﻿USE sofia;
DROP TABLE IF EXISTS sofia.sll_vpl;
CREATE TABLE sll_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sll_vpl WRITE;
INSERT INTO sll_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ebraham gang Debit momia. Debit gang Yisas Kraist momia. Te Yisas Kraist iwe, kwiang moya para muru haang bol enaminia, kere piro. ");
INSERT INTO sll_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Homa weni Ebraham momia. Mole gongure, Aisak aibing maulung sire momia. Mole gongure, Yekop aibing maulung sire momia. Mole gongure, Yuda ebiring hobo kina, aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Molere, Yuda al Tema ire, gir kul erere gongure, Peres Sara kina aibing maulung sire momia. Peres iwe, gir kul erere gongure, Hesron aibing maulung sire momia. Mole gongure, Ram aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Mole gongure, Aminadap aibing maulung sire, momia. Mole gongure, Nason aibing maulung sire, momia. Mole gongure, Salmon aibing maulung sire, momia. ");
INSERT INTO sll_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Molere, al Rehap ire kul erere gongure, Boas aibing maulung sire momia. Molere al Rut ire kul erere gongure, Obet aibing maulung sire, momia. Mole gongure, Yesi aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mole gongure yasingaba Debit aibing maulung sire momia. Molere Yuraia eungbi wou si ire, kul erere gongure, Solomon aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Mole gongure, Riaboam aibing maulung sire momia. Mole gongure, Abaisa aibing maulung sire momia. Mole gongure, Esa aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Mole gongure, Yihosapat momia. Mole gongure, Yoram aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Mole gongure, Asaia aibing maulung sire momia. Mole gongure, Yotam aibing maulung sire momia. Mole gongure, Ehas aibing maulung sire momia. Mole gongure, Hesekaia aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Mole gongure, Manasa aibing maulung sire momia. Mole gongure, Emos aibing maulung sire momia. Mole gongure, Yosaia aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mole gongure, Yekonaia ebering hobo kina, aibing maulung sire momia. Mongwo habang iwe, Isrel ari pi Bebilon ganba bani halabusi pangwi. ");
INSERT INTO sll_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pangwo wai sungure, Yekonaia gongure, Sialtiel aibing maulung sire momia. Mole gongure, Serebabel aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Mole gongure, Abayat aibing maulung sire momia. Mole gongure, Elayakim aibing maulung sire momia. Mole gongure, Eso aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Mole gongure, Sedok aibing maulung sire momia. Mole gongure, Ekim aibing maulung sire momia. Mole gongure, Elayat aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Mole gongure, Eliesa aibing maulung sire momia. Mole gongure, Matan aibing maulung sire momia. Mole gongure, Yekop aibing maulung sire momia. ");
INSERT INTO sll_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Mole gongure, Yosep aibing maulung sire momia. Yosep iwe, al Maria wiimbi momia. Te al Maria iwe, Yisas kul engwi. Kul engure, ari hobi singaba i haang Kraist engwi. ");
INSERT INTO sll_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Emia homa weni Ebraham mongwo bani gang ainere u tibi ongwiwe, guung ana holo holo kebena sui tai dire ongure, Debit emgi weni u tibi ongwi. Te Debit mongwo bani iwe, gang hon ainere malungwo guung i, ere ana holo holo kebena sui tai dire u tibi ongure, emgi Isrel ari pi Bebilon ganba halabusi pangwiwe, guung potin ongwi. Te Bebilon halabusi pangwo wai sungure, gang hon ainere male i ungwo guung i, ere ana holo holo kebena sui tai dire u tibi ongure, emgi weni singaba ta Kraist u tibi ongwo i, guung ere para potin ongwi. ");
INSERT INTO sll_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ena Yisas Kraist u tibi ongwiwe, maing yu pamia. Aang Maria amagir mongwo meri Yosep nu ke tongure, nin nin mongwi. Molere pana gale si daule wakima. Yu ongure ari hobi ama Maria hamba, God Kwiang gir Maria yong sina pire, mindebe ongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ena yal Yosep iwe, yal wai weni mongwi. Molere ama Maria gai maing i tibi ol tekiralua di pungwi. ");
INSERT INTO sll_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pirere kul si aidolala di pungwi. Pir mongure God ensel bai nu solungure, Yosep ul pangwo bani kuu ha di tongwi, “Yosep, Debit gang ye, ama Maria tal ongwo i nigi de pire aidolala di pirkio. Maria mindebe ongwo hangiwe, God Kwiang gir u tibi omia. ");
INSERT INTO sll_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mol i pire emgi wang kul nenamia. Kul nenangure, ni haang Yisas eyo. Enanga gir iwe, mol i pire bir dalere, emgi ari hobi tal nigi dongwo ol wangure God pring tongwo i, yal i irere yalhobi aki di tenamia. Yalhobi sigare kule u wai namua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dimia talhan u tibi ongwo hobi iwe, hana togu yalhobi God grang pirere homa awa ha yu di emiraya, omaga giu dire u tibi umia.");
INSERT INTO sll_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ama ta gir parere, wang kul enangwo, ari hobi haang Emanyuel enamia. Haang iwe, memini yu pamia, God nan yalhobi kina mol pai onaminua. ");
INSERT INTO sll_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ena Yosep kuu hanere, si pilo di aire, ensel dungwo meri wine olere, yu ongwi. Olere al Maria ire kene hane ol i wangwi. ");
INSERT INTO sll_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Warere heba bungwo i nekimba, Maria wang kul nongwi. Kul nongure Yosep haang Yisas engwi. ");
INSERT INTO sll_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ena Herot singaba king mongwo gin iwe, Yudia ganba sina i Betlehem oo malgi Maria Yisas kul nongwi. Kul nere mongure, ari mo ungwo holi ari wiyol ta nomani bir pangwo tau u Yerusalem malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dire yu sirin bol tongwi, “Gir ta u tibi pire Yuda ari singaba king monama dungwo i, malgi makena u tibi pire mome? Na yalhobi oona malgi molere, gir i kulmoma u tibi ungwo hanere, doling bole uminia. Makena pai mome? Pi hanere maa e tere, awai ol tenamna dire, uminua”. ");
INSERT INTO sll_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dungure Herot ha i pirere ganulun dungwi. Ganulun dungure, Yerusalem ari hobi para, ganulun dungwi. ");
INSERT INTO sll_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Direre Herot ha maing kene ongwo hobi te, God krehaman ha nir si tongwo yalhobi gala di ku bongwi. Bolere yu sirin bol tongwi, “Singaba ta Kraist oo malgi makena u tibi pire moma dime?” ");
INSERT INTO sll_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dungure yu ditongwi, “Yudia ganba Betlehem oo malgi u tibi pire moma dimua,” dungwi. “Hana togu yal homa awa ha mining yu bol emiraya,");
INSERT INTO sll_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yudia ganba Betlehem oo malgi yawe, ni Betlehem malgi i han ya ime sinangwo taman. Ni monga sina i, yasingaba ta u tibi pirere, Isrel ari para weni breng mining a holo sire kene ol tenamua.” ");
INSERT INTO sll_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ena Herot ha i pirere, ari kulmoma hane ungwo yalhobi kul si gala di ku bolere, yu sirin bol pungwi, “Kulmoma i, tal habang u tibi pire dome?” ");
INSERT INTO sll_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yu direre bai nu si Betlehem oo malgi olungwi. Olere yu ditongwi, “Ni Betlehem malgi pire gir i wa duyo. Wa dure monangwo hanangarai, ure na di na to. Na para pirere, maa e tere awai ol teralua.” ");
INSERT INTO sll_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dungwo pirere, yalhobi ere ongwi. Pirere kulmoma homa u tibi engwo hangwo i, hon u tibi ongwi. Pirere homa e tere pirere, gir pai mongwo oo bring bani derere, au di tongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Au di tongure, yalhobi hanere, gun ere doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pirere gir pai mongwo oo ala i ongwi. Pirere gir i aang kina mongwo hangwi. Hanere hoing baing sirere, maa e tongwi. Tere, gal a birere, gir i tobo ta terala dire, moni bir ta ire, paura kuning wai ungwo ta ire, wel sanda ta ire dire, gir i tongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tere pangure ginangwo God kuu ha yu ditongwi, “Ni yalhobi unga memini hol i siina dire, Herot mongwo bani hoyo,” ditongwi. Yu ditomia, yalhobi ere u kwaling ta pirere, nin oo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ena ere ongure God kwia ensel nu si olungure, Yosep kuu ha ditongwi, “Ni aire gir ya, aang para, aule ire, te ere pi Isip ganba monana po. Mol i nangere, na ha hon di ni teralga pinania. Herot gir i wa dure si golala dimia po,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ditongure girungwo Yosep gir aang para, aule ire Isip ongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pire mongure, Herot gongwi. Ena yu ongure homa hana togu yal ta God grang pirere, ha mining bol engwo nima namua, dimiraya. “Na wana Isip mongure, na gala diga umua.” ");
INSERT INTO sll_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ena ari kulmoma hanere, doling bol ungwo hobi ya singaba kera kul tere ere omia, Herot nigi weni de pungwi. Pirere ari tau bai nu si Betlehem oo malgi bina holo holi olungwi. Olemia yalhobi pirere, kumil migi tau me erin taniga te, sutani mongwo hobi wa dure, para si gol wai sungwi. Kulmoma hanere doling bol ungwo hobi Betlehem u tibi umua dimiraya, Betlehem gir para si gol wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Simia homa weni God ha dungwo hana togu yal Yeremaia di tibi olemiraya, kara nima ongwi.");
INSERT INTO sll_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama oo malgi aya maya dire, hai mere, gala dire, miling pire, al Resel gang hobi “Gir irai molkungwo yawe”, dinamia. Dinangure miling pir tenamba, al i pirkinamia. Gir i obilga dirane ta wiya homa. ");
INSERT INTO sll_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ena Herot gongure, God kwia ensel ta bai nu sungure, Yosep kuu ha hon ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ni aire gir ire, aang ire dire, ere Isrel ganba bani pire molo. Gir si golala di ongwo hobi irai, haya gol wai simua.” ");
INSERT INTO sll_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dungure Yosep gir ya, aang ya, para, aule irere, Isrel ganba pirere mongwi. ");
INSERT INTO sll_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mole pungure, “Akeleas irang Herot aibing maulung sirere, Yudia singaba momua,” dungwo pungwi. Pirere holi monamba, kul pungwi. Pimba, God Yosep kuu ha di tongwi, “Ni Galili ganba po. ");
INSERT INTO sll_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pirere Nasaret oo malgi molo.” Yu dungure Yosep pirere pi Nasaret mongwi. Homa hana togu yal Kraist unangwo pirere ha di engwiwe, kara nimaki namua dungwi. “Nasaret hong yal moma dinamua” dire mining yu bol emiraya. ");
INSERT INTO sll_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ena habang gin i Yon nir bil tongwo yal iwe, Yudia ganba sina i, ganba po engwo gul u pa dire, ha maing di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Olere, “God kene ol na tenangwo hol omaga u tibi umia, ni tal nigi dongwo ol wanga i nigi de pir tere, nomani si kulu sire hon olkirala di pire wayo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dimia, hana togu yal Aisaia homa ha di engwo meri irawe, Yon u tibi omia, Ganba po enangwo gul i, yal ta gala dire yu dinamia, yal ta hamen yasingaba momia unangwo hol bala di to. Ditere akun ol enangere, u wai nangure, yal i unamia. ");
INSERT INTO sll_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ena Yon kun hamel eme galsina warere, oni bani kun gang dongwi. Te homena nongwiwe, hau guamoro denboma niring kina obil nere mongwi. ");
INSERT INTO sll_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mongwo gin iwe, Yerusalem ari ungure, Yudia ari ungure, Yodan nir bina hol bani ari ungwi. ");
INSERT INTO sll_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Urere tal nigi dongwo ongwo maing di tibi olungure, Yon Yodan nulu molere, nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ena Perisi, te Sadyusi yalhobi nir bilala dire, u pa dungure, Yon hanere, yu ditongwi, “Ni hasu ari onba giri mongwo meri monia, emgi hon sinaa di mena pire, tal nigi dongwo onanga pamia. Pring pai ni tongwiwe, God ni sinamia, ti siina dinanga pamia ara di ni tongure une? ");
INSERT INTO sll_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ni yalhobi tal nigi dongwo ol wanga aidole nomani si kulu sire hon olkirala di pire monanga, miling i tibi olan mo? ");
INSERT INTO sll_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Olangarai olere, nomani yu si pinania, na Ebraham gang molia, God na sikinamua. Yu di pinba, God kwahulu i irere, Ebraham gang ol enangwo pamia. Ha weni kara dia. ");
INSERT INTO sll_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Di sire er dimani bani God homa nu ke engwiwe, nima pire ya di pamia, er miling holkinangwo hobi werere, endo ganangwo pamia. ");
INSERT INTO sll_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na nir bil ni tegiwe, arihobi nomani si kulu sire tal nigi dongwo hon olkirala di pinia hangure, bil ni teiwa. Te yal ta emgi na mobina holi unamia. Unangwo yal iwe, God Kwiang bai nu sinangure, ni yon wu binangure, endo gaun bani denama dire unamua. Unangwo yaliwe, singaba bir monangwo, na a ime ol teralga paikimia. Te na gal bala kine teralba, digan moliwa. ");
INSERT INTO sll_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Homena miling iwe, perere, iku bol ere, miling panangwo tali, kri di i pi oo ala i erere, te miling paikinangwo taliwe, kri di i pire endo dongwo bani ganangwo pamia. Ganangwo de wai ta sikinamua.” ");
INSERT INTO sll_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ena dungwo habang gin iwe, Yisas Galili molere, ere Yodan nulu ongwi. Pirere Yon nir bil na tenama dire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Omba, Yon Yisas manaa dire yu ditongwi, “Ni na nir bil na tenanga kunu panamia, te talongure ni nir bil ni terale?” ");
INSERT INTO sll_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dimba Yisas yu ditongwi, “Ite, God wine onama dire di na tongworai, homa e tere nir binaminga kunu pamia. Omaga ni nomani gogo sikio.” Yu dungure Yon, “Owa para dinua,” dire nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bil tongure Yisas nulu i aidolere, mena ungwi. Ungure hamen hona grang saang dungure, God Kwiang hahoba yumil mongwo meri molere, ya ime ure, Yisas breng bani amia hangwi. ");
INSERT INTO sll_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hangure hamen bani ha ta yu yaime ungwi, “Yal i na wana tani momia, milna ala pamia, wai pir teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ena God Kwiang Yisas aule ire ganba po engwo gul i ongwi. Ongwiwe, Seten ure, kraung sire, kera kul tenama dire, aule ongwi. Ongure Yisas homena nekirere, simo pare pare mongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mongwo hamen haung iwe, yal su kebering aling poti mongwi. Molere Yisas menan gobari gole mongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mongure Seten kera hong yal i mala ungwi. Urere yu ditongwi, “Ni God wang weni monanga, kwahulu mala i dingere, u homena nangwo nenaminba”. ");
INSERT INTO sll_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dungure, Yisas yu dungwi, “Ha mining ganing ta yu pamia, Ari homena tani pirere, molkun ta olekinaminua. God grang bani wine olere, ari molkun onaminua.” ");
INSERT INTO sll_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dungure kwia nigi dongwo singaba Yisas aule irere, ha maing bling mini oo bir bring bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pi molere, yu ditongwi, “Ni God wang kara weni monanga, iri so. Iri sinanga, ta bolkinania, ha mining ganing ta yu pamiraya, God kwia ensel hobi grang ha ditongwo pirere ni kene ol momia. Ure ni aki dinangwo hulu kebin ta bolkinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dungure Yisas Seten yu ditongwi, “I te, ha mining ta yu pamia, God kera kul tekio.” ");
INSERT INTO sll_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yu dungure Seten Yisas hon aule ire, hamen hul mini bani ongwi. Pi molere, ganba ganba ari tabin tabin te, talhan maing maing don miki weni i tibi olere, ");
INSERT INTO sll_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yisas yu ditongwi, “Ni ikwi bol na tere, maa e na tenanga, talhan hanga hobi para muru ni ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dimba Yisas Seten yu ditongwi, “Seten ni ere pa. Ha mining ta yu pamiraya, God tani weni maa e tenaminia. Terere honagi di na tongworai onaminga pamua.” ");
INSERT INTO sll_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yu dungure Seten Yisas aidolere, ere ongwi. Ongure kwia ensel tau urere, Yisas kene ol te mongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ena gin ta “Yon halabusi pamua” dungwo Yisas pirere, ere Galili ongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pirere Nasaret i holia olere, pi Kapaneam malgi ongwi. Malgi iwe, Galili nir digan bina Sebyulan Naptalai kunu holi mongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Momia homa God hana togu yal Aisaia awa ha di engwo nima namua dimiraya.");
INSERT INTO sll_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebyulan ganba, te Naptalai ganba homaulung nir bina ere u Yodan ongwo kuni yawe. Galili yamoni mongwo yalhobo, yal al ha maing nomani si pirkirere, si bongwo ala mongwo hobi gin ta ha maing pirere, u ari sungwo bani monamua. ");
INSERT INTO sll_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yal al si bongwo ali mol parere, gol wai sinamba, ari si yalhobi mongwo bani enangure, u wai namua. ");
INSERT INTO sll_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ena hongebe Kapaneam malgi, Yisas ha kebering holere nir si tongwi, “God kene ongwo maing omaga u tibi pi ni tomia, tal nigi dongwo ol wanga i nigi de pir tere, nomani si kulu sire, hon olkirala di pire wayo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ena Yisas Galili nir digan bina ware hangure, ebering su Saimon haang hon Pita engwo yaliwe, ebering Endru kina mongwo hangwi. Hangure pisi gal pia si nir ala olere, pisi si mongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mongure Yisas yu ditongwi, “Ni yasuri ure na dolna bolo. Bonanga, honagi tau nibil di ni tegere, pisi honagi nega dire onga meri na honagi nega dire ole ari tau i na tenanua.” ");
INSERT INTO sll_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yu dungure pisi gal gintani pisolere, Yisas kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Omia Yisas obilga wiyala pire hangure Sebedi wang Yems ebering Yon kina mongure hangwi. Yasuri sipi ala molere, irang kina pisi gal oulu dungwo guwa si mongure hangwi. Hanere Yisas yasuri gala dungwi. ");
INSERT INTO sll_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dungure yasuri sipi bani molere, irang Sebedi pisolere, ure Yisas kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Omia aule ire pirere, Galili ganba bina holo holi para wa pa di pisolungwi. Warere ha maing oo ala ari God kene ongwo hol u tibi ongwo ha maing i di tibi ol tongwi. Terere, nibil ole mongwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ol tongwiwe, Yisas guung haang Siria ganba ongure, ari hobi pirere, nu nibil ya, nebona maing maing kwia nigi dongwo yong sina mongwo hobi ire, omeling male yadani sungwo hobi aule ire ungure, awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ol tongure Galili ari ire, Dekapolis ari ire, Yerusalem ari ire, Yudia ari ire, Yodan hoibi hol bani iwo arihobi ire dire, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ena Yisas ari tabin bir weni hanere, ere pi hul ta pirere, ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mongure, gamahobo grang wine ongwo hobi u yobilungure, Yisas ha nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ena Yisas yu ditongwi, “Yal ta yal bina molia dire ya ime sire monangwo yal iwe, miling panamua. Panangure, God kene ongwo bani mol pai onamua. ");
INSERT INTO sll_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Te yal ta miling gul sinangure, hai me monangwo yal iwe, miling panamua. Panangure, God yong a ura ditenamua. ");
INSERT INTO sll_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Te yal ta ha ura panangwo dire monangwo yal iwe, miling panamua. Panangure, God ganba para muru tenangwo inamua. ");
INSERT INTO sll_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Te yal ta God ha maing honagi ol i pirere, mena gole nir gonangwo yal iwe, miling panamua. Panangure, God hon aine tenangure, inangwo kunu benamua. ");
INSERT INTO sll_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Te yal ta aki di tere awai ol tere, miling pir tenangwo yal iwe, miling panamua. Panangure, God ereyu yal i aki di tere awai ol tere miling pir tenamua. ");
INSERT INTO sll_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Te yal ta nomani sina i pege au kula pari wai dinangwo yal iwe, miling panamua. Panangwo yal iwe, moli pirere, God i tibi ole hanamua. ");
INSERT INTO sll_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Te yal ta ha ura pangwo dire kuku anangwo yal iwe, miling panamua. Panangure, God hanere, “Wana auna ye” ditenamua. ");
INSERT INTO sll_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Te yal ta God ha maing honagi ol i pirere, halabusi panangwo te, ari ol gogo dal tenangwo yal iwe, miling panamua. Panangure, God kene ongwo bani mol pai onamua. ");
INSERT INTO sll_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na na tege erere, dolna bonangiwe, yal tau ni hanere, gaun ha sirere, ol gogo dal ni terere, ni sinangwiwe, miling panania. ");
INSERT INTO sll_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wai weni pire molere, emgi tobo hamen bani inanua. Te arihobi God hana togu yal homa ereyu ol tomua. ");
INSERT INTO sll_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ena homena pil bemia hano. Pil dungwo meri iwe, ni yalhobi monia. Te homena dungwo meri iwe, ari ha maing pirkungwo hobi momua. Ena pil gwiring mena pi wai sinangure, ire tal omingere gwiring hon moname? I ta molkinama. Yu onangwo pil iwe, pia si manbi olere, ganba kina egiranua. ");
INSERT INTO sll_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ena ari dere maganba bani para au di peira simia hano. Ari dongwo meri iwe, ni yalhobi monia. Te maganba dungwo meri iwe, ari ha maing pirkungwo hobi momua. Te oo malgi bir weni ta hamen hul mini bani dinamia. Kul si dinangure, ari hobi hankinamo? Para hanamia. ");
INSERT INTO sll_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te ari kewa galere, mulu ali kul si enamo? I ta ekinama. Bol bani enangure, dere kurani sinangwo ari oo ala monangwo hobi, grang gumang ogolo han pa dinamua. ");
INSERT INTO sll_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kewa dongwo meri iwe, ni yalhobi monania. Te si bongwo meri iwe, ari ha maing pirkungwo hobi monamua. Ni ha maing pir sina ere tal dime dire ol i nangiwe, ari ha maing pirkungwo hobi au di tenania, arihobi hanere, Hamen Nabe maa e tere pir hobo kul tenamua. ");
INSERT INTO sll_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ni yalhobi na molga maing nomani si pinga talwa di pine? God krehaman ha di taning engwo te, hana togu yalhobi ha dungwo, si ime olala dire, u pa dikia. God krehaman ha wine olkio ditekiwa. Na ha maing bling memini weni di tibi olala dire u pa diiwa. ");
INSERT INTO sll_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ni piro. Hamen ganba ya dinangwo meri God Lo krehaman ha para ya dinamua. Te mining obil weni taga i bangi ta olekinanua. ");
INSERT INTO sll_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ena yal ta Lo krehaman mining obil weni taga i bangi olere, yal tau ereyu onama dire nir si tenamua. Tenangwo yal iwe, God grang wine ongwo hobi mongwo sina i, haang obil weniga panamua. Te yal ta God krehaman ha wine olere, yal tau ereyu onama dire nir si tenamua. Tenangwo yal iwe, God grang wine ongwo hobi mongwo sina i, haang bir weni panamua. ");
INSERT INTO sll_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Panangwo i pirere, di ni teralia piro. Lo krehaman ha nir si tongwo yalhobi ire, Perisi yalhobi ire dire, God krehaman ha wine olere, honagi ongwo haniba, ni yalhobi amane mole tal dime dire yulang ki bole olkinangiwe, God grang wine ongwo hobi mongwo sina i ta honanua. ");
INSERT INTO sll_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ena homa ni yalhobi kwian moiya krehaman ha para pinua. Ari si golkio, dungwo piniraya. Yal ta ari si gonanga yal iwe, ha hol boling bani nana dimirawa. ");
INSERT INTO sll_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dimba na iwe, di ni teralia piro. Yal ta ebering nigi de hanere, yong ki e tenangwo yal i, ha hol inama di piriwa. Te yal ta ebering ha yong i tenangwo yal iwe, kaunsil hobi ku bolere, ha hol bir ol tenama, di piriwa. Te yal ta molere yong ki ere ‘Ni du dinua’ di tenangwo yal iwe, endo de pangwo bani nama di piriwa. ");
INSERT INTO sll_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Te pring tobo ire ha maing oo ala bol kul engwo bani monania. Mole yu nomani si pinangarai, O, na yahuna kina yona ki ere mobiliraya. ");
INSERT INTO sll_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yu di pinangiwe, malgi pire ebin kina ha di wai sire, siina di unangarai, prin tobo i God tenanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ena yal ta ha hol ol ni tenamia. Ol ni tenangwo yal iwe, hol bangi u kel dinangworai gintani ha wai panangwo di to. Dikinanga yal i ni aule i pire Yas ha hol pungwo yal mongwo aling bani enamia. Enangure yal i ni aule i pire plisman tenamia. ");
INSERT INTO sll_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tenangure yal i ni aule i pire ni halabusi sinamia. Yu onangwo pangwo ipire ni yal ta taling nenanga prin panangwo iwe, ni mong yu ol tenanga pamua. Na ha weni di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ena kwiana moiya ha yu di na tomia, “Ni wiing eung irere, pisole al ta wou sire olkio.” ");
INSERT INTO sll_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dimba, na iwe, omaga di ni teralia piro. Yal ta al ta hanere, ebil dimo nenangwiwe, nin eumbi aidolere, nomani sina i haya pi al i wou sima di piriwa. ");
INSERT INTO sll_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Te omin weni hol iwe, talime tal nigi dongwo olere, pring oun dongwo i ni terala di onangure, sigi di olo. Omin ya dinangwo mol i pirere nigi derere, emgi endo de pangwo bani nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te, ani weni hol i, talime tal nigi dongwo olere, pring oun dongwo i ni terala di onangure, ani di keuru si olo. Ani ya dinangwo meri mol i pirere nigi dere endo de pangwo bani nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ena ha ta yu di engwo piniraya. Yal ta eumbi aidolala di pinangwiwe, pepa bole aling wa ere nu si olamia. ");
INSERT INTO sll_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Olamiba, na di ni teralia piro. Al i kuni ire wou sire ta olkinamba, “ere po”, di tenangwiwe, al i pi yal ta gal ere monamua. Monangwiwe, wou sinamia. Te sire monangwo pring iwe, wiimbi homa i inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ena kwiana moiya ha ta homa yu di engwo piniraya. Ni God maulung bani ha di tibi olangiwe, nima namia emgi hon hasu di kul sikio. God maulung bani di yulang bongiwe, para bonia, dinga meri wine ongere nima namua. ");
INSERT INTO sll_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yu dimba te, na iwe, di ni teralia piro. Ni yalhobi God maulung bani pirere, ha di erin bominua dingiwe, para pisolo. Te hamen bani hanere ha di erin bominua di pingiwe, pisolo. ");
INSERT INTO sll_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hamen bani iwe, God nin kene ole, mol pai ongwo dimia. Te ganba hanere ha di erin bominua dingiwe, ere para pisolo. Ganba i, God kebering egere gi dungwo dimia. Te Yerusalem malgi wa di hanere, di erin bominua dingiwe, ere para pisolo. Yerusalem iwe, yasingaba king nin kene ol momia. ");
INSERT INTO sll_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Te ni nin ha di bini hul ere di yulang bominua dingiwe, ere para pisolo. Bini eme hama sungwiwe, talta ol hangere, hon toba sinamo? Ta sikinama. ");
INSERT INTO sll_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni yalhobi ha pangwo meri dinangiwe, wai panamua. I dikire pia si albe ole boling bani dinangiwe, nigi denamua. ");
INSERT INTO sll_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Te ha ta kwian moiya hobi homa di ni tongwo piniraya. Yal ta omin si gi dinangwiwe, omeling mong si gi do. Te yal ta sigin si piu dinangwiwe, siging mong si piu do. ");
INSERT INTO sll_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yu dimba te, na iwe, omaga di ni terala piro. Yal ta tal nigi dongwo ol ni tenangwiwe, ni mong ol tekio. Yal ta pauni bani didagi ni sinangwiwe, pauni hol bani ma di to. ");
INSERT INTO sll_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te yal ta ni ha hol ol ni tere galsina inangwiwe, galsina ta dinangwo para te uning si olo. ");
INSERT INTO sll_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te plisman bona gana ire hol goptani dungwo holi nabilua dinangworai, ni hon aule ire, gobari dinangwo hol i po. ");
INSERT INTO sll_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te yal ta talhan ta na to, dire, hong dinangworai mining bole to. Te yal ta talhan ta na to. Na nere emgi ere malgi uralga, hon ni te aibing olalua dinangworai mining bole to. ");
INSERT INTO sll_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ena homa kwian moiya ha ta yu di engwo piniraya. Ni yalhobi ari mala monangwo hobi yon milni para to. Tere te, kiani yalhobi nigi de pir to. ");
INSERT INTO sll_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yu dimba te, na omaga, yu di ni teralia piro. Kiani pai tere monanga yalhobi iwe, yon milni para to. Tere tal gogo ol ni tenangwo yalhobi God yalhobi aki di to dire sirin bol tenanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yu onangiwe, Hamen Nabe wang aung weni monanua. Ari de ime ol na tongwiwe, yal wai digan mongwo bani para de na tomua. Te nimin, si ime na tongwiwe, si yal wai mongwo bani ere, yal digan mongwo bani ere dimua. ");
INSERT INTO sll_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni nin enin tau hobi obil yon milni tere awai ol tenangiwe, God tobo ni tenam mo? I ta ni tekinama. Te moni takis ingwo yalhobi iwe, ere para yu onamua. ");
INSERT INTO sll_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te ni enin tau hobi obil ha wai ol tenangiwe, kunu panamo? I ta paikinama. Hana ya moni mongwo yalhobi ere para yu onamia. ");
INSERT INTO sll_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yu olere, ni yalhobi Hamen Nabe amane mongwo meri monanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ena ni yalhobi ha maing honagi ol warere, ari na hanama hanama di pire nin gaun pir yuwo ere wakio. Pir yuwo ere wanangiwe, Nabin hamen bani mongwi tobo ta ni tekinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te ni ari tau awai ol tenangiwe, yal tau na hanama hanama di pire nin gaun pir yuwo ere nugun bol tekio. Nugun bol tenangiwe, nugun bol tere ari hobi wine onama dire nin wine olkungwo hobi ha maing oo ala te hol bangi ongwo tali onanua. Yalhobiwe, ha maing honagi olere tal dime dire olalga ari na hanere hana a yuwo olama di pire, hol bangi yu ol wanangwo hananua. Hananiba, yu onangwo yalhobiwe, ganba baniya hang awala gangwo i tobo haya i pisolamua. Na ha weni kara di ni teiya. ");
INSERT INTO sll_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Te yal bina ta monangwo hanere, miling pirere, moni ya, talhan tau i pire kul si te olo. ");
INSERT INTO sll_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Olanga, ni awai ol tengiwe, memini kul si ali pamia. Te Nabin hamen bani mongwiwe, talhan kul si onangi han pa dungwo hong yal momia, hanere tobo ni tenangwo inanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ena ni yalhobi God kina hawai olala di pinangiwe, hasu ari ongwo meri olkio. Yalhobiwe, ha maing oo ala i God ha ditere, homaulung bangi God ha di terere, yu olgere ari para weni na hanama hanama di pirere, nin gaung pir yuwo ere tal yu ol wamua. Wamiba ganba baniya hang awala gangwo i tobo para i pisolimua. Na ha weni kara di ni teiya. ");
INSERT INTO sll_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te ni yalhobi God kina hawai olala di pinangiwe, God kina hawai ol tere tere onanga oo ala i pire onanga pamua. Kul si mole onangiwe, hamen Nabin gumang hankinga yali ni haya hamua. Hanere tobo ni tenangwo inanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ena God ha di tenangiwe, gobari weni ditekio. Gobari weni ditenangiwe, ari hana ya mongwo hobi bring mini oo pire, bring mini hole tal ongwo meri onanga pamia. Yu onanga kunu panamo? I ta paikinama. Bring mini oo tal ongwo hobi iwe, ha miki weni dire tal olgi, God pir na tenama di pimua. Pimba, God yalhobi pir tekima. ");
INSERT INTO sll_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni yalhobi tal ongwo meri olkio. Nabe hamen bani mongwiwe, homena han ta wai sinangwo ma dinangwo i nerale, di pinangiwe, God homa hanangwo ni emgi hanere, God ha ditenanua. ");
INSERT INTO sll_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Di tenangiwe, yu dinania. Nabe, hamen bani monia ni hani awala gale maa e ni te i omo.");
INSERT INTO sll_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ni ure, yona sina te, ganba sina ya, kene ole kwi mol na to. Hamen bani ni gran wine ole momia, te ganba bani na yalhobi mominga bani ereyu wine ole moli namna.");
INSERT INTO sll_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kenba homena kunung benangwo meri na to.");
INSERT INTO sll_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yal ta tal nigi dongwo ol na tongwo pring i ole tominga meri na tal nigi dongwo ominga prina i ole na to.");
INSERT INTO sll_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kuni kura talime oun denangwo bani na aule i pi olekio. Kwia nigi dongwo Seten krauna sire kera kul na tenamia ni ure kuman kine na to. ");
INSERT INTO sll_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Te ari tau tal nigi dongwo ol ni tenangure pring panangwo i kri di olanga meri iwe, Nabin hamen bani mongwi tal nigi dongwo onga prin ereyu kri di ole ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te ari tau tal nigi dongwo ol ni tenangure pring panangwo i kri di ole tekinanga, God ni tal nigi dongwo ol wanga prin ere kri di ole ni tekinamua. ");
INSERT INTO sll_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ena gin ta homena mai tere monangiwe, kuru dungwo ari homena mai tere mole onangwo meri olkio. Kuru dungwo yaliwe, mai te mole yu onangure, ari hanere, O yali homena mai tongwo pamua, di hanama dire gumang megine monamia. Molere ganba baniya hang awala ganangwo i tobo haya inamua. ");
INSERT INTO sll_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na ha weni kara di ni teiya. Te, ni yalhobi God pir tere, homena mai tere monangiwe, gaun bigi sire guman nimni monangure kir wa ha dire molo. ");
INSERT INTO sll_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yu onangiwe, ari hobi homena mai tere monia di hankinama, God nin ni hanamia. Hanere tobo wai ni tenangwo inanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Te ni yalhobi ganba baniya, tal wai dinangwo nomani tere bona si wakio. Bona si wananga, simin malangure, ari kuni nenangwo pamia. ");
INSERT INTO sll_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","I nomani si pirere, hamen bani tal wai dinangwo bona si ere a i si wayo. Hamen bani iwe, simin ta malkinamio, te ari ta kuni nekinangwo pamia. ");
INSERT INTO sll_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bona si ere a i si wanangiwe, tal wai dungwo bani muru dinamia, nomani kwian para te bani olanua. ");
INSERT INTO sll_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ena kewa dere au dimia hano. Kewa dere au dungwo meri iwe, ni omin pine di hania. Omin au dinangwo irawe, nomani gaun i para au dinangwo hol hankun ole wananga pamia. ");
INSERT INTO sll_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te omin si bonangwo irawe, nomani gaun i para si bonangwo hol wakinanga pamua. Te ni kwian si bongwo ala i ya mol panangwo, mol pai oli nanga, yo tekinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ena ari singaba sutani monamia. Monangure honagi yal taniga molere, yasuri i mu dire honagi ol tenangwo kunu panamo? I ta paikinama. Yu onangwiwe, honagi yal i yal ta i honagi ol teral mo? yal ta i honagi ol teral mo? dire nomani susu sinamua. Sirewe, ta i nigi de pir tere pisolere, taniga honagi ol tenamua. Te moni honagi iwe, para weni ol i nanga pamba, nomani kwian sina iwe, God tani tegi dinanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ena ni yalhobi mol pai onanga maing di ni tominia piro. Homena ma dinangwo nerale? Nir ma dinangwo nerale? Gal kul ma dinangwo irale? yu dire kraun aulekio. Te homena nenangiwe, wai panamba te, hon monangiwe, wai weni panamia. Te galsina wai dinangwo wanangiwe, para wai pamba te, gaun wigi sire wai dinangwiwe, wai weni panamia. ");
INSERT INTO sll_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Te ni yalhobi hahoba wangwiwe, maing para hania. Homena yare bule yu ala ere nom mo? I ta nekima. Nabe hamen bani mongwiwe, hahoba kene ol tere, homena nin tongwo nomia. Te hahoba talwo i kene ol tomba, te ni arihobi nomani bolo ni ol emia ni kene wai weni ol ni tomua. ");
INSERT INTO sll_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Te omaga golal mo? emgi golal mo? dire nomani si gogo dalkio. Nomani si gogo dale moli nangiwe, emgi weni golalua di pinangi kunu panamo? I ta paikinama. Gonanga haung nin ta pirkinia, nomani gogo sikio. ");
INSERT INTO sll_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ena emgi galsina wanamin mo, ya monamin mo dire, nomani si gogo dalkio. Er kuung sungwo para hania. Sungwo ering bani iwe, galsina ta sibire ware, kebering gal wam mo? I ta wakima. ");
INSERT INTO sll_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iwe, singaba Solomon galsina wai anere wamba, er kuung sungwo i, wai weni dimia. ");
INSERT INTO sll_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Er kuung iwe, God ol emia. Ol engwo kuung sungwo kenba haniba, ongi hama sire uli di yanangwo ganba dal i namua. God er yung kene ol momia, ni para ni kene ol molkinamo? Monamia. Galsina ya, talhan hobi para ni tenamia. Ni ogolo nomani si pir kun olekino? ");
INSERT INTO sll_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Homena ma dinangwo nerale? Nir ma dinangwo nerale? ");
INSERT INTO sll_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Galsina ma dinangwo irale? yu di pirkio. Ari wiyol ha maing pirkungwo hobi iwe, nomani yu si pire talhan i wa dunamia. God nomani paikimo? Nomani bir pamia, talhan tau irere, gaun dirin dinangwo monangiwe, God nin pirere, aki di ni tenamia. Ni tenangwo ipire, ni pir gogo dalkio. ");
INSERT INTO sll_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Homa God grang wine olere, a i si wanangiwe, tal tau i tibi ol ni tenangwo inanga pamia. ");
INSERT INTO sll_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ni yalhobi ongi mol pai ol i nanga tal olale? dire, pir gogo dalkio.Pir gogo danangiwe, gul nin mobin hol i dimia emgi u guman holi unangwo hananua. Hamen haung haung honagi ol i nanga meri gaun gul inanga nomani si pirkio. ");
INSERT INTO sll_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ena ni yalhobi ari tau hanere, nigi de pir tere isime e tekio. Isime e tenanga meri iwe, God hon siina dire yu ol ni tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Te arihobi tal ol tenanga meri iwe, God ere siina dire yu ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Ni omin bani er dulung bir ta dungwo i pia si kul si olere, enin ta omeling bani molo dungwo i talongwo i tibi ol tene? Er dulung bir omin bani si pera di dungwi, omin gi dinamia, i ole teralga kunu paikinamua di pirkino? Ni yahunanin ta omeling molo dimua dingiwe, ni hasu dinia, ni nin omin bani palan dulung bir ta si pera di dungwo i, homa i olekino? Yu olere, ebin molo dinangwo emgi i ole tenanga pamia. Homa ni nin isime enangiwe, emgi enin tau hobi para isime e tenanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ena God ha maing iwe, i pi awi di tenangi gau di ni tere ni sinamua. Te kun tenangiwe, i pi kun emin sungwo ali olamua. ");
INSERT INTO sll_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ena tal ta irala dire God sirin bol pinangiwe, ni tenangwo inanua. Te wa dunanga tal iwe, ere i tibi ole ni tenangwo inanua. Te hona grang hoiri yole ere monangwiwe, gala dinanga God yaule ni tenangwo ala nanua. ");
INSERT INTO sll_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ena ari hobi tal ta na tenama dire sirin bonangwo taliwe, tenangwo, inamua. Te wa dunangwo taliwe, ere i tibi olamua. Te gala dinangwiwe, God hoiri yaule tenamua. ");
INSERT INTO sll_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ena ni yalhobi monga bani iwe, wani ta heba golia dinangwo kwahulu wo i tenanga wai panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te pisi nir hau golia dinangwo onba degirime si tenanga kunu panam mo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ni yalhobi digan moniba, te wani hobi tal yu wenin ta ol tekinia tal wai moni ol tenua. Ol tenga meri iwe, hamen Nabe ditenanga para weni ni te uning sinamua. ");
INSERT INTO sll_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ari hobi tal wai ol na tenama di pinanga meri iwe, ni ere ari hobi yu ol tenanua. Iwe, lo ana holo holo hana togu yal para weni dungwiwe, na grana para u tani omua. ");
INSERT INTO sll_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ni yalhobi iwe, hona grang migiga dungwo holi po. Honanga hogal ai endo de pangwo bani hona grang bir weni au dire dimia, nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pangwo ipire ari miki weni hona grang bir weni dungwo hol i doling bomua. Bomba, u wai pire mol panangwo bani panangwo hol iwe, oun domia, ari tan tani wa du hanere, doling bonamua. ");
INSERT INTO sll_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ena ha maing hasu di wangwo tisa hobi iwe, unangwo pir tekirala dire kwi han molo. Yalhobi gaung maini wai moma di hananba, emgi gaung ala i han pa dinanua. ");
INSERT INTO sll_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Emgi tal gogo onangwo kara han po sire digan mongwo pamia di hananua. Er digan dungwo bani iwe, amil sinam mo? I ta sikinama. ");
INSERT INTO sll_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te kewa bongwo bani iwe, paba ta sinam mo? I ta sikinama. Er wai dungwo bani iwe, miling wai hongure, nenua. Nenba, er nigi dongwo bani iwe, miling digan hongure, ta pe nekinua. ");
INSERT INTO sll_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Er wai dungwo bani iwe, miling digan honam mo? Te, er nigi dongwo bani iwe, miling wai honam mo? I ta holkinama. ");
INSERT INTO sll_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Er ta miling wai holkinangwo iwe, werere, endo ganangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ni yalhobi nomani sina pamia, ha maing hasu di wangwo tisa hobi iwe, tal gogo ol wanangwo nin han po sinanua. ");
INSERT INTO sll_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yal Yisas ye, Yisas ye, yu di na tongwo yalhobi tau God kene ongwo bani ta honamua. Te hamen Nabe haang pirere, wine ongwo yalhobi obil nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ari para muru God maulung bani pirere, ha hol bir weni pinamua. Pirere, “Yal Yisas ye, Yisas ye, na yalhobi ni hani pirere, gran wine olere, arihobi ha maing nir si tomingiawe. Ni hani pirere kwia nigi dongwo si hobale olimingiawe. Ni hani pirere arihobi tal gumang hon dongwo i tibi ol tomingiwe,” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dinangure “Ni yalhobi na guman ta hankigarawa, na bal na terala di dinia, digan monia ere pio,” diteralua. ");
INSERT INTO sll_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ena yal tau na guna hana pirere wine onangwo yalhobi nomani bir panangure monamua. Molere, yal ta oo hamen hul ke pare mongwo meri yu monamua. ");
INSERT INTO sll_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nimin bir weni sire, nir sire, hamen hair mu dinba olere, oo i i manbi olala di onangure, ta yakinamua. Oo iwe, hamen hul mini bani nona pare mama dinamua. ");
INSERT INTO sll_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ena yal tau na guna hana pirere, pisolangwo yal iwe, nomani bir paikinangure monamua. Molere, yal ta oo maker bani kengwo meri monamua. ");
INSERT INTO sll_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nimin bir weni sirere, hamen hair mu dinba olere, oo i i manbi olangure yanamua. Yarere u susu namua.” ");
INSERT INTO sll_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ena Yisas ha yu di wai sungure arihobi ha maing dungwo i nomani si pire wai pire mongwi. ");
INSERT INTO sll_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yisas iwe, lo ana holo holo kene ongwo yalhobi ha ditongwo meri ditekima. God yulang tongure ire ha maing ditomia, arihobi pire bukunungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisas hamen hul mini bani molere, ya ime ungure, ari miki weni doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ongure yal ta hakubi dongwo Yisas mongwo bani u pa dire, ikwi bole yu ditongwi, “Yal Yisas ye, ni nebona i kri di olala di pinanga, i ole na to.” ");
INSERT INTO sll_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dungure Yisas aling sine dire, gaung bani arere, yu ditongwi, “Na kri di ole ni teralga u wai nana di piria, gaun wigi sinangure ya molo.” Dungure nebona i gintani wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wai sungure, Yisas nebona dongwo yali kraung are yu di tongwi, “Piro. Ni awai ol ni tegi ari ta hawai ol tekio. Tekirere, gaun i ha maing oo singaba nibil di tengere, hanamia. Hanangure Moses grang wine olere, homena si gal tengere, gaun wigi sungwo i ari para han po sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ena, Yisas Kapaneam oo malgi ongwi. Ongure yol Roman soldia kene ongwo yal ta, Yisas mongwo bani u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Dire sirin bol tere yu ditongwi, “Yal Yisas ye, na honagi yal ta gaung gul bir weni ol tongure nimni molkimia, du dale malgi pai momua.” ");
INSERT INTO sll_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dungure Yisas yu ditongwi, “Na omaga urere, awai ol teralua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dimba, soldia molere, “A. Yal Yisas ye, na digan molia oona malgi huyo. Timiya molere, dingere, honagi yal i u wai namba? ");
INSERT INTO sll_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na sina weni molia, yal bir hobi na na kene omba, te na mol kebena ala olungwo hobi kene oliwa. Olere yal ta po diralga namua. Te yal ta wo diralga unamua. Te honagi yal yu olo diralga, onamua.” ");
INSERT INTO sll_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dungure Yisas pire ganulun dire mobing hol ungwo hobi yu ditongwi, “Yol Roman yal iwe, God ogolo nomani si pir te momba, Isrel ari hobi iwe, pir tongwo meri ta tekimua. ");
INSERT INTO sll_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yu omiba ni piro. Ari ungwo te, ya bengwo holi ari wiyol miki weni God kene ongwo bani namua. Kwiana moya Ebraham ire, Aisak ire, Yekop ire, yalhobi kina hamen bani monamua. ");
INSERT INTO sll_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Te Isrel ari tau hamen bani namba, God pia si, si bongwo ali olamua. Olangure, hai mere, siging girimil nure, anini sire monamua.” ");
INSERT INTO sll_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yu di te pisolere, Yisas soldia yu ditongwi, “Ni honagi yal na onangwo u wai nama di pingiwe, haya u wai namia, ere malgi po.” Yu dungure nibil ongwo yal i gintani u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ena Yisas Pita oo kepangwo ala i ongwi. Pirere, Pita wumbi nibil olere, gaung nega dungure, bol bani pai mongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hanere aling bani angure, nibil i wai simia, aire Yisas homena ke te mongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ena hamen pudungure, kwia nigi dongwo yong sina mongwo hobi aule ire, Yisas mongwo bani u pa dungwi. U pa dungure, Yisas kwia ha taniga ditere, si hobale olungwi. Olere nibil pangwo hobi awai ol tomia, nibil wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Homa God hana togu yal Aisaia molere, “Yal ta unangwo yal iwe, na nibil nebona para kri di ole na tenamua,” di emiraya, omaga nima omue. ");
INSERT INTO sll_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ena ari miki weni u ku bolere, Yisas yobile sina olimia hanere, gamahobo yu ditongwi, “Nan nir bina hoibi namna pano.” ");
INSERT INTO sll_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yu dimba, lo ana holo holo kene ongwo tisa ta, Yisas mongwo bani pirere, yu ditongwi, “Tisao. Ni u banta banta nala dinanga holi, na ni dolni bolalgiwe.” ");
INSERT INTO sll_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dungure Yisas yali yu ditongwi, “Dua hau hobi oong nin nin ere pamio, te hahoba hobi ereyu oong ere pamio, te na Ari Wang Weni molere, oo ai ya, te bona gana timiya ta dikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ena grang wine ongwo yal ta aire yu ditongwi, “Yal Yisas ye, ni na nusolingere, nabe gonangwo homa man wu erere, emgi ure ni ni dolni bolalba?” ");
INSERT INTO sll_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dungure Yisas yu ditongwi, “Gonangwo yal i nin man wu ere gonamia, ni ure na dolna bolo.” ");
INSERT INTO sll_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ena Yisas grang wine ongwo hobi kina sipi ala pirere, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ongure hamen hair bir mudinba olere, nir hone pera kulere, sipi i manala olangwo pangwi. Pamba Yisas ul pai mongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mongure, grang wine ongwo hobi ganulun dire a ho tere uling yurere yu ditongwi, “Nan gonamga pamia aki di na to.” ");
INSERT INTO sll_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dungure Yisas, “Na momia di pir na tekino?” Dire, aire, “Nir ya hamen hair olkio” dire, hobang si tomia wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wai sungure grang wine ongwo hobi hanere, “Ayo” dire, grang dalungure, “Hamen hair ya, nir hobang si tongworai grang wine omia, yal i ari mom mo, tal mome?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ena yalhobi nir bare iri si hoibi pire Gadara ganba pi pa dungwi. Pa dungure yasu kwia nigi dongwo yong sina momia ungwi. Ungwo yal iwe, ari yulagi engwo hulu grang ala i pai momia, ari kul pirere, hol i gogo ta wakima. ");
INSERT INTO sll_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ena yasuri gala bir dire yu dungwi, “Ni God wang weni irawe, na nan hana pamia ni hani pamo? Na gauna gul i na tenanga habang olo mala humia, tal ol na tenane?” ");
INSERT INTO sll_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yu dire hangure, kul airing gul banta kun miki weni emin ne momia, hangwi. ");
INSERT INTO sll_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hanere Yisas sirin bol tere yu ditongwi, “Na hobale olanga, kun yong sina i naminba?” ");
INSERT INTO sll_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dungure Yisas “Para po”, ditongwi. Ditomia kwia kun yong sina i ongure kun hobi daang nulu di yaime pire daang boi dire nir sagu dire gol wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Simiawe, ena kun kene ongwo yalhobi te pirere, oo malgi pi pa dire, kun kwia kina tal ongwo ha i ari hobi para weni boling kul tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tomia ari miki weni Yisas monangwo harala dire kri di ungwi. Urere, tal ongwo i hanere kul pire, “Yal Yisas ye, ni banta nanba?” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ena Yisas pi sipi ala molere, nir digan bani ti hon pirere, iri si hoibi ure, yali nin oong malgi u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","U pa dungure yal ta nibil ole, kebering aling meginungwo aule ire, Yisas mongwo bani ungwi. Ungure Yisas au si ungwo yalhobi God onangwo pamia di pir tongwo maing hanere, nibil ongwo yal i yu di tongwi, “Gir wai ye, kulna pirkio. Ni tal nigi dongwo ol wanga God prin ni tongwiwe, haya kri di ole ni tomua.” ");
INSERT INTO sll_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yu dungure Lo krehaman ha tisa tau nin diriala olere, “Ayo. Yal i God gaung ha si tomia hano.” ");
INSERT INTO sll_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dungure Yisas yalhobi ha nomani si pungwo i yong sina i haya han pa dungwi. Dire yu ditongwi, “Talongure ha gogo dire nomani si mone? ");
INSERT INTO sll_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni nomani si pinga tal ha oun dome? Tal nigi dongwo ol wanga God prin ni tongwo i kri di ole ni tomua, ditega, kulang pam mo? Te, aire ere malgi po ditega, kulang pame? Aire ere malgi po diteralga kulang panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Te na Ari Wang weni molia. Molere God yulang na tongure, ganba bani ari tal nigi dongwo ongure God pring tongwo i kri di olalga han pa dinanua.” ");
INSERT INTO sll_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yu direre, nibil ongwo yal i yu di tongwi, “Aire, er kwiba ire, ere malgi po”. Yu dungure nibil pangwo yal i aire er kwiba ire, ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Omia arihobi tal ongwo i hanere, miling si giri golere mongwi. Molere God ari yulang tomia, wai pire God haang a yuwo olere mongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ena Yisas ere pirere, takisi ingwo yal na hana, Matyu, takisi iga ala ami di molga hangwi. Hanere yu di na tongwi, “Ni urere, na hana wine olere, na dolna bolo.” Yu dungure na aire, Yisas doling bol ogi. ");
INSERT INTO sll_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ena gin ta na oo kepaga ala Yisas homena ne mongwi. Ne mongure, takisi ingwo yal miki ire dire, ha maing pirkungwo ari miki ire dire, urere, Yisas grang wine ongwo hobi kina, homena para tani ne momgi. ");
INSERT INTO sll_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yu ominia Perisi yal tau hanere, Yisas grang wine ongwo hobi yu ditongwi, “Takisi ingwo yal ire, hana yal ire dire, Yisas kina ereho mole, homena ne momia, talongwo nome?” ");
INSERT INTO sll_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yu dungure Yisas pungwi. Pirere yu ditongwi, “Dokta iwe, ari yamoni mongwo i gaung bani honagi ta ol tekimia, nibil pangwo yalhobi honagi ol tomua. ");
INSERT INTO sll_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ha maing buku God yu di emiraya, Na homena si gal na tenanga taman. Awai honagi habang habang ol na tenangi wai pinaminua. Yu di engworai kere memini pir pa dinana pio. Na iwe, ari tibi mongwo hobi i ku bolalga, taman. Ari ha maing pirkungwo hobi i ku bolala dire yaime wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Habang ta Yon, nir bil tongwo yali, grang wine ongwo hobi tau Yisas mongwo bani u pa dire yu sirin bol tongwi, “Na yalhobi Perisi yalhobi kina haung ta homena mai tere mominia, ni gran wine ongwo hobi homena mai tekirere, talongure gogo nome?” ");
INSERT INTO sll_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dungure Yisas yu ditongwi, “Al hon inangwo yali gamahobo kina ereho monangure, homena mai tere gumang yaure monam mo? I ta molkinama. Al inangwo yali aule ire, ere banta nangure, gamahobo miling gul sinangure, homena mai tere monamua.” ");
INSERT INTO sll_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Te ari gal goling bali sinangwo bani gal hon bol ere sibirangwo kunu paikinama. Sibirangwo iwe, hon ere bali bir sinamia. ");
INSERT INTO sll_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te ari nir wain hon holere, meme gang mugu goling ali garu dikinamia. Garu dinangure, miing ure, meme gang mugu i si gala dire, nir wain iwe, u ganba bani namia. Ari han pa dire meme gang hon irere, nir wain hon tulangure, meme gang iwe, nir wain i kina mama dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ena Yisas ha i di te mongure, Yudari kene ongwo yal ta ure ikwi bole yu ditongwi, “Na auna omaga gomia, ni ure gaung bani anana namna wo. Ananga si hon ere aire ya monamua.” ");
INSERT INTO sll_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yu ditere ongure, Yisas grang wine ongwo hobi kina doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ongure al ta, me erin ana holo holo kebena sutani, algi bil molere Yisas mobing holi doling bol ongwi. Pirere, u mobing hol i urere, Yisas galsina angwi. ");
INSERT INTO sll_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Airing i are yu nomani si pungwi, “na nibil olgarai, yali galsina obil agarai, gintani wai sinangwo pai dimia,” dipungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dipire angure, Yisas inaa dire, al i yu ditongwi, “Amagir ye, kulna pirkio. Ni na onangwo u wai nala di pir na tengiwe, u wai onua.” Ditongwo gin iwe, nibil i wai sungwo ya mongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ena Yisas pi Yudari kene ongwo yaliwe, oo kepangwo ala ongwi. Ongure arihobi u ku bole, hai mere, pegare ole, mugu ba pu dire yu ol mongwi. Yu ol mongure Yisas pi pa dire hangwi. ");
INSERT INTO sll_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hanere, “Ni yalhobi ere maini pio. Ama i ta golkima. Ul pai momia hankino.” Ditongure arihobi Yisas wa gol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa gol tongure, irang nigi de pirere, arihobi wa kirulu di maini olungwi. Olere Yisas ama pai mongwo bani pirere, aling aki dungure, ama i aire ya mongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Momia Yisas talongwo guung haang iwe, ganba bina holo holi wa dire kunu bengwi. ");
INSERT INTO sll_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ena Yisas ganba i pisolere, ere banta nala dire ongwi. Ongure omeling gi dungwo yal sutani doling bol ongwi. Pirere gala bir dire, “Debit gangye, milna pir na to.” ");
INSERT INTO sll_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dungure pisole, oo ala ongure, yasuri pi mongwo bani pa dungwi. Pa dungure Yisas yu ditongwi, “Na ni yasuri omin a pila di ni tenaminga panama, di pin mo?” Dimba, yasuri, “Owa, onanga panamua.” ");
INSERT INTO sll_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dungure yasuri omeling arere, yu ditongwi, “Ni na onangwo pamia dire nomani si pir na tenanga meri na ereyu ol ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yu dungure gintani omeling pila dungure, talhan para weni hangwi. Hangure Yisas yasuri kraung are yu ditongwi, “Na tal ol ni tegiwe, ari tau ha wai ol tekio.” ");
INSERT INTO sll_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yu ditomba, yasuri pirere, Yisas tal ongwo ha i ha wai ongure, ganba bina holo holi si dina dire, kunu bengwi. ");
INSERT INTO sll_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ena omeling gi dungwo yasuri ere ongure, yal ta kwia nigi dongwo yong sina momia ha mini paikungwo gintani u Yisas mongwo bani pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pa dungure, Yisas kwia si doling i mena ol tongwi. Ol tomia yal i ha mini pangwi. Yu omiawe, ari miki weni hanere bukunungwi. Bukunere, “Ayo. Isrel ganba bani homa tal ta yu onangwo hankimgirawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dimba, Perisi yalhobi iwe, Yisas tal ongwo i hanere yu ditongwi, “A. Iwe, kwia nigi dongwo singaba yulang tongure, yu omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ena Yisas oo bir migi para weni wangwi. Warere Yudari ha maing oo ala pirere, “God kene ol ni tongwo monua,” dire ha maing nir si tongwi. Tere nibil nebona dere mongwo hobi awai ol tongure, u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te Yisas molere, nibil nebona dere mongwo hobi kul pire momia, hanere, miling gul simia aki di tenangwo yal ta molkima. Kun sipi sipi hong yal kene olkungwo mongwo meri momia, hangwi. ");
INSERT INTO sll_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hanere grang wine ongwo hobi yu ditongwi, “Homena miling miki weni homia hano. Homiba, homena bulangwo yal ta molkimia, tamangwo, yal sutani momua. ");
INSERT INTO sll_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yu omia ni homena hong yal, God irawe, sirin bol tere yu do. Ni homena hong yal monia, homena bulangwo ari tau i tibi ol na tengere, homena i bulangwo, kunu benamua, di to.” ");
INSERT INTO sll_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ena gin ta Yisas grang wine ongwo hobi ana holo holo kebena sutani gala di ku bolere, kwia nigi dongwo ya, nu nibil maing maing ongwo hobi, si doling i olama dire, yulang tongwi. ");
INSERT INTO sll_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Tongwo hobi haang yu pamia, ta Saimon, haang ta Pita momia, te ebering Endru momia, te Sebedi wang Yems te ebering Yon momia, te ta Pilip, ta Batolomeu, ta Tomas momia, te ta takisi ingwo yal Matyu na moliwa, te ta Alpias wang Yems momia, te ta Tadius momia, te ta miling olba sungwo yal Saimon momia, te ta Yisas bai tal sungwo yal Yudas momia. Yudas iwe, Keriot ganba hong yal momia. ");
INSERT INTO sll_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Ena grang wine ongwo hobi Yisas nu si olere, yu ditongwi, “Ni yalhobi Isrel ganba obil warere, ari wiyol tau ganba te, Sameria ganba hoyo. Isrel arihobi iwe, kun sipi sipi mongwo meri momia, kene onangwo ari tamangure, wa du momia, po. ");
INSERT INTO sll_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pirere God ol wai ol na tere kene ol na tenangwo haung mala umua, di to. ");
INSERT INTO sll_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nu nibil pangwo hobi awai ol terere, te gongwo hobi uling yu to. Nebona bir hakubi dongwo hobi i ole terere, te kwia nigi dongwo yong sina mongwo hobi si hobale ole to. Tenangiwe, na yulana ya moro ni tominia ni para ya moro awai ol tenana pio. ");
INSERT INTO sll_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Moni gal gire ire wakio. ");
INSERT INTO sll_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hol bangi wananga moni hong dire gal gire ire wakio. Te galsina sutani, te kebin to sutani ire wakio. Goliba a ire wakio. God honagi onanga bani iwe, galsina goliba ya, moni ya, kebin daing ni tenangwo inanga pamua.” ");
INSERT INTO sll_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ena oo ai bir migi bina holo holi pi pa dingere, ganba hong yal ta pana gal ni tenangwiwe, yali kina gobari molo. ");
INSERT INTO sll_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni oo ala ta nangiwe, yahuno, moldinio, dito. ");
INSERT INTO sll_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oo hong yal pana gal ni tenangwo gala dire, hawai ol tenangiwe, ya pir monamua. Te oo hong yal gumang yaure ni han gogo danangwo, hawai ol tere onangiwe, ta nomani si pir molkinamua. ");
INSERT INTO sll_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te yal ta ni han gogo dal ni tenangwo, ni ere nala dinangi, ni ha ditekire, ere po. ");
INSERT INTO sll_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ena God ari para muru i ku bole, ha hol bir onangwo haung, Sodom Gomora ari hobi iwe, God ha hol obilga ol tenamba, han gogo dal ni tenangwo yal iwe, God ha hol nimaki nangwo ol tenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ena piro. Kun sipi sipi mongwo meri monia. Mol i pirere awi biing mongwo sina i nanga ni si nenangwo pamia hankun ole molo. Molere onba mining bolo wangwo meri ware molo. Molere dua hau ta omeling haung gole amane mongwo meri molo. ");
INSERT INTO sll_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mongere ari tau ni han hol i pirere, ha hol ol ni tenamua. Terere Yudari ha maing oo ala kuba ni sinamua. ");
INSERT INTO sll_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na hana pir monangiwe, yal bir hobi guman bani nigi de hanere, ha hol ol ni tenamua. Ol ni tenangwiwe ari hana yamoni mongwo tau ha hol ongwo hanama dire u ku bonangwo bani, ni aire na guna hana i di tibi ol tenanua. ");
INSERT INTO sll_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ol tenangiwe, talwa dirale di pinanba, Nabin hamen bani mongwo i, Kwiang bai nu sinangure, yon wu bilere, ha i gran bani enangwo dinanua.” ");
INSERT INTO sll_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ena yal tau ebering hobi yong bai tal sire, si golo, ditenamua. Te irang hobi wang tau yong bai tal sire, si golo ditenamua. Te kumil ama hobi irang aang yong bai tal sire, si golo ditenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yu onangwiwe, na hana pir monania, ari para weni ni hanere, yong ki e ni tenamua. Tenamba, yal ta nimni mole ha maing a i si wananga yal iwe, God aki di ni tenangure mol i nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te oo tabil ta pi mongere, tal gogo ol ni tenangwiwe, te ere pi oo tabil ta molo. Isrel oo tabil di ongwo hobi para wa pisolekinangere, Ari Wang Weni na, ti hon uralua. ");
INSERT INTO sll_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ena skul gir hobi tisa iime olangwo paikimua. Te honagi yalhobi honagi hong yal iime olangwo paikimua. ");
INSERT INTO sll_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gir tau mol ipirere, tisa mongwo meri molala di pinangwiwe, i para monangwo pamua. Te honagi yalhobi mol i pirere, singaba mongwo meri molala di pinangwiwe, i para monangwo pamua. Ena ari para weni oo hong yal narawe, “Kwia singaba Bielsebul monua” dire ha gogo di na tongwo meri, grana wine onga hobi para ha gogo weni yu di ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tenamba ni yalhobi kulung pirkio. Talhan kul si dungwiwe, emgi u tibi nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Te ha ta kul si dinangwiwe, emgi ere u tibi nangwo pamua. Na ha diminga i, ni yalhobi tani pinia, emgi di tibi olangere ari miki weni pinamua. Na ha di ni tominga i, ni nin pinia, emgi ire oo hona hona i pire di tibi olanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Di te i ongere yal ta ni sirala di unangure kul pirkio. Yal iwe, ni kwian para ta si golkinangwo pamia gaun tani si gonamua. God iwe, kwian gaun para endo de pangwo bani olere, si gonangwo pamia, yal i tani kulung pir to. ");
INSERT INTO sll_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hahoba elamaila sutani maket homena bring sinongwo bani wan toea obil bomua. Bomba, hamen nabe pirkinangure, hahoba taniga wala gal warere, yanangwo paikimua. ");
INSERT INTO sll_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ni yalhobi bini eme iwe, para weni God kerere, pir po simua. ");
INSERT INTO sll_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","God hahoba talwo i kene omba te ni arihobi ni kene wai weni omua. Ongwo ipire kul pirkio. ");
INSERT INTO sll_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yal ta arihobi maulung bani, na Yisas gamahobo moliwa, dinangwiwe, na ere yali haang God mongwo bani dal tibi ol teralga pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Te yalta arihobi maulung bani, “na Yisas grang wine olkiwa” dire gai gonangwiwe, na ere yali haang God mongwo bani dal tibi ol tekiralua. ");
INSERT INTO sll_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ena na uga hol iwe, dolna bole wine onangi, kulang panamo? I ta paikinama. Kura te tal oun dongwo u tibi pi ni tenamia hananua. ");
INSERT INTO sll_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Irang na pir na tere grana wine onangi, wanihobi kiang pai ni tenamua. Te wang na pir na tere grana wine onangi, nabin hobi ereyu kiang pai ni tenamua. Te aang na pir na tere grana wine onangi, aun hobi ereyu kiang pai ni tenamua. Te aung na pir na tere grana wine onangi, nimai hobi ereyu kiang pai ni tenamua. Te aingbi ta na pir na tere grana wine onangi, hoin hobi kiang pai ni tenamua. Te hoing na pir na tere grana wine onangi, ainimbi hobi ereyu kiang pai ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te yal ta na pir na tere dolna bonanga, ari tau kiang pai ni tenamba, te enin tau hobi iwe, kiang bir weni pai ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Te ni nimai nabin pir tere awai ol tenanba, te na pir na tere awai ol na tenanga iwe, wai weni panamua. Te ni wani aun pir tere awai ol tenanba, na pir na tere awai ol na tenangiwe, ere wai weni panamua. ");
INSERT INTO sll_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yal ta na dolna bolala di pinangiwe, gaun gul ikirere, dolna bonan mo? I ta bolkinana. Gaun gul bir irere, dolna bonanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yal ta gobari ya mol parala di pinangiwe, gonanua. Te yal ta gauna gul iralga tamama di pinangiwe, mol pai gobari inanua. ");
INSERT INTO sll_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Te yal ta ni yalhobi kina pana gal ni tere awai ol ni tenangwo yal iwe, na para awai ol na tenamua. Na tani ol na tenangwo taman. God, na nusolangwo yali, para ol tenamua. ");
INSERT INTO sll_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te God hana togu yal ta honagi onangwo meri iwe, tobo inamua. Te God hana togu yal i unangwo hanere, pana gal tenangwiwe, hana togu yal i tobo inangwo meri kunu inamua. Te yal ta wai weni monangwo yal iwe, tobo ere inamua. Yal wai weni unangwo hanere, pana gal tenangwo iwe, yamoni gal tekinamia tobo ere inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na grana wine onangwo yal bina ta unangwo hanere, nir hon holere, tenangwiwe, God yal i tobo tenangwo pamua. Na ha weni kara di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ena Yisas grang wine ominga ana holo holo kebena sutani honagi ha di na te pisolere, ere pi oo tabil tau pirere, ha maing nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ena Kraist honagi ongwo i Yon nir bil tongwo yali halabusi pai molere pungwi. Pirere grang wine ongwo tau bai nu si Yisas mongwo bani olungwi. ");
INSERT INTO sll_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Olungure pi Yisas mongwo bani pa dire yu ditongwi, “Yon yal ta unamua dungworai, ni mon mo, yal ta emgi uname?” ");
INSERT INTO sll_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Dungure Yisas yu ditongwi, “Omeling gi dungwo hobi pila dimio, kebering kebir engwo hobi u wai omio, hakubi dongwo hobi gaung wigi simio, kraung gi dungwo hobi pila dimio, gongwo hobi hon aire ya momio, yal bina hobi God tal ol na tongwo ha maing ditominga pungwo hangiwe, Yon ditenana po. ");
INSERT INTO sll_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yalta na na hanere, owa Kraist moma dipire nomani susu sikinangwo yal iwe, yong horoga onamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ena Yon grang wine ongwo hobi ha yu ditomia pirere, ere memini ongwi. Ongure Yisas Yon guung haang arihobi yu ditongwi, “Ni ganba po engwobani Yon momua, dungwo pirere, harala di ongiwe, ari monangwo harala di pin mo, tal u tibi nangwo harala di pine? ");
INSERT INTO sll_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kul airing hair sire ho tongwo harala di on mo, yal ta galsina wai weni si giu dinangwo harala dire one? Galsina wai weni si giu dinangwo yal iwe, oo bir ke pangwo ala i mole pare omia. ");
INSERT INTO sll_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","God hana togu yal harala dire ono? Owa, para dinia, hana togu tau mongwo meri ta molkima. Yon iwe, God hana togu yal bir weni momua. ");
INSERT INTO sll_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ha maing buku homa di emiraya omaga yali u tibi omua. God yu dungwi, na hana togu yal momia hano. Yal iwe, nu si olaminga homa e ni tere hol bala di ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ari tau bir omba, Yon bir weni omua. Yon bir weni omba, God kene ongwo bani ari monangwo iwe, God kina si daule monamua. ");
INSERT INTO sll_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yon mole ha maing ditongwo haung iwe, ari tau God kene ongwo bani nala dire nega dire yulang bol i ungwo ungwo, omaga ere na mominga haung para yu omua. ");
INSERT INTO sll_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","God hana togu yalhobi para weni, te lo ana holo holo Moses awa ha dire mining bol ere, God kene ongwo hol u tibi namua dimiraya, Yon omaga u tibi umua, dungwo pinua. ");
INSERT INTO sll_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hana togu ha dungworai pinangiwe, Yon Ilaiya u tibi pire moma di pinanua. ");
INSERT INTO sll_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ari nomani pamia ogolo pirio. ");
INSERT INTO sll_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ena ari tabin malaya mongwo hobi iwe, ari tau mongwomeri kunu momua diral mo, talwa dirale? Maket homena bring si nongwo bani gir migi ami di mongwo meri momua. Gir tau hol bani mole kir te mongwo hobi iwe, gala dire gir hol bani mongwo i yu ditongwi, “Na ul diminba, ni egin ikinua. ");
INSERT INTO sll_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Na ari gongwo hobi geral di tominba, ni gir hobi ere hai me tekinua.” ");
INSERT INTO sll_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yon urere homena tau mai tere nir wain nekungwiwe, ari para hanere, “Gir hobo, Yon ungworai du dima,” dimua. ");
INSERT INTO sll_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na Ari Wang weni molia ugiwe, homena ya nir wain negiwe, ari hobi na hanere, “Aye. Yali talta omia hano. Homena miki weni nere, nir wain nere, dimia hano. Takisi ingwo yal ire, ha maing pirkungwo hobi ire dire, yahuno ditomia hano.” Dimba God ha weni kara dim mo, dikime? Dinangwo ari pirere, u wai homo? U wai ongwo hania. Hanga i Yon na kina ha nir si tobilga pire ereyu u wai omia pir na tekino” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ena habang ta Yisas oo malgi tau tal guma hon dongwo i tibi ol tomba, ari hobi hanere tal digan ongwo i aidole nomani si kulu sinangwo ha pirkimia. Yu omia Yisas hanere kura ha yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aye, Korasin yalhobo, ni Betsaida yalhobi kina gaun gul bir inanua. Tal guma hon dongwo ni monga bani ol ni tega meri, Taia Saidon ganba arihobi yu ol teralga, hanere, tal gogo ongwo gintani aidole, nomani si kulu sinamua. Sirere ganba bilgere, ari para na han po sinama dire yu onamua. Onamba, tal guma hon dongwo ol tekia. Ni monga bani obil ol ni teiba nomani si kulu sire pir na tekinua. ");
INSERT INTO sll_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","God ari para muru ha hol ol tenangwo haung iwe, Taia Saidon yalhobi ha hol ol tenamba, ni yalhobi ha hol nimaki nangwo ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaneam yalhobo, ni hamen bani nala di pinanba, God ni irere, pia si endo de pangwo bani olangwo pamua. Ni monga bani tal guma hon dongwo ol ni tega meri iwe, Sodom ari ganba bani yu ol teralga Sodom ganba omaga ya di panamba, yu ol tekia wai simua. Simba ni monga bani tal guma don hongwo ol teiba, pir na tekinua. ");
INSERT INTO sll_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","God ari para muru ha hol ol tenangwo haung, Sodom yalhobi ha hol ol tenamba, ni yalhobi ha hol nimaki nangwo ol ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ena habang gin iwe, Yisas yu dungwi, “Nabe. Ni hamen ganba hong ni tani monia. Nomani bir pangwo sikul dungwo hobi ha di tibi ol tekinia. Sikul dikirere, pir po sikungwo yalhobi obil nibil di tenga wai piriwa. ");
INSERT INTO sll_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O nabe ni nin nomani si pinga meri yu onga pamua. ");
INSERT INTO sll_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nabe talhan para muru i na ana bani emua. God Wang na iwe, nabe nin na han po simua. Te nabe iwe, na nan han po siwa. Sirere, haang i, ari tau di tibi ol teralgiwe, para han po sinamua. ");
INSERT INTO sll_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yal tau honagi oun dongwo ol i pirere, ku si mol pirere na molga bani wo. Unangiwe, erin i tibi ol ni teralga monanua. ");
INSERT INTO sll_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na pirari te omena haung gole molga i pire ungere na nan gang were ni tegere na nan maing pir pa dinanua. Ena kwian mol pai goi sinangwo inanua. ");
INSERT INTO sll_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na honagi ol ni teralga i, kulang panamia, tal ta ni au so diralga i, para kulang panamia, au sinanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ena Sabat haung ta Yisas grang wine ongwo hobi kina paba ya nongwo sina wangwi. Warere, tau menan golere, paba tau pe nongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nomia, Perisi yalhobi hanere, Yisas yu ditongwi, “Sabat haung manaa dungworai, talongwo ni gran wine ongwo hobi paba pe nome?” ");
INSERT INTO sll_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dimba, Yisas yu ditongwi, “Debit gamahobi mena golere, tal ongworai, ha maing buku kere pirkino? ");
INSERT INTO sll_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yalhobi God ha maing oo bir ala werang tai pirere, homena breti God maulung bani dungwo i nongwo irawe, homena i, yali gamahobo nenama dire taman. Te ha maing oo kene ongwo yalhobi obil nomiraya. ");
INSERT INTO sll_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lo ana holo holo Moses ha yu di emiraya, Sabat haung ha maing oo kene ongwo yalhobi Sabat lo isusu olemua. Olungwiwe, pring ta paikimua di emiraya, kere hankino? ");
INSERT INTO sll_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ha maing oo i kene ongwo hobi Sabat haung honagi ongwo wai pamba, na ha maing oo i a ime ol teiya, olalga wai weni panamua. ");
INSERT INTO sll_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ha mining ganing ta yu pamiraya, Lo wine onangi para panamiba, te awai honagi onangi wai weni panamua. Ha iwe, memini pangwo pir po sinanga, pring pai tekinangwo hobi, “Pring ni tomua,” di tekinanga pamba, pir po sikina, di tenua. ");
INSERT INTO sll_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ari Wang Weni na iwe, Sabat haung para hobang molga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ena Yisas ai i pisolere, pi ha maing oo ala ongwi. Ongure, ala i yal ta aling kebir engwo mongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Momia, ari tau Yisas Sabat isusu ol tenangwo irai, ha di mere si tenamna di han mongwi. Molere Yisas yu ditongwi, “Yal ta Sabat habang nibil ongwo yali awai ol tenangwo, Lo isusu olam mo, olekiname?” ");
INSERT INTO sll_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dimba Yisas yu ditongwi, “Sabat habang kun sipi sipi yo maul ala nangwo ni yalhobi i mena olekinan mo? Olanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kun sipi sipi iwe, tobo bir pamiba, te ari tobo bir weni pamua. Pamia, awai ol tenamingiwe, Lo isusu ta olekinaminga pamua.” ");
INSERT INTO sll_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Direre nibil ongwo yal i yu ditongwi, “Ani sine do.” Dungure aling sine dungure u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yu ongure Perisi arihobi hanere, yong ki erere, Yisas sirala dire ha hongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ena, Yisas pirere, ganba i aidolere, ere ganba banta ongwi. Omia ari miki weni doling bol ongwi. Ongure Yisas nibil pangwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ol te pisolere yu ditongwi, “Na tal ol ni tega i guna hana ari tau ha wai ol tekio,” dire manaa ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ena hamen haya God hana togu yal Aisaia ha yu di emiraya,");
INSERT INTO sll_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God yu ditomia, Yal ta unangwo hananua. Unangwo yal iwe, na nan honagi ol na tenama dire pare ega unamia. Na yona milna yali tere, nomani para teiwa. Te na kwiana yali yong wu bilere kina mol pai onamua. Olere, na ha hol olalga maing ari para muru di tibi ol tenamua.");
INSERT INTO sll_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ha erakere bolbin ta dikinamua. Te homaulung bir gala dire ha miki ta ditekinamua.");
INSERT INTO sll_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yal ta bo kura pangwo meri pare monangwiwe, yal i hanere a yo te tenamua. Te kewa lampi dere gobirala dire abangwo meri iwe, yal ta yu monamua. Monangwo yal iwe, yal i hanere, yulang tenangure, aire nimni monamua. Yal i honagi ol i nangure, memini wai weni pare nima namua. Nangure talhan para muru ol kunu olangure, u wai pire pai monamua. ");
INSERT INTO sll_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pai monangure, ari para muru yali pir tere, pi tege ere mol i namua.” Homa Aisaia God grang pirere, ha yu di emiraya, omaga Yisas u tibi pire, honagi ongure nima omua. ");
INSERT INTO sll_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ena ongwo gin irawe, yal ta kwia kumo yong sina molere, omeling a gi dire, grabeling a tomia ha mining paikungwi. Paikimia aule ire, Yisas mongwo bani ungwi. Ungure Yisas yali awai ol tongure, omeling pila dire, ha mining pangwi. ");
INSERT INTO sll_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pamia ari miki weni mongwo hobi hanere, Aye. Yali Debit gang mom mo? di hangwi. ");
INSERT INTO sll_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Di hamia Perisi yalhobi pirere yu ditongwi, “Yali kwia nigi dongwo singaba, Bielsebul, aki di tongure, honagi ongwo i hankino?” ");
INSERT INTO sll_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dungure Yisas pirere, yu ditongwi, “Ena ari ganba banta sina sikira dire, kura bole, u susu namia. Te irang aang hobi kina kura bole, gumang nin nin dinangwo u susu namia. ");
INSERT INTO sll_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te Seten gamahobo nin nin ebir sire, kura bonangwo i nimni monamo? I ta molkinama. I ere yu u susu nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na Bielsebul aki di na tongure, kwia nigi dongwo si doling i ole tomua, di na tengiwe, ni wanihobo Bielsebul aki di tongure, kwia para yu si doling i olem mo? Ta olekimia ni ha gogo dinua. ");
INSERT INTO sll_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","God Kwiang aki di na tongure, kwia nigi dongwo si doling i olia. Olga hangiwe, God kene ol na tongwo maing omaga i tibi olga, hanua. ");
INSERT INTO sll_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Te nona pangwo yal ta monangure, yal ta oo kepangwo ala pirere, bona gana kuni inamo? Ta ikinama. Homa pi nona pangwo yal i kulere, kebering aling han sire, emgi ala pire bona gana inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ena yal ta Yisas tal ongwo kunu paikmua, dinangwo yal iwe, na gamnahobo ta molkinamua. Molkirere God ha maing pungwo hobi i gogo ol tenamua. ");
INSERT INTO sll_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Olamia yal tau tal nigi dongwo maing maing olere, ha gogo dire onangure God pring tenangwo iwe, tere nin nomani si pinangwo meri kri di olangwo pamia. Pamiba, God Kwiang gaung ha si tenangwo iwe, God pring tere han olangwo hawo ya di panangwo bani panamua. ");
INSERT INTO sll_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te yal ta Ari Wang Weni na irawe, gauna ha si na tenangworai, God pring kri di ole tenangwo pamia. Pamiba, God Kwiang gaung ha si tenangwo iwe, pring i ere hawo ya di panangwo bani panamua. ");
INSERT INTO sll_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ena er wai dinangwiwe, miling nigi dongwo pe nenan mo? I ta nekinanua. Te er nigi dongwo bani iwe, miling digan homia, te er wai dungwo bani iwe, miling wai homua. ");
INSERT INTO sll_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ni yalhobi onba giri mongwo meri mole hasu gran dirane sire yu di wanua. Ni ha wai weni dinba, monga maing yo toma di pino? Yo ta tekimua. Ni ha yona ali mo wi dungwo meri wa dire di mena olinua. ");
INSERT INTO sll_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yal wai monangwo yali ha wai dinamia, te yal digan monangwiwe, ha digan dinamua. ");
INSERT INTO sll_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Emgi God ari para muru ha hol ol tenangwo bani, ari para ha nigi dongwo dungwiwe, di tibi ol tenamua. ");
INSERT INTO sll_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ha gran bani dingiwe, ya direre emgi ha hol bani siina dire unangwo nin inanga pamua. Ha iwe, God hanere, a, ni pring pai ni tomua, te ni pring pai ni tekimua, yu di ni tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ena Lo ana holo holo kene ongwo tisa tau ire, Perisi tau ire dire, “Tisao. Ni hamen bani tal guma hon dongwo maing ta i tibi olingere hanaminba?” ");
INSERT INTO sll_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dungure Yisas yu ditongwi, “Ari yal al maing nigi denga monga hobi ya, tal guma hon dongwo maing ta i tibi ol na to, dingiwe, talongwo i tibi ol ni tegere hanane? I ta hankinanua. ");
INSERT INTO sll_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","God hana togu yal Yona mongwo bani u tibi ongwo meri irawe, yu nangwo hananua. Hana togu yal Yona iwe, pisi nir hau bir weni yong sina i hamen haung sui tai dire pare mongwi. Mongwo meri iwe, Ari Wang Weni na ari yulagi engwo bani ere hamen haung sui tai dire paralga pamua. ");
INSERT INTO sll_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ena God ari para muru ha hol ol tenangwo gin iwe, Nineba ganba hong yalhobi yal Yona ha maing ditongwo pirere, tal nigi dongwo ongwo i nigi de pir tere nomani si kulu sire hon olkirala di pimia. Ni nomani si kulu sikinia ha di mere si ni tenamua. Ena hana togu yal Yona wai momba, te hana togu yal timiya mongwo i wai weni momua. ");
INSERT INTO sll_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te Siba ganba al singaba kwin Solomon ha maing dungwo pirala dire, nin ganbani pisolere, pi pi Solomon mongwo bani pa dimia, ni yalhobi ha maing mala dimba, pirkinia, al i ha di mere si ni tenamua. Solomon wai momba, te hana togu yal timiya mongwo i wai weni momua.” ");
INSERT INTO sll_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ena kwia nigi dongwo ari yong sina i aidolere ere banta namua. ");
INSERT INTO sll_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pi molere, oo ta wa dunangwo, dikinangwo hanere, “Ayo, na homa oo wai dungwo moliraya omaga oona ta dikimia ere memini nalua” di pinamua. Pirere ere urere homa kepangwo ala i hanangure, bigi sire wai dinamua. ");
INSERT INTO sll_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dinangwo hanere hon ere pirere, kwia sewen-pela monangwo bani aule ire unamua. Aule ire, urere, yal ta yong sina monamua. Homa yal iwe, kwia nigi dongwo taniga yong sina mongwo nigi domiraba, omaga kwia miki weni yong sina monamia, nigi weni denamua. Yu ongwo meri iwe, ni yalhobi monga timiya yal nigi dinga, para yu ol ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ena di tongwo gin irawe, Yisas aang ebering hobo kina u maini mongwi. Molere, “Yisas ha ditenamna wo di to,” dire di gala dungwi. ");
INSERT INTO sll_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gala dungure ari tau Yisas yu ditongwi, “Pino. Nimai ebinhobo irai u maini molere ni gala dimia wiya po.” ");
INSERT INTO sll_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dimba Yisas yu ditongwi, “Na namine ebina ara mongwo han dime? ");
INSERT INTO sll_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na grana wine ongwo hobi momia hano. ");
INSERT INTO sll_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mongwo hobi iwe, namine ebina hobo momua. Hamen nabe grang wine onga hobi iwe, namine ebina keunambi muru weni monua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ena ha dungwo gin irawe, Yisas oo ala i pisolere, ere mena urere, pi nir digan bina mongwi. ");
INSERT INTO sll_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Molere ha maing nir si tongwi. Nir si tongure ari miki weni u yobilungwi. Yobilungure Yisas iri si sipi hanu bani pirere, ami di mongwi. Ami di mongure arihobi nir bina hala si mongwi. ");
INSERT INTO sll_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mongure Yisas ha bangi biire miki weni dire yu ditongwi. “Yal ta homena miling sigirala dire u sina namua. ");
INSERT INTO sll_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pirere miling sigirangure miling tau ya homaulu i sinamua. Sinangure hahoba u pa dire ne wai sinamua. ");
INSERT INTO sll_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te miling tau ya hulu bolimbani sinamua. Sinangure, ganba miki ta dikimia, obilga dinamba, pi sire gintani bonamua. ");
INSERT INTO sll_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bonamba, ari sina unangure, dulung stei kule megine gonamua. ");
INSERT INTO sll_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te miling tau ya tul galeng engwo ali sinamua. Sinangure pi sire bonamua. Bonamba, tul si nenangwo miling ta holkinamua. ");
INSERT INTO sll_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te miling tau ya ganba wai dungwo bani sinamua. Sinangure pi sire wai weni bonamua. Wai weni bolere miling honamua. Erin ta miling teti obil honamua. Erin ta miling miki siksti honamua. Te erin ta miling miki weni wan handret honamua. ");
INSERT INTO sll_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Honamia ari nomani pamia ha i pir po simo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ena ha bangi biire yu ditongure, Yisas grang wine ongwo ana holo holo kebena sutani yalhobi iwe, sirin bol tere yu ditongwi, “Ni ha bangi biire nir si tengiwe, talongwo dine?” ");
INSERT INTO sll_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dungure Yisas yu ditongwi, “God kene ongwo bani di bole dimingiwe, ni nin pir po sinia, ari ya mongwo hobi pir po sikimua. ");
INSERT INTO sll_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tal ta ni tenangwo kene ole yu wanangiwe, emgi ti hon ni te au sinangwo pamua. Te tal ta ni tenangwo ogolo kene ole yu wakinangiwe, homa ni tenangwo tali nin tol di inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yu onama dire ha bangi biire ditominua. Ditomingiwe, ari hobi omeling hamba hanere, ogolo han pa dikinama, te kraung pimba pirere, ogolo pir pa dikinamua. ");
INSERT INTO sll_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","God hana togu yal Aisaia homa ha di emiraya, omaga nima nangwo pamia. Ha iwe, mining yu bomia. Ni pir pir ole pir po sikinanua. Te han han ole ere han po sikinanua.");
INSERT INTO sll_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yu onangiwe, omeling gi yal ya, te kraung gi yal mongwo meri molere, nomani ta paikinangwo du dale monanua. God yu di ni tomia. Pinanga pirere, siina di na molga bani unangarai, tal nigi dongwo ol wanga God prin ni tongwo i, i ole ni teralga pamua. ");
INSERT INTO sll_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Dimba, ni yalhobi iwe, omen kraun gi ta dikinia, wai pire gun ere monanua. ");
INSERT INTO sll_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ena God hana togu yalhobi ire, God ha maing pungwo hobi ire dire, tal olga hangiwe, para harala di pire momba, ta hankimua. Te ha diga pingiwe, para yu pirala di pire momba, ta pirkimua. ");
INSERT INTO sll_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ena ha bangi biire di ni tominga irai, omaga memini di tibi ol ni tenaminia, piro. ");
INSERT INTO sll_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Miling tau ya homaulung sungwo meri ari tau yu monamua. Molere God kene ol na tongwo ha maing pinamba, memini pir po sikinamia, Seten ure ha maing tol di inamua. ");
INSERT INTO sll_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Te miling tau ya hulu bolimbani sungwo meri iwe, ari tau yu monamua. ");
INSERT INTO sll_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Molere, ha maing pirere, bukunere, monamua. Molere, kraung pinamba, nomani sina ali bona si eikirere ha i gintani pisolamua. Pisolangwo yalhobi iwe, ha maing gogo gogo i wa molere, emgi kura pare, te talime u tibi nangwo gin i, aidolangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Te miling tau ya tul galeng engwo ala sungwo meri iwe, ari tau yu monamua. Monangwo yalhobi ha maing pinamua. Pinamiba, ganba tal moni gal bona ya, talhan hobi pinangwo mo yuwo nangure, ha maing nomani sina pai tekinamua. Tekinangwo yalhobi iwe, God honagi ta ol tekinamua. ");
INSERT INTO sll_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Te miling tau ya ganba wai dungwo bani sungwo meri, ari tau yu monamua. Molere, ha maing pirere, nomani sina bona si ere a i si ware monangwo, miling panamua. Miling panangwo meri iwe, ari tau yu monamua. Molere ari tau honagi obilga teti ol God tenamio, te ari tau honagi miki siksti ol tenamio, te ari tau honagi miki weni wan handret ol tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ena Yisas ha bangi biire hon ainere yu ditongwi, “Yal ta paba miling wai u sire yanamua. Yanangwo meri iwe, God kene ongwo hol i yu pamua. ");
INSERT INTO sll_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Paba miling yarere ginangwo ul panangure kiang yal ure tul miling sigire sina i olere, te namua. ");
INSERT INTO sll_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Paba pi sire mo nangwiwe, tul kina ereho bonamua. ");
INSERT INTO sll_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bonangure, honagi yal ta hanere, homena hong yal yu ditenamia. Yahuno, ni homena miling wai weni inga yaminiraba, tul miki weni pi sire homena kina ereho bomua, dinamia. ");
INSERT INTO sll_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dinangure homena hong yal i yu ditenamia, Na kiana yal ta ure tul miling sigirimia. ");
INSERT INTO sll_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tul diirangiwe, paba kina ereho diiranga pamia pisolo. ");
INSERT INTO sll_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pisolanga, emgi paba sire kul enangure penanga habang iwe, tul para diire manbi hobi olere endo gananua. Galere paba i ku bolere homena oo ala enanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ena Yisas ha ta hon di bole yu ditongwi, “God ari kene ol ni tongwo mol pai ongiwe, maing yu pamia. Er miling wainta weniga, haang mastet, dungwo bani iwe, di bole di emua. ");
INSERT INTO sll_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Miling iwe, migiga dimba, kunanga bolere, er tau ime olamua. Er i bir weni bonangure yolang bani haboba oong ere mol pai onamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ena ha bangi ta hon ainere yu ditongwi, “Ena God ari kene ol ni tongwo hol iwe, Yis dungwo meri dimua. Yis iwe, agr ire plaua gangwo ali olungwo u bir ongwo hanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ena Yisas ha maing nir si tongwiwe, ha bangi biire muru ditomia, ha memini di tibi ol tekima. ");
INSERT INTO sll_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hana togu yal ta ha homa yu di emiraya, omaga nima ongwo pamua. “Na ha maing di teralgiwe, ha bangi biire muru diteralua. Ha iwe, hamen haya ta ditekimiraya omaga diteralua.” ");
INSERT INTO sll_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ena Yisas arihobi mongwo bani aidolere ere oo ala ongwi. Ongure grang wine ongwo hobi u Yisas mongwo bani urere, yu ditongwi, “Ni paba u sina tul kina ereho bomua dingiwe, omaga memini di tibi olingere pinaminba?” ");
INSERT INTO sll_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dungure Yisas yu ditongwi, “Yal ta homena miling yanamua, digarawe, Ari Wang Weni na moliwa. ");
INSERT INTO sll_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te u sina wa digiwe, ganba uling holo holi para weni dimua. Miling wai wa digiwe, ha maing wine ole pir mongwo hobi momua. Tul wa digiwe, Seten grang wine ole mongwo hobi di bole diiwa. ");
INSERT INTO sll_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kiang yal wa digiwe, Seten momua. Paba penangwo habang wa digiwe, hamen ganba wai sinangwo habang God ha hol bani di bole diwa. ");
INSERT INTO sll_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Paba penangwo yalhobi wa digiwe, ensel hobi di bole diwa. ");
INSERT INTO sll_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Te tul diire endo ganamua digiwe, Ari Wang Weni na ensel bai nu si olalga urere, God kene ongwo bani mongwo hobi i ku bonamua. Bolere ebir sire talime olo dire, kraung si tongwo yalhobi iwe, tal nigi dongwo ongwo yalhobi kina pia si endo dongwo bani olama dire dirawa. Olangure aya maya dire, kul pire, gaung a i sinangure monamua. ");
INSERT INTO sll_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Te God grang wine olere hol ditongwo meri doling bonangwo yalhobi iwe, hamen bani pire ari kulang gi dungwo meri yalhobi gaung bani ba bonangure monamua. Ni ari nomani pamia ha i ogolo piro. ");
INSERT INTO sll_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Te, God kene ol na tongwo hol iwe, maing yu pamia. Tal wai weni ta u sina man wure kul si enangwiwe, yal ta ure paine hanere hon kubu si enamua. Erere ere mena pire talhan a nongwiwe, para weni yal tau tere moni inamua. Moni irere u sina ganba hong yali bring si tenamua. ");
INSERT INTO sll_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Te, God kene ol na tongwo hol iwe, maing ere yu pamia. Yal ta kuri meule wai weni dinangwo irala dire wa du i namua. ");
INSERT INTO sll_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wa du i nangwiwe, kuri wai weni dinangwo hanere, talhan a nongwo i para weni yal tau tere moni inamua. Moni irere, kuri hong yal i bring si tenamua. ");
INSERT INTO sll_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Te, God kene ongwo bani iwe, maing ta ere yu pamia. Yal ta pisi nir hau gal pia si nir ala olamua. Olere, pisi nir hau han ta ta para muru sinamua. Sinangure, gal ala si di dinangwo i mena olamua. ");
INSERT INTO sll_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Olere ebir sire, nenamua. Ebir sinangwiwe, pisi wai dinangwo i holo pera ali erere, nigi denangwo i holo enamua. ");
INSERT INTO sll_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yu onangwo meri iwe, ganba wai sinangwo habang u tibi nangure, ensel hobi urere, ari para muru i ku bonamua. I ku bolere, pisi ebir sungwo meri, ari ere yu ebir sinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ebir sinangwiwe, ari amane monangwo i holo olere, ari nigi denangwo endo de pangwo bani olamua. Olangure, aya maya dire, hai mere, gaung a i sinangure monamua.” ");
INSERT INTO sll_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ena Yisas yu sirin bol tongwi, “Ni yalhobi ha di ni tega i para weni pir po sin mo?” ");
INSERT INTO sll_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dimba, yalhobi “Owa, pir po siminua.” Dungure Yisas hon yu ditongwi, “Lo tisa ta ha maing diga i pir na tenangwiwe, maing yu pamia. Oo hong yal ta boksi ali talhan tau wa erere, di bonamia. Bolere tal golin tau ire, tal hon tau ire, i tibi olamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ena Yisas ha bangi biire di te pisolere, ere nin oo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pirere Yuda ha maing oo ala ha nir si tongwi. Tongure arihobi pirere bukunungwi. Bukunere, yu dungwi, “Yal i nomani bir weni pamia, hano. Tal guma hon i hol makena i ure i tibi olime? ");
INSERT INTO sll_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Haminda yal wang molkimo? Aang Maria momiraya, te ebering hobi haang Yems ire, Yosep ire, Saimon ya Yuda yali ebering hobo mongwo irawe. ");
INSERT INTO sll_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Keunumbi hobirai nan yalhobi kina para mominua. ");
INSERT INTO sll_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tal ongwo i, yulang makena i ure ome?” Yu dire siga wa tere mongwi. Siga wa tere momia Yisas nin hanere, yu ditongwi, “God hana togu yal ta wiyol ganba banta ha maing di tongwo ari hobi pirere hang awala gamba, nin oong malgi arihobi hang awala galkimua.” ");
INSERT INTO sll_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yu dungure nin oo malgi arihobi Yisas pir tekimia, nibil pangwo hobi awai ol tekungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ena yu ongwo gin irawe, Galili ganba singaba Herot Yisas tal ongwo i haang pungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pirere, gamahobo yu ditongwi, “Yon ha maing nir bil tongwo yal irai, gongworai, ti si hon ere aire tal yu oma dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Homa yasingaba Herot ebering Pilip eumbi al Herotias ingwi. ");
INSERT INTO sll_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ingwo iwe, Yon hanere, “Ni al i inga i nigi domua,” di te te ole mongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mongure, Herot yong ki ere Yon si golala di pimba, Yuda ari Yon God hana togu yal momiraya dire, kul pungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ena Herot aang kul nongwo kalanda si engwo haung u tibi omia, Herot hanere, homena ke ne mongwi. Ne mongure al Herotias aung pi arihobi mongwo bani egin gale ingwi. ");
INSERT INTO sll_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Imiawe, Herot wai hanere, ama i yu ditongwi, “Ni egin ingi wai weni hania, tal ta irala di pinanga, na di na to. Di na tenangi ha weni kara ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dungure, aang ama i gala dire, “Yon halibusi pangworai, breng biire pera ali ere i na to ditenana po” ditongwi. Ditongwo ama i pirere Herot mongwo bani pirere aang dungwo meri ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ditomia Herot nigi de pimba, ari mongwo bani ha weni kara diraya ama dungwo meri yu olalua dire, gamahobo tau bai nu si halabusi oo malgi olungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Olemia, pirere Yon breng biire i pera ali ere i ure ama i tongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tongure ama i, i pirere aang tongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yu omia Yon grang wine ongwo tau halabusi oo ala pirere, Yon yone i ure man wu engwi. Wu erere pi Yisas mongwo bani pire ha i di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ol tomia, Yisas pirere, mongwo bani aidolere, u sipi ala pirere, pi sina ering gobo ta nin muru molala dire ongwi. Ongure, ari hobi omua dungwo pungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pirere, nir bina doling bol ongwi. Ongure, Yisas sipi ala mole ere mena ure, arihobi miki weni hanere, miling pir tongwi. Pir terere, nu nibil pangwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ol tere mongure, hamen pudungure, grang wine ongwo hobi Yisas mongwo bani ure yu ditongwi, “Omaga ganba po engwo bani molala di ungarai, hamen girangwo pamia, ari hobi ditengere, oo hona hona tau pirere, homena bring sinamia, nu si olo”. ");
INSERT INTO sll_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dimba, Yisas yu dungwi, “A, monamia. Ni yalhobi nin homena ta i unanga, obil tenana pio.” ");
INSERT INTO sll_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dungure grang wine ongwo hobi yu ditongwi, “Breti ana hol pai muru pisi sutani i umingirawe”. ");
INSERT INTO sll_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dimba, Yisas, “O dinangwo i, obil ire na mominga baniya wo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Direre, ari hobi kul bongwo bani “ami dio.” Diterere, homena breti pisi kina ereho irere, hamen bani yuwo hanere, “O God homena na tengi wai piriwa” dungwi. Direre, breti a du dire grang wine ongwo hobi tongwi. Tongure, yalhobi ire ebir sire ari mongwo hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tongure ari hobi nere miing ongwi. Ena homena tau ya dungwo tali i ku bolere, gal basket ana holo holo kebena sutani girungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te ari homena ne mongwo hobi iwe, paib tausen miki weni ne momia, gir migi agr para kerekimna. ");
INSERT INTO sll_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ena, Yisas grang wine ongwo hobi bai nu si olungure, sipi ala pirere, nir digan bina hol bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ongure Yisas ari hobi “ere po,” ditongwi. Ditere, Yisas hamen hul ta pire, irang God kina hawai olala di pire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pi molere, hamen girimia, nin mongwi. Nin mongwo haung i, grang wine ongwo hobi sipi ala molere, ere pi nir digan sina weni pa dungwi. Pa dungure, hamen hair mu dinba urere, sipi si manala olala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ongure, girungwo sinamoki grang wine ongwo hobi mongwo bani Yisas nir barere u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dimia grang wine ongwo hobi hanere, kul pirere, “Aya, kwia ta umua,” dire, gala dungwo oba abe yangure mongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Momba, Yisas hanere, “A, yu olkire, mining bole molo. ");
INSERT INTO sll_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na Yisas uminia ara uma di pine?” Ditongure Pita di holo ol tere, “Yal Yisas ye, ni nin unanga, na nir bare wo di na tenanga urale?”. ");
INSERT INTO sll_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dungure Yisas “Owa nir bare wo.” Ditongure Pita nir bare Yisas mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Omba, hamen hair bir hon hanere, u di nir ali ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pirere gala bir dire, “Aki di na tekino”. Dungure Yisas gintani urere, Pita aki dungwi. Aki dire yu ditongwi, “Ni nir bare ungi na yulana ni teralga paikinama di pino? Talongwo na pir na tekine?” ");
INSERT INTO sll_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Direre, iri si sipi ala ongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ongure hamen hair wai sungwi. Wai simia gamahobo Yisas maa e tere. “Ni onga wai piminua. Ni God wang weni monga pamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ena Yisas gamahobo kina hon ere pirere, pi Genesaret ganba pa dungwi. Pa dungure, Genesaret arihobi Yisas gumang han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pa dire, bina holo holi nu nibil pare moli ongwo hobi, aule ire, Yisas mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ure sirin bole yu ditongwi, “Nibil pangwo hobi ni galsina anamba?” Dungure nibil pangwo hobi galsina arere, u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ena gin ta Yerusalem oo malgi iwe, Perisi hobi ire, lo ha nir si tongwo tau ire dire, u Yisas mongwo bani pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Pa dire Yisas yu sirin bol tongwi, “Na yawo krehamen ha di engwiwe, ni gran wine ongwo hobi talongwo wine olkime? Homena nerala di ongwo habang i, homa aling bigi sire nekimua,” dire sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tomba, Yisas yu ditongwi, “Ni yalhobi nin krehamen ha wine olere, te God krehamen ha talongwo si alibe oline? ");
INSERT INTO sll_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ena God yu di emiraya, Nimai, nabin aki di tere ha dinangwo wine olo, dimiraya. Te ha ta yu pamia. Yal ta irang aang gaung ha si tenangwiwe, si gonangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pamba, ni yalhobi iwe, yu diniraya. Yal ta tal ta a nenangiwe, nimai nabin aki di tenanga pamba, homa God tenga para tenua dinga i, i ta paikimua. ");
INSERT INTO sll_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nimai nabin aki di tenanga para wai panamba, ni yalhobi nin ha wine olere, te God ha wine olkinanga pamua. God ha maing nir si tengiwe, ni nin wine olkire hasu gran dirane si wanua. ");
INSERT INTO sll_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Homa God hana togu yal Aisaia awa ha dire, yal ta yu onamua, dimiraya, omaga ni yalhobi yu onga Aisaia dungwo meri nima omua. Aisaia iwe, ha yu di emia.");
INSERT INTO sll_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ari mongwo hobi iwe, grang bani God pir teiwa dimba, pir nomani sina ekimua.");
INSERT INTO sll_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yalhobi iwe, ari grang ha direre God dima dire di wamua. Warere God maa e tongwo paikimua.” ");
INSERT INTO sll_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ena Yisas arihobi wo dungwo u ku bongwi. Bongure Yisas yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Talhan mena dire u grana bani ongwiwe, ari nomani sina ol nigi de na tomo? I ta tekimua. Te talhan nomani sina ali a bona dire, grana bani mena ongwiwe, ari ol nigi de na tomua. Ha weni kara di ni teiya ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dimia grang wine ongwo hobi Yisas mongwo bani ure yu sirin bol tongwi, “Ni ha dingarai Perisi yalhobi nigi de pungwo i hano?” ");
INSERT INTO sll_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dungure Yisas yu ditongwi, “Ha maing pir sina engwo hobi God er yung kungwo meri momia. Hamen Nabe er ta kulkinangwo irai we olangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ha di yalhobi mongwo bani oleminia miling pir tekio. Perisi yalhobi iwe, ari omeling gi dungwo mongwo meri momia. Omeling gi dinangwo yal ta pire, omeling gi dinangwo yal ta aule ire unangwo hol hankun onam mo? I ta olkinama, yasuri ereho hogal sinangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dungure Pita yu ditongwi, “Yisasye, ha dingarai memini pir po sikiminia nin di tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dungure Yisas yu ditongwi, “Ayo, yal tau nomani ta paikimia ni yalhobi para nomani paikimo? ");
INSERT INTO sll_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ha i memini pir po sikino? Talhan tau mena direre, u gran bani nangwiwe, nomani sina i honamia, yon ala obil pirere emgi u yo maul ali namua. ");
INSERT INTO sll_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Te ari nomani si pinga gran bani u mena ongwiwe, ari nomani sina i ol gogo dal ni tomua. ");
INSERT INTO sll_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ari nomani si pinua diminga iwe, ari si gole, wou sire, tal gogo ole, kuni nere, hasu dire, gaung ha si tere yu ol wanua. Yu ol warere, nin nomani sina i ol hama si tenua. ");
INSERT INTO sll_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ena ani bigi sikirere homena nenangiwe, nomani ta ol nigi de ni tekinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ena Yisas yu di te pisolere, ere Taia Saidon ganba ongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pi mongure yol Kenan al ta bani ke pai molere, pi Yisas mongwo bani pire gala bir dire yu dungwi, “Yahuna, Yisas ye, ni Debit gang monia. Na auna kwia nigi dongwo yong sina molere, ol gogo dal tomia ni milna pinanga awai ol na tenanba?” ");
INSERT INTO sll_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dungure Yisas ha ta mong di tekima. Ditekungure, grang wine ongwo hobi hanere, Yisas yu ditongwi, “Al i dolni bol ure ha gobari di ni te i umia, ere po dito.” ");
INSERT INTO sll_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dungure Yisas yu ditongwi, “Isrel ari kun sipi sipi mongwo meri molere, simane sire, u gogo omia, God na nu si olungwo, Isrel ari hobi obil i ku bolala dire wiwa.” ");
INSERT INTO sll_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dungure al i u Yisas mongwo bani pa dire ikwi bole yu dungwi, “Yahuno, ni gogo aki di na to.” ");
INSERT INTO sll_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dimba Yisas yu ditongwi, “Kumil ama homena tenamgiwe, awi hobi tenamno?” ");
INSERT INTO sll_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dungure al i, “O na awi mongwo meri mole, uga mere di na tomua,” dipungwi. Di pirere yu ditongwi, “A. Yahuno, ni para dinia. Gir hobi homena nongwo moiring boi di yangwo awi nongwo pamia, nongwo meri na obilga neralba?” ");
INSERT INTO sll_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dungure, Yisas yu ditongwi, “Ha weni kara dinga, wai piria tal ta ol na tenama di pinanga meri ol ni teralua.” Dungure aung gintani u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ena Yisas ganba i pisolere, ere Galili nir digan bina ongwi. Pirere pi hamen hul ta ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mongure ari miki weni urere, omeling gi dungwo, grabeling a tongwo, kebering aling pema kengwo, nu nibil pangwo hobi para aule ire, Yisas mongwo bani u tabin sungwi. Tabin sungure Yisas awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ol tomia arihobi hanere, ganulun dungwi. Omeling gi dungwo pila dimio, grabeling a tongwo ha mining pamio, kebering aling pema kengwo hobi u wai omio, kebering bigi dungwo hobi hol wamia, arihobi hanere, “O God Isrel ari kene ol na tere, awai ol na tengi wai piminua,” dire God gun e tongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ena Yisas grang wine ongwo hobi di ku bole yu ditongwi, “Ari mongwo hobi iwe, hamen haung sui tai dire ereho baniya mominga, homena dikungure, mena gomia, na miling piriwe. Bai nu si olalga, bangi pire omeling malama di piriwa.” ");
INSERT INTO sll_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dungure grang wine ongwo hobi yu ditongwi, “Nan sinering gobo mominia homena ma dinangwo i tomingere nename?” ");
INSERT INTO sll_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yu dungure Yisas grang wine ongwo hobi yu sirin bol tongwi, “Ni nin homena breti talmere i une?” Dungure grang wine ongwo hobi yu ditongwi, “Breti ana hol pai muru hol pai sutani i uminio, te pisi sutani i uminua.” ");
INSERT INTO sll_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dungure, Yisas arihobi “ami dio.” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ditere Yisas breti pisi kina are, “O God homena i na tenga wai piminua” dungwi. Direre, a du dire grang wine ongwo hobi tongwi. Tongure yalhobi ire ebir sire ari hobi tongwi. Tongure ari hobi nere miing ongwi. ");
INSERT INTO sll_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Omia homena ya dungwo hobi i ku bolere, gal basket ana hol pai muru hol pai sutani girungwi. ");
INSERT INTO sll_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te ari homena ne mongwo hobi iwe, miki weni po tausen mole nomia, agr kumil ama para kerekima. ");
INSERT INTO sll_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ena ari hobi ere omia, yali nin molere, iri si sipi ala pirere, pi Magadan ganba pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ena Perisi yal tau ire, Sadiusi tau ire dire, Yisas mongwo bani ungwi. Urere yu sirin bol tongwi, “tal gumang hon dongwo ta i tibi olanga hanamingiwe, owa, ni God honagi yal monga pamua di hanaminua.” ");
INSERT INTO sll_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ditongure Yisas yu dungwi, “Girungwo hamen egin ongwo hanere, nimin sinamue, ari denamue, dinia, te honmil kwahawa kengwo hanere, nimin sinamue dinua. ");
INSERT INTO sll_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dingiwe, hamen egin ongwo i hanere, maing pir po sinba, tal ta u nima nangwo i pir po sikino? ");
INSERT INTO sll_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ari omaga malinga hobi tal gogo ol wanua. Talongwo ni yalhobi tal guma hon dongwo harala dire gala dine? I pisolo. God hana togu yal Yona hamen haung sui tai dire manala pai molere, hon ere mena ongwo meri irawe, omaga para ere yal ta yu onangwo hananga pamua.” Direre Yisas arihobi aidolere, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ena grang wine ongwo hobiwe, breti tau ire, nala dire, akun ol engwo bani kraung gi dungwo, pisolere, nir digan bina hoibi ongwi. ");
INSERT INTO sll_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pi mongure Yisas yu ditongwi, “Homena breti yis ere gangwo dere, u bir ongwo meri, Perisi Sadiusi yalhobi kina ha dire tal ongwo sidina dire, u bir ongwo namia, pir tekirala dire kwi, han molo.” ");
INSERT INTO sll_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yu dungure grang weni ongwo hobi nin ha diriala olere, yu dungwi, “Na breti ire huminiraya, di na tomua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Di pirere, yalhobi nin ha diriala ol mongure, Yisas yu ditongwi, “Breti ire hungarai han dikiminia, talongwo breti dikungwo ha diria ol mone? ");
INSERT INTO sll_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tal ominga irai maing han pa dikino? Na homena breti ana holulu ebir sire ari paib tausen tominga irai pirkinua do. Homena tau ya dungwo gal basket ana holo holo kebena sutani giringarai pirkino? ");
INSERT INTO sll_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te, homena breti ana hol pai muru ana hol pai sutani ari po tausen tominga irai, ere pirkinga pamia. Homena ya dungwo gal basket ana hol pai muru hol pai sutani giringarai pirkino? ");
INSERT INTO sll_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na homena breti ire hungi han dikiminia. Perisi Sadiusi ha dire tal ongwo sidina dire, u bir ongwo namia, pir tekire kwi han monana dire di ni tominua.” ");
INSERT INTO sll_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yu dungure yalhobi, “O, homena breti yis ere gangwiwe, ta han dikimia, Perisi Sadiusi kina ha nir si na tongwo i, a i si pire yu wakinama dire, di na tomua” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ena Yisas grang wine ongwo hobi kina ganba i pisolere, pi Sisaria Pilipai mala ongwi. Pi molere, Yisas yalhobi yu sirin bol pungwi, “Ari Wang Weni na molia, arihobi na hana dangwo talwa dime?” ");
INSERT INTO sll_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dungure yalhobi yu ditongwi, “Yal tau Yon nir bil tongwo yal i mona dimua. Yal tau God hana togu yal Ilaiya mona dimua. Yal tau God hana togu yal Yeremaia mona dimua. Te yal tau hana togu yal ta mona dimua.” ");
INSERT INTO sll_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dungure Yisas sirin bol tere yu dungwi, “Ni yalhobi nin na hana talwa dine?” ");
INSERT INTO sll_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dungure Pita yu ditongwi, “Ni God wang singaba Kraist monua.” ");
INSERT INTO sll_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dungure Yisas yu ditongwi, “Saimon ni yal Yona wang monia, milni pamua. Ha pangwo meri dingiwe, ari ta di ni tekimia, hamen nabe nin nomani ni tongure dinua. ");
INSERT INTO sll_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni ha dingi kara di hulu tenia, ni hulu dungwo meri monua. Te hulu bolimbani iwe, na ana mini hobi i ku bol eralga pamua. Egere nona pare monangure kwia ya ari tau ure isusu ol terala di onamba, kunu paikinamua. ");
INSERT INTO sll_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ena God kene ongwo hol hona grang hoiri ki miling ni teralua. Ganba bani molere, “Owa, tal ta i onanga pamua” dinangiwe, hamen bani para yu pamua dinamua. Te paikimua dinangiwe, hamen bani ere para paikima dinamua.” ");
INSERT INTO sll_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Direre Yisas grang wine ongwo hobi ha di nima pire, yu ditongwi, “Na Kraist molia, yal ta na hana dal tekio.” ");
INSERT INTO sll_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ena Yisas Yerusalem nala dire tal emgi u tibi nangwo awa ha i grang wine ongwo hobi di tibi ol tere yu dungwi, “Na Yerusalem nalgiwe, Yuda ari ha maing oo singaba ire, ha maing kene ongwo yal bir hobi ire, ha maing nir si tongwo yalhobi ire dire, tal gogo ol na tere na sinangwo, golalga pamua. Golere emgi hamen haung sui tai dire pai molere, hon airalga pamua,” direre ha yu di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tongure yal Pita Yisas auli nin bangi pire kura ha yu ditongwi, “Yahuno. Ni talongwo gonanga ha di homa ene?” ");
INSERT INTO sll_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yu dungure Yisas inaa dire Pita yu ditongwi, “Seten, ni ere po. God ha dungwo meri dikinia, ari ha dungwo meri dinia. Na pauna bli bonga i paikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ena Yisas hon ainere grang wine ongwo hobi yu ditongwi, “Yal ta na pir na tere, dolna bolala di pinangiwe, nin gaun nomani si pirkirere, talhan mobin hal wa tere, na gul pire, golalga meri ni ere gul pire golere, na dolna bonania. ");
INSERT INTO sll_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yal ta nin nin gaung pir tere monangwo yal iwe, emgi u talwo nangwo pamua. Yal ta na molga maing nomani si pir na tere grana wine ole moli pire, u talwo nangwo yal iwe, emgi gobari mol panangwo bani panamua. ");
INSERT INTO sll_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ena yal ta ganba bani talhan nomani tere wanamia. Wanamba, emgi talhan hobi hon siina dire aki di tenangwo nomani u wai nam mo? Ta honamua. Tal tobo tenangwo kunu benangure nomani hon i si giu diname? I ta dikinamua. ");
INSERT INTO sll_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ena Ari Wang Weni na molere, Nabe yulang irere, kwia ensel hobi kina ereho uralga pamia. Urere ari para muru tal ol na tongwo meri iwe, na hon ainaa dire yu ol teralga pamia. ");
INSERT INTO sll_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ari Wang Weni na mole uralga haung, omaga malinga hobi tau na na hanere, gonanga pamia, ha di ni tega i ogolo pir molo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ena emgi hamen haung ana hol pai muru hol pai taniga molere, Yisas ire, Pita ire, Yems ebering Yon kina ire dire, ere pi hamen hul bir ta mini bani pire, nin bangi molala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pi mongure Yisas gaung pol kulere, u talta gobere ongure hangwi. Ena Yisas grang gumang gal bani ari kulang gi dungwo meri yu olere, ba bomia hangwi. ");
INSERT INTO sll_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Han mongure Moses, Ilaiya kina urere, Yisas ha wai ol tomia hangwi. ");
INSERT INTO sll_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita hanere, Yisas yu ditongwi, “Yal Yisas ye. Nan yalhobi baniya mominga wai pamia, oo sui tai dire kenamina do. Kemingere ta Moses oo dinangure, ta Ilaiya oo dinangure, ta ni oo dinama do.” ");
INSERT INTO sll_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yu di mongure, kwahawa pege weni ta ure yalhobi mongwo bani yobilungwi. Yobilungure kwahawa sina ali ha ta yu di mena olungwi, “Yali na wana weni momia, milna ala pamia, yona milna teiwa. Yal i ha dinangwo ogolo wine ole piro.” ");
INSERT INTO sll_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ena ha iwe, yalhobi pire, ganulun dire, kul bir weni pire, ikwi bole mongwi. ");
INSERT INTO sll_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Momia, Yisas u pa dire, gaung bani arere, “Aire kul pirkio.” ");
INSERT INTO sll_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ditongure yalhobi ari ta monangwo harala dire wa dumba, Yisas nin mongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hanere ere ya ime urere, bangi Yisas ha di nima pire gamahobi yu ditongwi, “Talhan u tibi ongwo hangiwe, yal ta ha wai ol tekio. Ari Wang Weni na irawe, golalga, God na aki dinangwo airalga habang i, ari di tibi ol tenanua,” dire hobang si tongwi. ");
INSERT INTO sll_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Si tomia grang wine ongwo hobi Yisas sirin bol tere yu dungwi, “Lo ana holo holo nir si tongwo yalhobi Ilaiya homa u tibi namua dungwo i, talongwo dime?” ");
INSERT INTO sll_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dungure Yisas yu ditongwi, “Owo, yalhobi i ha weni kara dimia, Ilaiya homa u tibi pirere, talhan tau a kun ol enangwo bani iwe, yal ta emgi u tibi namua. ");
INSERT INTO sll_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yu onamiba, yal ta Ilaiya aibing maulung sire haya umua. Umiba, ari hobi han po sikere momua. Molere, tal gogo ol te momua. Ol tongwo meri Ari Wang Weni na iwe, ere yu ol na tenamua.” ");
INSERT INTO sll_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yisas ha yu dungure yalhobi, “Owo, Ilaiya aibing Yon nir bil tongwo yali maulung sire momiraya di na tomua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ena hamen hul mole ya ime ure u ari mongwo bani pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Pa dungure yal ta ikwi bole Yisas yu ditongwi, “Yal Yisas ye, na wana ya dani sire, u di nir ala pire, endo dongwo ali pire, momia, ni milna pinanga, awai ol tenanba? ");
INSERT INTO sll_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ni gran wine ongwo hobi mongwo bani awai ol tenama dire oiba, yalhobi ongwo kunu paikimua.” ");
INSERT INTO sll_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dungure Yisas yu ditongwi, “God tani onangwo pamia di pire, a i si wakingiwe, na molkiralga haung tal onane? Moli pirere emgi talongure na hon aki di ni tenamne? Gir i aule ire na molga baniya wo.” ");
INSERT INTO sll_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Direre Yisas kwia nigi dongwo kura ha ditongure gir i aidolere ere mena ongwi. Ongure gir i ya mongwi. ");
INSERT INTO sll_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ena Yisas nin mongure grang wine ongwo hobi u pa dire yu sirin bol tongwi, “Na yalhobi kwia nigi dongwo si doling i oliminga paikimia, tal onamne?” ");
INSERT INTO sll_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dungure Yisas yu ditongwi, “God nin onangwo pamia dire ogolo pir tere dikinia, onga paikimua. Er Mastet miling iwe, wainta weniga dimia, ni obil weniga ereyu pir na tenanga irawe, hamen hul i banta po dinanga ere namua. Te talhan para muru olala di pinanga meri iwe, para onanga panamua. ");
INSERT INTO sll_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Hamen Nabe aki di na to dire sirin bol tenangi kwia si doling i olanga panamia. Panamba, tal ta onanga paikinamua.)” ");
INSERT INTO sll_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ena Yisas grang wine ongwo hobi Galili ganba u ku bongwo haung iwe, Yisas yalhobi yu ditongwi, “Yal ta Ari Wang Weni na irawe, na aule ire pire ari tau na tenamia. ");
INSERT INTO sll_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tenangure na si gonangwo hamen haung sui tai dire pai molgere, God na aki dinangwo, hon airalga pamua.” Yu dungure yalhobi pirere Yisas miling pir tongwi. ");
INSERT INTO sll_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ena Yisas grang wine ongwo hobi kina ereho Kapaneam oo malgi ongure, ha maing moni takisi ingwo yal tau u Pita mongwo bani pa dire yu ditongwi, “Tisa doling bonga yal iwe, ha maing moni takisi ere tenam mo?” ");
INSERT INTO sll_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Dimba, Pita, “Owo, para tenamua” dungwi. Direre oo ala pi mongure Yisas Pita yu sirin bol tongwi, “Ganba kene ongwo yalhobi moni takisi ingwo i, ara tongwo ime? Ganba hong yal tom mo, wiyol tau tome?” ");
INSERT INTO sll_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dungure Pita yu dungwi, “A, i wiyol tau tomua”. Dungure Yisas Pita yu ditongwi, “Owo, para dinia. Ganba hong yal nan yalhobi iwe, takisi para tekinaminga pamua. ");
INSERT INTO sll_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pamba tekinaminga, ari nigi de pir na tenangwo pamia. Pitao, ni han ta irere nir digan bina ime pire pisi enana po. Engere ta homa weni sinangiwe, grang ali a paule hananga moni ta dinamia. Dinangwiwe, ire ure, ha maing takisi ingwo yali tenania. Tenanga moni iwe, ni nan takisi moni para kunu benamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ena, grang wine ongwo hobi Yisas mongwo bani pire, yu sirin bol tongwi, “God kene ongwo bani, ara yal bir mole kene oname?” ");
INSERT INTO sll_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dungure Yisas yu ditongwi, “Gir migi ta aule ire na molga baniya wo. ");
INSERT INTO sll_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Gir i hano. Yal ta God kene ongwo bani, pi molala di pinangiwe, gir migi galeng bolkirere, omeling haung gole, nomani wai pare mongwo meri molkinanga, God kene ongwo bani ta honanua. ");
INSERT INTO sll_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te God kene ongwo bani, gir migi mongwo meri moli ongwo hobi singaba momua. ");
INSERT INTO sll_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yal ta na hana wine olere, gir migi ta awai ol tenangiwe, gir migi obil awai ol tekinania, na para ol na tenanua. ");
INSERT INTO sll_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gir migi na hana wine olere, pir na tere monangwiwe, yal ta hanere, “Ni hasu onia, yu olkio” ditenamia. Ditenangure gir i pirere, na mobing hal wa na tere na aidolamia. Ha yu ditenangwo yaliwe, kwahulu bir weni ta nugung bani han hol erere, u di nir man ala pirere, gonangwiwe, oun denamo? Ta dekinamia, kulang panamia. Te na tal ol teralgiwe, tal oun dongwo ol teralgere, gul bir weni inamua. ");
INSERT INTO sll_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eke, ha maing hol dinangwo bani tal ta si pera dinangwo iwe, yal ta hanere, u kwaling ta nangwo i, nigi denamua. Nigi denamba, te yal ta si pera di enangwo yaliwe, nigi weni denamia, gul bir weni inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Te kebin ani weni hol i, tal nigi dongwo olere, pring au si ni terala di onangure, di keuru si olo. Yu olkinanga, kebin ani sutani ereho ya dinangure, moli pirere, endo de pangwo bani nanga wai panamo? I ta paikinama. Di keuru si olangiwe, olere kebin ani taniga dinangwo mol pai oli nanga wai panamua. ");
INSERT INTO sll_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te omin hol bani, tal nigi dongwo olere, pring au si ni terala di onangworai, omin si gi di olo. Yu olkinanga, omin su ereho ya dinangwo moli pirere, endo de pangwo bani nanga wai panamo? I ta paikinama. Si gi di olangiwe, olere omin taniga dinangwo mol pai oli nanga wai panamua. ");
INSERT INTO sll_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ena gir migi i nigi de pir tere mane bai tekio. Hamen bani ensel hobi iwe, God pai olungure, God omeling bani molere, gir hobi kene ol te momua. ");
INSERT INTO sll_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ari Wang Weni na irawe, ari tal gogo ole wa mongwo hobi u wai nama dire wiwa.) ");
INSERT INTO sll_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Yal ta kun sipi sipi miki weni wan handret kul nenamia. Nenangure, taniga u nin bangi nangwo aidolam mo? I ta aidolekinama. Wa dunangwo pamia. Kun tau ya monangwo hobi kul airing ne monangwo pisolere, taniga u nin bangi nangwo i, wa dunamua. ");
INSERT INTO sll_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kun tau ya monangwo hobi wai pinamba, te kun ta molkinangwo wa dunangwo kun iwe, i tibi ole hanere, wai weni pinamua. ");
INSERT INTO sll_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yu ongwo meri, Hamen Nabe gir hobi u gogo nama di pire kwi mole kene ol te momua. ");
INSERT INTO sll_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ni enin ta tal nigi dongwo ol ni terere, pring ya dinangwo monamia. Monangwiwe, ni yasu pi nin bangi pirere, di tibi ol to. Di tibi ol tenanga yali, tal olga i pisole, hon olkiralua dinangwo irawe, ni kina pana gale monanua. ");
INSERT INTO sll_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te di tibi ol tenanga yali pirkinangwo, yal su mo, yal sui tai dire monangwo bani pire ha dinanga meri hon di tibi olo. Di tibi ol tenanga yalhobi ha i kene ol monamua. ");
INSERT INTO sll_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te di tibi ol tenanga yali ere pirkinangwo, pi ha maing pungwo ari hobi monangwo bani pirere hon di tibi olo. Hon di tibi ol tenanga pirkinangwo, kara aidolangere, u hana pire ya molere, yal digan mongwo meri monamua. ");
INSERT INTO sll_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ena ganba baniya arihobi tal ta onangwo wai pamua dire yu wanangiwe, God ere hamen bani wai pamua dinamia. Te arihobi tal ta onangwo wai paikimua dinangiwe, God ere wai paikima dinamua. ");
INSERT INTO sll_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Te ha ta para yu pamia. Yal sutani mo yal sui tai dire na hana wine olere, banta u ku bonangiwe, ku bonanga bani na ere ure sina i molalga pamua. Yu pangwo ipire ni yalhobi monga sina i yal su yong tani ere God tal ta ol na to ditenangiwe, Nabe hamen bani mongwo i yu ol ni tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ena dimia Pita Yisas yu sirin bol tongwi, “Yahuna, Yisas ye, na ebinambi tal nigi dongwo ol na tenangwo pring panangwo i kri di olaminga hamen haung talmere ol tenamne? Ana hol pai muru hol pai sutani ol tenamin mo?” ");
INSERT INTO sll_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dimba, Yisas yu ditongwi, “Ana hol pai muru hol pai sutani pisolo. Habang habang para weni i ole te monanga bani monanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yu olere God kene ongwo bani wananga hol iwe, ari singaba king tal ongwo meri, ha di bole diralga piro. Ena singaba i honagi ari tau tobo mong siina di na tenama dire, gala di ku bonamua. ");
INSERT INTO sll_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bolere honagi ari ta tobo miki weni ten milion kina tenangwo i, hon na te aibing olo, dinamua. Dinamba, honagi ari iwe, na moni ta dikimua dinamia. ");
INSERT INTO sll_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dinangure, singaba i, “O dikungwo pai dungwi ni ya, gir kunga ya, eunbi ya, wani aun ya, bona gana para weni ari tau terere, moni bol neralua. Bol neralgiwe, na moni tobo ni tegarai, nan i aibing oliwa” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dinangure honagi yal i, ya manbi ikwi bole, gumang digan hole, singaba yu ditenamia, “Yahuno, ni milna pinanga, na han uning si olingere, molere moni na tengarai, emgi pring ni teralue.” ");
INSERT INTO sll_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dinangure ya singaba honagi yali miling pir tere, han uning si terere, moni tongwo nongwi, aidolamua. ");
INSERT INTO sll_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Olangure honagi ari ere maini pirere han tema olamba, honagi ari ening ta moni tobo tu kina tongwo yal i u monamia. Monangure hanere, pi nugung kulere, “moni ni tega nengarai, mong na to” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dinangwo yal i ikwi bole “Enambiyo, ni milna pinanga, na han uning si olingere, molere moni na tengarai, emgi ni te aibing olalue,” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dinamba, yali pirkirere, i halabusi olgere pai molere emgi pring na te aibing olamua di pinamia. ");
INSERT INTO sll_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ena honagi ari ening tau hobi tal onangwo i hanere, nigi weni de pinamia. Pirere, ha dire tal onangwo hobi hanere pi singaba honagi hong yal mongwo bani di tibi ol tenamia. ");
INSERT INTO sll_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ol tenangure singaba i honagi ari gala dire yu ditenamia, “Ni honagi ari digan maing nigi denga monia. Homa na moni ni tegarai, pring a gi dikia, ni han uning si olirawa. ");
INSERT INTO sll_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Oliba, te ni enin ta miling pirkirere, talongwo moni na to dire gala dine? Han uning si olanga pamiba.” ");
INSERT INTO sll_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yu dire talongwo i nigi de pirere honagi yal iwe, i halabusi olere gul bir tegere pai molere, emgi moni na te aibing olama di pinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ha i di wai sirere, Yisas ha memini di ba bolere yu ditongwi, “Ni enin ta tal gogo ol ni tenangwo pring panangwo i, i ole tekinangiwe, yasingaba honagi ari ol tongwo meri Hamen Nabe ereyu ol ni tenangwo gul bir inanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ena Yisas ha hobi di wai si terere, Galili ai pisolere, ere memini pirere, Yodan nulu kin egere iri si Yudia ongwi. ");
INSERT INTO sll_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ongure ari nibil pangwo miki weni doling bol omia, awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ena emgi Perisi yal tau doling bol pirere, kera kul terala dire yu ditongwi, “Nan krehaman ha lo memini panangwo al ta ire aidole onaminga wai panam mo, paikiname?” ");
INSERT INTO sll_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dungure Yisas yu ditongwi, “Ni yalhobi ha maing buku kere pirekino? Hamen haya God yal ol ere te al ol ere dimia. ");
INSERT INTO sll_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yu omiawe, yal ta irang aang pisolere, eungbi kina si daulere, u tani pire monamia. ");
INSERT INTO sll_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Molere nomani gaung tani enama dire ol e ni tomia, ni yalhobi nin ha dire a poira sinanga paikimua.” ");
INSERT INTO sll_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dungure Perisi Yisas yu ditongwi, “Moses al irere, aidolala di pinanga, pepa bol terere, aidolanga para pama dimua dungwiwe, talongwo dima dipine?” ");
INSERT INTO sll_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dungure Yisas Perisi yu ditongwi, “Moses yu dimba, te ni yalhobi nomani ta paikinga hanere, yu di ni tomua. ");
INSERT INTO sll_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tomiba, hamen haya God ol engwo haung yu ta onangwo paikimia, te ni yalhobi al ta inanga al iwe, yal wou sikinangwo aidolere al ta hon inanga, al i wou sinanua.” ");
INSERT INTO sll_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dungure grang wine ongwo hobi Yisas yu sirin bol tongwi, “Ni ha dinga i oun domia, al ta yal ta ikinangure, te yal ta al ikinangwo pamue.” ");
INSERT INTO sll_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dungure Yisas yu ditongwi, “Ha digiwe, ari para weni pire i wanangwo taman. God nin yal al tan tani yulang tenangwo irere yu wanamia. ");
INSERT INTO sll_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yal tau aang kul nongwo haung kun walga mongwo meri momia. Molere al ta ikiralua di pirere yaubi yamua. Te yal tau iwe, ari tau a i si molere, walga hai si olungure ya momua. Te yal tau God grang wine olala di pinangwo i ya monamua. Na ha diga oun domba, yal tau memini pinanba, yal tau pirekinania. Pinanga hobi iwe, a i si pire yu wananua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ena gin ta, gir miki tau aule ire ungure Yisas breng bani arere, God aki di to di tenama dire aule ire ungwi. Umba, Yisas grang wine ongwo hobi hanere, kura ha ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ditomba, Yisas manaa dire yu ditongwi, “Gir migima hobi na molga bani unamia, manaa di tekio. Gir iwe, God kene ongwo bani ari mongwo meri mole wamia. Ari hobi warala di pinanga, gir migi nomani pangwo meri panangiwe, para ha maing hol wananua.” ");
INSERT INTO sll_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yu direre Yisas gir hobi breng bani arere ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ena yal ta urere Yisas yu ditongwi, “Tisao, na talmere olere mol paralga bani parale?” ");
INSERT INTO sll_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dungure Yisas yali yu ditongwi, “Tal ta wai dungwo iwe, talongwo sirin bol na tene? God tani weniga wai momia. Ni mol pananga bani parala di pinanga, God krehaman ha para weni wine olere a i si wayo.” ");
INSERT INTO sll_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dungure yali Yisas yu ditongwi, “Tal krehaman ha we?” Dimba Yisas yu dungwi, “God krehaman ha yu pamia. Ari si golkio. Wou sikio. Kuni nekio. Hasu ditekio. ");
INSERT INTO sll_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nimai nabin aki di tere grang wine olo. Yal ta awai ol na tenama di pinanga meri iwe, ni ere para yu ol to.” ");
INSERT INTO sll_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dimba, yal i yu dungwi, “Na gir migi molga ali krehaman ha i pirere yu oli uga uga, omaga ari molia. Molere tal ta olalba?” ");
INSERT INTO sll_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dungure Yisas yu ditongwi, “Onga i para onba, tal taniga onangiwe, monanga yo tenamua. Talhan miki weni a nenga i, ari te mena olere, moni inangarai, ebir sirere, talhan a nekinangwo hobi tenana po. Yu onangere ni tobo wai hamen bani dinamia pire ha te inanua. Yu ol pisolere na guna hana pirere na dolna bolo.” ");
INSERT INTO sll_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yisas yu ditomia yali bona gana miki weni a neiraya, tal olale di pire, guman digan hole ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Omia Yisas grang wine ongwo hobi yu ditongwi, “Yal ta bona gana miki weni a nenangwo yal iwe, God kene ongwo holi wahangwo kulang panamo? ");
INSERT INTO sll_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","I ta paikinama. Kun hausi hai bun kiaing kuun engwo ali, nangwo oun domba, bona gana miki weni a nenangwo yal i, God kene ongwo hol i wanangwo oun go domua.” ");
INSERT INTO sll_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dungure yalhobi pire ganulun bir dire Yisas yu sirin bol tongwi, “God yal ara kene ol tenangure sigare kule u wai pire moname?” ");
INSERT INTO sll_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dimba Yisas yalhobi gumang bani tene yulang bole hanere yu ditongwi, “Ari nin kunu ta paikinamia. God tani kunu bemua. Talhan hobi God nin ongwo dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ena Pita molere yu dungwi, “Hano. Na yalhobi talhan para pisolere ni ni dolni bomgirawe. Tal ta hon inamin mo?” ");
INSERT INTO sll_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dungure Yisas yu ditongwi, “Ari Wang Weni na molia. Emgi mol pai ai wai kene ol molalga haung iwe, ni yalhobi Isrel ari para muru kene ol te monanua. ");
INSERT INTO sll_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yal ta na guna hana nomani si pir na tere, oo ya, ebering ya, keuni ya, irang ya, aang ya, gir kul nongwo ya, homena ya nongwo para pisolere nangwiwe, omaga malungwo haung, God mong pring hon siina di tenangure miki weni inangwo kunu benamua. Te mol pai gobari inamua. ");
INSERT INTO sll_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ena ganba baniya singaba moliwa di pire, hamel ha sira, eang dire, bol hona monangwo yal iwe, emgi hon u bisi namua. Te yal bina ta bol bisi ala monangwo yal iwe, emgi hon u bol hona i molere eang dinamua.” ");
INSERT INTO sll_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ena God kene ongwo hol iwe, maing yu pamia. Yal ta er wain miki weni kul nenamia. Kul nerere honagi ari igere u sina i honagi onama dire honmil sinamo namia. ");
INSERT INTO sll_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pirere yalhobi di ku bolere, ari haung tani honagi onanga, wan kina wan kina ni teralua dinamia. Yalhobi owo, para dinua dire, yong tani ere honagi onamia. ");
INSERT INTO sll_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Onangure wain hong yal omare, nain klok, pire hanamba, yal tau ya monangure hanamia. ");
INSERT INTO sll_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hanere yu ditenamia. Yalhobo, ni honagi ol na tenanga, tobo kunu ni teralue. ");
INSERT INTO sll_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dinangure yalhobi honagi oli namia. Nangure wain hong yal i omare twel klok ya, te, pudinangwo tri klok pi hanamba, yal tau ereyu ya monangure hanamia. Hanere homa dungwo meri yu ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ditere pudinangwo, paib klok, Maket pire hanamia. Hanamba, yal tau ereyu ya monangure hanere yu ditenamia, “Honmil ya mongarai, omare ya mongarai, pudungwo para, ya monio?” ");
INSERT INTO sll_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dinangure yalhobi yu ditenamia, “Na yalhobi yal ta honagi ebir si na tekungwo yawe.” ");
INSERT INTO sll_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dinamba, wain hong yali yu ditenamia. “Wain honagi ol na tenana pio,” dinamua. Ditere, ari ya benangwo haung, wain hong yal i, bosboi gala dire yu ditenamia, “Yahuno. Ni honagi ari di ku bolere, tobo to. Tenangiwe, emgi ure honagi ongwo hobi pe homa terere, te homa ure ongwo hobi pe emgi to,” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dinangure bosboi han molere emgi ongwo hobi wan kina wan kina tenamia. ");
INSERT INTO sll_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tenangwo hanere honmil sinamo ongwo hobi “O, na moni bir iralua” di pinamia. Di pinamba, homa ongwo emgi ongwo hobi para, tobo kunu kunu inamua. ");
INSERT INTO sll_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Irere wain hong yali nigi de pir tere yu dungwi, ");
INSERT INTO sll_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Yalhobi emgi umiraya, honagi obilga omia, te na yalhobi honmil sinamoki ure honagi ol mominga, mominga, ari dere bukuniminga irai hamen girimia, tobo kunu kunu na tengiwe.” ");
INSERT INTO sll_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dinangure wain hong yal iwe, urere, yal ta yu ditenamia. “Yahuno, nan homa yona tani erere, wan kina ni tenaminua diminga, ni para bemua dingirawe. Na tal nigi dongwo omno? ");
INSERT INTO sll_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Para ni tominia, ire po. Ni tominga meri iwe, honagi emgi ongwo yalhobi ere kunu yu tominua. ");
INSERT INTO sll_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tominga i, na nan hana paikimo? Na nan hana pamia. Na pirari pare tobo bir ni teya, ni nigi de pir na teno? dire wain hong yal yu dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dire Yisas hon ainere yu ditongwi, “Eno. Ganba baniya singaba moliwa di pire, hamil ha sira, eang dire bol hona monangwo yaliwe, emgi hon u bisi namua. Te yal bina ta bol bisi ala monangwo yaliwe, emgi hon u bol hona i molere, eang dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ena Yisas Yerusalem nala dire, grang wine ongwo hobi ana holo holo kebena sutani aule ire ongwi. Pi hol bangi pirere awa ha ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pino. Omaga nan yalhobi Yerusalem namna dire uminia. Pi pa dinaminga, Na Ari Wang Weni iwe, yal tau na han holere, ha maing ari singaba tau, lo ana holo holo kene ongwo yal tau na tenamia. Tenangure na ha hol ol na terere, ni sigolalua di na tere, na auli pire ari wiyol ta monangwo bani olamia. ");
INSERT INTO sll_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Olangure gauna ha sirere, homa kuba na sirere, er pera bani na si gonamua. Golere, ari habang sui tai dire pai molgere, emgi God hon ulna yunangure airalua” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ena Sebedi eungbi wang sutani aule ire Yisas mongwo bani ongwi. Pirere sirin bongwi. ");
INSERT INTO sll_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Bomba, Yisas aang i yu ditongwi, “Na tal ol ni terale?” dungwi. “Kene ole kemilanga haung na wana suri u dalni holo holi monamba?” ");
INSERT INTO sll_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dimba Yisas yu ditongwi, “Ni ha ogolo pir kun ole dikinia. Ni yasuri na gauna gul iralga meri inano?” Dungure yasuri, “Owo, para yu irabilua” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Para dinia. Na gauna gul iralga meri inania. Inanba, yal ta u na dalna holo holi monangure nu ke tenaminga paikimia. Nabe God nin hanere, nu ke terere, a yo te tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ena Yisas grang wine ongwo ana holo holo iwe, ha dungwo i pirere yong ki e tongwi. ");
INSERT INTO sll_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tomba Yisas gamahobo ana holo holo hon i ku bole yu ditongwi, “Baniya yal tau singaba molere, hamil ha sire gamahobi honagi ha ditongwo hanua. ");
INSERT INTO sll_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yu omiba, ni yalhobi ongwo meri olkio. Yal ta singaba molala di pinangiwe, ya ime sire nir honagi oli nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yal ta eang dire bol hona molala di pinangiwe, ya ime sire gamnahobi yon bani enangure awai honagi ol te monanua. ");
INSERT INTO sll_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ari Wang Weni na molere, olga meri onanua. Na iwe, hamil ha sire, honagi ha diterala dire, ta huiwa. Awai honagi olala dire wiwa. Ganba ari para weni pring pangwo ipire na gol tegere, sigare kule u wai nama dire, wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ena Yisas grang wine ongwo hobi kina Yeriko malgi u pa dungwi. Pa dire aidolere, ere ongure, ari miki weni u mobing engure ongwi. ");
INSERT INTO sll_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Omba omeling gi dungwo yal sutani homaulung ami di molere, “Yisas u omua” dungwo pirere yasuri gala bir dire yu dungwi, “Yasingaba Debit gang ye. Na yasuri milna pir na tomo?” ");
INSERT INTO sll_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dimba arihobi yasuri kura ha ditere “Sime molo,” ditongwi. Ditomba, yasuri pir uning sire gala bir dire yu dungwi, “Yal Yisas Debit gangye. Na yasuri milna pir na tomo?” ");
INSERT INTO sll_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dungure Yisas pirere ira mole yu ditongwi, “Na tal ol ni teralga meri pine?” ");
INSERT INTO sll_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dungure yasuri Yisas yu ditongwi, “Yahuno, na yasu omena gi dungwo a pila di na tenana di pibilua.” ");
INSERT INTO sll_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dungure Yisas yasuri miling pirere omeling bani a to sungwi. Sungure yasuri gintani omeling wai dungure talhan para weni hanere Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ena Yisas grang wine ongwo hobi ere pi Yerusalem mala weni pirere, Betpasi malgi hamen hul Olibi u pa dungwi. U pa direre Yisas gamahobi ya sutani bai nu si olere, yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Oo malgi yuwo hane. Malgi i pirere hananba, kun donki giri aang ta han hol enangwo hanania. Hanangiwe, haning gule i unana po. ");
INSERT INTO sll_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","I u nanga yal ta bani mole sirin bonangworai, “A, kun i yal Yisas honagi ol terala dungwo ire uminua, ditenanga, yali o, para dinia ire po dintenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ena tal omaga i tibi olangwiwe, God hana togu yal homa awa ha di engwo meri irai i tibi olamia. ");
INSERT INTO sll_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Awa ha iwe, “Saion oo malgi ari hobi yu dito. Ni yalhobi nin singaba irai umia, hano. Yaliwe, omeling haung gongwo yal momia, kun donki mobing bani au sire unamia. Te kun donki giri yal kun au sire unamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yu dimiawe, yasuri homa ongure Yisas homa ditongwo meri ongwi. ");
INSERT INTO sll_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Olere kun donki giri aang para ire ungwi. Urere galsina gulere kun mobing bani hau tongure Yisas au sungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Au simia ari miki weni gal gulere homaulung i e ya ime ongure, te yal tau er yolang ba dire homaulung bangi bangi engwi. ");
INSERT INTO sll_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Erere ari ya emgi homa ere Yisas i sina olere gala yu dungwi, “Debit gang wai pir to. God nin haang pangure yulang ire umia wai pir to. God para wai pir to,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ena Yisas Yerusalem ongure ari para weni hanere, ha mu dire yu dungwi, “Yali ara ume?” ");
INSERT INTO sll_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dungure ari ereho ungwo hobi yu ditongwi, “Yaliwe, God hana togu yal momia. Galili probins Nasaret hong yal irai ungwo hangiwe”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ena Yisas ere ha maing oo ala pire ha maing oo ala ari bisnis honagi ol mongwo hobi si doling i maini olere, moni sanisi ongwo hobi bol kina siru di olere, te hahoba maket engwo hobi bol se ere yu siru di olungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Olere yu ditongwi, “God ha yu di emiraya, Na ha maing oo ala i ari hobi na kina hawai ol na tere tere onamia. Onamba, ni yalhobi ol gogo danga, oo ala onga homena kuni ire, tal gogo ongwo meri para yu onua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ditere ala i mongure omeling gi dungwo yalhobi ire, kebering aling keber engwo hobi ire dire, u Yisas mongwo bani ungwi. Ungure Yisas awai ol tongure u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Omia ha maing oo kene ongwo hobi ire, Lo ana holo holo tisa hobi ire dire, talongwo i hanere yong ki ere pir momba, oo ala i gir migi tau gala bir dire Yisas yu ditongwi, “Singaba Debit gang ye.” ");
INSERT INTO sll_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yu dimia ari hobi yong ki bir erere yu ditongwi, “Gir hobi ha dungwo i pirkino?” Dimba Yisas “Owo i na piriwa,” dire yu ditongwi, “Ha maing buku ha di engworai kere pirekino? Ha iwe, yu dimiraya. Gir migi te, gir aming ne mongwo hobi God wai pir tenama dire nibil di tomia kere pirekino?” ");
INSERT INTO sll_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ditere ere maini pirere, Yerusalem aidolere, pi Betani malgi molere pangwi. ");
INSERT INTO sll_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ena honmil Yisas hon Yerusalem pire menan gongwi. ");
INSERT INTO sll_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Golere er kwasulu ta homaulung bina i bomia hangwi. Hanere mala pire hamba, miling ta holkirere aulung yamoni dimia hangwi. Hanere, er i yu ditongwi, “Miling hon holkinanua.” ");
INSERT INTO sll_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dungure er i gintani gongwi. Gomia grang wine ongwo hobi hanere, para grang giri gongwi. Golere yu dungwi, “Er i, talongwo gintani gome?” ");
INSERT INTO sll_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dimba, Yisas yu ditongwi, “Ni nomani su su sikere, God tani onangwo pamia di pir tenanga, na er i ha ditega meri iwe, ni yalhobi para yu onanga kunu benamua. Benangure er i tani taman. Hamen hul i hane. Hul iwe, sahala sire nir digan po dinanga namua. ");
INSERT INTO sll_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te ni yalhobi God onangwo pamia di pir tere molere, tal ta na to dire sirin bonanga, God ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ena Yisas ha maing oo ala pi pa dire ha nir sitongwi. Si te mongure Isrel ari singaba ire, ha maing oo kene ongwo yal ire dire, u pa dire yu sirin bol tongwi, “Ni ara yulang ni tongwo ire ure tal maing maing one?” ");
INSERT INTO sll_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dimba Yisas yu ditongwi, “Na ha tani weniga sirin bol ni tenaminia, ha mong siina dire di na tenano? Tenanga na yulang na tongwo yal iwe, maing di tibi ol ni tenaminua. ");
INSERT INTO sll_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yon nir bil tongwiwe, God yulang ire bil tom mo, ari yulang ire bil tome? Ni yalhobi ha mong di na to.” Ditongure, yalhobi nin bolbin dire yu dungwi, “Tal ha ditenamne? God yulang tongwo Yon irere nir bil tomua, dinaminba, te Yon ha pangwo dimia di pir tekino, di na tenamia. ");
INSERT INTO sll_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te ari yulang tongwo Yon irere, nir bil tomua, dinaminba, te arihobi Yon God hana togu yal mongwo hamiraya, kura ha di na tenama dire kul piminua” dire, ");
INSERT INTO sll_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yisas yu ditongwi, “Na yalhobi ha ta pirkiminua.” Dungure Yisas yu ditongwi, “Pireki dingiwe, na yal ta yulang na tongwo ire honagi olga yali, ere di tibi ole ni tekiralua.” ");
INSERT INTO sll_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Eno, na ha ta di ni tenaminga piro. Yal ta wang sutani monamia. Wang homini iwe, “Grep hani honagi ol na tenana po” ditenamia. Ditenamba, yali omeling pege dire nona panamia. ");
INSERT INTO sll_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nona panamba, emgi hon nomani si kulu sire pinamia. ");
INSERT INTO sll_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pirere honagi onamua. Te wang emgi iwe, ere yu ditenamia. Ditenamba, yali para dinua dire, emgi hon kuru dire wanamua. ");
INSERT INTO sll_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wanamia, irang iwe, ara kina tama ire molere honagi oname?” Dungure yalhobi pire mole, “Wang homini pi tege ere mole honagi onamua.” Dungure Yisas yu ditongwi, “Owo, para dinia. God kene ongwo bani nanba, ari moni takisi ingwo yal ya, te yal al nu nomane ol wangwo hobi iwe, God kene ongwo hol i homa e ni tere omua. ");
INSERT INTO sll_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ongure, Yon nir bil tongwo yal iwe, God ha maing hol i nibil di ni tomia. Tomba, ni yalhobi wine ole pir tekinua. Tekingere, moni takis ingwo yal al nu nomane ol wangwo hobi wine ole pir tomua. Tongwo haniba, ni yalhobi nomani si kulu sire Yon ha pangwo dimia di pir tekinua.” ");
INSERT INTO sll_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ena ha ta di ni teralga piro. Yal ta ganba bir weni dinamia. Dinangure u sire er wain kunamia. Kulere miling honangwo pere wain niri dirala dire maul ta wu enamia. Wu erere u si mo pire mini bani oo kere wain i kene ol monamia. Monangwo ganba i yal tau te olere, hong yali ere pi milin ta namia. ");
INSERT INTO sll_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pi molere, miling kul ema di pire, nir honagi yal tau wain niri dire enangwo tau inama dire, nu si olamia. ");
INSERT INTO sll_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nu si olamba, ganba te ole nangwo yalhobi a i si molere, ta sire, si gole, ta hulu si algi bil tenamua. ");
INSERT INTO sll_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yu onangure hong yal iwe, nir honagi yal tau miki tani hon nu si olere, ha homa dungwo meri ditenamia. Ditenamba, ganba te ole nangwo yalhobi homa ol tongwo mere yu ol tenamia. ");
INSERT INTO sll_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Emgi weni hong yal iwe, nin wang weni tani nu si olamia. Ganba tominga yalhobi na wana i tani gumang terere, grang wine ol tenamua, di pinamia. ");
INSERT INTO sll_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Di pinamba, ganba te ole nangwo hobi ure yu dinamia, “Ganba hong yal irai wang weni umia hano. Haniba, wang weni si gonaminga irai, ganba oo ai nan para muru inaminua” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Direre wang i a piru di mena pire si gonamua,” dire Yisas yu dungwi, ");
INSERT INTO sll_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Gonangure ganba hong yal ure, ganba te ole nangwo yalhobi tal ol tename?” ");
INSERT INTO sll_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dungure arihobi yu ditongwi, “Hong yal iwe, ure, ganba te ole nangwo yalhobi para weni si gol wai sire, ganba nin ire yal tau tenamua. Terere yu ditenamia, ni er miling kene ole honagi ol mongere kul enangwo pinanga, na tau nan na tere ni tau nenanua, ditenamua.” ");
INSERT INTO sll_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Direre Yisas ha hon ainere yu di tongwi, “Ni yalhobi ha maing buku kere pin mo pirekine? Ha maing buku yu dimiraya. “OO kengwo yalhobi torari ta ire ‘mebin damua’ dire pisolamia. Pisolangwo torari iwe, God nin aki di ire torari sinangure bring torari nima ongwo meri dinamua. God yu onangwiwe, moli omingere miling pare nablimua.” ");
INSERT INTO sll_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Buku yu dimiawe, God kene ongwo ni monga gaun bani dimia. Dimba, God nin ire ari wiyol tenamia. Tenangure ari hobi iwe, ha maing wine olere, a i si wanamia. ");
INSERT INTO sll_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wanangure, yal ta torari i gore olala dire onamba, nona pare yali gumang hol yanamua. Te torari yal ta biirangwiwe, yali biire dal dinangure u susu pire ganba danamua.” ");
INSERT INTO sll_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ena Yuda ha maing oo kene ongwo hobi ire, Perisi tau ire dire, Yisas ha bangi biire dungwo i, “nan yalhobi mominga bani umia” dire han honamba, arihobi Yisas God hana togu yal irai momua dire, nomani si pir tongwo yalhobi kul pirere aidolungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ena Yisas ha bangi biire hon ainere yu ditongwi, “God kene ongwo bani wananga hol iwe, yu pamia. ");
INSERT INTO sll_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ari singaba king ta wang al i terala dire homena si ganamia. ");
INSERT INTO sll_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Si galere ari wiyol tau u nenama dire boi honagi ari tau bai nu si olamia. Olangure homena nenangwo yalhobi hure nona panamua. ");
INSERT INTO sll_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Panangure yal tau hon nu si olere yu ditenamia, “Homena haya akun ol ere bulmahau yal kun ya giring tau para si kere anon ol ere uminia nenana wiyo” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dinamba yalhobi ha dungwo i yol e pirekirere, ususu pirere, yal ta bisnis honagi onangure, yal ta heba honagi onangure, yal ta stua honagi onangure, yal tau mu di ure, ");
INSERT INTO sll_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nu si olungwo yalhobi, a i si mole sire, si gonamua. ");
INSERT INTO sll_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Si gonamia gonangure, singaba king yong ki ere soldia tau nu si olangwo pire, yalhobi para si gol wai sire, oo ke pangwo para si gal olamia. ");
INSERT INTO sll_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Si gal olere singaba king gamahobo yu ditenamia, “Homena a non ol eminga ya dimia, homena nenama diminga yalhobi tal ongwo paikimia. ");
INSERT INTO sll_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ni yalhobi bli si homaulung holo holi pire yal tau monangwo hananga irai homena nenana wo ditere aule ire unana pio.” ");
INSERT INTO sll_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dinangure pi homaulung kwaling kwaling pirere, ari wai digan i mu dire aule ire unamua. ");
INSERT INTO sll_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Urere homena kenangwo oo ala si di dire monamua. Monangure singaba king i ari hobi harala dire oo ala i namia. ");
INSERT INTO sll_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pi hanamba, yal ta egin galkinangure hanamia. Hanere yu ditenamia, “Yahuno, na homena bir kere erin momingiwe, ni egin gale hunia, tal ongwo ya une?” Dinamba yal i gai golere ha ta ditekinamia. ");
INSERT INTO sll_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ditekinangure singaba gamahobo tau yu ditenamia, “Yal i kebering aling han sire pia si maini si bongwo ali olo. Olanga yali molere, aya maya dire siging girimil nure gi boi dire monamua.” ");
INSERT INTO sll_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Direre Yisas hon yu ditongwi, “God ari miki weni gala dimba, yal tani tani nu ke tenangure ala namua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ena yu dimia Perisi hobi pirere ha hongwi. Ha holere, Yisas ha di mere si tenamna di pungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Di pirere gamahobi tau ire, Herot gamahobi tau ire dire, nu si Yisas mongwo bani olungwi. Pirere yu dungwi, “Tisao, ni ha pangwo meri kara dinga piminia. Direre, te God mongwo maing ari para weni di ba bol na tengi piminia. Ni ha ta abiyame ere dikinia. Ari singaba te, yal bina hobi para kulung pir tere ta dikinia. Ha kara aru dire diteniraya. ");
INSERT INTO sll_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ena Lo ana holo holo mining bongwo iwe, moni takis yol Roman singaba Sisa to dim mo, tekio dime?” ");
INSERT INTO sll_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dimba yalhobi kera kule dungwo i, Yisas haya han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Ni ha gogo dina. Tal oma di pire kera kul na tene? Moni takis olinga taniga i ya wo na hanamna.” ");
INSERT INTO sll_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dungure moni ta i ure tongwi. Tongwo hanere, yalhobi sirin bol tongwi, “Moni piksa i ara breng biire eme?” ");
INSERT INTO sll_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dimba yalhobi yu dungwi, “I yasingaba Sisa breng biire emua.” Dungure Yisas yu ditongwi, “O para dinia. Sisa nin taling dinangwiwe, Sisa tenana po. Te God nin taling dinangwo iwe, God tenanga pamua.” ");
INSERT INTO sll_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yu ditomia yalhobi ha i pire ganulun dungwi. Dire Yisas mongwo bani han ole ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ena habang gin iwe, Sadyusi yalhobi tau Yisas mongwo bani ungwi. Sadyusi yalhobi ha maing ditongwo i, tere “Ari gongwo hobi hon ta airekinamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ena yalhobi iwe, Yisas mongwo bani ure yu sirin bol tongwi, “Tisao, Moses ha yu nir si tomiraya, Yal ta eungbi kina temine tere wiimbi gonamia. Gonangwo eumbi iwe, al werai molere, ebering ta gal enamia. Gal ere molere, al i na igere, gir kul enangwo, abinambi aibing maulung sinama di pinamua. Moses yu di embawe, na di ni tenamna piro. ");
INSERT INTO sll_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ena ebering hobo ana hol pai muru hol pai sutani kina mominia. Abimbi homini iwe, al i kina moli pire temini tere golala dire eumbi ebering ta i gal eyo ditere gomia. ");
INSERT INTO sll_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ena ebering iwe, hon gal emba, ereyu temini tere gomia. Ebering hobi para weni yu gal emba, temini tere gomia. ");
INSERT INTO sll_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","28","Gongure emgi al i para gomia. Emgi ari gongwo hon airamua dingiwe, airangwo habang al i ara eumbi moname? ");
INSERT INTO sll_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ebering hobi para weni gal engwiwe.” Dimba Yisas yu ditongwi, “Ni ha pir kun ole dikinia. Ha maing buku bol engworai kere pirkinga, te God yulang pai tongworai para pirkire du ha dinua do. ");
INSERT INTO sll_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ari gongwo airangwo habang iwe, kwia ensel mongwo tali molere, yal al ta hon si daulekinamia. ");
INSERT INTO sll_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ena God ari gongwo hobi hon airamua di emiraya kere pirekino? ");
INSERT INTO sll_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God yu di engwo pamia. Ni kwian moya Ebraham ire, Aisak ire, Yekop ire dire, maa e tongwo yal na tani God moliwa. Yal God ari gongwo hobi hobang mole kene ol tom mo? Ta tekimia. Ari hon mongwo hobi hobang mole kene ol tomua. Tongwo ipire kwiana moya Ebraham ire, Aisak ire, Yekop ire dire, kwiang hon momua.” ");
INSERT INTO sll_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dungure ari hobi ha dungwo i pirere bukunungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ena Perisi yalhobi Yisas Sadyusi yu ditomia Sadyusi grang nir mongure sime mongwi. ");
INSERT INTO sll_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mongure Perisi yalhobi u tani pi molere Lo kene ole nir si tongwo yal ta Yisas kera kul terala dire yu sirin bol tongwi, ");
INSERT INTO sll_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisao. Lo ana holo holo ha iwe, tal ha moyu ome?” ");
INSERT INTO sll_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dungure Yisas yu ditongwi, “Ni God tani yon milni tere, nomani si pir tere, kwian tere monanua. ");
INSERT INTO sll_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo ha tani iwe, kara moyu pire ha tau i manbi olimua. ");
INSERT INTO sll_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te ha ta sina ala, Ni nin ol na tenama di pinanga meri, enin tau para yu ol to. Ha sutani dikima, Moses krehaman ha Lo para muru dikungure. ");
INSERT INTO sll_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te ha sutani iwe, dikima, God hana togu yal ha grang u tani ongwo i, ta honamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ena gin ta Perisi yalhobi hon u ku bol mongure, Yisas yalhobi yu sirin bol pungwi, ");
INSERT INTO sll_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yasingaba Kraist mongwiwe, ara gang moma di pine?” Dungure Perisi hobi yu ditongwi, “Debit gang monamua.” ");
INSERT INTO sll_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dungure Yisas yu sirin bol tongwi, “God Kwiang Debit yong wu bungure molere, ‘Kraist na nan hobana momua’ di tibi olimia. Ena Debit yu di tibi olimiraya. ");
INSERT INTO sll_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Hamen ya singaba na hobana yu ditomia, “Ana weni holi ami di molo. Mongere kiani i unaminga doling i mena olanua,” ditomia. ");
INSERT INTO sll_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Te Debit nin ‘Na hobana monua’ ditomia, talongwo Debit gang momua dine?” Dungure yal tau ha pring mong ta ditekima. ");
INSERT INTO sll_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sirin bol tenamba, ha dungwo bani gai golere mongwi. Molere emgi ha ta hon sirin bol tekima. ");
INSERT INTO sll_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ena Yisas hon ainere, ari tau grang wine ongwo hobi kina mongure yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo ha nir sitongwo yalhobi, Perisi yalhobi kina, Moses ha di engwo i, hana togu yal mongwo pamia. ");
INSERT INTO sll_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Molere ha dungwiwe, ni yalhobi wine olere a i si wananua. Wananba, yalhobi nin ongwo meri olkio. God krehaman ha para weni di ni tomba, yalhobi nin a i si wakimia. ");
INSERT INTO sll_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yalhobi iwe, honagi oun dongwo ari hobi i au si tomia. Tomba, yalhobi nin aki dire ol tekimua. Talhan ongwiwe, arihobi para na hanama hanama di pire ol wamua. ");
INSERT INTO sll_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Te ha maing buku yalhobi nin si ainere hon bolere, boksi bir ala ere maulung bani te aling kwang bani han si ere wangwo hania. Te galsina arikri wangwo hania. ");
INSERT INTO sll_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te ari homena bir ke nenangwo haung iwe, iri si homa enangwo hanania. Te ha maing oo ala ere para iri si homa enangwo hanania. ");
INSERT INTO sll_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te arihobi hanere, “O, Tisao, Yahuno,” ditongure wai pimua. ");
INSERT INTO sll_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wai pimba, ni yalhobi kunu kunu moli nania, “Singaba Tisao” di ni tenangwo paikimia, na tani di na tenanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ganba baniya yal ta pir tenanga paikimia, hamen bani Nabe tani momua di pinanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te yal ta “singabao” di ni tenangwo paikimia, na tani singaba Kraist moliwa. ");
INSERT INTO sll_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni yalhobi moli nanga bani iwe, yal ta ya ime sire awai honagi ole wa monangwo yal i, yal bir monamua. Yal ta nin gaung di yuwo ere na singaba moliwa, te hamil ha siga yal moliwa, dire wa monangwiwe, haang ya ime sinamua. ");
INSERT INTO sll_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te yal ta nin gaung di yuwo eikire digan yal bina moliwa, di pire aunabo nure wa monangwo yaliwe, ari tibi monamua. ");
INSERT INTO sll_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ena Lo ha nir si tongwo hobo, Perisiye, ni yalhobi gran dirani sinia. God kene ongwo hol iwe, ari hobi si pera di tenia. Tere u kwalin ta ongere, ari tau ha maing hol nala di omba, ni homa e tere u kwalin ta onga i hanere, dolni bomua. ");
INSERT INTO sll_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ena Lo ha nir si tongwo hobo, Perisiye, ni yalhobi gran dirani sire nin ol wanga maing di kul sinia. Al werai tau mongwo hanere, oo kepangwo ala pi mole yulang a ura di tenia. Emgi oo ya, talhan a nongwo i yamoni inia. Irere God ha miki weni ditegere arihobi para na hanama di pinua. Yu ongiwe, God hanere tobo nigi dongwo ni tenamua.) ");
INSERT INTO sll_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ena Lo ha nir si tongwo hobo, Perisiye, ni yalhobi gran dirani sire nin tal onga maing di kul sinua. Te yu olere, nega de wagere, ari tau na grana wine onama di pinia. Pirere ni digan monba, gran wine ongwo hobi iwe, digan weni momia. Ni gran wine ongwo hobi kina para endo de pangwo bani nanua. ");
INSERT INTO sll_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aye, omin gi dino? Ha yu nir si tenia. Ha maing oo bir pir tere ani a pli di hole ha di yulang bonangiwe, miling ta paikima dinia. Te ha maing oo ala aiyulang egin gwal pir tere di bole ani a pli di hongiwe, miling pamua dinia. ");
INSERT INTO sll_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ni yalhobi nomani pama di pino? Nomani ta paikungure du tal onua. Aiyulang egin gwal ban ta dinangwo hanere talwo ta dima di hanania. Te ha maing oo ala dinangwo, “Owo, ha maing oo i aki di tomua,” di pinania. Pirere aiyulang egin gwal tani nomani si pir tenan mo, ha maing oo nomani si pir tenane? ");
INSERT INTO sll_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ena ni yalhobi ha yu nir si tenia. Ha maing oo ala bol pir tere di bole ani a pli di hongiwe, miling paikima dinia. Te ha maing oo ala bol talta God terala dire i bol bani enangiwe, pir tere ani a pli di holere, di yulang bonga i, miling pamua dinia. ");
INSERT INTO sll_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Dinga i wai pama di pire dino? I ta paikima. Homena yamoni banta dinangwiwe, i ya moni dinamia. Te homena ta i pire ha maing oo ala bol bani enangiwe, bol i aki di tenangure God wai hanamua. Homena nima pire bol i aki di tenangwo panam mo? I ta paikinama. Bol i nima pire homena aki di tongwo i, wai pamua. ");
INSERT INTO sll_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Ena yalta ha maing oo bol i hanere, ani a pli di hole ha di yulang bonangiwe, tal ta bol bani dinangwo i para di yulang bonania. ");
INSERT INTO sll_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te yalta ha maing oo hanere, ani a pli di holere, ha di yulang bonangiwe, ha maing oo tani taman. God maulung bani kina para di yulang bonanua. ");
INSERT INTO sll_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te yal ta hamen bani yuwo hanere, ha di yulang bonangiwe, hamen tani taman. God hamen bani mol pai omia, hamen bani di bole di yulang bonanga i, God maulung bani para di yulang bonanua. ");
INSERT INTO sll_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aye, Perisi yalhobo, Lo ha nir si tongwo hobo, ni yalhobi gran dirani sinia. Ho gu kengwo tali, te kwasuli hawi tal wo i, tau ana holo holo irere, taniga God tenga i, para wai pamba, God Lo ha moyu ongwo i, pir tere honagi para olkinia. Lo ha moyu ongwo i, yu pamia. Ari para muru awai ole a yo te tere, te tal nigi dongwo ol ni tongwo hobi iwe, yon milni tere, te ha panangwo meri ogolo weni dire tal panangwo meri ogolo wine ole moli nanga, ha maing Lo bir yu pamia. Pangwo ipire, wine oli pire ha migiga pangwo i, aidolanga paikimia. Para muru wine onanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ni yalhobi nomani pama di pino? Nomani ta pai ni tekungure, du ha dire ha maing nir si tenua. Ni yalhobi ha maing Lo migi migi iwe, gran bani u mena ongure wine onba, ha maing Lo bir iwe, yamoni homena tani ne dugu dire monua. ");
INSERT INTO sll_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aye, Lo ha nir si tongwo hobo, Perisi hobo, ni yalhobi gran kwal sinia. Gaun bigi sire gal pege wai sigiu dire wanba, nega dire don i mala engiwe, nomani sina i nigi domua. ");
INSERT INTO sll_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ni Perisi yalhobi nomani pama di pino? Nomani pai ni tekungure, du tal ol wania. Nomani nigi dongwo sire nega dire don i mala ekinangiwe, kwian sina te gaun para nabilamua. ");
INSERT INTO sll_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aye, Lo ha nir si tongwo hobo, Perisiye, ni yalhobi gran kwal si wania. Ari gongwiwe, i pire man wu ere ganba maini er pera sire egin wai tere hania. Te ari gongwo enga manala iwe, wai dim mo? I ta dikima. Hau malere gaung bli yangure, yulang tani dungwo hania. Ni yalhobi ari gongwo man wu engwo meri monia. Gaun bani egin tenga wai dimba, te kwian sina iwe, hau malimua. ");
INSERT INTO sll_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ari hobi gaun bolimbani hamia. Hamiba, nomani sina iwe, hasu dire tal nigi dongwo ol wania. ");
INSERT INTO sll_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aye, krehaman ha nir si tongwo hobo, Perisiye, ni yalhobi gran kwal si wania. God hana togu yal ire, ari tal dime dire ongwo yal ire dire, gongure, ari yulagi engwo gul i man wu ere oo wai ke tenia. ");
INSERT INTO sll_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tere yu dinga pamia. Na yalhobi hamen haya kwiana moya mongwo haung i, na molalga God hana togu yal si golkiralua di pinia. ");
INSERT INTO sll_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na kwiana moya God hana togu yal si golere, isusu ol tekirere, aki di tenaminga pamba dinia. ");
INSERT INTO sll_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kwian moya talime ole pring bir i wangwo meri ni yalhobi ereyu omaga i wa molere dinua. ");
INSERT INTO sll_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ni yalhobi ari nigi denga monia. God ari para na i mu dire, ha hol ol na tenangwo gin iwe, endo de pangwo bani holala di pino? Nania. ");
INSERT INTO sll_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ni yalhobi te pi makena berala di pine? Pi benanga ai ta dikimua. Pino. Na nan pirere ni yalhobi monga bani hana togu yal tau ire, nomani wai pangwo tau ire, ha maing nir si tenangwo tau ire dire, bai nu si olaminia. Olimgere, u pa dinangure, ni yalhobi tau si gole, tau er pera bani sire, tau ha maing oo ala kuba sire oo malgi ta monangure, doling i mena olingere, ere pi malgi ta monamua. Monangure, ni pi malgi i pire si doling i mena olania. ");
INSERT INTO sll_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yu onangiwe, yal ta si gonangwo God pring tenangwo i, ni hon i au sinanua. Hamen haya yal ta Ebel si gomia. Si gongure moli pirere emgi Sekaraia wang Berekaia iwe, ha maing oo ala bol mala si gonga i, God tobo nigi dongwo ni tenangure gul inania. ");
INSERT INTO sll_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hamen haya si gongwiwe, pring ni omaga malinga hobi para weni inia. Irere gul bir weni inanua. Na ha weni kara di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ena Yerusalem hong ye, Yerusalem hong ye, God hana togu yal ire, God nu si olungwo yal ire dire, nu si ni monga bani olimia. Olungure si gonia. Hoale aang giring di ku bol i hong ala ere kule pamia. Pangwo meri iwe, Yerusalem ari hobi di ku bolere iminba, nona pania. ");
INSERT INTO sll_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nona pangiwe, oon aibin i pisolgere, po ere dinamua. ");
INSERT INTO sll_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Omaga ni yalhobi na haniba, emgi hon na hankinania. Te, yal ta God haang pirere, wai piriwa dinangiwe, na ti hon na hananua. Di ni teya ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ena Yisas Yudari ha maing oo pisole mena ongure grang wine ongwo hobi Yisas ha maing oo hanama dire nibil di tongwi. ");
INSERT INTO sll_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ditongure Yisas yu ditongwi, “Oo i mama kengwo haniba, emgi hulu sigwi dire isusu olamua. Hulu dungwo hanga bani hon ta dikinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ena Yisas ere pi Olibi hamen hul mongwi. Mongure grang wine ongwo hobi nin obil u Yisas mongwo bani ure yu ditongwi, “Ni ha di na tengarai tal habang u tibi name? Hamen ganba wai sinangwo ni uralua dingiwe, ta tal u tibi nangwo hane momingere unane?” ");
INSERT INTO sll_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dungure Yisas yu ditongwi, “Yal ta ure kera kule ni bal ni tenamia, pir tekirala dire kwi han molo. ");
INSERT INTO sll_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ari miki weni u tibi pirere, na hana dalere, “na nan kraist mole wiwa” dinamia. Dinangwiwe, ari miki weni mole, “ha pangwo dimua” di pire doling bonamua. ");
INSERT INTO sll_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Te ni monga mala kura u tibi namio, ganba ban ta kura bonamua,” dinangwo pinania. Pinangiwe, ganulun dikio. Talhan i para yu u tibi nangwo hananiba, tal onangwo i hanere, hamen ganba wai sinangwo haung u tibi uma di pirekio. Emgi u tibi namia. ");
INSERT INTO sll_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ari wiyol ta pirere, wiyol ta kina kura bonamia. Yasingaba king ta gamahobi kina pirere, yasingaba king ta kina kura bonamua. Te ganba uling holo holi para weni menan bir u tibi namio, te ememe bir onamua. ");
INSERT INTO sll_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tal yu onangwiwe, agr gir kulala dire, gaung gul pungwo meri, ganba ya, talhan hobi gul yu u tibi namua. ");
INSERT INTO sll_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ena yu onangwiwe, ari hobi ni aule ire pirere, ha hol oun denangwo ol ni tere ni si gonamia. Te ni yalhobi na pir na tere monanga, arihobi hanere yong ki e ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ari miki ha maing pire a i si ware monamba, tal yu onangwo gin iwe, ha maing aidolamua. Ha maing aidolere, tabin tani singa hobi bai tal sirere, yong ki e tenamua. ");
INSERT INTO sll_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te hasu ari miki weni u tibi pirere “God hana togu yal moliwa,” dinangwo, ari miki weni pir tenamua. ");
INSERT INTO sll_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te ari hobi monangwo maing nigi weni denamia. Denangure God yong miling tere wa monamiba, tal onangwo i hanere, God yong miling tere monangwo i, isusu olamua. ");
INSERT INTO sll_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Olamba, yal ta God pir tere, yong miling tere, nima pire monangwo yal i, emgi ganba wai sinangwo haung God nin aki di inamua. ");
INSERT INTO sll_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","God kene ol na tongwo ha maing ganba uling holo holi pi kunu benangure, emgi ganba wai sinamua.” ");
INSERT INTO sll_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ena piro. God hana togu yal, Daniel, ha mining yu bol emiraya. Tal maing nigi weni dongwo ol terala dire u God ha maing oo hona airamua. Yu di engwo meri u tibi nangwo, hananua, dimia. Dungwo bominga i, memini pangwo kerere, ogolo piro. ");
INSERT INTO sll_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Onangwo gin iwe, Yudia molere, te pirere, hamen hul i molo. ");
INSERT INTO sll_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yal ta malgi molere, hanere, bona gana oo ala dinangwo ire nala di pirikio. Gin tani hamen hul po. ");
INSERT INTO sll_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yal ta homena ya nenanga gul i wa molere, hanere, galsina malgi dinangwo ire nala di pirikio. Gin tani hamen hul po. ");
INSERT INTO sll_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Al gir panangwo hobi, te gir aming ne monangwo hobi, tal oname? Kee, miling pirie. ");
INSERT INTO sll_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","God sirin bol tere tal onangwo te nanga haung i, nimin sire hair onangwo i tibi ol na tekio. Sabat haung para i tibi ol na tekio, di tere molo. ");
INSERT INTO sll_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Onangwo habang i gul bir u tibi namia. Hamen haya God ari talhan i para ol engwo haung gul ere yu u tibi ta humia. Emgi gul ere yu u tibi ta hunamia. ");
INSERT INTO sll_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te God gul pinangwo haung haya si gubu diralua di pungwo pamia. Di pirekinangwo, ari para muru u susu nangwo pamia. Pamba, God ari nu ke tongwo hobi pir terere, gul pinangwo habang si gubu dirala di pimia. ");
INSERT INTO sll_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yu onangwo gin iwe, yal tau urere, “Hanya olega. Kraist u timi momua,” dinangworai, yol e pirekio. ");
INSERT INTO sll_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gin ta emgi, Kraist hasu dungwo tabin, te hana togu hasu dungwo tabin u tibi namia. Pirere, tal guma hon dongwo olere, diu sirere, tal maing maing onamia. Olere, ari nomani isusu ol tenamua. Olere God ari nu ke tongwo hobi kera kul ni terala dire honagi bir weni onamia. Onamba, na homa talhan i olo u tibi hungure, awa tani di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","I pirere nomani si pire molio.” ");
INSERT INTO sll_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ena yal ta molere, Kraist u ganba po engwo timi momua dinangwo mo, yal i kul si mongwo timawe dinangwo mo, ni yalhobi yol e pir tere hoyo. ");
INSERT INTO sll_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hamen yong anigi ongwo hania. Hanga meri iwe, Ari Wang Weni na molere gintani uralga hananga dimia. ");
INSERT INTO sll_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ari para weni tal nigi dongwo olere, nomani kwian para si golere, yone pare monamba, Nabe kina mole uralga gin iwe, hau sipia mu sungwo meri sire gintani are siralga pamua. ");
INSERT INTO sll_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ena kura talime gul i u tibi pi wai sinangure, ari si bonamio, haba dekinamio, te hamen bani kulmoma yanamio, te hamen bani hamen yulang nimni mongwo hangiwe, ho tere hol wanangwo hananua. ");
INSERT INTO sll_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hananga gin iwe, Ari Wang Weni na hamen bani deu mining tal guma hon dongwo u tibi nangwo ari wiyol para weni hanamua. Hanere aya maya dire hai menamua. Me monangure Ari Wang Weni na yulana bir ire nimni molere, ari kulang gi dungwo meri na gauna bani yu dinangure, uralga ari para weni na hanamua. ");
INSERT INTO sll_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hanangure hamen bani bu mugu bu bir weni dinangwo, na ensel tabin hobi nu si olalgere, ganba uling holo holi pirere, God ari nu ke tongwo hobi i ku bolere, tabin tani si enangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ena er kwasulu ering bani kwi han monania. Mongere yolang bani hon pu dire, mini hon onangwiwe, nimin yanangwo haung u tibi nangwo hanania. ");
INSERT INTO sll_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hanere, “O, awa ha di engwo irai, omaga u tibi omia,” di pire molo. ");
INSERT INTO sll_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Monangere, ari omaga malungwo hobi ta gol wai sikinangure, talhan i para u tibi unangwo pamua di pire monanua. ");
INSERT INTO sll_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hamen ganba wai sinamba, na hana iwe, wai ta sikinamua. Ha weni kara di ni teya, ogolo piro. ");
INSERT INTO sll_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ena talhan diga hobi u tibi nangwo gin iwe, yal ta pir pa ta dikimia. Ensel hobi para pirkimio, te God Wang na moliba, para ta pirikio, Nabe tani weni muru pimua. ");
INSERT INTO sll_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yal Noa mongwo haung arihobi ol wangwo meri iwe, Ari Wang Weni na uralga habang para yu onanga pamua. ");
INSERT INTO sll_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Homa nimin bir weni sire, nir sire, olkungwo gin iwe, arihobi homena nere, nir nere, al ire moli pirere, yal Noa iri si sipi ala pire momia. ");
INSERT INTO sll_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nimin bir sire, nir sire, omba, yal Noa gamahobi para pi sipi ala mongure, nimin sire, nir sire arihobi para si gol wai simia. Yu ongwo meri iwe, Ari Wang Weni na uralga haung para yu onamua. ");
INSERT INTO sll_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ena yal sutani homena sina wa monangwiwe, God hanere ta aki di inangure, ta ya monamua. ");
INSERT INTO sll_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Al sutani gal maule homena bule monangure, God hanere, ta aki di inangure, ta ya monamua. ");
INSERT INTO sll_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yu onangwo pamia pirere, kwi mole han molio. Na uralga haung pir pa dikinua. Omaga ural mo, emgi ural mo, uralgiwe, pir po sikinia, kwi molio. ");
INSERT INTO sll_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ena yal ta oo ke pangwo kene ol monamia. Molere kuni inangwo yal ta unangwo haung pir po sire er kwi nu monamia. Molere ul paikirere, hon mole han monangure, kuni nerala dinangwo yali ala unamia. Unamba, oo hong yal hanere, hobang si tenamia. ");
INSERT INTO sll_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yu onamia pire ni yalhobi a non ole molo. Ari Wang Weni na molere uralga haung ta pirkinania, hon molere kwi molio. ");
INSERT INTO sll_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ena ari singaba ta honagi ari para weni di ku bonamia. Bolere, Na ha diga pir na tere nomani wai panangwo yal i hanere, yu ditenamia. “Na honagi ari hobi para weni ni ani bani e ni teya, kene ol molo. Te homena nenangwo haung homena to” ditere ere namia. ");
INSERT INTO sll_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yasingaba i hon urere hanangure, kene ongwo yal i honagi ditongwo meri, a i si ol molkima gai gongure, a i si ol monamia miling panamua. ");
INSERT INTO sll_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na ha weni di ni teya. Talhan kene wai ongwo hanere hon bosbe bir haang enangure, talhan para muru kene ol monamua. ");
INSERT INTO sll_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Te honagi a i si ol molkinangure, honagi hong yali haya hunama di pirere monamua. ");
INSERT INTO sll_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Molere honagi ari hobi sirere, nir bia nere, ha yul dire spak ole wa monamia. ");
INSERT INTO sll_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Molere, singaba i unama di pire honagi ol molkinamia. ");
INSERT INTO sll_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yu onangure singaba u pa dire, kene onangwo yal i gaung bani si go dal inamia. Irere pia si ha maing isusu olangwo yalhobi mongwo bani olamia. Olangure hai mere, maning bare, siging girimil nure, monamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ena God kene ongwo bani wananga hol iwe, ama gir ana holo holo mongwo bani di bole di enamna piro. Yasingaba ta unangwo haung amahobi pirere, hol bangi i tibi olala dire kewa lampi ire namia. ");
INSERT INTO sll_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ama hobi iwe, ana hol pai du dinamia, ana hol pai nomani wai panamia. ");
INSERT INTO sll_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Du dungwo ama iwe, lampi kerosin tulekire, wigi bani obil gal ire namia. ");
INSERT INTO sll_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Te nomani wai pangwo ama hobi iwe, lampi kerosin tulere, botol mugu ta tulere, ire namia. ");
INSERT INTO sll_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nangure al irala dire ongwo yali haya aule ire hunamia. Hunangure ama hobi ginangwo ulgi sire omeling oun denangwo ul panamia. ");
INSERT INTO sll_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Panangure ginangwo sinamo “Omaga umia, haya wo” dire gala dinamia. ");
INSERT INTO sll_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dinangure amahobi ganulun dire aire, lampi akun ole ire namia. ");
INSERT INTO sll_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nangure ama ana hol pai nomani wai paikirere du dungwo ama hobi yu dinamia. “Ama enambi hobo, ni amahobi kerosin tau na tenanba. Na ama hobi wigi bani obil gaminga gobirimua,” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dinamba, nomani wai panangwo hobi yu ditenamia, “Ayo, ni tenaminba, na lampi gobiramue,” dinamia. “Ni gine hobi nin situa pire hon bring si ganana pio” ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ditenangure amahobi wa du i namia. Nangure al inangwo yal i u pa dinamia. Dinangure ama ana hol pai kewa gale monangwo ama hobi al inangwo hobi kina ereho ala pire hoiri yole homena nere monamia. ");
INSERT INTO sll_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Monangure emgi ama du dungwo hobi u pa dinamia. U pa dire, “Yahuno, Yahuno, ni hoiri yaule na tomo,” dinamia. ");
INSERT INTO sll_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dinamba, singaba yu ditenamia, “Na ni ama hobi ni hankigarawe.” ");
INSERT INTO sll_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dire Yisas ha yu dire gumuling timi yu ditongwi, “Na u tibi pi ni teralga habang ta pirekinia, girungwo ural mo, omare ural mo, pirekinia, kwi mole han molo.” ");
INSERT INTO sll_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ena hamen hol wananga maing, yu pamia. Yal singaba ta ganba ulubi nala dire, honagi ari di ku bolere, honagi kun awi bona gana kene ol monama dire ebir si tenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Terere kene ongwo yal ta hulu paib tausen kina tenamia. Te yal ta tu tausen kina tenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te yal ta wan tausen kina tenamia. Yu te olere ere namia. Nangure moni paib tausen kina tenangwo yal iwe, gintani honagi nega dire ol i pirere propit paib tausen hon inangure, u ten tausen kina namua. ");
INSERT INTO sll_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te honagi yal ta tu tausen kina inangwo iwe, ere honagi nega dire ol i pire, tu tausen kina hon inangure, u po tausen kina inamua. ");
INSERT INTO sll_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Te wan tausen kina inangwo yal iwe, i pirere man wure moni kul si ere monamia. ");
INSERT INTO sll_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ena mol i pirere gin ta honagi hong yal i u pa dinamia. U pa dire honagi ari hobi di ku bolere, moni tongwo i ha di kunu olamia. ");
INSERT INTO sll_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Olangure paib tausen kina tongwo yal i u pa dire, Yahuno, ni moni paib tausen kina na tengarai, na honagi oli oga, moni gumiling paib tausen kina hol bani ungure, ten tausen kina omua.” ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ditenangure singaba honagi ari yu ditenamia, “Gir waiye, ni honagi ongi wai pamia. Ni grana wine onga i homa bona gana obilga ni tega kene ol monia. Omaga bona gana miki weni kene ol monanua. Omaga ni ungere nan yasu yona tani ere wai parabilua,” ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Te honagi yal ta tu tausen kina tenangwo yal iwe, u pa dire yu ditenamia, “Yahuno, ni moni tu tausen kina na tengarai, na honagi oli oga moni gumiling tu tausen iga u po tausen kina omua,” ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ditenangure singaba i, “Gir waiye, ni honagi onga wai pamia. Ni grana wine onga i homa bona gana obilga ni tega kene ol monia. Omaga bona gana miki weni kene ol monanua. Omaga ni ungere nan yasu yona tani ere wai parabilua,” ditenamia. ");
INSERT INTO sll_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Te yal ta wan tausen kina tenangwo yal i u pa dire yu ditenamia, “Yahuno, ni gaunbi haminga, nega dinga yal irai monia. Yal ta homena ya nongwiwe, ni dagi dire i holo ere bule neniraya. Te paba yalta ya nongwiwe, ni ereyu ol ware pe neniraya. ");
INSERT INTO sll_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yu ol wangarai, na kulni pir ni tere moni wan tausen kina na tengarai, man wure kul si ega ya dimia. ");
INSERT INTO sll_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Moni iwe, hanere nin iyo.” Dinamba ya singaba iwe, honagi ari yu ditenamia, “Ni honagi onga paikimia, omin pege hong yal monga pamua. Na yal ta homena ya nongwo tol di nominga hanere dinio, te yal ta paba ya nongwo ereyu tol di nominga hanere di na teniba, ");
INSERT INTO sll_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","moni ni tominga irai ni honagi nega di olere moni propet ta i na tekinia. ");
INSERT INTO sll_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na gintani urere, moni hobi nan iralua di ni tegarawe. Moni ire pire moni paib tausen kina honagi olere ten tausen kina ingwo yal i, tenana po. ");
INSERT INTO sll_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te yal tau tal tenaminga a i si wanangwo yal iwe, emgi talhan miki weni tenamua. Te yal ta tal tegere a i si wakinangwo yal iwe, obilga teralga yu wa monangwo i nan tol di iralua. ");
INSERT INTO sll_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Omeling pege honagi ongwo yal iwe, pia si maini si bongwo ali olo. Olingere aya maya dire, maning bare, siging girimil nure, monamua.” ");
INSERT INTO sll_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ena Ari Wang Weni na iwe, emgi siina dire uralia. Uralga ari para weni hanere, “O, hamen ganba singaba mol na tongwo yal irai umua” di pinamia. Te uralga habang iwe, ensel hobi kina ereho uralia. Urere ha hol ol ni teralga bani ami di molalua. ");
INSERT INTO sll_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Molgere ari para weni u gumana bani tabin sinamia. Sinangure kun kene ongwo yal iwe, kun sipi sipi meme kina ereho kene olere ebir sungwo hania. ");
INSERT INTO sll_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te na uralgiwe, ebir sungwo meri yu siralua. ");
INSERT INTO sll_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sirere ari tau i ana weni hol olere, te ari tau i ana holo hol olalua. Olere ana weni hol monangwo hobi iwe, yu di teralia. “Nabe ni yalhobi ni hanere, wai pir ni tere tal wai ol ni tomia, hamen haya God hamen ganba ol engwo haung iwe, mol pai nabilungwo ai akun ol engwo dimia, ure inanua. ");
INSERT INTO sll_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","36","Homa na menan gole molgarai, homena na tenirawa. Te na nir gole molga nir na tenirawa, te na oo banta yal uga na i ala enirawa, te na gal dikungwo gal na tenirawa, te na nibil pare molga na kene onirawa, te halabusi oo pai molga pire na kwi hanirawa.” ");
INSERT INTO sll_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","38","Yu di teralba, yalhobi ha pring yu di na tenamia. “Tal haung ni mena gole monga homena ni tomne? Tal haung ni nir gole monga nir ni tomne? Tal haung ni ganba banta yal unga na makena mole ni ala wo dimne? ");
INSERT INTO sll_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te ni gal ta dikungwo na gal makena mole ni tomne? Te ni halabusi ya, te nibil makena panga ni kene omne?” ");
INSERT INTO sll_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yu di na tenangwo na yu di teralia. “Na arina hobo moli ongwo hobi kultaing yal bina ta mongwo hanere, awai ol tengiwe, i na ol na tenua.” ");
INSERT INTO sll_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Dire inaa dire ana holo hol monangwo hobi yu diteralia, “God hau kuria nigi dongwo haya ni tomia ere pio. God Setan ire, ensel tabin hobi ire, endo bir dongwo bani olangwo ni yalhobi para nanua. ");
INSERT INTO sll_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","Na mena golga heba na tekinirawa, te nir golga nir na tekinirawa. Te na ganba banta yal uga ala wo dikinirawa, gal wa duga, gal na tekinirawa, te nibil pare halabusi pare diga na kene ol hankinirawa.” ");
INSERT INTO sll_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yu diralga yalhobi ha pring yu di na tenamia. “Ni makena ni homena gole monga na han uning simne? Te ganba banta yal unga te gal dikungwo ni han uning simne? Te nibil pare halabusi pare monga ni han gogo ol ni tomne?” ");
INSERT INTO sll_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dinangure na yu di teralia. “Na arina moli ongwo hobi yal bina kultaing mongwo hobi aki di tekinga pamia. Tekingiwe, yali nin ol teya di pino? ");
INSERT INTO sll_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","I na para ol na tenua. Ha weni kara di ni teya. Direre tal gogo onangwo yal hobi, tobo nigi dongwo teralgere, gaung gul i panangwo bani panamia. Te God grang wine onangwo yalhobi God nin aki di ire mol pai gobari weni tenangure, ire gun ere monamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ena Yisas ha i di te wai sirere, grang wine ongwo hobi yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hamen haung sutani wai sinangure homa God Isrel arihobi wang homini para weni si gonamba, han uning si tomua dire, homena si gal nere, God wai pir tere erin monaminia. Monaminga gin iwe, Ari Wang Weni na molgere, ari hobi na aule ire pire er pera bani na sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ena dungwo habang i, God bling mining oo singaba tau ire, yol Isrel ari singaba tau ire dire, pi nambawan Kaiapas oo kepangwo ala mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Molere Yisas kul si haning sire, sigolala dire, nomani sire ha hongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ha hole yu dungwi, “Ayo, ari erin mongwo habang iwe, nan tal yu onaminga kura panamia, aidole emgi yu onaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ena Yisas ere Betani malgi pirere, Yal Saimon hakubi dongwo homa awai ol tongwo yal iwe, oo kepangwo ala mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mongure agr ta ala ungwi. Airing iwe, wel santa kunu wai ungwo, tobo bir weni bongwo ta i ungwi. Ire ure wel i garu dire Yisas homena ne mongure breng bani bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bil tongure grang wine ongwo hobi yong ki ere yu ditongwi, “Wel i talongwo gogo bil tome? ");
INSERT INTO sll_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tobo bir bomiraya, ari tau tere moni inaminga irai talhan a nekungwo hobi ebir si tenaminga irawe.” ");
INSERT INTO sll_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dimba, Yisas ha i haya pir po sire yu ditongwi, “Al i nin haang pangwo meri omia, hobang si tekio. ");
INSERT INTO sll_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ongwiwe, tal wai weni ol na tongwo i hankino? Yal bina hobi iwe, ni yalhobi kina mol pai oli pirere emgi talhan tau aki di te monanga bani monania. Te na iwe, ni yalhobi kina gobari moli uminga irai para wai simia, emgi hon talta aki di na tenan mo? Ta tekinanga pamia. ");
INSERT INTO sll_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Omaga al i wel gauna bani bil na tongwiwe, golere ari yulagi engwo bani nalga ipire ol na tomua. ");
INSERT INTO sll_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ena God tal ol na tongwo ha maing i ganba ganba i para pi kunu benangure, al i tal ol na tongwiwe, ere yu di tibi olangure ari para nomani si pinamia. Na ha pangwo meri di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ena Yisas grang wine ongwo ana holo holo kebena sutani yalhobi mongwo sina i yal ta haang Iskeriot ganba hong Yudas iwe, Yuda ha maing oo singaba hobi mongwo bani pire, Yisas bai tal si terala dire, yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Na Yisas bai tal siralga, ni yalhobi hulu moni talmere na tenane?” Sirin bol tongure, yalhobi moni miling tri pela ten kina ebir si tongwo ingwi. ");
INSERT INTO sll_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Irere Yudas Yisas bai tal sirala dire kwi hane mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ena homena breti u bir hongwo nere mongwo habang iwe, erin bir weni ta u tibi ongwi. Ongure grang wine ongwo hobi Yisas yu sirin bol tongwi, “Na yalhobi pirere homena makena a kun ol e ni tenamne?” ");
INSERT INTO sll_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dungure Yisas yu ditongwi, “Yerusalem pire yal ta monangwo hanania. Hanangiwe, yu dito, “Tisa yu dimia piro. Na golalga habang mala umia ni oo ala gamina hobi kina homena nenaminia weran ta i tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dungure gamahobi pire oo hong yal i, i tibi ole hanere ha dungwo meri ditere akun ol mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ena hamen girungure Yisas grang wine ongwo ana holo holo kebena sutani kina ereho ami di mole homena ne mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne mongure Yisas yu ditongwi, “Nan yalhobi mominga sina i yal ta na bai tal sinania. Ha weni kara di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dungure gamahobi miling gul sungure gumang bani nin han iriala olere, yal tani tani aire, “Na yo? Na yo? A, i ta olkiralua.” ");
INSERT INTO sll_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ditongure Yisas yu dungwi, “Ni yalhobi monga sina i yal ta na bai tal sinania. Sinanga yal iwe, nan ereho ami di molere, homena pere bala tani ereho nir bole nobilua. ");
INSERT INTO sll_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ha maing mining ganing bol engwo meri irawe, Ari Wang Weni na golalga pamia. Te na bai tal sinanga yal iwe, emgi gul bir weni ikiralua di pino? Inanua. Nimai ta ni kul ekinangworai, na bai tal sikinanba.” ");
INSERT INTO sll_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dungure yal Yudas Yisas yu ditongwi, “Tisao. Na han dino?” Dungure Yisas Yudas yu ditongwi, “Ni nin dinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ena homena ne mongure Yisas breti ta irere, God homena na tenga wai piriwa dire, a du dire, yalhobi tere yu ditongwi, “Homena i na nan yulana ni teiya, ire no.” ");
INSERT INTO sll_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ditere, mulu hau wain nir ta irere, God hon ereyu ditere, yalhobi tongwi. “Ire no. ");
INSERT INTO sll_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nir iwe, na algi dimia. Na nan algi ari miki weni tal nigi dongwo ongwo God pring tongwo i wai sinangure, God bolo gumang puli ire u tani nama dire, tobo teiwa. ");
INSERT INTO sll_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na nir wain iwe, ni kina hon ta nekiralba, emgi nabe God kene ongwo bani pi molere, ni na kina hon nerabilua. Na ha weni di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ditongure ul geral ta di wai sirere, Yisas grang wine ongwo hobi kina ere Olibi hamen hul i ongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ena pi mongure Yisas yu ditongwi, “Ha maing mining ta yu pamia. God kun sipi sipi kene ongwo yal i sigonangure, kun sipi sipi hobi te ususu namua.” Yu di emiraya, ni yalhobi iwe, na aidolere, te ususu nania. ");
INSERT INTO sll_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nanba, na golere hon airalga iwe, homa e ni tere pi Galili ganba molalua.” ");
INSERT INTO sll_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dungure Pita Yisas yu ditongwi, “A, yalhobi te namba, na ni ai dolekiralua.” ");
INSERT INTO sll_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dungure Yisas Pita yu ditongwi, “Pitao, kenba, ginangwo na hana gin sui tai dire di kul sinangere hoale emgi be dinamua.” ");
INSERT INTO sll_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dimba Pita yulang bole yu dungwi, “A, ni gonangi na para golalua. Ni hani ta di kul sikiralua.” Dungure gamahobi para Pita dungwo mere doling bole yu dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ena Yisas grang wine ongwo hobi kina pi Getsemani u sina i ongwi. Pi pa dungure Yisas yalhobi yu ditongwi, “Ni yalhobi timi molo. Na ban ta pire nabe God ha wai ol terala oiwa.” ");
INSERT INTO sll_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Direre Pita ire, Sebedi wang Yems Yon suri ire dire, aule ire ongwi. Pirere, Yisas yong sina ering bai tabile hoho mo ungure, nomani si gogo olungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Olere yasu hobi yu ditongwi, “Na yona sina i erin bai tabile dimia, golalga mere piria, hon mole han molo.” ");
INSERT INTO sll_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Direre obilga ulubu pire, ikwi bole, God yu ditongwi, “Nabe, ni aki di na terala di pinanga, aki di na to. Tenanga omaga gul piralga haung u tibi ta hunama, di piriwa. Piriba, na hana ta paikima. ");
INSERT INTO sll_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ni dinanga pinaminua.” Di te pisolere, ere yasu hobi mongwo bani pire hangure, ul pai mongwo hangwi. Hanere Yisas Pita yu ditongwi, “Ni yasu hobi ulgi sire ul pai mongi tal ome? Hon molo di ni tegarai molkino? ");
INSERT INTO sll_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Seten ni kraun sire kera kul ni tenangwo manaa dinana dire yu onamia, ni ul paikirere, God tani pir tere, ha di tere tere molo. Nomani si pinga kulang pangwo yu olalua di pinba, te gaun oun dongwo timawe.” ");
INSERT INTO sll_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ditere, hon ere mena pirere, irang kina hawai homa ol tongwo meri hon ol tongwi, “Nabe hol su dikimia, gul piralga hol obil dimua dingiwe, para dinia. Ni dinga meri na wine olalua.” ");
INSERT INTO sll_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Di te pisolere, hon ure yasu hobi omeling oun dongure ul pai mongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hanere hon ere banta pire irang kina hawai homa ongwo meri hon ongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ol pisolere ere gamahobo mongwo bani ure yu ditongwi, “Ni yalhobi ul pare erin mono? Hanega. Na si gonama digarai mala umia. Ari Wang Weni na irawe, na han holere ari ha maing pirkungwo hobi na tenangwo pamia, ni yalhobi airingere namna pano. ");
INSERT INTO sll_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na bai tal sinangwo yal omaga umia, hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ena di mongure Yisas grang wine ongwo yal ta Yudas u pa dungwi. Dungure ari miki weni kina ereho ungwi. Ungwo yal hobi iwe, di kuba para ire ungwi. Ungwo hobi, Yuda ha maing singaba ya, Yuda kene ongwo hobi nu si olungure, ungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ungure bai tal sinangwo yali homa yu ditongwi, “Ni yalhobi hangere, na homa pirere, yal ta guma mu diralga yali han honanga yal monamia, hole aule ire pio.” ");
INSERT INTO sll_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ena Yudas homa Yisas mongwo bani u pa dire “Tisao, moldinio,” ditere guma mu dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dungure Yisas yu ditongwi, “Yahuno. Ni talta ol na terala dire unanga gintani ol na to.” Dungure arihobi para ure aling a i si molere, han hongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Homba, Yisas grang wine ongwo ta di baina ire Yuda singaba honagi yal ta di simia, kraung bol bali sungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sungure Yisas yu ditongwi, “A, yu olkire di aibing eyo. Te yalta di sinanga pring mong ni sinangwo gonanga pamia, pirikino? ");
INSERT INTO sll_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hamen Nabe gala diralga, ensel tabin ana holo holo kebena sutani bai nu si olangure gintani aki di na tenamia, pirkino? ");
INSERT INTO sll_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ensel hobi aki di na tenamba, ha maing mining ganing homa awa ha di engworai u tibi unamia, aki di na tekungure, tal han i u tibi ungwo, hangiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ditongwo gin iwe, Yisas inaa dire arihobi yu ditongwi, “Ni yalhobi na na han sirala dire, di kuba ire unia. Ungiwe, yal ta homena kuni nongwo han sirala dire un mo? Ya monga haung iwe, kinbe kinbe na kina ha maing oo ala ereho molere, ha di ni tega pinga irai, na han sikiniraya. ");
INSERT INTO sll_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yu oniraba, God hana togu yal homa awa ha di engworawe, omaga u tibi ungwo hanua,” dungwi. Dimiawe, grang wine ongwo hobi Yisas aidolere te ongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ena yalhobi Yisas aule irere, Yuda ha maing oo singaba, yal Kaiapas ke pangwo malgi ongwi. Ongure ha maing Lo tisa ire, ha maing kene ongwo tau ire dire, haya u ku bol mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Momia yal Pita Yisas ongwo mobing hol i doling bol ongwi. Pirere ulibi naa di mongwi. Mongure er kwi nu mongwo yal tau mena hol i ami di mongure, Pita omeling gaini han mongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ena Yuda ha maing oo singaba, te uku bongwo hobi, Yisas si gonama dire ha hol ongwi. ");
INSERT INTO sll_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Omba, ha dungwo hobo kungwi. Kumia ari miki weni airere, hasu dire kera kul tongure, ha ta u kunu homa. ");
INSERT INTO sll_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hongure hon yal sutani aire yu ditongwi, “A, yali yu dimiraya, Yuda ha maing oo bir na tule olere, ari habang sui tai dire gintani hon keralua dungworawe.” ");
INSERT INTO sll_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dungure Yuda ha maing oo singaba nambawan sina aire molere, Yisas yu ditongwi, “Ha di mere si ni tongwo i ni mong di tere molkino?”. ");
INSERT INTO sll_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dimba, Yisas pir uning si ole sime mongwi. Mongure Yuda ha maing singaba yu ditongwi, “God maulung bani sirin bol ni teralia, ha ta pinanga meri di na to. Ni maa e tominga yal God irawe, wang Kraist ni mono?” ");
INSERT INTO sll_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dungure Yisas yu ditongwi. “Owo, para molga hanere dinia. Dinba, Ari Wang Weni na iwe, God na i aleng weni hol i olangure molalia. ");
INSERT INTO sll_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Moli pirere emgi kwahawa bolimbani mole uralga hananga pamua.” Dungure ha maing singaba i nigi de pirere, nin galsina ongwo aulu dire, yu ditongwi, “Eke. God gaung ha sungwo pingiwe. Yal ta hon aire sirin bol pirikinamia. ");
INSERT INTO sll_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yal i ha gogo dungwo timawe. Gonam mo, Golkinam mo? Ni arihobi nin pinanga mere mere do.” Dungure yalhobi grang para muru, “Yal i pring bir pai tomia, gonamue.” ");
INSERT INTO sll_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Direre yal tau ebil si gumang bani bilere, kuba sire, didagi sungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Sire yu ditongwi, “Kraist ye, ni God hana togu yal mon mo domo? Ni sungwo yali hang arawe?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ena yu ol mongure Pita maini u sina i mongwi. Mongure ha maing oo kene ongwo yal boi honagi ama ta u pa dire, hanere, yu ditongwi, “Ni Galili hong yal Yisas gamahobo irai mongiwe.” ");
INSERT INTO sll_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ditongure Pita ha di kirulu di mena olere, “Haniraba, dinga pir kun olekiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Direre ere maini nala dire hona i ongwi. Ongure boi honagi ama ta Pita hanere, ari hobi yu ditongwi, “Yal ya, Nasaret hong yal, Yisas, gamahobo irai mongwo malawe.” ");
INSERT INTO sll_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dungure hon di kul sire yu ditongwi, “A, haniraba dinga pirkia, ha weni kara diiwa.” ");
INSERT INTO sll_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dungure emgi ari mala mongwo hobi Pita hon sirin bol tongwi, “Ni Galili ha howa tani pangwo timawe. Yisas gamahobo molkino?” ");
INSERT INTO sll_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dungure Pita God maulung bani di yulang bolere, “Na ha pangwo dikiralga God na sigonaamia, yali weni kara hankiwe.” ");
INSERT INTO sll_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dungure gintani hoale be dungwi. Dungure Pita Yisas ha homa ditongworai nomani si pirere, “Hoale be dikinangure, ni gin sui tai dire na hana di kul sinanua,” ditomiraya, nomani si pungwi. Pirere Pita maini pirere, min bile yare simile hai me mongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ena honmil sinamoki Yuda ha maing oo singaba ya, kene ongwo hobi para, Yisas si gonama dire ha hongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Holere, han sirere, aule ire pi nambawan gabman Pailat tongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ena gonama dire yulang bongwo i Yisas bai tal sungwo yal Yudas hanere, “Na pring ta pai na tekungwo bani iwe, tal nigi dongwo ole, bai tal si waga i nigi domua” dire, hon nomani si kulu si pungwi. Pirere moni miling tripela ten tongwiwe, hon i pire Yuda ari kene ongwo hobi mongwo bani pirere nin te aibing olungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Olere yu ditongwi, “Na yali hasu kera kule di wagarai gonangwo pamia. Tal nigi dongwo olia God pring na tongwo igayawe.” Dungure yalhobi yu di tongwi, “Na yalhobi hana ta paikimia. Ni nin hani pangwo di wanga irawe.” ");
INSERT INTO sll_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dungure Yudas miling gul sungure, moni i siru di ha maing oo ala olere ere ongwi. Pirere nin nugung han sire, gongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ena ha maing oo singaba hobi moni i gana di irere yu dungwi, “Ari gongwo moni tobo iwe, nan ha maing oo moni kina i mu dire gal tani girimingere, kunu ta paikinamua.” ");
INSERT INTO sll_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Direre yalhobi ha hongwi. Holere moni irere, mulu sin honagi ongwo yal ta ganba ya nongwo bring sungwi. Sungwo i, wiyol miling ta ure gonangwo man wu enaminua dire, ganba i, i tibi ol engwi. ");
INSERT INTO sll_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Emiawe, ganba i haang Algi Ganba dimua dire, haang engure omaga ya di pamua. ");
INSERT INTO sll_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Homa God hana togu yal Yeremaia awa ha di emiraya, omaga u tibi pire nima omua. “Isrel ari yal ta bring sinama dire moni pai tongwo meri tripela ten kunu inamia. ");
INSERT INTO sll_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Irere mulu sin ol enangwo yal ta ganba bring sinamia. Sinangwiwe, hamen yal bir God di na tongwo irai wine onaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ena Yisas Pailat gumang bani aire mongwi. Mongure Pailat sirin bol tere yu dungwi, “Ni Yuda singaba nambawan mono?” Dungure Yisas yu ditongwi, “Owo, para molga hanere dinua.” ");
INSERT INTO sll_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dungure Yuda ha maing singaba hobi ire, kene ongwo hobi ire dire, Yisas ha di mere si tongwi. Tomba Yisas ha ta mong ditekima. ");
INSERT INTO sll_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ditekungure Pailat yu ditongwi, “Ni ari ha hol ol ni tongwo i ha ta mong ditekino?” ");
INSERT INTO sll_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dimba, Yisas Pailat ha dungwo bani ere ha ta mong ditekima. Ditekungure Pailat nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ena erin habang homena bir si gale nere mongwo haung Pailat yal ta halabusi pangwo gule ole ole yu ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ongwo haung i, yal ta haang, Barabas, halabusi pangwi. ");
INSERT INTO sll_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pangure arihobi u ku bongure, Pailat sirin bol tere yu ditongwi, “Ni ara gule ole na tenama di pine? Yisas Barabas gule ole na tenama di pin mo, Yisas Kraist gule ole na tenama di pine?” ");
INSERT INTO sll_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yu direre arihobi Yisas ha hol ol tere nigi de pir tongwiwe, Pailat maing han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dire ha hol ongwo bol se bani ami di mongure eungbi yal ta bai nu si olere yu ditongwi, “Yal wai mongwo yali ha ta di bani ol tekio. Na girungwo ul pare ku hanere, yali piriga milna gul bir simua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ena Yuda ha maing singaba ire, kene ongwo hobi ire dire, ari hobi kraung are yu ditongwi, “Yisas aidolo. Sigonamia, Barabas gule ole na to.” ");
INSERT INTO sll_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ditere mongure nambawan gabman yu ditongwi, “Yal sutani momia, yal ta i gule ole ni tenamin mo, yal ta i gule ole ni tenamne?” Dungure arihobi mole, “Barabas gule ole na to.” ");
INSERT INTO sll_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dungure Pailat yu ditongwi, “Para dinia. Barabas gule ole ni tenaminia. Te Yisas haang Kraist enga yaliwe, tal ol tenamne?” Dungure arihobi para weni grang mu dire, “Er pera bani si golo.” ");
INSERT INTO sll_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ditomba Pailat yu ditongwi, “Yal ya tal ome? Tal ta ongwo hano?” Dimba ari hobi grang mu dire erakere dire yu dungwi, “Er pera bani si golo.” ");
INSERT INTO sll_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ha yu dinangwo kura bir i tibi olangwo pamia dire, Pailat “Yisas si gonangwo i pring na molga bani hunamia. Ni yalhobi nin hani panamua,” di tibi ol tere, nir ire, arihobi omeling bani aleng biging sungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sungure arihobi yu ditongwi, “Sigonangwo pring iwe, nan yalhobi mominga bani unangure emgi galna hon mali nangwo bani pring para pai namua.” ");
INSERT INTO sll_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dungure Pailat pirere, arihobi yong aura diterere, Barabas gule ole tongwi. Terere Yisas aule ire pire kuba sire, si gonama dire, soldia er kwi nu mongwo hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ena tomia soldia hobi Yisas aule irere, nambawan gabman opis malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pirere soldia para muru u ku bole mongwi. Molere Yisas galsina gule ole, galsina mori wai weni ta sigui ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ditere han galeng engwo ta irere, ama kere breng bani wa siru ditongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ditere kewa goliba aleng weni hol i wa e tongwi. Tere hasu kewa dire, maa e tere, “Yuda ari singaba irai monua,” dire, ebil si tere, kewa kuba goliba nin angwo i a tol di ire, breng bani dulagi sungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sirere gaung ha si te pisolere, galsina wai gule nin i pire, yali nin galsina hon sigiu ditongwi. Ditere er pera bani si gonama dire, aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ena pire hangure, Sairini ganba hong yal ta, haang Saimon, u guma erere yu ditongwi, “Yisas er pera haungwo i ni tol di haunana wo,” ditongwo, haungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Haungure Yisas aule irere, pi Golgota ganba ongwi. Ganba iwe, nan hana Ari Breng Yulang hul wa dinaminia. ");
INSERT INTO sll_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ganba i pirere, wain nir tulere nir gu kengwo ta i mu dire, Yisas nenama dire, tongwi. Tomba, Yisas obilga ne pirere pisolungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pisolimia arihobi aule ire pire, er pera bani sungwi. Sirere, galsina wangwo gulere, santu sire, win sungwo yali i ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ena er pera sungwo bani kwi molere han mongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Molere er gumiling bani iwe, ha di mere si tere ha hol ol tongwo meri mining yu bol engwi. “YISAS YUDA ARI SINGABA TANI MOMUE.” Dire yu bol engwi. ");
INSERT INTO sll_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Erere bina holo holi iwe, kura bolere, homena kuni nongwo yal sutani daling holo holo er pera bani si engwi. ");
INSERT INTO sll_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ena ari hobi wiriyala pire gaung ha sire, breng guma gama dire, grabalga ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ol terere yu ditongwi, “Ni ha maing oo bir i tule olere, ari habang sui tai dire hon keralua, diniraya. Ni God wang monanga, nimni mole wa di manbi womo.” ");
INSERT INTO sll_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ditongure ha maing singaba ire, ha maing Lo ha nir si tongwo hobi para gaung ha si tongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tere yu ditongwi, “Ari tau gongwo aki di tomiraya, nin gaung aki di tenam mo? Te Isrel singaba Kraist ye. Ni er pera bani pisole manbi womo. Unanga hanere, na yalhobi ni hani wine olere, a i si wanaminba? ");
INSERT INTO sll_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yali God pir tere mole, ‘na God Wang weni moliwa’ dimiraya. God wai hanere aki di tenam mo? Han monaminue.” ");
INSERT INTO sll_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dungure tal gogo ongwo yal su er pera bina holo holi si engwo hobi ere yu gaung ha si tongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ena omare ari u sina weni umba, hamen si bongwi. Si bongure moli ongwo ongwo, pu dungwo ari pera wangure, hamen hon tangwi. ");
INSERT INTO sll_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tangure, Yisas gala bir weni dire yu dungwi, “Eli, eli lema sabaktani?” Ha iwe, nan ha memini yu pamia, “Na God ye, na God ye, ni talongwo na aidoline?” ");
INSERT INTO sll_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dimba ari tau mala mongwo hobi gala dungwo i pirere yu dungwi, “Yal iwe, Ilaiya gala dima pino.” ");
INSERT INTO sll_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dungure yal ta gintani bli si ure, dimin baira me gu kengwo meri iwe, tal ta yu dungwo nir hol nongwo gal ali hongwi. Holere mugu homiri bli wa ki dire, Yisas nenama dire grang wangwi. ");
INSERT INTO sll_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wamba, ari tau mole yu dungwi, “A, i tekirere, han molo. Ilaiya urere, aule i manbi olam mo, olekinam mo, hanaminue.” ");
INSERT INTO sll_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dire mongure Yisas gala bir dire gongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gongwo gin iwe, Yuda ha maing oo ala gal apalapa bir han hol engwo iwe, sina si oulu di ya ime pirere, u sutani ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ongure ememe bir weni piga sungwi. Sire kwahulu si du dimio, te ari yulagi engwo bani ganba grang hongure God grang wine olere gongwo hobi si hon ere airungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Airungure Yisas emgi airere homa e terere Yerusalem ongwi. Ongure golere airungwo hobi para doling bole wangure, ari para hangwi. ");
INSERT INTO sll_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ena soldia ya, te kepten kene ongwo yal ta Yisas kwi mole kene ongwo hobi tal ongwo i hanere, miling giri golere yu dungwi, “Yal iwe, God Wang weni kara mongwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ena agr miki weni molere hamba, tal yu u tibi ungure han mongwi. Al hobi iwe, homa Galili molere, Yisas aki di terere, doling bongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Doling bongwo al hobi iwe, Maria Magdala ke pangwo ire, Maria diing Yems Yosep aang ire, Sebedi wang suri aang ire dire, mongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ena hamen girungure, Arimatia ke pare talhan miki a nongwo yal ta, haang Yosep, u pa dungwi. Yaliwe, Yisas ha dungwo wine ole gamahobo wangwo hobi yali para doling bongwo yal momia. ");
INSERT INTO sll_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Molere, ere pi Pailat mongwo bani pire, Yisas yone irala dire, sirin bol pungwi. Pungure Pailat mole, “Yone dimia ire to.” ");
INSERT INTO sll_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ditongure Yosep Yisas yone irere gal pege hon ta yobilungwi. ");
INSERT INTO sll_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yobilere ire pire Yosep nin golalga hulu grang ala i enamua dire nu ke engwo ala iwe, Yisas yone ala i engwi. Erere hulu bir weni ta akrigi sire kwaling bol pera di engwi. Erere ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ere ongure Maria Magdala, Maria diing kina ami di molere, tene han mongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ena honmil Sareba, hamen tangure, ha maing singaba hobi ire, Perisi yalhobi ire dire, Pailat mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pire yu dungwi, “Yahuno. Na yalhobi nomani yu si piminia. Hasu hong yal iwe, hon molere yu dimiraya. Na golere ari habang sui tai dire pai molere hon airalua. ");
INSERT INTO sll_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yu dungwiwe, grang wine ongwo hobo irai yone man wu engwo bani pire, kuni ire, te pirere, i kul si ere yal irai airimua dinangwo panamia. Dinangwiwe, ni soldia hobi di tengere, hona grang si pera mama di erere haung sui tai dire kene mama ol monamua. Molkinangwo, Yisas grang wine ongwo hobi emgi hasu dinangwo i, Yisas homa hasu ditongwo nigi domba, emgi dinangwo i nigi weni denamua.” ");
INSERT INTO sll_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dungure Pailat yu ditongwi, “Ni yalhobi soldia tau aule ire ongere kene ol monama pio.” ");
INSERT INTO sll_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dungure Perisi ha maing singaba kina Pailat grang bani pirere ere ongwi. Pirere Yisas yone engwo bani kwahulu bir mama weni si pera di erere, yal ta er kwi nu mongure, tau ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ena Sareba haung wai sungure, Sarebir honmil Maria Magdala hong al ire, Maria diing ire, al suri Yisas engwo bani harala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pi han mongure ememe bir weni piga sungwi. Sungure God kwia ensel hamen bani ya ime ure kwahulu hona bol pera di engwo i, i mena olere bolimbani ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mongure gaung bani hamen yong anigi ongwo meri gaung bani ba bomio, te gal pungwo bani iwe, pege au dale dimia hangwi. ");
INSERT INTO sll_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hangure soldia para hanere, ganulun dire kul bir pungwi. Pirere gaung nungure, ari gongwo meri ereme ire pai ongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ena ensel al suri yu ditongwi, “Ni al suri kul pirikio. Ni al suri Yisas er pera bani si gongworai wa dunga haminia. ");
INSERT INTO sll_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa dungiwe, baniya molkimia, haya aire si hon ere, ere omia. Homa ha di ni tongwo pinga meri irai yu omia. Ni al suri ure pangwo aibing hanana wo. ");
INSERT INTO sll_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hanere bli si pire Yisas grang wine ongwo hobi yu di to. Yisas gongworai si hon ere airimia. Yal i homa ere Galili omia, ni doling bol pire hanana po. Na ha di ni tominga i, i bangi olania, a i si ire pire, grang wine ongwo hobi di tenana po.” ");
INSERT INTO sll_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ena al suri kul pimba, ha yu ditongwo bani iwe, hon wai pungwi. Wai pirere, yulagi engwo bani aidolere, bli si pi malgi pire, grang wine ongwo hobi di terala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Omba Yisas gintani u pa dire yu ditongwi, “Al suro, widinio.” Dungure al suri Yisas gumang hanere, ya ami dire kebering bani are maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tongure Yisas al suri yu ditongwi. “Ni al suri na kulna pirikio. Ere malgi pire ebina hobi ditengere, pi Galili malgi ku bole molere na hanamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ena al suri ere ongure, soldia Yisas man wu engwo bani kene ol mongwo hobi tau tal ongwo i hanere, bli si Yerusalem pire Yudari ha maing oo singaba di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tongure Yuda ha maing oo singaba, kene ongwo hobi ku bol molere, ha hongwi. Holere soldia kene ongwo hobi moni bir weni terere yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Gongwo yal irai ul paminia, grang wine ongwo hobi ure yone ire te ongwo pamia. ");
INSERT INTO sll_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te nambawan gabman ha i pinam mo, pirikinam mo, dire, kul pirikio. Pinangure nan yalhobi gintani pire a ura di tenaminua.” ");
INSERT INTO sll_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dungure soldia hobi moni tobo tongwo irere, ha dungwo meri wine ongwi. Ena yu ongure hasu hawai ha iwe, Yuda ari mongwo bani si dinaa dire pai ongwo omaga ya pai momua. ");
INSERT INTO sll_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ena Yisas grang wine ongwo ana holo holo kebena taniga yalhobi Yisas Galili po ditongwo meri wine olere, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pi pa dire Yisas mongwo hangwi. Hanere pi tege ere mongwi. Momba, yal tau nomani su su sungwi. ");
INSERT INTO sll_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Simba Yisas mala ure yu ditongwi, “God yulang para weni hamen pire ganba pire nan na te pa dimia. ");
INSERT INTO sll_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","I pirere ni yalhobi ari ganba ganba di aulere, i na kebena bani tabin si enania. Erere Abe ire, Wang na ire, Kwiang ire dire, haang aine ei tere ha maing nir bil tenania. ");
INSERT INTO sll_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te na ha di ni tega i, ni yalhobi i pirere, nir si tengere ari hobi wine ol pa dinamua. Onangure na ari habang habang ni yalhobi kina si daule mol pai oli obilgere, habang pa dinangwo pamua. Na ha di ni tega i ogolo pirio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ena God wang Yisas Kraist iwe, ol wai ol na tongwo ha maing i kebereng holere, u tibi omia pinamna. ");
INSERT INTO sll_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Te ha maing i God hana togu yal Aisaia awa ha dire mining yu bol emia, God yu di emia. Na honagi ari ta bai nu sigere, yali homa ere hol bala di tenamia. ");
INSERT INTO sll_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bala di tenangure, ganba po engwo gul yal ta molere, “Talhan para weni hobang yal unamia hol bala ditere, akun onangere, u wai namua,” dire gala dinamua.(Mal.3:1) ");
INSERT INTO sll_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ena yu di engwo meri iwe, Yon ari nir bil tongwo yali, ganba po engwo bani u tibi pire mongwi. Molere, “Tal nigi dongwo ol wanga i, nigi de pir tere, nomani si kulu sire, hon olkirala di pire wayo. ");
INSERT INTO sll_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wananga na nir bil ni teralgere. God prin ni tongwo i, yole ni tenamua.” Dungure, yalhobi pirere, Yuda ari te Yerusalem ari para kri di u ku bol mole, Yon ha dungwo pire mongwi. Molere, tal nigi dongwo ol wangwo maing di tibi olungure yal Yon, Yodan nulu molere, arihobi nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ena Yon kun hamel eme galsina ware, onibani kun gang dere, hau guamoro, te denboma niring obil nere mongwi. Molere, “Yal ta na mobina hol unamia. ");
INSERT INTO sll_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Unangwo yaliwe, yal bir monamia na yal digan moliwa. Te na gal bala kine teralba, ganba ari digan moliwa. ");
INSERT INTO sll_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na nir wo bil ni teiba, yaliwe, God Kwiang ni tenangure, ni yon wu binangure kina ereho mol pai onanua.” ");
INSERT INTO sll_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ena ditongwo habang iwe, Galili ganba sina i Nasaret oo malgi Yisas molere, pi Yon mongwo bani pa dungwi. Pa dungure Yon Yodan nulu molere, Yisas nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tongure, Yisas ere mena ungure, hamen gintani sala du holo holo ongure, God Kwiang hahoba yumil mongwo meri mole, ya ure, Yisas brengbani mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mongure, hamen bani ha ta yu ya ime urere, “Na wana wai milna ala pania, yona milna ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ena God Kwiang iwe, Yisas gintani aule ire pi ganba pene engwo bani olungure, pire mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mongwo haung iwe, guung yalsu kebering aling poti ongwi. Ongure Seten ure, Yisas kraung sire, kela kul tongwi. Tongure, hau biing kina ereho mongure, ensel hobi urere, kene ol te mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ena Yon halabusi oo ala engwo pai mongure, Yisas Galili pi pa dire, God tal ol na tongwo ha maing di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Olere, “God kene ol na tongwo haung omaga mominia, ni yalhobi tal nigi dongwo ol wanga i, aidole, nomani si kulu sire hon olkirala di pire wayo. Ware God tal ol na tongwo ha maing a i si wayo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te gin ta Yisas Galili nir digan bir bina warere, hangure, ebering Saimon Endru yasuri pisi nir hau gal pia si nir ala olere, pisi si mongure, hangwi. ");
INSERT INTO sll_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hanere, yu ditongwi, “Ni yasuri ure na dolna bolo. Bonangiwe, na honagi tau nibil di ni tegere, nir hau singa meri ari yal al tau i na tenanua.” ");
INSERT INTO sll_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dungure, yasuri gintani pisi gal pisolere, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Omia, Yisas obilga ulubi pire hangure, yal Sebedi wang sutani ta Yems, ta Yon, yasuri sipi ala mole pisi gal soulu dungwo hon guwa si mongure hangwi. ");
INSERT INTO sll_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hanere, “ni yasu namna wo,” di gala dungure, irang Sebedi nir honagi yal tau sipi ala mongwo hobi pisolere, gintani ure, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ena omia, aule irere, Kapaneam malgi ongwi. Ongwo habang i Sabat haung u tibi ongure, Yisas ha maing oo ala pirere, ha nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Si tongure, yalhobi ha i pire ganulun dungwi. Ena Lo krehaman ha nir si tongwo yalhobi ha maing dungwo meri ta dikima. Yali ha maing hong weni momia, mole ha memini di tibi ole ditomia, arihobi pire ganulun dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dungwo haung iwe, yal ta kwia nigi dongwo yong sina mongure, u ha maing oo ala molere gala dire, ");
INSERT INTO sll_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yisas, ni Nasarete yal irawe, na nan hana pamia ni hani pamo? Ni na ol gogo dal na terala dire uno? Ni God ni bai nu sungwo yal monia, na ni han pa diwa.” ");
INSERT INTO sll_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ditongure, Yisas kura ha ditere, “Ni ha dikio. Ari yong sina i aidolere, ere mena po.” ");
INSERT INTO sll_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dungure, kwia nigi dongwo ya dani sungwo ol tomia, aya maya dungure, aidole, ere mena ongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ongure, yalhobi tal ongwo i hanere, grang dalungure, ha diria ole, “Ayo. Yali tal ol tome? I ha maing maing ta yulang kina kwia ha ditongure, pirere, grang wine omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ena Yisas tal ongwo guung haang iwe, gintani wa dire, Galili te, ganba bina holo holi para kunu bengwi. ");
INSERT INTO sll_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ena Yisas ire, Yems ire, Yon ire dire, ha maing oo pisolere, pi Saimon Endru oo kepangwo ala mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mongure, “Saimon woumbi gaung nega dungwo bol bani ul pai momua.” ");
INSERT INTO sll_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ditongure, Yisas u werang ta pire, al i aling arere, aki di airungure, nibil i gintani wai sungure, yamoni mongwi. Molere, ari nibil ongwo harala dire ungwo hobi, homena si gale tongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ena hamen hama sungure, ari nibil pangwo te kwia nigi dongwo yong sina mongwo hobi aule ire, Yisas mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ungure, ari tabin miki weni hona si di di mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mongure, Yisas nibil ongwo hobi awai ol tere, te kwia nigi dongwo yong sina mongwo hobi si doling i ole tongwi. Tongure, kwia Yisas gumang hanere, ha diterala di omba, manaa ditongure, ha ta dikungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ena honmil sinamo hamen hama sipangure, Yisas aire pi banta sina ering gobo ta molere, God kina ha di te mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mongure, Saimon oo kepangwo ala ari mongwohobi, “Yisas molkimua,” dire wa du i ongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pirere, mongwo i tibi ole hanere, “Ari para ni ni wa dumua.” ");
INSERT INTO sll_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ditongure, Yisas yu dungwi, “Na ari ganba bina holo holo kepai ongwo i, para wa pa di mena olalia. Yu olere, ha maing diteralga pamia. Na honagi iwe, tani pire wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Direre, Galili ganba bina holo holi para wa pa dire, ha maing oo ala ha nir sitere, te kwia nigi dongwo yong sina mongwo hobi si doling i ole tongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ena, hakubi dongwo yal ta Yisas mongwo bani pire kebering gulu bole molere, “Ni nebona i kri di olala di pinanga, i ole na tenanba?” ");
INSERT INTO sll_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dungure, Yisas miling pir tere, aling sine dire, gaung bani are, yu ditongwi, “Na olalia, gaun wigi sinangure, u wai nanua.” ");
INSERT INTO sll_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yu dungure yali nebona gintani wai sungure, ya moni mongwi. ");
INSERT INTO sll_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ena Yisas ha ering mongwo ditere, “Haya po. Ni u wai ongiwe, ari ta hawai ol tekio. ");
INSERT INTO sll_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Te ni gaun i, Yuda ha maing oo kene ongwo yali nibil di tengere, Moses ha dungwo meri grang wine olere, homena si gale God tenania. Tengere ari para ni han pa dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dire Yisas mana di tomba, yali pirkirere, ari para weni dite i ongure, ha i para weni u ganba bina holo holi ongwi. Ongure, Yisas oo bir malgi ta namba, ari huhu enama dire, angwo timi mongwi. Mongure, ari para muru Yisas tal ongwo ha i pirere, u mongwo bani pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yisas habang tau gobari Galili molere, emgi hon ere Kapaneam ganba ongwi. Ongure, ari hobi molere, “Yisas ere malgi umua” dungure, pungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pirere ari miki weni ungure, oo hona si di dungwi. Si di dungure, Yisas ala molere, ari ha maing di tongwi. ");
INSERT INTO sll_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Di te mongure, yal ta nibil ole kebering aling meginungwo yal sui sui dire erba hau ire, Yisas mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Umba, ari hona si di di mongure, iri si airing bani pire oo airing tulere, er kwiba bolo pia si ala olungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Olere, Yisas awai onangure yali wai monama di pungwo maing hanere, Yisas nibil ongwo yali yu ditongwi, “Wanaye, ni tal nigi dongwo ol wangere God prin ni tongwo i haya kri di ole ni tomua.” ");
INSERT INTO sll_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dungure, ari tau Lo krehaman ha kene ongwo nomani wai pangwo hobi ami di molere, “Yali talongwo ha yu di tome? ");
INSERT INTO sll_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","God gaung ha si tomia. God nin weni pring i ole tenangwo kunu panamia, ari wo ta yu olkinangworawa,” di han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ena yalhobi nomani yu si pire mongure, Yisas haya han pa dungwi. Dire yu ditongwi, “Talongure ni yalhobi nomani yu si pir mone? ");
INSERT INTO sll_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni nomani si pinga tal ha oun dome? Tal nigi dongwo, ol wanga God pring ni tongwo i kri di ole ni tomua, ditega kulang pam mo? Te, er kwiba ire malgi po di tega kulang pame? Er kwiba ire ere malgi po diteralga kulang panamo? ");
INSERT INTO sll_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","I ta paikinama. Te Ari Wang Weni na molia, God yulang na tongure, ganba bani tal nigi dongwo ol wangwo God pring tongwo i kri di olalga han pa dinanua.” Yu direre, nibil ongwo yali yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ni di ni teiya, aire er kwiba ire, ere malgi po.” ");
INSERT INTO sll_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ditongure, yali gintani aire, er kwiba ire, ere ongwo hanere, yalhobi ganulun dungwi. Dire God ma e tere, “Na homa talta yu u tibi nangwo hankiminga irawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ena, Yisas ere mena pire, Galili nir digan bina wa mongwi. Mongure, ari tabin bir weni u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","U pa dungure, Yisas ha nir si te i ongwi. Pirere, yal Alpias wang Libai mongure hangwi. Libai iwe, ami di mole, moni takisi i mongure hangwi. Hanere, yu ditongwi, “Ni ure na dolna bolo.” Yu dungure, doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ena haung ta Yisas Libai oong ala mole homena ne mongwi. Mongure, ari moni takisi ingwo yal miki ire, hana yal miki ire, Yisas grang wine ongwo tau ire, para homena ne mongwi. ");
INSERT INTO sll_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne mongure, Lo krehaman ha tisa ire, Perisi yal ire dire, hanere, gamahobo i sirin bol tongwi, “Talongure Yisas yalhobi kina homena ereho ne mome?” ");
INSERT INTO sll_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dungure, Yisas pirere, Perisi yu ditongwi, “Dokta iwe, ari yamoni mongwo i gaung bani honagi ta ol tekimia, nibil pangwo yalhobi honagi ol tomia. Na iwe, ari tibi mongwo hobi i ku bolalga, taman. Ari hana ya mongwo hobi i ku bolala dire, ya ime wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ena habang ta Yon grang wine ongwo hobi ire, Perisi gamahobi ire dire, homena hobi para mai tere ya mongwi. Mongure, yal tau urere, Yisas sirin bol tongwi, “Yon gamahobo te Perisi gamahobo haung ta homena hobi para mai tere ya mongure, ni gran wine ongwo hobi homena mai tekimia talongure homena nere nere mome?” ");
INSERT INTO sll_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dungure Yisas yu ditongwi, “Yal ta al hon inangwo habang iwe, ari yol e nongwo hobi homena mai tere monamo? I ta molkinama. ");
INSERT INTO sll_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yol e nongwo hobi bolo para molere, homena nenamua. Yu onamiba, emgi al inangwo yali pi banta monangure, yol e nongwo hobi miling gul sinangure homena mai te monamua. ");
INSERT INTO sll_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Te ari gal goling bali sinangwo bani gal hon bol ere sibirangwo kunu paikinamia. ");
INSERT INTO sll_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sibirangwo iwe, a i di sina pire hon ere bali bir sinamia. Te ari nir wain hon holere, meme gang mugu goling ali garu dikinamia. Garu dinangure, miing ure, meme gang i si gala dire, nir wain iwe, u ganba bani namia. Ari han pa dire meme gang hon irere, nir wain hon tulangure, meme gang iwe, nir wain i kina mama dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ena Sabat habang ta Yisas grang wine ongwo hobi tau aule ire, paba ya nongwo sina wangwi. Warere, yalhobi paba ta pe nongwi. ");
INSERT INTO sll_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nongure, Perisi yalhobi hanere, Yisas hawai ol tongwi, “Pino, yalhobi tal ongwo i Sabat na mana dungworai, ni gamnahobo du dire paba gogo pe nomo?” Dimba Yisas i ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","“Ni yalhobi kwiana moya Debit tal ongwo maing mining bol engwo irai, kere pirkino? ");
INSERT INTO sll_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayata ari singaba mongwo habang iwe, Debit menan golere, ha maing oo ala pire, homena breti tau God maulung bani dungure, ire nomia. Nongwo homena i mai tenama dire emia. Erere ha maing oo kene ongwo yalhobi nin muru nenama dire di tibi ol tomia. Ol tomba, Debit ire gamahobi tere nomia. ");
INSERT INTO sll_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","God ari ol engwiwe, Sabat erin habang ba e tomia, te Sabat ol engwiwe, ari ba e tenangwo taman. ");
INSERT INTO sll_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ari Wang Weni na molere, Sabat habang para hobang molga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ena Yisas ha maing oo ala hon ongure, yal ta aling kebir engwo mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ena ari tau Yisas Lo ana holo holo isusu olangwo irai ha di mere si tenamna di han mongwi. Molere, Yisas Sabat haung awai ol tenam mo, tekinam mo, dire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mongure, Yisas aling kebir engwo yal i yu ditongwi, “Ni aire u gumana holiya wo.” ");
INSERT INTO sll_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yu direre, ari hobi yu ditongwi, “Lo ana holo holo talwa dungwo pine? Sabat habang nibil panangwo awai ol to dim mo, ol gogo dal to dime? Ari aki di to dim mo, si golo dime?” ");
INSERT INTO sll_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yu dimba, arihobi pir uning si mongwi. Pir uning si mole nona pangure, Yisas yong ki engwi. Embawe, miling pungwi. Pirere, yu ditongwi, “Ni ani sine do.” Dungure, yali sine dungure, aling wai dungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ena yu ongure, Perisi yalhobi ere mena pirere, Herot gamahobo wa dungwi. Wa dure mongwo i tibi olere, Yisas si golala dire ha hol albe engwi. ");
INSERT INTO sll_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ena Yisas grang wine ongwo hobi kina ere Galili nir digan ongwi. Ongure, ari tabin bir weni doling bol ongwi. Galili ari ungure, ");
INSERT INTO sll_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yudia ari ungure, Yerusalem ari ungure, Idumia ari ungure, Yodan nir bina hoibi holbani ari ungure, Taiya ari ungure, Saidon ari ungwi. Ena Yisas tal ongwo i ari hobi ha pirere, ungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","Urere, pi Yisas mongwo bani ongwi. Ongure, Yisas awai ol tongure, nibil pangwo hobi Yisas gaung arala dire wara kengwi. Te kwia nigi dongwo yong sina mongwo hobi iwe, Yisas gumang hanere, nin yare habilai sire gala dire yu dungwi, “Ni God wang monua.” Yu dungure, Yisas ha di yulang bole yu ditongwi, “Na hana dal tibi olekio.” Ena ari taporal u yobilema dire, Yisas grang wine ongwo hobi yu ditongwi, “Ari tabin bir weni u molere, na egerangwo pamia, sipi bolimbani monamna, i mala wo.” Dungure, sipi i mala ungure, Yisas pi bolimbani ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ena Yisas sipi pisolere, ere mena pire pi hamen hul ta ongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pi molere, honagi ari tau irala dire, gala di ku bongwi. Ena yalhobi u tabin sungure, ari ana holo holo kebena sutani i tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Olere, “Ni yalhobi na gamnahobo weni monia, ni bai nu si olgere, ha maing ditere, kwia nigi dongwo si doling i olanua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ena i tibi olungwo yalhobi ta haang Saimon haang hon Pita engwi. ");
INSERT INTO sll_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te ta Yems, ta Yon, yasuri Sebedi wang mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mongure, haang hon Boanesis, haang iwe. Yui ha hamen guru yal momia. Te ta Endru, ta Pilip, ta Batolomyu, ta Matyu, ta Tomas, ta Yems momia. Yems iwe, yal Alpias wang mongwi. Te ta Tadias, ta miling olba sungwo yal Saimon mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Te ta Yudas, Yisas bai tal sungwo yal yaliwe, Keriot ganba hong yal mongwi. Ena i tibi olere, Yisas ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ena, Yisas grang wine ongwo hobi kina homena nerala dire omba, ari tabin bir weni u ku bongure ta nekungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ena yu ongure, algi tani yalhobi pungwi. Pirere, han holala dire urere, “Yali kraungi dima hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ena Lo krehaman ha kene ongwo yal tau Yerusalem molere, ya ungwi. Urere, yu ditongwi, “Kwia nigi dongwo singaba mol tongwo yali haang Bielsebul yulang tongure, irere, kwia si doling i mena olimua.” ");
INSERT INTO sll_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yu dungure, Yisas pungwi. Pirere, “Ni yalhobi para wio” ditongwi. Ena ungure, Yisas ha bangi biire yu di engwi, “Seten nin molere, talongure nin si hobale olame? ");
INSERT INTO sll_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ari ganba banta sina sikira dire, kura bole, u susu namia. ");
INSERT INTO sll_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te irang aang hobi kina kura bole, gumang nin nin dinangwo, u susu namia. Te Seten nin nin ebir sire, si doling i ole tenangwo, nimni ta molkinamia. ");
INSERT INTO sll_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yal iwe, ere yu u susu nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Te nona pangwo yal ta monangure, yal ta oo kepangwo ala pirere, bona gana kuni inamo? Ta ikinama. Homa pi nona pangwo yal i kulere, kebering aling han sire, emgi ala pire bona gana inamua.” ");
INSERT INTO sll_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ena yal tau tal nigi dongwo maing maing olere, gaung ha sire, onangwo, pring panangwo iwe, God nin kri di olangwo pamia. ");
INSERT INTO sll_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Te, God Kwiang gaung ha si tenangwo iwe, pring hawo ya di panangwo bani panamia. Na ha weni kara di ni teiya ogolo piro.” ");
INSERT INTO sll_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ena kwia nigi dongwo yong sina momua ditomiraya, ha bangi biire ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ena ditongwo habang iwe, Yisas ebering ya, aang hobi u maini mongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Molere, “Yisas wo, dito,” dire gala dungwi. Gala dungure, ari taporal Yisas mongwo bani uku bole, yobile i sina olungwi. Olere yu ditongwi, “Pino. Nimai ebin hobi irai u maini molere, ni gala dimia wiya po.” ");
INSERT INTO sll_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dungure, yali aire, ari mongwo hobi han wabo dire, yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","“Namine ebina ara mongwo han dine? ");
INSERT INTO sll_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","God grang wine onga yalhobi iwe, namine ebina keunambi muru weni monua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ena gin ta Yisas Galili nir digan bina warere, ari ha maing hon nir si tongwi. Nir si tongure, ari tabin bir weni u ku bolere, ha dungwo i pir mongwi. Mongure, Yisas hon ere sipi ala pirere, pi nir sina ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mongure nir bina i ari tabin miki u yobile mongwi. Mongure, Yisas ha bangi biire miki weni di te mongwi. ");
INSERT INTO sll_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Molere, ha nir si tongwo i yu di engwi, “Ena yal ta homena miling sigirala dire, u sina namia. ");
INSERT INTO sll_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pirere, homena miling sigirangure, miling tau ya homaulung i sinamia. Sinangure, hahoba u pa dire ne wai sinamua. ");
INSERT INTO sll_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te miling tau ya hulu bolimbani sinamia. ");
INSERT INTO sll_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sinangure, ganba miki ta dikinamia. Obilga dinamba, pi sire gintani bonamia. Bonamba, ari sina unangure, dulung stei kulere, megine gonamua. ");
INSERT INTO sll_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te miling tau ya tul galeng enangwo dimane ali sinamia. Ena pi sire bonangure, tul si nenangure, miling ta holkinamua. ");
INSERT INTO sll_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Te miling tau ya ganba wai dinangwo bani sinamia. Ena pi sire bolere, miling miki weni honamia. Erin ta miling teti honamia. Te erin ta miling siksti honamia. Te erin ta miling wan handret honamua. ");
INSERT INTO sll_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Honamia, ari nomani pamia ha i pir pa dinama. Na ha weni kara di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ena ha bangi biire yu ditongure, Yisas grang wine ongwo ari ana holo holo kebena sutani yalhobi iwe, sirin bol tere yu dungwi, “Ha di enga i memini pir pa dikiminia, nin di tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dungure, Yisas yu ditongwi, “God kene ongwo maing di bole digiwe, ni nin pinia ari yamoni mongwo hobi pirkimia. Pinamba, ha bangi biire diga i, ta pirkima. ");
INSERT INTO sll_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hamba hanere, han pa dikimia. Te pimba pirere, ogolo pir pa dikimia. Pinangwo pirere nomani si kulu sinangwo irai, pring pangwo i God i ole tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te Yisas grang wine ongwo hobi yu sirin bol tongwi, “Ha bangi biire di ni tega irai, maing pir pa dikino? Pirkingiwe, ha di ega hobi para tal ole pinane? ");
INSERT INTO sll_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ena yal ta homena miling sigirungwo iwe, i God ha maing miling sigirimua. ");
INSERT INTO sll_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gin ta ha maing iwe, homaulung ari hobi nomani sina bona si ere i wanamia. Ware monamba, Seten gintani ure, ha maing a tol di inamia. ");
INSERT INTO sll_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te miling tau ya hulu bolimbani sungwo meri iwe, ari tau yu monamia. ");
INSERT INTO sll_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Monamba, ha i pir sina ekire gintani pisolamia. Pisolangwo yalhobi, ha maing gogo gogo i wa molere, emgi kura pare te, talime u tibi nangwo gin iwe, aidolangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Te miling tau ya tul galeng engwo ala sungwo mere iwe, ari tau yu monamia. Monangwo yalhobi ha maing pinamia. ");
INSERT INTO sll_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pinamba, ganba tal moni gal bona ya talhan i pinangwo mo mibi nangure, ha maing pir sina ekinamua. ");
INSERT INTO sll_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te miling tau ya ganba wai dungwo bani sungwo meri ari tau yu monamia. Ha maing pirere, i nomani sina ere a i si ware monangure, miling panamua. Miling panangwo meri iwe, ari tau yu monamia. Molere, ari tau honagi obilga 30 God aki di tenangure, te, ari tau miki 60 aki di tenangure, ari tau miki weni 100 aki di tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ena Yisas ha hon ainere yu ditongwi, “Yal ta kewa gale ire, oo ala pire, mulu ali kul si enamo? Ta ekinama. Te bol bera ala enamo? ");
INSERT INTO sll_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ekinama. Kewa bol bani enangwo pamua. Te ha ta di kul si enangwo iwe, emgi u tibi namua. Te ha ta di bii enangwo irai, emgi u tibi nangwo pamia. ");
INSERT INTO sll_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ari nomani pamia ha i pinamua.” ");
INSERT INTO sll_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ena Yisas yalhobi yu ditongwi, “Ha ni yalhobi pinga iwe, a i sire i wa molo. Hau homena ya talhan pangwo ebir si tenga meri iwe, God mong pring ni tere, hon ni te hobo kunangwo inanga pamia. ");
INSERT INTO sll_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Te yal ta talhan a i si ware monangure, God hon te hobo kunangwo pamua. Te yal ta talhan tau a i si wakinangure, homa anangwo tal iwe, God nin tol di inamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ena Yisas ha hon ainere yu ditongwi, “God ari kene ongwo iwe, maing yu pamia. ");
INSERT INTO sll_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yal ta homena miling sigirere, girungwo tangwo mol pai onangure, pi sire bonamia. ");
INSERT INTO sll_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bonamba, yal i maing ta pirkinamia. Ganba iwe, nin aki dinangure, pi sire, aulu sire, kung sire, miling honamia. ");
INSERT INTO sll_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te kul enangwo habang u tibi nangure, di sire penamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ena Yisas hon ainere yu ditongwi, “God ari kene ongwo iwe, di tibi olalga talwa dirale? Na tal ha di kul si ere di terale? ");
INSERT INTO sll_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Iwe, er ta haang Mastet dungwo bani di bole diralua. ");
INSERT INTO sll_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Homena tau miling dungwo tali ta dikima. Mastet miling wainta weniga dimia. Dimba, yal ta miling yanangwo pi sire bonamia. Bolere, er tau para i manbi olamia. Olere, yolang tau bir dinangwo hahoba ure, oong ere bani mol pai onamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ena Yisas ha nir si tongwo iwe, ha bangi biire muru ditongwi. Ha miki weni nir si tenamba, i bangi olama dire, obil obilga nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tere Yisas grang wine ongwo hobi nin mongwo haung i, ha hobi maing di ba bongure pungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ena, ditongwo habang pu dungwo iwe, yalhobi yu ditongwi, “Nan ere nir bina holi namna pano.” ");
INSERT INTO sll_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yu dire ari tabin bir mongwo bani pisolere, ongwi. Pi sipi ala Yisas mongwo bani ongure, aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ena sipi ta para ereho ongwi. Ongure, hamen hair mu dinba urere, sipi i albe olungure, nir pen di ala ungwi. ");
INSERT INTO sll_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ungure, Yisas sipi mobing hol ul pai mongwi. Mongure, gamahobi gala dire yu ditongwi, “Tisao. Nir ala naminga pamia, ni aki di na tekino?” ");
INSERT INTO sll_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dungure, Yisas aire hamen hair ya, nir ya hobi, “Yu olkio” dire, hobang si tongwi. Tongure, hamen hair nir para Yisas grang wine ongwi. ");
INSERT INTO sll_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ongure, Yisas yalhobi yu ditongwi, “Tal ongure ni yalhobi kul pine? Na aki di ni teralga pamia pir na tekino?” ");
INSERT INTO sll_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dungure, yalhobi grang si molere, nin di wama tere, “Yal i ari mom mo, tal mome? Yali yal maing ta momia, hamen hair ya, nir ha ditongure, wine omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ena yalhobi sipi ala molere, hon ere Gerasa ganba bina ongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pirere Yisas ere mena ungure, yal ta kwia nigi dongwo yong sina momia, u pa dungure, hangwi. ");
INSERT INTO sll_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yal iwe, ari yulagi engwo bani mol pai olere, nona pangure, kebereng aling han waiya sungure, kunu ta paikima. ");
INSERT INTO sll_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hamen haung haung han sungure, si oulu di ole ole, mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Molere girungwo tangwo yulagi engwo hulu grang ali pare pare, hamen hul i moni mole, hai mere, gala dire dire mongwi. Molere, pegare ole, hulu kebereng aling bol kula hala sire sire mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ena yal i mole hamba, Yisas ulubi ire u pa dungwo hanere, bli si pire, ya manbi habilai sire, gala dire yu dungwi, ");
INSERT INTO sll_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Yisas, God wangye, ni tal ol na terala di pire une? Na hana pamia, ni hani pamo? ");
INSERT INTO sll_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","God mongwo ipire gauna gul honagi ol na tekio.” Dimia Yisas homa kwia nigi dongwo mena po ditomiraya ha i ya pai mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mongure Yisas hon sirin bol tongwi, “Ni han dalo,” dungwi. “Na hana Kwia Miki Weni molia, taniga ta molkiwa.” ");
INSERT INTO sll_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Direre Yisas di tere, “Na yalhobi ganba baniya ta u mena honaminia ni na hobale olekio.” ");
INSERT INTO sll_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dire hangure, kun miki weni emin ne mongure, hangwi. ");
INSERT INTO sll_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hanere sirin bol tere yu dungwi, “Ni na hobale olingere, kun yong sina i naminba?” ");
INSERT INTO sll_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dungure, Yisas “Owa, para dinia, po,” ditongwi. Ditongure, ari yong sina aidole, ere mena pire, kun yong sina ongwi. Ongure, kun hobi miki weni tu tausen mole, daang i nulu di wi ime pire, nir digan bir saagu dire, gol wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Simia kun kene ongwo yalhobi iwe, te ongwi. Pire, tal ongwo ha i, ditongure, ari para weni pungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pirere, harala dire, Yisas mongwo bani ongwi. Pirere hangure, kwia nigi dongwo yong sina mongwo yal i krau pirere, yamoni mole ami di mongure hangwi. ");
INSERT INTO sll_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hanere, kul pungwi. Pungure tal ongwo i di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tongure pirere, “Na ganbana bani pisolere, ere banta po.” ");
INSERT INTO sll_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ditongure, Yisas ere sipi ala nala di ungure, kwia yong sina mongure si doling i ole tongwo yali ure, sirin bol tere, “Na kina ereho namne?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dimba Yisas mana dire yu ditongwi, “Ni nin ere gaminahobo mongwo malgi po. Pirere, God tal ol ni tere miling pir ni tongwo i, di tibi olana po.” ");
INSERT INTO sll_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ditongure, yali ere pire, tal ol tongwo maing di tibi olere, Dikapolis ganba bani molere, boling kul tibi olungwi. Olungure ari hobi molere, tal ongwo ha i, pirere, yo yangwi. ");
INSERT INTO sll_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ena Yisas ere sipi bani hon pirere, pi nir bina hoibi hol bani ongwi. Pi mongure ari tabin bir weni u ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mongure, yal Yairas Yuda ari ha maing oo kene ongwo yali urere, Yisas gumang hanere, kebering gulung bolere sirin bol tere yu dungwi, ");
INSERT INTO sll_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Na auna migi irai nibil bir ole, golala di omia, ni ure gaung bani angere, si hon ere ya monamia wo.” ");
INSERT INTO sll_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dungure, Yisas yali kina ereho ongwi. Ongure, ari tabin bir hobi kri di u ku bolere, yobile sina ole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mongure, al ta kina doling bol ongwi. Ena airing iwe, algi bilere mongwi. Algi iwe, omaga ta bilkima. Me erin ana holo holo kebena sutani twelpela yia bil mongwo bani mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ena ari dokta miki weni ure honagi ol tongure, airing i, moni bir kara pi dokta mongwo bani gongwi. Gombawe, nibil i wai ta sikima. ");
INSERT INTO sll_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hon u bir weni ongure mongwi. Molere, “Yisas gia ta yu omua,” dungwo pungwi. Pirere, u mongwo bani ungwi. Umba, ari taporal yobile sina ole mongwi. Mongure, al i haya u mobing hol urere, aling sine dire, galsina ongwo bani angwi. ");
INSERT INTO sll_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Arere, yu nomani si pungwi, “Na Yisas galsina ongwo bani aga i, nibil wai sinamia,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ena yu ongure, nibil iwe, gintani wai sungwo ya moni mongwi. Mole, nin nomani si pungure, yong miling sina i para u wai ongure pungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ena yu ongure, Yisas na yulana obilga ura di dimia di pire, inaa dire, sirin bol tere yu dungwi, “Na mobina holi ara ure galsina ame?” ");
INSERT INTO sll_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dungure, gamahobi yu ditongwi, “Ari miki weni ure, ni yobile i sina olimia talongure galsina ama dine?” ");
INSERT INTO sll_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dungure, Yisas ari mongwo bane hobi han wabo dire, angwo yal gumang harala dire wa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dungure, al i u wai oiya di pirere, si pilo dire, gaung nungure, ure, Yisas mongwo bani ungwi. Urere, ya habilai sire, ha weni di ba bole di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Olungure, Yisas yu ditongwi, “Auna ye, ni na awai ol na tenangwo u wai nala di pire pir na tenga meri u wai pire monia. Ni kul pirikio. Nibil i kara wai simia, yon ura dinangure molo.” ");
INSERT INTO sll_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ena Yisas ha i di te mongure, Yuda ha maing oo kene ongwo yal Yairus gamahobo tau ure, yu ditongwi, “Ni aun haya gomia, ni Tisa talwe di te mone?” ");
INSERT INTO sll_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yu dimba Yisas ha dungwo i pir tekima. Tekire Yairas yu ditongwi, “Ni nigi de pirkio. Yon ura dire, na onangwo pamia di pir na tere molo.” ");
INSERT INTO sll_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yu dire, ari hobi molo dire, hobang si tongwi. Si tere, Pita ire, Yems ire, ebering Yon ire dire, obil aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pirere, pi ya singaba Yairas oo malgi pa dungwi. Pa dire, hangure, ari miki weni hai mere, pegare ole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ena Yisas hanere, yu ditongwi, “Ni yalhobi talongwo hai me mone? Ama i ta golkimia. Ya moni ul pai momua.” ");
INSERT INTO sll_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yu dungure, ari hobi wa gol tongwi. Tombawe, Yisas ala pire, ari mongwo hobi “Ere maini po,” ditongwi. Diterere, aang ire, irang ire, te gamahobo ya sui tai di ire dire, pi werang ta ama i pai mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pirere, ama i aleng aki dire, yu ditongwi, “Amagir ye, airo.” ");
INSERT INTO sll_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ena yu dungure, ama i gintani aire, yamoni mole, hol wangwi. Wangure, me erin iwe, ana holo holo kebena sutani twelpela yia mongwi. Mongure, ari hobi hanere, yo yangwi. ");
INSERT INTO sll_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ena Yisas ha di nima pire yu ditongwi, “Na tal olga i, ari hawai ol tekio. Ama migi homena nenamia to,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ena Yisas Capernaum ganba i pisolere, ere nin oong malgi Nasaret ongwi. Ongure, grang wine ongwo hobi doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ongwo habang iwe, Sabat haung u tibi ongure, ha maing oo ala pire, ari ha maing nir si tongwi. Tongure, ari miki weni ha i pirere, ganulung dungwi. “Yal i ha makena i ure dime? Tal gumang hon dongwo i hol makena i ure ome? ");
INSERT INTO sll_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yal iwe, hapenda yal molkimo? Maria wang Yems ya, Yoses ya, Yudas ya, Saimon ebering momia. Te keuni hobo irai, nan kina para molkimno?” ");
INSERT INTO sll_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Direre, nigi de pir tongwi. Tongure, Yisas yu ditongwi, “God hana togu yalhobi iwe, haang ganba ganba i pai omia. Omba, nin ganbani ya, te algi tani yalhobi haang ta paikimua.” ");
INSERT INTO sll_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ena arihobi Yisas onangwo kunu pamia di pir tenangwo Yisas tal guma hon dongwo onangwo pamba, yol e pir tekimia, ol tekungwi. Tekimbawe, nibil pangwo tan tani awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te Yisas ari hobi pir na tekimia di pire nomani miki weni sungwi. Simia Yisas wa i banta banta pirere, ari hobi ha maing nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ena Yisas grang wine ongwo ari ana holo holo kebena sutani yalhobi di ku bolere, ya su su bai nu si olere, kwia nigi dongwo si doling i olama dire, yulang tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Terere, yu ditongwi, “Ni yalhobi bona gana ta ire wakio. Goliba tani a ire wayo. Heba gal gire ire wakio. Gal begi ta kine ire wakio. Te moni ta gal gire ire wakio. ");
INSERT INTO sll_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kebering daing wananga pamibawe, galsina taniga ire wayo. ");
INSERT INTO sll_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ena ni yalhobi wa i oo malgi ta ala pire mongere, oo hong yal i ha wai di ni tenangwo pana gananga bani iwe, tani pai monania. ");
INSERT INTO sll_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te oo malgi ta ongere, oo hong yal i ha wai di ni tekinangwo iwe, pisole guman yau tere, ere banta po. Nangere yalhobi nin maing hanere, nomani si pinamua.” ");
INSERT INTO sll_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ena yu dungure, yalhobi pirere, oo hona hona i ha maing nir si te i pirere, yu ditongwi, “Tal nigi dongwo ol wanga i nigi de pir tere, nomani si kulu sire hon olkirala di pire wayo.” ");
INSERT INTO sll_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ditere kwia nigi dongwo miki go si doling i ole tere, te ari nibil pangwo miki weni wel garu di bil tere, awai ol tongwi. Tongure, nibil wai sungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ena, Yisas ol wangwo guung haang iwe, wa dire ganba bina holo holi kunu be pisolimia, king Herot pungwi. Ena ari yal al tau yu dungwi, “Yon ari nir bil tongwo yal irawe, gongworai, God aki ditongure, si hon ere airima dimua,” dungwi. “Airimia yulang pai tongure, yu oma dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te ari tau yu dungwi, “A, God hana togu yal Ilaiya uma dimua,” dungwi. Te tau yu dungwi, “A, i hana togu yal irai u tibi uma dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dimiawe, king Herot ha i pirere, yu dungwi, “Hamen haya na Yon nir bil tongwo yal irai, nugung birega gomiraya, omaga God aki ditongure, hon airima di dungwiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Homa king Herot ebering Pilip eumbi Herotias wou si ingwi. Ingwo iwe, Yon hanere, “Ni ebin eumbi al Herotias si holo ole inga i krehaman ha yu ta paikimia, God Lo isusu ol tenua,” di tere tere mongwi. Di te momia al Herotias Yon nigi de pir tere mongwi. Molere, ta tal olere, sigolale di pire han mongwi. Momba, yal Herot mana ditongwi. Ditere yal tau bai nu si olungure yalhobi pirere, Yon han holere, aule ire pire, halabusi oo ala engwi. Embawe, king Herot Yon si gonama dire, kul pungwi. Pirere, Yon God honagi ari momia dire, halabusi oo ala engwi. Erere king Herot Yon ha dungwo pinangwo ha pirkimba, arewo pi pire pire mongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ena gin ta al Herotias Yon sirala di pungwo habang u tibi ongwi. Ena habang iwe, king Herot hamen haya aang kul nongwo haung u kalenda tibi ongure, homena kerala dire, ari di aulungwi. Di aulere, Gabman yal ire, Ami kene ongwo yal tau ire, Galili ari singaba tau ire dire, u ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mole homena ne mongure, al Herotias aung egin ingwi. Ingure king Herot ari homena ne mongwo hobi para molere, wai weni hangwi. Hanere Herot ama i yu ditongwi, “Ni tal irala di pine? Ni talta irala dire haang dananga tali ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yu dire Herot ha weni kara di nima oiwa dire, yu ditongwi, “Ni talta irala di pinanga na di na to. Ganba ta na to dinanga, na ganba hol bani bli bole ni ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dungure ama i ere mena pire aang yu ditongwi, “Namine, na tal na to ditenamne?” Dungure aang yu ditongwi, “Ni pirere, Yon ari nir bil tongwo yali nugung biire, i pere ali ere, i na to, ditenana po.” ");
INSERT INTO sll_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dungure, ama i gintani pirere, aang dungwo meri Herot ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ditongure king Herot pirere, nomani miki weni sungwi. Sirere yu nomani si pungwi, “O homa ari mongwo maulung bani ha weni kara di tibi oliraya tal olale? Ama i na to dimia yu olalua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pirere soldia nona pangwo yal tau bai nu si olere, yu ditongwi, “Yon breng biire i unana po.” Ditongure, yalhobi pirere, Yon halabusi oo ala mongure, breng biirere, i ungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I ure Het tongwi. Tongure Herot pere boling bani erere, ama tongwi. Tongure ire pire, aang tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tomia, Yon gamahobo pirere, Yon yone nin irala dire, ongwi. Pirere, irere, ure, man wu engwi. ");
INSERT INTO sll_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ena Yisas grang wine ongwo hobi ere urere, honagi ongwo i ha di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Te mongure ari miki weni iriyala te mongwi. Mongure Yisas gamahobo kina homena nenamba haung ta dikungwi. Yu ongure Yisas gamahobo yu ditongwi, “Nan yalhobi obil ere banta sime enangwo bani namna po. ");
INSERT INTO sll_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pirere obilga mol pinamna pano.” Yu direre sipi irere, ere pi banta sime engwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Omia, ari tabin bir hobi molere, hamba, yalhobi ongure, gumang han pa dungwi. Direre oo malgi pisolere, bli si pi hol bangi pirere, iri si homa engwi. ");
INSERT INTO sll_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Engure Yisas emgi u pa dire sipi pisole, mena ure, ari tabin bir hanere, miling bir pir tongwi. Yalhobi kun sipi sipi mongwo meri mole, umia, kene onangwo yal ta molkimua di hangwi. Hanere bangi timi hon ha maing nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te mongure hamen girungure, gamahobi urere, yu ditongwi, “Hamen girimia, baniya ari oo ta kepare molkimia, homena ma dinangwo bring si nename? ");
INSERT INTO sll_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ere oo ta dungwo bani po ditengere pirere, homena bring si nenamua.” ");
INSERT INTO sll_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dungure Yisas yu ditongwi, “Ni yalhobi homena nin inanga to.” Dungure, gamahobo yu ditongwi, “Na yalhobi moni miki weni tu handred kina homena bring sire ari hobi tenamin mo?” ");
INSERT INTO sll_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dungure Yisas yu ditongwi, “Breti talmere dime? Pi hanana po.” Dungure yalhobi pi hane urere, yu ditongwi, “Breti ana hol pai muru dimio, te pisi sutani dimua.” ");
INSERT INTO sll_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dungure Yisas yu ditongwi, “Ari hobi kul pege bongwo bani hala sire ami di molo.” ");
INSERT INTO sll_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ditongure ami dungwi. Ena ari tau miki weni wan handred hala si momio, te ari tau sutani pipti hala si mongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mongure Yisas breti te pisi sutani arere, han gala dire hamen bani hanere “God homena na tenga wai piminua” dungwi. Direre breti a du dire gamahobi tongwi. Tongure gamahobi irere, ebir sire ari hobi tongwi. Te pisi su i para a du dire arihobi ebir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tongure yalhobi nere miing ongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ongure tau ya dungwo tali pisi tau ire breti para homa yong gal basket ana holo holo kebena sutani girungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te homena iwe, ari yagr miki weni paib tausen molere nongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ena nomia Yisas ari tabin i ere pio ditere, gamahobi sipi irere, “Na mominia. Ni homa pi Betsaida monana pio.” ");
INSERT INTO sll_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ditongwo yalhobi ere ongure, Yisas ere hamen hul ta pire mongwi. Molere God ha di te mongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ena hamen girungure sipi nir bani ya dungwi. Dungure Yisas nin bangi mongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mole hangure, hamen hair mu dinba urere, sipi simia gamahobo puul sire nala di omba, kunu paikungwi. Paikungure yu ol mongure, hamen tarala di ongwi. Ongure Yisas nir aulung bani pi pa dire wiyala ongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Omba gamahobi hangwo nir aulung bani ongwo hanere, yu nomani si pungwi, “Kwia ta omia,” di hangwi. ");
INSERT INTO sll_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hanere ganulun dire aya maya dire, kul pire mongwi. Mongure gintani Yisas ha yu ditongwi, “Mining bole molo. Na nan wiya kul pirkio”. ");
INSERT INTO sll_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yu ditere, iri si sipi ala ongwi. Ongure, hamen hair wai simia, gamahobo ganulun dire nomani miki weni sungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ena Yisas homa breti ari miki weni ebir si tongwo i maing iwe, gamahobo pir pa dikima. ");
INSERT INTO sll_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ena nir bani hon ere pirere, pi Genesaret pirere, sipi si gol engwi. ");
INSERT INTO sll_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ere sipi pisole, mena ongure, ari Yisas gumang gintani han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dire bli si mena holo holo i ongwi. Ongure ari hobi urere, “Yisas makena mome?” dungwi. Direre nibil pangwo yalhobi er ba hau irere, Yisas mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Omiawe, ganba bina holo holo i, te oo ai bir migi hobi Yisas para wa pa dungwi. Dungure, ari nibil pangwo a ire, maket homena bring si mongwo bani ungwi. Urere, Yisas sirin bol tere, yu ditongwi, “Yal Yisas ye, ni galsina anaminba?” Yu dire angure, nibil wai sungure, u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ena Perisi hobi tau ire, krehaman ha Lo kene ole nir si tongwo hobi tau ire dire, Yerusalem aidolere, Yisas mongwo bani u ku bongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bolere hangure, Yisas gamahobi homena nerala di olere, aleng bigi homa sikungure hangwi. ");
INSERT INTO sll_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ena Perisi hobi ire, Yuda ari hobi ire dire, kwiang moiya yalhobi nin memini pangwo ongwo tali doling bole yu ongwi. Ena homena nerala di ongwo gin iwe, homa aleng bigi sirere, emgi homena nongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te Maket homena bring si nongwo bani ware, ere urere, homena han bring sungwo hobi homa bigi si tongwi. Te kwiang moiya maing pangwo meri tau ere wine olere, mulu sin ya te pere ya, mulu hau ya, bol ya, nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yu ongure, Perisi yalhobi ire, krehaman ha Lo kene ongwo yalhobi ire dire, Yisas yu sirin bol tongwi, “Ni gamnahobo aling bigi sikungwo iwe, talongwo kwiana moiya ha dungwo wine olkime? ");
INSERT INTO sll_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aling gama engure homena nomua.” Yu dungure Yisas yu ditongwi, “Hasu dire kuru dinga yalhobi Aisaia ha homa mining bol engwo yu pamiraya. God yu dimia, arihobi grang bani hana dal yuwo emba, pir nomani sina ekima. ");
INSERT INTO sll_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","God Lo krehaman ha di engwo dimba, te arihobi nin gaung bani di bole dimia. Direre maa e na tongwo paikimua.” ");
INSERT INTO sll_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ena Yisas yu ditongwi, “Ni yalhobi God Lo krehaman ha i pisolere, nin kwian moya ha iwe, a i si wanua.” ");
INSERT INTO sll_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ena Yisas hon ainere yu ditongwi, “God Lo krehaman ha pisolere, ni nin ha a i warala dire oniba, ongiwe, wai pama di pino? ");
INSERT INTO sll_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Homa kwiana moya Moses ha yu di emiraya, Nimai nabin ol gogo dal tekire aki di to. Te yal ta nimai nabin ha yong i tere gaung ha si tenangiwe, gonanga pamua. ");
INSERT INTO sll_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yu dimba, te ni yalhobi yu ditenia. Yal ta talhan a nenangwo iwe, irang aang tenangwo pamba, yu ditomia, ni teralba, talhan i haya God te pisole moliwa. ");
INSERT INTO sll_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yu direre namine nabe awai ol teralga paikima di pinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Direre Yisas hon yu ditongwi, “Ha di tengiwe, God ha i mobin hol olere, kwian moiya krehaman ha a i si ware, di tibi ol tenua. Te ni yalhobi tal miki weni ereyu moni ol wa monua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ena Yisas ari tabin hobi hon gala di ku bolere, yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Talhan mena dire u grana bani ongwo iwe, ari nomani sina ol nigi de na tomo? Tekimua. Te talhan nomani sina i a bona dire, grana bani u mena ongwiwe, ari ol nigi de na tomua. ");
INSERT INTO sll_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na ha weni di ni teiya ari nomani pamia ogolo piro.” ");
INSERT INTO sll_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ena Yisas ari hobi ai dolere, ere malgi ongwi. Pire mongure, gamahobi u pa dire, yu sirin bol tongwi, “Ha dinga irai, memini pir pa dikiminia nin di tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Dungure Yisas yu ditongwi, “Ni yalhobi nomani paikimo? Ha i memini pir pa dikinia. Talhan tau mena direre, u gran bani nangwo iwe, ari ol nigi de ni tekinamua. ");
INSERT INTO sll_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nomani sina i honama. I nin hol pai tongwo hol i pirere, u mena namia. Pirere, emgi u yo maul ali namua.” Yisas ha di tibi ol tomiraya, homena para muru kuari pamua. ");
INSERT INTO sll_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ena Yisas hon yu ditongwi, “Tal ta ari nomani sina direre, grang bani u mena ongwo iwe, ari ol nigi de tomua. ");
INSERT INTO sll_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Talhan tau nomani sina direre, u mena ungwiwe, di ni terala. ");
INSERT INTO sll_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nomani nigi dongwo si pingiwe, yu pamia, yal al wou sinangwo nomani tere ware, kuni nere, ari si golere, yal al ire pisolere, yalta talhan a nongwo hanere nomani nigi dongwo sire irala di pire, tal gogo olere, hasu bal tere, kulu sire, nomani pir don kere, yong ki ere, gaung ha sire, nin gaung di yuwo erere, omeling pege dire, du nomani sire, ");
INSERT INTO sll_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","tal nigi dongwo hobi iwe, nomani sina i u tibi pirere, ari nomani ol hama si tomua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ena Yisas ha di te pisolere, ere Taia ganba ongwi. Pirere, pi oo malgi ta pirere, kul si molia di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pimba ta molkima. Al ta Yisas umua dungwo pirere, ungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Al i Pinisia al kul nongwo ha howa al momia, Griki ha dungwi. Ena al iwe, aung kwia nigi dongwo yong sina momia, Yisas mongwo bani urere, ya habilai sirere, yu ditongwi, “Na auna kwia nigi dongwo yong sina mongure, wiya, ni si doling i mena olanba?” ");
INSERT INTO sll_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ditongure, Yisas yu dungwi, “Na gir hobi homa homena tegere, nere miing onamia. Onangure, homena moiring yanangwo ire awi hobi tenamno?” Yu dungure al i “O, na awi mongwo meri mole uga meri di na tomua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pirere yu ditongwi, “Yal Yisas ye, ni ha pangwo meri dinia. Dinba, gir hobi homena nongwo moiring boi di yangwo awi nongwo pamia, nongwo meri na obilga neralba?” ");
INSERT INTO sll_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dungure Yisas yu ditongwi, “Dinga wai piria, kwia nigi dongwo iwe, aun yong sina aidolere, haya ere mena ongwo wai momia, ere po.” ");
INSERT INTO sll_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dimia ere malgi pire aung pangwo bani hamba, kwia ere ongure, ya moni mongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ena Yisas Taia ganba bani aidolere, pi Saidon ongwi. Pirere pi Dekapolis pa direre, u Galili nir digan bina ongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ongure ari hobi yal ta kraung gi dire grabiling aa tongwo ha mining paikungure, a ire ungwi. Urere, Yisas sirin bol tere, “Yali awai ol tenanba?” ");
INSERT INTO sll_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dungure Yisas yali a ire, nin bangi ongwi. Pi molere, Yisas aling miling taniga kraung ali sin ongwi. Olere aling hol bani ebil sirere, grabiling bani angwi. ");
INSERT INTO sll_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Arere hamen bani yuwo hanere, eke dire, kraung gi dungwo yal i “Kraung pila do” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ditongure, gintani kraung pila dungure, ha mining wai pangwi. ");
INSERT INTO sll_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pamia, ha dire mongure, Yisas, “Tal olga i ari ha wai ol tekio,” hobang si tongwi. Tomba, ari hobi pirere, ha wai ol te i ongwi. ");
INSERT INTO sll_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ongure, ari para pirere, ganulun direre, yu dungwi, “Yal i talhan ongwiwe, tal wai moni omua. Ari kraung gi dungwo irai, a pila di tongure, ha hon pimio, te grabiling a tongwo irai, a kulang pai tongure, ha hon dimia hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ena dungwo gin iwe, ari tabin bir weni u ku hon bole mongwi. Mol i ongure, emgi homena wai sungwi. Wai sungure, Yisas grang wine ongwo hobi gala di ku bole, yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na arihobi hamen haung sui tai dire ereho molga homena wai sungure, miling piriwa. ");
INSERT INTO sll_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Menan gole momia bai nu si olgere, bangi pirere, omeling malamia, oo malgi ulubi dimua.” ");
INSERT INTO sll_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dungure yalhobi yu ditongwi, “Hol bangi ari ta ke paikimia, nan me heba makena dinangwo bring sire, ari hobi tomingere, nename?” ");
INSERT INTO sll_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dungure Yisas yalhobi yu sirin bol tongwi, “Breti talmere dime?” Dungure yalhobi yu ditongwi, “Ana hol pai muru ana hol pai sutal dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dungure Yisas arihobi “Ami dio.” Ditere, breti sewen pela irere, “God homena na tenga wai piriwa,” ditere, breti a du dire grang wine ongwo hobi tongwi. Tongure, ebir sire, ari hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te pisi migi sutani irere, God homa dungwo meri di tere, grang wine ongwo hobi tongwi. Tongure yalhobi ebir sirere, ari hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Tongwo ari hobi nongure miing ongwi. Ari homena ne mongwo hobi iwe, miki weni po tausen mole nongwi. Ne mongure Yisas bai nu si olungure ere ongwi. Ongure homena ya dungwo tali gal ana holo muru ana holo sutani girungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gire ire ongure, Yisas grang wine ongwo hobi kina gintani sipi ala pirere, nir bani ongwi. Pirere pi Dalmanuta ganba pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ena ginta Perisi yal tau Yisas mongwo bani urere, ha bolbin diriyala olungwi. Olere, yong bai tal sire, yu ditongwi, “Ni hamen bani tal guma hon dongwo ta i tibi ol na tengere, hanaminba?” dungwi. Direre, yu nomani si pungwi, “Weni ta i tibi olam mo, olekinam mo,” dire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Momba, Yisas nin nomani si pungure, miling gul sungure, yu dungwi, “Talongure ni yalhobi tal guma hon dongwo harala dire, gala dine? I pisolo. Omaga iwe, ganba hong malaya yalhobi, tal guma hon dongwo ta i tibi ol tekiralia. ");
INSERT INTO sll_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na ha weni kara diwa.” Yu direre, aidolere, iri si sipi ala pirere, pi nir digan bina holi ongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ena omia, gamahobo iwe, breti tau ire, nala dire, akun ol engwo bani kraung gi dungwo pisolere, taniga ire, sipi ala ongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ongure, Yisas ha ering bongwo dire, yu ditongwi, “Ni piro. Perisi yalhobi Herot gamahobi kina homena breti yis ere gangwo dere, u bir ongwo mere, yalhobi ha dire talongwo sidina dire, u bir ongwo namia, naa ire, han molo.” ");
INSERT INTO sll_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yu dungure Yisas grang wine ongwo hobi nin ha diriyala olere, yu dungwi, “Na breti ire huminia ha i di na tomua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Di pirere yalhobi nin ha di wama tongure Yisas yu ditongwi, “Breti ire hungarai, han dikia. Talongwo breti dikungwo ha diria ol mone? ");
INSERT INTO sll_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ha bangi biire diya pirkino? Ni yalhobi han pa dikinua do. ");
INSERT INTO sll_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ni omin hankino? Kraun gi dino? Na homena breti ana holulu ebir sire ari miki weni paib tausen tominga irai pirkino? Homena ya dungwo gal talmere girine?” Dungure, yalhobi, “Ana holo holo kebena sutani giriminua.” ");
INSERT INTO sll_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dungure yu ditongwi, “Na homena breti ana hol pai muru, ana hol pai sutani, ebir sire, ari po tausen tominga nongwo irai, homena ya dungwo gal talmere girine?” Dungure yalhobi yu ditongwi, “Ana hol pai muru hol pai sutani giriminua.” ");
INSERT INTO sll_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dungure Yisas yu ditongwi, “Ayo. Irai nomani si pirkino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ena Yisas grang wine ongwo hobi kina pi Betsaida pa dungwi. Pa dungure, ari hobi yal ta omeling gi dungwo aule ire, Yisas mongwo bani ungwi. Urere, sirin bol tere, yu dungwi, “Ni omeling gi dungwo yali awai ol tenanba?” ");
INSERT INTO sll_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dungure, Yisas omeling gi dungwo yali aling arere, a ire, ere mena ongwi. Pirere ebil si omeling bani bilere, omeling a to sire, “Tal ta hano?” ");
INSERT INTO sll_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ditongwo hanere yu dungwi, “Omena obilga pila dire, ari tau haniba, er dungwo meri molere, hol wamua.” ");
INSERT INTO sll_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dungure, Yisas aling hon omeling a to sungwi. Sungure tene yulang bole hangure, omeling wai dungure, talhan para muru han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dungure Yisas bai nu si olere, yu ditongwi, “Betsaida malgiya pisolere, ere nin oon malgi po,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ena Yisas grang wine ongwo hobi kina Betsaida malgi pisolere, pi Sisaria Pilipai malgi oo tabil tabil i para muru wa pisolungwi. Solere hol bangi grang wine ongwo hobi yu sirin bol pungwi, “Ari hobi na molga bani urere, na hana dangwo talwa dime?” ");
INSERT INTO sll_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dungure gamahobi yu ditongwi, “Yal tau urere, Yon nir bil tongwo yal i mona dimua. Tau Ilaiya mona dimua. Tau God hana togu ta mona dimua.” ");
INSERT INTO sll_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yu dungure Yisas sirin bol tere, “Ni yalhobi nin na hana talwa dine?” Dungure Pita yu dungwi, “Ni han singaba Kraist monua.” ");
INSERT INTO sll_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dungure Yisas ha di nima pire yu ditongwi, “Yal ta na hana dal tibi ol tekio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ena Yisas grang wine ongwo hobi ha hon ainere nir si tongwi, “Na Ari Wang Weni tani molga irai ari na sinamua. Te Yuda ari ha maing oo singaba ire, ha maing kene ongwo yal bir hobi ire, ha maing nir si tongwo yalhobi ire dire, para weni na isime e na tenangwo na si gonamia golalga pamua. Golere emgi hamen haung sui tai dire molere, hon airalga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Direre tal ol tenangwo awa ha iwe, yu di tibi ol tongwi. Tongure yal Pita Yisas aule ire pirere, kura ha di te mongwi. ");
INSERT INTO sll_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mongure Yisas grang wine ongwo hobi mongwo bani han wabo dire, Pita kura ha ditere, “Seten. Ni ere ulubi po. Ni God ha dungwo meri di tibi olekinia ari ha dungwo meri dinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ena Yisas ari tabin bir grang wine ongwo hobi kina gala di ku bongwi. Bole, yu ditongwi, “Yal ta na pir na tere, dolna bolala di pinanga iwe, nin gaung nomani si pirkirere, talhan mobin hal wa tere, na gul pire, golalga meri ni ere gul pire golere, na dolna bonania. ");
INSERT INTO sll_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yal ta nin gaung pir tere monangwo yal iwe, emgi u talwo nangwo pamua. Yal ta na pir na tere, tal ol tega ha wai nomani si pire, u talwo nangwo yaliwe, emgi gobari mol panangwo bani panamua. ");
INSERT INTO sll_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ena yal ta ganba bani talhan nomani tere wanamia. Wanamba, emgi talhan hobi hon siina dire aki di tenangwo nomani u wai nam mo? Ta honamua. ");
INSERT INTO sll_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tal tobo tenangwo kunu benangure nomani hon ire gobari mol panangwo bani paname? I ta kunu bekinamua. ");
INSERT INTO sll_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Te ganba hong malaya yalhobi ha di tega pirkirere, tal gogo ol wamua. Ware mongwo sina i yal ta na gai gol na tenamua. Tenangwo yal i, emgi Hamen Nabe ire kwia ensel hobi ire, Ari Wang Weni na ire dire, ba bongwo bolo uralga, yal i han gogo daralga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ena Yisas ha hon ainere yu ditongwi, “Yal tau malaya mongwohobi ta golkinamua. Homa God ari kene ongwo maing ire, nin yulang ire dire, u tibi nangwo hanere, emgi gonangwo pamua. Ha pangwo mere di ni teiya ogolo pirio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ena ari habang ana holo muru ana holo taniga a ba dire, Yisas ire, Pita ire, Yems ire, Yon ire dire, aule irere, hamen hul ta mini weni bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pirere, yalhobi nin mongwi. Mongure, ena Yisas gaung hon pol kungure hangwi. Kungwo iwe, yal ta gal pege bigi si wai ole, enamba, kunu paikinama. Yu ongure hangwi. ");
INSERT INTO sll_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hangure, Ilaiya Moses kina ure Yisas kina si daule molere, ha diria ol mongure hangwi. ");
INSERT INTO sll_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ena Pita i hanere, Yisas yu ditongwi, “Tisao, nan yalhobi baniya mominga wai pamua. Pamia oo sui tai dire kenamina do. Kemingere ta ni oo dinangure, ta Ilaiya oo dinangure, ta Moses oo dinama do.” ");
INSERT INTO sll_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dungure, yal sui tai dire hobi kul bir pirere, mongure, Pita ha dungure grang obe abe yangwi. ");
INSERT INTO sll_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yu dungure, hamen kwahawa tau urere, yalhobi yobilungure, ha ta sina ali yu di mena olungwi, “Yal i na wana momia, na yona milna para teiwa. Ni yalhobi yal i ha dinangwo grang wine ole piro.” ");
INSERT INTO sll_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dungure gin tani weni yalhobi han holo holo olungure, ari ta monangwo hankima. Yisas tani mongwo, hangwi. ");
INSERT INTO sll_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ena hamen hul i aidolere, ere ya ime ungure, Yisas yalhobi hobang si tere yu ditongwi, “Ni yalhobi tal hanga iwe, ari ta ha wai ol tekio. Ari Wang Weni na iwe, golere, emgi hon airalga habang ari ditenanga pamua.” ");
INSERT INTO sll_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dungure yalhobi pirere, a i si mongwi. Molere yalhobi nin yu dungwi, “Yal i golere hon airalua dungwo i, tal maing pangwo dime?” ");
INSERT INTO sll_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Direre hon sirin bol tongwi, “Talongure Yuda krehaman ha kene ongwo yalhobi Ilaiya homa u tibi namua dime?” ");
INSERT INTO sll_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dungure Yisas yu ditongwi, “Owa, i ha weni kara dimua. Ilaiya homa u tibi pirere, talhan para muru akun ol enamia. Ha mining ganing ta yu pamiraya, “Yalhobi Ari Wang Weni ol gogo dal tenangwo gaung gul bir inangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Talongure yu di eme? Ilaiya haya umia, ari hobi nin nomani si pungwo meri yali yu ol tomia, ha mining ganing homa di engwo irai giu dire pamia. Na omaga di ni teiya piro.” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ena Yisas yasu hobi kina u bangi urere, u grang wine ongwo tau mongwo bani pa direre, ari tabin bir weni u ku bongure, hangwi. Ena Yuda krehaman ha kene ongwo yal tau Yisas grang wine ongwo hobi kina ha bolbin diriyala ol mongwi. Mongure, ari tabin bir hobi Yisas u pa dungwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hanere, ganulun bir dire, bli si pirere, kewaa ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ditongure, Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi kina tal ha bolbin dine?” ");
INSERT INTO sll_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yu dungure ari mongwo sina i yal ta aire, yu ditongwi, “Tisao. Na wana kwia nigi dongwo yong sina mongure, ha dikimia, aule ire ni monga bani wiwa. ");
INSERT INTO sll_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hamen haung haung kwia i gir yong sina molere, nona pare, honagi ol tongure, gir i habilai simua.Habilai sire grang niri baregi dungure, siging girimil nure, aling kebering para si to sire dimua. Na ni gran wine ongwo hobi awai ol tenama dire diiba, yalhobi ongwo kunu paikimua.” ");
INSERT INTO sll_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ditongure, Yisas ha i pirere yu ditongwi, “Ha diga wine olere, a i si wakingiwe, na molkiralga tal onane? Mol i pire emgi talongwo na hon a ki di ni terale? Gir i aule ire na molga baniya wo.” ");
INSERT INTO sll_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dungure, ari hobi gir aule ire Yisas mongwo bani ongwi. Ongure, kwia nigi dongwo Yisas gumang hanere, gir i ere han ire pegare ol tongwi. Ol tongure, yare, habilai sire, grang niri u hole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mongure, Yisas gir irang yu sirin bol pungwi, “Gir i omaga om mo, haya ome?” ");
INSERT INTO sll_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dungure irang yu ditongwi, “Hamen haya gir migi mongwo ali ya ol mongwo bani momua. Hamen haung haung kwia nigi dongwo i ol tongure, u dia enda ali sirere, u dia nir ali pirere, si golala dire omua. Ni milna pirere aki di na terala dipinanga, aki di na tenanba?” ");
INSERT INTO sll_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dungure Yisas yu ditongwi, “Oa, na awai ol ni teralga pamia di pinga meri ol ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ditongure irang erakere ditongwi, “Ni onanga kunu benama di piminba, nomani susu sire a i si wanaminga paikimia, ni aki di na to.” ");
INSERT INTO sll_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dungure Yisas hangure, ari para weni u yobilungwi. Yobilungure, kwia nigi dongwo kura ha ditongwi, “Ni kwia nigi denga ari yong sina ali monga, kraung gi dire, ha mining paikimia, aidole, ere mena wo. ");
INSERT INTO sll_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Urere, hon siina dire, ari yong sina hoyo.” Dungure, kwia nigi dongwo i, gala bir weni dire, ere han ire gir i ol terere, ere mena ungwi. Yu ongure, gir i kara gol howa di ongwi. Omia arihobi hanere, “Gir i kara gomua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dire han mongure, Yisas ure, aling aki dungure, airungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ena emgi ere ala ongure, grang wine ongwo hobi nin mole, yu sirin bol pungwi, “Na yalhobi kwia nigi dongwo si doling i oliminga paikimia, tal onamne?” ");
INSERT INTO sll_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dungure, Yisas yu ditongwi, “God aki di na to dinanga kwia nigi dongwo si doling i olanga pamia. Tal ta onanga, kunu paikinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ena yu ditere, aidolere, ere Galili ganba sina ongwi. Pire Yisas kul si molere, grang wine ongwo hobi ha nir si terala di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Pirere, yu ditongwi, “Ari Wang Weni, na iwe, ari na i kura bolimbani olamua. Yu olere na si gonangwo pamua. Golere ari habang sui tai di pai molere, God aki di na tere ulna yunangure hon airalga pamua.” ");
INSERT INTO sll_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yu dungure yalhobi pir pa dikimia, sirin bol tenamba, kul pungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ena yalhobi hon pi Kapaneam pa dungwi. Pa dire pi ala molere, Yisas grang wine ongwo hobi yu sirin bol tongwi, “Ni yalhobi hol bangi tal ha bolbin dine?” ");
INSERT INTO sll_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yu dimba, yalhobi pir uning si mongwi. Momia, hol bangi iwe, urere “Nan yal ara singaba molere, kene onamne?” dire bolbin dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dungure Yisas ami di molere, grang wine ongwo ari ana holo holo kebena sutani yalhobi gala dire, ere wio, dungwi. Direre, yu ditongwi, “Ni yalhobi singaba molala di pinanga iwe, ya ime sire, nir honagi ol tere, mol i nanga, singaba monanga pamua.” ");
INSERT INTO sll_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yu dire gir migi ta i sina erere, kulere, yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ni yalhobi yal ta, na hana pirere, gir migi mongwo i pana gal tenanga iwe, na pana gal na tenanua. Te na pana gal na tenanga iwe, na tani taman. Nabe hamen ya singaba pana gal tenanua. Nabe na bai nu sungure na ya ime wiwa” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ena Yon Yisas sirin bol tere yu dungwi, “Tisao, yal ta ni hani a i wa molere, kwia nigi dongwo si doling i olungwo haminia. Hanere, na gamnahobo ta molkinia yu olkio dire, mana ditominua.” ");
INSERT INTO sll_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dungure Yisas yu ditongwi, “A, i mana ditekio. Te yal ta na hana a i wa molere, tal guma hon i tibi olamia, emgi na gauna ha si na tenam mo? ");
INSERT INTO sll_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta si na tekinama. Te yal ta kiang pai na tekinangwo iwe, nan yol e nominga monamua. ");
INSERT INTO sll_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ena yal ta ni yalhobi ni hanere, yu nomani si pinamia, O, na singaba Kraist grang wine ongwo hobi aki di teralua, di pire mulu hau nir holere ni tenangwo nenanua. Yu ol ni tenangwo yal iwe, emgi God siina dire tobo tenangwo pamua. Na ha weni kara di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ena Yisas hon ainere yu ditongwi, “Ena gir migi ta na tal ol tega ha maing a i warere, na pir na tenangwo, yal ta hanere, a, i hasu onua, ditenangwo, gir i pirere, na mobing hal wa na tenamia. Ditenangwo yal iwe, kwahulu bir weni ta nugung bani han hol erere, u di nir digan man ali pirere, gonangwo oun denamo? ");
INSERT INTO sll_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","I ta dekinamia. Na tal ol teralga iwe, tal oun dongwo ol teralua. Te ani weni hol iwe, tal nigi dongwo olere, pring au si ni terala di onangure, di keuru si olo. Yu ongere ani taniga dinangure, moli pire hamen bani nanga pamua. Te ani sutani dinangure, endo de pangwo bani nanga pamia. ");
INSERT INTO sll_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pirere, gin tani ta golkinanua. Te endo i wai ta sikinamua. ");
INSERT INTO sll_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te kebin weni hol i, tal nigi dongwo olere, pring au si ni terala di onangure, di keuru si olo. Yu ongere, kebin taniga dinangure, hamen bani nanga pamua. Te kebin sutani ereho ya dinangwo moli pirere, endo de pangwo bani nanga pamia. ");
INSERT INTO sll_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Pirere, gin tani ta golkinanua. Te endo i wai ta sikinamua. ");
INSERT INTO sll_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te omin weni hol i, tal nigi dongwo ol warere, pring au si ni terala di onangure, si gi di olo. Yu ongere, omin taniga dinangure, hamen bani nanga pamua. Te omin su dinangure, endo de pangwo bani nania. ");
INSERT INTO sll_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pirere gin tani ta golkinania. Te endo i wai ta sikinamua. ");
INSERT INTO sll_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Homena pil onga bengwo mere iwe, endo giini bli bali dire ari para muru denamua.” ");
INSERT INTO sll_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ena pil i tal wai dimia. Dimba, gwiring mena pi wai sinangure, irere, tal onamne? Tal ta omingere, gwiring hon monamo? Ta molkinama. Ni yalhobi homena pil ongwo mere iwe, kunu ganba sinaya monia. Molere, yon milni ura dinangure, ya ime sire, ari hobi kina yon tani erere, mol i nanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ena Yisas ere pi Yudia ganba pirere, pi Yodan nir bina hoibi hol yuwo ongwi. Pi mongure ari miki weni hon u ku bongwi. Bongure, yal iwe, homa tal ongwo meri olere, yu nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Si tomia, Perisi yalhobi tau u pa dire, kela kul tere, yu ditongwi, “Nan krehaman ha memini panangwo al ta ire ai dolamin mo, aidolekinamne?” ");
INSERT INTO sll_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dungure Yisas yu ditongwi, “Moses krehaman ha talwa di eme?” ");
INSERT INTO sll_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dungure yalhobi yu ditongwi, “Moses al irere, ai dolala di pinangi, pepa bol terere, ai dolanga para pama dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Owa, i dimba, ni nomani ta paikungwo ipire, Moses yu bol ni tomia. ");
INSERT INTO sll_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hamen haya God talhan para weni ol erere, ari yal al para ol erere, krehaman ha yu di emiraya, ");
INSERT INTO sll_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","God yal al ol engwo iwe, irang aang pia si nin bangi olere, eunbi kina yon tani erere, si daule molo dimiraya. ");
INSERT INTO sll_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Molere, nin nin molkirere, yon tani erere, monania. ");
INSERT INTO sll_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God ol erere, si daule e na tomia, yal ta eumbi wiimbi aidole si poira sire, u nin nin nanga paikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dimiawe, oo malgi hon pirere, grang wine ongwo hobi Yisas sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pungure Yisas yu ditongwi, “Ena yal ta eungbi ai dolere, al ta hon inamia. ");
INSERT INTO sll_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inangwo yal i, wou sire, eungbi homa monangwo al iwe, ol gogo dal tenamua. Te al ta wiimbi aidolere, yal ta namia. Nangwo al i, wou sirere, wiimbi homa inangwo yal iwe, ol gogo dal tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ena ginta ari gir kul nongwo hobi Yisas breng bani anama dire, i ku bongwi. Bomba, Yisas grang wine ongwo hobi kura ha ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ditongure Yisas hanere, yong ki erere, grang wine ongwo hobi yu ditongwi, “Gir migi hobi aule ire, na molga bani urala di omia mana di tekio. God gir migi hobi iwe, kene ol tongure momia. ");
INSERT INTO sll_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gir migi hobi God kene ol na to, ditongwo meri ari hobi ere yu dikinanga, God kene ongwo bani ta honanga pamua. ");
INSERT INTO sll_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na ha weni kara di ni teiya piro.” dungwi. Direre, gir migi aki di kulere, breng bani arere, kuria si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ena Yisas hon aire ere ongure, yal ta bli si pirere, ikwi bolere, yu sirin bol tongwi, “Tisa yal waiye. Na talmere olgere, kwiana mol paralga bani paralga na tenane?” ");
INSERT INTO sll_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dungure Yisas yu ditongwi, “Talongure na yal waiye, di na tene? God tani yal wai momua. ");
INSERT INTO sll_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ni krehaman ha pinirawa. Ari si golkio. Wou sikirere, wi eun yasuri ire pisole olkio. Kuni ta nekio. Yal ta hasu ditekio. Hasu dire yal ta taling tol di nekio. Nimai nabin aki di to dungwo pingirawe” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Tisao, na gir migi molga ali yu oli uga, omaga ari moliwa.” ");
INSERT INTO sll_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dungure, Yisas hanere, yong wai e tere yu ditongwi, “Onga i para onba, tal taniga olkinua. Talhan miki a nenga iwe, ari te mena olere, moni inanga, ebir sirere, ari talhan a nekinangwo yalhobi tenana po. Yu onangere, ni tobo wai hamen bani dinamua. Yu ol pisolere, na tal ol tega ha maing pire na dolna bolo.” ");
INSERT INTO sll_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yu ditongure, yal i nigi di pirere, gumang digan holere, ere ongwi. Ena yal iwe, bona gana miki weni a neiraya dire, miling pirere, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Omia, Yisas grang wine ongwo hobi han wabo direre, yu ditongwi, “Ni piro. Yal ta bona gana miki weni a nenangwo yal iwe, God kene ongwo bani honagrang ala nangwo kulang panamo? ");
INSERT INTO sll_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I ta paikinamua.” Ena yalhobi ha i pirere, ganulun dungwi. Dimba Yisas hon ainere yu ditongwi, “Gir hobo, yal ta God kene ongwo bani ala nangwo hol i kulang panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Te kun hausi hai bun kiaing kun engwo ala iwe, nangwo honagi nega dimba, bona gana miki weni a nenangwo yal iwe, God kene ongwo hol i nangwo nega weni dimua.” ");
INSERT INTO sll_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dungure grang wine ongwo hobi ganulun bir direre, nin diria ole yu dungwi, “God ara aki di tenangure sigare kule u wai namne?” ");
INSERT INTO sll_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dungure, Yisas grang wine ongwo hobi mongwo bani tene han terere, yu ditongwi, “Ari nin onangwo kunu ta paikinamia. God tani onangwo kunu bemia. Talhan hobi God nin ongwo dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ena Pita molere, “Ni piro. Na yalhobi talhan para ai dolere, ni ni dolni bominga yawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“I para bonba, yal ta na ol wai ol tega guna hana i nomani si pir na tere, oo ya, ebring ya, abring ya, ");
INSERT INTO sll_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","keumbi ya, irang ya, aang ya, gir kul nongwo ya, homena ya nongwo pisolere, na honagi ol na terala dire dolna bonangwiwe, omaga malungwo haung, God mong pring hon siina di tenangure, inangwo kunu benamua. Oo ya, ebring ya, keuni ya, aang ya, gir ya, homena ya nongwo miki weni wan handret meri inamua. ");
INSERT INTO sll_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ire monamba, yal tau ol gogo dal tenamia. Tenamba, emgi hamen bani iwe, mol pai gobari weni inamua. Ena ganba baniya ari tau singaba mole eang dire hamil ha sungwo hobi hon u mobing hol namua. Te yal bina kultaing hobi emgi hon singaba mole eang dinamua. Na ha pangwo weni kara diwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena Yisas grang wine ongwo hobi kina Yerusalem nala dire ongwi. Yisas homa emia, grang wine ongwo hobi bangi pirere, nomani miki sungwi. Ari miki weni emgi engwo hobi kul pire pire ungwi. Ungure Yisas grang wine ongwo ari ana holo holo kebena sutani yalhobi ha diterala dire, “Mala wo” dungwi. Dimia ungure, Yisas emgi tal han ol tenangwo meri awa ha di tibi ol tongwi, ");
INSERT INTO sll_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Pino. Omaga nan yalhobi Yerusalem namna dire uminia. Pi pa dinaminga yal tau na Ari Wang Weni na han holere, ha hol ol na terere, ha maing ari singaba tau, God krehaman ha kene ongwo yal tau na tenamia. Tenangure na aule pirere, na si golala dire, ha hol ol na tenamia. Terere, na aule ire pirere ari wiyol ta monangwo bani olamia. ");
INSERT INTO sll_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Olangure yalhobi gauna ha sirere, ebil si na terere, homa kuba na sirere, na si gonamia. Golere, ari habang sui tai dire pai molere, emgi airalua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ena Sebedi wang Yems ya, Yon, yasuri u Yisas mongwo bani urere, “Tisao, na sirin bol ni tenaminga ni talta ol na tenan mo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","37","“Tal ol ni teralga pire dine?” dungwi. “Hamen nabilungwo ai molere, talhan para weni kene ole kemilanga na yasuri u dalni holo holi molabilba?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Ni yasuri ha ogolo pir kun ole dikinia. Ni na gauna gul iralga meri inan mo? Te, na golere, bina nir biralga meri para binano?” dungure, ");
INSERT INTO sll_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Owa, para yu orabilua,” dungwi. “Para dinia. Na gauna gul iralga meri inanio, te na golere, bina nir biralga meri binanga pamia. ");
INSERT INTO sll_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pamba, yal ta u na dalna holo holi monangwo nu ke teralga paikimua. God nin hanere, nu ke tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ena Yisas grang wine ongwo yal ana holo holo ya molere, yal su i nigi de pir terere, kura ha ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ditomba, Yisas yalhobi gala di ku bolere, yu ditongwi, “Baniya yal tau singaba molere, hamil ha sire, gamahobi honagi ha ditongwo hanua. ");
INSERT INTO sll_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yu omba, ni yalhobi iwe, enin hobi nir honagi ol te i pirere, singaba monanua. ");
INSERT INTO sll_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yal ta singaba molala di pinanga iwe, nir honagi oli nanga pamua. ");
INSERT INTO sll_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te na Ari Wang Weni molia. Na hamil ha sire, honagi ha diterala dire, ta huiwa. Nir honagi ol terala dire wiwa. Ganba ari miki weni pring pangwo i na ulbe hane a tere gol tegere sigare kule u wai nama dire, wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ena Yisas grang wine ongwo hobi kina u Yeriko malgi pa dungwi. Pa dire, aidolere, ere ongure grang wine ongwo hobi ari tabin bir weni kina ereho ongwi. Ongure Timias wang omeling gi dungwo yal i, haang Batimias, homaulung bina i ami di mongwi. Molere ari ungwo hobi “Moni na to” dire hong dire mongwi. ");
INSERT INTO sll_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mole pungure, “Yisas Nasarete hong yal irai u momua,” dungwo pungwi. Pirere, gala erakere yu dungwi, “Yisas, Debit gang ye, ni milna pir na tomo?” ");
INSERT INTO sll_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dimba, ari hobi hanere kura ha ditere “sime molo,” ditongwi. Ditomba, yal i hon gala bir dire, “Debit gang ye, aki di na tomo?” ");
INSERT INTO sll_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dungure Yisas pirere ure, “Mala wo dito.” Ditomia ari hobi gala dire, “Yisas gala dimia, ni aire nimni mole wo.” ");
INSERT INTO sll_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dungure yal i galsina gintani kula si olere, gintani aire, Yisas mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ungure Yisas “Na tal ol ni teralga mere pine?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Tisao. Na omena pila dinama di piriwa,” dungwi. “Ni aire hol po. Ni na onangwo pamia di pir na tengiwe, u wai nanua.” Ditongure omeling gi dungwo yali gintani pila dimia talhan i para hanere, hol warere, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ena Yisas grang wine ongwo hobi kina ere pi Yerusalem mala weni pirere, Betpasi Betani malgi hamen hul Olibi u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","U pa direre, Yisas grang wine ongwo hobi ya sutani bai nu si olere, yu ditongwi, “Oo malgi yuwo hano. Hanga bani pirere, kun donki ta han hol engwo monamia. Kun donki iwe, yal ta au sikimia. Ni han hol irere, unana po. ");
INSERT INTO sll_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nanga, yal ta mana di ni tenangworai, yu dito, pi tege eminga yal kun i honagi ol terala dire ire wo, dungwo uminia. Ol wai sinangwo, haya ire bli si unaminua, dito.” ");
INSERT INTO sll_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dungure yasuri pirere, kun donki giring yal kun ta hona grang han hol emia hangwi. ");
INSERT INTO sll_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hanere han gulala dire ongwi. Omba, yal tau mala i molere, “Ni yasu kun donki giring yal kun i, han gulere, ire nano?” ");
INSERT INTO sll_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dungure Yisas ha dungwo meri yal i ditongwi. Ditomia pirere, “O, para dinia, kun i ire po.” ");
INSERT INTO sll_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ditongure kun i ire Yisas mongwo bani ongwi. Pirere, galsina kun donki mobing bani engure, Yisas au sungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Au sungure, ari hobi galsina i homaulung bangi bangi engwi. Engure, yal tau er yolang ba dire, i homaulung bangi bangi engwi. ");
INSERT INTO sll_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Erere, ari iri si emgi homa erere, “God wai pir to. Yasingaba iwe, God bai nu sungure, u tibi u na tomia, wai go piminua. ");
INSERT INTO sll_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nan kwiana moya Debit kene ongwo meri yali hon maulung sire ol na tongwo, wai weni piminua. ");
INSERT INTO sll_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","God wai pir to,” dungwi. Dungure Yisas ere Yerusalem ongwi. Pirere, pi Yuda ha maing oo bir ala pirere, han wabo dungwi. Dire mongure ari ya pi bengwi. Bengure hamen girimia Yisas grang wine ongwo hobi kina ere pi Betani pangwi. ");
INSERT INTO sll_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ena parere honmil irai Betani ai dolere, ere ungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ere bangi ungure, Yisas mena gongwi. Golere hangure, er kwasulu ta ulubi ire bongwo hangwi. Hanere, pi dimani pirere, miling ta honangwo pe nerala dire ongwi. Pire hamba, miling holkungwi. Holkungure aulung obil dungwo hangwi. Er miling hongwo haung ta molkimia, er i hanere ");
INSERT INTO sll_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","“Emgi miling honanga yal ta pe nekinamua,” ditongwi. Ditomia yalhobi pir mongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ena emgi Yisas grang wine ongwo hobi kina u Yerusalem malgi pa dungwi. Pa dire Yisas ere ha maing oo bir ala pirere, ari bona gana tobo ole i mongwo hobi si doling i maini olere, bol a siina manaa direre, moni tobo ole i mongwo hobi si doling i maini olere, bol a siina manaa direre, moni tobo ongwo hobi siru di olere, bol sia hahoba bring sungwo i para a siina manaa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Direre ari bona gana irere, God ha maing oo ala i wakio dire, mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ditere, “God ha yu di emiraya, Na ha maing oo ala i ari hobi ha di na tere tere onamia. Onamba, ni yalhobi ol gogo danga, u homena kuni ari mongwo meri gobere omua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ditomiawe, Yuda ha maing kene ongwo yalhobi te, ha maing nir si tongwo yalhobi Yisas si golala dire hol wa dungwi. Wa dumba Yisas kulung pir tongwi. Ena Yisas ha dungwo ari hobi wai pimiraya, kene ongwo yalhobi nin nigi de pire Yisas si gonamba, arihobi Yisas wai pir tere na si gonam mo di pire kul pungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ena hamen pu dungure, Yisas grang wine ongwo hobi kina Yerusalem ai dolere, ere mena ongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ena honmil sinamoki Yisas yalhobi kina aire hol ongwi. Pirere er kwasulu i hon hangure, kara gongwi. Dulung ya, aulung para gongwi. ");
INSERT INTO sll_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Gongure, Pita hanere, “Tisao, yaulo hanega. Er kwasulu i ni ongi kura ha ditengarai gomia hano,” ");
INSERT INTO sll_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dungure Yisas yu ditongwi, “Ni nomani si piro. ");
INSERT INTO sll_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ni yalhobi God grang wine olere, a i si wananga, ware nomani su su sikire God tani hobang momia di pir tere hamen hul i u dia nir digan ali po dinanga meri, wine ole nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Te ni yalhobi God tani kunu bemia na tenangwo pamia di pire nomani tani sire tal ta irala dire sirin bonanga tali, ere ni tenangwo inanga pamua. ");
INSERT INTO sll_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yu onana dire, ha pangwo kara diwa. Hamen haung haung God ha di te monangiwe, o, yal ta tal gogo ol na tomiraya di pirere, yon ki enga i aidole, yon milni wai e to. Tenanga, Nabin hamen bani mongwiwe, pring pai ni tenangwo i, i ole ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yon milni tekinangiwe, hamen Nabe prin i han uning sinangwo ya di panangwo bani panamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ena Yisas grang wine ongwo hobi kina Yerusalem hon pi pa dungwi. Pa dire, Yuda ari ha maing oo ala ongwi. Ongure ha maing bli mining oo singaba ire, ha maing nir si tongwo hobi ire dire, u pa dire, yu sirin bol tongwi, ");
INSERT INTO sll_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ni ara yulang ni tongwo ire ure, tal maing maing one?” ");
INSERT INTO sll_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ditongure, Yisas yu dungwi, “Na ha tani weniga sirin bol ni tenaminia, ha mong di na tenan mo? Tenanga na yulang na tongwo yal iwe, maing di tibi ol ni tenaminua. ");
INSERT INTO sll_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yon nir bil tongwiwe, God yulang ire bil tom mo, yal ta yulang ire bil tome? Ni yalhobi ha mong di na to.” ");
INSERT INTO sll_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ditongure, yalhobi nin bolbin dire, “Tal ha ditenamne? God yulang tongwo Yon irere, nir bil tomua, dinaminba, na yalhobi Yon pir tekiminia, Yisas Yon pir tekino, di na tenamia. ");
INSERT INTO sll_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te yal ta yulang tongwo Yon irere, honagi omua, dinaminba, te ari hobi Yon pir tomia kura ha di na tenamia. Arihobi Yon God hana togu yal mongwo hamiraya, kura ha di na tenamia. ");
INSERT INTO sll_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Talwa dinamne?” direre, “na yalhobi pirkiminua.” Dungure Yisas yu ditongwi, “O, para dinia, na ere para di tibi ol ni tekiralua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ena Yisas ha bangi biire yu ditongwi, “Yal ta u sirere, wain hani kunamia. Kulere niring dirala dire, maul ta wu enamia. Wu erere, kene ol molala dire, oo ta mini weni bani kenamua. Kerere, sina i yal tau kene ol molo di te olere, yali ere milin ta namua. ");
INSERT INTO sll_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pi molere, miling kul ema di pirere, honagi ari tau bai nu si olamia. Olere, yu di tenamia, nir wain i honagi ol i pirere, miling kul enangwo penangarai, tau ni nerere, tau na i na tenanua, dito. ");
INSERT INTO sll_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ditongure ere namia. Pi pa direre, ha dungwo meri ditongure, bisnis ongwo yali a i si molere, kuba sirere, ere po, ditenamua. ");
INSERT INTO sll_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ditenamia, ere unangure, yal ta hon bai nu si olamia. Olamba, kene onangwo yalhobi hon si algi bil terere, ol gogo dal tenamua. ");
INSERT INTO sll_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ere unamba, yal ta hon bai nu si olamua. Ena yali pi pa dinamba, hon sirere, kara si gonamua. Ena emgi ari miki weni bai nu si olangwo namba, tau si golere, tau si algi bil tenamua. ");
INSERT INTO sll_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ena emgi weni yali nin wang weni yong miling terere, pana wai ganangwo yal iwe, nu si olere, yu ditenamia, ni pirere honagi kene ongwo yal i ditenana po ditenamia. ");
INSERT INTO sll_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ena yal i pi malgi pa dire ditenamba, er miling kene ongwo yali gamahobo kina molere, nin ha hol molere, “Er miling kungwo yal i wang umia hano. Yali si gonaminga, er kungwo ya, te ganba i nan para inaminua” dinamia. ");
INSERT INTO sll_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Direre wang i si gonamia. Si golere, wai di maini olamua. ");
INSERT INTO sll_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ena yu onangwiwe, wain kunangwo yali tal oname? Er kungwo yal i pirere, er kene ongwo yalhobi kara si gol wai sinamia. ");
INSERT INTO sll_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sirere, ganba i hon yal tau tenamua. God homa yu di emiraya di pirkino? Oo kengwo yalhobi torari ire mebin damua dire pisolamia. Pisolangwo torari iwe, God hon ire torari sinangwo bring torari nima ongwo meri dinamua. ");
INSERT INTO sll_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yu onangwo hanaminga wai weni panamua.” ");
INSERT INTO sll_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ena Yuda ha maing kene ongwo yalhobi Yisas ha bangi biire ditongwo i, “Na yalhobi mominga bani umia,” dire agi dinamia. Dinamba, Yisas pir tongwo yalhobi kul pir tere aidolungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ena Perisi tau ire, Herot gamahobo tau ire dire, pi Yisas mongwo bani pirere, ha di mere si tere, sirin bol pinama dire, nu si olungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nu si olungure, pire yu ditongwi, “Tisao. Ni ha pangwo meri kara dinga haminua. Ni gin ta ari ha maing ditenga, yal ta wai pinam mo, nigi de pinam mo, dire, nomani si pire dikinua. Ha kara aru dire diteniraya. Ena God Lo krehaman ha moni takis ya singaba Sisa to dim mo, tekio dime? Tenaminga para panam mo, paikiname?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dimba yalhobi kela kule dungwo i, Yisas haya han pa dungwi. “Talwa di pire kela kul na tene? Moni miling ta ire wo. Na hanamna.” ");
INSERT INTO sll_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dungure moni ta i urere tongwi. “Moni piksa i ara breng biire eme?” ditongwi. “A, i yasingaba Sisa breng biire emua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“O, para dinia. Sisa taling dungwo i, Sisa nin to. Te God taling dinangwo iwe, God nin tenanga pamua.” Dimia yalhobi pirere bukunungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ena Sadiusi yal tau ha maing nir si terere, “Ari gonangwo hon airikinamua,” dungwi. Dungwo yalhobi Yisas mongwo bani urere, yu ditongwi, “Tisao. ");
INSERT INTO sll_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Moses ha ta yu di emiraya. Yal ta temine tere molere, gonamia. Gonangwo eumbi iwe, al werai molere, ebering ta gal enamia. Gal ere molere, al i na igere, gir kul enangwo, abinambi aibing maulung sinama di pinamua. ");
INSERT INTO sll_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Moses yu di emibawe, na di ni tenamna piro. Ena gonangwo yali ebering ana hol pai muru hol pai taniga monamia. ");
INSERT INTO sll_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Molere ebering ta i al i gal enamba, gir kul ekirere, gonamia. Ebering ta hon gal enamba, ere gir kul ekirere gonamia. Te ebering ta hon gal enamba, ere gir kul ekirere gonamia. ");
INSERT INTO sll_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ena ebering hobi para yu gal enangwo gir kul ekirere gonamia. ");
INSERT INTO sll_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Te emgi weni al i gonamia. Ena emgi weni ari gongwo hobi hon airangwo habang i, al i ara wiimbi moname? Yalhobi para weni al tani wiimbi monamo?” Dimba, Yisas yu ditongwi, “Ni ha pir kun ole dikinia. ");
INSERT INTO sll_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ha maing mining ganing bol engworai pirkinga, te God yulang pai tongworai para pirkinua. ");
INSERT INTO sll_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yu olere ha gogo dingiwe. Ari golere hon airangwo habang iwe, yal al mongwo tali hon ta molkinamua. Ensel hamen bani mongwo meri molere, yal al hon ta ikinamua. ");
INSERT INTO sll_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te ari gongwo hon airamua dungwiwe, Moses homa er bani endo dongwo hanere, ha mining bol engworai, kere pirkino? Ha iwe, God ha di Moses tongwo pire mining bol emiraya. Ebraham ire, Aisak ire, Yekop ire dire, maa e tongwo yal God, na tani moliwa. ");
INSERT INTO sll_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Maa e tongwo yali ari gongwo hobi hobang mole kene ol tom mo? Ta tekimia. Ari hon mongwo hobi hobang mole kene ol tomua. Tongwo ipire i kwiana moya Ebraham ire, Aisak ire, Yekop ire dire, kwiang hon momua. Ni yalhobi ha pir kun ole dikinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ena dimiawe, God Lo krehaman ha nir si tongwo yal ta urere, yalhobi grang bani ha diria ol mongure, pungwi. Pimba, Yisas ha wai weni ta Sadiusi ditongure pungwi. Pirere, yu sirin bol tongwi, “God krehaman ha iwe, tal ha mo yu wo ome?” ");
INSERT INTO sll_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dungure Yisas yu ditongwi, “Ni Isrel ari hobi piro. God pir tomingiwe, hobana tani weni momia. ");
INSERT INTO sll_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ni singaba God iwe, kwian tere nomani si pir tere, yulan tere, yon milni tere monanua. Ha iwe, nambawan ha dimia. ");
INSERT INTO sll_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Emgi nambatu ha iwe, ari para weni yon milni tenanua. Ha tau mo yu nangure, ha su i ya ime ta sikinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Tisao. Ni ha pangwo meri dinia. God tani hobana momia yal ta molkimua. Yu omia, nan God tani nomani si pir tere, yona milna tere, yulana para tenaminga meri para dinia. ");
INSERT INTO sll_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te enambi tau yona milna to dingiwe, ha weni kara dinua. Ena God hau si ke tere, honagi ol tongwo wai pamia. ");
INSERT INTO sll_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pamba, ha sutani iwe, wai weni pamua,” dungwi. Ha dungwiwe, Yisas pirere “O, yali nomani wai pangwo pamua,” di pungwi. Pire Yisas yali yu ditongwi, “Ni God kene ongwo hol ulibi molkinia, mala weni monua.” Ditongure ari hobi para emgi hon sirin bol tenamba, kul pir tongwi. ");
INSERT INTO sll_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kul pir tongwo gin iwe, Yisas ha maing oo ala ha yu nir sitongwi, “God krehaman ha nir si tongwo yalhobi ya singaba Kraist Debit gang momua, di na tongwo i, ha weni kara di na tomo? ");
INSERT INTO sll_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","God Kwiang Debit yong wu bilere, di tibi ol tongwo pirere, yu di emia. Hamen ya singaba na hobana yu ditomia, “Ni na ana weni holi ami di molo. Mongere kiani i unaminga doling i mena olanua,” ditomia.(Sam 110:1) ");
INSERT INTO sll_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Debit Kraist ‘Na nan hobana monia’ ditongworai Kraist iwe, Debit gang momo? Molkimua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ena yu ditomia, ari hobi para weni wai pungwi. Yisas ha hon aine nir si tongwi, “Ni krehaman ha nir si tongwo yalhobi ol wangwo meri ol wakinanga pire kwi han molo. Yalhobi iwe, gal arikri weni ole warere, “Na singaba moliwa,” di pinamua. Te, homaulung maket homena bring si nongwo bani wagere, ari hobi na hanere, Singaba umua, di na tenama di pimua. ");
INSERT INTO sll_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te, ha maing oo ala pirere, bol hona weni monangwo hananua. Te, ari homena ta bir ke nenangwo habang iwe, yal i hamil ha si holo holo olangwo hananua. ");
INSERT INTO sll_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ari gongwo eung werai molere, oo ke pangwo ala iwe, pi molere, bal tere, tal a nongwo i tol di inamia. Inangwo yal iwe, God ha gobari weni di tenamua. Yu onamiba, emgi habang kul enangwo God ha hol u tibi nangwo habang iwe, yalhobi gul bir weni inangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ena Yisas ha maing honagi aki dungwo moni boksi dungwo bani ami di mongwi. Molere ari moni olungwo bani han mongwi. Han mongure ari tau moni miki weni pai tongwo hobi miki olungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ena al werai ta urere, moni nol sutani obil olungwi. ");
INSERT INTO sll_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Olimia Yisas hanere grang wine ongwo hobi yu ditongwi, “Ni yalhobi pir molo. Al werai iwe, moni miki ta a nekimia moni olungwo i, moni bir olimua. ");
INSERT INTO sll_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Te yal tau moni olungwiwe, tau a bi ere obil olimua. Te al werai iwe, wiimbi gomiraya obilga a nongwo mere kara ole pisolimua. Emgi homena bring si nenangwo moni ta dikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ena Yisas Yudari ha maing oo mena ongure grang wine ongwo hobi ta yu ditongwi, “Tisao. Hulu ya, te oo i, wai weni kemia hanega.” ");
INSERT INTO sll_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dungure Yisas yu ditongwi, “Owa, i mama kengwo haniba, emgi hulu sigwi dire isusu olamua. Hulu dungwo hanga bani hon ta dikinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ena Yisas ha maing oo aidolere, ere hoibi pirere, Olib hamen hul ami di molere, han ya olere, ha maing oo hangwi. Han mongure, Pita, Yems, Yon, Endru yalhobi Yisas mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ni ha di na tengarai tal habang u tibi name? Tal ta guma hon denangwo, tal i u tibi namua dinanga, pir pa dire monaminba?” ");
INSERT INTO sll_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dungure Yisas yu ditongwi, “Yal ta ure, kela kule ni bal ni tenangwo, pir tenanga pire kwi han molo. ");
INSERT INTO sll_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ari miki weni urere, na hana dal iwo erere, na guung haang pir monga yal irai, wiwa, dinamia. ");
INSERT INTO sll_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dinangure ari miki weni pir tenamua. Te emgi ni monga mala kura u tibi namio, ganba ban ta kura bonamua. Yu onangwiwe, ganulun dikio. Yu onamiba, hamen ganba wai sinangwo haung u tibi ta olo hunamua. ");
INSERT INTO sll_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Te ari wiyol ta pirere, wiyol ta kina kura bonamua. Ya singaba ta gamahobi pirere, yasingaba ta kina kura bonamua. Te maganba i ememe bir onamio, menan bir u tibi namua. Tal yu onangwiwe, agr gir kulala dire, gaung gul pungwo meri, ganba ya, talhan hobi gul yu u tibi namua. ");
INSERT INTO sll_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ni yalhobi nin kwi mole hon molio. Yal tau ni aule ire pirere, ha hol pungwo hobi ni tenamua. Te Yuda ha maing oo ala kuba i urere, ni sinamua. Yu ol ni tenangwiwe, na hana a ime olala di pire onamua. Te yal bir singaba kina ni aule ire nangwiwe, ni ala molere, na tal ol tega ha maing di tibi ol tenanua. ");
INSERT INTO sll_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ganba banta banta ari para muru ha maing i pir pa dinangure, hamen ganba wai sinamua. ");
INSERT INTO sll_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ena ari para ni aule i pirere, ha hol ol ni tenamia. Tenamba, ni yalhobi nomani si pire talwa dirale, dire, kul pirkio. Ha dinanga iwe, God nin i gran bani enangwo dinanua. Ni yalhobi nin ta dikinanua. God Kwiang iwe, yon wu bilere, a kulang pai ni tenangwo dinanua. ");
INSERT INTO sll_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ena si gonama dire, abimbi ta ebering hobi yong bai tal sinamua. Te irang hobi ereyu gamahobi ol tenamua. Te irang aang hobi si gonama dire, wang hobi bai tal sinamua. ");
INSERT INTO sll_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na tal ol tega ha maing pirere, a i si wanangiwe, ari ni hanere, yong ki ei ni tenamia. Tenamba, ni ha maing a gi di warere, monangiwe, God aki dire, a kulang pai ni tenamua. ");
INSERT INTO sll_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ena piro. Tal maing nigi weni dongwo ol terala dire u ai mana dungwo sina i u tibi nangure hananua. Pirere sina i aire monamua,” dungwi. Dungwo bominga iwe, memini pangwo kerere, ogolo piro. “Onangwo gin iwe, Yudia molere, te pirere, hamen hul i molo. ");
INSERT INTO sll_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yal ta malgi molere, hanere, bona gana oo ala dinangwo ire nala di pirkio. Gintani hamen hul po. ");
INSERT INTO sll_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yal ta homena ya nenanga gul i wa molere, hanere, galsina malgi dinangwo ire nala di pirkio. Gin tani hamen hul po. ");
INSERT INTO sll_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Al gir panangwo hobi, te gir aming ne monangwo hobi, tal oname? Kee, miling pirie. ");
INSERT INTO sll_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","God sirin bol terere, “Nimin sinangwo haung u tibi pi na tekio,” di tere molo. ");
INSERT INTO sll_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Onangwo habang i kura talime gul bir u tibi namua. Hamen haya God ari talhan i para ol engwo haung gul ere yu u tibi ta humua. Emgi gul ereyu u tibi ta hunamua. ");
INSERT INTO sll_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te hamen yasingaba gul pinangwo haung si gubu dinamia. Dikinangwiwe, ari para muru u susu nangwo pamia. Pamba, hamen yasingaba nu ke tongwo hobi miling pir terere, gul pinangwo habang si gubu dinamua. ");
INSERT INTO sll_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yu onangwo habang iwe, yal tau urere, “Kraist u timi momia hankino?” yu dinangworai, nomani si pir tekio. Te “Kraist u banta momia hankino?” dinangworai, ere nomani si pir tekio. ");
INSERT INTO sll_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yu dinangwo hobi, Kraist hasu dungwo tabin, te hana togu hasu dungwo tabin u tibi namia. Pirere, tal guma hon dongwo olere, diu sirere, tal maing maing onamia. Olere, ari nomani isusu ol tenamua. Tere God ari nu ke tongwo hobi kela kul terala dire, honagi bir weni onamia. ");
INSERT INTO sll_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Onamba na homa tal i ta u tibi hungure, awa ha tani di ni teiwa. Pir tekinanga pire nomani si pire molio. ");
INSERT INTO sll_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ena kura talime gul oun dongwo pinangwo habang i wai sinangure, ari si bonamio, haba dekinamio, te hamen bani kulmoma yanamua. ");
INSERT INTO sll_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Te hamen bani hamen yulang nimni mongwo hangiwe, ho tere hol wanangwo hananua. ");
INSERT INTO sll_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hananga gin iwe, na Ari Wang Weni kwahawa bolimbani molere, ere ime uralua. Te yulana bir pai na tenangure nimni molere, hamen yong anigi ongwo meri uralga ari para muru na hanangwo pamua. ");
INSERT INTO sll_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hanangure ensel hobi bai nu siralgere, u geral bomai hobil kuman ganba uling holo holi namia. Pirere God ari nu ke tenangwo hobi aule i ku bolala dire namua. ");
INSERT INTO sll_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ena er kwasulu ering bani kwi han monanua. Yolang bani hon pu dire, mine hon onangwiwe, nimin hon yanangwo haung u tibi nangwo hanania. ");
INSERT INTO sll_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hananga meri iwe, ha emgi homa di ni tega meri u tibi nangwo hanania. Hanere, “O, awa ha di engwo irai, omaga mala umia, hona grang a non ole momua,” di pinania. ");
INSERT INTO sll_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ari omaga malungwo hobi ta gol wai sikinangure, talhan i u tibi unangwo hanere emgi gonamua. Ha weni kara di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hamen ganba wai sinamba, te na hana iwe, wai ta sikinamua. ");
INSERT INTO sll_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“U tibi nangwo gin iwe, yal ta pir pa dikinamua. Ensel hobi para ta pirkinamia, te Wang na para ta pirkiralia, Nabe tani weni muru pimua. ");
INSERT INTO sll_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","U tibi nangwo gin iwe, ni yalhobi para pirkinania, kwi mole han molo. Ha ya moni mere ta di ni tenamna pirio. ");
INSERT INTO sll_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yal ta oo ke panangwo aidolere, ere ari yol oo namia. Pirere, boi honagi ari hobi oo malgi kene ol molo dire, pai ole namia. Nangure kwi monangwo yali oo hong yali, na uralga kwi ogolo weni molo, ditenamia. ");
INSERT INTO sll_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na pudinangwo ural mo, ginangwo ural mo, hoale be dinangwo ural mo, honmil sinamoki ural mo, hamen tanangwo ural mo? ");
INSERT INTO sll_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Uralgiwe, ni yalhobi pir pa dikinia, gintani weni uralga dimia, yamoni ul pai molkio. ");
INSERT INTO sll_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na nan ha di ni tegiwe, ari para weni kwi ogolo weni molo, di teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ena hamen haung sutani wai sinangure erin bir u mala namia. Erin bir iwe, yal kun sipi sipi sikere, te breti u bir hongwo ne mongwo haung u pa dinangure, homena bir ke nenamia. Nenangwo haung u mala ongwi. Ena Yuda ha maing singaba God krehaman ha nir sitongwo hobi kina molere, Yisas kul si haning sire, sigolala dire, nomani sire, hol wa dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Erin habang iwe, ari miki weni homena ne monangure, nan Yisas haning sinaminba, ari hobi kura bir bol na tenamua,” dire han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Homa Saimon hakubi dongure Yisas awai ol tongwo yali Betani ke pangwi. Ke pangwo oo ala iwe, Yisas pi bol bani ami di molere, homena ne mongwi. Mongure al ta wel niring, kunu wai ungwo, tobo bir weni bongwo, i ungwi. Urere, grang si pa dire, garu dire, Yisas breng bani bil tongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tomba, ari hobi nigi de pire, ha diria olere, “Wel niring i talongwo gogo bil tome? ");
INSERT INTO sll_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tobo bir teti kina inaminga irai, ari talhan a nekungwo hobi ebir si tenaminga irawe.” ");
INSERT INTO sll_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Direre al i kura ha ditongwi. Tomba Yisas yu ditongwi, “A, kura ha ditekio. Al i nin hang pangwo omia. ");
INSERT INTO sll_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ongwiwe, tal wai weni ol na tongwo i hankino? Yal bina hobi kina ereho moli pirere, emgi talta aki di te monanga bani monania. Na kina moli ubilgarai para wai simia, emgi hon tal ta aki di na tenan mo? Tekinania. ");
INSERT INTO sll_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Omaga al i wel bil na tongwiwe, golalga haung mala umia, na ari yulagi engwo bani na man wu enangwo ipire, yu ol na tomua. ");
INSERT INTO sll_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tal ol tega ha maing ganba ganba i para kunu benangure, al tal ol na tongwiwe, di tibi olangure, ari para nomani si pinamua. Na ha pangwo meri di ni teiwa” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ena Yisas grang wine ongwo yal ta Yudas Iskeriot ha i pirere, pi Yuda ha maing oo singaba yu di tongwi, “Na Yisas gamahobo molia, sigonanga haung mala unangwiwe, na yali monangwo bani di tibi ol ni teralua.” ");
INSERT INTO sll_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dungure Yuda singaba hobi wai pirere, “Di tibi ol na tenanga, tobo moni ni teralua.” Dungure pirere, bai tal sirala dire, homaulung kwi mole han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ena homena breti u bir hongwo nere mongwo habang iwe, erin bir weni ta u tibi ongwi. Ongure, kun sipi sipi yalkun ta si kere nongwi. Nomba grang wine ongwo hobi Yisas yu ditongwi, “Na yalhobi pirere homena makena a kun ole enamne?” ");
INSERT INTO sll_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dungure ena Yisas yal sutani bai nu si olere, yu ditongwi, “Ni yasuri oo malgi po. Pi pa dinanga, yal ta nir hol ire unangwo bangi hanania. ");
INSERT INTO sll_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hanangiwe, doling bol po. Ongere yali oo ala nangwo irai oo hong yal sirin bol piro. “Tisa grang wine ongwo hobi kina homena nerala dimia, weran ta ya dim mo, dikime?” di piro. ");
INSERT INTO sll_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Oo hong yal i weran ta i tibi ol ni tenangwo irai, ala pirere, homena akun onanua.” ");
INSERT INTO sll_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yu ditongure yasuri ere pirere, pi malgi pa dungwi. Pa dungure Yisas ha ditongwo meri u tibi ongure, yasuri homena nenangwo a kun ol e mongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mongure pudungwo Yisas grang wine ongwo hobi kina ungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Urere bol bani ami di molere, homena ne momba, Yisas yu dungwi, “Ni yalhobi monga sina i yal ta na bai tal sinania. Ha weni kara di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dungure yalhobi gumang bani nin han iriala olere, yal tani tani aire, “Na yo? Na yo? I ta olkiralua.” ");
INSERT INTO sll_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dungure Yisas yu ditongwi, “Ni yalhobi monga sina i yal ta onania. Onanga yal iwe, pere bala tani homena ereho nir bole nobilua. ");
INSERT INTO sll_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ha maing mining ganing bol engwo meri irawe, Ari Wang Weni na golalga pamia. Na Ari Wang Weni irawe, na bai tal sinanga yal i, emgi gul bir weni pinania. Aang ta kul ekinangworai, wai panamba,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ena homena ne mongure, Yisas breti ta irere, God homena na tenga wai pir ni teiwa dire, a du dire, yalhobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Terere yu ditongwi, “Na gauna miing ni teiya neiyo” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Direre wain nir ta irere, God ereyu ditere yalhobi tongwi. Tongure nongwi. Nongure, “Nir iwe, na nan algi dimia Na nomani guwa si ni teiya. Ari miki weni God bolo gumang puli ire u tani nama dire, na nan algi u mena namia. ");
INSERT INTO sll_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na nir wain iwe, hon ta nekiralba, emgi God kene ongwo bani pi molere, hon neralua. Na haweni kara di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dungure ul geral ta di wai sirere, Yisas grang wine ongwo hobi kina ere Olib hamen hul i ongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pi mongure Yisas gamahobi yu ditongwi, “Ha maing mining ta yu pamia. God kun sipi sipi kene ongwo yali sigonangure, kun sipi sipi hobi te ususu namua. Yu di emiraya, ni yalhobi iwe, na aidolere, te nania.(Sek 13:7) ");
INSERT INTO sll_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nanba, te na golere hon airalgiwe, homa e ni tere, pi Galili molalua.” ");
INSERT INTO sll_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dungure Pita yu dungwi, “A, yalhobi te namba, na ni ai dolekiralua.” ");
INSERT INTO sll_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dungure Yisas Pita yu ditongwi, “Omaga ginangwo i hoale gin sutani be dinangure, kul pirere, na hana gin sui tai dire di kul sinanua.” ");
INSERT INTO sll_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yu dimba, Pita nimni mole yu dungwi, “A, ni gonangi na para golalua. Ni hani ta di kul sikiralua,” dungwi. Dungure yalhobi Pita dungwo meri doling bole dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ena yalhobi Getsemani ai u pa dungwi. Pa direre, Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi timi molo. Na God ha di terala oiwa.” ");
INSERT INTO sll_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Direre, Pita, Yems, Yon ya su hobi aule ire ongwi. Pirere, Yisas yong sina ering bai tabile hoho mo ungure, nomani si gogo olungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Olere, “Na yona sina i erin bai tabile dimia, golalga mere piria, hon mole han molo.” ");
INSERT INTO sll_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Direre obilga ulubi pire, ikwi bole, God yu ditongwi, “Nabe, ni aki di na terala di pinanga, aki di na to. ");
INSERT INTO sll_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tenanga omaga gul piralga haung u tibi ta hunama di piriwa. Piriba talhan hobi para muru ni hobang monia. Na hana ta paikima. Ni hani pamia, gran wine olalua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Di pisolere, ere yalhobi mongwo bani pire hangure, ul pai mongwo hangwi. Hanere Yisas Pita yu ditongwi, “Saimon, ni ul talongwo pane? Hon molo di ni tegarai molkino? ");
INSERT INTO sll_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Seten ni kraun sire kela kul ni tenangwo pir tekinga pire, ni ul paikirere, God ha moni moni di te molo. Nomani si pinga kulang pangwo yu olalua di pinba, gaun oun dongwo timawe.” ");
INSERT INTO sll_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Di tere, hon ere mena pirere, God ha homa ditongwo meri hon ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Di te pisole ure, hangure, yasu hobi omeling oun dongure, ul pai mongwo hangwi. Hangure Yisas wi dungwo pirere, gintani hon molere, gai golere, pir uning si mongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mongure Yisas hon ere mena pire urere, “Ni yalhobi ul pare uning sire mono? Ena para monia. Na si gonama diga haung irai u mala umia. Ari Wang Weni na irawe, na haning sirere, ari hana yamoni mongwo hobi na tenangwo pamia, han molega. ");
INSERT INTO sll_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aire namna pano. Na bai tal sinangwo yal omaga umia hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ena dire mongure Yisas grang wine ongwo yal ta Yudas, u pa dungwi. Dungure ari miki weni kina ereho ungwi. Ungwo hobi ure, Yuda ha maing singaba ya, ha nir sitongwo ya, kene ongwo hobi nu si olungure, di baina ya, kuba ire ungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ungure bai tal sinangwo yali yu dungwi, “Na homa pirere, yal ta guma mu diralga yali han sinania. Sirere kene ole aule ire po,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ena Yudas homa u Yisas mongwo bani pa dire, “Tisao” dire guma mu dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dungure ari hobi para pirere, Yisas han sungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sire aule ire nala di omba, Yisas grang wine ongwo yal ta di baina ire, Yuda singaba boi honagi yal ta di sungure, kraung bol bali sungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sungwo hanere Yisas yu ditongwi, “Ni yalhobi na na han sirala dire, di kuba ire unia. Ungiwe, yal ta homena kuni nongwo han sirala dire un mo? ");
INSERT INTO sll_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Homa ya monga habang na kina ha maing oo ala ereho molere, ha di ni tega pinga irawe, na han sikiniraya. Ha maing mining ganing homa di engwo irai, omaga u tibi omia hano.” ");
INSERT INTO sll_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yu dungure gamahobi Yisas aidolere, te ongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Omia yagaling ta apalapo pege ta pirere, Yisas ongwo mobing holi doling bol ongwi. Ongure ari hobi pi arere, han sirala di omba, ");
INSERT INTO sll_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","te omia, apalapo kula si ingure, yoluwai bolo ongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ena yalhobi Yisas aule irere, Yuda ha maing singaba ke pangwo malgi ongwi. Ongure krehaman ha nir si tongwo hobi ire, singaba tau ire, ha maing kene ongwo hobi ire dire, u ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Momia Pita Yisas ongwo mobing hol i doling bol pirere, ulubi naa di mongwi. Molere soldia er kwi nu mongwo yal tau, endo pir mongwo bani Pita ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ena Yuda ha maing oo singaba, te u ku bongwo hobi, Yisas si gonama dire ha hol ongwi. Omba, ha dungwo hobo kungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kumia ari miki weni airere, hasu dire kela kul tongure, ha ta u kunu homa. ");
INSERT INTO sll_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Homia yal tau aire ha gogo ditongwi, ");
INSERT INTO sll_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ena yali yu dimiraya, Yuda ha maing oo bir na gintani tulere, ari habang sui tai dire ari oo kengwo tali kekiralia. Hon keralua dungworai, na pir mominua.” ");
INSERT INTO sll_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dimba, ha ere u kunu homa. ");
INSERT INTO sll_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yu ongure Yuda ha maing oo singaba bir weni u sina aire molere, Yisas yu ditongwi, “Ha di mere si ni tongwo i ni mong di tere molkino?” ");
INSERT INTO sll_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dimba, Yisas pir uning si ole mongwi. Mongure singaba i hon yu sirin bol tongwi, “Ni maa e tominga yal God irawe, wang Kraist ni mon mo?” ");
INSERT INTO sll_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dungure Yisas yu dungwi, “Owa, na moliwa. Ari Wang Weni na irawe, God na i aleng weni hol i olangure molalia. Mol i pire emgi kwahawa bolimbani ya ime uralga hananua.” ");
INSERT INTO sll_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dungure singaba i nigi de pirere, nin galsina ongwo aulu dire, yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“God gaung ha sungwo pingiwe, para wai simia. Gonam mo, golkinam mo? Ni ari hobi nin pinanga meri do.” Dungure yalhobi grang para mu dire, “Yal i pring bir pai tomia, gonamua” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Direre yal tau ebil si tere, apalapo ta irere, omeling bani to holere, “Na ni siminia, hana dalo” dungwi. Ena soldia er kwi nu mongwo hobi urere, gaung bane bani di dagi sungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ena Pita maini u sina i mongwi. Mongure ha maing oo singaba honagi ama ta wiyala ongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Omba, Pita endo pir mongwo hanere, tene han terere, “Ni Nasarete hong yal, Yisas, gamahobo monua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ditongure Pita ha di kul sirere, “Haniraba dinga pir kun olekiwe,” dungwi. Direre ere maini nala dire hona i ongwi. Ongure hoale be dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dungure ama i hon urere, Pita hanere, ari mala mongwo hobi ditongwi, “Yal ya yali gamahobo momua” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","“A. Haniraba dinga pirkiwe.” Dungure emgi ari mala mongwo hobi Pita hon sirin bol tongwi, “Ni Galili yal monia, Yisas gamahobi weni kara monua.” ");
INSERT INTO sll_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dungure Pita God maulung bani di yulang bolere, “Na ha pangwo dikiralga God na sigonaamia. Yali weni kara hankiwe.” ");
INSERT INTO sll_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dungure hoale ti be dungwi. Dungure Pita pirere, “Yal hoale gin sutani be dirala di onangwo, na hana gin sui tai dire di kul si na tenanua,” Yisas yu ditongwo irai i kraung bani ere nomani si pir mongwi. Molere, min bile yare simile hai me mongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ena honmil sinamoki Yuda ha maing oo singaba ire, kene ongwo hobi ire, God krehaman ha nir si tongwo hobi ire, yal bir hobi para weni u ku bongwi. Bolere ha holere, Yisas han sungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sire aule ire pire Pailat tongwi. Tongure Pailat molere, yu sirin bol tongwi. “Ni Yuda singaba king bir weni mon mo?” Dungure Yisas, “Ni nin yu dinua” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dungure Yuda singaba ha miki weni di mere si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat pirere hon sirin bol tongwi, “Ha di mere si ni tongwo i, ni ha ta mong di tekino?” ");
INSERT INTO sll_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dimba, Yisas pir uning si momia, Pailat ganulun dire, nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ena erin habang homena bir si gale nere mongwo haung Pailat yal ta haning pangwo gule olungwi. Moni moni yu ongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ongwo haung i, yal ta haang, Barabas, haning pangwi. Pangwiwe, homa Yuda ari gaman kina kura bole yal ta si golere haning pangwi. ");
INSERT INTO sll_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ena Pailat mongwo bani ari miki weni u ku bole mongwi. Molere “Yal ta haning pangwo irai gule ole na to.” ");
INSERT INTO sll_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dungure, Pailat molere, yu nomani si pungwi, “Yuda ha maing singaba hobi para molere, Yisas nigi de pir tere, hani si na tomiraya” di pungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pirere kela kule ditongwi. “Owa, ni nin singaba Yisas gule ole ni tenamin mo?” ");
INSERT INTO sll_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dimba, ha maing singaba ari para weni yong ali bai wure, “Barabas obil gule ole na to.” ");
INSERT INTO sll_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dungure Pailat pirere, “Barabas gule ole ni tenaminia, te Yudari singaba bir weni aule i na tenga i tal ol tenamne?” ");
INSERT INTO sll_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dungure gala dire, “Yal i er pera bani si golo,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ditongure Pailat pirere, “Yu onaminba yali talime ta om mo?” Dungure ari hobi pirere, gala erakere dire, “Er pera bani si golo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dungure Pailat pirere, ari hobi yong aura di terere, Barabas gule ole tongwi. Terere Yisas aule ire pire kuba sire, si gonama dire soldia er kwi nu mongwo hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ena soldia hobi Yisas, aule irere gaman opisi sina ongwi. Pirere soldia para muru gala di ku bongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bongure, yalhobi urere, Yisas galsina mori wai weni ta wa tongwi. Tere han galeng engwo ta irere, ama kere breng bani wa siru ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ditere hasu kewa dire maa e tere, “Ni Yuda ari singaba irawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dire kewa kuba ta ire, breng bani sire, ebil si tongwi. Tere, ya manbi habilai si tongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Terere di gogo dal te pisolere, galsina wai gul olere, hon wa tongwi. Wa tere er pera bani si gonama dire, aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ena omia Sairini yal ta Aleksanda te Rupus irang Saimon, Yerusalem malgi nala dire ungwi. Ungure yalhobi pi guma erere, yalhobi, “Yisas er pera haungwo i ni tol di haunana wo,” ditongwo, haungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Haungure Yisas aule irere, pi Golgota ganba ongwi. Ganba iwe, nan ha Ari Yulagi Engwo dinaminia. ");
INSERT INTO sll_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pirerewe, marasin ta wain nir kina i mu dire, Yisas nenama dire tomba, nekima. ");
INSERT INTO sll_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nekimia er pera bani Yisas kebering aleng nilbli sungwi. Sirere galsina wangwo gulere, sina i erere, nin santu sire aleng bangwo yali i ongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I ongwo habang omare nain klok i pirere, Yisas er pera bani si engwi. ");
INSERT INTO sll_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Erere er gumiling mibi iwe, ha di mere si tongwo i mining bol engwi. Mining bol ere yu ditongwi, “YALI YUDA ARI SINGABA KING TANI MOMIRAYA,” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te bina holo holi iwe, kura bolere, homena kuni nongwo yal sutani daling holo holo er pera bani si engwi. ");
INSERT INTO sll_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","“Kura bole homena kuni nongwo yal momua,” ditomiraya, ha mining yu bol engwi. ");
INSERT INTO sll_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ena ari hobi wiriyala pire gaung ha sire, breng guma gama dire, grabalga ol terere, “Ni ha maing oo bir i tule olere, ari habang sui tai dire keralua, diniraya. ");
INSERT INTO sll_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ni er pera bani monia, wa di manbi womo.” ");
INSERT INTO sll_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ditongure ha maing singaba, te krehaman ha nir si tongwo hobi para gaung ha si tongwi, “Ari tau gongwo aki di tomiraya, ni nin gaung aki di tenam mo? ");
INSERT INTO sll_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te Isrel singaba Kraist ye. Ni er pera bani pisole, manbi unanga hanere, ni hani wine olere, pir ni tenaminba?” dungwi. Ditere, homena kuni nongwo yal su er pera bina holo holo sungwo i, para yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ena ari u sina weni ungure hamen si bongwi. Si bongure moli ongwo ongwo, ari pera wangure, hamen hon tangwi. ");
INSERT INTO sll_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tangure, Yisas gala dire, “Eloi eloi lama sabaktani?” dungwi. Ha iwe, memini yu pamia, “Na God ye, Na God ye, ni talongwo na han uning si oline?” ");
INSERT INTO sll_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dimba, ari tau mala mongwo hobi pirere, “Gir hobo, Ilaiya gala dima pino” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dimba, yal ta bli si pirere, dimin baira me guu kengwo meri iwe, tal ta yu dungwo nir hol nongwo gal ali hongwi. Holere mugu homiri bli wa aki dire, Yisas nenama dire grang wangwi. Warere, “Ilaiya urere, auli manbi olam mo, olekinam mo, hanaminue,” dire han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mongure Yisas gala bir dire gongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gomia Yuda ha maing oo ala gal abalabo bir han hol engwo iwe, sina si oulu di ya ime pirere, u sutani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ena soldia kene ongwo yal ta urere, Yisas gongwo hanere, “Gir hobo. Yal i God wang weni kara momua”, dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ena agr tau ulubi ire naa di molere, tene han mongwi. Mongwo sina i al ta Salomi mongwo, te al ta Maria, Magadala hong al mongwo, te Maria diing, Yems wang emgi ya, te Yosis yasuri aang mongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Al hobi iwe, homa Galili mole warere, Yisas ungwo hanere, aki di tere tere ongwi. Te al tau Yerusalem mole, Yisas kina ereho urere, mongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ena hamen pudungure, Arimatia yal Yosep u pa dungwi. Yal i Yuda ari kaunsel singaba momia haang u bir ongwi. Pirere God kene ongwo hol u tibi unama dire, kwi mole han mongwi. Molere, “Ongi Sabat habang u tibi namia, kenba talhan hobi akun ol eralua” di pungwi. Di pire momba, Yosep ere pi Pailat mongwo bani pirere, kul pirkima, ha kara nubigi di direre, “Yisas yone nan iralba?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dimia Pailat nomani si pire molere, “Yisas haya gomo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Direre soldia kene ongwo yal ta gala dire, “Yisas omaga gom mo, haya gome?” Dungure soldia, “Haya gomua” dungwi. Dungwo pirere, “Yosep ni Yisas yone ni nin inana po,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ditongure Yosep pirere, gal pege ta bring si ire pirere, Yisas yone nin ingwi. Irere gal pege yobilere, hulu grang ala i man wu engwi. Erere hulu bir weni ta i urere, grang bani si pera di engwi. ");
INSERT INTO sll_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Emia Maria Magdala hong al iwe, Yosis aang Maria diing, kina al suri tene han mongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat habang wai sungure, al Maria Magdala hong al ire, Maria diing Yems aang ire, Salomi ire dire, wel paura kunung wai ungwo ta bring sire, ire ongwi. Pirere, Yisas gongwo gaung bani bil terala dire, ire ongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sare bir habang honmil sinamoki al hobi ere Yisas man wu engwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pirere, al hobi nin ha di wa tere, “Kwahulu bir weni hona grang si pera di emiraya, ara urere, i ole na tename?” dungwi. ");
INSERT INTO sll_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Direre, ure hamba, hulu haya i mena olimia hangwi. ");
INSERT INTO sll_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hanere, ala pire hamba, yagaling ta gal pege pirere, ami di momia hangwi. Hanere, ganulun dungwi. ");
INSERT INTO sll_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Ganulun dikio. Yisas Nasarete yal irai, er pera bani si gongwo irai, wa dunga haminia. Yal irawe, baniya molkimia, gaung hon si giu dire airimia. Engwo bani irai dimia hano. ");
INSERT INTO sll_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ni al hobi hon ere memini pirere, Yisas grang wine ongwo yal Pita ya, irai di tenana po. Yisas homa e ni terere, Galili omia. Ni nanga, pi Galili pirere, hanania. Homa ha di ni tongwo meri irawe, yu omua.” ");
INSERT INTO sll_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dungure, al hobi ere maini urere, kwia kulung pirere, te ongwi. Pirere miling si giri gomia ari ta ditekima. Ena para. ");
INSERT INTO sll_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ena Yisas gongwo bani pai molere, Sarebir habang honmil sinamoki gaung hon si giu dire airungwi. Airungure Maria Magdala hong al i kwia nigi dongwo ana holo muru holo sutani i ole tongwo al iwe, homa hangwi. ");
INSERT INTO sll_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hanere Maria pirere, Yisas enin tau hobi ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ditomia yalhobi hai mere, aya maya di mongure, Maria u pa direre, “Yisas gongwo irai, haya airungwo, na hanere wiwa,” dungwi. Dimba, yalhobi Maria ha dungwo i yol e pirkima. ");
INSERT INTO sll_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ena enin tau ya sutani Yerusalem aidolere, banta nala di pirere, Yisas u pa dungwo hangwi. ");
INSERT INTO sll_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hanere ere pirere, grang wine ongwo hobi ditongwi. Ditomba, yalhobi iwe, yasuri ha dungwo ere yol e pirkima. ");
INSERT INTO sll_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ena emgi Yisas grang wine ongwo hobi para weni homena ne mongwi. Momba, Yisas u pa dungwi. U pa dire kura ha ditere, “Ari tau na i tibi ole hanere, na airimua, dungwo i, pirkin mo? ");
INSERT INTO sll_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni yalhobi ganba uling holo holi pirere, na ol wai ol tega ha maing ari para weni ditenana pio. ");
INSERT INTO sll_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ditengere na onangwo pamia di pir na tenangwo hobi iwe, nir bil tenanga God nin sigare kul tenangure u wai namua. Pir na tekinangwo yalhobi emgi si ha hol bolimbani olamua. ");
INSERT INTO sll_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te God tal guma hon ongwo iwe, ari pir tongwo hobi aleng bani emia. Te na hana dalere, kwia nigi dongwo si doling i olania. Te gin ta nin ha pisolere, ha howa ta yure dinanua. ");
INSERT INTO sll_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te onba aleng arere, ari sigonangwo nir ta nenania. Yu onaniba, golkinanua. Te nibil panangwo yalhobi gaung bani ananba, si hon ere u wai namua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ena Yisas ha i di pisolere, God nin aki di ingure, ere hamen bani ongwi. Pirere God kina si daule mongwi. ");
INSERT INTO sll_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Momia grang wine ongwo hobi Yisas ha ditongwo meri iwe, wine olere, u ganba bina holo holi pirere, Yisas tal ongwo ha maing arihobi ditongwi. Di te i ongure, hamen singaba nin kene ol tomia, honagi ol i ongure, tal guma hon dongwo ya, te yulang para tere aki di tongwi. Ena para. ");
INSERT INTO sll_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ena Yal Tiopilas, God tal tau i tibi ol na tongwo, han mominia. Haminga iwe, Yisas yangure bomia. Bolere mo mo mibi pire kuung si mena olungere, gamahobo ari tau hanere, di tibi ol na tomia. ");
INSERT INTO sll_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tongure, ari tau pirere, ha pangwo meri giu dire mining bolere, nu sungure umua. ");
INSERT INTO sll_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Umba, na iwe, kerere sirin bolgere, dinangwo, memini ogolo pir po sire, bol erala di piriwa. ");
INSERT INTO sll_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bol eralga kerere, o, ha pangwo kara dire bol engwo pamua di pinanua. ");
INSERT INTO sll_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ena Yudia singaba king Herot moli ongwo haung iwe, ha maing oo kene ongwo ta, haang Sekaria mongwi. Molere yaliwe, wiyol Abaisa yal mongwi. Molere, kwiang moya yal Eron gang ama Ilisabet ingwi. ");
INSERT INTO sll_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ena yal al suri moli pirere, God grang wine olere, moli pire tal nigi dongwo ta olkungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Olkire molere, al Ilisabet gir ta kul tekungure, yasuri bi dimani engwi. ");
INSERT INTO sll_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ena habang ta yal Sekaraia gamahobo para Yuda ha maing oo honagi ebir sire ol mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mongure, yal Sekaraia ha maing oo ala weran ta pire, endo galere, God engi ol terala dire pire, endo gal te mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te mongwo gin iwe, ari miki weni u maini ku bol molere, God ha di tongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Di te mongure yal Sekaraia ala i molere han ire olimba, kwia ensel ta ure God engi ol tongwo bol mala i mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","13","Mongure Sekaraia hanere, ganulun dire kul bir pungwi. Pimba, ensel yu ditongwi, “Sekaraiao, na kulna pirikio. Ni sirin bol tengiwe, God para pimia, eunbi Ilisabet wang ta kul ni tenamia. ");
INSERT INTO sll_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kul ni tenangure, gir iwe, haang Yon enanua. Enania, milni panangure wai pire monania. Monangere kul nenanga habang ari hobi para hanere wai pinamua. ");
INSERT INTO sll_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pinangure, gir i God honagi ari singaba bir monamua. Molere nir wain te nir nona pangwo ta nekinamua. ");
INSERT INTO sll_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te aang kul nenangwiwe, God Kwiang yong wu binangure, Isrel yal al tau ha maing ditenangure, pirere, God grang wine olere, wa monamua. ");
INSERT INTO sll_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ena God hana togu yal Ilaiya ha maing honagi nimni mole ol mongwo meri yu olere monamua. Molere singaba Kraist homa e te monamua. Molere onangwo ipire ari honagi irang wang hobi kina yong tani ere monamua. Monangure tal nigi dongwo oli ongwo hobi iwe, Yon ha nir si tenangure, pirere ha maing hol i doling bonamua. Bonangwo hobi iwe, Yon ari ire God kebering bani tabin si enamua.” ");
INSERT INTO sll_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dungure Sekaraia ensel yu ditongwi, “Na yal al suri bi dimani mobilia, ni ha weni kara di na ten mo?” ");
INSERT INTO sll_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dungure ensel yu ditongwi, “Na hana Gebriel, God kina si daule molgarai, na nu sungure, ure, ha weni mere di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Teiba, ni ha i pir tekinia, hol ware ha di mena olekire sime monanua. Molere, na awa ha di ni tega i, emgi u tibi nangwo habang i, ha hon dinanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ena Sekaraia werang ta ala mongure ari hobi maini kwi molere, “Haya humia tal ome?” di pungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Di pimba, Sekaraia emgi mena ure grang obe abe yamia hanere, o, tal ta ol tongwo pamua, di hangwi. Hangure Sekaraia yamoni grang pera dire aling hol wai engwi. ");
INSERT INTO sll_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Erere honagi wai sungure ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ena emgi eumbi Ilisabet mindebe ongwi. Ongure haba ana hol pai muru oo ala pai mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Molere yu dungwi, “Ari hobi na temini tomua dire wa gol na tomiraya, omaga hamen singaba gir i na tongure molia, ari mongwo maulung bani gai ta golkiralua.” ");
INSERT INTO sll_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ena Ilisabet mindebe olere, haba siks mun mongure, God kwia ensel Gebriel hon nu si olungwi. Nu si olungure Galili ganba Nasaret oo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pirere singaba Debit gang ta yal Yosep nu ke tongwo ama ta, haang Maria, ama i mongwo bani pi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pa dire yu ditongwi, “Amagirye. Ni God miling ala pania, God ni kina ereho mol pai onanua.” ");
INSERT INTO sll_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dimba Maria pirere nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dalere yu di pungwi, “I tal ha di na tome?” di pungwi. Di pimba, ensel hon yu ditongwi, “Mariao, kul pirikio. ");
INSERT INTO sll_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","God yong miling ni tere wai pir ni tomia. Pino. Ni gir parere wani ta kul enania. Erere haang Yisas enanua. ");
INSERT INTO sll_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Engere yal i yal bir monamia. Monangure God, “Na wana momua” dinamia. Yaung singaba king Debit aibing maulung sire monamia. ");
INSERT INTO sll_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ena gir kul nenangarai kwian moya Yekob gang malungwo hobi para weni breng a holo sire kene ol te monangwo bani monamua.” ");
INSERT INTO sll_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dungure Maria ensel yu ditongwi, “Na amagir molia, yal ta heba bil tekia, talongwo gir paralga han dine?” ");
INSERT INTO sll_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dimba ensel yu ditongwi, “Ena God Kwiang u ni yobilere yulang ni tenangure gir inanua. Inaniawe, gir i kul enanga ari wang ta molkinamia, God nin wang monamua. ");
INSERT INTO sll_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ena ni yon Ilisabet iwe, al dimani mole temini tomiraba, mindebe omia, wang ta miing ala haba siks mun pai momua. ");
INSERT INTO sll_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Te arihobi talhan ta onangwo kunu panamo? Ta paikinamua. ");
INSERT INTO sll_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","God nin muru ongwo pamua.” Dungure Maria yu dungwi, “Na hamen singaba honagi ama molia, ni ha dinga meri yu ol na tomo.” Dungure ensel pirere, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ena habang gin iwe, Maria mo hamen hul pirere, Yuda oo malgi ta ongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pirere pi yal Sekaraia oo malgi ala pirere, al Ilisabet “Alhuno” dire gala dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gala dungure gir miing ala mongwo i, pirere, ibil sungwi. Sungure God Kwiang, Ilisabet yong sina pire wu bungure, Ilisabet gala bir dire Maria yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“God al hobi kene ol tomba, ni ni kene ogolo weni ol ni tomua. ");
INSERT INTO sll_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Terere gir miin ala mongwo i aki di tongwo pamua. Na nan hobana aang na molga bani unia, hanere God wai pir teiwa. ");
INSERT INTO sll_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ni “Alhuno” dire gala dingiwe, na gir miina ala molgi wai pirere, ibil simia hano. ");
INSERT INTO sll_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God awa ha di ni tongwo i nima namua di pinga pamia, milni pangure gun enua.” ");
INSERT INTO sll_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ena Maria yu dungwi, “Na God pir tere molga milna pamua. ");
INSERT INTO sll_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God na aki di na tomia sigare kule nomani kwiana God tere moliwa. ");
INSERT INTO sll_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na God honagi ol tere digan moliba, God na na wai hanere kene ol na tomua. Tomiawe, emgi gir hon malangwo hobi na hana a yuwo olangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ena God tani mokene kumia tal wai ol na te mongwo bani momua. Molere haang nima pire mamaki ya di panangwo panamua. ");
INSERT INTO sll_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yal tau God grang wine onangwiwe, miling pir tere awai ol te monangwo monamua. ");
INSERT INTO sll_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God yal nona pare honagi nimni mole omia kuru dungwo yalhobi iwe, sire isusu ol tomua. ");
INSERT INTO sll_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Te God yal bir mole hamil ha sungwo hobi hon a ime ol tenangure, yal bina kultaing mongwo hobi God yulang tongure hon aire singaba mole hamil ha simua. ");
INSERT INTO sll_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Te menan gole wa mongwo hobi, God me heba tongure nomua. Nomba, bona gana miki a nere nimni mole wangwo hobi, God han gogo dal olungure yamoni omua. ");
INSERT INTO sll_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God Isrel arihobi kene ol teralua di pire aki di tomia. Tongwiwe, hongebe God awa ha di kwiana moya tongworai, omaga nima omua. ");
INSERT INTO sll_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Awa ha iwe, yu pamiraya. Yal Ebraham na miling pir tere te emgi gang hon malangwo hobi miling pir te molalga molalua,” dire Maria ha para wai simia. ");
INSERT INTO sll_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Ilisabet kina ereho haba sui tai dire pai molere, ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ena al Ilisabet moli pire haung mala ungure, wang kul engwi. ");
INSERT INTO sll_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kul engure God al i aki di tongure, ari eni abeng hobo gamahobi wai pire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ena ari habang eit wai sungure, ari hobi u ku bole gaung bol olere irang Sekaraia nin haang enamna dire dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dimba aang Ilisabet mana dire yu dungwi, “Sekaraia dikio. Haang Yon eyo.” ");
INSERT INTO sll_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dungure ari hobi yu ditongwi, “Ni enin abin ta haang yu paikungwo irawe.” ");
INSERT INTO sll_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Di di olere, irang Sekaraia ha dikire sime mongure, ari hobi aleng hol wai ere wani i ara haang enamne?” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dungure irang pepa ire mining yu bongwi, “Yal i haang Yon, enanua” dire, mining bol engwi. Emia ari hobi hanere, nomani gogo sire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mongure yal Sekaraia gintani aire grang kulang pangure ha dungwi. Dire God maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tongure eni hobi para hanere, grang dalungwi. Grang dalungure tal ongwo ha i Yudia hamen hul kepangwo hobi ha wai ha i para weni pir pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pirere nomani si mole yu dungwi, “Gir i bir dale emgi tal oname?” Dungure ari hobi para hamia, God gir i kene ol tongure momia, hangwi. ");
INSERT INTO sll_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ena God Kwiang Yon irang Sekaraia yong wu bungure, awa ha dire yu dungwi, ");
INSERT INTO sll_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nan Isrel ari hobi God maa e tomno. Yal iwe, urere nin ari hobi aki di tere, tal nigi dongwo ongwo God pring tongwo i tobo tongure nan Isrel ari sigare kule u wai ominua. ");
INSERT INTO sll_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Te God honagi ari Debit gang giri ta nan mominga bani urere, torari nimni mongwo ta a tan bongure aki di na tomua. ");
INSERT INTO sll_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Homa God hana togu yal hobi grang bani awa ha yu di emiraya, omaga u tibi ongure haminua. ");
INSERT INTO sll_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nan kiana pai na tere ol gogo dal na terala dire ongwo bani iwe, yal i ure a poira si na tenamua. ");
INSERT INTO sll_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God nan kwiana moya yalhobi kina ha di tani engwo i nima pire pangure pai omia, ");
INSERT INTO sll_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","omaga God nomani ura dinangure para yu ol na tenamua. Ena nan kwiana moya Ebraham mongwo bani, God di yulang bomiraya, omaga nan kiana mongwo sina i a poira si na tenamua. ");
INSERT INTO sll_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tenangure God honagi ol terere, mol i pire si hon e na tenangure pring paikinangwo moli pire gonamna. ");
INSERT INTO sll_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ena wana ye, bir dalere, God hana togu yal monanua. Molere hamen singaba hol i a ga dire homa e tere bala ditenanua. ");
INSERT INTO sll_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tere gaminahobi ha maing nir si tengere pir po sinangure, God hanere miling pir tere tal nigi dongwo ol wangure God pring tongwo i kri di ole tenamua. ");
INSERT INTO sll_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tenangwiwe, hamen tangwo meri yu u tibi pi na tenamua. ");
INSERT INTO sll_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tenangwo haung iwe, ari si bongwo bani yone pai mongwo hobi para au di tenamua. Tenangure mol pai dirin monaminga hol wai u tibi nangure hanere, para egere doling bonaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ena emgi gir i bir dalere, ari nomani sire momua. Molere ganba po engwo bani mol pai ol i pire, emgi Isrel ari mongwo bani u tibi pi tongure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ena habang gin iwe, singaba Sisa Ogastas ari haang bonama dire ganba bina holo holi gala dire di ku bongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Haang bongwo gin iwe, Sairinius gabman nambawan molere, Siria ganba kene ol mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mongure yalhobi ure haang dangwo esa dirala dire pi malgi ku bongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ena Galili probins Nasaret oo malgi yal Yosep molere, ere pire pi Yudia probins Betelehem oo malgi ongwi. Ena Betelehem oo malgi iwe, hamen haya Yosep kwiang moya singaba king Debit u tibi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Omia gang Yosep nu ke tongwo ama Maria kina pi pa dire esa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dire mongure Maria gir kulala dire yong gul sungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sungure wang kulere gal yobilungwi. Yobilere oo ala ta enamba, ari miki weni haang esa dire oo si di dimia, kun bulamahau oo ala pire gir i kun homena nongwo bol bani engwi. ");
INSERT INTO sll_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ena kun sipi sipi kene ongwo yal hobi girungwo mena i kene ol mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mongure God kwia ensel ta ungure nabilere hamen tangwo meri dungwi. Dungure yalhobi hanere ganulun dire kul bir pungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kul bir pungure ensel yu ditongwi, “Ni na kulna pirikio. Na ha wai ire uga di ni teralia, pinanga miling panangure ari hobi para weni gun ere monanua. ");
INSERT INTO sll_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kenba kwian moya yal Debit oo malgi agr ta gir kul nomia. Gir iwe, singaba Kraist yal bir molere, ni yalhobi aki di ni tenangure sigare kule u wai nanua. ");
INSERT INTO sll_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ha wo dimin mo? Ni yalhobi pi malgi pire kun bulamahau oo ala hanana pio. Pirere kun homena nongwo bol bani gir gal yobile enangure pai monangwo hanania pio.” ");
INSERT INTO sll_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yu ditongure gintani kwia ensel miki weni ure God maa e te mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Molere yu dungwi, “Hamen bani yuwo God tani momia, hang awala gale maa e tomno. God ganba ari para weni wai pir tomia yong ura dimo.” ");
INSERT INTO sll_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kwia ensel hobi siina di hamen bani ongure kun sipi sipi kene ongwo yalhobi nin ha diriyala olere yu dungwi, “Nan ha di na tongwo irai, Betelehem malgi pire wa du hanaminua.” ");
INSERT INTO sll_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dire gintani pi malgi pa dire Maria Yosep kina hanere, pi kun homena nongwo bol bani gir i pangure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hanere ensel ha dungwo meri ari hobi di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ditongure ari hobi pirere nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Damba, aang Maria ha i para weni nomani si pire a i si mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ena kun kene ongwo yalhobi hon ere memini pire, kwia ensel ha ta ditongwo, te tal pire hane ongwo meri nomani si pire, God maa e te mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ena Yisas gir u tibi pire hamen haung eit mongure, gaung bol olere haang Yisas engwi. Haang iwe, gir i olo ta kul ekungure, ensel homa awa ha dire haang i engwi. ");
INSERT INTO sll_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ena God hana togu yal Moses ha di engwo i, Yuda ari memini pangwo meri aang oo maini ungure, Yosep gir aang kina aule ire pi Yerusalem malgi pire, God nu ke tenama dire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","God krehaman ha yu di engwo pamia, “Wani homa kul enanga aule ire ha maing oo pire God ni teiwa di to. ");
INSERT INTO sll_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tere ere hamen singaba pir tere, yumil su mo te hau gan giri su ha maing homena si gangwo bol bani ere God to.” Dungwo meri gir irang aang suri wine olere, yu ol terala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ongure Yerusalem yal ta haang Simion yal iwe, ha maing ogolo dime di pire mongwi. Molere Isrel ari mongwo bani ha maing hong weni u tibi pire sigare kul tenangure u wai nama di pire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mongure God Kwiang yal Simion yong wu bilere yu ditongwi, “Ni olo golkinangere hamen singaba Kraist u tibi nangure hananua.” ");
INSERT INTO sll_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ditongwo pire mongure, emgi God Kwiang yal Simion hon yong wu bungure ha maing oo bir ala ongwi. Ongure Maria Yosep kina ha maing wine olere, Yisas aule ire ha maing oo ala pire God tongwi. Tongwo i Yudari nin memini pangwo meri wine olere tongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tongure yaldimani Simion gir i kulere, God di yuwo olere yu maa e tere yu dungwi, ");
INSERT INTO sll_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O God ha maing hong u tibi ungwo hanere, ha i pire nomani si pire ha maing bani na engere moli pire golalua. ");
INSERT INTO sll_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ni arihobi aki di tere sigare kul tenama dire gir i tenga haniwa. ");
INSERT INTO sll_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Gir i ari para weni au di tenamua. ");
INSERT INTO sll_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ni ha maing kewa galere ari hana ya mongwo hobi hol nibil di tenanua. Te na Isrel arihobi mominga bani ari kulang gi dire nabile poira sungwo meri mominua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ena yal Simion ha dungwo i Yisas irang aang suri pire nomani si gogo olungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Olimba, Simion aang irang gir para kuria si tere Maria yu ditongwi, “God gir i nu ke tongure molere, Isrel ari hobi ol tenangure tau nimni mole aire monangure tau yanamua. Te God nin gir i bai nu si olungure, God ha maing hol nibil di tere monangwo ari tau hanere aling diri bol tenamua. ");
INSERT INTO sll_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mariao, ni iwe, tal onangwo i hangere milni gul sinamua. Te tal onangwo iwe, gir i olere, ari hobi nomani si pinangwo meri i tibi olamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ena God hana togu al ta momia. Al iwe, haang Ana yal Panuel aung momia. ");
INSERT INTO sll_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yal Panuel iwe, yol Asa yal momia. Te al i aldimani weni me erin eti po yia mongwi. Homa wiimbi kina me erin seben yia molere wiimbi gongure al werai mongwi. Molere ha maing oo ala wine ole pire ha maing pir mongwo bani mongwi. Molere God ha di terala dire, haung tau homena mai tere mongwi. Mongwiwe, hamen girungwo tangwo para yu ol tere tere mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ena Maria gir aule ire ala u mongwo haung i, aldimani urere God “Wai onua” ditere, Yerusalem malgi ha maing panama dire kwi mongwo hobi, “Gir i Yerusalem malgi hobi aki di na tenamua” dire di tibi ol te mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ena God ha di engwo meri irang aang suri wine olere, yu ol pisolere, gir i aule ire, ere Galili probins Nasaret oo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pi mongure gir i bir dale, ari nomani pangure, God kene ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ena Isrel ari erin Pasoba ta nomani si pire erin mongwi. Homa hamen singaba wang homini para muru si gonamba, Isrel ari hobi han uning sungwi. Erin haung iwe, haung haung i Yisas irang aang suri kina Yerusalem pi mongwo bani mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ena yagaling Yisas me erin ana holo holo kebena sutani mongure erin haung u mala ongwi. Ongure irang aang suri aule ire Yerusalem ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pi mongure erin i wai sungure, irang aang suri ere bangi omba, Yisas nin Yerusalem mongure hankire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pirere irang aang suri nomani si pungwo ari ta kina hol ire uma di pungwi. Pirere girungwo ari hobi mongwo bani wa du wangwi. ");
INSERT INTO sll_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wangwo hon ekungure siina dire wa du mo Yerusalem ongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pirere Yerusalem oo malgi holo holi haung sui tai dire wa dungwi. Wa dungwo hon ekungure pi ha maing oo ala pire hamba, ala momia hangwi. Molere ha maing tisa hobi kina ha sirin wire yala pi momia hangwi. ");
INSERT INTO sll_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ha sirin bol tongwo bani Yisas ha dungwo iwe, ari hobi pirere gir i nomani bir pamia dire grang dalimia mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ena irang aang suri pi pa di hanere, ganulun dungwi. Aang pire yu ditongwi, “Wana ye. Na yal al suri tal gogo ol na tenia, talongwo ol na tene? Na nabin kina nomani si gogo dalere ni wa dubilua.” ");
INSERT INTO sll_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dungure Yisas yu ditongwi, “Hamen Nabe ha maing oo ala molgi hankino? Talongure ni yasuri na wa dune?” ");
INSERT INTO sll_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ditongwo yal al suri ha i memini pir po sikungwi. ");
INSERT INTO sll_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ena sikungure Yisas pi irang aang suri hongure aule ire ere Nasaret malgi ongwi. Pirere, Yisas irang aang suri grang wine olere wa mongwi. Ena aang iwe, wang Yisas tal olere ha dungwo i para weni i nomani sina ering si erere a i si pire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mongure Yisas bir dale ari molere nomani wai pamia, God ari kina Yisas ol wangwo i hanere tal wai omua, di hangwi. ");
INSERT INTO sll_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ena singaba Sisa Taibirias me erin piptin molere, ganba para muru kene ol mongwo gin iwe, Pontias Pailat Yudia probins nambawan gabman momia. Te yal Pilip singaba molere, Ituria probins ire, te Trekonaitis probins ire dire, i mu dire, kene ol momia. Te Galili probins ebering Herot kene ol momia. Te Aibilini probins yal Laisenias kene ol momia. ");
INSERT INTO sll_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te Anas, Kaiapas kina hetpris molere, Yuda ha maing oo kene ol momia. Mongwo gin iwe, yal Sekaraia wang Yon ganba po engwo bani u tibi ongwi. U tibi pire gin ta God ha dungwo pungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pirere Yodan nulu bina holo holi warere, ari hobi yu ditongwi, “Ni tal nigi dongwo ol wangiwe, nigi de pir tere, nomani si kulu sire, hon olkirala di pinanga, nir bil ni tegere God prin ni tongwo i kri di ole ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dimia God hana togu yal Aisaia homa awa ha di engwo meri irawe, omaga nima omia. “Ganba po enangwo gul i, yal ta gala dire yu dinamia, hobana pi tege eminga yal unamia hol bala di to. Ditere akun ol enangere, u wai nangure, yal i unamia. ");
INSERT INTO sll_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te ganba mongwo yangwo si sulere hamen hul i baning ol enamia. Hol gengwo bangwo iwe, a yo te enangure, hol mongwo yangwo si sule i baning olamia. ");
INSERT INTO sll_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Olangure ari para weni God ari hobi aki di tere sigare kul tenangwo i han pa dinamua.” ");
INSERT INTO sll_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ena ari miki weni Yon nir bil na tenama dire ungwi. Umba Yon yu ditongwi, “Ni hasu ari onba giri mongwo meri mole unia, emgi hon siina di mena pire, tal nigi dongwo onanga pamia. Pring pai ni tongwiwe, God ni sinangure ti siina dinanga pamia, ara di ni tongure une? ");
INSERT INTO sll_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ni yalhobi tal nigi dongwo ol wanga i nigi de pire tere nomani si kulu sire, hon olkirala di pinanga, miling i tibi olan mo? Olangarai olere, nomani yu si pinania, na Ebraham gamahobo moliwa. Yu dinangiwe, God kwahulu i ire, Ebraham gang ol enangwo pamia. Ha weni kara diwa. ");
INSERT INTO sll_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Di sire er dimani bani homa nu ke engwiwe, nima pire ya pai momia, er miling holkinangwo hobi werere, endo ganangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dungure ari hobi Yon hon sirin bol tongwi, “Na yalhobi tal onaminga pire dine?” ");
INSERT INTO sll_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dungure Yon yu ditongwi, “Ni galsina sutani a nenangiwe, yal ta gal a nekinangwo yal i ta tere nin ta wayo. Te ni homena nenangiwe, yal tau homena dikinangwo menan gole monangwo hobi tau tere nin tau no,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ena takisi ingwo yal tau Yon nir bil na tenama dire u pa dungwi. Dire yu ditongwi, “Tisao, na yalhobi tal onamne?” ");
INSERT INTO sll_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dungure Yon yu ditongwi, “Ni gabman moni takisi iyo dire bai ni tenangwo meri obil inana pio. Ni yalhobi hasu dire moni ta kuni ikio.” ");
INSERT INTO sll_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dungure polisman tau ure hon sirin bol tongwi, “Na yalhobi tal onamne?” Dungure Yon yu ditongwi, “Na polisman molia dire, hasu kela mala kule yal ta taling tol di nekio. Gabman tobo aling bani ni tenangwo meri obil iyo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ena ari hobi pirere, tal ta hon u tibi unama dire nomani si pungwi. Pirere Yon hanere, God nu ke tongwo yal Kraist mom mo? di hangwi. Hangure Yon yu ditongwi, “Na nir bil ni teiwa. ");
INSERT INTO sll_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Teiba yal ta emgi unamua. Unangwo yal iwe, yulang kunu panangwo na yulana kunu ta paikinamia. Te na gal bala kine teralba, digan ganba ari moliwa. Na nir wo bil ni teiba, yal iwe, God Kwiang bai nu sinangure, yal tau yon wu binangure, er gang ganga de bilo dire, gaun bani engwo meri enamua. ");
INSERT INTO sll_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Te homena miling iwe, perere, i ku bol ere, miling panangwo tal iwe, kri di i pi oo ala i erere, te miling paikinangwo tal iwe, kri di pire endo dongwo bani ganangwo pamia. Ganangwo de wai ta sikinamua.” ");
INSERT INTO sll_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dire ha maing miki weni nir si tere, ari nomani si hon enama dire di tongwi. ");
INSERT INTO sll_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ena Yon king Herot kura ha di tere, “Ni ebin Pilip eumbi al Herotias tol dire wou si inga i nigi domio, te tal tau ol wanga i ere para onga paikimua.” ");
INSERT INTO sll_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ditongure Herot nigi de pire yal Yon halabusi sire i pi hani oo ala engwi. ");
INSERT INTO sll_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ena Yon ari hobi nir bil te mongwo gin iwe, Yisas para u pa dire nir bungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nir bilere God ha ditongure, hamen hona grang saang dungure, God Kwiang hahoba yumil mongwo meri molere, ya ime ure, Yisas breng bani momia hangwi. Hangure hamen bani ha ta yu ya ime ungwi, “Ni na wana tani monia, milna ala pania, tal onga i wai pir ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ena Yisas me erin teti yia molere ha maing kebering holere nir si te mongwi. Mongure ari hobi yal Yosep wang moma di hangwi. Yosep iwe, irang Hilai momia. Te Hilai iwe, irang Matat momia. ");
INSERT INTO sll_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat iwe, irang Liwai momia. Liwai iwe irang Melkai momia. Melkai iwe, irang Yanai momia. Te Yanai iwe, irang Yosep momia. Yosep iwe, irang Matataias momia. ");
INSERT INTO sll_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matataias iwe, irang Emos momia. Te Emos iwe, irang Neam momia. Neam iwe, irang Eslai momia. Eslai iwe, irang Nagai momia. ");
INSERT INTO sll_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai iwe, irang Meat momia. Te Meat iwe, irang Matataias momia. Matataias iwe, irang Semen momia. Semen iwe, irang Yosek momia. Yosek iwe, irang Yoda momia. ");
INSERT INTO sll_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda iwe, irang Yoanan momia. Te Yoanan iwe, irang Resa momia. Resa iwe, irang Serababel momia. Serababel iwe, irang Sialtiel momia. Sialtiel iwe, irang Nerai momia. ");
INSERT INTO sll_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai iwe, irang Melkai momia. Melkai iwe, irang Edai momia. Te Edai iwe, irang Kosam momia. Kosam iwe, irang Elmedam momia. Elmedam iwe, irang Ea momia. ");
INSERT INTO sll_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Te Ea iwe, irang Yosua momia. Yosua iwe, irang Eliesa momia. Eliesa iwe, irang Yorim momia. Yorim iwe, irang Matat momia. Matat iwe, irang Liwai momia. ");
INSERT INTO sll_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai iwe, irang Simion momia. Simion iwe, irang Yuda momia. Yuda iwe, irang Yosep momia. Yosep iwe, irang Yonam momia. Te Yonam iwe, irang Elaiakam momia. ");
INSERT INTO sll_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakam iwe, irang Melia momia. Melia iwe, irang Mena momia. Mena iwe, irang Matata momia. Matata iwe, irang Netan momia. Netan iwe, irang Debit momia. ");
INSERT INTO sll_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debit iwe, irang Yesi momia. Yesi iwe, irang Obet momia. Obet iwe, irang Boas momia. Boas iwe, irang Salmon momia. Salmon iwe, irang Nason momia. ");
INSERT INTO sll_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason iwe, irang Aminadap momia. Aminadap iwe, irang Admin momia. Admin iwe, irang Anai momia. Te Anai iwe, irang Hesron momia. Hesron iwe, irang Peres momia. Peres iwe, irang Yuda momia. ");
INSERT INTO sll_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda iwe, irang Yekop momia. Yekop iwe, irang Aisak momia. Aisak iwe, irang Ebraham momia. Ebraham iwe, irang Tera momia. Tera iwe, irang Neho momia. ");
INSERT INTO sll_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Te Neho iwe, irang Serak momia. Serak iwe, irang Riyu momia. Riyu iwe, irang Pelek momia. Pelek iwe, irang Iba momia. Iba iwe, irang Sila momia. ");
INSERT INTO sll_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila iwe, irang Kenan momia. Kenan iwe, irang Apaksat momia. Apaksat iwe, irang Sem momia. Sem iwe, irang Noa momia. Noa iwe, irang Lemek momia. ");
INSERT INTO sll_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek iwe, irang Metusala momia. Te Metusala iwe, irang Inok momia. Inok iwe, irang Yeret momia. Yeret iwe, irang Mahalalil momia. Mahalalil iwe, irang Kenan momia. ");
INSERT INTO sll_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan iwe, irang Inos momia. Inos iwe, irang Set momia. Set iwe, irang Adam momia. Te Adam iwe, irang God momua. ");
INSERT INTO sll_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ena God Kwiang molere, Yisas yong wu bungure, Yisas Yodan nir nulu pisolungure, God Kwiang Yisas aule ire, ere ganba po engwo bani pire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mongwo haung i, yal su kebering aling muru mongure, Seten ure, kraung sire, kela kul tenama dire, ongwi. Ongure Yisas homena nekirere, simo pare pare mongwi. Molere menan bir gongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gomia kwia nigi dongwo singaba Seten ure yu ditongwi. “Ni God wang weni monanga, kwahulu mala i dingere, u homena nangwo nenaminba.” ");
INSERT INTO sll_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dungure Yisas Seten yu ditongwi, “Ha mining ganing ta yu pamia, Ari homena tani nomani tere, molkun ta olekinaminua.” ");
INSERT INTO sll_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dungure Seten Yisas aule ire, mo mini bani ongwi. Pi molere ganba ganba ari tabin tabin i tibi olere, Yisas yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Talhan hanga hobi na kene ol moliraba, yal ta terala di piralga teralga pamia. Talhan maing maing don miki weni hanga hobi yulang ni tegere kene ol monanba. ");
INSERT INTO sll_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Molala dinanga ikwi bol na tere, guman na tenanga talhan i ni teralga kene onanua.” ");
INSERT INTO sll_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dimba, Yisas yu ditongwi, “A, ha mining ta yu pamiraya, God tani weniga i kwi bol tere, gumana tenaminia. Terere honagi di na tongwo meri wine ole ol tenaminga pamua.” ");
INSERT INTO sll_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dungure Seten Yisas aule ire Yerusalem malgi pire, ha maing bling mini oo bir bring bani ongwi. Pirere yu ditongwi, “Ni God wang kara weni monanga, iri so. ");
INSERT INTO sll_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iri sinanga, ta bolkinania. Ha mining ganing ta yu pamiraya, God kwia ensel hobi grang ha ditongwo meri wine olere ni kene ol momua.” ");
INSERT INTO sll_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Te ha ta yu pamia, “Ure ni aki dinangwo, hulu kebin ta bolkinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dimba, Yisas Seten yu ditongwi, “I dinba, ha mining ta yu pamia, Hobana God kela kul tekio.” ");
INSERT INTO sll_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dungure Seten kela kul te i ongwo tamangure ere pire gin ta unangwo kwi mongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ena God Kwiang Yisas yong wu bilere aule ire ere Galili probins ongwi. Ongure tal ongwo ha guung i si dina dire ganba bina holo holo i para kunu bemia ari pungwi. ");
INSERT INTO sll_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pungure Yisas Yuda ha maing oo para muru wa pisolere ha maing nir si tomia, ari hobi pire bukunere, yali haang a yuwo olungwi. ");
INSERT INTO sll_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ena homa Yisas gir migi mongwo haung Nasaret ke pangwo malgi omaga hon u pa dungwi. Ena Sabat haung ha maing oo ala moni moni ongwo tali omaga yu ongwi. Pirere ha maing buku kerala dire airungwi. ");
INSERT INTO sll_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Airungure God hana togu yal Aisaia awa ha mining bongwo buku i tongwi. Tongure awala gale wa dungwi. Wa dure ha mining ta i tibi olere yu dungwi, ");
INSERT INTO sll_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God Kwiang na yona wu bimia. Bungure ari yal bina mongwo hobi God tal ol na tongwo ha maing di tenana po dire nu ke na tomua. Tere na nu si olere yu ditenana po. Han hongwo hobi gule ole ni tenamua. Te omin gi dinga hobi apla di ni tenamua. Te ari hobi er wengwo ya kwir hole dungwo meri iwe, yu mole wa mongwo hobi oine hole a poira sinangure isine dinanua. ");
INSERT INTO sll_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te omaga haung i God ari hobi miling pir tere awai ol tenamua.” ");
INSERT INTO sll_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dire buku akung si erere ha maing oo honagi ongwo yal ta tongwi. Terere ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ami di mongure ari hobi teni han tongwi. Tongure Yisas hon aine yu ditongwi, “Awa ha di engwo keriga pinga i omaga nima omua.” ");
INSERT INTO sll_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ena Yisas grang bani ha wai moni di tibi olimia, ari hobi pire bukunere, yali haang a yuwo olungwi. Olere ari hobi yu dungwi. “Aye, Yosep wang mongwiwe.” ");
INSERT INTO sll_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dungure Yisas yu ditongwi, “Dokta monanga ni nin gaun bani honagi olkinano? Homa Kapaneam tal ongirai nin ganbani timiya yu olkinan mo? Di na tenania. ");
INSERT INTO sll_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","God hana togu yalhobi iwe, haang ganba ganba i pai i omba, nin ganbani, haang ta paikimua. ");
INSERT INTO sll_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ena Ilaiya mongwo gin iwe, me erin sui tai dire haba siks mun nimin sikimua. Yu ongure homena haning gongure ari hobi menan bir weni gomua. Gongwo gin iwe, Isrel ganba bani al werai miki weni momia. ");
INSERT INTO sll_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Momba, God aki di tenama dire bai nu si Isrel al werai mongwo bani pisolere, nu si Saidon probins Sarepat al werai mongwo bani olemua. ");
INSERT INTO sll_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te hana togu yal Ilaisa mongwo gin iwe, nin gamahobi Isrel ari hakubi dongwo miki weni momia. Momba, ta u wai homua. Yol Siria yal ta Neaman tani u wai omua.” ");
INSERT INTO sll_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dungure ha maing oo ala mongwo hobi yong ki engwi. ");
INSERT INTO sll_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Erere Yisas aule ire mena ongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pirere mo mibi pire pia si hogal ai olala di ongwi. Omba Yisas ari mongwo sina i wiyala pire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ena Yisas ere Galili probins pi pa dire Kapaneam malgi ongwi. Pi molere Sabat habang ha maing oo ala pire ari ha maing nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Si tongure arihobi ganulun dire, “Ayo, yali ha maing hong weni mongwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dungwo haung iwe, yal ta kwia nigi dongwo yong sina mongure, u ha maing oo ala molere gala dire, ");
INSERT INTO sll_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yisas, ni Nasarete yal irawe, na nan hana pamia, ni hani pamo? Ni na isusu olala dire uno? Ni God bai nu si olungwo yal monia, na ni han pa diwa,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ditongure Yisas kura ha ditere, “Ni ha dikire, ari yong sina i aidolere, ere mena po,” dungwi. Dungure kwia yal i ol tongure maganba bani habilai sire ere mena ongwi. Ongure yal i gaung bani ta bol gebe dikungwi. ");
INSERT INTO sll_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dikungure ari hobi hanere bukunere nin ha diriyala olere yu dungwi, “Ayo, yal i tal ome? I ha maing maing ta yulang kina kwia ha ditongure, pirere, grang wine omua.” ");
INSERT INTO sll_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ena Yisas tal ongwo guung haang iwe, gintani wa dire, ganba bina holo holi para kunu bengwi. ");
INSERT INTO sll_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ena Yisas ha maing oo aidole ere mena pire pi yal Saimon oo kepangwo ala ongwi. Pi mongure yal Saimon woumbi gaung nega dire nibil bir ongure, Yisas ure awai ol tenama dire ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ditongure Yisas pi al i pangwo bani aire mole nibil u banta po dire kura ha ditongwi. Ditongure nibil i wai sungure al i yamoni molere ari ungwo hobi homena si gale tongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ena hamen hama sungure nibil ongwo yalhobi gamahobi aule ire Yisas mongwo bani u pa dungwi. U pa dungure Yisas aling yal tan tani gaung bani angure u wai ongwi. Ena kwia nigi dongwo yong sina mongwo hobi si doling i mena ole tongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tongure kwia Yisas gumang hanere gala bir dire yu dungwi, “Ni God wang mongiwe.” Dimba yalhobi Yisas singaba Kraist momia dire mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te honmil hamen tangure malgi aidolere ere pi sinere gobo ta pire mongwi. Mongure ari hobi, “Yisas molkimua” dire wa du i pi pa dungwi. Pi pa dire mongwo hanere, “banta hore timi molo.” ");
INSERT INTO sll_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dimba Yisas yu ditongwi, “Na ari ganba bina holo holo ke pai ongwo i, para wa pa di mena olalia. Olere God kene ongwo hol u tibi umua diteralga pamia. God na bai nu si olungure honagi i tani pire wirawa.” ");
INSERT INTO sll_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dire Yudia ganba holo holi, para wa pa dire, ha maing oo ala pire God kene ongwo maing ha nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ena habang ta Yisas Genesaret nir digan bina aire mongure, ari tabin miki weni u yobilungure, Yisas God ha maing nir si tomia pir mongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pir mongure Yisas hamba, sipi sutani nir bani dimia hangwi. Pisi sungwo yalhobi sipi i ure nir bina i si gol ere pisi gal bigi sirala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ongure Yisas iri si sipi ta bani pire mongwo sipi iwe, yal Saimon sipi a nongwo dungwi. Dimia Yisas pi bolimbani molere hong yal yu ditongwi, “Saimon, sipi obilga anu si nir sina i olo.” Dire Yisas sipi ala ami di molere, arihobi ha nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Si te pisole Saimon yu ditongwi, “Sipi obilga anu si nir mini sina olo. Olere ni yalhobi gal pia si nir ala ole pisi so.” ");
INSERT INTO sll_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dimba Saimon yu ditongwi, “Yal Yisas ye, ni para dinba, na yalhobi ginangwo pisi sinamna dire nega dire oli uminga uminga, ta sikiminga dimia, ni dinga pamia gal hon pia si ime olaminua.” ");
INSERT INTO sll_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dire gal pia si ime olungure, pisi bir bir ya ure gal ali si di dire dimia gal si oulu dinangwo pangwi. ");
INSERT INTO sll_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pangure enin tau sipi ta ala mongure, gala dire, “Pisi siminga gal si oulu dinangwo pamia, aki di na tenana wo,” dungwi. Dungure sipi ta mala ungure, pisi i sipi su ali ereho engure, pisi oun dere sipi i manala olangwo pangwi. ");
INSERT INTO sll_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pangure Saimon Pita hanere, ikwi bole Yisas yu ditongwi, “Yal Yisas ye, na yal digan nigi dongwo molia, na aidole ere banta po.” ");
INSERT INTO sll_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ditere pisi sungwo i hanere, kul di hangwi. ");
INSERT INTO sll_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hangure gamahobo tau Sebedi wang suri Yems Yon para yu kul di hangwi. Hangure Yisas Saimon yu ditongwi, “Kul ta pirikio. Omaga pisi singa meri iwe, emgi ari tau inanua.” ");
INSERT INTO sll_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dungure yalhobi mena pire, talhan hobi para weni aidole, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ena habang ta Yisas ere pi malgi ta mongwi. Mongure yal ta gaung bani para muru hakubi dere mongwi. Molere Yisas u pa dungwo hanere, ya habilai sire sirin bol tongwi, “Yal Yisas ye, ni nebona i awai ol na terala di pinanga, ol na to.” ");
INSERT INTO sll_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dungure Yisas aling sine dire, gaung bani are, yu ditongwi, “U wai nana di piria, gaun wigi sinangure ya molo.” Ditongure gintani gaung wigi sungure ya mongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mongure kraung are yu ditongwi, “Ni tal ol ni tega i, ari ta hawai ol tekio. Tekire, gaun i ha maing oo singaba nibil di tengere, hanamia. Hanangure yal Moses hamen haya krehaman ha dungwo i wine olere, homena si gal tengere, gaun wigi sungwo i ari para han po sinamua.” ");
INSERT INTO sll_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dimba Yisas tal ongwo i ha suwa dungure ari para weni pungwi. Pirere nibil pangwo hobi Yisas ha nir si tenangwo pirere, nibil nebona awai ol na tenama dire u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dungwiwe, Yisas pi ganba sine ering gobo ta molere, God aki di na tenangwo honagi i olala dire God ha ditomiraya. ");
INSERT INTO sll_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ena habang ta Yisas ari hobi ha maing nir si te mongure Galili probins Yudia probins Yerusalem oo malgi Perisi tau ire, Lo tisa tau ire dire, ami di mongwi. Mongure God yulang tomia, Yisas ari nibil pangwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te mongure yal ta kebering aling meginungwo er ba hau ire Yisas mongwo nala dire umba, ari miki weni u yobile si di di momia, aule ire ala nangwo hol ta dikungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hol ta dikungure iri si airing bani pire, oo airing tule er kwiba bolo pia si Yisas mongwo gumang bani olungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Olungure Yisas hamba, er ba hau ire ungwo hobi awai ol tenangwo u wai nama di pir tongwo maing hanere yu ditongwi, “Yahuno. Ni tal nigi dongwo ol wanga God prin ni tongwo iwe, haya kri di ole ni tomua.” ");
INSERT INTO sll_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yu dungure lo tisa ire, Perisi yalhobi ire dire, nin ha di wama tere yu dungwi, “Ayo, yal i God gaung ha simia, tal ongwo dime? Ara pring kri di ole tongure dime? Tal nigi dongwo ongwo pring iwe, God nin kri di olangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dungure Yisas yalhobi ha nomani si pungwo i yong sina i haya han pa dire yu ditongwi, “Talongure ni yalhobi nomani gogo sire ha yu di mone? ");
INSERT INTO sll_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni nomani si pinga tal ha diralga oun dename? Tal nigi dongwo onga God pring kri di ole ni tomua, diteralga kulang panam mo? Te aire ere po diteralga kulang paname? Aire ere po diteralga kulang panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Te Ari Wang Weni na molia. Molere God yulang na tongure, ganba bani tal nigi dongwo pring kri di olalga han pa dinanua.” Yu direre, nibil ongwo yal i yu ditongwi, “Aire, er kwiba ire, ere malgi po.” ");
INSERT INTO sll_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ditongure nibil ongwo yal i ari mongwo maulung bani aire er kwiba ire, God maa e tere, ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Omia ari hobi hanere, grang dalungwi. Dalere God maa e tere, haang a yuwo olungwi. Olere yu dungwi, “Kenba yal i tal guma hon dongwo maing ta bole ongwo hane bukuneminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ena Yisas ere pirere, takisi ingwo yal ta, haang Libai, takisi ingwo oo ala ami di mongwo hangwi. Hanere yu ditongwi, “Libai, ni ure na dolna bolo.” ");
INSERT INTO sll_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dungure Libai honagi ol mongwo i, aidolere, ure Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ena Libai Yisas doling bol ongwo i pirere, homena bir si gale Yisas tongwi. Tongure Libai oo ke pangwo ala mole nongwi. Ne mongwo gin iwe, moni takisi ingwo yal tau ire, ari tau ire dire, para ami di molere homena tani ne mongwi. ");
INSERT INTO sll_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mongure Perisi tau ire, Lo tisa tau ire dire, hanere, Yisas grang wine ongwo hobi yu di tongwi, “Takisi ingwo yal ire, ari ha maing pirkungwo hobi tau ire dire, Yisas kina ereho mole, nir homena tani ne momia, talongwo nome?” ");
INSERT INTO sll_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dimba Yisas yu ditongwi, “Nibil paikungwo yalhobi dokta mongwo bani om mo? I ta homia. Te nibil pangwo yalhobi iwe, obil dokta mongwo bani omua. ");
INSERT INTO sll_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na iwe, ari tibi mongwo hobi, i ku bolalga taman. Ari hana ya mongwo hobi i ku bolalga tal nigi dongwo ol wangwo i aidole nomani si kulu sire hon olkinama dire ya ime wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ena habang ta ari tau ure Yisas yu sirin bol tongwi, “Yon grang wine ongwo hobi iwe, homena mai tere mole, haung miki weni God ha di te momia. Te Perisi yalhobi ere para yu ol momua. Mongure ni gran wine ongwo hobi nir homena nere nere momia, talongwo haung ta homena mai tere God ha di tekime?” ");
INSERT INTO sll_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dimba Yisas yu ditongwi, “Al inangwo yal i gamahobo kina ereho monangure, gumang yaure homena mai tere monam mo? I ta molkinama. ");
INSERT INTO sll_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Te habang ta al inangwo yal i kiang hobi aule ire ere banta nangure, gamahobo miling gul sinangure, homena mai tere monangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ena Yisas ha bangi biire hon yu ditongwi, “Te ari gal goling bali sinangwo bani gal hon bol ere sibirangwo mama dinamo? I ta dikinamia. Sibirangwo iwe, bigi sinangwo kuung sire u mala dinangure, hon ere bali sire u mena nangure kunu paikinamua. ");
INSERT INTO sll_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te ari nir wain hon holere, meme gang mugu goling ali garu dikinamia. Garu dinangure, miing ure, meme gang mugu i si gala dire, nir wain i u ganba bani namua. ");
INSERT INTO sll_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ari han pa dire meme gang hon ire, nir wain hon tulangure, meme gang nir wain kina mama dinamua. ");
INSERT INTO sll_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ena ari nir wain goling i nenangwo nere wain hon i wai hanamo? I ta wai hankinama. Goling i nega don kema dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ena Sabat habang ta Yisas grang wine ongwo hobi kina paba ya nongwo sina wangwi. Ware gamahobi paba tau pere paule nongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nongure Perisi yal tau mole hane yu ditongwi, “Sabat habang na mana dimiraya, paba talongwo pe nene?” ");
INSERT INTO sll_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dimba Yisas yu ditongwi, “Ni yalhobi homa kwiana moya Debit gamahobo kina menan golere, talongwo irai ha maing buku kere pirikere dino? ");
INSERT INTO sll_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yal Debit God ha maing oo bir ala werang ta i pirere, homena breti God maulung bani dungwo i nongwo irawe, homena i, yal i gamahobo nenama dire ta ekimia. Te ha maing oo kene ongwo yalhobi obil nenama dire di tibi ol tomirawa. Tomiraba Debit ire gamahobo tere nomia. ");
INSERT INTO sll_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nongwo iwe, wai pamia. Te na Ari Wang Weni molere, Sabat habang para hobang molga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ena Sare habang ta Yisas ha maing oo ala pire, ha nir si te mongwi. Mongure ala i yal ta aling weni hol i kebir engure mongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Momia Perisi te Lo tisa tau kwi han mongwi. Molere aling kebir engwo Yisas awai ol tenangwo irai, ha di mere si tenamna dire han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Momba, yalhobi nomani si pungwo i, Yisas haya hanere, aling kebir engwo yal i yu ditongwi, “Ni aire u gumana baniya wo.” ");
INSERT INTO sll_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dungure yal i aire u sina ungwi. Ure mongure, Yisas Perisi arihobi yu ditongwi, “Na ha ta sirin bol ni teralia piro. Ari nibil onangwo Sabat habang Lo awai ol to dim mo, tal nigi dongwo ol to dime? Te yal ta golala di ole pai monangure gonama dire han olamin mo, awai ol tenamne? Lo dinangwo meri di tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Direre ari mongwo bani tene han wabo dire aling kebir engwo yal i yu ditongwi, “Ani sine do.” ");
INSERT INTO sll_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dungure aling sine dire, u wai ongwi. U wai ongure yal hobi hanere, yong ki bir ere yalhobi nin ha diriyala olere yu dungwi, “Nan Yisas tal ol tenamne?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ena Yisas God ha diterala dire hamen hul ta ongwi. Pi molere God kina ha wai ol te mongwo mongwo hamen tangwi. ");
INSERT INTO sll_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tangure grang wine ongwo ari ana holo holo kebena sutani gala di ku bole, ha maing di tenama dire, i tibi ole hang dangwi. ");
INSERT INTO sll_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Dal tere, “Aposel monua”, ditongwi. Ditongwo yalhobi ta Saimon, hang hon Pita, ta yal Saimon ebering Endru, ta Yems, ta Yon, ta Pilip, ta Batolomyu, ta Matyu, ta Tomas, ta yal Alpias wang Yems, ta miling olba sungwo yal Saimon momia, te ta yal Yems wang Yudas, te ta Yisas bai tal sungwo yal Yudas momia. Yal iwe, Keriot ganba hong yal momua. ");
INSERT INTO sll_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ena Yisas yalhobi haang e te pisolere, ere ya ime ure, ya baning ure mongure, grang wine ongwo hobi miki weni u yobile mongwi. Mongure ari tabin bir weni Yudia probins ire, Yerusalem ire, nir bina mala Taia Saidon ire dire, u ku bol mongwi. Molere Yisas ha dungwo pirala dire, nu nibil nebona dongwo hobi awai ol na tenama dire ure mongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Te kwia nigi dongwo yong sina mongwo hobi para ungure Yisas si doling i ole tongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yisas yulang kina nimni mole awai ol tomiraya, ari hobi pirere, mala ure gaung arala dire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ena Yisas grang wine ongwo hobi han wabo dire yu ditongwi, “Yal ta yal bina molia dire ya ime sire monangwo yal iwe, miling panamua. ");
INSERT INTO sll_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Panangure, God kene ol tenangure moli namua. Te yal ta menan gole nir gonangwo yal iwe, miling panamua. Panangure, God hon aine tenangure, inangwo kunu benamua. Te yal ta miling gul sinangure, hai me monangwo yal i, miling panangure wa gonamua. ");
INSERT INTO sll_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Te na Ari Wang Weni molia grana wine onga hobi ari hobi ni hanere, yong ki e ni tere, ere po di ni tere, gaun ha si ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tere tal yu ol ni tenangwiwe, miling pananua. Ni yalhobi gun ere milni panangure molo. Monangiwe, tobo bir hamen bani dimia inanua. Ol ni tongwo tal iwe, kwian moya God hana togu yalhobi ereyu ol tomua. ");
INSERT INTO sll_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Eke, bona gana miki weni a nenga hobi iwe, omaga para a neniba, emgi ta a nekinanua. ");
INSERT INTO sll_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eke, homena nere miin ongwo monga hobi iwe, para neniba, emgi menan gonanua. ");
INSERT INTO sll_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Eke, wa gol tenga hobi, omaga para wa gol teniba, emgi ni nin milni pirere hai menanua. Ni ari singaba mongere hani a yuwo olangwiwe, olamba kwian moya God hana togu yalhobi haang dalkima, hasu hana togu yal mole wangure ari haang a yuwo olungwo meri iwe, ni han para yu a yuwo olamua. Olangwo i wai pirkio. ");
INSERT INTO sll_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ena na ha ta di ni terala piro. Kiani yalhobi ha wai di tere yon milni to. Te yong ki e ni tere gumang yau ni tenangwo yalhobi aki di to. ");
INSERT INTO sll_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te gaun ha si ni tere ha yong i ni tenangwo yalhobi ha wai di to. Te tal gogo ol ni tenangwo God aura di tenama dire sirin bol to, ditenanua. ");
INSERT INTO sll_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te yal ta paun bani di dagi ni sinangwo iwe, pauni hol bani ma di to. ");
INSERT INTO sll_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te yal ta ni galsina kuni inangwiwe, galsina ta dinangwo para to. Te yal ta talhan ta na to dire hong dinangwo tal iwe, mining bole to. Yal ta ni talni ta irala dire agi dinangwiwe, ni emgi pring inanga ha dikio. ");
INSERT INTO sll_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ari hobi awai honagi tau ol na tenama di pinanga meri iwe, ni para arihobi yu ol to. ");
INSERT INTO sll_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Te yong miling ni tere wai pir ni tenangwo yali obil yon milni tenangiwe, wai panamo? I ta paikinama. Hana ya mongwo yalhobi ere para yu ol wamua. ");
INSERT INTO sll_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te yal ta tal wai ol ni tenangwo yali obil aki di tenangiwe, wai panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ari hana ya mole ha maing pirkungwo hobi ere para yu ol wamua. Te ni yalhobi yal ta hanere, “O, tal ta tegere mong pring na tenamua,” di pire tenania. Tenangiwe, wai panam mo? I ta paikinama. Ari hana ya mongwo hobi tal ta tere pring iralua dire para yu ol wamua. ");
INSERT INTO sll_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wamiba, ni yalhobi iwe, kiani yalhobi yon milni tere ha wai panangwo dito. Ditere tal ta tenangiwe, pring na tenama dire agi dikio. Ena ni tal wai onanga i pire emgi tobo bir weni irere, talhan para weni hobang yal God wang aung monanua. Yu onanga meri iwe, God yal wai obil aki di tere yal digan i aki di tekimo? I para awai ol tomia. ");
INSERT INTO sll_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hamen Nabe ari para muru miling pir tongwo meri iwe, ni ere para yu arihobi miling pir to. ");
INSERT INTO sll_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ena ni yalhobi ari tau hanere, nigi de pir tere isime e tekio. Isime e tenanga meri iwe, God hon siina dire yu ol ni tenangwo pamia. Ni tal nigi dongwo onua dire, ha di mere si tekio. Ha di mere si tenanga meri iwe, God para siina dire, yu ol ni tenamua. Yal ta tal gogo ol ni tenangwo ni han uning si ole monanga meri iwe, ni ere para tal gogo onanba, God para ni han uning si olangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Talhan ta ari hobi tenanga God para ni tenamua. Obilga na tenama di pino? Miki weni ni tenangure gal taniga girano? Gal su giranga pamua. Te arihobi tal ol tenanga meri iwe, God ere siina dire yu ol ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Direre Yisas ha di bole yu ditongwi, “Yal su omiling gi dinangure, goliba arere, hogal dungwo bani pisole, ya malgi nam mo? I ta honamia. Yasu ereho hogal dungwo bani pire hogal sinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te gir sikul dungwo hobi di wa molere, mo yuwo pire, irang tisa hobi iime olam mo? I ta olekinamia. Sikul gir hobi irang tisa kina kunu kunu monangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ena ni talongure ni nin omin molo ere dulung bir ta dungwo i kul sire enin ta omin molo dimua ditene? Er dulung bir omin bani si pera di dungwo i, omin gi dinia, i ole teralga kunu paikinamua di pirikino? ");
INSERT INTO sll_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ni yahunanin ta omeling molo dimua dingiwe, ni grabin dirani sinia. Ni nin omin palan dulung bir ta si pera di dungwiwe, homa i olekino? I olere emgi ebin omeling molo ongwo i, i ole tenanga pamua. ");
INSERT INTO sll_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ena er wai dungwo bani iwe, miling nigi dongwo hom mo? I ta holkimia. Er nigi dongwo bani iwe, miling wai dungwo hom mo? I ta ereyu holkimua. ");
INSERT INTO sll_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Er hobi para hanere, miling wai homio, digan homio dire han po sinia. Er digan dungwo bani iwe, amil sinam mo? I ta sikinama. Te kewa bongwo bani iwe, paba sinam mo? I ere ta sikungwo hanua. ");
INSERT INTO sll_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ni yal wai mongwo hangiwe, tal wai onangwo moni nomani si pimia. Te yal digan mongwo hangiwe, tal digan moni olala di pimua. Ena ari para muru nomani si pungwo meri di tibi olimua. ");
INSERT INTO sll_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ena na grana wine olkingiwe, talongwo yamoni yal waiye di na tene? ");
INSERT INTO sll_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ena yal tau na guna hana pirere, wine onangwo yal iwe, oo hamen hul mini bani ke pare mongwo meri monamia. ");
INSERT INTO sll_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","49","Te yal ta na ol wai ol tega ha maing pirere wine olkinangwo yal iwe, yal ta oo maker bani ke pare mongwo meri yu monamua. Yal sui yu ke pare monangure, nimin sire, nir mo yuwo nangure, hamen hul ke pangwo i, i manbi olala dire sinamba, kunu paikinamua. Te maker bani ke pangwo i, i manbi olala dire onangure yanamua. Yarere oo i ususu namua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ena Yisas yalhobi ha di te pisolungwi. Pisolere ere Kapaneam malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pi mongure yol Roman soldia kene ongwo yal ta mongwi. Yal iwe, honagi yal ta mongwo yong miling tere i wangwi. Yu wangwo yal iwe, nibil bir olere, kara gonangwo meri pangwi. ");
INSERT INTO sll_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pangure Kepten i mole pungure Yisas honagi ta yu omua dungwo pungwi. Pirere Yuda ha maing oo singaba ta bai nu si olere yu ditongwi, “Nibil ongwo i, Yisas ure awai ol tenamia, sirin bol pinana po.” ");
INSERT INTO sll_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dungure ha maing oo singaba Yisas mongwo bani pi pa dire, yulang bole dire sirin bol pire yu dungwi, “Yali yal wai momia, aki di tenan mo? ");
INSERT INTO sll_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yong miling nan Yuda yalhobi na tomia, na tere ha maing oo nin ke na tomua.” ");
INSERT INTO sll_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dungure Yisas wine olere ereho ongwi. Pirere pi oo malgi pa dirala di ongure, Kepten gamahobo tau nu si olere yu ditongwi, “Yisas unangwo bani pire yu ditenania, Yal Yisas ye, soldia kene ongwo yal iwe, yu dimia, na yal wai molgere ni oo kepaga malgi hunania, digan molia, ni monga bani uralga paikimua. ");
INSERT INTO sll_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni baniya molere, ha obil dingere, nibil pangwo yal i u wai namua. ");
INSERT INTO sll_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na sina weni molia, yal bir hobi na na kene omba, te na mol kebena ala olungwo hobi kene oliwa. Olere yal ta po, diralga namua. Te yal ta wo, diralga unamua. Te boi honagi yal ta yu olo, diralga onamua.” ");
INSERT INTO sll_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dungure Yisas pire ganulun dire, mobing hol ungwo hobi yu ditongwi, “Yol Roman yal iwe, God ogolo nomani si pir te momba, te nan Isrel ari hobi iwe, ta ereyu God nomani si pir tere monangwo hankiwa.” ");
INSERT INTO sll_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dungure Kepten gamahobo pire, siina dire ere malgi ongwi. Pi pa dire hangure nibil ongwo yal i u wai omia hangwi. ");
INSERT INTO sll_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ena habang ta Yisas ere pi oo malgi ta haang Nen wa dungwo bani ongwi. Ongure grang wine ongwo hobi ire, ari tabin bir weni ire dire, kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pi u egere pa dungure, yal ta gongwo er ba hau ire ungwi. Gongwo yal iwe, irang hamen haya gongure aang gir mua i wangure gongwi. Gongure Nen oo malgi ari hobi miki weni er ba hau ire ungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ungure pi tege eminga yal Yisas aang i hanere, miling go pungwi. Pirere aang i yu ditongwi, “Hai mekio.” ");
INSERT INTO sll_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ditere mala pire, er kwiba gumuling angure, er ba haungwo yalhobi ira mongwi. Mongure Yisas yu ditongwi, “Gir wai ye, ni airo.” ");
INSERT INTO sll_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dungure gongwo yal i airere, ami di mole, ha di mongwi. Mongure Yisas a ire pire aang hol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tongure ari hobi hanere, miling si giri golere, God wai pir tongwi. Tere yu dungwi, “Nan mominga baniya, God aki di na terala dire, hana togu yal bir i bai nu si olungure, omaga u pa dimua.” ");
INSERT INTO sll_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dire Yisas tal ongwo guung haang i Yudia ganba, te ganba bina holo holi para wa dire kunu bengwi. ");
INSERT INTO sll_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ena Yisas tal ongwo i Yon nir bil tongwo yal iwe, gamahobo pirere Yon di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ol tongure Yon gamahobi yal sutani wo dire yu ditongwi, “Ni yasuri pirere, yal Yisas ha ta dinangwo pire, ure di na tengere piralia. Pire yu sirin bol piro, Yon yal ta unamua dungwo irai, ni tani un mo, yal ta emgi uname?” ");
INSERT INTO sll_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dungure yasuri u Yisas mongwo bani ure yu ditongwi, “Yon na yasu na bai nu si olungure ubilia, Yon yu dimia, Ni unama diga yal irai un mo, yal ta uname?” ");
INSERT INTO sll_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dungwo gin iwe, Yisas nu nibil pangwo hobi, te kwia nigi dongwo yong sina mongwo hobi, te omeling gi dungwo hobi, awai ol te mongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Molere Yon nu si olungwo yasuri yu ditongwi, “Omeling gi dungwo hobi pila dimio, kebering kebir engwo hobi hol wamio, hakubi dongwo hobi gaung wigi simio, kraung gi dungwo hobi pila dimio, gongwo hobi hon aire ya momio, yal bina hobi God tal ol na tongwo ha maing ditega pungwo hangiwe, Yon ditenana po. ");
INSERT INTO sll_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yal ta na na hanere, na talhan i para weni onangwo kunu bemia di pire nomani su su sikinangwo yal iwe, yong horoga onamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ena Yon gamahobi ha yu ditomia pirere, ere memini ongwi. Ongure Yisas Yon mole honagi ongwo maing arihobi yu ditongwi, “Ni ganba po engwo bani Yon momua dungwo pirere, harala di ongiwe, ari monangwo harala di on mo, tal u tibi nangwo harala di one? ");
INSERT INTO sll_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kul airing hair sire ho tongwo harala dire on mo, yal ta galsina wai weni si giu dinangwo harala dire one? Galsina wai weni si giu dinangwo yal iwe, oo bir kepangwo ala i mole pare omia. ");
INSERT INTO sll_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","God hana togu yal harala dire ono? O, para dinia, hana togu yal tau mongwo meri ta molkima. Yon iwe, God hana togu yal bir weni momia. ");
INSERT INTO sll_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mongwiwe, ha maing buku homa di emiraya, omaga u tibi omua. God yu dimiraya, na hana togu yal momia hano. Yal iwe, nu si olalga homa e ni tere, hol bala di ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ari tau haang moyu omba, te Yon iwe, haang kara mo hora kumua. Kumba, te God kene ongwo sina i ari monangwo hobi iwe, Yon a ime ol tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ena ari hana ya mongwo hobi ire, takisi ingwo hobi ire dire, Yon ha dungwo pungwi. Pirere “Owa, God ha wo kara mongwo pamia nir binaminua,” dire, ongure Yon nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tomba, Perisi hobi ire, Lo ha nir si tongwo hobi ire dire, Yon nir bil na tenangwo paikimua, dire, God ha maing hol wai nibil di tongwo i, pir tekire aidole ya mongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ena Yisas yu dungwi, “Ari tabin malaya mongwo hobi iwe, di bolalga tal di bolale? ");
INSERT INTO sll_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Maket homena bring si nongwo bani gir migi gobere engwo ami di mongwo meri yu momua. Molere gir tau hol bani mongwo hobi iwe, gala dire, gir hol bane mongwo i yu ditongwi, “Na kir tere ul diminba, ni gir hobi egin ikinua. Na ari gongwo hobi hai me tominba, ni gir hobi ere hai me tekinua.” ");
INSERT INTO sll_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ena Yon nir bil tongwo yal i urere, homena tau mai tere nir wain nekungwiwe, ari para hanere, Girhobo, Yon ungworai du dima dimua. ");
INSERT INTO sll_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dimba Na Ari Wang Weni molia ure, homena ya, nir wain negiwe, ari hobi na hanere, Aye, yal i tal ta omia hano. Homena miki weni nere, wain nir nere dimia hano. Takisi ingwo yal ire, hana ya mole ha maing pirkungwo hobi ire dire, pana gal tomia hano. ");
INSERT INTO sll_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dimba, God ha weni kara dim mo, dikime? Dinangwo ari pire u wai honamo? U wai ongwo hangiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ena habang ta Perisi yal ta Yisas “Homena nenana wo,” ditongwi. Ditongure Yisas pirere Perisi oo kepangwo ala i homena nerala dire ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mongwo oo malgi i yal nu sungwo al ta, “Yisas ure Perisi yal i oo kepangwo ala homena ne momua,” dungwo pungwi. Pirere al i wel santa mugu ta ire u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pa dire Yisas debing bani molere, hai me mongwi. Mongure omiling niri ya Yisas kebering bani sungwi. Sungure breng eme ire kri dungwi. Kri dire, kebering bani guma mu dire, wel ingwo i garu dire, kebering bani bil tongwi. ");
INSERT INTO sll_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tongure Perisi yal i, hanere, yu nomani si pungwi, “O, yali God hana togu yal kara molkimua. Monangwo al i, tal nigi dongwo ol wamia hanamba, hankimua,” dipungwi. ");
INSERT INTO sll_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dipungure Yisas Perisi yal i nomani si pungwo i haya han pa dire yu ditongwi, “Saimon, ha gwo oo malgi i yal nu sungwo al ta di ni terala dire han moliwa.” Dungure Saimon Yisas yu ditongwi, “Tisa para dinia, di na tomo.” ");
INSERT INTO sll_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dungure Yisas yu dungwi, “Yal ta moni a nenangwo, yasutani dina ol tenamia. Yal ta handred kina tere yal ta ten kina tenamia. Tenangure yasuri moni dina i olo te aibing olekinamua. ");
INSERT INTO sll_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yu onangure moni hong yal i tenangwo yal suri “Moni dina i hon na tekio” dire te uning sinamia. Sinangure yasuri ara pinangwo mo yuwo name?” ");
INSERT INTO sll_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dungure Saimon yu ditongwi, “Moni bir inangwo yal i wai pir tenamua.” Dungure Yisas yu ditongwi, “Ni ha pangwo kara dinua.” ");
INSERT INTO sll_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dire si kulu sire ama i guma bani hanere, Saimon yu ditongwi, “Al i hanega. Na ni oo kepanga ala uga, tal nigi dongwo memini bole onia. Ni nir ta na tenanga na kebena bigi sinaminba, na tekinua. Tekinba al iwe, omeling niri kebena bigi si na tere breng eme kri di wai ole na tomua. ");
INSERT INTO sll_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni na kule kewa dikinia, al iwe, kebena bani kule kewa di di ole momia hano. ");
INSERT INTO sll_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na bina bani wel ta bilalga i na tekinia, al iwe, wel santa ire kebena gauna bani para muru bil na tomia. ");
INSERT INTO sll_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tal yu ol na tongwo meri di ni teiwa. Al i tal nigi dongwo miki weni ol ware God pring tongwo i God nin kri di ole tomia. Tongure al i yong miling na na tere tal yu ol na tomua. God yal ta pring obilga kri di ole tenangure, tenangwo yal i, tamamua di pire, yal tau yong miling tenamua.” ");
INSERT INTO sll_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dire Yisas al i yu ditongwi, “Tal nigi dongwo ol wanga, God pring ni tongwiwe, haya kri di ole ni tomua.” ");
INSERT INTO sll_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dungure ari bol tani ami di mole homena ne mongwo hobi iwe, nin ha diriyala ole yu dungwi, “Pring pai ni tongwo i, haya kri di ole ni tomua, dungwiwe, paikimia, God nin hanere yu onangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dimba Yisas al i yu ditongwi, “Ni God prina i olangwo pamia di pir tengiwe, prin kri di ole ni tomia, ere malgi pire mining bole yon ura dinangure, monana po,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ena habang ta Yisas ha maing oo bling bir migi para wa pisolungwi. Pisolere God kene ongwo bani ha maing hol yu pamua, dire nir si te i ongwi. Ongure grang wine ongwo ari ana holo holo kebena sutani hobi kina ereho wa i ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wa i ongure agr tau homa kwia nigi dongwo yong sina mongwo i ole tere, te nibil ongwo awai ol tongwo al hobi iwe, kina para doling bol ongwi. Al hobi iwe, ta haang Maria homa kwia nigi dongwo sewen pela i ole tomia. Al i Magadala hong al momia. ");
INSERT INTO sll_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te al ta Herot aibing kene ongwo yal ta Susa eumbi Yoana momia. Te al ta Susana momia. Te al tau para ire dire doling bol ongwi. Pirere, Yisas gamahobi kina aki di tere bona gana kene ol tere tere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ena ari tabin bir weni tabil tabil Yisas mongwo bani u ku bongure, Yisas ha bangi biire yu ditongwi, “Yal ta homena miling sigirala dire u sina namua. ");
INSERT INTO sll_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Pirere miling sigirangure miling tau ya homaulung sinamua. Sinangure ari iriyala tere egerangure, te hahoba u pa dire ne wai sinamua. ");
INSERT INTO sll_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te miling tau ya hulu bolimbani sinamua. Sinangure ganba giri gonangure meginere gonamua. Te miling tau ya tul galing engwo ali sinamua. ");
INSERT INTO sll_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","8","Sinangure pi sire tul kina ereho bonamba, tul si nenamua. Te miling tau ya ganba wai dungwo bani sinamua. Sinangure pi sire bonamua. Bolere miling miki wan handret honamua. Yal ta nomani pamia ha i pir po sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ena Yisas ha bangi biire ditongwo iwe grang wine ongwo hobi memini pir po sikire hon sirin bongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bongure Yisas yu ditongwi, “God kene ongwo bani di bole digiwe, ni nin pir po sinia, ari ya mongwo hobi ta pir po sikimua. Yu onama dire ha bangi biire diteiwa. Detega i, ari hobi omeling hamba, hanere ogolo han pa dikimua. Te kraung pimba, pirere ogolo pir po sikimua. ");
INSERT INTO sll_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ena ha di ni tega irai memini yu pamia. Homena miling bani di bole diga i, God ha maing bani di bole diiwa. ");
INSERT INTO sll_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Miling tau ya homaulung sungwo meri, ari tau yu momua. Molere ha maing pimba, kwia Seten ure pir po sikire a i si wakinangure God aidolama dire ha maing i tol di inamia. ");
INSERT INTO sll_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Te miling tau ya hulu bolimbani sungwo meri ari tau yu monamua. Molere ha maing pirere, bukunere, monamua. Molere kraung pinamba, nomani sina ali bona si eikirere gintani pisolamua. Ena yalhobi iwe, ha maing gogo gogo i wa molere, emgi kura pare, te talime u tibi nangwo gin iwe, aidolangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te miling tau ya tul galeng engwo ala sungwo meri, ari tau yu monamua. Monangwo yalhobi ha maing pinamua. Pinamiba ganba tal moni gal bona ya talhan hobi pinangwo mo yuwo nangure, ha maing nomani sina pai tekinamua. Tekinangwo yalhobi iwe, God honagi ta ol tekinamua. ");
INSERT INTO sll_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Te miling tau ya ganba wai dungwo bani sungwo meri, ari tau yu monamua. Molere, ha maing pirere, nomani sina bona si ere a i si ware ogolo wine ole moli nangure miling panamua. ");
INSERT INTO sll_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ena yal ta kewa gale ire, oo ala pire, mulu ali kul si enangwo paikimua. Te bol bera ala enangwo paikimua. Kewa bol bani enangwo au dinangwo pamia. ");
INSERT INTO sll_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Te ha ta di kul si enangwo iwe, emgi u tibi namua. Te ha ta di bii enangwo irai, emgi u tibi nangure nan para omena hanaminga pamua. ");
INSERT INTO sll_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Te na ha di ni tega i ogolo pirere, hankun ole molio. Molere yal ta ha i, a i si ware monangere, God hon ni te hobo kunangwo pamua. Te yal ta ha i, a i si wakinangere, homa a monanga tal iwe, God nin tol di inamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ena ditongwo gin iwe, Yisas aang ebering hobo kina u maini molere, ala namba, ari miki weni hona grang si di di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mongure yal ta Yisas yu ditongwi, “Pino. Nimai ebinhobo irai u maini molere, ni gala dimia wiya po.” ");
INSERT INTO sll_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dimba Yisas arihobi yu ditongwi, “God grang ogolo pirere, wine onanga yalhobi iwe, namine ebina monanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ena habang ta Yisas grang wine ongwo hobi kina sipi ala pirere, “Nir bina hoibi namna wo” dungwi. Dungure ere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pirere Yisas sipi ala ul pai mongwi. Mongure hamen hair bir mu dinba olere, nir hone pera kule sipi ala pirere sipi i manala olangwo pangwi. ");
INSERT INTO sll_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pangure yalhobi Yisas uling yurere yu ditongwi, “Yal Yisas ye, Yisas ye, nan gonaminga pamia aki di na tekino?” Dungure Yisas aire nir ya, hamen hair hon olkio dire hobang si tomia wai sungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sungure Yisas yalhobi yu ditongwi, “Na momia golkiralua di pir na tekino?” Dungure yalhobi hanere, grang dalere, kul bir pirere, yalhobi nin di wama tere, yu dungwi, “Hamen hair ya, nir hobang si tongwo irai, grang wine omia, yal i ari mom mo, tal mome?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ena direre nir bare iri si hoibi pire, Galili ganba hoibi hol bani dungure, pi Gegesa ganba ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pi pa dire sipi pisole ere mena ongure, oo malgi hong yal ta u pa dungwi. Dungwo yal iwe, kwia nigi dongwo yong sina mongure gobari weni krau pirikire mongwi. Molere oo malgi paikirere, hulu grang ari yulagi engwo bani moni pare pare mongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mongure Yisas u pa dungwo hanere, gala bir dire, yare manbi kebering bani habilai sire yu dungwi, “Ni singaba God wang irawe. Na nan hana pamia, ni hani pamo? Na gauna gul na terala dire un mo?” ");
INSERT INTO sll_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ena homa Yisas kwia nigi dongwo ere mena po dire hobang si tomiraya, yal i Yisas yu ditongwi. Kwia nigi dongwo iwe, yal i yong sina mole yulang bongure kebering aling han waiya simba, kunu paikungure si oulu di olere, ere pi ganba po engwo gul pai mongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ena Yisas yali hanere yu sirin bol tongwi, “Ni han dalo.” Dungure kwia i yu dungwi, “Na hana Ari Miki Weni molia, taniga ta molkiwa.” Dungwo i, kwia nigi dongwo miki weni yong sina omia yal i Yisas ha yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dungure kwia Yisas sirin bol tere yu ditongwi, “Ni na bai nu si hogal olekio.” ");
INSERT INTO sll_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dire hamba, kun tabin bir weni hamen hul ta emin ne mongwo hanere, “Ni na nu si olingere kun yong sina i naminba?” Dungure Yisas “Para dinia, po,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ditongure kwia nigi dongwo i ari yong sina i aidolere, ere kun yong sina ongwi. Ongure kun hobi nulu di hogal pire nir digan sagu dire gol wai sungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ena kun kene ol mongwo hobi tal ongwo i hanere, te ere malgi ongwi. Pire oo malgi mena ke pangwo hobi hawai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tongure arihobi harala dire ongwi. Pi Yisas mongwo bani pa dire hamba, kwia nigi dongwo yong sina mongwo yal irai Yisas kebering bani ami di mole, krau pire momia hangwi. Hanere ganulun dire kul bir weni pungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ena Yisas yal du dungwo yal awai ol tongwo hangwiwe, ari ungwo hobi di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tongure Gegesa arihobi kul bir pirere, Yisas, ere nama di pire sirin bol pungwi. Pungure Yisas iri si sipi ala pire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ere omba, kwia yong sina mongwo i ole tongwo yal i sirin bol tere yu ditongwi, “Na kina ereho nabilba?” ");
INSERT INTO sll_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Dimba, Yisas nu si nin oo malgi olere, yu ditongwi, “Ni ere malgi pire God awai ol ni tongwo i ari hobi ditenana po.” Dungure yal i ere malgi pire, Yisas tal ol tongwo meri ha di tibi olungure, ari hobi para weni pungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ena ari tabin bir Yisas ere hoibi unama dire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mongwo u pa dungure ari hobi wai pungwi. Ena ha maing oo kene ongwo yal Yairas u pa dire Yisas kebering bani ikwi bole, yu ditongwi, “Na auna ama migi me erin ana holo holo kebena sutani momia. ");
INSERT INTO sll_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Molere golala dire omia ni na kina ereho malgi naminba?” Dungure Yisas Yairas kina ereho ongwi. Ongure ari miki weni u yobile mongwi. Mongure al ta kina doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ongwo airing iwe, algi bilere mongwi. Algi iwe, omaga ta bilkima. Me erin ana holo holo kebena sutani bil mongwo bani mongwi. Ena dokta miki weni ure honagi ol tongure, kunu paikungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ena al i Yisas mobing hol urere, Yisas galsina ongwo gumiling obilga angwi. Angure algi gintani wai sungure ya moni mongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mongure Yisas “Ara na ame?” dungwi. Dungure arihobi “Na hankiminua, na hankiminua,” di ongwi. Di ongure Pita yu dungwi, “Yal Yisas ye, ari taporal ure ni yobilimia, hankino?” ");
INSERT INTO sll_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dimba, Yisas, “A i momiba, na yulana obilga ura di dungwo pire diwa.” ");
INSERT INTO sll_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dungure al i gintani u kul sirala di pimba, ure gaung nurere, Yisas kebering bani i kwi bongwi. Bolere ari taporal mongwo maulung bani gal are nibil ongwo wai sungwo ha i Yisas maing di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tongure Yisas al i yu ditongwi, “Auna ye, na onangwo u wai nala di pir na tenga iwe, u wai onia, ni pirere, mining bole yon ura dinangure molo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ena Yisas ha i dite mongure, Yuda ha maing oo kene ongwo yal gamahobo ure yu ditongwi, “Ni aun haya gomia Tisa ha gobari talongwo di te mone?” ");
INSERT INTO sll_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dimba Yisas ha i pirere Yairas yu ditongwi, “Ni nigi de pirikio. Yon ura dinangure na onangwo pamia di pir na tere molo. Aun i u wai namua.” Dire Yisas ere pi malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pi pa dire Yisas ari hobi “Ala huyo”, dire hobang si tere, Pita ire, Yon ire, Yems ire, gir irang aang suri ire dire, obil ala i ongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ongure ari hobi gir i handire hai me mongwi. Momba Yisas yu ditongwi, “Ni yalhobi hai mekio. Gir i ta golkimia. Ya moni ul pai momua.” ");
INSERT INTO sll_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dungure ari hobi para wa gol tongwi. Gir i hamen haya gongwo ari hobi para hangwi. ");
INSERT INTO sll_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hamba Yisas pire ama i aling aki dire gala dungwi, “Amagir ye, airo.” ");
INSERT INTO sll_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dungure ama i kwiang u hongure gintani airungwi. Airungure Yisas, “Homena tau gir i to”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ena irang aang suri airungwo hanere, ganulun dungwi. Dimba Yisas ha ering mole dire yu ditongwi, “Na tal ol ni tega i ari ta di tibi ol tekio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ena Yisas grang wine ongwo ari ana holo holo kebena sutani yalhobi di ku bolere, kwia nigi dongwo si doling i olere, nebona nibil pangwo hobi awai ol tenama dire, nomani nimni mongwo tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Terere, nibil pangwo hobi awai ol terere, God kene ongwo hol i di tibi ol tenama dire nu si olungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Olere yu ditongwi, “Ni yalhobi bona gana ta ire wakio. Goliba a ire wakio. Hol bangi wananga moni hong dire gal gire ire wakio. Heba ya, moni ya, galsina sutani ire wakio. ");
INSERT INTO sll_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ena ni yalhobi wa i oo malgi ta ala pire mongere oo hong yal i ha wai di ni tenangwo pana gananga bani iwe, tani pai monania. ");
INSERT INTO sll_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pai molere ere nanua. Pirere oo malgi ta ongere, oo hong yal i ha wai di ni tekinangwo, pisole guman yau tere, ere banta nanua. ");
INSERT INTO sll_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nangere yalhobi nin maing hanere, nomani si pinamua.” Ena yu dungure, yalhobi pirere, oo hona hona i God ol wai ol tongwo ha maing nir si te i pirere, nibil pangwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ena, Yisas tal ol wangwo guung haang iwe, Galili probins kene ongwo yal Herot pungwi. Ena ari yal al tau, “Yon ari nir bil tongwo yal irawe, gongwo irai, God aki ditongure, si hon ere airima dimua” dimia, Herot pirere nomani gogo sungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yal tau, “Ilaiya u tibi umua,” dungwo, te yal tau “God hana togu yal hamen haya gongwo irai hon airima dimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dungure Herot yu dungwi, “Yon hamen haya nugu biriga gongworawa, omaga tal i ara ole mongure haang guru ungure pirie?” Direre Yisas unangwo han molalua dimba, hankungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ena Yisas gamahobo aposel ere urere, honagi ongwo meri Yisas ha di tibi ol tongwi. Tongure ena arihobi pisolere Yisas gamahobo kina nin ere Betsaida malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ongure emgi ari hobi hanere doling bol pi pa dungwi. Pa dungure Yisas hanere, “Widinio” dire, God kene ongwo maing di tibi ol tongwi. Tere nibil pangwo hobi awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ena pudungure grang wine ongwo hobi ana holo holo kebena sutani yalhobi Yisas mongwo bani ure sirin bol tongwi, “Omaga ganba po engwo bani molala di ungarai, hamen ginangwo pamia, ari hobi ditengere, oo hona hona tau pi pare, homena inamia, nu si olo.” ");
INSERT INTO sll_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dimba Yisas yu ditongwi, “A, monamia, ni yalhobi nin homena ta i unanga tekino?” Dungure yalhobi yu ditongwi, “Na yalhobi homena miki ta dikimia. Breti ana hol bani ire, te pisi sutani ire dire dimia. Ayo ari hobi miki weni momia, homena hon bring si teralga pire dino?” ");
INSERT INTO sll_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ena yalhobi miki weni paib tausen mongwi. Mongure Yisas grang wine ongwo hobi yu ditongwi, “Ari hobi ganba bani pipti pipti hala sire ami di molo dito.” ");
INSERT INTO sll_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Di tongwo meri yalhobi arihobi ditongure ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mongure Yisas breti ana hol bani muru ire, pisi migi su ire dire, are hamen bani yuwo hanere, “God homena na tenga wai piriwa,” dire bigi dire grang wine ongwo hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tongure yalhobi ire ebir sire arihobi tongwi. Tongure yalhobi ire nongure miing ongwi. Ongure tau ya dungwo tali gal basket ana holo holo kebena sutani girungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ena habang ta Yisas nin molere, God kina ha wai ol mongwi. Mongure grang wine ongwo hobi u pa dungwi. Pa dungure Yisas yu sirin bol tongwi, “Ari hobi na hana pirere, talwa dime?” ");
INSERT INTO sll_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dungure yalhobi yu ditongwi, “Yal tau Yon nir bil tongwo yal i mona dimua. Yal tau God hana togu yal Ilaiya mona dimua. Yal tau God hana togu yal hamen haya gongwo irai hon aire mona dimua.” ");
INSERT INTO sll_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dungure Yisas yu ditongwi, “Para dinia. Te ni yalhobi nin na hana talwa dine?” Dungure Pita yu ditongwi, “Ni God bai nu sungwo yal Kraist monua.” ");
INSERT INTO sll_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ena dungure Yisas yalhobi mana di tere arihobi, “Na Kraist momua, ditekio,” dire yalhobi hobang si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Si tere yu dungwi, “Ari Wang Weni na tani molga irai gauna gul iralga pamua. Te Yuda ari ha maing oo singaba ire, ha maing kene ongwo hobi ire, lo ha nir si tongwo hobi ire dire, na han uning si olere mobing hal wa na tenamia. Tere na si gonangure ari habang sutani pai molere emgi hon airalga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dire Yisas ari hobi hon yu ditongwi, “Yal ta na pir na tere dolna bolala di pinangiwe, nin gaun nomani si pirikire, talhan galing enangwo mobin hal wa tere, na gul pire golalga meri, ni ere gul pire habang habang na dolna bolo. ");
INSERT INTO sll_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yal ta nin nin gaung pir tere monangwo yal iwe, emgi u talwo nangwo pamua. Te yal ta na pir na tere, ha maing nir si tega i nomani si pir tere, u talwo nangwo yal iwe, emgi gobari mol panangwo bani panamua. ");
INSERT INTO sll_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ena yal ta nin honagi ole ganba ganba i talhan para weni inamia. Inamba, emgi talhan hobi siina dire aki di tenangure nomani kwiang u wai nam mo? I ta honama. ");
INSERT INTO sll_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Te yal ta na hana mo ha maing diga pire gai gol na tenangwo, yali Ari Wang Weni na moli pire na Abe te kwia ensel nabilungwo hobi hamen hobini na molga bani gi di ya bonangure, hamen grang gumang ba bongwo siina dire ari tal ole wa monangwo hobi ere gai gol teralga pamua. ");
INSERT INTO sll_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Omaga malinga hobi tau gonamiba, tau olo golkinangure, God kene ongwo hol i u tibi nangwo hanere emgi gonangwo pamua. Ditega i ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ena Yisas ha di te pisolere, sare ta wai sungure, Yisas ire, Pita ire, Yon ire, Yems ire dire, hamen hul God ha di tenamna dire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pi molere, God kina ha wai olere, ena Yisas grang gumang gaung bani hon pol kungwo galsina ba bolere talta gobere ongure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hangure gin ta Yisas mongwo bani ya su u pa dungure kina hawai ongwi. Ongwo ya suri iwe, haang Moses, Ilaiya kina ure mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Molere hamen ba bongwo meri yasuri gaung bani yu ba bongure, emgi God Yisas nu si olangure, Yerusalem pire gonangwo ha i yasuri boling kule pir mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mongure Pita ening suri kina ulgi sire ul pangwi. Ul pamba, uling yumia airere hangure, Yisas gaung bani ba bongwo i hanere, yasuri kina para aire momia hangwi. ");
INSERT INTO sll_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hangure yasuri Yisas aidolere ere nala di pungwi. Di pungure Pita hanere Yisas yu ditongwi, “Yal Yisas ye, nan yalhobi baniya mominga wai pamia. Oo sui tai dire kenamna do. Kemingere ta Moses oo dinangure, ta Ilaiya oo dinangure, ta ni oo dinama do.” ");
INSERT INTO sll_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dire Pita ha ogolo pir kun ole ta dikima. Ha i di mongure kwahawa ta ure yalhobi yobilungwi. Yobilungure Yisas grang wine ongwo hobi ganulun dire kul bir pungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pimba kwahawa sina ali ha ta yu di mena olungwi, “Yal i na nan wana tani momia, honagi onama dire nu ke teya. Ni yalhobi ha dinangwo grang wine olere ogolo pirio.” ");
INSERT INTO sll_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ha yu di te pisolungure, kwahawa gintani ala dungure yalhobi han holo holo olimba, ari ta molkungwi. Yisas tani momia hangwi. Hanere tal ongwo hangwo i yal ta ha wai ol tekima. Yalhobi nin agi di pire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ena ongi hamen hul aidole ya ime ongure, ari yal al tabin bir weni molere, Yisas hol bangi ungure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hangure ari mongwo sina i yal ta gala bir dire yu dungwi, “Tisao, na wana iwe, tani weniga momia, haniga. ");
INSERT INTO sll_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Momba kwia nigi dongwo ure ol tongure gala bir dire ol gogo dal tongure, gir i habilai sire, grang niri baregi dungure, gaung bani bol kula hala sire mongure, kwia i ya kule momia. ");
INSERT INTO sll_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ni gran wine ongwo yalhobi kwia si doling i olama dire mongwo bani hai me waiba, yalhobi ongwo kunu paikimua.” ");
INSERT INTO sll_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dungure Yisas yu ditongwi, “Ni yalhobi na ha diga wine ole a i si wakirere, i bangi olinga hobi iwe, emgi na molkiralga haung tal onane? Mol i pirere emgi na hon talongure aki di ni terale?” Dire gir irang yu ditongwi, “Ni wani aule ire na molga bania wo.” ");
INSERT INTO sll_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dungure gir i wa di u mongwo bani urala di omba, kwia nigi dongwo i ol tongure yare habilai sire pegare ol mongwi. Mongure Yisas kwia kura ha ditere, si doling i olere, gir i aki di ire irang kule tongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ena ari yal al hobi God tal guma hon ongwo i hanere bukunungwi. Ena Yisas tal ongwo hobi iwe, arihobi bukunere nomani si mongure Yisas nin grang wine ongwo hobi yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ni yalhobi ha ta di ni teralga pir sina eyo. Ari Wang Weni na irawe, na han holi pire ari tau na tenamua.” ");
INSERT INTO sll_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dimba, yalhobi ha i memini pir po sikungwi. Sikirere ha memini kul si pamia, yalhobi Yisas sirin bol pinamba, gai gole han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ena ginta Yisas grang wine ongwo hobi, “Yal ara singaba monamne?” dire ha bolbin di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mongure Yisas yalhobi nomani sina haya han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dire gir migi ta ire aling weni hol i ere yu ditongwi, “Ni yalhobi yal ta na pirere gir migi mala i aki di tenangiwe, gir i tani aki di teya di pinanba, na para aki di na tenanua. Na aki di na tenangiwe, na tani aki di teya di pinanba, na bai nu si olungwo yal i para aki di tenanua. Ni yalhobi monga sina i yal bina taga mongwo hanga i, singaba momua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ena Yon Yisas yu ditongwi, “Yal Yisas ye, yal ta ni hani a i wa molere, kwia nigi dongwo si doling i olungwo haminia. Hanere, na gaminahobo ta molkinia, yu olkio dire, mana ditominua.” ");
INSERT INTO sll_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dungure Yisas yu ditongwi, “A, i mana ditekio. Yal ta kiang pai na tekinangwiwe, nan grana wine ole monamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ena God Yisas nin aki di inangure ere hamen bani nangwo habang u mala ongwi. Ongure Yisas ere Yerusalem nala dire yulang bongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bolere yal tau bai nu si olungure homa ongwi. Pirere Sameria malgi ta pi pa dire, Yisas panangwo oo wai ta i tibi olama di pire ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ena Yisas Yerusalem nala dire ongwo i pire, Sameria yalhobi oo a i sire nona pangwi. ");
INSERT INTO sll_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pangure Yems Yon tal ongwo i maing hanere, Yisas yu ditongwi, “Yal Yisas ye, ni pingere nan dibilgere hamen bani endo ya ime ure arihobi denamba.” ");
INSERT INTO sll_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dungure Yisas inaa dire, “Yu dikio. Na ari hobi si golala dire ta huya, sigare kunama dire wiwa,” ");
INSERT INTO sll_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","dire ere kwaling ta ongwi. ");
INSERT INTO sll_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ena ongwo gin iwe, bangi pi mongure yal ta ure Yisas yu ditongwi, “Ni oo malgi tau onga bani na para doling bole wa pa diralge.” ");
INSERT INTO sll_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dimba Yisas yu ditongwi, “Dua hau hobi oong nin nin ere pamio, te hahoba hobi ereyu oong ere pamio, te na Ari Wang Weni molere, oona ya, te bol ta baniya dikimua.” ");
INSERT INTO sll_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dire yal ta yu ditongwi, “Ni ure na dolna bolo.” Dimba yal i yu dungwi, “Yal Yisas ye. Na nabe yaldimani momia. Gonangwo man wu ere emgi ure ni ni dolni bolalba?” ");
INSERT INTO sll_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dungure Yisas yu ditongwi, “Gonangwo yal i nin man wu ere gonamia. Ni ure God ol wai ol na tongwo ha maing di tibi olana wo.” ");
INSERT INTO sll_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dungure yal ta ure yu ditongwi, “Yal Yisas ye, omaga na ni dolna bolalba, homa wana auna ya, gamnahobi di tibi ol tere emgi uralga ni dolni bolalua.” ");
INSERT INTO sll_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dimba Yisas yu ditongwi, “Yal ta honagi onangwiwe, omeling mobing hol dinangure honagi nomani pire oli nangure para wai panam mo? I ta paikinamia. Te God kene ongwo hol i nibil di na tongwiwe, nega dire oli wanaminga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ena habang ta pi tege eminga Yisas ari ten ana hol pai muru hol pai sutani honagi onama dire nu ke tere yal su su bai nu si olungwi. Olungure homa e tongwi. Tere banta banta yal su su nu si olere, “Ni yalhobi homa pi mongere, na emgi uralua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ditere ha ta ere yu ditongwi, “U sina i homena aang domia. Domba bulangwo ari molkimua. Molkimia, homena hong yal di to. Ditengere honagi ari tau inangure homena aang dongwo i bulere i ku bonamia. ");
INSERT INTO sll_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na ni bai nu si olgiwe, kun sipi sipi giring awi biing nona pangwo kina ereho mongwo ipire diya, pio. ");
INSERT INTO sll_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni yalhobi nanga, kesi ya, gal blasben, kebin daing ta ire hoyo. ");
INSERT INTO sll_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pirere ari hol maulung wanangwo, yahuno ditere hawai olkire haya bli si po. Ni yalhobi oo malgi ta nangiwe, pire yu dio, oo hong yal i ni monga bani hamen wai tanamia yon ura do, ditenania. ");
INSERT INTO sll_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ditenanga yal i oo ala monangwo, “Yahuno” ditere ha wai ol to. Te gumang yaure monangwo, ni hawai ditekio. ");
INSERT INTO sll_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pana gananga wai panangwo bani mone mol pai olo. Olere nir homena ni tenangwo, gogo nere molo. Honagi bani molere tobo inanga pamua. Ni yalhobi oo ta pi ta pi dire kebe ere wakio. ");
INSERT INTO sll_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te ni yalhobi oo malgi ta ongere oo hong yali ni ala enangwiwe, ere homena ni tenangwo i no. ");
INSERT INTO sll_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nerere oo malgi ari nibil panangwo hobi awai ol to. Terere yu di to, “God kene ongwo hol ni monga bani u tibi omua dito. ");
INSERT INTO sll_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ena ni yalhobi oo malgi ta ongere ni ala ekinangwiwe, homaulung bangi molo. ");
INSERT INTO sll_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Molere yu do, ni yalhobi oo ke panga malgi iwe, ganba taporal ongwo na kebena bani bai go dal iminua. Iminba, ganba iwe, nin oo ke panga malgi tariba ke ole naminua. Naminga i, God kene ongwo hol u tibi pi ni tomba, ni yalhobi a i si ikingere ere naminua. ");
INSERT INTO sll_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na di ni terala piro. God ha hol bir ol na tenangwo haung iwe, Sodom ha hol olere tal ol tongwiwe, obilga ol tomia. Tomba ni yalhobi iwe, ha hol bir weni ol ni tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aye Korasin yalhobo, ni Betsaida yalhobi kina gaun gul bir inanua. Tal guma hon dongwo ni monga bani ol ni tega meri Taia Saidon ganba ari hobi yu ol teralga, hanere, tal nigi dongwo ol wangwo gintani aidolere, nomani si kulu sire hon olkirala di pire homan yobilere monamua. ");
INSERT INTO sll_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God ari para weni ha hol ol tenangwo haung iwe, Taia Saidon yalhobi ha hol ol tenamba, ni yalhobi ha hol nimaki nangwo ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ni Kapaneam yalhobi iwe, ari han a yuwo olimia hamen bani nala di pino? Ta honania. God ni irere, pia si endo de pangwo bani olangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ena Yisas nin grang wine ongwo hobi yu ditongwi, “Yal tau ni yalhobi gran wine ole wa monangwo yalhobi iwe, ni tani taman. Na para grana wine onamua. Te yal tau ni mobing hal wa ni tenangwo yalhobi iwe, ni tani taman. Na para wa na tenamua. Na tani taman. Na bai nu si olungwo yal i para mobing hal wa tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ena ari sewenpela ten yalhobi wa i pire siina di memini ure Yisas ha yu boling kul tongwi, “Yal Yisas ye, na yalhobi ni han dal yuwo ere kwia nigi dongwo si doling i olimingere grana wine omua.” ");
INSERT INTO sll_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dungure Yisas yu ditongwi, “Seten i hamen bani yong anigi gintani ongwo meri boi di ya ime ungure haniwa. ");
INSERT INTO sll_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pirio. Ni onba ya, hau grang hongwo Seten pire tal miling engwo bolimbani egeringere, ta ni si golkinama di pire yulana ni teirawa. ");
INSERT INTO sll_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ena kwia nigi dongwo ni gran wine onangwo hanere gun ekio. God hamen bani mol pai gobari inanga pire buku bani hani bol engwo i tani gun e to,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ena habang gin iwe, God Kwiang Yisas yong wu bungure, Yisas yu dungwi, “Nabe, ni hamen ganba hong ni tani monia. Nomani bir pangwo kuru dungwo hobi ha di tibi ol tekinia. Pir po sikungwo yalhobi obil nibil di tenga wai piriwa. O, Nabe ni nin nomani si pinga meri yu onga pamua. ");
INSERT INTO sll_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nabe talhan para muru i na ana bani enua. God, ni wani na molia. Molga maing Nabe nin han po sinua. Te Nabe, ni monga maing na nan ni han po siwa. Sirere, ni ol wanga maing, ari tau di tibi ol teralga, para han po sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ena Yisas grang wine ongwo hobi kina nin molere yu ditongwi, “Tal olga hanere milni pamia. ");
INSERT INTO sll_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Homa God hana togu yal miki ire, singaba king miki ire dire, tal omaga u tibi ongwo hanga meri harala dire momba, olo ta u tibi hongure hankimua. Te ha omaga u tibi ongwo pinga meri pirala dire momba, olo ta u tibi hungure pirikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ena Lo ha nir si tongwo yal ta Yisas mongwo bani pi pa dire Yisas ha ta dinangwo pirala dire, kela kule yu sirin bol tongwi, “Tisao, na tal olere mol pai gobari iralga pire dine?” ");
INSERT INTO sll_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dungure Yisas yu ditongwi, “God Krehaman ha Lo talwa dime? Kere memini pinanga meri di tibi olo.” ");
INSERT INTO sll_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dungure yali Yisas yu ditongwi, “Nan God yuwo, yal iwe, kwiana tere, nomani si pir tere, yona milna tere dinaminua. Nan ari hobi para muru yong miling na tere tal wai ol na tenama di pinaminga meri, nan para yona milna tere awai ol tere dinaminua.” ");
INSERT INTO sll_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dungure Yisas yu ditongwi, “Ni ha pangwo kara dinia. Yu onanga mol pai gobari inanga pamua.” ");
INSERT INTO sll_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dimba Yisas ha pring gintani ditomia, Lo tisa gai golere ha hon sirin bol tongwi, “Nan mominga mala ara monangwo awai ol tenaminga pire dine?” ");
INSERT INTO sll_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dungure Yisas ha sitori yu ditongwi, “Ena yal ta Yerusalem aidolere Yeriko nala dire unamia. Unangure yal ta hol bangi hanere, talhan a nongwo i irala di pire kul si monamia. Molere yal i u pa dinangwo hanere, sire, ol gogo dal tere, gal gule olangure yal i golala di olere pai monamua. ");
INSERT INTO sll_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ena pai monangwo gin iwe, ha maing oo singaba ta ure ya ime pire han uning si ole homaulung bina hol bani kirulu dire ere namua. ");
INSERT INTO sll_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Te Yudari yal ta ere ure hanamia. Hanere yali pai monangwo han uning si olere homaulung hol bani kirulu dire ere namua. Libai yal ere ure hanamia. Hanere yal i pai mongure han uning si olere homaulung hol bani kirulu dire ere namua. ");
INSERT INTO sll_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nangure yol Sameria yal ta ure hanamia. Hanere kiang momba, miling pinamia. ");
INSERT INTO sll_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pirere kebering aling bol kula hala sire nebona dongwo bani er niring bol terere han dale tenamua. Tere aki di kun donki mobing bani olere, aule ire, pasendia oo malgi ta namia. ");
INSERT INTO sll_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pire awai ol tere pare, honmil oo hong yal i moni tu kina tenamia. Tere yu ditenamia, Ni yal i kene ogolo weni ol molo. Olere homena tere tal tau tenanga meri na emgi pring ni teralua, ditenamua. ");
INSERT INTO sll_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ena yal sui tai dire urere bongwo yal i hamia. Yal ara enin ta monangwo meri moma di pine?” ");
INSERT INTO sll_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dungure Lo tisa yu ditongwi, “Awai ol tongwo yal i enin ta momua.” Dungure Yisas yu ditongwi. “Para dinia. Dinga meri ni ere yu onana po,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisas grang wine ongwo hobi kina pirere oo malgi ta pi pa dungure al ta, haang Mata, ure Yisas aule ire oo ala pire awai ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ena al Mata ebering ta haang Maria urere Yisas kebering bani ami di mole ha maing dungwo pir mongwi. ");
INSERT INTO sll_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mongure Mata honagi nega dire olere homena kere a kun ongwi. Ole Yisas mongwo bani pire yu ditongwi, “Yal Yisas ye, na homena kere ol pan bolga ebina aki di na tekimia tal ome? Ni ditengere na aki di na tenamia dito.” ");
INSERT INTO sll_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dungure Yisas yu ditongwi, “Mataye, ni gala nega dire dingiwe, tal miki weni nomani sinba, tal taniga nomani si pirikinua. ");
INSERT INTO sll_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Al Maria iwe, ha wai weni na kina boling kul pir mobilia. Maria tal ongwo i, hobang si tekinaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ena habang ta Yisas banta molere, God kina hawai ol te mongwi. Ol te pisolungure grang wine ongwo hobi ta u pa dire yu sirin bol tongwi, “Yal Yisas ye, yal Yon grang wine ongwo hobi God ha di terala di mongwo nibil di tomiraya. Tongwo meri ni ere yu nibil di na tenanba?” ");
INSERT INTO sll_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dungure Yisas yu ditongwi, “Ni yalhobi God ha diterala di pinangiwe, yu dio. “Nabe, Ni hani awala gale maa e ni tomo. Ni ure yona sina, te ganba sina ya kene ole kwi mol na to. ");
INSERT INTO sll_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Homena kenba kunung benangwo meri na to. ");
INSERT INTO sll_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tal nigi dongwo ol waminga pring na tenga i, i ole na to. Na ere enan tau tal nigi dongwo ol na tongure pring pangwo i, i ole tominua. Kuni kura talime oun denangwo bani na aule i pi olekio.” ");
INSERT INTO sll_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ena Yisas ha hon ainere yu ditongwi, “Ni yalhobi monga sina i yal ta girungwo sinamo u pa dire ulni yure, ");
INSERT INTO sll_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yahuno, yal ta omare u na molga bani pa dungwo homena terala dire wa duga dikimia, ni heba sui tai dire na tengere teralua dinania. ");
INSERT INTO sll_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dinangere yahunanin oo hong yali yu dinamia, Na hoiri yole gir hobi kina ul paya ni talongwo ulna yune? Na airalga ha pirikiwa. ");
INSERT INTO sll_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Dinamba, na di ni terala piro. Yu onangwiwe, yali na yolna wi dima di pire tal ta ni tenangwo paikimia. Paikimba ni gai golkirere, gala di di ole monanga ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na hon di ni teralia. Tal ta irala dire sirin bonanga God ni tenamia. Te tal ta irala dire wa dunanga tali inania. Te hoiri yaulo dire hona grang gala dinanga hoiri yaule ni tenamia. ");
INSERT INTO sll_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ari para weni God sirin bol tenangiwe, tal ta irala di pinanga tali ni tenangwo inanua. Te tal ta wa dunanga tali God i tibi olangwo ere omin hananua. Te hoiri yaulo dinanga God yaule ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ni wani hobi pisi na to dire monangwo ni onba degirime si tenan mo? I ta tekinania. ");
INSERT INTO sll_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Te ni wani hoale miling i na to dinangwo er onba si tenan mo? I ta tekinania. ");
INSERT INTO sll_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ni ari nigi denga wani aun homena gal kul wai tenia. Yu ongere Nabin hamen bani mongwiwe, sirin bonanga God nin Kwiang ni tekinamo? Para ni tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ena kwia nigi dongwo yong sina mongure, ha mining paikirere, du dire wa mongure, Yisas awai ol tomia ha mining pangwi. Pamia ari hobi hanere grang dalungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dalungure yal tau yu dungwi, “Gir hobo, yal i kwia nigi dongwo singaba Bielsebul timi mongwo yal aki di tongure honagi oma hano.” ");
INSERT INTO sll_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dungure yal tau Yisas yong bai tal sire yu sirin bol tongwi, “Ni hamen bani tal guma hon dongwo ta i tibi olingere hanaminba? Olanga hanere, o, God yal i aki di tongwo pamua di hanaminua.” ");
INSERT INTO sll_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dimba, Yisas yalhobi nomani si pungwo i haya han pa dire yu ditongwi, “Wiyol ta sina sikira dire kura bonamia. Bolere kiang kiang monangure ari para wai sinamua. Te oo tabil ta kura bole kiang pare monangwo iwe, oo i mama dinamo? Ta dikinamua. ");
INSERT INTO sll_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te Setan gamahobo nin sikira dire kura bolere nimni mole monamo? Ta molkinama. Ni kwia nigi dongwo si doling i olga i hanere, o, Bielsebul yulang tongwo ire kwia nigi dongwo si doling i olere du haunua di na teniba, ");
INSERT INTO sll_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ni wani hobi kwia nigi dongwo si doling i olungwiwe, ara yulang tongwo ire honagi i ome? Bielsebul aki di tom mo? I ta aki di tekima. Ni ha gogo dinua. ");
INSERT INTO sll_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God Kwiang aki di na tongure, kwia nigi dongwo si doling i olia. Olga hangiwe, God kene ol ni tongwo maing omaga u tibi ongwo hanua. ");
INSERT INTO sll_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ena yal nona panangwo ta oo ke panangwo malgi molere, bona gana yal ta kuni inama di pire, er kwi nu monamia. Monangure yal ta malgi pire, bona gana kuni inam mo? I ta ikinama. ");
INSERT INTO sll_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yal nimni monangwo ta ure kura bolere, oo hong yal i si manbi olere, sugul er ya, di kuba i inamua. Irere ebir sire yal tau tenamua. ");
INSERT INTO sll_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yal ta pana gal na tekinangwo yal i kiang pai na tenamua. Te, yal ta na honagi pire hane ta olkinangwo yal iwe, honagi i isusu olamua. ");
INSERT INTO sll_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ena kwia nigi dongwo ari yong sina i aidole ere banta namua. Pi molere, oo ta wa dunangwo, dikinangwo hanere, Ayo na homa oo wai dungwo moliraya, omaga oona ta dikimia, ere memini nalua di pinamua. ");
INSERT INTO sll_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pirere ere ure homa kepangwo ala i hanangure, bigi sire wai dinamua. ");
INSERT INTO sll_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dinangwo hanere, hon ere pirere, kwia nigi dongwo sewen pela monangwo bani aule ire unamua. Aule ire, ure, yal ta yong sina monamua. Homa yal iwe, kwia taniga yong sina mongwo nigi domiraba, omaga kwia miki weni yong sina monamia, nigi weni denamua. ");
INSERT INTO sll_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ena Yisas ditongwo gin i, ari miki weni u tabin si mongwi. Mongwo sina i al ta gala bir dire yu dungwi, “Al ta ni kul nere aming ni tongwo al irai, miling pamua.” ");
INSERT INTO sll_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dimba Yisas yu ditongwi, “A, i dinba, ari God grang wine ongwo hobi iwe, miling pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ena ari miki weni kri di u tabin si mongure, Yisas yu ditongwi, “Ari yal al maing nigi denga monga hobi tal guma hon dongwo harala dire gala dinba, na ta i tibi ol ni tekiwa. ");
INSERT INTO sll_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","God hana togu yal Yona mongwo bani u tibi ongwo meri iwe, yu nangwo hananua. Yal Yona Nineba hong yalhobi i tibi ol tongwo meri iwe, Ari Wang Weni na ere yu i tibi ol ni tegere hananua. ");
INSERT INTO sll_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Emgi God ha hol bir olere, ari ebir sinangwo habang iwe, Siba ganba al singaba kwin yal Solomon ha maing dungwo pirala dire, nin ganbani pisolere, pi pi Solomon mongwo bani pa dimia, ni yalhobi ha maing mala dimba pirikinia, al i ha di mere si ni tenamua. Yal Solomon singaba bir momba, te hana togu yal timiya mongwo i singaba bir weni momua. ");
INSERT INTO sll_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ena God ari para muru ha hol ol tenangwo gin irawe, Nineba ganba hong yalhobi, yal Yona ha maing ditongwo pirere, tal nigi dongwo ol wangwo i hon olkirala di pire nomani si kulu simia, ni tal ol wanga i aidole nomani si kulu sikinia, Nineba yalhobi ha di mere si ni tenamua. Yal Yona singaba bir momba, te yal ta timiya mongwo i singaba bir weni momua. ");
INSERT INTO sll_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ena ari kewa elame galere, mulu ali kul si enamo? I ta ekinamia. Bol bani enangure dere kurani sinangwo, ari oo ala monangwo hobi para hanangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Omin iwe, gaun kewa dimia. Kewa dere au dungwo meri iwe, ni omin para pine di hania. Omin au dinangwo irawe, nomani gaung i para au dinangwo hol hankun ole wananga pamia. Te omin si bonangwo irawe, nomani gaung i para si bonangwo hol wakinanga pamia. ");
INSERT INTO sll_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te ni kwian si bongwo ala i ya mol panangwo, mol pai oli nanga, yo tekinangwo pamia, kene ogolo olo. ");
INSERT INTO sll_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hama si pangure kewa elame dere gaung bani kurani si engwo meri iwe, ni kene ogolo ole monanga, kwian nomani gaun para weni au di poira sinangure, obilga ta si bolkinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ena Yisas ha i di pisolungure, Perisi yal ta homena nenama dire wo dungwi. Dungure oo ala pire homena nerala dire ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Molere aling bigi sikungure, Perisi yal i hanere yu nomani si pungwi, “Ayo, yali homa aling bigi sikimia, talongwo homena aling gama kina nome?” di pungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pimba Yisas yu ditongwi, “Ni Perisi yalhobi mulu sin hau maini bolimbani bigi si wai olinba, talime yal monga yon milni sina i nigi domua. ");
INSERT INTO sll_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ni yalhobi nomani ta paikinua. God gaun maini ala para ol emua. ");
INSERT INTO sll_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ena nir homena pele bigi singa i tamamia yal bina hobi pirari pare tal dime dire ol tenanga, kwian sinali wai dinamua. ");
INSERT INTO sll_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Aye, ni Perisi yalhobi milni pirie. Ho gu kengwo tali, te kwasuli hawi tal wo i, tau ana holo holo irere, taniga God tenga i, wai pamua. Pamba, yon milni God tekirere, tal gogo onga pamua. Onga i, God ha maing a ime olinua. Olinga i pisole ha maing para weni a i si ware wine onanga pamia, olo. ");
INSERT INTO sll_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Aye, ni Perisi yalhobi milni pirie. Ha maing oo ala pire bol hona ami di molgere ari na hanama di pinua. Te homaulung bangi molgere, ari singaba momua di na tenama di pinua. ");
INSERT INTO sll_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pinba milni pirie. Ari yulagi ere u sikungwo meri iwe, yu monia. Ari yone engwo i hankire, hol wai dima dire wamia. Wangwo meri iwe, ari ni gaun maini wai dungwo hamba, nomani kwian sinali nigi dongwo hankimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dimiawe, ha maing Lo nir si tongwo yal ta Yisas yu ditongwi, “Tisao, ni ha dinga i na yalhobi ominga maing dire gauna ha sinua.” ");
INSERT INTO sll_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dimba Yisas yu ditongwi, “Aye, ha maing Lo nir si tongwo yalhobo, milni pirie. Ni yalhobi iwe, ari ha maing pungwo hobi honagi oun dongwo i au si tenua. Teniba, tenga meri ni yalhobi nin aki ditere olkinua. ");
INSERT INTO sll_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ni yalhobi milni pirie. Kwian moya yalhobi God hana togu yal tau si gomiraya. Golere man wu engure, yulagi engwo bani egin wai ol tere, oo ke tenua. ");
INSERT INTO sll_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwian moya tal gogo ongwo i, boleng kul pire pire molere, a yuwo ole wanua. Kwian moya yalhobi God hana togu yal tau si gomba, ni yalhobi kwian moya man wu engwo bani egin wai ol tere, oo ke tenua. ");
INSERT INTO sll_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","God ha tani di engwo meri yal ta yu bol emirawa. Na hana togu yal tau ire, yal tau ire dire, nu si olgere, yal tau si doling ire, yal tau si gomua. ");
INSERT INTO sll_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gomia homa malungwo hobi tal ongwo i pring iwe, omaga gang malinga hobi ere para inia, gaun gul bir inanua. ");
INSERT INTO sll_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hamen haya yal Ken ebering Ebel si gomia. Si gongure moli pirere, emgi yal ta yal Sekaraia ha maing oo ala bol mala si gongwiwe, God tobo nigi dongwo ni tenangure gul inanua. Hamen haya si gongwiwe, pring ni omaga gang giri malinga hobi para weni inia. Irere gul bir weni inanua. Na ha weni kara di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Eke, ni Lo ha nir si tenga yalhobi iwe, milni pirie. Ni yalhobi ha maing pir nomani sina enanba, ha maing ki miling ni tega irai i bangi olere, arihobi nir si tekinua. Yal tau ha maing pinamba, ni hoiri yole tenia para pirkimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ena Yisas ha i di te pisolere, ere mena ongwi. Ongure, Lo ha nir si tongwo yalhobi ire, Perisi yalhobi ire dire, kina ereho ongwi. Pirere ha di mere si tenamna dire nega dire sirin bol pungwi. Sirin bol piregere yal i ha gogo ta grang bani u mena nam mo dire, kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nangwo irai ha hol ol tenamna dire han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ena habang ta, ari tausen tabin bir weni u yobilere, si di dire mongwi. Mongure Yisas grang wine ongwo hobi nin homa yu ditongwi, “Perisi yalhobi hasu dire grang dirani sungwo si dina dire, u bir ongwo namia, wine olkio. ");
INSERT INTO sll_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tal ta kul si dinangwiwe, emgi u tibi nangure hanaminua. Te ha ta di bii enangiwe, emgi ere u tibi nangwo pinaminua. ");
INSERT INTO sll_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ha di si bonangwo ala olangiwe, omare ari sungwo bani u tibi nangure pinaminua. Ni yalhobi oo ala molere, ha di manbi olangiwe, emgi oo bring bani mole gala bir dire dinangwo ari para pinangwo gai bir gonanua. ");
INSERT INTO sll_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Enambi hobo, yal ta ni sinangwiwe, gaun tani si gonamia. Nomani kwian para sigolkinamia, kul pirikio. ");
INSERT INTO sll_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ni yalhobi kul pire wangiwe, na nibil di ni teiya hano. God iwe, gaun si gonangwo, nomani kwian ire pia si endo denangwo bani olangwo pamia. God tani kulung pir to. ");
INSERT INTO sll_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hahoba elamaila ana hol pai muru maket homena bring sinongwo bani engwo moni nol tu toea obil bomua. Bomiba, hau iwe, hamen Nabe pirikinangure, wala gal ware yanamo? I ta yakinama. Kene ol tongure wamua. ");
INSERT INTO sll_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ni yalhobi bini eme iwe, para weni God kerere, pir po simua. Simiawe, ni kul ta pirikinania. God, hahoba talwo iwe, kene omba, nan ari nomani bolo na ol engwiwe, na kene ogolo weni omua. ");
INSERT INTO sll_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ena yal ta ari mongwo maulung bani na hana dal tibi olangwiwe, olangwo yal i haang na Ari Wang Weni, ere God kwia ensel hobi kina mongwo maulung bani di tibi olalga pamua. ");
INSERT INTO sll_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Te yal ta ari hobi maulung bani na gai gol na tere, hana dal tibi olekinangwiwe, Ari Wang Weni na ere yal i haang God kwia ensel hobi kina mongwo maulung bani dal tibi ol tekiralga pamua. ");
INSERT INTO sll_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Na Ari Wang Weni molia, yal ta na gauna ha sinangwiwe, God pring i ole tenangwo pamua. Te yal ta God Kwiang gaung ha si tenangwiwe, pring God han uning si olangure, ya di panangwo panamua. ");
INSERT INTO sll_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ena yal tau ni han hol ire, ha maing oo ala pire, ha hol ol ni tenangwo mo, gabman te kene ongwo hobi mongwo bani ha hol ol ni tenangwo mo, ni yalhobi kul pire tal ha dirale dire nomani gogo sikio. ");
INSERT INTO sll_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ol ni tenangwo gin iwe, God Kwiang yon wu bilere, ha i gran bani enangure dinanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ena ari tabin bir weni mongwo sina i yal ta aire Yisas yu ditongwi, “Tisao, nabe haya gongure, talhan hobi abinambi muru ha te imia, ni ure ditengere, ebir sire, na tau na tenama womo.” ");
INSERT INTO sll_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dimba Yisas yu ditongwi, “Na yas ha hol pungwo yal molere, talhan i ebir sire ni teralo? Terala na gabman molimo?” ");
INSERT INTO sll_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Direre Yisas ainere yu ditongwi, “Hulu moni ya, bona gana tau nomani i bani tere wakio. Nomani i bani tere wananga, mol pai gobari inan mo? I ta ikinanua. Te bona gana miki weni a nenangiwe, mol pai gobari bring sinan mo. I ta sinanga paikimua.” ");
INSERT INTO sll_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dire Yisas ha bangi biire yu ditongwi, “Yal ta talhan miki weni a nere, ganba bir weni ire kepanamia. ");
INSERT INTO sll_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ke pare molere, homena yanangwo i miling miki weni hole aang denangure, hong yal i yu nomani si pinamia, Ayo, na homena i miki weni dimia, oo ta mamia. ");
INSERT INTO sll_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oo ke paga hobi tulere, hon bir weni kere, homena i para weni i ala i egere, kunu benama dipinamua. ");
INSERT INTO sll_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yong sina iwe, yu nomani si pinamia, tal wai dungwo hobi miki weni bona si egere, me erin miki weni ya di panama di pinamia. Erin mole nir homena nere, gun ere wai pire molala di pinamua. ");
INSERT INTO sll_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pinamba, God yu ditenamia, “Ni nomani paikinga pamia. Kenba ginangwo gonanua. Gonanga talhan olala dire, nomani si pire akun ol engiwe, nin inan mo? Ta ikinanua. ");
INSERT INTO sll_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ena ari hobi tau talhan miki weni a nenga i pingere, mo yu nangwiwe, i ganba tal dimia. Te God mongwo bani talhan ta dikimia. God wai pir ni tenam mo? I ta pir ni tekinamua. ");
INSERT INTO sll_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ena Yisas grang wine ongwo hobi yu ditongwi, “Eno, ni yalhobi ha ta a i wanana dire di ni tominia piro. Ni homena ma dinangwo nerale? Galsina ma dinangwo irale? yu dire kraun aulekio. ");
INSERT INTO sll_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te God ni yalhobi hon monana dire honagi bir weni ni tomia. Homena galsina ni terala dire God honagi obilga ol ni tenangwo pamia, ni tekinamo? Ni tenamia talongwo nomani si oun dene? ");
INSERT INTO sll_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ena hau sipia wangwo i, ni yalhobi nin maing para han po sinia. Homena yare bule yu ala ere nom mo? I ta nekima. God hahoba kene ol terere, homena nin tongure nomua. Nongwo i, God hahoba kene ongwo wai pamba, te ni ari moli onga i God ni kene wai weni omua. ");
INSERT INTO sll_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ongwo ipire, omaga golal mo? emgi golal mo? dire nomani si gogo danangiwe, gonanga haung nin pir po sin mo? Ta sikinia. ");
INSERT INTO sll_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sikinga ipire, tal migi ta onanga paikinangwo irawe, emgi tal bir ta olalga panama di pinanba, weni kara ta onanga paikinamia, nomani si gogo dalkio. ");
INSERT INTO sll_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Er kuung sungwo para hania. Sungwo erin bani iwe, galsina ta sibire ware, kebering gal wam mo? I ta wakima. Iwe, homa singaba king Solomon galsina wai a nere wamba, te er kuung sungwo i, wai weni dimia. ");
INSERT INTO sll_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Homena yanga sina tul sungwiwe, kenba ya dinangwo hananiba, ongi tul dere kri di i pire endo dongwo bani ganamua. God er yung kene ol tomia. Tere ni ari para ni kene ol ni tekinamo? Ol ni tenamia. Galsina ya, talhan hobi ni para ni tenamia. Tenangwo pangwo ipire, ni ogolo nomani si pir tere molkino? ");
INSERT INTO sll_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nir homena ma dinangwo nerale? yu di pirikio. ");
INSERT INTO sll_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ari hana ya moni mole ha maing pirkungwo hobi iwe, yu di pire wa dunamia. God nomani paikimo? Nomani bir pamia, talhan tau irere, gaun dirin dinangwo molala di pinanga i, Nabe hamen bani mongwo i, nin pire, aki di ni tenamia. ");
INSERT INTO sll_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tenangwo pangwo ipire, ni pir gogo dalkio. Homa God grang wine olere, a i si wananga, emgi tal tau i tibi ol ni tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ena girhobo, kun sipi sipi tabin obilga mongwo meri monia kul pirikio. Hamen Nabe kene ol ni teralga kul pirkinana dimia. ");
INSERT INTO sll_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ni tenangwo pangwo ipire ni, talhan a nenga hobi ebir sire, moni bol ire, yal tau talhan a nekinangwo hobi ya moro te uning si olo. Ganba baniya talhan dinangwo nomani tere bona si wakio. Tobo gobari ya di pangwo hol i wa dure molo. Hamen bani talhan wai dinangwo nomani tere bona si wayo. Wananga, hamen bani iwe, simin ta malekinamio, te ari ta kuni nekinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pangwo ipire bona si ere a i si wananga, tal wai dungwo bani muru dinamia, nomani kwian para te bani olanua. ");
INSERT INTO sll_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ena tal ta u tibi unangwo haung pirikinia, gal goptani pire, kun gang a i si dere, kewa gale a non ole molo. ");
INSERT INTO sll_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Monanga, ari singaba al inangwo, homena si ganangwo ne pisolere, ere unamia dire, honagi ari hobi a non ole monamua. Monangure u hona pa dire gala dinangure, hoiri gintani yaule tenamua. Yaule tenangure, singaba i ala hanamba, yalhobi ul paikire, hon monangwo hanamua. ");
INSERT INTO sll_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hanangwiwe, honagi ari hobi nomani yu si pinamia, o, na hon molga irai, nabe umia na sikimua dire, gun ere monamua. Ena singaba i wai pire kun gang a i si dere, honagi arihobi homena ke tenamua. ");
INSERT INTO sll_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Singaba i girungwo sinamo unamba, honagi arihobi wai wai pire, hon monangwo hanere, wai pir tenamua. ");
INSERT INTO sll_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kuni nenangwo yal ta unangwo haung oo hong yal i haya pir pa dinangwo, er kwi nu monamia. Monangure yal i oo ala pire, tal ta kuni inam mo? I ta ikinamia. ");
INSERT INTO sll_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ena na Ari Wang Weni molia, uralga haung ni yalhobi pir po sikinia a non ole molio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ena Pita Yisas yu ditongwi, “Ha bangi biire dinga irai, na tani han din mo, ari hobi para han dine?” ");
INSERT INTO sll_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dungure Yisas yu ditongwi, “Honagi ari hobi honagi wai ongwo yal iwe, singaba honagi para muru yal i aleng bani emia. ‘Honagi ari hobi homena nenangwo haung kene ole homena to. Na oona malgi kene ol molo,’ ditenamia. Yu ditere, singaba ganba hong yal i ere milin ta namua. ");
INSERT INTO sll_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pi molere, siina dire ere malgi ure hanamba, gamahobi honagi ditongwo mere ogolo a i si ol molere, gun enamua. Ol molkinangwo, ganulun dire kul pinamua. ");
INSERT INTO sll_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ol monangwo wai panangwo i, hong yal hanere, ‘Homa tal obilga kene ol monia, omaga talhan hobi para weni kene ol molo,’ ditenamua. ");
INSERT INTO sll_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Te honagi yal i, Honagi hong yal i haya hunama di pire monamia. Molere honagi yal al hobi sire, homena miki nere nir bia nere, spak ole, hayul di wa monamua. ");
INSERT INTO sll_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Monangure honagi hong yal i mining mining bolo tima ure hanamba, honagi ari hobi tal yu ol monangwo hanere, sire ol gogo dal tenamua. Terere ha maing a i si wakinangwo yalhobi, gonangwo kwiang aule i pi gul tenangure inamua. ");
INSERT INTO sll_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ena honagi ari ta honagi hong yali grang bani pimba, pirere nin pungwo meri ol ware, singaba grang si olamua. Olangure hong yal i ure hanere, nigi de pire, honagi yal i sire ol gogo dal tenamua. Te honagi ari ta honagi hong yal i grang ha pirikinangwo iwe, tal mere olale di pire honagi gogo oli pi sin tan onamia. ");
INSERT INTO sll_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Onangure singaba u pa dire hanere ogolo sinamba, singaba grang pirikinangwo i pirere ogolo ta sikinamua. Ari talhan miki weni a nenangwiwe, God hanere, na tega a nomia, pring mong ta tere tere nenama di pimua. Te arihobi yal ta tal miki weni tenangwo irai, nere uning si monam mo? I ta molkinamia. Pring hon na tenama di pinamua. ");
INSERT INTO sll_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na ugiwe, ha maing honagi olgere, ari wiyol ganba bina holo holo i kunung benama dire wiwa. Olere nega dire arihobi haya yol e pinama dire wiwa. ");
INSERT INTO sll_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na gauna gul irere, nir bilala di piriba, olo bilkirere piriga oun domua. ");
INSERT INTO sll_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ni yalhobi pinga na ganba bani ya kura nigi dongwo kuku arala dire uma di pino? I ta huiwa. Na ugiwe, ha wai dire pana gale mongwo hobi a poira si terala dire wiwa. ");
INSERT INTO sll_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Omaga te emgi para ari ana hol pai muru oo tani ala i monamia. Monamba, yal sui tai dire yasu kiang pai tenamua. Te yasu i hon ya sui tai dire kiang pai tenamua. ");
INSERT INTO sll_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Gin ta irang hobi wang kiang pai tenangure, te gin ta wanghobi irang kiang pai tenamua. Gin ta aang aung kiang pai tenangure, gin ta aung aang kiang pai tenamua. Te gin ta hoing aimbi kiang pai tenangure, gin ta aimbi hoing kiang pai tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ena Yisas arihobi hon ainere yu ditongwi, “Ari ya bengwo bani iwe, kwahawa kengwo hanere, ‘O, girhobo, kenba nimin yanamua,’ dinia. Dinga iwe, nimin weni kara yangwo hanua. ");
INSERT INTO sll_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te gin ta hobil hamen hol iwe, hamen hair mu dinba ungwo hanere, ‘O, girhobo, kenba ari bir denamua’ dinia. Dingiwe, ari weni kara dongwo hanua. ");
INSERT INTO sll_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ni yalhobi hasu gran dirani sire di wanua. Ni yalhobi hamen ganba ari dere, nimin yare ongwo haung iwe, pir po sinia. Sinba, omaga na u tibi uga monga haung iwe, maing pir po sikinua. ");
INSERT INTO sll_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ni yalhobi ha dinga giu di pangwo iwe, talongwo pama di pine? ");
INSERT INTO sll_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na u tibi uga ha i, talongwo nomani si pir tekine? Ena yal ta ha hol ol ni tenamia. Ol ni tenangwo yal iwe, hol bangi u kel dinangwo irai gintani ha wai panangwo di to. Dikinanga yal i ni aule ire pire Yas ha hol pungwo yal mongwo aling bani enamia. Enangure yal i ni aule ire pire plisman tenamia. Tenangure yal i ni aule ire pire ni hani sinamia. ");
INSERT INTO sll_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yu onangwo pangwo ipire ni yal ta taling ni tenangwo nenangiwe, pring te wai si olere, sigare kule isine dinanga pamua. Na ha weni di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ena Yisas ha yu dungwo gin iwe, yal tau molere, Galili ari tau God pir tere mole homena si gale tomba, Gabman nambawan Pailat ure tal ongwo i hanere, para si gol wai simia. Sungwo ha iwe, arihobi Yisas boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tomba, Yisas ari hobi yu ditongwi, “Pailat Galili ari tau tal ol tongwo i pirere, Galili ari tal nigi dongwo ol wamba, te Pailat si gongwo hobi iwe, tal nigi dongwo miki weni ol wama di pino? ");
INSERT INTO sll_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Di pinba, na ongwo maing ogolo weni di ni teralia. Ni yalhobi tal nigi dongwo ol wanga i, nomani si kulu sikire, hon olala di pinanga, gongwo tali para gonanua. ");
INSERT INTO sll_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ena ari ana holo holo kebena hol pai muru kebena hol pai sui tai dire iwe, homa Siloam malgi oo arikri weni ke pai mongure oo i yare si gomia. Si gongwo hobi iwe, tal nigi dongwo miki weni ol wangure God pring oun dongwo tongwo ire gongure, te Yerusalem arihobi tal nigi dongwo obilga ol wangure God pring obilga tongwo ire ya moma di pino? ");
INSERT INTO sll_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yu di pinba, na memini ogolo di ni terala piro. I yu ta olkimia, ni yalhobi tal nigi dongwo ol wanga i, aidole nomani si kulu sikire, hon olala di pinanga, gongwo tali para gonanga monua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ena Yisas hon ainere, ha di bole yu ditongwi, “Homena ya nenangwo sina i er kwasulu ta bonamia. Bonangure miling honama di hanamba, holkinamia. ");
INSERT INTO sll_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Holkinangure hong yal i honagi yal ta yu ditenamia, “Na me erin sui tai dire molere, er i miling ta honangwo nerala dire wiraba, holkungwo pamia, we olo. Talongwo ya moni ganba niri ne pire bome?” ");
INSERT INTO sll_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dinamba, honagi yal yu ditenamia. Yahuno, i ta wekinaminia. Aidolimingere omaga me erin taniga ya dinangwo hanaminua. ");
INSERT INTO sll_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na ganba dimani gula dire, marasin bolgere, wai bolere, miling honam mo, holkinam mo, hanere, emgi er i we olaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ena Sabat haung ta Yisas ha maing oo ala molere, arihobi ha nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tongwo ala iwe, al ta mongwi. Al i kwia nigi dongwo yong sina mongure, me erin ana holo holo kebena hol pai muru hol pai sui tai dire nibil ol tongwi. Ol tongure, al i kara u yuwa pire aire nimni mole wakungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Wakimia Yisas hanere yu ditongwi, “Alhuno, ni nibil onga i wai simua,” dire aling sine dire gaung bani angure, angwo meri gintani u wai omia, aire hol wangwi. Warere God maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ena Yisas Sabat haung al i awai ol tongwo iwe, ha maing oo singaba ta hanere Yisas nigi de pir tongwi. Tere ari yal al ha maing oo ala mongwo hobi yu ditongwi, “Nan iwe, ari haung ana hol pai muru hol pai taniga honagi onaminga pamia. Hamen haung iwe, awai ol na tenama di pinanga i ta mamia. Te Sabat haung awai ol na tenama di pinangiwe, kunung paikimua.” ");
INSERT INTO sll_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dungure yal Yisas yal i yu ditongwi, “Ni hasu ari gran kwal sinia. Sabat haung ni yalhobi kun kunga u gire si di pire nir tengirawe. ");
INSERT INTO sll_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tenga meri iwe, al i Ebraham gang momia, Seten ol tongure nibil pare me erin ana holo holo kebena hol pai muru hol pai sui tai dire pai momia. Nibil ongwo i Sabat haung awai ol tekinama dire dino?” ");
INSERT INTO sll_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisas ha di holo ol tongure kiang hobi gai gongwi. Ena arihobi Yisas talhan para weni ongwo i wai pire gun e tongwi. ");
INSERT INTO sll_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ena Yisas yu dungwi, “God ari ya, talhan para weni kene ongwo iwe, di tibi olalga tal di bole dirale? ");
INSERT INTO sll_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iwe, er ta haang Mastet dungwo bani di bole diralua. Yal ta homena ya nenangwo sina er mastet para kunamua. Kunamba, er iwe, bole u bir weni namia. Nangure yolang bani hahoba oong ere bani mol pai onamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ena Yisas hon ainere yu ditongwi, “God ari ya, talhan para weni kene ol ni tongwo iwe, tal di bole dirale? ");
INSERT INTO sll_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Marasin ta haang Yis bani di bole diralua. Yis iwe, agr ire plaua gangwo ali olungwo u bir ongwo hanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ena Yisas oo bir migi tau malgi wa pisolere, ari ha maing nir si tongwi. Te pisolere Yerusalem nala di pungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pungure yal ta ure Yisas yu sirin bol pungwi, “Yal Yisas ye, God ari aki di tere sigare kul tenamua dinga i, yal tani taniga sigare kul tenamo?” ");
INSERT INTO sll_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Dungure Yisas yu ditongwi, “Ni yalhobi nin yulang bolere hona grang migiga po. Ari miki weni ala nala di pinamba, nangwo kunu paikinamia. ");
INSERT INTO sll_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Paikinangure oo hong yali gintani ure hoiri yole nona panamua. Ni yalhobi pi maini pire ha sire, ‘Yahuno, ni hoiri yaule na tengere ala unaminba?’ dinania. Dinanba, yal i yu di ni tenamia, ‘Ni ara ure dine? Ni guman hankigirawe.’ ");
INSERT INTO sll_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dinangure yu ditenania, ‘Ni nan nir homena para tani nominirayo, te oona malgi mole ha maing di na tengirawe.’ ");
INSERT INTO sll_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dinanba, yal i yu di ni tenamia, ‘Ni ara ure dine? Ni tal nigi dongwo onga ure dina ere pio,’ di ni tenamia. ");
INSERT INTO sll_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Di ni tenangure yalhobi Ebraham ire, Aisak ire, Yekop ire, God hana togu yalhobi ire dire, God kene ongwo bani momba, ni yalhobi iwe, maini hara hara ware monanua. Molere aya maya dire sigin girimil nure monanua. ");
INSERT INTO sll_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Monanba, ari hobil, kuman, geral, bomai tau God kene ongwo sina i pire, bol wai ami di mole homena nere monamua. ");
INSERT INTO sll_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bol hona mole hamil ha singa hobi hon u bisi nanua. Te, yal bina tau bol bisi mongwiwe, hon iri si bol hona mole hamil ha sinanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ena dungwo gin iwe, Perisi tau u Yisas mongwo bani pa dire yu ditongwi, “Yal Heroti ni si golala dimia. Baniya pisole ere banta po.” ");
INSERT INTO sll_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dimba Yisas yu ditongwi, “Herot ari bal tongwo awi mongwo meri momia, ni pire awi i ditenana po. Na haung obilga kwia si doling i ole, nibil pangwo hobi awai ol te molalia. Ongi mole, tal irawe, honagi ol wai sire ere nalia. ");
INSERT INTO sll_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nalba, haung obilga, para ere nalga pamua. Naliba ari na si golala dungwiwe, banta na si gonangwo paikimia. Yerusalem God hana togu yal tau si gongwo bani iwe, na sigonangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ena Yerusalem hong ye, Yerusalem hong ye, God hana togu yal para si gonia. Te na yal tau bai nu si olega hobi para hulu kuba sinia. Hoale aang giring di ku bol i hong ala ere kule pamia. Pangwo meri iwe, Yerusalem ari hobi di ku bolere iiba, ni yalhobi simane sinia. ");
INSERT INTO sll_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Singiwe, oon aibin i God pisolangure po ere dinamua. Omaga ni yalhobi na haniba, emgi hon na hankinania. Te yal ta ure God ol wai ol na tongwo ha maing di tibi ol ni tenangwo pirere, wai piriwa, dinangiwe, na ti hon na hananua. Ha pangwo di ni teya ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ena Sabat haung ta Yisas Perisi ari singaba ta oo ke pangwo ala homena nerala dire pi mongwi. Mongure ari hobi Yisas tal ta onangwo harala dire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ena yal ta kebering aling yaungure Yisas mongwo bani u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pa dungure Yisas hanere, siina dire, ha maing Lo nir si tongwo hobi ire, Perisi hobi ire dire, sirin bol tere yu dungwi, “Ha maing Lo Sabat habang ari nibil onangwo awai ol to dim mo, tekio dime?” ");
INSERT INTO sll_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dimba ha ta bai tekirere pir uning si mongwi. Ena Yisas nibil ongwo yal i awai ol tere, ere po dire nu si olungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Olere ha maing singaba hobi yu ditongwi, “Ni yalhobi monga sina i wani mo, kun mo, ta Sabat habang yo maul nangure, i mena olan mo, olekinane?” ");
INSERT INTO sll_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dimba, ha mong di tenamba, gai pangure pir uning si mongwi. ");
INSERT INTO sll_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ena Yisas hangure ari hobi homena nerala dire ungwi. Ure bol guma bani molgere, ari na hanama di pire, ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mongure Yisas mongwo hobi di bole yu ditongwi, “Yal ta ama yal terala dire homena bir si gale gala dinamia. Dinangure ni unanga, bol guma bani ami di molkio. ");
INSERT INTO sll_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Monanga, yal ta haang mo yu nangwo yal i unangure homena hong yal, “Ni ai si to” di ni tere, yal ta haang mo yu nangwo yal i bol guma bani ami do ditenamia. Ditenangure ni gai gonania. Golere pi mobing holi ami di monanua. ");
INSERT INTO sll_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ena yal ta homena bir si gale gala dinangwo gin iwe, ni nangi pire, bol mobing hol i ami di molo. Monanga, homena hong yal i ure ni hanamua. Hanere ni bol guma holi monana wo di ni tenamia. Tenangwo, ari homena ne mongwo hobi ni hanere, o, yal i haang mo yuwo ongwo pamia, di hanamua. ");
INSERT INTO sll_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yal ta nin gaung di yuwo erere, wa monangwo yal iwe, God yal i haang a ime ol tenamua. Te yal ta nin gaung di yuwo eikirere, wa monangwo yal iwe, God yal i haang a yuwo ol tenamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ena Yisas homena si gangwo hong yal i yu ditongwi, “Ni homena si ganangiwe, nin enin abin hobo ya, arini hobo ya, gaminahobo tal miki weni a nongwo hobi, di aulanga paikimia. Di aulanga, yalhobi nere mole, emgi pring ke ni tenangwo nenanga pamua. ");
INSERT INTO sll_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ni homena si gananga gin iwe, ari yal bina kultaing hobi ire, kebering aling keber engwo hobi ire, omeling gi dungwo hobi ire dire, di aulingere nenangwo pamia. ");
INSERT INTO sll_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nenangwo nere yalhobi homena mong ke ni tenangwo paikimua. Paikungwo ipire ke tenanga yali miling wai ire gun enanua. Emgi tal dime dire ongwo ari hobi golere, hon airangwo gin iwe, homena si gal tenga i tobo ni tekinamba, God tobo ni tenangure inanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ena yu dimia homena ereho ne mongwo sina i yal ta pirere, Yisas yu ditongwi, “God kene ongwo sina i homena ne monangwo hobi miling panangure gun enamua.” ");
INSERT INTO sll_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dungure Yisas yu ditongwi, “Yal ta homena bir weni si gale ari taporal nenama dire di aulamia. ");
INSERT INTO sll_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aulangure homena nenangwo habang u mala weni nangwo hanere, homena a non ole ere, honagi ari ta bai nu si ole yu ditenamia. Homena irai para akun ole eminia, ni pire nenangwo ari aule ire unana po. Ditenangure yal i pire yu ditenamia, ‘homena para akun ol engwo uminia, nenana wio.’ ");
INSERT INTO sll_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dinamba, arihobi omeling pege dinangure, yal tani tani aire, yu ditenamia, ‘Na ereho naminba, ganba bring siminga hanamna dire mominua.’ ");
INSERT INTO sll_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te yal ta yu ditenamia, ‘Na ere para naminba, bulamahau ana holo holo bring siminga kene onamna dire mominua.’ ");
INSERT INTO sll_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te yal ta yu ditenamia, ‘Na al omaga iminga kene ol mominia ta hunaminua.’ ");
INSERT INTO sll_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ditenangure yal i aidole, ere memini pire homena si gangwo yal i ha dungwo meri boling kul tenamia. Tenangure homena hong yal iwe, yong ki bir ere, honagi yal i yu ditenamia, ‘Ni bli si homaulung bangi pire, yal bina kultaing, omeling gi dungwo, kebering aling keber engwo monangwo hobi aule ire unana po.’ ");
INSERT INTO sll_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dinangure honagi ari hon ure yu ditenamia, ‘Yalhuno, na ni gran wine oliwa. Oliba, bol ta ya dimua.’ ");
INSERT INTO sll_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dinangure singaba yal i yu ditenamia, ‘Ni bli si malgi pire, homena ya nenangwo ya, kun oo kepanangwo hobi wa dure, ari ta monangwo aule ire unana po. Unangere oo ala i si di dinama di piriwa. ");
INSERT INTO sll_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ari hobi homena nenama dire hamen haya gala digarai, emgi unangwo i homena nekinamua.’ Ha weni diiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ena ari miki weni Yisas doling bol ongwi. Ongure Yisas inaa dire ari hobi yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yal ta na grana wine ole dolna bolala dire onangwo yal iwe, irang aang ya, gir kul nenangwo keumbi, eumbi, eberimbi, nin kwian gaun nigi de pir tenangwo na gamnahobo monamua. ");
INSERT INTO sll_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yal ta na dolna bolala di pinangiwe, gaun gul ikirere, dolna bonan mo? I ta bolkinana. Gaun gul bir irere, dolna bonanga pamua. ");
INSERT INTO sll_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ni yalhobi oo kerala di pinangiwe, homa moni i ku bole nomani si pir i ongere, moni kunung benangwo mere pinanga i, oo kenanga pamua. Nomani homa si pirikire, gogo ol i nangiwe, oo kenanga kunung benamo? I ta bekinamua. ");
INSERT INTO sll_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bekinangure ari hobi hanere, gaun ha sire wa gol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tere yu di ni tenamia, yali oo i kemiraba, kunung bekungure ya dimia hano,” ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ena ari singaba king ta singaba ta kina kura bolala dire onamia. Singaba ta iwe, soldia ten tausen aule ire namia. Namba, singaba ta iwe, soldia twenti tausen aule ire namua. Ena ten tausen aule ire nangwo yal iwe, homa nomani si pinamia. ‘Ayo, yalhobi soldia twenti tausen aule ire umia, kura bolalga win siral mo,’ dipinamia. ");
INSERT INTO sll_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Win sikiralua dipinangwiwe, yal tau bai nu si olangure, pire singaba ta ditenamua. Na kina kura bonaminba, paikimia, ni tal ta irala di pinanga tal i, ni teralua. ");
INSERT INTO sll_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te ni yalhobi talhan para muru a nengiwe, pisolekinanga, na grana wine ole molkinanua. Pisolanga, na grana wine ole monanua. ");
INSERT INTO sll_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ena homena pil bemia hano. Pil gwiring mena pi wai sinangure, ire, tal omingere gwiring hon moname? I ta molkinama. ");
INSERT INTO sll_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yu onangwo pil iwe, pia si manbi olimingere, ganba hama sinam mo? I ta sikinama. Pil iwe, ya moni pia si hogal ai olaminga pamua. Ari nomani pamia, ha i pir po sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ena hamen haung ta moni takisi ingwo yal tau ire, hana ya mole ha maing pirkungwo yal tau ire dire, u Yisas mongwo bani ure, ha maing dungwo yol e pire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mongure Perisi yalhobi ire, ha maing Lo tisa ire dire, hanere tal ongwo i siga wa tere yu dungwi, “Ayo, yal i ari ha maing pirkungwo hobi kina pana galere, homena ereho ne momia, hano.” ");
INSERT INTO sll_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dimba Yisas ha ta di bole yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ni yalhobi monga sina i yal ta kun sipi sipi miki weni wan handret kul nenamia. Kul nenangure, taniga u nin bangi nangwo hankinangwo aidolam mo? I ta aidolekinama. Wa dunangwo pamia. Kun tau nainti nain ya monangwo hobi kul airing ne monangwo pisolere, taniga u nin bangi nangwo i, wa dunamia. ");
INSERT INTO sll_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wa du i pire, i tibi ole, gun ere, au sire, i malgi pire, arin tau gala dire yu ditenamia, ");
INSERT INTO sll_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","‘Na kun sipi sipi u tibi albe ongwo wa dugarai i tibi olia, gun enamna wo,’ dinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yu ongwo meri iwe, ari miki weni nainti nain ha maing wine ole monangwo hobi hamen bani God hanere gun enamba, te yal taniga tal nigi dongwo onangwo yal iwe, aidole nomani si kulu sire, hon olkirala di pinangwo i, God hanere, gun bir weni e tenamua. ");
INSERT INTO sll_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ena al ta moni ten toea ana holo holo a nenamia. A nenangwiwe, taniga hobo kul yanamia. Yanangwo aidolam mo? I ta aidolekinamia. Oo kepangwo ala i boni kri si maini ole kewa gale wa dunamua. ");
INSERT INTO sll_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wa du i pire i tibi olere, arin tau gala dinangwo, u ku bonangwo, yu ditenamia, Na moni ten toea yangwo irai i tibi ole wai piminia, gun enamna wo.” ");
INSERT INTO sll_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Direre yu ditongwi, “Hamen bani ensel hobi yal ta tal nigi dongwo ol wangwo i aidole nomani si kulu sire hon olkirala di pungwo i hanere wai pire gun emua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisas ha ta hon ainere yu ditongwi, “Yal ta wang sutani monamia. ");
INSERT INTO sll_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Monangure wang emgi irang ditere yu dinamia, ‘Nabe, ni moni talhan a nenga hobi ebir sire, na inama di pinanga tali nan na tenanba?’ Dinangure irang i ebir sire wang suri tenamia. ");
INSERT INTO sll_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tenangure wang emgi talhan hobi i pire moni bol ire, ere pi milin ta ke panamia. Ke pai molere, moni isusu ole ne wai sinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sirere talhan a nenangwo hobi para moni bol ire, ere ne wai sinamia. Sinangure yali monangwo ganba i menan bir u tibi namia. Nangure yal i han holo holo olamba, talhan ta gaung bani dikinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dikinangure yali wa i pire, ganba hong yal ta honagi ol tenamia. Ol tenangure yal i kun kule kene ol monana po ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ena yal i kene ol mole kun heba nenama dire tenangwiwe, yal i ire mena pire, i ta negere miina onama di pire, ari na ham mo, hankimo, dire monamia. ");
INSERT INTO sll_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mol i pirere, nomani si kulu si pinamia. ‘O, na nabe honagi ari hobi homena wai dungwo nere momiraba, na timiya mole menan gole, yona sibil dinangwo golalga pai dimia, nabe monangwo nalgarawa’ di pinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pire yu diteralia, ‘Nabe, ni God kina maun bani tal nigi dongwo olia. ");
INSERT INTO sll_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Omaga ni na wanaye dikio. Ni honagi ari mongwo meri molere, honagi ol ni teralgarawa.’ ");
INSERT INTO sll_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yu di pirere, pi irang monangwo bani nala dire namua. Pi ulubi ire monangure, irang hanamua. Hanere, ayo, na wana weni umia dire, miling gul sinangure, muma pire kule tol bai inamia. ");
INSERT INTO sll_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Inangure wang i yu ditenamia, ‘Nabe ni God kina maun bani tal nigi dongwo olia, ni na wana momua dikio.’ ");
INSERT INTO sll_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dinamba, irang iwe, honagi ari hobi di ku bolere, yu ditenamia, ‘Na gal wai egarai i ure pir tenana po. Ana digi wai egarai i ure wa to. Te kebena daing wai egarai sigiu di to. ");
INSERT INTO sll_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kun bulamahau bir weni irai i ure si keyo. Nan nere wai pire gun enaminua. ");
INSERT INTO sll_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Talongwo gun enamne? Yal i hamen haya goma di piriga irai, hon mole ere ungwo pamio, te u banta oma di piriga irai, hon ere ungwo pamia. Nan gun ere wai pire tenaminue.’ Dire homena ne monamia. ");
INSERT INTO sll_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Monamba, wang homini i honagi ol ware unamia. U malgi ure ta sire egin inangwo pinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pirere honagi yal ta gala dire sirin bole, yalhobi talongwo ome? dinamia. ");
INSERT INTO sll_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dinangure yal i yu ditenamia, ‘ni ebin irai ungure, nabin i miling bole wai pire, kun bulamahau bir irai sire, homena ke nere gun ere mominua,’ ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ditenangure, wang homini yong ki bir ere oo ala horala dipinamia. Dipinamba, irang i u maini ure, ha ura pangwo dire, ala womo, ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dinamba, wang i yu ditenamia, ‘Na me erin miki ni honagi ol ni te moliwa. Gin ta ni gran si olekiwa. Si olekiba, ni kun meme giri migima ta na tenanga na ire si kere gamnahobi kina wai pirio? Weni ta pirikiwa. ");
INSERT INTO sll_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pirikiba, wani iwe, talhan hobi irai para weni i pire, pasendia al tau te wai sire, hon ere memini umia, ni hanere, kun bulamahau bir weni irai si ke tenua.’ ");
INSERT INTO sll_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dinamba, irang yu ditenamia, ‘Gir waiye, nan yasu ereho tani molere, homena tani nere, pana wai gale mobilua. Te talhan ega hobi iwe, ni talni dimua. ");
INSERT INTO sll_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dimba, ebin iwe, hamen haya goli oma di pire momingarai, ya momio, te banta oma di pire momingarai, ere memini umia, nan wai pire, gun ere, homena si gal tominga i, wai pamua di pirikino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ena Yisas grang wine ongwo hobi yu ditongwi, “Moni bona gana a nenangwo yal ta molere, honagi ari ta haang e tere, ‘na talhan a nega hobi kene ol molo,’ ditenangure, ol monamia. Ol monamba, yal tau bona gana hong yal ure yu ditenamia, ‘Ni bona gana kene ol mongwo yal irawe, talhan hobi irai para isusu olemua,’ ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ditenangure bona gana hong yal i kene ongwo yal gala dire yu ditenamia, ‘Ni bona gana isusu olena dungwo i talongwo olene? Bona gana te mena ole tobo inga i, i tibi olingere, kunung benam mo, hanaminua. Ni honagi onga paikimia, ere nanga pamua.’ ");
INSERT INTO sll_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dungure honagi ongwo yal i yu nomani si pinamia, ‘Tal olale? Na honagi olga irai ere po di na tenangwo pamia. Na nimni mole homaulung honagi ganba ta gula dikiralia. Yal ta moni hong diralga gai golia. ");
INSERT INTO sll_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bona gana hong yal i ere po di na tenangwo, ere pi yal ta oo kepangwo ala molalga irai, molere pana gal molalia.’ Tal yu olala dire nomani si pinamia. ");
INSERT INTO sll_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pirere yal tau dinau ol tenangwo hobi gala di ku bonamia. Bonangure yal ta homa u pa dinangwo yu ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Ni bona gana hong yal dina talmere tene?’ Dinangure yu dinamia, ‘Kerosin daram handret ta muru teiwa’. Dinangure kene ongwo yal i yu ditenamia, ‘Ni dina tenga buku ire ami di mole, pipt kli si olingere, pipti obil ya dinamua.’ ");
INSERT INTO sll_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yal ta u pa dinangure, kene ongwo yal i yu ditenamia, ‘Ni dina talmere tene?’ Dinangure yal i yu ditenamia, ‘Paba miling gal handret gire teiwa,’ dinamia. Dinangure kene ongwo yal i yu ditenamia, ‘Pepa ire twenti pisolere, et pela ten obil bol eyo,’ ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ena emgi bona gana hong yal u pa dire tal ongwo i hanere, wai pir tere, honagi yal i ‘ni tal onga na ure hanega nomani wai panua.’ Ganba ari hobi ganba bani bona gana honagi nega dire omba, te hamen bani nangwiwe, hamen hol honagi nega dire olkimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ena Yisas ha ainere yu ditongwi, “Ganba baniya moni tobo a monangiwe, ebir sire awai honagi olere, ari tau tenania. Te wai sinangere, hamen bani mol pai gobari irere, God kina pana gananua. ");
INSERT INTO sll_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ena yal ta talhan wainta weniga kene wai ol monangwiwe, oli pirere, tal bir para kene wai onangwo pamia. Te, yal ta talhan migiga kene wai olkinangwiwe, oli pire emgi tal bir para kene wai olkinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ganba baniya moni tobo a nenanga i, ebir sire awai honagi olkinanga, hamen bani tobo ara ni tenangwo inane? ");
INSERT INTO sll_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ni yalhobi, yal ta taling kene ol molo di ni tenangwo, kene ol molkinanga, ni nin talni ara ni tename? ");
INSERT INTO sll_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ena ari singaba sutani honagi yal taniga molere, honagi ol tenangwo, wai panam mo paikiname? Singaba ta i nigi de pir tere, ta i wai pir tenamua. Te singaba ta honagi gogo ol tere, ta honagi wai ol tenamua. God pir tere, moni tobo pir tere, dinanga, para panam mo? I ta paikinamia. God taniga pir tenanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ena yu dimia Perisi yalhobi pirere, tobo moni pir tomia. Tere Yisas ha dungwo bani aling diri bole wa gol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tomba Yisas Perisi hobi yu ditongwi, “Ni yalhobi tal wai olgere, ari na hanama hanama di pire onanba, yon sina ali wai dim mo? I ta dikimia, God nin hamia. Ganba ari hobi talhan para weni nomani tere a yuwo ole yu wananba, God hanere, talhan i para ere yu a yuwo olam mo? I ta olekinamua. ");
INSERT INTO sll_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ena yal Moses krehaman ha ire, God hana togu yalhobi ha mining bol engwo i ire dire, wine ole pai ongwo ongwo, nir bil tongwo Yal Yon u tibi ongwo gin iwe, para yu pai omua. Ongure omaga God kene ongwo hol iwe, ha maing u tibi pire pai omua. Pai ongure arihobi para weni ha maing pire nega dire hol i doling bolala dire yulang bomua. ");
INSERT INTO sll_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bomba, hamen ganba iwe, wai sinangwo pamiba, God Lo krehaman ha mining obil weni taga wai ta sikinamua. ");
INSERT INTO sll_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ena yal ta eumbi ere po ditere al ta hon inangwo iwe, yal i al hon inangwo i wou sinamua. Te airing ere po ditenangwo i, pi aring giri oo monangure, yal ta hon pi inangwiwe, al i wou sinamua. ");
INSERT INTO sll_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ena hongebe moni bir pai tongwo yal ta gal wai weni pirere, galsina nol wai dungwo ware, hamen haung haung hau homena wai dungwo nere nere momia. ");
INSERT INTO sll_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mongwo oo kepangwo mala iwe, yal kultaing talhan a nekungwo ta momia. Yal iwe, haang Lasaras gaung bane bani iwe, nebona domia. ");
INSERT INTO sll_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ena yal i moni bir pai tongwo yal i oo kepangwo hona grang ami di mole, homena keuru boi di yangwo nere nere momia. Mongure awi ure gaung nebona dongwo bani dol bole bole omia. ");
INSERT INTO sll_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ena yal bina i gomia. Gongure kwia ensel hobi ure aule ire pire, kwiang moya Ebraham kina si daule engure, hamen homena wai ne momia. Ena emgi moni bir pai tongwo yal i ere para gomia. Gongure man wu emia. ");
INSERT INTO sll_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Engure ari yulagi engwo gul molere, gul bir imia. Ire han yuwo olimba, Ebraham ulubi weni mongure, Lasaras kina ereho si daule momia. ");
INSERT INTO sll_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mongure moni bir pai tongwo yal i gala dire yu dimia, ‘Nabe Ebraham, ni milna pir na tenanga, Lasaras nu si olingere, ure aling miling taniga nir sulere, grabina bani anangwo ura dinangwo piralba? Endo bir de pangwo bani molere gul bir iwa.’ ");
INSERT INTO sll_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dimba Ebraham yu ditomia, ‘Wanaye, ni nomani si piro. Homa irawe, kwian gaun kina ereho moniraya, mole tal wai dungwo iniraya, te Lasaras tal nigi dongwo imirawa. Imiraba, omaga yal i yong miling horega ongwo wai pire mongure, ni gul bir inua. ");
INSERT INTO sll_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te ta yu pamia. Nan mominga sina iwe, hogal bir dimia, na ni monga bani unaminba, hol ta dikimia. Te ni ere na mominga baniya unanba, hol ta ere dikimua.’ ");
INSERT INTO sll_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dungure moni bir pai tongwo yal i yu dimia, ‘Ayo, nabe, Lasaras bai nu si olangere, na nabe oo ke pangwo malgi namia. ");
INSERT INTO sll_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pire ebina ana hol bani muru momia awa ha ditenamba? Yalhobi gogo ta wa i unangwo na molga bani ure gul iname.’ ");
INSERT INTO sll_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dungure Ebraham yu ditomia, ‘Ni ebin hobi Moses krehaman ha ya, te God hana togu yal ha di engwo iwe, wine onangwo pamua.’ ");
INSERT INTO sll_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dungure moni bir pai tongwo yal i yu ditomia, ‘A, nabe Ebraham, i dinga paikimia. Gongwo yalhobi hon airere, ere pi ebina hobi mongwo bani nangure, tal nigi dongwo ol wangwo aidole, nomani si kulu sire, hon olkirala di piname.’ ");
INSERT INTO sll_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dimba, Ebraham yu ditomia, ‘Yalhobi Moses te hana togu yalhobi grang si ime olungwiwe, golere hon airangwo krehaman ha wine onam mo? I ta olkinangwo pamua,’” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ena Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi monga sina i yal ta kraun sire yon wu binangwiwe, bol yare, wine olere, tal nigi dongwo onangere, God pring ni tenangwo inanga pamua. Eke, kraun sire yon wu binangwo yal iwe, miling pirie. ");
INSERT INTO sll_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pring bir weni inangwo pamia. Pangwo ipire yali nin kwahulu bir weni ta nugung bani han hol erere, u di nir man ala pirere, gonangwo i, kulang panamba, God tal ol tenangwo i, tal oun weni dongwo ol tenamua. ");
INSERT INTO sll_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ena ni yalhobi yal ta kraun sire yon wu binangure, bol yare tal nigi dongwo onania, nin kene ole tal nigi dongwo olkirala dire molio. “Ena enin ta tal nigi dongwo onangwiwe, mana dire hobang si tenanua. Si tenangere, nomani si kulu sire tal nigi dongwo olga nigi domia hon olkiralua dinangwo, ha ta paikimua dire, han uning si olo. ");
INSERT INTO sll_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Enin ta gin ana hol pai muru hol pai sutani tal nigi dongwo ol ni tenangwo yali, ure, na tal nigi dongwo olgarai, nigi de pire hon nomani si kulu siwa, dinangwo, pring panangwo i kri di ole to,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ena aposel hobi Yisas yu ditongwi, “Na yalhobi wine ole pir ni tenaminba, nimni molkiminia, ni yulan na tenanue.” ");
INSERT INTO sll_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dimba Yisas yu ditongwi, “Ni yalhobi er miling wainta weniga dungwo meri obil pir na tenan mo? Tenanga er malbere i, nin dulung bolo gula di yare nir digan sina i hon bonanua, ditenanga meri wine ole bonamua. ");
INSERT INTO sll_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ena ni yalhobi monga sina i yal ta honagi ol ni tere, tobo ikungwo yal ta mole, homena ya nenga sina ganba gula dinangwo mo, kun sipi sipi kene ol wanangwo mo, ware, ginangwo ere malgi unamia. Unangure ni hanere ni homena haya no ditenan mo? I ta ditekinania. ");
INSERT INTO sll_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Homa na homena kere awai ol na tengere neralga, emgi ni nin homena ke nenanga pamua ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ke tenangwo i, nerala dire ni onga wai piriwa dire ma e tenan mo? I ta tekinania. Honagi ari iwe, honagi ongwo singaba han gogo dal tongwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Honagi ole tobo ikungwo hobi ongwo tali onanua. God ha di ni tenangwo wine olere yu dinania, na yalhobi honagi ari digan mominia, talhan na yalhobi ominga iwe, na nan hana pangwo ominua dio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ena Yisas Yerusalem nala dire ere pi Sameria holo dungure, Galili holo dungure, sina weni ongwi. ");
INSERT INTO sll_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pirere oo malgi pi pa dungwi. Pa dungure hakubi dongwo yal ana holo holo ure Yisas kina u guma engwi. ");
INSERT INTO sll_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ere ulubi mole gala bir dire yu ditongwi, “Yisas ye, ni na yalhobi milna pir na tenanga awai ol na tenanba?” ");
INSERT INTO sll_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dungure Yisas yalhobi hanere yu ditongwi, “Ni yalhobi ha maing oo singaba monangwo pire gaun i nibil di tenana po.” Dungure yalhobi ere pirere gaung wigi sungure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ena yalhobi ongwo sina i yal taniga tima pire nin gaung bani naa ire hamba, gaung wai dungwo hangwi. Hanere siina di Yisas mongwo bani pire erakere yu dungwi, “Na God ol na tongwo i wai piriwa.” ");
INSERT INTO sll_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dire ikwi bole Yisas kebering kule gun e tongwi. Tongwo yal iwe, yol Sameria yal mongwi. ");
INSERT INTO sll_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mongure Yisas tal ongwo i hanere yu ditongwi, “Na ari ana holo holo para u wai ona di piriwa. Di piria ni tani unba, ari ana hol pai muru hol pai sui sui dire makena mome? ");
INSERT INTO sll_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Monangwo hobi para ure God gun e tere maa e tekungwo yawe. Wiyol yal taniga maa e tomia hano.” ");
INSERT INTO sll_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dire Yisas Sameria yal i yu ditongwi, “Ni na onangwo pamia di pir na tengiwe, nibil i wai simia. Aire ere malgi po,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ena Perisi yal tau Yisas yu sirin bol tongwi, “God kene ol na tenangwo tal haung u tibi uname?” Dungure Yisas yu ditongwi, “God kene ongwo hol u tibi ongwiwe, ari yal al para weni omin ta hankinanua. ");
INSERT INTO sll_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","God kene ongwo hol timi u tibi omua, timiya u tibi omua dinamba, omeling hankinamua. God kene ongwiwe, ari monga nomani sina i omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dire Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi moli pire, Ari Wang Weni na u tibi egere, na han pa diralua di pinanba, gogo ta na hankinania. ");
INSERT INTO sll_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Habang ta ari tau na pire yu di ni tenamia, u timi momua, u timiya momua dinangworai, pir tere pi hankio. ");
INSERT INTO sll_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ari Wang Weni na kul sire ta u pa dikiralua. Hamen yong anigi bina holo holo au di poira sungwo meri, na u tibi uralga, ere yu onamua. ");
INSERT INTO sll_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na moli pire ganba hong arihobi na pisole mobing hal wa na tenangure, gul honagi bir olalia, emgi u tibi uralua. ");
INSERT INTO sll_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Homa yal Noa mongwo haung ari hobi tal ongwo meri iwe, Ari Wang Weni na siina diralga haung u mala nangure ere para yu onamua. ");
INSERT INTO sll_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Arihobi hau homena nere, nir nere, al te iri ya ole ire momua. Uning sire mongure, Noa iri si sipi ala ongure, nir bir weni sire, si terewa sire, ari para weni si gol wai simua. ");
INSERT INTO sll_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Te Ebraham ebering wang Lot mongwo gin i ere para yu omua. Yal hobi hau homena soo wa ma di nere, tal te ire ya ole, honagi ol yamua. Yare oo kere dimua. ");
INSERT INTO sll_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yu ol mongure, yal Lot Sodom malgi aidole ere ongure, hamen bani endo, te hulu de wa gongwo, nimin yangwo meri ya ime ure, oo ai te arihobi para de wai simia. ");
INSERT INTO sll_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ena sungwo meri iwe, Na Ari Wang Weni molere siina di u tibi uralga gin i, ere para yu onamua. ");
INSERT INTO sll_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“U tibi uralga gin iwe, yal ta oo airing bani molere, iri si ala pire bona gana ire nala di pirikio. Yal ta homena sina wa molere, hon inaa di malgi nala di pirikio. ");
INSERT INTO sll_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot eumbi siina dire pire gongwiwe, ha i pinia. ");
INSERT INTO sll_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ena yal ta nin nin gaung pir tere monangwo yal iwe, emgi u talwo nangwo pamua. Te yal ta nin gaung pir tekirere gonangwo yal iwe, emgi sigare kule kwiang mol pai gobari inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na u tibi uralga gin iwe, yal sutani ul tani pai monangure, God yal ta ire, ta aidolamua. ");
INSERT INTO sll_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te agr sutani heba ke monangure, God hanere al ta ire, ta aidolamua. ");
INSERT INTO sll_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yagr sutani homena sina wa monangure, God hanere yal ta ire, ta aidolamua.” ");
INSERT INTO sll_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dungure grang wine ongwo hobi ha i pirere, yu sirin bol tongwi, “Yal Yisas ye, tal ha dinga hobi makena u tibi name?” Dimba Yisas ha mong di tekima obil yu ditongwi, “Ari golere yone pare monangwo bani hau sipia mubil hama hane mu sungwo meri iwe, sire gintani ne monangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ena Yisas grang wine ongwo yal ta God sirin bol tenangure, God ha pring ditekinangure, pisolekire, oine holgi di monama dire ha di bole yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ena oo malgi ta yas ha hol pungwo yal i ke pare monamia. Monangwo yal iwe, God ari para kulung pir tekinamua. ");
INSERT INTO sll_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tekinangure oo malgi i agr ta wiimbi gonangure, al werai mole haung haung yas mongwo bani u giu giu dire, ‘Na kiana tal gogo ol na tongwo hobi ha hol ol wai ol na tenanba’, ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ditenangure, yas iwe, al werai i gobari weni pir tekinamia. ");
INSERT INTO sll_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tekinamba, na God ari para kulung pirikiba, al werai i gai golkirere, u giu giu di mongwo tali monangwo, nigi di piralga pamia dire, nomani si kulu sire, ha hol ol wai ol tenamua.” ");
INSERT INTO sll_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yu dire yal Yisas yu ditongwi, “Ni yalhobi yas digan ha dire tal ongwo i nomani si piro. ");
INSERT INTO sll_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ena God ari nu ke tongwo hobi girungwo tangwo, aki di na to dire u giu giu di monangere, God ni han uning si olamo? I ta olekinamia. ");
INSERT INTO sll_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gintani ha hol ol wai ol ni tere aki di ni tenangwo pamua. Aki di ni tenangwo gin iwe, Ari Wang Weni na uralga pamia. Pamiba, ari tau na grana wine ole monam mo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ena ari tau na nan wai weni molia ari para weni digan momua dire, guma igere bol tenama dire, Yisas ha di bole ditongwi, “Yal sutani ha maing oo bir weni God ha diterala dire pi monamia. ");
INSERT INTO sll_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Monangwo ya suri iwe, ta Perisi monangure, ta moni takisi ingwo yal monamia. ");
INSERT INTO sll_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ena Perisi yal iwe, homa nin bangi aire molere, ‘O God, na ari wo ta molkiwa. Yalhobi iwe, kela kule yal ta taling tol dire, Lo krehaman ha isusu ol tere, al wou sire ol wamia. Na yalhobi ongwo meri ta olkiwa. Te moni takis ingwo yal i ongwo meri ereyu ta olkiwa. ");
INSERT INTO sll_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sare tan tani hamen haung sutani ni pir ni tere homena mai tere tere moliwa. Te tobo ana holo holo igiwe, taniga ni moni ni tere tere moliwa.’ ");
INSERT INTO sll_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yu dinamba, takis ingwo yal iwe, ulubi mole, gai gole, ikwi bole, yu ditenamia, ‘O God, na digan mole tal nigi dongwo ol waga ni pring bir weni na tenia milna pir na to,’ dinamia. ");
INSERT INTO sll_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Dinamba, na di ni teralga piro. Moni takisi ingwo yal iwe, God hanere, o, na miling pire ol wai ol tegere, yal i na kina gumana pule irabilga pamia, digan momba, tal dime dire ol wama di hangure, ere malgi omua. Te Perisi nin gaung di yuwo engwo yal iwe, God, o, yal i na kina guma pule ikiralga pamia di hanamua. Ena yal ta nin di yuwo ere na singaba moliwa, te hamil ha siga yal moliwa, dire wa monangwiwe, haang ya ime sinamua. Te yal ta nin gaung di yuwo eikire, digan yal bina moliwa, di pire aunabo nure wa monangwo yal iwe, ari tibi monamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ena dungwo gin iwe, gir migi tau Yisas breng bani anama dire aule ire ungwi. Umba, grang wine ongwo hobi hanere hobang si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Si tomba, Yisas gir migi hobi di ku bole yu ditongwi, “Gir migima hobi na molga bani unamia, hobang si tekio. Gir iwe, God kene ongwo hol i wamia. ");
INSERT INTO sll_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ni ari hobi yu warala di pinanga, gir migi nomani pangwo meri yu paikinanga, para yu wakirere, te God kene ongwo sina honanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ena Yudari singaba ta u pa dire Yisas yu sirin bol tongwi, “Tisa yal wai ye, na tal mere olgere God kwiana mol pai gobari na tename?” ");
INSERT INTO sll_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dimba Yisas yu ditongwi, “Ni talongwo na yal wai ye di na tene? God tani yal wai momia. ");
INSERT INTO sll_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ni Lo krehaman ha para pinua. Wou sikio. Ari si golkio. Kuni nekio. Hasu ditekio. Nimai nabin aki di tere grang wine olo.” ");
INSERT INTO sll_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dimba, singaba i yu ditongwi, “Na gir migi molga ali wine oli uga uga, omaga ari moliwa.” ");
INSERT INTO sll_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dungure Yisas ha i pirere yu ditongwi, “Onga i para onba, tal taniga onangiwe, moli nanga yo tenamua. Talhan miki weni a nenga i, ari te mena olere, moni inangarai, ebir sire, talhan a nekinangwo hobi tenana po. Yu onangere ni tobo wai hamen bani dinamua. Yu ol pisolere, na guna hana pire na dolna bolo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ditomia yal i bona gana miki weni a neiraya, tal olale di pire guman digan hole mongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mongure Yisas hanere arihobi yu ditongwi, “Yal ta bona gana miki weni a nenangwo yal iwe, God kene ongwo hol i nangwo kulang panamo? I ta paikinama. ");
INSERT INTO sll_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kun hausi hai bun kiaing kuun engwo ala i, nangwo oun domba, te bona gana miki weni a nenangwo yal iwe, God kene ongwo hol i nangwo oun go domua.” ");
INSERT INTO sll_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dungure arihobi pire Yisas yu sirin bol tongwi, “Yal ara nimni mole sigare kule mol pai gobari iname?” ");
INSERT INTO sll_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dungure Yisas yu ditongwi, “Ari nin inangwo kunung ta paikinamia. God nin tenangwo kunung bemua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ena yal Pita Yisas yu ditongwi, “Hano. Na yalhobi oona aibina para pisolere, ni ni dolni bomingiwe.” ");
INSERT INTO sll_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dungure Yisas yu ditongwi, “Owa, ha pangwo dinia. Yal ta God kene ongwo ha maing hol i nomani si pir tere, oo ai ya, eumbi ya, ebiring ya, irang aang ya, gir kul nongwo ya, pisolere, nangwiwe, omaga malungwo haung, God mong pring hon siina di tenangure, miki weni inangwo kunung benamua. ");
INSERT INTO sll_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Te habang kul enangwo gin i, mol pai gobari inamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ena Yisas grang wine ongwo ari ana holo holo kebena sutani aule ire nin bangi pire yu ditongwi, “Pino. Nan omaga mo Yerusalem namna dire uminia. Pi pa dinamingere, God hana togu yal awa ha homa di engwo irai, Ari Wang Weni na u tibi wiya, nima namua. ");
INSERT INTO sll_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ari hobi na aule ire pire wiyol ta na tenamia. Tenangure, gauna ha sire, ol gogo dal na tere, ebil si na tenamua. ");
INSERT INTO sll_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Terere, homa kuba na sire, na sigonamua. Golere, ari habang sui tai dire pai molere, emgi hon airalua.” ");
INSERT INTO sll_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ditomba yalhobi pir po sikungwi. Ha iwe, memini kul si pamia, Yisas ha dungwo hobi para ogolo pir pa dikungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ena Yisas Yeriko malgi u pa dungwi. Pa dungure omeling gi dungwo yal ta homaulung ami di molere, ari iriyala tongwo i, moni na to dire hong di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mongure ari miki weni umua dungwo pire, “Ari hobi talongwo ume?” dire sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nasaret hong yal Yisas u omua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","“Yisas, singaba Debit gang ye, ni milna pir na tomo,” dire gala dungwi. ");
INSERT INTO sll_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dimba ari homa engwo hobi kura ha ditere, “Sime molo” ditongwi. Dimba yal i gala bir dire, “Debit gang ye, ni milna pir na tenanbao.” ");
INSERT INTO sll_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dungure Yisas u aire molere, “Aule ire na molga baniya wo,” ditongwi. Ditongure u mala ungure, Yisas yal i yu sirin bol tongwi, ");
INSERT INTO sll_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na ni tal ol ni teralga pire di na tene?” dungwi. “Yal Yisas ye, na omena gi dungwo i a pila di na tenana di pire diwa,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Ni na onangwo pamia di pingiwe, omin i pila dinangure u wai nanua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ditongure gintani omeling a pila dungure u wai ongwi. Pirere Yisas doling bol pirere, God maa e tere tere ongwi. Ena ari hobi Yisas tal ongwo i hanere, God maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ena Yisas Yeriko malgi wangwi. Wangure takisi ingwo hobi kene ongwo yal ta haang Sakias mongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Molere talhan miki weni a nongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ena yal i Yisas gumang hanamba, ari miki weni yobile mongure, yali koptani momia, i dui dire harala dire ol wamba, weniga hankungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hankire, yong ere momia, bli si homa pire er bane ta mo pire, Yisas wiyala nangwo haralua dipire han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Han mongure yal i mongwo bani Yisas ari hobi kina ongwi. Ongure pi Sakias mongwo dimani pa dire Yisas han yuwo ole, “Sakias ni manbi wo. Kenba na ni oo ke panga ala monaminua.” ");
INSERT INTO sll_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ditongure Sakias gintani manbi ure yong miling horega ongure, Yisas aule ire oo kepangwo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ongure arihobi hanere, “Ayo, tal nigi dongwo ongwo yal i kina pana gal momia, talongwo mome?” dire nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ena Sakias aire mole yu ditongwi, “Yal Yisas ye, ni piro. Omaga na talhan a nega hobi iwe, sina weni sikira dire ebir sire, ari talhan a nekungwo hobi tau teralua. Te na yal ta taling kuni negiwe, pring tal sui sui dire te aibing olalua.” ");
INSERT INTO sll_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dungure Yisas yu ditongwi, “Omaga iwe, ni arini hobi God kina mol pai onua. ");
INSERT INTO sll_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni Ebraham gang weni monua. Ena na Ari Wang Weni mole uga iwe, ari u tibi albe pire, yone pai mongwo hobi, si hon e tegere, sigare kule u wai nama dire wiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ena Yisas Yerusalem malgi mala ongure, ari Yisas haang pungwo hobi yu dipungwi, “Mala i God ari kene ongwo hol u tibi nama” di pire haung u mala omia pungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pimba Yisas ari hobi yu ditongwi, “Ari singaba ta, ari singaba bir weni mongwo bani pire digere, ganba kene ol na tenangure, na pi milin ta mole emgi siina dirala dire namia. ");
INSERT INTO sll_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nala dire honagi ari ana holo holo di aulere, moni tobo twenti kina twenti kina tere yu ditenamia, ‘Ni yalhobi moni i ire pire honagi ongere, mena mena i sina tai sire pai i nangure na siina dire uralua.’ ");
INSERT INTO sll_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ditere nangure arihobi tole wa tere i bolimbani ol tongwo ipire yal ta nu sungure, emgi pi pa dire singaba bir weni yu ditenamia, ‘Singaba i na ganbana kene ol molkinama di piriwa.’ ");
INSERT INTO sll_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ena singaba bir weni ganba ta kene ol te mole hon siina dinamia. Siina dire honagi ari tobo moni tongwo hobi di ku bolere, yu ditenamia, ‘Moni tegarai, ni yalhobi honagi onga sini sire pai i om mo paikime?’ ");
INSERT INTO sll_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Di aulungwo honagi yal ta homa u pa dire yu ditenamia, ‘Yahuno ni moni twenti kina na tengarai na hon honagi oli oga tu handret kina u tibi omua.’ ");
INSERT INTO sll_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dinangure singaba yu ditenamia, ‘Tal wai onia. Ni honagi ari wai monia. Ni talwo i honagi awai ole onga i pire na oo tabil ana holo holo ni tegere kene ol monanua.’ ");
INSERT INTO sll_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Honagi yal ta u pa dire yu ditenamia, ‘Yahuno, ni moni twenti kina na tengarai na hon honagi oli oga propet wan handret kina u tibi omua.’ ");
INSERT INTO sll_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dinangure singaba yu ditenamia, ‘O para onga wai pamia. Ni oo tabil ana hol pai muru kene ol monanua,’ ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ena honagi yal ta emgi u pa dire singaba yu ditenamia, ‘Yahuno, ni twenti kina na tengarai na gal yobilere, i kul si ega ya dimua. ");
INSERT INTO sll_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ni ari nigi denga monia kulni piriwa. Ni nin tal ta a nekire, ari tau a nongwo hobi tol dirala dire dinua. Ni nin honagi ta ol ya nekire, ari tau ol yangwo miling u tibi ongwo i nerala dire dinua.’ ");
INSERT INTO sll_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dungure singaba honagi ari yu ditenamia, ‘Ni honagi ari digan monia. Ni nin ha dinga meri, na ha pring di ni teralia. Na yal nigi dega molga han dinia. Na nan tal a nekire, yal ta taling tol di iga han dinia. Te na nan homena ol ya nekirere, ari tau ol yangwo nega han dingiwe, para dinia. ");
INSERT INTO sll_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ni iwe, talongure moni to mama hol ere mone? A siribi sire ari mongwo bani engere sina tai sire pai mena mena i nangure na ure iralga pamba.’ ");
INSERT INTO sll_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yu dire ari mongwo hobi yu ditenamia, ‘Ni yalhobi moni a nongwo i, a tol di ire tu handret kina a nongwo yal i to,’ ditenamia. ");
INSERT INTO sll_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ditenamba, yalhobi yu ditenamia, ‘A, Yahuno, yali tu handret kina haya para anongwiwe,’ ");
INSERT INTO sll_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dinangure singaba yu ditenamia, ‘Na di ni teralga piro. Yal ta tal tegere kene ole i wanangwiwe, hon aine teralga pamia. Te yal ta tal tegere kene ole i wakinangwiwe, homa teralga i wanangwo tal i nan tol di iralga pamua. ");
INSERT INTO sll_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na kiana hobi singaba ta molkiralga pamia dire dinamia, ni aule ire ure sire isusu olio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ena Yisas ha di pisolere, Yerusalem nala dire homa engwi. ");
INSERT INTO sll_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Erere ere Betpasi, Betani malgi hamen hul Olibi u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","U pa dire Yisas grang wine ongwo ya sutani bai nu si olere yu ditongwi, “Oo malgi yuwo hane. Malgi i pirere hananba, kun donki giri yal kun ta han hol enangure monangwo hanania. ");
INSERT INTO sll_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hanangiwe, yal tau au si wakimia, han i gule i unana po. I unanga, yal ta bani molere, ni ya su talongwo kun i han gule ire one? dire sirin bonangworai, yu ditenania, na yasu pi tege eminga yal kun i honagi ol terala dungure ire uminua, ditere wo.” ");
INSERT INTO sll_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ena yasuri pi pa dire hangure, Yisas ha ditongwo meri giu dire pangwi. ");
INSERT INTO sll_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ena yasuri kun han i gule mongure, kun hong yal ure yu ditongwi, “Ni yasu tal ongure kun yal kun i hani gule ire one?” ");
INSERT INTO sll_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dungure yasuri yu ditongwi, “Yal Yisas kun i honagi ol terala dungure gule ire ominua.” ");
INSERT INTO sll_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dire kun giring aule ire Yisas mongwo bani ongwi. Pirere nin galsina gule kun mobing bani ere Yisas aki dungure, kun mobing bani au sungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Au sungure ari tau gal gulere, homaulung i e ya ime ongwi. ");
INSERT INTO sll_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ongure Yisas Olibi hul mole aidole, ere ya ime pi Yerusalem nala dire ongwi. Ongure grang wine ongwo hobi miki weni molere, Yisas tal ongwo i hanere, yong miling horega ongure, God wai pir tere, maa e tere erakere dire yu dungwi, ");
INSERT INTO sll_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pi tege eminga yal iwe, God grang wine olere, u tibi pi na tomia, nan ari hobi wai piminia, God yal i kene ol to. God haang a yuwo ol tenaminue. God mongwo hamen bani iwe, kura paikire ura dinamue,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dimiawe, ari taporal mongwo sina i Perisi yal tau molere, Yisas yu ditongwi, “Tisao, ni gran wine ongwo hobi sime molo ditomo.” ");
INSERT INTO sll_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dimba Yisas yu ditongwi, “Yalhobi sime monangwiwe, kwahulu i ere yu gala dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ena Yisas ere u Yerusalem malgi mala ure hangwi. Hanere hai mengwi. ");
INSERT INTO sll_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mere yu dungwi, “Yerusalem hong yalhobo, tal ta onanga kura paikire ura dinamia, onanga meri ereyu ol monanba, pir po sikinua. ");
INSERT INTO sll_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ena haung ta u tibi unangwiwe, ari kiani mena holo holo i u ni yobilangure, ni sina i muru monanua. ");
INSERT INTO sll_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Monangere kiani hobi ure ni sire ol gogo dal ni tenamua. Tere oo para muru si galere, malgi isusu olangure, ni gol wai sinanua. God ni aki di ni tongwo haung pinanga pamba, pir po sikinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ena Yisas ere ha maing oo bir ala pire hamba, ari bisnisi honagi ol mongwo hanere, si doling i maini olungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Olere, yu ditongwi, “God ha mining ganing ta yu pamia. Na ha maing oo ala i arihobi na kina hawai ole ole olabilua. Yu pamiba, ni yalhobi oo ala i onga u kuni gobere omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ena hamen haung haung Yisas ha maing oo ala arihobi ha maing nir si tongwi. Te mongure ha maing oo singaba ire, Lo ha nir si tongwo hobi ire, Yudari kene ongwo hobi ire dire, Yisas si golala dire hol wa dungwi. ");
INSERT INTO sll_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dumba ari para weni Yisas ha dungwo hobi ogolo weni yole pir momia, si gonangwo hol ta i tibi olekima. ");
INSERT INTO sll_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ena haung ta Yisas Yudari ha maing oo ala ari hobi God tal ol na tongwo ha maing nir si te mongwi. Mongure ha maing oo singaba hobi ire, Lo ha nir si tongwo hobi ire, Yuda kene ongwo hobi ire dire, u Yisas mongwo bani pa dire yu sirin bol tongwi, “Ni ara yulang ni tongwo ire ure, tal maing maing one? ");
INSERT INTO sll_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ni tenangwo yal i haang dal na to.” ");
INSERT INTO sll_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dungure Yisas yu ditongwi, “Ni yalhobi sirin bol na tenia, na ha taniga sirin bol ni tenamna do. ");
INSERT INTO sll_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yal Yon nir bil tongwiwe, God yulang ire bil tom mo, ari yulang ire bil tome?” ");
INSERT INTO sll_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dimba yalhobi nin bolbin dire yu dungwi, “God yulang ire bil tomua dinaminba, Yon pir tekino, di na tenamia. ");
INSERT INTO sll_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te ari yulang ire bil tomua dinaminba, ari hobi Yon God hana togu yal weni kara mongwo pamua dire na sinamia. Talwa dinamne?” ");
INSERT INTO sll_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dire yalhobi Yisas yu ditongwi, “Yon nir bil tongwo iwe, yulang ingwo hol hankiminua.” Dungure Yisas yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“Hanki dingiwe, na yal ta yulang na tongwo ire honagi olga yal i, ere di tibi ol ni tekiralua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ena Yisas ha ta di bole arihobi yu ditongwi, “Yal ta ganba bir weni dinamia. Dinangure u sire grep hani kunamia. Kulere ganba i yal tau kene ol molo di te olere, hong yal i ere pi milin ta monamia. ");
INSERT INTO sll_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Molere, miling kul ema di pire, boi honagi yal tau wain niring diire enangwo tau inama dire nu si olamia. Olamba, ganba te ole nangwo yalhobi sirere, erepo ditenangure yamoni namia. ");
INSERT INTO sll_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yu onangure hong yal i boi honagi yal ta hon nu si olamia. Olamba, ganba te ole nangwo yalhobi sire, ol gogo dal terere, erepo, ditenangure yamoni namia. ");
INSERT INTO sll_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ti hon honagi yal ta nu si olangure u pa dinamba, ereyu ol gogo dal tere, pia si mena olamua. ");
INSERT INTO sll_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ena grep hani kungwo hong yal iwe, yu dinamia, Na tal olale? Na wana weni iwe, bai nu si olgere, yalhobi ha wai ditere han uning si olama di pinamua. ");
INSERT INTO sll_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pire nin wang bai nu si olamba, ganba te ole nangwo hobi mole yu dinamia, Ganba hong yal irai wang weni umia hano. Haniba, wang weni si gonaminga, ganba oo ai nan para muru inaminua, dinamia. ");
INSERT INTO sll_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yu dire wang i a pilu di mena pire si gonamua.” Dire Yisas yu ditongwi, “Si gonangure ganba hong yal ure, ganba te ole nangwo yalhobi tal ol tename? Han uning si olam mo? I ta olekinamia. ");
INSERT INTO sll_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ure si gol wai sire, oo ai ya, ganba i wiyol ta tenangwo pamua.” Dungure arihobi ha i pirere, ganulun dire yu dungwi, “Ayo, yu onam mo?” ");
INSERT INTO sll_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dungure Yisas teni han wabo dire yu ditongwi, “Ni yalhobi ha maing buku kere memini pin mo? Oo kengwo yalhobi torari ta ire ‘mebin damua’ dire pisolamia. Pisolangwo torari iwe, God nin aki di ire torari sinangure bring torari nima ongwo meri dinamua. ");
INSERT INTO sll_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ena yal ta torari i gore mena olala dire onamba, nona pare yal i gumang holi yanamua. Te torari yal ta biirangwiwe, yal i biire dal dinangure u susu pire ganba danamua.” ");
INSERT INTO sll_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ena Yisas ha di bole dungwo i, ha maing Lo tisa hobi, te ha maing singaba hobi yu nomani si pungwi, “O, na yalhobi di na tomia Yisas han honaminua,” di pungwi. Di pimba ari hobi kulung pirere, han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yisas tal gogo ta onangwo ha maing yal bir hobi ha di mere si terala dire, kwi han mongwi. Molere, yal tau Yisas mongwo bani pire, kela kule tenama dire yu ditongwi, “Yisas kraung singere bol yanangwo irai, moni tobo ni teralia po,” ditongwi. Ditere Yisas ha dinangwo bol yanangwo irai, aule ire gabman nambawan mongwo bani omingere ha hol ol tenamua, di pungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ena hasu kela kulala dungwo yalhobi u pa dire, Yisas yu ditongwi, “Tisao, ni ha pangwo meri kara dinga piminia. Direre te God mongwo maing ari para weni di ba bol na tenga piminia. Ni ha ta abiyame ere dikinia. Ari singaba te yal bina hobi para kulung pir tere ta dikinia. Ha kara aru dire diteniraya. ");
INSERT INTO sll_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ena God krehaman ha mining bongwo iwe, moni takis yol Rom singaba Sisa to, dim mo, tekio dime?” ");
INSERT INTO sll_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dimba, yalhobi kela kule dungwo i, Yisas haya han po sungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Sire yu ditongwi, “Moni takis olinga taniga i ya wo na hanamna. Moni piksa ya, te haang i ara haang dime?” ");
INSERT INTO sll_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dungure yalhobi Yisas yu ditongwi, “I ari singaba Sisa haang dimua,” dungwi. “O, para dinia. Sisa nin taling dinangwiwe, Sisa tenana po. Te God nin taling dinangwiwe, God tenanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ena Yisas ha yu ditongure yalhobi gai golere, han holkima. Ganulun dire nomani si gogo dale sime mongwi. ");
INSERT INTO sll_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ena gin ta Sadyusi yalhobi tau Yisas mongwo bani ungwi. Sadyusi yalhobi ha maing di tongwiwe, tere “Ari gongwo hobi hon ta airekinamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ena yalhobi, Yisas mongwo bani ure yu sirin bol tongwi, “Tisao, yal Moses krehaman ha yu mining bol e na tomiraya. Yal ta eumbi kina temine tere molere wiimbi gonamia. Gonangwo eumbi al werai, ebering ta gal enamia. Gal ere molere, al i na igere, gir kul enangwo, abinambi aibing maulung sinama di pinamua. Moses yu di embawe, na di ni tenamna piro. ");
INSERT INTO sll_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ena ebering hobo ana hol pai muru hol pai sutani momia. Abimbi homini iwe, al i kina moli pire temini tere gomia. ");
INSERT INTO sll_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gongure ebering iwe, hon gal emba, ereyu temini tere gomia. ");
INSERT INTO sll_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ebering hobi para weni yu gal emba, temini tere gomia. ");
INSERT INTO sll_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gongure emgi al i para gomia. ");
INSERT INTO sll_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Emgi ari gongwo hon airamua dingiwe, airangwo habang al i ara eumbi moname? Ebering hobi para weni gal engwiwe.” ");
INSERT INTO sll_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dimba Yisas yu ditongwi, “Omaga mominga habang iwe, ari yal al ire u tani ongere mominua. ");
INSERT INTO sll_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mominba, emgi ari gongwo airangure God mol pai gobari na tenangwo gin iwe, yal al ta hon molkinaminia. ");
INSERT INTO sll_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kwia ensel mongwo tali yu mole wanaminua. Ware hon ta golkinaminua. God ari yulagi engwo bani ulna yunangwo airaminga, aire God nin kul engwo weni monaminua. ");
INSERT INTO sll_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ena yal Moses ari gongwo hon airamua dire ha nir si tongwo gin iwe, tere er aulung bani endo dongwo hangwo i para di tibi olimia. Singaba God iwe, kwiana moya Ebraham ire, Aisak ire, Yekop ire dire, maa e tongwo yal momua. Ena yal God ari gongwo hobi hobang mole kene ol tom mo? Ta tekimia. ");
INSERT INTO sll_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ari hon mongwo hobi hobang mole kene ol tomua. Tongwo ipire kwiana moya Ebraham ire, Aisak ire, Yekop ire dire, kwiang hon momua.” ");
INSERT INTO sll_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yu dungure ha maing Lo tisa tau Yisas yu ditongwi, “Tisao, ni ha wai dinua.” ");
INSERT INTO sll_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dire hon sirin bol tenamba, Yisas kulung pungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ena Yisas ha hon ainere yu ditongwi, “Yasingaba Kraist mongwiwe, Debit gang momua, dinga i talongwo dine? ");
INSERT INTO sll_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Isrel ha maing ul geral buku Sam ala iwe, Debit nin ha yu bol emia, ");
INSERT INTO sll_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hamen yasingaba na grang wine ominga yali yu ditomia, “Ana weni holi ami di molo. Mongere kiana i unaminga doling i mena olanua,” dimia. ");
INSERT INTO sll_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Te Debit nin yal i ha dungwo doling bole a i si waiwa dimia, talongwo Debit gang momua, dine?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Ena ari hobi para ya molere, Yisas ha dungwo pir mongwi. Mongure Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi, Lo ana holo holo ha nir si tongwo hobi tal ol wangwo meri. Ol wakinanga pire kwi han molo. Yalhobi ari na hanama hanama dire gal wai dinangwo pire homaulung iriyala tenamia. Tere wa i ogere ari hobi homaulung kwaling na hanere, ‘Nebare, widinio’ di na tenama dire yu onamua. Te ha maing oo ala pire, bol guma bani ami di molgere, ari na hanama di pinamua. Te homena bir ke nere monangwo bani iwe, yalhobi ere iri si homa enangwo hananua. ");
INSERT INTO sll_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te ari gongwo eumbi al werai monangwo ala iwe, pire taling tol di ire bal tenamua. Te ari hobi maulung bani God ha diterala di monangwiwe, hasu ha miki weni di te monamua. Monamba, God ha hol bir ol na tenangwo gin iwe, yalhobi gaung gul bir weni inangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ena Yisas ha maing oo ala mole han wabo dire, ari tal miki weni a nongwo hobi ha maing honagi aki dungwo moni olungwo hangwi. ");
INSERT INTO sll_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Hamba, agr ta wiimbi gongwo al werai mole moni nol wan toea sutani olimia hangwi. ");
INSERT INTO sll_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hanere yu di tongwi, “Ni yalhobi pir molo. Al werai iwe, moni miki ta pai tekimia. Moni olungwo i, moni bir olimia. ");
INSERT INTO sll_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Te yal tau moni olungwo i, tau a bi ere obil olimia. Te al werai iwe, wiimbi gomiraya obilga pai tongwo meri kara ol pisolimia. Emgi homena bring si nenangwo moni ta dikimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ena ari hobi ha maing oo bir ala i ha di mole yu dungwi, “Ha maing oo i egin tere moni tobo God tominua.” ");
INSERT INTO sll_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Dimba Yisas yu ditongwi, “Ni yalhobi talhan omaga dungwo hangiwe, para hanba, emgi hon ta hankinanua. Hulu sigwi dire isusu olamua. Olangure hulu dungwo hanga bani hon ta dikinamua.” ");
INSERT INTO sll_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ena yu dungure ari hobi yu sirin bol tongwi, “Tisao, ha di na tenga i, tal habang u tibi name? Tal guma hon tal u tibi unangure ha dinga i hanamne?” ");
INSERT INTO sll_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dungure Yisas yu ditongwi, “Ni yalhobi han kun ole molio. Yal tau ure kela kul ni tenamia. Terere na hana dal yuwo ere yu di ni tenamia, ‘Ha di ni tongwo doling bole a i si wanga yal irai wiwa. Hamen haung omaga werigi dimua.’ ");
INSERT INTO sll_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dinangure ni yalhobi ha weni dima dire bol yakio. Emgi ni monga mala i kura u tibi namio, te ganba bantau kura bonamua. Yu onangwiwe, ni yalhobi ganulun dikio. Talhan hobi para u tibi namiba, ganba wai sinangwo haung u tibi ta olo hunamua. ");
INSERT INTO sll_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te ari wiyol ta pirere, wiyol ta kina kura bonamia. Yasingaba ta gamahobi pirere, yasingaba ta gamahobi kina kura bonamia. ");
INSERT INTO sll_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te maganba i ememe bir onamio, menan bir u tibi namio, nibil bir u tibi namio, hamen yulang ho tere tal guma hon dongwo maing maing u tibi namua. ");
INSERT INTO sll_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ena talhan hobi olo u tibi hunangure, ari ni aule ire pire ol gogo dal ni tenamua. Terere Yudari ha maing oo ala ha hol ol ni tere, ni si hani sinamua. Tal yu onangwiwe, na hana a ime olala di pire, ol ware ni aule ire pire, singaba king gabman mongwo bani olamua. ");
INSERT INTO sll_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Olangure ha maing di tenanga pinangwo pamia. ");
INSERT INTO sll_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ena yu ol ni tenangwo irai, nomani susu sire talwa dirale, di pirikio. ");
INSERT INTO sll_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ha iwe, na nan yon wu bilgere dinanga pamua. Dinanga kiani hobi gai gonangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Te nimai nabin hobi ire, ebin hobi ire, algi tani hobi ire, enin abin hobi ire dire, ni aule ire pire wiyol ta tenangure, ni sigonangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ari para weni na pir na tere monanga i, ni hanere yong ki e ni tenamia. ");
INSERT INTO sll_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tenamba, ni bini eme tani weniga malamba, na kene ol ni teralua. ");
INSERT INTO sll_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Teralia ni yalhobi nimni mole moli pire, nomani mol pai gobari inanua. ");
INSERT INTO sll_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ena Yerusalem oo malgi ami kura i wangwo yalhobi bina holo holi yobile monamia, hanere, eke, Yerusalem sigale isusu olamua di pinania. ");
INSERT INTO sll_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Di pinanga gin iwe, ari Yudia monga hobi te ere pi hamen hul molio. Yerusalem oo malgi monanga hobi, aidole te ere banta po. Te ari mena monanga hobi hon ere malgi nala di pirikio. ");
INSERT INTO sll_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Homa awa ha di engwo meri iwe, tal nigi dongwo ol wanga i, God nin prin ni tenangure u tibi namia. ");
INSERT INTO sll_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Eke, agr gir panangwo ya, te gir aming ne monangwo hobi iwe, miling pirie. God ari tal gogo ongwo hobi yong ki bir e tere, tal oun dongwo ol ni tenangure, gaung gul bir inanua. ");
INSERT INTO sll_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ari wiyol hobi Isrel ari tau si gonangure, tau aule ire pire ganba bina holo holi olamua. Te wiyol hobi Yerusalem oo ai bani egere moli nangwo nangwo, hamen haung wai sinamua. ");
INSERT INTO sll_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ena ari, haba, kulmoma iwe, tal ta onamio. Te pil nir digan mo mibi pire, sahala si yare sigune bir dinamio, ganba ari hobi ganulun dire kul pire omeling nol danamia. Danangure hamen yulang i, ho tere hol wanamia. ");
INSERT INTO sll_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wanangure ganba bani tal tau onangwo i ari hobi hanere, ha kwaling terewa sinamia yulang holkire, ari gongwo meri monamua. ");
INSERT INTO sll_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te Ari Wang Weni na kwahawa bolimbani molere, ere ime uralia. Uralgiwe, yulana bir pai na tenangure, nimni molere, hamen yong anigi ongwo meri uralga, ari para muru na hanangwo pamua. ");
INSERT INTO sll_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Emgi talhan han diga meri u tibi unangure, ni yalhobi hanere, o, God aki di na tenangwo haung mala umua dire, aire nimni molo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ena Yisas ha ta er bani di bole yu ditongwi, “Ni yalhobi kwasulu ya, te er tau bani kwi han monania. ");
INSERT INTO sll_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Monangere yolang bani hon pu dire mini hon onangwo irai, nimin sinangwo haung mala umua di pinia. ");
INSERT INTO sll_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pinga meri iwe, talhan onangwo hanere, o, God kene ol na tongwo hol irai omaga mala umua di pire monanua. ");
INSERT INTO sll_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ari omaga malungwo hobi olo ta gol wai sikinangure, talhan hobi u tibi unamia. ");
INSERT INTO sll_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hamen ganba wai sinamba, te na hana iwe, obil weniga ta i kul sikinamua. Ha weni kara di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ena hau homena miki weni nere, nir bia nere, te gaun tal pir yuwo ere wa monanga, Ari Wang Weni na uralga, tal onane? Na uralga haung pir po sikinia, gintani uralga pamia, a non ole kwi molio. ");
INSERT INTO sll_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hau kwir enga dirin wa i ure sungwo ganulun dungwo meri iwe, na uralga haung ari ganba uling holo holi para weni ganulun dinamua. ");
INSERT INTO sll_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ginangwo tanangwo haung haung na hana wai ole ole molio. Molere, talhan i u tibi unangwo nimni mole, Ari Wang Weni na gumana bani aire molala di pinanga iwe, God yulang na to dire, sirin bol tere tere molo.” ");
INSERT INTO sll_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hamen haung haung Yisas Yuda ha maing oo ware ha maing nir si tomia. Tere hamen girungwo, ere pi hamen hul Olibi pire mone pamia. ");
INSERT INTO sll_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te ari yal al hobi pare honmil Yisas ha maing dinangwo pirala dire, ha maing oo bir ala mone omua. ");
INSERT INTO sll_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ena homa God Isrel ari hobi wang homini si gonamba, han uning si tomia dire, homena si gal nere, God wai pir tere, erin mongwo haung u mala ungure hon nomani si pungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pirere ha maing oo singaba ire, Lo ana holo holo ha nir si tongwo hobi ire dire, Yisas si golala dire, ha hole hol wa dungwi. Dumba, ari para weni Yisas pir tomia dire, han uning sire ya mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ena Yisas grang wine ongwo ari ana holo holo kebena sutani yalhobi mongwo sina i, yal ta Yudas Iskeriot mongwo bani, Seten ure yong wu bungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bungure yal i ha maing oo singaba ire, ha maing plisman ire dire, mongwo bani u pa dire, Yisas han holala dire ha di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Olungure yal hobi wai pire, “Owa ni yu onanga moni tobo ni teralua”. ");
INSERT INTO sll_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ditongure yal Yudas, “Para dinia, han molo,” ditere, ari ta hon ekinangwo gin i na Yisas bai tal siralga irawa dire, kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ena erin habang iwe, kun sipi sipi giring si ke nongwo haung u tibi ungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ungure Yisas Pita Yon kina nu si olere, “Ni yasuri pire erin homena akun ol engere nenamna po,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Oo makena akun ol enamne?” ");
INSERT INTO sll_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ditongure Yisas yu ditongwi, “Piro. Ni yasuri pi oo malgi pa dinanba, yal ta nir mugu hol ire unangwo hanania. ");
INSERT INTO sll_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hananga yal i, oo ala ta nangwo i doling bol i pire, oo hong yal i yu ditenania, Tisa yu dimia piro. Ni oo weran ta na tengere, erin homena nenamna i tibi olo, dungure uminua. ");
INSERT INTO sll_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dinangere oo hong yal i weran ta mini bani i tibi ol ni tenamia. Tenangure, ni yasuri pire bol homena akun ole eyo.” ");
INSERT INTO sll_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dungure yasuri pire, oo hong yal i ha dungwo meri boling kul tomia, oo weran ta tongure, homena akun ole mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ena haung mala weni ongure, pudungwo Yisas grang wine ongwo hobi kina homena bol bani ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mongure yalhobi yu ditongwi, “Na gauna gul bir iralga mala umba, homa ni yalhobi kina erin homena i nerala dire wai pirige. ");
INSERT INTO sll_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Emgi erin homena i hon nekire moli ogere, God kene ongwo bani u tibi ure nima pire pai monangwo gin i, erin homena hon yulang bonangure hon nenaminua.” ");
INSERT INTO sll_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yu dire mulu hau are “God ni nir na tenga wai piriwa,” dire yu ditongwi, “Ni yalhobi nir i ebil sire ari hobi to. ");
INSERT INTO sll_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Emgi nir i hon ta nekire moli ogere, God kene ongwo bani u tibi ure nima pire pai monangwo gin i, nir i hon nenaminua.” ");
INSERT INTO sll_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yu dire homena breti ire, “God ni homena na tenga wai piriwa” dire, du dire yalhobi tongwi. Tere yu ditongwi, “Iwe, na yulana dimia. (Na yulana ni yalhobi miling pule ni teralia. Na pir na tere nere nere molio.” ");
INSERT INTO sll_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yu dire homena ne wai sungure, mulu hau nir holere tere yu ditongwi, “Mulu hau nir iwe, nomani hon gwa si ni teiya. Tegere God bolo guman puli ire u tani nana dire, na nan algi u mena namua.”) ");
INSERT INTO sll_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Hanega. Nan yalhobi homena tani nere ha wai dire mominga hobi, ta na bai tal sinania. ");
INSERT INTO sll_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ena God Ari Wang Weni gonama di pungwo meri, na golalga pamua. Pamiba na bai tal sinangwo yal i, miling pirie. Gaung gul obilga inama di pino? Bir weni inangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dungure yalhobi nin di wama tere, “Ara onama dire dime?” di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ena grang wine ongwo hobi molere, “Nan yal ara singaba molere, kene onamne?” dire bolbin dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dungure Yisas yu ditongwi, “Ari singaba king ta molere, hamil ha sire honagi ha dungwo te kene ol tongwo hobi yal i na yahuna ta moma di pimia. ");
INSERT INTO sll_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pimba, ni yalhobi monga sina i yal ta yal bir molala di pinangiwe, yal kultaing mongwo meri monania. Te singaba molala di pinanga, nir honagi oli nanga pire singaba monanua. ");
INSERT INTO sll_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yal ta nir hole yal ta tongwo nomia. Nongwo yal i singaba mom mo, te nir hongwo yal i singaba mome?” Dungure, yalhobi “Nir nongwo yal i singaba momua,” ditongwi. Ditomba, Yisas yu ditongwi, “Na nir honagi yal moliwa. ");
INSERT INTO sll_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na gauna gul ire moli ogiwe, ni yalhobi na pia si nin bangi olekingere, ereho moli uminia. ");
INSERT INTO sll_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Moli uminga Nabe ai ta na tongwo kene ol molalga meri, na ere ni yalhobi ai ta ni teralga kene yu ol monanua. Na kene olga bani iwe, nir nere homena nere monaminua. ");
INSERT INTO sll_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Molere Isrel wiyol ana holo holo kebena sutani hobi para weni bring aholo sire kene ol monanua. ");
INSERT INTO sll_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Ena Saimon, ni piro. Seten God sirin bol pimia. Pire urere, ni kela kul ni terala dire unamia. Yal ta hopi miling pere masin ongwo meri iwe, Seten ure kraun siralga pir na tenana dire yu ol ni tenamia. Tenamba miling dungwo meri ha maing a i si wananga nimni monanua. ");
INSERT INTO sll_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yu onamiba, na haya God Saimon aki di tenanga, Saimon nimni monamua di te pisole moliwa. Te ni mobin hal wa na tenangiwe, tere enin tau mobin hal wa na tenamba, ni hon aki di tenangere, hon nimni mole na pir na tenamua.” ");
INSERT INTO sll_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dungure Pita yu ditongwi, “Yal Yisas ye, ni halabusi pananga mo, gonanga, na kina ereho golabila dire, ni kwi han moliwa.” ");
INSERT INTO sll_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dimba Yisas Pita yu ditongwi, “Kenba ginangwo ni homa gin sui tai dire na hana di kul sinangere, emgi hoale be dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ena yu dire Yisas grang wine ongwo hobi yu ditongwi, “Homa na ni ha maing honagi onana dire, ni bai nu si olga onga irawe, moni gal kebin to, blasben ta ire honirayo, onga gin iwe, pi mole mena gole banta paikin mo?” dungwi. “Mena ta golkiminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Yu oniba, omaga iwe, yal ta moni gal giranga meri kene ole ire nanga pamua. Te gal blasben ere para kine ire nanga pamua. Te di baina ta hol sikinanga, gal yal ta tere moni inangiwe, di baina hon bring sire a ire po. ");
INSERT INTO sll_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ha maing buku awa ha yu pamiraya, ha hol ole halabusi pai mongwo hobi, yal i kina ereho si daule monamua. Ha di engwo iwe, omaga na molga bani nima namua. Te homa na pire awa ha di engwiwe, nima pire pai omua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dungure yalhobi yu ditongwi, “Yal Yisas ye, na yalhobi di baina sutani dimia hanega,” dungwi. “Owa, i para dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ena Yisas girungwo haung haung ongwo meri Yerusalem aidolere, ere Olibi hamen hul ongure, yalhobi doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pi pa dire Yisas grang wine ongwo hobi yu ditongwi, “Ni yalhobi monga bani tal nigi dongwo onanga pamua. Pamba, God gala dinangere, ni aki di ni tenangure, nimni mole monanua.” ");
INSERT INTO sll_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dire obilga ulubi pire, ikwi bole God yu ditongwi, “Nabe, ni aki di na terala di pinanga, aki di na to. ");
INSERT INTO sll_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tenanga, omaga gul iralga haung u tibi ta hunama di piriwa. Piriba, na hana ta paikima, ni nin hani pamia. Dinanga meri na wine olalua.” ");
INSERT INTO sll_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Yu dungure hamen bani ensel ta ya ime ure, aki di tongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tomba, Yisas yong sina hoho mo ure erin bai tabilungure, ha hon erakere ditongwi. Dite mongwo bani, pir pan iwe, ari algi yangwo meri ya ganba bani sungwi.) ");
INSERT INTO sll_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Di te pisolere, aire ere grang wine ongwo hobi mongwo bani ongwi. Pi hangure yalhobi Yisas tal ta ol tenangwo miling gul sungure, pole pole ul pai mongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hanere yu ditongwi, “Ni yalhobi talongwo ul pane? Aire hon mole God ha di te molkino? Ul panangiwe, Seten ni kraun sire kela kul ni tenangwo ni bol yanana dire yu onamia. Aire hon mole God ha di tere tere molo. ");
INSERT INTO sll_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yu dire mongure, Yisas kiang gintani u pa dungwi. Dire grang wine ongwo yal Yudas homa ere, Yisas gumang mu dirala dire ungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Umba, Yisas yu ditongwi, “Yal Yudas, Ari Wang Weni na ni gumana mu dinia. Talongwo mu dire na bai tal sine?” ");
INSERT INTO sll_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ena grang wine ongwo hobi Yisas tal ol terala dire ongwo hanere, yu dungwi, “Yal Yisas ye, na yalhobi tau di sinamne?” ");
INSERT INTO sll_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dire grang wine ongwo yal ta di baina aki dire sungure, ha maing oo singaba honagi yal ta kraung weni hol i bol wal kungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kungure Yisas hanere yu dungwi, “A, onga paikimia, hon olkio,” dire, kraung hon adagi si e tongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ena Yisas inaa dire, ha maing oo singaba ire, ha maing oo plisman ire, ha maing oo kene ongwo hobi ire dire, han hol irala dire ungwo yalhobi yu ditongwi, “Ni yalhobi na na han sirala dire unia. Ungiwe, di baina ire, di sire ire ure, yal ta homena kuni nongwo han sirala dire un mo? ");
INSERT INTO sll_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ya monga haung iwe, nan yalhobi kinbe kinbe ha maing oo ala molere, ha nir si ni tega pir mongarai, na han holkingirawe. Holkiniraba, ni yalhobi nin pinga haung, te si bongwo yulang tongwo hobi para pungwo haung, omaga werigi dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ena yalhobi Yisas han holere aule irere, Yuda ha maing oo singaba ke pangwo malgi ongwi. Ongure yal Pita pirere, naa di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Malgi sina iwe, endo gale pir mongure, Pita para pi endo pire ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mongure honagi ama ta ure, tene han mole yu dungwi, “Yal i Yisas kina ereho wangwo haniga irawe.” ");
INSERT INTO sll_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dimba, Pita ha di kul sire, “Alhuno, na yal i ta hankiwa” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yu di tere olo mol gobari hongure, yal ta ure yu dungwi, “Ni yal i gamahobo weni kara monga irawe.” Dimba, Pita yu ditongwi, “Ayo, na yal i gamahobo ta molkimna, pisolimo.” ");
INSERT INTO sll_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ena emgi yal ta u pa dire, yulang bole yu dungwi, “A i haweni kara dimia. Yal i Galili hong yal momia. Yisas kina ereho mole wamua.” ");
INSERT INTO sll_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dimba Pita yu dungwi, “Haniraba dinga pir kun olekiwe.” Yu di mongure, hoale gintani be dungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dungure yal Yisas inaa dire, Pita tene han tongwi. Tongure Pita Yisas ha homa ditongwo irai, hon i kraung bani ere nomani si pungwi, “Girungwo ni homa gin sui tai dire na hana di kul sinangere, emgi hoale be dinamua,” ditomiraya, hon nomani si pirere, ");
INSERT INTO sll_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ere mena pire, similo hai me mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ena plisman Yisas kene ongwo hobi Yisas gaung ha sire kuba sungwi. ");
INSERT INTO sll_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sire omeling apalapo ire to si tere yu ditongwi, “Ni sungwo yal i haang arawe?” ");
INSERT INTO sll_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dire ha yong miki i tongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ena honmil hamen tangure Yuda ari singaba hobi ire, kene ongwo hobi ire, Lo ana holo holo tisa ire dire, u ku bol mongwi. ");
INSERT INTO sll_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mongure Yisas aule ire kaunsil mongwo bani ongwi. Ongure yalhobi yu ditongwi, “Ni singaba Kraist mon mo, domo.” Dungure Yisas yu ditongwi, “Ni yalhobi na ha diga gin i, yol e pirikinia, talwa dirale? ");
INSERT INTO sll_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na sirin bol ni tenaminba, ni yalhobi sime molo di na tenania. ");
INSERT INTO sll_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ena omaga emgi na Ari Wang Weni molia. Molere yulang hong yal God kina kene ol molabilua.” ");
INSERT INTO sll_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dungure yalhobi yu ditongwi, “Ni God wang weni molia di pino?” Dungure Yisas yu ditongwi, “Ni yalhobi nin pinga meri dinua.” ");
INSERT INTO sll_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dungure yalhobi yu dungwi, “Nan tal ha hon dinangwo pinamne? Yali grang bani ha para di mena olungwo piminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ena yalhobi ha hol ol wai sire, Yisas aule ire ere gabman nambawan Pailat mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pi molere, yalhobi Yisas tal ongwo maing ha di mere si tongwi. Tere yu ditongwi, “Yal i ari hobi kraung sire, auli holo holo emirayo, te Singaba Sisa takis tekio dire hobang simirayo, te yal i nin na Kraist singaba moliwa dimiraya.” ");
INSERT INTO sll_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dungure Pailat Yisas sirin bol pungwi, “Ni Yuda ari singaba mono?” Dungure Yisas ha pring yu ditongwi, “Ni nin dingiwe.” ");
INSERT INTO sll_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dungure Pailat kene ongwo hobi ari tau para ditere yu dungwi, “Na yal i ha ta dinangwo miling irala dire wa duiba, ta dikimua.” ");
INSERT INTO sll_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dimba arihobi yulang bole yu ditongwi, “Yali Galili ganba ha kebering hole di te i Yudia pire omaga baniya umia. Ungure arihobi para weni ha i pire ganulun dire kura bonangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ena Pailat yalhobi ha dungwo i pirere, yu sirin bol tongwi, “Yal iya, Galili yal momo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Singaba Herot arinhobo momua,” dungure Pailat pirere, yalhobi Yisas kina nu si olere, “Herot monangwo po,” ditongwi. Ditongure yalhobi Herot mongwo bani ongwi. Ena gin iwe, Herot u Yerusalem mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mongure Yisas u pa dungure hangwi. Hanere, Yisas umia tal guma hon tau onangwo homa hankiraya, omaga haralga molia dire, wai pire gun ere mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Molere sirin miki weni bol tongwi. Tomba, Yisas ha ta mong ditekima. ");
INSERT INTO sll_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Di tekungure Yuda ha maing singaba ire, Lo tisa ire dire, u aire mole yulang bole ha di mere si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ena Herot soldia hobi para Yisas gaung ha sire grabalga ole brum bai tongwi. Tere gal mining ganing ungwo wai weni hau tere, nu si Pailat mongwo bani olungure, aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ena homa Pailat Herot kina kiang pai mongwi. Momba, omaga Herot tal ongwo i Pailat wai pire, u tani pire, ha wai di mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ena Pailat Yuda ha maing oo singaba, kene ongwo hobi para di ku bole yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ni yalhobi yu di ware, yal i aule i na molga bani unia, yal i ari hobi para weni kraung sire, auli holo holo emua dinga irawe. Ena na ni yalhobi monga bani ha ta dinangwo miling irala dire wa duiba, ta mangwo hanua. ");
INSERT INTO sll_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta mangwo meri iwe, Herot ere wa dungure ta mangwo pamia, hon nu si memini olimua. Piro, gonamba, ha oun dongwo ta i tibi olekinia, ");
INSERT INTO sll_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","homa kuba sire han gule olimingere ya monamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Ena erin habang Pailat memini pangwo ari halabusi pangwo yal taniga gule ole ole omiraya.) ");
INSERT INTO sll_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ena omaga iwe, ari yal al miki gala bir dire, “yal i si golo. Barabas gule olingere mena uname,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas iwe, gabman kina kura bole yal tau si gole hani pamiraya. ");
INSERT INTO sll_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat hon aire yu ditongwi, “Na Yisas gule olalgiwe.” ");
INSERT INTO sll_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dungure ari hobi para weni grang mu dire, “Er pera bani si golo. Er pera bani si golo,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ditongure Pailat ti hon aire yu ditongwi, “Tal ha oun dongwo pire dine? Yal iya gonamba, ha ta di oun dekimia, homa kuba obil sire gule olgere monangwiwe.” ");
INSERT INTO sll_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dimba, yalhobi grang mu dire, gala bir dire, “yali er pera bani si golo” dungure Pailat ha dungwo ya ime sungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sungure Pailat Yisas si gonama dire ha di ba bol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ena Pailat Barabas kura bole ari si gole hani pangwo yali gule mena olere, Yisas ari hobi ha dungwo meri grang wine olere, Yisas si gonama dire, soldia te aibing olungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ena olungure yalhobi Yisas aule ire ongwi. Ongure Sairini hong yal Saimon malgi nala di ongure, soldia hobi a i si molere, Yisas er pera haungwo i tol di ire hau tongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ena ari yal al tabin bir weni doling bol pire, al hobi aya maya dire, pegare ole hai mere mere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ongure Yisas kulu si hanere, yu ditongwi, “Yerusalem al hobo, na wa di pire hai me na tekio. Ni al hobi wani aun hobi pir tere hai me to. ");
INSERT INTO sll_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Piro, moli pire emgi habang ta u tibi nangure yu dinania, Ayo, al temini tongwo meri yu molalgarayo, di pinania. ");
INSERT INTO sll_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tal yu onangwo gin iwe, ni yalhobi yu dinania, Hamen hul i guru di yare na biiro, te ganba si pu dinangwo sina ala i molgere hon terewa sinamba, dinania. ");
INSERT INTO sll_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na er aulung hon dungwo molga na han olangwo pangwo yu ol na tomia, ni er aulung gongwo monia tal mere ol ni tename?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ena tal nigi dongwo ongwo yal su Yisas kina sirala dire aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pirere ganba ta haang Breng Yulang ganba pi pa dire, Yisas er pera bani sirere, te tal gogo ongwo yal su bina holo holo i si engwi. ");
INSERT INTO sll_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Si engure Yisas ha yu dungwi, “Nabe, arihobi tal gogo ol na tongwo i pring i ole to.” Dungure soldia yalhobi Yisas gal gule santu sire aling bangwo yal i, i ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ena ari hobi aire mole tene han mongwi. Mongure Yuda kene ongwo hobi guma bani aling diri bol tere yu dungwi, “Ari tau aki di tomiraya, nin gaung aki dinamo? Yal i Kraist God Nu Ke Tongwo Yal monangure, yu ole nin gaung aki do domo.” ");
INSERT INTO sll_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ena soldia hobi para gaung ha sire, u mala pire nir wain gu kengwo bli wa i pi grang wangwi. ");
INSERT INTO sll_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ware yu ditongwi, “Ni Yuda ari singaba king irai monia, nin gaung aki domo.” ");
INSERT INTO sll_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ena er pera gumiling mibi ha mining ta yu bol emia, YAL IWE, YUDA ARI SINGABA KING MOMUA. ");
INSERT INTO sll_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tal nigi dongwo ongwo yasuri yal ta Yisas gaung ha sire yu ditongwi, “Ni Kraist mon mo? Weni monanga nin gaun aki dire, na yasuri para aki di na tomo.” ");
INSERT INTO sll_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dimba er pera daling hol bani sungwo yal i ha dungwo i pire han tere yu dungwi, “Nan yasuri pring oun dongwo ipire gul na tomba, yal iwe, pring ta paikungure, gogo nomani pire ol tomia. ");
INSERT INTO sll_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nan yasuri tal gogo ominga pring pangwo meri gul iminia. Gul iminga meri yal i bolo para iminia. Ni God kulung pirikire, yu din mo?” ");
INSERT INTO sll_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dire Yisas yu ditongwi, “Yisas, ni emgi singaba king mole kene ol monanga haung na para milna pir na to.” ");
INSERT INTO sll_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dungure Yisas yu ditongwi, “Kenba ni na bolo gul ikinaminga ai u sina wai weni pire gun ere monaminua.” ");
INSERT INTO sll_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ena omare ari u sina weni ure dekungure, ganba uling holo holi hamen para si bol poira sungwi. Si ongwo ongwo hamen pudungwo ari kula pangure, ari hon dongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yu ongure ha maing oo bir ala gal hol engwo iwe, sina weni si dina di ya ime pire, u sutani ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ena Yisas gala bir dire yu dungwi, “Nabe, na kwiana ni ani bani eiwa,” yu dire gongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Gongure soldia kene ongwo yal keptin ta tal ongwo i hanere, God haang a yuwo olere yu dungwi, “Yal iwe, tal wai ongwo yal momua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ena ari miki weni harala dire u ku bole mongwi. Momba, tal ongwo i hanere, miling pire, dini me sire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ena Yisas ening abing hobo tau ire, Galili al doling bol ungwo hobi tau ire dire, ulubi aire molere, tal u tibi ongwo i han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tal yu ongwo gin iwe, Yuda oo Arimatia malgi hong yal ta Yosep mongwi. Yal iwe, tal wai mone olere, God kene ol na tenangwo hol u tibi unamia di pire kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yal i Yuda ha maing kaunsil yal momba, Yisas ha hol ol tere sigonaminua dungwo i, yal Yosep ha mining akire mongwi. ");
INSERT INTO sll_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Molere ere pi Pailat mongwo bani pire, Yisas gongwo yone irala dire sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pire yone ire gal pege yobile tere, i pi ari yulagi gul hulu grang ari yone ta ere ere olkungwo ala i, Yisas i pi engwi. ");
INSERT INTO sll_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Engwo gin iwe, Prainde ongi Sabat u tibi unamia. ");
INSERT INTO sll_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ena agr tau Galili mole Yisas hol ire ungwo hobi iwe, yal Yosep Yisas yone ire ongwo hol i doling bol pire man wu engwo bani hangwi. ");
INSERT INTO sll_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hanere ere malgi pire paura ya, marasin tau ire, Yisas gaung bani bil terala dire, akun ongwi. Akun ol erere, Sabat haung Lo erin molo dungwo meri iwe, wine ole mongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ena Sarebir haung honmil al hobi marasin paura akun ol engwo hobi ire, ere pi Yisas man wu engwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pirere kwahulu hona bol pera di engwo i, ya dinam mo di hamba, akrigi si mena olungure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hanere yone dinangwo harala dire, ala pire wa dumba, yal Yisas yone dikungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dikimia alhobi nomani si gogo dale, mongwi. Mongure gintani yal sutani gal ongwo bani, hamen yong anigi ongwo meri, pege au dale dimia mongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mongure alhobi gintani han ire ole, kul pire, ikwi bole mongwi. Mongure yasuri alhobi yu ditongwi, “Gongwo yal i haya si hon ere airimia, ni alhobi ari yulagi engwo bani talongwo wa dune? ");
INSERT INTO sll_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Homa ya monga haung Galili mole, awa ha di ni tongwo irai nomani si pirikino? ");
INSERT INTO sll_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yu di ni tomiraya, Ari Wang Weni na irawe, na aule i pire, ari tal gogo ongwo hobi na tenangure, er pera bani na sinamua. Sinangure ari habang sui tai dire pai molere, hon airalua di ni tongwo pinga irawe.” ");
INSERT INTO sll_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dungure al hobi awa ha di engwo i hon nomani si pungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pirere ari yulagi gul pisolere, ere pi memini ongwi. Pirere grang wine ongwo ari ana holo holo kebena taniga mongwo hobi ditere ari tau para di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ditongwo al hobi iwe, Magdala hong al Maria ire, te al Yoana ire, Yems aang Maria ire, al tau hobi ire dire, ha dungwo pungwo meri aposel yalhobi mongwo bani di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tomba, aposel hobi al hobi hamen hair mangwo ha duwama di pire pir tekungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pir tekimba, yal Pita aire bli si ari yulagi engwo bani ongwi. Pi molere han ala i olimba, ari ta molkima, gal obil dimia hangwi. Hanere nomani si gogo dale, ere memini ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ongwo gin iwe, grang wine ongwo hobi mongwo sina i yal su Yerusalem aidole, ere pi Emeas nala di ongwi. Ongwiwe, Kilau aidole Dirima nangwo meri ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pirere yasuri talhan ongwo hangwo meri boling kul pire pire ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ongure Yisas nin pi gaung bangure, ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pirere yasuri omeling aklu gale hamba, Yisas gumang han po sikirere, o, ari ta ungwo pamua di hangwi. ");
INSERT INTO sll_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hangure Yisas yasuri yu ditongwi, “Ni yasuri hol bangi timi ha diriyala olinga i talwa dine?” Dungure yasuri pire ira mole miling pirere, gumang boregi dungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dire yal ta haang Kliopas Yisas yu sirin bol tongwi, “Ari ganba bina holo holo irai Yerusalem tal oma dungwo i pire, pi ku bole momia, ni tani ha i pirikino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Tal u tibi ungwo han dine?” dungwi. “Nasaret hong yal Yisas irai, tal ol tongwo han diminia, yal iwe, God hana togu yal molere, ha miling bolo mone dire, te tal nimni mongwo mone olere, ari maulung bani God maulung bani kina tal yu ol mongwo yal irai han diminua. ");
INSERT INTO sll_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ena ha maing oo singaba ire, ha maing kene ongwo hobi ire dire, Yisas aule i pire Pailat tomia. Tongure Pailat ha hol ole sigonama dire soldia tomia. Tongure soldia aule i pire er pera bani si gomia. ");
INSERT INTO sll_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ena Isrel arihobi u tibi albe pire, yone pare mominga hobi si hon e na tongure, sigare kunama di piriga irai, pisole gomia. Gongure hamen haung sui tai dire mole uminua. ");
INSERT INTO sll_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ena kenba al ama hobi tau ari yulagi engwo bani pi hanere, molkimua dungure, ganulun diminua. ");
INSERT INTO sll_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te al hobi iwe, kwia ensel mole gongwo irai hon airima di na tomua dungwo i, kuu hanere dima di pire uminua. ");
INSERT INTO sll_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te nan gamnahobi tau ere pi yulagi engwo bani pire, al hobo dungwo meri pire pi hamba, Yisas pai monangwo hankimua.” ");
INSERT INTO sll_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dimba Yisas yasuri yu ditongwi, “Ayo, ni yasuri nomani paikinga pamia. God hana togu yalhobi ha dungwo meri irai memini pir po sikinga pamia. ");
INSERT INTO sll_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kraist homa gaung gul ire, emgi kene ongwo ai inangwo pamia pirikinua do.” ");
INSERT INTO sll_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yu dire yal Moses ire, God hana togu tau ire dire, ha maing buku bol engwo meri irai memini pangwo yal i hon si kulu sire di tibi ol tomia yasuri pire bukunungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ena yalhobi pi Emeas malgi pa dire, yasuri iri si oo ala ta nala di ongure, Yisas mena hol nala di ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Omba, yasuri gala dire, “Hamen girimia, na kina pamingere honmil nana ya wo.” Dungure Yisas ere ala pire yasuri kina mongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ena molere, emgi homena nerala di ongure, Yisas yasuri si daule mongwi. Molere Yisas aire breti ta ire, “O God, ni homena na tenga wai piriwa,” dire a du dire yasuri tongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tongure yasuri gintani Yisas gumang han pa dungwi. Dimba, yasuri mongwo omeling bani u holo holo omia hon hankungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hankire yasuri nin ha di mole, “Nan yasu homaulung ubilga bani irai yal i u na hongure, ereho uminga yal i ha maing memini weni di tibi olungwo irai nan yona sina nabile horega ongwiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yu dire yasuri gintani hon siina di Yerusalem ongwi. Pi pa dire hangure, Yisas grang wine ongwo ari ana holo holo kebena taniga ire, ari tau ire dire, ku bole mongure hangwi. ");
INSERT INTO sll_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ena ari hobi yasuri yu ditongwi, “Yasuro, pi tege eminga yal gongwo irai hon airungwo, yal Saimon haniwa dimua.” ");
INSERT INTO sll_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dungure yasuri pir mole homaulung bangi ongwo Yisas tal ol te i pire breti a du ditongwo iwe, boling kul tibi ol tere yu ongwo habilua, dungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ena di te mongwo gin iwe, Yisas haya ure yalhobi mongwo sina i aire mongwi. Molere, “Gir hobo moldinio. Ni monga bani hamen wai tanamia, mining bolo molo”. ");
INSERT INTO sll_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ditongure “gongwo irai gaing umua” di hanere kul pungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pimba Yisas yalhobi yu ditongwi, “Yalhobo, talongwo kulna pire nomani su su sine? ");
INSERT INTO sll_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Na kebena ana bini i guma hankino? Gaing molalga na arala dire ol i nanga bukunania. Te ari molalga na ananga gaung yulana i a pinania a pirio.” ");
INSERT INTO sll_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(Yu dire aling kebering sine dire hano dire nibil di tongwi.) ");
INSERT INTO sll_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ena ari hobi yong miling horega ongure wai pungwi. Pimba pir tekire nomani miki sungwi. Simia Yisas yu ditongwi, “Na homena ta neralga dimo?” dire sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pungure pisi gangwo ta tongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tomia nongure han mongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ena Yisas grang wine ongwo hobi yu ditongwi, “Moses krehaman ha ire, God hana togu yalhobi ire, Sam ul geral buku ire dire, na uralga pire awa ha di engwo meri irawe, omaga na molga bani nima pire panama dire, na di ni te molga irai, omaga gole hon airiga, kara nima pire pangwo hanua.” ");
INSERT INTO sll_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yu dire yalhobi nomani a kulang pai tongure, ha maing buku para memini pir po sungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sungure Yisas hon yu ditongwi, “Ha maing buku mining ta yu pamiraya, yal Kraist gaung gul ire golere, ari habang sui tai dire pai molere airamua. ");
INSERT INTO sll_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Airangwiwe, haang i pirere di tibi olamio, te ari hobi tal nigi dongwo ole wangwo i pisole, nomani si kulu sire hon olkirala di pinangwo pring pangwo i gul inanba, Kraist nin imua di tibi olamia. Te ha iwe, ni yalhobi Yerusalem malgi homa kebering holere, emgi banta banta nanua. ");
INSERT INTO sll_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ena ni yalhobi iwe, na hana pirere, tal olga hanga i di tibi olio. ");
INSERT INTO sll_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Homa Nabe Kwiang ni teralua di engwo irawe, na bai nu si olalga inanga pamia. Inanba, ni yalhobi Yerusalem malgi kwi monanga, ure yon wu binangure, nimni mole ha maing honagi onanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ena Yisas Yerusalem aidolere, grang wine ongwo hobi aule ire pire, Betani malgi pi pa dire, aling sine dire “God ni yulan yalhobi to.” Di tere kuria si tongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kuria si tere aidole, ere hamen bani ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ongure yalhobi gun bir weni ere siina dire ere Yerusalem ongwi. ");
INSERT INTO sll_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pire Yuda ha maing oo bir ala mone mol pai olere, God maa e te mongwo bani mongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hamen haya hamen ganba ol ekungwo haung, God grang yal ta momua. Molere God kina si daule momua. Ena grang ha yal iwe, ari ta molkimia, God nin momua. ");
INSERT INTO sll_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kebering hongwo haung, grang yal i God kina ereho molere, talhan hobi para weni ol e pa dimua. ");
INSERT INTO sll_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yal i molkima, talhan hobi ta ol e pa dikungure. Weni kara momia talhan hobi iwe, God yulang tongure grang yal i para weni ol e pa dimua. ");
INSERT INTO sll_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dire mol pai iwe, bling memini hong ere yal i momua. Molere ari hobi a nabile te mongwo bani momua. Mongure ari hobi mongwo miing simua. ");
INSERT INTO sll_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ena nabile te mongwo iwe, si bongwo u terewa sinamba, kunu paikinamua. ");
INSERT INTO sll_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ena God honagi yal ta, haang Yon, yali ha di tibi olama dire, bai nu si olungwi. ");
INSERT INTO sll_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Olungure yal i ure mol pai nabile ba bongwo yal i haang i di tibi ol tongwi. Tere ari hobi nabile ba bongwo hong yal i maing ogolo pinama dire, di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yon iwe, nabile ba bongwo hong yal ta molkima. Nabile ba bongwo hong yal emgi unangwo i pire awa ha i homa di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nabile ba bongwo hong yal i ari ganba ganba a nabile tongure pai momua. Molere nabile ba bongwo hong weni mole habang gin i ganba bani u tibi pire momua. ");
INSERT INTO sll_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ena grang yal i molere talhan i ol emia. Engwiwe, yal i tani taman. Ganba bani talhan i grang yal i God aling bani mole ol engwo dimia. ");
INSERT INTO sll_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ena yal i ya ime ure u tibi ongure, ganba ari hobi yal i gogo ta han po sikimia. Sikungure yal i nin ganbani u tibi umba, ening hobi pana gal tekirere, han gogo damia. ");
INSERT INTO sll_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Te ari tau pana gal tongwo hobi ogolo pir tere wa mongure, grang yal i nu ke tongure, God hanere wana auna monua ditomia. ");
INSERT INTO sll_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ditongure yal hobi ari miing algi bolimbani kul engwo i, God wang aung monangwo taman. Arihobi nomani sina ali God tal ta ol tongure, God wang aung moma diminia. ");
INSERT INTO sll_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iwe, grang yal i u ari ongure, nan mominga bani kina ereho mol pai ominua. Grang yal i ure mongwo hanere, o, God na mominga bani ungwo kina ereho momna di piminua. Yal iwe, tal nigi dongwo olkirere pirari pare to bir hole i ure pule a siribi sire, ha pangwo meri kara dungwo hanere mominua. Grang yal i God wang tani kul emia yal i God moma di piminua. ");
INSERT INTO sll_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ena yal Yon grang yal i guung haang di ba bole yu di tere tere ongwi. “Yal ta mobina hol unamua diga yal iwe, na omaga wiiba, yal i hamen haya ya mol pangwo pamua. Na digan molia, unangwo yal i singaba weni momua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yal i pirari pare to bir hole i ure tal wai miki weni a siribi si nan yalhobi mominga bani olimia. ");
INSERT INTO sll_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Homa God krehaman ha yal Moses di na tomiraba, Yisas Kraist iwe, pirari pare a siribi si na tere ha pangwo meri di na tomua. ");
INSERT INTO sll_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","God ari eming gaung hamo? Weni ta hankimia. God Wang weni iwe, God nin mongwo meri molere, irang kina ereho si daule momia, irang tal ongwo maing di ba bol na tongwo piminua. ");
INSERT INTO sll_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ena Yerusalem malgi Yuda yalhobi ha maing oo singaba tau ire, yol Lebai tau ire dire, bai nu si Yon mongwo bani olungwi. Olungure ure yalhobi Yon sirin bol pungwi, “Ni ara mone?” ");
INSERT INTO sll_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dungure Yon pir uning si molkima, maing di tibi ole yu ditongwi, “Na singaba Kraist ta molkiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ara mone? Kwiana moya Ilaiya mono?” dungwi. “Ta molkiwa,” dungwi. “God hana togu yal unama dire kwi mominga irai ni un mo?” dungwi. “Ta molkiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Na yalhobi ari na nu sungure ure sirin bominia, ni monanga maing di tibi ol na to. Ni nin tal ha di ime ene?” ");
INSERT INTO sll_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dungure Yon yu ditongwi, “Na ganba po engwo gul i mole gala dia. Pi tege enaminga yal unamia hol i bala dire akun olo.” Dungwiwe, homa hana togu yal Aisaya awa ha di engwo meri di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ena Perisi homa yal tau bai nu si olungwo hobi pi Yon mongwo bani pire hon sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Ni Kraist molkiwa dinirayo, te Ilaya molkiwa dinirayo, te God hana togu yal molkiwa diniraya, talongwo ari nir bil tene?” ");
INSERT INTO sll_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dungure Yon yu ditongwi, “Na ari hobi nir wo bil teiya. Teiba, ni yalhobi monga sina i yal ta u tibi ure aire momba, pir po sikinia. ");
INSERT INTO sll_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Na homa u tibi egere yal ta emgi unamua. Unangwo yali, na gal kine teralba, digan moliwa.” ");
INSERT INTO sll_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yodan nulu hoibi Betani malgi iwe, Yon nir bil te mongure, yalhobi ha i sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ena tanangwo Yisas u pa dungure Yon hanere yu di na tongwi, “Hanega. Yal i God kun sipi sipi giring kungwo momia. Mole ari para weni tal nigi dongwo ol wangure God pring tongwo i tol dire i momua. ");
INSERT INTO sll_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na homa yu di ni tega piniraya. Yal ta emgi unangwo yal iwe, na omaga wiiba, yal i hamen haya ya mol pangwo bani pamua. Na digan molia, unangwo yal i singaba weni momua. ");
INSERT INTO sll_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yali gumang haya han pa dikia. Dikiba, na ari nir bil ni tegere, Isrel ari hobi yal i gumang han pa dinana dire wiwa.” ");
INSERT INTO sll_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ena Yon ha di tibi olere yu dungwi, “God Kwiang hamen bani aidole hahoba yumil mongwo meri mole ya ime ure, Yisas kina si daule momia, haniwa. ");
INSERT INTO sll_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Homa yal i ta han po sikiba, God nir bil tenana po di na tere ainere yu di na tomia, ‘Bil te monanga, God Kwiang ya ime ure yal ta kina si daule monangwo hanania. Hananga yal iwe, God Kwiang bai nu si olangure Kwiang nega dire ure, ari gongwo meri mongwo hobi yong wu bilere si hon e tenangure sigare kunamua. ");
INSERT INTO sll_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na nan han pisole, yal i God wang weni mongwo hanere di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ena tanangwo irawe, Yon aire mongwo bani hon mongure na gamnahobo su ereho aire momingi. ");
INSERT INTO sll_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mole hamingere Yisas wiyala ongwi. Ongure Yon dina hanere yu di na tongwi, “Hanega. Yal iwe, God kun sipi sipi giring kungwo momua.” ");
INSERT INTO sll_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dungure na yasuri aire mole pirere Yisas ongwo hol i doling bol omingi. ");
INSERT INTO sll_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Omingere inaa dire hamba, na yasuri ominga hangwi. Hanere yu di na tongwi, “Ni yasuri tal holo une?” Dungure na yasuri yu ditomingi, “Tisao, ni oo makena monane?” dimingi. ");
INSERT INTO sll_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Ni yasuri ure hanana wo,” dungwi. Dungure na yasuri umingere Yisas oong nibil di na tongwi. Di na tongure na yasuri pudungwo poklok mole hamingi. Hanere pudimia Yisas kina ereho monaminua di pire ereho momingi. Ena na yasuri homa Yon dina ha dungwo pir molere Yisas kina ereho omingi. ");
INSERT INTO sll_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ominga yal i ta Saimon Pita ebering Endru na kina momingi. Ena honmil maini pire abimbi Saimon mongwo ongwi. ");
INSERT INTO sll_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pirere yu ditongwi, “Na singaba Kraist mongwo hane ugiwe.” ");
INSERT INTO sll_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dire aule ire Yisas mongwo bani ongwi. Ongure Yisas Saimon hanere yu ditongwi, “Yon wang Saimon ye. Omaga ni hani iwe, Sipas eiwa.” Haang su Sipas, Pita dimba, haang su i memini iwe, hulu ye dinaminua. ");
INSERT INTO sll_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ena tanangwo irawe, Yisas Galili probins nala dire ongwi. Pire Pilip mongwo hanere yu ditongwi, “Ni ure na dolna bolo.” ");
INSERT INTO sll_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ena Pilip ire, Pita ire, Endru ire dire, Betsaida hong yal momia. ");
INSERT INTO sll_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ena Pilip pirere, yal Nataniel mongwo hanere yu ditongwi, “Homa Moses God krehaman ha dire mining bol engure, hana togu yalhobi para awa ha mining grang u tani ongwo meri irawe, omaga giu dire pangwo haminue. ");
INSERT INTO sll_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yal i Yosep wang Yisas Nasaret hong yal momua.” Dungure Nataniel yu ditongwi, “Nasaret ganba nigi domia, omaga tal wai ta u tibi umua dino?” Dimba Pilip yu ditongwi, “Ni ure hanana wo.” ");
INSERT INTO sll_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dungure Nataniel mala ungure Yisas hanere yu ditongwi, “Yol Isrel yal weni ta umia hano. Yal i hasu hong yal ta molkimia, tal dime dire ongwo yal momua.” ");
INSERT INTO sll_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dungure Nateniel yu ditongwi, “Ni talongwo na gumana han pa dine?” Dungure Yisas yu ditongwi, “Homa yal Pilip ni gala dikinangwo, ni kwasulu dimani ya monga haniwa.” ");
INSERT INTO sll_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dimba Nataniel yu ditongwi, “Tisa, God wang ye. Nan Isrel ari hobi singaba king tani monge.” ");
INSERT INTO sll_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dungure Yisas yu ditongwi, “Ni kwasulu dimani monga han di ni tega i, ni hon nomani si kulu sire na tal han muru onangwo pamia dire pir na teno? Emgi ni tal bir weni ta hananga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dire Yisas hon aine yu ditongwi, “Emgi ni yalhobi hamen bani hananga, hamen hona grang hoiri yaulamia. Yaulangure God kwia ensel hobi ure na Ari Wang Weni molga bani na hanere, moyu pire, ya ime ure, moyu pire, ya ime ure dire wa monangwo hananua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ena hamen haung sutani molere, Galili probins Kena oo malgi yal ta al hon ingwi. ");
INSERT INTO sll_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ingwo gin iwe, Yisas ire, aang ire, gamahobo ire dire, al hon ingwo oo malgi di aulungure pi momingi. ");
INSERT INTO sll_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pi momingere, nir wain nominga wai sungwi. Simia al Maria Yisas aki di tenama dire yu ditongwi, “Nir wain para wai sungwo yawe.” ");
INSERT INTO sll_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dimba Yisas yu ditongwi, “Alhuno, ni hani ta paikimia, na nan hana pamia. Talhan hobang molia i tibi olalga haung olo molkiwa.” ");
INSERT INTO sll_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dungure aang honagi ari hobi yu ditongwi, “Yal i ha ta di ni tenangwo irai, ni arihobi wine ol to,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ena Yuda arihobi iwe, krehaman ha dungwo wine ole bigi moni sire sire ongwo ganba mulu sin bir weni ana hol pai muru hol pai taniga ire, nir eti lita honangwo kunung benangwo mere dimia. ");
INSERT INTO sll_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dungure Yisas honagi yalhobi yu ditongwi, “Nir hol ire unana po.” Dungure arihobi mugu migi tau ire pire, hol i ure, garu di mugu bir ala olungure, mulungwi. ");
INSERT INTO sll_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mulungure Yisas yalhobi yu ditongwi, “Tau tule ire pire, homena ebir si mongwo yal i to.” Dungure tule tongwi. ");
INSERT INTO sll_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tongure homena ebir sungwo yal i obilga tima ne pimba, nir wain houng pangwi. Pamia yal i nir wain ta inangwo hankiraya, makena ime di pungwi. Pimba, honagi ari nir hongwo hobi nin haya han pa dungwi. ");
INSERT INTO sll_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Homena ebir sungwo yal iwe, al ingwo yal i gala dire yu ditongwi, “Nir wain wai dungwo homa tomia, ari hobi ne pisole mongure emgi ari hobi gogo nongwo haung wain nigi dongwo tongwo nomia. Nomba, ni wain nir wai weni dungwo i kul si ere mole, emgi i tibi olinga nere wai piminge.” ");
INSERT INTO sll_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ena Yisas gir migi mongwo haung ya moni mol i ungwo ungwo, ari molere, Galili probins Kena oo malgi yal ta al ingwo gin iwe, tal guma hon dongwo i hongebe weni ongure, arihobi hangwi. Hangure God Yisas yulang tongwo i, i tibi olungure, na gamna hobi hanere Yisas pir tomingi. ");
INSERT INTO sll_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ena habang gin i wai sungure, Yisas ire, aang ire, ebering hobo ire, gamahobo ire dire, ere Kapaneam omingi. Pire habang tau pare momingi. ");
INSERT INTO sll_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ena Yuda ari erin haung u mala ongwi. Erin iwe, hongebe Isrel arihobi Isip pai mongure, God wang homini para muru si gonamba, han uning sungwo i erin u tibi ongure nomani si pire erin momingi. Molere Yisas kina ere Yerusalem malgi omingi. ");
INSERT INTO sll_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pire hamingere ha maing oo bir ala i yal tau kun bulamahau, sipi sipi, hahoba maket ere moni bol ingure, te yal tau moni sanesi ongwo hobi bol bani mongure haminia. ");
INSERT INTO sll_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hamingere Yisas han ta gwa sire hau hobi si doling i maini olungwi. Olere moni sanesi ongwo hobi bol a sinaa dire moni kina siru di manbi olungwi. ");
INSERT INTO sll_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Olere bisnisi ongwo hobi yu ditongwi, “Hahoba maket enga hobi iwe, ire ere pio. Ni yalhobi Nabe oo ala i ongere, u stua meri omia yu olkio.” ");
INSERT INTO sll_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dungure na gamnahobo i ha maing buku ala i ta yu pamiraya dire nomani si pimingi, “O God ni oon i kene onangure mama weni dinama dire na nega dire ol moliwa.” ");
INSERT INTO sll_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ena Yuda ari hobi Yisas tal ongwo i hanere yu ditongwi, “Ni yulang na tongure honagi oliwa dingiwe, tal guma hon ta i tibi olanga hanere, o, ha pangwo dinua, dinaminba?” ");
INSERT INTO sll_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dungure Yisas yu ditongwi, “Ni yalhobi God oong i tule olingere na ari habang sui tai dire gintani keralua.” ");
INSERT INTO sll_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dungure yalhobi yu ditongwi, “Ha maing oo iwe, me erin kun oo po pela ten sikis ke wai sungwo dimia, ni tule olere, ari habang sui tai dire gintani hon keralua dino?” ");
INSERT INTO sll_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dimba Yisas ha maing oo han dungwo iwe, nin gaung yone i ha maing oo bani di bongwi. ");
INSERT INTO sll_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bomia emgi God yulagi engwo bani nin aki di imia. Ingwo gin iwe, na gamna hobi han po sire, Yisas ha maing buku kina homa ha di tani engwo irai hon nomani si pimingi. ");
INSERT INTO sll_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ena erin habang i Yisas Yerusalem malgi molere, tal guma hon dongwo maing maing ongure, ari miki weni hangwi. Hanere pir tere haang a i si wangwi. ");
INSERT INTO sll_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wamba Yisas ari hobi nomani si pungwo meri han po sire, han gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ari hobi yong miling sina i nomani si pungwo meri yal ta ha wai ol tenamba, Yisas nin han po sungwi. ");
INSERT INTO sll_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ena Perisi yalhobi enin ta, Yuda ari singaba momia. Yaliwe, haang Nikodimas. ");
INSERT INTO sll_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yal i girungwo ta Yisas mongwo bani u pa dire yu ditongwi, “Tisao, ni God ni bai nu sungure, ya ure ha maing nir si tenga piminua. Ni diu sire tal guma hon dongwo onga i, God yulang ni tekinangure tal yu onanga panamo? Paikinamia. Yulang ni tongure onga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dimba Yisas yu ditongwi, “Ni ha weni kara dinba, na di ni teralga piro. Yal ta aang kul emiba, tal ta minibani ya ure hon kul ekinangwo God kene ongwo hol u tibi omia di hanamo? I ta hankinamua. Hon kul enangwo gintani hanangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dungure Nikodimas yu sirin bol tongwi, “Ayo, ari mongwo iwe, hon talongure aang yong miling sina nangure, kul mena olama di dine?” ");
INSERT INTO sll_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dimba Yisas yu ditongwi, “Na ha pangwo di ni teya. Yal ta nir te God Kwiang tal ta ol tenangure pol kule hon kul ekinangwo, God kene ongwo bani namo? I ta honama. Pol kule hon kule enangwo God kene ongwo bani gintani nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ari gir pare kule engwiwe, ari gumang homia. Te God Kwiang gir pare kul engwiwe, God Kwiang nin gumang homia, gir nomani hama sikima, wai weni dimua. ");
INSERT INTO sll_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ni yalhobi hon ni kul enamua di ni tega i, talmere na kul ename di pinba, nomani gogo sikio. ");
INSERT INTO sll_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hamen hair gogo ongwo nugung pinba, u ongwo hol ni uling han mo? I ta hankinia. Ungwo hol ure u ongwo hol i omua. God Kwiang yal ta ol tenangure, pol kule hon kul enangwiwe, hamen hair ongwo meri onamia, ni uling hankinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dungure Nikodimas yu ditongwi, “Tal ha dinga i talmere onangwo pire dine?” ");
INSERT INTO sll_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Dimba Yisas yu ditongwi, “Ayo. Ni Isrel ari hobi Tisa irai monia, ha diga i pir po sikino? ");
INSERT INTO sll_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na yalhobi tal pire hanere ominga i, i tibi ol ni tere nibil di ni tominua. Tominba, ni yalhobi a i si wakire, grana si olinua. ");
INSERT INTO sll_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na ganba baniya ha maing u tibi ongwo i, boling kul ni teiba, ni doling bole ogolo a i si wakinua. Te hamen bani ha oun domia di ni tegere, talmere ole pinane? ");
INSERT INTO sll_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yal ta yamoni mo hamen bani namo? I ta honamia. Na Ari Wang Weni molia. Molere hamen bani mole ya ime wiwa. ");
INSERT INTO sll_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Homa yal Moses ganba po engwo bani onba er yolang bani si paru di emiraya. Di engwo meri irawe, Ari Wang Weni na, er yolang bani na si paru di enamua. ");
INSERT INTO sll_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Enangure ari tau na onangwo pamia dire pir na tere monangwo hobi, nomani wai ire mol pai gobari ha te inamua.” ");
INSERT INTO sll_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ena God ganba ari miling ala pamia, yong miling ni tere Wang tani weni ni te olimia. Olungwo yal i gonamia, ni yalhobi para ereyu gonanba, doling bole a i si wananga, mol pai gobari weni inanua. ");
INSERT INTO sll_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God Wang Weni nu si olungure, hon siina di ganba bani ure, ari hobi ha hol oun dongwo ol tenama di pino? I ta ol tekinamia. Aki di tongure arihobi sigare kule u wai nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yal ta God Wang ogolo pir tere wa monangwo yali, God ha hol oun dongwo ol tekinamia. Te yal ta God Wang ogolo pir tekire wa monangwo yali, God haya ha hol oun dongwo ol tomua. ");
INSERT INTO sll_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ena ha hol maing yu pamia. Ganba baniya nabile ba bongwo u tibi umba, arihobi iwe, tal nigi dongwo a i si wa molere, mining hole si bongwo ala i ya mol parala dire yulang bomua. Bole ba bongwo bani wanangwo ha pirikimua. ");
INSERT INTO sll_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Te ari hobi tal nigi dongwo ol warere, nabile ba bongwo hol iwe, nigi de hanere, wanangwo ha pirikimia. Nabale ba bongwo hol iwe, wanangwo, tal nigi dongwo olalga, u tibi nangwo gai golala di pimia. ");
INSERT INTO sll_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te yal ta tal dime dire onangwo yal i, nabile ba bongwo hol i wanamua. Warere God wine ol tere, tal dime dire, ogolo weni olgere, ari hobi hanama dire, ole wanamua. ");
INSERT INTO sll_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ena habang gin i wai sungure Yisas na gina hobi kina ere Yudia ganba omingi. Pi molere Yisas ari yal al hobi nir bil to di na tomia bil te momingi. ");
INSERT INTO sll_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Habang gin i singaba Herot Yon olo hani sikungure honagi homa kebering hole ongwi. ");
INSERT INTO sll_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Olere dina yal Yon Ino ganba Selim malgi mala ari hobi nir bil tongwi. Tongwo bani iwe, nir miki weni yangwi. Yangure ari hobi nir bil na tenama dire u sina ungwi. ");
INSERT INTO sll_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ungwo gin wie, yal Yon gamahobo Yuda yal ta kina, nir bil tongwo i, ha bolbin di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Di pisolere gamahobi pire Yon yu ditongwi. “Tisao, homa Yodan nulu hoibi yuwo molere, yal ta kina ereho mole yal i momua di na tengarai, yal i omaga arihobi nir bil tongure ari para muru pir tere doling bongwo haminua.” ");
INSERT INTO sll_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dungure Yon yu ditongwi, “God mongwiwe, yulang tekima yal ta honagi olkungure. ");
INSERT INTO sll_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na ha di tibi ol ni tega i, ni yalhobi nin hamen haya pinia. Na Singaba Kraist molkiwa. Molkiba, God na nu sungure, homa e teiwa. ");
INSERT INTO sll_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ena yal ta al irala dire onangwiwe, inangwo al i yal i eumbi monamua. Te al ingwo yal i enin hobi aire mole ha dungwo i pire gun e tomua. Tongwo meri, na Yisas ha gung pire ere para yu gun e teiwa. ");
INSERT INTO sll_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yal i haang iwe, mo yu namia. Na hana ya ime sinamua.” ");
INSERT INTO sll_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Te yal ta mini bani ya unangwo yal i, ari talhan para weni bring mining a holo sinamua. Te yal ta ganba baniya u tibi nangwo yal i, ganba baniya talhan panangwo i di kunu olamua. Yal ta hamen bani ya unangwo yal i, ari talhan hobi para ya ime sinangure, yal i tani mo dui dinamua. ");
INSERT INTO sll_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dire talhan wai pire hanere onangwo hobi di tibi olamua. ");
INSERT INTO sll_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Olamba yal taniga pir tere a i si ware molkimua. Yal ta pir tere a i si wa monangwo yali, God mongwo i tibi olimua. ");
INSERT INTO sll_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God yal ta bai nu sinangwo yal iwe, ha dinangwo i God grang pire dinamia. Dinangwo ipire, God Kwiang nu si olangure yong obilga wu binama di pino? Muru wu binanagure ha di tibi olangwo pamia. ");
INSERT INTO sll_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Irang iwe, Wang yong miling tere, talhan para weni i aleng bani emua. ");
INSERT INTO sll_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Te yal ta Wang i ogolo pir tere a i si ware monanga, mol pai gobari inanua. Yal tau Wang grang wine olkinanga, mol pai gobari irala di pino? Ta ikinanga pamia. God yong ki ei ni te monangwo monamua. ");
INSERT INTO sll_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ena Yisas arihobi nir bil tekimia, na gamnahobi obil arihobi nir bil tomingi. ");
INSERT INTO sll_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tomingere yal Yon ha dungwo ari tau doling bol pimba, Yisas ha dungwo i ari miki weni doling bomia dire Perisi yalhobi yu di han mongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dungwo i na gamnahobi Yisas kina pirere Yudia aidolere ere Galili probins namna dire omingi. ");
INSERT INTO sll_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pirere Sameria ganba pi momingi. ");
INSERT INTO sll_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sameria oo malgi ta haang Saika pi pa dimingi. Dimingere malgi iwe, kwiana moya yal Yekop u sina ta wang Yosep tongwo ganba i mala dungwi. ");
INSERT INTO sll_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Homa Yekop nir man wu ere hol nongwo iwe, ya di pangwi. Pangwo bani Yisas pi pa dire hol ongwo nigi de pire ami di mongwi. Ami di mongwo i hamen omare twel klok mongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mol pangure yol Sameria al ta nir holala dire u pa dungwi. Dungure Yisas yu ditongwi, “Nir hongi ta nenaminba?” ");
INSERT INTO sll_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Di te mongwo i na gina hobi homena bring si nenamna dire ere malgi omingi. ");
INSERT INTO sll_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ena yol Sameria al i Yisas yu ditongwi, “Ni Yuda yal irawe. Te na Sameria al irai molia. Talongwo na nir holga i nerala di dine?” Yuda arihobi Sameria ari hobi kina pana gale hawai ta di wakimia. ");
INSERT INTO sll_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ena Yisas al i yu ditongwi, “Ni nan God tobo pirari pare awai pire na tongwo irai maing, te nir honga na to di ni tega i na maing pinanba, ha sire wa dunua. Pir pa dina dama hong di na tenanga nir yangwo ni teralba.” ");
INSERT INTO sll_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dungure al i yu ditongwi, “Yahuno, nir man wu engwiwe, alba ala dimia. Ni mugu ta ere molkinia. Tal ire nir yangwo hol na terala di dine? ");
INSERT INTO sll_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nan yalhobi kwiana moya Yekop nir i man wu e na tongure hol ne mominia. Te homa weni Yekop wang aung hobi ire, kun bulamahau kul nongwo hobi ire dire, nir i hol nongwo nir dimia. Yekop yal bir momba, ni Yekop a ime ol teno?” ");
INSERT INTO sll_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dimba Yisas yu ditongwi, “Ari hobi nir i nenangwiwe, nere emgi nir hon gonamia. ");
INSERT INTO sll_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gonamba na nir ni teralga nenanga nere, emgi nir hon ta golkinania, yamoni mol pananga panania. Na nir i yal ta tegere, nomani sina i nir oleng erere ya panangwo yal i mol pai gobari inangure ari hobi pi nir digan bani bere monamua.” ");
INSERT INTO sll_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dungure al i yu ditongwi, “Yahuno, nir i na na tengere nere, emgi nir hon ta golkiralua. Te nir mala i girungwo tangwo hol ne molga bani molga i pisole ya molalua.” ");
INSERT INTO sll_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dimba Yisas yu ditongwi, “Ni bli si malgi pire winimbi gala dire a ire unana po.” ");
INSERT INTO sll_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dimba al i yu ditongwi, “Na winambi ta molkimua.” Dungure Yisas yu ditongwi, “Ni winambi ta molkimua dingiwe, ha pangwo kara dinia. ");
INSERT INTO sll_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Homa ni yal ana hol bani muru gal enia. Te omaga yal ta kina monga i, ni winimbi ta molkimua. Ni ha wo kara dinua.” ");
INSERT INTO sll_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dungure al i Yisas yu ditongwi, “Yahuno, omaga na ni han pa dia. Ni God hana togu yal monga pamua. ");
INSERT INTO sll_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na Sameria nabe hobi, pi hamen hul i molere, God maa e toma dimua.” ");
INSERT INTO sll_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dungure Yisas al i yu ditongwi, “Alhuno, hamen haung ta u tibi unangure, hamen hul ire, Yerusalem ire dire, hon ta maa e tekinaminga pamua. ");
INSERT INTO sll_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Na ha di ni tega i ogolo piro. Ni yol Sameria talhan ta hankirere, maa e te monia. Te God honagi i, Yuda ari yal ta aki di na tongure, nan yalhobi sigare kunaminua. Kunaminga i pirere na Yuda yalhobi God maa e te mominua. ");
INSERT INTO sll_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mominba, habang omaga u tibi umia ari para weni Nabe ha maing maa e terala di pinangwo i, gaung tani taman. Kwiang para God tegi dire ha pangwo dire maa e tenangwo pamua. Yu onangwo yal i Nabe wai hanangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God iwe, ari gaung hongwo tali ta holkima, kwia tani momia. Ena yal ta maa e terala di pinanga i, gaun tani taman. Kwian para God tegi dire ha pangwo dire maa e tenanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dungure al i yu ditongwi, “Ni ha dinga i na haya piria. Mesaia ta unangwo mere piriwa. Unangwo i haang Kraist, molere talhan hobi para weni nibil di na tenangwo mere piriwa.” ");
INSERT INTO sll_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dungure Yisas yu ditongwi, “Unamua dingiwe, na molere omaga ni kina ha di mobilua.” ");
INSERT INTO sll_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yu di te mongure, na gamnahobo u pa dimingi. Dire, “ayo Yisas al i kina ta tal ongwo ha wai ol mome?” di hamingi. Di haminba, “Yisas talongwo al i kina hawai one?” ditenaminba, gai golere han uning si olimingi. Te al i, “tal holo une?” di pinaminba, ere gai gole han uning si olimingi. ");
INSERT INTO sll_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ena al i nir hongwo mugu aidole, bli si malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Pirere arihobi yu ditongwi, “Na ari ta mongwo habal pire uminia. Para pinana wio. Yal iwe, na tal tau homa weni ol waga meri maing di tibi ol na tongure, ayo, Kraist mom mo, di hane wiwa.” ");
INSERT INTO sll_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dungure arihobi oo malgi aidole guru di Yisas mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ungwo gin iwe, na gamnahobi ha ura pangwo di tere, “Tisao, menan gongi homena nere molkino?” dimingi. ");
INSERT INTO sll_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Diminba Yisas yu di na tongwi, “Na homena ta nerala dire oliba, neralga homena i ni yalhobi han po sikinua.” ");
INSERT INTO sll_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dungure na gamnahobi nan ha diriyala ole yu dimingi, “Yal ara homena tenangwo nerala di dime?” ");
INSERT INTO sll_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Diminba Yisas yu di na tongwi, “Na homena neralua digiwe, yu pamia. Na nu sungwo uga yal i, ha di na tongwo meri, wine olere, honagi ol te pisolalga pamua. ");
INSERT INTO sll_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ena ni yalhobi krehaman ha yu dinia, Homena yare haba sui sui dire monaminga, homena aang denamua. Yu dinba, na di ni terala piro. U sina i han wabo dire hanega. Haya aang domia bulanga mere pamua. ");
INSERT INTO sll_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Homena yananga yal i tobo i molere, bulanga hobi kina para mol pai gobari inanua. Yanangwo yal i bulangwo yal i kina ereho miling panangure yasuri gun enamua. ");
INSERT INTO sll_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yal ta yangure yal ta bulimua, diga i ha pangwo kara diwa. ");
INSERT INTO sll_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yal ta u sina ta homena miling yare tul haning dere i wanangwo bani ni bulana pio. Yalhobi homa honagi nega dire olere, homena miling yangwo aang domia. Dongwo bani ni yalhobi homena mebin dangwo bulanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ena Sameria ari hobi iwe, al i Yisas ha boling ari hobi di tibi ol tomia pirere, Yisas pir tongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ena Sameria arihobi, Yisas mongwo bani ure, “Yal Yisas ye, na kina tau mol pai omingere nanua,” ditongwi. Ditongure Yisas ari haung sutani Sameria arihobi kina mongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mongure ari miki weni ure, Yisas grang wine olere pir tongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tere al i yu ditongwi, “Na yalhobi ni gran tani pirere, Yisas pir tekiminia. Yisas nin grang para pirere, omena hanere diminga yal i ari yal al para weni aki di na tongure sigare kuminga irawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ena hamen haung sutani wai sungure, Yisas na gina kina Sameria aidolere, ere Galili omingi. ");
INSERT INTO sll_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Omingere, Yisas nin yu dungwi, “God hana togu yalhobi nin ganbani haang ta paikimia. Paikimba, ere Galili ongwo, o, God hana togu yal umua dungure waminua.” ");
INSERT INTO sll_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ena Yisas Galili pi pa dungure ari hobi kina pana gangwi. Homa erin haung Yisas tal ta ongwo i hanere, pana gal tongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ena Yisas na gina kina Galili probins Kena oo malgi pi molere homa nir wo i hon ongure u wain gobere ongwo bani pi pa dimingi. Ena Kapaneam oo malgi gaman kene ongwo yal ta wang nibil ongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Omia irang ere mole pir momba, Yisas na gina kina Yudia pisolere, ere Galili umua dungwo pungwi. Pirere yal i doling bol ya pirere wana awai ol tenanba dire, hong di te i ongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ongure Yisas yu ditongwi, “Ni yalhobi tal guma hon dongwo olga hankinanga pir na tenano? Tekinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dimba gaman kene ongwo yal i yu ditongwi, “Yahuno, na wana omaga gonangwo pamia haya bli si wo.” ");
INSERT INTO sll_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dungure Yisas yu ditongwi, “Ni wani i ya momia, ere po.” Dungure yal i Yisas ha dungwo i ha pangwo dimua di pire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ere pi mongure honagi ari ta u bangi pa dungwi. Pa dire yu ditongwi, “Wani irai aire heba nere ya moni momua.” ");
INSERT INTO sll_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dungure irang yu ditongwi, “Hamen haung talmere mongere gir i ya mome?” dungwi. “Ongi omare wan klok gaung nega dire wai simua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dungure irang i yu nomani si pungwi, “Ayo, Yisas ongi omare wan klok wani u wai omua di na tongwo mere irai, u wai omua,” dipungwi. Di pire irang tani kungwo hobi algi doling bole Yisas grang wine olere pir tongwi. ");
INSERT INTO sll_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ena Yisas Yudia aidolere Galili pire tal guma hon dongwo sutani Galili ganba bani i tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ena moli pire Yuda ari hobi erin bir ta u mala ongure Yisas ere Yerusalem malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ena Yerusalem malgi bani kun sipi sipi hona grang ta mala nir digan mongwo, haang Betesda. Mala i hona grang ana hol bani muru ke aine mena olungwi. ");
INSERT INTO sll_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Olungure mala i ari nibil ongwo miki weni ire, omeling gi dungwo ire, kebering aling ki sungwo ire dire, mongwi. (Mongure ensel ta nir digan ala pire nir i hone pera kungwi. ");
INSERT INTO sll_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kungwo gin iwe, ari hobi gintani nir ali namna dire han momba, yal taniga homa iri si nir ala pire u wai ongwi. Omia homa iri sungwo yali u wai omua di pungwi.) ");
INSERT INTO sll_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ena yal ta me erin tri pela ten et yia molere nibil pai mongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mongure Yisas pi hamba, hamen haya nibil omia ul pare pare momia hangwi. Hanere yu ditongwi, “Ni si hon erala di pino?” ");
INSERT INTO sll_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dungure nibil ongwo yal i yu ditongwi, “Yahuno, nir ho tongwo gin i, na yal ta na aule i pi nir ali olangure u wai nalba? Na nan nalga pamiba, yal ta iri si homa pire na pia si emgi olimua.” ");
INSERT INTO sll_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dungure Yisa yu ditongwi, “Ni aire kugal ire hol wayo.” ");
INSERT INTO sll_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ditomia yal i yulang gaung para nimni mole, kugal kri di ire hol wangwi. Wangwo gin iwe, Sabat habang mongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Momia Yuda ari hobi u wai ongwo yal i yu ditongwi, “Omaga erin bir mominia, kugal kri di wakio.” ");
INSERT INTO sll_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dungure yal i yu ditongwi, “Na awai ol na tongwo yal iwe, yu di na tomia, kugal i nin kri di wayo dungwo meri waiwa.” ");
INSERT INTO sll_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dungure ari hobi hon sirin bol tongwi, “Kugal kri di wayo di ni tongwo yal i haang arawe?” ");
INSERT INTO sll_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dimba u wai ongwo yal i Yisas hang pirkimia nomani si mongwi. Ari yal al miki weni u yobile momia Yisas haya ere ongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ena emgi Yuda ha maing oo ala awai ol tongwo yal i momia, Yisas hanere yu ditongwi, “Pino, ni omaga u wai onia. Tal nigi dongwo hon olkio. Onanga God tal pring oun weni dongwo ni tenangure inanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dungure yal i ere pire Yuda ari hobi yu ditongwi, “Na awai ol na tongwo yal iwe, haang Yisas.” ");
INSERT INTO sll_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ena Yisas Sabat habang awai ol tomia, Yudari hobi hanere, tal nigi dongwo kebering hole ol tenamna dire ongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Omba Yisas Yuda ari hobi yu ditongwi, “Na nabe haung haung honagi ol momia. Ol mongure na kina ereho obilua.” ");
INSERT INTO sll_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yu dungwo i Yuda ari hobi pire nega dire Yisas si gonamna dire ongwi. Ena Yisas Sabat haung Lo mana dungwo pir ole honagi omio, te God na nan nabe weni momua dimio, te yali ha dungwo hobi God na kina kunung mobilua dimia, nigi de pire si gonamna dire ongwi. ");
INSERT INTO sll_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ena Yisas yu dungwi, “Na ha weni di ni teralia. Hamen nabe Wang Weni na molia. Molere na nan piriga meri pire ta olkiwa. Nabe tal ongwo meri hanere oliwa. Nabe na kina ereho obilua. ");
INSERT INTO sll_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nabe wang na iwe, yong miling na te molere, honagi para weni nibil di na te momua. Emgi honagi bir weni nibil di na tenamia. Tenangwo i olalga ni arihobi hanere, ganulun dinanua. ");
INSERT INTO sll_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ena Nabe ari gongwo hobi tau uling yungwo airungure mol pai hon tomua. Tongwo tal i Wang na ari talime tal nigi dongwo pring kina wangwo hobi tau nu ke teralgere, sigare kunamua. ");
INSERT INTO sll_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nabe nin ari hobi ha hol ol tenama di pino? I ta ol tekinamia. Yulang na na tomia na ari hobi ha hol ol te moliwa. ");
INSERT INTO sll_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Molia Nabe haang a yuwo olanga meri Wang na para hana ayuwo olanga pamua. Yal ta Wang na hana a yuwo olkinga i, na bai nu si olungwo yal Nabe ere para haang a yuwo olkinanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na ha weni kara di ni teralga piro. Yal ta na grana pirere, na bai nu si olungwo yal i ha dungwo doling bole a i si wanangwo i, mol pai gobari haya imua. Emgi ha hol bani ta ikinamua. Gongwo meri gomiba, omaga sigare kule u wai omua. ");
INSERT INTO sll_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ena habang ta u tibi namua diga i omaga u tibi umua. Habang i gongwo hobi God Wang na ha diga pirere, tau ogolo pir na tenamba, tau pir uning si monamua. Te pir na tenangwo hobi mol pai wai haya imua. ");
INSERT INTO sll_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nabe iwe, mol pai bling memini yal momia. Mongwo tal i Wang na ere yulang na tongure, mol pai bling memini yal ere moliwa. ");
INSERT INTO sll_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te Nabe yulang wang na na tongure Ari Wang Weni na ari hobi kwi mol tere ebir si te molalga pamua. ");
INSERT INTO sll_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ha i pirere nomani si gogo dalkio. Habang u tibi nangwo gin i, ari yulagi engwo bani yone pai mongwo hobi, na nuguna pirere, ere mena unamia. ");
INSERT INTO sll_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Urere tal wai ongwo hobi mol pai hol nangure, talime tal nigi dongwo ongwo hobi ha hol bolimbani monamua. ");
INSERT INTO sll_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ena na tal olgiwe, na nan piriga mere pire ta olkiwa. God Nabe grang piriga mere i wine olere ari hobi ebir sire ha hol ol te moliwa. Na nan piriga mere pire ha hol ta olkia, na nu si olungwo yal i grang wine ole olga wai pamua. ");
INSERT INTO sll_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ha iwe na nan hana tani diralga kunung panamo? I ta paikinamia. ");
INSERT INTO sll_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yal ta ere momia. Molere na ha diga mining aki dungwo pinua. Pinga i ere ha pangwo kara dungwo piriwa. ");
INSERT INTO sll_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Homa ni yalhobi yal tau Yon mongwo bani nu si olingere, pirere Yon ha pangwo meri kara di tibi olungure, pinua. ");
INSERT INTO sll_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yal ta na ha diga mining aki dikinangwo tamamua. Na piriga God ni yalhobi ni aki di ni tenama di pire di tibi oliwa. ");
INSERT INTO sll_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon iwe, kewa lampi dongwo meri momia dongure kurani si ari mongwo nomani gaung bani emua. Engwo i ni yalhobi yon horega onangure wai pire haung obilga pir tenua. ");
INSERT INTO sll_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yon na ha diga mining aki di na tomba, ta aki di na tongwiwe, mo yu omua. Ongwo meri, Nabe honagi na tongwo meri na ol pisolia. Olgere, hana mo mibi ongwo hangiwe, o God yali na bai nu si olungwo pamua di hania. ");
INSERT INTO sll_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te Nabe na bai nu si olungwo yal iwe, na ha diga mining aki ni na te mongwo bani momua. Momba, ni yalhobi grang pirikirere, te gumang hankire dinua. ");
INSERT INTO sll_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nabe na bai nu si olimba, grang wine olkinia, Nabe hakuria boling kul ni teiba, pir sina ekinua. ");
INSERT INTO sll_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mol pai gobari inanga ipire ha maing buku kere pir monia. Monba, ha maing buku i, na nan hana nibil di tibi ol ni tomba, pir tekinua. ");
INSERT INTO sll_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ni yalhobi na molga bani ure, mol pai wai inanga ha pirikinua. ");
INSERT INTO sll_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ena na iwe, ari maa e na tenama di pirikiwa. ");
INSERT INTO sll_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na ni yalhobi haya ni han po sia, yon milni God tekinua. ");
INSERT INTO sll_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Te na iwe, Nabe mongwo bani yulang ire ya ime wiiba, ni yalhobi ereyu pir na tekinua. Tekinba, yal ta nin gaung pir yuwo ere monga bani unangwo gin i, ganulun dire pir tenanua. ");
INSERT INTO sll_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ni yalhobi enin abin nin wama dire maa e tenga i wai pinua. Pinba, God tani weni momia, ni tal onga wai piriwa, di na tenama di pirikinua. Pirikinga ipire, ni yalhobi tal ole God pir tengere nima name? ");
INSERT INTO sll_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nabe mongwo bani ni tal ongi na di mere si tenama di pino? I ta si tekiralia. Nan kwiana moya Moses pir tenga yal iwe, nin monga maing di ba bonangure gai gonanua. ");
INSERT INTO sll_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yal Moses ha dungwo ogolo pir tenanga na para pir na tenanba, pir tekinia, na para pir na tekinua. Moses na hana kuria ha di engwo dimia. ");
INSERT INTO sll_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dimba, ni yalhobi yal Moses ha dungwo meri pir tekinia, na diralga tal ole pir na tenane?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ena Yisas ha i di te pisolungure ere nir digan Galili Taibirias bina hoibi omingi. ");
INSERT INTO sll_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Omingere ari tabin bir weni u ku bole tal guma hon dongwo ole nu nibil awai ongwo i hanere, Yisas doling bol ongwi. ");
INSERT INTO sll_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ena Yisas na gina kina hamen hul mo pirere ami di momingi. ");
INSERT INTO sll_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mominga gin i, Pasoba erin haung mala ungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ena Yisas ari mongwo bani han wabo dimba, ari miki weni u tabin simia hangwi. Hanere Pilip yu ditongwi, “Nan homena makena bring sire ari hobi tomingere nename?” ");
INSERT INTO sll_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisas ha ta dinangwo pirala dire sirin bol tere Pilip kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ena Pilip Yisas yu ditongwi, “Nan tu handred kina ipire homena bring simingere ari hobi obil nenangwo kunung benamua.” ");
INSERT INTO sll_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dungure Yisas gamahobo ta Saimon Pita ebering Endru mole yu dungwi, ");
INSERT INTO sll_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kumil ta mongwo ya, breti nigi dongwo ana hol bani ire, pisi su ire dire, dima dungwiyawe. Dimba ari hobi miki weni momia homena gi obil tomingere kunung bekinamua.” ");
INSERT INTO sll_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dimba Yisas yu di na tongwi, “ari hobi ami do di to.” Timiya kul miki weni bomia, bongwo bani ami di mongwi. Mongwo hobi iwe, yagr namba i mu dire miki weni paib tausen momia. ");
INSERT INTO sll_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ena Yisas homena breti ire, “God homena na tenga wai piriwa” dire du dire arihobi ebir si tongwi. Tere pisi su ire ongwo meri yu olere, ebir sire arihobi tongwi. ");
INSERT INTO sll_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tongure ari hobi nere miing ongwi. Ongure Yisas na gamnahobo yu di na tongwi, “Homena nere egere olungwo tal i, i ku bole gal giro. Tau aidolana di pirikiwe.” ");
INSERT INTO sll_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dungure na yalhobi homena breti ana hol bani nere egere olungwo tal i, i ku bole gal basket ana holo holo kebena sutani girimingi. ");
INSERT INTO sll_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ena ari hobi homena i nere tau egere olere, Yisas tal guma hon dongwo omia hangwi. Hanere yu dungwi, “Aye, God hana togu yal unama dungworai, omaga ganba baniya u tibi ungwo haminge.” ");
INSERT INTO sll_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dimia Yisas pungwi. Pungure ari hobi ure Yisas na nan singaba king monangure kiana ol gogo dal teralua di pire a i si mongwi. Mongwo sina i Yisas simeng bol tere haya ere hamen hul omia, ari hobi hankungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena hamen girungure na gamnahobi ere nir digan bina omingi. ");
INSERT INTO sll_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pirere ere sipi ala pire Kapaneam namna dire omingi. Hamen hama sungure Yisas humia na yalhobi nan pi momingi. ");
INSERT INTO sll_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Momingere hamen hair mu dinba ure nir sii bir weni umia. ");
INSERT INTO sll_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na yalhobi sipi pul si pi nir mini sina omingi. Omingere Yisas nir aulung bani bare u pa dungwi. Dimia na yalhobi hanere milna sigiri gomingi. ");
INSERT INTO sll_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gominba, Yisas yu di na tongwi, “Na nan wiya, kul pirikio.” ");
INSERT INTO sll_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dungure na yalhobi “ala wo” diminba, sipi gintani u nir bina pa dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ena tanangwo ari yal al hobi Yisas hamen hul omiraya, unama dire nir digan bina i kwi han mongwi. Yisas na gamnahobo kina ereho sipi ala i oma di pirikimia, na gina hobi nin omiraya di hangwi. ");
INSERT INTO sll_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ena Taibirias sipi tau Yisas breti bigi dire gamahobo kina kuria sire nongwo bani u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","U pa dungure yalhobi Yisas gamnahobo kina umua dire han momba, hungure yalhobi hon wa du i Kapaneam ongwi. ");
INSERT INTO sll_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ena yalhobi wa du i pi nir digan bina pire hamba, Yisas momia hanere yu ditongwi, “Tisao, ni tal haung u timiya pa dine?” ");
INSERT INTO sll_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dungure Yisas yu ditongwi, “Na ha pangwo di ni teralia piro. Ni yalhobi homena breti ni tega ne miin onga ipire na wa dunba, te na yulang ire tal guma hon dongwo olga i pirere na wa dukinua. ");
INSERT INTO sll_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni yalhobi homena wo nengiwe, yo te mena olinia, ipire honagi tani olkio. Nomani kwian honagi para i mu dire ol i pire sigare kule mol pai gobari inanga pamua. Te Nabe God yulang haya na te pisolimia homena iwe, na Ari Wang Weni molia, ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dungure yalhobi yu ditongwi, “Na yalhobi tal olere God honagi ol tenamne?” ");
INSERT INTO sll_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dungure Yisas yu ditongwi “God honagi ni yalhobi onanga yu pamia. God na nu si olungwo yal molga ipire, pir na tere grana wine ol na to.” ");
INSERT INTO sll_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dungure yalhobi yu ditongwi, “Ni tal guma hon dongwo tal onanga na yalhobi hanere pir ni tere gran wine onamne? Te tal honagi ongere hanamne? ");
INSERT INTO sll_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na kwiana moya yalhobi ganba po engwo bani menan gol molere, homena ta haang mana God tongwo nomia. Nongwiwe, ha maing mining ta yu pamia, God homena ire pia si manbi ole yali toma dimua.” ");
INSERT INTO sll_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dungure Yisas yu ditongwi, “Ni ha weni kara dinba, na di ni teralga piro. Yal Moses iwe, homena ni tekungure, Na Nabe tani homena ni tongwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Homena breti God ni tongwiwe, yal ta hamen bani pisole, ya ime ure, ganba ari mol pai i tibi ole ni tomua.” ");
INSERT INTO sll_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dungure yalhobi yu ditongwi, “Yal Yisas ye, ni homena i mone na te monange.” ");
INSERT INTO sll_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dungure Yisas yu ditongwi, “Ni yalhobi yulan homena na tani molia. Te yal ta na dolna bonangwiwe, kwian nomani menan ta golkinamua. Te yal ta na pir na tere wa monangwiwe, nomani kwian nir ta gol molkinamua. ");
INSERT INTO sll_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ena ni yalhobi na haya na han po sinba, pir na tere wine ol na tekinua. ");
INSERT INTO sll_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nabe ari tau i na terala di pinangwo hobi na pir na tere dolna bonamua. Bonangwo hobi na ere po di teral mo? I ta ditekiralua. ");
INSERT INTO sll_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na nan piriga mere pire hamen bani ya ime ure tal yu ta olkiralua. Na bai nu si olungwo yal i grang wine ol tere olalua. ");
INSERT INTO sll_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yal iwe, yu onama dire na bai nu sire honagi ana bani emia. Engwo i memini yu pamia. Ari yal al tau nu ke tere i na kebena bani tabin sinangwo hobi, na ta aidolalga paikimua. Te emgi habang kul enangure hamen ganba wai sinangwo gin iwe, uling yugere airangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nabe iwe, yu nomani si pimia. Ari tau Wang na na hanere, pir na tere wine ol na tenangwo hobi, mol pai gobari ire mol panangwo panamua. Te habang kul enangwo gin i, uling yugere airangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ena Yisas, “Na nan hamen homena molere ya ime wiwa,” dungure Yuda yalhobi para para ha di tole ware yu dungwi, ");
INSERT INTO sll_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Yisas iwe, yal Yosep wang irai momia, nan irang aang para han po siminga irawe. Talongwo hamen bani ya ime wiya dime?” ");
INSERT INTO sll_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dungure Yisas yu ditongwi, “Ni yalhobi ha di tole wakio. ");
INSERT INTO sll_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yal ta yamoni na dolna bonanga paikimia. Na Nabe yal ta ni aule i ure na molga bani olangwo yali, na dolna bonanga pamia. Bonangere emgi habang kul enangwo gin iwe, ni ulni yugere airanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hana togu yalhobi ha di buku ala engwo i, God nin arihobi nir si tenangure pinangwo pamua. Yal ta Nabe grang pire hanere wine oliwa dingiwe, na dolna bonanga ha wo dinua di hanamua. ");
INSERT INTO sll_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yal ta Nabe gumang hankimia. Na nan tani Nabe God kina si daule mole gumang hanere wiwa. ");
INSERT INTO sll_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ena piro. Yal ta na pir na tere wa monanga yali, mol pai gobari ire mol pananga pananua. ");
INSERT INTO sll_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nan nomani mol pai wai homena moliwa. ");
INSERT INTO sll_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Homa weni kwiana moya hobi ganba po engwo bani mole homena haang mana nere moli pire emgi gol wai simua. ");
INSERT INTO sll_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gomba, hamen homena ta ya ime umia. Yal ta nenangiwe, ta golkinanua. ");
INSERT INTO sll_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na hamen homena molia, hamen bani aidole ya ime wiwa. Yal ta mol pai homena i nenangi, nere ya mol pananga pananua. Na homena breti ni tegiwe, na nan gauna miing ni teiwa. Teya ganba ari yal al hobi nere mol pai wai inamua. Na ha weni kara di ni teya ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ena yu dungure Yuda ari hobi nin ha bolbin dungwi, “Yal i gaung miing nan nenanua, dungwo i talongwo di na tome?” ");
INSERT INTO sll_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dungure Yisas yu ditongwi, “Piro. Ari Wang Weni na gauna miing nekire, algi nekire dinanga, mol pai wai ta ikinanua. ");
INSERT INTO sll_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Te yal ta na gauna miing nere algi nere dinanga yali, mol pai gobari ire ya mol pananga pananua. Emgi habang kul enangwo gin iwe, ulni yugere airanua. ");
INSERT INTO sll_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ena na gauna miing iwe, algi kina homena nima ongwo dimia. ");
INSERT INTO sll_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yal ta na gauna miing nere algi nere dinaga yali, ni na kina si daule mol i nabilga nabilua. ");
INSERT INTO sll_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nabe mol pai bling memini hong yal i na nu sungure wiwa. Ugere bling memini yal i yulang na tongure na ere mol pai bling memini yal moliwa. Molia yal ta na gauna miing nenangiwe, mol pai yulana ni tegere ire ya mol pananga pananua. ");
INSERT INTO sll_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Panangiwe, na homena molere hamen bani aidole ya ime ugere nenua. Homena nenga iwe, kwiana moya homena mana nere mol i pire, gongwo meri ta nekinua. Homena i nenaga mol pai gobari ire ya mol pananga pananua.” ");
INSERT INTO sll_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dire Yisas Kapaneam ha maing oo ala i ha nir si tere ha i ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ena Yisas ha dungwo i doling bongwo ari miki weni pirere yu dungwi, “Ha dungwiwe, na yalhobi pir oun de iminia. Ara ogolo pire wine oname?” ");
INSERT INTO sll_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yu dire momba, Yisas ha di tole wangwo i haya han po sungwi. Sire yu ditongwi, “Na ha di ni tegarai ni yalhobi pir oun denanga na pisolano? ");
INSERT INTO sll_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na Ari Wang Weni molia, inaa di ere hamen bani pi molalga talwa di pinane? ");
INSERT INTO sll_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Kwiang aki di na tongure, mol pai wai ominia. Te gauna iwe, aki di na tenangure mol pai wai inamno? I ta ikinaminia. Na grana ha di ni tega i, mol pai ire, God Kwiang ire mol pai wai onanga pire di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Teiba, ni yalhobi monga sina i tau nomani si pir na tekinua.” Homa Yisas ari nomani si pir tekinangwo hobi haya pir po simua. Te bai tal sinangwo yal i ere haya pir po simua. ");
INSERT INTO sll_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ena Yisas ha ainere yu ditongwi, “Nabe God yal tau yulang tere aki di tekinangure, na molga bani ure dolna bonamo? I ta bolkinamia. Homa God yulang tenangure na molga bani ure dolna bonangwo pamua. Ha wo kara diwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ena Yisas ha i ditomia doling bongwo ari miki weni pire Yisas mobing hal wa tere ere ongwi. Pire emgi hon ure Yisas doling bolkima. ");
INSERT INTO sll_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yu omia Yisas na gamnahobo ana holo holo kebena sutani yu di na tongwi, “Ni yalhobi para na na pisole nan mo?” ");
INSERT INTO sll_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dimba Saimon ha yu ditongwi, “Yal Yisas ye, na yalhobi ni aidole makena naminga han dine? Ni hani iwe, wine oli pire, mol pai gobari ire mol panaminga panaminua. ");
INSERT INTO sll_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni God mongwo bani kina si daule monia di piminga irawe.” ");
INSERT INTO sll_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dungure Yisas yu di na tongwi, “Ni yalhobi ana holo holo kebena sutani nu ke ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Teiba, ni monga sina i yal ta kumo pamua.” Ena kumo haang engwo yal iwe, yal Saimon wang Yudas momia. Yal iwe, Keriot ganba hong yal han dimia. Yal Yudas iwe, Yisas grang wine ongwo yal weni momia, bai tal sikinangwo mere sungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ena habang ta Yisas Galili ganba wa mongwi. Molere Yuda ari hobi Yisas sirala di omia hanere emgi hon Yudia ganba nangwo ha pirikungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kire momba, homena aang domia Yuda ari hobi oo tabil sire gal mole erin mongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ena Yisas ebering hobo Yisas yu ditongwi, “Timiya aidole Yudia ganba namna pano. Omingere gaminahobo irai ni tal guma hon dongwo ol tengere hanamia. ");
INSERT INTO sll_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ari tibi monangwo yali, tal kul si onamo? I ta olkinama. Yal ta guna hana ari hobi para pinama dire sina weni mole i tibi olungwo haminua. Yu ongwo meri onanga ari hobi ni gun han pinamua.” ");
INSERT INTO sll_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ebering hobi Yisas ha dungwo doling bole a i si wakire yu dimia. ");
INSERT INTO sll_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ena Yisas yu ditongwi, “Ni yalhobi habang girungwo tangwo moli unga moli nania, na habang olo mala humua. ");
INSERT INTO sll_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ari para weni ni yalhobi ta yong ki e ni tekimba, na tal nigi dongwo ongwo di tibi ol waga i hanere yong ki e na tomua. ");
INSERT INTO sll_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ni yalhobi nin pi erin molere homena nenana pio. Na nalga ha pirikiwa. Na nalga haung kul ekimua.” ");
INSERT INTO sll_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ditere Galili ganba ya mongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ena Yisas ya mongure ebering hobi erin habang erin mole homena si gal nerala dire ere ongwi. Ongure emgi Yisas u tibi engure ari ta hankima, kul si ongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ena Yuda ari hobi erin habang i Yisas unam mo dire kwi han mongwi. Mole, “makena mome?” dire sirin sirin bole wa du i ongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ena ari hobi haning hol wangwi. Ware tau “yal wai momua” dimba, tau, “hasu kela kul wangwo yal momua” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dire ha ta di tenamba, Yuda ari hobi kulung pire ha ta di tibi ol tekima. ");
INSERT INTO sll_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ena erin i tau mol sina mugu sungure, Yisas ere Yuda ari bling mining ha maing oo ala pire ari hobi ha nir si te mongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mongure Yuda ari hobi ha nir si tongwo pirere nomani si gogo dale yu dungwi, “Yal i sikul dikimiraya, ha maing makena i ure nir si tome?” ");
INSERT INTO sll_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dungure Yisas yu ditongwi, “Na ha nir si ni tegiwe, na nan hana taman. Na nu sungwo yal God grang pire di tibi ol ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","God yulang na tomia pire ha pangwo di tibi oliwa. Yal ta God grang wine olala di pinangiwe, na ha pangwo dimin mo, hasu dimin mo, emgi nin ebir si pinanua. ");
INSERT INTO sll_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yal ta nin nomani sinangwo wai panangwo di tibi ol tenangwo i, nin gaung pir yuwo ere dinangwo pamua. Pamba, yal ta nu si olangwo yal i gaung pir yuwo erala di pinangwo yali, nin gaung pir yuwo enangwo paikimia. Hasu kuni talime gerai ta i tibi olekire amane monamia. ");
INSERT INTO sll_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Homa yal Moses God Lo krehaman ha para di ni tongwo pinia. Pinba, yal taniga wine olkinua. Wine oliwa dinba, krehaman ha mining ta yal ta sigolkio dimba, na na si golala di onia. Olere ha i wine olkinua.” ");
INSERT INTO sll_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dimba ari hobi yu ditongwi, “Ni kumoigi pania, ara ni si goname?” ");
INSERT INTO sll_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dimba Yisas yu ditongwi, “Na tal nimni mongwo ta olga hanere nomani gogo siniraya. ");
INSERT INTO sll_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Homa yal Moses wani hobi gaung banta bol olo di ni tomiraya. Tomiba, tal iwe, hongebe kwiana moiya memini pangwo ongwo meri omaga ya ol monua. ");
INSERT INTO sll_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","God Lo krehaman ha Moses wine olala di pire, Sabat habang kumil migi gaung bol olinia. Ole tenba, na nibil pangwo yal ta Sabat habang awai ol tega wigi sire u wai ongwo i, ni yalhobi talongwo nigi de pir na tene? ");
INSERT INTO sll_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Omin ya mone hangi hanere ebir sinanga paikimia. Nomani ogolo si piri kunung olere ebir sinanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ena Yisas yu dungure Yerusalem malgi ari tau yu dungwi, “Ari hobi yal ta si gonaminua dungwo yal irai momio? ");
INSERT INTO sll_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hanega. Yal i ari maulung bani molere ha dimia. Dimba ari hobi ha ta sikir maure diguane wa tekimia. Yuda ari singaba yal i singaba Kraist moma di ham mo? ");
INSERT INTO sll_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Singaba Kraist monangwo oong maning han po sikinaminba, yal iya oong maning han po siminga irawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ena Yisas ha maing oo ala ya molere ha nir si te mongwi. Mole gala bir dire yu dungwi, “Ni yalhobi na na hanere, oona mana han po siwa di pino? Pinba na nan piriga mere pire ta huya. Nabe na nu sungure wiwa. Yal God ha pangwo hong yal momba, ni yalhobi han po sikinua. ");
INSERT INTO sll_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na yal i kina si daule mole na nu sungure wiya, yal i maing na nan han po siwa.” ");
INSERT INTO sll_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dimiawe ari hobi han honamba, yal i habang olo werigi dikimia han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ena ari miki weni Yisas pir tere ha dungwo a i si mole yu dungwi, “Kraist emgi ure tal guma hon dongwo onangure, yal i tal ongwo i ya ime sinamo? Ta sikinamia. Kraist yal i para mongwo haniwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ena ari hobi haning hol wamia, Perisi yalhobi pirere ha maing oo kene ongwo hobi ditongwi. Ditere ha maing oo kene ongwo hobi ire, Perisi yalhobi ire dire, polisman tau nu si olungure, Yisas han sirala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ena Yisas ha yu dungwi, “Na haung obilga ni yalhobi kina mobilua. Molere ere na bai nu si olungwo yal i mongwo bani siina di nalga pamua. ");
INSERT INTO sll_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nalgere emgi ni yalhobi na wa dunanba, hon ta na hankinanua. Pi molalga bani ni yalhobi tal ole ure na hanane?” ");
INSERT INTO sll_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dungure Yuda arihobi nin di wama tere yu dungwi, “Yal i u makena nangwo nan hankinaminga pire dime? Yal i yol Griki ganba Yuda ari tau pi mongwo bani pire ha maing nir si tenama nam mo? ");
INSERT INTO sll_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ni yalhobi na wa dunanba, hon ta na hankinanua. Pi molalga bani ni yalhobi tal ole ure na hanane? dungwo irai memini pirkiminue,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ena erin i wai sinama dire ku bir weni bole mongwi. Mongwo gin iwe, Yisas u aire mole gala bir dungwi, “Yal ta nir gonangwo na molga bani ure nenama. ");
INSERT INTO sll_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Te yal ta na ha diga i doling bole pir na tere monangwo i, yong sinali nir kung sungwo mere aine aine pai monangwo monamua. Ha maing mining ganing ha yu dire bole emua.” ");
INSERT INTO sll_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yal ta Yisas pir te wanangwo God Kwiang inangwo i pire Yisas ha yu di emia. Habang gin i, Yisas manbi mole God kina si daule molkimia, God Kwiang olo ya ime huma. ");
INSERT INTO sll_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ena ari tabin hobi Yisas ha dungwo i pirere yu dungwi, “God hana togu yal ta unama dungwo irai yal i weni momue.” ");
INSERT INTO sll_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dimba yal tau yu dungwi, “A, i ta molkima. Singaba Kraist momue.” Dimba yal tau yu dungwi, “A, singaba Kraist Galili ganba u tibi hunamia. ");
INSERT INTO sll_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ha mining ganing ta yu pamia, Kraist iwe, Debit gang momia. Molere Betelehem Debit oo malgi kul enamua dimiraya.” ");
INSERT INTO sll_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ari hobi sikira dire tau “momua”, tau “molkimua” di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tau Yisas han honamba, yal ta pire Yisas aling su a i si molkungwi. ");
INSERT INTO sll_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yu ongure polisman hobi hon ere pi ha maing oo singaba, Perisi hobi kina mongwo bani ongwi. Ongure yu sirin bol tongwi, “Yal i aule ire hunia, talongwo one?” ");
INSERT INTO sll_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dungure polisman yalhobi yu ditongwi, “Homa Yisas ha dungwo tal i yal ta yu dinangwo hankiminga irawe.” ");
INSERT INTO sll_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dungure Perisi yu ditongwi, “Yal i ni yalhobi para kela kul ni tongwo time. ");
INSERT INTO sll_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na gamna hobo kaunsil yal ta mo, Perisi yal ta yal i ha dungwo nomani si pir tomo? Ta pir tekimia. ");
INSERT INTO sll_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tekimba, ari tabin hobi Moses God krehaman ha i ogolo pirikimia, i bolimbani olimua. Olungure God yong ki ei tere gumang bani kun yo hau ire ungwo mere han monangwo monamua. ");
INSERT INTO sll_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ena Yuda ari kaunsil yal ta Nikodimas homa Yisas mongwo bani ure pir tongwo yal iwe, omaga mole yu ditongwi, “Nan krehaman ha iwe, yu pamiraya. Yal ta ha dinangwo pirekire, ha hol ya moni going hane ol tenaminga paikimia. Ha dinangwo homa pirere, oun denangwo emgi ha hol ol tenaminga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Dimba ari hobi yu ditongwi, “Ni Galili yal mono? God hana togu yal ta Galili ganba u tibi hunamua dire ha maing buku di engwo pamia, ni kere pirikino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(Ena ari hobi para ere hona hona omba, Yisas ere hamen hul Olibe ongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pi molere honmil sinamoki ere ya ime ure ha maing bling mining oo ala ongwi. Ongure ari hobi para u ku bongure ha maing nir si te mongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mongure God Lo krehaman ha nir si tongwo hobi ire, Perisi tau ire dire, al ta yal wou sungure, aule ire pire ari hobi mongwo maulung bani engwi. ");
INSERT INTO sll_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ere Yisas yu ditongwi, “Tisao, al i yal ta wou sungwo hanere aule ire uminua. ");
INSERT INTO sll_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nan krehaman ha memini pangwo yal Moses yu di emiraya, al ta yu onangwo kwahulu ire nugu sigu di olo dimiraya. Dimiraba, ni tal onama di pine?” ");
INSERT INTO sll_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Dire ha holere Yisas ha di mere si tenamna di pungwi. Pimba Yisas ikwi bole aling miling ganba bani mining bongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bol mongure ari hobi sirin sirin bol tongure, Yisas hon han piga dire yu ditongwi, “Ni yalhobi monga sina i yal ta tal nigi dongwo olkinanga prin paikinangure wigi sire monanga yali, homa al i hulu nugu sigu dinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yu ditere hon ikwi bole ganba mining bongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ena yalhobi ha i pirere, gai gole tan tani yoro di maini ongwi. Pire singaba hobi homa engure gamahobi emgi ere ongwi. Ongure Yisas nin mongure al i kina ereho mongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mongure Yisas aire mole al i yu ditongwi, “Alhuno, yalhobi ni ha hol ol ni tongwo irai molkimia ere omo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Yal Yisas ye, para ere omua,” dungwi. “Na para ha hol ol ni tekia. Ni ere malgi pirere emgi tal onga tali hon olkio,” ditongwi.) ");
INSERT INTO sll_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ena Yisas hon aine arihobi yu ditongwi, “Na iwe, ganba kewa lampi molia. Yal ta na na dolna bonanga yali, si bongwo ali molala di pino? I ta molkinana. Kewa dere kurani sungwo bani mol pai ol i nanga nanua.” ");
INSERT INTO sll_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dungure Perisi yalhobi Yisas yu ditongwi, “Ni nin pinga meri pire dinia. Dingiwe, u hasu pamua.” ");
INSERT INTO sll_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dungure Yisas yu ditongwi, “Ogolo pir kun ole dikinia. Na nan molga maing di ni tega i ha pangwo kara di ni teiwa. Na kwaling ta ure kwaling ta nalga hol i para pir po sire molia. Moliba ni yalhobi na kwaling ta ure kwaling ta nalga hol i para pir po ta sikinia. ");
INSERT INTO sll_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Na ganba ari hobi nin memini pangwo ebir singa tal sinia. ");
INSERT INTO sll_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na iwe, yal ta yu ebir si tekiwa. Tekiba, gin ta yal ta ebir sire ha hol ol teralga hol wai ol teralga pamua. Na nan ol teralga taman. Nabe na nu si olungwo yal i kina ereho si daule moli pirere, ol teralga pamua. ");
INSERT INTO sll_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ena ni yalhobi krehaman ha yu pamiraya. Yal sutani grang u tani nangwo i ha pangwo dinamia. ");
INSERT INTO sll_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Te na ha diga i, na nan dima di pirikio. Nabe na bai nu si olungwo yal i kina ereho si daule mole grana u tani obilua.” ");
INSERT INTO sll_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dungure ari hobi yu ditongwi, “Nabin ma mome?” dungwi. “Na Nabe kina na hankinia. Na molga maing han po sinanga, Nabe maing para han po sinanga pamba,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ha maing oo weran ta awai moni olungwo bol bani Yisas molere ari hobi ha yu ditongwi. Ditomba ari hobi ta han sikima. Han sinangwo habang werigi dinangwo sinamba, werigi dikimia han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ena Yisas hon ainere yu ditongwi, “Na ere nalia. Nalgere ni yalhobi na wa dunanba, tal nigi dongwo ol wanga pring pai ni tongwo bani gonanua. Na nalga hol i dolna bolala di pinanba, ta bolkinanua.” ");
INSERT INTO sll_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dungure Yuda ari hobi yu dungwi, “Na nalga hol i dolna bolala di pinanba, ta bolkinanua di na tomia, memini iwe, yal i nin wi sire gonangwo pire dim mo?” ");
INSERT INTO sll_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dimba Yisas yu ditongwi, “Ni yalhobi manbi timiya u tibi unia. Na God mongwo bani ya ime wiwa. Ni yalhobi ganba baniya hong monia. Te na iwe, ganba baniya hong ta molkiwa. ");
INSERT INTO sll_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na ha haya di ni te pisolga pinia. Tal nigi dongwo ol wanga prin i kina ereho gonanua. Na molga maing di ni tega ogolo pirikinangiwe, tal nigi dongwo ol wanga prin i ya di panangure kina ereho gonanua.” ");
INSERT INTO sll_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dungure arihobi Yisas sirin bol tongwi, “Ni ara mone?” Dungure Yisas yu ditongwi, “Na ha hongebe di tibi ol ni tega yal irai molgiwe. ");
INSERT INTO sll_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ni yalhobi mole tal ol i onga maing iwe, na di tibi ole ebir si ni teralia. Teraliba, na bai nu si olungwo yal i ha pangwo mere ogolo weni di nima pire momia. Mongure na ha i, i ure ganba ari hobi di ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ha iwe, Yisas hamen Irang di tibi olimba, ari hobi pir po sikimia. ");
INSERT INTO sll_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sikungure Yisas arihobi yu ditongwi, “Na Ari Wang Weni molia. Molgere emgi na si gole a yuwo olanga gin iwe, na ha hongebe di tibi ol ni tega yal irai molga maing han po sinanga dimia. Sinanga gin i yal i nin pungwo mere pire tal ta olkungwo pamia. Irang yulang tongure ire ha nir si tongwo pamua di pinania. ");
INSERT INTO sll_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Te na bai nu sungwo yal i na kina ereho si daule mole ubilga moli nabilua. Na honagi ol molgere yal i na wai hamia, mobing hal wa na tenangure na nan ta molkiralga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ena Yisas ha i di te pisolungure Yuda ari tabin hobi tau yal i pir tere mongwi. ");
INSERT INTO sll_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ena Yisas pir tongwo hobi yu ditongwi, “Ni yalhobi na hana ogolo pire wine onangiwe, na gamna hobo weni monanua. ");
INSERT INTO sll_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Molere ha miling pangwo hobi muru di engwo i ogolo pinanua. Pirere han holkungwo mere molere tal nigi dongwo olkire, amane monanua.” ");
INSERT INTO sll_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dungure Yuda ari hobi ha pring yu siina ditongwi, “Na Ebraham gang mominge. Molere nir honagi ari ol ware han hongwo mere ta molkiminue. Han holkungwo mere monanua di na tenga i, tal ole molalga pire dine?” ");
INSERT INTO sll_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dungure Yisas yu ditongwi, “Yal ta tal nigi dongwo ole wa monangwo yali, God pring tongwo i yal i nin han honangure wa monamua. ");
INSERT INTO sll_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Singaba ta yal ta han holere honagi ol na to dinangwo gobari ol te monamo? I ta molkinamia. Wang i nin honagi ol na to dinangwo i, gobari ol te monangwo monamua. ");
INSERT INTO sll_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ni tal nigi dongwo ol wanga pring bani hani pai monanba, God Wang na iwe, ure gule ole a poira si ni teralga pamia. Teralgere hani ya pai monano? I ta molkinania. Amane weni monanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ni Ebraham gang monga haminia. Haminba, na ha diga i, ni yalhobi pir sina ere a i si wakinia. Wakirere na si golala di onua. ");
INSERT INTO sll_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na Nabe God mongwo bani talhan pire hane olga mere iwe, ni yalhobi di tibi ol ni teiba, ni yalhobi a i si wakinia. Nin nabin ha di ni tongwo i, a i si ware monua.” ");
INSERT INTO sll_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dungure yalhobi Yisas yu ditongwi, “Na nabe tani Ebraham momua.” Dungure Yisas yu ditongwi, “Ni Ebraham gang mona, ongwo tali onanga pamba, molkinua. ");
INSERT INTO sll_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na ha di ni tegiwe, God ha miling kina di na tongure di ni teiwa. Di ni teiba, ni yalhobi na si golala dire wara kenua. Kenga tali yal Ebraham ta yu olkimua. ");
INSERT INTO sll_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Te ni yalhobi iwe, nabin talhan ongwo meri giu dire onua.” Dungure yalhobi yu ditongwi, “Ayo namine pasendia gir na kungwo momno? Ta molkiminia. Nabe tani God momua.” ");
INSERT INTO sll_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dimba Yisas yu ditongwi, “Ni ha pangwo dinba, nabin God moma yon milni na tengere. Na iwe, God kina ereho si daule mole uge. Ure na nan piriga mere pire ta huya. God na bai nu sungure wiwe. ");
INSERT INTO sll_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ni yalhobi na ha diga tal ongwo memini pir po sikine? Na ha di ni tega irai ogolo a i si wananga ha pirikinia. ");
INSERT INTO sll_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ni yalhobi nabin tani kela mala hong Seten momia. Yal iwe, yon wu bili nangwo haung ni yalhobi para pi kebering bani tabin si monanga monanua. Seten iwe, homa weni sigongwo hani bling memini momia. Molere du ha gogo di wa molere, ha miling kina pangwo hol i ta doling bolkimia. Bolkire hasu kela mala hong yal hani bling memini momia. Molere nin memini pangwo mere olere hasu di wamua. ");
INSERT INTO sll_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na iwe, ha pangwo kara di ni teiba, ni yalhobi pir na tenanga tekinia. ");
INSERT INTO sll_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni yalhobi monga sina i yal ara na tal haung tal nigi dongwo olgere di tibi olane? Na ha pangwo kara di teya, ni yalhobi talongwo pir na tekine? ");
INSERT INTO sll_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God kul engwo hobi iwe, God nin grang wine omia. Omba, ni yalhobi God ta kul engwo molkinia. Molkirere na ha diga a i si wananga ha pirikinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ena Yuda ari hobi Yisas yu ditongwi, “Ni kumoigi panua. Wiyol ta Sameria yal monua, di ni tegarai, ha pangwo kara di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dimba Yisas yu ditongwi, “Na kumoigi payo? Ta paikia. Na Nabe haang a yuwo oliba, ni yalhobi na hana di kul sinua. ");
INSERT INTO sll_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Singiwe, na nan hana dal yuwo erala di dima di pino? God na hana dal yuwo erala di olere ha hol ole ebir si na te momua. ");
INSERT INTO sll_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yal ta na grana ha wine onangiwe, ta golkinania, ya mol pananga pananua.” ");
INSERT INTO sll_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dungure Yuda ari hobi yu ditongwi, “Omaga na yalhobi haya ni han po siminia. Ni kumoigi panga time. Nabe Ebraham haya gongure, te God hana togu yal hobi haya gol i omia. Te ni, yal ta na grana wine olere ta golkinania, ya mol pananga pananua dinga i, tal ongwo dine? ");
INSERT INTO sll_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nabe Ebraham gomia, ni singaba Ebraham i ime olere, ni mokene kulala di dino? Te God hana togu yalhobi ere gomia. Ni talongure na nan singaba molalua di pire gaun di yuwo ene?” ");
INSERT INTO sll_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dungure Yisas yu ditongwi, “Na nan hana dal yuwo emua dingiwe, eralga paikimia. Te yal ta na hana dal yuwo engwo yal iwe, Nabe momia. ");
INSERT INTO sll_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ni yalhobi God haang dal tenga yal iwe, na Nabe momua. Momiba ni yalhobi han kun olekinia, na nan han po siwa. Te na yu di ni teralia, God na hankiwa di ni teralgiwe, hasu di wanga mere di ni teralba. Na kara han po sire ha dungwo meri ogolo wine oliwa. ");
INSERT INTO sll_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ni yalhobi kwian moya Ebraham iwe, na unamua dire homa gun e na tomua.” ");
INSERT INTO sll_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dungure Yuda ari hobi Yisas yu ditongwi, “Ni me erin pipti ta i olekinga ipire talmere ole Ebraham hanane?” ");
INSERT INTO sll_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dimba Yisas ari hobi yu ditongwi, “Ebraham olo ta kul ekungure na homa moliwe. Ha weni kara di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dungwo i ari hobi nigi de pire Yisas hulu kuba sinamba, yal i ha maing oo ala kul si molere ere maini ongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ena Yisas na gina kina wiyala pire yal ta omeling gi dungwo mongwo hamingi. Yal iwe, homa aang yong miling sina omeling gi dire mena ungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ena na gamnahobo Yisas yu sirin bol tomingi, “Tisao, yal ara tal nigi dongwo ol tongure, aang yong miling sina omeling gi dire ume? Irang om mo, aang om mo, nin ome?” ");
INSERT INTO sll_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Diminba Yisas yu di na tongwi, “Omeling gi dungwo yal i irang aang tal nigi dongwo ongure te nin tal nigi dongwo ongure omeling gi dimua dingiwe, memini yu paikimia. Omeling gi dikima God yulang tekinangwo pamba, omeling gi dimia God yulang tere a pila di tenangwo hananga pamua. ");
INSERT INTO sll_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Omaga ari ya dungwo meri na bai nu sungwo yal God honagi ol i naminga pamia. Te hamen kul engwo gin i, hamen si bonangwo honagi onaminga haung ta dikinamia. ");
INSERT INTO sll_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na omaga ganba baniya ya molgiwe, ganba kewa lampi dongwo meri mole arihobi au di te moliwa.” ");
INSERT INTO sll_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dire ebil si ganba bani ole nonere omeling holo holi aklu gale bil tongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bil tere yu ditongwi, “Ni Siloam nir digan bigi sinana po.” Dungure ere pire grang gumang bigi sungwi. Sire ere memini ure omeling wai dungure hangwi. ");
INSERT INTO sll_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hamiawe, eni hobi molere, “homa yal i homaulung ami di molere, moni na to dire hong di na te mongwo haminiraya, omaga yal i mom mo, ari wo mome?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dimba yal tau “momua” dungwi. Yal tau “gumang grang hongwo meri irai homba, molkimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dimba yal i nin mole, “na weni kara molge,” dungwi. “Tal ongere nin omin pila dime?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Yal ta haang Yisas wa dinga yal irawe, ganba nonere omena holo holi aklu gale bil na tomia. Tere, Siloam nir digan bigi sinana po di na tomia. Di na tongwo meri pire bigi sigere omena gumana wai dungure talhan para haniwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Awai ol ni tongwo yal i makena mome?” dungwi. “Mongwo hankiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ena yal i omeling haya gi dungure aule ire Perisi mongwo ongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ongwo gin iwe, Sabat habang Yisas banba dirin nonere yal i omeling apila ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ena Perisi yalhobi yal i hon sirin bol tongwi, “Ni omin pila dingi talmere ol ni tome?” dungwi. “Yal i ganba nonere omena bani aklu gale bil na tongure bigi si olega omena wai dimua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dungure Perisi yal tau mole, “Yal i Sabat habang ta wine olkimia, God yal i ta nu si olekimua,” dungwi. Te yal tau mole, “A, tal nigi dongwo ongwo yal i awai honagi ol tekinamba, omia hankino?” dungwi. Dire ari sikira dire bolbin di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Molere omeling gi dungwo yal i hon sirin bol tongwi, “Yal i omen apila di ni tongwo ni talwa di pir tene?” dungwi. “Yal iwe, God hana togu yal moma diwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dimba Yuda ari hobi yal i omeling gi dungwo apila di tongure moma di hane molkima. Molkimba, irang aang gala dungure ure di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ena Yuda ari aang irang ha hol ol tere, “Ni yasuri wani momo? Kul nega haung omeling gi dire mena umua dino? Dinba omaga omeling wai dungwi hankino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dimba irang aang suri yu ditongwi, “Gir iwe, na yasu kul ebilga momia. Mena ungwiwe, na yona milna sina omeling gi dire mena ungure i waga momia. ");
INSERT INTO sll_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Momba omeling pila dire wai dungwiwe, na yasuri han po sikibilua. Sikibilio, te yal ta apila di tongwo yal iwe, ere para han po sikibilua. Sikibilia, ni yalhobi nin yal i sirin bol piro. Pinanga ari gir momia, nin hamia di tibi olamua.” ");
INSERT INTO sll_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ena irang aang suri iwe, Yuda ari hobi kulung pirere ha yu ditongwi. Te Yuda ari hobi iwe, homa nin ha yu di ere momia. “Yal ta ha maing oo ala ure, Yisas singaba Kraist momua dinangwo yali, ha maing oo ala hon huyo” dire, hobang si tenamua di emia. ");
INSERT INTO sll_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yu di engwo ipire, irang aang suri kul pirere, “Yal i ari gir momia, nin sirin bol piro,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ena ari hobi omeling gi dungwo yal i hon gala dire yu ditongwi, “God maulung bani ha di nima pire ani apli di hole ha weni kara diralua, di na to. Yal irai tal nigi dongwo ongwo yal momia han po siminua.” Dungure omeling gi dungwo yu ditongwi, “Talime om mo, olkim mo, na han po sikiwa. ");
INSERT INTO sll_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sikiba, na homa omena gi dungworai hon pila dungure talhan para hanere wa molga yawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Yal i tal ol ni tome? Omen pila dingi tal ol ni tongwo dine?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Na haya di ni tega irai pirikinua do. Talongwo hon hon di ni teralga pirala di dine? Ni yalhobi yali doling bolala di dino?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dungure ari hobi ha nigi dongwo dire yu ditongwi, “Ayo ni nin yal i gamahobo monia. Na yalhobi yal Moses gamahobo mominga timawe. ");
INSERT INTO sll_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God Moses ha di tere tere ongwo haminga irawe. Haminiraba, yal i ungwo kwaling han po sikiminue.” ");
INSERT INTO sll_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dungure omeling gi dungwo yal i ha pring yu ditongwi, “Ayo, yalhobiya, ha di ta ta olungwo tima pire. Ni yalhobi yali ungwo kwaling hankiwa dinba, ure na omena i a pila di na tomia. ");
INSERT INTO sll_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ena God iwe, talime ol wangwo yalhobi pire tekungwo nan haminua. Tekimba yal ta God maa e tere grang ha wine ole doling bonangwo yal iwe, God yal i pir tongwo haminia. ");
INSERT INTO sll_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Homa weni hamen ganba ol engwo mol i uminga haung i yal ta omeling gi dungwo a pila di tenangwo hankiminga irawe. ");
INSERT INTO sll_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God yal i nu si olekima, omena a pila di na tekungure.” ");
INSERT INTO sll_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dungure ari hobi yu ditongwi, “Ni nimai nabin kuni nere ni kul engwo monia. Talongwo ha di holo ol na tene?” Dire ha maing oo ala aule ire pire, pia si maini ole, “ere po” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ena Yisas pungure, Yuda ari omeling gi dungwo yal i si doling i maini olimua dungwo pungwi. Pire wa du i pire omeling gi dungwo yal i mongwo hanere yu ditongwi, “Ni Ari Wang Weni pir ten mo tekine?” ");
INSERT INTO sll_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dungure, “Yal Yisas ye, Ari Wang Weni ara han dine? Han dinanga yal i na pir tenaminba?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Ni haya hangiwe. Pir tenanga yal i ni kina omaga ereho mole ha di yuwo ya ol mongiwe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Yisas ye, ni pir ni teiwa,” dungwi. Dire ikwi bole Yisas maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ena Yisas ha aine yu ditongwi, “Na ganba bania ugiwe, ari ebir sirala dire wiwa. Ebir sigere ari omeling gi dungwo hobi hon a pila di teralgere talhan para hanamua. Te omeling pila dungwo hobi omeling gi dungwo yal mongwo meri monamua.” ");
INSERT INTO sll_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dungure Perisi yalhobi kina ereho molere ha dungwo i pire yu ditongwi, “Na yalhobi para omena gi dungure dino?” ");
INSERT INTO sll_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dungure Yisas yu ditongwi, “Ni yalhobi omin gi dinangure monanga iwe, tal nigi dongwo ol wanga God pring ni tekinamia. Ni tekinamba, omena wai dimua diniraya monga bani tal nigi dongwo ol wanga pring ya dimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ena yal Yisas yu dungwi, “Ena piro. Yal ta kun sipi sipi u sina nala dinanga i, hona grang nanga pamba, iri sire onga pamia. Onga yali, talime homena kuni ari mole wangwo meri wanua. ");
INSERT INTO sll_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hona grang u sina ongwo yal iwe, kun hong yal momua. ");
INSERT INTO sll_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hona grang kene ol mongwo yal i hoiri yaule tongure wamua. Ware kun sipi sipi tan tani haang dale ma dimua. Dire maini homa e tongure kun hobi gone dire omua. ");
INSERT INTO sll_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pirere hong yal homa e tere gala dungwo kun hobi doling bole omua. ");
INSERT INTO sll_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yal ta pire ma dinamba, kun hobi nugung pirikimia gone dinangwo paikimua. Nugung pirikimia te nulu di daang namua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ena Yisas ha iwe, kun sipi sipi bani di bole di emba, ari hobi memini ogolo pir po sikungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ena Yisas ha hon ainere yu ditongwi, “Ena piro. Na nan kun sipi sipi u hona grang molia. ");
INSERT INTO sll_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yal tau homa ongwo hobi homena kuni nere ariwo taling tol di nongwo momia. Mole pire ma dimba, kun sipi sipi nugung pirikimia. ");
INSERT INTO sll_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Te na nan hona grang molia. Yal ta na molga ure ala nala hoiri yaule na to dinanga, yaule ni teralga, God si hon e ni tenangure sigare kule u wai nanua. Pirere maini ala tere wa molere mol pai homena nere monanua. ");
INSERT INTO sll_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ena kuni ongwo yal iwe, ala pire kuni ire, si gole, isusu olala dire umiwa. Umiba na iwe, ari hobi mol pai tegere kunung benama dire wiwa. ");
INSERT INTO sll_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ena na kun sipi sipi kene waole moliwa. Molgere kun sipi sipi gamna hobi si gonamba, na gauna pir tekire yakel digere na sigonama di piriwa. Golere kun sipi sipi hobi emgi breng ol irala di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Te yal ta tobo honagi ol ware kun sipi sipi kene ogolo olkimua. Ariwo kungwo momua di pimia. Di pire han momba, awi biing ungwo hanere kun hobi aidole te banta omia. Ongure awi biing ure tau si nongure, tau te ususu omua. ");
INSERT INTO sll_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tobo honagi ol wangwo yal iwe, kun hobi miling pir tekire, gintani te u banta namia. ");
INSERT INTO sll_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ena kun sipi sipi hong wai molere kun kene wai oliwa. Olgere sipi sipi mongwo meri mongwo hobi na nuguna pimua. ");
INSERT INTO sll_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Te Nabe na nomani si piriga meri pir po simba, te na Nabe nomani si pungwo meri ereyu pir po siwa. Siga meri iwe, kun sipi sipi kulga hobi nomani si pungwo meri pir po siiba, te na nomani si piriga meri kun hobi ere pir po simua. sungwo hobi iwe, miling pire yakel digere na sigonangwo meri piriwa. ");
INSERT INTO sll_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ena kun sipi sipi kulga u taniya ta molkinia, u bantau ere para momua. Mongure na aule ire wiwa. Ure kene ol molgere na nuguna pinangwo i tani olalga pamua. Olere na nan muru kene ol molalga pamua. ");
INSERT INTO sll_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na nan mol pai aidolalga pamia. Aidole emgi hon iralga pamua. Yu olala di olga ipire Nabe yong miling na tomia. Te yal ta na sigolala di onangwiwe, kunung ta paikinamia. ");
INSERT INTO sll_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Na nan moli pire golalga haung mala unangwo pire golalga pamua. Na golala di olalga, na nan nimni mole golalga pamia. Gole ti hon airala di olalgiwe, na nan ereyu nimni mole airalga pamua. Ha diga i, na nan taman. Nabe di nima pire yulang na tomia yu olalga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ena Yisas ha dungwo i pirere Yuda ari sikira dire ha bolbin di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tau mole, “Kumoigi pamia. Pare du ha dimia. Pir tenano?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dimba te tau mole, “A, kwia du haure ha dikimia. Kumoigi pangwo hobi omeling gi dungwo yalhobi a pila di tenamo? Ditenangwo paikinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ena erin ta u tibi ungwi. Erin iwe, Yuda ari hobi Yerusalem ha maing oo hoiri yaule engwo hon nomani si pire erin mole God gun e tere tere mongwi. Molere Yuda ari ganba hair gongwo haung mongwi. ");
INSERT INTO sll_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mongure ena Yisas ha maing oo ala oo ke ainungwo Solomon aibing wa mongwi. ");
INSERT INTO sll_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wa mongure Yuda ari hobi u yobilere yu ditongwi, “Ha di na tekinga nomani si gogo daliminia, tal one? Ni singaba Kraist monanga ha kara di tibi ol na tomo.” ");
INSERT INTO sll_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dimba Yisas yu ditongwi, “Na ha haya di ni tegarai, pir na tekingiwe. Na Nabe yulang na tongure irere tal ta ta olga hania. ");
INSERT INTO sll_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Haniba ni yalhobi na kun sipi sipi kulga mongwo meri molkire ogolo pir na tekinua. ");
INSERT INTO sll_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na kun sipi sipi kulga hobi na nan grana wine omia. Ongure na nan kun hobi han po sia. ");
INSERT INTO sll_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sigere kun hobi na na dolna bomia. Bongwo hobi iwe, mol pai gobari teralga ire ta golkinamia, ya mol panangwo panamua. Mol panangwo bani yal ta ana bani tol di inamo? I ta ikinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Nabe modui dungwo yali, arihobi haya nu ke tere, i na ana bani e pisolimia. E pisolere nimni mole kene ol momia. Yal ta tol di inangwo kunu paikinamua. ");
INSERT INTO sll_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nabe na kina tani mole si daule mobilua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ena yu dungure Yuda ari hobi yong ki ere hulu ire sirala di ongwi. ");
INSERT INTO sll_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Omba Yisas yu ditongwi, “Nabe na awai honagi para weni nibil di na tongwo mere ni yalhobi monga bani i tibi ol ni teiwa. Teiba honagi tau ta ol ni tekiwa. Tal honagi olga paikungwo pire na sirala dire one?” ");
INSERT INTO sll_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dungure Yuda ari hobi yu ditongwi, “Awai honagi ongiwe, hulu kuba ni sirala di olkia. God kina si daule moliwa dingiwe, God gaung ha sinia, ni sirala di oliwa. Ni ari monba, God kina si daule molala di pingiwe.” ");
INSERT INTO sll_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dungure Yisas yu ditongwi, “Ni nin krehaman ha mining ta yu pamia. ‘God haya yu di na tomia. Ni arihobi iwe, God ni ol engure God nomani pangwo meri panua.’ Dire ha di engwo i ya di panangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te God iwe, ha maing di tongwo hobi, ‘ni arihobi iwe, God ni ol engure God nin nomani pangwo meri panua,’ ditomia. ");
INSERT INTO sll_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ena na iwe, Nabe na nu ke na tere na bai nu sungure ganba baniya wiwa. U molere na God Wang moliwa digarai ni yalhobi God gaung ha sinua di na tenia. Talongwo di na tene? ");
INSERT INTO sll_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na Nabe honagi olkiralga, ni yalhobi pir na tenano? Pir na tekinanga pamia. ");
INSERT INTO sll_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pamiba na Nabe honagi ol te molga haniba, ni yalhobi ogolo pir na tenanga mere tekinua. Ha nir si ni tega pir na tekinba, honagi olga hanga i pir na tekinanga pamba, pir na tekinua. Ena Nabe na kina si daule moli nabilga nabilia di pinangiwe, na tal olga i maing a i si ware ogolo piro,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ena ari hobi han holala dire pi abama dungure ere ongwi. ");
INSERT INTO sll_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ena Yisas na gina kina Yodan nir bare iri si hoibi omingi. Pire yal Yon homa nir bil tongwo bani momingi. ");
INSERT INTO sll_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Momingere ari tabin bir weni u pa dungwi. U pa dire yu dungwi, “Yal Yon tal guma hon dongwo ta onangwo hankiminia. Hankiminba, Yon iwe, yal Yisas tal onangwo maing di tibi olungwo i, ha pangwo kara dimua.” ");
INSERT INTO sll_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dire ari miki weni pir tere wine ongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ena Betani oo malgi hong yal ta haang Lasaras nibil ongwi. Ena Betani oo malgi iwe, al Maria abimbi al Mata oo malgi dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ena al Maria iwe, Yisas kebering bani wel santa garu di bil tere breng eme ire kli sungwo al mongwi. Al iwe, keunimbi Lasaras nibil ongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ongure al suri yal ta bai nu si Yisas mongwo olere, “Yal Yisas ye, nin enin ta Lasaras irai nibil omua, ditenana po,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dungwo ha i Yisas pirere yu dungwi, “Nibil pangwo han dingi gonamo? Ta golkinamia. Nibil ongwo i God haang a yuwo olama dire omia. Olangwo meri, God Wang na ere para hana a yuwo olamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ena Yisas al Mata ire, ebering ire, keunimbi Lasaras ire dire, yong miling tongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tere “Lasaras nibil omua” dungwo ha i pirere mongwo bani ari haung sutani ya mongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Molere emgi Yisas na gamnahobi yu di na tongwi, “Ere Yudia namna pano.” ");
INSERT INTO sll_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dimba na gamnahobi yu ditomingi, “Tisao, naminba, Yudia ari hobi hulu ni sirala dimia. Ni hol i hon nala di dino?” dimingi. ");
INSERT INTO sll_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Diminba Yisas yu di na tongwi, “Ari haung taniga honmil obil tamo? I ta takimia. Honmil omare pudungwo para tamia. Tangure yal ta hamen tare au dikinangure hol ware hogal sinamo? Au dungwo han kun ole wamia. ");
INSERT INTO sll_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hamen girungwo hol wangwiwe, au dungwo hane wamo? Ta hane wakimia. Hogal simua.” ");
INSERT INTO sll_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Direre Yisas ha hon aine yu di na tongwi, “Na enan ta Lasaras haya ul pamia. Na pire hon uling yuralga airamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dungure na gamnahobi yu ditomingi, “Yal Yisas ye, Lasaras ul panangwo nibil wai sinamia aire ya monamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Diminba, Yisas Lasaras gongwo hanere ha saa tere dimba, na yalhobi ha weni dima di pire bol yare memini pir po sikimingi. ");
INSERT INTO sll_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pir po sikimingere Yisas di ba bolere, yu di na tongwi, “Lasaras haya gomia. ");
INSERT INTO sll_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na ni yalhobi wa di piriga yon horega onangure ogolo pir na tenana di pire na pi yali kina molkiga wai piriwa. Yal i pai mongwo bani namna pano.” ");
INSERT INTO sll_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yisas gamahobi kwal gir kul engwo tal iwe, yu kul engwo yal ta haang Tomas mole na gamnahobo tau yu di na tongwi, “Nan para naminga i, gonaminga uminia pano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ena Yisas na gina kina pi malgi pa dimingi. Pa dire hamingere Lasaras ari yulagi engwo bani man wu emia, hamen haung sui sui dire pai mongwo hamingi. ");
INSERT INTO sll_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ena Betani malgi iwe, Yerusalem mala weni dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dungure Yerusalem ari yal al hobi ure, hai mere, al Maria Mata kina keunimbi gomia yong aura di te mongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mongure al Mata Yisas umua dungwo pungwi. Pirere pi bangi pire uminga hangwi. Ena al Maria oo malgi ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ena al Mata Yisas yu ditongwi, “Yal Yisas ye, ni timiya ya mona, na keunambi golkinangwo dimba. ");
INSERT INTO sll_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","God sirin bol tenanga tal ta ni tenama di piriwa.” ");
INSERT INTO sll_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dungure Yisas yu ditongwi, “Ni keunbi iwe, si hon ere airamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dungure al Mata yu dungwi, “Habang kul ere ganba wai sinangwo gin iwe, ari para weni airangwo gin i airama di piriwa.” ");
INSERT INTO sll_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dungure Yisas yu ditongwi, “Airangwo ya, te mol pai iwe, hong bling memini na molia. Yal ta na grana wine ole moli pire gonangiwe, golere mol pai wai inanua. ");
INSERT INTO sll_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te yal ta hon molere na pir na tere grana wine ol i nanga yal i, golala di pinanba, ta golkire ya mol pananga bani pananua. Ni ha i nomani si pin mo pirikine?” ");
INSERT INTO sll_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dungure al Mata yu ditongwi, “Piminia. Ni singaba Kraist God Wang ya ganba bania unga na nomani si pir ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ena al Mata ha i di pisolere ere memini pire ebering al Maria gala di nin bangi ere yu ditongwi, “Tisa haya u molere ni sirin bomua.” ");
INSERT INTO sll_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Dungure al Maria pi bangi pire Yisas na gina kina uminga na hangwi. ");
INSERT INTO sll_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yisas Mata di tongwo bani ya mol pare olo hungure Maria ure hangwi. ");
INSERT INTO sll_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hangure Yuda ari hobi oo ala molere, Maria yong aura di te mongwo hobi Maria aire gintani omia hanere doling bol ongwi. Pirere yu nomani si pungwi, Maria ari yulagi engwo bani pire hai merala dire oma di hangwi. ");
INSERT INTO sll_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ena al Maria Yisas na gina kina mominga bani u pa dire hangwi. Hanere ya habilai sire yu ditongwi, “Yal Yisas ye, ni timiya mona, keunambi golkinangwo dimba.” ");
INSERT INTO sll_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dire hai mengure Yuda ari hobi para hai howa dire memia Yisas hangwi. Hanere miling pirere miling gul sungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Sirere, “Makena man wu ene?” dungwi. “Yal Yisas ye, eminga dima hanana wo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dungure Yisas hai mengwi. ");
INSERT INTO sll_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mengure Yuda ari hobi yu dungwi, “Yal i gongwo yal i yong miling tomia hano.” ");
INSERT INTO sll_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dimba tau yu dungwi, “Yal iwe, ari omeling gi dungwo a pila di tongwo yal momo? Monangwo Lasaras aki di tenangure golkinangwo pamba,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ena Yisas miling gul go sungure na gina kina ere yulagi engwo bani omingi. Engwo bani iwe, hulu grang bir weni dungure hulu ta kwaling pera di engwi. ");
INSERT INTO sll_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Engure Yisas hanere, “Hulu a krigi si mena olo,” dungwi. Dimba gongwo yal i keunimbi al Mata yu ditongwi, “Yal Yisas ye, yal iwe, hamen haya gongwo eminga hamen haung sui sui dire pai momia. Haya bil yare kunung unamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dimba Yisas yu ditongwi, “Ni na onangwo pamia dire ogolo pir na tenanga, God yulang hananua, di ni tekimno?” ");
INSERT INTO sll_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dungure ari hobi hulu i mena olungwi. Olungure Yisas han gala dire yu dungwi, “Nabe, na ha diga pir mongi wai piria. ");
INSERT INTO sll_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Habang habang na ha di ni tega pir monga bani monia. Ari yal al tabin mala mongwo hobi hanere, God bai nu sungure umia, di pinama dire di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yu ditere gala dire, “Lasaras ni maini wo,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ditongure gongwo yal i aire maini ungwi. Maini umia kebering aling bani iwe, banisi han dale tongwi. Tere grang gumang bani para gal yobile han dale tongwi. Tongure Yisas hanere, “Han i gule ole to. Tengere hol wanamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ena Yuda ari tau Maria hol ire ungwo hobi iwe, tal ongwo i hanere Yisas pir tongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tomba tau ere pi Perisi yalhobi mongwo bani pire Yisas tal ongwo ha i boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tongure Perisi yalhobi pirere, ha maing oo singaba mongwo bani pire Yuda ari Kaunsil hobi gala di ku bole yu ditongwi, “Yal i tal guma hon dongwo miki omia, nan tal ol tenamne? ");
INSERT INTO sll_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nan han uning si olimingere, yal i tal yu ol monangwo, ari hobi para pir tere grang wine ole doling bonamia. Bonangure yol Roman kene ol na tongwo yalhobi hanere ha maing bling mining oo si gale nan na i susu olamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ena ari mongwo sina i yal ta Kaiapas ha maing singaba nambawan molere yu ditongwi, “Ni yalhobi maing ogolo hanere, pir po sikinia. ");
INSERT INTO sll_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nan Yuda para weni gonaminga, wai ta paikinamia. Te yal taniga gonangwo i ari para weni breng ol inamia. Ol inangwo i, wai panamua.” ");
INSERT INTO sll_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ha iwe yal i nin nomani si pungwo meri pire ta dikimia. Yal i me erin taniga ha maing oo singaba president mongwi. Molere yu dungwi, “Yisas golere Yuda ari hobi para weni breng sinamua. ");
INSERT INTO sll_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yisas gonangure Yuda ari hobi tani taman. God ari nu ke tongwo mol i nangwo hobi breng sinangure u tabin tani sinamua,” dire, awa ha di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dungwo gin iwe, Yisas kara si golala dire erin mole ha hol mongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Momia Yisas Yudia ganba bani hon ta gumang tekima, mena holo holi kul si ware mongwi. Molere Epraim oo malgi pi mongwi. Mongure na gamahobi kina ereho momingi. ");
INSERT INTO sll_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ena God Isrel arihobi han uning sungwo Pasoba erin haung u mala ongwi. Ongure ari ganba bina holo holi miki weni mo Yerusalem pire, Yudari memini pangwo meri wine ole talime pring i ole na tenama di pire God hau si ke tongwi. ");
INSERT INTO sll_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yu ol molere Yisas wa du i ongwi. Wa du i pire ha maing oo ala mole yalhobi nin diriyala ole yu dungwi, “Yal i erin habang i Yerusalem unama di pin mo, hunama di pine?” ");
INSERT INTO sll_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ena ha maing oo singaba hobi ire, Perisi ire dire, ha hol molere yu ditongwi, “Yisas monangwo hananga, bani momua di na to.” Dire han honama dire yu ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ena ari haung ana hol pai muru hol pai taniga wai sinangure han uning sungwo Pasoba erin haung u tibi unama dire kwi han mongwi. Mongwo gin iwe, Yisas na gina kina ere yal Lasaras gongwo hon uling yungure airungwo yal i kepangwo Betani malgi omingi. ");
INSERT INTO sll_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Omingere ari hobi Yisas homena si gangwi. Si gangure Lasaras Yisas na gina kina ami di mole homena nomingi. Nominga gin i, al Mata homena si gangwo i gwire na tongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tongure ne momingere al Maria wel santa mugu tobo bir weni bongwo kunung wai ungwo ire, Yisas kebering bani bil tere, breng eme ire kli sungwi. Sungure santa kunung wai iwe, oo ala i kunung bengwi. ");
INSERT INTO sll_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bengure Yisas bai tal sinangwo yal i, mole yu dungwi, ");
INSERT INTO sll_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ayo, wel santa i yal ta bring sinangwo moni tri handret kina ire ari talhan anekungwo hobi tenanga pamba.” ");
INSERT INTO sll_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yu dire ari tal anekungwo hobi miling pirkire gogo dungwi. Dire na gina moni ben dungwo bani kene ol molere kuni nerala dire yu dungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dimba Yisas yu ditongwi, “Ni al i han tekio. Al i tal ol na tongwo i, ari yulagi engwo bani nalga pire ol na tomia. ");
INSERT INTO sll_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Te ari tal a nekungwo hobi ni yalhobi kina gobari moli nanga pamia. Te na iwe, ni yalhobi kina gobari go moli ubilua.” ");
INSERT INTO sll_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ena Yuda ari tabin bir weni Yisas Betani malgi momua dungwo pirere u pa dungwi. U p dungwiwe, ya moni ure Yisas tani harala dire huma. Yisas Lasaras gongwo bani uling yungure hon airimua dungwo pire Lasaras para harala dire ungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Umia ha maing oo singaba hobi kina ha holere, Yisas Lasaras kina ereho si gonaminua dungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ena Lasaras haya gomba, Yisas hon uling yungure airungwo i hanere, Yuda ari hobi para weni ha maing oo singaba pisolere Yisas ha dungwo doling bole a i si wamia. ");
INSERT INTO sll_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ena ari tabin bir weni erin molala dire ere Yerusalem ungwi. Tanangwo Yisas ere Yerusalem unamua dungure ari hobi pungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pirere ari hobi er yolang ba di ire pire homaulung kwaling molere na gina Yisas kina uminga hangwi. Hanere gala erakere yu dungwi, “God wai pir tominua. Yal i God mongwo bani ainere umia, God wai pir tominua. Yal i Isrel ari singaba king momia God yal i kene ol to.” ");
INSERT INTO sll_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ena Yisas kun donki ta han holere pi mobing bani au sungwi. Sungwiwe, homa ha maing buku di engwo meri irai giu dire yu ongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ni Isrel ari hobi, singaba king umia kul pirikio. Ungwiwe, kun donki giring au sire, umia. ");
INSERT INTO sll_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yisas gamahobo na gina iwe, ha maing buku di engwo i nima omba pir po sikiminia. Emgi Yisas golere hon aire God kina si daule mongwo gin i, na yalhobi nomani si pire, “Ayo, ha di engwo irai nima ongwo pamba, nan hankire gogo molere, omaga hane ganulun diminua” dimingi. ");
INSERT INTO sll_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ena homa Yal Lasaras gongwo man wu engure emgi Yisas pire uling yungwo airungwiwe, ari hobi hamia. Hanere tal ongwo i gung haang si wa dungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dimia ari tabin bir weni hobi Yisas tal yu omua dungwo ha gung pungwi. Pire pi bangi pire Yisas na gina kina uminga na i tibi ole hangwi. ");
INSERT INTO sll_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hamia Perisi yalhobi nin di wama tere yu dungwi, “Ari para weni na mobing hal wa na tere yal i doling bomia hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ena ari Yerusalem malgi erin haung u pa dungwo hobi mongwo sina i yol Griki ari tani tani ya sina sungure molere, God gumang tongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ena Griki ari ungwo hobi, yal Philip Galili probins Betsaida hong yal mongwo bani pirere yu ditongwi, “Yahuno, Yisas monangwo bani di na tengere hanaminba.” ");
INSERT INTO sll_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dungure Pilip pire Endru ditongwi. Ditongure Philip Endru kina ereho pirere Yisas ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ditomba Yisas yasuri yu ditongwi, “Na Ari Wang Weni molia. Molere God kina si daule molalga haung mala ungwo yawe. ");
INSERT INTO sll_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ha weni kara di ni teralia piro. Paba miling taniga ulu kul ya ganba bani sikinangwo ya di panamia. Te taniga ya ganba bani sinangwo, pi sire bolere miling miki weni honamua. ");
INSERT INTO sll_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yal ta nin gaung pir yuwo ere gaung kene onangwo yal iwe, u talwo nangwo pamua. Te yal ta ganba baniya nin gaung pir tekirere wa monangwo yal iwe, mol pai gobari ire ya mol panangwo panamua. ");
INSERT INTO sll_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Te yal ta na honagi olala di pinanga yali, na dolna bolo. Bonanga na mol pai olga bani iwe, honagi ari kina ereho mol pai olabilua. Na honagi onanga yal i, Nabe yal i haang a yuwo ol tenamua. ");
INSERT INTO sll_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ena omaga na yona milna ho ho mo wi dimia, talwa dirale? Nabe gaung gul iralga olo i tibi ol na tekio, diral mo, dikirale? Diralba, ganba baniya gul irala dire wiraya dikiralga pamua. ");
INSERT INTO sll_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nabe, ni nin hani a yuwo olo.” Yu ditongure hamen bani ha ta ya ime ure, “Na hana a yuwo ol i oga, te emgi hon ol i nalga pamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ari tabin mala mongwo hobi ha dungwo i pire, “Ayo, hamen guru dimua,” dungwi. Dimba tau, “Kwia ensel yal i ha ditomua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dimba Yisas na yalhobi yu di na tongwi, “Ha iwe, na molga ipire ta dikimia. Ni yalhobi kina mominga i pinana dire dimua. ");
INSERT INTO sll_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Omaga iwe, God ganba ari hobi ha hol ole ebir si ni tenangwo pamua. Te God ganba ari hobi irang bir kene ol tongwo yal i breng kuba sire isusu olamua. ");
INSERT INTO sll_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te na er yolang bani na si paru di enangwo hanania. Hangere, nu ke ni tere kri di ku bole tabin tani si egere monanua.” ");
INSERT INTO sll_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ha yu dungwo i gonangwo pangwo i pire di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tongure ari tabin hobi yu ditongwi, “Na yalhobi krehaman awa ha yu di engwo piminiraya. Ha iwe, Kraist golkirere ya mol panangwo bani panamua dimiraya. Ari Wang Weni er yolang bani si paru di enamua dingiwe, ara han dine?” ");
INSERT INTO sll_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dungure Yisas yu ditongwi, “Ni yalhobi monga bani iwe, kewa elame haung obilga de dinamia. Denangwo habang iwe, ni yalhobi dongwo i hanere wa molo. Si bongwo u terewa sinangwo pamia. Pangwo i hanere kewa dongwo meri haya ware ba bongwo bani molo. Si bongwo ali wa monanga molere, ‘ba bonangwo ma nale?’ dire hol wa dunanga pamia. ");
INSERT INTO sll_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Omaga kewa dongwo i na molia. Ni yalhobi kina ereho mol pai ol i nabilga pamia dire pir na to. Pir na tenanga ba bongwo bani mole wa monanua,” dungwi. Yisas ha i di te pisolere, ari hobi han mongwo omeling bani u kul si ongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ena Yisas tal guma hon nimni mongwo miki weni ol tomia. Tomba ari hobi pir tenangwo mere tekungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tekungwiwe, God hana togu yal Aisaya ha di engwo i nima namua dimiraya, omaga kara nima ongwi. Ha i yu pamia, “Yal God ye, ha di tominga irai ara pire wine ome? Ara God yulang ire i tibi olime?” ");
INSERT INTO sll_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Homa yal Aisaya awa ha di emiraba, omaga ari hobi Yisas ogolo pir tekungwi. Ha iwe, yu pamia. ");
INSERT INTO sll_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God ari hobi omeling naang bol tomia. Ari hobi nomani pamba, God tal ta ol tongure nomani sala omia. Ongwiwe, yalhobi omeling hanangwo ha pirikimio, te nomani si pinangwo ha pirikimua. God ol tongure nomani si kulu sigere awai ol na tenama di pinamba, ere ol tekiralga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ha iwe, Aisaya Yisas God kina si daule mongwo hanere ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ena Yuda ari singaba miki weni Yisas pir tere wine ongwi. Omba, Perisi hobi kul pir tere, ha di ba bolkimia. Di ba bolalga ha maing oo ala nalga na dolna i mena olama di pungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Di pire ganba ari hobi na wai hanama di pire ware God na wai hanama di pirikungwi. ");
INSERT INTO sll_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ena Yisas gala bir dire yu dungwi, “Yal ta na pir na tere grana wine onanga i, na tani taman. God na bai nu si olungwo yal i para pir tere wine ol tenanua. ");
INSERT INTO sll_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te yal ta na na hananga i, na tani taman. Na bai nu si olungwo yal i para hananua. ");
INSERT INTO sll_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na iwe, kewa lampi dongwo meri mole ganba ari hobi au di tegere, yal tau na pir na tere grana wine onanga hobi si bongwo bani ta wakinanua. ");
INSERT INTO sll_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yal ta na grana pinamia. Pirere wine olkinangwo i, na ha hol ole ebir si tekiralua. Na iwe, ganba ari hobi ha hol ole ebir sire isime e teralo? I ta tekiralia. Aki di tegere ari hobi sigare kule u wai nama dire wiwa. ");
INSERT INTO sll_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Te yal ta na mobing hal wa na tere ha diga wine olkinangwo i, yal ta ure ha hol ol tenangwo pamua. Na ha di ni tega i hamen ganba wai sinangwo haung ari hobi yu ol tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ha iwe, na nan piriga meri pire ta dikiwa. Nabe na bai nu si olungwo yal i yu dinana po di na tongure di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te na Nabe grang ha iwe, mol pai gobari mol panangwo panangwo i u tibi umia. Te na ha di ni tegiwe, Nabe yu do di na tongwo meri boling kul ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ena God Isrel ari si gonamba, han uning sungwo erin Pasoba olo u mala hungure, Yisas hanere, o, na ganba baniya pisole, Nabe mongwo nalga pamua di hangwi. Di hanere ganba baniya ari doling bominga hobi yong miling na tere tere moli pire gomia. ");
INSERT INTO sll_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ena hamen pudungwo Yisas na gina kina homena ne momingi. Homa Seten ure Iskeriot hoong yal Saimon wang Yudas Yisas bai tal sinama dire yong wu bungure mongwi. ");
INSERT INTO sll_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Te Yisas pungure Irang God talhan hobi para onama dire yulang tere i aling bani e tere, nu si olimiraya, omaga hon siina dire God mongwo bani nalga pamia di pungwi. ");
INSERT INTO sll_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pirere homena i pisolere, Yisas galsina gul olere, gal taul ta waling sina si paru di engwi. ");
INSERT INTO sll_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ere nir garu di pele ala engwi. Ere na gamnahobo i kebena bigi si na tere, gal taul ire kri di na tongwi. ");
INSERT INTO sll_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Di na te i pire pi Saimon Pita mongwo bani dimba, Pita Yisas yu ditongwi, “Yal Yisas ye, ni na kebena bigi si na tenano?” ");
INSERT INTO sll_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dungure Yisas yu ditongwi, “Omaga ni keben bigi si ni tega i, maing pir po sikire dinia. Dinba emgi pir po sinanua.” ");
INSERT INTO sll_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dungure Pita yu ditongwi, “Ni na kebena omaga te emgi para bigi si na tekinanue.” Dimba, Yisas yu ditongwi, “Na ni keben bigi si ni tekiralga, ni na na dolna bolkinanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dungure Saimon Pita yu ditongwi, “Yal Yisas ye, na kebena tani bigi si na tekinania. Kebena ana bina gauna para bigi si na tomo.” ");
INSERT INTO sll_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dungure Yisas yu di na tongwi, “Yal ta kebering aling gaung para bigi sungwiwe, sire mena ongwo i, gaung wai dimba, kebering tani ganba bamua. Ni yalhobi nomani hama sikungure monba, yal taniga talime pring ya dungure momua.” ");
INSERT INTO sll_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ena Yisas yal ta bai tal sinangwo yal iwe, haya han po sire, “yal ta talime pring ya dungure momua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ena Yisas na yalhobi kebena bigi si wai sire nin galsina hon ware ami dungwi. Dire yu di na tongwi, “Na tal ol ni tega i ni yalhobi maing han po sino? ");
INSERT INTO sll_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tisao, Yal wai ye, di na te monia. Dinga mere iwe, na weni kara molia. ");
INSERT INTO sll_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na ni hobani molere, Tisa molere, keben bigi si ni teya. Si ni tega meri, ni yalhobi ebin hobi para kebering bigi si to. ");
INSERT INTO sll_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na iwe, yu onana dire nibil di ni teya. Ni yalhobi na olga meri giu dire olo. ");
INSERT INTO sll_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na ha weni kara di ni teralia. Honagi ari hobi iwe, mo yu pire irang a ime ta olangwo paikimua. Yal ta ha di tenana po dire nu si olangwo yali, nanga ni nu si olangwo yal i a ime ta ol tenanga paikimua. ");
INSERT INTO sll_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni yalhobi ha miling bolo di ni tega pinia. Pinga meri yu olere, wine oli nanga i, miling ire gun enanua. ");
INSERT INTO sll_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ha di ni tega pinga i, ni yalhobi para weni taman. Ari tau nu ke tega yal hobi obil pire diwa. Homa ha maing buku, na kina homena ereho ne monanga hobi yal ta na mobing hal wa na tenamua di engwo irawe, omaga weni kara nima nangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Talhan hobi olo u tibi hungure, homa awa ha tani di ni teiwa. Teya emgi u tibi nangwo hananua. Hanere, ha hongebe di tibi ol ni tega yal na molga maing pir po sire a i si wananga dimua. ");
INSERT INTO sll_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na ha weni kara di ni teralia piro. Yal ta na bai nu si olalga yal i pana gal tenanga i, yal i tani taman. Na para pana gal na tenanua. Na para pana gal na tenanga i, na tani taman. God na bai nu si olungwo yal i para pana gal tenanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ena Yisas ha i di te pisolungure yong miling sina enin bai tabile ho ho mo ungwi. Ungure Yisas ha yu di tibi ol na tongwi, “Ni yalhobi monga sina i yal ta kiana hobi unangure na bai tal sinanua. Na ha weni di ni teiwa.” ");
INSERT INTO sll_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dungure na gina hobi nan gumana bani han iriyala olere, “ayo, ara han dime?” di pimingi. ");
INSERT INTO sll_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Di pimingere, Yisas yong miling na tongwo yal na kina ereho ami di momingi. ");
INSERT INTO sll_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Momingere Saimon Pita hanere, gumang iger bol tere yu di na tongwi. “Ni kiani ara mole ni bai tal sinangwo han dine, di piro.” ");
INSERT INTO sll_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dungure na mala pire hani di Yisas kraung ala i olgi, “Yal Yisas ye, ni kiani hobi yal ta na bai tal sinamua dinga irai ara han dine?” ");
INSERT INTO sll_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Digere Yisas yu di na tongwi, “Na yal ta kina homena pele tani nir bole nobilga yal irai han diiwa.” Dire homena nir bole Iskeriot hong yal Saimon wang Yudas tongwi. ");
INSERT INTO sll_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Homena i tongwo Yudas ingure Seten gin tani ure yong wu bungwi. Wu bungure Yisas Yudas yu ditongwi, “Ni tal ta olala di pinanga haya olo.” ");
INSERT INTO sll_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dungure Yudas i nere hamen girimia gin tani ere mena ongwi. ");
INSERT INTO sll_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ongure ena Yisas Yudas ha di tongwo i na gina homena nere ami di mominga hobi maing pir po sikimingi. ");
INSERT INTO sll_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pir po sikire hamingere, Yudas moni ben a mongure, Yisas erin homena bring sinana po di tom mo? te ari moni a nekungwo hobi tau tenana po di tom mo? di han momingi. ");
INSERT INTO sll_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ena Yudas ere maini ongure Yisas na gina hobi yu di na tongwi, “Na Ari Wang Weni molia. Molgere omaga hana awala ganamia. Galere God hang para awala ganamia. ");
INSERT INTO sll_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te God yulang ire haang a yuwo olalga meri, God na hana a yuwo olamua. Habang tau gobari moli nalgere, gintani i tibi olamua. ");
INSERT INTO sll_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gir hobo, na ni yalhobi kina habang obilga molabilua. Molabilgere, emgi na wa dunanua. Na Yuda ari hobi haya di tega meri, omaga di ni teralia piro. Na ere nalga hol i ni yalhobi na dolna bole u pa dikinanua. ");
INSERT INTO sll_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ena omaga na ha hon di kunung e ni teralia, Ni yalhobi nin wama dire yon milni to. ");
INSERT INTO sll_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na ni yalhobi yona milna ni tere tal olga mere iwe, yu ol to. Yon milni wama dire te monanga i, ari hobi ni hanere, o, yalhobi Yisas gamahobo mongwo pamua di hanamua.” ");
INSERT INTO sll_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dungure Saimon Pita yu ditongwi, “Yal Yisas ye, ni ma nane?” Dungure Yisas yu ditongwi, “Na nalga hol iwe, omaga ni na dolna ta bolkinania. Emgi hol i hanere na dolna bonanua.” ");
INSERT INTO sll_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dungure Pita yu ditongwi, “Yahuno, omaga talongwo ni dolni bolkiralga pire dine? Ni pir ni tere na yakel diralue.” ");
INSERT INTO sll_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dimba Yisas yu ditongwi, “Na gauna pir tere ni yakel diralua dino? Ha wo dinba, na di ni teralia piro. Hoale olo be dikinangure, ni na hana gin sui tai dire di kul sinanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ena Yisas na gina hobi yu di na tongwi, “Ni yalhobi ganulun dire nomani si gogo dalkio. God talhan para weni onangwo pamia dire ogolo pir tere wine ol tere na para wine ol na to. ");
INSERT INTO sll_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nabe oo aibing oo miki weni dimia. I ta dikinangwo ni di tibi ol ni tekiralga pamba. ");
INSERT INTO sll_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nalgiwe, pire ni yalhobi oon aibin akun olalua. Ol e pisolalga solere hon siina di ure ni yalhobi na aule inalga na kina ereho molabilua. ");
INSERT INTO sll_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni yalhobi ni nalga hol i honanua.” ");
INSERT INTO sll_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dungure Tomas yu ditongwi, “Ni makena nane? Nanga hol hankiminia. Na yalhobi tal ole hol i hanama di dine?” ");
INSERT INTO sll_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dungure Yisas yu ditongwi, “Na nan hol ya, mol pai ya, te ha weni iwe, hong bling memini tani moliwa. Yal ta na a ime ole Abe mongwo bani pi pa dinanga paikimua. ");
INSERT INTO sll_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni yalhobi na na han po singiwe, Nabe para hananua. Omaga ni yalhobi Nabe para han molere, maing para han pisolinua.” ");
INSERT INTO sll_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dungure yal Pilip Yisas yu ditongwi, “Yal Yisas ye, ni hamen Nabe maing di na tenanga, na yalhobi para han pisolaminue.” ");
INSERT INTO sll_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dungure Yisas Pilip yu ditongwi, “Pilipi, gobari weni na ni yalhobi kina mol i ubilgarai, ni na han po sikino? Yal ta na na hangiwe, Abe hania. Abe i tibi ol na to dinga i talongwo dine? ");
INSERT INTO sll_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilip, Nabe na kina si daule mol i ungwo umua di pirikino? Na ha di ni tegiwe, na nan piriga meri pire ta di ni tekiwa. Abe na yona wu bilere honagi omua. ");
INSERT INTO sll_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na Abe yong wu bilgere, Abe na yona wu bungwo pamia di hano. Ena yal ta di hankinanga panangwo na honagi nibil di ni tega i hanere, nomani si pir na to. ");
INSERT INTO sll_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ena na ha wo kara di ni teralia piro. Yal tau na nomani si pir na te monangiwe, na honagi nima ongwo olga meri ni ere para yu onanga pamia. Na Abe mongwo bani nalga pamia, ni yalhobi honagi nimni weni mongwo onanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni yalhobi na hana wine olere tal ta irala dire sirin bonanga tali ni teralga inanua. Nabe Wang yona wu bilere tal ta onangwo i hanere, yal i haang awala gananua. ");
INSERT INTO sll_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te ni yalhobi na hana wine olere tal ta irala dire sirin bonanga tali ni teralga inanua. ");
INSERT INTO sll_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ena ni yalhobi yon milni na te monanga monangiwe, na krehaman ha wine ol na to. ");
INSERT INTO sll_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tenanga Abe sirin bol teralga aki di ni tenangwo yal ta nu sinamua. Nu sinangwo yal iwe, Abe Kwiang ha pangwo hong yal i nu si olangure, ni yalhobi kina si daule moli pire yon wu bil monangwo monamua. ");
INSERT INTO sll_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Te ganba ari hobi Kwiang iwe, ta hankirere nimni mole ikinamua. Ikinamba, yal i ni monga sina i yon wu bilere wa momia, han po sinua. ");
INSERT INTO sll_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na ni aidoligere ni yalhobi gir mua mere mona di pire hon siina di ni yalhobi monga bani uralua. ");
INSERT INTO sll_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Habang obilga ganba ari ha maing pirikinangwo hobi hon ta na hankinamua. Hankinamba, ni yalhobi na hananua. Na hon moli nalga mere ni yalhobi para yu hon moli nanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nabe na pir na tongure na ni yalhobi pir ni teiwa. Tegere te ni yalhobi na pir na tere moli nanga haung bir u tibi nangwo gin iwe, na han pa dinanua. ");
INSERT INTO sll_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yal ta na grana bani wine olere wanga yal i, yon milni na na tenua. Yal ta yon milni na na tere wa monanga yal iwe, Nabe yong miling ni ni tenamua. Te Nabe tani taman. Na para yona milna ni tere u tibi pi ni teralga na hananua.” ");
INSERT INTO sll_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dungure Yudas, Yisas bai tal sinangwo yal i pisole, Yudas diing Yisas yu ditongwi, “Yal Yisas ye, ganba ari ha maing pirikinangwo hobi u tibi pire unanga hankinamba, na yalhobi nin na hanamua, dinga i tal ole ni hanamne?” ");
INSERT INTO sll_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dungure Yisas yu ditongwi, “Yal ta yong miling na na tere wa monanga yali, na grana ha wine onanue. Onangere Nabe yong miling ni tenamua. Ni tenangure na Nabe kina ereho ure, yal i kina si daule molere yong wu bil molabilga molabilua. ");
INSERT INTO sll_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yal ta yon milni na na tekinangiwe, grana ha i para wine olkinanga pamua. Ena ni yalhobi ha pingiwe, na nan ha taman. Nabe na nu si olungwo ya i grang pire diwa. ");
INSERT INTO sll_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Omaga na nan ni yalhobi kina molere ha yu dire nir si ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ena aki di ni tenangwo nimni mole mol pai onanga yal iwe, God Kwiang, Nabe na hana bani aine na tere nu sungure, ere ime ure, ha para weni nir si ni tenamua. Te na ha di ni te i uga hobi yal i ere hon ainere nir si ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ni yon ura dinama dire na nan ol ni teiwa. Ganba ari ha maing pirikinangwo hobi yon ura dinama dire ongwo meri na ta olikiralua. Ni yalhobi nomani sala ole ganulun dire kul pirikio. ");
INSERT INTO sll_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na ni aidole ere nalga pi mole hon siina diralga pamua, digiwe, ha gobari di ni te i uga pir pisolinua. Nabe obilga mo hora kungwo yali na molga pire ni yalhobi na nomani na te uni sina dama, Abe mongwo bani nala diga ipire yon milni wai pir na tenanba. ");
INSERT INTO sll_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tal i olo u tibi hungure homa awa ha tani di ni teya. Di ni tega meri emgi u tibi nangure, ‘o, ha di na tongwo irai ha pangwo dungwo pamua’ dire pir na tenania. ");
INSERT INTO sll_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na omaga ni yalhobi ha miki ta di ni tekiralia. Ganba bani singaba Seten urala dire a non omua. ");
INSERT INTO sll_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Omia ure na gauna sibala dire u dia sinamua. Te na Nabe yona milna terere grang wine ol i uga ganba bani ari ha maing pirikungwo hobi na han po sinama. Ni yalhobi aire namna pano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ena Yisas ha aine yu ditongwi, “Ena hopi erin dungwo meri na moliwa. Molgere te Nabe iwe, er hong yal momia. ");
INSERT INTO sll_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mongure na gaminahobi er yolang sungwo meri monua. Monia Nabe grang wine olkinanga hobi, yolang tau miling holkungwo meri monanua. Monangere Nabe hopi yolang di si olungwo meri ni yalhobi ere yu ni aidolangwo pamua. Te Nabe grang wine onanga hobiwe, hopi yolang dining bai engwo, miling miki weni hongwo meri monia. ");
INSERT INTO sll_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mongere ha di ni tega ogolo pire haya sigare kule u wai onua. ");
INSERT INTO sll_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pire u na molga mala i na tege ere molo. Monanga, na ere u ni monga mala i molere, ni kene ol ni teralua. Ena er yolang ta di si olinga nin bangi dire miling hongwo hano? I ta holkimia. Te ni yalhobi u na na tege ere molkinanga er yolang miling holkungwo meri monanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ena na iwe, hopi erin dungwo meri molgere, ni yalhobi yolang dungwo meri monua. Molere yal ta u na na tege ere monangere, na ni kene ol ni teralga yal iwe, tal dime dire ole mol i nanua. Te na yal ta aki di ni tekiralga yal iwe, tal dime dire ta onanga paikimua. ");
INSERT INTO sll_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Te yal ta na na tega ere molkinanga, er yolang bai olungwo meginungwo meri monania. Bai olungwo iwe, yal ta kri di pire endo dongwo bani olamua. Olangwo meri, God ni yalhobi ere para yu ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ena ni yalhobi u na na tege erere, na ha diga a i si ware monanga, molere na tal ta ol na tenama di pire, sirin bol na tenanga meri, na wine ole, ol ni teralga pamua. ");
INSERT INTO sll_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni tal wai dime dire ol monanga, ari hobi ni hanere, God hang a yuwo olamua. Ena olangwiwe, na pir tere dolna boliwa, dinanga, ha wo kara dinanua. ");
INSERT INTO sll_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nabe yong miling na na tomia. Na tongwo meri, na ere yu yona milna ni yalhobi ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yona milna ni tega hobi molio. Na Nabe grang ha wine olere, yong miling tongwo bani molga meri iwe, ni yalhobi ere yu na grana ha wine onga i, yona milna ni tega bani monanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na yona milna horega wai ni yalhobo monga bani kunung bere panama di pire, ha i di ni teya, ere ni yalhobi monga bani pai wa dire pai nama. ");
INSERT INTO sll_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na grana ha iwe, memini yu pamia, na yona milna ni tega meri iwe, ni ereyu ari enin tau hobi yon milni to. ");
INSERT INTO sll_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yal ta enin tau hobi pring ire gol tenangwo yali, arihobi yong miling tere mongwo i, mo hora kumua dinaminue. ");
INSERT INTO sll_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni yalhobi yu onana dire di ni teya, onangiwe, na yona yal weni monanua. ");
INSERT INTO sll_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Honagi ari hobi irang singaba tal ta olala dire nomani si pungwo i, honagi yal hobi ta han po sikimia. Yu ongwo i pire, na honagi ari ni yal hobi monua di ni tekiralia. Na Nabe grang bani piriga meri doling bole di tibi ol ni tere yona yal hobo di ni teya. ");
INSERT INTO sll_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ni yalhobi na ta na pare enanga paikimia. Na ni yalhobi ni pare ere igere, mol pai oli pire, tal wai dime dire onana dire di ni teiwa. Onangiwe, ya wine ole pai monangwo monamua. Yu olere, na hana a i si ware mole, Abe sirin bol tenanga meri, wine ole ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Grana ha di ni teya, ari hobi para yon milni tere molio. ");
INSERT INTO sll_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ena God molkimia dire pir tekungwo hobi, ni yalhobi yong ki e ni tenamia. Tenangwiwe, hanere, o, singaba Kraist homa yong ki e tongwo pamia di hananua. ");
INSERT INTO sll_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te pir na tere wakina, God pir tekungwo hobi hanere yong ki e ni tekungure. Tekimba, na ni yalhobi ni pare egere, pir na tenga hanere, yong ki e ni tomua. ");
INSERT INTO sll_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na homa di ni tegarai yu pamia, Honagi ari hobi mo yu pire irang singaba a ime olangwo paikimia, ha i ogolo pirio. Ari tau na ol gogo dal na tongwo meri ni yalhobi ere para yu ol ni tenangwo pamua. Te yalhobi na grana ha wine onangwiwe, oli pire ni gran ha para wine onangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pamba, Nabe na nu sungwo yal i maing pir po sikimia, na gamna hobo monia, ni hanere gran wine olkire tal gogo ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Te na u tibi pire ha maing di tekia, tal nigi dongwo ol wangwo pring pai tekungure. Tekinamba, na u tibi pire ha maing di teya, pimba, pirikiwa dinangwo paikimia, tal nigi dongwo ol wangwo pring pai tomua. ");
INSERT INTO sll_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Te yal tau yong ki e na tongwiwe, na tani taman. Nabe para yong ki e tomua. ");
INSERT INTO sll_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Te na tal wai olkia, ari hobi tal nigi dongwo ol wangwo pring pai tekungure. Tekinamba, na ari tal ongwo meri olkire, tal guma hon dongwo miki weni olga, hamba, yong ki e na tomua. ");
INSERT INTO sll_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tongwiwe, na tani taman. Nabe para e tomua. E tongwo maing iwe, homa Lo awa ha ta omaga u nima ongwo yu pamia, ‘Yalhobi yong ki ya mone e na tomua.’ ");
INSERT INTO sll_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ena di gon gan ole yon a ura dinangwo yal ta Nabe kina momia, na bai nu sigere, ure aang mol ni tenamua. Yal iwe, God Kwiang ha pangwo hong yal momia. Nabe mongwo bani pisole, ure na hana i di tibi ol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tenangure ni yalhobi na honagi kebering holga bani kina ereho moli ubilgarai pire na maing ereyu di ba bolio. ");
INSERT INTO sll_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Moli pirere tal ol ni tenangure pire mobin hal wa na tekinana di pire ha i homa di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yalhobi Yuda ari ha maing oo ala pire ni si dolni inamua. Ire ni si gonamia. Golere, owa, God aki di tega pamua di pinamia. ");
INSERT INTO sll_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Di pirere, yalhobi Nabe na kina ta na han po sikinamua. Sikire tal yu ol monamua. ");
INSERT INTO sll_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Monangwo ipire na homa awa ha tani di ni teiwa. Tegiwe, emgi ol ni tenangwo hanere hon nomani si pinanua. ");
INSERT INTO sll_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ena homa nan ni yalhobi kina moli ubiliraba, ha i ta di ni tekirawa. Omaga na nu si olungwo yal i mongwo bani nala dire ha i di ni teiwa. Teiba ni yalhobi na makena nane? dire sirin bol na te pirikinua. ");
INSERT INTO sll_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Omaga na di ni tega milni gul sungure ganulun dinua. ");
INSERT INTO sll_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dinba ha weni di ni teya. Na ni aidole nalga wai pamua. Horalga di gon gan ol ni tenangwo yal i hunangwo pamba. Nalia, di gon gan ol ni tenangwo yal i ure yon wu bile aki di ni tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Terere ganba ari hobi tal nigi dongwo ol wangwo pring nin i tibi ol tere, te tal dime dire ole mol pai onangwo hol i tibi ol tere, te God ha hol bani enangwo maing ere i tibi ol tenangure, nin pir po sinangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tal nigi dongwo ol wangwo pring maing yu pamia, ari hobi na pir na tere grana wine olkungwo i pring pamua. ");
INSERT INTO sll_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tal dime dire ole mol pai oli nangwo iwe, ere maing yu pamia, na ere Nabe mongwo bani nalga ni yalhobi baniya hon ta na hankinanua. ");
INSERT INTO sll_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te God ha hol iwe, ere maing yu pamia. God ganba ari singaba Seten ha hol haya ol tere ebil si tongwo momua. ");
INSERT INTO sll_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na ere nalga ha hon di ni teralba, nigi de pinanua. ");
INSERT INTO sll_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pinanba, God Kwiang, ha pangwo hong yal i, urere, God krehaman ha bling hobi nibil di ni tenangure pinanua. Pinangere, yal i nin nomani si pinangwo meri di ni tenangwo taman. God ha di tibi ol tongwo meri giu dire di ni tenamua. Tere emgi tal u tibi nangwo i pire awa ha para di ba bol ni tenamua. ");
INSERT INTO sll_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tere na homa ha di ni tega meri irai hon doling bole di ni tenamia. ");
INSERT INTO sll_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tenangure ari hobi pirere na hana ayuwo olamua. Abe grang ha wine ole pai ongwo i hong tani na moliwa. Mole yu di ni teya, God Kwiang na hana para weni ire di tibi ol ni tenama di pire diiwa. ");
INSERT INTO sll_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ena haung obilga mole ere ogere na wa dunanba, haung gobari ta molkiralia, hon u tibi egere na hananua.” ");
INSERT INTO sll_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dungure na gina hobi nan bolbin dire, “Ha dungwo i tal memini pangwo pire dime? Haung obilga mole ogere, na wa dunanba, emgi hon u tibi egere na hananua, dire ha ta yu dungwi, Nabe mongwo bani nalua dungwo i tal memini pangwo pire dime? ");
INSERT INTO sll_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yal i ha dungwo i nan memini pir po sikiminua.” ");
INSERT INTO sll_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Dire sirin bol tenamna di omingere Yisas haya han pa dire yu di na tongwi, “Na haung obilga mole ogere, na wa dunanba, emgi hon u tibi egere na hananua, di ni tega i pire bolbin dino? ");
INSERT INTO sll_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","I dinba, ni yalhobi kere bare hai mengere, ari ha maing pirikungwo hobi gun enamua. Ena guman megine monana di onangure monanba, guman meginangwo i hon si kulu sinangure, guman nimni mole gun enanua. Ha weni di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Agir mindebe ongwo i gir nin kul nenangwo habang werigi dungure gaung gul pimia. Pimba kul mena olere gir hanere gul hon ta pirikimia, wai sungure wai pimua. ");
INSERT INTO sll_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pungwo meri iwe, ni yalhobi omaga al gir miing ala ya mongwo gul pungwo meri monangere guman meginamua. Meginamba, emgi hon na hanere, guman meginangwo i, pisolere gun enanua. Gun enangiwe, tal ta ure i susu ol ni tekinama. ");
INSERT INTO sll_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ena habang gin i tal ta irala di pirala olkire sirin bol na tenanua. Na ha weni di ni teralia. Ni yalhobi Abe tal ta na tenama di pire sirin bol tenangere, na hana bani aine ni tenangure inanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Homa moli ungarai na hana a i ware tal ta irala dire God sirin bol tekiniraya. Omaga sirin bol tere inanga ire yon horega onangure wai pinanua. ");
INSERT INTO sll_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ha di ni te i uga hobi ha bangi biire mone di ni teya. Moli pire gin ta ha bangi biire hon dikiralia, maing di ba bole di ni teralua. ");
INSERT INTO sll_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Habang gin iwe, ni yalhobi na hana ire ware sirin bol tenanga, na ni yalhobi aki di ni tere Abe ditekiralia, Abe nin ni hanere yong miling ni tenangwo pamua. Na God mongwo bani ya ime umia di pire yon milni na tenia. ");
INSERT INTO sll_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tengiwe, God ere yong miling ni tomua. Na Abe aidolere ya ganba bani wiya, omaga hon ganba baniya aidolere, Abe mongwo bani nalge.” ");
INSERT INTO sll_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dungure na gina hobi yu ditomingi, “Homa ha bangi biire dinga tal irai dikire omaga ha memini di ba bole di na tengiwe. ");
INSERT INTO sll_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ari ta sirin bol ni tekungure tal han hobi para weni ni nin hanere pir po singiwe. Ni God mongwo bani ya ime unia di pire na omaga ni han pa diminua.” ");
INSERT INTO sll_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dimingere Yisas yu di na tongwi, “Owa para dinia. Haya pir na tekinba, pir na teno? ");
INSERT INTO sll_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tenba, tal ta ol na tenangwo habang omaga u mala umia, na aidolere u susu pire oon hona hona i moli nanua. Na pisolere ongere na nan muru ta molkiralba, Nabe kina ereho molalga pamua. ");
INSERT INTO sll_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ni yalhobi monga sina i yon ura dinama dire ha i di ni teiwa. Ni ganba guliya, galeng talime bolimbani monanua. Na ganba grang hongwo a ura diga i pire ni yalhobi nin yulang bole molio,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ena Yisas ha i di te pisolere, hamen bani yuwo hanere, yu dungwi, “Nabe, tal ol na tenangwo habang omaga u mala umia, ni na hana a yuwo ol na tenania. Tenanga, na ni wani tani molia, na ere ni hani a yuwo ol ni teralua. ");
INSERT INTO sll_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na nan ari para weni breng a holo so di na tenua. Tengiwe, ari tau nu ke na tenga hobi, mol pai gobari ya mol panangwo bani panangwo teralga pire na tenua. ");
INSERT INTO sll_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nabe, ni God taniga monia, su ta molkinua. Te na iwe, na bai nu si olinga ya ganba baniya ure, hana Yisas singaba Kraist engure moliwa. Molere ni na kina moli obilgere, ari hobi nan yasu pir na tere, mol pai gobari weni inangwo pamua. ");
INSERT INTO sll_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na ganba bani ni yulan hani kuria i tibi olga ari para hamua. Te na honagi onama dire i ana bani enga meri wine ole, ol pisoliwa. ");
INSERT INTO sll_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nabe, homa ganba olo u tibi hungure, ni na kina mobilga yulan na teniraya. Na tenga meri irawe, omaga ni monga bani uralga pangwo ipire yulan ere yu na to. ");
INSERT INTO sll_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ganba ari mongwo sina i tau ni nu ke tere i na ana bani enga hobi iwe, ni gun han i para boling kul tega pimia. Pirere ni wani aun weni molere na dolna bonama dire na tengere, dolna bomia. Bolere ni gran ha para wine omua. ");
INSERT INTO sll_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ongure, na ha dire tal olga hobiwe, na nan oma di hankimia, Nabe ni yulan na tengere oma di hamia. ");
INSERT INTO sll_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ni ha di na tengarai, boling kul tega ari nu ke tenga hobi para pimia. Pirere a i si wamia. Ware homa na ni kina mole ya ime uma di na hamia. Hanere ni na bai nu singa uga han pa dimua. ");
INSERT INTO sll_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ena na ha di ni tegiwe, ni arihobi aki di tenana di piriwa. Ari hobi gogo aki di tenana di pirikiwa. Tau ni nu ke tere i na ana bani enga hobi obil aki di tenana di piriwa. Tenanga hobi iwe, ni wani aun momua. ");
INSERT INTO sll_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ni wani aun hobi iwe, na wana auna momua. Te na wana auna hobi iwe, ni wani aun momua. Molere tal dime dire oli nangwo, hanere ari hobi na hana a yuwo olamua. ");
INSERT INTO sll_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ena homa na ganba bani moli ugarai wai simia, hon siina di ure ni kina molabilga pamua. Molabilgere yalhobi nin ganba bani monangwo pamua. Nabe amane hong yal ye, ni ari tau i na ana bani enga hobi yulan tere aki di to. Ni nan yona tani ebilia. Ebilga meri iwe, yalhobi yong tani enama di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pirere na ni hani kuria ire ugarai, yalhobi kina molere, nibil di tere, kwi mol tega ire nimni momua. Molere ta hogal sikimba, nu ke tenga yal digan taniga ha maing buku hogal sinamua di engwo meri, nima omia hogal sinamua. ");
INSERT INTO sll_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na omaga ni monga bani uralga pangwo ipire ganba baniya molere ari hobi di teiwa. Di tega ha i, na yona milna horega yalhobi teya, yalhobi ereyu yong horega mongwo bani pai wa dinama. ");
INSERT INTO sll_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ena Nabe hani kuria boling kul tega ni wani aun hobi a i wangwo hanere, ha maing pir tekungwo hobi nigi de pir tere yong ki e tomia. Te na hol ta doling bolgere, ha maing pirikungwo hobi hol ta doling bomia. Bolere na na hanere, yong ki e na tomua. Te ha maing pungwo hobi na na dolna bongure hanere ere yu yong ki e tomua. ");
INSERT INTO sll_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ena ha maing pirikungwo hobi mongwo sina i na gamnahobo tau mongwo i aule ire nana di pirikiwa. Seten yal nigi dongwo unangure ni kene ol tengere, ol gogo dal tekinama di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na ha maing pirikungwo hobi mongwo meri ta molkia. ");
INSERT INTO sll_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Molkiga meri gamnahobi ere para yu ta molkimua. Nabe ni hani iwe, ha pangwo kara dinia. Digiwe, u gamnahobi yong sina pire a yo te tenangure, dime dire mol pai onamua. ");
INSERT INTO sll_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Homa ni na bai nu si olingarai, ya ime ure ganba ari hob mongwo sina i molere, hani kuria wai boling kul teiwa. Te na ere gamnahobo i nu si olgere, ganba ari mongwo sina i pi molere, ni hani kuria wai para boling kul tenamua. ");
INSERT INTO sll_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na gamnahobo i yona milna tere molgere, ni tal ta ol na tengere, ni wani aun molere, ni ol wai ol tenga ha maing pir tenama di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nabe, omaga na dolna bongwo hobi tani taman. Yalhobi hon banta banta pire, hani kuria wai boling kunangure, ari tau pinangwo pire na dolna bonangure, aki di tenana di pire di ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nabe ni wani aun hobi para weni nan yasu yona tani ere mobilga meri nan ari hobi kina yona tani ere moli namna di piriwa. Yong tani ere monangwo hanere, ari hobi para weni, ‘owa God Yisas bai nu si olungwo pamua,’ di hanamia. ");
INSERT INTO sll_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Di hanere, ni na milna pir na tenga meri, ari na dolna bongwo hobi ere yu miling pir tenaminga nan yasu yona tani ere mobilga meri yu moli nama di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na yalhobi mongwo mala i molere kene ol tegere, te ni na molga mala i molere kene ol na tenua. Ni na kina kene ol tominga i, yalhobi yong tani ere monamua. Monangwo ari hobi hanere, ‘owa, God na bai nu si olungwo pamio, te God ha maing pungwo hobi wai hanere, na ere para na wai hamua,’ di hanamia. ");
INSERT INTO sll_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ena Nabe, na dolna bongwo hobi ni nu ke tere i na ana bani enia. Engiwe, na kina moli nabila di piriwa. Nabilgere homa ganba olo u tibi hungure, yon milni na tengere ni na kina si daule mobiliraya, omaga ere yu moli nabilgere arihobi hanama di piriwa. ");
INSERT INTO sll_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nabe, amane hong ye, ganba ari ha maing pirkungwo hobi ni maing pir po sikimia, na nan haniwa. Ena dolna bongwo hobi ni na bai nu singa uga pama di hamia. ");
INSERT INTO sll_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na dolna bongwo hobi ni hani bani aine tere tere moli obilgere, nan yasu yona tani ere pana gale molbilga meri, ni nan arihobi para yu moli pire si daule monamna di piriwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ena Yisas God ha i di te pisolungure na gina kina aule ire, iri si Kidron nir nulu pire ere hoibi omingi. Pirere pilawa sire er yuung kungwo sina i pi momingi. ");
INSERT INTO sll_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ena u sina i Yisas na gina gobari pire pare pare momingi. Momingere bai tal sinangwo yal Yudas, Yisas na gina kina moma di pungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Di pirere, soldia tau ire, ha maing oo bir singaba Perisi para yal nona pangwo yal tau nu sungwo hobi ire dire, aule ire Yisas mongwo bani ongwi. Ongwo hobi kewa lampi ire, di kuba ire dire ongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ena Yisas tal ta ol tenangwo nin haya han po sungwi. Sire mala pire, “Ni yalhobi ara wa du i une?” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Yisas Nasaret hong yal wa duminua,” dungwi. “Wa dunga yal i na moliwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dungure Yudas bai tal sinangwo yal i sina i mongwi. Mongure Yisas “na nan moliwa” dungure ari ungwo hobi kulung pire mobing hol yare habilai sungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sungure Yisas mole, “Ara wa du i une?”, dungwi. “Yisas Nasaret hong yal i wa duminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Wa dunga yal i na homa na moliwa di ni tegirawe. Na nan na wa dunga pamia, gamnahobo i han uning solanga ere namua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dungwiwe, homa awa ha di engwo irai yu dimiraya, “Nabe nu ke tere i na ana bani enga hobi na ta ai dolekiralua.” Di engwo i omaga nima ongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ena Saimon Pita di baina ere mongwi. Molere aki di ire ha maing singaba honagi yal ta haang Malkas kraung weni hol i di bali sungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sungure Yisas Pita yu ditongwi, “A, ni yu olkire, di golaun yaulo. Nabe gauna gul na tongwo i na ikinama di pino? Iralua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ena soldia yalhobi ire, kene ongwo yal ta ire, Yuda soldia ire dire, Yisas pi are han hongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Holere ire pi Yuda ha maing oo singaba Kaiapas imaumbi Anas ke pangwo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ena Kaiapas iwe, homa Yuda arihobi yu ditongwi, “Nan mominga baniya, yal taniga gonangwo i, ari para weni breng ol i namia. Ol inangwo i wai panamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ena Saimon Pita ire, na ire dire, Yisas aule ire ongwo hol i doling boli obilgi. Obilgere, Yuda ha maing oo singaba bir na gumana haya han pa dungure, ere singaba oo kepangwo malgi ogi. ");
INSERT INTO sll_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Oiba, Pita malgi hore u egere mongwi. Momia na ala pire, hon siina di u egere pire, u egere kene ongwo ama ta yu ditegi, “yal ta i ala unamba,” ditegere Pita ala ongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ala ongure u egere kene ongwo ama i Pita yu ditongwi, “Ni para yal Yisas gamahobo irai mongiwe.” Dimba Pita, “A, na ta molkiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dire honagi ari tau, polisman tau ire dire, hamen hair gole endo gale pir mongwi. Mongwo bani Pita para pi mole endo pir mongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ena ha maing singaba bir i Yisas, “ni gamnahobi ara mome? Ha maing dinga talwa dine?” dire sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Pungure Yisas yu ditongwi, “Na ari maulung bani nimni mole ha di tibi ol teya. Tere habang habang ha maing oo para weni ware, ha bling mining oo ware, Yuda ari hobi u ku bongwo bani ha ta di kul si tekia. ");
INSERT INTO sll_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Talongwo sirin bol na tene? Ari na ha ditega pungwo hobi sirin bol tekino? Yalhobi i na ha diga pir po simia, sirin bol tenanga di tibi olangwo pirikino?” ");
INSERT INTO sll_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yu dungure polisman ta mobing hol i aire mole Yisas di dagi sire yu ditongwi, “Ni ha maing singaba ha di ni tongwo ha bano?” ");
INSERT INTO sll_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dungure Yisas yu ditongwi, “Na ha nigi dongwo diralga di tibi olanba. Na ha pangwo pinanga ha diiba, talongwo na sine?” ");
INSERT INTO sll_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ena Yisas han hongwo mere i, yal Anas ha maing oo singaba haang Kaiapas oo malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ena Saimon Pita endo dongwo bani mole pir mongure ari hobi yu ditongwi, “Ni yal i gamahobo para mono?” Dimba Pita di kul sire, “A, na ta hankiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dungure ha maing singaba honagi yal ta, Pita kraung di keru sungwo yal i ening ta mongwi. Molere Pita yu ditongwi, “Ni yal i kina er yuung gul ire ereho monga hangirawe.” ");
INSERT INTO sll_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dimba, Pita, “Na hankiga han dinua,” dungure hoale gintani be dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ena arihobi Kaiapas oo malgi aidole honmil sinamoki Yisas aule ire, ere nambawan gabman mongwo ongwi. Pire ala namba, ongwo haung iwe, God han uning sungwo haung Pasoba erin momia. Mole ala i pire homena gogo neralga paikimua di pire isra dungwi. ");
INSERT INTO sll_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dire mena i mongure gabman Pailat u pa dire yu ditongwi, “Ni yalhobi yal i talongwo ha hol ole ha di mere si terala dire aule ire une?” ");
INSERT INTO sll_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dungure aule ire ungwo yalhobi gabman Pailat yu ditongwi, “Yal i Lo ta si keru sikima, auli humingere.” ");
INSERT INTO sll_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dimba Pailat arihobi yu ditongwi, “Ni yalhobi nin aule i pire ha hol ol tere nin memini panangwo meri ol tenana pio.” Dungure Yuda ari yu ditongwi, “Na Yuda nan memini pangwo ari si golo dikimua.” ");
INSERT INTO sll_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ena homa Yisas awa ha dire, “Yal tau er pera bani na sinangure golalua,” dimiraya, omaga u nima namua. ");
INSERT INTO sll_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dungure Pailat ere opisi ala pire Yisas “wo” dungwi. Dimia ongure sirin bol pungwi. “Ni Yuda ari singaba king mono?” ");
INSERT INTO sll_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dimba Yisas yu ditongwi, “A, i ni nin pinga mere pire din mo, yal ta di ni tongwo dine?” ");
INSERT INTO sll_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dungure Pailat yu ditongwi, “Na Yuda ari yal molio? Ta molkiba, ni nin gaminahobo ha maing oo singaba hobi ni aule ire na molga umia. Tal ongere ni aule ire ume?” ");
INSERT INTO sll_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dungure Yisas yu ditongwi, “Na ganba baniya hong yal molkia. Baniya hong yal molalga na gamina hobo i na han uning si olangure Yuda ari na han honamo? Ta holekinamia, Yuda ari kina kura bonangwo dimba, molkiwa.” ");
INSERT INTO sll_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dungure Pailat yu sirin bol pungwi, “Ite, ni singaba king mono?” Dungure Yisas yu ditongwi, “Ha i ni nin gran bani u mena ungwo timawe. Namine ganba baniya na kul nongwo molere, ha pangwo muru di tibi ol terala dire u molia. Molgere ha pangwo pirala dire doling bongwo hobi wine ole pir na tenangwo pamua.” ");
INSERT INTO sll_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dungure Pailat yu ditongwi, “Ha pangwo ha dinga i tal ha pire dine?” dungwi. Ena Pailat ere maini pire Yuda ari hobi yu ditongwi, “Yal i pring ta paikimia, ha hol ol teralga paikimua. ");
INSERT INTO sll_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ena ni yalhobi nin memini yu pamiraya, God Yuda ari han uning sungwo erin haung hani pangwo tan taniga gule ole ole oliraya. Yuda singaba King gule ole ni tenamno?” ");
INSERT INTO sll_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dungure ari hobi grang mu dire yu dungwi, “A, yal i pisole, Barabas na to.” Barabas yal ta taling tol di nere ari sigole hani pangwi. ");
INSERT INTO sll_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ena Pailat dungure soldia hobi homa kuba ire Yisas sungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sire han galeng engwo ta ire ama kere, breng bani sungwi. Sire galsina mori wai weni ta ire wa tongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wa tere iriyala tere hasu maa e tere, “Ni Yuda ari singaba king irawe” dungwi. Dire di dagi sungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sungure Pailat hon maini pire Yuda ari hobi yu ditongwi, “Piro, na yal iya, maing wa duiba, ha ta oun dekimia, na aule ire ni monga bani uralga hananua.” ");
INSERT INTO sll_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ena Yisas breng bani han si tongwo i gal mori wa tongwo i kina ya dungure ere maini ongwi. Ongure Pailat arihobi yu ditongwi, “Yal tima hanega.” ");
INSERT INTO sll_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dungure Yuda ha maing oo singaba tau ire, polisman tau ire dire, Yisas hanere gala dungwi, “Er pera bani so. Er pera bani so.” Dimba Pailat yu ditongwi, “Yal iya na maing wa duga ha ta oun dekimia, ni yalhobi nin aule ire pire er pera bani si gonana pio.” ");
INSERT INTO sll_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dimba Yuda ari hobi Pailat yu ditongwi, “Na yalhobi nan Lo krehaman ha memini yu pamia, Yal ta na nan God wang moliwa dinangwo yali, gonangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ena Pailat ha i pungwo oun dongure ere gabman opisi ala ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pire Yisas hon sirin bol pungwi, “Ni ara ni kul eme?” Dimba Yisas ha ta mong ditekungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ena Pailat hon sirin bol pungwi, “Ni talongwo ha ta mong di na tekine? Na yulang bol i pire ni gule olalga pamio, te na yulang bol i pire er pera bani ni siralga pamia, pirikino?” ");
INSERT INTO sll_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dungure Yisas yu ditongwi, “God ni yulang ni tekinangwo tal yu ol na tekinanga pamba, yulang ni tomia. Ena ni prin pamba, te yal ta na na aule i ure ni tongwo yal iwe, tal nigi weni dongwo omia, pring bir weni pamua.” ");
INSERT INTO sll_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ena Pailat ha i pire gule olala dire hol wa dumba, Yuda ari hobi gala erakere dire, “Ni yali gule olanga nambawan gabman Sisa enin ta molkinania. Yal ta singaba king moliwa dinangwiwe, Sisa kina kiang kiang monangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ena Pailat ha i pire Yisas aule ire maini ongwi. Pire ha hol ongwo bol hulu semen wigi sungwo bani ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mongwo gin iwe, God Yuda ari han uning sungwo erin u mala ongure homena han akun ongwo habang mongwi. Mongwiwe, omare weni twel klok molere Pailat Yuda ari hobi yu ditongwi, “Ni yalhobi singaba king irai momia hanega.” ");
INSERT INTO sll_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dungure yalhobi yu ditongwi, “So. So. Er pera bani si golo.” Dungure Pailat yu sirin bol pungwi, “Ni singaba king irai na er pera bani sinama di pino?” Dungure ha maing kene ongwo hobi yu ditongwi, “Singaba king Sisa tani moma di pir tominia. Yal ta moma di pirikiminue.” ");
INSERT INTO sll_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dungure Pailat Yisas aule ire pire, ere pera bani si gonama dire, tongure a ire ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ena ari hobi Yisas er pera nin haungure aule ire ongwi. Ere pi ganba ta haang Breng Yulang ganba bani ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pirere Yisas er pera bani si engwi. Ere yal su er pera su bina holo holi si engwi. ");
INSERT INTO sll_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ena Pailat, “Yisas Nasaret hong yal mole, Yuda singaba king momua” dire, mining bole er pera gumiling bani engwi. ");
INSERT INTO sll_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Engure Yisas er pera si engwiwe, oo malgi mala dimia, Yuda ari miki weni ware, kere hangwi. Ha iwe, ha howa sui tai dire Hibru ha ire, Latin ha ire, Griki ha ire dire, mining bol engwi. ");
INSERT INTO sll_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Emia Yuda ari singaba hobi Pailat yu ditongwi, “Ni ha yu dire mining bol enga i paikimia, yal iwe, Yuda ari singaba king molkimia. Yal i na nan Yuda singaba king molia dimua dire bolo.” ");
INSERT INTO sll_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dimba Pailat yu ditongwi, “Na ha homa mining bol ega i para ya dinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ena soldia hobi Yisas er pera bani si e pisolere, galsina tau ire tabin sui sui dire ering si ere soldia hobi i holo holo ongwi. Pirere gal arikri ta para i ongwi. I omba gal iwe, banta sibirikima. ");
INSERT INTO sll_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ena soldia hobi, “Gal i a bali sikio. Nan santu simingere yal ta win sinangwo yal i inamua,” dungwi. Dire yu ole i holo holo omia. Ongwiwe, ha maing buku homa awa ha di emiraya omaga kara nima ongwi. Awa ha iwe, yu pamia, “Yalhobi na gal kul i ebir sire i holo holo namio, te gal arikri para santu sire inamua” di emiraya, omaga soldia hobi Yisas yu ol tongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ena Yisas aang Maria ire, ebering ire, Maria diing Klopas eumbi ire, Maria diing Magdala hong al ire dire, al sui sui dire hobi, Yisas er pera si engwo dimani mala i mongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mongure Yisas aang na kina molgere han ime ole na hangwi. ");
INSERT INTO sll_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hanere Yisas aang yu ditongwi, “Alhuno, yal i ni wani momua” dire na hon yu di na tongwi, “Yahuno, na namine iwe, omaga ni nimai momua.” Dungure na al i na namine monama dire kene ol moliwa. ");
INSERT INTO sll_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ena tal ol tongwo i para nima pi pisolimia, awa ha taniga di engwo irai ya dimia, omaga nir goliwa dinangwo, nima nangwo ipire Yisas “nir goliwa” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ena botol dungwo ala i nir gu kengwo mongwi. Momia gal ta nir bole bli ware nenama dire Yisas grang wangwi. ");
INSERT INTO sll_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wangwo Yisas nere, “Talhan onangwo meri para ol pisolimua” dire nugung goli dire gongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Gongwo gin iwe, Prainde molere ongi Sabat habang erin bir u tibi namia, talhan akun olalua di pungwo habang gongwi. Gomba, Yuda ari hobi yone er pera bani ya di panangwo nigi denamua di pungwi. Pire Pailat mongwo pire, kebering di keru sire yone man wu enama dire sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pungure soldia tau pire yal su bina holo holo er pera si engwo i kebering di keru sungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sire Yisas ere yu sirala di hamba, haya gomia hanere kebering di keru sikirere han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Olimba, soldia ta kula ire daling bani sungwi. Sungure algi nir wo kina ya ime ungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tal ongwo hobi na nan hanere di tibi oliwa. Olgiwe, ha weni kara pamua. Pangwo ipire, ni ari hobi ha i doling bole a i si wanana dire di tibi ol ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ha maing buku awa ha di engwo meri irawe, omaga talhan hobi para u tibi pire nima pi pamua. Ha iwe, yal ta yal i yulang taniga di keru sikinamua dimiraya omaga nima omua. ");
INSERT INTO sll_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Te awa ha ta yu pamiraya, “Yal i gonangwo kula sire para hanamua.” ");
INSERT INTO sll_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ena yu ol te pisolungure, Arimatia hong yal Yosep Yisas yone irala di pire Pailat sirin bol pungwi. Yosep iwe, Yisas grang wine omba, Yuda ari hobi kulung pire aunabo nure wangwi. Ena Pailat, yone inana po ditongure Yosep ire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ena homa weni yal Nikodimas ginangwo Yisas mongwo pire sirin bol pungwo yal i, er su bli yangwo niring kunung wai ungwo holere oun domia, boksi ala ere ire, Yosep kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pire ya suri Yisas yone ire gal yobile er niring kunung ungwo yone bil tongwi. Togwo i Yuda ari man wu erala dire nin memini pangwo ongwo tali ongwi. ");
INSERT INTO sll_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ena Yisas er pera si engwo bani u sina ta mala dungwi. U sina iwe, hulu grang ari yone ta ere ere olkungwo ala i tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Olungwo gin iwe, Prainde haung molere ongi Sareba erin habang u tibi namia dire hulu grang ala i man wu engwi. ");
INSERT INTO sll_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ena Sarebir haung honmil sinamo mibi manbi hamen tangure Maria Magdala Yisas yone engwo bani ongwi. Pirere hamba, hulu hona grang si pera di engwo i dikimia hangwi. ");
INSERT INTO sll_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hanere bli si malgi pire Saimon Pita na kina yu di na tongwi, “Yasuro, pi tege eminga yal Yisas yone engwo bani irai dikimia i banta ongwo hankire uminga yawe.” ");
INSERT INTO sll_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dungure Pita na kina bli hama bare si ominga na iri si homa eminia. ");
INSERT INTO sll_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Erere pi hona haminba, gal yamoni dimia hanere maini momingi. ");
INSERT INTO sll_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ena Saimon Pita emgi u pa dire ere ala ongwi. ");
INSERT INTO sll_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pire gal tau dungure gal han ta breng bani yobilungwo gal i para dimia hangwi. ");
INSERT INTO sll_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Breng bani yobilungwo gal iwe, gal tau dungwo mala i ta dikima, pi nin bangi dimia hangwi. ");
INSERT INTO sll_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hangure na homa ure ala ogi. Pirere talhan ongwo i hanere, Yisas airungwo pamia, di hanere nomani si pir tegi. ");
INSERT INTO sll_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tega gin iwe, ha maing buku awa ha mining bole Yisas gole ti si hon ere airama dungwo i, na yasu pir po sikibilia. ");
INSERT INTO sll_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sikire ere malgi obilgi. ");
INSERT INTO sll_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ena Maria yone engwo hona grang aire mole hai me mongwi. Me molere ikwi bole han ala ire olungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Olimba ensel sutani gal pege ware Yisas yone engwo bani yal ta breng hol mongure yal ta kebering hol momia hangwi. ");
INSERT INTO sll_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hangure yasuri Maria yu ditongwi, “Alhuno, ni tal ongwo hai mene?” Dungure Maria yu ditongwi, “Yal ta na pi tege eminga yal irai yone i banta ongure na hankire wa du moliwa.” ");
INSERT INTO sll_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dire si kulu si yaulo ole Yisas mongwo hamba, gumang han po sikungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Sikungure Yisas Maria yu ditongwi, “Alhuno ni talongwo hai mene? Ara wa dune?” Dungure Maria yu di pungwi, Ayo, u sina ya hong yal mongwo pamia di hanere yu ditongwi, “Yahuno, gongwo yal irai i banta olanga nan di na tengere ire nale.” ");
INSERT INTO sll_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dimba Yisas Maria haang dale gala dungwi. Dimia Maria ganulun dire, “Tisao” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dimba Yisas yu ditongwi, “Na Nabe mongwo hamen bani olo hoiya, ni na olo na kulekio. Ulubi mole bli si malgi pire na ena abina hobo yu ditenania. Na ere nalgiwe, ni nan Nabe, ni nan God mongwo nalga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dungure Magdala hong al Maria ha i pirere ere Yisas grang wine ongwo hobi mongwo bani pire ha dungwo meri boling kul tere, “Yisas pi tege eminga yal mongwo hanere wiwa” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ena Yisas grang wine ongwo hobi Yuda ari kulung pire hoiri yole ala i mongwi. Momia Sarebir haung girungwo Yisas u gamahobo mongwo sina i molere, “Gir hobo moldinio. Mining bolo molo”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tere aling bli nil sungwo beni i tibi ol tere te kula bongwo beni i tibi ol tomia hangwi. Hanere yong horega ongure wai pire gun ere mongwi. ");
INSERT INTO sll_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mongure Yisas hon yu ditongwi, “Ni yalhobi mining bolo molo. Na Nabe na bai nu sungure ya ime wiya. Uga meri na ere ni yalhobi ni bai nu sigere nanua.” ");
INSERT INTO sll_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yu ditere, grang miing pu di tere yu ditongwi, “God Kwiang Holi Spirit ni tegere yon wu binama. ");
INSERT INTO sll_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Binangure ari tal nigi dongwo ol wangure God pring pai tenangwo kri di ole tenanga meri God ere para kri di ole ni tenamua. Te kri di ole tekinanga meri God ere para kri di ole ni tekinangure ya iwa monanga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ena Yisas u tibi ungwo haung na gina para mole haminba, kwal gir kul engwo tal i yu kul engwo yal taniga haang Tomas hankungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hankungure gamahobo tau Tomas “Pi tege eminga yal Yisas ungwo haminua” ditomingi. Tominba, Tomas na gina yu di na tongwi, “Na yal i bli nil sungwo aling beni hankio, te bli nil sungwo aling beni are te kula sungwo beni are diralga pir teralga pamba, akia pir tekiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ena sare ta wai sungure na gamnahobo para weni Tomas ire dire para momingi. Molere hoiri mama yole ere momingi. Mominba, Yisas hon ure sina mongwo tali mole yu di na tongwi, “Ni yalhobi mining bolo molio.” ");
INSERT INTO sll_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dire Yisas Tomas yu ditongwi, “Ni ani miling taniga na ana beni baniya are hano. Hanere ani dalna kula bolga baniya a piro. A pingiwe, na pir na tekinanga paikimia, pir na to.” ");
INSERT INTO sll_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dungure Tomas mole, “Na nan pi tege ega yal monio, na nan God mona di pire pir ni teiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dungure Yisas yu ditongwi, “Ni omaga na na hania, pir na teno? Tenba, ari tau na na hankinangwo hobi iwe, pir na tere gun ere mole yong miling horega onangure miling panamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ena Yisas ganba baniya mongwo gin iwe, tal nimni mongwo miki weni ongwo omena haniba, buku bani mining bol ekia. ");
INSERT INTO sll_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yisas tal ongwo tau buku bol egere ni yalhobi hanere, Yisas God wang mongwo pamio, Yisas singaba Kraist mongwo pamio, di pire, haang a yuwo ole moli pire, yal i yulang ire, nomani hon ire, mol pananga panana dire, buku bole ni teiwa. ");
INSERT INTO sll_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ena emgi Taibirias nir digan bir bina i na gina hobi momingere Yisas unangwo hol hankiminba, omena bani u tibi engwi. ");
INSERT INTO sll_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Engwiwe na gina yu mominia. Saimon Pita ire, Tomas ire, Galili probins Kena oo malgi hong yal Nataniel ire, Sebedi wang na abinambi kina gama hobo su ire dire momingi. ");
INSERT INTO sll_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Momingere Saimon Pita, “Pisi sina nalua” dungwi. Dungure “Na yalhobi kina para naminua” dimingi. Dire pire iri si sipi ala omingi. Ominga girungwo iwe, na yalhobi pisi ta weni sikimna. ");
INSERT INTO sll_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sikire wa i omingere hamen ari sungwi. Sungure Yisas u nir bina aire momba, na gina hobi Yisas guma han po sikimna. ");
INSERT INTO sll_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sikiminba, Yisas, yu di na tongwi, “Wana hobo wa i unga pisi ta sino?” ");
INSERT INTO sll_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dimba, “Ta sikiminua” dimingi. “Ni pisi gal ani weni holi pia si nir digan ala olanga tau sinanua,” dungwi. Dungure, na yalhobi dungwo meri yu olere pisi miki weni simingi. Sire gal aki dinaminba, gal oun weni dongwi. ");
INSERT INTO sll_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ena na Pita, “Pi tege eminga yal Yisas momua” ditegi. Ditegere Pita homa galsina gul olere honagi nega dire ongwiwe, galsina hon i ware u nir ala ongwi. ");
INSERT INTO sll_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ongure na yalhobi nir bina ulubi molkiminia, sipi ala mole nir bare, gal aule ire nir bina omingi. ");
INSERT INTO sll_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pire iri si mena pire haminba, endo gal emia dongwo hamingi. Hamingere, pisi homena breti para endo bani Yisas gale a te mongwo hamingi. ");
INSERT INTO sll_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hamingere Yisas, “pisi singa hobi tau ire wo” di na tongwi. ");
INSERT INTO sll_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tongure Saimon Pita hon iri si sipi ala pire gal i aule ire mena ungwi. Umia haminba pisi bir bir wan handred pipti tri miki weni sungwi. Simba, gal soulu dikungwi. ");
INSERT INTO sll_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ena Yisas na gina hobi “homena nenana wo”, dungwi. Dungure na gina hobi “ni ara mone?” dire sirin bol pinaminba, Yisas momia haya hamingi. ");
INSERT INTO sll_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hamingere Yisas ure breti du dire pisi ire bolo na gina hobi na tongwi. ");
INSERT INTO sll_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ena Yisas gongwo bani haya aire homa gin su u tibi ongwo hamingere emgi hon u tibi pire tal yu ol na tomia hamingi. ");
INSERT INTO sll_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ena na gina hobi homena nomingere, Yisas Saimon Pita yu ditongwi, “Saimon Yon wang ye, ari hobi na wa dire yong miling na tomba, ni na yon milni na tenga mo hora kumo?” dungwi. Pita “Owa, Yal Yisas ye, ni na yu olga hanere dinua” dungwi. Dungure Yisas yu ditongwi, “Ni para dinia, ha maing ire omaga pir na tongwo hobi nir si to.” ");
INSERT INTO sll_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dire Pita hon sirin bol tongwi, “Yon wang Saimon ye, yon milni na ten mo?” Dungure Pita “Owa, Yisas ye, ni na yu olga hanere dinua” dungwi. Dungure Yisas “Grana wine ole pir na tongwo hobi kene ol molo” dire, Pita hon sirin bol tongwi, “Yon wang Saimon ye, yon milni na ten mo?” ");
INSERT INTO sll_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dire gin sui tai dire sirin bol tomia Pita miling gul sungure, eke dire, yu dungwi, “Yahuno, ni talhan hobi para pir po sinia, na yona milna ni tega meri irai han dinua.” Dungure Yisas yu ditongwi, “Na grana wine ole pir na tongwo hobi ha maing ditere kene ol molo. ");
INSERT INTO sll_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Homa ni yagaling monga meri irai ni nin galni bala i kinere hol banta banta nala di pinga holi waniraya, emgi yal dimani monanga gin iwe, ani suala gangere yal ta ni han hole hol hon malgi dinangwo i si gulu dinangure nanga pamua.” ");
INSERT INTO sll_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ena Yisas Pita emgi ari si gonangwo i pire awa ha tani ditongwi. Gonangwo maing iwe, emgi God haang ayuwo olamia di pire ditongwi. Emgi Yisas Pita “ni ure na dolna bolo,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ena Pita si kulu sire, homa homena ne mominga haung na Yisas kina si daule mole, “ara ni bai tal siname?” dire mominia na hanere Yisas yu sirin bol pungwi, ");
INSERT INTO sll_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","“Yal Yisas ye, ni kina monga yali tal ol tename?” ");
INSERT INTO sll_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dungure Yisas yu ditongwi, “Yali na uralga haung ya monama di piralga i tamamia. Na nan hana pamia. Ni ure na na dolna bonanga tani nomani si piro.” ");
INSERT INTO sll_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dungure na golkiralga pamua dire Yisas gamahobi yu di wamba, “golkinanua” di na tekima. “Ni golkinana di piralga i tamamua” di na tomia. ");
INSERT INTO sll_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ha dungwiwe, na nan maing pire di tibi olimia. Olungure na mining bol ega i ha pangwo kara dire bol eya, pinanga pamua. ");
INSERT INTO sll_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ena Yisas tal miki weni omia. Ongwo hobi iwe, buku miki weni bonaminga buku miki weni dinangwo pamba, bolkiminia. Si gubu dire obilga bol eminue. ");
INSERT INTO sll_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ena Tiopilas, Homa na pepa ta mining bole ni tega meri irai, omaga ta hon bole ni teralia. Pepa homa mining bol ni tegiwe, Yisas honagi kebering hole ari ha maing nir si tomia. ");
INSERT INTO sll_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Te i pire emgi ere hamen bani ongwo i, para weni i mu dire, mining bole ni teiwa. Ena Yisas yu ol pisolungure, God Kwiang yong wu bimia, ere hamen bani nala dire aposel hobi honagi onama dire nu ke tongwo hobi ha di nima pire honagi ha ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ena Yisas homa gaung gul honagi oli pire gomia. Golere ere honagi onama dire nu si olungwo ari aposel hobi mongwo bani u tibi emia hangwi. Hangure hamen haung yasu kebering aling poti molere, u hon oga arihobi na hanama dire tal nimni mongwo mone ol tongwo hangwi. Hanere, “O, Yisas hon airungwo pamia hano,” dungwi. Ena Yisas tal nimni mongwo olere, God kene ongwo hol i doling bonama dire krehaman di tongwi. ");
INSERT INTO sll_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tere aposel hobi u ku bongure, ha di nima pire yu ditongwi, “Hamen Abe tal ta ni terala dimua di ni tegarai, ni tenangwo inanga pamia, Yerusalem aidolekire kwi molio. ");
INSERT INTO sll_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yal Yon ari nir bil ni tongwiwe, nir wo bil ni tomba, habang gobari ta molkinangere, God nin Kwiang ure ni yon wu binangure inanua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dungwo gin iwe, aposel gamahobi mole Yisas yu sirin bol pungwi, “Yal Yisas ye, omaga ari wiyol ta Isrel ari kene ol mongwo hobi nu si memini olano?” ");
INSERT INTO sll_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dimba Yisas yu ditongwi, “Onangwo gin iwe, ni yalhobi hani paikimia memini ta pir po sikinanua. Abe nin haang pamia. Tani kene ol momia grang wine ole yu onangwo pamua. ");
INSERT INTO sll_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pamiba, emgi God nin Kwiang ni yalhobi monga sina i ure yon wu binangure, yulang ire nimni monanua. Molere Yerusalem malgi na hana di tibi ole, Yudia te Sameria ganba bina holo holi para weni di te i nanga pamua.” ");
INSERT INTO sll_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ena Yisas ha i di te pisolungure, kwahawa ure Yisas yobilungure, gamahobi han momba, ere pi hamen ala yuwo terewa sungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Simia aposel hobi ya han gala di mongure, mongwo bani yal sutani gal pege sigiu dire ure yalhobi kina ereho si daule mongwi. ");
INSERT INTO sll_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mole yu dungwi, “Galili yalhobo, ni yalhobi tal ongure hamen bani yuwo tene han mone? Yisas iwe, omaga God nin aule ire hamen bani omia. Emgi siina dire ya ime unangwo gin iwe, omaga mo ongwo hanga meri ereyu ya ime unangwo hananga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ena ha dungwo i pire, aposel hobi hamen hul Olibi aidole ere Yerusalem malgi ongwi. Olibi hamen hul iwe, ulubi ta dikima, Yerusalem mala weni dungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ena Aposel hobi ere malgi pire oo ta ke engwo werang ta mini bani pire mongwi. Ena ongwo yalhobi iwe, haang yu pamia, Pita ire, Yon ire, Yems ire, Endru ire, Philip ire, Tomas ire, Batolomyu ire, Matyu ire, Alpias wang Yems diing ire, Saimon hamil ha sungwo yal ire, Yems wang Yudas ire dire, pi mongwi. ");
INSERT INTO sll_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ena haang daminga hobi iwe, yong tani ere God ha di terala dire pi mongwi. Mongure al hobo Yisas aang Maria ire, al tau ire, Yisas ebering hobo ire dire, pi mole, God ha wai ol te mongwi. ");
INSERT INTO sll_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ena habang gin ta Yisas nomani si pir tongwo ari miki weni wan handred twenti mongure, Pita aire yu dungwi, ");
INSERT INTO sll_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Girhobo, God nin Kwiang yal Debit yong wu bungure, Yudas haang pire, awa ha ul buku Sam mining yu bol emiraya. ");
INSERT INTO sll_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","20","Yal i oo i han olingere po dire dinangure, ari ta ala i pai molkinama. Te ul buku Sam ha mining ta yu pamia. “Yal i honagi ongwo bani iwe, yal ta hon maulung sire ol monamue.” Ena ha iwe, nima namua dimiraya, omaga para nima omia. “Homa Yisas han holala dire ungwo hobi, Yudas homa engure Yisas mongwo bani omua. Yudas iwe, God nu ke tomia. Tongure na gina kina tani mole waminua. Ena Yudas tal nigi dongwo olere, moni tobo ire ganba bring simia. Ganba bring sungwo bani hogal sire, miing bol pu dire, yong gebe di mena ungure gomia. Gongure, ari Yerusalem mongwo hobi tal ongwo ha i pimia. Ena yalhobi u sina i haang Akeldama emua. (Haang i nan ha Algi Ganba wa dinaminua.) ");
INSERT INTO sll_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ena yu ongwiwe, yal ta Yudas aibing maulung sinangure, honagi ereho onaminia. Olere singaba Yisas gomba, hon airimua di tenaminua. ");
INSERT INTO sll_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Homa Yon nir bil tongwo haung moli uminga, Yisas hon aine kebering hongwo haung ere moli uminga, gole hon aire ere hamen bani ongwo haung moli uminga hobiwe, yal taniga i tibi olaminga Yudas aibing maulung sinamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dungure ya sutani Yosep Basabas haang ta Yastas ire, Mataias ire dire, i tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Olere God ha yu ditongwi, “O God, ni ari yong miling sina i para hania. ");
INSERT INTO sll_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Na yalhobi yal sutani nu ke tominba, ni Yudas aposel aibing maulung sinama di pinanga yali, i tibi ol na to.” ");
INSERT INTO sll_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dire hulu sutani Yosep Mataias kina haang bol ere gal girungwi. Gire taniga i tibi olimba, Mataias haang i tibi olungwi. Olungure Mataias ari aposel ana holo holo kebena taniga kina honagi ereho ol wangwi. ");
INSERT INTO sll_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ena erin habang ta haang Pentikos u tibi ongure, Yisas doling bongwo hobi banta u ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mongure hamen bani gintani guru dire, hamen hair mu dinba ongwo meri ongwi. Olere ya ime ure, gamahobi ami di mongwo oo ala i si di di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Momia yalhobi hangure, endo dere gini bli bali dungwo meri dungwi. Dire pi gamahobi mongwo breng bane bani dongwo hangwi. ");
INSERT INTO sll_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ena God nin Kwiang ure ari hobi yong wu bungure, ha mane bona di nin nin olungure wiyol howa yungwi. ");
INSERT INTO sll_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ena Yuda ari tau God ha dungwo grang wine olere a i si wangwo hobi, ganba holo holo ke pare ha howa nin nin yungwo i pisolere, hon u Yerusalem malgi ke pare mongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Molere guru dungwo i pire u ku bongwi. Bole hamba, aposel hobi ha howa nin nin yungure, arihobi, “yalhobi Isrel ke pamba, na ha dimua, na ha dimua,” dire yo yangwi. ");
INSERT INTO sll_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yo yare ganulun dire yu dungwi, “Yalhobi Galili hong yal momba, ha howa nin nin yumia hano. ");
INSERT INTO sll_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Talongure yalhobi nan hana i dungure pimne? ");
INSERT INTO sll_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nan yalhobi ganba miling ta ke pare uminia. Pitia ya, Midia ya, Ilam ya, Mesopotemia ya, Yudia ya, Kapadosia, Pontas, ");
INSERT INTO sll_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Esia Prisia ya, Pampilia, Isip ya, Sairini ari Libia ke paminga te, Rom ya, tan tani sini sini yare mominia. ");
INSERT INTO sll_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nan Yuda ari tau momingere, tau wiyol banta sini yare ungere mominba, Yuda ha maing pir tere momingere, tau Krit, Arabia nan para mominba, God tal nimni mongwo ol tongwo iwe, nan hana i dungure piminua.” ");
INSERT INTO sll_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dire ganulun dire nomani su su sire, yalhobi nin di wama tere yu dungwi, “Ayo, yalhobi nan hana i gintani pimia, talmere ole pime?” ");
INSERT INTO sll_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dimba, yal tau gumang iger bole wa gol tere, “Ayo, yalhobi nir bia nere, spa ole, du ha dimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ena yu dungure, Pita aposel gamahobo kebena sutani hobi kina aire, gala erakere dire, ari mongwo hobi yu ditongwi, “Ni Yuda ari ya, te Yerusalem ke pai monga hobi ha ta di ni terala ogolo piro. ");
INSERT INTO sll_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na yalhobi nir bia nere spak ole du ha dimua di na tenba, nir nenaminga honmil nain klok mominga irai, omena malekimua. ");
INSERT INTO sll_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tal ominga hangiwe, homa God hana togu yal Yoel awa ha di engwo irai, omaga kara nima ongwo hanua. Ha iwe, God yu dimia, ");
INSERT INTO sll_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Haung ta emgi na Kwiana nu sigere, nir kuung sungwo meri ari hobi para muru mongwo bani ure, galni yal al malangwo hobi tan tani yulang tere, yong wu biralgere ha ditenamua. Te yagaling hobi omeling bani u tibi nangwo hanangure, te yal dimani hobi ul pare kuu ening bol tenangwo hanamua. ");
INSERT INTO sll_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hanangwo gin iwe, na Kwiana nu sigere, nir kuung sungwo meri unangure, honagi yal al hobi inamua. Ire molere ha maing ditenamua. ");
INSERT INTO sll_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na urere, hamen bani tal nima nangwo olere, te ganba bani tal guma hon dongwo maing ta bole i tibi olalgere, hane bukunamua. Algi ya, endo ya, engi bir ya, i tibi olalua. ");
INSERT INTO sll_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Olalgere hamen bani ari si bonamio, haba algi mo enamia. Yu onangwo hananga gin i, emgi hamen ganba hobang unangwo habang kul enamua. ");
INSERT INTO sll_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Enangwo gin iwe, yal tau hobang yali haang dal yu ere moli ongere, God si hon e ni tenangure sigare kule u wai nanua,’ dire God hana togu yal Yoel ha yu dimia. ");
INSERT INTO sll_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ena ni Isrel ari hobi ha dinaminga ogolo pirio. Nasaret hong yal Yisas iwe, mongwo maing yu pamia. God yal i yulang tongure ire urere, tal nima ongwo maing maing olere, tal guma hon dongwo maing maing monga sina i ol ni tongure, ni nan para haminua. ");
INSERT INTO sll_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ena God tal emgi homa panangwo i para nomani si pir i kunung olere, Yisas er pera bani gonangwo dima dire, ni tongure si gonia. Si golkiwa dinba, wiyol tau Yisas si golala di onangwo hanere, mana ditekinia, dungwo ha i para bol yare si gonua. ");
INSERT INTO sll_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kara si gonba, God hon uling yungure airimia. Gongwo engwo bani ta pai molkimia, God nin uling yungure hon ere omua. Man wu engwo bani halabusi pangwo meri pamiba, nin yulang bole airimua. ");
INSERT INTO sll_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Airungwiwe, kwiana moya yal Debit awa ha di engwo meri irai omaga nima omia. Debit ha iwe, yu dimia. ‘Na haniga hamen ganba hong yal gumana bani werigi werigi dimua. Yal i na kuman kine na tongure na kul pirkiwa. Yu ol na tongure, yona milna horega ongure, gun engwo tani ha di yau siwa. ");
INSERT INTO sll_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na ganba ari moliba, golere kwiana gauna kina hon airalga ipire, gun ere mining bolo moliwa. Ni na kwiana kwia molkinama di onia. ");
INSERT INTO sll_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Olere, te gran wine ongwo yal gaung golere, yulagi engwo bani bli yakinama dire onua. ");
INSERT INTO sll_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ena gobari mol paralga bani paralga hol bala di na tenua. Tere ni na kina si daule moli nabilga yona milna horega onangwo dimua,’ dire Debit ha i di wai simua. ");
INSERT INTO sll_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ena yalhobo, na kwiana moya Debit ha dungwo i memini di tibi ol ni teralia piro. Kwiana moya Debit gongwo man wu engwo maul ya di pamia. ");
INSERT INTO sll_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Debit God hana togu yal momia, God ha di yulang bongwo i Debit pimua. Di yulang bongwo ha iwe, yu dimia. Galni ta ni aibin maulung sire ni singaba king monga meri monamua. ");
INSERT INTO sll_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Monangure Debit God grang ha pirere, singaba Kraist golere hon airamua di pimia. ‘Yal i kwiang kwia molkinama di olere, te gaung gonangwo ere bli yakinama di oma, dimua.’ Dimba nin omeling hankimua. ");
INSERT INTO sll_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ena Yisas gongwiwe, God uling yungure airungwo nan para haminua. ");
INSERT INTO sll_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God yal i haang a yuwo olere, kina ereho si daule monama dire, i aling weni hol i olungure talhan para weni kene ol te momua. Mongure God homa aling kere ere, na nan Kwiana ni tegere inanua dimiraya, omaga tongure imua. Ingwo meri nan yalhobi God nin Kwiang nir kuung sungwo meri na tongure ire mole, tal maing maing ominga hanua. ");
INSERT INTO sll_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Singaba Debit hamen bani olo homba, ha homa yu dimia. Hamen ganba hong yal ure na pi tege ega yal yu ditomua, Ni ure ana weni hol i monania. ");
INSERT INTO sll_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Monangere kiani hobi unangwo u keben ali benamua.” ");
INSERT INTO sll_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dire Pita hon aine yu dungwi, “Nan Isrel arihobi talhan u tibi ongwo i ogolo pimino. Yisas er pera bani si enga yal iwe, God molere talhan para weni yulang hong yal molere, te Kraist mole dinama dire ol na tomua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ena ari hobi ha i pire bukunere, Pita aposel hobi kina yu ditongwi, “Girhobo, tal onamne?” ");
INSERT INTO sll_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dungure Pita yu ditongwi, “Ni yalhobi tal nigi dongwo ol wanga aidole nomani si kulu sire hon olkirala di pire wayo. Wananga tal nigi dongwo ol wanga prin pangwo i, God kri di olama dire Yisas Kraist haang dal yuwo ere nir bil ni tenaminua. Tenamingere, prin i ole ni tenamua. Tere nin Kwiang ni tenangure inanua. ");
INSERT INTO sll_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ena God aling kere ere han dungwiwe, ni tere, te wana auna hobi tere, te ari ganba milin ta mongwo hobi tere, te God ari pare ere nu ke engwo hobi tenangwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ena Pita Yisas talongwo hangwo i boling kul te mole ha di nima pire yu ditongwi, “Yalhobo, omaga malere tal nigi dongwo ol wangwo i pring bir pamia, ni yalhobi ongwo tali olkire i mobin hal wa tere u kwaling ta po.” ");
INSERT INTO sll_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dungure ari miki weni Pita ha dungwo ogolo a i si ware mongure nir bil tongwi. Tongure God ari tri tausen miki weni hon hon malere, Yisas pir tongwo hobi u bir weni ongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ena pire molere, aposel hobi ha maing nir si tongwo pire, te pana gale, homena tani nere, God ha di tere tere mongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ena God tal guma hon dongwo miki weni aposel hobi aling bani emia, ongure ari para weni kul de hangwi. ");
INSERT INTO sll_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hangure Yisas grang wine ongwo hobi bolo pana gale bona gana nin a ne i omba, i mu dire gol male a nongwo dungwi. ");
INSERT INTO sll_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dungure bona gana ganba ya nongwo hobi moni bol ire, ebir sire, talhan a nekungwo hobi aki di tongure kunung kunung mongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ari haung haung Yisas grang wine ongwo hobi ere Yuda ha maing oo mone ongwi. Pirere oo dungwo dungwo meri homena gol male nere yong tani ere gun ere mongwi. Molere God maa e tongure, ari hobi para hanere wai pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tongwo gin iwe, ari haung haung singaba God ari tau nu ke tere hon pare emia sigare kule u wai ongure u miki ongwi. ");
INSERT INTO sll_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ena girungwo ta Pita Yon kina God ha diterala dire, Yuda ha maing oo bir ala ongwi. Ongwo honagrang i haang Honagrang Wai engwi. ");
INSERT INTO sll_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Engwo bani iwe, yal ta aang yong miling sina kebering aling kebir engure, mena ure hol wakire honagrang ami di mongwi. Mongwo yal iwe, haung haung ari au si u olungwo molere, ari ha maing oo ala nala dire ungwo hobi “moni na to” dire, hong di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mongure Pita Yon kina ala nala di ungure hanere, “moni na to” dire, hong dungwo tali dungwi. ");
INSERT INTO sll_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dimba, Pita Yon kina kebir engwo yal i teni yuling bole han tongwi. Tere Pita yu ditongwi, “Ni na yasuri na hano.” ");
INSERT INTO sll_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dungure tal ta na terala di dima di pire hangwi. ");
INSERT INTO sll_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hangure Pita yu ditongwi, “Na yasuri moni ta dikimia. Tal ta a nobilga i ni terabilua. Yisas Kraist Nasaret hong yal iwe, yulang ire uminga ni tenaminia. Ni aire hol wayo.” ");
INSERT INTO sll_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ditere aling aki dungure, gintani kebering nimni mongure, iri sire hol wangwi. ");
INSERT INTO sll_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ware Yon Pita kina ereho ala pire, ha maing oo ala i iri si ware, God haang ayuwo olere, maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tomia ari hobi hanere ganulun dire, ");
INSERT INTO sll_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“Ayo, yal i homa Honagrang Wai ami di molere, ari maini ala tongwo i moni na to dire hong di momiraya, omaga u wai omue,” dire, miling si giri golere bukunungwi. ");
INSERT INTO sll_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ena awai ol tongwo yal i Yon Pita kina a i si mongure, ari hobi bukunere bli si pi Solomon honagrang oo ke maini olungwo bani tabin si mongwi. ");
INSERT INTO sll_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Momia Pita hanere, ari yal al hobi yu ditongwi, “Ni Isrel arihobi yawe, talongwo ganulun dire bukunere na yasu tene han na tene? Yal i nimni mole hol wangwo i na yasu nin yulana ire awai ol toma di hano? Yu di hankio. ");
INSERT INTO sll_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraham ya, Aisak ya, Yekop ya, kwiana moya para maa e tongwo yal God tani momia, honagi ari Yisas haang ayuwo olimua. Olimba, olungwo yal iwe, ni yalhobi aule i pire ha hol bani enua. Engere Pailat gule olangwo pamba, ni yalhobi yali sigonama dire nona panua. ");
INSERT INTO sll_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mama weni dime dire mongwo yal i mobin hal wa tenia. Tere Pailat pirere Yisas si golo dire, yal ta ari si gongwo yal i gule ole na to dinia. ");
INSERT INTO sll_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dire mol pai hong bling memini yali hol wai i tibi ol na tomba, si gonia. Si gonba, God nin uling yungure, yulagi engwo bani aidole airimua. ");
INSERT INTO sll_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Airungwiwe, na yasu habilga yasu mobilua. Ena na yasu Yisas haang a i wabilua. Wabilgere Yisas yulang na tongure, awai ol tobilga hanua. Yisas nin yal i aki di tongure, ni yalhobi monga omin bani u wai ongwo hanua. ");
INSERT INTO sll_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ena yalhobo, ni singaba hobi kina Yisas tal ki ol tenia. Tere pir kun olkinga mere ni yalhobi ere yu nin onga haminia. ");
INSERT INTO sll_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hamen haya God awa ha hana togu yal grang pirere, Kraist gaung gul ire gonamua dimiraya. Dungwo meri irai omaga yu ol tengere nima omua. ");
INSERT INTO sll_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Omia ni yalhobi tal nigi dongwo onga prin pangwo i, God kri di ole ni tenama dire, tal nigi dongwo ol wanga pisole, nomani si kulu sire, God bolo pana galio. Gananga God ni arihobi si hon e ni tenangure sigare kunanua. ");
INSERT INTO sll_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kunangere, God nu ke tongwo yal Yisas Kraist hon nu si ni yalhobi monga bani olamua. ");
INSERT INTO sll_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Olamba, omaga hamen bani monangure, God talhan para weni hon ol eralga gin i, singaba Kraist hon manbi unamia dire, awa dungwo i hana togu yal pirere, di tibi ol na tomiraya. ");
INSERT INTO sll_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tongwo meri iwe, yal Moses yu dimia, God na na bai nu sungure, hana togu yal molga meri ni yalhobi monga sina i ebin hobo ta yu monamia. Molere ha dinangwo grang bani ogolo wine ole pir to. ");
INSERT INTO sll_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tere wine olkinanga hobi ha maing pungwo hobi kina ereho monanba, God ni ai di mena olere ni sinamua. ");
INSERT INTO sll_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ena God hana togu yal Samyuel homa weni momia. Mongure emgi emgi tau ainere moli ongwo hobi iwe, para weni grang u tani pirere, omaga tal ongwo meri awa ha ere yu dimiraya, weni kara nima omua. ");
INSERT INTO sll_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Omaga malinga hobi iwe, God hana togu hobi gang monia. Homa God kwiana moya hobi ha wai ole gua sungwo meri irai omaga ni yalhobi ereyu gua sinanua. Homa God kwian moya Ebraham yu ditomiraya, Ni galni hon male siru dinamua. Dinangwo hobi God yulang tenangure, ari bina holo holo mol i ongwo hobi awai ol tenangure, sigare kule u wai namua. ");
INSERT INTO sll_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yu dungure God honagi yal Yisas nu ke tere bai nu sungure, ure tal nigi dongwo ol wanga i, pisole, sigare kule ure God hol di ni tongwo i doling bonana di olere, awai ol ni tomua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ena Pita Yon yasuri ha i di te mongure, ha maing oo singaba ire, ha maing oo bir er kwi nu mole kene ongwo yal ta ire, Sadyusi ire dire, u pa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dungure yasuri, Yisas golere hon airungwo mere ari tau yu onamua dire boling kul te momia, arihobi u hanere nigi de pungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pirere yasuri han sire, tanangwo ha hol ol terala dire, hamen girimia, halabusi oo ala i olungure, pai mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pai momba, Pita Yon yasuri ha nir si tongwo i, ari miki weni wine olere, Yisas pir tongwi. Pir tongwo hobi iwe, yagir namba imu dire paib tausen mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ena hamen tangure, ha maing oo singaba ire, ha maing yal bir ire, Lo ha nir si tongwo tisa ire dire, Yerusalem malgi i ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mongure Yuda ha maing oo kene ongwo yal bir Anas ire, Kaiapas ire, Yon ire, Aleksanda ire, singaba tau ire dire, para u ku bole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Molere aposel suri aule ire, sina ure, yu sirin bol pungwi, “Ni talmere ole yulang bole honagi one? Ara yulang ni tongure, haang dal yuwo erere, tal i one?” ");
INSERT INTO sll_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ditongwo gin iwe, God nin Kwiang ure Pita yong wu bilere, a kulang pai tongure, nimni mole yalhobi yu ditongwi, “Yuda ari yal bir ye, ");
INSERT INTO sll_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yalhobo, yal ta kebering kebir engwo na yasuri aki di tobilga u wai ongwo i hanere dino? ");
INSERT INTO sll_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Dinanga ni Isrel ari hobi kina para piro. Nasaret hong yal Yisas Kraist ni yalhobi er pera bani si gonga gongure, God nin uling yungure airimia. Airungwo yal iwe, yulang na tongure, haang dal yuwo ere awai ol tobilga kebir engwo yali u wai ongwo hania. ");
INSERT INTO sll_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yisas haang pungwo mere ha maing buku yu di emiraya, Oo kengwo yalhobi torari ta ire mebin dama dire aidolamba, olangwo torari i God nin ire bring torari sinangure nima pire dinamua. ");
INSERT INTO sll_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dinangwo meri iwe, Yisas ere yu nima pire momua. Molere yal i nin muru arihobi aki di tongure, sigare kule u wai ongure, te emgi tau u wai namua. Yal ta monangure, God yulang tenangwo awai onangure sigare kulkinamia. Yal i tani momua.” ");
INSERT INTO sll_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ena arihobi Yon Pita kina grang bani han momba, ha nimni mole dimia, ari hobi hanere, “ayo, yasuri sikul ta dikimiraya, ha i tal ole dime?” di hanere nomani si gogo dangwi. Damba, homa iwo yasuri Yisas kina wangwo hamingirawe di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pirere kura ha di tenamba, kebir engwo awai ol tongwo yal i ure Yon Pita kina si daule aire mongwo hangwi. Hanere yalhobi ha ta ditenamba, grang oun dongure han ole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Molere ere pi maini monana po ditere, yalhobi nin ha diriyala olungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Olere, yu dungwi, “Nan gina yasuri tal ol tenamne? Tal guma hon dongwo ongwo i Yerusalem ari hobi para han po sire momia, nan aulu bai haunaminga paikimua. ");
INSERT INTO sll_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Paikimba, guung haang i ari ganba bina holo holi pirikinama dire, Yisas haang dale honagi olkio dire mana ditenaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dire, “hon ala wo” ditongure ungure, “Yisas haang dal yuwo ere ha i ari hon nir si tekio,” dire mana giring ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ditomba, Pita Yon kina ha mong yu ditongwi, “Na yasuri God grang wine obilga i pisolere, ni gran wine olabilga wai panam mo? Nomani si pir kun olio. ");
INSERT INTO sll_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na yasu Yisas tal ongwo hanere, grang pirere dibilga i, pir uning si ole ta molkirabilua.” ");
INSERT INTO sll_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dungure u ku bongwo hobi yasuri kul pinama dire, han tere erepo ditongwi. Ditongure yasuri tal ongwo i ari hobi hanere, God haang dale maa e tomia, ari u ku bongwo hobi yasuri sinangwo paikungure, han olimia, ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ena kebir engwo awai ol tongwo yal iwe, yagaling ta molkimia, ari yal me erin yal su kebering aling poti mongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ena Pita Yon kina ere gamahobo tau mongwo pirere, singaba hobi ha ditongwo meri boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tomia pirere, yalhobi kina yong tani ere mole, God ha yu ditongwi, “Yulang hong yal ye, ni hamen ganba ya, nir sol wara ya, talhan ganba bani pangwo hobi ni ol enua. ");
INSERT INTO sll_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Homa ni Kwian ure kwiana moya ni honagi ol ni tongwo yal Debit yong wu bimia. Bungure Debit grang bani yu dinia, ‘Ari wiyol tau talongure yong ki eme? Te ari tau talongure nomani miki miki si pime? ");
INSERT INTO sll_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Te ganba ganba singaba king para weni u ku bolere, God singaba Kraist kina a ime ol terala dire, yulung bomua.’ ");
INSERT INTO sll_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dire Debit ha yu dungwiwe, omaga nima omua. Singaba king Herot ire, Pontias Pailat ire, ari wiyol tau ire, Isrel ari ire dire, ni wani Yisas Kraist tal dime dire ongwo yal i a ime olala dire yulang bomua. ");
INSERT INTO sll_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bolere nin pungwo mere pire tal yu ol wamiba, ongwiwe, ni homa yulan bole nomani pire tal yu olala dire onga meri omua. ");
INSERT INTO sll_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nabe, yalhobi tal gogo ol na terala dire ongwo hania, ni aki di na tengere, nimni mole, ni ol wai ol tenga ha maing di tibi ol tenamna. ");
INSERT INTO sll_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tenamingere ari nibil ongwo i ni nin yulan to. Tere ni wani Yisas han dal yuwo ere tal nimni mongwo miki weni onama di pinga meri aki di na to.” ");
INSERT INTO sll_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Di te pisolungure, oo i ememe ongwo tani hol wangure, God nin Kwiang ure ari hobi yong wu bungure, sipapa sire, nimni molere, ari moma ama di pirikire ha maing di tongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ena Yisas grang wine ongwo hobi yong miling tani ere mongwi. Molere, “I na talna dimua,” dikire, gol male a nongwo dimia hangwo hangwo i holo holo ongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ongure aposel hobi yulang ki bolere, Yisas golere hon airungwo ha i boling kul tongwi. Tomia God hanere, pirari pare aki di tongure u tani pire pana gangwi. ");
INSERT INTO sll_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gamia yalhobi mongwo sina i yal ta gal kul nir homena ta wa dukima. Yalhobi ganba ya, oo ke pangwo hobi yal tau tere moni bol ingwi. ");
INSERT INTO sll_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ingwo moni iwe, ire, aposel hobi tongwi. Tongure aposel hobi ire talhan a nekungwo hobi aki di tere tongwi. ");
INSERT INTO sll_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ena yu ongwiwe, yol Yuda Libai yal ta Saipras malgi kul engwo yal, Yosep aposel hobo haang hon Banabas engwi. Engwo haang iwe, memini yu pamia di gon gan ongwo yal momia. ");
INSERT INTO sll_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Molere ganba ya nongwo ta yal ta tere moni bol ingwi. Bol ingwo moni iwe, i ure aposel hobi tongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ena yu tomba, yal ta hang Ananaias eumbi Sapaira kina ganba ta ereyu yal ta tere moni bol ingwi. ");
INSERT INTO sll_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ingwo moni iwe, yasuri moni tau aposel hobi tomba, tau nin i kul si engwi. ");
INSERT INTO sll_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yu ongwo i Pita hanere, Ananaias yu ditongwi, “Ananaiasiye, ni moni hol bane i kul si engiwe, enga paikimia, God nin Kwiang bal tengiwe. Seten ni kraun sungure bol yania. ");
INSERT INTO sll_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ena homa ya dungwo haung, ni ganba dimia. Ganba yal ta tere moni inga i ni moni dimia. Yu onga i talongwo nomani si pire one? Yu ongi ari bal tekinia. God nin maulung bani bal tenua.” ");
INSERT INTO sll_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dungure Ananaias pirere gintani u di ya manbi sire gongwi. Gongure ari tau para mole ha dungwo pire, mongwo hobi hanere, miling si giri gongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gongure yagaling hobi ure gal yobile tere, i pi man wu engwi. ");
INSERT INTO sll_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Engure haung obilga mol goi si pire eumbi ere ala ongwi. Ongwiwe, wiimbi tal ol tongwo i hankima. ");
INSERT INTO sll_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita al i yu ditongwi, “Ni yal al suri ganba moni bol inga i muru na ten mo?” Eumbi “Owa, muru ni tominua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dungure Pita al i yu ditongwi, “Ni yal al suri moni nere ure talongwo God Kwiang kera kul tene? Han yuwo olo. Ni winimbi irai man wu engwo yalhobo ure hona mongwo yuwo hanega. Momia ni para ni pi man wu enamua.” ");
INSERT INTO sll_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dungure al i gintani golia Pita kebering bani dungwi. Dungure yagaling hobo ungwo tali ure, ipire wimbi man wu engwo bani engwi. ");
INSERT INTO sll_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Emia tal ongwo ha iwe, boling kungure, ha maing pire mongwo hobi ire, ari hobi para ire dire, pire miling si giri gongure, kul bir pungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ena aposel hobi tal guma hon nimni mongwo miki weni omia, arihobi hane bukunungwi. Bukunungure, Yisas grang wine ole pir tongwo hobi pi Solomon honagrang oo ke maini olungwo bani mongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mongure, ari hana ya mongwo hobi bolo pana gal molkinamba, hang a yuwo olere, wai pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yu omba, ari yal al miki weni Yisas hamen singaba momia di pire, u Yisas grang wine ongwo hobi kina hole molere, u bir ongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ena aposel yalhobi tal ongwo i hanere, ari nibil pangwo hobi er ba hau ire, homaulung bangi engwi. Erere yal Pita wiyala nangwo guung mulangwo nibil wai sinamua di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ena Yerusalem oo malgi ari bina holo holi pai ongwo i tau nibil pare te kwia nigi dongwo yong sina mongwo hobi para aule ire ungwi. Ungwo hobi para weni u wai ongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ena yu ongwo Yuda ha maing oo singaba Sadyusi kina pirere, yal i talongwo ome, dire nigi de pire kiang bangwi. Bare talta ol terala di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pire aposel hobi a i si molere, halabusi oo ala olungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Olimba, ginangwo hamen singaba ensel ta ure, hoiri yaule tere, aposel hobi aule i mena pire yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ni yalhobi ere Yuda ha maing bling mining oo ala pire, ha maing hol hon mol panangwo bani panangwo ha i di ba bole boling kul to.” ");
INSERT INTO sll_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dungure aposel ha dungwo meri wine olere, honmil sinamo Yuda ha maing oo ala pire ari yal al ha nir si tongwi. Ena Yuda ha maing kene ongwo yal hobi Yuda ari singaba hobi para Yuda ari kaunsil hobi gala di ku bongwi. Bole aposel hobi aule i unama dire gala di halabusi oo malgi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Olimba, polisman ta pirere hamba, aposel hobi molkungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Molkungure, polisman siina di memini pire singaba hobi yu ditongwi, “Na pi pa dire haminba, hoiri mama dimio, te nona pangwo hobi girungwo u egere holo holi hon momia, yalhobi ala molkimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dungure ha maing oo sugul irang bir ta ire, Yuda ha maing oo kene ongwo yal bir hobi ire dire, ha i pire nomani si gogo dalere yu di pungwi, “Ayo, molki dimia, hol makena u mena ome? Tal onamne?” ");
INSERT INTO sll_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dimba, yal ta u pa dire, “A, halabusi singa yal hobi irawe, ha maing oo ala molere, ari ha maing nir si te momua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dungure sugul irang yal bir ire, polisman ta ire dire, aule ire urala dire ongwi. Pirere aule ire unaminba, ari hobi hulu na sinamua dire, kul pire aposel hobi mining mining bolo aule ire ungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ena aule ire ure, u ku bongwo hobi mongwo bani u giu dungure, ha maing oo singaba yu sirin bol pungwi, ");
INSERT INTO sll_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yisas tal ongwo i boling kul tekio dire hobang si ni tominiraya. Ni yalhobi warakere di te i ongere, Yerusalem malgi suwa dungwiwe, Ena Yisas gongure, na pring inama dire yulang bole ha di mere si na tenua.” ");
INSERT INTO sll_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dimba Pita aposel hobi kina yu ditongwi, “God ha dungwo nima omia wine onaminga pamia. Ari ha ya ime sungwiwe, wine onaminga paikimua. ");
INSERT INTO sll_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ni yalhobi Yisas er pera bani singa gomia. Gongure God nin uling yungure, hon airimua. ");
INSERT INTO sll_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Airungure God nin aule ire, ere hamen bani pire, Isrel ari tal nigi dongwo ol wangwo pisole nomani si kulu sire, hon olkirala di pinangure God pring i ole tenama dire God nin i aleng weni holi engure, molere, nan hobana molere, aki di na tenangwo yal momua. ");
INSERT INTO sll_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Te na yalhobi Yisas honagi mining aki diminia. Na yalhobi tani taman. God nin Kwiang para aki dimia. Kwiang iwe, God grang wine ongwo arihobi tongure imua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dimia Kaunsil singaba hobi nigi de pire yong golere aposel hobi si golala di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Di pimba, Perisi yal ta Gameliel, Kaunsil yal Lo tisa molere, ari hobi ha nir si tomia, pirere nugun don kengwo wai piminua dungwo yal i, aire, aposel hobi aule ire, “Mena po. Haung obilga monamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ditere singaba u ku bongwo hobi yu ditongwi, “Ni Isrel arihobi yalhobi tal ta ol terala di pinanga nomani si pir kun olo. ");
INSERT INTO sll_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Homa yal ta Tiudas u tibi pire singaba bir moliwa dungure, ari miki weni po handred doling bomia. Bomba, si gomia gamahobi u sutani pire honagi ol tekimia. ");
INSERT INTO sll_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Te Gaman haang esa dungwo haung Galili yal ta Yudas u tibi pire dungure, ari tabin hobi sikira dire tau pir tomia. Tomba, ere yu si gongure, doling bongwo hobi ere yu u sutani pire honagi ta ol tekimia. ");
INSERT INTO sll_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yu ongwo meri irai omaga boling kul tibi olia. Yalhobi tal ta ol terala di pinanga i pisolo. Ya monamia. ");
INSERT INTO sll_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nin haang panangwo di wanangwo i, ya ime sinamba, God haang panangwo di wanangwo i ya ime ta sikinangwo pamua. Ena ni yalhobi hadagi dire ol i nanga God kina kura bonanga pamua.” ");
INSERT INTO sll_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ena yu dungure ari singaba u ku bongwo hobi, “Owa, ha pangwo dinua” dungwi. Dire aposel hobi wo ditomia ungure, kewa kuba sire Yisas ol wai ol na tongwo ha i ari hobi ditekio dire hobang si tongwi. Tere gule olungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Olungure Kaunsil oo malgi pisole ere mena ongwi. Ere mena pire God hon maa e tere “Yisas pir tere honagi ominga i pire gul iminia. Ire God wai pir tomimua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ena yalhobi Yuda ha maing oo ala te nin oo ala Yisas Kraist ol wai ol na tongwo ha maing nir si tere tere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ena emgi haung ta Yisas doling bongwo hobi u bir ongwi. Ongure gamahobi tau yol Isrel momba, Griki howa yure yure mongwi. Mongwo hobi iwe, yol Isrel Hibru ha dungwo hobi kina ha bolbin dungwi. Griki ha dungwo hobi, “Hamen haung haung na al werai hobi moni ebir si na tenga kunung paikimua” dire, han tongwi. ");
INSERT INTO sll_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tomia aposel hobi pirere, Yisas doling bongwo hobi gala di ku bolere, yu ditongwi, “Nan aposel hobi God ha maing honagi pisole, homena honagi onaminga kunung panamo? I ta paikinamia. ");
INSERT INTO sll_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gir hobo, ni yalhobi monga sina i yal ana hol pai muru hol pai sutani God Kwiang yong sina molere, yong wu bungure, tal dime dire ole nomani wai pangwo hobi, nu ke tere, ha maing moni honagi olo, ditenamna. ");
INSERT INTO sll_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ditere nan yalhobi God ha ditere tere mole, te ari hobi ha maing di te monamna.” ");
INSERT INTO sll_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dungure ari hobi “Owa, para dinua” dire, ari ana hol pai muru hol pai sutani i tibi olungwi. Olungwo hobi haang yu pamia. Ta Stiben, yal i God Kwiang yong wu bungure God ogolo pir tongwo yal momia. Te ta Pilip, ta Prokoras, ta Naikena, ta Taimon, ta Pamenas, ta Antiok hong yal Nikolas homa wiyol ta momba, Yuda ha maing pire u Yuda ari mongwo sina i ure momia. ");
INSERT INTO sll_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ena haang dangwo hobi u aposel mongwo mala i mongure, aposel hobi God ha ditere yalhobi breng a tau si tongwi. ");
INSERT INTO sll_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ena God tal ol na tongwo ha maing i wa dire ganba ganba i pai i ongwi. Ongure Yerusalem malgi ari hobi miki weni Yisas pir tongure u bir ongwi. Ongwo hobi iwe, Yuda ha maing oo kene ongwo gamahobo miki weni para Yisas pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ena yal Stiben iwe, God aki di tere yulang tere dimia, yal i tal guma hon nimni mongwo miki weni omia ari hobi hangwi. ");
INSERT INTO sll_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Hangure Yuda ha maing oo yal tau homa boi honagi yal momba, omaga aidole ya mongwi. Mongwo hobi iwe, Sairini hong yal tau ire, Aleksandria yal tau ire, Silisia tau ire, Esia tau ire dire, molere, yal Stiben kina ha bolbin dungwi. ");
INSERT INTO sll_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dimba God nin Kwiang Stiben yong wu bungure, Stiben ha dungwo mo yuwo ongure, yalhobi ha dungwo ya ime sungwi. ");
INSERT INTO sll_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Simia yalhobi yal tau yong wu bungure hasu dire, “God yal Moses kina gaung ha simua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dungure ari yal al hobi ire, ha maing oo singaba ire, Lo ha nir si tongwo hobi ire dire, yong ki e tere, Stiben aule ire Yuda ha maing oo Kaunsil mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pirere hasu dungwo yal tau aule ire pire yu dungwi, “Yal i mone mone Yuda ha maing oo bir te Moses krehaman ha gaung ha simua. ");
INSERT INTO sll_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sire Nasaret hong yal Yisas ha maing oo bir aidolangure, Moses krehaman ha aine aine di na tongwo hobi pisolangure, ha maing ta hon ere aine di na tenamua.” ");
INSERT INTO sll_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dungure Kaunsil uku bongwo hobi Stiben gumang bani tene yuling bole hangure, Stiben gumang digan holkire ensel pirari gumang hongwo meri homia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ena Yuda ha maing oo singaba nambawan molere, Stiben yu sirin bol pungwi, “Ha i ha pangwo dim mo?” ");
INSERT INTO sll_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dungure Stiben yu ditongwi, “Ni Yuda ari ena abina hobi pir molo. Kwiana moya Ebraham Heran ganba hore, Mesopotemia ganba ke pai mongwo gin iwe, God na hankinama dire nin u tibi pi na tere, ure, Ebraham yu di tongwi, ");
INSERT INTO sll_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ebin abin hobi nin ganbani para aidole, ganba banta i tibi ol ni teralga bani ke pare monana po.’ ");
INSERT INTO sll_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dungure Kaldia aidole, pi Heran oo malgi ke pai momia. Mongure Ebraham irang gomia. Gongure God Ebraham aule ire, na yalhobi Yudia ganba ke pai mominga bani umua. ");
INSERT INTO sll_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Umba, God Ebraham ganba girin ta nin tenangure, ya nere ke paikimia. Ganba obil weni taga ere ya nekimia. Ya nekimba, God emgi Ebraham gang male siru dinangwo hobi ganba tegere ya nenamua, dimia. Ebraham wang ta kul ekungure ha i homa di tibi ol tomia. ");
INSERT INTO sll_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tere God yu dimia, ni galni ganba bani male siru dinangwo dire pi wiyol ganba banta molere, boi honagi yal molere, me erin miki weni po handred yia molere, gul bir pire pire moli namua. ");
INSERT INTO sll_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Moli nangure ari boi honagi ol tongwo hobi ha hol ol teralua. Teralgere ni galni hobi wiyol ganba ta aidolere, ere memini umia, ure na u na hole maa e na tenamua. ");
INSERT INTO sll_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dire God Ebraham gang hobi gaung bol olama dire yu ditomia. Ditongure Ebraham wang Aisak kul nere hamen haung ana hol pai muru, hol pai sui tai dire molere, gaung bol olimia. Te Aisak wang Yekop ere yu ol tomia. Te Yekop wang ana holo holo kebena sutani kul engwo hobi ere para yu gaung bol olimua. ");
INSERT INTO sll_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ena kwiana moya homa malungwo hobi yal Yosep kiang pai tere Isip ari hobi tere, moni bol imia. Imba, God Yosep aidolekimia. ");
INSERT INTO sll_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kina ereho mongure ari hobi talime oun dongwo Yosep ol tomiba, God aki di te momua. Mongure Yosep Isip singaba Pero mongwo bani pire nomani wai pangure tal wai mone omia Pero hamua. Hanere Pero Yosep nin oong te Isip ganba para imu dire kene ol monama dire, i tibi ol tomia. ");
INSERT INTO sll_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ol mongure emgi menan bir u tibi pire Isip ganba ya, Kenan ganba menan bir gomia. Golere gul bir weni pimia. ");
INSERT INTO sll_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nan kwiana moya homena wa dumba, Yekop mole pungure Isip ganba homena ya dimua dungwo pimia. Pirere Yekop wang kwiana moya hobi homa bai nu si olungure, kwiana moya hobi pi Isip malgi omia. ");
INSERT INTO sll_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pire u mole, emgi hon omia. Ongure Yosep abimbi hobi nin tal ol tongwo maing di tibi olimia. Olere ‘ni yalhobi ebin Yosep na moliwa’ ditomia. Ditongure king Pero Yosep gamahobi han pa dimua. ");
INSERT INTO sll_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ena Yosep irang Yekop abing hobi kina unama dire gala di aulimia. Aulungwo hobi namba imu dire, 75 di aulungure Isip ganba umia. ");
INSERT INTO sll_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","U molere Yekop gongure wang na kwiana moya hobi para gomua. ");
INSERT INTO sll_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gongure er ba hau ire pi Sikem ganba pire man wu emia. Engwo ganba iwe, homa yal Ebraham yol Hemo ganba ta moni bring si ingwo bani man wu emua. ");
INSERT INTO sll_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ena homa God Ebraham aling kere e tere tere ongwo meri irai omaga u tibi nangwo haung mala umua. Ungure na arina Isrel ari hobi Isip ganba molere, miki male siru di mena omua. ");
INSERT INTO sll_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Emgi Isip yal bir king ta u tibi pire, Yosep tal ongwo i ha gung pirekire, Isip ari kene omia. ");
INSERT INTO sll_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ol molere, na kwiana moya hobi bal tomia. Tere wang aung hobi pia si maini olo ditongure, olungure, gir hobi gomua. ");
INSERT INTO sll_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Golere tal yu ol mongwo gin iwe, yal Moses aang kul engure, gumang grang wai weni homia. Hongure irang aang suri haba sui tai dire, gir i kene ol i wamia. ");
INSERT INTO sll_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ware emgi auli maini ongure, singaba Pero aung i ure hanere, gir i wai weni hanere, na kul nerala yuwo dire nin kul engwo tani kene hane ogolo weni olere yu wamua. ");
INSERT INTO sll_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yu wangure Moses bir dale Isip ganba sikul di momia. Mongure, Isip ari hobi nin memini pangwo meri Moses krehaman tongure, yal i pire nona pare nimni momua. ");
INSERT INTO sll_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ena emgi Moses ari mole me erin yia yal sutani kebering aling molere, na nan arina Isrel ari hobi monangwo haralua di pimia. ");
INSERT INTO sll_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","di pire hangure Isip ari ta ure Isrel ari ta ol gogo dal tongure hamia. Hanere yal i ure Isrel yal i aki di tere Isip ari si gomia. ");
INSERT INTO sll_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Si golere yu nomani si pungwi, na arina Isrel ari hobi aki di tegiwe, God yulang na tongure, Isrel ari hobi u wai naminua di pinama di pimia. Di pimba, Isrel ari hobi Moses tal ongwo i nin hang pangwo ol wama di pimua. ");
INSERT INTO sll_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pire parere, honmil hon u pa dire hamba, Isrel yal sutani nin kura bomia hanere, ‘A, ni yasuri nin holo holo kura bolala di ongiwe, paikimia, bolkio,’ dire a poira simia. ");
INSERT INTO sll_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Simba, tal gogo ole pring pangwo yal i Moses anu si ulubi olere, ‘Ara kene onanga yal mole yas ha hol ol na tenanga yu olo di ni tome? ");
INSERT INTO sll_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ongi ni Isip yal ta si goniraya, na yasuri ere yu na si golala di on mo?’ di tomia. ");
INSERT INTO sll_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ditongure Moses tal ongwo i, Pero ha wai ha pinama dire te omia. Te pirere ere pi Midian ganba momia. Moli pire wang sutani kul emua. ");
INSERT INTO sll_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ena me erin yal sutani kebering aling mol i pirere, Moses hamen hul Sainai mala weni ganba po engwo bani mongure, kwia ensel er migiga ta endo bala sungwo sina ala i u momua. ");
INSERT INTO sll_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mongure Moses endo bala i hane bukunere, er bani endo dongwo i harala di mala omia. ");
INSERT INTO sll_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Omba, endo dongwo sina ala i God ha yu di mena, olimia, ‘Ni kwian moya Ebraham ire, Aisak ire, Yekop ire dire, God na moliwa.’ Dungure Moses ganulun dire, kul pire, ikwi bomia. ");
INSERT INTO sll_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bongure God yu ditomia, ‘Ganba ire aire monga bani isra mana pangwo ai dimia, ni keben daing gule ole molo. ");
INSERT INTO sll_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na gamna hobi Isip ganba molere, gul bir weni i tibi ole mongwo haminge. Hamingere ari hobi hai mere ginga di mol dungwo i pirere aki di tegere u wai nama dire ya ime wiwa. Wiya ni airingere, ni bai nu si olgere, Isip ganba mole unga bani nanua.’ ");
INSERT INTO sll_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ena yal Moses iwe, ari hobi kene ol na tere ha hol pungwo yal monanga ara molo dire i tibi ol ni tome? di tere siga wa tomiraya. Wa tongwo yal iwe, God nu ke tere Isrel arihobi sigare kule u wai nama dire er bani endo bala sina ala i ensel ta mongwo hangwo yali, aki di tomia. ");
INSERT INTO sll_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tongure Moses ari hobi Isip ganba aidolama dire aule re omia. Pire Isip ganba te pil nir digan Nol mongwo bani te, ganba po engwo bani me erin yal sutani kebering aling wa molere, tal guma hon dongwo ole, tal nimni mongwo moni omia hamua. ");
INSERT INTO sll_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Hangure Moses iwe, Isrel ari hobi yu ditongwi, ‘God na nu si olungwo meri ni galne male monangwo bani yal ta ereyu nu si olangure, God hana togu yal molga meri monamua.’ ");
INSERT INTO sll_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Dimia emgi ari hobi pi ganba po engwo bani mongure Moses kina para momua. Mongure kwiana moya hobi Moses kina mongwo gin iwe, Sainai hamen hul ensel ha ditongwo i Moses nin pimua. Pungure God ha maing nona pangwo nan mominga bani aine aine pai nama dire, Moses ditomua. ");
INSERT INTO sll_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ditomba, nan kwiana moya hobi wine olkima, pisolere Moses ni kene ol na tenga paikimua dire, aidole, yalhobi hon ere Isip nangwo ha wai pimua. ");
INSERT INTO sll_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pirere yal Eron yu ditongwi, ‘Ni tal ta yong ba e na tengere, na yalhobi pir tenaminua.’ ‘Ena Moses iwe, na yalhobi Isip mominga na aule ire umia omaga banta om mo, gom mo, han kun olekiminua.’ ");
INSERT INTO sll_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dire ari hobi bulamahau giring mongwo meri yong ba ere, hau si ke tere, nin talhan ol engwo i ere wai pire, homena si gal nomua. ");
INSERT INTO sll_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ena yu ol wangwo hobi, God hanere, mobing hal wa tongure ari hobi haba ya, kulmoma ya, ari ya hanere pir tongwo i, God pir tenangwo tenama aidolo dire han gogo dal olimia. Olungwo ha iwe, God hana togu yal ta ha yu dire mining bol emiraya, ‘Isrel yal al hobo, ni ganba po engwo bani me erin krismasi yal sutani kebering aling molere hau si gangarai, na ta si gal na tekiniraya. ");
INSERT INTO sll_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tekire yong ba engwo gal haang Moloko gal oo kere i ala i ere a ire ire waniraya. Ware kulmoma ta haang kwia Repan momua dire pir tere a i si waniraya. Hulu iwe, ni yalhobi nin mining ganing wai ol ere i ware pir tenua. Yu ongiwe, na wai pima di pino? Ta pirikia. Ni bai nu si olgere Bebilon ganba hol bani monanua.’ ");
INSERT INTO sll_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ena homa nan kwiana moya ganba po engwo bani molere, gal oo kere God na kina si daule mominua dire, pir tomua. Gal oo iwe, God homa kenama dire, Moses nibil di tongwo meri kemua. ");
INSERT INTO sll_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Emgi kwiana moya gal oo i, wang kul nongwo hobi, Yosua kina mongwo gin i, si aine aine tongure, ari hobi gal oo i a pema ke engure, God ganba hong si doling i olungure, u banta ongure, ganba i na kwiana moya hobi imua. Ingure gal oo i, singaba Debit mongwo gin i, ya di pamua. ");
INSERT INTO sll_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ena God Debit tal dime dire ongwo hanere miling ala pamia. Pangure Debit God kina ha di te molere, gal oo nigi domia oo nimni mongwo ta kerala dire sirin bol pimua. Pungure God, ‘Owa, ni wani ke na tenamua’ dungure, Debit nin kekima. ");
INSERT INTO sll_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Moli pire gongure wang Solomon aibing maulung sire oo i kemua. ");
INSERT INTO sll_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kemba, God iwe, ari ha maing oo kengwo ala i tani momo? I ta molkimia. Banta banta para weni momua. Mongwo ha iwe, God hana togu yal ta yu di tibi ol emiraya, ");
INSERT INTO sll_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nabe God yu dimia, God tani weniga momba, te hamen ganba moiring sina i para weni wa pa dimua. Ni oo talmere ole ke na tengere kunung bename? Ni bol taniga kul na tengere kunung benamo? I ta bekinamua. ");
INSERT INTO sll_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Oo ya, bol ya, talhan hobi hobang na molkio? Na tani moliwa.’ ");
INSERT INTO sll_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ena hana togu yal yu dimba, ni yalhobi kere pir tekire, kuru dinua. God pir tekinga hobi ni nomani yu pania, pare God ha dungwo i pire a i si wakinua. Wakire kwiana moya hobi God nin Kwiang pir tekungwo meri ni ere para yu pir tekinua. ");
INSERT INTO sll_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tekingiwe, homa kwian moya God hana togu yal taniga tal gogo ol tekinangwo yali momua dire haang dalo. Hobi para weni tal gogo ol tomia. Tere God honagi yal bir tal dime dire ongwo yal i unamua di tibi ol tongwo hobi para si gol wai simua. Sungwo meri iwe, ni omaga God honagi yal bir nan mominga bani ungwo irawe, mobin hal wa tere si gongere gomua. ");
INSERT INTO sll_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God Lo krehaman ha iwe, ensel ire ni yal hobi monga bani umba, a i si ware wine olkinua.” ");
INSERT INTO sll_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ena Stiben ha i di tomia ha maing Kaunsil hobi nigi de pire yong ere mongure grang kul hangwi. ");
INSERT INTO sll_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hamba, God Kwiang ure Stiben yong wu bile yulang tomia hamen bani yuwo hanere, God nimni mongure Yisas kina si daule momia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hanere, “Han ya olega. Hamen hona grang hoiri yaulungure God Ari Wang Weni kina si daule mongwo haniwe” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dungure yalhobi kraung agi dire, mu di ongwi. ");
INSERT INTO sll_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pire Stiben auli mena pire, hulu kuba ire sungwi. Sungwo hobi galsina gul ire pire, yagaling ta Sol mongwo bani engure, kene ol mongwi. ");
INSERT INTO sll_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ena yalhobi hon Stiben hulu kuba sungure Stiben gala dire yu dungwi, “Yal Yisas ye, golalia na kwiana aki di iyo.” ");
INSERT INTO sll_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dire ikwi bole gala dire, “Nabe, ari hobi talime olere, tal digan ol na tongwo i pring tekio.” Ditere gongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Gongure Sol hanere, Stiben krai mongwo gomia dire wai pungwi. Ena yu ongwo gin iwe, ari hobi yol Yuda Yisas ha maing pire Yerusalem ke pangwo hobi tal maing nigi dongwo ol tongwi. Ol tongure, Yisas doling bongwo hobi te pi Yudia ganba Sameria ganba holi u sutani ongwi. Ongure aposel yalhobi Yerusalem ya mongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ena ari tau God pir tere wine ongwo hobi Stiben man wu ere aya maya dire hai mengwi. ");
INSERT INTO sll_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ena yal Sol Yisas doling bongwo hobi para sire ol gogo dal terala di ongwi. Olere oo hona hona pirere, Yisas doling bongwo yal al hobi aule pilu dire i hani oo ala olungure halabusi pangwi. ");
INSERT INTO sll_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ena Yisas doling bongwo hobi u sutani pire, ari holo holo pai ongwo i Yisas ol wai ol na tongwo ha maing ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ditongure yal Pilip pi Sameria oo malgi pire singaba Kraist tal wai ol na tongwo maing di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Olungure ari miki weni Pilip ha dungwo ogolo weni pungwi. Pirere tal guma hon dongwo ongwo i hangwi. ");
INSERT INTO sll_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Hangwo yal al hobiwe, tau kwia nigi dongwo yong sina i mongure gala bir dire aidole ere mena ongwi. Te ari tau kebering aling kebir engwo, kebering ki sungwo hobi awai ol tongure hol wangwi. ");
INSERT INTO sll_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Wangure Pilip ha dire tal ongwo i ari hobi wai pire miling pangure mongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ena oo malgi i, yal ta haang Saimon ke pai molere, kumo gia ol mongure, Sameria ari hobi hane bukunungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kunungure yal iwe, na nan singaba bir moliwa dungure, ari mongwo yangwo moli ongwo hobi para weni ogolo weni pungwi. Pirere, Yal i God Yulang nima ongwo imia, God Yulang nimaki ongwo yal wa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ena yal i kumo gia mone ol mongure, ari hobi bukunere ogolo weni pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tomba, Pilip emgi u pa dire God kene ongwo hol ha maing ire, Yisas Kraist ol wai ol na tongwo ha maing ire dire, di bole di tibi olungwiwe, yal al hobi ogolo pir tongure, nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bil tongure Saimon ere para pir tomia nir bil tongure Pilip kina ereho mongwi. Mongure yal Pilip tal guma hon dongwo maing maing i tibi olungure Saimon hanere grang dalungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ena aposel Yerusalem mongwo hobi, Sameria ari God gung hang pir tere wine omua dungwo pungwi. Pire Yon Pita kina bai nu si olungure Sameria ganba ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pi pa dire, Yisas doling bongwo hobi God Kwiang inama dire God ha sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bol tongwiwe, yalhobi God Kwiang olo ikungure, hobana Yisas haang tani a yuwo olere nir bil tomia. ");
INSERT INTO sll_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ena Pita Yon yasuri hanere, God Kwiang inama dire breng bani a tau sungure, ari hobi God Kwiang ingwi. ");
INSERT INTO sll_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ena imia Saimon aposel suri tal ongwo i hanere, God Kwiang ire ari hobi terala dire, moni ire yasuri mongwo bani ungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ure, “Ni yasuri ari breng bani a tau singa God Kwiang ingwo meri na yu olala dire moni ire wiwe. Ni yulan na tengere ari breng bani a tau siralga God Kwiang inamue,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dimba Pita yu ditongwi, “God awai honagi pire yamoni tongwo tal iwe, ni moni bring siralua dinga paikimia, moni ni kina ereho endo de pangwo bani nanua. ");
INSERT INTO sll_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ena tal i ni talni ta dikimia, ni nomani paikungure God kina guma pule ikinga hamua. ");
INSERT INTO sll_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hamia ni omaga moni kina ure tal yu olalua dingiwe, moni tobo aidole, nomani si kulu sire tal nigi dongwo hon olkirala di pire wayo. Ware God sirin bol tengere pring pai ni tongwo i, i ole ni tenamua. ");
INSERT INTO sll_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ena God tal ongwo i teni han nigi de ingiwe, pring ni han hongure ni hani pai monua.” ");
INSERT INTO sll_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dungure Saimon mole, Pita Yon suri yu ditongwi, “Ni yasuri God sirin bol tengere, tal ol na tenangwo i pisole aki di na tename.” ");
INSERT INTO sll_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ena Pita Yon yasuri God ol wai ol na tongwo ha i kara di ba bol te pisole, ere Yerusalem ongwi. Nala di pire ha maing i, Sameria oo tabil tabil i di te i ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ena God ensel ta ure, “Pilipo, ni aire homaulung Yerusalem pi Gesa ongwo hol i wayo,” ditongwi. Ditongwo hol iwe, ganba po engwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ena Pilip nala dire homena akun ole ere, ire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ongure Itiopia ganba yal ta al singaba kwin moni ben kene ongwo yal i Yerusalem pire God u na hongwo pamua dire maa e tere ere memini nala dire, hara ta kun ausi nugung bani han holengure, aule pilu dungwo hara bani ami di mole, hana togu yal Aisaia ha di engwo buku i kere kere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ongure Pilip God Kwiang yong wu bungure, “ni hara ongwo mala i po” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ditongure Pilip bli si mala pire pungure, yal i Aisaia buku i kerungwo pungwi. Pirere, “Buku keringa i memini pin mo?” dire sirin bol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tongure yal i mole, “Yal ta di ba bol na tenangwo memini pir po siralga pamia. Na nan talmere ole pinama di dine?” dire Pilip hara ala wo ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ena God ha maing buku kerungwo i yu pamia, Ari kun sipi sipi aule ire ure sirala di ongure ge dikungwo meri yal i ha ta dikimua. Te kun sipi sipi giring eme bangwo ge dikungwo meri yal i ere ha ta dikimua. Yu ongwo meri iwe, yal i ere grang saang dire ha ta di mena olekimia. ");
INSERT INTO sll_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yu ongure ari hobi gaung ha si tere han tere ha ta oun denangwo paikimba, ha di mere sire ha hol ol tomia. Mol pai ol wai simba, gang ta malekimua. Malekungwo ipire, ari hobi ta boling kul tekinamua.” ");
INSERT INTO sll_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ena moni ben kene ongwo yal i Pilip yu ditongwi, “Hana togu yal ha di engwo keriga i, yal i nin haang dim mo, yal ta haang dime? ");
INSERT INTO sll_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Maing di ba bol na to.” Dungure Pilip maing di ba bole, kerungwo hobi para maing di ba bol te i pire, Yisas maing para di ba bol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Te i ongure pi nir nulu pa dungwi. Pa dire ben kene ongwo yal i yu dungwi, “Nir iwe, na bil na tenanga para panamo?” ");
INSERT INTO sll_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Dungure Pilip yu ditongwi, “Ni God ogolo weni pir tenanga nir i binanga pamua” dungwi. “Na Yisas iwe, God wang weni moma di piriwa” dungwi.) ");
INSERT INTO sll_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dire kun ausi han hol eyo dire yal i Pilip kina nir ala pire, Pilip yal i nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bil tongure yasuri nir ala aidole mena ungure God Kwiang ure Pilip aule ire ongwi. Ongure ben kene ongwo yal i, Pilip ongwo hol i han kun olekimba, gun ere, ere malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ena Pilip u Asdot ganba pa dire u oo tabil tabil i pire ari Yisas ol wai ol na tongwo ha maing di te i ongwi. Pire pi Sisaria malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ena yal Sol ha di yulang bole yal Yisas grang wine ongwo hobi si gonama dire dire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Olere Yuda ha maing oo singaba mongwo bani pire, “Pasi bol na to. Na ire pire Damaskas ha maing oo singaba tegere hanere, ari Yisas doling bongwo hobi auli na tenangwo, halabusi si ire Yerusalem uralba?” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ditongure tomia ire nala di ongwi. Pi bangi ongure hamen bani hamen nabilungwo gi di ya yal i mongwo bani bongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Bongure Sol gumang hol ya manbi pare pungure ha ta yu ditongwi, “Sol, Sol, ni talongure na ol gogo dal na terala dire one?” ");
INSERT INTO sll_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Dungure Sol molere, “Yahuno, ni arawe?” dungwi. Dungure yal i, “Na Yisas molia, ni tal gogo ol na tenia. ");
INSERT INTO sll_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tenba, ni aire Damaskas malgi nanga, tal ta onanga maing yal ta di tibi ol ni tenamua.” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dungure ari Sol kina ongwo hobi ira mole ha dungwo pimba, ari ta monangwo gumang hankungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ena Sol aire omeling pila dire hamba, omeling si bomia, talhan ta ogolo han kun olekungwi. Han kun olekungure ari hobi aling a ire pi Damaskas malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ongure hamen haung sui tai dire, omeling ya si bol pangure, nir homena nekire mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ena Damaskas malgi iwe, Yisas ha dungwo a i si ware doling bongwo yal ta haang Ananaias mongwi. Molere ginangwo God ku ha ditere gala dimia hangwi. Hanere, “God ye, na moliwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dungure yu ditongwi, “Ni aire homaulung hang Stret ongwo holi po. Pi Yudas oo pire, Tasas hong yal ta Sol mom mo? di pinana po. ");
INSERT INTO sll_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yal iwe, omaga na ha di na te mongure, na ku ha ditega, yal i ni ure omeling pila dinama dire, ani breng bani anga hamua.” ");
INSERT INTO sll_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dungure Ananaias pi tege eminga yali yu ditongwi, “God ye, yal i guung haang piriga. Yal i ni gaminahobo Yerusalem mongwo i tal ol gogo dal toma dungwo piriwa. ");
INSERT INTO sll_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ol tongure Yerusalem Yuda ari ha maing oo singaba hobi haman tere ni hani wine ole Damaskas mongwo hobi han sinama dire umua.” ");
INSERT INTO sll_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dungure hobana yu ditongwi, “Na hana iwe, a i ware, ari hana ya mongwo hobi ire, singaba king hobi ire, Isrel ari hobi ire dire, di tibi ol tenama dire, nu ke teya, mongwo bani po. ");
INSERT INTO sll_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na hana pinangwiwe, gul ire, tal oun dongwo inangwo nan i tibi ol teralua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ena Ananaias pi Sol mongwo mala pire bring bani a tau sire yu ditongwi, “Enambi Sol ye, homaulung bangi unga hobana Yisas u tibi engwo hanga yal iwe, na bai nu si olungure wiwa. ");
INSERT INTO sll_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Olungwiwe, ni omin pila dinangure, God Kwiang yon wu binama dire na nu si olimua.” Dungure gintani Sol omeling bani gang kirebini para di dungwo woongure, omeling wai dimia talhan hangure, nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bil tongure Sol nir homena nere nimni mongwi. Molere habang tau Damaskas malgi Yisas doling bongwo hobi kina pana gale mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ena molere gintani pi Yuda ha maing oo hona hona i pire, Yisas mongwo maing di tibi ol tere, “Yisas iwe, God wang momua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ditomia ari hobi ha dungwo i pire ganulun dire “Ayo, yal i Yerusalem mole, ari Yisas tal ol na tongwo ha maing pire wine ongwo hobi sirere, te nan mominga bani ure, Yisas doling bongwo hobi han sire aule ire ure Yerusalem ha maing oo singaba terala dungwo irawe,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ena Sol yulang bole, “Yisas iwe, Kraist momua” ditongwo i, Yuda ari Damaskas mongwo hobi Sol kina ha bolbin dinamba, Sol ha dungwo i mo yuwo omia pire, ha ta mong ditekungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ena habang miki tani wai sungure Yuda ari hobi Sol si golala dire u ku bole ha hongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ha homba, Sol pirere Damaskas malgi ya mongwi. Momia Yuda ari hobi Sol mena unangwo sirala dire girungwo omare u egereng kwi han mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Momba girungwo ta gamahobo Sol aule ire hulu u sungwo mini bani mo pire gal bir ala ami di mongure han hole pia si mena holi olungure ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ena Sol pi Yerusalem pire Yisas grang wine ongwo hobi kina pana galala dire, ongwi. Omba, gamahobo iwe, Sol kulung pire yali na gamnahobo ta moma di hankima. ");
INSERT INTO sll_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hankimba yal Banabas Sol aule ire aposel hobi mongwo bani ongwi. Omia Sol iwe, homa Damaskas nala dire, pi bangi pire, hobana Yisas u tibi umia hangure, ha di tongure, Sol Damaskas pire Yisas ol wai ol na tongwo ha maing di nima pire di tibi ol tomiraya dire, ari hobi yu ongwo yal irai umua ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Di tibi ol tomia Sol yalhobi kina molere Yerusalem oo hona hona i wa molere Yisas ol wai ol na tongwo ha maing ari moma pama di pirekire yulang bole di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Di tere Yuda Griki howa yungwo yal ta kina ha wai ole ha bolbin dungwi. Dimba yalhobi nigi de pire Sol si golala di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pungure Yisas grang wine ongwo hobi hanere, Sol aule ire Sisaria oo malgi pire, nin ganbani Tasas onana po dire, bai nu si olungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Olungwo ongure Yudia ganba ya, Galili ganba ya, Sameria ganba Yisas pir tere ha maing pire mongwo hobi ari kura ha dire ha bil bal ta dikungure mama weni dime dire mongwi. Mongure God Kwiang aki di tongure, yalhobi hobana Yisas kebering ala bere, ha maing ogolo weni a i si ware mole ari male siru dungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ena yal Pita Yisas grang wine ongwo hobi harala dire ganba bina holo holi wa i ongwi. Pirere ginta Lida ganba pire Yisas grang wine ongwo hobi kina pana gal mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mole hangure, yal Inias nibil ole yulagi bona kere me erin et yia hol wakire, bol bani ul pare pare momia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Hanere Pita yu ditongwi, “Inias, omaga Yisas Kraist ni hanere, milni pire awai ol ni tongure u wai onia. Ni aire homena ke no.” Dungure Inias gintani airungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Airungure Lida malgi Seron malgi ari hobi tal ongwo i hanere hobana Yisas pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ena Yisas doling bongwo al ta haang Tabita al iwe, Yopa ganba ke pangwi. Airing iwe, haang ta Dokas engwi. Al i tal wai ole habang habang ari nir homena wa dungwo i aki di tere tere mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Moli pire habang ta nibil ole gongwi. Gomia ari hobi yone bigi si tere aki di werang ta ala i olungwi. ");
INSERT INTO sll_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ena Yopa ganba iwe, Lida ganba mala weni dungwi. Dimia ari hobi mole pungure, yal Pita Lida malgi momua dungwo pungwi. Pirere yal sutani bai nu si olungure Pita mongwo bani pire, “Kwi molkio, omaga unana po.” ");
INSERT INTO sll_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Dungure Pita u hongure aule ire ungwi. U pa dungure ari hobi Pita aule ire werang ta al yone engwo bani ongwi. Ongure al werai ure Pita mongwo bani yobile mole hai me mongwi. Molere Dokas mongwo haung galsina gal warungwo hobi i tibi ole Pita gumang bongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bongure Pita ari yal al mongwo hobi ere maini po ditere Pita ikwi bole God ha ditongwi. Ditere gumang te al yone pai mongwo holi olere, “Tabitao, ni airo” ditongwi. Ditomia al i omeling pila dire Pita gumang bani hanere, aire ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mongure Pita mala pire aling are aki dungure airungwi. Airungure Pita al werai hobi ire, Yisas pir tongwo hobi ire dire, di ku bole gala dire al irai umi imua ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ena Pita tal ongwo ha iwe, Yopa ganba holo holo i wa dire kunung bengwi. Bemia ari miki weni hobana Yisas pir tere grang wine ongwi. ");
INSERT INTO sll_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ena Pita Yopa ganba bani habang gobari pai molere, kun bulamahau gang tal mini hai ongwo yal ta Saimon kina pana gal mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ena yol Roman yal Konilias soldia kepten mole Itali soldia miki wan handret kene olere Sisaria ke pai mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Molere God ha maing agi di ware, gamahobi kina God yol e pir tongwi. Tere mole Yuda ari talhan a nekungwo hobi yamoni pirari pare aki di te molere, God kina ha wai ole ole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Molere pudungwo tri klok God ensel ta ure ku ha dire “Konilias” gala dungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dimia Konilias tene hanere, ganulun dire, “Yahuno, tal ome?” dungwi. Dimba ensel yu ditongwi, “Ni God ha wai ol te mole, pirari pare yal tau tal a nekungwo aki di tengiwe, God hanere wai pire ni tomia, tau nu si Yopa ganba olo. ");
INSERT INTO sll_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Olingere pire yal Saimon haang hon Pita engwo yali aule ire timiya unamia. ");
INSERT INTO sll_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ena yal Pita iwe, Saimon kun gang mini hai ongwo yal i nir bina ke pangwo ala i momua”. ");
INSERT INTO sll_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Direre ensel Konilias ku ha di te pisole ere ongwi. Ongure Konilias honagi yal sutani soldia ta kina gala dimia ungwi. Soldia iwe, God ha maing yol e pire Konilias kina pana gangwo yal mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Momia Konilias yal su hobi ku hangwo meri boling kul tere nu si Yopa malgi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nu si olimia yal su hobi ongwo hamen girimia pi bangi pare tanangwo pi malgi giu dungwi. Giu dungwo haung Pita God ha di terala dire omare oo mini bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pi molere menan golere homena nerala dire ungwi. Umba homena omaga kere akun ol mongure Pita ul ime dire ku hangwi. ");
INSERT INTO sll_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Hangure hamen hona grang saang dire tal ta gal apalapo bir weni dungwo meri a bigi holo holo sui sui dire angure mu sire ya ime ungwo hangwi. ");
INSERT INTO sll_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ungwo ala iwe, dua hau onba hahoba para mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ena ha ta yu ditongwi, “Pitao, ni dua hau hobi kene ole si no.” ");
INSERT INTO sll_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dimba Pita yu ditongwi, “God ye, Yuda ari molia memini pangwo hau hobi gogo ta nekigarawe.” ");
INSERT INTO sll_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dungure ha hon yu ditongwi, “Talhan hobi God nenana dire ol kuari pai ni tongwo iwe, nin mai tenanga paikimua.” ");
INSERT INTO sll_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Talhan i gin sui tai dire u tibi ongwo hangure, ere hamen bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ena Pita ku hangwo i memini pir po sikire nomani si gogo dal mongwi. Mongure Konilias nu si olungwo yal su hobi, ari iriyala tongwo hobi sirin sirin bol pire, “yal Saimon oo makena ke pame?” dire dire u Pita mongwo hona grang i mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mole gala erakere dire, “Yal Saimon Pita ala i momo?” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dungure ku hangwo i memini ogolo pirekire nomani si ungure God Kwiang yu ditongwi, “Pino. Yal sui tai dire ni ni wa du i umia. ");
INSERT INTO sll_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ungwiwe, na bai nu si olga umia, ere nangwo ni nomani gogo sikire kina ereho po. Omaga yal su hobi mongwo ime po.” ");
INSERT INTO sll_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dungure Pita gintani ya ime pire, “Wa dunga yal i na molia, talongwo une?” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Kepten Konilias na bai nu si olungwo uminua. Yal iwe, God kulung pire maa e tere wa momua. Mongure Yuda ari hobi hanere, wai pir tomua. Ni ha dinanga Konilias pinama dire God kwia ensel ta nu si olungure ku ha yu ditomia, Pita ni oon malgi wo dito.” ");
INSERT INTO sll_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dungure Pita yasu hobi ala wo dimia ongure homena nere kina ereho pangwi. Pare yalhobi kina ereho nala di ongure Yopa oo malgi God pir tongwo ari tau Pita kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ena pi bangi ongure hamen girimia pare tanangwo pi Sisaria malgi pa dungwi. Pa dungure Konilias gamahobo e nongwo hobo tau kina unangwo kwi ol mongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mongure Pita pi malgi pa dimia Konilias ure Pita kebering bani i kwi bole, maa e tongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tomba Pita Konilias aling aki dire “Airo. Na ganba ari mominua” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ditomia Konilias kina ha wai ol mole, aule ire ala omia, pire hangure, ari miki weni u ku bole momia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hanere Pita ari hobi yu ditongwi, “Ni yalhobi Yuda ari memini pangwo nin para hania. Na Yuda ari ta wiyol ta kepangwo pire ha wai ole ta mol hankiminia. Hankiminba, God yu nibil di na tomia. Na Yuda ari nomani wai pamio, wiyol tau du haumua ditenga paikimua di na tomia. ");
INSERT INTO sll_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na ni yalhobi na di aulingiwa dire wine ole wiwa. Talongwo na wo dine?” ");
INSERT INTO sll_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dungure Konilias yu dungwi, “Na e pudungwo God ha ditominga haung omaga mominia. Di te momingere yal ta gal pege pire u na gumana holi momia. ");
INSERT INTO sll_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Molere yu dimia, ‘Konilias God ha ditenga haya pimio, te ari talhan a nekungwo ni talhan tau aki di tenga i para hamia. ");
INSERT INTO sll_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ni yal ta nu si olingere Yopa ganba malgi pire yal Saimon Pita Saimon diing kun gang mine hai ongwo yal i pil nir bina kepangwo ala momia aule ire unamua,’ di na tongure na gir hobi nu si ni monga oliwa. ");
INSERT INTO sll_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Olga ni ungiwe, tal wai mere onua. Omaga God kina ereho momingere do di ni tongwo mere dinanga pinaminga pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ena Pita yu dungwi, “God wiyol para weni kunung kunung momua di pimia, omaga na para haniwa. ");
INSERT INTO sll_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wiyol hobi para weni yal tan tani God kuling pir tere grang wine ongwo hobi God gumang yau tekimua. ");
INSERT INTO sll_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God Isrel ari hobi ha maing ditongwo i yu pamia, Yisas Kraist ari Yulang Hong iwe, nan na i ku bongure, God kina yona tani ere si daule mominga hania. ");
INSERT INTO sll_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yon nir bil tere ha maing di tibi ol pisolungure, Galili ganba tal ta u tibi ongwo i ha si wa dire Yudia ganba holo holo i kunung bengwo irai para pinia. ");
INSERT INTO sll_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Te God Nasaret hong yal Yisas nin Kwiang tere yulang tongwo haang pinia. Yisas iwe, ganba bina holo holo i pire tal dime dire ole Seten han hongwo hobi gule ole tomua. Tongwiwe, God kina nin si daule mole ol tomua. ");
INSERT INTO sll_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yuda ari ganba te Yerusalem malgi Yisas tal ongwo i na gina hanere di tibi ol te i uminua. Yalhobi Yisas er pera bani bli nil si ere si gomua. ");
INSERT INTO sll_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gomba haung sui tai dire pai mongure God nin uling yungure hon u tibi omua. ");
INSERT INTO sll_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ongwo ari para ta hankimia. Na gina God nu ke na tongwo hobi nan haminua. Hanere God uling yungure airungwo haung yal i na gina kina homena tani nere mominua. ");
INSERT INTO sll_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Momingere Yisas yu di na tongwi, ‘Na ol wai ol tega ha maing kere ari hobi di tibi ol to. God nu ke na tomia ha hol pungwo yal yas mongwo meri molere, ari gongwo hon mongwo hobi para i tani olere ha hol ol teralga pamua, di na tomua.’ ");
INSERT INTO sll_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","God hana togu yalhobi yal i haang di tibi olere, “ari tau yali ha dungwo i yol e pir tere grang wine onangwo hobi God yal i haang pire tal nigi dongwo ol wangwo God pring tongwo i, i ole tenamua.” ");
INSERT INTO sll_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ena ha yu di te mongure, God Kwiang gintani ya ure ari ha dungwo pir mongwo hobi para weni yong wu bungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wu bimia Yuda ari tau Pita hol ire ungwo hobi ganulun dire yu dungwi, “Ayo nan Yuda mominia wiyol ta mongwo ure ha di te mongwo bani irai God Kwiang nu sungure ure yong wu bimia hano” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dungure yalhobi ha howa ta ta yure dire God maa e tongwo hanere bukunungwi. ");
INSERT INTO sll_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ena Pita yu dungwi, “God nin Kwiang na tongwo iminga meri yalhobi para ingwo hania. Nir bil tenaminga paikinamo? Para panamua.” ");
INSERT INTO sll_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dire krehaman ha yu ditongwi, “Ni yalhobi Yisas Kraist haang dal yuwo ere nir bil ni teralua.” Dire nir bil tongwi. Tongure nir bil tongwo ari hobi, “Pitao, na ni kina ari habang tau momingere nanba?” dire sirin bongwi. Bongure Pita, “Owa, monaminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ena Yudia ganba bina holo holo i aposel hobo ari ha maing pungwo hobi wiyol ta ha maing pir tere wine ongwo ha i pungwi. ");
INSERT INTO sll_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pire mongure Pita mo Yerusalem malgi ongwi. Ongure Yuda ari Yisas pir tongwo hobi wiyol tau gaung bol olo dire, han tere, ");
INSERT INTO sll_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Pita yu ditongwi, “Ari wiyol ta gaung bol olekungwo hobi oo kepangwo ala i talongwo one? Talongwo homena ereho nene?” ");
INSERT INTO sll_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ena Pita wa i ongwo talhan u tibi ongwo hangwo meri ha di tibi ole yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na Yopa malgi molere, God ha di te moliba, molga bani ku haniwa. Hanga hamen bani gal apalapo bir weni dungwo meri a bigi holo hol sui sui dire angure mu sire ya na molga bani umua. ");
INSERT INTO sll_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ungure na ala i hanigere, dua hau, onba, hahoba miki weni mongwo haniwa. ");
INSERT INTO sll_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hanigere gala ta, ‘Pitao, ni hau hobi kene ole si no’ di na tomia. ");
INSERT INTO sll_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Di na tomba, na ‘God ye, na Yuda ari molia memini pangwo hau hobi gogo ta nekiga irawe’ dia. ");
INSERT INTO sll_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hamen bani gala ta ti hon dire, ‘Talhan hobi God nenana dire ol kuari pai ni tongwo iwe, ari nin mai tenanga paikimua,’ di na tomia. ");
INSERT INTO sll_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Talhan hobi gin sui tai dire u tibi ongwo hanigere ere hamen bani omua. ");
INSERT INTO sll_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ongure Sisaria hong yal ta yal su hobi bai nu sungure, gintani u na molga bani pa dimua. ");
INSERT INTO sll_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dungure God Kwiang ‘nomani su su sikirere, ya su hobi kina ereho po,’ di na tomia. Di na tongwo Sisaria nala di ogere, gamna hobo i ana hol pai muru hol pai taniga u na hongure aule ire oiwa. ");
INSERT INTO sll_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pi malgi pa digere yal Konilias ku hangwo meri boling kule yu di na tomia, Ensel ta oo ala ya ure yu di na tomia, yal tau bai nu si Yopa olingere, Saimon Pita aule ire unamia. ");
INSERT INTO sll_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Urere ha di ni tenangwo pire ni gaminahobi kina sigare kule u wai nanua. ");
INSERT INTO sll_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ena na Sisaria pire ha kebering hole di te molgere, God Kwiang ya ime ure nan yona wu bungwo mere irai yalhobi ere yu yong wu bimua. ");
INSERT INTO sll_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wu bungure pi tege eminga yal Yisas homa, ‘Yon nir wo bil ni tomba, God nin Kwiang ni tenangure inanua,’ dungwo irai hon nomani si piriwa. ");
INSERT INTO sll_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Homa na Yulang Hong Yisas Kraist pir tegere, God nin Kwiang na tongwo mere irai omaga tomia na God manaa di teralo? Yal digan molia ta diteralga paikimua,’ dungure yalhobi pirere homa ha di mere si tongwo i pisole, ");
INSERT INTO sll_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","God maa e tere yu dungwi, “God aki di tongure ari wiyol tau tal nigi dongwo ol wangwo pisole, nomani si kulu sire, sigare kule u wai ongwo pamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ena homa Stiben gongwo gin i, i kura bolimbani olungure, ari God pir tongwo hobi te u susu pire, tau Pinisia ke pangure, tau Saipras ke pangure, tau Antiok ke pai mongwi. Molere Yuda ari tani Yisas ol wai ol na tongwo ha maing boling kul pire pire mongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Momba, mongwo sina i tau Saipras yal tau ire, Sairini yal tau ire dire, Antiok malgi pire wiyol tau hana ya mongwo hobi Yulang Hong Yisas ol wai ol na tongwo ha maing di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dite wangwo gin iwe, singaba Yisas yulang tongure ire ware ditomia, ari miki weni Yisas pir tere wine ongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ena Yerusalem ari ha maing a i wangwo hobi tal ongwo ha i pirere, yal Banabas bai nu si Antiok malgi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Olimia pire hangure, God yalhobi tal wai ol tomia pi hanere, gun e tongwi. Tere, “Yulang Hong Yisas ha maing a i si monga meri molo” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ena yal Banabas iwe, amane dime di mongure God nin Kwiang yong wu bungure nimni mole ha maing ogolo weni yol e pir tongwi. Pir tongure ari miki weni ure Yulang Hong Yisas kebering ala i bengwi. ");
INSERT INTO sll_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bengure Banabas Sol harala dire Tasas malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pire Sol mongure aule ire Antiok ungwi. Ure yasuri malgi mole ha maing ari tabin hobi ha nir si te mongwo mongwo, me erin ta wai sungwi. Wai sungure Antiok malgi Yisas grang wine ongwo hobi para i mu dire haang Kristen engwi. ");
INSERT INTO sll_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ena habang gin i God hana togu yal tau Yerusalem aidolere, Antiok malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ongwo hobi yal ta Agabas ha diterala dire airungure God Kwiang yong wu bungure awa ha dire “Ganba uling holo holi i para weni menan bir u tibi namua,” ditongwi. Ditongwo meri yal bir Klodias kene ongwo haung u tibi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Awa ha i pirere, Antiok Yisas pir tongwo ari hobi moni iku bolere, “Yudia probins ari ha maing pungwo hobi tomingere homena bring si nere monamua” dire moni imu dire, “Ha maing oo kene ongwo yal hobi tenana po” dire, moni Banabas Sol kina tongwi. ");
INSERT INTO sll_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tongure yasuri ire Yudia pire ari ha maing pungwo hobi ebir si tongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ena habang gin iwe, singaba king Herot molere, Yisas pir tere ha maing pire mongwo hobi i kura ol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tere Yon abimbi Yems han sire di baina sire si gongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tal ongwo i Yuda ari wai han momia Herot hanere hon pire Pita han hongwi. Hongwo gin iwe, homena breti marasin yis ekirere plawa ya moni gal nere erin mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ena mongwo gin iwe, Pita han holere, halabusi oo ala olungwi. Olere soldia ana holo holo kebena hol pai muru hol pai taniga, yal sui sui dire kene ol molo ditongure, kene ol nigi de pungwo yal i ya mongure, yal sui sui dire hon mongwo yal i pi aibing maulung sire kene ongwi. Ongure Herot molere, pasoba erin i wai sinangwo irai Pita aule i pi Yuda ari maulung bani pire ha hol ol teralua di pungwi. Pire omaga Pita i pi hani oo ala olungure kene ol mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mongure Yisas pir tere ha maing pire mongwo hobi girungwo tangwo God Pita i mena ol na to dire, sirin bol tere tere mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ena erin wai simia Pita ha hol ol tenangwo habang mala weni ungure, girungwo soldia su bina holo holo mole Pita i sina olimia ul pangwi. Ena Pita iwe, kebering aling han waya si engure pai mongwi. Te soldia su u egereng molere, er kwi nu mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mongure sinamo kwia ensel ta u tibi engure oo ala i au dungwi. Dungure ensel Pita gaung a ho tere uling yure, “Haya airo” ditongwi. Ditongure kebering aling han waya i gintani nin gule ya manbi dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dungure ensel mole, “kun gang dere kebin to wayo” ditongwi. Ditongure Pita yu ongwi. Yu ongure ensel mole, “Ni hair gal ware namna wo” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ditere ere ongure, Pita doling bol ongwi. Omba pire, ku hani mo, ensel um mo, di pir gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dale pire honagrang ta soldia mongwo i wiyala pire, ta wiyla pire, maini aiyulang hoiri i nin si ola te wiyala ongure ere mena ongwi. Pire ere bangi ongure, ensel gintani u banta nangwo hol omia hankungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hankirere, Pita ari nomani si pire, “O, Yulang Hong yal Yisas ensel bai nu sungure, ure Herot aling bani molga i na gule olere, te Yuda ari tal ol na terala di pir mongwo i kuman kine na tongwo pamua,” di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pire ere pi Yon Mak aang al Maria oo kepangwo hona i ongwi. Ongure oo ala ari miki weni u ku bole God ha di te mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mongure Pita hoiri bani si giu giu dire, gala dungwi. Dungure, nir honagi ama Roda hoiri yaulala dire ungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Umba, ha dungwo Pita nugung pai dungwo pire hoiri aidole hon ala pire, “Pita wi dimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dimba, ari hobi mole, “ni du haure di mono” dungwi. Dimba, ama i yulang bole, “ha weni kara dia, yali u mongwo nugung pire diwa” dungwi. Dimba, ari hobi mole, “A, Pita gaing u mole dungwo pire dinua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dimba, Pita hoiri bani hon si giu dire gala dungure, ari hobi ure hoiri yaule hamba, Pita weni kara momia hanere bu kunungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ena Pita ala pire ari hobi “ha weni dikio” dire a tau si tere, Yulang Hong Yal tal ol tongwo ha i boling kul tongwi. Tere, “Na tal ol na tongwo ha i yal Yems ari Yisas pir tongwo hobi boling kul tenana po” ditere ere banta ongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ena honmil hamen tangure soldia hobi ganulun dire, “Pita molkimia, u makena ome?” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ena Herot Pita wa dumba, weniga hankungwi. Hankire soldia hobi “hankun ole molkino” dire ha hol ol tere ginangwo kene ol mongwo hobi si gongwi. Si golere Yudia probins aidolere pi Sisaria malgi pai mongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ena gin ta Herot Taia Saidon ari hobi nigi de pir tere kiang pai tongwi. Tongure ari hobi Herot yong a ura di terala dire u ku bongwi. Bolere pi Herot oong kene ongwo yal Blastas mongwo bani pirere ha di kunung olungwi. Ena Taia Saidon yalhobi ganbani bani homena ta bolkun olekimia, singaba king Herot ganba homena bring si nominiraya dire, yong a ura diterala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ena gin ta Herot nin kulung galing i sigiu dire, ami di mole, ari hobi gala di ku bolere, ha gobari weni ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ditongure ari hobi gala bir dire, “Ari ha dungwo meri ta dikimia, yal i ha maing ta bole dimia piro” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dungure Herot God pir tekire, haang a yuwo olekimia, Yulang Hong Yisas ensel bai nu sungure simia. Sungure onba migiga gaung bani bai nongure Herot gongwi. ");
INSERT INTO sll_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ena God ha maing yulang bolere, ganba ganba pai wa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ena Banabas Sol kina u Yerusalem mole ha maing honagi ol te wai sire, ere Antiok malgi ongwi. Ongure, yal Yon Mak haang su engwo yali doling bongure, kina ereho ongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ena Antiok malgi ari ha maing pire mongwo sina i tisa hana togu yal tau momia. Yalhobi iwe, haang Banabas ire, Simion Naisa haang su engwo yali ire, Sairini hong yal Lusias ire, nambawan gabman Herot gamahobo ta Meneyen ire, Sol ire dire, mongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Molere, gin ta Yulang Hong Yisas maa e tere, homena mai tere mongure, God nin Kwiang molere, “Sol Banabas kina na honagi onama dire han molia, i tibi olo,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ditongure ari hobi homena mai te molere, God ha di te mongwi. Molere yasuri aling bring bani are, nu si olungure ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ena God nin Kwiang yal Sol Banabas kina nu si olungure, ere Selusia malgi ongwi. Pire iri si sipi ala pire, pi nir mole ai hobing sina ol engwo haang Saipras ganba pire, u Salamis malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pa dire, Yuda ha maing oo ala pire, ha nir si tongwi. Tongure Yon Mak haang su engwo yali yasuri aki di tongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ena yalhobi nir mole ai hobing sina ol engwo bina hoibi Pepos malgi ongwi. Pire hangure, Yuda kumo gia ongwo yal Ba Yisas mongwo hangwi. Yal iwe, arihobi bal tere “Na God hana togu yal moliwa” di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Molere, nambawan gabman Sesias Polas e nongwo molere, yasuri kina pana gal mongwi. Ena Sesias Polas iwe, nomani wai pamia, God ha maing di na tenama dire, Sol Banabas yasuri wo ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ditongure ure ha dimba, kumo gia ongwo yal Ba Yisas molere, nambawan gabman yal ha maing yol e pirikinama dire, mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ditomba, God Kwiang Sol Pol yong wu bungure ire nimni mole, Ba Yisas teni han tongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Tere yu ditongwi, “Ni Seten wang monia. Ha maing wai weni dungwo i, yol e pirikinga pamia. Nomani nigi dongwo ya, te talhan nigi dongwo ni bona si ware, Yulang Hong Yisas hol wai ari bala ditongwo i, si pera ditenga pamia. ");
INSERT INTO sll_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tengiwe, Yulang Hong Yisas ni sinangure, omin gi dire hamen tanangwo hankire, habang tau sime tame gogo moli nanua.” Ditongure, Ba Yisas omeling si bongure, sime tame gogo molere, ari aling a i nama dire, wa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yu ol tongure, nambawan gabman hanere, Yisas yol e pir tongwi. Tere Yulang Hong Yisas ha maing dungwo i pire bukunungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ena Pol gamahobi kina Pepos malgi aidole, iri si sipi ala pire, Pampilia probins Pega malgi ongwi. Omba Yon Mak yalhobi aidole, ere Yerusalem ongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ena yalhobi Pega aidole, pi Pisidia probins Antiok malgi ongwi. Pi molere, Sabat haung ta Yuda ha maing oo ala pire, ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mongure, ha maing oo kene ongwo hobi Moses krehaman ha, hana togu yal ha di engwo i kerere, ungwo hobi yu ditongwi, “Gir hobo, nan yalhobi miling panaminga ha maing ta i unanga di tibi olo.” ");
INSERT INTO sll_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dungure Pol aire mole aling diri bole yu ditongwi, “Isrel ari te wiyol tau God maa e tenga hobi, pir molo. ");
INSERT INTO sll_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God nan kwiana moya Isrel ari hobi pare ere nu ke tongure, Isip ganba mole male siru dimua. ");
INSERT INTO sll_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Emgi God yulang bolere, aule umua. Ungure yalhobi ganba po engwo bani molere, tal gogo ol wangwo God hanere, me erin yal sutani kebering aling muru han uning solungure momua. ");
INSERT INTO sll_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mongure Kenan ganba ari wiyol ana hol pai muru hol pai sutani si gol wai sire, ganbani Isrel ari tomua. ");
INSERT INTO sll_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tongure Isrel ari me erin po handret pipti yia mol pamua. Mol pangure, singaba yas yalhobi Isrel ari kene ol tomua. Tongure moli pire, emgi yal Samyuel u tibi omia. Ongure Isrel ari singaba king na kene ol na tenama dire, God sirin bol tomua. ");
INSERT INTO sll_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bol tongure yol Bensamin yal Kis wang Sol i tibi olimua. Olungure singaba king Sol me erin yal sutani kebering aling muru Isrel ari hobi kene ol tomua. ");
INSERT INTO sll_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tongure God singaba king Sol aidolere, singaba Debit king monama dire, i tibi olimua. Olere God Debit hanere, ‘Na ha ditega hobi Debit wine omia, na nan ha dire tal olga meri omua,’ dimia. ");
INSERT INTO sll_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ena hongebe God Isrel arihobi aling kere ere, ‘singaba Debit gang ta u tibi pire, ni Isrel ari hobi aki di ni tenangure, sigare kunana dire nu si olalua,’ dungwo irai, Yisas ungwo haminua. ");
INSERT INTO sll_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","God maing i tibi olangwo haung mala ungure, hana togu yal Yon Isrel ari hobi tal nigi dongwo ol wangwo aidole, nomani si kulu sire hon olkirala di pire ware, nir binama dire ditomua. ");
INSERT INTO sll_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ditongwiwe, Yon honagi ol waga i wai sinama di pire, ari hobi yu ditomia, ‘Ni ari hobi na molga i talwa di pine? Yal ta unangwo kwi han monga irai, na ta molkiwa. Molkiba, na homa e teiya, yal i emgi unamia. Unangwo yal iwe, na gal kino di teralba digan moliwa,’ dimia. ");
INSERT INTO sll_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ena kwiana moya Ebraham gang ya, wiyol tau God pir tenga hobi, God aki di na tongure, nan sigare kule u wai naminga ha iwe, omaga nan mominga bani umua. ");
INSERT INTO sll_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ungure Yerusalem ari hobi ire, singaba hobi ire dire, Yisas aki di na tenangwo sigare kunamna di pinangwo, obilga u werigi dinangwo gumang hankiwa. Te Sabat haung haung God hana togu yalhobi awa ha di engwo i kerimba, memini pir po sikimua. Sikire Yisas si gongwo i, hana togu awa ha di engwo meri nima omua. ");
INSERT INTO sll_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ena yalhobi Yisas si golala dire ha hol omba, ha ta oun dekimia. Dekimba, gabman yal Pailat si golo ditomua. Yisas wa di pire awa ha muru di engwo meri irai, yalhobi Yisas ol tongure nima omua. ");
INSERT INTO sll_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ongure er pera bani si engwo gongure, i manbi olere, hulu grang ala i man wu emua. ");
INSERT INTO sll_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Emba, God nin uling yungure Yisas airimua. ");
INSERT INTO sll_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Airungure Galili yalhobi Yisas hol ire, Yerusalem ongwo hobi habang miki weni Yisas u tibi pire mol pangure hamua. Hanere moli pire hangwo yalhobi, Yisas airungwo ha mining aki dire, Isrel arihobi boling kul te momua. ");
INSERT INTO sll_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ena na yalhobi iwe, Yisas ol wai ol na tongwo ha maing boling kul ni tenamna dire uminua. ");
INSERT INTO sll_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ha maing iwe, God kwiana moya aling kere e tomia. Tongwo meri omaga Yisas gongwo uling yungure airungwo haminua. Haminga meri ul geral buku Sam namba tu mining yu bol emia, ");
INSERT INTO sll_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wana ye, kenba nabin molia, ni hani ayuwo oliwa. Ena awa ha di engwo meri, Yisas golere, hon airungwo God aki di tongure, gaung ta bil yakinamua. God awa ha i nomani si pire yu dimia, Na Debit ha wai weni di nima pire aling kere ega meri yu ol ni teralua. ");
INSERT INTO sll_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Te buku Sam ta yu pamia, God, haung sire amane dime dire mongwo yal i, kene ol tenangure, gaung i ta bil yakinamua. ");
INSERT INTO sll_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ena God honagi kwiana moya Debit aling bani engure, oli pire gongure, man wu engure gaung bil yamua. ");
INSERT INTO sll_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yamba yal ta gongure God uling yungure gaung bil yakimia airimua. ");
INSERT INTO sll_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ena hobo, nan tal nigi dongwo ol waminga God pring na tongwo i, Yisas imia, God na han uning si olimia. ");
INSERT INTO sll_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Olungwo ha i boling kul ni teiwa. Nan tal nigi dongwo ol waminga God pring na tongwo i, kwiana moya Moses krehaman ha kri di ole na tenangwo paikimba, ari Yisas grang wine ole pir tenaminga hobi pring pai na tongwo i, God kri di ole na tenangwo pamua. ");
INSERT INTO sll_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","God hana togu yalhobi awa ha yu di emia, ");
INSERT INTO sll_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ena God ha maing guma iger bole wa gol tenga hobi, tal ominga i hanere, ganulun dire golo. Ni monga bani tal ominga i yal ta boling kul ni tomba, pir tekinua. Ha di engwo meri iwe, ni yalhobi monga bani umia, han kun ole molo,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ena Pol Banabas kina ere maini ongure, arihobi Sabat haung ta ha ditongwo meri hon dinangwo pirala dire sirin bol pungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pirere ha maing oo aidole ere ongure, Yuda ari taporal ire, te wiyol tau Yuda ha maing pir tongwo hobi ire dire, Pol Banabas kina doling bol ongwi. Ongure aposel suri yalhobi God tal wai ol tomia, a i si ware monama dire yu di nima pi tongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ena Sabat haung ta oo malgi hobi para weni God ha maing pirala dire hon u ku bongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bongure Yuda ari hanere, nigi de pire Pol ha dungwo di gogo dale gaung ha si tongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Si tomba, Pol Banabas kina yasuri ha di tibi ole, “God ha maing homa di ni tongwo irai para pamba, ni yalhobi ha maing mobin hal wa tere, mol pai gobari ire mol pananga bani pananga ha pirikinua. Kingiwe, pisole na yalhobi Yuda ari pisole, wiyol tau mongwo hobi ha maing di tenaminua. ");
INSERT INTO sll_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","God krehaman yu di na tomia. “Kewa ganga meri hol i tibi ole, ari wiyol tau mongwo hobi tenanga, God aki di tenangure sigare kule u wai namua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ditomia wiyol hobi pirere, wai weni pire God yulang tere yong aura di tongure ha i wine ole pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tongure Yisas tal ol na tongwo ha maing i ganba bina holo holi wa dire kunung bengwi. ");
INSERT INTO sll_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bemba Yuda ari hobi pire oo malgi singaba hobi ire, wiyol al God pir tongwo hobi ire dire, kraung sungure Pol Banabas kina ere po dire, anu si mena olungwi. ");
INSERT INTO sll_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Olimba yalhobi han gogo dal tere ere Aikoniam malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ongure Yisas pir tere ha dungwo a i si wangwo hobi wai pire yong horega ongure God Kwiang yong wu bungure mongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ena Pol Banabas kina Antiok oo malgi tal ongwo meri Aikoniam malgi ereyu omia hangwi. Hangure yasuri Yuda ha maing oo ala pire, ha maing ditomia, Yuda Griki arihobi pirere, miki weni Yisas yol e pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tomba, Yuda ari tau Yisas yol e pir tekungwo hobi mole, ari wiyol tau hobi Yisas doling bongwo hobi siga wa tere aidolama dire, kraung sungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ena aposel suri ganba ire gobari molere, Yulang Hong Yisas ol wai ol na tongwo ha maing di tibi ol tongwi. Tongure Yulang Hong Yisas aki di tongure, tal guma hon dongwo nimni mongwo omia hane bukunere, “O, ha dungwo irai ha pangwo kara dungwo pamua” di pungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yu ongure malgi hobi ari si kra wara dire, tau Yuda pir tongure tau aposel hobi pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ena Yuda arihobi ire, wiyol tau hobi ire dire, aposel suri tal gogo ol tere hulu sirala dire ha hongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Homba, yasuri haya pir po sire, te ere Likionia probins pire, pi Lista Debi malgi pire, ganba bina holo holo i para wa mongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wa molere, Yisas ol wai ol na tongwo ha maing arihobi di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ena Listra malgi yal ta aang kungwo haung kebering pema kemia, moli pire ari mole hol wakima ami di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Molere Pol ha dungwo i pir tongwo. ");
INSERT INTO sll_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pir tongure Pol hanere, u wai nama dire, teni yulin bole hanere, ha erakere dire, “kebin egere gi dire airo” ditongwi. Ditongure kebering keber engwo yal i gintani iri sire aire hol wangwi. ");
INSERT INTO sll_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wamia Pol tal ongwo i ari miki weni hanere, nin Likionia howa yure, “Kwia hon u ari gobere pire nan mominga bani umia hano” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dire Banabas haang Seus momua dire, Pol ha di tibi olungwo yal i haang Hemis momia hano dungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dungure kwia Seus bling mining angwo yal pirere, kun bulamahau tau ire, er kuung miki we ire, Pol Banabas terala di ungwi. Ure kun bulamahau ta ari yuwo han molo dire, si terala dire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Omba, Pol Banabas gal pungwo a dina dire pi sina weni pire, gala dire, ");
INSERT INTO sll_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Na yasuri ari mobilia, kwia ta molkibilia, talongure kun i si na terala di one? Ni ari monga tali na yasuri ari mobilia. Yisas ol wai ol na tongwo ha maing di ni terabila dire ubilua. Ubilgiwe, kwia wa dire tal ol wanga i pisole, God tani nomani si pir tere, haang a yuwo olana dire ubilua. God hamen ya, ganba ya, nir ya, nan ari dua hau hobi para weni ol engwo dimia. ");
INSERT INTO sll_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","God hangure, ari homa malungwo hobi tal gogo nin nomani si pungwo meri ol wangwo hanere, han uning si olimia. ");
INSERT INTO sll_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Olimba, God nin arihobi na weni kara moma di pire, i tibi olere, tal wai ol na tomia. Tongure nimin sire, ari dere, homena u wai ongure, nere miina ongure, gun ere mominua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Direre aposel suri ha dimia yalhobi pirere, kun bulamahau si ke terala di ongure, aposel suri mana dimia, arihobi kina bolbin di di ole pisole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ena Pisidia probins Antiok te Aikoniam malgi Yuda ari tau u pa dire, arihobi kraung sungure, Pol hulu kuba sire, para gomia dire, aule i mena olungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Olimba, Yisas yol e pir tongwo hobi u yobilungure, Pol aire hon ere malgi ongwi. Pi pare, hamen tangure Banabas kina ere Debi malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ena Pol Banabas kina Yisas ol wai ol na tongwo ha maing di tibi olungure, ari miki weni Yisas pir tongwi. Tongure Pol Banabas kina hon siina di memini pire, Listra pire, Aikoniam pire, Pisidia probins Antiok malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pire Yisas yol e pire tongwo hobi ha maing ogolo weni a i si ware monama dire ha di nima pire ditongwi. Ditere, “God kene ongwo sina i nala di pinanga, ganba guliya galang talime kura gul bolimbani wa molere emgi inanua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ditere God ha maing Yisas pir tongwo hobi tau ebir sire, kene ol monama dire, pai olungwi. Olere homena mai tere, God ha ditere, “God ni yalhobi ni kene ol monamua” ditere ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ena yasuri ongwo, ongwo, Pisidia probins pire pi pi Pampilia distrikt pire, Pega malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pa dire ha maing nir si tere pare, wi ime pire, pi Atelia malgi pa dungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pa dire pare, sipi a ire ere memini pire, Antiok malgi pa dungwi. Ena Antiok malgi iwe, homa mongure, ari Yisas ha dungwo doling bole a i si wangwo hobi nu ke tere, ha maing di tenana po dire nu si olungwo malgi hon ungwi. ");
INSERT INTO sll_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Urere, ari u ku bongwo hobi, yasuri ha maing dite i ongwo ari wiyol tal ol tongwo meri ari boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ere habang gobari yasuri ari Yisas pir tere grang wine ongwo hobi kina pana gale mongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ena ari tau Yudia probins aidole ere Antiok malgi pa dungwi. Pa dire “Yal Moses krehaman ha memini pangwo yal gir gaung bol olekinangwo God aki di tekinangure sigare kule u wai honamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Dungure Pol Banabas yalhobi kina bolbin dungwi. Di di ole mongure arihobi hanere, “Bolbin dikio. Pol Banabas na gamnahobo tau kina para Yerusalem pire, aposel hobi ire, Yisas ha dungwo a i si ware ari kene ongwo hobi ire dire, mongwo bani pire, ha bolbin dinga i sirin bol pinana pio” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ditongure yalhobi pi Pinisia Sameria probins pire malgi hobi, “Wiyol tau Yisas grang wine ole yol e pir tomua” dite i omia, arihobi pire miling pamia gun ere mongure, aidole ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pire pi Yerusalem malgi pa dungure, Yisas grang wine ole ha maing pire mongwo hobi ire, aposel hobi ire, Yisas ha maing kene ongwo hobi ire dire, aya maya dire kewa dire mongwi. Mongure ungwo hobi God wiyol tau oo tabil tabil i tal ole aki di tongwo maing boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tomba, Perisi tau Yisas pir tere, Perisi nin pir tere, nomani su su sungwo hobi aire, “Yuda molkungwo hobi gaung bol olangwo i kunung panangwo te kwiana moya Moses krehaman ha wine onangwo i wai panamua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dungure aposel hobi ire, Yisas ha maing kene ongwo hobi ire dire, ha dungwo hobi nomani si pir mongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pir mongure, ari miki weni ha diriya ol mongure, Pita aire yu dungwi, “Enambi hobo, homa nan yalhobi mominga sina i God na nan na nu ke na tere tal ta ol na tomirawa. Tongure wiyol tau Yisas ol wai ol na tongwo ha maing kere di tega pire a i si wamirawa. ");
INSERT INTO sll_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God ari nomani si pungwo maing han po sire nin Kwiang nu sungure, nan Yuda ari iminga tali irai wiyol hobi para imua. ");
INSERT INTO sll_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nan Yuda ari momingere, wiyol tau hobi mongure dimba, God hanere, kunung kunung mona dimua. Dire yalhobi Yisas pir tomia, God hanere, tal nigi dongwo ol wangwo pring pangwo i, kri di ole tongure, wigi sire momua. ");
INSERT INTO sll_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","God ha dungwo i talongwo ha bane? Tal oun dongwo kwiana moya ol wangwo i paikimia, omaga Yisas pir tere grang wine ongwo hobi talongwo ol wanama dire di tene? ");
INSERT INTO sll_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Dinga paikimia, pisolo. Yulang Hong Yisas pirari pare tal nigi dongwo ol waminga pring pai na tongwo i tol di ingure nan sigare kule isine diminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dimia u ku bongwo hobi sime mongwi. Mongure Pol Banabas kina molere, “God tal nimni mongwo i ana bani engure wiyol hobi ol teiwa,” dire boling kul tongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Boling kul te pisolungure, yal Yems yu ditongwi, “Enambi hobi, na ha obilga dinaminga piro. ");
INSERT INTO sll_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon omaga molere, “God wiyol hobi mongwo sina i tau nu ke tere nan hana ayuwo olama dire imua” di na tomia. ");
INSERT INTO sll_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Di na tongwo meri hana togu yalhobo awa ha homa di engwo meri giu dire pamia. Ha mining i, yu bol emia, ");
INSERT INTO sll_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","God yu dimia, na hon siina dire, uralga yal Debit wang hobo mongwo paikungure emgi na hon a yo te teralgere u wai namua. ");
INSERT INTO sll_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nangwo meri wiyol tau pare ere nu ke tegere hana dal yuwo erala dire na wa dunamua. ");
INSERT INTO sll_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Hamen haya yuwo Yulang Hong yal awa ha dire di tibi ol emua. ");
INSERT INTO sll_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dire Yems hon ainere yu ditongwi, “dungwo meri iwe, na yu nomani si piria. Wiyol tau nomani si kulu sire God ha maing hol doling bole pir tongwo hobi honagi nega dire ta ol tenaminga paikimua. ");
INSERT INTO sll_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Paikimba, al ama wou sikio dire, te so gal bala hau ke tere nekio dire, te hau nugung a di dire algi i mena olekinangwo nekio dire, hau algi para nekio dire pasi yu bole tenaminua. ");
INSERT INTO sll_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwiana moya Moses krehaman ha bol engwo i, Sabat haung haung Yuda ha maing oo ala kere i ungwo te omaga oo hona hona i para ha maing di te i ongwo piminua.” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ena dimia aposel hobi ire, ha maing kene ongwo hobi ire, Yisas pir tere ha maing pungwo tabin hobi ire dire, ari tau Pol Banabas kina nu si Antiok olere, nu ke terala dire mongwi. Molere yong miling tongwo yalsu i tibi olungure yasuri ta haang Yuda Basabas, te ta Sailas i tibi ole ingwi. ");
INSERT INTO sll_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ire pasi yu dire bol tongwi, “Ena wiyol Antiok, Siria, Silisia ari ena hobo, ");
INSERT INTO sll_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Na gamnahobo yal tau ni monga bani pire ha oun dongwo gogo di ni tongwo i piminba, na bai nu si olekiminua. ");
INSERT INTO sll_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Dungwo pingiwe, na yalhobi u ku bole ha di tani ere yal tau bai nu si oleminia. Pol Banabas yasuri e nominga momia. ");
INSERT INTO sll_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yasuri nin gaung pir tekire, Yulang Hong Yisas Kraist honagi ol i pire ari gaung si gonangwo kul pir tekima. Ena nu si oliminga yal i Pol Banabas kina ereho namua. ");
INSERT INTO sll_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nu si oliminga yasuri haang Yudas Sailas yasuri pasi bol tominga pinanga meri boling kul ni tenamua. ");
INSERT INTO sll_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God Kwiang na yalhobi kina nomani tani sire krehaman ha sui dire obil di ni tominia. ");
INSERT INTO sll_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ta so gal bala hau ke tere nekio, ta hau algi nekio, ta hau nugung a di dire algi i mena olekinangwo nekio, ta al ama wou sikio. Yu obil di ni tominia a i si wananga wai panamua. Para, we. Na aposel hobi ire, te ha maing kene ominga hobi ire dire, obil mole bol ni tominua.” ");
INSERT INTO sll_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ena nu si olungwo yasuri pasi ire, Antiok malgi pire, Yisas pir tongwo hobi gala dimia, u ku bongure, pasi tongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tongure kere ha i pire wai weni pungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ena Yudas ire, Sailas ire dire, God hana togu yal momia ha maing miki weni nir si tere aki di tomia wai pungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yasuri haung tau mol pai ongure Yisas pir tongwo hobi hon ere nama dire nu si memini olere erepo ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Tomba Sailas ereho nangwo ha pirikire bani ya mongwi.) ");
INSERT INTO sll_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ena Pol Banabas ari miki weni kina Antiok mole Yulang Hong Yisas ha maing nir si te mongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ena haung ta molere Pol Banabas yu ditongwi, “Nan yasu Yulang Hong Yisas ha maing oo tabil tabil i nir si te i pire Yisas pir tongwo hobi molpai onangwo maing hanamna wo” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ditongure Banabas yal Yon Mak haang su engwo yal i aule ire nala dipungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pimba Pol mole, “Homa Yon Mak ha maing honagi olere, Pampilia ai pisole siina di memini omiraya, omaga aidole naminua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dungure Banabas kina bolbin dire yasuri u kwaling nin nin ongwi. Ongure Banabas aule ire ere sipi ala pire pi Saipras malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ongure grang wine ongwo hobi God yalhobi kene ol tenama dire nu si olungwi. Olungure Pol Sailas aule ire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pi Siria probins Silisia probins pire Yisas pir tere ha maing pire mongwo hobi aki di tongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ena Pol pi Debi malgi pire, pi Listra malgi pa dungwi. Pa dungure Yisas pir tere grang wine ongwo yal ta Timoti mongwi. Timoti iwe, aang Yuda al mole Yisas pir tongure, irang Griki yal mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra Aikoniam malgi ari Yisas pir tere tabin tani mongwo hobi Timoti haang ayuwo olungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ol mongure Pol Timoti aule ire nala dire, gaung bol ole tongwi. Gaung bol olungwiwe, Yuda ari para muru hanere, yal i irang Griki yal moma di hamiraya, gaung bol olungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Olere ere pire oo hona hona i pire, Yerusalem Yisas ha maing kene ongwo hobi ire, aposel ire dire, “krehaman ha di tongwo irai, di tibi ole a i si wayo” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ditomia arihobi ha i a i si ware Yisas pir tere ha maing pungwo tabin hobi nima ongure haung ta yal tau ure Yisas pir tongure haung ta yal tau ure Yisas pir tongure, u tabin bir weni ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ena Pol gamahobi kina pi Prisia Galesia probins ongwi. Pirere Esia probins pire, ha maing di tenamba, God Kwiang mana di tongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Di tomia aidole Misia probins ganba gumiling aidole Bitinia nala dire omba, Yisas Kwiang mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ditongure Misia ganba pire, wi ime pire pi Troas ai ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pi pare Pol ginangwo ku hangure, Masedonia hong yal ure, “Ni na oona Masedonia probins ure, aki di na tenana wo” dimia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol ku hangwo meri, Yisas ol wai ol na tongwo ha maing Masedonia ganba namna dire, talhan gintani akun ole momingi. ");
INSERT INTO sll_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ena na gina hobi Troas aidole, sipi ala pire, iri si pil nir bina hoibi Samotres malgi pi pa dimingi. Dire paminga, hamen tangure Niapolis malgi pi pa dimingi. ");
INSERT INTO sll_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pa dire aidole, pi Masedonia ganba yol Roman ganba diming hon i tibi ole kepangwo malgi Pilipai pire momingi. ");
INSERT INTO sll_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Momingiwe, haung sutani pare mominga, Sabat habang u tibi ongure, ara te mena pire nir nulu bina momingi. Mominga gin iwe, Yuda ari tau God kina ha wai ole ole mom mo, maing hanamna dire omingi. Omingere agr tau u ku bongure, ami di mole ha maing ditomingi. ");
INSERT INTO sll_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ditominga alhobi iwe, ta haang Lidia, Taiataira kul nongwo al molere, gal nobu homilgi tongure ari bring sungwi. Sungwo al iwe, God grang wine olere maa e tere tere mongwi. Mongure haung gin i Yulang Hong Yisas Kwiang ure, yong aura ditongure Pol ha maing dungwo pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pir tongure ening abing hobo para nir bil tongwi. Tongure al i na gina hobi ha ura pangwo di na tere, “Na Yisas wine ole pir tongwo al moma di hananga na oona malgi namna wo” di na tongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ena di na te mongwo mongwo na yalhobi kina omingi. Ena habang ta God kina ha wai ol mongwo bani ominga nir honagi ama ta kwia nigi dongwo yong sina mongure, amilgi sire so gale tal yu onamua, yu onamua, dire dire mongwi. Mongure honagi ol tongwo yal i ama grang bani kwi ole tobo nin ire ire ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ama iwe, Pol na gina hobi kina dolna bole pire, gala dire, “Ayo, yalhobi hamen singaba God honagi ari momia hano. Mongwo hobi iwe, ha dinangwo pire sigare kule u wai nanua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ena gala i hamen girungwo tangwo di mongwo bani mongwi. Mongure Pol nigi de pire iina dire kwia nigi dongwo, “Yisas Kraist grang bani di ni teya. Ama i aidole ere mena po,” ditongwi. Ditongure kwia gintani ama i aidole ere mena ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ongure ama hong yal i moni hon ta i na tenangwo paikimia dire, Pol Sailas kina a i si mole han holere, aule piru di ire, ha hol pire u ku bole bole ongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pire yol Roman gabman yalhobi mongwo bani ongwi, “Yasuri Yuda yal momia. Nan oona malgi ure si honere ol go danangwo pamue. ");
INSERT INTO sll_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yasuri ha dungwo iwe, nan krehaman ha ya ime simia. Sungwo i paikimia. Nan yol Roman mominia, yasuri ha dungwo i ogolo a i wanaminga paikimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dungure ari tabin bir molere, yasuri kiang pai tere, ha hol pungwo yal homa galsina gule ole, “kuba so” ditomia sungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sire aule pire pia si halabusi oo ala olungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Olere, woda “ogolo weni kene ol molo” ditomia, aule ire ala pire, oo ala wai weni ire olere, kebering er tibi albe ere bli nil si daulungure pai mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pai molere ginangwo sinamo Pol Sailas kina God ha ditere, ul geral ditongwi. Ditongure halabusi pai mongwo hobi pir mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mongure ememe bir gintani ure oo ya torari hobi a hoha tomia, hoiri hobi nin yaule tongure, halabusi pangwo hobi kebering aling ayulang han sungwo hobi nin kirime ole ya manbi dungure, ya mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mongure halabusi oo kene ongwo yali aire hoiri yaulungwo hanere, halabusi pangwo hobi para mena omua di pire, di baina golau yaulungwo aki di ire nin wi sire golala di ongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Omba, Pol gala bir dire, “Na yalhobi para mominia, ni yu olkio,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ditongure halabusi oo kene onwo yali “kewa galo” dimia gangure ire bli si ala pire gaung nungure, Pol Sailas kina mongwo kebering bani ikwi bole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Molere Pol Sailas kina aule ire mena pire, “Yahuno, God aki di na tenangwo sigare kulalga tal ole kulale?” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Ni Yulang Hong Yisas grang wine ole pir tenanga aki di ni tenangure ebin hobi kina sigare kule u wai nanga pamua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ditere yasuri Yisas ha maing yali boling kul tere, yali ening abing hobi nir si tomia pungwi. Ena haung gin i girungwo sinamo halabusi kene ongwo yali Pol Sailas kina aule ire pire, kuba sungwo bongwo bani bigi si tongwi. Tongure Pol Sailas kina halabusi kene ongwo yal gamahobi nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tongure yal i Pol Sailas kina aule ire malgi pire homena si gal tongwi. Tere God yol e pir tomia ening gamahobi kina wai pire gun ere mongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ena hamen tangure yol Roman gabman yalhobi polisman nu si olere, “Halabusi pangwo yasuri gule mena olo”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ditomia olungure halabusi kene ongwo yal i mole, “Yol Roman gabman hobi ni Sailas kina ere po di ni tomia ere po”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ditomba, Pol mole polisman yu ditongwi, “Na tal nigi dongwo tal olalga pring pai na tekimba, Roman gabman hobi ari mongwo maulung bani kuba na simia. Sungwiwe, na Roman ari molkimno? Momingiwe. Ena yalhobi kul si na aule i mena olangwo paikimia. Roman gabman hobi nin ure na yasuri aule i mena olangwo pamue,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dungure Pol ha dungwo meri polisman Roman gabman hobi boling kul tongwi. Tongure “Yasuri Roman yal mongwo pamua” dire ganulun dire kul bir pungwi. ");
INSERT INTO sll_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pirere Pol Sailas kina mongwobani pire, ha ura pangwo dire, “Na tal ol ni tominga i paikimia, nigi de pir na tekire na oona malgi aidole ere po” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ditongure Pol Sailas kina halabusi oo aidole, ere pi al Lidia oo kepangwo malgi ongwi. Pire Yisas pir tongwo hobi mongwo gumang hanere, “Kul pirekire nima sire mole, ha maing a i si molo,” ditere ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ena Pol ire, Sailas ire, Timoti ire, ya su hobi Ampipolis malgi pire aidole, ere pi Apolonia malgi pire aidole, ere pi Tesalonaika malgi ongwi. Ongwo malgi iwe, Yuda ha maing oo dimia. ");
INSERT INTO sll_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Homa ongwo meri Pol hon Sabat haung sui tai dire ha maing oo ala i pire, ha maing buku kere ha bolbin diriya ol mongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Molere God honagi onama dire nu ke tongwo yal Kraist gaung gul ire gongure, God nin uling yungure, hon airungwo ha i, ha maing buku kere memini di tibi ol tongwi, “Yal Yisas haang dal tibi ol ni tega iwe, singaba Kraist momua”, ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ditongure ari tau Pol Sailas kina ha pangwo dimua dire, pir tongure, yol Griki yal ari tabin bir God pir tere maa e tongwo hobi ire, al singaba hobi ire dire, para yu pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pir tomia Yuda ari hanere Pol Sailas kina nigi de pir tongwi. Tere galing talime ari digan hobi di ku bongwi. Bongure arihobi blo tolo di pirere, Pol Sailas kina a i si monamna dire Yeson oo kepangwo hoiri di polo dungwi. ");
INSERT INTO sll_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Dire hamba, yasuri molkimia hanere, Yeson ire, Yisas pir tongwo yal tau ire dire, aule i pire gabman tongwi. Terere, yu ditongwi, “Yalhobi oo hona hona i pire tal gogo ol wamia. ");
INSERT INTO sll_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kenba nan oona malgi umia. Ungure yal Yeson aule i oo kepangwo ala pire pana gal mole homena tomia hano. Yalhobi singaba king Sisa krehaman ha i susu ole, singaba king ta haang Yisas momia. Yisas tani wine ol to dimua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dungure arihobi pire ganulun dire blo tolo di mongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mongure gabman hobi Yeson gamahobi kina ha hol ol tere moni pai tongure, i ole ere mena ongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ena ari Yisas pir tongwo hobi ginangwo Pol Sailas kina bai nu si Beria malgi olungwi. Olungure pi pa dire, ere pi Yuda ha maing oo ala ongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ena Yuda ari Beria malgi mongwo hobi iwe, ari nomani wai pangwo mone mongwi. Tesalonaika malgi ari mongwo meri ta molkima. Arihobi Pol ha maing nir si tongwo pire bukunere, hamen girungwo tangwo Pol hasu dim mo, ha wo dim mo, dire, ha maing buku kere kere mongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Molere Yuda ari miki weni ire, Griki al singaba miki weni ire, Griki yal tau ire dire, Yisas haang a i ware pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yuda ari Tesalonaika kepangwo hobi mole pungure, Pol Beria malgi pire, God ha maing nir si tomua dungwo pungwi. Pirere pi Beria malgi pire, Beria yalhobi ha maing i nigi domia pirikio ditongure, Beria yalhobi nomani si gogo dangwi. ");
INSERT INTO sll_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dangure Yisas pir tongwo arihobi Pol bai nu si nir digan bina olungwi. Olimba, Sailas Timoti kina Beria malgi ya mol pangwi. ");
INSERT INTO sll_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ena arihobi Pol aule i i Atens malgi pire, iina dire ere pi Beria ongwi. Pirere Timoti Sailas kina “Pol haya wo dimia po” ditongure, yasuri ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ena Pol Atens malgi mole Sailas Timoti kina unangwo kwi han mongwi. Mole hamba, Atens malgi oo tabil tabil i gal bala hulu miki weni yong ba ere pir tomia hanere, nigi de hangwi. ");
INSERT INTO sll_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hanere Yuda ha maing oo ala pirere, Yuda ari ire, yol Griki God pir tongwo hobi ire dire, bolbin dungwi. Dire haung haung oo malgi sina u ku bongwo hobi ere yu bolbin mone dire dire mongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mongure Epikurian ha maing nir si tongwo hobi ire, Stoik ha maing nir si tongwo hobi ire dire, Pol kina bolbin dungwi. Ena Pol Yisas ol wai ol na tere gole hon airungwo ha i di tibi ol tongwi. Tomia pire tau mole, “ha miling paikungwo di wangwo yal i memini talmere pame?” dungwi. Te tau mole, “Ari wiyol kumo gia pir tongwo irai, di tibi ol tomia hano,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dungure Pol aule i pi Ariopagas kaunsil mongwo bani olungwi. Olungure kaunsil hobi yu ditongwi, “Ni arihobi ha hon nir si tengarai omaga memini di tibi olanga pinaminua. ");
INSERT INTO sll_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ha ta nir si tengarai memini oun domia, ni nin maing di tibi olingere pir po sinaminua.” ");
INSERT INTO sll_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yu dungwiwe, Atens malgi arihobi wiyol tau ha maing hon ire sina sina ure dungwo hobi wai piriwa muru di mongwi. Molere ha bling taniga a i si pirkima. ");
INSERT INTO sll_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ena Ariopagas kaunsil mongwo maulung bani Pol aire yu ditongwi, “Atens yalhobo, ni yalhobi ha maing bling taniga a i si pirikinia, ha ta ta gogo hoba nir olungwo meri pinga haniwa. ");
INSERT INTO sll_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Homa na ni yalhobi oon hona hona i ware hanega, bling mining oo miki weni dungure, kun si ke tenga oo tau dungure haniwa. Hanga oo ta ala i ha mining ganing ta yu bol enia, “Kwia ta haang pirekiminga yal bol kul tominua” dire mining bol enia. Kwia haang pirikirere, ya moni ha maing ditenga yal i haang dal tibi ol ni teralia. ");
INSERT INTO sll_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yal iwe, haang God momia. Molere hamen ganba ol erere, talhan hobi para weni ol emua. Ena God iwe, hamen ganba hong yal momua. Mole yal tau ha maing oo taniga kengwo ala i ta molkimia. Kenba ari haung tani iwe, banta banta ganba uling holo holo i para weni momua. ");
INSERT INTO sll_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Te yal i tal ta wa dunangure, nan ari ana bani tal ta i tenaminga paikimia. Yal i nin grang miing tongure, talhan hobi para weni nin u tibi pire pai omia, tal ta na to dire hong dinamo? I ta dikinamia. ");
INSERT INTO sll_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","God kwiana moya tani weniga ol emba, emgi moli ongwo ongwo, wiyol para weni male siru dire, ganba uling holo holo i para kunung bemua. Hamen haya yali nin nu ke tere wiyol hobi poing paing sire ganba bli bol tomia. ");
INSERT INTO sll_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God yu ongwiwe, nan arihobi omeling si bongwo meri molere, God hanamna dire a a ei pirere hanamin mo? God ulubi ta molkimia nan mominga mala weni momua. ");
INSERT INTO sll_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“God molkima nan yalhobi hol ware molkimingere.” Te ni yalhobi ul geral hong yal ta mole geral yu dinia, “nan yalhobi God gang giring mominua.” ");
INSERT INTO sll_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Momingiwe, kwahulu nol, pege, so gal bala hulu ol eminga hobi para God haang pangwo meri pamo? I ta paikimia. Nan ari nomani si piminga meri ol eminua. ");
INSERT INTO sll_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Homa nan arihobi God molkima di pinga habang i God na sinamba, na han uning si olimia. Olimba, omaga God ari ganba ganba i tal nigi dongwo onga aidole, nomani si kulu sire, na pir na tenamua, dungwo haung mominia. ");
INSERT INTO sll_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","God iwe, yal ta yulang tere nu ke tere ba enangwo haung ta werigi dinangwo gin i, yal i nan ganba ari para weni ha hol bir ol na tenangwo God nin haung ba engwo pamia. Nu ke tongwo yal iwe, omaga moli pire gongure God uling yumia hon airungwo nan arihobi hanere o, nu ke tongwo han dungwo irai yal i mongwo pamua di haminua,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ena Pol yal ta gole hon airimua dungwo iwe, arihobi tau wa gol tomba, tau mole, “hon dinanga piralua” dungwi. Dungure Pol mongwo bani pisole ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ari obilga Pol pana gal tere Yisas pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tongwo yal ta Ariopagas kaunsil yal Daionisias mongure, al ta Damaris mongure, te ari tau para mole pir tongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ena Pol Atens malgi aidole ere pi Korin malgi ongwi. Pi molere Yuda yal Akwila momia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yal Akwila iwe, Pontus hong yal mongwi. Homa singaba Sisa Klodias yol Yuda Rom malgi kepangwo hobi ere po ditomia, Akwila eungbi Prisila kina Itali ganba aidole, ere Korin malgi ungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","U mongure, Pol pi yal al su mongwo bani pi pana gal molere honagi bling tani are olere, gal oo kerala dire warungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ware molere, Sabat haung haung Pol Yuda ha maing oo ala pire pire, Yuda ari tau Yisas pir tenama dire, wara wara kere di te mongwo bani mongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ena haung ta Sailas Timoti kina Masedonia aidole, u Pol mongwo bani pa dungwi. Pa dungure Pol girungwo tangwo Yuda arihobi “Yisas singaba Kraist momua” di tere tere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ongure Yuda arihobi pir tekirere, Pol gaung ha sire mongwi. Momia Pol hanere gumang iger bol tere, “Hamen hol wai nanga na di ni tominba pirikinia. Hol nigi dongwo nala di pinanga nin hani pamia, na hana ta paikimia pio. Na iwe, Yuda ari pisole, ari wiyol tau di terala dire oiwa,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dire yalhobi pisole, wiyol God maa e tongwo yal Tisias Yastas oong malgi keparala dire ongwi. Ongwo malgi iwe, Yuda ha maing oo mala weni dungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ena Yuda ha maing oo singaba Krispas mongwi. Krispas iwe, irang aang ya, te wang aung hobi kina Yulang Hong Yisas haang a i si ware pir tongwi. Tongure Korin ari miki weni Pol ha maing dungwo pirere Yisas haang a i ware pir tomia hanere nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ena girungwo ta Pol ku hangure Yulang Hong Yisas yu ditongwi, ");
INSERT INTO sll_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“Na ni kina si daule mobilia ni kul pirkire na guna hana wai boleng kul tere tere mining bolo molo. Yal ta tal gogo ol ni tere ni sinangwo paikimia, malgi i na gamnahobi miki weni momia aki di ni tenamua.” ");
INSERT INTO sll_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yu ditomia Pol wai pire me erin ta muru molere, ta i mala olere, ari hobi God ha maing hon nir si tongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ena yol Roman Griki ganba kene ol mongwo haung Griki ganba bani namba wan gabman Galio mongwi. Mongure Yuda ari u ku bolere, Pol ha hol ol terala dire, aule ire nambawan gabman mongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Pirere, “Arihobi God pir tere maa e tomba, yal iwe, ha maing hol ta bala dungure na Yuda ha maing ya ime simua,” ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ditomia Pol ha dinamba, yal Galio aire, yal i talime onangwo ha oun denangwo ha dinga hobi na yol e piralba, ");
INSERT INTO sll_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","nin ha te nin krehaman ha bolbin dingiwe, nin hani pamia, ere pio. Na yal i ha hol ol teralga paikungwo yawe.” ");
INSERT INTO sll_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dire anu si maini olungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Olungure arihobi nigi de pire Yuda ha maing oo singaba Sostenis a i sire opisi malgi simba, gabman yal Galio hanere, han uning si olungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ena Pol Korin malgi habang gobari mongure Yisas pir tongwo hobi pana gal tomia molere, molo ditere, al Prisila ire, yal Akwila ire dire, kina ereho Siria ganba nala di pire sipi ala ongwi. Omba homa Senkria malgi mole, God maulung bani ha di yulang bole breng eme bai olungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Olere ere pi Epesas malgi pa dire, yasuri ai di timi ole, Pol nin Yuda ha maing oo ala pirere, Yuda arihobi kina ha diriya ol mongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mongure Yuda arihobi Pol timiya tau mole nanua dimba, Pol arihobi ha dungwo pir tekima. ");
INSERT INTO sll_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Ere nalua” ditere, “God na hon ere memini po di na tenangwo ere uralua” ditongwi. Ditere Epesas malgi aidole iri si sipi ala pire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pi Sisaria malgi pire aidole pi Yerusalem malgi pire, Yisas pir tere ha maing pire mongwo hobi “moldinio” ditere ere Antiok malgi ongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ena pire habang gobari tau mole Antiok aidole ere ongwi. Pirere, Galesia Prisia probins oo tabil tabil i wa i pire, ari Yisas ha dungwo doling bole a i si wangwo hobi monangwo maing harala dire aki di te i pire ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ena Yuda Aleksandria hong yal ta Epesas malgi pi pa dungwi. Pa dungwo yal iwe, haang Apolos ha dungwo nugung don kengwo yal momia, God ha maing buku para weni kere pir po sungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sire Yulang Hong Yisas ol wai ol na tongwo ha maing nir si tomia para pir tongwi. Pir tere ha maing nega dire arihobi nir si tere, Yisas tal ongwo meri dime weni dire boling kul tongwi. Tomba tere yal Yon nir bil tongwo i tani hangwi. ");
INSERT INTO sll_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Hanere Yuda ha maing oo ala i Yisas ha maing nimni mole nir si tongwi. Tomia al Prisila iwe, yal Akwila kina pirere, na oona malgi namna wo dire, aule i pire God ha maing hol tau nibil ditomia memini para weni pir po sungwi. ");
INSERT INTO sll_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pir po sire ere pi Griki ganba nala di ongwi. Ongure Epesas malgi hong yal tau Yisas pir tere grang wine ongwo hobi pasi ta bolere, “Yal i unangwo pana gal to,” dire nu si olungwi. Olungure Apolos pi pa dire hangure God pirari pare to bir hole i ure pule a siribi sungure arihobi pir tomia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Hanere ha maing ditere aki di tongwi. “Ena God bai nu si olangwo yal Kraist unamua dire kwi han monga irai, omaga Yisas ungwo haminua” dire, Yuda arihobi kina bolbin dungure, Apolos ha maing buku kere ha dungwo mo yu ongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ena yal Apolos Korin malgi mol pangure, Pol mo hamen hul pire pi Epesas malgi pa dungwi. Pa dire hangure Yisas pir tere grang wine ongwo hobi tau momia hangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Hanere, “Yisas haang a i si ware pir tenga gin i God Kwiang ino?” dungwi. “God Kwiang moma di na tekimua”, dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Nir bil ni tongwo irai talwa pine?” dungwi. “Yal Yon ha maing dungwo pire a i si wamingere nir bil na tomua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","“Arihobi tal nigi dongwo ol wangwo aidole nomani si kulu sire hon olkirala di pire wangure yal Yon nir bil tere, ‘Isrel yalhobo na homa eminia yal ta emgi unamia pir to’ dimia. Unangwo yal iwe, Yisas momua” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Dungure yalhobi Yisas haang pire a i wangure, nir bil tongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bil tongure Pol yalhobi God Kwiang inama dire breng bani a tau sungure ingwi. ");
INSERT INTO sll_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Irere wiyol howa yure God ha ditongwi. Ditongwo hobi ana holo holo kebena sutani moma di haniwa. ");
INSERT INTO sll_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ena Pol Yuda ha maing oo pire nimni mole haba sui tai dire, God kene ongwo holi ware doling bonama dire, yulang bole di tibi ol tongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tomba, ari tau omeling pege dire, ari u ku bongwo maulung bani Yisas pir tenangwo hol i mana dire hobang tani si tongwi. Tomia Pol yalhobi mongwo bani aidole, Yisas pir tere grang wine ongwo hobi aule ire kina ereho ongwi. Pi molere nir si tongwo yal Tiranas ari u ku bonama dire, oo kengwo ala i haung haung pi molere, Pol arihobi kina ha maing diriya ole pir mongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mongwiwe, me erin sutani Esia ganba ol mongure, Yuda ari Griki ari hobi kina ha maing dungwo pungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ena God yulang Pol tongure Pol tal guma hon dongwo maing maing omia arihobi hangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ena yalhobi Pol pir pan kli dungwo gal ire, honagi gal wangwo i ire dire, a i pire, ari nibil pangwo mongwo bani guung mulungure, nibil i wai simio, te kwia nigi dongwo yong sina mongwo hobi si doling i mena olungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Olimia hanere Yuda ari tau kwia nigi dongwo si doling i ole wangwo hobi Yisas haang dalere kwia si doling i olala dire wangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ware kwia nigi dongwo yu ditongwi, “Pol Yisas haang dangwo meri daminia ere mena po.” Ditongwo hobi iwe, Yuda ha maing oo ya singaba bir haang Siba wang hobo ana hol pai muru hol pai sutani molere yu ol wangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wamba, kwia yu ditongwi, “Yisas wa dire Pol wa dire dinga piminba, ni yalhobi ara mone?” ");
INSERT INTO sll_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dungure kwia nigi dongwo yong sina mongwo yal i ure yalhobi sire galsina trausisi gule olungure oo ke pangwo malgi aidole te ongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Omia Epesas malgi Yuda ari Griki arihobi para weni hanere, kul bir pire, Yisas haang a yuwo olungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yisas ha dungwo doling bongwo ari tau ure homa ha kuria marega dire a i wangwo hobi di tibi olungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ena gia ongwo yal tau gia ongwo buku i ure ari mongwo maulung bani endo gangwi. Gia ongwo buku gangwo hobi tobo bir pipti tausen kina bonangwo meri bongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Bomia yu ol pisolere, Yulang Hong Yisas tal ol na tongwo ha maing nimni mole ganba ganba i ditongure, wa dire pai ongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ena yu ol wai sungure, God Kwiang Pol yong wu bungure, Pol Masedonia ganba pire aidole, pi Griki ganba pire aidole Yerusalem nala di ongwi. Pi molere, “emgi Rom malgi pi haralue” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Direre Pol aki di tongwo ya su Timoti Erastas bai nu si Masedonia olungwi. Olere Pol nin Esia probins haung tau mol pangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ena haung i Epesas malgi arihobi Yulang Hong Yisas ha maing di banta po dire tolo wa tongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tongure malgi hong yal Dimitrias aiyulang mining ganing ongwo yal mongwi. Molere aiyulang ire, ari yong ba ere “al kwia Atemis momua”, dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dungure arihobi ure honagi ol tere tobo bir ingwi. Ingure gin ta yal Dimitrias honagi ol tongwo arihobi di ku bolere yu ditongwi, “Yalhobo, nan honagi ominga tobo imna di haminia. ");
INSERT INTO sll_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Haminba, Pol digan i ure aiyulang mining ganing ole yong bai eminga i kwia molkimia, hulu ya moni dimua dimia. dungwo ipire, Esia probins arihobi ire, te Epesas malgi arihobi ire dire, miki weni pir tomue. ");
INSERT INTO sll_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nan yong ba ere kwia momua dire honagi ominga i, pir na tekinangwo pamia, tobo makena inamne? Tobo iminga tamamia, kwia al Atemis oo ke tominga i arihobi mobing ha wa tenangure mokene kulkinangwo pamia tal onamne? Omaga arihobi para weni kwia al i maa e tomia hankino? Emgi maa e tenangwo yal ara moname? Ta molkinamue”. ");
INSERT INTO sll_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Dungure u ku bongwo hobi yong ki ere gala bir dire, “Kwia al singaba Atemis Epesas malgi yal haang kara mokene kumue,” dungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Yu dungure arihobi gala auli ware u howa dungwi. Direre huhu e i pire Masedonia yalsu Gaias Aristakas Pol kina ereho ungwo yasuri aule ire bli si pi ai pene u ku bongwo bani ongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ongure Pol para pi ari mongwo maulung bani airalua di pimba, Yisas pir tere grang wine ongwo hobi mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ena Esia kaunsil tau Pol yoling yal momia, ari maulung bani airikinama dire bai nu si olimia pire mana ditongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ena uku bongwo hobi nomani sala mala ole ha gogo gogo dire tau ha ta dungwi, tau ha ta dungwi. Yu di molere yal ta ha dungwo mining ogolo pirikere talongwo huhu emne dipungwi. ");
INSERT INTO sll_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ena Yuda arihobi Aleksanda anu si sina olimia arihobi hanere, ayo yali sihonere ol go danangwo pamia di hangwi. ");
INSERT INTO sll_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Hangure Aleksanda aling hol wai ere ha ta dirala di omba, arihobi Yuda ari momia di hanere, hon u howa ditere grang u tani pire, “Kwia al singaba Atemis Epesas malgi ya haang kara mokene kumue” dire, gobari weni di di ole mongwi. ");
INSERT INTO sll_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ena emgi Epesas kaunsil president aire mole arihobi ha dikire pir molo ditere yu dungwi, “Epesas yalhobo, nan oona malgi kwia al singaba Atemis oo ke tominga irai dimia, te breng mining isra hulu hamen bani ya ime ungwo irai dimia. ");
INSERT INTO sll_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yal ta ure, i ta dikungwo hasu dinua di na tenangwo paikimia. Ni yalhobi sime molere tal gogo ol tenanga paikimia. ");
INSERT INTO sll_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Yal su aule i ungiwe, ya mone aule ire unia. Yasuri breng mining oo ala pire tal ta kuni nekimio, te kwia al i gaung ha ta sikimia. ");
INSERT INTO sll_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yal Dimitrias honagi arihobi kina yal ta ha hol ol terala di pinangwo i, ha hol ba enangwo haung ta pire gabman mongwo bani pire ha di mere si tere ha hol ol tenangwo pamia. ");
INSERT INTO sll_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Malgi ha ta panangwo iwe, ari singaba hobi u ku bol mole pinangwo pamia. ");
INSERT INTO sll_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kenba tal ominga i, polisman ure ni yalhobi si honere ol go dal inua di na tenangwo pamua. Yu di na tenangwo nan talwa di tenamne? Tal gogo ominia, nan yalhobi mining bolo ere namna pano” ");
INSERT INTO sll_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ditomia ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ena Epesas arihobi u howa di pisolungure, Pol Yisas pir tere grang wine ongwo hobi di ku bole nimni monama dire krehaman tere, “Ni timi molo. Na ere Masedonia ominua” ditere ere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pi oo tabil tabil i Yisas pir tongwo hobi Yisas ol wai ol na tongwo ha maing di tere krehaman ha di tere tere ongwi. ");
INSERT INTO sll_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pi Griki ganba molere haba sui tai dire si gongwi. Si golere P