﻿USE sofia;
DROP TABLE IF EXISTS sofia.slk_vpl;
CREATE TABLE slk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES slk_vpl WRITE;
INSERT INTO slk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Toto je záznam rodokmeňa Ježiša Krista, syna Dávidovho a syna Abrahámovho. ");
INSERT INTO slk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahám mal syna Izáka, Izák Jákoba, Jákob Júdu a jeho bratov, ");
INSERT INTO slk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júda splodil Faresa a Zára (ich matkou bola Tamara), Fares mal syna Hezrona a ten Arama, ");
INSERT INTO slk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mal syna Aminadaba, ten mal syna Násona a Náson mal syna Salmona, ");
INSERT INTO slk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon mal s Rachabou syna Boaza, Boaz mal s Rút syna Obeda a ten mal syna Jesseho, ");
INSERT INTO slk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse bol otcom Dávida, ktorý sa stal kráľom Izraela, Dávid splodil s Uriášovou manželkou Šalamúna, ");
INSERT INTO slk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Šalamún splodil Roboáma, Roboám Abiu, Abia Azafa, ");
INSERT INTO slk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azaf bol otcom Jozafata, Jozafat otcom Joráma a Jorám bol otcom Oziáša, ");
INSERT INTO slk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziáš splodil Joatama, Joatam Achaza, Achaz Ezechiáša, ");
INSERT INTO slk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezechiáš mal syna Manasesa, Manases mal syna Amosa a ten bol otcom Joziáša, ");
INSERT INTO slk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joziáš bol otcom Jechoniáša a jeho bratov (v čase odvlečenia do Babylonu). ");
INSERT INTO slk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Po babylonskom zajatí splodil Jekoniáš Salatiela a Salatiel Zorobábela, ");
INSERT INTO slk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobábel mal syna Abiúda, Abiúd Eliakima a Eliakim Azora, ");
INSERT INTO slk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mal syna Sádoka, ten syna Achima a Achim syna Eliúda, ");
INSERT INTO slk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúd splodil Eleazara, ten mal syna Mátana a Mátan mal syna Jákoba. ");
INSERT INTO slk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jákob bol otcom Jozefa, ktorý bol mužom Márie, matky Ježiša, nazývaného Kristus. ");
INSERT INTO slk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Od Abraháma po Dávida to teda bolo štrnásť generácií, ďalších štrnásť generácií od Dávida po babylonské zajatie a od zajatia v Babylone až po Krista zasa štrnásť. ");
INSERT INTO slk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","S narodením Ježiša Krista to bolo takto: Jeho matka Mária bola zasnúbená s Jozefom. No ešte skôr než sa vzali, vysvitlo, že počala z moci Ducha Svätého. ");
INSERT INTO slk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jozef bol muž prísnych zásad, preto sa rozhodol, že sa s ňou rozíde. Chcel to však urobiť v tajnosti, aby ju nevystavil verejnej potupe. ");
INSERT INTO slk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Keď o tom uvažoval, vo sne sa mu zjavil Pánov anjel a povedal: „Jozef, syn Dávidov, neboj sa prijať Máriu za svoju ženu, lebo dieťa, ktoré čaká, pochádza z Ducha Svätého. ");
INSERT INTO slk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Narodí sa jej syn a dáš mu meno Ježiš, lebo on vyslobodí svoj ľud z jeho hriechov. ");
INSERT INTO slk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Takto sa naplnilo všetko, čo Boh hovoril prostredníctvom proroka: ");
INSERT INTO slk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‚Počujte, panna otehotnie, porodí syna a dajú mu meno Emanuel,‘ čo znamená: Boh je s nami.“ ");
INSERT INTO slk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Keď sa Jozef prebudil, urobil tak, ako mu Pánov anjel prikázal a prijal Máriu za svoju ženu. ");
INSERT INTO slk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ale intímne spolu nežili, kým sa jej nenarodil syn, ktorému dal meno Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ježiš sa narodil v meste Betlehem v Judsku za vlády kráľa Herodesa. V tom čase prišli do Jeruzalema mudrci z východných krajín ");
INSERT INTO slk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a vypytovali sa: „Kde je ten židovský kráľ, ktorý sa práve narodil? Videli sme na východe jeho hviezdu a prišli sme sa mu pokloniť.“ ");
INSERT INTO slk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Keď sa to dozvedel kráľ Herodes, veľmi sa znepokojil a spolu s ním aj všetci obyvatelia Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes zvolal všetkých veľkňazov a učiteľov Zákona a vyzvedal sa od nich, kde sa má Mesiáš narodiť. ");
INSERT INTO slk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Odpovedali mu: „V Betleheme, v Judsku, lebo prorok napísal: ");
INSERT INTO slk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‚Betlehem, nie si najbezvýznamnejší medzi judskými mestami, lebo z teba vyjde vodca, ktorý sa bude starať o môj ľud, Izrael, ako pastier o ovce.‘ “ ");
INSERT INTO slk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes si tajne pozval mudrcov z východu a podrobne sa ich vypytoval, kedy sa im hviezda po prvý raz zjavila. ");
INSERT INTO slk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Poslal ich do Betlehema s takouto úlohou: „Choďte a dôkladne zistite všetko o tom dieťati, a keď ho nájdete, príďte mi to oznámiť, aby som sa mu mohol ísť pokloniť aj ja.“ ");
INSERT INTO slk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mudrci si kráľa vypočuli a vydali sa na cestu. A hviezda sa im znova zjavila a viedla ich, až zastala nad miestom, kde bolo dieťa. ");
INSERT INTO slk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Keď uvideli hviezdu, náramne sa potešili. ");
INSERT INTO slk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vošli do domu a našli tam dieťa s jeho matkou Máriou. Padli pred ním na kolená a klaňali sa mu ako kráľovi. Potom mu obetovali prinesené dary – zlato, kadidlo a drahocenný olej. ");
INSERT INTO slk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Vo sne ich však Boh varoval, aby sa nevracali k Herodesovi. Do svojej krajiny sa teda pobrali inou cestou. ");
INSERT INTO slk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Po ich odchode sa Jozefovi vo sne zjavil anjel Pánov a prikázal mu: „Vstaň, vezmi dieťa i jeho matku, uteč s nimi do Egypta a zostaň tam, kým ti nepoviem. Herodes bude totiž pátrať po dieťati, aby ho zabil.“ ");
INSERT INTO slk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jozef hneď v noci vzal dieťa i jeho matku a vybral sa s nimi do Egypta. ");
INSERT INTO slk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tam boli až do smrti kráľa Herodesa. Tak sa splnilo, čo povedal Pán ústami proroka: „Z Egypta som povolal svojho syna.“ ");
INSERT INTO slk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Keď Herodes zistil, že ho mudrci podviedli, vzbĺkol hnevom. Do Betlehema i jeho okolia poslal vojakov a dal povraždiť všetkých chlapcov do dvoch rokov – tento vek vyrátal podľa údajov, čo sa dozvedel od mudrcov. ");
INSERT INTO slk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vtedy sa akoby znova naplnili slová proroka Jeremiáša: ");
INSERT INTO slk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„V meste Ráma počuť nárek, plač a kvílenie. To Ráchel oplakáva svoje deti a nemožno ju potešiť, lebo ich niet.“ ");
INSERT INTO slk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Keď Herodes zomrel, Jozefovi sa v Egypte znova ukázal vo sne Pánov anjel ");
INSERT INTO slk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a povedal mu: „Vezmi dieťa i jeho matku a vráť sa do izraelskej krajiny, lebo už zomreli tí, čo chceli dieťa zabiť.“ ");
INSERT INTO slk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jozef poslúchol a vrátil sa spolu s dieťatkom a jeho matkou do izraelskej krajiny. ");
INSERT INTO slk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Veľmi sa však zľakol, keď sa dozvedel, že Herodesovým nástupcom v Judsku je jeho syn Archelaus. Vo sne dostal ďalší pokyn od Boha, aby šiel do Galiley. ");
INSERT INTO slk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Usadil sa v Nazarete, čím sa naplnili slová prorokov o Mesiášovi, že ho ľudia budú poznať ako: „Toho z Nazareta.“ ");
INSERT INTO slk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","V tom čase vystúpil Ján Krstiteľ a kázal ľuďom, ktorí prichádzali za ním na judskú púšť: ");
INSERT INTO slk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","„Prestaňte hrešiť a obráťte sa k Bohu, lebo prichádza nebeské kráľovstvo.“ ");
INSERT INTO slk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","To je ten, o ktorom hovoril prorok Izaiáš: „Na púšti volá hlas: Pripravte cestu Pánovi a odstráňte z nej všetky prekážky.“ ");
INSERT INTO slk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ján nosil odev z ťavej srsti, prepásaný koženým opaskom. Živil sa tým, čo poskytovala púšť: kobylkami a medom divých včiel. ");
INSERT INTO slk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Schádzali sa k nemu ľudia z Jeruzalema, z celého Judska i z krajov okolo Jordánu. ");
INSERT INTO slk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dávali sa krstiť v rieke Jordán, a tým verejne vyznávali svoje hriechy. ");
INSERT INTO slk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Keď však Ján videl, že sa prichádzajú krstiť aj mnohí farizeji a saduceji – povedal im: „Vy hadie plemeno! Prečo si myslíte, že takto môžete uniknúť pred Božím hnevom? ");
INSERT INTO slk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dokážte svojím životom, že ste sa odvrátili od vlastných hriechov. ");
INSERT INTO slk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nemyslite si, že sa vám nemôže nič stať len preto, že si vravíte ‚Sme potomkovia Abraháma.‘ Neklamte samých seba! Veď Boh môže aj tieto kamene oživiť a urobiť z nich Abrahámove deti. ");
INSERT INTO slk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sekera Božieho súdu je už priložená ku koreňom stromov. Každý strom, ktorý neprináša dobré ovocie, bude vyťatý a hodený do ohňa. ");
INSERT INTO slk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja krstím vodou tých, ktorí ľutujú svoje previnenia a vyznávajú ich. Ale po mne príde niekto omnoho väčší ako ja, ktorému nie som hodný ani len obuv vyzuť. On vás bude krstiť Svätým Duchom a ohňom. ");
INSERT INTO slk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","On prečistí zrno, zbaví ho pliev, pšenicu zhromaždí do sýpky, ale plevy spáli v neuhasiteľnom ohni.“ ");
INSERT INTO slk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vtedy prišiel Ježiš z Galiley k Jordánu za Jánom, aby sa dal od neho pokrstiť. ");
INSERT INTO slk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ján sa mu v tom však snažil zabrániť: „Ty by si mal pokrstiť mňa! Prečo prichádzaš, aby som pokrstil ja teba?“ ");
INSERT INTO slk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","No Ježiš mu odpovedal: „Len to urob, lebo musíme vykonať všetko, čo Boh žiada.“ A tak ho Ján pokrstil. ");
INSERT INTO slk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hneď, ako po krste Ježiš vystúpil z vody, otvorilo sa nebo a uvidel Božieho Ducha, ktorý akoby holubica zostupoval na neho. ");
INSERT INTO slk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Zároveň zaznel z neba hlas: „Toto je môj Syn. Milujem ho a to, čo robí, ma napĺňa radosťou!“ ");
INSERT INTO slk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Potom Duch Boží viedol Ježiša na púšť, aby ho tam diabol pokúšal. ");
INSERT INTO slk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Po tom, ako sa Ježiš postil štyridsať dní a nocí, veľmi vyhladol. ");
INSERT INTO slk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tu sa k nemu priblížil pokušiteľ a povedal mu: „Ak si naozaj Boží Syn, prikáž týmto kameňom, aby sa premenili na chleby!“ ");
INSERT INTO slk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ale Ježiš mu odpovedal: „Je napísané: Na to, aby človek žil, nepotrebuje len jedlo, ale aj slová, ktoré vychádzajú z Božích úst.“ ");
INSERT INTO slk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Potom ho diabol zaviedol do Jeruzalema na vežu chrámu ");
INSERT INTO slk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a povedal: „Ak si Boží Syn, zoskoč dolu! Veď je napísané: Boh prikáže svojim anjelom, aby ťa ochránili, a ponesú ťa na rukách, aby si si neporanil nohy o kameň.“ ");
INSERT INTO slk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ježiš mu zasa odpovedal: „Ale je napísané aj toto: Nebudeš pokúšať Boha, je tvojím Pánom!“ ");
INSERT INTO slk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Napokon ho diabol vyviedol na veľmi vysoký vrch a ukázal mu všetky kráľovstvá sveta s ich bohatstvom a slávou. ");
INSERT INTO slk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tam mu povedal: „Toto všetko ti dám, ak predo mnou padneš na kolená a vzdáš mi úctu!“ ");
INSERT INTO slk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ježiš mu odpovedal: „Strať sa mi z očí, pokušiteľ! Lebo je napísané: Pána, svojho Boha budeš uctievať a iba jemu budeš slúžiť!“ ");
INSERT INTO slk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","V tej chvíli ho diabol opustil. Ježiša obklopili anjeli a starali sa o neho. ");
INSERT INTO slk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Keď sa Ježiš dopočul, že Ján je vo väzení, vrátil sa do Galiley. ");
INSERT INTO slk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nezostal však v Nazarete, ale usadil sa v Kafarnaume. To mesto ležalo na brehu Genezaretského jazera, v oblasti, ktorú kedysi obývali izraelské kmene Zabulon a Neftalí. ");
INSERT INTO slk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Takto sa splnila predpoveď proroka Izaiáša: ");
INSERT INTO slk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„V krajine Zabulonovej a Neftalího, na ceste k moru, za Jordánom, Galilea pohanov – ");
INSERT INTO slk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ľud ponorený do temnoty uzrie veľké svetlo. Svetlo zažiari tým, ktorí žijú v krajine tieňa smrti.“ ");
INSERT INTO slk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Odvtedy začal Ježiš kázať: „Zmeňte svoje zmýšľanie a obráťte sa k Bohu, lebo nebeské kráľovstvo je blízko.“ ");
INSERT INTO slk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jedného dňa šiel Ježiš po brehu Galilejského mora a zazrel dvoch mužov, ako do vody hádžu siete. Boli to rybári Šimon, neskôr nazývaný Peter, a jeho brat Andrej. ");
INSERT INTO slk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ježiš na nich zavolal: „Poďte za mnou a ja vám ukážem, ako získavať ľudí pre večnosť!“ ");
INSERT INTO slk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Obaja hneď opustili siete a šli za ním. ");
INSERT INTO slk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O kúsok ďalej iní dvaja bratia, Jakub a Ján, spolu so svojím otcom Zebedejom opravovali v loďke siete. Aj ich zavolal. ");
INSERT INTO slk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A obaja razom zanechali svoju loďku i otca a pobrali sa za Ježišom. ");
INSERT INTO slk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ježiš chodil po celej Galilei, učil v synagógach, hlásal všade radostnú zvesť o Božom kráľovstve a zbavoval trpiacich všetkých možných chorôb a neduhov. ");
INSERT INTO slk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Správy o ňom sa rýchlo rozniesli až po provinciu Sýria. Vodili k nemu chorých, ľudí posadnutých démonmi, pomätencov, ochrnutých – a on ich uzdravoval. ");
INSERT INTO slk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Všade za ním putovalo množstvo ľudí nielen z Galiley, ale aj z Desaťmestia, Jeruzalema, Judska i zo Zajordánska. ");
INSERT INTO slk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jedného dňa, keď Ježiš videl dav ľudí, vystúpil na vrch a keď si sadol, pristúpili k nemu jeho učeníci. ");
INSERT INTO slk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ježiš ich začal učiť: ");
INSERT INTO slk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Šťastní sú tí, ktorí si uvedomujú svoju potrebu Boha, lebo tým patrí kráľovstvo nebeské. ");
INSERT INTO slk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Šťastní sú tí, ktorí plačú, lebo Boh ich poteší. ");
INSERT INTO slk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Šťastní sú tichí, lebo oni sa stanú dedičmi zeme. ");
INSERT INTO slk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Šťastní sú tí, ktorí túžia po spravodlivosti ako smädní po vode a hladní po jedle, lebo oni budú nasýtení. ");
INSERT INTO slk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Šťastní sú milosrdní, lebo aj Boh bude k nim milosrdný. ");
INSERT INTO slk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Šťastní sú tí, ktorí majú čisté srdce, lebo oni uvidia Boha. ");
INSERT INTO slk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Šťastní sú tí, ktorí šíria pokoj, lebo tých Boh nazve svojimi deťmi. ");
INSERT INTO slk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Šťastní sú tí, ktorých prenasledujú preto, že poslúchajú Boha, lebo im patrí nebeské kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Šťastní ste, ak vás hania, prenasledujú a očierňujú preto, že sa hlásite ku mne. ");
INSERT INTO slk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Áno, máte dôvod radovať sa a jasať, lebo v nebi máte veľkú odmenu. Napokon, rovnako prenasledovali aj prorokov, ktorí žili pred vami.“ ");
INSERT INTO slk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","„Vy ste soľ zeme. No ak soľ stratí svoju chuť, čo jej ju vráti? Taká soľ sa už nedá použiť na nič, možno ju iba vyhodiť, aby ju ľudia pošliapali. ");
INSERT INTO slk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vy ste svetlo sveta. Ste ako mesto postavené na kopci, nemôže sa schovať. ");
INSERT INTO slk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ani lampu nerozsvietite na to, aby ste ju schovali, ale dáte ju na viditeľné miesto, aby svietila každému v dome. ");
INSERT INTO slk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nech tak svieti vaše svetlo všetkým ľuďom, aby videli dobro, ktoré konáte, a oslavovali za to vášho Otca v nebesiach.“ ");
INSERT INTO slk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","„Nemyslite si, že som prišiel zrušiť Zákon alebo Prorokov. Neprišiel som to zrušiť, ale naplniť. ");
INSERT INTO slk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","S úplnou vážnosťou vám hovorím, kým trvá nebo a zem, ani písmenko, ani čiarka zo Zákona nestratí platnosť, kým sa všetko nenaplní. ");
INSERT INTO slk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Keby teda niekto zrušil čo i len jedno z týchto prikázaní, hoci to najmenšie, a učil by tomu aj iných, bude sa nazývať v nebeskom kráľovstve najmenším. Kto však rešpektuje Božie prikázania a učí tak aj iných, toho Boh označí za veľkého v nebeskom kráľovstve. ");
INSERT INTO slk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hovorím: Ak vaša spravodlivosť nebude väčšia ako spravodlivosť učiteľov Zákona a farizejov, určite nevstúpite do nebeského kráľovstva. ");
INSERT INTO slk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Viete, že vašim predkom bolo povedané: ‚Nezabiješ!‘ Preto, kto zabije, musí ísť pred súd. ");
INSERT INTO slk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ale ja vám hovorím: Súdený bude každý, kto sa hnevá na iného človeka; a kto iného ponižuje, odsúdi ho najvyšší súd, no kto mu zlorečí, zaslúži si pekelný oheň. ");
INSERT INTO slk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ak prinášaš na oltár svoj dar, aby si ho obetoval Bohu, no uvedomíš si, že tvoj brat má niečo proti tebe, ");
INSERT INTO slk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nechaj tam svoj dar, choď za svojím bratom a zmier sa s ním. Až potom obetuj svoj dar. ");
INSERT INTO slk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ak máš so svojím protivníkom spor a chce ťa obžalovať, usiluj sa s ním zmieriť už cestou. Inak ťa zavlečie k sudcovi, sudca ťa vydá dozorcovi a ten ťa uvrhne do väzenia. ");
INSERT INTO slk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A nevyjdeš odtiaľ skôr, kým nesplatíš svoj trest do posledného haliera. ");
INSERT INTO slk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Viete, že vašim predkom bolo povedané: ‚Nebudeš cudzoložiť.‘ ");
INSERT INTO slk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ale ja vám hovorím: každý, kto žiadostivo pozerá na ženu, už s ňou scudzoložil vo svojom srdci. ");
INSERT INTO slk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ak ťa teda zvádza pravé oko, vylúpni si ho a zahoď; lebo je pre teba lepšie, ak prídeš o jednu časť tela, ako by malo celé tvoje telo prísť do pekla. ");
INSERT INTO slk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ak ťa navádza na hriech pravá ruka, odsekni si ju a odhoď od seba. Lepšie je, ak prídeš o jednu časť tela, ako sa dostať do večnej záhuby.“ ");
INSERT INTO slk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","„Bolo tiež povedané: ‚Kto by sa chcel rozviesť so svojou ženou, nech jej dá rozvodový list.‘ ");
INSERT INTO slk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ale ja vám hovorím: každý, kto sa rozvedie so ženou – okrem prípadu smilstva – vystaví ju cudzoložstvu, a kto sa ožení s rozvedenou, dopúšťa sa cudzoložstva. ");
INSERT INTO slk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ďalej ste počuli, že bolo vašim predkom povedané: ‚Nebudeš krivo prisahať, ale splníš, čo si Pánovi pod prísahou sľúbil.‘ ");
INSERT INTO slk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ale ja vám hovorím: neprisahajte vôbec; ani na nebo, lebo je Božím trónom, ");
INSERT INTO slk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ani na zem, lebo je jeho podnožou, ani na Jeruzalem, lebo je mestom veľkého Kráľa. ");
INSERT INTO slk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neprisahajte ani na svoju hlavu, lebo nie je vo vašej moci, aby vám čo i len jeden vlas narástol biely alebo čierny. ");
INSERT INTO slk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vaša reč nech je jednoznačná – áno nech znamená áno, nie nech znamená nie. Ak k tomu niečo pridávate, pochádza to od zlého.“ ");
INSERT INTO slk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","„Počuli ste, že bolo povedané: ‚Oko za oko, zub za zub.‘ ");
INSERT INTO slk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ale ja vám hovorím: neodplácajte zlo zlým. Naopak, ak ťa niekto udrie po pravom líci, nastav mu aj ľavé. ");
INSERT INTO slk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A ak by sa chcel niekto s tebou súdiť a vziať ti košeľu, daj mu aj kabát. ");
INSERT INTO slk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A ak ťa niekto poprosí, aby si mu odniesol bremeno na kúsku cesty, zanes mu ho dva razy tak ďaleko. ");
INSERT INTO slk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tomu, kto ťa o niečo prosí, daj, a kto si chce od teba požičať, tomu neodmietni. ");
INSERT INTO slk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Počuli ste, že bolo povedané: ‚Miluj svojho blížneho a nenáviď svojho nepriateľa.‘ ");
INSERT INTO slk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ale ja vám hovorím: milujte svojich nepriateľov! Modlite sa za tých, ktorí vás prenasledujú. ");
INSERT INTO slk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Takto budete konať ako deti nebeského Otca. On spôsobuje, aby slnko svietilo na dobrých aj na zlých, a zosiela dážď na spravodlivých aj na nespravodlivých. ");
INSERT INTO slk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aké uznanie by ste chceli za to, že prejavujete lásku iba tým, ktorí vás milujú? Nerobia vari to isté aj vyberači daní? ");
INSERT INTO slk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ak sa správate priateľsky iba k svojim blízkym, ste vari v niečom výnimoční? Nerobia tak azda aj pohania? ");
INSERT INTO slk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Buďte teda dokonalí v láske, ako je dokonalý aj váš nebeský Otec.“ ");
INSERT INTO slk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","„Dávajte si pozor, aby ste skutky svojej spravodlivosti nevystavovali na obdiv pred ľuďmi, lebo tým sa pripravíte o odmenu od svojho Otca v nebesiach. ");
INSERT INTO slk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Preto keď dávaš núdznemu, nevytrubuj o tom všetkým na známosť. Okato – v synagógach a na námestiach – konajú dobro pokrytci, lebo túžia, aby ich ľudia chválili. Naozaj, vravím vám: oni už svoju odmenu dostali. ");
INSERT INTO slk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ak ty niekomu pomáhaš, rob to nenápadne – nech tvoja ľavá ruka nevie, čo robí pravá. ");
INSERT INTO slk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A tvoj Otec, ktorý vidí aj skryté veci, ti to odplatí.“ ");
INSERT INTO slk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","„Keď sa modlíte, nebuďte ako pokrytci, ktorí sa radi modlievajú v synagógach a na námestiach, aby ich ľudia videli. Naozaj, vravím vám: oni už svoju odmenu dostali. ");
INSERT INTO slk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ale keď sa chceš modliť, choď do svojej izbičky, zavri za sebou dvere a modli sa k svojmu Otcovi, ktorého nevidieť. A tvoj Otec, ktorý vidí aj to, čo je skryté, ťa vypočuje. ");
INSERT INTO slk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Neopakujte bezmyšlienkovito modlitbu ako ľudia, ktorí Boha nepoznajú. Myslia si, že ich Boh vypočuje, keď budú svoju prosbu donekonečna omieľať. ");
INSERT INTO slk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nenapodobňujte ich, veď váš Otec pozná vaše potreby skôr, než ich vyslovíte.“ ");
INSERT INTO slk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","„Vy sa modlite takýmto spôsobom: Otče náš, ktorý si na nebesiach, nech je vzdaná úcta a česť tvojmu menu. ");
INSERT INTO slk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nech príde tvoje kráľovstvo. Nech sa tvoja vôľa deje ako v nebi, tak i na zemi. ");
INSERT INTO slk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dávaj nám chlieb na každý deň. ");
INSERT INTO slk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A odpusť nám naše viny, ako i my odpúšťame každému, kto sa previňuje voči nám. ");
INSERT INTO slk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A nedovoľ, aby sme podľahli pokušeniu, ale pomáhaj nám vyhýbať sa zlému. (Lebo tvoje je kráľovstvo, i moc, i sláva naveky. Amen.) ");
INSERT INTO slk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ak odpustíte iným ich previnenia, aj vám odpustí váš nebeský Otec. ");
INSERT INTO slk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ale ak im neodpustíte, potom ani nebeský Otec neodpustí vaše previnenia.“ ");
INSERT INTO slk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","„A keď sa postíte, netvárte sa utrápene. A nech to nie je poznať ani na vašom zovňajšku, ako to robia pokrytci, ktorí takto upozorňujú svoje okolie, že sa postia. Naozaj vám hovorím: oni už svoju odmenu dostali. ");
INSERT INTO slk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ale keď sa ty postíš, pekne sa uprav a buď prirodzený, ");
INSERT INTO slk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pretože nie ľudia majú vidieť, že sa postíš, ale tvoj Otec, ktorého nikto nevidí. A tvoj Otec, ktorý vidí aj skryté veci, ti to odplatí.“ ");
INSERT INTO slk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","„Nehromaďte si bohatstvo na zemi, kde rýchlo stráca svoju hodnotu alebo ho môžu ukradnúť zlodeji. ");
INSERT INTO slk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ukladajte si radšej poklady v nebi, kde ich nezničia ani mole, ani hrdza, ani ich neukradne nijaký zlodej. ");
INSERT INTO slk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lebo kde je váš poklad, tam bude aj vaše srdce. ");
INSERT INTO slk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Oči sú ako lampa, ktorá dáva svetlo. Ak je tvoje oko čisté, tvoj život bude naplnený svetlom. ");
INSERT INTO slk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ale ak je tvoje oko zakalené nečistými myšlienkami a túžbami, si ponorený do temnoty. Ak to, čo by malo byť pre teba svetlom, je tmou, aká potom bude skutočná tma?“ ");
INSERT INTO slk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","„Nikto nemôže slúžiť dvom pánom. Jedného totiž bude nenávidieť a druhého mať rád, alebo jednému bude dávať prednosť a druhého bude zanedbávať. Nedá sa slúžiť zároveň Bohu aj majetku. ");
INSERT INTO slk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Preto vám radím: netrápte sa o to, čo budete jesť a piť, aby ste žili, ani o to, do čoho zaodejete svoje telo. Či nie je život viac ako jedlo a telo viac ako šaty? ");
INSERT INTO slk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pozrite sa na vtáky: nesejú ani nežnú, nezhromažďujú obilie do sýpok, a predsa ich nebeský Otec živí. Či nie ste omnoho cennejší ako ony? ");
INSERT INTO slk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Je medzi vami niekto, kto by si vlastnou snahou vedel čo i len o kúsok predĺžiť svoj život? ");
INSERT INTO slk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A prečo sa tak veľmi trápite s oblečením? Uvažujte o poľných kvetoch: nepracujú, nepradú, ");
INSERT INTO slk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","a predsa ani Šalamún vo svojom kráľovskom majestáte nebol oblečený tak ako hociktorý z nich. ");
INSERT INTO slk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ak teda Boh zaodieva do takej nádhery obyčajné poľné kvietky, ktoré dnes hýria farbami a zajtra zhoria v ohni, nepostará sa skôr o vás? To mu tak málo dôverujete? ");
INSERT INTO slk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Preto sa netrápte a nespytujte: Čo budeme jesť? Čo budeme piť? Čo si oblečieme? ");
INSERT INTO slk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ľudia, ktorí nepoznajú Boha, sami seba znepokojujú takýmito otázkami a trápia sa pre ne. Ale vy máte nebeského Otca, a ten dobre vie, čo potrebujete. ");
INSERT INTO slk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hľadajte najprv Božie kráľovstvo a jeho spravodlivosť a všetko toto vám bude pridané. ");
INSERT INTO slk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Netrápte sa teda o každú maličkosť, ktorú prinesie zajtrajšok, lebo každý deň má dosť svojich starostí a Boh vám s nimi pomôže aj zajtra.“ ");
INSERT INTO slk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","„Nesúďte iných, aby ste neboli súdení. ");
INSERT INTO slk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lebo spôsobom, akým súdite druhých, budete súdení aj vy. Akou mierou meriate, takou bude Boh merať vás. ");
INSERT INTO slk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Prečo sa staráš o smietku v oku svojho blížneho, ale brvno vo vlastnom oku si si nevšimol? ");
INSERT INTO slk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ako môžeš povedať inému: Dovoľ, aby som ti vybral z oka smietku!, a pritom ti neprekáža brvno vo vlastnom oku? ");
INSERT INTO slk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ty pokrytec! Najprv odstráň brvno zo svojho oka, lebo až potom budeš dobre vidieť, aby si mohol vybrať smietku z oka svojho blížneho. ");
INSERT INTO slk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Je zbytočné vysvetľovať Božie pravdy tým, ktorí nimi pohŕdajú. Nehádžte perly sviniam! Čo sa stane? Perly pošliapu a vás napadnú.“ ");
INSERT INTO slk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","„Proste a dostanete, hľadajte a nájdete, klopte a otvorí sa vám. ");
INSERT INTO slk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lebo kto prosí, dostane, kto hľadá, nájde a kto klope, tomu otvoria. ");
INSERT INTO slk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Keby ktoréhokoľvek z vás poprosilo vlastné dieťa o kus chleba, dali by ste mu snáď kameň? ");
INSERT INTO slk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Alebo by ste mu namiesto ryby dali hada? ");
INSERT INTO slk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ak teda vy, hoci ste hriešni, viete dávať svojim deťom dobré veci, o čo skôr ich dá nebeský Otec tým, ktorí ho o to prosia! ");
INSERT INTO slk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Správajte sa k ľuďom tak, ako chcete, aby sa oni správali k vám. To je to, čo hovorí Zákon i Proroci.“ ");
INSERT INTO slk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","„Do neba sa dá vojsť iba úzkou bránou. Priestranná brána a široká cesta vedú do záhuby, a predsa si ju vyberá a kráča po nej mnoho ľudí. ");
INSERT INTO slk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Dvere a cesta do života sú úzke a len málo je tých, ktorí ich nájdu.“ ");
INSERT INTO slk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","„Dajte si pozor na falošných prorokov: prichádzajú k vám preoblečení za bezbranné ovce, ale v skutočnosti sú to draví vlci. ");
INSERT INTO slk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Môžete ich spoznať podľa ovocia, ktoré nesú. Azda sa oberá hrozno z tŕnia a figy z bodľačia? ");
INSERT INTO slk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Dobrý strom rodí dobré ovocie a zlý strom zlé ovocie. ");
INSERT INTO slk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dobrý strom predsa nemôže rodiť zlé ovocie ani zlý strom dobré. ");
INSERT INTO slk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Každý strom, ktorý nenesie dobré ovocie, vytnú a spália. ");
INSERT INTO slk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Teda podľa ich činov ich poznáte.“ ");
INSERT INTO slk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","„Na to, aby sa človek dostal do nebeského kráľovstva, nestačí, že sa ku mne hlási a oslovuje ma Pane! Pane! Rozhodujúce je, či koná vôľu môjho Otca, ktorý je v nebesiach. ");
INSERT INTO slk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","V deň posledného súdu mnohí povedia: Pane, Pane, či sme nehovorili v tvojom mene? Nevyháňali sme démonov v tvojom mene? Nerobili sme v tvojom mene mnohé zázraky? ");
INSERT INTO slk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ale ja im odpoviem: Nikdy som vás nepoznal. Choďte odo mňa preč, lebo ste páchali zlé veci!“ ");
INSERT INTO slk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","„Každého, kto počúva moje slová a koná podľa nich, môžeme prirovnať k prezieravému človeku, ktorý si postavil dom na skale. ");
INSERT INTO slk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Keď sa spustil lejak, privalila sa povodeň a prudká víchrica sa oprela do jeho múrov, dom sa nezrútil, lebo mal základy postavené na skale. ");
INSERT INTO slk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ale toho, kto počúva moje slová, no nekoná podľa nich, môžeme prirovnať k nerozumnému človeku, ktorý si postavil dom na piesku. ");
INSERT INTO slk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Spustil sa lejak, privalila sa povodeň, prudká víchrica sa oprela do múrov jeho domu – a dom s veľkým rachotom spadol.“ ");
INSERT INTO slk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Keď Ježiš dohovoril, ľudia nad jeho učením žasli. ");
INSERT INTO slk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ježiš totiž, na rozdiel od ich náboženských učiteľov, učil ako niekto, kto má autoritu. ");
INSERT INTO slk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Keď Ježiš zostúpil z vrchu, išiel za ním veľký dav ľudí. ");
INSERT INTO slk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Vtedy sa k nemu priblížil malomocný, kľakol si pred neho a povedal: „Pane, keby si chcel, mohol by si ma uzdraviť!“ ");
INSERT INTO slk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ježiš vystrel ruku, dotkol sa ho a povedal: „Áno, chcem. Buď zdravý.“ A po malomocenstve nezostalo ani stopy. ");
INSERT INTO slk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ježiš mu povedal: „Nikomu nič nehovor, ale choď, ukáž sa kňazovi a obetuj dar, ako to nariadil Mojžiš – na dôkaz, že si zdravý.“ ");
INSERT INTO slk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Keď Ježiš prišiel do Kafarnauma, pristúpil k nemu rímsky stotník a prosil ho: ");
INSERT INTO slk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","„Pane, môj sluha leží doma ochrnutý a má veľké bolesti.“ ");
INSERT INTO slk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ježiš mu odpovedal: „Prídem a uzdravím ho.“ ");
INSERT INTO slk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ale stotník namietal: „Pane, nie som hodný, aby si vošiel pod moju strechu. No stačí tvoje slovo a bude zdravý. ");
INSERT INTO slk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Veď viem, ako to je: Ja sám som podriadený, ale mám aj pod sebou vojakov. Ak niektorému poviem: Choď!, tak ide, a inému: Poď!, tak príde, a ak poviem sluhovi: Urob to!, tak to vykoná.“ ");
INSERT INTO slk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Keď to Ježiš počul, začudoval sa a obrátil sa na tých, ktorí ho sprevádzali: „Vravím vám, že s takou veľkou vierou som sa nestretol v celom Izraeli. ");
INSERT INTO slk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A bude to veru tak, že prídu mnohí ľudia z východu i západu a zaujmú miesto pri stole v nebeskom kráľovstve s Abrahámom, Izákom a Jákobom, ");
INSERT INTO slk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kým Izraeliti, pre ktorých bolo kráľovstvo pripravené, budú hnaní do tmy, kde bude plač a škrípanie zubami.“ ");
INSERT INTO slk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Potom Ježiš povedal stotníkovi: „Vráť sa domov! Nech sa ti stane tak, ako si tomu uveril!“ A sluha bol v tej chvíli uzdravený. ");
INSERT INTO slk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Potom Ježiš vošiel do Petrovho domu a našiel tam jeho svokru ležať vo vysokej horúčke. ");
INSERT INTO slk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dotkol sa jej ruky a horúčka hneď zmizla. Žena vstala a začala mu pripravovať jedlo. ");
INSERT INTO slk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Večer priviedli k nemu mnohých posadnutých. Jediným slovom vyhnal z nich zlých duchov a všetkých chorých uzdravil. ");
INSERT INTO slk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Takto sa splnilo, čo predpovedal prorok Izaiáš: „On vzal na seba naše slabosti a niesol naše choroby.“ ");
INSERT INTO slk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Keď Ježiš videl dav ľudí okolo seba, rozkázal učeníkom, aby sa preplavili v loďke na druhý breh jazera. ");
INSERT INTO slk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Vtom ho zadržal jeden z učiteľov Zákona a povedal mu: „Majstre, pôjdem za tebou kamkoľvek.“ ");
INSERT INTO slk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ježiš mu na to odpovedal: „Líšky majú svoje nory a vtáci hniezda, ale Syn človeka nemá dom ani miesto, kde by si zložil hlavu.“ ");
INSERT INTO slk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jeden z jeho žiakov mu zasa povedal: „Pane, kým pôjdem za tebou, dovoľ mi pochovať otca!“ ");
INSERT INTO slk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ale Ježiš mu odpovedal: „Poď za mnou hneď. Nech tí, ktorí sú duchovne mŕtvi, pochovávajú svojich mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Potom vstúpil Ježiš do loďky a plavil sa s učeníkmi na druhý breh. ");
INSERT INTO slk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Zrazu sa strhla silná búrka a loďka sa takmer potápala vo vysokých vlnách. No Ježiš pokojne spal. ");
INSERT INTO slk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Priskočili k nemu a zobudili ho: „Pane, zachráň nás, inak sa utopíme!“ ");
INSERT INTO slk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ale Ježiš im odpovedal: „Prečo sa tak bojíte? Kde je vaša viera?“ Potom vstal a pohrozil vetru a vlnám. Búrka sa upokojila a nastalo veľké ticho. ");
INSERT INTO slk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tí, čo boli s ním, ohromene hovorili: „Kto to vlastne je, že ho poslúcha víchrica aj more?“ ");
INSERT INTO slk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Keď pristáli na druhom brehu neďaleko Gadary, vybehli oproti nemu dvaja muži posadnutí démonmi. Žili v skalných hroboch a boli takí nebezpeční, že sa nikto neodvážil tade ísť. ");
INSERT INTO slk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Začali na Ježiša kričať: „Čo od nás chceš, Syn Boží? Prišiel si nás trápiť? Ešte na nás nemáš právo!“ ");
INSERT INTO slk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Neďaleko sa páslo veľké stádo svíň. ");
INSERT INTO slk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A démoni ho prosili: „Ak nás už chceš vyhnať, pošli nás do toho stáda svíň!“ ");
INSERT INTO slk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","„Nedbám, choďte!“ povedal im Ježiš. A hneď vyšli z tých dvoch a vošli do svíň. Celé stádo sa ihneď splašilo, prehnalo sa dolu svahom a utopilo sa v jazere. ");
INSERT INTO slk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pastieri svíň sa rozbehli do mesta a všade rozchýrili, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Všetci jeho obyvatelia utekali oproti Ježišovi a žiadali ho, aby odišiel z ich kraja. ");
INSERT INTO slk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ježiš opäť nastúpil do loďky, preplavil sa na druhý breh a prišiel do Kafarnauma, do mesta, kde býval. ");
INSERT INTO slk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Čoskoro k nemu priniesli na nosidlách ochrnutého človeka. Keď Ježiš videl ich vieru, povedal chorému: „Teš sa, priateľ môj, tvoje hriechy sú odpustené!“ ");
INSERT INTO slk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niektorí z učiteľov Zákona sa však pohoršovali: „Ten človek sa rúha!“ ");
INSERT INTO slk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ale Ježiš vedel, čo si myslia, a preto sa spýtal: „Prečo máte srdcia naplnené zlobou? ");
INSERT INTO slk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Čo je ľahšie povedať: Odpúšťajú sa ti hriechy, alebo: Vstaň a choď!? ");
INSERT INTO slk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ale aby ste vedeli, že Syn človeka má na zemi moc odpúšťať hriechy…“ Nato sa obrátil k ochrnutému a povedal mu: „Vstaň a vezmi si svoje lôžko. Môžeš ísť domov.“ ");
INSERT INTO slk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A on vstal a odišiel. ");
INSERT INTO slk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Toto sa odohralo pred očami zhromaždeného davu. Všetci žasli a ďakovali Bohu, že dal človeku takú moc. ");
INSERT INTO slk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Keď sa Ježiš uberal ďalej, všimol si muža, ktorý na colnici vyberal poplatky. Ten muž sa volal Matúš. „Poď so mnou a staň sa mojím učeníkom!“ vyzval ho Ježiš. Matúš hneď vstal a išiel za ním. ");
INSERT INTO slk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Neskôr, keď Ježiš spolu s učeníkmi večeral v Matúšovom dome v spoločnosti mnohých ľudí pochybnej povesti, ");
INSERT INTO slk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","zbožní farizeji sa pohoršovali a vraveli jeho učeníkom: „Ako si váš majster môže sadnúť za jeden stôl s takou spodinou?“ ");
INSERT INTO slk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Keď to Ježiš počul, odpovedal im: „Lekára nepotrebujú zdraví, ale chorí. ");
INSERT INTO slk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Choďte a snažte sa pochopiť, čo znamenajú slová Písma: ‚Nejde mi o vaše obete a dary, ale o to, aby ste boli milosrdní.‘ Neprišiel som volať k Bohu tých, ktorí sú presvedčení o vlastnej spravodlivosti, ale hriešnikov.“ ");
INSERT INTO slk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jedného dňa prišli za Ježišom učeníci Jána Krstiteľa s otázkou: „Prečo sa tvoji učeníci nepostia? Veď to robíme my aj farizeji!“ ");
INSERT INTO slk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ježiš im odpovedal: „Majú vari svadobčania, ktorých pozval ženích, dôvod smútiť, kým je s nimi? Ale prídu dni, keď bude ženích od nich vzatý, a potom sa budú postiť. ");
INSERT INTO slk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nikto predsa neprišíva na staré šaty záplatu z novej látky, lebo by vytrhla staré tkanivo a diera by sa ešte zväčšila. ");
INSERT INTO slk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ani mladé víno nenalievate do mechov zo starej kože, lebo by popraskali a víno by vytieklo. Nové víno potrebuje nové mechy!“ ");
INSERT INTO slk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kým Ježiš hovoril, prišiel jeden z predstaviteľov miestnej synagógy a poklonil sa mu. „Práve mi umrela dcéra,“ povedal, „ale ty jej môžeš vrátiť život. Poď, polož na ňu ruku a ožije.“ ");
INSERT INTO slk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ježiš vstal a šiel – a jeho učeníci ho nasledovali. ");
INSERT INTO slk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Vtom k nemu pristúpila zozadu akási žena, ktorá už dvanásť rokov krvácala, a dotkla sa okraja jeho šiat, ");
INSERT INTO slk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","lebo si pomyslela: „Stačí, ak sa dotknem jeho šiat, určite sa uzdravím.“ ");
INSERT INTO slk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ježiš sa obrátil, pozrel sa na ňu a povedal: „Teš sa, žena. Tvoja viera ťa uzdravila.“ A naozaj, od tej chvíle bola žena zdravá. ");
INSERT INTO slk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Keď Ježiš vošiel do domu predstaveného synagógy, kde hrala pohrebná hudba a nariekal zhromaždený dav, ");
INSERT INTO slk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","povedal im: „Rozíďte sa, veď dievčatko neumrelo, iba spí.“ Oni sa mu však vysmiali. ");
INSERT INTO slk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hneď ako všetkých poslali preč, vstúpil do miestnosti, v ktorej bolo dievčatko, chytil ho za ruku a ono ožilo a vstalo. ");
INSERT INTO slk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Správa o tomto zázraku sa rozniesla po celom kraji. ");
INSERT INTO slk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Keď bol Ježiš na ceste späť, išli za ním dvaja slepci a volali naňho: „Syn Dávidov, zmiluj sa nad nami!“ ");
INSERT INTO slk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kráčali za ním až do domu. Slepí pristúpili celkom k nemu a on sa ich spýtal: „Naozaj veríte, že mám moc vrátiť vám zrak?“ „Áno, Pane,“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ježiš sa dotkol ich očí a povedal: „Nech sa vám stane, ako veríte.“ ");
INSERT INTO slk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","V tej chvíli začali vidieť. Dôrazne im prikázal: „Nikto sa o tom nesmie dozvedieť!“ ");
INSERT INTO slk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oni však išli a rozniesli tú správu po celom kraji. ");
INSERT INTO slk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Keď odtiaľ Ježiš s učeníkmi odchádzal, priviedli k nemu nemého človeka, posadnutého zlým duchom. ");
INSERT INTO slk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ježiš démona vyhnal a muž ihneď začal hovoriť. Ľudia v dave žasli a hovorili: „Nikdy nikto nič podobné v Izraeli nevidel!“ ");
INSERT INTO slk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ale farizeji vysvetľovali: „Diabol, kráľ démonov, mu dal moc vyháňať démonov.“ ");
INSERT INTO slk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Potom Ježiš prechádzal všetkými mestami a dedinami, učil v židovských synagógach a hlásal radostnú správu o Božom kráľovstve. A všade, kam prišiel, liečil choroby tela aj ducha. ");
INSERT INTO slk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pri pohľade na ľudí, ktorí za ním prichádzali, jeho vnútro bolo naplnené súcitom a veľkou bolesťou – boli totiž utrápení a bezbranní ako ovce bez pastiera. ");
INSERT INTO slk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Vtedy povedal svojim učeníkom: „Žatva je veľká, ale žencov je málo. ");
INSERT INTO slk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Preto proste Pána žatvy, aby vyslal robotníkov na svoje polia.“ ");
INSERT INTO slk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Potom si Ježiš zavolal svojich dvanástich učeníkov a dal im moc vyháňať nečistých duchov a uzdravovať každú chorobu tela aj ducha. ");
INSERT INTO slk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mená týchto dvanástich apoštolov sú: Šimon, ktorého volali aj Peter a jeho brat Andrej; Jakub, syn Zebedejov a jeho brat Ján; ");
INSERT INTO slk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip a Bartolomej; Tomáš a bývalý colník Matúš; Alfejov syn Jakub a Tadeáš; ");
INSERT INTO slk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Šimon Horlivec a Judáš Iškariotský, ktorý ho napokon zradil. ");
INSERT INTO slk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Týchto dvanástich Ježiš vyslal so slovami: „Nechoďte teraz medzi pohanov a nevchádzajte do samaritánskych miest. ");
INSERT INTO slk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Radšej choďte k Izraelitom, ovciam, ktoré sa Bohu stratili, ");
INSERT INTO slk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","a hlásajte: Priblížilo sa nebeské kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uzdravujte chorých, krieste mŕtvych, očisťujte malomocných, vyháňajte démonov. Čo ste zadarmo dostali, zadarmo rozdávajte! ");
INSERT INTO slk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Neberte si so sebou peniaze ");
INSERT INTO slk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ani kapsu na cestu ani náhradné šatstvo či obuv, ba ani palicu. Lebo robotník si zaslúži mzdu za to, čo urobil. ");
INSERT INTO slk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Do ktoréhokoľvek mesta alebo dediny vojdete, spýtajte sa na bohabojných ľudí, v ich dome sa potom ubytujte, kým sa vydáte na ďalšiu cestu. ");
INSERT INTO slk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Keď vstúpite do domu, povedzte: ‚Pokoj tomuto domu!‘ ");
INSERT INTO slk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ak vaše posolstvo vďačne prijmú, naplní ich pokoj, ktorý prinášate. Ak odmietnu, váš pokoj zostane s vami. ");
INSERT INTO slk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Opusťte každé mesto alebo dom, kde by vás ani vaše svedectvo neprijali, nezdržujte sa tam, straste aj prach zo svojich nôh. ");
INSERT INTO slk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Vravím vám, že v deň Božieho súdu bude ľahšie hriešnym ľuďom zo Sodomy a Gomory ako takémuto mestu. ");
INSERT INTO slk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Posielam vás ako ovce medzi vlky. Buďte teda obozretní ako hady a mierni ako holubice. ");
INSERT INTO slk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na ľudí si dávajte pozor, lebo vás pre mňa budú vydávať súdom, budú vás bičovať v synagógach, ");
INSERT INTO slk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","budú vás vláčiť pred vládcov a panovníkov. To všetko bude príležitosťou, aby ste vydali svedectvo im aj celému svetu. ");
INSERT INTO slk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ak vás postavia pred súd, netrápte sa, ako a čo budete hovoriť, lebo dostanete pravé slová v pravý čas. ");
INSERT INTO slk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","To nebudete hovoriť vy, ale Duch vášho Otca prehovorí prostredníctvom vás. ");
INSERT INTO slk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Brat vydá na smrť brata, otec syna, deti sa vzbúria proti rodičom a zabijú ich. ");
INSERT INTO slk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Všetci vás budú nenávidieť, lebo ste mojimi učeníkmi. Ale ten, kto vytrvá až do konca, bude zachránený pre večnosť. ");
INSERT INTO slk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ak vás budú v niektorom meste prenasledovať, utečte do iného. Vravím vám, že nestačíte pochodiť po všetkých izraelských mestách, kým sa Syn človeka opäť vráti. ");
INSERT INTO slk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Žiak neprevyšuje svojho učiteľa, ani sluha svojho pána. ");
INSERT INTO slk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Žiak znáša údel svojho učiteľa a sluha údel svojho pána. Keď mňa nazývajú diablom, čo si asi vymyslia na vás!? ");
INSERT INTO slk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ale nebojte sa ich! Príde čas, keď pravda vyjde najavo a všetko skryté bude odhalené. ");
INSERT INTO slk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Čo vám hovorím v tme, povedzte na svetle, a čo vám tajne šepkám, rozhláste verejne! ");
INSERT INTO slk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A nebojte sa pri tom ľudí. Môžu vás síce zabiť, ale nemôžu vás pripraviť o večný život. Bojte sa Toho, ktorý môže zahubiť dušu i telo v pekle. ");
INSERT INTO slk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Akú cenu má vrabec? A predsa ani jeden nespadne na zem bez vedomia vášho Otca. ");
INSERT INTO slk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A vy máte ešte aj všetky vlasy na hlave zrátané. ");
INSERT INTO slk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Preto sa nebojte: ste omnoho cennejší než celý kŕdeľ vrabcov. ");
INSERT INTO slk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kto sa ku mne prizná pred ľuďmi, k tomu sa aj ja priznám pred svojím Otcom v nebesiach. ");
INSERT INTO slk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ale kto ma pred ľuďmi zaprie, toho aj ja zapriem pred svojím Otcom v nebi.“ ");
INSERT INTO slk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","„Nemyslite si, že som prišiel, aby som priniesol na zem pokoj. Nepriniesol som pokoj, ale meč. ");
INSERT INTO slk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Viera vo mňa môže postaviť proti sebe syna a otca, dcéru a matku, nevestu a svokru. ");
INSERT INTO slk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nepriateľom človeka sa stanú jeho najbližší. ");
INSERT INTO slk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kto má vo svojom srdci na prvom mieste otca alebo matku, syna alebo dcéru, a nie mňa, nie je ma hoden. ");
INSERT INTO slk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kto by ma chcel nasledovať bez ťažkostí, nie je ma hoden. ");
INSERT INTO slk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kto lipne na živote, stratí ho, ale kto je ochotný pre mňa všetko obetovať, ten svoj život zachráni. ");
INSERT INTO slk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kto prijíma vás, prijíma mňa, a kto prijíma mňa, ten prijíma toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ak prijme niekto môjho svedka s vedomím, že ho posiela Boh, dostane rovnakú odmenu ako on. Kto prijme spravodlivého pre jeho spravodlivosť, dostane rovnakú odmenu ako on. ");
INSERT INTO slk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A ak niekto podá ako môj nasledovník čo len pohár vody niekomu zdanlivo bezvýznamnému, určite nepríde o svoju odmenu.“ ");
INSERT INTO slk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Keď Ježiš odovzdal pokyny svojim dvanástim učeníkom, pobral sa učiť a kázať do tamojších miest. ");
INSERT INTO slk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ján Krstiteľ, ktorý bol práve vo väzení, sa dopočul o tom, čo Kristus robí. Poslal za ním dvoch svojich učeníkov, ");
INSERT INTO slk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","aby sa ho spýtali: „Si naozaj ten, ktorý mal prísť, alebo máme čakať iného?“ ");
INSERT INTO slk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ježiš im odpovedal: „Vráťte sa k Jánovi a vyrozprávajte mu, čo ste videli a počuli: ");
INSERT INTO slk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Slepí vidia, chromí chodia, malomocní sú uzdravení, hluchí počujú, mŕtvi ožívajú a chudobným sa zvestuje dobrá správa. ");
INSERT INTO slk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Šťastný je ten, kto mi dôveruje.“ ");
INSERT INTO slk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Keď Jánovi učeníci odišli, Ježiš hovoril o ňom ľuďom: „Keď ste šli za Jánom na púšť, čo ste chceli uvidieť? Trstinu zmietanú vetrom? ");
INSERT INTO slk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Alebo človeka vyobliekaného do drahých šiat? Ale veď takí bývajú v kráľovských palácoch. ");
INSERT INTO slk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Prečo ste teda šli za ním? Chceli ste vidieť proroka? Hovorím vám, spoznali ste viac než proroka. ");
INSERT INTO slk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","To o ňom je napísané: ‚Posielam pred tebou svojho posla, aby ti pripravil cestu.‘ ");
INSERT INTO slk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Vedzte, že medzi všetkými ľuďmi, ktorí sa kedy narodili, niet nikoho, kto by prevyšoval Jána Krstiteľa. A predsa i ten najmenší v nebeskom kráľovstve je väčší ako on. ");
INSERT INTO slk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Od čias Jána Krstiteľa je nebeské kráľovstvo vystavené násiliu a zmocňujú sa ho ukrutníci. ");
INSERT INTO slk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lebo všetci proroci aj Zákon až po Jána Krstiteľa to predpovedali. ");
INSERT INTO slk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A ak ste pripravení prijať to, tak on je Eliáš, o ktorom prorok zvestoval, že príde skôr, než sa kráľovstvo začne. ");
INSERT INTO slk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kto má uši na počúvanie, nech počúva! ");
INSERT INTO slk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ku komu mám prirovnať ľudí, ako ste vy? Sú ako hrajúce sa deti, ktoré sedia na námestí a nespokojne pokrikujú na svojich kamarátov: ");
INSERT INTO slk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‚Hrali sme vám, ale netancovali ste, smutne sme vám spievali, ale neplakali ste.‘ ");
INSERT INTO slk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Keď prišiel Ján, postil sa a nepil víno – a vravia: Je posadnutý. ");
INSERT INTO slk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ale keď prišiel Syn človeka, nepostí sa – a hovoria: ‚Pozrite sa na toho nenažranca a opilca, priateľa hriešnikov. Ale dokonalosť Božej múdrosti ukážu tí, ktorí podľa nej žijú.‘ “ ");
INSERT INTO slk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vtedy začal Ježiš karhať mestá, ktoré boli svedkami jeho mnohých zázrakov, a predsa nerobili pokánie: ");
INSERT INTO slk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Beda ti, Korazim, beda ti, Betsaida! Keby sa v Týre a Sidone stali také zázraky ako u vás, ich obyvatelia by sa už dávno kajali a prejavovali by najhlbšiu ľútosť nad svojimi vinami. ");
INSERT INTO slk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Preto vám hovorím, že Týru a Sidonu bude ľahšie v deň súdu ako vám. ");
INSERT INTO slk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A čo vy, obyvatelia Kafarnauma? Myslíte si, že Boh vás vyvýši až po samo nebo? Zrútite sa do priepasti večného zahynutia! Keby sa v Sodome diali také zázraky ako u vás, stála by dodnes. ");
INSERT INTO slk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Znova vám hovorím, že sodomskej krajine bude ľahšie v deň súdu ako tebe!“ ");
INSERT INTO slk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vtedy sa Ježiš modlil: „Velebím ťa, Otče, Pán neba aj zeme, že pravdu skrývaš pred tými, ktorí sa pokladajú za múdrych a učených, a zjavuješ ju bezvýznamným a jednoduchým. ");
INSERT INTO slk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Áno, Otče, tak sa ti to páči.“ ");
INSERT INTO slk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","„Otec mi zveril všetko. Len Otec pozná Syna a Otca pozná iba Syn a ten, komu sa to Syn rozhodne zjaviť. ");
INSERT INTO slk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Poďte ku mne všetci, ktorí sa namáhate a ste unavení, ja vám dám odpočinutie. ");
INSERT INTO slk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Vezmite na seba moje jarmo a učte sa odo mňa, lebo mám tiché a pokorné srdce. U mňa nájdete mier a odpočinutie pre svoje duše. ");
INSERT INTO slk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Veď moje jarmo netlačí a bremeno neťaží.“ ");
INSERT INTO slk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Raz v sobotu prechádzal Ježiš so svojimi učeníkmi obilným poľom. Učeníci boli hladní, preto začali trhať klasy a jesť zrno. ");
INSERT INTO slk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Videli to farizeji a žalovali Ježišovi: „Pozri, tvoji učeníci robia, čo sa v sobotu nesmie robiť!“ ");
INSERT INTO slk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ježiš im odpovedal: „Azda ste nečítali, čo urobil kráľ Dávid, keď on aj jeho družina boli hladní? ");
INSERT INTO slk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ako vošiel do chrámu a spolu jedli posvätné chleby, ktoré smeli jesť iba kňazi? ");
INSERT INTO slk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Alebo ste nečítali v Mojžišovom zákone, že kňazi v chráme pracujú v sobotu? Porušujú sobotný pokoj, a predsa nie sú vinní. ");
INSERT INTO slk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Vravím vám, že je tu niekto, kto je viac než chrám. ");
INSERT INTO slk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Keby ste rozumeli slovám: ‚Nejde mi o vaše obete a dary, ale o to, aby ste boli milosrdní,‘ tak by ste nikoho neprávom neodsudzovali. ");
INSERT INTO slk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Syn človeka rozhoduje aj o tom, čo sa v sobotu smie robiť a čo nie.“ ");
INSERT INTO slk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Odtiaľ šiel Ježiš do synagógy. ");
INSERT INTO slk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bol tam človek s ochrnutou rukou. Farizeji hľadali nejakú zámienku, aby mohli Ježiša obžalovať, preto sa ho spýtali: „Dovoľuje zákon v sobotu uzdravovať?“ ");
INSERT INTO slk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Odpovedal im: „Keby niekto z vás mal jedinú ovcu a tá by mu v sobotu spadla do jamy, neurobil by všetko, aby ju z nej vytiahol ešte v ten deň? ");
INSERT INTO slk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A o čo cennejší je človek! Preto je správne robiť dobro aj v sobotu.“ ");
INSERT INTO slk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Obrátil sa k postihnutému a povedal mu: „Vystri ruku!“ Ten ho poslúchol a ruka bola zdravá ako tá druhá. ");
INSERT INTO slk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farizeji odišli a radili sa, ako by Ježiša zabili. ");
INSERT INTO slk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ježiš však postrehol ich úmysly a odišiel. Mnohí šli za ním a on uzdravil všetkých chorých. ");
INSERT INTO slk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ale prikázal im, aby o ňom verejne nehovorili. ");
INSERT INTO slk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tak sa naplnilo Izaiášovo proroctvo: ");
INSERT INTO slk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„Toto je môj služobník, ktorého som si vyvolil, môj milovaný, potešenie mojej duše. Dám mu svojho Ducha a národom ukáže, ako môžu získať spravodlivosť. ");
INSERT INTO slk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nebude sa hádať ani nikoho prekrikovať, nebude robiť hurhaj na uliciach, ");
INSERT INTO slk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","nalomené steblo nedolomí, tlejúci knôt neuhasí, kým nespôsobí, aby spravodlivosť zvíťazila. ");
INSERT INTO slk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jeho meno sa stane nádejou pre všetky národy.“ ");
INSERT INTO slk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tu k nemu priviedli posadnutého človeka, ktorý bol navyše slepý aj nemý. Ale Ježiš ho uzdravil – vrátil mu zrak aj reč. ");
INSERT INTO slk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ľudia žasli a vraveli: „Nie je on naozaj syn Dávidov?“ ");
INSERT INTO slk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ale počuli o tom zázraku farizeji a namietali: „Len Belzebul, kráľ démonov, mu mohol dať moc vyháňať démonov!“ ");
INSERT INTO slk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ale Ježiš vedel, čo si myslia, a preto povedal: „Rozdelené kráľovstvo pustne a nijaké mesto či rodina, kde vládnu spory a roztržky, neobstojí. ");
INSERT INTO slk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tak ani satan nemôže bojovať sám proti sebe – ako by potom obstálo jeho kráľovstvo? ");
INSERT INTO slk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hovoríte, že vyháňam zlých duchov mocou Belzebula. Koho mocou ich potom vyháňajú vaši žiaci? Aj oni vyháňajú démonov – a stanú sa aj vašimi sudcami. ");
INSERT INTO slk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ale ak vyháňam zlo v moci Božieho Ducha, tak Božie kráľovstvo už prišlo k vám. ");
INSERT INTO slk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ak chce niekto ukradnúť veci z domu silného muža, musí ho najprv zviazať a len potom si ich môže odniesť. ");
INSERT INTO slk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kto nie je so mnou, je proti mne a kto nezhromažďuje so mnou, rozptyľuje. ");
INSERT INTO slk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Preto vám hovorím, že každý hriech aj rúhanie môžu byť ľuďom odpustené, ale rúhanie proti Svätému Duchu odpustené nebude. ");
INSERT INTO slk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tomu, kto by hovoril niečo proti Synovi človeka, môže byť odpustené. Ale tomu, kto bude hovoriť proti Svätému Duchu, nebude odpustené ani v tomto veku, ani v budúcom.“ ");
INSERT INTO slk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","„Aký strom vypestujete, také ovocie bude rodiť. Dobrý bude rodiť dobré ovocie, zlý zlé. Každý strom sa pozná podľa svojho ovocia. ");
INSERT INTO slk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Vy, plemeno vreteníc, ako by ste mohli dobre hovoriť, keď ste zlí? Ústa hovoria to, čím je naplnené srdce. ");
INSERT INTO slk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dobrý človek rozdáva z dobrého pokladu svojho srdca dobré veci. Ak je však jeho srdce plné zla, šíri iba zlo. ");
INSERT INTO slk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Rátajte s tým, že v deň súdu budete skladať účty z každého neužitočného slova. ");
INSERT INTO slk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vaše terajšie slová o vás rozhodnú: buď vás ospravedlnia, alebo odsúdia.“ ");
INSERT INTO slk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vtedy prišli za Ježišom niektorí zo židovských učiteľov Zákona a farizeji a žiadali: „Učiteľ, chceme od teba vidieť jasné znamenie, že ťa poslal Boh.“ ");
INSERT INTO slk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ale Ježiš im odpovedal: „Len zvrátení a bezbožní ľudia si vyžadujú zázračné dôkazy, že ma poslal Boh. Ale nedostanete iné znamenie, iba znamenie proroka Jonáša. ");
INSERT INTO slk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ako bol totiž Jonáš tri dni a tri noci v útrobách veľryby, tak bude Syn človeka tri dni a tri noci v lone zeme. ");
INSERT INTO slk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Obyvatelia Ninive vystúpia na súde proti vám a odsúdia vás, lebo oni na Jonášovo kázanie vykonali pokánie a obrátili sa k Bohu. A ten, kto stojí pred vami, je väčší ako Jonáš. ");
INSERT INTO slk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kráľovná zo Sáby vystúpi na súde ako ďalší svedok proti vám, lebo prišla z ďalekej krajiny, aby poznala Šalamúnovu múdrosť. A tu je predsa niekto omnoho väčší ako Šalamún. ");
INSERT INTO slk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Keď je z človeka vyhnaný nečistý duch, blúdi po vyprahnutých a opustených miestach a hľadá, kam by sa utiahol, ale nemôže nájsť. ");
INSERT INTO slk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Vtedy si povie: ‚Vrátim sa, odkiaľ som vyšiel.‘ Po návrate zistí, že jeho príbytok je prázdny, uprataný a vyzdobený. ");
INSERT INTO slk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ide teda, vezme so sebou sedem iných duchov, horších ako je sám, vojdú dnu a usídlia sa tam. Taký človek je vtedy na tom oveľa horšie, ako bol predtým. To je to, čo sa stane takým skazeným ľuďom, ako ste vy.“ ");
INSERT INTO slk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kým Ježiš hovoril v dome obklopenom húfom ľudí, prišla jeho matka a bratia. Čakali vonku, lebo sa chceli s ním zhovárať. ");
INSERT INTO slk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Keď ho ktosi z davu upozornil, že naňho vonku čakajú, povedal: ");
INSERT INTO slk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","„Kto je moja matka a kto sú moji bratia?“ ");
INSERT INTO slk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ukázal na učeníkov a povedal: „Toto je moja rodina. ");
INSERT INTO slk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Každý, kto koná vôľu môjho nebeského Otca, je môj brat, sestra i matka!“ ");
INSERT INTO slk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","V ten istý deň vyšiel Ježiš z domu a posadil sa pri mori a učil. ");
INSERT INTO slk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Onedlho sa okolo neho zhromaždil taký veľký dav ľudí, že musel vstúpiť do loďky. Kázal teda odtiaľ a dav ho počúval na brehu. ");
INSERT INTO slk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Keď k nim hovoril, používal mnohé podobenstvá. „Roľník vyšiel na pole, aby zasial obilie. ");
INSERT INTO slk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ako rozsieval, padli niektoré zrná na okraj cesty, zlietli sa vtáky a pozobali ich. ");
INSERT INTO slk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iné zrná dopadli na skalnatú pôdu, kde bolo málo ornice. Obilie rýchlo vzklíčilo, ");
INSERT INTO slk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ale keď začalo páliť slnko, uschlo, lebo korienky nemohli ísť do hĺbky. ");
INSERT INTO slk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Veľa zŕn padlo aj medzi bodliaky. Keď bodľačie vyrástlo, udusilo klásky. ");
INSERT INTO slk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ostatné zrná padli do úrodnej pôdy. Obilie vyrástlo a prinieslo úrodu. Na niektorom klase bolo sto zrniek, na inom šesťdesiat a na ďalšom tridsať. ");
INSERT INTO slk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tak teda, kto má uši na počúvanie, nech počúva!“ ");
INSERT INTO slk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pristúpili k nemu učeníci a spýtali sa ho: „Prečo im hovoríš v podobenstvách?“ ");
INSERT INTO slk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Odpovedal im: „Vám už Boh zjavil tajomstvá nebeského kráľovstva, ale im ešte nie. ");
INSERT INTO slk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ten, kto žije podľa Božieho slova, bude mu rozumieť čoraz viac. Ale ten, kto podľa neho nežije, čoskoro prestane rozumieť aj tomu, čo mu je už teraz jasné. ");
INSERT INTO slk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hovorím ľuďom v podobenstvách, aby boli nútení rozmýšľať. Oni však počúvajú, ale nerozumejú, pozerajú sa, ale nevidia. ");
INSERT INTO slk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tak sa na nich plní Izaiášovo proroctvo: Budete počúvať, ale neporozumiete, budete sa dívať, ale neuvidíte. ");
INSERT INTO slk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lebo srdcia týchto ľudí otupeli, ušami ťažko počujú a zavreli oči, aby nevideli, nepočuli a neporozumeli, aby sa neobrátili k Bohu, ktorý by ich mohol uzdraviť. ");
INSERT INTO slk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ale šťastné sú vaše oči, že vidia a vaše uši, že počujú. ");
INSERT INTO slk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mnohí proroci túžili vidieť, čo vy vidíte, a počuť, čo vy počujete, ale nemohli.“ ");
INSERT INTO slk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","„A teraz počúvajte, aký je zmysel podobenstva o rozsievačovi. ");
INSERT INTO slk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cesta, kam padli niektoré zrná, predstavuje srdcia ľudí, ktorí počujú o Božom kráľovstve, ale nerozumejú tomu. Prichádza satan a vytrhne to, čo bolo zasiate. ");
INSERT INTO slk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Skalnatá pôda predstavuje srdce človeka, ktorý počuje Božie posolstvo a prijíma ho síce s veľkou radosťou, ");
INSERT INTO slk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ale povrchne, a ono tak v ňom nezapustí korene. Keď potom prídu ťažkosti alebo prenasledovanie pre vieru, jeho nadšenie ochabne a to, čo bolo zasiate, sa stratí. ");
INSERT INTO slk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pôda zarastená bodľačím predstavuje človeka, ktorý počuje Božie posolstvo, ale každodenné starosti a túžba po bohatstve udusia slovo, takže ostane bez úrody. ");
INSERT INTO slk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Úrodná pôda predstavuje srdce človeka, ktorý počuje Božie posolstvo a žije podľa neho. Ten prináša úžitok – tridsať, šesťdesiat alebo stonásobný.“ ");
INSERT INTO slk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Potom im povedal ďalšie podobenstvo: „Nebeské kráľovstvo je ako hospodár, ktorý zasial na svojom poli dobré semeno. ");
INSERT INTO slk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ale v noci, keď ľudia spali, jeho nepriateľ rozhodil medzi pšenicu kúkoľ a odišiel. ");
INSERT INTO slk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Keď obilie vyrástlo do klasov, ukázal sa aj kúkoľ. ");
INSERT INTO slk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sluhovia prišli za hospodárom a povedali mu: ‚Veď si zasial čisté semeno, kde sa vzal kúkoľ?‘ – ");
INSERT INTO slk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‚To urobil nepriateľ!‘ odpovedal im. ‚Pôjdeme to pole vyplieť,‘ ponúkli sa. ");
INSERT INTO slk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ale hospodár nesúhlasil: ‚Nie, nerobte to. S kúkoľom by ste mohli ľahko vytrhnúť aj pšenicu. ");
INSERT INTO slk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Necháme oboje dorásť a pri žatve rozkážem žencom, aby najprv vybrali kúkoľ, zviazali ho do snopov, spálili a pšenicu nanosili do mojej stodoly.‘ “ ");
INSERT INTO slk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Predložil im iný obraz: „S nebeským kráľovstvom je to ako s horčičným semienkom, ktoré človek zasial na poli. ");
INSERT INTO slk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Je síce najdrobnejšie zo všetkých semien, ale keď vyrastie, je to najmohutnejšia bylina, ba je z neho strom, takže prilietajú vtáci a hniezdia v ňom.“ ");
INSERT INTO slk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A použil ďalšie podobenstvo: „S nebeským kráľovstvom je to ako s kváskom, ktorý žena vzala, zarobila do troch meríc múky a všetko cesto vykyslo.“ ");
INSERT INTO slk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","To všetko hovoril Ježiš výhradne v podobenstvách. ");
INSERT INTO slk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tak sa naplnilo staré proroctvo: „Budem im hovoriť v obrazoch. Tajomstvá, ktoré boli skryté od založenia sveta, im odhalím.“ ");
INSERT INTO slk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ježiš potom rozpustil dav a šiel domov. Obklopili ho jeho učeníci a prosili ho, aby im vyložil podobenstvo o kúkoli na poli. ");
INSERT INTO slk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ježiš teda povedal: „Ten, ktorý seje dobré semeno, je Syn človeka. ");
INSERT INTO slk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pole predstavuje tento svet, dobré semeno sú deti nebeského kráľovstva a kúkoľ sú ľudia zotročení tým Zlým. ");
INSERT INTO slk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nepriateľ, ktorý kúkoľ rozosial, je diabol. Žatva predstavuje koniec sveta a ženci sú anjeli. ");
INSERT INTO slk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tak ako v tomto príbehu je kúkoľ oddelený a spálený, tak bude i na konci sveta. ");
INSERT INTO slk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Syn človeka pošle svojich anjelov a tí vyženú z nebeského kráľovstva všetkých, ktorí sa proti nemu stavali, i všetkých, ktorí páchali zlo. ");
INSERT INTO slk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Spáli ich oheň, budú plakať a škrípať zubami. ");
INSERT INTO slk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A vtedy tí, čo plnili Božiu vôľu, sa zaskvejú v kráľovstve nebeského Otca ako slnko. Kto má uši na počúvanie, nech počúva!“ ");
INSERT INTO slk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","„Nebeské kráľovstvo je ako skrytý poklad, ktorý nejaký človek objaví na poli a znova ho zakope. Od radosti predá všetko, čo má a kúpi to pole. ");
INSERT INTO slk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nebeské kráľovstvo je podobné aj kupcovi, ktorý hľadá vzácne perly. ");
INSERT INTO slk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Keď objaví mimoriadne krásnu perlu, predá všetko, čo má, len aby ju získal. ");
INSERT INTO slk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nebeské kráľovstvo môžeme ďalej prirovnať k sieti hodenej do mora. Zachytí sa v nej všetko možné. ");
INSERT INTO slk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Keď je sieť plná, vytiahnu ju rybári na breh, dobré ryby vyberú do košov a zvyšok vyhodia. ");
INSERT INTO slk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tak to bude aj na konci sveta. Prídu Boží anjeli, oddelia zlých od spravodlivých ");
INSERT INTO slk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a hodia ich do ohnivej pece. Tam bude plač a škrípanie zubami.“ ");
INSERT INTO slk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ježiš sa spýtal, či tomu všetkému porozumeli. – „Áno,“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Potom doložil: „Každý učiteľ Zákona, ktorý sa stal učeníkom nebeského kráľovstva, je ako hospodár, ktorý ponúka zo svojej komory nové aj staré veci.“ ");
INSERT INTO slk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Keď Ježiš dorozprával tieto podobenstvá, vrátil sa do Nazareta, ");
INSERT INTO slk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","do svojho domovského mesta. Učil v tamojšej synagóge. Všetci sa čudovali: „Kde sa v ňom berie taká múdrosť a moc? ");
INSERT INTO slk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Veď je to tesárov syn, matka je predsa Mária a Jakub, Jozef, Šimon a Júda sú jeho bratia! ");
INSERT INTO slk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aj jeho sestry žijú medzi nami. Odkiaľ to ten človek má?“ ");
INSERT INTO slk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A pohoršovali sa nad ním. Ježiš im povedal: „Proroka si vážia všade omnoho väčšmi ako v jeho rodnom meste a v jeho domove!“ ");
INSERT INTO slk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pre ich nevieru tam nemohol vykonať mnoho zázrakov. ");
INSERT INTO slk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vtedy sa dopočul galilejský vládca Herodes Antipas o Ježišovi ");
INSERT INTO slk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a povedal svojim dvoranom: „To je akiste Ján Krstiteľ! Vstal z mŕtvych, a preto má zázračnú moc!“ ");
INSERT INTO slk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pred časom dal totiž Herodes Jána zatknúť a uväzniť. Ján mu vyčítal, ");
INSERT INTO slk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","že žije s Herodiadou, manželkou svojho brata Filipa. ");
INSERT INTO slk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes chcel Jána zabiť, ale obával sa vzbury ľudu, lebo v ňom videli proroka. ");
INSERT INTO slk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na oslavách Herodesových narodenín tancovala dcéra Herodiady a veľmi očarila Herodesa. ");
INSERT INTO slk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Prisahal, že splní každé jej želanie. ");
INSERT INTO slk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodiada naviedla svoju dcéru a tá povedala: „Tak mi daj ihneď priniesť na podnose hlavu Jána Krstiteľa.“ ");
INSERT INTO slk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodesa to vydesilo, ale nechcel sa zosmiešniť pred hosťami tým, že by porušil prísahu. ");
INSERT INTO slk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Preto dal príkaz, aby Jána Krstiteľa sťali priamo vo väzení. ");
INSERT INTO slk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jeho hlavu priniesli tanečnici na podnose a tá ju položila pred svoju matku. ");
INSERT INTO slk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jánovi žiaci si vyžiadali jeho telo a pochovali ho. Potom šli oznámiť Ježišovi, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Keď to Ježiš počul, nastúpil do loďky a odplavil sa na pusté miesto, aby bol sám. ");
INSERT INTO slk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","No len čo ľudia z okolia zistili, ktorým smerom sa uberá jeho loďka, pešo sa pobrali za ním. Keď vystúpil na breh, už ho tam čakali davy ľudí. Prišlo mu ich ľúto, a tak začal uzdravovať chorých. ");
INSERT INTO slk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Keď sa zvečerilo, pristúpili k nemu učeníci a upozornili ho: „Už je neskoro a tu na pustatine sa nedá nič kúpiť. Dovoľ ľuďom odísť, nech sa rozídu po dedinách a zadovážia si niečo na jedenie.“ ");
INSERT INTO slk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ježiš im na to povedal: „Kam by chodili, vy sa im dajte najesť!“ ");
INSERT INTO slk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Namietli: „Veď máme dokopy iba päť chlebov a dve ryby!“ ");
INSERT INTO slk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","„Prineste mi ich sem!“ ");
INSERT INTO slk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Potom vyzval ľudí, aby si posadali na trávu. Vzal tých päť chlebov a dve ryby, uprel oči do neba a poďakoval sa za ne Bohu. Potom lámal a dával učeníkom chleby, a tí ich rozdávali ľuďom. ");
INSERT INTO slk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Najedlo sa tam dosýta asi päťtisíc mužov. ");
INSERT INTO slk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ženy a deti sa do toho počtu nerátali. A keď pozbierali zvyšky, zistili, že ich je plných dvanásť košov. ");
INSERT INTO slk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hneď potom prikázal svojim učeníkom, aby nastúpili do loďky a preplavili sa na druhý breh, kým sa on rozlúči so zhromaždenými ľuďmi. ");
INSERT INTO slk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Keď ich vyprevadil, vyšiel na kopec, aby sa osamote modlil. Strávil tam takmer celú noc. ");
INSERT INTO slk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","V tom čase už bola loď dosť ďaleko od brehu. Zmietali ňou vlny a fúkal silný protivietor. ");
INSERT INTO slk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nad ránom sa Ježiš priblížil k loďke kráčajúc po hladine jazera. ");
INSERT INTO slk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Keď ho učeníci zbadali, vydesili sa a od hrôzy kričali: To je prízrak! ");
INSERT INTO slk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ale Ježiš sa im hneď prihovoril a upokojil ich: „Vzchopte sa, to som ja, nebojte sa!“ ");
INSERT INTO slk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tu naňho zavolal Peter: „Pane, ak si to ty, rozkáž mi, a ja prídem k tebe po vode!“ ");
INSERT INTO slk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","„Tak poď!“ vyzval ho Ježiš. A Peter hneď vystúpil z lode a pobral sa po vode k Ježišovi. ");
INSERT INTO slk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ale keď sa pozrel okolo seba a videl obrovské vlny, preľakol sa a začal sa topiť: „Pane, zachráň ma!“ vykríkol. ");
INSERT INTO slk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ježiš ihneď vystrel ruku, zachytil ho a povedal mu: „Kde je tvoja viera? Prečo si pochyboval?“ ");
INSERT INTO slk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A len čo vystúpili na loď, vietor sa utíšil. ");
INSERT INTO slk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Učeníci pokľakli pred ním a vyznávali: „Ty si určite Boží Syn!“ ");
INSERT INTO slk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Potom pristáli v genezaretskom kraji. ");
INSERT INTO slk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Len čo ho tamojší ľudia spoznali, správa o ňom sa rozniesla po širokom okolí a odvšadiaľ prinášali k nemu chorých. ");
INSERT INTO slk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Prosili ho, aby im dovolil dotknúť sa aspoň lemu jeho šiat. A kto sa dotkol, bol uzdravený. ");
INSERT INTO slk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Vtedy prišli za Ježišom farizeji a učitelia Zákona z Jeruzalema, aby sa ho opýtali: ");
INSERT INTO slk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Prečo tvoji žiaci nedodržiavajú staré tradície? Veď si ani len ruky neumývajú pred jedením!“ ");
INSERT INTO slk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ježiš im na to odpovedal: „A prečo vy pre svoje tradície porušujete Božie prikázanie? ");
INSERT INTO slk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Napríklad, Boží príkaz znie: Cti svojho otca i svoju matku. A kto potupí otca alebo matku, musí zomrieť. ");
INSERT INTO slk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ale vy učíte: Kto povie otcovi alebo matke: To, čím by som ti mal pomôcť, je dar určený Bohu, ten už nemusí podporiť svojich rodičov ani vtedy, keď to potrebujú. ");
INSERT INTO slk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A tak ste svojou tradíciou zrušili priamy Boží príkaz. ");
INSERT INTO slk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pokrytci! Na vás sa vzťahujú slová proroka Izaiáša: ");
INSERT INTO slk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tento ľud hovorí, že ma ctí, ale jeho srdce je odo mňa ďaleko. ");
INSERT INTO slk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","No márne ma uctieva, lebo vyučuje svoje vlastné zákony, a nie Božie.“ ");
INSERT INTO slk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Potom okolo seba zhromaždil ľudí a povedal im: „Počúvajte, čo vám hovorím a pochopte: ");
INSERT INTO slk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vaše vnútro neznečisťuje to, čo vchádza do úst, ale čo z nich vychádza.“ ");
INSERT INTO slk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Prišli za ním učeníci a upozornili ho: „Vieš, že farizejov tieto slová pohoršili?“ ");
INSERT INTO slk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ježiš im odpovedal: „Rátajte s tým, že každá rastlina, ktorú nezasial môj nebeský Otec, bude vytrhnutá aj s koreňmi. ");
INSERT INTO slk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nechajte ich! Sú slepými vodcami slepých. A keď slepý povedie slepého, obaja spadnú do jamy.“ ");
INSERT INTO slk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter sa spýtal Ježiša: „Ako si to myslel s tým, čo nás znečisťuje?“ ");
INSERT INTO slk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ježiš sa začudoval: „Ani vy tomu nerozumiete? ");
INSERT INTO slk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nechápete, že všetko, čo zjeme, prechádza vnútornosťami a vychádza z tela do žumpy? ");
INSERT INTO slk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Človeka znesväcuje to, čo vychádza z jeho vnútra. ");
INSERT INTO slk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Zo srdca vychádzajú zlé myšlienky, ktoré vedú k vraždám, cudzoložstvu, smilstvu, krádežiam, klamstvám a ohováraniu. ");
INSERT INTO slk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Toto všetko zbavuje človeka vnútornej čistoty. Ale jesť neumytými rukami, to človeka nepoškvrňuje.“ ");
INSERT INTO slk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ježiš potom odtiaľ odišiel a pobral sa pešo do týrskeho a sidonského kraja. ");
INSERT INTO slk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tu prišla za ním jedna žena z tých pohanských končín a prosila ho: „Zmiluj sa nado mnou, Pane, Syn Dávidov! Moja dcéra je posadnutá démonom a veľmi trpí!“ ");
INSERT INTO slk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ale on si ju vôbec nevšímal. Jeho učeníci naňho naliehali: „Zbav sa jej, lebo nás unavuje svojím krikom.“ ");
INSERT INTO slk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tu sa Ježiš obrátil k žene a povedal jej: „Bol som poslaný iba k strateným ovciam z domu Izraela.“ ");
INSERT INTO slk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ale prišla až k nemu, klaňala sa mu a prosila ho: „Pane, pomôž mi!“ ");
INSERT INTO slk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","„Nie je správne brať chlieb deťom a hádzať ho psom!“ oponoval jej. ");
INSERT INTO slk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ale žena namietla: „Máš pravdu, ale šteňatám spadnú aspoň omrvinky zo stolov ich pánov.“ ");
INSERT INTO slk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","„Žena, máš veľkú vieru,“ povedal jej Ježiš. „Nech sa stane, ako si želáš!“ V tej chvíli sa jej dcéra uzdravila. ");
INSERT INTO slk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Potom sa Ježiš vrátil ku Galilejskému moru a vystúpil na vrch nad jazerom, aby tam učil. ");
INSERT INTO slk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zhromaždil sa okolo neho veľký dav ľudí a priviedli so sebou chorých, zmrzačených, slepých, nemých a všelijako inak postihnutých. Kládli ich pred neho a on ich uzdravoval. ");
INSERT INTO slk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ľudia žasli, keď videli, že tí, čo dovtedy nemohli vyriecť ani slovko, hovorili, chromí chodili, mrzáci sa narovnali a slepí videli! Nadšene oslavovali Boha Izraela. ");
INSERT INTO slk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tu si Ježiš zavolal učeníkov a povedal im: „Je mi ľúto týchto ľudí, veď sú už tri dni so mnou a nemajú čo jesť. Nerád by som ich pustil hladných, veď by ani nedošli domov.“ ");
INSERT INTO slk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Učeníci mu odpovedali: „Kde by sme v tejto pustatine vzali chlieb pre toľkých ľudí?“ ");
INSERT INTO slk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","„Čo tu máte na jedenie?“ „Sedem chlebov a niekoľko rýb,“ odpovedali. ");
INSERT INTO slk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nato Ježiš rozkázal ľuďom, aby si posadali na zem, ");
INSERT INTO slk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","potom vzal tých sedem chlebov a ryby, poďakoval sa za ne Bohu, lámal chlieb, dával ho učeníkom a tí ho rozdávali zástupom. ");
INSERT INTO slk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nasýtilo sa tam štyritisíc mužov, ");
INSERT INTO slk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","nerátajúc ženy a deti. A ešte nazbierali sedem košov zvyškov. ");
INSERT INTO slk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Potom sa s nimi rozlúčil, nastúpil do loďky a preplavil sa do Magadanského kraja. ");
INSERT INTO slk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Neskôr prišli za Ježišom niektorí z farizejov a saducejov, aby ho verejne znevážili. Domáhali sa nejakého znamenia z neba, aby im dokázal, že je naozaj Mesiáš. ");
INSERT INTO slk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","On im odpovedal: „Keď vidíte večerné zore, vravievate, že ráno bude pekne; ");
INSERT INTO slk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","keď sú zore ráno zapálené, vravievate, že príde búrka. Úkazy na nebi viete posúdiť, ale znamenia, ktoré sa teraz odohrávajú pred vašimi očami, posúdiť nemôžete? ");
INSERT INTO slk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tento prevrátený a neveriaci ľud sa dožaduje zvláštnych znamení z neba, ale nedostane iné znamenie ako to, ktoré dostal Jonáš.“ A nechal ich tam a odišiel. ");
INSERT INTO slk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Znova sa plavili cez jazero a až na druhom brehu jeho učeníci zistili, že si zabudli vziať chlieb. ");
INSERT INTO slk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ježiš im povedal: „Dávajte si pozor na farizejský a saducejský kvas!“ ");
INSERT INTO slk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Premýšľali teda a vraveli si: „Ale veď chlieb sme si nevzali.“ ");
INSERT INTO slk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ježiš čítal ich myšlienky, a preto im povedal: „Maloverní, prečo sa trápite pre jedlo? ");
INSERT INTO slk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ešte vždy nechápete? To ste už zabudli, ako som nasýtil päťtisíc mužov piatimi chlebmi, a koľko košov ste ešte nazbierali? ");
INSERT INTO slk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A čo tých štyritisíc, ktorých som nasýtil siedmimi chlebmi a ešte sa nazbieralo toľko zvyškov? ");
INSERT INTO slk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","To naozaj nechápete, o čom som vám hovoril? Nešlo mi o skutočný chlieb, keď som vás varoval pred kvasom farizejov a saducejov.“ ");
INSERT INTO slk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Až vtedy pochopili, že kvasom myslel nesprávne učenie židovských vodcov. ");
INSERT INTO slk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Keď sa potom Ježiš priblížil k Cézarey Filipovej, položil svojim učeníkom otázku: „Za koho ľudia pokladajú Syna človeka?“ ");
INSERT INTO slk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","„Niektorí za Jána Krstiteľa, iní za Eliáša, ďalší za Jeremiáša či niektorého z prorokov,“ odpovedali. ");
INSERT INTO slk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","„A vy? Kto som podľa vás?“ spýtal sa Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","„Ty si Kristus, Syn živého Boha!“ zvolal Šimon Peter. ");
INSERT INTO slk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","„Raduj sa, Šimon, syn Jonášov!“ povedal mu Ježiš. „To nemáš zo seba, tú pravdu ti zjavil môj Otec v nebesiach. ");
INSERT INTO slk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ty si Peter; a tak, ako sa dom buduje na skale, ja vybudujem svoju cirkev. Moc ríše smrti ju nepremôže. ");
INSERT INTO slk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dám ti kľúče od nebeského kráľovstva; na zemi odmietneš to, čo je odmietnuté v nebesiach a prijmeš to, čo je prijaté v nebesiach.“ ");
INSERT INTO slk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Svojim učeníkom potom prikázal, aby nikomu nehovorili, že on je očakávaný Mesiáš. ");
INSERT INTO slk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Od toho dňa začal Ježiš otvorene hovoriť s učeníkmi o tom, že musí ísť do Jeruzalema a čo ho tam čaká – mnoho si vytrpí od židovských náboženských vodcov, veľkňazov a zákonníkov, zabijú ho, ale na tretí deň vstane z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter ho odviedol nabok a začal mu to vyhovárať: „Nech ťa Boh pred tým ochráni, Pane! To sa ti nesmie stať!“ ");
INSERT INTO slk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ale on sa obrátil a povedal Petrovi: „Choď mi z cesty, satan! Pokúšaš ma, lebo nemyslíš na Božie veci, ale na ľudské.“ ");
INSERT INTO slk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Potom povedal učeníkom: „Kto ma chce nasledovať, nech prestane myslieť na seba, nech sa nebojí pre mňa trpieť a ide za mnou! ");
INSERT INTO slk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Komu ide len o jeho vlastný život, stratí ho. Ale kto je ochotný obetovať pre mňa život, získa ho. ");
INSERT INTO slk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Čo by z toho človek mal, keby získal hoci aj celý svet, ale stratil by skutočný život? Čo môže vyvážiť hodnotu večného života? ");
INSERT INTO slk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Syn človeka príde v sláve svojho Otca so svojimi anjelmi, a vtedy odplatí každému podľa toho, ako žil. ");
INSERT INTO slk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niektorí z vás ešte za svojho života uvidíte Syna človeka v jeho kráľovskej moci a sláve.“ ");
INSERT INTO slk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Po šiestich dňoch vzal Ježiš so sebou Petra, Jakuba a jeho brata Jána a vyšli na vysoký vrch, aby boli sami. ");
INSERT INTO slk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tam sa pred nimi premenil: tvár mu žiarila ako slnko a odev mu zbelel ako oslepujúce svetlo. ");
INSERT INTO slk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vtom uvideli Mojžiša a Eliáša, ako sa s ním zhovárajú. ");
INSERT INTO slk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter zvolal: „Pane, ako je nám tu dobre. Ak chceš, postavíme vám tu tri prístrešia, jeden tebe, druhý Mojžišovi, tretí Eliášovi.“ ");
INSERT INTO slk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kým to však dopovedal, zahalil ich oblak a počuli hlas: „Toto je môj milovaný Syn, moje potešenie, toho poslúchajte!“ ");
INSERT INTO slk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Keď to učeníci počuli, padli tvárami na zem a veľmi sa báli. ");
INSERT INTO slk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ježiš k nim prišiel, dotkol sa ich a povedal: „Vstaňte a nebojte sa!“ ");
INSERT INTO slk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Keď sa rozhliadli, videli iba Ježiša. ");
INSERT INTO slk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ako zostupovali z vrchu, rozkázal im: „Nikomu nevravte, čo ste videli, kým Syn človeka nevstane z mŕtvych!“ ");
INSERT INTO slk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Učeníci sa ho spytovali: „Prečo učitelia Zákona hovoria, že najprv má prísť Eliáš?“ ");
INSERT INTO slk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ježiš im odpovedal: „Majú pravdu. On má prísť a všetko pripraviť. ");
INSERT INTO slk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ale ja vám hovorím, že Eliáš už prišiel, ale oni ho nespoznali a veľmi zle s ním zaobchádzali. Tak bude trpieť aj Syn človeka.“ ");
INSERT INTO slk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Vtedy učeníci pochopili, že hovorí o Jánovi Krstiteľovi. ");
INSERT INTO slk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na úpätí vrchu čakal na nich veľký dav. Nejaký muž si kľakol pred Ježiša a prosil ho: ");
INSERT INTO slk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","„Pane, zľutuj sa nad mojím synom! Máva záchvaty a veľmi trpí. Neraz padne do ohňa alebo do vody. ");
INSERT INTO slk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Priviedol som ho k tvojim učeníkom, ale nevedeli mu pomôcť.“ ");
INSERT INTO slk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ježiš si vzdychol: „Čo je to s vami? Neveríte a prekážate Božej moci. Dokedy mám mať s vami trpezlivosť? Dokedy mám byť ešte s vami? Priveďte mi ho sem!“ ");
INSERT INTO slk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Potom Ježiš prikázal démonovi, aby z chlapca vystúpil. Démon vyšiel a chlapec bol odvtedy zdravý. ");
INSERT INTO slk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Keď potom učeníci s Ježišom osameli, spýtali sa ho: „Prečo sme ho nemohli vyhnať my?“ ");
INSERT INTO slk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ježiš im odpovedal: „Lebo málo veríte. Ak budete mať vieru aspoň takú ako horčičné semienko a poviete tomuto vrchu: ‚Posuň sa!‘, poslúchne vás. Nič pre vás nebude nemožné.“ ");
INSERT INTO slk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tento druh démonov je možné vyhnať iba modlitbou a pôstom. ");
INSERT INTO slk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Keď prišli do Galiley, Ježiš im povedal: „Syn človeka má byť vydaný do rúk tých, ktorí ho zabijú. ");
INSERT INTO slk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ale na tretí deň vstane z mŕtvych.“ Učeníkov to veľmi zarmútilo. ");
INSERT INTO slk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","V Kafarnaume prišli k Petrovi výbercovia chrámovej dane a spýtali sa ho: „Váš učiteľ neplatí daň?“ ");
INSERT INTO slk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","„Platí,“ odpovedal Peter. Len čo vošiel do domu, skôr než otvoril ústa, predišiel ho Ježiš otázkou: „Čo myslíš, Šimon, od koho vyberajú králi a panovníci dane a poplatky? Od synov alebo od cudzích?“ ");
INSERT INTO slk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","„Od cudzích,“ odpovedal Peter. „Tak vidíš,“ povedal Ježiš, „synovia sú teda oslobodení od tejto povinnosti. ");
INSERT INTO slk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ale nebudem ich zbytočne dráždiť. Choď k jazeru, hoď udicu a prvej rybe, ktorú chytíš, otvor ústa. Nájdeš v nich mincu. Zanes im ju a tá bude stačiť na poplatok za nás oboch.“ ");
INSERT INTO slk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tu obstúpili Ježiša jeho učeníci a spytovali sa ho: „Kto z ľudí je v nebeskom kráľovstve najdôležitejší?“ ");
INSERT INTO slk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zavolal malé dieťa, postavil ho medzi nich ");
INSERT INTO slk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a povedal: „Ubezpečujem vás, že ak nezmeníte svoje postoje a nebudete ako deti, do Božieho kráľovstva sa nikdy nedostanete. ");
INSERT INTO slk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kto sa pokorí na úroveň dieťaťa, ten bude v nebeskom kráľovstve najväčší. ");
INSERT INTO slk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kto by prijal jedno takéto dieťa v mojom mene, mňa prijíma. ");
INSERT INTO slk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kto by zlým príkladom zviedol na hriech jedného z týchto maličkých, čo veria vo mňa, tomu by sa lepšie stalo, keby ho hodili do mora s mlynským kameňom na krku. ");
INSERT INTO slk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Beda svetu, ak sa na ňom dejú veci, ktoré človeka zvádzajú na hriech. Aj keď pokušeniam sa vyhnúť na tomto svete nedá, beda tomu, kto ich spôsobuje! ");
INSERT INTO slk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ak ťa teda odvádza od Boha tvoja ruka alebo noha, radšej si ju odtni a zahoď. Lepšie je vstúpiť do Božieho kráľovstva chromý, ako skočiť oboma nohami do večnej záhuby. ");
INSERT INTO slk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A keby ťa aj tvoje oko navádzalo na zlé, zbav sa ho! Je lepšie získať večný život s jedným okom, než upadnúť s oboma očami do pekelného ohňa.“ ");
INSERT INTO slk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","„Dajte si pozor, aby ste nepohŕdali ani tými najobyčajnejšími ľuďmi. Lebo každý z nich má anjela, ktorý je stále v blízkosti môjho nebeského Otca. ");
INSERT INTO slk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Lebo Syn človeka prišiel zachrániť to, čo zahynulo. ");
INSERT INTO slk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ak má niekto sto oviec, a jedna z nich sa mu stratí, čo myslíte, že urobí? Či nenechá tých deväťdesiatdeväť na pastvinách a nepôjde hľadať tú, ktorá sa mu stratila? ");
INSERT INTO slk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A keď ju nájde, má z nej väčšiu radosť ako z tých deväťdesiatich deviatich, čo nezablúdili. ");
INSERT INTO slk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Práve tak nie je ani vôľou vášho nebeského Otca, aby zahynul čo i len jediný z týchto maličkých.“ ");
INSERT INTO slk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","„Ak sa previní proti tebe niektorý z bratov, vyhľadaj ho a pozhováraj sa s ním medzi štyrmi očami. Ak uzná svoju chybu, získal si znovu brata. ");
INSERT INTO slk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ak bude neústupný, pozvi si ešte jedného alebo dvoch, aby boli svedkami rozhovoru. ");
INSERT INTO slk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Keby si ani tak nedal povedať, povedz to zhromaždeniu veriacich. Ak neposlúchne ani ich, nech je vylúčený. ");
INSERT INTO slk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na zemi odmietnete to, čo je odmietnuté v nebesiach a prijmete to, čo je prijaté v nebesiach. ");
INSERT INTO slk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A takisto platí: Ak sa spoja dvaja z vás na modlitbách za akúkoľvek vec, nebeský Otec ich vypočuje. ");
INSERT INTO slk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Naozaj, tam, kde sa dvaja alebo traja zídu v mojom mene, tam som ja s nimi.“ ");
INSERT INTO slk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Potom sa ho Peter spýtal: „Pane, keď sa môj blížny proti mne stále prehrešuje, koľko ráz mu mám odpustiť? Až sedem ráz?“ ");
INSERT INTO slk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ježiš mu odpovedal: „Nie sedem ráz, ale až sedemdesiatkrát sedem ráz. ");
INSERT INTO slk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nebeské kráľovstvo sa totiž podobá kráľovi, ktorý sa rozhodol urobiť vyúčtovanie so svojimi poddanými. ");
INSERT INTO slk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Medzi prvými mu priviedli jedného, ktorý mu bol dlžný desaťtisíc talentov. ");
INSERT INTO slk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ten muž však nemal čím zaplatiť, preto kráľ prikázal, aby ho s celou rodinou predali do otroctva, speňažili jeho majetok, a tak uhradili aspoň časť dlžoby. ");
INSERT INTO slk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","On sa však hodil pred kráľa na kolená a prosil ho: ‚Pane, pozhovej mi a všetko ti vrátim!‘ ");
INSERT INTO slk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kráľovi prišlo toho človeka ľúto, nechal ho beztrestne odísť, ba odpustil mu aj celú dlžobu. ");
INSERT INTO slk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","No len čo ten muž odišiel od kráľa, stretol známeho, ktorý mu bol dlžný sto denárov. Schmatol ho a kričal: ‚Hneď mi vráť, čo si mi dlžný!‘ ");
INSERT INTO slk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ten chudák si pred ním kľakol a zúfalo ho prosil: ‚Pozhovej mi a všetko ti vrátim!‘ ");
INSERT INTO slk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ale veriteľ bol neoblomný a dal ho zavrieť do väzenia, kým dlžobu nezaplatí. ");
INSERT INTO slk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Svedkov tej udalosti to pobúrilo a šli to oznámiť kráľovi. ");
INSERT INTO slk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tu si ho kráľ dal zavolať a povedal mu: ‚Ty naničhodník! Takú veľkú dlžobu som ti odpustil, lebo si ma prosil. ");
INSERT INTO slk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nemohol si aj ty rovnako odpustiť svojmu druhovi?‘ ");
INSERT INTO slk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rozhnevaný kráľ ho potom dal zavrieť, kým celú dlžobu nezaplatí. ");
INSERT INTO slk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Takto bude zaobchádzať môj nebeský Otec s vami, ak nebudete ochotne odpúšťať svojim blížnym.“ ");
INSERT INTO slk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Po týchto slovách sa Ježiš pobral z Galiley do Judska na druhom brehu Jordánu. ");
INSERT INTO slk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Šli za ním veľké davy a on tam uzdravoval chorých. ");
INSERT INTO slk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Prišli za ním farizeji, aby ho pokúšali. Dali mu otázku: „Môže sa muž rozviesť s manželkou z akéhokoľvek dôvodu?“ ");
INSERT INTO slk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Odpovedal im: „Nečítali ste v Písme, že keď Boh na počiatku stvoril človeka, stvoril ho ako muža a ženu?“ ");
INSERT INTO slk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A pokračoval: „Preto muž opustí svojho otca i svoju matku a pripojí sa k svojej žene, aby sa tí dvaja stali jedným telom. ");
INSERT INTO slk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A preto nech nikto nerozdeľuje, čo Boh spojil.“ ");
INSERT INTO slk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ale oni namietali: „Prečo teda Mojžiš povedal, že muž môže prepustiť manželku jednoducho tým, že jej dá potvrdenie o rozvode?“ ");
INSERT INTO slk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ježiš odpovedal: „Toto ustanovenie Mojžišovho zákona je ústupkom tvrdosti vašich sŕdc. Pôvodný Boží úmysel to však nikdy nebol. ");
INSERT INTO slk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ja vám hovorím, že kto sa rozvedie s manželkou z iného dôvodu ako smilstvo a uzavrie nové manželstvo, sám sa dopustí cudzoložstva.“ ");
INSERT INTO slk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Učeníci mu na to povedali: „Ak to má byť takto, potom sa ani neoplatí ženiť.“ ");
INSERT INTO slk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Odpovedal im: „Pochopiť to môžu iba tí, ktorým to Boh umožní – nikto iný. ");
INSERT INTO slk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sú tri dôvody, aby človek zostal slobodný: Ak je na manželstvo telesne neschopný už od narodenia, ak mu v tom zabránili ľudia alebo ak sa manželstva sám zriekne pre bezvýhradnú službu Božej veci. Kto to môže pochopiť, nech pochopí.“ ");
INSERT INTO slk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Potom privádzali k Ježišovi malé deti, aby ich žehnal a modlil sa za ne. Učeníci však proti tomu rázne zakročili. ");
INSERT INTO slk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ježiš im povedal: „Nechajte ich a nebráňte im prichádzať ku mne, lebo takým ako ony patrí nebeské kráľovstvo.“ ");
INSERT INTO slk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kládol na ne ruky a žehnal ich. Potom odtiaľ odišiel. ");
INSERT INTO slk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Za Ježišom prišiel mladý človek a spýtal sa ho: „Majstre, čo mám robiť, aby som získal večný život?“ ");
INSERT INTO slk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ježiš mu povedal: „Prečo ma nazývaš dobrým? Naozaj dobrý je iba Boh. Ale ak chceš dosiahnuť večný život, riaď sa prikázaniami!“ ");
INSERT INTO slk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","„A ktorými?“ spýtal sa mladý človek. Ježiš mu odpovedal: „Nezabiješ; Nescudzoložíš; Nebudeš kradnúť; Nevydáš falošné svedectvo, ");
INSERT INTO slk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Budeš si ctiť otca a matku. A tiež: Milovať budeš svojho blížneho ako samého seba!“ ");
INSERT INTO slk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mládenec na to odpovedal: „Presne to som vždy robil. Čo mi ešte chýba?“ ");
INSERT INTO slk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ježiš mu povedal: „Ak chceš byť dokonalý, choď, predaj svoj majetok a peniaze rozdaj chudobným, a tak získaš poklad v nebi. Potom sa vráť a staň sa mojím učeníkom.“ ");
INSERT INTO slk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mladý muž po týchto slovách zosmutnel a sklamaný odišiel. Bol totiž veľmi bohatý. ");
INSERT INTO slk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ježiš potom povedal svojim učeníkom: „Bohatý len veľmi ťažko vojde do nebeského kráľovstva. ");
INSERT INTO slk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Keby som to mal prirovnať, ľahšie prejde ťava uchom ihly ako boháč do Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Učeníkov to veľmi prekvapilo a spytovali sa: „Kto teda môže byť vôbec zachránený?“ ");
INSERT INTO slk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ježiš sa na nich zahľadel a povedal: „V ľudských silách to nie je, ale u Boha je všetko možné.“ ");
INSERT INTO slk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tu sa ozval Peter a riekol: „My sme sa vzdali všetkého a ideme za tebou. Čo za to získame?“ ");
INSERT INTO slk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ježiš im odpovedal: „Ubezpečujem vás, že keď príde Syn človeka, aby nastolil nový svet, nad ktorým bude vládnuť v celej sláve, potom aj vy, ktorí ma nasledujete, budete sedieť po mojom boku na dvanástich trónoch ako sudcovia dvanástich izraelských kmeňov. ");
INSERT INTO slk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A každému, kto sa vzdá domova, bratov, sestier, otca, matky, detí alebo majetku preto, aby šiel za mnou, dostane stonásobne viac a ako dedičstvo získa večný život. ");
INSERT INTO slk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ale mnohí prví budú poslední a poslední budú prví.“ ");
INSERT INTO slk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","„S nebeským kráľovstvom je to totiž podobné ako s hospodárom, ktorý si šiel zavčasu ráno najať robotníkov na svoju vinicu. ");
INSERT INTO slk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dohodol sa s nimi na dennej mzde jedného denára a poslal ich pracovať. ");
INSERT INTO slk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Približne o deviatej šiel opäť na trh, kde sa najímali nádenníci, a videl tam postávať aj ďalších, ktorí čakali na prácu. ");
INSERT INTO slk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Povedal im teda: ‚Choďte aj vy na moju vinicu a dostanete mzdu, ktorá vám patrí.‘ A oni šli. ");
INSERT INTO slk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Potom opäť šiel na to miesto ešte okolo poludnia a asi tak o tretej popoludní a najal ďalších robotníkov. ");
INSERT INTO slk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","V podvečer tam videl niektorých postávať a spýtal sa ich: ‚Prečo tu tak nečinne celý deň stojíte?‘ ");
INSERT INTO slk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‚Nikto nás nenajal do práce‘, odpovedali. On im na to riekol: ‚Choďte aj vy na moju vinicu.‘ ");
INSERT INTO slk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Večer potom prikázal majiteľ vinice svojmu správcovi: ‚Zavolaj robotníkov a zaplať im za prácu. Začni tými, čo nastúpili do práce poslední.‘ ");
INSERT INTO slk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tí, ktorých najal do práce až podvečer, dostali po denári. ");
INSERT INTO slk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Robotníci, ktorí pracovali od rána, sa domnievali, že dostanú viac. Ale dostali takú istú mzdu – jeden denár. ");
INSERT INTO slk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Keď ho vzali, začali sa na hospodára sťažovať: ");
INSERT INTO slk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‚Tí, ktorí prišli poslední, pracovali iba hodinu a dostali presne toľko ako my, čo sme lopotili celý deň v slnečnej páľave!‘ ");
INSERT INTO slk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Majiteľ vinice sa obrátil k jednému z nich a povedal: ‚Priateľ môj, nekrivdím ti. Či sme sa vopred nedohodli na dennej mzde? ");
INSERT INTO slk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dostal si svoje, ja chcem zaplatiť tomu poslednému toľko ako tebe. ");
INSERT INTO slk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Podľa teba nemám právo vyplatiť každému, koľko uznám za vhodné? Alebo sa ti nezdá moja dobrota?‘ ");
INSERT INTO slk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","A tak poslední budú prví a prví poslední.“ ");
INSERT INTO slk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cestou do Jeruzalema si Ježiš zavolal nabok svojich dvanástich učeníkov a hovoril im: ");
INSERT INTO slk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Vystupujeme do Jeruzalema, kde Syna človeka vydajú veľkňazom a zákonníkom. Tí ho odsúdia na trest smrti ");
INSERT INTO slk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","a vydajú Rimanom, aby ho zosmiešnili, zbičovali a ukrižovali. Ale na tretí deň vstane z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vtedy k nemu pristúpila Zebedejova manželka so svojimi synmi Jakubom a Jánom. Úctivo sa klaňala a chcela predniesť svoju prosbu. ");
INSERT INTO slk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ježiš sa jej opýtal: „Čo si želáš?“ Povedala mu: „Sľúb mi, že dáš mojim synom najčestnejšie miesta po svojom boku, keď sa ujmeš vlády vo svojom kráľovstve.“ ");
INSERT INTO slk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ale Ježiš povedal: „Neviete, čo žiadate! Či môžete piť z kalicha utrpenia, ktorý je pripravený pre mňa?“ „Áno, môžeme!“ odpovedali. ");
INSERT INTO slk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","„Z môjho kalicha piť budete, ale miesta po mojej pravici a ľavici neurčujem ja. Dostanú ich tí, ktorým to pripravil môj Otec,“ povedal im Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ostatní desiati počuli tento rozhovor a nahnevali sa na Jakuba a Jána. ");
INSERT INTO slk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ale Ježiš si ich všetkých zavolal k sebe a povedal im: „Viete, že panovníci tvrdo vládnu nad národmi a tí, ktorí majú moc, dávajú ju pociťovať ostatným. ");
INSERT INTO slk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ale medzi vami to musí byť celkom inak. Kto chce byť veľkým, nech slúži druhým ");
INSERT INTO slk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","a kto chce byť prvý, nech sa stane sluhom všetkých. ");
INSERT INTO slk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Veď ani Syn človeka neprišiel, aby si dal slúžiť, ale aby slúžil a obetoval svoj život ako výkupné za všetkých ľudí.“ ");
INSERT INTO slk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Keď Ježiš s učeníkmi vychádzal z Jericha, uberal sa za ním obrovský dav. ");
INSERT INTO slk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na kraji cesty sedeli dvaja slepci, a keď začuli, že tade prechádza Ježiš, začali kričať: „Zmiluj sa nad nami, Pane, syn Dávidov!“ ");
INSERT INTO slk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dav ich okrikoval, aby mlčali. Ale oni volali ešte hlasnejšie: „Pane, syn Dávidov, zmiluj sa nad nami!“ ");
INSERT INTO slk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Keď sa Ježiš priblížil k nim, zastal, zavolal ich k sebe a spýtal sa: „Čo chcete, aby som pre vás urobil?“ ");
INSERT INTO slk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","„Pane, chceme vidieť!“ odpovedali. ");
INSERT INTO slk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ježišovi ich prišlo ľúto a dotkol sa ich očí. V tej chvíli začali vidieť – a šli za ním. ");
INSERT INTO slk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Keď sa priblížili k Jeruzalemu a prišli do dediny Betfage na Olivovom vrchu, poslal Ježiš dvoch učeníkov napred ");
INSERT INTO slk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a povedal im: „Choďte do dediny, ktorá je pred vami. Nájdete tam priviazanú oslicu aj s osliatkom. Odviažte ich a priveďte sem. ");
INSERT INTO slk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Keby sa vás niekto spýtal, čo to robíte, povedzte: Pán ich potrebuje. A ten človek ich sám pošle.“ ");
INSERT INTO slk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tak sa začalo plniť to, čo predpovedal prorok: ");
INSERT INTO slk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Povedzte Jeruzalemu: Tvoj kráľ prichádza k tebe, tichý a sediaci na osliatku!“ ");
INSERT INTO slk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Učeníci šli a vykonali všetko podľa Ježišovho príkazu. ");
INSERT INTO slk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Priviedli oslicu aj osliatko, namiesto sedla položili svoje plášte a on sa na ne posadil. ");
INSERT INTO slk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mnohí z davu prestierali na cestu svoje plášte, iní osekávali vetvičky zo stromov a zdobili nimi cestu. ");
INSERT INTO slk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sprievod ľudí, ktorý ho obklopoval spredu aj zozadu, volal: „Hosana Synovi Dávidovmu! Nech Boh požehná toho, ktorý prichádza v jeho mene! Hosana na výsostiach!“ ");
INSERT INTO slk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Keď Ježiš vošiel do Jeruzalema, celé mesto zachvátilo vzrušenie a ľudia sa spytovali: „Kto je to?“ ");
INSERT INTO slk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A z davu sa ozývalo: „To je Ježiš, prorok z galilejského Nazareta!“ ");
INSERT INTO slk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Potom Ježiš vošiel do chrámu a vyhnal všetkých, ktorí tu predávali a kupovali. Poprevracal stoly peňazomencom, stánky predavačom holubov ");
INSERT INTO slk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","a povedal im: „Je napísané – Môj dom bude známy ako miesto modlitby, ale vy ste z neho urobili brloh lotrov!“ ");
INSERT INTO slk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na chrámovom nádvorí sa okolo neho zhŕkli slepí a chromí a on ich uzdravoval. ");
INSERT INTO slk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ale keď veľkňazi a učitelia Zákona videli tie zázraky a počuli, že aj deti volajú v chráme: „Sláva synovi Dávidovmu!“ veľmi ich to pobúrilo. ");
INSERT INTO slk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Vyčítali mu: „Nepočuješ, čo volajú?“ Odpovedal im: „Pravdaže. Azda ste nečítali, že ho budú chváliť aj dojčatá a malé deti?“ ");
INSERT INTO slk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nato ich nechal a odišiel do Betánie, kde prenocoval. ");
INSERT INTO slk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Keď sa ráno vracal do Jeruzalema, pocítil hlad. ");
INSERT INTO slk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pri ceste si všimol figovník, ale keď prišiel k nemu, nenašiel na ňom nijaké plody, iba lístie. Povedal: „Už nikdy sa na tebe neurodí ovocie!“ A figovník naozaj uschol. ");
INSERT INTO slk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Keď to učeníci videli, prekvapene zvolali: „Ako rýchlo ten figovník vyschol!“ ");
INSERT INTO slk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ježiš im odpovedal: „Hovorím vám, ak budete veriť bez pochybovania, môžete robiť aj väčšie veci, ako ste teraz videli. Ak rozkážete tomuto vrchu, posuň sa a hoď sa do mora, stane sa. ");
INSERT INTO slk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A dostanete všetko, za čo sa s vierou budete modliť.“ ");
INSERT INTO slk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Keď potom zasa učil v chráme, prišli k nemu veľkňazi a poprední židovskí vodcovia a spýtali sa ho: „Akým právom robíš to, čo robíš? Kto ťa tým poveril?“ ");
INSERT INTO slk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","„Poviem vám to,“ odvetil Ježiš, „ale najprv odpovedzte vy na moju otázku: ");
INSERT INTO slk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Keď Ján krstil, od koho mal poverenie? Od Boha alebo od ľudí?“ Začali sa radiť: „Ak povieme, že ho poveril Boh, spýta sa nás, prečo sme mu neuverili. ");
INSERT INTO slk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","No ak povieme, že ľudia, budeme sa musieť báť ľudu, lebo všetci pokladajú Jána za proroka.“ ");
INSERT INTO slk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A tak mu napokon odpovedali. „Nevieme.“ Povedal im: „Ani ja vám nepoviem, kto mi dal moc konať to, čo konám.“ ");
INSERT INTO slk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","„No ako by ste rozsúdili tento prípad: Istý muž mal dvoch synov a jednému z nich povedal: ‚Syn môj, choď dnes pracovať na vinicu!‘ ");
INSERT INTO slk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Syn však odpovedal: ‚Nechce sa mi.‘ Ale potom si to rozmyslel a šiel. ");
INSERT INTO slk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","O to isté požiadal druhého syna. Ten odpovedal: ‚Áno, pôjdem!‘ Ale nešiel. ");
INSERT INTO slk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ktorý z dvoch synov poslúchol svojho otca?“ Odpovedali: „Ten prvý.“ „Práve tak aj vás,“ odpovedal Ježiš, „podvodníci a prostitútky predbiehajú do Božieho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ján Krstiteľ vám ukázal správnu cestu pokánia, ale vy ste mu neuverili, no títo áno. Videli ste to, ale ani potom ste sa nekajali a neuverili ste mu.“ ");
INSERT INTO slk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","„Teraz si vypočujte iné podobenstvo: Istý hospodár vysadil vinicu. Ohradil ju plotom, vykopal v nej lis a vystaval strážnu vežu. Potom vinicu prenajal vinohradníkom a vydal sa na cesty. ");
INSERT INTO slk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Keď sa priblížil čas oberačky, poslal k vinohradníkom svojich sluhov, aby prevzali jeho diel úrody. ");
INSERT INTO slk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ale vinohradníci pochytali sluhov, jedného zmlátili, druhého zabili a tretieho ukameňovali. ");
INSERT INTO slk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hospodár poslal ďalších sluhov. Bolo ich ešte viac ako predtým, ale aj s tými naložili rovnako. ");
INSERT INTO slk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Napokon poslal k nim vlastného syna. Myslel si, že aspoň jeho budú brať vážne. ");
INSERT INTO slk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ale keď ho vinohradníci videli prichádzať, povedali si: ‚To je dedič! Zabime ho a vinica bude naša!‘ ");
INSERT INTO slk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Zmocnili sa ho, vyvliekli ho z vinice a zabili. ");
INSERT INTO slk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Čo myslíte, že s nimi urobí majiteľ po svojom návrate?“ ");
INSERT INTO slk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Odpovedali mu: „Dá tých zlosynov bez milosti popraviť a vinicu prenajme ľuďom, ktorí mu budú svedomito odvádzať úrodu.“ ");
INSERT INTO slk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Potom im povedal: „Či poznáte slová Písma: ‚Kameň, ktorý stavitelia zavrhli, stal sa kameňom základným, najdôležitejším v celej stavbe. Urobil to Pán a z nášho pohľadu je to čosi obdivuhodné.‘ ");
INSERT INTO slk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chcem tým povedať, že Boh vám svoje kráľovstvo odníme a zverí ho ľuďom, ktorí budú prinášať jeho ovocie. ");
INSERT INTO slk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Každý, kto na ten kameň spadne, doláme sa, ale na koho spadne, toho rozdrví.“ ");
INSERT INTO slk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Keď veľkňazi a farizeji počuli tieto podobenstvá, pochopili, že hovorí o nich. ");
INSERT INTO slk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chceli ho chytiť, ale báli sa davu, lebo všetci pokladali Ježiša za proroka. ");
INSERT INTO slk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ježiš im vyrozprával ďalšie podobenstvo o nebeskom kráľovstve. ");
INSERT INTO slk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„S nebeským kráľovstvom je to totiž podobné ako s kráľom, ktorý vystrojil svojmu synovi svadbu. Pozval veľa hostí, a keď bola svadobná hostina pripravená, ");
INSERT INTO slk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","poslal sluhov, aby ich priviedli, ale hostia odmietli prísť. ");
INSERT INTO slk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Preto poslal ešte raz sluhov s odkazom: ‚Slávnostná hostina je pre vás pripravená, poponáhľajte sa!‘ ");
INSERT INTO slk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ale pozvaní jeho odkaz nebrali vážne. Jeden odišiel na pole, iný za obchodom, ");
INSERT INTO slk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","podaktorí sa dokonca zmocnili kráľových poslov, zbili ich a niekoľkých aj zabili. ");
INSERT INTO slk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","To kráľa rozhnevalo, poslal oddiely vojska, dal vrahov pobiť a ich mesto vypáliť. ");
INSERT INTO slk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Vtedy povedal svojim poslom: ‚Svadobná hostina je pripravená, ale pozvaní hostia jej neboli hodní. ");
INSERT INTO slk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Choďte na križovatky za mestom, kde je veľa ľudí a pozvite na svadbu každého, koho stretnete.‘ ");
INSERT INTO slk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Poslovia teda šli a priviedli všetkých, ktorých stretli, dobrých aj zlých, takže sa svadobná sieň naplnila. ");
INSERT INTO slk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Keď vstúpil kráľ, aby privítal hostí, zazrel jedného, ktorý si neobliekol pripravené svadobné šaty. ");
INSERT INTO slk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‚Priateľ môj, ako si sa odvážil prísť bez svadobného odevu?‘ vyčítal mu. Ten nevedel, čo má odpovedať. ");
INSERT INTO slk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Vtedy kráľ rozkázal sluhom: ‚Poviažte ho a vyhoďte von do tmy. Tam bude len nárek a utrpenie. ");
INSERT INTO slk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Lebo všetci sú pozvaní do Božieho kráľovstva, ale Boh prijme len tých, ktorí prijali jeho pozvanie.‘ “ ");
INSERT INTO slk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farizeji sa stretli a dohodli, čo urobia, aby Ježiša prichytili pri slovách, ktoré by potom mohli použiť na jeho obžalobu. ");
INSERT INTO slk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Poslali k nemu svojich žiakov spolu s Herodesovými stúpencami a tí povedali: „Majstre, vieme, že si čestný a že pravdivo učíš ceste k Bohu bez ohľadu na to, aké má kto postavenie. ");
INSERT INTO slk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tak nám teda povedz: je správne odvádzať rímskemu cisárovi daň?“ ");
INSERT INTO slk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ale Ježiš postrehol ich zlý úmysel a povedal: „Vy pokrytci! Chcete ma dobehnúť? ");
INSERT INTO slk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ukážte mi mincu, ktorou sa platí daň!“ Podali mu denár. ");
INSERT INTO slk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","„Koho obraz a meno sú na ňom vyrazené?“ ");
INSERT INTO slk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","„Cisárove,“ odpovedali. „Tak teda dávajte cisárovi, čo je cisárovo, a čo je Božie, dávajte Bohu,“ povedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zaskočení tou odpoveďou ho nechali tak a odišli. ");
INSERT INTO slk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","V ten deň za ním prišli aj saduceji, ktorí tvrdia, že vzkriesenie z mŕtvych nie je možné, a spýtali sa ho: ");
INSERT INTO slk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","„Majstre, v Mojžišovom zákone čítame, že ak zomrie muž, ktorého manželstvo bolo bezdetné, jeho brat je povinný oženiť sa s vdovou a splodiť bratovi potomka, aby sa zachoval jeho rod. ");
INSERT INTO slk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","U nás sa vyskytol takýto prípad: Bolo sedem bratov. Prvý sa oženil a potom bezdetný umrel, takže jeho žena sa stala manželkou druhého brata. ");
INSERT INTO slk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aj tento umrel bezdetný a takto sa to opakovalo aj s tretím až po siedmeho. ");
INSERT INTO slk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Napokon umrela aj žena. ");
INSERT INTO slk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ktorému z tých bratov bude po vzkriesení patriť? Bola predsa manželkou všetkých siedmich!“ ");
INSERT INTO slk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ježiš im odpovedal: „Klamete sami seba, lebo nepoznáte ani Písmo, ani Božiu moc. ");
INSERT INTO slk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Po vzkriesení sa ľudia nebudú ženiť ani vydávať. Budú ako anjeli v nebi, ktorí sa nesobášia. ");
INSERT INTO slk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A čo sa týka vzkriesenia z mŕtvych, pozorne čítajte Písmo. Ako nazýva Boh sám seba? ");
INSERT INTO slk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja som Boh Abrahámov, Boh Izákov a Boh Jákobov. On nie je Bohom mŕtvych, ale živých.“ ");
INSERT INTO slk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tieto odpovede urobili na dav hlboký dojem. ");
INSERT INTO slk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ale keď sa farizeji dopočuli, ako Ježiš umlčal saducejov, zišli sa ");
INSERT INTO slk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","a poverili jedného zo znalcov Zákona, aby ho pokúšal: ");
INSERT INTO slk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Majstre, ktoré je najväčšie prikázanie v Zákone?“ ");
INSERT INTO slk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ježiš mu odpovedal: „Miluj Pána, svojho Boha, celým srdcom, celou dušou aj mysľou. ");
INSERT INTO slk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","To je prvé a najdôležitejšie prikázanie. ");
INSERT INTO slk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Druhé je mu podobné: Miluj svojho blížneho ako samého seba. ");
INSERT INTO slk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tieto dve prikázania v sebe zahŕňajú celý Mojžišov zákon aj učenie prorokov.“ ");
INSERT INTO slk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Keď sa farizeji zhromaždili, Ježiš sa ich opýtal: ");
INSERT INTO slk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Čo si myslíte o Mesiášovi? Čí syn je?“ Odpovedali mu: „Dávidov.“ ");
INSERT INTO slk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Povedal im: „Ako to, že ho potom Dávid vedený Duchom volá svojím Pánom, keď hovorí: ");
INSERT INTO slk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‚Boh povedal môjmu Pánovi: Seď po mojej pravici, kým ti nepoložím tvojich nepriateľov k nohám?‘ ");
INSERT INTO slk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ak ho Dávid volá Pánom, ako môže byť aj jeho synom?“ ");
INSERT INTO slk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nevedeli mu odpovedať ani slovo. Od toho dňa sa už nikto neodvážil nachytať ho nejakými otázkami. ");
INSERT INTO slk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Vtedy Ježiš oslovil zhromaždené davy a učeníkov: ");
INSERT INTO slk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Učitelia a farizeji majú autoritu vysvetľovať Mojžišov zákon. ");
INSERT INTO slk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Počúvajte všetky ich príkazy, ale neberte si príklad z ich života, lebo ich slová sa rozchádzajú s činmi. ");
INSERT INTO slk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Zväzujú a kladú na vás ťažké bremená, ale sami pre vás nie sú ochotní ani len prstom pohnúť. ");
INSERT INTO slk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A všetko, čo robia, robia len preto, aby ich ľudia obdivovali. Aby vyzerali sväto, zadovažujú si nápadné znaky zbožnosti: rozširujú si modlitebné remienky a predlžujú strapce na odeve, ");
INSERT INTO slk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","majú radi čestné miesta na hostinách aj pri bohoslužbách. ");
INSERT INTO slk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Veľmi sa im páči, keď ich ľudia pozdravujú na verejných miestach a každého z nich oslovujú: Učiteľu! ");
INSERT INTO slk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ale vy sa nedávajte takto titulovať, lebo len jeden je váš Učiteľ a vy všetci ste navzájom bratia. ");
INSERT INTO slk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A nikoho z ľudí neoslovujte otec, lebo máte jediného Otca, a ten je v nebi. ");
INSERT INTO slk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ani sa nepokladajte za najvyššiu autoritu, lebo len jeden je váš vodca – Kristus. ");
INSERT INTO slk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Najväčší medzi vami je ten, kto slúži všetkým. ");
INSERT INTO slk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kto si o sebe priveľa namýšľa, bude ponížený, no kto je pokornej mysle, bude povýšený. ");
INSERT INTO slk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Beda vám, učitelia Zákona a farizeji! Ste pokrytci! Zatvárate ľuďom vstup do nebeského kráľovstva. Sami doň nevchádzate a tým, ktorí by chceli vstúpiť, bránite! ");
INSERT INTO slk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Beda vám, učitelia Zákona a farizeji! Ste pokrytci! Pod pláštikom dlhých modlitieb ste schopní vymámiť peniaze aj od vdov. Ťažko vám bude na súde! ");
INSERT INTO slk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Beda vám, učitelia Zákona a farizeji, pokrytci! Zašli by ste aj na kraj sveta, len aby ste jedného človeka obrátili, no len čo uverí, vlastným chápaním zbožnosti z neho urobíte syna pekla dva razy horšieho od vás. ");
INSERT INTO slk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Beda vám, slepí vodcovia! Vravíte, že prísaha na chrám nezaväzuje, ale prísaha na chrámové zlato áno. ");
INSERT INTO slk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Akí ste len hlúpi! Čo je viac? Zlato alebo chrám, ktorý to zlato posväcuje? ");
INSERT INTO slk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Alebo hovoríte: Prísaha na obetný oltár nič neznamená, kým prísaha na obeť sa musí plniť. ");
INSERT INTO slk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Akí ste slepí! Čo je viac? Dar, ktorý je na oltári, alebo oltár, ktorý ho posväcuje? ");
INSERT INTO slk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ak teda prisaháte na oltár, prisaháte aj na všetko, čo je na ňom. ");
INSERT INTO slk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A ak prisaháte na chrám, prisaháte aj na toho, kto v ňom prebýva. ");
INSERT INTO slk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A ak prisaháte na nebo, prisaháte na Boží trón i na toho, kto na ňom sedí. ");
INSERT INTO slk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Beda vám, učitelia Zákona a farizeji. Ste obyčajní pokrytci! Dávate desiatky z mäty, kôpru a rasce, ale nedbáte na to, čo Boh pokladá v zákone za dôležitejšie: aby ste konali spravodlivo, milosrdne a verne. Na tom vám malo záležať! Desiatky – to je samozrejmosť. ");
INSERT INTO slk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Slepí vodcovia! Dávate si pozor, aby ste neprehltli komára, ale ťavu zjete. ");
INSERT INTO slk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Beda vám, učitelia Zákona a farizeji, pokrytci! Starostlivo čistíte povrch nádob, ale vnútrajšok napĺňate tým, čo ste vo svojej chamtivosti nazhŕňali. ");
INSERT INTO slk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Slepí farizeji, najprv vyčistite vnútrajšok nádoby, iba potom bude naozaj čistá. ");
INSERT INTO slk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Beda vám, učitelia Zákona a farizeji, pokrytci! Podobáte sa bielo vymaľovaným hrobom, ktoré síce zvonka vyzerajú krásne, ale dnu sú iba kosti mŕtvych, hniloba a nečistoty. ");
INSERT INTO slk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Usilujete sa vyzerať pred ľuďmi sväto, ale pod zbožným zovňajškom sa skrývajú srdcia plné pretvárky a nespravodlivosti. ");
INSERT INTO slk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Beda vám, učitelia Zákona a farizeji, pokrytci! Prorokom staviate pomníky, zdobíte hroby mučeníkov ");
INSERT INTO slk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","a hovoríte: keby sme my boli žili v čase našich otcov, neboli by sme spolu s nimi prelievali krv prorokov. ");
INSERT INTO slk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Takto svedčíte sami proti sebe, že ste synovia tých, ktorí zabíjali prorokov. ");
INSERT INTO slk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Choďte v ich šľapajach a dovŕšte ich dielo. ");
INSERT INTO slk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Vy ľstivé hadie plemeno! Ako chcete uniknúť pekelnému trestu? ");
INSERT INTO slk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pošlem vám prorokov, múdrych ľudí a vykladačov Písma. Vy ich však budete bičovať vo svojich synagógach a hnať z mesta do mesta, mnohých zabijete, iných ukrižujete. ");
INSERT INTO slk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na vás padne vina za všetku preliatu krv nevinných od spravodlivého Ábela až po Zachariáša, syna Barachiášovho, ktorého ste zavraždili medzi budovou chrámu a miestom, kam sa prinášajú obete. ");
INSERT INTO slk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Áno, naozaj vám vravím, že toto všetko padne na hlavu ľudí, ako ste vy. ");
INSERT INTO slk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruzalem, Jeruzalem, mesto, ktoré zabíjaš prorokov a kameňuješ tých, čo Boh k tebe posiela! Koľko ráz som túžil zhromaždiť tvoje deti, ako kvočka zhromažďuje kuriatka pod svoje krídla, ale nechceli ste. ");
INSERT INTO slk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Odteraz bude váš dom pustý. ");
INSERT INTO slk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A vravím vám, že ma uvidíte až vtedy, keď poviete: ‚Nech je požehnaný ten, ktorý prichádza v Božom mene!‘ “ ");
INSERT INTO slk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Keď Ježiš vychádzal z chrámu, pristúpili k nemu učeníci a nadchýnali sa stavbami chrámového komplexu. ");
INSERT INTO slk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ale on im povedal: „Vidíte toto všetko? Pamätajte si, všetko to bude zničené, nezostane tu kameň na kameni.“ ");
INSERT INTO slk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","„Kedy sa to stane?“ spýtali sa ho učeníci, keď sa usadili na svahu Olivového vrchu. „Ktoré udalosti budú znamením tvojho príchodu a konca sveta?“ ");
INSERT INTO slk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ježiš im odpovedal: „Buďte v strehu, nedajte sa nikým oklamať. ");
INSERT INTO slk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lebo mnohí prídu v mojom mene, budú sa vyhlasovať za mesiášov a mnohých zvedú. ");
INSERT INTO slk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na viacerých miestach vypuknú vojny a nepokoje. Keď sa o tom dozviete a budete počuť o ich následkoch, neľakajte sa. To všetko musí prísť, ale koniec nenastane hneď. ");
INSERT INTO slk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Národy a krajiny budú proti sebe bojovať. Na rôznych miestach bude zúriť hlad a vyskytnú sa zemetrasenia. ");
INSERT INTO slk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ale to bude len počiatok hrôz. ");
INSERT INTO slk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Vtedy vás budú všade nenávidieť, trýzniť, ba aj zabíjať – a to len preto, že ste sa hlásili ku mne. ");
INSERT INTO slk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Niektorí toto násilie nevydržia, zradia vieru aj svojich spolubratov a navzájom sa budú nenávidieť. ");
INSERT INTO slk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Zjavia sa aj rôzni falošní proroci a mnohých zvedú. ");
INSERT INTO slk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na svete sa tak rozmnoží zlo, že vychladne láska mnohých. ");
INSERT INTO slk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ale ten, kto vytrvá až do konca, bude zachránený. ");
INSERT INTO slk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Radostnú správu o tom, že Boh vládne a všetkých volá k sebe, musia počuť ľudia na celom svete – aby k nej mohli zaujať svoj postoj. A potom príde koniec.“ ");
INSERT INTO slk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","„Keď uvidíte, že chrámu v Jeruzaleme hrozí zneuctenie od pohanov, ako to predpovedal prorok Daniel – kto ho čítate, premýšľajte a porozumiete –, ");
INSERT INTO slk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","vtedy tí, ktorí budú v Judsku, nech utečú do hôr. ");
INSERT INTO slk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kto bude na streche domu, nech nevstupuje dnu, aby si niečo vzal. ");
INSERT INTO slk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A ten, čo bude za mestom, nech sa nevracia po plášť. ");
INSERT INTO slk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ťažko bude v tých dňoch tehotným ženám a matkám dojčiat. ");
INSERT INTO slk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Proste Boha, aby ste nemuseli utekať v zime alebo v sobotu. ");
INSERT INTO slk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nastane totiž strašné utrpenie, aké tu od stvorenia sveta ešte nebolo a už ani nebude. ");
INSERT INTO slk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ale Boh kvôli svojim vyvoleným skráti toto hrozné obdobie. Keby tak neurobil, nik by sa nezachránil. ");
INSERT INTO slk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Keby vám niekto hovoril: ‚Pozrite, prišiel Mesiáš‘ alebo: ‚Aha, tam je‘, neverte mu! ");
INSERT INTO slk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lebo sa objavia falošní mesiáši a falošní proroci a budú robiť ohromujúce znamenia a zázraky, ktorými sa budú snažiť zviesť aj tých, čo patria Bohu. ");
INSERT INTO slk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pamätajte na toto moje varovanie. ");
INSERT INTO slk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A tak, keď vám povedia, že Kristus je už tu, na púšti alebo niekde v úkryte, nič na to nedajte, ani sa nechoďte o tom presvedčiť. ");
INSERT INTO slk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Lebo príchod Syna človeka bude zjavný, ako keď blesk preletí celým nebom od východu až na západ. ");
INSERT INTO slk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kde je mŕtvola, tam sa zlietajú aj supy. ");
INSERT INTO slk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hneď po tomto veľkom utrpení sa zatmie slnko, pohasne svit mesiaca, hviezdy začnú padať z neba a zachvejú sa nebeské mocnosti. ");
INSERT INTO slk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A potom sa zjavia na nebi znamenia príchodu Syna človeka. Všetci ľudia budú zdesene nariekať a uvidia Syna človeka prichádzať na nebeských oblakoch s veľkou mocou a slávou. ");
INSERT INTO slk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","S mohutným zvukom poľnice pošle svojich poslov a tí zhromaždia jeho verných zo všetkých svetových strán, od jedného konca zeme po druhý.“ ");
INSERT INTO slk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","„Poučte sa z tohto podobenstva: Keď sa konáre figovníka nalievajú miazgou a pučia listy, viete, že čoskoro bude leto. ");
INSERT INTO slk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A tiež, keď uvidíte, že sa plní, čo som predpovedal, poznáte, že je blízko, predo dvermi. ");
INSERT INTO slk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Je to tak – svet nepominie, kým sa to všetko nestane. ");
INSERT INTO slk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nebo a zem pominú, ale moje slová budú platiť večne. ");
INSERT INTO slk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","O tom dni a o tej hodine však nevie nikto, ani anjeli v nebi, ani Syn. Iba Otec to vie. ");
INSERT INTO slk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pri príchode Syna človeka bude život na zemi podobný, ako bol za čias Noacha. ");
INSERT INTO slk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Život pred potopou plynul celkom normálne – ľudia jedli, pili, ženili sa a vydávali až do toho dňa, keď Noe vstúpil do korábu. ");
INSERT INTO slk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ľudia neverili tomu, čo im hrozilo, kým ich nezmietla potopa. Tak to bude aj pri príchode Syna človeka. ");
INSERT INTO slk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dvaja budú spolu pracovať na poli, jeden bude vzatý, druhý zostane. ");
INSERT INTO slk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dve ženy budú mlieť, jedna bude vzatá, druhá zostane. ");
INSERT INTO slk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Buďte teda pripravení, lebo neviete, kedy váš Pán príde. ");
INSERT INTO slk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Uvedomte si, že keby pán domu vedel, v ktorú nočnú hodinu príde zlodej, bdel by a zabránil by mu vtrhnúť do domu. ");
INSERT INTO slk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Preto aj vy buďte pripravení na príchod Syna človeka. Príde vtedy, keď to budete najmenej čakať. ");
INSERT INTO slk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ako sa správa verný a prezieravý sluha, ktorého pán poveril, aby sa staral o ostatné služobníctvo? ");
INSERT INTO slk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ak pán pri svojom príchode zistí, že verne plnil zverené povinnosti, pochváli ho ");
INSERT INTO slk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","a urobí ho správcom celého svojho majetku. ");
INSERT INTO slk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ale nesvedomitý sluha by si mohol pomyslieť: ‚Môj pán akosi dlho nechodí‘, ");
INSERT INTO slk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a začal by týrať svojich druhov a hodovať s opilcami. ");
INSERT INTO slk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jeho pán sa vráti nečakane – v deň a hodinu, keď to nepredpokladal ");
INSERT INTO slk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","a potrestá ho ako najväčšieho podvodníka; vyženie ho tam, kde bude plač a škrípanie zubami.“ ");
INSERT INTO slk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","„Vtedy sa nebeské kráľovstvo bude podobať desiatim družičkám, ktoré čakali na ženícha, aby ho sprevádzali svetlom svojich lámp. ");
INSERT INTO slk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Päť z nich bolo ľahkomyseľných a päť prezieravých. ");
INSERT INTO slk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ľahkomyseľné si vzali lampy, ale nádoby s olejom nechali doma. ");
INSERT INTO slk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","No tie, čo to brali vážne, vzali si nielen lampy, ale aj nádoby s olejom. ");
INSERT INTO slk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ženích dlho neprichádzal, a tak všetky družičky premohli driemoty a zaspali. ");
INSERT INTO slk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","O polnoci ich vytrhol zo spánku výkrik: ‚Prichádza ženích, poďte ho privítať!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Všetky dievčatá vyskočili a pripravovali si lampy. ");
INSERT INTO slk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tie ľahkomyseľné si pýtali od ostatných: ‚Dajte nám trochu oleja, lebo nám vyhasínajú lampy!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ale rozumné im odpovedali: ‚Keď sa rozdelíme, nevystačí olej ani vám, ani nám. Zabehnite radšej k predavačovi a kúpte si.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No len čo sa vzdialili, prišiel ženích a družičky, ktoré boli pripravené, šli s ním na svadobnú hostinu; a dvere sa zavreli. ");
INSERT INTO slk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Keď sa tých päť vrátilo s olejom, volali: ‚Pane, otvor nám!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ale ženích im odpovedal: ‚Kto ste? Nepoznám vás!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","A tak bdejte a buďte stále pripravení, lebo nepoznáte ani deň ani hodinu príchodu Syna človeka.“ ");
INSERT INTO slk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","„Dám vám iný príklad. Jeden človek si pred odchodom na ďalekú cestu zavolal svojich podriadených a zveril im svoj majetok. ");
INSERT INTO slk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Každému dal podľa jeho schopností: jednému päť talentov, druhému dva a ďalšiemu jeden talent. Potom odcestoval. ");
INSERT INTO slk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ten, čo dostal päť talentov, začal hneď podnikať a získal ďalších päť. ");
INSERT INTO slk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ten, čo dostal dva talenty, tiež sumu zdvojnásobil. ");
INSERT INTO slk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ale ten, ktorému zveril jeden talent, vykopal v zemi jamu a peniaze do nej schoval. ");
INSERT INTO slk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Po dlhšom čase sa pán vrátil a chcel, aby mu podriadení predložili účty. ");
INSERT INTO slk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Prvý priniesol peniaze a povedal: ‚Pán môj, zveril si mi päť talentov, a tu máš zisk – ďalších päť.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pán ho pochválil: ‚Si dobrý a verný sluha. Osvedčil si sa v malej úlohe, preto ti môžem zveriť väčšiu. A teraz ťa pozývam na oslavu. Poď sa so mnou radovať!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Prišiel ďalší a povedal: ‚Pán môj, zveril si mi dva talenty a odovzdávam ti štyri.‘ – ");
INSERT INTO slk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‚Veľmi dobre!‘ odpovedal pán. ‚Si usilovný a spoľahlivý. Splnil si malú úlohu, zverím ti väčšiu. Aj teba pozývam na oslavu. Poď sa so mnou radovať!‘ ");
INSERT INTO slk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Potom skladal účty posledný. ‚Pán môj, viem, že si prísny človek a zbieraš úrodu tam, kde si nesial. ");
INSERT INTO slk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bál som sa, a preto som peniaze radšej ukryl a teraz ti ich v poriadku vraciam.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pán zvolal: ‚Ty lenivec a naničhodník! Vedel si, o čo mi ide. ");
INSERT INTO slk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mal si zverené peniaze radšej uložiť a priniesli by mi aspoň úroky. ");
INSERT INTO slk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vezmite od neho peniaze a dajte ich prvému. ");
INSERT INTO slk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lebo tomu, kto dobre využíva to, čo mu bolo zverené, bude ešte pridané. Ale kto berie zverené na ľahkú váhu, príde aj o to, čo má. ");
INSERT INTO slk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tohto lenivca vyžeňte do tmy! Tam ho čaká len plač a škrípanie zubami.‘ “ ");
INSERT INTO slk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","„Keď príde Syn človeka vo svojom kráľovskom majestáte v sprievode všetkých anjelov, zasadne na trón svojej slávy. ");
INSERT INTO slk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Vtedy sa zhromaždia všetky národy. Ako pastier oddeľuje ovce od capov, tak aj on rozdelí ľudí na dve skupiny. ");
INSERT INTO slk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ovce si postaví napravo a capov naľavo. ");
INSERT INTO slk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Vtedy povie Kráľ svojim verným po svojej pravici: ‚Poďte, sám Otec vás pozýva do kráľovstva, ktoré je pre vás pripravené od počiatku sveta. ");
INSERT INTO slk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bol som hladný a nakŕmili ste ma; bol som smädný a dali ste sa mi napiť; bol som cudzincom bez strechy nad hlavou a vy ste ma prichýlili; ");
INSERT INTO slk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nemal som si čo obliecť a vy ste ma obliekli; v chorobe ste sa o mňa starali; a keď som bol vo väzení, prišli ste ma navštíviť.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tí verní namietnu: ‚Pane, kedy sme ťa videli hladného, smädného? ");
INSERT INTO slk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kedy sme sa o teba postarali ako o cudzinca či nahého? ");
INSERT INTO slk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A kedy sme ťa videli vo väzení alebo chorého?‘ ");
INSERT INTO slk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kráľ im odpovie: ‚Čo dobrého ste urobili jednému z mojich najmenších bratov, to ste urobili pre mňa.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tým zhromaždeným po ľavici poviem: ‚Odíďte odo mňa, zatratení, do večného ohňa, ktorý je pripravený pre satana a jeho démonov. ");
INSERT INTO slk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bol som hladný a nedali ste sa mi najesť; bol som smädný a nedali ste sa mi napiť; bol som ako cudzinec, ktorý nemal strechu nad hlavou a neprichýlili ste ma; ");
INSERT INTO slk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nemal som si čo obliecť a nezaodeli ste ma; v chorobe ste ma neopatrovali a do väzenia ste ma neprišli navštíviť.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oni sa však budú brániť: ‚Pane, ako sme ti mohli pomôcť, keď sme ťa nikdy nevideli – ani hladného, ani smädného, ani ako cudzinca, ani nahého či chorého a ani vo väzení?‘ ");
INSERT INTO slk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kráľ im odpovie: ‚Ak ste odmietli pomôcť tým zdanlivo najbezvýznamnejším, mne ste nepomohli.‘ ");
INSERT INTO slk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A tak týchto čaká večný trest, ale spravodliví budú žiť večne.“ ");
INSERT INTO slk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Keď Ježiš skončil svoju reč, povedal učeníkom: ");
INSERT INTO slk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Viete, že o dva dni bude slávnosť Paschy; Syn človeka bude vydaný a ukrižujú ho.“ ");
INSERT INTO slk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","V tom čase sa zišla židovská rada v paláci veľkňaza Kaifáša. ");
INSERT INTO slk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Radili sa, akou ľsťou by sa mohli Ježiša zmocniť a zabiť ho. ");
INSERT INTO slk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dohodli sa, že by to nemalo byť počas sviatkov, lebo by to mohlo vyvolať vzburu. ");
INSERT INTO slk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ježiš sa pobral do Betánie do domu Šimona, ktorý bol predtým malomocný. ");
INSERT INTO slk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Keď jedli, pristúpila k Ježišovi žena s alabastrovou nádobkou drahocenného oleja a ten mu všetok votrela do vlasov: vyjadrila mu tak úctu a rešpekt. ");
INSERT INTO slk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Učeníkov to pohoršilo: „Také plytvanie! ");
INSERT INTO slk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mohlo sa to výhodne predať a peniaze rozdať chudobným!“ ");
INSERT INTO slk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ježiš to postrehol a povedal: „Prečo jej to zazlievate? ");
INSERT INTO slk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chudobných bude medzi vami vždy dosť, ale ja už s vami dlho nebudem. ");
INSERT INTO slk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Táto žena potrela moje telo olejom, a tak ma vlastne pripravila na pohreb. ");
INSERT INTO slk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Veru, vždy, keď sa kdekoľvek na svete bude hlásať radostná zvesť o Božom kráľovstve, ľudia budú počuť a premýšľať aj o jej čine.“ ");
INSERT INTO slk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Vtedy sa jeden z Ježišových dvanástich učeníkov, Judáš Iškariotský, pobral k veľkňazom a spýtal sa ich: ");
INSERT INTO slk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","„Koľko mi zaplatíte, ak vám vydám Ježiša?“ Dali mu tridsať strieborných. ");
INSERT INTO slk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Od tej chvíle hľadal vhodnú príležitosť, aby ho zradil. ");
INSERT INTO slk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","V prvý deň sviatku nekvasených chlebov sa učeníci spýtali Ježiša: „Kde máme pripraviť jedlo na Paschu?“ ");
INSERT INTO slk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Poslal ich do mesta k istému človeku s odkazom: „Nastal môj čas, u teba budem jesť so svojimi učeníkmi veľkonočného baránka.“ ");
INSERT INTO slk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Učeníci vykonali, čo im prikázal a pripravili tam večeru. ");
INSERT INTO slk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Keď sa zotmelo, jedol so svojimi dvanástimi učeníkmi ");
INSERT INTO slk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","a povedal im: „Jeden z vás ma zradí.“ ");
INSERT INTO slk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To ich veľmi zarmútilo a každý sa ho spytoval: „Vari len nie ja, Pane!?“ ");
INSERT INTO slk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Odpovedal: „Je to ten, ktorý jedol so mnou pri jednom stole. ");
INSERT INTO slk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Syn človeka musí umrieť, ako to predpovedali proroci, ale beda tomu, kto zrádza Syna človeka. Lepšie by mu bolo, keby sa nebol narodil.“ ");
INSERT INTO slk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judáš sa ho spýtal: „Učiteľ, vari len nie ja!?“ Odpovedal mu: „Sám si to povedal.“ ");
INSERT INTO slk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Keď jedli, vzal Ježiš chlieb, lámal ho a podával učeníkom so slovami: „Vezmite a jedzte, toto je moje telo.“ ");
INSERT INTO slk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Potom vzal kalich s vínom, poďakoval sa Bohu a podal im ho so slovami: „Pite z neho všetci, ");
INSERT INTO slk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","toto je moja krv, ktorá sa vylieva, aby zmyla hriechy mnohých. Je to nová zmluva Boha s človekom. ");
INSERT INTO slk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vravím vám, že oddnes nebudem piť z plodu viniča až dovtedy, kým ho nebudeme piť spolu úplne inak – v kráľovstve môjho Otca.“ ");
INSERT INTO slk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Potom zaspievali chválospev a pobrali sa na Olivový vrch. ");
INSERT INTO slk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tam im Ježiš povedal: „Tejto noci ma všetci opustíte, lebo Písmo predpovedá: ‚Budem biť pastiera a ovce sa rozpŕchnu.‘ ");
INSERT INTO slk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ale po svojom vzkriesení vás predídem do Galiley a tam sa spolu stretneme.“ ");
INSERT INTO slk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter vyhlásil: „Ak by ťa aj všetci opustili, ja od teba nikdy neodídem.“ ");
INSERT INTO slk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ježiš mu však povedal: „Pamätaj na moje slová: Ešte túto noc, skôr ako kohút zakikiríka, tri razy ma zaprieš.“ ");
INSERT INTO slk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","„Nikdy ťa nezapriem, aj keby som mal zomrieť s tebou!“ zvolal Peter. Ostatní učeníci sa k nemu pridali tiež. ");
INSERT INTO slk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Potom prišli na miesto zvané Getsemane a Ježiš povedal svojim učeníkom: „Vy si tu sadnite, a ja pôjdem ďalej, aby som sa modlil.“ ");
INSERT INTO slk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Vzal so sebou Petra, Jakuba a Jána. Tu na neho doľahol zármutok a padla naňho tieseň. ");
INSERT INTO slk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Smutne im povedal: „Prežívam smrteľnú úzkosť. Zostaňte tu a bdejte so mnou.“ ");
INSERT INTO slk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Trochu sa od nich vzdialil, padol tvárou na zem a modlil sa: „Môj Otče! Ak je to možné, nech ma minie tento kalich. Ale nech sa stane, ako ty chceš, nie ako ja.“ ");
INSERT INTO slk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Potom sa vrátil k učeníkom a našiel ich spať. Povedal Petrovi: „To ste so mnou nemohli ani hodinu bdieť? ");
INSERT INTO slk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bdejte a modlite sa. Inak vás premôže pokušenie. Ste síce plní odhodlania, ale sami nemáte dosť síl obstáť.“ ");
INSERT INTO slk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Znova sa vzdialil a modlil sa: „Môj Otče, ak to nie je možné, aby ma tento kalich minul a ja ho musím vypiť až do dna, nech sa stane tvoja vôľa.“ ");
INSERT INTO slk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Vrátil sa k svojim učeníkom a oni zasa spali; nevládali premôcť spánok. ");
INSERT INTO slk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nechal ich spať, odišiel po tretí raz a opäť sa modlil o to isté. ");
INSERT INTO slk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Potom sa vrátil k učeníkom a povedal: „Vari ešte sále spíte a odpočívate? Prišiel čas, keď bude Syn človeka zradený a vydaný do rúk podlých ľudí. ");
INSERT INTO slk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Vstaňte a poďme. Uvidíte môjho zradcu – práve prichádza!“ ");
INSERT INTO slk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ešte ani nedohovoril, a už sa ukázal Judáš, jeden z jeho dvanástich učeníkov. Spolu s ním prišiel veľký zástup mužov ozbrojených mečmi a palicami. Poslali ich veľkňazi a vodcovia ľudu. ");
INSERT INTO slk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judáš si s nimi dohodol znamenie: Bude to ten, s ktorým sa pozdravím bozkom. Toho zatknite! ");
INSERT INTO slk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nato pristúpil k Ježišovi a povedal: „Pozdravujem ťa, učiteľ!“ a pobozkal ho. ");
INSERT INTO slk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ježiš mu povedal: „Priateľu, vieš, prečo si prišiel?“ Vtom sa na Ježiša vrhli a zajali ho. ");
INSERT INTO slk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jeden z tých, ktorí boli s Ježišom, vytiahol krátky meč, napadol veľkňazovho sluhu a odsekol mu ucho. ");
INSERT INTO slk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","„Odlož svoj meč!“ prikázal mu Ježiš. „Kto mečom bojuje, mečom zahynie. ");
INSERT INTO slk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Myslíš, že by som teraz nemohol poprosiť svojho Otca, aby mi poslal viac ako dvanásť légií anjelov? ");
INSERT INTO slk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ale ako by sa potom naplnilo to, čo hovorí Písmo?“ ");
INSERT INTO slk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Potom sa obrátil na ozbrojencov: „Som azda nebezpečný zločinec, že ste ma prišli zajať s mečmi a palicami? Prečo ste ma nezatkli už v chráme, kde som deň čo deň učil?“ ");
INSERT INTO slk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ale to sa stalo preto, aby sa splnili predpovede prorokov. V tej chvíli ho všetci jeho učeníci opustili a rozutekali sa. ");
INSERT INTO slk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zatknutého Ježiša potom odviedli k veľkňazovi Kaifášovi, kde sa zhromaždili učitelia Zákona a vodcovia ľudu. ");
INSERT INTO slk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter ho z diaľky nasledoval až po veľkňazov palác. Vošiel na nádvorie a zamiešal sa medzi služobníctvo, aby sa dozvedel, čo sa s ním stane. ");
INSERT INTO slk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Medzitým sa veľkňaz aj celá veľrada usilovali nájsť nepravé dôkazy proti Ježišovi, aby ho mohli obviniť a odsúdiť na smrť. ");
INSERT INTO slk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nenašli však nič, hoci si zaobstarali mnohých falošných svedkov. Napokon vystúpili dvaja a zhodne svedčili: ");
INSERT INTO slk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","„Tento muž povedal, že má moc zboriť chrám a za tri dni ho znovu postaviť.“ ");
INSERT INTO slk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Vtedy sa ujal slova veľkňaz a spýtal sa Ježiša: „Počul si obvinenia? Čo chceš povedať na svoju obhajobu?“ ");
INSERT INTO slk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ale Ježiš mlčal. A tak mu veľkňaz položil ďalšiu otázku: „Vyzývam ťa pri živom Bohu, aby si nám povedal, či si Mesiáš, Syn Boží.“ ");
INSERT INTO slk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ježiš odvetil: „Ty sám si to povedal. Ale hovorím vám, že odteraz uvidíte Syna človeka, ako sedí po pravici Všemohúceho a ako prichádza na nebeských oblakoch.“ ");
INSERT INTO slk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Vtedy veľkňaz od zúrivosti roztrhol svoje vrchné rúcho a povedal: „To je rúhanie! Potrebujeme vari ďalších svedkov?! Počuli ste to na vlastné uši! ");
INSERT INTO slk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aký trest si zaslúži?“ Všetci mu odpovedali: „Zaslúži si smrť!“ ");
INSERT INTO slk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Začali mu pľuť do tváre, bili ho po hlave, udierali palicami ");
INSERT INTO slk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a posmievali sa mu: „Ak si Mesiáš, uhádni, kto ťa udrel!“ ");
INSERT INTO slk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter zatiaľ sedel vonku na nádvorí. Tu k nemu pristúpila jedna slúžka so slovami: „Aj ty patríš k tomu Ježišovi z Galiley!“ ");
INSERT INTO slk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ale Peter to pred všetkými zaprel: „Neviem, o čom hovoríš!“ ");
INSERT INTO slk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Potom sa pobral k bráne, ale zazrela ho iná žena a upozornila okolostojacich: „Tento človek chodieval s tým Ježišom z Nazareta.“ ");
INSERT INTO slk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","No Peter sa zaprisahal: „Nepoznám toho človeka!“ ");
INSERT INTO slk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","O chvíľu pristúpili k nemu tí, čo tam stáli, a povedali mu: „Určite k nemu patríš, veď aj tvoje nárečie ťa prezrádza!“ ");
INSERT INTO slk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peter sa zariekal a zaprisahával: „Ale ja toho človeka naozaj nepoznám!“ Vtom zakikiríkal kohút ");
INSERT INTO slk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","a Peter si spomenul na Ježišove slová: „Skôr ako zakikiríka kohút, tri razy ma zaprieš.“ Vybehol von a žalostne sa rozplakal. ");
INSERT INTO slk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Keď začalo svitať, veľkňazi a židovskí vodcovia sa uzhodli, že Ježiša vydajú na smrť. ");
INSERT INTO slk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Potom poslali spútaného Ježiša k rímskemu miestodržiteľovi Pilátovi z Pontu. ");
INSERT INTO slk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Keď Judáš videl, že Ježiša odsúdili na smrť, trýznilo ho svedomie za to, čo spáchal. Vzal tridsať strieborných, ktoré dostal za zradu, a chcel ich vrátiť veľkňazom a židovským vodcom. ");
INSERT INTO slk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","„Zhrešil som, zradil som nevinného človeka!“ „Čo nás po tom. To je tvoja vec!“ odsekli mu ľahostajne. ");
INSERT INTO slk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Odhodil peniaze na zem v chráme, vybehol von a obesil sa. ");
INSERT INTO slk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Veľkňazi pozbierali peniaze a povedali si: „Čo s nimi? Do chrámovej pokladnice ich nemôžeme dať. Lipne na nich krv!“ ");
INSERT INTO slk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dohodli sa teda, že za ne kúpia hrnčiarovo pole a že tam budú pochovávať cudzincov, ktorí zomrú v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Preto sa to pole dodnes volá Pole krvi. ");
INSERT INTO slk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tak sa splnilo Jeremiášovo proroctvo: „Vzali tridsať strieborných, cenu človeka, na akú ho ohodnotili synovia Izraela, ");
INSERT INTO slk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a dali ich za hrnčiarovo pole, ako mi Boh prikázal.“ ");
INSERT INTO slk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ježiša predviedli pred rímskeho miestodržiteľa Piláta. Spýtal sa ho: „Tak ty si židovský kráľ?“ „Ty sám to hovoríš,“ odpovedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Keď potom na neho veľkňazi a židovskí vodcovia prednášali svoje žaloby, Ježiš bol ticho. ");
INSERT INTO slk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","„Nepočuješ, z čoho všetkého ťa obviňujú?“ vyzval ho Pilát. ");
INSERT INTO slk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ale na jeho nesmierne prekvapenie Ježiš stále mlčal a neobhajoval sa. ");
INSERT INTO slk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bolo zvykom, že cez veľkonočné sviatky vladár prepustil jedného väzňa podľa želania ľudu. ");
INSERT INTO slk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","V tom čase bol vo väzení povestný zločinec Barabáš. ");
INSERT INTO slk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ráno sa ľudia zhromaždili pred Pilátovým domom a on sa ich spýtal: „Koho vám mám prepustiť, Barabáša alebo Ježiša, vášho Mesiáša?“ ");
INSERT INTO slk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Vedel totiž, že veľkňazi udali Ježiša zo závisti. ");
INSERT INTO slk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Keď Pilát sedel v sudcovskom kresle, dostal odkaz od svojej ženy: „Ruky preč od toho spravodlivého človeka. Kvôli nemu ma v noci prenasledovali strašné sny.“ ");
INSERT INTO slk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Židovskí veľkňazi a predstavitelia ľudu medzitým presvedčili dav, aby žiadali slobodu pre Barabáša a smrť pre Ježiša. ");
INSERT INTO slk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Keď sa Pilát znova spýtal, koho z tých dvoch má prepustiť, ozval sa krik: „Barabáša!“ ");
INSERT INTO slk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","„A čo mám urobiť s Ježišom, vaším Mesiášom?“ „Ukrižuj ho!“ kričal dav. ");
INSERT INTO slk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","„A čoho sa vlastne dopustil?“ namietal Pilát. Ale oni sa ešte naliehavejšie domáhali: „Ukrižuj ho, ukrižuj!“ ");
INSERT INTO slk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Keď Pilát videl, že jeho úsilie zachrániť Ježiša je márne a ľudia sú čoraz zúrivejší, dal si doniesť nádobu s vodou, pred očami všetkých si umyl ruky a povedal: „Som čistý od krvi tohto človeka. Je nevinný, zodpovednosť leží na vás!“ ");
INSERT INTO slk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","„Zodpovednosť za jeho preliatu krv berieme na seba a na naše deti!“ kričal rozvášnený dav. ");
INSERT INTO slk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A tak prepustil Barabáša, Ježiša nariadil zbičovať a dal súhlas, aby ho ukrižovali. ");
INSERT INTO slk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Rímski vojaci odviedli Ježiša do vládnej budovy a zhromaždili okolo neho celú čatu. ");
INSERT INTO slk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vyzliekli ho, cez plecia mu prehodili purpurový plášť, ");
INSERT INTO slk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","uplietli mu z tŕnia korunu, narazili mu ju na hlavu a do pravej ruky mu dali palicu. Potom si pred ním kľakali a posmievali sa mu: „Nech žije židovský kráľ!“ ");
INSERT INTO slk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pľuvali naňho a bili ho po hlave palicami. ");
INSERT INTO slk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Keď sa mu do vôle naposmievali, strhli z neho plášť, zasa mu obliekli jeho rúcho a viedli ho na popravisko. ");
INSERT INTO slk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cestou stretli človeka z mesta Kyréna v Afrike, ktorý sa volal Šimon. Prinútili ho, aby niesol Ježišov kríž. ");
INSERT INTO slk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Prišli na miesto zvané Golgota, čiže Lebka. ");
INSERT INTO slk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tam mu dali piť skysnuté víno zmiešané so žlčou, aby ho omámilo. Ale keď ochutnal, odmietol. ");
INSERT INTO slk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Potom ho pribili na kríž a losovaním si podelili jeho rúcho. ");
INSERT INTO slk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Posadali si okolo neho a strážili ho. ");
INSERT INTO slk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nad hlavu mu pripevnili nápis s jeho previnením: JEŽIŠ, KRÁĽ ŽIDOV. ");
INSERT INTO slk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Spolu s ním ukrižovali v ten deň aj dvoch zločincov, jedného po jeho pravej, druhého po ľavej strane. ");
INSERT INTO slk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ľudia, ktorí šli okolo, sa mu rúhavo posmievali: ");
INSERT INTO slk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","„Hej ty, čo si chcel zbúrať chrám a za tri dni ho postaviť! Teraz ukáž svoju moc a zachráň sám seba. Ak si Boží Syn, poď z toho kríža dolu!“ ");
INSERT INTO slk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aj veľkňazi a židovskí vodcovia sa k nim pridali: ");
INSERT INTO slk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Iných zachraňoval, a sám seba nemôže zachrániť. Mesiáš, kráľ Izraela – a visí na kríži! Nech zostúpi dolu a uveríme mu. ");
INSERT INTO slk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Spoliehal sa na to, že Boh je s ním. Ak teda Boh chce, nech ho vyslobodí. Veď o sebe tvrdil, že je Božím Synom!“ ");
INSERT INTO slk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Potupovali ho aj zločinci, ktorých ukrižovali spolu s ním. ");
INSERT INTO slk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Napoludnie sa zrazu nad celým krajom rozprestrela tma a trvala tri hodiny. ");
INSERT INTO slk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A vtedy zvolal silným hlasom: „Eli, Eli, lama sabachtani?“, čo znamená: „Bože môj, Bože môj, prečo si ma opustil?“ ");
INSERT INTO slk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Niektorí z tých, čo tam stáli, vraveli: „Volá na Eliáša!“ ");
INSERT INTO slk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jeden z nich bežal po špongiu, namočil ju do octu, nabodol na tyč a dával mu piť. ");
INSERT INTO slk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ostatní ho okrikovali: „Len ho nechaj, nech vidíme, či ho Eliáš príde zachrániť.“ ");
INSERT INTO slk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Potom Ježiš opäť skríkol mocným hlasom a skonal. ");
INSERT INTO slk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","V tej chvíli sa v chráme roztrhol záves odhora až nadol, zem sa chvela, skaly pukali, ");
INSERT INTO slk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","hroby sa otvárali a veľa mŕtvych bolo vzkriesených. ");
INSERT INTO slk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Keď potom Ježiš vstal z mŕtvych, mnohí v Jeruzaleme dosvedčovali, že videli vzkriesených z tých hrobov. ");
INSERT INTO slk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Keď stotník a tí, čo s ním strážili Ježiša, videli zemetrasenie a všetko, čo sa dialo, premkla ich hrôza a vraveli: „To bol naozaj Boží Syn!“ ");
INSERT INTO slk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Z diaľky sa prizeralo aj veľa žien, ktoré prišli za Ježišom až z Galiley a starali sa o neho aj o jeho učeníkov. ");
INSERT INTO slk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Medzi nimi bola aj Mária Magdaléna, Mária, Jakubova a Jozefova matka, a matka Jakuba a Jána Zebedejovcov. ");
INSERT INTO slk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Keď nastal večer, prišiel Jozef, bohatý človek z Arimatey, ktorý tiež patril k Ježišovým nasledovníkom. ");
INSERT INTO slk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dal sa ohlásiť u Piláta a poprosil ho, aby mu vydal Ježišovo telo. Pilát mu vyhovel. ");
INSERT INTO slk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jozef zavinul Ježišovo telo do čistého plátna ");
INSERT INTO slk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a uložil ho do hrobu, ktorý si dal vytesať v skale. Vchod do hrobu dal privaliť veľkým balvanom. Potom odišiel. ");
INSERT INTO slk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Dve Márie – jedna z nich bola Mária Magdaléna – sedeli oproti hrobu. ");
INSERT INTO slk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na druhý deň – v sobotu, po prípravnom dni sviatkov – sa veľkňazi a farizeji zhromaždili u Piláta ");
INSERT INTO slk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a povedali: „Pane, spomenuli sme si, že ten zvodca, kým ešte žil, povedal: ‚Po troch dňoch vstanem z mŕtvych.‘ ");
INSERT INTO slk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Daj teda aspoň tri dni strážiť hrob, lebo prídu jeho učeníci, ukradnú ho a potom budú ľudí presviedčať, že vstal z mŕtvych. A to by bol ešte väčší podvod ako prvý!“ ");
INSERT INTO slk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","„Dobre,“ povedal Pilát, „vezmite vojakov a strážte ho, ako viete.“ ");
INSERT INTO slk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tak aj urobili, postavili k hrobu stráž, dokonca zapečatili balvan, ktorým bol hrob privalený. ");
INSERT INTO slk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Keď uplynula sobota a svitol prvý deň týždňa, Mária Magdaléna a tá druhá Mária sa vybrali k hrobu. ");
INSERT INTO slk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A tu zrazu nastalo silné zemetrasenie, lebo Boží anjel zostúpil z neba, odvalil balvan a sadol si naň. ");
INSERT INTO slk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Žiaril ako blesk a odev mal biely ako sneh. ");
INSERT INTO slk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Strážcov to tak vydesilo, že sa nevládali ani pohnúť. ");
INSERT INTO slk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anjel sa prihovoril ženám: „Nebojte sa, viem, že hľadáte Ježiša, ktorý bol ukrižovaný. ");
INSERT INTO slk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ale on tu už nie je, vstal z hrobu, tak ako vám to predtým povedal. Poďte dnu a presvedčte sa. ");
INSERT INTO slk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A teraz sa ponáhľajte oznámiť jeho učeníkom, že vstal z mŕtvych. Pôjde do Galiley a tam sa s ním stretnete. To je to, čo som vám prišiel oznámiť.“ ");
INSERT INTO slk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","So strachom, ale aj s veľkou radosťou ženy rýchlo odišli od hrobu a bežali to oznámiť učeníkom. ");
INSERT INTO slk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vtom sa zjavil pred nimi Ježiš a povedal im: „Pozdravujem vás.“ Ihneď padli na kolená a objímali mu nohy. ");
INSERT INTO slk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ježiš ich upokojoval: „Nebojte sa, choďte a povedzte mojim bratom, aby šli do Galiley, tam sa stretneme.“ ");
INSERT INTO slk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Keď sa ženy vzdialili, niektorí zo strážcov utekali do mesta a oznámili veľkňazom všetko, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tí hneď zvolali poradu s ostatnými židovskými predstaviteľmi, aby sa dohodli, čo robiť. Najprv veľkou sumou podplatili vojakov, ");
INSERT INTO slk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nech povedia: „V noci sme zaspali, vtedy prišli jeho učeníci a ukradli jeho telo.“ ");
INSERT INTO slk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Potom im sľúbili, že ak sa to dozvie miestodržiteľ, uchlácholia ho a postarajú sa, aby z toho nemali nepríjemností. ");
INSERT INTO slk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vojaci vzali peniaze a rozhlasovali to, čo im prikázali. A táto zvesť sa rozšírila medzi Židmi, ktorí tomu veria dodnes. ");
INSERT INTO slk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jedenásť učeníkov sa pobralo do Galiley na vrch, ktorý im určil Ježiš. ");
INSERT INTO slk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Keď ho tam zazreli, klaňali sa mu, ale niektorí pochybovali, či je to naozaj on. ");
INSERT INTO slk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ježiš im povedal: „Je mi daná všetka moc na nebi aj na zemi. ");
INSERT INTO slk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Preto choďte a získavajte mi nasledovníkov vo všetkých národoch a krstite ich v mene Otca, Syna i Ducha Svätého. ");
INSERT INTO slk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A učte ich, aby zachovávali všetko, čo som vám prikázal. Budem s vami stále, až do konca tohto sveta.“");
INSERT INTO slk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Začiatok nádhernej správy o Ježišovi Kristovi, Božom Synovi, bol takýto: ");
INSERT INTO slk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","V knihe proroka Izaiáša oznámil Boh: „Posielam pred tebou svojho posla, ktorý ti praví cestu.“ ");
INSERT INTO slk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","„Na púšti volá hlas: ‚Pripravte cestu Pánovi a odstráňte z nej všetky prekážky.‘ “ ");
INSERT INTO slk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Týmto poslom bol Ján Krstiteľ. Býval na púšti a nabádal ľudí, aby sa dali pokrstiť, a vyjadrili tak, že sa odvracajú od svojich hriechov a túžia po Božom odpustení. ");
INSERT INTO slk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na púšť za ním prichádzali ľudia z Jeruzalema i z celého Judska. Tam vyznávali svoje hriechy a Ján ich krstil v rieke Jordán. ");
INSERT INTO slk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nosil odev z ťavej srsti a bol prepásaný koženým opaskom: jeho pokrmom boli kobylky a med divých včiel. ");
INSERT INTO slk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ľuďom prinášal toto posolstvo: „Po mne príde ktosi omnoho väčší ako ja. Nie som hodný ani toho, aby som mu rozviazal remienok na obuvi. ");
INSERT INTO slk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja vás krstím vodou, ale on vás bude krstiť Duchom Svätým.“ ");
INSERT INTO slk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","V tých dňoch prišiel Ježiš z galilejského Nazareta k Jordánu, kde ho Ján pokrstil. ");
INSERT INTO slk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Vo chvíli, keď Ježiš vystupoval z vody na breh, videl, ako sa otvorilo nebo a Boží Duch na neho zostúpil ako holubica. ");
INSERT INTO slk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Vtom zaznel z neba hlas: „Ty si môj Syn. Milujem ťa a to, čo robíš, ma napĺňa radosťou.“ ");
INSERT INTO slk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hneď nato ho Svätý Duch viedol na púšť. ");
INSERT INTO slk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Strávil tam štyridsať dní vystavený satanovým pokušeniam. Bol medzi divou zverou a anjeli sa o neho starali. ");
INSERT INTO slk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Neskôr, keď kráľ Herodes uväznil Jána, prišiel Ježiš do Galiley a zvestoval tam Božie radostné posolstvo: ");
INSERT INTO slk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Nadišiel už čas. Božie kráľovstvo je blízko. Odvráťte sa od svojich hriechov a dôverujte dobrej správe o Bohu!“ ");
INSERT INTO slk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Keď šiel Ježiš po brehu Galilejského mora, pozoroval Šimona a jeho brata Andreja, ako hádžu do vody siete, lebo sa živili rybárstvom. ");
INSERT INTO slk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ježiš na nich zavolal: „Poďte za mnou a ja vám ukážem, ako zachraňovať ľudí pre večnosť!“ ");
INSERT INTO slk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ihneď nechali všetko tak a odišli s ním. ");
INSERT INTO slk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kúsok ďalej videl pri brehu Zebedejových synov Jakuba a Jána, ako v loďke opravujú potrhané siete. ");
INSERT INTO slk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aj ich zavolal a oni nechali svojho otca Zebedeja v loďke s najatými pomocníkmi a pobrali sa za Ježišom. ");
INSERT INTO slk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Spoločne prišli do mesta Kafarnaum a hneď v prvú sobotu vošli do synagógy, kde Ježiš začal učiť. ");
INSERT INTO slk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Poslucháči žasli nad jeho učením – učil ich totiž ako niekto, kto má autoritu i moc, nie ako ich náboženskí učitelia. ");
INSERT INTO slk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bol tam istý muž posadnutý démonom a začal vykrikovať: ");
INSERT INTO slk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Ježiš z Nazareta, prečo nás nenecháš na pokoji? Prišiel si nás zničiť? Viem, kto si: ten Svätý, čo prichádza od Boha!“ ");
INSERT INTO slk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ježiš mu prísne povedal: „Mlč s vyjdi z neho!“ ");
INSERT INTO slk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Vtom démon zreval, divoko tým mužom zalomcoval a vyšiel z neho. ");
INSERT INTO slk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Poslucháčov sa zmocnil úžas a začali sa dohadovať, čo sa stalo. „Čo to je? Nejaké nové učenie?“ spytovali sa vzrušene. „A akú má len moc – aj zlí duchovia poslúchajú jeho rozkazy!“ ");
INSERT INTO slk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Správa o ňom sa rýchlo rozšírila po celom území Galiley. ");
INSERT INTO slk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Keď potom vyšiel zo synagógy, pobral sa s Jakubom a Jánom do Šimonovho a Andrejovho domu. ");
INSERT INTO slk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tu našli Šimonovu svokru ležať chorú v posteli s vysokou horúčkou. Povedali Ježišovi, čo ju trápi. ");
INSERT INTO slk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pristúpil k jej lôžku, chytil ju za ruku a pomohol jej vstať. Horúčka jej ihneď zmizla a ona im začala pripravovať jedlo. ");
INSERT INTO slk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Večer, keď zapadlo slnko, bolo nádvorie plné chorých a posadnutých démonmi, ktorých k nemu priviedli, aby ich uzdravil. ");
INSERT INTO slk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pred domom sa zhromaždil a pozoroval ho obrovský zástup ľudí z celého mesta. ");
INSERT INTO slk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","V ten večer uzdravil veľký počet chorých a mnohých démonov vyhnal z ich obetí. Ale démonom nedovolil hovoriť, lebo vedeli, kým je. ");
INSERT INTO slk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na druhý deň vstal Ježiš hneď ráno, ešte pred svitaním a odišiel na osamelé miesto, kde sa mohol v pokoji modliť. ");
INSERT INTO slk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Šimon spolu s ostatnými sa za ním ponáhľali. ");
INSERT INTO slk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Keď ho našli, vraveli mu: „Každý sa na teba vypytuje!“ ");
INSERT INTO slk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","On im odpovedal: „Musím ísť aj do okolitých dedín a oznámiť ľuďom moje posolstvo – veď to je dôvod, prečo som prišiel.“ ");
INSERT INTO slk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A potom kázal v synagógach po celej Galilei a vyháňal démonov. ");
INSERT INTO slk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Raz k nemu pristúpil človek postihnutý malomocenstvom, hodil sa pred ním na kolená a úpenlivo ho prosil: „Viem, že ma môžeš uzdraviť, ak budeš chcieť!“ ");
INSERT INTO slk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ježišovi ho prišlo ľúto, natiahol ruku, dotkol sa ho a povedal: „Chcem, buď čistý!“ ");
INSERT INTO slk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Len čo vyslovil tieto slová, nezostalo po malomocenstve ani stopy. ");
INSERT INTO slk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ale Ježiš mu prísne nariadil: „Nikomu nič nepovedz! ");
INSERT INTO slk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Choď, ukáž sa kňazovi a prines obetný dar, ako to nariadil Mojžiš uzdraveným z malomocenstva, aby všetci mali dôkaz, že si naozaj zdravý.“ ");
INSERT INTO slk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ale uzdravený nevydržal mlčať a všetkým radostne oznamoval, čo sa s ním stalo. A tak sa Ježiš nemohol verejne dostať do nijakého mesta. Zdržiaval sa preto na opustených miestach, ale aj tak sa za ním zbiehali zástupy ľudí zo všetkých strán. ");
INSERT INTO slk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Po niekoľkých dňoch sa Ježiš opäť vrátil do Kafarnauma. Správa o jeho príchode sa rýchlo rozletela po meste. ");
INSERT INTO slk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Do domu sa k nemu nahrnulo toľko ľudí, že vnútri, ale ani pred domom sa nedalo ani hnúť. A on im zvestoval Božie posolstvo. ");
INSERT INTO slk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Štyria muži priniesli na nosidlách ochrnutého človeka. ");
INSERT INTO slk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Keďže sa k nemu cez to množstvo ľudí nemohli dostať, vyšli na strechu domu, urobili v nej otvor a spustili ležadlo s ochrnutým rovno pred Ježiša. ");
INSERT INTO slk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Keď Ježiš videl ich vieru, povedal chorému: „Syn môj, tvoje hriechy sú odpustené!“ ");
INSERT INTO slk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sedeli tam však aj niekoľkí učitelia Zákona a v duchu sa pohoršovali: ");
INSERT INTO slk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Čo to ten človek hovorí!? Veď je to rúhanie! Veď iba Boh má právo odpúšťať hriechy!“ ");
INSERT INTO slk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","No Ježiš poznal ich myšlienky a preto sa ich spýtal: „Prečo vás to poburuje? ");
INSERT INTO slk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Veď čo je ľahšie? Povedať ochrnutému: ‚Tvoje hriechy sú odpustené‘ – alebo mu prikázať: ‚Vstaň a choď!‘ ");
INSERT INTO slk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ale aby ste vedeli, že Syn človeka má moc na zemi odpúšťať hriechy…“ ");
INSERT INTO slk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Vtedy sa obrátil k ochrnutému a povedal mu: „Vstaň a vezmi si svoje lôžko. Môžeš ísť domov!“ ");
INSERT INTO slk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A chorý sa pred očami ohromeného zástupu postavil na nohy, vzal ležadlo a pobral preč. Ľudia žasli a oslavovali Boha: „Také čosi sme nikdy nevideli!“ ");
INSERT INTO slk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ježiš sa znova pobral na breh Genezaretského jazera a kázal zástupu ľudí, ktorí sa okolo neho zhromaždili. ");
INSERT INTO slk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cestou uvidel Alfejovho syna Léviho, ako sedí na colnici a vyberá poplatky od pocestných. Zavolal na neho: „Poď so mnou a staň sa mojím učeníkom!“ A Lévi vstal a išiel za ním. ");
INSERT INTO slk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","V ten deň usporiadal Lévi vo svojom dome hostinu. Prišiel na ňu nielen Ježiš so svojimi učeníkmi, ale aj mnoho ďalších vyberačov daní a ľudí pochybnej povesti. ");
INSERT INTO slk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Keď však učitelia Zákona videli, že Ježiš stoluje s ľuďmi zlej povesti, vraveli jeho učeníkom: „Ako si môže sadnúť za stôl s takou spodinou?“ ");
INSERT INTO slk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ježiš to počul a odpovedal im: „Lekára nepotrebujú zdraví, ale chorí. Neprišiel som volať k Bohu tých, čo sú presvedčení o vlastnej spravodlivosti, ale hriešnikov.“ ");
INSERT INTO slk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nasledovníci Jána Krstiteľa a farizeji sa pravidelne postili. Niektorí ľudia sa preto Ježiša pýtali: „Prečo sa Jánovi nasledovníci a farizeji postievajú a tvoji učeníci nie?“ ");
INSERT INTO slk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ježiš im na to odpovedal: „Majú azda svadobčania dôvod postiť sa, keď sú na svadobnej hostine? Kým je ženích medzi nimi, prečo by sa neradovali? ");
INSERT INTO slk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ale prídu dni, keď ženícha vytrhnú z ich stredu, a potom sa budú postiť. ");
INSERT INTO slk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nikto predsa neprišíva na staré šaty záplatu z novej látky, lebo by vytrhla staré tkanivo a diera by sa ešte zväčšila. ");
INSERT INTO slk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A takisto sa mladé víno nenalieva do mechov zo starej kože. Kvasiace víno by staré mechy roztrhlo, a tak by jedno i druhé vyšlo nazmar. Mladé víno sa má nalievať do nových mechov.“ ");
INSERT INTO slk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Raz v sobotu prechádzal Ježiš so svojimi učeníkmi obilným poľom. Učeníci boli hladní, preto začali trhať klasy. ");
INSERT INTO slk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Videli to farizeji a vyčítali Ježišovi: „Pozri, tvoji učeníci robia, čo sa v sobotu nesmie robiť!“ ");
INSERT INTO slk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ježiš na to odpovedal: „Azda ste nečítali, čo urobil kráľ Dávid, keď on a jeho družina mali hlad a nebolo čo jesť? ");
INSERT INTO slk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ako vošli do Božieho domu – veľkňazom bol vtedy Abiatar – a jedli z posvätných chlebov, ktoré smeli jesť iba kňazi?“ ");
INSERT INTO slk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A potom ešte dodal: „Sobota bola predsa ustanovená pre človeka, a nie človek pre sobotu. ");
INSERT INTO slk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Preto Syn človeka má právo rozhodnúť aj o tom, čo sa v sobotu robiť smie a čo nie.“ ");
INSERT INTO slk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Keď Ježiš opäť vstúpil do synagógy, zbadal tam človeka s ochrnutou rukou. ");
INSERT INTO slk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bola práve sobota, a preto Ježišovi odporcovia napäto striehli, čo urobí. Ak postihnutého uzdraví, budú mať výbornú príležitosť vzniesť proti nemu obvinenie. ");
INSERT INTO slk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A naozaj – Ježiš chorého vyzval: „Postav sa sem do stredu, aby ťa všetci videli!“ ");
INSERT INTO slk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Potom sa spýtal prítomných: „Čo by sa malo robiť podľa zákona v sobotu: má sa konať dobro, alebo nie? Má sa život zachrániť, alebo zničiť?“ Ale oni len mlčali. ");
INSERT INTO slk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Premeral si všetkých nahnevaným pohľadom, lebo ich bezcitnosť a ľahostajnosť k ľudskému utrpeniu ho roztrpčila. Potom sa obrátil k tomu človeku a povedal: „Vystri ruku!“ Muž poslúchol a jeho ruka bola opäť zdravá. ");
INSERT INTO slk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Keď farizeji vyšli zo synagógy, hneď sa začali radiť s prívržencami kráľa Herodesa, ako Ježiša zabiť. ");
INSERT INTO slk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ježiš sa opäť utiahol s učeníkmi ku Genezaretskému jazeru. Znova ho nasledovali veľké davy ľudí z celej Galiley a Judska, ");
INSERT INTO slk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruzalema, Idumey, zo Zajordánska, ba prichádzalo veľké množstvo ľudí aj z okolia pohanských miest Týru a Sidona. Zvesť o zázrakoch, ktoré konal, sa totiž rozniesla široko-ďaleko. ");
INSERT INTO slk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Poprosil učeníkov, aby mu pripravili loďku a vyhol sa tak tlačenici. ");
INSERT INTO slk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pretože mnohých uzdravil, všetci, čo trpeli nejakou chorobou, sa k nemu predierali, aby sa ho aspoň dotkli. ");
INSERT INTO slk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Len čo ho zbadali ľudia posadnutí démonmi, padali pred ním na zem a kričali: „Ty si Boží Syn!“ ");
INSERT INTO slk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ale on im prísne zakázal hovoriť o tom, kým je. ");
INSERT INTO slk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Potom si zavolal k sebe tých, ktorých si sám vyvolil, a vystúpil s nimi na horu. ");
INSERT INTO slk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Z nich si vybral dvanástich za apoštolov, aby boli s ním a mohol ich poslať kázať, ");
INSERT INTO slk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","uzdravovať a vyháňať démonov. ");
INSERT INTO slk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Boli to: Šimon, ktorému pridal meno Peter; ");
INSERT INTO slk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedejovi synovia Jakub a Ján, ktorých volal Boanerges, čo znamená Synovia hromu; ");
INSERT INTO slk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrej, Filip, Bartolomej, Matúš, Tomáš, Jakub – syn Alfejov, Tadeáš, Šimon Horlivec ");
INSERT INTO slk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a Judáš Iškariotský, ktorý ho neskôr zradil. ");
INSERT INTO slk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ježiš sa vrátil do Šimonovho domu. Ale opäť sa tam nahrnul veľký zástup ľudí, takže sa nemal kedy s učeníkmi ani najesť. ");
INSERT INTO slk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Keď sa o tom, čo sa deje, dopočuli jeho príbuzní, vypravili sa za ním, aby ho donútili vrátiť sa domov. Vraveli totiž, že sa pomiatol. ");
INSERT INTO slk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A učitelia Zákona, ktorí prišli z Jeruzalema, tvrdili: „Je posadnutý Belzebulom, kniežaťom démonov, a zlých duchov vyháňa démonskou silou.“ ");
INSERT INTO slk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ježiš si ich zavolal k sebe a pokúšal sa im to vysvetliť obrazne: „Ako môže satan vyháňať satana? ");
INSERT INTO slk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rozdelené kráľovstvo pustne. ");
INSERT INTO slk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aj rodina, kde vládnu spory a roztržky, sa rozpadne. ");
INSERT INTO slk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tak ani satan nemôže bojovať sám proti sebe – ako by potom obstálo jeho kráľovstvo? Nevyhnutne musí prísť jeho koniec. ");
INSERT INTO slk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ak chce niekto ukradnúť veci z domu silného muža, musí ho najprv zviazať, a len potom si ich môže odniesť. ");
INSERT INTO slk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Preto vám hovorím, že každý hriech aj rúhanie môže byť ľuďom odpustené. ");
INSERT INTO slk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ale ak sa niekto rúha proti Svätému Duchu, tomu nebude odpustené – jeho hriech bude mať večné dôsledky.“ ");
INSERT INTO slk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","To im povedal preto, lebo jeho zázraky pripisovali satanskej moci. ");
INSERT INTO slk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","K preplnenému domu, kde Ježiš učil, prišli jeho bratia s matkou. Dali si ho zavolať. ");
INSERT INTO slk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","„Tvoja matka, tvoje sestry a tvoji bratia sú vonku a chcú, aby si prišiel k nim!“ oznámil mu ktosi zo zástupu, ktorý ho obklopoval. ");
INSERT INTO slk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","„Kto je moja matka a kto sú moji bratia?“ spýtal sa ich. ");
INSERT INTO slk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Potom sa rozhliadol po ľuďoch okolo seba a povedal: „Tu je moja matka a tu sú moji bratia. ");
INSERT INTO slk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Každý, kto koná podľa Božej vôle, je mojím bratom, mojou sestrou i mojou matkou.“ ");
INSERT INTO slk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Potom Ježiš opäť učil pri mori. Okolo neho sa zhromaždili veľké zástupy, preto musel nasadnúť do loďky a odtiaľ sa prihováral k ľuďom na brehu. ");
INSERT INTO slk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Keď učil, často používal podobenstvá. Hovoril im: ");
INSERT INTO slk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Počúvajte! Jeden roľník sa vybral na pole zasiať obilie. ");
INSERT INTO slk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nie všetky zrnká však padli do vhodnej pôdy. Niektoré sa dostali na kraj cesty. Zlietli sa vtáky a pozobali ich. ");
INSERT INTO slk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iné padli na skalnaté miesto, kde bolo len trochu pôdy. Tam síce veľmi skoro vyklíčili, lebo neboli hlboko v zemi, ");
INSERT INTO slk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ale v slnečnej páľave rastlinky pre nedostatok vlahy vyschli. ");
INSERT INTO slk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Iné zrnká padli medzi bodľačie, ktoré mladé výhonky čoskoro udusilo, takže klasy ani nevyrástli. ");
INSERT INTO slk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Zato zrno, ktoré padlo do úrodnej pôdy, vzišlo, rástlo a prinieslo úrodu – niektoré tridsaťnásobnú, ďalšie šesťdesiatnásobnú a iné stonásobnú.“ ");
INSERT INTO slk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Potom Ježiš dodal: „Kto má uši na počúvanie, nech počúva!“ ");
INSERT INTO slk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Neskôr, keď zostal sám so svojimi dvanástimi a ešte ďalšími učeníkmi, spýtali sa ho: „Prečo hovoríš v podobenstvách?“ ");
INSERT INTO slk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Odpovedal im: „Vám, ktorí bývate so mnou, Boh už zjavil tajomstvá svojho kráľovstva. Ale tým, čo sú ešte mimo neho, sa to usilujem vysvetliť v podobenstvách, ");
INSERT INTO slk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","aby boli nútení rozmýšľať. Oni však počúvajú, ale nerozumejú; pozerajú sa, ale nevidia: nie sú ochotní obrátiť sa k Bohu, aby im odpustil ich previnenia.“ ");
INSERT INTO slk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ježiš sa učeníkov opýtal: „Vy tomu podobenstvu nerozumiete? Ako potom chcete pochopiť to, čo vám hovorím!? Tak teda: ");
INSERT INTO slk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Rozsievačom zasieva Božie posolstvo. ");
INSERT INTO slk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Srdce niektorých poslucháčov je ako udupaná cesta. Satan ihneď prichádza a usiluje sa o to, aby zabudli, čo počuli. ");
INSERT INTO slk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Podobne je to aj s tými, u ktorých je slovo zasiate do skalnatej pôdy. Božie posolstvo si vypočujú a radostne ho prijmú. ");
INSERT INTO slk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nezakorení do hĺbky, je dočasné. Keď prídu ťažkosti alebo prenasledovanie, hneď sa vzdajú. ");
INSERT INTO slk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pôda zarastená bodľačím je obrazom ľudí, ktorí si Božiu radostnú zvesť vypočujú a prijmú ju, ");
INSERT INTO slk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ale každodenné starosti, túžba po majetku a pachtenie za tým, čo ponúka súčasná doba, udusia v srdci Božie posolstvo, takže zostane bez úžitku. ");
INSERT INTO slk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Napokon úrodnej pôde sa podobajú tí, ktorí prijmú Božiu zvesť bezvýhradne, a preto prinášajú bohatú úrodu: tridsať, šesťdesiat, ba i stonásobne viac, ako bolo do ich sŕdc zasiate.“ ");
INSERT INTO slk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Potom pokračoval: „Keď niekto rozsvieti lampu, zakryje ju azda nejakou nádobou alebo strčí pod posteľ? Alebo ju umiestni tak, aby všetkým jasne svietila? ");
INSERT INTO slk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Všetko, čo je teraz skryté, vyjde raz na svetlo, a čo je dnes utajované, vyjde najavo. ");
INSERT INTO slk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kto má uši na počúvanie, nech počúva! ");
INSERT INTO slk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Premýšľajte o tom, čo počujete! Akou mierou meriate, takou Boh nameria vám a ešte vám aj pridá. ");
INSERT INTO slk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ten, kto žije podľa Božieho slova, bude mu rozumieť stále viac. Ale ten, kto podľa neho nežije, čoskoro prestane rozumieť aj to, čo mu je teraz jasné.“ ");
INSERT INTO slk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ježiš hovoril ďalšie podobenstvá: „S Božím kráľovstvom je to tak, ako keď roľník zaseje na poli obilie. ");
INSERT INTO slk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dni ubiehajú, zrno vyklíči a rastie vo dne v noci bez jeho pričinenia. ");
INSERT INTO slk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Veď pôda prináša úrodu sama od seba: najprv steblo, potom klas a ten sa naleje zrnom. ");
INSERT INTO slk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A keď obilie napokon dozreje, príde žatva a roľník zožne úrodu.“ ");
INSERT INTO slk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","„Ako vám ešte môžem znázorniť Božie kráľovstvo? K čomu ho mám prirovnať?“ pokračoval Ježiš. ");
INSERT INTO slk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","„Je ako horčičné zrno: môžu ho zasiať ako to najmenšie semienko na poli. ");
INSERT INTO slk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ale keď ho zasejú do zeme, prerastie všetky byliny na poli a vyháňa také veľké vetvy, že vtáci môžu hniezdiť v ich tôni.“ ");
INSERT INTO slk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Použil ešte mnoho podobných podobenstiev, aby priblížil ľuďom svoje učenie. ");
INSERT INTO slk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Keď hovorieval verejne, používal výhradne podobenstvá. Ale keď potom zostal so svojimi učeníkmi osamote, všetko im vysvetlil. ");
INSERT INTO slk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Keď sa zvečerilo, navrhol Ježiš učeníkom: „Preplavme sa na druhý breh jazera.“ ");
INSERT INTO slk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Opustili zástup a v tej istej lodi, v ktorej Ježiš učil, odrazili od brehu. Niekoľko ďalších lodiek sa plavilo s nimi. ");
INSERT INTO slk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Onedlho sa na jazere strhla veľká búrka a víchrica. Obrovské vlny sa zapierali do loďky: čoskoro bola plná vody a hrozilo, že sa potopí. ");
INSERT INTO slk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ježiš však spal v zadnej časti lode s hlavou na poduške. Učeníci ho zobudili a celí zúfalí kričali: „Majstre, tebe je jedno, že sa utopíme!?“ ");
INSERT INTO slk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ježiš vstal, pohrozil vetru a prikázal moru: „Mlč! Utíš sa!“ V tej chvíli víchor prestal a zavládlo nesmierne ticho. ");
INSERT INTO slk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","„Prečo ste sa tak vyľakali? Nedôverujete mi?“ spýtal sa učeníkov. ");
INSERT INTO slk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Boli ohromení a pýtali sa jeden druhého: „Kto to vlastne je, že ho poslúcha vietor i more?“ ");
INSERT INTO slk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pristáli na druhom brehu jazera, v kraji Gerazénov. ");
INSERT INTO slk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Len čo Ježiš vystúpil z lode, vyšiel z hrobov oproti akýsi muž posadnutý démonmi. ");
INSERT INTO slk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Žil v hroboch vytesaných do skaly a nik ho nevládal skrotiť. ");
INSERT INTO slk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vždy znovu mu spútavali ruky reťazami a nohy okovami, ale on putá zakaždým rozlámal a reťaze potrhal. ");
INSERT INTO slk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vo dne v noci sa potĺkal medzi hrobmi, potuloval sa po pustých kopcoch, reval a zraňoval sa ostrými kameňmi. ");
INSERT INTO slk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Keď zbadal z diaľky Ježiša, pribehol, padol pred ním na kolená ");
INSERT INTO slk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a kričal: „Čo odo mňa chceš, Ježiš, Syn najvyššieho Boha? Prisahaj na Boha, že ma nebudeš trápiť!“ ");
INSERT INTO slk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ježiš mu totiž povedal: „Nečistý duch, vyjdi z neho!“ ");
INSERT INTO slk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ježiš sa ho spýtal: „Aké meno ti dali?“ – „Som Légia, lebo je nás mnoho,“ zaznela odpoveď. ");
INSERT INTO slk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A prosíkali, aby ich nevyháňal z tohto kraja. ");
INSERT INTO slk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na svahu kopca sa práve pásla veľká črieda svíň. ");
INSERT INTO slk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","„Pošli nás, aby sme vošli do tamtých svíň!“ žiadali démoni. ");
INSERT INTO slk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ježiš im to dovolil a nečistí duchovia vyšli z človeka a vošli do prasiat. Vzápätí sa tá veľká, asi dvojtisícová črieda splašila a rútila sa dolu svahom do jazera. Tam sa utopila. ");
INSERT INTO slk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pastieri svíň utekali preč a cestou o tom všade hovorili. Ľudia sa prichádzali pozrieť, čo sa vlastne stalo. ");
INSERT INTO slk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Keď videli posadnutého démonmi oblečeného a zdravého sedieť pokojne pri Ježišovi, vydesilo ich to. ");
INSERT INTO slk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tí, čo boli svedkami tejto udalosti, im totiž porozprávali, čo sa stalo, aj to, kde sa podelo stádo. ");
INSERT INTO slk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A tak začali všetci Ježiša prosiť, aby z ich kraja radšej odišiel. ");
INSERT INTO slk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ako Ježiš nastupoval na loďku, uzdravený ho prosil, aby mohol ísť s ním. ");
INSERT INTO slk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ale Ježiš nesúhlasil. „Choď domov k svojej rodine a povedz všetkým známym, aký zázrak vykonal Pán a aký bol k tebe milostivý.“ ");
INSERT INTO slk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A uzdravený naozaj chodil po kraji zvanom Desaťmestie a každému rozprával, aké dobrodenie mu Ježiš vykonal. A všetci nad tým žasli. ");
INSERT INTO slk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Keď sa Ježiš znova preplavil na druhý breh, opäť sa okolo neho zhromaždil obrovský zástup ľudí. ");
INSERT INTO slk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bol medzi nimi aj predstavený miestnej synagógy, ktorý sa volal Jairos. Keď ho zbadal, padol mu k nohám ");
INSERT INTO slk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a úpenlivo ho prosil: „Umiera mi dcérka. Prosím ťa, poď, polož na ňu ruky, aby bola zasa zdravá!“ ");
INSERT INTO slk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ježiš sa pobral s ním. Nasledovalo ho množstvo ľudí a tlačili sa naňho zo všetkých strán. ");
INSERT INTO slk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","V dave bola jedna žena, ktorá už dvanásť rokov trpela krvácaním. ");
INSERT INTO slk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Liečila sa u mnohých lekárov, minula na liečenie celý majetok, ale nič nepomáhalo: choroba sa jej stále zhoršovala. ");
INSERT INTO slk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","No dopočula sa o Ježišovi a jeho zázračnej moci, pretlačila sa k nemu zozadu a dotkla sa ho. ");
INSERT INTO slk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Povedala si totiž: „Ak sa čo len dotknem jeho rúcha, určite sa uzdravím!“ ");
INSERT INTO slk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A naozaj! Len čo sa ho dotkla, krvácanie prestalo a pocítila, že je úplne zdravá. ");
INSERT INTO slk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ježiš ihneď poznal, že z neho vyšla uzdravujúca moc, obrátil sa a spýtal sa: „Kto sa dotkol môjho rúcha?“ ");
INSERT INTO slk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Učeníci mu prekvapene odpovedali: „Prečo sa pýtaš, kto sa ťa dotkol? Veď vidíš koľko ľudí sa tu tlačí?“ ");
INSERT INTO slk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ale Ježiš sa obzeral, aby zistil, kto zo zástupu sa ho dotkol. ");
INSERT INTO slk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tu vyľakaná žena, ktorá sa triasla na celom tele, lebo cítila, čo sa s ňou stalo, padla Ježišovi k nohám a o všetkom mu povedala. ");
INSERT INTO slk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ježiš jej povedal: „Dcéra moja, tvoja viera ťa uzdravila. Môžeš pokojne odísť, choroba ťa už nebude trápiť.“ ");
INSERT INTO slk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kým sa s ňou zhováral, z Jairovho domu priniesli poslovia správu: „Tvoja dcéra zomrela, je zbytočné obťažovať Majstra.“ ");
INSERT INTO slk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Keď to Ježiš počul, povedal Jairovi: „Len sa neboj a dôveruj mi!“ ");
INSERT INTO slk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nikomu nedovolil ísť s ním a vzal so sebou iba Petra, Jakuba a jeho brata Jána. ");
INSERT INTO slk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dom predstaveného synagógy sa už ozýval srdcervúcim plačom a nárekom. ");
INSERT INTO slk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Vstúpil dnu a spýtal sa: „Načo ten plač a rozruch? Veď to dievča neumrelo, iba spí!“ ");
INSERT INTO slk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ale oni ho vysmiali. Všetkým kázal odísť a iba s rodičmi a tromi učeníkmi vošiel do miestnosti, kde ležalo dievča. ");
INSERT INTO slk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chytil ju za ruku a povedal: „Talitha kum!“ – čo znamená „Dievčatko: prikazujem ti, vstaň!“ ");
INSERT INTO slk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A to dvanásťročné dievča ihneď vstalo a chodilo. Všetci boli celkom bez seba. ");
INSERT INTO slk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ježiš im s veľkou vážnosťou kládol na srdce, aby nikomu nerozprávali o tom, čo sa stalo. Potom im pripomenul, aby dali dievčatku jesť. ");
INSERT INTO slk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Onedlho odišiel z toho kraja a vrátil sa aj so svojimi učeníkmi do Nazareta, svojho domovského mesta. ");
INSERT INTO slk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","V najbližšiu sobotu sa pobral do synagógy a tam vyučoval. Ľudia, ktorí ho počúvali, žasli a spytovali sa jeden druhého: „Kde sa to v ňom len berie? Kde získal takú múdrosť? Ba robí aj zázraky! ");
INSERT INTO slk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Veď je to obyčajný tesár! Poznáme ho, je to syn Márie! A poznáme aj jeho bratov Jakuba, Jozefa, Júdu a Šimona! Aj jeho sestry tu žijú s nami!“ A pohoršovali sa na ňom. ");
INSERT INTO slk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ježiš im na to povedal: „Nikde si proroka nevážia tak málo ako v jeho vlasti, vo vlastnom dome a v jeho rodine.“ ");
INSERT INTO slk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kvôli ich nevere tam nemohol prejaviť svoju moc nijakým zázrakom. Uzdravil len zopár ľudí tým, že na nich vložil ruky. ");
INSERT INTO slk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Čudoval sa, ako veľmi mu nedôverujú. Potom chodil po okolitých dedinách a vyučoval ľudí. ");
INSERT INTO slk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zavolal si dvanástich učeníkov, aby ich po dvoch vysielal vyslobodzovať ľudí od zlých duchov. ");
INSERT INTO slk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Prikázal im, aby si na cestu okrem palice nič nebrali: ani chlieb, ani nijakú kapsu, ani peniaze. ");
INSERT INTO slk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nemali ísť naboso, ale nemali si brať ani náhradnú obuv či šaty. ");
INSERT INTO slk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dal im takýto pokyn: „Ak vstúpite do niektorého domu, zostaňte v ňom až do svojho odchodu z toho mesta. ");
INSERT INTO slk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No ak by vás niekde nechceli prijať a nevypočuli vaše svedectvo, choďte preč a otraste si pred nimi aj prach zo svojich nôh, aby ste ich tak varovali pred Božím hnevom.“ ");
INSERT INTO slk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A tak sa učeníci vydali na cestu a nabádali ľudí: „Odvráťte sa od svojich hriechov!“ ");
INSERT INTO slk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Oslobodzovali ľudí od zlých duchov, mnohých chorých pomazali olejom a uzdravovali ich. ");
INSERT INTO slk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O Ježišovi sa všade veľa hovorilo a dopočul sa o ňom aj kráľ Herodes. Niektorí ľudia vraveli: „Ján Krstiteľ vstal z mŕtvych, preto koná také zázraky.“ ");
INSERT INTO slk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Iní sa nazdávali, že je to Eliáš, a ďalší boli presvedčení, že je to jeden z prorokov minulosti. ");
INSERT INTO slk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","No keď to počul Herodes, usúdil: „Je to Ján, ktorému som dal sťať hlavu. Určite vstal z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kráľ Herodes dal totiž Jána zatknúť a v putách zavrieť do žalára. Urobil to kvôli Herodiade, manželke svojho brata Filipa, ktorú si vzal za ženu. ");
INSERT INTO slk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ján Krstiteľ mu totiž vyčítal: „Tým, že žiješ s manželkou svojho brata, porušuješ zákon!“ ");
INSERT INTO slk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias ho za to znenávidela a usilovala sa pripraviť ho o život, ale neodvážila sa. ");
INSERT INTO slk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vedela, že Herodes Jána Krstiteľa berie vážne, pokladá ho za spravodlivého a svätého človeka a drží nad ním ochrannú ruku. Jánove slová ho síce vždy vnútorne rozrušili, ale predsa ho rád počúval. ");
INSERT INTO slk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Napokon sa Herodiade naskytla vhodná príležitosť. Herodes usporiadal na oslavu svojich narodenín slávnostnú hostinu a pozval na ňu dvoranov, dôstojníkov a významné osobnosti z celej Galiley. ");
INSERT INTO slk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na oslave tancovala Herodiadina dcéra a svojím pôvabom všetkých uchvátila. Herodes ňou bol taký očarený, že zvolal: „Žiadaj si odo mňa všetko, čo chceš, a dostaneš to!“ ");
INSERT INTO slk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Slávnostne sa pred všetkými zaprisahal, že jej dá čokoľvek; hoci aj polovicu svojho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dcéra sa šla poradiť s matkou. Tá ju naviedla, aby si žiadala hlavu Jána Krstiteľa. ");
INSERT INTO slk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Rýchlo sa vrátila a predniesla mu svoju žiadosť: „Chcem, aby si mi ihneď priniesol na mise hlavu Jána Krstiteľa.“ ");
INSERT INTO slk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kráľ veľmi zosmutnel, ale netrúfal si nesplniť sľub, ktorý dal pred všetkými hosťami. ");
INSERT INTO slk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Poslal teda do väzenia kata, aby sťal Jánovi hlavu. Kat príkaz splnil, sťal Jána v žalári ");
INSERT INTO slk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a priniesol jeho hlavu na mise. Dal ju dievčaťu a tá ju odovzdala svojej matke. ");
INSERT INTO slk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Keď sa to dopočuli Jánovi učeníci, prišli po jeho telo a pochovali ho. ");
INSERT INTO slk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apoštoli sa vrátili z ciest a znova sa zišli u Ježiša. Vyrozprávali mu všetko, čo robili a vyučovali. ");
INSERT INTO slk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ježiš im navrhol: „Utiahnime sa niekam do ústrania a odpočiňme si trochu.“ Stále boli totiž obklopení húfom ľudí a nemali sa kedy ani najesť. ");
INSERT INTO slk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chceli sa teda odplaviť na odľahlé miesto. ");
INSERT INTO slk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","No ľudia zbadali, ako odchádzajú na loďke. Bežali po brehu a keď loďka pristála, už tam na nich čakali. ");
INSERT INTO slk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Keď Ježiš vystúpil z loďky a uvidel ten obrovský zástup ľudí, prišlo mu ich ľúto, lebo boli ako ovce bez pastiera. Začal ich učiť mnohým veciam. ");
INSERT INTO slk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na sklonku dňa za ním prišli učeníci a pripomenuli mu: „Pozri, čas už pokročil a sme na pustom mieste. ");
INSERT INTO slk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Povedz ľuďom, aby si išli do okolitých dediniek a osád nakúpiť nejaké jedlo.“ ");
INSERT INTO slk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ježiš im odpovedal: „Vy sa im postarajte o jedlo!“ Namietli: „To máme pre všetkých nakúpiť jedlo za dvesto denárov?“ ");
INSERT INTO slk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Spýtal sa ich: „Koľko tu máte chleba? Choďte a zistite to!“ Vrátili sa a oznámili mu: „Dokopy päť chlebov a dve ryby.“ ");
INSERT INTO slk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ježiš vyzval ľudí, aby sa rozdelili na skupiny a usadili sa na tráve. ");
INSERT INTO slk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","V každej skupine bolo päťdesiat až sto ľudí. ");
INSERT INTO slk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Potom vzal tých päť chlebov, uprel zrak na nebo a poďakoval za ne Bohu. Rozlamoval chleby a podával učeníkom, aby ich roznášali ľuďom. To isté urobil aj s rybami. ");
INSERT INTO slk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Všetci sa najedli dosýta ");
INSERT INTO slk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","a ešte sa nazbieralo aj dvanásť košov zvyškov. ");
INSERT INTO slk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tak sa nasýtilo päťtisíc mužov. ");
INSERT INTO slk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hneď nato Ježiš prikázal učeníkom, aby opäť nasadli do loďky a preplavili sa na druhú stranu do Betsaidy. Sám ešte zostal, lebo sa chcel rozlúčiť s ľuďmi a poslať ich domov. ");
INSERT INTO slk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Keď sa rozišli, Ježiš sa pobral na vrch modliť. ");
INSERT INTO slk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nastala noc, učeníci boli uprostred jazera a on sa ešte modlil hore na vrchu. ");
INSERT INTO slk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na svitaní videl, že ešte vždy namáhavo veslujú, lebo sa plavili proti vetru. Vydal sa za nimi po hladine jazera a chcel sa priblížiť až k loďke. ");
INSERT INTO slk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Keď ho zbadali, ako kráča po vode, začali kričať od hrôzy, lebo si mysleli, že je to prízrak. ");
INSERT INTO slk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ale on ich upokojoval: „Hlavu hore! Nebojte sa, veď to som ja!“ ");
INSERT INTO slk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Vstúpil k nim do loďky a vietor ihneď utíchol. To ich ohromilo. ");
INSERT INTO slk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ani po zázraku s chlebmi a ani teraz stále nič nechápali – lebo pochopiť nechceli. ");
INSERT INTO slk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Potom pristáli na druhom brehu v genezaretskom kraji. ");
INSERT INTO slk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Len čo Ježiš vystúpil z loďky, ľudia ho ihneď spoznali. ");
INSERT INTO slk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Po celom kraji sa roznieslo, že sa sem priplavil. Nech prišiel kdekoľvek, z celého kraja prinášali k nemu chorých. ");
INSERT INTO slk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Všade, kam prišiel, v dedinách, v mestách, osadách alebo vonku na samotách, kládli na voľne prístupné miesta chorých. Prosili ho, aby sa mohli dotknúť aspoň okraja jeho šiat. A každý, kto sa ho s vierou dotkol, bol uzdravený. ");
INSERT INTO slk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farizeji a učitelia Zákona, ktorí prišli za Ježišom, ");
INSERT INTO slk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","zistili, že niektorí z jeho učeníkov jedia jedlo „nečistými“, teda neumytými rukami. ");
INSERT INTO slk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Židia, najmä farizeji, úzkostlivo lipli na zvykoch svojich predkov a nedotkli sa jedla, kým si obradným spôsobom neumyli ruky. ");
INSERT INTO slk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aj po návrate z trhu sa najprv obradne očistili, až potom sa pustili do prípravy jedla. Bolo ešte veľa podobných predpisov, ktoré prísne dodržiavali, ako napríklad umývanie čaší, džbánov a medeného riadu. ");
INSERT INTO slk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Preto teraz farizeji a učitelia Zákona dorážali do Ježiša: „Prečo tvoji učeníci nedodržiavajú zvyky našich predkov a jedávajú znesvätenými rukami?“ ");
INSERT INTO slk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ježiš im odpovedal: „Dobre to o vás, pokrytcoch, povedal prorok Izaiáš: ‚Tento ľud hovorí, že ma ctí, ale jeho srdce je odo mňa ďaleko. ");
INSERT INTO slk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","No márne ma uctieva, lebo vyučuje svoje vlastné zákony, a nie Božie.‘ ");
INSERT INTO slk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A naozaj, Božie príkazy zanedbávate a nahrádzate ich ľudskými tradíciami. ");
INSERT INTO slk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Veď vy vlastne rušíte Boží zákon v mene svojich zvykov. ");
INSERT INTO slk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tak napríklad Mojžiš vám takto tlmočil Božie prikázanie: ‚Cti svojho otca i matku.‘ A povedal tiež: ‚Kto potupí otca alebo matku, musí zomrieť.‘ ");
INSERT INTO slk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Vy však tvrdíte: ‚Ktokoľvek môže svojim rodičom povedať: Nemôžem vám pomôcť, lebo to, čo som vám zo svojho zárobku mohol dať, zaniesol som do chrámu.‘ ");
INSERT INTO slk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A vy učíte nielen to, ale dokonca bránite tomu človeku, aby pre svojho otca či matku urobil čokoľvek ďalšie; ");
INSERT INTO slk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","takto vlastné predpisy staviate nad Božie zákony. A to je len jeden príklad z mnohých.“ ");
INSERT INTO slk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Potom si zavolal k sebe zástup ľudí a povedal im: „Počúvajte, čo vám hovorím a pochopte: ");
INSERT INTO slk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Vaše vnútro neznečisťuje to, čo vchádza do úst, ale čo z nich vychádza.“ ");
INSERT INTO slk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ak má niekto uši na počúvanie, nech počúva! ");
INSERT INTO slk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Keď potom vstúpil do ktoréhosi domu, aby si odpočinul od zástupu, spýtali sa ho učeníci, čo mal tým výrokom na mysli. ");
INSERT INTO slk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ježiš sa začudoval: „Ani vy tomu nerozumiete? Nechápete, že duši človeka nemôže uškodiť to, čo prichádza zvonka? ");
INSERT INTO slk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Veď to nevchádza do jeho srdca. Jedlo prechádza vnútornosťami a vychádza z tela do žumpy!“ ");
INSERT INTO slk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Potom ešte dodal: „Človeka znesväcuje to, čo vychádza z jeho vnútra. ");
INSERT INTO slk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lebo z ľudského srdca vychádzajú zlé myšlienky, ktoré vedú k nečistým telesným túžbam, krádežiam, vraždám, ");
INSERT INTO slk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cudzoložstvu, chamtivosti, zákernosti, klamstvám, zlobe, podlosti, závisti, urážkam, pýche a bezuzdnosti. ");
INSERT INTO slk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Všetko toto zlo vychádza z vnútra človeka a vzďaľuje ho od Boha.“ ");
INSERT INTO slk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Potom Ježiš opustil Galileu a pobral sa do pohanského kraja v okolí miest Týru a Sidona. Ubytoval sa v jednom dome a chcel, aby to zostalo v tajnosti, ale márne: správa o jeho príchode sa hneď rozletela po celom kraji. ");
INSERT INTO slk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dozvedela sa o ňom aj žena, ktorá ho vyhľadala a na kolenách prosila, aby uzdravil jej pomätenú dcérku. ");
INSERT INTO slk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tá žena bola pohanka, pochádzala z Fenície. ");
INSERT INTO slk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ježiš jej povedal: „Nechaj, nech sa najprv nasýtia deti, lebo nie je správne brať chlieb deťom a hádzať ho psom!“ ");
INSERT INTO slk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ale žena sa nedala odbiť. „Pane, šteňatám spadnú zo stola aspoň omrvinky po deťoch.“ ");
INSERT INTO slk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ježiš jej povedal: „Pre tvoje slová, ktorými si ukázala, ako mi dôveruješ, zlý duch vyšiel z tvojej dcéry.“ ");
INSERT INTO slk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A naozaj, keď sa žena vrátila domov, našla dieťa pokojne spať. Po pomätenosti nebolo ani stopy. ");
INSERT INTO slk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Z Týru šiel Ježiš do Sidonu a odtiaľ popri Galilejskom mori do oblasti zvanej Desaťmestie. ");
INSERT INTO slk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tam k nemu priviedli človeka, ktorý bol hluchý a rozprával len s ťažkosťami: chceli, aby ho Ježiš uzdravil. ");
INSERT INTO slk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ježiš ho odviedol trochu nabok od ľudí, dotkol sa prstami jeho uší a potom sa mu naslineným prstom dotkol jazyka. ");
INSERT INTO slk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Uprel zrak k nebu, so stonom sa pomodlil a zvolal: „Efata!“ – čo znamená „Otvor sa!“ ");
INSERT INTO slk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","V tej chvíli hluchonemý počul a začal zrozumiteľne hovoriť. ");
INSERT INTO slk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Potom sa Ježiš obrátil k prítomným a žiadal ich, aby o tom nikomu nehovorili. Ale čím väčšmi to prikazoval, tým rýchlejšie sa správa o tom šírila. ");
INSERT INTO slk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ľudia žasli a nevychádzali z údivu: „Robí neuveriteľné veci! Hluchým vracia sluch a nemým reč!“ ");
INSERT INTO slk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Okolo Ježiša sa opäť zhromaždilo veľké množstvo ľudí. Boli s ním tak dlho, že sa im minuli všetky zásoby. Ježiš si zavolal učeníkov a povedal im: ");
INSERT INTO slk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Je mi ľúto týchto ľudí. Sú tu so mnou už tri dni a nemajú čo jesť. ");
INSERT INTO slk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ak ich pustím domov hladných, môžu cestou odpadnúť od vysilenia, veď niektorí prišli zďaleka.“ ");
INSERT INTO slk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Učeníci zareagovali: „Kto a ako by mohol v tejto pustatine zohnať chlieb pre toľkých ľudí?“ ");
INSERT INTO slk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","„Koľko chlebov tu máte?“ spýtal sa ich. „Sedem,“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nato poprosil všetkých zhromaždených, aby si posadali na zem. Potom vzal tých sedem chlebov, poďakoval za ne Bohu, odlamoval z nich a dával svojim učeníkom, aby ich roznášali ľuďom. ");
INSERT INTO slk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mali pri sebe aj niekoľko neveľkých rýb. Ježiš sa aj za ne poďakoval a dal ich učeníkom, aby ich poroznášali. ");
INSERT INTO slk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Všetci sa dosýta najedli a ešte sa aj nazbieralo sedem košov zvyškov. ");
INSERT INTO slk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tentoraz bolo v zástupe asi štyritisíc ľudí. Keď sa najedli, Ježiš ich poslal domov. ");
INSERT INTO slk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Potom nastúpil do loďky a spolu so svojimi učeníkmi sa preplavil do dalmanutského kraja. ");
INSERT INTO slk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Keď sa o jeho príchode dozvedeli tamojší farizeji, prišli k nemu a pokúšali ho: „Urob nejaký zázrak! Chceme vidieť nejaké znamenie z neba, až potom ti uveríme!“ ");
INSERT INTO slk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ježiš si smutne vzdychol a povedal: „Prečo chcete tak veľmi vidieť znamenia? Jedno je isté: ľudia ako vy nijaké znamenie od Boha nedostanú!“ ");
INSERT INTO slk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nechal ich tam, nastúpil do loďky a odplavil sa na druhý breh jazera. ");
INSERT INTO slk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Učeníci zabudli nakúpiť potraviny, a tak mali v loďke iba jeden chlieb. ");
INSERT INTO slk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Počas plavby im Ježiš kládol na srdce: „Dajte si pozor na kvas farizejov i na kvas kráľa Herodesa!“ ");
INSERT INTO slk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","„Čo tým myslí?“ pýtali sa jeden druhého. Napokon sa zhodli, že akiste naráža na to, že zabudli kúpiť chlieb. ");
INSERT INTO slk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ježiš vedel, o čom sa dohadujú, a povedal: „Nie, nejde o to. Ešte stále nechápete a nerozumiete? To máte také otupené srdce? ");
INSERT INTO slk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nevidíte, napriek tomu, že máte oči? A napriek tomu, že máte uši, nepočujete? To ste už zabudli, ");
INSERT INTO slk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","koľko košov zvyškov ste pozbierali, keď som rozlámal päť chlebov piatim tisícom?“ – „Dvanásť,“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","„A keď som nasýtil štyritisíc ľudí iba siedmimi chlebmi, koľko ešte zostalo? Spomínate si?“ – „Sedem košov,“ odvetili. ");
INSERT INTO slk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","„A ešte vždy nechápete?“ ");
INSERT INTO slk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Keď sa dostali do Betsaidy, priviedli k nemu slepca a prosili, aby ho dotykom uzdravil. ");
INSERT INTO slk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ježiš ho vzal za ruku a vyviedol za dedinu. Tam sa mu naslinenými prstami dotkol očí a spýtal sa ho: „Vidíš niečo?“ ");
INSERT INTO slk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Muž sa poobzeral a zvolal: „Áno, vidím ľudí, ale nejasne, vyzerajú ako chodiace stromy.“ ");
INSERT INTO slk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ježiš sa ešte raz dotkol jeho očí. Keď sa muž znova rozhliadol okolo seba, videl všetko zreteľne a jasne, oči mal úplne zdravé. ");
INSERT INTO slk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ježiš mu povedal, že môže ísť domov a dodal: „Cez dedinu teraz nechoď.“ ");
INSERT INTO slk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Potom Ježiš so svojimi učeníkmi opustil Galileu a prechádzal dedinkami v okolí Cézarey Filipovej. Cestou položil svojim učeníkom otázku: „Za koho ma ľudia pokladajú?“ ");
INSERT INTO slk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Odpovedali mu: „Niektorí sa domnievajú, že si Ján Krstiteľ, ďalší vravia, že si Eliáš alebo iný veľký prorok.“ ");
INSERT INTO slk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","„A vy? Kto som podľa vás?“ opýtal sa. „Ty si Kristus!“ zvolal Peter. ");
INSERT INTO slk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ježiš im však prikázal, aby o tom nikomu nehovorili. ");
INSERT INTO slk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Vtedy im prvý raz hovoril: „Syn človeka musí veľmi trpieť. Židovskí vodcovia, veľkňazi a učitelia Zákona ho odsúdia a zabijú, ale na tretí deň vstane z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rozprával o tom celkom otvorene, preto ho Peter odviedol nabok a usiloval sa ho od toho odhovoriť. ");
INSERT INTO slk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ježiš sa však obrátil k učeníkom a pokarhal Petra: „Choď mi z cesty, satan! Pozeráš sa na veci len ľudskými očami. Nevieš, aká je Božia vôľa.“ ");
INSERT INTO slk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Potom sa prihovoril k zástupu i k učeníkom: „Kto ma chce nasledovať, nech prestane myslieť na seba, nech sa nebojí pre mňa trpieť a ide za mnou! ");
INSERT INTO slk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Komu ide len o jeho vlastný život, stratí ho, ale kto je ochotný obetovať svoj život pre mňa a pre zvesť evanjelia, získa ho. ");
INSERT INTO slk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Čo by z toho človek mal, keby získal hoc aj celý svet, ale skutočný život stratí? ");
INSERT INTO slk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Čo môže vyvážiť hodnotu večného života? ");
INSERT INTO slk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ak sa niekto hanbí za mňa a za moje slová pred nevernými a hriešnymi ľuďmi, za toho sa bude hanbiť aj Syn človeka, keď sa vráti so svätými anjelmi v sláve svojho Otca.“ ");
INSERT INTO slk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Potom sa obrátil k svojim poslucháčom a pokračoval: „Niektorí z vás ešte za svojho života uvidíte, ako sa prejaví moc Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Asi týždeň po tomto rozhovore vzal Ježiš so sebou Petra, Jakuba a Jána a vyšli spolu na vysoký vrch, aby boli sami. Tam sa pred nimi premenil. ");
INSERT INTO slk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jeho oblečenie sa stalo žiarivo bielym a skvelo sa takou belosťou, aká sa ničím na svete nedá dosiahnuť. ");
INSERT INTO slk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Zjavil sa im Eliáš a Mojžiš a rozprávali sa s Ježišom. ");
INSERT INTO slk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter zvolal: „Ako dobre, že sme tu! Postavme tu tri stany, pre každého jeden: tebe, Mojžišovi a Eliášovi!“ ");
INSERT INTO slk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Vravel to, lebo od strachu nevedel, čo povedať. ");
INSERT INTO slk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Vtom ich všetkých zastrel oblak a z neho sa ozval hlas: „Toto je môj milovaný Syn. Počúvajte ho!“ ");
INSERT INTO slk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Keď sa mrak rozplynul, učeníci sa rozhliadli, ale okrem Ježiša nevideli už nikoho. ");
INSERT INTO slk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Keď zostupovali z vrchu, Ježiš ich upozornil, aby o tom, čo videli, nerozprávali nikomu dovtedy, kým Syn človeka nevstane z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zachovali to v tajnosti, ale medzi sebou často uvažovali, čo to znamená „vstať z mŕtvych“. ");
INSERT INTO slk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Spytovali sa Ježiša: „Prečo učitelia Zákona tvrdia, že sa pred príchodom Mesiáša musí vrátiť Eliáš?“ ");
INSERT INTO slk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Odpovedal im: „Správne, najprv mal prísť Eliáš, aby dal všetko do poriadku. Ale čo myslíte, o čom hovorili proroci, keď predpovedali, že Syn človeka musí mnoho vytrpieť a že ním budú pohŕdať? ");
INSERT INTO slk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hovorím vám: Eliáš už prišiel, ale naložili s ním, ako sa im páčilo; ako o ňom predpovedali proroci.“ ");
INSERT INTO slk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Keď sa vrátili k ostatným učeníkom, našli ich obklopených veľkým zástupom. Boli tam aj učitelia Zákona, ktorí sa s nimi hádali. ");
INSERT INTO slk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A ľudia, len čo zazreli Ježiša, užasli, bežali mu naproti a vítali ho. ");
INSERT INTO slk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Spýtal sa ich: „O čom sa dohadujete?“ ");
INSERT INTO slk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Akýsi muž zo zástupu mu povedal: „Majstre, priviedol som k tebe svojho syna. Je nemý, lebo ho ovláda zlý duch. ");
INSERT INTO slk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Zakaždým, keď sa chlapca zmocní, zvíja sa v kŕčoch, spenia sa mu ústa, škrípe zubami a celý zmeravie. Poprosil som tvojich učeníkov, aby zlého ducha vyhnali, ale nemohli.“ ");
INSERT INTO slk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","„Čo je to s vami? Kedy konečne začnete veriť!“ zvolal Ježiš. „Dokedy mám byť s vami? Dokedy mám mať s vami trpezlivosť? Priveďte chlapca ku mne!“ ");
INSERT INTO slk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Priviedli ho. No len čo zlý duch spoznal Ježiša, strašne zalomcoval chlapcom. Spadol na zem a zvíjal sa v kŕčoch s penou na ústach. ");
INSERT INTO slk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","„Odkedy takto trpí?“ spýtal sa Ježiš otca. Ten odpovedal: „Už odmala. ");
INSERT INTO slk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zlý duch ho neraz hodil aj do ohňa alebo do vody; chcel ho zahubiť. Och, zmiluj sa nad nami a pomôž nám, ak môžeš!“ ");
INSERT INTO slk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","„Ak môžem?“ začudoval sa Ježiš. „Pre toho, kto verí, je možné všetko!“ ");
INSERT INTO slk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Otec ihneď zvolal: „Verím, Pane, ale pomôž mi veriť viac!“ ");
INSERT INTO slk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ježiš si všimol, že sa zbiehajú ďalší ľudia, a tak prikázal: „Duch hluchoty a nemoty, vyjdi z neho a nikdy sa už nevracaj!“ ");
INSERT INTO slk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zlý duch zreval, zalomcoval chlapcom a opustil ho. Chlapec zostal ležať na zemi bez známok života. Mnohí si mysleli, že zomrel. ");
INSERT INTO slk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ale Ježiš chytil chlapca za ruku a pomohol mu vstať. ");
INSERT INTO slk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Keď potom vošiel do domu a učeníci s ním zostali sami, spýtali sa ho: „Prečo sme my nemohli vyhnať toho zlého ducha?“ ");
INSERT INTO slk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ježiš im odpovedal: „Takého ducha nemožno vyhnať inak ako modlitbou a pôstom!“ ");
INSERT INTO slk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ježiš opustil s učeníkmi tento kraj a prechádzal Galileou, ale nechcel, aby sa o tom vedelo. ");
INSERT INTO slk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chcel sa venovať svojim učeníkom. Hovoril im: „Syna človeka onedlho vydajú napospas ľuďom, zabijú ho, ale na tretí deň vstane a bude žiť.“ ");
INSERT INTO slk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jeho slovám však nerozumeli a neodvažovali sa ho na to ani spýtať. ");
INSERT INTO slk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Potom sa vrátili do Kafarnauma. Keď boli v dome, Ježiš sa opýtal učeníkov: „O čom ste sa to cestou zhovárali?“ ");
INSERT INTO slk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nikto mu neodpovedal. Cestou sa totiž dohadovali o tom, kto z nich je najdôležitejší. ");
INSERT INTO slk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ježiš si sadol, zavolal si ich k sebe a povedal im: „Kto chce byť najdôležitejším, ten sa musí stať posledným zo všetkých a musí byť ich služobníkom.“ ");
INSERT INTO slk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Potom zavolal dieťa, postavil ho medzi nich, objal ho a povedal im: ");
INSERT INTO slk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Kto prijíma čo i len jedného zdanlivo nedôležitého človeka ako je toto dieťa v mojom mene, mňa prijíma. A neprijíma len mňa, ale aj toho, ktorý ma poslal.“ ");
INSERT INTO slk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ján mu povedal: „Majstre, videli sme človeka, ako v tvojom mene vyháňa démonov. Usilovali sme sa mu v tom zabrániť, lebo nepatrí medzi nás.“ ");
INSERT INTO slk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ježiš namietol: „Nebráňte mu! Veď predsa nikto, kto robí v mojom mene zázraky, nemôže sa hneď potom obrátiť proti mne. ");
INSERT INTO slk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kto nie je proti nám, je s nami. ");
INSERT INTO slk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A keby vám niekto podal pohár vody len preto, že ste moji, hovorím vám, že nepríde o svoju odmenu. ");
INSERT INTO slk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ale ak by niekto zviedol na hriech niekoho z tých zdanlivo bezvýznamných, čo veria vo mňa, lepšie by bolo, keby mu na krk dali mlynský kameň a hodili ho do mora. ");
INSERT INTO slk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ak ťa zvádza na hriech ruka, odtni ju. Je ti rozhodne lepšie byť bez ruky a získať večný život, ako mať obe ruky a ísť do neuhasiteľného pekelného ohňa, ");
INSERT INTO slk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kde červ, ktorý sa nimi sýti neumiera a ich oheň nevyhasína. ");
INSERT INTO slk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A ak ťa navádza na zlé noha, odtni ju. Lepšie je byť mrzákom a získať večný život, ako mať dve nohy, ktoré ťa zavedú do večnej záhuby, ");
INSERT INTO slk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kde červ, ktorý sa nimi sýti neumiera a ich oheň nevyhasína. ");
INSERT INTO slk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A tak aj oko, ak je pôvodcom zla v tvojom živote, zbav sa ho. Lepšie je vojsť do Božieho kráľovstva ako jednooký, než mať obe oči a byť uvrhnutý do pekelného ohňa, ");
INSERT INTO slk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kde nárek neprestáva a oheň nevyhasína. ");
INSERT INTO slk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Každý bude osolený ohňom a každá obeť očistená soľou. ");
INSERT INTO slk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Soľ je dobrá vec. Ale ak stratí svoju chuť, čo jej ju vráti? Tak dbajte, aby ste boli soľou. A žite navzájom v pokoji.“ ");
INSERT INTO slk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ježiš opustil Kafarnaum a cez Zajordánsko prešiel až do Judska. Aj tu sa okolo neho zhromaždili zástupy ľudí, ktoré ako zvyčajne vyučoval. ");
INSERT INTO slk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Prišli za ním farizeji a chceli ho nachytať. Spýtali sa ho: „Je povolený rozvod?“ ");
INSERT INTO slk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Namiesto odpovede im dal otázku: „Čo vám prikázal Mojžiš?“ ");
INSERT INTO slk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Odpovedali mu: „Podľa Mojžiša stačí, ak dá muž svojej žene rozvodový list, a manželstvo je zrušené.“ – ");
INSERT INTO slk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","„Týmto ustanovením urobil Mojžiš ústupok tvrdosti vášho srdca,“ povedal na to Ježiš a pokračoval: ");
INSERT INTO slk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","„Už na počiatku ich Boh stvoril ako muža a ženu. ");
INSERT INTO slk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Preto muž opustí svojho otca i svoju matku, pripojí sa k svojej žene ");
INSERT INTO slk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","a tí dvaja sa stanú jedným telom. Takže potom už nežijú ako dvaja jednotlivci, ale stávajú sa jedným telom. ");
INSERT INTO slk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A preto nech nikto nerozdeľuje, čo Boh spojil.“ ");
INSERT INTO slk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Neskôr, keď boli spolu v dome, učeníci sa ho na to znovu pýtali. ");
INSERT INTO slk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Povedal im: „Ak muž opustí svoju ženu a ožení sa s inou, dopúšťa sa cudzoložstva. ");
INSERT INTO slk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tak isto aj žena: ak opustí svojho muža a vydá sa za iného, cudzoloží.“ ");
INSERT INTO slk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niektorí ľudia prinášali k Ježišovi deti, aby ich požehnal. Učeníci však proti tomu rázne zakročili. ");
INSERT INTO slk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Keď to Ježiš videl, nahneval sa a povedal: „Nechajte deti prísť ku mne a nebráňte im v tom, lebo práve takým ako oni patrí Božie kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Zapamätajte si: Kto nepríde k Bohu s detskou dôverou, do nebeského kráľovstva sa nedostane.“ ");
INSERT INTO slk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Potom vzal každé dieťa do náručia, položil mu ruku na hlávku a požehnal ho. ");
INSERT INTO slk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Keď sa zase vydal na cestu, dobehol ho akýsi muž, kľakol si pred ním a spýtal sa ho: „Dobrý učiteľ, čo mám robiť, aby som získal večný život?“ ");
INSERT INTO slk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ježiš mu odpovedal: „Prečo ma nazývaš dobrým? Veď dobrý je len Boh. ");
INSERT INTO slk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A poznáš predsa prikázania: Nezabiješ; Nescudzoložíš; Neukradneš; Nebudeš falošne svedčiť; Budeš si vážiť svojich rodičov.“ ");
INSERT INTO slk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","On mu na to odpovedal: „Majstre, ale veď podľa týchto prikázaní žijem už od svojej mladosti.“ ");
INSERT INTO slk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ježiš sa na muža zahľadel a s láskou mu povedal: „A predsa ti ešte niečo chýba. Choď a predaj všetko, čo máš, peniaze rozdaj chudobným, a poklad v nebi bude tvoj. Potom sa vráť a staň sa mojím nasledovníkom.“ ");
INSERT INTO slk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Muž po týchto slovách zosmutnel a odišiel so zvesenou hlavou. Bol totiž veľmi bohatý. ");
INSERT INTO slk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ježiš sa rozhliadol okolo seba a povedal svojim učeníkom: „Ako ťažko sa bohatým vstupuje do Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Keď videl, ako ich jeho slová prekvapili, zopakoval ešte raz: „Priatelia, je ťažké dostať sa do Božieho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ľahšie prejde ťava uchom ihly, ako bohatý vojde do Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","To učeníkov ešte väčšmi zmiatlo a spytovali sa jeden druhého: „Tak kto vlastne môže byť zachránený?“ ");
INSERT INTO slk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ježiš sa na nich uprene pozrel a povedal: „Ľudia sa sami zachrániť nemôžu. To môže urobiť len Boh, pretože u Boha je možné všetko.“ ");
INSERT INTO slk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Vtom sa ozval Peter: „A ako je to s nami? My sme predsa nechali všetko a šli sme za tebou!“ ");
INSERT INTO slk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ježiš mu na to odpovedal: „Buďte si istí, že každý, kto sa z lásky ku mne a pre šírenie evanjelia niečoho vzdá: domova, života so súrodencami, s rodičmi a s deťmi, alebo majetku, ");
INSERT INTO slk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","vráti sa mu to stonásobne už teraz, v tomto čase, a v budúcnosti ho čaká večný život. No tu na tomto svete musí rátať aj s prenasledovaním. ");
INSERT INTO slk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mnohí, ktorých dnes obdivujú, nebudú nič znamenať. A iní, ktorých si dnes nikto nevšimne, budú patriť medzi prvých.“ ");
INSERT INTO slk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Keď sa uberali do Jeruzalema, Ježiš kráčal vpredu. Učeníci boli znepokojení a tí, čo ho nasledovali, boli plní úzkosti. Ježiš vzal dvanástich učeníkov stranou a znova im hovoril o tom, čo ho čaká. ");
INSERT INTO slk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Ideme do Jeruzalema a Syn človeka bude vydaný do rúk veľkňazov a učiteľov Zákona. Tí ho odsúdia na smrť a vydajú pohanom. ");
INSERT INTO slk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Budú sa mu verejne posmievať, pľuvať na neho, zbičujú ho a zabijú. Ale na tretí deň vstane z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Potom k nemu pristúpili Zebedejovi synovia Jakub a Ján a povedali mu: „Majstre, chceme, aby si nám splnil to, o čo ťa požiadame.“ ");
INSERT INTO slk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ježiš sa spýtal: „A čo také by to malo byť?“ ");
INSERT INTO slk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Odpovedali mu: „Keď sa ujmeš vlády vo svojom kráľovstve, chceli by sme mať čo najvýznamnejšie postavenie.“ ");
INSERT INTO slk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ježiš im na to povedal: „Ani netušíte, o čo žiadate. Vari môžete piť z kalicha, z ktorého musím piť ja, a prejsť krstom, ktorý ma čaká?“ ");
INSERT INTO slk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","„Áno, môžeme,“ prisvedčili. Ježiš im na to povedal: „Je to tak. Budete piť z môjho kalicha a budete pokrstení rovnakým krstom. ");
INSERT INTO slk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ale nie je mojou vecou určovať, kto zaujme miesto po mojej pravici či ľavici. To už rozhodol Boh.“ ");
INSERT INTO slk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Keď ostatní učeníci zistili, o čo žiadali Jakub a Ján, veľmi sa na nich rozhnevali. ");
INSERT INTO slk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ježiš si ich však zavolal a povedal im: „Viete, že vládcovia a králi utláčajú svojich podriadených, a tí, čo majú moc, ju neraz zneužívajú. ");
INSERT INTO slk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ale medzi vami to tak nemá byť. Naopak, kto chce byť medzi vami dôležitý, nech všetkým pokorne slúži. ");
INSERT INTO slk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A kto chce byť prvý, nech sa stane sluhom všetkých. ");
INSERT INTO slk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Veď ani Syn človeka neprišiel na svet preto, aby mu ostatní slúžili, ale aby slúžil a dal svoj život ako výkupné za všetkých.“ ");
INSERT INTO slk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ježiš potom prechádzal so svojimi učeníkmi cez Jericho. Tu sa k nim pridal veľký zástup. Keď neskôr opúšťali mesto, sedel pri ceste slepý žobrák Bartimej, syn Timejov. ");
INSERT INTO slk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Keď počul, že prichádza Ježiš z Nazareta, začal kričať: „Ježiš, syn Dávidov, zľutuj sa nado mnou!“ ");
INSERT INTO slk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ľudia ho napomínali, aby mlčal. On však kričal ešte hlasnejšie: „Syn Dávidov, zľutuj sa nado mnou!“ ");
INSERT INTO slk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ježiš sa zastavil a dal muža zavolať k sebe. Bežali poňho a povedali mu: „Máš šťastie, Ježiš ťa volá. Vstaň!“ ");
INSERT INTO slk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Slepý ihneď odhodil svoj plášť, vyskočil a prišiel k Ježišovi. ");
INSERT INTO slk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","„Čo chceš, aby som pre teba urobil?“ spýtal sa Ježiš. Bartimej odpovedal: „Majstre, chcem opäť vidieť!“ ");
INSERT INTO slk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ježiš mu povedal: „Tvoja viera ťa uzdravila, môžeš ísť.“ V tej chvíli sa slepému vrátil zrak a šiel po tej ceste za Ježišom. ");
INSERT INTO slk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Keď sa priblížili k Jeruzalemu a stúpali na Olivový vrch, zbadali pred sebou dedinky Betfage a Betániu. ");
INSERT INTO slk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ježiš poslal dvoch zo svojich učeníkov dopredu a povedal im: „Choďte do dedinky pred nami. Hneď na kraji uvidíte oslíka, na ktorom ešte nikto nejazdil. Odviažte ho a priveďte sem. ");
INSERT INTO slk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A keby sa vás niekto spýtal, čo to robíte, odpovedzte mu: Pán ho potrebuje, no čoskoro ho vráti.“ ");
INSERT INTO slk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Učeníci odišli a naozaj našli pri akejsi bránke priviazaného oslíka. ");
INSERT INTO slk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Odviazali ho, ale niektorí ľudia, čo tam stáli, sa ich spýtali: „Čo to robíte? Prečo toho oslíka odväzujete?“ ");
INSERT INTO slk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Odpovedali tak, ako im poradil Ježiš, a ľudia im dovolili zviera odviesť. ");
INSERT INTO slk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Priviedli ho k Ježišovi, prehodili mu cez chrbát plášte a Ježiš naň vysadol. ");
INSERT INTO slk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mnohí ľudia zo zástupu, čo ich sprevádzal, prestierali pred neho svoje plášte, lámali zelené vetvičky zo stromov a vystielali mu nimi cestu. ");
INSERT INTO slk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pred ním i za ním sa utvoril veľký sprievod a všetci volali: „Hosana! Nech Boh požehná toho, ktorý prichádza v jeho mene! ");
INSERT INTO slk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nech Boh požehná prichádzajúce Dávidovo kráľovstvo! Hosana na výsostiach!“ ");
INSERT INTO slk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tak vstúpil Ježiš do Jeruzalema a pobral sa do chrámu. Pozoroval, čo sa tam deje. Keďže bol už večer, odišiel so svojimi dvanástimi učeníkmi na noc do Betánie. ");
INSERT INTO slk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na druhý deň, keď vyšli z Betánie, Ježiš vyhladol. Z diaľky zazrel figovník bohato obsypaný lístím. ");
INSERT INTO slk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Šiel sa pozrieť, či na ňom nenájde nejaké figy. Ale ovocie na ňom nebolo; len samé lístie. Figy mali ešte len dozrievať. ");
INSERT INTO slk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tu počuli učeníci, ako hovorí stromu: „Nech už z teba nikto nikdy neje ovocie!“ ");
INSERT INTO slk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vrátili sa do Jeruzalema a Ježiš vošiel do chrámu. Keď videl hluk, ktorý tam panoval, začal vyháňať tých, čo v chráme predávali a kupovali. Peňazomencom pováľal stoly a predavačom holubov stánky; ");
INSERT INTO slk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","nedovolil ani, aby sa cez chrám čokoľvek nosilo. ");
INSERT INTO slk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pripomínal im: „Neviete, že je napísané: ‚Môj chrám bude pre všetkých miestom modlitby?‘ Ale vy ste ho premenili na brloh lotrov.“ ");
INSERT INTO slk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Počuli to aj veľkňazi a učitelia Zákona a začali vymýšľať plány, ako by ho zabili. Naháňal im však strach, lebo ľud bol nadšený jeho učením. ");
INSERT INTO slk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Keď sa zvečerilo, Ježiš s učeníkmi odišiel z mesta. ");
INSERT INTO slk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na druhé ráno, keď šli zasa popri figovníku, videli, že je úplne vyschnutý. ");
INSERT INTO slk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter si spomenul, čo včera povedal Ježiš, a zvolal: „Majstre, pozri! Strom, ktorému si včera zlorečil, vyschol!“ ");
INSERT INTO slk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ježiš na to odpovedal: „Stačí dôverovať Bohu! ");
INSERT INTO slk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Keby niekto napríklad povedal tomuto vrchu: Zdvihni sa a hoď sa do mora, stane sa tak. Ale podmienkou je, aby nemal nijaké pochybnosti a bezvýhradne veril, že Boh jeho prosbu splní. ");
INSERT INTO slk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pamätajte si: všetko, o čo vo viere Boha prosíte, ste už dostali a patrí vám to. ");
INSERT INTO slk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ale keď sa za niečo modlíte, najprv odpustite ľuďom to, čo proti nim máte, aby aj vám váš nebeský Otec odpustil vaše previnenia. ");
INSERT INTO slk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ak však vy neodpustíte ľuďom, ani nebeský Otec vám neodpustí vaše previnenia.“ ");
INSERT INTO slk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ježiš a učeníci prišli opäť do Jeruzalema. Keď Ježiš prechádzal chrámom, zastavili ho veľkňazi, učitelia Zákona a židovskí vodcovia ");
INSERT INTO slk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a spýtali sa ho: „Akým právom robíš to, čo robíš? Kto ťa tým poveril?“ ");
INSERT INTO slk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ježiš im odpovedal: „Aj ja sa vás na niečo spýtam. Ak mi odpoviete, poviem vám, od koho mám tú moc. ");
INSERT INTO slk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Povedzte mi: Keď Ján krstil – od koho mal poverenie? Od Boha alebo od ľudí? Odpovedzte!“ ");
INSERT INTO slk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Začali sa medzi sebou dohadovať: „Ak mu odpovieme, že ho poslal Boh, spýta sa nás, prečo sme mu neuverili. ");
INSERT INTO slk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ak však povieme, že ľudia, pobúrime si proti sebe ľud, lebo všetci sú presvedčení, že Ján bol prorok.“ ");
INSERT INTO slk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A tak napokon odpovedali Ježišovi: „Nevieme.“ Nato im Ježiš povedal: „Ani ja vám teda nepoviem, kto mi dal moc konať to, čo konám.“ ");
INSERT INTO slk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Potom židovským vodcom povedal podobenstvo: „Istý človek vysadil vinicu, ohradil ju plotom, postavil lis na víno a strážnu vežu. Potom vinicu prenajal vinohradníkom a sám odcestoval. ");
INSERT INTO slk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Keď nastal čas oberačky, poslal jedného zo sluhov, aby od nájomníkov prevzal diel z úrody, ktorý mu patril. ");
INSERT INTO slk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ale vinohradníci ho zbili a poslali preč s prázdnymi rukami. ");
INSERT INTO slk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Majiteľ poslal druhého. Toho kameňovali, rozbili mu hlavu a vyhnali. ");
INSERT INTO slk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Poslal teda iného, no toho zabili. Majiteľ vyslal aj ďalších poslov, ale k všetkým sa správali surovo, niektorých zbili, ostatných zabili. ");
INSERT INTO slk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Napokon poslal posledného – svojho milovaného syna. Povedal si totiž: ‚Pred mojím synom určite budú mať rešpekt.‘ ");
INSERT INTO slk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ale vinohradníci si povedali: ‚To je jediný dedič. Zabime ho a vinica bude naša.‘ ");
INSERT INTO slk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A tak ho chytili, zmlátili na smrť a jeho mŕtve telo vyhodili z vinice. ");
INSERT INTO slk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Čo myslíte, čo urobí majiteľ vinice, keď sa to dozvie? Príde osobne, všetkých dá pozabíjať a vinicu prenajme iným. ");
INSERT INTO slk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Len si spomeňte, čo je napísané v Písme: ‚Kameň, ktorý zavrhli stavitelia, stal sa kameňom základným, najdôležitejším v celej stavbe. ");
INSERT INTO slk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Urobil to Pán a z nášho pohľadu je to čosi obdivuhodné.‘ “ ");
INSERT INTO slk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Židovskí vodcovia pochopili, že tento príbeh sa vzťahuje na nich. Chceli sa ho preto zmocniť, ale báli sa naňho siahnuť zo strachu pred ľuďmi. Museli ho nechať tak a odišli. ");
INSERT INTO slk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Židovskí vodcovia potom poslali za Ježišom niekoľko farizejov a Herodesových prívržencov, aby ho pri rozhovore s nimi chytili do pasce a mohli ho obžalovať. ");
INSERT INTO slk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Povedali: „Majstre, vieme, že ti ide o pravdu a že sa vo svojich názoroch nedáš nikým ovplyvniť. Učíš ľudí pravej ceste k Bohu. Povedz nám teda: je správne platiť cisárovi dane, alebo nie? Máme to robiť, alebo nie?“ ");
INSERT INTO slk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ježiš postrehol ich lesť, preto im povedal: „Prečo ma pokúšate? Ukážte mi mincu!“ ");
INSERT INTO slk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Podali mu rímsky denár. Spýtal sa ich: „Čí obraz a meno je na tejto minci?“ Odpovedali: „Cisárove.“ ");
INSERT INTO slk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ježiš im povedal: „Tak dávajte cisárovi, čo patrí cisárovi, a čo je Božie, dávajte Bohu.“ Jeho odpoveď ich zaskočila. ");
INSERT INTO slk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Potom za ním prišli saduceji, ktorí učia, že žiadne zmŕtvychvstanie neexistuje. Opýtali sa ho: ");
INSERT INTO slk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Majstre, v Mojžišovom zákone je napísané, že ak zomrie muž, ktorého manželstvo bolo bezdetné, jeho brat je povinný oženiť sa s vdovou a splodiť bratovi potomka, aby sa zachoval jeho rod. ");
INSERT INTO slk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Raz bolo sedem bratov. Najstarší sa oženil, onedlho však zomrel a nezanechal po sebe nijaké deti. ");
INSERT INTO slk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oženil sa s vdovou druhý brat, ale aj ten zomrel bezdetný. ");
INSERT INTO slk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tak to pokračovalo, až zomrel aj posledný. Napokon zomrela aj žena. ");
INSERT INTO slk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naša otázka znie: Komu bude patriť táto žena po vzkriesení? Veď bola manželkou všetkých siedmich bratov!“ ");
INSERT INTO slk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ježiš im odpovedal otázkou: „Nespočíva váš omyl náhodou v tom, že nerozumiete Písmu a nepoznáte Božiu moc? ");
INSERT INTO slk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Keď ľudia vstanú z mŕtvych, nebudú sa ženiť a vydávať, ale budú žiť ako anjeli. ");
INSERT INTO slk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A pokiaľ ide o zmŕtvychvstanie, nečítali ste v Mojžišovej knihe o tom, čo mu Boh povedal z horiaceho kra: ‚Ja som Boh Abrahámov, Boh Izákov a Boh Jákobov?‘ ");
INSERT INTO slk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Boh predsa nie je Bohom mŕtvych, ale Bohom živých. V tomto sa hlboko mýlite!“ ");
INSERT INTO slk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bol tam aj jeden z učiteľov Zákona, ktorý videl, ako sa saduceji medzi sebou dohadujú. Keď počul, ako múdro im Ježiš odpovedal, prišiel za ním aj on s otázkou: „Ktoré prikázanie je najdôležitejšie?“ ");
INSERT INTO slk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ježiš mu odvetil: „Najdôležitejšie prikázanie znie takto: ‚Počuj, Izrael! Pán, náš Boh je jediný Pán. ");
INSERT INTO slk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Budeš ho milovať z celého srdca, z celej duše, z celej mysle a z celej svojej sily!‘ ");
INSERT INTO slk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A druhé prikázanie je: ‚Miluj svojho blížneho ako samého seba! Niet dôležitejších prikázaní, ako sú tieto.‘ “ ");
INSERT INTO slk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","„Správne si to povedal,“ súhlasil učiteľ Zákona. „Je len jeden Boh a okrem neho iného niet. ");
INSERT INTO slk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Milovať ho z celého srdca, celým rozumom a z celej sily svojej vôle a milovať blížneho ako samého seba, to je viac ako všetky obete zvierat na oltári.“ ");
INSERT INTO slk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Keď Ježiš počul, že zákonník pochopil jeho slová, povedal mu: „Nie si ďaleko od Božieho kráľovstva.“ Odvtedy sa ho už nikto nesnažil nachytať žiadnymi otázkami. ");
INSERT INTO slk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Neskôr, keď Ježiš učil v chráme, spýtal sa: „Uvažovali ste nad tým, prečo učitelia Zákona nazývajú Mesiáša synom Dávidovým? ");
INSERT INTO slk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Veď sám Dávid, vedený Duchom Svätým, napísal: ‚Boh povedal môjmu Pánovi: Seď po mojej pravici, kým ti všetkých nepriateľov nepoložím k nohám.‘ ");
INSERT INTO slk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ak ho Dávid nazýva svojím Pánom, ako potom môže byť aj jeho synom?“ Ježiša nadšene počúval veľký zástup ľudí. ");
INSERT INTO slk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ježiš im hovoril: „Dajte si pozor na učiteľov Zákona, ktorí sa radi honosne obliekajú a čakajú, že ich ľudia budú na verejnosti úctivo zdraviť a klaňať sa im. ");
INSERT INTO slk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Radi sedávajú na čestných miestach pri bohoslužbách i na hostinách. ");
INSERT INTO slk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Využívajú domy vdov a dlho sa modlievajú na verejnosti, aby ich všetci videli. Práve preto ich Boh potrestá prísnejšie než ostatných.“ ");
INSERT INTO slk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ježiš si sadol oproti chrámovej pokladnici a pozoroval, ako do nej ľudia vhadzujú peniaze. Mnohí bohatí do nej vkladali vysoké sumy. ");
INSERT INTO slk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Keď však prišla akási chudobná vdova, vhodila do pokladnice iba dve drobné mince. ");
INSERT INTO slk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ježiš na to upozornil učeníkov: „Viete, že táto chudobná vdova dala vlastne viac ako ostatní? ");
INSERT INTO slk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Oni všetci dávali iba to, čo im zvyšovalo, ale táto chudobná žena dala všetko, čo mala na svoje živobytie.“ ");
INSERT INTO slk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Keď Ježiš vychádzal z chrámu, upozornil ho jeden z učeníkov: „Pozri, Majstre, aké obrovské kamene a aká veľkolepá stavba!“ ");
INSERT INTO slk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ježiš mu na to odpovedal: „Vidíš nádhernú stavbu? Všetko to bude zničené; nezostane tu kameň na kameni.“ ");
INSERT INTO slk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Potom spolu vyšli na Olivový vrch, odkiaľ bol výhľad na chrám. Keď osameli, Peter, Jakub, Ján a Andrej sa ho spýtali: ");
INSERT INTO slk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","„Povedz nám, kedy sa stanú veci, o ktorých si hovoril a čo bude znamením, že sa schyľuje k ich uskutočneniu?“ ");
INSERT INTO slk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ježiš im odpovedal: „Dajte si pozor, aby vás niekto neoklamal a nezviedol. ");
INSERT INTO slk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mnohí totiž prídu, budú sa za mňa vyhlasovať a tvrdiť: ‚Ja som on‘ a mnohí im uveria. ");
INSERT INTO slk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na mnohých miestach vypuknú vojny a nepokoje. Keď sa o tom dozviete a budete počuť o ich následkoch, neľakajte sa. To všetko musí prísť, ale koniec nenastane hneď. ");
INSERT INTO slk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Národy a krajiny budú proti sebe bojovať. V mnohých častiach sveta budú zemetrasenia a nastane hlad. To všetko však bude len začiatok, ako keď začínajú pôrodné bolesti. ");
INSERT INTO slk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Keď sa to začne diať, dajte si pozor. Budú vás biť, vláčiť po súdoch a synagógach, vodiť pred vládcov a kráľov, pretože ste moji nasledovníci. No takto sa vám naskytne príležitosť vydať svedectvo o mne a o vašej viere. ");
INSERT INTO slk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Najprv sa však dobrú správu o mne musia dozvedieť ľudia na celom svete. ");
INSERT INTO slk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kedykoľvek vás zatknú či budú vypočúvať, netrápte sa vopred, čo budete hovoriť. Svätý Duch vám v pravej chvíli dá pravé slová. ");
INSERT INTO slk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Brat vydá na smrť svojho brata, otec syna. Deti sa postavia proti rodičom a pripravia ich o život. ");
INSERT INTO slk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Všetci vás budú nenávidieť len preto, že ste moji. Ale každému, kto vytrvá až do konca, dá Boh večný život. ");
INSERT INTO slk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Keď však uvidíte, že sa spustošenie a znesvätenie blíži k miestu, kde nemá byť – kto číta, nech premýšľa a porozumie, o čo ide – nech tí, čo budú v Judsku, utečú do hôr. ");
INSERT INTO slk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A kto bude na streche domu, nech už nebeží dnu, aby si niečo so sebou vzal. ");
INSERT INTO slk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kto bude za mestom, nech sa nevracia domov pre plášť. ");
INSERT INTO slk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ťažko bude v tých dňoch tehotným ženám a tým, čo majú dojčatá. ");
INSERT INTO slk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Proste Boha, aby sa to neudialo v zime. ");
INSERT INTO slk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lebo nastanú dni ťažkého súženia, aké tu, odkedy Boh stvoril svet, nebolo a už ani nebude. ");
INSERT INTO slk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Keby Boh tieto dni neskrátil, nikto by sa nezachránil. Ale skráti ich, aby zachránil svojich vyvolených. ");
INSERT INTO slk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Keby vám niekto hovoril: ‚Pozrite, prišiel Mesiáš‘ alebo: ‚Aha, tam je‘, neverte mu! ");
INSERT INTO slk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lebo sa objavia falošní mesiáši a falošní proroci a budú robiť ohromujúce znamenia a zázraky. Nimi sa budú snažiť zviesť aj tých, čo patria Bohu; ");
INSERT INTO slk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","vopred vás varujem: dajte si na nich pozor! ");
INSERT INTO slk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","V dňoch, ktoré nastanú po tom veľkom utrpení, zatmie sa slnko, pohasne svit mesiaca, ");
INSERT INTO slk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hviezdy začnú padať z neba a zachvejú sa nebeské mocnosti. ");
INSERT INTO slk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Vtedy ľudia uvidia, ako Syn človeka prichádza v oblakoch s veľkou mocou a slávou. ");
INSERT INTO slk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","On vyšle poslov, aby zhromaždil svojich vyvolených zo všetkých svetových strán, od jedného konca zeme po druhý. ");
INSERT INTO slk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Poučte sa z tohto podobenstva: Keď sa konáre figovníka nalievajú miazgou a pučia listy, viete, že sa blíži leto. ");
INSERT INTO slk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A takisto keď uvidíte, že sa dejú veci, o ktorých som vám hovoril, vedzte, že je blízko, predo dvermi. ");
INSERT INTO slk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Je to tak – svet nepominie, kým sa to všetko nestane. ");
INSERT INTO slk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nebo aj zem pominú, ale moje slová nikdy nestratia platnosť. ");
INSERT INTO slk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","O tom dni a o tej hodine však nevie nikto, ani anjeli v nebi, ani Syn. Iba Otec to vie. ");
INSERT INTO slk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A keďže neviete, kedy ten čas príde, buďte bdelí a modlite sa! ");
INSERT INTO slk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bude to tak, ako keď nejaký človek odcestoval do cudzích krajov. Pred svojím odchodom poveril každého sluhu nejakou právomocou, každému určil, čo má vykonať a tomu pri bráne prikázal strážiť. ");
INSERT INTO slk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aj vy buďte ostražití. Veď neviete, kedy sa má Pán vrátiť. Môže to byť večer, v noci, na svitaní alebo za bieleho dňa. ");
INSERT INTO slk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nebolo by príjemné, keby vás našiel pri svojom nečakanom príchode spať. ");
INSERT INTO slk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tieto slová sa týkajú vás, ale aj ostatných ľudí: Bdejte a buďte pripravení!“ ");
INSERT INTO slk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Boli dva dni pred Veľkou nocou a sviatkom nekvasených chlebov. Veľkňazi a učitelia Zákona už dávno hľadali vhodnú príležitosť, ako by sa Ježiša ľsťou zmocnili a dali ho zabiť. ");
INSERT INTO slk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hovorili si však: „Nesmieme to urobiť cez Veľkú noc, lebo by sa ľud mohol vzbúriť.“ ");
INSERT INTO slk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ježiš bol v tom čase v Betánii hosťom Šimona, ktorý kedysi trpel malomocenstvom. Práve sedeli pri stole, keď do domu vstúpila žena s alabastrovou nádobkou drahocenného voňavého oleja z pravého nardu. Odrazila úzky otvor nádobky, olejom pomazala Ježišovi hlavu a prejavila mu tak úctu. ");
INSERT INTO slk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Niektorí sa rozhorčovali: „Načo také zbytočné mrhanie? ");
INSERT INTO slk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Veď ten olej má obrovskú cenu! Mohli sme to radšej predať a peniaze rozdať chudobným!“ – osopili sa na ňu. ");
INSERT INTO slk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ježiš im však povedal: „Nechajte ju. Prečo jej to zazlievate? Preukázala mi dobro. ");
INSERT INTO slk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chudobných bude vždy dosť a budete mať príležitosť im pomáhať, ale ja budem s vami už len chvíľu. ");
INSERT INTO slk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Urobila, čo mohla: už vopred natrela moje telo, ako sa to robieva pred pohrebom. ");
INSERT INTO slk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Počujte, čo vám poviem: kdekoľvek na svete sa bude hlásať radostná zvesť o záchrane, tam sa bude pripomínať aj tento jej čin.“ ");
INSERT INTO slk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tu vstal Judáš Iškariotský, jeden z dvanástich učeníkov, a pobral sa k veľkňazom, aby Ježiša zradil. ");
INSERT INTO slk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Keď veľkňazi vypočuli Judáša, veľmi sa potešili a sľúbili mu odmenu. Odvtedy Judáš striehol na vhodnú príležitosť, aby ho zradil. ");
INSERT INTO slk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","V prvý deň sviatkov nekvasených chlebov, keď sa zabíjal a jedol veľkonočný baránok, spýtali sa učeníci Ježiša: „Kde máme pripraviť veľkonočnú večeru?“ ");
INSERT INTO slk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ježiš vybral dvoch učeníkov a povedal im: „Choďte do mesta, stretnete tam človeka, ktorý bude niesť džbán s vodou. Choďte za ním, ");
INSERT INTO slk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","vojdite do domu, do ktorého vstúpi, a povedzte majiteľovi: ‚Učiteľ sa ťa pýta, kde je miestnosť, v ktorej by mohol jesť veľkonočného baránka so svojimi učeníkmi.‘ ");
INSERT INTO slk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A on vás zavedie do priestrannej a zariadenej miestnosti na poschodí. Tam pre nás pripravte večeru.“ ");
INSERT INTO slk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dvaja učeníci šli teda do mesta, našli všetko tak, ako im povedal, a pripravili veľkonočnú večeru. ");
INSERT INTO slk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Večer tam prišiel Ježiš s učeníkmi. ");
INSERT INTO slk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Keď boli okolo stola a jedli, Ježiš prehovoril: „Jeden z vás, ktorí ste teraz so mnou pri stole, ma vydá do rúk nepriateľov.“ ");
INSERT INTO slk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Učeníkov to ohúrilo a jeden po druhom hovorili: „Ja to nie som, že?“ a „Nie je to pravda, však?“ ");
INSERT INTO slk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zopakoval im: „Je to jeden z vás dvanástich, ktorý si naberá z jednej misy so mnou. ");
INSERT INTO slk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Syn človeka musí zomrieť, ako to predpovedali proroci, ale beda tomu, kto Syna človeka zrádza. Bolo by pre neho lepšie, keby sa vôbec nebol narodil.“ ");
INSERT INTO slk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Keď jedli, Ježiš vzal chlieb, poďakoval zaň Bohu, lámal ho a podával im ho so slovami: „Jedzte, toto je moje telo!“ ");
INSERT INTO slk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Potom vzal kalich, aj zaň sa poďakoval a podal ho učeníkom. Pili z neho všetci. ");
INSERT INTO slk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pritom im vravel: „To je moja krv, preliata za každého ako pečať novej zmluvy medzi Bohom a človekom. ");
INSERT INTO slk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A hovorím vám, že odteraz už nebudem piť z plodu viniča až dovtedy, keď ho budem piť úplne inak v Božom kráľovstve.“ ");
INSERT INTO slk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Napokon zaspievali chválospev a vyšli na Olivový vrch. ");
INSERT INTO slk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Cestou ich Ježiš upozornil: „Túto noc ma všetci opustíte. Ako je napísané: ‚Budem biť pastiera a ovce sa rozpŕchnu.‘ ");
INSERT INTO slk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ale po svojom vzkriesení vás predídem do Galiley a tam sa spolu stretneme.“ ");
INSERT INTO slk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter vyhlásil: „Aj keby ťa všetci opustili, ja ťa neopustím.“ ");
INSERT INTO slk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ježiš mu však povedal: „Pamätaj na moje slová, že ešte túto noc, skôr ako kohút ráno druhý raz zakikiríka, tri razy ma zaprieš.“ ");
INSERT INTO slk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ale Peter ešte zápalistejšie tvrdil: „Nikdy ťa nezapriem, aj keby som mal zomrieť s tebou.“ A ostatní sa k nemu pridali tiež. ");
INSERT INTO slk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Prišli do olivového sadu zvaného Getsemanská záhrada a Ježiš povedal učeníkom: „Počkajte na mňa, kým sa pomodlím.“ ");
INSERT INTO slk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vzal so sebou iba Petra, Jakuba a Jána. Tu na neho doľahol hrôza a úzkosť. ");
INSERT INTO slk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ježiš im povedal: „Prežívam smrteľnú úzkosť. Zostaňte tu a buďte bdelí.“ ");
INSERT INTO slk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Odišiel kúsok ďalej, padol na zem a modlil sa, aby, ak je to možné, nemusel podstúpiť strašné utrpenie, ktoré ho čaká. ");
INSERT INTO slk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Volal: „Otec môj, Otecko, ty môžeš všetko! Odním odo mňa tento kalich utrpenia. Ale nech sa stane, ako ty chceš, nie ako ja.“ ");
INSERT INTO slk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Keď sa vrátil k učeníkom, našiel ich spať. Prebudil Petra: „Šimon, ty spíš? Nevydržal si bdieť ani hodinku? ");
INSERT INTO slk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bdejte a modlite sa. Inak vás premôže pokušenie. Ste síce plní odhodlania, ale sami nemáte dosť síl obstáť.“ ");
INSERT INTO slk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Potom sa vzdialil a opäť prosil Boha o to isté. ");
INSERT INTO slk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Keď sa vrátil, učeníci znova spali. Pre únavu nevládali premôcť spánok, no nevedeli, čo povedať na ospravedlnenie. ");
INSERT INTO slk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Keď prišiel tretí raz, povedal im: „Vari ešte stále spíte a odpočívate? Už dosť! Nastal čas, keď uvidíte, ako bude Syn človeka vydaný do rúk podlých ľudí. ");
INSERT INTO slk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vstaňte a poďme. Uvidíte môjho zradcu – práve sa prichádza!“ ");
INSERT INTO slk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ešte ani nedohovoril a už sa objavil Judáš, jeden z jeho dvanástich učeníkov. Spolu s ním prišiel veľký zástup mužov ozbrojených mečmi a palicami. Poslali ich veľkňazi, učitelia Zákona a vodcovia ľudu. ");
INSERT INTO slk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zradca si s nimi dohovoril znamenie: „Bude to ten, s ktorým sa pozdravím bozkom. Toho zatknite ho a pod dozorom odveďte!“ ");
INSERT INTO slk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ihneď pristúpil k Ježišovi a povedal: „Pozdravujem ťa, Majstre!“ a pobozkal ho. ");
INSERT INTO slk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Vtom sa na neho vrhli a zajali ho. ");
INSERT INTO slk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jeden z učeníkov vytasil meč a sekol ním veľkňazovho sluhu tak, že mu odťal ucho. ");
INSERT INTO slk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ježiš im povedal: „Som azda nejaký nebezpečný burič, že ste ma prišli zajať s mečmi a palicami? ");
INSERT INTO slk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Každý deň som predsa učil v chráme. Tam ste si na mňa netrúfli? Ale muselo sa to stať takto, aby sa splnila predpoveď prorokov.“ ");
INSERT INTO slk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vtedy ho všetci učeníci opustili a rozpŕchli sa. ");
INSERT INTO slk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Len akýsi mladík s plachtou prehodenou cez holé telo sledoval Ježiša z diaľky. Keď sa ho strážcovia pokúsili zadržať, vytrhol sa im z rúk. ");
INSERT INTO slk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Plachtu im nechal a utiekol nahý. ");
INSERT INTO slk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ježiša odviedli k veľkňazovi, kde sa hneď zhromaždili najvyšší kňazi, učitelia Zákona a vodcovia ľudu. ");
INSERT INTO slk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter ho zďaleka nasledoval a dostal sa až na nádvorie veľkňazovho paláca. Tam sa zamiešal medzi sluhov a zohrieval sa pri ohni. ");
INSERT INTO slk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Medzitým sa veľkňaz i celá veľrada usilovali nájsť dôkazy proti Ježišovi, aby ho mohli obviniť a odsúdiť na smrť. Nenašli však nič. ");
INSERT INTO slk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bolo tam síce mnoho falošných svedkov, ale ich výpovede si odporovali. ");
INSERT INTO slk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Napokon niektorí vystúpili a krivo proti nemu svedčili: ");
INSERT INTO slk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","„Počuli sme ho, ako hovoril: ‚Zbúram tento chrám postavený ľudskými rukami a za tri dni postavím iný bez pomoci ľudských rúk.‘ “ ");
INSERT INTO slk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ale ani tieto výpovede sa nezhodovali. ");
INSERT INTO slk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tu sa ujal slova veľkňaz, postavil sa do stredu zhromaždenia a spýtal sa Ježiša: „Počul si obvinenia? Čo chceš povedať na svoju obhajobu?“ ");
INSERT INTO slk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ježiš však veľkňazovi neodpovedal – mlčal. A tak mu veľkňaz položil ďalšiu otázku: „Hej, ty! Si Kristus, Boží Syn?“ ");
INSERT INTO slk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ježiš odpovedal: „Áno, som. Uvidíte Syna človeka, ako sedí po pravici Všemohúceho a ako prichádza na nebeských oblakoch.“ ");
INSERT INTO slk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Vtedy veľkňaz od zúrivosti roztrhol svoje vrchné rúcho a povedal: „Potrebujeme vari ďalších svedkov?! ");
INSERT INTO slk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sami ste počuli, ako sa rúha. Aký rozsudok si zaslúži?“ Jednohlasne ho odsúdili na smrť. ");
INSERT INTO slk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Niektorí naňho začali pľuť, zaviazali mu oči, bili ho po tvári a pokrikovali naňho: „Kto ťa udrel, ty prorok?“ Aj strážcovia sa doňho pustili a bili ho päsťami. ");
INSERT INTO slk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Medzitým prišla na nádvorie, kde bol aj Peter, jedna z veľkňazových slúžok ");
INSERT INTO slk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Keď si ho všimla sedieť pri ohni, zadívala sa na neho a povedala: „Aj ty patríš k tomu Nazaretskému Ježišovi!“ ");
INSERT INTO slk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ale on to zaprel: „Vôbec netuším, o čom to hovoríš!“ Nenápadne sa vykradol z nádvoria a vtom prvý raz zakikiríkal kohút. ");
INSERT INTO slk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Slúžka ho po chvíli opäť zazrela a upozornila okolostojacich: „Aj tento k nim patrí!“ ");
INSERT INTO slk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ale Peter to znova poprel. No o chvíľu ktosi z tých, čo tam stáli, povedal Petrovi: „Určite k nim patríš, si predsa z Galiley!“ ");
INSERT INTO slk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ale Peter sa začal zaklínať a zaprisahávať: „Ale ja naozaj nepoznám toho človeka, o ktorom vravíte.“ ");
INSERT INTO slk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vtom kohút zakikiríkal druhý raz. A tu si Peter spomenul na Ježišove slová: „Skôr ako kohút druhý raz zakikiríka, tri razy ma zaprieš.“ Odišiel a rozplakal sa. ");
INSERT INTO slk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zavčasu ráno sa veľkňazi, vodcovia ľudu a učitelia Zákona – celá veľrada – uzniesli, že Ježiša vydajú rímskemu miestodržiteľovi Pilátovi. Spútali ho a odviedli k nemu. ");
INSERT INTO slk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","„Takže ty si ten kráľ Židov…“ opýtal sa Pilát Ježiša. „Je to tak, ako hovoríš,“ odpovedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Potom veľkňazi predniesli svoju rozsiahlu žalobu. ");
INSERT INTO slk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Keď skončili, Pilát sa znova obrátil na Ježiša: „Prečo sa nebrániš? Počul si, z čoho všetkého ťa obvinili!“ ");
INSERT INTO slk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ale Ježiš na Pilátovo prekvapenie stále mlčal. ");
INSERT INTO slk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cez sviatky Pilát pravidelne prepúšťal Židom jedného väzňa, o ktorého požiadali. ");
INSERT INTO slk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","V tom čase sedel vo väzení istý Barabáš, ktorý sa spolu s inými vzbúrencami dopustil vraždy. ");
INSERT INTO slk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pred Pilátovým palácom sa zhromaždil zástup a začal sa domáhať každoročnej amnestie. ");
INSERT INTO slk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilát sa ich spýtal: „Chcete, aby som vám prepustil toho židovského kráľa?“ ");
INSERT INTO slk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Vedel totiž, že sa proti Ježišovi zo závisti sprisahali najvyšší kňazi. ");
INSERT INTO slk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tí však nahovorili zástup, aby žiadal milosť pre Barabáša. ");
INSERT INTO slk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilát sa ich spýtal: „A čo chcete, aby som urobil s mužom, ktorého voláte židovským kráľom?“ ");
INSERT INTO slk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dav zakričal: „Ukrižuj ho!“ Pilát namietal: „Ale za aký zločin?“ No dav reval ešte hlasnejšie: ");
INSERT INTO slk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","„Ukrižuj ho!“ ");
INSERT INTO slk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilát im chcel urobiť po vôli, prepustil teda Barabáša, Ježiša dal zbičovať a vydal ho, aby ho ukrižovali. ");
INSERT INTO slk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Rímski vojaci odviedli Ježiša na nádvorie vládneho paláca a zvolali celú rotu. ");
INSERT INTO slk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Zahalili ho do purpurovej látky ako do kráľovského plášťa, uplietli z tŕnia veniec a nasadili mu ho na hlavu ako korunu. ");
INSERT INTO slk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Posmešne naňho pokrikovali: „Nech žije židovský kráľ!“ ");
INSERT INTO slk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bili ho palicou po hlave, pľuvali naňho, posmešne pred ním padali na kolená a ukláňali sa. ");
INSERT INTO slk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Keď sa mu do vôle naposmievali, vyzliekli mu zasa plášť, obliekli mu jeho vlastné šaty a viedli ho na popravisko, aby ho ukrižovali. ");
INSERT INTO slk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cestou stretli Šimona z Cyrény, otca Alexandra a Rúfa, ktorý prichádzal do mesta. Prinútili ho, aby pomohol niesť Ježišovi kríž. ");
INSERT INTO slk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ježiša priviedli na popravisko, ktoré sa volalo Golgota, čo v preklade znamená Lebka. ");
INSERT INTO slk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ponúkli mu víno zmiešané s omamnou myrhou, ale odmietol. ");
INSERT INTO slk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Potom ho pribili na kríž a jeho odev si rozdelili medzi sebou losovaním. ");
INSERT INTO slk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bolo deväť hodín ráno, keď ho ukrižovali. ");
INSERT INTO slk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nad hlavu mu pripevnili tabuľku s nápisom, ktorý oznamoval, akého zločinu sa dopustil: ŽIDOVSKÝ KRÁĽ. ");
INSERT INTO slk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Spolu s ním ukrižovali dvoch zločincov, jedného po pravej, druhého po ľavej strane. ");
INSERT INTO slk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tak sa splnila predpoveď proroka Izaiáša: „Zaradili ho medzi zločincov.“ ");
INSERT INTO slk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tí, čo prechádzali okolo, urážali ho a posmievali sa mu: „Aha! Chcel nám zbúrať chrám a za tri dni ho znova postaviť! ");
INSERT INTO slk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Poď z toho kríža dolu a zachráň sa!“ ");
INSERT INTO slk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Medzi posmievačmi boli aj veľkňazi a učitelia Zákona a hovorili jeden druhému: „Iných zachraňoval, ale sebe pomôcť nemôže. ");
INSERT INTO slk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Vraj Mesiáš, kráľ Izraela! Nech teda zostúpi z kríža! Keď to uvidíme, uveríme mu!“ Ešte aj zločinci, ktorí umierali spolu s ním, si z neho robili posmech. ");
INSERT INTO slk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Okolo obeda zrazu nastala tma v celom kraji a trvala až do tretej hodiny. ");
INSERT INTO slk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","O tretej zvolal Ježiš silným hlasom: „Eli, Eli, lama sabachtani?“ čo v preklade znamená: Bože môj, Bože môj, prečo si ma opustil? ");
INSERT INTO slk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Niektorí z tých, čo stáli pod krížom, vraveli: „Pozrite, volá Eliáša.“ ");
INSERT INTO slk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pribehol jeden z nich, nastokol na tyč špongiu namočenú do octu a podal mu ju a potom zvolal: „Počkajte, uvidíme, či ho Eliáš príde dať dolu!“ ");
INSERT INTO slk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tu Ježiš nahlas zakričal a skonal. ");
INSERT INTO slk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","V tej chvíli sa opona v chráme roztrhla napoly odhora až nadol. ");
INSERT INTO slk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Keď rímsky stotník, ktorý stál pri kríži, videl, ako Ježiš zomieral, zvolal: „Ten človek bol naozaj Syn Boží!“ ");
INSERT INTO slk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Obďaleč stálo niekoľko žien a pozorovalo všetko, čo sa deje. Bola medzi nimi Mária Magdaléna; Mária, matka Jakuba mladšieho a Jozefa; a Salome. ");
INSERT INTO slk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tie ho sprevádzali a pomáhali mu už vtedy, keď bol v Galilei. A boli tu aj iné ženy, ktoré s ním prišli do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bol deň pripravovania, čiže deň pred sobotou, a pomaly sa zvečerilo. ");
INSERT INTO slk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jozef z Arimatey, vážený člen židovskej rady, ktorý tiež očakával Božie kráľovstvo, predstúpil smelo pred Piláta a požiadal ho o Ježišovo telo. ");
INSERT INTO slk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilát sa začudoval: „Vari už naozaj zomrel?“ Dal si zavolať stotníka a spýtal sa ho, či je to pravda. ");
INSERT INTO slk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Keď mu stotník potvrdil Ježišovu smrť, dovolil Jozefovi telo vziať. ");
INSERT INTO slk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ten kúpil plátno, sňal Ježišovo telo z kríža, zavinul ho do plátna a uložil do vlastnej hrobky, vytesanej v skale. Vchod do hrobu privalili balvanom. ");
INSERT INTO slk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mária Magdaléna a Mária Jozesova sa prizerali, kde Ježiša pochovali. ");
INSERT INTO slk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mária z Magdaly, Jakubova matka Mária a Salome nakúpili po sobote voňavé masti, aby nimi podľa židovskej obyčaje natreli Ježišovo telo. ");
INSERT INTO slk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Zavčasu ráno v prvý deň týždňa, len čo vyšlo slnko, pobrali sa k hrobu. ");
INSERT INTO slk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cestou si hovorili: „Kto nám odvalí kameň, ktorý je pri vchode do hrobu?“ ");
INSERT INTO slk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Keď však prišli na miesto, zistili, že ten obrovský kameň je od hrobu odvalený. ");
INSERT INTO slk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vstúpili do hrobky a na pravej strane videli sedieť mladého muža v bielom odeve. Veľmi sa ho zľakli. ");
INSERT INTO slk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","On ich však upokojoval: „Nebojte sa! Viem, že hľadáte Ježiša z Nazareta, ktorého ukrižovali. Nie je tu, vstal z mŕtvych! Pozrite sa na miesto, kde ho položili: je prázdne. ");
INSERT INTO slk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Choďte a oznámte jeho učeníkom vrátane Petra: Ježiš ide pred vami do Galiley. Stretnete sa tam s ním, tak ako vám to oznámil pred svojou smrťou.“ ");
INSERT INTO slk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ženy vybehli z hrobky a celé predesené utekali preč. Triasli sa od hrôzy a nikomu nič nepovedali, lebo sa báli. ");
INSERT INTO slk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ježiš Kristus vstal z mŕtvych v nedeľu zavčasu ráno. Najprv sa ukázal Márii Magdaléne, žene, z ktorej kedysi vyhnal sedem démonov. ");
INSERT INTO slk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tá bežala k Ježišovým učeníkom, ktorých našla plačúcich a zúfalých, a oznámila im: „Ježiš žije! Videla som ho!“ ");
INSERT INTO slk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ale neuverili jej. ");
INSERT INTO slk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Potom sa ukázal dvom učeníkom, ktorí šli z Jeruzalema na vidiek. ");
INSERT INTO slk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vrátili sa, oznámili to ostatným, ale ani im nikto neveril. ");
INSERT INTO slk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Neskôr sa ukázal svojim jedenástim učeníkom, práve keď jedli. Karhal ich pre nevieru i preto, že tak tvrdohlavo odmietali uveriť, že je živý. ");
INSERT INTO slk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Potom ich poveril úlohou: „Choďte do celého sveta a všetkým ľuďom oznamujte radostnú správu: ");
INSERT INTO slk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","kto uverí vo mňa a dá sa pokrstiť, bude zachránený. Ale toho, kto odmietne veriť, Boh odsúdi. ");
INSERT INTO slk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tých, ktorí uveria, budú sprevádzať tieto znamenia: Budú v mojom mene vyháňať démonov a hovoriť novými jazykmi. ");
INSERT INTO slk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Budú brať do rúk hady, ktoré im neublížia, a jedovatý nápoj im neuškodí. Na chorých budú vkladať ruky a uzdravia ich.“ ");
INSERT INTO slk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Po týchto slovách bol Pán Ježiš vzatý do neba a zaujal svoje miesto po Božej pravici. ");
INSERT INTO slk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jeho učeníci sa rozišli do sveta a všade zvestovali radostnú správu o Kristovi. A Pán bol s nimi a ich slová potvrdzoval zázračnými činmi.");
INSERT INTO slk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Už mnohí predo mnou sa usilovali spísať udalosti, ktoré sa u nás odohrali. ");
INSERT INTO slk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vychádzali pri tom zo slov tých, ktorí boli od začiatku očitými svedkami a zvestovateľmi Božieho slova. ");
INSERT INTO slk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Napriek tomu som sa rozhodol dôkladne preskúmať, roztriediť a napísať ti, vznešený Teofil, všetky dostupné správy, ");
INSERT INTO slk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aby si získal istotu, že to, o čom si sa dozvedel, je pravda. ");
INSERT INTO slk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","V dobe, keď bol Herodes kráľom Judska, žil istý kňaz menom Zachariáš. Zachariáš bol členom Abiášovej skupiny. Jeho manželka Alžbeta pochádzala z Áronovho kňazského rodu. ");
INSERT INTO slk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Obaja boli čestní ľudia, Boha rešpektovali a žili podľa Božích prikázaní a predpisov. ");
INSERT INTO slk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Boli to už starší ľudia a zostali bezdetní, lebo Alžbeta bola neplodná. ");
INSERT INTO slk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","V čase, keď prišiel rad na Zachariášovu kňazskú skupinu a on konal v chráme svoje kňazské povinnosti, ");
INSERT INTO slk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bol práve Zachariáš vybratý losom, aby vstúpil vo svätyne a tam na oltári priniesol kadidlovú obeť. ");
INSERT INTO slk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Všetci zhromaždení ľudia sa v tom čase vonku modlili. ");
INSERT INTO slk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zachariáš bol práve vo svätyni, keď sa mu ukázal Pánov anjel po pravej strane kadidlového oltára. ");
INSERT INTO slk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Keď ho Zachariáš uvidel, predesil sa a zmocnila sa ho bázeň. ");
INSERT INTO slk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Boží posol ho však upokojoval: „Neboj sa, Zachariáš! Prišiel som ti oznámiť, že Boh vypočul tvoju modlitbu. Manželka Alžbeta ti porodí syna, ktorému dáte meno Ján. ");
INSERT INTO slk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Budeš mať z neho veľkú radosť a potešenie a mnohí budú za jeho narodenie nesmierne vďační. ");
INSERT INTO slk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Boh ho poverí veľkou úlohou. Počas svojho života nebude piť víno ani iný opojný nápoj. Duch Svätý bude v ňom už od narodenia. ");
INSERT INTO slk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mnohých z izraelského národa privedie naspäť k Bohu, ich skutočnému Pánovi. ");
INSERT INTO slk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","On sám pôjde pred Ním a bude mať toho istého ducha a tú istú moc, ako mal Eliáš. To preto, aby obnovil lásku medzi rodičmi a deťmi, aby tých, čo konajú svojvoľne, priviedol k múdrosti spravodlivých a pripravil tak ľudí na Jeho prijatie.“ ");
INSERT INTO slk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zachariáš namietol: „Ako môžem veriť, že je to pravda? Veď sme s manželkou obaja starí a deti už mať nemôžeme.“ ");
INSERT INTO slk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anjel mu však povedal: „Ja som Gabriel a prichádzam s posolstvom priamo od Boha. Mám ti oznámiť túto radostnú správu. ");
INSERT INTO slk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","No keďže si neuveril, budeš nemý, kým sa moje slová v určenom čase nenaplnia.“ ");
INSERT INTO slk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ľudia vonku medzitým čakali na Zachariáša a čudovali sa, že je vo svätyni tak dlho. ");
INSERT INTO slk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Keď konečne vyšiel, nemohol prehovoriť. Posunkami im dal najavo, že mal vo svätyni videnie. ");
INSERT INTO slk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Keď sa skončil týždeň jeho chrámovej služby, vrátil sa domov. ");
INSERT INTO slk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Onedlho nato Alžbeta otehotnela, ale tajila to pred ľuďmi až do piateho mesiaca. ");
INSERT INTO slk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Radovala sa: „Boh sa nado mnou zľutoval a zbavil ma pohŕdania a neúcty ľudí.“ ");
INSERT INTO slk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pol roka po Zachariášovom videní poslal Boh anjela Gabriela do galilejského mestečka Nazareta ");
INSERT INTO slk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","k dievčaťu, ktoré sa volalo Mária. Bola snúbenicou Jozefa, ktorý pochádzal z Dávidovho kráľovského rodu. ");
INSERT INTO slk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anjel sa jej prihovoril: „Raduj sa, lebo Boh je s tebou a obdaril ťa svojou milosťou.“ ");
INSERT INTO slk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Máriu jeho slová znepokojili a snažila sa pochopiť, čo to znamená. ");
INSERT INTO slk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Posol pokračoval: „Neboj sa, Mária! Boh ťa chce nesmierne požehnať. ");
INSERT INTO slk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Narodí sa ti syn a dáš mu meno Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bude mať veľkú moc a bude Synom Najvyššieho. Boh mu dá Dávidov trón, ");
INSERT INTO slk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","naveky bude kráľom Izraela a jeho kráľovstvo sa nikdy neskončí.“ ");
INSERT INTO slk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mária však namietala: „Ako sa mi môže narodiť dieťa? Veď nežijem s mužom!“ ");
INSERT INTO slk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anjel jej povedal: „Duch Svätý to spôsobí. Zjaví sa pri tebe moc Najvyššieho a sväté dieťa, ktoré sa ti narodí, bude sa volať Boží Syn. ");
INSERT INTO slk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Veď aj tvoja príbuzná Alžbeta, po celý život neplodná, bude mať vo svojej starobe syna. Narodí sa jej už o tri mesiace. ");
INSERT INTO slk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","U Boha nie je nič nemožné.“ ");
INSERT INTO slk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mária na to povedala: „Som Pánovou služobníčkou. Nech sa teda stane, ako si povedal.“ Potom anjel odišiel. ");
INSERT INTO slk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","O niekoľko dní sa Mária vydala do mestečka v judských kopcoch, kde žil Zachariáš s Alžbetou. ");
INSERT INTO slk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Keď vošla do ich domu a pozdravila sa, ");
INSERT INTO slk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","pocítila Alžbeta, ako sa v nej dieťa pohlo. V tej chvíli Alžbetu prenikol Svätý Duch ");
INSERT INTO slk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a nadšene zvolala: „Mária, Boh ťa požehnal spomedzi všetkých žien a aj tvoj syn bude požehnaním. ");
INSERT INTO slk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aká je to pre mňa česť, že ma navštívila matka môjho Pána. ");
INSERT INTO slk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Len čo som začula tvoj pozdrav, dieťatko sa vo mne od radosti pohlo. ");
INSERT INTO slk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Si blahoslavená, lebo si uverila Božiemu zasľúbeniu. Jeho slová sa splnia.“ ");
INSERT INTO slk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nato Mária povedala: „Moje srdce chváli Pána ");
INSERT INTO slk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a radujem sa v Bohu, mojom Spasiteľovi. ");
INSERT INTO slk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mňa, bezvýznamné dievča, si všimol. Ľudia zo všetkých národov budú o mne hovoriť ako o požehnanej, ");
INSERT INTO slk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","pretože vidím, aké veľké a úžasné veci vykonal mocný Boh. Jeho meno je sväté ");
INSERT INTO slk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","a svoje milosrdenstvo preukazuje všetkým, ktorí ho berú vážne. ");
INSERT INTO slk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Vystiera svoju mocnú ruku, aby maril plány pyšných, ");
INSERT INTO slk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","aby zosadzoval vládcov z trónu a pozdvihoval utláčaných. ");
INSERT INTO slk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hladných sýtil dobrými vecami a bohatých prepúšťal s prázdnymi rukami. ");
INSERT INTO slk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ujal sa svojho ľudu, Izraela a stále mu je milosrdný. ");
INSERT INTO slk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tak to naveky sľúbil našim otcom: Abrahámovi i jeho potomkom.“ ");
INSERT INTO slk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mária ostala u Alžbety tri mesiace a potom sa vrátila domov. ");
INSERT INTO slk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Keď nastal čas, Alžbete sa narodil syn. ");
INSERT INTO slk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Keď sa všetci susedia a príbuzní dozvedeli, ako ju Boh požehnal, radovali sa spolu s ňou. ");
INSERT INTO slk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Zišli sa na ôsmy deň, keď podľa zákona chlapcov obrezávali, a chceli mu dať meno po otcovi – Zachariáš. ");
INSERT INTO slk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ale Alžbeta povedala: „Nie, bude sa volať Ján.“ ");
INSERT INTO slk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Namietali: „Vo vašej rodine sa predsa nikto tak nevolal.“ ");
INSERT INTO slk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tu sa obrátili na otca, aké mu chce dať meno. ");
INSERT INTO slk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Vypýtal si tabuľku a na prekvapenie všetkých napísal: „Bude sa volať Ján.“ ");
INSERT INTO slk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","V tej chvíli sa Zachariášovi opäť vrátila reč a začal chváliť Boha. ");
INSERT INTO slk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Všetci susedia pochopili, že sa deje čosi mimoriadne a naplnila ich bázeň. Hovorilo sa o tom po celej hornatej Judei. ");
INSERT INTO slk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Každý, kto o tom počul, uvažoval vo svojom srdci: „Z toho chlapca určite vyrastie niekto významný. Veď je zrejmé, že ho sprevádza Božia moc.“ ");
INSERT INTO slk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Duch Svätý naplnil Zachariáša a dal mu tieto prorocké slová: ");
INSERT INTO slk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Chvála Pánovi, Bohu Izraela, že prichádza svojmu ľudu na pomoc a vyslobodzuje ho. ");
INSERT INTO slk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Posiela nám mocného Záchrancu z rodu kráľa Dávida, ");
INSERT INTO slk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ktorého už dávno ohlasoval ústami svojich prorokov; ");
INSERT INTO slk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","oslobodí nás od našich nepriateľov a tých, čo nás nenávidia. ");
INSERT INTO slk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Boh prejavil svoje milosrdenstvo a priznáva sa k našim otcom a k svojej zmluve s nimi. ");
INSERT INTO slk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Veď Boh sa prísahou zaviazal nášmu otcovi Abrahámovi, ");
INSERT INTO slk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","že nás vyslobodí z rúk nepriateľov, aby sme mu mohli slobodne vzdávať česť a chválu ");
INSERT INTO slk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","a mohli po celý náš život žiť čestne a spravodlivo. ");
INSERT INTO slk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ty, syn môj, budeš prorokom Najvyššieho a budeš pod Pánovým vedením pripravovať ľudí na jeho príchod. ");
INSERT INTO slk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Budeš im hovoriť, že Boh chce ľudí zachrániť odpustením ich hriechov. ");
INSERT INTO slk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Veď Boh je plný zľutovania a milosrdenstva. Slnko spásy už vychádza, ");
INSERT INTO slk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","aby zažiarilo všetkým, čo žijú v tme a v tieni smrti. Boh nás povedie po ceste, ktorá vedie k zmiereniu a pokoju.“ ");
INSERT INTO slk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chlapec rástol a jeho duch mocnel. Neskôr odišiel na púšť, kde žil v ústraní až do chvíle, keď vystúpil so svojím posolstvom pred izraelský národ. ");
INSERT INTO slk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","V tom čase nariadil cisár Augustus, aby sa vykonalo sčítanie ľudu v celej Rímskej ríši. ");
INSERT INTO slk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tento súpis sa konal pred tým, než sa rímskym miestodržiteľom v Sýrii stal Kvirinius. ");
INSERT INTO slk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Každý bol povinný dať sa zapísať v meste, odkiaľ pochádzali jeho predkovia. ");
INSERT INTO slk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aj Jozef so svojou snúbenicou Máriou putoval z galilejského Nazareta do judského mesta Betlehem, rodiska kráľa Dávida. Jozef totiž pochádzal z jeho rodu. ");
INSERT INTO slk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Keď sa vydali na cestu, Mária už bola vo vysokom stupni tehotenstva. ");
INSERT INTO slk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Počas pobytu v Betleheme nastal čas pôrodu. ");
INSERT INTO slk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Márii sa narodil jej prvorodený syn. Zavinula ho do plienok a uložila do jaslí, lebo v hostinci už nebolo miesta. ");
INSERT INTO slk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Za mestom pásli pastieri svoje ovce. Aj v tú noc boli pri stáde a strážili ho. ");
INSERT INTO slk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Zrazu sa pred nimi zjavil Pánov anjel a celá krajina sa rozžiarila odleskom Božej slávy. Veľmi sa vyľakali, ");
INSERT INTO slk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ale anjel ich upokojoval: „Nebojte sa, nesiem vám radostnú správu, z ktorej sa môžu tešiť všetci ľudia. ");
INSERT INTO slk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","V Dávidovom meste sa vám dnes narodil Záchranca. On je Mesiáš a váš Pán. ");
INSERT INTO slk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nájdete dieťatko zavinuté v plienkach a ležiace v jasliach: to je ten, o ktorom vám hovorím.“ ");
INSERT INTO slk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Potom sa k anjelovi pripojili celé zástupy nebeského vojska. Všetci chválili Boha a hovorili: ");
INSERT INTO slk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Sláva Bohu na nebi a na zemi pokoj ľuďom, ktorí našli Božiu priazeň.“ ");
INSERT INTO slk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Len čo sa anjeli vrátili do neba, pastieri sa rozhodli: „Poďme sa pozrieť do Betlehema, aby sme videli veci, o ktorých nám Boh prostredníctvom anjela hovoril.“ ");
INSERT INTO slk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ponáhľali sa do mesta a našli Máriu s Jozefom i novorodeniatko ležiace v jasliach. ");
INSERT INTO slk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Keď ho uvideli, všetkým rozpovedali, čo zažili a čo im anjel povedal o dieťatku. ");
INSERT INTO slk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ľudia, ktorí to počuli, sa ich slovám veľmi čudovali. ");
INSERT INTO slk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mária si to všetko uchovala v srdci a premýšľala o tom. ");
INSERT INTO slk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pastieri sa vrátili k svojim stádam, radovali sa a velebili Boha, že našli všetko tak, ako im anjel oznámil. ");
INSERT INTO slk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na ôsmy deň dali Mária a Jozef chlapca obrezať. Dali mu meno Ježiš, ako to anjel určil už pred jeho narodením. ");
INSERT INTO slk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mojžišov zákon prikazoval, aby každá žena, ktorej sa narodí dieťa, išla do chrámu a priniesla obeť. Preto aj Mária, keď bola podľa Zákona obradne čistá, prišla s Jozefom do chrámu. Vzali so sebou aj dieťa: ");
INSERT INTO slk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","v Mojžišovom zákone je totiž napísané, že každý prvorodený chlapec bude zasvätený Bohu. ");
INSERT INTO slk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Priniesli aj obeť, ktorú mali podľa zákona obetovať chudobní: dve hrdličky alebo dvoch holubov. ");
INSERT INTO slk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","V tom čase žil v Jeruzaleme zbožný starec Simeon. Bol to čestný muž, Boha i jeho prikázania bral vážne a viedol ho Svätý Duch. Simeon očakával Božie potešenie pre Izrael. ");
INSERT INTO slk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Duch Svätý mu zjavil, že nezomrie, kým na vlastné oči neuvidí Bohom sľúbeného Mesiáša. ");
INSERT INTO slk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Vedený Božím Duchom prišiel do chrámu práve vo chvíli, keď rodičia zasväcovali Ježiša Bohu. ");
INSERT INTO slk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon vzal dieťa do náručia a modlil sa: ");
INSERT INTO slk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Pane, ďakujem ti, že si splnil svoj sľub. Teraz môžem pokojne zomrieť, ");
INSERT INTO slk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","lebo som na vlastné oči videl toho, ktorý prinesie záchranu. ");
INSERT INTO slk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","V ňom ponúkaš záchranu celému svetu; ");
INSERT INTO slk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","on bude svetlom pohanom a slávou svojho ľudu Izraela.“ ");
INSERT INTO slk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jozef a Mária boli z jeho slov o dieťati prekvapení. ");
INSERT INTO slk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon im požehnal a Márii ešte povedal: „Toto dieťa bude príčinou pádu jedných a povýšenia druhých v Izraeli. Je znamením z neba, proti ktorému sa mnohí postavia, ");
INSERT INTO slk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","a tak prezradia svoje zmýšľanie. A tvoje srdce prenikne bolesť ako meč.“ ");
INSERT INTO slk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bola tam aj prorokyňa Anna, dcéra Fanuelova z rodu Aserovho. Po sedemročnom manželstve ovdovela a teraz už bola vo veľmi pokročilom veku: ");
INSERT INTO slk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mala osemdesiatštyri rokov. Celý svoj život prežila v chráme a jej dni aj noci boli naplnené službou Bohu, modlitbami a častými pôstmi. ");
INSERT INTO slk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aj ona k nim pristúpila a ďakovala Bohu za to dieťa. Hovorila o ňom všetkým, ktorí v Jeruzaleme očakávali príchod Mesiáša. ");
INSERT INTO slk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Keď Jozef s Máriou splnili všetko, čo prikazoval Zákon, vrátili sa do Nazareta v Galilei. ");
INSERT INTO slk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chlapec rástol, jeho duch mocnel, nadobúdal poznanie a múdrosť. Všetci mohli vidieť, že Boh ho zahŕňa svojím dobrodením. ");
INSERT INTO slk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ježišovi rodičia putovali každý rok do Jeruzalema na veľkonočné sviatky. ");
INSERT INTO slk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Keď mal Ježiš dvanásť rokov, tiež sa vybrali na sviatky do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Po slávnosti sa všetci vydali na cestu domov, ale Ježiš zostal bez vedomia rodičov v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Spočiatku sa ani neznepokojovali, lebo si mysleli, že zostal niekde medzi pútnikmi. Ale keď sa celý deň neukázal, začali ho hľadať medzi príbuznými a známymi. ");
INSERT INTO slk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nenašli ho, a preto sa vrátili do Jeruzalema a hľadali ho tam. ");
INSERT INTO slk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Až po troch dňoch ho našli v chráme, ako sedí medzi učiteľmi Zákona, počúva ich a kladie im otázky. ");
INSERT INTO slk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Všetci, ktorí tam boli, žasli nad jeho múdrosťou a odpoveďami. ");
INSERT INTO slk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rodičov prekvapilo, že je v chráme, a matka mu vyčítala: „Syn náš, čo si nám to urobil? Báli sme sa s otcom o teba a hľadali sme ťa.“ ");
INSERT INTO slk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ježiš im odpovedal: „Prečo ste ma hľadali? Či neviete, že musím byť tam, kde ide o veci môjho Otca?“ ");
INSERT INTO slk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Oni však jeho slová nepochopili. ");
INSERT INTO slk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ježiš sa potom vrátil s rodičmi do Nazareta. Bol im dobrým synom a jeho matka premýšľala o všetkom, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ježiš rástol a rozvíjal sa telesne aj rozumovo a bol milý Bohu i ľuďom. ");
INSERT INTO slk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","V pätnástom roku vlády cisára Tiberia, keď bol Pilát Pontský rímskym správcom Judei a tetrarchami boli: Herodes v Galilei, jeho brat Filip v Iturei a na území Trachonitidy a Lyzaniáš v Abiléne. ");
INSERT INTO slk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","V čase, keď veľkňazský úrad zastávali Annáš a Kaifáš, vyzval Boh Jána, syna Zachariášovho, aby vystúpil z ústrania. ");
INSERT INTO slk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ján Krstiteľ z Božieho poverenia prechádzal údolím rieky Jordán a kázal: „Zmeňte svoje myslenie a svoj život. Obráťte sa k Bohu, vyznajte svoje hriechy a na znamenie toho, že vám Boh odpustil, sa nechajte pokrstiť.“ ");
INSERT INTO slk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Takto sa splnila dávna predpoveď proroka Izaiáša: „Na púšti volá hlas: Pripravte cestu Pánovi a odstráňte z nej všetky prekážky. ");
INSERT INTO slk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Zasypte priehlbiny, zarovnajte vrchy! Odstráňte zákruty, uhlaďte hrboľaté cesty. ");
INSERT INTO slk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A každý človek uvidí, ako Boh zachraňuje.“ ");
INSERT INTO slk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zástupom, ktoré za ním vychádzali, aby ich pokrstil, hovoril: „Hadie plemeno, myslíte si, že takto môžete uniknúť Božiemu hnevu? ");
INSERT INTO slk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dokážte svojím životom, že ste sa odvrátili od svojich hriechov. Nenahovárajte si, že sa vám nemôže nič stať len preto, že ste potomkovia Abraháma. Neklamte samých seba! Veď Boh môže aj tieto kamene oživiť a urobiť z nich Abrahámove deti. ");
INSERT INTO slk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sekera Božieho súdu je už priložená ku koreňom stromov. Každý strom, ktorý neprináša dobré ovocie, bude vyťatý a hodený do ohňa.“ ");
INSERT INTO slk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ľudia sa ho spytovali: „Tak čo máme robiť?“ ");
INSERT INTO slk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ján im odpovedal: „Máte dve košele? Rozdeľte sa s tými, čo nemajú ani jednu. Máte čo jesť? Rozdeľte sa s tými, čo sú hladní.“ ");
INSERT INTO slk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Prichádzali k nemu aj vyberači daní, aby ich pokrstil a spytovali sa ho: „Učiteľu, čo máme robiť my?“ – ");
INSERT INTO slk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","„Nevyberajte viac, ako je stanovené,“ odpovedal im. ");
INSERT INTO slk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","„A čo my?“ spytovali sa vojaci. „Nikomu neubližujte ani nikoho nevydierajte. A buďte spokojní so žoldom, ktorý dostávate.“ ");
INSERT INTO slk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ján vedel, že ľudia očakávajú príchod Mesiáša. Všetci si dokonca začali myslieť, že by ním mohol byť práve on. ");
INSERT INTO slk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Preto im Ján povedal: „Ja vás krstím vodou, ale prichádza ktosi mocnejší, ako som ja. Tomu nie som hoden ani remienok rozviazať na obuvi. On vás bude krstiť Svätým Duchom a ohňom. ");
INSERT INTO slk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","On prečistí zrno, zbaví ho pliev, pšenicu zhromaždí do svojej sýpky, ale plevy spáli v neuhasiteľnom ohni.“ ");
INSERT INTO slk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ján napomínal ľudí i rôznym iným spôsobom a zároveň ich povzbudzoval hlásaním radostnej zvesti. ");
INSERT INTO slk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Karhal i Herodesa, tetrarchu nad Galileou. Vyčítal mu, že žije s Herodiadou, manželkou svojho brata. Napomínal ho i za ostatné zlo, ktoré páchal. ");
INSERT INTO slk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes svoje zločiny zavŕšil tým, že dal neskôr Jána uväzniť. ");
INSERT INTO slk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Keď sa všetok ľud dával krstiť a bol pokrstený aj Ježiš, vyšiel z vody a modlil sa. Vtom sa otvorilo nebo a ");
INSERT INTO slk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","zostúpil naňho Svätý Duch v podobe holubice. Z neba sa ozval hlas: „Ty si môj milovaný Syn a to, čo robíš, ma napĺňa radosťou!“ ");
INSERT INTO slk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ježiš mal okolo tridsať rokov, keď začal verejne pôsobiť. Ľudia ho pokladali za syna tesára Jozefa, ktorého otcom bol Heli a jeho predkami boli postupne: ");
INSERT INTO slk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat, Lévi, Melchi, Janai, Jozef, ");
INSERT INTO slk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiáš, Amos, Naum, Esli, Nagge, ");
INSERT INTO slk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mahat, Matatiáš, Semein, Josech, Joda, ");
INSERT INTO slk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Johannan, Resa, Zorobábel, Salatiel, Neri, ");
INSERT INTO slk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi, Adit, Kosam, Elmodam, Ér, ");
INSERT INTO slk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jesus, Eliezer, Iorim, Matat, Lévi, ");
INSERT INTO slk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon, Júda, Jozef, Jonam, Eliakim, ");
INSERT INTO slk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea, Mena, Matat, Nátan, Dávid, ");
INSERT INTO slk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse, Obéd, Bóz, Sala, Náson, ");
INSERT INTO slk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab, Admin, Arni, Ezrom, Fares, Júda, ");
INSERT INTO slk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jákob, Izák, Abrahám, Thara, Náchor, ");
INSERT INTO slk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruch, Ragau, Falek, Eber, Sala, ");
INSERT INTO slk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainam, Arfaxad, Sem, Noe, Lámech, ");
INSERT INTO slk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matuzalem, Enoch, Jared, Maleel, Kainam, ");
INSERT INTO slk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos, Set a Adam, ktorého otcom bol Boh. ");
INSERT INTO slk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ježiš sa vrátil od Jordánu naplnený Svätým Duchom. Duch ho teraz viedol na púšť, kde s ním bol štyridsať dní. Po celý ten čas nič nejedol a diabol ho pokúšal. ");
INSERT INTO slk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Keď uplynulo tých štyridsať dní mal veľký hlad. ");
INSERT INTO slk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Vtedy mu diabol povedal: „Ak si naozaj Boží Syn, prikáž tomuto kameňu, aby sa premenil na chlieb!“ ");
INSERT INTO slk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ale Ježiš mu odpovedal: „Je napísané: Na to, aby človek žil, nepotrebuje len jedlo.“ ");
INSERT INTO slk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Potom ho diabol vyviedol na vysoký vrch, ukázal mu všetky kráľovstvá sveta ");
INSERT INTO slk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","a povedal: „Dám ti moc i slávu týchto kráľovstiev, pretože patria mne, a môžem ich dať, komu chcem. ");
INSERT INTO slk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ak predo mnou padneš na kolená a vzdáš mi úctu ako Bohu, toto všetko bude tvoje.“ ");
INSERT INTO slk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ježiš mu odpovedal: „Je napísané: Pána, svojho Boha budeš uctievať a iba jemu budeš slúžiť!“ ");
INSERT INTO slk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Potom ho diabol zaviedol do Jeruzalema na vežu chrámu a povedal mu: „Ak si Boží Syn, zoskoč dolu. ");
INSERT INTO slk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Veď je napísané: Boh prikáže svojim anjelom, aby ťa ochránili, ");
INSERT INTO slk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","a ponesú ťa na rukách, aby si si neporanil nohy o kameň.“ ");
INSERT INTO slk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ježiš mu opäť odpovedal: „Ale je napísané aj toto: Nebudeš pokúšať Boha, je tvoj Pán!“ ");
INSERT INTO slk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Po týchto slovách diabol ukončil pokúšanie a na určitý čas od neho odišiel. ");
INSERT INTO slk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ježiš sa vrátil vyzbrojený mocou Ducha do Galiley a zvesť o ňom sa čoskoro rozšírila po celom okolí. ");
INSERT INTO slk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Učil v synagógach a chválil ho každý, kto ho počul. ");
INSERT INTO slk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Prišiel aj do Nazareta, kde vyrastal. Keďže bola sobota, šiel – ako každú sobotu – do miestnej synagógy. Keď vstal, aby čítal z Písma, ");
INSERT INTO slk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","podali mu zvitok, na ktorom bola napísaná kniha proroka Izaiáša. Rozvinul ho a našiel miesto, kde bolo napísané: ");
INSERT INTO slk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Duch Boží ma vedie, lebo ma Boh určil, aby som chudobným priniesol radostnú správu a tých, ktorí majú zlomené srdce, uzdravil. Poslal ma, aby som oznámil väzňom vyslobodenie, slepým vrátil zrak, utláčaných oslobodil ");
INSERT INTO slk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a všetkým rozhlásil, že prichádza čas, v ktorom chce Boh prejaviť svoju milosť.“ ");
INSERT INTO slk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ježiš zvinul zvitok, podal ho sluhovi a sadol si. Všetci, čo boli v synagóge sa na neho uprene pozreli. ");
INSERT INTO slk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A vtedy Ježiš doložil: „To, čo ste práve počuli, sa dnes stalo skutočnosťou.“ ");
INSERT INTO slk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Všetci, čo tam boli, mu prisviedčali a obdivovali, aké krásne slová plynú z jeho úst. A spytovali sa: „Ako je to možné? Nie je to azda syn Jozefov?“ ");
INSERT INTO slk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ale Ježiš pokračoval: „Asi by ste mi radi pripomenuli príslovie: ‚Lekár, uzdrav sa sám!‘ Prečo neurobíš doma také isté zázraky, ako si urobil v Kafarnaume?“ ");
INSERT INTO slk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ježiš im odpovedal: „Pravda je totiž taká, že žiadneho proroka si neuctia tam, odkiaľ pochádza! ");
INSERT INTO slk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Len si spomeňte, ako to bolo za čias proroka Eliáša, keď tri a pol roka nepršalo. V celej krajine nastal veľký hlad. V Izraeli bolo vtedy mnoho vdov, ");
INSERT INTO slk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ale ani k jednej Boh neposlal Eliáša: naopak, poslal ho k pohanskej vdove zo Sarepty v Sidone. ");
INSERT INTO slk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Alebo za čias proroka Elizea: v Izraeli bolo veľa malomocných, ale uzdravený bol iba Náman, pohan zo Sýrie.“ ");
INSERT INTO slk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Po týchto slovách sa všetci poslucháči v synagóge rozzúrili, ");
INSERT INTO slk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","schmatli Ježiša a vyviedli ho za mesto na svah vrchu, na ktorom bolo ich mesto postavené, aby ho zhodili dolu. ");
INSERT INTO slk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ježiš však zrazu prešiel pomedzi nich a pokračoval vlastnou cestou. ");
INSERT INTO slk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pobral sa do mesta Kafarnaum v Galilei a každú sobotu tam vyučoval. ");
INSERT INTO slk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Poslucháči žasli nad jeho učením, lebo ich učil ako niekto, kto má autoritu a moc. ");
INSERT INTO slk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Raz, keď učil v synagóge, bol tam muž ovládaný diablovým duchom. Ten začal vykrikovať: ");
INSERT INTO slk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Hej! Choď preč! Načo si prišiel, Ježiš z Nazareta? Chceš nás zahubiť? Ja viem, kto si: ten Svätý, čo prišiel od Boha!“ ");
INSERT INTO slk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ježiš však démonovi prikázal: „Mlč a vyjdi z neho!“ Zlý duch tým mužom mocne zalomcoval, hodil ho medzi nich a vyšiel z neho, ale neublížil mu. ");
INSERT INTO slk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ohromení ľudia sa medzi sebou zhovárali: „Aké mocné slová! S akou autoritou rozkazuje démonom, že ho na slovo poslúchajú?“ ");
INSERT INTO slk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Správa o ňom sa ihneď rozletela po celom kraji. ");
INSERT INTO slk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zo synagógy sa pobral do domu rybára Šimona. Šimonova svokra bola ťažko chorá a lomcovala ňou vysoká horúčka. Prosili ho, aby ju uzdravil. ");
INSERT INTO slk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ježiš sa sklonil nad chorú a na jeho slovo horúčka zmizla. Žena vstala z postele a šla im pripraviť jedlo. ");
INSERT INTO slk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Keď zapadlo slnko, všetci k nemu privádzali svojich blízkych, ktorí trpeli rozličnými ťažkosťami. Ježiš na nich kládol ruky a uzdravoval ich. ");
INSERT INTO slk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mnohých oslobodil aj od démonov, ktorí kričali: „Ty si Syn Boží!“ Ale Ježiš im pohrozil, lebo nechcel, aby práve oni hovorili, že je Mesiáš. ");
INSERT INTO slk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Zavčasu ráno odišiel z domu na osamelé miesto. Ľudia ho všade hľadali, a keď ho našli, chceli mu zabrániť, aby od nich odišiel. ");
INSERT INTO slk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ale on im povedal: „Aj ostatným mestám musím hlásať radostnú správu o prichádzajúcom Božom kráľovstve, veď na to ma Boh poslal.“ ");
INSERT INTO slk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A tak prechádzal judskou krajinou a kázal v synagógach. ");
INSERT INTO slk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jedného dňa stál Ježiš na brehu Genezaretského jazera, obklopený obrovským zástupom ľudí, ktorí sa okolo neho tlačili, lebo chceli počuť Božie slovo. ");
INSERT INTO slk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Všimol si na brehu dve prázdne loďky. Rybári z nich vystúpili a prali siete. ");
INSERT INTO slk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ježiš nastúpil na loďku, ktorá patrila Šimonovi, a poprosil ho, aby s ním odrazil od brehu. Potom si sadol a kázal odtiaľ zástupom. ");
INSERT INTO slk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Keď skončil, povedal Šimonovi: „Poď teraz s loďkou na miesto, kde je hlboká voda, a roztiahnite tam siete na lov.“ ");
INSERT INTO slk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Šimon odpovedal: „Učiteľ, celú noc sme tvrdo pracovali a nič sme nechytili. Ale ak je to tvoje prianie, spustíme siete do vody.“ ");
INSERT INTO slk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Vyplávali a vylovili také množstvo rýb, až sa im trhali siete. ");
INSERT INTO slk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Museli si zavolať na pomoc rybárov z druhej loďky. Čoskoro boli obe loďky také plné rýb, že sa takmer potápali. ");
INSERT INTO slk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Keď to Šimon Peter videl, padol pred Ježišom na kolená a prosil: „Odíď odo mňa, Pane, veď ja som hriešny človek!“ ");
INSERT INTO slk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peter bol totiž ohromený z takého nezvyčajného úlovku. Úžas sa zmocnil aj jeho spoločníkov: ");
INSERT INTO slk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jakuba a Jána, synov Zebedejových. Ježiš Šimonovi povedal: „Neboj sa! Odteraz nebudeš loviť ryby, ale budeš zachraňovať ľudí pre večnosť.“ ");
INSERT INTO slk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A len čo prirazili s loďkami k brehu, všetko tam nechali a šli za Ježišom. ");
INSERT INTO slk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","V jednom mestečku stretol Ježiš človeka postihnutého ťažkým malomocenstvom. Úbožiak si pred neho kľakol a prosil: „Pane, keby si chcel, mohol by si ma uzdraviť.“ ");
INSERT INTO slk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ježiš vystrel ruku, dotkol sa ho a povedal: „Áno, chcem. Buď zdravý!“ A v tej chvíli nezostalo po malomocenstve ani stopy. ");
INSERT INTO slk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ježiš mu prikázal, aby o tom nikomu nehovoril. „Choď a ukáž sa kňazovi! Potom prines Mojžišovým zákonom predpísanú obeť vďačnosti na dôkaz, že si zdravý.“ ");
INSERT INTO slk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zvesť o Ježišovi počulo čoraz viac ľudí. Prichádzali za ním veľké zástupy: chceli počúvať jeho učenie a byť uzdravení zo svojich chorôb. ");
INSERT INTO slk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","On však často odchádzal na opustené miesto a tam sa modlil. ");
INSERT INTO slk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jedného dňa, práve keď učil, zhromaždili sa farizeji a učitelia Zákona z rozličných miest Galiley a Judska, ba aj z Jeruzalema. Posadali si okolo neho a počúvali ho. Boh mu dal moc uzdravovať. ");
INSERT INTO slk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Akýsi muži priniesli na nosidlách ochrnutého človeka a chceli ho priniesť k Ježišovi. ");
INSERT INTO slk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nemohli sa však k nemu cez to množstvo ľudí dostať. Vyšli teda na strechu a cez otvor spustili ochrnutého na nosidlách priamo pred Ježiša. ");
INSERT INTO slk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Keď Ježiš videl ich vieru, povedal: „Priateľ môj, tvoje hriechy sú odpustené.“ ");
INSERT INTO slk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Učitelia Zákona a farizeji uvažovali: „Kto si myslí, že je! To je predsa rúhanie! Veď iba Boh má právo odpúšťať hriechy!“ ");
INSERT INTO slk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ježiš dobre vedel, čo si myslia, preto povedal: „Prečo sa pohoršujete vo svojich srdciach? ");
INSERT INTO slk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Veď čo je ľahšie? Povedať ochrnutému: ‚Tvoje hriechy sú odpustené‘, alebo mu prikázať: ‚Vstaň a choď!‘ ");
INSERT INTO slk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ale aby ste vedeli, že Syn človeka má moc na zemi odpúšťať hriechy…“ Vtedy sa obrátil k ochrnutému a povedal mu: „Vstaň a vezmi si svoje lôžko. Môžeš ísť domov!“ ");
INSERT INTO slk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ochrnutý hneď pred očami všetkých vstal a zbalil si rohož. Pobral sa domov a cestou hlasno chválil Boha. ");
INSERT INTO slk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Všetkých sa zmocnil úžas a oslavovali Boha. V bázni hovorili jeden druhému: „To, čo sme dnes videli, bolo naozaj mimoriadne!“ ");
INSERT INTO slk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Keď Ježiš neskôr vyšiel z domu, všimol si na colnici vyberača poplatkov, ktorý sa volal Lévi. Povedal mu: „Poď, staň sa mojím nasledovníkom!“ ");
INSERT INTO slk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A Lévi nechal všetko tak, vstal a šiel za ním. ");
INSERT INTO slk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Vo svojom dome potom usporiadal na Ježišovu počesť veľkú hostinu. Pozval na ňu aj mnoho ďalších vyberačov poplatkov. ");
INSERT INTO slk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizeji a učitelia Zákona sa na tom pohoršovali a vyčítali učeníkom: „Prečo si sadáte za stôl s takou spodinou?“ ");
INSERT INTO slk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ježiš im na to povedal: „Lekára nepotrebujú zdraví, ale chorí. ");
INSERT INTO slk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neprišiel som volať k Bohu tých, čo sú presvedčení o vlastnej spravodlivosti, ale hriešnikov, aby sa odvrátili od svojich hriechov.“ ");
INSERT INTO slk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Niektorí ľudia Ježišovi vyčítali: „Nasledovníci Jána Krstiteľa i nasledovníci farizejov sa často postia a modlia, ale tvoji sa nepostia vôbec.“ ");
INSERT INTO slk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ježiš im odpovedal: „Majú vari svadobčania, ktorých pozval ženích, dôvod smútiť, kým je s nimi? ");
INSERT INTO slk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ale prídu dni, keď bude ženích od nich vzatý, a potom sa budú postiť.“ ");
INSERT INTO slk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Potom im povedal aj podobenstvo: „Nikto predsa neodtrhne kus látky z nových šiat, aby ním zaplátal starý odev. Zničil by tak nové šaty a na staré by nová záplata ani nepristala. ");
INSERT INTO slk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A nikto nebude nalievať mladé víno do starých kožených mechov, lebo kvasiace víno by staré mechy roztrhlo, a tak by jedno i druhé vyšlo nazmar. ");
INSERT INTO slk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Preto mladé víno patrí do nových mechov. ");
INSERT INTO slk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ale vy dávate prednosť starému vínu. Vravíte, že staré víno je lepšie.“ ");
INSERT INTO slk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Raz v sobotu prechádzal Ježiš a jeho učeníci obilným poľom. Učeníci trhali klasy, mrvili ich a zrná jedli. ");
INSERT INTO slk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Videli to farizeji a pohoršovali sa: „Čo to robíte? V sobotu sa to predsa nesmie!“ ");
INSERT INTO slk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ježiš im odpovedal: „Nikdy ste nečítali, čo urobil kráľ Dávid, keď on aj jeho družina boli hladní? ");
INSERT INTO slk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ako vošiel do chrámu, vzal a jedol posvätné chleby, ktoré smeli jesť iba kňazi? Nečítali ste, ako z tých chlebov dal aj svojim spoločníkom?“ ");
INSERT INTO slk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A potom ešte dodal: „Veď Syn človeka má právo rozhodnúť aj o tom, čo sa v sobotu smie robiť a čo nie!“ ");
INSERT INTO slk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","V inú sobotu vošiel Ježiš do synagógy a vyučoval. Bol tam aj človek s ochrnutou pravou rukou. ");
INSERT INTO slk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Učitelia Zákona a farizeji napäto striehli, čo urobí. Ak postihnutého uzdraví, budú mať výbornú príležitosť vzniesť proti nemu obvinenie. ");
INSERT INTO slk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ale Ježiš dobre poznal ich myšlienky. Vyzval muža s ochrnutou rukou: „Poď sem a postav sa do prostriedku, aby ťa všetci videli.“ Muž poslúchol. ");
INSERT INTO slk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nato oslovil Ježiš farizejov a učiteľov Zákona: „Mám pre vás otázku: Je dovolené konať v sobotu dobro alebo nie? Má sa život zachrániť, alebo zničiť?“ ");
INSERT INTO slk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Každému z nich sa pozrel do očí a potom mužovi povedal: „Vystri ruku!“ Poslúchol a ruku mal opäť zdravú. ");
INSERT INTO slk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ježišových odporcov to veľmi nahnevalo a začali sa medzi sebou radiť, čo by mohli s Ježišom urobiť. ");
INSERT INTO slk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","V tých dňoch vystúpil Ježiš na vrch a celú noc tam strávil s Bohom na modlitbe. ");
INSERT INTO slk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Keď sa rozvidnelo, zavolal si k sebe učeníkov, vyvolil si z nich dvanástich a nazval ich apoštolmi. Boli to: ");
INSERT INTO slk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Šimon, ktorého volali aj Peter; Ondrej, jeho brat; Jakub a Ján; Filip a Bartolomej; ");
INSERT INTO slk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matúš a Tomáš; Jakub, syn Alfejov a Šimon, ktorého volali Horlivec; ");
INSERT INTO slk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Júda, syn Jakubov a Judáš Iškariotský, ktorý ho neskôr zradil. ");
INSERT INTO slk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Keď zostúpili z vrchu na rovinu, očakával ich už veľký zástup Ježišových stúpencov a davy ľudí z Jeruzalema i z celého Judska, ba aj z pobrežných miest Týru a Sidonu. ");
INSERT INTO slk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Prišli ho počúvať, ale aj dať sa uzdraviť. Vyliečil mnohých, ktorých trápili rozličné choroby spôsobené nečistými duchmi. ");
INSERT INTO slk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Všetci sa ho túžili aspoň dotknúť, lebo z neho vychádzala uzdravujúca moc. ");
INSERT INTO slk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tu sa Ježiš obrátil na svojich učeníkov a povedal: „Radujte sa, vy chudobní, lebo vám patrí Božie kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Radujte sa, ktorí trpíte hladom, lebo Boh vás nasýti. Radujte sa, ktorí teraz plačete, lebo príde čas, keď sa budete smiať. ");
INSERT INTO slk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Radujte sa, keď vás budú nenávidieť, vylučovať spomedzi seba, potupovať a hanobiť vaše mená preto, že sa hlásite k Synovi človeka. ");
INSERT INTO slk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tešte sa a jasajte od radosti, kedykoľvek sa to bude diať, lebo vás v nebi čaká veľká odmena: veď tak isto zaobchádzali ich predkovia s prorokmi. ");
INSERT INTO slk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ale beda vám, bohatí, lebo vy už tu na zemi máte svoje potešenie. ");
INSERT INTO slk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Beda vám, ktorí sa cítite nasýtení, lebo raz budete trpieť hladom. Beda vám, ktorí sa ľahkomyseľne smejete, lebo raz budete trpko nariekať. ");
INSERT INTO slk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A beda vám, ak vás všetci vychvaľujú, veď kedysi sa ich otcovia rovnako správali k falošným prorokom.“ ");
INSERT INTO slk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","„Ale vám, ktorí ma počúvate, radím: Milujte svojich nepriateľov. Robte dobre tým, ktorí vás nenávidia. ");
INSERT INTO slk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Žehnajte tých, ktorí vás preklínajú, a proste o Božie požehnanie pre tých, ktorí vám krivdia. ");
INSERT INTO slk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ak ťa niekto udrie po líci, nastav mu aj druhé. Ak od teba niekto žiada košeľu, daj mu aj kabát. ");
INSERT INTO slk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Každému, kto ťa o niečo prosí, daj, a ak si niekto vzal, čo patrí tebe, nevymáhaj to naspäť. ");
INSERT INTO slk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Správajte sa k ľuďom tak, ako chcete, aby sa oni správali k vám. ");
INSERT INTO slk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aké uznanie by ste chceli za to, že budete prejavovať lásku iba tým, ktorí milujú vás? To robia aj bezbožníci. ");
INSERT INTO slk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akú odmenu by ste chceli za to, že budete robiť dobre len tým, ktorí robia dobre vám? To isté predsa robia aj bezbožníci. ");
INSERT INTO slk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A akú by ste mali zásluhu, ak by ste požičiavali iba tým, o ktorých viete, že vám to vždy vrátia? Veď aj bezbožní ľudia požičiavajú s tým, že sa im to ľudia vrátia. ");
INSERT INTO slk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Vy však konajte inak. Milujte svojich nepriateľov. Robte im dobre! Požičiavajte a nevymáhajte naspäť. Veď je pre vás pripravená bohatá odmena a budete deťmi Boha Najvyššieho. Boh je totiž dobrý aj k ľuďom nevďačným a zlým. ");
INSERT INTO slk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Buďte teda milosrdní, ako je milosrdný aj váš Otec.“ ");
INSERT INTO slk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","„Nesúďte a nebudete súdení. Nikoho neodsudzujte a ani vy nebudete odsúdení. Odpúšťajte a aj vám bude odpustené. ");
INSERT INTO slk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dávajte ochotne a aj Boh vás zahrnie svojimi darmi. Váš dar sa vám vráti dobre utlačenou, utrasenou, vrchovatou mierou. Lebo akou mierou dávate vy – malou či veľkou – takou bude namerané aj vám.“ ");
INSERT INTO slk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ježiš im povedal aj prirovnanie: „Čo sa stane, ak slepý vedie slepého? Vari nespadnú obaja do jamy? ");
INSERT INTO slk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Žiak nie je väčší ako jeho učiteľ. Ale ak na sebe pracuje, môže sa mu vyrovnať. ");
INSERT INTO slk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Prečo sa staráš o smietku v oku svojho brata, ale brvno vo vlastnom oku si si nevšimol? ");
INSERT INTO slk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ako sa opovážiš povedať: ‚Brat môj, dovoľ, nech ti vyberiem smietku z oka‘, a pritom brvno vo vlastnom oku nevidíš? Pokrytec, najprv odstráň brvno z vlastného oka, a až potom budeš môcť dobre vidieť, ako odstrániť triesku z oka svojho brata.“ ");
INSERT INTO slk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","„Dobre zaštepený strom nerodí plané ovocie a planý strom nemôže rodiť ušľachtilé ovocie. ");
INSERT INTO slk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Každý strom sa pozná podľa ovocia. Veď z bodliakov sa neoberajú figy ani z tŕnia hrozno. ");
INSERT INTO slk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dobrý človek rozdáva z dobrého pokladu svojho srdca dobré veci. Zlý človek má srdce plné zla, šíri iba zlo. Lebo jeho ústa hovoria iba to, čím je preplnené jeho srdce.“ ");
INSERT INTO slk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","„Prečo ma stále oslovujete: ‚Pane, Pane‘, ale nerobíte to, čo vám hovorím? ");
INSERT INTO slk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Každý, kto prichádza ku mne, počúva, čo hovorím, a podľa toho aj koná, ");
INSERT INTO slk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","podobá sa človeku, ktorý staval dom. Kopal hlboko a základy položil na skale. Keď sa prihnala povodeň a vody sa zapreli do domu, nepohol sa, lebo mal pevné základy. ");
INSERT INTO slk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ale ten, kto počúva moje slová, no nežije podľa nich, podobá sa človeku, ktorý si postavil dom bez základov. Keď sa prihnala povodeň, dom sa zrútil a zostali z neho iba ruiny.“ ");
INSERT INTO slk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Keď to všetko povedal poslucháčom, vrátil sa späť do Kafarnauma. ");
INSERT INTO slk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tam mal istý rímsky dôstojník sluhu, ktorého si veľmi vážil, a ten na smrť ochorel. ");
INSERT INTO slk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Keď sa dôstojník dopočul o Ježišovi, poslal k nemu židovských starších s prosbou, aby prišiel a uzdravil mu sluhu. ");
INSERT INTO slk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tí sa pobrali k Ježišovi a naliehavo ho prosili: „Zaslúži si, aby si mu pomohol. ");
INSERT INTO slk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Má rád náš národ, ba dal nám postaviť aj synagógu.“ ");
INSERT INTO slk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ježiš šiel s nimi. A keď už bol neďaleko dôstojníkovho domu, ten poslal k nemu svojich priateľov s odkazom: „Pane, neobťažuj sa, nie som hoden, aby si vstúpil pod moju strechu. ");
INSERT INTO slk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Preto som sa ani neodvážil prísť za tebou osobne. No stačí, ak povieš slovo, a môj sluha určite vyzdravie. ");
INSERT INTO slk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Veď aj ja sa musím podriaďovať rozkazom svojich veliteľov a sám dávam príkazy vojakom. Ak niektorému poviem: ‚Choď!‘, tak ide, a ak rozkážem inému: ‚Príď!‘, tak príde. A ak poviem svojmu sluhovi: ‚Urob to!‘, tak to urobí!“ ");
INSERT INTO slk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Keď to Ježiš počul, bol veľmi prekvapený. Obrátil sa k zástupu, ktorý ho sprevádzal, a povedal: „Vravím vám, že v celom izraelskom národe som nestretol človeka, ktorý by mal takú veľkú vieru!“ ");
INSERT INTO slk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Keď sa dôstojníkovi poslovia vrátili domov, našli sluhu zdravého. ");
INSERT INTO slk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hneď nato sa Ježiš pobral do mesta Naim. Šli s ním jeho učeníci a veľký zástup ľudí. ");
INSERT INTO slk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Keď prišli až k mestskej bráne, stretli pohrebný sprievod. Pochovávali jediného syna istej vdovy. Sprevádzalo ju mnoho ľudí z mesta. ");
INSERT INTO slk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Keď ju Pán videl, prišlo mu jej ľúto a povedal: „Neplač!“ ");
INSERT INTO slk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Potom pristúpil bližšie k máram, dotkol sa ich a tí, čo ich niesli, zastali. Ježiš povedal: „Chlapec, vravím ti, vstaň!“ ");
INSERT INTO slk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ten, čo bol mŕtvy, sa zrazu posadil a začal sa zhovárať s ľuďmi okolo. Tak Ježiš vrátil matke syna. ");
INSERT INTO slk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Všetkých naplnila veľká bázeň a zvelebovali a oslavovali Boha: „Prišiel k nám veľký prorok! Boh navštívil svoj ľud!“ ");
INSERT INTO slk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Správa o tejto udalosti sa rozniesla po celom Judsku i po celom okolí. ");
INSERT INTO slk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Správy o všetkom, čo Ježiš robil, priniesli Jánovi jeho učeníci. Dvoch z nich si Ján zavolal ");
INSERT INTO slk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a poslal ich k Ježišovi s otázkou: „Si naozaj Mesiáš, ktorý mal prísť, alebo máme čakať niekoho iného?“ ");
INSERT INTO slk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Keď prišli za Ježišom, povedali mu: „Ján Krstiteľ nás poslal, aby sme sa ťa opýtali, či si naozaj Mesiáš, ktorý mal prísť, alebo máme čakať niekoho iného?“ ");
INSERT INTO slk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Práve, keď tam boli, Ježiš uzdravil mnohých trpiacich – chorých, posadnutých zlými duchmi a mnohým slepým vrátil zrak. ");
INSERT INTO slk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Odpovedal im: „Choďte a povedzte Jánovi, čo ste videli a čo ste počuli: slepí vidia, chromí chodia, malomocní sú uzdravení, hluchí počujú, mŕtvi sa prebúdzajú k životu a chudobným sa zvestuje radostná správa. ");
INSERT INTO slk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Šťastný je ten, kto mi dôveruje.“ ");
INSERT INTO slk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Keď Jánovi poslovia odišli, začal Ježiš rozprávať o Jánovi zástupom: „Keď ste šli na judskú púšť, čo ste chceli obdivovať? Trstinu kolísanú vetrom? ");
INSERT INTO slk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Alebo ste chceli vidieť človeka oblečeného do drahých šiat? Ale veď tí žijú v prepychu v kráľovských palácoch. ");
INSERT INTO slk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Alebo ste chceli počuť proroka? Áno, poznali ste ešte niekoho väčšieho ako proroka. ");
INSERT INTO slk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ján je ten, o ktorom prorok Malachiáš napísal: ‚Posielam svojho posla pred tebou, aby ti pripravil cestu.‘ ");
INSERT INTO slk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Vedzte, že medzi všetkými ľuďmi, ktorí sa kedy narodili, niet nikoho, kto by prevyšoval Jána Krstiteľa, a predsa i ten najmenší v nebeskom kráľovstve je väčší ako on.“ ");
INSERT INTO slk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Všetci, ktorí počuli Jána kázať – a boli medzi nimi aj ľudia pochybnej povesti – nechali sa od neho pokrstiť. Tým uznali, že spôsob, akým Boh koná, je správny. ");
INSERT INTO slk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farizeji a učitelia Zákona však Jánov krst odmietli, lebo nepochopili, že aj oni potrebujú Božie odpustenie. ");
INSERT INTO slk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ježiš pokračoval: „Ku komu mám prirovnať ľudí ako vy? Komu sa podobajú? ");
INSERT INTO slk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sú ako deti, ktoré sa hrajú na námestí chvíľu na svadbu, chvíľu na pohreb a vzájomne si vyčítajú: ‚Pískali sme vám, ale netancovali ste.‘ ‚A my sme vám zasa smutne spievali, a neplakali ste.‘ ");
INSERT INTO slk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Keď prišiel Ján Krstiteľ, nejedol chleba a nepil víno a vraveli, že je posadnutý, ");
INSERT INTO slk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ale keď prišiel Syn človeka, ktorý je a pije, vravíte pohŕdavo: ‚Pozrite sa na toho nenažranca a opilca, ktorý sa priatelí so zdieračmi a kadejakou spodinou.‘ ");
INSERT INTO slk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dokonalosť Božej múdrosti dokážu tí, čo sa ňou nechajú viesť.“ ");
INSERT INTO slk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jeden z farizejov pozval Ježiša na obed. Ježiš pozvanie prijal a stoloval s ním. ");
INSERT INTO slk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","V tom meste žila žena veľmi zlej povesti. Keď sa dozvedela, že Ježiš je na návšteve u farizeja Šimona, priniesla alabastrovú nádobku so vzácnym vonným olejom. ");
INSERT INTO slk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","S plačom pristúpila odzadu k jeho nohám, zmáčala ich slzami, utierala svojimi vlasmi, bozkávala a natierala olejom. ");
INSERT INTO slk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Keď to videl hostiteľ, povedal si v duchu: „Keby to bol prorok, vedel by, že tá žena je veľká hriešnica a nedovolil by, aby sa ho čo i len dotkla.“ ");
INSERT INTO slk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","V tom ho Ježiš oslovil: „Rád by som sa ťa, Šimon, na niečo spýtal.“ – „Prosím, len vrav,“ povedal Šimon. ");
INSERT INTO slk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","„Jeden z veriteľov mal dvoch dlžníkov. Prvý mu bol dlžný päťsto denárov, druhý päťdesiat. ");
INSERT INTO slk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Keďže ani jeden nemal z čoho dlžobu zaplatiť, odpustil obidvom. Čo myslíš, ktorý z tých dvoch ho bude mať radšej?“ – ");
INSERT INTO slk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","„Myslím, že ten, ktorému viac odpustil,“ odpovedal Šimon. „Správne uvažuješ,“ odpovedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Potom ukázal na ženu pri svojich nohách a povedal Šimonovi: „Pozri na tú ženu. Keď som prišiel do tvojho domu, nedoniesol si vodu na umytie nôh, ako je zvykom. Táto žena mi ich však umyla svojimi slzami a poutierala vlastnými vlasmi. ");
INSERT INTO slk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na uvítanie si ma nebozkal, ale táto žena mi neprestáva bozkávať nohy. ");
INSERT INTO slk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nepotrel si mi hlavu olejom, ale ona mi vzácnym olejom natierala nohy. ");
INSERT INTO slk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Veľká láska, ktorú mi táto žena prejavila, je dôkazom, že jej bolo odpustených mnoho hriechov. Ten, kto si neuvedomuje potrebu Božieho odpustenia, ten vie prejaviť len veľmi málo lásky.“ ");
INSERT INTO slk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ježiš potom povedal žene: „Tvoje hriechy sú odpustené.“ ");
INSERT INTO slk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ľudia, ktorí boli na hostine, si v duchu vraveli: „Kto si myslí, že je, keď si trúfa odpúšťať hriechy!?“ ");
INSERT INTO slk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ježiš však žene znovu povedal: „Boh ťa zachránil pre tvoju dôveru vo mňa. Môžeš ísť a Boží pokoj bude s tebou.“ ");
INSERT INTO slk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ježiš potom chodil z mesta do mesta, z dediny do dediny a všade prinášal radostnú zvesť o Božom kráľovstve. Sprevádzalo ho jeho dvanásť učeníkov a ");
INSERT INTO slk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","niektoré ženy, ktoré zbavil démonov a uzdravil z rozličných chorôb. Boli to: Mária zvaná Magdaléna, z ktorej vyhnal sedem démonov; ");
INSERT INTO slk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jana, žena Herodesovho správcu Chúzu; Zuzana a mnohé iné, ktoré sa o nich starali z vlastných prostriedkov. ");
INSERT INTO slk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Keď sa raz okolo Ježiša zhromaždilo mnoho ľudí zo všetkých kútov, vyrozprával im toto podobenstvo: ");
INSERT INTO slk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Roľník vyšiel na pole zasiať obilie. Ako rozsieval, niektoré zrnko padlo na cestu, kde ho buď pošliapali ľudia, alebo ho vyzobali vtáci. ");
INSERT INTO slk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iné padlo do skalnatej pôdy, vyklíčilo, ale hneď uschlo, lebo nemalo dostatok vlahy. ");
INSERT INTO slk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ďalšie padlo do tŕnia, ktoré ho prerástlo a udusilo. ");
INSERT INTO slk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jedno však padlo do úrodnej pôdy, vyrástlo klíčilo a vyhnalo do plného klasu, v ktorom bolo až sto zŕn.“ Keď dorozprával toto podobenstvo, povedal: „Kto má uši na počúvanie, nech počúva!“ ");
INSERT INTO slk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Neskôr sa ho učeníci spytovali, čo to podobenstvo znamená. ");
INSERT INTO slk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Odpovedal im: „Vám už Boh zjavil tajomstvá Božieho kráľovstva. Ostatným však hovorím v podobenstvách, aby boli nútení rozmýšľať. Oni však počúvajú, ale nerozumejú, pozerajú sa, ale nevidia. ");
INSERT INTO slk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Zmysel tohto podobenstva je nasledovný: ");
INSERT INTO slk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Zrno je Božie posolstvo ľuďom. Cesta, na ktorú padajú prvé zrná, to sú tvrdé srdcia tých, čo počúvajú Božie slovo, ale potom príde diabol a vytrhne im ho zo srdca, aby neuverili a neboli zachránení. ");
INSERT INTO slk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Skalnatá pôda predstavuje tých, ktorí s radosťou prijímajú slovo, ale nedovolia, aby sa v nich zakorenilo a prinieslo úrodu. Veria, že Božie slovo je správne, no len čo prídu nejaké prekážky, odpadnú. ");
INSERT INTO slk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zrno, čo spadlo do tŕnia, to sú tí, ktorí počúvajú Božie slovo a veria, ale ich vieru udusia starosti, honba za bohatstvom a užívaním života, takže neprinesú úžitok. ");
INSERT INTO slk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A napokon zrno v dobrej pôde sú tí, ktorí dychtivo počúvajú slovo, zachovávajú ho v dobrom a úprimnom srdci a prinášajú trvalý úžitok.“ ");
INSERT INTO slk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","„Nikto predsa nerozsvieti lampu, aby ju prikryl nádobou alebo strčil pod posteľ, ale postaví ju na svietnik, aby svietila všetkým v dome. ");
INSERT INTO slk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Všetko, čo je teraz skryté, sa raz dostane na svetlo a všetko, čo je ešte tajomné, bude raz zjavné. ");
INSERT INTO slk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dbajte teda na to, ako počúvate. Lebo ten, kto žije podľa Božieho slova, bude mu rozumieť stále viac. Ale ten, kto podľa neho nežije, čoskoro prestane rozumieť aj to, čo mu je teraz jasné.“ ");
INSERT INTO slk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Potom za ním prišla jeho matka a bratia, ale nemohli sa k nemu dostať pre zástup. ");
INSERT INTO slk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ľudia mu oznámili: „Tvoja matka a bratia stoja vonku a chcú sa s tebou stretnúť.“ ");
INSERT INTO slk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","On im však odpovedal: „Moja matka a moji bratia sú tí, ktorí počúvajú Božie slovo a žijú podľa neho.“ ");
INSERT INTO slk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jedného dňa povedal Ježiš svojim učeníkom: „Preplavme sa na druhý breh jazera.“ Nastúpili teda spoločne do loďky ");
INSERT INTO slk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","a odrazili od brehu. Kým sa plavili, Ježiš zaspal. Onedlho sa strhla veľká búrka s víchricou. Ocitli sa vo veľkom nebezpečenstve, lebo do loďky sa im začala naberať voda a hrozilo, že sa potopí. ");
INSERT INTO slk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Učeníci pristúpili k Ježišovi a budili ho: „Učiteľ! Učiteľ! Utopíme sa!“ Ježiš vstal, pohrozil vetru aj valiacim sa vlnám. Búrka utíchla a rozhostilo sa ticho. ");
INSERT INTO slk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Potom sa opýtal učeníkov: „Kde je vaša viera?“ Predesení sa čudovali a pýtali sa jeden druhého: „Kto to vlastne je, že dáva príkazy vetru i vode a poslúchajú ho?“ ");
INSERT INTO slk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pristáli na druhom brehu jazera oproti Galilei, v kraji Gerazénov. ");
INSERT INTO slk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Len čo Ježiš vystúpil z loďky, vyšiel mu oproti z mesta Gadary akýsi muž posadnutý démonmi. Už dlhý čas sa potuloval neoblečený a miesto domu spával v prázdnych hroboch vytesaných do skaly. ");
INSERT INTO slk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Keď zbadal Ježiša, zreval, hodil sa pred ním na kolená a kričal: „Čo odo mňa chceš, Ježišu, Syn najvyššieho Boha! Prosím ťa, nemuč ma!“ ");
INSERT INTO slk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","To povedal preto, lebo Ježiš prikázal nečistému duchu, aby vyšiel z toho človeka. Už dlho ho totiž ovládal, a hoci mal ruky aj nohy často spútané reťazami, putá popretŕhal a démon ho hnal na pusté miesta. ");
INSERT INTO slk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ježiš sa ho spýtal: „Aké meno ti dali?“ – „Légia,“ zaznela odpoveď. Bol totiž posadnutý mnohými zlými duchmi. ");
INSERT INTO slk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A tí prosíkali, aby ich Ježiš neposlal do bezodnej priepasti. ");
INSERT INTO slk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na neďalekom svahu sa pásla veľká črieda svíň. Démoni ho požiadali, aby im dovolil vojsť do nich. Dovolil im to. ");
INSERT INTO slk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ihneď opustili úbožiaka a vošli do svíň. Črieda sa splašila, hnala sa po strmom úbočí do jazera a utopila sa v ňom. ");
INSERT INTO slk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Keď pastieri videli, čo sa stalo, rozutekali sa a každému o tom v meste i po dedinách hovorili. ");
INSERT INTO slk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ľudia sa prichádzali pozrieť, čo sa vlastne stalo. Prišli k Ježišovi a videli, ako mu pri nohách pokojne sedí muž, z ktorého vyšli démoni, oblečený a zdravý. To ich vydesilo. ");
INSERT INTO slk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tí, čo boli svedkami tejto udalosti im totiž rozprávali, ako bol tento posadnutý človek uzdravený. ");
INSERT INTO slk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zmocnila sa ich taká hrôza, že všetci, čo tam bývali, začali Ježiša prosiť, aby z ich kraja odišiel. A tak nastúpil do loďky, aby sa vrátil späť. ");
INSERT INTO slk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Muž, ktorého Ježiš vyslobodil z moci démonov, ho prosil, aby smel zostať s ním, ale Ježiš ho poslal preč so slovami: ");
INSERT INTO slk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Vráť sa domov a rozprávaj všetkým, aký zázrak Boh urobil!“ Muž poslúchol, vrátil sa do mesta a všade rozprával, aké dobrodenie mu Ježiš vykonal. ");
INSERT INTO slk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na druhom brehu jazera ho srdečne uvítal zástup ľudí, ktorí ho tu čakali. ");
INSERT INTO slk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bol medzi nimi aj predstavený židovskej synagógy Jairos. Padol Ježišovi k nohám a úpenlivo ho prosil, aby šiel do jeho domu, ");
INSERT INTO slk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","lebo jeho jediná dcéra, ktorá mala iba dvanásť rokov, zomierala. Ježiš sa pobral s ním, ale zovšadiaľ sa tlačil zástup ľudí. ");
INSERT INTO slk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bola tam aj istá žena, ktorá už dvanásť rokov trpela krvácaním, a hoci minula na lekárov celý svoj majetok, ani jednému sa ju nepodarilo vyliečiť. ");
INSERT INTO slk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pristúpila k Ježišovi zozadu, dotkla sa okraja jeho plášťa a v tej chvíli pocítila, že prestala krvácať. ");
INSERT INTO slk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","„Kto sa ma to dotkol?“ spýtal sa Ježiš. Keď sa nikto nechcel priznať, Peter namietol: „Majstre, veď pozri, koľko veľa je tu ľudí. Mohlo sa stať, že niekto do teba sotil.“ ");
INSERT INTO slk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ale Ježiš odpovedal: „Niekto sa ma úmyselne dotkol a viem, že moja moc mu pomohla.“ ");
INSERT INTO slk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Keď žena videla, že sa to nedá utajiť, prišla celá rozochvená k Ježišovi, padla pred ním na kolená a pred všetkými sa priznala, prečo sa ho dotkla, aj ako bola hneď uzdravená. ");
INSERT INTO slk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","„Dcéra, tvoja viera ťa uzdravila. Môžeš pokojne odísť,“ povedal jej Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kým sa zhováral so ženou, priniesol ktosi z Jairovho domu správu: „Tvoja dcéra už zomrela, neobťažuj Majstra.“ ");
INSERT INTO slk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Keď to Ježiš počul, povedal otcovi: „Neboj sa, dôveruj mi, a tvoja dcéra bude zachránená!“ ");
INSERT INTO slk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Keď prišli k Jairovmu domu, nedovolil nikomu vojsť dnu. Vzal so sebou iba Petra, Jána, Jakuba a rodičov dievčatka. ");
INSERT INTO slk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tam už všetci oplakávali mŕtvu a srdcervúco nariekali. Ježiš im povedal: „Neplačte, veď neumrela, iba spí.“ ");
INSERT INTO slk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Do očí sa mu vysmiali, lebo vedeli, že je naozaj mŕtva. ");
INSERT INTO slk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chytil ju za ruku a zvolal: „Dievčatko, vstaň!“ ");
INSERT INTO slk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A ono hneď ožilo a vstalo. Povedal: „Dajte sa mu najesť!“ ");
INSERT INTO slk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rodičov sa zmocnil úžas, ale Ježiš im prikázal, aby nikomu nevraveli, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ježiš si zvolal svojich dvanástich učeníkov a dal im silu a právomoc vyháňať všetkých démonov a liečiť choroby. ");
INSERT INTO slk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Potom ich poslal hlásať Božie kráľovstvo a uzdravovať chorých. ");
INSERT INTO slk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Povedal im: „Nič si neberte na cestu; ani palicu, ani tašku, ani chlieb, ani peniaze, ba ani odev na prezlečenie. ");
INSERT INTO slk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kde vám poskytnú prístrešie, tam bývajte, kým sa nepoberiete ďalej. ");
INSERT INTO slk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A ak vás niekde neprijmú, nevnucujte sa; odíďte a straste si pred nimi aj prach zo svojich nôh, aby ste ich tak varovali pred Božím hnevom.“ ");
INSERT INTO slk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Učeníci sa vydali na cestu, chodili z dediny do dediny, všade prinášali radostnú zvesť o záchrane a uzdravovali chorých. ");
INSERT INTO slk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chýr o Ježišových zázrakoch sa dostal až do uší vladára Galiley Herodesa, ktorý nevedel, čo si o tom má myslieť. Niektorí totiž tvrdili, že to vstal z mŕtvych Ján Krstiteľ, ktorého dal Herodes popraviť. ");
INSERT INTO slk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Iní sa nazdávali, že sa znova zjavil prorok Eliáš, ďalší usudzovali, že vstal jeden z dávnych prorokov. ");
INSERT INTO slk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","„Ja som predsa dal Jána sťať,“ vravel Herodes. „Kto len môže byť ten človek, o ktorom počúvam také zvláštne veci?“ Preto sa s ním veľmi túžil stretnúť. ");
INSERT INTO slk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Keď sa apoštoli vrátili, porozprávali Ježišovi všetko, čo robili. Utiahol sa s nimi do ústrania neďaleko mesta Betsaida. ");
INSERT INTO slk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Len čo sa však ľudia dozvedeli, kam šiel, vybrali sa za ním. Ježiš ich prijal, znova im hovoril o Božom kráľovstve a uzdravoval tých, ktorí to potrebovali. ");
INSERT INTO slk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zvečerievalo sa. Prišli za ním dvanásti učeníci a pripomenuli mu: „Povedz ľuďom, aby si šli do okolitých dediniek a osád nájsť nocľah a jedlo, lebo tu na tejto pustatine nič nezoženú.“ ");
INSERT INTO slk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","„Vy sa im postarajte o jedlo!“ povedal Ježiš učeníkom. „My?“ začudovali sa. „Veď máme iba päť chlebov a dve ryby. Alebo máme azda ísť a nakúpiť potravu pre celý tento zástup?“ ");
INSERT INTO slk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Len mužov tam bolo asi päťtisíc. ");
INSERT INTO slk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","„Usaďte všetkých na zem do skupín asi po päťdesiatich,“ rozkázal učeníkom. Urobili podľa jeho pokynu. ");
INSERT INTO slk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Potom vzal tých päť chlebov a dve ryby, uprel zrak k nebu a poďakoval za ne Bohu. Rozlamoval chleby a podával učeníkom, aby ich roznášali ľuďom. ");
INSERT INTO slk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Všetci sa dosýta najedli a ešte sa nazbieralo aj dvanásť košov zvyškov. ");
INSERT INTO slk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Raz, keď sa Ježiš v súkromí modlil, opýtal sa učeníkov: „Za koho ma ľudia pokladajú?“ ");
INSERT INTO slk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","„Niektorí za Jána Krstiteľa,“ odpovedali mu, „iní za Eliáša, ďalší vravia, že to vstal z mŕtvych jeden z dávnych prorokov.“ ");
INSERT INTO slk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","„A vy? Kto som podľa vás?“ spýtal sa ich priamo. „Ty si Bohom zasľúbený Mesiáš,“ odpovedal Peter. ");
INSERT INTO slk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ježiš im však prikázal, aby o tom nikomu nehovorili, ");
INSERT INTO slk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","a dodal: „Syn človeka musí veľa trpieť. Židovskí vodcovia, veľkňazi a učitelia Zákona ho odsúdia, zabijú, ale na tretí deň vstane z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Potom povedal aj ostatným: „Kto ma chce nasledovať, nech prestane myslieť na seba, deň čo deň nech nesie svoj kríž a ide za mnou. ");
INSERT INTO slk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Každý, kto by chcel zachrániť svoj život, stratí ho, ale kto stratí svoj život pre mňa, získa ho. ");
INSERT INTO slk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Veď čo by mal človek z toho, keby získal hoc aj celý svet, ale svoj život premrhal alebo ho stratil? ");
INSERT INTO slk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kto ma odmieta a hanbí sa za mňa i za moje slová, toho raz odmietne aj Syn človeka, keď príde v sprievode anjelov vo svojej sláve a v sláve Otcovej. ");
INSERT INTO slk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A niektorí z vás ešte za svojho života uvidia moc Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asi týždeň po tomto rozhovore vzal Ježiš so sebou Petra, Jakuba a Jána a vystúpil na vrch modliť sa. ");
INSERT INTO slk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pri modlitbe sa zmenil výraz jeho tváre a jeho oblečenie sa stalo žiarivo bielym. ");
INSERT INTO slk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Potom sa s ním začali zhovárať dvaja muži – Mojžiš a Eliáš, ");
INSERT INTO slk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ktorí sa im zjavili v žiarivej nádhere. Rozprávali sa s Ježišom o jeho odchode, ktorý ho čaká v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petra a jeho druhov zmáhala únava, ale keď nakoniec premohli spánok, uvideli Ježiša žiariaceho nebeským jasom a vedľa neho tých dvoch mužov. ");
INSERT INTO slk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Keď Mojžiš a Eliáš od Ježiša odchádzali, Peter celý zmätený, zvolal: „Majstre, to je dobre, že sme tu! Postavme tu tri stany: tebe, Mojžišovi a Eliášovi.“ ");
INSERT INTO slk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kým to dopovedal, všetkých obkolesil oblak. Učeníci sa vydesili. ");
INSERT INTO slk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Z oblaku sa však ozval hlas: „Toto je môj vyvolený Syn, toho poslúchajte!“ ");
INSERT INTO slk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Keď hlas doznel, Ježiš zostal sám so svojimi učeníkmi. V tých dňoch však učeníci nikomu nehovorili o tom, čo na vrchu prežili. ");
INSERT INTO slk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Keď na druhý deň zostúpili z vrchu, vyšiel im oproti veľký zástup ľudí. ");
INSERT INTO slk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Z davu vykríkol akýsi muž: „Majstre, prosím ťa, ujmi sa môjho syna. Je to moje jediné dieťa. ");
INSERT INTO slk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Často ho ovládne démon a lomcuje ním tak, že syn kričí a ústa sa mu spenia. Záchvat trvá dlho a veľmi ho vyčerpáva. ");
INSERT INTO slk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Prosil som tvojich učeníkov, aby mi syna uzdravili, ale nemohli.“ ");
INSERT INTO slk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ježiš pokarhal učeníkov: „Ach, vy obmedzení a neveriaci ľudia! Dokedy mám byť ešte s vami a znášať vás?“ Potom tomu mužovi povedal: „Priveď mi sem syna!“ ");
INSERT INTO slk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ako sa chlapec blížil k Ježišovi, démon ho hodil na zem a zmietal ním. Ježiš vyhnal démona a chlapca uzdravil. Tak Ježiš vrátil otcovi jeho syna. ");
INSERT INTO slk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Všetci žasli nad veľkým prejavom Božej moci. Kým sa všetci nadchýnali zázrakmi, ktoré Ježiš urobil, vravel svojim učeníkom: ");
INSERT INTO slk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Počúvajte ma a dobre si pamätajte tieto slová: Syn človeka má byť vydaný do rúk ľudí.“ ");
INSERT INTO slk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Učeníci však jeho slovám nerozumeli. Ich myseľ bola totiž zastretá a nemali ani odvahu opýtať sa, čo má Ježiš na mysli. ");
INSERT INTO slk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Potom sa začali dohadovať, kto z nich je najdôležitejší. ");
INSERT INTO slk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ježiš vedel, o čom premýšľajú, a preto pred nich postavil dieťa ");
INSERT INTO slk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a povedal: „Kto prijíma čo i len jedného zdanlivo nedôležitého človeka, ako je toto dieťa, v mojom mene, mňa prijíma. A kto mňa prijíma, prijíma aj toho, ktorý ma poslal. Ten najbezvýznamnejší medzi vami je v Božích očiach najdôležitejší.“ ");
INSERT INTO slk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Vtedy pristúpil k nemu Ján a povedal mu: „Majstre, videli sme človeka, ktorý v tvojom mene vyháňal démonov. Usilovali sme sa mu v tom zabrániť, lebo nepatrí medzi nás.“ ");
INSERT INTO slk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ježiš namietol: „Nebráňte mu! Veď kto nie je proti vám, je s vami.“ ");
INSERT INTO slk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Keď sa priblížil čas, v ktorom sa mal Ježiš vrátiť hore do neba, rozhodol sa ísť do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jedného dňa poslal poslov do samaritánskej dediny, aby tam zohnali nocľah. ");
INSERT INTO slk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ale neprijali ho, lebo mal namierené do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jakuba a Jána to rozhnevalo a povedali: „Majstre, máme na nich privolať oheň z neba ako kedysi Eliáš? Nech tá dedina zhorí!“ ");
INSERT INTO slk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ale Ježiš sa k nim obrátil a pokarhal ich. (Potom im povedal: „Vravíte, akoby ste ani neboli moji učeníci. ");
INSERT INTO slk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Syn človeka predsa neprišiel ľudí zahubiť, ale zachrániť.“) A tak sa pobrali do inej dediny. ");
INSERT INTO slk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ako sa uberali cestou, ktosi mu povedal: „Pôjdem za tebou všade, kamkoľvek pôjdeš.“ ");
INSERT INTO slk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","No Ježiš mu odpovedal: „Líšky majú svoje nory a vtáci svoje hniezda, ale Syn človeka nemá kde hlavu skloniť.“ ");
INSERT INTO slk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iného muža vyzval: „Poď za mnou!“ Ale ten váhal a vyhováral sa: „Dovoľ mi, aby som najprv pochoval otca.“ ");
INSERT INTO slk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ježiš mu odpovedal: „Nech tí, čo sú mŕtvi, pochovajú svojich mŕtvych. Ty choď a hovor ľuďom o Božom kráľovstve.“ ");
INSERT INTO slk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iný mu zase povedal: „Budem ťa nasledovať, ale najprv mi dovoľ, aby som sa rozlúčil so svojou rodinou.“ ");
INSERT INTO slk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ježiš mu povedal: „Ak chce oráč vyorať brázdu, nesmie sa obracať naspäť. Kto nie je ochotný ísť hneď, nie je súci pre Božie kráľovstvo.“ ");
INSERT INTO slk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ježiš si potom vyvolil ešte sedemdesiatich dvoch iných učeníkov a poslal ich po dvoch do každého mesta a dediny, ktoré mienil navštíviť. ");
INSERT INTO slk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pred odchodom im povedal: „Proste Pána žatvy, aby vám poslal na pomoc viacerých žencov, lebo pole, ktoré treba zožať, je obrovské a pracovníkov je málo. ");
INSERT INTO slk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Choďte! Posielam vás ako ovce medzi vlkov. ");
INSERT INTO slk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Neberte si so sebou peniaze, ani tašku, ani obuv! A cestou sa nezdržiavajte! ");
INSERT INTO slk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Keď vojdete do niektorého domu, najprv im zaželajte: ‚Pokoj tomuto domu!‘ ");
INSERT INTO slk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ak vás prijmú v pokoji, pokoj sa usídli v tom dome. No ak vás odmietnu, pokoj zostane vám. ");
INSERT INTO slk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tam, kde vás prijmú, zdržte sa a prijmite ich pohostinstvo, lebo pracovník má právo na svoju mzdu. Neprechádzajte z domu do domu. ");
INSERT INTO slk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ak vás prijmú v niektorom meste: prijmite, čím vás ponúknu, ");
INSERT INTO slk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","uzdravujte chorých a hlásajte: ‚Božie kráľovstvo je celkom blízko vás.‘ ");
INSERT INTO slk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ale ak vás v niektorom meste neprijmú, vyjdite do jeho ulíc a rozhláste: ");
INSERT INTO slk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‚Vytriasame na vás ešte aj prach zo svojich nôh. Vezmite však na vedomie, že aj k vám prichádza Božie kráľovstvo.‘ ");
INSERT INTO slk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hovorím vám, že v deň Božieho súdu bude obyvateľom Sodomy ľahšie než tomuto mestu.“ ");
INSERT INTO slk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Potom Ježiš začal hovoriť o galilejských mestách, kde mnohí v neho neuverili: „Beda ti, Korazim! Beda ti, Betsaida! Keby sa v pohanských mestách Týre a Sidone stali také zázraky ako u vás, ich obyvatelia by už dávno robili pokánie a prejavili by najhlbšiu ľútosť nad svojimi vinami. ");
INSERT INTO slk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A tak Týru a Sidonu bude v deň posledného súdu ľahšie ako vám. ");
INSERT INTO slk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A čo mám povedať o vás, obyvatelia Kafarnauma? Myslíte si, že Boh vás vyvýši až po samé nebo? Zrútite sa do priepasti večného zahynutia!“ ");
INSERT INTO slk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Potom povedal svojim učeníkom: „Kto vás počúva, mňa počúva. Kto však vás odmieta, mňa odmieta, a tým odmieta toho, ktorý ma poslal.“ ");
INSERT INTO slk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Neskôr sa tí sedemdesiati dvaja učeníci vrátili s radostnými správami: „Pane, aj démoni sa nám podrobujú, keď vyslovíme tvoje meno!“ ");
INSERT INTO slk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Odpovedal im: „Áno, videl som satana padať z neba ako blesk! ");
INSERT INTO slk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dal som vám moc potláčať moc tohto nepriateľa, šliapať po hadoch a škorpiónoch. Nebojte sa, nič vám nemôže ublížiť. ");
INSERT INTO slk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","No neradujte sa príliš z toho, že sa vám podrobujú mocnosti zla, radujte sa predovšetkým z toho, že vaše mená sú zapísané v nebesiach.“ ");
INSERT INTO slk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","V tej chvíli naplnil Duch Svätý Ježiša veľkou radosťou a povedal: „Velebím ťa, Otče, Pán neba aj zeme, že si schoval tieto pravdy pred vzdelanými a múdrymi tohto sveta a zjavil si ich tým, ktorí sú ako deti. Áno, ďakujem ti, Otče, lebo tak sa ti to páči.“ ");
INSERT INTO slk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ježiš potom povedal zástupu: „Môj Otec mi všetko zveril do rúk. Nik iný nevie, kým Syn skutočne je, okrem môjho Otca. Ani Otca nepozná nikto, iba Syn, a ten, komu sa to Syn rozhodne zjaviť.“ ");
INSERT INTO slk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Potom sa obrátil k svojim dvanástim učeníkom a povedal im: „Radujte sa, že všetko smiete vidieť na vlastné oči. ");
INSERT INTO slk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mnohí proroci a králi túžili vidieť, čo vy vidíte, ale nevideli; ako aj počuť, čo vy počujete, ale nepočuli.“ ");
INSERT INTO slk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jeden zo znalcov Zákona chcel vyskúšať Ježiša a spýtal sa ho: „Majstre, čo mám robiť, aby som zdedil večný život?“ ");
INSERT INTO slk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ježiš mu odpovedal otázkou: „Čo o tom hovorí Mojžišov zákon? Čo tam čítaš?“ ");
INSERT INTO slk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Znalec mu zacitoval slová zo Zákona: „Miluj Pána, svojho Boha, z celého srdca, z celej duše, celou silou i celou svojou mysľou a svojho blížneho miluj tak, ako miluješ seba samého!“ ");
INSERT INTO slk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Správne,“ povedal Ježiš. „Konaj tak a budeš žiť.“ ");
INSERT INTO slk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Keďže znalec podľa toho nežil, hľadal výhovorku, ktorou by ospravedlnil svoje konanie. Opýtal sa preto Ježiša: „Ale kto je môj blížny?“ ");
INSERT INTO slk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nato mu Ježiš vyrozprával tento príbeh: „Istý muž sa uberal z Jeruzalema dolu do Jericha. Cestou ho prepadli banditi, ukradli mu šaty aj peniaze, zbili ho a polomŕtveho nechali ležať pri ceste. ");
INSERT INTO slk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Náhodou šiel tadiaľ kňaz, ale keď ho videl, radšej ho obišiel. ");
INSERT INTO slk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Potom šiel tadiaľ aj nejaký Levita. Ale keď zbadal toho muža, aj on radšej prešiel na druhú stranu cesty. ");
INSERT INTO slk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Napokon šiel po tej ceste aj Samaritán. Keď videl zraneného, prišlo mu ho nesmierne ľúto. ");
INSERT INTO slk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pristúpil k nemu, ošetril mu rany olejom a vínom, obviazal mu ich, vysadil na svojho oslíka, zaviezol do hostinca a tam sa oňho staral. ");
INSERT INTO slk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na druhý deň dal hostinskému dva denáre a poprosil ho: ‚Postaraj sa oňho, a ak ťa to bude stáť viac, doplatím ti, keď sa budem vracať.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","„Čo myslíš,“ spýtal sa Ježiš, „ktorý z tých troch mužov bol skutočným blížnym tomu úbožiakovi, čo ho prepadli banditi?“ ");
INSERT INTO slk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Znalec odpovedal: „Ten, čo mu pomohol.“ „Tak teraz choď a konaj podobne,“ povedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ježiš s učeníkmi pokračovali v ceste do Jeruzalema. V jednej dedine ho pozvala do svojho domu žena, ktorá sa volala Marta. ");
INSERT INTO slk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jej sestra Mária si sadla na zem a pozorne počúvala Ježišove slová. ");
INSERT INTO slk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta mala zatiaľ plné ruky práce s prípravou pohostenia. O chvíľu prišla k Ježišovi a vyčítavo mu povedala: „Pane, nezdá sa ti to nesprávne, že moja sestra si tu nečinne sedí a všetku prácu necháva na mňa? Povedz jej, aby mi pomohla!“ ");
INSERT INTO slk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ale Ježiš jej povedal: „Marta, Marta, trápiš sa a znepokojuješ pre mnohé nepodstatné veci. ");
INSERT INTO slk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A pritom len jedno je potrebné. Mária si zvolila správne, vybrala si to, čo jej nikto nevezme.“ ");
INSERT INTO slk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Raz sa Ježiš opäť modlil v ústraní. Keď skončil, poprosil ho jeden z učeníkov: „Pane, nauč nás, ako sa máme modliť. Veď aj Ján to učil svojich učeníkov.“ ");
INSERT INTO slk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ježiš mu povedal: „Keď sa modlíte, hovorte: ‚Otče, nech je vzdaná úcta a česť tvojmu menu. Nech príde tvoje kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dávaj nám chlieb na každý deň ");
INSERT INTO slk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","a odpusť nám naše viny, ako aj my odpúšťame každému, kto sa previňuje voči nám. A nedovoľ, aby sme podľahli pokušeniu.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Potom ešte doložil: „Predstavte si, že niekto z vás má priateľa a o polnoci zaklope uňho so žiadosťou: ‚Prosím ťa, požičaj mi tri chleby. ");
INSERT INTO slk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Dostal som nečakanú návštevu a nemám ju čím pohostiť.‘ ");
INSERT INTO slk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Priateľ neotvorí a namrzene odpovie: ‚Daj mi pokoj! Nevidíš, že je už zamknuté? Všetci sme už v posteli a deti spia. Nebudem predsa vstávať, aby som ti dal chlieb.‘ ");
INSERT INTO slk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Poviem vám: aj keď najprv odmietne vstať, hoci je to jeho priateľ, napokon mu predsa vyhovie, lebo sa nedal odbiť a naliehavo prosil. ");
INSERT INTO slk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Preto vám hovorím: Proste a dostanete, hľadajte a nájdete, klopte a otvorí sa vám! ");
INSERT INTO slk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lebo kto prosí, dostane, kto hľadá, nájde, a kto klope, tomu otvoria. ");
INSERT INTO slk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Je azda medzi vami taký otec, ktorý by dal svojmu synovi kameň, keby prosil o chlieb, alebo by mu dal hada, keby prosil o rybu? ");
INSERT INTO slk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Alebo by mu dal škorpióna namiesto vajca? ");
INSERT INTO slk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ak teda vy, hoci ste zlí, viete dávať svojim deťom dobré dary, o čo skôr dá váš nebeský Otec Svätého Ducha tým, čo ho o to prosia.“ ");
INSERT INTO slk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Raz Ježiš vyhnal zlého ducha z nemého človeka. Keď ľudia počuli, že nemý hovorí, čudovali sa. ");
INSERT INTO slk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Niektorí však namietali: „To mu Belzebul, knieža démonov, prepožičal moc, preto ho zlí duchovia poslúchajú.“ ");
INSERT INTO slk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iní pochybovačne žiadali, aby urobil znamenie z neba, ktorým by potvrdil, že ho poslal Boh. ");
INSERT INTO slk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ale on poznal ich myšlienky, a preto povedal: „Kráľovstvu, ktoré je vnútorne rozdelené, a v ktorom ľudia proti sebe bojujú, hrozí zánik. A podobne rodine, v ktorej vládne zvada a hádky. ");
INSERT INTO slk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ak by teda satan bojoval sám proti sebe, ako môže obstáť jeho kráľovstvo? ");
INSERT INTO slk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ak som ja dostal moc od Belzebula, od koho ju dostali vaši žiaci? Veď tiež vyháňajú démonov! Oni sami dokážu, že sa mýlite. ");
INSERT INTO slk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ale ak vyháňam démonov Božou mocou, to je dôkaz, že k vám prišlo Božie kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ak svoj dom stráži silný, dobre ozbrojený muž, nemusí sa báť o svoj majetok. ");
INSERT INTO slk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ale ak ho napadne niekto silnejší a premôže ho, odníme mu zbraň, na ktorú sa spoliehal a zmocní sa jeho majetku. ");
INSERT INTO slk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kto nie je so mnou, je proti mne, a kto nezhromažďuje so mnou, rozptyľuje.“ ");
INSERT INTO slk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","„Keď je z človeka vyhnaný nečistý duch, blúdi po suchých, vyprahnutých miestach a hľadá, kam by sa utiahol. Ak také miesto nenájde, povie si: ‚Vrátim sa, odkiaľ som vyšiel.‘ ");
INSERT INTO slk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Keď sa tam vráti, zistí, že jeho príbytok je uprataný a vyzdobený. ");
INSERT INTO slk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ide teda, nájde sedem iných duchov, horších, ako je sám, vojdú dnu a usídlia sa tam. Taký človek je na tom horšie ako predtým.“ ");
INSERT INTO slk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pri tých slovách akási žena zo zástupu nahlas zvolala: „Šťastná je žena, ktorá ťa porodila a odchovala!“ ");
INSERT INTO slk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ježiš jej však na to povedal: „Ešte šťastnejší sú tí, ktorí počujú Božie slovo a žijú podľa neho.“ ");
INSERT INTO slk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Obklopoval ho čoraz väčší zástup a tak začal kázať: „Len bezbožní ľudia si vyžadujú zázračné dôkazy, že ma poslal Boh. Ale nedostanú iné znamenie, iba znamenie Jonášovo. ");
INSERT INTO slk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tak ako bol Jonáš znamením pre obyvateľov Ninive, tak bude aj Syn človeka znamením tomuto ľudu. ");
INSERT INTO slk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kráľovná z juhu vystúpi na súde a odsúdi týchto ľudí, lebo sama neváhala podniknúť dlhú cestu, aby poznala Šalamúnovu múdrosť, a tu je predsa niekto omnoho väčší ako Šalamún. ");
INSERT INTO slk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A podobne aj obyvatelia Ninive vystúpia na súde proti takýmto ľuďom a odsúdia ich, lebo oni oľutovali svoje činy, keď počúvali Jonáša, a tu je predsa niekto väčší, ako bol Jonáš.“ ");
INSERT INTO slk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","„Nikto predsa nerozsvieti lampu, aby ju prikryl nádobou alebo strčil pod posteľ, ale postaví ju na stôl, aby svietila všetkým v dome. ");
INSERT INTO slk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oči sú pre teba ako lampa, ktorá dáva svetlo. Ak je tvoje oko čisté, tvoj život bude naplnený svetlom, ale ak sa zakalí, bude aj celé tvoje telo v tme. ");
INSERT INTO slk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dbaj teda, aby nič nebránilo prenikaniu svetla, a aby ničím nebolo zatienené. Ak bude tvoje vnútro naplnené svetlom a nebude v tebe nijaký tmavý kút, ");
INSERT INTO slk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","vtedy aj celý tvoj život bude plný svetla, akoby ťa svetlo prežiarilo svojím jasom.“ ");
INSERT INTO slk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Keď dohovoril, pozval ho jeden z farizejov k sebe na obed. Ježiš prišiel a sadol si za stôl. ");
INSERT INTO slk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Vynechal obradné umývanie rúk pred jedlom, čo farizeja nemilo prekvapilo. ");
INSERT INTO slk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ježiš mu povedal: „Vy farizeji umývate všetko iba zvonka, ale na vnútro nedbáte, vnútri ste plní chamtivosti a zloby. ");
INSERT INTO slk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Zaslepenci! Či ten, ktorý stvoril vonkajšok, nestvoril aj to, čo je vo vnútri? ");
INSERT INTO slk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Či štedrosť nie je najlepším dôkazom vašej čistoty? ");
INSERT INTO slk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Beda vám, farizeji, ktorí starostlivo dbáte, aby ste dávali desiatu čiastku z mäty, ruty či iných bylín, ale zabúdate na spravodlivosť a lásku, ktorú žiada Boh. Na tom vám malo záležať, desiatky sú samozrejmosťou. ");
INSERT INTO slk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Beda vám, farizeji! Radi vyhľadávate čestné miesta v synagógach a vyžadujete, aby vás ľudia na ulici úctivo zdravili. ");
INSERT INTO slk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Beda vám! Ste ako zabudnuté hroby, po ktorých ľudia chodia a nevedia, aká nečistota sa v nich skrýva.“ ");
INSERT INTO slk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nato mu jeden z učiteľov Zákona povedal: „Učiteľ, to, čo hovoríš, nás uráža!“ ");
INSERT INTO slk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ježiš mu na to povedal: „Beda aj vám, učiteľom Zákona! Uvaľujete na ľudí bremená, ktoré nevládzu uniesť, ale sami pre nich nie ste ochotní ani len prstom pohnúť, aby ste im pomohli. ");
INSERT INTO slk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Beda vám! Staviate pomníky prorokom, ktorých zabili vaši otcovia. ");
INSERT INTO slk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nijako sa od svojich predkov nelíšite – čo hovoria proroci vás nezaujíma. ");
INSERT INTO slk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Boh vo svojej prozreteľnosti povedal: ‚Pošlem k nim prorokov a poslov, ale oni niektorých zabijú a ostatných budú prenasledovať.‘ ");
INSERT INTO slk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Preto na vašu hlavu padne vina za preliatu krv všetkých božích mužov ");
INSERT INTO slk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","od Ábela až po Zachariáša, ktorý zahynul medzi oltárom a svätyňou. Hovorím vám, že aj vy budete braní na zodpovednosť za to, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Beda vám, učitelia Zákona! Privlastnili ste si kľúč, ktorým sa dajú otvoriť dvere pravého poznania. Sami ste nevošli, a tým, ktorí chceli vojsť, ste zabránili.“ ");
INSERT INTO slk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tieto slová strašne popudili farizejov a učiteľov Zákona, ");
INSERT INTO slk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","začali doňho dorážať a klásť mu zákerné otázky, aby ho mohli pre nejaký výrok obžalovať. ");
INSERT INTO slk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Medzitým sa okolo neho zhromaždili neprehľadné zástupy, dobre že sa navzájom nepošliapali. Ježiš však najprv prehovoril k svojim učeníkom: „Dajte si pozor na pokrytectvo farizejov. Je ako kvas, ktorý ľahko prenikne celým cestom. ");
INSERT INTO slk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nič sa nedá navždy zatajiť, aby sa raz neodhalilo, a nič nie je natoľko utajené, aby raz nevyšlo najavo. ");
INSERT INTO slk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Všetko, čo ste povedali potme, bude hovorené vo svetle. A čo ste si šepkali za zatvorenými dvermi, sa bude hlásať zo striech.“ ");
INSERT INTO slk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","„Vám, svojim priateľom, radím: Nebojte sa tých, ktorí vás môžu pripraviť o život, ale nič viac vám urobiť nemôžu. ");
INSERT INTO slk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Poviem vám, koho sa máte báť. Bojte sa toho, kto má moc zabiť aj uvrhnúť do pekla. Toho berte vážne! ");
INSERT INTO slk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Koľko stojí päť vrabcov? Pár halierov, nie viac. A pritom Boh nezabudne ani na jedného z nich. ");
INSERT INTO slk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aj vlasy na vašej hlave sú všetky zrátané. A preto sa nebojte, lebo máte v jeho očiach väčšiu cenu ako celý kŕdeľ vrabcov.“ ");
INSERT INTO slk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","„A ubezpečujem vás, že kto sa ku mne prizná pred ľuďmi, k tomu sa prizná aj Syn človeka pred Božími anjelmi. ");
INSERT INTO slk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ale kto mňa zaprie pred ľuďmi, toho zapriem pred anjelmi. ");
INSERT INTO slk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Každý, kto hovorí proti Synovi človeka, môže získať odpustenie. Ale tomu, kto sa rúha Svätému Duchu, tomu odpustené nebude. ");
INSERT INTO slk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Keď vás budú vypočúvať pred úradmi a súdmi, keď vás povedú do synagóg, netrápte sa, čo poviete na svoju obhajobu, ");
INSERT INTO slk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","lebo Duch Svätý vám v pravej chvíli ukáže, čo povedať.“ ");
INSERT INTO slk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ktosi zo zástupu ho poprosil: „Majstre, povedz môjmu bratovi, aby sa so mnou spravodlivo rozdelil o dedičstvo.“ ");
INSERT INTO slk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ježiš mu odpovedal: „Nie som tu nato, aby som vás delil alebo rozsudzoval vaše spory.“ ");
INSERT INTO slk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A všetkým povedal: „Varujte sa chamtivosti, lebo zmyslom života nie je hromadenie bohatstva.“ ");
INSERT INTO slk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A svoje slová doplnil týmto podobenstvom: „Jednému bohatému človeku polia tak zarodili, ");
INSERT INTO slk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","že nemal kde uskladniť úrodu. Rozmýšľal, čo urobiť, ");
INSERT INTO slk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","až napokon zvolal: ‚Už viem, čo urobím! Staré stodoly zbúram, postavím väčšie a všetky zásoby uložím do nich. ");
INSERT INTO slk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Potom si budem môcť povedať: Teraz máš zásoby na mnohé roky, užívaj si život, jedz, pi a zabávaj sa.‘ ");
INSERT INTO slk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Boh mu však povedal: ‚Blázon, už tejto noci umrieš, a komu zostane to, čo si si nahromadil?‘ ");
INSERT INTO slk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tak je to s každým, kto si hromadí majetky na zemi, ale nemá bohatstvo, ktoré má v Božích očiach skutočnú hodnotu.“ ");
INSERT INTO slk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Potom sa obrátil k svojim učeníkom a povedal im: „Netrápte sa o to, čo budete jesť a piť, aby ste žili, ani o to, do čoho zaodejete svoje telo. ");
INSERT INTO slk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Veď život je viac ako pokrm a telo je dôležitejšie ako šaty. ");
INSERT INTO slk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Všimnite si havrany! Nesejú, nežnú, nemajú stodoly a Boh ich živí. A vy máte predsa pre neho väčšiu cenu ako vtáci! ");
INSERT INTO slk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Je medzi vami niekto, kto by si vlastnou snahou dokázal čo i len o kúsok predĺžiť svoj život? ");
INSERT INTO slk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ak nedokážete ani to, prečo sa potom trápite o ostatné? ");
INSERT INTO slk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Všimnite si poľné kvetiny. Nepradú, netkajú, a predsa ani Šalamún v celom svojom kráľovskom majestáte nebol tak skvostne oblečený ako ktorákoľvek z nich. ");
INSERT INTO slk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Keď teda Boh tak krásne odieva kvety, ktoré dnes kvitnú a zajtra zhoria v ohni, či sa tým skôr nepostará o vás? To mu tak málo dôverujete? ");
INSERT INTO slk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","A tak sa toľko netrápte tým, čo budete jesť a piť. ");
INSERT INTO slk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Veď tým všetkým sa znepokojujú ľudia, ktorí nepoznajú Boha. Váš nebeský Otec však vie, že aj tieto veci potrebujete. ");
INSERT INTO slk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","No usilujte sa predovšetkým o Božie kráľovstvo, a on vám pridá všetko, čo budete potrebovať. ");
INSERT INTO slk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","A nebojte sa o budúcnosť, hoci je vás len hŕstka! Váš Otec vám chce darovať kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Predajte, čo máte a rozdajte tým, ktorí to potrebujú! Budete tak mať poklad v nebesiach, ktorý nijaký zlodej neukradne ani mole nerozožerú. ");
INSERT INTO slk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lebo kde je váš poklad, tam bude aj vaše srdce.“ ");
INSERT INTO slk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","„Buďte pripravení slúžiť a majte rozsvietené lampy. ");
INSERT INTO slk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Buďte ako sluhovia, ktorí čakajú na svojho pána: keď príde zo svadby, otvoria mu dvere hneď, ako zaklope. ");
INSERT INTO slk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Veľká radosť čaká tých, ktorí bdejú a čakajú na jeho návrat. On sám ich usadí za stôl, vezme si zásteru a bude ich obsluhovať. ");
INSERT INTO slk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Šťastní budú tí, ktorých Pán nájde bdieť, či príde zvečera, o polnoci alebo až na svitaní. ");
INSERT INTO slk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Uvedomte si, že keby pán domu vedel, kedy príde zlodej, zabránil by mu vlámať sa do svojho domu. ");
INSERT INTO slk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tak aj vy buďte pripravení na príchod Syna človeka. Príde vtedy, keď to budete najmenej čakať.“ ");
INSERT INTO slk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter sa ho spýtal: „Pane, toto podobenstvo vravíš len nám, alebo je určené všetkým?“ ");
INSERT INTO slk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ježiš odpovedal: „Ako sa správa verný a prezieravý správca, ktorého pán poveril, aby rozdeľoval pokrm ostatným pracovníkom? ");
INSERT INTO slk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ak sa pán vráti a zistí, že dobre koná svoju prácu, ");
INSERT INTO slk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","odmení ho a zverí mu do správy všetko, čo má. ");
INSERT INTO slk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ale beda správcovi, ktorý by si povedal: ‚Môj pán sa tak skoro nevráti‘, a začal by zle zaobchádzať s tými, ktorí mu boli zverení, sám by hodoval a opíjal sa. ");
INSERT INTO slk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jeho pán sa vráti nečakane v deň a hodinu, o ktorej to nečakal: vyženie ho a naloží s ním ako s neverným sluhom. ");
INSERT INTO slk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kruto ho potrestá, lebo vedel, čo má robiť, ale nerobil to. ");
INSERT INTO slk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","No sluha, ktorý nepozná vôľu svojho pána a vykoná niečo trestuhodné, dostane miernejší trest. Lebo kto mnoho dostal, od toho sa aj mnoho očakáva, a komu mnoho zverili, od toho sa bude aj mnoho požadovať.“ ");
INSERT INTO slk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","„Prišiel som zapáliť oheň na zemi: aký by som bol rád, keby už vzbĺkol. ");
INSERT INTO slk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Najprv však musím prejsť krstom utrpenia: ako mi je úzko, kým sa to stane! ");
INSERT INTO slk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Domnievate sa, že som prišiel darovať zemi pokoj? Nie, ľudia sa budú hádať a bojovať proti sebe. ");
INSERT INTO slk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Odteraz sa aj rodiny rozdelia: z piatich ľudí budú traja za mňa a dvaja proti mne, alebo naopak. ");
INSERT INTO slk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Otec bude proti synovi a syn proti otcovi; matka a dcéra budú proti sebe a nevesta proti svokre.“ ");
INSERT INTO slk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Potom sa obrátil k zástupom a povedal: „Keď vidíte, že sa na západe sťahujú mračná, hneď poviete, že bude pršať. A máte pravdu. ");
INSERT INTO slk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A keď začne fúkať južný vietor, poviete: ‚Dnes bude horúčava‘, a naozaj je horúco. ");
INSERT INTO slk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Úkazy na nebi a na zemi viete posúdiť? Pokrytci! Prečo potom nechcete vidieť znamenia týchto čias? ");
INSERT INTO slk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Prečo nie ste ochotní prijať, čo je pravda a konať podľa nej?“ ");
INSERT INTO slk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","„Ak ideš so svojím protivníkom na úrad, usiluj sa s nímvdohodnúť už cestou. Inak ťa zavlečie k sudcovi, sudca ťa vydá dozorcovi a dozorca ťa uvrhne do väzenia. ");
INSERT INTO slk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A nevyjdeš odtiaľ skôr, kým svoju dlžobu nezaplatíš do posledného haliera.“ ");
INSERT INTO slk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","V tom istom čase priniesli Ježišovi správu, že Pilát dal povraždiť niektorých Galilejčanov práve v čase, keď prinášali svoje obete. ");
INSERT INTO slk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ježiš im na to povedal: „Môžete si myslieť, že títo Galilejčania boli väčší hriešnici ako ostatní z Galiley, a preto ich stihol takýto osud, ");
INSERT INTO slk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ale nie je to tak. Ak však neoľutujete svoje hriechy, aj vy zahyniete. ");
INSERT INTO slk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Alebo si myslíte, že tí osemnásti nešťastníci, na ktorých sa zrútila veža v Siloe, boli najväčšími hriešnikmi v Jeruzaleme? ");
INSERT INTO slk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Vôbec nie! Ak však neoľutujete svoje hriechy, aj vy zahyniete.“ ");
INSERT INTO slk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Potom im porozprával toto podobenstvo: „Istý človek mal vo svojej vinici figovník. Keď však prišiel pooberať ovocie, nič na ňom nenašiel. ");
INSERT INTO slk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Povedal záhradníkovi: ‚Pozri, už tretí rok čakám, že sa na ňom niečo urodí, ale márne. Vytni ho, lebo tu iba prekáža!‘ ");
INSERT INTO slk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ale záhradník sa prihováral: ‚Pane, nechaj ho ešte jeden rok! Okopem ho, pohnojím, ");
INSERT INTO slk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","a ak ani na budúci rok neprinesie ovocie, potom ho vytni.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","V jednu sobotu Ježiš opäť učil v synagóge. ");
INSERT INTO slk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bola tam žena, ktorá už osemnásť rokov trpela ťažkou chorobou: celá bola zohnutá a nemohla sa vystrieť. ");
INSERT INTO slk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Keď ju Ježiš videl, zavolal ju k sebe a povedal: „Žena, tvoje trápenie skončilo.“ ");
INSERT INTO slk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Položil na ňu ruky a v tej chvíli sa žena narovnala a oslavovala Boha. ");
INSERT INTO slk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ale predstaveného synagógy pobúrilo, že Ježiš uzdravuje v sobotu. Preto sa obrátil k ľuďom v synagóge a napomenul ich: „Šesť dní sa má pracovať. Vtedy prichádzajte a dajte sa uzdravovať, nie v sobotu.“ ");
INSERT INTO slk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ježiš jemu i ostatným, čo zmýšľali podobne povedal: „Pokrytci! Či vy nepracujete v sobotu? Či každý z vás neodväzuje v sobotu vola alebo osla a nevedie ho napojiť? ");
INSERT INTO slk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A vy si myslíte, že je to hriech, ak som túto ženu, ktorá je potomkom Abraháma, vyslobodil práve v sobotu? Veď ju satan držal vo svojich putách osemnásť rokov!“ ");
INSERT INTO slk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Táto odpoveď zahanbila Ježišových odporcov, ale celý zástup sa nadchýnal zázračnými činmi, ktoré Ježiš konal. ");
INSERT INTO slk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","„Ako vám ešte môžem priblížiť Božie kráľovstvo? K čomu ho mám prirovnať?“ spýtal sa Ježiš poslucháčov a pokračoval. ");
INSERT INTO slk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","„Je ako nepatrné horčičné semienko, ktoré si človek zaseje v záhrade. Semienko vyklíči a vyrastie z neho veľký strom, na ktorom môžu hniezdiť vtáci. ");
INSERT INTO slk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","K čomu ešte môžem pripodobniť Božie kráľovstvo? ");
INSERT INTO slk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Je ako kvások, ktorý žena vmiešala do troch meríc múky a celé cesto dobre vykyslo.“ ");
INSERT INTO slk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ježiš pokračoval na svojej ceste do Jeruzalema. Prechádzal mestami a dedinami a všade kázal. ");
INSERT INTO slk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ktosi sa ho spýtal: „Pane, naozaj je málo tých, ktorí budú zachránení?“ Ježiš mu odpovedal: ");
INSERT INTO slk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","„Dvere do neba sú úzke. Usilujte sa zo všetkých síl cez ne prejsť, lebo mnohí sa budú o to pokúšať, ale nedostanú sa dnu. ");
INSERT INTO slk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lebo len čo Pán domu príde, zamkne dvere a vy zostanete vonku. Mnohí budete búchať na dvere a volať: ‚Pane, Pane, otvor nám!‘ Pán vám však odpovie: ‚Neviem, kto ste ani odkiaľ ste!‘ ");
INSERT INTO slk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Vtedy sa začnete brániť: ‚Ale veď sme jedávali spolu a učil si na našich uliciach!‘ ");
INSERT INTO slk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","No on vám odpovie: ‚Nepoznám vás a neviem, odkiaľ ste prišli! Choďte odo mňa preč, lebo ste páchali zlé veci!‘ ");
INSERT INTO slk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Keď zostanete vonku a uvidíte, že Abrahám, Izák, Jákob a všetci proroci sú v Božom kráľovstve, budete zúfalo nariekať a škrípať zubami. ");
INSERT INTO slk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Zo všetkých svetových strán prídu ľudia, aby zaujali miesta pri stole v Božom kráľovstve. ");
INSERT INTO slk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A zapamätajte si: mnohí, ktorými dnes pohŕdajú, tam zaujmú popredné miesta a mnohí, ktorí sú dnes zahŕňaní priazňou a úctou, tam budú medzi poslednými.“ ");
INSERT INTO slk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","V tej chvíli za ním prišli niektorí farizeji a varovali ho: „Mal by si odtiaľto utiecť, lebo Herodes ťa chce zabiť.“ ");
INSERT INTO slk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Odpovedal im: „Choďte a povedzte tomu lišiakovi, že v tieto dni budem vyháňať démonov a uzdravovať chorých, ale čoskoro dôjdem do svojho cieľa! ");
INSERT INTO slk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Čokoľvek sa stane, musím ísť svojou cestou. Veď nie je možné, aby prorok zahynul inde ako v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzalem, Jeruzalem! Zabíjaš prorokov a kameňuješ tých, ktorých Boh posiela, aby ti pomohli. Koľko ráz som chcel zhromaždiť tvoje deti, ako sliepka zhromažďuje kuriatka pod ochranné krídla, ale nechceli ste. ");
INSERT INTO slk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Odteraz bude váš dom pustý. A neuvidíte ma skôr, ako budete volať: ‚Nech je požehnaný ten, ktorý prichádza v Božom mene!‘ “ ");
INSERT INTO slk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Raz v sobotu istý popredný farizej pozval Ježiša do svojho domu na obed. Všetci farizeji napäto striehli, čo Ježiš urobí. ");
INSERT INTO slk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bol tam totiž aj človek chorý na vodnatieľku. Ježiš sa na neho zadíval, ");
INSERT INTO slk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","a potom sa obrátil na farizejov a učiteľov Zákona s otázkou: „Dovoľuje zákon v sobotu uzdraviť človeka, alebo nie?“ ");
INSERT INTO slk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Oni však mlčali. Ježiš teda vzal chorého za ruku, uzdravil ho a poslal domov. ");
INSERT INTO slk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Farizejom a učiteľom zákona povedal: „Ak niekomu z vás spadne do nádrže s vodou syn alebo vôl, nevytiahnete ho z nej hneď v sobotu?“ ");
INSERT INTO slk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na to mu však nemali čo povedať. ");
INSERT INTO slk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Keď si všimol, ako sa niektorí hostia usilujú zaujať popredné miesta pri stole, povedal im takéto podobenstvo: ");
INSERT INTO slk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Ak ťa niekto pozve na svadbu, nesadaj si na predné miesto. Mohlo by sa totiž stať, že príde niekto váženejší ako ty ");
INSERT INTO slk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","a hostiteľ by prišiel za tebou a vyzval ťa: ‚Uvoľni miesto tomuto človeku!‘ A tebe by zostalo už len podradné miesto na konci stola. ");
INSERT INTO slk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Naopak, ak ťa pozvú, sadni si celkom dozadu. Keď ťa hostiteľ uvidí, príde a povie: ‚Poď, priateľ môj, presadni si dopredu!‘ A to ťa pozdvihne v očiach ostatných hostí. ");
INSERT INTO slk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lebo ten, kto sa povyšuje, bude ponížený a ten, kto sa ponižuje, bude povýšený.“ ");
INSERT INTO slk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A hostiteľovi povedal: „Keď usporadúvaš obed alebo večeru, nepozývaj svojich priateľov, bratov, príbuzných či bohatých susedov. Veď títo ľudia ti môžu tvoje pozvanie oplatiť. ");
INSERT INTO slk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Radšej pozvi na hostinu chudobných, zmrzačených, chromých a slepých. ");
INSERT INTO slk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tí sa ti nemajú čím odmeniť, ale ty budeš mať v srdci radosť. A pri vzkriesení spravodlivých ťa Boh za to odmení.“ ");
INSERT INTO slk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jeden z hostí, čo sedel pri stole s Ježišom, zvolal: „Aké to bude šťastie pre každého, kto bude pozvaný k stolu v Božom kráľovstve!“ ");
INSERT INTO slk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na to mu Ježiš odpovedal týmto podobenstvom: „Istý muž chystal veľkú hostinu a pozval na ňu mnoho ľudí. ");
INSERT INTO slk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Keď sa priblížil ten slávnostný deň, poslal svojho sluhu k pozvaným s odkazom: ‚Príďte, všetko je už pripravené!‘ ");
INSERT INTO slk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ale oni sa začali svorne vyhovárať. Jeden povedal: ‚Kúpil som pole a potrebujem si ho ísť obhliadnuť. Ospravedlň ma, prosím.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Druhý sa vyhovoril: ‚Žiaľ, nemôžem prísť. Kúpil som päť párov volov a musím ich vyskúšať. Ospravedlň ma, prosím.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ďalší povedal: ‚Práve som sa oženil; nemôžem prísť.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Keď sa sluha vrátil a všetko rozpovedal pánovi, ten sa rozhneval a prikázal mu: ‚Choď rýchlo do ulíc a na námestia a pozvi sem chudobných, zmrzačených, slepých a chromých.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sluha sa vrátil a povedal: ‚Splnil som tvoj príkaz, ale ešte ostalo dosť miesta.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tu mu pán prikázal: ‚Choď na poľné cesty a medzi ohrady a každého, koho stretneš, pozvi tak, aby prišli a naplnili môj dom. ");
INSERT INTO slk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A buďte si istí, že ani jeden z tých, čo boli pozvaní, neokúsi nič z mojej hostiny.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Za Ježišom šli obrovské zástupy. On sa k nim obrátil a povedal: ");
INSERT INTO slk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kto ma chce nasledovať, musí ma mať radšej ako svojho otca a matku, ako svoju ženu či deti, bratov a sestry, ba väčšmi ako sám seba, inak nemôže byť mojím učeníkom. ");
INSERT INTO slk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kto nie je ochotný znášať utrpenie a ťažkosti, ktoré mu nastanú, keď ma bude nasledovať, nemôže byť mojím učeníkom. ");
INSERT INTO slk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kto chce stavať dom, musí si najprv urobiť rozpočet a odhadnúť, či bude mať dosť prostriedkov na jeho dokončenie. ");
INSERT INTO slk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inak, ak postaví iba základy a stavbu nedokončí, všetci sa mu budú vysmievať: ");
INSERT INTO slk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‚Pozrite, to je ten, čo začal stavať, ale nedokončil, lebo na to nemal.‘ ");
INSERT INTO slk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Alebo ak niektorému kráľovi hrozí vojna, či najprv nezvolá vojenskú radu a neporadí sa, či môže so svojimi desiatimi tisícami vojakov čeliť dvadsiatim tisícom? ");
INSERT INTO slk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ak sa ukáže, že nie, či nepošle svojich poslov vyjednávať o mier skôr, ako ho nepriateľ napadne? ");
INSERT INTO slk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","A podobne je to aj s vami: nikto z vás sa nemôže stať mojím učeníkom, ak sa nevzdá všetkého, čo má.“ ");
INSERT INTO slk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Potom Ježiš pokračoval: „Soľ je užitočná vec. Ale ak stratí svoju chuť, čo jej vráti slanosť? ");
INSERT INTO slk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nie je z nej žiadny úžitok a ľudia ju vyhodia. Kto má uši na počúvanie, nech počúva.“ ");
INSERT INTO slk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Do Ježišovej blízkosti často prichádzali výbercovia daní a ľudia zlej povesti, aby ho počúvali. ");
INSERT INTO slk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizeji a učitelia Zákona sa nad tým pohoršovali a vraveli: „S takou zberbou sa priatelí a sedáva s nimi za jedným stolom!“ ");
INSERT INTO slk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ježiš im na to odpovedal podobenstvom: ");
INSERT INTO slk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Keby niekto z vás mal sto oviec a jedna z nich by sa mu stratila, nepokúsil by sa ju nájsť? Nechá tých deväťdesiatdeväť pásť sa a pôjde hľadať tú stratenú, kým ju nenájde. ");
INSERT INTO slk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A keď ju nájde, vyloží si ju na plecia ");
INSERT INTO slk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a radostne ju ponesie domov. Zavolá svojich priateľov i susedov a povie im: ‚Radujte sa so mnou, lebo som našiel svoju stratenú ovečku!‘ ");
INSERT INTO slk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Buďte si istí, že v nebi bude ešte väčšia radosť nad jedným hriešnikom, ktorý oľutuje svoje hriechy a obráti sa k Bohu, ako nad deväťdesiatimi deviatimi, ktorí si myslia, že je s nimi všetko v poriadku a nič ľutovať nemusia.“ ");
INSERT INTO slk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","„Alebo si predstavte ženu, ktorá má desať strieborných mincí a jedna sa jej doma niekde zakotúľa. Či nerozsvieti svetlo, nepovymetá všetky kúty a nebude hľadať dovtedy, kým ju nenájde? ");
INSERT INTO slk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A keď ju nájde, určite zavolá všetky svoje susedky a priateľky a povie im: ‚Radujte sa so mnou, lebo som našla svoju stratenú mincu!‘ ");
INSERT INTO slk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A takú radosť majú aj anjeli v nebi nad jedným hriešnikom, ktorý oľutuje svoje hriechy.“ ");
INSERT INTO slk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Potom Ježiš pokračoval ďalším podobenstvom: „Istý muž mal dvoch synov. ");
INSERT INTO slk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mladší prišiel za otcom a povedal: ‚Otec, daj mi už teraz podiel z dedičstva, ktoré nám mieniš raz zanechať.‘ A tak otec rozdelil svoj majetok medzi oboch synov. ");
INSERT INTO slk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","O niekoľko dní predal mladší syn svoj podiel a pobral sa z domu do ďalekej krajiny. Tam prehýril všetok svoj majetok. ");
INSERT INTO slk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Keď všetko premrhal, vypukol v tej krajine hlad a on takmer nemal čo do úst. ");
INSERT INTO slk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Šiel teda a začal pracovať u jedného obyvateľa tej krajiny. Ten ho poslal na svoje pole pásť svine. ");
INSERT INTO slk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Túžil sa najesť aspoň strukov, ktorými kŕmili svine, ale ani tých sa mu nedostalo. ");
INSERT INTO slk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Napokon vstúpil do seba a povedal si: U môjho otca ešte aj robotníci majú chleba nazvyš a ja tu umieram od hladu. ");
INSERT INTO slk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vrátim sa domov a poviem otcovi: ‚Otec, previnil som sa voči nebu aj voči tebe ");
INSERT INTO slk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","a dobre viem, že si nezaslúžim, aby si ma ešte nazýval svojím synom. Ale dovoľ mi, aby som u teba mohol pracovať aspoň ako robotník.‘ ");
INSERT INTO slk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A tak sa pobral domov. Otec ho zbadal už z diaľky a naplnený súcitom mu vybehol oproti, objal ho a vybozkával. ");
INSERT INTO slk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‚Otec môj‘, povedal syn, ‚previnil som sa voči nebu aj voči tebe, nezaslúžim si, aby som bol ešte tvojím synom.‘ ");
INSERT INTO slk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ale otec prikázal svojim sluhom: ‚Rýchlo prineste najkrajšie šaty a oblečte mu ich! Na prst mu dajte pečatný prsteň a obujte mu topánky! ");
INSERT INTO slk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Zarežte vykŕmené teľa a pripravte hostinu! Spoločne oslávime jeho návrat. ");
INSERT INTO slk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Veď je to, akoby bol umrel a zasa ožil; bol stratený a našiel sa.‘ A tak oslavovali jeho návrat. ");
INSERT INTO slk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Starší syn sa vracal z poľa a počul, ako sa z domu ozýva hudba a tanec. ");
INSERT INTO slk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zavolal si jedného sluhu a spýtal sa ho, čo sa deje. ");
INSERT INTO slk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sluha mu povedal: ‚Vrátil sa tvoj brat a tvoj otec od radosti, že sa vrátil živý a zdravý, dal zarezať vykŕmené teľa a pripraviť slávnostnú hostinu.‘ ");
INSERT INTO slk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Starší brat sa rozhneval a vôbec nechcel ísť dnu. Otec vyšiel von a prehováral ho. ");
INSERT INTO slk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ale syn mu vyčítal: ‚Toľké roky som pre teba drel, vo všetkom som ťa poslúchal, no nikdy si mi nedal ani len kozľa, aby som si pozval na hostinu svojich priateľov. ");
INSERT INTO slk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A teraz, keď sa vrátil tvoj miláčik, ktorý všetko prehýril s ľahkými ženami, dal si zarezať vykŕmené teľa a usporiadal si mu hostinu!‘ ");
INSERT INTO slk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‚Syn môj drahý‘, povedal mu otec, ‚ty si stále so mnou a všetko, čo mám, je tvoje. ");
INSERT INTO slk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ale teraz máme dôvod sa radovať. Veď tvoj brat bol mŕtvy a ožil, bol stratený a našiel sa.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Potom Ježiš porozprával učeníkom iný príbeh: „Jeden boháč mal správcu a toho obvinili, že zle hospodári so zvereným majetkom. ");
INSERT INTO slk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pán si ho dal zavolať a povedal mu: ‚Čo to o tebe počúvam? Predlož mi všetky účty, u mňa si ako správca skončil!‘ ");
INSERT INTO slk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Správca rozmýšľal: ‚Čo teraz? S lopatou robiť nevládzem a žobrať sa hanbím. ");
INSERT INTO slk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Už viem, čo urobím, aby ma ľudia prichýlili a postarali sa o mňa, keď prídem o prácu.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Zavolal si jedného po druhom dlžníkov svojho pána a spýtal sa prvého: ‚Koľko si dlžný môjmu pánovi?‘ ");
INSERT INTO slk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dlžník povedal: ‚Sto batov olivového oleja.‘ Správca ho vyzval: ‚Tu máš svoj dlžobný úpis, sadni si a napíš nový na päťdesiat.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Potom sa spýtal druhého dlžníka: ‚A ty si koľko dlžný?‘ Odpovedal: ‚Tisíc vriec pšenice.‘ Správca mu poradil: ‚Vezmi si dlžobný úpis a napíš nový na osemsto.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pán napokon prefíkaného správcu pochválil, že si počínal prezieravo. Treba priznať, že ľudia tohto sveta bývajú prezieravejší, keď im ide o zisk, ako veriaci. ");
INSERT INTO slk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Hovorím vám, že hoci sa peniaze dajú ľahko zneužiť, môžete nimi urobiť aj mnoho dobrého a pomôcť veľa ľuďom. Keď sa raz peniaze pominú, budete prijatí do večných príbytkov v nebesiach.“ ");
INSERT INTO slk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ježiš pokračoval: „Kto je verný v drobnostiach, je verný aj v podstatných veciach. A ten, kto je nespoľahlivý v maličkostiach, zlyháva aj v závažných veciach. ");
INSERT INTO slk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ak neviete tu na zemi správne zaobchádzať s majetkom, kto vám zverí pravé bohatstvo? ");
INSERT INTO slk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ak ste neboli verní v cudzom, kto vám dá, čo je vaše? ");
INSERT INTO slk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ani jeden sluha nemôže slúžiť dvom pánom. Lebo buď jedného bude nenávidieť a druhého milovať, alebo prvému dá prednosť a druhým bude pohŕdať. Nemôžete slúžiť Bohu i majetku.“ ");
INSERT INTO slk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Počuli to farizeji, ktorí sa pachtili za peniazmi, a vysmiali sa mu. ");
INSERT INTO slk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ale Ježiš im povedal: „V očiach ľudí sa snažíte vyzerať ako dobrí. Boh však pozná vaše srdce. On pohŕda tým, čo ľudia obdivujú a oceňujú. ");
INSERT INTO slk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Obdobie Zákona a prorokov sa skončilo Jánom Krstiteľom. Teraz počujete radostnú správu, že prišlo Božie kráľovstvo, a kdekto si robí nárok na vstup do neho. ");
INSERT INTO slk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ale nemýľte sa, skôr pominie nebo aj zem, ako by jediná čiarka z Božieho zákona stratila platnosť. ");
INSERT INTO slk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Napríklad, kto sa rozvádza so svojou ženou a berie si inú, previňuje sa proti prikázaniu ‚nescudzoložíš‘; a kto sa ožení s rozvedenou, takisto cudzoloží.“ ");
INSERT INTO slk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","„Bol raz jeden bohatý človek, ktorý sa honosne obliekal, každý deň hodoval a oddával sa pôžitkom. ");
INSERT INTO slk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pri bráne jeho domu líhal žobrák Lazár. Telo mal samý vred. ");
INSERT INTO slk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mal veľký hlad a túžil ho zahnať aspoň zvyškami z boháčovho stola. Neraz pribehli psy a oblizovali mu otvorené rany. ");
INSERT INTO slk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Keď Lazár zomrel, anjeli ho preniesli do Abrahámovej blízkosti. Krátko nato zomrel aj boháč. Pochovali ho a jeho duša sa dostala do ríše mŕtvych. ");
INSERT INTO slk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tam v mukách zdvihol oči a v diaľke zazrel Abraháma s Lazárom sedieť spolu pri stole. ");
INSERT INTO slk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‚Otec Abrahám, zmiluj sa nado mnou‘, zavolal. ‚Pošli Lazára, aby si omočil koniec prsta vo vode a zvlažil mi jazyk, lebo trpím v tomto plameni.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ale Abrahám mu odpovedal: ‚Synu, rozpomeň sa, že ty si žil na zemi v prepychu a hojnosti, no Lazár v biede a utrpení. Ale teraz sa on má dobre a ty trpíš. ");
INSERT INTO slk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Okrem toho nás delí obrovská priepasť, ktorú nik nemôže prekonať, aj keby chcel.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nato boháč povedal: ‚Tak ťa prosím, otec Abrahám, pošli ho aspoň k mojim piatim bratom, ");
INSERT INTO slk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nech ich varuje, aby sa aj oni nedostali na toto miesto utrpenia.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ale Abrahám mu odpovedal: ‚Majú predsa Písmo, môžu žiť podľa neho.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Boháč však namietal: ‚Nie, otec Abrahám, na Písmo oni nedajú, ale keby niekto vstal z mŕtvych, tomu by uverili a odvrátili sa od svojich hriechov.‘ ");
INSERT INTO slk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahám povedal: ‚Ak nedajú na Mojžišov zákon a prorokov, nedajú sa presvedčiť, ani keby niekto vstal z mŕtvych.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","„Pokušeniam sa na tomto svete vyhnúť nedá,“ povedal Ježiš jedného dňa svojim učeníkom, „beda však tomu, kto ich spôsobuje. ");
INSERT INTO slk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bolo by mu lepšie, keby mu dali na krk mlynský kameň a hodili ho do mora, než aby zviedol na zlé jedného z týchto maličkých. ");
INSERT INTO slk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dávajte si na to pozor!“ „Ak sa niekto voči tebe previní, pokarhaj ho, a ak to oľutuje, odpusť mu! ");
INSERT INTO slk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A keby sa to stalo aj sedem ráz za deň a zakaždým by prišiel za tebou s prosbou: ‚Prepáč mi prosím, mrzí ma to‘, zakaždým mu odpusť.“ ");
INSERT INTO slk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Učeníci povedali Pánovi: „Daj nám viac viery!“ ");
INSERT INTO slk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ježiš im odvetil: „Keby ste mali vieru aspoň ako horčičné semienko a povedali ste tejto moruši: ‚Vytrhni sa aj s koreňmi a zasaď sa do mora!‘ stalo by sa to.“ ");
INSERT INTO slk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","„Ak sa váš sluha vráti po celodennej práci z poľa, kde oral alebo pásol, vari mu poviete: ‚Poď, sadni si a najedz sa?‘ ");
INSERT INTO slk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nie je to skôr tak, že mu prikážete: ‚Priprav večeru a obsluhuj ma, kým sa ja nenajem a nenapijem; keď skončím, môžeš sa navečerať ty?‘ ");
INSERT INTO slk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bude azda pán ďakovať svojmu sluhovi za to, že urobil, čo mu prikázal? ");
INSERT INTO slk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Podobne je to aj s vami. Ak urobíte všetko, čo vám Boh ukladá, povedzte: ‚Nie sme výnimočný sluhovia. Vykonali sme iba to, čo bolo našou povinnosťou!‘ “ ");
INSERT INTO slk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cestou do Jeruzalema prechádzal Ježiš územím medzi Samáriou a Galileou. ");
INSERT INTO slk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Keď prichádzal k akejsi dedine, šlo mu oproti desať malomocných. Zastavili sa ");
INSERT INTO slk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a zďaleka naňho volali: „Ježišu, Majstre, zmiluj sa nad nami!“ ");
INSERT INTO slk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pozrel na nich a povedal: „Choďte a ukážte sa kňazom!“ Poslúchli a cestou boli zbavení svojej choroby. ");
INSERT INTO slk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jeden z nich, len čo zistil, že je zdravý, vrátil sa a nahlas chválil Boha. ");
INSERT INTO slk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Padol Ježišovi k nohám a z celého srdca mu ďakoval. Bol to Samaritán. ");
INSERT INTO slk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tu sa Ježiš spýtal: „Neuzdravil som vari desiatich? Kde je tých ostatných deväť? ");
INSERT INTO slk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Okrem tohto cudzinca sa nikto z nich nevrátil, aby sa poďakoval Bohu?“ ");
INSERT INTO slk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Samaritánovi povedal: „Vstaň, môžeš pokojne odísť. Tvoja viera ťa uzdravila.“ ");
INSERT INTO slk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jedného dňa sa farizeji pýtali Ježiša, kedy príde Božie kráľovstvo. Odpovedal im: „Kráľovstvo Božie neprichádza tak, aby ste to mohli spozorovať. ");
INSERT INTO slk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ani sa nedá povedať: ‚Je tu alebo tam.‘ Veď kráľovstvo Božie je už medzi vami!“ ");
INSERT INTO slk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Svojim učeníkom však povedal: „Príde čas, keď si budete túžobne želať, aby ste prežili aspoň jediný deň v kráľovstve Syna človeka. Ale táto túžba sa vám nesplní. ");
INSERT INTO slk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nedajte sa mýliť, keď vám budú hovoriť: ‚Kristus je tam‘, alebo: ‚Je tu!‘ Nikam nechoďte, nebežte za tými ľuďmi. ");
INSERT INTO slk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ako keď oslepujúci blesk pretne oblohu a ožiari celý obzor, taký jasný bude návrat Syna človeka. ");
INSERT INTO slk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Najprv však musí mnoho vytrpieť a táto neveriaca generácia ho zavrhne. ");
INSERT INTO slk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pri príchode Syna človeka bude život na zemi podobný ako za čias Noacha: ");
INSERT INTO slk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ľudia jedli, pili, ženili sa a vydávali až do dňa, keď Noe vošiel do korábu. Vtedy prišla potopa, v ktorej všetci zahynuli. Zachránil sa iba Noe so svojou rodinou. ");
INSERT INTO slk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Podobne to bolo za čias Lota: ľudia jedli, pili, kupovali, predávali, sadili a stavali ");
INSERT INTO slk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","až do dňa, keď Lot vyšiel zo Sodomy. Vtedy Boh zoslal oheň a síru z neba a všetkých zahubil. ");
INSERT INTO slk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tak to bude v deň, keď príde Syn človeka. ");
INSERT INTO slk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kto bude vtedy na streche domu, nech už nebeží dnu pre veci, ktoré tam má. Kto bude za mestom, nech sa nevracia späť. ");
INSERT INTO slk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Spomeňte si, čo sa stalo s Lotovou ženou. ");
INSERT INTO slk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Každý, kto by si chcel zachrániť život, stratí ho, ale kto stratí svoj život, ten ho zachová. ");
INSERT INTO slk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","V tú noc budú dvaja ležať v jednej posteli: jeden bude vzatý, druhý zostane. ");
INSERT INTO slk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dve ženy budú spolu mlieť: jedna bude vzatá, druhá zostane. ");
INSERT INTO slk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dvaja muži budú pracovať na poli: jeden bude vzatý, druhý zostane.“ ");
INSERT INTO slk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Učeníci sa ho spýtali: „Kde, Pane?“ Ježiš im odpovedal: „Kde je mŕtvola, tam sa zlietajú aj supy.“ ");
INSERT INTO slk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jedného dňa Ježiš vyrozprával učeníkom podobenstvo o tom, že Bohu treba neprestajne v dôvere predkladať svoje prosby a byť v tom vytrvalý. ");
INSERT INTO slk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","V ktoromsi meste bol sudca, ktorý nerešpektoval Boha a nezaujímal sa ani o ľudskú mienku. ");
INSERT INTO slk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","V tom meste žila aj istá vdova, ktorá za ním neustále chodila s prosbou: „Zastaň sa ma proti môjmu odporcovi!“ ");
INSERT INTO slk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sudca síce dlho odmietal, ale napokon si povedal: „Aj keď mi je naozaj jedno, čo hovorí Boh a ľudia ma tiež nezaujímajú, ");
INSERT INTO slk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pomôžem jej, lebo inak ma svojou neodbytnosťou celkom umorí.“ ");
INSERT INTO slk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A Ježiš dodal: „Vidíte, takej neodbytnej prosebníčke vyhovel aj nespravodlivý sudca! ");
INSERT INTO slk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ako by sa potom Boh nezastal svojich milovaných, ktorí k nemu volajú vo dne i v noci? Vari bude otáľať so svojou pomocou? ");
INSERT INTO slk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Uisťujem vás, že im pomôže čo najrýchlejšie. Otázkou je, či Syn človeka pri svojom návrate na zem nájde ľudí, ktorí mu budú dôverovať.“ ");
INSERT INTO slk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","O tých, ktorí si o sebe mysleli, že sú bez chyby, a ostatnými ľuďmi pohŕdali, porozprával Ježiš toto podobenstvo: ");
INSERT INTO slk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Dvaja muži prišli do chrámu, aby sa zhovárali s Bohom. Jeden z nich bol farizej a druhý colník. ");
INSERT INTO slk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizej sa postavil dopredu a takto sa modlil: ‚Ďakujem ti, Bože, že nie som taký chamtivec, nepoctivec alebo cudzoložník ako ostatní ľudia, a najmä, že nie som ako tento colník. ");
INSERT INTO slk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dva razy do týždňa sa postím a dávam desatinu zo všetkých svojich príjmov.‘ ");
INSERT INTO slk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Colník však stál celkom vzadu so sklonenou hlavou, ani len oči sa neodvážil zdvihnúť k nebu. Na znamenie ľútosti sa bil do pŕs a hovoril: ‚Bože, som hriešnik, prosím zľutuj sa nado mnou.‘ ");
INSERT INTO slk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Uisťujem vás, že ten, kto sa vrátil domov ospravedlnený, bol colník, nie farizej. Lebo každý, kto sa povyšuje, bude ponížený, a kto sa ponižuje, bude povýšený.“ ");
INSERT INTO slk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","K Ježišovi prinášali malé deti, aby im požehnal. Učeníci však proti tomu rázne zakročili. ");
INSERT INTO slk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ale Ježiš si zavolal deti k sebe a učeníkom povedal: „Nechajte deti prísť ku mne a nebráňte im v tom. lebo práve takým ako oni patrí Božie kráľovstvo. ");
INSERT INTO slk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Zapamätajte si, že kto nepríde k Bohu s detskou dôverou, do nebeského kráľovstva sa nedostane.“ ");
INSERT INTO slk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jeden zo židovských vodcov sa spýtal Ježiša: „Dobrý učiteľ, čo musím robiť, aby som získal večný život?“ ");
INSERT INTO slk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ježiš mu odpovedal: „Prečo ma nazývaš dobrým? Veď dobrý je iba Boh. ");
INSERT INTO slk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A poznáš predsa prikázania: Nescudzoložíš, Nezabiješ, Neukradneš, Nebudeš falošne svedčiť, Budeš si vážiť svojich rodičov.“ ");
INSERT INTO slk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Muž odpovedal: „Ale veď podľa týchto prikázaní žijem už od svojej mladosti.“ ");
INSERT INTO slk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ježiš mu povedal: „A predsa ti ešte niečo chýba. Predaj všetko, čo máš, rozdaj chudobným a budeš mať poklad v nebi. Potom príď a nasleduj ma.“ ");
INSERT INTO slk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Muž po týchto slovách zosmutnel, lebo bol veľmi bohatý. ");
INSERT INTO slk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Keď Ježiš videl jeho smútok, povedal: „Ako ťažko sa bohatým vstupuje do Božieho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","To skôr prejde ťava uchom ihly, ako boháč vojde do Božieho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tí, čo to počuli, zvolali: „Tak kto vlastne môže byť zachránený?“ ");
INSERT INTO slk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Odpovedal im: „Ľudia sa sami zachrániť nemôžu, to môže urobiť len Boh.“ ");
INSERT INTO slk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Vtom sa ozval Peter: „A ako je to s nami? My sme predsa nechali všetko a šli sme za tebou!“ ");
INSERT INTO slk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ježiš im na to odpovedal: „Buďte si istí, že každý, kto sa pre Božie kráľovstvo niečoho vzdal – domova, súrodencov, rodičov alebo detí – ");
INSERT INTO slk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dostane bohatú odmenu: už na tomto svete získa omnoho viac a v budúcom svete dostane večný život.“ ");
INSERT INTO slk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ježiš vzal so sebou dvanástich učeníkov a povedal im: „Ideme teraz do Jeruzalema a tam sa splní všetko, čo proroci predpovedali o Synovi človeka. ");
INSERT INTO slk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bude vydaný do rúk pohanov, budú sa mu posmievať, potupia ho a opľujú. ");
INSERT INTO slk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Potom ho zbičujú a zabijú, ale na tretí deň vstane z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Učeníci však nič z toho nepochopili a jeho slová pre nich ostali záhadou. ");
INSERT INTO slk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Keď sa blížili k Jerichu, sedel pri ceste jeden slepec a žobral. ");
INSERT INTO slk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Počul, že okolo prechádza množstvo ľudí, preto sa vypytoval, čo sa to deje. ");
INSERT INTO slk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Povedali mu: „Ide tadiaľto Ježiš z Nazareta.“ ");
INSERT INTO slk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Len čo to počul, zvolal: „Ježiš, Syn Dávidov, zmiluj sa nado mnou!“ ");
INSERT INTO slk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tí, čo šli vpredu, ho okrikovali, aby mlčal. On však volal ešte hlasnejšie: „Syn Dávidov, zmiluj sa nado mnou!“ ");
INSERT INTO slk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nato Ježiš zastal a kázal, aby ho k nemu priviedli. Keď slepý prišiel, Ježiš sa ho opýtal: ");
INSERT INTO slk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","„Čo chceš, aby som pre teba urobil?“ Muž mu odpovedal: „Pane, chcem opäť vidieť!“ ");
INSERT INTO slk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","„Dobre, nech sa ti vráti zrak! Tvoja viera ťa zachránila,“ povedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Od tej chvíle muž naozaj videl, šiel za Ježišom a chválil Boha. A všetci, ktorí boli toho svedkami, takisto zvelebovali Boha. ");
INSERT INTO slk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ježiš prišiel do Jericha a prechádzal mestom. ");
INSERT INTO slk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Istý muž zvaný Zachej, hlavný výberca daní a veľký boháč, ");
INSERT INTO slk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","zatúžil vidieť a spoznať Ježiša. Bol však nízkej postavy a pre veľký zástup, ktorý sa tlačil okolo Ježiša, ho nevidel. ");
INSERT INTO slk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Predbehol teda sprievod, vyškriabal sa na vysoký strom a odtiaľ ho pozoroval. ");
INSERT INTO slk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Keď Ježiš prišiel k stromu, pozrel sa hore a povedal: „Zachej, zlez rýchlo dolu! Dnes chcem byť tvojím hosťom.“ ");
INSERT INTO slk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zachej zišiel a s radosťou ho viedol do svojho domu. ");
INSERT INTO slk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ale všetci, ktorí to videli, začali reptať a pohoršovali sa: „Ide na návštevu k jednému z najväčších zdieračov.“ ");
INSERT INTO slk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Vtedy sa Zachej postavil tak, aby ho všetci videli a povedal Ježišovi: „Pane, polovicu svojho majetku rozdám chudobným, a ak som niekoho okradol, vrátim mu to štvornásobne.“ ");
INSERT INTO slk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ježiš mu povedal: „Dnes Boh zachránil túto rodinu. Ukázalo sa totiž, že aj tento človek nasleduje Abrahámov príklad viery. ");
INSERT INTO slk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lebo Syn človeka, prišiel hľadať a zachrániť stratených.“ ");
INSERT INTO slk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Keďže bol neďaleko Jeruzalema a mnohí sa domnievali, že Božie kráľovstvo sa čochvíľa stane viditeľným, vyrozprával im toto podobenstvo: ");
INSERT INTO slk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","„Jeden vznešený a bohatý muž odišiel do ďalekej krajiny, aby sa tam dal korunovať a vrátil sa späť ako kráľ. ");
INSERT INTO slk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pred svojím odchodom si zavolal desiatich sluhov, každému z nich zveril určitú sumu a povedal: ‚Kým sa vrátim, investujte tie peniaze tak, aby priniesli úžitok.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ale niektorí z jeho občanov ho nenávideli a poslali poslov s odkazom: ‚Nechceme, aby sa tento stal naším kráľom.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","No on sa po nejakom čase predsa vrátil ako kráľ a dal si predvolať sluhov, ktorým zveril peniaze. Chcel zistiť, ako s nimi hospodárili. ");
INSERT INTO slk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Prišiel prvý a povedal: ‚Pane, získal som desaťnásobne viac, ako bola pôvodná suma.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‚Výborne‘, pochválil ho kráľ. ‚Si dobrý hospodár. Keďže si verne zaobchádzal s tým málom, čo som ti zveril, za odmenu ťa menujem správcom nad desiatimi mestami.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Potom pristúpil ďalší sluha: ‚Pane, získal som päťnásobne viac, ako bola pôvodná suma.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aj toho pán pochválil a ustanovil ho správcom nad piatimi mestami. ");
INSERT INTO slk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nakoniec prišiel sluha, ktorý povedal: ‚Pozri, to je to, čo si mi zveril. Celý čas som to nosil pri sebe a ochraňoval, ");
INSERT INTO slk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","lebo som sa ťa bál. Si totiž prísny – žiadaš aj to, čo si nedal, a žneš, čo si nezasial.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tomu človeku kráľ povedal: ‚Tvoje vlastné slová ťa odsudzujú, ty zlý sluha! Vedel si, že som prísny človek, beriem, čo som nedal a žnem, čo som nezasial. ");
INSERT INTO slk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Prečo si moje peniaze aspoň nezveril správcom peňazí, aby priniesli nejaké úroky?‘ ");
INSERT INTO slk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Potom sa obrátil k tým, čo stáli okolo neho: ‚Vezmite mu tie peniaze a dajte tomu, čo získal najviac.‘ ");
INSERT INTO slk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Namietli: ‚Pane, ale veď on už má desať!‘ ");
INSERT INTO slk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kráľ však odpovedal: ‚Áno, ten, čo má, dostane ešte viac; a ten, čo nemá, príde aj o to, čo má. ");
INSERT INTO slk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A nepriateľov, ktorí ma nechceli za kráľa, priveďte sem a pred mojimi očami ich pobite.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Keď Ježiš dorozprával tento príbeh, pokračoval v ceste do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Neďaleko Betfage a Betánie pri Olivovom vrchu Ježiš vyzval svojich učeníkov: ");
INSERT INTO slk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","„Choďte do dedinky pred nami. Hneď na kraji uvidíte oslíka, na ktorom ešte nikto nejazdil. Odviažte ho a priveďte sem! ");
INSERT INTO slk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Keby sa vás niekto spýtal, prečo to robíte, odpovedzte: ‚Pán ho potrebuje.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Šli a našli všetko tak, ako im povedal. ");
INSERT INTO slk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Keď odväzovali osliatko, prišli majitelia a spýtali sa ich: „Prečo to osliatko odväzujete?“ ");
INSERT INTO slk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Odpovedali: „Pán ho potrebuje.“ ");
INSERT INTO slk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Potom osliatko priviedli k Ježišovi, prestreli mu na chrbát svoje plášte a pomohli Ježišovi vysadnúť. ");
INSERT INTO slk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A ľudia rozprestierali svoje plášte na cestu, po ktorej šiel. ");
INSERT INTO slk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Keď sa priblížil k Olivovému vrchu, začal zástup učeníkov nadšene a hlasno chváliť Boha za všetky zázraky, ktoré na vlastné oči videli. ");
INSERT INTO slk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Volali: „Nech Boh požehná kráľa, ktorý prichádza v jeho mene! Nech je pokoj medzi nebom a zemou! Sláva Bohu na výsostiach!“ ");
INSERT INTO slk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Vtedy mu niektorí farizeji zo zástupu dohovárali: „Napomeň svojich učeníkov!“ ");
INSERT INTO slk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ale Ježiš im odpovedal: „Ak by oni mlčali, budú kričať kamene popri ceste.“ ");
INSERT INTO slk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Keď už boli blízko a uvidel mesto, vstúpili mu do očí slzy a so smútkom povedal: ");
INSERT INTO slk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","„Keby ste aspoň dnes pochopili, čo vám môže priniesť pokoj! Ale vy nič nechápete. ");
INSERT INTO slk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Prídu dni, keď vás nepriatelia obkľúčia, oboženú valom a zovrú zo všetkých strán. ");
INSERT INTO slk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Napokon zrovnajú vaše mesto so zemou a tých, čo budú v ňom, pobijú. Nezostane tu kameň na kameni, pretože ste nespoznali čas, keď vám Boh priniesol záchranu.“ ");
INSERT INTO slk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ježiš vošiel do priestorov chrámu a začal odtiaľ vyháňať všetkých, ktorí tam obchodovali. ");
INSERT INTO slk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Povedal im: „Je napísané: ‚Môj chrám bude pre všetkých miestom modlitby‘, ale vy ste z neho urobili brloh lotrov!“ ");
INSERT INTO slk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ježiš potom deň čo deň vyučoval v chráme. Veľkňazi, učitelia Zákona i vodcovia ľudu ho chceli zabiť, ");
INSERT INTO slk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ale nevedeli, ako to urobiť, lebo ľudia ho dychtivo počúvali. ");
INSERT INTO slk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jedného dňa, keď Ježiš opäť učil ľud v chráme a hlásal radostnú zvesť, prišli za ním veľkňazi, učitelia Zákona a židovskí vodcovia ");
INSERT INTO slk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","s otázkou: „Povedz nám, akým právom robíš to, čo robíš? Kto ťa tým poveril?“ ");
INSERT INTO slk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","„Aj ja mám pre vás otázku: ");
INSERT INTO slk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Keď Ján krstil, od koho mal poverenie? Od Boha alebo od ľudí?“ ");
INSERT INTO slk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Začali sa medzi sebou dohadovať: „Ak povieme že ho poslal Boh, spýta sa nás, prečo sme mu neuverili. ");
INSERT INTO slk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ak však povieme, že ľudia, mohol by nás dav ukameňovať, lebo verí, že Ján bol prorok.“ ");
INSERT INTO slk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Napokon mu odpovedali: „Nevieme, kto poslal Jána.“ ");
INSERT INTO slk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ježiš im na to povedal: „Ani ja vám nepoviem, kto mi dal moc konať to, čo konám.“ ");
INSERT INTO slk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Potom sa znova obrátil k zástupu a povedal im toto podobenstvo: „Istý človek vysadil vinicu, prenajal ju vinohradníkom a na dlhý čas odcestoval. ");
INSERT INTO slk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Keď nastal čas oberačky, poslal k vinohradníkom svojho sluhu, aby mu odovzdali podiel z úrody. Ale vinohradníci ho zbili a poslali naspäť s prázdnymi rukami. ");
INSERT INTO slk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Poslal k nim iného sluhu, ale aj toho zbili, potupili ho a nič mu nedali. ");
INSERT INTO slk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nato poslal aj tretieho sluhu, ale stihol ho ten istý osud: do krvi ho zbili a vyhnali. ");
INSERT INTO slk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‚Čo mám robiť?‘ spytoval sa majiteľ vinice v duchu. ‚Pošlem k nim svojho milovaného syna, pred ním určite budú mať rešpekt.‘ ");
INSERT INTO slk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ale keď vinohradníci zazreli majiteľovho syna, zosnovali takýto plán: ‚Toto je dedič, zabijeme ho a vinica bude naša.‘ ");
INSERT INTO slk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Vyvliekli ho teda z vinice a zabili. ");
INSERT INTO slk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Čo myslíte, čo urobí majiteľ vinice, keď sa to dozvie? Príde, dá ich pozabíjať a vinicu prenajme iným.“ Tí, čo ho počúvali, odpovedali: „To nech sa nikdy nestane!“ ");
INSERT INTO slk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ježiš sa na nich zahľadel a povedal: „Čo teda znamenajú slová Písma: ‚Kameň, ktorý stavitelia odhodili ako nepotrebný, stal sa kameňom základným, najdôležitejším v celej stavbe?‘ “ ");
INSERT INTO slk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A doložil: „Každý, kto spadne na ten kameň, doláme sa, ale na koho spadne, toho rozdrví.“ ");
INSERT INTO slk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Veľkňazi a učitelia Zákona ho chceli hneď zatknúť, lebo si uvedomovali, že to podobenstvo bolo o nich. Báli sa však ľudí. ");
INSERT INTO slk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Židovský vodcovia Ježiša urputne sledovali. Poslali za ním špehov, ktorí sa vydávali za spravodlivých ľudí. Ich úlohou bolo Ježiša pri rozhovore chytiť do pasce, aby ho mohli obžalovať a vydať do rúk rímskemu miestodržiteľovi. ");
INSERT INTO slk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tí Ježišovi povedali: „Majstre, poznáme ťa ako dobrého učiteľa, ktorý sa vo svojich názoroch nedá nikým ovplyvniť. Učíš ľudí pravej ceste k Bohu. ");
INSERT INTO slk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Povedz nám teda: je správne platiť cisárovi dane, alebo nie?“ ");
INSERT INTO slk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ježiš postrehol ich lesť, preto im povedal: ");
INSERT INTO slk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Ukážte mi mincu! Čí obraz a meno je na nej?“ Odpovedali mu: „Cisárove.“ ");
INSERT INTO slk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nato im Ježiš povedal: „Dávajte teda cisárovi, čo je cisárovo, a Bohu, čo je Božie.“ ");
INSERT INTO slk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Zmĺkli, ohromení jeho odpoveďou a zostali zarazení, lebo sa im nepodarilo prichytiť ho v reči. ");
INSERT INTO slk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Potom za ním prišli aj saduceji, ktorí popierajú zmŕtvychvstanie, a povedali mu: ");
INSERT INTO slk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Majstre, v Mojžišovom zákone je napísané, že ak zomrie muž, ktorého manželstvo bolo bezdetné, jeho brat je povinný oženiť sa s vdovou a splodiť bratovi potomka, aby sa zachoval jeho rod. ");
INSERT INTO slk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bolo raz sedem bratov. Najstarší sa oženil a zomrel bez potomka. ");
INSERT INTO slk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Vdovu si vzal druhý brat a tiež zomrel bez detí. ");
INSERT INTO slk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","To sa opakovalo aj s ďalšími: všetci pomreli a nezanechali deti. ");
INSERT INTO slk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Napokon zomrela aj žena: ");
INSERT INTO slk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","komu bude pri vzkriesení patriť, keď mala sedem mužov?“ ");
INSERT INTO slk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ježiš im na to odpovedal: „Pre ľudí je normálne, že sa ženia a vydávajú. ");
INSERT INTO slk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tí, ktorých Boh uzná za hodných žiť na novej zemi a vzkriesi ich z mŕtvych, sa už nebudú ženiť, ani vydávať ");
INSERT INTO slk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","a nebudú ani umierať. V tomto sa budú podobať anjelom a budú Božími synmi, lebo ich Boh vzkriesil z mŕtvych do nového života. ");
INSERT INTO slk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A pokiaľ ide o zmŕtvychvstanie, to naznačil už Mojžiš pri kre. Tam Pána nazýva Bohom Abraháma, Bohom Izáka a Bohom Jákoba. ");
INSERT INTO slk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Boh predsa nie je Bohom mŕtvych, ale Bohom živých. Z Božieho pohľadu sú teda všetci živí.“ ");
INSERT INTO slk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","„Majstre, dobre si im odpovedal!“ poznamenali niektorí z učiteľov Zákona. ");
INSERT INTO slk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A už sa neodvážili dávať mu ďalšie otázky. ");
INSERT INTO slk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ježiš sa opýtal tých, čo ho počúvali: „Uvažovali ste nad tým, prečo ľudia nazývajú Mesiáša synom Dávidovým? ");
INSERT INTO slk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Veď sám Dávid hovorí v knihe Žalmov: ‚Boh povedal môjmu Pánovi: Seď po mojej pravici, ");
INSERT INTO slk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kým ti všetkých nepriateľov nepoložím k nohám.‘ ");
INSERT INTO slk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ak ho Dávid nazýva svojím Pánom, ako potom môže byť aj jeho synom?“ ");
INSERT INTO slk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Učeníkom potom pred všetkými povedal: ");
INSERT INTO slk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Dajte si pozor na učiteľov Zákona, ktorí sa radi honosne obliekajú a čakajú, že ich ľudia budú na verejnosti úctivo zdraviť a klaňať sa im. Radi sedávajú na čestných miestach pri bohoslužbách i na hostinách. ");
INSERT INTO slk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Využívajú domy vdov a dlho sa modlievajú na verejnosti, aby ich všetci videli. Práve preto ich Boh potrestá prísnejšie, než ostatných.“ ");
INSERT INTO slk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ježiš pozoroval, ako zámožní ľudia vhadzujú peniaze do chrámovej pokladnice. ");
INSERT INTO slk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Videl aj jednu chudobnú vdovu, ako tam vhodila dve drobné mince. ");
INSERT INTO slk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Povedal: „Táto chudobná vdova dala viac ako ostatní. ");
INSERT INTO slk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Oni všetci dávali z nadbytku, ale táto chudobná žena dala všetko, čo mala – celé svoje živobytie.“ ");
INSERT INTO slk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niektorí učeníci obdivovali, z akého krásneho kameňa je postavený chrám a ako nádherne je vyzdobený pamätnými darmi. Ale Ježiš povedal: ");
INSERT INTO slk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Prídu dni, keď zo všetkého, čo teraz obdivujete, nezostane kameň na kameni. Všetko to bude zničené – nezostane tu kameň na kameni.“ ");
INSERT INTO slk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","„Majstre, kedy sa to všetko stane a čo bude znamením, že sa k tomu schyľuje?“ opýtali sa ho. ");
INSERT INTO slk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ježiš im odpovedal: „Dajte si pozor, aby vás niekto neoklamal a nezviedol. Mnohí totiž prídu, budú sa za mňa vyhlasovať a tvrdiť ‚Ja som on!‘ alebo ‚Už nastal ten čas!‘, no neverte im! ");
INSERT INTO slk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na mnohých miestach vypuknú vojny a nepokoje. Keď sa o tom dozviete a budete počuť o ich následkoch, neľakajte sa! To všetko musí prísť, ale koniec nenastane hneď. ");
INSERT INTO slk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Budú proti sebe bojovať národy a krajiny, ");
INSERT INTO slk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nastanú veľké zemetrasenia, v mnohých krajinách vypukne hlad a rôzne epidémie a na nebi sa budú objavovať nezvyčajné úkazy. ");
INSERT INTO slk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ale tomu všetkému bude ešte predchádzať obdobie veľkého prenasledovania. Vydajú vás synagógam, budú vás vláčiť po súdoch, vodiť pred kráľov a vládcov, a to len preto, že ste uverili vo mňa. ");
INSERT INTO slk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","No takto sa vám naskytne príležitosť vydať svedectvo o mne a o vašej viere. ");
INSERT INTO slk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","A netrápte sa, akými slovami sa budete obhajovať, ");
INSERT INTO slk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","lebo ja vám dám pravé slová aj vhodné dôkazy, ktoré vaši odporcovia nebudú môcť vyvrátiť. ");
INSERT INTO slk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Neraz vás zradia aj vlastní rodičia, súrodenci, príbuzní a priatelia. Ba niektorých z vás aj usmrtia. ");
INSERT INTO slk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Všetci vás budú nenávidieť len preto, že ste moji. ");
INSERT INTO slk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ale nebojte sa, lebo ani jeden vlas z hlavy sa vám nestratí. ");
INSERT INTO slk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ak vytrváte, získate večný život.“ ");
INSERT INTO slk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","„Keď uvidíte, že Jeruzalem obkľučujú vojská, vedzte, že sa priblížila jeho skaza. ");
INSERT INTO slk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tí, čo budú v Judsku, nech utečú do hôr. Tí, čo budú v Jeruzaleme, nech z neho odídu, a tí, čo budú za mestom, nech sa doň nevracajú. ");
INSERT INTO slk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Budú to dni trestu a splní sa všetko, čo o tom napísali proroci. ");
INSERT INTO slk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ťažko bude v tých dňoch tehotným ženám a tým, čo majú dojčatá. Na zemi bude veľké utrpenie a hnev proti tomuto ľudu. ");
INSERT INTO slk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mnohých povraždia a mnohých odvlečú do vyhnanstva alebo do zajatia po celom svete a po Jeruzaleme budú šliapať pohania až dovtedy, kým sa nenaplní aj ich čas.“ ");
INSERT INTO slk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","„A budú zvláštne úkazy na slnku, na mesiaci aj na hviezdach. ");
INSERT INTO slk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ľudia na zemi budú prežívať nesmiernu úzkosť a nebudú vedieť, kam sa podieť pred hukotom rozbúreného mora. Celý svet zachváti smrteľný strach z neistoty, čo sa bude diať, lebo i nebeské mocnosti sa zachvejú. ");
INSERT INTO slk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vtedy ľudia uvidia, ako Syn človeka prichádza v oblakoch s veľkou mocou a slávou. ");
INSERT INTO slk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Keď sa to všetko začne diať, vzpriamte sa a zdvihnite hlavy. Vaša záchrana je blízko!“ ");
INSERT INTO slk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Svoje slová zdôraznil podobenstvom: „Všimnite si figovník alebo ktorýkoľvek iný strom. ");
INSERT INTO slk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Keď vypučí lístie, viete, že sa blíži leto. ");
INSERT INTO slk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A takisto, keď uvidíte, že sa plní, čo som predpovedal, poznáte, že Božie kráľovstvo je blízko. ");
INSERT INTO slk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Je to tak – svet nepominie, kým sa to všetko nestane. ");
INSERT INTO slk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nebo aj zem sa raz pominú, ale moje slová nikdy nestratia svoju platnosť.“ ");
INSERT INTO slk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","„Dávajte si pozor, aby vaša myseľ nebola otupená nestriedmosťou, opilstvom a starosťami o živobytie. Inak vás ten deň prekvapí ako nastražená pasca, z ktorej niet úniku. ");
INSERT INTO slk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lebo to príde na všetkých ľudí na zemi. ");
INSERT INTO slk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Preto buďte bdelí a neprestajne sa modlite, aby ste unikli všetkému, čo má prísť, a mohli ste napokon obstáť pred Synom človeka.“ ");
INSERT INTO slk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ježiš každý deň učil v chráme, ale na noc odchádzal z Jeruzalema na Olivový vrch. ");
INSERT INTO slk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hneď zrána všetci ľudia opäť prichádzali do chrámu, aby ho počúvali. ");
INSERT INTO slk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Priblížil sa sviatok nekvasených chlebov, ktorý sa nazýva Pascha. ");
INSERT INTO slk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Veľkňazi a učitelia Zákona sa pokúšali nájsť spôsob, ako Ježiša pripraviť o život, no zároveň sa báli, aby to nevyvolalo vzburu medzi ľuďmi. ");
INSERT INTO slk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Vtedy satan ovládol Judáša Iškariotského, jedného z Ježišových dvanástich učeníkov: ");
INSERT INTO slk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","šiel za veľkňazmi a veliteľmi chrámovej stráže a ponúkol sa, že im pomôže zmocniť sa Ježiša. ");
INSERT INTO slk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tí sa nesmierne zaradovali a sľúbili mu za to finančnú odmenu. ");
INSERT INTO slk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judáš súhlasil a od tej chvíle striehol na vhodnú príležitosť, ako Ježiša zatknúť nenápadne, bez mnohých svedkov. ");
INSERT INTO slk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nastal deň sviatku nekvasených chlebov, v ktorom Židia zabíjali baránka. ");
INSERT INTO slk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ježiš prikázal Petrovi a Jánovi: „Choďte a pripravte nám veľkonočnú večeru.“ ");
INSERT INTO slk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Spýtali sa ho: „Kde chceš, aby sme ju pripravili?“ ");
INSERT INTO slk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Odpovedal im: „Keď prídete do mesta, stretnete tam muža, ktorý ponesie krčah s vodou. Choďte za ním do domu, do ktorého vojde, ");
INSERT INTO slk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a majiteľovi domu povedzte: ‚Učiteľ sa ťa pýta na miestnosť, v ktorej by mohol so svojimi učeníkmi jesť baránka.‘ ");
INSERT INTO slk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ukáže vám veľkú, už prichystanú miestnosť na poschodí. Tam pripravte večeru.“ ");
INSERT INTO slk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Učeníci odišli a našli všetko tak, ako im povedal. A pripravili tam veľkonočného baránka. ");
INSERT INTO slk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Keď nastal čas večere, sadol si s apoštolmi za stôl. ");
INSERT INTO slk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Povedal im: „Veľmi som túžil jesť s vami veľkonočné jedlo skôr, ako budem trpieť. ");
INSERT INTO slk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Je to naposledy, čo ho takto jeme. Lebo vám hovorím, že ho už nebudem jesť dovtedy, kým sa to, čo predstavuje, nenaplní v Božom kráľovstve.“ ");
INSERT INTO slk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Potom vzal kalich, poďakoval zaň Bohu a povedal: „Vezmite a rozdeľte si to medzi sebou. ");
INSERT INTO slk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lebo ja už nebudem piť z plodu viniča, až kým nepríde Božie kráľovstvo.“ ");
INSERT INTO slk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Potom vzal chlieb, poďakoval sa Bohu, lámal ho a podával svojim učeníkom so slovami: „Toto je moje telo, ktoré sa za vás vydáva. To robte na moju pamiatku.“ ");
INSERT INTO slk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Po večeri im opäť podal kalich a povedal: „Tento kalich je znamením novej zmluvy, spečatenej mojou krvou, ktorá sa za vás vylieva. ");
INSERT INTO slk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ale môj zradca je so mnou pri stole. ");
INSERT INTO slk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Syn človeka ide, ako je určené, ale beda tomu, kto ho zrádza.“ ");
INSERT INTO slk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Po týchto slovách sa začali dohadovať, kto z nich by bol schopný čosi také urobiť. ");
INSERT INTO slk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Napokon sa medzi učeníkmi rozpútal spor, kto z nich je najdôležitejší. ");
INSERT INTO slk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ježiš im povedal: „Tu na zemi panujú vládcovia a dávajú sa nazývať dobrodincami. ");
INSERT INTO slk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Medzi vami nech je to inak. Ten najdôležitejší medzi vami nech je pokorný akoby bol najmladší, a kto je na čele, nech je ako ten, čo slúži ostatným. ");
INSERT INTO slk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Veď kto je dôležitejší? Ten, kto sedí za stolom a dá sa obsluhovať, alebo ten, čo obsluhuje? Všeobecne platí, že ten, kto sa dá obsluhovať. No ja som medzi vami ako ten, kto slúži. ");
INSERT INTO slk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Až doposiaľ ste mi v mojich skúškach verne stáli po boku. ");
INSERT INTO slk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dávam vám teda kráľovstvo, ako ho môj Otec dal mne, ");
INSERT INTO slk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","aby ste v tom kráľovstve jedli a pili pri mojom stole, sedeli na trónoch a súdili dvanásť kmeňov Izraela.“ ");
INSERT INTO slk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Potom oslovil Petra: „Šimon, Šimon, Satan si vyžiadal, aby vás smel preosiať ako pšenicu, ");
INSERT INTO slk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ale ja som prosil za teba, aby tvoja viera celkom nezlyhala. A až mi opäť začneš dôverovať, posilňuj svojich bratov.“ ");
INSERT INTO slk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter mu odpovedal: „Pane, som pripravený ísť s tebou do väzenia, ba aj na smrť.“ ");
INSERT INTO slk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ale Ježiš mu povedal: „Vravím ti, Peter, skôr ako ráno zakikiríka kohút, tri razy ma zaprieš.“ ");
INSERT INTO slk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Potom sa spýtal ostatných učeníkov: „Keď som vás poslal bez peňazí, bez tašky aj bez obuvi, chýbalo vám niečo?“ Odpovedali: „Nechýbalo.“ ");
INSERT INTO slk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ježiš pokračoval: „Odteraz však, kto má peniaze či tašku, nech si ich vezme. A kto nemá meč, nech radšej predá šaty a kúpi si ho. ");
INSERT INTO slk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lebo nastal čas, keď sa na mne splní proroctvo Písma: ‚Budú ho počítať medzi zločincov.‘ To, čo je o mne napísané sa vyplní.“ ");
INSERT INTO slk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Učeníci mu povedali: „Pane, máme tu dva meče.“ „To stačí,“ odpovedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Potom sa ako zvyčajne pobral na Olivový vrch. Išli s ním aj učeníci. ");
INSERT INTO slk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Keď došli na miesto, povedal im: „Modlite sa, aby ste nepodľahli pokušeniu.“ ");
INSERT INTO slk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Potom sa od nich vzdialil asi tak na dohodenie kameňom, kľakol si a modlil sa: ");
INSERT INTO slk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Otče, ak chceš, odním odo mňa tento kalich utrpenia. Ale nech sa stane tvoja vôľa, nie moja.“ ");
INSERT INTO slk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tu sa mu zjavil anjel z neba a posilňoval ho. ");
INSERT INTO slk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ježiš sa v smrteľnej úzkosti modlil ešte horlivejšie. Pot mu ako krvavé kvapky stekal na zem. ");
INSERT INTO slk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Keď napokon vstal od modlitby a vrátil sa k učeníkom, našiel ich spať, zmorených smútkom. ");
INSERT INTO slk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","„Ako môžete spať?“ prebudil ich. „Vstaňte a modlite sa! Inak vás premôže pokušenie.“ ");
INSERT INTO slk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ešte ani nedohovoril, a už sa zjavil zástup ľudí na čele s Judášom, jedným z dvanástich učeníkov. Pristúpil k Ježišovi a pozdravil ho priateľským bozkom. ");
INSERT INTO slk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ježiš sa ho spýtal: „Judáš, bozkom zrádzaš Syna človeka?“ ");
INSERT INTO slk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Keď ostatní učeníci pochopili, čo sa deje, zvolali: „Pane, máme na nich zaútočiť mečmi?“ ");
INSERT INTO slk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jeden z nich naozaj vytasil meč a odťal veľkňazovmu sluhovi pravé ucho. ");
INSERT INTO slk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ježiš im však povedal: „Prestaňte s tým!“ Dotkol sa ucha zraneného a uzdravil ho. ");
INSERT INTO slk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Potom sa obrátil k veľkňazom, veliteľom stráže a vodcom ľudu, ktorí šli na čele zástupu: „Som azda nejaký nebezpečný burič, že ste na mňa vyšli s mečmi a palicami? ");
INSERT INTO slk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Každý deň som predsa s vami v chráme. Prečo ste ma nezajali tam? Teraz však nastala vaša chvíľa a čas, keď vláda tmy vrcholí.“ ");
INSERT INTO slk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Vtedy sa ho zmocnili a odviedli do veľkňazovho paláca. Peter šiel obďaleč za ním. ");
INSERT INTO slk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ktosi rozložil uprostred nádvoria oheň a posadali si okolo neho. Aj Peter si k nim prisadol, aby sa zohrial. ");
INSERT INTO slk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ako mu oheň osvietil tvár, všimla si ho jedna slúžka, premerala si ho a povedala: „Pozrite sa, aj tento patrí k nemu!“ ");
INSERT INTO slk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ale Peter to zaprel a povedal jej: „Žena, veď ja ho vôbec nepoznám!“ ");
INSERT INTO slk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Po chvíli si ho všimol ktosi iný: „Aj ty si určite jeden z nich.“ Peter sa ohradil: „Nie som!“ ");
INSERT INTO slk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Asi o hodinu ktosi opäť začal tvrdiť: „Ale veď aj tento patrí k Ježišovým učeníkom, veď je to Galilejčan!“ ");
INSERT INTO slk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peter to však zasa poprel: „Človeče, vôbec neviem, o čom hovoríš!“ A vtom, ešte skôr ako dohovoril, zakikiríkal kohút. ");
INSERT INTO slk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Vtedy sa Ježiš obrátil a zadíval sa na Petra. Peter si hneď spomenul, čo mu Pán povedal: „Skôr ako ráno zakikiríka kohút, tri razy ma zaprieš.“ ");
INSERT INTO slk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Vyšiel z nádvoria a trpko sa rozplakal. ");
INSERT INTO slk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vojaci, ktorí Ježiša strážili, sa mu začali posmievať a biť ho. ");
INSERT INTO slk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zakrývali mu oči a pýtali sa ho: „Si predsa prorok, tak uhádni, kto ťa udrel.“ ");
INSERT INTO slk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A predbiehali sa v tom, kto ho väčšmi urazí. ");
INSERT INTO slk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Len čo sa rozvidnelo, zišla sa židovská veľrada, ktorú tvorili vodcovia ľudu, veľkňazi a učitelia Zákona. Dali si Ježiša predviesť ");
INSERT INTO slk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","a naliehali naňho: „Si Mesiáš? Povedz nám to!“ On im odpovedal: „Aj keby som vám to povedal, neuveríte mi. ");
INSERT INTO slk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A keby som sa ja vás na niečo spýtal, neodpoviete mi. ");
INSERT INTO slk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Čoskoro však Syn človeka zasadne po pravici všemohúceho Boha.“ ");
INSERT INTO slk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tu všetci začali kričať: „Ty si teda Syn Boží?“ Odpovedal im: „Vy sami hovoríte, že som!“ ");
INSERT INTO slk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","„Načo by nám boli ďalší svedkovia?“ povedali. „Veď sme to počuli priamo od neho!“ ");
INSERT INTO slk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tu vstali všetci členovia rady a odviedli ho k rímskemu miestodržiteľovi Pilátovi. ");
INSERT INTO slk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Predniesli proti nemu obžalobu: „Tento človek, ako sme zistili, poburuje náš ľud, zakazuje odvádzať dane rímskemu cisárovi a vyhlasuje sa za Mesiáša a kráľa.“ ");
INSERT INTO slk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tu sa ho Pilát spýtal: „Ty si kráľ Židov?“ Odpovedal mu: „Ty sám to vravíš.“ ");
INSERT INTO slk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilát povedal veľkňazom i zhromaždenému zástupu: „Na tomto človeku som nenašiel nič, čím by sa previnil.“ ");
INSERT INTO slk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oni však namietali: „Svojím učením vyvoláva nepokoje v celom Judsku. Začalo sa to v Galilei a preniklo to až sem.“ ");
INSERT INTO slk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Keď to Pilát počul, spýtal sa: „Pochádza z Galiley?“ ");
INSERT INTO slk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A keď prisvedčili, hneď rozkázal zaviesť Ježiša ku kráľovi Herodesovi, lebo Galilea podliehala jeho právomoci. Herodes bol práve v Jeruzaleme a ");
INSERT INTO slk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","veľmi sa tomu zaradoval, lebo už dávno túžil Ježiša vidieť. Veľa totiž o ňom počul a dúfal, že bude svedkom nejakého zázraku. ");
INSERT INTO slk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dal mu mnoho otázok, ale Ježiš na ne neodpovedal. ");
INSERT INTO slk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Zato prítomní veľkňazi a učitelia Zákona ho neprestajne osočovali. ");
INSERT INTO slk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes spolu s jeho vojakmi začal Ježiša ponižovať a vysmieval sa mu. Dal ho obliecť do slávnostných kráľovských šiat a poslal ho naspäť k Pilátovi. ");
INSERT INTO slk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","V ten deň sa Herodes s Pilátom spriatelili; dovtedy totiž vládla medzi nimi nevraživosť. ");
INSERT INTO slk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilát zvolal veľkňazov, popredných mužov aj ľud ");
INSERT INTO slk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a predniesol im tento rozsudok: „Priviedli ste mi tohto človeka a obvinili ste ho, že poburuje ľud proti Rímu. Boli ste pri tom, keď som ho vypočúval, no nemohol som ho usvedčiť z nijakého zločinu, ktorý mu pripisujete. ");
INSERT INTO slk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ani Herodes nie, inak by nám ho neposlal späť. Nespáchal teda nič, prečo by si zaslúžil smrť. ");
INSERT INTO slk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A tak ho dám potrestať a potom ho prepustím.“ ");
INSERT INTO slk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na každý sviatok im totiž prepúšťal jedného väzňa. ");
INSERT INTO slk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Celý zástup však začal jednohlasne kričať: „Preč s ním! Prepusť nám Barabáša!“ ");
INSERT INTO slk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabáš bol uväznený pre akúsi vzburu v meste a pre vraždu. ");
INSERT INTO slk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilát sa znova pokúsil presvedčiť dav, že Ježiš je nevinný, lebo ho chcel prepustiť. ");
INSERT INTO slk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ale ľudia ho prekričali: „Ukrižuj ho! Ukrižuj!“ ");
INSERT INTO slk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilát sa ešte tretí raz pokúsil presvedčiť ich: „Akého zločinu sa vlastne dopustil? Nenašiel som nijaký dôvod, pre ktorý by si zaslúžil trest smrti. Dám ho zbičovať a potom ho prepustím.“ ");
INSERT INTO slk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ale dav sa s čoraz väčším krikom domáhal Ježišovho ukrižovania. Ich krik nakoniec tak zmohutnel, ");
INSERT INTO slk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","že sa im Pilát rozhodol vyhovieť. ");
INSERT INTO slk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Prepustil Barabáša, muža, ktorý bol uvrhnutý do väzenia za poburovanie a vraždu, a vydal im Ježiša, aby s ním urobili, čo chcú. ");
INSERT INTO slk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Keď Ježiša odvádzali, vojaci prinútili istého muža, aby odniesol Ježišov kríž. Bol to Šimon z Kyrény, ktorý práve prichádzal z vidieka do mesta. ");
INSERT INTO slk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Šiel za nimi obrovský zástup a bolo v ňom mnoho žien, ktoré nariekali a oplakávali Ježiša. ");
INSERT INTO slk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ježiš sa k nim obrátil a povedal: „Dcéry jeruzalemské, neplačte nado mnou, plačte radšej nad sebou a nad svojimi deťmi, ");
INSERT INTO slk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","lebo prichádzajú dni, keď sa bude hovoriť: ‚Šťastné sú neplodné, šťastné sú tie, ktoré nikdy nerodili ani nepridájali!‘ ");
INSERT INTO slk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ľudia budú prosiť vrchy: ‚Padnite na nás!‘ a kopce: ‚Prikryte nás!‘ ");
INSERT INTO slk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Lebo ak takto nakladajú so živým stromom, čo sa potom bude diať so suchým?“ ");
INSERT INTO slk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Spolu s Ježišom viedli na smrť aj dvoch zločincov. ");
INSERT INTO slk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Keď prišli na miesto, ktoré sa volá Lebka, ukrižovali jeho aj tých zločincov: jedného sprava, druhého zľava. ");
INSERT INTO slk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ježiš sa modlil za svojich nepriateľov: „Otče, odpusť im, lebo nevedia, čo robia.“ Vojaci si losovaním rozdelili jeho odev. ");
INSERT INTO slk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Okolo stál a prizeral sa dav. Ozývali sa aj posmešky členov veľrady: „Iných zachraňoval, tak nech teraz zachráni sám seba, ak je naozaj Mesiáš, ktorého si vyvolil Boh.“ ");
INSERT INTO slk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aj vojaci sa mu posmievali a ponúkali ho octom. ");
INSERT INTO slk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pokrikovali naňho: „Ak si židovský kráľ, zachráň sa!“ ");
INSERT INTO slk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nad hlavu mu pripevnili nápis v gréčtine, latinčine a hebrejčine: TOTO JE KRÁĽ ŽIDOV. ");
INSERT INTO slk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aj jeden z ukrižovaných zločincov na Ježiša zaútočil slovami: „Čo si to za Mesiáša? Ak ním si, zachráň seba i nás!“ ");
INSERT INTO slk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ale ten druhý ho okríkol: „Ani vo chvíli smrti sa nebojíš Boha? Veď si odsúdený k tomu istému trestu! ");
INSERT INTO slk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","My si však takýto trest zaslúžime, ale tento človek nespáchal nič zlé a trpí nevinne.“ ");
INSERT INTO slk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Potom oslovil Ježiša: „Ježišu, spomeň si na mňa, keď prídeš do svojho kráľovstva.“ ");
INSERT INTO slk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ježiš mu odpovedal: „Dávam ti svoj sľub, že dnes budeš so mnou v raji.“ ");
INSERT INTO slk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Okolo poludnia odrazu nastala tma a trvala v celej zemi až do tretej poobede. ");
INSERT INTO slk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Slnko sa zatmelo a chrámová opona roztrhla napoly. ");
INSERT INTO slk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ježiš nahlas zvolal: „Otče, do tvojich rúk odovzdávam svojho ducha!“ Po týchto slovách naposledy vydýchol. ");
INSERT INTO slk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Keď rímsky stotník, videl, čo sa stalo, vzdal česť Bohu a povedal: „Tento človek bol určite spravodlivý.“ ");
INSERT INTO slk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A zástupy, ktoré sa prizerali tejto scéne a videli, čo sa stalo, bili sa do pŕs a odchádzali. ");
INSERT INTO slk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ježišovi priatelia a ženy, čo prišli za ním z Galiley stáli opodiaľ a na všetko sa pozerali. ");
INSERT INTO slk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jeden z členov veľrady, Jozef, čestný a šľachetný človek, ");
INSERT INTO slk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ktorý pochádzal z judského mesta Arimatea, nesúhlasil s postupom a rozsudkom ostatných. Patril k tým, ktorí očakávali príchod Božieho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ten teraz zašiel za Pilátom a vyžiadal si Ježišovo mŕtve telo. ");
INSERT INTO slk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sňal ho z kríža, zavinul do plátna a uložil do hrobu vytesaného v skale, kde ešte nik nebol pochovaný. ");
INSERT INTO slk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bolo to v piatok večer, v deň, keď sa robili prípravy na sobotu. ");
INSERT INTO slk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ženy, ktoré sprevádzali Ježiša z Galiley, boli pri pochovávaní Ježišovho tela a videli jeho hrob. ");
INSERT INTO slk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Potom sa vrátili domov a pripravili vonné masti a oleje, ktorými ho chceli natrieť. Ale v sobotu zachovali podľa prikázania sviatočný odpočinok. ");
INSERT INTO slk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","V prvý deň týždňa sa zavčasu ráno ženy pobrali k hrobu a niesli so sebou vonné masti a oleje. ");
INSERT INTO slk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Keď prišli, zistili, že veľký kameň, ktorý mal zakrývať vchod do hrobu, je odvalený. ");
INSERT INTO slk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vošli teda dnu, ale telo Pána Ježiša tam nenašli. ");
INSERT INTO slk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ako tu bezradné stáli, zrazu sa vedľa nich zjavili dvaja muži v žiarivo bielych odevoch. ");
INSERT INTO slk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ženy zachvátil strach a sklonili sa k zemi. Muži sa ich spýtali: „Prečo hľadáte živého medzi mŕtvymi? ");
INSERT INTO slk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ježiš tu nie je! Vstal z mŕtvych! Spomeňte si, čo vám hovoril už v Galilei: ");
INSERT INTO slk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‚Syn človeka má byť vydaný do rúk zlých ľudí, ukrižujú ho, ale na tretí deň vstane z mŕtvych.‘ “ ");
INSERT INTO slk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ženy sa na to naozaj rozpamätali. ");
INSERT INTO slk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vrátili sa od hrobu a všetko vyrozprávali apoštolom i všetkým ostatným. ");
INSERT INTO slk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Boli to: Mária Magdaléna, Jana, Mária Jakubova, ale i ďalšie ženy. ");
INSERT INTO slk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Učeníci pokladali ich správu za nezmysel a neverili im. ");
INSERT INTO slk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peter však vstal a bežal k hrobu. Keď sa nahol dnu, videl tam len plachty. Vrátil sa a nedokázal pochopiť, čo sa vlastne stalo. ");
INSERT INTO slk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","V ten istý deň sa dvaja z Ježišových učeníkov uberali do dediny Emauzy, ktorá je od Jeruzalema vzdialená asi dvanásť kilometrov. ");
INSERT INTO slk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hovorili spolu o všetkom, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ako sa tak rozprávali a znovu o všetkom diskutovali, pripojil sa k nim samotný Ježiš a kráčal s nimi. ");
INSERT INTO slk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pozerali sa na neho, čosi im však bránilo spoznať, že je to on. ");
INSERT INTO slk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","„O čom sa to rozprávate?“ prihovoril sa im. Zostali stáť a na tvárach sa im zračil hlboký smútok. ");
INSERT INTO slk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jeden z nich, Kleofáš, mu odpovedal: „Ty si asi jediný z celého Jeruzalema, ktorý nevie, čo sa tam po tieto dni stalo!“ ");
INSERT INTO slk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Spýtal sa ich: „A čo?“ – „Ty si nič nepočul o Ježišovi z Nazareta?“ čudovali sa. „Bol to prorok. Mal veľkú moc, ktorá sa prejavovala v jeho činoch i slovách. Boh bol s ním a všetci ľudia ho obdivovali. ");
INSERT INTO slk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Naši veľkňazi a členovia rady ho však zatkli a odovzdali rímskemu panovníkovi, aby ho odsúdil na smrť: potom ho ukrižovali. ");
INSERT INTO slk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A my sme dúfali, že on je ten očakávaný Mesiáš, ktorý vyslobodí Izrael. Stalo sa to už predvčerom, ");
INSERT INTO slk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","no dnes nás niektoré ženy vyľakali. Skoro ráno boli totiž pri hrobe, v ktorom bol pochovaný, ");
INSERT INTO slk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ale jeho telo nenašli. A vraj videli anjelov, ktorí im povedali, že Ježiš žije. ");
INSERT INTO slk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niektorí z nás potom odišli k hrobu a všetko našli presne tak, ako nám o tom hovorili ženy: jeho však nenašli.“ ");
INSERT INTO slk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ježiš im na to povedal: „Akí ste nechápaví! Je také ťažké uveriť tomu, čo predpovedali proroci? ");
INSERT INTO slk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vari nemal Mesiáš prejsť všetkým tým utrpením, kým sa mu nedostane sláva, ktorá mu náleží?“ ");
INSERT INTO slk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Počnúc Mojžišom a prorokmi im vysvetľoval všetko, čo sa o ňom hovorí v celom Písme. ");
INSERT INTO slk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Keď sa priblížili k dedine Emauzy, k cieľu svojej cesty, Ježiš akoby chcel ísť ďalej. ");
INSERT INTO slk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oni ho však prehovárali: „Zostaň s nami, zvečerilo sa a blíži sa noc.“ Dal sa teda pozvať a vošiel s nimi do domu. ");
INSERT INTO slk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Keď zasadli k večeri, vzal do rúk chlieb, poďakoval Bohu, rozdelil ho a podával im. ");
INSERT INTO slk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","V tej chvíli sa im otvorili oči a spoznali ho, ale on im zmizol. ");
INSERT INTO slk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vtedy si povedali: „Či nám nehorelo srdce, keď sa s nami celou cestou zhováral a vysvetľoval nám Písma?“ ");
INSERT INTO slk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nedbali na to, že je neskoro, a hneď sa pobrali naspäť do Jeruzalema, kde ich jedenásti učeníci a ostatní Ježišovi nasledovníci uvítali slovami: ");
INSERT INTO slk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","„Ježiš naozaj vstal z mŕtvych! Ukázal sa Šimonovi!“ ");
INSERT INTO slk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A tí dvaja učeníkom zasa vyrozprávali, čo sa im prihodilo na ceste a ako spoznali Ježiša, keď lámal chlieb. ");
INSERT INTO slk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Práve keď o tom rozprávali, Ježiš sa zrazu zjavil medzi nimi a pozdravil ich: „Pokoj vám!“ ");
INSERT INTO slk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Všetci sa strašne preľakli, lebo sa domnievali, že vidia ducha. ");
INSERT INTO slk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","„Prečo ste vystrašení a prečo sa rodia vo vašom srdci pochybnosti?“ napomenul ich. ");
INSERT INTO slk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","„Pozrite na moje ruky a nohy – som to naozaj ja. Dotknite sa ma a tak sa presvedčte, že nie som duch – veď ten na rozdiel odo mňa nemá telo z mäsa a kostí!“ ");
INSERT INTO slk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pri tých slovách im ukázal rany na svojich rukách a na nohách. ");
INSERT INTO slk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","No ešte vždy tomu nemohli uveriť, radovali sa aj pochybovali, a tak ich poprosil: „Máte tu niečo na jedenie?“ ");
INSERT INTO slk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Podali mu kúsok pečenej ryby a medového plásta. ");
INSERT INTO slk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Zjedol to pred ich očami. ");
INSERT INTO slk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Potom im povedal: „Spomeňte si, keď som ešte býval s vami, pripomínal som vám, že sa musí naplniť všetko, čo je o mne napísané v Mojžišovom zákone, v Prorokoch aj Žalmoch.“ ");
INSERT INTO slk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Vtedy vďaka Ježišovi konečne porozumeli slovám Písma. ");
INSERT INTO slk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pokračoval: „Áno, už dávno bolo napísané, že Mesiáš musí trpieť, zomrieť a tretí deň vstane z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A z Jeruzalema sa zvesť o záchrane musí zaniesť všetkým národom; odpustenie hriechov je pre všetkých, ktorí sa obrátia k Bohu. ");
INSERT INTO slk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vy sami budete svedčiť, čo sa stalo a čoho ste boli svedkami. ");
INSERT INTO slk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A ja vám pošlem Ducha Svätého, ktorého vám sľúbil môj Otec. Zostaňte v Jeruzaleme, kým vás Boh nevyzbrojí touto mocou.“ ");
INSERT INTO slk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Potom ich viedol cestou z Jeruzalema do Betánie. Zastal, zdvihol ruky k nebu a požehnal ich. ");
INSERT INTO slk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A keď im žehnal, vzďaľoval sa od nich a vznášal sa do neba. ");
INSERT INTO slk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Padli pred ním na kolená a potom sa s nesmiernou radosťou vrátili do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Každý deň prichádzali do chrámu a velebili Boha.");
INSERT INTO slk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na počiatku bolo Slovo, to Slovo bolo u Boha, a Boh sám bol tým Slovom. ");
INSERT INTO slk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","On, toto Slovo, bol od počiatku s Bohom. ");
INSERT INTO slk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Prostredníctvom neho bolo všetko stvorené a bez neho nebolo stvorené nič z toho, čo jestvuje. ");
INSERT INTO slk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","On bol zdrojom všetkého života a tento život bol svetlom pre každého človeka. ");
INSERT INTO slk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","To svetlo prekonáva temnotu sveta a temnota ho nikdy nepohltila. ");
INSERT INTO slk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Boh poslal muža, ktorý sa volal Ján. ");
INSERT INTO slk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ján prišiel na svet ako svedok, ktorého úlohou bolo priniesť posolstvo o svetle. Prostredníctvom Jána mali všetci uveriť. ");
INSERT INTO slk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ján sám nebol tým svetlom, jeho poslaním bolo upozorniť naň. ");
INSERT INTO slk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","To pravé svetlo, ktoré osvecuje každého človeka, prišlo na svet. ");
INSERT INTO slk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bol na svete, ktorý vznikol jeho prostredníctvom, ale svet ho nepoznal. ");
INSERT INTO slk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Prišiel do svojho vlastného, ale jeho vlastní ho neprijali. ");
INSERT INTO slk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ale všetkým, ktorí ho prijali a uverili v neho, umožnil stať sa Božími deťmi. ");
INSERT INTO slk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tí sa nenarodili bežným spôsobom, ani z ľudskej túžby po deťoch, či z rozhodnutia človeka, ale Božím pôsobením. ");
INSERT INTO slk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Slovo sa stalo človekom, ktorý žil medzi nami. A my sme videli jeho slávu – slávu jediného Syna nebeského Otca, ktorý bol naplnený milosťou a pravdou. ");
INSERT INTO slk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ján Krstiteľ o ňom vydával jasné svedectvo. Volal k zástupom: „To je ten, o ktorom som vám hovoril: Prichádza po mne, ale je omnoho významnejší, lebo bol dávno predo mnou.“ ");
INSERT INTO slk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Z bohatstva jeho milosti sme prijímali jedno požehnanie za druhým. ");
INSERT INTO slk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kým prostredníctvom Mojžiša dal Boh ľuďom Zákon, prostredníctvom Ježiša preukázal milosť a pravdu. ");
INSERT INTO slk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Boha nikto z ľudí nevidel, iba ten jediný, ktorý sám je Bohom a má s Otcom ten najužší vzťah; ten nám ukázal, aký Boh je. ");
INSERT INTO slk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Z Jeruzalema prišli za Jánom Krstiteľom židovskí kňazi a chrámoví služobníci s otázkou: „Kto vlastne si?“ Ján im vydal svedectvo, ");
INSERT INTO slk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","v ktorom otvorene a jasne vyznal, že nie je očakávaným Mesiášom. ");
INSERT INTO slk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","„A kto teda si?“ spýtali sa ho znova. „Si prorok Eliáš?“ „Nie som,“ odpovedal. „Tak si ten Prorok?“ „Nie,“ odpovedal im opäť. ");
INSERT INTO slk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","„Tak povedz, kto si. Musíme o tebe podať správu tým, ktorí nás poslali. Za koho sa pokladáš?“ ");
INSERT INTO slk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","„Ja som hlas, ktorý volá na púšti, ako to predpovedal prorok Izaiáš: ‚Pripravte cestu Pánovi!‘ “ ");
INSERT INTO slk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tí, ktorých poslali farizeji, ");
INSERT INTO slk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","sa ho spýtali: „Ak nie si Mesiáš, ani Eliáš, ani prorok, tak akým právom krstíš?“ ");
INSERT INTO slk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ján im odpovedal: „Ja vás krstím vodou, ale uprostred vás stojí ten, koho ešte nepoznáte. ");
INSERT INTO slk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jemu nie som hodný ani len rozviazať remienok na obuvi.“ ");
INSERT INTO slk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","To sa stalo v Betánii, za Jordánom, kde Ján krstil. ");
INSERT INTO slk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na druhý deň videl Ján prichádzať Ježiša a povedal: „Pozrite, Boží Baránok, ktorý na seba berie hriech celého sveta. ");
INSERT INTO slk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Toto je ten, ktorého som mal na mysli, keď som povedal: ‚Prichádza po mne, ale je omnoho významnejší, lebo bol dávno predo mnou.‘ ");
INSERT INTO slk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Keď som bol poverený, aby som krstil a pripravoval izraelský národ na Mesiášov príchod, ešte som nevedel, kto to je.“ ");
INSERT INTO slk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Potom Ján ľuďom vyznal: „Videl som Božieho Ducha, ktorý zostúpil z neba ako holubica, a zostal na ňom. ");
INSERT INTO slk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nevedel som, kto to bude, ale ten, ktorý ma poslal krstiť vodou mi povedal jasne: ‚Na koho uvidíš zostupovať Božieho Ducha a zostávať na ňom, to je ten, ktorý krstí Duchom Svätým.‘ ");
INSERT INTO slk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Videl som, že sa to stalo, a preto vydávam svedectvo, že on je Boží Syn.“ ");
INSERT INTO slk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na ďalší deň stál Ján pri Jordáne s dvoma zo svojich učeníkov. ");
INSERT INTO slk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tu opäť videl Ježiša, ako prechádza okolo, a zvolal: „Pozrite, to je Boží Baránok!“ ");
INSERT INTO slk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Keď to Jánovi učeníci počuli, vybrali sa za Ježišom. ");
INSERT INTO slk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ježiš sa obrátil a videl, že idú za ním. Spýtal sa ich: „Čo by ste chceli?“ „Rabbi, kde bývaš?“ odpovedali. (Rabbi znamená Učiteľ.) ");
INSERT INTO slk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Poďte a uvidíte!“ vyzval ich Ježiš. Prijali jeho pozvanie a zostali v ten deň uňho. Stalo sa to okolo štvrtej popoludní. ");
INSERT INTO slk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jeden z tých dvoch učeníkov bol Ondrej, brat Šimona Petra. ");
INSERT INTO slk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Po návšteve u Ježiša vyhľadal svojho brata Šimona a povedal mu: „Našli sme Mesiáša“ (po grécky Krista). ");
INSERT INTO slk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A priviedol ho k Ježišovi. Ježiš sa naňho zahľadel a povedal: „Ty si Šimon, syn Jonášov. Odteraz sa budeš volať Kéfas“ (po grécky Peter). ");
INSERT INTO slk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na druhý deň sa Ježiš rozhodol, že pôjde do Galiley. Vyhľadal Filipa a vyzval ho, aby ho nasledoval. ");
INSERT INTO slk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip, podobne ako Ondrej a Peter, pochádzal z Betsaidy. ");
INSERT INTO slk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip potom zašiel za Natanaelom a povedal mu: „Našli sme toho, o ktorom písal Mojžiš, a ktorého predpovedali proroci. Je to Ježiš, syn Jozefa z Nazareta.“ ");
INSERT INTO slk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","„Z Nazareta? Môže vari odtiaľ prísť niečo dobré?“ zapochyboval Natanael. „Poď a presvedč sa sám!“ povedal Filip. ");
INSERT INTO slk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Keď Ježiš uvidel Natanaela, vyhlásil: „To je pravý Izraelita, v ktorom nieto lesti.“ ");
INSERT INTO slk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","„Odkiaľ ma poznáš?“ spýtal sa prekvapený Natanael. „Videl som ťa pod figovníkom ešte predtým, ako ťa Filip zavolal,“ odpovedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","„Majstre, ty si Boží Syn a Kráľ Izraela!“ zvolal Natanael. ");
INSERT INTO slk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ježiš mu na to povedal: „Veríš mi len preto, lebo som ti povedal, že som ťa videl sedieť pod figovníkom? Uvidíš však niečo oveľa väčšie. ");
INSERT INTO slk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Uisťujem vás, že uvidíte nebesia otvorené a Božích anjelov, ako vystupujú a zostupujú na Syna človeka.“ ");
INSERT INTO slk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","V galilejskej dedine Kána sa o tri dni nato konala svadba a bola tam aj Ježišova matka Mária. ");
INSERT INTO slk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ježiš a jeho učeníci tam boli tiež, lebo boli medzi pozvanými. ");
INSERT INTO slk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Keď sa na hostine minulo víno, prišla matka za Ježišom: „Nemajú víno.“ ");
INSERT INTO slk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","„Čo nás do toho?“ povedal jej. „Môj čas ešte neprišiel.“ ");
INSERT INTO slk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jeho matka však obsluhujúcim povedala: „Urobte všetko, čo vám prikáže!“ ");
INSERT INTO slk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na chodbe stálo šesť kamenných asi stolitrových nádob, ktoré sa používali na obradné očisťovanie. ");
INSERT INTO slk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ježiš prikázal obsluhujúcim: „Naplňte nádoby vodou!“ Poslúchli a naplnili ich vodou až po okraj. ");
INSERT INTO slk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ježiš ich potom vyzval: „Naberte z nich a dajte ochutnať starejšiemu.“ Urobili, ako im povedal. ");
INSERT INTO slk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Keď starejší ochutnal vodu, premenenú Ježišom na víno, nevedel odkiaľ služobníci víno priniesli, ale oni vedeli, kde ho nabrali. Dal si zavolať ženícha ");
INSERT INTO slk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a povedal mu: „Každý hostiteľ ponúka najprv lepšie víno, a keď sa hostia riadne napijú, dá priniesť to horšie. Ale ty si odložil dobré víno až nakoniec.“ ");
INSERT INTO slk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","V galilejskej Káne tak Ježiš vykonal prvé zo svojich znamení a zjavil svoju božskú moc. A jeho učeníci v neho uverili. ");
INSERT INTO slk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Potom so svojou matkou, bratmi a učeníkmi odišiel do Kafarnauma, kde strávil niekoľko dní. ");
INSERT INTO slk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Blížili sa židovské veľkonočné sviatky, a tak sa Ježiš vybral do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na nádvorí chrámu našiel predavačov obetných býkov, oviec a holubov, i zmenárnikov, ako sedia za svojimi stolmi. ");
INSERT INTO slk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Uplietol si z povrazov bič a vyhnal z chrámového nádvoria predavačov aj dobytok a ovce, peňazomencom poprevracal stoly a rozsypal mince ");
INSERT INTO slk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","a tým, čo predávali holuby, povedal: „Preč s tým! Z domu môjho Otca nerobte tržnicu!“ ");
INSERT INTO slk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","V tej chvíli si učeníci spomenuli na slová Písma: „Starostlivosť o Boží dom ma spaľuje.“ ");
INSERT INTO slk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","„Akým znamením nás chceš presvedčiť, že máš právo takto konať?“ spytovali sa ho nahnevane židovskí vodcovia. ");
INSERT INTO slk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Odpovedal im: „Zbúrajte tento chrám a ja ho za tri dni znovu postavím.“ ");
INSERT INTO slk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","„Čo to vravíš?“ zvolali Židia. „Tento chrám sa budoval celých štyridsať rokov a ty by si ho chcel postaviť za tri dni?!“ ");
INSERT INTO slk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ježiš však hovoril o chráme, ktorým bolo jeho telo. ");
INSERT INTO slk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aj učeníci tomu porozumeli až po jeho zmŕtvychvstaní, keď si spomenuli na to, čo hovoril, a uverili Písmu i Ježišovým slovám. ");
INSERT INTO slk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cez veľkonočné sviatky vykonal Ježiš v Jeruzaleme viaceré znamenia, a tak v neho mnohí uverili. ");
INSERT INTO slk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ježiš im však nedôveroval, lebo dobre poznal ľudskú povahu, ");
INSERT INTO slk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","a ani sa nepotreboval na nikoho spytovať: vedel, čo sa v každom z nich skrýva. ");
INSERT INTO slk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Medzi farizejmi bol aj muž menom Nikodém, člen židovskej veľrady. ");
INSERT INTO slk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Raz v noci prišiel za Ježišom a povedal mu: „Majstre, vieme, že ťa poslal Boh, aby si nás vyučoval. Veď znamenia, ktoré konáš, by nemohol konať nikto, s kým by nebol Boh.“ ");
INSERT INTO slk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ježiš mu odpovedal: „Uisťujem ťa, že nikto, kto sa nenarodí znova, nemôže uvidieť Božie kráľovstvo.“ ");
INSERT INTO slk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","„Ako sa môže dospelý človek narodiť?“ zvolal prekvapene Nikodém. „Nemôže sa predsa vrátiť do matkinho tela a narodiť sa po druhý raz!“ ");
INSERT INTO slk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ježiš mu na to povedal: „Buď si istý, že ak sa s človekom nestane zásadná zmena, ktorú spôsobí Boží Duch, a ak sa na znamenie toho nedá pokrstiť, nemôže vstúpiť do Božieho kráľovstva. ");
INSERT INTO slk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Svojim deťom dávajú život rodičia, ale len Boží Duch privádza ľudí k duchovnému životu. ");
INSERT INTO slk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nečuduj sa teda, že som ti povedal: ‚Musíte sa narodiť znovu.‘ ");
INSERT INTO slk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vietor vanie, kam chce. Počuješ, ako šumí, ale nevieš, odkiaľ sa vzal a kam veje. To je to, čo sa deje s každým, kto sa narodil z Ducha.“ ");
INSERT INTO slk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","„Ako sa to môže stať?“ spýtal sa Nikodém. ");
INSERT INTO slk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","„Ty, taký významný učiteľ izraelského ľudu, a nevieš to?“ povedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","„Uisťujem ťa, že hovoríme o tom, čo vieme, a svedčíme o tom, čo sme videli, a predsa nám neveríte. ");
INSERT INTO slk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ak neveríte, keď hovorím o veciach, ktoré sa dejú na zemi, ako uveríte, keď budem hovoriť o tom, čo sa deje v nebesiach? ");
INSERT INTO slk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nik z ľudí nevystúpil na nebesia (a nemôže vám dať také svedectvo) iba ten, ktorý zostúpil z nebies – Syn človeka. ");
INSERT INTO slk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tak ako Mojžiš na púšti vyvýšil hada, tak musí byť vyvýšený aj Syn človeka, ");
INSERT INTO slk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aby každý, kto v neho verí, mal večný život. ");
INSERT INTO slk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Lebo tak Boh miloval svet, že dal svojho jediného Syna, aby nik, kto v neho verí, nezahynul, ale mal večný život. ");
INSERT INTO slk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Boh svojho Syna neposlal nato, aby svet odsúdil, ale aby ho zachránil. ");
INSERT INTO slk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kto v neho verí, nie je súdený, ale kto neverí, odsudzuje sám seba, lebo odmietol jediného Božieho Syna. ");
INSERT INTO slk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Toto je spôsob, akým Boh súdi: na svet prišlo svetlo, ale ľudia mali radšej tmu než svetlo, lebo žijú hriešnym životom. ");
INSERT INTO slk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Každý, kto koná niečo zlé, nenávidí svetlo a ani ho nevyhľadáva: bojí sa totiž, aby jeho činy nevyšli najavo. ");
INSERT INTO slk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ale ten, kto žije podľa pravdy, túži po svetle, aby sa ukázalo, že jeho činy sú v súlade s Božou vôľou.“ ");
INSERT INTO slk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Potom Ježiš prišiel aj so svojimi učeníkmi do Judska, tam s nimi nejaký čas pobudol a krstil. ");
INSERT INTO slk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ľudia však stále prichádzali aj za Jánom, aby ich krstil. Bolo to v Ainóne neďaleko Salimu, lebo tam bolo dosť vody. ");
INSERT INTO slk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bolo to ešte predtým, ako Jána uvrhli do väzenia. ");
INSERT INTO slk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jedného dňa sa akýsi Žid pustil do debaty s Jánovými učeníkmi ohľadom obradného očisťovania. ");
INSERT INTO slk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Učeníci sa obrátili na svojho učiteľa: „Majstre, ten, s ktorým si bol na druhom brehu Jordánu a o ktorom si ľuďom vydával svedectvo, teraz sám krstí a všetci idú za ním!“ ");
INSERT INTO slk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ján im odpovedal: „Človek si nemôže prisvojiť nič, čo by mu nebolo dané od Boha. ");
INSERT INTO slk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vy sami ste svedkami, že som vyhlásil: ‚Ja nie som Mesiáš, Boh ma však poslal, aby som ľudí pripravil na jeho príchod.‘ ");
INSERT INTO slk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nevesta patrí ženíchovi. Jeho priateľ je tiež na svadbe, počúva ženícha a raduje sa z jeho šťastia. Túto radosť teraz prežívam aj ja. ");
INSERT INTO slk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","On sa musí dostávať do popredia a ja musím ustupovať. ");
INSERT INTO slk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ježiš prišiel z neba a prevyšuje nás všetkých. My ľudia pochádzame zo zeme a hovoríme len o tom, čo sme prežili na zemi. ");
INSERT INTO slk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","On svedčí o tom, čo videl a počul v nebi, no jeho svedectvo nikto neprijíma. ");
INSERT INTO slk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ale kto mu uveril, potvrdil tým, že Boh je dôveryhodný. ");
INSERT INTO slk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lebo ten, ktorého poslal Boh, vraví Božie slová. Boh mu totiž dáva Ducha v neobmedzenej miere. ");
INSERT INTO slk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Veď Otec miluje Syna a všetko zveril do jeho rúk. ");
INSERT INTO slk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Preto ten, kto verí v Syna, má večný život; kto však Syna odmieta, nedosiahne ozajstný život, ale zostáva na ňom Boží hnev.“ ");
INSERT INTO slk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farizeji sa dopočuli, že Ježiš získava a krstí viac učeníkov ako Ján. ");
INSERT INTO slk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Aj keď v skutočnosti Ježiš sám nekrstil – krstili jeho učeníci.) ");
INSERT INTO slk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Keď Pán zistil, čo sa o ňom hovorí, opustil Judsko a opäť sa vrátil do Galiley. ");
INSERT INTO slk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Cestou však musel prejsť cez oblasť Samárie. ");
INSERT INTO slk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dostal sa až k samaritánskemu mestu Sychar. V jeho blízkosti ležal pozemok, ktorý dal kedysi Jákob svojmu synovi Jozefovi. ");
INSERT INTO slk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nachádzala sa tam i Jákobova studňa. Ježiš, unavený dlhou chôdzou, posadil sa ku studni, aby si odpočinul. Bolo okolo poludnia. ");
INSERT INTO slk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Onedlho prišla k studni samaritánska žena po vodu. Ježiš ju poprosil: „Daj sa mi napiť!“ ");
INSERT INTO slk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bol sám, lebo jeho učeníci odišli do mesta nakúpiť niečo na jedenie. ");
INSERT INTO slk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Žena sa začudovala: „Ako to, že si odo mňa pýtaš vodu? Veď ty si Žid a ja som Samaritánka.“ (Židia sa totiž snažili nemať so Samaritánmi nič spoločné.) ");
INSERT INTO slk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ježiš jej odpovedal: „Keby si vedela o Božom dare a keby si poznala, kto je ten, čo si od teba pýta vodu, prosila by si ho, aby ti dal napiť živej vody.“ ");
INSERT INTO slk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","„Pane, veď nemáš ani vedro, ako chceš nabrať vodu z takej hlbokej studne?“ namietla. „Odkiaľ by si vzal živú vodu? ");
INSERT INTO slk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Náš praotec Jákob dal túto studňu vykopať a sám z nej pil, aj jeho synovia, aj jeho dobytok. Si vari väčší než on?“ ");
INSERT INTO slk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ježiš jej odpovedal: „Každý, kto pije túto vodu, bude opäť smädný. ");
INSERT INTO slk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ale ak by niekto pil z vody, ktorú mu dám ja, navždy uhasí svoj smäd. A nielen to: voda, ktorú mu dám, stane sa v ňom prameňom životodarnej vody a dá mu večný život.“ ");
INSERT INTO slk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","„Pane, prosím ťa, daj mi z tej vody, aby som už nebola smädná a nemusela sem chodievať čerpať,“ povedala žena. ");
INSERT INTO slk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","„Choď a priveď sem svojho muža,“ vyzval ju Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","„Nemám muža,“ odpovedala mu. „Dobre vravíš, že nemáš muža,“ súhlasil Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","„V skutočnosti si ich už mala piatich a ten, s ktorým žiješ teraz, nie je tvojím manželom. To, čo si povedala, je pravda.“ ");
INSERT INTO slk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","„Pane, vidím, že si prorok!“ zvolala žena. ");
INSERT INTO slk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","„Naši predkovia uctievali Boha na tomto vrchu, ale vy, Židia, tvrdíte, že jediné miesto, kde sa má uctievať Boh, je v Jeruzaleme. Kde ho teda máme uctievať?“ ");
INSERT INTO slk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ježiš jej odpovedal: „Ver mi, žena, blíži sa čas, keď ľudia nebudú uctievať Boha ani na tomto vrchu, ani v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vy uctievate toho, o ktorom príliš veľa neviete, my uctievame, toho, ktorého dobre poznáme. Veď Boh prostredníctvom Židov prináša posolstvo záchrany. ");
INSERT INTO slk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Prichádza však čas, ba už aj prišiel, keď praví Boží nasledovníci budú Otcovi prejavovať ozajstnú úctu pod vedením Ducha. Je Otcovou vôľou, aby ho ľudia takto uctievali. ");
INSERT INTO slk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Veď Boh je Duch a tí, ktorí ho uctievajú, to majú robiť vedení Duchom a v plnej vážnosti.“ ");
INSERT INTO slk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","„Viem, že príde Mesiáš, (ktorý sa volá Kristus)“ povedala žena. „Keď príde, všetko nám vysvetlí.“ ");
INSERT INTO slk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","„To som ja: ten istý, čo sa s tebou rozpráva,“ povedal jej Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","V tej chvíli sa vrátili učeníci a boli prekvapení, keď zastihli Ježiša v rozhovore so ženou. Ale neodvážili sa spýtať, prečo sa s ňou zhovára, ani o čom sa zhovára. ");
INSERT INTO slk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Žena nechala vedro pri studni, rozbehla sa do mesta a každému oznamovala: ");
INSERT INTO slk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Poďte so mnou! Stretla som človeka, ktorý mi povedal všetko, čo som v živote urobila. Nemohol by byť práve on Mesiášom?“ ");
INSERT INTO slk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Obyvatelia mesta sa ihneď pobrali za Ježišom. ");
INSERT INTO slk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Medzitým ho učeníci ponúkali, aby sa najedol. ");
INSERT INTO slk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","On však odmietol: „Nebudem jesť. Mám na jedenie čosi, o čom vy nič neviete.“ ");
INSERT INTO slk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","„Priniesol mu azda niekto nejaké jedlo?“ spytovali sa učeníci jeden druhého. ");
INSERT INTO slk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","„Mojím pokrmom,“ povedal im Ježiš, „je konať vôľu toho, ktorý ma poslal, a dovŕšiť jeho dielo. ");
INSERT INTO slk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nazdávate sa, že žatva sa začne až o štyri mesiace, na sklonku leta? Rozhliadnite sa okolo seba! Obrovské lány obilia už dozrievajú. ");
INSERT INTO slk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","To sú ľudské duše pripravené na žatvu. Ten čo bude žať a zhromažďovať úrodu pre večnosť, dostáva už teraz svoju odmenu. A ten, čo rozsieval, sa bude radovať spolu s ním. ");
INSERT INTO slk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lebo je pravda to, čo sa hovorí: Jedni sejú a ďalší žnú. ");
INSERT INTO slk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ja som vás poslal žať tam, kde ste nesiali. Iní pred vami sa lopotili, a vy zbierate výsledky ich práce.“ ");
INSERT INTO slk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mnoho Samaritánov z toho mesta uverilo, že Ježiš je Mesiáš. Prijali totiž svedectvo ženy, ktorá im hovorila: „Povedal mi všetko, čo som robila.“ ");
INSERT INTO slk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Keď prišli za ním k studni, prosili ho, aby zostal v ich meste. Zdržal sa u nich dva dni. ");
INSERT INTO slk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vďaka slovám, ktoré im hovoril, uverili v neho aj mnohí ďalší. ");
INSERT INTO slk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vraveli žene: „Teraz už veríme nie preto, čo si nám povedala, ale sami sme počuli a presvedčili sme sa, že je naozaj Záchranca sveta.“ ");
INSERT INTO slk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Po dvoch dňoch, ktoré tam strávil, sa pobral do Galiley. ");
INSERT INTO slk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A hoci je známy jeho výrok: „Žiadneho proroka si neuctia tam, odkiaľ pochádza!“, ");
INSERT INTO slk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","tentoraz ho Galilejčania prijali s otvoreným náručím, lebo aj oni boli v Jeruzaleme na veľkonočných slávnostiach, a videli, čo tam vykonal. ");
INSERT INTO slk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Keď Ježiš prechádzal Galileou, znova zavítal do mestečka Kána, kde predtým premenil vodu na víno. Istý kráľovský úradník z mesta Kafarnaum, ktorý mal na smrť chorého syna, ");
INSERT INTO slk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa dozvedel, že sa Ježiš vrátil z Judska do Galiley. Vyhľadal ho v Káne a úpenlivo ho prosil, aby šiel s ním do Kafarnauma a uzdravil jeho umierajúceho syna. ");
INSERT INTO slk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","„Nikto z vás mi neuverí, kým neuvidíte znamenia a divy?“ spýtal sa ho Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","„Pane, prosím ťa, poď rýchlo, kým môj syn neumrie!“ naliehal úradník. ");
INSERT INTO slk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","„Môžeš ísť domov! Tvoj syn bude žiť!“ odpovedal mu Ježiš. Ten človek Ježišovi uveril a vybral sa domov. ");
INSERT INTO slk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Niektorí z jeho sluhov mu bežali oproti a zvestovali mu, že jeho syn žije a má sa lepšie. ");
INSERT INTO slk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Spýtal sa ich, kedy sa chlapcov stav zlepšil. Odpovedali mu: „Včera poobede okolo jednej mu zrazu klesla horúčka.“ ");
INSERT INTO slk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A tu si uvedomil, že sa to stalo presne v tej chvíli, keď mu Ježiš povedal: „Tvoj syn bude žiť.“ A úradník i všetci v jeho dome uverili, že Ježiš je Mesiáš. ");
INSERT INTO slk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Toto bolo druhé znamenie, ktoré Ježiš vykonal, keď prišiel z Judska do Galiley. ");
INSERT INTO slk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Potom sa Ježiš pobral do Jeruzalema, lebo bol práve židovský sviatok. ");
INSERT INTO slk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","V Jeruzaleme je neďaleko Ovčej brány vodná nádrž, židovsky nazývaná Betezda, lemovaná piatimi stĺporadiami. ");
INSERT INTO slk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pod týmito prístreškami ležali mnohí chorí: slepí, chromí a ochrnutí. Tí túžobne čakali kedy sa rozčerí hladina vody. ");
INSERT INTO slk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Z času na čas zostupoval totiž do rybníka anjel Pánov a rozvíril vodu. Prvý, kto vstúpil do rozvírenej vody, bol uzdravený, nech trpel akoukoľvek chorobou. ");
INSERT INTO slk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Medzi postihnutými ležal človek, ktorý bol chorý už tridsaťosem rokov. ");
INSERT INTO slk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Keď ho tam Ježiš uvidel ležať, a zistil, že je už tak dlho chorý, spýtal sa ho: „Túžiš vyzdravieť?“ ");
INSERT INTO slk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","„Pane,“ odpovedal chorý, „nemám nikoho, kto by mi pomohol dostať sa k nádrži, keď sa zvíri voda. Kým sa tam sám dostanem, zakaždým ma niekto predbehne.“ ");
INSERT INTO slk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ježiš mu odpovedal: „Vstaň, vezmi si rohož a môžeš ísť.“ ");
INSERT INTO slk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chorý bol v tej chvíli uzdravený: zvinul si rohož a pobral sa preč. V ten deň však bola sobota. ");
INSERT INTO slk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Židovský predstavitelia preto začali uzdraveného napomínať: „Je sobota, náš zákon ti zakazuje niesť svoju rohož.“ ");
INSERT INTO slk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","On im však povedal: „Muž, ktorý ma uzdravil, povedal: ‚Vezmi svoju rohož a môžeš ísť.‘ “ ");
INSERT INTO slk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","„A ktože ti povedal: ‚Vezmi svoju rohož a choď?‘ “ rozhorčovali sa. ");
INSERT INTO slk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","To uzdravený nevedel, lebo Ježiš sa vytratil v dave, ktorý sa tam zišiel. ");
INSERT INTO slk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Po nejakom čase ho Ježiš vyhľadal v chráme a povedal mu: „Vidíš, si zdravý. Ale už nehreš, aby ťa nepostihlo niečo horšie.“ ");
INSERT INTO slk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ten človek sa rozbehol za židovskými vodcami a oznámil im, že to bol Ježiš, kto ho uzdravil. ");
INSERT INTO slk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Židovský vodcovia začali na Ježiša útočiť, že také veci robí práve v sobotu. ");
INSERT INTO slk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ale Ježiš im odpovedal: „Môj Otec neprestajne koná pre dobro ľudí a ja robím to isté.“ ");
INSERT INTO slk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Po týchto slovách sa židovskí vodcovia ešte väčšmi usilovali zabiť ho. Dôvodom nebolo len znesväcovanie soboty, ale aj to, že hovoril o Bohu ako o svojom Otcovi, a tým sa robil rovným Bohu. ");
INSERT INTO slk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ježiš im však povedal: „Buďte si istí, že Syn nerobí nič sám od seba; robí len to, čo vidí robiť Otca. Lebo všetko, čo koná Otec, robí takisto aj Syn. ");
INSERT INTO slk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Veď Otec miluje Syna a zveruje sa mu so všetkým, čo robí. A ukáže mu, že má urobiť ešte väčšie veci, než tie, ktoré ste videli – a budete sa tomu čudovať. ");
INSERT INTO slk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Otec kriesi mŕtvych a dáva im život. Rovnako aj Syn dáva život podľa vlastného rozhodnutia. ");
INSERT INTO slk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A navyše, Otec sám nebude súdiť nikoho. Toto právo zveril Synovi, ");
INSERT INTO slk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aby všetci vzdali Synovi rovnakú úctu, akú vzdávajú Otcovi. Kto nepreukazuje úctu Synovi, nepreukazuje ju ani Otcovi, ktorý ho poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","„Uisťujem vás, že každý, kto berie vážne moje slová a dôveruje tomu, ktorý ma poslal, má večný život. Nebude odsúdený; prešiel zo smrti do života. ");
INSERT INTO slk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A slávnostne vyhlasujem, že príde čas, ba už je tu, keď mŕtvi budú počuť hlas Božieho Syna; a tí, čo ho vezmú vážne, budú žiť. ");
INSERT INTO slk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ako je Otec zdrojom života, tak aj Syna poveril, aby dával život ľuďom. ");
INSERT INTO slk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A dal mu aj právo súdiť, lebo on je Syn človeka. ");
INSERT INTO slk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nebuďte prekvapení; prichádza totiž čas, keď všetci mŕtvi budú počuť jeho hlas ");
INSERT INTO slk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a budú vzkriesení. Tí, čo konali dobro, vstanú do večného života, ale tí, čo neprestali konať zlo, vstanú a budú odsúdení.“ ");
INSERT INTO slk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","„Nič nerobím sám, nezávisle od Otca. Súdim len po porade s ním, preto súdim spravodlivo. Moja vôľa sa zhoduje s Otcovou, a tak nekonám podľa svojej vôle, ale podľa vôle toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ak by som bol sám sebe svedkom toho, kým som, moje svedectvo by nemalo žiadnu hodnotu. ");
INSERT INTO slk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ale je tu iný, ktorý svedčí o mne, a ja viem, že jeho svedectvo je dôveryhodné. ");
INSERT INTO slk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Vy sami ste poslali poslov k Jánovi, a to, čo o mne Ján povedal, bola pravda. ");
INSERT INTO slk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ja však nemusím stavať na ľudskom svedectve. O Jánovi hovorím len preto, že prijatím jeho posolstva môžete byť zachránení. ");
INSERT INTO slk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ján bol ako horiaca pochodeň, ktorá dáva svetlo a vy ste sa určitý čas radovali z jeho svetla. ");
INSERT INTO slk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ale je tu ešte jasnejšie svedectvo ako Jánovo, a to sú skutky, ktoré ma Otec poveril vykonať, tie sú dôkazom, že ma poslal Otec. ");
INSERT INTO slk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Sám Otec, ktorý ma poslal, vydal o mne svedectvo. Vy ste však nikdy nepočuli jeho hlas, ani nevideli jeho tvár, ");
INSERT INTO slk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","a jeho slovo vo vás nezostalo, lebo tomu, ktorého poslal, neveríte. ");
INSERT INTO slk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Skúmate Písmo a domnievate sa, že ak budete podľa neho žiť, získate večný život. Ale aj Písmo svedčí o mne. ");
INSERT INTO slk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Napriek tomu nechcete prísť ku mne, aby ste mali život. ");
INSERT INTO slk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nejde mi o ľudské uznanie, ");
INSERT INTO slk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ale poznám vás dobre a viem, že v skutočnosti Boha nemilujete. ");
INSERT INTO slk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Viem to, lebo som prišiel v mene svojho Otca, no odmietli ste ma prijať. Keby však niekto prišiel vo vlastnom mene, prijali by ste ho s nadšením. ");
INSERT INTO slk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nečudujem sa, že mi nemôžete uveriť, lebo vám väčšmi záleží na tom, aby ste sa páčili ľuďom ako Bohu. ");
INSERT INTO slk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A nemyslite si, že to budem ja, kto vás pred Otcom obžaluje. Vaším žalobcom bude Mojžiš, do ktorého ste vložili všetky svoje nádeje. ");
INSERT INTO slk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","No keby ste naozaj verili Mojžišovi, verili by ste aj mne, lebo on písal o mne. ");
INSERT INTO slk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ale keď neveríte jemu, ako by ste mohli veriť mojim slovám?“ ");
INSERT INTO slk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Potom sa Ježiš spolu s učeníkmi preplavil na druhý breh Galilejského jazera (ktoré sa nazýva aj Tiberiadské). ");
INSERT INTO slk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hrnuli sa za ním veľké zástupy, lebo v tom, ako uzdravoval chorých, videli Božie znamenie. ");
INSERT INTO slk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ježiš vystúpil na vrch a usadil sa na ňom aj so svojimi učeníkmi. ");
INSERT INTO slk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bolo krátko pred veľkonočnými sviatkami. ");
INSERT INTO slk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Keď sa Ježiš rozhliadol a uvidel veľké množstvo ľudí, ktorí sa k nemu blížili, opýtal sa Filipa: „Kde nakúpime toľko chleba, aby sa všetci tí ľudia najedli?“ ");
INSERT INTO slk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ježiš však už vedel, čo urobí a touto otázkou chcel len vyskúšať Filipovu vieru. ");
INSERT INTO slk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip mu odpovedal: „Ani keby sme nakúpili chlieb za dvesto denárov, nebolo by dosť, aby sa každému ušiel aspoň kúsok.“ ");
INSERT INTO slk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jeden z učeníkov, Šimonov brat Ondrej, povedal Ježišovi: ");
INSERT INTO slk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Je tu jeden chlapec, ktorý má päť jačmenných chlebov a dve ryby. Ale čože je to pre toľkých ľudí!“ ");
INSERT INTO slk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","„Povedzte, aby si všetci posadali!“ prikázal Ježiš učeníkom. Miesta bolo dosť a tak sa všetci usadili na trávnatom úbočí svahu. V zástupe bolo asi päťtisíc mužov. ");
INSERT INTO slk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ježiš vzal päť chlebov, poďakoval za ne Bohu, rozlámal ich a učeníci ich roznášali sediacim. Podobne urobil aj s rybami a každý dostal, koľko chcel. ");
INSERT INTO slk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Keď sa všetci najedli, prikázal učeníkom: „Pozbierajte všetko čo zostalo, aby nič nevyšlo nazmar!“ ");
INSERT INTO slk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nazbierali dvanásť košov zvyškov, ktoré zostali z pôvodných piatich chlebov. ");
INSERT INTO slk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","V tom, čo Ježiš urobil, ľudia videli Božie znamenie, a preto si hovorili: „To je akiste ten Prorok, ktorý má prísť!“ ");
INSERT INTO slk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ježiš vedel, o čom uvažujú i to, že sa ho chcú zmocniť a vyhlásiť ho za kráľa. Preto sa od nich vzdialil a opäť vyšiel až úplne na vrch, aby bol sám. ");
INSERT INTO slk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Keď sa zvečerilo, učeníci zišli k jazeru. ");
INSERT INTO slk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bola už tma a Ježiš za nimi ešte stále neprišiel. A tak nastúpili do loďky a plavili sa na druhý breh do Kafarnauma. ");
INSERT INTO slk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Onedlho sa strhol prudký vietor a hladina jazera sa rozbúrila. ");
INSERT INTO slk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Keď sa vzdialili päť či šesť kilometrov od brehu, zrazu zbadali Ježiša, ako kráča po mori a blíži sa k loďke. Učeníci sa však veľmi sa preľakli. ");
INSERT INTO slk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ježiš ich však upokojil: „Nebojte sa, to som ja!“ ");
INSERT INTO slk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pozvali ho, aby nastúpil do lode a čoskoro pristáli pri brehu, ku ktorému sa plavili. ");
INSERT INTO slk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zástup ľudí na protiľahlom brehu čakal na Ježiša až do rána. Vedeli, že Ježiš s učeníkmi nenastúpil do jedinej loďky, ktorú mali a neodplavil sa s nimi. ");
INSERT INTO slk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na miesto, kde Pán ďakoval za chlieb a nasýtil zástup, sa priplavilo na druhý deň niekoľko člnov z Tiberiady. ");
INSERT INTO slk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Keď ľudia zistili, že sa nedočkajú ani Ježiša, ani učeníkov, nasadli niektorí naspäť do svojich člnov a vybrali sa ho hľadať. Preplavili sa až do mesta Kafarnaum ");
INSERT INTO slk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","na druhom brehu jazera, kde Ježiša konečne našli. Opýtali sa ho: „Majstre, kedy si sa sem dostal?“ ");
INSERT INTO slk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ježiš im však povedal: „Pravda je takáto: Hľadáte nie preto, že by ste pochopili znamenia ktoré konám, ale len preto, lebo som vás včera nasýtil chlebom. ");
INSERT INTO slk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Prečo sa ustavične staráte iba o pominuteľné veci, o jedlo a pitie? Usilujte sa o pokrm, ktorý pretrvá pre večný život. Tento pokrm vám dá Syn človeka, ktorého tým poveril Boh, jeho Otec.“ ");
INSERT INTO slk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","„A čo máme robiť, aby sme konali to, čo od nás Boh očakáva?“ pýtali sa ho. ");
INSERT INTO slk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","„Boh od vás očakáva iba jedno,“ odpovedal im. „Verte v toho, ktorého poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Oni však vraveli: „Ak ti máme uveriť, musíš nám dať jasné znamenie. Čím nás chceš presvedčiť? ");
INSERT INTO slk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Keď naši otcovia putovali púšťou, dostávali mannu. Lebo o Mojžišovi je napísané: ‚Dal im chlieb z neba, aby ich nasýtil.‘ “ ");
INSERT INTO slk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ježiš im povedal: „Uisťujem vás: Nebol to Mojžiš, kto vám dával chlieb z neba. Je to môj Otec, ktorý vám dáva skutočný chlieb z neba. ");
INSERT INTO slk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tým chlebom od Boha je ten, ktorý zostupuje z neba a dáva ľuďom život.“ ");
INSERT INTO slk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","„Pane,“ prosili ho ľudia, „dávaj nám tento chlieb stále!“ ");
INSERT INTO slk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ježiš im povedal: „Ja som chlieb, ktorý dáva život. Kto príde ku mne a dôveruje mi, nebude už nikdy trpieť hladom ani smädom. ");
INSERT INTO slk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ale hoci ste počuli moje slová a videli ste moje činy, aj tak mi neveríte. ");
INSERT INTO slk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Každý, koho mi Otec zveril, prichádza ku mne a ja nikoho, kto ku mne prichádza, neodmietnem. ");
INSERT INTO slk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Lebo ja som zostúpil z neba, aby som robil nie to, čo chcem ja, ale aby som plnil vôľu toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A ten, ktorý ma poslal, si želá, aby som dával pozor na všetkých, ktorých mi zveril, aby som ich v deň svojho druhého príchodu vzkriesil k večnému životu. ");
INSERT INTO slk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","To, čo si môj otec naozaj želá je, aby každý, kto sa rozhodne pre Syna a uverí v neho, získal večný život a ja ho vzkriesim v posledný deň.“ ");
INSERT INTO slk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ľudí pobúrili jeho slová: „Ja som chlieb, ktorý zostúpil z neba.“ ");
INSERT INTO slk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A namietali: „Ako to? Vari to nie je Ježiš, Jozefov syn? Veľmi dobre poznáme jeho otca i matku! A on sa opovažuje tvrdiť nám: ‚Zostúpil som z neba.‘ “ ");
INSERT INTO slk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ježiš im povedal: „Nepohoršujte sa! ");
INSERT INTO slk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nikto sa nemôže stať mojím nasledovníkom bez toho, aby ho viedol Otec, ktorý ma poslal. A všetkých, ktorých mi dal, vzkriesim v posledný deň k večnému životu. ");
INSERT INTO slk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Veď jeden z prorokov napísal: ‚Boh bude hovoriť ku každému človeku.‘ Kto teda počúva Otca a dá sa ním poučiť, prichádza ku mne. ");
INSERT INTO slk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","To však neznamená, že by niekto Otca videl. Len ten, kto prišiel od Boha, ho naozaj videl. ");
INSERT INTO slk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Preto vám hovorím: Každý, kto mi verí, má večný život. ");
INSERT INTO slk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja som chlieb, ktorý dáva život. ");
INSERT INTO slk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vaši predkovia jedli na púšti mannu, a predsa zomreli. ");
INSERT INTO slk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Toto je však chlieb, ktorý zostúpil z neba. Kto z neho bude jesť, nezomrie. ");
INSERT INTO slk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja som chlieb, ktorý zostúpil z neba a dáva život. Ak sa niekto sýti týmto chlebom, bude žiť večným životom. Tým chlebom je moje telo a ja ho dám ako obeť, aby svet mohol žiť.“ ");
INSERT INTO slk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To vyvolalo medzi Židmi nový rozruch: „Vari nám môže dať tento tu jesť svoje telo? Ako?“ ");
INSERT INTO slk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ježiš im na to povedal: „Uisťujem vás: Ak nebudete jesť telo Syna človeka a piť jeho krv, nemáte večný život. ");
INSERT INTO slk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iba ten, kto je moje telo a pije moju krv, bude žiť naveky a ja ho vzkriesim v posledný deň. ");
INSERT INTO slk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Veď moje telo je tým pravým pokrmom a moja krv tým pravým nápojom. ");
INSERT INTO slk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kto je moje telo a pije moju krv, žije v jednote so mnou a ja v jednote s ním. ");
INSERT INTO slk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tak, ako môj život závisí od Otca, ktorý je zdrojom života a poslal ma sem, tak aj ja budem pre toho, kto mňa je, zdrojom života. ");
INSERT INTO slk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja som ten pravý chlieb, ktorý zostúpil z neba a každý, kto tento chlieb je, bude žiť naveky a neumrie, ako pomreli vaši otcovia, hoci jedli mannu.“ ");
INSERT INTO slk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Toto povedal Ježiš, keď učil v kafarnaumskej synagóge. ");
INSERT INTO slk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Keď to počuli Ježišovi nasledovníci, mnohí z nich povedali: „Čo sú to za nezmysly. To sa nedá počúvať!“ ");
INSERT INTO slk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ježiš postrehol, že sa jeho poslucháči rozhorčujú, a spýtal sa ich: „To vás pohoršuje? ");
INSERT INTO slk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A čo poviete, keď uvidíte Syna človeka vystupovať tam, kde bol predtým? ");
INSERT INTO slk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Život dáva len Boží Duch; ľudské úsilie človeku život nedá. Slová, ktoré som vám hovoril, sú z Ducha a prinášajú život. ");
INSERT INTO slk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Medzi vami sú však takí, ktorí mi neveria.“ Ježiš totiž od začiatku vedel, kto v neho verí, a vedel aj to, kto ho neskôr zradí. ");
INSERT INTO slk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A potom dodal: „Preto som vám povedal, že nikto nemôže ku mne prísť, lebo najprv musí sám dovoliť Otcovi, aby mu to umožnil.“ ");
INSERT INTO slk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Po týchto slovách sa mnohí od Ježiša odvrátili a už ho nenasledovali. ");
INSERT INTO slk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Vtedy sa Ježiš obrátil k dvanástim učeníkom: „Vy ma nechcete opustiť, však?“ ");
INSERT INTO slk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Šimon Peter mu odpovedal: „Pane, ku komu by sme šli? Iba tvoje slová prinášajú večný život. ");
INSERT INTO slk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","My sme uverili aj poznali, že si Kristus, Boží Syn.“ ");
INSERT INTO slk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ježiš im povedal: „Vari som si vás dvanástich nevyvolil ja sám? A i napriek tomu jedného z vás ovláda diabol.“ ");
INSERT INTO slk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Myslel tým Judáša, syna Šimona Iškariotského, ktorý ho zradil aj napriek tomu, že patril medzi Ježišových dvanástich učeníkov. ");
INSERT INTO slk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Potom Ježiš navštevoval jednotlivé miesta v Galilei. Nechcel sa zdržiavať v Judsku, lebo tam sa ho židovský vodcovia usilovali zabiť. ");
INSERT INTO slk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ale keď sa blížila slávnosť Stánkov, ");
INSERT INTO slk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","jeho bratia naňho naliehali: „Choď do Judska a ukáž svojim učeníkom, aké zázraky vieš robiť! ");
INSERT INTO slk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ak niekto chce, aby sa o ňom na verejnosti, nemôže svoje činy skrývať. Ak naozaj dokážeš konať zázraky, mal by si to všetkým ukázať.“ ");
INSERT INTO slk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Dokonca ani jeho bratia totiž neverili, že je Mesiáš. ");
INSERT INTO slk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ježiš im odpovedal: „Môj čas ešte nenastal. Vy však môžete ísť kdekoľvek, ");
INSERT INTO slk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","vás ľudia nemajú dôvod nenávidieť. Mňa však nenávidia, lebo ich usvedčujem z hriešnosti ich činov. ");
INSERT INTO slk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Choďte na sviatky sami, nebudem robiť, čo chcete vy; pôjdem, až príde ten správny čas.“ ");
INSERT INTO slk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A zostal ešte v Galilei. ");
INSERT INTO slk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Po odchode bratov sa však na sviatky pobral aj on: nie však verejne, ale tak, aby sa o tom nevedelo. ");
INSERT INTO slk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Židovskí vodcovia ho cez sviatky hľadali a vypytovali sa: „Kde je?“ ");
INSERT INTO slk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Medzi ľuďmi sa o ňom šírili všelijaké reči. Jedni vraveli: „Je to dobrý človek.“ Iní však hovorili: „Kdeže, iba ich vodí za nos.“ ");
INSERT INTO slk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nikto sa však neodvážil povedať o ňom svoju mienku nahlas, lebo sa báli židovských vodcov. ");
INSERT INTO slk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Zrazu uprostred sviatkov vstúpil Ježiš do chrámu a začal učiť. ");
INSERT INTO slk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Židovský vodcovia sa čudovali: „Ako to, že sa tak vyzná v Písme, keď na to nemá školy?“ ");
INSERT INTO slk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ježiš im odpovedal: „To, čo vás učím, pochádza od Boha, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Každý, kto túži konať Božiu vôľu, pozná, či moje slová pochádzajú od Boha, alebo či hovorím len sám za seba. ");
INSERT INTO slk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kto prináša svetu vlastné myšlienky, ten túži po tom, aby sa mu dostalo uznanie. Ale kto chce osláviť a zvelebiť toho, kto ho poslal, je úprimný a niet v ňom neprávosti. ");
INSERT INTO slk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nedal vám vari Mojžiš zákon? Nikto z vás však podľa neho nežije. Prečo ma chcete zabiť?“ ");
INSERT INTO slk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","„Čo si sa pomiatol na rozume? Kto ťa chce zabiť?“ ozývalo sa zo zástupu. ");
INSERT INTO slk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","„Urobil som v sobotu zázrak a vás to vyviedlo z miery,“ vysvetľoval Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","„A pritom vy takisto narúšate zákon. Mojžiš vám prikázal, aby ste svoje deti obrezávali ôsmy deň; tento príkaz pochádza nie od Mojžiša, ale už od praotcov. ");
INSERT INTO slk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ak neváhate vykonať obriezku, ak to pripadne na sobotu, aby ste neprestúpili Mojžišov zákon, prečo vás tak hnevá, že som v sobotu vrátil človeku zdravie? ");
INSERT INTO slk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Prestaňte vynášať povrchné súdy, ale súďte podľa toho, čo je skutočná pravda.“ ");
INSERT INTO slk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Niektorí z obyvateľov Jeruzalema sa spytovali: „Je to naozaj ten, ktorého chcú zabiť? ");
INSERT INTO slk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Káže verejne v chráme a nič mu nepovedia? Vari ho vodcovia začali predsa len pokladať za Mesiáša? ");
INSERT INTO slk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ale to predsa nemôže byť! O Mesiášovi vraj nikto nebude vedieť, odkiaľ prišiel, ale o Ježišovi vieme, odkiaľ prichádza.“ ");
INSERT INTO slk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tu zvolal Ježiš v chráme, takže ho všetci mohli počuť: „Poznáte ma a viete, odkiaľ som? Neprišiel som sám od seba, poslal ma ten, ktorému sa dá veriť. Vy ho však nepoznáte. ");
INSERT INTO slk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ja ho poznám, lebo od neho prichádzam a on ma k vám poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","V tej chvíli sa ho židovskí vodcovia chceli zmocniť, ale nik sa neopovážil vztiahnuť naňho ruku, lebo jeho čas ešte nenastal. ");
INSERT INTO slk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mnohí, ktorí ho v chráme počúvali, uverili v Ježiša ako Mesiáša a hovorili: „Vari by mal Mesiáš vykonať viac znamení od Boha ako tento človek?“ ");
INSERT INTO slk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Keď sa farizejom dostalo do uší, čo ľudia rozprávajú o Ježišovi, spolu s veľkňazmi poslali chrámovú stráž, aby ho zatkla. ");
INSERT INTO slk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ale Ježiš im povedal: „Zostanem s vami ešte nejaký čas a potom sa vrátim k tomu, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Keď odídem, budete ma hľadať, ale nenájdete ma. Kde som ja, tam sa vy nedostanete.“ ");
INSERT INTO slk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","„Kam chce tento človek odísť? Kde by sme ho nenašli?“ spytovali sa vodcovia ľudu posmešne. „Mieni azda odísť medzi židov, ktorí nežijú v Izraeli a učiť tam pohanov? ");
INSERT INTO slk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A čo znamenajú jeho slová: Budete ma márne hľadať. Lebo kde pôjdem ja, tam sa vy nedostanete?“ ");
INSERT INTO slk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","V posledný deň, keď slávnosť Stánkov vrcholila, Ježiš opäť vystúpil a hlasno zvolal: „Kto je smädný, nech príde ku mne a napije sa! ");
INSERT INTO slk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kto verí vo mňa, zakúsi, čo hovorí Písmo: ‚Prúd živej vody bude vytekať z jeho vnútra.‘ “ ");
INSERT INTO slk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hovoril o Svätom Duchu, ktorého mali prijať tí, ktorí v neho uveria. Dovtedy totiž Duch ešte nebol daný, lebo Ježiš ešte nebol oslávený. ");
INSERT INTO slk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Po týchto slovách sa zo zástupu ozývali hlasy: „To je určite ten Prorok!“ ");
INSERT INTO slk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ďalší hovorili: „Je to Mesiáš!“ Iní však namietali: „Vari by mohol Mesiáš pochádzať z Galiley! ");
INSERT INTO slk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Či nehovorí Písmo, že Mesiáš bude potomkom kráľa Dávida a narodí sa v mestečku Betleheme, z ktorého pochádzal i Dávid?“ ");
INSERT INTO slk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A tak sa napokon pre Ježiša pohádali. ");
INSERT INTO slk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Niektorí sa ho pokúšali zatknúť, ale nik sa neodhodlal naň siahnuť. ");
INSERT INTO slk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chrámová stráž sa vrátila k veľkňazom a farizejom bez neho. „Prečo ste ho nepriviedli?“ oborili sa na nich. ");
INSERT INTO slk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Stráže však vraveli: „Nikdy sme nikoho nepočuli hovoriť také veci.“ ");
INSERT INTO slk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farizeji im povedali: „Takže aj vy ste sa dali zviesť? ");
INSERT INTO slk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uveril v neho azda niekto z vodcov alebo z nás, farizejov?“ ");
INSERT INTO slk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","„Verí mu iba ten nevzdelaný dav, ktorý sa vôbec nevyzná v Zákone. Nech sú prekliaty!“ ");
INSERT INTO slk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jedným z tých farizejov bol aj Nikodém, ktorý pred časom navštívil Ježiša. Ten namietol: ");
INSERT INTO slk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Ako môžete odsúdiť človeka, ktorého ste predtým nevypočuli? Zodpovedá to azda nášmu Zákonu?“ ");
INSERT INTO slk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","„Nie si náhodou aj ty Galilejčan?“ spýtali sa ho. „Len čítaj Písmo a presvedčíš sa, že z Galiley prorok nepríde.“ ");
INSERT INTO slk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Po týchto slovách sa rozišli domov. ");
INSERT INTO slk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ježiš odišiel na Olivový vrch, ");
INSERT INTO slk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ale hneď na svitaní sa znova vrátil do chrámu. Všetci, čo prišli na chrámové nádvorie, sa zhromaždili okolo Ježiša. Sadol si a učil ich. ");
INSERT INTO slk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Onedlho učitelia Zákona a farizeji privliekli ženu pristihnutú pri cudzoložstve. Postavili ju všetkým na oči ");
INSERT INTO slk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","a povedali: „Učiteľ, túto ženu pristihli pri cudzoložstve. ");
INSERT INTO slk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mojžiš nám v zákone prikázal takéto ženy ukameňovať. A čo nám povieš ty?“ ");
INSERT INTO slk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bola to však pasca. Touto otázkou sa ho snažili vyprovokovať, aby povedal niečo, za čo by ho mohli obžalovať. Ale Ježiš sa zohol a písal prstom po zemi. ");
INSERT INTO slk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Keď neprestávali dobiedzať, vzpriamil sa a povedal: „Ten z vás, kto nikdy nezhrešil, nech do nej hodí kameň ako prvý.“ ");
INSERT INTO slk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A znova sa sklonil a písal po zemi. ");
INSERT INTO slk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Keď to počuli, začali sa jeden po druhom vytrácať – prví odišli starší, po nich aj ostatní. Nakoniec Ježiš zostal v strede nádvoria so ženou sám. ");
INSERT INTO slk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Vtedy sa opäť vzpriamil a spýtal sa jej: „Kde sú tvoji žalobcovia? Ani jeden ťa neodsúdil?“ ");
INSERT INTO slk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","„Nikto, pane,“ odpovedala. „Ani ja ťa neodsudzujem,“ povedal jej Ježiš. „Choď, ale už viac nehreš!“ ");
INSERT INTO slk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Potom znova prehovoril k zhromaždeným poslucháčom a povedal: „Ja som svetlo sveta. Kto ide za mnou, nebude blúdiť v tme, ale bude mať svetlo, ktoré vedie k ozajstnému životu.“ ");
INSERT INTO slk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","„Vystupuješ ako svoj vlastný svedok; tvoje svedectvo preto nemá žiadnu hodnotu!“ prerušili ho farizeji. ");
INSERT INTO slk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","„Moje svedectvo je pravdivé, aj keď hovorím sám o sebe,“ namietol Ježiš. „Lebo ja viem, odkiaľ som prišiel a kam idem. Vy však ani len netušíte odkiaľ som prišiel a kam idem. ");
INSERT INTO slk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vy súdite podľa ľudských meradiel, ja však takto nikoho neodsudzujem. ");
INSERT INTO slk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Keď ja súdim, môj súd je spravodlivý, lebo nesúdim sám, ale so mnou súdi aj môj Otec, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Vo vašom vlastnom zákone je napísané, že svedectvo je pravdivé, ak sa zhodnú vo výpovedi dvaja svedkovia. ");
INSERT INTO slk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Svedectvo o sebe vydávam ja sám a tým druhým svedkom je Otec, ktorý ma poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","„A kdeže je tvoj otec?“ spytovali sa ho. „Neviete ani kto som ja, ani kto je môj Otec,“ odpovedal im Ježiš. „Keby ste vedeli, kto naozaj som, poznali by ste aj môjho Otca.“ ");
INSERT INTO slk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tento rozhovor sa odohrával na chrámovom nádvorí pri pokladniciach, do ktorých ľudia dávali svoje dary. Ale nikto ho nezatkol, lebo ešte nenastal jeho čas. ");
INSERT INTO slk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ježiš sa im znova prihovoril: „Odídem od vás, vy ma budete hľadať, ale zomriete vo svojom hriechu. A tam, kam idem, nemôžete ísť.“ ");
INSERT INTO slk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","„Hádam si len nechce vziať život?“ vraveli si medzi sebou. „Prečo by inak vravel, že nemôžeme prísť tam, kam ide on?“ ");
INSERT INTO slk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ježiš im povedal: „Vy ste zdola a patríte tomuto svetu. Ja som zhora a nepatrím tomuto svetu. ");
INSERT INTO slk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","To je dôvod, prečo som vám povedal, že zomriete vo svojich hriechoch. Ak neuveríte, že JA SOM, zomriete vo svojich hriechoch.“ ");
INSERT INTO slk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","„Tak nám povedz, kto vlastne si!“ naliehali. „Ale veď vám o tom hovorím už od začiatku,“ odpovedal. ");
INSERT INTO slk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","„O vás by som mohol povedať mnoho, čo vás odsudzuje. No poviem vám iba to, čo mi povedal ten, ktorý ma poslal. A on je pravda sama.“ ");
INSERT INTO slk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ale nikto v tej chvíli nepochopil, že Ježiš hovorí o svojom Otcovi. ");
INSERT INTO slk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Preto na vysvetlenie doložil: „Keď pribijete Syna človeka na kríž, pochopíte, že JA SOM a že nič nekonám nezávisle od Otca, ale hovorím tak, ako ma to on naučil. ");
INSERT INTO slk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A ten, ktorý ma poslal, je so mnou. Neopustí ma, lebo robím to, čo sa mu páči.“ ");
INSERT INTO slk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Po týchto slovách mnohí v neho uverili. ");
INSERT INTO slk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Židovským vodcom, ktorí v neho uverili, Ježiš povedal: „Ak budete žiť podľa mojich slov, budete mojimi ozajstnými učeníkmi. ");
INSERT INTO slk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Poznáte pravdu a pravda vás oslobodí.“ ");
INSERT INTO slk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","„Ale veď my sme potomkovia Abraháma a nikdy sme neboli nikoho otrokmi. Prečo teda hovoríš, že budeme slobodní?“ namietali. ");
INSERT INTO slk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ježiš im odpovedal: „Pravda je taká, že každý, kto hreší, je otrokom hriechu. ");
INSERT INTO slk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Otrok nemá v rodine stále miesto. Iba syn je členom rodiny navždy. ");
INSERT INTO slk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ak vás teda Syn oslobodí, budete naozaj slobodní. ");
INSERT INTO slk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Viem, že ste Abrahámovi synovia, no napriek tomu ma chcete zabiť, pretože odmietate prijať moje slová. ");
INSERT INTO slk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ja vám hovorím, čo som videl u svojho Otca. Vy však konáte podľa toho, čo ste videli a počuli od vášho otca.“ ");
INSERT INTO slk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","„Naším otcom je Abrahám!“ ohradili sa. Ježiš im odpovedal: „Ak by ste boli Abrahámovými deťmi, konali by ste ako on. ");
INSERT INTO slk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vy ma však chcete zabiť. A pritom všetko, čo som vám hovoril, bola pravda, ktorú som počul od Otca. Abrahám by tak nekonal. ");
INSERT INTO slk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Robíte presne to, čo váš otec.“ Odsekli mu: „My sme sa nenarodili zo smilstva ako ty! Naším jediným otcom je sám Boh.“ ");
INSERT INTO slk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ježiš im povedal: „Keby bol naozaj Boh vaším otcom, milovali by ste ma. Ja som sem totiž prišiel od Boha. Neprišiel som sám od seba, ale z jeho poverenia. ");
INSERT INTO slk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Viete, prečo nechápete, čo vám hovorím? Lebo nemôžete zniesť moje slová. ");
INSERT INTO slk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Vaším otcom je diabol a vy chcete konať len to, po čom túži váš otec. Jeho lži od počiatku prinášajú smrť, lebo v ňom nie je žiadna pravda. Keď klame, robí to, čo je mu prirodzené: je to klamár a otec lži. ");
INSERT INTO slk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vy však mojim slovám neveríte, pretože ja hovorím pravdu! ");
INSERT INTO slk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Môže ma niekto z vás usvedčiť z nejakého hriechu? Prečo mi teda neveríte, keď hovorím pravdu? ");
INSERT INTO slk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kto patrí Bohu, ten rád prijíma Božie slovo. Vy však Bohu nepatríte, preto odmietate počuť jeho slová.“ ");
INSERT INTO slk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Židovskí vodcovia mu na to povedali: „Nevraveli sme správne, že si zradca, človek posadnutý zlým duchom?“ ");
INSERT INTO slk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","„Nie som posadnutý zlým duchom,“ odpovedal im Ježiš. „Ja len vzdávam česť svojmu Otcovi, ale vy ju odmietate vzdať mne. ");
INSERT INTO slk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Netúžim po tom, aby sa mi dostalo uznania. Je však niekto, komu záleží na tom, aby mi bola vzdaná česť. Odsúdi každého, kto mňa odmietne. ");
INSERT INTO slk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ale jedno je isté: kto prijíma moje slovo a podľa neho žije, nikdy neokúsi smrť.“ ");
INSERT INTO slk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Židia zvolali: „Teraz sme si istí, že si posadnutý démonom! Abrahám zomrel, aj proroci zomreli, a ty vravíš, že kto bude žiť podľa tvojho slova, nikdy neokúsi smrť. ");
INSERT INTO slk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Si azda väčší ako náš otec Abrahám, ktorý zomrel? Aj proroci zomreli. Kto si myslíš, že si?“ ");
INSERT INTO slk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ježiš im odpovedal: „Keby som chválil sám seba, nemalo by to nijakú cenu. Mne však preukazuje česť môj Otec, o ktorom tvrdíte, že je vaším Bohom. ");
INSERT INTO slk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Vy ste ho nikdy nepoznali, ale ja ho poznám dobre. Keby som to poprel, bol by som rovnaký luhár ako vy. Ale ja ho poznám a konám v súlade s jeho slovom. ");
INSERT INTO slk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Váš otec Abrahám túžil vidieť môj deň a keď ho uvidel, zaradoval sa.“ ");
INSERT INTO slk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","„Tak ty si videl Abraháma?“ pýtali sa ho židovský vodcovia, „veď nemáš ani len päťdesiat rokov!“ ");
INSERT INTO slk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","„Uisťujem vás,“ povedal Ježiš, „že skôr než sa Abrahám narodil, JA SOM.“ ");
INSERT INTO slk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vtom okamihu vzali kamene a chceli ho ukameňovať. Ježiš sa im však skryl a vytratil sa z chrámu. ");
INSERT INTO slk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cestou stretol človeka, ktorý bol od narodenia slepý. ");
INSERT INTO slk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","„Majstre, prečo sa narodil slepý?“ spytovali sa ho učeníci. „Je to následok jeho hriechu, alebo hriechu jeho rodičov?“ ");
INSERT INTO slk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","„Nehľadajte vinu ani uňho, ani u jeho rodičov,“ odpovedal Ježiš. „Je slepý, aby sa v jeho živote prejavila Božia moc. ");
INSERT INTO slk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kým ešte trvá deň, musíme konať dielo toho, ktorý ma poslal. Čoskoro nastane noc, keď sa už nebude dať robiť nič. ");
INSERT INTO slk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kým som na svete, som svetlo sveta.“ ");
INSERT INTO slk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Po týchto slovách napľul na zem, urobil zo slín a prachu blato, potrel ním slepému oči ");
INSERT INTO slk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a povedal mu: „Choď sa umyť k nádrži Siloe.“ (Siloe znamená Poslaný.) Slepý poslúchol, umyl sa, a keď sa vrátil, videl. ");
INSERT INTO slk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jeho susedia a tí, čo ho poznali ako slepého žobráka, sa čudovali: „Vari to nie je to ten, čo tu sedával a žobral?“ ");
INSERT INTO slk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jedni hovorili: „Je to on!“ Iní vraveli: „Nie je to on, len sa naňho podobá.“ Ale uzdravený povedal: „Áno, som to ja!“ ");
INSERT INTO slk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","„Ako to, že vidíš? Čo sa stalo?“ vyzvedali sa. ");
INSERT INTO slk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","On im odpovedal: „Nejaký človek menom Ježiš urobil blato, potrel mi ním oči blatom a povedal, aby som sa šiel umyť k nádrži Siloe. Išiel som teda, umyl som sa – a odvtedy vidím.“ ");
INSERT INTO slk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","„A nevieš, kde je teraz?“ spytovali sa ho. „Neviem,“ odpovedal im uzdravený. ");
INSERT INTO slk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Človeka, ktorý bol predtým slepý, priviedli k farizejom. ");
INSERT INTO slk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","V ten deň, keď Ježiš urobil blato a uzdravil slepého, bola totiž sobota. ");
INSERT INTO slk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farizeji sa ho podrobne vypytovali, ako sa mu vrátil zrak. A muž im to vyrozprával: „Ježiš mi potrel blatom oči, potom som sa umyl – a teraz vidím.“ ");
INSERT INTO slk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niektorí z farizejov vraveli: „Ten človek akiste nie je od Boha, keď nezachováva sobotu.“ „Ale ako by mohol hriešny človek urobiť také zázračné znamenia?“ vraveli iní. Strhla sa medzi nimi škriepka. ");
INSERT INTO slk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Znova sa teda obrátili na uzdraveného: „A čo si o ňom myslíš ty? Veď teba uzdravil.“ „Je to prorok,“ odpovedal im. ");
INSERT INTO slk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Farizeji však odmietali uveriť, že ten človek bol slepý a že sa mu vrátil zrak. Zavolali si teda jeho rodičov ");
INSERT INTO slk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","a spýtali sa ich: „Je to váš syn? A je pravda, že sa narodil slepý? Ako to, že teraz vidí?“ ");
INSERT INTO slk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Rodičia odpovedali: „Áno, je to náš syn a narodil sa nám slepý. To vieme určite. ");
INSERT INTO slk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ale ako sa stalo, že teraz vidí, to nevieme. A nevieme nič ani o tom, kto ho uzdravil. Opýtajte sa jeho, je už dospelý, nech vám to povie sám.“ ");
INSERT INTO slk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Rodičia odpovedali vyhýbavo, lebo sa báli židovských vodcov. Tí totiž rozhodli, že vylúčia zo židovskej obce každého, kto by uznal Ježiša za Mesiáša. ");
INSERT INTO slk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","To bol dôvod, prečo jeho rodičia povedali: „Je dospelý, opýtajte sa jeho.“ ");
INSERT INTO slk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A tak si znovu zavolali bývalého slepca a povedali mu: „Prisahaj pred Bohom, že hovoríš pravdu! My totiž vieme, že ten človek je hriešny.“ ");
INSERT INTO slk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","„Či je hriešny, alebo nie, to neviem,“ odpovedal uzdravený. „Jedno však viem: bol som slepý, no teraz vidím!“ ");
INSERT INTO slk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","„Ale ako ti vrátil zrak? Čo s tebou urobil?“ spytovali sa ho znova. ");
INSERT INTO slk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","„Veď som vám to všetko už vyrozprával a nepočúvali ste. Prečo to vlastne chcete znova počuť? Chcete sa azda aj vy stať jeho učeníkmi?“ ");
INSERT INTO slk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","„Ty si jeho učeník!“ zlostne sa naňho osopili. „My sme učeníci Mojžišovi. ");
INSERT INTO slk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","O Mojžišovi vieme, že sa s ním zhováral Boh, ale o tomto človeku nevieme ani len to, odkiaľ je.“ ");
INSERT INTO slk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","„To je naozaj čudné, že neviete nič o človeku, ktorý mi vrátil zrak!“ namietol uzdravený. ");
INSERT INTO slk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","„Každý predsa vie, že Boh prosby hriešnikov nepočuje, ale vypočuje toho, kto je bohabojný a žije podľa Božej vôle. ");
INSERT INTO slk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Čo svet svetom stojí, nikto nikdy nepočul, že by niekto vrátil zrak slepému od narodenia. ");
INSERT INTO slk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Keby toho človeka neposlal Boh, nič podobné by nemohol urobiť.“ ");
INSERT INTO slk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","„Si skrz-naskrz hriešny od svojho narodenia! Ty sa nás opovážiš poúčať?“ rozkričali sa naňho a vyhnali ho. ");
INSERT INTO slk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Keď sa Ježiš dozvedel, že ho vyhnali, vyhľadal uzdraveného a spýtal sa ho: „Veríš v Syna človeka?“ ");
INSERT INTO slk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","„Pane, povedz mi, kto to je? Rád by som v neho veril,“ odpovedal. ");
INSERT INTO slk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","„Vidíš ho pred sebou; práve sa s tebou zhovára,“ odpovedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","„Verím, Pane!“ zvolal a padol pred Ježišom na kolená. ");
INSERT INTO slk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","„Prišiel som na tento svet, aby som ho súdil,“ pokračoval Ježiš, „aby som otvoril oči tým, ktorí sú slepí, a aby som ukázal tým, čo sa domnievajú, že vidia, akí sú slepí.“ ");
INSERT INTO slk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Počuli to farizeji, čo stáli okolo, a spýtali sa ho: „Čože? Vari sme tiež slepí?“ ");
INSERT INTO slk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ježiš im odpovedal: „Keby ste boli naozaj slepí, boli by ste bez viny. Vy však hovoríte ‚Vidíme‘, a preto zostávate v hriechu.“ ");
INSERT INTO slk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Uisťujem vás, že kto nevchádza do košiara bránou, ale prelieza cez ohradu, je určite zlodej a lupič. ");
INSERT INTO slk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pastier vchádza k svojim ovciam cez bránu. ");
INSERT INTO slk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Strážnik otvára dvere iba jemu a ovce ho poznajú po hlase. Potom volá ovce po mene von z košiara. ");
INSERT INTO slk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Keď tie, ktoré mu patria vyvedie von, kráča pred nimi a ovce idú za ním, lebo poznajú jeho hlas. ");
INSERT INTO slk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Za cudzím človekom by nešli, ale utiekli by od neho, lebo jeho hlas nepoznajú.“ ");
INSERT INTO slk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Poslucháči nepochopili toto Ježišovo prirovnanie, ");
INSERT INTO slk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","a tak im ho vysvetlil: „Verte mi, ja som pre ovce bránou. ");
INSERT INTO slk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Všetci, čo prišli predo mnou, sú zlodeji a lupiči. Ale ovce ich neposlúchli. ");
INSERT INTO slk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja som brána. Kto cezo mňa vojde, bude zachránený, bude mať prežívať pokoj a bude mať dostatok. ");
INSERT INTO slk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zlodej prichádza len preto, aby kradol, zabíjal a ničil. Ja som však prišiel preto, aby mali život, a prežívali ho v plnosti. ");
INSERT INTO slk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja som dobrý pastier. Dobrý pastier je ten, kto za svoje ovce aj život obetuje. ");
INSERT INTO slk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ten, komu ovce nepatria a pasie ich len za mzdu, keď vidí prichádzať vlka, utečie. Vlk potom ovce napadne a rozoženie ich. ");
INSERT INTO slk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tomu, kto je najatý za mzdu, na ovciach nezáleží a preto utečie. ");
INSERT INTO slk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ja som dobrý pastier, poznám svoje ovce a ony poznajú mňa; ");
INSERT INTO slk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","rovnako aj môj Otec pozná mňa a ja poznám Otca. A za svoje ovce položím aj svoj život. ");
INSERT INTO slk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mám aj iné ovce, ktoré ešte nepatria do tohto košiara. Aj tie musím priviesť. Budú počuť môj hlas a stanú sa jedným stádom a budú mať jedného pastiera. ");
INSERT INTO slk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Otec ma miluje, lebo dávam svoj život, aby som ho znova získal. ");
INSERT INTO slk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nikto mi ho neberie, dávam ho dobrovoľne. Mám právo svoj život dať a mám právo ho opäť prijať. Taký príkaz som dostal od svojho Otca.“ ");
INSERT INTO slk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tieto slová opäť vyvolali medzi židovskými vodcami roztržku. ");
INSERT INTO slk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Niektorí vraveli: „Je posadnutý zlým duchom. Úplne sa zbláznil. Prečo ho vôbec počúvate?“ ");
INSERT INTO slk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ale iní namietali: „Posadnutý človek by takto nehovoril; a môže vôbec zlý duch otvoriť oči slepým?“ ");
INSERT INTO slk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Boli práve sviatky vysvätenia jeruzalemského chrámu. Bolo to v zime. ");
INSERT INTO slk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ježiš sa v chráme prechádzal pomedzi Šalamúnovo stĺporadie. ");
INSERT INTO slk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Vtedy ho obstúpili židovskí vodcovia a vyzvali ho: „Dokedy nás chceš napínať? Ak si Mesiáš, povedz nám to otvorene!“ ");
INSERT INTO slk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","„Už som vám to neraz povedal, ale vy mi neveríte,“ odpovedal im. „Moje činy vydávajú svedectvo o tom, že som Mesiáš. Veď ich konám z Božieho poverenia. ");
INSERT INTO slk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Neveríte mi, lebo nepatríte medzi moje ovce. ");
INSERT INTO slk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Moje ovce počúvajú, čo hovorím, ja ich poznám a ony idú za mnou. ");
INSERT INTO slk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dávam im večný život, nikdy nezahynú a nikto ich z mojej ruky nevytrhne. ");
INSERT INTO slk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dal mi ich môj Otec a on je mocnejší ako akákoľvek mocnosť, preto ich nik nemôže vytrhnúť z jeho ruky. ");
INSERT INTO slk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ja a Otec sme jedno.“ ");
INSERT INTO slk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Po týchto slovách začali židovskí vodcovia zbierať kamene a chceli ho ukameňovať. ");
INSERT INTO slk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","„Z Božieho poverenia som vykonal veľa dobrých činov. Pre ktorý z nich ma chcete ukameňovať?“ spýtal sa Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","„Nechceme ťa zabiť pre tvoje činy, ale preto, že sa rúhaš. Ty, obyčajný človek, sa vyhlasuješ za Boha,“ vraveli mu Židia. ");
INSERT INTO slk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ježiš im odvetil: „Nie sú vari vo vašom Zákone zapísané Božie slová: ‚Povedal som: Ste bohovia?‘ ");
INSERT INTO slk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ak Boh nazýva bohmi tých, ktorým adresoval svoje slová – a Písmo musí platiť –, ");
INSERT INTO slk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","prečo obviňujete mňa, ktorého Otec posvätil a poslal na svet, že sa rúham, keď som povedal: ‚Som Boží Syn?‘ ");
INSERT INTO slk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ak nekonám to, čo môj Otec, neverte mi; ");
INSERT INTO slk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ale ak konám ako môj Otec a vy mi neveríte, verte aspoň skutkom, ktoré konám, a presvedčte sa, že Otec je vo mne a ja v Otcovi.“ ");
INSERT INTO slk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vtedy sa ho opäť chceli zmocniť, ale unikol im. ");
INSERT INTO slk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Odišiel na druhý breh Jordánu a zdržiaval sa na mieste, kde predtým Ján krstil. ");
INSERT INTO slk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mnohí prichádzali za Ježišom a vraveli: „Ján síce neurobil nijaké znamenie, ale všetko, čo hovoril o tomto mužovi, je pravda.“ ");
INSERT INTO slk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A mnohí z tých, čo tam boli, v Ježiša uverili. ");
INSERT INTO slk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Muž, ktorý sa volal Lazár ochorel. Pochádzal z dediny Betánia, v ktorej bývali aj jeho sestry Mária a Marta. ");
INSERT INTO slk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Bola to tá Mária, ktorá natrela vzácnym olejom Ježišove nohy a svojimi vlasmi ich vyutierala. Jej brat Lazár bol teraz chorý.) ");
INSERT INTO slk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sestry poslali Ježišovi odkaz: „Pane, tvoj milovaný priateľ je ťažko chorý.“ ");
INSERT INTO slk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Keď sa to Ježiš dozvedel, povedal: „Neochorel preto, aby zomrel, ale aby sa prejavila Božia moc a ukázala sa sláva Syna Božieho.“ ");
INSERT INTO slk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ježiš mal veľmi rád obe sestry i Lazára. ");
INSERT INTO slk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ježiš teda zostal ešte dva dni na mieste, kde ho zastihla správa o Lazárovej chorobe. ");
INSERT INTO slk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Až potom vyzval svojich učeníkov: „Vráťme sa do Judska.“ ");
INSERT INTO slk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jeho učeníci namietali: „Majstre, veď len nedávno ťa tam chceli židovskí vodcovia ukameňovať, a ty sa tam mieniš vrátiť?“ ");
INSERT INTO slk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","„Vari nesvieti slnko cez deň dvanásť hodín? Kto chodí za vidna, nemusí sa báť, že sa potkne, lebo svetlo tohto sveta mu osvetľuje cestu. ");
INSERT INTO slk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ale keď niekto kráča v noci, potkýna sa, lebo svetlo mu neosvecuje cestu.“ ");
INSERT INTO slk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Potom dodal: „Náš priateľ Lazár zaspal a ja ho idem zobudiť.“ ");
INSERT INTO slk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","„Pane, ak spí, čoskoro sa uzdraví,“ povedali mu učeníci. ");
INSERT INTO slk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ježiš však hovoril o jeho smrti – i keď učeníci sa nazdávali, že hovorí o obyčajnom spánku. ");
INSERT INTO slk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Preto im povedal jasne: „Lazár zomrel. ");
INSERT INTO slk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","A ja som rád, že som nebol pri ňom. Takto máte možnosť naučiť sa viac mi dôverovať. Je to pre vaše dobro. Poďme k nemu!“ ");
INSERT INTO slk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomáš, prezývaný Dvojča, povedal ostatným učeníkom: „Poďme aj my, nech zomrieme spolu s ním!“ ");
INSERT INTO slk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Keď prišli do Betánie, Ježiš zistil, že Lazár je už štyri dni pochovaný. ");
INSERT INTO slk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betánia bola neďaleko Jeruzalema (asi tri kilometre), ");
INSERT INTO slk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a tak mnohí známi z mesta prišli potešiť Máriu a Martu v ich žiali za bratom. ");
INSERT INTO slk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Keď sa Marta dozvedela, že prichádza Ježiš, bežala mu oproti, ale Mária zostala doma. ");
INSERT INTO slk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta privítala Ježiša slovami: „Pane, keby si bol tu, môj brat by nezomrel. ");
INSERT INTO slk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ale ja viem, že i teraz ti Boh dá, o čokoľvek ho poprosíš.“ ");
INSERT INTO slk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ježiš jej povedal: „Tvoj brat bude opäť žiť.“ ");
INSERT INTO slk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","„Viem, že ožije pri vzkriesení v posledný deň,“ prisvedčila Marta. ");
INSERT INTO slk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","„Ja som vzkriesenie a život!“ povedal jej Ježiš. „Kto vo mňa verí, bude žiť, aj keby zomrel. ");
INSERT INTO slk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A kto žije a verí vo mňa, nezomrie večnou smrťou. Veríš tomu, Marta?“ ");
INSERT INTO slk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","„Áno, Pane,“ odpovedala. „Uverila som, že si Mesiáš, Boží Syn, ktorý mal prísť na svet.“ ");
INSERT INTO slk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Po tých slovách sa vrátila a zavolala si bokom svoju sestru Máriu. „Učiteľ je tu,“ povedala jej, „a volá ťa.“ ");
INSERT INTO slk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Keď to Mária počula, ihneď vstala a bežala k nemu. ");
INSERT INTO slk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Ježiš ešte nevošiel do dediny – bol na tom istom mieste, kde sa s ním stretla Marta.) ");
INSERT INTO slk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Keď ľudia, ktorí utešovali Máriu, videli, ako náhlivo vybehla z domu, pobrali sa za ňou, lebo si mysleli, že sa šla vyplakať na Lazárov hrob. ");
INSERT INTO slk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Len čo Mária došla k Ježišovi, padla pred ním na kolená a nariekala: „Pane, keby si bol tu, môj brat by nezomrel!“ ");
INSERT INTO slk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Keď Ježiš videl jej slzy i plač tých, čo prišli s ňou, hlboko sa ho to dotklo a rozľútostene sa ich opýtal: ");
INSERT INTO slk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","„Kde ste ho pochovali?“ „Pane, poď a uvidíš,“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Vtedy sa rozplakal aj Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","„Pozrite, ako ho mal rád!“ šepkali si medzi sebou. ");
INSERT INTO slk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Niektorí z nich však povedali: „Keď vedel uzdraviť slepého, nemohol zachrániť Lazára pred smrťou?“ ");
INSERT INTO slk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ježiš sa znova zachvel a vykročil k hrobu. Bola to jaskyňa a vstupu do nej bránil veľký kameň. ");
INSERT INTO slk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","„Odvaľte ten kameň!“ rozkázal Ježiš. Ale Marta, sestra mŕtveho Lazára, povedala: „Pane, pochovali sme ho pred štyrmi dňami. Jeho telo je už určite v rozklade!“ ");
INSERT INTO slk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","„Vari som ti nepovedal, že ak budeš veriť, uvidíš Božiu slávu?“ pripomenul jej Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Vtedy odvalili kameň. Ježiš pozdvihol svoj pohľad k nebu a modlil sa: „Otče, ďakujem ti, že si ma vypočul. ");
INSERT INTO slk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ja viem, ty ma vždy počuješ, ale povedal som to kvôli ľuďom, ktorí stoja okolo, aby uverili, že si to ty, kto ma poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Potom nahlas zvolal: „Lazár, poď von!“ ");
INSERT INTO slk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A Lazár vyšiel. Ruky aj nohy mal ovinuté plátnom, v ktorom bol pochovaný, a tvár mal prikrytú šatkou. Ježiš im povedal: „Zložte mu to, nech môže odísť!“ ");
INSERT INTO slk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mnohí z tých, čo prišli za Máriou, boli svedkami zázraku, ktorý Ježiš vykonal, a uverili v neho. ");
INSERT INTO slk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ale niektorí sa ponáhľali rýchlo oznámiť farizejom, čo Ježiš urobil. ");
INSERT INTO slk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tí spolu s najvyššími kňazmi ihneď zvolali zasadnutie veľrady. „Čo len budeme robiť?“ spytovali sa bezradne. „Veď ten človek skutočne robí zázraky! ");
INSERT INTO slk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ak proti nemu nezakročíme, všetci v neho uveria! A potom sa môže stať, že Rimania zničia chrám aj celý náš národ!“ ");
INSERT INTO slk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","No tu sa prihlásil o slovo Kaifáš, ktorý bol v tom čase veľkňazom: „Vari vôbec nerozmýšľate? ");
INSERT INTO slk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nepochopili ste, že je pre vás lepšie, aby zomrel jeden človek namiesto všetkých, než aby bol kvôli jednému človeku zničený celý národ?“ ");
INSERT INTO slk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A aj keď Kaifáš ako veľkňaz vyslovil tie slová s iným zámerom, vyzneli ako proroctvo, že Ježiš má byť obetovaný za národ. ");
INSERT INTO slk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A nielen za jeho národ, ale aj za všetky Božie deti, ktoré žijú po celom svete, aby sa stali jednou rodinou. ");
INSERT INTO slk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","V ten deň sa židovskí vodcovia pevne rozhodli, že ho zabijú. ");
INSERT INTO slk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Preto sa Ježiš prestal verejne pohybovať po Judei a utiahol sa aj s učeníkmi do mesta Efraim na okraji púšte. ");
INSERT INTO slk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Opäť sa priblížila Veľká noc. Ľudia z celej krajiny putovali do Jeruzalema, aby ešte pred hlavnými sviatkami mohli vykonať predpísané očistné obrady. ");
INSERT INTO slk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Snažili sa nájsť Ježiša a pýtali sa jeden druhého: „Čo myslíte? Príde na sviatky?“ ");
INSERT INTO slk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Najvyšší kňazi a farizeji totiž vydali rozkaz, že každý, kto by vedel, kde sa Ježiš zdržiava, musí to oznámiť, aby ho mohli zatknúť. ");
INSERT INTO slk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Šesť dní pred Veľkou nocou sa Ježiš vrátil do Betánie, kde žil Lazár, ktorého vzkriesil z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na Ježišovu počesť pripravili slávnostnú večeru. Marta obsluhovala pri stole, zatiaľ čo Lazár bol medzi tými, čo sedeli s Ježišom pri stole. ");
INSERT INTO slk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mária vzala nádobu s drahým olejom vyrobeným z nardu, natierala ním Ježišovi nohy a utierala ich vlastnými vlasmi. Vôňa nardu naplnila celý dom. ");
INSERT INTO slk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jeden z učeníkov – Judáš Iškariotský, ktorý Ježiša neskôr zradil – poznamenal: ");
INSERT INTO slk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Prečo sa taký vzácny olej radšej nepredal? Mohlo sa zaň získať tristo denárov a peniaze sa mohli rozdať chudobným.“ ");
INSERT INTO slk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ale nepovedal to preto, že by mu záležalo na chudobných, ale že bol zlodej. Mal totiž na starosti spoločnú pokladnicu a neraz si z nej vzal niečo pre seba. ");
INSERT INTO slk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ježiš mu na to povedal: „Nechaj ju, odložila si to na deň môjho pohrebu. ");
INSERT INTO slk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chudobných budete mať medzi sebou vždy, ale ja s vami nebudem stále.“ ");
INSERT INTO slk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Keď sa rozchýrilo, že Ježiš je v Betánii, pobrali sa za ním z Jeruzalema celé zástupy. Neprišli však len kvôli nemu, ale aj preto, aby videli vzkrieseného Lazára. ");
INSERT INTO slk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Preto sa veľkňazi uzniesli, že zabijú aj Lazára: ");
INSERT INTO slk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mnohí ľudia ich totiž začali odmietať a uverili Ježišovi. ");
INSERT INTO slk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na druhý deň sa po celom Jeruzaleme, v ktorom bolo už aj mnoho ľudí, čo prišli na sviatky, rozniesla správa, že do mesta prichádza Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ľudia nalámali palmové konáre a nadšene volali: „Hosana! Nech Boh požehná toho, ktorý prichádza v jeho mene! Nech Boh požehná kráľa Izraela!“ ");
INSERT INTO slk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ježiš vstúpil do mesta na oslíkovi, tak ako je napísané: ");
INSERT INTO slk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Nebojte sa, ľudia Jeruzalema. Váš kráľ prichádza. Skromne sa nesie na osľati.“ ");
INSERT INTO slk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ježišovi učeníci si vtedy túto súvislosť neuvedomili. Až potom, keď bol Ježiš oslávený, pochopili, že sa vtedy pred ich očami naplnilo to, čo o ňom bolo napísané. ");
INSERT INTO slk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","V zástupe boli svedkovia toho, ako Ježiš zavolal Lazára z hrobu a vzkriesil ho z mŕtvych. Teraz o tom hovorili ostatným. ");
INSERT INTO slk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aj správy o tomto znamení spôsobili, že ho prišlo vítať mnoho ľudí. ");
INSERT INTO slk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Keď to videli farizeji, hovorili jeden druhému: „Vidíte to? S tým si neporadíme! Pozrite! Celý svet ide za ním!“ ");
INSERT INTO slk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Medzi tými, čo prišli do Jeruzalema na blížiaci sa sviatok, aby sa poklonili Bohu, boli aj Gréci. ");
INSERT INTO slk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Obrátili sa na Ježišovho učeníka Filipa, ktorý bol z Betsaidy v Galilei a poprosili ho: „Pane, chceli by sme vidieť Ježiša!“ ");
INSERT INTO slk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip to šiel povedať Ondrejovi a potom to spolu oznámili Ježišovi. ");
INSERT INTO slk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ježiš im povedal: „Nastal čas, keď má byť Syn človeka oslávený. ");
INSERT INTO slk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Počúvajte pozorne: Ak pšeničné zrno nepadne do pôdy a nezomrie, neprinesie úžitok a zostane samo. Ak však zomrie, prinesie mnoho úžitku. ");
INSERT INTO slk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kto žije len pre seba, príde o svoj život. Ale ten, kto žije pre druhých ľudí, o svoj život nepríde – získa večný život. ");
INSERT INTO slk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ak mi chce niekto slúžiť, musí ma nasledovať, lebo moji služobníci musia ísť tou istou cestou ako ja. Takému služobníkovi prejaví česť aj môj Otec.“ ");
INSERT INTO slk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","„Moju dušu teraz zviera úzkosť. Mám preto azda poprosiť: ‚Otče, zachráň ma pred tým, čo ma čaká?‘ Ale veď práve preto som prišiel. ");
INSERT INTO slk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Otče, osláv svoje meno!“ A vzápätí zaznel hlas z neba: „Už som oslávil a ešte oslávim!“ ");
INSERT INTO slk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ježiš v tej chvíli stál uprostred veľkého zástupu. Niektorí tvrdili, že zahrmelo, iní sa nazdávali, že to k nemu prehovoril anjel. ");
INSERT INTO slk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","„Hlas, ktorý ste počuli, nezaznel kvôli mne, ale kvôli vám!“ povedal Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","„Teraz prebieha súd nad týmto svetom. Satan, vládca tohto sveta, bude vyhnaný. ");
INSERT INTO slk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ale keď ja budem vyvýšený zo zeme, všetkých pritiahnem k sebe.“ ");
INSERT INTO slk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Týmito slovami Ježiš naznačil, akou smrťou zomrie.) ");
INSERT INTO slk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zástup mu odporoval: „Zo Zákona sme sa predsa dozvedeli, že Mesiáš má zostať naveky. Prečo teda hovoríš, že Syn človeka musí byť vyvýšený? A kto je vlastne ten Syn človeka?“ ");
INSERT INTO slk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ježiš im na to povedal: „Ešte malú chvíľu bude svetlo medzi vami. Žite vo svetle, kým ešte svieti, aby vás nezastihla tma. Ten, kto kráča potme, nevie, kam ide. ");
INSERT INTO slk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dôverujte tomu svetlu, kým je ešte s vami, aby z vás svietilo ďalej, až tu nebude.“ Po týchto slovách sa Ježiš vytratil zo zástupu a skryl sa pred nimi. ");
INSERT INTO slk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Napriek všetkým tým znameniam, ktoré Ježiš urobil, ľudia mu ešte stále neuverili. ");
INSERT INTO slk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tak sa potvrdili slová proroka Izaiáša: „Pane, kto uveril našim slovám? Kto poznal Božiu moc?“ ");
INSERT INTO slk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Prorok Izaiáš ďalej ukazuje, aký bol dôsledok ich nevery. ");
INSERT INTO slk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Boh im oslepil oči a zatvrdil srdce, preto očami nevidia, ich srdcia nechápu a neobrátia sa ku mne, aby som im pomohol.“ ");
INSERT INTO slk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","To povedal Izaiáš, pretože videl Jeho slávu. ");
INSERT INTO slk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A predsa aj medzi židovskými vodcami boli mnohí, ktorí v neho uverili. Verejne sa však k nemu nepriznali, lebo sa báli, že ich farizeji vylúčia zo synagógy. ");
INSERT INTO slk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Viac im totiž záležalo na sláve, ktorej sa im dostávalo od ľudí, než na sláve, ktorú im chcel dať Boh. ");
INSERT INTO slk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ježiš hlasno zvolal: „Kto verí vo mňa, neverí len vo mňa, ale aj v toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","A kto mňa vidí, vidí toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Prišiel som na svet ako svetlo, aby ten, kto vo mňa verí, nezostal v tme. ");
INSERT INTO slk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kto počuje moje slová, ale nekoná podľa nich, toho nesúdim. Neprišiel som na svet, aby som ho súdil, ale zachránil. ");
INSERT INTO slk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kto mňa odmieta a nežije podľa mojich slov, ten už má svojho sudcu: moje slová ho budú súdiť v posledný deň. ");
INSERT INTO slk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nehovoril som zo svojej vlastnej moci; hovorím len to, čo mi prikázal Otec, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A jeho prikázanie vedie k večnému životu. A tak vám hovorím len to, čo mi povedal Otec.“ ");
INSERT INTO slk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","V predvečer sviatkov Paschy Ježiš vedel, že nastal čas, aby opustil tento svet a odišiel k Otcovi. Tak veľmi miloval tých, ktorí ho nasledovali, že im prejavoval lásku až do konca. ");
INSERT INTO slk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pri večeri, keď už diabol vnukol Judášovi, synovi Šimona Iškariotského, aby ho zradil, ");
INSERT INTO slk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","a keď si bol Ježiš vedomý, že Otec všetko zveril do jeho rúk a že od Boha prišiel a k nemu sa teraz vracia, ");
INSERT INTO slk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","vstal od večere, odložil si vrchný odev, vzal uterák a prepásal sa ním. ");
INSERT INTO slk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Potom nalial vodu do umývadla a začal učeníkom umývať a utierať nohy. ");
INSERT INTO slk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Keď prišiel k Šimonovi Petrovi, ten mu povedal: „Pane, vari chceš ty umyť moje nohy?“ ");
INSERT INTO slk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ježiš mu odpovedal: „Teraz nechápeš, prečo to robím, ale neskôr to pochopíš.“ ");
INSERT INTO slk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","„Nikdy nedovolím, aby si mi umyl nohy!“ vyhlásil Peter. „Ale ak ťa neumyjem, nebudeš mať so mnou podiel!“ odpovedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","„Pane, tak mi umy nielen nohy, ale aj ruky a hlavu!“ zvolal Peter. ");
INSERT INTO slk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","„Kto sa vykúpal, je celý čistý,“ odpovedal mu Ježiš. „Stačí mu iba zmyť prach z nôh. Aj vy ste čistí, ale nie všetci!“ ");
INSERT INTO slk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Ježiš totiž vedel, kto ho zradí. Preto povedal: „Nie všetci ste čistí.“) ");
INSERT INTO slk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Keď im umyl nohy, opäť si obliekol vrchný odev, vrátil sa k stolu a spýtal sa ich: „Chápete, čo som urobil? ");
INSERT INTO slk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oslovujete ma Majster a Pane a vravíte správne, lebo ním naozaj som. ");
INSERT INTO slk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ak som vám teda ja, váš Majster a Pán, umyl nohy, aj vy ste povinní takto si navzájom umývať nohy. ");
INSERT INTO slk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dal som vám príklad, aby ste konali tak ako ja. ");
INSERT INTO slk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Uisťujem vás, že žiadny sluha nie je dôležitejší ako jeho pán a ani posol nie je dôležitejší ako ten, čo ho poslal. ");
INSERT INTO slk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ak to viete, budete šťastní, keď podľa toho budete aj konať. ");
INSERT INTO slk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","To, čo som povedal, neplatí o vás všetkých. Ja viem, ktorých som si vyvolil. Ale má sa naplniť výrok Písma: ‚Ten, ktorý jedáva so mnou chlieb, stane sa mojím nepriateľom.‘ ");
INSERT INTO slk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vravím vám to už teraz, aby ste potom, keď sa to stane, uverili, že JA SOM. ");
INSERT INTO slk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Uisťujem vás, že kto prijíma toho, koho pošlem, mňa prijíma. A kto prijíma mňa, prijíma toho, ktorý mňa poslal.“ ");
INSERT INTO slk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Po týchto slovách Ježiša zovrela úzkosť a otvorene im povedal: „Hovorím vám pravdu, jeden z vás ma zradí.“ ");
INSERT INTO slk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Učeníci sa v rozpakoch pozerali jeden na druhého, pretože netušili, o kom hovorí. ");
INSERT INTO slk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Po Ježišovom boku, opretý o jeho hruď, sedel učeník, ktorého mal Ježiš veľmi rád. ");
INSERT INTO slk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tomu dal Šimon Peter pokyn, aby sa spýtal, o kom to hovorí. ");
INSERT INTO slk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naklonil sa teda bližšie k Ježišovi a spýtal sa ho: „Pane, kto je to?“ ");
INSERT INTO slk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","„Je to ten, pre ktorého namočím kúsok chleba a podám mu ho,“ povedal Ježiš. Namočil chlieb a podal ho Judášovi, synovi Šimona Iškariotského. ");
INSERT INTO slk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Keď vzal Judáš chlieb, vstúpil doňho satan. Vtedy mu Ježiš povedal: „To, čo chceš urobiť, urob rýchlo!“ ");
INSERT INTO slk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","No nik pri stole nechápal, prečo mu to hovorí. ");
INSERT INTO slk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Keďže Judáš mal na starosti spoločnú pokladnicu, niektorí sa domnievali, že ho posiela nakúpiť veci potrebné na sviatky, alebo dať niečo chudobným. ");
INSERT INTO slk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judáš si vzal chlieb a hneď nato odišiel. A bola noc. ");
INSERT INTO slk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Keď Judáš odišiel, Ježiš povedal: „Teraz je oslávený Syn človeka a Boh je oslávený prostredníctvom neho. ");
INSERT INTO slk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Syn človeka oslávi Boha a čoskoro aj Boh oslávi Syna človeka. ");
INSERT INTO slk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Moji drahí, zostanem s vami už len veľmi krátko. Budete ma hľadať, ale márne. Čo som povedal vodcom ľudu, to vravím aj vám, že kam idem ja, vy ísť nemôžete. ");
INSERT INTO slk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","No dávam vám nové prikázanie: Milujte sa navzájom. Lásku, ktorou som vás ja miloval, preukazujte aj vy jeden druhému. ");
INSERT INTO slk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Podľa lásky, ktorú budete mať jeden k druhému všetci spoznajú, že ste moji učeníci.“ ");
INSERT INTO slk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Šimon Peter sa ho spýtal: „Pane, kam chceš vlastne ísť?“ Ježiš mu odpovedal: „Nemôžeš ísť so mnou tam, kam teraz idem, ale prídeš za mnou neskôr.“ ");
INSERT INTO slk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","„Ale prečo ťa nemôžem nasledovať teraz?“ spýtal sa Šimon Peter. „Som pripravený za teba hoc aj zomrieť!“ ");
INSERT INTO slk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","„Ty si pripravený za mňa zomrieť?“ spýtal sa Ježiš. „Vravím ti, že ma tri razy zaprieš ešte skôr, ako ráno zakikiríka kohút.“ ");
INSERT INTO slk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Nech sa vaše srdce nechveje úzkosťou! Veríte v Boha, verte aj vo mňa! ");
INSERT INTO slk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","V dome môjho Otca je mnoho príbytkov; keby to tak nebolo, povedal by som vám to. Odchádzam, aby som pre vás všetko pripravil. ");
INSERT INTO slk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Keď bude všetko hotové, zase sa vrátim, vezmem vás k sebe a zostanete so mnou. ");
INSERT INTO slk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A cestu, kam idem, poznáte.“ ");
INSERT INTO slk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","„Nie, Pane,“ namietol Tomáš, „nevieme, kam ideš, tak ako by sme mohli poznať cestu?“ ");
INSERT INTO slk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","„Ja som tá Cesta, Pravda i Život!“ povedal mu Ježiš. „A nikto nemôže prísť k Otcovi inak ako cezo mňa. ");
INSERT INTO slk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Keby ste ma naozaj poznali, poznali by ste aj môjho Otca. Odteraz ho však už poznáte, lebo ste ho videli.“ ");
INSERT INTO slk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","„Pane, ukáž nám Otca a budeme spokojní!“ poprosil Filip. ");
INSERT INTO slk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","„Tak dlho som s vami, Filip, a ešte vždy ma nepoznáš?“ povedal mu Ježiš. „Kto videl mňa, videl Otca. Prečo teda hovoríš: ‚Ukáž nám Otca?‘ ");
INSERT INTO slk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Neveríš, že ja som v Otcovi a Otec je vo mne? Slová, ktoré vám hovorím, nemám len sám zo seba – Otec, ktorý prebýva vo mne, on robí tie skutky. ");
INSERT INTO slk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Verte mi, že ja som v Otcovi a Otec je vo mne. Ak vám nestačia moje slová, verte mi aspoň pre skutky, ktoré konám. ");
INSERT INTO slk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Uisťujem vás, že každý, kto verí vo mňa, bude konať také isté činy ako ja, ba aj väčšie, lebo ja odchádzam k Otcovi. ");
INSERT INTO slk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","O čokoľvek budete prosiť v mojej moci, dám vám, aby Otec bol oslávený v tom, čo Syn koná. ");
INSERT INTO slk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","A ak budete o niečo prosiť v mojom mene, ja to urobím.“ ");
INSERT INTO slk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","„Ak ma milujete, žite podľa mojich prikázaní. ");
INSERT INTO slk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A ja poprosím Otca, aby poslal iného Pomocníka, ktorý s vami bude navždy. ");
INSERT INTO slk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bude to Duch pravdy. Svet ho nemôže prijať, lebo ho nevidí ani nepozná. Ale vy ho poznáte, lebo žije s vami a raz bude aj vo vás. ");
INSERT INTO slk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nie, neopustím vás a nezanechám vás tu ako siroty; znova prídem k vám. ");
INSERT INTO slk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Onedlho ma už nik na tomto svete neuvidí, ale vy ma uvidíte. A pretože ja žijem, aj vy budete žiť. ");
INSERT INTO slk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","V ten deň poznáte, že som vo svojom Otcovi, že vy ste vo mne a ja som vo vás. ");
INSERT INTO slk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kto prijíma moje prikázania a žije podľa nich, ten ma miluje. A kto miluje mňa, toho bude milovať aj môj Otec; budem ho milovať i ja a zjavím mu seba.“ ");
INSERT INTO slk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tu sa ho spýtal Júda, ale nie ten Iškariotský: „Pane, prečo sa chceš zjaviť nám, a nie svetu?“ ");
INSERT INTO slk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ježiš mu odpovedal: „Lebo sa dám poznať iba tomu, kto ma miluje. Ten bude žiť podľa môjho slova a môj Otec ho bude milovať. K takému človeku obaja – môj Otec i ja – prídeme a budeme uňho bývať. ");
INSERT INTO slk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ale kto ma nemiluje, ten nežije podľa mojich slov. A slová, ktoré vám hovorím, nepochádzajú odo mňa, ale od Boha, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Toto všetko vám vravím, kým som ešte s vami. ");
INSERT INTO slk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ale Pomocník, Svätý Duch, ktorého pošle Otec v mojej moci, pripomenie vám všetko, čo som vám povedal, a on vás aj všetko naučí. ");
INSERT INTO slk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Zanechám vám svoj pokoj, ktorý vám nemôže dať nik na svete. Preto sa nebojte ani nestrachujte! ");
INSERT INTO slk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pamätajte na to, čo som vám povedal: ‚Odchádzam, ale opäť sa vrátim. Ak ma naozaj milujete, mali by ste sa radovať, že odchádzam k Otcovi, lebo on je väčší ako ja.‘ ");
INSERT INTO slk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Povedal som vám o tom už dopredu, aby ste uverili, keď sa to všetko stane. ");
INSERT INTO slk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Už nezostáva veľa času na rozhovor, lebo prichádza zlý vládca tohto sveta. Nemá však nado mnou nijakú moc, ");
INSERT INTO slk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Robím to preto, aby svet pochopil, že Otca milujem a konám podľa toho, čo mi prikázal. A teraz vstaňme a odíďme odtiaľto.“ ");
INSERT INTO slk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Ja som pravý kmeň viniča a môj Otec je vinohradník. ");
INSERT INTO slk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Odrezáva na mne každý výhonok, ktorý nenesie ovocie, ale ten výhonok, ktorý ovocie prináša, dôkladne strihá a čistí, aby prinášal ešte väčšiu úrodu. ");
INSERT INTO slk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vy ste už očistení, lebo ste prijali moje slová. ");
INSERT INTO slk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zostaňte spojení so mnou a ja zostanem s vami. Veď tak, ako výhonok oddelený od kmeňa nemôže prinášať nijaké ovocie, nemôžete ho prinášať ani vy, ak nezostanete vo mne. ");
INSERT INTO slk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja som vínny kmeň a vy ste výhonky. Každý, kto zostáva vo mne a ja v ňom, prináša mnoho ovocia. Bezo mňa nemôžete konať nič. ");
INSERT INTO slk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kto nežije so mnou, bude vyhodený ako výhonok: uschne a potom ho hodia na oheň a spália. ");
INSERT INTO slk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ale ak ste so mnou pevne spojení a moje slová sú vo vás a žijete podľa nich, smiete prosiť Boha o čokoľvek a dá vám to. ");
INSERT INTO slk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sláva môjho Otca sa najlepšie prejaví tak, že budete prinášať veľa ovocia a žiť ako moji učeníci. ");
INSERT INTO slk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ako mňa miluje Otec, tak i ja milujem vás. Zostaňte so mnou a budete prežívať moju lásku. ");
INSERT INTO slk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ak budete zachovávať to, čo som vám prikázal, budete žiť v mojej láske; tak ako som ja poslúchol to, čo mi Otec prikázal a žijem v jeho láske. ");
INSERT INTO slk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Povedal som vám to, aby vás moja radosť napĺňala a aby ste sa mohli radovať naplno. ");
INSERT INTO slk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Moje prikázanie znie: ‚Milujte sa navzájom tak, ako ja milujem vás.‘ ");
INSERT INTO slk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nikto nemiluje viac než ten, kto za svojich priateľov obetuje svoj život. ");
INSERT INTO slk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vy ste moji priatelia, ak robíte to, o čo vám prikazujem. ");
INSERT INTO slk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Už vás nevolám sluhami, lebo sluha nevie, aké zámery má jeho pán. Stali ste sa mojimi priateľmi, lebo som vám dal poznať všetko, čo som prijal od svojho Otca. ");
INSERT INTO slk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ja som si vybral vás, nie vy mňa. A poveril som vás, aby ste išli a prinášali ovocie, ktoré bude trvalé. A potom vám Otec dá všetko, o čo ho požiadate v mojom mene. ");
INSERT INTO slk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","To je moje prikázanie: Milujte jeden druhého.“ ");
INSERT INTO slk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","„Ak vás ľudia nenávidia, pamätajte, že mňa nenávideli skôr ako vás. ");
INSERT INTO slk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ak by ste žili tak, ako všetci ostatní, ľudia by vás považovali za svojich priateľov. Ja som vás však povolal, aby ste boli iní ako sú oni, preto vás nenávidia. ");
INSERT INTO slk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Spomeňte si na to, čo som vám hovoril: ‚Sluha nie je väčší ako jeho pán.‘ Ak mňa prenasledovali, budú prenasledovať aj vás. A ako prijímali moje slová, tak budú prijímať aj vaše. ");
INSERT INTO slk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ale to všetko vám budú robiť pre moje meno, pretože nepoznajú toho, ktorý ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Keby som nebol prišiel a neprihováral sa im, boli by bez viny, ale teraz nemajú ako ospravedlniť svoj hriech. ");
INSERT INTO slk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tí, čo pohŕdajú mnou, pohŕdajú aj mojím Otcom. ");
INSERT INTO slk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Keby som pred ich očami nebol vykonal toľko zázrakov, ktoré nik iný nemôže vykonať, boli by bez viny. Oni ich však videli na vlastné oči, a predsa nenávidia mňa i môjho Otca. ");
INSERT INTO slk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Takto sa naplnili slová napísané v ich Zákone: ‚Nenávideli ma bez príčiny.‘ ");
INSERT INTO slk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ale ja vám od Otca pošlem Pomocníka. Bude to Duch pravdy, ktorý príde od Otca a bude o mne vydávať svedectvo. ");
INSERT INTO slk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aj vy budete mojimi svedkami, lebo ste boli so mnou od počiatku.“ ");
INSERT INTO slk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","„Toto všetko som vám povedal, aby ste sa nevzdali svojej viery. ");
INSERT INTO slk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lebo prichádza čas, keď vás budú nielen vylučovať zo synagóg, ale aj zabíjať v presvedčení, že tým slúžia Bohu: ");
INSERT INTO slk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","to preto, že nepoznali Otca ani mňa.“ ");
INSERT INTO slk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","„Povedal som vám to, aby ste si spomenuli na moje slová, keď ten čas príde. Doteraz som o tom nehovoril, lebo som bol s vami. ");
INSERT INTO slk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Teraz však odchádzam k tomu, ktorý ma poslal. No nik z vás sa nepýta: ‚Kam ideš?‘ ");
INSERT INTO slk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Vaše srdcia sú totiž plné zármutku nad tým, čo som vám hovoril. ");
INSERT INTO slk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pravda je však taká, že je pre vás lepšie, aby som odišiel. Ak by som neodišiel, neprišiel by k vám Pomocník. Ale keď odídem, pošlem ho k vám. ");
INSERT INTO slk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A keď príde, bude usvedčovať ľudí z ich hriechu, ale ukáže im aj spravodlivosť a súd. ");
INSERT INTO slk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hriech je v tom, že ľudia vo mňa neveria. ");
INSERT INTO slk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Spravodlivosť je v tom, že odchádzam k Otcovi a už ma neuvidíte. ");
INSERT INTO slk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A súd je v tom, že vládca tohto sveta je už odsúdený. ");
INSERT INTO slk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Je toho ešte veľa, čo by som vám mohol povedať, lenže teraz by ste to nezniesli. ");
INSERT INTO slk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ale keď príde Duch pravdy, bude vás viesť k plnému poznaniu pravdy o Bohu. Nebude hovoriť sám od seba, ale oznámi vám to, čo počul. Ba zjaví vám aj to, čo sa má stať v budúcnosti, ");
INSERT INTO slk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","a tak ukáže moju slávu, lebo všetko, čo vám zjaví, prijme odo mňa. ");
INSERT INTO slk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Všetko, čo má Otec, patrí aj mne; preto som vám povedal, že vám bude zvestovať, čo prijme odo mňa.“ ");
INSERT INTO slk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","„Onedlho ma už neuvidíte, ale potom ma o krátky čas opäť uvidíte.“ ");
INSERT INTO slk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","„Čo to znamená: ‚Onedlho ma už neuvidíte, ale potom ma o krátky čas opäť uvidíte?‘ A čo to znamená: ‚Odchádzam k Otcovi?‘ “ dohadovali sa niektorí učeníci medzi sebou. ");
INSERT INTO slk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","„Čo má na mysli, keď hovorí ‚onedlho?‘ Vôbec nerozumieme, čo hovorí.“ ");
INSERT INTO slk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ježiš vedel, že sa ho na to chcú opýtať a preto im povedal: „Premýšľajte, čo znamenajú moje slová, že ma už onedlho neuvidíte, ale potom ma o krátky čas opäť uvidíte. ");
INSERT INTO slk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Uisťujem vás, že budete plakať a smútiť, ale svet sa bude radovať. Vaša bolesť sa však zmení na radosť. ");
INSERT INTO slk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Žena, pri pôrode prežíva bolesť, lebo prišiel čas jej utrpenia. Ale keď sa už dieťa narodí, nemyslí viac na bolesť, ktorú prežila: naopak, raduje sa, že dieťatko prišlo na svet. ");
INSERT INTO slk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Teraz ste smutní, no keď sa opäť stretneme, vy sa budete radovať. A vašu radosť vám už nik nevezme. ");
INSERT INTO slk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","V ten deň sa ma už nebudete musieť na nič pýtať. Znova vás ubezpečujem: Môj Otec vám dá, o čokoľvek by ste ho v mojom mene prosili. ");
INSERT INTO slk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Doteraz ste ho v mojom mene o nič neprosili, proste však a dostanete, aby vaša radosť bola úplná. ");
INSERT INTO slk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Doposiaľ som vám o všetkom hovoril obrazne. Ale teraz nastáva čas, keď to už nebude potrebné a budem vám o Otcovi hovoriť celkom otvorene. ");
INSERT INTO slk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Vtedy budete Otca prosiť v mojom mene. A vedzte, že nebude potrebné, aby som sa za vás u Otca nejako prihováral. ");
INSERT INTO slk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sám Otec vás totiž miluje, lebo vy ma milujete a uverili ste, že som prišiel od Boha. ");
INSERT INTO slk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Áno, prišiel som na svet od Otca a teraz zasa opúšťam svet a vraciam sa k Otcovi.“ ");
INSERT INTO slk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","„Teraz konečne hovoríš jasne, nie v obrazoch,“ povedali mu učeníci. ");
INSERT INTO slk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","„Teraz sme pochopili, že vieš o všetkom a nepotrebuješ, aby sa ťa niekto na niečo spytoval. Preto naozaj veríme, že si prišiel od Boha.“ ");
INSERT INTO slk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","„Naozaj mi teraz veríte?“ spýtal sa ich Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","„Čoskoro, naozaj o malú chvíľu, nastane čas, keď sa rozpŕchnete do svojich domovov a necháte ma samého. Ale ja nebudem sám, lebo Otec je so mnou. ");
INSERT INTO slk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Toto všetko som vám povedal, aby vám spoločenstvo so mnou prinášalo pokoj. Tu na svete budete mať mnoho trápenia. Ale nestrácajte odvahu, ja som zvíťazil nad svetom.“ ");
INSERT INTO slk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Po týchto slovách Ježiš pozdvihol svoj zrak k nebu a modlil sa: „Otče, prišiel čas. Zjav slávu svojho Syna, aby tvoj Syn mohol odhaliť tvoju slávu. ");
INSERT INTO slk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Veď ty si mu dal moc nad všetkými ľuďmi, aby tým, ktorých si mu zveril, dal večný život. ");
INSERT INTO slk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A večný život je založený na osobnom poznaní teba – jediného pravého Boha a Ježiša Krista, ktorého si poslal. ");
INSERT INTO slk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Vykonal som všetko, čo si mi uložil, a tým som ukázal tvoju slávu. ");
INSERT INTO slk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A teraz, Otče, zjav ty moju slávu, ktorú som mal u teba pred stvorením sveta. ");
INSERT INTO slk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ľuďom, ktorých si mi dal zo sveta, som ukázal, kto si. Patria tebe – zveril si mi ich a oni prijali tvoje slovo a žili podľa neho. ");
INSERT INTO slk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Teraz vedia, že všetko, čo si mi dal, je naozaj od teba. ");
INSERT INTO slk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Veď všetko, čo si mi povedal, som im zvestoval. A oni prijali tvoje slová a sú presvedčení, že som prišiel na zem od teba, a uverili, že si ma ty poslal. ");
INSERT INTO slk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Prosím teraz za nich, nie za všetkých ľudí, ale za tých, ktorých si mi dal, lebo patria tebe. ");
INSERT INTO slk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Veď všetko, čo mám, je tvoje, a čo je tvoje, patrí aj mne. A tak nech sa prostredníctvom nich zjaví moja sláva. ");
INSERT INTO slk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ja teraz opúšťam tento svet a odchádzam k tebe, no oni tu zostávajú. Svätý Otče, staraj sa o nich svojou mocou, aby boli jednotní, ako sme my spolu jedno. ");
INSERT INTO slk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kým som bol s nimi, chránil som ich tvojou mocou, ktorú si mi dal. Dával som na nich pozor, takže sa nik nestratil, okrem toho, ktorý dospel k zatrateniu, ako to bolo predpovedané v Písme. ");
INSERT INTO slk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A teraz odchádzam k tebe. Toto všetko im ešte raz zdôrazňujem, kým som s nimi, aby ich moja radosť celkom naplnila. ");
INSERT INTO slk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naučil som ich tvojim prikázaniam a svet ich nenávidel, lebo podobne ako ja nesplynuli s prúdom. ");
INSERT INTO slk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neprosím, aby si ich vzal zo sveta, ale chráň ich pred mocou zla. ");
INSERT INTO slk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nepatria svetu, ako ani ja mu nepatrím. ");
INSERT INTO slk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Daj, nech ich tvoje slovo, ktoré je pravda, očistí a posvätí. ");
INSERT INTO slk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ako si ty mňa poslal do sveta, tak ja posielam ich. ");
INSERT INTO slk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ja za nich posväcujem svoj život, aby oni mohli rásť v pravde a v svätosti. ");
INSERT INTO slk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ale neprosím iba za nich, no aj za všetkých, ktorí budú počúvať posolstvo mojich učeníkov a uveria vo mňa. ");
INSERT INTO slk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Daj, nech sú všetci jedno srdce a jedna myseľ, ako aj my sme, Otče, jedno. Tak ako si ty vo mne a ja v tebe, aj oni nech sú s nami pevne spojení. Potom sa svet presvedčí, že si ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Preto som im dal aj slávu, ktorú si mi daroval, aby žili v takej istej jednote ako ja s tebou. ");
INSERT INTO slk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nech zostanú vo mne a ja v tebe, tak budeme dokonale jednotní. A vtedy svet pozná, že ty si ma poslal a že miluješ mojich učeníkov tak ako mňa. ");
INSERT INTO slk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Otče, chcem, aby všetci, ktorých si mi dal, prišli tam, kde ja idem, a poznali ma v plnej sláve. Dal si mi ju z lásky, prv ako bol svet. ");
INSERT INTO slk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Spravodlivý Otče, aj keď ťa svet nepozná, ja ťa poznám a aj oni poznali, že si ma poslal. ");
INSERT INTO slk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ukázal som im teba a ešte aj ukážem, aby tvoja láska ku mne napĺňala aj ich a ja aby som v nich žil.“ ");
INSERT INTO slk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Po tejto modlitbe odišiel Ježiš so svojimi učeníkmi do olivovej záhrady za údolie Kedrón. ");
INSERT INTO slk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Toto miesto dobre poznal aj Judáš, ktorý Ježiša zradil. Ježiš sa totiž práve tu so svojimi učeníkmi často stretával. ");
INSERT INTO slk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Teraz sem Judáš viedol chrámovú stráž aj s oddielom rímskeho vojska: boli ozbrojení a svietili si na cestu fakľami a lampášmi. ");
INSERT INTO slk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ježiš vedel, čo sa má stať. Šiel im oproti a spýtal sa: „Koho hľadáte?“ ");
INSERT INTO slk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","„Ježiša z Nazareta,“ odpovedali mu. „Ja som,“ odpovedal im. Judáš, jeho zradca, stál medzi vojakmi. ");
INSERT INTO slk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Keď im Ježiš povedal: „To som ja,“ ustúpili dozadu a padli na zem. ");
INSERT INTO slk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","„Koho hľadáte?“ spýtal sa ich znovu. „Ježiša Nazaretského!“ zopakovali. ");
INSERT INTO slk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","„Veď som vám už povedal, že som to ja,“ povedal Ježiš. „Ak hľadáte mňa, týchto ostatných nechajte odísť.“ ");
INSERT INTO slk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tak sa naplnili slová, ktoré Ježiš už predtým vyslovil vo svojej modlitbe: „Nestratím ani jedného z tých, ktorých si mi zveril.“ ");
INSERT INTO slk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tu Šimon Peter vytasil meč a odťal Malchusovi, jednému z veľkňazových sluhov, pravé ucho. ");
INSERT INTO slk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ale Ježiš prikázal Petrovi: „Schovaj svoj meč! Mám sa azda vyhnúť utrpeniu, ktoré mi určil Otec?“ ");
INSERT INTO slk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Vtedy sa rímski vojaci na čele so svojím veliteľom a židovská stráž zmocnili Ježiša a spútali ho. ");
INSERT INTO slk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Odviedli ho najprv k Annášovi, svokrovi Kaifáša, ktorý bol v tom čase veľkňazom. ");
INSERT INTO slk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Práve on navrhol židovským vodcom, že je lepšie, aby zomrel jeden človek namiesto všetkých. ");
INSERT INTO slk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Peter šiel spolu s iným učeníkom za Ježišom. Ten učeník sa poznal s veľkňazom, a tak mu dovolili vstúpiť až na nádvorie veľkňazovho paláca. ");
INSERT INTO slk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter musel zostať vonku. Ten druhý učeník sa po chvíli vrátil, povedal čosi slúžke pri dverách a voviedol Petra dnu. ");
INSERT INTO slk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vtedy sa slúžka spýtala: „Nepatríš aj ty medzi učeníkov toho človeka?“ „Nie, nepatrím,“ odpovedal jej. ");
INSERT INTO slk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bolo chladno, preto si strážcovia a vojaci rozložili oheň a hriali sa okolo neho. Aj Peter sa zamiešal medzi nich a zohrieval sa. ");
INSERT INTO slk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Medzitým sa začal výsluch. Veľkňaz Annáš sa vypytoval Ježiša na jeho učeníkov i na to, čo učil. ");
INSERT INTO slk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ježiš mu odpovedal: „Vždy som hovoril k ľuďom verejne. Kázal som otvorene v synagógach i v chráme a každý to mohol počuť. Nie je nič, čo by som tajil. ");
INSERT INTO slk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Prečo sa teda vypytuješ mňa? Spýtaj sa tých, ktorí ma počúvali. Oni predsa vedia, čo som hovoril.“ ");
INSERT INTO slk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","„Ako sa to zhováraš s veľkňazom?“ oboril sa na Ježiša jeden zo strážcov a udrel ho do tváre. ");
INSERT INTO slk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","„Ak som povedal niečo nesprávne, tak to dokáž!“ bránil sa Ježiš. „Ale ak som povedal pravdu, prečo ma biješ?“ ");
INSERT INTO slk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annáš potom poslal spútaného Ježiša ku Kaifášovi. ");
INSERT INTO slk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ako sa Šimon Peter zohrieval pri ohni, opýtali sa ho: „Aj ty si jedným z jeho učeníkov, však?“ „Nie, nie som,“ zaprel Peter. ");
INSERT INTO slk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jeden z veľkňazových sluhov, príbuzný toho, ktorému Peter odťal ucho, povedal: „Vari som ťa s ním nevidel v záhrade?“ ");
INSERT INTO slk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter to znova poprel a vzápätí zakikiríkal kohút. ");
INSERT INTO slk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Zavčasu ráno odviedli Ježiša od Kaifáša do paláca rímskeho miestodržiteľa. Židovskí vodcovia nevstúpili do paláca, lebo by sa podľa židovských predpisov poškvrnili a nemohli by sa zúčastniť slávnosti Paschy. ");
INSERT INTO slk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Preto Pilát, rímsky miestodržiteľ, vyšiel von a spýtal sa ich: „Z čoho obviňujete tohto človeka? Čo vykonal?“ ");
INSERT INTO slk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","„Keby to nebol zločinec, nedoviedli by sme ho k tebe!“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilát im však povedal: „Tak si ho zasa odveďte a súďte podľa vlastných zákonov!“ „Ale my nemáme právo nikoho popraviť!“ naliehali židovský vodcovia. ");
INSERT INTO slk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Takto sa mali naplniť Ježišove slová, ktorými predpovedal, akým spôsobom zomrie.) ");
INSERT INTO slk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilát sa vrátil do paláca, dal si Ježiša predvolať a spýtal sa ho: „Ty si kráľ Židov?“ ");
INSERT INTO slk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","„Zaujímaš sa o to sám od seba, alebo ti o mne povedali iní?“ odpovedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","„Som ja azda Žid?“ odvetil Pilát. „Tvoj vlastný národ a tvoji veľkňazi mi ťa vydali. Čím si sa previnil?“ ");
INSERT INTO slk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","„Moje kráľovstvo nie je pozemským kráľovstvom,“ odpovedal Ježiš. „Keby to tak bolo, moji služobníci by ma bránili a nedovolili by, aby ma židovskí vodcovia zajali. V mojom kráľovstve však ide o niečo iné.“ ");
INSERT INTO slk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","„Tak predsa len si kráľ,“ zvolal Pilát. „Ty sám si povedal, že som kráľ,“ povedal Ježiš. „Ja som sa narodil a prišiel na tento svet preto, aby som ľuďom ukázal, čo je pravda. A každý, kto miluje pravdu, žije podľa mojich slov.“ ");
INSERT INTO slk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","„A čo je vlastne pravda?“ povedal Pilát. Potom sa vrátil k židovským vodcom a vyhlásil: „Ja som na ňom nenašiel nijakú vinu. ");
INSERT INTO slk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","A keďže je zvykom, že vám vždy cez sviatok Paschy prepustím na slobodu jedného väzňa, pýtam sa vás: Chcete, aby som vám prepustil židovského kráľa?“ ");
INSERT INTO slk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","„Nie! Tohto nechceme! Prepusť Barabáša!“ kričali. Barabáš patril medzi vzbúrencov. ");
INSERT INTO slk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nato dal Pilát príkaz, aby Ježiša odviedli a zbičovali ho. ");
INSERT INTO slk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vojaci uplietli z tŕnia korunu, nasadili mu ju na hlavu a cez plecia mu prehodili purpurový plášť. ");
INSERT INTO slk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Potom pred neho predstupovali, bili ho po tvári a posmievali sa mu: „Nech žije židovský kráľ!“ ");
INSERT INTO slk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilát opäť vyšiel k zhromaždenému zástupu a povedal: „Pozrite, vediem vám ho, aby ste sa presvedčili, že som na ňom nenašiel žiadnu vinu.“ ");
INSERT INTO slk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ježiš vyšiel von s tŕňovou korunou a v purpurovom plášti. Pilát naňho ukázal a povedal: „Hľa, človek!“ ");
INSERT INTO slk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Keď ho veľkňazi a ich stráž zazreli, začali kričať: „Na kríž s ním! Ukrižuj ho!“ „Ukrižujte si ho sami! Ja na ňom nijakú vinu nenachádzam,“ odpovedal im Pilát. ");
INSERT INTO slk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","„Ale podľa nášho zákona musí zomrieť, lebo sa vyhlasoval za Božieho Syna!“ namietali Židia. ");
INSERT INTO slk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Keď to Pilát počul, jeho nepokoj ešte väčšmi vzrástol. ");
INSERT INTO slk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Odviedol Ježiša späť do paláca a spýtal sa ho: „Odkiaľ vlastne si?“ Ale Ježiš mlčal. ");
INSERT INTO slk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilát Ježišovi povedal: „Prečo sa so mnou nechceš zhovárať? Neuvedomuješ si, že ja mám moc prepustiť ťa aj ťa ukrižovať?“ ");
INSERT INTO slk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","„Nemal by si nado mnou nijakú moc, keby ti ju nedal Boh,“ odpovedal Ježiš. „Preto ten, kto ma vydal do tvojich rúk, má väčšiu vinu ako ty.“ ");
INSERT INTO slk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Po tých slovách sa Pilát znova pokúšal Ježiša oslobodiť. Ale židovský vodcovia kričali: „Ak ho prepustíš, staneš sa cisárovým nepriateľom! Kto sa vyhlasuje za kráľa, stavia sa na odpor cisárovi!“ ");
INSERT INTO slk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Keď to Pilát počul, dal Ježiša vyviesť na nádvorie zvané Kamenná dlažba (po aramejsky sa to miesto nazývalo Gabbatha) a sadol si do sudcovského kresla. ");
INSERT INTO slk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Keďže bol deň prípravy na slávnosť Paschy a bolo už okolo obeda, povedal Pilát židovským vodcom: „Tu je váš kráľ!“ ");
INSERT INTO slk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","„Preč s ním! Preč s ním!“ spustili veľký krik. „Ukrižuj ho!“ „Mám ukrižovať vášho kráľa?“ ešte raz sa spýtal Pilát. „Nemáme žiadneho kráľa! Máme predsa cisára!“ odpovedali veľkňazi. ");
INSERT INTO slk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Vtedy im ho Pilát vydal, aby ho ukrižovali. Vojaci Ježiša vzali a viedli preč. ");
INSERT INTO slk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ježiš si musel niesť kríž sám. Viedli ho z mesta na kopec zvaný Lebka (po aramejsky nazývané Golgota). ");
INSERT INTO slk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tam ho ukrižovali. Spolu s ním ukrižovali z každej strany aj dvoch ďalších a Ježiš bol uprostred. ");
INSERT INTO slk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nad Ježišovu hlavu dal Pilát pripevniť tabuľku s nápisom: JEŽIŠ Z NAZARETA – ŽIDOVSKÝ KRÁĽ. ");
INSERT INTO slk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Popravisko bolo blízko mesta, takže ten nápis, písaný aramejsky, latinsky a grécky, čítalo mnoho ľudí. ");
INSERT INTO slk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Židovskí veľkňazi protestovali u Piláta: „Nemal si napísať ‚židovský kráľ‘, ale ‚vyhlasoval sa za židovského kráľa.‘ “ ");
INSERT INTO slk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ale Pilát ich odbil: „Čo som napísal, to som napísal.“ ");
INSERT INTO slk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Keď vojaci ukrižovali Ježiša, podľa zvyku roztrhli jeho plášť na štyri diely, pre každého vojaka jeden diel. Ale jeho spodný odev, utkaný vcelku, bez jediného šva, ");
INSERT INTO slk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","nechceli roztrhať a povedali si: „Losujme, komu pripadne.“ Tak sa naplnila predpoveď Písma: „Rozdelili si môj plášť a losovali o môj odev.“ Vojaci to naozaj urobili. ");
INSERT INTO slk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pod krížom, na ktorom visel Ježiš, stála jeho matka, sestra jeho matky Mária Kleofášova a Mária Magdaléna. ");
INSERT INTO slk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Keď Ježiš videl matku a vedľa nej učeníka, ktorého mal tak rád, povedal jej: „Ujmi sa ho ako svojho syna.“ ");
INSERT INTO slk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A učeníkovi povedal: „Ujmi sa jej ako svojej matky!“ Odvtedy ju prijal do svojho domu. ");
INSERT INTO slk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Keď Ježiš vedel, že vykonal všetko, čo mal vykonať, povedal: „Žíznim.“ (To povedal, aby sa naplnilo, čo bolo napísané v Písme.) ");
INSERT INTO slk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vojaci namočili špongiu do nádoby s kyslým vínom a na stonke yzopu mu ju podali k ústam. ");
INSERT INTO slk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ježiš si ovlažil ústa a povedal: „Je dokonané.“ Hlava mu klesla a skonal. ");
INSERT INTO slk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Keďže bol deň prípravy a židovskí vodcovia nechceli, aby telá zostali cez sobotu na kríži, lebo táto sobota bola veľkým sviatočným dňom, požiadali Piláta, aby dal odsúdencom polámať nohy a aby boli sňatí z kríža. ");
INSERT INTO slk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Prišli teda vojaci a polámali nohy tým, ktorí boli ukrižovaní s Ježišom. ");
INSERT INTO slk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ale keď pristúpili k Ježišovi, videli, že je už mŕtvy. Preto mu nelámali kosti, ");
INSERT INTO slk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ale jeden z vojakov mu kopijou prebodol bok. Z rany hneď vytiekla zrazená krv a voda. ");
INSERT INTO slk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ten, ktorý všetko videl na vlastné oči, hovorí o tom preto, aby ste aj vy mohli uveriť. To, o čom hovorí, sa naozaj stalo a jeho svedectvo je pravdivé. ");
INSERT INTO slk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Stalo sa to preto, aby sa naplnili predpovede Písma: „Ani kosť mu nebude zlomená,“ ");
INSERT INTO slk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","a „Budú hľadieť na toho, ktorého prebodli.“ ");
INSERT INTO slk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Potom požiadal Jozef z Arimatey Piláta, aby mu dovolil sňať Ježišovo telo z kríža. Jozef bol Ježišovým tajným učeníkom – mal totiž strach zo židovských vodcov. Pilát mu dal súhlas, a tak šiel a zložil Ježišovo mŕtve telo. ");
INSERT INTO slk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pomáhal mu pritom aj Nikodém, ktorý kedysi v noci navštívil Ježiša. Priniesol veľké množstvo vzácnych vonných mastí – zmes myrhy a aloe. ");
INSERT INTO slk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ježišovo telo nabalzamovali a zavinuli do ľanového plátna, ako to Židia robievajú pri pochovávaní. ");
INSERT INTO slk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Neďaleko miesta, kde ho ukrižovali, bola záhrada a v nej ešte nepoužitá hrobka vytesaná do skaly. ");
INSERT INTO slk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Keďže bol židovský deň prípravy a hrobka bola blízko, Ježiša uložili do nej. ");
INSERT INTO slk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","V prvý deň týždňa, ešte pred svitaním, šla Mária Magdaléna k hrobu a videla, že kameň, ktorý mal zakrývať vchod do hrobu, je odvalený. ");
INSERT INTO slk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bežala k Petrovi a k učeníkovi, ktorého mal Ježiš tak rád, a oznámila im: „Nášho Pána vzali z hrobu a nevieme, kde ho uložili.“ ");
INSERT INTO slk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter s učeníkom sa vybrali k hrobu. ");
INSERT INTO slk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cestou bežali, ale druhý učeník Petra predbehol a pri hrobe bol prvý. ");
INSERT INTO slk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naklonil sa, nazrel do hrobu a videl tam ležať plátno; dnu však nevošiel. ");
INSERT INTO slk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Vtom pribehol aj Peter: vstúpil do hrobky a našiel tam ležať ľanové plátno ");
INSERT INTO slk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a pohrebnú šatku, ktorou mal Ježiš prikrytú hlavu. Tá však ležala zložená na inom mieste ako ľanové plátno. ");
INSERT INTO slk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vtedy vstúpil dnu aj učeník, ktorý pribehol k hrobu ako prvý. Všetko si prehliadol a tiež uveril. ");
INSERT INTO slk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vtedy totiž ešte nechápali, čo hovorí Písmo, že Ježiš vstane z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Obaja učeníci sa potom vrátili späť do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Medzitým sa vrátila Mária. Ako tak stála pred hrobom a plakala, naklonila sa do hrobky ");
INSERT INTO slk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a zbadala dvoch anjelov v bielom. Sedeli na tom mieste, kde predtým ležalo Ježišovo telo, jeden pri hlave, druhý pri nohách. ");
INSERT INTO slk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","„Žena, prečo plačeš?“ spýtali sa jej. „Odniesli môjho Pána a neviem, kam ho uložili,“ odpovedala. ");
INSERT INTO slk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Keď to povedala, obrátila sa dozadu a uvidela tam kohosi stáť. Bol to Ježiš, ale Mária nevedela, že je to on. ");
INSERT INTO slk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","„Prečo plačeš?“ spýtal sa jej Ježiš. „Koho hľadáš?“ Mária sa domnievala, že je to záhradník, preto mu povedala: „Pane, ak si ho odniesol, povedz, kde si ho položil, a ja poňho pôjdem.“ ");
INSERT INTO slk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","„Mária!“ prihovoril sa jej Ježiš. Obrátila sa a po aramejsky zvolala: „Rabbuni!“ (To znamená Učiteľ.) ");
INSERT INTO slk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","„Nedotýkaj sa ma!“ povedal jej Ježiš. „Ešte som nevystúpil k Otcovi. Choď a povedz mojim bratom, že odchádzam k svojmu Otcovi a k vášmu Otcovi, k svojmu Bohu a vášmu Bohu.“ ");
INSERT INTO slk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mária Magdaléna prišla za učeníkmi a oznámila im: „Videla som Pána!“ A porozprávala im všetko, čo jej povedal. ");
INSERT INTO slk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","V ten istý deň večer – prvý deň po sobote – sa zhromaždili všetci jeho učeníci. Dvere mali zamknuté, lebo sa báli židovských vodcov. Zrazu sa zjavil Ježiš, postavil sa doprostred miestnosti a povedal im: „Pokoj vám!“ ");
INSERT INTO slk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Potom im ukázal rany na rukách a na boku. Keď učeníci videli svojho Pána, veľmi sa zaradovali. ");
INSERT INTO slk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ježiš im opäť povedal: „Pokoj vám. Ako mňa poslal Otec, tak ja posielam vás.“ ");
INSERT INTO slk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Potom na nich dýchol a povedal: „Prijmite Svätého Ducha. ");
INSERT INTO slk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Komu odpustíte hriechy, tomu budú odpustené, komu ich neodpustíte, tomu odpustené nebudú.“ ");
INSERT INTO slk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomáš, prezývaný Dvojča, jeden z dvanástich učeníkov, nebol s nimi, keď prišiel Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Keď mu ostatní hovorili: „Videli sme Pána!“, Tomáš im povedal: „Kým neuvidím stopy po klincoch na jeho rukách a kým nevložím do jeho rán prst a svoju ruku do jeho boku, neuverím, že vstal z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","O týždeň boli učeníci znovu spolu a tentoraz bol s nimi aj Tomáš. A hoci mali dvere zamknuté, Ježiš opäť prišiel, postavil sa medzi nich a povedal: „Pokoj vám!“ ");
INSERT INTO slk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Potom sa obrátil k Tomášovi a povedal mu: „Dotkni sa prstami mojich prebodnutých rúk a môjho boku. A už nepochybuj, ale ver!“ ");
INSERT INTO slk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomášovou odpoveďou však boli slová: „Môj Pán a môj Boh!“ ");
INSERT INTO slk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ježiš mu povedal: „Uveril si preto, lebo si ma videl. Ale šťastní sú tí, ktorí nevideli, a uverili!“ ");
INSERT INTO slk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ježišovi učeníci boli svedkami ešte mnohých iných Ježišových zázrakov, ktoré nie sú opísané v tejto knihe. ");
INSERT INTO slk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ale tieto správy sú zapísané, aby ste uverili, že Ježiš je Mesiáš, Boží Syn a aby ste prostredníctvom viery v neho mali večný život. ");
INSERT INTO slk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Neskôr sa Ježiš opäť zjavil učeníkom pri Tiberiadskom jazere. Stalo sa to takto: ");
INSERT INTO slk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Šimon Peter, Tomáš (prezývaný Dvojča), Natanael z galilejskej Kány, synovia Zebedejovi a ešte ďalší dvaja učeníci boli spolu. ");
INSERT INTO slk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Šimon Peter im povedal: „Idem loviť.“ „Ideme s tebou!“ pridali sa k nemu ostatní. Nastúpili do člna, vyplávali na jazero, ale v tú noc nechytili nič. ");
INSERT INTO slk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na svitaní si všimli, že ktosi stojí na brehu. Bol to Ježiš, ale učeníci nevedeli, že je to on. ");
INSERT INTO slk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","„Priatelia, však ste nič nechytili?“ zavolal na nich Ježiš. „Nič“ odpovedali mu. ");
INSERT INTO slk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","„Tak hoďte siete na druhú stranu člna. Tam ich ulovíte!“ poradil im. Poslúchli jeho radu a do siete sa im chytilo toľko rýb, že ju nevládali vytiahnuť. ");
INSERT INTO slk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Učeník, ktorého mal Ježiš tak rád, povedal Petrovi: „To je Pán!“ Len čo to Šimon Peter počul, obliekol si plášť, pri práci ho mal totiž vyzlečený, a skočil do vody. ");
INSERT INTO slk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ostatní učeníci priplávali na lodi, za ktorou ťahali sieť s rybami. Neboli ďaleko od brehu, len okolo sto metrov. ");
INSERT INTO slk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Keď vystúpili na breh, videli ohnisko a na ňom rybu i chlieb. ");
INSERT INTO slk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","„Prineste niekoľko rýb zo svojho úlovku,“ povedal im Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Šimon Peter šiel a vytiahol na breh sieť plnú veľkých rýb. Bolo ich stopäťdesiattri, a hoci ich bolo tak veľa, sieť sa neroztrhla. ");
INSERT INTO slk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","„A teraz sa poďte naraňajkovať,“ pozval ich Ježiš. Nikto z učeníkov sa ho neopovážil spýtať: „Kto si?“, lebo vedeli, že je to Pán. ");
INSERT INTO slk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ježiš k nim pristúpil, vzal chlieb a podal im ho. Podobne im podal aj rybu. ");
INSERT INTO slk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bolo to už tretí raz, čo sa Ježiš po svojom vzkriesení ukázal učeníkom. ");
INSERT INTO slk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Keď sa najedli, opýtal sa Ježiš Petra: „Šimon, syn Jánov, miluješ ma viac ako ostatní?“ „Áno, Pane, ty vieš, že ťa mám rád.“ „Tak pas moje jahniatka!“ povedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Potom sa ho Ježiš opýtal opäť: „Šimon, syn Jánov, naozaj ma miluješ?“ „Áno, Pane, ty vieš, že ťa mám rád,“ odpovedal. „Tak sa staraj o moje ovce!“ ");
INSERT INTO slk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Spýtal sa ho i tretí raz: „Šimon, syn Jánov, máš ma rád?“ Peter zosmutnel, že sa tretí raz spýtal, či ho má rád. „Pane, ty vieš všetko, dobre vieš, že ťa mám rád.“ „Tak pas moje ovečky!“ odpovedal mu Ježiš. ");
INSERT INTO slk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","„Ale na jedno nezabudni: Keď si bol mladý, sám si sa opásaval a chodil si, kam si chcel. Ale keď zostarneš, vystrieš svoje ruky a iný ťa poviaže a povedie, kam nebudeš chcieť.“ ");
INSERT INTO slk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tým mu chcel naznačiť, akou smrťou oslávi Boha. A potom ešte dodal: „Nasleduj ma!“ ");
INSERT INTO slk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter sa obrátil a videl, že za nimi ide učeník, ktorého Ježiš tak veľmi miloval, a ktorý sa ho pri večeri, sediac vedľa neho, opýtal: „Pane, ktorý z nás ťa zradí?“ ");
INSERT INTO slk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Keď ho teda Peter videl, spýtal sa Ježiša: „Pane, čo bude s ním?“ ");
INSERT INTO slk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ježiš mu povedal: „Ak bude moja vôľa, aby zostal nažive, až kým znovu neprídem, nemusíš sa s tým trápiť. Ty ma nasleduj!“ ");
INSERT INTO slk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A tak sa medzi veriacimi roznieslo, že tento učeník nezomrie. Ale Ježiš nepovedal, že ten učeník nezomrie, ale: „Ak bude moja vôľa, aby zostal nažive, až kým znovu neprídem, nemusíš sa s tým trápiť.“ ");
INSERT INTO slk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Je to učeník, ktorý vydal svedectvo o týchto udalostiach a zapísal ich. A my vieme, že jeho svedectvo je spoľahlivé. ");
INSERT INTO slk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ježiš vykonal ešte veľa ďalších vecí. Keby sa to malo všetko dopodrobna spísať, myslím si, že na celom svete by nebolo dosť miesta pre knihy, ktoré by sa o tom napísali.");
INSERT INTO slk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Milý Teofil, vo svojej prvej knihe som sa usiloval opísať všetko, čo Ježiš konal a učil od počiatku ");
INSERT INTO slk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","až do svojho odchodu k Bohu do neba. Vtedy dal aj pokyny prostredníctvom Ducha Svätého svojim učeníkom, ktorých si na to vyvolil. ");
INSERT INTO slk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Od svojho umučenia a ukrižovania sa im zjavoval štyridsať dní; tak im mnohorakým spôsobom dokázal, že naozaj žije, a rozprával im o Božom kráľovstve. ");
INSERT INTO slk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Keď boli ešte spolu, povedal im: „Neodchádzajte z Jeruzalema, ale čakajte, kým Boh splní svoj sľub, o ktorom ste odo mňa počuli: ");
INSERT INTO slk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ján krstil vodou, ale vás Boh v najbližších dňoch pokrstí Svätým Duchom.“ ");
INSERT INTO slk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Keď boli zasa spolu, spýtali sa ho jeho učeníci: „Pane, teraz je ten čas, keď obnovíš kráľovstvo pre Izrael?“ ");
INSERT INTO slk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Odpovedal im: „Nie je vašou starosťou poznať čas či vhodnú dobu, kedy to bude. Boh koná podľa vlastného rozhodnutia. ");
INSERT INTO slk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dostanete však moc Ducha Svätého, ktorý na vás zostúpi a stanete sa mojimi svedkami v Jeruzaleme, v celom Judsku, v Samárii a po celom svete.“ ");
INSERT INTO slk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Po týchto slovách sa pred ich očami vzniesol dohora a zastrel ho oblak. ");
INSERT INTO slk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kým uprene hľadeli na oblohu, ako odchádza, postavili sa k nim dvaja muži v bielom ");
INSERT INTO slk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a oslovili ich: „Galilejčania, prečo tu stojíte a dívate sa do neba? Ten Ježiš, ktorý bol od vás vzatý do neba, sa jedného dňa znova vráti tak, ako ste ho videli odchádzať.“ ");
INSERT INTO slk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Potom sa z Olivového vrchu vrátili do Jeruzalema: je to približne vzdialenosť, ktorú bolo dovolené prejsť v sobotu. ");
INSERT INTO slk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Vrátili sa do mesta, kde v hornej miestnosti domu spoločne bývali Peter, Ján, Jakub, Andrej, Filip, Tomáš, Bartolomej, Matúš; Jakub, syn Alfejov; Šimon, prezývaný Horlivec a Júda, syn Jakubov. ");
INSERT INTO slk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tí všetci sa zomknuto a vytrvalo modlili s niektorými ženami, Ježišovou matkou Máriou a jeho bratmi. ");
INSERT INTO slk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pri jednom zhromaždení, kde sa zišlo asi stodvadsať Ježišových nasledovníkov, vystúpil Peter a povedal: ");
INSERT INTO slk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","„Bratia, naplnila sa predpoveď Písma o Judášovi. Duch Svätý predpovedal Dávidovými ústami o Judášovi, ktorý priviedol tých, čo zatkli Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","A to napriek tomu, že Judáš bol jedným z nás dvanástich apoštolov a že dostal rovnaké poverenie ako my.“ ");
INSERT INTO slk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Za peniaze, ktoré dostal ako odmenu za svoju neprávosť, si kúpil pozemok. Potom skončil svoj život strašným spôsobom: spadol dolu hlavou, telo sa mu roztrhlo a vypadli mu vnútornosti. ");
INSERT INTO slk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jeruzalemčania, ktorí sa o tom dozvedeli, nazvali to miesto Hakeldamach – Pole krvi. ");
INSERT INTO slk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","„Veď v knihe Žalmov je napísané: ‚Jeho obydlie nech spustne a nech v ňom nik nebýva.‘ A na inom mieste: ‚Jeho poverenie nech prevezme iný.‘ ");
INSERT INTO slk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Musíme teda nahradiť Judáša. Vyberme muža, ktorý bol spolu s nami s Pánom Ježišom celý čas ");
INSERT INTO slk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","od chvíle, keď ho Ján pokrstil, až do jeho odchodu do neba; ten spolu s nami bude svedčiť, že Ježiš vstal z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Vybrali teda dvoch: Jozefa, ktorého volali Barsabáš (a bol známi aj pod menom Justus – Spravodlivý), a Mateja. ");
INSERT INTO slk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Potom sa modlili: „Pane, ty poznáš srdce každého človeka. Ukáž, ktorého z týchto dvoch si si vyvolil ");
INSERT INTO slk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","do služby ako svojho apoštola namiesto Judáša, zradcu, čo odišiel na miesto, ktoré si sám zvolil.“ ");
INSERT INTO slk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Potom ťahali lós a ten označil Mateja, ktorý sa pripojil k jedenástim apoštolom. ");
INSERT INTO slk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Keď nadišiel deň Turíc, mali Kristovi nasledovníci opäť spoločné stretnutie. ");
INSERT INTO slk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Zrazu sa strhol hukot z neba, ako keď sa ženie silný vietor, a naplnil celý dom, v ktorom sa zišli. ");
INSERT INTO slk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Potom uvideli čosi ako ohnivé jazyky, ktoré sa rozdelili a spočinuli na každom z nich. ");
INSERT INTO slk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Všetkých naplnil Duch Svätý a začali hovoriť inými jazykmi tak, ako ich na to Duch zmocňoval. ");
INSERT INTO slk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","V tom čase bolo v Jeruzaleme veľa zbožných Židov, ktorí prišli na sviatky z mnohých krajín a národov. ");
INSERT INTO slk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Keď zaznel z neba ten zvláštny šum, prilákal mnohých pútnikov. Tí ostali ohromení, keď počuli hovoriť Ježišových učeníkov v ich rodnom jazyku. ");
INSERT INTO slk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Čudovali sa a žasli: „Ako je to možné? Vari nie sú všetci, ktorí tu hovoria, Galilejčania? ");
INSERT INTO slk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ako to, že ich každý z nás počuje hovoriť vo svojom rodnom jazyku? ");
INSERT INTO slk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","My, Partovia, Médovia a Elamčania, obyvatelia Mezopotámie, Judska, Kapadócie, Pontu a Ázie, ");
INSERT INTO slk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frýgie a Pamfýlie, Egypta a krajov Líbye, z okolia Cyrény, ľudia z Ríma, ");
INSERT INTO slk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","rodení Žida aj na židovskú vieru obrátení pohania, Kréťania i Arabi – každý z nás ich počuje hovoriť o veľkých Božích veciach v našom rodnom jazyku.“ ");
INSERT INTO slk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Všetci žasli a zmätene sa spytovali jeden druhého: „Čo sa to deje?“ ");
INSERT INTO slk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ale poniektorí sa smiali a hovorili: „Sú opití.“ ");
INSERT INTO slk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tu vystúpil Peter s jedenástimi učeníkmi a mocným hlasom prehovoril k zástupu: „Pozorne ma počúvajte všetci, návštevníci aj obyvatelia Jeruzalema! ");
INSERT INTO slk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Niektorí z vás si myslia, že títo muži sú opití. To však nie je pravda! Veď je iba deväť hodín ráno. ");
INSERT INTO slk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ale splnilo sa to, čo predpovedal prorok Joel: ");
INSERT INTO slk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‚V posledných dňoch, hovorí Boh, zošlem svojho Ducha na všetkých ľudí a vaši synovia a dcéry budú prorokovať, vaši mladí ľudia budú mať videnia a starým sa budú snívať sny. ");
INSERT INTO slk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","V tých dňoch zošlem Svätého Ducha na mojich služobníkov, na mužov aj ženy, a budú prorokovať. ");
INSERT INTO slk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na nebi aj na zemi sa zjavia zvláštne znamenia, krv, oheň a stĺpy dymu. ");
INSERT INTO slk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Slnko sa zatmie a mesiac bude červený ako krv skôr, než príde veľký a slávny deň Pánov. ");
INSERT INTO slk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Len ten, kto ho uznáva za svojho Pána, bude zachránený.‘ “ ");
INSERT INTO slk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","A pokračoval: „Mužovia izraelskí, počujte: Žil tu medzi vami Ježiš z Nazareta, ktorého Boh preslávil veľkými zázrakmi a znameniami. Mnohí z vás by to mohli dosvedčiť. ");
INSERT INTO slk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A tohto muža ste sa vy zmocnili a rukami pohanov ste ho pribili na kríž. No tým ste vlastne splnili Boží úmysel. ");
INSERT INTO slk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Boh ho však vytrhol z moci smrti, ktorá ho nemohla udržať, a vzkriesil ho z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","To o ňom spieva Dávid v žalme: ‚Pána mám ustavične pred očami, stojí pri mne, a tak nezakolíšem. ");
INSERT INTO slk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Preto sa moje srdce raduje a moje ústa spievajú chválu, veď aj pre moje telo je nádej. ");
INSERT INTO slk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nezanecháš ma v ríši smrti a nedopustíš, aby sa telo tvojho vyvoleného rozpadlo na prach. ");
INSERT INTO slk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dal si mi poznať cestu, ktorá vedie k životu, a tvoja prítomnosť ma naplní radosťou.‘ ");
INSERT INTO slk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Milí bratia! Môžem vám smelo povedať, že náš praotec Dávid zomrel, bol pochovaný a jeho hrob tu máme až dodnes. ");
INSERT INTO slk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ale Dávid bol prorok a vedel o Božom sľube, že jeden z jeho potomkov bude sedieť na jeho tróne. ");
INSERT INTO slk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A tak, keď hovoril, že nezostane v ríši smrti a jeho telo sa nerozpadne na prach, prorokoval vlastne Kristovo vzkriesenie z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Áno, práve Ježiša Boh vzkriesil a my všetci to môžeme dosvedčiť. ");
INSERT INTO slk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Teraz je v nebesiach po Božej pravici, prijal Ducha Svätého, ktorého Boh sľúbil, a teraz ho zoslal na nás, ako to vidíte a počujete. ");
INSERT INTO slk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A Dávid nehovoril o sebe ani vtedy, keď napísal: ‚Boh povedal môjmu Pánovi: Seď po mojej pravici, ");
INSERT INTO slk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kým ti nepoložím nepriateľov pod nohy.‘ ");
INSERT INTO slk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nech teda vie každý Izraelita, že toho Ježiša, ktorého ste vy ukrižovali, urobil Boh Pánom a Mesiášom.“ ");
INSERT INTO slk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petrove slová sa hlboko dotkli sŕdc mnohých poslucháčov a začali sa spytovať apoštolov: „Bratia, čo máme robiť?“ ");
INSERT INTO slk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter im odpovedal: „Nech sa každý z vás odvráti od hriechu, navráti sa k Bohu a dá sa pokrstiť v mene Ježiša Krista na odpustenie hriechov a prijmete dar Svätého Ducha. ");
INSERT INTO slk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Veď to zasľúbenie patrí vám, vašim deťom, ba aj ľuďom po celom svete, ktorých si Pán, náš Boh, povolá.“ ");
INSERT INTO slk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ešte dlho im Peter hovoril o Ježišovi a naliehavo ich vyzýval: „Zachráňte sa pred týmito zvrátenými ľuďmi!“ ");
INSERT INTO slk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tí, ktorí prijali Petrove slová, dali sa pokrstiť. V ten deň sa pripojilo k Ježišovým nasledovníkom okolo tritisíc ľudí. ");
INSERT INTO slk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Trávili spolu čas pri vyučovaní apoštolov a vo vzájomnom zdieľaní sa, mali vzájomné spoločenstvo, jedli spolu a modlili sa. ");
INSERT INTO slk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Všetkých sa zmocnila bázeň, lebo Boh prostredníctvom apoštolov konal mnohé zázraky a znamenia. ");
INSERT INTO slk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Veriaci akoby tvorili jednu rodinu a so všetkými sa delili, ");
INSERT INTO slk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ba aj majetok mali spoločný. Predávali svoje majetky a peniaze delili medzi všetkých, ako kto potreboval. ");
INSERT INTO slk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Všetci sa spoločne každý deň zhromažďovali v jeruzalemskom chráme a v menších skupinách sa schádzavali po domoch, kde spolu jedávali. Ich srdcia boli naplnené radosťou a úprimnosťou ");
INSERT INTO slk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","a nadšene vyjadrovali svoju vďačnosť Bohu. Všetci ľudia ich mali radi a Pán im denne pridával ďalších, ktorí uverili a boli zachránení. ");
INSERT INTO slk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Raz popoludní okolo tretej sa Peter a Ján uberali do chrámu na pravidelné modlitby. ");
INSERT INTO slk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Práve ta prinášali nejakého človeka od narodenia chromého. Každý deň ho položili k chrámovej bráne, ktorá sa volala Krásna, a tam prosil o almužnu tých, čo vchádzali do chrámu. ");
INSERT INTO slk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Keď videl prichádzať Petra a Jána, aj ich poprosil o almužnu. ");
INSERT INTO slk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Zastali pri ňom a Peter povedal: „Pozri sa na nás!“ ");
INSERT INTO slk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Žobrák sa na nich zahľadel v očakávaní, že niečo dostane. ");
INSERT INTO slk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ale Peter pokračoval: „Žiadne peniaze nemám, ale dám ti to, čo mám. V mene Ježiša Krista Nazaretského vstaň a choď!“ ");
INSERT INTO slk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nato chytil žobráka za pravú ruku, zdvihol ho a v tom okamihu do ochrnutých nôh a kĺbov chromého vstúpila sila. ");
INSERT INTO slk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Vyskočil na nohy a začal chodiť. Spolu s apoštolmi vošiel do chrámu, skákal od radosti a chválil Boha. ");
INSERT INTO slk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Všetci ľudia ho mohli vidieť, ako chodí a chváli Boha. ");
INSERT INTO slk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Keď zistili, že je to ten chromý mrzák, ktorý sedával pri Krásnej bráne a žobral, boli ohromení a žasli nad tým, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Uzdravený zostával v blízkosti Petra a Jána a čoskoro sa okolo nich v Šalamúnom stĺporadí zhromaždilo mnoho ľudí naplnených údivom. ");
INSERT INTO slk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Keď to Peter videl, prihovoril sa zástupu: „Drahý Izraelčania, čo sa čudujete? Hádam si nemyslíte, že sme toho chromého uzdravili vlastnou mocou alebo zbožnosťou? ");
INSERT INTO slk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","To Boh, ktorého vyznávate, Boh našich praotcov – Abraháma, Izáka a Jákoba – týmto zázrakom oslávil a dokázal moc svojho Syna Ježiša. Toho Ježiša, ktorého ste vy vydali Rimanom a verejne ste sa ho zriekli pred Pilátom, hoci Pilát ho chcel oslobodiť. ");
INSERT INTO slk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A keď vám dal na výber, koho má prepustiť, vy ste sa zriekli Svätého a Spravodlivého a vyžiadali ste milosť pre vraha. ");
INSERT INTO slk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pôvodcu života ste zabili. Ale Boh ho vzkriesil z mŕtvych a my sme toho svedkami. ");
INSERT INTO slk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Viera v Ježišovo meno uzdravila tohto človeka; poznáte ho a viete, že bol chromý. To, že celkom vyzdravel pred vašimi očami, je výsledkom viery v Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Bratia, uvedomujem si, že to všetko ste konali v nevedomosti, rovnako ako vaši vodcovia. ");
INSERT INTO slk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Boh tak vlastne dopustil, aby sa naplnilo, že Kristus bude trpieť, tak ako to už dávno predpovedal ústami všetkých prorokov. ");
INSERT INTO slk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Preto teraz zmeňte svoje zmýšľanie a svoj postoj k Bohu, aby vám boli odpustené viny. ");
INSERT INTO slk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","A príde čas odpočinutia od Pána a pošle vám Ježiša, zasľúbeného Mesiáša. ");
INSERT INTO slk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Teraz je v nebi a zostane tam až dovtedy, kým nepríde čas, aby bolo všetko obnovené, ako o tom Boh oddávna hovoril ústami svojich svätých prorokov. ");
INSERT INTO slk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mojžiš povedal: ‚Z vášho národa si raz Pán, náš Boh, povolá Proroka, podobne ako k vám poslal mňa. Počúvajte pozorne, čo vám bude hovoriť. ");
INSERT INTO slk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kto však tohto Proroka neposlúchne, bude vyhladený z ľudu.‘ ");
INSERT INTO slk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Aj ostatní proroci, počnúc Samuelom, často hovorili o dobe, ktorú práve prežívame. ");
INSERT INTO slk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vy ste synmi tých prorokov a máte dedičský podiel na zmluve, ktorú Boh uzavrel s vašimi otcami. Abrahámovi sľúbil: ‚Cez tvoje potomstvo budú požehnané všetky národy zeme.‘ ");
INSERT INTO slk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Vám predovšetkým poslal Boh svojho Syna Ježiša, ktorý vás požehná a urobí šťastnými tým, že zmeníte svoj život a zanecháte zlo.“ ");
INSERT INTO slk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kým Peter a Ján hovorili k ľudu, kňazi a saduceji na nich priviedli veliteľa chrámovej stráže: ");
INSERT INTO slk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","boli totiž veľmi rozhorčení, že Peter a Ján učia v chráme a hlásajú, že Ježiš vstal z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Zatkli ich teda, a keďže už bol večer, uvrhli ich do druhého dňa do väzenia. ");
INSERT INTO slk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ale mnohí, ktorí počuli Božie slovo, uverili, takže počet veriacich vzrástol asi na päťtisíc. ");
INSERT INTO slk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na druhý deň zasadla v Jeruzaleme židovská veľrada – politickí a náboženskí predstavitelia a znalci Zákona – ");
INSERT INTO slk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","za prítomnosti veľkňaza Kaifáša, jeho predchodcu Annáša, Jána, Alexandra a ostatných príslušníkov z veľkňazského rodu. ");
INSERT INTO slk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dali si predvolať Petra a Jána a začali ich vypočúvať: „Akou mocou a v mene koho ste to urobili?“ ");
INSERT INTO slk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tu Peter, keďže bol naplnený Duchom Svätým, odpovedal: „Vážení vodcovia a predstavitelia ľudu! ");
INSERT INTO slk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ak nás vyšetrujete pre dobro, ktoré sme spôsobili chromému človeku, a chceli by ste vedieť, kto ho uzdravil, ");
INSERT INTO slk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tak vyhlasujeme pred vami aj pred celým izraelským národom, že sa to stalo v mene Mesiáša, Ježiša z Nazareta, ktorého ste ukrižovali, ale Boh ho vzkriesil z mŕtvych. Vďaka jeho moci stojí tento človek pred vami zdravý. ");
INSERT INTO slk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na Ježiša sa vzťahujú slová Písma: ‚Kameň, ktorý stavitelia zavrhli, stal sa kameňom základným, najdôležitejším v celej stavbe.‘ ");
INSERT INTO slk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Len v ňom je záchrana. A niet na celom svete iné meno, ktorého by sa mohli ľudia dovolávať, ak chcú byť zachránení pre večnosť.“ ");
INSERT INTO slk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Členovia veľrady boli prekvapení, akí sú Peter a Ján smelí a presvedčiví. Poznali ich totiž ako Ježišových spoločníkov – jednoduchých a nevzdelaných. ");
INSERT INTO slk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","A keď videli uzdraveného človeka, ktorý tam stál s apoštolmi, nedokázali proti nim nič povedať. ");
INSERT INTO slk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Prikázali apoštolom, aby opustili zasadanie a začali sa medzi sebou radiť: ");
INSERT INTO slk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Čo s nimi urobíme? Nemôžeme poprieť, že vykonali veľký zázrak, veď to videl celý Jeruzalem. ");
INSERT INTO slk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ale musíme zabrániť, aby sa tie ich reči ďalej šírili. Prísne im pohrozíme a zakážeme hovoriť o Ježišovi.“ ");
INSERT INTO slk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Zavolali ich späť a zakázali im o Ježišovi hovoriť a učiť o ňom. ");
INSERT INTO slk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ale Peter a Ján odpovedali: „Posúďte sami, či je v Božích očiach správne, aby sme viac poslúchali vás ako Boha? ");
INSERT INTO slk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nemôžeme predsa mlčať o tom, čo sme videli a počuli!“ ");
INSERT INTO slk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Znovu im pohrozili, ale napokon ich prepustili, lebo nenašli nič, za čo by ich mohli potrestať. A navyše sa báli, že by sa ľudia mohli búriť, lebo všetci oslavovali Boha za to, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Veď ten chromý, ktorý bol zázračne uzdravený, mal už vyše štyridsať rokov. ");
INSERT INTO slk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Len čo sa Peter a Ján dostali na slobodu, vrátili sa medzi svojich a porozprávali všetko, čo im veľkňazi a vodcovia ľudu povedali. ");
INSERT INTO slk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Keď to veriaci počuli, jednomyseľne sa modlili: „Pane Bože, ty si stvoril nebo, zem, more i všetko, čo len jestvuje. ");
INSERT INTO slk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ty si ústami nášho otca Dávida, tvojho služobníka, ktorý bol vedený Duchom Svätým, povedal: ‚Prečo sa búria pohania a národy kujú márne plány? ");
INSERT INTO slk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pozemskí králi povstávajú a vládcovia sa spolčujú proti Bohu a jeho Pomazanému.‘ ");
INSERT INTO slk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A naozaj sa v tomto meste spolčil kráľ Herodes s miestodržiteľom Pilátom Pontským a Izraeliti sa spriahli s pohanmi, aby zabili tvojho svätého služobníka Ježiša, ktorého si si vyvolil. ");
INSERT INTO slk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ale vykonali iba to, čo tvoja moc a vôľa dávno rozhodli, že sa stane. ");
INSERT INTO slk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pane, a teraz sa vyhrážajú aj nám. Prosíme, daj nám odvahu, aby sme ako tvoji služobníci hovorili tvoju zvesť ľuďom smelo a bez zábran. ");
INSERT INTO slk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dokáž svoju moc! Daj, aby sa diali uzdravenia, znamenia a zázraky v moci tvojho svätého služobníka Ježiša!“ ");
INSERT INTO slk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Keď sa domodlili, zatriasol sa dom, v ktorom boli zhromaždení, a všetkých naplnil Svätý Duch. A odvážne a neohrozene hlásali ďalej Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Všetci veriaci boli jednomyseľní a nažívali v láske. Nik z nich nepokladal nič z toho, čo mal, za vlastné, ale všetko mali spoločné. ");
INSERT INTO slk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Svedectvo apoštolov o vzkriesení Pána Ježiša bolo veľmi mocné a všetci zakúšali Božiu milosť. ");
INSERT INTO slk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nikto medzi nimi netrpel núdzu, lebo tí, čo mali domy a pozemky, ich predávali a peniaze, ktoré utŕžili, ");
INSERT INTO slk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","prinášali apoštolom. Tí ich rozdeľovali podľa toho, ako kto potreboval. ");
INSERT INTO slk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jedným z takýchto darcov bol napríklad levita Jozef z Cypru, ktorého apoštoli nazvali Barnabáš, to znamená Syn potešenia. ");
INSERT INTO slk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ten vlastnil pole, ktoré predal a peniaze odovzdal apoštolom. ");
INSERT INTO slk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aj istý muž, ktorý sa volal Ananiáš, a jeho žena Zafira predali svoj pozemok. ");
INSERT INTO slk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiáš si však s vedomím svojej manželky časť utŕžených peňazí nechal pre seba a zvyšok doniesol apoštolom. ");
INSERT INTO slk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter mu však povedal: „Ananiáš, prečo si dovolil satanovi, aby ťa ovládol? Ak si si nechal časť peňazí, ktoré si dostal za to pole, klameš nie nás, ale Svätého Ducha. ");
INSERT INTO slk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","To pole bolo predsa tvoje a mohol si si ho nechať. A keď si ho predal, s peniazmi si mohol naložiť podľa vlastného uváženia. Prečo si sa rozhodol takto klamať? Neoklamal si nás, ale samého Boha!“ ");
INSERT INTO slk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Keď to Ananiáš počul, zrútil sa a na mieste bol mŕtvy. Všetci, čo to počuli, sa zdesili. ");
INSERT INTO slk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mladší z mužov ho prikryli plachtou, vyniesli a pochovali. ");
INSERT INTO slk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Asi o tri hodiny prišla jeho žena Zafira, ktorá netušila, čo sa stalo. ");
INSERT INTO slk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter sa jej spýtal: „Počuj, Zafira, za toľko a toľko ste predali pole?“ Odpovedala: „Áno, presne za toľko.“ ");
INSERT INTO slk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter jej na to povedal: „Ako ste sa len mohli dohodnúť a pokúšať Božieho Ducha. Pozri, práve sa vracajú tí, ktorí pochovali tvojho muža. Ten istý údel stihne aj teba.“ ");
INSERT INTO slk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A v tom okamihu Zafira padla Petrovi k nohám a umrela. Keď mládenci vošli dnu, našli ju už mŕtvu. Odniesli ju a pochovali k jej mužovi. ");
INSERT INTO slk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Celej cirkvi i všetkých, čo to počuli, sa zmocnil veľký strach. ");
INSERT INTO slk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Prostredníctvom apoštolov sa v národe diali veľké divy a znamenia. Všetci sa pravidelne schádzali v Šalamúnovom stĺporadí v chráme. ");
INSERT INTO slk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ostatní sa k nim neodvážili pripojiť, ale všetci ľudia o nich hovorili s veľkou úctou. ");
INSERT INTO slk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pribúdalo čoraz viac mužov a žien, ktorí uverili v Pána. ");
INSERT INTO slk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Došlo to tak ďaleko, že ľudia vynášali na ulice chorých na rohožiach a nosidlách, aby na nich mohol padnúť aspoň Petrov tieň, keď bude prechádzať okolo. ");
INSERT INTO slk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ba mnohí prichádzali do Jeruzalema aj zo širšieho okolia a prinášali svojich chorých a posadnutých zlými duchmi. A všetci boli uzdravení. ");
INSERT INTO slk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pribúdanie veriacich vyvolalo veľkú žiarlivosť a strach vo veľkňazovi a jeho prívržencoch, saducejoch. ");
INSERT INTO slk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","A tak dali apoštolov znova zatknúť, tentoraz do mestského väzenia. ");
INSERT INTO slk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ale Pánov anjel otvoril v noci dvere žalára, vyviedol apoštolov von a povzbudil ich: ");
INSERT INTO slk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Choďte naspäť do chrámu a hovorte všetkým ľuďom o novom živote.“ ");
INSERT INTO slk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Poslúchli ho a už na svitaní boli v chráme a učili. Medzitým sa zišiel veľkňaz so svojimi stúpencami, zvolali veľradu a za prítomnosti predstaviteľov izraelského národa kázali predvolať apoštolov z väzenia. ");
INSERT INTO slk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ale keď strážcovia prišli do väzenia, našli ho prázdne. Vrátili sa teda a oznámili: ");
INSERT INTO slk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","„Dvere žalára boli zamknuté aj dobre strážené, ale keď sme odomkli, nikoho sme vnútri nenašli.“ ");
INSERT INTO slk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tieto slová vyvolali u veliteľa chrámovej stráže aj veľkňazov poriadny zmätok. Nedokázali si totiž vysvetliť, ako sa to mohlo stať. ");
INSERT INTO slk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Vtom však ktosi pribehol a oznámil: „Tí muži, ktorých ste včera uväznili, sú zasa v chráme a pokojne vyučujú ľudí.“ ");
INSERT INTO slk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Veliteľ odišiel aj so strážcami, ale nezmocnili sa ich násilne, lebo sa báli, že ich ľud ukameňuje; apoštoli sa pred židovskú radu dali predviesť dobrovoľne. ");
INSERT INTO slk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Veľkňaz ich obvinil: ");
INSERT INTO slk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Prísne sme vám zakázali hovoriť o tom človeku. Ale vy ste naplnili celý Jeruzalem svojím učením. A navyše na nás zvaľujete zodpovednosť za jeho smrť!“ ");
INSERT INTO slk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter odpovedal aj v mene ostatných apoštolov: „Boha predsa musíme poslúchať viac ako ľudí! ");
INSERT INTO slk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","To Boh našich praotcov vzkriesil z mŕtvych Ježiša, ktorého ste vy potupne pribili na kríž a usmrtili. ");
INSERT INTO slk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ale práve jemu zveril veľkú úlohu Vodcu a Záchrancu, aby Izrael priviedol k zmene života a odpustil mu hriechy. ");
INSERT INTO slk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","A my sme jeho svedkami a takisto Duch Svätý, ktorého Boh dal každému, kto ho poslúcha.“ ");
INSERT INTO slk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tieto slová rozzúrili všetkých v rade a chceli ich zabiť. ");
INSERT INTO slk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","No tu sa o slovo prihlásil známy farizej, zvaný Gamaliel, učiteľ Zákona a človek veľmi vážený medzi ľuďmi. Dal pokyn, aby obžalovaných na chvíľku odviedli, ");
INSERT INTO slk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","a potom povedal: „Izraeliti, dobre si rozmyslite, čo urobíte s týmito ľuďmi. ");
INSERT INTO slk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Spomínate si na rozruch okolo Teuda? Robil zo seba veľkú osobnosť a podarilo sa mu zhromaždiť okolo seba štyristo ľudí. Ale keď ho zabili, jeho stúpenci sa rozpŕchli a bolo po všetkom. ");
INSERT INTO slk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Alebo si spomeňte na Júdu Galilejského, ktorý vystúpil počas sčítania ľudu. Aj on zahynul a jeho prívržencov rozohnali. ");
INSERT INTO slk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A tak vám radím: Nechajte týchto ľudí na pokoji, nech si idú. Ak je to zasa len nejaké ľudské hnutie, čoskoro sa samo rozpadne. ");
INSERT INTO slk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ale ak za ním stojí Boh, nebudete ich môcť zastaviť, veď by ste bojovali proti samému Bohu.“ ");
INSERT INTO slk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jeho reč ich presvedčila. Predviedli apoštolov, dali ich zbičovať a znova im prísne zakázali hovoriť o Ježišovi. Potom ich prepustili. ");
INSERT INTO slk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apoštoli odchádzali z veľrady naplnení radosťou, že smeli trpieť pre Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naďalej učili každý deň v chráme i po domoch a šírili radostnú zvesť o tom, že Ježiš je Mesiáš. ");
INSERT INTO slk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","S rýchlym rastom cirkvi sa začali vyskytovať aj nezhody. Kresťania, pochádzajúci z Grékov, sa ponosovali, že ich vdovám sa pri rozdeľovaní prostriedkov na obživu nedáva spravodlivý diel. ");
INSERT INTO slk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","A tak dvanásti apoštoli zvolali všetkých veriacich a predložili im tento návrh: „Určite by nebolo správne, aby sme sa prestali venovať hlásaniu Božieho posolstva, a namiesto toho dávali pozor, či sa všetko rozdeľuje spravodlivo. ");
INSERT INTO slk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Preto vám navrhujeme, bratia, aby ste si zvolili spomedzi seba sedem rozvážnych mužov, ktorí sa už osvedčili a sú naplnení Svätým Duchom. Im zveríme tieto úlohy ");
INSERT INTO slk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","a my sa budeme môcť aj naďalej venovať predovšetkým modlitbám a kázaniu Božieho slova.“ ");
INSERT INTO slk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","S týmto návrhom všetci zhromaždení súhlasili a hneď aj pristúpili k voľbe. Vyvolili si Štefana, muža neochvejnej viery, ktorý bol plný Svätého Ducha, ďalej Filipa, Prochora, Nikanora, Timona, Parména a Mikuláša z Antiochie, pôvodom pohana, ktorý prestúpil na židovstvo. ");
INSERT INTO slk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Siedmich zvolených bratov predstavili apoštolom, ktorí na nich položili ruky a vyprosili pre nich Božie požehnanie. ");
INSERT INTO slk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Božie Slovo sa rýchlo šírilo ďalej a počet učeníkov v Jeruzaleme veľmi rástol. Dokonca aj mnohí z kňazov uverili v Krista. ");
INSERT INTO slk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Štefana Boh obdaril mimoriadnou vierou a mocou, takže konal medzi ľuďmi veľké zázraky. ");
INSERT INTO slk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jedného dňa sa dostal do sporu so Židmi, ktorí patrili k takzvanej synagóge prepustencov, ľuďmi z Cyrény a Alexandrie, a tiež so Židmi z Cilície a z Malej Ázie. ");
INSERT INTO slk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Keď videli, že ich argumenty neobstoja pred Štefanovou múdrosťou a Božím Duchom, v ktorého moci hovoril, ");
INSERT INTO slk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","naviedli proti nemu falošných žalobcov, ktorí vraveli: „Počuli sme, ako sa rúha Mojžišovi, ba aj samému Bohu!“ ");
INSERT INTO slk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Touto obžalobou poštvali proti Štefanovi nielen ľud, ale aj vodcov a učiteľov Zákona. Napokon Štefana zatkli a predviedli pred veľradu. ");
INSERT INTO slk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Falošní svedkovia tam zopakovali svoju obžalobu: „Tento človek neprestajne hovorí proti chrámu aj proti Mojžišovmu zákonu. ");
INSERT INTO slk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na vlastné uši sme počuli, ako hovoril, že Ježiš z Nazareta zborí chrám a zmení poriadky, ktoré nám dal Mojžiš.“ ");
INSERT INTO slk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Po tomto obvinení sa všetci zahľadeli na Štefana a videli, že jeho tvár bola ako tvár anjela. ");
INSERT INTO slk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Veľkňaz sa ho spýtal: „Je to, čo hovoria, pravda?“ ");
INSERT INTO slk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","„Bratia a otcovia, vypočujte ma!“ oslovil ich Štefan. „Slávny Boh sa kedysi zjavil nášmu predkovi Abrahámovi už v Mezopotámii, skôr, ako sa presídlil do Cháranu ");
INSERT INTO slk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","a dal mu príkaz: ‚Opusť svoju rodnú krajinu a svojich príbuzných a choď do zeme, ktorú ti ukážem!‘ ");
INSERT INTO slk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Vysťahoval sa teda z Chaldejskej krajiny a býval v Chárane v Sýrii až do smrti svojho otca. Odtiaľ ho potom Boh priviedol do tejto krajiny, v ktorej bývate teraz aj vy. ");
INSERT INTO slk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","No nedal tu Abrahámovi do vlastníctva ani kúsok zeme, hoci mu sľúbil, že ju dá natrvalo jemu a jeho potomkom, i keď vtedy ešte nemal syna. ");
INSERT INTO slk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ďalšia Božia predpoveď bola: ‚Tvoji potomkovia sa odtiaľto vysťahujú do cudzej krajiny a budú tam štyristo rokov otročiť za veľmi ťažkých podmienok. ");
INSERT INTO slk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ale ja potrestám národ, ktorý si ich zotročí, a potom ich vyvediem a budú ma uctievať na tomto mieste.‘ ");
INSERT INTO slk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Boh uzavrel s Abrahámom zmluvu a jej viditeľným znamením sa stala obriezka. Keď sa podľa Božieho sľubu narodil Abrahámovi Izák, na ôsmy deň ho obrezal. Práve tak obrezal Izák Jákoba a Jákob svojich dvanásť synov, našich praotcov. ");
INSERT INTO slk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jeden z nich, Jozef, sa stal terčom závisti svojich bratov, a preto ho predali ako otroka do Egypta. Ale Boh bol s ním a ");
INSERT INTO slk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","vyslobodil ho zo všetkých útrap. Pre jeho prezieravosť a múdrosť si ho veľmi obľúbil sám faraón, egyptský vládca a zveril mu úlohu správcu Egypta i kráľovského paláca. ");
INSERT INTO slk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Potom vypukol v Egypte aj v Palestíne veľký hlad a naši praotcovia trpeli núdzou, lebo nemali čo jesť. ");
INSERT INTO slk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Vtedy sa Jákob dopočul, že v Egypte majú zásoby obilia, a poslal tam dvakrát svojich synov. ");
INSERT INTO slk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pri druhej návšteve sa dal Jozef svojim bratom poznať, a tak sa faraón dozvedel o Jozefovom pôvode. ");
INSERT INTO slk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jozef potom poslal po otca Jákoba a presťahoval do Egypta celú rodinu, dokopy sedemdesiatpäť ľudí. ");
INSERT INTO slk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Usadili sa tam a Jákob i naši praotcovia zostali v Egypte až do smrti. ");
INSERT INTO slk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ich pozostatky preniesli do Sichemu a pochovali ich do hrobky, ktorú si kedysi Abrahám kúpil od synov Emorových a zaplatil za ňu striebrom. ");
INSERT INTO slk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Medzitým sa priblížil čas naplnenia Božieho sľubu Abrahámovi. Náš ľud sa v tom čase v Egypte veľmi rozmnožil. ");
INSERT INTO slk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na trón však nastúpil faraón, ktorý už o Jozefovi nevedel nič. ");
INSERT INTO slk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ten zaobchádzal s našim národom nepriateľsky a prikázal našim otcom, aby sa zriekli novonarodených detí a usmrtili ich. ");
INSERT INTO slk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","V tom čase sa narodil Mojžiš, s ktorým mal Boh svoje plány. Rodičia sa o chlapca starali tri mesiace doma. ");
INSERT INTO slk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Keď ho už nemohli mať viac pri sebe, ujala sa ho faraónova dcéra a starala sa oňho, akoby to bol jej vlastný syn. ");
INSERT INTO slk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mojžiš dostal najlepšie egyptské vzdelanie a vyrástol z neho výrečný a schopný muž. ");
INSERT INTO slk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Keď mal štyridsať rokov, zatúžil navštíviť svojich izraelských bratov. ");
INSERT INTO slk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Vtedy sa stal svedkom toho, ako Egypťan jednému z nich nespravodlivo ubližuje. Zastal sa ho a pomstil utláčaného tým, že Egypťana zabil. ");
INSERT INTO slk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Myslel si, že bratia pochopia, že im Boh posiela pomocou neho záchranu, ale nepochopili to. ");
INSERT INTO slk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na druhý deň sa usiloval zmieriť dvoch Židov, ktorí sa hádali. ‚Čo to robíte? Ste predsa bratia. Prečo si navzájom ubližujete?‘ upokojoval ich. ");
INSERT INTO slk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ale ten, ktorý ubližoval svojmu blížnemu, odstrčil Mojžiša a povedal: ‚Kto ťa poveril, aby si nám vládol a súdil nás?‘ ");
INSERT INTO slk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‚Hádam ma len nechceš zabiť ako včera toho Egypťana?‘ ");
INSERT INTO slk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mojžiš sa tých slov zľakol a utiekol do Madiánskej krajiny. Žil tam ako cudzinec, oženil sa a mal dvoch synov. ");
INSERT INTO slk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Po štyridsiatich rokoch vyhnanstva sa mu v plameňoch horiaceho kríka zjavil na púšti pri vrchu Sinaj anjel. ");
INSERT INTO slk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Keď sa chcel udivený Mojžiš zblízka pozrieť na ten nezvyčajný úkaz, počul Boží hlas: ");
INSERT INTO slk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‚Ja som Boh tvojich otcov, Boh Abraháma, Izáka a Jákoba.‘ Mojžiš sa roztriasol od strachu a neodvážil sa ísť ďalej. ");
INSERT INTO slk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ale Boh pokračoval: ‚Vyzuj sa, lebo stojíš na svätom mieste! ");
INSERT INTO slk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Dobre som videl trápenie svojho ľudu v Egypte a počul som jeho ston. Preto som zostúpil, aby som ho vyslobodil. A teraz poď, pošlem ťa do Egypta.‘ ");
INSERT INTO slk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Bol to ten istý Mojžiš, ktoré predtým odmietli slovami: ‚Kto ťa poveril, aby si nám vládol a súdil nás?‘ Práve jeho Boh poslal prostredníctvom anjela ako vládcu a vysloboditeľa. ");
INSERT INTO slk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A Mojžiš ich vyviedol z Egypta a konal veľké divy a znamenia v Egypte, pri Červenom mori i počas štyridsaťročného putovania po púšti. ");
INSERT INTO slk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Práve Mojžiš povedal Izraelitom: ‚Pán Boh vám pošle proroka z vášho národa ako som ja.‘ ");
INSERT INTO slk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mojžiš bol sprostredkovateľom medzi anjelom, ktorý k nemu hovoril na vrchu Sinaj, a našimi otcami na púšti. Prijal pre nás slová života, aby nám ich oodvzdal. ");
INSERT INTO slk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","A napriek tomu ho naši otcovia neposlúchali, búrili sa proti nemu a túžili sa vrátiť do Egypta. ");
INSERT INTO slk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Vyzvali preto Árona: ‚Urob nám bohov, aby nás viedli na ďalšej ceste. Veď nevieme, čo sa stalo s tým Mojžišom, ktorý nás vyviedol z Egypta.‘ ");
INSERT INTO slk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A tak si urobili sochu teľaťa, obetovali jej a s radosťou oslavovali výtvor vlastných rúk. ");
INSERT INTO slk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ale Boh sa od nich odvrátil, aby sa klaňali nebeskému vojsku, ako sa o tom píše v prorokoch: ‚Či ste to mne prinášali dary a obete počas štyridsaťročného putovania po púšti, národ izraelský? ");
INSERT INTO slk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nosili ste so sebou stánok Molocha a hviezdu boha Remfana, ktoré ste si sami vytvorili, a tým ste sa klaňali. Preto pôjdete do vyhnanstva až za Babylon.‘ ");
INSERT INTO slk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na púšti mali naši otcovia stánok svedectva. Boh totiž Mojžišovi prikázal, aby ho urobil podľa vzoru, ktorý mu ukázal. ");
INSERT INTO slk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tento stánok prenášali naši otcovia pri svojom putovaní púšťou a za Jozuu ho doniesli do zeme pohanov, ktorých Boh odtiaľ vyhnal. Stánok zmluvy slúžil až do čias kráľa Dávida, ");
INSERT INTO slk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ktorého Boh obdaril svojou priazňou. Dávid ho prosil, aby mohol zaobstarať miesto pre príbytok Jákobovmu Bohu. ");
INSERT INTO slk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Až Šalamún však vystaval Bohu chrám. ");
INSERT INTO slk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ale Najvyšší nebýva v chrámoch postavených ľudskými rukami! Ako hovorí prorok: ");
INSERT INTO slk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‚Nebesia sú mojím trónom a zem je podnožou mojich nôh. Aký chrám mi chcete vystavať, hovorí Pán? Je vôbec miesto, kde by som mohol bývať? ");
INSERT INTO slk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Či to všetko nestvorila moja ruka?‘ ");
INSERT INTO slk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","No vy ste takí istí ako vaši otcovia: ste tvrdošijní, vaše srdcia sú ako srdcia tých, ktorí neveria v Boha, nepočúvate ho a neustále odporujete Svätému Duchu. ");
INSERT INTO slk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Našiel by sa prorok, ktorého vaši otcovia neprenasledovali? Zabíjali tých, ktorí predpovedali príchod Spravodlivého, ale vy ste sa ho úplne zriekli a zavraždili ste ho! ");
INSERT INTO slk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Prijali ste Boží zákon z rúk anjelov, ale sami ste ho nezachovávali!“ ");
INSERT INTO slk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Keď to členovia veľrady počuli, rozzúrili sa na neho a od zlosti až škrípali zubami. ");
INSERT INTO slk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ale Štefan, plný Ducha Svätého, hľadel uprene do neba. Uvidel Božiu slávu a Ježiša stáť po Božej pravici. ");
INSERT INTO slk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","„Vidím otvorené nebesia,“ zvolal, „a Syna človeka, ako stojí po Božej pravici!“ ");
INSERT INTO slk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tu prehlušili Štefana krikom a zapchávali si uši, aby už nič nepočuli. Spoločne sa na neho vrhli, ");
INSERT INTO slk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","odvliekli ho za hradby mesta, aby ho ukameňovali. Tí, čo počuli Štefanove slová, vyzliekli si plášte a dali ich strážiť mladému Saulovi. ");
INSERT INTO slk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","No Štefan, kým ho kameňovali, prosil Pána: „Pane Ježišu, prijmi môjho ducha!“ ");
INSERT INTO slk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Potom padol na kolená a nahlas zvolal: „Pane, odpusť im tento hriech!“ Po týchto slovách skonal. ");
INSERT INTO slk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul schvaľoval, že Štefana zabili. V ten deň vypuklo veľké prenasledovanie cirkvi v Jeruzaleme. Všetci, okrem apoštolov, sa rozpŕchli po Judsku a Samárii. ");
INSERT INTO slk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Niektorí zbožní muži pochovali Štefana a hlboko za ním žialili. ");
INSERT INTO slk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A Saul sa pustil do ničenia cirkvi: vtrhával do domov, zatýkal veriacich mužov aj ženy, ktorí sa tam schádzali, a dával ich do väzenia. ");
INSERT INTO slk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ale veriaci, ktorí utiekli z Jeruzalema, všade, kam prišli, šírili dobrú správu o Ježišovi. ");
INSERT INTO slk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip sa dostal do mesta Samária a tam kázal o Kristovi. ");
INSERT INTO slk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Všetkých veľmi zaujalo jeho posolstvo – slová i zázraky, ktorých sa stali svedkami. ");
INSERT INTO slk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Uzdravil totiž mnohých posadnutých démonmi, ochrnutých aj chromých. ");
INSERT INTO slk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","V celom meste zavládla veľká radosť. ");
INSERT INTO slk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","V Samárii žil istý Šimon, ktorý svojimi čarodejnými trikmi a mágiou uchvacoval ľudí a samého seba považoval za výnimočného. ");
INSERT INTO slk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mal veľký vplyv na jednoduchých i významných ľudí a všeobecne sa o ňom hovorilo: „V Šimonovi na zem zostúpil boh nazývaný Veľká Moc.“ ");
INSERT INTO slk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ľudia sa ním nechali ovplyvniť aj preto, lebo svoju mágiu konal medzi nimi už veľmi dlho. ");
INSERT INTO slk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ale keď uverili Filipovej zvesti o Božom kráľovstve a o Ježišovi Kristovi, dávali sa krstiť muži aj ženy. ");
INSERT INTO slk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Uveril dokonca aj Šimon a dal sa pokrstiť. Takmer sa nepohol od Filipa, uchvátený znameniami a mocnými činmi, ktoré Filip robil. ");
INSERT INTO slk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Keď sa apoštoli v Jeruzaleme dozvedeli, že v Samárii prijali Božiu zvesť, vyslali tam Petra a Jána. ");
INSERT INTO slk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Keď prišli do Samárie, prosili Boha, aby aj im daroval Svätého Ducha, ");
INSERT INTO slk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","lebo doposiaľ ho ešte nik z nich neprijal, hoci boli pokrstení v meno Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter a Ján vložili teda ruky na týchto veriacich a prijali Ducha Svätého. ");
INSERT INTO slk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Keď Šimon videl, že veriaci dostávajú Svätého Ducha, keď na nich apoštoli vkladajú ruky, ponúkol im peniaze ");
INSERT INTO slk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","s prosbou: „Dajte aj mne túto moc, aby každý, na koho položím ruky, dostal Svätého Ducha!“ ");
INSERT INTO slk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter mu odpovedal: „Nech sú tie peniaze zatratené spolu s tebou! Myslíš si azda, že sa Boží dar dá kúpiť? ");
INSERT INTO slk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nemôžeš dostať tento dar, lebo tvoje srdce nie je úprimné pred Bohom. ");
INSERT INTO slk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Odvráť sa od tejto ohavnosti, zanechaj ju a pros Boha – možno ti odpustí tvoje zámery, ");
INSERT INTO slk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","lebo vidím, že si plný trpkej závisti a že si v zajatí hriechu.“ ");
INSERT INTO slk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Šimon zahanbene prosil: „Proste za mňa Boha, aby ma nepostihlo to, o čom ste hovorili.“ ");
INSERT INTO slk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peter a Ján pokračovali vo vydávaní svedectva a kázali slovo Pánovo. Potom sa vrátili do Jeruzalema, no cestou sa zastavili vo viacerých samaritánskych mestečkách a šírili aj tam radostnú zvesť o Kristovi. ");
INSERT INTO slk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filip dostal pokyn od Božieho anjela: „Pober sa smerom na juh, na osamelú cestu, ktorá vedie z Jeruzalema do Gazy.“ ");
INSERT INTO slk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip sa vydal na cestu. Onedlho zazrel sprievod etiópskeho hodnostára, správcu pokladu etiópskej kráľovnej. Bol sa v Jeruzaleme pokloniť Bohu ");
INSERT INTO slk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","a teraz sa vracal vo svojom voze a čítal zvitok proroka Izaiáša. ");
INSERT INTO slk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Boží Duch vnukol Filipovi: „Dobehni ten voz a choď vedľa neho!“ ");
INSERT INTO slk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip k nemu pribehol, a začul, ako si muž nahlas číta Izaiášovo proroctvo. Spýtal sa ho: „Rozumieš tomu, čo čítaš?“ ");
INSERT INTO slk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiópčan odpovedal: „Nerozumiem. Potreboval by som, aby mi to niekto vysvetlil.“ Pozval Filipa, aby si k nemu prisadol. ");
INSERT INTO slk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Práve čítal slová: „Bol ako ovca vedená na zabitie; ako baránok, ktorý onemie, keď ho strihajú; ani on neotvoril ústa. ");
INSERT INTO slk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Vo svojom ponížení bol zbavený všetkých svojich práv. Kto môže hovoriť o jeho potomkoch? Veď bol vzatý preč zo zeme.“ ");
INSERT INTO slk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dvoran sa spýtal Filipa: „Povedz mi, prosím, o kom to hovoril prorok? O sebe, alebo o niekom inom?“ ");
INSERT INTO slk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A tak Filip nadviazal na tieto prorocké slová a ukázal, ako sa splnili na Ježišovi. ");
INSERT INTO slk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cestou sa dostali k akejsi vode. Dvoran zvolal: „Pozri, voda! Prečo by som nemohol byť aj ja pokrstený?“ ");
INSERT INTO slk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip mu odpovedal: „Ak si uveril celým srdcom, prečo nie?“ Dvoran vyznal: „Verím, že Ježiš Kristus je Boží Syn.“ ");
INSERT INTO slk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dal zastaviť koč, vstúpil s Filipom do vody a Filip ho pokrstil. ");
INSERT INTO slk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Keď vyšli na breh, Pánov Duch sa Filipa zmocnil a dvoran ho viac nevidel. Pokračoval teda vo svojej ceste a jeho vnútro bolo naplnené radosťou. ");
INSERT INTO slk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip sa potom ocitol v Azote, prešiel celým krajom až do Cézarey a v každom meste šíril radostnú zvesť o Ježišovi. ");
INSERT INTO slk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul sa ešte stále vyhrážal Pánovým učeníkom a dychtivo túžil po ich vyvraždení. Zašiel preto za veľkňazom ");
INSERT INTO slk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a vyžiadal si poverovacie listiny pre židovské synagógy v Damasku. Ak by tam našiel stúpencov tohto nového učenia, mužov alebo ženy, chcel ich zajať a spútaných priviesť do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Vybral sa teda do Damasku, a keď už bol neďaleko, ožiarilo ho zrazu svetlo z neba. ");
INSERT INTO slk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Padol na zem a počul, ako mu nejaký hlas hovorí: „Saul, Saul, prečo ma prenasleduješ?“ ");
INSERT INTO slk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul sa spýtal: „Kto si, Pane?“ Hlas odpovedal: „Ja som Ježiš, ktorého ty prenasleduješ. ");
INSERT INTO slk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Teraz vstaň, choď do mesta a tam sa dozvieš, čo máš ďalej robiť!“ ");
INSERT INTO slk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mužovia, čo sprevádzali Saula, ostali stáť v nemom úžase, počuli síce nejaký hlas, ale nikoho nevideli. ");
INSERT INTO slk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul vstal, ale keď otvoril oči, zistil, že nič nevidí. Chytili ho za ruky a odviedli do Damasku. ");
INSERT INTO slk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tri dni trvala jeho slepota a po celý čas nejedol ani nepil. ");
INSERT INTO slk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","V Damasku žil veriaci muž zvaný Ananiáš. Tomu sa vo videní zjavil Pán Ježiš a oslovil ho: „Ananiáš!“ „Tu som Pane,“ odpovedal. ");
INSERT INTO slk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pán mu povedal: „Choď do Priamej ulice. Tam sa v Júdovom dome spýtaj na Saula, ktorý pochádza z Tarzu. Práve sa modlí ");
INSERT INTO slk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","a má videnie, ako k nemu prichádza muž menom Ananiáš, kladie naňho ruky a ako sa mu vracia zrak.“ ");
INSERT INTO slk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiáš namietol: „Pane, počul som od mnohých, koľko zla napáchal tento muž tvojim verným v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A aj sem vraj prišiel s poverením od veľkňazov, aby zatkol každého, kto ťa nasleduje.“ ");
INSERT INTO slk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pán mu však povedal: „Len choď a urob všetko, ako ti vravím. Ja som si ho vybral ako zvláštny nástroj, ktorý ponesie zvesť o mne pohanským národom, vládcom a takisto aj Izraelitom. ");
INSERT INTO slk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","A zároveň mu ukážem, ako veľmi bude musieť trpieť pre moje meno.“ ");
INSERT INTO slk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","A tak Ananiáš šiel a vyhľadal Saula. Položil naňho ruky a povedal: „Saul, brat môj, posiela ma k tebe Pán Ježiš, ktorý sa ti ukázal na ceste sem. Má sa ti opäť vrátiť zrak a máš byť naplnený Svätým Duchom.“ ");
INSERT INTO slk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A tu zrazu, akoby mu spadli šupiny z očí, Saul opäť videl. Vstal a dal sa pokrstiť. ");
INSERT INTO slk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Potom sa najedol a vrátila sa mu sila. Saul zostal niekoľko dní s damaskými veriacimi ");
INSERT INTO slk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","a od prvého okamihu začal v synagógach zvestovať radostnú správu, že Ježiš je naozaj Boží Syn. ");
INSERT INTO slk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Všetci poslucháči sa čudovali a vraveli: „Vari to nie je ten, ktorý tak kruto prenasledoval v Jeruzaleme Ježišových vyznávačov? Veď aj sem predsa prišiel, aby ich pochytal a spútaných doviedol pred veľkňazov.“ ");
INSERT INTO slk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ale Saul čoraz presvedčivejšie dokazoval, že Ježiš je zasľúbený Mesiáš, až napokon celkom zmiatol Židov v Damasku. ");
INSERT INTO slk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Keď to trvalo už príliš dlho, niektorí z nich sa dohodli, že Saula zabijú. ");
INSERT INTO slk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","On sa však dozvedel, aké plány proti nemu kujú. Vo dne v noci dali strážiť mestské brány, aby ho mohli chytiť a zabiť, ");
INSERT INTO slk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","no kresťania ho raz v noci spustili v koši cez mestské hradby. ");
INSERT INTO slk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Keď sa Saul vrátil do Jeruzalema, pokúšal sa pripojiť k Ježišovým nasledovníkom. Ale všetci sa ho báli – nikto totiž neveril, že sa naozaj stal učeníkom Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ujal sa ho však Barnabáš, priviedol ho k apoštolom a vyrozprával im, ako sa Saulovi ukázal Pán na ceste do Damasku, ako sa s ním zhováral a ako potom Saul v Damasku odvážne kázal v Ježišovom mene. ");
INSERT INTO slk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A tak mohol mať Saul účasť na všetkom, čo robili a aj tu smelo hovoril o Ježišovi. ");
INSERT INTO slk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kázal aj grécky hovoriacim Židom, hádal sa s nimi, až ho napokon chceli zabiť. ");
INSERT INTO slk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Keď sa ostatní bratia dozvedeli, aké nebezpečenstvo mu hrozí, odviedli ho tajne do Cézarey a odtiaľ ho poslali do rodného Tarzu. ");
INSERT INTO slk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pre zbory v Judsku, Galilei a Samárii nastalo teraz pokojné obdobie. Cirkev vnútorne silnela, Duch Svätý ju povzbudzoval a viedol, rástla početne a všetci žili v Božej bázni. ");
INSERT INTO slk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter navštevoval zbory po okolí a zavítal aj medzi veriacich v meste Lydda. ");
INSERT INTO slk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tam sa stretol s Eneášom, človekom, ktorý bol už osem rokov pripútaný na lôžko, lebo bol ochrnutý. ");
INSERT INTO slk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter mu povedal: „Eneáš, Ježiš Kristus ti vracia zdravie. Vstaň a usteľ si lôžko!“ A Eneáš hneď vstal. ");
INSERT INTO slk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Keď to obyvatelia Lyddy a neďalekého Sáronu videli, uverili v Pána Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","V meste Joppa žila veriaca žena, ktorá sa volala Tabita, po grécky Dorkas. Bola známa tým, že konala veľa dobra a pomáhala najmä chudobným. ");
INSERT INTO slk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Práve v tých dňoch však ochorela a zomrela. Umyli ju a uložili v podkrovnej izbe. ");
INSERT INTO slk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Keďže Joppa je blízko Lyddy, učeníci sa dozvedeli že je tam Peter. Poslali k nemu dvoch mužov s naliehavou prosbou: „Príď k nám čo najskôr!“ ");
INSERT INTO slk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peter sa ihneď pobral s nimi. Keď prišiel do Joppy, zaviedli ho do hornej miestnosti, kde ho ihneď obklopil zástup plačúcich vdov a ukazovali mu šaty, ktoré im šila ich milá Tabita, kým ešte žila. ");
INSERT INTO slk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter požiadal, aby všetci odišli, kľakol si a modlil sa. Potom sa obrátil k mŕtvej a povedal: „Tabita, vstaň!“ Otvorila oči, uvidela Petra a sadla si. ");
INSERT INTO slk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Podal jej ruku a pomohol jej vstať. Potom všetkých zavolal hore a ukázal im Tabitu živú. ");
INSERT INTO slk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Správa o tom sa ihneď rozletela po celej Joppe a mnoho ľudí uverilo v Pána Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter zostal dlhší čas v Joppe v dome garbiara Šimona. ");
INSERT INTO slk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","V Cézarey žil istý Kornélius, stotník vojenského oddielu, nazývaného Italský. ");
INSERT INTO slk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bol to zbožný človek, ktorý uveril s celou svojou rodinou Bral Boha vážne. Štedro podporoval chudobných a pravidelne sa modlieval. ");
INSERT INTO slk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Raz popoludní okolo tretej sa mu vo videní zjavil Boží posol, ktorý k nemu prišiel a oslovil ho: „Kornélius!“ ");
INSERT INTO slk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Vystrašene sa naň pozrel a spýtal sa: „Čo si želáš, Pane?“ Anjel mu odpovedal: „Boh vypočul tvoje modlitby a vie o tvojej dobročinnosti. ");
INSERT INTO slk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pošli teraz do Joppy svojich sluhov a pozvi k sebe Šimona zvaného Peter. ");
INSERT INTO slk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Býva v dome garbiara Šimona pri mori. Peter ti povie, čo máš robiť.“ ");
INSERT INTO slk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Potom anjel odišiel. Kornélius si hneď zavolal dvoch sluhov a zbožného vojaka zo svojho sprievodu. ");
INSERT INTO slk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Vyrozprával im, čo sa mu prihodilo, a poslal ich do Joppy. ");
INSERT INTO slk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na druhý deň okolo poludnia, keď sa Kornéliovi poslovia približovali k mestu, vyšiel Peter na plochú strechu domu a modlil sa tam. ");
INSERT INTO slk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ako sa modlil, vyhladol a chcel si zajesť. Kým mu pripravovali jedlo, upadol do vytrženia. ");
INSERT INTO slk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Videl otvorené nebo a z neho akoby niekto spúšťal čosi ako prestieradlo uviazané za štyri rohy. ");
INSERT INTO slk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","V prestieradle boli všelijaké štvornohé zvieratá, plazy i vtáci. ");
INSERT INTO slk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Vtom začul hlas: „Peter vstaň, zabíjaj a jedz!“ ");
INSERT INTO slk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","„Za nič na svete, Pane, jakživ som nevzal do úst nič, čo poškvrňuje a znečisťuje.“ ");
INSERT INTO slk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ale hlas sa ozval znovu: „To, čo Boh očistil, nepokladaj za nečisté!“ ");
INSERT INTO slk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","To sa opakovalo tri razy a napokon to všetko bolo opäť vyzdvihnuté do neba. ");
INSERT INTO slk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter bol zarazený, a kým rozmýšľal, čo má to videnie znamenať, Kornéliovi poslovia našli dom garbiara Šimona a práve stáli pred bránou. ");
INSERT INTO slk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Spytovali sa, či tu býva Šimon, ktorého volajú aj Peter. ");
INSERT INTO slk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter si ešte vždy lámal hlavu, čo asi znamená to videnie, keď mu Svätý Duch povedal: „Hľa, hľadajú ťa traja muži. ");
INSERT INTO slk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Zíď dolu a choď bez váhania s nimi, ja som ich poslal za tebou.“ ");
INSERT INTO slk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A tak Peter zišiel dolu a povedal im: „Ja som ten, koho hľadáte. Prečo ste za mnou prišli?“ ");
INSERT INTO slk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Odpovedali: „Posiela nás stotník Kornélius, spravodlivý človek, ktorý berie Boha vážne a má v židovskom národe dobrú povesť. Zjavil sa mu totiž anjel a dal mu pokyn, aby ťa pozval do svojho domu a vypočul, čo mu máš povedať.“ ");
INSERT INTO slk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter pozval hostí dnu a ponúkol im, aby uňho prenocovali. Na druhý deň sa Peter aj s niekoľkými veriacimi z Joppy pobral s nimi. ");
INSERT INTO slk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ďalší deň došli do Cézarey, kde ich už Kornélius čakal. Na stretnutie s Petrom pozval svojich príbuzných a dobrých priateľov. ");
INSERT INTO slk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Keď Peter vchádzal do jeho domu, Kornélius si pred ním pokľakol a hlboko sa mu poklonil. ");
INSERT INTO slk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ale Peter ho zdvihol so slovami: „Vstaň, veď ja som len človek.“ ");
INSERT INTO slk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Začali sa spolu rozprávať a keď Peter vošiel do domu, zistil, že sa tam zišlo mnoho ľudí. ");
INSERT INTO slk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter ich oslovil: „Vy iste viete, že ako Žid by som sem nemal chodiť a že máme zakázané priateliť sa s ľuďmi iného pôvodu. Mne však Boh ukázal, aby som si o žiadnom človeku nemyslel, že kontakt s ním je niečo poškvrňujúce alebo nečisté. ");
INSERT INTO slk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Preto som bez váhania prijal vaše pozvanie a prišiel som. No rád by som vedel, prečo ste ma vlastne zavolali.“ ");
INSERT INTO slk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornélius mu vysvetlil: „Pred tromi dňami som sa postil a modlil vo svojom dome. Boli asi tri hodiny popoludní, tak ako teraz, keď sa zrazu zjavil predo mnou muž v bieloskvúcom rúchu ");
INSERT INTO slk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a oslovil ma: ‚Kornélius, Boh počuje tvoje modlitby a vie o tvojej dobročinnosti. ");
INSERT INTO slk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pošli poslov do Joppy a pozvi k sebe Šimona, zvaného Peter. Býva pri mori v dome garbiara Šimona.‘ ");
INSERT INTO slk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nuž som hneď po teba poslal a som rád, že si ochotne prišiel. A tak sme tu všetci pred Bohom a tvoje slová prijmeme ako jeho odkaz.“ ");
INSERT INTO slk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter sa ujal slova: „Teraz som konečne pochopil pravdu, že Boh nerobí rozdiel medzi ľuďmi, ");
INSERT INTO slk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ale že mu je milý každý človek z ktoréhokoľvek národa, ak ho berie vážne a žije podľa jeho vôle. ");
INSERT INTO slk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Boh zveril Izraelitom svoje posolstvo, radostnú správu o zmierení prostredníctvom Ježiša Krista, ktorý je Pánom všetkých. ");
INSERT INTO slk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Azda už viete, aké udalosti sa diali po celom Judsku. Začalo to v Galilei, kde Ján volal ľudí ku pokániu a krstil ich. ");
INSERT INTO slk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Potom Boh obdaril Ježiša z Nazareta zvláštnou mocou a Svätým Duchom. Všade, kam len prišiel, pomáhal ľuďom a uzdravoval všetkých, ktorí boli v diablovej moci, lebo Boh bol s ním. ");
INSERT INTO slk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","A my sme očitými svedkami všetkého, čo robil v Judskej krajine i v Jeruzaleme. Napriek tomu ho tam popravili na kríži, ");
INSERT INTO slk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ale Boh ho na tretí deň vzkriesil a my sme sa s ním opäť stretli. ");
INSERT INTO slk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Neukázal sa všetkým, len svojim vyvoleným učeníkom a my sme s ním po jeho zmŕtvychvstaní dokonca jedli a pili. ");
INSERT INTO slk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Poveril nás, aby sme hlásali a svedčili, že je to on, ktorého Boh ustanovil za sudcu živých aj mŕtvych. ");
INSERT INTO slk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Už proroci o ňom predpovedali, že každému, kto v neho uverí, Boh odpustí hriechy.“ ");
INSERT INTO slk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter ešte ani nedohovoril a Duch Svätý už zostúpil na všetkých poslucháčov. ");
INSERT INTO slk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Obrátení Židia zo zboru v Joppe žasli, že dar Svätého Ducha dostávajú aj ľudia pohanského pôvodu. ");
INSERT INTO slk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Počuli ich dokonca hovoriť inými jazykmi a chváliť Boha. Peter im povedal: ");
INSERT INTO slk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","„Môžeme azda zabrániť, aby boli pokrstení vodou tí, ktorí prijali od Boha Svätého Ducha tak ako aj my?“ ");
INSERT INTO slk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A dal pokyn, aby všetci noví veriaci boli pokrstení v mene Pána Ježiša. Potom ho pozvali, aby u nich zostal ešte niekoľko dní. ");
INSERT INTO slk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apoštoli i bratia v Judsku sa čoskoro dozvedeli, že aj pohania uverili Božej zvesti. ");
INSERT INTO slk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ale keď sa Peter vrátil do Jeruzalema, niektorí kresťania židovského pôvodu mu vyčítali: ");
INSERT INTO slk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","„Ty si navštevoval pohanov, ba ešte si aj s nimi jedával!“ ");
INSERT INTO slk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","A tak Peter vyrozprával, ako sa to stalo: ");
INSERT INTO slk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","„Bol som v meste Joppa. Jedného dňa, práve keď som sa modlil, mal som videnie: čosi ako obrovské prestieradlo sa uviazané za štyri rohy spúšťalo z neba a zastalo práve pri mne. ");
INSERT INTO slk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Keď som sa doň pozorne zahľadel, uvidel som v ňom najrozmanitejšie zvieratá – divú zver, plazy i vtáky. ");
INSERT INTO slk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","A počul som hlas: ‚Vstaň, Peter, zabíjaj a jedz!‘ ");
INSERT INTO slk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Odpovedal som: ‚Za nič na svete, Pane! Jakživ som nevzal do úst nič, čo poškvrňuje a znečisťuje.‘ ");
INSERT INTO slk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ale znova zaznel hlas z neba: ‚To, čo Boh očistil, nepokladaj za nečisté!‘ ");
INSERT INTO slk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","To sa zopakovalo tri razy a potom sa všetko vyzdvihnuté späť do neba. ");
INSERT INTO slk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A práve v tej chvíli pred domom, kde som býval, zastali traja muži, čo prišli po mňa z Cézarey. ");
INSERT INTO slk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Duch mi povedal, aby som bez pochybovania išiel s nimi. So mnou sa vydali na cestu aj títo šiesti bratia a spolu sme vošli do domu muža, ktorý po nás poslal. ");
INSERT INTO slk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Porozprával nám, ako vo svojom dome uvidel anjela, ktorý mu povedal: ‚Pošli niekoho do Joppy a pozvi k sebe Šimona zvaného Peter. ");
INSERT INTO slk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","On ti prinesie posolstvo, ako môžeš byť spasený ty aj všetci v tvojom dome.‘ ");
INSERT INTO slk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Začal som im teda hovoriť, ale čoskoro na nich zostúpil Svätý Duch, tak ako na nás vtedy na počiatku. ");
INSERT INTO slk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Vtedy som si spomenul na slová Pána Ježiša: ‚Ján vás krstil vodou, ale vy budete pokrstení Svätým Duchom.‘ ");
INSERT INTO slk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ak teda Boh dal pohanom rovnaký dar ako nám, ktorí sme uverili v Pána Ježiša Krista, kto som ja, aby som sa staval proti Bohu?“ ");
INSERT INTO slk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Po týchto slovách bratia prestali namietať a začali oslavovať Boha: „Teda aj pohanov prebúdza Boh k pokániu, aby sa obrátili k nemu a získali večný život!“ ");
INSERT INTO slk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Po Štefanovej smrti nastalo v Jeruzaleme veľké prenasledovanie. Veriaci, ktorí sa odtiaľ rozišli, sa dostali až do Fenície, na Cyprus a do Antiochie v Sýrii. S radostnou zvesťou o záchrane však zoznamovali iba Židov. ");
INSERT INTO slk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ale niektorí z nich, rodáci z Cypru a Cyrény, začali po svojom príchode do Antiochie zvestovať Krista aj pohanom. ");
INSERT INTO slk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Moc Božia bola s nimi a veľké množstvo ľudí uverilo a obrátilo sa k Pánovi. ");
INSERT INTO slk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Správy o tom sa dostali do jeruzalemského zboru. Bratia teda vyslali do Antiochie Barnabáša. ");
INSERT INTO slk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Keď tam prišiel a uvidel, ako Božia milosť pôsobí, veľmi sa z toho tešil a povzbudzoval všetkých, aby vo svojom rozhodnutí vytrvali a zostali Pánovi verní. ");
INSERT INTO slk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabáš bol vzácny muž, plný Ducha Svätého a viery. Tak v Antiochii uveril v Pána Ježiša veľký počet ľudí. ");
INSERT INTO slk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabáš sa odtiaľ pobral do Tarzu, vyhľadal Saula ");
INSERT INTO slk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","a priviedol ho so sebou do Antiochie. Zostali tam spolu celý rok a vyučovali veľké množstvo veriacich. Práve v Antiochii sa začalo Kristovým nasledovníkom prvý raz hovoriť kristovci – kresťania. ");
INSERT INTO slk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Do antiochijského zboru prišli z Jeruzalema niektorí kresťania, ktorí mali prorocký dar. ");
INSERT INTO slk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jednému z nich, Agabovi, ukázal Duch, že v celej ríši vypukne hlad. To sa aj neskôr splnilo za vlády cisára Klaudia. ");
INSERT INTO slk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kresťania v Antiochii sa preto rozhodli, že každý podľa svojich možností pomôže bratom v Judsku. ");
INSERT INTO slk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tak aj urobili a zbierku poslali po Barnabášovi a Saulovi predstaveným zboru v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","V tom čase začal kruto prenasledovať niektorých z cirkvi aj kráľ Herodes. ");
INSERT INTO slk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Apoštola Jakuba, Jánovho brata, dal popraviť mečom. ");
INSERT INTO slk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Keď videl, že sa tým zapáčil Židom, dal zatknúť aj Petra. Bol práve Sviatok nekvasených chlebov, ");
INSERT INTO slk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","keď Petra uvrhol do žalára, ktorý strážili štyri štvorice vojakov. Po sviatkoch Veľkej noci ho mienil verejne súdiť. ");
INSERT INTO slk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Zatiaľ čo bol Peter vo väzení, cirkev sa zaňho bez prestania modlila k Bohu. ");
INSERT INTO slk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","V noci pred chystaným procesom spal Peter medzi dvoma vojakmi spútaný dvoma reťazami a stráže predo dvermi strážili väzenie. ");
INSERT INTO slk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tu zrazu svetlo ožiarilo celu a pri Petrovi stál Pánov anjel. Potriasol ho za bok a zobudil slovami: „Rýchlo vstaň!“ a Petrovi spadli zo zápästí reťaze. ");
INSERT INTO slk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Anjel mu rozkázal: „Obleč sa a obuj!“ Peter poslúchol a anjel ho vyzval: „Vezmi si plášť a poď za mnou!“ ");
INSERT INTO slk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Vyšiel z cely a šiel za anjelom. Vôbec netušil, že to, čo sa s ním prostredníctvom anjela deje, je skutočnosť. Myslel si totiž, že to celé je len videnie, sen. ");
INSERT INTO slk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Prešli popri prvej aj druhej stráži a prišli k železnej bráne, ktorá viedla do mesta. Tá sa im otvorila sama od seba. Vyšli von, prešli jednou z ulíc, a vtom anjel zmizol. ");
INSERT INTO slk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Až teraz sa Peter spamätal a povedal si: „Teraz už viem, že Pán poslal svojho anjela a vytrhol ma z Herodesových rúk, a tak zmaril plány Židov.“ ");
INSERT INTO slk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Keď si to uvedomil, zamieril do domu Márie, matky Jána, zvaného Marek. Tam sa zhromaždilo mnoho veriacich a modlili sa. ");
INSERT INTO slk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter zabúchal na dvere. Slúžka, ktorá sa volala Rodé, sa pribehla spýtať, kto to je. ");
INSERT INTO slk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Poznala Petrov hlas, ale od veľkej radosti ani neotvorila, ale bežala dnu oznámiť, že pred bránou stojí Peter. ");
INSERT INTO slk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","„Ty si sa zbláznila!“ povedali jej. Ona však trvala na svojom. „Tak potom to musí byť jeho anjel,“ povedali jej. ");
INSERT INTO slk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ale Peter znova zabúchal. Išli teda otvoriť a keď ho zbadali, neverili vlastným očiam. ");
INSERT INTO slk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter im pokynul rukou, aby ich upokojil, a vyrozprával im, ako ho Boh vyslobodil z väzenia. Napokon ich poprosil: „Oznámte to Jakubovi a ostatným bratom.“ Potom odišiel schovať sa na iné miesto. ");
INSERT INTO slk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ráno sa strhol medzi strážcami poplach. Začali sa dohadovať, kam sa podel Peter. ");
INSERT INTO slk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes ho dal hľadať, ale márne. Vypočul strážcov, a keď sa od nich nič nedozvedel, dal ich popraviť. Nato Herodes opustil Judsko, pobral sa do Cézarey a nejaký čas tam zostal. ");
INSERT INTO slk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Počas pobytu v meste Cézarea prijal delegáciu zástupcov z miest Týrus a Sidon. Bol na tieto mestá veľmi nazlostený, ale ich zástupcovia si úplatkami získali priazeň kráľovského dvorana Blasta a žiadali uzavrieť prímerie, lebo ich kraj bol zásobovaný potravinami z Herodesovho územia. ");
INSERT INTO slk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","V deň audiencie zasadol Herodes v kráľovských šatách na trón a predniesol reč. ");
INSERT INTO slk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Keď skončil, ľud ho zahrnul ováciami a volal: „To nehovoril človek, to hovoril sám Boh!“ ");
INSERT INTO slk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","V tom okamihu ho potrestal Boží anjel, pretože prijal pocty, ktoré patrili Bohu. Postihla ho choroba a umrel rozožraný červami. ");
INSERT INTO slk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Božia zvesť sa rýchlo šírila a k cirkvi sa pridávali noví kresťania. ");
INSERT INTO slk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabáš a Saul splnili svoje poslanie v Jeruzaleme a vrátili sa do Antiochie, kam so sebou vzali aj Jána, zvaného Marek. ");
INSERT INTO slk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Medzi členmi zboru v Antiochii boli proroci i učitelia: Barnabáš, Simeon zvaný Čierny, Lucius z Cyrény, Manahen, ktorý bol vychovávaný spolu s tetrarchom Herodesom Antipom, a Saul. ");
INSERT INTO slk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Raz, keď sa pripravovali pôstom a modlitbami na službu Bohu, dostali pokyn od Svätého Ducha: „Oddeľte spomedzi seba Barnabáša a Saula, lebo im chcem zveriť zvláštne poslanie.“ ");
INSERT INTO slk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Znova sa teda modlili a postili, potom na nich položili ruky, aby pre nich vyprosili požehnanie a vyslali ich na cestu. ");
INSERT INTO slk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Podľa pokynu Svätého Ducha sa vybrali do prístavu Seleukia a odtiaľ sa odplavili na Cyprus. ");
INSERT INTO slk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Spolu s nimi šiel ako ich pomocník aj Ján Marek. Pristáli v meste Salamina a v židovských synagógach kázali o Kristovi. ");
INSERT INTO slk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Potom putovali cez ostrov, až sa napokon dostali do Pafu. Narazili tam na istého židovského čarodejníka, ktorý sa volal Barjezus a bol falošným prorokom. ");
INSERT INTO slk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Zdržiaval sa u rímskeho miestodržiteľa Sergia Paula, vzdelaného muža. Ten si k sebe pozval Barnabáša a Saula, lebo chcel počuť slovo od Boha. ");
INSERT INTO slk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ale čarodejník Elymas (také bolo jeho grécke meno) sa proti nim tvrdo postavil a zo všetkých síl chcel odvrátiť Sergia od viery. ");
INSERT INTO slk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul, teraz väčšmi známy pod menom Pavol, sa naňho prenikavo zahľadel a naplnený Svätým Duchom ");
INSERT INTO slk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","povedal: „Si synom diabla, plný klamu a falše! Ty nepriateľ všetkého, čo je spravodlivé, vari nikdy neprestaneš prevracať Božie cesty na lož? ");
INSERT INTO slk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Teraz ťa postihne Boží trest: oslepneš a istý čas neuvidíš ani slnko!“ A naozaj sa mu zatmelo pred očami, začal šmátrať okolo seba a hľadal, kto by mu podal ruku a viedol ho. ");
INSERT INTO slk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Keď miestodržiteľ videl, čo sa stalo, uveril a žasol nad tým, akú moc má Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Z Pafu sa Pavol a jeho spoločníci plavili do Pergy v Pamfýlii. Ján Marek sa však od nich oddelil a vrátil sa do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Z Pergy pokračovali do Antiochie v Pisidskej provincii, kde vošli v sobotu do synagógy a posadili sa. ");
INSERT INTO slk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Najprv sa ako zvyčajne čítali oddiely z Mojžišových kníh a z prorokov a potom predstavení synagógy vyzvali Pavla a Barnabáša: „Bratia, ak máte pre nás nejaké slová povzbudenia, môžete hovoriť!“ ");
INSERT INTO slk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tu vystúpil Pavol, dal pokyn rukou a začal: „Mužovia izraelskí aj vy ostatní, ktorí ctíte Boha, počúvajte! ");
INSERT INTO slk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Boh Izraela si vyvolil našich praotcov a za pobytu v Egypte dal ich potomkom vyrásť na veľký národ. Potom ich odtiaľ svojou veľkou mocou vyviedol. ");
INSERT INTO slk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Štyridsať rokov putovali po púšti a Boh sa o nich staral. ");
INSERT INTO slk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Neskôr im podmanil sedem národov, ktoré obývali Kanaán, a daroval im tú krajinu do dedičstva. ");
INSERT INTO slk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Takmer štyristopäťdesiat rokov im dával múdrych vodcov až po proroka Samuela. ");
INSERT INTO slk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vtedy naši predkovia zatúžili po kráľovi a Boh im dal kráľa Saula, syna Kišovho z Benjamínovho kmeňa. Vládol im štyridsať rokov. ");
INSERT INTO slk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Boh sa však od neho odvrátil a dal Izraelovi za kráľa Dávida, o ktorom povedal: ‚Dávid, syn Jesseho, je muž podľa mojich predstáv, lebo bude konať moju vôľu.‘ ");
INSERT INTO slk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","A z Dávidovho rodu dal, tak ako sľúbil, izraelskému ľudu Spasiteľa Ježiša. ");
INSERT INTO slk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jeho príchod ohlasoval Ján a vyzýval všetkých Izraelitov, aby sa odvrátili od svojich hriechov a dali sa pokrstiť. ");
INSERT INTO slk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Keď Ján skončil svoje poslanie, pripomenul: ‚Nie som ten, za koho ma pokladáte. Po mne však prichádza ten, ktorému nie som hodný ani len rozviazať remienok na obuvi.‘ ");
INSERT INTO slk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bratia, ktorí ste z Abrahámovho rodu, aj vy ostatní, ktorí spolu s nami ctíte jediného Boha, zvesť o záchrane je určená nám všetkým. ");
INSERT INTO slk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Obyvatelia Jeruzalema ani ich vodcovia však v Ježišovi nespoznali Spasiteľa. Odsúdili ho a tak splnili, čo o ňom napísali proroci, ako si to čítavame každú sobotu. ");
INSERT INTO slk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nenašli na ňom nijaký dôvod, aby ho mohli odsúdiť na smrť, a predsa naliehali na Piláta, aby ho dal popraviť: ");
INSERT INTO slk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tak sa naplnili všetky predpovede Písma. Potom jeho telo zložili z kríža, pochovali, ");
INSERT INTO slk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ale Boh ho vzkriesil z mŕtvych. ");
INSERT INTO slk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mnoho dní sa zjavoval tým, ktorí s ním prišli z Galiley do Jeruzalema. Tí o tom teraz všetkým osobne svedčia. ");
INSERT INTO slk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","A my vám prinášame radostnú správu, že sľub, ktorý Boh dal našim praotcom, ");
INSERT INTO slk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","splnil teraz nám, ich deťom, a potvrdil ho Ježišovým vzkriesením. Naňho sa vzťahujú slová druhého žalmu: ‚Ty si môj Syn, dnes som sa stal tvojím Otcom.‘ ");
INSERT INTO slk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","To, že Ježiš vstane z mŕtvych a už nikdy nezomrie, predpovedal Boh v Písme slovami: ‚Splním vám zasľúbenie, ktoré som dal Dávidovi.‘ ");
INSERT INTO slk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","A v inom žalme to vysvetľuje ešte jasnejšie: ‚Nedopustíš, aby sa telo tvojho vyvoleného rozpadlo na prach.‘ ");
INSERT INTO slk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","To sa netýkalo Dávida, ktorý keď vykonal svoje poslanie podľa Božej vôle, zomrel, bol pochovaný vedľa svojich predkov a potom zotlel na prach. ");
INSERT INTO slk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ten však, ktorého Boh vzkriesil, nerozpadol sa na prach. ");
INSERT INTO slk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bratia, počúvajte! V Ježišovi vám zvestujeme odpustenie hriechov. ");
INSERT INTO slk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Každý, kto mu dôveruje, je oslobodený od všetkých previnení a je ospravedlnený; to je niečo, čo Mojžišov zákon nikdy nemohol urobiť. ");
INSERT INTO slk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dajte si však pozor, aby sa na vás nesplnila prorocká predpoveď: ");
INSERT INTO slk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‚Vy, ktorí mnou pohŕdate, otvorte oči a zahyňte, lebo vykonám za vášho života niečo veľké, čomu neuveríte, aj keď vám o tom budú rozprávať iní.‘ “ ");
INSERT INTO slk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Keď vychádzali zo synagógy, poslucháči prosili Pavla a Barnabáša, aby im o týchto veciach prišli hovoriť aj nasledujúcu sobotu. ");
INSERT INTO slk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mnohí Židia aj obrátení pohania, ktorí uctievali jediného Boha, sa pripojili k Pavlovi a Barnabášovi, a tí ich povzbudzovali, aby žili naplnení Božou milosťou. ");
INSERT INTO slk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nasledujúcu sobotu sa zhromaždilo skoro celé mesto, aby počuli Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Keď židovskí vodcovia videli taký zástup ľudí, pochytila ich závisť. Skákali Pavlovi do reči, odporovali mu a rúhali sa všetkému, čo povedal. ");
INSERT INTO slk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Napokon im teda Pavol a Barnabáš smelo a otvorene povedali: „Túto dobrú správu sme mali zvestovať najprv vám Židom. Keďže ju však odmietate a vzdávate sa večného života, obraciame sa k pohanom. ");
INSERT INTO slk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Veď tak nám to Pán prikázal: ‚Určil som ťa, aby si bol svetlom pohanom a niesol spásu až na koniec sveta.‘ “ ");
INSERT INTO slk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Keď to pohania počuli, veľmi sa tešili a zo srdca ďakovali za počuté Božie slovo. Tí, v ktorých Boh prebudil túžbu po večnom živote, uverili. ");
INSERT INTO slk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Radostná správa o Kristovi sa šírila po celom kraji. ");
INSERT INTO slk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ale židovským vodcom sa podarilo popudiť zbožné urodzené ženy aj vplyvných mužov proti Pavlovi a Barnabášovi, až ich napokon vyhnali z mesta. ");
INSERT INTO slk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pavol a Barnabáš striasli prach zo svojich nôh a odišli do mesta Ikonium. ");
INSERT INTO slk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ale Boh napĺňal veriacich radosťou i Svätým Duchom. ");
INSERT INTO slk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aj v Ikoniu kázal Pavol s Barnabášom v synagóge, a to tak mocne, že uverilo mnoho Židov aj pohanov. ");
INSERT INTO slk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ale tí Židia, ktorí odmietli Božie posolstvo, pobúrili pohanov a vyvolali nenávisť voči kresťanom. ");
INSERT INTO slk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pavol a Barnabáš napriek prekážkam zostali v meste dosť dlho a neohrozene zvestovali Krista. Ich slová o milosti Boh potvrdzoval tým, že dal apoštolom moc konať znamenia a zázraky. ");
INSERT INTO slk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Obyvatelia mesta sa rozdelili na dva tábory: niektorí boli na strane Židov, ktorí odmietli Ježiša, iní držali s kresťanmi. ");
INSERT INTO slk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Keď sa Pavol a Barnabáš dozvedeli, že pohania, Židia a židovskí vodcovia kujú proti nim plány a chcú ich ukameňovať, ");
INSERT INTO slk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","utiekli a zdržiavali sa v lykaonských mestách v Lystre, v Derbe a v okolí. ");
INSERT INTO slk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aj tam hlásali radostnú správu o Kristovi. ");
INSERT INTO slk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","V Lystre žil istý človek, ktorý sa nemohol postaviť. Bol chromý od narodenia a nikdy nechodil. ");
INSERT INTO slk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aj on bol medzi Pavlovými poslucháčmi. Pavol si ho všimol, a keď videl, že má vieru, aby bol vyliečený, ");
INSERT INTO slk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","hlasno naňho zavolal: „Postav sa na rovné nohy!“ A muž hneď vyskočil a chodil. ");
INSERT INTO slk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ľudia, ktorí boli svedkami tohto zázraku, nahlas volali vo svojom jazyku: „Zostúpili k nám bohovia v ľudskej podobe!“ ");
INSERT INTO slk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","O Barnabášovi vraveli, že je grécky boh Zeus, a o Pavlovi, že je Hermes, posol bohov, lebo väčšinou hovoril on. ");
INSERT INTO slk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kňaz Diovho chrámu, ktorý stál pred hradbami, dal dokonca priviesť k bráne ovenčené býky a chcel ich spolu s ostatnými apoštolom obetovať. ");
INSERT INTO slk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Keď sa to apoštoli dozvedeli, roztrhli svoj odev, vbehli medzi zástup a volali: ");
INSERT INTO slk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","„Priatelia, čo to robíte? Veď aj my sme len smrteľní ľudia ako vy. Prinášame vám dobrú správu a vyzývame vás, aby ste sa opustili tieto márnosti a obrátili sa k živému Bohu, ktorý stvoril nebo i zem i more i všetko, čo je v nich. ");
INSERT INTO slk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","V minulosti dovolil všetkým národom chodiť po vlastných cestách, ");
INSERT INTO slk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ale dával o sebe vedieť tým, že vám preukazoval dobro: zosielal vám dážď z neba i úrodu v pravý čas, dával vám jedlo a napĺňal vás radosťou.“ ");
INSERT INTO slk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Týmito slovami sa im len horko-ťažko podarilo prehovoriť zástupy, aby im nepriniesli obete. ");
INSERT INTO slk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","No o pár dní prišli z Antiochie a Ikonia niekoľkí Židia, strhli ľudí na svoju stranu a poštvali ich proti apoštolom a Pavla kameňovali. Keď sa im zdalo, že je už mŕtvy, vyvliekli jeho nevládne telo za hradby. ");
INSERT INTO slk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Keď sa okolo neho zbehli učeníci, Pavol sa prebral a vrátil sa do mesta. Na druhý deň však odišli aj s Barnabášom ďalej do Derby. ");
INSERT INTO slk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tu takisto hlásali radostnú zvesť o Kristovi a získali mnoho nasledovníkov. Potom sa vracali cez Lystru, Ikonium a Pisidskú Antiochiu. ");
INSERT INTO slk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Všade posilňovali veriacich a povzbudzovali ich, aby vytrvali vo viere. Vraveli: „Kým vojdeme do Božieho kráľovstva, musíme prejsť cez mnohé utrpenia.“ ");
INSERT INTO slk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pavol a Barnabáš zároveň ustanovili starších a po pôste a modlitbách ich všetkých zverili do ochrany Pána, v ktorého uverili. ");
INSERT INTO slk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Vydali sa na spiatočnú cestu cez Pisidiu a Pamfýliu ");
INSERT INTO slk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","a opäť kázali v meste Perga. Potom odišli do Atálie, ");
INSERT INTO slk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","odkiaľ sa plavili späť do Antiochie v Sýrii, kde im pred časom vyprosili Božiu milosť pre prácu, ktorú práve zakončili. ");
INSERT INTO slk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Po ich príchode sa zišiel celý zbor a oni im rozprávali, čo všetko prostredníctvom nich Boh vykonal a ako otváral dvere viery aj pohanom. ");
INSERT INTO slk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pavol a Barnabáš zostali s kresťanmi v Antiochii dlhší čas. ");
INSERT INTO slk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kým boli Pavol a Barnabáš v Antiochii, prišli niektorí ľudia z Judska a začali poúčať bratov: „Ak sa nedáte obrezať, ako to predpisuje Mojžišov zákon, nebudete zachránení.“ ");
INSERT INTO slk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pavol a Barnabáš s tým nesúhlasili a vypukol medzi nimi spor. Napokon sa rozhodli, že Pavol a Barnabáš aj s niekoľkými bratmi z Antiochie odcestujú do Jeruzalema a predložia tento problém apoštolom a starším. ");
INSERT INTO slk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Zbor ich teda vyslal na cestu. Išli cez Feníciu a Samáriu a všade rozprávali o tom, ako aj pohania začínajú veriť v Pána Ježiša. Táto správa spôsobovala všetkým veriacim veľkú radosť. ");
INSERT INTO slk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","V Jeruzaleme ich srdečne prijal celý zbor, starší i apoštoli. Aj tým rozprávali, čo všetko Boh prostredníctvom nich vykonal. ");
INSERT INTO slk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ale hneď sa ozvali niektorí kresťania, bývalí farizeji, a upozornili: „Aj obrátení pohania sa musia dať obrezať a treba im prikázať, aby sa riadili Mojžišovým zákonom.“ ");
INSERT INTO slk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A tak sa apoštoli a starší zišli, aby sa o tom poradili. ");
INSERT INTO slk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Po dlhej a náročnej debate sa prihlásil o slovo Peter: „Milí bratia, viete veľmi dobre, že si ma Boh pred časom vybral, aby som zvestoval evanjelium pohanom a oni tak mohli uveriť. ");
INSERT INTO slk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A Boh, ktorý vidí do srdca človeka, sa k nim priznal a dal im Svätého Ducha takisto ako nám. ");
INSERT INTO slk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","A nerobil nijaký rozdiel medzi nami a nimi, lebo aj ich srdce očistil vierou. ");
INSERT INTO slk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Prečo teraz pokúšate Boha a chcete vložiť na chrbát nových kresťanov bremeno, ktoré nevládali uniesť ani naši otcovia, ani my? ");
INSERT INTO slk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Veríme predsa, že sme rovnako ako oni zachránení milosťou Pána Ježiša.“ ");
INSERT INTO slk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Po tejto reči celé zhromaždenie stíchlo a pozorne vypočulo Pavla aj Barnabáša, aké veľké zázraky konal Boh prostredníctvom nich medzi pohanmi. ");
INSERT INTO slk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Keď dohovorili, ujal sa slova Jakub: „Bratia, rád by som vám niečo povedal. ");
INSERT INTO slk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Práve sme počuli od Šimona Petra, ako Boh prvý raz prejavil pohanom svoju milosť a povolal ich za svoj ľud. ");
INSERT INTO slk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","To sa celkom zhoduje so slovami proroka: ");
INSERT INTO slk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‚Navrátim sa zase a znovu postavím Dávidov zborený príbytok, z jeho ruín ho znovu postavím a obnovím ho, ");
INSERT INTO slk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","aby aj ostatní ľudia hľadali Pána, všetky národy, ktoré mi patria. Tak hovorí Pán, ktorí to činí ");
INSERT INTO slk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","a ktorý to oznámil už pred vekmi.‘ ");
INSERT INTO slk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Môj názor teda je, že by sme nemali na pohanov, ktorí sa obrátili k Bohu, nakladať zbytočné bremená. ");
INSERT INTO slk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Radšej im napíšme, aby sa vyhýbali všetkému, čo súvisí s pohanskou modloslužbou, aby sa chránili smilstva a nejedli mäso zadusených zvierat, ani ich krv. ");
INSERT INTO slk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Veď Mojžišov zákon sa už oddávna vyučuje každú sobotu v synagógach a má dosť kazateľov.“ ");
INSERT INTO slk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","S týmto návrhom súhlasilo celé zhromaždenie. Apoštoli a starší rozhodli, že zvolia dvoch zástupcov a pošlú ich s Pavlom a Barnabášom do Antiochie, aby im oznámili, na čom sa uzniesli. Vybrali dvoch popredných bratov z vedenia zboru, a to Júdu nazývaného Barsabáš a Sílasa. ");
INSERT INTO slk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Poslali po nich list s týmto znením: „My, apoštoli a starší, vaši bratia, posielame srdečný pozdrav vám, svojim bratom v Antiochii, Sýrii a Cilícii, ktorí ste boli kedysi pohanmi. ");
INSERT INTO slk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dozvedeli sme sa, že vás niektorí naši bratia svojimi rečami znepokojili a spochybnili vaše spasenie, hoci ich tým nikto nepoveril. ");
INSERT INTO slk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Preto sme sa jednomyseľne rozhodli, že zvolíme dvoch zástupcov a pošleme ich k vám s našimi milovanými bratmi Barnabášom a Pavlom, ");
INSERT INTO slk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ktorí v službe pre nášho Pána Ježiša Krista nasadzujú vlastné životy. ");
INSERT INTO slk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Posielame vám tiež Júdu a Sílasa, ktorí vám to, čo píšeme, potvrdia aj ústne. ");
INSERT INTO slk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Duch Svätý i my považujeme za dobré, aby vás nikto nezaťažoval povinnosťami, ktoré nie sú pre spasenie nevyhnutné. ");
INSERT INTO slk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Je však potrebné, aby ste sa zdržiavali všetkého, čo bolo obetované modlám, krvi, mäsa udusených zvierat, nezbavených krvi, a napokon smilstva. Ak sa toho všetkého vyvarujete, budete konať správne. Majte sa dobre.“ ");
INSERT INTO slk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Poverení zástupcovia sa teda vybrali do Antiochie, kde zvolali celé zhromaždenie a odovzdali im list. ");
INSERT INTO slk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Keď ho bratom prečítali, veľmi sa zaradovali, lebo ich upokojil. ");
INSERT INTO slk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Aj Júda a Sílas, ktorí mali dar proroctva, posilňovali a povzbudzovali celý zbor vo viere. ");
INSERT INTO slk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nejaký čas tam zostali a potom sa s nimi bratia so želaním pokoja rozlúčili, aby sa mohli vrátiť späť. ");
INSERT INTO slk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ale Sílas zostal radšej v Antiochii. ");
INSERT INTO slk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pavol a Barnabáš zostali ešte v Antiochii a spolu s mnohými ďalšími vyučovali a zvestovali Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Po nejakom čase navrhol Pavol Barnabášovi: „Navštívme opäť našich bratov vo všetkých mestách, kde sme kázali o Pánu Ježišovi. Rád by som videl, ako sa im darí.“ ");
INSERT INTO slk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabáš súhlasil a radil, aby so sebou opäť vzali Jána zvaného Marek. ");
INSERT INTO slk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ale Pavol bol proti tomu, lebo Marek ich opustil už v Pamfýlii a nepokračoval s nimi v práci. ");
INSERT INTO slk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Došlo medzi nimi k takej ostrej výmene názorov, že sa radšej rozdelili. Barnabáš vzal so sebou Marka a odplavili sa na Cyprus. ");
INSERT INTO slk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pavol si vybral Sílasa a vydali sa na cestu s požehnaním bratov, ktorí ich zverili do Božej milosti. ");
INSERT INTO slk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Putovali Sýriou a Cilíciou a všade upevňovali zbory. ");
INSERT INTO slk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pavol navštívil najprv mesto Derby a odtiaľ sa dostal do Lystry. Tam stretli mladého veriaceho Timoteja. Jeho matka bola Židovka, ktorá uverila v Krista, ale otec bol Grék. ");
INSERT INTO slk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bratia v Lystre aj v Ikoniu sa veľmi pochvalne vyjadrovali o Timotejovi. ");
INSERT INTO slk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pavol chcel, aby sa s ním vydal na cestu. Z ohľadu na tamojších Židov, ktorí vedeli, že jeho otec je Grék, ho Pavol obrezal. ");
INSERT INTO slk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Potom Pavol, Sílas a Timotej putovali spoločne z mesta do mesta a všade zoznamovali kresťanov s ustanoveniami, ktoré prijali apoštoli a starší jeruzalemského zboru. ");
INSERT INTO slk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","A tak sa zbory upevňovali vo viere a každý deň pribúdali noví veriaci. ");
INSERT INTO slk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Po svojom pobyte v Lystre prešli cez provinciu Frýgia naspäť do Galácie. Svätý Duch ich totiž zastavil, aby nešli kázať do provincie Ázia. ");
INSERT INTO slk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Keď prišli do Mýzie, chceli putovať ďalej na sever do provincie Bitýnia. Ježišov Duch im to opäť neumožnil. ");
INSERT INTO slk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Prešli teda Mýziou a dostali sa do Troady. ");
INSERT INTO slk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tam mal Pavol v noci videnie. Stál pred ním akýsi Macedónec a prosil ho: „Preplav sa do Macedónska a pomôž nám!“ ");
INSERT INTO slk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Po tomto Pavlovom videní sme sa usilovali odísť do Macedónska, lebo sme usúdili, že Boh nás tam posiela hlásať radostnú zvesť. ");
INSERT INTO slk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Z Troady sme sa teda plavili rovno na ostrov Samotráke a na druhý deň sme doplávali do Neapola. ");
INSERT INTO slk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Potom sme pokračovali už po súši do Filíp, najvýznamnejšieho mesta východného Macedónska, ktoré bolo Rímskou kolóniu. Tam sme strávili niekoľko dní. ");
INSERT INTO slk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","V sobotu sme sa vybrali za bránu mesta popri rieke, lebo sme predpokladali, že sa tam miestni Židia schádzajú na modlitby. Prisadli sme si ku skupinke žien, ktoré sa tam zišli, a hovorili sme im o Kristovi. ");
INSERT INTO slk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Medzi poslucháčkami bola aj Lýdia, obchodníčka s purpurovými látkami z Tyatír, ktorá verila v Boha. Boh jej otvoril srdce a prijala všetko, čo Pavol hovoril. ");
INSERT INTO slk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dala sa pokrstiť a spolu s ňou aj všetci, čo bývali v jej dome. Potom nás pozvala do svojho domu. Naliehala na nás: „Ak ste presvedčení, že som uverila v Pána, buďte hosťami v mojom dome.“ ");
INSERT INTO slk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Raz, keď sme opäť išli na miesto modlitieb, stretla nás mladá otrokyňa, ktorá mala veštecký dar a predpovedaním budúcnosti prinášala svojim pánom značný zisk. ");
INSERT INTO slk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chodila za Pavlom a za nami a neustále volala: „Toto sú služobníci najvyššieho Boha a prišli sem, aby vám povedali, ako môžete byť zachránení.“ ");
INSERT INTO slk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","To sa opakovalo deň čo deň, až to Pavol nezniesol a prikázal démonovi v nej: „V mene Ježiša Krista ti prikazujem, aby si z nej vyšiel!“ A v tej chvíli ju ten zlý duch opustil. ");
INSERT INTO slk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Jej páni si uvedomili, že tým prišli o svoj zisk, chytili Pavla a Sílasa a vliekli ich na námestie pred predstaviteľov mesta. ");
INSERT INTO slk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Keď ich predviedli pred úradníkov, povedali: „Títo Židia poburujú naše mesto! ");
INSERT INTO slk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Zavádzajú tu zvyky, ktoré sú proti našim rímskym zákonom.“ ");
INSERT INTO slk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Aj dav sa obrátil proti nim. Sudcovia nariadili, aby z nich postŕhali šaty a dali ich zbičovať. ");
INSERT INTO slk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Poriadne ich zbičovali, vrhli ich do väzenia a žalárnikovi prikázali, aby ich prísne strážil. ");
INSERT INTO slk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dal ich do najvzdialenejšej cely a nohy im spútal do klady. ");
INSERT INTO slk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Okolo polnoci, keď sa Pavol a Sílas modlili a spevom oslavovali Boha, a ostatní väzni ich počúvali, ");
INSERT INTO slk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","nastalo zrazu veľké zemetrasenie. Celá budova sa otriasala až do základov. Všetky dvere sa pootvárali a väzňom spadli okovy. ");
INSERT INTO slk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Keď sa žalárnik prebudil a videl pootvárané dvere, vytasil meč a chcel sa zabiť, lebo si myslel, že väzni utiekli. ");
INSERT INTO slk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ale Pavol zvolal: „Nerob to! Sme tu všetci!“ ");
INSERT INTO slk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Žalárnik teda rozkázal, aby mu priniesli svetlo, vbehol dnu a trasúc sa od strachu, padol pred Pavlom a Sílasom na kolená. ");
INSERT INTO slk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Potom ich vyviedol von a spýtal sa: „Páni, čo mám robiť, aby som bol zachránený?“ ");
INSERT INTO slk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Odpovedali mu: „Uver v Pána Ježiša a budeš spasený ty i všetci v tvojom dome.“ ");
INSERT INTO slk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","A začali jemu i všetkým v jeho domácnosti zvestovať Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hneď v tú nočnú hodinu sa ich žalárnik ujal, umyl a ošetril im rany a dal sa pokrstiť aj s celou svojou rodinou. ");
INSERT INTO slk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Potom ich zaviedol do svojho domu, pohostil ich a všetci sa tešili, že mohli uveriť v Boha. ");
INSERT INTO slk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na druhé ráno poslali sudcovia sluhov s odkazom: „Prepusť tých ľudí!“ ");
INSERT INTO slk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Žalárnik oznámil Pavlovi: „Sudcovia nariadili, aby som vás prepustil. Ste slobodní – môžete v pokoji odísť.“ ");
INSERT INTO slk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ale Pavol odpovedal: „Nás rímskych občanov verejne a bez súdu zbili a zavreli do väzenia. Teraz sa nás chcú tajne zbaviť? Nech prídu osobne a prepustia nás!“ ");
INSERT INTO slk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Sluhovia to oznámili sudcom. Keď počuli, že Pavol a Sílas sú rímski občania, náramne sa preľakli; ");
INSERT INTO slk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","prišli sa ospravedlniť, vyviedli ich z väzenia a pekne ich požiadali, aby opustili mesto. ");
INSERT INTO slk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pavol a Sílas po prepustení z väzenia navštívili Lýdiu. Tam sa stretli s ďalšími, ktorí uverili, a keď ich povzbudili, z Filíp odišli. ");
INSERT INTO slk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pobrali sa cestou, ktorá vedie cez mestá Amfipolis a Apolóniu do Tesaloniky, kde bola židovská synagóga. ");
INSERT INTO slk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavol ako zvyčajne prišiel do ich zhromaždenia a po tri soboty s nimi diskutoval o Písmach, ");
INSERT INTO slk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","vysvetľoval im a dokazoval, že Mesiáš musel trpieť a vstať z mŕtvych. Na záver dodal: „Tým Mesiášom je Ježiš, o ktorom vám hovorím.“ ");
INSERT INTO slk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Niektorí zo Židov sa dali presvedčiť a pripojili sa k Pavlovi a Sílasovi. Pripojilo sa k nim aj veľa Grékov a nemálo vplyvných žien. ");
INSERT INTO slk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","To však prebudilo závisť židovských vodcov. Zavolali povaľačov z trhoviska, vytvorili hlučný dav a pobúrili celé mesto. Zaútočili na Jasonov dom, hľadali v ňom Pavla a Sílasa a chceli ich predviesť pred zhromaždený dav. ");
INSERT INTO slk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nenašli ich však, preto dovliekli Jasona a niekoľkých veriacich pred mestskú radu a kričali: „Pavol a Sílas, ktorí poburujú celý svet, prišli aj k nám ");
INSERT INTO slk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a Jason ich prijal do svojho domu. Všetci porušujú cisárove nariadenia, lebo tvrdia, že pravým kráľom je Ježiš.“ ");
INSERT INTO slk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tieto slová popudili dav aj členov mestskej rady. ");
INSERT INTO slk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ale keď Jason aj ostatní zaplatili záruku, prepustili ich. ");
INSERT INTO slk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hneď v tú noc vypravili bratia Pavla a Sílasa do Berei. Keď tam prišli, zamierili rovno do židovskej synagógy. ");
INSERT INTO slk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tamojší Židia boli omnoho prístupnejší ako v Tesalonike. S veľkým záujmom prijímali zvestované slovo, každý deň študovali Písmo a skúmali, či všetko to, čo Pavol hovorí, je pravda. ");
INSERT INTO slk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mnohí z nich uverili, medzi nimi aj nemálo Grékov, mužov i žien z vyšších vrstiev. ");
INSERT INTO slk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Keď sa však Židia v Tesalonike dozvedeli, že Pavol káže v Berei, hneď tam prišli a začali proti nim poburovať a štvať ľudí. ");
INSERT INTO slk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Preto bratia vypravili Pavla na pobrežie, zatiaľ čo Sílas a Timotej zostali v Berei. ");
INSERT INTO slk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pavol im po svojich sprievodcoch, ktorí ho odprevadili až do Atén, odkázal, aby čo najskôr prišli za ním. ");
INSERT INTO slk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kým Pavol v Aténach čakal na Sílasa a Timoteja, bol hlboko znepokojený pri pohľade na množstvo pohanských modiel, s ktorými sa stretával v meste na každom kroku. ");
INSERT INTO slk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Deň čo deň sa zhováral so Židmi aj bohabojnými Grékmi v synagóge, ale vychádzal aj na námestia a debatoval so všetkými, čo tam práve boli. ");
INSERT INTO slk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tak sa dostal do rozhovoru aj s epikurejskými a stoickými filozofmi. Hovoril im o Ježišovi a o tom, že vstal z mŕtvych, no reagovali rozlične. Jedni vraveli: „Čo sa nám to tu ten táraj snaží nahovoriť?“ Iní zasa: „Chce tu zaviesť akési nové náboženstvo!“ ");
INSERT INTO slk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Zaviedli ho teda na stretnutie na Areopágu. Tam sa ho spýtali: „Smieme sa dozvedieť, aké nové učenie to hlásaš? ");
INSERT INTO slk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hovoríš nezvyčajné veci a radi by sme sa o tom dozvedeli čosi viac.“ ");
INSERT INTO slk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Najväčšou záľubou Aténčanov, ako aj v meste žijúcich cudzincov bolo totiž hovoriť a dozvedať sa o nových veciach. ");
INSERT INTO slk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavol teda vystúpil pred všetkých, ktorí sa zhromaždili na Areopágu, a oslovil ich: „Vážení Aténčania! Všimol som si, že ste veľmi nábožensky založení ľudia. ");
INSERT INTO slk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Keď som sa totiž prechádzal po meste a prezeral si vaše posvätné miesta, našiel som aj oltár s nápisom ‚Neznámemu Bohu.‘ A tohto Boha, ktorého uctievate, hoci ho nepoznáte, vám dnes chcem zvestovať. ");
INSERT INTO slk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Je to Boh, ktorý stvoril svet aj všetko, čo je na ňom. On je Pánom neba aj zeme. Nebýva však v chrámoch, ktoré si ľudia postavili, ");
INSERT INTO slk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ani si nedáva od ľudí slúžiť, akoby bol od nich závislý. Veď je to on sám, kto dáva ľuďom život, dýchanie i všetko ostatné. ");
INSERT INTO slk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","On stvoril všetkých ľudí na zemi z jedného muža, a umožnil im bývať na celej zemi. On určil, ako dlho a kde majú žiť. ");
INSERT INTO slk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","To všetko urobil, lebo chcel, aby ho ľudia hľadali, pátrali po ňom a našli ho. Veď je nám tak blízko. ");
INSERT INTO slk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Vďaka nemu žijeme, pohybujeme sa i jestvujeme, tak ako to vyjadrili aj niektorí z vašich básnikov: ‚Aj my sme jeho rodina.‘ ");
INSERT INTO slk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ak teda pochádzame z Boha, je nezmyselné sa domnievať, že sa Boh podobá modle, ktorú človek vytvoril zo zlata, zo striebra, alebo vytesal z kameňa. Veď je to iba výtvor ľudského umenia a zručnosti. ");
INSERT INTO slk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Boh prepáčil ľuďom túto nevedomosť z minulosti, ale teraz prikazuje všetkým ľuďom na celom svete, aby sa odvrátili od svojho predchádzajúceho spôsobu zmýšľania. ");
INSERT INTO slk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lebo už sa blíži deň, keď bude spravodlivo súdiť svet prostredníctvom muža, ktorého na to určil. Všetkým ľuďom o tom poskytol dôkaz, keď ho vzkriesil z mŕtvych.“ ");
INSERT INTO slk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Keď poslucháči počuli, že niekto, kto zomrel, vstal z mŕtvych, poniektorí sa začali Pavlovi posmievať. Iní mu však povedali: „Niekedy inokedy nám o tom môžeš porozprávať aj viac.“ ");
INSERT INTO slk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Po týchto slovách Pavol stretnutie opustil. ");
INSERT INTO slk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ale niektorých jeho reč predsa zaujala a uverili. Bol medzi nimi aj člen Areopágu Dionýz, žena menom Damaris, a niektorí ďalší. ");
INSERT INTO slk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Po týchto udalostiach Pavol opustil Atény a prišiel do Korintu. ");
INSERT INTO slk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tam sa zoznámil so židovskými manželmi Akvilom a Priscilou. Akvila bol rodák z Pontu, nedávno sa prisťahoval aj s manželkou z Itálie. Cisár Klaudius totiž vydal rozkaz, aby všetci Židia opustili Rím. ");
INSERT INTO slk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pavol u nich býval aj pracoval, lebo mali rovnaké remeslo ako on; vyrábali stany. ");
INSERT INTO slk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Každú sobotu uvádzal v synagóge dôvody, ktorými sa snažil získať Židov aj Grékov. ");
INSERT INTO slk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Príchod Sílasa a Timoteja do Macedónska posilnil Pavlovo šírenie evanjelia. Začal ešte viac presviedčať Židov, že Ježiš je zasľúbený Mesiáš. ");
INSERT INTO slk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Židia mu však odporovali a začali sa rúhať. Pavol si preto vytriasol prach z odevu a povedal: „Ak zahyniete, nebude to moja vina, sami ste si za to zodpovední. Odteraz sa budem venovať pohanom.“ ");
INSERT INTO slk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Potom sa presťahoval k Títovi Justovi, ktorý býval hneď vedľa synagógy. Justus bol pohan, ktorý uveril v Boha. ");
INSERT INTO slk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Uveril aj predstavený synagógy Krispos s celou svojou rodinou. Aj mnohí ďalší z Korintu, ktorí počúvali Pavla, uverili a dali sa pokrstiť. ");
INSERT INTO slk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Raz v noci sa Pavlovi ukázal vo videní Pán a povedal mu: „Neboj sa! Len smelo hovor a nemlč! ");
INSERT INTO slk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Veď ja som s tebou a nikto ti neublíži. V tomto meste mi patrí mnoho ľudí.“ ");
INSERT INTO slk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","A tak zostal Pavol ešte rok a pol v Korinte a hlásal tam Božie slovo. ");
INSERT INTO slk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Keď sa stal rímskym miestodržiteľom v Achajsku Gallio, Židia sa spolčili proti Pavlovi, predviedli ho pred súd ");
INSERT INTO slk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","a obžalovali ho: „Tento muž navádza ľudí, aby uctievali Boha spôsobom, ktorý je v rozpore so zákonom.“ ");
INSERT INTO slk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Zatiaľ čo sa Pavol chystal prehovoriť, Gallio sa obrátil na jeho žalobcov: „Židia, keby šlo o nejaké bezprávie alebo zločin, vypočul by som vás. ");
INSERT INTO slk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ale spory o slová, mená osôb alebo vaše zákony, vyriešte si to sami. Ja sa tým ako sudca zaoberať nebudem.“ ");
INSERT INTO slk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A vyhnal ich zo súdnej siene. ");
INSERT INTO slk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tu sa všetci vrhli na Sostena, predstaveného židovskej synagógy, a bili ho rovno pred Galliovými očami. On však do toho nezasiahol. ");
INSERT INTO slk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pavol v Korinte ešte určitý čas zostal. Potom sa rozlúčil s bratmi a pobral sa loďou do Sýrie. Spolu s ním odišli aj manželia Priscila a Akvila. Predtým si dal Pavol v Kenchreách, východnom korintskom prístave, ostrihať vlasy podľa sľubu, ktorý urobil. ");
INSERT INTO slk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","V Efeze sa rozlúčil s priateľmi a pobral sa do synagógy, kde debatoval so Židmi. ");
INSERT INTO slk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Prehovárali ho, aby sa u nich zdržal dlhšie, ale neprijal ich pozvanie. ");
INSERT INTO slk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pri lúčení im však povedal: „Ak to bude Božia vôľa, ešte sa k vám vrátim.“ ");
INSERT INTO slk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Z Efezu sa odplavil do Cézarey v Judsku a odtiaľ sa pešo vydal do Jeruzalema, aby sa pozdravil s miestnym zborom. Potom odcestoval do sýrskej Antiochie. ");
INSERT INTO slk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Strávil tam nejaký čas a znova sa pobral do Galácie a Frýgie. Ponavštevoval rad za radom všetky zbory a povzbudzoval veriacich vo viere. ");
INSERT INTO slk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Medzitým prišiel do Efezu Žid z Alexandrie, ktorý sa volal Apollo. Bol to výborný rečník a znalec Písma. ");
INSERT INTO slk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Už sa zoznámil s Ježišovým učením, o ktorom rozprával nadšene a správne, hoci poznal iba krst Jánov. ");
INSERT INTO slk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Odvážne kázal o Ježišovi aj v efezskej synagóge. Tam ho počuli Priscila a Akvila, pozvali ho k sebe a dôkladnejšie ho zoznámili s Božou cestou. ");
INSERT INTO slk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollo sa rozhodol ísť zvestovať radostnú správu do Acháje. Efezskí kresťania ho v tom povzbudili a dali mu aj odporúčajúci list pre tamojších kresťanov, aby ho srdečne prijali. Keď tam prišiel, bol veľkou pomocou pre všetkých, ktorí vďaka Božej milosti uverili. ");
INSERT INTO slk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Vedel totiž vynikajúco vyvracať argumenty Židov a na základe Písma dokazovať, že Ježiš je Mesiáš. ");
INSERT INTO slk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kým bol Apollo v Korinte, prešiel Pavol hornatým vnútrozemím a prišiel do Efezu. Tu sa zoznámil so skupinou učeníkov. ");
INSERT INTO slk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Spýtal sa ich: „Keď ste uverili, prijali ste Ducha Svätého?“ Odpovedali mu: „Nie, o Duchu Svätom sme ani len nepočuli.“ ");
INSERT INTO slk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pavol pokračoval: „Čomu ste teda uverili, keď ste sa dali pokrstiť?“ „Tomu, čo učil Ján,“ odpovedali. ");
INSERT INTO slk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tu im Pavol vysvetlil: „Ján krstil tých, ktorí oľutovali svoje hriechy a odvrátili sa od nich, ale nabádal ľudí, aby uverili v toho, kto príde po ňom, v Ježiša.“ ");
INSERT INTO slk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Keď to počuli, dali sa pokrstiť v mene Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","A len čo na nich Pavol položil ruky, zostúpil na nich Duch Svätý a hovorili cudzími jazykmi a prorokovali. ");
INSERT INTO slk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tých mužov bolo asi dvanásť. ");
INSERT INTO slk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Potom išiel Pavol do synagógy. Tri mesiace tam každú sobotu smelo učil, diskutoval a presviedčal, že to, čo hovorí o Božom kráľovstve, je pravda. ");
INSERT INTO slk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ale keď niektorí neústupne trvali na svojom, ba dokonca verejne hanobili Krista, Pavol od nich odišiel a odviedol so sebou aj tých, čo uverili. Každý deň potom kázal a diskutoval v prednáškovej sieni filozofa Tyrana, ");
INSERT INTO slk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","čo trvalo dva roky, takže všetci obyvatelia provincie Ázia, Židia aj Gréci, počuli o Ježišovi. ");
INSERT INTO slk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A Boh konal prostredníctvom Pavla nezvyčajné zázraky. ");
INSERT INTO slk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Stačilo dokonca, ak ľudia vzali šatky alebo časti odevu, ktorých sa Pavol dotkol, priložili ich s vierou na chorých a tí boli uzdravení. Aj mnohých zlých duchov takto vyhnali. ");
INSERT INTO slk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Niektorí židovskí zaklínači, ktorí cestovali z mesta do mesta, sa pokúsili používať pri vyháňaní zlých duchov novú zaklínaciu formulku: „Zaklínam ťa v mene Ježiša, ktorého káže Pavol.“ ");
INSERT INTO slk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tak to robilo sedem synov židovského veľkňaza Skevu. Raz sa pokúsili takto uzdraviť človeka posadnutého démonmi. ");
INSERT INTO slk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ale démon im odpovedal: „Ježiša aj Pavla poznám, ale kto ste vy?“ ");
INSERT INTO slk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Potom sa na nich ten posadnutý človek vrhol, postŕhal z nich šaty a zmlátil tak, že napokon nahí a doráňaní museli utekať z domu. ");
INSERT INTO slk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","To sa hneď rozchýrilo medzi Židmi aj Grékmi v Efeze, takže sa všetkých zmocnila bázeň a meno Pána Ježiša bolo vo veľkej úcte. ");
INSERT INTO slk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Prichádzali mnohí, ktorí už uverili a pred všetkými vyznávali, že aj oni sa kedysi venovali zaklínaniu. ");
INSERT INTO slk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mnohí, ktorí sa zaoberali mágiou, prinášali svoje knihy a pred všetkými ich pálili. Odhadovalo sa, že mali cenu päťdesiattisíc drachiem. ");
INSERT INTO slk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Aj to bol dôkaz, že Božie slovo zasahovalo čoraz viac ľudí a malo na nich mocný vplyv. ");
INSERT INTO slk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Po týchto udalostiach sa Pavol rozhodol, že precestuje Macedónskom a cez Achajsko sa vráti do Jeruzalema. „Keď tam nejaký čas pobudnem, určite sa vyberiem do Ríma,“ povedal si. ");
INSERT INTO slk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dvoch svojich pomocníkov, Timoteja a Erasta, poslal napred do Macedónska a sám zostal ešte nejaký čas v Ázii. ");
INSERT INTO slk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Práve v tom čase vypukli v Efeze vážne nepokoje kvôli novému učeniu. ");
INSERT INTO slk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vyvolal ich zlatník Demeter, ktorý vyrábal strieborné napodobeniny chrámu gréckej bohyne Artemis, a poskytoval tak remeselníkom nemalé zisky. ");
INSERT INTO slk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demeter ich zvolal spolu s ostatnými, ktorí vyrábali podobné veci, a povedal im: „Priatelia, veľmi dobre viete, že naše remeslo nám veľmi dobre vynáša. ");
INSERT INTO slk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","No teraz, ako iste vidíte a počujete, príde si nejaký Pavol a popletie a zvedie mnohých ľudí nielen v Efeze, ale aj po celej Ázii. Vraví, že bohovia vytvorení ľudskými rukami nie sú nijakí bohovia. ");
INSERT INTO slk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hrozí nám, že nielen prídeme o svoje zisky a že sa naším remeslom začne pohŕdať, ale že aj chrám veľkej bohyne Artemis stratí svoju vážnosť a sama bohyňa, ktorú si ctí celá Ázia, ba aj celý svet, príde o svoju slávu.“ ");
INSERT INTO slk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tieto slová rozzúrili zhromaždených remeselníkov a začali kričať: „Veľká je Artemis Efezanov!“ ");
INSERT INTO slk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pobúrenie postupne zachvátilo celé mesto. Ľudia sa hrnuli do amfiteátra a vliekli so sebou aj Gája a Aristarcha, Pavlových macedónskych sprievodcov. ");
INSERT INTO slk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pavol chcel predstúpiť pred zhromaždený dav, ale učeníci mu v tom zabránili. ");
INSERT INTO slk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Aj niektorí vysokí úradníci provincie, ktorí mu boli naklonení, ho varovali, aby do amfiteátra nechodil. ");
INSERT INTO slk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Každý kričal niečo iné, vládol tu náramný zmätok a väčšina ani nevedela, načo sa vlastne zišli. ");
INSERT INTO slk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Židia postrčili dopredu Alexandra a niektorý z davu na neho začali pokrikovať. Zakýval rukou a chcel povedať niečo na obhajobu. ");
INSERT INTO slk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ale keď zástup zistil, že je to Žid, znova spustil krik a takmer dve hodiny volali: „Veľká je Artemis Efezanov! Veľká je Artemis Efezanov!“ ");
INSERT INTO slk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Konečne došiel predstavený mestskej rady a podarilo sa mu utíšiť dav: „Občania Efezu! Našiel by sa na svete niekto, kto by nevedel, že mesto Efez je strážcom chrámu veľkej Artemidy a kameňa, ktorý padol z neba? ");
INSERT INTO slk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Keďže o tom niet pochýb, upokojte sa a neurobte nič unáhlené. ");
INSERT INTO slk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Priviedli ste sem týchto ľudí. Ale oni predsa neznesvätili chrám, ani sa nerúhali našej bohyni. ");
INSERT INTO slk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A ak sa Demeter a ostatní remeselníci chcú na niekoho ponosovať, na to sú verejné súdne zasadnutia a sú tu aj rímske úrady, tam sa to môže prerokovať. ");
INSERT INTO slk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A ak máte nejaké iné požiadavky, môže sa to vyriešiť na riadne zvolanom stretnutí občanov. ");
INSERT INTO slk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Inak hrozí nebezpečenstvo, že budeme za dnešné udalosti obvinení zo vzbury. Nie je totiž nič, čím by sme mohli toto stretnutie obhájiť.“ ");
INSERT INTO slk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Po týchto slovách rozpustil zhromaždenie. ");
INSERT INTO slk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Keď rozruch utíchol, zvolal Pavol učeníkov, aby ich povzbudil. Zároveň sa s nimi rozlúčil a vybral sa do Macedónska. ");
INSERT INTO slk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Prechádzal krajinou a všetkých učeníkov povzbudzoval. Dostal sa takto do Grécka, ");
INSERT INTO slk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kde strávil tri mesiace. Odtiaľ sa chystal odplaviť do Sýrie, no dozvedel sa, že Židia na neho pripravili pascu, preto sa rozhodol vrátiť naspäť do Macedónska. ");
INSERT INTO slk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sprevádzali ho Sopatros, Pyrrhov syn z Berei, Aristarchos a Sekundus z Tesaloniky, Gájus z Derbe, Timotej, Tychikos a Trofimos z Ázie. ");
INSERT INTO slk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tí šli napred a čakali na nás v Troade. ");
INSERT INTO slk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Hneď po sviatkoch nekvaseného chleba sme vyplávali z Filíp a o päť dní sme sa dostali do Troady, kde sme sa zdržali týždeň. ");
INSERT INTO slk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","V sobotu večer sa tamojší zbor spolu s nami zišiel na spoločné stretnutie spojené s jedlom. Pavol kázal, a keďže mal na druhý deň odcestovať, hovoril až do polnoci. ");
INSERT INTO slk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","V hornej miestnosti, v ktorej boli zídení, bolo veľa lámp. ");
INSERT INTO slk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jeden mladík, zvaný Eutychus, sedel na obloku, a pretože Pavol hovoril dlho, zadriemal a spadol z druhého poschodia. Keď ho zdvihli, bol mŕtvy. ");
INSERT INTO slk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavol zbehol k nemu, sklonil sa nad ním, objal ho a povedal: „Neznepokojujte sa, žije.“ ");
INSERT INTO slk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Vrátili sa hore a pri spoločnom jedle s nimi Pavol diskutoval až do svitania a potom odišiel. ");
INSERT INTO slk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eutychus sa vrátil domov živý a to ich nesmierne povzbudilo. ");
INSERT INTO slk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nastúpili sme na loď a odplavili sme sa do Assa, kde sa k nám mal pripojiť Pavol. Šiel totiž po súši, kým my ostatní sme na jeho príkaz cestovali loďou. ");
INSERT INTO slk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","V Asse sme sa stretli, vzali sme ho na loď a pokračovali loďou do Mitylény. ");
INSERT INTO slk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Odtiaľ sme plávali ďalej a na druhý deň sme sa dostali do blízkosti ostrova Chios, ďalší deň k ostrovu Samos a na tretí deň sme zakotvili v Miléte. ");
INSERT INTO slk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pavol sa úmyselne vyhol Efezu, lebo nechcel stratiť v Ázii veľa času. Veľmi chcel, ak by to bolo len trochu možné, stráviť Turíce v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Z Milétu poslal Pavol odkaz do Efezu, že by sa rád stretol a pozhováral so staršími zboru. ");
INSERT INTO slk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Keď prišli, povedal im: „Dobre viete, ako som žil po celý ten čas, čo som bol s vami, odkedy som prišiel do Ázie. ");
INSERT INTO slk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Slúžil som Pánovi so všetkou pokorou, neraz so slzami, vystavený skúškam, ktoré som musel znášať pre nástrahy Židov. ");
INSERT INTO slk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","A nikdy som sa vám verejne ani po rodinách nezdráhal hovoriť to, čo by pre vás mohlo byť užitočné. ");
INSERT INTO slk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Židom aj Grékom som rovnako zdôrazňoval, že musia zanechať svoje hriechy, obrátiť sa k Bohu a uveriť v Ježiša Krista, nášho Pána. ");
INSERT INTO slk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A teraz ma Duch Svätý nabáda, aby som išiel do Jeruzalema, hoci neviem presne, čo ma tam čaká. ");
INSERT INTO slk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Viem len to, že mi Duch Svätý v každom meste, ktorým sme prechádzali, pripomínal, že ma tam čaká väzenie a útrapy. ");
INSERT INTO slk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ale môj život nemá pre mňa žiadnu cenu. Záleží mi len na tom, aby som dokončil svoje poslanie a úlohu, ktorou ma Ježiš poveril: niesť ľuďom radostnú zvesť o Božej milosti. ");
INSERT INTO slk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","A teraz viem, že nikto z vás, ktorým som na svojich cestách hlásal Božie kráľovstvo, ma už neuvidí. ");
INSERT INTO slk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","S čistým svedomím môžem povedať, že ak niekto zahynie, nebudem niesť na tom vinu, ");
INSERT INTO slk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","lebo som vám oznámil celý Boží plán na záchranu človeka a nič som nezamlčal. ");
INSERT INTO slk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","A tak dávajte pozor na seba aj na celé spoločenstvo, ktoré vám ako pastierom, zveril Duch Svätý. Buďte pastiermi Božej cirkvi, ktorú si Boh získal krvou vlastného Syna. ");
INSERT INTO slk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Viem, že po mojom odchode sa medzi vás vkradnú draví vlci a narobia v stáde škody. ");
INSERT INTO slk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dokonca aj niektorí z vás začnú prekrúcať pravdu, len aby učeníkov strhli za sebou. ");
INSERT INTO slk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Buďte preto ostražití! Majte na pamäti tie tri roky, ktoré som s vami strávil, a že som celý čas, vo dne v noci, vychovával aj so slzami v očiach každého z vás. ");
INSERT INTO slk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Teraz vás zverujem Bohu a slovu jeho milosti, ktoré má moc vás zdokonaľovať a zabezpečiť vám dedičský podiel medzi jeho vernými. ");
INSERT INTO slk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikdy som od nikoho nežiadal zlato, striebro, ani odev. ");
INSERT INTO slk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Viete, že som si vlastnými rukami zarábal na to, čo som potreboval ja i moji druhovia. ");
INSERT INTO slk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Chcel som vám zároveň ukázať príklad, ako máme pracovať, pomáhať slabým a pamätať na slová Pána Ježiša: ‚Blahoslavenejšie je dávať ako prijímať.‘ “ ");
INSERT INTO slk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Keď dohovoril, kľakol si a modlil sa s nimi. ");
INSERT INTO slk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Všetci sa nahlas rozplakali, objímali ho a lúčili sa s ním. ");
INSERT INTO slk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Najväčšmi ich rozžialili jeho slová, že ho už nikdy neuvidia. Napokon ho vyprevadili až k lodi. ");
INSERT INTO slk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Keď sme sa rozlúčili s bratmi z Efezu, nastúpili sme na loď a plavili sme sa priamo na ostrov Kós, na druhý deň na Rodos a odtiaľ do prístavu Patara. ");
INSERT INTO slk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tam sme našli loď, ktorá sa plavila do Fenície; nastúpili sme na ňu a vyplávali sme. ");
INSERT INTO slk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Priblížili sme sa na dohľad k Cypru, ale minuli sme ho z južnej strany, a zamierili sme k Sýrii. Pristáli sme v prístave Týrus, kde mala loď vyložiť náklad. ");
INSERT INTO slk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Vyhľadali sme tam miestnych kresťanov a strávili sme s nimi sedem dní. Oni však, vedení Svätým Duchom, varovali Pavla, aby do Jeruzalema nechodil; ");
INSERT INTO slk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","no keď náš čas uplynul, vydali sme sa znova na cestu. Všetci učeníci i so ženami a deťmi nás vyprevadili až za mesto. Na brehu sme si spoločne kľakli a modlili sa. ");
INSERT INTO slk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Potom sme sa rozlúčili, nastúpili sme na loď a oni sa vrátili domov. ");
INSERT INTO slk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Z Týru sme pokračovali v plavbe až do Ptolemaidy, kde sme tiež pozdravili bratov, no zostali sme tam iba jeden deň. ");
INSERT INTO slk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Z Ptolemaidy sme teda na druhý deň odišli ďalej do Cézarey. Tam sme bývali v dome evanjelistu Filipa, ktorý bol jedným zo siedmich diakonov. ");
INSERT INTO slk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jeho štyri slobodné dcéry mali prorocký dar. ");
INSERT INTO slk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Po niekoľkých dňoch nášho pobytu pricestoval z Judska Agabus, ktorý mal tiež prorocký dar. ");
INSERT INTO slk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Prišiel k nám, vzal Pavlov opasok, spútal si ním ruky aj nohy a povedal: „Duch Svätý hovorí, že majiteľa tohto opasku Židia v Jeruzaleme takto spútajú a vydajú pohanom.“ ");
INSERT INTO slk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Keď sme to počuli, začali sme všetci, my aj tamojší bratia, prehovárať Pavla, aby nešiel do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ale on nás napomenul: „Prečo plačete a zraňujete tak moje srdce? Veď ja som odhodlaný dať sa v Jeruzaleme nielen spútať, ale aj zomrieť pre Pána Ježiša!“ ");
INSERT INTO slk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Videli sme, že je márne ho prehovárať, prestali sme a povedali: „Nech sa stane Božia vôľa.“ ");
INSERT INTO slk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Potom sme sa pripravili na cestu a vydali sme sa do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sprevádzali nás niektorí učeníci z Cézarey a doviedli nás k Mnázonovi, ktorý pochádzal z Cypru a bol jedným z prvých kresťanov. U neho sme sa mali ubytovať. ");
INSERT INTO slk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Po našom príchode do Jeruzalema nás tamojší bratia prijali veľmi srdečne. ");
INSERT INTO slk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Hneď na druhý deň sme prišli k Jakubovi, kde sa zišli aj všetci starší. ");
INSERT INTO slk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pavol sa s nimi zvítal a potom podrobne vyrozprával, aké zázračné veci konal Boh jeho prostredníctvom medzi pohanmi. ");
INSERT INTO slk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","S radosťou ho počúvali a oslavovali za to Boha. Ale potom povedali Pavlovi: „Vieš, milý brat, aj tu tisícky Židov uverili v Krista, no sú pritom horlivými zástancami zákona. ");
INSERT INTO slk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","O tebe sa však povráva, že presviedčaš Židov, ktorí žijú medzi pohanmi, aby sa vzdali Mojžišovho zákona, nedávali obrezávať svojich synov a celkom zavrhli staré židovské obyčaje. ");
INSERT INTO slk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Čo teraz? Nepochybne sa dozvedia, že si prišiel. ");
INSERT INTO slk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Radíme ti preto urobiť nasledovné: Medzi nami sú štyria muži, ktorí sa zaviazali plniť sľub. ");
INSERT INTO slk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pridaj sa k nim, podrob sa očistnému obradu a zaplať za nich, čo je predpísané. Potom si budú môcť dať ostrihať hlavu. Takto budú vidieť, že to, čo o tebe počuli, nie je pravda, ale naopak, že si Zákon vážiš a žiješ podľa neho. ");
INSERT INTO slk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pre obrátených pohanov však platí naše rozhodnutie, v ktorom sme im písomne oznámili, že nemajú jesť mäso obetované modlám, krv, ani mäso zo zadusených zvierat, a aby sa vystríhali smilstva.“ ");
INSERT INTO slk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Na ďalší deň sa Pavol spolu s tými mužmi podrobil očistnému obradu. Potom šiel do chrámu a oznámil, kedy sa skončia očistné dni a že za každého z nich bude prinesená obeť. ");
INSERT INTO slk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Keď sa končilo tých sedem dní, uvideli Pavla v chráme Židia z Malej Ázie. Poštvali proti nemu okolostojacich, chytili ho ");
INSERT INTO slk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","a kričali: „Izraeliti! Poďte sem! Tu máte toho odpadlíka! Všade hlása bludy a nič mu nie je sväté: ani naše vyvolenie, ani Zákon, ani chrám. Teraz sem dokonca priviedol pohanov, aby zneuctil toto sväté miesto.“ ");
INSERT INTO slk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Predtým totiž zazreli v meste Pavla s Trofimom z Efezu a nazdávali sa, že ho Pavol priviedol do chrámu. ");
INSERT INTO slk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","V celom meste vznikol obrovský rozruch a ľudia sa zbiehali zo všetkých strán. Medzitým vyviedli Pavla z vnútorného chrámového nádvoria a hneď za ním zavreli brány. ");
INSERT INTO slk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Už-už by ho chceli zabiť, no veliteľ rímskej posádky dostal hlásenie, že sa celý Jeruzalem búri. ");
INSERT INTO slk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ihneď vyslal na nádvorie dôstojníkov a vojakov. Keď ľudia zbadali veliteľa a vojakov, prestali Pavla biť. ");
INSERT INTO slk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Veliteľ pristúpil k Pavlovi, dal ho zatknúť a rozkázal, aby ho spútali dvoma reťazami. Potom začal vyšetrovať, kto je to a čo urobil. ");
INSERT INTO slk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Z davu vykrikoval každý čosi iné. Veliteľ videl, že sa pre obrovský hluk nič rozumné nedozvie, preto dal Pavla odviesť do pevnosti. ");
INSERT INTO slk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Keď sa Pavol dostal ku schodom, dav doňho tak dorážal, že ho vojaci museli niesť. ");
INSERT INTO slk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Celý ten rozzúrený dav sa totiž hrnul za nimi a kričal: „Zabite ho!“ ");
INSERT INTO slk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kým ho odviedli do pevnosti, spýtal sa Pavol veliteľa: „Mohol by som ťa o niečo poprosiť?“ Veliteľ sa začudoval: „Ty vieš po grécky? ");
INSERT INTO slk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ja som si myslel, že si ten Egypťan, čo sa nedávno pokúsil vyvolať povstanie a vyviedol na púšť štyri tisíc rebelantov.“ ");
INSERT INTO slk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pavol mu odpovedal: „Ja som Žid z významného mesta Tarzu v Cilícii. Dovoľ mi, prosím, prehovoriť k tým ľuďom.“ ");
INSERT INTO slk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Veliteľ súhlasil. Pavol, sa postavil na schody a dal pokyn rukou na znamenie, že chce hovoriť. Dav stíchol a Pavol začal po hebrejsky: ");
INSERT INTO slk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Bratia a otcovia! Vypočujte si teraz, prosím, moju obhajobu.“ ");
INSERT INTO slk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Keď počuli, že sa im prihovoril v ich rodnom jazyku, nastalo ešte väčšie ticho. ");
INSERT INTO slk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Som Žid, narodil som sa v Tarze v Cilícii, ale vychovaný som bol tu, v Jeruzaleme. Ako žiak Gamaliela som sa naučil zachovávať zákony našich otcov. Horlil som za Boha rovnako, ako to robíte vy dnes. ");
INSERT INTO slk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Preto som až na smrť nenávidel učenie Ježiša Krista a jeho vyznávačov, mužov aj ženy som dával zatýkať a väzniť. ");
INSERT INTO slk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","To mi môže dosvedčiť veľkňaz aj celá najvyššia rada. Raz som si od nej dokonca vyžiadal odporúčajúce listy pre židovskú obec v Damasku. Vybral som sa tam, aby som tamojších stúpencov novej viery priviedol v putách do Jeruzalema a dal ich potrestať. ");
INSERT INTO slk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","No počujte, čo sa stalo: Keď som sa okolo poludnia blížil k Damasku, zrazu sa okolo mňa rozžiarilo oslepujúce svetlo z neba. ");
INSERT INTO slk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Padol som na zem a počul som hlas: ‚Saul, Saul, prečo ma prenasleduješ?‘ ");
INSERT INTO slk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ozval som sa: ‚Kto si, Pane?‘ Odpovedal mi: ‚Som Ježiš z Nazareta, ktorého ty prenasleduješ.‘ ");
INSERT INTO slk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Moji sprievodcovia boli takisto oslepení tým svetlom, ale nepočuli toho, ktorý ku mne prehovoril. ");
INSERT INTO slk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Spýtal som sa: ‚Čo mám robiť, Pane?‘ A Pán mi povedal: ‚Vstaň! Choď do Damasku, a tam sa dozvieš, čo máš ďalej robiť.‘ ");
INSERT INTO slk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Jas toho svetla ma celkom oslepil, preto ma museli moji druhovia vziať za ruku a doviesť až do Damasku. ");
INSERT INTO slk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tam žil istý muž, ktorý sa volal Ananiáš. Bol veľmi zbožný a usiloval sa svedomite dodržiavať všetky Božie príkazy, takže sa tešil dobrej povesti u všetkých Židov v Damasku. ");
INSERT INTO slk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ten ma vyhľadal a povedal mi: ‚Milý brat Saul, opäť budeš vidieť.‘ V tej chvíli sa mi vrátil zrak a uvidel som ho. ");
INSERT INTO slk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","A ešte mi povedal: ‚Boh našich otcov si ťa vyvolil, aby si poznal jeho vôľu, videl toho Spravodlivého a počul ho hovoriť. ");
INSERT INTO slk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Staneš sa jeho svedkom pred celým svetom a všade budeš rozprávať, čo si videl a počul. ");
INSERT INTO slk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Neváhaj teda, daj sa pokrstiť na znamenie, že si očistený od hriechov, a vyznávaj, že je tvojím Pánom.‘ ");
INSERT INTO slk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Keď som sa potom vrátil naspäť do Jeruzalema a modlil som sa v chráme, dostal som sa do vytrženia. ");
INSERT INTO slk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Uvidel som Pána, ktorý mi povedal: ‚Čo najrýchlejšie odíď z Jeruzalema, lebo tvojmu svedectvu o mne nik neuverí.‘ ");
INSERT INTO slk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Odpovedal som: ‚Pane, oni predsa vedia, že práve ja som dával zatvárať do žalára a biť v synagógach tých, ktorí v teba veria. ");
INSERT INTO slk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A keď tiekla krv tvojho svedka Štefana, aj ja som bol pri tom, schvaľoval som to a strážil som šaty tým, ktorí ho kameňovali.‘ ");
INSERT INTO slk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ale Pán mi povedal: ‚Choď, lebo ťa chcem poslať ďaleko k pohanom.‘ “ ");
INSERT INTO slk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Počúvali ho až do chvíle, kým sa nezmienil o pohanoch. Potom však opäť začali kričať: „Preč s tým zradcom. Nesmie zostať nažive!“ ");
INSERT INTO slk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","A naďalej kričali, strhávali si zo seba šaty a hádzali do vzduchu prach. ");
INSERT INTO slk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Veliteľ dal Pavla rýchlo odviesť do pevnosti, rozkázal, aby ho zbičovali a vypočuli. Chcel sa dozvedieť, prečo sa dav naňho tak rozzúril. ");
INSERT INTO slk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Keď ho už priviazali, obrátil sa Pavol na veliaceho dôstojníka: „Smiete bičovať rímskeho občana a navyše bez súdneho vyšetrenia?“ ");
INSERT INTO slk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Dôstojník zašiel za veliteľom a hlásil mu to: „Čo to chceš robiť? Ten človek je rímsky občan!“ ");
INSERT INTO slk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Veliteľ pristúpil k Pavlovi a spýtal sa ho: „Je pravda, že si rímsky občan?“ Odpovedal: „Áno, som.“ ");
INSERT INTO slk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Veliteľ namietol: „Aj ja som. No ja som za to občianske právo zaplatil ťažké peniaze!“ „A ja som sa ako rímsky občan už narodil,“ povedal Pavol. ");
INSERT INTO slk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tu sa vojaci, ktorí ho mali biť a vypočúvať, ihneď stiahli. Aj veliteľ sa preľakol, keď sa dozvedel, že Pavol je rímsky občan a on ho dal spútať. ");
INSERT INTO slk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Veliteľ chcel zistiť, z čoho Židia vlastne Pavla obviňujú. Na druhý deň ho dal vyviesť z väzenia a rozkázal, aby sa zišli veľkňazi i celá veľrada. ");
INSERT INTO slk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pavol sa zahľadel členom veľrady do očí a povedal: „Bratia! Až dodnes žijem s čistým svedomím pred Bohom.“ ");
INSERT INTO slk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Po týchto slovách rozkázal veľkňaz Ananiáš tým, čo stáli pri Pavlovi, aby ho udreli po ústach. ");
INSERT INTO slk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ale Pavol zvolal: „Boh bude biť teba, ty pokrytec! Aký si to sudca? Chceš ma súdiť podľa zákona, a pritom proti Zákonu prikazuješ, aby ma bili.“ ");
INSERT INTO slk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","No tí, čo stáli vedľa Pavla, ho napomenuli: „Ako si dovoľuješ urážať veľkňaza?“ ");
INSERT INTO slk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pavol sa ospravedlnil: „Nevedel som, bratia, že je to veľkňaz. A v Písme sa naozaj hovorí: ‚Nehovor zle o vládcovi svojho ľudu!‘ “ ");
INSERT INTO slk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pavol vedel, že vo veľrade sú zastúpené dve strany: saduceji a farizeji. Preto nahlas zvolal: „Bratia, som farizej ako všetci moji predkovia. Stojím dnes pred súdom, lebo verím vo vzkriesenie mŕtvych!“ ");
INSERT INTO slk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Hneď ako to povedal, rozpútala sa hádka medzi farizejmi a saducejmi a veľrada sa rozdelila. ");
INSERT INTO slk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceji totiž popierajú vzkriesenie i existenciu duchovného sveta, kým farizeji toto všetko vyznávajú. ");
INSERT INTO slk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Strhol sa veľký krik. Niektorí učitelia zákona spomedzi farizejov sa postavili a začali rázne namietať: „Nič zlé na ňom nevidíme. Čo ak k nemu naozaj prehovoril duch alebo anjel?“ ");
INSERT INTO slk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hádka sa tak vyostrila, až sa veliteľ zľakol, že Pavla roztrhajú na kúsky. Dal preto príkaz, aby vojaci zišli dolu, násilím vytrhli Pavla z ich rúk a odviedli ho do pevnosti. ");
INSERT INTO slk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tej noci sa Pavlovi ukázal Pán a povzbudil ho: „Neboj sa, Pavol! Ako si o mne svedčil v Jeruzaleme, tak musíš svedčiť aj v Ríme.“ ");
INSERT INTO slk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na druhé ráno sa stretli Židia a zaprisahali sa, že nebudú jesť ani piť, kým Pavla nezabijú. ");
INSERT INTO slk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bolo ich viac ako štyridsať. ");
INSERT INTO slk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Zašli k veľkňazom a starším, oznámili im: „Zaviazali sme sa prísahou, že nevezmeme nič do úst, kým Pavla nezabijeme. ");
INSERT INTO slk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vy a veľrada si u veliteľa vyžiadajte, aby dal znova Pavla predviesť pod zámienkou, že chcete dôkladnejšie vyšetriť jeho prípad. A my sa ho zmocníme a zabijeme ho skôr, ako príde na miesto.“ ");
INSERT INTO slk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","O týchto úkladoch sa dozvedel syn Pavlovej sestry. Zašiel za Pavlom do pevnosti a oznámil mu. ");
INSERT INTO slk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavol si zavolal službukonajúceho dôstojníka a požiadal ho: „Zaveď tohto mladíka k veliteľovi, má pre neho dôležitú správu.“ ");
INSERT INTO slk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Dôstojník ho teda vzal k veliteľovi a povedal: „Zavolal ma väzeň Pavol so žiadosťou, aby som tohto mladíka zaviedol k tebe. Vraj má nejakú dôležitú správu.“ ");
INSERT INTO slk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Veliteľ chlapca prijal a medzi štyrmi očami sa ho opýtal: „O čo ide?“ ");
INSERT INTO slk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","„Židia sa dohodli, že ťa požiadajú, aby si zajtra dal predviesť Pavla pred veľradu. Budú sa tváriť, že ho chcú dôkladnejšie vypočuť. ");
INSERT INTO slk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Never im! cestou bude totiž na Pavla striehnuť viac ako štyridsať mužov. Zaprisahali sa, že nebudú ani jesť, ani piť, kým ho nezabijú. Sú odhodlaní na všetko a čakajú iba na tvoj súhlas.“ ");
INSERT INTO slk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Veliteľ prepustil chlapca a povedal mu: „Pred nikým ani len nemukni, čo si mi prezradil.“ ");
INSERT INTO slk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Veliteľ si ihneď zavolal dvoch dôstojníkov a prikázal im: „Pripravte na deviatu hodinu večer dvesto pešiakov, sedemdesiat jazdcov a dvesto kopijníkov na cestu do Cézarey. ");
INSERT INTO slk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Dajte koňa aj Pavlovi a postarajte sa, aby ste ho dopravili k miestodržiteľovi Felixovi.“ ");
INSERT INTO slk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Potom napísal list tohto znenia: ");
INSERT INTO slk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Klaudius Lyziáš pozdravuje veľaváženého miestodržiteľa Felixa. ");
INSERT INTO slk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Muža, ktorého ti posielam, chytili Židia a chceli ho zabiť. Keď som sa dozvedel, že je to rímsky občan, zakročil som so svojím oddielom a vytrhol im ho z rúk. ");
INSERT INTO slk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aby som zistil, z čoho ho vlastne obviňujú, predviedol som ho pred ich veľradu. ");
INSERT INTO slk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ukázalo sa, že nejde o nijaký vážny zločin, ktorý by si zasluhoval väzenie alebo smrť, ale iba o spory okolo ich zákona. ");
INSERT INTO slk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Dostal som však správu, že ho chcú úkladne zavraždiť, preto ho posielam k tebe. Zároveň som dal na vedomie žalobcom, aby sa so žalobou proti nemu obrátili na teba.“ ");
INSERT INTO slk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ešte v tú noc sa vojaci s Pavlom podľa rozkazu dostali do Antipatridy. ");
INSERT INTO slk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ráno sa vrátili do pevnosti a Pavla sprevádzali na ďalšej ceste už len jazdci. ");
INSERT INTO slk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Keď dorazili do Cézarey, odovzdali miestodržiteľovi list aj Pavla. ");
INSERT INTO slk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felix si prečítal odkaz a spýtal sa Pavla, z ktorej provincie pochádza. Keď sa dozvedel, že je z Cilície, ");
INSERT INTO slk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","povedal: „Vypočujem ťa, až prídu tvoji žalobcovia.“ Potom dal príkaz, aby Pavla strážili v Herodesovom paláci. ");
INSERT INTO slk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","O päť dní prišiel do Cézarey sám veľkňaz Ananiáš v sprievode niekoľkých členov veľrady a právneho zástupcu Tertula, aby podali u miestodržiteľa žalobu na Pavla. ");
INSERT INTO slk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Predvolali Pavla a Tertulus predniesol obžalobu: „Vznešený Felix! Tvojou zásluhou žijeme v mieri a vďaka tvojej prezieravej starostlivosti sa nášmu národu žije čoraz lepšie. ");
INSERT INTO slk_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","To vždy a všade uznávame s nesmiernou vďačnosťou. ");
INSERT INTO slk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nechcem ťa dlho zdržiavať, no prosím ťa, aby si bol taký láskavý a krátko nás vypočul. ");
INSERT INTO slk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Zistili sme totiž, že tento človek je veľmi nebezpečný, po celom svete vyvoláva medzi Židmi nepokoje a je vodcom nazarejskej sekty. ");
INSERT INTO slk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pokúsil sa dokonca znesvätiť chrám. Pritom sme ho chytili a chceli súdiť podľa našich zákonov. ");
INSERT INTO slk_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ale veliteľ Lyziáš nám ho násilne vytrhol z rúk ");
INSERT INTO slk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","a rozkázal, aby jeho žalobcovia prišli k tebe a aby bol súdený podľa rímskych zákonov. Keď ho budeš vypočúvať, sám sa môžeš presvedčiť, že naša obžaloba sa zakladá na pravde.“ ");
INSERT INTO slk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Aj ostatní Židia sa pripojili k obžalobe a potvrdili, že všetko, čo Tertulus povedal, je pravda. ");
INSERT INTO slk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na miestodržiteľov pokyn sa Pavol začal obhajovať: „Viem, že už dlhé roky vykonávaš úrad sudcu v tomto národe. Preto sa budem pred tebou obhajovať s dôverou. ");
INSERT INTO slk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Môžeš si presne zistiť, že len pred dvanástimi dňami som prišiel do Jeruzalema vzdať Bohu poklonu v chráme. ");
INSERT INTO slk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ale ani v chráme, ani v synagógach, ani na uliciach ma nikto nepristihol, že by som s niekým debatoval, alebo dokonca vyvolával vzburu medzi ľudom. ");
INSERT INTO slk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tí, ktorí na mňa teraz žalujú, nemajú proti mne žiadny dôkaz. ");
INSERT INTO slk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ale k jednému sa priznávam otvorene: slúžim Bohu našich predkov spôsobom, ktorý oni pokladajú za sektárstvo. Pevne verím všetkému, čo je napísané v Mojžišovom zákone a v prorockých knihách. ");
INSERT INTO slk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","A pevne dúfam, rovnako ako títo muži, že Boh raz vzkriesi z mŕtvych spravodlivých aj nespravodlivých. ");
INSERT INTO slk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Práve táto viera ma nabáda, aby som sa usiloval zachovať si čisté svedomie pred Bohom aj pred ľuďmi. ");
INSERT INTO slk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","A tak po mnohých rokoch som sa vrátil, aby som svojmu národu odovzdal peňažnú podporu od iných národov a priniesol obeť v chráme. ");
INSERT INTO slk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A vtedy ma tam pri očistnom obrade zazreli. No nebol tam ani zhluk ľudí, ani nedošlo k nijakým výtržnostiam. ");
INSERT INTO slk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Boli tam, pravda, niektorí Židia z Malej Ázie. Tí by mali byť teraz tu, ak niečo proti mne majú. ");
INSERT INTO slk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Alebo nech tí, čo sú tu prítomní, povedia, z akého zločinu ma usvedčili, keď som stál pred veľradou. ");
INSERT INTO slk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Iba ak by mali na mysli tú jedinú vec, ktorý som zakričal, keď som stál pred nimi: ‚Pre vieru vo vzkriesenie ma dnes súdite!‘ “ ");
INSERT INTO slk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix, ktorý už bol oboznámený s kresťanským učením, odročil preto rokovanie s odôvodnením: „Váš spor rozhodnem až potom, keď príde veliteľ Lyziáš.“ ");
INSERT INTO slk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dôstojníkovi potom prikázal, aby Pavla držal len v ľahkej väzbe a nebránil jeho priateľom, keby mu chceli nejako poslúžiť. ");
INSERT INTO slk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","O niekoľko dní prišiel Felix so svojou manželkou Druzilou, ktorá bola Židovka. Dal si zavolať Pavla a nechal si od neho rozprávať o viere v Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Keď sa však Pavol dotkol problému spravodlivosti, sebaovládania a budúceho súdu, Felix znervóznel a povedal: „Nadnes stačí. Keď budem mať čas, dám si ťa zase zavolať.“ ");
INSERT INTO slk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A naozaj, často posielal po Pavla a debatoval s ním, ale zrejme najmä preto, že čakal od neho nejaký úplatok. ");
INSERT INTO slk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aby si získal priazeň Židov, nechával Pavla naďalej vo väzení. Tak to trvalo dva roky, kým Felixa nevystriedal v úrade Porcius Festus. ");
INSERT INTO slk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Na tretí deň po prevzatí úradu odcestoval Festus z Cézarey do Jeruzalema. ");
INSERT INTO slk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tam ho vyhľadali veľkňazi a ďalší židovskí predstavitelia a predniesli mu svoju žalobu proti Pavlovi. ");
INSERT INTO slk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Usilovali sa získať jeho priazeň a prehovoriť ho, aby dal previesť Pavla naspäť do Jeruzalema. Chceli však Pavla cestou prepadnúť a zavraždiť. ");
INSERT INTO slk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus im odpovedal: „Pavol je vo väzbe v Cézarey, kam sa ja sám čoskoro vrátim. ");
INSERT INTO slk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Vyšlite so mnou tých, čo majú medzi vami moc, a ak toho človeka z niečoho obviňujete, vzneste žalobu tam.“ ");
INSERT INTO slk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Po ôsmich či desiatich dňoch sa Festus vrátil do Cézarey. Hneď na druhý deň zvolal súd a rozkázal predviesť Pavla. ");
INSERT INTO slk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Len čo ho priviedli, zástupcovia z Jeruzalema ho obkľúčili a zasypali mnohými vážnymi obvineniami, ktoré však nemohli nijako dokázať. ");
INSERT INTO slk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pavol sa však obhajoval: „Neporušil som ani židovské zákony, ani som neznesvätil chrám, ani som sa nestaval proti rímskej vláde.“ ");
INSERT INTO slk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus sa chcel zapáčiť Židom, preto navrhol Pavlovi: „Chceš ísť do Jeruzalema a tam byť súdený v mojej prítomnosti?“ ");
INSERT INTO slk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pavol však povedal: „Stojím teraz pred cisárskym súdom, ktorý ma má súdiť. Proti Židom som sa ničím neprevinil a ty to veľmi dobre vieš. ");
INSERT INTO slk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ak som vinný a vykonal som niečo, čo si zasluhuje smrť, som ochotný zomrieť. Ale ak sú ich žaloby proti mne nepodložené, nik nemá právo vydať ma do ich rúk. Preto sa odvolávam k cisárovi!“ ");
INSERT INTO slk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus sa šiel poradiť so svojimi radcami a potom oznámil: „Keďže si sa odvolal k cisárovi, pôjdeš k cisárovi.“ ");
INSERT INTO slk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","O niekoľko dní zavítal do Cézarey kráľ Herodes Agrippa so svojou sestrou Berenikou. Prišli pozdraviť Festa ");
INSERT INTO slk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","a zdržali sa uňho niekoľko dní. Pri jednej príležitosti im Festus predložil Pavlov prípad: „Zdedil som tu po Felixovi zvláštneho väzňa. ");
INSERT INTO slk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Keď som bol v Jeruzaleme, žalovali naňho veľkňazi a ostatní židovskí vodcovia a žiadali odo mňa rozsudok smrti. ");
INSERT INTO slk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pravdaže, poučil som ich, že rímske právo nikoho neodsúdi, kým nevypočuje obidve strany, a že každý musí dostať možnosť obhajovať sa. ");
INSERT INTO slk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Keď sem prišli z Jeruzalema jeho žalobcovia, ihneď som zvolal súd a rozkázal som priviesť toho muža. ");
INSERT INTO slk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Predpokladal som, že jeho žalobcovia predložia obvinenia z nejakých zločinov, no nestalo sa tak. ");
INSERT INTO slk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Išlo len o nejaké ich náboženské spory a o nejakého mŕtveho Ježiša, o ktorom Pavol tvrdí, že žije. ");
INSERT INTO slk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Keďže som si nebol istý, ako celú vec vyriešiť, navrhol som mu, aby sa súd konal priamo v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ale Pavol sa odvolal a žiadal, aby zostal vo väzbe až do cisárovho rozhodnutia. A tak je tu vo väzení, kým budem mať príležitosť poslať ho do Ríma.“ ");
INSERT INTO slk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa povedal: „Ten človek ma zaujíma, rád by som ho vypočul.“ Festus mu sľúbil: „Zajtra budeš mať možnosť.“ ");
INSERT INTO slk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Na druhý deň prišli Agrippa a Berenika s celou kráľovskou pompou do veľkej siene. Sprevádzali ich vysokí dôstojníci a poprední mestskí hodnostári. Festus dal príkaz, aby priviedli Pavla. ");
INSERT INTO slk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Povedal: „Kráľ Agrippa a vážení prítomní! Toto je človek, na ktorého sa sťažovali Židia v Jeruzaleme aj tu. Veľmi hlasno naliehajú, že musí zomrieť. ");
INSERT INTO slk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ja som však zistil, že tento človek nevykonal nič, za čo by si zaslúžil smrť. Ale keďže sa odvolal na jeho cisárske veličenstvo, rozhodol som, že ho k nemu pošlem. ");
INSERT INTO slk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nemám však nič, čo by som mohol uviesť do obžaloby, ktorú musím cisárovi poslať. Preto som ho dal znova predvolať pred vás, najmä pred teba, kráľ Agrippa, aby ste ho vypočuli a aby som mohol uviesť dôvod obžaloby. ");
INSERT INTO slk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Pokladám totiž za nerozumné poslať väzňa k cisárovi bez udania viny.“ ");
INSERT INTO slk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa vyzval Pavla: „Je ti dovolené prehovoriť na svoju obhajobu.“ Pavol zdvihol ruku na spôsob rečníkov a začal hovoriť: ");
INSERT INTO slk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","„Pokladám sa za šťastného, kráľ Agrippa, že sa môžem práve pred tebou obhajovať proti žalobám Židov. ");
INSERT INTO slk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A to zvlášť preto, že výborne poznáš židovské obyčaje i sporné otázky. Preto prosím, aby si ma trpezlivo vypočul. ");
INSERT INTO slk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Môj život poznajú od mladosti všetci Židia. Vedia, ako som žil v mojom kraji i v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Poznajú ma už dlho a keby chceli, mohli by dosvedčiť, že som patril k nášmu najprísnejšiemu náboženskému smeru, k farizejom. ");
INSERT INTO slk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A dnes stojím pred súdom práve preto, lebo pevne verím, že Boh splní zasľúbenie, ktoré dal našim predkom. ");
INSERT INTO slk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dvanásť kmeňov nášho národa dúfa, že toto zasľúbenie dosiahne, a vo dne aj v noci horlivo slúži Bohu. Pre túto nádej ma Židia obžalovali zo zločinu. ");
INSERT INTO slk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Prečo sa vám zdá neuveriteľné, že Boh kriesi mŕtvych? ");
INSERT INTO slk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Pravda, vtedy som sa aj ja nazdával, že musím všemožne bojovať proti Ježišovi Nazaretskému ");
INSERT INTO slk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","To som v Jeruzaleme aj konal. A keď som dostal od veľkňazov splnomocnenie, dal som mnohých kresťanov uväzniť. A ak mali byť usmrtení, súhlasil som s tým. ");
INSERT INTO slk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","V synagógach som dával ľudí trestať a snažil som sa ich prinútiť, aby sa rúhali Kristovi. Ako zmyslov zbavený som ich chcel prenasledovať aj v iných mestách. ");
INSERT INTO slk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Preto som sa vybral so splnomocnením a poverením veľkňazov do Damasku. ");
INSERT INTO slk_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A tu zrazu, kráľu, za bieleho dňa, práve napoludnie, svetlo z neba, jasnejšie ako slnko, oslepilo mňa aj mojich sprievodcov. ");
INSERT INTO slk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Všetci sme padli na zem a ja som počul hlas v hebrejčine: ‚Saul, Saul, prečo ma prenasleduješ? Márne sa proti mne vzpieraš!‘ ");
INSERT INTO slk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Spýtal som sa: ‚Kto si, Pane?‘ A on mi odpovedal: ‚Ja som Ježiš, ktorého ty prenasleduješ. ");
INSERT INTO slk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ale teraz vstaň! Zjavil som sa ti preto, aby si bol mojím služobníkom a aby si svedčil o tom, čo si zažil a čo ti dám ešte poznať. ");
INSERT INTO slk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Budem ťa chrániť pred tvojím vlastným národom aj pred pohanmi, ku ktorým ťa posielam. ");
INSERT INTO slk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Budeš im otvárať oči, aby sa obrátili od tmy k svetlu, od moci satanovej k Bohu. Vierou vo mňa príjmu odpustenie svojich hriechov a dostanú miesto medzi jeho vyvolenými.‘ ");
INSERT INTO slk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kráľ Agrippa, toto nebeské zjavenie som nemohol neposlúchnuť. ");
INSERT INTO slk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Preto som musel najprv v Damasku, potom v Jeruzaleme, v celom Judsku a napokon aj medzi pohanmi nabádať ľudí, aby zmenili svoje myslenie a obrátili sa k Bohu a dosvedčili to novým životom. ");
INSERT INTO slk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","To je ten ‚zločin‘, pre ktorý sa ma Židia zmocnili v chráme a chceli ma zabiť. ");
INSERT INTO slk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ale Boh ma zakaždým vytrhol z ich rúk, a tak tu dnes môžem stáť a vydávať svedectvo ľuďom vznešeným i obyčajným. Nehlásam nič iné, len čo predpovedali proroci a Mojžiš, ");
INSERT INTO slk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","že Mesiáš bude trpieť, ako prvý vstane z mŕtvych, a tak prinesie svetlo Židom aj pohanom.“ ");
INSERT INTO slk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Tu Festus prerušil Pavlovu obhajobu: „Pavol, ty si sa zbláznil. Tá tvoja veľká učenosť ťa pripravila o rozum.“ ");
INSERT INTO slk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pavol sa však bránil: „Nezbláznil som sa, vznešený Festus. Moje slová sú pravdivé a jasné. ");
INSERT INTO slk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Veď aj kráľovi Agrippovi sú tieto veci známe a môžem o nich hovoriť otvorene. Som totiž presvedčený, že mu nič z toho neuniklo. Veď sa to nedialo niekde v ústraní. ");
INSERT INTO slk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kráľ Agrippa, veríš tomu, čo predpovedali proroci? Ja viem, že tomu veríš.“ ");
INSERT INTO slk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa Pavlovi odpovedal: „Takmer si ma presvedčil, aby som sa stal kresťanom.“ ");
INSERT INTO slk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A Pavol odpovedal: „Kiežby dal Boh, aby si sa nielen ty, ale aj všetci, čo ma dnes počúvajú, stali skôr či neskôr tým, čím som ja; pravda, bez týchto reťazí.“ ");
INSERT INTO slk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kráľ, miestodržiteľ, Berenika aj ostatní vstali ");
INSERT INTO slk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","a keď odchádzali, zhodli sa: „Tento človek neurobil nič, za čo by si zasluhoval smrť alebo väzenie.“ ");
INSERT INTO slk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","A Agrippa povedal Festovi: „Keby sa nebol odvolal k cisárovi, mohol byť už na slobode.“ ");
INSERT INTO slk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Konečne sa rozhodlo, že sa budeme plaviť loďou do Itálie. Pavla a ešte niekoľkých väzňov zverili dôstojníkovi Júliovi z cisárskeho oddielu. ");
INSERT INTO slk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nastúpili sme na adramytskú loď, ktorá sa mala plaviť do prístavov pozdĺž pobrežia Ázie. Bol s nami aj Aristarchos Macedónec z Tesaloniky. ");
INSERT INTO slk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na druhý deň sme pristáli v Sidone. Július sa správal k Pavlovi veľmi láskavo a dovolil mu navštíviť v meste svojich priateľov, ktorí mu dali všetko, čo potreboval. ");
INSERT INTO slk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Vial nepriaznivý vietor, preto sme sa ďalej plavili medzi Cyprom a pevninou: ");
INSERT INTO slk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","preplavili sme sa popri Cilícii a Pamfýlii a napokon sme pristáli v Myre v Lýcii. ");
INSERT INTO slk_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tam dôstojník našiel alexandrijskú loď, ktorá sa plavila do Itálie, a nalodil nás na ňu. ");
INSERT INTO slk_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Niekoľko dní bola plavba veľmi namáhavá a horko-ťažko sme sa dostali do miest oproti Knidu. Pre nepriaznivý vietor sme tam nemohli pristáť, preto sme pokračovali v ceste okolo Salmony chránení Krétou. ");
INSERT INTO slk_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","S ťažkosťami sme sa plavili pozdĺž pobrežia, až sme sa dostali na miesto zvané Dobré prístavy neďaleko mesta Lasaia. ");
INSERT INTO slk_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Medzitým sme stratili veľa času, a keďže bolo už po Dni zmierenia a plavba cez šíre more bola v tomto období nebezpečná, Pavol ich varoval: ");
INSERT INTO slk_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","„Priatelia, vidím, že ďalšia plavba bude veľmi namáhavá a ohrozí nielen náklad a loď, ale aj životy nás všetkých.“ ");
INSERT INTO slk_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lenže dôstojník dal väčšmi na kapitána a na majiteľa lode ako na Pavlove slová. ");
INSERT INTO slk_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Keďže prístav nebol vhodný na prezimovanie, väčšina sa rozhodla plaviť ďalej, podľa možnosti sa dostať do Fénixu a tam zostať cez zimu. Je to prístav na Kréte, otvorený len na severozápad a juhovýchod. ");
INSERT INTO slk_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Práve začal viať od juhu mierny vietor, preto sa nazdávali, že je to ideálny čas na vyplávanie, a tak zdvihli kotvu a plavili sa pozdĺž Kréty. ");
INSERT INTO slk_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Onedlho sa však od Kréty prihnal prudký nárazový vietor zvaný Eurakylón. ");
INSERT INTO slk_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Vietor bol taký silný, že sa loď nedala ovládať, preto sme sa pustili po vetre a dali sme sa ním unášať. ");
INSERT INTO slk_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dostali sme sa takto do závetria ostrovčeka Kauda a len s veľkou námahou sa nám podarilo dostať záchranný čln do bezpečia. ");
INSERT INTO slk_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Potom námorníci zabezpečili loď tým, že ju previazali. Báli sa, aby nenarazili na nebezpečné syrtské plytčiny, preto stiahli plachty a dali sa unášať vetrom. ");
INSERT INTO slk_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Na druhý deň, keď sa vlny nebezpečne dvíhali a búrka prudko zmietala loďou, námorníci začali vyhadzovať náklad ");
INSERT INTO slk_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","a na tretí deň aj vybavenie lode. ");
INSERT INTO slk_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Búrka zúrila niekoľko dní, nebolo vidieť slnko ani hviezdy a postupne sme strácali všetku nádej, že vyviazneme živí. ");
INSERT INTO slk_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Keď už dlhší čas nikto na jedlo ani len nepomyslel, zašiel Pavol medzi námorníkov a povedal im: „Priatelia, mali ste ma poslúchnuť a prezimovať na Kréte. Boli by ste si ušetrili toto nebezpečenstvo a vyhli sa škode. ");
INSERT INTO slk_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Vyzývam vás však: neklesajte na duchu a nestrácajte nádej, lebo nik z vás nezahynie, prídeme iba o loď. ");
INSERT INTO slk_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Dnes v noci sa mi zjavil anjel od Boha, ktorému patrím a ktorému slúžim, ");
INSERT INTO slk_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a povedal mi: ‚Neboj sa, Pavol, určite budeš stáť pred cisárom. Boh ti daroval aj životy všetkých, ktorí sa plavia s tebou.‘ ");
INSERT INTO slk_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","A tak hlavy hore, priatelia! Verím totiž Bohu, že svoj sľub splní. ");
INSERT INTO slk_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Vietor nás odveje k nejakému ostrovu.“ ");
INSERT INTO slk_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Už štrnástu noc nás víchor hnal Stredozemným morom do neznáma, keď okolo polnoci sa zrazu lodníkom zamarilo, že sa na obzore sa ukázala nejaká pevnina. ");
INSERT INTO slk_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Námorníci spustili olovnicu a namerali hĺbku okolo štyridsať metrov a o kúsok ďalej už len tridsať metrov. ");
INSERT INTO slk_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Báli sa, že by sme mohli potme naraziť na nejaké skaliská, preto vzadu spustili štyri kotvy a túžobne vyčkávali, kedy sa rozbrieždi. ");
INSERT INTO slk_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Námorníci chceli zradne opustiť ohrozenú loď. Spustili na more záchranný čln, akože chcú spustiť kotvy z predku lode, ");
INSERT INTO slk_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ale Pavol povedal dôstojníkovi a vojakom: „Pozor na nich! Ak nezostanú na lodi, nepodarí sa vám zachrániť.“ ");
INSERT INTO slk_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tu vojaci presekli laná člna a nechali ho odplávať preč. ");
INSERT INTO slk_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ešte skôr ako sa rozvidnelo, povzbudzoval Pavol všetkých na lodi, aby sa najedli: „Už štrnásty deň takto vyčkávate na záchranu, trpíte hladom, a pritom nič nevezmete do úst. ");
INSERT INTO slk_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Radím vám, aby ste sa najedli. Budete to potrebovať, aby ste sa zachránili. Veď som vám povedal, že sa nikomu ani vlas na hlave neskriví.“ ");
INSERT INTO slk_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Vzal chlieb, pred všetkými zaň nahlas poďakoval Bohu, odlomil si z neho a začal jesť. ");
INSERT INTO slk_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Všetkých to povzbudilo a takisto sa dali do jedenia. ");
INSERT INTO slk_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Na lodi nás bolo spolu dvestosedemdesiatšesť osôb. ");
INSERT INTO slk_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Keď sme sa najedli, námorníci začali vyhadzovať do mora obilie, aby zmenšili ponor lode. ");
INSERT INTO slk_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Konečne sa rozvidnelo. Zazreli sme pred sebou pás plochého pobrežia so zálivom, ale nik nepoznal, o akú pevninu ide. Námorníci sa rozhodli, že ak sa bude dať, pristanú s loďou v zátoke. ");
INSERT INTO slk_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Odsekli kotvy a nechali ich v mori a zároveň uvoľnili povrazy kormidiel. Potom nastavili prednú plachtu vetru a zamierili k brehu. ");
INSERT INTO slk_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nabehli však na plytčinu a na nej loď zaviazla. Prova sa pevne zaborila do dna; korma lode bola vystavená náporu prudkých vĺn a pomaly sa začala rozpadávať. ");
INSERT INTO slk_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vojaci už chceli pozabíjať všetkých väzňov, aby niektorý z nich nedoplával na breh a neutiekol. ");
INSERT INTO slk_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ale dôstojník chcel zachrániť Pavla, preto im to nedovolil. Nariadil, aby najprv skočili do vody tí, čo vedia plávať, ");
INSERT INTO slk_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a ostatní nech si zadovážia dosky alebo nejaké trosky z lode a na nich nech sa pokúsia dostať na breh. Takto sa nikto neutopil a všetci sa dostali v poriadku na breh. ");
INSERT INTO slk_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Keď sme boli v bezpečí, dozvedeli sme sa, že sme na ostrove Malta. ");
INSERT INTO slk_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tamojší ľudia sa k nám správali neobyčajne láskavo. Keďže bolo chladno a začalo pršať, rozložili veľký oheň a ujali sa nás. ");
INSERT INTO slk_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pavol nazbieral za náruč raždia a prikladal na oheň. Vtom vyliezla z raždia zmija, ktorá utekala pred horúčavou, a zahryzla sa mu do ruky. ");
INSERT INTO slk_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Keď domorodci videli, ako mu z ruky visí zmija, vraveli si medzi sebou: „Ten človek je určite vrah! Pred utopením sa zachránil, no pred spravodlivosťou neutečie!“ ");
INSERT INTO slk_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ale Pavol pokojne striasol hada do ohňa a nič zlé sa mu nestalo. ");
INSERT INTO slk_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ľudia čakali, že opuchne, alebo odrazu padne mŕtvy. Keď však uplynul dosť dlhý čas a videli, že je celkom v poriadku, začali si šepkať pravý opak, že Pavol je akiste nejaký boh. ");
INSERT INTO slk_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Neďaleko toho miesta mal svoj majetok Publius, správca ostrova. Prijal nás a tri dni sa o nás staral ako o svojich hostí. ");
INSERT INTO slk_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiov otec bol práve chorý: drvila ho zimnica a úplavica. Pavol zašiel za ním, pomodlil sa, položil na neho ruky a uzdravil ho. ");
INSERT INTO slk_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Po tejto udalosti začali za Pavlom prichádzať zo všetkých strán chorí a on ich uzdravoval. ");
INSERT INTO slk_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Za to si nás nesmierne vážili a pred odchodom nás zahrnuli všetkým, čo sme len potrebovali. ");
INSERT INTO slk_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Prešli tri mesiace, kým sme mohli pokračovať v ceste. Vzala nás loď, ktorá vyplávala z Alexandrie a na ostrove prezimovala. Ako znak mala Blížencov Kastora a Poluxa. ");
INSERT INTO slk_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Pristála najprv v Syrakúzach na Sicílii, kde sme sa zdržali tri dni. ");
INSERT INTO slk_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Odtiaľ sme sa plavili popri pobreží a dostali sme sa do Regia a s južným vetrom, ktorý nám vial do chrbta, sme po dvoch dňoch pristáli v Puteoloch. ");
INSERT INTO slk_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tam sme sa stretli s bratmi a na ich naliehanie sme sa u nich zdržali celý týždeň. ");
INSERT INTO slk_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Odtiaľ sme sa pobrali pešo do Ríma. Dopočuli sa o nás tamojší bratia, niektorí nám prišli naproti na Appiovo trhovisko, iní aspoň k Trom hostincom. Len čo Pavol zazrel bratov, ďakoval Bohu a nesmierne ho to povzbudilo. ");
INSERT INTO slk_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","V Ríme mu potom dovolili bývať v súkromnom byte, ale vždy s jedným vojenským strážcom. ");
INSERT INTO slk_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tri dni po príchode do Ríma si Pavol pozval k sebe tamojších popredných Židov. Keď sa zišli, povedal im: „Bratia, ničím som sa neprevinil proti nášmu národu, ani proti obyčajom našich predkov, a predsa ma v Jeruzaleme zatkli a spútaného vydali do rúk Rimanom. ");
INSERT INTO slk_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tí ma po vypočutí chceli prepustiť, lebo som nevykonal nič, za čo by som si zasluhoval smrť. ");
INSERT INTO slk_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ale Židia sa proti tomu rázne postavili, a tak mi nezostalo nič iné, iba sa odvolať k cisárovi. Nemienim tu však žalovať na svoj národ. ");
INSERT INTO slk_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Preto som túžil stretnúť sa s vami a pozhovárať sa o tom. Pre našu spoločnú vieru v Mesiáša nosím tieto reťaze!“ ");
INSERT INTO slk_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Odpovedali mu: „Z Judska sme o tebe nedostali žiadnu správu, ani nikto nehovoril o tebe nič zlé, ");
INSERT INTO slk_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","no radi by sme vedeli, aké sú tvoje názory, lebo vieme, že táto sekta sa všade stretáva s odporom.“ ");
INSERT INTO slk_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dohodli si teda ďalšie stretnutie a zišlo sa ich uňho ešte omnoho viac. Pavol im celý deň hovoril o podstate Božieho kráľovstva. Hovoril im o Ježišovi Kristovi a presviedčal ich dôkazmi z Mojžišovho zákona a z prorockých kníh. ");
INSERT INTO slk_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Niektorých jeho slová presvedčili, iní však odmietali uveriť. ");
INSERT INTO slk_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Keď sa v nezhode rozchádzali, Pavol im povedal: „Presne tak to Duch Svätý predpovedal vašim predkom ústami proroka Izaiáša: ");
INSERT INTO slk_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‚Budete počúvať, ale neporozumiete, budete sa dívať, ale neuvidíte. ");
INSERT INTO slk_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Lebo srdce tohto ľudu otupelo, ušami ťažko počujú a zavreli oči, aby nevideli, nepočuli a neporozumeli, aby sa neobrátili k Bohu, ktorý by ich mohol uzdraviť.‘ ");
INSERT INTO slk_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Preto sa nečudujte, že radostnú zvesť o Božej záchrane hlásame pohanom. A tí ju budú prijímať.“ ");
INSERT INTO slk_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Po tých slovách Židia odišli a veľmi sa medzi sebou hádali. ");
INSERT INTO slk_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Celé dva roky zostal Pavol vo svojom prenajatom byte a mohol prijímať každého, kto ho navštívil. ");
INSERT INTO slk_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A tak slobodne a bez prekážok hlásal Božie kráľovstvo a učil o Pánovi Ježišovi Kristovi.");
INSERT INTO slk_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ja, Pavol, som služobníkom Ježiša Krista, ktorý si ma povolal za svojho apoštola a poveril ma, aby som šíril Božiu dobrú správu. ");
INSERT INTO slk_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","V svätých písmach ju Boh už dávno zasľúbil prostredníctvom svojich prorokov. ");
INSERT INTO slk_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Je to evanjelium o jeho Synovi, ktorý je ako človek potomkom Dávida, ");
INSERT INTO slk_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","zároveň však o ňom Duch svätosti dosvedčil, že je Božím Synom, obdareným Svätým Duchom a mocou, čo dokazuje jeho vzkriesenie. Tým Synom je Ježiš Kristus, náš Pán. ");
INSERT INTO slk_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Od neho som prijal milosť a poverenie privádzať ľudí všetkých národov k poslušnosti viery. ");
INSERT INTO slk_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Aj vy ste z tých, ktorí boli povolaní, aby patrili Ježišovi Kristovi. ");
INSERT INTO slk_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","A tak všetkým v Ríme, ktorých si Boh zamiloval a ktorých si povolal ako svoj svätý ľud, želám milosť a pokoj od Boha, nášho Otca, a od Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Predovšetkým ďakujem Bohu za každého z vás. Veď vďaka Ježišovi sa o vašej viere hovorí po celom svete. ");
INSERT INTO slk_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Sám Boh, ktorému z celého srdca slúžim a šírim radostnú zvesť o jeho Synovi, vie, ako často na vás myslím ");
INSERT INTO slk_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","a neprestajne ho prosím, aby mi dožičil navštíviť vás, ak to bude jeho vôľa. ");
INSERT INTO slk_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Túžim vás uvidieť osobne a upevniť vašu vieru tým, čo mi Svätý Duch daroval. ");
INSERT INTO slk_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Zároveň túžim po tom, aby sme sa navzájom povzbudili vierou vašou i mojou. ");
INSERT INTO slk_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Milí bratia, bol by som rád, aby ste vedeli, že som k vám plánoval prísť už neraz. Chcel som, aby som aj u vás ako u iných národov mohol získať ľudí pre Krista, ale zakaždým mi v tom niečo zabránilo. ");
INSERT INTO slk_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Cítim sa totiž dlžníkom národom, vyspelým aj barbarským, vzdelaným aj nevzdelaným, ");
INSERT INTO slk_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","a z toho pramení moja túžba šíriť dobrú správu aj u vás v Ríme. ");
INSERT INTO slk_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nehanbím sa za evanjelium, lebo je v ňom Božia moc na záchranu každého, kto verí: najprv pre Židov a teraz aj pre pohanov. ");
INSERT INTO slk_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","V ňom sa zjavuje Božia spravodlivosť, ktorá sa prijíma vierou a k viere vedie. Veď už prorok Habakuk napísal: „Spravodlivý bude žiť z viery.“ ");
INSERT INTO slk_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ale Boh odhaľuje svoj hnev voči všetkým, ktorí vedú hriešny a nespravodlivý život, a tým potláčajú pravdu. ");
INSERT INTO slk_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Veď všetko, čo môže človek o Bohu poznať, zjavil Boh aj im. ");
INSERT INTO slk_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Jeho večnú moc aj božstvo, ktoré sú neviditeľné, môžu ľudia poznávať uvažovaním nad celým stvoreným svetom. Nikto sa nebude môcť vyhovárať, že o Bohu nevedel. ");
INSERT INTO slk_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hoci ľudia oddávna poznali Boha, neuctievali ho, ani mu neboli vďační. Vlastné myšlienky ich zviedli do márnosti a nerozumné srdce sa im zatemnilo. ");
INSERT INTO slk_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Tvrdia o sebe, že sú múdri, ale upadli do bláznovstva. ");
INSERT INTO slk_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Namiesto toho, aby uctievali večného Boha, vytvorili si modly z dreva alebo kameňa v podobe smrteľného človeka, alebo aj vtákov, štvornožcov a plazov. ");
INSERT INTO slk_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Preto ich Boh nechal napospas nečistým vášňam ich srdca, takže zneuctievajú svoje vlastné telá. ");
INSERT INTO slk_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Vymenili Božiu pravdu za lož a namiesto Stvoriteľovi sa klaňajú a slúžia Bohom stvoreným veciam. Jemu jedinému patrí česť a sláva naveky! Amen. ");
INSERT INTO slk_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Preto ich Boh ponechal samých na seba a dovolil, aby upadli do hanebných náruživostí. Ich ženy zamenili prirodzený styk za neprirodzený. ");
INSERT INTO slk_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Aj muži namiesto prirodzeného styku so ženami zahoreli túžbou po sebe, navzájom sa oddávajú hanebnostiam, a tak sami na sebe znášajú trest za svoju zvrátenosť. ");
INSERT INTO slk_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Keďže odmietli to, čo môže človek o Bohu naozaj poznať, vydal ich Boh napospas ich zvrátenej mysli a nechal ich robiť všetko, čo sa nepatrí. ");
INSERT INTO slk_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ich život je plný neprávosti, podlosti, chamtivosti a nevraživosti. Sú plní závisti, vraždenia, konfbdtov, intrigánstva a zlomyseľnosti. ");
INSERT INTO slk_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ohovárajú sa navzájom, nenávidia Boha, sú nafúkaní, spupní, vymýšľajú hriešne veci, nectia si rodičov. ");
INSERT INTO slk_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Sú nerozumní, zradní, nepoznajú lásku ani zľutovanie. ");
INSERT INTO slk_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Vedia, že si podľa Božieho rozhodnutia za svoje správanie zaslúžia smrť, a predsa nielenže sami tak konajú, ale takéto konanie schvaľujú aj u iných. ");
INSERT INTO slk_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Vynášaš súd, človeče, nad druhými? Veď tebe samému nemôže byť odpustené, lebo v tom, v čom súdiš druhého človeka, odsudzuješ samého seba; lebo to, čo odsudzuješ, robíš sám. ");
INSERT INTO slk_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Vieme, že spravodlivý Boh nenechá bez trestu nikoho, kto takto koná. ");
INSERT INTO slk_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Iných súdiš a dúfaš, že sám unikneš súdu, hoci robíš to isté? ");
INSERT INTO slk_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nepohŕdaš aj ty nesmiernou Božou dobrotou, trpezlivosťou a zhovievavosťou? Neuvedomuješ si, že práve Božia láskavosť sa ťa snaží viesť k zmene myslenia? ");
INSERT INTO slk_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ale ty sa naďalej zaťato vzpieraš Bohu a nechceš sa odvrátiť od hriechu, a takto len zväčšuješ hnev, ktorý sa zjaví v deň spravodlivého Božieho súdu. ");
INSERT INTO slk_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","V ten deň Boh spravodlivo odplatí každému podľa jeho zásluhy. ");
INSERT INTO slk_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Večný život dá tým, ktorí sa neúnavným konaním dobra usilujú o nepominuteľnú slávu a česť. ");
INSERT INTO slk_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Tých však, ktorí myslia len na seba, odmietajú pravdu a nasledujú zlo, stihne hnev a spravodlivý trest. ");
INSERT INTO slk_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Súženie a úzkosť dopadnú raz na každého, kto pácha zlo, na Židov a aj na pohanov. ");
INSERT INTO slk_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ale tých, čo konajú dobro, čaká sláva, česť a pokoj, nezáleží, či je to Žid, alebo niekto iný. ");
INSERT INTO slk_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Boh totiž nikoho neuprednostňuje. ");
INSERT INTO slk_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Tí, čo hrešili a nemali zákon, zahynú bez zákona. A tých čo zákon poznali, ale hrešili proti nemu, budú odsúdení podľa zákona. ");
INSERT INTO slk_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Aby bol človek uznaný za spravodlivého, na to nestačí zákon iba poznať, treba podľa neho aj žiť. ");
INSERT INTO slk_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ak pohania, hoci Boží zákon nepoznajú, konajú podľa svojho svedomia tak, že je to v súlade s Božími príkazmi, sami ukazujú, že vedia ako žiť, hoci zákon nemajú. ");
INSERT INTO slk_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Svojím životom tak dávajú najavo, že to, čo zákon požaduje, majú napísané vo svojom srdci, čo im dosvedčuje ich svedomie. Ich myšlienky ich buď obviňujú, alebo ospravedlňujú. ");
INSERT INTO slk_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","To, čo je dnes v ľuďoch skryté, zjaví sa v deň súdu, ktorý Boh vykoná prostredníctvom Ježiša Krista, ako som to zvestoval v evanjeliu. ");
INSERT INTO slk_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ak sa teda považuješ za Žida, spoliehaš sa na Zákon a chváliš sa Bohom; ");
INSERT INTO slk_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ak poznáš jeho vôľu a vieš rozoznať, na čom záleží, lebo si vyučený v Zákone; ");
INSERT INTO slk_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ak si namýšľaš, že by si mohol byť vodcom slepých a svetlom tým, čo blúdia v tme ");
INSERT INTO slk_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","a že by si mohol vychovávať nevzdelaných a učiť nedospelých, lebo zo Zákona čerpáš všetko poznanie a pravdu; ");
INSERT INTO slk_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ty, ktorý iných učíš, sám seba neučíš? Hlásaš, že sa nesmie kradnúť, a pritom sám kradneš? ");
INSERT INTO slk_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Hovoríš, že sa nesmie cudzoložiť, a pritom sa sám dopúšťaš cudzoložstva? Modlárov zatracuješ, ale dopúšťaš sa svätokrádeže? ");
INSERT INTO slk_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Oháňaš sa Zákonom, ale sám ho prestupuješ, a tým zneuctievaš Boha, ");
INSERT INTO slk_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ako je napísané: „Kvôli vám svet každý deň potupuje moje meno.“ ");
INSERT INTO slk_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Obriezka má zmysel, len ak žiješ podľa toho, čo prikazuje Zákon. Ak však Zákon prestupuješ, stávaš sa človekom, ktorý je ako pohan. ");
INSERT INTO slk_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ale ak pohan zachováva požiadavky Zákona, vari sa na neho Boh nebude pozerať ako na obrezaného? ");
INSERT INTO slk_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ten, kto nie je obrezaný, ale žije podľa Zákona, bude súdiť teba, ktorý Zákon prestupuješ, hoci ho poznáš a nosíš viditeľné znamenie svojej viery. ");
INSERT INTO slk_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Pravým Židom totiž nie je ten, kto je ním navonok, ani obrezaným človek nie je ten, kto má viditeľné znamenie na tele. ");
INSERT INTO slk_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Pravým Židom je ten, kto je ním vo svojom srdci a skutočnou obriezkou je zmena srdca, ktorú môže spôsobiť iba Boží Duch, a nie dodržiavanie Zákona. Taký človek si získa chválu nie od ľudí, ale od Boha. ");
INSERT INTO slk_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Je teda nejaká prednosť byť Židom? Má obriezka nejaký význam? ");
INSERT INTO slk_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Áno, v každom prípade má! V prvom rade ten, že Židom zveril Boh svoje slová. ");
INSERT INTO slk_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","A čo keď niektorí z nich neuverili? Myslíte si, že ich nevera ukončí Božiu vernosť? ");
INSERT INTO slk_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Určite nie! Nech sa ukáže, že Boh je dôveryhodný a každý človek klamár. Ako je napísané: „Aby sa ukázalo, že si spravodlivý a vo svojich súdoch si nestranný.“ ");
INSERT INTO slk_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Niekto však môže namietnuť: „Ak naša nespravodlivosť ukazuje Božiu spravodlivosť, nie je vari Boh nespravodlivý, keď nás stíha svojím hnevom?“ (Hovorím teraz tak, ako rozmýšľa človek.) ");
INSERT INTO slk_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Určite nie! Ak Boh nie je spravodlivý, ako by potom mohol súdiť svet? ");
INSERT INTO slk_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Veď ak moja neprávosť spôsobila, že sa odhalila Božia dôveryhodnosť a vyzdvihla sa Božia sláva, prečo by som mal byť naďalej považovaný za hriešnika? ");
INSERT INTO slk_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Potom by sme mohli povedať (ako nám to aj niektorí podsúvajú, že vraj tvrdíme): „Konajme zlo, aby mohlo prísť dobro.“ Takí hriešnici budú spravodlivo odsúdení. ");
INSERT INTO slk_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Takže ako? Sme ako Židia vo výhode? Vôbec nie! Veď práve sme Židov i pohanov usvedčili, že nad nimi vládne hriech. ");
INSERT INTO slk_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ako hovorí Písmo: „Na svete niet spravodlivého, niet ani jedného. ");
INSERT INTO slk_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Niet rozumného, kto by Boha hľadal. ");
INSERT INTO slk_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Všetci zblúdili, oddali sa zvrátenosti. Niet nikoho, kto by dobro konal, niet ani jedného. ");
INSERT INTO slk_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Z hrdla im páchne ako z otvoreného hrobu, jazykom svojím rozširujú lesť, hadí jed majú na perách. ");
INSERT INTO slk_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ich ústa sú plné kliatby a horkosti. ");
INSERT INTO slk_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ich nohy sa náhlia preliať krv, ");
INSERT INTO slk_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kam sa len pohnú, zanechajú spúšť a biedu, ");
INSERT INTO slk_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","nevedia, čo je to pokoj. ");
INSERT INTO slk_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nevedia, čo je to mať bázeň pred Bohom.“ ");
INSERT INTO slk_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Vieme, že všetko, čo Zákon hovorí, hovorí proti tým, čo sú pod jeho vplyvom. Umlčí každé ústa a celý svet usvedčí pred Bohom z viny. ");
INSERT INTO slk_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Veď nikto nebude v Božích očiach ospravedlnený konaním toho, čo požaduje Zákon. Prostredníctvom Zákona totiž len poznávame vlastnú hriešnosť. ");
INSERT INTO slk_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Teraz nám však Boh ukázal inú cestu, ako získať jeho spravodlivosť. Hoci ju nie je možné dosiahnuť prostredníctvom zákona, hovorili o nej už Mojžiš i proroci. ");
INSERT INTO slk_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Je to spravodlivosť od Boha, ktorá je pre všetkých veriacich prostredníctvom viery v Ježiša Krista. V jednom sú si totiž všetci ľudia rovní: ");
INSERT INTO slk_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","všetci ľudia zhrešili a nikto neodráža slávny Boží charakter. ");
INSERT INTO slk_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Teraz sú však považovaní za spravodlivých zadarmo, jeho milosťou, prostredníctvom vykúpenia, ktoré uskutočnil Ježiš Kristus. ");
INSERT INTO slk_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Boh poslal svojho Syna, aby sa svojou vlastnou smrťou stal obeťou zmierenia pre tých, ktorí veria. Tak Boh ukázal svoju spravodlivosť, keď už predtým s nekonečnou zhovievavosťou prehliadal hriechy ľudí. ");
INSERT INTO slk_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Teraz však Boh dokázal svoju spravodlivosť (tým, že hriechy vložil na Ježiša Krista). Takto ukázal, že je spravodlivý a že ospravedlňuje toho, kto vierou prijíma to, čo vykonal Ježiš. ");
INSERT INTO slk_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","A to sa človek nemá čím pochváliť? Nie! Ani tým, že dodržiava Zákon? Nie, pretože človek je ospravedlnený len prostredníctvom svojej viery. ");
INSERT INTO slk_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","A tak je isté, že sme ospravedlnení prostredníctvom viery, a nie dobrými skutky, ktoré konáme. ");
INSERT INTO slk_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Je Boh len Bohom Židov? Vari nie je aj Bohom pohanov? Určite je! ");
INSERT INTO slk_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Boh je iba jeden a bez rozdielu ospravedlní Židov i pohanov na základe ich viery. ");
INSERT INTO slk_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Takže vierou zbavujeme Zákon platnosti? Určite nie! Naopak, platnosť zákona tým potvrdzujeme. ");
INSERT INTO slk_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Aká bola Abrahámova skúsenosť? Čo o ňom môžeme povedať ako o našom praotcovi? ");
INSERT INTO slk_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Keby Abrahám dosiahol spravodlivosť na základe svojich skutkov, možno by sa v očiach ľudí mal čím pochváliť, ale nie pred Bohom. ");
INSERT INTO slk_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Veď Písmo hovorí: „Abrahám Bohu dôveroval a Boh ho preto považoval za spravodlivého.“ ");
INSERT INTO slk_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ak niekto koná nejakú prácu, svoju mzdu nedostáva ako dar, ale ako niečo, na čo má nárok. ");
INSERT INTO slk_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Tomu však, kto sa neusiluje dosiahnuť spravodlivosť skutkami, ale dôveruje Bohu, tomu sa jeho viera počíta za spravodlivosť. To je spôsob, akým Boh ospravedlňuje bezbožných. ");
INSERT INTO slk_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","O tom hovorí aj kráľ Dávid, ktorý nazýva šťastným toho človeka, ktorého Boh ospravedlnil bez jeho vlastnej zásluhy: ");
INSERT INTO slk_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Šťastní sú tí, ktorým Boh odpustil previnenia a ktorých hriechy prikryl. ");
INSERT INTO slk_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Šťastný je človek, ktorému Boh nepočíta hriechy!“ ");
INSERT INTO slk_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Vzťahuje sa toto zasľúbenie iba na tých, ktorí sa podrobili obradu obriezky, alebo aj na ostatných? O Abrahámovi sme predsa povedali, že ho Boh považoval za spravodlivého, lebo mu Abrahám uveril. ");
INSERT INTO slk_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kedy sa to stalo? Po jeho obrezaní, alebo ešte predtým? Áno, bolo to ešte predtým, ako sa dal obrezať. ");
INSERT INTO slk_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Znamenie obriezky prijal ako spečatenie svojho ospravedlnenia na základe viery. Ospravedlnený však bol už pred svojím obrezaním. Tak sa stal Abrahám praotcom tých, čo síce neboli obrezaní, ale ktorých Boh pre ich vieru považuje za spravodlivých. ");
INSERT INTO slk_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Zároveň je aj predchodcom tých, ktorí sú nielen obrezaní, ale podobne ako on žijú životom viery, tak ako Abrahám pred svojím obrezaním. ");
INSERT INTO slk_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahámovi a jeho potomkom zasľúbil Boh slávnu budúcnosť nie preto, že dodržiavali prikázania zákona, ale preto, že ho Boh na základe jeho viery považoval za spravodlivého. ");
INSERT INTO slk_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ak by sa dedičmi Božích zasľúbení stali tí, ktorí sa spoliehajú na zákon, viera by bola zbytočná a Božie zasľúbenie dané Abrahámovi by stratilo zmysel. ");
INSERT INTO slk_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Zákon so sebou prináša Boží hnev a naopak: kde nie je zákon, tam nie je ani jeho prestúpenie. ");
INSERT INTO slk_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Toto zasľúbenie je založené na viere, aby bolo jasné, že je darom Božej milosti. Takto je isté, že zasľúbenie platilo pre všetkých Abrahámových potomkov; nielen tých, čo stavajú na Zákone, ale aj tých, ktorých s Abrahámom spája rovnaká viera. On je otcom všetkých nás. ");
INSERT INTO slk_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Tak treba rozumieť Písmu, ktoré hovorí: „Určil som ťa za otca mnohých národov.“ V Božích očiach je preto Abrahám naším otcom. Abrahám totiž uveril Bohu, ktorý oživuje mŕtvych, o tom, čo ešte nie je, hovorí, akoby sa to už stalo. ");
INSERT INTO slk_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abrahám napriek beznádeji uveril, že sa stane otcom mnohých národov podľa slov: „Také početné bude tvoje potomstvo.“ ");
INSERT INTO slk_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Neochabol vo viere ani vtedy, keď si pomyslel na svoje neduživé telo, veď mal bezmála sto rokov, a jeho žena Sára takisto prekročila vek, keď mohla mať deti. ");
INSERT INTO slk_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abrahám o Božom zasľúbení nepochyboval. Uveril Bohu, jeho viera bola čoraz pevnejšia a tým vzdal chválu Bohu. ");
INSERT INTO slk_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Bol neochvejne presvedčený, že Boh má moc vykonať všetko, čo zasľúbil. ");
INSERT INTO slk_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A práve pre takúto vieru Boh označil Abraháma za spravodlivého. ");
INSERT INTO slk_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Slová „bolo mu to počítané za spravodlivosť“ nie sú zaznamenané len kvôli Abrahámovi, ");
INSERT INTO slk_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ale aj kvôli nám. Aj nás ospravedlní, ak uveríme v toho, ktorý vzkriesil z mŕtvych Ježiša, nášho Pána. ");
INSERT INTO slk_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","On bol vydaný za naše hriechy a vstal z hrobu, aby nás ospravedlnil. ");
INSERT INTO slk_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Prostredníctvom viery sme teda ospravedlnení, a tak máme vo vzťahu s Bohom pokoj, ktorý nám daroval náš Pán Ježiš Kristus. ");
INSERT INTO slk_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","On nám umožnil, aby sme vierou získali prístup k Božej milosti, ktorú teraz prežívame a radujeme sa z nádeje na Božiu slávu. ");
INSERT INTO slk_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Radujeme sa však nielen z nádeje, ale aj z utrpenia. Vieme totiž, že utrpenie prináša trpezlivosť, ");
INSERT INTO slk_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","trpezlivosť prináša zrelosť a tá vedie k nádeji. ");
INSERT INTO slk_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A táto nádej nás nikdy nesklame, lebo Boh nám prostredníctvom svojho Ducha dal poznať, ako veľmi nás miluje. ");
INSERT INTO slk_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Veď pre našu bezmocnosť Kristus zomrel v určený čas za hriešnych. ");
INSERT INTO slk_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Málokto by bol ochotný obetovať svoj život aj za najušľachtilejšieho človeka, i keď niekto by sa možno predsa len našiel. ");
INSERT INTO slk_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nám však Boh dokázal svoju lásku práve tým, že Kristus za nás zomrel, keď sme boli hriešnikmi. ");
INSERT INTO slk_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Tým skôr teraz, keď nás Kristus svojou obeťou ospravedlnil, budeme prostredníctvom neho zachránení od konečného trestu. ");
INSERT INTO slk_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ak nás Kristova smrť zmierila s Bohom už vtedy, keď nás delilo nepriateľstvo, tým skôr nás teraz, keď sme už zmierení, zachráni Kristov život. ");
INSERT INTO slk_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","A nielen to, môžeme sa radovať aj zo vzťahu s Bohom, s ktorým nás zmieril náš Pán, Ježiš Kristus. ");
INSERT INTO slk_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Cez jedného človeka, cez Adama, vstúpil na svet hriech aj dôsledok hriechu – smrť. A pretože všetci zhrešili, smrť zasiahla každého človeka. ");
INSERT INTO slk_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Už pred vydaním Zákona ľudia neposlúchali Boha, ale nemohli byť odsúdení podľa Zákona, lebo ešte nebol vydaný. ");
INSERT INTO slk_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Výsledkom neposlušnosti ľudí, ktorí žili v čase od Adama do Mojžiša, bola však takisto smrť, i keď nešlo o to isté previnenie ako Adamovo. Aký protiklad je medzi Adamom a Kristom, ktorý ešte len mal prísť! ");
INSERT INTO slk_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","A aký rozdiel je medzi ľudským hriechom a Božou milosťou! Veď tento jediný človek, Adam, priniesol smrť všetkým pre svoj hriech. No jediný človek, Ježiš Kristus, priniesol dar Božej milosti pre všetkých ľudí. ");
INSERT INTO slk_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","S darom milosti je to inak ako s následkami Adamovho hriechu. Kým súd nad jediným hriechom priniesol odsúdenie, dar milosti aj napriek mnohým hriechom prináša ospravedlnenie. ");
INSERT INTO slk_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A ako pre hriech jediného človeka, Adama, ovládla smrť celý svet, o čo skôr prostredníctvom Ježiša Krista budú vládnuť v živote večnom tí, ktorým on jediný vydobyl milosť a odpustenie. ");
INSERT INTO slk_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Áno, tak ako hriech jedného priniesol odsúdenie pre všetkých, tak Kristova spravodlivosť zmierila ľudí s Bohom a dovoľuje im žiť. ");
INSERT INTO slk_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ako sa neposlušnosťou jedného človeka stali všetci hriešnikmi, tak im poslušnosť toho jedného priniesla ospravedlnenie. ");
INSERT INTO slk_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Boh dal ľuďom svoj Zákon, aby sa odhalila veľkosť hriechu. Ale čím väčší sa hriech ukazuje, tým viac sa zviditeľňuje aj Božia milosť. ");
INSERT INTO slk_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Predtým všetkých ľudí ovládal hriech, ktorý ich hnal do smrti, ale teraz vládne Božia milosť a prináša večný život prostredníctvom Ježiša Krista, nášho Pána. ");
INSERT INTO slk_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Čo z toho pre nás vyplýva? Budeme ďalej hrešiť, aby Boh mohol ešte viac prejaviť svoju milosť? ");
INSERT INTO slk_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Určite nie! Veď vo vzťahu k hriechu sme sa stali mŕtvi. Ako by sme teda mohli naďalej žiť v hriechu? ");
INSERT INTO slk_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Alebo azda neviete, že každý, kto sa dal pokrstiť v Ježiša Krista, spolu s ním aj zomrel? ");
INSERT INTO slk_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Prostredníctvom krstu sme teda boli pochovaní a zomreli sme spolu s Kristom, aby tak, ako Kristus bol vzkriesený slávnou mocou svojho Otca, aj my sme žili novým životom. ");
INSERT INTO slk_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Keďže sme v krste zomreli podobne ako on, budeme, podobne ako on, aj vzkriesení. ");
INSERT INTO slk_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Vieme predsa, že naše staré hriešne „ja“ bolo ukrižované spolu s ním. Naša hriešna podstata tým bola vyslobodená z nadvlády zla, aby sme už ďalej nemuseli byť otrokmi hriechu. ");
INSERT INTO slk_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Veď ten, kto zomrel, je vyslobodený z moci hriechu. ");
INSERT INTO slk_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Keď sme teda svoje „ja“ nechali s Kristom zomrieť, veríme, že budeme spolu s ním aj žiť. ");
INSERT INTO slk_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Vieme, že Kristus vstal z mŕtvych a už nikdy nezomrie. Smrť už nemá nad ním nijakú moc. ");
INSERT INTO slk_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","On zomrel, aby zlomil moc hriechu, a teraz žije v neporušiteľnom spojení s Bohom. ");
INSERT INTO slk_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","A to isté platí aj o vás: ste mŕtvi hriechu, ale živí pre Boha prostredníctvom vašej viery v Ježiša Krista, nášho Pána. ");
INSERT INTO slk_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nedovoľte, aby vaše smrteľné telo ovládal hriech a aby ste podliehali jeho zlým žiadostiam. ");
INSERT INTO slk_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nevydávajte samých seba za nástroje neprávosti, ale oddajte sa úplne Bohu. Veď vás Boh vyviedol zo smrti do života, a preto buďte nástrojom spravodlivosti v Božích rukách. ");
INSERT INTO slk_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hriech stratil nad vami svoju moc, preto už nepodliehate zákonu, ale žijete z Božej milosti. ");
INSERT INTO slk_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Znamená to azda, že môžeme pokojne ďalej hrešiť, keďže nad nami nepanuje Zákon, ale Božia milosť? Určite nie! ");
INSERT INTO slk_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Veď viete, že komu sa dávate do služieb, ten sa stane vaším pánom. Buď sa teda stanete otrokmi hriechu a ten vás privedie k večnej smrti, alebo sa rozhodnete poslúchať Boha, a tým získate spravodlivosť. ");
INSERT INTO slk_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Vďaka Bohu, že hoci ste kedysi boli otrokmi hriechu, teraz ste sa celým srdcom priklonili k učeniu, ktoré ste prijali. ");
INSERT INTO slk_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","A tak ste boli oslobodení od hriechu a dali ste sa do služieb spravodlivosti. ");
INSERT INTO slk_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Tento príklad používam, aby ste to lepšie pochopili. Ako ste predtým otročili všelijakým hriechom, nečistote a bezbožnosti, tak sa teraz dajte do služby všetkému, čo je správne a sväté. ");
INSERT INTO slk_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kým ste boli otrokmi hriechu, nestarali ste sa priveľmi o to, čo je dobré. ");
INSERT INTO slk_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","A čo vám to prinieslo? Len hanbu. Veď za to všetko ste si zaslúžili iba smrť. ");
INSERT INTO slk_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ale teraz ste slobodní od moci hriechu a slúžite Bohu. Odmenou za to je svätosť a nakoniec večný život. ");
INSERT INTO slk_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Lebo mzdou hriechu je smrť, ale darom Božej milosti je večný život, v spoločenstve s Ježišom Kristom, naším Pánom. ");
INSERT INTO slk_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Milí bratia, vy sa predsa dobre vyznáte v zákone, a tak viete, že je platný len dovtedy, kým človek žije. ");
INSERT INTO slk_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Vydatá žena je zákonom viazaná k žijúcemu manželovi. Ak však jej muž zomrie, je oslobodená spod zákona, ktorý ju viazal k jej mužovi. ");
INSERT INTO slk_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Pokiaľ by sa však za manželovho života oddala inému mužovi, stala by sa cudzoložnicou. Po manželovej smrti je však podľa zákona slobodnou ženou a nik ju nebude viniť z cudzoložstva, ak by sa znova vydala. ");
INSERT INTO slk_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","A podobne je to aj s vami, bratia moji, Kristovou smrťou ste sa stali pre zákon mŕtvymi, aby ste mohli patriť inému Pánovi; tomu, ktorý bol vzkriesený, a žili životom, ktorý sa Bohu páči. ");
INSERT INTO slk_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Keď sme ešte žili podľa svojej hriešnej prirodzenosti, ovládali nás hriešne žiadosti po tom, čo zákon zakazuje a robili sme to, čo vedie do záhuby. ");
INSERT INTO slk_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ale teraz, keď sme zomreli tomu, čím sme boli spútaní, sme oslobodení od zákona a môžeme slúžiť Bohu celkom novým spôsobom, ako nás vedie Svätý Duch, a nie podľa starej litery zákona. ");
INSERT INTO slk_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Chceme tým azda povedať, že Božie zákony sú zlé? Určite nie! Veď bez Božích prikázaní by som ani nevedel, čo hriech je a čo nie. Keby Božie prikázanie nehovorilo: „Nepožiadaš!“, ani by som nevedel, že žiadostivosť je zlá. ");
INSERT INTO slk_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ale hriech zneužil zákon, aby vo mne podnietil všetky druhy žiadosti. Ak by nebolo zákona, hriech by túto moc nemal. ");
INSERT INTO slk_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kedysi som žil bez zákona, ale s jeho príchodom do môjho života hriech ožil a ja som sa stal mŕtvym. ");
INSERT INTO slk_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ukázalo sa, že prikázanie, ktoré mi malo dať život, prinieslo mi smrť. ");
INSERT INTO slk_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Hriech využil prikázanie, aby ma oklamal, a tak namiesto života mi priniesol smrť. ");
INSERT INTO slk_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Zákon sa však sám osebe zhoduje s Božou vôľou; každé prikázanie je sväté, správne a dobré. ");
INSERT INTO slk_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Mohlo byť teda to, čo je dobré, príčinou mojej smrti? Určite nie! Ale tým, že hriech využil dobro, aby mi prinieslo smrť, prejavil sa ako hriech, a práve zákon ukázal celú hĺbku jeho hriešnosti. ");
INSERT INTO slk_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Vieme, že zákon bol inšpirovaný Božím Duchom, ale ja som len slabý človek, ktorý je otrokom hriechu. ");
INSERT INTO slk_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sám sebe som záhadou, lebo nerobím to, čo chcem, ale to, čo sa mi protiví. ");
INSERT INTO slk_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ak však to, čo robím, je proti mojej vôli, potom uznávam, že Zákon je dobrý. ");
INSERT INTO slk_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","To vlastne znamená, že zlo nekonám ja, ale hriech, ktorý je vo mne. ");
INSERT INTO slk_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Viem, že vo mne, v mojej hriešnej prirodzenosti, neprebýva nič dobré. Ja by som síce chcel robiť to, čo je dobré, ale nedokážem to. ");
INSERT INTO slk_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Veď nekonám dobro, ktoré chcem, ale zlo, ktoré nechcem. ");
INSERT INTO slk_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ak teda robím to, čo nechcem, nerobím to už vlastne ja, ale hriech, ktorý je mojou súčasťou. ");
INSERT INTO slk_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","A tak objavujem v sebe takúto zákonitosť: Keď chcem konať dobro, hriech je to prvé, čo sa vo mne prejaví. ");
INSERT INTO slk_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Vo svojej najvnútornejšej bytosti nadšene súhlasím s Božím zákonom, ");
INSERT INTO slk_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","a predsa konám podľa iného zákona, ktorý je vo mne. Tento zápas medzi mojím dobrým predsavzatím a hriešnym konaním dokazuje, že som otrokom hriechu. ");
INSERT INTO slk_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ja nešťastný človek! Je niekto, kto ma vyslobodí z tohto tela, ktoré ma odsudzuje na smrť? ");
INSERT INTO slk_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Vďaka Bohu, áno! Náš Pán Ježiš Kristus ma vyslobodil. Vo svojej mysli teda slúžim Božiemu zákonu, ale v konaní som stále otrokom hriechu. ");
INSERT INTO slk_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","A tak pre tých, ktorí veria v Krista Ježiša, už nejestvuje žiadne odsúdenie. ");
INSERT INTO slk_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Pre nich neplatí zákon hriechu a smrti, lebo oživujúci Duch ich prostredníctvom Ježiša Krista spod tohto zákona vyslobodil. ");
INSERT INTO slk_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Boh vykonal to, čo pre ľudskú hriešnosť nemohol vykonať zákon: poslal vlastného Syna v ľudskom tele, ako má hriešny človek, aby zlomil vládu hriechu nad nami tým, že sa sám obetoval za naše hriechy. ");
INSERT INTO slk_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","A tak Kristovou zásluhou môže byť na nás vykonané to, čo požaduje zákon, keď nekonáme podľa našej ľudskej prirodzenosti, ale dáme sa viesť Duchom. ");
INSERT INTO slk_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tí, ktorí žijú podľa toho, čo sami chcú, majú svoje mysle naplnené hriešnymi túžbami. Tí však, ktorí sa dajú viesť Božím Duchom, majú svoje mysle naplnené túžbami Ducha. ");
INSERT INTO slk_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Telesné zmýšľanie prináša smrť, ale zmýšľanie vedené Božím Duchom prináša život a pokoj. ");
INSERT INTO slk_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Človek, ktorý myslí iba na seba, žije v nepriateľstve voči Bohu; nechce sa totiž, ba ani nemôže, podvoliť jeho prikázaniam. ");
INSERT INTO slk_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Je ovládaný svojou hriešnou prirodzenosťou, a preto sa Bohu nemôže páčiť. ");
INSERT INTO slk_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ak však vo vás prebýva Boží Duch, nežijete zo svojej vlastnej sily, ale z moci Ducha. Kto nemá Ducha Kristovho, nepatrí Kristovi. ");
INSERT INTO slk_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ak je vo vás Kristus, vaše telo je síce mŕtve a pre hriech podlieha smrti, ale Duch dáva život, lebo ste ospravedlnení. ");
INSERT INTO slk_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ak je vo vás Duch toho, ktorý vzkriesil Ježiša z mŕtvych, potom ten, ktorý ho vzkriesil, oživí aj vaše smrteľné telo svojím Duchom, ktorý je vo vás. ");
INSERT INTO slk_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Preto, milí bratia, nemáme žiadny dlh voči našej starej prirodzenosti, aby sme podľa nej žili. ");
INSERT INTO slk_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Lebo naše žiadosti nás ženú do smrti. Ale ak mocou Ducha umŕtvujete zlé skutky, budete žiť. ");
INSERT INTO slk_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Všetci, ktorí sa dajú viesť Božím Duchom, sú Božími deťmi. ");
INSERT INTO slk_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Od Boha sme totiž neprijali Ducha, ktorý by z nás robil ustráchaných otrokov, ale Ducha, ktorý z nás robí členov Božej rodiny a dáva nám právo volať Boha: „Otec! Otecko!“. ");
INSERT INTO slk_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Sám Boží Duch nám dáva vnútornú istotu, že sme Božie deti. ");
INSERT INTO slk_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","A ako deti sme Božími dedičmi a Kristovými spoludedičmi. A ak teraz trpíme s Kristom, budeme raz mať podiel aj na jeho sláve. ");
INSERT INTO slk_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Som totiž presvedčený, že terajšie utrpenie sa nedá ani porovnať so slávou, ktorou nás Boh raz zahrnie. ");
INSERT INTO slk_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Veď celé stvorenstvo túžobne očakáva zjavenie Božích synov. ");
INSERT INTO slk_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Celé stvorenstvo je podrobené pominuteľnosti, no nie dobrovoľne, ale z vôle toho, ktorý si ho podrobil. Je tu však nádej ");
INSERT INTO slk_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","na vyslobodenie všetkého stvorenstva z otroctva skazy do slobody a slávy Božích detí. ");
INSERT INTO slk_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Veď vidíme, že všetko stvorenstvo až doteraz vzdychá a stoná ako v pôrodných bolestiach. ");
INSERT INTO slk_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ba aj my, ktorým Boh ako prísľub budúcej slávy už dal svojho Ducha, túžobne očakávame, kedy nás ako svoje deti prijme k sebe a naše telo oslobodí od všetkej porušiteľnosti. ");
INSERT INTO slk_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Zachránení sme nádejou. Nádej je čakaním na to, čo ešte nemáme. Ak to, na čo čakáme, vidíme pred sebou, nepotrebujeme už dúfať. ");
INSERT INTO slk_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","My však máme nádej a trpezlivo očakávame to, čo ešte nevidíme. ");
INSERT INTO slk_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Podobne k nám prichádza aj Svätý Duch, aby nám pomáhal v našej slabosti. Veď ani nevieme, ako a za čo by sme sa mali modliť. Vtedy sa za nás prihovára Svätý Duch so stonmi, ktoré sa nedajú vyjadriť slovami. ");
INSERT INTO slk_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","A Boh, ktorý vidí do srdca človeka, vie, že Svätý Duch prosí za nás o to, čo sa zhoduje s jeho vôľou. ");
INSERT INTO slk_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Jedno vieme určite: Boh koná tak, aby všetko, čokoľvek sa deje, slúžilo na dobré tým, ktorí ho milujú a ktorých si povolal podľa svojho odvekého plánu. ");
INSERT INTO slk_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Tých, o ktorých Boh vopred vedel, tých aj vopred určil, aby sa stali podobní jeho Synovi a on bol tak prvý medzi mnohými bratmi. ");
INSERT INTO slk_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","A ktorých Boh takto určil, tých aj povolal, ospravedlnil ich a dal im svoju slávu. ");
INSERT INTO slk_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Môžeme si želať ešte niečo viac? Keď je Boh s nami, kto môže byť proti nám? ");
INSERT INTO slk_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Boh, ktorý neušetril svojho vlastného Syna, ale dal ho za nás všetkých, vari nám spolu s ním nedaroval všetko? ");
INSERT INTO slk_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kto by sa odvážil obžalovať tých, ktorých si Boh povolal? Veď sám Boh nás zbavil všetkej viny. ");
INSERT INTO slk_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kto by sa odvážil nás odsúdiť? Veď Kristus za nás nielen zomrel, ale aj vstal z mŕtvych a teraz je po Božej pravici a obhajuje nás. ");
INSERT INTO slk_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Čo by nás teda mohlo odlúčiť od Krista a jeho lásky? Utrpenie alebo strach? Prenasledovanie? Hlad? Bieda? Nebezpečenstvo alebo sama smrť? ");
INSERT INTO slk_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Je napísané: „Denne nás pre teba vydávajú na smrť, sme ako ovce na zabitie.“ ");
INSERT INTO slk_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","A predsa nad tým všetkým víťazíme v moci Ježiša Krista, ktorý nás tak veľmi miluje. ");
INSERT INTO slk_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Som presvedčený, že ani smrť, ani život, ani anjeli, ani démonské sily, ani prítomnosť, ani budúcnosť, ani nijaká moc, ");
INSERT INTO slk_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nič čo je na nebi, nič čo je na zemi, ani čokoľvek iné v celom stvorení nás nemôže odlúčiť od Božej lásky, ktorú Boh zjavil v Ježišovi Kristovi, našom Pánovi. ");
INSERT INTO slk_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Hovorím pravdu v Kristovi. Neklamem a Duch Svätý mi to cez moje svedomie dosvedčuje: ");
INSERT INTO slk_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mám veľký zármutok a srdce ma neprestajne bolí. ");
INSERT INTO slk_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Chcel by som byť totiž radšej sám prekliaty a odlúčený od Krista, než aby to postihlo mojich bratov, ľud, z ktorého pochádzam. ");
INSERT INTO slk_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Sú to predsa Izraeliti! Ich si Boh osvojil za synov, im patrí Božia sláva, s nimi uzavrel zmluvu, im dal svoj Zákon, oni mali tú prednosť slúžiť mu a im boli dané zasľúbenia. ");
INSERT INTO slk_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Oni mali slávnych praotcov a z ich národa pochádza aj Kristus, Vládca všetkého, Boh požehnaný naveky! Amen. ");
INSERT INTO slk_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Božie slovo však neprestalo platiť, lebo nie všetci tí, čo sú z Izraela, sú aj Božím ľudom. ");
INSERT INTO slk_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ani deťmi nie sú len preto, že sú Abrahámovými potomkami. Veď Boh povedal: „Podľa Izáka sa bude volať tvoje potomstvo.“ ");
INSERT INTO slk_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","To znamená, že nie všetci potomkovia Abraháma sú Božími deťmi, ale iba tí, čo sa narodili z Božieho sľubu. ");
INSERT INTO slk_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","A Božie zasľúbenie znelo: „V určený čas prídem a Sára bude mať syna.“ ");
INSERT INTO slk_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Podobne to bolo aj s Rebekou, ktorá mala obe deti s jedným mužom – naším praotcom Izákom. ");
INSERT INTO slk_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ešte skôr, ako sa narodili – a teda než mohli urobiť niečo dobré či zlé (aby sa potvrdilo, že Boh je zvrchovaný vo svojom pláne, deje sa jeho vôľa ");
INSERT INTO slk_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","a je to on, kto povoláva) –, oznámil Rebeke: „Starší zo synov bude slúžiť mladšiemu.“ ");
INSERT INTO slk_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","V Písme sa o tom hovorí: „Miloval som Jákoba, ale Ezaua som nenávidel.“ ");
INSERT INTO slk_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Znamená to azda, že Boh je nespravodlivý? Určite nie! ");
INSERT INTO slk_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Mojžišovi predsa povedal: „Zmilujem sa, nad kým sa zmilujem a zľutujem sa, nad kým sa zľutujem.“ ");
INSERT INTO slk_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nezáleží teda na tom, či niekto stojí o Božiu priazeň, alebo sa o ňu tvrdo usiluje, ale na Božej milosti. ");
INSERT INTO slk_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Písmo napríklad hovorí o egyptskom faraónovi: „Zachoval som ťa preto, aby som na tebe ukázal svoju moc a aby sa hlásalo moje meno v celej krajine.“ ");
INSERT INTO slk_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Boh sa teda zmiluje, nad kým chce, a komu chce, tomu milosť odoprie. ");
INSERT INTO slk_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Možno niekto namietne: Prečo nás teda Boh karhá? Môže sa azda niekto vzoprieť jeho vôli? ");
INSERT INTO slk_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ale, človeče, kto si, že si trúfaš hádať sa s Bohom? Hovorí azda dielo svojmu tvorcovi: Prečo si ma urobil práve takto? ");
INSERT INTO slk_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Vari nemá hrnčiar právo vyrobiť z hliny čo sám uzná za vhodné – či už nádobu na slávnostný účel alebo nádobu obyčajnú? ");
INSERT INTO slk_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","A to isté možno povedať o Božom konaní. Rozhodol sa zjaviť svoj hnev a odhaliť svoju moc. Napriek tomu s trpezlivosťou znášal tých, ktorí mali okúsiť jeho hnev, lebo si zaslúžili záhubu. ");
INSERT INTO slk_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","A podobne sa rozhodol prejaviť svoju veľkú slávu na tých, ktorým prejavil svoje milosrdenstvo, aby prijali jeho slávu. ");
INSERT INTO slk_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Povolal nás nielen zo Židov, ale aj z pohanských národov, ");
INSERT INTO slk_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ako to hovorí už prostredníctvom Ozeáša: „Ľud, ktorý nie je môj, povolám za svoj ľud a memilovanú nazvem milovanou. ");
INSERT INTO slk_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","A stane sa, že tým, ktorým sa hovorilo: ‚Vy nie ste môj ľud‘, budú nazvaní ‚synmi živého Boha.‘ “ ");
INSERT INTO slk_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","O Izraelovi hovorí Izaiáš: „Aj keby bolo synov Izraela ako morského piesku, len ostatok bude zachránený. ");
INSERT INTO slk_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Lebo Hospodin vykoná svoj súd na zemi rýchlo a úplne.“ ");
INSERT INTO slk_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","A ešte predtým Izaiáš predpovedal: „Keby nám Hospodin zástupov nebol ponechal potomstvo, boli by sme spustli ako Sodoma a podobali by sme sa Gomore.“ ");
INSERT INTO slk_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Čo teda povieme nakoniec? To, že pohania, ktorí nehľadali správny vzťah s Bohom, spravodlivosť dosiahli, a to spravodlivosť prostredníctvom viery; ");
INSERT INTO slk_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ale Izrael, vyvolený národ, ktorý sa usiloval dosiahnuť správny vzťah s Bohom zachovávaním Zákona, spravodlivosť nedosiahol. ");
INSERT INTO slk_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Prečo? Lebo sa usiloval získať spravodlivosť svojimi skutkami, ale nie vierou. Preto narazili na „kameň úrazu“. ");
INSERT INTO slk_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Ako je napísané: „Hľa, kladiem na Sion kameň úrazu a skalu pohoršenia, ale kto v neho verí, nebude zahanbený.“ ");
INSERT INTO slk_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Milí bratia, z celého srdca túžim a neprestajne prosím Boha, aby aj môj národ bol zachránený. ");
INSERT INTO slk_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Lebo môžem dosvedčiť, že nadšene a horlivo chce slúžiť Bohu, ale chýba mu správne poznanie. ");
INSERT INTO slk_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nezaujíma ich spôsob, akým Boh ľudí ospravedlňuje. Namiesto toho si chcú vlastným úsilím získať ospravedlnenie v Božích očiach, preto Božiu spravodlivosť neprijali. ");
INSERT INTO slk_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kristus je naplnením zákona, takže ospravedlnený je každý, kto verí. ");
INSERT INTO slk_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ale ak by predsa chcel niekto obstáť pred Bohom plnením zákona, na toho sa vzťahujú Mojžišove slová: „Človek, ktorý plní moje ustanovenia, bude žiť.“ ");
INSERT INTO slk_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ale kto našiel cestu k Bohu vierou v Krista, ten môže povedať: „Nezaoberaj sa myšlienkou, kto vstúpi do neba?“, aby Krista priviedol dolu, ");
INSERT INTO slk_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ani nehovor: „Kto zostúpi do hlbín?“, aby Krista vyviedol z ríše mŕtvych. ");
INSERT INTO slk_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kto verí, ten povie: „Blízko teba je slovo, je v tvojich ústach a v tvojom srdci.“ Je to slovo o viere, ktorého zvestujeme. ");
INSERT INTO slk_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Lebo ak ústami vyznáš Ježiša ako svojho Pána a ak celým srdcom uveríš, že Boh ho vzkriesil z mŕtvych, budeš zachránený. ");
INSERT INTO slk_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Lebo ak uveríme, získame ospravedlnenie pred Bohom, ak svoju vieru vyznáme, sme zachránení. ");
INSERT INTO slk_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Boh už ústami proroka Izaiáša povedal: „Kto verí v neho, nebude zahanbený.“ ");
INSERT INTO slk_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","A tu nie je nijaký rozdiel medzi Židmi a pohanmi. Veď ten istý Pán je Pánom všetkých a zo svojho bohatstva štedro dáva všetkým, čo ho o to prosia. ");
INSERT INTO slk_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","„Lebo každý, kto vzýva meno Pánovo, bude zachránený,“ predpovedal už prorok Joel. ");
INSERT INTO slk_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ako však budú vzývať toho, v ktorého neuverili? A ako môžu uveriť, ak o ňom nepočuli? A ako počujú, keď im Božie slovo nikto nezvestoval? ");
INSERT INTO slk_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A ako budú zvestovať, ak ich nikto neposlal? Je to tak, ako hovorí Písmo: „Aký krásny je príchod tých, ktorí prinášajú radostnú správu o dobrých veciach.“ ");
INSERT INTO slk_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ale nie všetci radostnú správu prijali. Už Izaiáš povedal: „Pane, kto uveril našej zvesti?“ ");
INSERT INTO slk_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Človek teda môže uveriť na základe počutia radostnej zvesti o Kristovi. ");
INSERT INTO slk_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ale ako je to so Židmi? Azda Božie slovo nikdy nepočuli? Pravdaže počuli. Je napísané: „Ich hlas sa rozlieha po celej zemi a ich slová až na okraj sveta.“ ");
INSERT INTO slk_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Zostáva teda otázka: Nepochopil Izrael toto posolstvo? Veď už v Mojžišovi Boh hovorí: „Prebudím vo vás žiarlivosť voči tým, ktorí nie sú národom a popudím vás voči nerozumným národom.“ ");
INSERT INTO slk_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","A neskôr Izaiáš odvážne hovorí: „Dal som sa nájsť tým, ktorí ma nehľadali, ukázal som sa tým, ktorí sa na mňa nepýtali.“ ");
INSERT INTO slk_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","O Izraeli však hovorí: „Celý deň som vystieral ruky k národu neposlušnému a vzdorovitému.“ ");
INSERT INTO slk_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Pýtam sa teda: Zavrhol azda Boh svoj národ? Rozhodne nie! Veď aj ja som Izraelita, potomok Abrahámov z Benjamínovho kmeňa. ");
INSERT INTO slk_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Boh nezavrhol svoj ľud, o ktorom vedel už od počiatku. Veď viete, čo Písmo hovorí v časti o Eliášovi, keď sa ponosoval Bohu na Izrael: ");
INSERT INTO slk_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Pane, tvojich prorokov povraždili a tvoje oltáre zbúrali. Už som zostal len ja sám a teraz chcú zabiť aj mňa.“ ");
INSERT INTO slk_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","A čo mu na to odpovedá Boh? „Ponechal som si sedemtisíc verných, ktorí sa nesklonili na kolená pred Baálom.“ ");
INSERT INTO slk_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tak aj dnes je tu ostatok ľudu, ktorý si však Boh vyvolil zo svojej milosti. ");
INSERT INTO slk_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","A keďže z milosti, znamená to, že nie na základe dobrých skutkov, lebo milosť by viac nebola milosťou. ");
INSERT INTO slk_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Čo z toho vyplýva? Izraelský ľud nedosiahol to, o čo sa tak snaží. Dosiahol to len malý počet tých, ktorých si Boh vyvolil. Ostatní sa však voči Božiemu volaniu zatvrdili, ");
INSERT INTO slk_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ako je napísané: „Boh im dal ducha otupenosti. Majú síce oči, ale nevidia, majú uši, ale nepočujú. A tak je to až dodnes.“ ");
INSERT INTO slk_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dávid hovorí: „Obetný oltár nech sa im stane osídlom a pascou, do ktorej sa sami chytia a dostanú zaslúženú odplatu. ");
INSERT INTO slk_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Oči nech sa im zatmia, aby nevideli, a chrbát nech majú navždy zohnutý.“ ");
INSERT INTO slk_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Znovu sa pýtam: Potkli sa azda preto, aby padli úplne? Určite nie! Ich previnenie však umožnilo záchranu pohanov, a to potom prebudilo u Židov žiarlivosť. ");
INSERT INTO slk_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ak teda ich previnením svet získal a ich úpadok obohatil pohanov, o čo väčšie bohatstvo to prinesie, keď sa aj oni úplne obrátia k Bohu? ");
INSERT INTO slk_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Vám, ktorí ste z pohanských národov, by som chcel povedať ja, apoštol pohanov: Slávu svojej služby vidím v tom, ");
INSERT INTO slk_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","že azda vyvolám žiarlivosť u svojich pokrvných bratov a aspoň niektorých privediem k záchrane. ");
INSERT INTO slk_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ak to, že sa Boh od nich odvrátil, viedlo k zmiereniu sveta, čo iné bude znamenať ich prijatie? To akoby mŕtvi znova ožili! ");
INSERT INTO slk_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","S prvým chlebom, ktorý sa obetuje Bohu pri slávnosti prvej úrody, sa totiž posväcuje všetko cesto. A ak niekto zasvätí Bohu korene stromu, patria mu potom aj jeho vetvy. ");
INSERT INTO slk_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ale niektoré vetvy toho stromu boli odlomené. Na ich miesto si bol zaštepený ty ako konár planej olivy, takže berieš silu z koreňa ušľachtilej olivy. ");
INSERT INTO slk_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Nenamýšľaj si preto, že si čosi viac ako odlomené vetvy. Ak by si sa predsa len začal vyvyšovať, spomeň si, že koreň nesie teba, nie ty koreň. ");
INSERT INTO slk_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Mohol by si povedať: „Vetvy boli predsa vylomené, aby som ja mohol byť zaštepený na ich miesto.“ ");
INSERT INTO slk_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Dajme tomu. Boli vylomené, lebo neverili. A ty si na ich mieste len vďaka viere. Nebuď namyslený, ale radšej sa maj na pozore. ");
INSERT INTO slk_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Lebo ak Boh neušetril vetvu ušľachtilej olivy, tým skôr neušetrí teba. ");
INSERT INTO slk_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Pamätaj na Božiu dobrotu, ale aj na jeho prísnosť: prísnosť k tým, ktorí odpadli, a na dobrotu k tebe, ak sa budeš Božej dobroty aj naďalej pridŕžať, inak odtne aj teba. ");
INSERT INTO slk_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","A takisto Židia, ak sa odvrátia od svojej neviery, budú zaštepení naspäť. Veď Boh má moc to urobiť. ");
INSERT INTO slk_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Lebo ak Boh zaštepil vás, vetvy planej olivy, na ušľachtilý strom, čo sa nikdy nerobieva, o čo ochotnejšie zaštepí odlomené konáre na olivu, na ktorú pôvodne patrili. ");
INSERT INTO slk_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nechcel by som, milí bratia, aby pre vás zostalo tajomstvom, aké úmysly má Boh so židovským národom; nechcem vás v tom nechať vlastným predstavám. Časť Židov prepadla zatvrdeniu a bude to tak, kým do Božieho kráľovstva nevojdú všetci, ktorí budú zachránení z pohanov. ");
INSERT INTO slk_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","A takto bude zachránený celý Izrael, ako je napísané: „Z Jeruzalema príde Vysloboditeľ a odvráti bezbožnosť od Jákoba. ");
INSERT INTO slk_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Toto bude moja zmluva s nimi, keď ich zbavím vín.“ ");
INSERT INTO slk_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ako sa teda dívať na Židov? Pokiaľ ide o evanjelium, neprijali ho a stali sa tak Božími nepriateľmi, ale vás to priviedlo k Božiemu milosrdenstvu. Boh ich však stále miluje, lebo sú deťmi svojich predkov, ktorých si vyvolil. ");
INSERT INTO slk_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Keď Boh niečo daruje, neberie to späť, a ak si niekoho povolá, sám to neruší. ");
INSERT INTO slk_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Vy ste kedysi Boha odmietli, ale teraz sa vám dostalo Božie milosrdenstvo, keď ho odmietli Židia. ");
INSERT INTO slk_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","V podobnej situácii sú teraz oni. Postavili sa odmietavo k milosti, ktorú ste získali vy a teraz ju môžu získať aj oni. ");
INSERT INTO slk_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Lebo Boh všetkých – Židov aj pohanov – ponechal ich nevere, aby mohol všetkých obdariť svojou milosťou. ");
INSERT INTO slk_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Aké nesmierne je Božie bohatstvo, aká hlboká je jeho múdrosť a poznanie! Aké nevyspytateľné sú jeho rozhodnutia a nepredvídateľné jeho zámery! ");
INSERT INTO slk_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Veď kto môže pochopiť Božie myslenie, kto by mu mohol byť radcom? ");
INSERT INTO slk_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kto mu niečo dal zo svojho, aby mu to Boh musel vrátiť? ");
INSERT INTO slk_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Veď z Boha všetko pochádza, vďaka nemu a pre neho všetko trvá. Jemu nech je sláva naveky. Amen. ");
INSERT INTO slk_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Prosím vás preto, bratia, keďže nás Boh zahŕňa svojím veľkým milosrdenstvom, aby ste samých seba prinášali Bohu. Nech je váš život ako svätá, Bohu príjemná obeť, ako vaša pravá bohoslužba. ");
INSERT INTO slk_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Neprispôsobujte sa tomu, ako žije svet okolo vás, ale zmeňte celé svoje zmýšľanie. Len tak budete schopní rozoznávať, čo je Božia vôľa, čo je správne, dokonalé a jemu milé. ");
INSERT INTO slk_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Z poverenia, ktoré som z milosti dostal od Boha, kladiem na srdce každému z vás, aby si nemyslel o sebe viac, ako skutočne je. Nech o sebe každý zmýšľa v závislosti od viery, ktorú mu Boh daroval. ");
INSERT INTO slk_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Lebo tak, ako sa telo skladá z mnohých orgánov a každý má v ňom inú úlohu, ");
INSERT INTO slk_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tak je to aj s Kristovým telom: hoci je nás veľa, tvoríme jedno telo, kde všetky jeho časti sú závislé jedna od druhej. ");
INSERT INTO slk_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Dostali sme však rozličné dary milosti. Ak je tvojím darom sprostredkovať Božie posolstvo, rob to v súlade s vierou, ktorú máš. ");
INSERT INTO slk_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ak je niekto obdarený schopnosťou slúžiť, nech slúži. Kto má schopnosť vyučovať, nech sa venuje vyučovaniu. ");
INSERT INTO slk_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Kto má dar povzbudzovať, nech povzbudzuje. Kto dáva, nech to robí úprimne. Komu bol zverený dar viesť ostatných, nech to robí poctivo. Kto pomáha núdznym, nech to robí s radosťou. ");
INSERT INTO slk_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Láska nech je bez pretvárky. Zlo nech sa vám protiví, milujte dobro. ");
INSERT INTO slk_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Majte sa radi, ako sa na bratov patrí, buďte k sebe láskaví. Každý nech si ctí iného väčšmi ako seba. ");
INSERT INTO slk_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","V horlivosti neochabujte, slúžte Pánovi s vrúcnosťou a zápalom. ");
INSERT INTO slk_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Tešte sa z toho, že máte nádej; trápenie znášajte trpezlivo a modlite sa vytrvalo. ");
INSERT INTO slk_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Pomáhajte ostatným veriacim, ak sa ocitnú v núdzi, a majte dom vždy otvorený pre hostí. ");
INSERT INTO slk_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Tým, čo vám robia zle, želajte len dobré. Dobrorečte, neživte v sebe nenávisť. ");
INSERT INTO slk_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Radujte sa s radujúcimi, plačte s plačúcimi. ");
INSERT INTO slk_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Žite vo vzájomnej zhode. Nevyvyšujte sa, ale venujte sa aj zdanlivo nepatrným ľuďom a drobným úlohám. Nepokladajte sa za najmúdrejších a najšikovnejších. ");
INSERT INTO slk_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Zlo nikdy neodplácajte zlom, ale usilujte sa o dobro pre všetkých ľudí. ");
INSERT INTO slk_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Nakoľko to závisí od vás, nech sú vaše vzťahy s ostatnými naplnené pokojom. ");
INSERT INTO slk_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nebuďte pomstychtiví, moji drahí, ale nechajte miesto Bohu na jeho súd. Veď je napísané: „Mne patrí pomsta, ja všetkým odplatím, vraví Pán.“ ");
INSERT INTO slk_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","V Písme je totiž aj: „Ak je tvoj nepriateľ hladný, daj sa mu najesť. Ak je smädný, daj sa mu napiť. Takto ho zahanbíš.“ ");
INSERT INTO slk_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nedajte sa premôcť zlom, ale dobrom premáhajte zlo. ");
INSERT INTO slk_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Každý nech sa podriaďuje vrchnosti, ktorá vládne. Veď každá vláda jestvuje len s Božím zvolením. ");
INSERT INTO slk_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kto sa teda stavia proti vláde, stavia sa proti zriadeniu, ktoré Boh ustanovil, a privoláva na seba odsúdenie. ");
INSERT INTO slk_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Vláda predsa nemá naháňať strach tým, čo robia dobre, ale tým, ktorí robia zle. Kto koná v súlade so zákonmi, nemusí sa báť vlády. Naopak, kto robí dobre, dostane od nej pochvalu. ");
INSERT INTO slk_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Veď Boh ju používa na tvoje dobro. Ale ak sa dopúšťaš zla, máš sa čoho báť, lebo nie nadarmo má právo aj trestať. Lebo jej úlohou od Boha je aj to, aby trestala zlo. ");
INSERT INTO slk_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Preto sa jej treba podriadiť: nielen zo strachu pred trestom, je to aj vec svedomia. ");
INSERT INTO slk_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Z rovnakého dôvodu platíme aj dane. Veď ak si vláda plní svoje povinnosti, stáva sa Božím služobníkom. ");
INSERT INTO slk_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Dávajte teda každému, čo mu patrí: komu daň, tomu daň; komu clo, tomu clo; komu úctu, tomu úctu; komu česť, tomu česť. ");
INSERT INTO slk_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nikomu nebuďte nič dlžní, okrem vzájomnej lásky, lebo iba ten, kto ostatných miluje, naplnil Zákon. ");
INSERT INTO slk_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Veď všetky prikázania, ako: „nebudeš cudzoložiť, nebudeš zabíjať, nebudeš kradnúť, nebudeš túžiť po cudzom vlastníctve“ či ktorékoľvek iné, všetky sú obsiahnuté v tomto jedinom: „Milovať budeš svojho blížneho ako seba samého.“ ");
INSERT INTO slk_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Láska neurobí blížnemu nič zlé, preto je naplnením zákona. ");
INSERT INTO slk_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Pamätajte na to najmä teraz, keď viete, v akých vážnych časoch žijeme. Je najvyšší čas prebrať sa z ľahostajnosti, lebo Pánov príchod je bližšie ako vtedy, keď sme uverili. ");
INSERT INTO slk_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Noc sa chýli ku koncu a čoskoro svitne deň. Zanechajme preto skutky tmy a vezmime na seba zbrane svetla. ");
INSERT INTO slk_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Žime slušne a správne: neoddávajme sa hýreniam, opilstvám, nemravnostiam a zmyselnostiam, vyhýbajme sa zvadám a závisti. ");
INSERT INTO slk_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Vezmite na seba charakter Ježiša Krista, ako keď sa obliekate. A nevenujte sa svojmu telu natoľko, aby sa v ňom prebúdzali zlé žiadosti. ");
INSERT INTO slk_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Prijímajte každého, aj keď je jeho viera ešte slabá, ale nedohadujte sa o sporných názoroch. ");
INSERT INTO slk_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Niekto je presvedčený, že môže jesť všetko, iný však prijíma len rastlinnú stravu. ");
INSERT INTO slk_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ten, kto je všetko, nech sa nedíva zvysoka na toho, kto neje. A kto nejedáva všetko, nech zasa neodsudzuje toho, kto jedáva všetko, veď Boh aj jeho prijal. ");
INSERT INTO slk_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Akým právom chceš odsudzovať sluhu iného pána! On nie je zodpovedný tebe, ale svojmu pánovi. A ten je dosť silný, aby ho ochránil od pádu. ");
INSERT INTO slk_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Niektorí ľudia pripisujú niektorým dňom mimoriadny význam, pre iných sú zase všetky dni rovnaké. Dôležité je, aby každý konal podľa vlastného presvedčenia. ");
INSERT INTO slk_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kto napríklad dodržiava pôstne dni, chce si tým uctiť Boha. A kto v týchto dňoch jedáva, takisto si uctí Boha, lebo mu v modlitbe za jedlo ďakuje. A tak či sa postíme alebo jeme, robíme to na česť Pánovi. ");
INSERT INTO slk_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Veď nikto z nás nežije pre seba, ani neumiera pre seba. ");
INSERT INTO slk_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Lebo ak žijeme, žijeme pre Pána, ak zomrieme, zomrieme pre Pána. A tak či žijeme, alebo zomierame, patríme Pánovi. ");
INSERT INTO slk_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Preto Kristus zomrel aj vstal z mŕtvych, aby sa stal Pánom mŕtvych i živých. ");
INSERT INTO slk_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Akým právom teda odsudzuješ svojho brata? A ty, prečo ním pohŕdaš? Nezabúdajme, že všetci sa raz musíme postaviť pred Bohom a on nás bude súdiť. ");
INSERT INTO slk_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Veď je napísané: „Akože som živý, hovorí Pán, každé koleno raz predo mnou pokľakne a každý jazyk vyzná, že ja som Boh.“ ");
INSERT INTO slk_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Každý sám za seba sa bude skladať účty Bohu. ");
INSERT INTO slk_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nesúďme teda jeden druhého, ale radšej dbajme, aby sme blížnemu neurobili nikdy nič také, čo by ho pohoršilo alebo spôsobilo jeho pád do hriechu. ");
INSERT INTO slk_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Viem, ba som o tom presvedčený v Pánovi Ježišovi, že nič nie je nečisté samo osebe. Nečistými sa stávajú veci len tomu, kto ich za nečisté pokladá. ");
INSERT INTO slk_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ak sa tvoj brat trápi pre to, čo ješ, už nekonáš na základe lásky. Nech sa tvoj pokrm nestane príčinou záhuby toho, za ktorého Kristus zomrel. ");
INSERT INTO slk_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Nedovoľte, aby sa o tom dobrom, čo ste prijali, hovorilo ako o zlom. ");
INSERT INTO slk_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","V Božom kráľovstve predsa nejde o jedlo a pitie, ale o spravodlivosť, pokoj a radosť, ktoré dáva Duch Svätý. ");
INSERT INTO slk_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kto takto slúži Kristovi, je milý Bohu a vážia si ho aj ľudia. ");
INSERT INTO slk_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","A tak sa zo všetkých síl usilujme o to, čo nám prináša pokoj a čo nás vzájomne posilňuje. ");
INSERT INTO slk_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nekazme Božie dielo pre pokrmy. Niektorí z vás povedia: „Bohu je všetko čisté.“ To je pravda, ale zlé je, ak niekto pohoršuje iného jedlom. ");
INSERT INTO slk_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Je teda dobré, ak nejeme mäso, nepijeme víno ani nerobíme nič, čím by sme mohli niekoho zraniť alebo oslabiť jeho vieru. ");
INSERT INTO slk_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","To, v čo veríš, nech je medzi tebou a Bohom. Šťastný je ten, kto sa necíti vinný, keď robí niečo, čo pokladá za správne. ");
INSERT INTO slk_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ale toho, kto má pochybnosti pre pokrm, ktorý je, Boh odsúdi, lebo taký človek nekoná na základe viery. A čokoľvek, čo nie je z viery, je hriech. ");
INSERT INTO slk_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","My silní vo viere sme povinní pomáhať slabým niesť ich slabosti, a nie sa len samoľúbo pozerať na seba. ");
INSERT INTO slk_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Každý z nás sa má správať tak, aby bol jeho osobný príklad povzbudením pre blížnych a pomáhal im rásť vo viere. ");
INSERT INTO slk_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ani Kristus nehľadal svoj prospech, ale podľa slov Písma: „Urážky tých, čo teba, Bože, tupili, padli na moju hlavu.“ ");
INSERT INTO slk_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Všetko, čo je tam napísané, bolo napísané na naše poučenie, aby sme z trpezlivosti a povzbudenia, ktoré nám dáva Písmo, čerpali nádej. ");
INSERT INTO slk_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","A Boh, ktorý dáva trpezlivosť a povzbudenie, nech nám pomôže nažívať vo vzájomnej zhode, ako nám to ukázal Ježiš Kristus. ");
INSERT INTO slk_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","A potom budeme môcť všetci spoločne a jednomyseľne oslavovať Boha a Otca nášho Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Preto sa prijímajte navzájom, ako Kristus prijal vás, aby bol Boh oslávený. ");
INSERT INTO slk_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Hovorím vám, že Kristus bol poslaný k Židom, aby ukázal Božiu vernosť a potvrdil sľuby, ktoré dal praotcom. ");
INSERT INTO slk_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Súčasne priniesol milosť aj všetkým ostatným národom, aby aj oni oslavovali Boha, ako je napísané: „Preto ťa budem oslavovať medzi národmi a ospevovať tvoje meno.“ ");
INSERT INTO slk_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","A na inom mieste hovorí: „Tešte sa, pohania, spolu s jeho národom!“ ");
INSERT INTO slk_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","A inde zasa hovorí: „Chváľte Pána, všetky pohanské národy! Velebte ho všetci ľudia!“ ");
INSERT INTO slk_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","A Izaiáš prorokuje: „Príde potomok Izaiho, povstane, aby vládol národom, a pohania budú v neho dúfať.“ ");
INSERT INTO slk_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nech vás Boh, zdroj nádeje, naplní pre vašu vieru všetkou radosťou a pokojom, aby mocou Svätého Ducha vaša nádej čoraz väčšmi rástla. ");
INSERT INTO slk_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Priatelia, som pevne presvedčený, že moje napomenutie ani nepotrebujete, lebo vy sami ste okúsili Božie dobrodenia, máte poznanie, a preto si môžete navzájom ukazovať cestu ako žiť. ");
INSERT INTO slk_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","A predsa som vám písal o niečo smelšie, lebo som vám niektoré veci chcel pripomenúť. Boh ma obdaril svojou milosťou ");
INSERT INTO slk_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","a povolal ma, aby som bol služobníkom Ježiša Krista medzi všetkými národmi. Plním túto úlohu ako kňaz kázaním Božej radostnej zvesti, aby pohania priniesli Bohu radosť ako úprimnú obeť, posvätenú Duchom Svätým. ");
INSERT INTO slk_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Účasť na Božom diele, ktoré konám v spojení s Ježišom Kristom, je mojou najväčšou chválou. ");
INSERT INTO slk_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Neodvažoval by som sa totiž hovoriť o niečom, čo by Kristus cezo mňa nevykonal, aby sa stali pohania poslušní slovom aj skutkom, ");
INSERT INTO slk_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","mocou znamení a divov, mocou Ducha Božieho. Radostnú správu o Kristovi som rozšíril po celom okolí Jeruzalema a vo všetkých krajoch až po Illýriu. ");
INSERT INTO slk_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Usiloval som sa zvestovať Krista tým, ktorí o ňom dosiaľ nič nepočuli. Nechcel som stavať na cudzích základoch, ");
INSERT INTO slk_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ale pridŕžam sa slov Písma: „Uvidia ho tí, ktorí o ňom nič nevedeli, a poznajú ho tí, ktorí o ňom nepočuli.“ ");
INSERT INTO slk_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","A práve to mi neraz zabránilo, aby som k vám prišiel. ");
INSERT INTO slk_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Teraz však už nemám nijaké voľné pole v tých končinách a už mnoho rokov sa teším, že vás navštívim, ");
INSERT INTO slk_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","keď budem cestovať do Španielska. Dúfam, že sa mi toto želanie splní, prežijeme spolu radostné spoločenstvo, a potom ma vypravíte na ďalšiu cestu. ");
INSERT INTO slk_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Predtým sa však ešte chystám do Jeruzalema, aby som pomohol tamojším kresťanom. ");
INSERT INTO slk_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","V Macedónsku a v Achajsku usporiadali totiž zbierku pre núdznych bratov v Jeruzaleme. ");
INSERT INTO slk_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Rozhodli sa pomôcť im hmotnými darmi, lebo sa im túžia odvďačiť za duchovné bohatstvo, ktoré od nich prijali. ");
INSERT INTO slk_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Keď vykonám túto úlohu a odovzdám im výťažok zo zbierky, vyberiem sa do Španielska a cestou sa zastavím u vás. ");
INSERT INTO slk_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Som si istý, že keď k vám prídem, budem sa s vami môcť podeliť o bohatstvo požehnania Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Chcem vás ešte poprosiť, milí bratia, pre nášho Pána Ježiša a pre lásku, ktorá je z Ducha, aby ste mi pomáhali bojovať na modlitbách a prihovárali sa za mňa u Boha, ");
INSERT INTO slk_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","aby ma ochránil pred neveriacimi v Judsku a aby v Jeruzaleme moju službu tamojší veriaci uvítali. ");
INSERT INTO slk_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Potom, ak to bude vôľa Božia, budem môcť s radosťou prísť k vám, aby som si medzi vami odpočinul. ");
INSERT INTO slk_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Boh, darca pokoja, nech je so všetkými vami. Amen. ");
INSERT INTO slk_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Odporúčam vám našu sestru Fébu, obetavú služobníčku zboru v Kenchreách. ");
INSERT INTO slk_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Ochotne pomáhala mne aj iným. Ak sa na vás obráti, pomôžte jej vo všetkom, čo bude potrebovať, ako sa na kresťanov patrí. ");
INSERT INTO slk_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Pozdravte Prisku a Akvilu, mojich spolupracovníkov v službe pre Ježiša Krista, ");
INSERT INTO slk_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ktorí boli pre mňa ochotní obetovať aj svoj život. Vďačím im nielen ja, ale aj všetky zbory z bývalých pohanov. ");
INSERT INTO slk_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Aj všetkých veriacich, ktorí sa schádzajú v ich dome, srdečne pozdravujem. Pozdravte aj môjho milovaného Epaineta, ktorý ako prvý v Ázii uveril v Krista. ");
INSERT INTO slk_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Pozdravte Máriu, ktorá pre vás toľko vykonala. ");
INSERT INTO slk_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Srdečne pozdravujem aj Andronika a Júniu, pôvodom Židov, ako som ja, a kedysi spoluväzňov, apoštolov, ktorí sa tešia veľkej vážnosti a uverili v Krista skôr ako ja. ");
INSERT INTO slk_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ďalej pozdravte Ampliáta, môjho dobrého priateľa a spoločníka v Pánovi, ");
INSERT INTO slk_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ale aj Urbana, nášho spolupracovníka v diele Kristovom, a Stachysa, ktorý je pre mňa veľmi vzácny. ");
INSERT INTO slk_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Pozdravujte Apella, ktorý je známy svojou oddanosťou Kristovi. Takisto všetkých z Aristobulovho domu. ");
INSERT INTO slk_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Pozdravte aj môjho krajana Herodiona. Pozdravte tých z domu Narcisa, čo sa odovzdali Pánovi. ");
INSERT INTO slk_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Takisto pozdravte Tryfinu a Tryfózu, ktoré mnoho pracovali pre Pána. Pozdravte mne veľmi drahú Persidu, ktorá horlivo pracovala v diele Pánovom. ");
INSERT INTO slk_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Pozdravujte Rúfa, pozoruhodného veriaceho, a jeho matku, ktorá i mne bola matkou. ");
INSERT INTO slk_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ďalej pozdravujem Asynkrita, Flegóna, Hermesa, Patroba, Hermasa a ostatných tamojších bratov, ");
INSERT INTO slk_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filológa a Júliu, Nerea a jeho sestru, Olympa i všetkých kresťanov u nich. ");
INSERT INTO slk_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Pozdravte sa navzájom láskavým objatím. Pozdravujú vás aj všetky kresťanské zbory. ");
INSERT INTO slk_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ešte jedno vám chcem položiť na srdce: dajte si pozor na ľudí, ktorí vyvolávajú roztržky a chceli by vás odviesť od učenia, ktoré ste prijali. Vyhýbajte sa im! ");
INSERT INTO slk_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Takí totiž neslúžia Kristovi, ale pre svoj vlastný prospech. Krásnymi a zbožnými rečami sa usilujú zmiasť srdcia nič netušiacich ľudí. ");
INSERT INTO slk_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Všade sa hovorí o vašej oddanosti evanjeliu. Mám z toho veľkú radosť a želám vám múdrosť v konaní dobra a zlo nech sa vás ani nedotkne. ");
INSERT INTO slk_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Boh, darca pokoja, už čoskoro rozdrví satana pri vašich nohách. Nech je s vami milosť Ježiša, nášho Pána. ");
INSERT INTO slk_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Pozdravuje vás aj môj spolupracovník Timotej a moji krajania Lucius, Jason a Sosipatros. ");
INSERT INTO slk_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","I ja, Tercius, ktorý som zapísal tento list, pripájam svoj pozdrav ako váš brat. ");
INSERT INTO slk_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","I Gájus, ktorý otvoril svoj dom mne i celému zboru, vás úprimne pozdravuje, a takisto Erastos, správca mestskej pokladnice, a brat Kvartus. ");
INSERT INTO slk_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Milosť nášho Pána Ježiša Krista nech je s vami všetkými. ");
INSERT INTO slk_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Sláva tomu, ktorý má moc upevniť vás vo viere podľa slov, ktoré som vám zvestoval o Ježišovi Kristovi. Bolo vám zjavené tajomstvo, ktoré bolo od dávnych čias pred ľuďmi skryté. ");
INSERT INTO slk_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Už proroci o ňom hovorili a na príkaz večného Boha majú teraz ľudia zo všetkých národov počuť evanjelium, prijať ho vierou a žiť podľa neho. ");
INSERT INTO slk_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Tohto jediného pravého Boha, chceme za jeho múdrosť, v mene Ježiša Krista, zvelebovať a oslavovať celú večnosť. Amen!");
INSERT INTO slk_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Od Pavla, ktorého Boh podľa svojej vôle povolal za apoštola Ježiša Krista a od nášho brata Sostena ");
INSERT INTO slk_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Božej cirkvi v Korinte, tým, ktorých Boh pozval, aby sa stali jeho svätým ľudom a vďaka jednote s Ježišom Kristom mu patria, a všetkým, ktorí kdekoľvek slúžia nášmu Pánovi Ježišovi Kristovi – Pánovi nášmu aj ich. ");
INSERT INTO slk_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Milosť vám a pokoj od Boha, nášho Otca, a od Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Neprestajne ďakujem Bohu za milosť, ktorou vás obdaroval prostredníctvom Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","V Ňom sa vám dostalo bohatstvo vo všetkom – v slove múdrosti i v každom poznaní. ");
INSERT INTO slk_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Tak sa medzi vami potvrdila jeho pravdivosť, ");
INSERT INTO slk_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","takže nemáte nedostatok v žiadnom obdarovaní a očakávate zjavenie nášho Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","On vám dá silu byť čestní až do konca – do dňa nášho Pána Ježiša Krista. ");
INSERT INTO slk_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Bohu môžete dôverovať, veď je to on, kto vás povolal do spoločenstva so svojím Synom Ježišom Kristom, naším Pánom. ");
INSERT INTO slk_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","V moci nášho Pána Ježiša Krista vás napomínam: žite vo vzájomnej zhode a nehádajte sa! Buďte jednotní v zmýšľaní a majte spoločný cieľ. ");
INSERT INTO slk_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Dopočul som sa totiž od niektorých z domu Chloe, milí bratia, že sú medzi vami spory. ");
INSERT INTO slk_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Mám na mysli to, ako každý z vás hovorí niečo iné. Jedni tvrdia: „Ja som Pavlov nasledovník“, iní „Ja som Apollov“, ďalší „Ja sa hlásim k Petrovi“ a ešte iní „Ja som Kristov“. ");
INSERT INTO slk_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Je vari Kristus rozdelený? Bol azda Pavol za vás ukrižovaný? Či som krstil niekoho z vás vo svojom vlastnom mene? ");
INSERT INTO slk_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Som Bohu vďačný, že som u vás nekrstil nikoho okrem Krispa a Gája, ");
INSERT INTO slk_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","takže sa nikto nemôže odvolávať na môj krst. ");
INSERT INTO slk_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Vlastne som pokrstil aj Štefanovu rodinu, inak už neviem o nikom. ");
INSERT INTO slk_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristus ma totiž neposlal krstiť, ale hlásať radostnú zvesť. Nie však slovami ľudskej múdrosti, aby sa nestalo, že Kristova smrť na kríži stratí zmysel. ");
INSERT INTO slk_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Posolstvo o kríži je totiž pre tých, ktorí sa rútia do záhuby, bláznovstvom; ale pre nás, ktorí prijímame záchranu, je prejavom Božej moci. ");
INSERT INTO slk_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Písmo hovorí: „Zničím múdrosť múdrych a zmarím rozumnosť rozumných.“ ");
INSERT INTO slk_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Kde ste, mudrci, znalci Zákona a všetci filozofi dneška? Či Boh nedokázal, aká pochabá je všetka múdrosť sveta? ");
INSERT INTO slk_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Keďže svet vlastnou múdrosťou nepoznal Boha v jeho múdrosti, rozhodol sa zachrániť „bláznivou“ zvesťou o kríži tých, ktorí mu uveria. ");
INSERT INTO slk_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Židia očakávajú ako dôkaz znamenia, pohania chcú všetko pochopiť svojou múdrosťou. ");
INSERT INTO slk_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","My však kážeme ukrižovaného Krista: Židov to uráža, pohania to pokladajú za bláznovstvo, ");
INSERT INTO slk_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ale pre tých, ktorí prijali Božie pozvanie, či už sú Židia alebo pohania, je Kristus Božou mocou a Božou múdrosťou. ");
INSERT INTO slk_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Božie „bláznovstvo“ je totiž múdrejšie a Božia „bezmocnosť“ je mocnejšia ako ľudia. ");
INSERT INTO slk_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Len sa obzrite okolo seba, bratia, koho si Boh povolal. Zistíte, že podľa ľudských meradiel medzi vami nie je veľa múdrych ani vplyvných či vážených ľudí. ");
INSERT INTO slk_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","A predsa si Boh vyvolil práve to, čo svet považuje za bláznivé, aby zahanbil múdrych. Čo svet považuje za slabé, to si Boh vybral, aby zahanbil mocných. ");
INSERT INTO slk_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","To, čo ľudia považujú za obyčajné či menejcenné, to si Boh vyvolil. Vyvolil si to, čo v očiach ľudí akoby nebolo, aby zmenil na ničotu to, čo podľa nich má hodnotu. ");
INSERT INTO slk_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","A to všetko preto, aby sa nikto pred Bohom nevyvyšoval. ");
INSERT INTO slk_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","To, že patríte Kristovi, je len vďaka Božej moci. Vďaka nemu sa nám Kristus stal múdrosťou, spravodlivosťou, posvätením a vykúpením. ");
INSERT INTO slk_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Je to tak, ako hovorí Písmo: „Kto sa chváli, nech sa chváli tým, čo vykonal Pán.“ ");
INSERT INTO slk_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Bratia, keď som k vám prišiel, nehovoril som vám o Božích tajomstvách nejakými vznešenými slovami ani učenými výkladmi. ");
INSERT INTO slk_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Rozhodol som sa totiž, že kým budem u vás, nebudem myslieť na nič, iba na Ježiša Krista a jeho smrť na kríži. ");
INSERT INTO slk_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Keď som bol u vás, chvel som sa úzkosťou, prežíval som obavy a strach. ");
INSERT INTO slk_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Moja reč a moje posolstvo neboli založené na presvedčivých slovách ľudskej múdrosti, ale spoliehal som sa na Božieho Ducha a jeho moc. ");
INSERT INTO slk_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Vaša viera sa teda nezakladá na ľudskej múdrosti, ale na Božej moci. ");
INSERT INTO slk_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Je aj múdrosť, o ktorej hovoríme kresťanom so zrelou vierou. Nie je to však múdrosť tohto sveta, ani jeho vládcov, ktorý prichádzajú o svoju moc. ");
INSERT INTO slk_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Hovoríme o Božej múdrosti, skrytej v tajomstve, o ktorej Boh už pred stvorením sveta určil, že nás ňou privedie do svojej slávy. ");
INSERT INTO slk_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Nikto z dnešných vládcov nemal o tejto múdrosti ani tušenie. Veď keby o nej vedeli, neukrižovali by Pána slávy. ");
INSERT INTO slk_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ale tak, ako je napísané: „Čo ľudské oko nikdy nevidelo, ani ucho nepočulo, čo človeku ani nenapadlo, to Boh pripravil tým, ktorí ho milujú“. ");
INSERT INTO slk_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nám to však Boh odhalil svojím Duchom, lebo iba Duch má preskúmané všetko – aj hĺbku Božích myšlienok. ");
INSERT INTO slk_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ako ľudia nevidia do myšlienok človeka a vie o nich len on sám, tak aj Božie myslenie je známe len Božiemu Duchu. ");
INSERT INTO slk_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","My sme však neprijali ducha sveta! Prijali sme Ducha, ktorého nám poslal Boh, aby sme pochopili, čo všetko nám daroval. ");
INSERT INTO slk_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nerozprávame o tom naučenými slovami ľudskej múdrosti, ale hovoríme tak, ako nás vyučuje Boží Duch; duchovné veci vysvetľujeme duchovným ľuďom. ");
INSERT INTO slk_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Neveriaci človek nemôže prijať veci Božieho Ducha. Zdajú sa mu bláznivé a nepochopiteľné, pretože ich význam sa dá vidieť len s pomocou Ducha. ");
INSERT INTO slk_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Kto však je preniknutý Božím Duchom, vie ku všetkému zaujať jasný postoj, ale sám nemôže byť nikým správne posúdený. ");
INSERT INTO slk_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Ako je napísané: „Kto môže pochopiť Božie myslenie a kto by mu mohol byť radcom?“ My sme však prijali Kristovho Ducha a môžeme mu preto rozumieť. ");
INSERT INTO slk_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Bratia, ak som sa vám prihováral vo veciach viery ako k deťom, malo to svoju príčinu. Nemohol som k vám totiž pristupovať ako k tým, ktorých vedie Boží Duch, ale len ako k ľuďom patriacim tomuto svetu. ");
INSERT INTO slk_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Kŕmil som vás akoby len mliekom, nie riadnou stravou, lebo by ste ju ešte nevedeli prijať. A zdá sa, že ani teraz to nedokážete, ");
INSERT INTO slk_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","a že ešte vždy žijete ako bez Božieho Ducha. Veď ak sú medzi vami spory a žiarlivosť, nie je príčinou vaša telesnosť? Nekonáte ako ostatní ľudia? ");
INSERT INTO slk_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Keď niekto zdôrazňuje: „Ja som Pavlov nasledovník“ a iný zase „Ja nasledujem Apolla“, nie je to príliš ľudské? ");
INSERT INTO slk_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Veď kto je Apollo? A kto je Pavol? Iba služobníci, ktorí vás priviedli k viere, a to každý podľa toho, ako mu to Boh určil. ");
INSERT INTO slk_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ja som zasadil, Apollo polieval, ale vzrast dal Boh. ");
INSERT INTO slk_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","To on dáva všetkému rásť, a nie ten, kto sadí alebo kto polieva. ");
INSERT INTO slk_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Niet rozdielu medzi tým, ktorý sadí a ktorý polieva; každý dostane odmenu podľa vykonanej práce. ");
INSERT INTO slk_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","My sme iba Boží spolupracovníci; vy ste Božie pole, Božia stavba. ");
INSERT INTO slk_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Z Božej milosti som mohol ako múdry staviteľ položiť základ Božej stavby, na ktorom ďalej stavia už iný. Ale každý nech si dáva pozor, ako na ňom stavia. ");
INSERT INTO slk_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Nik totiž nemôže položiť iný základ, než ten, ktorý už stojí, a tým je Ježiš Kristus. ");
INSERT INTO slk_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Avšak na tomto základe stavia niekto zo zlata, striebra, drahého kameňa alebo z dreva, sena či slamy, ");
INSERT INTO slk_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","a to sa ukáže v súdny deň. Vtedy vyjde najavo každé dielo a prejde ohňom, aby sa ukázalo, ako kto staval. ");
INSERT INTO slk_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ak stavba vydrží, dostane staviteľ odmenu. ");
INSERT INTO slk_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ak zhorí, stratí všetko a sám sa zachráni len ako ktosi, kto unikol plameňom. ");
INSERT INTO slk_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Vari neviete, že ste Božím chrámom a prebýva vo vás Boží Duch? ");
INSERT INTO slk_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ak niekto ničí Boží chrám, toho zničí Boh, lebo Boží chrám je svätý, a tým chrámom ste vy! ");
INSERT INTO slk_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Nežite v sebaklame! Ak si niekto o sebe namýšľa, že je podľa meradiel tohto sveta ktovieako múdry, potrebuje sa stať bláznom, aby našiel ozajstnú múdrosť. ");
INSERT INTO slk_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","V Božích očiach je to, čo ľudia považujú za múdrosť, len obyčajným bláznovstvom. Je predsa napísané: „On chytá múdrych v ich chytráctve“, ");
INSERT INTO slk_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","alebo: „Pán dobre pozná myšlienky múdrych, že sú nanič“. ");
INSERT INTO slk_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Nech si teda nikto nezakladá na ľuďoch, veď všetko ste len dostali. ");
INSERT INTO slk_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Pavol či Peter alebo Apollo – aj oni vám boli daní. Patrí vám svet, život i smrť, všetko v prítomnosti i všetko v budúcnosti – ");
INSERT INTO slk_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","vy však patríte Kristovi a Kristus je Boží. ");
INSERT INTO slk_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nepozerajte sa teda na nás inak než ako na Kristových služobníkov a správcov Božích tajomstiev. ");
INSERT INTO slk_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Od služobníkov sa očakáva, že budú vo všetkom, čo robia, verní. ");
INSERT INTO slk_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Preto mi nezáleží na tom, čo o mne súdite vy či ktokoľvek z ľudí. Súd nad sebou nevynášam ani ja sám. ");
INSERT INTO slk_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","A hoci je moje svedomie čisté, neznamená to, že som nevinný; len Pán je ten, kto o mne môže vyniesť súd. ");
INSERT INTO slk_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Nerobte preto o nikom predčasné závery, kým sa nevráti Kristus. On vynesie na svetlo to, čo bolo ukryté v tme, a odhalí aj tie najtajnejšie pohnútky. Až potom dostane každý od Boha spravodlivú odmenu. ");
INSERT INTO slk_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Bratia, to čo som hovoril, sa síce vzťahovalo na mňa a na Apolla, ale chcel som tým len zdôrazniť slová: „Nemyslieť nad to, čo je napísané.“ Nemáte sa pýšiť a vyzdvihovať jedného z nás pred druhým. ");
INSERT INTO slk_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Veď kto z teba robí dôležitého? Máš vari niečo, čo by si nebol dostal? A ak si to dostal ako dar, prečo sa chváliš, akoby si si to zaslúžil? ");
INSERT INTO slk_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Vy ste teda presvedčení, že máte všetko, čo potrebujete? Naozaj ste už zbohatli? Už ste začali kraľovať? A to všetko bez nás? Kiež by ste sa naozaj stali kráľmi, aby sme mohli kraľovať spolu s vami. ");
INSERT INTO slk_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Tak sa mi zdá, akoby nám apoštolom určil Boh posledné miesto; ako odsúdencom na smrť. Stali sme sa divadlom svetu, anjelom i ľuďom. ");
INSERT INTO slk_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Nás považujú za bláznov pre Krista, vy ste však tí rozumní! Nami každý pohŕda, vás však uznáva; my sme slabí, vy ste silní. ");
INSERT INTO slk_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Neustále trpíme hladom a smädom, zimou a chorobami, bijú nás, ako bez domova blúdime z miesta na miesto ");
INSERT INTO slk_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","a musíme si zarábať ťažkou prácou. Žehnáme tým, ktorí nás preklínajú; ak nás prenasledujú, trpezlivo to znášame; ");
INSERT INTO slk_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ak nás ohovárajú, odpovedáme láskavo. Stali sme sa spodinou tohto sveta a ešte stále nás považujú za odpad spoločnosti. ");
INSERT INTO slk_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","To však nepíšem preto, že by som vám chcel niečo vyčítať, ale napomínam vás ako vlastné deti. ");
INSERT INTO slk_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Keby ste mali hoc aj tisíce vodcov, otcov toľko mať nemôžete. V spojení s Ježišom Kristom som sa stal akoby vaším otcom, keď som vám priniesol evanjelium. ");
INSERT INTO slk_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Preto vás nabádam, aby ste žili podľa môjho príkladu. ");
INSERT INTO slk_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Práve preto k vám posielam svojho milovaného a Pánovi verného Timoteja, ktorý mi je ako syn. Ten vám pripomenie zásady života s Ježišom Kristom, ako ich vyučujem v každom zbore. ");
INSERT INTO slk_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Niektorí sa začali povyšovať, akoby som už ani nemal prísť do Korintu. ");
INSERT INTO slk_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ja však čoskoro prídem – ak to Bude Pánova vôľa –, a potom uvidím, či je v tých vystatovačných ľuďoch Božia moc, alebo len prázdne slová. ");
INSERT INTO slk_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Božie kráľovstvo totiž nestojí na rečnení, ale na moci Božieho ducha. ");
INSERT INTO slk_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Tak čo teda chcete? Mám k vám prísť s palicou, alebo s láskou a vľúdnosťou? ");
INSERT INTO slk_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Hovorí sa o tom, že je u vás taký prípad nemravnosti, aký by človek ťažko hľadal aj medzi pohanmi, že totiž jeden z vás žije s nevlastnou matkou ako jej muž. ");
INSERT INTO slk_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","A to sa ešte nehanebne vystatujete, namiesto aby ste sa zhrozili a vylúčili takého človeka zo svojho spoločenstva! ");
INSERT INTO slk_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Hoci nie som s vami osobne, duchom som stále pri vás. A rozhodol som, čo treba urobiť s človekom, ktorý sa niečoho takého dopustil. ");
INSERT INTO slk_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","V mene nášho Pána Ježiša Krista zvolajte zhromaždenie všetkých veriacich, moc Pána Ježiša bude s vami – i ja v jeho Duchu – ");
INSERT INTO slk_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","a ten človek nech je vylúčený zo spoločenstva kresťanov a odovzdaný do satanových rúk na záhubu tela, aby jeho duch mohol byť zachránený v Pánov deň. ");
INSERT INTO slk_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Vaša chvála naozaj nie je na mieste. Či neviete, že trocha kvasu nakvasí celé cesto? ");
INSERT INTO slk_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Odstráňte starý kvas, aby ste boli novým cestom. Máte byť totiž nekvaseným chlebom; veď Kristus, náš veľkonočný Baránok, bol za nás obetovaný. ");
INSERT INTO slk_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Slávme teda sviatky nie so starým kvasom hriechu a zla, ale s nekvaseným chlebom úprimnosti a pravdy. ");
INSERT INTO slk_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Napísal som vám v liste, že s nemorálnymi ľuďmi sa nemáte dávať dohromady. ");
INSERT INTO slk_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nemyslel som to však tak, že sa máte vyhýbať všetkým nemravníkom, chamtivcom, podvodníkom a modloslužobníkom. Veď to by ste sa museli vysťahovať preč z tohto sveta. ");
INSERT INTO slk_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ak sa však niekto vydáva za kresťana, ale je nemravník a chamtivec, modloslužobník, ohovárač, opilec alebo podvodník, nesadajte s ním ani za jeden stôl. ");
INSERT INTO slk_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Súdiť nekresťanov nie je našou úlohou. My by sme mali zaujať postoj k tým, čo sú medzi nami. ");
INSERT INTO slk_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Tých, ktorí neveria, nech súdi Boh. Ale zlo zo svojho stredu odstráňte vy sami! ");
INSERT INTO slk_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Ako to, že keď má niekto s niekým spor, rieši to pred pohanským sudcom a nie pred veriacim? ");
INSERT INTO slk_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Či vari Boží ľud, ktorému raz bude zverený súd nad celým svetom, nie je schopný dohodnúť sa na takých maličkostiach? ");
INSERT INTO slk_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Neviete, že raz máte súdiť aj anjelov? Čo sú proti tomu nejaké každodenné záležitosti? ");
INSERT INTO slk_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Keď sa súdite vo veciach všedného života, prečo si beriete za sudcov ľudí, ktorí nemajú v cirkvi žiadnu vážnosť? ");
INSERT INTO slk_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Hanbite sa, že vám to musím vyčítať! Či sa medzi vami nenájde ani jeden rozumný, kto by rozsúdil spor medzi svojimi bratmi? ");
INSERT INTO slk_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Namiesto toho sa súdi brat s bratom, a to pred neveriacimi! ");
INSERT INTO slk_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Už to je vaša prehra, že máte medzi sebou spory. Prečo netrpíte radšej krivdu? Prečo neznášate radšej škodu? ");
INSERT INTO slk_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ale namiesto toho sami krivdíte a spôsobujete škody, a to bratom! ");
INSERT INTO slk_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Vyri neviete, že nespravodliví sa nedostanú do Božieho kráľovstva? Neklamte samých seba Nijakí nemravníci ani modlári, ani cudzoložníci či tí, ktorí sa oddávajú iným mužom, ");
INSERT INTO slk_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ani zlodeji, chamtivci, opilci, ohovárači alebo podvodníci nevkročia do Božieho kráľovstva! ");
INSERT INTO slk_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Aj niektorí z vás boli takí. Teraz ste však z moci nášho Pána Ježiša Krista a Duchom nášho Boha očistení od hriechu, zasvätení Bohu a vyhlásení za spravodlivých. ");
INSERT INTO slk_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Niekto môže povedať: „Všetko smiem.“ Áno, ale nie všetko je osožné. „Všetko je dovolené.“ Áno, ale nestaň sa otrokom toho, čo robíš. ");
INSERT INTO slk_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Potrava je na to, aby bolo čo do žalúdka a žalúdok je na to, aby bolo kam dať potravu. Boh však raz urobí obom koniec. So smilstvom je to však inak: telo nám nebolo dané na to, aby sme ho zneužívali, patrí Pánovi a má mu slúžiť. ");
INSERT INTO slk_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Tou istou mocou, ktorou vzkriesil Boh Krista, vzkriesi aj nás. ");
INSERT INTO slk_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Vari neviete, že naše telá sú časťami Kristovho tela? Máme teda časti Kristovho tela spojiť s predajnou ženou? Určite nie! ");
INSERT INTO slk_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Veď kto sa oddáva smilnici, je s ňou jedno telo, ako je napísané: „A tí dvaja sa stanú jedným telom“. ");
INSERT INTO slk_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","A každý, kto sa oddáva Pánovi, je s ním jeden duch. ");
INSERT INTO slk_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Vyhýbajte sa teda smilstvu! Ostatné priestupky sa netýkajú tela priamo, ale smilstvom sa previňujete proti vlastnému telu. ");
INSERT INTO slk_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Neviete vari, že vaše telo je chrámom Svätého Ducha, ktorý v ňom prebýva a ktorého vám dal Boh? Nepatríte už sami sebe! ");
INSERT INTO slk_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Bolo za vás zaplatené vysoké výkupné! Tak teda nech aj vaše telo je Bohu na slávu! ");
INSERT INTO slk_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","A teraz k ďalším otázkam z vášho listu. Ak muž dokáže žiť bez ženy, je mu to na dobré. ");
INSERT INTO slk_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Aby ste však predišli nemorálnostiam, nech má každý muž svoju manželku a žena svojho manžela. ");
INSERT INTO slk_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Manželia nech si navzájom plnia svoje manželské povinnosti. ");
INSERT INTO slk_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Žena ani muž nemajú v manželstve svoje telá sami pre seba, ale pre svojho partnera. ");
INSERT INTO slk_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Preto si vzájomne vychádzajte v ústrety, iba ak po vzájomnej dohode na nejaký čas zachováte zdržanlivosť kvôli stíšeniu sa na modlitbách; potom sa zas odovzdajte jeden druhému, aby ste sa nevystavovali satanovým pokušeniam, keby ste sa nemohli ovládnuť. ");
INSERT INTO slk_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","To, čo tu píšem, považujte za možnosť, nie za príkaz. ");
INSERT INTO slk_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Bol by som samozrejme rád, keby mal každý silu žiť ako ja. Ale Boh nedáva každému rovnaký dar: jednému dá to, inému ono. ");
INSERT INTO slk_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Slobodným ľuďom a vdovám odporúčam, aby už nevstupovali do manželstva, tak ako ja. ");
INSERT INTO slk_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ale keby im zdržanlivosť pôsobila ťažkosti, nech sa radšej oženia alebo vydajú. Je lepšie žiť v manželstve, než sa trápiť túžbou po partnerovi. ");
INSERT INTO slk_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Pre manželov však platí jednoznačne (a to nie je môj príkaz, ale Pánov), aby žena neodchádzala od svojho muža. ");
INSERT INTO slk_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ak by predsa odišla, nech zostane nevydatá alebo nech sa s manželom zmieri (a vráti sa k nemu). Takisto ani muž sa nesmie rozviesť so ženou. ");
INSERT INTO slk_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","O ďalších problémoch nemám priame pokyny od Pána. Ja by som však radil toto: Ak má niekto z bratov neveriacu ženu a ona s ním chce žiť, nech sa s ňou nerozvádza. ");
INSERT INTO slk_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","A podobne ak má žena za muža neveriaceho a on s ňou chce žiť, nech sa s ním nerozvádza. ");
INSERT INTO slk_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Lebo viera veriaceho muža či ženy má v manželstve vplyv aj na jeho neveriaceho partnera. A takto sú aj ich deti pod vplyvom viery veriaceho rodiča. ");
INSERT INTO slk_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ale ak neveriaci chce z manželstva odísť, nechajte ho. Takýto veriaci brat či sestra nie sú slobodní vo svojom konaní. Boh nás predsa povolal, aby sme žili v pokoji. ");
INSERT INTO slk_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Či môžeš vedieť, veriaci muž alebo žena, aký vplyv budeš mať na svojho manželského partnera a jeho cestu k záchrane? ");
INSERT INTO slk_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Každý by mal zostať v takom stave, v akom bol, keď ho Pán povolal k viere. Tak o tom hovorím vo všetkých kresťanských zboroch. ");
INSERT INTO slk_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Kto sa napríklad dal podľa židovského spôsobu obrezať, nemá sa prečo hanbiť a tajiť to. A kto nebol obrezaný, nemusí sa tomu obradu podrobovať ani teraz. ");
INSERT INTO slk_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Pre kresťana nie je dôležité, či sa podrobil obradu obriezky, alebo nie. Dôležité je, aby žil podľa Božích prikázaní. ");
INSERT INTO slk_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Zostaň teda tým, čím si bol, keď si počul Božie volanie. ");
INSERT INTO slk_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Zastihlo ťa ako otroka? Nič si z toho nerob. Ale ak sa ti naskytne možnosť stať sa slobodným, využi ju. ");
INSERT INTO slk_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Veď koho Boh povolal ako otroka, ten môže prežívať slobodu, ktorú mu daroval. A naopak, ak si niekoho Boh povolal ako slobodného občana, je Kristovým otrokom. ");
INSERT INTO slk_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Bolo za vás zaplatené vysoké výkupné. Nedávajte sa teda zotročovať inými ľuďmi! ");
INSERT INTO slk_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Veriaci, každý z vás nech zostáva v spoločenstve s Bohom v takom postavení, do akého ho Boh povolal. ");
INSERT INTO slk_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","O nevydatých dievčatách mi Kristus nedal nijaké osobitné pokyny. No keď smiem byť vďaka Božiemu milosrdenstvu považovaný za dôveryhodného, poviem vám svoju osobnú mienku. ");
INSERT INTO slk_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Myslím, že s ohľadom na súženia, ktoré sa dajú očakávať, je múdrejšie zostať tak, ako ste. ");
INSERT INTO slk_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Si zosobášený? Nehľadaj rozluku. Si slobodný? Nevyhľadávaj vstup do manželstva. ");
INSERT INTO slk_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Kto sa aj napriek tomu rozhodne vstúpiť do manželstva – či muž alebo slobodné dievča – ten samozrejme nehreší. Musíte však potom rátať s tým, že vás v živote stretnú mnohé problémy a tých by som vás rád ušetril. ");
INSERT INTO slk_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Mám tým na mysli toto: Pred nami je už len krátky čas. A tak tí, ktorí sú ženatí, nech to nepovažujú za prvoradé ");
INSERT INTO slk_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Tí, čo plačú, nech sú, akoby neplakali; tí, čo sa radujú, akoby sa neradovali; tí, čo kupujú, akoby nič nevlastnili. ");
INSERT INTO slk_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Využívajte teda všetko dobré, čo ponúka život, ale pamätajte, že nič z toho nepotrvá večne. ");
INSERT INTO slk_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Bol by som rád, keby ste nemali zbytočné starosti. Neženatý sa môže naplno venovať Božím veciam a tomu, aby bol svojím konaním milý Bohu. ");
INSERT INTO slk_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ženatý sa musí starať o všedné veci a o to, aby sa zapáčil svojej žene, ");
INSERT INTO slk_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","a preto je jeho pozornosť rozdelená medzi Boha a rodinu. Rovnako nevydatá žena alebo mladé dievča sa môže starať o Božie veci; chce Bohu patriť telom i dušou. Vydatá sa však musí starať o všedné veci a o to, aby sa páčila manželovi. ");
INSERT INTO slk_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","To všetko vám hovorím, aby som vám pomohol, nie aby som vás priviedol do problémov. Chcem vám ukázať, ako slúžiť Pánovi čo najlepšie a tak, aby vás od neho nič neodvádzalo a mohli ste mu byť oddaní. ");
INSERT INTO slk_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ale ak má niekto snúbenicu a zdá sa mu dobré, aby sa (vzhľadom na jej vek) zosobášili, nech tak urobí – nie je to hriech. Nech sa zosobášia! ");
INSERT INTO slk_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","A tak ten, kto sa rozhodol zosobášiť so svojou snúbenicou, dobre robí, ale ten kto sa rozhodol zostať slobodný, urobil lepšie rozhodnutie. ");
INSERT INTO slk_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Tak teda oboje je správne, ale to druhé je lepšie. ");
INSERT INTO slk_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Žena je viazaná vernosťou, kým žije jej muž. Keď ovdovie, je voľná a môže sa opäť vydať, no iba za kresťana. ");
INSERT INTO slk_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Podľa môjho názoru však bude šťastnejšia, ak to neurobí, a nazdávam sa, že aj ja sa môžem odvolávať na vedenie Božím Duchom. ");
INSERT INTO slk_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","A teraz k otázke jedenia mäsa zo zvierat obetovaných pohanským modlám. Pravdou je, že všetci vieme ako to je. Poznanie však nie je všetko – môže viesť človeka k povýšenosti, ale len láska povznáša. ");
INSERT INTO slk_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ak má niekto pocit, že pozná odpoveď na každú otázku, pravdepodobne toho ešte veľa nevie. ");
INSERT INTO slk_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ale ak niekto Boha miluje, Boh o ňom vie a pozná ho. ");
INSERT INTO slk_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Čo sa týka mäsa zasväteného pohanským modlám, vieme, že modly nič neznamenajú. Nie je iný Boh okrem toho jediného. ");
INSERT INTO slk_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Ak sa im tiež hovorí „bohovia“ – a takých „bohov“ a „pánov“ je na nebi i na zemi naozaj mnoho – ");
INSERT INTO slk_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","my máme len jedného Boha, nášho Otca, od ktorého všetko pochádza a ktorému my všetci patríme. A máme len jedného Pána, Ježiša Krista, prostredníctvom ktorého bolo všetko stvorené a aj nám dal život. ");
INSERT INTO slk_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Avšak nie všetci dospeli k tomuto poznaniu. Niektorí ešte len nedávno sami uctievali modly, a preto v prijímaní takého mäsa vidia náznak modloslužby. Oslabuje to ich svedomie a cítia sa poškvrnení. ");
INSERT INTO slk_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Je pravda, že jedlo nás v Božích očiach nerobí lepšími. Ak mäso obetované modlám nejeme, o nič neprichádzame, ak ho jeme, nič tým nezískavame. ");
INSERT INTO slk_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Musíte však byť opatrní, aby váš slobodný postoj nepohoršil slabších vo viere. ");
INSERT INTO slk_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Keď totiž teba, ktorý vieš o čo ide, uvidí niekto sedieť za stolom v pohanskom chráme, môžeš tým ovplyvniť jeho slabé svedomie a bude tiež jesť mäso obetované modlám. ");
INSERT INTO slk_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","A keď bude robiť niečo proti hlasu svojho svedomia, budeš to vlastne ty, kto svojho slabšieho brata, za ktorého tiež Kristus umrel, privedieš do záhuby. ");
INSERT INTO slk_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Prehrešovať sa takto proti bratom a útočiť na ich neisté svedomie znamená hrešiť proti samotnému Kristovi. ");
INSERT INTO slk_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ak by teda moje jedlo malo byť príčinou bratovho pádu, radšej sa toho jedla zrieknem, aby som ho nepriviedol k pádu do hriechu. ");
INSERT INTO slk_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Nie som vari slobodný? Či vari nie som apoštol Ježiša Krista? Či som sa vari nestretol s Ježišom, naším Pánom? Nie ste vari výsledkom toho, čo Pán cezo mňa vykonal? ");
INSERT INTO slk_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Ak ma aj niektorí nepovažujú za apoštola, pre vás ním som. Veď vy ste dôkazom, že som Pánovým apoštolom. ");
INSERT INTO slk_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Keď ma súdia, obhajujem sa takto: ");
INSERT INTO slk_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","„Či nemáme právo na jedlo a pitie za našu prácu? ");
INSERT INTO slk_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Nemáme právo brať so sebou veriacu manželku ako ostatní apoštoli a Ježišovi bratia či Peter? ");
INSERT INTO slk_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Prečo si iba ja a Barnabáš máme zarábať na živobytie? ");
INSERT INTO slk_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Či ste už videli vojaka, ktorý by slúžil v armáde za vlastné peniaze? Alebo hospodára, ktorý by nejedol hrozno z vinice, ktorú sám vysadil? Alebo niekoho, kto sa stará o stádo a nepije mlieko, ktoré získa? ");
INSERT INTO slk_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Myslíte, že sú to len moje vlastné myšlienky? Nehovorí to isté i Zákon?“ ");
INSERT INTO slk_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Veď v Mojžišovom zákone je napísané: „Nedáš náhubok volovi, ktorého používaš pri mlatbe.“ Keď dal Boh takýto príkaz, mal na mysli iba zvieratá? ");
INSERT INTO slk_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Netýka sa to vari aj nás? Áno, bolo to napísané aj pre nás: veď aj ten, kto orie, alebo ten, kto mláti, robia tak v nádeji, že budú mať podiel na úrode. ");
INSERT INTO slk_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Ak sme medzi vami rozsievali večné hodnoty, či nemáme právo očakávať, že budeme mať podiel na vašich všedných veciach? ");
INSERT INTO slk_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ak majú u vás toto právo iní, nemáme naň vari oveľa skôr nárok aj my? A napriek tomu sme toto svoje právo nikdy nevyužili: radšej budeme znášať biedu, len aby sme neboli prekážkou v šírení evanjelia o Kristovi. ");
INSERT INTO slk_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Alebo vari neviete že tí, ktorí konajú službu v chráme, dostávajú z chrámu svoje jedlo a tí, čo slúžia pri oltári, dostávajú svoj diel z obetí? ");
INSERT INTO slk_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Tak to ustanovil aj Pán, že tí, ktorí zvestujú evanjelium, majú mať z neho aj svoje živobytie. ");
INSERT INTO slk_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Napriek tomu som túto možnosť nikdy nevyužil a ani teraz to nepíšem preto, že by som sa niečoho takého dožadoval. Radšej by som zomrel, než by mal niekto zmariť to, na čo som bol až dosiaľ hrdý. ");
INSERT INTO slk_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Tým, že hlásam dobrú správu, sa však nechválim; je to moja povinnosť a beda mi, keby som evanjelium nezvestoval. ");
INSERT INTO slk_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Ak to robím z vlastného rozhodnutia, mám nárok na odmenu. Boh si ma však povolal a ja plním zverenú úlohu. ");
INSERT INTO slk_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Čo je teda mojou odmenou? Mám tú prednosť, že som sa rozhodol prinášať dobrú správu zadarmo a nevyužívať to, čo mi ako kazateľovi evanjelia právom patrí. ");
INSERT INTO slk_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","A tak, hoci som slobodný od všetkých, dobrovoľne som sa dal do služby všetkým, aby som čo najviac ľudí získal pre Krista. ");
INSERT INTO slk_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Aby som získal Židov, žil som medzi nimi ako Žid. Aby som získal tých, ktorí dbajú na ustanovenia Mojžišovho zákona, podriadil som sa im aj ja (hoci nimi už nie som viazaný). ");
INSERT INTO slk_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","A aby som získal tých, čo sú zákonu úplne vzdialení, bol som medzi nimi, akoby som aj ja bol bez zákona (hoci nežijem bez Božieho zákona – zaväzuje ma predsa zákon Kristov). ");
INSERT INTO slk_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Pre slabých som sa stal slabým, aby som získal slabých. Každému som sa snažil priblížiť na jeho úrovni, aby som aspoň niektorých zachránil. ");
INSERT INTO slk_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Ale k tomu všetkému ma vedie snaha, aby šírenie evanjelia napredovalo a aby som aj ja mohol mať podiel na jeho požehnaniach. ");
INSERT INTO slk_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Či neviete, že tí, ktorí bežia na pretekoch, bežia síce všetci, ale iba jeden môže dostať cenu? Bežte teda tak, aby ste ju získali! ");
INSERT INTO slk_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Každý pretekár sa potrebuje cvičiť v zdržanlivosti. Oni to robia preto, aby získali pozemské vavríny, nám však ide o večnú odmenu. ");
INSERT INTO slk_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Keď teda bežím, nie bez cieľa; keď bojujem, nie tak, akoby som bil do prázdna. ");
INSERT INTO slk_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Ale krotím svoje telo a cvičím ho v zdržanlivosti, aby sa nestalo, že by som druhým kázal, no sám zlyhal. ");
INSERT INTO slk_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Chcem bratia, aby ste pochopili, čo sa stalo našim otcom. Nad všetkými sa vznášal Boží oblak a všetci prešli cez more. ");
INSERT INTO slk_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Takto boli pokrstení v oblaku a mori ako Mojžišovi nasledovníci. ");
INSERT INTO slk_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Všetci sa sýtili tým istým duchovným pokrmom ");
INSERT INTO slk_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","a všetci pili z toho istého duchovného prameňa. Pili totiž z duchovnej skaly, ktorá ich stále sprevádzala, a tou skalou bol Kristus. ");
INSERT INTO slk_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","A predsa väčšina z nich Bohu radosť nespravila; ich mŕtve telá naplnili púšť. ");
INSERT INTO slk_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Nech sa nám stanú výstražným príkladom, aby sme netúžili po zlom ako oni. ");
INSERT INTO slk_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Preto nebuďte modlármi ako tí, o ktorých je napísané: „Urobili si veľkú slávnosť, jedli a pili a potom tancovali okolo zlatého teľaťa.“ ");
INSERT INTO slk_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ani sa neoddávajte smilstvu ako niektorí z nich, a za jediný deň ich zomrelo dvadsaťtritisíc. ");
INSERT INTO slk_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Nesnažte sa zistiť, ako ďaleko môžete zájsť vo svojom hriechu proti Pánovi ako tí na púšti a potom hynuli od uštipnutia hadov; ");
INSERT INTO slk_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ani nereptajte, ako to niektorí z nich robili a zahynuli rukou zhubcu. ");
INSERT INTO slk_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","To, čo sa im stalo, je akoby predobrazom a je to zapísané na naše napomenutie. Veď žijeme blízko času konca. ");
INSERT INTO slk_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Dávajte si pozor, aby ste nepadli; najmä tí, ktorí si myslia, že stoja pevne. ");
INSERT INTO slk_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Veď doteraz ste boli vystavení len obyčajným ľudským pokušeniam. Bohu však môžete dôverovať. Ak aj prídu skúšky, nedopustí, aby ste podľahli, ale ukáže vám z nich východisko a dá vám silu obstáť. ");
INSERT INTO slk_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Preto, moji milovaní, utekajte pred modloslužbou! ");
INSERT INTO slk_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Hovorím s vami ako s rozumnými ľuďmi. Urobte si svoj názor na to, čo hovorím: ");
INSERT INTO slk_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Je vari kalich požehnania, za ktorý ďakujeme, niečím iným, než našou účasťou na krvi Kristovej? Je vari chlieb, ktorý lámeme, niečím iným, než našou účasťou na Kristovom tele? ");
INSERT INTO slk_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","A keďže je jeden chlieb, hoci je nás veľa, tvoríme jedno telo, lebo všetci jeme z toho istého chleba. ");
INSERT INTO slk_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Pozrite sa na izraelský národ: Nespája vari tých, čo jedia obete, spoločná služba pri obetovaní Bohu? ");
INSERT INTO slk_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Čo tým chcem povedať? Že modla je bohom? Alebo mäso obetované modle má nejakú moc? ");
INSERT INTO slk_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Vôbec nie! Veď obete, ktoré pohania prinášajú, obetujú démonom, nie Bohu. Hovorím to, lebo nechcem, aby ste mali s démonmi čosi spoločné. ");
INSERT INTO slk_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Nemôžete sa predsa súčasne hlásiť k Bohu aj k zlým mocnostiam. ");
INSERT INTO slk_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Alebo chcete Boha vyprovokovať k prejavu žiarlivosti? Ste snáď mocnejší ako on? ");
INSERT INTO slk_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Áno, kresťanovi je všetko dovolené, ale nie všetko je na osoh. Všetko je dovolené, ale nie všetko slúži na dobro aj ostatným. ");
INSERT INTO slk_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Nikto nech nesleduje svoj vlastný prospech, ale dobro toho druhého. ");
INSERT INTO slk_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Všetko, čo sa predáva u mäsiarov, pokojne jedzte a nezaťažujte svoje svedomie zbytočne tým, či to náhodou nebolo obetované modlám. ");
INSERT INTO slk_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Lebo: „Pánova je zem, i všetko, čo je na nej.“ ");
INSERT INTO slk_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","A keď vás pozve neveriaci na návštevu a rozhodnete sa tam ísť, jedzte s pokojným svedomím všetko, čo vám predloží a nezisťujte pôvod toho jedla. ");
INSERT INTO slk_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Keď vás však niekto upozorní, že to jedlo bolo obetované pohanským božstvám, nejedzte to kvôli tomu, ktorý vám to oznámil a jeho svedomiu. ");
INSERT INTO slk_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Áno, mám na mysli jeho svedomie, nie vaše. Prečo by mala byť moja sloboda obmedzená cudzím svedomím? ");
INSERT INTO slk_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Či ma niekto môže odsudzovať za to, čo vďačne prijímam z Božej ruky? ");
INSERT INTO slk_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Všetko, čo robíme – či už je to jedenie, či pitie, alebo čokoľvek iné – všetko má slúžiť na Božiu oslavu. ");
INSERT INTO slk_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Nebuďte preto pohoršením ani Židom, ani pohanom, ani kresťanom. ");
INSERT INTO slk_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Aj ja sa vždy usilujem vyjsť každému v ústrety a nesledujem svoj prospech, ale dobro tých druhých, aby ich bolo zachránených čo najviac. ");
INSERT INTO slk_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Nasledujte môj príklad, ako aj ja nasledujem Krista. ");
INSERT INTO slk_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Inak vás musím pochváliť, že na mňa nezabúdate a držíte sa toho, čo som vás naučil. ");
INSERT INTO slk_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Bol by som však rád, keby ste pochopili, že hlavou každého muža je Kristus, hlavou ženy je jej manžel a hlavou Krista je Boh. ");
INSERT INTO slk_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Každý muž, ktorý sa modlí alebo prorokuje so zakrytou hlavou, zneuctieva svoju hlavu – Krista. ");
INSERT INTO slk_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","A každá žena, ktorá sa modlí alebo prorokuje s nezakrytou hlavou, zneuctieva toho, kto je jej hlavou; je to, akoby si dala vyholiť svoju hlavu. ");
INSERT INTO slk_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Keď si teda žena nezahaľuje hlavu, môže si rovno ostrihať vlasy. Ak to však považuje za potupu, nech sa radšej zahaľuje. ");
INSERT INTO slk_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Muž si nemá zakrývať hlavu, lebo je obrazom Boha a jeho charakteru a žena je mužovou pýchou ");
INSERT INTO slk_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Veď nebol stvorený muž zo ženy, ale žena z muža. ");
INSERT INTO slk_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","A preto bola žena stvorená pre muža, nie muž pre ženu. ");
INSERT INTO slk_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Z tohto dôvodu – a tiež kvôli anjelom – má mať žena na svojej hlave znamenie autority. ");
INSERT INTO slk_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Ale ak žijeme v Kristovi, potom žena nie je nezávislá od muža a ani muž nie je nezávislý od ženy. ");
INSERT INTO slk_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Veď ako žena pochádza z muža, tak sa aj muž rodí zo ženy, ale všetko pochádza od Boha. ");
INSERT INTO slk_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Sami teda posúďte, či sa patrí, aby sa žena modlila k Bohu s neprikrytou hlavou. ");
INSERT INTO slk_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Či nie je všeobecným pravidlom, že keď má muž dlhé vlasy, nepridáva mu to na vážnosti, ");
INSERT INTO slk_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","pričom ženu dlhé vlasy ctia? Veď jej boli dané ako závoj. ");
INSERT INTO slk_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Ale ak by sa o tom chcel niekto škriepiť, nech vie, že nič podobné nemáme vo zvyku ani my, ani ostatné Božie zbory. ");
INSERT INTO slk_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Keď už vám dávam tieto príkazy, nemôžem vás pochváliť za to, že vaše spoločné stretnutia sú vám skôr na škodu, než na prospech. ");
INSERT INTO slk_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Počul som, a niečo pravdy na tom asi bude, že keď sa ako spoločenstvo veriacich stretávate, sú medzi vami roztržky. ");
INSERT INTO slk_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Takéto rozdelenie je dobré akurát tak na to, aby sa ukázalo, kto to myslí s Bohom naozaj vážne. ");
INSERT INTO slk_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ale vaše spoločné stolovanie sa potom nemôže nazývať večera Pánova. ");
INSERT INTO slk_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Každý sa ponáhľa, aby zjedol a vypil, čo si sám priniesol, a tak sa niektorí prejedajú, ba aj sa pripijú, kým iní zostávajú hladní. ");
INSERT INTO slk_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","To sa nemôžete najesť doma? Alebo chcete znevážiť Božiu cirkev a ponížiť chudobných? Za to vás naozaj nemôžem chváliť. ");
INSERT INTO slk_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Ja som vám predsa odovzdal, čo mi Pán zveril: V tú noc, keď bol Pán Ježiš zradený, vzal chlieb, ");
INSERT INTO slk_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","poďakoval zaň Bohu, lámal ho a povedal: „Toto je moje telo, ktoré sa obetuje za vás. To robte na moju pamiatku.“ ");
INSERT INTO slk_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Podobne po večeri zdvihol kalich a povedal: „Tento kalich je nová zmluva medzi Bohom a vami, spečatená mojou krvou. Robte to na moju pamiatku, kedykoľvek budete z neho piť.“ ");
INSERT INTO slk_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Vždy, keď takto spoločne budete jesť a piť, zvestujete Pánovu smrť až do jeho príchodu. ");
INSERT INTO slk_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Preto ak niekto je tento chlieb a pije z kalichu Pánovho ľahkovážne, znevažuje obeť Kristovu a berie tak na seba spoluvinu za jeho smrť. ");
INSERT INTO slk_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Skúmajte teda každý sám seba a až potom nech je z toho chleba a pije z kalicha. ");
INSERT INTO slk_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Lebo kto si pritom neuvedomí, že tu ide o telo Pána Ježiša, je a pije na vlastné odsúdenie. ");
INSERT INTO slk_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Preto je u vás toľko chorých, slabých a niektorí umierajú. ");
INSERT INTO slk_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Keby sme boli ochotní posúdiť samých seba, neboli by sme súdení. ");
INSERT INTO slk_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Ale keď nás súdi Pán, chce nám tým pomôcť, aby nás potom nemusel odsúdiť s ostatným svetom. ");
INSERT INTO slk_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Preto vás prosím, bratia, aby ste pri spoločných stretnutiach čakali, až sa zídete všetci a až potom jedli. ");
INSERT INTO slk_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Kto by nemohol vydržať od hladu, nech sa naje doma, aby vaše stretnutia neboli dôvodom na odsúdenie. Ostatné zariadim, keď prídem. ");
INSERT INTO slk_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Čo sa týka duchovných darov, bol by som nerád, aby ste v tej veci nemali jasno. ");
INSERT INTO slk_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Sami viete, že keď ste ešte boli neveriaci, uctievali ste mŕtve a nemé modly, ku ktorým vás to ťahalo. ");
INSERT INTO slk_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Preto vám oznamujem, že nikto, koho vedie Boží Duch, nepohŕda Kristom. A Ježiša ako svojho Pána vyznáva len ten, koho vedie Svätý Duch. ");
INSERT INTO slk_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Je mnoho rozmanitých obdarovaní, ale Duch je ten istý. ");
INSERT INTO slk_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Je mnoho rôznych spôsobov služby, ale Pán je stále ten istý. ");
INSERT INTO slk_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Je mnoho rôznych prejavov moci, ale Boh je ten istý a on to všetko pôsobí. ");
INSERT INTO slk_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Každému človeku je daný zvláštny prejav Ducha na spoločný úžitok. ");
INSERT INTO slk_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Jednému Boží Duch dáva slovo múdrosti, inému dáva ten istý Ducha slovo poznania. ");
INSERT INTO slk_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Ďalšiemu dáva ten istý Duch zvláštny dar viery, inému schopnosť uzdravovať v tom istom Duchu. ");
INSERT INTO slk_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Niekomu zasa dáva schopnosť konať zázraky, ďalšiemu prorokovať, niekomu možnosť rozlišovať duchov, niekomu rôzne druhy jazykov a inému schopnosť tlmočiť tieto jazyky. ");
INSERT INTO slk_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","To všetko je dielom jedného a toho istého Ducha, ktorý rozdeľuje každému jednotlivo podľa svojej vôle. ");
INSERT INTO slk_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Veď s Kristom je to tak, ako s telom, ktoré je síce jedno, ale skladá sa z mnohých častí a tie, hoci ich je veľa, tvoria spolu jeden celok. ");
INSERT INTO slk_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Tak aj každý z nás – Žid alebo pohan, otrok alebo slobodný občan – bol pokrstený do jedného spoločného tela prostredníctvom jedného Ducha a všetci sme sa napili z toho istého Ducha. ");
INSERT INTO slk_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Telo predsa nie je jediný orgán, má mnoho častí. ");
INSERT INTO slk_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Ak by noha povedala: „Ja nepatrím k telu, lebo nie je ruka“, neznamená to, že by prestala patriť k telu. ");
INSERT INTO slk_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Alebo keby ucho povedalo: „Ja nepatrím k telu, keď nie som oko“, či preto prestane byť časťou tela? ");
INSERT INTO slk_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Veď keby celé telo bolo okom, ako by mohlo počuť? A keby celé bolo uchom, kde by bol čuch? ");
INSERT INTO slk_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Boh však dal do tela rôzne orgány a každému z nich určil jeho úlohu podľa svojho uváženia. ");
INSERT INTO slk_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Keby bolo všetko tvorené jediným orgánom, kde by bolo telo? ");
INSERT INTO slk_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Takto máme mnoho rozličných orgánov, ale všetky dovedna tvoria jedno telo. ");
INSERT INTO slk_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Oko nemôže povedať ruke: „Nepotrebujem ťa!“, ani hlava nohám: „Zaobídem sa bez vás!“ ");
INSERT INTO slk_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Skôr naopak: práve tie zdanlivo podradné orgány sú nenahraditeľné ");
INSERT INTO slk_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","a práve tým častiam tela, ktoré pokladáme za menejcenné, venujeme najväčšiu pozornosť a tie, ktoré považujeme za neslušné, zaodievame zvlášť pozorne – ");
INSERT INTO slk_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","na rozdiel od ostatných častí tela. Boh ustrojil naše telo tak, aby sa prehliadaným častiam dostalo viac pozornosti. ");
INSERT INTO slk_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","To preto, aby v tele nedochádzalo k hádkam, ale aby sa jednotlivé časti o seba navzájom starali. ");
INSERT INTO slk_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Keď trpí jeden orgán, trpia spolu s ním aj všetky ostatné. Keď je jeden z nich vyznamenaný, radujú sa s ním všetky. ");
INSERT INTO slk_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Vy ste Kristovo telo a každý z vás je časťou jeho tela. ");
INSERT INTO slk_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","V cirkvi Boh ustanovil ako prvých apoštolov, druhých prorokov, tretích učiteľov, ďalej dal moc konať obdivuhodné činy, potom schopnosť uzdravovať, dar pomáhať, dar spravovať cirkev či hovoriť rôznymi jazykmi. ");
INSERT INTO slk_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Vari sme všetci apoštolmi? Sú všetci prorokmi či učiteľmi? Majú všetci moc robiť zázraky? ");
INSERT INTO slk_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Všetci majú dar uzdravovať? Všetci hovoria rôznymi jazykmi a všetci ich vedia vykladať? ");
INSERT INTO slk_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Usilujte sa dosiahnuť oveľa dôležitejšie dary. Chcem vám však ukázať oveľa lepšiu cestu. ");
INSERT INTO slk_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Ak hovorím jazykmi ľudskými i anjelskými, ale lásku nemám, som iba cvendžiaci zvon a duniaci gong. ");
INSERT INTO slk_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ak mám dar prorokovať, rozumieť všetkým tajomstvám a každej múdrosti a ak mám takú veľkú vieru, že môžem aj vrchy prenášať, ale lásku nemám, nie som ničím. ");
INSERT INTO slk_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Ak rozdám všetok svoj majetok, aby som nasýtil chudobných, keď sa dám pre vieru hoc aj upáliť, ale lásku nemám, nič mi to neosoží. ");
INSERT INTO slk_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Láska je trpezlivá, láska je vľúdna, nezávidí. Láska sa nevystatuje a nie je domýšľavá, ");
INSERT INTO slk_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","nekoná nečestne, neusiluje sa o vlastný prospech, nie je zlostná, nespomína na krivdy, ");
INSERT INTO slk_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","neraduje sa zlým veciam, ale teší sa z pravdy. ");
INSERT INTO slk_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Všetko znáša, za každých okolností verí, má nádej a všetko vydrží. ");
INSERT INTO slk_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Láska nikdy neprestáva, no proroctvá pominú, jazyky umĺknu, poznanie sa rozplynie. ");
INSERT INTO slk_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Veď všetky naše vedomosti sú neúplné a všetko prorokovanie čiastočné. ");
INSERT INTO slk_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Keď ich miesto zaujme dokonalosť, všetko neúplné sa pominie. ");
INSERT INTO slk_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Kým som bol dieťaťom, hovoril som ako dieťa, premýšľal som ako dieťa, uvažoval som ako dieťa. Keď som však dospel, zanechal som všetko detské. ");
INSERT INTO slk_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Teraz vidíme len čosi ako zahmlený obraz v zrkadle, ale potom uvidíme tvárou v tvár. Zatiaľ poznám iba čiastočne, potom však budem poznať v plnosti tak, ako Boh pozná mňa. ");
INSERT INTO slk_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Teraz zostávajú tri veci: viera, nádej a láska. Ale najväčšia z nich je láska. ");
INSERT INTO slk_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Nech vám teda záleží na láske. O duchovné dary sa tiež usilujte, ale predovšetkým, aby ste prorokovali. ");
INSERT INTO slk_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Keď niekto hovorí neznámym jazykom, nehovorí to ľuďom, ale Bohu; nikto mu nerozumie a tak to, čo pod vplyvom Ducha hovorí, zostáva tajomstvom. ");
INSERT INTO slk_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Ak však niekto prehovorí zrozumiteľne, je to pre jeho poslucháčov posilnením, povzbudením a potešením. ");
INSERT INTO slk_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Neznámy jazyk má význam len pre toho, kto ním hovorí, kým zvestovanie Božej vôle buduje kresťanské spoločenstvo. ");
INSERT INTO slk_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Prajem si, aby ste všetci hovorili inými jazykmi, ale dávam prednosť tomu, aby ste prinášali zrozumiteľné posolstvo. Ten, kto prináša zrozumiteľné posolstvo, je dôležitejší než ten, kto hovorí v jazykoch; veď takéto hovorenie môže byť cirkvi na úžitok, len ak to niekto aj vysvetlí. ");
INSERT INTO slk_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Bratia, aký úžitok by ste mali z toho, keby som k vám prišiel a hovoril v rôznych jazykoch, ale nepriniesol by som žiadne odhalenie, ani poznanie, ani zrozumiteľné posolstvo od Boha, ani poučenie? ");
INSERT INTO slk_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Podobne ako neživé hudobné nástroje ako flauta či harfa musia hrať tóny čisto, inak by nikto nerozoznal melódiu. ");
INSERT INTO slk_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","A keby trúbka vydala nejasný zvuk, kto v tom rozozná signál do boja? ");
INSERT INTO slk_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Tak je to aj s vami: ak vaša reč nie je zrozumiteľná, ako ľudia zistia, čo hovoríte? Budete hovoriť len do vetra. ");
INSERT INTO slk_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Na svete sa hovorí najrôznejšími jazykmi a každému z nich sa dá rozumieť. ");
INSERT INTO slk_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Ak však niekto bude hovoriť jazykom, ktorému nerozumiem, budeme si navzájom cudzincami – ja pre neho a on pre mňa. ");
INSERT INTO slk_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Keď ste takí horliví v získavaní duchovných darov, usilujte sa o také dary, ktoré pomáhajú budovať cirkev. ");
INSERT INTO slk_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Preto ten, kto hovorí neznámym jazykom, nech sa modlí, aby to vedel aj vyložiť. ");
INSERT INTO slk_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Keď sa totiž niekto modlí takým jazykom, jeho duch sa síce modlí, ale jeho myseľ z toho nemá žiadny úžitok. ");
INSERT INTO slk_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Nuž čo robiť? Budem sa modliť duchom aj mysľou, budem spievať „duchom“, ale aj „mysľou“. ");
INSERT INTO slk_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Ako by mohol obyčajný človek pripojiť svoje amen k modlitbe, keby nevedel, čo si hovoril? ");
INSERT INTO slk_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Áno, ty krásne ďakuješ, ale iný z toho nič nemá. ");
INSERT INTO slk_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Som vďačný Bohu, že hovorím jazykmi väčšmi než ktokoľvek z vás, ");
INSERT INTO slk_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ale v zhromaždení poviem radšej päť zrozumiteľných slov, ktoré ostatných poučia, než tisíce slov v nezrozumiteľnom jazyku. ");
INSERT INTO slk_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Bratia, nebuďte detinskí. Nech je vám zlo cudzie ako bábätkám, ale inak myslite ako dospelí ľudia. ");
INSERT INTO slk_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","V Písme sa hovorí: „Budem sa tomuto ľudu prihovárať inými jazykmi a ústami cudzincov, ale ani tak ma nebudú poslúchať,“ hovorí Pán. ");
INSERT INTO slk_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Jazyky sú znamením nie pre veriacich, ale pre neveriacich, proroctvo nie je pre neveriacich, ale pre veriacich. ");
INSERT INTO slk_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Keď sa všetci zídete ako spoločenstvo veriacich a každý z vás bude hovoriť cudzím jazykom a príde medzi vás nezasvätený alebo neveriaci človek, nepovie vari, že ste sa pomiatli? ");
INSERT INTO slk_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","No keď všetci budete zrozumiteľne hovoriť Božiu pravdu a príde niekto nezasvätený alebo neveriaci, to, čo počuje, ho bude usvedčovať z hriechu a odsudzovať. ");
INSERT INTO slk_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Najavo vyjdú jeho najtajnejšie myšlienky, takže padne na kolená, pokorí sa pred Bohom a vyzná: „Naozaj je Boh s vami!“ ");
INSERT INTO slk_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Čo z toho vyplýva, bratia? Keď sa zídete, jeden poslúži chválospevom, druhý slovami učenia či zjavením od Boha, iný svedectvom v cudzom jazyku ďalší jeho výkladom. Všetko má však slúžiť na spoločný rast všetkých. ");
INSERT INTO slk_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Ak niekto hovorí cudzím jazykom, nech hovoria najviac dvaja alebo traja, ale jeden po druhom, a zároveň nech to niekto vysvetľuje. ");
INSERT INTO slk_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Ak sa nenájde vykladač, nech taký človek počas zhromaždenia mlčí a nech hovorí len sebe a Bohu. ");
INSERT INTO slk_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Tí, ktorí dostali proroctvo, nech tiež hovoria len dvaja alebo traja, ostatní nech o tom uvažujú. ");
INSERT INTO slk_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ak Boh odhalí niečo ďalšiemu z prítomných, kým druhý ešte hovorí, treba mu dať slovo. ");
INSERT INTO slk_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Tak môže proroctvo tlmočiť každý, kto má ten dar, a pre všetkých to bude slúžiť na poučenie a povzbudenie. ");
INSERT INTO slk_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Veď kto hovorí z Božieho poverenia, vie sa aj ovládať. ");
INSERT INTO slk_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Boh nemá rád zmätok, je Bohom pokoja. Tak sa to deje vo všetkých zhromaždeniach kresťanov. ");
INSERT INTO slk_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Ženy vo vašom zhromaždení nech mlčia – nie je im dovolené hovoriť. Majú sa podriaďovať, ako im to prikazuje aj Zákon. ");
INSERT INTO slk_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Ak sa chcú na niečo opýtať, nech im to doma vysvetlí manžel. Nie je vhodné, aby žena hovorila v zhromaždení. ");
INSERT INTO slk_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Zdá sa vám, že posolstvo od Boha pochádza od vás? Alebo máte pocit, že ste jediní, kto ho obdržal? ");
INSERT INTO slk_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Ak niekto z vás tvrdí, že je obdarený slovom od Boha, alebo má iné dary Božieho Ducha, mal by tým skôr poznať, že to, čo vám hovorím, je Pánov príkaz. ");
INSERT INTO slk_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Kto to odmieta uznať, sám nemá nárok na uznanie. ");
INSERT INTO slk_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Tak teda, milí bratia, proste Boha o to, aby ste mohli hlásať jeho pravdy a nebráňte hovoriť ani cudzí