﻿USE sofia;
DROP TABLE IF EXISTS sofia.sle_vpl;
CREATE TABLE sle_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sle_vpl WRITE;
INSERT INTO sle_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ಯೆಸು ಕ್ರಿಸ್ತನು ಖಾಂದಾನ. ತೆ ದಾವಿದನಾ ಖಾಂದಾನನೊ ವ್ಹೈ. ದಾವಿದ ಅಬ್ರಹಾಮನಾ ಖಾಂದಾನನೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ಅಬ್ರಹಾಮ ಇಸಾಕನೊ ಬಾ ವ್ಹೈ. ಇಸಾಕ ಯಾಕೊಬನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಯಾಕೊಬ ಯಹುದನೆ ವರಿ ತಿನಾ ಭಾಯೊನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ಯೆಹುದ ತಾಮಾರಳಮಾ ಪೆರೆಚನನೆ ಬಿ ಜೆರಹನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಪೆರೆಚನ ಹೆಚ್ರೊನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ಹೆಚ್ರೊನ ಅರಾಮನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಅರಾಮ ಅಮ್ಮಿನಾದಾಬನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಅಮ್ಮಿನಾದಾಬ ನಹಶೊನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ನಹಶೊನ ಸಲ್ಮೊನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ಸಲ್ಮೊನ ರಾಹಾಬಳಮಾ ಬೊವಜನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಬೊವಜನ ರುತಳಮಾ ಓಬೆದನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಓಬೆದ ಇಷಯನನೆ ಪಡದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ಇಷಯನ ರಾಜೊ ಥಯಲ ದಾವಿದನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ದಾವಿದ ಉರಿಯನನಿ ಬೈಕೊ ಥಯಲವಾಲಿಮಾ ಸೊಲೊಮೊನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ಸೊಲೊಮೊನ ರೆಹಬ್ಬಾಮನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ರೆಹಬ್ಬಾಮ ಅಬಿಯನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಅಬಿಯನ ಆಸನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ಆಸನ ಯೆಹೊಷಾಫಾಟನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಯೆಹೊಷಾಫಾಟನ ಯೆಹೊರಾಮನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಯೆಹೊರಾಮ ಉಜ್ಜಿಯನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ಉಜಜಿಯನ ಯೊತಾಮನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಯೊತಾಮ ಆಹಾಜನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಆಹಾಜನ ಹಜ್ಕಿಯನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ಹಿಜ್ಕಿಯನ ಮನಸ್ಸೆಯನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಮನಸ್ಸೆಯ ಆಮೊನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ಆಮೊನ ಯೊಷಿಯನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಮನಕ್ಹೊ ಬಾಬೆಲನೆ ಧರಿಲಿನ ಮಯಲ ಟೈಮಮಾ ಯೊಷಿಯನ ಯೆಕೊನ್ಯನೆ ವರಿ ತಿನಾ ಭಾಯೊನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ಬಾಬೆಲನೆ ಧರಿಲಿನ ಗಯಲ್ಪರ ಯೆಕೊನ್ಯನ ಶೆಯಲ್ತಿಯನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಷೆಯಲ್ತಿಯನ ಜೆರುಬಾಬೆಲನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ಜೆರುಬಾಬೆಲ ಅಬಿಹೊದನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಅಬಿಹೊದನ ಎಲ್ಯಕಿಮನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಎಲ್ಯಕಿಮನ ಅಜೊ಼ರನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ಅಜೊ಼ರನ ಸದೊಕನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಸದೊಕ ಅಖಿಮನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಅಖಿಮ ಎಲಿಹೊದನನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ಎಲಿಹೊದನ ಎಲಿಯಾಜರನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಎಲಿಯಾಜರ ಮತ್ತಾನನೆ ಪಡ್ದಿಲದ್ಯೊ. ಮತ್ತಾನ ಯಾಕೊಬನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ಯಾಕೊಬ ಮರಿಯಳನೊ ಮಟಿ ಥಯಲ ಯೊಸೆಫನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಎಜ ಮರಿಯಳಮಾ ಕ್ರಿಸ್ತ ಕವಾಲೊ ಯೆಸು ಹುಟ್ಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ಇಮ್ಮ ಅಬ್ರಹಾಮತು ದಾವಿದಲಕ್ಕಾ ವಟ್ಟಜ ಚೌದಾ ತಲೆಮಾರೊ ವ್ಹೈ. ದಾವಿದ ಪೈಲಾ ಥೈನ ಬಾಬೆಲನೆ ಧರಲಿನ ಗಯೆಲಕ್ಕಾ ಚೌದಾ ತಲೆಮಾರೊ ವ್ಹೈ. ಬಾಬೆಲನೆ ಧರಿಲಿನ ಗಯೆಲ ಟೈಮತಾ ಕ್ರಿಸ್ತ ಲಕ್ಕಾ ಚೌದಾ ತಲೆಮಾರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ಯೆಸು ಕ್ರಿಸ್ತ ಕಿಮ್ಮ ಹುಟ್ಯೊ ಕದ್ಯಾಮ ತಿನಿ ಯಾ ಥಯಲ ಮರಿಯಳನೆ ಯೊಸೆಫನಾ ಕ್ಹಾತೆ ನಾತ್ರು ಥಯುತು ತ್ಯುನೆ ಮಳಾತಿ ಪೈಲಾ ತೆ ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹು ಪೆಟೆ ವ್ಹತ್ತಿ ಕೈನ ಗ್ವತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ತೆನೈಸೊ ತಿನೊ ಮಾಟಿ ಥಯಲ ಚೊ಼ಕೊ ಮನಕ್ಹ ರ‍್ಹಯಲಕ್ಹು ತೆ ವಾತ ಕಿನೆ ಕವಾನೆ ಮನಸ ನೈ ರ‍್ಹಯಲಕ್ಹು, ಕಿನೆಜ ಗ್ವತ್ತ ವಾಚಿ ತಿನೆ ಚ್ಹೊಡಿಪಡು ಕೈನ ಕರ‍್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ತೆ ಎ ವಿಚಾರ ಕರಾನಾ ಟೈಮಮಾ ಪ್ರಭುನೊ ಧುತ ಕ್ಹಪನಮಾ ದಿಕ್ಹಿನ ಎ ಯೊಸೆಫ, ದಾವಿದನಾ ಖಾಂದಾನವಾಲಾ, ತಾರಿ ಬೈಕೊ ಥಯಲ ಮರಿಯಳನೆ ಹಿವಾ ಕರಿಲಿವಾನೆ ಬುಚ್ಕುನಕೊ. ತೆ ಪೆಟೆ ರ‍್ಹಯಲ ಪವಿತ್ರಾತ್ಮಾಕ್ಹುಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ತೆ ಯಕ್ಕ ಪಟ್ಟಾನೆ ಜನ್ನಸ; ತು ತಿನೆ ಯೆಸು ಕೈನ ನಾಮ ಮ್ಹೆಲು; ಕಾ ಕದ್ಯಾಮ ಎಜ ತಿನಾ ಮನಕ್ಹೊನೆ ತ್ಯುನಾ ಪಾಪೊಕ್ಹು ಚೊಡೈನ ವಚಾಡಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ಪ್ರಭು ಪ್ರವಾದಿನಾ ಮೂಲಕ ಕದಲ ವಾತ ಪುರಾ ಥಾವಾನಾ ಹುತಿ ಎ ಕ್ಹಾರು ಥಯು; ತೆ ವಾತ ಸು ವ್ಹೈ ಕದ್ಯಾಮ- ");
INSERT INTO sle_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ದೆಕ, ಯಕ್ಕ ಜಾಂಜಿಮಾನ ಛೊಕ್ರಿ ಪೆಟೆ ರ್‍ಹೈನ ಪಟ್ಟಾನೆ ಜನ್ನಸ; ತಿನೆ ಇಮ್ಮಾನುವೆಲ ಕೈನ ನಾಮ ಮ್ಹೆಲಸ ಕವಾನು ವ್ಹೈ. ಕ್ಹುದಾ ಅಪ್ನಾ ಕ್ಹಾತೆ ಛೆ ಕೈನ ಎ ನಾಮನು ಮತಲಬ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ತೆಳಾಮಾ ಯೊಸೆಫ ನಿಂದರಮಾತೊ ಉಟಿನ ಪ್ರಭುನೊ ಧುತ ಅಪಣೆ ದಿದಲ ತಿಮ್ಮ ತಿನಿ ಬೈಕೊನೆ ಹಿವಾ ಕರಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ತೆನೈಸೊ ಮರಿಯಳ ಪಟ್ಟಾನೆ ಜನ್ನೆಲಕ್ಕಾ ಯೊಸೆಫ ತಿನಾ ಕ್ಹಾತೆ ಶರಿರನಾ ಸಂಭಂದಕ್ಹು ನ್ಹೊತೊ. ಯೊಸೆಫ ತೆ ಪಟ್ಟಾನೆ ಯೆಸು ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ಹೆರೊದ ರಾಜೊ ಥಯಲ ಟೈಮಮಾ ಯೆಸು ಯುದಾಯನಾ ಬೆತ್ಲೆಹೆಮ ಕವಾನಾ ಗಾಮಮಾ ಹುಟ್ಯೊ. ಯೆಸು ಹುಟ್ಟಲ್ಪರ, ಪುರ್ವ ದೆಶನಾ ದಕ್ಹಾ ಗ್ಯಾನಿಯೊ ಯೆರುಸಲೆಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ತೆ ಗ್ಯಾನಿಯೊ ಮನಕ್ಹೊನೆ, ಯೆಹುದಿಯೊನೊ ರಾಜೊ ಹುಟ್ಯೊಸ ನೈ? ತೆ ಕಿಜಾ ಛೆ? ತೆ ಹುಟ್ಯೊಸ ಕೈನ ದೆಕಾಡಾನಿ ಚಿಕ್ಕಿ ಪುರ್ವ ದಿಕ್ಕಮಾ ಹುಟ್ಟಲ ದೆಕಿನ ತಿನೆ ಆರಾಧನಾ ಕರಾನೆ ಆಯಾಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ಯಹುದಿಯೊನಾ ಎ ನಯಾ ರಾಜಾ಼ನಿ ವಿಶಯ ಗ್ವತ್ತ ಥಯಲ್ಪರ ಹೆರೊದ ವರಿ ಯೆರುಸಲೆಮನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಗಲಿಬಿಲಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ತೆಳಾಮಾಜ಼, ಹೆರೊದ ಕ್ಹಾರ ಖಾಸ ಯಾಜಕೊನೆ ಶಾಸ್ತ್ರಿಯೊನೆ ಸಭೆ ಮಳೈನ ಕ್ರಿಸ್ತ ಹುಟ್ಟನಿ ಜ಼ಗಾ ಕೈ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ತ್ಯುನೆ, ಯುದಾಯನಾ ಬೆತ್ಲೆಹೆಮ ಕವಾನಾ ಗಾಮಮಾ ಹುಟ್ಟಸ. ಕಾ ಕದ್ಯಾಮ ಪ್ರವಾದಿ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಇಮ್ಮ ಬರದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ಯಹುದ ಸಿಮೆನಿ ಬೆತ್ಲೆಹೆಮ, ಯಹುದನಾ ಖಾಸ ಗಾಮೊಮಾ ತು ನಕ್ಕರಬಿ ನ್ಹಾನು ನ್ಹವೈ. ಯಕ್ಕ ಅದಿಪತಿ ತಾರಾಮಾತೊಜ ಆವಸ, ತೆ ಮಾರಾ ಮನಕ್ಹೊ ಥಯಲ ಇಸ್ರಾಯೆಲೊನೆ ಆಳಾಲೊ ವ್ಹೈ ಕವಾನು ಪ್ರವಾದಿನಾ ಮುಲಕ ಬರ್ದಲ ಛೆ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ತೆಳಾಮಾ ಹೆರೊದ ಪುರ್ವ ದಿಕ್ಕನಾ ದೆಶನಾ ಗ್ಯಾನಿಯೊನೆ ಚೊರಿಕ್ಹು ಬಲೈನ, ತ್ಯನೆ ತೆ ಚಿಕ್ಕಿನೆ ದೆಕಲ ಕರೆಕ್ಟ ಟೈಮ ತ್ಯುನೊಕಂತೊ ಗ್ವತ್ತ ಕರಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ಹೆರೊದ ತೆ ಗ್ಯಾನಿಯೊನೆ, ತುಮೆ ಗೈನ ಚೊಕಿತರಾ ಪುಚ್ಚಿಲಿನಿ ತೆ ಬಚ್ಚು ಕಜಾ ಶೆ ಕೈನ ಗ್ವತ್ತ ಥಯಲ್ಪರ ಐನ ಮನೆ ತಿಳಸಾವೊ. ತೆಳಾಮಾ ಮಿ ಗೈನ ತಿನೆ ಆರಾಧನಾ ಕರುಸ ತಿಮ ಕೈನ ತ್ಯುನೊನೆ ಬೆತ್ಲೆಹೆಮನೆ ವಳೈನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ತೆ ಗ್ಯಾನಿಯೊ ರಾಜಾ಼ನಿ ವಾತ ಐಕಿನ ತ್ಯಾಂತಾ ಗಯೆಲ್ಪರ, ಪುರ್ವ ದಿಕ್ಕಮಾ ಹುಟ್ಟಲ ಚಿಕ್ಕಿನೆ ವರಿ ದೆಕಯಾ. ತ್ಯುನೆ ತೆ ಚಿಕ್ಕಿನಾ ಪಾಚಾ಼ ಗಯಾ. ತೆ ಚಿಕ್ಕಿ ತ್ಯುನಾ ಅಗಿ ಜಾತಿ ಪಟ್ಟೊ ರ‍್ಹಯಲ ಜ಼ಗಾಪರ ಗೈನ ಹುಬ್ರೈ. ");
INSERT INTO sle_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ತ್ಯುನೆ ತೆ ಚಕ್ಕಿನೆ ದೆಕಿನ ಘನ್ನಾಕಿ ಕ್ಹುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ತ್ಯುನೆ ತೆ ಘರೆ ಆಯೆಲ್ಪರ, ಪಟ್ಟಾನೆ ಮರಿಯಳ ಕನ್ನ ದೆಕಿನ, ಸಾಷ್ಟಾಂಗ ಥೈನ ಆರಾಧನಾ ಕರ‍್ಯಾ ತೆನೈಸೊ ತ್ಯುನೆ ತೆ ಪಟ್ಟಾನಾ ಹುತಿ ಲಾಯೆಲ ಕಾಣಿಕೆ ಕಾಡಿನ ಕ್ಹೊನು, ಧುಪ ವರಿ ಬಾಸನಾ ದ್ರವ್ಯೊನೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ತೆನೈಸೊ ಕ್ಹುದಾ ತೆ ಗ್ಯಾನಿಯೊನಾ ಕ್ಹಪನ್ಮಾ ಐನ, ತುಮೆ ಹೆರೊದ ಕನ್ನಫರಿನ ಜೌ ನೈ ಕೈನ ಹುಶಾರ ಕರ‍್ಯೊ. ತ್ಯುನೆ ಬಿಜಿ ಯಕ್ಕ ಜ಼ಗಾನಾ ಮುಲಕ ತ್ಯುನಾ ದೆಶನೆ ಫರಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ಗ್ಯಾನಿಯೊ ಫರಿನ ಗಯೆಲ್ಪರ ಪ್ರಭುನೊ ದುತ ಯೊಸೆಫನೆ ಕ್ಹಪನ್ಮಾ ದಿಕ್ಹಿನಿ, ಉಟ್ಟ! ಬಚ್ಚಾನೆ ವರಿ ತಿನಿ ಯಾನೆ ಬಲೈಲಿನ ಇಜಿಪ್ಟನೆ ನ್ಹಾಟಿನ ಜಾ. ಹೆರೊದ ಬಚ್ಚಾನೆ ಹುಡ್ಕಾನು ಶುರು ಕರಸ. ತೆ ಬಚ್ಚಾನೆ ಕ್ಹಲಾಸ ಕರು ಕೈನ ಕೈಲಿದ್ಯೊಸ. ‘ಸುಜ ಕೆಟ್ಟ ನತ್ತಿ’ ಕೈನ ಮಿ ತುನೆ ಕದೆ ಲಕ್ಕಾ ತು ಇಜಿಪ್ಟಮಾ ರ‍್ಹೈನ” ಕೀನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ತೆಳಾಮಾಜ಼, ಯೊಸೆಫ ಉಟಿನ ಬಚ್ಚಾನೆ ವರಿ ತಿನಿ ಯಾನಾ ಕ್ಹಾತೆ ಇಜಿಪ್ಟನೆ ರಾತ್ನಾ ಟೈಮಮಾ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ಹೆರೊದ ಮರೆಲಕ್ಕಾ ಯೊಸೆಫ ಇಜಿಪ್ಟಮಾಜ ವ್ಹತ್ತೊ. ಮಿ ಮಾರಾ ದಿಕ್ರಾನೆ ಇಜಿಪ್ಟಮಾತೊ ಬಲಾಯೊ ಕೀನ ಪ್ರವಾದಿ ನಾ ಮುಲಕ ಪ್ರಭು ಕದಲ ವಾತ ಇನಾಕ್ಹು ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ಗ್ಯಾನಿಯೊ ತಿನೆ ಮೊಸ ಕರ‍್ಯಾಸ ಕೈನ ಗ್ವತ್ತ ಥಯಲ್ಪರ ಹೆರೊದ ಘನ್ನೊ ಶಿಟ್ಟ ಥಯೊ. ತೆಳಾಮಾ ಬಚ್ಚು ಉಟ್ಟಲ ಟೈಮ ಹೆರೊದ ಗ್ಯಾನಿಯೊಕ್ಹು ಗವ್ತ ಕರಿಲಿದ್ಯೊತೊ. ತೆ ಬಚ್ಚು ಹುಟ್ಟಿನ ಬೆ ವರಕ್ಹ ಥಯಾತಾ. ತಿನಾಹುತಿ ಹೆರೊದ ಬೆತ್ಲೆಹೆಮಮಾ ವರಿ ತಿನಾ ಆಜು಼ ಬಾಜುನಾ ಗಾಮೊಮಾ ರ‍್ಹಯಲ ಬೆ ವರಕ್ಹನಾ ವರಿ ತ್ಯುನಾತಿ ನ್ಹಾನಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಪಟ್ಟಾವೊನೆ ಕ್ಹಲಾಸ ಕರು ಕೈನ ಆಗನ್ಯಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ಅಮ್ಮ ಕ್ಹುದಾ ತಿನೊ ಪ್ರವಾದಿ ಥಯಲ ಯೆರೆಮಿಯನಾ ಮುಲಕ ಕದಲ ಎ ವಾತ ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ರಾಮಮಾ ಬೊಂಬಡ್ಯಾ ಮಾರಾನು ಐಕು ಐವು; ರುವಾನು ವರಿ ಘನ್ನು ಗೊಳಾಟ ಉಂಟ ಥಯು; ರಾಹೆಳ ತ್ಯುನಾ ಬಚ್ಚಾವೊನ ಹುತಿ ರ‍್ಹೈನ ತ್ಯನೆ ನೈ ರ‍್ಹಯಲಕ್ಹು ಸಮಾಧಾನ ಹೊಂದಿಲಿದ್ಯಾವಾಚಿ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ಹೆರೊದ ಮರಲ್ಪರ, ಪ್ರಭನೊ ದುತ ಯೊಸೆಫನೆ ಕ್ಹಪನ್ಮಾ ದಿಕ್ಹಿನ. ಯೊಸೆಫ ಇಜಿಪ್ಟಮಾ ರ‍್ಹತಾಮಾಜ಼ ಆ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ಕ್ಹುದಾನೊ ದುತ ತಿನೆ, ಉಟ್ಟ! ಪಟ್ಟಾನೆ ವರಿ ತಿನಿ ಯಾನೆ ಬಲೈಲಿನ ಇಸ್ರಾಯೆಲನೆ ಜಾ. ಪಟ್ಟಾನೆ ಕ್ಹಲಾಸ ಕರು ಕೈನ ಪರಯತ್ನ ಕರಾಲಾ ಮರಿ ಗಯಾಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ತಿನಾಹುತಿ ಯೊಸೆಫ ಪಟ್ಟಾನೆ ವರಿ ಪಟ್ಟಾನಿ ಯಾನೆ ಬಲೈಲಿನ ಇಸ್ರಾಯೆಲನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ತೆನೈಸೊ ಹೆರೊದ ಮರಲ್ಪರ ತಿನೊ ದಿಕ್ರೊ ಥಯಲ ಅರ್ಖೆಲಾಯ ಯುದಾಯನೊ ರಾಜೊ ಥಯೊಸ ಕರಿನ ಕವಾನು ಐಕಿನ ತ್ಯಾ ಜಾ಼ವಾನೆ ಭುಚ್ಚಕ್ಯೊ. ಕ್ಹಪನ್ಮಾ ದಿದಲ ಹುಶಾರಕಿ ಲಿಂಗತಜ ತೆ ತೆ ಜ಼ಗಾನೆ ಛೊಡಿನ ಗಲಿಲಾಯ ಗಾಮನೆ ಗೈನ, ");
INSERT INTO sle_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ನಜರೆತ ಕವಾನಾ ಗಾಮ್ಮಾ ರ‍್ಹಯಲೊ. ಕ್ರಿಸ್ತನನೆ ‘ನಜ಼ರೆತನೊ’ ವ್ಹೈ ಕೈನ ಬಲಾವಸ” ಕೈನ ಕ್ಹುದಾ ಪ್ರವಾದಿಯೊನಾ ಮುಲಕ ಕದಲ ಅಮ್ಮ ಪುರಾ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ತೆ ಕಾಲಮಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾಲೊ ಯೊಹಾನ ಯುದಾಯನಾ ರಾನ್ಮಾ ಬೊದನೆ ಕವಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ಸ್ವರ್ಗನೊ ರಾಜ್ಯ ನಜಿಕ ಆಯೊಸ. ತುಮೆ ತುಮಾರಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡ್ದಿನ ಕ್ಹುದಾಕನ ಫರೊ” ಕೈನ ತೆ ಬೊದನೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ಪ್ರಭುನಾ ಹುತಿ ವಾಟ ತಯ್ಯಾರ ಕರೊ; ತಿನಿ ವಾಟ ಸಿದಾ ಚೊ಼ಕಿ ಕರೊ ಕೈನ ರಾನ್ಮಾ ಅಡ್ಡಾಲಾನಿ ಆವಾಜ ಐಕು ಆವಾಡುಸ. (ಯೆಶಾಯ 40:3) ಕೈನ ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾಲಾ ಯೊಹಾನನಾ ಹುತಿ ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಕದಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ಯೊಹಾನನಾ ವಣ್ಣಾ ಹುಂಟಾನಾ ಬಾಲೊಕ್ಹು ಕರಲ ವ್ಹತ್ತಾ. ತಿನೆ ಕಂಬರನೊ ಪಟ್ಟೊ ವ್ಹತ್ತೊ. ತಿನೆ ಫಿರಕಾ ವರಿ ರಾನನು ಜೆನ ಅನ್ನ ಲಿಂಗತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ಮನಕ್ಹೊ ಯೊಹಾನನು ಉಪದೆಶ ಐಕಾನೆ ಯೆರುಸಲೆಮತಾ, ಯುದಾಯ ವರಿ ಯೊರ್ದನ ನದಿನಾ ಬಗಲ ದಂಡಿಕನ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಜ಼ಗಾತಾ ಆವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ಮನಕ್ಹೊ ತ್ಯುನೆ ಕರಲ ಪಾಪ ವಪ್ಪಿ ಲಿದಲ್ಪರ ಯೊಹಾನ ತ್ಯುನೊನೆ ಯೊರ್ದನ ನದಿಮಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ಘನ್ನಾ ಫರಿಸಾಯರೊ ವರಿ ಸದ್ದುಕಾಯರೊ ಯೊಹಾನನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮಾ ಕರೈಲಿವಾನಾ ಹುತಿ ಆಯಾ. ಯೊಹಾನ ತ್ಯುನೊನೆ ದೆಕಿನ, ತುಮೆ ಕ್ಹಾರಾ ಕ್ಹಾಪೊ ವ್ಹೈ! ಆವಾನೆ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ಶಿಟ್ಟಕ್ಹು ವಾಚಾನೆ ತುಮೊನೆ ಹುಶಾರಕಿ ದಿದಲವಾಲು ಕುನ್ನ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ತುಮಾರು ಮನಸ ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುದಾ ಬಗಲ ಛೆ ಕೈನ ಕವಾನು ತುಮೆ ಕರಾನಾ ಕಾಮೊಕ್ಹು ದೆಕಾಡೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘ಅಬ್ರಹಾಮ ಅಪ್ನೊ ಬಾ ವ್ಹೈ’ ಕೈನ ತುಮೆ ಸ್ವಕ್ಕ ಕರಾನು ಕಾ? ಕ್ಹುದಾ ಅಬ್ರಹಾಮನಾ ಹುತಿ ನ್ಯ್ಹಾ ರ‍್ಹಯಲ ದಗಡಾವೊಕ್ಹುಬಿ ಬಚ್ಚಾ ಹುಟ್ಸಾವಾನೆ ಥಾವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ಝಾಡೊ ಕತ್ರಿನ ನಾಕಾನೆ ಕೊಡ್ಲಿ ಹಮ್ನಾಜ ತಯ್ಯಾರ ಛೆ. ಚೊ಼ಕು ಫಲ ನೈ ದಿವಾನಾ ಹರಯಕ್ಕ ಝಾಡನೆ ಕತ್ರಿನ ಆಗಮಾ ಘಾಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ತುಮಾರಾ ಮನಸೊ ಕ್ಹುದಾ ಬಗಲ ಫರ್xಯಾಸ ಕವಾನೆ ದೆಕಾಡಾನಾ ಹುತಿ ಮಿ ತುಮೊನೆ ಪಾನಿಮಾ ಬಾಪ್ತಿಸ್ಮಾ ಕರೌಸ. ತೆನೈಸೊ ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ ಮಾರಾತಿ ತಾಕತವಾಲೊ ವ್ಹೈ. ತಿನಾ ಚಪ್ಲೊ ಛೊಡಾವಾನೆಬಿ ಮಿ ಯೊಗ್ಯ ನ್ಹವೈ. ತೆ ತುಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾಮಾ ಆಗಮಾ ಬಾಪ್ತಿಸ್ಮಾ ಕರಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ತೆ ಬಿಯ್ಯಾವೊನೆ ಸ್ವಚ್ಛ ಕರಾನೆ ತಯ್ಯಾರ ಥಯೊಸ. ತೆ ಬಿಯ್ಯಾವೊನೆ ಕೊಂಡಾವೊಕ್ಹು ಜುದೊ ಕರಿನ ಚೊ಼ಕಾ ಬಿಯ್ಯಾವೊನೆ ಕಣಜಮಾ ಭರೈನ ಕೊಂಡಾವೊನೆ ನೈ ಇಜ್ಜಾ಼ವಾನಿ ಆಗಮಾ ಬಾಳಿ ಪಡಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ತೆ ಟೈಮ ಯೊಹಾನನಾ ಹತೆ ಯೆಸು ಬಾಪ್ತಿಸ್ಮಾ ಲಿವಾನೆ ಗಲಿಲಾಯತೊ ಯೊರ್ದನ ನದಿನೆ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ತೆನೈಸೊ ಯೊಹಾನ, ಮಿಜ಼ ತಾರಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮಾ ಕರೈ ಲಿವಾನು ಛೆ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತು ಮಾರಾಕ್ಹು ಬಾಪ್ತಿಸ್ಮಾ ಲಿವಾನೆ ಮಕನ ಆವಾನು ಕಾ? ಕೈನ ತಿನೆ ಹುಬ್ರಾಡಾನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ಯೆಸು \"ಹಮ್ನಾ ತು ಇನಿ ಒಪ್ಪಿಲೆ ಅಪೆ ಕಾಮೊ ಕರಾನು ಶೆ\" ಕದ್ಯೊ. ತೆಳಾಮಾ ಯೊಹಾನ ಯೆಸುನೆ ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾನೆ ಒಪ್ಪಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ಯೆಸು ಬಾಪ್ತಿಸ್ಮಾ ಲಿನಾ ಪಾನಿಮಾತೊ ಉಪ್ಪರ ಆಯೊ, ತೆಳಾಮಾಜ಼ ಹಬಾಳ ಕ್ಹುಲ್ಯು ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಖಬುತರನಾ ರುಪ್ಮಾ ಉತರಿ ತಿನಾ ಉಪ್ಪರ ಆವಾನು ಯೆಸು ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ತೆಳಾಮಾ ಸ್ವರ್ಗಮಾತು ಆವಾಜ ಐಯು \"ಆ ಮಾರೊ ಮಾಯಾನೊ ದಿಕ್ರೊ ಯೆಸು ವ್ಹೈ, ಅನೆ ಮಿ ಘನ್ನೊ ಮೆಚ್ಚೊಸ\". ");
INSERT INTO sle_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ತೆಳಾಮಾ ಕ್ಹುದನಿ ಆತ್ಮಾ ಸೈತಾನಕ್ಹು ಪರಿಕ್ಷಾ ಲಿವಾನ ಹುತಿ ತಿನೆ ರಾಣಮಾ ಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ಯೆಸು ಚಾಲಕ್ಹ ದಿನ್ನ ರಾತ ಸುಜ ಕ್ಹಾದ್ಯೊ ನೈ. ಪಾಚಾ಼ತು ತಿನೆ ಘನ್ನಿ ಬುಕ್ಕ ಲಾಗಿ. ");
INSERT INTO sle_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ತೆಳಾಮ ಯೆಸುನೆ ಪರಿಕ್ಷಾ ಲಿವಾನಾ ಹುತಿ ಸೈತಾನ ಕನ ಐನ ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ರ‍್ಹಯೊಮ ಆ ದಗ್ಡಾನೆ ರೊಟ್ಲೊ ಥಾ ಕೈನ ಆಗನ್ಯಾ ದೆ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ಯೆಸು ತಿನೆ ಮನಕ್ಹ ರೊಟ್ಲೊ ಕ್ಹಾದ್ಯಾಮಾಜ ಜಿವ್ತೊ ರ್xಹತೊ ನೈ, ಕ್ಹುದಾನಾ ನಾ ಮ್ಹೊಡಾಕ್ಹು ಆವಾನಾ ವಾತೊಕ್ಹು ಜಿವ್ತೊ ರ‍್ಹವಸ ಕೈನ ಬರ್ದನ ಶೆ ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ತೆಳಾಮಾ ಸೈತಾನ ತಿನೆ ಯೆರೊಸಲೆಮನಾ ದೆವಾಲಯನಕನ ಲಿನ ಗೈನ, ದೆವಾಲಯನಾ ಕ್ಹಾರಾವೊತಿ ಉಪ್ಪರ ಜ಼ಗಾಪರ ಹುಬ್ರಾಡಿನ, ");
INSERT INTO sle_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ರ‍್ಹಯೊಮ ಉಪ್ಪರತೊ ಉಡ ತೆ ತಾರಾಹುತಿ ತಿನಾ ದೆವದುತೊನೆ ಆಗನ್ಯಾ ದಿವಸ ತ್ಯುನೆ ತಾರಾ ಪಗೊ ದಗ್ಡಾನೆ ಲಾಗಾನೆ ದಿದ್ಯಾವಾಚಿ ತುನೆ ಹತೊ ಮಾ ಉಚೈಲಿವಸ” ಕೈನ ಬರ್ದಲ ಛೆ ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ತೆ ವಾತೆ ಯೆಸು ತಾರಾ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನೆ ಪರಿಕ್ಷಾ ಕರು ನೈ ಕೈನ ಬಿ ಬರ್ದಲ ಶೆ. ");
INSERT INTO sle_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ಪಾಚಾ಼ತೊ ಸೈತಾನ ತಿನೆ ಘನ್ನೊ ಉಚ್ಚು ರ‍್ಹಯಲ ಡೊಂಗರಪರ ಲಿನ ಗೈನ ಆ ಲೊಕಮಾ ರ‍್ಹಯಲ ಹರಯಕ ರಾಜ್ಯ ದೆಕಾಡಿನ ತ್ಯಾ ರ‍್ಹಯಲ ಹರಯಕ ವೈಭವ ದೆಕಾಡಿನ ");
INSERT INTO sle_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ತು ಮನೆ ಅಡ್ಡ ಪಡ್ಯಾರೆ ಆ ಕ್ಹಾರು ಮಿ ತುನೆ ದ್ಯುಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ಯೆಸು ತಿನೆ ಸೈತಾನ ತು ಗೈ ಪಡ, ತಾರೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನೆ ಯಕ್ಕಜ ಅಡ್ಡ ಪಡಿನ ತಿನೆ ಯಕ್ಕಲಾನೆಜ ಆರಾದನಾ ಕರು ಕೈನ ಬರ್ದಲ ಛೆ ತೊ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ತಿನಾಹು ಸೈತಾನ ತಿನೆ ಛೊಡಿನ ಗೈ ಪಡ್ಯೊ ತೆಳಾಮಾ ದಕ್ಹಾ ದೆವದುತೊ ಐನ ತಿನೆ ಉಪಚಾರ ಕರ‍್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ಯೊಹಾನನೆ ಜೆಲ್ಮಾ ಘಾಲ್ಯಾಸ ಕೈನ ಯೆಸುನೆ ಗೊತ್ತ ಥಯು, ತಿನಾಹುತಿ ಯೆಸು ಗಲಿಲಾಯಾನೆ ಫರಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ತೆಳಾಮ ತೆ ನಜರೆತಮಾ ರ‍್ಹಯಾ ಬಗರ ತ್ಯಾಂತೊ ಗೈನ ಗಲಿಲಾಯನಾ ಸರೊವರನಾ ಕ್ಹಾಮು ರ‍್ಹಯಲ ಕಪೆನೌರ್ಮ ಕವಾನಾ ಗಾಮಮಾ ರ‍್ಹಯೊ. ತೆ ಗಾಮ ಜೆಬುಲೊನ ವರಿ ನಫ್ತಾಲಿನ ಸಿಮೆಕನ ಶೆ. ");
INSERT INTO sle_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಕದಲ ನಿಂಗತ ಥಯು ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾರೆ ");
INSERT INTO sle_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ಜೆಬುಲೊನ ಸಿಮೆ ವರಿ ನಫ್ತಾಲಿನ ಸಿಮೆ , ಯೊರ್ದನನಾ ಬಾಜು, ಸಮುದ್ರಕನ ರ‍್ಹಯಲ ಸಿಮೆ, ಬಿಜಾ಼ ಜಾ಼ತನಾ ಮನಕ್ಹೊ ರ‍್ಹಯಲ ಗಲಿಲಾಯ ಸಿಮೆ ");
INSERT INTO sle_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ಅಮ್ಮ ಅಂದಾರಮಾ ರ‍್ಹಯಲ ಆ ಗಾಮ ವಾಲಾ ಮನಕ್ಹೊನೆ ಮ್ಹೊಟು ಉಜಾಲು ದಿಕ್ಹ್ಯು. ಮೌತನಾ ಅಂದಾರಾಮಾ ರ‍್ಹಯಲವಾಲಾ ದೆಶನಾ ಮನಕ್ಹೊನೆ ಸುರ‍್ಯಾನು ಉಜಾಲು ಪಡ್ಯು” ");
INSERT INTO sle_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ತೆ ದಿನತೊ ಯೆಸು ಬೊದನೆ ಕರಾನು ಸುರು ಕರ‍್ಯೊ, ಪರಲೊಕ ರಾಜ್ಯ ಜಲ್ದಿ ಆವಾನು ಶೆ, ತಿನಾಹುತಿ ತುಮೆ ಕ್ಹುದಾಕನ ತುಮಾರಾ ಮನಸೊ ಫರಾವೊ ವರಿ ತುಮಾರಿ ಪಾಪನಿ ಜಿವ್ನಾ ಬದ್ಲಿ ಕರಲಿವೊ” ಕೈನ ಯೆಸು ಬೊದನೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ಗಲಿಲಾಯಾನ ಸರೊವರಕನ ಯೆಸು ಜಾ಼ತಾಮಾ, ತೆಳಾಮಾ ಪೆತ್ರಕೈನ ಕೈಲಿವಾಲಾ ಸಿಮೊನ ವರಿ ತಿನೊ ಭೈ ಥಯಲ ಅಂದ್ರೆಯನೆ ದೆಕ್ಯೊ, ತ್ಯುನೆ ತ್ಯುನಾ ಮಚ್ಲಿಯೊ ಧರಾನಾ ಬಲಿಯೊ ಸಿದಾ ಕರಾಡಾತಾ, ತ್ಯುನೆ ಭಂಬಿಜಾನಾ ಮಚ್ಲಿಯೊ ಧರಾಲಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ಯೆಸು ತ್ಯುನೊನೆ ಆವೊ ಮಾರಾ ಪಾಚಾ಼ ಆವೊ, ಮಿ ತುಮೊನೆ ಮನಕ್ಹೊನೆ ಧರಾನಾ ಬೆಸ್ತರೊ ಕರುಸ” ಕೈನ ಕದಲ ಬರೊಬ್ಬರಜ ");
INSERT INTO sle_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ತ್ಯುನೆ ತ್ಯುನಾ ಮಚ್ಲಿಯೊ ಧರಾನಾ ಬಲಿಯೊ ಛೊಡಿನ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ವರಿ ಯೆಸು ಆಗೊ ಜಾ಼ತಾಮಾ ಹಜು಼ನ ಬೆ ಭಾಯೊನೆ ದೆಕ್ಯೊ ತ್ಯುನೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾರೆ ಜೆಬೆದಾಯನೊ ದಿಕ್ರೊ ಥಯಲ ಯಾಕೊಬ ವರಿ ತಿನೊ ನ್ಹಾನೊ ಭೈ ರ‍್ಹಯಲ ಯೊಹಾನ. ಆ ಭಂಬಿ ಜ಼ನಾ ತಿನಾ ಬಾ ನಾ ಕ್ಹಾತೆ ಮಚ್ಲಿ ಧರಾನಿ ಬಲಿಯೊ ಸಿದಾ ಕರಾಡಾತಾ, ತೆ ತ್ಯುನೊನೆಬಿ ಮಾರಾ ಪಾಚಾ಼ ಆವೊ ಕದ್ಯೊ . ");
INSERT INTO sle_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ತೆಳಾಮಾಜ಼ ತ್ಯುನೆ ತಿನಾ ಬಾನೆ ತ್ಯುನೆ ರ‍್ಹಯಲ ಹಡ್ಗಾನೆ ಛೊಡಿನ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಗಲಿಲಾಯ ಪುರಾ ಫರಿನ ತ್ಯಾ ರ‍್ಹಯಲ ಸಭಾ ಮಂದಿರಮಾ ಉಪದೆಶ ಕರತೊ ಪರಲೊಕ ರಾಜ್ಯನಿ ಸುವಾರ್ತಾ ಕತೊ ಮನಕ್ಹೊಮಾ ರ‍್ಹಯಲ ಹರಯಕ ರೊಗ , ತ್ರಾಸ ಅರಾಮ ಕರತೊ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ತಿನಿ ಸುದ್ದಿ ಸಿರಿಯಾ ದೆಶಮಾ ಫೈಲಿ ಗಯಲಕ್ಹು ಮನಕ್ಹೊ ಅರಾಮ ನೈ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಕದ್ಯಾರೆ ತರಾ ತರಾನಾ ರೊಗೊಮಾ ರ‍್ಹೈನ ತ್ರಾಸ ಕ್ಹಾವಾವಾಲಾವೊನೆ ಬೆಹೊಶ ಥೈ ಜಾ಼ವಾನಾವಾಲಾವೊನೆ ಪಾರ್ಶಿಮಾರಾಲವಾಲಾವೊನೆ ತಿಕನ ಲಾಯಾ. ತೆ ತ್ಯುನೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ವರಿ ಗಲಿಲಾಯ ದೆಕಪೊಲಿ ಯುದಾಯ ಕವಾನಾ ಗಾಮೊತಾ ವರಿ ಯೊರ್ದನ ನದಿಕನ ರ‍್ಹಯಲ ಆಜು಼ ಬಾಜುನಾ ಗಾಮೊನಾ ಮನಕ್ಹೊ ತಿನಾ ಪಾಚಾ಼ ಗುಂಪ ಗುಂಪ ಥೈನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ಯೆಸು ತೆ ಮನಕ್ಹೊನು ಗುಂಪ ದೆಕಿನ ಡೊಂಗರ ಚ಼ಡಿನ ಬೈಟಲ್ಪರ ತಿನಾ ಶಿಷ್ಯಾ ತಿಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ತೆ ತ್ಯುನೊನೆ ಉಪದೆಶ ಕರತೊ ಸು ಕದ್ಯೊ ಕದ್ಯಾರೆ - ");
INSERT INTO sle_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ಆತ್ಮಾಮಾ ಗರಿಬ ರ‍್ಹಯಲ ವಾಲಾ ಧನ್ಯ ವ್ಹೈ; ಪರಲೊಕ ರಾಜ್ಯ ತ್ಯುನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ದುಕ್ಕ ಪಡಾಲಾ ಧನ್ಯ ವ್ಹೈ; ತ್ಯುನೆ ಸಮಾಧಾನ ಹೊಂದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ಶಾಂತ ರ‍್ಹವಾಲಾ ಧನ್ಯ ವ್ಹೈ; ತ್ಯುನೆ ಆ ಲೊಕಮಾ ಘನ್ನಾ ದಿನ್ನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ನಿತಿನಾ ಹುತಿ ಭುಕ್ಕಾ ವರಿ ತರಕ್ಹಾ ರ‍್ಹಯಲವಾಲಾ ಧನ್ಯ ವ್ಹೈ; ತ್ಯುನೊನೆ ತೃಪ್ತಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ಕರುಣಾ ಕುನ್ನ ದೆಕಾಡಸ ಧನ್ಯ ವ್ಹೈ; ತ್ಯುನೊನೆ ಕರುಣಾ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ನಿರ್ಮಲಚಿತ್ತ ರ‍್ಹಯಲವಾಲಾ ಧನ್ಯ ವ್ಹೈ. ತ್ಯುನೆ ಕ್ಹುದಾನೆ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ಸಮಾಧಾನ ಕರಾಲಾ ಧನ್ಯ ವ್ಹೈ. ತ್ಯುನೆ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ನಿತಿನಾ ಹುತಿ ತ್ರಾಸ ಖಾವಾಲಾ ಧನ್ಯ ವ್ಹೈ. ಸ್ವರ್ಗಲೊಕ ರಾಜ್ಯ ತ್ಯುನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ತುಮೆ ಮಾರಾ ಪಾಚಾ಼ ಆವಾಕ್ಹು ಮನಕ್ಹೊ ತುಮೊನೆ ಕದ್ರಾಯಮ, ತ್ರಾಸ ಕರ‍್ಯಾಮ ವರಿ ತುಮಾರಾ ಉಪ್ಪರ ಕೆಟ್ಟ ವಿಶಯ ಸುಳ್ಳ ಘಾಲ್ಯಮ ತುಮೆ ಧನ್ಯ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ಕ್ಹುಶಿ ಥಾವೊ, ಆನಂದಕ್ಹು ರ‍್ಹವೊ. ಸ್ವರ್ಗಲೊಕಮಾ ತುಮಾರಾಹುತಿ ಕೈದಲ ಹೆಚ್ಕಿ ಫಲ ತುಮೆ ವ್ಹಂದಿಲಿವೊಶಿ. ತುಮಾರಾತಿ ಪೈಲಾ ಜಿವ್ತಾ ರ‍್ಹಯಲ ಪ್ರವಾದಿಯೊನೆಬಿ ಮನಕ್ಹೊ ಇಮ್ಮಜ಼ ಕರ‍್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ತುಮೆ ಜಿಮಿನನೆ ಮಿಟ್ಟು ಥಯಾಸ. ತೆನೈಸೊ ಮಿಟ್ಟುಜ ತಿನು ಸ್ವಾದ ಜ಼ವೈ ಲಿದ್ಯಮ ತಿನೆ ವರಿ ಮಿಟ್ಟಾನು ಸ್ವಾದ ಕರಾನೆ ಥಾತು ನೈ; ತೆವಾ ಮಿಟ್ಟಾಕ್ಹು ಸುಜ಼ ಉಪಯೊಗ ನತ್ತಿ. ಮನಕ್ಹೊ ತಿನೆ ಭಾರಾ ನಾಕಿನ ತಿನಾ ಉಪ್ಪರ ಚಾಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ತುಮೆ ದುನಿಯಾನೆ ಉಜಾಲು ಥಯಾಸ. ಡೊಂಗರಪರ ಭಾಂದಲ ಗಾಮ ನೈ ಝಕಾತು. ");
INSERT INTO sle_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ಮನಕ್ಹೊ ದಿವ್ವಾನೆ ಹಂಡಾಮಾ ಝಾಕಿನ ನೈ ಮ್ಹೆಲ್ತಾ. ಮನಕ್ಹೊ ದಿವ್ವಾನೆ ದಿವ್ವಾನಾ ಖಂಬಾಪರ ಮ್ಹೆಲಸ. ತೆಳಾಮಾ ಘರಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾವೊನೆ ಉಜಾಲು ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ತಿನಾ ಲಿಂಗತ ತುಮೆ ಮನಕ್ಹೊನೆ ಉಜಾಲು ಥೈನ ರ‍್ಹೌ. ಇಮ್ಮ ತ್ಯುನೆ ತುಮಾರಾ ಚೊ಼ಕಾ ಕಾಮೊ ದೆಕಿನ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಬಾನೆ ಸ್ತುತಿ ಕರಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ಮಿ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರ ರ‍್ಹವಾದೆ ಪ್ರವಾದಿಯೊನಾ ಉಪದೆಶೊ ರ‍್ಹವಾದೆಕಾಡಿಪಡಾನೆ ಆಯೊಸ ಕೈನ ತಿಳ್ದಲಿವೊ ನಕೊ. ಮಿ ತೆ ಕ್ಹಾರಾವೊನೆ ನಾಶ ಕರಾನೆ ನೈ ತೆ ಕ್ಹಾರು ಪುರಾ ಕರಾನೆ ಅಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಸ್ವರ್ಗ ವರಿ ಜಿಮಿನ ನಾಶ ಥಾಯೆಲಕ್ಕಾ ಧರಮಶಾಸ್ತ್ರಮಾತು ಸುಜ಼ ನುಚ್ಚಾತು ನೈ. ಕ್ಹಾರು ಪುರಾ ಥಯೆಲಕ್ಕಾ ಧರಮ ಶಾಸ್ತ್ರಮಾನು ಯಕ್ಕ ಅಕ್ಷರ ರ‍್ಹವಾದೆ ತೆನೈಸೊ ತಿಮಾನಿ ಯಕ್ಕ ಚಿಕ್ಕಿ ರ‍್ಹವಾದೆ ನುಚ್ಚಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ಮನಕ್ಹ ಹರಿ ಯಕ್ಕ ಆಗನ್ಯಾನೆ, ಕದ್ಯಾಮ ನ್ಹಾನಾ ನ್ಹಾನಾ ಆಗನ್ಯಾನೆ ವಿಧೆಯ ಥೈನ ರ‍್ಹೌ. ಯಕ್ಲೊ ಕಯಾಬಿ ಆಗನ್ಯಾನೆ ವಿಧಯ ನೈ ಥೈನ ಜಿವ್ನಾ ಕರ್ತೊ ತೆ ಅಗನ್ಯಾನೆ ಬಿಜಾಬಿ ವಿಧೆಯ ಥೈನ ರ‍್ಹೌ ನೈ ಕೈನ ಬೊದನೆ ಕರ‍್ಯೊಮ ತೆ ಸ್ವರ್ಗಲೊಕಮಾ ಘನ್ನೊ ನ್ಹಾನೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಸ. ತೆನೈಸೊ ದರಮ ಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥೈನ ಜಿವ್ನಾ ಕರ್ತೊ ದರಮ ಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥೌ ಕೈನ ಬಿಜಾವೊನೆ ಬೊದನೆ ಕರಾಲೊ ಪರಲೊಕ ರಾಜ್ಯಮಾ ಕ್ಹಾಸ ಥೈನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ಧರಮ ಉಪದೆಶ ಕರಾಲಾವೊತಿ ಫರಿಸಾಯರೊತಿಬಿ ತುಮೆ ಚೊ಼ಕು ರ‍್ಹಯಲ ಕರು. ನೈತೊ ತುಮೆ ಪರಲೊಕನಾ ರಾಜ್ಯನೆ ನೈ ಜಾ಼ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ಕಿನೆಜ ಖಲಾಸ ಕರು ನೈ ಖಲಾಸ ಕರಾಲೊ ನ್ಯಾಯನಾ ಫೈಸ್ಲಾನೆ ಮ್ಹೈ ಥಾವಸ ಕೈನ ಘನ್ನಾ ಕಾಲ ಪಾಚಾ಼ ಅಪ್ನ ಮನಕ್ಹೊನೆ ಕದಲ ತುಮೆ ಐಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ ಕಿನಾಜ ಉಪ್ಪರ ಶಿಟ್ಟ ಥಾವೊ ನಕೊ. ಹರಯಕ್ಲೊ ತುಮಾರೊ ಭೈ ವ್ಹೈ. ತುಮೆ ಬಿಜಾವೊಪರ ಶಿಟ್ಟ ಥಯಾಮ ನ್ಯಾಯನಾ ಫೈಸ್ಲಾನೆ ಗುರಿ ಥವೊಶಿ. ತುಮೆ ಕಿನೆಬಿ ಕೆಟ್ಟ ವಾತೊ ಬೊಲ್ಯಾಮ, ಯೆಹುದಿಯೊನಾ ನ್ಯಾಯ ಸಭೆಮಾ ವಿಚಾರಣೆನೆ ಗುರಿ ಥಾವೊಶಿ. ತುಮೆ ಕಿನೆತುಬಿ ಪಿಸಾಳೊ ಕೈನ ಬಲಾಯಾಮ, ಆಗನಿ ನರಕಮಾ ಮಳಾನಾ ಖತ್ರಾಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ತಿನಾಹುತಿ ತುಮೆ ತುಮಾರಿ ಕಾಣಿಕೆ ಬಲಿನಾ ಕಟ್ಟಾನಾ ಕ್ಹಾಮಾ ಕ್ಹುದಾನೆ ಛಡಾತಾಮಾ, ತುಮಾರಾ ಭೈನೆ ತುಮಾರಾ ಉಪ್ಪರ ಸುಬಿ ಬೆಜ್ಜಾರ ಛೆ ಕೈನ ತುಮೊನೆ ಶೆಂ ಐಮ, ");
INSERT INTO sle_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ತೆಳಾಮಾ ತುಮಾರಿ ಕಾಣಕಿನೆ ಬಲಿನಾ ಕಟ್ಟಾಕನ ಛೊಡಿನ ಜಾವೊ, ಪೈಲಾ ತಿನಾ ಕ್ಹಾತೆ ಸಮಾಧಾನ ಕರಿಲಿವೊ. ಪಾಚ್ಲತಾ ಐನ ತುಮಾರಿ ಕಾಣಕಿ ಛಡಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ತುಮಾರೊ ವಿರೊದಿ ತುಮೊನೆ ನ್ಯಾಯಲಯಮಾ ಜಗ್ಗಿಲಿನ ಜಾ಼ತಾಮಾ ಜಲ್ದಿಜ ತಿನಾ ಕ್ಹಾತೆ ಯಕ್ಕ ಥಾವೊ. ತುಮೆ ನ್ಯಾಯಾಲಯನೆ ಜಾ಼ವಾತಿ ಪೈಲಾ ಎ ಕರು. ತುಮೆ ತಿನಾ ಕ್ಹಾತೆ ಯಕ್ಕ ನೈ ಥಯಾರೆ, ತೆ ತುಮೊನೆ ನ್ಯಾಯಾದಿಪತಿನೆ ವಪ್ಪಿಸಾವಸ. ನ್ಯಾಯಾದಿಪತಿ ತುಮೊನೆ ಜೈಲಮಾ ಘಾಲಾನೆ ಕೈದಾಲಾನೆ ವಪ್ಸಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ತೆಳಾಮಾ ತುಮೆತುಮಾರಿ ಕ್ಹಾರಿ ಸಾಲಾ ಚುಕಾಯೆಲಕ್ಕಾ ಜೈಲಮಾತಾ ಭಾರಾ ಆತಾ ನೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ವ್ಯಭಿಚಾರ ಕರೊ ನಕೊ ಕವಾನು ತುಮೆ ಕ್ಹಾಲಿ ಐಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ತೆನೈಸೊ ಯಕ್ಲೊ ಮನಕ್ಹ ಬಿಜಿ ಬಾಕ್ಡಿನೆ ದೆಕಿನ ತಿನಾ ಕ್ಹಾತಿ ಶರಿರ ಸಂಬಂದ ಮ್ಹೆಲಾನೆ ವಿಚಾರಕರ‍್ಯೊಮ, ತೆ ತೆಳಾಮಾಜ಼ ತಿನಾ ಮನಸಮಾ ತಿನಾ ಕ್ಹಾತೆ ವ್ಯಭಿಚಾರ ಕರ‍್ಯೊಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ತಾರೊ ಸಿದಾ ಬಗಲನೊ ಡೊಳೊ ತುನೆ ಪಾಪಮಾ ಮ್ಹೈ ಕರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊಮ, ತಿನೆ ಕಿತ್ತಿನ ನಾಕ. ತಾರು ಪುರಾ ಅಂಗ ನರಕಮಾ ಪಡಾತಿ ತಾರಾ ಅಂಗನು ಯಕ್ಕ ಭಾಗ ಜವೈಲಿವಾನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ತಾರೊ ಸಿದಾ ಬಗಲನೊ ಹತ್ತ ತುನೆ ಪಾಪಮಾ ಮ್ಹೈ ಕರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊಮ, ತಿನೆ ಕಾಟಿನ ನಾಕಿಪಡ.ತಾರು ಪುರಾ ಅಂಗ ನರಕಮಾ ಪಡಾತಿ ತಾರಾ ಅಂಗನು ಯಕ್ಕ ಭಾಗ ಜವೈಲಿವಾನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿ ಪಾಡು ಕವಾಲೊ, ತಿನೆ ತಲಾಕನು ಪತ್ರ ದಿವಾದೆ’ ಕೈನ ಕದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ತೆನೈಸೊ ಮಿ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ, ತಿನಿ ಬೈಕೊನೆ ಛೊಡಾಲೊಜ಼ ತೆ ವ್ಯಬಿಚಾರ ಕರಾನೆ ಕಾರಣ ಥಾವಸ. ಬೈಕೊ ಬಿಜಾ ಯಕ್ಕ ದಾಣಗಾನಾ ಕ್ಹಾತೆ ಅಂಗನು ಸಂಬಂದ ಮ್ಹೆಲ್ಲಿದಿಮ ಯಕ್ಕಜ಼ ತಿನೆ ಮಾಟಿ ಛೊಡಸಕಸ. ತಲಾಕ ಥಯಲವಾಲಿನೆ ಹಿವಾ ಕರಿಲಿದಲವಾಲೊಬಿ ವ್ಯಬಿಚಾರ ಕರಲವಾಲೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ತುಮೆ ಘಾಲಲ ಕ್ಹಮ್ಮ ದಾಟಿನ ಜಾ಼ವೊನಕೊ. ಪ್ರಭುನೆ ತುಮೆ ಕರಲ ಕ್ಹಮ್ಮ ಪುರಾ ಕರುಜ಼’ ಕೈನ ಅಪ್ನಾ ಪುರ್ವಕರೊನೆ ಕದಲ ತುಮೆ ಐಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ತೆನೈಸೊ ಮಿ ಸು ಕೌಸ ಕದ್ಯಾಮ, ಕ್ಹಮ್ಮ ಘಾಲೊಜ ನಕೊ. ಸ್ವರ್ಗಪರ ಕ್ಹಮ್ಮ ಘಾಲೊ ನಕೊ, ಕಾಕದ್ಯಾಮ ಸ್ವರ್ಗ ಕ್ಹುದಾನಿ ಸಿಂಹಾಸನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ಜಿಮಿನಪರ ಕ್ಹಮ್ಮ ಘಾಲೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ಜಿಮಿನ ಕ್ಹುದಾನಿ ಪಗ್ಗ ಮ್ಹೆಲಾನಿ ಜ಼ಗಾ ವ್ಹೈ. ಯೆರುಸಲೆಮಪರಬಿ ಕ್ಹಮ್ಮ ಘಾಲೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ತೆ ಗಾಮ ತೆ ಮ್ಹೊಟಾ ರಾಜಾ಼ನು ಗಾಮ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ತುಮಾರಾ ಮಾತಾಪರ ಕ್ಹಮ್ಮ ಘಾಲೊ ನಕೊ. ತುಮಾರಾ ಮಾತಾನಾ ಬಾಲೊನು ಯಕ್ಕ ಬಾಲನೆ ಧೊಳು ವರಿ ಕಾಳೊ ಕರಾನೆ ತುಮೊಕ್ಹು ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ಹುಂ ಕದ್ಯಾಮ ‘ಹುಂ’ ಕವೊ. ನೈ ಕದ್ಯಾಮ ‘ನೈ’ ಕವೊ. ತುಮೆ ಇತ್ತಿ ಉಪ್ಪರ ಕವಾನು ಸೈತಾನಕ್ಹು ಆಯಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ಡೊಳಾನೆ ಡೊಳೊ, ದಾತನೆ ದಾತ’ ಕೈನ ಕದಲ ತುಮೆ ಐಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ, ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲಾನಾ ವಿರುದ್ದ ಹುಬ್ರ್ಯವೊ ನಕೊ. ಕಯೊಬಿ ತುಮಾರಾ ಸಿದಾ ಬಗಲನಾ ಗಾಲೆ ಮಾರ‍್ಯಾಮ, ತಿಎ ವರಿಯಕ್ಕ ಗಾಲ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ಕಯೊಬಿ ತುಮಾರಾ ಉಪ್ಪರಲ್ಯಾ ಅಂಗಡಾನಾಹುತಿ ನ್ಯಾಯಾಲಯನೆ ಜಗ್ಗಿಲಿನ ಜಾತೊ ರ‍್ಹಯಲಾಮ, ತುಮಾರು ಮ್ಹೈನು ಅಂಗಡುಬಿ ತಿನೆ ದಿಪಾಡೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ಕಯೊ ಸೈನಿಕಬಿ ತಿನಾ ಕ್ಹಾತೆ ಯಕ್ಕ ಮೈಲ ದುರ ಆ ಕೈನ ಜಬರದಸ್ತಿಕರ‍್ಯೊಮ, ತಿನಾ ಕ್ಹಾತೆ ಬೆ ಮೈಲ ದುರ ಜಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ಕಯೊಬಿ ತುಮೊಕನ ರ‍್ಹಯಲ ಸುಬಿ ಪುಚ್ಯೊಮ, ತಿನೆ ದಿವೊ. ತುಮೊಕ್ಹು ಸಾಲಾ ಮಾಂಗಿಲಿವಾನೆ ಆಯಲವಾಲಾನೆ ದಿದ್ಯಾವಾಚಿ ರ‍್ಹವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ತಾರಾ ದೊಸ್ತೊನೆ ಮಯಾ ಕರ ವರಿ ತಾರಾ ದುಶ್ಮನೊನೆ ದ್ವೆಶ ಕರ’ ಕೈನ ಕದಲ ತುಮೆ ಐಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ, ತುಮಾರಾ ದುಶ್ಮನೊನೆ ಮಯಾ ಕರೊ. ತುಮೊನೆ ಕಟ್ಟ ಕರಾಲಾ ಮನಕ್ಹೊನಾಹುತಿ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ತೆಳಾಮಾ ತುಮೆ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಬಾನಾ ಕ್ಹರಿನಾ ಬಚ್ಚಾ ಥಾವೊಶಿ. ತುಮಾರೊ ಬಾ ಚೊ಼ಕಾವೊನಾಹುತಿಬಿ ವರಿ ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲಾವೊನಾಹುತಿಬಿ ಸುರ‍್ಯಾನು ಉಜಾಲು ದಿವಸ ವರಿ ಪಾನಿ ಆವಾ ಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ತುಮೊನೆ ಮಯಾ ಕರಾನಾ ಮನಕ್ಹೊನೆ ತುಮೆ ಮಯಾ ಕರ‍್ಯಾಮ, ತಿನಾಕ್ಹು ತುಮೊನೆ ಸು ಫಲ ಮಳಸ? ಬುಭಾಡೊಲಿವಾಲಾ ತಿಮ್ಮಜ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ತುಮೆ ತುಮಾರಾ ದೊಸ್ತೊನೆ ಯಕ್ಕಜ಼ ಚೊ಼ಕಾ ರ‍್ಹಯಾಮ,ತುಮೆ ಬಿಜಾವೊತಿ ಚೊ಼ಕಾ ಸು ನ್ಹವೈ. ಕ್ಹುದಾ ನೈ ವಳಕ ಮನಕ್ಹೊಬಿ ತ್ಯುನಾ ದೊಸ್ತೊನೆ ಚೊ಼ಕಾ ಥೈನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ತಿನಾಹುತಿ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರೊ ಬಾ ಪರಿಪುರ್ಣ ಥೈನ ರ‍್ಹಯಲ ಲಿಂಗತ ತುಮೆಬಿ ಪರಿಪುರ್ಣ ಥೈನ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ಹುಶಾರ ರ‍್ಹವೊ ತುಮೆ ಚೊ಼ಕಾ ಕಾಮೊ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ಕರೊ ನಕೊ. ಮನಕ್ಹೊ ದೆಕು ಕೈನ ತುಮೆ ತೆಕ್ಹಾರು ಕರ‍್ಯಾಮ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಬಾಕ್ಹು ತುಮೊನೆ ಪ್ರತಿಫಲ ನೈ ಮಳ್ತು. ");
INSERT INTO sle_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ತುಮೆ ಗರಿಬ ಮನಕ್ಹೊನೆ ಕರಾನು ದಾನನಾಹುತಿ ದೆಕಾಡಿನ ದಿವೊ ನಕೊ. ತುಮೆ ಕಪಟಿಯೊ ಲಿಂಗತ ಕರು ನೈ. ತ್ಯುನೆ ಕರಾನಾ ದಾನನೆ ಮನಕ್ಹೊನೆ ದೆಕಾಡಿನ ದಿವಾನಾಹುತಿ ಕಪಟಿಯೊ ಸಭಾ ಮಂದಿರೊಮಾ ವರಿ ಒಣಿಯೊಮಾ ಪಾಂಯೊ ವಜಾ಼ಡಸ. ಮನಕ್ಹೊಕ್ಹು ಮರ್ಯಾದಿ ಲಿವಾನುಜ ತ್ಯುನು ಉದ್ದೆಶ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ತಿನಾಹುತಿ ತುಮೆ ಗರಿಬೊನೆ ದೆತಾಮಾ ಘನ್ನಾ ದಡೈನ ದಿವೊ. ತುಮೆ ಕರಾನು ಕಿನೆಜ ಗ್ವತ್ತ ಥೌ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ತುಮೆ ದಾನ ದಡೈನ ದ್ಯು. ದಡೈನ ಕರಾನಾ ಕಾಮೊ ದೆಕಾಲೊ ತುಮಾರೊ ಬಾ ತುಮೊನೆ ಪ್ರತಿಧಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ತುಮೆ ಪ್ರಾಥನಾ ಕರತಾಮಾ ಕಪಟಿಯೊ ಲಿಂಗತ ಪ್ರಾಥನಾ ಕರೊ ನಕೊ. ಕಪಟಿಯೊ ಸಭಾಮಂದಿರಮಾ ವರಿ ಒಣಿಯೊನಾ ಮುಲಾವೊಮಾ ಹುಬ್ರೈನ ಜೊ಼ರ ಪ್ರಾಥನಾ ಕರಾನು ಪಸಂದ ಕರಸ. ತ್ಯುನೆ ಪ್ರಾಥನಾ ಕರಾನು ಮನಕ್ಹೊ ದೆಕು ಕೈನಜ ತ್ಯುನಿ ಆಸ ವ್ಹೈ. ತ್ಯುನೆ ತೆಳಾಮ ತಿನು ಪುರಾ ಪ್ರತಿಫಲ ಹೊಂದಿಲಿದ್ಯಾಸ ಕೈನ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ತುಮೆ ಪ್ರಾಥನಾ ಕರು ಕದ್ಯಾಮ, ತುಮಾರಿ ಖೊಲಿಮಾ ಗೈನ ಬಾಕಲ ಜಾಕಿನ ತುಮೊನೆ ನೈ ದಿಕ್ಹಾಲಾ ಬಾನೆ ಪ್ರಾಥನಾ ಕರೊ. ದಡೈನ ಕರಾನಾ ಕಾಮೊ ದೆಕಾಲೊ ತುಮಾರೊ ಬಾ ತುಮೊನೆ ಪ್ರತಿಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ತುಮೆ ಪ್ರಾಥನಾ ಕರತಾಮಾ ಕ್ಹುದಾನೆ ನೈ ತಿಳದಿಲಿದಲ ಮನಕ್ಹೊಲಿಂಗತ ಪ್ರಾಥನಾ ಕರೊ ನಕೊ. ತ್ಯುನೆ ಮತಲಬ ನೈ ರ‍್ಹಯಲ ಸಂಗತಿಯೊ ಕತಾಜ ರ‍್ಹವಸ ಅಮ್ಮ ಪ್ರಾಥನಾ ನಕೊ. ತ್ಯುನೆ ಘನ್ನಾ ವಿಶಯ ಕವಾಕ್ಹು ಕ್ಹುದಾ ತ್ಯುನಿ ಪ್ರಾಥನಾ ಐಕಸ ಕವಾನು ತ್ಯನಿ ವಿಚಾರ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ತುಮೆ ತ್ಯುನಾ ಲಿಂಗತ ನೈ ಥಾವೊ ನಕೊ. ತುಮೆ ಮಾಂಗಾತಿ ಪೈಲಾಜ ತುಮೊನೆ ಸು-ಸು ಚಾ಼ಯೆ ಕವಾನು ತುಮಾರಾ ಬಾನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ತಿನಾ ಹುತಿ ತುಮೆ ಇಮ್ಮ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ಹಮಾರಾ ಬಾ, ತಾರು ನಾಮ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾದೆ ತಾರಿ ರಾಜ್ಯ ಆವಾದೆ ತಾರಿ ಚಿತ್ತ ಸ್ವರ್ಗಾಮಾ ಥಾಯೆ ಲಿಂಗತ ಭುಲೊಕಮಾ ಥಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ಹಮಾರು ಹರ ದಿನ್ನನು ಅನ್ನ ಹಮ್ನಾಜ಼ ದೆ. ");
INSERT INTO sle_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ಹಮೊನೆ ತಪ್ಪ ಕರೆಲವಾಲಾವೊನೆ ಹಮೆ ಮಾಫ ಕರೆ ಲಿಂಗತ ಹಮಾರ ತಪ್ಪೊ ಮಾಫ ಕರ. ");
INSERT INTO sle_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ಹಮೊನೆ ಶೊದನೆಮಾ ಪಡೆತೆ ಕೆಟ್ಟಕ್ಹು ಹಮೊನೆ ವಚಾಡ. ");
INSERT INTO sle_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ತುಮೆ ಮನಕ್ಹೊನಾ ತಪ್ಪೊ ಮಾಫ ಕರ‍್ಯಾಮ ಸ್ವರ್ಗಾಮಾ ರ‍್ಹವಾಲೊ ಬಾ ತುಮಾರಾ ತಪ್ಪೊ ಮಾಫ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ತೆನೈಸೊ ತುಮೆ ಮನಕ್ಹೊನಾ ತಪ್ಪೊ ಮಾಫ ನೈ ಕರ‍್ಯಾಮ ತುಮಾರೊ ಬಾ ಬಿ ತುಮಾರಾ ತಪ್ಪೊ ಮಾಫನೈ ಕರತೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ತುಮೆ ಉಪಾಸ ಕರತಾಮಾ ತುಮಾರಾ ಮ್ಹೊಡು ಉತಾರಿಲಿವೊ ನಕೊ. ಕಪಟಿಯೊ ತಿಮ್ಮಜ ಕರಸ. ತೆನೈಸೊ ತುಮೆ ಕಪಟಿಯೊ ಲಿಂಗತ ರ‍್ಹವೊ ನಕೊ. ತ್ಯುನೆ ಉಪಾಸ ಕರಾಡಾಸ ಕವಾನು ಮನಕ್ಹೊನೆ ದೆಕಾಡಾನಾ ಹುತಿ ತ್ಯುನಾ ಮ್ಹೊಡಾ ಉತಾರಿ ಲಿವಸ. ತೆ ಕಪಟಿಯೊ ತ್ಯುನೊನೆ ಆವಾನು ಪ್ರತಿಫಲ ಪುರಾ ಹೊಂದಿಲಿದ್ಯಾಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿ ಕವುಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ತಿನಾಹುತ ತುಮೆ ಉಪಾಸ ಕರತಾಮಾ, ಮ್ಹೊಡು ದ್ವೈಲಿವೊ; ಮಾತಾನೆ ತೆಲ ಲಗಾಡಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ತೆಳಾಮಾ ತುಮೆ ಉಪಾಸ ಕರಾಡಾಸ ಕವಾನು ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ಥಾತು ನೈ. ತೆನೈಸೊ ತುಮೊನೆ ನೈ ದಿಕ್ಹಾಲೊ ತುಮಾರೊ ಬಾ ತುಮೊನೆ ದೆಕಸ. ದಡೈನ ಕರಾನಾ ಕಾಮೊ ದೆಕಾಲೊ ತುಮಾರೊ ಬಾ ತುಮೊನೆ ಪ್ರತಿಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ತುಮಾರಾ ಹುತಿ ಎ ಜಿಮಿನಪರ ಆಸ್ತಿ ಕರಿಲಿವೊ ನಕೊ.ತೆ ಕ್ಹಾರು ನುಶಿ ಲಾಗಿನ ಹಾಳ ಥಾವಸ. ಚ್ವಟ್ಟಾ ತುಮಾರಾ ಘರಪರ ಡೊಳೊ ಮ್ಹೆಲಿನ ತುಮೊಕನ ರ‍್ಹವಾನು ಕಾಳ್ಳಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ತಿನಾಹುತಿ ತುಮಾರಿ ಆಸ್ತಿ ಪರಲೊಕಮಾ ಕರಿವೊ. ತ್ಯಾ ತೆ ಕ್ಹಾರಾನೆ ನುಶಿಯೊಬಿ ನೈ ಲಾಗತಾ ಜಂಗಬಿ ನೈ ಲಾಗತು. ಚ್ವಟ್ಟಾ ಡೊಳೊ ಮ್ಹೆಲಿನ ಕಾಳ್ಳೆತಾಬಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ತುಮಾರಿ ಆಸ್ತಿ ಕಜಾ ರ‍್ಹವಸ ತ್ಯಾಜ ತುಮಾರು ಮನಸ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ಡೊಳೊ ಅಂಗನೆ ಉಜಾಲು ಥಯೊಸ. ತಾರೊ ಡೊಳೊ ಕರೆಟ್ಟ ರ‍್ಹಯೊಮ, ತಾರು ಪುರಾ ಅಂಗ ಉಜಾಲಾಕ್ಹು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ತೆನೈಸೊ ತಾರೊ ಡೊಳೊ ಕೆಟ್ಟ ರ‍್ಹಯಲೊಮ, ತಾರು ಪುರಾ ಅಂಗ ಅಂದಾರಾಮಾ (ಪಾಪಮಾ) ಭರಲ ರ‍್ಹವಸ. ತಾರಾಮಾ ರ್xಹವಾನು ಯಕ್ಕಜ ಉಜಾಲು ಕ್ಹರಿಮಾಜ಼ ಅಂದಾರು ಥಯುಮ, ತೆಳಾಮಾ ಮರಣನಾ ಅಂದಾರಾಮಾ ರ್xಹಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ಕಯೊಬಿ ಬೆ ಮಾಲಕೊನೆ ಯಕ್ಕಜ ಟೈಮಮಾ ಸೆವಾ ನೈ ಕರಸಕ್ತೊ. ತೆ ಯಕ್ಕ ಮಾಲಕನೆ ದ್ವೆಶ ಕರಿನ ವರಿ ಯಕ್ಲಾನೆ ಮಯಾ ಕರಸ ತೆನೈಸೊ ಯಕ್ಕ ಮಾಲಕನಾ ಪಾಚೊ಼ ಗೈನ ವರಿ ಯಕ್ಲಾನೆ ಇನ್ಕಾರಸ. ತಿನಾಹುತಿ ತು ಕ್ಹುದಾನೆ ವರಿ ದೊಕ್ಡಾನೆ ಯಕ್ಕಜ ಟೈಮಮಾ ಸೆವಾ ನೈ ಕರಸಕ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ತಿನಾಹುತಿ ತುಮಾರಾ ಜಲಮನೆ ಚಾ಼ಯೆ ಥಯಲ ಅನ್ನನಾ ಹುತಿ ರ‍್ಹವಾದೆ ಅಂಗನೆ ಚಾ಼ಯೆ ಥಯಲ ವಣ್ಣಾನಾ ಹುತಿ ರ‍್ಹವಾದೆ ತುಮೆ ಚಿಂತಾ ಕರು ನೈ. ಜ಼ಲಮ ಅನ್ನತಿಬಿ ಅಂಗ ವಣ್ಣಾತಿಬಿ ಘನ್ನು ಖಾಸ ವ್ಹೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ಪಕ್ಷಿಯೊಕನ್ನ ದೆಕೊ ತ್ಯುನೆ ಬಿತ್ತತಾ ನೈ, ಕಾಟತಾ ನೈ ತೆತೆ ಕಣಜಮಾ ಜಮಾ ಕರಲೆತಾ ನೈ. ತೆತೆ ಪರಲೊಕಮಾ ರ‍್ಹವಾಲೊ ತುಮಾರೊ ಬಾ ತ್ಯುನೊನೆ ಅನ್ನ ದಿವಸ ತುಮೆ ತೆ ಪಕ್ಷಿಯೊತಿಬಿ ಘನ್ನಾ ಅಮುಲ್ಯ ವ್ಹೈ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ತುಮೆ ಚಿಂತಾ ಕರಾಕ್ಹು ತುಮಾರಿ ಆಯಸ ಜಾಸ್ತ ಸು ನೈ ಥಾತಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ವಣ್ಣಾವೊನಾ ಹುತಿ ಚಿಂತಾ ಕರಾನು ಕಾ ಖೆತರಮಾ ರ‍್ಹವಾನಾ ಫುಲ್ಲೊನೆ ದೆಜೊ. ತ್ಯುನೆ ಬೆಳದಾನು ದೆಕೊ. ತ್ಯುನೆ ರಾಬತಾ ನೈ ತೆತೆ ತ್ಯುನಾ ಹುತಿ ವಣ್ಣಾ ಶಿಲೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸು ವ್ಹೈ ಕದ್ಯಾಮ, ಸೊಲೊಮೊನ ತಿನಿ ವೈಭವಕ್ಹು ರ‍್ಹತಾಮಾಬಿ ಎ ಫುಲ್ಲೊಮಾ ಯಕ್ಕನೆ ರ‍್ಹವಾನಿ ಕ್ಹುಬಸುರತ ರ‍್ಹಯಲ ವಣ್ಣಾ ಘಾಲಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ವಾಟ್ಮಾ ರ‍್ಹಯಲ ಚಾರಾನೆ ಕ್ಹುದಾ ತಿಮ್ಮ ವರಾಡಸ. ಚಾರೊತಬಿ ಹಮ್ನಾ ರ‍್ಹೈನ ವಂತಾ ಆಗನಾ ಪಾಲೆ ತಾವಸ. ತಿನಾಹುತಿ ಕ್ಹುದಾ ತುಮೊನೆ ಕ್ಯಕ್ಲೊಕಿ ಜಾಸ್ತ ಪೆರಾಡಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಕಮ್ಮ ವಿಶವಾಸ ರ‍್ಹಯಲವಾಲಾವೊ ಲಿಂಗತ ಥಾವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ಹಮೆ ಸು ಖೌ? ಸು ಪಿವು? ಸು ಪೆರಲ್ಯು? ಕೈನ ಚಿಂತಾ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ಕ್ಹುದಾನೆ ನೈ ತಿಳದಿಲಿದಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಎ ಕ್ಹಾರು ಪಡ್ದಿಲಿವಾನೆ ಕೊಶಿಶ ಕರಸ. ಚಿಂತಾ ಕರೊ ನಕೊ, ಕಾ ಕದ್ಯಾಮ ಎ ಕ್ಹಾರು ತುಮೊನೆ ಜರುರತ್ತ ಛೆ ಕೈನ ಪರಲೊಕಮಾ ರ್xಹಲವಾಲಾ ತುಮಾರಾ ಬಾನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ತಿನಾಹುತಿ ತುಮೆ ಕ್ಹುದಾನಾ ರಾಜ್ಯನಾ ಹುತಿ ವರಿ ತಿನಿ ಚಿತ್ತನಾ ಲಿಂಗತ ಕಾಮೊ ಕರಾನೆ ಘನ್ನಾ ಹರಬಡು. ತೆಳಾಮಾ ತುಮೊನೆ ಜರುರತ್ತ ರ‍್ಹಯಲ ಕ್ಹಾರುಬಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ತಿಕ್ಹುನೆ ವಂತ್ತಾನಾ ಹುತಿ ಚಿಂತ್ತಾ ಕರೊ ನಕೊ. ಹರ ದಿನ್ನ ತಿನುಜ ರ‍್ಹಯಲ ಕ್ಯಕ್ಲಾಕಿ ತ್ರಾಸೊ ಹೊಂದಲ ರ‍್ಹವಸ. ವಂತ್ತಾಬಿ ತಿನುಜ ರ‍್ಹಯಲ ಚಿಂತ್ತಾ ಹೊದಲ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ಬಿಜಾ಼ವೊನೆ ಫೈಸಲೊ ಕರೊ ನಕೊ. ತೆಳಾಮ ಕ್ಹುದಾ ತುಮೊನೆ ಫೈಸಲೊ ನೈ ಕರತೊ. ");
INSERT INTO sle_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ತುಮೆ ಬಿಜಾ಼ವೊನೆ ಫೈಸಲೊ ಕರ‍್ಯಾಮ, ತಿನಾ ಲಿಂಗತಜ ಫೈಸಲೊ ಥಾವಸ. ತುಮೆ ಬಿಜಾ಼ವೊನೆ ಮಾಫ ಕರ‍್ಯಾಮ ತುಮೊನೆಬಿ ಮಾಫಿ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ತಾರಾ ಕ್ಹುದನಾ ಡೊಳಾಮಾ ರ‍್ಹವಾನಿ ಛಕ್ಕಿ ತು ದೆಕ್ಯಾ ಬಗರ ತಾರಾ ಭೈನಾ ಡೊಳಾಮಾ ರ‍್ಹಯಲ ಬಾರಿಕ ಕಸಾ ಕಾ ದೆಕಶಿ? ");
INSERT INTO sle_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ತಾರಾ ಡೊಳಾಮಾ ರ‍್ಹಯಲ ಬಾರಿಕ ಕಸಾ ಮಿ ಭಾರೊ ಕಾಡುಸ ಕೈನ ತಾರಾ ಭೈನೆ ಕಾ ಕಶಿ? ಪೈಲಾ ತಾರೊ ಡೊಳೊ ದೆಕಿಲೆ! ತಾರಾ ಡೊಳಾಮಾ ಛಕ್ಕಿ ಹಜುನ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ತು ಕಪಟಿ ವ್ಹೈ ತಾರಾ ಡೊಳಾಮಾ ರ‍್ಹವಾನಿ ಛಕ್ಕಿನೆ ಭಾರೊ ಕಾಡ. ತೆಳಾಮಾ ತಾರಾ ಭೈನಾ ಡೊಳಾಮಾ ರ‍್ಹವಾನಿ ಬಾರಿಕ ಕಸಾ ಕಾಡಾನೆ ತುನೆ ಚೊಕಿತಾ ದಿಕ್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ಪರಿಶುದ್ದ ರ‍್ಹಯಲ ಚಿಜೊ ಕುತ್ರಾವೊನೆ ಘಾಲೊ ನಕೊ. ತ್ಯುನೆ ಫರಿನ ತುಮೊನೆ ಕಡ್ಡಸ. ಡುಕ್ಕುರೊನಾ ಕ್ಹಾಮಾ ತುಮಾರಾ ಮುತ್ತೊ ನಾಕೊ ನಕೊ. ತ್ಯುನೆ ಮುತ್ತೊನೆ ಖುಂದಿಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ಮಾಂಗಿಲಿವೊ, ತೆಳಾಮಾ ತುಮೊನೆ ದಿವಸ. ಹುಡ್ಕೊ, ತೆಳಾಮಾ ತುಮೊನೆ ಮಳಸ. ಬಾಕಲ ವಜಾಡೊ, ತೆಳಾಮಾ ತೆ ತುಮಾರಾ ಹುತಿ ಕ್ಹುಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ಹೊ, ಪುಚ್ಚತೊಜ ರ‍್ಹವಾಲೊ ಪಡ್ದಿಲಿವಸ, ಹುಡಕ್ತೊ ರ‍್ಹವಾಲಾನೆಜ಼ ಮಳಸ, ವಜಾ಼ಡತೊ ರ‍್ಹವಾಲಾನೆಜ಼ ಬಾಕಲ ಕ್ಹುಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ತುಮಾರೊ ದಿಕ್ರೊ ರೊಟ್ಲೊ ಪುಚ್ಯೊಮ ದಗ್ಡೊ ದಿವೊಶಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ಮಚ್ಲಿ ಪುಚ್ಯಾಮ, ಕ್ಹಾಪ ದಿವೊಶಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ತುಮೆ ಕ್ಹುದಾ ಲಿಂಗತ ಚೊ಼ಕಾತೊ ನವ್ಹೈ, ಕೆಟ್ಟ ರ‍್ಹಯಲಾತೊಬಿ ತುಮಾರಾ ಬಚ್ಚಾವೊನೆ ಚೊ಼ಕಾಜ಼ ಚಿಜೊ ದ್ಯು ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಪರಲೊಕನೊ ತುಮಾರೊ ಬಾ ಬಿ ತಿನೆ ಪುಚ್ಚಾಲಾವೊನೆ ಛೊಕಾ ಚಿಜೊ ಕ್ಹರಿಮಾಜ಼ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ತುಮೊನೆ ಬಿಜಾ ಸು ಕರು ಕೈನ ತುಮೆ ಆಶಾ ಕರೊಶಿತೊ ತೆಜ಼ ತುಮೆ ತ್ಯುನೊನೆ ಕರೊ. ಎ ಮೊಶೆನು ಧರ್ಮಶಾಸ್ತ್ರನು ವರಿ ಪ್ರವಾದಿವೊನಾ ಬೊದನೆನು ಸಾರಾಂಶ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ತ್ರಾಸನಾ (ಇಕ್ಕಟ್ಟನಾ) ಬಾಕಲಕ್ಹು ಪರಲೊಕ ರಾಜ್ಯಮಾ ಪ್ರವೆಶ ಕರೊ. ನರಕನೆ ಜಾ಼ವಾನಿ ವಾಟ ಮ್ಹೊಟಿ ವ್ಹೈ, ಬಾಕಲ ಘನ್ನು ಮ್ಹೊಟು ಶೆ. ಘನ್ನಾ ಜ಼ನಾ ತೆ ಬಾಕಲಮಾ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ತೆನೈಸೊ ನಿತ್ಯಜಿವನೆ ರ‍್ಹಯಲ ಬಾಕಲ ಘನ್ನು ನ್ಹಾನು ಛೆ, ವಾಟ ಕಷ್ಟನಿ ಛೆ. ದಕ್ಹಾಜ಼ ಜ಼ನಾ ತೆ ವಾಟನೆ ಇನಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ಸುಳ್ಳ ಪ್ರವಾದಿಯೊನಾ ಹುತಿ ಹುಶಾರ ರಹೊ. ತ್ಯುನೆ ಬಕ್ರಾವೊ ಲಿಂಗತ ದಿಕ್ಹಿನ ತುಮೊಕನ ಆವಸ. ತೆನೈಸೊ ತೊಳೊ ಲಿಂಗತ ಕ್ಹರಿಮಾಜ಼ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಲಿಂಗತಜ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ತ್ಯುನಾ ಕರಾನಾ ಕಾಮೊಕ್ಹು ತುಮೆ ತ್ಯುನೊನೆ ತಿಳ್ದಿಲಿವೊಶಿ. ಕಾಟಾವೊನಾ ಝಾಡಮಾ ಕಿಮ ದ್ರಾಕ್ಷಿಯೊ ಮಳತಾ ನೈ ತಿನಾ ಲಿಂಗತ ಚೊ಼ಕಾ ಕಾಮೊ ಕೆಟ್ಟ ಮನಕ್ಹೊಕ್ಹು ನೈ ಆತಾ.ಅಂಜುರೊ ಕಾಟಾವೊನಾ ಝಾಡಮಾ ನೈ ಮಳ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ತಿನಾ ಲಿಂಗತ ಹರಿ ಯಕ್ಕ ಚೊ಼ಕು ಝಾಡ ಚೊ಼ಕು ಫಲ ದಿವಸ. ಕೆಟ್ಟ ಝಾಡ ಕೆಟ್ಟ ಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ಚೊ಼ಕು ಝಾಡ ಕೆಟ್ಟ ಫಲ ದೆತು ನೈ ವರಿ ಕೆಟ್ಟ ಝಾಡ ಚೊ಼ಕು ಫಲ ದೆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ಚೊ಼ಕು ಫಲ ನೈ ದಿವಾನಾ ಝಾಡನೆ ಕತ್ರಿನ ಆಗಮಾ ನಾಕಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ಎ ಸುಳ್ಳ ಬೊಧಕರೊನೆ ತ್ಯುನೆ ದಿವಾನಾ ಫಲಕ್ಹುಜ (ಕಾಮೊಕ್ಹುಜ಼) ತುಮೆ ತಿಳದಿಲಿವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ಮಿ ಪ್ರಭುನೊ ವ್ಹೈ ಕೈನ ಕ್ಹಾಲಿ ಕದಲಕ್ಹು ಮನಕ್ಹ ಪರಲೊಕ ರಾಜ್ಯನೆ ಪ್ರವೆಶ ಕರಾನು ಸಾದ್ಯ ನತ್ತಿ. ಪರಲೊಕಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಬಾನಾ ಮನಸನೆ ಚೊ಼ಕು ಲಾಗಲಿಂಗತ ಕರಾಲಾಜಾ ಪರಲೊಕ ರಾಜ್ಯನೆ ಪ್ರವೆಶ ಕರ ಸಕಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ಲಾಸ್ಟನಾ ದಿನೊಮಾ ಘನ್ನಾ ಜ಼ನಾ ಮನೆ, ತುಜ಼ ಮಾರೊ ಪ್ರಭು ವ್ಹೈ! ತಾರಾ ವಿಶಯಮಾ ಹಮೆ ಬೊಧನೆ ಕರ‍್ಯಾಸ.ತಾರಾ ನಾಮನಾ ಮಿಲ ಭುತ್ಡಾವೊನೆ ಛೊಡಾಯಾಸ ವರಿ ಘನ್ನಾ ಅದ್ಬುತ ಕಾಮೊ ಕರ‍್ಯಾಸ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ತೆನೈಸೊ ಮಿ ತ್ಯುನೊನೆ, ಅಧರ್ಮಿಯೊ, ಮಕಂತಾ ಜಾ಼ವೊ. ತುಮೆ ಕುನ್ನ ವ್ಹೈ ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ಚೊ಼ಕಿತರಾ ಕೈಪಡುಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ಮಾರಾ ವಾತೊ ಐಕಿನ ತೆ ವಾತೊನೆ ವಿಧೆಯ ಥೈನ ರ‍್ಹಯಲ ಹರಯಕ್ಲೊ ತಿನಾ ಘರನೆ ದಗ್ಡಾಪರ ಭಾಂದವಾಲಾ ಶಾಣಾನೆ ಮಳ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ಜೊ಼ರ ರ‍್ಹಯಲ ಪಾನಿ ಐನ ಉಪ್ಪರ ಚ಼ಡಸ. ವಾರೊ ಛುಟಿನ ತೆ ಘರನೆ ಲಾಗಸ. ತೆನೈಸೊ ತೆ ಘರ ದಗ್ಡಾಪರ ಭಾಂದಲಕ್ಹು ತೆ ಪಡ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ತೆನೈಸೊ ಮಾರಾ ವಾತೊ ಐಕಿನಬಿ ತಿನೆ ವಿದೆಯ ನೈ ಥಯಲವಾಲೊ ಬುದ್ಧಿ ತೆವಾಲೊ ಥಯೊಸ. ತೆ ಬುದ್ಧಿ ತೆವಾಲೊ ಉಸುಕಪರ ತಿನು ಘರ ಭಾಂದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ಜೊ಼ರ ಪಾನಿ ಐನ ಉಪ್ಪರ ಚ಼ಡಸ. ವಾರೊ ಛುಟಿನ ತೆ ಘರನೆ ಲಾಗಸ. ತೆಳಾಮಾ ತೆ ಘರ ಪಡಿಗಯು. ");
INSERT INTO sle_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ಯೆಸು ಎ ವಾತೊ ಕದಲ್ಪರ ಎ ಸಂಗತಿಯೊನೆ ಐಕಿನ ಮನಕ್ಹೊ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ಕಾ ಕದ್ಯಾಮ, ತೆ ಧರ್ಮೊಪದೆಶಕರೊ ಲಿಂಗತ ಉಪದೆಶ ಕರ‍್ಯಾವಾಚಿ ಅಧಿಕಾರ ರ‍್ಹಯಲೆಲವಾಲಾ ಲಿಂಗತ ಉಪದೆಶ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ಯೆಸು ಡೊಂಗರಪರತೊ ಉತ್ರಿನ ಹೆಟೊ ಆಯೊ. ಮನಕ್ಹೊ ಗುಂಪ-ಗುಂಪ ಥೈನ ಯೆಸುನಾ ಪಾಚಾ಼ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ತೆಳಾಮಾ ಯಕ್ಕ ಕುಷ್ಠ ರೊಗಿ ಯೆಸುಕನ ಆಯೊ. ತೆ ಯೆಸುನಾ ಅಗೊ ಅಡ್ಡ ಪಡಿನ, ಪ್ರಭು, ತು ಮನಸ ಕರ‍್ಯೊಮ ಮನೆ ಅರಾಮ ಕರಶಿ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ಯೆಸು ತಿನೆ ಮುಟ್ಟಿನ, ತುನೆ ಅರಾಮ ಕರಾನೆ ಮನೆ ಮನಸ ಛೆ, ಅರಾಮ ಥಾ” ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತಿನೆ ರ‍್ಹಯಲ ಕುಷ್ಠ ರೊಗ ಗೈನ ಅರಾಮ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ಯೆಸು ತಿನೆ, ಎ ಕಿಮ್ಮ ಥಯು ಕೈನ ಕಿನೆ ಕೌ ನಕೊ. ಹಮ್ನಾ ತು ಗೈನ ಯಾಜಕನೆ ತಾರು ಅಂಗ ದೆಕಾಡ. ಅರಾಮ ಥಯಲವಾಲಾ ಮೊಶೆನಿ ಆಗನ್ಯಾ ಲಿಂಗತ ದಿವಾನಿ ಕಾಣಿಕ ದೆ. ತು ಅರಾಮ ಥಯಲನೆ ತೆ ಸಾಕ್ಷಿ ಥೈನ ರ‍್ಹವಾದೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ಯೆಸು ಕಪೆನೌರ್ಮ ಕವಾನಾ ಗಾಮೆ ಗಯೊ. ತೆ ಗಾಮಮಾ ಗಯಲ ಬರೊಬ್ಬರ ಸೈನ್ಯನೊ ಅದಿಕಾರಿ ಯಕ್ಲೊ ಐನ, ");
INSERT INTO sle_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ಪ್ರಭು, ಮಾರಾ ಆಳನೆ ತೌ ಐನ ವಚ್ಚಾ಼ನಾಪರ ಪಡ್ಯೊಸ. ತೆ ಘನ್ನಾ ದುಖಕ್ಹು ನೆಳ್ಳಾಡೊಸ” ಕೈನ ಮದತ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ಯೆಸು ತೆ ಅಧಿಕಾರಿನೆ, ಮಿ ಐನ ತಿನೆ ಅರಾಮ ಕರುಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ತಿಕ್ಹುನೆ ತೆ ಅದಿಕಾರಿ, ಪ್ರಭು, ತು ಮಾರ ಘರೆ ಆವಾ ಅಕ್ಲಿ ಬಿ ಯೊಗ್ಯತೆಬಿ ಮನೆ ನತ್ತಿ. ತಿನೆ ಅರಾಮ ಥಾವಾದೆ ಕೈನ ತು ಆಗನ್ಯಾಪಿಶ್ಯೊಮ ಬಸ, ತಿನೆ ಅರಾಮ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ಮಿ ಬಿ ಬಿಜಾ ಅಧಿಕಾರಿಯೊನಾ ಹತ್ಮಾ ವ್ಹತ್ತೊ. ಮಾರಾ ಅಧಿನಮಾ ಸಿಪಾಯಿಯೊ ಛೆ. ಮಿ ಯಕ್ಕ ಸಿಪಾಯಿನೆ ‘ಜಾ’ ಕದ್ಯೊ ಕದ್ಯಾಮ ತೆ ಜಾ಼ವಸ; ಬಿಜೆಕ್ಲಾನೆ ‘ಆ’ ಕದ್ಯೊ ಕದ್ಯಾಮ ತೆ ಆವಸ. ಮಿ ಮಾರಾ ಸೆವಕನೆ, ‘ಆಂ ಕರ’ ಕದ್ಯೊ ಕದ್ಯಾಮ ತೆ ವಿದೆಯತೆಕ್ಹು ಕರಸ. ತುನೆಬಿ ಎಜ ತರಾನು ಅಧಿಕಾರ ಶೆ ಕೈನ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ಎ ಐಕಿನ ಯೆಸು ಘಾಬ್ರೊ ಥಯೊ. ಯೆಸು ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನೆ, ಮಿ ಇಸ್ರಾಯೆಲಮಾ ಬಿ ಅಕ್ಲಾ ಬರ್xಹೊಕಾನಾ ಮನಕ್ಹನೆ ದೆಕ್ಯೊ ನೈ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ಘನ್ನಾ ಮನಕ್ಹೊ ಪುರ್ವ ವರಿ ಪಶ್ಚಿಮ ದಿಕ್ಕೊತಾ ಆವಸ. ತ್ಯುನೆ ಪರಲೊಕ ರಾಜ್ಯಮಾ ಅಬ್ರಹಾಮ, ಇಸಾಕ, ಯಾಕೊಬ ಇವ್ನಾ ಕ್ಹಾತೆ ಬೈಟಿನ ಖಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ತೆನೈಸೊ ಪರಲೊಕ ರಾಜ್ಯ ನೈ ಹೊಂದಲವಾಲಾವೊನೆ ಭಾರಾ ಅಂದಾರಾಮಾ ಭಿರಕೈ ಪಡಸ. ತ್ಯಾ ತ್ಯುನೆ ಗೊಳಾಡಸ ವರಿ ದುಖಕ್ಹು ದಾತೊ ಖಾವಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ಪಾಚಲ್ತೊ ಯೆಸು ತೆ ಅಧಿಕಾರಿನೆ, ದಿಕ್ರಾ ಜಾ ತು ನಂಬಲಿಂಗತಜ಼ ತಾರಾ ಸೆವಕನೆ ಅರಾಮ ಥಾವಸ” ಕದ್ಯೊ. ತೆಜ ಟೈಮಮಾ ತಿನಾ ಸೆವಕನೆ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ಯೆಸು ಪೆತ್ರಾನಾ ಘರೆ ಗಯೊ. ತ್ಯಾ ಪೆತ್ರಾನಿ ಪ್ಹೈ ಘನ್ನಾ ತೌಕ್ಹು ವಚ್ಚಾನಾಪರ ಕ್ಹುರಯಲ ಯೆಸು ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ಯೆಸು ತಿನೊ ಹತ್ತ ಮುಟ್ಟೆಲ ಬರೊಬರ ತೌ ತಿನೆ ಛೊಡಿನ ಗೈ ಪಡ್ಯೊ. ತೆಳಾಮಾ ತೆ ಉಟಿನ, ತಿನಿ ಸೆವಾ ಕರಿ. ");
INSERT INTO sle_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ತೆ ದಿನ್ನೆ ಕ್ಹಾಂಜೆ ಮನಕ್ಹೊ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರೆಲವಾಲಾ ಘನ್ನಾ ಜ಼ನಾ ಯೆಸುಕನ ಬಲೈಲಿನ ಆಯಾ. ಯೆಸು ಖಾಲಿ ವಾತೊಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ತ್ಯುನಾಮಾತೊ ನ್ಹಟಾಡ್ಯೊ; ರೊಗೊಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ತೆ ಅಪ್ನಾ ತ್ರಾಸೊ ಕ್ಹಾದ್ಯೊ, ಅಪ್ನಾ ರೊಗೊ ಉಚೈಲಿದ್ಯೊ (ಯೆಶಾಯ 53:4) ಕೈನ ಯೆಶಾಯ ಕವಾಲಾ ಪ್ರವಾದಿಕ್ಹು ಕದಲ ವಾತ ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ಯೆಸು ತಿನಾ ಸುತ್ತೆ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ದೆಕಿನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸಮುಂದರನಾ ಬಿಜಿ ದಂಡಿ ಬಗಲ ಜಾ಼ವಾನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ತೆಳಾಮಾ ಧರ್ಮವುಪದೆಶ ಕರಾಲೊ ಯೆಸುಕನ ಐನ, ಗುರು, ತು ಕಯಾ ಜ಼ಗಾಬಿ ಗಯೊಮ ಮಿ ತಾರಾ ಪಾಚೊ಼ ಔಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ಯೆಸು ತಿನೆ, ನರಿಯೊನೆ ಗುಹೆ ಛೆ, ಪಕ್ಷಿಯೊನೆ ಗುಡೊ ಛೆ. ತೆನೈಸೊ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಮಾತು ಮ್ಹೆಲಾಯಕ್ಲಿ ಜ಼ಗಾ ನತ್ತಿ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ಶಿಷ್ಯಾವೊನಾ ಯಕ್ಲೊ ಯೆಸುನೆ, ಮಿ ಪೈಲಾ ಗೈನ ಮಾರಾ ಬಾನು ತನ್ನದಿನ್ನು ಕರಿನ ಆವಾನೆ ಮನೆ ಅಪ್ಪಣೆ ದೆ. ಪಾಚಲ್ತೊ ಮಿ ತಾರಾ ಪಾಚೊ಼ ಔಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ತೆನೈಸೊ ಯೆಸು ತಿನೆ, ಮರಲವಾಲಾಜ ತ್ಯುನಾ ತ್ಯುನಾಮಾ ಮರಲವಾಲಾವೊನು ತನ್ನದಿನ್ನು ಕರಿಲಿವಾದೆ. ಮಾರಾ ಪಾಚೊ಼ ಆ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ಯೆಸು ಹಡ್ಗಾಮಾ ಗಯೊ ತಿನಾ ಶಿಷ್ಯಾಬಿ ತಿನಾ ಕ್ಹಾತೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ಹಡ್ಗೊ ದಂಡಿ ಛೊಡಲ್ಪರ ಮ್ಹೊಟೊ ವಾರಾನು ತುಫಾನ ಸಮುದ್ರಪರ ಐಯು. ತೆನೈಸೊ ಯೆಸು ಹಡ್ಗಾಮಾ ಕ್ಹುರಾಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿಕನ ಗೈನ ತಿನೆ ಉಟಾಡಿನ, ಪ್ರಭು, ಹಮೊನೆ ವಚಾ಼ಡ! ಹಮೆ ಡುಬಾಡಸ!” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ಯೆಸು, ತುಮೆ ಭುಚ಼ಕಾನು ಶ್ಯಾನೆ? ತುಮೊಮಾ ನಕ್ಕರಬಿ ಬರೊಕ್ಹೊ ನತ್ತಿ” ಕೈನ ಉತ್ತರ ದಿನ ಉಟಿನ ಹುಬ್ರೈನ ತೆ ತುಫಾನನೆ ಅಗನ್ಯಾ ದಿದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತೆ ತುಫಾನ ಹುಬ್ರೈ ಗಯು. ಸಮಂದರ ಶಾಂತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ತ್ಯುನೆ ಕ್ಹಾರಾ ಘಾಬ್ರಾ ಥಯಾ. ಎ ಕ್ಯವೊ ಮನಕ್ಹ ವ್ಹೈ? ಬಿರುಗಾಳಿ ವರಿ ಪಾನಿ ಇನೆ ವಿಧೆಯ ಥಾವಸ್ತೊ” ಕೈನ ಬೊಲಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ಯೆಸು ಸಮುಂದರನಾ ಬಿಜೆಕ ದಂಡಿಕ ರ‍್ಹಯಲ ಗದರೆನ ಕವಾನಾ ಗಾಮೆ ಆಯೊ.ತ್ಯಾ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಬೆಜ಼ನಾ ಯೆಸುಕನ ಆಯಾ. ತ್ಯುನೆ ಮಜಾ಼ರೊನಾ ಗವಿಯೊನಾ ವ್ಹತ್ತಾ ವರಿ ಘನ್ನಾ ಖತರನಾಕ ವ್ಹತ್ತಾ. ತಿನಾಹುತಿ ಮನಕ್ಹೊ ತ್ಯುನಿ ವಾಟಕನ ಜಾ಼ತಾ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ಯೆಸುಕನ ಐನ. ತು ಹಮೊನೆ ಸು ಕರು ಕೈನ ವಿಚಾರ ಕರ‍್ಯೊಸ? ಕ್ಹುದಾನಾ ದಿಕ್ರಾ, ಟೈಮ ಆವಾತಿ ಪೈಲಾ ಹಮೊನೆ ಶಿಕ್ಷಾ ದಿವಾನೆ ಆಯೊ ಸು?” ಕೈನ ಜೊ಼ರ ಅಡ್ಡಿನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ತೆ ಜ಼ಗಾಕನ ಢುಕ್ಕುರೊನು ಮ್ಹೊಟ್ಟು ಗುಂಪ ಚ಼ರಾಡುತು. ");
INSERT INTO sle_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ, ಹಮೆ ಎ ಭಂಬಿಜ಼ನಾವೊನೆ ಛೊಡಿನ ಜಾ಼ವಾವರ್ಕ್ಹು ತು ಕರಾನೊ ರ‍್ಹಯೊಮ, ದಯಾ ಕರಿನ ಹಮೊನೆ ತೆ ಡುಕ್ಕುರೊಮಾ ವಳಾ” ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ಯೆಸು ತ್ಯುನೊನೆ, ಜಾ಼ವೊ” ಕದ್ಯೊ. ತೆಳಾಮಾ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ತೆ ಭಂಬಿ ಜ಼ನಾವೊನೆ ಛೊಡಿನ ಢುಕ್ಕುರೊಮಾ ಗಯಾ. ತೆಳಾಮಾಜ಼ ಕ್ಹಾರಾ ಢುಕ್ಕುರೊ ಡೊಂಗರನಾ ಹೆಟಾ ನ್ಹಾಟಿನ ಸಮುಂದರಮಾ ಪಡಿನ ಪಾನಿಮಾ ಡುಬಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ತೆಳಾಮ ಢುಕ್ಕುರೊ ಚ಼ರಾವಾಲಾ ಗಾಮಮಾ ನ್ಹಾಟಿನ ಗೈನ ಢುಕ್ಕುರೊನೆ ಬಿ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಧರಲವಾಲೊನೆಬಿ ಥಯಲ ಮನಕ್ಹೊನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ತೆಳಾಮ ತೆ ಗಾಮನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ದೆಕಾನೆ ಗೈನ, ತ್ಯುನಿ ಜ಼ಗಾ ಛೊಡಿನ ಜಾ಼ ಕೈನ ತಿನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ಯೆಸು ಹಡ್ಗೊ ಚ಼ಡಿನ ಸಮುಂದರ ದಾಟಿನ ತಿನಾ ಸ್ವಂತ ಗಾಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ತೆಳಾಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಯಕ್ಕ ಲಕ್ವೊ ಮಾರಲ ರೊಗಿನೆ ಯೆಸು ಕನ ಲಾಯಾ ತೆ ತಿನಾ ವಚ್ಚಾನಾಪರ ಕ್ಹುರಯೊತೊ. ಯೆಸು ಎ ಮನಕ್ಹೊಮಾ ರ‍್ಹಯಲ ಮ್ಹೊಟ್ಟೊ ಭರೊಕ್ಹೊ ದೆಕಿನ ಲಕ್ವೊ ಮಾರ ರೊಗಿನೆ, ಎ ಜಾಂಜಿಮಾನ ಪಟ್ಟಾ, ಕ್ಹುಶಿ ಥಾ. ತಾರಾ ಪಾಪೊ ಮಾಫ ಥಯಾಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ತ್ಯಾ ರ‍್ಹಯಲ ಧರಮ ಉಪದೆಶಕೊ ತೆ ಐಕಿನ, ಎ ಕ್ಹುದಾನಿ ದುಶಣೆ ವ್ಹೈ” ಐನ ತ್ಯುನೊಮಾಜ಼ ಕೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ತ್ಯುನೆ ಇಮ್ಮ ವಿಚಾರ ಕರಾನು ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯುತು. ತೆ ತ್ಯುನೊನೆ, ತುಮೆ ಕಾ ಕೆಟ್ಟ ವಿಚಾರ ಕರಾಡಾಸ? ");
INSERT INTO sle_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ಕಯು ಆಸಾನ ವ್ಹೈ? ಎ ಲಕ್ವೊ ಮಾರಲ ರೊಗಿನೆ, ‘ತಾರಾ ಪಾಪೊ ಮಾಫ ಥಯಾಸ’ ಕೈನ ಕವಾನು ಸು ತೆನೈಸೊ ‘ಉಪ್ಪರ ಉಟ್ಟ ಚಾ಼ಲ’ ಕೈನ ಕವಾನು ಸು? ");
INSERT INTO sle_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ತೆನೈಸೊ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಪಾಪ ಮಾಫ ಕರಾನೆ ಭುಲೊಕಮಾ ಅದಿಕಾರ ಛೆ ಕವಾನು ಮಿ ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹೌ” ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ಯೆಸು ಲಕ್ವೊ ಮಾರಲ ರೊಗಿನೆ, ಉಟ್ಟ, ತಾರು ವಚ್ಚಾ಼ನೊ ಲಿನ ಘರೆ ಜಾ಼” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ತೆಳಾಮಾ ತೆ ಉಟಿನ ಘರೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ಮನಕ್ಹೊ ಎ ದೆಕಿನ ಘಾಬ್ರಾ ತಿಬ್ರ ಥಯಾ. ಮನಕ್ಹೊನೆ ಹೈ ಅದಿಕಾರ ದಿದಲಕ್ಹು ಮನಕ್ಹೊ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರ‍್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ಯೆಸು ಜಾ಼ತಾಮಾ, ಮತ್ತಾಯ ಕವಾಲಾ ಮನಕ್ಹನೆ ದೆಕ್ಯೊ. ಮತ್ತಾಯ ಭು ಭಾಡೊ ಲಿವಾನಾ ಕಟ್ಟಾಪರ ಬೆಟ್ಯೊತೊ. ಯೆಸು ತಿನೆ, ಮಾರಾ ಪಾಚೊ಼ ಆ” ಕದ್ಯೊ. ತೆಳಾಮಾ ಮತ್ತಾಯ ಉಟಿನ ಯೆಸುನಾ ಪಾಚೊ಼ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ಯೆಸು ಮತ್ತಾಯನಾ ಘರಮಾ ಗೈನ ಖಾವಾನೆ ಬೈಟ್ಯೊ. ಘನ್ನಾ ಮನಕ್ಹೊ ಭು ಭಾಡೊ ಲಿವಾಲಾ ವರಿ ಕೆಟ್ಟ ಮನಕ್ಹೊಬಿ ಯೆಸುನಾ ಕ್ಹಾತೆ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಖಾವಾನೆ ಬೈಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ಎ ದೆಕಿನ ಪರಿಸಾಯರೊ ಯೆಸುನಾ ಶಿಷ್ಯಾವೊನೆ, ತುಮಾರೊ ಬೊದಕ ಭು ಭಾಡೊ ಲಿವಾಲಾವೊನಾ ಕ್ಹಾತೆ ವರಿ ಕೆಟ್ಟ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಕಾ ಖಾವಸ?” ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ಪರಿಸಾಯರೊ ಕದಲ ಐಕಿನ ಯೆಸು ತ್ಯುನೊನೆ, ಅರಾಮ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಡಾಕ್ಟರನಿ ಜ಼ರುರತ ನತ್ತಿ. ರೊಗಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಡಾಕ್ಟರನಿ ಜರುರತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ತುಮೆ ಜಾ಼ವೊ, ‘ಮನಿ ಬಲಿ ನಕೊ, ಮರ್ಗಾ ಚಾ಼ಯೆ’ ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರದಲ ವಾಕ್ಯಾನು ಮತಲಬ ಶಿಕ್ಕಿಲಿವೊ. ಮಿ ನಿತಿವಂತವಾಲಾವೊನೆ ಬಲಾವೊನೆ ನತ್ತಿ ಆಯೊ, ಪಾಪಿಯೊನೆ ಬಲಾವಾನೆ ಆಯೊಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ಪಾಚಲ್ತಾ ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಯೆಸುಕನ ಆಯಾ. ತ್ಯುನೆ ಯೆಸುನೆ, ಹಮೆ ವರಿ ಪರಿಸಾಯರೊ ತೆಳಾಮ ತೆಳಾಮಾ ಉಪಾಸ ಕರಿಯೆಸ. ತೆನೈಸೊ ತಾರಾ ಶಿಷ್ಯಾ ಕಾ ಉಪಾಸ ನೈ ಕರ್ತಾ?” ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ಯೆಸು, ಹಿವಾನಾ ಟೈಮಮಾ ನ್ಹೌರಾನಾ ಕ್ಹಾತೆ ರ‍್ಹವಾನಾ ದೊಸ್ತೊ ದುಖಿ ನೈ ಥಾತಾ. ತೆನೈಸೊ ನ್ಹೌರೊ ತ್ಯುನೊನೆ ಛೊಡಿನ ಜಾ಼ವಾನೊ ಟೈಮ ಆವಸ. ತೆಳಾಮಾ ತ್ಯುನೆ ದುಖಿ ಥಾವಸ ವರಿ ಉಪಾಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ಯಕ್ಲೊ ಪ್ಹಾಟಿಗಯಲ ಜು಼ನ್ನಾ ಅಂಗ್ಡಾನೆ ನವಾ ಫಡ್ಕಾನು ಥಿಗ್ಡು ಘಾಲಿನ ಶಿತಾ ನೈ. ಯಕ್ಕೆಳೆ ಶಿಯಾತೊಬಿ, ತೆ ತಿಗ್ಡು ಅಂಗ್ಡಾಪರತು ಕಿತೈಜಾ಼ವಸ. ತೆಳಾಮಾ ತೆ ಅಂಗ್ಡು ಬಿದಕ್ಹು ಫಾಟಿ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ತೆನೈಸೊ ಮನಕ್ಹೊ ನವು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಜು಼ನ್ನಿಯೊ ದ್ರಾಕ್ಷಿಯೊನಾ ರಕ್ಹನಾ ಕೈಚಿಲಾಮಾ ನೈ ಘಾಲ್ತಾ; ಕಾ ಕದ್ಯಾಮ ಜುನ್ನಿಯೊ ಕೈಚಿಲಾ ಫಾಟಿ ಜಾ಼ವಸ; ವರಿ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ನಕೈ ಜಾ಼ವಸ. ತಿನಾ ಹುತಿ ಮನಕ್ಹೊ ಕೆಳಾಮಾಬಿ ನವು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ನವಾ ಕೈಚಿಲಾವೊಮಾ ಘಾಲಸ. ತೆಳಾಮಾ ಭಂಬಿ ಉಗ್ರಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ಯೆಸು ಎ ಸಂಗತಿಯೊ ಕತಾಮಾ ಸಭಾಮಂದಿರನೊ ಅದಿಕಾರಿ ಯಕ್ಲೊ ತಿಕನ ಐನ ತಿನೆ ಡೊಗ್ಗಿನ ನಮಸ್ಕಾರ ಕರಿನ, ಮಾರಿ ದಿಕ್ರಿ ಹಮನಾತೊಬಿ ಮರಿ ಗೈ. ತು ಐನ ತಿನೆ ಮುಟ್ಯೊಮ ತೆ ವರಿ ಜ್ಯುತಿ ಥಾವಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ತಿನಾಹುತಿ ಯೆಸು ಉಟಿನ ಅದಿಕಾರಿನಾ ಕ್ಹಾತೆ ಗಯೊ. ತಿನಾ ಕ್ಹಾತೆ ಶಿಷ್ಯಾಬಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ಬಾರಾ ವರಕ್ಹತಿ ರಕ್ತ ಕುಸಮ ರೊಗಮಾ ರ‍್ಹಯಲ ಯಕ್ಕ ಬಾಕ್ಡಿ ತ್ಯಾ ವ್ಹತ್ತಿ. ತೆ ಬಾಕ್ಡಿ ಯೆಸುನಾ ಪಾಚಿ ಐನ ತಿನಾ ಉಪ್ಪರಲ್ಯಾ ಅಂಗಡಾನಿ ತುದಿನೆ ಮುಟ್ಟಿ. ");
INSERT INTO sle_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ತೆಳಾಮ ತೆ ಬಾಕ್ಡಿ, ಮಿ ತಿನಾ ಅಂಗಡಾನೆ ಮುಟ್ಟಿಮ ಬಸ, ಮಿ ಅರಾಮ ಥೈ ಜೌಸ” ಕೈನ ವಿಚಾರ ಕರಿಲಿದಿತಿ. ");
INSERT INTO sle_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ಯೆಸು ಪಾಚೊ಼ ಫರಿನ ತೆ ಬಾಕ್ಡಿನೆ ದೆಕಿನ, ದಿಕ್ರಿ, ಖುಶಿ ಥಾ! ತಾರಾ ಭರೊಕ್ಹಾಕ್ಹುಜ ತುನೆ ಅರಾಮ ಥಯುಸ” ಕೈನ ಕದ್ಯೊ. ತೆಳಾಮಾ ತೆ ಅರಮ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ಪಾಚಲ್ತೊ ಯೆಸು ಅದಿಕಾರಿನಾ ಕ್ಹಾತೆ ಅಗೊ ಗೈನ ತಿನಾ ಘರಮಾ ಗಯೊ. ಮಾತಿ ಕರಾನಾ ಹುತಿ ಆಯಲ ಭಜ್ನಿ ವಾಲಾವೊನೆ ಬಿ ವರಿ ರವಾಲಾವೊನೆ ಬಿ ಯೆಸು, ");
INSERT INTO sle_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ದುರ ಜಾವೊ, ಚೊಕ್ರಿ ಮರಿ ನತ್ತಿ. ತೆ ನಿಂದರ ಕರಾಡಿಸ” ಕದ್ಯೊ. ತೆನೈಸೊ ತ್ಯುನೆ ಯೆಸುನೆ ಕದರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ಮನಕ್ಹೊನೆ ಘರಮಾತೊ ಭಾರೊ ವಳಾಯಲ್ಪರ ಯೆಸು ಛೊಕ್ರಿನಾ ಖೊಲಿಮಾ ಗಯೊ. ಯೆಸು ಛೊಕ್ರಿನು ಹತ್ತ ದರಲ್ಪರ ತೆ ಛೊಕ್ರಿ ಉಟಿನ ಹುಬ್ರೈ. ");
INSERT INTO sle_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ಎ ಸುದ್ದಿ ಸುತ್ತೆ ರ‍್ಹಯಲ ಗಾಮೊಮಾ ಫೈಲಿ. ");
INSERT INTO sle_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ಯೆಸು ತ್ಯಾಂತೊ ಜಾ಼ತಾಮಾ ಬಿ ಕುಡ್ಡಾ ತಿನಾ ಪಾಚಾ಼ ಲಾಗ್ಯಾ. ತ್ಯುನೆ, ದಾವಿದನಾ ದಿಕ್ರಾ, ಹಮೊನೆ ದಯಾ ದೆಕಾಡ” ಕೈನ ಜೊ಼ರ ಅಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ಯೆಸು ಘರಮಾ ಗಯೊ. ಕುಡ್ಡಾ ಬಿ ತಿನಾ ಕ್ಹಾತೆ ಗಯಾ. ಯೆಸು ತ್ಯುನೊನೆ, ಮಿ ತುಮೊನೆ ಅರಾಮ ಕರುಸ ಕೈನ ತುಮೆ ಭರೊಕ್ಹೊ ಕರೊಶಿ ಸು?” ಕೈನ ಪುಚ್ಯೊ. ಕುಡ್ಡಾ, ಹೊ ಪ್ರಭು, ಹಮೆ ಭರೊಕ್ಹೊ ಕರಿಯೆಸ” ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನಾ ಡೊಳಾ ಮುಟ್ಟಿನ, ತುಮೆ ಭರೊಕ್ಹೊ ಕರಲ ಲಿಂಗತಜ ತುಮೊನೆ ಅರಾಮ ಥಾವಾದೆ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ತೆಳಾಮಾಜ಼ ತ್ಯುನೊನೆ ಡೊಳಾ ಆಯಾ. ಎ ವಿಶಯ ಕಿಜೆಜ಼ ಕೌ ನೈ” ಕೈನ ಯೆಸು ತ್ಯುನೆನೊ ಹುಶಾರಕಿ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ತೆನೈಸೊ ತೆ ಕುಡ್ಡಾ ತ್ಯಾಂತಾ ಗೈನ ಯೆಸುನಿ ಸುದ್ದಿ ತೆ ಗಾಮ್ನಾ ಸುತ್ತೆ ಫೈಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ಜಾ಼ತಾಮಾ ದಕ್ಹಾ ಜ಼ನಾ ವರಿ ಯಕ್ಲಾನೆ ಯೆಸುಕನ ಲಾಯಾ. ತಿನಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ರ‍್ಹಯಲಕ್ಹು ತೆ ಮುಕೊ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ಯೆಸು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನೆ ತಿನೆ ಛೊಡಿನ ಜಾ಼ ಕೈನ ಆಗನ್ಯಾ ದಿದ್ಯೊ. ತೆ ಬೊಲಾನು ಶುರು ಕರ‍್ಯೊ. ಎ ದೆಕಲ ಮನಕ್ಹೊ ಘಾಬ್ರಾ ತಿಬ್ರಾ ಥೈನ, ಇಸ್ರಾಯೆಲಮಾ ಹೌ ಕಾಮ ದೆಕ್ಯಾಜ ನತ್ತಿ” ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ತೆನೈಸೊ ಪರಿಸಾಯರೊ, ಎ ಕೆಟ್ಟ ಆತ್ಮಾವೊನಿ ಮಾಲಕನಿ ತಾಕತಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಛೊಡಾವಸ” ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ಯೆಸು ಕ್ಹಾರಾ ಗಾಮೊಮಾ ವರಿ ಕ್ಹಾರಾ ಖೆಡಾವೊಮಾ ಪ್ಹರ‍್ಯೊ. ಯೆಸು ತ್ಯುನಾ ಸಭಾಮಂದಿರೊಮಾ ಉಪದೆಶ ಕರಿನ ಪರಲೊಕ ರಾಜ್ಯನಿ ವಿಶಯನಾ ಹುತಿ ಚೊ಼ಕಿ ಸುವಾರ್ತೆ ಕದ್ಯೊ. ಕ್ಹಾರಾ ತರಾನಾ ರೊಗೊನೆ ದುಕ್ಕೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ದುಕ್ಕೊಕ್ಹು ವದ್ಯಾಡಾಲಾ ವರಿ ಸಹಾರೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಯೆಸು ದೆಕಿನ ದುಖಿ ಥಯೊ. ಕುರಬುರ‍್ಯೊ ನೈಸೊ ಬಿಚ಼ಡಿಗಯಲ ಬಕ್ರಾವೊಲಿಂಗತ ತ್ಯುನೆ ಛೆ ಕೈನ ತ್ಯುನೊನೆ ಮರಗ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ, ಬೆಳಿ ಘನ್ನಿ ಛೆ, ತೆನೈಸೊ ಕಾಮ ಕರಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ಬೆಳಿನೊ ಮಾಲಕ ಕ್ಹುದಾಜ ವ್ಹೈ. ತಿನಾ ಹುತಿ ಘನ್ನಾ ಕಾಮವಾಲಾವೊನೆ ಸುಗ್ಗಿ ಕಾಲನಾ ಹುತಿ ವಳೌಕೈನ ತಿನೆ ಪ್ರಾಥನಾ ಕರೊ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ಯೆಸು ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನ, ತ್ಯುನೊನೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಛೊಡಾವಾನೆಬಿ ವರಿ ಕ್ಹಾರಾ ತರಾನಾ ರೊಗೊ ವರಿ ದುಕ್ಕೊನೆ ಅರಾಮ ಕರಾನೆ ಅದಿಕಾರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ಬಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊನಾ ನಾಮೊ ಇಮ್ಮ ಛೆ: ಪೈಲಾರ ಪೆತ್ರಾ ಕವೈಲಿವಾಲೊ ಸಿಮೊನ, ತಿನೊ ಭೈ ಥಯಲ ಅಂದ್ರೆಯ, ಜೆಬೆದಾಯನೊ ದಿಕ್ರೊ ಥಯಲ ಯಾಕೊಬ, ತಿನೊ ನ್ಹಾನೊ ಭೈ ಥಯಲ ಯೊಹಾನ, ");
INSERT INTO sle_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ಫಿಲಿಪ್ಪ ವರಿ ಬಾರ್ತೊಲೊಮಾಯ, ತೊಮ, ಭು ಭಾಡೊ ಲಿವಾಲೊ ಮತ್ತಾಯ, ಅಲ್ಫಾಯನೊ ದಿಕ್ರೊ ಥಯಲ ಯಾಕೊಬ, ತದ್ದಾಯ, ");
INSERT INTO sle_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ಯಹುದಿಯೊನಾ ರಾಜಕಿಯ ಪಕ್ಷನೆ ಮಳಲ ಸಿಮೊನ, ಯೆಸುನೆ ಧರಿನ ದಿದಲ ಇಸ್ಕರಿಯೊತ ಯುದ, ಇವುನೆಜ. ");
INSERT INTO sle_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ಯೆಸು ಎ ಬಾರಾ ಅಪೊಸ್ತಲೊನೆ ದಕ್ಹಾ ಆಗನ್ಯಾ ದಿನ ಪರಲೊಕ ರಾಜ್ಯನಾ ಹುತಿ ತಿಳಸಾವಾನೆ ತ್ಯುನೊನೆ ವಳಾಯೊ. ಯೆಸು ತ್ಯುನೊನೆ ಕದಲ ಸು ವ್ಹೈ ಕದ್ಯಾಮ: ಯೆಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊಕನ ರ‍್ಹವಾದೆ ಸಮಾರ್ಯವಾಲಾ ರ‍್ಹಯಲ ಕಯಾಬಿ ಗಾಮೊನೆ ಜಾ಼ವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ತೆನೈಸೊ ತ್ಯುನೊಕ್ಹು ಚುಕೈಲಿನ ಬಕ್ರಾವೊಲಿಂಗತ ರ‍್ಹಯಲ ಇಸ್ರಾಯೆಲರೊಕನ ಜಾ಼ವೊ, ");
INSERT INTO sle_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ಪರಲೊಕ ರಾಜ್ಯ ಭೆಗಿನ ಅವಸ ಕೈನ ಭೊದನೆ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ರೊಗಿಯೊನೆ ಅರಾಮ ಕರೊ. ಮರಲವಾಲಾವೊನೆ ವಚಾ಼ಡೊ. ಕುಷ್ಠರೊಗಿಯೊನೆ ಅರಾಮ ಕರೊ. ಮನಕ್ಹೊನೆ ಭುತ್ಡಾವೊಕ್ಹು ಛೊಡಾವೊ. ಮಿ ತುಮೊನೆ ಎ ಅದಿಕಾರೊ ಫ್ರಿಮಾ ದ್ಯುಸ. ತಿನಾಹುತಿ ಬಿಜಾವೊನೆಬಿ ಫ್ರಿಮಾ ಮದತ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ತುಮಾರಾ ಕ್ಹಾತೆ ದೊಕ್ಡಾ ರ‍್ಹವಾದೆ ತಾಂಬು, ಕ್ಹೊನು ರುಪ್ಪು ರ‍್ಹವಾದೆ ಲಿಂಜಾವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ಕೊತಳಾ ರ‍್ಹವಾದೆ ಹೆಚ್ಕಿ ವಣ್ಣಾ ರ‍್ಹವಾದೆ ಚಪ್ಲೊ ರ‍್ಹವಾದೆ ಉರುಗೊಲು ರ‍್ಹವಾದೆ ಲಿಂಜಾ಼ವೊ ನಕೊ. ಕಾಮ ಕರಾಲಾನೆ ಚಾ಼ಯೆ ಥಯಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ತುಮೆ ಕಯಾಬಿ ಗಾಮಮಾ ಗಯಲ ಟೈಮಮಾ ತ್ಯಾ ರ‍್ಹವಾನಾ ಚೊ಼ಕಾ ಮನಕ್ಹನೆ ವಳಕೊ, ತುಮೆ ತೆ ಗಾಮ ಛೊಡಿನ ಜಾ಼ಯೆಲಕ್ಕಾ ತಿನಾ ಘರಮಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ತೆ ಘರಮಾ ತುಮೆ ಗಯಲ್ಪರ, ‘ತುಮೊನೆ ಚೊ಼ಕು ಥಾವಾದೆ ಕೈನ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ತೆ ಘರಮಾ ರ‍್ಹವಾಲಾ ಮನಕ್ಹೊ ತುಮೊನೆ ಮಳೈಲಿದ್ಯಾಮ ತುಮಾರಾ ಆಶಿರ್ವಾದನೆ ತ್ಯುನೆ ಯೊದ್ಯ ರ‍್ಹಯಲಕ್ಹು ತೆ ಆಶಿರ್ವಾದ ತ್ಯುನೊನೆ ಮಳಾದೆ. ತ್ಯುನೆ ತುಮೊನೆ ನೈ ಮಳೈಲಿದ್ಯಾಮ, ತುಮಾರಿ ಆಶಿರ್ವಾದ ತುಮೊನೆ ವಾಪಸ ಆವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ಯಕ್ಕ ಘರವಾಲಾ ನೈತೊ ಯಕ್ಕ ಗಾಮವಾಲಾ ತುಮೊನೆ ನೈ ಮಳೈಲಿದ್ಯಾಮ ತ್ಯುನೆ ತುಮಾರಿ ವಾತ ನೈ ಐಕ್ಯಾಮ ತುಮೆ ತೆ ಜ಼ಗಾನೆ ಛೊಡಿನ ಜಾ಼ತಾಮಾ, ತುಮಾರಾ ಪಗೆ ಲಾಗಲ ಧುಳ ಝಾಡ್ಸಿ ಪಾಡೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ಫೈಸಲಾನಾ ದಿನ್ನಮಾ ಎ ಗಾಮನಿ ಗತಿ ಸೊದೊಮ ವರಿ ಗೊಮೊರತಿಬಿ ಘನ್ನಿ ಕೆಟ್ಟ ಥಾವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ಐಕೊ! ನರಿಯೊನಾ ವಚ್ಮಾ ಬಕ್ರಾವೊನೆ ಛೊಡಲ ಲಿಂಗತ ಮಿ ತುಮೊನೆ ವಳಾವಾಡೊಸ. ತಿನಾಹುತಿ ತುಮೆ ಕ್ಹಾಪೊ ಲಿಂಗತ ಹುಶಾರ ಕ್ಹಬುತರ ಲಿಂಗತ ಕಪಟ ನೈಸೊವಾಲಾ ಥೈನ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ಮನಕ್ಹೊನಾ ಹುತಿ ಹುಶಾರ ರ‍್ಹವೊ ತುಮೊನೆ ತ್ಯುನೆ ಧರಿಲಿನ ನ್ಯಾಯಾಲಯನೆ ಬಲೈಲಿನ ಜಾ಼ವಸ. ತ್ಯುನೆ ತ್ಯುನಾ ಸಭಾಮಂದಿರೊಮಾ ಬಾರಕೊಲೊಕ್ಹು ಮಾರಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ತುಮೊನೆ ಅದಿಕಾರಿಯೊನಾ ಕ್ಹಾಮಾ ರಾಜಾ಼ವೊನಾ ಕ್ಹಾಮಾ ಬಲೈಲಿನ ಜಾ಼ವಸ. ಮಾರಾ ಹುತಿ ಮನಕ್ಹೊ ತುಮೊನೆ ಇಮ್ಮ ಕರಸ. ತೆನೈಸೊ ತುಮೆ ತೆ ರಾಜಾ಼ವೊನೆಬಿ ಅದಿಕಾರಿಯೊನೆಬಿ ಯಹುದಿಯೊ ತೆ ಮನಕ್ಹೊನೆ ಮಾರಾ ವಿಶಯಮಾ ಕವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ತುಮೊನೆ ಧರಿಲಿನ ಗಯಲ್ಪರ ತುಮೆ ಸು ಬೊಲು, ಕಿಮ್ಮ ಬೊಲು ಕವಾನು ಚಿಂತಾ ನಕೊ ಕರೊ. ತುಮೆ ಕವಾನು ತೆ ಟೈಮಮಾ ಕವಾಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ಬೊಲಾಲಾ ಕ್ಹರಿಮಾಜ಼ ತುಮೆ ನ್ಹವೈ. ತುಮಾರಾ ಬಾನಿ ಆತ್ಮಾಜ಼ ತುಮಾರಾ ಮುಲಕ ಬೊಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ಭಾಯೊ ಸ್ವಂತ ಭಾಯೊನೆಜ಼ ವಿರುದ ಥೈನ ತ್ಯುನೊನೆ ಮರಣನಿ ಸಜಾನೆ ವಪ್ಪಿಸಾವಸ. ಬಾವೊ ತ್ಯುನಾ ಸ್ವಂತ ಬಚ್ಚಾವೊನೆ ವಿರುದ್ದ ಥೈನ ತ್ಯುನೊನೆ ಮರಾನಿ ಸಜಾನೆ ವಪ್ಪಿಸಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ತುಮೆ ಮಾರಾ ಪಾಚಾ಼ ಆವಾಕ್ಹು ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತುಮೊನೆ ದ್ವೆಶ ಕರಸ. ತೆನೈಸೊ ಲಾಸ್ಟ ಲಕ್ಕಾ ತಡ್ದಿಲಿವಾಲೊ ರಕ್ಷಣೆ ವ್ಹಂದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ಯಕ್ಕ ಗಾಮಮಾ ತುಮೊನೆ ತ್ರಾಸ ಕರ‍್ಯಾಮ ಬಿಜಾ಼ ಗಾಮೆ ಜಾವೊ. ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಫರಿನ ಆವಾತಿ ಪೈಲಾ ತುಮೆ ಇಸ್ರಾಯೆಲನಾ ಕ್ಹಾರಾ ಗಾಮೊನೆ ಜಾ಼ವಾನು ಕ್ಹಾರಾಯೆಲಜ಼ ನೈ ರ‍್ಹತಾ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ಶಿಷ್ಯೊ ಗುರುತಿ ಹೆಚ್ಕಿ ನ್ಹವೈ. ಆಳ ತಿನಾ ಮಾಲಕತಿ ಕ್ಹಾಸ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ಶಿಷ್ಯೊ ತಿನಾ ಗುರು ಲಿಂಗತ ಥಯೊಮ ಬಸ್ಸ. ಆಳ ತಿನಾ ಮಾಲಕ ಲಿಂಗತ ಥಯೊಮ ಬಸ್ಸ. ಘರನಾ ಮ್ಹೊಟಾನೆ ಬೆಲ್ಜೆಬುಲ (ಭುತಡು) ಕೈನ ಬಲಾಯಾಮ, ತೆ ಘರವಾಲಾವೊನಾ ಬಿಜಾ಼ವೊನೆ ವರಿ ದಕ್ಹಾ ಕೆಟ್ಟ ನಾಮೊಕ್ಹು ಬಲಾತಾ ನೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ತಿನಾಹುತಿ ಮನಕ್ಹೊನೆ ಭುಚ಼ಕೊ ನಕೊ. ಝಕಾಯಲ ಕ್ಹಾರು ಭಾರು ಆವಸ. ದಡಿ ರ‍್ಹಯಲ ಹರಿಯಕ್ಕ ವಾತ ಭಾರು ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ಮಿ ಅಂದಾರಾಮಾ ಎ ವಾತೊ ತುಮೊನೆ ಝಾಕಿನ ಕವಾಡೊಸ. ತೆನೈಸೊ ತುಮೆ ಎ ವಾತೊ ಉಜಾಲಾಮಾ ಕೌ ಕೈನ ಮಾರಿ ಆಸ ವ್ಹೈ. ಮಿ ತುಮೊನೆ ಎ ವಿಶಯೊ ತುಮೊನೆ ಹಲ್ಲು ಕವಾಡೊಸ. ತೆನೈಸೊ ತುಮೆ ಎ ವಿಶಯೊ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಜೊ಼ರ ವದ್ರಿನ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ಮನಕ್ಹನೆ ಭುಚ಼ಕೊ ನಕೊ. ತ್ಯುನೆ ತುಮಾರು ಅಂಗ ಯಕ್ಕಜ಼ ಖಲಾಸ ಕರಸ. ತೆ ಮನಕ್ಹೊ ಆತ್ಮಾನೆ ಖಲಾಸ ನೈ ಕರ್ತಾ. ಅಂಗನೆ ವರಿ ಆತ್ಮಾನೆ ನರಕಮಾ ಘಾಲಾಲಾ ಕ್ಹುದಾನೆ ಯಕ್ಕಜ಼ ಭುಚ಼ಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ಬಾಜ಼ರೊಮಾ ಬೆ ಚಿಮ್ಣಿಯೊನೆ ಯಕ್ಕ ಬಿಲ್ಲಾನೆ ಇಕ್ಕಸ. ತೆನೈಸೊ ತುಮಾರೊ ಬಾ ಅಪ್ಪಣೆ ದಿದ್ಯಾ ಬಗರ ತ್ಯುನೊಮಾ ಯಕ್ಕಬಿ ನೈ ಮರ್ತು. ");
INSERT INTO sle_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ತುಮಾರಾ ಮಾತಾಮಾ ಕಕ್ಲಾ ಬಾಲೊ ಛೆ ಕವಾನುಬಿ ಕ್ಹುದಾನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ತಿನಾಹುತಿ ಭುಚ಼ಕೊ ನಕೊ. ತುಮೆ ಘನ್ನಾ ಚಿಮ್ಣಿಯೊತಿಬಿ ಘನ್ನಾ ಕಿಮ್ಮತನಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ಯಕ್ಲೊ ಬಿಜಾ಼ವೊನಾ ಕ್ಹಾಮೊ, ತೆ ಮಾರೊ ವ್ಹೈ ಕೈನ ಕದ್ಯೊಮ, ಮಿಬಿ ಪರಲೊಕಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಬಾನಾ ಕ್ಹಾಮೊ ತೆ ಮಾರೊ ವ್ಹೈ ಕೈನ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ತೆನೈಸೊ ಯಕ್ಲೊ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ, ತೆ ಮಾರೊ ನ್ಹವೈ ಕೈನ ಕದ್ಯೊಮ, ಮಿಬಿ ಪರಲೊಕಮಾ ಮಾರಾ ಬಾನಾ ಕ್ಹಾಮೊ ತೆ ಮಾರೊ ನ್ಹವೈ ಕೈನ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","\"ಎ ದುನಿಯಾಮಾ ಮಿ ಶಾಂತ ಕರಾನೆ ಆಯೊಸ ಕೈನ ವಿಚಾರ ಕರೊ ನಕೊ. ಮಿ ಶಾಂತ ಕರಾನೆ ಆಯೊ ನತ್ತಿ, ತಲ್ವಾರ ಘಾಲಾನೆ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ಕಿಮ್ಮ ಕದ್ಯಾಮ ದಿಕ್ರಾನೆಬಿ ಬಾನೆ, ದಿಕ್ರಿನೆಬಿ ಮಾನೆ, ಫೈನೆಬಿ ವ್ಹೌನೆಬಿ ಬೆದ-ಭಾವ ಹುಟ್ಸಾವಾನೆ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ಇಮ್ಮ ಯಕ್ಕ ಮನಕ್ಹನೆ ತ್ಯುನಾ ಘರವಾಲಾಜ಼ ದುಶ್ಮನೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ಬಾಪನಾ ಉಪ್ಪರ ರ‍್ಹವಾದೆ ಮಾನಾ ಉಪ್ಪರ ರ‍್ಹವಾದೆ ಮಾರಾ ಉಪ್ಪರ ಮ್ಹೆಲಾತಿ ಜಾಸ್ತ ಮಯಾ ಕರಾಲೊ ಮನೆ ಯೊಗ್ಯ ನತ್ತಿ; ದಿಕ್ರಾನಾ ಉಪ್ಪರ ರ‍್ಹವಾದೆ ದಿಕ್ರಿನಾ ಉಪ್ಪರ ರ‍್ಹವಾದೆ ಮಾರಾ ಉಪ್ಪರ ಮ್ಹೆಲಾತಿ ಜಾಸ್ತ ಮಯಾ ಕರಾಲೊ ಮನೆ ಯೊಗ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ಕುನ್ನತಬಿ ಮಾರಾ ಪಾಚೊ಼ ಆತಾಮಾ ತಿನೆ ದಿವಾನಿ ಶಿಲುವಿ (ತ್ರಾಸೊ) ಉಚೈಲಿದ್ಯಾ ಬಗರ, ತೆ ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ಮನೆ ಮಯಾ ಕರಾತಿ ಜಾಸ್ತ ತಿನಾ ಜಲಮನೆ ಮಯಾ ಕರಾಲೊ ತಿನೆ ಜವೈಲಿವಸ. ಮಾರಾಹುತಿ ತಿನು ಜ಼ಲಮ ಜವೈಲಿವಾಲೊ ತಿನೆ ಪಡ್ದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ತುಮೊನೆ ಮಳೈ ಲಿವಾಲೊ ಮನೆಬಿ ಮಳೈ ಲಿವಸ. ಮನೆ ಮಳೈ ಲಿವಾಲೊ ಮನೆ ವಳಾಯಲವಾಲಾನೆ (ಕ್ಹುದಾನೆ) ಬಿ ಮಳೈ ಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ಪ್ರವಾದಿನೆ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಮಳೈಲಿವಾಲೊ ತೆ ಪ್ರವಾದಿನೆ ಆವಾನು ಪ್ರತಿಫಲ ಪಡ್ದಿಲಿವಸ. ನಿತಿವಂತವಾಲಾನೆ ನಿತಿವಂತ ವ್ಹೈ ಕೈನ ಮಳೈಲಿವಾಲೊ ತೆ ನಿತಿವಂತನೆ ಆವಾನು ಪ್ರತಿಫಲ ಪಡ್ದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ವರಿ ಎ ನ್ಹಾನಾವೊಮಾ ಯಕ್ಲಾನೆ ಯೆಸುನೊ ಶಿಷ್ಯಾ ವ್ಹೈ ಕೈನ ಕುನ್ನತಬಿ ಯಕ್ಕ ತಾಂಬಿಯೊ ಥಂಡು ಪಾನಿತುಬಿ ಪಿವಾನೆ ದಿದ್ಯೊಮ ತಿನೆ ಆವಾನು ಪ್ರತಿಫಲ ತಿನೆ ಚು಼ಕ್ತೊಜ಼ ನೈ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ಯೆಸು ತಿನಾ ಬಾರಾ ಜ಼ನಾ ಶಿಷ್ಯಾವೊನೆ ಎ ಸಂಗತಿಯೊ ಕದಲ್ಪರ ಪಾಚಲ್ತೊ ತ್ಯಾಂತೊ ಗೈನ ಕ್ಹುದಾನಿ ವಾತೊ ಕವಾನೆ ವರಿ ಉಪದೆಶ ಕರಾನೆ ಗಲಿಲಾಯ ಗಾಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾಲೊ ಯೊಹಾನ ಜೆಲಮಾ ವ್ಹತ್ತೊ. ಯೆಸು ಕರಾನಾ ಕಾಮೊ ತಿನೆ ಗ್ವತ ಥಯಾ. ತಿನಾಹುತಿ ಯೊಹಾನ ತಿನಾ ದಕ್ಹಾ ಶಿಷ್ಯಾವೊನೆ ಯೆಸುಕನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಯೆಸುನೆ, ಯೊಹಾನ ಕದಲತಿಮ್ಮ ಆವಾಲೊ ತುಜ಼ ವೈಸು ನೈತೊ ಬಿಜಾ಼ ಯಕ್ಲಾನಾ ಹುತಿ ಹಮೆ ಕೈದೆ ಸು?” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ತೆ ವಾತೆ ಯೆಸು, ತುಮೆ ನ್ಹ್ಯಾ ಐಕಲ ವರಿ ದೆಕಲ ಕ್ಹಾರು ಯೊಹಾನನೆ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ಕುಡ್ಡಾವೊನೆ ಡೊಳಾ ಆವಸ; ಲಂಗ್ಡಾ ರ‍್ಹಯಲ ಚಾ಼ಲಸ; ಕುಷ್ಟ ರೊಗಿಯೊ ಅರಾಮ ಥಾವಸ; ಕಿವ್ಡಾ ಐಕಸ; ಮರಲವಾಲಾ ಜಿವ್ತಾ ಥಾವಸ ವರಿ ಗರಿಬ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಕ್ಹುದಾನಿ ವಾತೊ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ಮನೆ (ಯೆಸುನೆ) ವಪ್ಪಿಲಿವಾಲೊ ಧನ್ಯ ವ್ಹೈ” ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ತ್ಯಾಂತಾ ಜಾ಼ತಾಮಾ ಯೆಸು ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಯೊಹಾನನಾ ಹುತಿ ಕವಾನು ಶುರು ಕರ‍್ಯೊ. ಯೆಸು, ತುಮೆ ಸು ದೆಕು ಕೈನ ರಾನ್ಮಾ ಗಯಾತಾ? ವಾರಾಕ್ಹು ಹಲ್ಲಾನಾ ಧಾಂಡಾನೆ ಸು? ನೈ! ");
INSERT INTO sle_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ಕ್ಹರಿಮಾಜ಼ ತುಮೆ ಸು ದೆಕಾನೆ ಗಯಾತಾ? ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ರ‍್ಹಯಲ ಮನಕ್ಹನೆ ಸು? ನೈ! ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿದಲ ಮನಕ್ಹೊ ರಾಜಾ಼ವೊನಾ ಮಹೆಲೊಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ತಿಮ್ಮ ರ‍್ಹಯಾಮ, ಸು ದೆಕಾನೆ ಗಯಾತಾ? ಯಕ್ಕ ಪ್ರವಾದಿನೆ ಸು? ಹೊ! ಯೊಹಾನ ಪ್ರವಾದಿತೊ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ಯೊಹಾನನಾ ಹುತಿ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಅಮ್ಮ ಬರ್ದಲ ಛೆ; ದೆಕ! ಮಿ (ಕ್ಹುದಾ) ಮಾರಾ ದುತನೆ ತಾರಾ ಅಗೊ ಮೊಕ್ಲುಸ. ತೆ ತಾರಿ ವಾಟ ತಯ್ಯಾರ ಕರಸ. ಮಲಾಕಿ 3:1 ");
INSERT INTO sle_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಾವಾಲೊ ಯೊಹಾನ ಪೈಲಾ ಜಿವ್ತಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊತಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ತೆನೈಸೊ ಪರಲೊಕ ರಾಜ್ಯಮಾ ರ‍್ಹವಾಲೊ ನ್ಹಾನೊಬಿ ಯೊಹಾನತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಕ್ಹರಿಮಾಜ಼ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾಲೊ ಯೊಹಾನ ಆಯಲ ಟೈಮತೊ ನ್ಹ್ಯಾ ಲಕ್ಕಾ ಪರಲೊಕ ರಾಜ್ಯ ಘನ್ನಾ ತಾಕತನಾ ಯುದ್ದೊನೆ ಮ್ಹೈ ಥಯುಸ. ಹಿಂಸೆನೆ ಉಪಯೊಗ ಕರಿನ ಮನಕ್ಹೊ ರಾಜ್ಯ ಲಿವಾನೆ ಕೊಶಿಶ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ಕ್ಹಾರಾ ಪ್ರವಾದನೆ ವರಿ ಮೊಶೆನು ಧರಮ ಶಾಸ್ತ್ರ ಯೊಹಾನ ಆಯೆಲಕ್ಕಾ ಪರಲೊಕ ರಾಜ್ಯನಾ ಹುತಿ ಪೈಲಾಜ ಕದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ಧರಮ ಶಾಸ್ತ್ರನೆ ವರಿ ಪ್ರವಾದಿಯೊ ಕದಲ ತುಮೆ ಬರೊಕ್ಹೊ ಕರಾನಾ ರ‍್ಹಯಮ ಎ ಯೊಹಾನಜ ಎಲಿಯ ವ್ಹೈ. ತೆ ಆವಸ ಕೈನ ಧರಮ ಶಾಸ್ತ್ರ ಕದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ಮನಕ್ಹೊ, ಮಿ ಕವಾನು ಐಕೊ. ವರಿ ತಿಳ್ದಿಲಿವೊ! ");
INSERT INTO sle_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ಎ ಕಾಲನಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಮಿ ಸು ಕೌ? ತ್ಯುನೆ ಕೈ ತರಾನಾ ಛೆ? ಎ ಕಾಲನಾ ಮನಕ್ಹೊ ಬಾಜ಼ರೊಮಾ ಬೈಟಲ ಬಚ್ಚಾ ಲಿಂಗತ ಛೆ. ಯಕ್ಕ ಗುಂಪನಾ ಬಚ್ಚಾ ಬಿಜಾ಼ ಗುಂಪನಾ ಬಚ್ಚಾವೊನೆ ಅಮ್ಮ ಕವಸ: ");
INSERT INTO sle_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ಹಮೆ ತುಮಾರಾ ಹುತಿ ವಜಾ಼ಡ್ಯಾ ತುಮೆ ನ್ಹಾಚ್ಯಾ ನೈ. ಹಮೆ ರವಾನಾ ರಿಕಾಡೊ ಕದ್ಯಾ ತುಮೆ ರೊಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ಆಜ಼ನಾ ಮನಕ್ಹೊ ಎ ಬಚ್ಚಾ ಲಿಂಗತ ಛೆ ಕೈನ ಮಿ ಕದ್ಯಲ ಶಾನೆ ವ್ಹೈ? ಕಾಕದ್ಯಾಮ ಯೊಹಾನ ಆಯೊ. ತೆನೈಸೊ ತೆ ಬಿಜಾ಼ ಮನಕ್ಹೊ ಲಿಂಗತ ಖಾದ್ಯೊ ನೈ; ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿದ್ಯೊ ನೈ. ವರಿಬಿ ಮನಕ್ಹೊ, ‘ತಿನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರ‍್ಯುಸ’ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆಯೊ. ತೆ ಬಿಜಾ಼ ಮನಕ್ಹೊ ಲಿಂಗತ ಅನ್ನ ಖಾವಸ; ವರಿ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿವಸ. ತೆನೈಸೊ ಮನಕ್ಹೊ, ‘ತಿನೆ ದೆಕೊ! ತೆ ಮ್ಹೊಟಿ ಕುಡಿವಾಲೊ ವ್ಹೈ, ತೆ ಪಿದೊಡೊ ವ್ಹೈ, ಭು ಭಾಡೊ ಲಿವಾಲಾ ವರಿ ಪಾಪಿಯೊ ತಿನಾ ದೊಸ್ತೊ ವ್ಹೈ’ ಕೈನ ಕವಸ. ತೆನೈಸೊ ತ್ಯುನು ಗ್ಯಾನ ತ್ಯುನೆ ಕರಾನಾ ಕಾಮೊಕ್ಹು ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ಪಾಚಲ್ತೊ ಯೆಸು, ತೆ ಕಯಾ ಗಾಮೊಮಾ ಘನ್ನಾ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍್ಯೊತೊತೊ ತೆ ಗಾಮೊನೆ ಇನ್ಕಾರ‍್ಯೊ. ಕಾಕದ್ಯಾಮ ತೆ ಗಾಮೊಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ತ್ಯುನಿ ಜಿವನಾ ಬದಲಿ ಕರಿಲಿದ್ಯಾ ನೈ ವರಿ ಪಾಪ ಕರಾನು ಛೊಡ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ಯೆಸು ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ; \"ಬೆತ್ಸಾಯಿವಾಲಾ, ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ? ಬೆತ್ಸಾಯಿದ, ತಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ಮಿ ತುಮೊಮಾ ಘನ್ನಾ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍್ಯೊ. ತೆಜ ಅದ್ಭುತ ಕಾಮೊ ತೊರ, ಸಿದೊನಮಾ ಕರಲ ರ‍್ಹವತ್ತೊ, ತ್ಯುನಾ ಮನಕ್ಹೊ ಘನ್ನಾ ಕಾಲ ಪೈಲಾಜ ತ್ಯುನಿ ಜಿವತ ಬದಲಿ ಕರಿಲೆತಾತಾ; ತ್ಯುನಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕೊತ್ಳಾ ಭಾಂದಿಲೆತಾತಾ; ತ್ಯುನಾ ಅಂಗಪರ ರಾಕ ಘಾಲಿಲೆತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ತೆನೈಸೊ ಫೈಸಲಾನಾ ದಿನ್ನಮಾ ತೊರ, ಸಿದೊನತಿಬಿ ತುಮಾರಿ ಸ್ಥಿತಿ ಘನ್ನಿ ಕಷ್ಟಮಾ ಮ್ಹೈ ಥಾವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ಕಪೆನೌರ್ಮಿ, ತು ಪರಲೊಕೆ ಜಾಶಿ ಕೈನ ವಿಚಾರ ಕರಶಿ ಸು? ನೈ! ತು ನರಕೆ ಜಾಶಿ. ಮಿ ತುಮೊಮಾ ಘನ್ನಾ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍್ಯೊ. ಸೊದೊಮಮಾ ತೆ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍ಲ ರ‍್ಹವತ್ತೊ ತೆ ಮನಕ್ಹೊ ಪಾಪ ಕರಾನು ಛೊಡಿಪಡತಾತಾ ವರಿ ಹಜು಼ನ ಲಕ್ಕಾ ತೆ ಗಾಮ ಉಗ್ರಲ ರ‍್ಹತುತು. ");
INSERT INTO sle_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ತೆನೈಸೊ ಫೈಸಲಾನಾ ದಿನ್ನಮಾ ತಾರಿ ಪರಿಸ್ಥಿತಿ ಸೊದೊಮತಿಬಿ ಕೆಟ್ಟ ಸ್ಥಿತಿನೆ ಮ್ಹೈ ಥಾವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ.\" ");
INSERT INTO sle_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ಪಾಚಲ್ತೊ ಯೆಸು, ಪರಲೊಕ ವರಿ ಜಿಮಿನನೊ ಪ್ರಭು ಥಯಲ ಬಾ, ಮಿ ತುನೆ ಸ್ತುತಿ ಕರುಸ. ಕಾಕದ್ಯಾಮ, ತು ಎ ಕ್ಹಾರಾ ವಾತೊ ಗ್ಯಾನಿಯೊನೆಬಿ ಮಾತು ಹುಶಾರ ರ‍್ಹಯಲವಾಲಾವೊನೆಬಿ ಝಾಕಿನ ಮ್ಹೆಲ್ಯೊಸ. ತೆನೈಸೊ ನ್ಹಾನಾ ಬಚ್ಚಾ ಲಿಂಗತ ರ‍್ಹಯಲ ಎ ಮನಕ್ಹೊನೆ ತು ದೆಕಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ಹೊ ಬಾ, ಎ ಕ್ಹರಿಮಾಜ಼ ತಾರಿ ಚಿತ್ತ ವ್ಹೈ ಕೈನ ತು ಇಮ್ಮ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ಮಾರೊ ಬಾ ಮನೆ ಕ್ಹಾರು ದಿದ್ಯೊಸ. ಕುನಜ ದಿಕ್ರಾನೆ ವಳಕ್ಯು ನತ್ತಿ. ಬಾ ಯಕ್ಕಜ ದಿಕ್ರಾನೆ ವಳಕ್ಯೊಸ. ದಿಕ್ರೊ ಯಕ್ಕಜ ಬಾನೆ ವಳಕ್ಯೊಸ. ದಿಕ್ರೊ ಬಾನೆ ಕಿನೆ ದೆಕಾಡು ಕೈನ ಆಸ ಕರಸ ತ್ಯುನೆ ಬಾನೆ ತಿಳ್ದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ಕಷ್ಟಮಾ ರ‍್ಹಯಲವಾಲಾ, ವಜ್ಜು಼ ಉಚೈಲಿದಲವಾಲಾ, ತುಮೆ ಕ್ಹಾರಾ ಮಕನ ಆವೊ. ಮಿ ತುಮೊನೆ ಸಮಾಧಾನ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ಮಾರಿ ನೊಗನೆ ಖಾಂದೊ ದಿನ ಮಾರಾಕ್ಹು ಶಿಕ್ಕೊ. ಮಿ ಸಾತ್ವಿಕ ದಿನ ರ‍್ಹಯಲಕ್ಹು ತುಮೆ ತುಮಾರಿ ಆತ್ಮಾವೊನೆ ಸಮಾಧಾನ ದೆಕೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ಹೊ, ತುಮೊನೆ ಮಾರಿ ನೊಗ ನರಮ ಥೈಸ; ಮಾರು ವಜ್ಜು಼ ತುಮೊನೆ ಹಲ್ಕು ಥಯುಸ.” ");
INSERT INTO sle_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ತೆ ದಿನ್ನ ಸಬ್ಬತ ದಿನ್ನ ಯೆಸು ಫಸಲ ರ‍್ಹಯಲ ಖೆತರೊನಾ ವಾಟಕಂತೊ ಚಾ಼ಲ್ಯೊತೊ. ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ ವರಿ ಭುಕ್ಕಾ ಥಯಾತಾ. ತಿನಾಹುತಿ ಶಿಷ್ಯಾ ಭುಟ್ಟಾ ಕಿತ್ತಿಲಿನ ಖಾವಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ಎ ದೆಕಲ ಫರಿಸಾಯರೊ ಯೆಸುನೆ, ದೆಕ! ಸಬ್ಬತ ದಿನ್ನೆ ನೈ ಕರಾನಾ ಕಾಮೊನಾಹುತಿ ಯಹುದಿಯೊನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಕದಲ ನಿಯಮೊನಾ ವಿರುದ್ದ ತಾರಾ ಶಿಷ್ಯಾ ಕರಾಡಾಸ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ತೆ ವಾತೆ ಯೆಸು, ತೆಬಿ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಭುಕ್ಕಾ ಥಯಲ ಟೈಮಮಾ ದಾವಿದ ಸು ಕರ‍್ಯೊ ಕವಾನು ತುಮೆ ಒದ್ಯಾ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ದಾವಿದ ಕ್ಹುದಾನಾ ಘರಮಾ ಗಯೊ. ಕ್ಹುದಾನೆ ಚ಼ಡಾಯಲ ರೊಕ್ಲೊ ದಾವಿದ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಮನಕ್ಹೊಬಿ ಖಾದ್ಯಾ. ತ್ಯುನೆ ತೆ ರೊಕ್ಲೊ ಖಾವಾನು ಧರಮ ಶಾಸ್ತ್ರನೆ ವಿರೊದ ಥಯುತು. ತೆ ಖಾವಾನೆ ಕ್ಹಾಲಿ ಯಾಜಕೊನೆ ಅವಕಾಶ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ಹರಿಯಕ್ಕ ಸಬ್ಬತ ದಿನ್ನಮಾ ಯಾಜಕೊ ದೆವಾಲಯಮಾ ಸಬ್ಬತ ದಿನ್ನನಾ ನಿಯಮೊನೆ ದಾಟಿನ ಗಯಾತುಬಿ ತ್ಯುನೆ ತಪ್ಪ ಕರಲವಾಲಾ ನೈ ಥಾತಾ ಕೈನ ತುಮೆ ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಒದ್ಯಾ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ತೆನೈಸೊ ದೆವಾಲಯತಿಬಿ ಮ್ಹೊಟೊ ನ್ಹ್ಯಾ ಛೆ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ಪಶು ಬಲಿಯೊನೆ ಮನೆ ನಕೊ, ಮರ್ಗಾಜ ಮನೆ ಚಾ಼ಯೆ” ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ. ತಿನು ಮತ್ಲಬ ತುಮೆ ತಿಳ್ದಿಲಿದ್ಯಾ ನತ್ತಿ. ತುಮೆ ತಿನು ಮತ್ಲಬ ತಿಳ್ದಿಲಿದ್ಯಾಮ ತಪ್ಪ ನೈ ಕರಲ ಇವ್ನೊನೆ ತಪ್ಪ ಕರಲವಾಲಾ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ನೈ ಕರ‍್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸಬ್ಬತ ದಿನ್ನನೆ ಮಾಲಕ ಥಯೊಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ಯೆಸು ತೆ ಜ಼ಗಾ ಛೊಡಿನ ತ್ಯುನಿ ಸಭಾಮಂದಿರಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ತೆ ಸಭಾಮಂದಿರಮಾ ಯಕ್ಕ ಮನಕ್ಹನೊ ಹತ್ತ ಕುಕ್ಹೈ ಗಯೊತೊ. ಯಹುದಿಯೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಯೆಸುನಾ ಉಪ್ಪರ ತಪ್ಪ ಘಾಲಾನೆ ಕಾರಣ ಹುಡ್ಕಾಡಾತಾ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆಸುನೆ ಸಬ್ಬತ ದಿನ್ನಮಾ ರೊಗ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಅರಾಮ ಕರಾನು ಚೊ಼ಕು ವ್ಹೈ ಸು?” ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ಯೆಸು, ತುಮೊಮಾ ಕಿಕನಬಿ ಯಕ್ಕ ಬಕ್ರು ರ‍್ಹಯಮ ತೆ ಬಕ್ರು ಸಬ್ಬತ ದಿನ್ನಮಾ ಉಂಡಿ ಖಾಡಿಮಾ ಪಡ್ಯಾಮ, ತುಮೆ ತೆ ಬಕ್ರಾನೆ ಉಂಡಿ ಖಾಡಿಮಾತಾ ಭಾರಾ ಕಾಡೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ಮನಕ್ಹ ಬಕ್ರಾತಿ ಕೆಕ್ಲೊಕಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ತಿನಾಹುತಿ ಸಬ್ಬತ ದಿನ್ನಮಾ ಚೊ಼ಕಾ ಕಾಮೊ ಕರಾನು ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರನಾ ನಿಯಮನೆ ಚೊ಼ಕು ವ್ಹೈ” ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಹತ್ತ ಕುಕ್ಹೈ ಗಯಲ ಮನಕ್ಹನೆ, ತಾರೊ ಹತ್ತ ದೆಕಾಡ” ಕದ್ಯೊ. ತೆ ತಿನೊ ಹತ್ತ ಯೆಸುಕನ ಅಗೊ ಕರ‍್ಯೊ. ತೆಳಾಮಾಜ಼, ತಿನೊ ಹತ್ತ ಬಿಜೆಕ್ಕ ಹತ್ತ ಲಿಂಗತ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ತೆನೈಸೊ ಪರಿಸಾಯರೊ‍ ತ್ಯಾಂತಾ ಗೈನ ಯೆಸುನೆ ಖಲಾಸ ಕರಾನೆ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ಪರಿಸಾಯರೊ ಸು ಕರಾಡಾಸ ಕೈನೆ ಯೆಸುನೆ ಗ್ವತ ಥಯುತು. ತಿನಾಹುತಿ ಯೆಸು ತೆ ಜ಼ಗಾ ಛೊಡಿನ ಗಯೊ. ಘನ್ನಾ ಮನಕ್ಹೊ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ಯೆಸು ಘನ್ನಾ ಮನಕ್ಹೊನಾ ರೊಗೊ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ತೆನೈಸೊ ತೆ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಕೌ ನೈ ಕೈನ ತೆ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಕದಲ ಲಿಂಗತ ಥಾವಾನಾಹುತಿ ಯೆಸು ಎ ಕ್ಹಾರು ಕರ‍್ಯೊ. ಯೆಶಾಯ ಸು ಕದ್ಯೊತೊ ಕದ್ಯಾಮ; ");
INSERT INTO sle_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ದೆಕೊ, ಎ ಮಾರೊ ಸೆವಕ ವ್ಹೈ; ಇನೆ ಮಿ ಇನಿಲಿದ್ಯೊಸ; ಎ ಮನೆ ಪಸಂದ ಛೆ; ಮಾರೊ ಮಯಾನೊ ವ್ಹೈ. ಇನಾಮಾ ಮಾರಿ ಆತ್ಮಾ ಭರುಸ; ಎ ಬಿಜಾ ಮನಕ್ಹೊನೆಬಿ ನ್ಯಾಯನೊ ಫೈಸಲೊ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ಎ ಲಡೈ ಕಾಡತೊ ನೈ, ವದರತೊ ನೈ; ಒಣಿಯೊಮಾ ಇನಿ ಅವಾಜ಼ ಕಿನೆಜ ಐಕು ಆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ಛೆಟಲ ಧಾಂಡಾನೆ ಭಾಗ್ಯಾವಾಚಿ ಇಜೈ ಜಾ಼ತು ರ‍್ಹಯಲ ದಿವ್ವಾನೆ ಲಗಾಡ್ಯಾವಾಚಿ ನ್ಯಾಯನೆ ಜಿತ್ತಾನಾಹುತಿ ವಳೈನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಸ.” ಯೆಶಾಯ 42:1-4. ");
INSERT INTO sle_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ತೆಳಾಮ ದಕ್ಹಾ ಮನಕ್ಹೊ ಯಕ್ಲಾನೆ ಯೆಸುಕನ ಲಾಯಾ. ತಿನಾಮಾ ಭುತ್ಡಾ ರ‍್ಹಯಲಕ್ಹು ತೆ ಕುಡ್ಡೊ ಥೈನ ವ್ಹತ್ತೊ ವರಿ ಮುಕೊ ಥೈನ ವ್ಹತ್ತೊ. ಯೆಸು ತೆ ಮನಕ್ಹನೆ ಅರಾಮ ಕರಲಕ್ಹು ತೆ ಮನಕ್ಹ ಬೊಲಾನೆ ಬಿ ವರಿ ದೆಕಾನೆ ಬಿ ಸಾದ್ಯ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ಮನಕ್ಹೊ ಕ್ಹಾರ ಘಾಬ್ರಾ ಥಯಾ. ಕ್ಹುದಾ ಮೊಕ್ಲಿನ ದ್ಯುಸ ಕದಲ ದಾವಿದನೊ ದಿಕ್ರೊ ಎಜ಼ (ಯೆಸು) ವಸ” ಕೈನ ಬೊಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ಮನಕ್ಹೊ ಎ ಕ್ಹಾರು ಬೊಲ್ಲಿವಾನು ಐಕಲ ಪರಿಸಾಯರೊ, ಯೆಸು ಬೆಲ್ಜೆಬೊಲನಾ ತಾಕತಕ್ಹು ಮನಕ್ಹೊನೆ ಭುತ್ಡಾವೊಕ್ಹು ಛೊಡಾವಸ. ಬೆಲ್ಜೆಬೊಲ ಭುತ್ಡಾವೊನೊ ಅಧಿಪತಿ ವ್ಹೈ” ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ಪರಿಸಾಯರೊ ವಿಚಾರ ಕರಾನಾ ಸಂಗತಿಯೊ ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯಾತಾ. ತಿನಾಹುತಿ ಯೆಸು ತ್ಯುನೊನೆ, ತಿನಾಕ್ಹು ತಿನೆಜ಼ ವಿರೊದ ಥೈನ ತೆಜ಼ ಹೊರಾಡಾನು ರಾಜ್ಯ ನಾಶ ಥಾವಸ. ತಿನಾ ಲಿಂಗತ ತುಟಿಗಯಲ ಹರಿಯಕ್ಕ ರಾಜ್ಯ ಸ್ಥಿರ ನೈ ರ‍್ಹತು. ಭೆದಭಾವ ಹೊಂದಲ ಹರಿಯಕ್ಕ ಕುಟುಂಬ ಅಭಿವೃದ್ಧಿ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ಇಮ ರ‍್ಹತಾಮಾ ಸೈತಾನ ತಿನಾ ಸ್ವಂತ ಭುತ್ಡಾವೊನೆ ಭಾರೊ ಘಾಲ್ಯೊಮ ತಿನಾಮಾಜ ತೆ ಬೆದ ಹುಟ್ಟಾಯೆಲಿಂಗತ ಥಾವಸ. ತೆಳಾಮಾ ತೆ ವರಿ ತಿನು ರಾಜ್ಯ ಯಕ್ಕ ಥೈನ ಹುಬ್ರಾವಾನೆ ಕಿಮ್ಮ ಸಾದ್ಯ ಛೆ? ");
INSERT INTO sle_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ಮಿ ಬೆಲ್ಜೆಬೊಲನಾ ತಾಕತಕ್ಹು ಭುತ್ಡಾವೊನೆ ಛೊಡೌಸ ಕೈನ ತುಮೆ ಕವೊಶಿ. ತೆ ಕ್ಹರಿ ರ‍್ಹಯಮ, ತುಮಾರಾ ಮನಕ್ಹೊ ಕೈ ತಾಕತಕ್ಹು ಭುತ್ಡಾವೊನೆ ಛೊಡಾವಸ? ತಿನಾಹುತಿ ತುಮಾರಾ ಸ್ವಂತ ಮನಕ್ಹೊಜ ತುಮೊನೆ ನ್ಯಾಯತಿರ್ಪ ಕರಾಲಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ತೆನೈಸೊ ಮಿ ಕ್ಹುದಾನಿ ತಾಕತಕ್ಹು ಭುತ್ಡಾವೊನೆ ಛೊಡೌಸ. ಕ್ಹುದಾನಿ ರಾಜ್ಯ ತುಮಾರಾ ನಜಿಕ ಐಸ ಕವಾನು ಎ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ಯಕ್ಕ ಮನಕ್ಹ ತಾಕತ ವರನಾ ಘರಮಾ ಹೊಕ್ಕಿನ ತಿನು ಸಂತ ರ‍್ಹಯಲ ಕಾಳ್ಯು ಕೈನ ರ‍್ಹಯಮ, ಪೈಲಾ ತೆ ತಾಕತವರವಾಲಾನೆ ಭಾಂದಿನ ಘಾಲು. ತೆಳಾಮಾ ತೆ ತಾಕತವರವಾಲಾನಾ ಘರ್ನಿ ಆಸ್ತಿ ತೆ ಕಾಳ್ಳಿವಾನೆ ಸಾದ್ಯ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ಮಾರಾ ಕ್ಹಾತೆ ನೈ ರ‍್ಹಯಲವಾಲೊ ಮನೆ ವಿರೊದಿ ಥಯೊಸ. ಮಾರಾ ಕ್ಹಾತೆ ಮಳಲವಾಲೊ ಜಾಸ್ತಕರಾಲೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ತಿನಾಹುತಿ ಮಿ ತುಮೊನೆ ಕವಾನು ಸು ವೈ ಕದ್ಯಾಮ , ಮನಕ್ಹೊ ಕರಾನಾ ಹರಿಯಕ್ಕ ಪಾಪೊನೆ ಕವಾನಾ ಹರಿಯಕ್ಕ ದೊಷನಾ ವಾತೊನೆ ಮಾಫಿ ಛೆ. ತೆನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾನಿ ದೊಷಣೆನೆ ಮಾಫಿ ನತ್ತಿಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ವಿರೊದ ಥೈನ ಬೊಲ್ಯಾಮ ತಿನೆ ಬಿ ಮಾಫಿ ಛೆ. ತೆನೈಸೊ ಪವಿತ್ರಾತ್ಮಾನಾ ವಿರೊದ ಥೈನ ಬೊಲ್ಯಾಮ ತಿನೆ ಮಾಫಿ ಇಹಲೊಕಮಾ ರ‍್ಹವಾದೆ ಪರಲೊಕಮಾ ರ‍್ಹವಾದೆ ನತ್ತಿಜ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ತುಮೊನೆ ಚೊ಼ಕು ಫಲ ಚಾ಼ಯೆ ಥಯಲ ರ‍್ಹಯಮ ತುಮೆ ಚೊ಼ಕು ಝಾಡ ಹೊಂದಿಲಿದಲ ರ‍್ಹೌ. ತುಮಾರು ಝಾಡ ಚೊ಼ಕು ನೈ ರ‍್ಹಯಲ ರ‍್ಹಯಮ ತೆ ಕೆಟ್ಟ ಫಲಜ ಛೊಡಸ. ಝಾಡನೆ ತಿಮಾ ಛೊಡಾನಾ ಫಲಕ್ಹುಜ಼ ತಿಳದಿಲಿವಾನೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ತುಮೆ ಕ್ಹಾಪೊ ವ್ಹೈ! ತುಮೆ ದುಷ್ಠೊ ವ್ಹೈ.! ಕಿಮ ತುಮೆ ಚೊ಼ಕು ಕವೊಶಿ? ತುಮಾರಾ ಮನಸ್ಮಾ ಭರಲಜ ತುಮಾರು ಮ್ಹೊಡು ಬೊಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ಚೊ಼ಕೊ ರ‍್ಹಯಲವಾಲೊ ತಿನಾ ಮನಸ್ಮಾ ಚೊ಼ಕಾನುಜ ಮ್ಹೆಲಿಲಿದಲ ರ‍್ಹವಸ. ತಿನಾ ಹುತಿ ತೆ ತಿನಾ ಮನಸ್ಮಾ ಆವಾನು ಚೊ಼ಕುಜ ಬೊಲಸ. ತೆನೈಸೊ ದುಷ್ಟ ತಿನಾ ಮನಸ್ಮಾ ಕೆಟ್ಟ ರ‍್ಹಯಲಜ ಭರಿಲಿದಲ ರ‍್ಹವಸ. ತಿನಾಹುತಿ ತೆ ತಿನಾ ಮನಸ್ಮಾ ಆವಾನು ಕೆಟ್ಟಜ಼ ಬೊಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ಮನಕ್ಹೊ ಅರುವಾಚಿ ಬೊಲಲ ಹರಿಯಕ್ಕ ವಾತನೆ ನ್ಯಾಯನಾ ದಿನ್ಮಾ ಜವಾಬ ದ್ಯು ಲಾಗಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ತುಮಾರಾ ವಾತೊಕ್ಹುಜ ತುಮೊನೆ ನಿತಿವಂತರೊ ಕೈನ ರ‍್ಹವಾದೆ ಅಪರಾದಿಯೊ ಕೈನ ರ‍್ಹವಾದೆ ಫೈಸಲೊ ದಿವಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ತೆಳಾಮಾ ದಕ್ಹಾ ಫರಿಸಾಯರೊ ವರಿ ಧರಮೊಪದೆಶಕರೊ ಯೆಸುನೆ, ಬೊದಕ, ತು ಕದಲ ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ದೆಕಾಡಾನಾ ಹುತಿ ಯಕ್ಕ ಅದ್ಭುತ ಕಾಮ ಕರ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ಯೆಸು, ದುಷ್ಟರೊ ವರಿ ಪಾಪಿಯೊ ಅದ್ಭುತ ಕಾಮ ದೆಕಾನೆ ಮನಸ ಕರಸ. ತೆನೈಸೊ ತ್ಯುನೊನೆ ಯಕ್ಕ ಬಿ ಅದ್ಭುತ ಕಾಮ ದೆಕಾಡತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ಪ್ರವಾದಿ ಥಯಲ ಯೊನ ತನ್ನ ದಿನ್ನ ಲಕ್ಕಾ ದಿನ್ನ ರಾತ ಯಕ್ಕ ಮ್ಹೊಟ್ಟಿ ಮಚ್ಲಿನಾ ಪೆಟಮಾ ಕಿಮ್ಮ ವ್ಹತ್ತೊ ತಿನಾ ದಾಕ್ಹಲಜ ಮನಕ್ಹನೊ ದಿಕ್ರೊಬಿ ಮಜಾರಮಾ ತನ್ನ ದಿನ್ನ-ದಿನ್ನ ರಾತ ಲಕ್ಕಾ ರ‍್ಹವಸ. ಎನೈಸೊ ಬಿಜು ಕಯುಜ ಅದ್ಭುತ ಕಾಮ ತ್ಯುನೊನೆ ದೆಕಾಡತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ಫೈಸಲಾನಾ ದಿನ್ನಮಾ ನಿನೆವ ಗಾಮನಾ ಮನಕ್ಹೊ ಆಜ಼ಬಿ ಜಿವತಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಕ್ಹಾತೆ ಹುಬ್ರೈನ ತುಮೊನೆ ಅಪರಾದಿಯೊ ಕೈನ ಫೈಸಲೊ ಕರಸ. ತುಮೆ ಅಪರಾದಿಯೊ ವ್ಹೈ ಕೈನ ಕವಸ. ಕಾಕದ್ಯಾಮ ಯೊನ ಕತಾಮಾ ತ್ಯುನೆ ತ್ಯುನಿ ಜಿವನಾ ಬದಲಿ ಕರಿಲಿದ್ಯಾ. ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ ಮಿ ಯೊನತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","\"ಫೈಸಲಾನಾ ದಿನ್ನೆ ದಕ್ಷಿಣ ದೆಶನಿ ರಾಣಿ ಆಜ಼ ಜಿವ್ತಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಕ್ಹಾತೆ ಉಟಿನ ಹುಬ್ರೈನ ತುಮೊನೆ ತಪ್ಪ ಕರಾಲಾ (ಅಪರಾದಿಯೊ) ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿವಸ. ಕಾಕದ್ಯಾಮ, ತೆ ರಾಣಿ ಸೊಲೊಮೊನನಿ ಗ್ಯಾನ ಐಕಾನೆ ಘನ್ನಿ ದುರತಿ ಐ. ಮಿ ತುಬಿ ಸೊಲೊಮೊನತಿ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ಕೆಟ್ಟ ಆತ್ಮಾ ಮನಕ್ಹಮಾತಿ ಭಾರಿ ಆಯಲ್ಪರ ಅರಾಮ ಕರಾನಾ ಹುತಿ ಜ಼ಗಾ ಹುಡಕತಿ ಪಾನಿ ನೈರ‍್ಹಯಲ ಜ಼ಗಾವೊಕನ ಫರಸ. ತೆನೈಸೊ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನೆ ಚಾಯೆ ಥಯಲ ಅರಾಮ ಕರಾನಿ ಜ಼ಗಾ ನೈ ಮಳ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ತೆಳಾಮಾ ತೆ, ಮಿ ಛೊಡಿನ ಆಯಲ ಘರೆ ಫರಿನ ಜೌ಼ಸ ಕೈನ ಕೈಲಿವಸ. ಪಾಚಲ್ತಿ ತೆ ತಿಕನ ವರಿ ಆಯಲ್ಪರ ತೆ ಘರ ಕ್ಹಾಲಿ ರ‍್ಹಯಲ ರ‍್ಹವಸ. ವ್ಹಚಲ ನೈಸೊ ಚೊಕಿ ತರಾ ತಯ್ಯಾರ ಕರಲ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ತೆಳಾಮಾ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಗೈನ ತಿನಾತಿಬಿ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಕ್ಹಾತ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಬಲೈ ಲಾವಸ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ತೆ ಮನಕ್ಹನಾ ಅಂಗಮಾ ಗೈನ ತ್ಯಾ ರ‍್ಹವಾನು ಶುರು ಕರಸ. ತೆಳಾಮಾ ತೆ ಮನಕ್ಹನೆ ಪೈಲಾತಿಬಿ ಜಾಸ್ತ ತ್ರಾಸ ಥಾವಸ. ಎ ದಿನ್ನೊಮಾ ರ‍್ಹಯಲ ಕೆಟ್ಟ ಮನಕ್ಹೊನೆ ಇನಾಲಿಂಗತಜ಼ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ಯೆಸು ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾ, ತಿನಿ ಯಾ ವರಿ ತಿನಾ ಭಾಯೊ ಐನ ಭಾರಾ ಹುಬ್ರಯಾ. ತ್ಯುನೆ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲು ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ಯಕ್ಲೊ ಯೆಸುನೆ, ತಾರಿ ಯಾ ವರಿ ಭಾಯೊ ತಾರಾ ಹುತಿ ಭಾರಾ ಕೈದಾಡಾಸ, ತ್ಯುನೆ ತಾರಾ ಕ್ಹಾತೆ ಬೊಲು ಕೈನ ಕವಾಡಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ಯೆಸು, \"ಮಾರಿ ಯಾ ಕುನ ವ್ಹೈ? ಮಾರಾ ಭಾಯೊ ಕುನ ವ್ಹೈ?\" ಕೈನ ಪುಚ್ಚಿನ, ");
INSERT INTO sle_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ತಿನಾ ಶಿಷ್ಯಾವೊಕನ ಹತ್ತ ದೆಕಾಡಿನ, \"ದೆಕೊ! ಇವ್ನೆಜ ಮಾರಿ ಯಾ ವರಿ ಭಾಯೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ಪರಲೊಕಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಬಾನಾ ಚಿತ್ತನಾ ಪ್ರಕಾರ ಚಾಲಾಲೊಜ ಮನೆ ಭೈ ವ್ಹೈ, ಭೆನ ವ್ಹೈ ವರಿ ಯಾ ವ್ಹೈ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ತೆಜ ದಿನ್ನೆ ಯೆಸು ಘರಮಾತೊ ಗೈನ ಸಮುಂದರನಾ ದಂಡಿಕನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಸುತ್ತೆ ಆಯಲಕ್ಹು, ತೆಳಾಮಾ ಯೆಸು ಹಡಗಮಾ ಗೈನ ಬೆಟ್ಯೊ. ಮನಕ್ಹೊ ಕ್ಹಾರಾ ದಂಡಿಕನ ಹುಬ್ರಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ತೆಳಾಮಾ ತೆ ಸಾಮ್ಯನಾ ಮುಲಕ ಘನ್ನಾ ವಿಶಯೊ ತ್ಯುನೊನೆ ಬೊಧನೆ ಕರ‍್ಯೊ. ಯೆಸು ತ್ಯುನೊನೆ ಆಂ ಸಾಮ್ಯ ಕದ್ಯೊ: ಯಕ್ಲೊ ರೈತ ಬಿಯ್ಯಾ ಬಿತ್ತಾನಾ ಹುತಿ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ತೆ ಬಿಯ್ಯಾ ಬಿತ್ತತಾಮಾ ದಕ್ಹಾ ಬಿಯ್ಯಾ ರೊಡನಾ ಬಾಜುಮಾ ಪಡ್ಯಾ. ಪಕ್ಷಿಯೊ ಐನ ಕ್ಹಾರಾ ಬಿಯ್ಯಾ ಖೈಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ದಕ್ಹಾ ಬಿಯ್ಯಾ ದಗಡಾ ರ‍್ಹಯಲ ವಾಟಪರ ಪಡ್ಯಾ. ತೆ ಜ಼ಗಾ ಜಿಮಿನ್ಪರ ಮಾತಿ ಕಮ್ಮ ರ‍್ಹಯಲ ಹುತಿ ಬಿಯ್ಯಾ ಭೆಗಿನ ಬೆಳದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ತೆನೈಸೊ ತಡಕೊ ಪಡಿನ ತೆ ಝಾಡೊ ಕುಕ್ಹೈ ಗಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೊಮಾ ಬೆರ ಘಟ್ಟ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ಬಿಜಾ಼ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಕಾಟಾವೊನಾ ಝಾಡೊಮಾ ಪಡ್ಯಾ. ಕಾಟಾವೊನಾ ಝಾಡೊ ಬೆಳದಿನ ಚೊ಼ಕಾ ಝಾಡೊನೆ ಝಾಕಿಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ಬಿಜಾ಼ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಚೊ಼ಕಿ ಜಿಮಿನ್ಪರ ಪಡ್ಯಾ. ತೆ ಬೆಳ್ದಿನ ಕಾಳೊ ದಿದ್ಯಾ. ದಕ್ಹಾ ಝಾಡೊ ಕ್ಹೊ ಯಕ್ಲಾ, ದಕ್ಹಾ ಝಾಡೊ ಕ್ಹಾಟ ಯಕ್ಲಾ, ವರಿ ದಕ್ಹಾ ಝಾಡೊ ಮುವತ್ತ ಯಕ್ಲಾ ಕಾಳೊ ಛೊಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ಮಾರಾ ಆಗನ್ಯಾನೆ ಕಾನದಿನ ಐಕಾಲಾ ಮನಕ್ಹೊ, ಐಕೊ!” ");
INSERT INTO sle_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ತೆಳಾಮಾ ಶಿಷ್ಯಾ ಯೆಸುಕನ ಐನ, \"ತು ಸಾಮ್ಯ ಮುಕಾಂತರ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕವಾನು ಶಾನೆ?\" ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ತೆಳಾಮಾ ಯೆಸು, \"ಪರಲೊಕ ರಾಜ್ಯ ದಡಿ ರ‍್ಹಯಲ ಕ್ಹರಿನೆ ಕ್ಹಾಲಿ ತುಮೆಜ ತಿಳ್ದಿಲೆಸಕೊಶಿ. ಎ ದಡಿ ರ‍್ಹಯಲ ಕ್ಹರಿ ಬಿಜಾ ಮನಕ್ಹೊನೆ ಕಳ್ತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ಕಮ್ಮ ಗ್ಯಾನ ರ‍್ಹಯಲವಾಲೊ ಹಜು಼ನ ಹೆಚ್ಕಿ ಗ್ಯಾನ ಪಡ್ದಿಲಿನ ತೆ ಘನ್ನೊ ಗ್ಯಾನಿ ಥಾವಸ. ತೆನೈಸೊ ಗ್ಯಾನ ನೈ ರ‍್ಹಯಲವಾಲೊ ತಿಕನ ರ‍್ಹವಾನಿ ಗ್ಯಾನಬಿ ಜ಼ವೈ ಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ಎ ಕಾರಣಕ್ಹುಜ಼ ಮಿ ಎ ಸಾಮ್ಯ ಮುಕಾಂತರ ತ್ಯುನೊನೆ ಕೌಸ. ಎ ಮನಕ್ಹೊ ದೆಕ್ಯಾತಬಿ ದಿಕ್ಹತು ನೈ, ಐಕಿನಬಿ ತಿಳ್ದಿ ಲೆತಾನೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ಹೆವಾವೊನಾ ಹುತಿ ಯೆಶಾಯ ಸು ಕದ್ಯೊಸ ಕದ್ಯಾಮ, ತುಮೆ ಕಾನೊ ರ‍್ಹೈನ ಐಕ್ಯಾತಬಿ ತಿಳ್ದಿಲೆತಾ ನೈ. ತುಮೆ ಡೊಳಾ ರ‍್ಹೈನ ದೆಕ್ಯಾತಬಿ ದಿಕ್ಹತುಜ಼಼ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ಎ ಮನಕ್ಹೊನು ಮನಸ ಘಟ್ಟ ಥಯು; ಇವ್ನಾ ಕಾನೊ ಕಿವ್ಡಾ ಥಯಾ; ಇವ್ನೆ ಡೊಳಾ ಝಾಕಿಲಿದ್ಯಾಸ. ತ್ಯುನೆ ಡೊಳಾಕ್ಹು ದೆಕಿನ ಕಾನೊಕ್ಹು ಐಕಿನ ಮನಸಕ್ಹು ತಿಳ್ದಿಲಿನ ಮಕನ ಫರಿನ ಮಾರಾಕ್ಹು ಅರಾಮ ಥೌ ನೈ ಕೈನ ಕರಿಲಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ತುಮೆ ಧನೈ ವ್ಹೈ. ತುಮೊನೆ ದಿಕ್ಹಾನಾ ಸಂಗತಿಯೊ ತುಮೊನೆ ಕವಾನಾ ವಿಶಯೊ ತಿಳ್ದಿಲೆಸಕೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ, ತುಮೆ ಹಮ್ನಾ ದೆಕಾನಾ ಸಂಗತಿಯೊ ದೆಕಾನೆ ವರಿ ಹಮ್ನಾ ತುಮೆ ಐಕಾನಾ ಸಂಗತಿಯೊನೆ ಐಕಾನೆ ಘನ್ನಾ ಪ್ರವಾದಿಯೊ ವರಿ ಚೊ಼ಕಾ ಮನಕ್ಹೊ ಆಸ ಕರ‍್ಯಾ. ತೆನೈಸೊ ತ್ಯುನೊನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಬಿತ್ತಾಲಾ ರೈತನಾ ಹುತಿ ಕದಲ ಸಾಮ್ಯನು ಅರ್ಥ ಐಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ರಸ್ತಾನಾ ಬಾಜು಼ಮಾ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ ಸು ವ್ಹೈ? ಪರಲೊಕನಾ ಹುತಿ ಕದಲ ಐಕಿನ ತಿನೆ ತಿಳ್ದಿಲಿದ್ಯಾವಾಚಿ ರ‍್ಹಯಲ ಮನಕ್ಹ ಬಿಯ್ಯಾ ಪಡಲ ರಸ್ತಾನಾ ಬಾಜುನಿ ವಾಟ ವ್ಹೈ. ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲೊ (ಸೈತಾನ) ಐನ ತೆ ಮನಕ್ಹನಾ ಮನಸಮಾ ಬಿತ್ತಲ ಬಿಯ್ಯಾ ಕಾಳಿನ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ದಗ್ಡಾವೊನಿ ಮಾತಿಪರ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ ಸು ವ್ಹೈ? ಕ್ಹುದಾನಾ ವಾತೊ ಐಕಲ ಬರೊಬರ ತೆ ಖುಶಿಕ್ಹು ಸ್ವಿಕಾರ ಕರಾಲೊ ಮನಕ್ಹಜ ಬಿಯ್ಯಾ ಪಡಲ ದಗ್ಡಾವೊನಿ ಜಿಮಿನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ತೆನೈಸೊ ತೆ ಮನಕ್ಹ ಕ್ಹುದಾನಾ ವಾತೊ ತಿನಾ ಜಿವಿತಮಾ ಮ್ಹೆಲಿಲೆತೊ ನೈ. ತೆ ಮನಕ್ಹ ಕ್ಹುದಾನಾ ವಾತೊ ದಕ್ಹಿಯೆಳಜ ಚಾಲಿಲಿನ ಜಾ಼ವಸ. ತೆ ಕ್ಹುದಾನಾ ವಾತೊ ಸ್ವಿಕಾರ ಕರಿಲಿದಲಕ್ಹು ತಿನೆ ಕಷ್ಟ ರ‍್ಹವಾದೆ ತ್ರಾಸ ರ‍್ಹವಾದೆ ಆತಾಮಾ ತಿನೆ ಜಲ್ದಿನ ಛೊಡಿ ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","\"ಕಾಟಾನಾ ಝಾಡೊಮಾ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ ಸು ವ್ಹೈ? ಕ್ಹುದಾನಾ ವಾತೊ ಐಕಿನಬಿ ಲೊಕನಿ ಚಿಂತಾಕ್ಹು ವರಿ ದೊಕ್ಡಾನಾ ಉಪ್ಪರ ರ‍್ಹಯಲ ಮಯಾಕ್ಹು ಕ್ಹುದಾನಿ ವಾತೊನೆ ತಿನಾಮಾ ಬೆಳ್ದೆ ನೈಸೊ ಕರಾಲೊಜ಼ ಬಿಯ್ಯಾ ಪಡಲ ಕಾಟಾವೊನಾ ಝಾಡೊನಿ ಜಿಮಿನ ವ್ಹೈ. ತಿನಾಹುತಿ ಕ್ಹುದಾನಾ ವಾತೊ ತೆ ಮನಕ್ಹನಾ ಜಿವಿತಮಾ ಫಲ ನೈ ದೆತಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ಚೊ಼ಕಿ ಜಿಮಿನಪರ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ ಸು ವ್ಹೈ? ಕ್ಹುದಾನಾ ವಾತೊ ಐಕಿನ ತಿನೆ ತಿಳ್ದಿಲಿದಲ ಮನಕ್ಹಜ ಬಿಯ್ಯಾ ಪಡಲ ಚೊಕಿ ಜಿಮಿನ ವ್ಹೈ. ತೆ ಮನಕ್ಹ ಬೆಳ್ದಿನ ದಕ್ಹಿ ಸಲಾ ಕ್ಹೊ ಯಕ್ಲು ದಕ್ಹಿ ಸಲಾ ಕ್ಹಾಟ ಯಕ್ಲು ವರಿ ದಕ್ಹಿ ಸಲಾ ಮುವ್ವತ್ತ ಯಕ್ಲು ಫಲ ದಿವಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತ್ಯುನೊನೆ ವರಿಯಕ್ಕ ಸಾಮ್ಯನಾ ಮುಲಕ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕದ್ಯೊ. ತೆ ಸುವೈ ಕದ್ಯಾಮ: ಪರಲೊಕ ರಾಜ್ಯ ಚೊ಼ಕಾ ಬಿಯ್ಯಾ ತಿನಾ ಖೆತರಮಾ ಬಿತ್ತಲ ಯಕ್ಕ ರೈತ ಲಿಂಗತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ತೆ ರಾತ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಕ್ಹುರಯಲ ರ‍್ಹತಾಮಾ, ತೆ ಟೈಮಮಾ ತಿನೊ ದುಶ್ಮನ ಐನ ಘೌಂನಾ ವಚ್ಮಾ ಹಣಜಿ ಬಿತ್ತಿನ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ತೆ ಘೌಂ ಬೆಳ್ದಿನ ಬಿಯ್ಯಾ ದಿವಸ. ತಿನಾ‍ ಕ್ಹಾತೆಜ ಹಣಜಿಬಿ ಬೆಳ್ದಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ತೆಳಾಮ ತೆ ರೈತನಾ ಆಳೊ ತಿಕನ ಐನ, ತಾರಾ ಖೆತರಮಾ ತು ಚೊ಼ಕಾ ಬಿಯ್ಯಾ ಬಿತ್ಯೊತೊ. ಹಣಜಿ ಕಿಜಾ಼ಂತಿ ಐ?” ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ತೆ ಮನಕ್ಹ, ‘ಯಕ್ಲೊ ದುಶ್ಮನ ಹಣಜಿ ಬಿತ್ಯೊಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ತೆ ಆಳೊ, ಹಮೆ ಗೈನ ಹಣಜಿ ಕಿತ್ತೆ ಸು?\" ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ತೆ ಮನಕ್ಹ, ‘ನಕೊ, ಕಾಕದ್ಯಾಮ ತುಮೆ ಹಣಜಿ ಕಿತ್ತತಾ ಟೈಮಮಾ ಘೌಂ ಬಿ ಕಿತ್ತಿಪಾಡೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ಸುಗ್ಗಿಕಾಲ ಆಯೆಲಕ್ಕಾ ಹಣಜಿ ಘೌಂ ಮಳಿನ ಬೆಳ್ದಾದೆ. ಸುಗ್ಗಿಕಾಲನಾ ಟೈಮಮಾ ಮಿ ಕಾಮ ಕರಾಲಾವೊನೆ, ಪೈಲಾ ಹಣಜಿ ಕಾಟಿನ ತಿನೆ ಬಾಳಾನಾಹುತಿ ಭಾರೊ ಭಾಂದಿನ, ಪಾಚಲ್ತಾ ಘೌಂನೆ ಮಳೈನ ತಿನೆ ಮಾರಾ ಕಣಜಮಾ ಲಿನಾವೊ ಕೈನ ಕೌಸ’ ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ.” ");
INSERT INTO sle_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ಪಾಚಲ್ತೊ ಯೆಸು ಮನಕ್ಹೊನೆ ವರಿಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ; ಪರಲೊಕರಾಜ್ಯ ಸಾಸ್ವಿ ಕಾಳ ಲಿಂಗತ ಛೆ. ಯಕ್ಲೊ ತಿನೆ ಖೆತರಮಾ ಬಿತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ತೆ ಕ್ಹಾರಾ ಬಿಯ್ಯಾವೊತಿ ನ್ಹಾನೊ ಬಿಯ್ಯೊ ವ್ಹೈ. ತೆನೈಸೊ ತೆ ಬೆಳ್ದಲಪರ ಖೆತರನಾ ಝಾಡೊತಿಬಿ ಮ್ಹೊಟು ರ‍್ಹವಸ. ತೆ ಝಾಡ ಥಯಲ್ಪರ ಪಕ್ಷಿಯೊ ಐನ ತಿನಾ ಠೊಂಗಿಯೊಮಾ ಗುಡ ಕರಿಲಿಯೆ ಲಿಂಗತ ಮ್ಹೊಟಾ ರ‍್ಹವಸ.” ");
INSERT INTO sle_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ಪಾಚಲ್ತೊ ಯೆಸು ಮನಕ್ಹೊನೆ ವರಿಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ; ಪರಲೊಕರಾಜ್ಯ ಯಕ್ಕ ಬಾಕಡಿ ರೊಟ್ಲಾ ಕರಾನೆ ಯಕ್ಕ ಮ್ಹೊಟಾ ಪರಾತಮಾ ಲೊಟಮಾ ಮಳಾಯಲ ಖಾಟಾ ಲಿಂಗತ ಛೆ. ತೆ ಖಾಟು ಮಕ್ಹಳಲ ಪುರಾ ಲೊಟನೆ ಫುಗ್ಗಾವಸ.” ");
INSERT INTO sle_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ಯೆಸು ಎ ಕ್ಹಾರು ಸಾಮ್ಯನಾ ಮುಲಕ ಕದ್ಯೊ. ತೆ ಉಪದೆಶ ಕರ‍್ತಾ ಟೈಮಮಾ ಸಾಮ್ಯ ಉಪಯೊಗ ಕರ‍್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ಪ್ರವಾದಿ ಕದ್ಯಲ ಎ ವಾತ ಇನಾಕ್ಹು ಪುರಾ ಥಯು: \"ಮಿ ಸಾಮ್ಯನಾ ಮುಲಕ ಉಪದೆಶ ಕರುಸ; ದುನಿಯಾ ಸೃಷ್ಟಿ ಥಾವಾತಿ ಪೈಲಾ ದಡಿರ‍್ಹಯಲ ಕ್ಹಾರು ಭಾರೊ ಲೌಸ.” ");
INSERT INTO sle_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ಯೆಸು ಮನಕ್ಹೊನು ಗುಂಪನೆ ಛೊಡಿನಿ ಘರಮಾ ಗಯೊ. ತೆಳಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ತಿಕನ ಐನ ಸಾಮ್ಯನೊ ಮತ್ಲಬ ಹಮೊನೆ ಕೆ ಕದ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ಯೆಸು ಅಮ ಜವಾಬ ದಿದ್ಯೊ, ಖೆತರಮಾ ಚೊ಼ಕೊ ಬಿಯ್ಯೊ ಬಿತ್ತಾಲೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ತೆ ಖೆತರ ಎ ದುನಿಯಾ ವ್ಹೈ ಚೊ಼ಕೊ ಬಿಯ್ಯೊ ಸ್ವರ್ಗನಾ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ಹಣಜಿ ಕದ್ಯಾಮ ಕೆಟ್ಟ ಮನಕ್ಹನಾ ಬಚ್ಚಾ಼ ವ್ಹೈ ತಿನೆ ಬಿತ್ತಾಲೊ ದುಶ್ಮನ ಸೈತಾನ ವ್ಹೈ. ಸುಗ್ಗಿನೊ ಟೈಮ ಕದ್ಯಾಮ ದುನಿಯಾ ಖಲಾಸ ಥಾವಾನಾ ಟೈಮ್ಮಾ ಕಾಟಾಲಾ ಕದ್ಯಾಮ ದೆವದುತೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ಕಿಮ ಹಣಜಿ ಇನಿನ ಜ಼಼ಮಾ ಕರಿನ ಬಾಳಿಪಾಡಸ ತಿಮ್ಮಜ಼ ದುನಿಯಾ ಖಲಾಸ ಥಾವಾನಾ ಟೈಮ್ಮಾ ಇಮ್ಮಜ಼ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಾ ದುತೊನೆ ಮೊಕ್ಲಸ.ತ್ಯುನೆ ತಿನಾ ರಾಜ್ಯಮಾ ಪಾಪನೆ ಕಾರಣಥಯಲವಾಲಾ ಕ್ಹಾರಾ ಅಧರ್ಮಿಯೊನೆ ಮಳೈನ ಆಗನಿ ಇರಮಾ ಘಾಲಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ತ್ಯಾ ರವಾನು ವರಿ ಕಟ್ಟ-ಕಟ್ಟ ದಾತೊ ಖಾವಾನು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ತೆಳಾಮಾ ಕ್ಹರಿಕ್ಹು ರ‍್ಹಯಲವಾಲಾ ತ್ಯುನಾ ಬಾನಾ ರಾಜ್ಯಮಾ ಸುರ‍್ಯಾನಾನಿಂಗತ ಉಜಾಲಾವಾಲಾ ಥೈನ ದಿಕ್ಹಸ. ಐಕಾಲಾ ಕಾನೊ ರ‍್ಹಯಾಮ ಐಕಾದೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ಸ್ವರ್ಗ ರಾಜ್ಯನಾ ಖೆತರ ಝಾಕಿನ ಮ್ಹೆಲಲ ನಿಧಿನೆ ಹೊಲಿಕೆ ಥೈಸ. ಯಕ್ಲೊ ಇಕ್ಕಾತೊ ಲಿನ ಝಾಕಿನ ಮ್ಹೆಲಿನ ತಿನೆ ಥಯಲ ಕುಶಿಕ್ಹು ಗೈನ ತಿನೆ ರ‍್ಹಯಲ ಕ್ಹಾರು ಇಕ್ಕಿನ ತೆ ಖೆತರ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ವರಿ ಸ್ವರ್ಗನೊ ರಾಜ್ಯ ಚೊ಼ಕಾ ರ‍್ಹಯಲ ಮುತ್ತೊ ಹುಡಕಾಲೊ ವ್ಯಾಪಾರಿ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ತೆ ಯಕ್ಕ ಘನ್ನು ಮೊಗು ರ‍್ಹಯಲ ಮುತ್ತ ಇಕ್ಕಾತು ಲಿನ ಗೈನ ತಿಕನ ರ‍್ಹಯಲ ಇಕ್ಕಿನ ತೆ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","\"ಸ್ವರ್ಗನು ರಾಜ್ಯ ಸಮುದ್ರಮಾ ರ‍್ಹಯಲ ಸಮುದ್ರಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಿಯೊ ಮಚ್ಲಿಯೊ ಧರಾನಿ ಬಲಿ ನಿಂಗತ ಛೆ ");
INSERT INTO sle_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ತೆ ಭರಲ್ಪರ ಮಚ್ಲಿ಼ಯೊ ಧರಾಲಾ ತ್ಯುನೆ ಧಂಡಿಯೆ ಲೈನ ಚೊ಼ಕಿಯೊ ಮಚ್ಲಿಯೊ ಇನಿಲಿನ ಕೆಟ್ಟ ಮಚ್ಲಿ಼ಯೊ ನಾಕಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ಇನಾನಿಂಗತಜ಼ ದುನಿಯಾಬಿ ಖಲಾಸ ಥಾವಸ. ದೆವದುತೊ ಐನ ನಿತಿವಂತವಾಲಾವೊಮಾತಾ ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಜು಼ದಾ ಕರಿನ ತ್ಯುನೊನೆ ಆಗನಿ ಇರಮಾ ಘಾಲಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ತ್ಯಾ ರವಾನು ವರಿ ಕಟ್ಟ-ಕಟ್ಟ ದಾತೊ ಖಾವಾನು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ಎ ಕ್ಹಾರಿಯೊ ಸಂಗತಿಯೊ ಕಳಿಯೊಸು ಕೈನ ಪುಚ್ತಾ಼ಮಾ, ಕ್ಹಾರಾ ಶಿಷ್ಯಾ ಕಳ್ಯುಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ತೆಳಾಮ ತೆ ತ್ಯುನೊನೆ ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಸ್ವರ್ಗನಾ ಹುತಿ ಉಪದೆಶ ಹೊಂದಿನ ಶಿಕ್ಕಿಲ ಹರಿಯಕ್ಲೊ ಶಾಸ್ತ್ರೊಪದೆಶಕ, ಬೊಕ್ಕಸಮಾತೊ ನವಾ ಸಾಮನೊ, ಜು಼ನ್ನಾ ಸಾಮನೊ ಭಾರಾ ಕಾಡಲ ಘರ್ನೊ ಮಾಲಕನಿ ಹೊಲಿಕೆ ಥಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ಯೆಸು ಎ ಸಾಮ್ಯ ಕೈನ ಮುಗ್ಸಲ್ಪರ ತ್ಯಾಂತೊ ಗೈ ಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ತೆ ಥಯಲ್ಪರ ತೆ ತಿನಾ ಸ್ವಂತ ಗಾಮೆ ಐನ ತಿವ್ನಿ ಸಭಾಮಂದಿರಮಾ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರಾಡ್ಯೊತೊ. ತಿವ್ನೆ ತೆ ಐಕಿನ ಘಾಬ್ರಾ ಥೈನ, ಇನೆ ಎ ಗ್ಯಾನ ಮ್ಹೊಟಾ ಕಾಮೊ ಕರಾನು ಕಿಜ್ಗಾಂತು ಐಯು ವಸೆ? ");
INSERT INTO sle_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ಎ ಐಲಾ ಬಡಗ್ಯಾನೊ ದಿಕ್ರೊ ನ್ಹವೈ ಸು? ಇನಿ ಯಾ ಮರಿಯಳ ನ್ಹವೈ ಸು? ಯಾಕೊಬ, ಯೊಸೆಫ, ಸಿಮೊನ, ಯುದ ಇವ್ನೆ ಇನಾ ಭಾಯೊ ನ್ಹವೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ಇನಿಯೊ ಭೆನೊ ಅಪೊಮಾ ನತ್ತಿ ಸು? ವರಿ ಎ ಕ್ಹಾರು ತಿನೆ ಕಿಜ್ಗಾಂತೊ ಆಯುಸ? ತಿನಾ ಹುತಿ ತಿನೆ ಠುಕ್ರಾಯಾ ");
INSERT INTO sle_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ತೆನೈಸೊ ತ್ಯುನೊನೆ ತೆ ಪ್ರವಾದಿ ಬಿಜಿ ಜ಼ಗಾ ಕಿಜ್ಗಾ಼ ರ‍್ಹಯೊತಬಿ ತಿನಿ ಮರ್ಯಾದಿ ಛೆ. ಸ್ವಂತ ದೆಶಮಾ ವರಿ ಸ್ವಂತ ಗಾಮ್ಮಾ ಮರ್ಯಾದಿ ಮಳತಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ತ್ಯುನೊಮಾ ಬರೊಕ್ಹೊ ನೈ ರ‍್ಹಯಲ ಹುತಿ ತಿನಾಹುತಿ ತ್ಯಾ ಮ್ಹೊಟಾ ಕಾಮೊ ಕರ‍್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ತೆ ಟೈಮಮಾ ಹೆರೊದ ಗಲಿಲಾಯ ಗಾಮ್ಮಾ ರಾಜೊ಼ ವ್ಹತೊ. ಯೆಸುನಿ ಸುದ್ದಿ ಕ್ಹಾರುಜ಼ ತಿನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ಹೆರೊದ ತಿನಾ ಆಳೊನೆ ಎ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಾವಾಲೊ ಯೊಹಾನ ವ್ಹೈಸು; ಮರಲವಾಲಾಮಾತೊ ಉಟಿನ ಆಯೊಸ. ತಿನಾಹುತಿ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಕಾಮೊ ಕರಾನಿ ತಾಕತ ತಿನಾಮಾ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ಹೆರೊದ ತಿನಾ ಭೈನಿ ಬೈಕೊನಾ ಹುತಿ ಯೊಹಾನನೆ ಧರೈನ ಜೆಲ್ಮಾ ಘಾಲಾಲಗಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ಯೊಹಾನ ಹೆರೊದನೆ ತು ತಿನೆ ತಾರಿ ಬೈಕೊ ಕರಿಲಿನ ಮುಕ್ಕಿಲಿವಾನು ನ್ಯಾಯ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ಹೆರೊದ ತಿನೆ ಖಲಾಸ ಕರೌ ಕೈನ ಕೈಲಿದ್ಯೊತುಬಿ ಮನ್ಹೊಕ್ಹು ಭುಚ್ಕಾಡ್ಯೊತೊ, ಕಾ ಕದ್ಯಾಮ ತಿನೆ ತೆ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಗ್ವತ್ತ ವ್ಹತು. ");
INSERT INTO sle_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ತೆನೈಸೊ ಹೆರೊದ ಹುಟ್ಟಲ ದಿನ್ನಾ ದಿನ್ನೆ ಹೆರೊದ್ಯನಿ ದಿಕ್ರಿ ಆಯಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಿ ನ್ಹಾಚ಼ಲ ಹೆರೊದನೆ ಪಸಂದ ಆಯು. ");
INSERT INTO sle_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","\"ತುನೆ ಸು ಚಾ಼ಯೆ ತೆ ಮಾಂಗ ತುನೆ ಮಿ ದ್ಯುಸ ಕೈನ. ಕೈನ ವಾತ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ತೆ ಛೊಕ್ರಿ ತಿನಿ ಮಾನಿ ವಾತ ಐಕಿನ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಾವಾಲೊ ಯೊಹಾನನಿ ಗರ್ದನ ಕತ್ರಿನ ಪರಾತಮಾ ಮ್ಹೆಲ್ಲಿನ ಮನೆ ಮಂಗೈನ ದ್ಯು ಕೈನ ಕೈಲಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ತೆ ಛೊಕ್ರಿ ಮಾಂಗಿಲಿದಲಾ ಹುತಿ ಐಕಿನ ಹೆರೊದ ಘನ್ನೊ ದುಖಿ ಥಯೊ ತೆ ದಿದಲ ವಾತನಾ ಹುತಿಬಿ ದುಖಿ ಥಯೊ.ಕಾ ಕದ್ಯಾಮ ತ್ಯಾ ಐಯಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ವಾತ ದಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ತೆ ಯೊಹಾನನಿ ಗರ್ದನ ಕತ್ರಿಲಾವೊ ಕೈನ ಆಳೊನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ತ್ಯುನೆ ಯೊಹಾನನು ಗರ್ದನ ಮಾತ ಕತ್ರಿನ ಪರಾತ್ಮಾ ಲೈನ ಹೆರೊದ್ಯಳನಿ ದಿಕ್ರಿನಾ ಹತ್ಮಾ ದಿದ್ಯೊ.ತೆ ಗೈನ ತಿನಿ ಯಾನಾ ಹತ್ಮಾ ದಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಐನ ತಿನು ಮರಲ ಅಂಗ ಲಿಂಗೈನ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲ್ಯಾ. ತೆಳಾಮ ತ್ಯುನೆ ಯೆಸುಕನ ಗೈನ ಕ್ಹಾರು ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ಯೆಸು ಎ ಕ್ಹಾರು ಐಕಿನ ಹಡಗೊ ಚ಼ಡಿನ ತ್ಯಾಂತೊ ತೆ ಜ಼ಗಾ ಛೊಡಿನ ಕುನ್ನಜ಼ ನೈಸೊ ಜ಼ಗಾ ಗಯೊ. ಎ ಸುದ್ದಿ ಐಕಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತ್ಯುನಾ ತ್ಯುನಾ ಗಾಮ್ತಾ ಚಾ಼ಲ್ತಾ ಯೆಸುನಾ ಪಾಚಾ಼-ಪಾಚಾ಼ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ಯೆಸು ಮನಕ್ಹೊತಿ ಪೈಲಾ ಐನ ತೆ ಗುಂಪನೆ ದೆಕಿನ ತ್ಯುನೊನೆ ಮರಗನಿ ತ್ಯುನಾ ರೊಗೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ಕ್ಹಾಂಜ ಥಾತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ತಿಕನ ಐನ ಎ ರಾನ ವ್ಹೈ ಹಮ್ನಾ ಕ್ಹಾಂಜ಼ಬಿ ಥೈಸ ತೆ ಮನಕ್ಹೊನೆ ತ್ಯುನಾ ತ್ಯುನಾ ಗಾಮೊನೆ ಮೊಕಲ ಕಾ ಕದ್ಯಾ ತ್ಯುನೊನೆ ಖಾವಾನೆ ಅನ್ನ ಕರಿಲಿವಾದೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ತೆನೈಸೊ ಯೆಸು, ತ್ಯುನೊನೆ ತ್ಯುನೆ ಜಾ಼ವಾನಿ ಜ಼ರುರತ್ತ ನತ್ತಿ. ತುಮೆಜ಼ ತ್ಯುನೊನೆ ಸುಬಿ ಅನ್ನ ಖಾವಾನೆ ದಿವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ತೆಳಾಮ ತಿನಾ ಶಿಷ್ಯಾ, \"ಅಪೊನೆ ಪಾಂಚ಼ ರೊಕ್ಲ ವರಿ ಬೆ ಮಚ್ಲಿ಼ಯೊ ಛೆ ಕೈನ\" ಕತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ಯೆಸು ತ್ಯುನೊನೆ, \"ತೆ ರೊಕ್ಲ ವರಿ ಮಚ್ಲಿ಼ಯೊ ಮಕನ ಲೈನ ದಿವೊ ಕದ್ಯೊ.” ");
INSERT INTO sle_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ತೆಳಾಮಾ ತೆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಚಾ಼ರಾಪರ ಬೈಟೊ ಕೈನ ತೆ ಪಾಂಚ಼ ರೊಕಲಾ ಬೆ ಮಚ್ಲಿಯೊ ಲಿನ ಹಬಾಳನೆ ದೆಕಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ರೊಕಲಾ ಭಾಗಿನ ಶಿಷ್ಯಾವೊಕನ ದಿದ್ಯೊ. ತ್ಯುನೆ ಮನಕ್ಹೊನೆ ವಾಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ಕ್ಹಾರ ಮನಕ್ಹೊ ಪೆಟ ಭರಿನ ಖಾದ್ಯಾ ವರಿ ಉಗ್ರಲ ರೊಕಲಾನಾ ತುಕಡಾ ಮಳಾತಾಮಾ ಬಾರಾ ಟೊಪ್ಲಿಯೊ ಭರಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ಅನ್ನ ಖಾದಲವಾಲಾ ಮನಕ್ಹೊಮಾ ಹೆಣಮನಕ್ಹೊನೆ ವರಿ ಬಚ್ಚಾವೊನೆ ಛೊಡಿನ ದಾಣ್ಗಾಜ಼ ಪಾಂಚ಼ ಹಜಾ಼ರ ವ್ಹತಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ಎ ಥಯಲ್ಪರ ತೆ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಮಿ ಆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಮೊಕ್ಲೆಲಕ್ಕಾ ತುಮೆ ಹಡ್ಗೊ ಚ಼ಡಿನ ಮುತ್ತಿ ಪೈಲಾ ತುಮೆ ಬಿಜಿ ದಂಡಿಯೆ ಜಾ಼ವೊ ಕೈನ ಜ಼ಬರದಸ್ತಿಯೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಮೊಕಲಿನ ಯಕ್ಲೊಜ಼ ಪ್ರಾಥನಾ ಕರಾನಾ ಹುತಿ ಡೊಂಗರ್ಪರ ಗಯೊ.ವರಿ ಕ್ಹಾಂಜ಼ ಥಯಲಹುತಿ ತ್ಯಾ ಯಕ್ಲೊಜ಼ ವ್ಹತೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ತೆ ಟೈಮ್ಮ ಶಿಷ್ಯಾ ಗಯಲ ಹಡಗೊ ಸಮುದ್ರನಾ ವಚ್ಮಾ಼ ವ್ಹತೊ ಹಡ್ಗಾನಾ ವಿರುದ್ದ ವಾರೊ ಛುಟಲಹುತಿಸುಮುದ್ರನಿಯೊ ಧಡ್ಕಿಯೊ ಲಾಗಾಕ್ಹು ಹಡ್ಗೊ ಪಾನಿಮಾ ಡುಬಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ತೆ ಟೈಮ್ಮಾ ರಾತ್ನಾ ಚಾರ ವಾಸ್ತಾ ಯೆಸು ಸಮುದ್ರಪರ ಚಾ಼ಲ್ತೊ ತ್ಯುನೊಕನ ಆವಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ತೆ ಸಮುದ್ರಪರ ಚಾ಼ಲ್ತೊ ಆವಾನು ತಿನಾ ಶಿಷ್ಯಾ ದೆಕಿನ ಭುತ್ಡು ವ್ಹೈ ಕೈನ ಘನ್ನಾ ಭುಚ್ಕಿನ ಅಡ್ಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ತೆಕ್ಲಾಮಾಜ಼಼ ಯೆಸು ತ್ಯುನೆ ದೆಕಿನ ಭುಚ್ಕೊ಼ ನಕೊ ಮಿ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ತೆಳಾಮ ಪೆತ್ರಾ, \"ಪ್ರಭು ಕ್ಹರಿಮಾಜ಼ ತು ರ‍್ಹಯೊಮ, ಮನೆ ಪಾನಿಪರ ಚಾ಼ಲಿನ ಆವಾನೆ ಅಪ್ಪಣೆ ದೆ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ಯೆಸು, ತೆಳಾಮ ಪೆತ್ರಾ \"ಆ\" ಕದ್ಯೊ. ತೆಳಾಮ ತೆ ಹಡ್ಗಾಮಾತೊ ಉತ್ರಿನ ಪಾನಿಪರ ಚಾ಼ಲಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ತೆಳಾಮಾ ಪೆತ್ರಾ ವಾರಾನೆ ದೆಕಿನ ಭುಚ್ಕಿ಼ನ ಪಾನಿಮಾ ಡುಬಾಡ್ಯೊ, ಕರ್ತಾ ಮನೆ ವಚಾ಼ಡ ಕೈನ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ಯೆಸು ತಿನೆ ಹತ್ತ ಧರಿನ ಎ ಅಲ್ಪ ವಿಶ್ವಾಸಿ ಕಾ ಸಂಶೊ ಕರ‍್ಯೊ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ಪೆತ್ರಾ ವರಿ ಯೆಸು ಹಡ್ಗೊ ಚ಼ಡಲ್ಪರ ಸಮುದ್ರಪರ ರ‍್ಹಯಲ. ವಾರೊ ಶಾಂತ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ತೆಳಾಮಾ ಹಡ್ಗಾಮಾ ರ‍್ಹಯಲ ಶಿಷ್ಯಾ \"ತು ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ\" ವ್ಹೈ ಕೈನ ಆರಾಧನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ತ್ಯುನೆ ಸಮುಂದರ ದಾಟಿನ ಗೆನೆಜರೆತ ಗಾಮನಿ ದಂಡಿ ಬಗಲ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ತಿನೆ ವಳಕಿನ ಸುತ್ತೆ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಗಮೊನೆ ಮನಕ್ಹೊನೆ ಮೊಕಲಿನ ರೊಗ್ಮಾ ರ‍್ಹಯಲವಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ತಿಕನ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ತ್ಯುನೆ ತಿನೆ ತು ಘಾಲ್ಲಿದಲ ವಣ್ಣಾನಿಯೊ ತುದಿ ತುಬಿ ಮುಟ್ಟಾನೆ ದೆ ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ವರಿ ತಿನೆ ಮುಟ್ಟಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಅರಾಮ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ತೆಳಾಮ ಯೆರುಸಲೆಮತಾ ಪರಿಸಾಯರೊ, ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಯೆಸು ಕನ ಐನ, ");
INSERT INTO sle_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"ತಾರಾ ಶಿಷ್ಯಾ ಶಾನಾ ಮನಕ್ಹೊ ಕರಲ ಪದ್ದತನೆ ಕಾ ದಾಟಿನ ಜಾ಼ವಸ? ತ್ಯುನೆ ಖಾತಾಮಾ ತ್ಯುನಾ ಹತೊ ಧ್ವಯಿಲೆತಾ ನೈ ಕಾ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ತಿನಾಹುತಿ ತೆ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ತುಮೆ ತುಮಾರಾ ಪದ್ದತನಾ ಹುತಿ ಕ್ಹುದಾನಿ ಆಜ್ಞಾನೆ ಕಾ ದಾಟೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","\"ತಾರಾ ಮಾ ಬಾಪನೆ ಮರ್ಯಾದಿ ದ್ಯು ಕೈನ ಬಾನೆ ರ‍್ಹವಾದೆ ಯಾನೆ ರ‍್ಹವಾದೆ ದೊಷ ದಿದಲವಾಲೊ ಮರಸ ಕೈನ ಕ್ಹುದಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ತೆನೈಸೊ ಯಕ್ಕ ಮನಕ್ಹ ತಿನಾ ಮಾ ಬಾಪ್ನೆ ತುಮೊನೆ ಮದತ ಕರಾನೆ ಮನೆ ಥಾತು ನೈ, ಕಾಕದ್ಯಾಮ ಮಾರಾಮಾ ರ‍್ಹವಾನು ಕ್ಹುದಾನೆ ಒಪ್ಪಿಸಾಯೊಸ ಕೈನ ಕದ್ಯೊಮ, ");
INSERT INTO sle_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ತೆ ‘ತಿನಾ ಮಾಪನೆ ಸನ್ಮಾನ ಕರು ನೈ’ ಕವೊಶಿ. ಇಮ್ಮ ತುಮಾರಿ ಪದ್ದತನಾ ಹುತಿ ಕ್ಹುದಾನಿ ವಾಕ್ಯನೆ ಇನ್ಕಾರ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ತುಮೆ ಕಪಟಿಯೊ ವ್ಹೈ, ತುಮಾರಾಹುತಿ ಯೆಶಾಯ ಕರೆಟ್ಟ ಪ್ರವಾದನೆ ಕರಿನ, ತೆ ಕವಾನು ಸು ವ್ಹೈ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ಎ ಮನಕ್ಹೊ ತ್ಯುನಾ ಮ್ಹೊಡಾವೊಕ್ಹು ಮನೆ ಸನ್ಮಾನ ಕರಸ ತೆನೈಸೊ ತ್ಯುನಾ ಮನಸೊ ಮಕ್ಹು ಘನ್ನಾ ದುರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ಮನಕ್ಹೊ ವಿಚಾರ ಕರಲ ಕಟ್ಟಳೆನೆ ತ್ಯುನೆ ಉಪದೆಶ ಕರಿನ ಬೊದನೆ ಕರಾಕ್ಹು ಮನೆ ವ್ಯರ್ಥ ಆರಾಧನಾ ಕರಸ ಕವಾನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ಪಾಚ಼ಲ್ತೊ ಯೆಸು ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಅಗೊ ಬಲೈನ ತ್ಯುನೊನೆ, ಐಕಿನ ತಿಳ್ದಿಲಿವೊ, ");
INSERT INTO sle_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ಮ್ಹೊಡಾಮಾ ಜಾ಼ವಾನು ಮನಕ್ಹನೆ ಅಶುದ್ದ ನೈ ಕರ‍್ತು, ಮ್ಹೊಡಾತು ಭಾರಾ ಆವಾನಾ ವಾತೊಜ಼ ಮನಕ್ಹನೆ ಅಶುದ್ದ ಕರಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ತೆಳಾಮಾ ಶಿಶ್ಯಾ ಐನ ತಿನೆ, ಪರಿಸಾಯೊ ಎ ವಾತ ಐಕಿನ ಬೆಜ್ಜಾ಼ರ ಥಯಾ ಕೈನ ತುನೆ ಗ್ವತ್ತ ಥಯು ಸು ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ತಿನೆ ತೆ ಪರಲೊಕನೊ ಮಾರೊ ಬಾ ನೈ ಗಡಾಯಲ ಕ್ಹಾರಾ ಝಾಡೊನೆ ಬೆರ ಕ್ಹಮೆತ ಕಿತ್ತಿನ ನಾಕಿಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ತ್ಯುನೊನೆ ಛೊಡೊ, ತ್ಯುನೆ ಕಡ್ಡಾವೊನೆ ವಾಟ ದೆಕಾಡಾಲಾ ಕುಡ್ಡಾ ಲಿಂಗತ ಛೆ. ಕುಡ್ಡೊ ಕುಡ್ಡಾನೆ ವಾಟ ದೆಕಾಡ್ಯಮ ತ್ಯುನೆ ಭಂಬಿ ಜ಼ನಾ ಖಾಡಿಮಾ ಪಡಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ತೆಳಾಮಾ ಪೆತ್ರಾ, ಎ ಸಾಮ್ಯ ಹಮೊನೆ ತಿಳಸೈನ ಕೆ ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ತಿನಾಹುತಿ ಯೆಸು, \"ತುಮೆಬಿ ಹಜು಼ನ ಗ್ಯಾನ ನೈಸೊವಾಲಾ ಥಯಾಸ? ");
INSERT INTO sle_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ಮ್ಹೊಡಾಮಾ ಜಾ಼ವಾನು ಪೆಟಮಾ ಗೈನ ಜಿರ್ಣ ಥೈನ ಜಾ಼ವಾನು ವ್ಹೈ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ತೆನೈಸೊ ಮ್ಹೊಡಾಮಾತಾ ಭಾರಾ ಸು ಆವಸ ಕ್ಹಾರು ಮನಸಮಾತು ಆವಸ. ಎಜ಼ ಮನಕ್ಹನೆ ಅಶುದ್ದ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ಕಾಕದ್ಯಾಮ ಮನಸಮಾತು ಕೆಟ್ಟ ವಿಚಾರೊ, ಖಲಾಸ ಕರಾನು, ವ್ಯಬಿಚಾರ, ಜಾರತ್ವ, ಚೊ಼ರಿ, ಸುಳ್ಳ ಸಾಕ್ಷಿ ವರಿ ದುಶಣೆ ಹೊರಾಟ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ಹೆವಾಜ಼ ಮನಕ್ಹನೆ ಅಶುದ್ದ ಕರಸ. ತೆನೈಸೊ ಹತ್ತ ಧ್ವಯಾ ಬಗರ ಅನ್ನ ಖಾವಾನು ಮನಕ್ಹನೆ ಅಶುದ್ದ ನೈ ಕರ‍್ತು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ಪಾಚ಼ಲ್ತೊ ಯೆಸು ತ್ಯಾಂತೊ ಗೈನ ತುರ ಸಿದೊನ ಗಾಮನಾ ಪ್ರಾಂತೊನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ತೆ ಜ಼ಗಾತಿ ಕಾನಾನ್ಯನಿ ಥಯಲ ಯಕ್ಕ ಬಾಕಡಿ ಐ, ಕರ್ತ, ದಾವಿದನಾ ದಿಕ್ರಾ, ಮಾರಾ ಉಪ್ಪರ ಮರ್ಗಾ ಮ್ಹೆಲ, ಮಾರಿ ದಿಕ್ರಿನೆ ಭುತಡು ಧರಿನ ಘನ್ನಿ ತ್ರಾಸ ಕ್ಹಾವಾಡಿಸ ಕೈನ ಅಡ್ಡಿ. ");
INSERT INTO sle_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ತೆನೈಸೊ ತೆ ತಿನೆಸುಜ಼ ಜವಾಬ ದಿದ್ಯೊ ನೈ. ತೆಳಾಮಾ ತಿನಾ ಶಿಶ್ಯಾ ಐನ, ತೆ ಅಪ್ನಾ ಪಾಚಿ ಅಡ್ಡತಿ ಆವಾಡಿಸ. ತಿನೆ ವಳೈಪಡ ಕೈನ ತಿನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ತೆ ವಾತೆ ಯೆಸು ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಜ಼ವೈಗಯಲ ಬಕ್ರಾ ಲಿಂಗತ ರ‍್ಹವಾಲಾ ಇಸ್ರಾಯೆಲ ಘರ್ದಾನವಾಲಾವೊನಾ ಕನ ನೈಸೊ ಬಿಜಾ಼ ಕಿಕನಜ಼ ಮನೆ ವಳಾಯಲವಾಲೊ ನ್ಹವೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ತೆಳಾಮಾ ತೆ ಹೆಣ ಮನಕ್ಹ ಯೆಸುನಾ ಕ್ಹಾಮಿ ಅಡ್ಡ ಪಡಿನ, ಕರ್ತಾ ಮನೆ ಸಹಾಯ ಕರ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ತಿನಾಹುತಿ ಯೆಸು, \"ಬಚ್ಚಾ ಖಾವಾನೊ ರೊಕ್ಲೊ ಲಿನ ಕುತ್ರಾನಾ ಬಚ್ಚಾವೊನೆ ಘಾಲಾನು ಕರೆಟ್ಟ ನ್ಹವೈ ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ತೆ ಹೆಣ ಮನಕ್ಹ, \"ಹೊ ಪ್ರಭು, ತೆನೈಸೊ ಕುತ್ರಾನಾ ಬಚ್ಚಾ಼ತುಬಿ ತ್ಯುನಾ ಮಾಲಕನಾ ಟೆಬಲಪರ‍್ತಾ ಪಡಲ ರೊಕ್ಲಾನಾ ತುಕ್ಡಾ ಖಾವಸತೊ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ತೆಳಾಮಾ ಯೆಸು ತೆ ಬಾಕಡಿನೆ, \"ಯಾ, ತಾರೊ ಬರೊಕ್ಹೊ ಮ್ಹೊಟೊ ವ್ಹೈ. ತು ಸೊಚಲ ತಿಮ್ಮ ತುನೆ ಥಾವಾದೆ ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ತೆ ಟೈಮಮಾ ತಿನಿ ದಿಕ್ರಿನೆ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ಯೆಸು ತ್ಯಾಂತೊ ಗೈನ ಗಲಿಲಾಯ ಸಮಂದರ ಕನ ಗಯೊ. ತೆಳಾಮಾ ತೆ ಯಕ್ಕ ಡೊಂಗರ ಚ಼ಡಿನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ತೆಳಾಮಾ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತಿಕನ ಆಯಾ ಲಂಗಡಾ, ಕುಡ್ಡಾ, ಮುಕಾ, ಹತೊಪಗೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ಹೆವಾ ಹಜು಼ನ ಘನ್ನಾ ಜ಼ನಾವೊನೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬಲೈಲಿನ ತ್ಯುನೊನೆ ಯೆಸುನಾ ಪಗೊಕನ ಛೊಡ್ಯಾ. ತೆ ತ್ಯುನೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ಮುಕಾ ಬೊಲಾನು, ಲಂಗ್ಡಾ ಚಾ಼ಲಾನು, ಅರಾಮ ಕುನ ವ್ಹತಾ ಡೊಳಾ ನೈ ರ‍್ಹ ಡೊಳಾ ಐನ ದೆಕಿನ ಕ್ಹಾರ ಮನಕ್ಹೊ ಘಾಬ್ರ ಕೈನ ಇಸ್ರಾಯಲ ಕ್ಹುದಾ ಸ್ತುತ ವಾಲಾವೊನೆ. ");
INSERT INTO sle_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಬಲೈನ, \"ಮಿ ಎ ಮನಕ್ಹೊನಾ ಹುತಿ ದುಖಿ ಥಯೊಸ. ತ್ಯುನೆ ತನ್ನ ದಿನ ಮಾರ ಕ್ಹಾತೆ ಛೆ. ಹಮ್ನಾ ತ್ಯುನೊನೆ ಖಾವನೆ ಸುಜ಼ ನತ್ತಿ. ತ್ಯುನೊನೆ ಭುಕ್ಕಾ ಮೊಕ್ಲಾನೆ ಮನೆ ಮನಸ ನತ್ತಿ. ತ್ಯುನೆ ಘರೆ ಜಾ಼ತಾಮಾ ಸುಸ್ತ ಥಾಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ಶಿಷ್ಯಾವೊನೆ ಯೆಸು, ‘ಎ ಮನಕ್ಹೊನೆ ಚಾ಼ಯೆ ಥಯೆ ಲಿಂಗತ ರೊಕ್ಲಾ ಎ ರಾನಮಾ ಅಪೊನೆ ಕಿಜಾ಼ಂತು ಮಳಸ?” ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ಯೆಸು, ತುಮೊಕನ ಕಕ್ಲಾ ರೊಕ್ಲಾ ಛೆ? ಕೈನ ಪುಚ್ಚಲಕ್ಹು ತ್ಯುನೆ, ಕ್ಹಾತ ರೊಕ್ಲಾ ಛೆ ವರಿ ದಕ್ಹಾ ನ್ಹಾನಾ ಮಚ್ಲಿ಼ಯೊ ಛೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ತೆಳಾಮಾ ತೆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ, ಜಿಮಿನಪರ ಬೈಟೊ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ತೆ ಕ್ಹಾತ ರೊಕ್ಲಾ ವರಿ ಮಚ್ಲಿ಼ಯೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರ ಕರಿನ ತೆ ರೊಕ್ಲಾ ಭಾಗಿನ ಶಿಷ್ಯಾವೊನೆ ದಿದ್ಯೊ. ತೆ ಶಿಷ್ಯಾ ಮನಕ್ಹೊನೆ ವಾಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ಮನಕ್ಹೊ ಪೆಟ ಭರಿನ ಖಾದ್ಯಾ ವರಿ ಉಗ್ರಲ ಅನ್ನ ಶಿಷ್ಯಾ ಕ್ಹಾತ ಟೊಪ್ಲಿಯೊ ಭರಿ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ತೆ ದಿನ್ನ ಅನ್ನ ಖಾದ್ಯಲವಾಲಾವೊಮಾ ಬಾಕ್ಡಿಯೊ ಬಚ್ಚಾ಼ವೊನೆ ಛೊಡಿನ ಚಾರ ಹಜಾ಼ರ ದಾಣ್ಗಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತೆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಘರೊಯೆ ವಳೈನ ಹಡಗೊ ಛಡಿನ ಮಗದಾನ ಕವಾನಾ ಸಿಮೆನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ಪಾಚ಼ಲ್ತಾ ಪರಿಸಾಯರೊ ಸದ್ದುಕಾಯರೊ ಐನ ಪರಿಕ್ಷಾ ಕರಾನಾಹುತಿ, ತು ಪರಲೊಕತು ಯಕ್ಕ ಸುಚಕ ಕಾಮ ಹಮೊನೆ ದೆಕಾಡು ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ಯೆಸು ತ್ಯುನೊನೆ, ‘ಖಾಂಜ಼ ಥಯಲ್ಪರ ಹಬಾಳ ಲಾಲ ಥಯಮ ಚೊ಼ಕಿ ವಾತಾವರಣ ರ‍್ಹವಸ’ ಕವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ಪಾಟೆ, ‘ಹಬಾಳ ಮ್ಹಾಡ ಘಾಲಿನ ಲಾಲ ಥಯಮ ಹಮ್ನಾ ವಾರೊ ಪಾನಿ ಆವಸ' ಕವೊಶಿ. ಹಬಾಳಮಾ ದಿಕ್ಹಾನಾ ಸುಚನೆ ತಿಳ್ದಿಲಿವಾಲಾ ಥಯಾಸ, ತೆನೈಸೊ ಆಂ ಕಾಲಮಾನಾ ಸುಚನೆ ತಿಳ್ದಿಲಿವಾನೆ ತುಮೊನೆ ಥಾವಾಡು ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ವ್ಯಬಿಚಾರಿ ಲಿಂಗತ ರ‍್ಹಯಲ ಎ ದುಶ್ಟ ಸಂತತಿ ಸುಚಕ ಕಾಮ ದೆಕು ಕೈನ ಹುಡಕಸ. ತೆನೈಸೊ ಯೊನನು ಸುಚಕ ಕಾಮ ಛೊಡಿನ ಬಿಜು಼ ಕಯುಜ಼ ನೈ ಮಳ್ತು ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ಪಾಚ಼ಲ್ತೊ ಯೆಸು ತ್ಯುನೊನೆ ಛೊಡಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ಶಿಶ್ಯಾ ಅನ್ನನಿ ಭುತ್ತಿ ಲಿವಾನು ಇಕ್ಹರಿನ ಬಿಜಿ ದಂಡಿಯೆ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ಯೆಸು ತ್ಯುನೊನೆ ಹುಶಾರ ರ‍್ಹವೊ! ಪರಿಸಾಯರೊ ವರಿ ಸದ್ದುಕಾಯರೊನಾ ಕ್ಹಾಟಾ ಲೊಟನಾ ವಿಶಯಮಾ ಹುಶಾರ ರ‍್ಹವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ತಿನಾಹುತಿ ಶಿಷ್ಯಾ, ಅಪೆ ಅನ್ನನಿ ಭುತ್ತಿ ಲಿದ್ಯಾ ಬಗರ ಆಯಲಕ್ಹು ಇಮ್ಮ ಕದ್ಯೊವಸ ಕೈನ ತ್ಯುನಾ ತ್ಯುನಾಮಾ ಬೊಲಿ ಲಿವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ಯುಸು ತೆ ತಿಳ್ದಿಲಿನ , ಅಲ್ಪ ವಿಶ್ವಾಸಿಯೊ, ಅನ್ನನಿ ಭುತ್ತಿ ಲಾಯಾ ನತ್ತಿ ಕೈನ ತುಮೊಮಾ ಕಾ ಬೊಲಿ ಲಿವಾಡಾಸ? ");
INSERT INTO sle_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ತೆ ಪಾಂಚ಼ ರೊಕ್ಲಾ ಪಾಂಚ಼ ಹಜಾರ ಮನಕ್ಹೊನೆ ವಾಟಲಪರ ಕಕ್ಲಾ ಟೊಪ್ಲಿಯೊ ಭರಿಲಿದ್ಯಾತಾ? ");
INSERT INTO sle_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ತೆನೈಸೊ ಕ್ಹಾತ ರೊಕ್ಲಾ ಚಾರ ಹಜಾ಼ರ ಮನಕ್ಹೊನೆ ವಾಟಲಪರ ಕಕ್ಲಾ ಟೊಪ್ಲಿಯೊ ಭರ‍್ಯಾತಾ? ತುಮೆ ಹಜು಼ನ ತಿಳ್ದಿಲಿದ್ಯಾ ನತ್ತಿ ಸು? ತುಮೊನೆ ಶೆಂ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ಮಿ ರೊಕ್ಲಾನಾಹುತಿ ಬೊಲ್ಯೊ ನತ್ತಿ, ಕವಾನು ತುಮೊನೆ ಕಿಮ್ಮ ಗೊತ್ತ ಥಯು ನೈ? ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕದಲ ಸುವೈ ಕದ್ಯಾಮ, ಪರಿಸಾಯರೊ ವರಿ ಸದ್ದುಕಾಯರೊನು ಕ್ಹಾಟಾ ಲೊಟನಾ ವಿಶಯಮಾ ಹುಶಾರ ರ‍್ಹೌ ಕವಾನುಜ಼ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ತೆಳಾಮಾ ಶಿಶ್ಯಾ ರೊಕ್ಲಾನು ಕ್ಹಾಟೊ ಲೊಟನಾ ಹುತಿ ಪರಿಸಾಯರೊ ವರಿ ಸದ್ದುಕಾಯರೊನಾ ಬೊದನೆನಾ ಹುತಿ ಹುಶಾರ ರ‍್ಹವೊ ಕೈನ ಕದ್ಯೊ ಕವಾನು ತಿಳ್ದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ಯೆಸು ಫಿಲಿಪ್ಪನಾ ಕೈಸರೈ ಕವಾನಾ ಗಾಮನಾ ಪ್ರಾಂತ್ಯನೆ ಆಯಲ್ಪರ, ಮನಕ್ಹೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಥಯಲ ಮನೆ ಕುನ್ನ ವ್ಹೈ ಕವಸ ಕೈನ ಶಿಶ್ಯಾವೊನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ತೆಳಾಮಾ ಶಿಷ್ಯಾ, \"ತುನೆ ದಕ್ಹಾ ಜ಼ನಾ ಸ್ನಾನಿಕ ಥಯಲ ಯೊಹಾನ ಕವಸ, ದಕ್ಹಾ ಜ಼ನಾ ಎಲಿಯಾ ಕವಸ ವರಿ ಬಿಜಾ಼ ದಕ್ಹಾ ಜ಼ನಾ ಯೆರೆಮಿಯ ಕವಸ, ತೆನೈಸೊ ಪ್ರವಾದಿಯೊಮಾ ಯಕ್ಲೊ ಕವಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ಯೆಸು ಶಿಶ್ಯಾವೊನೆ, ತುಮೆ ಮನೆ ಕುನ್ನ ವ್ಹೈ ಕವೊಶಿ ಕೈನ ಪುಚ್ಯೊ? ");
INSERT INTO sle_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ತೆಳಾಮಾ ಸಿಮೊನ ಪೆತ್ರಾ, ತು ಜಿವ್ತೊ ರ‍್ಹಯಲ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಥಯಲ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ಯೆಸು, ಯೊನನೊ ದಿಕ್ರೊ ಥಯಲ ಸಿಮೊನ, ತು ಧನ್ಯ ವ್ಹೈ. ಕಾಕದ್ಯಾಮ ಎ ಮನಕ್ಹಕಂತು ತುನೆ ಗೊತ್ತ ನತ್ತಿ ಥಯು, ಪರಲೊಕಮಾ ರ‍್ಹವಾಲೊ ಮಾರೊ ಬಾಜ಼ ಎ ಕ್ಹಾರು ತಿಳ್ಸಾಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ಮಿಬಿ ಎಜ಼ ತುನೆ ಕೌಸ, ತು ಪೆತ್ರಾ ವ್ಹೈ, ಎ ದಗಡಾನಾ ಉಪ್ಪರ ಮಿ ಮಾರಿ ಸಭೆ ಭಾಂದುಸ.ಪಾತಾಳನಿ ತಾಕತ ತಿನೆ ಹರಾನೈ ಸಕ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ಪರಲೊಕ ರಾಜ್ಯನಿ ಚಾವಿಯೊ ತುಮೆ ದ್ಯುಸ. ಭುಲೊಕಮಾ ತು ಕಯು ಭಾಂದಶಿ ತೆ ಪರಲೊಕ ರಾಜ್ಯಮಾಬಿ ಭಂದಾವಸ. ವರಿ ಭುಲೊಕಮಾ ತು ಕಯು ಖೊಲಶಿ ತೆ ಪರಲೊಕಮಾಬಿ ಖೊಲಲ ರ‍್ಹವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ತೆಳಾಮಾ ಯೆಸು , ಮಿ ಕ್ರಿಸ್ತ ಥಯೊಸ ಕವಾನು ಕಿನೆಜ಼ ಕವೊ ನಕೊ ಕೈನ ತಿನಾ ಶಿಶ್ಯಾವೊನೆ ಆಗನ್ಯಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ತೆ ದಿನತೊ ಯೆಸು ತೆ ಯೆರುಸಲೆಮೆ ಗೈನ ಶಾನಾವೊತಿಬಿ ಖಾಸ ಯಾಜಕೊಕ್ಹುಬಿ ಶಾಸ್ತಿಯೊಕ್ಹುಬಿ ಘನ್ನಾ ತ್ರಾಸೊ ಖೈನ ಮರಿನ ತನ್ವಾ ದಿನ್ನೆ ಉಟಿನ ಆವಾನು ಜರುರಿ ವ್ಹೈ ಕೈನ ತಿನಾ ಶಿಶ್ಯಾವೊನೆ ಕವಾನೆ ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ತೆಳಾಮಾ ಪೆತ್ರಾ ತಿನೆ ಸೈಡಮಾ ಬಲೈಲಿನ ಗೈನ, ಕರ್ತಾ, ಕ್ಹುದಾ ತುನೆ ತೆ ತ್ರಾಸ ನಕೊ ದಿವಾದೆ.ತುನೆ ಇಮ್ಮ ಕೆಳಾಮಾಜ಼ ಥೌ ನೈ ಕೈನ ತೆ ಭುಚ್ಕಾಡಾನೆ ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ಯೆಸು ತೆಳಾಮಾ ಪೆತ್ರಾನೆ, ಸೈತಾನ, ಮನೆ ಛೊಡಿನ ಜಾ಼. ಮನೆ ತು ಅಡ್ಡಿ ಥಯೊಸ, ಕಾಕದ್ಯಾಮ ತು ಕ್ಹುದಾನಾ ವಿಚಾರಕ್ಹು ಸೊಚಾ಼ನು ಛೊಡಿನ ಮನಕ್ಹನಾ ವಿಚಾರೊ ನಿಂಗತ ವಿಚಾರ ಕರಾಡೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ಪಾಚ಼ಲ್ತೊ ಯೆಸು ತಿನಾ ಶಿಶ್ಯಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಕುನತುಬಿ ಮಾರಒ ಪಾಚೊ಼ ಆವಾನೆ ಮನಸ ಕರ‍್ಯೊಮ ತೆ ತಿನೆಜ಼ ಇನ್ಕಾರಿನ ತಿನಿ ಶಿಲುವಿ ಉಚೈಲಿನ ಮಾರಾ ಪಾಚೊ಼ ಆವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ತಿನಾ ಜ಼ಲಮನೆ ವಚಾ಼ಡಿಲ್ಯು ಕವಾಲೊ ತಿನೆ ಜವೈ ಲಿವಸ. ತೆನೈಸೊ ಮಾರಾಹುತಿ ತಿನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿದ್ಯಲವಾಲೊ ತಿನೆ ಪಡ್ದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ಯಕ್ಕ ಮನಕ್ಹ ಭುಲೊಕ ಕ್ಹಾರು ಕಮೈಲಿದ್ಯೊತಬಿ ತಿನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿದ್ಯೊಮ ತಿನೆ ಲಾಭ ಸು ವ್ಹೈ? ತೆನೈಸೊ ಯಕ್ಲೊ ತಿನಾ ಜ಼ಲಮನಾಹುತಿ ಸು ದೆಸಕಸ? ");
INSERT INTO sle_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಾ ಬಾನಿ ಮಹಿಮಾನಾ ಕ್ಹಾತೆ ತಿನಾ ದುತೊನಾ ಕ್ಹಾತೆ ಆವಸ. ತೆಳಾಮಾ ತೆ ಯಕೆಕ್ಲಾವೊನೆ ತೆ ಕರಲ ಕಾಮ ನಿಂಗತ ಪ್ರತಿ ಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ ನ್ಹ್ಯಾ ಹುಬ್ರಯಲವಾಲಾವೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಾ ರಾಜ್ಯಮಾ ಆವಾನು ದೆಕೆ ಲಕ್ಕಾ ಮರ್ತಾಜ಼ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ಛೆ ದಿನ್ನ ಥಯಲ್ಪರ, ಯೆಸು ಪೆತ್ರಾನೆ ಯಾಕೊಬನೆ ತಿನೊ ನ್ಹಾನೊ ಭೈ ಯೊಹಾನನೆ ಕುನ್ನಜ಼ ನೈರ‍್ಹಯಲ ಉಚ಼್ಚಾ ಡೊಂಗರಪರ ಬಲೈಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ತ್ಯಾ ಯೆಸು ತ್ಯುನಾ ಕ್ಹಾಮೊ ರುಪಾಂತರ ಥಯೊ. ತಿನು ಮ್ಹೊಡು ಸುರ್ಯಾನಾ ನಿಂಗತ ಮಿಂಚಾ಼ಡುತು. ತಿನಾ ವಣ್ಣಾ ಉಜಾಲಾ ನಿಂಗತ ಧೊಳಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ತೆಳಾಮಾ ಮೊಶೆಬಿ ಎಲಿಯಾಬಿ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲ್ತಾ ರ‍್ಹಯಲ ತ್ಯುನೊನೆ ದಿಕ್ಹ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ತೆಳಾಮಾ ಪೆತ್ರಾ ಯೆಸುನೆ, ಕರ್ತಾ, ಅಪೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹವಾನು ಚೊ಼ಕು ವ್ಹೈ. ತು ಮನಸ ಕರ‍್ಯೊಮ, ನ್ಹ್ಯಾ ತನ್ನ ಝುಪ್ಡಾ ಭಾಂದುಸ. ತುನೆ ಯಕ್ಕ, ಮೊಶೆನೆ ಯಕ್ಕ, ಎಲಿಯಾನೆ ಯಕ್ಕ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ತೆ ಹಜ಼ುನ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾಜ಼ ಉಜಾಲಾನು ಮ್ಹಾಡ ಐನ ತ್ಯುನಾ ಉಪ್ಪರ ಐಯು. ತೆನೈಸೊ ತೆ ಮ್ಹಾಡಮಾತು ಎ ಮಾರೊ ಮಯಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಇನೆ ಮಿ ಪಸಂದ ಕರ‍್ಯೊಸ. ಎ ಕವಾನು ಐಕೊ ಕೈನ ಅವಾಜ಼ ಅಯು. ");
INSERT INTO sle_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ಶಿಶ್ಯಾ ಎ ಐಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥೈನ ಉಂದಾ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊಕನ ಐನ ತ್ಯುನೊನೆ ಮುಟ್ಟಿನ, ಉಟೊ ಭುಚ಼್ಕೊ ನಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ತ್ಯುನೆ ಡೊಳಾ ಉಚೈನ ಉಪ್ಪರ ದೆಕ್ತಾಮಾ ಯೆಸುನೆ ಛೊಡಿನ ವರಿ ಕುನ್ನಜ಼ ದಿಕ್ಹ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ತ್ಯುನೆ ತೆ ಡೊಂಗರ ಉತ್ರಿನ ಆತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ, ಆಂ ದರ್ಶನನಾಹುತಿ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಮರಿನ ಜಿವ್ತೊ ಥಯೆ ಲಕ್ಕಾ ಕಿನೆಜ಼ ಕೌ ನೈ ಕೈನ ಆಗನ್ಯಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ತೆಳಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ, ಕ್ರಿಸ್ತ ಆವಾತಿ ಪೈಲಾ ಯಲಿಯಾ ಆವಸ ಕೈನ ಧರ್ಮೊಪದಶಕರಾಲಾ ಕವಾನು ಕಾ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ತೆ ವಾತೆ ಯೆಸು, ಎಲಿಯ ಆವಾನೊ ಛೆ ಕೈನ ಕವಾನು ಕ್ಹರಿ ವ್ಹೈ. ಕ್ಹರಿಮಾಜ಼ ಎಲಿಯ ಐನ ಕ್ಹಾರು ಕರೆಟ್ಟ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ವರಿಬಿ ಮಿ ತುಮೊನೆ ಸು ಕೌಸ, ಕದ್ಯಾಮ, ಎಲಿಯ ಹಮ್ನಾ ಆಯೊಸ. ವರಿಬಿ ತೆ ಕನ್ನ ವ್ಹೈ ಕೈನ ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ಥಯು ನೈ. ಮನಕ್ಹೊ ತ್ಯುನಾ ಮನಸೆ ಆಯಲತಿಮ್ಮ ತಿನೆ ತರಾಸ ಕರ‍್ಯಾ. ತಿನಾನಿಂಗತಜ಼ ತ್ಯುನೆ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ತ್ರಾಸ ದಿವಸ ಕೈನ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ಯೆಸು ಕವಾನು ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಾವಾಲೊ ಯೊಹಾನನಾ ಹುತಿ ಕವಾಡ್ಯೊಸ ಕವಾನು ವ್ಹೈ ಕೈನ ಶಿಶ್ಯಾ ತಿಲದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ವರಿಬಿ ಮನಕ್ಹೊಕನ ಗಯಾ.ಯಕ್ಲೊ ಯೆಸುಕನ ಐನ ತಿನಾ ಕ್ಹಾಮೊ ಉಂದೊ ಪಡಿನ, ");
INSERT INTO sle_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"ಪ್ರಭು ಮಾರಾ ದಿಕ್ರಾನೆ ಮರಗ, ತೆ ಮಡ್ಡ ರೊಗಕ್ಹು ಘನ್ನೊ ತ್ರಾಸ ಖಾವಾಡ್ಯೊಸ. ತೆ ಹಗಲೆಲ ಆಗಮಾ ನೈತೊ ಪಾನಿಮಾ ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ಮಿ ಮಾರಾ ದಿಕ್ರಾನೆ ತಾರಾ ಶಿಷ್ಯಾವೊಕನ ಲಾಯೊ, ತೆನೈಸೊ ತ್ಯುನೆ ತಿನೆ ಅರಾಮ ಕರಾನೆ ಥಯು ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ಯೆಸು, \"ಅಯ್ಯೊ, ಬರೊಕ್ಹೊ ನೈಸೊ ಗ್ಯಾನ ನೈಸೊವಾಲಾವೊನಾ ಬಚ್ಚಾ಼ವೊ, ಹಜು಼ನ ಕೆಕ್ಲಾದಿನ್ನ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌ? ವರಿ ಕೆಕ್ಲಾ ದಿನ್ನ ತುಮೊನೆ ತಡ್ದಿಲ್ಯು? ತೆ ಪಟ್ಟಾನೆ ಮಕನ ಲಿನ ಆವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ತೆ ಪಟ್ಟಾಮಾ ರ‍್ಹಯಲ ಭುತ್ಡಾನೆ ಯೆಸು ಭುಚ್ಕಾಡ್ತಾಮಾ ಭುತ್ಡು ತಿಮಾತು ಗೈ ಪಡ್ಯು. ತಞೆಳಾಮಾಜ಼ ತೆ ಪಟ್ಟಾನೆ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ತೆಳಾಮಾ ಶಿಷ್ಯಾ ಯೆಸು ಯಕ್ಲೊಜ಼ ರ‍್ಹತಾಮಾ ತಿಕನ ಐನ, ತೆ ಪಟ್ಟಾಮಾ ರ‍್ಹಯಲ ಭುತ್ಡಾನೆ ಛೊಡಾವಾನೆ ಹಮೆ ಕೊಶಿಶ ಕರ‍್ಯಾತಬಿ ಹಮಾರಾ ಹತೆ ಕಾ ಥಯು ನೈ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ತೆ ವಾತೆ ಯೆಸು ತುಮೊಮಾ ಬರೊಕ್ಹೊ ನೈ ರ‍್ಹಯಲ ಹುತಿ ತಿನೊ ಕಾರಣ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ತುಮಾರೊ ಬರೊಕ್ಹೊ ಸಾಸವಿ ಕಾಳ ಯಕ್ಲಿ ರ‍್ಹೈ ತಬಿ, ಆ ಡೊಂಗರನೆ ನ್ಯಾಂತೊ ತ್ಯಾ ಜಾ಼ ಕೈನ ತುಮೆ ಕದ್ಯಾತಬಿ ತೆ ಜಾ಼ವಸ. ತುಮಾರಾ ಹತೆ ನೈ ಥಾವಾನು ಕಾಮೊಜ಼ ರ‍್ಹತು ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ಯಕ್ಕಸಲಾ ಶಿಷ್ಯಾ ಗಲಿಲಾಯಾಮಾ ಮಳ್ಯಾ. ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ, \"ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಮನಕ್ಹೊನಾ ಹತ್ಮಾ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ತ್ಯುನೆ ತಿನೆ ಖಲಾಸ ಕರಸ. ವರಿಬಿ ತನ್ವಾ ದಿನ್ಮಾ ತೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಅವಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಕಪೆನೌರ್ಮಿಯೆ ಗಯಾ. ದೆವಾಲಯನೆ ಯಹುದ್ದಿಯೊಕ್ಹೊ ಭು ಭಾಡೊ ವಸುಲಿ ಕರಾಲಾ ಪೆತ್ರಾಕನ ಐನ, ತುಮಾರಾ ಭೊದಕೊ ದೆವಾಲಯನಾ ಭು ಭಾಡೊ ದೆತಾ ನೈಸು ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ತೆ ವಾತೆ ಪೆತ್ರಾ ಹೊ ದಿವಸ. ಕೈನ ಕದ್ಯೊ. ಪಾಚಾ಼ತೊ ಪೆತ್ರಾ ಯೆಸು ರ‍್ಹಯಲ ಘರ್ಮಾ ಗಯೊ. ತೆ ಎ ವಿಚಾರ ಕಾವತಿ ಪೈಲಾಜ಼ ಯೆಸು ತಿನೆ ಭುಲೊಕನಾ ರಾಜಾ಼ ಮನಕ್ಹೊಕಂತು ಘನ್ನಾ ತರಾನಾ ಭು ಭಾಡಾ ಮಾಂಗಿಲಿವಸ. ತೆನೈಸೊ ಭು ಭಾಡೊ ದಿವಾಲಾ ಮನಕ್ಹೊ ಕುನ್ನ ವ್ಹೈ? ರಾಜಾನಾ ದಿಕ್ರಾ ನೈತೊ ಬೆಜಾ಼ ಮನಕ್ಹೊ? ತಾರು ವಿಚಾರ ಸು ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ಪೆತ್ರಾ, \"ಬಿಜಾ಼ ಮನಕ್ಹೊ ಭು ಭಾಡೊ ದಿವಸ. ಕೈನ ಕದ್ಯೊ. ಯೆಸು ಪೆತ್ರಾನೆ, ತಿಮ್ಮ ರ‍್ಹಯುಮ ರಾಜಾ಼ನಾ ದಿಕ್ರಾ ಭು ಭಾಡೊ ದ್ಯುನೈ. ");
INSERT INTO sle_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ವರಿಬಿ ಭು ಭಾಡೊ ಲಿವಾಲಾವೊನೆ ಅಪೆ ಕಾ ಶಿಟ್ಟ ಲಾವಾ ವರಕ್ಹು ಕರಿಯೆ? ತೆ ಭು ಭಾಡೊ ದೆ. ಸಮುದ್ರಮಾ ಗೈನ ಮಚ್ಲಿಯೊ ಧರ್ರ ತುನೆ ಮಳಲ ಪೈಲಾನಿ ಮಚ್ಲಿನು ಮ್ಹೊಡು ಖುಲ್ಲಾ ಕರ, ತಿನಾ ಮ್ಹೊಡಾಮಾ ಭು ಭಾಡೊನೆ ದಿವಾನೆ ಚಾ಼ಯೆ ಥಯಲ ಯಕ್ಕ ಬಿಲ್ಲೊ ದೆಕಶಿ. ತೆ ಲಿನ ಐನ ಭು ಭಾಡೊ ಲಿವಾಲಾನೆ ದೆ.ತಿನಾಹುತಿ ಮಾರೊ ವರಿ ತಾರೊ ಭು ಭಾಡೊ ದಿದಲ ನಿಂಗತ ಥಾವಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ತೆ ಟೈಮ ಶಿಷ್ಯಾ ಯೆಸುಕನ ಐನ, ಪರಲೊಕ ರಾಜ್ಯಮಾ ಕುನ್ನ ಮ್ಹೊಟು ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ಯೆಸು ನ್ಹಾನಾ ಬಚ್ಚಾನೆ ಕ್ಹಾಮೊ ಬಲೈನ ತ್ಯುನಾ ವಚ್ಮಾ ಹುಬ್ರಾಡಿನ, ");
INSERT INTO sle_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ತ್ಯುನೊನೆ ತುಮಾರು ಮನಸ್ಸ ಬದಲಾವಣೆ ಥೈನ ನ್ಹಾನಾ ಬಚ್ಚಾವಿ ನಿಂಗತ ನೈ ಥಯಾಮ ತುಮೆ ಪರಲೊಕ ರಾಜ್ಯಮಾ ಆವಾನು ನೈಕೈನ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ಅಮ್ಮ ರ‍್ಹತಾಮಾ ಕುನ್ನ ಆ ನ್ಹಾನಾ ಬಚ್ಚಾನಿಂಗತ ತಿನೆ ತೆಜ ತಗ್ಗಿಸಿಲಿವಸ ತೆಜ ಪರಲೊಕ ರಾಜ್ಯಮಾ ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ತೆನೈಸೊ ಕುನಬಿ ಮಾರಾ ನಾಮಮಾ ಹವಾ ನ್ಹಾನಾ ಬಚ್ಚಾನೆ ಮಳೈಲಿವಸತೊ ಮನೆಜ ಮಳೈಲಿವಾಲೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ತೆನೈಸೊ ಮಾರಾಮಾ ಭರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಆ ನ್ಹಾನಾವೊಮಾ ಯಕ್ಲಾನೆ ಕುನಬಿ ಅಡ್ಡಿ ಕರ‍್ಯಾಮ ಥ್ಯವಾನೆ ಗರ್ದನೆ ಮ್ಹೊಟೊ ನಾಕಾನೊ ದಗ್ಡಾನೆ ಭಾಂದಿನ ತಿನೆ ಸಮಂದರಮಾ ಡುಬಾಡಿ ಪಡಾನೂ ತಿನೆ ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ಮನಕ್ಹೊನೆ ಪಾಪನೆ ಚಲಾವಾನೂ ಸಂಗತಿಯೊನಾ ಹುತಿ ಮಿ ಆ ಲೊಕನಾ ವಿಷಯಮಾ ದುಖ ಪಡ್ದುಸ. ತೆ ಕೆಳಾಮಾಬಿ ರ‍್ಹವಸ.ತೆನೈಸೊ ತಿನೆ ಕಾರಣ ಥಾವಾನೂ ಮನಕ್ಹನೆ ಘನ್ನು ತ್ರಾಸ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ತಾರೊ ಹತ್ತ ರ‍್ಹವಾದೆ ತಾರೊ ಪಗ್ಗ ರ‍್ಹವಾದೆ ತುನೆ ಪಾಪಮಾ ಕ್ಹಾಪ್ಡಾವರಕ್ಹು ರ‍್ಹಯಾಮ ತಿನೆ ಕತ್ರಿನ ಭಿರಕೈ ಪಡ. ಭಂಬೆ ಹತೊ, ಬೆ ಪಗೊವಾಲೊ ರ‍್ಹೈಯಲವಾಲೊ ನಿತ್ಯ ಆಗಮಾ ಘಾಲಾತಿಜ ಅಂಗನು ಹಿನ ಥಯಲ ನೈತೊ ಲಂಗ್ಡೊ ಥಯಲ ಜಿವನಾಮಾ ಸೆರಾನೂ ತುನೆ ಚೊ಼ಕುವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ತಾರ ಡೊಳಾ ತುನೆ ಪಾಪಮಾ ಕ್ಹಾಪ್ಡಾಯಾರೆ ತಿನೆ ಕಿತ್ತಿನ ಭಿರಕೈ ಪಡ, ಬೆ ಡೊಳಾ ರ‍್ಹಯಲವಾಲೊ ಆಗನಾ ನರಕಮಾ ಘಾಲಾತಿಜ ಯಕ್ಕಜ ಡೊಳಾವಾಲೊ ಥೈನ ಜಿವನಮಾ ಸೆರಾನೂ ತುನೆ ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ಆ ನ್ಹಾನಾವೊಮಾ ಯಕ್ಲೊಬಿ ರ‍ಹೈತಬಿ ತಪ್ಪ ಕರೆವಾಚಿ ದೆಕಿಲಿವೊ. ಕಾ ಕದ್ಯಮ ಪರೊಲೊಕಮಾ ರ‍್ಹವಾನಾ ದುತೊ ಮಾರಾ ಸ್ವರ್ಗನೊ ಬಾನೂ ಮ್ಹೊಡಾನೆ ದೆಕ್ತಾ ರ‍್ಹವಸತೊ ಕೈನ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ಮನಕ್ಹೊನೊ ದಿಕ್ರೊ ಕೆಟ್ಟಿನ ಗಯಲ ಹುಡ್ಕಿನ ರಕ್ಷಾಕರಾನಾ ಹುತಿ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ತುಮಾರಾಮಾ ಯಕ್ಲಾ ಮನಕ್ಹನೆ ಕ್ಹೊ ಬಕ್ರಾ ರ‍್ಹಯಾಮ ತ್ಯುನಾಮಾ ಯಕ್ಕ ಬಕ್ರು ತಪ್ಸಿಲಿನ ಗಯುಸ ಕೈನ ಮ್ಹೆಲ್ಲಿವೊ. ತೆಳಾಮಾ ತುಮೊನೆ ಸು ಅನಸಾವಸ? ತೆ ಉಗ್ರಲ ನೌವದಪರನೌ ಬಕ್ರಾವೊನೆ ಡೊಂಗರಪರ ಛೊಡಿನ ತಪ್ಸಲಿನ ಗಯಲ ತೆ ಯಕ್ಕ ಬಕ್ರಾನೆ ಹುಡ್ಕಿಲಿನ ನೈ ಜಾತಾತೊ? ");
INSERT INTO sle_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ತೆ ತಿನೆ ಮಳ್ಯಾರೆ, ನೈ ತಪ್ಸಿಲಿನ ರ‍್ಹವಾನಾ ನೌವದಪರ ನೌ ಬಕ್ರಾತಿಬಿ ತೆ ಯಕ್ಕ ಬಕ್ರಾನಾಹುತಿ ಘನ್ನೊ ಖುಷಿ ಥೌಸ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ತಿಮ್ಮಜ ಆ ನ್ಹಾನಾವೊಮಾ ಯಕ್ಲೊಬಿ ನಾಶ ಥೈನ ಜಾವಸ ಪರಲೊಕಮಾ ರ‍್ಹವಾನು ತುಮಾರಾ ಬಾನೂ ಚಿತ್ತ ನವೈ. ");
INSERT INTO sle_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ತಾರೊ ಭೈ ತಾರಾ ವಿರುದ್ದ ತಪ್ಪ ಕರ‍್ಯಾರೆ, ಗೈನ ತು ತೆ ಯಕ್ಲೊಜ ರ‍್ಹತಾಮಾ ತಿನೊ ತಿನೆ ಅರು ಥಯು ಕೈನ ತಿಳಸಾ. ತೆ ತಾರಾ ವಾತನೆ ಐಕ್ಯಾಮ ತಾರಾ ಭೈನೆ ತು ಕಮೈಲೆಸಿ. ");
INSERT INTO sle_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ಪಾಚಾತೊ ತೆ ತಾರಿ ವಾತ ನೈ ಐಕ್ಯಾಮ ಬೆ ತನ್ನ ಸಾಕ್ಷಿಯೊನೆ ಮ್ಹೊಡಾಕ್ಹು ಹರಿಯಕ್ಕ ವಾತ ಸ್ಥಿರ ಪಡಸಾನಾಹುತಿ ಯಕ್ಲಾನೆ ನೈತೊ ಬೆಜ಼ನಾವೊನೆ ತಾರಾ ಕ್ಹಾತೆ ಬಲೈಲಿನ ಜಾ. ");
INSERT INTO sle_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ತೆ ತಿನಿ ವಾತ ನೈ ಐಕ್ಯಾಮ ತೆ ವಾತನೆ ಸಭೆಮಾ ಕೆ. ತೆ ಸಭೆನಾ ವಾತೊನೆ ನೈಐಕ್ಯಾಮ ತೆ ತುನೆ ಅನ್ಯ ನಿಂಗತಬಿ ಸುಂಕವಾಲಾ ನಿಂಗತಬಿ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ಭುಲೊಕಮಾ ತುಮೆ ಸುಸು ಭಾಂದ್ಯೊಸಿತೊ ತೆ ಪರಲೊಕಮಾಬಿ ಭಾಂದಲ ರ‍್ಹವಸ. ವರಿ ಭುಲೊಕಮಾ ಸುಸು ಕ್ಹೊಲೊಸಿತೊ ತೆ ಪರಲೊಕಮಾ ಕ್ಹುಲಾವಸ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ತೆನೈಸೊ ತುಮಾರಾಮಾ ಮಾಂಗಿಲಿವಾ ಅಕ್ಲು ಕಯುಬಿ ರ‍್ಹೈತಬಿ ಯಕ್ಕ ವಿಷಯ ಥೈನ ಭುಲೊಕಮಾ ಯಕ್ಕಜ ಮನಸವಾಲಾ ಥಯಾತಬಿ ತೆ ಪರಲೊಕಮಾ ರ‍್ಹವಾನು ಮಾರಾ ಬಾಕ್ಹು ತ್ಯುನೊನೆ ಥಾವಸ ಕೈನ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ಕಾ ಕದ್ಯಾಮ ಬೆಜ಼ನಾ ರ‍್ಹೈನೆಕಾ ತನ್ನಜ಼ನಾ ರ‍್ಹೈನೆಕಾ ಮಾರಾ ನಾಮಂಪರ ಮಳಿನ ಆವಸ ತ್ಯುನಾ ವಚ್ಮಾ಼ ಮಿ ರ‍್ಹೌಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ತೆಳಾಮ ಪೆತ್ರಾ ತಿಕನ ಐನ, ಕರ್ತಾ ಮಾರೊ ಭೈ ಮರಾ ವಿರುದ್ದ ಪಾಪ ಕರ‍್ಯೊಮ ಕೆಕ್ಲಿಸಲಾ ತಿನಿ ಮಾಫ ಕರು? ಖಾತಾ ಸಲಾ ವ್ಹೈಸು? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ಯೆಸು ತಿನೆ, \"ಕ್ಹಾತ ಸಲಾ ಕೈನ ನೈ ಸತ್ತರಪರ ಕ್ಹಾತ ಸಲಾ” ಕೈನ ಮಿ ತುನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ತಿನಾಹುತಿ ಪರಲೊಕ ರಾಜ್ಯ ತಿನಾ ಆಳೊಕ್ಹು ಲೆಕ್ಕೊ ಲಿವಾನಾಹುತಿ ಯಕ್ಕ ರಾಜಾ಼ನೆ ಹೊಲಿಕೆ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ತೆ ಲೆಕ್ಕೊ ಲಿವಾನೆ ಶುರು ಕರ‍್ತಾಮಾ ದಕ್ಹ ಹಜಾ಼ರ ಕ್ಹೊನಾನಾ ಬಿಲ್ಲಾ ದಿವಾಲಾ ಆಳನೆ ತೆ ರಾಜಾ಼ಕನ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ತೆ ಸಾಲಾ ತಿರ್ಸಾನೆ ತಿಕನ ಸುಜ಼ ನೈ ರ‍್ಹಯಲಕ್ಹು ತಿನೊ ಮಾಲಕ ತಿನೆ, ತಿನಿ ಬೈಕೊನೆ, ಬಚ್ಚಾ಼ವೊನೆ ತಿನೆ ರ‍್ಹಯಲ ಕ್ಹಾರು ಇಕ್ಕಿನ ತೆ ಸಾಲಾ ದ್ಯು ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ತೆಳಾಮ ತೆ ಆಳ ಉಂದಾ ಗುಡಗಾ ಘಾಲಿನ ತಿನು ಮಾತು ಝುಕೈನ ಮಾಲಕನೆ, \"ಮಾಲಕ, ಮಾರಾ ಉಪ್ಪರ ತಾಳ್ಮೆ ರ‍್ಹವಾದೆ, ತಾರು ಕ್ಹಾರು ಮಿ ದ್ಯುಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ತೆ ಆಳ ರಾಜೊ ಕನಿಕರ ಪಡಿನ ತಿನೆ ಛೊಡೈನ ತೆ ಸಾಲಾ ಕ್ಹಾರಿ ಮಾಫಕರಿ ಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","\"ಪಾಚ಼ಲ್ತೊ ತೆ ಸೆವಕ ಭಾರೊ ಐನ ತಿನೆ ಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ದಿವಾಲಾ ಯಕ್ಕ ಆಳನೆ ದೆಕಿನ ತಿನೆ ಧರಿನ ನಡ್ಡಿ ಚಿಕಲಿನ, ಮಾರಿ ಸಾಲಾ ಫೆಡ’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","\" ತೆನೈಸೊ ತಿನಾ ಕ್ಹಾತೆ ಆಳಬಿ ಉಂದಾ ಗುಡ್ಗಾ ಘಾಲಿನ ಮಾರಾ ಉಪ್ಪರ ತಾಳ್ಮೆ ರ‍್ಹವಾದೆ ಮಿ ತಿರಸುಸ’ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","\" ತೆನೈಸೊ ತೆ ಒಪ್ಪೆವಾಚಿ ಗೈನ ತೆ ಸಾಲಾ ತಿರಸಾಯೆ ಲಕ್ಕಾ ತಿನೆ ಜೆಲಮಾ ಘಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ತಿನಾ ಕ್ಹಾತೆ ಆಳೊ ಚಾಲಲ ಸಂಗತಿಯೊನೆ ದೆಕಿನ ಘನ್ನು ದುಕ್ಹ ಪಡ್ದಿನ ತಿನಾ ರಾಜಾಕನ ಐನ ಚಾಲಲ ಕ್ಹಾರು ತಿಕನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ತೆಳಾಮಾ ತೆ ರಾಜೊ ತಿನೆ ಬಲೈನ, ‘ಓ, ದುಷ್ಟ ಆಳ, ತು ಮನೆ ಮಾಂಗಿ ಲಿದಲಕ್ಹು ತಾರಿ ಸಾಲಾ ಕ್ಹಾರಿ ಮಾಫ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ಮಿ ತುನೆ ಮರಗಲ ನಿಂಗತ ತುಬಿ ರ‍್ಹತಬಿ ತಾರಾ ಕ್ಹಾತೆ ಆಳನೆ ಮರಗಾನೂ ನ್ಹೊತು? ತಿಮ್ಮ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ರಾಜೊ ಸಿಟ್ಟ ಥೈನ ತಿನೆ ದಿವಾನಿ ಸಾಲಾನೆ ತಿರಸೆಲಕ್ಕಾ ತಿನೆ ಪಿಡಿಸೊನಾ ಹತೊಮಾ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","\" ತುಮಾರಾಮಾ ಹರಯಕ್ಲೊ ತಾರಾ ಭೈನೆ ಮನಸಕ್ಹುಜ ನೈ ಮಾಫ ಕರ‍್ಯಾಮ ಮಾರೊ ಬಾಬಿ ತುಮೊನೆ ತಿಮ್ಮಜ ಕರಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ಅಮ್ಮ ರ‍್ಹತಾಮಾ ಯೆಸು ಆ ವಾತೊ ಮೂಗಸಲಪರ ಗಲಿಲಾಯ ಛೊಡಿನ ಯೊರ್ದಾನ್ ತಳಾನಾ ಹಿಂಗೆ ರ‍್ಹಯಲ ಯುದಾಯ ಪ್ರಾಂತ್ಯನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತಿನಾ ಪಾಚಾ ಗಯಾ, ತೆ ತ್ಯುನೊನೆ ತ್ಯಾಜ಼ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ಪರಿಸಾಯರೊ ಯೆಸುನೆ ಪರಿಕ್ಷಾ ಕರಾನೆ ತಿನಾ ಕ್ಹಾಮಾ ಐನ, ಯಕ್ಲೊ ಕಯಾಬಿ ಯಕ್ಕ ಕಾರಣಕ್ಹು ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿ ಪಡಾನೂ ಶಾಸ್ತ್ರಮಾ ಛೆ ಸು? ಕೈನ ಪುಚ್ತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ತೆ ಉತ್ತರ ದಿನ, ಮನಕ್ಹೊನೆ ಸೃಷ್ಟಿ ಕರಲವಾಲೊ ಅದಿತೊಜ಼ ತ್ಯುನೊನೆ ಗಂಡ ವರಿ ಹೆಣ್ಣ ಕೈನ ಸೃಷ್ಟಿ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ಆ ಕಾರಣಕ್ಹುಜ಼ ದಾಣ್ಗೊ ಯಾ ಬಾನೆ ಛೊಡಿನ ತಿನಿ ಬೈಕೊನೆ ಮಳೈಲಿವಸ. ತ್ಯುನೆ ಭಂಬಿ ಜ಼ನಾ ಯಕ್ಕಜ಼ ಅಂಗ ಥೈನ ರ‍್ಹವಸ ಕವಾನು ತುಮೆ ಓದ್ಯಾಸತೊ?’ ");
INSERT INTO sle_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ಅಮ್ಮ ರ‍್ಹತಾಮಾ ತ್ಯುನೆ ಬೆಜ಼ನಾ ನ್ಹವೈ ಯಕ್ಕ ಅಂಗ ಥಯಾಸ. ತಿನಾಹುತಿ ಕ್ಹುದಾ ಮಳಾಯಲನೆ ಮನಕ್ಹ ಜು಼ದು ಕರು ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆಸುನೆ, ಇಮ್ಮ ರ‍್ಹಯಮ ತಾಲಾಕನು ಪತ್ರ ದಿನ ತಿನೆ ಛೊಡಿಪಡು ಕೈನ ಮೊಶೆ ಕಾ ಆಗನ್ಯಾ ದಿದ್ಯೊ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ, ಮೊಶೆ ತುಮಾರಾ ಮಂಡತನಾಹ್ಉ ತುಮಾರಿಯೊ ಬೈಕೊನೆ ಛೊಡಿಪಡಾನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ತೆನೈಸೊ ಆದಿತು ಇಮ್ಮ ನ್ಹೊತು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ವರಿ ವ್ಯಬಿಚಾರನಾ ಕಾರಣಕ್ಹು ನೈಸೊ ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿನ ವರಿಯಕ್ಲಿನೆ ಹಿವಾ ಕರಿಲಿವಾಲೊ ವ್ಯಬಿಚಾರ ಕರಲ ನಿಂಗತ ವ್ಹೈ; ವರಿ ಮಾಟಿ ಛೊಡಲವಾಲಿನೆ ಹಿವಾ ಕರಿಲಿವಾಲೊ ವ್ಯಬಿಚಾರ ಕರಲ ನಿಂಗತ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಕೌಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ತಿನಾಹುತಿ ಶಿಶ್ಯಾ ಯೆಸುನೆ, ಬೈಕೊನಾ ಕ್ಹಾತೆ ಮಾಟಿನೊ ರಿಸ್ತೊ ಇಮ್ಮ ರ‍್ಹಯಮ ಹಿವಾ ಕರಿಲಿವಾನು ಚೊ಼ಕು ನ್ಹವೈ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ, ಎ ವಾತನೆ ಕ್ಹಾರಾ ಸ್ವಿಕಾರ ನೈ ಕರ‍್ತಾ ತೆನೈಸೊ ಕಿನೆ ತೆ ವರಾ ದಿದಲ ಛೆ ತ್ಯುನೆ ಯಕ್ಕಜ಼ ತಿನೆ ಸ್ವಿಕಾರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ಮಾನಾ ಪೆಟಮಾತಾಜ಼ ನಪುಸಕ ಥೈನ ಹುಟ್ಟಲವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಛೆ ವರಿ ಮನಕ್ಹೊಕ್ಹು ನಪುಸಕ ಥೈಯಲವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಛೆ ವರಿ ಪರಲೊಕ ರಾಜ್ಯನಾಹುತಿ ತ್ಯುನೊನೆ ತ್ಯುನೆಜ಼ ನಪುಸಕ ಕರಿಲಿದಲವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಛೆ. ಎ ಬೊದನೆನೆ ಸ್ವಿಕಾರ ಕರಾಲಾ ಸ್ವಿಕಾರ ಕರಾದೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ದಕ್ಹಾ ಜ಼ನಾ ತ್ಯುನಾ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಯೆಸುಕನ ಬಲೈಲಿನ ಐನ, ತ್ಯುನಾ ಉಪ್ಪರ ತೆ ಹತೊ ಮ್ಹೆಲಿನ ಪ್ರಾರ್ಥನಾ ಕರು ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ತೆನೈಸೊ ಶಿಶ್ಯಾ ತ್ಯುನೊನೆ ಭುಚ್ಕಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ತೆನೈಸೊ ಯೆಸು, ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಛೊಡೊ. ಮಕನ ಆವಾನೆ ತ್ಯುನೊನೆ ಅಡ್ಡ ಕರೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ಪರಲೊಕ ರಾಜ್ಯ ಹೆವಾವೊನುಜ಼ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ವರಿ ತ್ಯುನಾ ಉಪ್ಪರ ಹತ್ತ ಮ್ಹೆಲಿನ ಪಾಚ಼ಲ್ತೊ ತ್ಯಾಂತೊ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ಯಕ್ಕ ಮನಕ್ಹ ಯೆಸುಕನ ಐನ, ಬೊದಕ ಮಿ ಹಮೆಶಾನು ಜ಼ಲಮ ವ್ಹಂದಿಲಿವಾನೆ ಕಯು ಚೊ಼ಕು ಕಾಮ ಕರು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ಯೆಸು ತಿನೆ, ಚೊ಼ಕಾನಾಹುತಿ ಮನೆ ಶಾನೆ ಪುಚ್ಚಶಿ? ಚೊ಼ಕೊ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲೊಜ಼ ವ್ಹೈ. ತೆ ಜ಼ಲಮ ವ್ಹಂದಿಲಿವ ಕೈನ ಕದ್ಯಾಮ ಕ್ಹುದಾನಿ ಆಗನ್ಯಾವೊನೆ ವಿದೆಯ ಥೈನ ಚಾ಼ಲ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ತಿನಾಹುತಿ ತೆ, ತೆ ಕಯಾ ವ್ಹೈ? ಕೈನ ಪುಚ್ತಾಮಾ ಯೆಸು, ನರಹತ್ಯ ಕರು ನೈ, ವ್ಯಬಿಚಾರ ಕರು ನೈ, ಚೊ಼ರಿ ಕರು ನೈ, ಸುಳ್ಳ ಸಾಕ್ಷಿ ಕೌ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ತಾರ ಮಾ ಬಾಪನೆ ಮರ್ಯಾದಿ ದ್ಯು ವರಿ ತಾರಾ ನಿಂಗತಜ಼ ತಾರಾ ಬಾಜು಼ ರ‍್ಹಯಲವಾಲಾನೆ ಮಯಾ ಕರು. ಎಜ಼ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ತೆ ಜಾಂಜಿಮಾನ ಮನಕ್ಹ ತಿನೆ, \"ಎ ಕ್ಹಾರಾವೊನೆ ಮಿ ವಿದೆಯ ಥೈನ ಚಾ಼ಲಿಲಿನ ಗಯೊಸ” ಹಜ಼ುನ ಮಾರಾಮಾ ಸು ಕಮಿ ವಸ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ಯೆಸು ತಿನೆ, ತು ಪರಿಪುರ್ಣ ಥಾವಾನೊ ರ‍್ಹಯೊಮ, ಗೈನ ತುನೆ ರ‍್ಹಯಲ ಕ್ಹಾರು ಇಕ್ಕಿನ, ಗರಿಬೊನೆ ದೆ, ತೆಳಾಮಾ ತುನೆ ಪರಲೊಕಮಾ ಆಸ್ತಿ ರ‍್ಹವಸ. ಪಾಚ಼ಲ್ತೊ ತು ಮಾರಾ ಪಾಚೊ ಆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ತೆನೈಸೊ ತೆ ಜಾಂಜಿಮಾನ ಮನಕ್ಹ ಘನ್ನೊ ಆಸ್ತಿವಾಲೊ ರ‍್ಹಯಲಕ್ಹು ಎ ವಾತ ಐಕಿನ ದುಖಕ್ಹು ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ತೆಳಾಮಾ ಯೆಸು ತಿನಾ ಶಿಶ್ಯಾವೊನೆ, ಆಸ್ತಿ ರ‍್ಹಯಲವಾಲೊ ಪರಲೊಕ ರಾಜ್ಯಮಾ ಜಾ಼ವಾನು ಘನ್ನು ಕಷ್ಟ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ಹಾಂ, ಮಿ ಫರಿನ ತುಮೊನೆ ಕೌಸ ಆಸ್ತಿ ರ‍್ಹಯಲವಾಲೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ವಾತಿ ಹುಂಟ ಖ್ವಯಿನಾ ಡೊಳಾಮಾ ಜಾ಼ವಾನು ಆಸಾನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ಶಿಶ್ಯಾ ಎ ಐಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥೈನ, ಇಮ್ಮ ರ‍್ಹಯಮ ರಕ್ಷಣೆ ವ್ಹಂದಾನೆ ಕಿಕ್ಹು ಥಾವಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ಯೆಸು ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಂವಾ ದೆಕಿನ ಎ ಮನಕ್ಹೊಕ್ಹು ಅಸಾದ್ಯ ವ್ಹೈ. ತೆನೈಸೊ ಕ್ಹುದಾನೆ ಕ್ಹಾರುಜ಼ ಸಾದ್ಯ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ತೆಳಾಮಾ ಪೆತ್ರಾ ಯೆಸುನೆ, \"ಹಮೆ ಕ್ಹಾರು ಛೊಡಿನ ತಾರಾ ಪಾಚಾ ಆಯಾಸ; ಇಕ್ಹು ಹಮೊನೆ ಸು ಮಳಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ಯೆಸು ತ್ಯುನೊನೆ, ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ, ನಯಿ ಸೃಷ್ಟಿಮಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಿ ಮಹಿಮಾನಾ ಸಿಂಹಾಸನಪರ ಬೈಟತಾಮಾ, ಮಾರಾ ಪಾಚಾ಼ ಆಯಲವಾಲಾ ತುಮೆಬಿ ಬಾರಾ ಸಿಂಹಾಸನೊನಾ ಉಪ್ಪರ ಬೈಟಿನ, ಇಸ್ರಾಯೆಲನಾ ಬಾರಾ ಘರ್ದಾನೊನೆ ನ್ಯಾಯ ತಿರಿಸೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ವರಿ ಮಾರಾ ನಾಮನಾ ಹುತಿ ಘರೊನೆ ರ‍್ಹವಾದೆ, ಭಾಯೊನೆ ರ‍್ಹವಾದೆ, ಭೆನೊನೆ ರ‍್ಹವಾದೆ, ಬಾಪನೆ ರ‍್ಹವಾದೆ, ಮಾನೆ ರ‍್ಹವಾದೆ, ಬಚ಼್ಚಾವೊನೆ ರ‍್ಹವಾದೆ, ಜಿಮಿನನೆ ರ‍್ಹವಾದೆ, ಛೊಡಿಪಡಲ ಹರಯಕ್ಲೊ ಕ್ಹಾರು ಖೊ ಯಕ್ಲು ವ್ಹಂದಿಲಿವಸ. ತೆನೈಸೊ ಹಮೆಶಾನಾ ಜ಼ಲಮನೊ ಅದಿಕಾರಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ತೆನೈಸೊ ಪೈಲಾತಾ ರ‍್ಹಯಲವಾಲಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಲಾಸ್ಟನಾ ಥಾವಸ ವರಿ ಲಾಸ್ಟನಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಪೈಲಾನಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ಪರಲೊಕ ರಾಜ್ಯ ತಿನಾ ದ್ರಾಕ್ಷಿನಾ ಮಳಾನೆ ಕುಲಿನಾ ಆಳೊ ಲಾವಾನೆ ಪಾಟೆಜ಼ ಗಯಲ ಯಕ್ಕ ಮಳಾನಾ ಮಾಲಕ ನಿಂಗತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ತೆ ಯಕ್ಕ ದಿನ್ನನೆ ಯಕ್ಕ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಕೈನ ಕುಲಿ ಆಳೊನಾ ಕ್ಹಾತೆ ಒಪ್ಪಂದ ಕರಿಲಿದಲಪರ ತ್ಯುನೊನೆ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾನೆ ವಳಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ತೆ ವರಿ ಕಮ್ಮಸಿಕಮ್ಮ ನೌ ವಸ್ತಾ ಬಾಜ಼ರನಾ ಜ಼ಗಾನೆ ಗೈನ ಕಾಮ ನೈಸೊ ಗಪ್ಪ ಹುಬ್ರಯಲ ಬಿಜಾ಼ ದಕ್ಹಾ ಕುಲಿ ಆಳೊನೆ ದೆಕಿನ, ");
INSERT INTO sle_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ತ್ಯುನೊನೆ, ‘ ತುಮೆಬಿ ಮಾರಾ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾನೆ ಜಾವೊ; ತುಮೊನೆ ಕರೆಟ್ಟ ಪಗಾರ ದ್ಯುಸ’ ಕದ್ಯೊ. ತೆಳಾಮಾ ತ್ಯುನೆ ಕಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ತೆ ವರಿ ಕಮ್ಮಸಿಕಮ್ಮ ಬಾರಾ ವಸ್ತಾ ವರಿ ತನ್ನ ವಸ್ತಾ ಗೈನ ತಿನಾ ನಿಂಗತಜ಼ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ಹಜಿಯಕ್ಕ ಸಲಾ ಕ್ಹಾಂಜ಼ನಾ ಟೈಮ್ಮಾ ಪಾಂಚ ವಸ್ತಾ ತೆ ಗೈನ ಬಿಜಾ ದಕ್ಹಾ ಜ಼ನಾ ಗಪ್ಪ ಹುಬ್ರಯಲ ದೆಕಿನ ತ್ಯುನೊನೆ, ‘ದಿನ ಕ್ಹಾರಿ ಯ್ಹಾ ಗಪ್ಪ ಶ್ಯಾನೆ ಹುಬ್ರಾಯಾಸ?’ ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ತ್ಯುನೆ ತಿನೆ, ‘ಕುನ್ನಜ ಹಮೊನೆ ಕುಲಿನೆ ಬಲಾಯಾ ನೈ’ ಕದ್ಯಾ, ತೆಳಾಮಾ ತೆ ತ್ಯುನೊನೆ, ‘ತುಮೆಬಿ ಮಾರಾ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾನೆ ಜಾ಼ವೊ’ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ಕ್ಹಾಂಜ಼ ಥಯಲ್ಪರ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾನೊ ಮಾಲಕ ತಿನಾ ಮೆಲ್ವಚಾರಕನೆ, ತೆ ಕುಲಿ ಆಳೊನೆ ಬಲೈನ ಲಾಸ್ಟನೆ ಆಯಲವಾಲಾವೊತೊ ಪಸ್ಟ ಆಯಲವಾಲಾವೊ ಲಕ್ಕಾ ಪಗಾರ ದೆ’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ತೆಳಾಮಾ ಕ್ಹಾಂಜೆ ಪಾಂಚ಼ವಾಸ್ತಾ ಐನ ಕಾಮ ಕರಲವಾಲಾ ಆಯಲ್ಪರ, ಹರಯಕ್ಲಾನೆ ಯಕ್ಕಯಕ್ಕ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ಪೈಲಾ ಆಯಲವಾಲಾ ತ್ಯುನೊನೆ, ಹೆಚ್ಕಿ ಮಳಸ ಕೈನ ತಿಳ್ದಿಲಿದ್ಯಾ. ತೆನೈಸೊ ತ್ಯುನೊನೆಬಿ ಯಕ್ಕಯಕ್ಕ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊಜ಼ ಮಳ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ತ್ಯುನೆ ತೆ ಲಿನ ಮಳಾನಾ ಮಾಲಕನಾ ವಿರುದ್ದ ಗುಣಗುಟ್ಟಿನ, ");
INSERT INTO sle_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ಲಾಸ್ಟೆ ಆಯಲ ಇವ್ನೆ ಕ್ಹಾಲಿ ಯಕ್ಕಜ಼ ತಾಸ ಕಾಮ ಕರ‍್ಯಾಸ. ಹಮೆ ಪುರಾದಿನ ತಡಕಾಮಾ ಕಷ್ಟ ಪಡಿನ ಕಾಮ ಕರ‍್ಯಾಸ. ತೆನೈಸೊ ತು ತ್ಯುನೊನೆ ಹಮೊನೆ ಯಕ್ಕಜ಼ ಕರ‍್ಯೊಸ ಸು’ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ತಿನಾಹುತಿ ಮಾಲಕ ತ್ಯುನೊಮಾ ಯಕ್ಲಾನೆ, ‘ಐಕ ದೊಸ್ತ, ಮಿ ತುನೆ ಅನ್ಯಾಯ ಕರ‍್ಯೊ ನತ್ತಿ. ತು ಮಾರಾ ಕ್ಹಾತೆ ಯಕ್ಕ ರುಪ್ಪಾನಾ ಬಿಲಾನೆ ಒಪ್ಪಂದ ಕರಿಲಿದ್ಯಾ ನ್ಹೊತಾ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ತಾರು ಪಗಾರ ತು ಲಿನ ಜಾ಼ ತುನೆ ದಿದಲ ತಿಮ್ಮ ಲಾಸ್ಟೆ ಆಯಲವಾಲಾನೆಬಿ ದಿವಾನು ಮಾರಿ ಪಸಂದ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ಮಾರಿ ಸ್ವಂತ ಆಸ್ತಿನೆ ಮಾರಿ ಆಸ ನಿಂಗತ ಕರಾನೆ ಮನೆ ಅದಿಕಾರ ನತ್ತಿ ಸು? ಮಿ ಚೊ಼ಕೊ ಥಯಲಕ್ಹು ತು ಕಾ ಹೊಚ್ಚಿಗಿಟ್ಟಿ ಘಾಲ್ಯಾಡೊಸ?’ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ಇಮ್ಮ ಲಾಸ್ಟನಾ ಪಸ್ಟ ಥಾವಸ ಪಸ್ಟನಾ ಲಾಸ್ಟ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ಯೆಸು ಯೆರುಸಲೆಮೆ ಜಾ಼ತಾಮಾ ವಾಟಮಾ ಬಾರಾ ಜ಼ನಾ ಶಿಶ್ಯಾವೊನೆ ಕುನ್ನಜ಼ ನೈ ರ‍್ಹಯಲ ಜ಼ಗಾ ಬಲೈಲಿನ ತ್ಯುನೊನೆ, ");
INSERT INTO sle_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ದೆಕೊ ಅಪೆ ಯೆರುಸಲೆಮೆ ಚಾ಼ಲ್ಯಾಸ ವರಿ ಮನಕ್ಹನೊ ದಿಕ್ರಾನೆ ಕ್ಹಾಸ ಯಾಜಕೊನಾ ವರಿ ಶಾಸ್ತ್ರಿಯೊನಾ ಹತೊಮಾ ಒಪ್ಸಿನ ದಿವಸ. ತ್ಯುನೆ ತಿನೆ ಮರಣದಂಡನೆ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ತಿನೆ ಅಪಹಾಸ್ಯ ಕರಾನಾಹುತಿಬಿ ಬಾರಕೊಲಕ್ಹು ಮಾರಾನಾಹುತಿಬಿ ಶಿಲುವಿಪರ ಘಾಲಾನಾಹುತಿಬಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಹತೊಮಾ ಒಪ್ಸಿಪಡಸ. ತೆನೈಸೊ ತೆ ತನ್ನ ದಿನ್ನಮಾ ಜಿವ್ತೊ ಥೈನ ಉಟಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ತೆಳಾಮಾ ಜೆಬೆದಾಯನಾ ಬಚ್ಚಾ಼ವೊನಿ ಮಾ ಥಯಲ ಬಚ್ಚಾ಼ವೊನಾ ಕ್ಹಾತೆ ಯೆಸುಕನ ಐನ; ತಿನೆ ಅಡ್ಡ ಪಡಿನ ಯಕ್ಕ ಉಪಕಾರ ಕರ ಕೈನ ಮಾಂಗಿಲಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ಯೆಸು ತಿನೆ, ತುನೆ ಸು ಚಾ಼ಯೆ? ಕೈನ ಪುಚ್ತಾಮಾ ತೆ ಯೆಸುನೆ, ತಾರಿ ರಾಜ್ಯಮಾ ಮಾರಾ ಎ ಬೆ ಬಚ್ಚಾ಼ವೊಮಾ ಯಕ್ಲೊ ತಾರಾ ಸಿದಾ ಬಗಲಕನ ವರಿ ಯಕ್ಲೊ ರೊಡ್ಡಾ ಬಗಲ ಬೈಟೆ ನಿಂಗತ ಅನುಗ್ರಹ ಕರ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ತಿನಾಹುತಿ ಯೆಸು ಉತ್ತರ ದಿನ, ತುಮೆ ಮಾಂಗಿಲಿವಾನು ಸು ವ್ಹೈ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ಮಿ ಖಾವಾನು ಕಸ್ಟ ತುಮೊನೆ ಖಾವಾನೆ ಥಾವಸ ಸು? ಕೈನ ಪುಚ್ಯೊ. ತ್ಯುನೆ ಯೆಸುನೆ, ಹಮೊಕ್ಹು ಥಾವಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ, ಮಿ ಖಾವಾನು ತ್ರಾಸ ತುಮೆಬಿ ಖಾವೊಶಿ. ತೆನೈಸೊ ಮಾರಾ ಆಜು಼ಬಾಜು಼ಮಾ ಬೈಟಾನೆ ಅನುಗ್ರಹ ಕರಾಲೊ ಮಿ ನ್ಹವೈ, ತೆನೈಸೊ ಮಾರಾ ಬಾಕ್ಹು ತೆ ಕಿನಾಹುತಿ ತಯ್ಯಾರ ಕರಾಯಲ ಛೆ ತ್ಯುನೊನೆಜ಼ ಮಳಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ಉಗ್ರಲ ದಕ್ಹ ಶಿಷ್ಯಾ ತೆ ಐಕಿನ ತೆ ಭಂಬಿ ಜ಼ನಾವೊಪರ ಶಿಟ್ಟ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ ತಿಕನ ಬಲೈಲಿನ ತ್ಯುನೊನೆ, ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಅದಿಪತಿಯೊ ತ್ಯುನಾ ಉಪ್ಪರ ಅದಿಕಾರ ಚ಼ಲಾವಸ ವರಿ ತ್ಯುನಾ ಕ್ಹಾಸ ಅದಿಕಾರಿಯೊ ತ್ಯುನಾ ಉಪ್ಪರ ಜಬರದಸ್ತಿಕ್ಹು ಅದಿಕಾರ ಚ಼ಲಾವಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ತೆನೈಸೊ ತುಮೊಮಾ ತಿಮ್ಮ ರ‍್ಹೌನೈ. ತುಮೊಮಾ ಮ್ಹೊಟೊ ಥೈನ ರ‍್ಹೌಸ ಕವಾಲೊ ತುಮಾರೊ ಸೆವಕ ಥೈನ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ತುಮೊಮಾ ಕ್ಹಾಸ ಥೈ ರ‍್ಹೌಸ ಕವಾಲೊ ತುಮಾರೊ ದಾಸ ಥೈನ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ತೆನೈಸೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸೆವೆ ಕರೈಲಿವಾನಾಹುತಿ ಆಯೊ ನತ್ತಿ, ಸೆವೆ ಕರಾನಾಹುತಿಬಿ, ಘನಾಜ಼ನಾವೊನೆ ಬಿಡುಗಡೆನಾಹುತಿ ತಿನೊ ಜ಼ಲಮ ದಿವಾನೆ ಆಯೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ತ್ಯುನೆ ಯೆರಿಕೊತಾ, ಜಾತಾಟೆಮಾ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತಿನಾ ಪಾಚು ಅಯು. ");
INSERT INTO sle_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ತೆಳಾಮಾ ವಾಟನಾ ಬಾಜು಼ಮ ಬೈಟಲ ಬೆ ಕುಡ್ಡಾ ಯೆಸು ತೆ ವಾಟಮಾತೊ ಚಾ಼ಲ್ಯೊಸ ಕೈನ ಐಕಿನ, ಪ್ರಬು, ದಾವಿದನಾ ದಿಕ್ರಾ ಹಮೊನೆ ಮರಗ ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ತೆನೈಸೊ ತೆ ಗುಂಪಮಾ ರ‍್ಹಯಲವಾಲಾ, ಗಪ್ಪ ರ‍್ಹವೊ ಕೈನ ತ್ಯುನೊನೆ ಭುಚ್ಕಾಡ್ಯಾ. ತ್ಯುನೆತಬಿ, ಪ್ರಭು, ದಾವಿದನಾ ದಿಕ್ರಾ, ಹಮೊನೆ ಮರಗ ಕೈನ ಜೊ಼ರ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ತೆಳಾಮಾ ಯೆಸು ಹುಬ್ರೈನ ತ್ಯುನೊನೆ ಬಲೈನ, ಮಿ ತುಮೊನೆ ಸು ಕರೊ ಕವೊಶಿ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ತ್ಯುನೆ, ಪ್ರಭು, ಹಮಾರಾ ಡೊಳಾ ದಿಕ್ಹಾ ವರಕ್ಹು ಕರ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ತೆಳಾಮಾ ಯೆಸು ಮರ್ಗಿನ, ತ್ಯುನಾ ಡೊಳಾ ಮುಟ್ಯೊ ತೆಳಾಮಾಜ಼ ತ್ಯುನೊನೆ ಡೊಳಾ ದಿಕ್ಹ್ಯಾ ತೆಳಾಮಾತಾಜ಼ ತ್ಯುನೆ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಯೆರುಸಲೆಮನಾ ನಜಿಕ ಗೈನ ಒಲಿವ ತೆಲನಾ ಝಾಡೊನಾ ಡೊಂಗರನಾ ಬಾಜು಼ಮಾ ರ‍್ಹಯಲ ಬೆತ್ಫೆನೆ ಆಯಲ್ಪರ ");
INSERT INTO sle_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ಯೆಸು ಬೆ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನ, ತುಮಾರಾ ಕ್ಹಾಮಾರ‍್ಹಯಲ ಖೆಡಾ ಗಾಮೊನೆ ಜಾ಼ವೊ; ಗಯಲ ಬಬ್ಬರ ತ್ಯಾ ಭಾಂದಲ ಗದ್ಡಾನೆ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಗದ್ಡಾನು ಬಚ಼್ಚು ದೆಕ್ಯೊಶಿ; ತ್ಯುನೊನೆ ಛೊಡೈನ ಮಕನ ಲಿನ ಆವೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ಕುನ್ನತಬಿ ತುಮೊನೆ ಸುತಬಿ ಕದ್ಯಾಮ, ‘ಎ ಹಮಾರಾ ಪ್ರಭುನೆ ಚಾ಼ಯೆ ಥಯಾಸ’ ಕೈನ ತುಮೆ ಕವೊ; ತೆ ತೆಳಾಮಾಜ಼ ತ್ಯುನೊನೆ ಛೊಡಿನ ದಿವಸ ಕೈನ ವಳಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ಪ್ರವಾದಿ ಕದಲ ವಾತ ಪುರಾ ಥಾವಾನಾಹುತಿ ಇಮ್ಮ ಥಯು; ತೆ ಸುವೈ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ಚಿಯೊನ ದಿಕ್ರಿ, ದೆಕ, ತಾರೊ ರಾಜೊ಼ ತುಕನ ಆವಾಡ್ಯೊಸ; ತೆ ಚೊಕಿ ಗುಣಾ ರ‍್ಹಯಲವಾಲೊ ಥೈನ ಗದ್ಡಾನೆ, ಹೊ ಗದ್ಡಾನಾ ಬಚ್ಚಾ಼ಪರ ಚ಼ಡಿನ ಆವಾಡ್ಯೊಸ ಕೈನ ಕವೊ ಕವಾನುಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ತೆಳಾಮಾ ಶಿಶ್ಯಾ ಗೈನ ಯೆಸು ತ್ಯುನೊನೆ ಅಪ್ಪಣೆ ದಿದಲ ತಿಮ್ಮ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ಗದ್ಡಾನೆ ವರಿ ತಿನಾ ಬಚ್ಚಾ಼ನೆ ಲಿನ ಐನ ತ್ಯುನಾ ಉಪ್ಪರ ತ್ಯುನಾ ವಣ್ಣಾ ಘಾಲಲ್ಪರ ಯೆಸು ಚ಼ಡಿನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ತೆಳಾಮಾ ಮನ್ಹೊನಾ ಗುಂಪಮಾ ಘನಾ ಜ಼ನಾ ತ್ಯುನಾ ವಣ್ಣಾ ವಾಟಮಾ ವಚ್ಚಾ಼ಯಾ ಬಿಜಾ ದಕ್ಹಾಜ಼ನಾ ಝಾಡೊಕ್ಹು ಟೊಂಗಿಯೊ ವಾಟಮಾ ವಚ್ಚಾ಼ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ತಿನಾ ಅಗಾ ಪಾಚಾ಼ ಜಾವಾಲಾ ಮನಕ್ಹೊ, ದಾವಿದನಾ ದಿಕ್ರಾ ಹೊಸನ್ನಾ! ಕರ್ತಾನಾ ನಾಮಪರ ಆವಾಲೊ ಧನ್ಯ ವ್ಹೈ! ಉಪ್ಪರಲ್ಯಾ ಲೊಕಮಾ ಹೊಸನ್ನಾ ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ಯೆಸು ಯೆರುಸಲೆಮನಾ ಮ್ಹೈ ಜಾ಼ತಾಮಾ ಗಾಮಾ ಕ್ಹಾರಾ ಗದ್ದಲ ಥೈನ, ಆ ಕುನ್ನ ವ್ಹೈ? ಪುಚ್ಯಾ಼. ");
INSERT INTO sle_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ತೆನೈಸೊ ತೆ ಗುಂಪನಾ ಮನಕ್ಹೊ, ಎ ಗಲಿಲಾಯನೊ ನಜರೆತನೊ ಯೆಸು ವ್ಹೈ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ಪಾಚಾ಼ತೊ ಯೆಸು ದೆವಾಲಯಮಾ ಗೈನ ತಿಮಾ ಇಕ್ಕಾನು ಲಿವಾಲಾನೆಬಿ ಕ್ಹಾರಾವೊನೆ ಭಾರೊ ಘಾಲಿನ ದೊಕ್ಡಾ ಬದ್ಲಿ ಕರಾನು ಟೆಬಲ ಕ್ಹಬುತರನಾ ಪೆಟಗಿಯೊನೆ ಢಕ್ಲಿ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ತೆ ತ್ಯುನೊನೆ, ‘ಮಾರು ಘರ ಪ್ರಾರ್ಥಾನು ಘರ ಥಯುಸ. ಕೈನ ಬರದಲ ಛೆ; ತೆನೈಸೊ ತುಮೆ ತಿನೆ ಚೊ಼ಟ್ಟಾವೊನು ಘರ ಕರಾಡ್ಯಾಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ತೆಳಾಮಾ ತ್ಯಾ ರ‍್ಹಯಲ ಕುಡ್ಡಾ ಲಂಗ್ಡಾ ದೆವಾಲಯಮಾ ತೆ ಆತಾಮಾ ತ್ಯುನೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ತೆನೈಸೊ ಕ್ಹಾಸ ಯಾಜಕೊ ಶಾಸ್ರ್ತಿಯೊ ತೆ ಕರಲ ಆಶ್ಚರ್ಯ ಕರಲ ಕಾಮೊ ದೆಕಿನ ವರಿ ದಾವಿದನಾ ದಿಕ್ರಾ ಹೊಸನ್ನ ಕೈನ ಪಟ್ಟಾ ವದ್ರಾನು ದೆಕಿನ ಸಿಟ್ಟ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ತಿನೆ , ಅವ್ನೆ ಕವಾನು ಐಕಾಡ್ಯೊಸು ಕೈನ ಕತಾಮಾ ಯೆಸು, ಹಾ, ಐಕಾಡ್ಯೊಸ, ತೆನೈಸೊ ‘ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ನಾ ಮ್ಹೊಡಾಕ್ಹು ದುದ್ದ ಪಿವಾನಾ ಬಚ್ಚಾ಼ನಾ ಮ್ಹೊಡಾಕ್ಹು ತು ಸ್ತೊತ್ರಾನೆ ತಯ್ಯಾರ ಕರಸಿ’ ಕವಾನು ತುಮೆ ಕೆಳಾಮಾಬಿ ಓದ್ಯಾವಸೆತೊ? ಕೈನ ಪುಚ್ಯೊ಼. ");
INSERT INTO sle_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ತೆಳಾಮಾ ತ್ಯುನೊನೆ ಛೊಡಿನ ಗಾಮತೊ ಗೈನ ಬೆಥನ್ಯಾನೆ ಐನ ತ್ಯಾ ರಾತೆ ಕ್ಹುರಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ಪಾಟೆ ಯೆಸು ಗಾಮೆ ಗೈನ ಆತಾಮಾ ಭುಕ್ಕ ಲಾಗಿತಿ. ");
INSERT INTO sle_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ವಾಟಮಾ ಯಕ್ಕ ಅಂಜು಼ರನಾ ಝಾಡನೆ ದೆಕಿನ ತಿನಾ ಕ್ಹಾಮೊ ಗೈನ ತಿಮಾ ಕ್ಹಾಲಿ ಪಾಲೊ ರ‍್ಹವಾನು ದೆಕಿನ ತಿನೆ, ಅನಾಪರ ತಾರಾಮಾ ಕೆಳಾಮಾಜ ಫಲ ದಿಯುಜ಼ ನೈ ಕೈನ ಕದ್ಯೊ. ತೆ ಟೆಮಾ ತೆ ಅಂಜುರನು ಝಾಡ ಕ್ಹುಕ್ಹೈ ಗಯು. ");
INSERT INTO sle_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ಶಿಷ್ಯಾ ತೆ ದೆಕಿನ ಘಾಬ್ರಾ ಥೈನ, ಆ ಅಂಜುರನು ಝಾಡ ಯಕ್ಕಜ಼ ಟೆಮಾ ಕ್ಹುಕ್ಹೈ ಗಯುತೊ ಕೈನ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ತೆನೈಸೊ ಯೆಸು, ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ತುಮೆ ಸಂಶೆಕರೆವಾಚಿ಼ ನಂಬ್ಯಾಮ ಆ ಅಂಜುರನು ಝಾಡನೆ ಕರಲ ನಿಂಗತ ತುಮೆಬಿ ಕರೊಶಿ ತೆನೈಸೊ ಎ ಡೊಂಗರನೆ ‘ ತು ಕಿತ್ತಿಲಿನ ಗೈನ ಸಮಂದರಮಾ ಪಡ’ ಕೈನ ಕದ್ಯಾಮ ತೆಬಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ತುಮೆ ಭರೊಕ್ಹೊ ಕರಿನ ಪ್ರರ್ಥಾನಾಮಾ ಸುಸು ಮಾಂಗಿಲಿವೊಸಿ ತೆ ಕ್ಹಾರು ಹೊಂದಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಯೆಸು ದೆವಾಲಯಮಾ ಐನ ಭೊದನೆ ಕರ್ತಾಮಾ ಖಾಸ ಯಾಜಕೊ ಮನಕ್ಹೊನಾ ಮ್ಹೊಟಾ ತಿಕನ ಐನ, ತುಮೆ ಕಯಾ ಅದಿಕಾರಕ್ಹು ಎ ಕ್ಹಾರು ಕರಾಡ್ಯೊಸ? ಆ ಅದಿಕಾರ ತುನೆ ದಿದಲವಾಲೊ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ಯೆಸು ತ್ಯುನೊನೆ ಕದಲ ಸುವೈ ಕದ್ಯಾಮ, ಮಿಬಿ ತುಮೊನೆ ಯಕ್ಕ ಪ್ರಶ್ನೆ ಪುಚ್ಚು಼ಸ; ತಿನೆ ತುಮೆ ಮನೆ ಉತ್ತರ ದಿದ್ಯಾಮ ತೆಳಾಮಾ ಮಿ ಕಯು ಅದಿಕಾರಕ್ಹು ಎ ಕರುಸ ಕೈನ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ಬಾಪ್ತಿಸ್ಮಾ ದಿವಾನು ಅದಿಕಾರ ಯೊಹಾನನೆ ಕಿಜಾ಼ತು ಐಯುತು ಪರಲೊಕತು ನೈತೊ ಮನಕ್ಹೊಕ್ಹು? ಕದ್ಯೊ. ತೆಳಾಮಾ ತ್ಯುನೆ, ಪರಲೊಕತು ಐಯುಸ ಕೈನ ಹಮೆ ಕದ್ಯಾಮ, ‘ತಿಮ್ಮ ರ‍್ಹಯಾಮ ತುಮೆ ತಿನೆ ಕಾ ನಂಬ್ಯಾ ನತ್ತಿ’ ಕೈನ ಅಪೊನೆ ಪುಚ್ಚಸ; ");
INSERT INTO sle_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","\"ಮನಕ್ಹೊಕಂತು ಐಯುಸ ಕೈನ ಕದ್ಯಾಮ, ಅಪೊನೆ ಮನಕ್ಹೊನೊ ಭೆ ಛೆ. ಯೊಹಾನ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಮನಕ್ಹೊ ವಪ್ಪಿಲಿದ್ಯಾಸ್ತೊ ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ, ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ಯೆಸುನೆ ಕದ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಕೈ ಅದಿಕಾರಕ್ಹು ಮಿ ಎ ಕ್ಹಾರು ಕರಾಡ್ಯೊಸ ಕೈನ ಮಿಬಿ ತುಮೊನೆ ನೈ ಕತೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ತೆನೈಸೊ ತುಮೊನೆ ಕಿಮ ದಿಕ್ಹಸ? ಯಕ್ಕ ಮನಕ್ಹನೆ ಬೆ ಬಚ್ಚಾ಼ ವ್ಹತಾ. ತೆ ಪಸ್ಟಲ್ಯಾ ಬಚ್ಚಾ಼ ಕೈನ ಐನ, ದಿಕ್ರಾ ತು ಆಜ಼ನಾ ದಿನ್ನೆ ಗೈನ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾಮಾ ಕಾಮ ಕರ, ಕೈನ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ತೆಳಾಮಾ ತೆ ಪಟ್ಟೊ, , ಮಿನೈ ಜಾ಼ತೊ ಕೈನ ಕದ್ಯೊತುಬಿ ವರಿ ತಿನು ಮನಸ ಬದಲಿ ಕರ್ಲಿನ ಮಳಾಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ತೆಳಾಮಾ ತಿನಾ ಬಿಜೆಕ್ಲಾ ದಿಕ್ರಾಕನ ಐನ ತೆಜ಼ ವಾತ ಕತಾಮಾ, ಬಾ ಮಿ ಜೌ಼ಸ, ಕೈನ ಕದ್ಯೊತುಬಿ ಗಯೊಜ಼ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ಎ ಭಂಬಿ ಜ಼ನಾವೊಮಾ ಬಾಪನಿ ವಾತನೆ ಕುನ್ನ ವಿಧೆಯ ಥಯು? ಕೈನ ಪುಚ್ತಾ಼ಮಾ ತ್ಯುನೆ ಪಸ್ಟಲ್ಯೊ ಕೈನ ಕದ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಸುಂಕವಾಲಾ, ವೈಭಿಚಾರ ಕರಾಲಿಯೊ ತುಮೊತಿ ಪೈಲಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ವಸ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ಕಾ ಕದ್ಯಾಮ ಯೊಹಾನ ಕ್ಹರಿನಿ ವಾಟ ದೆಕಾಡಾಲೊ ಥೈನ ತುಮೊಕನ ಆಯೊ. ತುಮೆ ತಿನೆ ನಂಬ್ಯಾ ನೈ. ಸುಂಕವಾಲಾ ವರಿ ವೈಭಿಚಾರ ಕರಾಲಿಯೊ ತಿನೆ ನಂಬಿಯೊ; ತುಮೆ ಎ ಕ್ಹಾರು ದೆಕ್ಯಾತಬಿ ಪಶ್ಚಾತಾಪ ಪಡ್ಯಾ ನೈ, ತಿಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ಬಿಜಿ಼ ಸಾಮ್ಯ ಐಕೊ, ಯಕ್ಕ ಘರ್ನೊ ಮಾಲಕ ವ್ಹತ್ತೊ. ತಿನೊ ಯಕ್ಕ ದ್ರಾಕ್ಷಿಯೊನೊ ಮಳೊ ವ್ಹತೊ. ತಿನಾ ಸುತ್ತೆ ಬೆಲಿ ಭಾಂದಿನ, ತಿಮಾ ದ್ರಾಕ್ಷಯೊನೊ ಘಾಣೊ ಘಾಲಿನ, ಕೈದಾನು ಝೊಪ್ಡು ಭಾಂದಿನ, ತೆ ದ್ರಾಕ್ಷಯೊನೊ ಮಳೊ ಬಿಜಾ಼ವೊನೆ ವತ್ತಿ ಘಾಲಿನ ತೆ ಬಿಜಾ಼ ದೆಶೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ಫಲ್ಲ ದಿವಾನೊ ಟೈಮ ನಜಿಕ ಆತಾಮಾ ತೆ ಮಳಾನೊ ಮಾಲಕ ತಿನೊ ವಾಟೊ ಲಿವಾನಾ ಹುತಿ ತೆ ವತ್ತಿ ಘಲ್ಲಿದಲವಾಲಾವೊಕನ ತಿನಾ ಆಳೊನೆ ಮೊಕಲ್ತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ತೆ ವತ್ತಿ ಘಾಲ್ಲಿದಲವಾಲಾ ತೆ ಮೊಕ್ಲಲ ಆಳೊಮಾನಾ ಯಕ್ಲಾನೆ ಮಾರ‍್ಯಾ, ಯಕ್ಲಾನೆ ಕತ್ರಿಪಾಡ್ಯಾ, ಯಕ್ಲಾನೆ ದಗ್ಡಾ ಮಾರಿನ ಖಲಾಸ ಕರಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ತೆ ಮಾಲಕ ವರಿಯಕ್ಕೆಬ ಹಜು಼ನ ಘನ್ನಾ ಜ಼ನಾವೊನೆ ಮೊಕಲ್ತಾಮಾ ತ್ಯುನೆ ತ್ಯುನೊನೆಬಿ ತಿಮ್ಮಜ಼ ಕರಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ಲಾಸ್ಟಮಾ ತಿನಾ ದಿಕ್ರಾನೆತಬಿ ಮೊಕಲ್ಯೊಮ ತಿನೆತಬಿ ಮರಯಾದಿ ದಿವಸ ಕೈನ ತಿನಾ ದಿಕ್ರಾನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ತೆನೈಸೊ ತೆ ಮಳೊ ವತ್ತಿ ಘಾಲ್ಲಿದವಾಲಾ ತಿನಾ ದಿಕ್ರಾನೆ ದೆಕಿನ, ಎಜ಼ ಉತ್ತರಾಧಿಕಾರಿ ವ್ಹೈ ಕೈನ, ಆವೊ ಇನೆಜ಼ ಖಲಾಸ ಕರಿಪಾಡಿಯೆ, ಇನೊ ರ‍್ಹಯಲ ಕ್ಹಾರುಜ಼ ಅಪೆ ಲಿಪಾಡಿಯೆ. ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ತಿನೆ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾಮಾತಾ ಢಕ್ಲಿನ ಕಲಾಸ ಕರಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ತಿಮ ರ‍್ಹಯುಮ ದ್ರಾಕ್ಷಿಯೊನೊ ಮಳಾನಾ ಮಾಲಕ ಆತಾಮಾ ತೆ ವತ್ತಿ ಘಾಲ್ಲಿದಲವಾಲಾವೊನೆ ಸು? ಕರಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ತ್ಯುನೆ ತಿನೆ, ತೆ ಕೆಟ್ಟವಾಲಾವೊನೆ ವರಿ ಕ್ರುರ ತನಾಕ್ಹು ಖಲಾಸ ಕರಿನ ಕರೆಟ್ಟ ಟೈಮ್ಮಾ ಫಲ್ಲಮಾ ವಾಟೊ ದಿವಾಲಾನೆ ಬಿಜಾ಼ ವತ್ತಿವಾಲಾವೊನೆ ತೆ ಮಳೊ ವತ್ತಿ ಘಾಲಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ಯೆಸು ತ್ಯುನೊನೆ, ಘರ ಭಾಂದಾಲಾ ನಕೊ ಕೈನ ಠುಕ್ರಾಯಲ ದಗ್ಡೊಜ಼ ಖಾಸ ಮುಲಾನೊ ದಗ್ಡೊ ಥಯೊ; ಎ ಕರ್ತಾಕ್ಹುಜ಼ ಥಯು. ವರಿ ತೆ ಕ್ಹಾರು ಅಪ್ನಾ ಡೊಳಾನೆ ಆಶ್ಚರ್ಯನಿಂಗತ ದಿಕ್ಹಸ ಕವಾನು ತುಮೆ ಧರ್ಮಶಾಸ್ತ್ರಮಾ ಕೆಳಾಮಾಬಿ ಒದ್ಯಾ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ತಿನಾ ಹುತಿ ಕ್ಹುದಾನು ರಾಜ್ಯ ತುಮೊಮಾತು ಕಾಡಿನ ತಿನೆ ಫಲ್ಲ ದಿವಾಲಾ ಮನಕ್ಹೊನೆ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ಎದಗ್ಡಾಪರ ಪಡಾಲೊ ತುಕ್ಡಾ ತುಕ್ಡಾ ಥಾವಸ; ಎ ದಗ್ಡೊ ಕಿಪರ ಪಡಸ ತೆ ತ್ಯುನೊನೆ ಪುಡಿ ಪುಡಿ ಕರಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ಖಾಸ ಯಾಜಕೊ ಫರಿಸಾಯರೊ ತೆ ಕದಲ ಸಾಮ್ಯ ಐಕಿನ ತ್ಯುನಾಹುತಿಜ಼ ಕವಾಡ್ಯೊಸ ಕೈನ ತಿಳದಿಲಿನ ಯೆಸುನೆ ಬಂದಿ ಕರಾನಾ ಹುತಿ ಟೈಮ ದೆಕಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ತೆನೈಸೊ ತ್ಯುನೆ ತಿನೆ ಬಂದಿ ಕರಾನಾಹುತಿ ಕೊಶಿಶ ಕರ‍್ಯಾತುಬಿ ಮನಕ್ಹೊ ತಿನೆ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ತಿಳದಿಲಿದಲ ಹುತಿ ಮನಕ್ಹೊನಾಹುತಿ ಭುಚಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ಯೆಸು ವರಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬೊಲ್ತೊ ಸಾಮ್ಯ ಲಿನ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ಸ್ವರ್ಗನೊ ರಾಜ್ಯ ತಿನಾ ದಿಕ್ರಾನಾ ಹಿವಾನು ಖಾವಾನು ಅನ್ನ ತಯ್ಯಾರ ಕರಲ ಯಕ್ಕ ರಾಜಾ಼ನೆ ಹೊಲಿಕೆ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ತೆ ಹಿವಾಮಾ ಆಯಲವಾಲಾವೊನೆ ಬಲಾವಾನಾಹುತಿ ತಿನಾ ಆಳೊನೆ ಮೊಕಲ್ಯೊ, ತೆಕ್ಲು ರ‍್ಹೈತಬಿ ತ್ಯುನೊನೆ ಆವಾನೆ ಮನಸ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ತೆ ರಾಜೊ಼ ಬಿಜಾ಼ ಆಳೊನೆ ಬಲೈನ, ತುಮೆ ಹಿವಾನು ಅನ್ನ ಖಾವಾನೆ ಆಯಲ ಮನಕ್ಹೊಕನ ಗೈನ ದೆಕೊ, ಖಾವಾನು ಅನ್ನ ತಯ್ಯಾರ ಥಯುಸ; ಮಾರಿಯೊ ಬೈಲೊ, ಚ಼ರಬಿಯೊ ರ‍್ಹಯಲ ಹೊರಿಯೊನೆ ಕತರ‍್ಯೊಸ; ಕ್ಹಾರುಜ಼ ತಯ್ಯಾರ ಛೆ; ಹಿವಾನು ಅನ್ನ ಖಾವಾನೆ ಆವೊ ಕೈನ ತ್ಯುನೊನೆ ಕವೊ ಕೈನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ವರಿಬಿ ತ್ಯುನೆ ಮಿ ಬಲಾಯಲನೆ ಠುಕರೈನ ಯಕ್ಲೊ ತಿನಾ ಖೆತ್ರೆ ಯಕ್ಲೊ ವ್ಯಾಪಾರ ಕರಾನಾ ಹುತಿ ಗೈ ಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ಉಗ್ರಲವಾಲಾ ತಿನಾ ಆಳೊನೆ ಧರಿನ ಮರಿಯಾದಿ ಕಾಡಿನ ಖಲಾಸ ಕರಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ರಾಜೊ಼ ಎ ಕ್ಹಾರು ಐಕಿನ, ತಿನಾ ಸೈನಿಕೊನೆ ಮೊಕ್ಲಿನ ಖಲಾಸ ಕರಲವಾಲಾವೊನೆ ತ್ಯುನೆ ಖಲಾಸ ಕರಿನ ತ್ಯುನು ಗಾಮ ಬಾಳಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ತೆಳಾಮಾ ತಿನಾ ಆಳೊನೆ, ಹಿವಾನು ಅನ್ನ ತಯ್ಯಾರ ಛೆ ತೆನೈಸೊ ತೆ ಅನ್ನ ಖಾವಾನೆ ತೆ ಮನಕ್ಹೊ ಯಗ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ತಿನಾಹುತಿ ತುಮೆ ಹಮ್ನಾ ಖಾಸ ರ‍್ಹಯಲ ರಸ್ತೆ ಗೈನ ದಿಕ್ಹಲ ದಿಕ್ಹಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಹಿವಾನು ರ‍್ಹಯಲ ಅನ್ನ ಖಾವಾನೆ ಬಲಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ತಿನಾನಿಂಗತಜ಼ ಆಳೊ ಗೈನ ಕೆಟ್ಟ ರ‍್ಹೈನೆಕಾ ಚೊ಼ಕಾ ರ‍್ಹೈನೆಕಾ ಕಿನೆಜ಼ ದೆಕ್ಯಾವಾಚಿ. ಕ್ಹಾರಾವೊನೆ ಮಳೈನ ಕ್ಹಾರಾವೊನೆ ಬಲೈಲಾಯಾ. ಇನಾನಿಂಗ ಹಿವಾನು ಘರ ಮನಕ್ಹೊಕ್ಹು ಭರಿಗಯು. ");
INSERT INTO sle_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ತೆಳಾಮಾ ರಾಜೊ಼ ಹಿವಾಮಾ ಆಯಲ ಮನಕ್ಹೊನೆ ದೆಕಾನಾಹುತಿ ಮ್ಹೈ ಆಯೊ, ಹಿವಾಮಾ ತಿನಾ ತಕ್ಕ ವಣ್ಣಾ ನೈ ಘಲ್ಲಿದಲ ಯಕ್ಕ ಮನಕ್ಹನೆ ರಾಜೊ಼ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ತಿನೆ ದೊಸ್ತ’ ಹಿವಾನಾ ಚೊ಼ಕಾ ವಣ್ಣಾ ನೈಸೊ ತು ಕಿಮ್ಮ ಮ್ಹೈ ಆಯೊ?, ಕೈ ಪುಚ್ತಾ಼ಮಾ ತೆ ಗಪ್ಪಜ಼ ವ್ಹತೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ತೆಳಾಮಾ ರಾಜೊ಼ ಆಳೊನೆ ಬಲೈನ, ತಿನಾ ಹತೊ ಪಗೊ ಭಾಂದಿನ ಭಾರಾ ಅಂದಾರಮಾ ನಾಕೊ ಕೈನ ಕದ್ಯೊ. ತ್ಯಾ ರವಾನು ಕಟ್ಟ ಕಟ್ಟ ದಾತೊ ಖಾವಾನು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ಇಮ್ಮ ಬಲಾಯವಾಲಾವೊಮಾ ಘನ್ನ ಜ಼ನಾ, ಇನಿಲಿದಲವಾಲಾ ದಕ್ಹಾಜ಼ ಜ಼ನಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ತೆ ಥಯಲ್ಪರ ಫರಿಸಾಯರೊ ಗೈನ ಯೆಸುನೆ ವಾತೊಮಾ ಕಿಮ್ಮ ಧರಿಯೆ ಕೈನ ವಿಚಾರ ಕರ್ತಾ ");
INSERT INTO sle_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ತಿಕನ ತ್ಯುನಾ ಶಿಷ್ಯಾವೊಎ ಯಹುದ್ದಿಯೊನಾ ಕ್ಹಾತೆ ಮಳೈನ ಮೊಕಲ್ಯಾ. ತ್ಯುನೆ ಯೆಸುನೆ, ಗುರು, ತು ಕ್ಹರಿನೊ ವ್ಹೈ ಕ್ಹುದಾನಿ ವಾಟ ದೆಕಾಡಾಲೊ ವ್ಹೈ, ಕಿನೆಜ಼ ಭುಚಕ್ತೊ ನೈ; ತು ಮನಕ್ಹೊನಾ ಮ್ಹೊಡಾ ದೆಕಿನ ಬೊಲಾಲೊ ನ್ಹವೈ ಕೈ ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ಇಮ್ಮ ರ‍್ಹಯುಮ ಕೈಸರನೆ ಭು ಭಾಡೊ ದಿವಾನು ಪದ್ದತ ವ್ಹೈ ಸು?ತುನೆ ಕಿಮ್ಮ ದಿಕ್ಹಸ? ಹಮೊನೆ ಕೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ಯೆಸು ತ್ಯುನೆ ಕವಾನು ಕ್ಹಾರು ಕೆಟ್ಟ ತಿಳದಿಲಿನ ಕಪಟಿಯೊ, ಮನೆ ಕಾ ಪರಿಕ್ಷ್ಯಾ ಕರಾಡ್ಯಾಸ? ");
INSERT INTO sle_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ಟ್ಯಾಕ್ಸನೆ ದಿವಾನೊ ಬಿಲ್ಲೊ ಮನೆ ದೆಕಾಡೊ ಕತಾಮಾ ತ್ಯುನೆ ತಿನೆ ಯಕ್ಕ ಬಿಲ್ಲೊ ಲೈನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ತೆಳಾಮಾ ತೆ, ಬಿಲ್ಲಾನೊ ಶಿಕ್ಕೊ ಕಿನೊ ವ್ಹೈ? ಕೈನ ಪುಚ಼ಲ ಹುತಿ ");
INSERT INTO sle_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ತ್ಯುನೆ, ಕೈಸರನೊ ವ್ಹೈ ಖಯನ ಕದ್ಯಾ. ತೆಳಾಮಾ ತೆ ತ್ಯುನೊನೆ, ಕೈಸರನೆ ರ‍್ಹಯಲ ಕೈಸರನೆ ದಿವೊ; ಕ್ಹುದಾನು ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ದಿವೊ.ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ತ್ಯುನೆ ಎ ವಾತೊ ಐಕಿನ ಘಾಬ್ರಾ ಥೈನ ತಿಕಂತಾ ಗೈಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ತೆಜ಼ ದಿನ್ಮಾ ಪುನರುತ್ಥಾನ ನತ್ತಿ ಕೈ ಕವಾಲಾ ದಕ್ಹಾ ಸದ್ದು ಕಾಯರೊ ತಿಕನ ಐಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ಇವ್ನೆ ತಿನೆ, ಗುರು, ಯಕ್ಲೊ ಬಚ್ಚಾ಼ ನೈಸೊ ಮರ‍್ಯೊಮ ತಿನಿ ಬೈಕೊನೆ ತಿನೊ ನ್ಹಾನೊ ಭೈ ಹಿನಾ ಕರಿಲಿದ್ಯೊಮ ತಿನಾ ಮ್ಹೊಟಾ ಬೈನಾ ಬಚ್ಚಾ಼ ಪಡ್ದಿಲ್ಯು ಕೈನ ಮೊಶೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ತೆನೈಸೊ ಹಮೊಮಾ ಕ್ಹಾತ ಭಾಯೊ ವ್ಹತಾ. ಪೈಲಾನೊ ಹಿವಾಕರಿಲಿನ ಮರಿಗಯೊ. ತಿನೆ ಬಚ್ಚಾ಼ ನೈಸೊಕ್ಹು ಬೈಕೊನೆ ತಿನಾ ಭೈನೆ ಛೊಡಿನೆ ದದ್ಯೊ; ");
INSERT INTO sle_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ತಿನಾನಿಂಗತಜ಼ ಬೆವಾವಾಲೊ ತನ್ವಾವಾಲೊ ತಿನಾನಿಂಗತಜ಼ ಕ್ಹಾತ್ವಾಲಕ್ಕಾ ಕರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ತ್ಯುನೆಕ್ಹಾರಾ ಮರಲ್ಪರ ತೆ ಬಾಕ್ಡಿಬಿ ಮರಿಗೈ. ");
INSERT INTO sle_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ತಿಮ ರ‍್ಹಯುಮ ಪುನರುತ್ಥಾನಮಾ ತೆ ಕ್ಹಾತ ಜ಼ನಾವೊಮಾ ಕಿನಿ ಬೈಕೊ ಥೈನ ರ‍್ಹವಸ? ತೆ ಕ್ಹಾತೆ ಜ಼ನಾವವೊನೆ ಹಿವಾಕರಿಲಿದಿಸ ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ತೆ ವಾತೆ ಯೆಸು ತ್ಯುನೊನೆ, ತುಮೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ವರಿ ಕ್ಹುದಾನಿ ತಾಕತನೆ ಕ್ಹರಿಮಾಜ಼ ನೈ ತಿಳದಿಲಿದ್ಯಾವಾಚಿ ತಪ್ಪ ಅಬಿಪ್ರಾಯಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ಪುನರುತ್ಥಾನ ಥಯಲ್ಪರ ಹಿವಾ ಕರಿಲೆತಾ ನೈ, ಹಿವಾ ಕರಿನ ದೆತಾಬಿ ನೈ; ಪರಲೊಕಮಾ ದೆವದುತೊ ನಿಂಗತ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ಮರಲವಾಲಾವೊನಾ ಹುತಿ ಪುನರುತ್ಥಾನಾ ಹುತಿ ಕೌ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ಮಿ ಅಬ್ರಹಾಮನೊ ಕ್ಹುದಾ, ಇಸಾಕನು ಕ್ಹುದಾ, ಯಾಕೊಬನೊ ಕ್ಹುದಾ, ಕೈನ ಕ್ಹುದಾ ತುಮೊನೆ ಕದ್ಯೊಸ ಕೈನ ತುಮೆ ಒದ್ಯಾ ನತ್ತಿಸು, ತೆ ಮರಲವಾಲಾವೊನೆ ಕ್ಹುದಾ ನ್ಹವೈ. ತೆನೈಸೊ ಜಿವ್ತಾರ‍್ಹಯಲವಾಲಾವೊನೆ ಕ್ಹುದಾ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ಮನಕ್ಹೊನು ಗುಂಪ ತೆ ಕ್ಹಾರು ಐಕಿನ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ಯೆಸು ಸದ್ದುಕಾಯರೊನೆ ಮ್ಹೊಡುಜ಼ ಬಂದ ಕರಾಯೊಸ ಕೈನ ಫರಿಸಾಯರೊ ಐಕಿನ ತ್ಯಾ ಮಳಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ತ್ಯುನೊಮಾನೊ ಯಕ್ಲೊ ಧರ್ಮುಪದೆಶಕ ತಿನೆ ಪರಿಕ್ಷಾ ಲ್ಯು ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ಗುರು, ಧರ್ಮನಾ ನಿಯಮ್ಮಾ ಕಯು ಆಗನ್ಯಾ ಖಾಸ ವ್ಹೈ ತಿನೆ ಪುಚ಼ಲಹುತಿ ");
INSERT INTO sle_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ಯೆಸು ತಿನೆ, ತಾರೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನೆ ತಾರಾ ಪುರಾ ಮನಸಕ್ಹು ತಾರು ಪುರಾ ಜ಼ಲಮಕ್ಹು ಮಯಾ ಕರು, ");
INSERT INTO sle_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ಕವಾನಿ ಆಗನ್ಯಾ ಖಾಸ ವ್ಹೈ ವರಿ ಪೈಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ಇನೆ ಸರಿ ಸಮಾನ ಬೆವಾ ಆಗನ್ಯಾ ಕೈ ವ್ಹೈ ಕದ್ಯಾಮ, ತಾರಾ ಆಜು಼ ಬಾಜು಼ವಾಲಾನೆ ಖುದ್ದನಾನಿಂಗತ ಮಯಾಕರು ಕವಾನುಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ಎ ಬೆ ಅಗನ್ಯಾ ಕ್ಹಾರಾ ಧರ್ಮ ನಿಯೊಮೊನಾ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥೊನೆ ಆಧಾರ ಥೈನ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ಫರಿಸಾಯರೊ ಮಳಿನ ಆಯಲ ಹುತಿ ಯೆಸು ತ್ಯುನೊನೆ, ");
INSERT INTO sle_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ಆವಾನೊ ರ‍್ಹಯಲ ಕ್ರಿಸ್ತಾನಾ ಹುತಿ ತುಮೊನೆ ಕಿಮ ದಿಕ್ಹಸ? ತೆ ಕಿನೊ ದಿಕ್ರೊ ವ್ಹೈ?ಕೈನ ಪುಚ಼ಲ ಹುತಿ ");
INSERT INTO sle_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ತ್ಯುನೆ ತಿನೆ, ದಾವಿದನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಕದ್ಯಾ. ತೆ ವಾತೆ ತೆ, ತಿಮ್ಮ ರ‍್ಹಯುಮ ದಾವಿದಜ಼, ಪವಿತ್ರ ಆತ್ಮಾನಿ ಪ್ರೆರಣಾಕ್ಹು ತಿನೆ ಕರ್ತಾ ಕೈನ ಕದ್ಯೊಸ್ತೊ ಎ ಕಿಮ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ಮಿ ತಾರಾ ವಿರೊದಿಯೊನೆ ತಾರಾ ಪಗ್ಮಾ ಘಾಲೆಲಕ್ಕಾ ತು ಮಾರಾ ಶಿದಾ ಹತ ಬಗಲ ಬೈಟ, ಕೈನ ಕರ್ತಾನೆ ಮಾರೊ ಮಾಲಕನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ಎ ವಾತಮಾ ದಾವಿದಜ಼ ತಿನೆ ಕರ್ತಾ ವ್ಹೈ ಕೈನ, ಕದಲ್ಪರ ತೆ ತಿನೊ ದಿಕ್ರೊ ಕಿಮ್ಮ ವ್ಹೈ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ತೆ ವಾತೆ ಯಕ್ಲೊಬಿ ತಿನೆ ಯಕ್ಕ ವಾತಬಿ ಪುಚ್ಯಾವಾಚಿ ಗಯಾ. ತೆಳಾಮಾತಾ ತಿನೆ ಕುನ್ನಸ ಸುಜ಼ ಪುಚ಼ಾನೆ ಧೈರ್ಯ ಥೈ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ಶಾಸ್ತ್ರಿಯೊ ವರಿ ಫರಿಸಾಯರೊ ಮೊಶೆನಾ ಜ಼ಗಾಪರ ಬೈಟ್ಯಾಸ; ");
INSERT INTO sle_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ತಿನಾಹುತಿ ತ್ಯುನೆ ಸು ಆಗನ್ಯಾ ಕವಸ ತುಮೆ ಕ್ಹಾರಾ ಚಲೈಲಿನ ಜಾ಼ವೊ; ");
INSERT INTO sle_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ತ್ಯುನೆ ಕ್ಹಾರು ವಜ್ಜು ಭಾಂದಿನ ಮನಕ್ಹೊನಾ ಖಾಂದಾವೊಪರ ಉಚಾ಼ವಾ ಲಗಾಡಸ; ತ್ಯುನೆತೊ ಯಕ್ಕ ಬೊಟಬಿ ಲಗಾಡತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ತ್ಯುನೆ ಕರಾನು ಕಾಮ ಕ್ಹಾರು ಮನಕ್ಹೊ ದೆಕು ಕೈನ ಕರಸ. ತ್ಯುನೆ ಭಾಂದಿಲಿವಾನಿ ಷೆ ಮ್ಹೆಲ್ಲಿವಾನಿ ಪಟ್ಟಿಯೊ ತ್ಯುನೆ ಮ್ಹೊಟಿ ಕರಸ. ತ್ಯುನೆ ಘಲ್ಲಿದಲ ವಣ್ಣಾವೊನಾ ಗೊಂಡಾ ಮ್ಹೊಟಾ ಕರಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ತೆಕ್ಲುಜ಼ ನೈಸೊ ಉತ್ಸವ ರ‍್ಹಯಲ ಜ಼ಗಾ ಖಾಸ ಮರ್ಯಾದಿ ದ್ಯು ವರಿ ಸಭಾಮಂದಿರ್ಮಾ ಖಾಸ ಖುರ್ಚಿಯೊ ಬೈಟಾನೆ ದ್ಯು; ");
INSERT INTO sle_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ವಾನಿವಾಯೊಮಾ ರಸ್ತಾವೊಪರ ಪಗೆ ಪಡೈಲಿವಾನು ಮನಕ್ಹೊನಾ ಹತೆ ಗುರುವೊ ಕೈನ ಕವೈಲಿವಾನು; ಹೌ ಕ್ಹಾರುಜ಼ ತ್ಯುನೊನೆ ಪಸಂದ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ವರಿಬಿ ತುಮೆ ಭೊದಕೊ ಕೈನ ಕವೈಲಿವೊ ನಕೊ; ಕಾ ಕದ್ಯಾಮ ಕ್ರಿಸ್ತ ಯಕ್ಕಲೊಜ಼ ತುಮಾರೊ ಭೊದಕ ವ್ಹೈ. ವರಿ ತುಮೆ ಕ್ಹಾರಾ ಭಾಯೊಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ಯಕ್ಲುಜ಼ ಭೊಲೊಕಪರ ಕಿನೆಜ಼ ತುಮಾರೊ ಬಾಪ ವ್ಹೈ ಕೈನ ಕವೊ ನಕೊ; ಕಾ ಕದ್ಯಾಮ ಪರಲೊಕ್ಮಾ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಕಜ಼ ತುಮಾರೊ ಬಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ವರಿ ಗುರು, ಕೈನ ಕವೈಲಯವೊನಕೊ; ಕಾ ಕದ್ಯಾ ತುಮಾರೊ ಗುರು ಕ್ರಿಸ್ತ ಯಕ್ಲೊಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ತೆನೈಸೊ ತುಮೊಮಾ ಮ್ಹೊಟೊ ಕೈನ ಕವೈಲಿವಾಲೊ ತುಮಾರೊ ಸೆವಕ ಥೈನ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ತಿನಾಕ್ಹು ತಿನೆ ಮ್ಹೊಟೊ ಕೈನ ಕವೈಲಿವಾಲೊ ತೆ ನ್ಹಾನೊ ಥೈನ ತಗ್ಗಿನ ರ‍್ಹೌ, ತಿನಾಕ್ಹುತೆ ತಗ್ಗಿನ ರ‍್ಹವಾಲೊ ತೆ ಮ್ಹೊಟೊ ಥೈನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ಅಯ್ಯೊ ಕಪಟಿಯೊ ಶಾಸ್ತ್ರಯೊ, ಫರಿಸಾಯರೊ, ಪರಲೊಕ ರಾಜ್ಯ ನು ಬಾಕಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ಝಾಕಿಪಾಡೊಸಿತುಮೆತೊ ಮ್ಹೈ ನೈ ಜಾ಼ತಾ. ಮ್ಹೈ ಜಾ಼ವಾಲಾವೊನೆಬಿ ಜಾ಼ವಾನೆ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊ ಮನಕ್ಹೊ ದೆಕು ಕೈನ ಮ್ಹೊಟಿಯೊ ಪ್ರಾಥನಾ ಕರೊಸಿ. ತುಮೆ ಮಾಟಿಯೊ ಮರಲ ಬಾಕ್ಡಿಯೊನಾ ಘರೊಮಾ ಹೊಕ್ಕಿನ ನಾಟಕ ಕರಿಸಿ. ತಿನಾಹುತಿ ತುಮೊನೆ ಮ್ಹೊಟಿ ಶಿಕ್ಷಾ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊತುಮೆ ಯಕ್ಕ ಮನಕ್ಹನೆ ಮತಾಂತರ ಕರಾನಾಹುತಿ ಜಿಮಿನ ವರಿ ಸಮುದ್ರನೆ ಸುತ್ತ ಮಾರಿನ ಆವೊಶಿ; ತೆ ತುಮೊಮಾ ಮಳಿನ ತೆ ತುಮೊತಿಬಿ ಜಾ಼ಸ್ತಿ ಬೆ ಯಕ್ಲಿ ನರಕ್ಮಾ ಶಿಕ್ಷಾ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ಅಯ್ಯೊ, ವಾಟಾದೆಕಾಡಾಲಾ ಕುಡ್ಡಾವೊಯಕ್ಲೊ ದೆವಾಲಯಪರ ಕ್ಹಮ್ಮ ಘಾಲ್ಯೊಮ ತೆಜ಼ ಘಮ್ಮ ವ್ಹೈ ಕವೊಶಿ.ಯಕ್ಲೊ ದೆವಾಲಯಮಾ ರ‍್ಹಯಲ ಕ್ಹೊನಾಪರ ಕ್ಹಮ್ಮ ತೆ ಪುರಾ ಕರುಜ಼ ಕೈನ ಕವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ಕುಡ್ಡಾವೊ, ಪಿಸಾಳಾವೊ, ಕಯೊ ಖಾಸ ವ್ಹೈ? ಕ್ಹೊನುಸು, ಕ್ಹೊನಾಕ್ಹು ಕರಲ ದೆವಾಲಯ ವ್ಹೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ವರಿ ಯಕ್ಲೊ ಬಲಿ ದಿವಾನಾ ಕಟ್ಟಾಪರ ಕ್ಹಮ್ಮ ಘಾಲ್ಯೊಮ ತೆ ಕ್ಹಮ್ಮ ನ್ಹವೈ ಕವೊಶಿ, ತೆನೈಸೊ ತಿಮಾ ರ‍್ಹಯಲ ಕಾಣಿಕೆಪರ ಕ್ಹಮ್ಮ ಘಾಲ್ಯಾಮ ತೆ ಪುರಾ ಕರುಜ಼ ಕೈನ ಕವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ಕುಡ್ಡಾವೊ, ಪಿಸಾಳಾವೊ, ಕಯು ಜಾಸ್ತಿ ವ್ಹೈ? ಕಾಣಿಕೆ ವ್ಹೈಸುನೈತೊ ತೆ ಕಾಣಿಕೆನೆ ಪ್ರತ್ಠಾಕರಾನಿ ಬಲಿನೊ ಕಟ್ಟೊಸು? ");
INSERT INTO sle_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ಇಮ ರ‍್ಹಯುಮ ಕಯೊಬಿ ಬಲಿನಾ ಕಟ್ಟಪರ ಕ್ಹಮ್ಮ ಘಾಲ್ಯೊ ತಿಪರ ತಿಮಾ ರ‍್ಹಯಲ ಕ್ಹಾವೊಪರ ಕ್ಹಮ್ಮ ಘಲಲನಿಂಗ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ವರಿ ಕಯೊಬಿ ದೆವಾಲಯಪರ ಕ್ಹಮ್ಮ ಗಾಲ್ಯೊಮ ತಿನಾ ಉಪ್ಪರ, ತಿಮಾ ರ‍್ಹಯಲವಾಲಾಪರ ಕ್ಹಮ್ಮ ಘಾಲಲನಿಂಗತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ವರಿ ಪರಲೊಕಪರ ಕ್ಹಮ್ಮ ಘಾಲ್ಯಾಮ ಕ್ಹುದಾನಿ ಸಂಹಾಸನಪರ ತಿಪರ ಬೈಟಲವಾಲಾಪರ ಕ್ಹಮ್ಮ ಘಾಲಲನಿಂಗತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊ ತುಮೆ ಪುದಿನ, ಮರುಗ ಪತ್ರಿ , ಸಬಸಗಿ ಸೊಪ್ಪ, ಜಿರಾಮಾ ದಕ್ಹವಾ ಭಾಗ ದಿವೊಸಿ ಕ್ಹರಿ, ತೆನೈಸೊ ಧರ್ಮನಾ ನಿಯಮ್ಮಾ ಖಾಸ ರ‍್ಹಯಲ ಕದ್ಯಾಮ ನ್ಯಾಯ ಮರಗಾ ಬರೊಕ್ಹೊ ಛೊಡಿಪಾಡ್ಯಾಸ. ಇ ಕ್ಹಾರು ಕರು; ಎ ಕ್ಹಾರು ಛೊಡು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ವಾಟ ದೆಕಾಡಾಲಾ ಕುಡ್ಡಾವೊ, ತುಮೆ ಭಕ್ತಾರಾ ಸೊಸಾಲಾ ವ್ಹೈ. ತೆನೈಸೊ ಹುಂಟ ಗಳಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊತುಮೆ ತಾಂಬಿಯಾ ವಾಟಕಾ ತುಮೆ ಭಾರಾ ಎಕ್ಹಾರು ಧವೊಸಿ ತೆನೈಸೊ ತ್ಯುನಾ ಮ್ಹೈ ದರಾಎ ಚೊ಼ರಿ ಕರಾನು ಕ್ಹು ಭರಲ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ಕುಡ್ಡೊ ರ‍್ಹಯಲ ಫರಿಸಾಯರ, ಪೈಲಾ ತೆ ಸಾಮನೊ ಕ್ಹಾರಾ ಮ್ಹೈತಾ ವಾಗಾತಿ ಕರ, ತೆಳಾಮಾ ತೆ ಭಾರಾತಾಬಿ ವಾಗಾತಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊ ತುಮೆ ಚು಼ನ್ನೊ ಮಾರಲ ಮಜಾ಼ರೊ ನಿಂಗತ ಛೆ. ಎ ಭಾರಾತು ವಾಗಾತಿ ದಿಕ್ಹಸ. ಮ್ಹೈತು ದೆಕ್ಯಾಮ ಮರಲವಾಲಾವೊನಾ ಹಡಕಾ ವರಿ ಗಲಿಜಿ ಭರಲ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ಇನಾನಿಂಗತಜ಼ ತುಮೆಬಿ ಭಾರಾತಾ ಮನಕ್ಹೊನೆ ಕ್ಹರಿನಾ ವ್ಹೈ ಕೈನ ದಿಕ್ಹೊಶಿ. ತೆನೈಸೊ ಮ್ಹೈ ಕಪಟ ವರಿ ಜ಼ಬರದಸ್ತವಾಲಾ ರ‍್ಹವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ಅಯ್ಯೊ, ಕಪಟಿಯೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊ, ಫರಿಸಾಯರೊ, ತುಮೆ ಪ್ರವಾದಿಯೊನಿಯೊ ಮಾಜಾ಼ರೊ ಭಾಂದಿನ, ಕ್ಹರಿಕ್ಹು ರ‍್ಹಯಲವಾಲಾವೊನಿಯೊ ಮಾಜಾ಼ರೊ ಶ್ರಿಂಗಾರ ಕರೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ಹಮೆ ಹಮಾರಾ ಶಾನಾವೊನಾ ಕಾಲಮಾ ರ‍್ಹವತ್ತೊ ಪ್ರಾವಾದಿಯೊನೆ ಖಲಾಸ ಕರಲ ಪಾಪಮಾ ವಾಟೊಲಿವಾಲಾ ಥಾತಾ ನ್ಹೊತಾ, ಕವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ತಿಮ ರ‍್ಹಯುಮ ಪ್ರಾದಿಯೊನೆ ಖಲಾಸ ಕರಲ ವಾಲಾವೊನಾ ಬಚ್ಚಾ಼ ವ್ಹೈ ಕೈನ ಕವಾನಿಕ್ಹು ಸಾಕ್ಷಿಯೊ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ಚೊ಼ಕು ವ್ಹೈ, ತುಮೆ ತುಮಾರಾ ಶಾನಾವೊನು ಪಾಪನಿ ಅಳತಿ ಪುರಾ ಕರೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ಕ್ಹಾಪೊ, ಕ್ಹಾಪನಿ ಜಾ಼ತನಾವೊ, ನರಕನಿ ಶಿಕ್ಷಾಕ್ಹು ನ ತುಮೆ ಕಿಮ್ಮ ವಾಚ್ಚೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ತಿನಾಹುತಿ ದೆಕೊ, ಮಿ ತುಮೊಕನ ಪ್ರವಾದಿಯೊನೆ, ಗ್ಯಾನಿಯೊನೆ ಶಾಸ್ತ್ರಿಯೊನೆ ಮೊಕ್ಲುಸ; ತುಮೆ ತಿಮಾನಾ ದಕ್ಹಾಜ಼ನಾವೊನೆ ಖಲಾಸ ಕರೊಸಿ, ಶಿಲುಬಿಪರ ಗಾಲೊಶಿ; ದಕ್ಹಾಜ಼ನಾವೊನೆ ತುಮಾರಿ ಸಭಾಮಂದಿರೊಮಾ ಬಾರಕೊಲೊಕ್ಹು ಮಾರಿನ ಗಮ್ತಾ ಭಾರಾ ಘಾಲೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ಇಮ್ಮಜ಼ ನಿತಿವಂತವಾಲೊ ಹೆಬಲನು ರಗತ ಪೈಲಾ ತುಮೆ ದೆವಾಲಯನೆ ಬಲಿನಾ ಕಟ್ಟಲಕ್ಕಾ ವಚ್ಮಾ಼ ಖಲಾಸ ಕರಲ ಬರಕಿನೊ ದಿಕ್ರಾಒ ತಯಲ ಜರಕಿನಾ ರಗತಲಕ್ಕಾ ಜಿಮಿನಪರ ಚು಼ವಾಯಲ ಕ್ಹಾರಾ ನಿತಿವಂತ ವಾಲಾವೊನು ರಗತ ಚು಼ವಾಯಲ ಅಪರಾಧ ತುಮಾರಾ ಮಾತಾವೊಪರ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ಎ ಕ್ಹಾರಾ ಅ ಸಂತತಿವಾವಾಲಾವೊಪರ ಅವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ಯೆರುಸಲೆಮ, ಯೆರುಸಲೆಮ! ಪ್ರವಾದಿ ಜ಼ಲಮ ಕಾಡಾಲಿ, ಕ್ಹುದಾ ತುಕನ ಮೊಕ್ಳವಾಲಾವೊನೆ ದಗ್ಡಾ ಮಾರಿನ ಖಲಾಸ ಕರಾಲಿ! ಕುಕಡಿಯೊ ತಿನಾ ಬಚ್ಚಾ಼ವೊನೆ ರೆಕ್ಯಾಮಾ ಝಾಕಿಲಿದಲನಿಂಗತ ತಿನಾನಿಂಗತ ತಾರಾ ಬಚ್ಚಾ಼ವೊನೆ ಮಿ ಝಾಕಿಲಿವಾನೆ ಮನೆ ಘನ್ನು ಮನಸ ವ್ಹತು. ");
INSERT INTO sle_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ದೆಕೊ, ತುಮಾರು ಘರ ಖಾಲಿ ಖಾಲಿ ಲಾಗಸ. ");
INSERT INTO sle_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ಹಮ್ನಾತಾಜ಼, ಕರ್ತಾನಾ ನಾಮಪರ ಆವಾಲಾ ಧನ್ಯ ವ್ಹೈ ತುಮಾರಾಕ್ಹು ತುಮೆಜ಼ ಕಯೆಲಕ್ಕಾ ತುಮೆ ಮನೆ ದೆಕ್ತಾಜ಼ ನೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ತೆ ಥಯಲ್ಪರ ಯೆಸು ದೆವಾಲಯಮಾತೊ ಜಾ಼ತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ದೆವಾಲಯನಾ ಕಟ್ಟಡೊ ದೆಕಾಡಾನಾ ಹುತಿ ತಿನಾ ನಜಿಕ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ತೆಳಾಮ ಯೆಸು ತ್ಯುನೊನೆ ಎ ಮ್ಹೊಟ ಗೊಡಿಯೊ ದೆಕಾಡ್ಯಾಸು? ಮಿ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ ನ್ಹ್ಯಾ ದಗ್ಡಾಪರ ದಗ್ಡೊ ಹುಬ್ರೆತು ನೈ, ಕ್ಹಾರುಜ಼ ಪಾಡಾಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ಪಾಚಾ಼ತೊ ತೆ ತೆಲನಾ ಝಾಡೊನಾ ಡೊಂಗರಪರ ಬೈಟಲ ರ‍್ಹತಾಮಾ ತಿನಾ ಶಿಶ್ಯಾ ತಿಕನ ಐನ, ಎ ಕ್ಹಾರು ಕೆಳಾಮಾ ಥಾವಸ? ತು ಪ್ಹರಿನ ಆವಾನು ದುನಿಯಾ ಖಲಾಸ ಥಾವಾನು ವಳಕ ಸು ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ಕುನಬಿ ತುಮೊನೆ ಮೊಸ ಕರ‍್ಯಾವಾಚಿ ದೆಕಿಲಿವೊ. ಹುಶಾರ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ಕಾ ಕದ್ಯಾಮ ಮಾರಾ ನಾಮಪರ ಘನ್ನಾ ಜ಼ನಾ ಐನ ಮಿಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಮಿಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಘನ್ನಾ ಜ಼ನಾವೊನೆ ಮೊಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ಯಕ್ಲೊಜ಼ ನೈಸೊ ಯುದ್ದೊ ಥಾವಾನಿಯೊ ವಳಕ ಸುದ್ದಿಯೊ ತುಮೆ ಐಕೊಶಿ. ಕಳವಳಥಯಾವಾಚಿ ದೆಕಿಲಿವೊ, ಇಮ್ಮ ಥಾವಾನು ಜ಼ರುರತ್ತ ಛೆ. ವರಿಬಿ ತೆ ಅಂತ್ಯಕಾಲ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ಇಮ್ಮ ಥಾತಾಮಾ ಮನಕ್ಹೊನಾ ವಿರುದ್ದ ಮನಕ್ಹೊ, ರಾಜ್ಯನಾ ವಿರುದ್ದ ರಾಜ್ಯ ಉಟಸ; ವರಿ ತ್ಯಾ ತ್ಯಾ ಬರಗಾಲ, ತ್ಯಾ ತ್ಯಾ ಭುಕಂಪೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ಎ ಕ್ಹಾರು ತ್ರಾಸ ಥಾವಾನು ಚಾಲು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ತೆಳಾಮಾ ತುಮೊನೆ ತ್ರಾಸ ಕರಿನ ಖಲಾಸ ಕರಸ; ಮಾರಾ ಹುತಿ ತುಮೊನೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ದ್ವೆಶಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ತೆಳಾಮಾ ಘನ್ನಾ ಜ಼ನಾ ಭುಚ಼್ಕಿನ ಪಾಚಾಸರ್ಕಿನ ಯಕ್ಲಾನೆ ಯಕ್ಲೊ ಧರಿನ ದಿವಸ; ಯಕ್ಲಾಪರ ಯಕ್ಲೊ ದ್ವೆಶ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ಘನ್ನಾ ಸುಳ್ಳ ಪ್ರವಾದಿಯೊ ಉಟಿನ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಮೊಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ಯಕ್ಲುಜ಼ ನೈಸೊ ಅಧರ್ಮ ಜಾಸ್ತಿ ಥಯಲಹುತಿ ಘನ್ನಾ ಮನಕ್ಹೊನಿ ಮಯಾಜ಼ ಥಂಡಿ ಥೈ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ವರಿಬಿ ಲಾಸ್ಟಲಕ್ಕಾ ತಡ್ದಿಲಿವಾಲೊ ರಕ್ಷಣೆ ಹೊಂದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ಯಕ್ಲುಜ಼ ನೈಸೊ ರಾಜ್ಯನಿ ಎ ಸುವಾರ್ತೆ ಕ್ಹಾರಿಜ಼ ದುನಿಯಾಮಾ ಕ್ಹಾರಾ ಮನ್ಕಹೊನೆ ಸಾಕ್ಷಿನಾಹುತಿ ಪೈಲಾವಸ; ತೆಳಾಮಾ ಅಂತ್ಯಕಾಲ ಅವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ಪ್ರಾವಾದಿ ದಾನಿಯಲ ಕದಲ ತಿಮ್ಮಜ಼ ಹಾಳ ಕರಾನು ಕೆಟ್ಟ ವಸ್ತು ಪವಿತ್ರ ಜ಼ಗಾಪರ ಹುಬ್ರಯಲ ತುಮೆ ದೆಕ್ತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ಯುದಾಯಮಾ ರ‍್ಹಯಲವಾಲಾ ಕ್ಹಾರಾಜ಼ ದೊಂಗರ್ಪರ ನ್ಹಾಟಿ ಜಾ಼ವಾದೆ; ");
INSERT INTO sle_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ಮ್ಹಾಡಿಪರ ರ‍್ಹಯಲವಾಲೊ ತಿನಾ ಘರ್ಮಾ ರ‍್ಹಯಲ ಸುಜ಼ ಸಾಮನ ಲಿವಾನೆ ಜ಼ೌ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ಖೆತರ್ಮಾ ರ‍್ಹಯಲವಾಲೊ ತಿನಾ ವಚ್ಚಾ಼ನಾ ಲಿವಾನಾ ಹುತಿ ಜೌ಼ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ತೆ ದಿನೊಮಾ ಪೆಟೆ ರ‍್ಹಯಲವಾಲಿಯೊನೆ, ಬಾಣತಿಯೊ ರ‍್ಹಯಲ ಹೆಣ್ಣ ಮನಕ್ಹೊ ಅಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ತುಮೊನೆ ಎಕ್ಹಾರು ಥಂಡನಾ ದಿನೊಮಾ ಸಬ್ಬತದಿನೊಮಾ ರ‍್ಹವಾಎ ಥೌ ನೈ ಕೈನ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ಕಾ ಕದ್ಯಾಮ ದುನಿಯಾ ಶುರುತಿಬಿ ಆಜ಼ಲಕ್ಕಾ ನೈ ಥಯಲ, ಇತ್ತಿ ಉಪ್ಪರ ನೈಸೊ ಥಾವಾನು ಮ್ಹೊಟೊ ತರಾಸ ತೆಳಾಮಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ಕರ್ತಾ ದಿನೊ ಕಮ್ಮ ನೈ ಕರ‍್ಯೊಮ ಯಕ್ಲೊಬಿ ಉಗರ್ತೊ ನೈ; ವರಿಬಿ ತೆ ಇನಿಲಿದಲವಾಲಾವೊನಾ ಹುತಿ ತೆ ದಿನೊ ಕಮ್ಮ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ತೆಳಾಮಾ ತೊಮೊನೆ ಕುನಬಿ ಕ್ರಿಸ್ತ ನ್ಹ್ಯಾ ಛೆ ಕ್ರಿಸ್ತ ನ್ಹ್ಯಾ ಛೆ ಕೈನ ಕದ್ಯಾಮ ತುಮೆ ನಂಬೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ಸುಳ್ಳ ಕ್ರಿಸ್ತೊ, ಸುಳ್ಳ ಪ್ರವಾದಿಯೊ ಉಟಿನ ಸಾಧ್ಯ ಥಯುಮ ಕ್ಹುದಾ ಇನಿಲಿದಲ ಮನಕ್ಹೊನೆ ಬಿ ಮೊಸ ಕರಾನಾ ಹುತಿ ಮ್ಹೊಟಾ ಸುಚಕ ಕಾಮೊ ಘಾಬ್ರಾ ಥಾವಾನಾ ಕಾಮೊ ಕರಿನೆ ದೆಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ದೆಕೊ, ಮಿ ಪೈಲಾಜ಼ ಮಿ ಕವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ತಿನಾಹುತಿ ಕುನಬಿ ತುಮೊನೆ ಕುನಬಿ, ದೆಕೊ, ಕ್ರಿಸ್ತ ರಾನಮಾ ಛೆ. ಕೈನ ಕದ್ಯಾಮ ತುಮೆ ರಾನ್ಮಾ ಗೈ ಪಡೊನಕೊ; ದೆಕೊ ಮ್ಹೈನಾ ಘರ್ಮಾ ಛೆ ಕೈನ ಕದ್ಯಾಮ ಬರೊಕ್ಹೊ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ಕಿಮ್ಮ ಬಿಜಲಿ ಪುರ್ವಮಾ ಹುಟ್ಟಿನ ಪಶ್ಚಿಮ ಲಕ್ಕಾ ಉಜಾಲು ದಿಕ್ಹಸ ತಿನಾ ನಿಂಗತಜ಼ ಮನಕ್ಹೊನೊ ದಿಕ್ರೊ ಆವಾನು ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ಮುರ್ದೊ ಪಡಲ ಜ಼ಗಾ ಹದ್ದೊ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ತೆ ತ್ರಾಸನಾ ದಿನೊ ಮುಗ್ದಲ್ಪರ ಸುರ್ಯೊ ಅಂದಾರು ಥಾವಸ, ಚ಼ಂದಪ್ಪಾ ಉಜಾಲು ದಿದ್ಯಾವಾಚಿ ರ‍್ಹವಸ, ಚಿಕ್ಕಯೊ ಹಬಾಳಮಾತಿಯೊ ಪಡಸ, ಹಬಾಳಮಾ ರ‍್ಹಯಲ ತಾಕತೊ ಹಲ್ಲಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ತೆಳಾಮಾ ಮನಕ್ಹೊನೊ ದಿಕ್ರೊ ಕದಲ ವಳಕ ಹಬಾಳಮಾ ದಿಕ್ಹಿನ ಆವಸ. ತೆಳಾಮಾ ಭುಲೊಕ್ಪರ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಛಾತಿ ಬಡೈಲಿವಸ, ವರಿ ಮನಕ್ಹನೊ ದಿಕ್ರಾನಿ ತಾಕತಕ್ಹು, ಘನ್ನಿ ಮಹಿಮಾಕ್ಹು ಹಬಾಳನಾ ಮ್ಹಾಡಪರ ಆವಾನು ದಿಕ್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ತೆ ತಿನಾ ದುತೊನೆ ಪೊಂಗಾವೊನಿ ಮ್ಹೊಟಿ ಅವಾಜ಼ನಾ ಕ್ಹಾತೆ ಮೊಕ್ಲಸ. ತ್ಯುನೆ ತೆ ಇನಿಲಿದಲವಾಲಾವೊನೆ ಹಬಾಳನಾ ಯಕ್ಕ ಬಗಲ್ತೊ ಚಾ಼ರೆ ದಿಕ್ಕ ಬಗಲ್ತೊ ಮಳಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ಅಂಜುರ್ನಾ ಝಾಡನಿ ದೃಷ್ಟಾಕ್ಹು ಗ್ಯಾನ ಶಿಕ್ಕೊ. ತಿನಿಯೊ ಠೊಂಗಿಯೊ ಹಜು಼ನ ಕುಳಿಯೊ ರ‍್ಹತಾಮಾಜ಼ ಪಾಲೊ ಛೊಡ್ತಾಮ ತಡಕಾನೊ ದಿನ್ನ ನಜಿಕ ಐಯೊಸ ಕೈನ ತಿಳದಿಲಿವೊಸಿತೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ತಿಮ್ಮಜ಼ ತುಮೆ ಎ ಕ್ಹಾರು ದೆಕ್ತಾಮಾ ತೆ ದಿನ್ನ ನಿಜಕ ಆಯೊಸ ಕೈನ ತಿಲದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ಎ ಕ್ಹಾರು ಥಾಯೆಲಕ್ಕಾ ಎ ಸಂತತಿ ಮಿಟೈಜಾ಼ತಿ ನೈ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ಜಿಮಿನ ಹಬಾಲ ಮಿಟೈಜಾ಼ತು ನೈ, ತೆನೈಸೊ ಮಾರಿ ವಾಕ್ಯ ಹಮೆಶಾಬಿ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ತೆನೈಸೊ ತೆ ದಿನೊ ವರಿ ತೆ ಟೈಮನಾ ಹಹುತಿ, ಮಾರಾ ಬಾನೆ ಯಕ್ಕಜ಼ ಗ್ವತ್ತ ಛೆ ಬಿಜಾ಼ ಕಿನೆಜ಼ ಗ್ವತ್ತ ನತ್ತಿ. ಪರಲೊಕಮಾ ರ‍್ಹಯಲ ದುತೊನೆಬಿ ಗ್ವತ್ತ ನತ್ತಿ, ದಿಕ್ರಾನೆಬಿ ಗ್ವತ್ತ ನತ್ತಿ.. ");
INSERT INTO sle_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ನೊಹಾನಾ ದಿನೊ ಕಿಮ್ಮ ವ್ಹತಾ ತಿನಾನಿಂಗತಜ಼ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆವಾನಾ ಟೈಮ್ಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ಕಿಮ್ಮ ಕದ್ಯಾಮ ಜಲಪ್ರಳಯ ತಿ ಪೈಲಾನಾ ದಿನೊಮಾ ನೊಹಾ ಹಡಗಾಮ ಗಯಲ ದಿನ್ನ ಲಕ್ಕಾ ಮನಕ್ಹೊ ಪಿತಾ ಖಾತಾ, ಹಿವಾ ಕರಿಲೆತಾ, ಹಿವಾ ಕರ್ತಾ ವ್ಹತಾ. ");
INSERT INTO sle_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ಪ್ರಳಯನು ಪಾನಿ ಐನ ಕ್ಹಾರಾವೊನೆ ಕಿತ್ತೈ ಲಿನ ಜಾ಼ಯೆ ಲಕ್ಕಾ ತ್ಯುನೊನೆ ಸುಜ಼ ಗ್ವತ್ತ ನೈಸೊ ವ್ಹತಾತೊ. ತಿನಾನಿಂಗತಜ಼ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆವಾನ ದಿನೊಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ತೆಳಾಮಾ ಬೆ ಜ಼ನಾ ಖೆತರ್ಮಾ ರ‍್ಹವಸ; ತ್ಯುನೊಮಾಮಾನಾ ಯಕ್ಲಾನೆ ಲಿವಸ, ಯಕ್ಲಾನೆ ಛೊಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ಬೆ ಬಾಕ್ಡಿಯೊ ದಳಾನಾ ಡಗ್ಡಾಕನ ಬೈಟಿನ ದಳತಿಯೊ ರ‍್ಹವಸ; ಯಕ್ಲಿನೆ ಲಿವಸ, ಯಕ್ಲಿನೆ ಛೊಡಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಕರ್ತಾ ಆವಾನೊ ದಿನ್ನ ನೈ ಗ್ವತ್ತ ರ‍್ಹಯಲ ಹುತಿ ಹುಶಾರಮಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ಚ಼್ವಟ್ಟೊ ಕೆಳಾಮಾ ಆವಸ ಕವಾನು ಗ್ವತ್ತ ರ‍್ಹವತ್ತೊ ತೆ ತಿನಾ ಗರ್ಮಾ ಚೊ಼ರಿ ಕರಾನೆ ಆವಾಲಾನೆ ಕೈತ್ತೊ ರ‍್ಹತೊತೊ ಕೈ ತಿಳ್ದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ತಿನಾ ಹುತಿ ತುಮೆಬಿ ತಯ್ಯಾರ ರ‍್ಹವೊ; ತುಮೆ ವಿಚಾರಬಿ ಕರಲ ರ‍್ಹತಾ ನೈ ತೆವಾ ಟೈಮ್ಮಾ ಮನಕ್ಹೊನೊ ದಿಕ್ರೊ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ಕದ್ಯಾಮ ಮಾಲಕ ತಿನಾ ಘರವಾಲಾವೊನೆ ಟೈಮೆ ಟೈಮೆ ಅನ್ನ ದಿವಾನಾ ಹುತಿ ತೆ ಬರೊಕ್ಹಾವಾಲಾ ನಿಂಗತ, ಗ್ಯಾನಿ ಥಯಲ ಆಳ ಕುನ್ನ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ಮಾಲಕ ಆವಾನಾ ವಕ್ಹತಮಾ ಕಯೊ ಆಳ ಇಮ್ಮ ಕರಾನು ದೆಕ್ಯೊಮ ತೆ ಆಳ ಧನ್ಯ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ತೆವಾನೆ ತೆ ತಿನಿ ಕ್ಹಾರಿ ಆಸ್ತಿನೆ ಮ್ಯಾನೆಜರ ಕರಿನ ಮ್ಹೆಲಸ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ತೆನೈಸೊ ತೆ ಕೆಟ್ಟ ಆಳ, ಮಾರೊ ಮಾಲಕ ಆವಾನೆ ತಡಾ ಕರಸ, ಕೈನ ತಿನಾ ಮನಸ್ಮಾ ಕೈಲಿನ ");
INSERT INTO sle_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ತಿನಾ ಆಳೊನೆ ಮಾರ್ತೊ, ವರಿ ಪಿದೊಡಾವೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ಪಿವಾನು ಸುರು ಕರ‍್ಯೊಮ, ");
INSERT INTO sle_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ತೆ ವಿಚಾರ ನೈ ಕರಲ ದಿನೊಮಾ, ವಕ್ಹತ ನೈ ರ‍್ಹಯಲ ಗ್ವತ್ತ ಟೈಮ್ಮಾ ತೆ ಅಳನೊ ಮಾಲಕ ಐನ ತಿನೆ ಘನ್ನಿ ಮ್ಹೊಟಿ ಶಿಷಾ ದಿನ ");
INSERT INTO sle_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ಕಪಟ್ಯಾವೊ ನೈಸೊ ಥಾವಾನಿ ಗತಿ ತಿನೆ ತೆ ಕರಸ.ತ್ಯಾ ರವಾನು ಕಟ್ಟ ಕಟ್ಟ ದಾತೊ ಖಾವಾನು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ಪರಲೊಕ ರಾಜ್ಯ ತಿವ್ನಿಯೊ ಆರ್ತಿಯೊಲಿನ ನೌರಾನಿ ಮಳಾನಾಹುತಿ ಜಾ಼ವಾಲಿಯೊ ದಕ್ಹ ಜ಼ನಿಯೊ ಜಾಂಜಿಮಾ ಛೊಕ್ರಿಯೊ ನೆ ಹೊಲಿಕೆ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ತ್ಯುನೊಮಾ ಪಾಂಚ಼ ಜ಼ನಿಯೊ ಗ್ಯಾನಿ ಪಾಂಚ಼ ಜ಼ನಿಯೊ ಗ್ಯಾನ ನೈಸೊ ವಾಲಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ಗ್ಯಾನ ನೈಸೊವಾಲಿಯೊ ಆರ್ತಿಯೊಲಿನ, ತಿನಾ ಕ್ಹಾತೆ ತೆಲ ಲಿದಿಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ತೆನೈಸೊ ಶಾಣಿಯೊ ರ‍್ಹಯಲವಾಲಿಯೊ ಆರ್ತಿಯೊಲಿನ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ಜಾಸ್ತಿ ತೆಲ ಲಿದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ನೌರೊ ಆವಾನು ತಡಾ ಕರಲಹುತಿ ತ್ಯುನಿ ಕ್ಹಾರಿಯೊ ಝುಕ್ಕಾತಿಯೊ ಕ್ಹುರೈಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ವರಿ ಅರ್ದಿ ರಾತಮಾ, ದೆಕೊ, ನೌರೊ ಆವಾಡ್ಯೊಸ ತಿನೆ ಮಳಾನಾ ಹುತಿ ಚಾ಼ಲೊ, ಕವಾನು ಅವಾಜ಼ ಐಕು ಆಯು. ");
INSERT INTO sle_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ತೆಳಾಮಾ ತೆ ಛೊಕ್ರಿಯಯೊ ಹುಶಾರ ಥೈನ ತಿವ್ನಿಯೊ ಆರ್ತಿಯೊ ಲಿನ ವಾಗಾತಿ ಕರಿಲಿದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ತೆಳಾಮಾ ಗ್ಯಾನ ನೈಸೊವಾಲಿಯೊ ಶಾಣಿಯೊ ರ‍್ಹಯಲ ಛೊಕ್ರಿಯೊನೆ , ತುಮೊಕನ ರ‍್ಹಯಲ ತೆಲಮಾ ಹಮೊನೆ ದಕ್ಹು ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ಕಾಕದ್ಯಾಮ ಹಮಾರಾ ದಿವ್ವಾ ಇಜ್ಜೈ ಜಾ಼ವಸ ಕೈನ ಕದಿಯೊ ತೆ ವಾತೆ ತೆ ಶಾಣಿಯೊ ಛೊಕ್ರಿಯೊ , ನೈ ಥಾತು ತುಮೊನೆ ದಿದಿಯೊಮ ಹಮೊನೆಬಿ ಥಾತು ನೈ ತುಮೊನೆಬಿ ಥಾತು ನೈ, ತುಮೆ ಇಕ್ಕಾಲಾವೊಕನ ಗೈನ ಲಿದಿಯೊಮ ಚೊ಼ಕು ವ್ಹೈ ಕದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ತ್ಯುನೆ ಇಕ್ಕಾತು ಲಾವಾನೆ ಜಾ಼ತಾಮಾ ನೌರೊ ಆಯೊ. ತಯ್ಯಾರ ರ‍್ಹಯಲವಾಲಿಯೊ ತಿನಾ ಕ್ಹಾತೆ ಹಿವಾನಾ ಘರ್ಮಾ ಗೈಪಡಿಯೊ, ಬಾಲಕ ಘಾಲಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ಪಾಚಾ಼ತಿಯೊ ಉಗ್ರಲ ಛೊಕ್ರಿಯೊ ಐನ, ಕರ್ತಾ, ಕರ್ತಾ, ಹಮಾರಾ ಹುತಿ ಬಾಕಲ ಕಾಡ ಕದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ತೆ ವಾತೆ ತೆ ತ್ಯುನೊನೆ ಅಮ್ಮ ಕದ್ಯೊ ತುಮೆ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಮನೆ ಕ್ಹರಿಮಾಜ಼ ಗ್ವತ್ತ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ಕಾ ಕದ್ಯಾಮ ತೆ ದಿನ್ನ ತೆ ವಕ್ಹತ ತುಮೊನೆಬಿ ಗ್ವತ್ತ ನತ್ತಿ ತಿನಾಹುತಿ ತುಮೆ ಹುಶಾರಮಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ಕ್ಹುದಾನೊ ರಾಜ್ಯ ಕಿಮ ಛೆ ಕದ್ಯಾಮ ಯಕ್ಕ ಮನಕ್ಹ ಬಾರಲ್ಯಾ ದೆಶೆ ಜಾ಼ವಾಲೊ ಮನಕ್ಹ ತಿನಿ ಪುರಾ ಆಸ್ತಿಪರ ತಿನಾ ಆಳನೆ ಬಲೈನ ತಿನೆ ಆಸ್ತಿ ಆಳನೆ ಒಪ್ಸಿನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ತೆ ಯಕ್ಲಾನೆ ಪಾಂಚ಼ ತಲಾಂತೊ, ಯಕ್ಲಾನೆ ಬೆ ತಲಾಂತೊ ಯಕ್ಲಾನೆ ಯಕ್ಕ ತಲಾಂತೊ ಇಮ್ಮ ತ್ಯುನಾ ತ್ಯುನಾ ಸಾಮರ್ಥನಿಂಗತ ತಲಾಂತೊ ವಪ್ಸಿನೆ ದಿನ ತೆ ಮಾಲಕ ಭಾರಲ್ಯಾ ದೆಶೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ತೆಳಾಮಾಜ಼ ಪಾಂಚ಼ ತಲಾಂತೊ ಲಿದಲವಾಲೊ ಗೈನ ತಿಮಾ ವ್ಯಾಪಾರ ಕರಿನ ವರಿ ತಿಮಾ ಪಾಂಚ಼ ತಲಾಂತೊ ಕಮಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ತಿನಾ ನಿಂಗತಜ಼ ಬೆ ತಲಾಂತೊ ಲಿದಲವಾಲೊ ತಿಮಾ ಬೆ ತಲಾಂತೊ ಕಮಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ತೆನೈಸೊ ಯಕ್ಕ ತಲಾಂತ ಲಿದಲವಾಲೊ ಗೈನ ಜಿಮಿನ ಖಂದಿನ ತಿನೊ ಮಾಲಕ ದಿದಲ ತಲಾಂತ ಝಾಕಿನ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ಘನ್ನಾ ದಿನ್ಪರ ಮಾಲಕ ಐನ ತಿನಾ ಆಳೊನೆ ಬಲೈನ ತ್ಯುನೊಕ್ಹು ಲೆಕ್ಕೊ ಪುಚ್ತಾ಼ಮಾ ");
INSERT INTO sle_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ಪಾಂಚ಼ ತಲಾಂತೊ ಲಿದವಾಲೊ ತಿನಾ ಕ್ಹಾತೆ ವರಿ ಪಾಂಚ಼ ತಲಾಂತೊ ಕಮಾಯಲ ಲೈನ, ಮಾಲಕ, ತು ಮನೆ ಪಾಂಚ಼ ತಲಾಂತೊ ದಿದ್ಯೊತೊತೊ ಲೆ, ವರಿ ಪಾಂಚ಼ ತಲಾಂತೊ ಕಮಾಯೊಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ತಿನೊ ಮಾಲಕ ತಿನೆ, ಹೊ ಬೊರೊಕ್ಹೊ ರ‍್ಹಯಲ ಚೊ಼ಕಾ ಸೆವಕ; ತು ನಕ್ಕರ ಕಾಮ್ಮಾ ಕ್ಹರಿನೊ ವ್ಹೈ; ಮ್ಹೊಟಾ ಕಾಂಪರ ತುನೆ ಮ್ಹೆಲುಸ; ತಾರಾ ಮಾಲಕನಾ ಖುಶಿಮಾ ತು ಮಳ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ತೆಳಾಮಾ ಬೆ ತಲಾಂತೊ ವ್ಹಂದಲ ಆಳ ಐನ, ಮಾಲಕ, ತು ಮನೆ ಬೆ ತಲಾಂತೊ ದಿದ್ಯೊತೊತ; ದೆಕ, ತಿಮಾ ವರಿ ಬೆ ತಲಾಂತೊ ಕಮಾಯೊಸ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ತಿನೊ ಮಾಲಕ ತಿನೆ ಹೊ, ಬರೊಕ್ಹೊ ರ‍್ಹಯಲ ಚೊ಼ಕಾ ಸೆವಕ ತುಬಿ ದಕ್ಹಾಜ಼ ರ‍್ಹಯಲ ಕಾಮ್ಮಾ ಕ್ಹರಿಕ್ಹು ರ‍್ಹಯೊಸ, ಮ್ಹೊಟಾ ಕಾಂಪರ ತುನೆ ಮ್ಹೆಲುಸ; ತಾರಾ ಮಾಲಕನಾ ಖುಶಿಮಾ ತು ಮಳ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ತೆಳಾಮಾ ಯಕ್ಕ ತಲಾಂತ ಲಿದಲವಾಲೊ ಐನ ಮಾಲಕ, ತು ಬಿತ್ತಲಜ಼ ಕಾಟಾಲಾ ವ್ಹೈ, ತು ತುರ್ಯಾವಾಚಿ ರಾಶಿ ಕರಾಲೊ ವ್ಹೈ ರ್ಹಯಲ ಘಟ್ಟ ಮನಸ್ನೊ ಮಿ ತಿಳದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ಮಿ ಭಹಚ್ಕಿ಼ನ ತು ದಿದಲ ತಲಾಂತ ಜಿಮಿನ್ಮಾ ಝಾಕಿನ ಮ್ಹೆಲ್ಯೊತೊ; ಅಲೆ, ತಾರು ರ‍್ಹಯಲ ತುನೆಜ಼ ದ್ಯುಸ, ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ತೆಳಾಮಾ ತೆ ಮಾಲಕ ತಿನೆ ಮೈಗಳ ಥಯಲ ಕೆಟ್ಟ ಆಳ, ತು ಮನೆ ಬಿತ್ತಲಮಾಜ಼ ಕಾಟಾಲೊ ವ್ಹೈ ವರಿ ತುರ‍್ಯಾವಾಚಿ ರಾಶಿ ಕರಾಲೊ ವ್ಹೈ ಕೈನ ತಿಳದ್ಯೊಸು? ");
INSERT INTO sle_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ತಿಮ್ಮ ರ‍್ಹಯುಮ, ಮಿ ದಿದಲ ದೊಕ್ಡಾ ಸವಕಾರೊಮಾ ಬಡ್ಡಿನಿಂಗತ ದಿವಾನಹೊತು ಮಿ ಆತಾಮಾ ಬಡ್ಡಿನಾ ಕ್ಹಾತೆ ವಾಪಸ ಮಾಂಗಿಲೆತೊತೊ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ತಿಕನ ರ‍್ಹಯಲ ತಲಾಂತ ಕಾಡಿಲಿನ ದಕ್ಹ ತಲಾಂತೊ ರ‍್ಹಯಲ ಆಳಕನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ರ್ಹಯಲವಾಲಾವೊ ಹಜು಼ನ ದವಸ, ತ್ಯುನೊನೆ ಹುಜ಼ುನ ಜಾಸ್ತಿ ಥಾವಸ; ನೈ ರ‍್ಹಯಲವಾಲಾವೊಕಂತು ರ‍್ಹಯಲಬಿ ಕಾಳ್ಳಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ವರಿ ಉಪಯೊಗ ನೈಸೊ ಆ ಆಳನೆ ಭಾರು ರ‍್ಹಯಲ ಅಂದಾರಾಮಾ ಘಾಲಿಪಾಡೊ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ತ್ಯಾ ರವಾನು ಕಟ್ಟ ಕಟ್ಟ ದಾತೊ ಖಾವಾನು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","\" ಎ ನಯಸೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಿ ಮಹಿಮಾನಿ ಕ್ಹಾರಾ ದುತೊನಾ ಕ್ಹಾತೆ ಆತಾಮಾ ತಿನಿ ಮಹಿಮಾನಿ ಸಿಂಹಿಸನ್ಪರ ಬೈಟಸ, ");
INSERT INTO sle_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ತೆಳಾಮಾ ಕ್ಹಾರಾ ದಶನಾ ಮನಕ್ಹೊ ತಿನಾ ಕ್ಹಾಮಾ ಮಳಸ. ಬಕ್ರಾ ಬಕ್ರಿಯೊ ಜು಼ದಾ ಕರಲನಿಂಗತ ತೆ ತ್ಯುನೊನೆ ಜು಼ದಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ಬಕ್ರಾವೊನೆ ತಿನಾ ಶಿದಾ ಬಗಲ ಬಕ್ರಿಯೊನೆ ಡಾವಾ ಬಗಲ ಹುಬ್ರಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ತೆಳಾಮಾ ರಾಜೊ಼ ತಿನಾ ಶಿದಾ ಬಗಲ ರ‍್ಹಯಲವಾಲಾವೊನೆ, ಮಾರಾ ಬಾನೊ ಆಶಿರ್ವಾದ ಹೊಂದಲವಾಲಾ ಆವೊ, ಲೊಕಾಧಿತೊ ತುಮಾರಾ ಹುತಿ ತಯ್ಯಾರ ಕರಲ ರಾಜ್ಯ ತುಮಾರಾ ಹತ್ಮಾ ಪಡ್ದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ಮಿ ಭುಕ್ಕೊ ವ್ಹತೊ ಮನೆ ತುಮೆ ಅನ್ನ ದಿದ್ಯಾ; ಮಿ ತರಕ್ಹೊ ವ್ಹತೊ, ಮನೆ ಪಿವಾನೆ ಪಾನಿ ದಿದ್ಯಾ, ಮಿ ಪರದೆಶಿ ವ್ಹತೊ ಮನೆ ತುಮೆ ರ‍್ಹವಾನೆ ಜ಼ಗಾ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ವಣ್ಣಾ ನೈಸೊವಾಲೊ ವ್ಹತೊ ತುಮೆ ಮನೆ ವಣ್ಣಾ ಘಾಲ್ಲಿವಾನೆ ದಿದ್ಯಾ. ಮಿ ಅರಾಮ ನೈಸೊ ವ್ಹತೊ ಮನೆ ತುಮೆ ಜ಼ತ್ತನ ಕರ‍್ಯಾ, ಮಿ ಜೆಲ್ಮಾ ವ್ಹತೊ, ತುಮೆ ಮನೆ ದೆಕಾನೆ ಆಯಾ, ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ತೆ ವಾತೆ ಕ್ಹರಿಕ್ಹು ರ‍್ಹಯಲವಾಲಾ, ಕರ್ತಾ, ಕೆಳಾಮ ಹಮೆ ತು ಭುಕ್ಕೊ ರ‍್ಹತಾಮಾ ಅನ್ನ ದಿದ್ಯಾ? ತು ದರಕ್ಹೊ ರ‍್ಹತಾಮಾ ಹಮೆ ಪಾನಿ ಪಿವಾನೆ ದಿದ್ಯಾ? ");
INSERT INTO sle_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ಕೆಳಾಮಾ ತು ಪರದೆಶಿ ವ್ಹತೊ ಕೈನ ಹಮೆ ತುನೆ ದೆಕಿನ ಆಸ್ರೊ ದಿದ್ಯಾ? ತಾರಾ ವಣ್ಣಾ ದೆಕಿನ ಹಮೆ ಕೆಳಾಮಾ ತುನೆ ವಣ್ಣಾ ಘಾಲ್ಲಿವಾನೆ ದಿದ್ಯಾ? ");
INSERT INTO sle_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ಕೆಳಾಮಾ ತು ಅರಾಮನೈಸೊ ದಡ್ಯೊತೊ ವರಿ ಕೆಳಾಮಾ ತು ಜೆಲ್ಮಾ ವ್ಹತೊ ಹಮೆ ಕೆಳಾಮಾ ತುನೆ ದೆಕಾನೆ ಆಯಾತಾ, ಕೈನ ಪುಚ಼್ಚಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ತೆ ವಾತೆ ರಾಜೊ಼ ಆ ಮಾರಾ ಭಾಯೊಮಾ ಇಮಾನಾ ಯಕ್ಲಾನೆಬಿ ಸುಸು ಕರ‍್ಯಾ ತೆ ಕ್ಹಾರು ಮಾರಾ ಕ್ಹಾತೆ ಕರಲನಿಂಗತ ವ್ಹೈ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ, ಕವಸ ");
INSERT INTO sle_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ಪಾಚಾ಼ತೊ ಡಾವಾಬಗಲ ರ‍್ಹಯಲವಾಲಾವೊನೆ, ಶ್ರಾಪ ಹೊಂದಲವಾಲಾ ಮನೆ ಛೊಡಿನ ಪಿಶಾಚಿನೆ ತಿನಾ ದುತೊನೆ ತಯ್ಯಾರ ಕರಲ ಹಮೆಶಾನಿ ಆಗ್ಮಾ ಜಾ಼ವೊ. ");
INSERT INTO sle_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ಮಿ ಭುಕ್ಕೊ ವ್ಹತೊ ತುಮೆ ಮನೆ ಖಾವಾನೆ ಅನ್ನ ದಿದ್ಯಾ ನೈ. ಮಿ ತರಕ್ಹೊ ವ್ಹತೊ ತುಮೆ ಮನೆ ಪಿವಾನೆ ಪಾನಿ ದಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ಪರದೆಶಿ ವ್ಹತೊ ಮನೆ ತುನೆ ಆಸ್ರೊ ಕರ‍್ಯಾ ನೈ; ವಣ್ಣಾ ನೈಸೊವಾಲೊ ವ್ಹತೊ ಮನೆ ಘಾಲ್ಲಿವಾನೆ ವಣ್ಣಾ ದಿದ್ಯಾ ನೈ. ಅರಾಮ ನೈಸೊ ವ್ಹತೊ, ವರಿ ಜೆಲ್ಮಾ ವ್ಹತೊ, ಮನೆ ತುಮೆ ಜ಼ತ್ತನ ಕರಾನೆ ಆಯಾ ನೈ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ತೆ ವಾತೆ ತ್ಯುನೆ ಬಿ, ಕೆಳಾಮಾ ತು ಭುಕ್ಕೊ ವ್ಹತೊ,ತು ತರಕ್ಹೊ ವ್ಹತೊ, ತು ವಣ್ಣಾ ನೈಸೊವಾಲೊ ವ್ಹತೊ, ಕೆಳಾಮಾ ತು ಜೆಲ್ಮಾ ವ್ಹತೊ, ಕೆಳಾಮಾ ತು ಪರದೆಸಿ ವ್ಹತೊ, ಕೆಳಾಮಾ ಅರಾಮ ನೈಸೊ ವ್ಹತೊ ತುನೆ ಉಪಚಾರ ಕರ‍್ಯಾವಾಚಿ ಗಯಾ? ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ತೆಳಾಮಾ ತೆ ತ್ಯುನೊನೆ ಎ ಕ್ಹಾರು ನೈಸೊ ವಾಲಾವೊನೆ ಕರ‍್ಯಾ ನತ್ತಿ ತೊ ಮನೆ ಬಿ ಕರಲನಿಂಗತ ನ್ಹವೈ ಕೈನ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ.ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ವರಿ ಅನಿತಿವಂತವಾಲಾ ರ‍್ಹಯಲ ಇವ್ನೆ ಹಮೆಶಾನಿ ದಂಡನೆಮಾ ಜಾ಼ವಸ ತೆನೈಸೊ ನಿತಿವಂತವಾಲಾ ಹಮೆಶಾನೊ ಜ಼ಲಮಾ ರ‍್ಹಯಲ ಜ಼ಗಾ ಜಾ಼ವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ಯೆಸು ತೆ ಕ್ಹಾರಿಯೊ ವಾತೊ ಕೈನ ಮುಗ್ಸಲ್ಪರ ತಿನಾ ಶಿಶ್ಯಾವೊನೆ ಬೆ ದಿನ್ನ ಥಯಲ್ಪರ ಫಸ್ಕ ಸನ್ನ ಆವಾನೊ ಛೆ ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ; ");
INSERT INTO sle_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ತೆಳಾಮಾ ಮನಕ್ಹೊನೊ ದಿಕ್ರಾನೆ ಶಿಲುಬಿಪರ ಘಾಲಾನಾ ಹುತಿ ವಪ್ಸಿನ ದಿವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ತೆ ಕಾಲಮಾ ಖಾಸ ಯಾಜಕೊ, ಶಾನಾ ಮನಕ್ಹೊ ಕಾಯಫ ಕವಾಲೊ ಮ್ಹೊಟೊ ಯಾಜಕನಾ ಭವನಮಾ ಮಳಿನ ಐನ ");
INSERT INTO sle_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ಯೆಸುನೆ ಗಪ್ಪಜ಼ ಧರಿನ ಖಲಾಸ ಕರು ಕೈನ ಮ್ಹೈನಾ ಮ್ಹೈ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ವರಿಬಿ ಸನ್ನಮಾ ಧರುನೈ ಕೈನ, ಅಪ್ನಾ ಮನಕ್ಹೊಮಾ ಗದ್ದಲ ಥಾವಸ ಕೈನ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ಯೆಸು ಬೆಥಾನ್ಯಮಾ ಸಿಮೊನ ಕೈನ ಕವಾಲಾ ಕುಷ್ಠರೊಗಿನಾ ಘರ್ಮಾ ಖಾವಾಹುತಿ ಬೈಟಲ ಟೈಮ್ಮಾ ಯಕ್ಲಿ ಬಾಕ್ಡಿ ");
INSERT INTO sle_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ಘನ್ನು ಮೊಗು ಬಾಸನು ತೆಲನಿ ಭರ್ಣಿ ಲೈನ ತಿಕನಾ ನಜಿಕ ಐನ ತೆ ತೆ ತಿನಾ ಮಾತಾಪರ ರಿಚೈ಼. ");
INSERT INTO sle_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ಶಿಶ್ಯಾ ಎ ಕ್ಹಾರು ದೆಇಮ್ಮ ಸುಕ್ನಿಜ಼ ಖರ್ಚ಼ ಕರಾನು ಕಾ? ");
INSERT INTO sle_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ಎ ತೆಲ ಮೊಗು ಇಕ್ಕಿನ ಗರಿಬೊನೆ ದಿವಾನೆ ಥಾತುತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ಯೆಸುನೆ ಎ ಗ್ವತ್ತ ಥಾತಾಮಾ ತ್ಯುನೊನೆ , ಎ ಬಾಕ್ಡಿನೆ ಕಾ ತ್ರಾಸ ಕರಾಡ್ಯಾಸ? ಎ ಮನೆ ಚೊ಼ಕು ಕಾಮ ಕರಿಸ. ");
INSERT INTO sle_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ಗರಿಬೊ ಹಮೆಶಾಬಿ ತುಮಾಕ್ಹಾತೆ ರ‍್ಹವಸ್ತೊ, ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ಹಮೆಶಾಬಿ ರ‍್ಹತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ಎ ಬಾಕ್ಡಿ ಎ ತೆಲ ಮಾರಾ ಅಂಗ್ಪರ ರಿಚಾ಼ಯಲ ಮಾರಾ ಉತ್ತರ ಕ್ರೆಯೆನೆ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ, ಎ ಸುವಾರ್ತೆ ಕ್ಹಾರಿ ದುನಿಯಾಮಾ ಕವಸ ತ್ಯಾ ತ್ಯಾ ಎ ಬಾಕ್ಡಿನಾ ಹುತಿ ಶೆ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ತೆಳಾಮ ಬಾರಾ ಶಿಶ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ರ‍್ಹಯಲ ಇಸ್ಕರಿಯುತ ಯುದ ಕವಾಲೊ ಖಾಸ ಯಾಜಕೊಕನ ಗೈನ, ");
INSERT INTO sle_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ಮಿ ತಿನೆ ಧರಿನೆ ದಿವಾನೆ ತುಮೊನೆ ಮದತ ಕರ‍್ಯೊಮ ಮನೆ ತುಮೆ ಸು ದಿವೊಶಿ? ಕದ್ಯೊ. ತಿವ್ನೆ ತಿನೆ ಮುವತ್ತ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ತೆಳಾಮಾತಾ ತಿವ್ನೆ ತಿನೆ ಧರಾನಾ ಹುತಿ ಮೌಕೊ ದೆಕಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ಖಾಟೊ ನೈಸೊ ರೊಕ್ಲಾನೊ ಸನ್ನಾ ಪೈಲಾನಾ ದಿನ್ಮಾ ಶಿಶ್ಯಾ ಯೆಸುಕನ ಐನ, ಪಸ್ಕನು ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ಹಮೆ ತುನೆ ಕಿಜಾ಼ ತಯ್ಯಾರ ಕರುಕೈನ ಛೆ ಕೈನ ಪುಚ಼್ಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ತೆ ತ್ಯುನೊನೆ ಗಾಮ್ಮಾ ಗ ಮಿ ಕವದಲವಾಲಾಕನ ಗೈನ ತಿನೆ, ಮಾರೊ ಟೈಮ ನಜಿಕ ಆಯೊಸ , ಮಿ ಮಾರಾ ಶಿಶ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಪಸ್ಕ ಸನ್ನ ಕರುಸ ಕೈನ ಗುರು ಕವಾಡ್ಯೊಸ ಕೈನ ಕವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ಶಿಶ್ಯಾ ಯೆಸು ಕದಲ ತಿಮ್ಮಜ಼ ಪಸ್ಕಾನು ಅನ್ನ ತಯ್ಯಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ಕ್ಹಾಂಜ಼ ಥಾತಾಮಾ ತಿನಾ ಬಾರಾ ಶಿಶ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಖಾವಾನು ಹುತಿ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ತ್ಯುನೆ ಅನ್ನ ಖಾತಾಮಾ ತೆ , ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ ತುಮಾಮಾ ಯಕ್ಲೊ ಮನೆ ಧರೈನ ದಿವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ತೆಳಾಮಾ ತ್ಯುನೆ ಘನ್ನಾ ದುಖಿ ಥೈನ ಕರ್ತಾ, ಮಿ ವ್ಹೈ ಸು? ಕೈನ ಹರಿಯಕ್ಲೊ ಪುಚಾ಼ನು ಶುರುಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ತೆನೈಸೊ ಯೆಸು, \"ಕುಂಡಾಮಾ ಮಾರಾ ಕ್ಹಾತೆ ಹತ್ತ ಡುಬಾಲಯವಾಲೊ ಮನೆ ಧರಿನ ದಿವಾಲೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನಾ ವಿಷಯಮಾ ಬರದಲ ನಿಂಗತ ಗೈ ಪಡಸ; ತೆನೈಸೊ ಕುನಬಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಧರಿನ ದಿವಸ್ತೊ ತಿನೆ ಆಯೊ. ತೆ ಮನಕ್ಹ ನೈ ಹುಟ್ಟಾರೆ ಕೆಕ್ಲುಕಿ ಚೊಕೊ ರ‍್ಹತುತು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ತೆಳಾಮಾ ತಿನೆ ಧರಿನ ದ್ಯುಸ ಕೈನ ಕವಾಲೊ ಯುದಾ, ಪ್ರಭು ಮಿಜ ವ್ಹೈ? ಕೈನ ಪುಚ್ತಾಮಾ ಯೆಸು ತಿನೆ, ತು ತಿಮ್ಮ ಕದ್ಯೊತೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ತ್ಯುನೆ ಅನ್ನ ಕ್ಹಾತಾ ಟೈಮ್ಮಾ ಯೆಸು ರೊಕ್ಲೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕರಿನ ತೆ ತೊಡಿನ ಶಿಶ್ಯಾವೊನೆ ದಿನ, ಕಾಡಿಲಿವೊ, ಕ್ಹಾವೊ, ಎ ಮಾರು ಅಂಗ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ಪಾಚಲ್ತೊ ಪಾನಿನೊ ತಾಂಬ್ಯೊ ಲಿನ ಸ್ತೊತ್ರಾ ಕರಿನ ತ್ಯುನೊನೆ ದಿನ ಅಮಾ ರ‍್ಹವಾನೂ ಕ್ಹಾರಾಜ಼ನಾ ಪಿವೊ; ಎ ಮಾರು ರಗತ ವ್ಹೈ, ");
INSERT INTO sle_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ಎ ಮಾರು ರಗತ ವ್ಹೈ. ಪಾಪ ಮಾಫನಾಹುತಿ ಘನ್ನಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಚುವಾಯಲ ರಗತ. ");
INSERT INTO sle_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ಮಿ ಮಾರಾ ಬಾನಾ ರಾಜ್ಯಮಾ ತಾರಾ ಕ್ಹಾತೆ ನವು ದ್ರಾಕ್ಷರಕ್ಹ ಪಿವಾನಾ ದಿನ್ನ ಲಕ್ಕಾ ಹಜು಼ನ ಎ ಪಿತೊಜ಼ ನೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ ಕಿರ್ತನೆನು ಗಿದ್ದ ಕದಲ್ಪರ ತೆಲನಾ ಝಾಡೊನಾ ಡೊಂಗರ್ಪರ ಗೈಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ತೆಳಾಮಾ ಯೆಸು, ತ್ಯುನೊನೆ, ಕುರಬುರ‍್ಯಾನೆ ಮಾರುಸ; ಹಿಂಡನಾ ಬಕ್ರಾ ಭಿಕ್ಹರೈ ಜಾವಸ ಕೈನ ಬರದಲ ನಿಂಗತ ತುಮೆ ಕ್ಹಾರಾ ಆ ರಾತೆ ಮಾರಾ ವಿಷಯಮಾ ಪಾಚಾ ಸರಕಸ. ");
INSERT INTO sle_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ತೆನೈಸೊ ಮಿ ಜ್ಯುತ್ಯೊ ಥೈನ ಉಟಲ್ಪರ ತುಮಾರಾತಿ ಪೈಲಾಜ ಗಲಿಲಾಯನೆ ಜಾವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ತೆನೈಸೊ ಪೆತ್ರಾ ತಿನೆ, ಕ್ಹಾರಾಜ಼ನಾ ಮಾರಾ ವಿಷಯಮಾ ಘಾಬ್ರಾಥೈನ ಪಾಚಾ ಸರಕ್ಯಾ ಮಿತೊ ಕೆಳಾಮಾಜ ಪಾಚೊ಼ ಸರಕ್ತೊ ನೈ ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ಯೆಸು ಪೆತ್ರಾನೆ, ತುನೆ ಕ್ಹರಿಜ಼ ಕೌಸ, ಎಜ಼ ರಾತಮಾ ಕುಕ್ಡೊ ಬಾಂಗದಿವಾತಿ ಪೈಲಾಜ಼ ತು ಮನೆ ತನ್ನ ಸಲಾ ಒಪ್ಪಿಲೆತೊ ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ಪೆತ್ರಾ ತಿನೆ ಮಿ ತಾರಾ ಕ್ಹಾತೆ ಮರಣ ಆಯುತಬಿ ಮಿ ತುನೆ ಇನ್ಕಾರ್ತೊ ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತಿನಾ ಶಿಶ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಗೆತ್ಸಮನೆ ಮಳಾಮಾ ಐನ ತ್ಯುನೊನೆ, ನ್ಹ್ಯಾಜ಼ ಬೈಟೊ, ಮಿ ಬಿಜಿಬಗಲ ಗೈನ ಪ್ರಾಥನಾ ಕರುಸ ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ಪೆತ್ರಾನೆ ಜೆಬೆದಾಯನಾ ಭಂಬಿ ದಿಕ್ರಾವೊನೆ ಅಗೊ ಬಲೈಲಿನ ಗೈನ ದುಖಿ ಥೈನ ಮನಸ ದುಖಕರ್ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ವರಿ ತ್ಯುನೊನೆ ಮಾರಾ ಜ಼ಲಮ ಮರಾನಾ ಯಕ್ಲು ದುಖಮಾ ಪಡ್ಯುಸ; ತುಮೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹೈನ ಮಾರಾ ಕ್ಹಾತೆ ಹುಶಾರ ರ‍್ಹವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ತೆ ದಕ್ಹೊ ಅಗೊ ಗೈನ ಉಂದೊ ಪಡಿನ, ಮಾರಾ ಬಾ, ತುಕನ ಸಾದ್ಯ ಥಯುರೆ ಎ ತ್ರಾಸನೊ ಘಡೊ ಮನೆ ಛೊಡಿನ ಜಾ಼ವಾದೆ; ತೆನೈಸೊ ಮಾರಿ ಚಿತ್ತನಾ ಪ್ರಕಾರ ಥಯಾವಾಚಿ ತಾರಿ ಚಿತ್ತ ಲಿಂಗತಜ಼ ಥಾವಾದೆ ಕೈನ ಕ್ಹುದಾನೆ ಪ್ರಾರ್ಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ಪಾಚ಼ಲ್ತೊ ತೆ ಶಿಶ್ಯಾವೊಕನ ಜಾ಼ತಾಮಾ ತ್ಯುನೆ ನಿಂದರ ಕರಾನು ದೆಕಿನ ಪೆತ್ರನೆ, ಯಕ್ಕ ಟೈಮತುಬಿ ಮಾರಾ ಕ್ಹಾತೆ ಹುಶಾರ ರ‍್ಹತಾ ನೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ಶೊದನೆಮಾ ಮ್ಹೈ ಥಯಾ ಬಗರ ಹುಶಾರ ರ‍್ಹೈನ ಪ್ರಾರ್ಥನಾ ಕರೊ; ಆತ್ಮಾ ಸಿದ್ದ ಥೈಸ ತೆನೈಸೊ ಅಂಗ ಬಲಹಿನ ಥಯುಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ಫರಿನ ಬೆವಾಸಲಾ ಗೈನ, ಮಾರಾ ಬಾ, ಮಿ ತ್ರಾಸ ಖಾದ್ಯಾ ಬಗರ ಎ ತ್ರಾಸ ಮನೆ ಛೊಡಿನ ಜಾ಼ತು ನೈ ಕವಾನು ರ‍್ಹಯಮ ತಾರಿ ಚಿತ್ತ ಲಿಂಗತ ಥಾವಾದೆ ಕೈನ ಕ್ಹುದಾನೆ ಪ್ರಾರ್ಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ತೆ ಫರಿನ ಆಯಲ್ಪರ ತ್ಯುನೆ ನಿಂದರ ಕರಾನು ದೆಕ್ಯೊ; ತ್ಯುನಾ ಡೊಳಾ ವಜ್ಜಾ಼ ಥಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ತೆ ಥಯಲ್ಪರ ವರಿ ತ್ಯುನೊನೆ ಛೊಡಿನ ಗೈನ ಫರಿನ ತೆಜ಼ ವಾತೊ ಕತೊ ತನ್ವಾ ಸಲಾಬಿ ಪ್ರಾರ್ಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ಪಾಚಲ್ತೊ ತೆ ಶಿಶ್ಯಾವೊಕನ ಐನ ತ್ಯುನೊನೆ, ತುಮೆ ಹಜು಼ನ ನಿಂದರ ಕರಿನ ಅರಾಮ ಕರಾಡಾಸ ಸು; ದೆಕೊ, ತೆ ಟೈಮ ನಜಿಕ ಆಯುಸ, ಹಮ್ನಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಪಾಪಿಸ್ಟೊನಾ ಹತೆ ಒಪ್ಸಾಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ಉಟೊ, ಗಯ್ಯೆ; ಮನೆ ಧರೈನ ದಿವಾಲೊ ನಜಿಕ ಆಯೊಸ ದೆಕೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ಯೆಸು ಹಜು಼ನ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾಜ, ಬಾರಾ ಶಿಶ್ಯಾವೊಮಾ ಯಕ್ಲೊ ಥಯಲ ಯುದ ಆಯೊ. ಕ್ಹಾಸ ಯಾಜಕೊನಾ ವರಿ ಮನಕ್ಹೊನಾ ಶಾನಾವೊಕಂತಾ ಘನ್ನಾ ಜ಼ನಾವೊನು ಗುಂಪ ಚಾಕಾ, ಗುಂಡಕಾ ಲಿನ ತಿನಾ ಕ್ಹಾತೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ತೆಜ಼ ನೈಸೊ ತಿನೆ ಧರಿನ ದಿವಾಲೊ ತ್ಯುನೊನೆ, ಮಿ ಕಿನೆ ಮಟ್ಟಿ ದ್ಯುಸ ತೆಜ಼ ತೆ ವ್ಹೈ; ತಿನೆ ಧರೊ ಕೈನ ಪೈಲಾಜ಼ ಕದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ತೆಳಾಮಾಜ಼ ತೆ ಯೆಸುಕನ ಐನ, ಗುರು ನಮಸ್ಕಾರ ಕೈನ ತಿನೆ ಮಟ್ಟಿ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ, ದೊಸ್ತ, ತು ಶಾನೆ ಆಯೊಸ ಕೈನ ಕದ್ಯೊ. ತ್ಯುನೆ ನಜಿಕ ಐನ ಯೆಸುನಾ ಉಪ್ಪರ ಹತ್ತ ಘಾಲಿನ ತಿನೆ ಧರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲಮಾ ಯಕ್ಲೊ ಹತ್ತ ಚಾಚಿನ ತಿನು ಚಾಕು ಕಾಡಿನ ಮಹಾಯಾಜಕನಾ ಆಳನೆ ಮಾರಿನ ತಿನು ಕಾನ ಕತ್ರಿಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ, ತಾರು ಚಾಕು ಫರಿನ ಮ್ಯಾನಮಾ ಘಾಲ; ಚಾಕು ಧರ‍್ಯಲವಾಲಾ ಕ್ಹಾರಾ ಚಾಕಾಕ್ಹು ನಾಶ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ಮಿ ಮಾರಾ ಬಾನೆ ಮಾಂಗಿ ನೈ ಲೆಸಕ್ತೊ ಸು, ಮಾಂಗಿಲಿದ್ಯೊಮ ತೆ ಮನೆ ಹಮ್ನಾಜ಼ ಬಾರಾ ಗುಂಪತೊಬಿ ಜಾಸ್ತ ಜ಼ನಾ ದೆವದುತೊ ನೈ ವಳಾತೊ ನೈ ಕೈನ ವಿಚಾರ ಕರ್ಶಿಸು? ");
INSERT INTO sle_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ವಳಾಯೊಮ ಮನೆ ಅಮ್ಮ ತಿಮ್ಮ ಥೌ ಕವಾನಾ ಶಾಸ್ತ್ರನಾ ವಾತೊ ಪುರಾ ಥಾವಾನುತಬಿ ಕಿಮ್ಮ ವ್ಹೈ? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ತೆಜ಼ ಟೈಮಮಾ ಯೆಸು ಗುಂಪ ಥೈನ ಆಯಲ ಮನಕ್ಹೊನೆ, ಚ್ವಟ್ಟಾನೆ ಧರಾನೆ ಆಯೆ ಲಿಂಗತ ಚಾಕಾ ಗುಂಡಕಾ ಲಿನ ಮನೆ ಧರಾನಾಹುತಿ ಆಯಾಸ ಸು? ಮಿ ಹರ ದಿನ್ನ ದೆವಾಲಯಮಾ ಬೈಟಿನ ಬೊದನೆ ಕರ‍್ತಾಮಾ ತುಮೆ ಮನೆ ಧರ‍್ಯಾ ನೈತೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ತೆನೈಸೊ ಪ್ರವಾದಿಯೊ ಬರ್ದಲ ವಚನಾ ಪುರಾ ಥಯೆ ಲಿಂಗತ ಎ ಕ್ಹಾರು ಥಯು ಕೈನ ಕದ್ಯೊ. ತೆಳಾಮಾ ಕ್ಹಾರಾ ಶಿಶ್ಯಾ ತಿನೆ ಛೊಡಿನ ನ್ಹಾಟಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ಯೆಸುನೆ ಧರಲವಾಲಾ ತಿನೆ ಮಹಾಯಾಜಕ ಥಯಲ ಕಾಯಫಕನ ಬಲೈಲಿನ ಗಯಾ, ತ್ಯಾ ಶಾಸ್ತ್ರಿಯೊ ಶಾನಾ ಮಳಿನ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ತೆನೈಸೊ ಪೆತ್ರಾ ದುರತೊ ತಿನೆ ಪಾಚೊ಼ಲಾಗಿನ, ಮಹಾಯಾಜಕನಾ ಭವನನಾ ಅಂಗಳಾಮಾ ಮ್ಹೈ ಐನ ತಿನೆ ಸು ಥಾವಸ ದೆಕು ಕೈನ ಸೈನಿಕೊನಾ ಕ್ಹಾತೆ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ತೆಳಾಮಾ ಕ್ಹಾಸ ಯಾಜಕೊ ಮ್ಹೊಟಿ ಸಬೆವಾಲಾ ಕ್ಹಾರಾ ಯೆಸುನೆ ಖಲಾಸ ಕರೌ ಕೈನ ತಿನಾ ಉಪ್ಪರ ಸುಳ್ಳ ಸಾಕ್ಷಿಯೊ ಹುಡಕ್ಯಾ; ತೆನೈಸೊ ಘನ್ನಾ ಜ಼ನಾ ಸುಳ್ಳ ಸಾಕ್ಷಿಯೊ ಅಗಾ ಆಯಾತಬಿ ಸುಜ಼ ಮಳ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ಪಾಚ಼ಲ್ತಾ ಬೆ ಜ಼ನಾ ಕ್ಹಾಮಾ ಐನ, ");
INSERT INTO sle_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ಮಿ ಕ್ಹುದಾನಿ ಆಲಯ ಕೆಡಶಿನ ತನ್ನ ದಿನ್ನಮಾ ಫರಿನ ಭಾಂದಸಕುಸ ಕೈನ ‘ಎ ಮನಕ್ಹ ಕದ್ಯೊ’ ಕದ್ಯಾ; ");
INSERT INTO sle_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ತೆಳಾಮಾ ಮಹಾಯಾಜಕ ಉಟಿನ ಹುಬ್ರೈನ, ತು ಸು ನೈ ಕತೊ ಸು? ಇವ್ನೆ ತಾರಾ ಉಪ್ಪರ ಘಾಲಾನಾ ಆರೊಪ ಕ್ಹರಿಜ಼ ವ್ಹೈ ಸು? ಕೈನ ತಿನೆ ಪುಚ್ಯೊ. ತೆನೈಸೊ ಯೆಸು ಗಪ್ಪ ಚುಪ್ಪ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ಮಹಾಯಾಜಕ ಯೆಸುನೆ, ತುನೆ ಜಿವ್ತೊ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ಉಪ್ಪರ ಖಮ್ಮ ಘಾಲಿನ ಪುಚ್ಚಾ಼ಡೊಸ; ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಥಯಲ ಕ್ರಿಸ್ತ ರ‍್ಹಯೊಮ, ಹಮೊನೆ ಕೌ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ಯೆಸು ತಿನು ಜವಾಬ ದಿನ, ತು ಕವಾಡೊಸ; ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ, ಇನಾ ಉಪ್ಪರ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸರ್ವಶಕ್ತನಾ ಸಿದಾ ಬಗಲ ಬೈಟಲ ರ‍್ಹವಾನು, ಹಬಾಳನಾ ಉಪ್ಪರ ಬೈಟಿನ ಆವಾನು ದೆಕೊಶಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ತೆಳಾಮಾ ಮಹಾಯಾಜಕ ತಿನಾ ವಣ್ಣಾ ಫಾಡಿಲಿನ, ಎ ಕ್ಹುದಾನಿ ದುಷಣೆನಾಹುತಿ ಬೊಲ್ಯೊಸ; ಹಮೊನೆ ಸಾಕ್ಷಿಯೊ ವರಿ ಶಾನೆ ಚಾ಼ಯೆ? ದೆಕೊ ಎ ಹಮ್ನಾ ಕದಲ ದುಷಣೆನಿ ವಾತ ಐಕ್ಯಾಸತೊ; ");
INSERT INTO sle_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ತುಮೊನೆ ಕಿಮ್ಮ ಲಾಗಸ? ಕತಾಮಾ, ಇ ಮರಣನಿ ಶಿಕ್ಷಾನೆ ಲಾಯಕ ವ್ಹೈ ಕೈನ ತ್ಯುನೆ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ತೆಳಾಮಾ ತ್ಯುನೆ ತಿನಾ ಮ್ಹೊಡಾನಾ ಉಪ್ಪರ ಗುದ್ಯಾ; ದಕ್ಹಾ ಜ಼ನಾ ತಿನಾ ಗಾಲೆ ಮಾರಿನ, ");
INSERT INTO sle_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ಕ್ರಿಸ್ತ, ತುನೆ ಮಾರ‍್ಯಲವಾಲಾ ಕುನ್ನ ವ್ಹೈ? ಹಮೊನೆ ಪ್ರವಾದನೆ ಕೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ತೆಳಾಮಾ ಪೆತ್ರಾ ಭಾರೊ ಅಂಗ್ಳಾಮಾ ಬೈಟ್ಯೊತೊ. ತ್ಯಾ ಯಕ್ಕ ದಾಸಿ ತಿಕನ ಐನ, ತುಬಿ ಗಲಿಲಾಯಮಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲೊ ವ್ಹೈನೈ ಕತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ತೆ ಇನ್ಕಾರ ಕರಿನ, ತು ಕವಾಡೊಸ ಮನೆ ಗೊತ್ತ ನತ್ತಿ ಕೈನ ಕ್ಹಾರಾ ಜ಼ನಾವೊಕನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ತೆ ತ್ಯಾಂತ್ಯೊ ಬಾಕಲನ ಜಾ಼ತಾಮಾ ಹಜಿ಼ಯಕ್ಲಿ ದಾಸಿ ತಿನೆ ದೆಕಿನ ತ್ಯಾ ರ‍್ಹಯಲವಾಲಾವೊನೆ, ಆ ನಜ಼ರೆತನೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲೊ ವ್ಹೈ ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ತೆ ಫರಿನ ಇನ್ಕಾರ ಕರಿನ ಕ್ಹಮ್ಮ ಘಾಲಿನ, ತೆ ಮನಕ್ಹನೆ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ದಕ್ಹೊ ಟೈಮ ಥಾತಾಮಾ ತ್ಯಾ ಹುಬ್ರೆಲವಾಲಾ ಕ್ಹಾಮಾ ಐನ ಪೆತ್ರಾನೆ, ನಿಶ್ಚಯಥೈನ ತುಬಿ ತ್ಯುನಾಮಾ ಯಕ್ಲೊ ವ್ಹೈ, ತಾರಿ ಜಾತ ತುನೆ ಗಲಿಲಾಯಲವಾಲೊ ವ್ಹೈ ಕೈನ ದೆಕ್ಲಾಡಿನ ದಿವಸ ಕೈನ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ತೆ, ಶಾಪ ಘಾಲ್ಲಿಲಿವಾನಾಹುತಿ ಶುರು ಕರಿನ ಕ್ಹಮ್ಮ ಘಾಲಿನ, ತೆ ಮನಕ್ಹ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಮೆ ಗ್ವತ್ತ ನತ್ತಿ. ಕೈನ ಕದ್ಯೊ. ತೆಳಾಮಾ ಕುಕ್ಡೊ ಬಾಂಗ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ಪೆತ್ರಾನೆ ಯೆಸು, ಕುಕ್ಡೊ ಬಾಂಗ ಲಿವಾತಿ ಪೈಲಾಜ಼ ತನ್ನ ಸಲಾ ಮನೆ ಇನ್ಕಾರ ಕರಿನ ಕಸಿ ಕೈನ ಕದಲ ವಾತನೆ ಸ್ಹೆಂ ಕರಲಿನ ಭಾರಾ ಗೈನ ಘನ್ನೊ ದುಖ ಪಡ್ದಿನ ರೊಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ಪಾಟ ಥಾತಾಮಾ ಕ್ಹಾರಾ ಕ್ಹಾಸ ಯಾಜಕೊ, ಶಾನಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಯೆಸುನೆ ಕಲಾಸ ಕರು ಕೈನ ಪ್ಲ್ಯಾನ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ತಿನೆ ಭಾಂದಿನ ಬಲೈಲಿನ ಗೈನ ದೆಶಾದಿಪತಿ ಥಯಲ ಪೋನಥ್ಯ ಪಿಲಾತಕನ ಒಪ್ಸಿನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ತೆಳಾಮಾ ತಿನೆ ಮೊಸಕ್ಹು ಧರೈನ ದಿದಲ ಯುದ ಯೆಸುನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ಥಯಲ ದೆಕಿನ , ಪಶ್ಚಾತಾಪ ಪಡಿನ ತೆ ಮುವತ್ತ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಖಾಸ ಯಾಜಕೊನೆ ಷಾನಾವೊನೆ ವಾಪಾಸ ದಿಪಾಡ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","\"ನಿರಪರಾಧಿನೆ ಮನಣನಿ ಶಿಕ್ಷಾನೆ ವಪ್ಸಿನ ದಿದಲ ಮಿ ಪಾಪ ಕರ‍್ಯೊಸ ಕದ್ಯೊ. ತೆಳಾಮಾ ತ್ಯುನೆ ಹಮೊನ ಸು ವೈ? ತುಜ಼ ದೆಕಿಲೆ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ತೆಳಾಮಾ ತೆ ದೆವಾಲಯಮಾ ತೆ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ನಾಕಿನ ಗೈನ ಪಾಕ್ಹೊ ಘಾಲ್ಲಿನ ಮರಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ಖಾಸ ಯಾಜಕೊ ತೆ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಲಿನ ಎ ಜಿವ ಹತ್ಯೆನೆ ದಿದಲ ಕಿಮ್ಮತ ರ‍್ಹಯಲಹುತಿ ಎ ಕಾಣಿಕೆನಿ ಪೆಟಗಿಮಾ ಘಾಲು ನೈ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ಪಾಚಾ಼ತಾ ವಿಚಾಲ ಕರಿನ ಬಿಜಾ಼ ದೆಶವಾಲಾವೊನೆ ಮರಲವಾಲಾವೊನೆ ಮಜಾ಼ರ ಕರಾನಾ ಹುತಿ ತೆಜ಼ ದೊಕ್ಡಾವೊಮಾ ತೆ ಜ಼ಗಾ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ಎನಾಹುತಿ ಹಜು಼ನಲಕ್ಕಾಬಿ ತೆ ಖೆತರ್ನೆ ಜ಼ಲಮ ಕಾಡಲ ಖೆತರ ಕೈನ ನಾಮ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ತೆ ಸುವೈ ಕ್ಯಾಮ ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊಕ್ಹು ತಿನೆ ಫಯಸಲೊ ಕರಿನ ಕಿಮ್ಮತ ರ‍್ಹಯಲ ತೆ ರುಪ್ಪಾನಾ ಮುವತ್ತ ಬಿಲ್ಲಾ ಲಿನ, ಕರ್ತಾ ಮನೆ ಅಪ್ಪಣೆ ದಿದಲ ನಿಂಗತ ");
INSERT INTO sle_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ತೆ ತ್ಯುನೆ ಕುಂಬಾರನಾ ಖೆತರ್ನೆ ದಿದ್ಯಾ. ಇಮ್ಮ ಪ್ರವಾದಿ ಥಯಲ ಯೆರೆಮಿಯಾ ಕದಲ ವಾತ ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ಯೆಸು ದೆಶಾದಿಪತಿನಾ ಕ್ಹಾಮೊ ಹುಬ್ರೆತಾಮಾ ದೆಶಾದಿಪತಿ ತಿನೆ ತು ಯಹುದ್ದಿಯೊನೊ ರಾಜೊ಼ ವ್ಹೈ ಸು?ಕೈನ ಪುಚ್ಯೊ. ಯೆಸು ತಿನೆ ತುಜ಼ ಕದ್ಯೊತೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ವರಿ ಖಾಸ ಯಾಜಕೊ ಶಾನಾ ಮನಕ್ಹೊ ತಿಪರ ತಪ್ಪ ಗಾಲ್ತಾ ರ‍್ಹತಾಮ ತೆ ಸುಜ಼ ಕದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ತೆಳಾಮಾ ಪಿಲಾತನ, ತಾರಾ ವಿರುದ್ದ ಯಕಲಿಯೊ ಸಾಕ್ಷಿ ಕವಾಡ್ಯಾಸ, ತುನೆ ಐಕು ನತ್ತಿ ಆವಾಡ್ಯುಸು?ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ತೆನೈಸೊ ಪಿಲಾತನೆ ಸುಜ಼ ಉತ್ತರ ದಿದ್ಯೊ ನೈ ತೆಳಾಮಾ ಪಿಲಾತನ ಘನ್ನೊ ಘಾಬ್ರೊ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ತೆನೈಸೊ ತೆ ಸನ್ನಮಾ ಮನಕ್ಹೊ ಆಸ ಕರಾನಾ ಜೈಲಮಾ ರ‍್ಹಯಲವಾಲಾನೆ ತ್ಯುನೆ ಛೊಡಾನು ದೆಶನಾ ಅದಿಪತಿನಿ ಪದ್ದತ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ತೆ ಟೈಮಮಾ ಬರಬ್ಬ ಕವಾನೊ ಪ್ರಸಿದ್ದ ರ‍್ಹಯಲ ಯಕ್ಕ ಕೈದಿ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತ್ಯುನೆ ಮಳಿನ ಆಯಲ ಟೈಮಮಾ ಪಿಲಾತನ, ತುಮಾರಾಹುತಿ ಕಿನೆ ಛೊಡು ಕೈನ ಆಸ ಛೆ? ಬರಬ್ಬನೆ ಸು ತೆನೈಸೊ ಕ್ರಿಸ್ತ ಕೈನ ಕವೈಲಿವಾಲಾ ಯೆಸುನೆ ಸು? ಕೈನ ತ್ಯುನೊನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ತಿಪರ ವಿರುದ್ದ ರ‍್ಹಯಲಕ್ಹು ಇಮ್ಮ ಕರ‍್ಯಾಸ ಕೈನಪಿಲಾತನನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ತೆನೈಸೊ ತೆ ಫೈಸ್ಲೊ ಕರಾನಾ ಕಟ್ಟಾಪರ ಬೈಟಲ ಟೈಮಮಾ ತಿನಿ ಬೈಕೊಬಿ, ತು ತೆ ನಿತಿವಂತನಾ ಮನಕ್ಹನಾ ಉಸಾಬರಿನೆ ಜೌ ನಕೊ; ತಿನಾಹುತಿ ತೆ ಟೈಮಮಾ ಕ್ಹಪನಮಾ ಘನ್ನಿ ತ್ರಾಸ ಖಾದಿಸ ಕೈನ ತಿಕನ ಗೈನ ಸುದ್ದಿ ಕೈನ ಮೊಕ್ಲಿ. ");
INSERT INTO sle_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ತೆನೈಸೊ ಕ್ಹಾಸ ಯಾಜಕೊ ಶಾನಾ ಬರಬ್ಬನೆ ಛೊಡು ಕೈನ ಮಾಂಗಿಲಿವಾನೆಬಿ ಯೆಸುನೆ ಖಲಾಸ ಕರು ಕೈನ ಐಕು ಆಯೆಲಿಂಗತ ಮನಕ್ಹೊನೆ ಕೈನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ತಿನಾಹುತಿ ದೆಶನೊ ಅದಿಪತಿ ತ್ಯುನೊನೆ, ಎ ಬೆ ಜ಼ನಾವೊಮಾ ಕಿನೆ ತುಮಾರಾಹುತಿ ಛೊಡು ಕೈನ ಕವೊಶಿ? ಕೈನ ಪುಚ್ತಾಮಾ ತ್ಯುನೆ ಬರಬ್ಬನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ಪಿಲಾತನ ತ್ಯುನೊನೆ, ತಿಮ್ಮ ರ‍್ಹಯಾಮ ಕ್ರಿಸ್ತ ಕೈನ ಕವೈಲಿವಾನಾ ಯೆಸುನೆ ಮಿ ಸು ಕರು? ಕೈನ ಪುಚ್ತಾಮಾ ಕ್ಹಾರಾ ಜ಼ನಾ, ತಿನೆ ಶಿಲುವಿಪರ ಘಾಲಾಲಗಾಡ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ತಿನಾಹುತಿ ತೆ ಕಾ ಆಂ ಕರಲ ಅಪರಾದತಬಿ ಸು ವ್ಹೈ? ಕದ್ಯೊ. ತೆನೈಸೊ ತ್ಯುನೆ, ತಿನೆ ಶಿಲುವಿಪರ ಘಾಲಾಲಗಾಡ ಕೈನ ಘನ್ನಾ ಅಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ಮನಕ್ಹೊನು ಮನಸ ಬದ್ಲಿ ಕರಾನೆ ತಿನೆ ನೈ ಥಾತು ಕೈನ ಮನಕ್ಹೊ ವದ್ರಾನು ಚಾಲು ಕರಸ ಕವಾನು ತಿಳ್ದಿಲಿದಲ ಪಿಲಾತನ ದಕ್ಹು ಪಾನಿ ಲಿನ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ತಿನಾ ಹತೊ ಧ್ವೈಲೆತೊ, \"ಎ ಮನಕ್ಹನಾ ಮರಣನೆ ಮಿ ಜವಾಬ್ದಾರ ನ್ಹವೈ. ತಿನೆ ಶಿಲುವಿಪರ ಘಾಲಾಲಾ ತುಮೆಜ಼ ವ್ಹೈ!” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ಕ್ಹಾರಾ ಮನಕ್ಹೊ, \"ತಿನಾ ಮರಣನೆ ಹಮೆಜ಼ ಜವಾಬ್ದಾರ ವ್ಹೈ. ತಿನಾ ಮರಣನೆ ಕಯುತಬಿ ಶಿಕ್ಷಾ ರ‍್ಹಯಾಮ ತಿನೆ ಹಮೆ ವರಿ ಹಮಾರಾ ಬಚ್ಚಾ಼ ಅನುಬೊಸೆಸ” ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ತೆಳಾಮಾ ಪಿಲಾತನ ಬರಬ್ಬನೆ ಬಿಡುಗಡೆ ಕರಿನ, ಯೆಸುನೆ ಬಾರಕೊಲೆ ಮಾರಾಲಗಾಡಿನ ಶಿಲುವಿಪರ ಛಡಾವಾನೆ ಸೈನಿಕೊನೆ ಒಪ್ಸಿನ ದಿದ್ಯೊ.. ");
INSERT INTO sle_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ಪಿಲಾತನಾ ಸೈನಿಕೊ ಯೆಸುನೆ ರಾಜ್ಯ ಭವನಮಾ ಬಲೈ ಲಿನಗಯಾ. ಕ್ಹಾರಾ ಸೈನಿಕೊ ಯೆಸುನಾ ಸುತ್ತೆ ಹುಬ್ರಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ಸೈನಿಕೊ ತಿನಾ ವಣ್ಣಾ ಕಾಡಿನ ತಿನೆ ಯಕ್ಕ ಲಾಲ ಅಂಗಡು ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ಕಾಟಾವೊನಿ ಬಳ್ಳಿಕ್ಹು ಯಕ್ಕ ಕಿರಿಟ ಕರಿನ ತಿನಾ ಮಾತಾಪರ ಮ್ಹೆಲ್ಯಾ. ತಿನಾ ಸಿದಾ ಹತೆ ಯಕ್ಕ ಲಾಕ್ಡಿ ದಿದ್ಯಾ. ಪಾಚ಼ಲ್ತಾ ಸೈನಿಕೊ ಯೆಸುನಾ ಕ್ಹಾಮಾ ಡೊಗ್ಗಿನ, \"ಯಹುದ್ಯನಾ ರಾಜಾ಼, ನಮಸ್ಕಾರ” ಕೈನ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ತಿನಾ ಉಪ್ಪರ ಥುಕ್ಯಾ. ತಿನಾ ಹತ್ಮಾನಿ ಲಾಕ್ಡಿ ಲಿನ ಮಾತಾಪರ ಮಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ಇಮ್ಮ ಕದ್ರಾಯಲಪರ, ತಿನು ಅಂಗ್ಡು ಕಾಡಿನ ತಿನಾ ವಣ್ಣಾ ವರಿ ತಿನೆ ಘಾಲಿನ ಶಿಲುವಿಪರ ಘಾಲಾನೆ ಬಲೈಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ಸೈನಿಕೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ಗಾಮತಾ ಭಾರಾ ಜಾ಼ತಾಮಾ ಸಿರೆನ ಗಾಮನಾ \"ಸಿಮೊನ” ಕವಾಲಾ ಮನಕ್ಹನೆ ದೆಕ್ಯಾ. ತಿನಿ ಶಿಲುವಿ ಉಚೈಲಿವಾನಾಹುತಿ ತ್ಯುನೆ ತಿನೆ ಜ಼ಬರದಸ್ತಿ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ತ್ಯುನೆ ಗೊಲ್ಗೊಥಾ ಕವಾನಾ ಜ಼ಗಾಯೆ ಆಯಾ. (ಗೊಲ್ಗೊಥಾ ಕದ್ಯಾಮ \"ಕಪಾಲ ಜ಼ಗಾ” ಕೈನ ಮತ್ಲಬ ವ್ಹೈ.) ");
INSERT INTO sle_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ಗೊಲ್ಗೊಥಾಮಾ ಸೈನಿಕೊ ತಿನೆ ಪಿವಾನೆ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ದಿದ್ಯಾ. ತೆ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹನೆ ದುಕ ಕಮ್ಮ ಕರಾನು ವಕ್ಹಡ ಮಳಾಯಾತಾ. ತೆ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹನು ಸ್ವಾದ ದೆಕಿನ ತಿನೆ ಪಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ಸೈನಿಕೊ ತಿನೆ ಶಿಲುವಿಪರ ಮೊಳಾವೊಕ್ಹು ಮಾರ‍್ಯಾ. ಪಾಚ಼ಲ್ತಾ ವಣ್ಣಾವೊನಾಹುತಿ ತ್ಯುನಾಮಾಜ಼ ಚಿಟಿ ಘಾಲಿನ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ಸೈನಿಕೊ ಯೆಸುನೆ ಕೈದತಾ ತ್ಯಾಜ಼ ಬೆಟ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ತೆನೈಸೊ ತಿನಾ ಉಪ್ಪರ ಘಾಲಲ ಅಪರಾದನೆ ಲಿಕ್ಕಿನ ತಿನಾ ಮಾತಾನಾ ಉಪ್ಪರ ಲಗಾಡ್ಯಾ. \"ಎಜ಼ ಯೆಸು ವ್ಹೈ, ಯಹುದ್ಯೊನೊ ರಾಜೊ಼ ವ್ಹೈ” ಕವಾನುಜ಼ ತೆ ಅಪರಾದ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ಯೆಸುನಾ ಬಾಜು಼ಮಾಜ಼ ಬೆ ಚ್ವಟ್ಟಾವೊನೆ ಶಿಲುವಿಪರ ಘಾಲ್ಯಾತಾ. ಯಕ್ಕ ಚ್ವಟ್ಟಾನೆ ಯೆಸುನಾ ಸಿದಾ ಬಗಲಬಿ ವರಿಯಕ್ಕ ಚ್ವಟ್ಟಾನೆ ಡಾವಾ ಬಗಲ ಘಾಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ವಾಟಮಾ ಜಾ಼ವಾನಾ ಮನಕ್ಹೊ ಗರ್ದನ ಹಲ್ಲಾತಾ, ");
INSERT INTO sle_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","\"ತು ದೆವಾಲಯನೆ ಪಾಡಿನ, ತಿನೆ ವರಿ ತನ್ನ ದಿನ್ನಮಾ ಭಾಂದುಸ ಕೈನ ಕವಾಡೊತೊ. ತೆನೈಸೊ ಹಮ್ನಾ ತುನೆ ತುಜ಼ ವಚಾ಼ಡಿಲೆ! ತು ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಥಯಲ ರ‍್ಹಯೊಮ, ಶಿಲಿವಿಪರತೊ ಹೆಟೊ ಉತ್ರಿನ ಆ!” ಕೈನ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ಮಹಾಯಾಜಕೊ ಧರ್ಮ ಉಪದೆಶಕೊ ವರಿ ಯಹುದ್ಯನಾ ಶಾನಾ ತ್ಯಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆಬಿ ಬಿಜಾ಼ ಮನಕ್ಹೊ ಲಿಂಗತ ಯೆಸುನೆ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"ಎ ಬಿಜಾ಼ವೊನೆ ವಚಾ಼ಡ್ಯೊ. ತೆನೈಸೊ ತಿನೆ ತೆಜ಼ ನೈ ವಚಾ಼ಡಿಲೆಸಕ್ತೊ! ಇಸ್ರಾಯೆಲನೊ ರಾಜ಼ೊ ವ್ಹೈ ಕೈನ ಮನಕ್ಹೊ ಕವಸ. ಎ ರಾಜೊ಼ ರ‍್ಹಯೊಮ ಶಿಲುವಿಪರತೊ ಹೆಟೊ ಉತ್ರಿನ ಆವಾದೆ. ತೆಳಾಮಾ ಹಮೆ ಇನೆ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ಎ ಕ್ಹುದಾನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯೊತೊ. ಹಮ್ನಾ ಕ್ಹುದಾನೆ ಕ್ಹರಿಬಿ ಎ ಛಾಯೆ ಥಯಲ ರ‍್ಹಯೊಮ, ಕ್ಹುದಾಜ಼ ಅನೆ ವಚಾ಼ಡಾದೆ. ‘ಮಿ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ’ ಕೈನ ಎಜ಼ ಕೈಲಿದ್ಯೊಸತೊ” ಕೈನ ತ್ಯುನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ತಿನಾಲಿಂಗತಜ಼ ಯೆಸುನಾ ಆಜು಼ ಬಾಜು಼ಮಾ ಶಿಲುವಿಪರ ಘಾಲಲ ಚ್ವಟ್ಟಾಬಿ ತಿನೆ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ತೆ ದಿನ್ನೆ ದುಪ್ಪಾರೆ ಬಾರಾ ವಾಸ್ತಾತಾ ತನ್ನ ವಾಜೆ ಲಕ್ಕಾ ಪುರಾ ದೆಶಮಾ ಅಂದಾರು ಭರ‍್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ಕಮ್ಸಿಕಮ್ಮ ತನ್ನ ವಾಸ್ತಾ ಯೆಸು, \"ಎಲಿ, ಎಲಿ, ಲಮಾ ಸಬಕ್ತಾನಿ? ಕೈನ ಮ್ಹೊಟಿ ಅವಾಜ಼ಕ್ಹು ವದ್ರ್ಯೊ. ಅಮ್ಮ ಕದ್ಯಾಮ, \"ಮಾರಾ ಕ್ಹುದಾ, ಮಾರಾ ಕ್ಹುದಾ, ಕಾ ಮನೆ ಹತ್ತ ಛೊಡ್ಯೊ?” ಕೈನ ಮತ್ಲಬ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ತ್ಯಾ ಹುಬ್ರಯಲ ದಕ್ಹಾ ಮನಕ್ಹೊ ಎ ಐಕಿನ, \"ಆಂ ಎಲಿಯಾನೆ ಬಲಾವಾಡೊಸ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ತೆ ಮನಕ್ಹೊಮಾ ಯಕ್ಲೊ ನ್ಹಾಟಿನ ಗೈನ ಸ್ಪಂಜ ಲಿನ ಐನ, ತಿಮಾ ಕ್ಹಾಟು ರಕ್ಹ ಭರಿನ, ತಿನೆ ಯಕ್ಕ ಲಾಕ್ಡಾನೆ ಭಾಂದಿನ ತೆ ಲಾಕ್ಡಾಕ್ಹು ಸ್ಪಂಜ ಯೆಸುನೆ ಪಿವಾನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ತೆನೈಸೊ ಬಿಜಾ಼ ಮನಕ್ಹೊ, \"ತಿನಾಹುತಿ ಚಿಂತಾ ಕರು ನಕೊ, ತಿನೆ ವಚಾ಼ಡಾನೆ ಎಲಿಯಾ ಆಸ ಸು ದೆಕೆ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ಪಾಚ಼ಲ್ತೊ ಯೆಸು ವರಿ ಮ್ಹೊಟಿ ಅವಾಜ಼ಕ್ಹು ವದ್ರಿನ ಜ಼ಲಮ ಛೊಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ತೆಳಾಮಾ ದೆವಾಲಯನೊ ಪಡದೊ ಉಪ್ಪರತೊ ಹೆಟಾ ಲಕ್ಕಾ ಫಾಟಿನ ಬೆ ಭಾಗ ಥಯು. ಜಿಮಿನ ಕಾಪಿ. ದಗ್ಡಾ ಫುಟಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ಮಜಾ಼ರೊ ಖುಲ್ಯಾ, ಮರಲವಾಲಾ ಘನ್ನಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ಮಜಾ಼ರೊಮಾತಾ ಜಿವ್ತಾ ಥೈನ ಉಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ಯೆಸು ಪುನರುತ್ಥಾನ ಥಯಲ್ಪರ, ತ್ಯುನೆ ಪವಿತ್ರ ಗಾಮ ಥಯಲ ಯೆರುಸಲೆಮೆ ಗಯಾ. ಮನಕ್ಹೊ ತ್ಯುನೊನೆ ಡೊಳೆ ನಜ಼ರೆ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ಯೆಸುನೆ ಕೈದಾಲೊ ಸೆನಾದಿಪತಿ ವರಿ ಸೈನಿಕೊ ಬುಕಂಪನೆ ವರಿ ಥಯಲ ಕ್ಹಾರು ದೆಕಿನ ಘನ್ನಾ ಭುಚ್ಕಿನ, \"ಎ ಕ್ಹರಿಬಿ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹತ್ತೊ!” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ಯೆಸುನಿ ಸೆವಾ ಕರ‍್ತಾ ಗಲಿಲಾಯತಾ ತಿನೆ ಪಾಚಾ಼ ಲಾಗಿನ ಆಯಲ ಘನ್ನಾ ಬಾಕ್ಡಿಯೊ ದುರತಾ ದೆಕ್ತಾ ಹುಬ್ರಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ತ್ಯುನೆ ಮಗ್ದಲನಿ ಮರಿಯಳ, ಯಾಕೊಬ ವರಿ ಯೊಸೆಫನಿ ಯಾ ಥಯಲ ಮರಿಯಳ, ವರಿ ಯೊಹಾನ ವರಿ ಯಾಕೊಬನಿ ಯಾ ತ್ಯಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ತೆ ಕ್ಹಾಂಜೆ಼ ಅರಿಮಥಾಯಮಾ ರ‍್ಹಯಲ ಯೊಸೆಫ ಕವಾಲೊ ಸೌಕಾರ ಮನಕ್ಹ ಯೆರುಸಲೆಮೆ ಆಯೊ. ಎಬಿ ಯೆಸುನೊ ಶಿಶ್ಯೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ತೆ ಪಿಲಾತನಕನ ಗೈನ, ಯೆಸುನು ಅಂಗ ತಿನೆ ದ್ಯು ಕೈನ ಮಾಂಗ್ಯೊ. ಯೆಸುನು ಅಂಗ ಯೊಸೆಫನೆ ದ್ಯು ಕೈನ ಪಿಲಾತನ ತಿನಾ ಸೈನಿಕೊನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ಯೊಸೆಫ ತೆ ಅಂಗ ಲಿನ, ತಿನೆ ನವಾ ಶುದ್ಧ ರ‍್ಹಯಲ ಬಾಸನಾ ಫಡ್ಕೆ ಸುತ್ತಿನ ");
INSERT INTO sle_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ದಗ್ಡಾಮಾ ತೆ ಕರಾಯಲ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲ್ಯೊ. ಮಜಾ಼ರನಾ ಬಾಕಲನೆ ಯಕ್ಕ ಮ್ಹೊಟ್ಟಾ ದಗ್ಡೊ ಝಾಕಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ಮಗ್ದಲನಿ ಮರಿಯಳ ವರಿ ಬಿಜಾ಼ ಯಕ್ಕ ಮರಿಯಳ ತೆ ಮಜಾ಼ರಕನ ಬೈಟ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ಶುಕ್ರವಾರ ಕ್ಹರ‍್ಯಲಪರ ಮಹಾಯಾಜಕೊ ವರಿ ಪರಿಸಾಯರೊ ಪಿಲಾತನಕನ ಗೈನ, ");
INSERT INTO sle_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","\"ಮಾಲಕ, ತೆ ಸುಳ್ಳ ಬೊಲಾಲೊ ಜಿವ್ತೊ ರ‍್ಹತಾಮಾ, ‘ತನ್ನ ದಿನ್ನ ಥಯಲ್ಪರ ಮಿ ಪುನರುತ್ಥಾನ ವ್ಹಂದುಸ’ ಕೈನ ಕದ್ಯಲ ಹಮೊನೆ ಹಜಿ಼ನ ಶೆಂ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ತಿನಾಹುತಿ ತನ್ನ ದಿನ್ನಲಕ್ಕಾ ತೆ ಮಜಾ಼ರನೆ ಕೈದಾನೆ ಆಗನ್ಯಾ ದೆ. ತಿನಾ ಶಿಶ್ಯಾ ಐನ, ತಿನು ಅಂಗ ಕಾಳಿಲಿನ ಗೈನ, ತೆ ಮಜಾ಼ರಮಾತೊ ಉಟಿನ ಆಯೊಸ ಕೈನ ಮನಕ್ಹೊನೆ ಕೆಸಕಸ. ತೆಳಾಮಾ ಪಸ್ಟ ಥಯಲ ಮೊಸತಿಬಿ ಲಾಸ್ಟನುಜ಼ ಘನ್ನು ಮೊಸ ಥಾಸ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ಪಿಲಾತ ತ್ಯುನೊನೆ, \"ದಕ್ಹಾ ಕೈದಾಲಾ ಸೈನಿಕೊನೆ ಲಿನ ಗೈನ, ತುಮೊನೆ ಚಾ಼ಯೆ ಥಯಲ ತರಿಕಾಮಾ ಮಜಾ಼ರನೆ ಕೈದಾಲಗಾಡೊ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ತ್ಯುನೆ ಗೈನ, ಮಜಾ಼ರನೆ ಸಿಕ್ಕೊ ಮಾರಿನ, ಸೈನಿಕೊನೆ ಕೈದಾನೆ ಛೊಡಿನ, ಮಜಾ಼ರನೆ ಚೊ಼ಕಾ ಕೈದಾ ಲಗಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ಸಬ್ಬತ ದಿನ್ನ ಥಯಲ್ಪರ ಐತವಾರ ಪಾಟ ಥಾವಾನಿ ವ್ಹತ್ತಿ. ಮಗ್ದಲನಿ ಮರಿಯಳ ವರಿ ಬಿಜಿ಼ ಮರಿಯಳ ಮಜಾ಼ರನೆ ದೆಕಾನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ತೆಳಾಮಾ ಘನ್ನು ಮ್ಹೊಟು ಭುಕಂಪ ಥಯು. ಕ್ಹುದಾನೊ ದುತ ಹಬಾಳತೊ ಉತ್ರಿನ ಆಯೊ. ತೆ ದುತ ಮಜಾ಼ರಕನ ಗೈನ, ಮಜಾ಼ರನಾ ಬಾಕಲಕಂತು ಮ್ಹೊಟೊ ದಗ್ಡೊ ಸರ್ಕೈನ ತೆ ದಗ್ಡಾಪರ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ಕ್ಹುದಾನೊ ದುತನು ಮ್ಹೊಡು ಬಿಜ಼ಲಿ ಲಿಂಗತ ಚಮ್ಕಾಡುತು. ತಿನಾ ವಣ್ಣಾ ಮಿಂಚ ಲಿಂಗತ ಧೊಳಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ಮಜಾ಼ರ ಕೈದಾಲಾ ಸೈನಿಕೊ ಕ್ಹುದಾನಾ ದುತನೆ ದೆಕಿನ ಘನ್ನ ಭುಚ್ಕಿ಼ನ ಘಾಬ್ರಾ ಥೈನ ಮರ‍್ಯಲವಾಲಾ ಲಿಂಗತ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ದುತ ತೆ ಬಾಕ್ಡಿಯೊನೆ, \"ತುಮೆ ಭುಚ್ಕೊ಼ ನಕೊ; ಶಿಲುವಿಪರ ಘಾಲಲ ಯೆಸುನೆ ತುಮೆ ಹುಡ್ಕಾಡಾಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ತೆನೈಸೊ ಯೆಸು ನ್ಹ್ಯಾ ನತ್ತಿ. ತೆ ಕದಲ ತಿಮ್ಮ ಪುನರುತ್ಥಾನ ವ್ಹಂದ್ಯೊಸ. ಆವೊ, ತಿನು ಅಂಗ ರ‍್ಹಯಲ ಜ಼ಗಾ ದೆಕೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ಜಲ್ದಿ ಗೈನ ತಿನಾ ಶಿಶ್ಯಾವೊನೆ, \"ಯೆಸು ಪುನರುತ್ಥಾನ ವ್ಹಂದ್ಯೊಸ. ತೆ ಗಲಿಲಾಯೆ ಚಾ಼ಲ್ಯೊಸ. ತುಮಾರಾತಿ ಪೈಲಾಜ಼ ತೆ ತ್ಯಾ ರ‍್ಹವಸ. ತುಮೆ ತಿನೆ ತ್ಯಾ ದೆಕೊಶಿ” ಕೈನ ಕವೊ. ಮಿ ತುಮೊನೆ ಕವಾನಿ ಸುದ್ದಿ ಎಜ಼ ವ್ಹೈ, ಇಕ್ಹರೊ ನಕೊ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ತೆಳಾಮಾಜ಼ ತೆ ಬಾಕ್ಡಿಯೊ ಭೆಂಕ್ಹುಬಿ ಕ್ಹುಷಿಕ್ಹುಬಿ ಮಜಾ಼ರ ಕಂತಾ ಗಯಾ. ಥಯಲ ಕ್ಹಾರು ಶಿಶ್ಯಾವೊನೆ ಕವಾನೆ ತ್ಯುನೆ ನ್ಹಾಟಿನ ಜಾ಼ತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ಯೆಸು ತ್ಯುನಾ ಕ್ಹಾಮೊ ದಿಕ್ಹಿನ, \"ತುಮೊನೆ ಶುಭ ಥಾವಾದೆ” ಕದ್ಯೊ. ತೆ ಬಾಕ್ಡಿಯೊ ಯೆಸುಕನ ಗೈನ, ತಿನಾ ಪಗೊ ಧರಿನ ಆರಾಧನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ಯೆಸು ತೆ ಬಾಕ್ಡಿಯೊನೆ, ಭುಚ್ಕೊ಼ ನಕೊ; ಮಾರಾ ಭಾಯೊಕನ ಗೈನ ಗಲಿಲಾಯೆ ಆವಾನೆ ಕವೊ. ತ್ಯುನೆ ಮನೆ ದೆಕಸ” ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ತೆ ಬಾಕ್ಡಿಯೊ ಶಿಶ್ಯಾವೊನೆ ಕವಾನೆ ಗಯಾ. ತ್ಯಾ ಮಜಾ಼ರ ಕೈದಾಲಾ ದಕ್ಹಾ ಸೈನಿಕೊ ಗಾಮಮಾ ಗೈನ ಥಯಲ ಕ್ಹಾರು ಮಹಾಯಾಜಕೊನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ತೆಳಾಮಾ ಮಹಾಯಾಜಕೊ ಮ್ಹೊಟಾ ಯಹುದ್ಯೊನೆ ಮಳಿನ ಚರ್ಚೆ ಕರ‍್ಯಾ ವರಿ ಸೈನಿಕೊನೆ ಘನ್ನಾ ದೊಕ್ಡಾ ದಿನ ತ್ಯುನೊಕ್ಹು ಸುಳ್ಳ ಕವಾಲಗಾಡಾನು ಉಪಾಯ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ತ್ಯುನೆ ಸೈನಿಕೊನೆ, \"ರಾತನಾ ಟೈಮಮಾ ಹಮೆ ಕ್ಹುರಯಲ ಟೈಮಮಾ ಯೆಸುನಾ ಶಿಶ್ಯಾ ಐನ ತಿನು ಅಂಗ ಕಾಳಿಲಿನ ಗಯಾ ಮನಕ್ಹೊನೆ ತಿಳ್ಸಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ಎ ರಾಜ್ಯಪಾಲನೆ ಗ್ವತ್ತ ಥಯುಮ ಹಮೆ ತಿನೆ ಸಮಾದಾನ ಕರೆಸ ವರಿ ತುಮೊನೆ ಕಯುಜ಼ ತ್ರಾಸ ಥಯಾ ಬಗರ ದೆಕಿಲಿಯೆಸ” ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ಸೈನಿಕೊ ದೊಕ್ಡಾ ಲಿನ, ತ್ಯುನೆ ಕದಲ ತಿಮ್ಮ ಕರ‍್ಯಾ. ಎ ಕಾನಿ ಹಜು಼ನಲಕ್ಕಾಬಿ ಯಹುದಿಯೊಮಾ ಫೈಲ್ಯಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ತೆ ಥಯಲ್ಪರ ಗ್ಯಾರಾ ಜ಼ನಾ ಶಿಷ್ಯಾ ಗಲಿಲಾಯನೆ ಗೈನ ಯೆಸು ಕದ್ಯಲ ಡೊಂಗರಪರ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ಶಿಶ್ಯಾ ಡೊಂಗರಪರ ಯೆಸುನೆ ದೆಕಿನ ತಿನೆ ಆರಾಧನಾ ಕರ‍್ಯಾ. ತೆನೈಸೊ ದಕ್ಹಾ ಶಿಶ್ಯಾ ತೆಜ಼ ಕ್ಹರಿನೊ ಯೆಸು ವ್ಹೈ ಕವಾನು ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ತಿನಾಹುತಿ ಯೆಸು ತ್ಯುನೊಕನ ಐನ, ಸ್ವರ್ಗ ವರಿ ಎ ದುನಿಯಾನಿ ಕ್ಹಾರಿ ಅದಿಕಾರ ಮನೆ ದಿದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ತಿನಾಹುತಿ ತುಮೆ ಗೈನ, ದುನಿಯಾಮಾ ರ‍್ಹವಾನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಮಾರಾ ಶಿಶ್ಯಾ ಕರೊ. ಬಾನಾ, ದಿಕ್ರಾನಾ ವರಿ ಪವಿತ್ರ ಆತ್ಮಾನಾ ನಾಮಪರ ತ್ಯುನೊನೆ ಬಾಪ್ತಿಸ್ಮಾ ಕರಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ಮಿ ತುಮೊನೆ ಆಗನ್ಯಾ ದಿದ್ಯಲ ಕ್ಹಾರಾವೊನೆ ವಿದೆಲ ಥಾಯೆಲಿಂಗತ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರೊ, ಜಗತ್ತನು ಅಂತ್ಯ ಥಯೆಲಕ್ಕಾ ಹಮೆಶಾಬಿ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌಸ” ಕೈನ ಕದ್ಯೊ.");
INSERT INTO sle_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಯೆಸು ಕ್ರಿಸ್ತನಿ ಸುವಾರ್ತೆ (ಚೊ಼ಕಿಯೊ ವಾತೊ) ಶುರು. ");
INSERT INTO sle_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಬುಕ್ಮಾ ಬರ್ದಲ ಲಿಂಗತ ಕ್ಹುದಾ ಕದಲ ಅಮ್ಮ ವ್ಹೈ. ಹಮ್ನಾ ಮಿ ಮಾರಿಯೊ ವಾತೊ ಕವಾಲಾನೆ ತಾರಾ ಕ್ಹಾಮೊ ಮೊಕ್ಲುಸ. ತು ಜಾ಼ವಾನಿ ವಾಟ ತೆ ಚೊ಼ಕಿ ಕರಸ.' ");
INSERT INTO sle_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ಕರ್ತಾನಿ ವಾಟ ತಯ್ಯಾರ ಕರೊ; ತಿನಿ ಜಾ಼ವಾನಿ ಯಕ್ಕ ವಾಟ ಚೊ಼ಕಿ ಕರೊ; ರಾನ್ಮಾ ವದ್ರಾಲಾನು ಅವಾಜ಼ ಐಕು ಆವಾಡುಸ. ");
INSERT INTO sle_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ಯೊಹಾನ ಐನ ಮನಕ್ಹೊನೆ, ತುಮೆ ಪಾಪ ಪರಿಹಾರನಾಹುತಿ ಕ್ಹುದಾಕನ ಫರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವೊ. ತೆಳಾಮಾ ಕ್ಹುದಾ ತುಮಾರು ಪಾಪ ಮಾಫ ಕರಸ\" ಕತೊ ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ಕರಾತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ತೆಳಾಮಾ ಯುದಾಯಾತಾ ವರಿ ಯೆರುಸಲೆಮಾತಾಬಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯೊಹಾನಕನ ಐನ ತ್ಯುನೆ ತ್ಯುನಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಕರಲಿನ ಯೊರ್ದನ ನದಿಮಾ ತಿನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ಆ ಯೊಹಾನ ಹುಂಟನಾ ಬಾಲೊನಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ, ಕಂಬರನೆ ಯಕ್ಕ ಚಾ಼ಂಬಡಾನಿ ಪಟ್ಟಿ ಭಾಂದಿಲೆತೊತೊ; ಫಿರಕಾ ವರಿ ರಾನ್ಮಾನು ಜೆನ ತಿನು ಅನ್ನ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ತೆ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ, ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ, ತೆ ಮಾರಾತಿಬಿ ಘನ್ನಿ ತಾಕತವಾಲೊ ವ್ಹೈ, ತಿನಿಯೊ ಚಪ್ಪಲನಿಯೊ ದೊರಿಯೊ ಡೊಗ್ಗಿನ ಛೊಡಾನೆಬಿ ಮಿ ಲಾಯಕ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ಮಿ ತುಮೊನೆ ಪಾನಿಕ್ಹು ಬಾಪ್ತಿಸ್ಮ ಕರಾಯೊಸ. ತೆ ತುಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಬಾಪ್ತಿಸ್ಮ ಕರಾವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ತೆ ದಿನ್ನಮಾ ಯೆಸು ಗಲಿಲಾಯ ಗಾಮನೆ ಮಳಲ ನಜ಼ರೆತ ಕವಾನಾ ಗಾಮತೊ ಐನ. ಯೊರ್ದನ ನದಿಮಾ ಯೊಹಾನ ರ‍್ಹಯಲ ಜ಼ಗಾ ಐನ, ತಿನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದಲ ಬರೊಬ್ಬರ ತೆ ಪಾನಿಮಾತೊ ಉಪ್ಪರ ಆತಾಮಾ ಸ್ವರ್ಗ ಕ್ಹುಲ್ಲಾ ಥೈನ, ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಕ್ಹಬುತರ ಲಿಂಗತ ತಿಪರ ಉತರಾನು ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ತೆಳಾಮಾ, ತು ಮಯಾನೊ ಥಯಲ ಮಾರೊ ದಿಕ್ರೊ ವ್ಹೈ. ತುನೆ ಮಿ ಮೆಚ್ಯೊಸ. ಕೈನ ಸ್ವರ್ಗಮಾತು ಆವಾಜ಼ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ತೆಳಾಮಾಜ಼ ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಯೆಸುನೆ ರಾನ್ಮಾ ಚ಼ಲೈ. ");
INSERT INTO sle_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ತೆ ಚಾ಼ಳಕ್ಹ ದಿನ್ನ ಕುನ್ನಜ಼ ರ‍್ಹವಾನೆ ಥಾಯೆ ನೈಸೊ ಜ಼ಗಾ ಜಾನ್ವರೊನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ, ಸೈತಾನ ಯೆಸುನೆ ಶೊದನೆಮಾ ಪಾಡಾನೆ ದೆಕ್ಯೊ. ತಿನಾ ಹತೆ ಥಯು ನೈ. ವರಿ ಕ್ಹುದಾನಾ ದುತೊ ಐನ ತಿನಿ ಸೆವಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ಪಾಚಲ್ತಾ ಯೊಹಾನನೆ ಜೆಲಮಾ ಘಾಲಲ್ಪರ, ಯೆಸು ಗಲಿಲಾಯ ಗಾಮೆ ಐನ ಮನಕ್ಹೊನೆ ಸುವಾರ್ತೆ ಕವಾನು ಚಾ಼ಲು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ತೆ ದಿನ್ನೊ ಪುರಾ ಥಯಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನಜಿ಼ಕ ಐ. ತುಮಾರಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ಫರಿನ ಸುವಾರ್ತೆ (ಸುವಾರ್ತೆ ಕದ್ಯಾಮ ಕ್ಹುದಾನಿಯೊ ವಾತೊ) ನಂಬೊ ಕೈನ ಕ್ಹುದಾನಿಯೊ ಚೊ಼ಕಿಯೊ ವಾತೊ ಕತೊ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತೆ ಗಲಿಲಾಯ ಸಮುಂದರಕನ ಜಾ಼ತಾಟೈಮಾ. ಸಿಮೊನ ವರಿ ಸಿಮೊನನೊ ನ್ಹಾನೊ ಭೈ ರ‍್ಹಯಲ ಅಂದ್ರೆಯಾ. ಸಮುಂದರಮಾ ಬಲಿ ನಾಕಾನು ದೆಕ್ಯೊ. ತ್ಯುನೆ ಬೆಸ್ತರೊ ವ್ಹತ್ತಾ. (ಕದ್ಯಾಮ ಮಚ಼್ಲಿ಼ಯೊ ಧರಾಲಾ) ");
INSERT INTO sle_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ಯೆಸು ತ್ಯುನೊನೆ, ಮಾರಾಪಾಚಾ಼ ಆವೊ ಮಿ ತುಮೊನೆ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾನಾ ರಾಜ್ಯಮಾ ಲಾವಾಲಾ ಲಿಂಗತ ಕರುಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ತೆಳಾಮಾಜ಼ ತ್ಯುನೆ ಬಲಿಯೊ ಛೊಡಿನ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ಹಜು಼ನ ದಕ್ಹಾ ದುರ ಗೈನ ಜೆಬೆದಾಯನೊ ದಿಕ್ರೊ ಯಾಕೊಬನೆ ತಿನೊ ನ್ಹಾನೊ ಭೈ ಥಯಲ ಯೊಹಾನ ಕವಾಲಾನೆ ದೆಕ್ಯೊ. ತ್ಯುನೆ ಹಡಗಾವೊಮಾ ಬೈಟಿನ ಬಲಿಯೊ ಸಿದಾ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ಜೆಬೆದಾಯನೆ ಕುಲಿ ಆಳೊನಾ ಕ್ಹಾತೆ ಹಡಗಾಮಾ ಚೊ಼ಡಿನ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ಪಾಚಲ್ತಾ ತ್ಯುನೆ ಕಪೆನೌರ್ಮಿ ಕವಾನಾ ಗಾಮೆ ಐನ ಮುಟ್ಟ್ಯಾ. ತೆಳಾಮಾ ಸಬ್ಬತ ದಿನಮಾ ಯೆಸು ಸಭಾಮಂದಿರಮಾ ಗೈನ ಉಪದೆಶ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ಮನಕ್ಹೊ ತೆ ಉಪದೆಶ ಕರಾನು ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ಕಾಕದ್ಯಾಮ ತೆ ಶಾಸ್ತ್ರಿಯೊಲಿಂಗತ ಉಪದೆಶ ಕರ‍್ಯಾವಾಚಿ ಅದಿಕಾರ ರ‍್ಹಯಲವಾಲಾ ಲಿಂಗತ ತ್ಯುನೊನೆ ಉಪದೆಶ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ತೆಳಾಮಾ ತ್ಯುನಾ ಸಭಾಮಂದಿರಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಯಕ್ಕ ದಾಣಗೊ ಐನ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ , ನಜ಼ರೆತನಾ ಯೆಸು ಹಮಾರಿ ಉಸಾಬರಿ ತುನೆ ಕಾ? ಹಮ್ನೊನೆ ನಾಶ (ಹಾಳ) ಕರಾನೆ ಆಯೊ ಸು? ತುನೆ ವಳಕ್ಯಾಸ; ತು ಕ್ಹುದಾ ವಳಾಯಲ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕೈನ ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ ಕೈನ ವದ್ರಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ಯೆಸು ತಿನೆ, ಭುಚ್ಕಾ಼ಡಿನ ಗಪ ರ‍್ಹೆ ಅನಾಮಾತೊ ಭಾರೊ ಜಾ಼ ಕತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತಿನೆ ವದ್ಯಾಡಸಿನ ಘಾಬ್ರುಥೈನ ಛೊಡಿನ ವದ್ರಿನ ಗಯು. ");
INSERT INTO sle_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ತಿನಾಹುತಿ ಕ್ಹಾರಾ ಜ಼ನಾ ಘಾಬ್ರಾಥೈನ, ಆ ಸುವೈ? ನವು ಉಪದೆಶ. ಆ ಅದಿಕಾರಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆಬಿ ಆಗನ್ಯಾ ದಿವಸ ತ್ಯುನೆ ತಿನಿ ವಾತ ಐಕಸ” ಕೈನ ತ್ಯುನೊ-ತ್ಯುನೊಮಾಜ಼ ವಿಚಾರ ಕರಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ತೆಳಾಮಾ ತಿನಿ ಸುದ್ದಿ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯಮಾ ಫೈಲಿ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ತೆ ಥಯಲ್ಪರ ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಸಭಾಮಂದಿರಮಾತಾ ಗೈನ ಯಾಕೊಬ ಯೊಹಾನನಾ ಕ್ಹಾತೆ ಸಿಮೊನ ಅಂದ್ರೆಯನಾ ಘರೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ತ್ಯಾ ಸಿಮೊನನಿ ಪ್ಹೈ ತೌ ಐನ ಕ್ಹುರೈತಿ ತ್ಯುನೆ ತೆಳಾಮಾಜ಼ ಯೆಸುಕನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ತೆ ನಜಿಕ ಐನ ತಿನೊ ಹತ್ತ ಧರಿನ ಉಟಾಡತಾಮಾ ತಿನೆ ತೌ ರ‍್ಹಯಲ ಗೈ ಪಾಡ್ಯೊ. ತೆ ತ್ಯುನೊನೆ ಉಪಚಾರ ಕರಿ. ");
INSERT INTO sle_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ಕ್ಹಾಂಜ಼ ಥೈನ ದಿನ್ನ ಡುಬ್ತಾಮಾ ಮನಕ್ಹೊ ಅರಾಮ ನೈಸೊವಾಲಾವೊನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲವಾಲಾವೊನೆ ತಿಕನ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ಗಾಮವಾಲಾ ಸಿಮೊನನಾ ಘರನಾ ಬಾಕಲನಾ ಕ್ಹಾಮಾ ಗುಂಪ ಥೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ತೆ ಬಿಜಾ಼-ಬಿಜಾ಼ ರೊಗೊ ರ‍್ಹಯಲವಾಲಾ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಅರಾಮ ಕರಿನ ಘನ್ನಿಯೊ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಛೊಡೈನ ವರಿ ತೆ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಗ್ವತ್ತ ರ‍್ಹಯಲಕ್ಹು ತ್ಯುನೊನೆ ಬೊಲಾನೆ ದಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ದಿನ್ನ ನಿಕ್ಹಳಾತಿ ಅಗ್ದುರಜ಼ ತೆ ಉಟಿನ ಕುನ್ನಜ಼ ನೈಸೊ ಜ಼ಗಾ ಗೈನ ಕ್ಹುದಾನೆ ಪ್ರಾಥನಾ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ಸಿಮೊನ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ತಿನೆ ಹುಡಕ್ತಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ತಿನೆ ದೆಕಲ ಬರೊಬ್ಬರ ಕ್ಹಾರಾಜ಼ನಾ ತುನೆ ಹುಡಕಾಡಾಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ಯೆಸು ತ್ಯುನೊನೆ ಅಪೆ ನಜಿಕ ರ‍್ಹಯಲ ಬಿಜಾ಼ ಗಾಮೆ ಗಯ್ಯೆ ತ್ಯಾಬಿ ಮಿ ಸುವಾರ್ತೆ ಕೌ; ಇನಾಹುತಿ ಮಿ ಐಪಾಡ್ಯೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ಪಾಚಲ್ತೊ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯಮಾ ಕ್ಹಾರಿ ಜ಼ಗಾ ಗೈನ ತ್ಯುನಿಯೊ ಸಭಾ ಮಂದಿರೊಮಾ ಗೈನ ಸುವಾರ್ತೆ ಕತೊ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ಯಕ್ಕ ಕುಷ್ಟರೊಗಿ ಯೆಸುಕನ ಐನ ತಿನಾ ಕ್ಹಾಮೊ ಉಂದಾಗುಡಗಾ ಘಾಲ್ಲಿನ ಬೈಟಿನ ತುನೆ ಮನಸ ರ‍್ಹಯುಮ ಮನೆ ಶುದ್ಧ ಕರಶಿ (ಅರಾಮ ಕರಶಿ) ಕೈನ ಮಾಂಗಿಲೆತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ಯೆಸು ತಿನೆ ಮರಗಿನ ಹತ್ತ ದಿನ ಮುಟ್ಟಿನ, ಮನೆ ಮನಸ ಛೆ ಶುದ್ಧ ಥಾ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ತೆಳಾಮಾಜ಼ ತಿನೊ ಕುಷ್ಟರೊಗ ಗೈನ ತೆ ಶುದ್ಧ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ತೆಳಾಮಾ ಯೆಸು ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಿನ ವಳಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ಸು ಕೈನ ವಳಾಯೊ ಕದ್ಯಾಮ, ಯೆಸು ತಿನೆ, ಕಿನೆಜ಼಼ ಸು ಕೌ ನಕೊ ದೆಕ ತು ಗೈನ ಯಾಜಕನೆ ತಾರು ಅಂಗ ದೆಕಾಡ ಮೊಶೆ ಕದಲ ಪದ್ದತ ಕರಿನ ತಾರು ಶುದ್ಧವಿಚಾರ ಪುರಾಕರ. ತೆ ಮನಕ್ಹೊನೆ ಸಾಕ್ಷಿ ಥಾವಾದೆ ಕೈನ ಕ್ಹರಿಕ್ಹು ಕೈನ ತಿನೆ ವಳೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ವರಿಬಿ ತೆ ಗೈನ ತಿನಾ ಕ್ಹಾತೆ ಥಯಲ ಅದ್ಭುತ ಘನ್ನೊ ಸುದ್ದಿ ಕರಲ ಹುತಿ ಯೆಸುನೆ ಕಯಾಜ಼ ಗಾಮಮಾ ಖುಲ್ಲಾ ಜಾ಼ವಾನೆ ಥಯು ನೈ. ವರಿ ಕುನ್ನಜ಼ ನೈಸೊ ರ‍್ಹಯಲ ಜ಼ಗಾಪರ ವ್ಹತ್ತೊ. ವರಿ ಮನಕ್ಹೊ ಚ಼್ಯಾರೆ ಬಗಲತಾ ಆವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ದಕ್ಹಾ ದಿನೊ ಥಯಲ್ಪರ ಯೆಸು ಕಪೆನೌರ್ಮಿ ಗಾಮೆ ಫರಿನ ಆಯೊ. ತೆ ಘರಮಾ (ಘರ ಕದ್ಯಾಮ ತೆ ರ‍್ಹಯಲ ಗಾಮೆ) ಆಯೊಸ ಕೈನ ಮನಕ್ಹೊನೆ ಸುದ್ದಿ ಗೊತ್ತ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ಮನಕ್ಹೊ ಮಳಿನ ಆಯಲ ಹುತಿ ಘರನಾ ಬಾಕಲನಾ ಭಾರಿಬಿ ಜ಼ಗಾನ್ಹೊತಿ ಯೆಸು ತ್ಯುನೊನೆ ಉಪದೆಶ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ತೆಕ್ಲಾಮಾಜ಼಼ ಯಕ್ಕ ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ಚ಼್ಯಾರ ಜ಼ನಾ ಉಚೈಲಿನ ತ್ಯಾ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ಮನಕ್ಹೊ ಗುಂಪ ಥೈನ ಹುಬ್ರಯಲ ಹುತಿ ತ್ಯುನೆ ತಿಕನ ನಜಿಕ ಆವಾನೆ ಥಯಲ ನೈಸೊಕ್ಹು ತೆ ರ‍್ಹಯಲ ಘರನಾ ಉಪ್ಪರಲಿ ಛತ್ತ ಕಾಡಿನ ಜ಼ಗಾ ಕರಿನ ಲಕ್ವೊ ಮಾರಲ ರೊಗಿನೆ ಕ್ಹುರಯಲ ವಚ್ಚಾ಼ನಾನಾ ಕ್ಹಾತೆ ಉತಾರ‍್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ಯೆಸು ತಿವ್ನೊ ಬರೊಕ್ಹೊ ದೆಕಿನ ತೆ ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ದಿಕ್ರಾ ತಾರು ಪಾಪ ಮಾಫ ಥಯುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ತೆಳಾಮಾ ಶಾಸ್ತ್ರಿಯೊಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ ತ್ಯಾಜ಼ ಬೈಟ್ಯಾತಾ ");
INSERT INTO sle_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ಆ ಇಮ್ಮ ಕಾ ಬೊಲಾಡೊಸ? ಎ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ವ್ಹೈ. ಕ್ಹುದಾನೆ ಯಕ್ಲಾನೆಜ಼ ಛೊಡಿನ ಬಿಜು಼ ಕುನ್ನ ವ್ಹೈ ಪಾಪ ಮಾಫ ಕರಸ? ಕೈನ ತ್ಯುನಾ-ತ್ಯುನಾ ಮನಸ್ಮಾ ಕೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ತ್ಯುನೆ ಇಮ್ಮ ಕೈಲಿವಾನು ತೆಳಾಮಾಜ಼ ಯೆಸು ತಿಳದಿಲಿದ್ಯೊ. ಯೆಸು ತ್ಯುನೊನೆ-ತುಮೆ ತುಮಾರಾ ಮನಸ್ಮಾ ಇಮ್ಮ ಕಾ ತಿಳದಿಲಿವಾಡಾಸ? ಕಯು ಆಸಾನ (ಚೊ಼ಕು) ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ತಾರು ಪಾಪ ಮಾಫ ಥೈ ಗಯುಸ ಕವಾನು ಸು? ಉಟಿನ ತಾರಾ ವಚ್ಚಾ಼ನಾಲಿನ ಚಾ಼ಲ ಕವಾನು ವ್ಹೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ವರಿಬಿ ಪಾಪ ಮಾಫಕರಾನೆ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಭ್ಹುಲೊಕಮಾ (ದುನಿಯಾಮಾ) ಅದಿಕಾರ ಛೆ ಕವಾನು ತಿಳದಿಲಿವೊ ಕದ್ಯೊ. ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ದೆಕಿನ. ");
INSERT INTO sle_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ಉಟಿನ ತಾರು ವಚ್ಚಾ಼ನು ಉಚೈನ ಘರೆ ಜಾ಼ ಕೈನ ತುನೆ ಕೌಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ತೆ ಉಟಲ ಬರೊಬ್ಬರ ತೆ ವಚ್ಚಾ಼ನುಲಿನ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮಾತೊ ಗೈ ಪಡ್ಯೊ. ತಿನಾಹುತಿ ಕ್ಹಾರಾಜ಼ನಾ ಘಾಬ್ರಾಥೈನ - ಹಜು಼ನಲಕ್ಕಾ ಹಮೆ ಹೌ ಕೆಳಾಮಾಜ಼ ದೆಕ್ಯಾನತ್ತಿ ಕತಾ ಕ್ಹುದಾನೆ ನೆಣಸ್ತಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ಯೆಸು ತ್ಯಾಂತೊ ಫರಿನ ಸಮುಂದರಕನ ಗಯೊ ಮನಕ್ಹೊನು ಗುಂಪ ತಿಕನ ಆತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಶಿಕ್ಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ತೆ ತ್ಯಾಂತೊ ಜಾ಼ತಾಮಾ ಭು ಭಾಡಾನಾ ಹುತಿ. ಬೈಟಲ ಅಲ್ಫಾಯನನಾ ದಿಕ್ರೊ ಲೆವಿನೆ ದೆಕಿನ ಮಾರಾ ಪಾಚೊ಼ ಆ ಕೈನ ಬಲಾತಾಮಾ ತೆ ಉಟಿನ ತಿನಾಪಾಚೊ಼ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ತೆ ಥಯಲ್ಪರ ಲೆವಿನಾ ಘರಮಾ ಕ್ಹಾವಾನಾ ಹುತಿ ಯೆಸು ಬೈಟ್ಯೊ ಮ್ಹೊಟು ಗುಂಪ ಯೆಸುನಾ ಪಾಚು಼ ಐಯು ತಿಮಾ ಭು ಭಾಡಾವಾಲಾ ಪಾಪಿಯೊಬಿ ಗಯಾ, ವರಿ ಘನ್ನಾ ಜ಼ನಾ ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಕುಡ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ತೆವಾ ಘನ್ನಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ಫರಿಸಾಯರೊ ಥಯಲ ಶಾಸ್ತ್ರಿಯೊಬಿ ಐನ. ಯೆಸು ಪಾಪಿಯೊನಾ ಕ್ಹಾತೆ ವರಿ ಭು ಭಾಡಾವಾಲಾವೊನಾ ಕ್ಹಾತೆ. ಖಾವಾನು ದೆಕಿನ ತಿನಾ ಶಿಷ್ಯಾವೊಕನ ಕದ್ಯಾ ಆ ಪಾಪಿಯೊನಾ ಕ್ಹಾತೆ ಅನ್ನ ಖಾವಾಡೊಸ್ತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ಯೆಸು ತೆ ಐಕಿನ ಜವಾಬ ದಿದ್ಯೊ ಚೊ಼ಕಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಡಾಕ್ಟರನಿ ಜ಼ರುರತ ನತ್ತಿ; ರೊಗಿಯೊನೆ ಡಾಕ್ಟರನಿ ಜ಼ರುರತ ಛೆ. ಮಿ ಚೊ಼ಕಾವೊನಾ ಹುತಿ ನತ್ತಿ ಆಯೊ ಪಾಪಿಯೊನಾ ಹುತಿ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ಯಕ್ಕ ಸಲಾ ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ವರಿ ಫರಿಸಾಯರವಾಲಾ ಉಪಾಸ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಯೆಸುಕನ ಐನ, ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ವರಿ ಫರಿಸಾಯರೊ ಉಪಾಸ ಕರಾಡಾಸ್ತೊ? ತಾರಾ ಶಿಷ್ಯಾ ಉಪಾಸ ಕಾ ಕರತಾ ನೈ? ");
INSERT INTO sle_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ಕೈನ ಪುಚ್ತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಹಿವಾಮಾ ಆಯಲ ಮನಕ್ಹೊ. ತಿವ್ನಾ ಕ್ಹಾತೆ. ನೌರೊ ರ‍್ಹತಾಸ್ತಾ ಉಪಾಸ ಕರು ಸು ನೈ ಕರತಾ ನೈ!ಹಿವಾಮಾ ನೌರೊ ತಿವ್ನಾ ಕ್ಹಾತೆ ರ‍್ಹಯೆ ಲಕ್ಕಾ ಉಪಾಸ ಕರು ನೈ ");
INSERT INTO sle_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ವರಿ ನೌರೊ ತಿವ್ನೊಕಂತೊ ಜಾ಼ವಾನೊ ಟೈಮ ಆವಸ ತೆ ಟೈಮಮಾ ತ್ಯುನೆ ಉಪಾಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ಕುನ್ನಜ಼ ನವಾ ವಣ್ಣಾವೊನೊ ತುಕಡೊ ಜು಼ನ್ನಾ ವಣ್ಣಾನೆ ಲಗಾಡ್ತೊ ನೈ ಲಗಾಡ್ಯಾಮ ತೆ ನೌ ಪ್ಹಡಕು ಜು಼ನ್ನಾ ಪ್ಹಡಕಾನೆ ಕುಜೈ಼ಪಾಡಸ ಫಾಟಾನು ಹೆಚ್ಕಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ಎನೈಸೊ ಕುನ್ನಬಿ ಜು಼ನ್ನಾ ಚಾ಼ಮ್ಡಾನಿ ಕೈಚಿಲಾಮಾ ನೌ ದ್ರಾಕ್ಷಾ ರಕ್ಹ ಕುನ್ನಜ಼ ಘಾಲಿನ ನೈ ಮ್ಹೆಲ್ತು. ಕಾಕದ್ಯಾಮ ಮುಕ್ಯಾಮ ತೆ ದ್ರಾಕ್ಷಾ ರಕ್ಹ ತೆ ಕೈಚಿಲಾವೊನೆ ಫಾಡಿನ ಹೆಟು ಪಡಿನ ಕೆಟ್ಟಿ ಜಾ಼ವಸ. ವರಿ ನೌ ದ್ರಾಕ್ಷಾ ರಕ್ಹ ನಯ್ಯೊ ಕೈಚಿಲಾವೊಮಾಜ಼ ಘಾಲಿನ ಮುಕ್ಕು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ಯೆಸು ಸಬ್ಬತ ದಿನ್ನಮಾ ಖೆತ್ರೊಮಾತೊ ಜಾ಼ತಾ ಟೈಮ್ಮಾ ಯೆಸುನಾ ಶಿಷ್ಯಾ ಜಾ಼ತಾ-ಜಾ಼ತಾ ಮಕ್ಕಾ (ಬುಟ್ಟಾ) ಭಾಗಿಲೆತಾ ವ್ಹತ್ತಾ ");
INSERT INTO sle_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ಫರಿಸಾಯರೊ ತಿನೆ ದೆಕಿನ ಇವ್ನೆ ಸಬ್ಬತ ದಿನಮಾ ನೈಸೊ ಕರಾನು ಕಾಮ ಕಾ ಕರಾಡಾಸ ಕೈನ ಪುಚ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ಯೆಸು ತ್ಯುನೊನೆ ದಾವಿದ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನೆ ತಿವನೊನೆ ಸುಜ಼ ನೈಸೊ ಭುಕ್ಕಾ ಥಯಲ ಟೈಮಾ ಸುಕರ‍್ಯೊ ಕೈನ ತುಮೆ ಒದ್ಯಾನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ತೆ ಖಾಸ ಯಾಜಕ ಥಯಲ ಅಬಿಯ್ಯಾತರನ ಕಾಲಮಾ ದಾವಿದ ಕ್ಹುದಾನಾ ಘರಮಾ ಗೈನ, ಪದ್ದತ ಲಿಂಗತ ಯಾಜಕನೆ ಛೊಡಿನ ಬಿಜು಼ ಕುನ್ನಜ಼ ಖೌ ನೈ ಕೈನ ಮೊಶೆನು ಧರಮ ಶಾಸ್ತ್ರ ಕವಸ್ತೊ. ಕ್ಹುದಾನೆ ಚ಼ಡಾಯಲ ರೊಕ್ಲೊ ತೆ ಖೈನ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನೆ ದಿದ್ಯೊತೊ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ವರಿ ಯೆಸು ಕದಲ ಸಬ್ಬತ ದಿನ್ನ ಮನಕ್ಹೊನಾಹುತಿ ಆಯೊಸ ತೆನೈತೊ ಮನಕ್ಹೊ ಸಬ್ಬತ ಹುತಿ ನತ್ತಿ ಆಯಾ ");
INSERT INTO sle_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸಬ್ಬತ ದಿನ್ಪರ‍ ಮಾಲಕ ಥಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ಬಿಜೆಕ ಟೈಮಮಾ ಯೆಸು ಸಭಾಮಂದಿರಮಾ ಜಾ಼ತಾಮಾ ತ್ಯಾ ಹತ್ತ ಕುಕ್ಹೈ ಗಯಲ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ತ್ಯುನೆ ದಕ್ಹಾ ಜ಼ನಾ ಯೆಸುಪರ ತಪ್ಪ ಕಿಮ ಘಾಲಿಯೆ ಕೈನ ವಿಚಾರ ಕರಲೆತಾ ಸಬ್ಬತ ದಿನ್ನಮಾ ತಿನೆ ಅರಾಮ ಕರಸು ಕೈನ ತಿನೆ ದೆಕತಾ ವ್ಹಂಚಘಾಲ್ತಾ (ಸೊಚ಼ತಾ) ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ಯೆಸು ಹತ್ತ ಕುಕ್ಹೈ ಗಯಲವಾಲಾನೆ ಉಟಿನ ವಚ಼ಮಾ ಆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ಸಬ್ಬತ ದಿನ್ನಮಾ ಸು ಕರಾನು ನ್ಯಾಯ ವ್ಹೈ? ಕೆಟ್ಟ ಸು ಚೊ಼ಕು ಕರಾನು. ಜ಼ಲಮ ವಚಾ಼ಡಾನು ಚೊ಼ಕು ವ್ಹೈಸು? ಜ಼ಲಮ ಕಾಡಾನು ಚೊ಼ಕು ವ್ಹೈ? ಕೈನ ಕತಾಮಾ ತ್ಯುನೆ ಗಪ್ಪಜ಼ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ತೆಳಾಮಾ ತ್ಯುನಾ ಮನಸೊ ದಗಡಾ ಥಯಲ ದೆಕಿನ ಯೆಸು ದುಖಿ ಥಯೊ ವರಿ ತೆ ಶಿಟ್ಟಥೈನ ಸುತ್ತೆ ತ್ಯುನೊನೆ ದೆಕಿನ ಹತ್ತ ಕುಕ್ಹಾಯಲ ಮನಕ್ಹನೆ ತಾರೊ ಹತ್ತ ಅಗೊ ಕರ ಕೈನ ಕದ್ಯೊ. ತೆ ಹತ್ತ ಅಗೊ ಕರ‍್ಯೊ ಹತ್ತ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ಫರಿಸಾಯರೊ ಭಾರಾಗಯಲ ಬರೊಬ್ಬರ ಹೆರೊದ್ಯನನಾ ಗುಂಪನಾ ಕ್ಹಾತೆ ಮಳಿನ ಯೆಸುನೆ ಕೈ ಉಪಾಯಕ್ಹು ಖಲಾಸ ಕರಿಯೆ ಕೈನ ತಿನಾ ವಿರುದ್ದ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ತೆ ಜ಼ಗಾ ಛೊಡಿನ ಸಮುಂದರನಾ ನಜಿ಼ಕ ಗಯಾ. ಗಲಿಲಾಯ ಗಾಮತಾ ಘನ್ನಾ ಮನಕ್ಹೊ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ಎನೈಸೊ ಯೆಸು ಹವಾ-ಹವಾ ಕಾಮೊ ಕರಸ ಕೈನ ಐಕಿನ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯ ಯೊದಾಯಾ ಪ್ರಾಂತ್ಯಮಾತಾಬಿ ಯೆರುಸಲೆಮಾತಾಬಿ ಇದೊಮಾಯಾ ಪ್ರಾಂತ್ಯಮಾತಾಬಿ ಯೊರ್ದನ ನದಿನಾ ಬಾಜು಼ಮಾತಾಬಿ ತೊರ ಸಿದೊನ ಗಾಮ್ತಾಬಿ ಗಾಮ್ನಾ ಸುತ್ತೆ ರ‍್ಹಯಲವಾಲಾ ಯೆಸುಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ಮನಕ್ಹೊ ಗುಂಪ ಥಯಲ ಹುತಿ ತಿಪರ ಪಡಿ ಜಾ಼ವಸ ಕೈನ ಯೆಸು ಯಕ್ಕ ನ್ಹಾನೊ ಹಡ್ಗೊ ತಯ್ಯಾರ ಕರಲಿವೊ ಕೈನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ಕಾಕದ್ಯಾಮ ಯೆಸು ಘನ್ನಾ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರಲಹುತಿ ರೊಗಮಾ ರ‍್ಹಯಲವಾಲಾನೆ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ತಿನೆ ಮುಟ್ಟಾನಾ ಹುತಿ ತಿನೆ ಢಕ್ಲಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ವರಿ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಮನಕ್ಹೊ ಯೆಸುನೆ ದೆಕಲ ಬರೊಬ್ಬರ ತಿನಾ ಪಗೊಮಾ ಪಡಿಜಾ಼ತಾತಾ ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ವದರತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ವರಿ ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಮಿ ಹವೊಜ಼ ವ್ಹೈ ಕೈನ ಕಿನೆಜ಼಼ ಕೌ ನೈ ಕೈನ ತಾಕಿತ ಕರಿನ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಡೊಂಗರಪರ ಚ಼ಡಿನ ತಿನೆ ಚಾ಼ಯೆಥಯಲವಾಲಾವೊನೆ ತಿಕನ ಬಲಾಯೊ. ತ್ಯುನೆ ತಿಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ಯೆಸು ತಿನೆ ಚಾ಼ಯೆ ಥಯಲ ಬಾರಾ ಜ಼ನಾವೊನೆ ಇನಿಲಿನ ತ್ಯುನೊನೆ ಅಪೊಸ್ತಲೊ ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಮಿ ತುಮೊನೆ ಇನಿಲಿದಲ ವ್ಹೈ ತುಮೆ ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌ ಕೈನ, ವರಿ ತುಮೆ ಗೈನ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಹುತಿ ಮೊಕ್ಲುಸ, ");
INSERT INTO sle_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ಇನಾಲಿಂಗತ ತ್ಯುನೊನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾವಾನಿ ಅದಿಕಾರ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ಯೆಸು ಇನಿಲಿದಲ ಬಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊನಾ ನಾಮೊ ಅಮ್ಮ ಛೆ. ಸಿಮೊನ (ಪೆತ್ರಾ) ");
INSERT INTO sle_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ಸಿಮೊನ ಕವಾಲಾನೆ ಪೆತ್ರಾ ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ಜ಼ೆಬೆದಾಯನೊ ದಿಕ್ರೊ ಥಯಲ ಯಾಕೊಬನೆ ವರಿ ಯಾಕೊಬನೊ ನ್ಹಾನೊ ಬೈ ಯೊಹಾನ. ಯೆಸು ತ್ಯುನೊನೆ ಬೊವನೆರಗಸ ನಾಮ ಮ್ಹೆಲ್ಯೊ ಕದ್ಯಾಮ ಬಿಜ್ಲಿನಾ ಬಚ್ಚಾ. ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ ಉಗ್ರಲ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ಅಂದ್ರೆಯಾ ಫಿಲಿಪ್ಪ ಬಾರ್ತೊಲೊಮಾಯಾ ಮತ್ತಾಯ ತೊಮ ಅಲ್ಫಾಯನೊ ದಿಕ್ರೊ ಥಯಲ ಯಾಕೊಬ ತದ್ದಾಯಾ ದೆಶನೊ ಅಭಿಮಾನಿ ಕೈನ ನಾಮ ಪಡಲ ಸಿಮೊನ. ");
INSERT INTO sle_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ವರಿ ಯೆಸುನೆ ಧರಿನ ದಿದಲ ಇಸ್ಕರಿಯುತ ಯುದ ಇವ್ನೆ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ಯೆಸು ಘರಮಾ ಜಾ಼ತಾಮಾ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ‍ ಥೈನ ಆತಾಮಾ ಯೆಸುನೆ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನೆಬಿ ಖಾವಾನೆ ಟೈಮ ಮಳ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ಎ ಐಕಿನ ತಿನಾ ಕಳ ಬಳ ಯೆಸುನೆ ಘರೆ ಲಾವಾನಾ ಹುತಿ ಧರಾನೆ ಗಯಾ. ಕಾಕದ್ಯಾಮ ಮನಕ್ಹೊ ತಿನೆ ಪಿಸಾಳೊ ಥೈಗಯೊಸ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ಎನೈಸೊ ಯೆರುಸಲೆಮತಾ ಆಯಲ ಶಾಸ್ತ್ರಿಯೊ ತಿನೆ, ಬೆಲ್ಜೆಬೊಲ ತಿಮಾ ಛೆ, ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೊ ಮಾಲಕ ತಿನಿ ತಾಕತಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಛೊಡಾವಸ” ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ಯೆಸು ತ್ಯುನೊನೆ ನಜಿ಼ಕ ಬಲೈನ, ತ್ಯುನೊನೆ ಸಾಮ್ಯ ರುಪಮಾ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ಸೈತಾನ ಕೆಟ್ಟ ಆತ್ಮಾನೆ ಕಿಮ ನ್ಹಟಾಡಸ?” ");
INSERT INTO sle_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ಯಕ್ಕ ರಾಜ್ಯಮಾ ತಿಮಾ ಭೆದಹುಟ್ಯುಮ, ತೆ ರಾಜ್ಯ ಉಗರತು ನೈ. ತೆ ರಾಜ್ಯ ಬೆ ಭಾಗ ಥೈ ಜಾ಼ವಾಸ. ");
INSERT INTO sle_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ಯಕ್ಕ ಘರಮಾ ಭೆದಹುಟ್ಯುಮ, ತೆ ಘರ ಬೆ ಭಾಗ ಥಾವಸ. ಕಯಾ ಘರಮಾ ಮನಕ್ಹೊ ಲಡೈ ಕರಸ ತೆ ಘರ ಹುಬ್ರೆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ತಿನಾಲಿಂಗತಜ಼ ಸೈತಾನನಾ ರಾಜ್ಯಮಾ ಭೆದಹುಟ್ಯುಮ, ಗುಂಪ ಥೈ ಜಾ಼ವಸ. ಎ ಘನ್ನಾ ದಿನ್ನ ಉಗರತು ನೈ ವರಿ ತ್ಯುನೆ ನಾಶ (ಹಾಳ) ಥೈ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ಎನೈಸೊ ಯಕ್ಲೊ ತಾಕತ ವಾಲಾನಾ ಘರಮಾ ವ್ಹಕ್ಕಿನ ಪೈಲಾ ತಿನೆ ಭಾಂದ್ಯಾವಾಚಿ ತಿನಿ ಯಕ್ಕ ಆಸ್ತಿ ಚೊ಼ರಿ ಕರಾನೆ ಥಾತು ನೈ. ಪೈಲಾ ತಿನೆ ಭಾಂದಿಲಿದಲಪರ ತಿನೊ ಘರ ಲುಟಿ ಕರಾನೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ತೆ ತ್ಯುನೊನೆ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಸು ಕೌಸ ಕದ್ಯಾಮ, ಮನಕ್ಹೊ ಕರಾನಾ ಪುರಾ ಪಾಪೊನೆ ವರಿ ಕ್ಹಾರಾ ಪಾಪೊಕ್ಹುಬಿ ಮಾಫಿ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ತೆನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾನೆ ದೊಶದಿವಾಲಾನೆ ಕೆಳಾಮಾಜ಼ ಮಾಫಿ ನೈ ಮಳ್ತಿ. ತೆ ಹಮೆಶಾಬಿ ಪಾಪನೊ ಅಪರಾದಿ ಥಾವಸ ಕೈನ ಯೆಸು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ಕಾಕದ್ಯಾಮ ಮನಕ್ಹೊ ಇನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರ‍್ಯುಸ ಕದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ಮನಕ್ಹೊ ತಿನಾ ಸುತ್ತೆ ಬೈಟತಾಮಾ ತಿನಿ ಯಾಬಿ ಭಾಯೊಬಿ ಐನ ಭಾರಾ ಹುಬ್ರೈನ ಯಕ್ಲಾನೆ ಬಲಾವಾನೆ ಮೊಕ್ಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ತೆ ಮನಕ್ಹ ತಿನೆ ತಾರಿ ಯಾ ತಾರಾ ಭಾಯೊ ವರಿ ಭೆನೊ ತುನೆ ಹುಡಕ್ತಾ ಐನ ಭಾರಾ ಹುಬ್ರಾಯಾಸ ದೆಕ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ತಿನಾಹುತಿ ಯೆಸು, ಮಾರಿ ಯಾ ಮಾರಾ ಭಾಯೊ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ಪಾಚಲ್ತೊ ಯೆಸು, ತಿನಾ ಸುತ್ತೆ ಬೈಟಲವಾಲಾವೊನೆ ದೆಕಿನ ಅವ್ನೆಜ಼ ಮಾರಿ ಯಾ ವರಿ ಮಾರಾ ಭಾಯೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ಕ್ಹುದಾನಿ ಚಿ಼ತ್ತಲಿಂಗತ ಚಾ಼ಲಾಲಾ ಮಾರಿ ಯಾ ವರಿ ಮಾರಾ ಭಾಯೊ ಭೆನೊ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ಯೆಸು ಫರಿನ ಸಮುಂದರನಿ ದಂಡಿಕನ ಉಪದೆಶ ಕರತೊ ವ್ಹತ್ತೊ ಘನ್ನಾ ಜ಼ನಾ ತಿಕನ ಮಳಿನ ಆಯಲ ಹುತಿ ತೆ ಸಮುಂದರಮಾ ರ‍್ಹಯಲ ಹಡಗಾಮಾ ಚ಼ಡಿನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ತೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಸಮುಂದರನಿ ಬಾಜು಼ನಿ ಜ಼ಗಾಪರ ಹುಬ್ರಯಾತಾ ತೆಳಾಮಾ ತೆ ತ್ಯುನೊನೆ ತ್ಯುನಾ ಕ್ಹಾಮೊಜ಼ ತಿವ್ನಾ ಹುತಿ ಸಾಮ್ಯಲಿನ ಉಪದೆಶ ಕರ‍್ಯೊ. ತೆ ಉಪದೆಶ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ. ");
INSERT INTO sle_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ಧ್ಯಾನ ದಿನ್ನ ಐಕೊ, ಬಿತ್ತಾಲೊ ಬಿತ್ತಾನೆ ತಿನಾ ಖೆತರಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ತಿಮ್ಮ ತೆ ಬಿಯ್ಯಾ ಬಿತತಾಮಾ ದಕ್ಹಾ ಬಿಯ್ಯಾ ವಾಟಪರ ಪಡ್ಯಾ. ಪಕ್ಷಿಯೊ ಐನ ತೆ ಬಿಯ್ಯಾ ಖೈಪಾಡಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ಬಿಜಾ಼ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಮಾತಿ ಕಮ ರ‍್ಹಯಲ ದಗ್ಡಾವೊಪರ ಪಡ್ಯಾ. ವರಿ ಮಾತಿ ಕಮ ರ‍್ಹಯಲಕ್ಹು ತೆ ಭೆಗಿನ ಬೆಳದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ವರಿ ತಡಕೊ ತಿವ್ನೊಪರ ಪಡ್ತಾಮಾ ಬೆಳದಾತಿ ಅಗ್ದುರಜ಼ ಕುಕ್ಹೈ ಗಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನಿಯೊ ಬೆರ ಘಟ್ಟ ನ್ಹೊತಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ತೆ ಬಿಯ್ಯಾ ದಕ್ಹಾ ಬೆಳದ್ಯಾ ಕಾಟಾವೊನಿಯೊ ಕಂಠಿಯೊ ತ್ಯುನೊನೆ ಝಾಕಿಪಾಡ್ಯಾ ತೆ ಬಿಯ್ಯಾ ಫಲ ದಿದ್ಯಾನೈ. ");
INSERT INTO sle_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ಹಜು಼ನ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಚೊ಼ಕಿ ಜಿಮಿನ್ಪರ ಪಡ್ಯಾ ತೆ ಬೆಳದಿನ ಮುವತ್ತ ಯಕ್ಲಾ ಯಕ್ಕ ಕ್ಹಾಟ ಯಕ್ಲಾ ಕ್ಹೊ ಯಕಲಾ ಫಲದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ವರಿ ಯೆಸು ಇಮ್ಮ ಕದ್ಯೊ ಕಾನೊ ರ‍್ಹಯವಾಲಾ ಧ್ಯಾನ ದಿನ್ನ ಐಕಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ತೆಳಾಮಾ ಯೆಸು ಯಕ್ಲೊ ರ‍್ಹತಾಮಾ ತಿಕನ ರ‍್ಹಯಲ ಬಾರಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಬಿಜಾ಼ದಕ್ಹಾ ಜ಼ನಾ ತೆ ಸಾಮ್ಯನಾ ಹುತಿ ಹಮೊನೆ ತಿಳಸಿನ ದೆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ಯೆಸು ತ್ಯುನೊನೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯನು ಗುಟ್ಟ ತುಮ್ನೊನೆ ದಿದ್ಯೊಸ ; ಭಾರಲ್ಯಾವೊನೆ ಸಾಮ್ಯ ಲಿಂಗತ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ತಿನಾಹುತಿ ತ್ಯುನಾ ಡೊಳಾ ರ‍್ಹೈತಬಿ ದೆಕತಾ ನೈ. ಕಾನೊ ರ‍್ಹೈತಬಿ ಐಕ್ಯಾತಬಿ ತ್ಯುನೆ ತಿಳದಿಲೆತಾನೈ ತಿಮ್ಮ ದೆಕಿನ ಐಕಿನ ತಿಳದಿಲಿದ್ಯಾಮ. ತ್ಯುನೆ ಕ್ಹುದಾಕನ ಫರಿನ ಕರಲ ಪಾಪನೆ ಕೈಲಿನ ಮಾಫಿ ವ್ಹಂದಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಪುಚ್ಯೊ ತೆಜ಼ ವಾತ ತುಮೊನೆ ನೈ ಗೊತ್ತ ಥೈಯುಮ? ಬಿಜಿ಼ ಕೈ ವಾತ ತುಮೊನೆ ಕಿಮ ಗೊತ್ತ ಥಾವಸ? ");
INSERT INTO sle_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ತೆ ಬಿತ್ತಾಲೊ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾನಾ ಬಿಯ್ಯಾ ಬಿತ್ತಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ದಕ್ಹಾ ಜ಼ನಾ ವಾಟಪರ ಪಡಲ ಬಿಯ್ಯಾ ಲಿಂಗತ ರ‍್ಹವಸ ಕ್ಹುದಾನಿ ವಾತೊ ಐಕಲ ಬರೊಬ್ಬರ ಸೈತಾನ ಐನ ತ್ಯುನಾಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ವಾತೊ ಕಾಳ್ಳಿನ ಗೈ ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ದಕ್ಹಾ ಜ಼ನಾ ದಗ್ಡಾಪರ ಪಡಲ ಬಿಯ್ಯಾ ಲಿಂಗತ ರ‍್ಹವಸ. ತಿಮ್ಮ ತೆ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಲ ಬರೊಬ್ಬರ ಖುಶಿಕ್ಹು ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ತಿವ್ನೊಮಾ ಬೆರ ಘಟ್ಟನೈ ರ‍್ಹಯಲಕ್ಹು ಇವ್ನೆ ದಕ್ಹಾ ಟೈಮಾ ರ‍್ಹೈನ ಪಾಚಾ಼ತಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊನಾ ಹುತಿ ತ್ರಾಸ ಉರಸಾವಾನು ಐಯುಮ ಛೊಡಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ಹಜು಼ನ ದಕ್ಹಾ ಜ಼ನಾ ಕಾಟಾನಿಯೊ ಕಂಟ್ಟಿಯೊಮಾ ಪಡಲ ಬಿಯ್ಯಾ ಲಿಂಗತ ರ‍್ಹವಸ ಎ ಮನಕ್ಹೊ ಹವಾವೈ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಸ ");
INSERT INTO sle_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ವರಿ ತ್ಯುನೆ ಜಿವ್ನಾನಾ ಹುತಿ ಚಿಂತಾ ಕರಸ, ದೊಕಡಾವೊಪರ ಆಸ, ವರಿ ಆಸ್ತಿನಿ ಆಸಮಾ ತೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊನೆ ದಾಬಿಪಾಡಸ ತೆ ಫಲ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿನ ಕೈದಿಲಿನ ಮುವತ್ತ ಯಕಲಾ ಕ್ಹಾಟ ಯಕಲಾ ಕ್ಹೊ ಯಕಲಾ ಫಲದಿವಾಲಾ ಥಾವಸ. ಇವ್ನೆಜ಼ ಚೊ಼ಕಿ ಜಿಮಿನ್ಪರ ಪಡಲ ಬಿಯ್ಯಾ ಲಿಂಗತ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ ದಿವ್ವೊ ಲೈನ ಹಂಡ್ಲಾನಾ ನೈತೊ ಪಲಂಗನಾ ಹೆಟಾ ಮುಕ್ಕೊಶಿ ಸು? ನೈ ಮ್ಹೆಲ್ತಾ, ಉಜಾಲು ಪಡಾನಾ ಹುತಿ ಉಪ್ಪರ ಜ಼ಗಾಜ಼ ಮ್ಹೆಲಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ಸು ದಡಲ ರ‍್ಹವಸ ತಿನೆ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಲಾವಸ ವರಿ ಸು ಝಾಕ್ಯಾಸ ತೆ ಖುಲ್ಲಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ಐಕಾನೆ ಕಾನೊ ರ‍್ಹಯಲವಾಲಾ ಐಕಾದೆ. ಎಬಿ ತ್ಯುನೊನೆ ಕದ್ಯೊ ಧ್ಯಾನ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ತುಮೆ ಕಯಾ ಪದ್ದತಿಕ್ಹು ಬಿಜಾ಼ವೊನೊ ಫೈಸಲೊ ಕರೊಶಿ ತೆಜ಼ ಪದ್ದತ ಕ್ಹು ಕ್ಹುದಾ ತುಮಾರೊ ಫೈಸಲೊ ಕರಸ ವರಿಬಿ ತಿತ್ತಿಬಿ ಘನ್ನು ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ಕುನ್ನ ಮಾರಾ ಉಪದೆಶನೆ ಕಾನ ದಿನ್ನ ಐಕಸ ತ್ಯುನೊನೆ ಬೆ ಯಕ್ಲು ಹೆಚ್ಕಿ ಗೊತ್ತ ಥಾವಸ ಕುನ್ನ ಕಾನ ದಿನ್ನ ನೈ ಐಕ್ತು ತ್ಯುನೊಕಂತು ರಹೆಲ ಬಿ ಕಾಳ್ಳಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ವರಿ ಯೆಸು \"ಕದ್ಯೊ ಕ್ಹುದಾನೊ ರಾಜ್ಯ ಇನಾಲಿಂಗತ ಛೆ ಯಕ್ಕ ಮನಕ್ಹ ಬಿಯ್ಯಾ ಜಿಮಿನಮಾ ಘಾಲಿನ. ");
INSERT INTO sle_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ರಾತೆ ತೆ ಕ್ಹುರೈನ ಪಾಟೆ ಉಟ್ತಾಮಾ ತೆ ಬಿಯ್ಯೊ. ಮಡಿಕಿ ಫುಟಿನ ಬೆಳದಸ ವರಿಬಿ ತೆ ಬೆಳದಾನು ತಿನೆ ಗ್ವತ್ತ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ಮಾತಿ ಝಾಡನೆ ಬೆಳದಾನಾ ಹುತಿ ವರಿ ಫಲ ದಿವಾನೆ ಸಹಾರೊ ಕರಸ. ಪೈಲಾ ಬಿಯ್ಯು ತೆ ಫುಟಸ ಪಾಚಲ್ತೊ ತೆ ಬುಟ್ಟು ಥಾವಸ ವರಿ ತಿನು ಪುರಾ ಬುಡ ಕಾಳೊ ಥೈ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ಕೆಳಾಮಾ ಬಿಯ್ಯೊ ಪಾಕಸ ತೆಳಾಮ ಮನಕ್ಹೊ ದಾತಡೆ ಕಾಟಸ ಕಾಕದ್ಯಾಮ ಕಾಟಾನೊ ಟೈಮ ಐ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ಹಜು಼ನ ತೆ ಕದಲ ಕ್ಹುದಾನಿ ಯಕ್ಕ ರಾಜ್ಯ ಕಿನೆ ಹೊಲ್ಸಿಯೆ? ವರಿ ಯೆಸು ಪುಚ್ಯೊ ಎ ತಿಳಸಾನೆ ಕಯು ಸಾಮ್ಯ ಉಪಯೊಗಿಸಿಯೆ? ");
INSERT INTO sle_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ತೆ ತಿಮ್ಮಶೆ ಯಕ್ಲೊ ಸಾಸವಿನೊ ಬಿಯ್ಯೊ ಲಿವಸ. ತೆ ದುನಿಯಾಮಾ ಕ್ಹಾರಾವೊತಿ ನ್ಹಾನೊ ರ‍್ಹಸ ತೆ ಜಿಮಿನ್ಪರ ನ್ಹಾನು ಝಾಡಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ತೆ ಬಿತ್ತಲಪರ ತೆ ಬೆಳದಿನ ಕ್ಹಾರಾ ಭಾಜಿ ಪಾಲೊನಾ ಝಾಡೊತಿಬಿ ತೆ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಠೊಂಗಿಯೊ ಛೊಡಿನ ಹಬಾಳಮಾ ಉಡಾನಿಯೊ ಪಕ್ಷಿಯೊ ತಿನಿಯೊ ಠೊಂಗಿಯೊನಿ ಛವ್ಲಿಮಾ ಮಾಚೊ಼ ಕರಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ಯೆಸು ತ್ಯುನೊನೆ ಇಮ್ಮ ಘನಿಯೊ ತರಾನಿಯೊ ವಾತೊಮಾ ಮನಕ್ಹೊನೆ ತಿಳದಿಲಿವಾದೆ ಕೈನ ಕ್ಹುದಾನಿ ವಾತೊ ಕತೊತೊ. ಕಾನಿ ನೈಸೊ ಸುಜ಼ ತ್ಯುನೊನೆ ಕತೊ ನ್ಹೊತೊ ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ತಿಳದಿಲಿವಾದೆ ಕೈನ ಕತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ಯೆಸು ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ತಾಮಾ ಸಾಮ್ಯಲಿನ ಕತೊತೊ. ತೆನೈತೊ ಯೆಸು ಯಕ್ಲೊ ರ‍್ಹತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಕ್ಹಾರು ಫೊಡಿನ ಕತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ತೆ ದಿನ್ನನಾ ಕ್ಹಾಂಜ಼ ಥಾತಾಮಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಯೆ ಗಯ್ಯೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ತ್ಯುನೆ ಮನಕ್ಹೊನು ಗುಂಪ ಛೊಡಿನ ಗಯಾ ಶಿಷ್ಯಾ ಹಡಗಾಮಾ ಗಯಾ ಕಾಕದ್ಯಾಮ ತೆಳಾಮಾಜ಼ ಯೆಸು ತಿಮಾ ಬೈಟ್ಯೊತೊ ವರಿ ತಿನೆ ತ್ಯುನೆ ಬಲೈ ಲಿಂಗಯಾ ಬಿಜಾ಼ ಹಡಗಾಬಿ ತ್ಯಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ತ್ಯುನೆ ಜಾ಼ತಾಮಾ ಯಕಾಕಿಜ಼ ತುಫಾನನೊ ಝೊರ ವಾರೊ ಆತಾಮಾ ಧಡಕಿಯೊ ಉಟಿಯೊ ಹಡಾಗಾನೆ ಲಾಗಿನ ತಿಮಾ ಪಾನಿ ಭರಾಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ಯೆಸು ಹಡಗಾಮಾ ಪಾಚೊ಼ ಮಟ್ಲು ಘಾಲ್ಲಿನ ಧಡ ನಿಂದರ ಕರ‍್ಯಾಡ್ಯೊತೊ. ತ್ಯುನೆ ಯೆಸುನೆ ಗುರು ಉಟ ಅಪೆ ಮರಿಗಯ್ಯೆಸ? ತುನೆ ಚಿಂತಾನತ್ತಿ ಸು ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ಯೆಸು ಉಟಿನ ತುಫಾನನೆ ಬರಬಡ್ಯೊ ವರಿ ಧಡಕಿಯೊನೆ ಗಪರ‍್ಹೆ ಶಾಂತ ಥಾ ಕೈನ ಕತಾಮಾ ತೆ ತುಫಾನ ಹುಬ್ರೈಪಡ್ಯು ಕ್ಹಾರು ಶಾಂತಥಯು. ");
INSERT INTO sle_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ತೆಳಾಮಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ತುಮೆ ಕಾ ಇಮ್ಮ ಭುಚ್ಕೊ಼ಸಿ? ತುಮೊನೆ ಹಜು಼ನಬಿ ಬರೊಕ್ಹೊ ನತ್ತಿ ಸು ಕದ್ಯೊ? ");
INSERT INTO sle_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ಶಿಷ್ಯಾ ಘನ್ನಾ ಭುಚ಼ಕಿನ ಆ ಮನಕ್ಹ ಕುನ್ನ ವ್ಹೈ? ವಾರೊಬಿ ವರಿ ಸಮುಂದರನಿಯೊ ಧಡಕಿಯೊಬಿ ಇನಿ ವಾತ ಐಕಸ್ತೊ ಕೈನ ತ್ಯುನೆ ಯಕೆಕ್ಲಾಜ಼ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಯೆ ರ‍್ಹಯಲ ಗೆರೆಸಿನೆರ ಪ್ರಾಂತ್ಯ ಮುಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ಯೆಸು ಹಡಗಾಮಾತೊ ಉತ್ರಿನ ಆಯಲ ಬರೊಬ್ಬರ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಯಕ್ಕ ದಾಣಗೊ ಮಜಾ಼ರೊನಿ ಗವಿಮಾತೊ ಯೆಸುನಾ ಕ್ಹಾಮೊ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ತೆ ಮಜಾ಼ರೊನಿಯೊ ಗವಿಯೊಮಾ ರ‍್ಹತೊತೊ ತಿನೆ ಭಾಂದಿನ ಘಾಲಾನೆ ಕಿನೆಜ಼಼ ಥಾತುನ್ಹೊತು. ತಿನೆ ಬೆಡಿಯೊಕ್ಹು ಭಾಂದ್ಯಾತಬಿ ಉಪಯೊಗ ಥಾತುನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ಮನಕ್ಹೊ ಘನ್ನಿಸಲಾ ತಿನೆ ಹತೊ ಪಗೊ ಬೆಡಿಯೊಕ್ಹು (ಚೈನೊಕ್ಹು) ಭಾಂದ್ಯಾತಬಿ ವರಿಬಿ ತೆ ತೊಡಿಲಿನ ನಾಕಿಪಾಡತೊತೊ. ತಿನೆ ವರಿ ಕುನ್ನಜ಼ ಬೆಡಿಯೊ ಘಾಲಾನೆ ವರಿ ತಿನೆ ಹತೊಟಿಮಾ ಲಾವಾನೆ ಕುನ್ನಜ಼ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ತೆ ದಿನ್ನ ರಾತ ಮಜಾರೊಮಾ ಗವಿಯೊಮಾ ರ‍್ಹತೊತೊ. ಡೊಂಗ್ರೊಮಾ ವದರತೊ ತಿನೊ ಅಂಗ ತೆಜ಼ ದಗ್ಡೆ ಛೆಟಿಲೆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ತೆ ಯೆಸುನೆ ದುರತೊ ದೆಕಿನ ನ್ಹಾಟತೊ ಐನ ತಿನೆ ಉಂದೊ ಪಡಿನ ಝೊರ ವದ್ರಿನ ");
INSERT INTO sle_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ಯೆಸು ಕ್ಹಾರಾವೊತಿ ಉಪ್ಪರ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ದಿಕ್ರಾ ಮಾರಾ ಕ್ಹಾತೆ ಸು ಕರಶಿ? ಕ್ಹುದಾನಾ ಹುತಿ ತುಕನ ಮಾಂಗುಸ ಮನೆ ಶಿಕ್ಷಾ ನಕೊ ದ್ಯು ");
INSERT INTO sle_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(ಕಾಕದ್ಯಾಮ ಎ ಕೆಟ್ಟ ಆತ್ಮಾ ಅನೆ ಛೊಡಿನ ಜಾ಼ ಕೈನ ಯೆಸು ಕದ್ಯೊ). ");
INSERT INTO sle_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ವರಿ ಯೆಸು ತಿನೆ ತಾರು ನಾಮ ಸುವೈ ಕೈನ ಪುಚ಼ತಾಮಾ ತೆ ಮನಕ್ಹ ಕದ್ಯೊ ಮಾರು ನಾಮ ಗುಂಪ ವ್ಹೈ ಕಾಕದ್ಯಾಮ ಹಮೆ ಘನ್ನಾಕೆಟ್ಟ ಆತ್ಮಾವೊ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ತ್ಯುನೆ ಯೆಸುಕನ ಹಮೊನೆ ಆ ಗಮ್ಮಾತೊ ಮೊಕ್ಲು ನಕೊ ಕೈನ ಯೆಸುಕನ ಘನ್ನಾ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ತ್ಯಾಜ಼ ಡೊಂಗರಪರ ಯಕ್ಕ ಢುಕ್ಕುರೊನು ಮ್ಹೊಟು ಗುಂಪ ಚ಼ರಾಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ. ಯೆಸುನೆ ಐಲಾ ಢುಕ್ಕುರೊಮಾ ಜಾ಼ವಾನೆ ಹಮೊನೆ ವಳಾ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ಯೆಸು ಥಯು ಕೈನ ಜಾ಼ವೊ ಕದ್ಯೊ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಮನಕ್ಹನಾ ಅಂಗಮಾತಾ ಭಾರಾ ಐನ ಢುಕ್ಕಕುರೊಮಾ ಗಯಾ. ತೆ ಢುಕ್ಕುರೊನು ಗುಂಪ ನ್ಹಾಟಿನ ಗೈನ ಡೊಂಗರಪರತಾ ಸಮುಂದರಮಾ ಪಡಿನ ಡುಬಿ ಗಯಾ. ಕಮ ಜಾಸ್ತ ಬೆ ಹಜಾ಼ರ ಢುಕ್ಕುರೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ತ್ಯುನೊನೆ ಚ಼ರಾವಾಲಾ ನ್ಹಾಟಿನ ಗೈನ ತೆ ಸುದ್ದಿ ಗಾಮ್ಮಾ ವರಿ ಖೆತ್ರೊಮಾ ತಿಳಸ್ತಾಮಾ ಮನಕ್ಹೊ ಸು ಥಯುಸಕೈನ ದೆಕಾನೆ ಚಾ಼ಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ತ್ಯುನೆ ಯೆಸುಕನ ಆತಾಮಾ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಛೊಡಿನ ಗಯಲ ದಾಣಗಾನೆ ದೆಕಿನ ಬಾಜು಼ಮಾ ವಣ್ಣಾಘಾಲ್ಲಿನ ಚೊ಼ಕೊ ಥೈನ ಬೈಟಲ ದೆಕಿನ ಭುಚಕ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ಎ ದೆಕಲವಾಲಾ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಧರಲವಾಲಾ ಮನಕ್ಹನಾ ಕ್ಹಾತೆ ಥಯಲ ವರಿ ಢುಕ್ಕುರೊನಾ ಕ್ಹಾತೆ ಥಯಲ ಹುತಿ. ಮನಕ್ಹೊನೆ ತಿಳಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ತ್ಯುನೆ ತಿನೆ ಗಾಮ ಛೊಡಿನ ಜಾ಼ ಕೈನ ಯೆಸುನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ಯೆಸು ಹಡ್ಗೊ ಚ಼ಡತಾಮಾ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಧರಿನ ಛೊಡಲವಾಲೊ ಮಿ ತಾರಾ ಕ್ಹಾತೆ ಔಸ ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ತೆ ತಿನೆ ರ‍್ಹವಾನೆ ದಿದ್ಯಾವಾಚಿ ತು ತಾರಾ ಘರೆ ತಾರಾ ಮನಕ್ಹೊಕನ ಜಾ಼ ಗೈನ ಸ್ವಾಮಿ ತುನೆ ಮರಗಿನ ತುನೆ ಕೆವು ಉಪಕಾರ ಕರ‍್ಯೊಸ ತೆ ವದ್ರಿನ ಕೆ. ");
INSERT INTO sle_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ತೆ ಗೈನ ಯೆಸು ತಿನೆ ಕರಲ ಉಪಕಾರ ದಕ್ಹೆ ಗಾಮೊಮಾ ಕವಾನು ಶುರು ಕರ‍್ಯೊ ಐಕಿನ ಕ್ಹಾರಾ ಜ಼ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ಯೆಸು ಫರಿನ ಹಡಗಾಮಾ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಯೆ ಆತಾಮಾ ಮನಕ್ಹೊನು ಘನ್ನು ಗುಂಪಥೈನ ತಿನಾ ಸುತ್ತೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ತೆಳಾಮಾ ಸಬಾಮಂದಿರಪರ ಅದಿಕಾರಿ ರ‍್ಹಯಲ ವಾಲೊ ಯಕ್ಲೊ ಯಾಯಿರಕವಾಲೊ ಐನ ಯೆಸುನೆ ದೆಕಿನ ತಿನಾ ಪಗೊಪರ ಪಡಿನ. ");
INSERT INTO sle_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ಮಾರಿ ಮಯಾನಿ ನ್ಹಾನಿ ದಿಕ್ರಿ ಹಮ್ನಾ ತಿನೆ ಅರಾಮ ನತ್ತಿ (ತೆ ಮರಾ ವರಕ್ಹಿ ಥೈಸ) ತು ಐನ ತಿಪರ ಹತ್ ಮ್ಹೆಲ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ತೆ ಅರಾಮ ಥಾವಸ ವರಿ ವಾಚಿ಼ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ಯೆಸು ತಿನಾ ಕ್ಹಾತೆ ಗಯೊ ವರಿ ಘನ್ನಾ ಮನಕ್ಹೊ ತಿನೆ ಢಕಲ್ತಾ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ತೆಳಾಮಾ ಬಾರಾ ವರಕ್ಹತಿ ರಗತ ಕುಸುಮು ರೊಗಮಾ ಘನ್ನು ತ್ರಾಸ ಕ್ಹಾತಿ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ತ್ಯಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ತೆ ಘನ್ನಿಸಲಾ ಡಾಕ್ಟರೊಕನ ಗೈತಬಿ ಸುಜ಼ ಅರಾಮ ಥಯು ನೈ ಘನ್ನಿ ಕಷ್ಟ ಖೈನ. ಹತ್ಮಾ ರ‍್ಹಯಲ ದೊಕ್ಡಾ ಜ಼ವೈಲಿದಿತಿ. ವರಿ ರೊಗ ಹೆಚ್ಕಿ ಥಾತೊಜ಼ ವ್ಹತ್ತೊ. ವರಿ ಸುಜ಼ ಅರಾಮ ಥೈಯ್ಯು ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ತೆ ಹೆಣ ಮನಕ್ಹ ಯೆಸುನಿ ಸುದ್ದಿ ಐಕಿನ. ತೆ ಗುಂಪಮಾ ತಿನಾ ಪಾಚಿ ಗೈ. ವರಿ ತಿನಾ ವಣ್ಣಾ ಧರಿ. ");
INSERT INTO sle_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ತೆ ವಿಚಾರ ಸು ಕರಲಿದಿ ಕದ್ಯಾಮ ಮಿ ತಿನಾ ವಣ್ಣಾ ಮುಟ್ಟಿಮ ಬಸ ಅರಾಮ ಥೈ ಜ಼ೌಸ ಕೈನ ತಿನಾಮಾ ಕೈಲಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ಗುಂಪನಾ ಪಾಚಾ಼ತಿ ಐನ ತಿನಾ ವಣ್ಣಾ ಮುಟ್ಟಿ. ಮುಟ್ಟಲ ಬರೊಬ್ಬರ ತಿನು ರಗ್ತಜಾ಼ವಾನು ಹುಬ್ರೈ ಪಡ್ಯು. ಮನೆ ಕದ್ರಾವಾನೊ ರೊಗ ಗೈನ ಮಿ ಅರಾಮ ಥೈ ಕೈನ ತಿನಾಮಾ ತೆ ತಿಳದಿಲಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ತೆಳಾಮಾಜ಼ ಯೆಸು ಮಾರಮಾತಿ ತಾಕತ ಚಾ಼ಲಿಸ ಕೈನ ತಿನಾಮಾಜ಼ ತಿಳದಿಲಿನ ಗುಂಪಮಾ ಪಾಚೊ಼ ಫರಿನ ಮಾರಾ ವಣ್ಣಾ ಕುನ್ನ ಮುಟ್ಯು? ಕೈನ ಪುಚ಼ತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ತಿನಾ ಶಿಷ್ಯಾ ತಿನೆ ಮನಕ್ಹೊ ತುನೆ ಢಕ್ಕಲಾನು ದೆಕಿನ ಮನೆ ಕುನ್ನ ಮುಟ್ಟಾಡ್ಯುಸ ಕೈನ ಪುಚ್ಚಾಡ್ಯೊಸ? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ಯೆಸು ಸುತ್ತೆ ದೆಕಿನ ಎ ಕಾಮ ಕುನ್ನ ಕರ‍್ಯುಸ ಕೈನ ದೆಕ್ತಾಮಾ ತೆಕ್ಲಾಮಾಜ಼಼ ");
INSERT INTO sle_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ರ‍್ಹಯಲ ತೆ ಹೆಣ ಮನಕ್ಹ ತಿನೆ ಥಯಲ ದೆಕಿನ ಭುಚ಼ಕಿನ ಕಾಪತಿ ತಿಕನ ಐನ ಪಗೊಪರ ಆಡ್ಡ ಪಡಿನ ರ‍್ಹಯಲ ವಿಚಾರ ಕ್ಹರಿ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ಯೆಸು ತಿನೆ ಮಾರಿ ದಿಕ್ರಿ ತಾರೊ ಬರೊಕ್ಹೊ ತುನೆ ಅರಾಮ ಕರ‍್ಯೊಸ ಸಮಾಧಾನೆ ಜಾ಼ ತುನೆ ಕದ್ರಾಯಲ ರೊಗ ಗೈನ ತುನೆ ಅರಾಮ ಥೈಯುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ಯೆಸು ಹಜು಼ನ ಬೊಲ್ತಾಮಾಜ಼ ಅದಿಕಾರಿ ಥಯಲ ಯಾಯಿರನಾ ಘರ್ತೊ ಯಕ್ಲೊ ಐನ ತಾರಿ ದಿಕ್ರಿ ಮರಿ ಗೈಸ. ಹಮ್ನಾ ಕಾ ಗುರುನೆ ತರಾಸ ಕರಾಡ್ಯೊಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ತ್ಯುನೆ ಕದಲ ವಾತೊ ಯೆಸು ಧ್ಯಾನ ದಿದ್ಯಾ ವಾಚಿ಼ ತಿನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ. ಭುಚ಼ಕು ನಕೊ ಬರೊಕ್ಹೊ ರ‍್ಹವಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ವರಿ ಯೆಸು ಪೆತ್ರಾ ಯಾಕೊಬನೆ ಯಾಕೊಬ್ನೊ ನ್ಹಾನೊ ಭೈ ಯೊಹಾನ ಇವ್ನೊನೆ ಛೊಡಿನ ಕಿನೆಜ಼಼ ತಿಕನ ಆವಾನೆ ದಿದ್ಯೊ ನೈ ");
INSERT INTO sle_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ತ್ಯುನೆ ಯಾಯಿರನಾ ಘರೆ ಆತಾಮಾ ದಕ್ಹಾಜ಼಼ನಾ ಘನ್ನಾ ಗದ್ದಲ ಕರತಾ ರವಾಡ್ಯಾತಾ ಯೆಸು ತೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ಯೆಸು ಮ್ಹೈ ಗೈನ ತುಮೆ ಗದ್ದಲ ಕರಾನು ಕಾ? ರವಾನು ಕಾ? ಛೊಕ್ರಿ ಮರಿನತ್ತಿ ");
INSERT INTO sle_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ನಿಂದರಕರಾಡಿಸ ಕತಾಮಾ ತ್ಯುನೆ ಯೆಸುನೆ ದೆಕಿನ ಕದ್ರೈನ ಅಕ್ಹ್ಯಾ. ವರಿ ಯೆಸು ಕ್ಹಾರಾಜ಼ನಾವೊನೆ ಭಾರೊ ಮೊಕ್ಲಿನ ತೆ ಛೊಕ್ರಿನಾ ಯಾ ಬಾ ನೆ ತಿವ್ನಾ ಕ್ಹಾತೆ ತನ ಶಿಷ್ಯಾವೊನೆಲಿನ ಛೊಕ್ರಿ ರ‍್ಹಯಲ ಜ಼ಗಾ ಬಲೈ ನಿಂಗೈನ. ");
INSERT INTO sle_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ತಿನೊ ಹತ್ತ ಧರಿನ ತಲಿಥಾ ಕೊಮ ಕದ್ಯೊ. ತಿಮ್ಮ ಕದ್ಯಾಮ ನ್ಹಾನಿ ಛೊಕ್ರಿ ಮಿ ಕವಾಡ್ಯೊಸ ತು ಉಟ. ");
INSERT INTO sle_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ತೆಳಾಮಾಜ಼ ತೆ ಛೊಕ್ರಿ ಉಟಿನ ಚಾ಼ಲಾಡಿ. (ತೆ ಬಾರಾ ವರಕ್ಹನಿ ವ್ಹತ್ತಿ) ತ್ಯುನೆ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ತೆಳಾಮಾಜ಼ ಯೆಸು ತ್ಯುನೊನೆ ಆ ಕಿನೆಜ಼಼ ಗೊತ್ತಥೌನೈ ಕೈನ ತಾಕಿತ ಕವಾಡ್ಯೊಸ ಕದ್ಯೊ. ತೆ ಛೊಕ್ರಿನೆ ಖಾವಾನೆ ದಿವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ಯೆಸು ತೆ ಜ಼ಗಾ ಛೊಡಿನ ತ್ಯಾಂತೊ ತಿನಾ ಸ್ವಂತ ಗಾಮೆ ಆಯೊ ಶಿಷ್ಯಾಬಿ ತಿನಾ ಪಾಚಾ಼ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ಸಬ್ಬತ (ಐತ್ವಾರ) ದಿನ್ನ ಆತಾಮಾ ಯೆಸು ಸಭಾಮಂದಿರಮಾ ಗೈನ ಉಪದೆಶ ಕರಾನು (ಕ್ಹುದಾನಿಯೊ ಚೊ಼ಕಿಯೊ ವಾತೊ ಕವಾನು) ಶುರುಕರ‍್ಯೊ ಘನ್ನಾ ಮನಕ್ಹೊ ತ್ಯಾ ವ್ಹತ್ತಾ ಕ್ಹಾರಾಜ಼ನಾ ತಿನಿಯೊ ವಾತೊ ಐಕಿನ ಘಾಬ್ರಾಥಯಾ. ಇನೆ ಎ ವಾತೊ ಕಿಜ಼್ಗಾಂತಿಯೊ ಆಯೊಸ? ಇನೆ ಎ ಕ್ಹಾರು ಗ್ಯಾನ ಕಿಜ್ಗಾಂತು ಮಳ್ಯುಸ? ಎ ಕಿಮ ಅದ್ಭುತ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ಎ ಬಡಗ್ಯಾನು ಕಾಮ ಕರಾಲೊ ನ್ಹವೈಸು? ಎ ಮರಿಯಳನೊ ದಿಕ್ರೊ ನ್ಹವೈಸು ಯಾಕೊಬ ಯೊಸೆಫ ಯುದ ವರಿ ಸಿಮೊನನೊ ಮ್ಹೊಟೊ ಭೈ ನ್ಹವೈಸು? ಇನಿಯೊ ಭೆನೊ ನ್ಹ್ಯಾಜ಼ ಅಪ್ನೊಕನ ನತ್ತಿಸು? ಇನಾ ಹುತಿ ತ್ಯುನೆ ಯೆಸುನೆ ಇನ್ಕಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ಪ್ರವಾದಿ ಬಿಜಿ ಝಗಾ ರ‍್ಹವಾದೆ ಮರ್ಯಾದಿ ಛೆ ತೆನೈಸೊ ತಿನಾ ಸ್ವಂತ ಗಾಮ್ಮಾ ಸ್ವಂತ ಮನಕ್ಹೊಮಾ ಸ್ವಂತ ಘರಮಾ ತ್ಯಾ ಯಕ್ಕಜ಼ ಮರ್ಯಾದಿ ನತ್ತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ತೆ ತ್ಯಾ ದಕ್ಹಾಜ಼಼ನಾ ರೊಗ ರ‍್ಹಯಲ ವಾಲಾವೊಪರ ಹತ್ತ ಮ್ಹೆಲಿನ ಅರಾಮ ಕರ‍್ಯೊ ತೆ ಛೊಡಿನ ಬಿಜು಼ ಕಯುಜ಼ ಮ್ಹೊಟು ಕಾಮ ಕರಾನೆ ಥಯೊನೈ ಕಾಕದ್ಯಾಮ ತ್ಯುನೊಮಾ ಬರೊಕ್ಹೊ ನ್ಹೊತೊ ");
INSERT INTO sle_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ಮನಕ್ಹೊಮಾ ಬರೊಕ್ಹೊ ನೈ ರ‍್ಹಯಲ ದೆಕಿನ ತಿನೆ ಘನ್ನು ಅಜಪ ಲಾಗ್ಯು. ತೆಳಾಮ ಯೆಸು ಗಾಮ್ಮಾ ಐನ ವರಿ ಶಿಕ್ಕಲಾವಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ಪಾಚಲ್ತೊ ಯೆಸು ಸುತ್ಲ್ಯಾ ಗಾಮೊಪರ ಫರಿನ ಉಪದೆಶ ಕರತೊ ಆಯೊ. ವರಿ ಬಾರಾ ಜ಼ನಾ ಶಿಷ್ಯಾವೊನೆ ತಿಕನ ಬಲೈನ ತ್ಯುನೊನೆ ಬೆ-ಬೆ ಜ಼ನಾವೊನೆ ಮೊಕಲ್ತಾಮಾ. ವರಿ ತ್ಯುನೊನೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊಪರ ಅದಿಕಾರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ತೆಳಾಮಾ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ. ಲಾಕ್ಕಡಿ ಛೊಡಿನ ವಾಟಮಾ ಬಿಜು಼ ಸುಜ಼ ನಿಂಜಾವೊನಕೊ. ಭುತಿ ನಕೊ ಗಾಮೆ ನಿಂಜಾ಼ವಾನಿಯೊ ಚಾ಼ಂಬಡಾನಿ ಪಟ್ಟಿನಿ ಪಿಶಿಯೊ ನಕೊ ಪಿಶಿಮಾ ದೊಕ್ಡಾ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ಚ಼ಪ್ಲೊ ಘಾಲ್ಲಿವೊ ಬೆ ಅಂಗ್ಡಾ ಲಿವೊ ನಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ಎನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ -ತುಮೊನೆ ಕಯಾ ಘರಮಾ ಬಲೈ ಲಿವಸ ತೆ ಜ಼ಗಾ ಛೊಡಿನ ಜಾ಼ಯೆಲಕ್ಕಾ ತ್ಯಾಜ಼ ರಹೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ತುಮೆ ಯಕ್ಕ ಗಾಮ್ಮಾ ಆತಾಮಾ ತ್ಯಾ ತುಮೊನೆ ಮನಕ್ಹೊ ಒಪ್ಪಿನೈಲಿದ್ಯಾಮ ಎನೈಸೊ ಮನಕ್ಹೊ ತುಮಾರಿಯೊ ವಾತೊ ನೈ ಐಕ್ಯಾಮ ತುಮಾರಾ ಪಗೊನು ಧುಳ್ಳ ತ್ಯಾಜ಼ ಝಾಡಿಸಿಲಿವೊ ತೆ ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಾಕ್ಷಿ ಥೈನ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ತ್ಯುನೆ ಗೈನ ಮನಕ್ಹೊನೆ ಪಾಪೊ ಕರಾನು ಛೊಡಿಪಾಡೊ ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ತ್ಯುನೆ ಘನ್ನಾ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಛೊಡಾಯಾ ವರಿ ಘನ್ನಾ ರೊಗಿಯೊನೆ ಒಲಿವ ತೆಲ ಮಾತಾಪರ ಲಗಾಡಿನ ಪ್ರಾಥನಾ ಕರತಾಮಾ ತ್ಯುನೊನೆ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ತೆಳಾಮಾ ರಾಜೊ಼ ಥಯಲ ಹೆರೊದ. ಯೆಸುನಿ ಸುದ್ದಿ ಐಕಿನ ಕಾಕದ್ಯಾಮ ತಿನು ನಾಮ ಘನ್ನು ಫೈಲಿಗಯುತು. ವರಿ ಮನಕ್ಹೊ ತಿನಾಹುತಿ-ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಥಯಲ ಯೊಹಾನಜ಼ ಫರಿನ ವಾಚಿ಼ನ ಆಯೊಸ. ತಿನಾಹುತಿ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಕಾಮೊ ಕರಾನಿ ತಾಕತ ತಿನಾಮಾ ಛೆ ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಎ ಪ್ರವಾದಿ ಥಯಲ ಎಲಿಯಾ ವ್ಹೈ ಕೈನ ಕತಾತಾ ವರಿ ದಕ್ಹಾಜ಼಼ನಾ ಎ ಪಾಚ಼ಲ್ಯಾ ರ‍್ಹಯಲ ಪ್ರವಾದಿಯೊಮಾನೊ ಯಕ್ಲೊ ಲಿಂಗತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ತೆಳಾಮಾ ಹೆರೊದ ರಾಜೊ಼ ತಿನಿ ಸುದ್ದಿ ಐಕಿನ - ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನ ವ್ಹೈಸು ಮಿ ಗರದನ ಕತ್ರಲ ಯೊಹಾನ ವಾಚಿ಼ನ ಆಯೊಸು ಕದ್ಯೊ! ");
INSERT INTO sle_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ಯೊಹಾನನೆ ಧರಿಲಾವಾನೆ ತಿನಾ ಸೈನಿಕೊನೆ ಹೆರೊದ್ಯಜ಼ ಕದ್ಯೊತೊ ತೆಳಾಮಾ ತ್ಯುನೆ ಯೊಹಾನನೆ ಜೆಲಮಾ ಘಾಲ್ಯಾ ಕಾಕದ್ಯಾಮ ಹೆರೊದ ತೆ ಮುಕ್ಕಕಿಲಿದಲ ಹೆರೊದ್ಯಳನಾ ಹುತಿ ಯೊಹಾನನೆ ಧರಿಲೈನ ಜೆಲಮಾ ಭಾಂದಿನ ಘಾಲ್ಯೊತೊ. ತೆ ಹೆರೊದ್ಯಳ ಹೆರೊದನಾ ಮ್ಹೊಟೊ ಭೈ ಫಿಲಿಪ್ಪನಿ ಬೈಕೊ ವ್ಹತ್ತಿ ");
INSERT INTO sle_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ಯೊಹಾನ ಹೆರೊದನೆ ಹಗ್ಲೆಲ್ಲಾ ಕತೊತೊ ತಾರಾ ಭೈನಿ ಬೈಕೊನೆ ಹಿವಾ ಕರಿಲಿವಾನು ಚೊ಼ಕು ನ್ಹವೈ ಕೈನ ಕತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ತಿನಾಹುತಿ ಹೆರೊದ್ಯಳ ತಿನಾ ಉಪ್ಪರ ಶಿಟ್ಟ ಮ್ಹೆಲ್ಲಿನ ತಿನೆ ಖಲಾಸ ಕರಾವುಕೈನ ವಿಚಾರ ಕರಿತಬಿ ಹೆರೊದನಾ ಹುತಿ ತಿನಾ ಹತೆ ಥಯುನೈ. ");
INSERT INTO sle_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ಹೆರೊದ ಯೊಹಾನ ಕ್ಹುದಾನೊ ಭೆ ರ‍್ಹಯಲ ವಾಲೊ ವರಿ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿನ ತಿಕ್ಹು ಭುಚ಼ಕಿನ ತಿನೆ ಸು ಥಾವುನೈ ಕೈನ ಮುಕ್ಕಯೊತೊ ಎನೈಸೊ ಯೊಹಾನ ಕವಾನು ತಿನೆ ಐಕ್ತಾಮಾ ಮನಸೆ ಘನ್ನು ಗಲಿಬಿಲಿ ಥಯುತಬಿ ತಿನಿಯೊ ವಾತೊ ಧ್ಯಾನ ದಿನ್ನ ಐಕ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಯಕ್ಕ ದಿನ್ನ ತಿನೆ ಅನುಕುಲ ದಿನ್ನ ಆಯೊ. ಕಿಮ ಕದ್ಯಾಮ ಹೆರೊದನಾ ಹುಟ್ಟಲ ದಿನಮಾ ತೆಳಾಮಾ ತೆ ಪ್ರಭುವೊನೆ ಸೆನಾಧಿಪತಿನೆ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯನಾ ಶಾನಾವೊನೆ ಖಾವಾನೆ ಕರತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ಹೆರೊದಳನಿ ದಿಕ್ರಿ ಮ್ಹೈ ಐನ ನ್ಹಾಚಿ಼ನ ಹೆರೊದನಾ ಕ್ಹಾತೆ ಸಾಲಮಾ ಕ್ಹಾವಾನೆ ಬೈಟಲವಾಲಾವೊನೆ ಖುಶಿ ಕರಿ. ರಾಜೊ಼ ತೆ ಛೊಕ್ರಿನೆ ಸು ಚಾ಼ಯೆ? ಮಾಂಗ ಸು ಮಾOಗಶಿ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ತು ಮಕನ ಸು ಮಾಂಗಿಲೆಸಿ ಮಾಂಗ ಕದ್ಯೊ. ಮಾರಾ ರಾಜ್ಯಮಾನೊ ಅರಧೊವಾಟೊ ಮಾಂಗಿತಬಿ ಮಿ ತುನೆ ದ್ಯುಸ ಕೈನ ಕ್ಹಮ ಘಾಲಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ತೆಳಾಮಾ ತೆ ಛೊಕ್ರಿ ಭಾರಿ ಗೈನ ಮಿ ಸು ಮಾಂಗಿಲ್ಯು? ಕೈನ ತಿನಿ ಯಾನೆ ಪುಚ಼ತಾಮಾ ತೆ ತಿನೆ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಥಯಲ ಯೊಹಾನನು ಮಾತು ಮಾಂಗಿಲೆ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ತೆಳಾಮಾಜ಼ ತೆ ರಾಜಾ಼ ಕನ ಭರನೆ ಐನ ಹಮ್ನಾಜ಼ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಥಯಲ ಯೊಹಾನನು ಮಾತು ಪರಾತ್ಮಾ ಮನೆ ಲೈನ ದ್ಯು ಕೈನ ಮಾರಿ ಆಸ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ತೆ ವಾತೆ ರಾಜಾ಼ನೆ ಘನ್ನು ದುಖಥಯ್ಯು ತೆ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಕದಲ ಹುತಿ ತಿನೆ ಇನ್ಕಾರ ಕರಾನೆ ಥೈಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ತಿನಾಹುತಿ ರಾಜೊ಼ ಸೈನಿಕೊಮಾನಾ ಯಕ್ಲಾನೆ ಬಲೈನ ತು ಗೈನ ಯೊಹಾನನಿ ಗರದನ ಕತ್ರಿನ ಲೈನ ದೆ ಕೈನ ಅಪ್ಪಣೆ ದಿನ್ನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ತೆ ಜೆಲಮಾ ಗೈನ ಯೊಹಾನನಿ ಗರದನ ಕತ್ರಿನ ಪರಾತ್ಮಾ ಮ್ಹೆಲಿನ ತೆ ಛೊಕ್ರಿನೆ ಲೈನ ದಿದ್ಯೊ. ತೆ ಛೊಕ್ರಿ ಗೈನ ತಿನಿ ಯಾನಾ ಹತ್ಮಾ ದಿದಿ. ");
INSERT INTO sle_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಎಕ್ಹಾರು ಐಕ್ತಾಮಾ ತ್ಯುನೆ ಐನ ತಿನೊ ಮುರದೊ ಉಚೈನ ಲಿನಗೈನ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ಅಪೊಸ್ತಲೊ ಮಳಿನ ಯೆಸುಕನ ಐನ ತ್ಯುನೆ ತೆ ಕದಲ ತೆ ಕ್ಹಾರು ಕರಿನ ಕರಲ ಕ್ಹಾರು ಉಪದೆಶ ತಿಕನ ತಿಳಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ಯೆಸು ತ್ಯುನೊನೆ ಆವೊ ಅಪೆ ಕುನ್ನ ನೈಸೊ ಜ಼ಗಾ ಗೈನ ಅರಾಮ ಕರಿಯೆ ಕದ್ಯೊ. ಕಾಕದ್ಯಾಮ ಘನ್ನಾ ಮನಕ್ಹೊ ಆವಾನು ಜಾ಼ವಾನು ಕರಾಡಾತಾ ತ್ಯುನೊನೆ ಕ್ಹಾವಾನೆ ಬಿ ಟೈಮ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ತಿನಾಹುತಿ ತೆಳಾಮಾ ತ್ಯುನೆ ಹಡಗಾಮಾ ಗೈನ ಕುನ್ನ ನೈಸೊತ್ಯುನೆ ಯಕ್ಲಾಜ಼ ರ‍್ಹವಾನಿ ಜ಼ಗಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ತ್ಯುನೆ ಜಾ಼ವಾನು ಘನ್ನಾ ಮನಕ್ಹೊ ದೆಕಿನ ತ್ಯುನೊನೆ ವಳಕಿನ ಕ್ಹಾರಾ ಗಾಮೊತಾ ಮನಕ್ಹೊ ಚಾ಼ಲ್ತಾ ನ್ಹಾಟ್ತಾ ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊತಿ ಅಗ್ದುರ ತೆ ಜ಼ಗಾಪರ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ತೆಳಾಮಾ ಯೆಸು ಹಡಗಾಮಾತೊ ಉತ್ರಿನ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ದೆಕಿನ ಇವ್ನೆ ಕುರಬುರ‍್ಯೊ ನೈಸೊ ಬಕ್ರಾವೊಲಿಂಗತ ಛೆ ಕೈನ ಘನ್ನೊ ಮರಗಿನ ತ್ಯುನೊನೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ತೆಕ್ಲಾಮಾಜ಼಼ ಕ್ಹಾಂಜ಼ ಥಯಲ ಹುತಿ ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿಕನ ಐನ ಆ ಕುನ್ನ ನೈಸೊ ಜ಼ಗಾ ವ್ಹೈ ಟೈಮ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ಎ ಮನಕ್ಹೊನೆ ಅಪ್ಪಣೆ ದೆ ಇವ್ನೆ ಆಜು಼ ಬಾಜ಼ುನಾ ಗಾಮೆ ಗೈನ ತ್ಯುನೆ ಖಾವಾನೆ ಸುಬಿ ಕರಲಿವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ತೆ ವಾತೆ ಯೆಸು \"ತುಮೆಜ಼ ಇವ್ನೊನೆ ಖಾವಾನೆ ಅನ್ನ ದಿವೊ ಕದ್ಯೊ. ತೆ ವಾತೆ ತ್ಯುನೆ-ಹಮೆ ಗೈನ ಬೆಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾಮಾ ಇವ್ನೊನೆ ರೊಕ್ಲಾ ಲೈನ ಕ್ಹಾವಾನೆ ದಿಯೆಸು? ");
INSERT INTO sle_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ಕೈನ ಪುಚ಼ತಾಮಾ ಯೆಸು -ತುಮೊಕನ ಕೆಕ್ಲಾ ರೊಕ್ಲಾ ಛೆ? ಕೈನ ದೆಕಿನ ಆವೊ ಕದ್ಯೊ. ತ್ಯುನೆ ದೆಕಿನ ಐನ ಪಾಂಚ಼ ರೊಕ್ಲಾ ಬೆ ಮಚ್ಲಿ಼ಯೊ ಛೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಹಸರ ಚಾ಼ರಾಪರ ಜಿಮಿನ್ಪರ ಬೈಟೊ ಕೈನ ಅಪ್ಪಣೆ ದೆತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ಇನಾಹುತಿ ಮನಕ್ಹೊ ಕ್ಹೊ ಯಕ್ಲಾ ಐವತ್ತ ಯಕ್ಲಾ ಗುಂಪ ಥೈನ ಬೈಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ತೆಳಾಮಾ ಯೆಸು ತೆ ಪಾಂಚ಼ ರೊಕ್ಲಾ ಬೆ ಮಚ್ಲಿ಼ಯೊಲಿನ ಹಬಾಳನೆ ದೆಕಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ತೆ ರೊಕ್ಲಾ ಭಾಗಿನ ತುಮೆ ಮನಕ್ಹೊನೆ ವಾಟೊ ಕೈನ ಶಿಷ್ಯಾವೊನಾ ಹತ್ಮಾ ದಿನ್ನ ತೆ ಬೆ ಮಚ್ಲಿ಼ಯೊ ಕ್ಹಾರಾವೊನೆ ವಾಟಾಲಗಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ತ್ಯುನೆ ಕ್ಹಾರಾ ಪೆಟ ಭರೆಲಕ್ಕಾ ಖಾದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ಶಿಷ್ಯಾ ಉಗ್ರಲ ರೊಕ್ಲಾನಾ ತುಕಡಾ ಮಚ್ಲಿ಼ಯೊನಾ ತುಕಡಾ ಮಳಾತಾಮಾ ಬಾರಾ ಟೊಪ್ಲಿಯೊ ಭರಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ಖಾದಲವಾಲಾವೊಮಾನಾ ಪಾಂಚ಼ ಹಜಾ಼ರ ದಾಣ್ಗಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ಎ ಥಯಲ್ಪರ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಮಿ ಆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಮೊಕ್ಕಲಾತಿ ಅಗ್ದುರ ತುಮೆ ಹಡ್ಗೊ ಚ಼ಡಿನ ಅಗಾ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಯೆ ಬೆತ್ಸಾಯಿ ಕವಾನಾ ಗಾಮೆ ಜಾವೊ ಕೈನ ಜು಼ಲಮೆ ಮೊಕಲ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ಯೆಸು ಮನಕ್ಹೊನೆ ಅಪ್ಪಣೆ ದಿದಲ್ಪರ ಪ್ರಾಥನಾ ಕರಾಹುತಿ ಡೊಂಗರಪರ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ಕ್ಹಾಂಜ಼ ಥಯಲ್ಪರ ಹಡ್ಗೊ ಸಮುಂದರನಾ ವಚ಼ಮಾ ವ್ಹತ್ತೊ. ತೆಳಾಮಾ ಯೆಸು ಯಕ್ಕಲೊಜ ದOಡಿಪರ ವ್ಹತ್ತೊ ");
INSERT INTO sle_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ಯೆಸುನಾ ಶಿಷ್ಯಾ ಸಮುಂದರಮಾ ಹಡಗಾಮಾ ಬೈಟಿನ ತ್ಯುನೆ ಹಡಗಾನೆ ತ್ರಾಸ ಖಾತಾ ತೆಳಾಮಾ ತನ ಯಾ ಛೆ ವಾಸ್ತಾ ದಿನ್ನ ನಿಕ್ಹಳಾನಾ ಟೈಮಾ ಯೆಸು ಸಮುಂದರಪರ ಚಾ಼ಲ್ತೊ ತ್ಯುನಾ ಕ್ಹಾಮಾತೊ ಅಗೊ ಜೌ಼ ಕದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ಸಮುಂದರಪರ ಚಾ಼ಲಾನು ದೆಕಿನ ತ್ಯುನೆ ಭುತ್ಡು ವ್ಹೈ ಕೈನ ತಿಳ್ದಿನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ತ್ಯುನೆ ಕ್ಹಾರಾಜ಼ನಾ ತಿನೆ ದೆಕಿನ ಭುಚ಼ಕಿನ ಘಾಬ್ರಾಥಯಾ ತೆಳಾಮಾಜ಼ ತೆ ತ್ಯುನೊನೆ ಬೊಲಿನ ತ್ಯುನೊನೆ ಧೈರ್ಯಕ್ಹು ರಹೊ ಮಿ ವ್ಹೈ ಭುಚ್ಕೊ಼ ನಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ತೆಳಾಮಾಜ಼ ಯೆಸು ಹಡಗಾಮಾ ಚ಼ಡಿನ ತ್ಯುನೊಕನ ಆಯಲಪರ ವಾರೊ ಹುಬ್ರೈಪಾಡ್ಯೊ. ತೆಳಾಮಾ ಶಿಷ್ಯಾ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ಕಾಕದ್ಯಾಮ ಪಾOಚ಼ ಹಜಾ಼ರ ಮನಕ್ಹೊನೆ ಅನ್ನ ಖಲಾಯಲ ತ್ಯುನೆ ತಿಳದ್ಯಾ ನ್ಹೊತಾ ತೆ ತಿನಾ ವಾಸ್ತರ ತೆ ಮ್ಹೊಟು ಕಾಮ ತ್ಯುನೆ ತಿಳದಿಲಿದ್ಯಾ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ತ್ಯುನೆ ಸಮುಂದರ ದಾಟಿನ ಗೆನೆಜರೆತೆ ಕವಾನಾ ದೆಶನಿ ದಂಡಿಯೆ ಮುಟ್ಟಿನ ಹಡ್ಗೊ ಭಾಂದ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ತ್ಯುನೆ ಹಡಗಾಮಾತಾ ಉತ್ರಲ ಬರೊಬ್ಬರ ಮನಕ್ಹೊ ಯೆಸುನೆ ವಳಕಿನ. ");
INSERT INTO sle_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ತೆ ಪ್ರಾOತ್ಯಮಾತಾ ನ್ಹಾಟ್ತಾ ಅಂಗಮಾ ಅರಾಮ ನೈಸೊ ವಾಲಾವೊನೆ ಬೊರಿಯ್ಯಾಪರ ಘಾಲ್ಲಿನ ತೆ ಕಿಜ್ಗಾ-ಕಿಜ್ಗಾ ಛೆ ಕೈನ ಪುಚಿ಼ನ ತ್ಯಾ-ತ್ಯಾ ನಿಂಜಾ಼ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ವರಿ ಯೆಸು ಕ್ಹಾರಿ ಜ಼ಗಾ ಗಯೊ ಖೆಡಾವೊಪರ ವರಿ ಗಾಮ್ಮಾ ನೈತೊ ಖೆತ್ರೊನೆ ತ್ಯಾ ಮನಕ್ಹೊ ಅಂಗಮಾ ಅರಾಮ ನೈಸೊ ವಾಲಾವೊನೆ ಬಾಜ಼ರೊನಾ ವಚ್ಮಾ಼ ಲಾತಾತಾ. ವರಿ ಯೆಸುಕನ ತಿನಾ ವಣ್ಣಾವೊನಾ ಗೊಂಡಾವೊನೆ ಮುಟ್ಟೌ ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ತಿನೆ ಮುಟ್ಟಲ ವಾಲಾ ಅರಾಮ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ಎ ಥಯಲ್ಪರ ಯೆರುಸಲೆಮ್ತಾ ಆಯಲ ಫರಿಸಾಯರೊಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ ಶಾಸ್ತ್ರಿಯೊ ಕುಡಿನ ಯೆಸುನಾ ಸುತ್ತೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ವರಿ ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿವ್ನಿ ಪದ್ದತಿನಿOಗತ ಹತ್ ಧ್ವಯಾವಾಚಿ ಅನ್ನ ಖಾವಾನು ದೆಕ್ಯಾ ತ್ಯುನೆ ಕಾಕದ್ಯಾಮ ತ್ಯುನಿ ಪದ್ದತ್ ಲಿಂಗತ ಖಾವಾತಿ ಅಗ್ದುರ ಹತ್ ಧ್ವಯಾನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(ಕಾಕದ್ಯಾಮ ಫರಿಸಾಯರೊ ವರಿ ಯೆಹುದಿ ತ್ಯುನೊನೆ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಶಿಕ್ಲಾಯಲ ಪದ್ದತ ತಿವ್ನಾ ಹತೊ ಚೊ಼ಕಿ ತರಾ ಧ್ವಲಿದ್ಯಾವಾಚಿ ಖಾತಾನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ತಿನಾನಿOಗತ ಬಾಜ಼ರಮಾತಾ ಖಾವಾನು ಸುಬಿಲಾಯಮ ಧ್ವಯಾವಾಚಿ ಖಾತಾನ್ಹೊತಾ ಎ ಯಕ್ಕ ತರಾನಿ ಪದ್ದತ ತ್ಯುನೆ ಘನ್ನಿ ತರಾನಿಯೊ ಪದ್ದತೊ ಕರತಾತಾ ಎನೈಸೊ ತ್ಯುನೊಮಾ ತಾಂಬಿಯಾ ವಾಟಕಾ ತಪಾಲೊ. ಬೆಳಗಿನ ಧವಾನು ವಚ್ಚಾ಼ನಾ ಧೊತಾತಾ ಹಜು಼ನ ಘನಿಯೊ ಶುದ್ಧಾಚಾರ (ಪದ್ದತ) ಕರತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ಇನಾಹುತಿ ಫರಿಸಾಯೊರೊ ಶಾಸ್ತ್ರಿಯೊ ಯೆಸುನೆ ಪುಚ್ಯಾ ತಾರಾ ಶಿಷ್ಯಾಮ್ಹೊಟಾ ಮನಕ್ಹೊತಿ ಆಯಲ ಪದ್ದತಿ ಲಿಂಗತ ಕಾ ನೈ ಚಾ಼ಲ್ತಾ? ರಾಡಿ ಹತೊ ಕ್ಹು ಅನ್ನ ಕಾ ಖಾವಸ? ");
INSERT INTO sle_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ಯೆಸು ಜ಼ವಾಬ ದಿದ್ಯೊ ಕಪಟಿಯೊ ಥಯಲ ತಮಾರಾ ವಾಸ್ತರ ಯೆಶಾಯಾ ಬರ್ದಲ ಕೆಕ್ಲೊ ಕರೆಟ್ಟ ಛೆ! ತುಮೆ ಮ್ಹೈ ಯಕ್ಕ ಭಾರಾ ಯಕ್ಕ ತೆ ತಿಮ್ಮ ಬರ್ದಲ, ಕ್ಹುದಾ ಕದ್ಯೊ ಎ ಮನಕ್ಹೊ ಕ್ಹಾಲಿ ವಾತೊಕ್ಹು ಮನೆ ಮರ್ಯಾದಿ ದಿವಸ ವರಿಬಿ ತ್ಯುನು ಮನಸ ಮಕ್ಹು ಘನ್ನು ದುರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ಇವ್ನೆ ಮಾರಿ ಆರಾಧನಾ ಕರಾನು ಸುಜ಼ ಉಪಯೊಗ ನತ್ತಿ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಕ್ಹುದಾನಿ ಪದ್ದತ ಛೊಡಿನ ತ್ಯುನಾ ನಿಯಮೊ ಉಪದೆಶ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ತುಮೆ ಕ್ಹುದಾನಿಯೊ ಪದ್ದತ ಛೊಡಿನ ಮನಕ್ಹೊನಿ ಪದ್ದತ ಕರೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ ತುಮೆ ತುಮಾರಾ ಗ್ಯಾನ ಉಪಯೊಗ ಕರಲಿನ ಕ್ಹುದಾನಿ ಪದ್ದತಿ ದುರ ಕರಾಡಾಸ ವರಿ ತುಮಾರಿಯೊ ಪದ್ದತಿಯೊ ಮನಕ್ಹೊನೆ ಕರೊ ಕೈನ ಶಿಕ್ಕಲಾವಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ಮೊಶೆ ಸು ಕದ್ಯೊಸ ಕದ್ಯಾಮ ಯಾ. ಬಾಪನೆ ಮರ್ಯಾದಿ ದ್ಯು ವರಿ ಕೈನ ಬಾಪನೆ ರ‍್ಹ್ಯೆನೆಕಾ ಯಾನೆ ರ‍್ಹ್ಯೆನೆಕಾ ಕ್ಹರಾಪಾಲಾನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ಥಾವು ; ");
INSERT INTO sle_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ತಿಮ್ಮಜ ತುಮೆ ಕವಾನು ಸುವೈ ಕದ್ಯಾಮ, ಯಕ್ಲೊ ತಿನಾ ಯಾ ಬಾಪನೆ, ದಿವಾನು ಮಿ ಕ್ಹುದಾನೆ ದಿದ್ಯೊಸ ಕವೊ ಕೈನ ಶಿಕ್ಲಾಯಾಸ್ತೊ( ತಿನು ಮತ್ಲಬ ತೆ ಕ್ಹುದಾನು ವ್ಹೈ). ");
INSERT INTO sle_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ತೆ ತಿನಾ ಯಾ ಬಾಪನೆ ಆಸ್ರೊ ನೈ ಕರ‍್ಯೊ ಸುಜ಼ ತರಾಸ ನತ್ತಿ ಇಮ್ಮ ಕವೊಸಿತೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ಇಮ್ಮ ತುಮೆ ಶಿಕ್ಲಾತಾ ಆಯಲ ಪದ್ದತಿಕ್ಹು. ಕ್ಹುದಾನಿಯೊ ವಾತೊನಿ ತಾಕತ ಇಕ್ಹರಿ ಪಾಡೊಶಿ. ವರಿ ಇಮ್ಮಜ಼ ಹವಾ ಕಾಮೊ ಕೆಕ್ಲಾ ಕರೊಶಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ತಿಕನ ಬಲೈನ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಕ್ಹಾರಿಯೊ ಮಾರಿಯೊ ವಾತೊ ಕಾನ ದಿನ್ನ ಐಕೊ ವರಿ ತಿಳದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ಭಾರಾತು ಮನಕ್ಹೊನಾ ಮ್ಹೈ ಗೈನ ತ್ಯುನೊನೆ ಹೊಲಸ ಕರಾನು ಯಕ್ಕ ಬಿ ನತ್ತಿ; ");
INSERT INTO sle_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ತೆನೈಸೊ ಮನಕ್ಹೊಮಾತು ಜಾ಼ವಾನು ತಿನೆಜ ಹೊಲಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಮನಕ್ಹೊನೆ ಛೊಡಿನ ಘರಮಾ ಜಾ಼ತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾತಿನೆ ತೆ ವಾತನೊ ಮತ್ಲಬ ಸುವೈ ಕೈನ ಪುಚ಼ತಾಮಾ ತೆ ತ್ಯುನೊನೆ. ");
INSERT INTO sle_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ಯೆಸು ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ. ತುಮೊನೆ ತೆಕ್ಕಲಿಬಿ ಗ್ಯಾನ ನತ್ತಿಸು? ತುಮೊನೆ ಗೊತ್ತ ಥಾತು ನೈಸು ಯಕ್ಕ ಮನಕ್ಹನಾ ಮ್ಹೈಜಾ಼ವಾನು ಕ್ಹರಿಮಾಜ಼ ತಿನೆ ಹೊಲಸ ನೈ ಕರತು. ತೆವೊ ಸುಜ಼ ನತ್ತಿ ಭಾರಾತು ಮನಕ್ಹೊನಾ ಮ್ಹೈ ಜಾ಼ವಾನು. ");
INSERT INTO sle_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ಕಾಕದ್ಯಾಮ ತೆ ಮನಸ್ಮಾ ಗಯಾವಾಚಿ ಪೆಟಮಾ ಗೈನ ಪಾಚಾ಼ತು ಭಾರು ಜಾ಼ವಸ (ಯೆಸು ಎ ಕೈನ ಖಾವಾನು ಕ್ಹಾರುಬಿ ಚ಼ೊಕು ವ್ಹೈ ಕದ್ಯೊ) ");
INSERT INTO sle_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ಯೆಸು ವರಿ -ಮನಕ್ಹೊನಾ ಮ್ಹೈತು ಜಾ಼ವಾನುಜ಼ ಮನಕ್ಹೊನೆ ಹೊಲಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ಯಕ್ಕ ಮನಕ್ಹನಾ ಮ್ಹೈತು ಕದ್ಯಾಮ ಮನಕ್ಹೊನಾ ಮನಸ ಮಾತು. ಜಾ಼ವಾನು ಕೈ ವ್ಹೈ ಕದ್ಯಾಮ ತೆ ತಿನೆ ಕೆಟ್ಟ ಕಾಮೊಮಾ ಚ಼ಲಾವಸ ತೆ ಕೈಯು ವ್ಹೈ ಕದ್ಯಾಮ ವೈಭಿಚಾರ ಕಾಮೊ ಚೊ಼ಟ್ಟಿತನಾ ಖಲಾಸ ಕರಾನು. ");
INSERT INTO sle_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ಸುಳಿತನಾ ಹಾದರತನಾ ದೊಕಡಾವೊಪರ ಆಸ ಕೆಡತನಾ ಮೊಸ ಸಂಗಟ ಘಾಲ್ಲಿವಾನು ಗಾಳೊ ದಿವಾನು ಸೊಕ್ಕಕ ಸುಳ್ಳ ಬೊಲಾನು. ");
INSERT INTO sle_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ಎ ಕ್ಹಾರಿಯೊ ಕೆಟ ವಿಚಾರೊ ಮನಕ್ಹೊನಾ ಮ್ಹೈತು ಗೈನ ತೆ ಮನಕ್ಹನೆ ಹೊಲಸ ಕರಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ಯೆಸು ತ್ಯಾಂತೊ ಉಟಿನ ಜಾ಼ತೊ ತೊರ ಕವಾನಾ ಗಾಮ್ನಾ ನಜಿ಼ಕ ರ‍್ಹಯಲ ಪ್ರದೆಶೆ ಗಯೊ. ಗೈನ ಯಕ್ಕ ಘರಮಾ ಗಯೊ ತೆ ಕಿನೆಜ಼಼ ಗೊತ್ತ ಥಾವುನೈ ಕೈಲಿದ್ಯೊ. ತೆನೈಸೊ ತೆ ಝಕೈನ ರ‍್ಹವಾನೆ ಥಯೊ ನೈ ");
INSERT INTO sle_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ತೆಳಾಮಾಜ಼ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ತಿನಿ ದಿಕ್ರಿನಾ ಅOಗಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ವ್ಹತ್ತಿ ಯೆಸು ತ್ಯಾ ಛೆ ಕೈನ ಸುದ್ದಿ ಐಕಿನ ತಿನಾ ಪಗೊಮಾ ಐನ ಪಡಿ. ");
INSERT INTO sle_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ತೆ ಹೆಣ ಮನಕ್ಹ ಬಿಜಿ ಜಾ಼ತನಿ ವ್ಹತ್ತಿ ತೆ ಶಿರಿಯ್ಯಾ ಪೊಯಿನಿಕ್ಕಯ ಪ್ರಾOತ್ಯ ಮಾ ಹುಟ್ಟಿತಿ ತೆ ಯಹುದ್ಯೊನಿ ಜಾ಼ತನಿ ನ್ಹೊತಿ. ತೆ ತಿನಿ ದಿಕ್ರಿನು ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾ ಕೈನ ಯೆಸುಕನ ಮಾಂಗಿಲೆತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ಯೆಸು ತಿನೆ- ಬಚ್ಚಾವೊನೆ ಪೈಲಾ ತೃಪ್ತ ಥಾವಾದೆ; ಬಚ಼್ಚಾಖಾವಾನೊ ರೊಕ್ಲೊ ಕಾಳ್ಳಿನ ಕುತ್ರಾವೊನಾ ಬಚ್ಚಾವೊನೆ ಘಾಲಾನು ಚೊ಼ಕು ವ್ಹೈಸು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ತೆ ವಾತೆ ತೆ -ಸ್ವಾಮಿ ಆ ವಾತ ಕ್ಹರಿ ವ್ಹೈ ಟೆಬಲನಾ ಹೆಟಾ ರ‍್ಹಯಲ ಕುತ್ರಾವೊನಾ ಬಚ್ಚಾ ಮನಕ್ಹನಾ ಬಚ್ಚಾ಼ನಾ ಹತಮಾತಾ ಪಡಲ ರೊಕ್ಲಾನಾ ತುಕಡಾ ಖಾವಸ್ತೊ ಕೈನ ಜ಼ವಾಬ ದೆತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ಯೆಸು ತಿನಿ ವಾತೆ ತಿನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ತಾರಿ ದಿಕ್ರಿನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಿಪಾಡ್ಯುಸ ಜಾ಼ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ತೆ ತಿನಾ ಘರೆ ಗೈನ ದೆಕ್ತಾಮಾ ತೆ ಛೊಕ್ರಿ ವಚ್ಚಾ಼ನಾಮಾ ಅರಾಮ ಕ್ಹುರೈತಿ ವರಿ ತಿನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಿನ ಗೈ ಪಡಿತಿ. ");
INSERT INTO sle_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತೊರ ಗಾಮ ಛೊಡಿನ ಸಿದೊನ ಗಾಮ ಪರತೊ ದೆಕಪೊಲಿ ಗಲಿಲಾಯ ಸಮುಂದರಕನ ರ‍್ಹಯಲ 10 ಗಾಮೊ ದಾಟಿನ ಚಾ಼ಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ತೆಳಾಮಾ ದಕ್ಹಾಜ಼಼ನಾ ತ್ವದಲಿನ ಬೊಲಾನಾ ಯಕ್ಕ ಕ್ಯುಡಾನೆ -ಯೆಸುಕನ ಬಲೈ ಲೈನ ಇಪರ ತು ಹತ್ತ ಮ್ಹೆಲ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ಯೆಸು ತಿನೆ ಮನಕ್ಹೊನಾ ಗುಂಪಮಾತೊ ಯಕ್ಕ ಬಗಲ ಬಲೈ ಲಿನ ಗೈನ ತಿನಾ ಬೊಟೊ ತಿನಾ ಕಾನೊಮಾ ಮುಕ್ಕಿನ ಥುಕ್ಕಿನ ತಿನಿ ಜಿಬ್ಬ ಮುಟ್ಯೊ. ಹಬಾಳನೆ ದೆಕಿನ ಉಸುಲ ಛೊಡಿನ ತಿನೆ ");
INSERT INTO sle_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ಎಪ್ಫಥಾ ಕೈನ ಕದ್ಯೊ. ತೆ ವಾತನೊ ಮತ್ಲಬ ವ್ಹೈ ಖುಲ್ಲಾಥಾವಾದೆ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ಕತಾಮಾ ತೆಳಾಮಾಜ಼ ತಿನಾ ಕಾನೊ ಖುಲ್ಲಾಥಯಾ ತಿನಿ ಜಿಬ್ಬಬಿ ಖುಲ್ಲಾ ಥೈ ತೆ ತರಾಸನೈಸೊ ಬೊಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ತೆಳಾಮಾ ಯೆಸು ಕಿನೆಜ಼಼ ಎ ತಿಳಸುನಕೊ ಕೈನ ತಾಕಿತ ಕರ‍್ಯೊ ವರಿ ಕೆಕ್ಲೊ ಕದ್ಯೊತಬಿ ವರಿ ಘನ್ನಾ ಮನಕ್ಹೊಕನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ಎ ಐಕಲವಾಲಾ ಕ್ಹಾರಾಜ಼ನಾ ಘನ್ನಾ ಘಾಬ್ರಾಥೈನ ಕ್ಹಾರು ಚೊ಼ಕು ಕರ‍್ಯೊಸ ಕಿವ್ಡಾ ರ‍್ಹಯಲವಾಲಾನೆ ಐಕಾ ವರಕ್ಹು ಕರಸ. ಮುಕಾ ರ‍್ಹಯಲವಾಲಾನೆ ಬೊಲಾ ವರಕ್ಹು ಕರಸ ಕೈನ ತಿಳದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ತೆ ದಿನಮಾ ಮನಕ್ಹೊ,ಫರಿನ ಗುಂಪ ಥೈನ ಕುಡಿನ ಆತಾಮಾ ತ್ಯುನೊನೆ ಖಾವಾನೆ ಸು ನೈಸೊ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ನಜಿ಼ಕ ಬಲೈನ ವರಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ಆ ಮನಕ್ಹೊನೆ ದೆಕಿನ ಮರಗಾ ಐಸ. ಯುನೆ ಮಕನ ಐನ ತನ ದಿನ್ನ ಥಯಾಸ. ಇವ್ನೊನೆ ಖಾವಾನೆ ಸುಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ಇವ್ನೊನೆ ಭುಕ್ಕಕಾವೊನೆಜ಼ ಘರೆ ಮೊಕ್ಕಲಿಪಾಡ್ಯಾಮ ವಾಟಮಾ ಚಕ್ಕರ ಐನ ಪಡಿಜಾ಼ವಸ ಇವ್ನೊಮಾ ದಕ್ಹಾಜ಼಼ನಾ ದುರತಾ ಆಯಾಸತೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ತಿನಾ ಶಿಷ್ಯಾ ಕದ್ಯಾ ಕುನ್ನಜ಼ ನೈಸೊ ಜ಼ಗಾಮಾ ರೊಕ್ಲಾ ಕಿಜ಼್ಗಾಂತಾ ಲೈನ ಯುನು ಪೆಟ ಭರಾಯ್ಯೆ? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ಯೆಸು ತ್ಯುನೊನೆ ಪುಚ್ಯೊ ತುಮೊಕನ ಕೆಕ್ಲಾ ರೊಕ್ಲಾ ಛೆ ಕೈನ ತ್ಯುನೊನೆ ಪುಚ಼ಲಕ್ಹು ತಿವ್ನಾ ಕ್ಹಾತ ಛೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ತೆಳಾಮಾ ಯೆಸು ತೆ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಜಿಮಿನ್ಪರ ಬೈಟೊ ಕೈನ ಅಪ್ಪಣೆ ದಿನ್ನ ತೆ ಕ್ಹಾತ ರೊಕ್ಲಾ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ರೊಕ್ಲಾ ಭಾಗಿನ ತಿನಾ ಶಿಷ್ಯಾಯೊನಾ ಹತ್ಮಾ ವಾಟಾಹುತಿ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ತ್ಯುನೆ ತೆ ಗುಂಪಮಾ ರ‍್ಹಯಲವಾಲಾವೊನಾ ವಾಟಿನ ದಿದ್ಯಾ. ಎನೈಸೊ ತಿವ್ನೊಮಾ ದಕ್ಹಿಯೊ ನ್ಹಾನಿಯೊ ಮಚ್ಲಿ಼ಯೊ ವ್ಹತ್ತಿಯೊ ಯೆಸು ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ತ್ಯುನೊನೆ ವಾಟಾನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ತ್ಯುನೆ ಪೆಟ ಭರೆಲಕ್ಕಾ ಖೈನ ಉಗ್ರಲ ತುಕಡಾ ರೊಕ್ಲಾ ಮಳಾತಾಮಾ ಕ್ಹಾತ ಟೊಪ್ಲಿಯೊ ಥಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ಖಾದಲವಾಲಾ ಕಮ ಜಾಸ್ತ ಚಾರ ಹಜಾ಼ರ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ ಪಾಚಲ್ತೊ ಮನಕ್ಹೊನೆ ಮೊಕ್ಕಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ಯೆಸು ತ್ಯುನೊನೆ ಮೊಕ್ಕಲಿಪಾಡಲ್ಪರ ತೆಳಾಮಾಜ಼ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಲಿನ ಹಡ್ಗೊ ಚ಼ಡಿನ. ದಲ್ಮುಥ ಗಾಮೆ ಗಯಾ.. ");
INSERT INTO sle_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ತೆಳಾಮಾ ಫರಿಸಾಯರೊ ಐನ ಯೆಸುನಾ ಕ್ಹಾತೆ ತಕ್ಕರಾರ ಕರತಾ. ತಿನೆ ಪರಿಕ್ಷಾ ಲಿವಾನಾಹುತಿ ವರಿ ಕ್ಹಾಪಡಾವಾಹುತಿ - ತು ಕ್ಹುದಾಕಂತೊ ಆಯಲ ರ‍್ಹಯೊಮ ಹಬಾಳಮಾ ಯಕ್ಕ ಅಗ್ದಿ ಮ್ಹೊಟು ಕಾಮ ಕರಿನ ದೆಕಾಡ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ತಿಕನ ಪುಚ್ತಾಮಾ ಯೆಸು ತಿನಿ ಆತ್ಮಾಮಾ ದುಕ ಕರಲಿನ ಉಸುಲ ಛೊಡ್ಯೊ ಎ ಮನಕ್ಹೊ ಅಗ್ದಿ ಮ್ಹೊಟು ಕಾಮ ಕಾ ಹುಡುಕಾನು ಕಾ? ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ, ಮನಕ್ಹೊನೆ ಅಗ್ದಿ ಮ್ಹೊಟು ಕಾಮ ಕರಿನ ಸಾಕ್ಷಿ ನೈ ದೆಕಾಡತೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ಕೈನ ತೆ ತ್ಯುವ್ನೊನೆ ಛೊಡಿನ ಹಡಾಗಾಮಾ ಚ಼ಡಿನ ಬಿಜಿ಼ ದಂಡಿಯೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ಶಿಷ್ಯಾ ಹಡಗಾಮಾ ಜಾ಼ತಾಮಾ ರೊಕ್ಲಾವೊನಿ ಭುತಿ ಭಾಂದಿಲಿವಾನು ಇಕ್ಹರ‍್ಯಾತಾ ಹಡಗಾಮಾ ತ್ಯುನೊನೆ ಯಕಜ಼ ರೊಕ್ಲೊ ವ್ಹತ್ತೊ ಬಿಜು಼ ಸುಜ಼ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ಯೆಸು ತ್ಯುನೊನೆ. ಫರಿಸಾಯರೊ ವರಿ ಹೆರೊದನಾ ಖಾಟೊ ಲೊಟನಾ ವಾಸ್ತರ ಹುಶಾರ. ದೆಕಿ ಲಿವೊ ಕೈನ ಖರಿಮಾಜ಼಼ ತ್ಯುನೊನೆ ಕತಾಮಾ ತ್ಯುನೆ ");
INSERT INTO sle_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ಅಪ್ನೊಕನ ರೊಕ್ಲಾ ನತ್ತಿ ಕೈನ ತೆ ಇಮ್ಮ ಬೊಲ್ಯೊ ಕೈನ ಶಿಷ್ಯಾ ತಿವ್ನೊಮಾಜ಼ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ಯೆಸು ತೆ ತಿಳದಿಲಿನ ರೊಕ್ಲಾ ನತ್ತಿ ಕೈನ ಬೊಲ್ಲಿವಾನು ಕಾ? ತುಮೆ ಹಜು಼ನ ತಿಳದಿಲಿದ್ಯಾನತ್ತಿಸು? ತಿಳವಳಕಿ ನತ್ತಿ ಐ ಸು? ತುಮಾರಾ ಮನಸ್ಮಾ ತಿಳದ್ಯಾ ನತ್ತಿಸು? ");
INSERT INTO sle_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ಡೊಳಾ ರೈನ ಬಿ ದಿಕ್ಹ್ತು ನೈಸು? ಕಾನೊ ರೈನ ಬಿ ಐಕ್ತಾ ನೈಸು? ತುಮೊನೆ ಶೆ ನತ್ತಿಸು? ");
INSERT INTO sle_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ಮಿ ಪಾಂಚ಼ ರೊಕ್ಲಾ ಭಾಗಿನ ಪಾಂಚ಼ ಹಜಾ಼ರ ಮನಕ್ಹೊನೆ ವಾಟಾನೆ ದಿದಲಮಾ ಉಗ್ರಲ ತುಕಡಾ ಕೆಕ್ಲಾ ಭರ‍್ಯಾ ಕೈನ ಪುಚ಼ತಾಮಾ ತ್ಯುನೆ ಬಾರಾ ಟೊಪ್ಲಿಯೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ವರಿ ಕ್ಹಾತ ರೊಕ್ಲಾ ಚಾರ ಹಜಾ಼ರ ಮನಕ್ಹೊನೆ ವಾಟಲಮಾ ಉಗ್ರಲ ಕೆಕ್ಕಲೆಯೊ ಟೊಪ್ಲಿಯೊ ಭರ‍್ಯಾ ಕೈನ ಪುಚ಼ತಾಮಾ ತ್ಯುನೆ ಕ್ಹಾತ ಟೊಪ್ಲಿಯೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ- ತುಮೊನೆ ಹಜು಼ನ ತಿಳವಳಕಿ ಐ ನತ್ತಿಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ವರಿ ತ್ಯುನೆ ಬೆತ್ಸಾಯಿ ಗಾಮೆ ಆಯಾ. ತ್ಯಾ ಮನಕ್ಹೊ ಯಕ್ಕ ಕುಡ್ಡಾನೆ ಯೆಸುಕನ ಬಲೈ ಲೈನ ಅನೆ ಮುಟ್ಟ ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ಯೆಸು ತೆ ಕುಡ್ಡಾನೊ ಹತ್ತ ಧರಿನ ಗಾಮ್ನಾ ಭಾರೊ ನಿಂಗೈನ ತಿನಾ ಡೊಳಾಪರ ಥುಕ್ಕಕಿನ ತಿಪರ ಹತ್ತ ಮ್ಹೆಲಿನ-ತುನೆ ಸುಬಿ ದಿಕ್ಹಾಡ್ಯುಸು? ಕೈನ ತಿನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ತೆ ಮಾತು ಉಚೈನ ದೆಕಿನ ಮನೆ ಮನಕ್ಹೊ ದಿಕ್ಹಾಡ್ಯಾಸ; ತ್ಯುನೆ ಝಾಡೊ ಲಿಂಗತ ದಿಕ್ಹ್ಯಾತಬಿ ಫರವಾಡ್ಯಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ತೆಳಾಮಾ ಯೆಸು ತಿನಾ ಡೊಳಾಪರ ಫರಿನ ಹತ್ತ ಮ್ಹೆಲ್ತಾಮಾ ;ತೆ ಡೊಳಾ ಖೊಲಿನ ದೆಕ್ತಾಮಾ ತೆ ಅರಾಮ ಥಯೊತೊ. ಕ್ಹಾರು ಚೊ಼ಕಿ ತರಾ ದಿಕ್ಹಾಡ್ಯುತು ");
INSERT INTO sle_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ತೆಳಾಮ ಯೆಸು ತಿನೆ ತು ಎ ಗಾಮ್ನಾ ಮ್ಹೈ ಜಾ಼ವುನಕೊ ಕೈನ ತೆ ತಿನಾ ಘರೆ ಮೊಕ್ಕಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಫಿಲಿಪ್ಪನ ಕೈಸರೆಯ ಕವಾನಾ ಗಾಮೆ ಮಳಲ ಗಾಮೊಯೆ ಚಾ಼ಲ್ಯಾತಾ ವಾಟಮಾ ಯೆಸು -ಮನಕ್ಹೊ ಮನೆ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಕವಸ. ಕೈನ ಶಿಷ್ಯಾವೊನೆ ಪುಚ಼ತಾಮಾ. ತ್ಯುನೆ ");
INSERT INTO sle_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ತುನೆ ದಕ್ಹಾಜ಼಼ನಾ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನ ವ್ಹೈ ಕವಸ ; ದಕ್ಹಾಜ಼಼ನಾ ಎಲಿಯಾ ಕವಸ;ಹಜು಼ನ ದಕ್ಹಾಜ಼಼ನಾ ಪ್ರವಾದಿಮಾನೊ ಯಕ್ಲೊ ವ್ಹೈ ಕವಸ; ");
INSERT INTO sle_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ಯೆಸು ತ್ಯುನೊನೆ ವರಿ ತುಮೆ ಮನೆ ಕುನ್ನ ವ್ಹೈ ಕವೊಸಿ? ಕೈನ ಪುಚ಼ತಾಮಾ ತಿಮಾನೊ ಪೆತ್ರಾ ತು ಕ್ರಿಸ್ತ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ತೆ ವಾತೆ ಯೆಸು ಮಾರಾ ಹುತಿ ಕಿನೆಜ಼಼ ಕೌ ನಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ಎನೈಸೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಘನ್ನು ಕಷ್ಟ ಖೈನ ಮ್ಹೊಟಾ ಮನಕ್ಹೊನಾ ಹತೆ ಖಾಸ ಯಾಜಕನಾ ಹತೆ ಶಾಸ್ತ್ರಿಯೊನಾಹತೆ ಇನ್ಕಾರಿನ ಮಾರಾ ಲಗಾಡಿಪಾಡಸ. ಮರಿನ ತನ ದಿನ್ಪರ‍ ವಾಚಿ಼ನ ಆವಾನು ಛೆ ಕೈನ ಉಪದೆಶ ಕವಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ತೆ ತೆಳಾಮಾ ಯೆಸು ಎ ವಾತೊ ಝಾಕಿನ ಮ್ಹೆಲ್ಯಾ ವಾಚಿ಼ ಕದ್ಯೊ. ತೆಳಾಮಾ ಪೆತ್ರಾ ತಿನೊ ಹತ್ ಧರಿನ ತಿನೆ ಗದರಸಾನೆ ಚ಼ಾಲು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ತೆಳಾಮಾ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ ಪಾಚೊ಼ ಫರಿನ ದೆಕಿನ ಪೆತ್ರಾನೆ ಸೈತಾನ. ಮಾರಾ ಕ್ಹಾಮೊ ಹುಬ್ರೌ ನಕೊ. ಜಾ಼. ತಾರಿ ವಿಚಾರ ವ್ಹೈ ಕ್ಹುದಾಕಂತು ಆಯಲ ವಿಚಾರ ನ್ಹವೈ ಕೈನ ಗದರಶೊ. ");
INSERT INTO sle_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ತೆ ಥಯಲ್ಪರ ತಿನಾ ಶಿಷ್ಯಾವೊನಾವರಿ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಬಲೈನ ತ್ಯುನೊನೆ ಸುಕದ್ಯೊ ಕದ್ಯಾಮ ಕಿನೆಬಿ ರ‍್ಹವಾದೆ ಮಾರಾ ಪಾಚಾ಼ ಆವಾನು ಮನಸ ರ‍್ಹಯುಮ ತಿನೆ ತೆ ಇಕ್ಹರಿನ ತಿನಿ ಶಿಲುವಿ ಉಚೈಲಿನ ಮಾರಾ ಪಾಚೊ಼ ಆವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ಕಯೊಬಿ ತಿನೊ ಜ಼ಲಮ ತೆ ವಚಾ಼ಡಿಲಿವಾನೆ ಕರತೊ ರ‍್ಹಯೊಮ. ತಿನೊ ಜ಼ಲಮ ತೆ ಜ಼ವೈ ಲಿವಸ. ನೈತೊ ತಿನೊ ಜ಼ಲಮ ಮಾರಾಹುತಿ ಸುವಾರ್ತೆನಾ ಹುತಿ ಜ಼ವಾಲಿದ್ಯೊಮ ತಿನೊ ಜ಼ಲಮ ತೆ ವಚಾ಼ಡಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ಯಕ್ಕ ಮನಕ್ಹ ದುನಿಯಾಮಾ ಸುಬಿ ಗಳಶ್ಯೊಮ ತಿನೊ ಜ಼ಲಮ ಗೈ ಪಾಡ್ಯೊಮ ತಿನೆ ಸು ಫೈದೊ ಕದ್ಯಾಮ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ರ‍್ಹವಾನೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿದ್ಯೊಮ ತಿನೆ ಸು ಫೈದೊ ವ್ಹೈ? ಸುಜ಼ ನ್ಹವೈ ");
INSERT INTO sle_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ಯಕ್ಲೊ ತಿನಾ ಜ಼ಲಮನೆ ಸು ಮುಕ್ಕಿಲಿವಾನು ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ಕ್ಹುದಾನೊ ಭೆ ನೈಸೊವಾಲಾ ಎ ಪಾಪಿ ದಿನೊಮಾ ಮಾರಾ ಹುತಿ ಮಾರಿಯೊ ವಾತೊಕ್ಹು ಕುನ್ನ ಸರಮಸ ತಿನೆ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತೆ ತಿನಾ ಬಾಪ್ನಿ ಮಹಿಮಾನಾ ಕ್ಹಾತೆ ಪರಿಶುದ್ಧ ದುತೊನಾ ಕ್ಹಾತೆ ಆತಾಮಾ ತಿನಾ ಹುತಿ. ತೆ ಸರಮಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ವರಿ ಕತೊ ರ‍್ಹತಾಮಾ ಅಮ್ಮ ಕದ್ಯೊ ತುಮೊನೆ ಕ್ಹರಿ ಕೌಸ. ನ್ಹ್ಯಾ ರ‍್ಹಯಲ ವಾಲಾಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ ಕ್ಹುದಾನಿ ತಾಕತನಿ ಅದಿಕಾರಕ್ಹು ರಾಜ್ಯ ಆವಾನು ದೆಕೆಲಕ್ಕಕಾ ತ್ಯುನೆ ಮರತಾನೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ವರಿ. ಛೆ. ದಿನ್ನ ಥಯಲ್ಪರ ಯೆಸು ಪೆತ್ರಾ ಯಾಕೊಬ ಯೊಹಾನ ತ್ಯುನೊನೆಜ಼ ಜು಼ದೊ ಬಲೈ ಲಿಂಗೈನ ಉಚ್ಚಾರ‍್ಹಯಲ ಡೊಂಗರಪರ ಗಯಾ ತೆಳಾಮಾ ತ್ಯುನಾ ಡೊಳಾಕ್ಹಾಮೊ ಯೆಸುನೊ ರುಪ ಬಿಜೊ಼ಥಯೊ ");
INSERT INTO sle_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ತಿನಾ ಧೊಳಾ ವಣ್ಣಾ ಘನ್ನಾ ಮಿಂಚಾ಼ಡ್ಯಾತಾ ಜಿಮಿನ್ಪರ ರ‍್ಹಯಲವಾಲಾ ಕುನ್ನಜ಼ ಯಕ್ಲು ಹಸಾ ಧೊತಾ ನೈ ತೆಕ್ಲಾ ಧೊಳಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ತೆಳಾಮಾ ಎಲಿಯಾ, ಮೊಶೆ, ಯೆಸುನಾ, ಕ್ಹಾತೆ ಬೊಲಾನು ತನ್ನೆ ಶಿಷ್ಯಾ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ತೆಳಾಮಾ ಪೆತ್ರಾ ಯೆಸುನೆ-ಗುರು ಅಪೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹವಾನು ಚೊ಼ಕು ವ್ಹೈ ತನ ಝುಪ್ಡಾ ಭಾಂದಿಯೆ. ತುನೆ ಯಕ್ಕ ಮೊಶೆನೆ ಯಕ್ಕ ಎಲಿಯಾನೆ ಯಕ್ಕ ಇಮ್ಮ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ಸು ಕವೊ ಕೈನ ತಿಳದ್ಯಾವಾಚಿ ಇಮ್ಮ ಬೊಲ್ಯೊ. ತ್ಯುನೆ ಘನ್ನಾ ಭುಚ್ಕಿ಼ ಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ತೆಕ್ಲಾಮಾಜ಼಼ ಮ್ಹಾಡ ತ್ಯುನಾ ಉಪ್ಪರ ಐನ ಹುಬ್ರಯು. ತೆ ಮ್ಹಾಡಮಾತು ಎ ಮಾರೊ ಮಯಾನೊ ಥಯಲ ದಿಕ್ರೊ ವ್ಹೈ ಇನಿ ವಾತ ಐಕೊ ಕೈನ ಹಬಾಳಮಾತೊ ಬೊಲಲ ಅವಾಜ಼ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ತೆಳಾಮಾಜ಼ ತ್ಯುನೆ ಸುತ್ತೆ ದೆಕ್ತಾಮಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ಯೆಸುನೆ ಛೊಡಿನ ಬಿಜು಼ ಕುನ್ನಜ಼ ದಿಕ್ಹ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ತ್ಯುನೆ ತೆ ಡೊಂಗರಪರತಾ. ಉತ್ರಿನ ಆತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ - ತುಮೆ ಎ ದೆಕಲ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಮರಿನ ಜುತೊ ಥೈನ ಉಟಿನ ಆಯೆಲಕ್ಕಾ ಕಿನೆಜ಼಼ ಕವೊನಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ತ್ಯುನೆ ತಿನಿ ವಾತ ಐಕ್ಯಾ. ತೆ ವಾತ ಧರಿನ ಮರಿನ ಜುತೊ ಥಾವಸ ಕದ್ಯಾಮ ಸುವೈ? ಕೈನ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ಎನೈಸೊ ತ್ಯುನೆ ಎಲಿಯಾ ಪೈಲಾ ಆವಾನು ಛೆ ಕೈನ ಶಾಸ್ತ್ರಿಯೊ ಕವಸ್ತೊ. ಎ ಕಿಮ? ಕೈನ ಯೆಸುನೆ ಪುಚ಼ತಾಮಾ ಯೆಸು. ");
INSERT INTO sle_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ತೆ ಕದ್ಯೊ ಎಲಿಯಾ ಪೈಲಾ ಐನ ತಯ್ಯಾರ ಕರಸ ಕ್ಹರಿ ವ್ಹೈ ವರಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ಹುತಿ ತೆ ಘನ್ನೊ ಕಷ್ಟ ಖೈನ ಇನ್ಕಾರ ಥಾವಸ ಕೈನ. ಬರ್ದಲ ಛೆ ಎ ಕಿಮ? ");
INSERT INTO sle_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯಾಮ-ಎಲಿಯಾ ಆಯೊ ವರಿ ತಿನಿ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಪೈಲಾಜ಼ ಬರ್ದಲ ಛೆ. ತಿಮ್ಮಜ ಮನಕ್ಹೊ ತ್ಯುನಾ ಮನಸ್ಮಾ ಕೆಟ ಆಯಲ ತಿಮ್ಮಜ಼ ತ್ಯುನೆ ಕರಿಪಾಡ್ಯಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ಎ ಥಯಲ್ಪರ ತ್ಯುನೆ ತಿನಾ ಉಗ್ರಲ ಶಿಷ್ಯಾವೊಕನ ಐನ ತಿವ್ನಾ ಸುತ್ತೆ ರ‍್ಹಯಲ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತಿವ್ನಾ ಕ್ಹಾತೆ ಶಾಸ್ತ್ರಿಯೊ ತಕ್ಕರಾರ ಕರಾನು ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ತೆಳಾಮಾಜ಼ ಗುಂಪಮಾ ರ‍್ಹಯಲವಾಲಾ ಯೆಸುನೆ ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾಥೈನ ತಿಕನ ನ್ಹಾಟಿನ ಐನ ತಿನೆ ಹತ್ ಜೊ಼ಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ಯೆಸು ಶಿಷ್ಯಾವೊನೆ ಪುಚ್ಯೊ? ಇವ್ನಾ ಕ್ಹಾತೆ ಸು ತಕ್ಕರಾರ ಕರಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ಕೈನ ಪುಚ಼ಲ ಹುತಿ ತೆ ಗುಂಪಮಾನೊ ಯಕ್ಲೊ ಎ ಗುರು ಮಾರಾ ದಿಕ್ರಾನೆ ತುಕನ ಬಲೈ ಲಾಯೊಸ ಕಾಕದ್ಯಾಮ ಇನಾಮಾ ಭುತ್ಡು ಛೆ; ಎ ಬೊಲ್ತೊ ನೈ ");
INSERT INTO sle_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ತೆ ಕಿಜ್ಗಾ಼ಬಿ ತಿಪರ ಐನ ತಿನೆ ಪಾಡಿಪಾಡಸ; ತೆಳಾಮಾ ತಿನಾ ಮ್ಹೊಡಾಮಾತು ಬುರುಕ ಚು಼ವಾವಸ. ವರಿ ಕಟ-ಕಟ ದಾತೊ ಖಾತೊ ಶಡ್ದೈ ಜಾ಼ವಸ ತೆ ಛೊಡಾಕೈನ ತಾರಾ ಶಿಷ್ಯಾವೊಕನ ಕೈಲಿದ್ಯೊ. ತಿವ್ನಾ ಹತೆ ಥಯ್ಯೊನೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ತಿನಾಹುತಿ ಯೆಸು ತಿನಾಶಿಷ್ಯಾವೊನೆ -ಎ ಬರೊಕ್ಹೊ ನೈಸೊವಾಲಾವೊ? ಮಿ ಹಜು಼ನ ಕೆಕ್ಲಾ ದಿನ್ನ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌ? ಹಜು಼ನ ಕೆಕ್ಲಾ ದಿನ್ನ ತುಮೊನೆ ತಡ್ದಿಲಿವ? ತೆ ಪಟ್ಟಾನೆ ಲಿನ ಮಕನ ಆವೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ಕತಾಮಾ ತೆ ಪಟ್ಟಾನೆ ಲಿನ ಯೆಸುಕನ ಆಯಾ ತಿನೆ ದೆಕಲ ಬರೊಬ್ಬರ ತೆ ಪಟ್ಟಾನೆ ಭುತ್ಡು ಘನ್ನು ವದ್ಯಾಡಸಿನ ತೆ ಜಿಮಿನ್ಪರ ಪಡಿನ ಮ್ಹೊಡಾಮಾನು ಬುರುಕ ಚು಼ವಾತೊ ಉಳ್ಯಾಡಶು. ");
INSERT INTO sle_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ಯೆಸು ತಿನಾ ಬಾನೆ ಇನೆ ಇಮ್ಮ ಥೈನ ಕೆಕ್ಲಾ ದಿನ್ನ ಥಯಾ. ಕೈನ ಪುಚ್ತಾ಼ಮಾ ಇನೆ ನ್ಹಾನೊ ರ‍್ಹತಮಾ ಇಮ್ಮ ಥಯುಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ವರಿ ಇನೆ ತೆ ಕೆಟ ಆತ್ಮಾ ಮಾರಿಪಾಡು ಕೈನ ಆಗಮಾ ಪಾನಿಮಾ ಪಾಡಿಪಾಡ್ಯುಸ. ತಾರಾ ಹತೆ ಥಾವಾನುರ‍್ಹಯುಮ ಮನೆ ಮರಗಿನ ಹಮ್ನೊನೆ ಸಹಾಯಾ ಕರಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ಯೆಸು ಎ ಸಾದ್ಯ ಛೆ ತಿನೆ ತಾರಾ ಹತೆ ಸುಬಿ ಥಾವಾನು ರ‍್ಹಯುಮ ಕಸಿಸು? ನಂಬಾಲಾವೊನೆ ಕ್ಹಾರುಜ಼ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ತೆಳಾಮಾಜ಼ ತೆ ಪಟ್ಟಾನೊ ಬಾ ಮಿ ಬರೊಕ್ಹೊ ಕರುಸ ಬರೊಕ್ಹೊ ಕಮ ಥಯೊತಬಿ ಸಹಾಯಾ ಕರ ದುಖಿ ಥೈನ ವದ್ರಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ತೆಳಾಮಾ ಯೆಸು ಮನಕ್ಹೊನು ಗುಂಪನೆ ನ್ಹಾಟಿನ ಆವಾನು ದೆಕಿನ ತೆ ಭುತ್ಡಾನೆ ಭುಚ್ಕಾ಼ಡಿನ ಎ ಕಿವುಡು ವರಿ ಮುಕಾ ಭುತ್ಡಾ ಪಟ್ಟಾನೆ ಛೊಡಿನ ಜಾ಼; ಇತ್ತಿ ಉಪ್ಪರ ಧರು ನಕೊ ಕೈನ ಮಿ ತುನೆ ಅಪ್ಪಣೆ ದ್ಯುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ತೆಳಾಮಾ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಪಟ್ಟಾನೆ ಘಾಬ್ರುಕರಿನ ವದ್ಯಾಡಸಿನ ಛೊಡಿನ ಗಯು. ತೆ ಪಟ್ಟೊ ಮರಲಲಿಂಗತ ಪಡಲ ದೆಕಿನ ಮನಕ್ಹೊ-ಮರಿಗಯೊಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ಯೆಸು ತೆ ಪಟ್ಟಾನೆ ಹತ್ ಧರಿನ ಉಟಾಡತಾಮಾ ತೆಳಾಮಾಜ಼ ಉಟಿನ ಹುಬ್ರಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ಯೆಸು ಘರೆ ಆತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ-ತೆ ಕೆಟ ಆತ್ಮಾನೆ ಛೊಡಾವಾನೆ ಹಮೊನೆ ಕಾ ಥಯ್ಯುನೈ ಕೈನ ಯಕ್ಲೊ ರ‍್ಹತಾಮಾ ಪುಚ಼ತಾಮಾ ಯೆಸು ");
INSERT INTO sle_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ಎ ಜಾ಼ತ ಪ್ರಾಥನಾ ನೈಸೊ ವರಿ ಶಾಕ್ಹುಜ಼ ಜಾ಼ತಾನೈ ಕೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ತ್ಯಾಂತಾ ಜಾ಼ತಾ ಗಲಿಲಾಯ ಗಾಮಪರತಾ. ಚಾ಼ಲ್ಯಾತಾ ತೆ ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ಥಾವುನೈ ಕೈನ ತಿನೆ ಮನಸ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ಕಾಕದ್ಯಾಮ ತೆ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಉಪದೆಶ ಕರತೊ-ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಮನಕ್ಹೊನಾ ಹತ್ಮಾ ದಿಪಾಡಸ. ತ್ಯುನೆ ತಿನೆ ಖಲಾಸ ಕರಿಪಾಡಸ ವರಿಬಿ. ಖಲಾಸ ಕರಲ ತನ ದಿನ್ಪರ‍ ವರಿ ತೆ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆವಸ ಕೈನ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ವರಿ ತೆ ವಾತೊ ತ್ಯುನೊನೆ ತಿಳದ್ಯಾನೈ ಮತ್ಲಬ ತಿಳದ್ಯು ನೈ ವರಿ ತ್ಯುನೆ ತಿನೆ ತೆ ವಾತನೊ ಮತ್ಲಬ ಪುಚ್ಚಾ಼ನೆ ಭುಚ಼್ಕ್ಕಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ವರಿ ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಕಪೆನೌರ್ಮಿಯೆ ಆಯಾ. ತೆ ತ್ಯಾ ತ್ಯುನೆ ಘರಮಾ ರ‍್ಹತಾಮಾ-ತುಮೆ ವಾಟಮಾ ರ‍್ಹತಾಮಾ ಸು ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ ಕೈನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಪುಚ಼ತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ತ್ಯುನೆ ಗಪ್ಪಜ಼ ವ್ಹತ್ತಾ ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ವಾಟಮಾ ತ್ಯುನೊಮಾಜ಼ ಕುನ್ನ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ತೆ ಬೈಟಿನ ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನ ತ್ಯುನೊನೆ ತುಮೊಮಾ ಕುನ್ನ ಅಗೊ ಥಾವಾನ ಕರಸ ತೆ ಕ್ಹಾರಾವೊತಿ ಪಾಚೊ಼ ರ‍್ಹವಾದೆ ತೆ ಕ್ಹಾರಾವೊನೊ ಆಳ ಥೌ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ಯಕ್ಕ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ನೆ ಲಿನ ತ್ಯುನಾ ವಚ಼ಮಾ ಹುಬ್ರಾಡಿನ ತಿನೆ ಗಳೆ ಮಳೈಲಿನ. ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ");
INSERT INTO sle_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ಕುನ್ನಬಿ ಮಾರಾ ನಾಮಪರ ಹವಾ ಬಚ್ಚಾವೊಮಾನಾ ಯಕ್ಲಾನೆಬಿ ಮಳೈ ಲಿದ್ಯಾಮ ತ್ಯುನೆ ಮನೆ ಮಳೈ ಲಿದಲ ಲಿಂಗತ ವ್ಹೈ ; ವರಿ ಕುನ್ನಬಿ ಮನೆ ಮಳೈ ಲಿದ್ಯಾಮ ಮನೆ ನ್ಹವೈ. ಮನೆ ಮೊಕ್ಕಲಲ ವಾಲಾನೆ ಮಳೈ ಲಿದಲ ಲಿಂಗತ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ಯೊಹಾನ ಯೆಸುನೆ ಭೊದಕ ಕುನ್ನಬಿ ಯಕ್ಲೊ ತಾರಾ ನಾಮಪರ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾವಾನು ಹಮೆ ದೆಕಿನ ತೆ ಹಮೊಮಾನೊ ನೈ ರ‍್ಹಯಲ ಕ್ಹು ತಿನೆ ಹಮೆ ಅಡ್ಡಿ ಕರ‍್ಯಾಸ ಕೈನ ಕದ್ಯೊ. ಕತಾಮಾ ಯೆಸು ");
INSERT INTO sle_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ತಿನೆ ಅಡ್ಡಿಕರೊನಕೊ; ಮಾರಾ ನಾಮಪರ ಅದ್ಭುತ ಕರಿನ ಯಕದುಮ ಮಾರಾಹುತಿ ಕೆಟ ಬೊಲ್ತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ಅಪೊನೆ ವಿರೊಧ ನೈಸೊ ವಾಲೊ ತೆ ಅಪ್ನೊಜ಼ ವ್ಹೈ, ");
INSERT INTO sle_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ತುಮೆ ಕ್ರಿಸ್ತನಾ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿನ ತುಮೊನೆ ಕುನ್ನಬಿ ಯಕ್ಕ ತಾಂಬಿಯೊ ಪಾನಿ ಪಿವಾನೆ ದಿದ್ಯೊಮ ತಿನೆ ಆವಾನೊ ಪ್ರತಿಫಲ ತಿನೆ ಕ್ಹರಿಮಾಜ಼ ತಪ್ತೊನೈ. ಕೈನ ತುಮೊನೆ ಖರಿಮಾಜ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ಮನೆ ನಂಬಲವಾಲಾವೊಮಾನೊ ಎ ನ್ಹಾನಾವೊಮಾನೊ ಯಕ್ಲಾನೆಬಿ ಮಪರಲ್ಯೊ ಬರೊಕ್ಹೊ ನೈಸೊ ಕರ‍್ಯೊಮ ತೆವಾನೆ ಗಳಾಮಾ ಮ್ಹೊಟೊ ದಗ್ಡೊ ಭಾಂದಿನ ಸಮುಂದರಮಾ ನಾಕಾನು‍ ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ಎನೈಸೊ ತಾರೊ ಹತ್ತ ತಾರೊ ಬರೊಕ್ಹೊ ನೈಸೊ ಕರಾನೊ ರಹ್ಯೊಮ ತೆ ಹತ್ ಕತ್ರಿನ ನಾಕಿಪಾಡ ಬೆ ಹತೊ ರ‍್ಹೈನ ನರಕನಿ ನೈ ಇಜ್ಜಾ಼ವಾನಿ ಆಗಮಾ ಜಾ಼ವಾತಿಬಿ ಯಕ್ಕ ಹತ್ತ ನೈಸೊ ಕ್ಹುದಾಕನ ರ‍್ಹವಾನೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಾನೊ ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ದಕ್ಹಾ ಗ್ರಿಕ ಪುಸ್ತಕೊಮಾ 44 ನಿ ವಚನಾ ಛೆ, ತೆ 48 ನಿ ವಚನ ನಿಂಗತಜ಼ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ವರಿ ತಾರೊ ಪಗ ತಾರೊ ಬರೊಕ್ಹೊ ನೈಸೊ ಕರಾನೆ ರ‍್ಹಯೊಮ ತಿನೆ ಕತ್ರಿಪಾಡ ತೆ ಪಗ ಕತ್ರಿನ ನಾಕಿಪಾಡ ಬೆ ಪಗೊ ರ‍್ಹೈನ ನರಕನಿ ನೈ ಇಜ್ಜಾ಼ವಾನಿ ಆಗಮಾ ಜಾ಼ವಾತಿಬಿ ಯಕ್ಕ ಪಗ ನೈಸೊ ಕ್ಹುದಾಕನ ರ‍್ಹವಾನೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಾನೊ ಚೊ಼ಕು ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ದಕ್ಹಾ ಗ್ರಿಕ ಪುಸ್ತಕೊಮಾ 46 ನಿ ವಚನಾ ಛೆ, ತೆ 48 ನಿ ವಚನ ನಿಂಗತಜ಼ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ತಾರೊ ಡೊಳೊ ತಾರೊ ಬರೊಕ್ಹೊ ನೈಸೊ ಕರಾನೆ ರ‍್ಹಯೊಮ ತಿನೆ ಕಿತ್ತಿನ ನಾಕಿಪಾಡ ಬೆ ಡೊಳಾ ರ‍್ಹೈನ ನರಕಮಾ ಘಲಾಯಿಲಿವಾತಿಬಿ ಯಕ್ಕ ಡೊಳಾಕ್ಹು ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ರ‍್ಹವಾನು ತುನೆ ಕೆಕ್ಲು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ನರಕಮಾ ತ್ಯುನೊನೆ ಕಡ್ಡಾನಾ ಕಿಡಾ ಮರತಾನೈ. ತ್ಯುನೊನೆ ಬಾಳಾನಿ ಆಗ ಇಜ್ಜಾ಼ತಿ ನೈ ");
INSERT INTO sle_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ಬಲಿನೆ ಮಿಟ್ಟು ಶುದ್ಧ ಕರಸ ತಿಮ್ಮಜ಼ ಹರಿ ಯಕ್ಲಾನೆ ಆಗಕ್ಹು ಶುದ್ಧ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ಮಿಟ್ಟು ಚೊ಼ಕು ವ್ಹೈ; ಮಿಟ್ಟಾನಿಜ಼ ಸವಾದ ಗೈ ಪಡ್ಯುಮ ತಿನೆ ಶಾಕ್ಹು ಮಿಟ್ಟು ಕರೊಶಿ? ತುಮೊಮಾ ಮಿಟ್ಟಾ ನಿOಗತ ದೊಸ್ತಿ ರ‍್ಹವಾದೆ. ಯಕ್ಕಲಾಪರ ಯಕ್ಲೊ ಸಮಾಧಾನೆ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ಯೆಸು ತ್ಯಾಂತೊ ಉಟಿನ ಯೊರ್ದನ ನದಿನಾ ಬಿಜಿ಼ ದಂಡಿಯೆ ರ‍್ಹಯಲ ಯೊದಾಯಾ ಪ್ರಾಂತ್ಯ ಗಯೊ. ತ್ಯಾ ಮನಕ್ಹೊ ಫರಿನ ಗುಂಪ-ಗುಂಪ ಥೈನ ತಿಕನ ಆತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಪದ್ದತ ಲಿಂಗತ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ತೆಳಾಮಾ ಫರಿಸಾಯರೊ ಕುಡಿನ ಐನ ಯೆಸುನೆ ಪರಿಕ್ಷಾ ಲಿವುಕೈನ ವಿಚಾರ ಕರಿನ ಆಯಾತಾ-ಯಕ್ಲೊ ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿಪಾಡಾನು ಧರಮ ವ್ಹೈಸು ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ತೆ ವಾತೆ ಯೆಸು - ಮೊಶೆ ತುಮೊನೆ ಸು ಆಗನ್ಯೆ ದಿದ್ಯೊಸ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ತ್ಯುನೆ ತ್ಯಾಗ ಪತ್ರ ಬರ್ದಿನ ದಿನ್ನ ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿಪಾಡ ಕೈನ ಮೊಶೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ತಮಾರಿ ಮಂಡತನಾ ದೆಕಿನ ಮೊಶೆ ತೆ ಆಗನ್ಯಾ ಬರ್ದಿನ ಮ್ಹೆಲಿನ ಗಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ವರಿ ಕ್ಹುದಾ ಸೃಷ್ಟಿತೊಬಿ ಮನಕ್ಹೊನೆ ದಾಣಗೊ ಹೆಣ ಮನಕ್ಹ ಕರ‍್ಯೊಸ ಇನಾಹುತಿ ಧರಮ ಶಾಸ್ತ್ರ ಕವಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ದಾಣಗೊ ತಿನಾ ಯಾ ಬಾ ನೆ ಛೊಡಿನ ತಿನಿ ಬೈಕೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ಮಳಿನ ಯಕ್ಕ ಅಂಗ ಥಾವಸಕೈನ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ಇಮ್ಮ ರ‍್ಹಯಲ ತ್ಯುನೆ ಬೆಜ಼ನಾ ನ್ಹವೈ. ಯಕ್ಕ ಅಂಗ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ತಿನಾಹುತಿ ಕ್ಹುದಾ ಕರಲ ಜೊ಼ಡಿ ಮನಕ್ಹೊ ದುರ ಕರುಜ಼ ನೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ಘರಮಾ ತಿನಾ ಶಿಷ್ಯಾ ಯೆಸುನೆ ತಿನಾಹುತಿ ಫರಿನ ಪುಚ಼ತಾಮಾ ತೆ ತ್ಯುನೊನೆ ");
INSERT INTO sle_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿನ ಬಿಜೆಕ್ಕಲಿನೆ ಹಿವಾ ಕರಲಿವಾಲೊ. ತಿನಿ ಬೈಕೊನೆ ದ್ರೊಹಿಥೈನ ವ್ಯಭಿಚಾರಕರಾಲೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ತಿನಾನಿOಗತ ಬೈಕೊ ಮಾಟಿನೆ ಛೊಡಿನ ಬಿಜೆಕ್ಕಲಾನ ಹಿವಾ ಕರಲಿದಿಮ ತೆ ವ್ಯಭಿಚಾರ ಕರಾಲಿ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ತೆ ಥಯಲ್ಪರ ದಕ್ಹಾಜ಼಼ನಾ ತಿವ್ನಾ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಯೆಸುನಾ ಹತೆ ಮುಟ್ಟಾವು ಕೈನ ತಿಕನ ಲಾತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ತ್ಯುನೊನೆ ಭುಚ್ಕಾ಼ಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ತೆ ಯೆಸು ದೆಕಿನ ಶಿಟ್ಟಥೈನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ -ಬಚ್ಚಾವೊನೆ ಮಕನ ಆವಾನೆ ದಿವೊ ತ್ಯುನೊನೆ ಅಡ್ಡಿ ಕರೊ ನಕೊ. ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಇವ್ನಾ ವರಕ್ಹಾವೊನೆ ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ ಕುನ್ನ ಬಚ್ಚಾ಼ನಾ ಮನಸ ಲಿಂಗತ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಕುನ್ನ ವಪ್ಪಿಲೆತಾ ನೈ. ತೆ ತಿಮಾ ಮಳತೊಜ಼ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ತಿಮ್ಮ ಕೈನ ಬಚ್ಚಾವೊನೆ ಅವಳಿಲಿನ ಯಕೆಕ್ಕಲಾವೊಪರ ಹತ್ ಮ್ಹೆಲಿನ ಆಶಿರ್ವಾದ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ಯೆಸು ವಾಟ ಧರಿನ ಜಾ಼ತಾಮಾ ಯಕ್ಲೊ ನ್ಹಾಟತೊ ತಿನಾ ಕ್ಹಾಮೊ ಐನ ಉಂದಾಗುಡಗಾ ಘಾಲ್ಲಿನ ಚೊ಼ಕಾ ಭೊದಕ ಮನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಮಳು ಕದ್ಯಾಮ ಮಿ ಸುಕರು ಕೈನ ಯೆಸುನೆ ಪುಚ಼ತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ಯೆಸು ತಿನೆ ಮಿ ಚೊ಼ಕೊ ವ್ಹೈ ಕೈನ ಕಾ ಕವಾಡ್ಯೊಸ? ಕ್ಹುದಾನೆ ಛೊಡಿನ ಬಿಜು಼ ಕುನ್ನಜ಼ ಚೊ಼ಕು ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ತುನೆ ಆ ಗೊತ್ತ ಛೆ ಸು ನರಹತ್ಯಾ ಕರುನೈ; ವ್ಯಭಿಚಾರ ಕರುನೈ ;ಚೊ಼ರಿಕರು ನೈ; ಸುಳ್ಳ ಸಾಕ್ಷಿ ಕವೊನೈ; ಮೊಸ ಕರುನೈ ತಾರಾ ಯಾ ಬಾನೆ ಮರ್ಯಾದಿ ದ್ಯು. ಕವಾನಿಯೊ ಕ್ಹುದಾನಿಯೊ ಆಗನ್ಯಾ ತುನೆ ಗೊತ್ತ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ತೆ ಯೆಸುನೆ -ಭೊದಕ ಮಿ ನ್ಹಾನೊ ರ‍್ಹತಾಮಾತೊ ಬಿ ಎ ಕ್ಹಾರು ಚೊ಼ಕಿತರಾ ಕರತೊ ಆಯೊಸ. ಕೈನ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ಯೆಸು ತಿನೆ ಯಕ್ಕ ಸಂವಾ ದೆಕಿನ ಮಯಾ ಕರಿನ ತಿನೆ ತುನೆ ಯಕ್ಕ ಕಮ ಥಯುಸ ಜಾ಼ ತು ಗಳಸಲ ತೆಕ್ಲು ಇಕ್ಕಿನ ಗರಿಬೊನೆ ವಾಟ ಸ್ವರ್ಗಮಾ ತು ಸೌಕಾರ ರ‍್ಹಸಿ ತು ಮಾರಾ ಪಾಚೊ಼ ಆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ತೆ ಘನ್ನೊ ಸೌಕಾರ ರ‍್ಹಯಲ ಹುತಿ ಎ ವಾತೆ ತೆ ಮ್ಹೊಡು ಉತಾರಲಿನ ದುಖಕ್ಹು ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ತೆಳಾಮಾ ಯೆಸು ಸುತ್ತೆ ದೆಕಿನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸೌಕಾರ ರ‍್ಹಯಲ ವಾಲೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಆವಾನು ಘನ್ನು ಕಷ್ಟ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ಶಿಷ್ಯಾ ತಿನಿ ವಾತ ಐಕಿನ ಘಾಬ್ರಾಥಯಾ. ಯೆಸು ಫರಿನೆ ತ್ಯುನೊನೆ-ಮಾರಾ ಬಚ್ಚಾ಼ವೊ,ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಮಳಾನು ಕೆಕ್ಲು ಕಷ್ಟ ವ್ಹೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ಸೌಕಾರ ರ‍್ಹಯಲ ವಾಲೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಸೆರಾನು ಕೆಕ್ಲೊ ಕಷ್ಟ ವ್ಹೈ ಕದ್ಯಾಮ ಹುಂಟ ಕ್ಹೊಯಿನಾ ಡೊಳಾಮಾತು ಜಾ಼ವಾನು ಆಸಾನ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ಎ ವಾತೆ ತ್ಯುನೆ ವರಿ ಘಾಬ್ರಾಥೈನ. ಇಮ್ಮ ರಹ್ಯುಮ ಕಿನೆ ರಕ್ಷಣೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಕೈಲಿವಾನು ದೆಕಿನ ಯೆಸು ತ್ಯುನೊನೆ ದೆಕಿನ ಎ ಮನಕ್ಹೊನೆ ಅಸಾದ್ಯ ವ್ಹೈ; ಕ್ಹುದಾನೆ ಅಸಾದ್ಯ ನ್ಹವೈ ಕ್ಹುದಾನೆ ಕ್ಹಾರು ಸಾದ್ಯ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ಪೆತ್ರಾ ಬೊಲ್ಯೊ- ದೆಕ ಹಮೆ ಕ್ಹಾರುಜ಼ ಛೊಡಿನ ತಾರಾ ಪಾಚಾ಼ ಆವಾಡ್ಯಾಸ. ಕೈನ ಕವಾನು ಚ಼ಾಲು ಕರು ಕವಾಕ್ಹುಜ಼. ");
INSERT INTO sle_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ಯೆಸು. ಮಿ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ ಕುನ್ನಬಿ ಮಾರಾಹುತಿ ಸುವಾರ್ತೆನಾ ಹುತಿ ಘರನೆ ರ‍್ಹವಾದೆ ಭೈ ಭೆನ ಯಾ ಬಾಪನೆ ಬಚ್ಚಾವೊನೆ ಜಿಮಿನ್ನೆ ಛೊಡಿನ. ");
INSERT INTO sle_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ಛೊಡಲವಾಲಾನೆ ತಿನೆ ಹಮ್ನಾನಾ ಕಾಲಮಾ ಘರ, ಭಾಯೊ, ಭೆನೊ, ಯಾ, ಬಚ್ಚಾ, ಜಿಮಿನ ಎ ಕ್ಹಾರು ತ್ರಾಸನಾ ಕ್ಹಾತೆ ಕ್ಹಾರು ಮಳಸ. ವರಿ ಅಗಲ್ಯಾ ಜಗತಮಾ (ದುನಿಯಾ) ಕ್ಹುದಾಕನ ರ‍್ಹವಾನೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಮಳಸ ");
INSERT INTO sle_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ಘನ್ನಾ ಮನಕ್ಹೊ. ಪಾಚಾ಼ರ‍್ಹಯಲವಾಲಾ ಅಗಾ ಥಾವಸ ಅಗಾ ರ‍್ಹಯಲವಾಲಾ ಪಾಚಾ಼ಥಾವಸ ಇಮ್ಮ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಯೆರುಸಲೆಮಿನಿ ವಾಟ ಧರಿನಜಾ಼ತಾಮಾ ಯೆಸು ಅಗೊ-ಅಗೊ ಚಾ಼ಲ್ಯೊತೊ. ತಿನಾ ಪಾಚಾ಼ ರಹೆಲ ಶಿಷ್ಯಾ ಗಲಿಬಿಲಿ ಥಯಾ ತಿವ್ನಾ ಕ್ಹಾತೆ ಆವಾಲಾ ಮನಕ್ಹೊ ಭುಚ಼್ಕಾ ವರಕ್ಹಾ ಥಯಾ. ತೆಳಾಮಾ ತೆ ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನ ಫರಿನ ತಿನಾ ಕ್ಹಾತೆ ಅಗು ಥಾವಾನು ಕತೊರ‍್ಹತಾಮಾ ತ್ಯುನೊನೆ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ದೆಕೊ ಅಪೆ ಯೆರುಸಲೆಮೆ ಚಾ಼ಲ್ಯಾಸ ವರಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಖಾಸ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊನಾ ಹತ್ಮಾ ಧರಿನ ದಿವಸ. ವರಿ ತ್ಯುನೆ ತಿನೆ ತಿಪರ ತಪ್ಪ ಘಾಲಿನ ಮರವಾನಿ ಶಿಕ್ಕಷಾದಿವಸ ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಹತ್ಮಾ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ಇವ್ನೆ ತಿನೆ ಕದ್ರಾವಸ ತಿಪರ ಥುಕ್ಕಕಸ ತ್ಯುನೆ ತಿನೆ ಬಾರಕೊಲಕ್ಹು ಮಾರಸ ವರಿ ಖಲಾಸ ಕರಿಪಾಡಸ ತೆ ತನ ದಿನ್ನ ಥಯಲ್ಪರ ಜುತೊಥೈನ ಉಟಿನ ಆವಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ತೆಳಾಮಾ ಜೆಬೆದಾಯನಾ ದಿಕ್ರಾ ಯಾಕೊಬ ಯೊಹಾನ. ಯೆಸುಕನ ಐನ ತಿನೆ ಗುರು ಹಮೆ ಯಕ್ಕ ಮಾಂಗಿಯೆಸ. ತೆ ಹಮಾರಾ ಹುತಿ ಪುರಾಕರು ಕದ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ - ");
INSERT INTO sle_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ತುಮೊನೆ ಸು ಪುರಾಕರು ಕೈನ ಕತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ತು ಮಹಿಮಾನಾ ರಾಜ್ಯ ಸಿಂಹಾಸನಿ ಪದವಿಪರ ಬೈಟತಾಮಾ ಹಮೊಮಾ ಯಕ್ಲಾನೆ ಸಿದಾಹತೆ ಯಕ್ಲಾನೆ ಡಾವಾ ಹತ್ ಬಗಲ ಹಮೊನೆ ಬೈಟಾನೆ ದೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ-ತುಮೆ ಸು ಪುಚಾ಼ಡ್ಯಾಸ ತುಮೊನೆ ಗೊತ್ತನತ್ತಿ. ಮಿ ಪಾನಿ ಪಿವಾನಾ ತ್ರಾಸನಾ ತಾಂಬಿಯಾಮಾ ತುಮೊನೆ ಪಿವಾನೆ ಥಾವಸು? ಮನೆ ಥಾವಾನು ಬಾಪ್ತಿಸ್ಮ ತುಮೊನೆ ಕರೈಲಿವಾನೆ ಥಾವಸು. ಕೈನ ಪುಚ್ತಾ಼ಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ತ್ಯುನೆ-ಥಾವಸ ಕದ್ಯಾ ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಮಿ ಪಿವಾನಾ ತಾಂಬಿಯಾಮಾ ತುಮೆ ಪಿವೊಸಿ. ಮನೆ ಥಾವಾನು ಬಾಪ್ತಿಸ್ಮ ತುಮೊನೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ವರಿಬಿ ಮಾರಾ ಆಜು಼ ಬಾಜು಼ಮಾ ಬೈಟಾನು ಅದಿಕಾರ ದಿವಾನು ಮಾರಾ ಹತ್ಮಾ ನತ್ತಿ. ಕ್ಹುದಾಜ಼ ದಿವಸ ತೆ ಕಿನಾಹುತಿ ತೆ ತಯ್ಯಾರ ಥೈಸ ತೆ ತಿನೆಜ ಮಳಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ಉಗ್ರಲ ದಕ್ಹೆ ಶಿಷ್ಯಾ ಎ ಐಕಿನ ಯಾಕೊಬ ಯೊಹಾನ ಪರ ಶಿಟ್ಟಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ಯೆಸು ಕ್ಹಾರಾವೊನೆ ನಜಿಕ ಬಲೈನ ತ್ಯುನೊನೆ ಯೆಹುದಿ ನಾಯಕೊನೆ ಕ್ಹಾರು ಅದಿಕಾರ ದಿದ್ಯಾಸ ಎ ಕ್ಹಾರು ಅದಿಕಾರ ಬಿಜಾ಼ ಮನಕ್ಹೊಪರ ರಾಜ಼ ಕರುಸ ಕವಾಲಾ ತ್ಯುನೊಪರ ಅಹಂಕಾರಕ್ಹು ರಾಜ಼ ಕರಸ. ವರಿ ತ್ಯುನೊಮಾ ಮ್ಹೊಟೊ ಜ಼ಬರದಸ್ತಿಕ್ಹು ರಾಜ಼ ಚ಼ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ತುಮೊಮಾ ತಿಮ್ಮ ರ‍್ಹೌ ನೈ ತುಮೊಮಾ ಮ್ಹೊಟೊ ಥೌಸ ಕವಾಲೊರ‍್ಹಯೊಮ ತೆ ತಮಾರೊ ಸೆವಕ ಥೌ; ");
INSERT INTO sle_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ವರಿ ತುಮೊಮಾ ಪೈಲಾ ಥೌಸಕವಾಲೊ ಕ್ಹಾರಾವೊನೊ ಆಳ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ಮನಕ್ಹನೊ ದಿಕ್ರೊಬಿ ಸೆವಾ ಕರೈಲಿವಾನೆ ನತ್ತಿ ಆಯೊ. ಸೆವಾ ಕರಾನೆ. ವರಿ ತೆ ಜ಼ಲಮ ದಿನ್ನ ಘನ್ನಾಜ಼ನಾವೊನೆ ಛೊಡಾವಾನೆ ಆಯೊಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ತ್ಯುನೆ ಯೆರಿಕೊವಿಯೆ ಆಯಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಮನಕ್ಹೊನು ಗುಂಪ ತೆ ಗಾಮತಾ ಜಾ಼ತಾಮಾ ತಿಮಾಯನೊ ದಿಕ್ರೊ ಬಾರ್ತಿಮಾಯಾ ತೆ ಕುಡ್ಡೊ ಮಾOಗಾನೆ ವಾಟನಾ ಬಾಜು಼ಮಾ ಬೈಟ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ತೆ ಕುಡ್ಡೊ ಭಿಕ ಮಾಂಗಾಲೊ ವ್ಹತ್ತೊ. ಎ ವಾಟಪರ ಜಾ಼ವಾನೊ ನಜ಼ರೆತನೊ ಯೆಸು ವ್ಹೈ ಕೈನ ಐಕಿನ ದಾವಿದನಾ ದಿಕ್ರಾ ಯೆಸು. ಮನೆ ಮರಗ ಕೈನ ವದ್ರಾನು ಚಾಲುಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ಘನ್ನಾಜ಼ನಾ ತಿನೆ ಗಪ ರ‍್ಹೆ ವರಿ ತೆ ದಾವಿದನಾ ದಿಕ್ರಾ ಮನೆ ಮರಗ ಕೈನ ವರಿ ಜೊ಼ರ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ತೆಳಾಮಾ ಯೆಸು ಹುಬ್ರೈನ ತಿನೆ ಬಲೈ ಲಾವೊ ಕದ್ಯೊ. ತೆಳಾಮಾ ಮನಕ್ಹೊ ತೆ ಕುಡ್ಡಾನೆ ಬಲೈನ ಖುಶಿ ಕರ ಉಟ. ತುನೆ ಬಲಾವಾಡ್ಯೊಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ತೆ ತಿಪರ ವಳ್ಳಿದಲ ಪ್ಹಡಕು ನಾಕಿನ ಗಪ್ನೆ ಉಟಿನ ಯೆಸುಕನ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ಯೆಸು ತಿನೆ ಮಿ ತುನೆ ಸುಕರು ಕೈನ ಆಸ ಛೆ. ಕೈನ ಪುಚ್ತಾ಼ಮಾ. ತೆ ಕುಡ್ಡೊ ಮನೆ ಡೊಳಾ ದಿಕ್ಹಾವರಕ್ಹಾ ಕರು. ಗುರು. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ಯೆಸು ತಿನೆ - ಜಾ಼ ತಾರೊ ಬರೊಕ್ಹೊ ತುನೆ ಅರಾಮ ಕರ‍್ಯೊಸ ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತಿನಾ ಡೊಳಾ ಆಯಾ. ತೆ ವಾಟಮಾ ತಿನಾ ಪಾಚೊ಼ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ತ್ಯುನೆ ಯೆರುಸಲೆಮ್ನಾ ನಜಿಕ ರ‍್ಹಯಲ ಬೆತ್ಪ ವರಿ ಬೆಥಾನ್ಯ ಐನ ತೆಲನಾ ಝಾಡನಾ ಡೊಂಗರೊಕನ ಗಯಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆಜ಼ನಾವೊನೆ ಬಲೈನ ತಿನಾ ಅಗೊ ಮೊಕಲ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ತ್ಯುನೊನೆ ಅಮ್ಮ ಕೈನ ಮೊಕ್ಕಲ್ಯೊತುಮಾರಾ ಕ್ಹಾಮು ರ‍್ಹಯಲ ಗಾಮೆ ಜಾವೊ ; ತ್ಯಾ ಭಾಂದಲ ಕುನ್ನಜ಼ ನೈ ಚ಼ಡಲ ಯಕ್ಕ ಗದಡಾನು ಬಚ್ಚು಼ ತುಮೆ ದೆಕೊಸಿ ; ತಿನೆ ಛೊಡಿನ ನ್ಹ್ಯಾ. ಧರಿನ ಲಿನಾವೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ತುಮೊನೆ ಕುನ್ನಬಿ ಪುಚ್ಯುಮ ಮಾಲಕನೆ ಎ ಚಾ಼ಯೆಥೈಯುಸ ವರಿ ತೆಳಾನ ತೆಳಾಮಾಜ಼ ತಿನೆ ಫರಿನ ಮೊಕ್ಲಸ- ");
INSERT INTO sle_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ತೆ ಶಿಷ್ಯಾ ಗೈನ ಗಾಮ್ನಾ ವಾಟೆ ರ‍್ಹಯಲ ಘರನಾ ಬಾಕಲ್ನಾ ಕ್ಹಾಮು ಗದಡಾನಾ ಬಚ್ಚಾ಼ನೆ ಭಾಂದಲ ದೆಕಿನ ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ತಿನೆ ಛೊಡತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ತ್ಯಾ ಹುಬ್ರಯಲ ದಕ್ಹಾ ಜ಼ನಾ ದೆಕಿನ - ಆ ಬಚ್ಚಾ಼ನೆ ಛೊಡಿನ ತುಮೆ ಸು ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ಕೈನ ಪುಚ್ತಾಮಾ ತ್ಯುನೆ ಯೆಸು ಕದಲತಿಮ್ಮ ತ್ಯುನೆ ಕತಾಮಾ ತೆ ಮನಕ್ಹೊ ಲಿನ ಜಾ಼ವಾನೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ಶಿಷ್ಯಾ ತೆ ಬಚ್ಚಾ಼ನೆ ಯೆಸುಕನ ಲೈನ ತಿವ್ನಾ ವಣ್ಣಾ ತಿಪರ ಘಾಲ್ತಾಮಾ ಯೆಸು ತಿಪರ ಚ಼ಡಿನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ತೆಳಾಮಾ ಘನ್ನಾಜ಼ನಾ ತಿವ್ನಾ ವಣ್ಣಾ ಕಾಡಿನ ವಾಟಪರ ವಚ್ಚಾ಼ಯಾ ವರಿ ದಕ್ಹಾಜ಼಼ನಾ ತ್ಯುನಾ ಮಳಾಮಾತಾ ಗರಿಯೊ ಕತ್ರಿನ ಲೈನ ವಾಟಪರ ವಚ್ಚಾ಼ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ಯೆಸುನಾ ಅಗಾ ಪಾಚಾ಼ ಜಾ಼ವಾಲಾ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ. ಕರ್ತಾನಾ ನಾಮಪರ ಆವಾಲಾನೆ ಆಶಿರ್ವಾದ ");
INSERT INTO sle_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ಹಮಾರೊ ಬಾ ಥಯಲ ದಾವಿದನಾ ರಾಜ್ಯನೆ ಕ್ಹುದಾ ಆಶಿರ್ವಾದ ದಿವಾದೆ ತೆ ರಾಜ್ಯ ಆವಾಡ್ಯೊಸ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ಜ಼ೊರ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ತೆಳಾಮಾ ಯೆಸು ಯೆರುಸಲೆಮ ಗೈನ ದೆವಾಲಯಮಾ ಗೈನ ಸುತ್ತೆ ಕ್ಹಾರು ದೆಕಿನ ತೆಕ್ಲಾಮಾಜ಼಼ ಕ್ಹಾಂಜ಼ ಥೈಗಯಲಹುತಿ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನೆ ಬೆಥಾನ್ಯ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ಮರನಾದಿನೆ ತ್ಯುನೆ ಬೆಥಾನ್ಯ ಛೊಡಿನ ಆತಾಮಾ ಯೆಸು ಭುಕ್ಕೊ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ವರಿ ಪಾಲೊ ಛೊಡಲ ಉOಬ್ರೊನು ಝಾಡ ದುರ ರ‍್ಹಯಲ ದೆಕ್ಯೊ. ತಿಮಾ ತಿನೆ ಖಾವಾನೆ ಸುಬಿ ಮಳಸ ಕೈನ ತಿನಾ ನಜಿಕ ಗಯೊ. ತಿನಾ ನಜಿ಼ಕ ಆತಾಮಾ ತಿಮಾ ಪಾಲೊ ಛೊಡಿನ ಬಿಜು಼ ಸುಜ಼ ದಿಖ್ಯ್ಹನೈ ತೆಳಾಮಾ ಉOಬ್ರೊನಾ ಫಲನೊ ದಿನ್ನ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ತೆಳಾಮಾ ಯೆಸು ತೆ ಝಾಡನೆ - ಇತ್ತಿ ಉಪ್ಪರ ಯಕ್ಲೊಬಿ ತುಕನ ಫಲ ಹಮೆಶಾಬಿ ಖೌ ನೈಸೊ ಥಾವಾದೆ. ಕದ್ಯೊ. ತಿನಾ ಶಿಷ್ಯಾ ತೆ ವಾತ ಐಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ತ್ಯುನೆ ಯೆರುಸಲೆಮೆ ಆತಾಮಾ ಯೆಸು ದೆವಾಲಯಮಾ ಗೈನ ತಿಮಾ ವ್ಯಾಪಾರ ಕರಾಲಾವೊನೆ ಲಿವಾಲಾವೊನೆ ದೊಕಡಾ ಬದ್ಲಿ ಕರಾವಾಲಾವೊನೆ ಮೊಕ್ಕಲಿಪಾಡಾನು ಶುರು ಕರ‍್ಯೊ ತಿವ್ನಾ ಟೆಬ್ಲೊ ಕ್ಹಬುತರನಿಯ್ಯೊ ಕುರಚಿಯೊ. ಪಾಡಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ಯಕ್ಲಾನೆಬಿ ಸಾಮಾನಲಿನ ದೆವಾಲಯಮಾ ನಿಂಜಾ಼ವಾನೆ ದಿದ್ಯೊನೈ. ");
INSERT INTO sle_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ವರಿ ತೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕೈನ- ಮಾರಿ ಆಲಯ ಕ್ಹಾರಿ ಜ಼ನಾಂಗನೆ ಪ್ರಾಥನಾನು ಘರ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಸ ಕೈನ ಬರ್ದಲ ಛೆ ತೊ? ತುಮೆ ತೆ ಜ಼ಗಾನೆ ಚ್ವಟ್ಟಾವೊನು ಘರ ಕರಿಪಾಡ್ಯಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ತೆ ವಾತ ಖಾಸ ಯಾಜಕ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಐಕಿನ ಯೆಸುನೆ ಕೈ ಉಪಾಯಕ್ಹು ಖಲಾಸಕರಿಯೆ ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ; ಕಾಕದ್ಯಾಮ ಮನಕ್ಹೊ ತಿನಿಯೊ ವಾತೊ ಐಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾಥೈನ ವರಿ ತಿಕ್ಹು ಭುಚ಼್ಕಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ತೆ ದಿನ್ನಾ ಕ್ಹಾಂಜೆ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಗಾಮ ಛೊಡಿನ ಭಾರಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ಪಾಟೆ ತ್ಯುನೆ ಆತಾಮಾ ತೆ ಉಂಬ್ರೊನು ಝಾಡ ಬುಡತುಜ಼಼ ಕುಕ್ಹೈಗಯಲ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ತೆಳಾಮಾ ಪೆತ್ರಾ ಪಾಚು಼ ಥಯಲ ನೆಣಸಿನ ಯೆಸುನೆ - ಗುರು ದೆಕ ತು ಶ್ರಾಪ ದಿದಲ ಉOಬ್ರೊನು ಝಾಡ ಕುಕ್ಹೈ ಗಯುಸ ಕತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ಯೆಸು ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ತುಮಾರೊ ಬರೊಕ್ಹೊ ಕ್ಹುದಾಪರ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ, ಕಯೊಬಿ ರ‍್ಹವಾದೆ ಆ ಡೊಂಗರನೆ ತು ಕಿತ್ತೈನ ಸಮುಂದರಮಾ ಪಡ ಕೈನ ತಿನಾ ಮನಸ್ಮಾ ಸಂಶೊ ಕರ‍್ಯಾವಾಚಿ ತೆ ಕೈಲಿದಲ ಥಾವಸ ಕೈನ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಲಿದ್ಯೊಮ ತೆ ಕದಲ ತಿಮ್ಮ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ತೆ ಕಾರಣಕ್ಹು ತುಮೆ ಪ್ರಾಥನಾಮಾ ಸು ಮಾಂಗಿಲಿವೊಸಿ ತೆ ಕ್ಹಾರು ಮಳ್ಯುಸ ಕೈನ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾಮ ತೆ ಕ್ಹಾರು ತುಮೊನೆ ಮಳಸ ಕೈನ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ಎನೈಸೊ ತುಮೆ ಹುಬ್ರೈನ ಪ್ರಾಥನಾ ಕರತಾಮಾ ಕಿಪರಬಿ ತುಮೆ ವಿರೊಧ ರ‍್ಹಯಾಮ ತುಮೆ ತಿನೆ ಮಾಫಕರೊ; ಮಾಫ ಕರ‍್ಯಾಮ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರೊ ಬಾ ತುಮಾರಾ ತಪ್ಪೊನೆ ಮಾಫಕರಸ ಇಮ್ಮ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ತೆನೈಸೊ ತುಮೆ ಬಿಜಾ಼ವೊನೆ ಮಾಫ ನೈ ಕರ‍್ಯಾಮ, ಪರಲೊಕಮಾ ರ‍್ಹವಾಲೊ ತುಮಾರೊ ಬಾಬಿ ತುಮಾರಾ ತಪ್ಪೊ ಮಾಫ ನೈ ಕರ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ತ್ಯುನೆ ಫರಿನ ಯೆರುಸಲೆಮೆ ಆತಾಮಾ ಯೆಸು ದೆವಾಲಯಮಾ ಫರತಾಮಾ ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಯೆಸುಕನ ಐನ - ");
INSERT INTO sle_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ತು ಎಕ್ಹಾರು ಕೈ ಅದಿಕಾರಕ್ಹು ಕರಶಿ? ಯೆ ಕ್ಹಾರು ಕರಾನೆ ತುನೆ ಕುನ್ನ ಅದಿಕಾರದಿದ್ಯುಸ ಕೈ ತಿನೆ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ಯೆಸು ತ್ಯುನೊನೆ - ಮಿ ತುಮೊನೆ ಯಕ್ಕ ವಾತ ಪುಚ಼್ಚುಸ,ಮನೆ ತುಮೆ ಜವಾಬ ದಿದ್ಯಾಮ ಮಿಬಿ ತುಮೊನೆ ಕಯಾ ಅದಿಕಾರಕ್ಹು ಯೆ ಕರಾಡ್ಯೊಸ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾನೊ ಅದಿಕಾರ ಯೊಹಾನನೆ ಕ್ಹುದಾಕಂತೊ ಆಯೊಸು? ಮನಕ್ಹೊಕಂತೊ ಆಯೊಸ? ಜವಾಬ ದಿವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ತೆಳಾಮಾ ತ್ಯುನೆ - ಕ್ಹುದಾಕಂತೊ ಆಯೊಸ ಕದ್ಯಾಮ ತುಮೆ ತಿನೆ ಕಾ ನಂಬ್ಯಾನತ್ತಿ ಕೈಪಡಸ್ತೊ; ಮನಕ್ಹತಿ ಆಯುಸ ಕದ್ಯಾಮ ಸು ಥಾವಸ ಕೈನ ತಿವ್ನೊ ತಿವ್ನೊಮಾಜ಼ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ಯೊಹಾನ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಸುಜ಼ ಸಂಶಯವಾಚಿ ಮನಕ್ಹೊನೆ ಗೊತ್ತ ವ್ಹತ್ತು ಇವ್ನೊನೆ ಮನಕ್ಹೊನು ಭುಚ಼್ಕ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ಇಮ್ಮ ರ‍್ಹತಾಮಾ -ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ಯೆಸುನೆ ಜವಾಬ ದಿದ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಮಿ ಕೈ ಅದಿಕಾರಕ್ಹು ಎ ಕ್ಹಾರು ಕರುಸ ಕೈನ ನೈಕತೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ತೆಳಾಮಾ ಯೆಸು ತಿವ್ನಾ ಕ್ಹಾತೆ ಯಕ್ಕ ಸಾಮ್ಯ ಲಿನ ಕವಾಡೊತೊ. ಯಕ್ಕ ಮನಕ್ಹ ಯಕ್ಕ ದ್ರಾಕ್ಷಿನೊ ಮಳೊ ಕರಿನ ಸುತ್ತೆ ಬೆಲಿ ಘಾಲಿನ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಕಾಡಾಹುತಿ ಯಕ್ಕ ಖಾಡಿಲಿಂಗತ ಕರಿನ ಕೈದಾಲಾನೆ ಯಕ್ಕ ಝುಪ್ಡು ಭಾಂದಿನ ತೆ ಮಾಲಕ ದ್ರಾಕ್ಷಿಯೊನೊ ಮಳೊ ದಕ್ಹಾ ರೈತರೊನೆ ಗುತ್ತಿಗೆ ದಿನ್ನ ಗಾಮೊಪರ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ತೆ ಥಯಲ್ಪರ ದ್ರಾಕ್ಷಿಯೊನೊ ಸಿಜ಼ನನೊ ಟೈಮ ಆತಾಮಾ ದ್ರಾಕ್ಷಿಯೊನೊ ಮಳಾನೊ ವಾಟೊ ಪುಚ್ಚಾ಼ನೆ ರೈತರೊಕನ ತೆ ಮಾಲಕ ತಿನಾ ಯಕ್ಕ ಆಳನೆ ತಿವ್ನೊಕನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ತ್ಯುನೆ ತಿನೆ ಧರಿನ ಮಾರಿನ ಸುಜ಼ ದಿದ್ಯಾವಾಚಿ ಖಾಲಿ ಹತೆ ಮೊಕ್ಕಲಿಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ತೆ ಮಾಲಕ ಫರಿನ ವರಿ ಯಕ್ಲಾ ಆಳನೆ ಮೊಕಲ್ತಾಮಾ ತೆ ರೈತರೊ ತಿನೆ ಮಾತಾ ಮಾತಾಪರ ಮಾರಿನ ಮರ್ಯಾದಿ ಕಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ತೆ ಥಯಲ್ಪರ ಮಳಾನೊ ಮಾಲಕ ವರಿ ಯಕ್ಲಾನೆ ಮೊಕಲ್ತಾಮಾ ತಿನೆಬಿ ಖಲಾಸ ಕರಿಪಾಡ್ಯಾ. ಹಜು಼ನ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಮೊಕಲ್ತಾಮಾ ತಿಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಮಾರಿನ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಕತ್ರಿನ ನಾಕಿಪಾಡ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ತಿನೆ ಹಜು಼ನ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ತಿನೊ ಮಯಾನೊ ದಿಕ್ರೊ ಮಾರಾ ದಿಕ್ರಾನೆತಬಿ ಮೊಕಲ್ಯೊಮ ತಿನೆ ಮರ್ಯಾದಿ ದೆಸಕೈನ ಮಾಲಕನಾ ತರಪತೊ ಲಾಸ್ಟಮಾ ತಿನೆ ತ್ಯುನೊಕನ ಮೊಕ್ಕಲತಾಮಾ ತೆನೈಸೊ ತೆ ರೈತರೊ ");
INSERT INTO sle_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ತೆಜ಼ ವಾರಿಸದಾರ ವ್ಹೈ ಕೈನ. ಮಾಲಕನಾ ದಿಕ್ರಾನೆ ಖಲಾಸ ಕರಿಪಾಡಿಯೆ ತೆಳಾಮಾ ಎ ಪುರಾ ಅಪ್ನೊನೆ ಥೈಜಾ಼ವಸ. ಕೈನ ರೈತರೊ ಯಕ್ಲಾನಾ ಕ್ಹಾತೆ ಯಕ್ಲಾ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ತಿನೆ ಧರಿನ ಖಲಾಸ ಕರಿನ ತಿನು ಅOಗ ದ್ರಾಕ್ಷಿನಾ ಮಳಾನಾ ಭಾರಾ ನಾಕಿಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ಯೆಸು ಪುಚ್ಯೊ ತಿಮ್ಮ ಥಯುಮ ದ್ರಾಕ್ಷಿನೊ ಮಳಾನೊ ಮಾಲಕ ಸುಕರೆ? ತೆ ಯಕ್ಕ ರೈತರೊನೆ ಖಲಾಸಕರಿನ ಬಿಜಾ಼ ರೈತರೊನೆ ವಪ್ಸಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ತುಮೆ ಗ್ರOಥಮಾ ಒದ್ಯಾವಸೆತೊ ಘರ ಭಾಂದಾಲಾವೊನೆ ನಕೊ ಚಾ಼ಯೆ ಕೈನ ಭಿರಕಾಯಲ ದಗ್ಡೊಜ಼ ಚಾ಼ಯೆಥಯಲ ಮುಲಾನೊ ದಗ್ಡೊ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ಎ ಕರ್ತಾನಾ ಹತೆ ಥಯು ; ಹಮೊನೆ ಆಶ್ಚರ್ಯಲಿಂಗತ ದಿಕ್ಹಸ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ಎ ಸಾಮ್ಯ ಅಪ್ನಾಹುತಿ ಕದ್ಯೊ ಕೈನ ತ್ಯುನೆ ತಿಳದಿಲಿನ ತಿನೆ ಧರಾಹುತಿ ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಟೈಮ ದೆಕಾಡಾತಾ ವರಿ ಮನಕ್ಹೊನೆ ಭುಚ಼ಕಿನ ತಿನೆ ಛೊಡಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ತೆ ಥಯಲ್ಪರ ಯೆಸುನೆ ವಾತೊಮಾ ತಪ್ಪ ಧರುಕೈನ ಫರಿಸಾಯರೊ ವರಿ ಹೆರೊದ್ಯೆ ಗುOಪ ಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಯೆಸುಕನ ಮೊಕ್ಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ಇವ್ನೆ ಐನ ಭೊದಕ, ತು ಕ್ಹರಿನೊಜ಼ ವ್ಹೈ. ಕಿನೆಜ಼಼ ಭುಚ಼ಕಾಲೊ ನ್ಹವೈ; ತು ಮನಕ್ಹೊನಾ ಮ್ಹೊಡಾ ದೆಕ್ಯಾವಾಚಿ ಬೊಲಾಲೊ ವ್ಹೈ ವರಿ ಕ್ಹುದಾನಿ ವಾಟ ಕ್ಹರಿಮಾಜ಼ ದೆಕಾಡಾಲೊ ವ್ಹೈ ಕೈನ ಹಮೆ ತಿಳದಿಲಿದ್ಯಾಸ ರೊಮನನಾ ಚಕ್ರವರ್ತಿನೆ ಅಪೆ ಭುಭಾಡೊ ದಿವಾನು ಅಪ್ನಾ ನಿಯಮನಾ ವಿರುದ್ದ ವ್ಹೈ ಅಪೆ ದ್ಯುಸು ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ಯೆಸು ತಿವ್ನು ಕಪಟ ತಿಳ್ದಿನ - ಮನೆ ಕಾ ಪರಿಕ್ಷಾ ಕರಾಡಾಸ? ಮನೆ ರುಪ್ಪಾನೊ ಯಕ್ಕ ಬಿಲ್ಲೊ ಲೈನ ದೆಕಾಡೊ ಕತಾಮಾ ತ್ಯುನೆ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ತೆಳಾಮಾ ತೆ ಆ ಬಿಲ್ಲಾಪರ ರ‍್ಹಯಲ ಮ್ಹೊಡು ವರಿ ನಾಮ ಕಿನು ವ್ಹೈ ಕೈನ ಪುಚ್ತಾಮಾ ತ್ಯುನೆ ಚಕ್ರವರ್ತಿನೆ ವ್ಹೈ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ಯೆಸು ತ್ಯುನೊನೆ ಥೈಯು, ಚ಼ಕ್ರವರ್ತಿನು ರ‍್ಹಯಲ ಚ಼ಕ್ರವರ್ತಿನೆ ದಿವೊ. ಕ್ಹುದಾನು ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ದಿವೊ. ಕದ್ಯೊ. ತ್ಯುನೆ ತಿನಿ ವಿಚಾರ ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ತೆ ಥಯಲ್ಪರ ಪುನರುತ್ಥಾನ ನತ್ತಿ ಕವಾಲಾ ಸದ್ದುಕಾಯರೊ ಯೆಸುಕನ ಐನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ಇವ್ನೆ ಯೆಸುಕನ ಐನ ಪ್ರಶ್ನೆ ಸು ಪುಚ್ಚಾಕದ್ಯಾಮ ಭೊದಕ ಮೊಶೆನಾ ನಿಯಮನಾ ಹುತಿ, ಯಕ್ಕ ಮನಕ್ಹ ಬಚ್ಚಾ ನೈಸೊ ಬೈಕೊನೆ ಛೊಡಿನ ಮರಿಗಯೊಮ ತಿನೊ ನ್ಹಾನೊ ಭೈ ತೆ ರಾOಡಿನೆ ಹಿವಾ ಕರಲಿನ ತಿನಾ ಮ್ಹೊಟಾ ಭೈನಾ ನಾಮೆ ಬಚ್ಚಾಹುಟ್ಸಾನು ಛೆ ಕೈನ ಹಮೊನೆ ಮೊಶೆ ಬರ್ದಿನ ಮ್ಹೆಲ್ಯೊಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ಕ್ಹಾತ ಭಾಯೊ ವ್ಹತ್ತಾ. ಪಸ್ಟ ರ‍್ಹಯಲವಾಲೊ ಹಿವಾ ಕರಲಿನ ಬಚ್ಚಾ ನೈಸೊ ಮರಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ಬೆವಾವಾಲೊ ತೆ ಹೆಣ ಮನಕ್ಹನೆ ಹಿವಾ ಕರಲಿನ ಬಚ್ಚಾ಼ ನೈಸೊ ಮರಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ತಿನಾಲಿಂಗತಜ಼ ತನವಾವಾಲೊ ಬಿ ಇನಾಲಿಂಗತಜ಼ ಕ್ಹಾತೆ ಜ಼ನಾ ಬಚ್ಚಾ ನೈಸೊ ಮರಿ ಗೈ ಪಡ್ಯಾ. ಲಾಸ್ಟಮಾ ತೆ ಹೆಣ ಮನಕ್ಹ ಮರಿ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ಪುನರುತ್ಥಾನಮಾ ತೆ ಕಿನಿ ಬೈಕೊ ಥೈನ ರ‍್ಹ್ಯೆ? ತಿನೆ ಕ್ಹಾತೆ ಜ಼ನಾ ಹಿವಾ ಕರಲಿದ್ಯಾಸ್ತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ಯೆಸು ತ್ಯುನೊನೆ, ತುಮೆ ಕಾ ತಪ್ಪಮಾ ಛೆ ವರಿ ತುಮೆ ಕಾ ತಪ್ಪ ವಿಚಾರಮಾ ಛೆ ಕಾಕದ್ಯಾಮ. ಕ್ಹುದಾನಿ ತಾಕತನೆ ರ‍್ಹವಾದೆ ಪವಿತ್ರ ಗ್ರಂಥನೆ ರ‍್ಹವಾದೆ ತಿಳದಿಲಿದ್ಯಾ ನತ್ತಿ ");
INSERT INTO sle_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ಮರಲವಾಲಾ ವಾಚಿ಼ನ ಉಟಲಪರ ಹಿವಾ ಕರಲೆತಾ ನೈ, ಕರಿನ ದೆತಾಬಿ ನೈ ; ಸ್ವರ್ಗಲೊಕಮಾ ದೆವ ದುತೊ ಲಿಂಗತ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ತೆನೈಸೊ ಮರಲವಾಲಾ ಜಿವ್ತಾ ಥಾವಸ ಕವಾನಾ ಹುತಿ ಕೌ ಕದ್ಯಾಮ -ಮಿ ಅಬ್ರಹಾಮನೊ ಕ್ಹುದಾ ಇಸಾಕನೊ ಕ್ಹುದಾ ಯಾಕೊಬ್ನೊ ಕ್ಹುದಾ ಮೊಶೆನಾ ಕ್ಹಾತೆ ಆಗ ಲಾಗಲ ಕಾಟಾನಾ ಝಾಡಮಾತೊ ಬೊಲಲ ಮೊಶೆನಾ ಗ್ರಂಥಮಾ ಅದ್ಯಾಯಮಾ ರ‍್ಹಯಲ ಯಕ್ಕ ಸಂಗತಿ ಒದ್ಯಾನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ತೆ ಜಿವ್ತಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಕ್ಹುದಾ ಥಯೊಸ ವರಿ ಕ್ಹುದಾನೆ ನಂಬಿನ ಮರಲವಾಲಾವೊನೆ ಕ್ಹುದಾ ವ್ಹೈ ವರಿ ಕ್ಹುದಾನೆ ನಂಬ್ಯಾವಾಚಿ ಮರಲವಾವೊನೊ ಕ್ಹುದಾ ನ್ಹವೈ. ತುಮೆ ಧರಲಿದಲ ಪದ್ದತ ಘನ್ನು ತಪ್ಪ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ಶಾಸ್ತ್ರಿಯೊಮಾನೊ ಯಕ್ಲೊ ತಿವ್ನಿ ತಕ್ಕರಾರ ಐಕಿನ ಯೆಸು ಚೊ಼ಕು ಜವಾಬ ದಿದ್ಯೊ ಕೈನ ತಿಳ್ದಿನ ತಿಕನ ಐನ -ಕ್ಹಾರಿ ಆಗನ್ಯಾಮಾ ಪೈಲಾ ರ‍್ಹಯಲಮ್ಹೊಟಿ ಆಗನ್ಯಾ ಕೈ ವ್ಹೈ? ಕೈನ ತಿನೆ ಪುಚ಼ತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ಯೆಸು ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊ ಐಕೊ ಹಮಾರೊ ಕರತಾ ಥಯಲ ಕ್ಹುದಾ ಯಕ್ಕಲೊಜ ಕರತಾ ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ತಾರೊ ಕರತಾ ಥಯಲ ಕ್ಹುದಾನೆ ಪುರಾ ಮನಸೆ ಪುರಾ ಜ಼ಲಮಕ್ಹು ಪುರಾ ಗ್ಯಾನಕ್ಹು ಪುರಾ ತಾಕತಕ್ಹು ಮಯಾ ಕರು ಕವಾನಿ ಪೈಲಾ ಆಗನ್ಯಾ ; ");
INSERT INTO sle_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ತಾರಾ ಆಜು಼ ಬಾಜು಼ವಾಲನೆ ತಾರಾನಿಂಗತಜ಼ ಮಯಾ ಕರು ಕೈನ ಕವಾನಿ ವಾತ ಬೆವಾ ಆಗನ್ಯಾ ವ್ಹೈ ;ಎ ಬೆತಿ ಮ್ಹೊಟಿ ಬಿಜಿ ಆಗನ್ಯಾ ಕೈಜ಼ ನತ್ತಿ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ತೆಳಾಮಾ ತೆ ಶಾಸ್ತ್ರಿ ಯೆಸುನೆ -ಭೊದಕ ಚೊ಼ಕು ಕದ್ಯೊ. ಯಕ್ಲೊ ಛೆ, ಕರತಾ ಥಯಲ ಕ್ಹುದಾ ಛೆ ತಿನೆ ಛೊಡಿನ ಬಿಜೊ಼, ಕ್ಹುದಾ ನತ್ತಿ. ತು ಕದಲ ಕ್ಹರಿಜ಼ ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ತಿನೆ ಪುರಾ ಮನಸಕ್ಹು ಪುರಾ ಗ್ಯಾನಕ್ಹು ಪುರಾ ತಾಕತಕ್ಹು ಮಯಾಕರಾನು ವರಿ ತಿನಾಕ್ಹು ತಿನೆ ಮಯಾಕರಲಿವಾನು ತಿನಾ ಆಜು಼ ಬಾಜುನಾವೊನೆ ಮಯಾಕರಾನು ಎ ಭಂಬಿ ಕ್ಹಾರಾ ಹೊಮಾತಿಬಿ ಕ್ಹಾರಾ ಜಾನ್ವರೊನಿ ಬಲಿತಿಬಿ ತೆ ಹೆಚ್ಕಿ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ತೆ ತಿನಿ ಗ್ಯಾನಕ್ಹು ಜವಾಬ ದಿದ್ಯೊ. ಯೆಸು ದೆಕಿನ - ತು ಕ್ಹುದಾನಾ ರಾಜ್ಯನೆ ದುರ ಥಯಲವಾಲೊ ನ್ಹವೈ ಕದ್ಯೊ. ತೆ ಥಯಲ್ಪರ ಯೆಸುನೆ ಪ್ರಶ್ನೆ ಕರಾನೆ ಕಿನೆಜ಼಼ ಧೈರಯ ನ್ಹೊತಿ. ");
INSERT INTO sle_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ಯೆಸು ದೆವಾಲಯಮಾ ಉಪದೆಶ ಕರತಾಮಾ ತೆ ಪ್ರಶ್ನೆಕರಿನ - ಶಾಸ್ತ್ರಿಯೊ ಆವಾನೊ ರ‍್ಹಯಲ ಕ್ರಿಸ್ತನೆ ದಾವಿದನಿ ಸಂತತಿ ವ್ಹೈ ಕೈನ ಕವಸ್ತೊ, ತೆ ಕಿಮಥಾವಸ? ");
INSERT INTO sle_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ದಾವಿದ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಿನ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಮಾರೊಕರತಾ ಥಯಲ ಕರ್ತಾನೆ. ಮಿ ತಾರಾ ವಿರೊಧಿಯೊನೆ ತಾರಾ ಪಗಮಾ ಘಾಲೆಲಕ್ಕಾ ಮಾರಾ ಕ್ಹಾತೆ ಮಾರಾ ಸಿದಾಹತ ಬಗಲ ಬೈಟ. ಕಿರ್ತನೆ 110: 1 ");
INSERT INTO sle_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ದಾವಿದಜ಼ ತಿನೆ ಕರತಾ ವ್ಹೈ ಕೈನ ಕದಲ್ಪರ ಮಸ್ಸಿಹಾ ತಿನಿಜ಼ ಸಂತತಿ ಕಿಮ ಥಾವಸ ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ಯೆಸುನಿಯೊ ವಾತೊ ಖುಶಿಕ್ಹು ಐಕಾಡ್ಯಾತಾ ತೆ ಉಪದೆಶ ಸುಕರ‍್ಯೊ ಕದ್ಯಾಮ -ಶಾಸ್ತ್ರಿಯೊನಾ ಹುತಿ ಹುಶಾರ ರಹೊ ತ್ಯುನೆ ಮ್ಹೊಟಾವಣ್ಣಾ ಘಾಲ್ಲಿನ ಫರಾನು ವಾನಿಯಾ, ರಸ್ತಾವೊಪರ ಮರಯಾದಿಕ್ಹು ನಮಸ್ಕಾರ ಕರೈಲ್ಯು ಕೈನ ಕೈಲೆತಾತಾ, ");
INSERT INTO sle_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ಸಭಾಮಂದಿರಮಾ ಖಾಸ ಜ಼ಗಾ ಖಾವಾನೆ ಪೈಲಾಸ್ಥಾನ ದಿವಾಮಾ ಇವ್ನು ಮನಸ ಘನ್ನುರ‍್ಹವಸ ");
INSERT INTO sle_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ರಾOಡಿಯೊ ಹೆಣ ಮನಕ್ಹೊನಾ ಘರಮಾ ವ್ಹಕ್ಕಕಿನ ತಿವ್ನಿ ಆಸ್ತಿ ಕಾಳ್ಳೆತಾ ಘನಿಯೆಳ ಲಕ್ಕಾ ಪ್ರಾಥನಾ ಕರಾಲಾ ಥೈನ ಇವ್ನೆ ಮ್ಹೊಟಿ ಶಿಕ್ಷಾನೆ ಗುರಿ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ಯೆಸು ಐನ ಬೊಕ್ಕಕಸನಾ ಕ್ಹಾಮೊ ಬೈಟಿನ ಮನಕ್ಹೊ ಕಾಣಿಕೆನಿ ಪೆಟಗಿಮಾ ದೊಕ್ಡಾ ಘಾಲಾನು ದೆಕಾಡ್ಯೊತೊ ಘನ್ನಾ ಸೌಕಾರ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ");
INSERT INTO sle_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ಘನ್ನು-ಘನ್ನು ಘಾಲತಾಮಾ ಯಕ್ಲಿ ರಾOಡಿ ಹೆಣ ಮನಕ್ಹ ಐನ ಬೆ ತಾಂಬಾನಾ ಬಿಲ್ಲಾ ಘಾಲಿ. ತಿನಿ ಕಿಮ್ಮತ ಯಕ್ಕ ಅಣಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ತೆಳಾಮಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ನಜಿಕ ಬಲೈನ - ದೆಕೊ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಕಾಣಿಕಿನಿ ಪೆಟ್ಕಿಮಾ ಘಾಲಲವಾಲಾವೊತಿಬಿ ಆ ರಾOಡಿ ಹೆಣ ಮನಕ್ಹ ಘಾಲಲ ಘನ್ನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ಕಿಮ ಕದ್ಯಾಮ ತ್ಯುನೊನೆ ಬಸ ಥೈನ ಉಗ್ರಲ ಘಾಲ್ಯಾಸ ;ಎ ಹೆಣ ಮನಕ್ಹ ತೆಕ್ಕಲಿ ಗರಿಬನಿ ಸ್ತಿತಿಮಾ ತಿಕನ ರ‍್ಹಯಲ ತೆಕ್ಕಲುಬಿ ಘಾಲಿಪಾಡಿಸ ಕದ್ಯೊ. ತೆ ಗರಿಬನಿ ರ‍್ಹೈತಬಿ ತಿಕನ್ನು ರ‍್ಹಯಲ ತೆಕ್ಲು ಘಾಲಿ. ");
INSERT INTO sle_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ಯೆಸು ದೆವಾಲಯ ಛೊಡಿನ ಜಾ಼ತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ತಿನೆ ಗುರು. ದೆಕ ಕೆವಾ ಮಂಗಾಳಾವೊಕ್ಹು ಭಾಂದಲ ಛೆ, ಕಿಮ ಭಾಂದ್ಯಾಸ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ಯೆಸು ಕದ್ಯೊ ಎ ಚೊ಼ಕಾ ಭಾಂದಲ ದೆಕಾಡ್ಯೊಸು? ನ್ಹ್ಯಾ ಮಂಗಾಳಾವೊಪರ ಮಂಗಾಳೊ ಉಗ್ರತೊ ನೈ; ಕ್ಹಾರು ಪಾಡಾಲಗಾಡಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ಪಾಚಲ್ತೊ ಯೆಸು ಒಲಿವ. ಕವಾನಾ ತೆಲನಾ ಝಾಡನಾ ಡೊಂಗರಪರ ದೆವಾಲಯನಾ ಕ್ಹಾಮೊ ಬೈಟಲ ಟೈಮಾ ಪೆತ್ರಾ ಯಾಕೊಬ ಯೊಹಾನನಾ ಅಂದ್ರೆಯ ಗ್ವತ್ತವಾಚಿ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ಇವ್ನೆ ಎ ಕೆಳಾಮಾ ಥಾವಸ ಕೆ? ಎ ಕ್ಹಾರು ಥಾವಾನು ವಳಕ ಸುವೈ? ಹಮೊನೆ ಕೆ ಕೈನ ಯೆಸುನೆ ಪುಚ಼ತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ - ಕುನ್ನಬಿ ತುಮೊನೆ ಮೊಸಕರಸ ಹುಶಾರಮಾ ರ‍್ಹವೊ. ದೆಕೊ ");
INSERT INTO sle_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ಘನ್ನಾ ಜ಼ನಾ ಐನ ಮಾರಾ ನಾಮಪರ -ಮಿ ಕ್ರಿಸ್ತ ವ್ಹೈ ಮಿ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಕೆಕ್ಲಾಕಿ ಜ಼ನಾವೊನೆ ಮೊಸಕರಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ಎನೈಸೊ ಯುದ್ದೊಥಾವಸ ಯುದ್ದೊನಿ ಅವಾಜ಼ ಐಕೊಸಿ ಯುದ್ದೊ ಥಾವಸ ಕೈನ ಸುದ್ದಿಯೊ ತುಮೆ ಐಕ್ತಾಮಾ ಭುಚ಼ಕೊ ನಕೊ. ತಿಮ್ಮಥಾವಾನು ಛೆ ಥೈಯುತಬಿ ತೆ ಲಾಸ್ಟನೊ ದಿನ್ನ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ಮನಕ್ಹೊನಾ ವಿರುದ್ದ ಮನಕ್ಹೊ ರಾಜ್ಯನಾ ವಿರುದ್ದ ರಾಜ್ಯ ಉಟಸ ; ವರಿ ಭುಕಂಪೊ ತ್ಯಾ-ತ್ಯಾ ಥಾವಸ ;ಬರಗಾಲ ಆವಸ ಕಷ್ಟ ತ್ರಾಸ ಶುರುಥಾವಸ ಆ ಕ್ಹಾರು ಹೆಣ ಮನಕ್ಹ ಜ಼Oತಾರಮಾ ಕೆಕ್ಲೊ ತ್ರಾಸ ಥಾವಸ ತೆಕ್ಲು ತ್ರಾಸ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ವರಿ ತುಮಾರಾ ಹುತಿ ತುಮೆ ದೆಕಿಲಿವೊ. ತುಮೊನೆ ಧರಿನ ತುಮೊನೆ ಸಭಾಮಂದಿರಮಾ ಯಳ್ದಿನ ಲಿನಜಾ಼ವಸ ತುಮೊನೆ ಮಾರಸ ಮಾರಾಹುತಿ ತುಮೊನೆ ಮ್ಹೊಟಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ರಾಜಾ಼ವೊನಾ ಕ್ಹಾಮಾ ಸಾಕ್ಷಿನಾಹುತಿ ಹುಬ್ರಾಡಸ ಇಮ್ಮ ತ್ಯುನೊನೆ ಸುವಾರ್ತೆ ಸಾಕ್ಷಿ ಥಾವಸ ");
INSERT INTO sle_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ಪೈಲಾ ಕ್ಹಾರಿ ಜ಼ನಾಂಗನೆ ಸುವಾರ್ತೆ ಕದಲ ರ‍್ಹೌ ತೆಳಾಮಾ ಲಾಸ್ಟನೊ ದಿನ್ನ ಆವಸ ");
INSERT INTO sle_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ತುಮೊನೆ ಫೈಸಲೊ ಕರಾನಿ ಜ಼ಗಾ ಧರಿಲಿನಗೈನ ದೆತಾಮಾ ಸು ಕೌ ಕೈನ ಅಗ್ದುರಜ಼ ತುಮೆ ಚಿಂತಾ ನಕೊ ಕರೊ ತೆ ಟೈಮಾ ತುಮೊನೆ ತಿಳಸಾವಾನಿಯೊ ವಾತೊಜ಼ ಬೊಲೊ ; ಬೊಲಾಲಾ ತುಮೆ ನ್ಹವೈ ತುಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾ ಬೊಲಾ ಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ಎನೈಸೊ ಮ್ಹೊಟೊ ಭೈ ನ್ಹಾನಾ ಭೈನೆ. ಬಾಪ ದಿಕ್ರಾನೆ ಮರಾನೆ ವಪ್ಸಸ. ಬಚ್ಚಾ ಜ಼ನ್ನಲ ವಾಲಾವೊಪರ ಫರಿನ ಪಡಸ ತ್ಯುನೊನೆ ಖಲಾಸ ಕರಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ವರಿ ಮಾರಾ ನಾಮಪರ ತುಮೊನೆ ಕದ್ರಾವಸ. ತಿಮ್ಮ ಥಯಲ್ಪರಬಿ ಕುನ್ನ-ಕುನ್ನ ಲಾಸ್ಟಲಕ್ಕಕಾ ತಡ್ದಿಲಿವಾಲಾನೆ ರಕ್ಷಣೆ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ಎನೈಸೊ ಹಾಳ ಕರಾನು ಹಸೈ ಯಕ್ಕ ಕೆಟ್ಟ ಸಾಮನ ದೆವಾಲಯಮಾ ನೈಸೊ ಹುಬ್ರವಾನಿ ಜ಼ಗಾ ಹುಬ್ರಯಲ ತುಮೆ ದೆಕಾನಾ ಟೈಮಾ (ಎ ಒದಾಲೊ ತಿಳದಿಲಿವಾದೆ). ಯುದಾಯಮಾ ರ‍್ಹಯಲ ಡೊಂಗರಪರ ನ್ಹಾಟಿ ಜಾ಼ವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ಘರನಾ ಉಪ್ಪರ ರ‍್ಹಯಲ ವಾಲೊ ತಿನಾ ಘರಮಾ ಹೆಟೊ ಉತ್ರಿನ ಮ್ಹೈ ಜೌ಼ ನೈಸೊ ತಿನಾ ಘರಮಾ ಮ್ಹೈ ಗೈನ ಸುಜ಼ ಲಿಂಜೌ ನೈಸೊ, ");
INSERT INTO sle_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ಖೆತರಮಾ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲೊ ತಿನೆ ವಳ್ಳಿವಾನೆ ಜಾಡಿನಾ ಹುತಿ ಘರೆ ಜೌ಼ ನೈಸೊ, ");
INSERT INTO sle_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ವರಿ ತೆ ದಿನೊಮಾ ಪೆಟೆರ‍್ಹಯಲವಾಲಿಯೊನೆ ಧೈಧಾವಾಲಾ ಬಚ್ಚಾವೊನೆ ಯಾವೊನೆ ತ್ಯುನೊನೆ ಥಾವಾನೊ ಕಷ್ಟ ಮಿ ಸು ಕೌ. ");
INSERT INTO sle_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ತೆ ದಿನೊಮಾ ಸಂಕಟನಾ ದಿನೊ ರ‍್ಹಯಲ ಹುತಿ ಎ ಕ್ಹಾರು ಥಂಡನಾ ದಿನಮಾ ವರಿ ಪಾನಿನಾದಿನಮಾ ಥೌನೈ ಕೈನ ತುಮೆ ಪ್ರಾಥನಾ ಕರೊ ; ");
INSERT INTO sle_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ತೆವು ಸಂಕಟ ಕ್ಹುದಾನಿ ಸೃಷ್ಟಿನಾ ದಿನೊತಿಬಿ ಹಜು಼ನಲಕ್ಕಕಾಬಿ ತೆವಾ ದಿನೊ ಆಯಾ ನತ್ತಿ. ಹವಾ ಕೆಟ ದಿನೊ ಕ್ಹುದಾ ಕರಲ ಸೃಷ್ಟಿತೊಬಿ ದಿನೊತಿಬಿ ಆಜ಼ಲಕ್ಕಾ ಥಯಾನತ್ತಿ ಅಗಾ ಥಾತಾ ನೈ ");
INSERT INTO sle_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ತೆನೈಸೊ ಕ್ಹುದಾ ತೆ ದಿನೊ ಕಮ ನೈ ಕರಲ ರ‍್ಹವತ್ತೊ ಕುನ್ನಜ಼ ಉಗರತು ನೈ ತೆ ಇನಿಲಿದಲವಾಲಾವೊನಾ ಹುತಿ ತೆ ದಿನೊ ಕಮ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ದೆಕೊ ಕುನ್ನಬಿ ತುಮೊನೆ - ಮಸ್ಸಿಹಾ ನ್ಯಾಛೆ ದೆಕೊ ಮಸ್ಸಿಹಾ ತ್ಯಾ ಛೆ ಕೈನ ಕದ್ಯಾಮ ನಂಬೊನಕೊ ; ");
INSERT INTO sle_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ಸುಳ್ಳ ಮಸ್ಸಿಹಾ ವರಿ ಸುಳ್ಳ ಪ್ರವಾದಿಯೊ ಉಟಿನ. ಸಾದ್ಯಥಯೊಮ ಕ್ಹುದಾ ಇನಿಲಿದಲವಾಲಾವೊನೆ ಮೊಸಕರಾಹುತಿ ಘಾಬ್ರಾಥಾವಾನು ಕಾಮ ಅದ್ಭುತ ಕಾಮ ಕರಿನ ದೆಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ತುಮೆ ಹುಶಾರ ರ‍್ಹವೊ;ತುಮೊನೆ ಕ್ಹಾರುಜ಼ ಅಗು ಕೈಪಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ಎನೈಸೊ ಸಂಕಟನಾ ದಿನೊ ಥಯಲ್ಪರ ಸುರ್ಯೊ ಕಾಳೊ ಥೈಝಾವಸ ;ಚ಼ಂದಪ್ಪಾ ಉಜಾಲು ದಿದ್ಯಾವಾಚಿ ರ‍್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ಚಿಕ್ಕಿಯೊ ಹಬಾಳಮಾತಿಯೊ ಪಡಸ; ಹಬಾಳಮಾ ರ‍್ಹಯಲ ಶಕ್ತಿಯೊ ಹಲ್ಲಸ ; ");
INSERT INTO sle_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ತೆಳಾಮಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಘನ್ನಿ ತಾಕತಕ್ಹು ಘನ್ನಿ ಮಹಿಮಾಕ್ಹು ಹಬಾಳಮಾತೊ ಆವಾನು ದಿಕ್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ವರಿ ತೆ ತಿನಾ ದುತೊನೆ ಜಿಮಿನ್ಪರ ಕ್ಹಾರಿಬಗಲ ಮೊಕ್ಲಿನ ತೆ ಇನಿಲಿದಲ ವಾಲಾವೊನೆ ಮಳೈನಿ ವರಿ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಮಳಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ಉOಬ್ರೊನು ಝಾಡನಿ ದ್ರಷ್ಟಾಂತಕ್ಹು ಗ್ಯಾನ ಸಿಕ್ಕೊ ತಿನಿಯೊ ಠೊಂಗಿಯೊ ಹಜು಼ನ ಕುಳಿಯೊ ರ‍್ಹಯಲ ಹುತಿ ಪಾಲೊ ಛೊಡತಾಮಾ ತಡಕಾನೊ ದಿನ್ನ ನಜಿಕ ಆಯೊಸ ಕೈನ ತಿಳದಿಲಿವೊಸಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ತಿಮ್ಮಜ಼ ಎ ಕ್ಹಾರು ಥಾವಾನು ತುಮೆ ದೆಕ್ತಾಮಾ ತೆ ಟೈಮ ನಜಿಕ ಛೆ, ಬಾಕಲಮಾಜ಼ ಛೆ ಕೈನ ತಿಳದೊ. ");
INSERT INTO sle_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ಶೆ ಮ್ಹೆಲ್ಲಿವೊ ಎ ಕಾಲನಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ಎಕ್ಹಾರು ಕ್ಹರಿಮಾಜ಼ ಥಾಯೆಲಕ್ಕಾ ಮರತಾಜ಼ ನೈ. ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ಜಿಮಿನ ಹಬಾಳ ನೈಸೊ ಥೈ ಜಾ಼ವಸ. ವರಿ ಮಾರಿಯೊ ವಾತೊ ಕೆಳಾಮಾಜ಼ ನುಚಾ಼ಯಿಜಾ಼ತಿಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ತೆ ದಿನೊನಾ ಹುತಿ ವರಿ ತೆ ಟೈಮನಾ ಹುತಿ ಕೆಳಾಮಾ ಆವಸ ಕೈನ ಸ್ವರ್ಗಲೊಕಮಾ ರ‍್ಹಯಲ ದುತೊನೆಬಿ ಗೊತ್ತನತ್ತಿ ದಿಕ್ರಾನೆಬಿ ಗೊತ್ತನತ್ತಿ ಮಾರಾ ಬಾನೆ ಯಕ್ಕಜ಼ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ಹುಶಾರ ರ‍್ಹವೊ ಕೈದಿನ ರ‍್ಹವೊ ತೆ ಕಾಲ ಕೆಳಾಮಾ ಆವಸ ತುಮೊನೆ ಗೊತ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ಎ ಕಿಮ ವ್ಹೈ ಕದ್ಯಾಮ ಯಕ್ಲೊ ಮನಕ್ಹ ತಿನು ಘರ ಛೊಡಿನ ಬಿಜಾ಼ ದೆಶೆ ಜಾ಼ತಾಮಾ ಘರ್ನಿ ಜವಾಬ್ದಾರಿ ತಿನಾ ಆಳೊನಾ ಹತ್ಮಾ ದಿನ್ನ ಜಾ಼ತಾಮಾ ಯಕೆಕ್ಕಲಾನೆ ತಿನಾ ಕಾಮನಿ ಜವಾಬ್ದಾರಿ ನೆಮ್ಸಿನ ಬಾಕಲ ಕೈದಾಲಾನೆ ಬಲೈನ - ತು ಇವ್ನೊಪರ ತಾರಿ ನಜ಼ರ ರ‍್ಹವಾದೆ ಕೈನ ಮಿ ತುನೆ ಆಗನ್ಯೆ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ಘರನೊ ಮಾಲಕ ಕ್ಹಾಂಜ಼ನಾ ಟೈಮಾ ಅರದಿ ರಾತ ನಾಟೈಮಾ ನೈತೊ ಪಾಟ ಥಾವಾತಿ ಅಗ್ದುರ ನೈತೊ ಸುರ್ಯೊ ಉಟಲಪರ ಪಾಟನಾ ಟೈಮಾ ಘರನೊ ಮಾಲಕ ಆವಾನು ತುಮೊನೆ ಗೊತನೈ ರ‍್ಹಯಲ ಹುತಿ ಹುಶಾರಮಾ ರ‍್ಹವೊ; ");
INSERT INTO sle_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ತೆ ಯಕಾಕಿಜ಼ ಐನ ತುಮೆ ಕ್ಹುರೈ ಪಡ್ಯಾಸ ಕೈನ ದೆಕಾನೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ಮಿ ತುಮೊನೆ ಕದಲಜ಼ ಕ್ಹಾರಾವೊನೆ ಕೌಸ, ಹುಶಾರ ಥೈನ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ಪಸ್ಕಾನೊ ಸನ್ನ ವರಿ ಖಾಟು ನೈಸೊ ರೊಕ್ಲಾನೊ ಸನ್ನ ಆವಾನೊ ಹಜು಼ನ ಬೆ ದಿನ್ನ ರ‍್ಹತಾಮಾ ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ಯೆಸುನೆ ಉಪಾಯಕ್ಹು ಕಿನೆ ಗೊತ್ತವಾಚಿ ಧರಿನ ಖಲಾಸ ಕರಿಪಾಡಿಯೆ ಕೈನ ವಾಟ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ಕಾಕದ್ಯಾಮ - ಸನ್ನಮಾ ಧರುನೈ ಕೈನ, ಅಪ್ನಾ ಮನಕ್ಹೊಮಾ ಗದ್ದಲ ಥಾವಸ ಕೈನ ತ್ಯುನೆ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ತೆ ಬೆಥಾನ್ಯಮಾ ಯಕ್ಕ ಕಾಲಮಾ ಮ್ಹೊಟೊ ಕುಷ್ಟರೊಗಿ ಥಯಲ ಸಿಮೊನನಾ ಘರಮಾ ಯೆಸು ಖಾವಾನೆ ಬೈಟಲ ಟೈಮಮಾ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ಘನ್ನು ಮೊಗಾನು ಬಾಸನು ತೆಲನಿ ಭರಣಿ ಲೈನ ತೆ ಖುಲ್ಲಾ ಕರಿನ ಯೆಸುನಾ ಮಾತಾಪರ ರಿಚೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ತ್ಯಾ ರ‍್ಹಯಲ ದಕ್ಹಾಜ಼಼ನಾ ಸಿಟ್ಟಥೈನ - ಆ ಮೊಗು ತೆಲ ಹಾಳ ಕಾ ಕರಿ ಕೈನ ಯಕ್ನಾ ಯಕ್ಕ ಬೊಲ್ಲಿದ್ಯಾ? ");
INSERT INTO sle_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ತೆ ತೆಲ ತನಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾಮಾ ಇಕ್ಕಿನ ತೆ ದೊಕಡಾ ಗರಿಬೊನೆ ದಿವಾನೆಥಾತುತು ಕೈನ ತಿನೆ ಛಿ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ಯೆಸು ಗಪರ‍್ಹವೊ ಅನೆ ಛೊಡೊ ಅನೆ ಕಾ ತ್ರಾಸ ಕರಾಡಾಸ? ಆ ಮನೆ ಘನ್ನು ಚೊ಼ಕು ಕಾಮ ಕರಿಸ. ");
INSERT INTO sle_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ಗರಿಬೊ ಕೆಳಾಮಾಬಿ ತುಮೊಕನಜ಼ ರ‍್ಹವಸ ;ತುಮೊನೆ ಮನಸ ಆಯಲಟೈಮಾ ತ್ಯುನೊನೆ ಆಸ್ರೊ ಕರೊಶಿ ಮಿ ಹಮೆಶಾ ತಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹತೊನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ಆ ಹೆಣ ಮನಕ್ಹ ತಿನಾ ಹತೆ ಥಯಲ ತೆಕ್ಲು ಕರಿಸ ಆ ಹೆಣ ಮನಕ್ಹ ಮಿ ಮರಾತಿ ಅಗ್ದುರಜ಼ ಮಾರಾ ಅOಗ ಪರ ತೆಲ ಘಾಲಿಸ. ");
INSERT INTO sle_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ ಸುವಾರ್ತೆ ಕ್ಹಾರಿ ದುನಿಯಾಮಾ ಕಿಜ್ಗಾ಼-ಕಿಜ್ಗಾ಼ ಕವಸ ಆ ಹೆಣ ಮನಕ್ಹ ಕರಲ ಅನಿ ಶೆನಾ ಹುತಿ ತ್ಯಾ-ತ್ಯಾ ಕವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ತೆ ಥಯಲ್ಪರ ಬಾರಾ ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ಇಸ್ಕರಿಯುತ ಯುದ ಯೆಸುನೆ ಖಾಸ ಯಾಜಕೊಕನ ಧರೈನ ದ್ಯುಸ ಕೈನ ತ್ಯುನೊಕನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ತ್ಯುನೆ ತೆ ವಾತ ಐಕಿನ ಖುಶಿ ಥೈನ - ತುನೆ ದೊಕಡಾ ದಿಯೆಸ ಕೈನ ವಾತ ದಿದ್ಯಾ. ಇಸ್ಕರಿಯುತ ಯುದ ಯೆಸುನೆ ಧರೈನ ದಿವಾನೊ ಚೊ಼ಕೊ ಟೈಮ ದೆಕಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ಖಾಟೊ ನೈಸೊ ರೊಕ್ಲಾನೊ ಪಸ್ಟಲ್ಯಾ ದಿನಮಾ ಪಸ್ಕ ಸನ್ನಾ ದಿನಮಾ ಬಕ್ರಾನಾ ಬಚ್ಚಾ಼ನೆ ಕಾಟಾನಾ ದಿನಮಾ,ತಿನಾ ಶಿಷ್ಯಾ- ಯೆಸುಕನ ಐನ ತುನೆ ಪಸ್ಕ ಸನ್ನನು ಖಾವಾನೆ ಹಮೆ ಕಿಜಾ಼ ಗೈನ ತಯ್ಯಾರ ಕರಿಯೆ ಕೈನ ತಿನೆ ಪುಚ಼ತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆ ಜ಼ನಾವೊನೆ ಬಲೈನ ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ - ತುಮೆ ಗಾಮ್ಮಾ ಜಾವೊ ತ್ಯಾ ಯಕ್ಲೊ ಮನಕ್ಹ ಭರಲಪಾನಿನೊ ಘಡೊಲಿನ ತುಮಾರಾ ಕ್ಹಾಮೊ ಆವಸ ;ತುಮೆ ತಿನಾ ಪಾಚಾ಼ ಜಾ಼ವೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ತೆ ಕಯಾ ಘರೆ ಜಾ಼ವಸ ತೆ ಘರನಾ ಮಾಲಕನೆ - ಹಮಾರೊ ಭೊದಕ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಪಸ್ಕಾ ಸನ್ನನು ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ಅನ್ನ ಘಾಲಾನಿ ಜ಼ಗಾ ಕಿಜ್ಗಾ಼ ಶೆ ಕೈನ ಪುಚಾ಼ಡ್ಯೊಸ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ತೆ ಚಾ಼ಯೆಥಯಲ ಸಾಮನ ತಯ್ಯಾರ ಕರಿನ ಮ್ಹೊಟು ರ‍್ಹಯಲ ಮ್ಹಾಡಿಪರ ರ‍್ಹಯಲ ಖೊಲಿ ತುಮೊನೆ ದೆಕಾಡಸ ; ತ್ಯಾ ಆಪೊನೆ ತಯ್ಯಾರ ಕರೊ ಕೈನ ತ್ಯುನೊನೆ ವಳೈಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ತಿನಾ ಶಿಷ್ಯಾ ತ್ಯಾಂತಾ ಗಾಮ್ಮಾ ಗೈನ ಯೆಸು ಕದಲತಿಮ್ಮ ತಯ್ಯಾರ ರ‍್ಹಯಲ ದೆಕಿನ ತ್ಯುನೆ ಪಸ್ಕ ಅನ್ನ ತಯ್ಯಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ಕ್ಹಾಂಜ ಥಾತಾಮಾ ಯೆಸು ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಆಯೊ ");
INSERT INTO sle_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ತ್ಯುನೆ ಬೈಟಿನ ಖಾತಾಮಾ ಯೆಸು - ತುಮೊಮಾನೊ ಯಕ್ಲೊ ಮನೆ ಧರೈನ ದಿವಸ, ತೆ ಮಾರಾ ಕ್ಹಾತೆ ಖಾವಾಲೊಜ಼ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ತೆಳಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ದುಖಿಥೈನ - ತೆಳಾಮಾ ತ್ಯುನೆ ಮಿ ನ್ಹವೈತೊ? ಮಿ ನ್ಹವೈತೊ? ಕೈನ ತಿನೆ ಕೈಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ಯೆಸು ತ್ಯುನೊನೆ - ತೆ ಮಾರಾ ಬಾರಾಜ಼ನಾವೊಮಾನೊ ಯಕ್ಲೊ ವ್ಹೈ ಮಾರಾ ಕ್ಹಾತೆ ತಿನೊ ರೊಕ್ಲೊ ಡುಬೈನ ಖಾವಾಲೊ ವ್ಹೈ, ");
INSERT INTO sle_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಗೈ ಪಡಸ ಕ್ಹರಿ ; ತಿನಾ ಹುತಿ ಪವಿತ್ರ ಗ್ರOಥಮಾ ಬರ್ದಲ ಛೆ ವರಿ ತೆ ಮರುಜ಼. ತೆ ವರಿ ಕಯೊಬಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಧರೈನ ದಿವಾಲಾನಿ ಗತಿ ಮಿ ಸು ಕೌ. ತೆ ಮನಕ್ಹ ನೈ ಹುಟ್ಟತ್ತೊ ತಿನೆ ಕೆಕ್ಲುಕಿ ಚೊ಼ಕು ಥಾತುತು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ತ್ಯುನೆ ಖಾವಾನೆ ಬೈಟತಾಮಾ ಯೆಸು ರೊಕ್ಲಾನೊ ತುಕಡೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ಶಿಷ್ಯಾವೊನೆ ಭಾಗಿನ ದಿನ್ನ ಆ ಮಾರು ಅಂಗ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ತೆಳಾಮಾ ಯಕ್ಕ ತಾಂಬಿಯೊ ಲಿನ ಸ್ತೊತ್ರಾ ಕರಿನ ಶಿಷ್ಯಾವೊನೆ ದಿದ್ಯೊ ತ್ಯುನೆ ತೆಕ್ಲಾ ಜ಼ನಾ ತಿಮಾ ಪಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ವರಿ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ -ಆ ಮಾರು ರಗ್ತ ವ್ಹೈ, ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ಕ್ಹಾತೆ ವಾತದಿದಲ ರಗತ ವ್ಹೈ ಆ ಘನ್ನಾ ಜ಼ನಾವೊನಾ ಹುತಿ ಚುವಾಯಲ ರಗ್ತ ವ್ಹೈ, ");
INSERT INTO sle_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ನೌ ದ್ರಾಕ್ಷಿಯೊನು ವೈನ(ರಖ) ಪಿಯೆಲಕ್ಕಾ ಆ ದ್ರಾಕ್ಷಿಯೊನು ವೈನ (ರಕ್ಹ) ಪಿತೊಜ಼ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಸ್ತೊತ್ರ ಕತಾ ಗಿದ್ದೊ ಕತಾ ತೆಲನಾ ಝಾಡನಾ ಡೊಂಗರಪರ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ತೆಳಮಾ ಯೆಸು ತ್ಯುನೊನೆ - ತುಮೆ ಕ್ಹಾರಾ ಮನೆ ಛೊಡಿನ ನ್ಹಾಟಿ ಜಾವೊಸಿ. ಕಾಕದ್ಯಾಮ ಕುರುಬುರ‍್ಯಾನೆ ಕ್ಹುದಾ ಖಲಾಸ ಕರಸ, ಬಕ್ರಾ ಜವೈಜಾ಼ವಸ ಕೈನ ಪವಿತ್ರ ಗ್ರOಥಮಾ ಬರ್ದಲ ಛೆ ತೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ಇಮ್ಮ ಥಯೊತಬಿ ಮಿ ಜುತೊ ಥೈನ ಉಟಿನ ಆಯಲಪರ ತುಮಾರಾತಿ ಅಗ್ದುರ ಗಲಿಲಾಯನೆ ಜೌ಼ಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ಪೆತ್ರಾ ಯೆಸುನೆ - ಕ್ಹಾರಾ ತುನೆ ಛೊಡಿನ ಗಯಾತಬಿ ಮಿ ತುನೆ ಛೊಡಿನ ಜಾ಼ತೊನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ಯೆಸು. ಪೆತ್ರಾನೆ \"ತುನೆ ಕ್ಹರಿಜ಼ ಕೌಸ, ಆಜ಼ನಾ ರಾತೆಜ಼ ಕುಕಡೊ ಬೆ ಸಲಾ ಬಾಂಗದಿವಾತಿ(ಅಡ್ಡಾತಿ) ಅಗ್ದುರಜ಼ ತು ಮಾರಾ ಹುತಿ ಮನೆ ಗೊತನತ್ತಿ ಕೈನ ತನ ಸಲಾ ಕಸಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ತೆ ವಾತೆ ಪೆತ್ರಾ ಥಯುತಬಿ ತಾರಾ ಕ್ಹಾತೆ ಮರ‍್ಯೊತಬಿ ಕೆಳಾಮಾಜ಼ ತು ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ಕತೊಜ಼ ನೈ ಕದ್ಯೊ. ತಿನಾ ಲಿಂಗತಜ಼ ಉಗ್ರಲ ಶಿಷ್ಯಾಬಿ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ ಗೆತ್ಸೆಮನೆ ಕವಾನಾ ಮಳಾಮಾ ಆಯಾ. ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ನ್ಹ್ಯಾ ಬೈಟೊ ಮಿ ಪ್ರಾಥನಾ ಕರಿನ ");
INSERT INTO sle_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ಔಸ ಕೈನ ಪೆತ್ರಾ ಯಾಕೊಬ ಯೊಹಾನನೆ ತಿನಾ ಕ್ಹಾತೆ ಬಲೈ ಲಿಂಗೈನ ಮನಸೆ ಬೆಜ್ಜಾರ ಕರಲಿನ. ");
INSERT INTO sle_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ತೆ ತ್ಯುನೊನೆ ಕದ್ಯೊ ಮಾರಾ ಮನಸ್ಮಾ ಘನ್ನು ದುಖ ಛೆ ತೆ ಮನೆ ಮಾರು ಮನಸ ಫುಟಿ ಜಾ಼ವಾ ಲಿಂಗತ ಥಯುಸ ತುಮೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹೈನ ಹುಶಾರ ರ‍್ಹವೊ ");
INSERT INTO sle_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ತೆ ದಕ್ಹೊ ದುರ ಗೈನ ಜಿಮಿನ್ಪರ ಪಡಿನ ಪ್ರಾಥನಾ ಕರತೊ ಸಾದ್ಯ ಥಯೊಮ ಮಿ ಮರಾನಿ ಸ್ತಿತಿಮಾತೊ ವರಿ ಆ ಕಷ್ಟನಾ ಟೈಮಮಾತೊ ಮನೆ ಛೊಡಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ತೆ ಪ್ರಾಥನಾ ಕರತೊ ಬಾ ಮಾರಾ ಬಾ. ತುನೆ ಕ್ಹಾರು ಸಾದ್ಯ ಛೆ. ಆ ತ್ರಾಸ್ನೊ ತಾಂಬಿಯೊ ಮಕ್ಹು ದುರ ಕರ ವರಿ ಮಾರಿ ಚಿ಼ತ್ತಲಿಂಗತ ಥೌ ನೈಸೊ ತಾರಿ ಚಿ಼ತ್ತಲಿಂಗತ ಥಾವಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ಯೆಸು ವರಿ ಐನ ತಿನಾ ತನ್ನೆ ಶಿಷ್ಯಾ ಕ್ಹುರಯಲ ದೆಕಿನ ಪೆತ್ರಾನೆ ಕದ್ಯೊ ಸಿಮೊನನ ತುಮೆ, ಕ್ಹುರೈ ಪಡ್ಯಾಸು? ಯಕ್ಕ ತಾಸ ತುಮೆ ಜಾ಼ಗಾ ರ‍್ಹತಾ ನೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ. ಶೊಧನೆಮಾ ಪಡೆನೈಸೊ ಹುಶಾರ ರ‍್ಹೈನ ಪ್ರಾಥನಾ ಕರೊ; ಆತ್ಮಾ ತಯ್ಯಾರ ಛೆ ಕ್ಹರಿ ವರಿ ;ಅOಗಮಾ ತಾಕತ ನತ್ತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ತೆ ಥಯಲ್ಪರ ವರಿ ಯೆಸು ದುರ ಗೈನ ಫರಿನ ತೆಜ಼ ವಾತೊ ಕತೊ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ಯೆಸು ಫರಿನ ಆತಾಮಾ ಶಿಷ್ಯಾ ವರಿ ಕ್ಹುರಯಲ ದೆಕ್ಯೊ ; ತ್ಯುನಾ ಡೊಳಾ ಖೊಲಾನೆ ಥಾವಾಡ್ಯು ನ್ಹೊತು ವರಿ ತ್ಯುನೆ ಯೆಸುನೆ ಸು ಕೌ ಕೈನ ತಿಳದ್ಯುನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ತೆ ತನವಾ ಸಲಾ ಗೈನ ಆತಾಮಾ ತ್ಯುನೊನೆ ಯೆಸು ಕದ್ಯೊ - ತುಮೆ ಹಜು಼ನ ಅರಾಮ ಕ್ಹುರಯಾಸ ಸು ; ಬಸ; ತೆ ಟೈಮ ಆಯೊ ದೆಕೊ ಪಾಪಿಯೊನಾ ಅದಿಕಾರಮಾ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಧರೈದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ಉಟೊ ಅಪೆ ಗಯ್ಯೆ; ಮನೆ ಧರೈನ ದಿವಾಲೊ ನಜಿ಼ಕಾಯೊಸ ದೆಕೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ತೆ ಹಜು಼ನ ತೆ ಬೊಲ್ತೊರ‍್ಹತಾಮಾಜ಼ ಬಾರಾ ಜ಼ನಾ ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ಯುದ ಆಯೊ ತಿನಾ ಕ್ಹಾತೆ ಮನಕ್ಹೊನು ಗುಂಪ ತ್ಯುನಾ ಹತೊಮಾ ಚಾ಼ಕಾ ಛ್ಯುರಿಯೊ ಧರ್ಲಿನ ಆಯಾ. ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ತಿವನೊನೆ ವಳಾಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ಎನೈಸೊ ತಿನೆ ಧರೈನ ದಿವಾಲೊ ತ್ಯುನೊನೆ ಮಿ ಕಿನೆ ಮಯಾಕರಿನ ಮಟ್ಟಿಲ್ಯುಸ ತೆಜ಼ ಯೆಸು ವ್ಹೈ ತಿನೆಜ಼ ತುಮೆ ಧರ್ಲಿನ ಭಾಂದಿನ ಹುಶಾರಕ್ಹು ಕೈದಾತಾ ಬಲೈನ ಲಿನಜಾ಼ವೊ ಇಮ್ಮ ಪೈಲಾಜ಼ ಕದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ತ್ಯಾ ಆಯಲ ಬರೊಬ್ಬರ ತೆ ಯೆಸುಕನ ಯುದ ಐನ ಗುರು ಕೈನ ಮಟ್ಟಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ತ್ಯುನೆ ಐನ ಯೆಸುನೆ ಘಟ್ಟ ಭಾಂದಿನ ಧರಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ವರಿ ಯೆಸುಕನ ನಜಿ಼ಕಮಾ ಹುಬ್ರಯಲವಾಲಾವೊಮಾನೊ ಯಕ್ಲೊ ತಿನು ತಲ್ವಾರ ಕಾಡಿನ ಖಾಸ ಯಾಜಕನಾ ಆಳನೊ ಕಾನ ಕತ್ರಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ತ್ಯುನೆ ಯೆಸುನೆ ಧರ್ತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಮಿ ಸು ಚ್ವಟ್ಟೊ ವ್ಹೈ ತುಮೆ ಚಾ಼ಕಾ ಛ್ಯುರಿಯೊ ಲಾಯಾಸು? ");
INSERT INTO sle_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ಮಿ ದಿನ್ನೆಬಿ ದೆವಾಲಯಮಾ ತುಮಾರಾ ಕ್ಹಾಮೊ ಭೊದನೆ ಕರತಾಮಾ ಮನೆ ತುಮೆ ಧರಯಾನೈ. ವರಿ ಗ್ರಂಥನಾ ವಚನೊಮಾ ರ‍್ಹಯಲ ಪುರಾ ಥಾವಾಹುತಿ ಎ ಕ್ಹಾರು ಥಯುಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ತೆಳಾಮಾ ತಿನಾ ಕ್ಹಾರಾಶಿಷ್ಯಾ ತಿನೆ ಛೊಡಿನ ನ್ಹಾಟಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ತ್ಯಾ ಯಕ್ಲೊ ಜಾಂಜಿಮಾನ ಅಂಗಪರ ಶಾಲ ಘಾಲ್ಲಿನ ಯೆಸುನಾ ಪಾಚೊ಼ ಆವಾಡ್ಯೊತೊ ತ್ಯುನೆ ತಿನೆ ದೆಕಿನ ಧರಾನೆ ಆತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ತೆ ವಣ್ಣಾ ಛೊಡಿನ ತೆ ಉಗಾಡೊ ನ್ಹಾಟಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ತೆಕ್ಲಾಮಾಜ಼಼ ತ್ಯುನೆ ಯೆಸುನೆ ಲಿನ ಮಾಹಾಯಾಜಕನಾ ಘರೆ ಗಯಾ. ತಿಕನ ತೆ ಘರಮಾ ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಇವ್ನೆ ಕ್ಹಾರಾ ಮಳ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ವರಿ ಪೆತ್ರಾ ದುರತೊ ತಿವ್ನಾ ಪಾಚೊ಼-ಪಾಚೊ಼ ಗೈನ ಖಾಸ ಯಾಜಕನಾ ಘರನಾ ಅಂಗಳಾಮಾ ಆಯಾ ಸಿಪಾಯಿಯೊನಾ ಕ್ಹಾತೆ ಆಗಕನ ಬೈಟಿನ ಅಂಗ ಶೆಕಿಲಿವಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ತೆಳಾಮಾ ಖಾಸ ಯಾಜಕೊ ಸಭೆಮಾ ಮ್ಹೊಟಾ ರ‍್ಹಯಲ ವಾಲಾ ಯೆಸುನೆ ಖಲಾಸ ಕರುಕೈನ ಸಾಕ್ಷಿ ಹುಡಕ್ಯಾ. ವರಿ ತ್ಯುನೊನೆ ಕಯುಜ಼ ತಪ್ಪ ಕ್ಹಾಪಡ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ಘನ್ನಾ ಜ಼ನಾ ಐನ ಯೆಸುಪರ ಸುಳ್ಳಸಾಕ್ಕಷಿ ಕದ್ಯಾ. ತೆ ಸುಳ್ಳ ಸಾಕ್ಕಷಿಯೊ ಕ್ಹರಿ ಥಯ್ಯೊನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ತೆಳಮಾ ತಿಪರ ದಕ್ಹಾ ಜ಼ನಾ ಸುಳ್ಳ ಸಾಕ್ಕಷಿಯೊ ಕವಾನೆ ಹುಬ್ರಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ಎ ಕದ್ಯೊ. ಮನಕ್ಹೊ ಹತೆ ಭಾಂದಲ ದೆವಾಲಯ ಮಿ ಪಾಡಿನ ವರಿ ತನ ದಿನ್ನ ಥಯಲ್ಪರ ಮನಕ್ಹೊ ನೈ ಭಾಂದಲ ಮಿ ಭಾಂದುಸ ಎ ಕದ್ಯೊತೊ ಹಮೆ ಐಕ್ಯಾಸ ತ್ಯುನೆ ತಿಪರ ಸುಳ್ಳ ಸಾಕ್ಷಿ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ತಿಮ್ಮ ಕದ್ಯಾತಬಿ ತ್ಯುನಿ ಸಾಕ್ಷಿ ಹೊಂದಾಣಕಿ ಥೈ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ತೆಳಾಮಾ ಖಾಸ ಯಾಜಕ ವಚ಼ಮಾ ಉಟಿನ ಹುಬ್ರೈನ - ತು ಸುಜ಼ ಜವಾಬ ದೆತೊನೈ ಸು? ಇವ್ನೆ ತುಪರ ತಪ್ಪ ಚ಼ಡಾವಾನು ಸುವೈ? ಯೆಸುನೆ ಪ್ರಶ್ನೆ ಪುಚ಼ತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ವರಿ ತೆ ಗಪರ‍್ಹೈನ ಸುಜ಼ ಕದ್ಯೊ ನೈ. ಫರಿನ ಖಾಸ ಯಾಜಕ - ಮಸ್ಸಿಹಾ ತುಜ಼಼ ವ್ಹೈಸು? ಸ್ತೊತ್ರಾನೆ ಯೊಗ್ಯ ಥಯಲವಾಲನೊ ದಿಕ್ರೊ ತುಜ಼಼ ವ್ಹೆಸು? ");
INSERT INTO sle_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ಕೈನ ತಿನೆ ಪುಚ಼ತಾಮಾ ಯೆಸು ಹೊ ಮಿಜ಼ ವ್ಹೈ, ಎನೈಸೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸರವಶಕ್ಕತನಾ ಬಾಜು಼ಮಾ ಬೈಟಾನೊ. ವರಿ ಕ್ಹುದಾ ರ‍್ಹಯಲ ಸ್ವರ್ಗಮಾತೊ ಉಜಾಲಾನಾ ಕ್ಹಾತೆ ತೆ ಆವಾನು ತುಮೆ ದೆಕೊಸಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ಎ ಐಕಿನ ಖಾಸ ಯಾಜಕ ತಿನಾ ವಣ್ಣಾ ಫಾಡಿಲಿನ ಹಮ್ನಾ ಹಮೊನೆ ಇತ್ತಿ ಉಪ್ಪರ ಸಾಕ್ಷಿ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ಎ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ಕದಲ ವಾತ ತುಮೆ ಕ್ಹಾರಾ ಐಕ್ಯಾಸು ನೈ ತುಮಾರಿ ವಿಚಾರ ಸುವೈ ತ್ಯುನೆ ತಿನೆ ವಿರುದ್ದ ಥೈನ ಎ ತಪ್ಪ ಕರಲವಾಲೊ ವ್ಹೈ - ಇನೆ ಮರಾನಿ ಶಿಕ್ಷಾ ದಿಯ್ಯೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ತೆ ಥಯಲ್ಪರ ದಕ್ಹಾ ಜ಼ನಾ ಸಿಪಾಯಿಯೊ ತಿಪರ ಥುಕ್ಕಿನ ತಿನು ಮ್ಹೊಡು ಪ್ಹಡಕಾಕ್ಹು ಝಾಕಿನ ತಿನೆ ಮಾರ‍್ಯಾ ಹಮ್ನಾ ತುನೆ ಕುನ್ನ ಮಾರ‍್ಯೊ ಕೆ ಕವಾಡಾತಾ. ವರಿ ತಿನೆ ಕೈದಾಲಾ ತಿನಾ ಗಾಲೊಪರ ಮಾರತಾ ತಿವ್ನಾ ಹತೊಟಿಮಾ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ಪೆತ್ರಾ ತ್ಯಾ ಅಂಗಳಾಮಾ ರ‍್ಹತಾಮಾ ಖಾಸ ಯಾಜಕನಿ ದಾಸಿಮಾನಿ ಯಕ್ಕಲಿ ಐ. ");
INSERT INTO sle_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ತೆ ಪೆತ್ರಾ ಆಗಕ್ಹು ಅಂಗ ಶೆಕಿಲಿವಾನು ದೆಕಿನ \"ತುಬಿ ನಜ಼ರೆತನಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ವಾಲೊ ವ್ಹೈ \"ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ತೆ ಮಿ ನ್ಹವೈ ತು ಸು ಕವಾಡಿಸ ಮನೆ ಗೊತ್ತ ನತ್ತಿ ಕೈನ ತೆ ಯೆಸುನೆ ಇನ್ಕಾರ ಕರಿನ ಅಂಗಳಾ ಮಾತೊ ಭಾರೊ ಐಪಾಡ್ಯೊ. ತೆಳಾಮಾ ಕುಕಡೊ ಬಾಂಗದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ತ್ಯಾ ತೆ ದಾಸಿ ತಿನೆ ದೆಕಿನ ತ್ಯಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ತ್ಯುನೊಮಾನೊ ಎಬಿ ಯಕ್ಲೊ ವ್ಹೈ ಕತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ವರಿ ಪೆತ್ರಾ ಫರಿನ ಇನ್ಕಾರ ಕರ‍್ಯೊ ಮಿ ನ್ಹವೈ ಕದ್ಯೊ. ದಕ್ಹಿಯಳಪರ ತ್ಯಾ ಹುಬ್ರಯಲವಾಲಾ ಪೆತ್ರಾನೆ ಕ್ಹರಿಮಾಜ಼ ತು ತ್ಯುನೊಮಾನೊ ಯಕ್ಲೊ ವ್ಹೈ; ತು ಗಲಿಲಾಯವಾಲೊ ವ್ಹೈ ಕೈನ ವರಿ ಫರಿನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ವರಿ ಪೆತ್ರಾ-ತುಮೆ ಕವಾನು ಮನಕ್ಹ ಮನೆ ಗೊತ್ತ ನತ್ತಿ ಕೈನ ತಿನಾಕ್ಹು ತೆ ಕ್ಹರಾಪಿಲೆತೊ ಕ್ಹುದಾನಾ ಕ್ಹಮ ಘಾಲಾನು ಶುರುಕರ‍್ಯೊ. ತೆಕ್ಲಾಮಾಜ಼಼ ಕುಕಡೊ ಬಾಂಗ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ತೆಳಾಮಾ ಬೆ ಸಲಾ ಕುಕಡೊ ಬಾOಗ ದಿದ್ಯೊತೊ ಪೆತ್ರಾ ಐಕ್ಯೊ ಯೆಸು ತಿನೆ ಕದಲ ವಾತ ತೆ ಶೆ ಕರಿನ ಕುಕಡೊ ಬೆ ಸಲಾ ಬಾಂಗದಿವಾತಿ ಅಗ್ದುರ ತನ ಸಲಾ ಮಾರಾ ಹುತಿ ತು ಮನೆ ಗೊತ್ತ ನತ್ತಿ ಕೈನ ಕಸಿಕದಲ ತೆ ವಿಚಾರಮಾ ಉಂದಾ ಗುಡ್ಗಾ ಘಾಲ್ಲಿನ ರ‍್ವಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ಪಾಟ ಥಯಲ ಬರೊಬ್ಬರ ಖಾಸ ಯಾಜಕೊ ಗಡಬಡಮಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಶಾಸ್ತ್ರಿಯೊ ಮ್ಹೊಟಾ ಸಭೆವಾಲಾ ಯಕ್ನಾ ಯಕ್ಕ ಮಳಿನ ತ್ಯುನೆ ವಿಚಾರ ಕರಿಲಿದಲ ತಿಮ್ಮ ಪ್ರಕಾರ ಕರ‍್ಯಾ. ತ್ಯುನೆ ಯೆಸುನೆ ಬೆಡಿಯೊಕ್ಹು ಭಾಂದಿನ ಧರ್ಲಿನ ಗೈನ ಪಿಲಾತನಕನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ಪಿಲಾತನ ತಿನೆ ತು ಯಹುದ್ಯೊನೊ ರಾಜೊ಼ ವ್ಹೈ ಕೈನ ಪುಚ಼ತಾಮಾ ಯೆಸು ತುಜ಼಼ ಕದ್ಯೊತೊ ಕೈನ ಜ಼ವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ಖಾಸ ಯಾಜಕೊ ತಿಪರ ಘನ್ನಾ ಸುಳ್ಳ ತಪ್ಪ ಚ಼ಡಾವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ತಿನಾಹುತಿ ಪಿಲಾತನ ವರಿಯಕಸಲಾ ತು ಸುಜ಼ ಜವಾಬ ದೆತೊ ನೈಸು? ಇವ್ನೆ ತುಪರ ಕೆಕ್ಲಾ ಅಪವಾದ ಘಾಲಾಡ್ಯಾಸ ದೆಕ ಕವಾಡೊತೊ. ತೆಕ್ಲು ಥಯು ತಬಿ ");
INSERT INTO sle_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ಯೆಸು ಸುಜ಼ ಜವಾಬ ದಿದ್ಯೊನೈ ತೆ ದೆಕಿನ ಪಿಲಾತನ ಘನ್ನೊ ಘಾಬ್ರೊಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ಹರಿ ಯಕ್ಕ ಫಸ್ಕಾನಾ ಸನ್ಮಾ ರಾಜ್ಯಪಾಲ ಥಯಲ ಪಿಲಾತನ ಮನಕ್ಹೊ ಮಾಂಗಲ ತೆ ಕೈದಿನೆ ಛೊಡಾನಿ ಪದ್ದತ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ತೆಳಾಮಾ ಬರಬ್ಬ ಕವಾಲೊ ಯಕ್ಕ ಕೈದಿ ವ್ಹತ್ತೊ ತೆ ಲಡೈಕರಾಲಾವೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ಮನಕ್ಹೊನೆ ಖಲಾಸ ಕರ‍್ಯೊತೊ ತಿನೆ ಧರಿನ ಜೆಲಮಾ ಘಾಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ಮನಕ್ಹೊ ಪಿಲಾತನಕನ ಗೈನ ತು ಹಮಾರಾಹುತಿ ಕರತೊ ಆಯಲ ಪದ್ದತ ಕರ ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ಪಿಲಾತನ ತ್ಯುನೊನೆ ಪುಚ್ಯೊ ಮಿ ಯಹುದ್ಯನಾ ರಾಜಾ಼ನೆ ತಮಾರಾಹುತಿ ಛೊಡುಕೈನ ತುಮಾರಿ ಆಸ ಛೆ ಸು. ");
INSERT INTO sle_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ಖಾಸ ಯಾಜಕೊಮಾ ಸOಗಟ ಹೆಚ್ಕಿ ಥಯಲ ಹುತಿ ಯೆಸುನೆ ಧರಿನ ದಿದ್ಯಾತಾ ಕೈನ ಪಿಲಾತನೆ ಗೊತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ತಿತಾ ಖಾಸ ಯಾಜಕೊ - ಬರಬ್ಬನೆ ಛೊಡಕೈನ ಮನಕ್ಹೊನೆ ಪಿಲಾತನಕನ ಮಾಂಗಿಲಿವೊಕೈನ ಶಿಕ್ಕಲಾವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ತಿನಾಹುತಿ ಪಿಲಾತನ ಫರಿನ ತ್ಯುನೊನೆ - ತಿಮ್ಮ ರ‍್ಹಯುಮ ತುಮೆ ಕವಾನಾ ಯೆಹುದಿನಾ ರಾಜಾ಼ನೆ ಮಿ ಸು ಕರುಕೈನ ಪುಚ಼ತಾಮಾ ತ್ಯುನೆ ");
INSERT INTO sle_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ತಿನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ವರಿ ಆ ಸು ಕೆಟ್ಟ ಕರ‍್ಯೊಸ ಪಿಲಾತನ ಕದ್ಯೊ ವರಿ ತ್ಯುನೆ ಅನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾ ಕೈನ ವರಿ ಜೊ಼ರವದರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ತೆಳಾಮಾ ಪಿಲಾತನ ಮನಕ್ಹೊನು ಮನಸ ಸಮಾದಾನ ಕರಾಹುತಿ ಬರಬ್ಬನೆ ಛೊಡಿನ ಯೆಸುನೆ ಬಾರಕೊಲಕ್ಹು ಮಾರಖಲೈನ ಶಿಲುವಿಪರ ಚ಼ಡಾವಾನಾ ಹುತಿ ವಪ್ಸಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ಸೈನಿಕೊ ಯೆಸುನೆ ಪಿಲಾತನ ರಾಜಾ಼ನಾ ಘರ್ಮಾತಾ ಅಂಗಳಾಮಾ ಲೈನ ತ್ಯುನಾ ಬಿಜಾ಼ ಸೈನಿಕೊನೆ ಮಳೈನ ");
INSERT INTO sle_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ಯೆಸುನೆ ಘನ್ನಾ ಲಾಲ ರಾಜಾ಼ನಾ ವಣ್ಣಾ ಘಾಲಿನ ಕಾಟಾವೊನು ಕಿರಿಟ ಕರಿನ ತಿನಾ ಮಾತಾ ಪರ ಮುಕ್ಕಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ಯೆಹುದಿನಾ ರಾಜಾ಼ ತು ಘನ್ನಾ ದಿನ್ನ ಜುತೊ ರ‍್ಹೆ ಕೈನ ನಮಸ್ಕಾರ ಕರಿನ ಪಗೆ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ವರಿ ಲಾಕಡಿ ತಿನಾ ಮಾತಾಪರ ಮಾರಿನ ತಿಪರ ಥುಕ್ಕಕಿನ ತಿನಾ ಕ್ಹಾಮಾ ಉಂದಾಗುಡಗಾಘಾಲ್ಲಿನ ಡಬ್ಬ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ಇಮ್ಮ ತಿನೆ ಕದ್ರಾಯಲ್ಪರ ತಿಪರಲ್ಯಾ ಘನ್ನಾ ಲಾಲ ರಾಜಾ಼ನಾ ವಣ್ಣಾ ಕಾಡಿನ ತಿನಾ ವಣ್ಣಾತಿನೆ ಘಾಲಿನ ತಿನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾವಾನೆ ಲಿನಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ತೆಳಾಮಾ ಖೆತರನಿ ವಾಟಮಾತಾ ಜಾ಼ತಾಮಾ ತೆಜ಼ ವಾಟಮಾತೊ ಯಕ್ಕ ದಾಣಗೊ ಆವಾಡ್ಯೊತೊ ಯೆಸುನಿ ಶಿಲುವಿ ಉಚೈಲೆ ಕೈನ ತಿನೆ ಜ಼ಬರದಸ್ತಿ ಕರ‍್ಯಾ ತೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ಅಲೆಕ್ಸಾಂಡರ ವರಿ ರುಫಸನೊ ಬಾ ಥಯಲ ಸಿಮೊನ ಕವಾಲೊ ಕುರೆನ ಗಾಮವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಗೊಲ್ಗೊತಾ ಕವಾನಾ ಜ಼ಗಾಪರ ತಿನೆ ಲಿನ ಆಯಾ. ಗೊಲ್ಗೊಥಾ ಕದ್ಯಾಮ ಕಪಾಲ ಕವಾನಿ ಜ಼ಗಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ತ್ಯಾ ತಿನೆ ರಗ್ತಬೊಳ ಮಳಾಯಲ ದ್ರಾಕ್ಷಿನೊ ವೈನ(ರಖ) ದಿದ್ಯಾ. ವರಿ ತೆ ಲಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ಪಾಚಾ಼ತಾ ಯೆಸುನೆ ತ್ಯುನೆ ಶಿಲುವಿಪರ ಚ಼ಡೈನ ತಿನಾ ವಣ್ಣಾವೊನೆ ಕಿನೆ-ಕಿನೆ ಸು-ಸು ಆವಸ ಕೈನ ತ್ಯುನೆ ಚಿ಼ಟಿಯೊ ಘಾಲಿನ ವಾಟಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ಯೆಸುನೆ ಶಿಲುವಿಪರ ಘಾಲ್ತಾಮಾ ಪಾಟ್ನಾ ನೌ ವಾಜಾ಼ತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ತಿಪರ ಚ಼ಡಾಯಲ ತಪ್ಪ ಸು ವ್ಹೈ ಕದ್ಯಾಮ-ಎ ಯಹುದ್ಯನೊ ರಾಜೊ಼ ವ್ಹೈ ಕೈನ ಮಾತಾನಿ ಜ಼ಗಾ ಶಿಲುವಿಪರ ಬರ್ದಿನ ಲಗಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ಇನಾ ಕ್ಹಾತೆ ಬೆ ಜ಼ನಾ ಚೊ಼ಟ್ಟಾವೊನೆ ಲೈನ ಯಕ್ಲಾನೆ ಸಿದಾ ಬಗಲ ಯಕ್ಲಾನೆ ಡಾವಾ ಬಗಲ ತಿನಾ ಕ್ಹಾತೆ ಶಿಲುವಿಪರ ಘಾಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ದಕ್ಹಾ ಮುಲ ಪ್ರತಿಮಾ ಎ ವಚನಾ ಛೆ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ ");
INSERT INTO sle_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ತ್ಯಾಂತಾ ಜಾ಼ವಾಲಾ ಮಾತು ಹಲೈನ ಯೆಸುನೆ ದೆಕಿನ ಆಹಾ ತು ದೆವಾಲಯ ಪಾಡಿನ ತನ ದಿನಮಾ ಭಾಂದಾಲಾ, ");
INSERT INTO sle_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ಶಿಲುವಿಪರತೊ ಉತ್ರಿನ ತಾರೊ ಜ಼ಲಮ ತು ವಚಾ಼ಡಿಲೆ ಕೈನ ತಿನೆ ಹಿನಾವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ತೆಜ಼ ಟೈಮಮಾ ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ತೆ ಬಿಜಾ಼ವೊನೆ ವಚಾ಼ಡಾಲೊ ವ್ಹೈ; ತಿನೆ ತೆ ವಚಾ಼ಡಿ ಲೆತೊನೈ. ");
INSERT INTO sle_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ಇಸ್ರಾಯೆಲನೊ ರಾಜೊ಼ ಥಯಲ ಎ ಮಸ್ಸಿಹಾ ಹಮ್ನಾ ಶಿಲುವಿಪರತೊ ಉತ್ರಿನ ಆವಾದೆ. ಉತ್ರಿನ ಆಯೊಮ ಹಮೆ ಬಿ ದೆಕಿನ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ ಕೈನ ತ್ಯುನೊಮಾಜ಼ ಕದ್ರೈನ ತ್ಯುನೆ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ತಿನಾ ಕ್ಹಾತೆ ಶಿಲುವಿಪರ ರ‍್ಹಯಲವಾಲಾ ತಿನೆ ಕದ್ರಾವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ದುಪಾರನಾ ಬಾರಾ ವಾಸ್ತಾ ದೆಶಪರ ಅಂದಾರು ಥೈ ಗಯು ತೆ ಅOದಾರು ತನ ತಾಸ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ದುಪಾರೆ ತನ ವಾಸ್ತಾ ಯೆಸು ಎಲೊಹಿ-ಎಲೊಹಿ ಲಮಾ ಸಬಕ್ತಾನಿ, ತಿಮ್ಮ ಕದ್ಯಾಮ ಕ್ಹುದಾ ಮಾರಾ ಕ್ಹುದಾ ಕಾ ಮಾರೊ ಹತ ಛೊಡ್ಯೊ ಕೈನ ಜೊ಼ರ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ನಜಿಕ ಹಬ್ರಯಲ ದಕ್ಹಾ ಜ಼ನಾವೊಮಾನಾ ತೆ ಐಕಿನ ಹಮ್ನಾ ತೆ ಎಲಿಯಾನೆ ಬೊಲಾಡೊಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ತೆಳಾಮಾ ಯಕ್ಲೊ ನ್ಹಾಟಿ ಗೈನ ಸ್ಪಂಜಮಾ ಘನ್ನು ಸಸ್ತು ರ‍್ಹಯಲ ವೈನ ಭರಿನ ಲಾಕ್ಕಡಿನೆ ಭಾಂದಿನ ಯೆಸುನಾ ಹೊಟೊನೆ ಲಗಾಡ್ಯೊ. ಛೊಡೊ ಇನೆ ಶಿಲುವಿ ಪರತೊ ಉತಾರಾನೆ ಎಲಿಯಾ ಆಸ ಸು ದೆಕಿಯೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ವರಿ ಯೆಸು ಜೊ಼ರ ವದ್ರಿನ ಜ಼ಲಮ ಛೊಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ತೆಳಾಮಾ ದೆವಾಲಯಮಾ ರಹೆಲ ಪಡದೊ ಉಪ್ಪರತೊ ಹೆಟೊಲಕ್ಕಾ ಬೆ ತುಕ್ಡಾ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ತೆ ಇಮ್ಮ ಜ಼ಲಮ ಛೊಡಲ ದೆಕಿನ ತ್ಯಾ ಹುಬ್ರಯಲಮಾನಾ ಶತಾದಿಪತಿ ದೆಕಿನ ಕ್ಹರಿಮಾಜ಼ ಆ ಮನಕ್ಹ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ತ್ಯಾ ದಕ್ಹಿಯೊ ಹೆಣ ಮನಕ್ಹೊಬಿ ದುರತಿಯೊ ದೆಕಾಡಿಯೊತ್ಯೊ ತಿಮಾನಿಯೊ, ತೆ ಮಗ್ದಲನಿ ಮರಿಯಳ, ನ್ಹಾನಾ ಯಾಕೊಬ ವರಿ ಯೊಸೆಫನಿ ಯಾ ಮರಿಯಳ ವರಿ ಸಲೊಮಿ ತ್ಯಾ ವ್ಹತ್ತಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ಇವ್ನೆ ಯೆಸು ಗಲಿಲಾಯಮಾ ರ‍್ಹತಾಮಾ ಯೆಸುನಾ ಪಾಚಿ಼ಯೊ ಐನ ತಿನೆ ಮದತ ಕರಿಯೊತ್ಯೊ ವರಿ ತಿನಾ ಪಾಚಿ಼ಯೊ ಆವಾಲಿಯೊ ಘನ್ನಿಯೊ ಜನಿಯೊ ಹೆಣ ಮನಕ್ಹೊ ಯೆರುಸಲೆಮೆ ಐಯೊತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ತೆಳಾಮಾಜ಼ ಕ್ಹಾಂಜ಼ ಥೈ ಗೈತಿ ತೆಳಾಮಾ ಅರಿಮಥಾಯ ಯೊಸೆಫ ಕವಾಲೊ ತ್ಯಾ ಆಯೊ ತೆ ಯಹುದ್ಯೊನೊ ಸಭಾಪರ ಮ್ಹೊಟೊ ವ್ಹತ್ತೊ ವರಿ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಆವಾನು ತೆ ಕೈದಾಡ್ಯೊತೊ ತೆಳಾಮ ಸಬ್ಬತನೊ ಪಾಚ಼ಲ್ಯೊ ದಿನ್ನ (ವರಿ ಸನ್ನ ತಯ್ಯಾರ ಕರಾನೊ ದಿನ್ನ ವ್ಹತ್ತೊ) ಪಿಲಾತನ ರಾಜ್ಯಪಾಲಕನ ಧೈರ್ಯಕ್ಹು ಐನ ಯೆಸುನು ಮರಲ ಅಂಗ ದೆ ಕೈನ ಮಾಂಗ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ಪಿಲಾತನ ರಾಜ್ಯಪಾಲ ಯೆಸು ತೆಕ್ಕಲೊ ಭೆಗಿನ ಮರ‍್ಯೊಸು ಕೈನ ಘಾಬ್ರೊಥೈನ ಶತಾದಿಪತಿನೆ ಬಲೈನ ಯೆಸು ಭೆಗಿನ ಮರ‍್ಯೊಸು ಕೈನ ತಿನೆ ಪುಚ಼್ಚಿನ ");
INSERT INTO sle_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ಯೆಸು ಮರಲ ಶತಾದಿಪತಿಕ್ಹು ತಿಳ್ದಿನ ಮರಲ ಅಂಗ ಯೊಸೆಫನೆ ದಿಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ಯೊಸೆಫ ಘನ್ನು ಮೊಗು ಪ್ಹಡಕು ಇಕ್ಕಾತೊ ಲಾಯಲ ತಿನೆ ವಾಟಮಾ ಉತಾರಿನ ತಿಮಾ ತಿನೆ ಸುತ್ತಿನ ದಗ್ಡಾಮಾ ಕಾಡಲ ಮಜಾ಼ರಮಾ ಮುಕ್ಕಕಿನ ಮಜಾ಼ರನು ಬಾಕಲ ಮ್ಹೊಟೊ ದಗ್ಡೊ ಉಳ್ಸಿನ ಝಾಕ್ಕಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ಮಗ್ದಲನಿ ಮರಿಯಳ ಯೊಸೆಫನಿ ಯಾ ಯೆಸುನಿ ಯಾ ಮರಿಯಳ ಎ ಕ್ಹಾರು ದೆಕಾಡಿಯೊತ್ಯೊ ತಿಕ್ಹು ಯೆಸುನಿ ಮಜಾ಼ರನಿ ಜ಼ಗಾ ತ್ಯುನೊನೆ ಗೊತ್ತ ಥೈತು. ");
INSERT INTO sle_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ಸಬ್ಬತ ದಿನ್ನ ಥಯಲ್ಪರ, ಮಗ್ದಲನಿ ಮರಿಯಳ. ಯಾಕೊಬನಿ ಯಾ ಮರಿಯಳ ವರಿ ಸಲೊಮಿ ಯೆಸುನಾ ಅಂಗೆ ಲಗಾಡಾನಾ ಹುತಿ ಬಾಸನು ತೆಲ ಇಕ್ಕಾತಿಯೊ ಲಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ಐತ್ವಾರ ದಿನ್ನ ನಸ್ಕೆ ಸುರ‍್ಯೊ ಉಟ್ತಾಮಾ ತ್ಯುನೆ ಮಜಾ಼ರಕನ ಚಾ಼ಲಿಯೊತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ವಾಟಮಾ ಜಾ಼ತಾಮಾ ಮಜಾ಼ರನೆ ಝಾಕಲ ದಗ್ಡೊ ಮ್ಹೊಟೊರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೆ ದಗ್ಡೊ ಅಪ್ನಾಹುತಿ ಕುನ್ನ ಸರಕಾಸ? ಕೈನ ತ್ಯುನೊಮಾ ಬೊಲ್ಲಿವಾಡಿಯೊತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತ್ಯುನೆ ಮಾತು ಉಚೈನ ದೆಕಿನ ತೆ ದಗ್ಡೊ ಸರಕಾಯಲ ದೆಕಿನ. ");
INSERT INTO sle_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ತ್ಯುನೆ ಮಜಾ಼ರಮಾ ಗೈನ ದೆಕ್ತಾಮಾ ತ್ಯಾ ಯಕ್ಲೊ ಜಾಂಜಿಮಾನ ದಾಣಗೊ ಧೊಳಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ಶಿದಾ ಬಗಲ ಬೈಟಲ ದೆಕಿನ ತ್ಯುನೆ ಘಾಬ್ರಿಯೊ ಥಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ತೆ ತ್ಯುನೊನೆ ತುಮೆ ಘಾಬ್ರಿಯೊ ಥಾವೊ ನಕೊ ಶಿಲುವಿಪರ ಚ಼ಡಾಯಲ ನಜ಼ರೆತನಾ ಯೆಸುನೆ ಹುಡಕಾಡಿಯೊಸ ಮನೆ ಗೊತ ಛೆ ತೆ ಜಿವ್ತೊ ಥೈನ ಉಟ್ಯೊಸ; ತೆ ನ್ಹ್ಯಾ ನತ್ತಿ ತಿನೆ ಮುಕ್ಕಕಲ ಜ಼ಗಾ ಎಜ಼ ವ್ಹೈ ದೆಕೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ತುಮೆ ಗೈನ ಎ ಸುದ್ದಿ ತಿನಾ ಶಿಷ್ಯಾವೊಕನ ವರಿ ಪೆತ್ರಾನೆ ತೆ ತುಮೊನೆ ಕದಲತಿಮ್ಮ ತುಮಾರಾತಿ ಅಗೊ ಗಲಿಲಾಯನೆ ಜಾ಼ವಸ. ತ್ಯಾ ತುಮೆ ತಿನೆ ದೆಕೊಸಿ ಕೈನ ಕವೊ ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ತ್ಯುನೆ ಘಾಬ್ರಿಯೊ ಥೈನ ಭುಚ಼ಕಿನ ಕಾಪ್ತಿಯೊ ಮಝಾರಕಂತಿಯೊ ನ್ಹಾಟಿಗಯ್ಯೊ. ತ್ಯುನೆ ಭುಚ಼್ಕಲ ಹುತಿ ಕಿಕನಜ಼ ಸುಜ಼ ಕದಿಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(ಹಪ್ತಾನಾ ಪಸ್ಟಲ್ಯಾ (ಐತ್ವಾರ) ದಿನಮಾ ಪಾಟೆ ಯೆಸು ಮರಿನ ಜಿವ್ತೊ ಥೈನ ಉಟಲಪರ ಮಗ್ದಲನಿ ಮರಿಯಳನೆ ಪೈಲಾ ದಿಕ್ಹ್ಯೊ. ತೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ತಿನೆ ತೆ ಕ್ಹಾತ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ತೆ ದಿಕ್ಹಲ ಪೈಲಾ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನಾ ತಿಳಸಿ ತ್ಯುನೆ ದುಖಪಡ್ದಿನ ರೊತಾ ಬೈಟ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ತೆ ಜಿವ್ತೊ ಛೆ ಮನೆ ದಿಕ್ಹ್ಯೊಸ ಕದಲ ಐಕಿನ ತ್ಯುನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ಎ ಥಯಲ್ಪರ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆ ಜ಼ನಾ ಯಕ್ಕ ಗಾಮೆ ಚಾ಼ಲತಾ ಜಾ಼ತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ತೆ ವಳಕ ಲಾಗುನೈಸೊ ಬಿಜಾ಼ ಯಕ್ಕ ರುಪಮಾ ದಿಕ್ಹ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ತ್ಯುನೆ ಗೈನ ವರಿ ಫರಿನ ಐನ ಉಗ್ರಲವಾಲಾವೊನೆ ತಿಳಶ್ಯಾ. ವರಿಬಿ ತ್ಯುನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ಲಾಸ್ಟೆ ತ್ಯುನೆ ಗ್ಯಾರಾ ಜ಼ನಾ ಶಿಷ್ಯಾ ಖಾವಾನೆ ಬೈಟಲ ಟೈಮಮಾ ತ್ಯುನೊನೆ ತೆ ದಿಖ್ಯೊ. ತೆ ಜಿವ್ತೊ ಥೈನ ಉಟಲ ದಿಕ್ಹಲ ವಾಲಾವೊನಿ ವಾತಪರ ನೈ ಬರೊಕ್ಹೊ ಕರಲಕ್ಹು ತ್ಯುನಿ ಯಕ್ಕ ಅಪನಂಬಿಕಿಕ್ಹು ತ್ಯುನಾ ಘಟ್ಟ ಥಯಲ ಮನಸೊನೆ ಭುಚ್ಕಾ಼ಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ಪಾಚಲ್ತೊ ತೆ ತ್ಯುನೊನೆ ತುಮೆ ಗೈನ ದುನಿಯಾಮಾ ಕ್ಹಾರಿ ಜ಼ಗಾ ಕ್ಹಾರಿ ಜಾ಼ತನಾ ಮನಕ್ಹೊನೆ ಸುವಾರ್ತೆ ಸಾರೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ಕುನ್ನ ಬರೊಕ್ಹೊ ಕರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವಾಲಾನೆ ರಕ್ಷಣೆ ಮಳಸ ಬರೊಕ್ಹೊ ನೈ ಕರಲ ವಾಲಾನೆ ಶಿಕ್ಷಾನೆ ಗುರಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ಎನೈಸೊ ಬರೊಕ್ಹೊ ಕರಲ ವಾಲಾನಾ ಹತೆ ಅದ್ಭುತ ಕರಾನು ಅದಿಕಾರ ದಿವಸ; ಮಾರು ನಾಮ ಕೈನ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾವಸ ಅಜಪನಿಯೊ ವಾತೊ ಬೊಲಸ. ");
INSERT INTO sle_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ತ್ಯುನೆ ಕ್ಹಾಪೊ ಉಚಾವಸ ವರಿ ಮರಾನು ವಕ್ಹಡ ಪಿದ್ಯಾತಬಿ ಸುಜ಼ ಕೆಟ್ಟ ಥಾತು ನೈ ತ್ಯುನೆ ರೊಗಿಯೊಪರ ಹತ್ತ ಮ್ಹೆಲ್ಯಾಮ ತೆ ರೊಗಿಯೊ ಅರಾಮ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ಯೆಸು ಸ್ವಾಮಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬೊಲಲಪರ ತಿನೆ ಸ್ವರ್ಗಮಾ ಕ್ಹುದಾಲಿನ ಗೈಪಡ್ಯೊ ತೆಳಾಮಾಜ಼ ಯೆಸು ಕ್ಹುದಾನಾ ಶಿದಾ ಹತ ಬಗಲ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ಶಿಷ್ಯಾ ಕ್ಹಾರಿ ಜ಼ಗಾ ಗೈನ ತೆ ವಾತೊ ಕತಾ ಗಯಾ;ವರಿ ಕರತಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಕಾಮೊ ಅದ್ಭುತ ಕರತೊ ತಿನಾ ಹುತಿ ತ್ಯುನೆ ಕವಾನಿ ಸುವಾರ್ತೆ ಘಟ್ಟ ಕರತೊ ವ್ಹತ್ತೊ)");
INSERT INTO sle_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ಸನ್ಮಾನ್ಯ ಥೆಯೊಫಿಲನ, ಹಮಾರಾ ವಚ್ಮಾ಼ ಥಯಲ ಸಂಗತಿಯೊ ವರಿ ಚರಿತ್ರೆ ತಿಳಸಾನಾಹುತಿ ಘನ್ನಾ ಜ಼ನಾ ಕೊಶಿಶ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ಶುರುತಾಬಿ ತೆ ಸಂಗತಿಯೊ ಡೊಳೆ ದೆಕಲ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕದಲವಾಲಾವೊನಾ ಮ್ಹೊಡೆ ಹಮೆ ಐಕಲ ಸಂಗತಿಯೊ ತ್ಯುನೆ ಬರ್ದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ತಿನಾಹುತಿ ಹರಿಯಕ್ಕ ಸಂಗತಿಯೊ ಶುರುತಿಬಿ ಮಿಜ಼ ಮ್ಹೈನತ ಕರಿನ ಒದಿ ಬರ್ದಿನ ತಿಳದಿಲಿದಲ ಹುತಿ ತ್ಯುನೆ ಎ ಕ್ಹಾರು ತುನೆ ಯಕ್ಕ ಲೆವಲ (ಸಂವಾ) ತಿಳಸಾನಾ ಹುತಿ ಪುಸ್ತಕನಾ ರುಪಮಾ ಬರ್ದಿನ ಮ್ಹೆಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ತುನೆ ಕದಲ ಉಪದೆಶ ಕ್ಹರಿನಿಯೊ ವ್ಹೈ ಕೈನ ಇನಾಹುತಿ ಕ್ಕಲಿಯರ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ಯುದಾಯನೊ ರಾಜೊ಼ ಥಯಲ ಹೆರೊದನಾ ಕಾಲಮಾ ಅಭಿಯನ್ನಾ ಆರೊನನಿ ಒಸಮಾ ಮಳಲ ಜಕರಿಯಾ ಕವಾಲೊ ಯಕ್ಕ ಯಾಜಕ ವ್ಹತ್ತೊ. ತಿನಿ ಬೈಕೊ ಯಾಜಕೊನಿ ಒಸವಾಲಿ ವ್ಹತ್ತಿ. ತಿನು ನಾಮ ಎಲಿಸಬೆತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ತ್ಯುನೆ ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ಚೊ಼ಕಾ ಥೈನ ವ್ಹತ್ತಾ. ಭಂಬಿಜ಼ನಾ ಕರ್ತಾನಿಯೊ ಕ್ಹಾರಿಯೊ ಆಗನ್ಯಾ ವರಿ ನಿಯಮೊ ನಿಶ್ಠೆ ಕಾಯ್ದಿಲಿನ ತಪ್ಪ ನೈಸೊ ಕರಾಲಾ ರ‍್ಹೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ತೆನೈಸೊ ಎಲಿಸಬೆತನೆ ವರಿ ಜಕರಿಯಾನೆ ಬಚ್ಚಾ಼ನ್ಹೊತಾ; ಕಾಕದ್ಯಾಮ ಎಲಿಸಬೆತ ಗ್ವಡ್ಡ ವ್ಹತ್ತಿ. ಎನೈಸೊ ತ್ಯುನೊನೆ ಘನ್ನಿ ವೈಸ್ ಥೈತಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ಯಕ್ಕ ದಿನ್ನ ಜಕರಿಯಾನಿ ಒಸನಿ ಪಾಳಿ ಆತಾಮಾ, ತೆ ಕ್ಹುದಾನಿ ಸನ್ನಿಧಿಮಾ ಯಾಜಕ ಥೈನ ಸೆವೆ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ಕ್ಹುದಾನಿ ಸನ್ನಿಧಿಮಾ ಯಾಜಕೊ ಉದನೊ ಧವಾಂಡೊ ದಿವಾಹುತಿ ತಿವ್ನಿ ಪದ್ದತಿಲಿಂಗತ ಚಿಟಿಯೊ ಘಾಲ್ತಾಮಾ ತಿಮಾ ಜಕರಿಯಾನು ನಾಮ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ತಿನಾಹುತಿ ಜಕರಿಯಾ ಕ್ಹುದಾನಿ ಸನ್ನಿದಿಮಾ ಗೈನ ಉದನೊ ಧವಾಂಡೊ ದೆತಾ ಟೈಮಾ ಮನಕ್ಹೊನು ಗುಂಪ ಭಾರಾಜ಼ ರ‍್ಹೈನ ಕ್ಹುದಾನೆ ಪ್ರಾಥನಾ ಕರಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ತೆಳಾಮಾ ಕ್ಹುದಾನೆ ಉದನೊ ಧವಾಂಡೊ ದಿವಾನಿ ಜ಼ಗಾನಾ ಸಿದಾ ಬಗಲ ಜಕರಿಯಾನೆ ದೆವದುತ ಹುಬ್ರಯಲ ದಿಕ್ಹ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ಜಕರಿಯಾ ತಿನೆ ದೆಕಿನ ಘಾಬ್ರೊಥೈನ ಭುಚ್ಕ್ಕಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ವರಿ ತೆ ದುತ ತಿನೆ ಜಕರಿಯಾ, ಭುಚ್ಕು಼ನಕೊ; ತಾರಿ ಪ್ರಾಥನಾ ಕ್ಹುದಾ ಐಕ್ಯೊಸ; ತಾರಿ ಬೈಕೊ ಎಲಿಸಬೆತ ಯಕ್ಕ ಪಟ್ಟೊ ಜ಼ನ್ನಿನ ತುನೆ ದಿವಸ. ತು ತಿನೆ ಯೊಹಾನ ಕೈನ ನಾಮ ಮ್ಹೆಲು. ");
INSERT INTO sle_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ತೆ ಹುಟ್ಟಲಹುತಿ ತುಮೊನೆ ಘನ್ನಿ ಖುಶಿ ಮಳಸ; ವರಿ ತೆ ಹುಟ್ಟಲಹುತಿ ಘನ್ನಾ ಮನಕ್ಹೊಮಾ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ಯೊಹಾನ ಕರ್ತಾನಿ ನಜ಼ರಮಾ ಮ್ಹೊಟೊ ಮನಕ್ಹ ಥಾವಸ; ತೆ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ರ‍್ಹವಾದೆ ವರಿ ಕಯುಬಿ ನಶಾನು ರಕ್ಹ ರ‍್ಹವಾದೆ ತೆ ಪಿತೊಜ಼ ನೈ; ಯೊಹಾನ ಹುಟ್ಟಲ ದಿನತೊಬಿ ತಿಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ತೆ ಇಸ್ರಾಯಲನಾ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ತ್ಯುನೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾಕನ ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ವರಿ ತೆ ಕ್ಹುದಾನೊ ದುತ ಥೈನ ಅಗೊ ಜಾ಼ವಸ. ತಿನೆ ಪ್ರವಾದಿ ಥಯಲ ಎಲಿಯಾನಿಯೊ ಚ್ಯಾಳಿಯೊ ವರಿ ಶಕ್ತಿಯೊ ಯೊಹಾನನೆ ಮಳಸ; ಬಾಪೊನೆ ದಿಕ್ರಾವೊನಾ ವಚ಼ಮಾ ಸಮಾದಾನ ದಿಲಾವಸ; ನಿತಿನೈಸೊ ವಾಲಾವೊನೆ ನಿತಿವಂತನು ಗ್ಯಾನ ಸಿಕ್ಕಲಾವಸ್; ವರಿ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾನಾ ಹುತಿ ತಯ್ಯಾರ ಕರಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ಜಕರಿಯಾ ತೆ ಕ್ಹುದಾನಾ ದುತನೆ\"ತು ಕವಾನು ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ಸು ವಳಕ ಛೆ? ಮಿ ಗಡಿಯೊ ಥೈಗಯೊಸ ವರಿ ಮಾರಿ ಬೈಕೊನೆ ಬಿ ವೈಸ ಥೈಗೈಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ತೆಳಾಮಾ ತೆ ದೆವದುತ \"ಮಾರು ನಾಮ ಗಬ್ರಿಯೆಲ ವ್ಹೈ. ಮಿ ಕ್ಹುದಾ ಕನ ರ‍್ಹವಾಲೊ ವ್ಹೈ. ವರಿ ಮಿ ಕ್ಹುದಾನಿಯೊ ವಾತೊ (ಸಂದೆಶ) ಮನಕ್ಹೊಕನ ಕವಾಲೊ ವ್ಹೈ, ವರಿ ಎ ಚೊ಼ಕಿ ವಾತ ಕವಾನಾ ಹುತಿ ಕ್ಹುದಾ ಮನೆ ತುಕನ ಮೊಕ್ಕಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ಎ ಮಾರಿಯೊ ವಾತೊ ಕರೆಟ್ಟ ಟೈಮಾ ಪುರಾ ಥಾವಸ; ಎನೈಸೊ ತು ಎ ನೈ ನಂಬಲಕ್ಹು ಎಕ್ಹಾರು ಪುರಾಥಾವಾನು ದಿನ್ನಲಕ್ಕಾ ಕಿಕನಜ಼ ಸು ಕದ್ಯಾವಾಚಿ ಮುಕೊ ಥೈನ ರ‍್ಹಶಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ವರಿ ಜಕರಿಯಾನಾ ಹುತಿ ಭಾರಾ ಕೈದತಾ ಹುಬ್ರಯಲ ಮನಕ್ಹೊ ದೆವಾಲಯಮಾ ತೆ ವಕ್ಹತ ಕರಲಹುತಿ ಮನಕ್ಹೊ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ತೆಕ್ಲಾಮಾಜ಼಼ ಜಕರಿಯಾ ದೆವಾಲಯಮಾತೊ ಭಾರೊ ಆತಾಮಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಸುಜ಼ ಬೊಲ್ಯಾವಾಚಿ ರ‍್ಹತಾಮಾ ಮನಕ್ಹೊ ಇನೆ ದೆವಾಲಯಮಾ ಕ್ಹುದಾ ಕಯೊಬಿ ಯಕ್ಕ ದರ್ಶನ ದಿದ್ಯೊಸ. ಕೈನ ಮನಕ್ಹೊ ತಿಳದಿಲಿನ. ತೆಳಾಮಾತೊಜ಼ ಜಕರಿಯಾ ಮನಕ್ಹೊನೆ ಹತಕ್ಹು ಇಶಾರೊ ಕರತೊ ಮುಕೊಥೈನೆಜ಼ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ಜಕರಿಯಾ ಯಾಜಕನಿ ಸೆವೆನಾ ದಿನೊ ಮುಗ್ದಲಪರ ತೆ ತಿನಾ ಘರೆ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ತೆ ದಿನೊ ಥಯಲಪರ ಜಕರಿಯಾನಿ ಬೈಕೊ ಎಲಿಸಬೆತ ಪಾಂಚ಼ ಮ್ಹ್ಯೆನಾ ಪೆಟೆ ರ‍್ಹ್ಯೆನ ಪಾಂಚ಼ ಮ್ಹ್ಯೆನಾ ಲಕ್ಕಾ ಘರಮಾತಿ ಭಾರಿ ಐ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ಎಲಿಸಬೆತ, ದೆಕೊ ಕರತಾ ಮಾರಾಹುತಿ ಹವು ಮ್ಹೊಟು ಕಾಮ ಕರ‍್ಯೊಸ \"ಮಾರಾ ಮನಕ್ಹೊನಾ ವಚ಼ಮಾ ಮಪರ ರ‍್ಹಯಲ ಯಕ್ಕ ಕೆಟ್ಟ ನಾಮ ಕ್ಹು ವಚಾ಼ಡ್ಯೊಸ\" ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ಎಲಿಸಬೆತ ಛೆ ಮ್ಹ್ಯೆನಾ ಪೆಟೆ ರ‍್ಹತಾಮಾ ಕ್ಹುದಾ ತಿನಾ ಗಬ್ರಿಯೆಲ ಕವಾನಾ ದುತನೆ ಗಲಿಲಾಯ ಕವಾನಾ ಪ್ರಾಂತ್ಯಮಾ ರ‍್ಹಯಲ ನಜ಼ರೆತೆ ಕವಾನಾ ಗಾಮ್ಮಾ ರ‍್ಹಯಲ ಜಾಂಜಿಮಾನ ಚೊ಼ಕ್ರಿಕನ ವಳಾಯೊ. ತಿನೆ ಕಯಾಜ಼ ದಾಣಗಾನಾ ಕ್ಹಾತೆ ಸಂಬದ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ತಿನೆ ದಾವಿದನಾ ಖಾಂದಾನವಾಲೊ ಥಯಲ ಯೊಸೆಫನಾ ಕ್ಹಾತೆ ನಾತ್ರು ಥೈತು. ತಿನು ನಾಮ ಮರಿಯಳ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ದೆವದುತ ತಿನಾ ಕ್ಹಾಮೊ ಐನ \"ಕ್ಹುದಾನೊ ಆಶಿರ್ವಾದ ವ್ಹಂದಲವಾಲಿ. ತುನೆ ಚೊ಼ಕು ಥಾವಾದೆ ಕರತಾ ತಾರಾ ಕ್ಹಾತೆ ಛೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ದೆವದುತನಾ ವಾತೊ ಐಕಿನ ಘನ್ನಿ ಗಲಿಬಿಲಿ ಥೈನ ಎ ಕೆವೊ ಆಶಿರ್ವಾದ ವ್ಹೈ ಕೈನ ವಿಚಾರ ಕರತಿ ಘಾಬ್ರಿ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ದೆವದುತ ತಿನೆ \"ಮರಿಯಳ, ಭುಚ್ಕು಼ನಕೊ. ಕ್ಹುದಾ ತುನೆ ಘನ್ನಿ ಕೃಪಾ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ಐಕ! ತು ಪೆಟೆ ರ‍್ಹೈನ ಯಕ್ಕ ಪಟ್ಟೊ ಜ಼ನ್ಸಿ. ತು ತಿನು ನಾಮ \"ಯೆಸು \"ಕೈನ ಮ್ಹೆಲು. ");
INSERT INTO sle_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ತೆ ಮ್ಹೊಟೊ ಮನಕ್ಹ ಕೈನ ಕವೈಲಿವಸ. ಎನೈಸೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನು ದಿಕ್ರೊ ಕವೈಲಿವಸ. ವರಿ ಕ್ಹುದಾ ತಿನೆ ರಾಜೊ಼ ಥಯಲ ದಾವಿದನಾ ಲಿಂಗತ ರಾಜೊ಼ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ತೆ ಯಾಕೊಬನಾ ಖಾಂದಾನವಾಲಾವೊಪರ ಕೆಳಾಮಾಬಿ ಅದಿಕಾರ (ಹಕ್ಕ) ಚ಼ಲಾವಸ; ತಿನಿ ಯಕ್ಕ ರಾಜ್ಯನೆ ಅಂತ್ಯ ನತ್ತಿ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ಮರಿಯಳ ದೆವದುತನೆ \"ಎ ಕಿಮ ಥಾವಸ? ಮಿ ಹಜು಼ನ ಹಿವಾ ನತ್ತಿ ಕರಲಿದಿತೊ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ದೆವದುತ ಮರಿಯಳನೆ ಪವಿತ್ರ ಆತ್ಮಾ ತುಪರ ಆವಸ. ಕ್ಹಾರಾವೊತಿ ಮ್ಹೊಟೊ ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ತಾಕತನಿ ಛವ್ಲಿ ತುಪರ ಆವಸ. ತಿನಾ ಹುತಿ ಹುಟ್ಟಾನು ಪವಿತ್ರ ಬಚ್ಚು಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ \"ಕವೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ಎನೈಸೊ ತಾರು ಕಳಬಳ ಥಯಲ ಎಲಿಸಬೆತ ಛೆತೊ. ತಿನೆ ವೈಸ ಥೈತಬಿ ತೆ ಯಕ್ಕ ಪಟ್ಟೊ ಜ಼ನ್ನಸ. ಬಚ್ಚಾ಼ನತ್ತಿ ಕೈನ ಮನಕ್ಹೊನಾ ಹತೆ ಕವೈಲಿದಲವಾಲಿ ತೆ ಹಮ್ನಾ ಛೆ ಮ್ಹ್ಯೆನಾ ಪೆಟೆ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾನಾ ಹತೆ ನೈ ಥಾವಾನು ಸುಜ಼ ನತ್ತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ತೆಳಾಮಾ ಮರಿಯಳ\"ಮಿ ಪ್ರಭುನಿ ದಾಸಿ ವ್ಹೈ. ವರಿ ತು ಕದಲ ತಿಮ್ಮಜ಼ ಥಾವಾದೆ\"ಕದಿ. ತೆಳಾಮಾ ದೆವದುತ ತ್ಯಾಂತೊ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ತೆಳಾಮಾಜ಼ ಮರಿಯಳ ಉಟಿನ ಗಡಬಡೆ ಯುದೆಯಮಾ ರ‍್ಹಯಲ ಡೊಂಗರೊನಾ ಪ್ರದೆಶಮಾ ರ‍್ಹಯಲ ಗಾಮೆ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ತ್ಯಾ ಜಕರಿಯಾ ಕವಾಲಾನಾ ಘರಮಾ ಗೈನ ಎಲಿಸಬೆತನಾ ಗಳೆ ಮಳಿನ ಹತೊಜೊ಼ಡಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ಎಲಿಸೆಬೆತ ಮರಿಯಳನೊ ಗಳೊ ಐಕ್ತಾಮಾ ಎಲಿಸಬೆತನಾ ಪೆಟಮಾ ರ‍್ಹಯಲ ಬಚ್ಚು಼ ಖುಶಿ ಥೈನ ವದ್ಯಾಡ್ಯು. ತೆಳಾಮಾ ಎಲಿಸಬೆತ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಿನ ");
INSERT INTO sle_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ವರಿ ಜೊ಼ರ ವದ್ರಿನ ಅಮ್ಮ ಕದಿ\" ಕ್ಹಾರಿಯೊ ಬಾಕ್ಡಿಯೊಮಾತಿ ಕ್ಹುದಾನೊ ಘನ್ನೊ ಆಶಿರ್ವಾದ ವ್ಹಂದಿಲಿದಲವಾಲಿ. ವರಿ ತಾರಾ ಮುಲಕ ಹುಟ್ಟಾನು ಬಚ್ಚು಼ ಕ್ಹುದಾ ಆಶಿರ್ವಾದ ದಿದಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ಮಾರಾ ಪ್ರಭುನಿ ಯಾ ಥಾವಾಲಿ ಮಕನ ತು ಆಯಲ ಮನೆ ಕೆಕ್ಲೊ ಚೊ಼ಕೊ ನಸಿಬ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ದೆಕ ತಾರೊ ಗಳೊ ಮಾರಾ ಕಾನೆ ಪಡ್ತಾಮಾಜ಼ ಮಾರಾ ಪೆಟಮಾ ರ‍್ಹಯಲ ಬಚ್ಚು಼ ಖುಶಿಕ್ಹು ವದ್ಯಾಡ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ಪ್ರಭು ತುನೆ ಕದಲ ವಾತೊ ಪುರಾ ಥಾವಸಜ಼ ಕೈನ ನಂಬಲವಾಲಿ ತು ಧನ್ಯ ವ್ಹೈ.. ");
INSERT INTO sle_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ತೆಳಾಮಾ ಮರಿಯಳ, \"ಮಾರೊ ಜ಼ಲಮ ಪ್ರಭುನೆಜ಼ ಸ್ತುತಿ ಕರಸ\" ");
INSERT INTO sle_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ಮಾರಿ ಆತ್ಮಾ ಮಾರೊ ರಕ್ಷಕ ಥಯಲ ಕ್ಹುದಾನಾ ಹುತಿ ಖುಶಿ ಥಯುಸ್ಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ಕ್ಹುದಾ ತಿನಿ ದಾಸಿನಿ ದಿನಸ್ತಿತಿ ದೆಕ್ಯೊಸ. ಆಜ಼ತಾಜ಼ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಮನೆ ಧನ್ಯ ವ್ಹೈ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ತಿನಾಹುತಿ ಸರವಶಕ್ಕತ ಥಯಲ ಕ್ಹುದಾ ಮನೆ ಮ್ಹೊಟೊ ಉಪಕಾರ ಕರ‍್ಯೊಸ. ತಿನು ನಾಮ ಪರಿಶುದ್ಧ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ಕ್ಹುದಾನಾ ಭೆಮಾ ವರಿ ಭಕ್ಕತಿಮಾ ರ‍್ಹಯಲವಾಲಾವೊಪರ ತಿನಿ ಮರಗಾ ಕೆಳಾಮಾಬಿ ತ್ಯುನೊಪರ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ತೆ ತಿನಿ ತಾಕತಕ್ಹು ಸ್ವಕ್ಕ ರ‍್ಹಯಲವಾಲಾವೊನಾ ತ್ಯುನು ಸ್ವಕ್ಕ ಹಾಳ ಕರಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ಕ್ಹುದಾ, ಸ್ವಕ್ಕ ರ‍್ಹಯಲವಾಲಾ ಅದಿಪತಿಯೊನೆ ತ್ಯುನೆ ಯಕ್ಕ ಜ಼ಗಾತೊ ಉತಾರಿನ. ತೆನೈಸೊ ಕ್ಹುದಾನೊ ಭೆ ವರಿ ಭಕ್ತಿ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಚೊ಼ಕಿ ಜ಼ಗಾ ಹುಬ್ರಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ತೆ ಭುಕ್ಕಾ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಚೊ಼ಕು ರ‍್ಹಯಲ ಖಲೈನ, ತೆನೈಸೊ ಆಸ್ತಿರಹೆವಾಲಾವೊನೆ ಖಾಲಿ ಹತೆ ಮೊಕ್ಲಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ಕ್ಹುದಾ ಅಪ್ನಾ ಪುರ್ವಜೊನೆ ವಾತದಿದಲ ಪುರಾ ಕರ‍್ಯೊಸ. ಅಪ್ನೊ ಮುಲ ಪಿತಾ ಥಯಲ ಅಬ್ರಾಹಮನಾ ಖಾಂದಾನವಾಲಾವೊನೆ ಕೆಳಾಮಾಬಿ ");
INSERT INTO sle_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ಮರಗಾ ದೆಕಾಡು ಕೈನ ತಿನಾ ಸೆವಕೊ ಥಯಲ ಅಬ್ರಹಾಮ ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹನೆ ಹತ ಧರ‍್ಯೊಸ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ಮರಿಯಳ ಕಮ ಜಾಸ್ತ ತನ ಮ್ಹ್ಯೆನಾ ಎಲಿಸಬೆತನಾ ಕ್ಹಾತೆ ರ‍್ಹ್ಯೆನ ಮರಿಯಳ ತಿನಾ ಘರೆ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ಎಲಿಸಬೆತನೆ ದಿನೊ ಭರಿನ ಯಕ್ಕ ಪಟ್ಟೊ ಜ಼ನ್ನಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ಕ್ಹುದಾ ಎಲಿಸಬೆತನೆ ಆಶಿರ್ವಾದ ದಿದಲ ಗ್ವತ್ತ ಥೈನ ತಿನಾ ಕಳಬಳ ವರಿ ಆಜು಼ ಬಾಜು಼ವಾಲಾ ತಿನಾ ಕ್ಹಾತೆ ಮಳಿನ ಘನ್ನಾ ಖುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ಪಟ್ಟೊ ಹುಟ್ಟಿನ ಆಟ ದಿನ್ನ ಥಾತಾಮಾ ತ್ಯುನೆ ತಿನೆ ಸುನ್ನತಿ ಕರಾಹುತಿ ಲಾಯಾ. ತ್ಯುನೆ ತೆ ಪಟ್ಟಾನು ನಾಮ ತಿನಾ ಬಾನು ನಾಮ ಜಕರಿಯಾ ಕೈನ ಮ್ಹೆಲು ಕೈನ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ತೆನೈಸೊ ತೆ ಪಟ್ಟಾನಿ ಯಾ ತೆ ನಾಮಿ \"ನಕೊ! ತಿನೆ ಯೊಹಾನ ಕೈನ ನಾಮ ಮ್ಹೆಲೊ \"ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ತ್ಯಾ ಆಯಲವಾಲಾ ಮನಕ್ಹೊ ಎಲಿಸಬೆತನೆ \"ತಾರಾ ಖಾಂದಾನಮಾ ಕಿನುಜ಼ ಎ ನಾಮ ನತ್ತಿತೊ \"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ಎ ಪಟ್ಟಾನೆ ಸು ನಾಮ ಮ್ಹೆಲು ಕೈನ ಸ್ವನ್ನಿ ಕರಿನ ತಿನಾ ಬಾನೆ ಪುಚ್ತಾ಼ಮಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ತೆಳಾಮಾ ಜಕರಿಯಾ ಪಾಟಿ ಮಂಗೈನ \"ಯೊಹಾನಜ಼ \"ಮ್ಹೆಲೊ ಕೈನ ಬರ್ದಿನ ದೆಕಾಡ್ಯೊ ತಿನಾ ಹುತಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ತೆಳಾಮಾಜ಼ ಜಕರಿಯಾನೆ ಬೊಲಾನಿ ತಾಕತ ಮಳಿ ತೆಳಾಮಾ ತೆ ಕ್ಹುದಾನಿ ಸ್ತುತಿ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ಎ ಕ್ಹಾರು ಐಕಿನ ಆಜು಼ಬಾಜು಼ವಾಲಾ ಭುಚ್ಕ್ಕಯಾ. ವರಿ ಎ ಕ್ಹಾರಿಯೊ ವಿಚಾರೊ ಹುತಿ ಯುದಾಯಮಾನಾ ಮನಕ್ಹೊ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ಐಕಲವಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ \"ಎ ಪಟ್ಟೊ ಮ್ಹೊಟೊ ಥಯಲ್ಪರ ಕೆವೊ ಥಾವಸ ಕೈನ? ತಿಳ್ದಿನ ತ್ಯುನೆ ಮನಸ್ಸಮಾ ಮ್ಹೆಲ್ಲಿದ್ಯಾ ವರಿ ಕ್ಹುದಾನಿ ತಾಕತ ತಿಪರ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ಪಾಚಲ್ತೊ ಯೊಹಾನನೊ ಬಾ ಥಯಲ ಜಕರಿಯ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಿನ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊನೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನೆ ಸ್ತೊತ್ರಾ ತೆ ತಿನಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಆಯೊ ವರಿ ತೆ ಮನಕ್ಹೊನೆ ಛೊಡಾವಾನೆ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ಕ್ಹುದಾ ತಿನೊ ಸೆವಕ ಥಯಲ ದಾವಿದನಾ ಖಾಂದಾನತೊ ಅಪ್ನಾ ಹುತಿ ಯಕ್ಕ ಮ್ಹೊಟಾ ರಕ್ಕಷಕನೆ ಅಪೊನೆ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ಎ ಕ್ಹಾರು ತೆ ಪುರ್ವಕಾಲನಾ ತಿನಾ ಪವಿತ್ರ ಪ್ರವಾದಿನಾ ಮ್ಹೊಡೆ ಕವಾಲಗಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ಕ್ಹುದಾ ಅಪ್ನೊನೆ ಅಪ್ನಾ ದುಶ್ಮನೊಕ್ಹು ವಚಾ಼ಡ್ಯೊಸ. ವರಿ ಅಪೊನೆ ನೈ ಶೆರಾಲಾವೊಕ್ಹು ವಚಾ಼ಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ಕ್ಹುದಾ ಅಪೊನೆ ಮರಗಾ ದಿವಾ ಹುತಿ ಅಪ್ನೊ ಪಿತೃ ಥಯಲ ಅಬ್ರಹಾಮನೆ ಪವಿತ್ರ ವಾತ ದಿದಲ ಶೆ ಮ್ಹೆಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ಕ್ಹುದಾ ಅಪ್ನೊ ಪಿತೃಥಯಲ ಅಬ್ರಹಾಮನೆ ವಾತ ದಿದಲಲಿಂಗತ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ತೆ ಅಪೊನೆ ದುಶ್ಮನೊಕ್ಹು ವಚಾ಼ಡಾನೆ ವಾತ ದಿದ್ಯೊತೊ. ವರಿ ತೆ ಕಯುಜ಼ ಭೆವಾಚಿ ಆರಾಧನಾ ಕರಾನೆ ವಾಟ ಕರಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ಇನಾಹುತಿ ಅಪೆ ತಿನಾ ಕ್ಹಾಮಾ ಅಪ್ನಿ ಜಿವ್ತಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ದಿನೊ ತಿನಾ ಕ್ಹಾಮಾ ಪರಿಶುದ್ಧ ವರಿ ನಿತಿವಂತೊ ಥೈನ ರ‍್ಹೌ ಕೈನ ಉದ್ದೆಶ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ವರಿ ಜಕರಿಯಾ\"ದಿಕ್ರಾ ತುತೊ ಮ್ಹೊಟೊ ಪ್ರವಾದಿ ಕೈನ ಕವೈಲೆಶಿ. ತು ಕರ್ತಾನಾ ಕ್ಹಾಮೊ ಗೈನ ತೆ ಆವಾನಾ ಟೈಮ ಲಕ್ಕಾ ತಿನಿ ವಾಟ ತಯ್ಯಾರ ಕರಶಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ಪಾಪ ಮಾಫ ಥಯಾಮ ಯಕ್ಕಜ಼ ರಕ್ಷಣೆ ಥಾವಸ ಕವಾನು ತಿನಾ ಮನಕ್ಹೊನೆ ತಿಳಸ್ಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ಅಪ್ನೊ ಕ್ಹುದಾ ಮರಗಾಲೊ ವ್ಹೈ ವರಿ ತೆ ಅಪ್ನೊಪರ ರಕ್ಕಷಣೆನು ಉಜಾಲು ದಿವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ವರಿ ಅಂದಾರಾಮಾ ಜಿವ್ನಾ ಕರತಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಮರಾನೊ ಭೆ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ಆಸ್ರೊ ಕರಸ ವರಿ ತೆ ಅಪೊನೆ ಸಮಾಧಾನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ತೆ ಪಟ್ಟೊ (ಯೊಹಾನ) ಮ್ಹೊಟೊ ಥೈನ ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಕ್ಹು ವರಿ ಅಂಗಕ್ಹು ಬೆಳದಿನ ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಚಾಲು ಕರಾನಿ ದಿನ್ನ ಲಕ್ಕಾ ಕುನ್ನಜ಼ ರ‍್ಹವಾನೆ ಥಾಯೆನೈಸೊ ಜ಼ಗಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ತೆ ದಿನೊಮಾ ಇಡಿ ರೊಮ ರಾಜ್ಯಮಾ ಮನೊಕ್ಹೊನಿ ಗಣತಿ ಥೌ ಕೈನ ಚಕ್ರವರ್ತಿ ಥಯಲ ಅಗಸ್ಟಸ ಆದೆಶ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ಕುರೆನ್ಯ ಸಿರಿಯನನೊ ಅಧಿಪತಿ ಥಯಲ ಟೈಮಾ ಎಜ಼ ಪಸ್ಟ ಸಲಾ ಮನಕ್ಹೊನಿ ಗಣತಿ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ವರಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತೆಳಾಮಾ ತ್ಯುನು ನಾಮ ದಾಖಲೊ ಕರಾಹುತಿ ತ್ಯುನಾ-ತ್ಯುನಾ ಸ್ವಂತ ಗಾಮೊನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ತಿನಾ ಹುತಿ ಯೊಸೆಫ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯಮಾ ರ‍್ಹಯಲ ನಜ಼ರೆತೆ ಕವಾನಾ ಗಾಮತಾ ಗೈನ ಯುದೆಯಮಾ ರ‍್ಹಯಲ ಬೆತ್ಲೆಹೆಮ ಕವಾನಾ ಗಾಮೆ ಗಯೊ. ಯೊಸೆಫ ದಾವಿದನೊ ಖಾಂದಾನಾವಾಲೊ ರ‍್ಹಯಲಹುತಿ ದಾವಿದನು ಗಾಮ ಥಯಲ ಬೆತ್ಲೆಹೆಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ತಿನಾಕ್ಹಾತೆ ನಾತ್ರು ಥಯಲ ಮರಿಯಳನೆಬಿ ಕ್ಹಾತೆ ಲಿನಗಯೊ. (ಮರಿಯಳ ತೆ ಟೈಮಾ ಪೆಟೆ ವ್ಹತ್ತಿ) ");
INSERT INTO sle_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ತ್ಯುನೆ ಬೆತ್ಲೆಹೆಮ್ಮಾ ರ‍್ಹತಾಮಾ ಮರಿಯಳನೆ ದಿನೊ ಭರಿನ ಜ಼ನ್ನಾನೊ ಟೈಮ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ಮರಿಯಳ ತಿನು ಪೈಲಾರ ಬಚ್ಚು಼ (ಯೆಸುನೆ) ಜ಼ನ್ನಿ. ತ್ಯುನೊನೆ ರ‍್ಹವಾನೆ ಜ಼ಗಾ ನೈರ‍್ಹಯಲಹುತಿ. ಮರಿಯಳ ಪಟ್ಟಾನೆ ಫಡಕಾಮಾ ಸುತ್ತಿನ ಬೈಲೊನೆ ಹಕ್ಕಿಮಾ ಚಾ಼ರೊ ಖಾವಾನಿ ಜ಼ಗಾ ಪಟ್ಟಾನೆ ಕ್ಹುರಾಡಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ತೆ ದಿನನಾ ರಾತೆ ಕುರಬುರ‍್ಯಾ ತೆ ಪ್ರಾಂತ್ಯನಾ ಗಾಮ್ನಾ ಬಾಜು಼ಮಾ ತ್ಯುನಾ ಬಕ್ರಾವೊನೆ ಕೈದಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ಕ್ಹುದಾನೊ ಯಕ್ಲೊ ದುತ ತ್ಯುನೊಕನ ಆಯೊ. ತೆಳಾಮಾ ಕ್ಹುದಾನಿ ಮಹಿಮಾನು ತ್ಯುನಾ ಸುತ್ತ-ಮುತ್ತ ಉಜಾಲು ಥಯು. ತ್ಯುನೆ ಘನ್ನಾ ಭುಚ್ಕ್ಕಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ತೆ ದುತ ತ್ಯುನೊನೆ \"ಭುಚ಼ಕೊ ನಕೊ ಐಕೊ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಮ್ಹೊಟಿ ಖುಶಿ ಕರಾನು ಚೊ಼ಕಿ ಸುದ್ದಿ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ತೆ ಸುವೈ ಕದ್ಯಾಮ ಆಜ಼ನಾ ಟೈಮಮಾ ತುಮಾರಾ ಹುತಿ ದಾವಿದನಾ ಗಾಮ್ಮಾ ಯಕ್ಲೊ ರಕ್ಷಕ ಹುಟ್ಯೊಸ. ತೆ ಕರತಾ ಥಯಲ ಕ್ರಿಸ್ತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ತೆ ದುತ ತುಮೊನೆ ಗ್ವತ್ತ ಥಾವಾಹುತಿ ತಿನೆ ವಳ್ಕಾನು ಕಿಮ ಕದ್ಯಾಮ ಫಡಕಾಮಾ ಸುತ್ತಲ ಯಕ್ಕ ಪಟ್ಟಾನೆ ಹಕ್ಕಿಮಾ ಕ್ಹುರಯಲ ದೆಕೊಸಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ಗಪಕ್ಕಕನೆ ಸ್ವರಗಲೊಕಾನಾ ದೆವದುತೊನು ಗುಂಪ ಐನ ತೆ ಪೈಲಾ ಆಯಲ ದುತನಾ ಕ್ಹಾತೆ ಮಳಿನ ತ್ಯುನೆ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ಉಪ್ಪರಲ್ಯಾ ಲೊಕಮ ಕ್ಹುದಾನಿ ಮಹಿಮಾ; ಭುಲೊಕಮಾ ಮನಕ್ಹೊಮಾ ಸಮಾದಾನ ಕ್ಹುದಾ ತ್ಯುನೊನೆ ವಲ್ದ್ಯೊಸ ಕೈನ ಕ್ಹುದಾನೆ ಸ್ತುತ್ತಿ ಕರತಾ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ದೆವದುತೊ ತ್ಯುನೊ ಕಂತಾ ಸ್ವರ್ಗಲೊಕಮಾ ಗಯಲ್ಪರ ತೆ ಕುರಬುರ‍್ಯಾ \"ಅಪೆ ಹಮ್ನಾ ಬೆತ್ಲೆಹೆಮೆ ಗೈನ ಕರತಾ ಅಪೊನೆ ತಿಳಸಲತಿಮ್ಮ ಎ ವಿಚಾರ ದೆಕಿಯೆ ಚಾ಼ಲೊ \"ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ಗಪಕ್ಕಕನೆ ಗೈನ ಮರಿಯಳನೆ ಯೊಸೆಫನೆ ಹಕ್ಕಕಿಮಾ ಕ್ಹುರಯಲ ಬಚ್ಚಾ಼ನೆ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ತ್ಯುನೆ ತೆ ಬಚ್ಚಾ಼ನಾ ಹುತಿ ದೆವದುತೊ ಕದಲ ತಿಮ್ಮಜ಼ ಕುರಬುರ‍್ಯಾ ತ್ಯುನೊಕನ ದುತೊ ಕದಲ ವಾತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ಕುರಬುರ‍್ಯಾ ಕದಲ ಐಕಲವಾಲಾ ತೆಕ್ಕಲಾಜ಼ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ವರಿ ಮರಿಯಳ ತೆ ಕ್ಹಾರಿಯೊ ವಾತೊ ತಿನಾ ಮನಸ್ಸಾಮಾ ಮ್ಹೆಲ್ಲಿನ ವಿಚಾರ ಕರಾಡಿತಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ಕುರಬುರ‍್ಯಾ ದೆವದುತೊನೆ ದೆಕಲ ತ್ಯುನೆ ಕದಲ ಐಕಿನ ವರಿ ತಿನಾ ಹುತಿ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರತಾ ತ್ಯುನಾ ಬಕ್ರಾ ರ‍್ಹಯಲ ಜ಼ಗಾಪರ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ತೆ ಪಟ್ಟಾನೆ ಆಟ್ವಾ ದಿನೆ ಸುನ್ನತಿ ಥೈ ತಿನು ನಾಮ \"ಯೆಸು \"ಕೈನ ಮ್ಹೆಲ್ಯಾ. ಮರಿಯಳನಾ ಪೆಟಮಾ ಬೆಳದಾತಿ ಪೈಲಾ ಕ್ಹುದಾನು ದುತ ಎಜ಼ ನಾಮ ಮ್ಹೆಲ ಕೈನ ಕದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ಶುದ್ಧಿಕರಣ ಕರಾನಾ ಹುತಿ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ತಿಮಜ಼ ಕಾರಯೊ ಕರಾನೊ ಮರಿಯಳನೊ ವರಿ ಯೊಸೆಫನೊ ಟೈಮ ಆಯೊ. ಯೆಸುನೆ ಕ್ಹುದಾನೆ ಪ್ರತಿಷ್ಟೆನಾ ಹುತಿ ತ್ಯುನೆ ತಿನೆ ಯೆರುಸೆಲೆಮನಿ ದೆವಾಲಯಮಾ ಬಲೈ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ಕಾಕದ್ಯಾಮ ಪೈಲಾ ಹುಟ್ಟಲ ಪಟ್ಟಾನೆ ಕ್ಹುದಾನೆ ನೆಮ್ಸಿನ ದ್ಯು ಕೈನ ಕ್ಹುದಾನಾ ಧರಮಶಾಸ್ತ್ರಮಾ ಬರ್ದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ತಿನಾಹುತಿ \"ಬೆ ಕ್ಹಬುತರೊ ನೈತೊ ಬೆ ಜಂಗ್ಲಿ ಕ್ಹಬುತರೊ ಬಲಿನಾ ಹುತಿ ದ್ಯು ಕೈನ ಕ್ಹುದಾನಿ ಧರಮಶಾಸ್ತ್ರಮಾ ಕವಸ್ತೊ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆರೊಸೆಲಿಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ತೆ ಕಾಲಮಾ ಸಿಮೊನ ಕವಾಲೊ ಯಕ್ಲೊ ಯೆರೊಸೆಲಿಮಾ ವ್ಹತ್ತೊ. ತೆ ಚೊ಼ಕೊ ವರಿ ಕ್ಹುದಾನೊ ಭಕ್ಕತ ವ್ಹತ್ತೊ. ಎ ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊನೆ ರಕ್ಷಣೆ ದಿವಾಲೊ ಆವಸ ಕೈನ ದೆಕಾಡ್ಯೊತೊ. ವರಿ ಪವಿತ್ರ ಆತ್ಮಾ ತಿನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ಕರತಾ ಮೊಕ್ಕಲಾಯಲ ಕ್ರಿಸ್ತನೆ ದೆಕೆ ಲಕ್ಕಾ ತು ಮರ್ತೊಜ಼ ನೈ ಕೈನ ಪವಿತ್ರ ಆತ್ಮಾ ಸಿಮೊನನೆ ತಿಳಶ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ಸಿಮೊನ ಪವಿತ್ರ ಆತ್ಮಾನಾ ಮುಲಕ ದೆವಾಲಯೆ ಆಯೊ. ಯೆಹುದಿಯೊನಿ ಧರಮಶಾಸ್ತ್ರನಿ ನಿಯಮ ಪುರಾ ಕರಾನಾಹುತಿ ತಿನಾ ಮಾ ಬಾಪ ಯೆಸು ನ್ಹಾನೊ ರ‍್ಹತಾಮಾ ದೆವಾಲಯೆ ಲಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ಸಿಮೊನ ಪಟ್ಟಾನೆ ಹತಮಾ ಉಚೈಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರ ಕೈನ ಅಮ್ಮ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"ಕ್ಹುದಾ, ತಾರಿ ವಾಗ್ದಾಲಿಂಗತ ಪುರಾ ಕರ‍್ಯೊ. ಹಮ್ನಾ ಸಮಾದಾನಕ್ಹು ಜಾ಼ವಾನೆ ತಾರಾ ಆಳನೆ ಅಪ್ಪಣೆ ಥಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ಕಾಕದ್ಯಾಮ ತು ಹಮಾರಾ ಹುತಿ ದಿದಲ ರಕ್ಷಣೆ ಮಿ ಡೊಳೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ತು ತಿನೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ತೆ ಯೆಹೊದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ತಾರಿ ವಾಟ ದೆಕಾಡಾನು ಉಜಾಲು ವ್ಹೈ. ತಿನಾಕ್ಹು ತಾರಾ ಮನಕ್ಹೊ ರ‍್ಹಯಲ ಇಸ್ರಾಯೆಲರೊನೆ ಮರ್ಯಾದಿ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ಸಿಮೊನ ಪಟ್ಟಾನಾ ಹುತಿ ಕದಲ ವಾತೊ ಐಕಿನ ತೆ ಪಟ್ಟಾನಾ ಮಾ ಬಾಪ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ಪಾಚಲ್ತೊ ಸಿಮೊನ ಆಶಿರ್ವಾದ ದಿನ್ನ ಮರಿಯಳನೆ \"ದೆಕ ಎ ಪಟ್ಟಾನಾ ಹುತಿ ಇಸ್ರಾಯಲನಾ ಘನ್ನಾ ಜ಼ನಾ ಪಡಸ ಘನ್ನಾ ಜ಼ನಾ ಉಟಸ. ದಕ್ಹಾ ಜ಼ನಾ ತಿನೆ ನೈ ವಪ್ಪಿಲೆತಾ. ಎ ಕ್ಹುದಾಕಂತೊ ಆಯೊಸ ಕವಾನು ವಳಕ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ಇಮ್ಮ ಮನಕ್ಹೊನಾ ಮನಸ್ಸಮಾ ರ‍್ಹಯಲ ವಿಚಾರೊ ಭಾರಿಯೊ ಆವಸ. ಅಗಿಯೊ ಥಾವಾನಿಯೊ ವಾತೊ ತಾರಾ ಮನಸ್ಸನೆ ತಲ್ವಾರ ಘಾಲಲ ಲಿಂಗತ ಥಾವಾಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ದೆವಾಲಯಮಾ ಅನ್ನಳ ಕವಾಲಿ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಲಿ ವ್ಹತ್ತಿ. ತೆ ಅಶೆರನ್ನಿ ಖಾಂದಾನ್ನಿ ಫನುವೆಲನಾ ಕುಟುಂಬವಾಲಿ ವ್ಹತ್ತಿ. ತಿನೊ ಹಿವಾ ಥೈನ ಕ್ಹಾತ ವರಕ್ಹ ಥಯಲಪರ ತಿನೊ ಮಾಟಿ ಮರಿ ಗಯೊತೊ. ತೆ ಹೆಣ ಮನಕ್ಹನಿ ವೈಸ ಘನ್ನಿ ಥೈತಿ ");
INSERT INTO sle_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ತೆ ಹೆಣ ಐಂಶಿಪರ ಚಾರ ವರಕ್ಹನಿ ವ್ಹತ್ತಿ. ತೆ ರಾಂಡಿ ವ್ಹತ್ತಿ. ವರಿ ದೆವಾಲಯ ಛೊಡಿನ ಗಯಾವಾಚಿ ಉಪಾಸ ಕರತಿತಿ. ವರಿ ದಿನ್ನ ರಾತ ಪ್ರಾಥನಾ ಕರತಿ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರತಿತಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ತೆಜ಼ ಟೈಮಾ ತೆ ಬಚ್ಚಾ಼ನಾ ಮಾ ಬಾಪಕನ ಐನ, ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ. ಕ್ಹುದಾ ಯರುಸೆಲೆಮ ಮನೆ ಮರಗಿನ ತ್ಯಾನಾ ಮನಕ್ಹೊನೆ ಛೊಡಾವಾಹುತಿ ವಾಟ ದೆಕತಾ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊನೆ ಯೆಸುನಾ ಹುತಿ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ಕ್ಹುದಾನಾ ಧರಮಶಾಸ್ತ್ರಮಾ ರ‍್ಹಯಲ ನಿಯಮೊ ಪುರಾ ಕರಲ್ಪರ ಯೊಸೆಫ ವರಿ ಮರಿಯಳ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯಮಾ ರ‍್ಹಯಲ ತಿವ್ನಾ ಸ್ವಂತ ಗಾಮ ಥಯಲ ನಜ಼ರೆತೆ ಫರಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ತೆ ಪಟ್ಟೊ ಬೆಳ್ದಿನ ತಾಕತ ಹೊಂದಿನ ಪುರಾ ಗ್ಯಾನಿ ಥಯೊ. ಕ್ಹುದಾನಿ ಕೃಪಾ ತಿಪರ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ತಿನಾ ಮಾ ಬಾಪ ಹರಿ ಯಕ್ಕ ವರಕ್ಹೆ ಪಸ್ಕ ಸನ್ನನಾ ದಿನ್ನೆ ಯೆರೊಸೆಲಿಮೆ ಜಾ಼ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತೆ ಪಟ್ಟೊ ಬಾರಾ ವರಕ್ಹನೊ ಥಯಲ್ಪರ ತ್ಯುನೆ ಪಸ್ಕ ಸನ್ನಾ ನಿಯಮನಾ ಪ್ರಕಾರ ತ್ಯಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ಸನ್ನಾ ದಿನ್ನೊ ಮುಗ್ದಲಪರ ತ್ಯುನೆ ಗಾಮೆ ಚಾ಼ಲ್ಯಾತಾ. ತೆನೈಸೊ ಯೆಸು ಯೆರುಸೆಲೆಮಾಜ಼ ರ‍್ಹ್ಯೆ ಗಯೊ. ಎ ಕ್ಹಾರು ತಿನಾ ಮಾ ಬಾಪನೆ ಗ್ವತ್ತ ನ್ಹೊತು. ಯೆಸು ತ್ಯುನಾ ಕ್ಹಾತೆ ಆಯಲ ತ್ಯುನಾ ದೊಸ್ತೊಮಾ ವರಿ ಕಳ ಬಳನಾ ಕ್ಹಾತೆ ವಸೆ ಕೈನ ತಿಳದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ಯೊಸೆಫ ವರಿ ಮರಿಯಳ ಯಕ್ಕ ದಿನ್ನ ಪುರಾ ಚಾ಼ಲ್ತಾ ಯೆಸುನೆ ಧುಂಡಾನೆ ಗಯಾ. ಪಾಚಾ಼ತಾ ದಿಕ್ರೊ ನೈದಿಕ್ಹಲಕ್ಹು ತ್ಯುನಾ ಕಳಬಳಮಾ ವರಿ ತ್ಯುನಾ ದೊಸ್ತೊಮಾ ನೈ ದಿಕ್ಹಲಹುತಿ ತಿನೆ ಹುಡ್ಕಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ವರಿ ತೆ ತ್ಯಾ ನೈ ದಿಕ್ಹಲ ಹುತಿ ಯೆಸುನೆ ಹುಡ್ಕಾನೆ ಯೆರೊಸೆಲಿಮೆ ಫರಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ತನವಾ ದಿನೆ ಯೆಸು ಮರಿಯಳನೆ ವರಿ ಯೊಸೆಫನೆ ದಿಕ್ಹ್ಯೊ. ಯೆಸು ದೆವಾಲಯಮಾ ಧಾರಮಿಕ ವಾತೊ ಕವಾಲಾವೊನಾ ಕ್ಹಾತೆ ಬೈಟಿನ ತ್ಯುನಿಯೊ ವಾತೊ ಐಕ್ತೊ ವರಿ ತ್ಯುನೊನೆ ಪ್ರಶ್ನೆ ಪುಚಾ಼ಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ತಿನಿಯೊ ವಾತೊ ಐಕಿನ ತಿನಿ ಗ್ಯಾನಕ್ಹು ಜ಼ವಾಬ ದಿದಲ ದೆಕಿನ ತ್ಯುನೆ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ಯೆಸುನಾ ಮಾ ಬಾಪ ತಿನೆ ತ್ಯಾ ದೆಕಿನ ತ್ಯುನೆ ಘಾಬ್ರಾಥಯಾ. ಮರಿಯಳ ತಿನೆ \"ದಿಕ್ರಾ, ತು ಹಮೊನೆ ಅಮ್ಮ ಕಾ ಕರ‍್ಯೊ? ದೆಕ ತಾರೊ ಬಾ ವರಿ ಮಿ ತಾರಾ ಹುತಿ ಘನ್ನಾ ಚಿಂತಾಕರಾಡಾತಾ. ವರಿ ತುನೆ ಹುಡ್ಕಾಡ್ಯಾತಾ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ\"ಮನೆ ತುಮೆ ಹುಡ್ಕಾನು ಕಾ? ಮಾರಾ ಬಾನಾ ಘರಮಾ ರ‍್ಹೌಸ ಕವಾನು ತುಮೆ ತಿಳ್ದಿಲಿನ ರ‍್ಹವಾನು ವ್ಹತು. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ತೆನೈಸೊ ತಿನಿಯೊ ವಾತೊ ತ್ಯುನೊನೆ ತಿಳದಿಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ಯೆಸು ತ್ಯುನಾ ಕ್ಹಾತೆ ನಜ಼ರೆತೆ ಐನ ತಿನಾ ಮಾ ಬಾಪನೆ ವಿಧೆಯ ಥಯೊ. ತಿನಿ ಯಾ ಎ ಕ್ಹಾರಿಯೊ ವಾತೊನಾ ಹುತಿ ವಿಚಾರ ಕರಾಡಿತಿ. ");
INSERT INTO sle_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ಯೆಸು ಘನ್ನು ಗ್ಯಾನ ವ್ಹಂದಿನ ವರಿ ಅಂಗಮಾ ತಾಕತ ವ್ಹಂದಿನ ಬೆಳತ್ತೊ ಆಯೊ. ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ವರಿ ಮನಕ್ಹೊನೆ ನಜ಼ರಮಾ ಚೊ಼ಕೊ ಥಾತೊ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ಚಕ್ರವರ್ತಿ ಥಯಲ ತಿಬೆರಿಯಸ ಸಿಸರನಿ ಆಡಳಿತನೆ 15 ವರಕ್ಹ ವ್ಹತು. ತೆಳಾಮಾ, ಪೊಂತ್ಯ ಪಿಲಾತನು ಯುದೆಯ ಪ್ರಾಂತ್ಯನೆ ಹೆರೊದ ಗಲಿಲಾಯನೆ ಹೆರೊದನೊ ಭೈ ಥಯಲ ಪಿಲಪ್ಪ ಇತುರೆಯ ವರಿ ತ್ರಕೊನಿತಿ ಪ್ರಾಂತ್ಯನೆ ಲುಸನ್ಯ ಅಬಿಲೆನ ಪ್ರಾಂತ್ಯನೆ ಅಧಿಪತಿ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ಅನ್ನನ ವರಿ ಕಾಯಫನ ಖಾಸ ಯಾಜಕೊ ವ್ಹತ್ತಾ. ತೆ ಟೈಮಾ ಜಕರಿಯಾನೊ ದಿಕ್ರೊ ಥಯಲ ಯೊಹಾನ ರಾನ್ಮಾ ರ‍್ಹಯಲ ಗಾಮ್ಮಾ ರ‍್ಹತಾಮಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ತಿನೆ ಮಳಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ಯೊಹಾನ ಯೊರ್ದನ ನದಿನಾ ಆಜು಼ಬಾಜು಼ ಪ್ರಾಂತ್ಯಮಾ ಫರಿನ, ಮನಕ್ಹೊನೆ \"ತುಮೆ ತುಮಾರಾ ಪಾಪ ಮಾಫ ಕರಾನಾ ಹುತಿ ಕ್ಹುದಾಕನ ಫರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವೊ ಇನಾಹುತಿ ಕ್ಹುದಾ ತುಮಾರಾ ಪಾಪೊಕ್ಹು ಛೊಡಾವಸ\" ಕೈನ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯನ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಲಿಂಗತಜ಼ ಥಾವಾ ಹುತಿ ಎ ಕ್ಹಾರು ಶುರು ಥಯು. ಕುನ್ನ ಯಕ್ಕ ವದ್ರಾಡ್ಯುಸ. ತೆ ಸುವೈ ಕದ್ಯಾಮ; \"ಕರ್ತಾನಿ ವಾಟ ತಯ್ಯಾರ ಕರೊ ತಿನಿ ವಾಟ ಸಿದಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ಹರ ಯಕ್ಕ ಖಾಡಿಯೊ ಝಕಾವಸ. ಹರ ಯಕ್ಕ ಡೊಂಗರ ಸಂವಾ ಥಾವಸ. ವಾಕಾ ರಸ್ತಾ ಸಿದಾ ಥಾವಸ. ಕೆಟ್ಟ ವಾಟೊ ಚೊ಼ಕಿಯೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ಹರಿ ಯಕ್ಲೊ ಕ್ಹುದಾ ವಚಾ಼ಡಾನು ದೆಕಸ! ಕವಾನು ವದ್ರಲ ಯಕ್ಕ ಅವಾಜ಼ ಐಕು ಆವಾಡ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ಮನಕ್ಹೊನು ಗುಂಪ ಯೊಹಾನನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈ ಲಿವಾ ಹುತಿ ಆಯಾ. ಯೊಹಾನ ತ್ಯುನೊನೆ \"ಎ ಕ್ಹಾಪೊನಿ ಜಾ಼ತ ವಾಲಾವೊ! ಅಗು ದಿಕ್ಹಾನು ಕ್ಹುದಾನಿ ಸಿಟ್ಟಕ್ಹು ವಾಚಾ಼ನಾ ಹುತಿ ತುಮೊನೆ ಹುಶಾರ ರ‍್ಹವೊ ಕೈನ ಕದಲವಾಲು ಕುನ್ನ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ತಿಮ್ಮ ಥೈಯುಮ ತುಮಾರು ಮನಸ್ಸ ಕ್ಹುದಾ ಬಗಲ ಫರ‍್ಯುಸ ಕವಾನು ತುಮೆ ಕರಾನಾ ಕಾಮೊಕ್ಹು ದೆಕಾಡಿನ ದಿವೊ. ಅಬ್ರಹಾಮ ಅಪ್ನೊ ಮುಲ ಪಿತೃ ನ್ಹವೈಸು \"ಕೈನ ತುಮೊಮಾ ಕವೈಲಿವಾಲಾ ಥಾವೊನಕೊ. ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೆ ಆ ದಗ್ಡಾವೊಕ್ಹುಬಿ ಬಚ್ಚಾ಼ ದೆತೊತೊ ಕೈನ ತುಮೆ ತಿಳದಿಲಿವೊ ವರಿ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ಝಾಡೊ ಕತ್ರಾನಿಯೊ ಕ್ವಡಲಿ ತಯಾರ ಥೈಸ. ಚೊ಼ಕು ಫಲಾ ನೈ ದಿವಾನು ಹರ ಯಕ್ಕ ಝಾಡ ಕತ್ರಿನ ಆಗಮಾ ಘಾಲಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ತಿನಾ ಹುತಿ ಮನಕ್ಹೊ\"ಹಮ್ನಾ ಹಮೆ ಸುಕರಿಯೆ? ಕೈನ ಯೊಹಾನೆನೆ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ಯೊಹಾನ, ತ್ಯುನೊನೆ \"ತುಮೊಕನ ಬೆ ಅಂಗ್ಡಾ ರ‍್ಹಯಾಮ, ವಣ್ಣಾ ನೈಸೊ ವಾಲಾನೆ ಯಕ್ಕ ಅಂಗ್ಡು ದಿವೊ. ತುಮೊಕನ ಅನ್ನ ರ‍್ಹಯುಮ, ತೆ ಅನ್ನ ವಾಟಿನ ಖಾವೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ದಕ್ಹಾ ಮನಕ್ಹೊ ಭುಭಾಡೊ ಲಿವಾಲಾ ಬಿ ಬಾಪ್ತಿಸ್ಮ ಲಿವಾ ಹುತಿ ಯೊಹಾನಕನ ಆಯಾ. ತ್ಯುನೆ ಯೊಹಾನನೆ\"ಗುರು, ಹಮೆ ಸು ಕರಿಯೆ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ಯೊಹಾನ ತ್ಯುನೊನೆ \"ತುಮೊನೆ ಕೆಕ್ಕಲು ಕದ್ಯಾಸ ತೆಕ್ಲು ಲಿವೊ ವರಿ ಹೆಚ್ಕಿ ಲಿವೊ ನಕೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ವರಿ ದಕ್ಹಾ ಸ್ಯೆನಿಕೊ ಯೊಹಾನಕನ ಐನ, ಹಮಾರಾ ಹುತಿ ಸು ಕಸಿ? ಹಮೆ ಸುಕರಿಯೆ? ಕೈನ ಪುಚ್ಯಾ. ಯೊಹಾನ ತ್ಯುನೊನೆ \"ತುಮೆ ಕಿನೆಜ಼಼ ಭುಚ್ಕಾ಼ಡಿನ ದೊಕ್ಡಾ ಕಾಳ್ಳಿವೊನಕೊ, ಕಿಪರಜ಼ ಸುಳ್ಳ ಸಾಕ್ಷಿ ಕವೊ ನಕೊ. ತುಮಾರಾ ಪಗಾರಮಾ ಖುಶಿ ರಹೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಮನಕ್ಹೊ ಆವಾನೊ ರ‍್ಹಯಲ ಕ್ರಿಸ್ತನಿ ವಾಟ ದೆಕಾಲಾ ರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೆ ಕ್ಹಾರಾ ಯೊಹಾನನಿ ವಿಷಯಮಾ \"ಎಜ಼ ಕ್ರಿಸ್ತ ವಸ \"ಕೈನ ತ್ಯುನಾ ಮನಸ್ಸಮಾ ವಿಚಾರ ಕರಿಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ಯೊಹಾನ, ತ್ಯುನೊನೆ \"ಮಿತೊ ತುಮೊನೆ ಪಾನಿಕ್ಹು ಅಂಗ ಧವೌಸ. ವರಿ ಮಾರಾತಿ ಹೆಚ್ಕಿ ತಾಕತವಾಲೊ ಆವಸ. ಮಿ ತಿನಿಯೊ ಚಪ್ಲೊನಿಯೊ ದೊರಿಯೊ ಛೊಡಾನೆಬಿ ಮಿ ಯೊಗ್ಯ ನತ್ತಿ. ತೆ ತುಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು, ಆಗಕ್ಹು ಅಂಗ ಧವಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ತೆ ಜ಼ಮಾ ರ‍್ಹಯಲ ಬಿಯ್ಯಾನೆ ಶುದ್ಧ ಕರಾನೆ ಆವಸ. ತೆ ಚೊ಼ಕಾ ಬಿಯ್ಯಾವೊನೆ ಕೊಂಡಾಕ್ಹು ಜು಼ದಾ ಕರಿನ ತಿನಾ ಗುಂಪಾಮಾ ಘಾಲಸ. ತೆ ಥಯಲಪರ ಕೊಂಡೊ ನೈ ಇಜ್ಜಾ಼ವಾನಿ ಆಗ್ಮಾ ಬಾಳಿಪಡಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ಯೊಹಾನ ಹಜು಼ನ ಘನಿಯೊ ವಿಷಯಮಾ ಮನಕ್ಹೊನೆ ಹುಶಾರ ಕರಿನ ವರಿ ತುಮಾರಿ ಜಿವ್ನಾ ಚೊ಼ಕಿ ಕರಿಲಿವೊ ಕೈನ ತ್ಯುನೊನೆ ಕೈಲಿದ್ಯೊ ವರಿ ಸುವಾರ್ತೆ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ರಾಜ್ಯಪಾಲ ಥಯಲ ಹೆರೊದ ತಿನೊ ಭೈ ಥಯಲ ಪಿಲಿಪ್ಪಿನಿ ಬೈಕೊನೆ ಹೆರೊದ್ಯ ಕವಾಲಿನೆ ಹಿವಾ ಕರಲಿದ್ಯೊತೊ. ವರಿ ಹೆರೊದ ಕರಲ ಕ್ಹಾರಾ ಕೆಟ್ಟ ಕಾಮೊಕ್ಹು ಯೊಹಾನ ತಿನೆ ಭುಚ್ಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ತಿನಾಹುತಿ ಹೆರೊದ ಯೊಹಾನನೆ ಜೆಲಮಾ ಘಲೈನ ತಿನಾ ಕೆಟ್ಟ ಕಾಮೊಮಾ ಎಬಿ ಯಕ್ಕ ಮಳೈ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ಯೊಹಾನನೆ ಜೆಲಮಾ ಘಾಲಾತಿ ಅಗ್ದುರ ಮನಕ್ಹೊ ತಿನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವಾಡಾತಾ. ತೆಳಮಾ ಯೆಸು ಐನ ತಿನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯೊ. ಯೆಸು ಪ್ರಾಥನಾ ಕರತಾಮಾ ಹಬಾಳ ಖುಲ್ಲಾ ಥೈಯು. ");
INSERT INTO sle_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ತೆಳಾಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹಹಬುತರನಾ ರುಪಮಾ ತಿಪರ ಐನ ಉತರ‍್ಯು. ತೆಳಾಮಾಜ಼ ಸ್ವರ್ಗಮಾತೊ ಅವಾಜ಼ ಆಯೊ\" ತು ಮಾರೊ ಮಯಾನೊ ದಿಕ್ರೊ ವ್ಹೈ, ಮಿ ತುನೆ ಮೆಚ್ಯೊಸ \"ಕೈನ ಅವಾಜ಼ ಆಯು. ");
INSERT INTO sle_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ಯೆಸು ಸೆವಾ ಕರಾನು ಚಾಲು ಕರ‍್ತಾಮಾ ತಿನಿ ವೈಸ 30 ವ್ಹತ್ತಿ. ಯೆಸು ಯೊಸೆಫನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಮನಕ್ಹೊ ತಿಳದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ಯೊಸೆಫ ಹೆಲಿಯಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಹೆಲಿಯಾ ಮತ್ತಾತನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮತ್ತಾತನ ಲೆವಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಲೆವಿ ಮಲ್ಕಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮೆಲ್ಕಿಯಾ ಯನ್ನಾಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯನ್ನಾಯನ ಯೊಸೆಫನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ಯೊಸೆಫ ಮತ್ತಥಿಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮತ್ತಥಿಯಾ ಆಮೊಸನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಆಮೊಸ ನಹುಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ನಹುಮನ ಎಸ್ಲಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಎಸ್ಲಿಯಾ ನಗ್ಗಾಯಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ನಗ್ಗಾಯಾ ಮಹಾಥನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮಹಾಥನ ಮತ್ತಥಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮತ್ತಥಿಯಾ ಶಿಮಿಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಶಿಮಿಯನ ಯೊಸೆಖನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೊಸೆಖ ಯುದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ಯುದ ಯೊನಾನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೊನಾನ ರೆಸನೊ ದಿಕ್ರೊ ವ್ಹೈ. ರೆಸ ಜೆರುಬಾಬೆಲನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಜೆರುಬಾಬೆಲ ಸಲಥಿಯೆಲನೊ ದಿಕ್ರೊ. ವ್ಹೈ. ಸಲಥಿಯಾ ಸೆರಿಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ಸೆರಿಯಾ ಮೆಲ್ಕಿಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮೆಲ್ಕಿಯಾ ಅದ್ದಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅದ್ದಿಯಾ ಕೊಸಾಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಕೊಸಾಮನ ಎಲ್ಮದಾಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಎಲ್ಮದಾಮನ ಎರನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ಎರನ ಯೆಹುಷುವನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೆಹೊಷುವಾ ಎಲಿಜೆಯೆರನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಎಲಿಯೆಜರ ಯೊರೈನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೊರೈಯ ಮತ್ತಾತನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮತ್ತಾತನ ಲೆವಿನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ಲೆವಿಯ ಸಿಮೆಯೊನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಸಿಮೆಯೊನ ಯುದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯುದ ಯೊಸೆಫನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೊಸೆಫ ಯೊನಾವುನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೊನಾವುನ ಎಲಕಿಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ಎಲಿಯಕಿಮನು ಮೆಲೆಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮೆಲೆಯನ ಮೆನ್ನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮೆನ್ನನ ಮತ್ತಾಥನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮತ್ತಾಥನ ನಾತಾನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ನಾತಾನನ ದಾವಿದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ದಾವಿದ ಜೆಸ್ಸಿಯಾಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಜೆಸ್ಸಿಯಾ ಒಬೆದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಒಬೆದನ ಬೊವಜನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಬೊವಜನ ಸಲ್ಮೊನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಸಲ್ಮೊನನ ನಹಸ್ಸೊನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ನಹಸ್ಸೊನನ ಅಮ್ಮಿನಾದಬನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅಮ್ಮಿನಾದಾಬ ಅದ್ಮಿನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅದ್ಮಿನನ ಅನೈರಯನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅನೈರಯ ಹೆಸ್ರೊನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಹೆಸ್ರೊನ ಪೆರೆಸನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಪೆರೆಸನ ಯುದನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ಯುದನ ಯಾಕೊಬನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯಾಕೊಬ ಇಸಾಕನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಇಸಾಕ ಅಬ್ರಹಾಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅಬ್ರಹಾಮ ತೆರೆಹನೊ ದಿಕ್ರೊ ವ್ಹೈ. ತೆರೆಹನ ನಹೊರನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ನಹೊರನ ಸೆರುಗನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಸೆರುಗನ ರೆಗುವನೊ ದಿಕ್ರೊ ವ್ಹೈ. ರೆಗುವನ ಪೆಲೆಗನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಪೆಲೆಗನ ಎಬರನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಎಬರನ ಸಾಲನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ಸಾಲನ ಕಯಿನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಕಯಿನನ ಅರಪಕ್ಷದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಅರಪಕ್ಷದನ ಶೆಮನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಶೆಮನ ನೊಹಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ನೊಹಾ ಲಾಮೆಕನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ಲಾಮೆಕನ ಮೆತುಶಲನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಮೆತುಶಲ ಹನೊಕನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಹನೊಕ ಯೆರೆದನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಯೆರೆದನ ಮಹಲಲೆಲನ ದಿಕ್ರೊ ವ್ಹೈ. ಮಹಲಲೆಲನ ಕಯಿನಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ಕಯಿನಾನ ಎನೊಶನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಎನೊಶನ ಸೆಥನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಸೆಥನ ಆದಾಮನೊ ದಿಕ್ರೊ ವ್ಹೈ. ಆದಾಮ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ಯೆಸು ಯೊರ್ದನ ನದ್ದಿಕಂತೊ ಪಾಚೊ಼ ಫರಿನ ಆಯೊ. ತೆ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಯೊತೊ. ಪವಿತ್ರ ಆತ್ಮಾ ಯೆಸುನೆ ರಾನ್ಮಾ ಚ಼ಲೈ. ");
INSERT INTO sle_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ತ್ಯಾ ಸೈತಾನ ತಿನೆ ಚಾ಼ಳಕ್ಹ ದಿನ್ನ ಶೊಧನೆಮಾ ಪಾಡ್ಯು. ತೆ ದಿನೊಮಾ ಯೆಸು ಸುಜ಼ ಖಾದ್ಯೊ ನ್ಹೊತೊ. ತೆ ದಿನೊ ಥಯಲ್ಪರ ಯೆಸುನೆ ಭುಕ್ಕ ಲಾಗಿ. ");
INSERT INTO sle_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ತೆಳಾಮಾ ಸೈತಾನ ಯೆಸುನೆ \"ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ರ‍್ಹಯೊಮ, ಆ ದಗಡಾನೆ ರೊಕ್ಲೊ ಥಾ ಕೈನ ಅಪ್ಪಣೆ ದೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ತೆ ವಾತೆ ಯೆಸು, ಸೈತಾನನೆ \"ಮನಕ್ಹ ರೊಕ್ಲೊ ಖಾದ್ಯಾಮಜ಼ ವಾಚ್ತೊ಼ ನೈ. (ಧರಮೊಪದೆಶ ಕಾಂಡ 8:3) ಕೈನ ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ಛೆತೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ತೆ ಥಯಲ್ಪರ ಸೈತಾನ ಯೆಸುನೆ ಉಚ್ಚು಼ ರ‍್ಹಯಲ ಡೊಂಗರಪರ ಬಲೈ ನಿಂಗೈನ, ಯಕ್ಕ ಕ್ಷಣಮಾ ಭುಲೊಕ್ಪರ ರ‍್ಹಯಲ ರಾಜ್ಯ ದೆಕಾಡಿನ, ");
INSERT INTO sle_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","\"ಎ ಕ್ಹಾರಿ ರಾಜ್ಯನು ಅದಿಕಾರ ತುನೆ ದ್ಯುಸ. ಎ ಕ್ಹಾರಿ ರಾಜ್ಯನಿ ಅದಿಕಾರ ಮಾರಾ ಹತ್ಮಾ ಛೆ, ವರಿ ಎ ಮಿ ಮನಸೆ ಆಯಲವಾಲಾನೆ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ತು ಮನೆ ಅಡ್ಡ ಪಾಡ್ಯೊಮ ಎ ಕ್ಹಾರು ಮಿ ತುನೆ ದ್ಯುಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ತೆ ವಾತೆ ಯೆಸು\"ತಾರೊ ಕರತಾ ಥಯಲ ಕ್ಹುದಾನೆ ಎಕ್ಕಜ಼ ಸ್ತುತಿ ಕರು, ವರಿ ತಿನೆ ಎಕ್ಕಜ಼ ಅಡ್ಡ ಪಡು ಕೈನ ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ಛೆತೊ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ಪಾಚಲ್ತೊ ಸೈತಾನ ಯೆಸುನೆ ಯೆರುಸೆಲೆಮೆ ಬಲೈ ನಿಂಗೈನ ದೆವಾಲಯನಿ ಘನ್ನಿ ಉಚ್ಚಿ಼ ರ‍್ಹಯಲ ಜ಼ಗಾಪರ ನಿಂಗೈನ ಹುಬ್ರಾಡಿನ\"ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ರ‍್ಹಯೊಮ, ನ್ಹ್ಯಾಂತೊ ಹೆಟೊ ಉಡ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","\"ಕ್ಹುದಾ ತುನೆ ವಚಾ಼ಡಾನೆ ತಿನಾ ದುತೊನೆ ಅಪ್ಪಣೆ ದಿವಸ. (ಕಿರ್ತನೆ 91:1) ");
INSERT INTO sle_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ತಾರಾ ಪಗೊನೆ ಮಂಗಾಳಾ ಲಾಗೆ ನೈಸೊ ತ್ಯುನೆ ತುನೆ ತ್ಯುನಾ ಹತೊಮಾ ಉಚೈಲಿವಸ ಕೈನ ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ಛೆತೊ! ಕದ್ಯೊ. (ಕಿರ್ತನೆ. 91:1) ");
INSERT INTO sle_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ತೆ ವಾತೆ ಯೆಸು ತಾರೊ ಕರ್ತಾ ಥಯಲ ಕ್ಹುದಾನೆ ಪರಿಕ್ಷಾ ಕರು ನೈ ಕವಾನು ಮೊಶೆನಾ ಧರಮ ಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ಛೆತೊ ಕದ್ಯೊ. (ಧರಮೊಪದೆಶ ಕಾಂಡ 6:16) ");
INSERT INTO sle_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ಸೈತಾನ ಯೆಸುನೆ ಎ ಕ್ಹಾರಿ ಪರಿಕ್ಷಾ ಲಿನ ಪಾಚಲ್ತೊ ಯೆಸುನೆ ದಕ್ಹೊ ಟೈಮ ಲಕ್ಕಾ ತ್ಯಾಂತೊ ಛೊಡಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ಯೆಸು ಪವಿತ್ರ ಆತ್ಮಾನಿ ತಾಕತ ಕ್ಹು ಭರಿನ ಗಲಿಲಾಯನೆ ಫರಿನ ಗಯೊ. ಯೆಸುನಿ ಸುದ್ದಿ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯನಾ ಮನಕ್ಹೊಮಾ ಗ್ವತ್ತ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ಯೆಸು ಸಭಾಮಂದಿರಮಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾನು ಶುರು ಕರ‍್ಯೊ. ತೆ ಐಕಲ ವಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಘನ್ನಾ ನೆಣಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ಯೆಸು ತೆ ಮ್ಹೊಟೊ ಥಯಲ ನಜ಼ರೆತೆ ಕವಾನಾ ಗಾಮೆ ಐನ ಸಬ್ಬತ ದಿನಮಾ ಸಭಾಮಂದಿರಮಾ ಗೈನ. ತ್ಯುನಿಯೊ ಪದ್ದತಿ ಲಿಂಗತ ಯೆಸು ಒದಾನಾ ಹುತಿ ಉಟಿನ ಹುಬ್ರಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯಾ ಬರ್ದಲ ಪುಸ್ತಕ ಯೆಸುನೆ ಒದಾನೆ ದಿದ್ಯಾತಾ. ಯೆಸು ತೆ ಬುಕ್ಕಕಮಾನು ಒದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಮಪರ ಛೆ. ಗರಿಬ ಮನಕ್ಹೊನೆ ಚೊ಼ಕಿ ಸುದ್ದಿ ಕವಾ ಹುತಿ. ಕ್ಹುದಾ ಮನೆ ಅಭಿಶೆಕ ಕರ‍್ಯೊಸ. ಪಾಪ ಕವಾನಿ ಯಕ್ಕ ಜೆಲಮಾ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಮನಕ್ಹೊನೆ ಛೊ಼ಡಾವಾನೆ ವರಿ ಕುಡ್ಡಾವೊನೆ, ಡೊಳಾ ದಿವಾನೆ ವರಿ ತ್ಯುನೊನೆ ಚೊ಼ಕಿ ಸ್ತಿತಿನಾ ಹುತಿ ಮನಸ ಭಗೈ ಗಯಲವಾಲಾವೊನಾ ಹುತಿ ತ್ಯುನು ಮನಸ ಚೊ಼ಕು ಕರಾಹುತಿ. ಮನೆ ಕ್ಹುದಾ ಮೊಕ್ಕಲ್ಯೊಸ\" ");
INSERT INTO sle_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ವಚಾ಼ಡಾನೆ ನೆಮಿಸಲ ಚೊ಼ಕೊ ವರಕ್ಹ ಲಾವಾನಾ ಹುತಿ ಮನೆ ವಳಾಯೊಸ\" ");
INSERT INTO sle_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ತೆ ಒದಲ್ಪರ ಯೆಸು ತೆ ಯೆಶಾಯನು ಗ್ರಂಥ ಸುತ್ತಿನ ಸಬಾಮಂದಿರನಾ ಆಳನಾ ಹತ್ಮಾ ದಿನ್ನ ತ್ಯಾ ಬೈಟ್ಯೊ. ಸಬಾಮಂದಿರಮಾ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಯಕ್ಕ ಸಂವಾ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ತೆಳಾಮಾ ಯೆಸು, ತ್ಯುನೊನೆ \"ಮಿ ಹಮ್ನಾ ಒದಲ ವಾಕ್ಯಾ ಆಜ಼ ಕ್ಹರಿಮಾಜ಼ ಎ ಪುರಾ ಥಯ್ಯು\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತಿನೆ ಘನ್ನೊ ಚೊ಼ಕೊ ವ್ಹೈಕದ್ಯಾ. ತ್ಯುನೆ ತಿನಿಯೊ ಚೊ಼ಕಿಯೊ ವಾತೊ ಐಕಿನ ಘಾಬ್ರಾಥೈನ\"ಎ ಇಮ್ಮ ಕಿಮ ಬೊಲಾನೆ ಸಾದ್ಯ ಛೆ? ಎ ಯೊಸೆಫನೊ ದಿಕ್ರೊ ನ್ಹ ವ್ಹೈ ಸು? ಕೈನ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ಯೆಸು ತ್ಯುನೊನೆ\"ತುತೊ ಡಾಕ್ಟರ ವ್ಹೈ, ಪೈಲಾ ತುನೆ ಅರಾಮ ಕರಲೆ \"ಪೈಲಾನಿ ಗಾದೆ ಮನೆ ಕವೊಸಿ ಕವಾನು ಮನೆ ಗೊತ್ತ ಛೆ\" ತು ಕಪೆರನೌರ್ಮಿಮಾ ಕರಲ ದಕ್ಹಾ ಕಾಮೊ ತಾರಾ ಹುತಿ ಐಕ್ಯಾಸ. ತೆಜ಼ ಕಾಮೊ ತಾರಾ ಸ್ವಂತ ಗಾಮ್ಮಾ ಕರ\" ಕೈನ ಕವಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ. ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ ಪ್ರವಾದಿನೆ ತಿನಾ ಸ್ವಂತ ಗಾಮ್ಮಾ ನೈ ಮಳೈಲೆತಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ಐಕೊ ಎಲಿಯಾನಾ ಕಾಲಮಾ ಕ್ಹಡಾತನ ವರಕ್ಹ ಇಸ್ರಾಯೆಲ ದೆಶಮಾ ಪಾನಿ ಐಯು ನ್ಹೊತು. ತೆಜ಼ ದೆಶಮಾ ಬರಗಾಲ ವ್ಹತ್ತು. ತೆ ಟೈಮಾ ಇಸ್ರಾಯೆಲಮಾ ರಾಂಡಿ ಬಾಕಡಿಯೊ ಘನ್ನಿಯೊ ವ್ಹತ್ತಿಯೊ ಕವಾನು ಕ್ಹರಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ತೆನೈಸೊ ಎಲಿಯಾನೆ ಬಿಜಿ಼ಯೊ ರಾಂಡಿ ಹೆಣ ಮನಕ್ಹೊಕನ ಮೊಕ್ಕಲ್ಯಾ ವಾಚಿ ಸಿದೊನ ದೆಶನೆ ಮಳಲ ಸೆರೆಪ್ತ ಗಾಮ್ಮಾ ರ‍್ಹಯಲ ಯಕ್ಕ ರಾಂಡಿ ಹೆಣ ಮನಕ್ಹಕನ ಕ್ಹುದಾ ಎಲಿಯಾನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ಪ್ರವಾದಿ ಥಯಲ ಎಲಿಶಾನಾ ಕಾಲ್ಮಾ ಘನ್ನಾ ಕುಸ್ಟರೊಗಿಯೊ ಇಸ್ರಾಯೆಲಮಾ ವ್ಹತ್ತಾ. ತೆನೈಸೊ ತ್ಯುನೊಮಾನಾ ಕಿನೆಜ಼಼ ಅರಾಮ ಥಯಾವಾಚಿ ಸಿರಿಯಾ ದೆಶವಾಲೊ ಥಯಲ ನಾಮಾನನೆ ಯಕ್ಕಜ಼ ಅರಾಮ ಥಯ್ಯು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ಸಬಾಮಂದಿರಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಎ ವಾತೊ ಐಕಿನ ಘನ್ನಾ ಶಿಟ್ಟಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ಯೆಸುನೆ ಗಾಮ್ತಾ ಭಾರಾ ಘಾಲ್ಯಾ. ತೆ ಗಾಮ ಯಕ್ಕ ಡೊಂಗರಪರ ವ್ಹತ್ತು. ತ್ಯುನೆ ಯೆಸುನೆ ತ್ಯಾಂತಾ ಬಲೈನಿಂಗೈನ ಡೊಂಗರಪರತಾ ಢಕ್ಲಿಪಾಡಿಯೆ ಕೈನ ಕೈಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನಾ ವಚ್ಮಾ಼ತೊ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ತ್ಯಾಂತೊ ಯೆಸು ಗಲಿಲಾಯನಾ ಕಪೆನೌರ್ಮಿ ಕವಾನಾ ಗಾಮೆ ಗಯೊ. ತ್ಯಾ ಸಬ್ಬತ ದಿನಮಾ ತ್ಯುನೊನೆ ಉಪದೆಶ ಕರಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ತಿನೆ ಕ್ಹಾರು ಅದಿಕಾರ ರಹೆವಾಲಾ ಲಿಂಗತ ಕವಾಡೊತೊ. ತ್ಯುನೆ ತೆ ವಾತೆ ಘನ್ನಾ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ತೆ ಸಬಾಮಂದಿರಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಯಕ್ಕ ದಾಣಗೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ತೆ ಯೆಸುನೆ ದೆಕಿನ ಜೊ಼ರ ವದ್ರಿನ ನಜ಼ರೆತನಾ ಯೆಸು! ಮಾರಿ ಉಸಾಬರಿ ತುನೆ ಕಾ? ಹಮೊನೆ ನಾಶಕರಾನೆ ಆಯೊಸು? ತುನೆ ವಳಕ್ಯೊಸ. ತು ಕ್ಹುದಾ ವಳಾಯಲ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕದ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ವರಿ ಯೆಸು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನೆ \"ಗಪ ರ‍್ಹೆ! ಇನೆ ಛೊಡಿನ ಭಾರು ಆ\" ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತೆ ದಾಣಗಾನಾ ಹೆಟು ಪಾಡಿನ ಸುಜ಼ ತರಾಸ ಕರ‍್ಯಾ ವಾಚಿ ತಿನೆ ಛೊಡಿನ ಗೈಪಡಿ. ");
INSERT INTO sle_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ತೆ ದೆಕಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ\"ಎ ಕೆಯ್ಯೊ ವಾತೊ ವ್ಹಸೆ! ತೆ ಅದಿಕಾರಕ್ಹು ವರಿ ತಾಕತಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಅಪ್ಪಣೆ ದೆತಾಮಾ, ತೆ ಗೈ ಪಡಸ್ತೊ \"ತ್ಯುನೊಮಾ ಕೈನ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ವರಿ ತಿಮ್ಮ ಥೈನ ಯೆಸುನಿ ಸುದ್ದಿ ತೆ ಪ್ರಾಂತ್ಯಮಾ ಘನ್ನಿ ಜ಼ಗಾ ಗ್ವತ್ತ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ಯೆಸು ಸಬಾಮಂದಿರಮಾತೊ ಗೈನ ಸಿಮೊನನಾ (ಪೆತ್ರಾ) ಘರೆ ಆಯೊ. ತ್ಯಾ ಶಿಮೊನನಿ ಫ್ಯೆ ತೌ ಐನ ಕ್ಹುರೈತಿ ತಿನೆ ಅರಾಮ ಕರ ಕೈನ ಯೆಸುಕನ ತ್ಯಾ ರ‍್ಹಯಲವಾಲಾ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ಯೆಸು ತಿಕನ ಗೈನ ತಿನಾ ಜಡ್ಡನೆ ಭುಚ್ಕಾ಼ಡ್ಯೊ ತೆಳಾಮಾ ಸಿಮೊನನಿ ಫ್ಯೆ ಅರಾಮ ಥೈ. ತಿನಾ ಹುತಿ ತೆ ಉಟಿನ ತ್ಯುನೊನೆ ಸೆವಾ ಕರಿ. ");
INSERT INTO sle_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ಸುರ‍್ಯೊ ಡುಬಲ್ಪರ, ಕಿನಾ-ಕಿನಾ ಘರಮಾ ತರಾ ತರಾನಾ ರೊಗ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಯೆಸುಕನ ಲಾಯಾ. ತೆ ರೊಗಿಯೊಪರ ಯೆಸು ತಿನೊ ಹತ್ತ ಮ್ಹೆಲಿನ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ಘನ್ನಾ ಮನಕ್ಹೊನಾ ಅಂಗಮಾತಾ ಕೆಟ್ಟ ಆತ್ಮಾ ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಜೊ಼ರ ವದ್ರಿನ ತ್ಯುನಾ ಅಂಗಮಾತಾ ಭಾರಾ ಆಯಾ ಯೆಸು ತ್ಯುನೊನೆ ಬೊಲೊ ನಕೊ ಕೈನ ಕದ್ಯೊ. ಕಾಕದ್ಯಾಮ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಯೆಸುಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಗೊತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ಮರ್ನಾ ದಿನ್ನೆ ಪಾಟೆ ಯೆಸು ಕುನ್ನಜ಼ ನೈಸೊ ರ‍್ಹಯಲ ಜ಼ಗಾ ಯೆಸು ಗಯೊ. ಮನಕ್ಹೊ ಗುಂಪ-ಗುಂಪ ಥೈನ ತಿನೆ ಹುಡಕ್ತಾ ತೆ ರ‍್ಹಯಲ ಜ಼ಗಾ ಐನ ತು ಹಮೊನೆ ಛೊಡಿನ ಜೌ಼ ನಕೊ ಕೈನ ತಿನಾ ಸುತ್ತೆ ಹುಬ್ರಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ವರಿ ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಿ ಸುವಾರ್ತೆ ಬಿಜಾ಼ ಗಾಮೊಮಾಬಿ ಕೌ ಇನಾ ಹುತಿಜ಼ ಮಿ ಆಯೊಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಯುದಾಯ ದೆಶನಾ ಸಬಾಮಂದಿರೊಮಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ಯಕ್ಕ ದಿನ್ನ ಯೆಸು ಗೆನೆಜರೆತ ಕವಾನಾ (ಗಲಿಲಾಯ) ನದಿನಾ ದಂಡಿಕನ ಹುಬ್ರೈಲ ಟೈಮಾ, ಮನಕ್ಹೊ ಯಕ್ಕಪರ ಯಕ್ಕ ಢಕಲ್ತಾ ತ್ಯಾ ಯೆಸುನಾ ಸುತ್ತೆ ಐನ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ಯೆಸು ನದಿನಾ ದಂಡಿಕನ ಬೆ ಹಡಗಾ ದೆಕ್ಯೊ. ಹಡಗಾಮಾ ರ‍್ಹಯಲ ಮಚ್ಲಿ಼ಯೊ ಧರಾಲಾ ಭಾರಾ ಐನ ತ್ಯುನಿಯೊ ಬಲಿಯೊ ಧವಾಡ್ಯತಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ಯೆಸು ಸಿಮೊನನೊ ಹಡ್ಗೊ ಚ಼ಡಿನ ಬೈಟ್ಯೊ ವರಿ ಹಡಗಾನೆ ದಂಡಿತೊ ನಕ್ಕರ ದುರ ಢಕಲ ಕೈನ ಯೆಸು ಸಿಮೊನನೆ ಕದ್ಯೊ. ವರಿ ಯೆಸು ಹಡಗಾಪರ ಬೈಟಿನ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ಉಪದೆಶ ಕರಲ್ಪರ ಯೆಸು ಸಿಮೊನನೆ ಹಡಗಾನೆ \"ಉಂಡು ರ‍್ಹಯಲ ಜ಼ಗಾ ನಿಂಗೈನ. ಮಚ್ಲಿ಼ಯೊ ಧರಾಹುತಿ ತುಮಾರಿಯೊ ಬಲಿಯೊ ಪಾನಿಮಾ ಘಾಲೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ತೆಳಾಮಾ ಸಿಮೊನ, ಯೆಸುನೆ \"ಗುರು, ಹಮೆ ಕ್ಹಾರಿ ರಾತ ಕಷ್ಟಪಡದ್ಯಾತಬಿ ಯಕ್ಕ ಮಚ್ಲಿ಼ಬಿ ಮಳಿ ನೈ. ವರಿ ತು ಕದಲ ಹುತಿ ಹಮೆ ಬಲಿ ಪಾನಿಮಾ ಘಾಲಾಡ್ಯಾಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ತ್ಯುನೆ ತ್ಯುನಿಯೊ ಬಲಿಯೊ ಪಾನಿಮಾ ಘಾಲ್ತಾಮಾ ತ್ಯುನಿಯೊ ಬಲಿಯೊ ಫಾಟಿ ಜಾ಼ವಾಯಕ್ಲಿಯೊ ಮಚ್ಲಿ಼ಯೊ ಢಿಗ ಗಟ್ಳೆ ಮಳಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ತೆಳಾಮಾ ತ್ಯುನೆ ಬಿಜೆಕ ಹಡಗಾಮಾ ರ‍್ಹಯಲ ತ್ಯುನಾ ದೊಸ್ತೊನೆ ಹತೊಕ್ಹು ಸ್ವನ್ನಿ ಕರಿನ ಬಲಾಯಾ ತ್ಯುನಾಬಿ ಬೆ ಹಡಗಾ ಮಚ್ಲಿ಼ಯೊ ಭರಿನ ಡುಬಾವರಖಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ಸಿಮೊನ ಯೆಸುನಾ ಖಾಮೊ ಉಂದಾಗುಡ್ಗಾ ಘಾಲ್ಲಿನ ಪಗೆ ಪಡಿನ \"ಸ್ವಾಮಿ, ಮಿ ಪಾಪಿ ವ್ಹೈ. ಮನೆ ಛೊಡಿನ ಜಾ಼ \"ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ಕ್ಹಾರಾ ಮಚ್ಲಿ಼ಯೊ ಧರಾಲಾ ಘಾಬ್ರಾಥಯಾ. (ಇವ್ನೆ ಭಂಬಿಜ಼ನಾ ಸಿಮೊನನಾ ಕ್ಹಾತೆ ವಾಟೊಲಿವಾಲಾ ವ್ಹತ್ತಾ) ");
INSERT INTO sle_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ಎ ದೆಕಿನ ಜೆಬೆದಾಯನಾ ದಿಕ್ರಾ ಥಯಲ ಯಾಕೊಬ ವರಿ ಯೊಹಾನ ಘಾಬ್ರಾಥಯಾ. ಯೆಸು ಸಿಮೊನನೆ\"ಭುಚ಼ಕುನಕೊ. ಆಜ಼ತೊಜ಼ ತು ಮಚ್ಲ್ಯೊ಼ ಧರಾಲೊ ನ್ಹವೈ. ವರಿ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾಕನ ಲಾವಾಲೊ ಥಾಸಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ತ್ಯುನೆ ತ್ಯುನಾ ಹಡಗಾ ದಂಡಿಯೆ ಲೈನ ಭಾಂದಿನ. ಕ್ಹಾರು ಛೊಡಿನ ಯೆಸುನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ಯಕ್ಕ ದಿನ್ನ ಯೆಸು ಯಕ್ಕ ಗಾಮ್ಮಾ ರ‍್ಹತಾಮಾ ಯಕ್ಕ ಕುಷ್ಟರೊಗಿ ಯೆಸುನೆ ದೆಕಿನ ತಿನಾ ಕ್ಹಾಮೊ ಉಂದಾ ಗುಡ್ಗಾ ಘಾಲ್ಲಿನ ಅಡ್ಡಪಡಿನ \"ಪ್ರಭು, ತು ಮನಸ್ಸ ಕರ‍್ಯೊಮ ಮನೆ ಅರಾಮ ಕರಶಿ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ಯೆಸು\"ತಿನೆ ತುನೆ ಅರಾಮ ಕರಾನೆ ಮನೆ ಮನಸ್ಸೆ ಛೆ ತುನೆ ಅರಾಮ ಥಾವಾದೆ\" ಕೈನ ತಿನೆ ಮುಟ್ಯೊ ತೆಳಾಮಾಜ಼ ತಿನೆ ಅರಾಮ ಥಯ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ಯೆಸು ತಿನೆ, ಎ ಕ್ಹಾರು ತಾರಾ ಖಾಮು ಥಯಲ ಅದ್ಭುತ ಕಿಕನಜ಼ ಕೌ ನಕೊ, ತೆನೈಸೊ ತು ಗೈನ ಸಾಕ್ಷಿ ಥಾವಾನಾ ಹುತಿ ಯಾಜಕನೆ ತಾರು ಅಂಗ ದೆಕಾಡಿನ ಮೊಶೆ ನಿಯಮ ಕರಲ ಶುದ್ಧವಿಚಾರೊ ಪುರಾಕರ ಕೈನ\"ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ಗಾಮ್ಮಾ ಯೆಸುನಿ ಸುದ್ದಿ ಘನ್ನಿ ಫೈಲಿ ಗೈ. ಘನ್ನಾ ಮನಕ್ಹೊ ತಿನಿಯೊ ವಾತೊ ಐಕು ಕೈನ ತ್ಯುನಾ ರೊಗೊ ಗೈನ ಅರಾಮ ಥಾವು ಕೈನ ತಿಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ತೆಳಾಮಾ ಯೆಸು ಯಕ್ಕಲೊಜ಼ ಕುನ್ನಜ಼ ನೈಸೊ ರ‍್ಹವಾನ ಜ಼ಗಾ ಗೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ಯಕ್ಕ ದಿನ್ನ ಯೆಸು ಮನಕ್ಹೊನೆ ಭೊದನೆ ಕರಾಡೊತೊ. ತ್ಯಾಜ಼ ಗಲಿಲಾಯ ಪ್ರಾಂತ್ಯತಾ ವರಿ ಯುದೆಯ ಯೆರುಸೆಲಿಮತಾ ಆಯಲ ಫರಿಸಾಯರೊ ವರಿ ನಿಯಮೊನಾ ಶಾಸ್ತ್ರಿಯೊ ತ್ಯಾ ವ್ಹತ್ತಾ. ರೊಗೊ ಅರಾಮ ಕರಾನಿ ಕರ್ತಾನಿ ತಾಕತ ಯೆಸುಮಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಯಕ್ಕ ಲಕ್ವೊ ಮಾರಲವಾಲಾ ರೊಗಿನೆ ದಕ್ಹಾ ಜ಼ನಾ ವಚ್ಚಾ಼ನಾ ಕ್ಹಮಾತಾಜ಼ ಉಚೈನ ಯೆಸು ರ‍್ಹಯಲ ಜ಼ಗಾ ಲಾವಾನೆ ಕೊಶಿಶ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ವರಿ ತ್ಯಾ ಘನ್ನಾ ಮನಕ್ಹೊನು ಕುಡಿನ ಯೆಸುನಾ ಸುತ್ತೆ ರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೊನೆ ತೆ ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ಯೆಸುಕನ ನಿಂಜಾ಼ವಾನೆ ನೈ ಥಯಲ ಹುತಿ ತ್ಯುನೆ ಘರಪರ ನಿಂಗೈನ ಘರಪರಲ್ಯು ಛತ್ತ ಕಾಡಿನ ತೆ ರೊಗಿನೆ ವಚ್ಚಾ಼ನಾ ಕ್ಹಮಾತಾಜ಼ ಯೆಸುನಾ ಕ್ಹಾಮಾ ಉತಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ಯೆಸು ತಿವ್ನೊ ಬರೊಕ್ಹೊ ದೆಕಿನ ತೆ ರೊಗಿನೆ, ಮಾರಾ \"ದೊಸ್ತ ತಾರು ಪಾಪ ಮಾಫ ಥಯುಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ತ್ಯಾ ರ‍್ಹಯಲವಾಲಾ ಶಾಸ್ತ್ರಿಯೊ ಫರಿಸಾಯರೊ. ತೆ ಐಕಿನ \"ಎ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ಬೊಲಾಲೊ ಕುನ್ನ ವ್ಹೈ? ಕ್ಹುದಾನೆ ಯಕ್ಲಾನೆಜ಼ ಪಾಪ ಮಾಫ ಕರಾನೆ ಥಾವಸ \"ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ವಿಚಾರ ಕರಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ವರಿ ಯೆಸು ತ್ಯುನಿಯೊ ವಿಚಾರೊ ತಿಳದಿಲಿನ ತ್ಯುನೊನೆ\"ತುಮೆ ತಮಾರಾ ಮನಸ್ಮಾ ಇಮ್ಮ ಕಾ ವಿಚಾರ ಕರಲಿವಾಡ್ಯಾಸ? ");
INSERT INTO sle_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ಕಯು ಆಸಾನ ವ್ಹೈ? ತಾರು ಪಾಪ ಮಾಫ ಥಯುಸ, ಕೈನ ತೆ ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ಕವಾನು? ನೈತೊ ಉಟಿನ ಜಾ಼ ಕವಾನು? ");
INSERT INTO sle_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ತೆನೈಸೊ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಭುಲೊಕ್ಪರ ಪಾಪ ಮಾಫ ಕರಾನೆ ಅದಿಕಾರ ಛೆ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹೌ ಕೈನ \"ತೆ ಲಕ್ವೊ ಮಾರಲವಾನೆ ದೆಕಿನ\"ಉಟ! ತಾರು ವಚ್ಚಾ಼ನು ಲಿನ ಘರೆ ಜಾ಼\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ತೆಳಾಮಾಜ಼ ತೆ ಲಕ್ವೊ ಮಾರಲವಾಲೊ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಉಟಿನ ಹುಬ್ರಯೆನ, ತಿನು ವಚ್ಚಾ಼ನು ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರತೊ ತಿನಾ ಘರೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ತೆಳಾಮಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಘನ್ನಾ ಘಾಬ್ರಾ ಥೈನ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರತಾ ವರಿ ಭುಚ಼ಕ್ಕತಾ\"ಆಜಾ಼ನಾ ದಿನಮಾ ಹಮೆ ಯಕ್ಕ ಅದ್ಭುತ ದೆಕ್ಯಾ\"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ಪಾಚಲ್ತೊ, ಯೆಸು ತ್ಯಾಂತೊ ಜಾ಼ತಾಮಾ, ಭುಭಾಡೊಲಿವಾಲೊ ಕಟ್ಟಾಪರ ಬೈಟಲವಾಲೊ ಲೆವಿನೆ ದೆಕಿನ \"ತು ಮಾರಾ ಪಾಚೊ಼ ಆ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ಲೆವಿ ಉಟಿನ ಕ್ಹಾರು ತ್ಯಾಜ಼ ಛೊಡಿನ ಯೆಸುನಾ ಪಾಚೊ಼ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ಪಾಚಲ್ತೊ ಲೆವಿ ಯೆಸುನಾ ಹುತಿ ತಿನಾ ಘರಮಾ ಖಾವಾನೆ ಮ್ಹೊಟು ಫಂಕ್ಷನ ಕರಾಯೊ ತೆಳಾಮಾ ಭುಭಾಡೊಲಿವಾಲಾ ಘನ್ನಾ ಜ಼ನಾ ವರಿ ಘನ್ನಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ತೆಳಾಮ ಫರಿಸಾಯರೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಯೆಸುನಾ ಶಿಷ್ಯಾವೊನೆ \"ತುಮೆ ಭುಭಾಡೊಲಿವಾಲಾವೊನಾ ಕ್ಹಾತೆ ವರಿ ಪಾಪಿಯೊನಾ ಕ್ಹಾತೆ ಕಾ ಅನ್ನ ಖಾವಾಡ್ಯಾಸ ವರಿ ಪಿವಾಡ್ಯಾಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ತೆಳಾಮಾ ಯೆಸು ತೆ ಐಕಿನ ಅರಾಮ ನೈಸೊವಾಲಾನೆ ಡಾಕ್ಟರನಿ ಜ಼ರುರತ ಛೆ ಅರಾಮ ರ‍್ಹಯಲವಾಲಾವೊನಾ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ತುಮಾರಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾಬಗಲ ಫರೊ ಕೈನ ನಿತಿವಂತಕ್ಹು ರ‍್ಹಯಲವಾಲಾವೊನಾ ಮಿ ಬಲಾವಾನೆ ನತ್ತಿ ಆಯೊ. ಪಾಪಿಯೊನಾ ಹುತಿ ಆಯೊಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ದಕ್ಹಾ ಮನಕ್ಹೊ ಯೆಸುನೆ\"ಫರಿಸಾಯರೊನಾ ಶಿಷ್ಯಾ ವರಿ ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಹಗ್ಲೆಲ್ಲಾ ಉಪಾಸ ವರಿ ಪ್ರಾಥನಾ ಕರಸ; ವರಿ ತಾರಾ ಶಿಷ್ಯಾ ಖಾವಾಡ್ಯಾಸ ಪಿವಾಡ್ಯಾಸ ಕೈನ ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ಯೆಸು ತ್ಯುನೊನೆ \"ನೌರೊ ಹಿವಾನಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ರ‍್ಹಯೆಲಕ್ಕಾ ತ್ಯುನೆ ಭುಕ್ಕಾ ಜಾ಼ವಸು? ");
INSERT INTO sle_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ವರಿ ನೌರಾನೆ ತ್ಯುನೊಕಂತೊ ನಿಂಜಾ಼ವೊನೊ ಟೈಮ ಆವಸ ತೆಳಾಮಾ ತ್ಯುನೆ ವಂದತ ಕರಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ಪಾಚಲ್ತೊ ಯೆಸು ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ತೆ ಸುವೈ ಕದ್ಯಾಮ \"ಕುನ್ನಬಿ ಜು಼ನ್ನಾ ಅಂಗ್ಡಾನೆ ಥಿಗ್ಡು ಲಗಾಡಾ ಹುತಿ ನವಾ ಅಂಗ್ಡಾನೆ ಪ್ಹಾಡ್ತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ತಿನಾಲಿಂಗತಜ಼ ನೌ (ನವು) ದ್ರಾಕ್ಷಿಯೊನೊ ರಕ್ಹ ಜು಼ನ್ನಿಯೊ ದ್ರಾಕ್ಷಿಯೊನಿ ರಕ್ಹನಿಯೊ ಚಾ಼ಮ್ಡಾನಿ ಕೈಚಿಲಾವೊಮಾ ಭರಿನ ಮುಕ್ಕತಾ ನೈ. ವರಿ ಭರಿನ ಮ್ಹೆಲ್ಯಾಮ ನೌ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ತೆ ಜು಼ನ್ನಿಯೊ ಚಾ಼ಮ್ಡಾನಿ ಕೈ ಚಿಲಾವೊನೆ ಫಾಡಿನ ಹೆಟು ಪಡಿನ ಕೆಟ್ಟಿ ಜಾ಼ವಸ, ವರಿ ಕೈಚಿಲಾ ಹಾಳ ಥೈ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ಮನಕ್ಹೊ ನೌ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ನೈಯೊ ಚ಼ಾಮ್ಡಾವೊನಿ ಕೈಚಿಲಾವೊಮಾ ಭರಿನ ಮ್ಹೆಲಸ. ");
INSERT INTO sle_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ಜು಼ನ್ನು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿದಲವಾಲೊ ನೌ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹನಿ ಸ್ವಾದ ಗೊತ್ತ ಥಾತು ನೈ. ತೆ ಮನಕ್ಹ ಜು಼ನ್ನು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ನೆಜ಼ ಪಸಂದ ಕರಸ\" ");
INSERT INTO sle_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ಯಕ್ಕ ಸಬ್ಬತ ದಿನಮಾ ಯೆಸು ಖೆತ್ರೊಮಾತೊ ಜಾ಼ತಾ ಟೈಮಾ ತಿನಾ ಶಿಷ್ಯಾ ಖೆತ್ರೊಮಾನಾ ಬುಟ್ಟಾ ಭಾಗಿಲಿನ ಹತೊಕ್ಹು ತಿಕ್ಕಿನ ಖಾತಾ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ತೆಳಾಮಾ ಪರಿಸಾಯರೊ ಯೆಸುನೆ\"ತುಮೆ ಸಬ್ಬತ ದಿನಮಾ ನೈಸೊ ಕರಾನು ಕಾಮ ಕರಾಡಾಸ್ತೊ? ಎ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನಾ ವಿರುದ್ದ ವ್ಹೈ \"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ತೆ ವಾತೆ ಯೆಸು, ಫರಿಸಾಯರೊನೆ \"ದಾವಿದ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯೆಲವಾಲಾವೊನೆ ಭುಕ್ಕಕಲಾಗಲ ಟೈಮಾ ತೆ ಸುಕರ‍್ಯೊ ಕೈನ ತುಮೆ ಒದ್ಯಾ ನತ್ತಿಸು? ");
INSERT INTO sle_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ದಾವಿದ ಕ್ಹುದಾನಿ ಸನ್ನಿದಿಮಾ ಗೈನ ಕ್ಹುದಾನೆ ಚ಼ಡಾಯಲ ರೊಕ್ಲೊ ಯಾಜಕನೆ ಛೊಡಿನ ಬಿಜು಼ ಕುನ್ನಜ಼ ನೈಸೊ ಖಾವಾನೊ ರೊಕ್ಲೊ ದಾವಿದ ಖೈನ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಖಲಾಯೊಸ್ತೊ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಸಬ್ಬತ ದಿನ್ಪರ‍ ಮಾಲಕ ಥಯೊಸ \"ಕೈನ ಯೆಸು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ವರಿ ಯಕ್ಕ ಸಬ್ಬತ್ ದಿನಮಾ ಯೆಸು ಸಬಾಮಂದಿರಮಾ ಗೈನ ಉಪದೆಶ ಕರ‍್ತಾಮಾ ತ್ಯಾ ಯಕ್ಲೊ ದಾಣಗೊ ಸಿದಾ ಹತ ಕುಕ್ಹೈ ಗಯಲವಾಲೊ ತ್ಯಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ಯೆಸು ತಿನೆ ಸಬ್ಬತ್ ದಿನಮಾ ಅರಾಮ ಕರ‍್ಯೊಮ ತಿಪರ ತಪ್ಪ ಘಾಲಿಯೆ ಕೈನ ಫರಿಸಾಯರೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಟೈಮ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ವರಿ ತ್ಯುನಿ ವಿಚಾರ ಯೆಸುನೆ ತಿಳದಿತಿ. ಯೆಸು ಹತ ಕುಕ್ಹೈ ಗಯಲವಾಲಾನೆ\"ತು ಐನ ನ್ಹಾ ಹುಬ್ರೆ \"ಕದ್ಯೊ. ತೆ ಉಟಿನ ಐನ ಹುಬ್ರಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ\"ಸಬ್ಬತ ದಿನಮಾ ಕಯು ಕಾಮ ಕರಾನು ಚೊ಼ಕು ವ್ಹೈ? ಚೊ಼ಕು ಕಾಮ ಕರಾನು ಸು ಕೆಟ್ಟಕಾಮ ಕರಾನು ಚೊ಼ಕು ವ್ಹೈ? ಜ಼ಲಮ ವಚಾ಼ಡಾನು ಸು? ಜ಼ಲಮ ಕಾಡಾನು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ಯೆಸು ತಿನಾ ಸುತ್ತೆ ಹುಬ್ರಯಲವಾಲಾವೊನೆ ದೆಕಿನ, ತೆ ಮನಕ್ಹನೆ, ಯೆಸು \"ತಾರೊ ಹತ ಅಗೊ ಕರ\" ಕದ್ಯೊ. ತೆ ತಿನೊ ಹತ ಅಗೊ ಕರ‍್ಯೊ. ತೆಳಾಮಾಜ಼ ತಿನೊ ಹತ ಅರಾಮ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ಫರಿಸಾಯರೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಘನ್ನಾ ಶಿಟ್ಟ ಥೈನ. ತ್ಯುನೆ \"ಅಪೆ ಕೈ ಉಪಾಯಕ್ಹು ಯೆಸುನೆ ಸು ಕರಿಯೆ? ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. (ಪ್ಯ್ಲಾನ ಕರಾಡಾತಾ) ");
INSERT INTO sle_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ಯಕ್ಕ ದಿನ್ನ ಪ್ರಾಥನಾ ಕರಾ ಹುತಿ ಯೆಸು ಡೊಂಗರಪರ ಗೈನ ಕ್ಹಾರಿ ರಾತ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ಮರ್ನಾ ದಿನ್ನೆ ಪಾಟೆ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಬಲೈನ ತ್ಯುನೊಮಾನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ ಇನಿಲಿನ ತ್ಯುನೊನೆ ಅಪೊಸ್ತಲೊ ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ತ್ಯುನೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ಸಿಮೊನನೆ (ಯೆಸು ಪೆತ್ರಾ ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯೊ) ವರಿ ತಿನೊ ಭೈ ಥಯಲ ಅಂದ್ರೆಯ, ಯಾಕೊಬ, ವರಿ ಯೊಹಾನ, ಫಿಲಿಪ್ಪ ವರಿ ಬಾರ್ತೊಲೊಮಾಯ, ");
INSERT INTO sle_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ಮತ್ತಾಯ ತೊಮ, ಯಾಕೊಬ (ಅಲ್ಫಾಯನೊ ದಿಕ್ರೊ) ವರಿ (ದೆಶಪರ ಮಯಾ ರ‍್ಹಯಲ ವಾಲೊ) ಸಿಮೊನ, ");
INSERT INTO sle_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ಯುದ ಯಾಕೊಬನೊ ದಿಕ್ರೊ ವರಿ ಇಸ್ಕರಿಯುತ ಯುದ (ಯೆಸುನೆ ಧರೈನ ದಿದಲ ವಾಲೊ) ");
INSERT INTO sle_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ಯೆಸು ವರಿ ಅಪೊಸ್ತಲೊ ಡೊಂಗರಪರತಾ ಉತ್ರಿನ ಸಿದಾ ರ‍್ಹಯಲ ಜಿಮಿನ್ಪರ ಹುಬ್ರಯಾ. ತ್ಯಾ ತಿನಾ ಪಾಚಾ಼ ಆಯಲ ಶಿಷ್ಯಾವೊನು ಮ್ಹೊಟು ಗುಂಪ ವರಿ ಯುದಾಯತಾ ಯೆರುಸೆಲೆಮ್ತಾ ತುರ ಸಿದೊನ ಗಾಮ್ತಾ ವರಿ ಸಮುಂದರನಿ ಆಜು಼ಬಾಜು಼ಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತ್ಯಾ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ತ್ಯುನೆ ಕ್ಹಾರಾ ಯೆಸುನಿಯೊ ವಾತೊ ಐಕು ಕೈನ ವರಿ ತೆ ಮನಕ್ಹೊಮಾ ರ‍್ಹಯಲ ರೊಗೊ ಕ್ಹೊ ಅರಾಮ ಥೌ ಕೈನ ತಿಕನ ಆಯಾತಾ. ವರಿ ತ್ಯುನಾಮಾ ದಕ್ಹಾ ಮನಕ್ಹೊಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ವ್ಹತ್ತಿಯೊ. ತ್ಯುನೆ ಕ್ಹಾರಾ ಅರಾಮ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಮುಟ್ಟಾನಾ ಹುತಿ ಕೊಶಿಶ ಕರಾಡಾತಾ. ಕಾಕದ್ಯಾಮ ಯೆಸುಮಾತಿ ತಾಕತ ಭಾರಿ ಐನ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಅರಾಮ ಕರಾಡಿತಿ! ");
INSERT INTO sle_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ದೆಕಿನ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, \"ಗರಿಬೊ ರ‍್ಹಯಲವಾಲಾ ತುಮೆ ಧನೈ ವ್ಹೈ; ಕ್ಹುದಾನಿ ರಾಜ್ಯ ತುಮಾರಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ಭುಕ್ಕಾ ರ‍್ಹಯಲವಾಲಾ ತುಮೆ ಧನ್ಯ ವ್ಹೈ. ತುಮೆ ತೃಪ್ತ ಥಾವೊಸಿ. ವರಿ ತುಮೆ ಹಮ್ನಾ ರವಾಲಾ ತುಮೆ ಧನ್ಯ ವ್ಹೈ; ಪಾಚಾ಼ತಾ ತುಮೆ ಅಕ್ಹೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ಹುತಿ ಮನಕ್ಹೊ ತುಮೊಪರ ಸಿಟ್ಟ ಮ್ಹೆಲಸ ತುಮೊನೆ ಕೆಟ್ಟ ವ್ಹೈ ಕವಸ ವರಿ ತುಮಾರಿ ಮರ್ಯಾದಿ ಕಾಡಸ ವರಿ ಎ ಕ್ಹಾರು ತಡ್ದಿಲಿವಾಲಾ ತುಮೆ ಧನೈ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ತೆ ಟೈಮಾ ಖುಶಿ ರ‍್ಹವೊ. ಕಾಕದ್ಯಾಮ ಸ್ವರ್ಗಮಾ ತುಮೊನೆ ಘನ್ನು ಫಲ ಮಳಸ. ಎ ಮನಕ್ಹೊ ತುಮೊನೆ ಕರಲ ತಿಮ್ಮಜ಼ ತ್ಯುನಾ ಪಿತ್ರೊಬಿ ಪ್ರವಾದಿಯೊನಾ ಕ್ಹಾತೆ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ವರಿ ಸೌಕಾರ ರ‍್ಹಯಲವಾಲಾ ತುಮಾರಿ ಯಕ್ಕ ಪರಸ್ತಿ ಮಿ ಸು ಕೌ! ತುಮಾರಿ ಸುಖಾನಿ ಜಿವ್ನಾ ತುಮೊನೆ ಮಳಿಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ಹಮ್ನಾ ಪೆಟ ಭರಲವಾಲಾ ಮನಕ್ಹೊ, ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ತುಮೆ ಭುಕ್ಕಾ ಥಾವೊಸಿ. ಹಮ್ನಾ ಅಕ್ಹಾಲಾ ಮನಕ್ಹೊ, ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ತುಮೆ ದುಖಿ ಥೈನ ರವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","\"ಮನಕ್ಹೊನಾ ಮ್ಹೊಡೆ ಕೆಳಾಮಾಬಿ ಚೊ಼ಕೊ ಛೆ ಕವೈಲಿವಾಲಾ ತುಮಾರಿ ಗತಿ ಸು ಕೌ! ತ್ಯುನಾ ಪಿತ್ರೊ ಸುಳ್ಳ ಪ್ರವಾದಿಯೊನೆ ಚೊ಼ಕಾ ಛೆ ಕತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"ಮಾರಿಯೊ ವಾತೊ ಐಕಾಲಾವೊ ತುಮೊನೆ ಮಿ ಸು ಕೌಸ ಕದ್ಯಾಮ; ತುಮಾರಾ ದುಶ್ಮನೊನೆ ಮಯಾ ಕರೊ. ತುಮೊನೆ ಕದ್ರಾವಾಲಾವೊನೆ ತುಮೆ ಚೊ಼ಕು ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ತುಮೊನೆ ಕ್ಹರಾಪಾಲಾವೊನೆ ತುಮೆ ಆಶಿರ್ವಾದ ಕರೊ, ತುಮೊನೆ ಕೆಟ್ಟ ಕರಾಲಾವೊನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ಯಕ್ಲೊ ತುಮೊನೆ ಯಕ್ಕ ಗಾಲ್ಪರ ಮಾರಯೊಮ, ತಿನೆ ಬಿಜೆಕ ಗಾಲ ಮಾರಾನೆ ದಿವೊ. ಯಕ್ಲೊ ತಮಾರಾ ಅಂಗಪರ ಉಪ್ಪರಲ್ಯೊ ಅಂಗ್ಡು ಕಾಳ್ಳಿದ್ಯೊಮ, ತುಮೆ ತಿನೆ ಮ್ಹೈನು ಅಂಗ್ಡು ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ತುಮೊಕನ ಮಾಂಗಾಲಾವೊನೆ ಹರಿ ಯಕ್ಲಾನೆ ದಿವೊ. ಯಕ್ಲೊ ತುಮೊಕನ್ನು ಸುಬಿ ಕಾಳ್ಳಿದಲ ರ‍್ಹಯೊಮ ತೆ ವಾಪಾಸ ಮಾಂಗಿಲಿವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ಬಿಜಾ಼ ಮನಕ್ಹೊ ತುಮಾರಾ ಕ್ಹಾತೆ ಸು ಕರು ಕೈನ ಆಸ ಛೆ ತೆಜ಼ ತುಮೆ ತೆ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ತುಮೊನೆ ಮಯಾಕರಾಲಾನೆಜ಼ ತುಮೆ ಮಯಾ ಕರ‍್ಯಾಮ ತೆ ಸು ಉಪಯೊಗ ಛೆ? ಕಾಕದ್ಯಾಮ ಪಾಪಿಯೊಬಿ ತ್ಯುನೊನೆ ಮಯಾ ಕರಾಲಾನೆಜ಼ ಮಾಯಾ ಕರಸ್ತೊ! ");
INSERT INTO sle_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ತುಮೊನೆ ಚೊ಼ಕು ಕರಾಲಾವೊನೆ ತುಮೆ ಚೊ಼ಕು ಕರ‍್ಯಮ ತುಮೊನೆ ಸು ಚೊ಼ಕು ವ್ಹೈ? ಪಾಪಿಯೊಬಿ ತಿಮ್ಮಜ಼ ಕರಸ್ತೊ! ");
INSERT INTO sle_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ತುಮೆ ಕಿನೆಬಿ ಸಾಲಾ ದಿದ್ಯಾಮ, ತುಮೊನೆ ಫರಿನ ದಿವಾಲಾವೊನೆ ಸಾಲಾ ದಿದ್ಯಾಮ ತುಮೊನೆ ಸು ಉಪಯೊಗ ವ್ಹೈ? ಪಾಪಿಯೊಬಿ ಬಿಜಾ಼ ಪಾಪಿಯೊನೆ ಸಾಲಾ ದಿದಲ ತೆಕ್ಲು ದಿದಲ ಮಳಸ ಕೈನ ದಿವಸ್ತೊ! ");
INSERT INTO sle_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","\"ತಿನಾಹುತಿ ತುಮಾರಾ ದುಶ್ಮನೊನೆ ಮಯಾಕರೊ, ತ್ಯುನೊನೆ ಚೊ಼ಕು ಕರೊ, ತುಮೆ ತ್ಯುನೊನೆ ಸಾಲಾ ದೆತಾಮಾ ವರಿ ಫರಿನ ದಿವಸ ಕವಾನು ಆಸ ಮ್ಹೆಲೊ ನಕೊ. ತೆಳಾಮಾ ತುಮೊನೆ ಮ್ಹೊಟು ಪ್ರತಿಫಲ ರ‍್ಹಯಲ ರ‍್ಹವಸ, ವರಿ ಪರಾತ್ಪರ ಕ್ಹುದಾನಾ ದಿಕ್ರಾ ಥಾವೊಸಿ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾ ಪಾಪಿಯೊನೆ, ಕೆಟ್ಟ ಮನಕ್ಹೊ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಚೊ಼ಕೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ತುಮಾರೊ ಸ್ವರಗನೊ ಬಾ ಥಯಲ ಕ್ಹುದಾ ಮರಗಾಲೊ ರ‍್ಹಯಲ ಲಿಂಗತಜ಼ ತುಮೆಬಿ ಮರಗಾಲಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","\"ಬಿಜಾ಼ವೊನೆ ತಿರಪ ಕರೊ ನಕೊ, ತೆಳಾಮಾ ತುಮೊನೆಬಿ ತಿರಪ ಥಾತು ನೈ. ಅಪರಾದಿ (ಕೆಟ್ಟ ಕರಲವಾಲೊ) ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಕರೊ ನಕೊ, ತೆಳಾಮಾ ತುಮೆಬಿ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಥಾತೊನೈ. ಬಿಜಾ಼ವೊನೆ ತುಮೆ ಮಾಫ ಕರೊ ತುಮೊನೆಬಿ ಮಾಫಿ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ಬಿಜಾ಼ವೊನೆ ದಿವೊ, ಕ್ಹುದಾ ತೆಳಾಮಾ ತುಮೊನೆ ಬಿ ದಿವಸ. ಚೊ಼ಕಿ ಅಳತಿ ಕರಿನ ದಾಬಿನ ಹಲೈನ ಪಡೆಲಿಂಗತ ತುಮಾರಾ ಖೊಳಾಮಾ ಘಾಲಸ ತುಮೆ ಅಳತಿ ಕರಾನಿ ಅಳತಿಕ್ಹುಜ಼ ಕ್ಹುದಾ ತುಮೊನೆಬಿ ಅಳತಿ ಕರಿನ ದಿವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ಎನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ತೆ ಸುವೈ ಕದ್ಯಾಮ ಯಕ್ಕ ಕುಡ್ಡೊ ಬಿಜೆಕ್ಕಲಾ ಕುಡ್ಡಾನೆ ವಾಟ ದೆಕಾಡಸ್ಸು? ತಿಮ್ಮ ಥಯುಮ ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ಖಾಡಿಮಾ ಪಡಿ ಜಾ಼ವಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ಗುರುತಿ ಶಿಷ್ಯೊ ಮ್ಹೊಟೊ ನ್ಹವೈ, ಶಿಷ್ಯೊ ಪುರಾ ಶಿಕ್ಕಕಲ್ಪರ ಹರಿ ಯಕ್ಲೊ ತಿನಾ ಗುರು ಲಿಂಗತ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ಎನೈಸೊ ತು ತಾರಾ ಡೊಳಾಮಾ ರ‍್ಹಯಲ ವ್ಹಲಸ ದೆಕ್ಯಾವಾಚಿ ಬಿಜೆ಼ಕ್ಲಾನೆ ಹಸಾಕರಲೆ ಕಾ ಕಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ಪೈಲಾ ತು ಹಸಾ ಥಾ ತುನೆ ದೆಕಾಲೊ ತುನೆ ದೆಕಿನ ಸುದ್ರಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ಚೊ಼ಕು ಝಾಡ ಕೆಟ್ಟ ಫಲ ದೆತು ನೈ, ತಿನಾಲಿಂಗತಜ಼ ಕೆಟ್ಟ ಝಾಡ ಚೊ಼ಕು ಫಲ ದೆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ಹರಿ ಯಕ್ಕ ಝಾಡ ತೆ ದಿವಾನಾ ಫಲಕ್ಹು ತಿನೆ ವಳಕಸ, ಮನಕ್ಹೊ ಕಾಟಾವೊನಾ ಝಾಡಮಾ ಉಂಬ್ರೊನು ಫಲ ನೈತೊ ದ್ರಾಕ್ಷಿಯೊ ಹುಟ್ಟತ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ಚೊ಼ಕು ಮನಸ ರ‍್ಹಯಲವಾಲಾನಾ ಚೊ಼ಕಿಯೊ ಸಂಗತಿಯೊ ಲಾವಸ. ಮನಸ್ಮಾ ಚೊ಼ಕು ರ‍್ಹಯಲಜ಼ ಮ್ಹೊಡಾತು ಆವಸ. ವರಿ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಮನಕ್ಹನಾ ಮನಸ್ಮಾ ರ‍್ಹಯಲಜ಼ ಮ್ಹೊಡಾತು ಕೆಟ್ಟ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ಎನೈಸೊ ತುಮೆ ಮನೆ ಸ್ವಾಮಿ-ಸ್ವಾಮಿ, ಕೈನ ಬಲೈನ ಮಿ ಕವಾನು ಕಾ ನೈ ಕರತಾ? ");
INSERT INTO sle_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ಮಕನ ಐನ ಮಾರಿಯೊ ವಾತೊ ಐಕಿನ, ತಿನಾ ಲಿಂಗತ ಚಾ಼ಲಾಲೊ ತೆ ಕೆವೊ ವ್ಹೈ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ತೆ ಘರ ಭಾಂದಾಲಾ ಲಿಂಗತ ಛೆ. ತೆ ಘನ್ನಿ ಉಂಡಿ ಖಾಡಿ ಖಂದಿನ ಫಾಯಾ ಘಾಲಿನ ದಗಡಾಪರ ಘರ ಭಾಂದಲ ಲಿಂಗತ ತೆ ಮನಕ್ಹ ರ‍್ಹವಸ. ಕೆಕ್ಕಲು ಜೊ಼ರ ನದಿನು ಪಾನಿ ಐನ ತೆ ಘರನೆ ಪಾನಿ ಲಾಗ್ಯು ತಬಿ ತಿನೆ ಸುಜ಼ ಥಯುನೈ. ಕಾಕದ್ಯಾಮ ತೆ ಘರ ದಗ್ಡಾಪರ ಭಾಂದಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ತೆನೈಸೊ ಮಾರಿಯೊ ವಾತೊ ಐಕಿನ ತಿನಾಲಿಂಗತ ನೈ ಚಾ಼ಲಾಲೊ ಉಂಡಿ ಫಾಯಾ ನೈ ರ‍್ಹಯಲ ಲಿಂಗತ ಕ್ಹಾಲಿ ಜಿಮಿನ್ಪರ ಭಾಂದಲವಾಲಾ ಲಿಂಗತ ರ‍್ಹವಸ, ತೆ ನದಿನು ಪಾನಿ ತೆ ಘರನೆ ಲಾಗ್ಯುಮ ತೆ ಘರ ಭೆಗಿನ ಪಡಿಜಾ಼ವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ಯೆಸು ಮನಕ್ಹೊನೆ ಎ ಕ್ಹಾರಿಯೊ ವಾತೊ ಕೈನ ಮುಗ್ಸಲ್ಪರ ಕಪೆನೌರ್ಮಿಯೆ ಕವಾನಾ ಗಾಮೆ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ತ್ಯಾ ಯಕ್ಲೊ ರೊಮನ್ನೊ ಸೆನಾದಿಪತಿ ವ್ಹತ್ತೊ. ಸೆನಾದಿಪತಿ ಮಯಾ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲೊ ಆಳ ಅರಾಮ ನೈಸೊ ಮರವಾನಿ ಸ್ತಿತಿಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ತೆ ಶೆತಾದಿಪತಿ ಯೆಸುನಿ ಸುದ್ದಿ ಐಕಿನ, ತಿಕನ ರ‍್ಹಯಲ ಯಹುದ್ಯೊನಾ ನಾಯಕೊನೆ ಯೆಸುಕನ ಮೊಕ್ಲಿನ ತಿನಾ ಸೆವಕನೆ ಅರಾಮ ಕರ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ತೆ ಯಹುದ್ಯೊನಾ ನಾಯಕೊ ಯೆಸುಕನ ಐನ \"ಎ ತಾರೊ ಆಶಿರ್ವಾದ ಹೊಂದಾನೆ ಎ ಸೆನಾದಿಪತಿ ಯೊಗ್ಯ ಛೆ\" ");
INSERT INTO sle_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ಕಾಕದ್ಯಾಮ ತೆ ಅಪ್ನಾ ಮನಕ್ಹೊನೆ ಮಯಾ ಕರಸ ವರಿ ಹಮಾರಾ ಹುತಿ ಸಭಾಮಂದಿರ ಭಾಂದಿನ ದಿದ್ಯೊಸ \"ಕೈನ ಘನ್ನಾ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ತಿನಾಹುತಿ ಯೆಸು ತಿವ್ನಾ ಕ್ಹಾತೆ ಚಾ಼ಲ್ಯೊ. ಯೆಸು ಘರಕನ್ನಾ ನಜಿಕ ಆತಾಮಾ, ತೆ ಅದಿಕಾರಿ ತಿನಾ ಸೆವಕನೆ ಮೊಕ್ಲಿನ ಯೆಸುನೆ \"ಸ್ವಾಮಿ ತು ಮಾರಾ ಘರೆ ಆವಾಯಕ್ಲಿ ಮಾರಿ ಯೊಗ್ಯತೆ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ತುಕನ ಆವಾನಿ ಯಕ್ಲಿಬಿ ಮನೆ ಯೊಗ್ಯತೆ ನತ್ತಿ. ತು ನ್ಹ್ಯಾಂತೊಜ಼ ಯಕ್ಕ ಅಪ್ಪಣೆ ದಿದ್ಯೊಮ ಬಸ, ಮಾರೊ ಯಕ್ಕ ಸೆವಕ ಅರಾಮ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ತಾರೊ ಯಕ್ಕ ಅದಿಕಾರ ಮಿ ತಿಳದಿಲಿದ್ಯೊಸ. ಮಿಬಿ ಬಿಜೆ಼ಕ್ಲಾನಾ ಅದಿಕಾರಿನಾ ಹತ್ಮಾ ಛೆ, ಮಾರಾ ಹತಮಾ ಸೈನಿಕೊ ಛೆ, ಮಿಬಿ ಯಕ್ಕ ಸೈನಿಕನೆ ಜಾ಼ ಕದ್ಯಾಮ ತೆ ಜಾ಼ವಸ, ವರಿ ಯಕ್ಲಾನೆ ಆ ಕದ್ಯಾಮ ತೆ ಆವಸ. ಮಾರಾ ಆಳನೆ, ಆ ಕರ ಕದ್ಯಾಮ ಮನೆ ತೆ ವಿಧೆಯ ಥಾವಸ \"ಕೈನ ಯೆಸುಕನ ಕೆ ಕೈನ ತಿನಾ ಆಳನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ಯೆಸು ಎ ವಾತೊ ಐಕಿನ ಘಾಬ್ರೊ ಥೈನ ತಿನಾ ಪಾಚಾ಼ ಆಯಲ ಮನಕ್ಹೊನೆ ದೆಕಿನ\"ಅಕ್ಲೊ ಮ್ಹೊಟೊ ಬರೊಕ್ಹೊ ರ‍್ಹಯಲ ಮನಕ್ಹನೆ ಮಿ ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊಮಾಬಿ ದೆಕ್ಯೊ ನತ್ತಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ತೆ ಮೊಕ್ಕಲಲ ಮನಕ್ಹೊ ಯೆಸು ಕಂತಾ ಫರಿನ ಜಾ಼ತಾಮಾ ತಿನಾ ಆಳನೆ ಅರಾಮ ಥಯಲ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ಮರ್ನಾ ದಿನ್ನೆ ಯೆಸು ನಾಯಿನ ಕವಾನಾ ಗಾಮೆ ಚಾ಼ಲ್ಯಾತಾ, ಯೆಸುನಾ ಶಿಷ್ಯಾ ವರಿ ಮನಕ್ಹೊನು ಗುಂಪಬಿ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ಯೆಸು ತೆ ಗಾಮ್ನಾ ನಜಿಕ ಆತಾಮಾ, ಮರಿಗಯಲ ಯಕ್ಲಾನೆ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲಾನೆ ತಿನೆ ಉಚೈಲಿನ ಚಾ಼ಲ್ಯಾತಾ,ವರಿ ತೆ ರಾಂಡಿ ಬಾಕಡಿನೆ ಯಕ್ಲೊಜ಼ ದಿಕ್ರೊ ವ್ಹತ್ತೊ. ತ್ಯುನಾ ಪಾಚು಼ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪಬಿ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ಯೆಸು ತೆ ರಾಂಡಿ ಬಾಕಡಿನೆ ದೆಕಿನ ತಿನೆ ಮರಗಿನ\"ರೌ ನಕೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ಯೆಸು ಮ್ಹಾಡಕನ ನಜಿಕ ಗೈನ ತೆ ಮ್ಹಾಡನೆ ಮುಟ್ತಾಮಾ ತೆ ಮ್ಹಾಡನೆ ಉಚೈಲಿದಲವಾಲಾ ಹುಬ್ರಯಾ. ತೆಳಾಮಾ ಯೆಸು ಮರವಾಲಾನೆ ಎ ಜಾಂಜಿಮಾನ ಪಟ್ಟಾ ಉಟ್ಟ ಮಿ ತುನೆ ಕೌಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ಕದಲ ಬರೊಬ್ಬರ ಮರಲವಾಲೊ ಉಟಿನ ಬೈಟ್ಯೊ ವರಿ ಬೊಲಾನೆ ಚಾಲು ಕರ‍್ಯೊ ಯೆಸು ತೆ ಪಟ್ಟಾನೆ ತಿನಿ ಮಾ ಕನ ವಪ್ಶ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಭುಚ್ಕಾ಼ವರಕ್ಹಾ ಥೈನ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರತಾ, ಮ್ಹೊಟೊ ಪ್ರವಾದಿ ಅಪೊಕನ ಆಯೊಸ! ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ವಚಾ಼ಡಾನಾ ಹುತಿ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ಯೆಸು ಎ ಕ್ಹಾರು ಕರಲ ಸುದ್ದಿ ಯುದಾಯಮಾಬಿ ವರಿ ಸುತ್ತೆ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಗಾಮೊಮಾ ಪ್ಹೈಲಿ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಯೆಸುನಿ ಎ ಕ್ಹಾರಿ ಸುದ್ದಿ ಯೊಹಾನನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ಯೊಹಾನ ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆ ಜ಼ನಾವೊನೆ ಬಲೈನ \"ಆವಾನೊ ರ‍್ಹಯಲ ಮಸಿಹಾ ತುಜ಼಼ ವ್ಹೆಸು ನೈತೊ ಬಿಜ಼ೊ ವ್ಹೈ ಸು ತೆ ಆವಾನಾ ಹುತಿ ಹಮೆ ಕೈದಿಸು? ಕೈನ ಪುಚ್ಚಾ಼ಹುತಿ ಯೆಸುಕನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ತಿನಾ ಹುತಿ ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಯೆಸುಕನ ಐನ \"ಆವಾನೊ ರ‍್ಹಯಲ ಮಸಿಹಾ ತುಜ಼಼ ವ್ಹೈಸು ಸು ಬಿಜಾ಼ನೆ ಹಮೆ ಕೈದಿಯೆ? ಕೈನ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನ ತುನೆ ಪುಚ಼ ಕೈನ ಹಮೊನೆ ತುಕನ ಮೊಕ್ಕಲ್ಯೊಸ\" ");
INSERT INTO sle_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ತೆಜ಼ ಟೈಮಾ ಯೆಸು ಘನ್ನಾ ಜ಼ನಾವೊನೆ ರೊಗ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಕೆಟ್ಟ ಆತ್ಮಾ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಛೊಡೈನ ಅರಾಮ ಕರ‍್ಯೊ ವರಿ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಕುಡ್ಡಾವೊನೆ ದಿಕ್ಹಾ ವರಕ್ಹು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಯೆಸು ಯೊಹಾನನಾ ಶಿಷ್ಯಾವೊನೆ ತಿಳಸಾ ಹುತಿ \"ತುಮೆ ಗೈನ ದೆಕಲ ಎಕ್ಹಾರು ಯೊಹಾನನೆ ಕವೊ. ಕುಡ್ಡಾವೊನೆ ಡೊಳಾ ಆವಸ ಲಂಗ್ಡಾ ರ‍್ಹಯಲ ವಾಲಾ ಚಾ಼ಲಸ ಕುಷ್ಠ ರೊಗಿಯೊ ಚೊ಼ಕಾ ಥಾವಸ. ಕ್ಯುಡಾ ರ‍್ಹಯಲ ವಾಲಾ ಐಕಸ. ಮರಲವಾಲಾ ವಾಚ಼ಸ. ಗರಿಬೊನೆ ಸುವಾರ್ತೆ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ವರಿ ಮಾರಾ ಹುತಿ ಸಂಶೊ ನೈ ಕರಲವಾಲೊ ಧನೈ ವ್ಹೈ\" ಕೈನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ಯೊಹಾನನಾ ಶಿಷ್ಯಾ ಗಯಲ್ಪರ, ಯೆಸು ಮನಕ್ಹೊನೆ ಯೊಹಾನನಾ ಹುತಿ ಕವಾನು ಚಾಲು ಕರ‍್ಯೊ\"ಸು ತುಮೆ ದೆಕಾನೆ ರಾನ್ಮಾ ಗಯಾತಾ? ವಾರಾ ಕ್ಹು ಹಲ್ಲಾನೊ ಧಾಂಡೊಸು? ");
INSERT INTO sle_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ತುಮೆ ಭಾರಾ ಸು ದೆಕಾನೆ ಗಯಾತಾ? ನರಮ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ಹುಬ್ರಯಲ ಮನಕ್ಹನೆ ಸು? ನೈ ನರಮ ವರಿ ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿದಲ ವಾಲಾ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಘರೊಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ಮನೆ ಕವೊ, ತುಮೆ ಭಾರಾ ಸು ದೆಕಾನೆ ಗಯಾತಾ? ಪ್ರವಾದಿನೆ ಸು? ಹೊ ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯಾಮ, ಯೊಹಾನ ಪ್ರವಾದಿ ತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ದೆಕ! ಮಿ ಕ್ಹುದಾ ಮಾರಾ ದುತನೆ ತಾರಾ ಕ್ಹಾಮೊ ಮೊಕ್ಕಲುಸ. ತೆ ತಾರಾ ಹುತಿ ವಾಟ ತಯ್ಯಾರ ಕರಸ (ಮಲಾಕಿ 3:1) ಕೈನ ಯೊಹಾನನಾ ಹುತಿ ಬರ್ದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ಮಿ ತುಮೊನೆ ಕೌಸ,ಎ ಜಗತ್ಮಾ ಹುಟ್ಟಲ ಮನಕ್ಹೊಮಾ ಯೊಹಾನಜ಼ ಮ್ಹೊಟೊ ವ್ಹೈ. ವರಿಬಿ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ನ್ಹಾನೊಬಿ ಯೊಹಾನತೊಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ಯೊಹಾನ ಉಪದೆಶ ಕರತಾಮಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಮನಕ್ಹೊ ಸ್ವಿಕಾರ ಕರ‍್ಯಾ. ಭು ಭಾಡೊಲಿವಾಲಾ ಸ್ವಿಕಾರ ಕರ‍್ಯಾ. ಇವ್ನೆ ಕ್ಹಾರಾ ಯೊಹಾನನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ವರಿ ಫರಿಸಾಯರೊ ಶಾಸ್ತ್ರಿಯೊ ತಿನಾ ಹತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯಾ ವಾಚಿ ತ್ಯುನಿ ವಿಚಾರಮಾ ಕ್ಹುದಾನಿ ನಿಯಮನೆ ಇನ್ಕಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಯೆಸು ಎ ಕಾಲನಾ ಮನಕ್ಹೊ ಕಿನೆ ಹೊಲ್ಸು? ತ್ಯುನೆ ಕಿನೆ ಹೊಂದಾಣಕಿ ಥಾವಸ? ");
INSERT INTO sle_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ತ್ಯುನೆ ಬಾಜ಼ರೊಮಾ ಬೈಟಲ ಬಚ್ಚಾ ಲಿಂಗತ ತಮಾರಾ ಹುತಿ ಪಿಂಗಿ ವಜಾ಼ಡ್ಯಾ ತುಮೆ ನ್ಹಾಚ್ಯಾ ನೈ ಮರಲ ಗಿದ್ದ ಕದ್ಯಾ ತುಮೆ ರೊಯಾ ನೈ, ");
INSERT INTO sle_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನ ಆಯೊ. ತೆ ಬಿಜಾ಼ವೊಲಿಂಗತ ಅನ್ನ ಖಾದ್ಯೊ ನೈ ವರಿ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿದ್ಯೊ ನೈ. ತುಮೆ-ತಿನೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಿಸ ಕೈನ ಕವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆಯೊಸ ವರಿ ತೆ ಅನ್ನ ಖಾವಸ, ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿವಸ. ತುಮೆ ಕದ್ಯಾ, ದೆಕೊ! ಆ ಘನ್ನು ಖಾವಸ,ವರಿ ಪಿದೊಡೊ ವ್ಹೈ ದೊಕಡಾ ಲಿವಾಲಾ ವರಿ ಪಾಪಿಯೊನೊ ದೊಸ್ತೊ ವ್ಹೈ ಕೈನ ಕವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ಕ್ಹುದಾನಿ ಗ್ಯಾನನೆ ವಪ್ಪಿಲಿದಲವಾಲಾ ಬಚ್ಚಾ಼ವೊಕ್ಹು ಕ್ಹರಿ ಕೈನ ದಿಕ್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ಪರಿಸಾಯರಮಾನೊ ಯಕ್ಕ ಮನ್ಹಖ ಯೆಸುನೆ ಖಾವಾನೆ ಬಲಾಯೊ ಯೆಸು ತಿನಾ ಘರೆ ಗೈನ ಖಾವಾನೆ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ತೆಳಾಮ ತೆ ಗಾಮಮಾ ರ‍್ಹಯಲ ಯಕ್ಕ ವ್ಯಬಿಚಾರ ಕರಾಲಿ ಹೆಣ ಮನ್ಹಖ ಯೆಸು ಫರಿಸಾಯರನಾ ಘರಮಾ ಅನ್ನ ಖಾವಾಡ್ಯೊಸ ಕೈನ ತಿನೆ ಗ್ವತ್ತ ಥಯು. ತಿನಾಹುತಿ ತೆ ಹೆಣ ಮನಕ್ಹ ಭರಣಿಮಾ ಬಾಸುನು ತೆಲ ಲೈ. ");
INSERT INTO sle_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ತೆ ಹೆಣ ಮನಕ್ಹ ಯೆಸು ಕನ ಐನ ತಿನಾ ಪಗೊಕನ ಬೈಟಿನ ರೊತಿ ತಿನಾ ಡೊಳಾಮಾನು ಪಾನಿ ಯೆಸುನಾ ಪಗೊ ಭಿಂಜೈನ ವರಿ ತಿನಾ ಮಾತಾನಾ ಬಾಲೊಕ್ಹು ಯೆಸುನಾ ಪಗೊ ನುಚ್ಚಿನ ವರಿ ತೆ ಹೆಣ ಮನಕ್ಹ ತಿನಾ ಪಗೊನೆ ಮಟ್ಟಿಲಿನ ತೆಲ ಪಗೊಮಾ ರಿಚೈ ಪಾಡಿ. ");
INSERT INTO sle_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ಯೆಸುನೆ ತಿನಾ ಘರೆ ಖಾವಾನೆ ಬಲಾಯಲ ಫರಿಸಾಯರ ಎ ಕ್ಹಾರು ದೆಕಿನ ತಿನಾ ಮನಸ್ಮಾ\"ಯೆಸು ಪ್ರವಾದಿ ರ‍್ಹಯಲ ರ‍್ಹಯೊಮ, ತಿನೆ ಮುಟ್ಟಾಲಿ ತೆ ಹೆಣ ಮನಕ್ಹನೆ ಪಾಪಿ ವ್ಹೈ ಕೈನ ತಿಳದಿಲೆತೊತೊ \"ಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ತೆ ವಾತೆ ಯೆಸು ಫರಿಸಾಯರನೆ\"ಸಿಮೊನ ಮಿ ತುನೆ ಯಕ್ಕ ವಾತ ಕೌ ಕೈನ ಛೆ ಕದ್ಯೊ. ತೆಳಾಮಾ ಸಿಮೊನ ಯೆಸುನೆ \"ಗುರು ಕೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ತೆಳಾಮಾ ಯೆಸು ಕದ್ಯೊ, ಬೆ ಜ಼ನಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಯಕ್ಕಜ಼ ಸೌಕಾರಕನ ಸಾಲಾ ಲಿದ್ಯಾತಾ, ತಿಮಾನೊ ಯಕ್ಲೊ ಪಾಂಚ಼ ಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಲಿದ್ಯೊತೊ ವರಿ ಯಕ್ಲೊ ಐವತ್ತ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಲಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ತ್ಯುನೊಕನ ಸಾಲಾ ವಾಪಸ ದಿವಾನೆ ಸುಜ಼ ನ್ಹೊತಾ. ತೆಳಾಮಾ ತ್ಯುನೊನೆ ಸಾಲಾ ದಿದಲ ವಾಲೊ ಸೌಕಾರ ತ್ಯುನೊನೆ ಕದ್ಯೊ, ತುಮೆ ಸಾಲಾ ವಾಪಸ ದಿವೊನಕೊ ಕದ್ಯೊ. ತೆಳಾಮಾ ಯೆಸು ಸಿಮೊನನೆ ಪುಚ್ಯೊ ತೆ ಬೆ ಜ಼ನಾವೊಮಾ ಕುನ್ನ ಸೌಕಾರನೆ ಹೆಚ್ಕಿ ಮಯಾ ಕರಸ ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ಸಿಮೊನ ಯೆಸುನೆ \"ಹೆಚ್ಕಿ ಸಾಲಾ ಲಿದಲವಾಲೊ \"ಕೈನ ಕದ್ಯೊ. ಯೆಸು ಸಿಮೊನನೆ \"ತು ಕರೆಟ್ಟ ಕದ್ಯೊ \"ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತೆ ಬಾಕಡಿಕನ ದೆಕಿನ ಸಿಮೊನನೆ\"ಆ ಬಾಕ್ಡಿ ದಿಕ್ಹಾಡಿಸು? ಮಿ ತಾರಾ ಘರಮಾ ಆತಾಮಾ ತು ಮಾರಾ ಪಗೊ ಧವಾನೆ ಪಾನಿ ದಿದ್ಯೊ ನೈ. ಆ ಬಾಕಡಿತೊ ರೊಯಿನ ತಿನಾ ಡೊಲಾಮಾನು ಪಾನಿಕ್ಹು ಮಾರಾ ಪಗೊ ಧ್ವಯಿನ ತಿನಾ ಮಾತಾನಾ ಬಾಲೊಕ್ಹು ಮರಾ ಪಗೊ ನುಚ್ಚಿಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ತು ಮನೆ ಯಕ್ಕಬಿ ಮಟ್ಟಿಲಿದ್ಯೊ ನೈ. ಆ ತೊ ಮಾರಾ ಪಗೊನೆ ಮಟ್ಟಿಲಿವಾನು ಛೊಡಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ತುತೊ ಮಾರಾ ಮಾತೆ ತೆಲ ಲಗಾಡ್ಯೊ ನೈ. ಆ ತೊ ಮಾರಾ ಪಗೊನೆ ಬಾಸನು ತೆಲ ಲಗಾಡಿಸ. ");
INSERT INTO sle_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ತಿನಾ ಹುತಿ ಮಿ ತುಮೊನೆ ಕೌಸ, ಆ ದೆಕಾಡಲ ಘನ್ನಿ ಮಯಾಕ್ಹು ಅನಾ ಪುರಾ ಪಾಪೊ ಮಾಫ ಥಯಾ. ಕಾಕದ್ಯಾಮ ಆ ಘನ್ನು ಮಯಾ ದೆಕಾಡಿಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತೆ ಬಾಕಡಿನೆ \"ತಾರಾ ಪಾಪೊ ಮಾಫ ಥಯಾಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ಖಾವಾನೆ ಬೈಟಲವಾಲಾ ಮನ್ಹಖೊ \"ಆ ತಿನೆ ತೆ ಸು ಕೈನ ತಿಳದಿಲಿದ್ಯೊಸ? ಪಾಪೊನೆ ಮಾಫ ಕರಾನೆ ಅಕನ ಕಿಮ ಸಾಧ್ಯ ಛೆ? ಕೈನ ತಿವ್ನಾ ತಿವ್ನಾಮಾಜ಼ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ಯೆಸು ತೆ ಬಾಕಡಿನೆ \"ತಾರೊ ಬರೊಕ್ಹೊಜ಼ ತುನೆ ರಕ್ಷಣೆ ಮಳ್ಯುಸ ಸಮಾಧಾನ ಕ್ಹು ಜಾ಼. ");
INSERT INTO sle_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ಎ ಥಯಲಪರ, ಯೆಸು ಭೊದನೆ ವರಿ ಕ್ಹುದಾನಿ ರಾಜ್ಯನ ಹುತಿ ಮನಕ್ಹೊನೆ ತಿಳಸಾತೊ ಖೆಡಾವೊಪರ ಗಾಮೊಪರ ಗಯೊ ವರಿ ತಿನಾ ಕ್ಹಾತೆ 12 ಶಿಷ್ಯಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ದಕ್ಹಿಯೊ ಹೆಣ ಮನಕ್ಹೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಿಯೊ. ತೆ ಹೆಣ ಮನಕ್ಹೊಮಾ ರ‍್ಹಯಲ ರೊಗೊಕ್ಹೊ ಅರಾಮ ಕರ‍್ಯೊತೊ ವರಿ ದಕ್ಹಿಯೊ ಹೆಣ ಮನಕ್ಹೊನೆ ತಿವ್ನೊಮಾ ರ‍್ಹಯಲ ಕೆಟ್ಟ ಆತ್ಮಾಕ್ಹು ಛೊ಼ಡಾಯೊತೊ. ಎ ಹೆಣ ಮನಕ್ಹೊಮಾನಿ ಯಕ್ಲಿನು ನಾಮ ಮರಿಯಳ ವ್ಹತ್ತು. ತೆ ಮಗ್ದಲ ಗಾಮ ವಾಲಿ ವ್ಹತ್ತಿ. ಯೆಸು ತಿನಾ ಅಂಗಮಾತೊ ಕ್ಹಾತ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ತೆನೈಸೊ ಹೆರೊದನಾ ರಾಜ್ಯಮಾ ಅದಿಕಾರಿ ಥಯಲ ಕುಜ಼ನನಿ ಬೈಕೊ ಯೊಹಾನಳ, ಸುಸನ್ನಳ ವರಿ ಬಿಜಿ಼ಯೊ ಘನಿಯೊ ಹೆಣ ಮನಕ್ಹೊ ವ್ಹತ್ತಿಯೊ ವರಿ ತೆ ಹೆಣ ಮನಕ್ಹೊ ತಿವ್ನಾ ಸ್ವಂತ ದೊಕಡಾಕ್ಹು ಯೆಸುನೆ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸಹಾಯಾ ಕರತಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ಬಿಜಾ಼-ಬಿಜಾ಼ ಗಾಮ್ತಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುಕನ ಗುಂಪ ಥೈನ ಆತಾಮಾ ತೆ ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"ಯಕ್ಲೊ ರೈತ ಬಿಯ್ಯಾ ಬಿತ್ತಾನಾ ಹುತಿ ತಿನಾ ಖೆರತೆಗಯೊ ತೆ ಬಿಯ್ಯಾ ಖೆತರಮಾ ನಾಕ್ಕತಾಮಾ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಮನಕ್ಹೊ ಫರಾನಿ ವಾಟ್ಮಾ ಪಡ್ಯಾ ತೆ ಬಿಯ್ಯಾವೊನೆ ಮನಕ್ಹೊ ಖುಂದಿಪಾಡ್ಯಾ. ವರಿ ಹಬಾಳಮಾ ಉಡಾನಿಯೊ ಪಕ್ಷಿಯೊ ಐನ ತೆ ಬಿಯ್ಯಾ ಖೈಪಾಡಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ಬಿಜಾ಼ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಮಾತಿ ಕಮ ರ‍್ಹಯಲ ದಗ್ಡಾವೊಪರ ಪಡ್ಯಾ, ತೆ ಬಿಯ್ಯಾ ಬೆಳದ್ಯಾ ವರಿ ಪಾನಿ ನೈಸೊಕ್ಹು ಕುಕ್ಹೈ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ವರಿ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಕಾಟಾವೊನಿಯೊ ಕಂಟಿಯೊನಾ ಝಾಡೊಮಾ ಪಡ್ಯಾ ತೆ ಬಿಯ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಕಾಟಾವೊನಾ ಝಾಡೊ ಬೆಳ್ದಿನ ತೆ ಬಿಯ್ಯಾವೊನೆ ಬೆಳ್ದಾನೆ ದಿದ್ಯಾ ನೈ. ಝಾಕಿ ಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ವರಿ ದಕ್ಹಾ ಬಿಯ್ಯಾ ಚೊ಼ಕಿ ಜಿಮಿನ್ಪರ ಪಡ್ಯಾ ತೆ ಬೆಳ್ದಿನ ಕ್ಹೊ ಯಕ್ಲಾ ಫಲ ದಿದ್ಯಾ\" ಎ ವಾತೊ ಕೈನ ಯೆಸು \"ಐಕಾನೆ ಕಾನೊ ರ‍್ಹಯಲ ವಾಲೊ ಐಕಾದೆ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ಯೆಸುನಾ ಶಿಷ್ಯಾ\"ಎ ಸಾಮ್ಯನು ಮತ್ಲಬ ಸುವೈ? ಕೈನ ಯೆಸುನೆ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ಯೆಸು, ತ್ಯುನೊನೆ \"ಕ್ಹುದಾನಿ ರಾಜ್ಯನಿ ಗುಟ್ಟ ತುಮೆ ತಿಳದಿಲಿವಾದೆ ಕೈನ ಗ್ಯಾನ ತುಮೊನೆ ದಿದ್ಯಾಸ. ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಮಿ ಕಾನಿಕ್ಹು ಬೊಲುಸ, ಕಾಕದ್ಯಾಮ, ತ್ಯುನೆ ದೆಕ್ಯಾತಬಿ ದಿಕ್ಹತು ನೈ, ಐಕ್ಯಾತಬಿ ತಿಳ್ದಿಲೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"ಎ ಸಾಮ್ಯನು ಮತ್ಲಬ ಅಮ ಛೆ. ಬಿಯ್ಯಾ ಕವಾನು ಕ್ಹುದಾನಿ ವಾತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ವಾಟ್ಮಾ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ? ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕುನ್ನ ಐಕಸ. ವರಿ ಸೈತಾನ ಐನ ತ್ಯುನಾ ಮನಸೊಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ವಾತೊ ಕಾಳ್ಳಿನ ಗೈ ಪಾಡ್ಯೊ. ತ್ಯುನೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊಪರ ಬರೊಕ್ಹೊ ನೈ ರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೊನೆ ರಕ್ಷಣೆ ಥಾತಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ಕಮ ಮಾತಿ ದಗ್ಡಾಪರ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ ಕುನ್ನ-ಕುನ್ನ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಖುಶಿಕ್ಹು ಐಕಿನ ತ್ಯುನೊಮಾ ಬರೊಕ್ಹೊ ಕಮ ರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೊನೆ ತರಾಸ ಆಯೊಮ ತ್ಯುನೆ ಕ್ಹುದಾತಿ ದುರ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ಕಾಟಾವೊನಿಯೊ ಕಂಟಿಯೊಮಾ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ. ತ್ಯುನೆ ತ್ಯವಾ ಮನಕ್ಹೊ ವ್ಹೈ. ದಕ್ಹಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿಸ ವರಿ ಇವ್ನೆ ಜಗತಿನಿ ಸುಖಮಾ ವರಿ ಚಿಂತಾಮಾ, ಸೌಕಾರನಿ ಆಸಮಾ ಆಸ್ತಿನಾ ಹುತಿ ತ್ಯುನೆ ತಿನೆಜ಼ ಹೆಚ್ಕಿ ಟೈಮ ದಿನ್ನ ತ್ಯುನೆ ಬೆಳತ್ತಾ ನೈ; ತ್ಯುನೆ ಚೊ಼ಕು ಫಲ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ತೆನೈಸೊ ಚೊ಼ಕಿ ಜಿಮಿನ್ಪರ ಪಡಲ ಬಿಯ್ಯಾ ಕದ್ಯಾಮ, ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿನ ಚೊ಼ಕಾ ಮನಸ್ಮಾ ಮುಕ್ಕಕಿಲಿನ ತಡ್ದಿಲಿನ ಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"ಕಯೊಜ಼ ಮನಕ್ಹ ದಿವ್ವೊ ಲಗಾಡಿನ ಸಾಮನಕ್ಹು ಝಾಕ್ಕತಾನೈ ನೈತೊ ಪಲಂಗನಾ ಹೆಟೊ ಝಾಕಿನ ಮ್ಹೆಲ್ತಾನೈ. ಘರಮಾ ಆವಾಲಾವೊನೆ ದಿಕ್ಹಾ ಹುತಿ ಉಜಾಲು ಪಡಾನ ಜ಼ಗಾಜ಼ ಮ್ಹೆಲಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ಉಜಾಲಾಮಾ ಆವಾನು ಸುಜ಼ ಗುಟ್ಟ ನತ್ತಿ, ವರಿ ಸುಬಿ ಝಾಕಿನ ಮ್ಹೆಲಾಮ ತೆ ಭಾರು ಆವಸ, ತುಮೆ ಸುಬಿ ಝಾಕಿನ ಮ್ಹೆಲಲ ರ‍್ಹಯಾಮ ತೆ ತುಮೊನೆ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ತಿನಾಹುತಿ ತುಮೆ ಕಿಮ ಕಾನ ದ್ಯು ದೆಕಿಲಿವೊ ಕಾಕದ್ಯಾಮ ರ‍್ಹಯಲ ವಾಲಾನೆ ದಿವಾಲಗಾಡಸ ನೈ ರ‍್ಹಯಲವಾಲಾಕಂತು ತೆ ತಿನು ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾನು ಕಾಳ್ಳಿವಾ ಲಗಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ಯೆಸುನಿ ಮಾ ವರಿ ಭಾಯೊ ತೆ ರ‍್ಹಯಲ ಜ಼ಗಾ ಐನ ಮನಕ್ಹೊನು ಗುಂಪನಾ ಹುತಿ ಯೆಸುಕನ ಜಾ಼ವಾನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ತ್ಯಾ ರ‍್ಹಯಲ ಯಕ್ಲೊ ತಿನೆ \"ತಾರಿ ಮಾ ತಾರಾ ಭಾಯೊ ತುನೆ ದೆಕು ಕೈನ, ಭಾರಾ ಹುಬ್ರಯಾಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ಕತಾಮಾ ಯೆಸು ತ್ಯಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾವೊನೆ \"ಕುನ್ನ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿನ ತಿನಾಲಿಂಗತ ಚಾ಼ಲಸ ತ್ಯುನೆಜ಼ ಮನೆ ಮಾ ವರಿ ಭಾಯೊ ವ್ಹೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ಯಕ್ಕ ದಿನ್ನ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಹಡ್ಗೊ ಚ಼ಡಿನ \"ಅಪೆ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಯೆ ಗೈಯೆ \"ಕೈನ ಕದ್ಯೊ. ಕತಾಮಾ ತ್ಯುನೆ ಹಡ್ಗೊ ಚ಼ಡಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ತ್ಯುನೆ ಸಮುಂದರಪರತಾ ಜಾ಼ತಾಮಾ ಯೆಸುನೆ ನಿಂದರ ಲಾಗಿತಿ. ತೆಕ್ಲಾಮಾಜ಼಼ ಜೊ಼ರ ವಾರೊ ಸಮುಂದರಪರ ಚು಼ಟ್ಯು. ಹಡಗಾಮಾ ಪಾನಿ ಭರಾನು ಚಾಲು ಥಯು. ತಿಮ್ಮ ಥಯಲ ಹುತಿ ತ್ಯುನೆ ಭುಚಿ಼ಕಿನ ತ್ರಾಸಮಾ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ತಿಮ್ಮ ಥಾತಾಮಾ ಯೆಸುನಾ ಶಿಷ್ಯಾ ತ್ಯುನೆ ತಿಕನ ಐನ \"ಗುರು! ಗುರು! ಅಪೆ ಡುಬಿ ಚಾ಼ಲ್ಯಾಸ\" ಕೈನ ತಿನೆ ಉಟಾಡ್ಯಾ, ಯೆಸು ತೆಳಾಮಾ ಉಟಿನ ವಾರಾನೆ ಪಾನಿನಾ ಧಡಕಿಯೊನೆ ಭುಚ್ಕಾಡ್ಯೊ, ತೆ ಕ್ಹಾರು ಶಾಂತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ತೆಳಾಮಾ ಯೆಸು\"ತುಮಾರೊ ಬರೊಕ್ಹೊ ಕಿಜಾ಼ ಛೆ? ಕೈನ ತ್ಯುನೊನೆ ಪುಚ್ಯೊ. ತೆಳಾಮಾ ಕ್ಹಾರಾ ಶಿಷ್ಯಾ ಭುಚ್ಕಿನ ಘಾಬ್ರಾಥಯಾ\"ಎ ಕುನ್ನ ವಸ? ಪಾನಿನೆ ವಾರಾನೆ ಅಪ್ಪಣೆ ದಿವಸ, ಎ ಕ್ಹಾರು ಯೆಸು ಕದಲ ತಿಮ್ಮಜ಼ ಐಕಸ್ತೊ\"ತ್ಯುನೊಮಾ ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ; ");
INSERT INTO sle_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾ ಗಲಿಲಾಯತಾ ಸಮುಂದರ ದಾಟಿನ ಗೆರೆಸಿನೆರ ಕವಾನಾ ಗಾಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ಯೆಸು ಹಡಗಾಮಾತೊ ಉತರತಾಮಾ ತೆ ಗಾಮ್ನೊ ಯಕ್ಕ ಮನಕ್ಹ ಯೆಸುಕನ ಐನ ಎ ದಾಣಗಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ವ್ಹತ್ತಿಯೊ. ಘನ್ನಾ ದಿನತೊ ತೆ ವಣ್ಣಾಜ಼ ಘಾಲ್ಲಿದ್ಯೊ ನ್ಹೊತೊ. ತೆ ಮಜಾ಼ರೊನಿಯೊ ಗವಿಯೊಮಾ ರ‍್ಹತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ತೆ ದಾಣಗೊ ಯೆಸುನೆ ದೆಕಿನ ತಿನಾ ಕ್ಹಾಮೊ ಉಂದಾಗುಡ್ಗಾ ಘಾಲ್ಲಿನ ಜೊ಼ರ ಅವಾಜಕ್ಹು ಯೆಸು ಪರಾತ್ಪರನಾ ದಿಕ್ರಾ ಮಾರಾಕ್ಹು ತುನೆ ಸು ಥಾವಾನು ಛೆ ಮನೆ ಮರಗಿನ ಶಿಕ್ಕಷಾದಿವು ನಕೊ\" ಕೈನ ವದ್ರಯು. ");
INSERT INTO sle_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ಕಾಕದ್ಯಾಮ ಯೆಸು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನೆ ತಿನೆ ಛೊಡಿನ ಜಾ಼ ಕೈನ ಕದ್ಯೊ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಹಗ್ಲೆಲ್ಲಾ ತೆ ದಾಣಗಾನೆ ತಿನೆ ವಶ್ಮಾ ಲೆತಿತಿ ತೆ ದಾಣಗಾನೆ ಜೆಲ್ಮಾಘಾಲಿನ ಹತೊ ಪಗೊ ಬೆಡಿಯೊಕ್ಹು ಭಾಂದ್ಯಾತಬಿ ತೆ ದಾಣಗೊ ತೆ ಕ್ಹಾರು ತೊಡಿಲಿನ ನಾಕಿಪಾಡತೊತೊ. ತಿಮಾ ರ‍್ಹಯಲ ಕೆಟ್ಟ ಆತ್ಮಾ ತಿನೆ ಮನಕ್ಹೊ ನೈಸೊ ಜ಼ಗಾ ಜಬರದಸ್ತಿಕ್ಹು ನಿಂಜಾ಼ತುತು. ");
INSERT INTO sle_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ಯೆಸು ತಿನೆ \"ತಾರು ನಾಮ ಸುವೈ? ಕೈನ ಪುಚ್ಯೊ. ತೆ \"ಹಮಾರು ನಾಮ ಗುಂಪ ವ್ಹೈ \"ಕದ್ಯೊ. ಕಾಕದ್ಯಾಮ ತೆ ಮನಕ್ಹನಾ ಅಂಗಮಾ ಘನಿಯೊ ಕೆಟ್ಟ ಆತ್ಮಾ ವ್ಹತ್ತಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ವರಿ ತೆ ಪುರಾ ಕೆಟ್ಟ ಆತ್ಮಾ \"ಹಮೊನೆ ಪಾತಾಳಮಾ ನಕೊ ಮೊಕ್ಕಲು ಕೈನ \"ಯೆಸುಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ತ್ಯಾ ರ‍್ಹಯಲ ಯಕ್ಕ ಡೊಂಗರಪರ ಢುಕ್ಕಕುರೊನು ಮ್ಹೊಟು ಗುಂಪ ಚ಼ರಾಡುತು\" ಆ ಢುಕ್ಕಕುರೊನಾ ಅಂಗಮಾ ಜಾ಼ವಾನೆ ಹಮೊನೆ ಆಗನ್ಯಾ \"ದೆ ಕೈನ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾವೊನು ಗುಂಪ ಮಾಂಗಿಲಿದ್ಯು. ಯೆಸು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನಾ ಗುಂಪನೆ ಆಗನ್ಯಾದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ತೆಳಾಮ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾನು ಗುಂಪ ತೆ ಡುಕ್ಕಕುರೊಮಾ ವ್ಹಕ್ಕಯಾ. ತೆಳಾಮಾಜ಼ ತೆ ಢುಕ್ಕುರೊನು ಗುಂಪ ತ್ಯಾ ರ‍್ಹಯಲ ಯಕ್ಕ ತಳಾಮಾ ಡುಬಿನ ಮರಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ಡುಕ್ಕಕುರೊ ಚ಼ರಾವಾಲಾ ಆ ಕ್ಹಾರು ಥಯಲ ದೆಕಿನ ಪುರಾ ಗಾಮವಾಲಾವೊನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ತೆ ಗಾಮನಾ ಮನ್ಹಖೊ ಯೆಸುನೆ ದೆಕಾನೆ ಆಯಾ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಮನ್ಹಖ ಯೆಸುನಾ ಪಗೊಕನ ಬೈಟಲ ದೆಕ್ಯಾ. ತೆ ವಣ್ಣಾ ಘಾಲಿನ, ಅರಾಮ ಥೈನ ವರಿ ಶಾಣ್ಯೊ ಥೈನ,ಕೆಟ್ಟ ಆತ್ಮಾ ತಿನೆ ಛೊಡಿನ ಗಯಾತಾ. ಆ ದೆಕಿನ ಮನ್ಹಖೊನೆ ಭುಚ್ಕ ವಾಟ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ಯೆಸು ತೆ ಮನ್ಹಖನೆ ಅರಾಮ ಕರಲ ತರಿಕೊ ದೆಕಲವಾಲಾ ಗಾಮನಾ ಮನ್ಹಖೊನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ತೆ ಗಾಮನಾ ಮನ್ಹಖೊ ಯೆಸುನೆ\"ತು ಆ ಗಾಮ ಛೊಡಿನ ಜಾ಼ \"ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಘನ್ನಾ ಭುಚ್ಕ್ಕಯಾತಾ. ತಿನಾ ಹುತಿ ಯೆಸು ಹಡ್ಗೊ ಚ಼ಡಿನ ಜಾ಼ತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಿನ ಗಯಲ ಮನ್ಹಖ ಐನ ಯೆಸುನೆ \"ಮನೆಬಿ ತಾರಾ ಕ್ಹಾತೆ ನಿಂಜಾ಼\" ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ತಿನೆ ಯೆಸು\"ತಾರಾ ಘರೆ ಫರಿನ ಜಾ಼. ಕ್ಹುದಾ ತುನೆ ಕರಲ ಉಪಕಾರ ಮನಕ್ಹೊಕನ ಕೆ ಜಾ಼ \"ಕೈನ ತಿನೆ ತ್ಯಾಂತೊ ಮೊಕ್ಲಿಪಾಡ್ಯೊ. ತಿನಾ ಹುತಿ ತೆ ಮನಕ್ಹ ತ್ಯಾಂತೊ ಗೈನ ಯೆಸು ತಿನೆ ಕರಲ ಉಪಕಾರ ಪುರಾ ಗಾಮ್ಮಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ಯೆಸು ಬಿಜೆಕ ದಂಡಿಯೆ ಆತಾಮಾ ಮನ್ಹಖೊ ತಿನೆ ಮರಯ್ಯಾದಿಕ್ಹು ಬಲೈಲಿದ್ಯಾ. ಹರಯಕ್ಲಾ ತೆ ಆವಾನಾ ಹುತಿ ಕೈದಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ಯಾಯಿರ ಕವಾಲೊ ಯಕ್ಕ ಮನ್ಹಖ ಯೆಸುಕನ ಆಯೊ. ತೆ ಯಾಯಿರ ಸಭಾಮಂದಿರನೊ ಅದಿಕಾರಿ ವ್ಹತ್ತೊ. ಯಾಯಿರ ಯೆಸುನಾ ಪಗೊಮಾ ಪಡಿನ ಮಾರಾ ಘರೆ ಆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ಕಾಕದ್ಯಾಮ ತಿನೆ ಯಕ್ಕಲಿಜ಼ ದಿಕ್ರಿ ವ್ಹತ್ತಿ. ತೆ ಬಾರಾ ವರಕ್ಹನಿ ವ್ಹತ್ತಿ. ತೆ ಮರಾನಿ ಹಾಲತಮಾ ವ್ಹತ್ತಿ. ಯೆಸು ಯಾಯಿರನಾ ಘರೆ ಜಾ಼ತಾಮಾ ಮನ್ಹಖೊ ತಿನಾ ಸುತ್ತೆಬಿ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ತೆ ಮನಕ್ಹೊನಾ ಗುಂಪಮಾ ಬಾರಾ ವರಕ್ಹತಿಬಿ ಅಂಗಮಾನು ರಗತ ಜಾ಼ವಾಲಿ ತ್ಯಾ ಯಕ್ಕ ಹೆಣ ಮನ್ಹಖ ವ್ಹತ್ತಿ. ತಿಕನ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ದೊಕಡಾ ಡಾಕ್ಕಟರನೆ ಘಾಲಿತಿ. ತೆ ತೆಕ್ಲಾ ದೊಕಡಾ ಘಾಲಿತೊಬಿ ಕಯೊಜ಼ ಡಾಕ್ಕಟರನೆ ತಿನೆ ಅರಾಮ ಕರಾನೆ ಥಯುನೈ. ");
INSERT INTO sle_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ತೆಳಾಮಾ ತೆ ಹೆಣ ಮನ್ಹಖ ಯೆಸುನಾ ಪಾಚಿ಼ ಐನ ಯೆಸುನು ಅಂಗ್ಡು ಮುಟ್ಟಿ. ತೆ ಹೆಣ ಮನ್ಹಖ ಯೆಸುನು ಅಂಗ್ಡು ಧರಲ ಬರೊಬ್ಬರ ತಿನೆ ಅರಾಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ತೆಳಾಮಾ ಯೆಸು \"ಮನೆ ಧರಲವಾಲು ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ಕ್ಹಾರಾ ಮನ್ಹಖೊ ಹಮೆ ನತ್ತಿ ಧರ‍್ಯಾ ಕದ್ಯಾ. ತೆಳಾಮಾ ಪೆತ್ರಾ\"ಗುರು,ಅಕ್ಲಾ ಮನ್ಹಖೊ ತುಪರ ಪಡಿನ ಢಕ್ಕಲಾಡಾಸ್ತೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ತೆನೈಸೊ ಯೆಸು ತಿನೆ ಕುನ್ನ ಯಕ್ಕ ಮನೆ ಧರಯು! ಮಾರಾಮಾತಿ ತಾಕತ ಚಾ಼ಲಿಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಥಯು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ಹಮ್ನಾ ಮಿ ದಡಿ ರ‍್ಹವಾನು ಚೊ಼ಕು ನ್ಹವೈ ಕೈನ ತಿಳ್ದಿನ ತೆ ಹೆಣ ಮನಕ್ಹ ಯೆಸುನಾ ಕ್ಹಾಮಿ ಐನ ತಿನಾ ಪಗೊಮಾ ಪಡಿನ ತೆ ಯೆಸುನೆ ಶಾನಾ ಹುತಿ ಮುಟ್ಟಿಕವಾನು ವರಿ ಯೆಸುನೆ ಮುಟ್ಟಲ ಬರೊಬ್ಬರ ತಿನೆ ಅರಾಮ ಥಯು ಕೈನ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮಿ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ\"ದಿಕ್ರಿ, ತಾರೊ ಬರೊಕ್ಹೊ ತುನೆ ಅರಾಮ ಕರ‍್ಯೊಸ. ತು ಸಮಾದಾನ ಕ್ಹು ಜಾ಼\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ಯೆಸು ಹಜು಼ನ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾ ಸಬಾಮಂದಿರನೊ ಅದಿಕಾರಿಯೊಮಾನೊ ಯಾಯಿರ ಕವಾಲಾನಾ ಘರ್ತೊ ಐನ \"ತಾರಿ ದಿಕ್ರಿ ಮರಿಗೈಸ ತು ಹಮ್ನಾ ಗುರುನೆ ಕಾ ತ್ರಾಸ ಕರಾಡ್ಯೊಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ಯೆಸು ತೆ ಐಕಿನ ಯಾಯಿರನೆ\"ಭುಚ್ಕು ನಕೊ. ಧೈರ್ಯಕ್ಹು ರ‍್ಹೆ ಬರೊಕ್ಹೊ ರ‍್ಹವಾದೆ ತಾರಿ ದಿಕ್ರಿನೆ ಅರಾಮ ಥಾವಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ಯೆಸು ಯಾಯಿರನಾ ಘರೆ ಗಯೊ. ಪೆತ್ರಾನೆ, ಯೊಹಾನನೆ, ಯಾಕೊಬನೆ ವರಿ ಚೊ಼ಕ್ಕರಿನಾ ಮಾ ಬಾಪನೆ ತಿನಾ ಕ್ಹಾತೆ ಆವಾನೆ ಕದ್ಯೊ. ವರಿ ಬಿಜು಼ ಕುನ್ನಜ಼ ಔ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ಮರಿಗಯಲ ತೆ ಚೊ಼ಕ್ಕರಿನಾ ಹುತಿ ಕ್ಹಾರಾ ಜ಼ನಾ ರವಾಡ್ಯಾತಾ. ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ \"ರವೊ ನಕೊ, ತೆ ಮರಿ ನತ್ತಿ; ಕ್ಹುರೈಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ತಿಮ್ಮ ಕತಾಮಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಕದ್ರಾಯಾ. ಕಾಕದ್ಯಾಮ ತೆ ಚೊ಼ಕ್ಕರಿ ಮರಿಗೈಸ ಕೈನ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ಯೆಸು ಮರಿಗಯಲ ಛೊಕ್ರಿನೊ ಹತ ಧರಿನ \"ದಿಕ್ರಿ ಉಟ್ಟ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ತೆಳಾಮಾಜ಼ ತಿನೆ ಜ಼ಲಮ ಆಯೊ. ತೆ ಛೊಕ್ರಿ ಉಟಿನ ಹುಬ್ರೈ. ಯೆಸು ತಿನಾ ಮಾ ಬಾಪನೆ\"ತೆ ಛೊಕ್ರಿನೆ ಕ್ಹಾವಾನೆ ಸುಬಿ ದಿವೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ಛೊಕ್ರಿನಾ ಮಾ ಬಾಪ ಘಾಬ್ರಾ ಥಯಾ. ಎ ಥಯಲ ವಾತ ಕಿನೆಜ಼಼ ಕವೊ ನಕೊ ಕೈನ ಯೆಸು ತ್ಯುನೊನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ಯೆಸು ಬಾರಾ ಅಪೊಸ್ತಲೊನೆ ಬಲೈನ, ತ್ಯುನೊನೆ ರೊಗೊನೆ ಅರಾಮ ಕರಾನಿ ತಾಕತ ದಿನ್ನ ಕೆಟ್ಟ ಆತ್ಮಾವೊಪರ ಅದಿಕಾರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ಕವಾ ಹುತಿ ವರಿ ರೊಗೊಮಾ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಅರಾಮ ಕರಾ ಹುತಿ ಯೆಸು ಅಪೊಸ್ತಲೊನೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ತೆಳಾಮಾ ಯೆಸು ಅಪೊಸ್ತಲೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ತುಮೆ ಗಾಮೊಯೆ ಜಾ಼ತಾಮಾ ಲಾಕ್ಡಿ ನಕೊ ಕೈಚಿಲಾ ನಕೊ ದೊಕಡಾ ನಕೊ ಭುತ್ತಿ ನಕೊ. ಬೆ ಅಂಗ್ಡಾ ನಕೊ ನಿಂಜಾ಼ವೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ತುಮೆ ಕಯಾಬಿ ಯಕ್ಕ ಘರಮಾ ರ‍್ಹತಾಮಾ ತೆ ಗಾಮ ಛೊಡಿನ ಜಾ಼ಯೆಲಕ್ಕಾ ತ್ಯಾಜ಼ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ವರಿ ಕಯಾಬಿ ಗಾಮ ವಾಲಾ ತುಮೊನೆ ಮಳೈ ನೈ ಲಿದ್ಯಾಮ ತುಮೆ ತೆ ಗಾಮ ಛೊಡಿನ ಜಾ಼ತಾಮಾ ತಮಾರಾ ಪಗನೆ ಲಾಗಲ ಧುಳ್ಳ ಝಾಡ್ಸಿ ಲಿವೊ ತೆ ತ್ಯುನೊನೆ ಸಾಕ್ಷಿ ಥೈನ ರ‍್ಹವಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ತೆಳಾಮಾ ತೆ ಬಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊ ಗಾಮೊಪರ ಗೈನ ತ್ಯಾ-ತ್ಯಾ ಸುವಾರ್ತೆ ಕೈನ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರತಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ಯೆಸುನಾ ಹುತಿ ವರಿ ಅಪೊಸ್ತಲೊ ಕರಲ ಅದ್ಭುತ ಕಾಮೊಕ್ಹು ರಾಜ್ಯಪಾಲ ಥಯಲ ಹೆರೊದ ಘನ್ನೊ ಗಲಿಬಿಲಿ ಥಯೊ ಕಾಕದ್ಯಾಮ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನಜ಼ ಮರಲವಾಲಾವೊಮಾತೊ ಉಟ್ಯೊಸು? ಕೈನ ದಕ್ಹಾ ಜ಼ನಾ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ಹಜು಼ನ ದಕ್ಹಾ ಜ಼ನಾ \"ಪ್ರವಾದಿ ಥಯಲ ಎಲಿಯಾ ಅಪೊಕನ ಆಯೊಸ ಕವಾಡಾತಾ. ಹಜು಼ನ ದಕ್ಹಾಜ಼಼ನಾ ಪೈಲಾ ರ‍್ಹಯಲ ಪ್ರವಾದಿಮಾನೊ ಯಕ್ಲೊ ಜಿವ್ತೊ ಥೈನ ಉಟ್ಯೊಸ\" ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ತೆಳಾಮಾ ಅದಿಕಾರಿ ಹೆರೊದ \"ಮಿ ಯೊಹಾನನಿ ಗರದನ ಕತ್ರಯೊಸ ವರಿ ಎ ಕ್ಹಾರು ಅದ್ಬುತ ಕರಾಲೊ ಎ ಮನಕ್ಹ ಕುನ್ನ ವ್ಹೈ? ವಿಚಾರ ಕರತೊ ಯೆಸುನೆ ದೆಕಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ಅಪೊಸ್ತಲೊ ಸುವಾರ್ತೆ ಕೈನ ಮುಗ್ಸಿನ ಐನ ತ್ಯುನೆ ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊ ಯೆಸುಕನ ಕದ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಬೆತ್ಸಾಯ ಕವಾನಾ ಗಾಮ್ನಾ ನಜಿ಼ಕ ಬಲೈ ನಿಂಗೈಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ವರಿ ಯೆಸು ತ್ಯಾ ಗಯಲ ಮನಕ್ಹೊನೆ ಗೊತ್ತ ಥಯು ತೆ ಮನಕ್ಹೊ ಯೆಸುನಾ ಪಾಚಾ಼-ಪಾಚಾ಼ ಗಯಾ. ಯೆಸು ತ್ಯುನೊನೆ ಬಲೈನ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ತ್ಯುನೊನೆ ಕದ್ಯೊ. ರೊಗ್ಮಾ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ತೆ ದಿನ್ನಾ ಕ್ಹಾಂಜೆ಼ ಬಾರಾ ಶಿಷ್ಯಾ ಯೆಸುಕನ ಐನ, ಎ ಜ಼ಗಾಪರ ಕುನ್ನಜ಼ ರ‍್ಹತು ನೈ ತಿನಾ ಹುತಿ ಮನಕ್ಹೊನಾ ಗುಂಪ್ನೆ ಮೊಕ್ಲಿಪಾಡ ತ್ಯುನೆ ಸುತ್ತೆ ಮುತ್ತೆ ರ‍್ಹಯಲ ಗಾಮೊಯೆ ಗೈನ ತ್ಯುನೊನೆ ಖಾವಾನ ಅನ್ನನಾ ಹುತಿ ವೆವಸ್ತಾ ಕರಲಿವಾದೆ ವರಿ ರ‍್ಹವಾನೆ ಜ಼ಗಾ ಕರಲಿವಾದೆ ");
INSERT INTO sle_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ವರಿ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ \"ತುಮೆಜ಼ ತ್ಯುನೊನೆ ಖಾವಾನೆ ಅನ್ನ ದಿವೊತೊ \"ಕದ್ಯೊ, ತೆ ವಾತೆ ಶಿಷ್ಯಾ \"ಹಮೊಕನ ಖಾಲಿ ಪಾಂಚ಼ ರೊಕ್ಲಾ ವರಿ ಬೆ ಮಚ್ಲಿ಼ಯೊ ಛೆ ಹಮೆ ಗೈನ ಆ ಮನಕ್ಹೊನೆ ಖಾವಾನೆ ಅನ್ನ ಇಕ್ಕಾತು ಲಾಯ್ಯೆಸು? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ತ್ಯಾ ಕಮ್ಸಿ ಕಮ ಪಾಂಚ಼ ಹಜಾ಼ರ ದಾಣ್ಗಾ ವ್ಹತ್ತಾ, ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ \"ಇವನೊನೆ ಐವತ್ತ-ಐವತ್ತ ಜ಼ನಾವೊನೆ ಸಾಲೆ ಬೈಟಾಡೊ \"ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ತೆಳಾಮಾ ತೆ ಕದಲತಿಮ್ಮ ತ್ಯುನೆ ಕರ‍್ಯಾ ತೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಬೈಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ತೆಳಾಮಾ ಯೆಸು ತೆ ಪಾಂಚ಼ ರೊಕ್ಲಾ ವರಿ ಬೆ ಮಚ್ಲಿ಼ಯೊ ಹತ್ಮಾ ಲಿನ ಸ್ವರಗನೆ ದೆಕಿನ ತೆ ಅನ್ನನಾ ಹುತಿ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ಪಾಚಲ್ತೊ ಯೆಸು ತೆ ರೊಕ್ಲಾ ಭಾಗಿನ ಶಿಷ್ಯಾವೊನೆ ಮನಕ್ಹೊನೆ ವಾಟೊ ಕೈ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ಹರ ಯಕ್ಲೊ ಪೆಟ ಭರಿನ ಖೈನ ತೃಪ್ತ ಥಯಾ ಉಗ್ರಲ ತುಕ್ಡಾ ಮಳಾತಾಮಾ ಬಾರಾ ಟೊಪ್ಲಿಯೊ ಭರಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ಯಕ್ಕದಿನ ಯೆಸು ಯಕ್ಕಲೊಜ಼ ಪ್ರಾಥನಾ ಕರತಾಮಾ, ತಿನಾ ಶಿಷ್ಯಾಮಳಿನ ತಿಕನ ಆಯಾ, ಯೆಸು ತ್ಯುನೊನೆ ಮನಕ್ಹೊ ಮನೆ ಕುನ್ನ ವ್ಹೈ ಕವಸ? ಕೈನ ಪುಚ್ಯೊ಼. ");
INSERT INTO sle_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ತೆ ವಾತೆ ಶಿಷ್ಯಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ತುನೆ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ಯೊಹಾನ ವ್ಹೈ ಕವಸ. ಹಜು಼ನ ದಕ್ಹಾ ಜ಼ನಾ ಎಲಿಯಾ ವ್ಹೈ ಕವಸ, ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಪಾಚೊ಼ ರ‍್ಹಯಲ ಪ್ರವಾದಿಯೊಮಾನೊ ಯಕ್ಲೊ ಜುತೊ ಥೈನ ಉಟಿನ ಆಯೊಸ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ತೆಳಾಮಾ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ\"ಮನೆ ತುಮೆ ಕುನ್ನ ವ್ಹೈ ಕವೊಸಿ\" ಕೈನ ಪುಚ್ಯೊ ಪೆತ್ರಾ ಯೆಸುನೆ \"ತು ಕ್ಹುದಾನೊ ಮಸ್ಸಿಹಾ ವ್ಹೈ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ಎ ವಾತ ಕಿನೆಜ಼಼ ಕವೊ ನಕೊ ಕೈನ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ ಅಪ್ಪಣೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ಪಾಚಲ್ತೊ ಯೆಸು ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಘನ್ನೊ ತ್ರಾಸ ತಡ್ದಿಲಿನ ಯಹುದ್ಯನಾ ನಾಯಕೊನಾ ಹತೆ ಖಾಸ ಯಾಜಕೊನಾ ಹತೆ ಶಾಸ್ತ್ರಿಯೊನಾ ಹತೆ ಇನ್ಕಾರ ಥೈನ ಮರವಾನೆ ಶಿಕ್ಷಾ ದಿಲಾವಸ ವರಿ ತೆ ಮರಿನ ತನ ದಿನ್ಪರ‍ ಜುತೊ ಥೈನ ಉಟಿನ ಆವಸ \"ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ಯೆಸು ತಿನಿಯೊ ವಾತೊ ಕತೊ ತೆ ಕ್ಹಾರಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ಮಾರಾ ಪಾಚೊ಼ ಔಸ ಕವಾಲೊ ತೆ ತಿನೊ ಕ್ಹಾರು ಇಕ್ಹರಿನ ದಿನ್ನೆಬಿ ತಿನಿ ಶಿಲುಬಿ ಉಚೈಲಿನ ಮಾರಾ ಪಾಚೊ಼ ಆವಾದೆ \"ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ಕುನ್ನ ತಿನೊ ಜ಼ಲಮ ವಚಾ಼ಡಿಲಿವುಸ್ ಕವಾಲೊ ತಿನೊ ಜ಼ಲಮ ಜ಼಼ವೈಲಿವಸ, ಮಾರಾಹುತಿ ತಿನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿವಾಲೊ ತಿನೊ ಜ಼ಲಮ ವಚಾ಼ಡಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ಯಕ್ಲೊ ಜಗತಮಾನು ಕ್ಹಾರು ಗಳ್ಸಿನ ಮಕ್ಕಯೊಮ ತಿನೆ ತೆ ತಿನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿದ್ಯೊಮ ತಿನಾ ಹುತಿ ತಿಕ್ಹು ಸು ತಿನೆ ಫೈದೊ ಛೆ? ");
INSERT INTO sle_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ಕಯೊಬಿ ಮಕ್ಹು ವರಿ ಮಾರಿಯೊ ವಾತೊಕ್ಹು ಸರಮಾವಸ ಮಿ ಮಹಿಮಾನಾ ಕ್ಹಾತೆ ಬಾ ನಿ ಮಹಿಮಾನಾ ಕ್ಹಾತೆ ವರಿ ಸ್ವರಗನಾ ಪರಿಶುದ್ಧ ದುತೊನಾ ಮಹಿಮಾನಾ ಕ್ಹಾತೆ ಆತಾಮಾ ತಿನೆ ದೆಕಿನ ಮಿ ಸರಮಾವುಸ. ");
INSERT INTO sle_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ಮಿ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ ನ್ಹ್ಯಾ ರ‍್ಹಯಲ ವಾಲಾವೊಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ದೆಕೆ ಲಕ್ಕಾ ಮರತಾಜ಼ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ಎಕ್ಹಾರು ಕೈನ ಆಟದಿನ ಥಯಲ್ಪರ ಯೆಸು ಪೆತ್ರಾ ಯಾಕೊಬ ವರಿ ಯೊಹಾನನೆ ಬಲೈ ನಿಂಗೈನ ಪ್ರಾಥನಾ ಕರಾ ಹುತಿ ಡೊಂಗರಪರ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ಯೆಸು ಪ್ರಾಥನಾ ಕರತಾಮಾ ತಿನು ಮ್ಹೊಡು ಬದ್ಲಿ ಥಯು ಮಿಂಚಾ಼ಡ್ಯುತು, ತಿನಾ ವಣ್ಣಾ ಘನ್ನಾ ಮಿಂಚಾ಼ಡ್ಯಾತಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ತೆಳಾಮಾಜ಼ ಬೆ ಜ಼ನಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ಬೊಲಾಡ್ಯಾತಾ ತ್ಯುನೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ ಮೊಶೆ ವರಿ ಎಲಿಯಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ಎ ಭಂಬಿಜ಼಼ನಾವೊನು ರುಪಬಿ ಘನ್ನು ಮಿಂಚಾ಼ಡ್ಯುತು ಕ್ಹುದಾನಿ ಚಿತ್ತ ಥಾವಾನಾ ಹುತಿ ವರಿ ಯೆರುಸೆಲಿಮಾ ಥಾವಾನು ಯೆಸು ಮರವಾನಾ ಹುತಿ ಬೊಲಾಡ್ಯಾತಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ಘನ್ನಿ ನಿಂದರಮಾ ರ‍್ಹಯಲ ಪೆತ್ರಾ ವರಿ ಯಾಕೊಬ, ಯೊಹಾನ ಹುಶಾರ ಥೈನ ಉಟ್ತಾಮಾ ಯೆಸುನಿ ಮಹಿಮಾ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ಬೆ ಜ಼ನಾ ಬೊಲಾನು ದೆಕ್ಯಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ತೆ ಬೆ ಜ಼ನಾ ಯೆಸುನೆ ಚೊ಼ಡಿನ ಜಾ಼ತಾಮಾ ಪೆತ್ರಾ ಯೆಸುನೆ ಗುರು ಅಪೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹವಾನು ಚೊ಼ಕು ವ್ಹೈ ನ್ಹ್ಯಾಜ಼ ಅಪೆ ತನ ಝುಪ್ಡಾ ಭಾಂದಿಯೆ ತುನೆ ಯಕ್ಕ ಮೊಶೆನೆ ಯಕ್ಕ ಎಲಿಯಾನೆ ಯಕ್ಕ ತುನೆ ಕದ್ಯೊ. ಪೆತ್ರಾ ಸು ಕವಾಡ್ಯೊಸ ತಿನೆಜ಼ ಗೊತ್ತ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ಪೆತ್ರಾ ಎಕ್ಹಾರು ಕತಾಮಾ ಮ್ಹಾಡ ಐನ ಛವ್ಲಿ ಲಿಂಗತ ತ್ಯುನಾ ಸುತ್ತೆ ಫೈಲಿ ಗಯು ತೆಳಾಮಾ ಶಿಷ್ಯಾ ಘನ್ನಾ ಭುಚ್ಕಾ಼ ವರಕ್ಹಾ ಥಯಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ತೆಳಾಮಾಜ಼ ತೆ ಮ್ಹಾಡ ಮಾತು ಅವಾಜ಼ ಐಯು \"ಎ ಮಾರೊ ಮಯಾನೊ ಥಯಲ ದಿಕ್ರೊ ವ್ಹೈ ಮಿ ಇನೆ ಇನಿಲಿದ್ಯೊಸ ಇನೆ ತುಮೆ ತಿನೆ ವಿದೆಯ (ವಿಧೆಯೆ ಕದ್ಯಾಮ ತಿನು ಕ್ಹಾರುಜ಼ ಐಕಿನ ಚಾ಼ಲಾನು) ಥಾವೊ \"ಕವಾನು. ");
INSERT INTO sle_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ಎ ವಾತ ಥಯಲಪರ ತ್ಯುನೆ ಯೆಸುನೆ ಛೊಡಿನ ಬಿಜು಼ ಸುಜ಼ ದಿಕ್ಹ್ಯು ನೈ ಶಿಷ್ಯಾ ದೆಕಲ ಕ್ಹಾರು ಯಕ್ಕಬಿ ತೆ ದಿನೊಮಾ ಕಿನೆಜ಼಼ ಕದ್ಯಾ ವಾಚಿ ಗಪ್ಪಜ಼ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ಮರ್ನಾ ದಿನ್ನೆ ಯೆಸು, ತಿನಾ ತನ್ನೆ ಶಿಷ್ಯಾ ಡೊಂಗರಪರತಾ ಉತ್ರಿನ ಆಯಾ. ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ಯೆಸುನಾ ಕ್ಹಾಮೊ ಆಯು. ");
INSERT INTO sle_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ಗುಂಪ್ಮಾ ರ‍್ಹಯಲ ಯಕ್ಲೊ ಮನಕ್ಹ ವದ್ರಿನ \"ಗುರು \"ಮರಗಿನ ಮಾರಾ ದಿಕ್ರಾನೆ ದೆಕ ಮನೆ ತೆಜ಼ ಯಕ್ಲೊ ದಿಕ್ರೊ ಛೆ ");
INSERT INTO sle_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ಯಕ್ಕ ಕೆಟ್ಟ ಆತ್ಮಾ ಮಾರಾ ದಿಕ್ರಾಪರ ಆವಸ ತೆಳಾಮಾ ತೆ ವದ್ರಾಡ್ಯಾಸ ಮ್ಹೊಡಾ ಮಾತು ಬುರುಕ ಚು಼ವಾವಸ, ಕೆಟ್ಟ ಆತ್ಮಾ ತಿನೆ ಘನ್ನೊ ತ್ರಾಸ ದಿವಸ ವರಿ ಪಾಡಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ಮಾರಾ ದಿಕ್ರಾಮಾತು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾಕೈನ ತಾರಾ ಶಿಷ್ಯಾವೊಕನ ಮಾಂಗಲಿದ್ಯೊ ತೆನೈಸೊ ತಿವ್ನಾ ಹತೆ ಥಯು ನೈ ಕೈನ ಯೆಸುಕನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನಾ ಶಿಷ್ಯಾವೊಕನ ದೆಕಿನ ಬರೊಕ್ಹೊ ನೈಸೊ ವಾಲಾವೊನೆ ಹಜು಼ನ ಕೆಕ್ಕಲಾ ದಿನ್ನ ತುಮಾರಾ ಕ್ಹಾತೆ ಮಿ ತಡ್ದಿಲಿನ ರ‍್ಹೌ? ಕದ್ಯೊ ತೆ ಮನಕ್ಹನೆ ತಾರಾ ದಿಕ್ರಾನೆ ನ್ಹ್ಯಾ ಬಲೈಲಿನಾ ಆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ತೆ ಪಟ್ಟೊ ಆತಾಮಾ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತಿನೆ ಜಿಮಿನ್ಪರ ಪಾಡಿನ ಪಟ್ಟಾನೆ ವದ್ಯಾಡ್ಸಿನ ತೆಳಾಮಾ ಯೆಸು ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ನೆ ಭುಚ್ಕಾ಼ಡಿನ ತೆ ಪಟ್ಟಾನೆ ಅರಾಮ ಕರ‍್ಯೊ, ಪಾಚಲ್ತೊ ತೆ ಪಟ್ಟಾನೆ ತಿನಾ ಬಾನಾ ಹತ್ಮಾ ವಪ್ಸಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಕ್ಹುದಾನಿ ಮ್ಹೊಟಿ ತಾಕತನೆ ದೆಕಿನ ಘಾಬ್ರಾಥಯಾ. ಯೆಸು ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊ ದೆಕಿನ ಮನಕ್ಹೊ ವರಿ ದಕ್ಹಾ ಘಾಬ್ರಾ ಥಯಾ. ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ");
INSERT INTO sle_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ದಕ್ಹಾ ಜ಼ನಾವೊನಾ ಅದಿಕಾರಮಾ ವಪ್ಸಸ್ ಎ ತುಮೆ ಇಕ್ಹರು ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ತೆನೈಸೊ ಶಿಷ್ಯಾವೊನೆ ತಿಳದ್ಯುನೈ ಕಾಕದ್ಯಾಮ ತೆ ವಾತೊನೊ ಮತ್ಲಬ್ ಝಕಾಯಲ ವ್ಹತ್ತು ವರಿಬಿ ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿನೆ ಪುಚ್ಚಾ಼ನೆ ಭುಚ್ಕ್ಕಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ಯೆಸುನಾ ಶಿಷ್ಯಾ ತ್ಯುನಾಮಾ ಕುನ್ನ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ, ");
INSERT INTO sle_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ತ್ಯುನಿಯೊ ಮನಸ್ಸಮಾನಿ ವಿಚಾರ ಯೆಸುನೆ ಗೊತ್ತ ಥಯುತು, ತಿನಾಹುತಿ ಯೆಸು ಯಕ್ಕ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ನೆ ಬಲೈನ ತಿಕನ ಹುಬ್ರಾಡಿ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ಪಾಚಲ್ತೊ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ \"ಯಕ್ಲೊ ಮಾರಾ ನಾಮಪರ ಯಕ್ಕ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ನೆ ಮಳೈ ಲಿದ್ಯೊಮ ತೆ ಮನೆ ಮಳೈಲಿದಲ ಲಿಂಗತ ವ್ಹೈ, ವರಿ ಯಕ್ಲೊ ಮನೆ ಮಳೈ ಲಿದ್ಯೊಮ ತೆ ಮನೆ ಮೊಕ್ಲಲವಾಲಾನೆ (ಕ್ಹುದಾನೆ) ಮಳೈಲಿದಲ ಲಿಂಗತ ವ್ಹೈ ಕದ್ಯೊ. ವರಿ ತುಮೊಮಾ ಕುನ್ನ ನ್ಹಾನೊ ವ್ಹೈ ತೆಜ಼ ಮ್ಹೊಟೊ ವ್ಹೈ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ಯೊಹಾನ ಯೆಸುನೆ ಕದ್ಯೊ\"ಗುರು, ತಾರಾ ನಾಮ ಪರ ಮನಕ್ಹೊಮಾ ರ‍್ಹಯಲ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾವಾನು ಹಮೆ ಯಕ್ಲಾನೆ ದೆಕ್ಯಾ. ತಿನೆ ಹಮೆ ತಡದ್ಯಾ \"ಕಾಕದ್ಯಾಮ ತೆ ಹಮೊಮಾನೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ತೆ ವಾತೆ ಯೆಸು\"ತಿನೆ ತರಬೊ ನಕೊ, ಕಾಕದ್ಯಾಮ ತುಮೊನೆ ವಿರೊದ ನೈ ರ‍್ಹಯಲ ವಾಲೊ ತುಮಾರೊಜ಼ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ಯೆಸು ವರಿ ಸ್ವರಗೆ ಜಾ಼ವಾನೊ ಟೈಮ ನಜಿಕ ಆವಾಡ್ಯೊಸ, ತಿನಾಹುತಿ ಯೆರುಸೆಲೆಮೆ ಜಾ಼ವಾನಾ ಹುತಿ ಮನಸ್ಸ ಘಟ್ಟ ಕರಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ಯೆಸು ತಿನಾ ಸಂದೆಶ ಕವಾಲಾವೊನೆ ತಿನಾತಿ ಅಗೊ ಮೊಕಲ್ಯೊ. ಯೆಸುನಾ ಹುತಿ ಕ್ಹಾರು ತಯ್ಯಾರ ಕರಾನೆ ತ್ಯುನೆ ಸಮರಯಾ ಗಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ತೆನೈಸೊ ತೆ ಯೆರೊಸೆಲಿಮೆ ಜಾ಼ವಾನು ಕಾರಣ ಸು ವ್ಹೈ ಕದ್ಯಾಮ ಸಮರಯಾನಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಮರ್ಯಾದಿ ದಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ಯೆಸುನಾ ಶಿಷ್ಯಾ ಯಾಕೊಬ ವರಿ ಯೊಹಾನ \"ಎ ದೆಕಿನ ಸ್ವಾಮಿ ಹಬಾಳಮಾತಿ ಆಗ ಪಡಿನ ಇವ್ನೊನೆ ಬಾಳಿಪಾಡಾದೆ ಕೈನ ಮಾಂಗಿಲಿಯೆಸು\" ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ ದೆಕಿನ ಭುಚ್ಕಾ಼ಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ಪಾಚಾ಼ತಾ ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಬಿಜೆಕ ಗಾಮೆ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ತ್ಯುನೆ ವಾಟ್ಮಾ ಜಾ಼ತಾಮಾ ಯಕ್ಲೊ ಯೆಸುನೆ \"ತು ಕಿಜಾ಼ ಗಯೊತಬಿ ಮಿ ತಾರಾ ಪಾಚೊ಼ ಔಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ಯೆಸು ತಿನೆ ದೆಕಿನ ಕದ್ಯೊ \"ನರಿಯೊನೆ ಘರೊ ಛೆ, ಪಕ್ಕಷಿಯೊನೆ ಗುಡ ಛೆ. ತೆನೈಸೊ ಮನಕ್ಹಾನಾ ದಿಕ್ರಾನೆ ಮಾತು ಮುಕ್ಕಕಾ ಯಕ್ಕಲಿ ಜ಼ಗಾ ನತ್ತಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ಯೆಸು ಹಜು಼ನ ಯಕ್ಲಾನೆ \"ಮಾರಾ ಪಾಚೊ಼ ಆ\"ಕದ್ಯೊ. ವರಿ ತೆ ಸ್ವಾಮಿ ಮಿ ಪೈಲಾ ಗೈನ ಮಾರಾ ಬಾನು ತನ್ನ ದಿನ್ನು ಕಾರಾನೆ ಮೌಕೊ ದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ಯೆಸು ತಿನೆ \"ಮರಲ ಮನಕ್ಹೊ ತಿವ್ನೊಮಾ ಮರಿನ ಗಯಲವಾಲಾ ತ್ಯುನೆ ತೆ ಕರಾದೆ! ತು ಗೈನ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ಮನಕ್ಹೊಕನ ಕೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ಬಿಜೆಕ್ಲೊ \"ಸ್ವಾಮಿ, ಮಿ ತಾರಾ ಪಾಚೊ಼ ಔಸ ಪೈಲಾ ಮಾರಾ ಘರವಾಲಾವೊನೆ ಗೈನ ಮಳಿನ ಆವಾನೆ ಮೌಕೊ ದೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ಯೆಸು\"ರ‍್ಹಂಟಿಪರ ಹತ ಘಾಲಿನ ಪಾಚೊ಼ ದೆಕಾಲೊ ತೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯನೆ ಯೊಗೈ ನ್ಹವೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ತೆ ಥಯಲ್ಪರ ಯೆಸು ಸತ್ತರಪರ ಬೆ ಜ಼ನಾವೊನೆ ಇನಿಲಿನ ತೆ ಜೌ಼ ಕೈನ ವಿಚಾರ ಕರಲಿದಲ ಗಾಮೊಯೆ ತ್ಯುನೊನೆ ಬೆ-ಬೆ ಜ಼ನಾವೊನೆ ಪೈಲಾಜ಼ ಮೊಕ್ಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ಯೆಸು ತ್ಯುನೊನೆ \"ಬೆಳಿ (ಮನಕ್ಹೊ) ಘನ್ನಿ ಛೆ ತೆನೈಸೊ ಕಾಮ ಕರಾಲಾ ಕಮ ಛೆ ಕ್ಹುದಾ ಬೆಳಿನೊ ಮಾಲಕ ವ್ಹೈ ವರಿ ಬೆಳಿ ಮಳಾವಾನೆ ಘನ್ನಾ ಕಾಮ ಕರಾಲಾ ಚಾ಼ಯೆ ಕೈನ ಮಾಲಕಕನ (ಕ್ಹುದಾಕನ) ಮಾಂಗಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ಹಮ್ನಾ ತುಮೆ ಜಾ಼ ಸಕೊಸಿ ವರಿ ಮಾರಿಯೊ ವಾತೊ ಐಕೊ ನರಿಯೊನಾ ವಚ್ಮಾ಼ ಬಕ್ರಾವೊನೆ ಮೊಕ್ಕಲಾಲಾಲಿಂಗತ ತುಮೊನೆ ಮೊಕ್ಕಲಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ಕೈಚಿಲಾ ರ‍್ಹೈನೆಕಾ ದೊಕ್ಡಾ ರ‍್ಹೈನೆಕಾ ಚಪ್ಲೊ ರ‍್ಹೈನೆಕಾ ನಿಂಜಾ಼ವೊನಕೊ, ವಾಟ್ಮಾ ಹುಬ್ರೈನ ಮನಕ್ಹೊನೆ ಚೊ಼ಕು ಥಾವಾದೆ ಕೈನ ಬೊಲೊನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ತುಮೆ ಘರಮಾ ಜಾ಼ವಾತಿ ಅಗ್ದುರಜ಼ ಆ ಘರಮಾ ಸಮಾಧಾನ ರ‍್ಹವಾದೆ ಕೈನ ತುಮೆ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ತೆ ಘರಲ್ಯಾ ಮನಕ್ಹೊ ಶಾಂತಿ ಸಮಾಧಾನವಾಲಾ ರ‍್ಹಯಾಮ ತುಮಾರೊ ಆಶಿರ್ವಾದ ತ್ಯುನೊಪರ ರ‍್ಹವಸ. ನೈತೊ ತೆ ಆಶಿರ್ವಾದ ತುಮೊನೆ ಫರಿನ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ತೆ ಘರಮಾ ರ‍್ಹೈನ ತ್ಯುನೆ ದಿವಾನು ಅನ್ನ ತುಮೆ ಖಾವೊ ವರಿ ತ್ಯುನೆ ದಿವಾನು ತುಮೆ ಪಿವೊ, ಕಾಮಕರಾಲೊ ಪಗಾರನೆ ಲಾಯಕ ವ್ಹೈ ತಿನಾಹುತಿ ತೆ ಘರ ಛೊಡಿನ ಬಿಜೆಕ ಘರಮಾ ಜಾ಼ವೊನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ತುಮೆ ಯಕ್ಕ ಗಾಮೆ ಜಾ಼ತಾಮಾ ತೆ ಗಾಮ್ನಾ ಮನಕ್ಹೊ ತುಮೊನೆ ಮಳೈ ಲಿದ್ಯಾಮ,ತ್ಯುನೆ ದಿವಾನು ಅನ್ನ ಖಾವೊ ");
INSERT INTO sle_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ತ್ಯಾ ರ‍್ಹಯಲ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರೊ, ತ್ಯಾನಾ ಮನಕ್ಹೊನೆ\"ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನಜಿಕ ಐಸ \"ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ತೆನೈಸೊ ತುಮೆ ಯಕ್ಕ ಗಾಮೆ ಜಾ಼ತಾಮಾ ತ್ಯಾನಾ ಮನಕ್ಹೊ ತುಮೊನೆ ನೈ ಮಳೈ ಲಿದ್ಯಾಮ ತುಮೆ ತೆ ಗಾಮ್ನಿಯೊ ಒಣಿಯೊಮಾ ಗೈನ, ");
INSERT INTO sle_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ಅಪ್ನಾ ಪಗೊನೆ ಲಾಗಲ ಧುಳ್ಳ ತೆ ಗಾಮ್ನಾ ವಿರುದ್ದ ಝಾಡ್ಸಿಲಿಪಾಡಿಯೆಸ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನಜಿಕ ಆವಾಡಿಸ ಕವಾನು ತುಮೊನೆ ಕಳಾದೆ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಕ್ಹುದಾನಿ ನ್ಯಾಯ ಫೈಸಲಾನಾ ದಿನಮಾ ತೆ ಮನಕ್ಹೊನಿ ಗತಿ ಸೊದೊಮ ಗಾಮ್ನಾ ಮನಕ್ಹೊನಿ ಗತಿತಿಬಿ ಕಠಿಣ ಥಾವಸ ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","\"ಕೊರಾಜಿನ ಬೆತ್ಸಾಯಿವಾಲಾ, ತಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ತುಮೊಮಾ ಮಿ ಘನ್ನಾ ಸುಚಕ ಕಾಮೊ ಕರ‍್ಯೊ ತೆಜ಼ ಸುಚಕ ಕಾಮೊ ತೊರ ವರಿ ಸಿದೊನ ಗಾಮೊಮಾ ಥಾವತ್ತೊ. ತ್ಯಾನಾ ಮನಕ್ಹೊ ಪೈಲಾಜ಼ ತ್ಯುನಾ ಪಾಪೊ ಛೊಡಿನ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕೊತ್ಳಾವೊನಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ರಾಕ ಅಂಗೆ ಲಗಾಡಿ ಲೆತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ವರಿ ಕ್ಹುದಾನಿ ನ್ಯಾಯ ಫೈಸಲಾನಾ ದಿನಮಾ ತಾರಿ ಸ್ತಿತಿ ತೊರ ವರಿ ಸಿದೊನ ಗತಿತಿಬಿ ಕಠಿಣ ಥಾವಸ ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ಕಪೆನೌರ್ಮಿ ತು ಸ್ವರ್ಗಲೊಕಮಾ ಜಾ಼ಶಿಸು! ನೈ? ತು ಪಾತಾಳಮಾ ಉತರಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ತುಮಾರಿಯೊ ವಾತೊ ಐಕಾಲಾ ಮಾರಿಯೊ ವಾತೊ ಐಕಾಲೊ ಥಾವಸ. ತುಮೊನೆ ವಪ್ಪಿಲಿವಾಲಾ ಮನೆ ವಪ್ಪಿಲಿವಸ ಮನೆ ಕುನ್ನ ನೈ ವಪ್ಪಿಲಿವಾಲೊ ಮನೆ ಮೊಕ್ಕಲಲವಾಲಾನೆ (ಕ್ಹುದಾನೆ) ನೈ ವಪ್ಪಿಲೆತೊ,ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ಸತ್ತರಪರ ಬೆ ಜ಼ನಾ ಶಿಷ್ಯಾ ಗಾಮೊಪರತಾ ಫರಿನ ಆತಾಮಾ ಘನ್ನಾ ಖುಶಿ ಕ್ಹು ವ್ಹತ್ತಾ ತ್ಯುನೆ ಯೆಸುನೆ \"ಪ್ರಭು ಹಮೆ ತಾರು ನಾಮ ಕತಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾಬಿ ಹಮೊನೆ ವಿಧೆಯೆ ಥಯ್ಯೊ, ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ಯೆಸು ತ್ಯುನೊನೆ ಸೈತಾನ ಬಿಜ್ಲಿನಾ ರುಪಮಾ ಸ್ವರ್ಗಮಾತೊ ಹೆಟೊ ಪಡ್ವಾನು ಮಿ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ಐಕೊ, ಕ್ಹಾಪೊ ವರಿ ಇಚ್ಚಿಯೊಪರ ಚಾ಼ಲಾನು ತುಮೊನೆ ಮಿ ಅದಿಕಾರ ದಿದ್ಯೊಸ. ವೈರಿಯೊನೆ (ಸೈತಾನ) ರ‍್ಹಯಲ ಅದಿಕಾರಿತೊಬಿ ಹೆಚ್ಕಿ ಅದಿಕಾರ ಮಿ ತುಮೊನೆ ದಿದ್ಯೊಸ ಕದ್ಯೊ. ತುಮೊನೆ ಸುಜ಼ ಕೆಡ ಕರತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ಹೊ ಕೆಟ್ಟ ಆತ್ಮಾವೊಬಿ ತುಮೊನೆ ವಿಧೆಯ ಥಾವಸ ಎ ಅದಿಕಾರ ತುಮೊನೆ ಛೆ ರ‍್ಹಯಲ ಹುತಿ ಖುಶಿ ಥಯೆ ನೈಸೊ ತುಮಾರಾ ನಾಮೊ ಸ್ವರ್ಗಮಾ ಬರ್ದಲ ಛೆ ಕವಾನಾ ಹುತಿ ಖುಶಿ ಕ್ಹು ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ಪಾಚಲ್ತೊ ಯೆಸು ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಘನ್ನೊ ಖುಶಿ ಥೈನ ಅಮ್ಮ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ ಸ್ವರಗ ಲೊಕನೊ ಭುಲೊಕನೊ ಕ್ಹುದಾ ಥಯಲ ಬಾ ಮಿ ತುನೆ ಸ್ತುತಿ ಕರುಸ ತು ಗ್ಯಾನಿಯೊನೆ ಗ್ಯಾನ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಎ ಸಂಗತಿ ಝಾಕಿನ ಮುಕ್ಕಕಲ ಹುತಿ ಮಿ ತುನೆ ಸ್ತುತಿ ಕರುಸ ವರಿ ತು ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊಲಿಂಗತ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಎ ಸಂಗತಿಯೊ. ಝಾಕಿನ ಮ್ಹೆಲ್ಯಾವಾಚಿ ಕದ್ಯೊ ಹೊ ತೆಜ಼ ತಾರಿ ಆಸ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ಮಾರೊ ಬಾ ಮನೆ ಕ್ಹಾರುಜ಼ ದಿದ್ಯೊಸ. ದಿಕ್ರೊ ಕುನ್ನ ವ್ಹೈ ಕಿನೆಜ಼಼ ಗೊತ್ತ ನತ್ತಿ. ಬಾ ನೆ ಯಕಜ಼ ಗೊತ್ತ ಛೆ. ವರಿ ಬಾ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ದಿಕ್ರಾನೆ ಯಕಜ಼ ಗೊತ ಛೆ. ದಿಕ್ರೊ ಬಾನಾ ಹುತಿ ಕಿನೆ ತಿಳ್ಸಸ ತೆ ಯಕ್ಕಲೊಜ಼ ಬಾನಾ ಹುತಿ ತಿಳದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ಪಾಚಲ್ತೊ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಫರಿನ ದೆಕ್ಯೊ. ತ್ಯಾ ತಿನಾ ಶಿಷ್ಯಾ ಯಕ್ಕ ಜ಼ ವ್ಹತ್ತಾ ಯೆಸು ತ್ಯುನೊನೆ ಹಮ್ನಾ ಥಾವಾನು ಸಂಗತಿಯೊ ದೆಕಲ ತುಮೆ ಧನೈ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ತಿನಾ ಹುತಿ ಮಿ ತುಮೊನೆ ಕೌಸ ಘನ್ನಾ ಪ್ರವಾದಿಯೊ ರಾಜಾ಼ ಹಮ್ನಾ ತುಮೆ ದೆಕಾನು ಎ ಸಂಗತಿಯೊ ದೆಕು ಕೈನ ವರಿ ತುಮೆ ಐಕಾನು ಸಂಗತಿಯೊ ಐಕೊ ಕೈನ ಆಸ ರ‍್ಹೈತಬಿ ತೆ ತ್ಯುನೊನೆ ಸಾದ್ಯ ಥೈಯು ನೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ತೆಳಾಮಾ ಶಾಸ್ತ್ರಿಯೊಮಾನೊ ಯಕ್ಲೊ ಯೆಸುನೆ ಪರಿಕ್ಷಾ ಲಿವೊ ಕೈನ ಉಟಿನ ಹುಬ್ರೈನ ಗುರು ಮಿ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಲಿವು ಕದ್ಯಾಮ ಮಿ ಸು ಕರು ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ತೆ ವಾತೆ ಯೆಸು ಧರಮ ಶಾಸ್ತ್ರಮಾ ಸು ಬರ್ದಲ ಛೆ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ತೆ ವಾತೆ ತೆ ತಾರೊ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾನೆ ಪುರಾ ರ‍್ಹುದಯಾ ಕ್ಹು ಪುರಾ ಜ಼ಲಮಕ್ಹು ಪುರಾ ತಾಕತಕ್ಹು ಪುರಾ ಮನಸೆ ಮಯಾ ಕರು ವರಿ ತಾರಾಕ್ಹು ತು ಕೆಕ್ಲೊ ಮಯಾ ಕರಶಿ ತಾರಾ ಬಾಜು಼ವಾಲಾನೆ ತೆಕ್ಕಲೊ ಮಯಾ ಕರುಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ಯೆಸು ತಿನಿ ತು ಕದಲ ಕರೆಟ್ಟ ಛೆ ತು ತಿಮ್ಮಜ಼ ಕರ ತೆಳಾಮಾ ತುನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಮಳಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ತೆನೈಸೊ ತೆ ಮನಕ್ಹ ತೆ ಖರಿನೊ ವ್ಹೈ ಕವೈ ಲಿವಾ ಹುತಿ, ಯೆಸುನೆ\"ಮಿ ಮಯಾ ಕರಾನು ಮಾರೊ ಬಾಜು಼ವಾಲೊ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ತಿನೆ ಪುಚ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ\" ಯಕ್ಕ ಮನಕ್ಹ ಯೆರುಸೆಲಿಮಾ ಉತ್ರಿನ ಯೆರಿಕೊವೆ ಜಾ಼ವಾನಿ ವಾಟ್ಮಾ ಜಾ಼ತಾಮಾ. ದಕ್ಹಾ ಚ್ವಟ್ಟಾತಿನೆ ಗೊಲ ಘಾಲ್ಯಾ. ತ್ಯುನೆ ತಿನಾ ಘಾಲ್ಲಿದಲ ವಣ್ಣಾ ಫಾಡಿನ ತಿಕನ ರ‍್ಹಯಲ ತೆಕ್ಲು ಕಾಳ್ಳಿನ ತಿನೆ ಮಾರ‍್ಯಾ. ತಿನೆ ಉಟಾನೆ ಥಾಯೆ ನೈಸೊ ಜಿಮಿನ್ಪರ ಪಡಿಗಯೊತೊ. ಚ್ವಟ್ಟಾ ತಿನೆ ತ್ಯಾಜ಼ ಛೊಡಿನ ಗಯಾ. ತೆ ಮರವಾನಿ ಸ್ತಿತಿಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ತೆಜ಼ ವಾಟ್ಮಾ ಯಕ್ಲೊ ಯಾಜಕ ಚಾ಼ಲ್ಯೊತೊ ಜಾ಼ತಾಮಾ ತೆ ಪಡಲವಾಲಾನೆ ದೆಕಿನಬಿ ದೆಕೆನೈಸೊ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ತಿನಾ ಲಿಂಗತಜ಼ ಯಕ್ಲೊ ಭು ಭಾಡೊ ಲಿವಾಲೊ ತೆ ಪಡಲ ವಾಲಾನೆ ದೆಕಿನಬಿ ನೈ ದೆಕಲ ಲಿಂಗತ ತ್ಯಾಂತೊ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ತೆಳಾಮಾ ಯಕ್ಲೊ ಸಮಾರಯಾವಾಲೊ ತೆಜ಼ ವಾಟ್ಮಾ ಆತಾಮಾ ತೆ ಮನಕ್ಹ ಮಾರ ಖೈನ ಪಡಲ ಜ಼ಗಾ ಐನ ತೆ ಮಾರ ಖೈನ ಪಡಲ ಮನಕ್ಹನೆ ದೆಕಿನ ಘನ್ನೊ ಮರಗ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ಸಮಾರಯಾವಾಲೊ ಬೆ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ತೆ ಸಮರಯಾವಾಲೊ ತೆ ಮನಕ್ಹನಾ ದುಕ್ಕಕೊಪರ ಒಲಿವ ತೆಲ ವರಿ ದ್ರಾಕ್ಷಿಯೊನೊ ರಕ್ಹ ಲಗಾಡಿನ ತೆ ದುಕ್ಕಕೊಪರ ಫಡಕಾ ಕ್ಹು ಭಾಂದಿನ. ಸಮಾರಯಾವಾಲೊ ಯಕ್ಕ ಗದಡಾಪರ ಆಯೊತೊ ತೆಜ಼ ಗದಡಾಪರ ತೆ ಮಾರ ಖಾದಲ ಮನಕ್ಹನೆ ಘಾಲ್ಲಿನ ದವಾಕ್ಹಾನಿಯೆ ನಿಂಗೈನ, ಅರಾಕಿ ಕರ‍್ಯೊ. ಮರ್ನಾ ದಿನ್ನೆ ತೆ ವಾಕ್ಹಾನಿ ವಾಲಾನೆ ದಿನ ಇನೆ ಅರಾಕಿ ಕರ ಕೈನ; ವರಿ ಹೆಚ್ಕಿ ಖರಚ಼ ಥಯಾತಬಿ ಮಿ ಬಿಜೆ಼ಕ್ಕೆಬ ಆತಾಮಾ ವರಿ ತುನೆ ದಿವ್ಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ಮರ್ನಾ ದಿನೆ,ಸಮರಯಾವಾಲೊ ಬೆ ರುಪ್ಪಾನಾ ");
INSERT INTO sle_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ತೆಳಾಮಾ ಯೆಸು ಶಾಸ್ತ್ರಿನೆ \"ಎ ತನ ಜ಼ನಾವೊಮಾ (ಯಾಜಕ, ಭು ಭಾಡೊವಾಲೊ, ವರಿ ಸಮಾರಯಾ ವಾಲೊ) ಕುನ್ನ ಚ್ವಟ್ಟಾವೊನಾ ಹತೆ ಮಾರ ಖೈನ ಪಡಲವಾಲಾನೆ ಮನಕ್ಹನೆ ಕುನ್ನ ಮಯಾ ಕರ‍್ಯು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ತೆಳಾಮಾ ಶಾಸ್ತ್ರಿ, ತೆ ಮಾರ ಖೈನ ಪಡಲವಾಲಾನೆ ಆಸ್ರೊ ಕರಲವಾಲೊ ವ್ಹೈ ಕದ್ಯೊ. ತೆಳಾಮಾ ಯೆಸು ತಿನೆ ತಿಮ್ಮ ರ‍್ಹಯುಮ, ತು ಗೈನ ತಾರಾ ಬಾಜು಼ವಾಲಾನೆ ತಿಮ್ಮಜ಼ ಮಯಾ ಕರ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಫರತಾ-ಫರತಾ ಯಕ್ಕ ಗಾಮೆ ಆಯಾ, ಮಾರಥಳ ಕವಾಲಿ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ಯೆಸುನೆ ತಿನಾ ಘರೆ ಆ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ತಿನೆ ಯಕ್ಕಲಿ ಮರಿಯಳ ಕವಾಲಿ ನ್ಹಾನಿ ಭೆನ ವ್ಹತ್ತಿ. ಯೆಸು ತ್ಯುನಾ ಘರೆ ಆತಾಮಾ ಮರಿಯಳ ಯೆಸುನಾ ಪಗೊಕನ ಬೈಟಿನ ತಿನು ಉಪದೆಶ ಐಕಾಡಿತಿ. ");
INSERT INTO sle_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ಘರಮಾ ಘನ್ನು ಕಾಮ ರ‍್ಹಯಲ ಹುತಿ ಮಾರಥಳ ಘನ್ನಿ ಶಿಟ್ಟ ಥೈನ ಯೆಸುಕನ ಐನ, ಪ್ರಭು, ಮಾರಿ ಭೆನ ಘರನು ಪುರಾ ಕಾಮ ಮಪರ ಯಕ್ಕಲಿಪರಜ಼ ಛೊಡಿನ ತುಕನ ಐನ ಬೈಟಿಸ. ಇನಾಹುತಿ ತುನೆ ಚಿಂತಾ ನತ್ತಿಸು? ಮಾರಾ ಕ್ಹಾತೆ ಕಾಮ ಕರ ಕೈನ ತಿನೆ ಕೆ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ತೆನೈಸೊ ಯೆಸು ಮಾರಥಳನೆ \"ಮಾರಥಳ, ಮಾರಥಳ, ತು ಘನ್ನಿಯೊ ಚಿಂತಾಮಾ ವರಿ ಗಲಿಬಿಲಿಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ಯಕ್ಕಜ಼ ಯಕ್ಕ ಚೊ಼ಕು ರ‍್ಹಯಲ ಮರಿಯಳ ಇನಿಲಿದಿಸ. ತೆ ತಿಮಾತು ಕೆಳಾಮಾಜ಼ ಕಾಡಾನೆ ಥಾತು ನೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ಯಕ್ಕದಿನ ಯೆಸು ಯಕ್ಕ ಜ಼ಗಾಪರ ಪ್ರಾಥನಾ ಕರಾಡೊತೊ ಪ್ರಾಥನಾ ಕರಿನ ಮುಗಸ್ತಾಮಾ, ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ಯೆಸುನೆ\"ಸ್ವಾಮಿ ಯೊಹಾನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಪ್ರಾಥನಾ ಕರಾನು ಶಿಕ್ಲಾಯಲ ಲಿಂಗತ, ಹಮೊನೆಬಿ ಪ್ರಾಥನಾ ಕರಾನು ಶಿಕ್ಲಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ತೆ ವಾತೆ ಯೆಸು ತಿನೆ ತುಮೆ ಅಮ್ಮ ಪ್ರಾಥನಾ ಕರೊ ಬಾ, ತಾರು ನಾಮ ಕೆಳಾಮಾಬಿ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾದೆ. ತಾರೊ ರಾಜ್ಯ ಆವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ಹಮಾರು ದಿನ್ನೆನು ಅನ್ನ ದಿನ್ನೆಬಿ ದೆ ");
INSERT INTO sle_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ಹಮೊನೆ ತಪ್ಪ ಕರಲವಾಲಾನೆ ಹಮೆ ಮಾಫ ಕರಲ ಲಿಂಗತ ಹಮಾರು ಪಾಪೊ ಮಾಫ ಕರ ಹಮೊನೆ ಶೊದನೆಮಾ ಪಾಡುನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ ತುಮೊಮಾನೊ ಯಕ್ಲಾನೆ ದೊಸ್ತ ಛೆ ಕೈನ ತಿಳದಿಲಿಯೆ. ಯಕ್ಕ ದಿನ್ನ ರಾತೆ ತಿನಾ ದೊಸ್ತನಾ ಘರೆ ಗೈನ ತಿನೆ ಮಾರು ದೊಸ್ತ ಮನೆ ಮಳಾನಾ ಹುತಿ ತೆ ಘನ್ನಾ ದುರತೊ ಮಾರಾ ಘರೆ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ತೆನೈಸೊ ಮಾರಾ ದೊಸ್ತನೆ ಖಾವಾನೆ ಅನ್ನ ಮಕನ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ತೆ ಘರಮಾ ರ‍್ಹಯಲ ದೊಸ್ತ ಅನ್ನ ಪುಚ್ಚಾ಼ಲಾನೆ \"ತು ಗೈಪಡ! ಮನೆ ತ್ರಾಸ ದ್ಯು ನಕೊ! ಬಾಕಲ ಘಾಲ್ಲಿ ಪಾಡ್ಯೊಸ! ಮಿಬಿ ವರಿ ಮಾರಿ ದಿಕ್ರಿ ಕ್ಹುರೈ ಪಡ್ಯಾಸ, ಮಿ ಉಟಿನ ರೊಕ್ಲಾ ನೈ ದೆತೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ಕ್ಹಾಲಿ ತ್ಯುನಿ ದೊಸ್ತಿ ಯಕಜ಼ ತಿನೆ ಉಟಿನ ರೊಕ್ಲಾ ದಿವಾನು ವೃಕ್ಹು ಕರತು ನೈ ಕೈನ ತುಮೊನೆ ಕೌಸ. ತೆ ಹಗ್ಲೆಲ್ಲಾ ಪುಚ್ತೊ಼ ರ‍್ಹಯ್ಯೊಮ, ತೆ ಉಟಿನ ಚಾ಼ಯೆ ಥಯಲ ರೊಕ್ಲಾ ಕ್ಹರಿಮಾಜ಼ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ತಿನಾಹುತಿ ಮಿ ತುಮೊನೆ ಕೌಸ, ಮಾಂಗಿಲಿವೊ ತುಮೊನೆ ಮಳಸ. ಹುಡ್ಕೊ ತೆಳಾಮಾ ತುಮೊನೆ ಕ್ಹಾಪ್ಡಸ. ವಜಾ಼ಡೊ ತೆಳಾಮಾ ತುಮಾರಾ ಹುತಿ ಬಾಕಲ ಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ಹೊ ಛೊಡ್ಯಾವಾಚಿ ಮಾಂಗಾಲಾನೆ ಮಳಸ, ಹುಡ್ಕಾಲಾನೆ ಕ್ಹಾಪ್ಡಸ, ವಜಾ಼ಡಾಲಾನೆ, ತಿನಾ ಹುತಿ ಬಾಕಲ ಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ತುಮೊಮಾ ಕೆಕ್ಕಲಾ ಜ಼ನಾ ಬಾ ಥಯಾಸ? ತಮಾರಾ ಬಚ್ಚಾ಼ ಮಚ್ಲಿ಼ ಮಾಂಗ್ಯಾಮ, ತುಮೆ ತಿನೆ ಕ್ಹಾಪ ದಿವೊಸಿಸು ನೈ! ");
INSERT INTO sle_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ತುಮಾರಾ ಬಚ್ಚಾ಼ ಇಂಡು ಮಾಂಗ್ಯಾಮ ಇಚ್ಚಿ ದಿವೊಸಿಸು? ನೈ! ");
INSERT INTO sle_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ತುಮೆ ಬಿಜಾ಼ವೊಲಿಂಗತ ಕೆಟ್ಟ ರ‍್ಹಯಾತಬಿ ತುಮಾರಾ ಬಚ್ಚಾ಼ವೊನೆ ಚೊ಼ಕೊಜ಼ ದಿವೊಸಿ, ತಿನಾಲಿಂಗತಜ಼ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರೊ ಬಾ ಬಿ ತುಮೆ ಮಾಂಗಿಲಿವಾನೆ ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹರಿಮಾಜ಼ ದಿವಸ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ಯಕ್ಕ ಸಲಾ ಯೆಸು ಮುಕಿ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲವಾಲಾನೆ ಛೊಡಾವಾಡ್ಯೊತೊ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತೆ ಮನಕ್ಹಾನಾ ಅಂಗಮಾತೊ ಭಾರು ಆತಾಮಾ ತೆ ಮನಕ್ಹ ಬೊಲ್ಯೊ. ಎ ದೆಕಲ ಮನಕ್ಹೊ ಘಾಬ್ರಾಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ತಿಮಾನಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ಎ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೊ ಅದಿಕಾರಿ ಥಯಲವಾಲೊ ಬೆಲ್ಜೆಬೊಲನಿ ತಾಕತ ಕ್ಹೊ ಛೊಡಾವಾಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ಬಿಜಾ಼ ದಕ್ಹಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಪರಿಕ್ಷಾ ಲಿವಾನಾ ಹುತಿ ತು ಕ್ಹುದಾಕಂತೊ ಮಾಂಗಿಲಿನ ಯಕ್ಕ ಸುಚಕ ಕಾರಯೊ ಕರಿನ ದೆಕಾಡ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನಿಯೊ ವಿಚಾರ ತಿಳ್ದಿನ ತ್ಯುನೊನೆ \"ಫುಟಿ ಗಯಲ ವರಿ ತಿನಾ ವಿರುದ್ದ ತೆಜ಼ ಲಡಾಯಿ ಕರಾನು ರಾಜ್ಯ ಹಾಳ ಥೈ ಜಾ಼ವಸ, ಯಕ್ಕ ಕುಟುಂಬಮಾ ಭೆದ ಭಾವ ರ‍್ಹಯುಮ ತೆ ಕುಟುಂಬ ಉಗರತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","\"ತಿನಾಲಿಂಗತಜ಼ ಸೈತಾನ ತಿನಾ ವಿರುದ್ದ ತೆಜ಼ ಲಡಾಯಿ ಕರಲಿದ್ಯುಮ, ತಿನು ಯಕ್ಕ ಅದಿಕಾರ ಕಿಮ ಉಗ್ರಸ? ಬೆಲ್ಜೆಬೊಲನಾ ತಾಕತ ಕ್ಹು ಮಿ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೊಡಾವಸ ಕೈನ ತುಮೆ ಕವಾಡ್ಯಾಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ಮಿ ಬೆಲ್ಜೆಬೊಲನಿ ತಾಕತಕ್ಹು ಕೆಟ್ಟ ಆತ್ಮಾವೊ ಛೊಡಾವಾನು ರ‍್ಹಯುಮ ತಮಾರಾ ಮನಕ್ಹೊ ಕೆಟ್ಟ ಆತ್ಮಾ ಕೈ ತಾಕತಕ್ಹು ಛೊ಼ಡಾವಸ? ತಮಾರಾ ಸ್ವಂತ ಮನಕ್ಹೊ ತುಮೊನೆ ತಪ್ಪ ಕರಾಲಾ ವ್ಹೈಕೈನ ಕವಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ತೆನೈಸೊ ಮಿ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಕ್ಹುದಾನಿ ತಾಕತ ಕ್ಹು ಛೊಡಾವಾಡ್ಯುಸ್ತೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ತುಮಾರಾ ಕ್ಹಾಮಿ ಐಸ ಕೈನ ಎಜ಼ ಸಾಕ್ಷಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ಯಕ್ಲೊ ತಾಕತವಾಲೊ ಲಡಾಯಿನು ಕ್ಹಾರು ಸಾಮನ ಅಂಗಪರ ಘಾಲ್ಲಿನ ತಿನು ಘರ ಕೈದತೊ ರ‍್ಹತಾಮಾ ತಿನು ಘರಮಾನು ಸಾಮನ ವಾಗಾತಿ ರ‍್ಹವಸ, ");
INSERT INTO sle_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ತೆನೈಸೊ ತಿತ್ತಿಬಿ ತಾಕತವಾಲೊ ಐನ ತಿನೆ ಸೊಲ್ಸಿನ್ ಪಾಚಲ್ತೊ ತೆ ಪೈಲಾನೊ ಮನಕ್ಹ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಲಿದಲ ತೆ ಲಡಾಯಿನು ಸಾಮನ ಕಾಳ್ಳಿನ ತೆ ಚೊ಼ರಿಕರಲ ಕ್ಹಾರು ವಾಟಿನ ದಿವಸ, ");
INSERT INTO sle_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ಮಾರಾ ಕ್ಹಾತೆ ನೈ ರ‍್ಹಯಲವಾಲೊ ಮನೆ ವಿರುದ್ದ ವ್ಹೈ. ಮಾರಾ ಕ್ಹಾತೆ ನೈ ಮಳಲವಾಲೊ ಜು಼ದಾ ಕರಾವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","\"ಕೆಟ್ಟ ಆತ್ಮಾ ಯಕ್ಕ ಮನಕ್ಹಮಾತಿ ಭಾರಿ ಆಯಲ್ಪರ ಅರಾಮ ಕರಾನೆ ಜ಼ಗಾ ಹುಡ್ಕತಿ ಪಾನಿ ನೈಸೊ ಜ಼ಗಾ ಫರಸ, ತೆನೈಸೊ ತಿನೆ ಅರಾಮ ಕರಾನೆ ಜ಼ಗಾ ನೈ ಮಳ್ತಾಮಾ ತೆ ಫರಿನ ಮಿ ರ‍್ಹಯಲ ಪೈಲಾನಾ ಮನಕ್ಹನಾ ಅಂಗಮಾ ವರಿ ಜೌ಼ಸ ಕೈನ ಕೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ತೆ ಮನಕ್ಹಕನ ಫರಿನ ಆತಾಮಾ ತೆ ಘರ (ಮನಕ್ಹ) ವಾಗಾತಿ ಥಯಲ ದೆಕಿನ. ");
INSERT INTO sle_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಗೈನ ತಿತ್ತಿಬಿ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಬಿಜಿ಼ಯೊ ಕ್ಹಾತ ಕೆಟ್ಟ ಆತ್ಮಾವೊನೆ ಬಲೈಲಿನ ಆವಸ. ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತೆ ಮನಕ್ಹನಾ ಅಂಗಮಾ ಹೊಕ್ಕಕಿನ ತ್ಯಾಜ಼ ರ‍್ಹವಸ. ತೆಳಾಮಾ ತೆ ಮನಕ್ಹನೆ ಪೈಲಾತಿಬಿ ಹೆಚ್ಕಿ ತ್ರಾಸ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ಯೆಸು ಎ ವಾತೊ ಕತೊ ರ‍್ಹತಾಮಾ ಯಕ್ಕ ಬಾಕ್ಡಿ ಯೆಸುನೆ ತುನೆ ಜ಼ನ್ನಿನ ರಾಕಲವಾಲಿ ಧನೈ ವ್ಹೈ. ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ಯೆಸು ತಿನೆ, ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿನ ತಿನೆ ಕರೆಟ್ಟ ಚಾ಼ಲಾಲಾ ಧನೈ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ಮನಕ್ಹೊ ಗುಂಪ ಥೈನ ಆತಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಸು ಕವಾನು ಚಾಲು ಕರ‍್ಯೊ ಕದ್ಯಾಮ ಎ ಕೆಟ್ಟ ಸಂತತಿಜ಼ ವ್ಹೈ. ಸುಚಕ ಕಾರಯೊ ದೆಕುಸ ಕವಾಡ್ಯೊಸ. ತೆನೈಸೊ ಯೊನನಿ ಜಿವಿತ್ಮಾ ದೆಕಾನೆ ಮಳಲ ಸುಚಕ ಕಾರ‍್ಯೊ ಬಿಜಾ಼ವೊನೆ ಕಿನೆಜ಼಼ ದೆಕಾನೆ ಮಳತು ನೈ, ");
INSERT INTO sle_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ನಿನೆವಿಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಯೊನ ಯಕ್ಕ ಸುಚನೆ ರ‍್ಹಯಲ ಲಿಂಗತ ಹೊತೊ. ತಿನಾ ಲಿಂಗತಜ಼ ಎ ಕಾಲ್ನಾ ಮನಕ್ಹೊನೆ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ವಳಕ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ನ್ಯಾಯ ತಿರಪನಾ ದಿನಮಾ ದಕ್ಕಷಿಣ ದೆಶನಿ ರಾಣಿ ಎ ಖಾಂದಾನ್ನಾ ಕ್ಹಾತೆ ಉಟಿನ ಹುಬ್ರೈನ ಇವ್ನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಕವಸ. ಕಾಕದ್ಯಾಮ ಘನ್ನಿ ದುರತಿ ಐನ ಸೊಲೊಮೊನನಿಯೊ ಗ್ಯಾನಿಯೊ ವಾತೊ ಐಕಿನ ವರಿ ತಿಳದಿಲಿವಾನೆ ಐ. ವರಿಬಿ ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯೊ ಕದ್ಯಾಮ ಮಿ ಸೊಲೊಮೊನತಿ ಬಿ ಘನ್ನಿ ಗ್ಯಾನವಾಲೊ (ಯೆಸು) ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ನ್ಯಾಯ ತಿರಪನಾ ದಿನಮಾ ನಿನೆವೆ ಗಾಮವಾಲಾ ಎ ಸಂತ್ತತಿವಾಲಾವೊನ ಕ್ಹಾತೆ ತ್ಯುನೊನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಕವಾಲೊ ಯೊನ ಕದಲ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಐಕಿನ ತೆ ಗಾಮನಾ ಮನಕ್ಹೊ ತ್ಯುನಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ. ಕ್ಹುದಾ ಬಗಲ ಫರಯಾ. ತೆನೈಸೊ ಮಿ ಪ್ರವಾದಿ ಥಯಲ ಯೊನ ತಿಬಿ (ಯೆಸು) ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ಕುನ್ನಬಿ ದಿವ್ವೊ ಲಗಾಡಿ ಸಾಮನ್ಮಾ ನೈತೊ ಬಿಜಿ ಜ಼ಗಾಮಾ ಝಾಕಿನ ಮ್ಹೆಲ್ತಾ ನೈ ಮ್ಹೈ ಆವಾಲಾವೊನೆ ಉಜಾಲು ಪಡಾ ಹುತಿ ದಿವ್ವೊ ಲೈನ ಗೊಡಿಪರ ಮ್ಹೆಲಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ತಾರಾ ಡೊಳಾ ತಾರಾ ಅಂಗನೆ ಉಜಾಲು ಥಯಾಸ. ತಾರಾ ಡೊಳಾ ಸಿದಾರ‍್ಹತಾಮಾ ತಿನಾ ಲಿಂಗತ ತಾರು ಅಂಗ ಉಜಾಲಾ ಲಿಂಗತ ರ‍್ಹವಸ. ತೆ ಕೆಟ್ಟ ರ‍್ಹಯೊಮ ತಿನಾಲಿಂಗತ ಅಂಗಬಿ ಅಂದಾರಾ ಲಿಂಗತ ರ‍್ಹವಸ. ತಿನಾ ಹುತಿ ತಾರಾಮಾ ರ‍್ಹಯಲ ಉಜಾಲು ಅಂದಾರು ಥೈಯುಸು ದೆಕ. ");
INSERT INTO sle_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ತಾರು ಅಂಗ ಪುರಾ ಉಜಾಲು ರ‍್ಹಯುಮ ಯಕ್ಕ ಬಗಲಬಿ ಅಂದಾರು ರ‍್ಹಯುಮ ದಿವ್ವಾನು ಉಜಾಲು ಪಡಿನ ತುನೆ ಉಜಾಲು ದಿವಾನಾ ಕಾಲಮಾ ಕಿಮ ತಿಮ್ಮಜ಼ ತೆ ಪುರಾ ಉಜಾಲು ಥೈನ ರ‍್ಹವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ತಾರು ಪುರಾ ಅಂಗ ಉಜಾಲು ರ‍್ಹೈಮ ತಾರಾ ಅಂಗನಾ ಕಯಾಜ಼ ಭಾಗನೆ ಅಂದಾರು ರ‍್ಹತು ನೈ. ಇನಾಹುತಿ ಕ್ಹಾರು ಉಜಾಲು ಥೈನಜ಼ ರ‍್ಹವಸ ಕಿನಾ ಲಿಂಗತ ಕದ್ಯಾಮ ದಿವ್ವೊ ಉಜಾಲು ದಿನ್ನ ಕ್ಹಾರಿ ಬಗಲ ಉಜಾಲು ಥೈನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ತೆ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾ ಯಕ್ಲೊ ಫರಿಸಾಯರವಾಲೊ ಯೆಸುನೆ ಖಾವಾನೆ ಆ ಕೈನ ಮಾಂಗಿಲೆತಾಮಾ ತೆ ಮ್ಹೈ ಗೈನ ಖಾವಾನಾ ಹುತಿ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ಯೆಸು ತಿನಾ ಹತೊ ಧ್ವಲಿದ್ಯಾವಾಚಿ ಖಾವಾನೆ ಬೈಟಲ ದೆಕಿನ ತೆ ಫರಿಸಾಯರ ವಾಲೊ ಘಾಬ್ರೊಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ಯೆಸು ಫರಿಸಾಯರನೆ ತುಮೆ ತಾಂಬಿಯಾ ವರಿ ವಾಟ್ಕಾ ಭಾರಾತು ಯಕ್ಕಜ಼ ಧವೊಸಿ. ತೆನೈಸೊ ತುಮಾರು ಮ್ಹೈನು ಮೊಸಕ್ಹು ಕೆಟ್ಟ ಕ್ಹು ಭರಿ ಗಯುಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ತುಮೆ ಗ್ಯಾನ ನೈಸೊ ವಾಲಾ ವ್ಹೈ! ಮನಕ್ಹನೆ ಭಾರಾತೊಬಿ ಮ್ಹೈತೊಬಿ ಕರಲವಾಲೊ ಕ್ಹುದಾಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ತಿನಾ ಹುತಿ ಸಾಮನ್ಮಾ ರ‍್ಹಯಲ ಖಾವಾನು ಅನ್ನ ಗರಿಬೊನೆ ದಿವೊ ತೆಳಾಮಾ ತುಮೆ ಪುರಾ ಶುದ್ಧ ಥಾವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ಫರಿಸಾಯರೊ, ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ತುಮೆ ಕ್ಹುದಾನೆ ತುಮೊಕನ ರ‍್ಹಯಲ ಹರಿ ಯಕಮಾ ಲಾಸ್ಟುನೊ ವಾಟೊ ದಿವೊಸಿ. ತುಮಾರಾ ಖೆತರಮಾ ಬೆಳ್ದಾನು ಮರುಗ, ಸದಾಪು ಹಜು಼ನ ಘನ್ನಿಯೊ ತರಕಾರಿಯೊ ಮಾ ಲಾಸ್ಟನೊ ವಾಟೊ ದಿವೊಸಿ. ವರಿ ಬಿಜಾ಼ವೊನೆ ನ್ಯಾಯ ತಿರಸಾನು ಕ್ಹುದಾನೆ ಮಯಾಕರಾನು ಇಕ್ಹರಿಪಾಡ್ಯಾಸ. ತುಮೆ ಪೈಲಾ ಕ್ಹುದಾನೆ ದಿವಾನು ಪೈಲಾ ದಿವೊ ವರಿ ಕ್ಹಾರಾವೊನೆ ಮಯಾಕರಾನು ಪೈಲಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ಫರಿಸಾಯರೊ ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ,ಸಭಾಮಂದಿರಮಾ ಖಾಸ ಜ಼ಗಾವೊಪರ ವಾನಿಯಾನಿ ವರಿ ವಾಟ್ಪರ ಮನಕ್ಹೊ ತುಮೊನೆ ಪಗೆ ಪಡಾನು ತುಮೊನೆ ಘನ್ನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ತುಮೆ ಬುಜ್ಜೈ಼ಗಯಲ ಮಜಾ಼ರೊ ಲಿಂಗತ ವ್ಹೈ. ಮನಕ್ಹೊ ತುಮೆ ಮಜಾ಼ರೊ ನ್ಹವೈ ಕೈನ ತಿಳ್ದಿನ ತುಮೊಪರ ಚಾ಼ಲಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ಎ ಕ್ಹಾರು ಕದಲ ಐಕಿನ ಧರಮ ಉಪದೆಶ ಕವಾಲೊ ಯಕ್ಲೊ ಯೆಸುನೆ ಭೊದಕ ತು ಎವಾತೊ ಕವಾಕ್ಹು ಹಮಾರಾ ಮನಕ್ಹೊನೆ ಬೆಜ್ಜಾರ ಕರಲ ಲಿಂಗತ ಥಯುಸ ಕತಾಮಾ ಯೆಸು. ");
INSERT INTO sle_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ಧರಮ ಉಪದೆಶ ಕರಾಲಾವೊ, ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ? ತುಮೆ ಮನಕ್ಹೊ ನೈ ಪಾಲ್ಸಾನಾ ನಿಯಮೊ ತ್ಯುನೊನೆ ಪಾಲ್ಸಾನಾ ಕವೊಸಿತೊ ವರಿ ಎ ನಿಯಮೊ ಪಾಲ್ಸುಜ಼ ಕೈನ ಮನಕ್ಹೊನೆ ವತ್ತಾಯ ಕರೊಶಿತೊ. ಮತ್ರಾ ತುಮೆ ತೆ ನಿಯಮೊ ಪಾಲಸ್ತಾ ನೈ ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ತುಮಾರಿ ಗತಿ ಸು ಕೌ! ತುಮೆ ಪ್ರವಾದಿಯೊನೆ ಮಜಾರೊ ಭಾಂದೊಶಿ. ತೆನೈಸೊ ಪ್ರವಾದಿನೆ ಮಾರೆಲ ವಾಲಾ ತುಮಾರಾ ಬಾಪೊಜ಼ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ಅನಾ ಹುತಿ ತುಮಾರಾ ಬಾಪೊ ಕರಲ ಕಾಮೊ ತುಮೆ ವಪ್ಪಿಲಿದ್ಯಾಸ ಮನಕ್ಹೊನೆ ದೆಕಾಡೊಸಿ. ತ್ಯುನೆ ಪ್ರವಾದಿಯೊನೆ ಖಲಾಸ ಕರಿಪಾಡ್ಯಾ. ತುಮೆ ತೆಜ಼ ಪ್ರವಾದಿಯೊನಿಯೊ ಮಜಾ಼ರೊ ಭಾಂದೊಸಿ! ");
INSERT INTO sle_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ತಿನಾ ಹುತಿ ಕ್ಹುದಾನು ಗ್ಯಾನ ಸು ಕವಸ ಕದ್ಯಾಮ,ಮಿ ಮಾರಾ ಪ್ರವಾದಿಯೊನೆ ವರಿ ಅಪೊಸ್ತಲೊನೆ ಮೊಕ್ಕಲುಸ. ಮಾರಾ ದಕ್ಹಾ ಪ್ರವಾದಿಯೊನೆ ವರಿ ಅಪೊಸ್ತಲೊನೆ ಕೆಟ್ಟ ಮನಕ್ಹೊನಾ ಹತ್ಮಾ ಮರಿ ಜಾ಼ವಸ ವರಿ ದಕ್ಹಾಜ಼಼ನಾ ಕಷ್ಟಮಾ ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ತಿನಾಹುತಿ ದುನಿಯಾ ಶುರುತಿಬಿ ಮರಲ ಕ್ಹಾರಾ ಪ್ರವಾದಿಯೊನೆ ಕಾರಣ ಥಯಲ ಎ ಕಾಲನಾ ಮನಕ್ಹೊ ತುಮೆ ಶಿಕ್ಷಾನೆ ಗುರಿ ಥಾವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ಹೆಬಲನೆ ಮಾರಲ ಹುತಿ ಜಕರಿಯಾನೆ ಮಾರಲಹುತಿ ತುಮೊನೆ ಶಿಕ್ಷಾ ಮಳಸ. ಜಕರಿಯಾನೆ, ಬಲಿದಿವಾನಿ ಜ಼ಗಾ ವರಿ ದೆವಾಲಯನಾ ವಚ್ಮಾ಼ ಖಲಾಸ ಕರಾಯಾ. ಹೊ ಇವ್ನೊನೆ ಮಾರಲ ಹುತಿ ತುಮೊನೆ ಶಿಕ್ಷಾ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ಧರಮ ಉಪದೆಶ ಕರಾಲಾ ತುಮಾರಿ ಗತಿ ಮಿ ಸು ಕೌ! ಕ್ಹುದಾನಾ ಹುತಿ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ ವರಿಬಿ ತುಮೆ ತುಮಾರು ತುಮೆಜ಼ ಕರೊಶಿ. ಮನಕ್ಹೊಕನ ಕ್ಹುದಾನಾ ಹುತಿ ಕತಾಬಿ ನೈ ಶಿಕ್ಕಲಾತಾಬಿ ನೈ \"ಕೈನ ಯೆಸು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ಯೆಸು ತ್ಯಾಂತೊ ಜಾ಼ತಾಮಾ ಧರಮ ಕರೊ ಕವಾಲಾ ವರಿ ಫರಿಸಾಯರೊ ಯೆಸುನೆ ವರಿ ದಕ್ಹಾ ತ್ರಾಸ ಕರಾನು ಚಾಲು ಕರ‍್ಯಾ. ತ್ಯುನೆ ಯೆಸುನೆ ಘನಿಯೊ ವಾತೊಮಾ ಪ್ರಶ್ನೆ ಪುಚಾ಼ನು ಚಾಲು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ಯೆಸುನೆ ವಾತೊಮಾ ಧರಿಯೆ ಕೈನ ವಿಚಾರ ಕರಲೆತಾ, ಯೆಸು ಸುಬಿ ತಪ್ಪ ಕಸ ಕೈನ ಬಿಜು಼-ಬಿಜು಼ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ತೆಕ್ಲಾಮಾಜ಼಼ ಹಜಾ಼ರೊಸಿ ಮನಕ್ಹೊ ಯಕ್ಲಾನಾ ಯಕ್ಲೊ ಖುಂದಾ ಯಕ್ಲಾ ಕುಡಿನ ಆಯಲ ಹುತಿ ತೆ ಪೈಲಾ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ, ಫರಿಸಾಯರೊನಾ ಖಾಟಾ ಲೊಟ್ನಿ ವಿಷಯಮಾ ಕದ್ಯಾಮ ತಿವ್ನಿ ಕಪಟತನಾ ಹುತಿ ಹುಶಾರಕ್ಹು ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ಝಕಾಯಲ ಕಯುಜ಼ ಗ್ವತ್ತ ಥಾವಸ, ದಡೈನ ಮ್ಹೆಲಲ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮು ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ಇಮ್ಮ ರ‍್ಹಯಲ ಹುತಿ ತುಮೆ ಅಂದಾರಾಮಾ ಕದಲ ಉಜಾಲಾಮಾ ಐಕು ಆವಸ. ವರಿ ತುಮೆ ಖೊಲಿಮಾ ರ‍್ಹೈನ ಕಾನ್ಮಾ ಕದಲ ವಾತೊ ಮ್ಹಾಡಿನಾ ಘರಮಾ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","\"ಮಾರಾ ದೊಸ್ತೊ ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯಾಮ, ತುಮಾರಾ ಅಂಗನೆ ಖಲಾಸ ಕರಾಲಾನೆ ಭುಚ಼ಕೊ ನಕೊ ತ್ಯುನೆ ವರಿ ಬಿಜು಼ ಸುಜ಼ ಕರತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ತುಮೆ ಕಿನೆ ಭುಜ್ಕು಼ ಕದ್ಯಾಮ, ತುಮೊನೆ ಖಲಾಸ ಕರಿನ ನರಕಮಾ ಘಾಲಾನೆ ಅದಿಕಾರ ರ‍್ಹಯಲ ವಾಲೊ ಕ್ಹುದಾನೆ ಯಕ್ಕಜ಼ ಭುಚ಼ಕು. ");
INSERT INTO sle_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","\"ಪಾಂಚ಼ ಚಿಮ್ಣಿಯೊನಿ ಕಿಮ್ಮತ ಬೆ ಬಿಲ್ಲಾ? ರ‍್ಹಯುತಬಿ ಕ್ಹುದಾ ತ್ಯುನೊಮಾ ಯಕ್ಕನೆಬಿ ಇಕ್ಹರತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ತಿನಾಲಿಂಗತಜ಼ ತಮಾರಾ ಮಾತಾಮಾ ಕೆಕ್ಕಲಾ ಬಾಲೊ ಛೆ ಕ್ಹುದಾನೆ ಗ್ವತ್ತ ಛೆ. ತಿನಾಹುತಿ ತುಮೆ ಭುಚಕೊ಼ ನಕೊ. ತುಮೆ ಘನಿಯೊ ಚಿಮ್ಣಿಯೊತಿಬಿ ಘನ್ನಾ ಕಿಮ್ಮತ್ನಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","\"ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯಾಮ, ಕಯೊಬಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ತೆ ಮನಕ್ಹ ಮಾರೊ ವ್ಹೈ ಕದ್ಯಾಮ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಬಿ ತೆ ಮನಕ್ಹನೆ ದೆವದುತೊನಾ ಕ್ಹಾಮೊ ತಿನೆ ಮಾರೊ ವ್ಹೈ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ವರಿ ಕಯೊಬಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ತೆ ಮನಕ್ಹ ಮಾರೊ ನ್ಹವೈ ಕದ್ಯಾಮ, ಮನಕ್ಹನೊ ದಿಕ್ರೊ ತಿನೆ ದೆವದುತೊನಾ ಕ್ಹಾಮೊ, ತೆ ಮನಕ್ಹನೆ ಮಾರೊ ನ್ಹವೈ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","\"ಕುನ್ನಬಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ವಿರುದ್ದ ಬೊಲಲ ರ‍್ಹಯೊಮ ತಿನೆ ಮಾಫ ಮಳ್ಸ. ವರಿ ಪವಿತ್ರ ಆತ್ಮಾನೆ ದೊಶ ದಿವಾಲಾನೆ ಮಾಫ ಮಳ್ತಿಜ಼ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ಮನಕ್ಹೊ ತುಮೊನೆ ಸಬಾಮಂದಿರಮಾ ಅದಿಕಾರಿಯೊನಾ ಕ್ಹಾಮಾ ನ್ಯಾಯಾದಿಪತಿಯೊನಾ ಕ್ಹಾಮಾ ಮಂತ್ರಿಯೊನಾ ಕ್ಹಾಮಾ ತುಮೊನೆ ಯಳ್ದಿನ ನಿಂಜಾ಼ತಾಮಾ ತ್ಯುನಾ ಕ್ಹಾಮೊ ಸು ಬೊಲುಕೈನ ತುಮೆ ಚಿಂತಾನಕೊ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ತೆ ಟೈಮಾ ತುಮೆ ಬೊಲಾನು ಪವಿತ್ರ ಆತ್ಮಾ ತುಮೆ ಸು ಕೌ ಕೈನ ತಿಳ್ಸಾವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ನಜಿಕ್ಮಾ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲೊ ಯೆಸುನೆ, ಭೊದಕ ಹಮಾರೊ ಬಾ ಛೊಡಿನ ಗಯಲ ಮಾರಿ ಬಾನಿ ಆಸ್ತಿಮಾ ಮನೆ ವಾಟೊ ದೆ ಕೈನ ಮಾರಾ ಮ್ಹೊಟಾ ಭೈನೆ ಕೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ತೆನೈಸೊ ಯೆಸು \"ಮಿ ತುಮಾರಿ ನ್ಯಾಯ ಕರಾನೆ ವರಿ ತುಮಾರಾ ಬಾನಿ ಆಸ್ತಿಮಾ ತುಮೊನೆ ಭಂಬಿಜ಼ನಾವೊನೆ ವಾಟಿನೆ ದಿವಾನೆ ಮನೆ ಕುನ್ನ ಕದ್ಯುಸ? ");
INSERT INTO sle_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ತೆ ಥಯಲಪರ ಯೆಸು ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ \"ಹುಶಾರ, ಕೈಬಿ ಆಸನೆ ಸ್ವಾರಥಮಾ ಪಡೆನೈಸೊ ಜಾ಼ಗಾ ರ‍್ಹವೊ. ಕಾಕದ್ಯಾಮ ಯಕ್ಲಾನೆ ಕೆಕ್ಕಲಿಬಿ ಆಸ್ತಿ ರ‍್ಹೈತಬಿ ತೆ ಆಸ್ತಿಕ್ಹು ತೆ ಮನಕ್ಹನೊ ಜ಼ಲಮ ನೈ ವಚಾ಼ಡಿಲೆತೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ಪಾಚಲ್ತೊ ಯೆಸು ಮನಕ್ಹೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ (ಸಾಮ್ಯ ಕದ್ಯಾಮ ತಿನೆ ಮಳೈನ ಕವಾನು) ಕದ್ಯೊ\" ಯಕ್ಲೊ ಘನ್ನೊ ಸೌಕಾರ ವ್ಹತ್ತೊ ವರಿ ತಿನೆ ಘನ್ನಿ ಜ಼ಗಾ ವ್ಹತ್ತಿ ವರಿ ಯಕ್ಕಸಲಾ ತಿನಿ ಜಿಮಿನ್ಪರ ಘನ್ನು ಅನಾಜ಼ ಉಟ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ತೆಳಾಮಾ ತೆ ಸೌಕಾರ ರ‍್ಹಯಲವಾಲೊ ಮಿ ಹಮ್ನಾ ಸು ಕರು? ಮಾರು ಅನಾಜ಼ ಭರಿನ ಮುಕ್ಕಕಾನೆ ಜ಼ಗಾ ನತ್ತಿ! ತಿನಾಕ್ಹು ತೆ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ಪಾಚಲ್ತೊ ತೆ ಸೌಕಾರ, ಮಿ ಸು ಕರು ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ. ಮಾರು ಅನಾಜ಼ ಮ್ಹೆಲಾನು ಘರ ಪಾಡಿನ, ಅನಾಜ಼ ಮ್ಹೆಲಾನಾ ಹುತಿ ಮಿ ಮ್ಹೊಟು ಘರ ಭಾಂದುಸ. ವರಿ ಅನಾಜ಼ ಕ್ಹಾರು ಜ಼ಮಾ ಕರಿನ ಭರಿನ ಮ್ಹೆಲಾವುಸ್, ");
INSERT INTO sle_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ಪಾಚಲ್ತೊ ಮಿ ಮಾರಾ ಹುತಿ ಘನ್ನಾ ವರಕ್ಹ ಚಾ಼ಯೆಥಯಲ ಅನಾಜ಼ ಕುಡ್ಸಿನ ಮ್ಹೆಲ್ಯೊಸ, ಖಾ. ಪಿ. ಖುಶಿ ಕರ! ಕೈಲ್ಯುಸ, ವಿಚಾರ ಕರಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನೆ, ತು ಗ್ಯಾನ ನೈಸೊವಾಲಾ! ಆಜ಼ ರಾತೆಜ಼ ತು ಮರಸಿ! ಹಮ್ನಾ ಕೆ ತು ಕುಡ್ಸಿನ ಮ್ಹೆಲಲ ಅನಾಜ಼ ತೆ ಸು ಥಾಸ? ತೆ ಕ್ಹಾರು ಅನಾಜ಼ ಕಿನಾ ಪಾಲ ಥಾಸ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","\"ತಿನಾಹುತಿ ಕುಡ್ಸಿನ ಮ್ಹೆಲಲ ಆಸ್ತಿ ಲಾಸ್ಟೆ ತಿನಿ ಗತಿ ಅಮ್ಮಜ಼ ಥಾವಸ. ಎ ಮನಕ್ಹ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ಸೌಕರ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಅಮ್ಮ ಕದ್ಯೊ\" ಎ ಕಾರಣ ಕ್ಹು ಮಿ ತುಮೊನೆ ಸು ಕೌಸ ಕದ್ಯಾಮ, ತಿನಾ ಜ಼ಲಮನಾ ಹುತಿ ಖಾವಾನು ಅನ್ನ ವರಿ ಘಾಲ್ಲಿವಾನಾ ಹುತಿ ವಣ್ಣಾವೊನಾ ಹುತಿ ಚಿಂತಾ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ಖಾವಾನಾ ಅನ್ನತಿಬಿ ಜ಼ಲಮ ಹೆಚ್ಚಿನ ವ್ಹೈ ವಣ್ಣಾವೊತಿಬಿ ಅಂಗ ಜ಼ರುರತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ಪಕ್ಕಷಿಯೊನೆ ದೆಕೊ. ತೆ ಬಿತ್ತತಿಯೊ ನೈ, ಕಾಟ್ತಿಯೊ ನೈ ತೆ ಪಕ್ಕಷಿಯೊ ಅನಾಜ಼ ತ್ಯುನಾ ಗುಡ್ಮಾ ಕುಡ್ಸಿನ ಮ್ಹೆಲ್ತಿಯೊ ನೈ. ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಜ಼ತ್ತನ ಕರಸ್ತೊ. ತುಮೆ ಪಕ್ಕಷಿಯೊತಿಬಿ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ಘನ್ನಾ ಚೊ಼ಕಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ತುಮೆ ಅನ್ನನಾ ಹುತಿ ವಣ್ಣಾವೊನಾ ಹುತಿ ಕೆಕ್ಕಲಾ ಚಿಂತಾ ಕರ‍್ಯಾತಬಿ ತುಮೆ ನಕ್ಕರಬಿ ಬೆಳತ್ತಿ ನೈ? ");
INSERT INTO sle_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ನ್ಹಾನಾ ಕಾಮೊ ತುಮೊನೆ ನೈ ಕರಾನೆ ಥಯುತಬಿ ಮ್ಹೊಟಾ ಕಾಮೊ ಕರಾನು ಕಾ ಚಿಂತಾ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ರಾನ್ಮಾ ರ‍್ಹಯಲ ಬೆಳ್ದಾನಾ ಫುಲ್ಲೊನೆ ದೆಕೊ. ತೆ ಫುಲ್ಲೊ ರಾಬ್ತಾ ನೈ. ತ್ಯುನಾ ವಣ್ಣಾ ಶಿಲೆತಾ ನೈ. ತಿಮ್ಮ ರ‍್ಹಯೊತಬಿ ಸೊಲೊಮೊನ ರಾಜಾ಼ನಿ ಅದಿಕಾರ ರ‍್ಹತಾಮಾ ತ್ಯುನಾಮಾ ಯಕ್ಕ ಫುಲ ಲಿಂಗತಬಿ ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿದ್ಯೊನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ಎ ಬರೊಕ್ಹೊ ನೈಸೊವಾಲಾವೊ ಹಮ್ನಾ ರ‍್ಹೈನ ವ್ಹಂತ್ತಾ ಬಳಿ ಜಾ಼ವಾಲಾ ರಾನ್ಮಾನಾ ಚಾ಼ರೊನೆ ದೆಕೊ. ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಕೆಕ್ಲೊ ಚೊ಼ಕೊ ಕರ‍್ಯೊಸ. ತೆ ಚಾ಼ರಾತಿಬಿ ಕ್ಹುದಾ ತುಮೊಪರ ಮಯಾ ಛೆ. ತುಮೊನೆ ಕೆಕ್ಲೊ ದೆಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","\"ತುಮೆ ಸು ಖೌ? ಸು ಪ್ಯು? ಕೈನ ಕೆಳಾಮಾಬಿ ತುಮೆ ವಿಚಾರ ಕರೊ ನಕೊ. ವರಿ ಚಿಂತಾ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ಎ ಕ್ಹಾರು ಮಳಾದೆ ಕೈನ ಎ ಭುಲೊಕ್ನಾ ಮನಕ್ಹೊ ಪ್ರಯತ್ನ ಕರಸ. ಎಕ್ಹಾರು ತುಮೊನೆ ಚಾ಼ಯೆ ಕವಾನು ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ತುಮಾರಾ ಬಾನೆ (ಕ್ಹುದಾನೆ) ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ತೆನೈಸೊ ತುಮೆ ಪೈಲಾ ಕ್ಹುದಾನಾ ರಾಜ್ಯನಾ ಹುತಿ ಟೈಮ ದಿವೊ. ಪಾಚಾ಼ತು ತುಮೊನೆ ಚಾ಼ಯೆಥಯಲ ಕ್ಹಾರುಜ಼ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","\"ನ್ಹಾನು ಮನಕ್ಹೊನು ಗುಂಪ ಭುಚ಼ಕೊ ನಕೊ, ತುಮೊನೆ ತೆ ರಾಜ್ಯ ದಿವಾನೆ ತುಮಾರಾ ಬಾನೆ ಆಸ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ತುಮೊಕನ ರ‍್ಹಯಲ ಆಸ್ತಿ ಇಕ್ಕಿನ,ಇಕ್ಕಿನ ಆಯಲ ದೊಕ್ಡಾ ತ್ರಾಸ್ಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ದಿವೊ. ಎ ಲೊಕಮಾ ಸೌಕಾರತನಾ ಹಮೆಶಾ ರ‍್ಹತಿ ನೈ. ತಿನಾಹುತಿ ಹಮೆಶಾ ರ‍್ಹವಾನುಜ಼ ಗಳ್ಸಿನ ಮ್ಹೆಲೊ. ಹಾಳ ನೈ ಥಾವಾನು ಆಸ್ತಿ ಸ್ವರ್ಗಮಾ ಗಳ್ಸೊ. ತೆ ಆಸ್ತಿನೆ ಚ್ವಟ್ಟಾ ಚೊ಼ರಿ ಕರತಾ ನೈ ವರಿ ತಿನೆ ನುಶಿಯೊ ಲಾಗ್ತಿಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ತಮಾರಿ ಆಸ್ತಿ ಕಿಜಾ಼ ರ‍್ಹವಸ ತ್ಯಾಜ಼ ತುಮಾರು ಮನಸ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ತುಮೆ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ತಯ್ಯಾರ ರ‍್ಹವೊ, ತುಮಾರೊ ದಿವ್ವೊ ಲಾಗಲ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ತುಮೆ ತೊ ತಮಾರೊ ಮಾಲಕ ಐನ ಬಾಕಲ ವಜಾ಼ಡಲ ಬರೊಬ್ಬರ ಬಾಕಲ ಕಾಡಾಲಾ ಥಾವೊ ಹಿವಾನು ಅನ್ನ ಖೈನ ಕೆಳಾಮಾ ಆವಸ ಕವಾನು ಗೊತ್ತ ನತ್ತಿ. ತುಮೆ ಕೆಳಾಮಾಬಿ ತಯ್ಯಾರ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ಮಾಲಕ ಐನ ಕಯೊ-ಕಯೊ ಆಳ ಹುಶಾರ ಛೆ ಕೈನ ದೆಕಸ. ತೆಜ಼ ಆಳೊ ಧನೈ ವ್ಹೈ. ತೆಜ಼ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ತೆಜ಼ ಆಳೊನೆ ಮಾಲಕ ತೆ ಆಳೊನೆ ಬಲೈನ ಬೈಟಾಡಿ ಅನ್ನ ಘಾಲಿನ ದಿವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ವರಿ ತೆ ಆಳೊ ತ್ಯುನಾ ಮಾಲಕನಾ ಹುತಿ ರಾತ್ನಾ ಬೆ ವಾಸ್ತಾ ನೈತೊ ತನ ವಾಸ್ತಾ. ಕೈದಾನು ಮಾಲಕ ದೆಕಿನ ಹಜು಼ನ ಜಾ಼ಗಾ ಛೆ ಕೈನ ತಿಳ್ದಿನ ತೆ ಘನ್ನೊ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ಎ ತುಮೊನೆ ಶೆ ರ‍್ಹವಾದೆ. ಚ್ವಟ್ಟೊ ಆವಾನು ಟೈಮ ಮಾಲಕನೆ ಗ್ವತ್ತ ರ‍್ಹಯುಮ, ತೆ ತಿನಾ ಘರಮಾ ಚೊ಼ರಿಕರಾನೆ ದಿವಸ್ಸು? ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ತಿನಾಲಿಂಗತಜ಼ ತುಮೆ ತಯ್ಯಾರ ರ‍್ಹವೊ! ತುಮೊನೆ ಗ್ವತ್ತ ನೈರ‍್ಹಯಲ ಟೈಮಾಜ಼ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ತೆಳಾಮಾ ಪೆತ್ರಾ ಯೆಸುನೆ ಗುರು ಎ ಸಾಮ್ಯ ತು ಕದಲ ಹಮಾರಾ ಹುತಿ ವ್ಹೈಸು, ಸು ಮನಕ್ಹೊನಾ ಹುತಿ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ಯೆಸು ಅಮ್ಮ ಕದ್ಯೊ\" ಗ್ಯಾನಿ ರ‍್ಹಯಲ ವರಿ ಬರೊಕ್ಹಾನೊ ಥಯಲ ಆಳ ಕುನ್ನ ವ್ಹೈ? ಟೈಮ ಟೈಮೆ ಕರೆಟ್ಟ ಕುಲಿ ಆಳೊನೆ ಅನಾಜ಼ ತುಕಾ ಕರಿನ ದಿವಾನಾ ಘರಪರ ನೆಮಿಸಲ ಆಳಜ಼ ಬರೊಕ್ಹೊ ವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ತೆ ಆಳ ತಿನು ಕಾಮ ಕ್ಹರಿ ಕ್ಹು ಕರತೊ ರ‍್ಹಯೊಮ, ಮಾಲಕ ಆತಾಮಾ ತೆ ಆಳನೆ ಘನ್ನಿ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ಮಿ ತುಮೊನೆ ಕ್ಹರಿ ಕೌಸ. ಮಾಲಕ ಆತಾಮಾ ತಿನಿ ಆಸ್ತಿಪರ ತೆ ಆಳನೆಜ಼ ನೆಮ್ಸಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ತೆನೈಸೊ ತೆ ಆಳ ಕೆಟ್ಟ ರ‍್ಹಯೊಮ ತಿನೊ ಮಾಲಕ ಭೆಗಿನ ಆತೊ ನೈ ಕೈನ, ಕೈಲಿದ್ಯೊಮ ಸು ಥಾಸ? ತೆ ಆಳ ಮಾಲಕನಾ ಬಿಜಾ಼ ಆಳೊನೆ ಮಾರಾಸ ವರಿ ಖೈನ ಪಿನ ನಶಾಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ಪಾಚಲ್ತೊ ತೆ ಮಾಲಕ ತೆ ಆಳನೆ ಗ್ವತ್ತ ನೈಸೊ ಟೈಮಾ ಐನ ತೆ ಆಳನೆ ಶಿಕ್ಷಾ ದಿನ್ನ ತೆ ಮಾಲಕ ಬರೊಕ್ಹೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊಮಾ ತಿನೆ ಢಕ್ಕಲಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ತಿನೊ ಮಾಲಕ ತಿನಾಕ್ಹು ಸು ಆಸ ಮ್ಹೆಲ್ಯೊಸ ಕೈನ ತೆ ಆಳನೆ ಗೊತ್ತ ವ್ಹತ್ತು. ತೆನೈಸೊ ತೆ ಆಳ ತಯ್ಯಾರ ನ್ಹೊತೊ. ವರಿ ತಿನೊ ಮಾಲಕ ದಿದಲ ಕಾಮ ತೆ ಆಳ ಕರ‍್ಯೊ ನ್ಹೊತೊ. ತಿನಾಹುತಿ ತೆ ಆಳನೆ ಮಾಲಕ ಶಿಕ್ಷಾ ದಿವಸ! ");
INSERT INTO sle_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ತೆನೈಸೊ ತಿನಾ ಮಾಲಕನಿ ಆಸ ನೈ ತಿಳದಿಲಿದಲ ಆಳ ತಪ್ಪ ಕರ‍್ಯೊಮ ತಿನೆ ಕಮ ಶಿಕ್ಷಾ ಮಳಸ. ವರಿ ತಿನಾ ಮಾಲಕ ಕದಲ ಕಾಮ ಛೊಡಿನ ತಪ್ಪ ಕಾಮ ಕರ‍್ಯೊಮ ತೆ ಆಳನೆ ಘನ್ನಿ ಶಿಕ್ಷಾ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ವರಿ ಮಿ ಜಗತ್ಮಾ ಆಗ ಘಾಲಾನೆ ಆಯೊಸ! ಯಕ್ಕಲಾಮಾಜ಼ ಬಳ್ತು ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ವರಿ ಮಿ ಬಿಜಿ಼ ತರಾನಿ ಬಾಪ್ತಿಸ್ಮ ವ್ಹಂದು. ತೆ ವ್ಹಂದೆಲಕ್ಕಕಾ ಮಿ ಘನ್ನೊ ಕಷ್ಟಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ಮಿ ಜಗತ್ನೆ ಸಮಾದಾನ ದಿವಾನೆ ಆಯೊಸ ಕೈನ ತುಮೆ ತಿಳದ್ಯಾಸು? ನೈ! ಮಿ ಜಗತ್ಮಾ ಮನಕ್ಹೊಮಾ ಭೆದ ಹುಟ್ಸಾನೆ ಆಯೊಸ! ");
INSERT INTO sle_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ಆಜ಼ತೊ, ಪಾಂಚ಼ ಜ಼ನಾ ರ‍್ಹಯಲ ಕುಟುಂಬಮಾ ಭೆದ ಹುಟ್ಟಸ. ತ್ಯುನೊಮಾನಾ ತನ ಜ಼ನಾ ಬೆ ಜ಼ನಾವೊನೆ ವಿರುದ್ದ ಥಾವಸ. ಬೆ ಜ಼ನಾ ತನ ಜ಼ನಾವೊಪರ ವಿರುದ್ದ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ಬಾಪ ದಿಕ್ರಾಮಾ ಭೆದ ಹುಟ್ಟಸ. ದಿಕ್ರೊ ಬಾಪನೆ ವಿರೊದ ಥಾವಸ. ಬಾಪ ದಿಕ್ರಾನೆ ವಿರೊದ ಥಾವಸ. ಮಾ ವರಿ ದಿಕ್ರಿಮಾ ವಿರೊದ ಥಾವಸ. ದಿಕ್ರಿ ಮಾನೆ ವಿರುದ್ದ ಥಾವಸ. ಮಾ ತಿನಿ ದಿಕ್ರಿನೆ ವಿರುದ್ದ ಥಾವಸ. ಫೈ ವ್ಹವುಮಾ ಭೆದ ಹುಟ್ಟಸ. ವ್ಹವು ಫೈನಾ ವಿರುದ್ದ ಥಾವಸ. ಫೈ ವ್ಹವುನಾ ವಿರುದ್ದ ಥಾವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ಪಾಚಲ್ತೊ ಯೆಸು ಅಮ್ಮ ಕದ್ಯೊ \"ಮ್ಹಾಡ ಪಶ್ಚಿಮ ದಿಕ್ಕಕತೊ ಮ್ಹೊಟು ಥಾವಾನು ದೆಕತಾ ರ‍್ಹತಾಮಾ ತೆ ದಿನಮಾ ಪಾನಿ ಆವಸ, ಕೈನ ಕವೊಸಿ. ತಿನಾ ಲಿಂಗತಜ಼ ಪಾನಿ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ದಕ್ಷಿಣ ದಿಕ್ತೊ ವಾರೊ ಚು಼ಟಸ, ಎ ದಿನೊಮಾ ಘನ್ನಿ ಝಳಾ ಥಾವಸ, ಕವೊಸಿ ತೆ ತಿಮ್ಮಜ಼ ಥಾವಸ, ");
INSERT INTO sle_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ತುಮೆ ಕಪಟ್ಯಾ ವ್ಹೈ! ತುಮೆ ಎಕ್ಹಾರು ತಿಳದಿಲಿವೊಸಿ, ಹಮ್ನಾ ಥಾವಾನು ತುಮೆ ತಿಳದಿಲಿವಾನೆ ಥಾತು ನೈಸು? ");
INSERT INTO sle_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ತುಮೆಜ಼ ಕಾ ತಿರಪ ಕರು ನೈ? ");
INSERT INTO sle_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ಯಕ್ಲೊ ತುಮೊಪರ ಅಪವಾದ ಘಾಲಾನೆ ಕೊರಟೆ ಜಾ಼ತಾಮಾ ತಮಾರಿ ಸಮಶ್ಯಾ ವಾಟ್ಮಾಜ಼ ಬಗೆ ಹರಸಿಲಿವೊ ತುಮೊಕನ ಥಾವಾ ಯಕ್ಲು ಬಗೆ ಹರಸಿಲಿವೊ ನೈತೊ ತುಮೊನೆ ಬಿಜಕ್ಲೊ ಜಜ್ನಾ ಕ್ಹಾಮೊ ಯಳ್ದಿನ ನಿಂಜಾ಼ವಸ. ತೆ ಜಜ್ಜ ತುಮೊನೆ ಜೆಲ್ಮಾ ಘಾಲಾ ಲಗಾಡಸ್. ");
INSERT INTO sle_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ತಿಮ್ಮ ಥೈಯುಮ ತಮೊಕನ ರ‍್ಹಯಲ ತೆಕ್ಲಾ ದೊಕಡಾ ವರಿ ಆಸ್ತಿ ಜ಼ವೈಲಿವೊಸಿ ವರಿ ತೆಕ್ಲು ಥಯು ತಬಿ ತುಮೆ ಜೆಲ್ಮಾತಾ ಭಾರಾ ಆವಾನೆ ಥಾತುಜ಼಼ ನೈ\" ");
INSERT INTO sle_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ತೆ ಟೈಮಾ ತ್ಯಾ ರ‍್ಹಯಲವಾಲಾ ದಕ್ಹಾಜ಼಼ನಾ ಯೆಸುಕನ ಐನ, ಗಲಿಲಾಯಮಾ ಬಲಿ ದೆತಾವಾಲಾವೊನೆ ಪಿಲಾತನ ಖಲಾಸ ಕರಾಯಲ, ಯೆಸುಕನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ\"ತೆ ಖಲಾಸ ಥಯಲವಾಲಾ ಮನಕ್ಹೊ ಗಲಿಲಾಯಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊತೊಬಿ ಘನ್ನಾ ಪಾಪಿಯೊ ವ್ಹೈ ಕೈನ ತುಮೆ ತಿಳದ್ಯಾಸು? ");
INSERT INTO sle_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ಮಿ ನ್ಹವೈ \"ತ್ಯುನೆ ತೆವಾ ಪಾಪಿಯೊ ನ್ಹೊತಾ, ತೆನೈಸೊ ತುಮೆ ತಮಾರಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ನೈ ಫರಯಾಮ ತ್ಯುನಾ ಲಿಂಗತಜ಼ ಹಾಳ ಥಾವೊಸಿ! ");
INSERT INTO sle_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ಸಿಲೊವಾಮಾ ಗೊಪುರ ಪಡ್ತಾಮಾ,ಮರಿಗಯಲ ಅಟ್ರಾ ಜ಼ನಾವೊನಾ ಹುತಿ ತುಮಾರಿ ವಿಚಾರ ಸು ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ನ್ಹವೈ, ತ್ಯುನೆ ತೆವಾ ಪಾಪಿಯೊ ನ್ಹೊತಾ! ತುಮೆ ತಮಾರಾ ಪಾಪೊ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ನೈ ಫರಯಾಮ ತ್ಯುನಾ ಲಿಂಗತಜ಼ ತುಮೆ ಹಾಳ ಥಾವೊಸಿ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ಪಾಚಲ್ತೊ ಯೆಸು ತ್ಯುನೊಕನ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ; ಯಕ್ಲೊ ತಿನಾ ದ್ರಾಕ್ಷಿಯೊನಾ ಮಳಾಮಾ ಯಕ್ಕ ಅಂಜುರನು ಝಾಡ ಲಗಾಡ್ಯೊ. ವರಿ ದಕ್ಹಾ ದಿನ್ನ ಥಯಲಪರ ತೆ ಮನಕ್ಹ ತೆ ಅಂಜುರನಾ ಝಾಡಮಾ ಫಲ ಉಟ್ಯು ವಸೆ ಕರಿನ ತ್ಯಾ ಆಯೊ. ತೆ ಝಾಡಮಾ ದೆಕ್ತಾಮಾ ಫಲ ಉಟ್ಯು ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ತೆ ಮನಕ್ಹ ಮಳೊ ಕೈದಾನಾ ಹುತಿ, ಯಕ್ಕ ಆಳನೆ ತೆ ಮಳಾಮಾ ಮುಕ್ಯೊ. ತೆ ಮಳಾನೊ ಮಾಲಕ ತಿನಾ ಆಳನೆ ಕದ್ಯೊ ಮಿ ಆ ಝಾಡ ಘಾಲಿನ, ತನ, ವರಕ್ಹ ಥಯಾ. ಹಜು಼ನಬಿ ಫಲ ನತ್ತಿ ದಿದ್ಯು. ಎ ಝಾಡನೆ ಕತ್ರಿಪಾಡ. ಕದ್ಯೊ. ಎ ಝಾಡನಾ ಹುತಿ ಜಿಮಿನಬಿ ಗ್ವಡ್ಡ ಥೈ ಗೈಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ತಿಮ್ಮ ಕತಾಮಾ ಆಳ ಮಾಲಕನೆ ಕದ್ಯೊ. ಮಾಲಕ ಹಜು಼ನ ಯಕ್ಕ ವರಕ್ಹ ತು ತಡ್ದಿಲೆ ಆ ಅಂಜುರನು ಝಾಡ ಫಲ ದೆಸ,ಮಿ ತೆ ಝಾಡನಾ ಸುತ್ತೆಬಿ ಖಂದಿನ ಗ್ವಬ್ರಾ ಘಾಲುಸ, ");
INSERT INTO sle_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ತೆಳಾಮಾ ಅಗಲ್ಯಾ ವರಕ್ಹೆ ಎ ಝಾಡ ಫಲ ದೆಸ. ವರಿ ಎ ಝಾಡ ಫಲ ನೈ ದಿದ್ಯುಮ ಮಿಜ಼ ಕತ್ರಿನ ನಾಕಿ ಪಾಡುಸ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ಯೆಸು ಸಬ್ಬತ ದಿನಮಾ ಯಕ್ಕ ಸಬಾಮಂದಿರಮಾ ಉಪದೆಶ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ತೆ ಸಬಾಮಂದಿರಮಾ ಯಕ್ಕ ಕೆಟ್ಟ ಆತ್ಮಾ ಧರಲ ಹೆಣ ಮನಕ್ಹ ತ್ಯಾ ವ್ಹತ್ತಿ, ತೆ ಹೆಣ ಮನಕ್ಹ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ಕ್ಹು ಅಟ್ರಾ ವರಕ್ಹತಿಬಿ ಡುಗಿ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ಯೆಸು ತಿನೆ ದೆಕಿನ, ತಿಕನ ಬಲೈನ\"ಯಾ ತುನೆ ರ‍್ಹಯಲ ರೊಗ ತುನೆ ಛೊಡಿನ ಗೈ ಪಡ್ಯುಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ಯೆಸು ತಿಪರ ಹತ ಮ್ಹೆಲ್ತಾಮಾ ತೆ ಹೆಣ ಮನಕ್ಹ ಸಿದಾ ಹುಬ್ರಯಿ, ತೆಳಾಮಾ ತೆ ಹೆಣ ಮನಕ್ಹ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರಿ. ");
INSERT INTO sle_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ಯೆಸು ಸಬ್ಬತ ದಿನಮಾ ತೆ ಹೆಣ ಮನಕ್ಹನೆ ಅರಾಮ ಕರಲ ಹುತಿ ತೆ ಸಬಾಮಂದಿರನಾ ಅದಿಕಾರಿಯೊ ಶಿಟ್ಟ ಥೈನ \"ಮನಕ್ಹೊನೆ ಕಾಮ ಕರಾ ಹುತಿ ಅಟ್ವಾಡಾನಾ ಛೆ ದಿನ್ನ ಛೆ ತೆ ದಿನೊಮಾ ಐನ ತುಮೆ ಅರಾಮ ಥಾಸಕೊಸಿ, ಸಬ್ಬತ ದಿನಮಾ ಅರಾಮ ಕರೈ ಲಿವೊ ನಕೊ \"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ತೆ ವಾತೆ ಯೆಸು, ತುಮೆ ಕಪಟ್ಯಾ ವ್ಹೈ ತುಮೆ ತುಮಾರಾ ಪಶು ಪಕ್ಷಿಯೊನೆ ದಿನ್ನೆಬಿ ತ್ಯುನೊನೆ ಪಾನಿ ಪಿಲಾವಾನೆ ಲಿನಜಾ಼ವೊಸಿ. ವರಿ ಸಬ್ಬತ ದಿನಮಾ ಎ ಕ್ಹಾರು ಕರೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ಮಿ ಅರಾಮ ಕರಲ ಹೆಣ ಮನಕ್ಹ ಅಬ್ರಹಾಮನಿ ಖಾಂದಾನವಾಲಿ ವ್ಹೈ. ಸೈತಾನ ಎ ಹೆಣ ಮನಕ್ಹನೆ ಅಟ್ರಾ ವರಕ್ಹತು ಬಂದನಮಾ ಮ್ಹೆಲ್ಯುತು, ತಿನಾ ಹುತಿ ಎ ಹೆಣ ಮನಕ್ಹನೆ ಸಬ್ಬತ ದಿನಮಾ ತಿನೊ ರೊಗ ಮಿ ಅರಾಮ ಕರ‍್ಯೊ, ತಿನಾ ಹುತಿ ಕ್ಹರಿಮಾಜ಼ ಎ ತಪ್ಪ ನ್ಹವೈ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ಎ ವಾತೊ ಐಕಿನ ಯೆಸುನೆ ವಿರುದ್ದ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊ ಸರಮಾಯಿಗಯಾ. ವರಿ ಯೆಸು ಕರಲ ಅದ್ಭುತ ದೆಕಿನ ತ್ಯಾನಾ ಮನಕ್ಹೊ ಖುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ಪಾಚಲ್ತೊ ಯೆಸು\"ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಕಿನೆ ಹೊಲ್ಸಿಯೆ? ಮಿ ತೆ ಕಿನೆ ಹೊಲ್ಸು? ");
INSERT INTO sle_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಸಾಸವಿ ಕಾಳ ಲಿಂಗತ ಛೆ. ಯಕ್ಲೊ ತಿನಾ ಮಳಾಮಾ ಎ ಸಾಸವಿ ಕಾಳನೊ ಬಿಯ್ಯೊ ಘಾಲಸ. ತೆ ಬೆಳ್ದಿನ ಝಾಡ ಥಾವಸ, ಪಕ್ಷಿಯೊ ತೆ ಝಾಡನಿಯೊ ಠೊಂಗಿಯೊಪರ ಘರ ಭಾಂದಿಲಿವಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ವರಿ ಅಮ್ಮ ಕದ್ಯೊ ‘ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಮಿ ಕಿನೆ ಹೊಲ್ಸು? ");
INSERT INTO sle_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ತೆ ಖಾಟಾ ಲೊಟನೆ ಹೊಲಸ್, ತೆ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ತೆ ಲಿನ ಲೊಟ್ಮಾ ಪಾನಿ ಘಾಲಿನ ಮಳಾತಾಮಾ ತೆ ಲೊಟ ಖಾಟೊ ಥಯೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ಯೆಸು ಕ್ಹಾರಾ ಖೆಡಾವೊಪರ ವರಿ ಗಾಮೊಪರ ಉಪದೆಶ ಕರತೊ ಯೆರೊಸೆಲಿಮೆ ಚಾ಼ಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ತೆ ದಿನಮಾ ಯಕ್ಲೊ ಯೆಸುನೆ\"ಸ್ವಾಮಿ ದಕ್ಹಾ ಮನಕ್ಹೊ ರಕ್ಷಣೆ ಹೊಂದಸ ಕ್ಹಾಲಿ ದಕ್ಹಾ ಮನಕ್ಹೊ ಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ತೆ ವಾತೆ ಯೆಸು ಸ್ವರಗೆ ಜಾ಼ವಾನು ಅಗ್ದಿ ನ್ಹಾನಾ ಬಾಕಲಮಾತಾ ಜಾ಼ವಾನಾ ಹುತಿ ತ್ರಾಸ ಖಾವೊ! ಘನ್ನಾ ಮನಕ್ಹೊ ತ್ಯಾ ಜಾ಼ವಾನೆ ಕೊಶಿಶ ಕರಸ, ತೆನೈಸೊ ತ್ಯುನೊಕನ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ಘರನೊ ಮಾಲಕ ಉಟಿನ ಬಾಕಲ ಝಾಕಲ್ಪರ, ತುಮೆ ಭಾರಾ ಹುಬ್ರೈನ ಖಾಲಿ ವಜಾ಼ಡು, ವಜಾ಼ಡ್ಯಾ ತಬಿ ತೆ ಮಾಲಕ ಬಾಕಲ ಕಾಡ್ತೊ ನೈ. ಸ್ವಾಮಿ ಹಮಾರಾಹುತಿ ಬಾಕಲ ಕಾಡ! ಕೈನ ತುಮೆ ಕವೊಸಿ. ತೆ ಮಾಲಕ ತುಮೊನೆ ತುಮೆ ಕುನ್ನ ವ್ಹೈ. ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತುಮೆ ಕಿಜ಼ಗಾನಾ ವ್ಹೈ? ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ತೆಳಮಾ ತುಮೆ ಹಮೆ ತಾರಾ ಕ್ಹಾತೆ ಖಾದಲವಾಲಾ ವ್ಹೈ. ವರಿ ಪಿದಲವಾಲಾ ವ್ಹೈ. ತು ಹಮೊನೆ ಉಪದೆಶ ಕರಲವಾಲೊ ವ್ಹೈ. ಕೈನ ಕವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ತೆಳಾಮಾ ತೆ ತುಮೊನೆ, ತುಮೆ ಕುನ್ನ ವ್ಹೈ. ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ, ತುಮೆ ಕಿಜ್ಗಾ಼ನಾ ವ್ಹೈ. ನ್ಹ್ಯಾಂತ್ತಾ ಗೈಪಡೊ. ತುಮೆ ಪಾಪನು ಕಾಮ ಕರಾಲಾ ಮನಕ್ಹೊ ವ್ಹೈ. ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","\"ಅಬ್ರಹಾಮ,ಯಾಕೊಬ, ಇಸಾಕ ವರಿ ಕ್ಹಾರಾ ಪ್ರವಾದಿಯೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ರ‍್ಹಯಲ ತುಮೆ ದೆಕೊಸಿ. ವರಿ ತುಮೊನೆ ಭಾರಾ ಘಾಲಾಲಗಾಡಸ. ತೆಳಾಮಾ ತುಮೆ ಭುಚಿ಼ಕಿನ ವರಿ ಸಿಟ್ಟಕ್ಹು ವದ್ರೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ಮನಕ್ಹೊ ಪುರವತಾ, ಪಶ್ಚಿಮ, ಉತ್ತರ, ದಕ್ಕಷಿಣತಾ ಆವಸ. ತ್ಯುನೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಖಾವಾನೆ ಬೈಟಸ್. ");
INSERT INTO sle_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ಹಮ್ನಾ, ಲಾಸ್ಟೆ ರ‍್ಹಯಲ ವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಪಸ್ಟ ಥಾವಸ, ಪಸ್ಟ ರ‍್ಹಯಲವಾಲಾ ಲಾಸ್ಟೆ ಥಾವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ತೆ ಟೈಮಾ ದಕ್ಹಾ ಫರಿಸಾಯರೊ ಯೆಸುಕನ ಐನ, ತು \"ನ್ಹ್ಯಾಂತೊ ಗೈಪಡ! ಹೆರೊದ ತುನೆ ಖಲಾಸ ಕರುಸ ಕವಾಡ್ಯೊಸ\"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ಯೆಸು ತ್ಯುನೊನೆ, ತುಮೆ ಗೈನ ತೆ ನರಿನೆ (ಹೆರೊದ್ನೆ) ಆಜಾ಼ನಾ ದಿನಮಾ ವರಿ ವ್ಹಂತ್ತಾ ಮನಕ್ಹೊನೆ ಮಿ ಕೆಟ್ಟ ಆತ್ಮಾವೊಕ್ಹು ಛೊಡೌಸ. ವರಿ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರಾನು ಕಾಮ ಪುರಾ ಕರುಸ, ಮರನಾದಿನ್ನೆ ಮಾರು ಕಾಮ ಪುರಾ ಖಲಾಸ ಥಾಸ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ಪಾಚಲ್ತೊ ಮಿ ಯೆರೊಸೆಲಿಮೆ ಜೌ಼ ಕಾಕದ್ಯಾಮ ಪ್ರವಾದಿಯೊನೆ ತ್ಯಾಜ಼ ಖಲಾಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","\"ಯೆರೊಸೆಲಿ, ಯೆರೊಸೆಲಿ ತು ಪ್ರವಾದಿಯೊನೊ ಖಲಾಸ ಕರಶಿ. ಕ್ಹುದಾ ತುಕನ ಮೊಕ್ಕಲಲ ಮನಕ್ಹೊನೆ ತು ಮಂಗಾಳಾ ಮಾರಿನ ಖಲಾಸ ಕರಶಿ. ಕುಕಡಿ ತಿನಾ ಬಚ್ಚಾವೊನೆ ತಿನಾ ರೆಕ್ಕಕ್ಕಯಾನ ಹೆಟು ಬೈಟಾಡಿ ಲಿದಲ ಲಿಂಗತ ಮಿ ತಾರಾ ಮನಕ್ಹೊನೆ ಸಹಾಯಾ ಕರಾನೆ ಕೆಕ್ಕಲಿಕಿ ಸಲಾ ಮಿ ಚಿಂತಾ ಕರ‍್ಯೊ ವರಿ ತು ಮನೆ ಮರ್ಯಾದಿ ದಿದ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ತಾರಿ ಯಕ್ಕ ದೆವಾಲಯ ಖಾಲಿ ಥೈ ಜಾ಼ವಸ. ಕರ್ತಾನಾ ನಾಮ ಪರ ಆವಾಲಾನೆ ಆಶಿರ್ವಾದ! ಕೈನ ಕವಾನಾ ಟೈಮ ಲಕ್ಕಾ ತು ಮನೆ ದೆಕುಜ಼ ನೈ ಕೈನ ಮಿ ತುನೆ ಕೌಸ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ಯಕ್ಕ ಸಬ್ಬತದಿನಮಾ ಯೆಸು ಖಾಸ ಫರಿಸಾಯನಾ ಘರಮಾ ಖಾವಾನೆ ಗಯೊ. ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಯೆಸುನೆ ಯಕ್ಕ ಸಂವಾ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ತೆಳಾಮಾ ಯೆಸುನಾ ಕ್ಹಾಮಾ ಜಲೊದರ ರೊಗರ‍್ಹಯಲವಾಲಾನೆ ಲೈನ ಬೈಟಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ಯೆಸು ಫರಿಸಾಯರೊನೆ ಧರಮೊಪದೆಶ ಕರಾಲಾ ಶಾಸ್ತ್ರಿಯೊನೆ\"ಸಬ್ಬತ್ ದಿನಮಾ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರಾನು ಚೊ಼ಕು ವ್ಹೈಸು? ಸು ತಪ್ಪ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ತ್ಯುನೆ ಸುಜ಼ ಕದ್ಯಾ ನೈ. ತೆಳಾಮಾ ಯೆಸು ರೊಗ ರ‍್ಹಯಲ ಮನಕ್ಹನೆ ಮುಟ್ಟಿನ ಅರಾಮ ಕರಿನ ತಿನೆ ಮೊಕ್ಕಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ಯೆಸು ಫರಿಸಾಯರೊನೆ ವರಿ ಶಾಸ್ತ್ರಿಯೊನೆ\"ಸಬ್ಬತ್ ದಿನಮಾ ತುಮಾರಾ ದಿಕ್ರಾನೆ ತುಮೆ ರಾಕಲ ಪಶುವೊನೆ ಇರಮಾ ಪಡಿಗಯಾಮ, ತೆಳಾಮಾಜ಼ ತುಮೆ ತ್ಯುನೊನೆ ಇರ ಮಾತಾಭಾರಾ ಕಾಡಿನ ವಚಾ಼ಡೊಸಿ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ತೆ ವಾತೆ ಫರಿಸಾಯರೊ ರ‍್ಹೈನೆಕಾ ಶಾಸ್ತ್ರಿಯೊ ರ‍್ಹೈನೆಕಾ ಜವಾಬ ದಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ಅತಿಥಿಯೊ ಥೈನಾಯಲ ದಕ್ಹಾ ಜ಼ನಾ ಬೈಟಾನಾ ಹುತಿ ಚೊ಼ಕಿ ಜ಼ಗಾ ಹುಡ್ಕಾನು ಯೆಸು ದೆಕಿನ ತ್ಯುನೊಕನ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"ಯಕ್ಲೊ ತುನೆ ಹಿವಾಮಾ ಖಾವಾನೆ ಬಲಾಯೊಮ, ತು ಚೊ಼ಕಿ ಜ಼ಗಾ ಬೈಟು ನಕೊ. ತೆ ತುತ್ತಿ ಘನ್ನೊ ಚೊ಼ಕೊ ರ‍್ಹಯಲವಾಲಾನೆ ಬಲಾಯಲ ರ‍್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ತು ಚೊ಼ಕಿ ಜ಼ಗಾ ಬೈಟಲ ರ‍್ಹಯೊಮ, ತುನೆ ಹಿವಾಮಾ ಬಲಾಯಲ ವಾಲೊ ತೆ ಐನ, ತುನೆ ಆ ಜ಼ಗಾ ಅನೆ ಛೊಡಿನ ದೆ ಕೈನ, ತುನೆ ಕಸ. ತೆಳಮಾ ತು ಸರಮಾಯಿನ ಲಾಸ್ಟನಿ ಜ಼ಗಾಪರ ಬೈಟೆಕ್ಹ. ");
INSERT INTO sle_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ತಿನಾಹುತಿ ಯಕ್ಲೊ ತುನೆ ಹಿವಾನೆ ಬಲಾತಾಮಾ ಲಾಸ್ಟನಿ ಜ಼ಗಾಪರ ಗೈನ ಬೈಟ. ತೆಳಾಮಾ ತುನೆ ಹಿವಾನೆ ಬಲಾಯಲ ವಾಲೊ ಐನ. ದೊಸ್ತ ತು ಚೊ಼ಕಿ ಜ಼ಗಾ ಬೈಟ ಕವಸ!, ತೆಳಾಮಾ ಹಿವಾಮಾ ಆಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತುನೆ ಮರ್ಯಾದಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ಕುನ್ನಬಿ ಮಿಜ಼ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಕವೈ ಲಿವಾಲೊ ನ್ಹಾನೊ ಥಾವಸ. ನ್ಹಾನೊ ಥೌಸ ಕೈನ ಕವೈಲಿವಾಲೊ ತೆ ಮ್ಹೊಟೊ ಥಾವಸ\" ");
INSERT INTO sle_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ಪಾಚಲ್ತೊ ಯೆಸು ಖಾವಾನಾ ಹುತಿ ಬಲಾಯಲ ಫರಿಸಾಯರನೆ\"ರಾತೆ ಖಾವಾನೆ ವರಿ ದುಪಾರೆ ಖಾವಾನೆ ತಾರಾ ದೊಸ್ತೊನೆ ಭಾಯೊನೆ ಕುಟುಂಬವಾಲಾನೆ ವರಿ ಸೌಕಾರ ರ‍್ಹಯಲ ತಾರಾ ಆಜು಼ಬಾಜು಼ ವಾಲಾನೆ ಘರೆ ಬಲಾಯೊಮ, ತ್ಯುನೆ ತುನೆಬಿ ತುನೆ ಖಾವಾನಾ ಹುತಿ ಘರೆ ಬಲಾವಸ, ತೆಳಾಮಾ ತೆಜ಼ ತುನೆ ಪ್ರತಿಫಲ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ತಿನಾ ಬದ್ಲಿ, ತು ಖಾವಾನೆ ಅನ್ನ ಕರತಾಮಾ ಗರಿಬ ಮನಕ್ಹೊನೆ, ಅಪಾಯಿಜ಼ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಲಂಗ್ಡಾವೊನೆ ವರಿ ಕುಡ್ಡಾವೊನೆ ಖಾವಾನೆ ಬಲಾ. ");
INSERT INTO sle_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ತೆಳಾಮಾ ತುನೆ ಆಶಿರ್ವಾದ ಮಳಸ, ಕಾಕದ್ಯಾಮ, ಎ ಮನಕ್ಹೊ ಖಾವಾನಾ ಹುತಿ ತುನೆ ಘರೆ ಬಲಾತಾ ನೈ. ತ್ಯುನೊಕನ ಸುಜ಼ ನತ್ತಿ. ತೆನೈಸೊ ಕ್ಹರಿನಾ ಮನಕ್ಹೊ ಜಿವ್ತಾ ಥೈನ ಉಟಿನ ಆತಾಮಾ, ತುನೆ ಪ್ರತಿಫಲ ಮಳಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ಯೆಸುನಾ ಕ್ಹಾತೆ ಖಾವಾನಾ ಹುತಿ ಬೈಟಲವಾಲಾವೊಮಾ ಯಕ್ಲೊ ಎ ವಾತೊ ಐಕಿನ, ಯೆಸುನೆ\"ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಖಾವಾಲಾಜ಼ ಧನ್ಯ ವ್ಹೈ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ; ಯಕ್ಲೊ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಖಾವಾನಾ ಹುತಿ ಅನ್ನ ಕರಾಯಲ ಟೈಮ್ಮಾ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಬಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ಖಾವಾನೊ ಟೈಮ ಆತಾಮಾ, ತೆ ತಿನಾ ಆಳೊನೆ ಮೊಕ್ಲಿನ, ಆವೊ ಅನ್ನ ತಯ್ಯಾರ ಛೆ, ಕೈನ ಖಾವಾನೆ ಆಯಲ ವಾಲಾವೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ತೆನೈಸೊ ತೆ ಖಾವಾನೆ ಆಯಲವಾಲಾ ಮನಕ್ಹೊ ಹಮೊನೆ ಆವಾನೆ ಥಾತು ನೈ ಕದ್ಯಾ. ಹರಿ ಯಕ್ಲೊ ಯಕೆಕ ನ್ಯವಾ ಕದ್ಯಾ ಪೈಲಾ ವಾಲೊ ಮಿ ಹಮ್ನಾ ಖೆತರ ಇಕ್ಕಾತು ಲಿದ್ಯೊಸ. ವರಿ ಮಿ ತ್ಯಾ ಗೈನ ಕೈದು, ಮನೆ ಮರಗಿನ ಮಾಫ ಕರ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ಬೆವಾವಾಲೊ, ಮಿ ಹಮ್ನಾ-ಹಮ್ನಾ ಪಾಂಚ಼ ಜೊ಼ಡಿ ಬೈಲೊ ಇಕ್ಕಾತೊ ಲಿದ್ಯೊಸ, ಮಿ ಗೈನ ತೆ ಬೈಲೊ ಚೊ಼ಕಿಯೊ ಛೆಸು ನೈ ಕೈನ ದೆಕು, ಮನೆ ಮರಗಿನ ಮಾಫ ಕರ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ತನ್ವಾವಾಲೊ ಮಿ ಹಮ್ನಾ-ಹಮ್ನಾ ಹಿವಾ ಕರಲಿದ್ಯೊಸ, ಮನೆ ಆವಾನೆ ಥಾತು ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ತಿನಾ ಹುತಿ ತೆ ಆಳ ಪಾಚೊ಼ ಫರಿನ ಗೈನ ತಿನಾ ಮಾಲಕನೆ ತೆ ಕ್ಹಾರು ಕದ್ಯೊ. ತೆಳಾಮ ತೆ ಮಾಲಕ ಘನ್ನೊ ಸಿಟ್ಟ ಥೈನ ತಿನಾ ಆಳನೆ ಎ ಗಾಮ್ನಿಯೊ ಒಣಿಯೊಮಾ ವರಿ ಸಂದಿಯೊಮಾ ಭೆಗಿನ ಗೈನ ಗರಿಬೊನೆ ಅಪಾಯಿಜ಼ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಕುಡ್ಡಾವೊನೆ ಲಂಗ್ಡಾವೊನೆ ನ್ಹ್ಯಾ ಬಲೈ ಲಿನ ಆ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","\"ತೆಳಾಮಾ ತೆ ಆಳ ಗೈನ ಐನ ಮಾಲಕ, ತು ಕದಲ ತಿಮ್ಮಜ಼ ಕರ‍್ಯೊ. ವರಿ ತೆಕ್ಲಾ ಮನಕ್ಹೊ ಆಯಾ ತಬಿ ಅಪೊಕನ ಹಜು಼ನ ಮನಕ್ಹೊನೆ ಜ಼ಗಾ ಛೆ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ತೆಳಾಮಾ ತೆ ಮಾಲಕ ತಿನಾ ಆಳನೆ ಕದ್ಯೊ. ತು ಗೈನ ರಸ್ತಾವೊಪರ ಜಾ಼ವಾಲಾ ಖೆತ್ರೊಮಾತಾ ಜಾ಼ವಾಲಾ ಮನಕ್ಹೊನೆ ವರಿ ಕುನ್ನ ಮಳಸ ತ್ಯುನೊನೆ ಬಲೈ ಲಿನಜ಼ ಆ, ಮಾರು ಘರ ಮನಕ್ಹೊಕ್ಹು ಭರಿ ಜಾ಼ವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ಮಿ ಪೈಲಾ ಬಲಾಯಲ ಮನಕ್ಹೊಮಾ ಯಕ್ಲೊಬಿ ಮಾರಾ ಅನ್ನನು ಸವಾದ ದೆಕು ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ಯಕ್ಕ ಸಲಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ಗುಂಪ-ಗುಂಪ ಥೈನ ಜಾ಼ತಾಮಾ ತ್ಯುನೊನೆ ದೆಕಿನ ಅಮ್ಮ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ಮಕನ ಆವಾಲೊ ಮುತ್ತಿ (ಯೆಸುತಿಬಿ) ಹೆಚ್ಕಿ ತಿನಾ ಮಾ ಬಾಪನೆ, ಬೈಕೊನೆ, ಬಚ್ಚಾ಼ವೊನೆ ತಿನಾ ಭಾಯೊ ಭೆನೊನೆ ವರಿ ತಿನಾಕ್ಹು ತೆ ಮಯಾ ಕರಾಲೊ ರ‍್ಹಯೊಮ ತೆ ಮಾರೊ ಶಿಷ್ಯೊ ಥಾವಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ ತಿನಿ ಶಿಲುವಿ ತೆಜ಼ ಉಚೈಲಿನ ಜಾ಼ವಾಲೊ ಮಾರೊ ಶಿಷ್ಯೊ ಥಾವಾನೆ ಸಾದ್ಯ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","\"ತು ಯಕ್ಕ ಘರ ಭಾಂದು ಕದ್ಯಾಮ ಪೈಲಾ ಬೈಟಿನ ತಿನೆ ಕೆಕ್ಲಾ ಖರಚ಼ ಥಾಸ ಕೈನ ತಿಳದಿಲಿವ. ತೆ ಘರ ಭಾಂದಾನೆ ತುಕನ ಘನ್ನಾ ದೊಕ್ಡಾ ಛೆಸು ಕೈನ ಲೆಕ್ಕೊ ಘಾಲಿನ ದೆಕ, ");
INSERT INTO sle_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ನೈತೊ, ತು ಘರ ಭಾಂದಾನು ಕಾಮ ಚಾಲು ಕರ‍್ಯೊಮ ತೆ ಘರ ಭಾಂದಾನೆ ನೈಥಯುಮ, ");
INSERT INTO sle_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ಮನಕ್ಹೊ ತುನೆ ದೆಕಿನ ಆ ಮನಕ್ಹ ಘರ ಭಾಂದಾನು ಕಾಮ ಚಾಲು ಕರ‍್ಯೊ ವರಿ ತಿನಾ ಹತೆ ಥಯು ನೈ ಕೈನ ತುನೆ ಕದ್ರಾವಸ, ");
INSERT INTO sle_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ಯಕ್ಲೊ ರಾಜೊ಼ ಬಿಜೆಕ್ಲಾ ರಾಜಾ಼ನಾ ವಿರುದ್ದ ಯುದ್ದನೆ ಜಾ಼ತಾಮಾ, ಪೈಲಾ ತೆ ರಾಜೊ಼ ಬೈಟಿನ ವಿಚಾರ ಕರಲಿವಸ, ತಿಕನ ದಕ್ಹ ಹಜಾ಼ರ ಸೈನಿಕೊ ರ‍್ಹಯಾಮ. ಇಕ್ಹ ಹಜಾ಼ರ ಸೈನಿಕೊ ರ‍್ಹಯಲ ಹಜು಼ನ ಯಕ್ಲಾ ರಾಜಾ಼ನೆ ಸೊಲ್ಸಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ಕೈನ ತೆ ರಾಜೊ಼ ವಿಚಾರ ಕರಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ತೆ ಬಿಜೆಕ್ಲಾ ರಾಜಾ಼ನೆ ನೈ ಸೊಲ್ಸಾನೆ ಥಯುಮ, ತ್ಯುನಾ ಮನಕ್ಹೊನೆ ಮೊಕ್ಲಿನ ಶಾಂತಿ ಸಮಾದಾನೆ ಬೊಲ್ಲಿನ ಫೈಸಲೊ ಕರಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ತಿನಾ ಲಿಂಗತಜ಼ ತುಮೆ ವಿಚಾರ ಕರು. ತುಮೆ ಮಾರಾ ಪಾಚಾ಼ ಔಸ ಕದ್ಯಾಮ ತುಮೊಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಶಿಷ್ಯಾ ಥಾವಾನೆ ಸಾದ್ಯ ನತ್ತಿ! ");
INSERT INTO sle_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ಮಿಟ್ಟು ಚೊ಼ಕು ವ್ಹೈ, ವರಿ ಮಿಟ್ಟುಜ಼ ತಿನು ಸವಾದ ಜ಼ವೈ ಲಿದ್ಯುಮ ತೆ ಮಿಟ್ಟಾನೆ ಶಾಕ್ಹುಜ಼ ಸ್ವಾದ ಕರಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ತಿನಾಹುತಿ ಮಾತಿನೆ ರ‍್ಹೈನೆಕಾ ಗೊಬ್ರಾನೆ ರ‍್ಹೈನೆಕಾ ಉಪಯೊಗ ನತ್ತಿ, ಮನಕ್ಹೊ ತಿನೆ ಭಾರಾ ನಾಕಿ ಪಾಡಸ. ಕಾನೊ ರ‍್ಹಯಲವಾಲಾ ಮಾರಿಯೊ ವಾತೊ ಐಕೊ! ");
INSERT INTO sle_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ಯಕ್ಕ ದಿನ್ನ ಘನ್ನಾ ಭು ಭಾಡೊಲಿವಾಲಾ ವರಿ ಪಾಪಿಯೊ ಯೆಸು ಕವಾನು ಉಪದೆಶ ಐಕು ಕೈನ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ತೆಳಾಮಾ ಫರಿಸಾಯರೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ\"ದೆಕೊ! ಎ ಮನಕ್ಹ (ಯೆಸು) ಪಾಪಿಯೊನೆ ಬಲೈನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಮಳಿನ ಅನ್ನ ಖಾವಾಡ್ಯೊಸ\"ಕತಾ ಯೆಸುಪರ ಗುಣ ಗುಟ್ಟಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ತುಮೊಮಾನಾ ಯಕ್ಲಾಕನ ಕ್ಹೊ ಬಕ್ರಾ‌ ಛೆ ಕೈನ ತಿಳದಿಲಿಯೆ ತೆ ಕ್ಹೊ ಬಕ್ರಾವೊಮಾನು ಯಕ್ಕ ಬಕ್ರು ಜ಼ವೈ ಗಯುಮ, ತೆ ಮನಕ್ಹ ನವ್ವದಪರ ನೌ ಬಕ್ರಾ ತ್ಯಾಜ಼ ಛೊಡಿನ ಜ಼ವೈಗಯಲ ಯಕ್ಕ ಬಕ್ರಾನೆ ಹುಡ್ಕತೊ ಜಾ಼ವಸ. ತೆ ಬಕ್ರು ಮಳೆ ಲಕ್ಕಾ ತೆ ಹುಡ್ಕತೊಜ಼ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ತೆ ಮನಕ್ಹನೆ ಜ಼ವೈಗಯಲ ಬಕ್ರು ಮಳ್ತಮಾ ಘನ್ನೊ ಖುಶಿ ಥಾವಸ. ತೆ ಬಕ್ರಾನೆ ಖಾಂದಾಪರ ಉಚೈಲಿನ ತಿನಾ ");
INSERT INTO sle_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ಘರೆ ಆವಸ ತೆ ತಿನಾ ದೊಸ್ತೊನೆ ವರಿ ಆಜು಼ಬಾಜು಼ವಾಲಾನೆ ಬಲೈನ ಮಾರಾ ಕ್ಹಾತೆ ಖುಶಿ ಕರೊ, ಮಾರು ಜ಼ವೈಗಯಲ ಬಕ್ರು ಮಳ್ಯುಸ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ತಿನಾ ಲಿಂಗತಜ಼, ಯಕ್ಕ ಪಾಪಿ ತಿನು ಮನಸ. ಕ್ಹುದಾ ಬಗಲ ಫರಯೊಮ ಸ್ವರಗಾಮಾ ಘನ್ನಾ ಖುಶಿ ಥಾವಸ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ನೌವ್ವದಪರ ನೌ ಮನಕ್ಹೊ ಕ್ಹುದಾಬಗಲ ಫರಲ ವಾಲಾತಿಬಿ ಯಕ್ಕ ಪಾಪಿ ಕ್ಹುದಾ ಬಗಲ ಫರಯೊಮ ತಿನಾ ವಾಸ್ತರ ಘನ್ನಾ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ನೈತೊ \"ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹಕನ ದಕ್ಹ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಛೆ ಕೈನ ತಿಳದಿಲಿಯೆ. ತೆ ಹೆಣ ಮನಕ್ಹ ತಿಮಾನೊ ಯಕ್ಕ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಜ಼ವೈ ಲಿಪಾಡಸ್. ತೆ ದಿವ್ವೊ ಲೈನ ತಿನು ಘರ ಝಾಡಸ. ತೆ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಮಳೆ ಲಕ್ಕಾ ಹುಡ್ಕಸ, ");
INSERT INTO sle_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ಜ಼ವೈ ಗಯಲ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಮಳಲ್ಪರ ತೆ ತಿನಾ ದೊಸ್ತನಾ ಕ್ಹಾತೆ ಆಜು಼ಬಾಜು಼ವಾಲಾವೊನೆ ಬಲೈನ, ಮಾರಾ ಕ್ಹಾತೆ ಖುಶಿ ಕರೊ ಜ಼ವೈ ಗಯಲ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಮಳ್ಯೊಸ, ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ತಿನಾ ಲಿಂಗತಜ಼ ಯಕ್ಕ ಪಾಪಿ ತಿನಾ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾಬಗಲ ಫರಯೊಮ ಸ್ವರ್ಗಮಾ ರ‍್ಹಯಲ ದೆವದುತೊ ಘನ್ನಾ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ಪಾಚಲ್ತೊ ಯೆಸು ಅಮ್ಮ ಕದ್ಯೊ\" ಯಕ್ಕ ಮನಕ್ಹನೆ ಬೆ ದಿಕ್ರಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ತಿಮಾನೊ ನ್ಹಾನೊ ದಿಕ್ರೊ, ತಿನಾ ಬಾನೆ \"ತಾರಿ ಆಸ್ತಿಮಾನೊ ಮಾರೊ ವಾಟೊ ದೆ ಕೈನ ಕದ್ಯೊ. ತಿನಾಹುತಿ ತಿನೊ ಬಾ ತಿನಿ ಆಸ್ತಿಮಾನೊ ವಾಟೊ, ತಿನಾ ನ್ಹಾನಾ ದಿಕ್ರಾನೆ ವಾಟಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","\"ತೆಳಾಮಾ ತಿನೊ ನ್ಹಾನೊ ದಿಕ್ರೊ ತಿನೊ ವಾಟೊ ಲಿನ ಭಾರಲ್ಯಾ ದೆಶೆ ಗೈಪಡ್ಯೊ. ತ್ಯಾ ತೆ ಕೆಟ್ಟ ಚಟಾ ಸಿಕ್ಕಕಿನ ಪುರಾ ಆಸ್ತಿ ಹಾಳ ಕರಲಿ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ದಕ್ಹಾ ದಿನ್ಪರ‍ ತೆ ರ‍್ಹಯಲ ದೆಶಮಾ ಬರಗಾಲ ಐಯು. ತೆಳಾಮಾ ತೆ ದೆಶಮಾ ಸು ನ್ಹೊತು, ತೆ ಪಟ್ಟಾನೆ ಘನ್ನಿ ಭುಕ್ಕ ಲಾಗಿತಿ ತಿನಾ ಹುತಿ ತಿನೆ ದೊಕಡಾನಿ ಜ಼ರುರತ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ತಿನಾ ಹುತಿ ತೆ ದೆಶಮಾ ರ‍್ಹಯಲ ಯಕ್ಲಾಕನ ಕುಲಿ ಕರಾನೆ ತಿಕನ ವ್ಹತ್ತೊ. ತೆ ಮನಕ್ಹ ತೆ ಪಟ್ಟಾನೆ ಢುಕ್ಕಕುರೊ ಚ಼ರಾವಾನಾ ಹುತಿ ತಿನೆ ಖೆರತೆ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ತೆಳಾಮಾ ತೆ ಪಟ್ಟಾನೆ ಘನ್ನಿ ಭುಕ್ಕ ಲಾಗಿತಿ ತಿನಾಹುತಿ ಢುಕ್ಕಕುರೊ ಖಾವಾನಿ ತರಕಾರಿ ಖೌಕೈನ ತೆ ಪಟ್ಟೊ ಕೈಲಿದ್ಯೊ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ತಿನೆ ತೆ ಖಾವಾನೆ ದಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ತೆಳಾಮಾ ತೆ ಪಟ್ಟೊ ಗ್ಯಾನ ಐಯು ತೆ ಕಾಮ ಕರಲ ತಿನೆ ತಿಳದ್ಯು. ವರಿ ತಿನಾ ಮನಸ್ಮಾ ಕೈಲಿದ್ಯೊ. ಮಾರಾ ಬಾನಾ ಘರಮಾ ರ‍್ಹಯಲ ಆಳೊನೆ ಘನ್ನು ಅನ್ನ ರ‍್ಹವಸ ಮಿ ತೊ ನ್ಹ್ಯಾ ಭುಕ್ಕೊ ಮರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ಮಿ ನ್ಹ್ಯಾಂತೊ ಗೈ ಪಡಸು. ವರಿ ಮಿ ಮಾರಾ ಬಾಕನ ಗೈನ ಬಾ ಮಿ ತಾರಾ ವಿರೊದ ವರಿ ಕ್ಹುದಾನಾ ವಿರೊದ ಪಾಪ ಕರ‍್ಯೊಸ, ");
INSERT INTO sle_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ತಾರೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾನೆ ಯೊಗ್ಯ ನತ್ತಿ. ಮನೆ ತಾರಾ ಘರನಾ ಆಳೊಮಾ ಮಿಬಿ ಯಕ್ಲೊ ವ್ಹೈ ಕೈನ ತಿಳದಿಲೆ ಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ತಿನಾ ಲಿಂಗತಜ಼ ತೆ ತಿನಾ ಬಾಕನ ಚಾ಼ಲ್ಯೊತೊ\" ತಿನೊ ನ್ಹಾನೊ ದಿಕ್ರೊ ದುರತೊ ಆವಾನು ವಳ್ಕಿನ ತಿನೆ ಮರಗಿನ ತಿಕನ ನ್ಹಾಟತೊ ಐನ ತಿನಾ ಗಳೆ ಮಳಿನ ದಿಕ್ರಾನೆ ಮಟ್ಟಿ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ದಿಕ್ರೊ ತಿನಾ ಬಾಪನೆ, ಬಾ, ಮಿ ಕ್ಹುದಾ ವಿರೊದ ಥೈನ ತುನೆ ವಿರೊದ ಥೈನ ಪಾಪ ಕರ‍್ಯೊಸ. ತಾರೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾನೆ ಮಿ ಯೊಗ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ತೆನೈಸೊ ಬಾಪ ತಿನಾ ಸೆವಕೊನೆ, ಐಕೊ! ಚೊ಼ಕಾ ವಣ್ಣಾ ಲೈನ ಅನೆ ಘಾಲೊ. ತಿನಾ ಬೊಟೊನೆ ಇಟ್ಟಿಯೊ ಘಾಲೊ. ಪಗೊನೆ ಚೊ಼ಕಾ ಚಪ್ಲೊ ಘಾಲೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ಘಟ್ಟಮುಟ್ಟ ರ‍್ಹಯಲ ಹೊರಿನೆ ಕಾಟಿನ ಖುಶಿ ಕರಿಯೆ. ");
INSERT INTO sle_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ಮಾರೊ ದಿಕ್ರೊ ಜ಼ವೈ ಗಯೊತೊ, ಎ ತಪ್ಪಿನ ಗಯೊತೊ. ಹಮ್ನಾ ವರಿ ಮಳ್ಯೊಸ\" ಕದ್ಯೊ. ತೆನೈಸೊ ತ್ಯುನೆ ಖುಶಿ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ತೆಳಾಮಾ ಮ್ಹೊಟೊ ದಿಕ್ರೊ ಖೆತರಮಾ ವ್ಹತ್ತೊ. ತೆ ಘರೆ ಆತಾಮಾ ಗಿದ್ದೊ ಕವಾನು ನ್ಹಾಚಾ಼ನು ಅವಾಜ಼ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ತಿನಾಹುತಿ ತೆ ತ್ಯುನಾ ಆಳಮಾನಾ ಯಕ್ಲಾನೆ ಬಲೈನ ಆ ಸು ಕರಾಡಾಸ? ತಿನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ತೆಳಾಮಾ ತೆ ಆಳ ಕದ್ಯೊ. ತಾರೊ ಜ಼ವೈಗಯಲ ಭೈ ಫರಿನ ಆಯೊಸ. ತಿನಾ ಹುತಿ ತಾರೊ ಬಾ ಘಟ್ಟ ಮುಟ್ಟ ರ‍್ಹಯಲ ಹೊರಿ ಕಾಟಾ ಲಗಾಡ್ಯೊಸ್. ವರಿ ತಾರೊ ಬಾ ಘನ್ನೊ ಖುಶಿಮಾ ಛೆ! ಕದ್ಯೊ ಕಾಕದ್ಯಾಮ ತಾರೊ ಭೈ ಫರಿನ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ತೆಳಾಮಾ ತಿನೊ ಮ್ಹೊಟೊ ದಿಕ್ರೊ ಶಿಟ್ಟ ಥೈನ ತೆ ಘರಮಾ ಗಯೊ ನೈ. ತೆಳಾಮಾ ತಿನೊ ಬಾ ಭಾರೊ ಐನ ತಿನೆ ಮ್ಹೈ ಆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ತೆಳಾಮಾ ತಿನೊ ಮ್ಹೊಟೊ ದಿಕ್ರೊ ತಿನಾ ಬಾನೆ ಮಿ ತಾರೊ ಆಳ ಥೈನ ಘನ್ನಾ ವರಘತೊ ಸೆವಾ ಕರ‍್ಯೊಸ! ವರಿ ತು ಕದಲ ತಿಮ್ಮಜ಼ ಮಿ ಐಕ್ಯೊಸ. ವರಿಬಿ ತು ಮಾರಾಹುತಿ ಮಾರಾ ದೊಸ್ತೊನಾ ಹುತಿ ಯಕ್ಕ ಬಕ್ಕರುಬಿ ಕಾಟ್ಯೊ ನತ್ತಿ. ವರಿ ತು ಮಾರಾಹುತಿ ಮಾರಾ ದೊಸ್ತೊನೆ ಖಾವಾನೆ ಅನ್ನ ಕರಾಯೊ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ತೆನೈಸೊ ತಾರೊ ನ್ಹಾನೊ ದಿಕ್ರೊ ತಾರಾ ಕ್ಹಾರಾ ದೊಕ್ಡಾ ಸುಳಿಯೊನಾ ಹುತಿ ಜ಼಼ವೈ ಲಿದ್ಯೊ. ವರಿ ತೆ ಘರೆ ಫರಿನೆ ಆತಾಮಾ ತಿನಾಹುತಿ ತು ಹೊರಿ ಕಾಟಾಲಗಾಡ್ಯೊ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ತಿಮ್ಮ ಕತಾಮಾ ತಿನೊ ಬಾ ಕದ್ಯೊ ದಿಕ್ರಾ, ತುತೊ ಮಾರಾ ಕ್ಹಾತೆ ಕೆಳಾಮಾಬಿ ರ‍್ಹಸಿ. ಮಕನ ರ‍್ಹಯಲ ಕ್ಹಾರುಜ಼ ತಾರು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ಅಪೆ ಖುಶಿ ಕರು ಕಾಕದ್ಯಾಮ ತಾರೊ ಭೈ ತೊ ಜ಼಼ವೈ ಗಯೊತೊ. ತೆ ಮರಿಗಯೊತೊ ಜಿವ್ತೊ ಥಯೊಸ ವರಿ ಅಪೊಕನ ಫರಿನ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ. ಯಕ್ಕ ಕಾಲ್ಮಾ ಯಕ್ಕ ಸೌಕಾರ ವ್ಹತ್ತೊ. ತೆ ಸೌಕರ, ತೆ ಕರಾನೊ ವ್ಯಾಪಾರ ದೆಕಿಲಿವಾಹುತಿ ಯಕ್ಕ ಆಳನೆ ಮ್ಹೆಲ್ಯೊತೊ. ದಕ್ಹಾದಿನ್ನ ಥಯಲ್ಪರ, ತೆ ಆಳ ಸೌಕಾರನೆ ಮೊಸ ಕರಾಡ್ಯೊಸ ಕವಾನು ಸೌಕಾರನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ತಿನಾಹುತಿ ತೆ ಸೌಕಾರ ತಿನಾ ಆಳನೆ ಬಲೈನ, ತಾರಾ ಹುತಿ ಮನೆ ಸುದ್ದಿ ಐಸ. ಕದ್ಯೊ. ಮಾರಾ ದೊಕ್ಡಾ ತು ಶಾನಾ ಹುತಿ ಖರಚ್ಯೊ ಕರ‍್ಯೊಸ ಕೈನ? ತು ಮನೆ ಲೆಕ್ಕೊ ದೆ ತು ಕೆ. ಇತ್ತಿ ಉಪ್ಪರ ಮಿ ಕರಾನು ವ್ಯಾಪಾರ ತು ನಕೊ ದೆಕಿಲಿವ, ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ತೆಳಾಮಾ ತೆ ಆಳ ತಿನಾ ಮನಸ್ಮಾ ಮಿ ಸು ಕರು ಕೈನ? ವಿಚಾರ ಕರಲಿದ್ಯೊ. ಮಾರೊ ಮಾಲಕ ಮನೆ ಕಾಮ ಪರತೊ ಕಾಡಿ ಪಾಡಸ! ಖಾಡಿಯೊ ಖಂದಾನೆ ಮನೆ ತಾಕತ ನತ್ತಿ. ಭಿಕ ಮಾಂಗಾನೆ ಮನೆ ಸರಮ ವಾಟಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ಮಿ ಹಮ್ನಾ ಸು ಕರು ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ! ಮಿ ಕಾಮ ಜ಼ವೈ ಲಿದಲ್ಪರ, ಮಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ದೊಸ್ತಿ ಕರಲ್ಯು ಕಾಮಪರ ಲಿವಾ ವರಕ್ಹು ಮಿ ಹಮ್ನಾ ಕಯುಬಿ ಚೊ಼ಕು ಕಾಮ ಕರಿನ ದೆಕಾಡು. ಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ಪಾಚಲ್ತೊ ತೆ ಆಳ ತಿನಾ ಸೌಕಾರಕನ ಸಾಲಾ ಲಿದಲವಾಲಾವೊನೆ ತೆಕ್ಲಾವೊನೆ ಬಲೈನ. ತಿಮಾನಾ ಯಕ್ಲಾನೆ ಬಲೈನ, ತು ಮಾರಾ ಸೌಕರನಿ ಸಾಲಾ ಕೆಕ್ಕಲಿ ದಿವ್. ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ತೆಳಾಮಾ ತೆ ಮನಕ್ಹ ಕದ್ಯೊ ಮಿ ಕ್ಹೊ ಬ್ಯಾರಲೊ ಒಲಿವ ತೆಲ ದ್ಯು ಕದ್ಯೊ. ವರಿ ತೆ ಆಳ ಸಾಲಾವಾಲಾನೆ ಕದ್ಯೊ, ತಾರೊ ಲೆಕ್ಕೊ ನ್ಹ್ಯಾಛೆ. ಬೈಟ ಭೆಗಿನ ಆ ಲೆಕ್ಕಕಾಮಾ ಛೆ ಕಿಲೊ ವ್ಹೈ ಕೈನ ಐವತ್ತ ಅಮಾ ಬರದ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ಪಾಚಲ್ತೊ ತೆ ಆಳ ಬಿಜೆ಼ಕ್ಲಾನೆ ಬಲೈನ ತು ಮಾರಾ ಸೌಕರನೆ ಕೆಕ್ಲಿ ಸಾಲಾ ದ್ಯು. ಕೈನ ತಿನೆ ಪುಚ್ಯೊ. ಹಜಾ಼ರ ಕೊತಳಾ ಘೌ ದ್ಯು ಕದ್ಯೊ. ತೆಳಾಮಾ ತೆ ಆಳ ತೆ ಸಾಲಾವಾಲಾನೆ ಕದ್ಯೊ ತಾರೊ ಲೆಕ್ಕೊ ನ್ಹ್ಯಾಜ಼ ಛೆ ಆ ಲೆಕ್ಕಕಮಾ ಕಮ ಬರದ. ಆಟ ಕ್ಹೊ ಕೊತಳಾ ಕೈನ ಬರದ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ಪಾಚಲ್ತೊ ತೆ ಸೌಕಾರ ತಿನೊ ಮೊಸ ಕರಲ ಆಳನೆ ಬಲೈನ. ತು ಕೆಕ್ಲಿ ಶಾಣೆತನಾ ಕರ‍್ಯೊಸ, ಕದ್ಯೊ. ಹೊ ಲೊಕ್ಮಾನಾ ಮನಕ್ಹೊ ಘನ್ನಾ ಶಾಣ್ಯಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ಮೊಸ ಕರಿನ ರಾಬೆಲ ಆಸ್ತಿಕ್ಹು ದೊಸ್ತ ಕರಲಿವೊ ತೆ ಆಸ್ತಿ ತುಮೊನೆ ಛೊಡಿನ ಜಾ಼ತಾಮಾ ತ್ಯುನೆ ತುಮೊನೆ ಹಮೆಶಾ ರ‍್ಹವಾನ ಜ಼ಗಾ ಬಲೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ದಕ್ಹಾಮಾಜ಼ ಬರೊಕ್ಹೊ ರ‍್ಹಯಲವಾಲೊ ಘನ್ನು ರ‍್ಹಯಲ ಟೈಮಾಬಿ ಬರೊಕ್ಹಾವಾಲಾಲಿಂಗತ ರ‍್ಹವಸ. ದಕ್ಹಾಮಾಜ಼ ಅನ್ಯಾಯಮಾ ರ‍್ಹಯಲವಾಲೊ ಘನ್ನು ರ‍್ಹಯಲ ಟೈಮಾಬಿ ಅನ್ಯಾಯವಾಲೊ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ತಿನಾಹುತಿ ತುಮೆ ಮೊಸ ಕರಿನ ಆಸ್ತಿ ದಿದಲಮಾಜ಼ ಬರೊಕ್ಹೊ ನೈಸೊ ರ‍್ಹಯಾಮ ಮ್ಹೈನತ ಕರಲ ಕ್ಹರಿನಿ ಆಸ್ತಿ ತುಮೊನೆ ಕುನ್ನ ದಿಸವ? ");
INSERT INTO sle_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ಬಿಜೆ಼ಕ್ಕಲಾನಿ ಆಸ್ತಿಪರ ಬರೊಕ್ಹೊ ನೈ ಮ್ಹೆಲಲ ರ‍್ಹಯಾಮ ತುಮಾತು ಸ್ವಂತ ರ‍್ಹಯಲ ಸಾಮನಜ಼ ತುಮೊನೆ ಕುನ್ನ ದೆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ಕಯೊ ಸೆವಕ ಯಕಜ಼ ಟೈಮಾ ಬೆ ಮಾಲಕೊನೆ ಸೆವಾ ನೈ ಕರತೊ. ಯಕ್ಕನೆ ಮಯಾ ಕರಿನ ಯಕ್ಲಾನೆ ದುರ ಕರಸ, ತುಮೆ ಯಕಜ಼ ಟೈಮಾ ಕ್ಹುದಾನೆಬಿ ವರಿ ದೊಕಡಾವೊನೆ ಸೆವೆ ನೈ ಕರತಾ\" ");
INSERT INTO sle_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ತೆಳಾಮಾ ಫರಿಸಾಯರೊ ಎ ಕ್ಹಾರು ಐಕಾಡ್ಯಾತಾ. ಫರಿಸಾಯರೊ ದೊಕಡಾವೊಪರ ಆಸ ರ‍್ಹಯಲ ವಾಲಾ ವ್ಹತ್ತಾ ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆಸುನೆ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ವರಿ ಯೆಸು ಫರಿಸಾಯರೊನೆ ಕದ್ಯೊ, ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ತುಮೆ ಚೊ಼ಕಾ ವ್ಹೈ ಕೈನ ಕವೈಲಿವೊಶಿ. ವರಿ ಕ್ಹರಿಮಾಜ಼ ತುಮಾರು ಮನಸ್ಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ಗ್ವತ್ತ ಛೆ. ಮನಕ್ಹೊನಾ ನಜ಼ರಮಾ ಚೊ಼ಕು ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ಕೆಟ್ಟ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","\"ಮನಕ್ಹೊ ಮೊಶೆ ಬರ್ದಲ ಧರಮಶಾಸ್ತ್ರ ಪ್ರಕಾರ ಪ್ರವಾದಿಯೊ ಕದಲಜ಼ ತಿಮ್ಮಜ಼ ಮನಕ್ಹೊ ಜಿವ್ನಾ ಕರು ಕವಾನಿ ಕ್ಹುದಾನಿ ಆಸ ವ್ಹತ್ತಿ. ದಿಕ್ಕಷಾಸ್ನಾನ ದಿಲಾವಾಲೊ ಯೊಹಾನನಾ ಆಯಲ ಕಾಲ್ಮಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ತಿಳ್ಸಸ, ಘನ್ನಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ವಾನಾ ಹುತಿ ಘನ್ನಾ ಕಷ್ಟ ಪಡಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ಹಬಾಳ ಜಿಮಿನ ನೈಸೊ ಥಾವಸ ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರಮಾ ರ‍್ಹಯಲ ಯಕ್ಕಬಿ ವಾತ ಕಾಡಾನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ಯಕ್ಲೊ ತಿನಿ ಬೈಕೊನೆ ಛೊಡಿನ ಬಿಜೆ಼ಕ್ಲಿನೆ ಹಿವಾ ಕರಲಿದ್ಯೊಮ ತೆ ವೈಬಿಚಾರ ಕರಾಲೊ ಲಿಂಗತ ಥಾವಸ. ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ಮಾಟಿನೆ ಛೊಡಿನ ಬಿಜೆ಼ಕ್ಲಾನೆ ಹಿವಾ ಕರಲಿದಿಮ ತೆ ವ್ಯಭಿಚಾರ ಕರಾಲಿ ಲಿಂಗತ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ವರಿ ಯೆಸು ತ್ಯುನೊಕನ ಅಮ್ಮ ಕದ್ಯೊ\" ಯಕ್ಲೊ ಸೌಕಾರ ವ್ಹತ್ತೊ, ತೆ ಸೌಕಾರ ಘನ್ನಾ ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲೆತೊತೊ. ತೆ ಘನ್ನೊ ಸೌಕಾರ ರ‍್ಹಯಲ ಹುತಿ ತೆ ದಿನ್ನೆಬಿ ಚೊ಼ಕು ಚೊ಼ಕೊಜ಼ ಅನ್ನ ಖಾತೊ ಖುಶಿ ಕರ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ತ್ಯಾ ಲಾಜ಼ರ ಕವಾಲೊ ಯಕ್ಲೊ ಗರಿಬ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ತಿನೆ ಅಂಗ ಭರಿನ ಘುಮ್ಡಾ ವ್ಹತ್ತಾ ತೆ ಲಾಜ಼ರ ಸೌಕಾರನಾ ಘರನಾ ಕ್ಹಾಮೊ ಪಡಲ ರ‍್ಹತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ವರಿ ಸೌಕಾರ ಖೈನ ಉಗ್ರಲ ಭಾರು ನಾಕಲ ಅಟ್ಟು ಅನ್ನ ಖಾತೊತೊ. ಕುತ್ರಾ ಐನ ಲಾಜ಼ರನಾ ಘುಮ್ಡಾ ಚಾ಼ಟ್ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","\"ದಕ್ಹಾ ದಿನ್ನ ಥಯಲಪರ ಲಾಜ಼ರ ಮರಯೊ. ಸ್ವರಗನಾ ದುತೊ ಐನ ತೆ ಲಾಜ಼ರನೆ ಅಬ್ರಹಾಮಕನ ಲಿನಗಯಾ, ಯಕ್ಕ ದಿನ್ನ ತೆ ಸೌಕಾರಬಿ ಮರಯೊ. ತಿನೆ ಮಜಾ಼ರಮಾ ಬುಜ್ಜಾ಼. ");
INSERT INTO sle_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ತೆನೈಸೊ ತೆ ಸೌಕಾರ ನರಕಮಾ ತ್ರಾಸ ಖಾತೊ ಘನ್ನೊ ದುರ ರ‍್ಹಯಲ ಅಬ್ರಹಾಮನಾ ಕ್ಹಾತೆ ಲಾಜ಼ರನೆ ದೆಕಿನ, ");
INSERT INTO sle_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ಹಮಾರೊ ಬಾ ಅಬ್ರಹಾಮ, ಮನೆ ಮರಗಿನ ಲಾಜ಼ರನೆ ಮಕನ ಮೊಕಲ. ತೆ ತಿನೊ ಬೊಟ ಪಾನಿಮಾ ಡುಬೈನ ಮಾರಿ ಜಿಬ್ಬ ಥಂಡಿ ಥಾವಾ ವರಕ್ಹಿ ಕರ, ಮಿ ಆಗಮಾ ಬಳವಾಡ್ಯೊಸ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ತೆ ವಾತೆ ಅಬ್ರಹಾಮ ತಿನೆ ದಿಕ್ರಾ ತಾರಿ ಜಿವಿತಮಾ ತು ಸು ಕರ‍್ಯೊ ತುನೆ ಗ್ವತ್ತ ನತ್ತಿಸು? ತ್ಯಾ ತುನೆ ಕ್ಹಾರಿ ಸುಕಾ ವ್ಹತ್ತಿ. ತೆನೈಸೊ ಲಾಜ಼ರತೊ ತಿನಿ ಜಿವಿತ ಪುರಾ ಕಷ್ಟ ವರಿ ತ್ರಾಸ ಖಾದ್ಯೊಸ. ತಿನಾ ಹುತಿ ತೆ ಸ್ವರ್ಗಮಾ ತಿನೆ ಸುಖಾ ಛೆ. ತು ಕಷ್ಟ ಖಾವಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ತೆನೈಸೊ ತಾರಾಮಾ ಹಮಾರಾಮಾ ಘನ್ನು ಮ್ಹೊಟು ಫರಕ ಛೆ ತ್ಯಾ ಐನ ತುನೆ ಮದತ ಕರಾನೆ ಕಿನೆಜ಼಼ ಸಾದ್ಯ ನತ್ತಿ. ತೆನೈಸೊ ತು ರ‍್ಹಯಲ ಜ಼ಗಾತೊ ಹಮೆ ರ‍್ಹಯಲ ಜ಼ಗಾ ಕಿನೆಜ಼಼ ಆವಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ತೆಳಾಮಾ ಸೌಕಾರ ಕದ್ಯೊ ತಿಮ್ಮ ರ‍್ಹಯುಮ ಲಾಜ಼ರನೆ ಭುಲೊಕಪರ ರ‍್ಹಯಲ ಮಾರಾ ಬಾನಾ ಘರೆ ಮೊಕಲ! ");
INSERT INTO sle_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ಮಾರಾ ಪಾಂಚ಼ ಭಾಯೊ ಛೆ ತ್ಯುನೆ ಮಿ ತ್ರಾಸ ಖಾವಾನ ಜ಼ಗಾ ಆವಾನು ನಕೊ, ಕೈನ ತ್ಯುನೊನೆ ಹುಶಾರ ಕರಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ತೆ ವಾತೆ ಅಬ್ರಹಾಮ, ಮೊಶೆ ಬರ್ದಲ ಧರಮ ಶಾಸ್ತ್ರ ವರಿ ಪ್ರವಾದಿಯೊನಾ ಬುಕ್ಕೊ ತ್ಯುನೊಕನ ಛೆ ತ್ಯುನೆ ತ್ಯುನಿಯೊ ವಾತೊ ಐಕಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ತೆ ವಾತೆ ಸೌಕಾರ, ಬಾ ಅಬ್ರಹಾಮ ತಿಮ್ಮ ಕೌ ನಕೊ ಕುನ್ನಬಿ ಮರಲವಾಲಾವೊಮಾನೊ ಯಕ್ಲೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಗೈನ ತ್ಯುನೊಕನ ಕವಾದೆ ತೆಳಾಮಾ ತ್ಯುನೆ ಚೊ಼ಕಾ ಥಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ತೆ ವಾತೆ ಅಬ್ರಹಾಮ ತಿನೆ, ನೈ! ತಾರಾ ಭಾಯೊ ಮೊಶೆನು ಧರಮ ಶಾಸ್ತ್ರ ವರಿ ಪ್ರವಾದಿಯೊ ಕದಲ ವಾತೊ ನೈ ಐಕ್ಯಾಮ, ಮರಲವಾಲಾವೊಮಾನಾ ಮನಕ್ಹೊಮಾ ಜಿವ್ತಾ ಥೈನ ಉಟಲ ವಾಲಾವೊನಿಯೊ ವಾತೊ ನೈ ಐಕ್ತಾ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ\"ಮನಕ್ಹೊನೆ ಪಾಪಮಾ ಚ಼ಲಾವಾನಿಯೊ ಸಂಗತಿಯೊ ಖರಿಮಾಜ ಆವಸ. ವರಿ ತೆ ಕಿಕ್ಹು ಆವಸ ತೆ ಮನಕ್ಹನಿ ಗತಿ ಮಿ ಸು ಕೌ! ");
INSERT INTO sle_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ತಾಕತ ಕಮ ರ‍್ಹಯಲವಾಲಾವೊನ, ಪಾಪ ಕರಾನೆ ಸಿಕ್ಕಲಾವಾಲೊ ತಿನಾ ಗರದನೆ ವಾಟ ದೆಕಾಡಾನೊ ಮ್ಹೊಟೊ ದಗ್ಡೊ ಭಾಂದಿಲಿನ ಸಮುಂದರಮಾ ಪಡಾನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ತಿನಾಹುತಿ ತುಮೆ ಹುಶಾರ ರಹೊ\"ತಾರೊ ಭೈ ಪಾಪ ಕರಲ ರ‍್ಹಯೊಮ, ತಿನೆ ಭುಚ್ಕಾ಼ಡ. ವರಿ ತಾರೊ ಭೈ ಕರಲ ಪಾಪನೆ ಪಶ್ಚಾತಾಪ ಪಾಡ್ಯೊಮ ತಿನೆ ಮಾಫ ಕರ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ತಾರೊ ಭೈ ತಾರಾ ವಿರುದ್ದ ಯಕ್ಕ ದಿನಮಾ ಕ್ಹಾತ ಸಲಾ ಪಾಪ ಕರಿನ ತೆ ಕ್ಹಾತ ಸಲಾಬಿ, ತುನೆ ಮಾಫಕರ ಕೈನ ಕದ್ಯಾಮ, ತು ತಿನೆ ಮಾಫ ಕರು \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ಅಪೊಸ್ತಲೊ ಯೆಸುನೆ \"ಹಮಾರೊ ಬರೊಕ್ಹೊ ಹೆಚ್ಕಿ ಥಾವಾ ವರಕ್ಹು ಹಮೊನೆ ಆಶಿರ್ವಾದ ದೆ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ಯೆಸು ತ್ಯುನೊನೆ ಅಮ್ಮ ಕದ್ಯೊ, \"ತುಮಾರೊ ಬರೊಕ್ಹೊ ಸಾಸಿವೆ ಕಾಳ ಯಕ್ಲೊ ಮ್ಹೊಟೊ ಬರೊಕ್ಹೊ ರ‍್ಹಯೊಮ, ತುಮೆ ಉಂಬ್ರೊನಾ ಝಾಡನೆ ತು ಕಿತೈನ ಸಮುಂದರಮಾ ಗೈನ ಪಡ ಕದ್ಯಾಮ ತುಮೆ ಕದಲ ತಿಮ್ಮಜ಼ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","\"ತುಮೊಮಾ ಯಕ್ಲಾನಾ ಖೆತರಮಾ ಕಾಮ ಕರಾಹುತಿ ಯಕ್ಕ ಆಳ ಛೆ ಕೈನ ತಿಳದಿಲಿಯೆ. ತೆ ಆಳ ಖೆತರನಿ ಜಿಮಿನ್ಪರ ಹೆರಗತೊ ರ‍್ಹವಸ, ನೈತೊ ತೆ ಆಳ ಬಕ್ರಾ ಚ಼ರಾತೊ ರ‍್ಹವಸ. ತೆ ಆಳ ಖೆತರನು ಕಾಮ ಮುಗ್ಸಿನ ಘರೆ ಆತಾಮಾ ತು ತಿನೆ ಸು ಕಸಿ? ಮ್ಹೈ ಆ ತು ಖಾವಾನೆ ಬೈಟ ಕೈನ ಕಸಿಸು? ");
INSERT INTO sle_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ನೈ! ತು ತಿನೆ, ಮಾರಾ ಹುತಿ ಖಾವಾನೆ ಅನ್ನ ಕರ. ಪಾಚಲ್ತೊ ತು ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ಮನೆ ಖಾವಾನೆ ಅನ್ನ ಘಾಲಿನ ದೆ. ಮಿ ಖೈನ ಪಿದಲಪರ ತು ಖಾ ಕೈನ ತಿನೆ ಕಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ತಾರೊ ಆಳ ತಿನೊ ಕಾಮ ಕರಲ ಹುತಿ, ತು ತಿನೆ ಘನ್ನಿ ಮರ್ಯಾದಿ ದಿವಾನೆ ಜಾ಼ವುನಕೊ. ಆಳ ರ‍್ಹಯಲಜ಼ ಮಾಲಕನಿ ವಾತ ಐಕಾ ಹುತಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ಎಜ಼ ನಿಯಮೊ ತುಮೊನೆಬಿ ಲಾಗು ಥಾವಸ. ತುಮೊನೆ ದಿದಲ ಕಾಮೊ ತುಮೆ ಪುರಾ ಕರಲ್ಪರ\"ಹಮೆ ಆಳೊ ವ್ಹೈ, ಹಮೆ ಕಾರಾನು ಕರ್ತವ್ಯ ಹಮೆ ಕರ‍್ಯಾಸ \"ಕೈನ ಕೌ\" ");
INSERT INTO sle_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ಯೆಸು ಯೆರೊಸೆಲಿಮ ಫರತೊ ಗಲಿಲಾಯನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ತ್ಯಾ ತೆ ಯಕ್ಕ ಖೆಡೆ ಆಯೊ. ತ್ಯಾ ತಿನೆ ದಕ್ಹ ಜ಼ನಾ ದೆಕ್ಯಾ ತ್ಯುನೆ ಯೆಸುನಾ ಕ್ಹಾಮಾ ಆಯಾ ನೈ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಕ್ಹಾರಾಜ಼ನಾ ಕುಷ್ಠ ರೊಗಿಯೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ತೆನೈಸೊ ತ್ಯುನೆ ಯೆಸುನೆ ದೆಕಿನ \"ಯೆಸು! ಗುರು! ಮರಗಿನ ಮನೆ ಸಹಾಯಾ ಕರ ಕೈನ ಜೊ಼ರ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ಯೆಸು ತ್ಯುನೊನೆ ದೆಕಿನ\"ಜಾ಼ವೊ ತುಮಾರು ಅಂಗ ಯಾಜೊ಼ಕೊನೆ ದೆಕಾಡೊ ಕೈನ \"ತ್ಯುನೊನೆ ಕದ್ಯೊ. ತ್ಯುನೆ ಯಾಜಕೊನೆ ತ್ಯುನು ಅಂಗ ದೆಕಾಡಾನೆ ಜಾ಼ತಾಮಾಜ಼ ತ್ಯುನೊ ಕುಷ್ಟರೊಗ ರ‍್ಹಯಲ ಗೈಪಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ತ್ಯುನೊಮಾನೊ ಯಕ್ಲೊ ತೆ ಅರಾಮ ಥಯಲ ದೆಕಿಲಿನ ಫರಿನ ಯೆಸುಕನ ಐನ ಜೊ಼ರ ವದ್ರಿನ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ತೆ ಯೆಸುನಾ ಪಗೊಮಾ ಪಡಿನ ಸ್ತುತಿ ಕರ‍್ಯೊ. ತೆ ಸಮಾರಯಾ ವಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ಯೆಸು ತಿನೆ ಪುಚ್ಯೊ, ತುಮೊನೆ ದಕ್ಹೆ ಜ಼ನಾವೊನೆ ಅರಾಮ ಥೈಸ್ತೊ? ಬಾಕಿನಾ ನೌ ಜ಼ನಾ ಕಿಜಾ಼ ಛೆ? ");
INSERT INTO sle_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರಾನೆ ಎ ಸಮಾರಯಾವಾಲನೆ ಛೊಡಿನ ಭಿಜಾ಼ ಕುನ್ನಜ಼ ಐಯುನತ್ತಿಸು? ಕೈನ ಪುಚ್ಯೊ಼. ");
INSERT INTO sle_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ಪಾಚಲ್ತೊ ಯೆಸು ತಿನೆ\"ಉಟ್ಟ! ಹಮ್ನಾ ತು ಘರೆ ಜಾ಼! ತು ಬರೊಕ್ಹೊ ಕರಲ ಹುತಿಜ಼ ತುನೆ ಅರಾಮ ಥಯೊಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ಫರಿಸಾಯರೊಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ ಯೆಸುನೆ, ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಕೆಳಾಮಾ ಆವಸ? ಕೈನ ಪುಚ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ \"ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಆವಾಡಿಸ, ತೆನೈಸೊ ತುಮಾರಾ ಡೊಳೆ ದಿಕ್ಹೆಲಿಂಗತ ಆತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","\"ದೆಕೊ, ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನ್ಹ್ಯಾ ಛೆ\" ದೆಕೊ ಐಜ್ಗಾ಼ ಛೆ\" ಕೈನ ಮನಕ್ಹೊ ಕಯೆಲಿಂಗತ ನತ್ತಿ. ಕ್ಹುದಾನಿ ರಾಜ್ಯ ತುಮೊಮಾ ಛೆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ಪಾಚಲ್ತೊ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ\"ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ತುಮೆ ಆಸ ಮ್ಹೆಲಲ ದಿನ್ನ ಆವಸ, ವರಿ ತುಮೆ ತೆ ದಿನ್ನ ದೆಕತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ಮನಕ್ಹೊ ತುಮೊನೆ, ಐಲೊ ಐಜ್ಗಾ಼ ಛೆ! ಕವಸ. ತುಮೆ ರ‍್ಹಯಲ ಜ಼ಗಾಜ಼ ರ‍್ಹವೊ. ತಿವ್ನಾ ವಾತೊ ಐಕೊ ನಕೊ. ವರಿ ಹುಡ್ಕೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ಕಾಕದ್ಯಾಮ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಥಯಲ ಮಿ, ಆತಾಮಾ ತುಮೊನೆ ಗ್ವತ್ತ ಥಾವಸ. ಹಬಾಳಮಾತೊ ಉಜಾಲಾನ ವರಿ ಬಿಜ್ಲಿನಾ ರುಪಮಾ ತೆ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ತೆನೈಸೊ ಪೈಲಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಘನ್ನು ಕಷ್ಟ ಖೈನ ಎ ಕಾಲನಾ ಮನಕ್ಹೊ ತಿನೆ ಠುಕ್ಕರಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಫರಿನ ಆವಾನಾ ಟೈಮ್ಮಾ ಎ ಜಗತ್ನಿ ಸ್ತಿತಿ ನೊಹಾನಾ ಕಾಲ್ಮಾ ಥಯಲ ಸ್ತಿತಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ನೊಹಾನಾ ಕಾಲ್ಮಾ ಹರಿ ಯಕ್ಲೊ ಖಾತಾ ಪಿತಾ, ಹಿವಾ ಕರಲೆತಾ ಹಿವಾ ಕರಾತಾ ವ್ಹಾತಾ. ನೊಹಾ ಹಡಗಾಮಾ ಗಯಲ ಟೈಮ್ಮಾ ತೆ ಮನಕ್ಹೊ ತಿಮ್ಮಜ಼ ಕರತಾತಾ. ತೆಳಾಮಾ ಘನ್ನು ಪಾನಿ ಥೈನ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಮರಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ಲೊಟಾನಾ ಕಾಲ್ಮಾ ಕ್ಹುದಾ ಸೊದೊಮನ ದೆಶ ಕಿಮ ನಾಶ ಥೈಯುತು ತಿಮ್ಮಜ಼ ಥಾವಸ. ತೆ ಮನಕ್ಹೊ ಖಾತಾ, ಪಿತಾ, ವ್ಯಾಪಾರ ಕರತಾ ವರಿ ತ್ಯುನೆ ರ‍್ಹವಾ ಹುತಿ ಮ್ಹೊಟಾ-ಮ್ಹೊಟಾ ಘರೊ ಭಾಂದಿಲೆತಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ಲೊಟಾ, ಸದೊಮ ಗಾಮ ಛೊಡಿನ ಜಾ಼ತಾಮಾ ತ್ಯಾನಾ ಮನಕ್ಹೊ ತಿಮ್ಮಜ಼ ಕರಾಡಾತಾ. ತೆಳಾಮಾ ಹಬಾಳಮಾತಾ ಆಗನಾ ಮಂಗಾಳಾ ಪಡಿನ ತ್ಯುನೆ ಕ್ಹಾರಾ ಮರಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಫರಿನ ಆತಾಮಾ ಜಗತ್ನಿ ಸ್ತಿತಿ ಇಮ್ಮಜ಼ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ತೆ ದಿನೊಮಾ ಅಂಟಾಪರ ರ‍್ಹಯಲವಾಲೊ ಹೆಟೊ ಉತ್ರಿನ ತಿನಾ ಘರಮಾನು ಲಾವಾನೆ ಜೌ಼ ನೈಸೊ ನ್ಹಾಟಿ ಜಾ಼ವಾದೆ ");
INSERT INTO sle_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ಲೊಟಾನಿ ಬೈಕೊನಾ ಕ್ಹಾತೆ ಥಯಲ ಶೆ ಛೆಸು. ");
INSERT INTO sle_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ತಿನೊ ಜ಼ಲಮ ವಚಾ಼ಡಿಲಿವಾಲೊ ತಿನೊ ಜ಼ಲಮ ಜ಼ವೈಲಿವಸ, ವರಿ ತಿನೊ ಜ಼ಲಮ ದಿವಾಲೊ ತಿನೊ ಜ಼ಲಮ ವಚಾ಼ಡಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ಮಿ ಆತಾಮಾ ಯಕ್ಕ ಘರಮಾ ಬೆ ಜ಼ನಾ ಕ್ಹುರಯಲ ರ‍್ಹಯಾಮ ಯಕ್ಲಾನೆ ಲಿನಂಜಾ಼ವುಸ ಯಕ್ಲಾನೆ ಛೊಡಿನ ಜೌ಼ಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ಬೆಜ಼ನಿಯೊ ಹೆಣ ಮನಕ್ಹೊ ಕಾಮ ಕರತಿಯೊ ರ‍್ಹತಾಮ ಯಕ್ಕಲಿನ ಲಿನಂಜಾ಼ವುಸ ಯಕ್ಕಲಿನ ಛೊಡಿನ ಜೌ಼ಸ. ");
INSERT INTO sle_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ಶಿಷ್ಯಾ ಯೆಸುನೆ \"ಪ್ರಭು, ಎ ಕ್ಹಾರು ಕಿಜಾ಼ ಥಾವಸ? ಕೈನ ಪುಚ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ, ಹದ್ದೊ ಮಳಿನ ಕಿ ಆಯಲ ರ‍್ಹವಸ ತ್ಯಾ ಮುರದಾ ರ‍್ಹಯಲ ರ‍್ಹವಸಜ಼ ಕೈನ ಮನಕ್ಹೊ ತಿಳದಿಲಿವಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ನಿರಾಶ ಥಯಾವಾಚಿ ಕೆಳಾಮಾಬಿ ಪ್ರಾಥನಾ ಕರು ಕೈನ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಯಕ್ಕ ಸಾಮ್ಯ ಲಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ಯಕ್ಕ ಗಾಮಾ ಯಕ್ಕ ನ್ಯಾಯಾ ಕರಾಲೊ ವ್ಹತ್ತೊ. ತಿನೆ ಕ್ಹುದಾನೊ ಭೆ ನ್ಹೊತೊ ವರಿ ಮನಕ್ಹೊ ತಿನಾ ಹುತಿ ಸು ಬೊಲಸ ಕೈನ ತೆ ವಿಚಾರ ಕರತೊ ನ್ಹೊತೊ ");
INSERT INTO sle_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ತೆಜ಼ ಗಾಮ್ಮಾ ಯಕ್ಕ ರಾಂಡಿ ಬಾಕ್ಡಿ ವ್ಹತ್ತಿ, ತೆ ಬಾಕ್ಡಿ ಘನ್ನಿ ಸಲಾ ನ್ಯಾಯಾ ಕರಾಲಾಕನ ಐನ, ನ್ಹ್ಯಾ ಯಕ್ಲೊ ಮನೆ ಘನ್ನೊ ತರಾಸ ಕರಸ. ತು ಮನೆ ಮರಗಿನ ನ್ಯಾಯ ದಿಲಾ! ಕೈನ ಮಾಂಗಿಲಿದಿ. ");
INSERT INTO sle_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ತೆನೈಸೊ ತೆ ನ್ಯಾಯಾ ಕರಾಲೊ ತೆ ಬಾಕಡಿನೆ ಧ್ಯಾನ ದಿದ್ಯೊ ನೈ. ವರಿ ದಕ್ಹಾ ದಿನ್ಪರ‍ ತೆ ನ್ಯಾಯಾ ಕರಾಲೊ ತಿನಾ ಮನಸ್ಮಾ ವಿಚಾರ ಕರಲಿದ್ಯೊ ಮಿ ಕ್ಹುದಾಕ್ಹು ಬಿ ಭುಚ್ಕೊತೊ ನೈ ವರಿ ಮನಕ್ಹೊನೆ ದಾದ ನೈ ಕರತೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ವರಿ ಆ ಬಾಕ್ಡಿ ಐನ ಮನೆ ಘನ್ನಿ ಕಿರಿ-ಕಿರಿ ಲಗಾಡಿಸ. ಇನು ಫೈಸಲೊ ಮಿ ಕರಿಪಾಡುಸ, ವರಿ ಎ ಬಾಕ್ಡಿ ಮನೆ ಕಿರಿ-ಕಿರಿ ನೈ ಕರತಿ, ನೈತೊ ಎ ಬಾಕ್ಡಿ ಮನೆ ಘನ್ನಿ ಕಿರಿ-ಕಿರಿ ಕರತಿಜ಼ ರ‍್ಹವಸ \"ಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ಯೆಸು ಎ ಸಾಮ್ಯ ಕದಲ್ಪರ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ. ಐಕೊ ತೆ ಅನ್ಯಾಯಾ ಕರಾಲೊ ನ್ಯಾಯಾದಿಪತಿ ಕದಲ ವಾತಮಾ ಮತ್ಲಬ್ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನೆ ದಿನ್ನ ರಾತ ಪ್ರಾಥನಾ ಕರು. ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ಚೊ಼ಕು ರ‍್ಹಯಲಜ಼ ಕೆಳಾಮಾಬಿ ದಿವಸ, ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನಿ ಪ್ರಾಥನಾನೆ ಭೆಗಿನಜ಼ ಜವಾಬ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ಭೆಗಿನಜ಼ ಆಸ್ರೊ ಕರಸ. ಕೈನ ತುಮೊನೆ ಕೌಸ. ತೆನೈಸೊ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಆತಾಮಾ ಜಗತ್ನಾ ಮನಕ್ಹೊಮಾ ಬರೊಕ್ಹೊ ದೆಕಸ್ಸು? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ತೆಜ಼ ಟೈಮ್ಮಾ ತ್ಯಾನಾ ಮನಕ್ಹೊ ಹಮೆಜ಼ ಚೊ಼ಕಾವೈ ಕೈನ ತಿಳದಿಲಿದ್ಯಾತಬಿ ವರಿ ಎ ಮನಕ್ಹೊ ಹಮೆ ಬಿಜಾ಼ವೊತಿಬಿ ಚೊ಼ಕಾ ವ್ಹೈ ಕೈನ ");
INSERT INTO sle_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ಯಕ್ಕ ಸಲಾ ಫರಿಸಾಯರವಾಲೊ ವರಿ ಭುಭಾಡೊಲಿವಾಲೊ ಪ್ರಾಥನಾ ಕರಾ ಹುತಿ ದೆವಾಲಯೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ತೆಳಾಮಾ ಫರಿಸಾಯರವಾಲೊ ಭು ಭಾಡೊಲಿವಾಲಾನೆ ದೆಕಿನ ದುರ ಹುಬ್ರೈನ ಅಮ್ಮ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ಕ್ಹುದಾ, ಮಿ ಬಿಜಾ಼ವೊ ಲಿಂಗತ ಭು ಭಾಡೊಲಿವಾಲೊ ನ್ಹವೈ. ಮೊಸ ಕರಾಲೊ ನ್ಹವೈ, ವೈಭಿಚಾರ ಕರಾಲೊ ನ್ಹವೈ. ತಿನಾ ಹುತಿ ಮಿ ತುನೆ ಸ್ತೊತ್ರಾ ಕೌಸ, ");
INSERT INTO sle_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ಮಿತೊ ಹಪ್ತಾಮಾ ಬೆಸಲಾ ಉಪಾಸ ಕರುಸ. ಮಿ ರಾಬಲಮಾ ದಕ್ಹ್ವಾಮಾನೊ ಯಕ್ಕ ಭಾಗ ಮಿ ತುನೆ ದ್ಯುಸ! ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ಭುಭಾಡೊ ಲಿವಾಲೊ ಯಕ್ಕಲೊಜ಼ ಹುಬ್ರೈನ. ಹಬಾಳನೆ ಡೊಳಾ ಉಚೈನ ದೆಕ್ಯಾವಾಚಿ ಛಾತಿ ಬಡೈಲೆತೊ, ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ ಡ್ವಗ್ಗಿನ, ಕ್ಹುದಾ ಮನೆ ಮರಗ ಮಿ ಪಾಪಿ ವ್ಹೈ. ಕೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ತೆ ಪ್ರಾಥನಾ ಕರಲಪರ ತೆ ಕ್ಹರಿನೊ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಥಯಲಪರ ತೆ ಘರೆ ಗಯೊ ಕೈನ ಮಿ ತುಮೊನೆ ಕೌಸ. ವರಿ ತೆ ಫರಿಸಾಯರ ಕ್ಹರಿನೊ ನ್ಹವೈ ಕೈನ ಫೈಸಲೊ ಥಯೊ. ಮಿ ವ್ಹೈಕೈನ ಕವೈಲಿವಾಲೊ ಹರಿ ಯಕ್ಲೊ ತಗ್ಗಿನ ರ‍್ಹವಾಲೊ ಥಾವಸ. ವರಿ ತಗ್ಗಿನ ರ‍್ಹವಾಲೊ ಹರಿ ಯಕ್ಲೊ ತೆ ಮಿ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ದಕ್ಹಾ ಮನಕ್ಹೊ ತಿವ್ನಾ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಯೆಸುನಾ ಹತೆ ಮುಟೌಕೈನ ತಿಕನ ಲಾಯಾ, ತೆ ತಿನಾ ಶಿಷ್ಯಾ ಐಕಿನ, ಬಚ್ಚಾ಼ವೊನೆ ಯೆಸುಕನ ಲಾವೊನಕೊ ಕೈನ ಮನಕ್ಹೊನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ಯೆಸು ತೆ ದೆಕಿನ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ತಿಕನ ಬಲೈನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ, ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಮಕನ ಆವಾನೆ ದಿವೊ, ತ್ಯುನೊನೆ ತರಬೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾನು ರಾಜ್ಯ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ವೊಲಿಂಗತ ರ‍್ಹಯಲ ವಾಲಾವೊನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಬಚ್ಚಾ಼ವೊನಾ ಮನಸ ಲಿಂಗತ ವಪ್ಪಿಲಿವು. ನೈತೊ, ತುಮೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ತಾ ನೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ಯಕ್ಲೊ ಯಹುದ್ಯೊನೊ ನಾಯಕ ಯೆಸುನೆ \"ಚೊ಼ಕಿಯೊ ವಾತೊ ಕವಾಲಾ, ಹಮೆಶಾನೊ ಜ಼ಲಮ ಮಳು ಕದ್ಯಾಮ ಮಿ ಸು ಕರು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ಯೆಸು ತಿನೆ\"ಮನೆ ಚೊ಼ಕೊ ವ್ಹೈ ಕೈನ ಕಾ ಕವಾಡ್ಯೊಸ? ಕ್ಹುದಾ ಯಕ್ಕಲೊಜ಼ ಚೊ಼ಕೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ಕ್ಹುದಾನಿಯೊ ಆಗನ್ಯಾ ತುನೆ ಗ್ವತ್ತ ಛೆ ಸು; ತು ವ್ಯಭಿಚಾರ ಕರು ನೈ, ಕಿನೆಬಿ ಖಲಾಸ ಕರು ನೈ, ಸುಜ಼ ಚೊ಼ರಿ ಕರು ನೈ, ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಹುತಿ ಸುಳ್ಳ ಕೌ ನೈ, ತಾರಾ ಮಾ ಬಾಪನೆ ಮರ್ಯಾದಿ ದ್ಯು. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ತಿಮ್ಮ ಕತಾಮಾ ತೆ ಮನಕ್ಹ ಮಿ ನ್ಹಾನ್ಪಂತೊ ಎ ಕ್ಹಾರು ಕರತೊ ಆಯೊಸ, ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ\"ತು ಕರಾನು ಕಾಮ ಬಿಜೆಕ ಛೆ. ತಾರಿ ಆಸ್ತಿ ಇಕ್ಕಿನ ಆಯಲ ದೊಕ್ಡಾ ಗರಿಬೊನೆ ದೆ. ತೆಳಾಮಾ ತುನೆ ಸ್ವರ್ಗಮಾ ಇನೊ ಪ್ರತಿಫಲ ಮಳಸ. ತು ಮಾರಾ ಪಾಚೊ಼ ಆ\" ");
INSERT INTO sle_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ಯೆಸುನಿಯೊ ವಾತೊ ತೆ ಮನಕ್ಹ ಐಕ್ತಾಮಾ ಘನ್ನೊ ಬೆಜ್ಯಾರ ಥಯೊ ಕಾಕದ್ಯಾಮ ತೆ ಮನಕ್ಹ ಘನ್ನೊ ಸೌಕಾರ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ತೆಳಾಮಾ ಯೆಸು ತಿನೆಜ಼ ದೆಕಿನ, ಸೌಕಾರ ರ‍್ಹಯಲವಾಲಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ವಾನು ಘನ್ನು ಕಷ್ಟ ಛೆ! ");
INSERT INTO sle_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ಸೌಕರ ರ‍್ಹಯಲವಾಲೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಜಾ಼ವಾನು ಕೆಕ್ಲು ಕಷ್ಟ ಛೆ ಕದ್ಯಾಮ ಕ್ಹ್ವಯಿನಾ ಡೊಳಾಮಾತು ಹುಂಟ ಜಾ಼ವಾನು ಆಸಾನ ವ್ಹೈ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ಮನಕ್ಹೊ ಯೆಸುನಾ ವಾತೊ ಐಕಿನ\"ತಿಮ್ಮ ಕದ್ಯಾಮ ರಕ್ಷಣೆ ಕಿನೆ ಥಾವಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ಯೆಸು ತ್ಯುನೊನೆ\"ಮನಕ್ಹನೆ ನೈ ಥಾವಾನಾ ಕಾಮೊ ಕ್ಹುದಾ ಕರಸ\" ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ಪೆತ್ರಾ\"ದೆಕ ಹಮೆ ಹಮಾರಾ ಘರೊನೆ ಛೊಡಿನ ತಾರ ಪಾಚಾ಼ ಆಯಾಸತೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ತೆ ವಾತೆ ಯೆಸು\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಕ್ಹುದಾನಾ ರಾಜ್ಯನಾ ಹುತಿ ಕುನ್ನ ತಿನು ಘರ, ಬೈಕೊ, ಬಚ್ಚಾ, ಭಾಯೊ-ಭೆನೊ ವರಿ ತಿನಾ ಯಾ ಬಾ ನೆ ಛೊಡಲವಾಲೊ ತೆ ಛೊಡ್ಯಲತಿಬಿ ತಿನೆ ಜಾಸ್ತ ಮಳಸ. ಅಗಾ ಆವಾನಾ ದಿನ್ನೊಮಾ ಹಮೆಶಾನು ಜ಼ಲಮ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ತೆ ತಿನಾ ಜಿಂದಗಿಮಾ ತಿತಿಬಿ ತಿನೆ ಹೆಚ್ಕಿ ಮಳಸ ವರಿ ತಿನಾ ಅಗ್ಲಿ ದುನಿಯಾಮಾ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಹಮೆಶಾ ಜಿವ್ತೊ ರ‍್ಹವಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತಿನಾ ಬಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊನೆ ಬಲೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ. ಐಕೊ! ಮಿ ಹಮ್ನಾ ಯೆರುಸಲೆಮೆ ಚಾ಼ಲ್ಯೊಸ. ಕ್ಹುದಾ ತಿನಾ ಪ್ರವಾದಿ ಕಂತೊ ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ಹುತಿ ಬರದಾಯಲ ಹರಿಯಕ್ಕ ಸಂಗತಿ ಪುರಾ ಥಾವಸ! ");
INSERT INTO sle_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ತೆ ಮನಕ್ಹ ತಿನಾ ವಿರುದ್ಧ ಉಟಿನ ಯೆಹುದಿ ನೈ ರ‍್ಹಯಲ ವಾಲಾವೊಕನ ಕ್ಹಾಪ್ಡಸ. ತ್ಯುನೆ ತಿನೆ ಕದರೈನ, ತಿನಾ ಮ್ಹೊಡಪರ ಥುಕ್ಕಕಸ, ತಿನೆ ಅಸಯ್ಯ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ತ್ಯುನೆ ತಿನೆ ಬಾರಕೊಲ ಕ್ಹು ಮಾರಸ ವರಿ ತಿನೆ ಖಲಾಸ ಕರಿಪಾಡಸ! ತೆನೈಸೊ ತೆ ತನ್ನ ದಿನ್ನ ಥಯಲ್ಪರ ವರಿ ಉಟಿನ ಆವಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ಅಪೊಸ್ತಲೊ ಆ ವಾತ ತಿಳದಿಲಿವಾನೆ ಕೊಶಿಶ ಕರ‍್ಯಾ ತಬಿ ತಿವ್ನೊಕನ ಥೈಯು ನೈ, ಕಾಕದ್ಯಾಮ ತಿನು ಮತ್ಲಬ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ಯೆಸು ಯೆರಿಕೊ ಗಾಮನಾ ಕ್ಹಾಮೊ ಜಾ಼ತಾಮಾ, ತೆ ವಾಟೆ ಯಕ್ಕ ಕುಡ್ಡೊ ಭಿಕ ಮಾಂಗತೊ ಬೈಟ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ತೆ ವಾಟಮಾ ಮನಕ್ಹೊನಿ ಘನ್ನಿ ಆವಾಜ಼ ಐಕಿನ ತೆ ಕುಡ್ಡೊ\"ನ್ಹ್ಯಾ ಸು ಥಾವಾಡ್ಯುಸ? ಕೈನ ಪುಚ್ಚೊ಼. ");
INSERT INTO sle_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ಮನಕ್ಹೊ ತಿನೆ \"ನಜ಼ರೆತನೊ ಯೆಸು ಆವಾಡ್ಯೊಸ\" ಕೈನ ತಿಳಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ತೆ ಕುಡ್ಡೊ ಜೊ಼ರ ಆವಾಜ಼ ಕ್ಹು\"ಯೆಸು, ದಾವಿದನಾ ದಿಕ್ರಾ ಮರಗಿನ ಮನೆ ಮದದ ಕರ! ಕೈನ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ಮನಕ್ಹೊನು ಗುಂಪ ತೆ ಕುಡ್ಡಾನೆ ಭುಚ್ಕಾಡ್ಯಾ. ತಿನೆ ಬೊಲು ನಕೊ ಕೈನ ಕದ್ಯಾ. ತೆನೈಸೊ ತೆ ಕುಡ್ಡೊ ವರಿ ಜೊ಼ರ ಆವಾಜ಼ ಕ್ಹು \"ದಾವಿದನಾ ದಿಕ್ರಾ, ಮರಗಿನ ಮನೆ ಮದದ ಕರ\" ಕೈನ ಅಡ್ಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ಯೆಸು ತ್ಯಾಜ ಹುಬ್ರೈನ\"ತೆ ಕುಡ್ಡಾನೆ ಮಕನ ಬಲೈನ ಲಾವೊ\" ಕೈನ ಕದ್ಯೊ. ತೆ ಕುಡ್ಡೊ ಕ್ಹಾಮೊ ಆಯೊ, ಯೆಸು ತಿನೆ \"ಮಿ ತುನೆ ಸು ಕರು ಕೈನ ತು ಕಶಿ? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ತೆಳಾಮಾ ತೆ ಕುಡ್ಡೊ \"ಪ್ರಭು, ಮಾರಾ ಡೊಲಾ ವರಿ ದಿಕ್ಹಾ ವರಕ್ಹಾ ಕರ ಬಾ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ಯೆಸು ತಿನೆ\"ತು ನಂಬಲಕ್ಹು ತುನೆ ಅರಾಮ ಥೈಯುಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ತೆಳಾಮಾಜ಼ ತೆ ಕುಡ್ಡಾನೆ ಪುರಾ ದಿಕ್ಹಾಡು. ತೆ ಕುಡ್ಡೊ ಕ್ಹುದಾನೆ ಸೊತ್ರಾ ಕತೊ ಯೆಸುನಾ ಪಾಚೊ಼ ಗಯೊ. ಆ ಕ್ಹಾರು ದೆಕಿನ ಮನಕ್ಹೊ ಕ್ಹುದಾನೆ ಸೊತ್ರಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ಯೆಸು ಯೆರಿಕೊ ಗಾಮ ಕಂತೊ ಚಾ಼ಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ತೆ ಗಾಮ್ಮಾ ಜಕ್ಕಾಯಾ ಕವಾಲೊ ಯಕ್ಕ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ತೆ ಮನಕ್ಹ ಸೌಕಾರ ವ್ಹತ್ತೊ. ವರಿ ತೆ ಭು ಭಾಡೊ ಲಿವಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ತೆ ಯೆಸುನೆ ದೆಕು ಕೈನ ಘನ್ನು ಮನಸ ವ್ಹತ್ತು. ವರಿ ತ್ಯಾ ಯೆಸುನೆ ದೆಕು ಕೈನ ಘನ್ನಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ಜಕ್ಕಕಾಯಾ ಘನ್ನೊ ಗಿಡ್ಡೊ ವ್ಹತ್ತೊ ತಿನಾ ಹುತಿ ಮನಕ್ಹೊ ಯೆಸುನಾ ಸುತ್ತೆ ಹುಬ್ರಯಲ ಹುತಿ. ಜಕ್ಕಾಯಾನೆ ಯೆಸುನೆ ದೆಕಾನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ತಿನಾಹುತಿ ಜಕ್ಕಾಯಾ ಯೆಸು ಬಿಜಿ ಜ಼ಗಾ ಜಾ಼ವಾನು ಐಕಿನ ತೆ ಜ಼ಗಾಪರ ತಿತ್ತಿ ಅಗ್ದುರಜ಼ ಯಕ್ಕ ಪಿಪ್ಳಾನಾ ಝಾಡಪರ ಚ಼ಡಿನ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ಯೆಸು ತೆ ಜ಼ಗಾಪರ ಆತಾಮಾ ಝಾಡಪರ ಚ಼ಡಿನ ಬೈಟಲ ಜಕ್ಕಕಾಯಾನೆ ದೆಕಿನ ಕದ್ಯೊ. ಜಕ್ಕಕಾಯಾ ತು ಭೆಗಿನ ಹೆಟೊ ಉತ್ರಿನ ಆ\"ಆಜ಼ನಾ ದಿನ್ನೆ ತಾರಾ ಘರೆ ಔಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ತೆಳಾಮಾ ಜಕ್ಕಾಯಾ ಝಾಡಪರತೊ ಹೆಟೊ ಉತ್ರಿನ ಐನ ಯೆಸುನೆ ಖುಶಿಕ್ಹು ಘರೆ ಬಲೈಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ಮನಕ್ಹೊ ಎ ಕ್ಹಾರು ದೆಕಿನ ಯೆಸು ಜಕ್ಕಕಾಯಾ ಯಕ್ಕ ಪಾಪಿ ವ್ಹೈ ತೆ ತಿನಾ ಘರೆ ಕಾ ಜಾ಼ತೊ ವಸೆ ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ತೆಳಾಮಾ ಜಕ್ಕಾಯಾ ಉಟಿನ ಹುಬ್ರೈನ ಯೆಸುನೆ ಪ್ರಭು ಮಿ ಮಾರಿ ಆಸ್ತಿಮಾನೊ ಹೆಚ್ಕಿ ವಾಟೊ ಗರಿಬೊನೆ ದ್ಯುಸ. ವರಿ ಕಿಕಂತು ಬಿ ಮೊಸ ಕ್ಹು ಲಿದಲ ರ‍್ಹಯೊಮ ತಿನೆ ಚಾರ ಯಕ್ಲು ಹೆಚ್ಕಿ ದ್ಯುಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ಯೆಸು ಕದ್ಯೊ ಆಜ಼ ಆ ಘರ ಉದ್ದಾರ ಥಯು, ಕಾಕದ್ಯಾಮ ಎ ಮನಕ್ಹ ಬಿ ಅಬ್ರಹಾಮನಾ ಖಾಂದಾನ ವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ತಿನಾಹುತಿ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಜ಼ವೈ ಗಯಲ ಮನಕ್ಹೊನೆ ಹುಡಕಿನ ರಕ್ಷಣೆ ದಿವಾನೆ ಆಯೊಸ, ");
INSERT INTO sle_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ಯೆಸು ಯೆರುಸಲೆಮಿನಾ ನಜಿಕ ಆಯೊ. ದಕ್ಹಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನಜಿಕ ಐಸ ಕೈನ ತಿಳದಿಲಿದ್ಯಾತಾ. ಎ ವಿಚಾರ ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯುತು. ತಿನಾ ಹುತಿ ತ್ಯುನೊಕನ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ಯಕ್ಲೊ ಚಾ಼ಯೆ ಥಯಲ ವಾಲೊ ಘನ್ನೊ ರಾಜ್ಯಾಧಿಕಾರ ಮಳಾನಾ ಹುತಿ ಬಿಜಾ಼ ದೆಶೆ ಗಯೊ. ವರಿ ರಾಜ್ಯಾಧಿಕಾರ ಮಳಲಪರ ಫರಿನ ಐನ ತಿನಾ ಮನಕ್ಹೊಪರ ಆಳು ಕೈನ ತಿನಿ ಆಸ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ತಿನಾಹುತಿ ತಿನಾ ದಕ್ಹ ಆಳೊನೆ ಬಲೈನ ತ್ಯುನೊಮಾನಾ ಹರ ಯಕ್ಲಾನೆ ಕ್ಹೊನಾನಾ ಹಜಾ಼ರ-ಹಜಾ಼ರ ಬಿಲ್ಲಾ ದಿನ್ನ, ಮಿ ಫರಿನ ಆಯೆಲಕ್ಕಾ ಯೆ ದೊಕ್ಡಾ ಕ್ಹು ಸುಬಿ ವ್ಯಾಪಾರ ಕರೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ತೆನೈಸೊ ತಿನಾ ಸ್ವಂತ ದೆಶನಾ ಮನಕ್ಹೊ ತಿಪರ ಶಿಟ್ಟ ರ‍್ಹಯಲ ಹುತಿ, ಮನಕ್ಹೊನು ಯಕ್ಕ ಗುಂಪನೆ ತಿನಾ ಪಾಚಾ಼ ಮೊಕ್ಕಲ್ಯಾ. ತೆ ಗುಂಪನಾ ಮನಕ್ಹೊ ಭಾರಲ್ಯಾ ದೆಶಮಾ ಎ ಮನಕ್ಹ ಹಮೊಪರ ರಾಜೊ಼ ಥಾವಾನೆ ಹಮೊನೆ ಮನಸ ನತ್ತಿ. ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ತಿಮ್ಮ ರ‍್ಹಯು ತಬಿ ತೆ ಮನಕ್ಹ ರಾಜೊ಼ ಥಯೊ. ವರಿ ತೆ ತಿನಾ ದೆಶೆ ಫರಿನ ಆತಾಮಾ, ತಿನಾ ಕ್ಹೊನಾನಾ ಬಿಲ್ಲಾ ಲಿದಲ ವಾಲಾವೊನೆ ಬಲೈನ ತ್ಯುನೆ ತೆ ದೊಕ್ಡಾ ಕ್ಹು ಕೆಕ್ಕಲಾ ರಾಬ್ಯಾಸ ಕೈನ ಮಿ ದೆಕು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ತಿಮಾನೊ ಯಕ್ಲೊ ಆಳ ಐನ ಸ್ವಾಮಿ ತಾರಾ ಯಕ್ಕ ಹಜಾ಼ರ ರುಪ್ಯಾಯಾ ಕ್ಹು ದಕ್ಹ ಹಜಾ಼ರ ರಾಬ್ಯೊಸ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ರಾಜೊ಼ ತೆ ಆಳನೆ ತು ಚೊ಼ಕು ಕಾಮ ಕರ‍್ಯೊಸ ಶಬಾಶ ಕದ್ಯೊ. ಎ ನ್ಹಾನು ಕಾಮ ದಿದಲ ತು ಚೊ಼ಕಿ ತರಾ ಕರ‍್ಯೊಸ ತಿನಾ ಹುತಿ ಮಿ ತುಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲುಸ ಕದ್ಯೊ. ಮಿ ತುನೆ ದಕ್ಹ ಗಾಮೊ ಪರ ಅದಿಕಾರಿ ಕರುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","\"ಬೆವಾ ಆಳ ಐನ ಸ್ವಾಮಿ, ತು ದಿದಲ ಯಕ್ಕ ಹಜಾ಼ರ ರುಪಿಯ್ಯಾ ಕ್ಹು ಪಾಂಚ಼ ಹಜಾ಼ರ ಕಮಾಯೊಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ರಾಜೊ಼ ತೆ ಆಳನೆ ಕದ್ಯೊ. ತುನೆ ಪಾಂಚ಼ ಗಾಮೊಪರ ಅದಿಕಾರ ದ್ಯುಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ಪಾಚಲ್ತೊ ಬಿಜೆಕ್ಲೊ ಆಳ ಐನ ರಾಜಾ಼ನೆ ಕದ್ಯೊ. ಎ ಸ್ವಾಮಿ ತು ದಿದಲ ಯಕ್ಕ ಹಜಾ಼ರ ರುಪಿಯಾ ನ್ಹ್ಯಾಜ಼ ಛೆ ");
INSERT INTO sle_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ಕಾಕದ್ಯಾಮ ತು ಘನ್ನೊ ಶಿಟ್ಟನೊ ಮನಕ್ಹ ವ್ಹೈ ತಿನಾ ಹುತಿ ಮಿ ಭುಚ಼ಕ್ಕಯೊ. ತು ತಾರು ನೈರ‍್ಹಯುತಬಿ ತು ಕಾಡಿಲೆಸಿ ವರಿ ತು ನೈ ಬಿತ್ತಲ ರ‍್ಹಯುತಬಿ ತು ತೆ ಬೆಳಿ ಕಾಟಿಲೆಸಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ತೆಳಾಮಾ ತೆ ರಾಜೊ಼ ತೆ ಆಳನೆ, ಕದ್ಯೊ ತು ಕೆಟ್ಟ ಆಳ ವ್ಹೈ! ತು ಕದಲ ವಾತೊ ಕ್ಹುಜ಼ ತಾರಿ ಫೈಸಲೊ ಕರುಸ, ಮನೆ ತು ಘನ್ನೊ ಶಿಟ್ಟನೊ ಮನಕ್ಹ ವ್ಹೈ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ತೆ ಕ್ಹರಿ ರ‍್ಹಯು ಕದ್ಯಾಮ, ತು ಮಾರಾ ರುಪಿಯಾ ಬಡ್ಡಿಕ್ಹು ದಿವಾನು ವ್ಹತ್ತು. ಮಿ ಫರಿನ ಆತಾಮಾ ಮನೆ ದಕ್ಹಿ ಬಡ್ಡಿತಬಿ ಮಳ್ತಿತಿ ತೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ತೆಳಾಮಾ ರಾಜೊ಼ ತ್ಯಾ ಹುಬ್ರಯಲ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ ಆ ಆಳಕನ್ನಾ ಹಜಾ಼ರ ರುಪಿಯಾ ಕಾಳ್ಳಿನ ದಕ್ಹ ಹಜಾ಼ರ ರುಪಿಯಾ ಕಮಾಯಲ ವಾಲಾನೆ ದಿವೊ, ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ತೆ ಮನಕ್ಹೊ ರಾಜಾ಼ನೆ ಕದ್ಯಾ, ಸ್ವಾಮಿ ತೆ ಆಳಕನ ಹಮ್ನಾಜ಼ ದಕ್ಹ ಹಜಾ಼ರ ರುಪಿಯಾ ಛೆತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ರಾಜೊ಼ ಕದ್ಯೊ, ಮಿ ತುಮೊನೆ ಕೌಸ ಹರಿ ಯಕ್ಕ ಮನಕ್ಹ ಕನ ದಕ್ಹು ರ‍್ಹಯಲ ವಾಲಾಕಂತು ಹಜು಼ನ ದಿವಸ ನೈರ‍್ಹಯಲವಾಲಾ ಕಂತು ರ‍್ಹಯಲ ಬಿ ಕಾಳ್ಳಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ವರಿ ಮಾರಾ ದುಶ್ಮನೊ ಮಿ ರ‍್ಹವಾನು ತ್ಯುನೊನೆ ಮನಸೆ ನತ್ತಿ ವರಿ ತ್ಯುನೊನೆ ಧರ್ಲಿನ ಆವೊ ಮಾರಾ ಕ್ಹಾಮಾ ತ್ಯುನೊನೆ ಖಲಾಸ ಕರಿ ಪಾಡೊ\" ");
INSERT INTO sle_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ಯೆಸು ಎ ಕ್ಹಾರು ಕದಲ್ಪರ ಯೆರುಸೆಲೆಮೆ ಚಾ಼ಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ಯೆಸು ಬೆತ್ಪೆ ವರಿ ಬೆಥಾನಿಯಾ ಕವಾನಾ ಗಾಮೊನಾ ನಜಿ಼ಕ ಆಯೊ. ತೆ ಗಾಮೊಮಾ ತೆಲನಾ ಝಾಡೊನು ಡೊಂಗರ ವ್ಹತ್ತು. ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆ ಜ಼ನಾವೊನ ಬಲೈನ ತ್ಯುನೊನೆ, ");
INSERT INTO sle_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ಐಜ್ಗಾ಼ ದಿಕ್ಹಾನಾ ಗಾಮೆ ಜಾ಼ವೊ. ತುಮೆ ಗಾಮ್ಮಾ ಜಾ಼ತಾಮಾ ತ್ಯಾ ಯಕ್ಕ ಗದಡು ಭಾಂದಲ ದೆಕೊಸಿ ತಿಪರ ಹಜು಼ನ ಲಕ್ಕಾಬಿ ಕುನ್ನಜ಼ ಬೈಟ್ಯು ನತ್ತಿ, ತೆ ಗದಡಾನೆ ಛೊಡಿನ ಮಕನ ಲಿನ ಆವೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ಕಯಾಬಿ ಮನಕ್ಹೊ ತುಮೊನೆ ಆ ಗದಡಾನೆ ಛೊಡಿಲಿನ ಕಿಜ್ಗಾ಼ ಲಿನಚಾ಼ಲ್ಯಾಸ ಕೈನ ಪುಚ್ಯಾ಼ಮ ಗುರುನೆ ಆ ಗದಡು ಚಾ಼ಯೆ ಥಯುಸ ಕೈನ ಕವೊ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ತೆಳಾಮಾ ತೆ ಶಿಷ್ಯಾ ಗಾಮ್ಮಾ ಗೈನ ಯೆಸು ಕದಲ ತಿಮ್ಮಜ಼ ತ್ಯುನೆ ಗದಡಾನೆ ದೆಕಿನ ತಿನೆ ಛೊಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ತೆಳಾಮಾ ಗದಡಾನೊ ಮಾಲಕ ಐನ ತೆ ಶಿಷ್ಯಾವೊನೆ ತುಮೆ ಅಮ್ಮ ಕಾ ಕರಾಡಾಸ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ಶಿಷ್ಯಾ ತಿನೆ ಆ ಗುರುನೆ ಚಾ಼ಯೆ ಥಯುಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ಶಿಷ್ಯಾ ತೆ ಗದಡಾನಾ ಬಚ್ಚಾ಼ನೆ ಯೆಸುನಾ ಕ್ಹಾಮಾ ಲಾಯಾ. ಶಿಷ್ಯಾ ತಿವ್ನಾ ವಣ್ಣಾ ಕಾಡಿನ ಗದಡಾಪರ ಘಾಲ್ಯಾ. ವರಿ ಯೆಸುನೆ ತಿಪರ ಬೈಟಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ತೆಳಾಮಾ ಯೆಸು ಯೆರುಸೆಲೆಮೆ ಚಾ಼ಲ್ಯೊ. ತ್ಯಾನಾ ಮನಕ್ಹೊ ತಿವ್ನಾ ವಣ್ಣಾ ಯೆಸು ಜಾ಼ವಾನಿ ವಾಟ್ಪರ ವಚ್ಚಾ಼ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ಯೆಸು ಯೆರುಸೆಲೆಮನಾ ನಜಿ಼ಕ ಐನ ತೆಲನಾ ಝಾಡನಾ ಡೊಂಗರಕನ ಆಯಾ. ತಿನಾ ಪಾಚಾ಼ ಶಿಷ್ಯಾಬಿ ಆಯಾ ವರಿ ಘನ್ನಾ ಮನಕ್ಹೊಬಿ ವ್ಹತ್ತಾ. ವರಿ ತ್ಯುನೆ ಕ್ಹಾರಾ ಕ್ಹುದಾ ಕರಲ ಕ್ಹಾರಾ ಅಧ್ಭುತ ದೆಕಿನ ಖುಶಿ ಕರತಾ ವರಿ ಸ್ತೊತ್ರಾ ಕತಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ಕ್ಹುದಾನಾ ನಾಮಪರ ಆವಾಲಾ ರಾಜಾ಼ನೆ ಆಶಿರ್ವಾದ ಥಾವಾದೆ ಸ್ವರ್ಗಮಾ ಸಮಾಧಾನ ಥಾವಾದೆ ಕ್ಹುದಾನಿ ಮಹಿಮಾ ಥಾವಾದೆ \"ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ಫರಿಸಾಯರೊಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ, ಯೆಸುನೆ ಭೊದಕ, ಇಮ್ಮ ಕ್ಹಾರು ಕೌ ನಕೊ ಕೈನ ತಾರಾ ಶಿಷ್ಯಾವೊನೆ ಕೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ವರಿ ತೆ ವಾತೆ ಯೆಸು ತ್ಯುನೊನೆ \"ಇವ್ನೆ ಎ ಕ್ಹಾರು ಕೌಜ಼ ಇವ್ನೆ ನೈ ಕದ್ಯಾಮ, ತಿವ್ನಾ ಬದಲ ಆ ಮಂಗಾಳಾ ಬೊಲಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ಯೆಸು ಯೆರುಸೆಲೆಮಕನ ಆತಾಮಾ ತೆ ಗಾಮನೆ ದೆಕಿನ ರೊಯೊ ");
INSERT INTO sle_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ವರಿ ಅಮ್ಮ ಕದ್ಯೊ \"ಯೆರುಸಲೆಮ ತುನೆ ಶಾಕ್ಹು ಸಮಾಧಾನ ಥಾವಸ ಕೈನ ತು ತಿಳದಿಲಿವತ್ತೊ ಕೆಕ್ಕಲು ಕೆ ಚೊ಼ಕು ವ್ಹತ್ತು! ವರಿ ತು ತಿಳದಿಲಿದ್ಯೊ ನೈ ಕಾಕದ್ಯಾಮ ಹಮ್ನಾ ತೆ ಝಕೈ ಗಯುಸ. ");
INSERT INTO sle_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ಕಾಕದ್ಯಾಮ ಯಕ್ಕ ಟೈಮ ಆವಸ ತಾರಾ ದುಶ್ಮನೊ ತಾರಾ ಸುತ್ತೆ ಗೊಡಿಯೊ ಭಾಂದಿನ ವರಿ ತಾರಾ ಸುತ್ತೆ ಬಿ ಚಾವಿಯೊ ಘಾಲಿ ಪಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ತುನೆ ಬಿ ತಾರಾ ಮನಕ್ಹೊನೆ ಬಿ ನಾಶ ಕರಸ ನ್ಯ್ಹಾ ದಗ್ಡಾಪರ ದಗ್ಡೊ ನೈ ಹುಬ್ರಾಡತಾ, ಕ್ಹುದಾ ತುನೆ ವಚಾ಼ಡಾನೆ ಆಯಲ ಟೈಮಾ ತು ನೈ ತಿಳದಿ ಲಿದ್ಯೊಮ ಎ ಕ್ಹಾರು ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ಯೆಸು ದೆವಾಲಯಮಾ ಗೈನ, ತ್ಯಾ ಇಕ್ಕಾನೆ ಬೈಟಲ ವಾಲಾವೊನೆ ಭಾರೊ ಘಾಲಿ ಪಾಡಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ತ್ಯುನೊನೆ, ಯೆಸು ಕ್ಹುದಾ ಕವಸ \"ಮಾರು ಯಕ್ಕ ಘರ ಪ್ರಾಥನಾನು ಘರ ಕವೈ ಲಿವಸ ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆತೊ. ತುಮೆ ತಿನೆ ಚ್ವಟ್ಟಾವೊನು ಘರ ಕರಿಪಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ಯೆಸು ದಿನ್ನೆ ಬಿ ಮಂದಿರಮಾ ಉಪದೆಶ ಕರಾನು ಚಾಲು ಕರ‍್ಯೊ ತಿನಾಹುತಿ ತ್ಯಾನಾ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ವರಿ ಮನಕ್ಹೊಪರ ಮ್ಹೊಟಾ ರ‍್ಹಯಲ ವಾಲಾ ಯೆಸುನೆ ಖಲಾಸ ಕರು ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ತೆನೈಸೊ ಯೆಸುನಿಯೊ ವಾತೊ ಯಕ್ಕ ಛೊಡ್ಯಾವಾಚಿ ಘನ್ನಿ ಧ್ಯಾನ ದಿನ್ನ ಮನಕ್ಹೊ ಐಕಾಡ್ಯಾತಾ. ವರಿ ತಿನಾ ಲಿಂಗತಜ಼ ಚಾ಼ಲಾಡ್ಯಾತಾ ತಿನಾ ಹುತಿ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಕಿಮ ಖಲಾಸ ಕರಿಯೆ ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ಯಕ್ಕ ದಿನ್ನ ಯೆಸು ದೆವಾಲಯಮಾ ವ್ಹತ್ತೊ. ತೆ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರಿನ ಸುವಾರ್ತೆ ಕವಾಡೊತೊ, ಖಾಸ ಯಾಜಕೊ ಶಾಸ್ತ್ರಿಯೊ ವರಿ ಯೆಹುದಿಯೊಮಾನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಯೆಸುಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ತುನೆ ಎ ಕ್ಹಾರು ಕರಾನು ಅದಿಕಾರ ಕುನ್ನ ದಿದ್ಯುಸ? ವರಿ ಎ ಕ್ಹಾರು ಕಯು ಅದಿಕಾರಕ್ಹು ಕರಾಡ್ಯೊಸ? ಹಮೊನೆ ಕೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ, ಮಿ ತುಮೊನೆ ಯಕ್ಕ ಪ್ರಶ್ನೆ ಪುಚ್ಚು಼ಸ. ತುಮೆ ಮನೆ ಕವೊ, ");
INSERT INTO sle_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾನೊ ಅದಿಕಾರ ಯೊಹಾನನೆ ಕ್ಹುದಾ ಕಂತೊ ಆಯೊಸ ಸು ಮನಕ್ಹೊ ಕಂತೊ ಆಯೊಸ? ಮನೆ ಕವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ತ್ಯುನೆ ಯಕ್ಲಾನಾ ಕ್ಹಾತೆ ಯಕ್ಲೊ ಬೊಲ್ಲಿನ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾನೊ ಯೊಹಾನನೆ ಕ್ಹುದಾ ಕಂತೊ ಆಯೊಸ ಕದ್ಯಾಮ ತುಮೆ ತಿಪರ ಕಾ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ ಕೈನ ತೆ (ಯೆಸು) ಪುಚ್ಚಿ಼ ಪಾಡಸ್ತೊ? ");
INSERT INTO sle_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ನೈ ತೊ ಮನಕ್ಹೊತಿ ಎ ಅದಿಕಾರ ಆಯೊಸ ಕದ್ಯಾಮ ಮನಕ್ಹೊ ಅಪೊನೆ ಸುಕರಸ ಕೈನ ತ್ಯುನೆ ಭುಚ಼ಕ್ಯಾ. ಕಾಕದ್ಯಾಮ ಯೊಹಾನ ಯಕ್ಕ ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾಸ ಕೈನ ಕೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ತಿನಾಹುತಿ ತ್ಯುನೆ ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ಯೆಸುನೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ತೆಳಾಮಾ ತ್ಯುನೊನೆ ಯೆಸು ಮಿ ಕೈ ಅದಿಕಾರಕ್ಹು ಎ ಕ್ಹಾರು ಕರಾಡ್ಯೊಸ ಕೈನ ತುಮೊನೆ ಕತೊ ನೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ಪಾಚಲ್ತೊ ಯೆಸು ಮನಕ್ಹೊಕನ ಯಕ್ಕ ಸಾಮ್ಯ ಕದ್ಯೊ. ಯಕ್ಕ ಮನಕ್ಹ ಯಕ್ಕ ದ್ರಾಕ್ಷಿಯೊನೊ ಮಳೊ ಕರಿನ ತೆ ರೈತರೊನೆ ಗುತ್ತಿಗೆಯೆ ದಿನ್ನ ತೆ ತ್ಯಾಂತೊ ಬಿಜಾ಼ ಗಾಮೆ ಗಯೊ. ವರಿ ತ್ಯಾ ಘನ್ನಾ ದಿನ್ನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ದ್ರಾಕ್ಷಿಯೊ ಕಾಟಿನ ಇಕ್ಕಾನೊ ಟೈಮ ಆತಾಮಾ ತೆ ಮಳಾನೊ ಮಾಲಕ ತಿನೊ ವಾಟೊ ಪುಚ್ಚಾ಼ನೆ ತಿನಾ ಯಕ್ಕ ಆಳನೆ ರೈತರೊಕನ ಮೊಕಲ್ಯೊ. ತೆನೈಸೊ ತೆ ರೈತರೊ ತೆ ಆಳನೆ ಮಾರಿನ ಕ್ಹಾಲಿ ಹತೆ ಮೊಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ತಿನಾ ಹುತಿ ತೆ ಮಾಲಕ ವರಿ ಯಕ್ಲಾ ಆಳನೆ ತ್ಯುನೊಕನ ಮೊಕಲ್ಯೊ ತಿನೆ ಬಿ ತೆ ರೈತರೊಬಿ ಮಾರಿನ ಮರಿಯಾದಿ ಕಾಡಿನ ಖಾಲಿ ಹತೆ ಮೊಕ್ಕಲಿ ಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ವರಿಬಿ ತೆ ಮಾಲಕ ತನವಾ ಸಲಾ ತಿನಾ ಬಿಜಕ್ಕಲಾ ಆಳನೆ ಮೊಕಲ್ಯೊ, ವರಿಬಿ ರೈತರೊ ತೆ ಆಳನೆ ಘನ್ನಾ ಮಾರಿನ ತಿನೆಬಿ ಮೊಕ್ಕಲಿ ಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ತೆಳಾಮಾ ತೆ ದ್ರಾಕ್ಷಿನೊ ಮಳಾನೊ ಮಾಲಕ ಮಿ ಸುಕರು ಕೈನ ಕೈಲಿದ್ಯೊ? ಮಾರಾ ಮಯಾನಾ ದಿಕ್ರಾನೆ ತಬಿ ತ್ಯುನೊಕನ ಮೊಕ್ಕಲುಸ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ತೆ ರೈತರೊ ತೆ ಮಾಲಕನಾ ದಿಕ್ರಾನೆ ದೆಕಿನ ತ್ಯುನೆ-ತ್ಯುನೆ ಬೊಲ್ಲಿನ ಇನೆಜ಼ ಅಪೆ ಮಳಿನ ಖಲಾಸ ಕರಿ ಪಾಡ್ಯಾಮ ಎ ಮಳೊ ಅಪೊನೆ ಥೈಜಾ಼ವಸ ಕೈನ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ತೆ ಮಾಲಕನಾ ದಿಕ್ರಾನೆ ದ್ರಾಕ್ಷಿನಾ ಮಳಾಮಾತಾ ಭಾರಾ ನಿಂಗೈನ ಖಲಾಸ ಕರಿನ ನಾಕಿಪಾಡ್ಯಾ. ತಿಮ್ಮ ಥಯುಮ ತೆ ಮಳಾನೊ ಮಾಲಕ ತ್ಯುನೊನೆ ಸು ಕರಸ? ಕೈನ ಯೆಸು ಪುಚ್ಚೊ಼. ");
INSERT INTO sle_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ತೆಳಾಮಾ ತೆ ಮಾಲಕ ಐನ ತೆ ರೈತರೊನೆ ಖಲಾಸ ಕರಿನ ತೆ ದ್ರಾಕ್ಷಿನೊ ಮಳೊ ಬಿಜಾ಼ವೊನೆ ವಪ್ಸಸ\" ಮನಕ್ಹೊ ಎ ಐಕಿನ ಇಮ್ಮ ಕೆಳಾಮಾಜ಼ ಥಾವು ನೈ! ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ವರಿ ಯೆಸು ತ್ಯುನೊನೆ ದೆಕಿನ ತಿಮ್ಮ ರ‍್ಹಯುಮ, ಘರ ಭಾಂದಾಲಾವೊನೆ ನೈ ಚಾ಼ಯೆ ಥಯಲ ಭಿರಕೈ ಪಾಡಲ ದಗ್ಡೊ ಮೆನ ಮುಲಾನೊ ದಗ್ಡೊ ಥಯೊ. ಎ ವಚನೊ ಮತ್ಲಬ ಸುವೈ? ");
INSERT INTO sle_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ತೆ ದಗಡಾಪರ ಪಡಾಲೊ ಹರಿ ಯಕ್ಲೊ ತುಕಡಾ-ತುಕಡಾ ಥೈಜಾ಼ವಸ. ವರಿ ತೆ ದಗ್ಡೊ ತುಮೊಪರ ಪಾಡ್ಯೊಮ ತೆ ತುಮೊನೆ ಛೆಟಿ ಪಾಡಸ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ಯೆಸು ಎ ಕ್ಹಾರು ಕತಾಮಾ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ಶಾಸ್ತ್ರಿಯೊ ಖಾಸ ಯಾಜಕೊ. ಐಕಿನ ಯೆಸುನೆ ಕೈ ಉಪಾಯಕ್ಹು ಧರಿಯೆ ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ. ವರಿ ಮನಕ್ಹೊನಾ ಭೆಕ್ಹು ಯೆಸುನೆ ಚೊ಼ಡಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ತಿನಾಹುತಿ ಶಾಸ್ತ್ರಿಯೊ ಯಾಜಕೊ ಯೆಸುನೆ ರೊಮ ಅದಿಕಾರಿಯೊನಾ ಹತ್ಮಾ ಧರಿನ ದ್ಯು ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ. ತ್ಯುನೆ ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಯೆಸುನೆ ಶಕ್ಕಕ ಥಾವು ನೈಸೊ ಶಿಕಲೈನ ಯೆಸುಕನ ಮೊಕಲ್ಯಾತಾ. ವರಿ ತ್ಯುನೆ ಯೆಸುನೆ ತಪ್ಪಮಾ ಧರಿಯೆ ಕೈನ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ತಿನಾ ಹುತಿ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಶಿಕಲೈನ ಮೊಕ್ಕಲಲ ಮನಕ್ಹೊ ಯೆಸುನೆ ಉಪದೆಶ ಕರಾಲಾ ಗುರು ತು ಕ್ಹರಿನೊಜ಼ ವ್ಹೈ ತು ಮ್ಹೊಡು ದೆಕಿನ ಬೊಲಾಲೊ ನ್ಹವೈ ತು ಕ್ಹುದಾನಿ ಕ್ಹರಿನಿ ವಾಟಮಾ ಚ಼ಲಾವಾಲೊ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ಹಮ್ನಾ ಹಮೊನೆ ಕೆ ಹಮೆ ರೊಮನ ಚಕ್ರವರ್ತಿನೆ ಭು ಭಾಡೊ ದಿವಾನು ಚೊ಼ಕು ವ್ಹೈಸು ಕೆಟ್ಟ ವ್ಹೈ. ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ಯೆಸು ಎ ಮನಕ್ಹೊ ಮನೆ ಮೊಸ ಕರಾನೆ ಆಯಾಸ ಕೈನ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ತಿನಾ ಹುತಿ ಯೆಸು ತಿವನೊನೆ ಯಕ್ಕ ರುಪ್ಪಾನೊ ಬಿಲ್ಲೊ ಲೈನ ಮನೆ ದೆಕಾಡೊ ತ್ಯುನೆ ಲೈನ ದೆಕಾಡ್ಯಾ ಯೆಸು ತೆ ಬಿಲ್ಲೊ ಲಿನ ಎ ಬಿಲ್ಲಾಪರ ಕಿನೊ ಸಿಕ್ಕಕೊ ಛೆ? ವರಿ ಕಿನೊ ನಾಮ ಛೆ? ಕೈನ ಪುಚ್ಯೊ಼. ತ್ಯುನೆ ಸಿಸರನೊ ವ್ಹೈ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ ಸಿಸರನೊ ರ‍್ಹಯಲ ಸಿಸರನೆ ದಿವೊ ವರಿ ಕ್ಹುದಾನು ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ದಿವೊ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ತೆ ಮನಕ್ಹೊ ಯೆಸು ತಿನಿ ಗ್ಯಾನಕ್ಹು ಜ಼ವಾಬ ದಿದಲ ಐಕಿನ ಘಾಬ್ರಾ ಥೈನ ಯೆಸುನೆ ಬಿಜೆ಼ಕ ಸಲಾ ಪುಚ್ಚಾ಼ನೆ ಮನಕ್ಹೊಕ್ಹು ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ತೆಳಾಮಾ ಮರಿನ ಪುನರುತ್ಥಾನ ನೈ ಥಾತಾ ಕವಾಲಾ ದಕ್ಹಾ ಸದ್ದು ಕಾಯರೊ ಮನಕ್ಹೊ ಯೆಸುಕನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ತ್ಯುನೆ ಯೆಸುನೆ ದೆಕಿನ ಗುರು, ಯಕ್ಲೊ ಹಿವಾ ಕರಲಿನ ಬಚ್ಚಾ಼ ನೈಸೊ ಬೈ ಕೊನೆ ಚೊ಼ಡಿನ ಮರಿ ಗಯೊಮ. ತಿನೊ ನ್ಹಾನೊ ಭೈ ತೆ ಬಾಕಡಿನೆ ಹಿವಾ ಕರಲಿನ ತಿನಾ ಮ್ಹೊಟಾ ಭಾಯೊನಾ ನಾಮಪರ ಬಚ್ಚಾ಼ ಹುಟ್ಸು ಕೈನ ಮೊಶೆ ಬರ್ದಲ ಛೆತೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ಯಕ್ಕ ಕಾಲ್ಮಾ ಕ್ಹಾತ ಭಾಯೊ ವ್ಹತ್ತಾ. ಪಸ್ಟಲ್ಯೊ ಭೈ ಹಿವಾ ಕರಲಿನ, ಪಾಚಲ್ತೊ ಬಚ್ಚಾ಼ ನೈಸೊ ಮರಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ತೆಳಾಮಾ ಬೆವಾ ಭೈ ತೆ ಮಾಟಿ ಮರಲವಾಲಿ ಬಾಕಡಿನೆ ಹಿವಾ ಕರಲಿನ ತೆಬಿ ಬಚ್ಚಾ ನೈಸೊ ಮರಿಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ತೆಳಾಮಾ ತನ್ವಾವಾಲೊ ತೆಜ಼ ಮಾಟಿ ಮರಲವಾಲಿ ಬಾಕಡಿನೆ ಹಿವಾ ಕರಲಿನ ತೆಬಿ ತಿಮ್ಮಜ಼ ಮರಿಗಯೊ. ತಿನಾ ಲಿಂಗತಜ಼ ಕ್ಹಾತೆ ಜ಼ನಾ ಬಚ್ಚಾ಼ ನೈಸೊ ಮರಿಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ಲಾಸ್ಟಮಾ ತೆ ಬಾಕಡಿಬಿ ಮರಿ ಗೈ ");
INSERT INTO sle_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ವರಿ ಮರಿನ ಪುನರುತ್ಥಾನ ಥೈನ ಉಟ್ತಾಮಾ ತೆ ಬಾಕ್ಡಿ ಕಿನಿ ಬೈಕೊ ಥೈನ ರ‍್ಹವಸ? ಕೈನ ಪುಚ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ಯೆಸು ಸದ್ದುಕಾಯರೊನೆ ಕದ್ಯೊ. ದುನಿಯಾಮಾ ದಾಣ್ಗಾ ವರಿ ಹೆಣ ಮನಕ್ಹೊ ಹಿವಾ ಕರಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ಪುನರುತ್ಥಾನನೆ ಯೊಗ್ಯ ರ‍್ಹಯಲ ದಕ್ಹಾ ಮನಕ್ಹೊ ಜಿವ್ತಾ ಥೈನ ಉಟಿನ ಆಯಲಪರ ವರಿ ಜಿವ್ತಾ ರ‍್ಹವಸ. ತ್ಯುನೆ ನವೊ ಜ಼ಲಮ ಮಳಲ ಟೈಮ್ಮಾ ಹಿವಾಕರಲೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ತೆ ಜ಼ಲಮ್ಮಾ ದೆವದುತೊ ಲಿಂಗತ ರ‍್ಹವಸ. ತ್ಯುನೊನೆ ಮರಣ ಆತೊ ನೈ. ತ್ಯುನೆ ಕ್ಹುದಾನಾ ದಿಕ್ರಾ ಥೈನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ಮರಲವಾಲಾ ಪುನರುತ್ಥಾನ ಥಾವಸ ಕೈನ ಮೊಶೆ ದೆಕಾಡ್ಯೊಸ. ಆಗ ಲಾಗಲ ಝಾಡನಾ ಹುತಿ ಮೊಶೆ ಬರದತಾ ಟೈಮ್ಮಾ ಪ್ರಭು ಥಯಲ ಕ್ಹುದಾಜ಼ ಅಬ್ರಹಾಮನೊ ಕ್ಹುದಾ, ಇಸಾಕನೊ ಕ್ಹುದಾಜ಼, ವರಿ ಯಾಕೊಬನೊ ಕ್ಹುದಾಜ಼ ವ್ಹೈ ಕೈನ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ಕ್ಹುದಾಜ಼ ತಿವ್ನೊ ಕ್ಹುದಾ ಥಯಲ ಹುತಿ ತ್ಯುನೆ ಕ್ಹಾರಾ ಕ್ಹರಿಮಾಜ಼ ಮರ‍್ಯಾ ನತ್ತಿ. ಕಾಕದ್ಯಾಮ ಜಿವ್ತಾ ರ‍್ಹಯಲವಾಲಾವೊನೊ ಕ್ಹುದಾ ವ್ಹೈ. ಕ್ಹುದಾಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಜಿವ್ತಾ ರ‍್ಹಯಲ ಲಿಂಗತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ಶಾಸ್ತ್ರಿಯೊಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ \"ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಕವಾಲಾ ತು ಚೊ಼ಕು ಜವಾಬ ದಿದ್ಯೊಸ\"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ಬಿಜೆ಼ಕ ಸಲಾ ಯೆಸುನೆ ಪುಚ್ಚಾ಼ನೆ ಕಿನೆ ಧೈರಯ ಥೈ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ, ಕ್ರಿಸ್ತನೆ ದಾವಿದನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಮನಕ್ಹೊ ಕವಸ್ತೊ ಎ ಕಿಮ? ");
INSERT INTO sle_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ಕಿರ್ತನೆ ಬುಕ್ಮಾ ರ‍್ಹಯಲ ದಾವಿದಜ಼ ಕದ್ಯೊಸ್ತೊ. ಪ್ರಭು (ಕ್ಹುದಾ) ಮಾರಾ ಪ್ರಭುನೆ (ಕ್ರಿಸ್ತನೆ) ಸು ಕದ್ಯೊಸ ಕದ್ಯಾಮ, ");
INSERT INTO sle_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ಮಿ ತಾರಾ ದುಶ್ಮನೊನೆ ತಾರಾ ಪಗೊಮಾ ಘಾಲೆಲಕ್ಕಕಾ ಮಾರಾ ಸಿದಾ ಬಗಲ ಬೈಟ, ");
INSERT INTO sle_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ದಾವಿದಜ಼ ಕ್ರಿಸ್ತನೆ ಪ್ರಭು ವ್ಹೈ ಕೈನ ಕದಲ್ಪರ ತೆ ದಾವಿದನೊ ದಿಕ್ರೊ ಕಿಮ ಥಾವಸ? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ತ್ಯಾನಾ ಮನಕ್ಹೊ ಯೆಸುನಿಯೊ ವಾತೊ ಐಕಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಶಾಸ್ತ್ರಿಯೊನಾ ಹುತಿ ಹುಶಾರ ರ‍್ಹವೊ, ತ್ಯುನೆ ಚೊ಼ಕಾ-ಚೊ಼ಕಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ಫರಸ ವರಿ ಬಾಜ಼ರೊಮಾ ಮನಕ್ಹೊನಾ ಹತೆ ನಮಸ್ಕಾರ ಕರೈಲೆ ಲಿವು ಕೈನ ಸಭಾಮಂದಿರಮಾ ವರಿ ಖಾವಾನೆ ಘಾಲಾನಿ ಜ಼ಗಾ ಚೊ಼ಕಿ ಜ಼ಗಾ ಬೈಟಾಡು ಕೈನ ತಿವ್ನಿ ಆಸ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ತ್ಯುನೆ ರಾಂಡಿ ಹೆಣ ಮನಕ್ಹೊನೆ ಮೊಸ ಕರಿನ ತ್ಯುನಾ ಘರೊ ವರಿ ತಿವ್ನಿ ಆಸ್ತಿ ಕಾಳ್ಳೆತಾ ಕ್ಹುದಾಕನ ಮ್ಹೊಟಿ-ಮ್ಹೊಟಿ ಪ್ರಾಥನಾ ಕರತಾ ತ್ಯುನೆ ಚೊ಼ಕಾ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿಲಿವಸ. ಇವ್ನೊನೆ ಮ್ಹೊಟಿ ಶಿಕಶ್ಯಾ ದಿವಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ಸೌಕಾರ ರಹೆಲವಾಲಾ ಮನಕ್ಹೊ ದೆವಾಲಯಮಾ ಕಾಣಿಕೆನಿ ಪೆಟಗಿಮಾ ದೊಕಡಾ ಘಾಲಾನು ಯೆಸು ದೆಕಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ತೆಕ್ಲಾಮಾಜ಼಼ ಯಕ್ಕ ರಾಂಡಿ ಬಾಕ್ಡಿ ಐನ ಬೆ ತಾಂಬಾನಾ ಬಿಲ್ಲಾ ಕಾಣಿಕಿನಿ ಪೆಟಗಿಮಾ ಘಾಲಿ. ");
INSERT INTO sle_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ಯೆಸು ತೆ ದೆಕಿನ ತುಮೊನೆ ಕ್ಹರಿಮಾಜ಼ ಕೌಸ. ಕ್ಹಾರಾವೊನಿ ಕಾಣಕಿತಿಬಿ ಎ ಬಾಕ್ಡಿ ಘಾಲಲ ಕಾಣಕಿ ಘನ್ನಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ಸೌಕಾರ ರ‍್ಹಯಲ ವಾಲಾ ತ್ಯುನೊನೆ ಚಾ಼ಯೆಥಯಲ ತ್ಯುನೆ ಮುಕ್ಕಕಿಲಿನ ಉಗ್ರಲ ಕಾಣಿಕೆ ದಿದ್ಯಾ. ಆ ಬಾಕ್ಡಿ ಜಿವ್ನಾ ಕರಾನೆ ಚಾ಼ಯೆ ಥಯಲ ಕ್ಹಾರಾ ದೊಕಡಾ ಕಾಣಿಕೆ ಘಾಲಿಪಾಡಿ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ಶಿಷ್ಯಾವೊಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ ದೆವಾಲಯನಾ ಹುತಿ ಬೊಲ್ತಾ, ಎ ಕೆಕ್ಕಲಾ ಚೊ಼ಕಾ ಮಂಗಾಳಾ ಕ್ಹು ಭಾಂದ್ಯಾಸ. ವರಿ ಮನಕ್ಹೊ ಕೈಲಿದಲ ಹರಕೆ ಕ್ಹು ಸಾಮನಕ್ಹು ಕೆಕ್ಕಲು ಚೊ಼ಕು ದಿಕ್ಹಾಡುಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ಇಮ್ಮ ಕತಾಮಾ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ ಕದ್ಯೊ. ತುಮೆ ನ್ಹ್ಯಾ ದೆಕಾನು ಪುರಾ ನಾಶ ಥಾವಾನೊ ಟೈಮ ಆವಸ. ವರಿ ನ್ಹ್ಯಾ ದಗಡಾಪರ ದಗ್ಡೊ ನೈ ಹುಬ್ರೆತೊ ಪಾಡಾ ಲಗಾಡಿಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ತೆಳಾಮಾ ಶಿಷ್ಯಾ ಯೆಸುನೆ ಕದ್ಯಾ \"ಗುರು, ಎಕ್ಹಾರು ಥಾವಾನು ಕೆಳಾಮಾ ವ್ಹೈ ವರಿ ಎ ಥಾವಾನು ವಳಕ ಸು ವ್ಹೈ, ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ಯೆಸು ತ್ಯುನೊನೆ ತುಮೆ ಹುಶಾರ ರಹೊ ಮೊಸಮಾ ಪಡೊನಕೊ ಮಾರು ನಾಮ ಕೈನ ಘನ್ನಾ ಜ಼ನಾ ಆವಸ. ತ್ಯುನೆ ಐನ ಮಿಜ಼ ಕ್ರಿಸ್ತ (ಯೆಸು) ವ್ಹೈ ಕವಸ. ತುಮೆ ತಿವ್ನೊಪರ ಬರೊಕ್ಹೊ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ಯುದ್ದೊನಾ ಹುತಿ ದಂಗಾವೊನಾ ಹುತಿ ಸುದ್ದಿಯೊ ಐಕೊಸಿ ವರಿಬಿ ತುಮೆ ಭುಚ಼ಕೊ ನಕೊ. ಎ ಕ್ಹಾರು ಪೈಲಾ ಥಾವು ತಿಮ್ಮ ಥಯಲ್ಪರಬಿ ತೆ ಅಂತ್ಯ ನ್ಹವೈ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ವರಿ ಯೆಸು ತ್ಯುನೊನೆ ದೆಶನಾ ವಿರುದ್ದ ದೆಶ ಉಟಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ಭುಕಂಪೊ ಥಾವಸ ಬರಗಾಲ ಪಡಸ ಮನಕ್ಹೊನೆ ಘನ್ನೊ ತ್ರಾಸ ಥಾವಸ, ಹಬಾಳಮಾ ನೈಸೊ ಥಾವಾನು ಅದ್ಭುತ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ವರಿ ಎ ಕ್ಹಾರು ಥಾವಾತಿ ಅಗ್ದುರ ಮನಕ್ಹೊ ತುಮೊನೆ ಧರಿಲಿನಗೈನ ತ್ರಾಸ ಕರಸ ವರಿ ತುಮೊನೆ ಸಭಾಮಂದಿರಮಾ ಲಿನಜಾ಼ವಸ, ತುಮೊನೆ ಫೈಸಲೊ ಕರಿನ ಜೆಲಮಾ ಘಾಲಾಲಗಾಡಸ. ವರಿ ರಾಜಾ಼ವೊನಾ ಕ್ಹಾಮಾ ಹುಬ್ರಾಡಸ, ತುಮೊಪರ ಅಪವಾದ ಘಾಲಸ. ತುಮೆ ಮಾರಾ ಪಾಚಾ಼ ಆವಾಕ್ಹು ಮನಕ್ಹೊ ತುಮೊನೆ ಎ ಕ್ಹಾರು ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ಇನಾಹುತಿ ತುಮಾರಾ ಬರೊಕ್ಹಾನಾ ಹುತಿ ಸಾಕ್ಷಿ ಕವಾನೆ ಚೊ಼ಕೊ ಟೈಮ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ತೆಳಾಮಾ ತುಮೆ ತ್ಯುನೊಕನ ಸು ಕೌ ಕೈನ ಚಿಂತಾ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ಕಾಕದ್ಯಾಮ ಮಿಜ಼ ತುಮೊನೆ ಬೊಲಾನು ಗ್ಯಾನ ದ್ಯುಸ. ತಿನಾಹುತಿ ತುಮಾರಾ ದುಶ್ಮನೊ ತುಮೆ ಪುಚ಼್ಚಲ ವಾತನೆ ಜ಼ವಾಬ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ತುಮೊನೆ ತಮಾರಾ ಮಾ ಬಾಪ ವರಿ ಭಾಯೊ ತುಮಾರಾ ದೊಸ್ತೊ ತಮಾರಾ ವಿರುದ್ದ ಥಾವಸ. ತುಮೊಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ತ್ಯುನೆ ಖಲಾಸ ಕರೈಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ವರಿ ತುಮೆ ಮಾರಾ (ಯೆಸುನಾ) ಪಾಚಾ಼ ಆವಾಕ್ಹು ಮನಕ್ಹೊ ತುಮಾರಾ ದುಶ್ಮನೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ತಿಮ್ಮ ಥಯುತಬಿ ತುಮಾರಾ ಮಾತಾನಾ ಬಾಲನೆಬಿ ಧೊಕೊ ಥಾತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ತುಮೆ ತಮಾರಾ ಬರೊಕ್ಹಾಪರ ಘಟ್ಟ ರ‍್ಹಯಾಮ ತಮಾರಾಕ್ಹು ತುಮೆ ವಚಾ಼ಡಿ ಲಿವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ಯೆರುಸೆಲೆಮಾನಾ ಸುತ್ತೆ ಸೈನಿಕೊ ಬೆಲಿ ಘಾಲಾನು ತುಮೆ ದೆಕೊಸಿ ತೆಳಾಮಾ ಯೆರುಸೆಲೆಮ ಹಾಳ ಥಾವಾನು ನಜಿಕ ಆಯುಸ ಕೈನ ತುಮೆ ತಿಳದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ತೆಳಾಮಾ ಯುದಾಯಮಾ ರ‍್ಹಯಲ ವಾಲಾ ಮನಕ್ಹೊ ಡೊಂಗರಪರ ನ್ಹಾಟಿ ಜಾ಼ವಾದೆ ಗಾಮ್ಮಾ ರ‍್ಹಯಲ ವಾಲಾ ಭಾರಾ ನ್ಹಾಟಿ ಜಾ಼ವಾದೆ ವರಿ ಖೆಡಾಮಾ ರ‍್ಹಯಲ ವಾಲಾ ಗಾಮ್ಮಾ ಔ ನೈಸೊ ತ್ಯಾಜ಼ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ತೆ ದಿನೊ ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ಶಿಕ್ಷಾ ದಿವಾನಾ ಟೈಮ ವ್ಹೈ ಪ್ರವಾದಿಯೊ ಬರ್ದಲ ಪುರಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ತೆ ದಿನೊಮಾ ಪೆಟೆ ರ‍್ಹಯಲ ಬಾಕಡಿಯೊನೆ ವರಿ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ ರ‍್ಹಯಲಲಿಯೊನೆ ಘನ್ನು ತ್ರಾಸ ಥಾವಸ. ಕಾಕದ್ಯಾಮ ಆ ಜ಼ಗಾಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊಪರ ತ್ರಾಸ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ಎ ಮನಕ್ಹೊಮಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಸೈನಿಕೊ ಖಲಾಸ ಕರಿಪಾಡಸ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಧರಿಲಿನಗೈನ ಬಿಜಾ಼ ದೆಶೆ ಲಿನಜಾ಼ವಸ. ವರಿ ಬಿಜಾ಼ ದೆಶವಾಲಾ ತಿವ್ನೊ ದಿನ್ನ ಥಾಯೆಲಕ್ಕಾ ಯೆರುಸೆಲೆಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ಸುರ‍್ಯೊ, ಚ಼ಂದಪ್ಪಾ ವರಿ ಚಿಕ್ಕಿಯೊ ಬಿಜಿ ತರಾಜ಼ ದಿಕ್ಹಸ ವರಿ ಜಿಮಿನ್ಪರ ರ‍್ಹಯಲ ಮನಕ್ಹೊಮಾ ಅಲ್ಲೊಲ ಕಲ್ಲೊಲ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ಹಬಾಳಮಾ ರ‍್ಹಯಲ ಶಕ್ತಿಯೊ ಹಲ್ಲಾಕ್ಹು ಜಿಮಿನಪರ ಸು-ಸು ಥಾಸ ಕೈನ ಮನಕ್ಹೊ ಭುಚ಼ಕಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ತೆಳಾಮಾ ಮನಕ್ಹನೊ ದಿಕ್ರೊ (ಯೆಸು) ಮ್ಹೊಟಿ ತಾಕತಕ್ಹು ಮಹಿಮಾನಾ ಪ್ರಭಾವಕ್ಹು ಹಬಾಳಮಾತೊ ಆವಾನು ಮನಕ್ಹೊ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ಎ ಕ್ಹಾರು ಥಾತಾಮಾ ಉಪ್ಪರ ದೆಕೊ ಕಾಕದ್ಯಾಮ ತುಮೊನೆ ಬಿಡಗಡೆನೊ ದಿನ್ನ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ಪಾಚಲ್ತೊ ಯೆಸು ಆ ಸಾಮ್ಯ ಕದ್ಯೊ. ಕ್ಹಾರಾ ಝಾಡೊಮಾತಿಬಿ ಅಂಜುರನು ಝಾಡನಿ ಚೊ಼ಕಿ ಉದಾಹರಣ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ತೆ ಚಿಗರತಾಮಾಜ಼ ತಡಕಾನೊ ದಿನ್ನ ಆಯೊಸ ಕೈನ ತಿಳದಿಲಿವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ತಿನಾ ಲಿಂಗತಜ಼ ಎ ಕ್ಹಾರು ಥಾತಾಮಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಭೆಗಿನ ಆವಸ ಕೈನ ತಿಳದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಎ ಕಾಲನಾ ಮನಕ್ಹೊ ಹಜು಼ನ ಜಿವ್ತಾ ರ‍್ಹತಾಮಾಜ಼ ಎ ಕ್ಹಾರು ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ಹಬಾಳ ಜಿಮಿನ ಹಾಳ ಥಾವಸ ಮಿ ಕದಲ ವಾತೊ ಕೆಳಮಾಜ಼ ಹಾಳ ಥಾತಿಯೊ ನೈ! ");
INSERT INTO sle_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"ತುಮೆ ಹುಶಾರ ರ‍್ಹವೊ! ಖಾವಾಮಾ ಪಿನ ನಶಾಮಾ ದುನಿಯಾನಿ ಚಿಂತಾಮಾ ಡುಬಿಜಾ಼ವೊನಕೊ ತುಮೆ ತುಮಾರು ಮನಸ ಘಟ್ಟ ಕರಲಿದಲ ಟೈಮಾಜ಼ ಲಾಸ್ಟನೊ ದಿನ್ನ ಭೆಗಿನ ಐ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ತೆ ದಿನ್ನ ಜಿಮಿನಪರ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಘಾಬ್ರೊ ಕರಿ ಪಾಡ್ಸ. ");
INSERT INTO sle_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ತಿನಾ ಹುತಿ ಕ್ಹಾರಾಜ಼ ಟೈಮ್ಮಾ ತಯ್ಯಾರ ಥೈನ ರಹೊ. ಹಮ್ನಾ ಥಾವಾನಿ ವಿಚಾರೊಕ್ಹು ವಾಚಿನ ವರಿ ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ಕ್ಹಾಮಾ ಹುಬ್ರವಾನೆ ತಯ್ಯಾರ ರಹೊ. ವರಿ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ಯೆಸು ತೆ ದಿನೊಮಾ ದಿನ್ನ ಕ್ಹಾರಿ ದೆವಾಲಯಮಾ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕತೊತೊ. ವರಿ ರಾತ ಕ್ಹಾರಿ ಒಲಿವ ತೆಲನಾ ಝಾಡನಾ ಡೊಂಗರಪರ ರ‍್ಹತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ದಿನ್ನೆ ಪಾಟೆ, ಮನಕ್ಹೊ ಭೆಗಿನ ಉಟಿನ ಗೈನ ದೆವಾಲಯಮಾ ಯೆಸುನು ಉಪದೆಶ ಐಕಾನೆ ಜಾ಼ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ಖಾಟೊ ನೈಸೊ ರೊಕ್ಲಾನೊ ಸನ್ನ ಕದ್ಯಾಮ ಫಸ್ಕ ಸನ್ನ ನಜಿಕ ಆಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ಖಾಸ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ. ಯೆಸುನೆ ಕಿನೆಜ಼಼ ಗ್ವತ್ತವಾಚಿ಼ ಖಲಾಸ ಕರಿಯೆ ಕೈನ ಟೈಮ ದೆಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ಯೆಸುನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನಾ ಇಸ್ಕರಿಯುತ ಯುದ ಕವಾಲೊ ಶಿಷ್ಯೊ ಬಿ ವ್ಹತ್ತೊ. ಸೈತಾನ ತಿಮಾ ಐನ ಯಕ್ಕ ಕೆಟ್ಟ ಕಾಮ ಕರಾನೆ ಸಹಾಯತಾ ಕರ‍್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ಯುದ ಖಾಸ ಯಾಜಕಕೊಕನ ವರಿ ದೆವಾಲಯನಾ ಅದಿಕಾರಿಯೊಕನ ಐನ, ಯೆಸುನೆ ಧರಿನ ದ್ಯುಸ ಕೈನ ತ್ಯುನೊಕನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ತೆಳಾಮ ತೆ ವಾತ ಐಕಿನ ಯಾಜಕೊನೆ ಘನ್ನಿ ಖುಶಿ ಥೈ. ತು ಯೆಸುನೆ ಧರೈನ ದಿದ್ಯೊಮ ಹಮೆ ತುನೆ ದೊಕಡಾ ದಿಯೆಸ ಕೈನ ವಾತ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ಯುದ ತೆ ವಾತೆ ಒಪ್ಪಿಲಿದ್ಯೊ. ಪಾಚಲ್ತೊ ಯುದ ಯೆಸುನೆ ಧರೈನ ದಿವಾನೆ ಟೈಮ ದೆಕಾಡ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ಖಾಟೊ ನೈಸೊ ರೊಕ್ಲೊ ಖಾವಾನೊ ದಿನ್ನ ಆಯೊ. ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊ ಪಸ್ಕ, ತೆ ದಿನಮಾ ಬಕ್ರಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಕಾಟತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ತೆಳಾಮಾ ಯೆಸು, ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ, ತುಮೆ ಗೈನ ಪಸ್ಕ ಸನ್ನನು ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ಅಪೊನೆ ತಯ್ಯಾರ ಕರೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ತ್ಯುನೆ ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ಹಮೆ ಕಿಜ್ಗಾ಼ ತಯ್ಯಾರ ಕರಿಯೆ? ಕೈನ ಯೆಸುನೆ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ಯೆಸು ತ್ಯುನೊನೆ ಐಕೊ ತುಮೆ ಯೆರುಸಲೆಮ ಗಾಮ್ಮಾ ಗೈನ ತ್ಯಾ ಯಕ್ಲೊ ಭರಲ ಪಾನಿನೊ ಘಡೊ ಲಿನ ಜಾ಼ವಾಲಾನೆ ತುಮೆ ದೆಕೊಸಿ. ತುಮೆ ತಿನಾ ಪಾಚಾ಼ ಜಾ಼ವೊ ತೆ ಯಕ್ಕ ಘರಮಾ ಜಾ಼ವಸ. ತುಮೆ ತೆ ಘರಮಾ ಜಾ಼ವೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ತೆ ಘರನಾ ಮಾಲಕನೆ, ಗುರು ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಕೈ ಖೊಲಿಮಾ ಪಸ್ಕ ಸನ್ನನು ಅನ್ನ ಖಾವಾನೆ ಬೈಟಾನೆ. ಕೈನ ಪುಚೊ಼. ");
INSERT INTO sle_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ತೆಳಾಮಾ ಘರನೊ ಮಾಲಕ ಮ್ಹಾಡಿಪರ ರ‍್ಹಯಲ ಯಕ್ಕ ಮ್ಹೊಟಿ ಖೊಲಿ ದೆಕಾಡಸ. ತೆ ಖೊಲಿಮಾ ಅಪೊನೆ ಪಸ್ಕನು ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ತ್ಯಾ ತಯ್ಯಾರ ಕರೊ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ತಿನಾ ಹುತಿ ತ್ಯುನೆ ಗಯಾ. ವರಿ ಯೆಸು ಕದಲ ತೆ ಪುರಾ ಥಯು. ತ್ಯುನೆ ತ್ಯಾ ಪಸ್ಕನು ಅನ್ನ ತಯ್ಯಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ಪಸ್ಕನಾ ಅನ್ನ ಖಾವಾನೊ ಟೈಮ ಆಯೊ. ಯೆಸು ವರಿ ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾ ಅನ್ನ ಖಾವಾನಾ ಹುತಿ ಬೈಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ತೆಳಾಮ ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ ಮಿ ಕಷ್ಟಮಾ ಪಡಾತಿ ಅಗ್ದುರ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ಪಸ್ಕನು ಅನ್ನ ಖೌ ಕೈನ ಮಾರಿ ಘನ್ನಿ ಆಸ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ಇನೊ ಮತ್ಲಬ ವ್ಹೈ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಪುರಾ ಆಯೆಲಕ್ಕಾ ಮಿ ಬಿಜೆಕ ಪಸ್ಕನು ಅನ್ನ ಖಾತೊಜ಼ ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ಪಾಚಲ್ತೊ ಯೆಸು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹನೊ ತಾಂಬಿಯೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರ ಕೈನ. ತೆ ಶಿಷ್ಯಾವೊನೆ ದಿನ್ನ ತುಮೆ ವಾಟಿನ ಪಿವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ಆಜ಼ತೊ ಮಿ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ಆಯೆಲಕ್ಕಾ ಫರಿನ ದ್ರಾಕ್ಷಿಯೊನೊ ರಕ್ಹ ಪಿತೊಜ಼ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ವರಿ ಯೆಸು ದಕ್ಹೊ ರೊಕ್ಲೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ತೆ ಭಾಗಿನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ದಿದ್ಯೊ. ಪಾಚಲ್ತೊ ಯೆಸು, ಮಿ ತುಮಾರಾ ಹುತಿ ದಿವಾನು ಮಾರು ಅಂಗ ವ್ಹೈ. ಮಾರಿ ಶೆನಾ ಹುತಿ ತುಮೆ ಇಮ್ಮ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ವರಿ ತ್ಯುನು ಖಾವಾನು ಥಯಲಪರ, ಯೆಸು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹನೊ ತಾಂಬಿಯೊ ಲಿನ, ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ವಾತ ದಿದಲ ನಯ್ಯೊ ವಾತೊನಾ ಹುತಿ ವಳಕ ರ‍್ಹವಾದೆ ಮಿ ತುಮಾರಾ ಹುತಿ ದಿವಾನು ರಗತ ಎ ನೈಯೊ ವಾತೊ ಶುರು ಥಾವಸ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ಯೆಸು, ಮನೆ ಮೊಸ ಕರಾಲೊ ಮಾರಾಜ಼ ಕ್ಹಾತೆ ಅನ್ನ ಖಾವಾನೆ ಬೈಟ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಕ್ಹುದಾನಿ ಮರ್ಜಿ ಲಿಂಗತ ಮರಸ, ತೆನೈಸೊ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಮರಾನಾ ಹುತಿ ವಪ್ಸಿನ ದಿವಾಲಾ ಮನಕ್ಹನೆ ಘನ್ನು ಕೆಟ್ಟ ಥಾವಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ತೆಳಾಮಾ ಶಿಷ್ಯಾ, ಅಪೊಮಾ ಎ ಕೆಟ್ಟ ಕುನ್ನ ಕರಸ? ಕೈನ ಯಕ್ನಾ ಯಕ್ಕ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ಪಾಚಲ್ತೊ ಶಿಷ್ಯಾವೊನಾ ತಿವ್ನೊಮಾ ಕುನ್ನ ಮ್ಹೊಟು ವ್ಹೈ ಕೈನ ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ, ಎ ಲೊಕನಾ ರಾಜಾ಼ ತಿವ್ನಾ ಮನಕ್ಹೊಪರ ರಾಜ಼ ಚ಼ಲಾವಸ. ಮನಕ್ಹೊಪರ ಅದಿಕಾರ ಕರಾಲಾವೊನೆ ಕೆಟ್ಟ ಮನಕ್ಹೊ ವ್ಹೈ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ತೆನೈಸೊ ತುಮೆ ತಿಮ್ಮ ಥೌ ನೈ. ಮ್ಹೊಟೊ ಮನಕ್ಹ ನ್ಹಾನೊ ಮನಕ್ಹ ಥೈನ ರ‍್ಹೌ. ನಾಯಕ ಸೆವಕ ಥೈನ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ಚೊ಼ಕೊ ಕುನ್ನ ವ್ಹೈ? ಖಾವಾನೆ ಬೈಟಲವಾಲೊ? ನೈತೊ ತಿನೆ ಸೆವಾ ಕರಾಲೊ ಸು? ಅನ್ನ ಖಾವಾನೆ ಬೈಟಲವಾಲೊ ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ತುಮೆ ತಿಳದಿಲಿದ್ಯಾಸು? ಮಿ ತುಮೊಮಾ ಸೆವಕ ಲಿಂಗತ ಛೆ! ");
INSERT INTO sle_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ತುಮೆ ಮನೆ ಕಷ್ಟ ಆಯಲ ಟೈಮ್ಮಾ ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ವಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ಮಾರೊ ಬಾ (ಕ್ಹುದಾ) ಮನೆ ಅದಿಕಾರ ದಿದ್ಯೊಸ. ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ತುಮೊನೆ ಮಿಬಿ ತೆಜ಼ ಅದಿಕಾರ ದ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ಮಾರಾ ರಾಜ್ಯಮಾ ತುಮೆಬಿ ಮಾರಾ ಕ್ಹಾತೆ ಅನ್ನ ಖಾವೊಸಿ ವರಿ ಪಿವೊಸಿ. ಸಿಂಹಾಸನ್ಪರ ಬೈಟಿನ ಇಸ್ರಾಯಲನಾ ಬಾರಾ ಜಾ಼ತವಾಲಾವೊನೆ ಫೈಸಲೊ ಕರೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ಯಕ್ಕ ರೈತ ತಿನು ಘೌ ತುರಾನಾ ಲಿಂಗತ ಸೈತಾನ ತುಮೊನೆ ಪರಿಕ್ಕಷಾಲಿವಾನೆ ಮಾಂಗಿಲಿದ್ಯೊ. ಸಿಮೊನ, ಸಿಮೊನ (ಪೆತ್ರಾ) ");
INSERT INTO sle_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ತಾರೊ ಬರೊಕ್ಹೊ ಕಮ ಥೌನೈ ಕೈನ ಮಿ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ! ತು ಫರಿನ ಆಯಲ್ಪರ ತಾರಾ ಭಾಯೊನೆ ತು ತಾಕತ ಥೌ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ತೆ ವಾತೆ ಪೆತ್ರಾ ಯೆಸುನೆ \"ಪ್ರಭು, ತಾರಾ ಕ್ಹಾತೆ ಜೆಲೆ ಜಾ಼ವಾನೆಬಿ ವರಿ ಮರಾನೆಬಿ ಮಿ ತಯ್ಯಾರ ಛೆ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ತೆ ವಾತೆ ಯೆಸು, ಪೆತ್ರಾ, ವ್ಹಂತಾ ಪಾಟೆ ಕುಕಡೊ ಬಾಂಗ ದಿವಾತಿ ಅಗ್ದುರ ತು ಮಾರಿ ವಿಷಯಮಾ ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕೈನ ತನ ಸಲಾ ಕಸಿ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ಪಾಚಲ್ತೊ ಯೆಸು ಶಿಷ್ಯಾವೊನೆ, ಮಿ ತುಮೊನೆ ಭೊದನೆ ಕವಾನಾ ಹುತಿ ಮೊಕಲ್ತಾಮಾ ದೊಕಡಾವೊನೆ ಕೈಚಿಲಾ ವರಿ ಗಾಮೆ ನಿಂಜಾ಼ವಾನಿ ಕೈಚಿಲಾ ನೈಸೊಜ಼, ಚಪ್ಲೊ ನೈಸೊ ಮೊಕಲ್ಯೊ, ವರಿಬಿ ತುಮೊನೆ ಸುಬಿ ಕಮ ಥೈಸು? ಕೈನ ಪುಚ್ಯೊ. ತೆಳಾಮ ಶಿಷ್ಯಾ ಸುಜ಼ ಕಮ ಥೈಯು ನೈ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ಯೆಸು ತ್ಯುನೊನೆ\"ಹಮ್ನಾ ತುಮೊಕನ ದೊಕಡಾ ರ‍್ಹಯಾಮ ಕೈಚಿಲಾ ರ‍್ಹೈಮ ತೆ ಲಿನ ಜಾ಼ವೊ ತುಮೊಕನ ತಲ್ವಾರ ನೈ ರ‍್ಹಯುಮ ತುಮಾರು ಉಪ್ಪರಲ್ಯು ಅಂಗ್ಡು ಇಕ್ಕಿನ ತೆ ದೊಕಡಾಕ್ಹು ಯಕ್ಕ ತಲ್ವಾರ ನಿಂಜಾ಼ವೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ತೆ ಅಪರಾದಿಮಾನೊ ಯಕ್ಲೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿದ್ಯೊ. ಕೈನ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ಮಾರಾ ಹುತಿ ಬರ್ದಲ ಪುರಾ ಥೌ ವರಿ ತೆ ಹಮ್ನಾ ಪುರಾ ಥಾವಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ತೆಳಾಮ ಶಿಷ್ಯಾ ತಿನೆ, ಪ್ರಭು, ನ್ಹ್ಯಾ ದೆಕ ಬೆ ತಲ್ವಾರ ಛೆ \"ಕದ್ಯಾ. ಯೆಸು \"ತೆಕ್ಲು ಬಸ್ಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ಯೆಸು ಯೆರುಸೆಲೆಮ ಗಾಮ್ಮಾತೊ ಒಲಿವ ತೆಲನಾ ಝಾಡೊನಾ ಡೊಂಗರಪರ ಗಯೊ. ತಿನಾ ಶಿಷ್ಯಾಬಿ ತಿನಾ ಕ್ಹಾತೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ\"ತುಮೆ ಶೊದನೆಮಾ ಪಡೆ ನೈಸೊ ಪ್ರಾಥನಾ ಕರೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ಪಾಚಲ್ತೊ ಯೆಸು ತ್ಯುನೊತಿ ದಗ್ಡೊ ಭಿರಕಾವಾನಾ ಯಕ್ಲೊ ದುರ ಗೈನ ತೆ ಉಂದಾ ಗುಡ್ಗಾ ಘಾಲ್ಲಿನ, ");
INSERT INTO sle_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ಬಾ, ತುನೆ ಮನಸ ರ‍್ಹಯುಮ, ಆ ತ್ರಾಸನೊ ತಾಂಬಿಯೊ ಮಕ್ಹು ದುರ ಕರ ವರಿಬಿ ಮಾರಿ ಚಿತ್ತ ಲಿಂಗತ ನೈಸೊ ತಾರಿ ಚಿತ್ತ ಲಿಂಗತ ಕರ ಕೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ತೆಳಾಮಾ ಸ್ವರಗತೊ ಯಕ್ಕ ದೆವದುತ ಐನ. ಯೆಸುನೆ ತಾಕತ ಭರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ಯೆಸುನೆ ಘನ್ನು ತ್ರಾಸ ಥಯು. ತೆ ಪ್ರಾಥನಾಮಾ ಘನ್ನೊ ಕಷ್ಟ ಖಾದ್ಯೊ. ತಿನೊ ಘಾಮ ರಗತ ಲಿಂಗತ ಚಾ಼ಲ್ಯು. ");
INSERT INTO sle_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ಯೆಸು ಪ್ರಾಥನಾ ಕರಲ್ಪರ ತಿನಾ ಶಿಷ್ಯಾವೊಕನ ಗಯೊ. ತ್ಯುನೆ ಕ್ಹುರೈ ಪಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ಯೆಸು ತ್ಯುನೊನೆ ತುಮೆ ಕಾ ಕ್ಹುರೈ ಪಡ್ಯಾಸು? ಉಟೊ! ಶೊದನೆಮಾ ಪಡೆ ನೈಸೊ ಪ್ರಾಥನಾ ಕರೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ಯೆಸು ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾಜ಼, ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ತ್ಯಾ ಐಯು. ಬಾರಾ ಅಪೊಸ್ತಲೊಮಾ ಯಕ್ಲೊ ತೆ ಗುಂಪನಾ ಕ್ಹಾತೆ ಆವಾಡ್ಯೊತೊ. ತೆಜ಼ ಯುದ ವ್ಹೈ. ತೆ ಯೆಸುನಾ ಕ್ಹಾಮೊ ಐನ ಮಟ್ಟಿ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ಯೆಸು ತಿನೆ ಯುದ ಯಕ್ಕ ಮಟ್ಟಿಲಿನ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಧರೈನ ದಿವಾನೆ ಆಯೊಸು? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ಯೆಸುನಾ ಶಿಷ್ಯಾಬಿ ತ್ಯಾ ವ್ಹತ್ತಾ. ತ್ಯಾ ಥಾವಾನು ತ್ಯುನೆ ದೆಕಾಡಾತಾ. ಶಿಷ್ಯಾ ಯೆಸುನೆ, ಪ್ರಭು, ಹಮೆ ಹಮಾರಾ ತಲ್ವಾರೊ ಉಪಯೊಗ ಕರಿಯೆಸು? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ಶಿಷ್ಯಾವೊಮನೊ ಯಕ್ಲೊ ತಿನು ತಲ್ವಾರ ಕಾಡಿನ ಮಹಾಯಾಜಕನಾ ಆಳನೊ ಸಿದಾ ಬಗಲನೊ ಕಾನ ಕತ್ರಿ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ಯೆಸು ತಿನೆ \"ಹುಬ್ರೆ\" ಕದ್ಯೊ. ತೆ ಆಳನಾ ಕಾನೆ ಮುಟ್ಟಿನ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ಯೆಸುನೆ ಧರಾ ಹುತಿ ಖಾಸ ಯಾಜಕೊ, ಯಹುದ್ಯೊನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ. ವರಿ ಸೈನಿಕೊ ಆಯಾತಾ. ತುಮೆ ಚಾಕಾ ಛುರಿಯೊ ಲಿನ ನ್ಹ್ಯಾ ಕಾ ಆಯಾಸ? ಮಿ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ತುಮೆ ತಿಳದ್ಯಾಸು? ");
INSERT INTO sle_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ದಿನ್ನೆ ಬಿ ತುಮಾರಾ ಕ್ಹಾತೆ ದೆವಾಲಯಮಾ ವ್ಹತ್ತೊ. ತುಮೆ ಮನೆ ತ್ಯಾ ಕಾ ಧರ‍್ಯಾ ನೈ? ತೆನೈಸೊ ಆಜ಼ ತಮಾರೊ ದಿನ್ನ ವ್ಹೈ. ಎ ಅಂದಕಾರನೊ ರಾಜ್ಯ ವ್ಹೈ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ತ್ಯುನೆ ಯೆಸುನೆ ಭಾಂದಿನ ಮಹಾಯಾಜ಼ಕನಾ ಘರೆ ಬಲೈ ಲಾಯಾ. ಪೆತ್ರಾ ತ್ಯುನಾ ಪಾಚೊ಼-ಪಾಚೊ಼ ಆಯೊ. ವರಿ ತೆ ಯೆಸುನಾ ನಜಿ಼ಕ ಆಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ಸೈನಿಕೊ ಖಾಸ ಯಾಜಕನಾ ಅಂಗಳಾಮಾ ಆಗ ಲಗಾಡಿನ ಅಂಗ ಶೆಕಿಲೆತಾ ಬೈಟ್ಯಾತಾ. ಪೆತ್ರಾ ಬಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ಪೆತ್ರಾ ತ್ಯಾ ಬೈಟಲ ಖಾಸ ಯಾಜಕನಿ ಆಳನಿ ದೆಕಿನ. ಆಗನಾ ಉಜಾಲಾಕ್ಹು ತೆ ಪೆತ್ರಾನೆ ವಳಕಿ. ತೆ ಆಳನಿ ಪೆತ್ರಾನೆ ಆ ಮನಕ್ಹ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ವಾಲೊ ವ್ಹೈ ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ತೆಳಾಮಾ ಪೆತ್ರಾ. ಎ ಕ್ಹರಿ ನ್ಹವೈ ಕದ್ಯೊ. ತೆ ತಿನೆ ಯಾ ಮನೆ ತೆ ಗ್ವತ್ತ ನತ್ತಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ದಕ್ಹಿಯಳ್ಪರ ಬಿಜೆಕ್ಲೊ ಪೆತ್ರಾನೆ ದೆಕಿನ, ತುಬಿ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ವಾಲಾವೊಮಾನೊ ಯಕ್ಲೊ ವ್ಹೈ\"ಕದ್ಯೊ. ತೆಳಾಮಾ ಪೆತ್ರಾ ಎ ಮನಕ್ಹ \"ತ್ಯುನೊಮಾನೊ ಮಿ ನ್ಹವೈ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ವರಿ ಯಕ್ಕ ತಾಸಪರ ಬಿಜೆಕ್ಲೊ ಐನ ಪೆತ್ರಾನೆ ಆ ಮನಕ್ಹ ಕ್ಹರಿಜ಼ ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ವಾಲೊ ವ್ಹೈ ವರಿ ಆ ಗಲಿಲಾಯವಾಲೊಜ಼ ವ್ಹೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ತೆಳಾಮಾ ಪೆತ್ರಾ, ಎ ಮನಕ್ಹ \"ತು ಸು ಕವಾಡ್ಯೊಸ ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ \"ಕದ್ಯೊ. ಪೆತ್ರಾ ಹಜು಼ನ ಬೊಲ್ತೊ ರ‍್ಹತಾಮಾಜ಼ ಕುಕಡೊ ಬಾಂಗ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ತೆಳಾಮಾ ಯೆಸು ಪೆತ್ರಾನೆ ಪಾಚ಼ೊ ಫರಿನ ದೆಕ್ಯೊ. ಪಾಟೆ ಕುಕಡೊ ಬಾಂಗ ದಿವಾತಿ ಅಗ್ದುರಜ಼ ಮಾರಿ ವಿಚಾರಮಾ ತು ತನ ಸಲಾ ಮನೆ ವಳಕ ನತ್ತಿ ಕೈನ ಕಸಿ ಕೈನ ಯೆಸು ಕದಲ ಶೆ ಕರಲಿದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ಪಾಚಲ್ತೊ ಪೆತ್ರಾ ಭಾರೊ ಗೈನ ಘನ್ನೊ ರೊಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ಯೆಸುನೆ ಕೈದಾಲಾ ಸೈನಿಕೊ ತ್ಯುನೆ ಯೆಸು ಮ್ಹೊಡು ಝಾಕಿನ, ತಿನೆ ಮಾರಿನ, ");
INSERT INTO sle_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","\"ತುನೆ ಕುನ್ನ ಮಾರಯು? ಕೆ ಕೈನ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ತ್ಯುನೆ ಯೆಸುನೆ ಘನ್ನಾ ಕದ್ರೈನ ತಿಪರ ದೊಶ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ಮರ್ನಾ ದಿನ್ನೆ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಖಾಸ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ ಕ್ಹಾರಾ ಮಳಿನ, ಯೆಸುನೆ ಫೈಸಲೊ ಕರಾನೆ ಬಲೈ ಲಿನಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ತ್ಯುನೆ ಯೆಸುನೆ ತು \"ಕ್ರಿಸ್ತ ರ‍್ಹಯೊಮ ಹಮೊನೆ ಕೆ \"ಕದ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ, ಮಿ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಕದ್ಯೊತಬಿ ತುಮೆ ಬರೊಕ್ಹೊ ಕರತಾ ನೈ, ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ಮಿ ತುಮೊನೆ ಪುಚ್ಯೊ಼ತಬಿ ತುಮೆ ಮನೆ ಜ಼ವಾಬ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ತಿನಾ ಹುತಿ ಆಜ಼ತೊಜ಼ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಕ್ಹುದಾನಾ ಬಾಜು಼ಮಾ ಬೈಟಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ತ್ಯುನೆ ಕ್ಹಾರಾ ಜ಼ನಾ \"ತಿಮ್ಮ ರ‍್ಹಯುಮ ತು ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈಸು? ಕೈನ ಪುಚ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ, ಮಿಜ಼ ತೆ ವ್ಹೈ ತುಮೆಜ಼ ಕವಾಡ್ಯಾಸ್ತೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ತೆಳಾಮ ತ್ಯುನೆ ಹಮ್ನಾ ಅಪೊನೆ ಕಾ ಸಾಕ್ಷಿ ಚಾ಼ಯೆ? ತೆ ತಿಮ್ಮ ಕವಾನು ಅಪೆ ಐಕ್ಯಾತೊ \"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ವರಿ ತ್ಯಾ ಪಂಚ್ಯಾತಿನಾ ಹುತಿ ಕುಡಿನ ಆಯಲ ವಾಲಾ ಯೆಸುನೆ ಪಿಲಾತನಕನ ಬಲೈ ಲಿನಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ತ್ಯುನೆ ಯೆಸುಪರ ದೊಷ ಘಾಲಾನೆ ಶುರು ಕರ‍್ಯಾ ಆ ಮನಕ್ಹ ಹಮಾರಾ ಮನಕ್ಹೊನೆ ತಪ್ಪ ವಾಟಮಾ ನಿಂಜಾ಼ವಾನೆ ಕವಾಡ್ಯೊಸ. ಹಮೆ ಸಿಸರನೆ ಭುಭಾಡೊ ದಿವೊನಕೊ ಕೈನ ಎ ಕವಾಡ್ಯೊಸ. ತೆನೈಸೊ ಇನಾಕ್ಹು ಎಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಕೈಲಿವಾಡ್ಯೊಸ. ಇನಾಹುತಿ ಹಮೆ ಇನೆ ಧರಿನ ಲಾಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ತೆಳಾಮಾ ಪಿಲಾತನ ಯೆಸುನೆ \"ತು ಯಹುದ್ಯೊನೊ ರಾಜೊ಼ ವ್ಹೈಸು? ಕೈನ ಪುಚ್ಯೊ. ತೆಳಾಮಾ ಯೆಸು ತುಜ಼಼ ಕವಾಡ್ಯೊಸ್ತೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ಪಿಲಾತನ, ಖಾಸ ಯಾಜಕೊನೆ ವರಿ ಮನಕ್ಹೊನೆ\"ಮನೆ ಆ ಮನಕ್ಹಮಾ ಕಯೊಜ಼ ತಪ್ಪ ದಿಕ್ಹಾಡ್ಯು ನತ್ತಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ತೆ ವಾತೆ ತ್ಯುನೆ\"ಎ ಮನಕ್ಹ ಯುದಾಯಾ ಗಾಮ್ಮಾ ಉಪದೆಶ ಕರಿನ ಮನಕ್ಹೊನೆ ಭಡ್ಕಾಯೊಸ. ಗಲಿಲಾಯಮಾ ಶುರು ಕರಿನ ಎ ಹಮ್ನಾ ನ್ಹ್ಯಾ ಆಯೊಸ\" ಕೈನ ಹಗ್ಲೆಲ್ಲಾ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ಪಿಲಾತನ ಎ ಐಕಿನ, ಎ ಮನಕ್ಹ ಗಲಿಲಾಯ ವಾಲೊ ವ್ಹೈಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ಯೆಸು ಹೆರೊದನಾ ಅದಿಕಾರಮಾ ರ‍್ಹಯಲ ಗಾಮ ವಾಲೊ ವ್ಹೈ ಕೈನ ತಿಳದಿಲಿನ. ತೆ ಟೈಮ್ಮಾ ಹೆರೊದ ಯೆರುಸೆಲೆಮ್ಮಾ ವ್ಹತ್ತೊ. ತಿನಾಹುತಿ ಯೆಸುನೆ ಹೆರೊದಕನ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ಹೆರೊದ ಯೆಸುನೆ ದೆಕ್ತಾಮಾ ಘನ್ನೊ ಖುಶಿ ಥಯೊ, ಕಾಕದ್ಯಾಮ ತೆ ಯೆಸುನಾ ಹುತಿ ಕ್ಹಾರುಜ಼ ಐಕ್ಯೊತೊ ವರಿ ಯೆಸು ಕರಾನು ಅದ್ಭುತ ದೆಕು ಕೈನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ಹೆರೊದ ಯೆಸುನೆ ಘನ್ನಾ ಪ್ರಶ್ನೆ ಪುಚ್ಯೊ. ತೆಳಾಮಾ ಯೆಸು ಯಕ್ಕಬಿ ಜ಼ವಾಬ ದಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ಖಾಸ ಯಾಜಕೊ ವರಿ ಶಾಸ್ತ್ರಿಯೊ. ತ್ಯಾಜ಼ ಹುಬ್ರಯಾತಾ. ತ್ಯುನೆ ಯೆಸುನಾ ವಿರುದ್ದ ವದ್ರಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ತೆಳಾಮಾ ಹೆರೊದ ವರಿ ಸೈನಿಕೊ ಯೆಸುನೆ ಕದ್ರಾಯಾ ತ್ಯುನೆ ಯೆಸುನೆ ರಾಜಾ಼ವೊನಾ ವಣ್ಣಾ ಘಾಲಿನ ಹಿನಾಯಾ. ಪಾಚಾ಼ತಾ ಹೆರೊದ ಯೆಸುನೆ ಪಿಲಾತನಕನ ಮೊಕ್ಕಲಿ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ಪೈಲಾ ಪಿಲಾತನ ವರಿ ಹೆರೊದ ದುಶ್ಮನೊ ವ್ಹತ್ತಾ. ವರಿ ತೆ ದಿನತಾ ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ದೊಸ್ತೊ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ಪಿಲಾತನ ಖಾಸ ಯಾಜಕೊನೆ ಯೆಹುದಿನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊನೆ ಕ್ಹಾರಾ ಜ಼ನಾವೊನೆ ಬಲೈನ, ");
INSERT INTO sle_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ತ್ಯುನೊನೆ\"ತುಮೆ ಆ ಮನಕ್ಹನೆ ಮಕನ ಬಲೈ ಲಾಯಾಸ. ಎ ಮನಕ್ಹೊನೆ ತಪ್ಪ ವಾಟಪರ ಚ಼ಲಾವಾಡ್ಯೊಸ ಕೈನ ಕದ್ಯಾ. ವರಿ ಮಿ ತಮಾರಾ ಕ್ಹಾಮೊ ಇನೆ ವಿಚಾರ ಕರ‍್ಯೊ, ಇಮಾ ಮಿ ಸುಜ಼ ತಪ್ಪ ದಿಕ್ಹ್ಯು ನೈ. ತುಮೆ ಇಪರ ಘಾಲಾನು ದೊಶ ಹೊಂದಾಡ್ಯು ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ಎನೈಸೊ ಹೆರೊದನೆಬಿ ಎ ಮನಕ್ಹಮಾ ಸುಜ಼ ತಪ್ಪ ದಿಕ್ಹ್ಯು ನೈ. ಹೆರೊದ ಯೆಸುನೆ ಹಮೊಕನ ವರಿ ಮೊಕಲ್ಯೊಸ, ದೆಕೊ ಯೆಸುಮಾ ಸುಜ಼ ತಪ್ಪ ನತ್ತಿ ಕರ‍್ಯೊ. ತಿನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ಥೌ ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ತಿನಾಹುತಿ ಮಿ ಇನೆ ನ್ಹಾನಿ ಶಿಕ್ಷಾದಿನ ಛೊಡಿಪಾಡುಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ಹರಿ ಯಕ್ಕ ಫಸ್ಕಾನಾ ಸನ್ಮಾ ರಾಜ್ಯಪಾಲ ಥಯಲ ಪಿಲಾತನ ಮನಕ್ಹೊ ಮಾಂಗಲ ತೆ ಕೈದಿನೆ ಛೊಡಾನಿ ಪದ್ದತ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ತೆನೈಸೊ ಮನಕ್ಹೊ ಯೆಸುನೆ ಜೊ಼ರ ವದ್ರಿನ ಮರವಾನಿ ಶಿಕ್ಷಾ ದೆ ಕೈನ ಕವಾಡಾತಾ. ವರಿ ಬರಬ್ಬನೆ ಛೊಡ ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(ತೆ ಜೆಲಮಾ ವ್ಹತ್ತೊ ತೆ ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಖಲಾಸ ಕರ‍್ಯೊತೊ) ");
INSERT INTO sle_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ಪಿಲಾತನ ಯೆಸುನೆ ಛೊಡಿಪಾಡು ಕೈನ ವ್ಹತ್ತೊ. ತಿನಾಹುತಿ ಯೆಸುನೆ ಛೊಡಿಪಾಡು ಕೈನ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ತೆ ನೈಸು ತ್ಯುನೆ ವರಿ ತಿನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ದೆಕಿನ ವರಿ ಜೊ಼ರ ವದ್ರ್ಯಾ. ವರಿ ತಿನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾ ಶಿಲುವಿಪರ ಚ಼ಡಾ\"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ತನ್ವಾ ಸಲಾ ಪಿಲಾತನ ಮನಕ್ಹೊನೆ, ಕಾ? ತೆ ಸು ತಪ್ಪ ಕರ‍್ಯೊಸ? ತೆ ತಪ್ಪ ಕರಲವಾಲೊ ನ್ಹವೈ. ತಿನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ದಿವಾನೆ ತಿಮಾ ಸುಜ಼ ತಪ್ಪ ದಿಕ್ಹಾಡು ನತ್ತಿ. ತಿನಾ ಹುತಿ ತಿನೆ ನ್ಹಾನಿ ಶಿಕ್ಷಾ ದಿನ್ನ ಛೊಡಿ ಪಾಡುಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ವರಿ ಮನಕ್ಹೊ ವದ್ರಾನು ದೆಕಿನ ಪಿಲಾತನ ಯೆಸುನೆ ಶಿಲುವಿಪರ ಚ಼ಡೈನ ಮರವಾನಿ ಶಿಕ್ಷಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ಪಿಲಾತನ ತ್ಯುನೆ ಮಾಂಗಲ ತೆ ಪುರಾ ಕರಾನೆ ಒಪ್ಪಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ಪಿಲಾತನ, ಬರಬ್ಬನೆ ಛೊಡಿನ ಯೆಸುನೆ ಶಿಲುವಿಪರ ಘಾಲಾಹುತಿ ಮನಕ್ಹೊನಾ ಹತಮಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ಸೈನಿಕೊ ಯೆಸುನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾವಾನೆ ನಿಂಜಾ಼ತಾಮಾ ಖೆತರಮಾತೊ ಗಾಮ್ಮಾ ಆತೊ ರ‍್ಹಯಲ ಸಿಮೊನ ಕವಾಲಾನೆ ದೆಕ್ಯಾ. ಸಿಮೊನ ಕವಾಲೊ ಸಿರೆನ ಗಾಮವಾಲೊ ವ್ಹತ್ತೊ. ಯೆಸುನಿ ಶಿಲುವಿ ಉಚೈಲಿನ ಯೆಸುನಾ ಪಾಚೊ಼-ಪಾಚೊ಼ ಆ ಕೈನ ವತ್ತಾಯ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಪಾಚಾ಼-ಪಾಚಾ಼ ಆವಾಡಾತಾ. ಮ್ಹೊಟು ಗುಂಪ ಥೈನ ಮಳಲ ಹೆಣ ಮನಕ್ಹೊ ಘನ್ನಿಯೊ ರವಾಡಿಯ್ಯುತೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ಯೆಸು ತೆ ಹೆಣ ಮನಕ್ಹೊನೆ \"ಯೆರೊಸೆಲಿಮಿನಿಯೊ ಹೆಣ ಮನಕ್ಹೊ, ಮಾರಾ ಹುತಿ ರವೊ ನಕೊ ತಮಾರಾ ಹುತಿ ತಮಾರಾ ಬಚ್ಚಾ಼ವೊನಾ ಹುತಿ ರವೊ\" ");
INSERT INTO sle_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ಬಚ್ಚಾ಼ ನೈಸೊ ವಾಲಿಯೊ ಚೊ಼ಕಿಯೊ ವ್ಹೈ ಬಚ್ಚಾ಼ವೊನೆ ಛಾತಿನು ದುದ್ದ ನೈ ಪಿಲಾಯಲ ವಾಲಿಯೊ ಚೊ಼ಕಿಯೊ ವ್ಹೈ. ಕೈನ ಮನಕ್ಹೊ ಕವಾನು ಟೈಮ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ತೆಳಾಮಾ ಮನಕ್ಹೊ ಡೊಂಗರನೆ ಮಪರ ಪಡ! ಕೈನ ಡೊಂಗರೊ ಹಮೊನೆ ಝಾಕಿ ಪಾಡಾದೆ ಕೈನ ವದ್ರಸ. ");
INSERT INTO sle_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ಮನಕ್ಹೊ ಝಾಡ ಚೊ಼ಕು ರ‍್ಹತಾಮಾ ಇಮ್ಮ ಕರಸ. ವರಿ ಕುಕ್ಹಾಯಲ ಟೈಮ್ಮಾ ಕಿಮ ರ‍್ಹಸ? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ಯೆಸುನಾ ಕ್ಹಾತೆ ಬೆ ಚ್ವಟ್ಟಾವೊನೆ ಮರವಾನಿ ಶಿಕ್ಕಶಯಾ ದಿದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ಯೆಸುನೆ ವರಿ ಬೆ ಚ್ವಟ್ಟಾವೊನೆ ತ್ಯುನೊನೆ \"ಕಪಾಲ \"ಕವಾನಿ ಜ಼ಗಾಪರ ಬಲೈ ಲಿನಗಯಾ. ತ್ಯಾ ಯೆಸುನೆ ಶಿಲುವಿಪರ ಚ಼ಡಾಯಾ ಬೆ ಚ್ವಟ್ಟಾವೊಮಾ ಯಕ್ಲಾನೆ ಯೆಸುನಾ ಶಿದಾಬಗಲ ಯಕ್ಲಾನೆ ಡಾವಾ ಬಗಲ ಚ಼ಡಾಯಾ, ");
INSERT INTO sle_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ತೆಳಾಮ ಯೆಸು, ಬಾ, ಅವ್ನೊನೆ ಮಾಫ ಕರ. ಅವನೆ ಸು ಕರಾಡಾಸ ತಿಳದ್ಯಾ ನತ್ತಿ \"ಕೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ. ಸೈನಿಕೊ ಚಿಟಿಯೊ ಘಾಲಿನ ಯೆಸುನಾ ವಣ್ಣಾ ಕಿನೆ-ಕಿನೆ ವಾಟಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ಮನಕ್ಹೊ ದೆಕತಾ ತ್ಯಾ ಹುಬ್ರಯಾತಾ. ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಕದ್ರಾಯಾ. ತ್ಯುನೆ ಯೆಸುನೆ ತು ಕ್ಹುದಾ ಇನಿಲಿದಲ ಕ್ರಿಸ್ತ ರ‍್ಹಯೊಮ ತಿನಾಕ್ಹು ತೆ ವಚಾ಼ಡಿಲಿವಾದೆ. ಎ ಬಿಜಾ಼ವೊನೆ ವಚಾ಼ಡಲ ವಾಲೊ ನ್ಹವೈಸು? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ಸೈನಿಕೊ ಯೆಸುನೆ ಕದ್ರಾಯಾ. ತ್ಯುನೆ ಯೆಸುಕನ ಐನ. ದಕ್ಹು ಖಾಟು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಪಿವಾನೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ವರಿ ಯಹುದ್ಯನೊ ರಾಜೊ಼ ರ‍್ಹಯೊಮ, ತಾರಾ ಕ್ಹು ತು ವಚಾ಼ಡಿಲೆ \"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","(ಶಿಲುಬಿನಾ ಉಪ್ಪರ, ಎ ಯಹುದ್ಯೊನೊ ರಾಜೊ಼ ವ್ಹೈ ಕೈನ, ಕೈನ ಬರದ್ಯಾತಾ) ");
INSERT INTO sle_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ತ್ಯಾ ಚ಼ಡಾಯಲ ಬೆ ಚ್ವಟ್ಟಾವೊಮಾನೊ ಯಕ್ಲೊ ಯೆಸುನೆ \"ತು ಕ್ರಿಸ್ತ ನ್ಹ ವ್ಹೈಸು? ತಿಮ್ಮ ರ‍್ಹಯುಮ ತಾರಾಕ್ಹು ತು ವಚಾ಼ಡಿ ಲೆ! ವರಿ ಹಮೊನೆಬಿ ವಚಾ಼ಡ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ತೆನೈಸೊ ತೆ ಬಿಜೆಕ್ಲೊ ಚ್ವಟ್ಟೊ. ತಿನೆ ಭುಚ಼್ಕಾಡ್ಯೊ. ತು ಕ್ಹುದಾ ಕ್ಹು ಭುಚ಼ಕ್ತಾ ನೈಸು? ತುನೆ ಬಿ ಎಜ಼ ಶಿಕ್ಷಾ ಥೈಸ! ");
INSERT INTO sle_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ತುಬಿ ಮಿ ಪಾಪಿಯೊ ವ್ಹೈ. ಅಪೊನೆ ಅಪ್ನಾ ಪಾಪನಾ ಹುತಿ ಶಿಕ್ಷಾ ದಿದ್ಯಾಸ. ವರಿ ಎ ಮನಕ್ಹ (ಯೆಸು) ಕಯುಜ಼ ತಪ್ಪ ಕರ‍್ಯೊ ನತ್ತಿ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ಪಾಚಲ್ತೊ ತೆ ಚ್ವಟ್ಟೊ ಯೆಸುನೆ ತಾರೊ ರಾಜ್ಯ ಆತಾಮಾ ಮನೆ ಶೆ ಕರಿಲೆ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ ಐಕ! ಮಿ ಕ್ಹರಿಜ಼ ಕೌಸ. ಆಜಾ಼ನಾ ದಿನ್ನೆಜ಼ ತು ಮಾರಾ ಕ್ಹಾತೆ ಸ್ವರ್ಗಮಾ ರ‍್ಹಸಿ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ತೆಕ್ಲಾಮಾಜ಼಼ ದುಪಾರ ಥೈಗೈತಿ ವರಿ ಇಡಿ ಭುಲೊಕ್ಪರ ಅಂದಾರು ಥೈಗೈಯುತು. ತೆ ಅಂದಾರು ದುಪಾರನಾ ಬಾರಾ ವಾಸ್ತಾತು ತನ, ವಾಜೆ ಲಕ್ಕಾ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ಸುರ್ಯಾನು ಉಜಾಲುಜ಼ ನ್ಹೊತು! ದೆವಾಲಯನೊ ಪಡದೊ ಫಾಟಿನ ಬೆ ಭಾಗ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ಪಾಚಲ್ತೊ ಯೆಸು\"ಬಾ, ಮಾರಿ ಆತ್ಮಾ ತಾರಾ ಹತೊಮಾ ವಪ್ಸುಸ, ಕೈನ ಝೊರ ವದ್ರಿನ ಜ಼ಲಮ ಛೊ಼ಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ತ್ಯಾ ರ‍್ಹಯಲ ಸೈನಿಕೊನೊ ಅದಿಕಾರಿ ತಿಮ್ಮ ಥಯಲ ದೆಕಿನ\"ಎ ಮನಕ್ಹ ಕ್ಹರಿನೊಜ಼ ವ್ಹೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು\" ಕೈನ ಕ್ಹುದಾನಿ ಸ್ತುತಿ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ಎ ಕ್ಹಾರು ದೆಕಾನೆ ಗಾಮತಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಆಯಾತಾ. ವರಿ ಎ ಕ್ಹಾರು ದೆಕಿನ ಘನ್ನಾ ದುಕಿ ಥೈನ ಫರಿನ ತ್ಯುನಾ ಗಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ಯೆಸುನಾ ದೊಸ್ತೊ ಬಿ ತ್ಯಾ ವ್ಹತ್ತಾ. ಗಲಿಲಾಯತಿಯೊ ಯೆಸುನಾ ಪಾಚಿ಼ಯೊ ಆಯಲ ಹೆಣ ಮನಕ್ಹೊಬಿ ತ್ಯಾ ವ್ಹತ್ತಿಯೊ. ತ್ಯುನೆ ದುರತಿಯೊಜ಼ ಎ ಕ್ಹಾರು ದೆಕಾಡಿಯೊತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ಅರಿಮಥಾಯ ಕವಾನು ಯೆಹುದಿಯೊನು ಯಕ್ಕ ಗಾಮ ವ್ಹತ್ತು. ಯೊಸೆಫ ಎಜ಼ ಗಾಮವಾಲೊ ಚೊ಼ಕೊ ವ್ಹತ್ತೊ. ಎ ಕ್ಹುದಾನಾ ಹುತಿ ಕ್ಹಾರು ತಿಳದಿಲಿದ್ಯೊತೊ. ವರಿ ಕ್ಹುದಾನು ರಾಜ್ಯ ಆವಸ ಕವಾನು ಇನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ಯೊಸೆಫ ಯಹುದ್ಯೊನೊ ಮನಕ್ಹೊಪರ ಮ್ಹೊಟೊ ವ್ಹತ್ತೊ. ವರಿ ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಖಲಾಸ ಕರಿಯೆ ಕೈನ ಕತಾಮಾ ತೆ ವಾತೆ ವಪ್ಯೊನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ಯೆಸುನೊ ಮರಲ ಅಂಗ ದಿಲಾ ಕೈನ ಯೊಸೆಫ ಪಿಲಾತನಕನ ಮಾಂಗ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ಪಾಚಲ್ತೊ ಯೊಸೆಫ ಯೆಸುನು ಅಂಗ ಶಿಲುವಿಪರತೊ ಹೆಟೊ ಉತಾರಿನ ನರಮ ಪ್ಹಡಕಾಮಾ ಯೆಸುನೆ ಸುತ್ತಿನ ದಗಡಾಮಾ ಕಾಡಲ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲ್ಯೊ. ತೆ ಮಜಾ಼ರಮಾ ಬಿಜಾ಼ ಕಿನೆಜ಼಼ ಘಾಲ್ಯಾ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ವರಿ ತೆ ದಿನ್ನ ಸಬ್ಬತನೊ ತಯ್ಯಾರನೊ ದಿನ್ನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ಗಲಿಲಾಯತಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ಆಯಲ ಹೆಣ ಮನಕ್ಹೊ ಯೊಸೆಫನಾ ಪಾಚಿ಼ಯೊ ಗಯ್ಯೊ. ತ್ಯುನೆ ಯೆಸುನೆ ಮುಕ್ಕಕಲ ಮಜಾ಼ರ ದೆಕಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ಪಾಚಾ಼ತಿಯೊ ತೆ ಹೆಣ ಮನಕ್ಹೊ ಯೆಸುನಾ ಅಂಗೆ ಲಗಾಡಾನಾ ಹುತಿ ಬಾಸನು ತೆಲ ಲಾವಾನಾ ಹುತಿ ಗಯ್ಯೊ. ಸಬ್ಬತ ದಿನಮಾ ತ್ಯುನೆ ಅರಾಮ ಕರಿಯೊ. ಮೊಶೆನು ಧರಮ ಶಾಸ್ತ್ರನಾ ಪ್ರಕಾರ ಸಬ್ಬತನಾ ದಿನಮಾ ಮನಕ್ಹೊ ಅರಾಮ ಕರಾನು ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ಐತ್ವಾರನಾ ಪಾಟೆ ಹಜ಼ುನ ಮಬ್ಬ ರ‍್ಹತಾಮಾ ಯೆಸುನೆ ಮ್ಹೆಲಲ ಮಜಾ಼ರಕನ ಹೆಣ ಮನಕ್ಹೊ ಯೆಸುನಾ ಅಂಗೆ ಲಗಾಡಾನೆ ಬಾಸನು ತೆಲ ತಯ್ಯಾರ ಕರಿನ ಲಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ಮಜಾ಼ರನೆ ಝಾಕಲ ದಗ್ಡೊ ಸರಕಾಯಲ ದೆಕಿನ ತ್ಯುನೆ ಮ್ಹೈ ಆಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ವರಿ ತ್ಯುನೊನೆ ಯೆಸುನು ಮರಲ ಅಂಗ ದಿಕ್ಹ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ತೆ ಹೆಣ ಮನಕ್ಹೊ ಘಾಬ್ರಿಯೊ ಥಯ್ಯೊ. ವರಿ ಘನ್ನಾ ಮಿಂಚಾ಼ನಾ ವಣ್ಣಾ ಘಾಲ್ಲಿನ ಬೆ ಜ಼ನಾ ತ್ಯುನೊಕನ ಹುಬ್ರಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ತೆ ಹೆಣ ಮನಕ್ಹೊ ಘನ್ನಿಯೊ ಭುಚಕಿನ ತ್ಯುನಾ ಮ್ಹೊಡಾ ಹೆಟಾ ಘಾಲ್ಲಿನ ಹುಬ್ರಯ್ಯೊ. ತೆ ದುತೊ, ಜಿವ್ತಾ ರ‍್ಹಯಲ ವಾಲಾನೆ ತುಮೆ ನ್ಹ್ಯಾ ಕಾ ಹುಡಕಾಡಿಯೊಸ? ಎ ಮರಲ ವಾಲಾವೊನೆ ಮುಕ್ಕಕಾನಿ ಜ಼ಗಾ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ಯೆಸು ನ್ಹ್ಯಾ ನತ್ತಿ. ತೆ ಜಿವ್ತೊ ಥೈನ ಉಟ್ಯೊಸ! ತೆ ಗಲಿಲಾಯಮಾ ರ‍್ಹತಾಮಾ ಕದಲ ವಾತ ತುಮೊನೆ ಶೆ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಕೆಟ್ಟ ಮನಕ್ಹೊನಾ ಹತಮಾ ವಪ್ಸಿನ; ಶಿಲುವಿಪರ ಚ಼ಡಾಯಿನ ಖಲಾಸ ಕರಿನ ತನ ದಿನ್ಪರ‍ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆವಸ. ಕೈನ ಯೆಸು ಕದ್ಯೊ ನತ್ತಿ ಸು\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ತೆಳಾಮಾ ತೆ ಹೆಣ ಮನಕ್ಹೊ ಯೆಸು ಕದಲ ವಾತ ಶೆ ಕರಲಿದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ತೆ ಹೆಣ ಮನಕ್ಹೊ ಮಜಾ಼ರಮಾತಿಯೊ ಗೈನ ಯೆಸುನಾ ಗ್ಯಾರಾ ಶಿಷ್ಯಾವೊಕನ ಗಯ್ಯೊ, ತೆ ಹೆಣ ಮನಕ್ಹೊ ಮಜಾ಼ರಮಾ ಥಯಲ ಪುರಾ ತಿನಾ ಅಪೊಸ್ತಲೊಕನ ಕದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ತೆ ಹೆಣ ಮನಕ್ಹೊ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ; ಮಗ್ದಲನಿ ಮರಿಯಳ, ಯೊಹಾನನಿ, ಯಾಕೊಬನಿ ಯಾ ಥಯಲ ಮರಿಯಳ ವರಿ ಬಿಜಿ಼ಯೊ ಹೆಣ ಮನಕ್ಹೊ. ಅಪೊಸ್ತಲೊಕನ ತ್ಯುನೆ ಕ್ಹಾರು ಕದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ತೆನೈಸೊ ತಿನಾ ಅಪೊಸ್ತಲೊ ತೆ ವಾತೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ತಿವ್ನಿವಾತೊ ಮಸ್ಕಿರಿ ಲಿಂಗತ ಲಾಗಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ಪೆತ್ರಾ, ತ್ಯುನಿಯೊ ವಾತೊ ಕ್ಹರಿ ವ್ಹೈಸು ಕೈನ ದೆಕಾಹುತಿ ಯೆಸುನಿ ಮಾಜಾ಼ರ ಕನ ನ್ಹಾಟ್ಯೊ. ತೆ ಮಜಾ಼ರಕನ ಗೈನ ಮ್ಹೈ ಗೈನ ದೆಕ್ತಾಮಾ ಯೆಸುನೆ ಸುತ್ತಲ ವಣ್ಣಾ ಯಕ್ಕಜ಼ ವ್ಹತ್ತಾ. ತೆ ದೆಕಿನ ಪೆತ್ರಾ ಘಾಬ್ರೊ ಥೈನ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ತೆ ದಿನಮಾಜ಼ ಯೆಸುನಾ ಶಿಷ್ಯಾವೊಮಾನಾ ಬೆ ಜ಼ನಾ ಎಮ್ಮಾಹು ಕವಾನಾ ಗಾಮೆ ಚಾ಼ಲ್ಯಾತಾ. ತೆ ಗಾಮಾ ಯೆರುಸೆಲಿಮತು ಕ್ಹಾತ ಮೈಲ ದುರ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ತ್ಯುನೆ ಥಯಲ ಕ್ಹಾರು ಬೊಲ್ಲೆತಾ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊಕನ ಐನ, ತ್ಯುನಾ ಕ್ಹಾತೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","(ತ್ಯುನೊನೆ ಯೆಸು ವ್ಹೈ ಕವಾನು ಗ್ವತ್ತ ನ್ಹೊತು) ");
INSERT INTO sle_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ಯೆಸು ತ್ಯುನೊನೆ\"ತುಮೆ ಕೈ ವಿಷಯಮಾ ಬೊಲ್ಲಿವಾಡ್ಯಾಸ? ಕೈನ ಪುಚ್ಯೊ. ತಿಮ್ಮಕತಾ ತ್ಯುನೆ ತ್ಯಾಜ಼ ಹುಬ್ರಯಾ. ತ್ಯುನಾ ಮ್ಹೊಡಾ ದುಖ ಕ್ಹು ಭರಿಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ತ್ಯುನೊಮಾ ಕ್ಕಲೆಯೊಫಾ ಕವಾಲೊ\"ತೆ ಯೆರುಸೆಲೆಮಾ ಥಯಲ ಕ್ಹಾರು ನೈ ತಿಳದಲವಾಲೊ ತು ಯಕ್ಲೊ ವ್ಹೈಸು\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ಯೆಸು ತ್ಯುನೊನೆ\"ತುಮೆ ಶಾನಾ ಹುತಿ ಬೊಲ್ಲಿವಾಡ್ಯಾಸ? ಕೈನ ಪುಚ್ಯೊ. ತ್ಯುನೆ ತಿನೆ, ಹಮೆ ನಜ಼ರೆತನಾ ಯೆಸುನಾ ಹುತಿ ಬೊಲ್ಲಿವಾಡ್ಯಾಸ. ತೆ ಕ್ಹುದಾನಾ ಕಂತೊ. ವರಿ ಮನಕ್ಹೊನಾ ನಜ಼ರಮಾ ಮ್ಹೊಟೊ ಪ್ರವಾದಿ ಹೊತೊ. ತೆ ಘನಿಯೊ ಸಂಗತಿಯೊ ವರಿ ಘನ್ನಾ ಅದ್ಭುತೊನಾ ಕಾಮೊ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ಹಮಾರಾ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ವರಿ ಪ್ರದಾನ ಯಾಜಕೊ. ತಿನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ದಿಲಾಯಾ ವರಿ ತಿನೆ ಶಿಲುವಿಪರ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ಯೆಸು ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊ ಬಂದನಮಾತೊ ಛೊಡಾತೊತೊ ಹಮೆ ಕೈಲೆತಾತಾ. ತೆಕ್ಲಾಮಾಜ಼಼ ಎಕ್ಹಾರು ಥೈಗಯು. ಯಕ್ಲಾಮಜ಼ ವರಿ ಯಕ್ಕ ಸಂಗತಿ ಥೈಗೈಸ. ತೆ ಮರಿನ ತನ ದಿನ್ನ ಥೈ ಗಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ಆಜ಼ ಹಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಹೆಣ ಮನಕ್ಹೊ ಘಾಬ್ರು ಥಾವಾನಿಯೊ ವಾತೊ ಕದಿಯೊ. ಪಾಟೆ ನಸಕೆ ತೆ ಹೆಣ ಮನಕ್ಹೊ. ಯೆಸುನೆ ಮ್ಹೆಲಲ ಮಜಾ಼ರಕನ ಗಯ್ಯೊತ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ತ್ಯಾ ತ್ಯುನೆ ಯೆಸುನು ಅಂಗ ದಿಕ್ಹ್ಯು ನೈ. ತ್ಯುನೆ ಫರಿನೆ ಐನ ಹಮೊನೆ ದೆವದುತೊ ದಿಕ್ಹ್ಯಾ ವರಿ ತೆ ದೆವದುತೊ ಯೆಸು ಮರಯೊ ನತ್ತಿ ಕೈನ ಹಮೊನೆ ಕದ್ಯಾ ಕೈನ ಕದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ತಿನಾಹುತಿ ಹಮೊಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ ಯೆಸುನಿ ಮಜಾ಼ರಕನ ಗಯಾ. ತೆ ಹೆಣ ಮನಕ್ಹೊ ಕದಲ ಲಿಂಗತಜ಼ ತೆ ಮಜಾ಼ರ ಕ್ಹಾಲಿ ವ್ಹತ್ತಿ. ತ್ಯುನೆ ಸುತ್ತೆ ಮುತ್ತೆ ದೆಕ್ಯಾ. ವರಿ ತ್ಯುನೊಮಾ ತೆ (ಯೆಸು) ಕಿನೆಜ಼಼ ದಿಕ್ಹ್ಯೊ ನೈ. ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ತೆಳಾಮ ಯೆಸು ತ್ಯುನೊನೆ ಕದ್ಯೊ. ತುಮೆ ಗ್ಯಾನ ನೈಸೊವಾಲಾ ವ್ಹೈ. ವರಿ ಕ್ಹರಿ ತುಮೊನೆ ವಳಕಾನೆ ಥಾತು ನೈ. ಪ್ರವಾದಿಯೊ ಕವಾನು ಕ್ಹಾರು ತುಮೆ ನಂಬು. ");
INSERT INTO sle_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ಕ್ರಿಸ್ತ ತಿನಿ ಮಹಿಮಾ ದೆಕಾಡಾತಿ ಅಗ್ದುರ ಹವಾ ತ್ರಾಸೊ ಅನುಭವಿಸು ಕೈನ ಪ್ರವಾದಿಯೊ ಕದ್ಯಾಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ಪಾಚಲ್ತೊ ಯೆಸು ತಿನಾ ಹುತಿ ಮೊಶೆನಾ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಹರಿ ಯಕ್ಕ ಕದ್ಯೊ. ಯೆಸು ಮೊಶೆನು ಗ್ರಂಥತೊ. ಶುರು ಕರಿನ ತಿನಾ ಹುತಿ ಪ್ರವಾದಿಯೊ ಕದಲ ಕ್ಹಾರು ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ತ್ಯುನೆ ಹಮ್ಮಾಹು ಕವಾನಾ ಗಾಮನಾ ನಜಿ಼ಕ ಆತಾಮಾ. ತೆ ಅಗೊ ಗಯಲಲಿಂಗತ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ತೆನೈಸೊ ತ್ಯುನೆ ಯೆಸುನೆ ಬಲೈನ ಹಮ್ನಾ, ರಾತ ಥೈಗೈಸ ಹಮಾರಾ ಕ್ಹಾತೆ ನ್ಹ್ಯಾಜ಼ ರ‍್ಹೆ ಕೈನ ತಿನೆ ಕೈಲಿದ್ಯಾ. ತಿನಾ ಹುತಿ ತೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ತೆ ಗಾಮ್ಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ಯೆಸು ತಿವ್ನಾ ಕ್ಹಾತೆ ರೊಕ್ಲೊ ಖಾವಾನೆ ಬೈಟ್ಯೊ. ತೆ ರೊಕ್ಲೊ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕೈನ ತೆ ಭಾಗಿನ ತ್ಯುನೊನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ತೆಳಾಮಾ ತ್ಯುನೆ ಯೆಸುನೆ ವಳಕ್ಯಾ. ತೆನೈಸೊ ತ್ಯುನೆ ವಳಕ್ಕತಾಮಾ ಯೆಸುನೆ ಗ್ವತ್ತ ಥೈನ ತ್ಯುನಾ ಡೊಳೆ ದಿಕ್ಹೆ ನೈಸೊ ಮಾಯಾ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ\"ತೆ ಅಪ್ನಾ ಕ್ಹಾತೆ ಬೊಲ್ತಾಮಾ ಅಪೊಮಾ ಆಗ ಲಾಗಲ ಲಿಂಗತ ಥೈನೈ? ಪವಿತ್ರ ಗ್ರಂಥಮಾ ರ‍್ಹಯಲ ಕ್ಹರಿಮಾನು ಮತ್ಲಬ್ ತೆ ಕತಾಮಾ ಘನ್ನು ಚೊ಼ಕು ಲಾಗ್ಯುನೈ? ");
INSERT INTO sle_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ತೆಳಾಮಾಜ಼ ತ್ಯುನೆ ಉಟಿನ ಯೆರೊಸೆಲಿಮೆ ಗಯಾ. ಯೆರುಸೆಲೆಮಾ ತಿನಾ ಕ್ಹಾರಾ ಶಿಷ್ಯಾ ಮಳಿನ ಆಯಾ. ಗ್ಯಾರಾ ಶಿಷ್ಯಾ ವರಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಮನಕ್ಹೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ಪ್ರಭು (ಯೆಸು) ಮರಲ ವಾಲಾವೊಮಾತೊ ಕ್ಹರಿಮಾಜ಼ ಜಿವ್ತೊ ಥೈನ ಉಟ್ಯೊಸ! ತೆ ಪೆತ್ರಾನೆ ದಿಕ್ಹ್ಯೊಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ತೆಳಾಮಾ ವಾಟ್ಮಾ ಜಾ಼ವಾಲಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ಥಯಲ ತ್ಯುನೆ ತ್ಯುನೊಕನ ಕದ್ಯಾ. ವರಿ ಹಮೆ ತೆ ರೊಕ್ಲೊ ಭಾಗತಾಮಾ ತಿನೆ ವಳಕ್ಯಾ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ತ್ಯುನೆ ಭಂಬಿಜ಼಼ನಾ ತೆ ಕ್ಹಾರು ಕತಾಮಾ, ತ್ಯುನಾ ವಚ಼ಮಾ ಯೆಸು ಐನ ತುಮೊನೆ ಚೊ಼ಕು ಥಾವಾದೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ತೆಳಾಮಾ ಶಿಷ್ಯಾ. ತ್ಯುನೊನೆ ಭೆ ವಾಟ್ಯೊ. ಎ ಕೆಟ್ಟ ಆತ್ಮಾ ವಸೆ ಕೈನ ತಿಳದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ವರಿ ಯೆಸು, ತ್ಯುನೊನೆ ತುಮೆ ಗಲಿ ಬಿಲಿ ಥಯಾಸ? ತುಮೆ ಡೊಳೆ ದೆಕಿನಬಿ ಕಾ ಸಂಶ್ಯೊಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ಮಾರಾ ಹತೊ ವರಿ ಮಾರಾ ಪಗೊ ದೆಕೊ. ಮಿಜ಼ ವ್ಹೈ! ಮನೆ ಮುಟ್ಟೊ. ಮಾರು ಜಿವ್ತು ಅಂಗ ದೆಕೊ. ಕೆಟ್ಟ ಆತ್ಮಾನೆ ಇಮ್ಮ ಅಂಗ ರ‍್ಹತು ನೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ಯೆಸು ಎ ಕದಲ್ಪರ, ಹತೊಮಾ ಪಗೊಮಾ ರ‍್ಹಯಲ ದುಕ್ಕಕೊ ದೆಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ತೆಳಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ಘಾಬ್ರಾಥಯಾ ವರಿ ತ್ಯುನೆ ಜಿವ್ತೊ ಥಯಲ ದೆಕಿನ ಘನ್ನಾ ಖುಶಿ ಥಯಾ. ವರಿಬಿ ತ್ಯುನೆ ಬರೊಕ್ಹೊ ಕರಾನೆ ಥಯು ನೈ. ಯೆಸು ತ್ಯುನೊನೆ ತುಮೊಕನ ಖಾವಾನೆ ಸುಬಿ ಅನ್ನ ಛೆಸು? ರ‍್ಹಯುಮ ಮನೆ ದಿವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ತ್ಯುನೆ ಬಳಲ ಮಚ್ಲಿ಼ ತಿನೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ಶಿಷ್ಯಾವೊನಾ ಡೊಳಾ ಕ್ಹಾಮೊ ಯೆಸು ತೆ ಮಚ಼ಲಿ ಲಿನ ಖಾದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ಯೆಸು ತ್ಯುನೊನೆ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಶೆಕರಿಲಿವೊ. ಮಾರಿ ವಿಷಯಮಾ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರಮಾ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥಮಾ, ಕಿರತನೆಮಾ ಬರ್ದಲ ಹರಿ ಯಕ್ಕ ಸಂಗತಿಯೊ ಪುರಾ ಥೌ ಕೈನ ಮಿ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ಪಾಚಲ್ತೊ ಯೆಸು ಪವಿತ್ರ ಗ್ರಂಥಮಾ ರ‍್ಹಯಲ ತಿನಾ ಹುತಿ ಬರ್ದಲ ಶಿಷ್ಯಾವೊನೆ ತಿಳಶ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ಪಾಚಲ್ತೊ, ಯೆಸು ತ್ಯುನೊನೆ \"ಕ್ರಿಸ್ತ ಮರಿನ ತನ ದಿನ್ಪರ‍ ತೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆವಸ ಕೈನ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ಎಕ್ಹಾರು ಪುರಾ ಥಾವಾನು ತುಮೆ ದೆಕ್ಯಾಸ. ತುಮೆಜ಼ ಇನೆ ಸಾಕ್ಷಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ತುಮೆ ಮನಕ್ಹೊಕನ ಜಾ಼ವೊ, ತ್ಯುನಾ ಪಾಪೊನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾಬಗಲ ಫರಾಲಾವೊನೆ ಪಾಪ ಮಾಫ ಥಾವಸ ಕೈನ ಕವೊ. ತುಮೆ ಸುವಾರ್ತೆ ಯೆರುಸೆಲೆಮಾ ಶುರುಕರಿನ ಜಗತ್ನಾ ಮನಕ್ಹೊಮಾ ಮಾರಾ ನಾಮಪರ ತಿಳಸೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ಐಕೊ! ಮಾರೊ, ಬಾ, ಕದಲಜ಼ ಮಿ ತುಮೊನೆ ತಿಳಸುಸ. ವರಿ ತುಮೆ ಸ್ವರಗನೆ ಶಕ್ತಿ ಮಳೆಲಕ್ಕಾ ಯೆರುಸೆಲೆಮಾಜ಼ ಕೈದಿನ ರ‍್ಹವೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಯೆರುಸೆಲೆಮ್ನಾ ಭಾರೊ ಬೆಥಾನಿನಾ ನಜಿ಼ಕ ಬಲೈ ಲಿನಗಯೊ. ಯೆಸು ತಿನಾ ಹತೊ ಉಚೈನ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ಆಶಿರ್ವಾದ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ತೆಳಾಮಾಜ಼ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊಕಂತೊ ಸ್ವರಗೆ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ಶಿಷ್ಯಾ ಯೆಸುನೆ ತ್ಯಾ ಸ್ತುತಿ ಕರ‍್ಯಾ. ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಫರಿನ ಗಾಮ್ಮಾ ಗಯಾ. ತ್ಯುನೆ ಘನ್ನಾ ಖುಶಿಮಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ತ್ಯುನೆ ಹಮೆಶಾಬಿ ದೆವಾಲಯಮಾ ಕ್ಹುದಾನಿ ಸ್ತುತಿ ಕರತಾತಾ.");
INSERT INTO sle_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ಶುರುತಿ ಪೈಲಾಜ ದುನಿಯಾಮಾ ವಾಕ್ಯಾ ವ್ಹತ್ತಿ. ತೆ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ತೆಜ಼ ಕ್ಹುದಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ಕ್ಹಾರು ಶುರು ಥಾವಾತಿ ಪೈಲಾಜ ತೆ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ಕ್ಹುದಾ ಕ್ಹಾರುಜ ತಿನಾ ಮುಕಾಂತರ ತಯ್ಯಾರ ಕರ‍್ಯೊ. ತೆನೈಸೊ ಸುಜ಼ ತಯ್ಯಾರ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ತಿಮಾ ಮುಲ ಜ಼ಲಮ ವ್ಹತ್ತೊ. ತೆ ಜ಼ಲಮ ಮನಕ್ಹೊನೆ ಉಜಾಲು ಥೈನ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ಉಜಾಲು ಅಂದಾರಾಮಾ ಉಜಾಲು ದಿದ್ಯು. ತೆನೈಸೊ ಅಂದಾರು ಉಜಾಲಾನೆ ವಳಕ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ಕ್ಹುದಾ ಸಂದೆಶ ಕವಾಲಾ ಯಕ್ಕ ಮನಕ್ಹನೆ ಮೊಕಲ್ಯೊ ತಿನು ನಾಮ ಯೊಹಾನ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ಯೊಹಾನ ಉಜಾಲಾನಾ ಹುತಿ ಮನಕ್ಹೊಕನ ಆಯೊ. ತಿನಾ ಮುಕಾಂತರ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತೆ ಸಂದೆಶ ಐಕಿನ ತಿನೆ ನಂಬು ಕೈನ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ಯೊಹಾನಜ ತೆ ಕ್ಹರಿನು ಉಜಾಲು ನ್ಹೊತು ");
INSERT INTO sle_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ಕ್ಹರಿನು ಉಜಾಲು ವ್ಹತ್ತು. ಎ ದುನಿಯಾಮಾ ಆವಾನು ವ್ಹತ್ತು. ತೆಜ಼ ಕ್ಹರಿನು ಉಜಾಲು ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪರ ಚಮಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ವಾಕ್ಯಾ ಕವಾಲೊ ತೆಳಾಮಾಜ಼ ದುನಿಯಾಮಾ ವ್ಹತ್ತೊ. ವರಿ ಕ್ಹುದಾ ತಿನಾ ಮುಕಾಂತರ ದುನಿಯಾ ತಯ್ಯಾರ ಕರ‍್ಯೊ. ವರಿಬಿ ತಿನೆ ಎ ದುನಿಯಾವಾಲಾ ವಳಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ತೆ ತಿನಾ ಸ್ವಂತ ದೆಶೆ ಆಯೊ. ತೆನೈಸೊ ತಿನಾ ಸ್ವಂತ ಮನಕ್ಹೊ ತಿನೆ ವಪ್ಪಿಲಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ತೆನೈಸೊ ಕುನ್ನ-ಕುನ್ನ ತಿನೆ ವಪ್ಪಿಲಿದ್ಯಾ ಕದ್ಯಾಮ ತಿನಾ ನಾಮ ಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ತ್ಯುನೊನೆ ತೆ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ ಥಾವಾನೆ ಹಕ್ಕ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ಇವ್ನೆ ರಗತಕ್ಹು ರ‍್ಹೈನೆಕಾ ಅಂಗನಾ ಆಸಕ್ಹು ರ‍್ಹೈನೆಕಾ ದಾಣ್ಗಾನಾ ಆಸಕ್ಹು ರ‍್ಹೈನೆಕಾ ಹುಟ್ಟಲ ನ್ಹವೈ. ತೆ ಇವ್ನೆ ಕ್ಹುದಾಕ್ಹುಜ ಹುಟ್ಟಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ವಾಕ್ಯಾ ಕವಾಲೊ ಮನಕ್ಹನೊ ರುಪತಾಳಿನ. ತೆ ಪುರಾ ಕೃಪಾಕ್ಹು ವರಿ ಕ್ಹರಿಕ್ಹು ಭರ‍್ಯೊತೊ. ಅಪ್ನಾ ಕ್ಹಾತೆ ಜಿವ್ನಾ ಕರ‍್ಯೊ ಅಪೆ ತಿನಿ ಮಹಿಮಾ ದೆಕ್ಯಾ. ತೆ ಮಹಿಮಾ ಬಾನೊ ಯಕ್ಲೊಜ ದಿಕ್ರೊ ರ‍್ಹಯಲ ತಿನೆ ಮಹಿಮಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ಯೊಹಾನ ತಿನಾಹುತಿ ಸಾಕ್ಷಿ ದಿನ್ನ ವರಿ ವದ್ರಿನ ಕದ್ಯೊ\" ಎ ತೆಜ಼ ವ್ಹೈ ಕಿನಾಹುತಿ ಮಿ ಕದ್ಯೊ, ತೆ ಮಪರ್ತೊ ಆವಸ, ಮುಪರತೊ ಆವಾಲೊ ಯಕ್ಲೊ ಮುತ್ತಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ತೆ ಮಿ ಹುಟ್ಟಾತಿ ಪೈಲಾಜ ಕಾಕದ್ಯಾಮ ತೆ ಅಸ್ತಿತ್ವಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ತಿನಿ ಕರುಣಾ ವರಿ ಪರಿಪುರ್ಣ ಕೃಪಾಕ್ಹು ಭರಲ ವ್ಹತ್ತೊ. ತಿನಾಕ್ಹುಜ ಅಪೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಆಶಿರ್ವಾದ ಪರ ಆಶಿರ್ವಾದ ವ್ಹಂದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ಕ್ಹುದಾ ಮೊಶೆನಾ ಮುಲಕ ನಿಯಮೊ ದಿದ್ಯೊತೊ. ತೆನೈಸೊ ಕೃಪಾ ಕ್ಹರಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಆಯು. ");
INSERT INTO sle_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ಕ್ಹುದಾನೆ ಕುನ್ನಜ ಕೆಳಾಮಾಜ ದೆಕ್ಯಾ ನತ್ತಿ. ತೆನೈಸೊ ಯಕ್ಲೊಜ ದಿಕ್ರೊ ತೆ ಕ್ಹುದಾನ ಲಿಂಗತ ಛೆ ವರಿ ಬಾನಾ ಬಾಜು಼ಮಾ ಛೆ. ತೆ ದಿಕ್ರೊ ಕ್ಹುದಾನೆ ಅಪೊನೆ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ತು ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಯೊಹಾನನೆ ಪುಚ್ಚಾನಾ ಹುತಿ ಯೆರುಸಲೆಮನಾ ಯಹುದ್ಯೊನಾ ಅದಿಕಾರಿಯೊ ಯೊಹಾನಕನ ದಕ್ಹಾ ಯಾಜಕೊನೆ ವರಿ ಲೆವಿಯೊನೆ ಮೊಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ಯೊಹಾನ ಝಾಕ್ಯಾವಾಚಿ\"ಮಿ ಕ್ರಿಸ್ತ ನ್ಹವೈ\" ಕೈನ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ವರಿ ತ್ಯುನೆ ತಿನೆ\"ತಿಮ್ಮ ರ‍್ಹಯುಮ ತು ಕುನ್ನ ವ್ಹೈ? ತು ಎಲಿಯಾ ವ್ಹೈಸು ಕೈನ ಪುಚ್ಯಾ. ತೆ\"ನ್ಹವೈ, ಮಿ ಎಲಿಯಾ ನ್ಹವೈ ಕೈನ ಕದ್ಯೊ. ವರಿ ತ್ಯುನೆ\"ತು ಪ್ರವಾದಿ ವ್ಹೈಸು? ಕೈನ ಪುಚ್ಯಾ. ಯೊಹಾನ\"ನ್ಹವೈ, ಮಿ ಪ್ರವಾದಿ ನ್ಹವೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ತಿಮ್ಮ ರ‍್ಹಯುಮ\"ಹಮೊನೆ ಕೆ ತು ಕುನ್ನ ವ್ಹೈ. ಹಮೊನೆ ವಳಾಯಲವಾಲಾವೊನೆ ಹಮೆ ಸು ಕೈಯೆ. ತಾರಾ ಹುತಿ ತು ಸು ಕಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ತೆ ವಾತೆ ಯೊಹಾನ,ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಕದಲ ತಿಮ್ಮ ಕದ್ಯೊ. \"ಪ್ರಭು ಆವಾನಾ ಹುತಿ ವಾಟ ಸಿದಾ ತಯ್ಯಾರ ಕರೊ ಕೈನ ರಾನ್ಮಾ ವದ್ರಾನು ಅವಾಜ಼ ಮಿ ವ್ಹೈ\" ");
INSERT INTO sle_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ವಳಾಯಲ ವಾಲಾವೊಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ ಪರಿಸಾಯರೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ತ್ಯುನೆ ಯೊಹಾನನೆ ಪುಚ್ಯಾ\"ತು ತಾರಾ ಹುತಿ\"ಮಿ ಕ್ರಿಸ್ತ ಬಿ ನ್ಹವೈ ಕವಾನು ರ‍್ಹಯುಮ, ಎಲಿಯಾಬಿ ನ್ಹವೈ, ಪ್ರವಾದಿಬಿ ನ್ಹವೈ ಕೈನ ಕವಾಡ್ಯೊಸ. ಇಮ್ಮ ರ‍್ಹಯುಮ ತು ಮನಕ್ಹೊನೆ ಕಾ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾಡೊಸ? ");
INSERT INTO sle_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ಯೊಹಾನ ಕದ್ಯೊ\"ಮಿ ಮನಕ್ಹೊನೆ ಪಾನಿಕ್ಹು ಬಾಪ್ತಿಸ್ಮ ಕರೌಸ. ತೆನೈಸೊ ತುಮೊನೆ ಗ್ವತ ನೈ ರ‍್ಹಯಲವಾಲೊ ನ್ಹ್ಯಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ ತೆಜ಼ ವ್ಹೈ. ತಿನಿಯೊ ಚಪ್ಲೊನಿಯೊ ದೊರಿಯೊ ಖೊಲಾನೆ ಮಿ ಯೊಗ್ಯ ನತ್ತಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ಯೊರ್ದನ ನದಿನಾ ತಿನಾ ಪುರ್ವ ದಿಕ್ರಾನಾ ಬಗಲ ರ‍್ಹಯಲ ಬೆಥನಿ ಕವಾನಾ ಗಾಮಮಾ ಎ ಸಂಗತಿಯೊ ಥಯ್ಯೊ. ಯೊಹಾನ ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ಕರಾನು ನ್ಹ್ಯಾಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ಮರ್ನಾ ದಿನ್ನೆ ಯೊಹಾನ, ತಿಕನ ಆವಾನಾ ಯೆಸುನೆ ದೆಕ್ಯೊ ದೆಕಿನ \"ದೆಕೊ, ಕ್ಹುದಾನು ಬಕ್ರಾನು ಬಚ್ಚು಼. ತೆ ಎ ದುನಿಯಾನಾ ಪಾಪೊ ಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ಮಿ ಗಯಲ್ಪರ ಯಕ್ಕ ಮನಕ್ಹ ಆವಸ. ತೆ ಮಾರಾತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ಕಾಕದ್ಯಾಮ ತೆ ಮಾರಾತಿಬಿ ಪೈಲಾ ಹುಟ್ಟಿನ ಅಸ್ತಿತ್ವಮಾ ರ‍್ಹಯಲವಾಲೊ ವ್ಹೈ ಕೈನ ಮಿ ಕವಾನು ಇನಾಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ತೆ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಮನೆಬಿ ಗ್ವತ ನ್ಹೊತು. ತೆನೈಸೊ ತಿನೆ ಇಸ್ರಾಯಲೊನೆ ತಿಳ್ಸಾನಿ ಹುತಿ ಮಿ ಮನಕ್ಹೊನೆ ಪಾನಿಕ್ಹು ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಡ್ಯೊತೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ಯೊಹಾನ ಸಾಕ್ಷಿ ದಿನ್ನ ಕದ್ಯೊ ತೆ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಮನೆಬಿ ಗ್ವತ ನ್ಹೊತು. ತೆನೈಸೊ ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ದಿವಾನೆ ಮನೆ ವಳಾಯಲವಾಲೊ ಮನೆ ಪವಿತ್ರ ಆತ್ಮಾ ಸ್ವರ್ಗತು ಉತ್ರಿನ ಐನ ಯಕ್ಕ ಮನಕ್ಹನಾ ಉಪ್ಪರ ಆವಾನು ತು ದೆಕ್ಷಿ. ");
INSERT INTO sle_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಲೊ ತೆಜ಼ ಮನಕ್ಹ ವ್ಹೈ \"ಕೈನ ಕದಲ ಎ ಥಾವಾನು ಮಿ ಡೊಳಾ ಕ್ಹಾಮೊ ದೆಕ್ಯೊಸ. ಪವಿತ್ರ ಆತ್ಮಾ ಸ್ವರ್ಗತೊ ಕ್ಹಬುತರನಾ ರುಪಮಾ ಉತ್ರಿನ ಐನ ತಿನಾ ಉಪ್ಪರ ಆವಾನು ಮಿ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ತಿನಾಹುತಿ \"ಮಿ ಸು ದೆಕ್ಯೊಸ ತೆಜ಼ ಮಿ ಕೌಸ. ತೆಜ಼ (ಯೆಸು) ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಮಿ ಮನಕ್ಹೊನೆ ತಿಳ್ಸುಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ಮರ್ನಾ ದಿನೆ ವರಿ ಯೊಹಾನ ತಿನಾ ಬೆ ಶಿಷ್ಯಾವೊನೆ ಕ್ಹಾತೆ ತ್ಯಾ ರ‍್ಹತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ನಜಿಕ್ಮಾ ಚಾಲ್ತೊ ರ‍್ಹತಾಮಾ ಯೆಸುನೆ ದೆಕ್ಯೊ ತೆಳಾಮಾ ಯೊಹಾನ ಕದ್ಯೊ ಎ ಕ್ಹುದಾನು ಬಕ್ರಾನು ಬಚ್ಚು಼, ");
INSERT INTO sle_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ಯೊಹಾನನಾ ಎ ವಾತೊ ಐಕಿನ ತೆ ಬೆ ಶಿಷ್ಯಾ ಯೆಸುನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ಯೆಸು ಪಾಚೊ಼ ಫರಿನ ದೆಕ್ಯೊ ತ್ಯುನೆ ಪಾಚಾ಼ ಆವಾನು ದೆಕಿನ ತುಮೊನೆ ಸು ಚಾ಼ಯೆ? ಕೈನ ಪುಚ್ಯೊ. ತೆ ಬೆ ಜ಼ನಾ, ತಿನೆ ಉತ್ತರ ದಿದ್ಯಾ\" ರಬ್ಬಿ, ತು ಕಿಜ್ಗಾ ರ‍್ಹಯೊಸ? ಕೈನ ಪುಚ್ಯಾ. ರಬ್ಬಿ\" ಕದ್ಯಾಮ\" ಗುರು\" ಇನೊ ಮತ್ಲಬ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ಯೆಸು ತ್ಯುನೊನೆ \"ಮಾರಾ ಕ್ಹಾತೆ ಆವೊ, ತೆಳಾಮಾ ತುಮೆಜ಼ ದೆಕೊಶಿ\" ಕೈನ ಕದ್ಯೊ. ತಿನಾಹುತಿ ತೆ ಬೆಜ಼ನಾ ಗೈನ ಯೆಸು ರ‍್ಹಯಲ ಜ಼ಗಾ ದೆಕಿಲಿದ್ಯಾ. ತೆಳಾಮಾ ಕ್ಹಾಂಜ಼ನಾ ಟೈಮ್ಮಾ ಚಾರ ವಾಜಾ಼ತಾ ತೆ ದಿನೆ ತ್ಯುನೆ ತ್ಯಾಜ ಕ್ಹಾರೊ ತಿನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ತೆ ಬೆ ಜ಼ನಾ ಯೊಹಾನನಿಯೊ ವಾತೊ ಐಕಿನ ಯೆಸುನಾ ಪಾಚಾ಼ ಗಯಲ ಬೆ ಶಿಷ್ಯಾಮಾ. ಸಿಮೊನ ಪೆತ್ರಾನೊ ನ್ಹಾನೊ ಭೈ ಥಯಲ ಅಂದ್ರೆಯ ಇವ್ನೊಮಾ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ಪೈಲಾ, ತೆ ತಿನೊ ಭೈ ಥಯಲ ಸಿಮೊನೆ ಮಳಿನ ಕದ್ಯೊ\" ಅಪೊನೆ ಮಸಿಹಾ ಮಳ್ಯೊಸ ಕದ್ಯೊ. (ಮಸ್ಸಿಹಾ ಕದ್ಯಾಮ ಕ್ರಿಸ್ತ ವ್ಹೈ) ");
INSERT INTO sle_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ತೆ ಸಿಮೊನನೆ ಯೆಸುಕನ ಬಲೈ ಲಾಯೊ. ಯೆಸು ಸಿಮೊನನೆ ದೆಕಿನ\"ಯೊಹಾನನೊ ದಿಕ್ರೊ ರ‍್ಹಯಲ ತಾರು ನಾಮ ಸಿಮೊನ ವ್ಹೈ. ತು ಕೆಫ ಕೈನ ಕವೈಲೆಸಿ\" ಕೈನ ಕದ್ಯೊ. ಕೆಫ ಕದ್ಯಾಮ ಮ್ಹೊಟೊ ದಗ್ಡೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ಮರ್ನಾ ದಿನೆ ಯೆಸು ಗಲಿಲಾಯೆ ಜೌ಼ಸ ಕೈನ ನಿರ್ದಾರ ಕರ‍್ಯೊ. ಯೆಸು ಫಿಲಿಪ್ಪನೆ ದೆಕಿನ ತಿನೆ\"ಮಾರಾ ಪಾಚೊ಼ ಆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ಅಂದ್ರೆಯಾ ವರಿ ಪೆತ್ರಾ ಲಿಂಗತ ಫಿಲಿಪ್ಪಬಿ ಬೆತ್ಸಾಯಿ ಗಾಮವಾಲಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ಫಿಲಿಪ್ಪ ನತಾನಿಯೆಲನೆ ಮಳಿನ ತಿನೆ\"ಕಿನಾಹುತಿ ಮೊಶೆ ಧರಮಶಾಸ್ತ್ರಮಾ ಬರ್ದ್ಯೊ ವರಿ ಪ್ರವಾದಿಯೊ ಬರ್ದ್ಯಾ, ತೆ ಹಮೊನೆ ಮಳ್ಯೊಸ. ತೆ ಯೊಸೆಫನೊ ದಿಕ್ರೊ ಯೆಸು ನಜರೆತವಾಲೊ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ತೆನೈಸೊ ನತಾನಿಯೆಲ ಫಿಲಿಪ್ಪನೆ\"ನಜರೆತತೊ ಚೊ಼ಕು ರ‍್ಹಯಲ ಸುಬಿ ಆವಸ ಸು? ಕೈನ ಪುಚ್ಚೊ. ಫಿಲಿಪ್ಪ\"ಐನ ದೆಕ\" ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ಯೆಸು ತಿಕನ ಆವಾನಾ ನತಾನಿಯೆಲನೆ ದೆಕಿನ ತಿನಾ ಹುತಿ\"ಎ ಕ್ಹರಿನೊ ಇಸ್ರಾಯಲ ವ್ಹೈ. ಇನಾಮಾ ಕಪಟ ನತ್ತಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ನತಾನಿಯೆಲ\"ತು ಮನೆ ಕಿಮ್ಮ ವಳಕ್ಯೊ? ಕೈನ ಪುಚ್ಚೊ. ಯೆಸು\"ಫಿಲಿಪ್ಪ ತುನೆ ಬಲಾವಾತಿ ಅಗ್ದುರಜ಼ ತು ಉಂಬ್ರೊನಾ ಝಾಡನಾ ಹೆಟೊ ರ‍್ಹತಾಮಾ ಮಿ ತುನೆ ದೆಕ್ಯೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ತೆಳಾಮಾ ನತಾನಿಯೆಲ ತಿನೆ\"ಗುರು, ತುಜ಼಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ. ತು ಇಸ್ರಾಯಲನೊ ರಾಜೊ಼ ವ್ಹೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ಯೆಸು ತಿನೆ\"ತು ಉಂಬ್ರೊನಾ ಝಾಡನಾ ಹೆಟೊ ಬೆಟಲ ದೆಕ್ಯೊಸ. ಅಮ್ಮ ಮಿ ಕದಲಕ್ಹು ತು ಮಪರ ಬರೊಕ್ಹೊ ಕರ್ಸಿ ಸು? ತೆನೈಸೊ ತಿತ್ತಿಬಿ ಘನ್ನಾ ಮ್ಹೊಟಾ ಕಾಮೊ ತು ದೆಕ್ಷಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ಸ್ವರ್ಗ ಖುಲ್ಲಾ ಕರಲನೆ ಮನಕ್ಹನಾ ದಿಕ್ರಾನಾ ಉಪ್ಪರ ದೆವ ದುತೊ ಉಪ್ಪರ ಜಾ಼ವಾನು ಹೆಟು ಆವಾನು ತುಮೆ ದೆಕೊಶಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ಬೆ ದಿನ್ನ ಥಯಲ್ಪರ ಗಲಿಲಾಯನಾ ಕಾನಾ ಕವಾನಾ ಗಾಮಮಾ ಯಕ್ಕ ಹಿವಾ ವ್ಹತ್ತೊ. ಯೆಸುನಿ ಯಾ ಬಿ ತ್ಯಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ಯೆಸುನೆ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನೆಬಿ ಹಿವಾನೆ ಬಲಾಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ಹಿವಾಮಾ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಕ್ಹರಲ್ಪರ. ಯೆಸುನಿ ಯಾ ತಿನೆ\"ತ್ಯುನೊಕನ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹಜ ನತ್ತಿ \"ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ಯೆಸು\"ಬೈ, ತು ಮನೆ ಕಾ ಕವಾಡಿಸ? ಮಾರು ಟೈಮ ಹಜನ ಆಯೊ ನತ್ತಿ\" ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ಯೆಸುನಿ ಯಾ ಸೆವಕೊನೆ\"ತೆ ತುಮೊನೆ ಸು ಕವಸ ತೆ ಕರೊ\" ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ದಗ್ಡಾಕ್ಹು ಕರಲ ಛೆ ಮ್ಹೊಟಿಯೊ ಡೊಣಿಯೊ ತ್ಯಾ ವ್ಹತ್ತಿಯೊ. ಯಹುದಿಯೊನಿ ಪದ್ದತ ಲಿಂಗತ ಶುದ್ಧಾಚಾರಿಯೊನೆ ಎ ದಗ್ಡಾನಿಯೊ ಡೊಣಿಯೊ ಉಪಯೊಗ ಕರ್ತಾತಾ. ಹರಿ ಯಕ್ಕ ಡೊಣಿಯೊಮಾ ಕಮ್ಮಶಿ ಕಮ್ಮ 80 ತು 120 ಲಿಟರ ಪಾನಿ ಧರ್ತುತು. ");
INSERT INTO sle_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ಯೆಸು ಸೆವಕೊನೆ\"ತೆ ಡೊಣಿಯೊಮಾ ಪಾನಿ ಭರೊ\" ಕೈನ ಕದ್ಯೊ. ತಿನಾಲಿಂಗತಜ಼ ಸೆವಕೊ ತೆ ಡೊಣಿಯೊಮಾ ಪಾನಿ ಕಂಟಾ ಲಕ್ಕಾ ಭರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ಯೆಸು ಸೆವಕೊನೆ\"ತೆ ಡೊಣಿಯೊಮಾನು ದಕ್ಹು ಪಾನಿ ಕಾಡಿನ ತೆ ಗೈನ ಅನ್ನ ಕರಾಲಾವೊನಾ ಮ್ಹೊಟಾನೆ ದಿವೊ\" ಕೈನ ಕದ್ಯೊ ತಿನಾಲಿಂಗತಜ಼ ತ್ಯುನೆ ತೆ ಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ಅನ್ನ ಕರಾಲಾವೊಪರ ಮ್ಹೊಟೊ ರ‍್ಹಯಲವಾಲೊ ಪಾನಿ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಬದಲಿ ಥಯಲ ಪಾನಿನು ಸವಾದ ದೆಕ್ಯೊ. ಕಿಜ್ಗಾಂತು ದ್ರಾಕ್ಷಿಯೊನು ಆಯುಸ ಕವಾನು ತಿನೆ ಗ್ವತ್ತ ನ್ಹೊತು. ತೆನೈಸೊ ಪಾನಿ ಕಾಡಲ ತೆ ಸೆವಕೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ಅನ್ನ ಕರಾಲಾವೊ ಪರ ಮ್ಹೊಟೊ ರ‍್ಹಯಲವಾಲೊ ನೌರಾನೆ ಬಲಾಯೊ, ");
INSERT INTO sle_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","\"ಮನಕ್ಹೊ ಚೊಕೊಜ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ವಾಟಸ. ಅತಿಥಿಯೊ ಪಿನ ತೃಪ್ತ ಥಯಲ್ಪರ ಸಾದಾ ರ‍್ಹಯಲ ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ದಿವಸ. ತೆನೈಸೊ ತು ಚೊಕೊಜ ರ‍್ಹಯಲ ದ್ರಾಕ್ಷಾರಸ ಇವ್ನೊನೆ ಮುಕ್ಯೊಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ಕಾನಾ ಕವಾನಾ ಗಾಮ್ಮಾ ಯೆಸು ಕರಲ ಪೈಲಾನು ಅದ್ಭುತ ಕಾಮ ವ್ಹೈ. ತೆ ತಿನಿ ಮಹಿಮಾ ತ್ಯಾ ದೆಕಾಡಿನ ದಿದ್ಯೊ. ತಿನಾ ಶಿಷ್ಯಾ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತಿನಿ ಮಾ, ಭಾಯೊ ವರಿ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಕಪೆನೌರ್ಮ ಕವಾನಾ ಗಾಮೆ ಗಯೊ. ವರಿ ತ್ಯುನೆ ತ್ಯಾ ದಕ್ಹಾ ದಿನ್ನ ವ್ಹತ್ತಾ.. ");
INSERT INTO sle_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ತೆಳಾಮಾ ಯೆಹುದಿಯೊನು ಫಸ್ಕ ಸನ್ನ ನಜಿಕ ವ್ಹತ್ತು. ತಿನಾಹುತಿ ಯೆಸು ಉಪ್ಪರ ಯೆರುಸಲೆಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ದೆವಾಲಯಮಾ ಮನಕ್ಹೊ ಬೈಲೊ, ಬಕ್ರಾ, ವರಿ ಕ್ಹಬುತರೊ ಇಕ್ಕಾನು ಯೆಸು ದೆಕ್ಯೊ. ವರಿ ದಕ್ಹಾ ಮನಕ್ಹೊ ಟೆಬ್ಲೊಕನ ಬೈಟಿನ ದೊಕ್ಡಾ ಬದಲಿ ಕರಾನು ವರಿ ವ್ಯಾಪಾರ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ಯೆಸು ದಕ್ಹಾ ರಾಕ್ಹೊನಾ ತುಕ್ಡಾಲಿನ ತ್ಯುನೊಕ್ಹು ಬಾರಕೊಲ ಕರಿನ ವರಿ ಕ್ಹಾರಾ ಜಾನ್ವರೊನೆ ದೆವಾಲಯತೊ ಭಾರೊ ಖಾದ್ಯೊ, ಬೈಲೊ ವರಿ ಬಕ್ರಾ ಭಂಬಿನೆ ಮಾರಿನ ವರಿ ದೊಕ್ಡಾ ಬದಲಿ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ವರಿ ತ್ಯುನಾ ದೊಕ್ಡಾ ನಾಕಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ಕ್ಹಬುತರೊ ಇಕ್ಕಾಲಾವೊನೆ\"ಎ ಕ್ಹಾರು ಭಾರಾ ಲಿನ ಜಾವೊ! ಮಾರಾ ಬಾನು ಘರ ವ್ಯಾಪಾರ ಕರಾನು ಜ಼ಗಾ ಕರೊ ನಕೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ತಾರಿ ಆಲಯಪರ ರ‍್ಹಯಲ ಮಯಾ ಮಾರಾಮಾ ಆಗ ಲಿಂಗತ ಬಳಸ. (ಕಿರ್ತನೆ 69:9) ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ವಾಕ್ಯಾ ತಿನಾ ಶಿಷ್ಯಾ ಶೆ ಕರಲಿದ್ಯಾ. ಯಹುದ್ಯೊ ಯೆಸುನೆ\"ಯಕ್ಲು ಕ್ಹಾರು ಕರಾನು ತುನೆ ಕುನ್ನ ಅದಿಕಾರ ದಿದ್ಯುಸ ಹಮೊನೆ ಸಬುತ ದೆಕಾಡ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ಯೆಹುದಿಯೊನಾ ಅದಿಕಾರಿಯೊ ತಿಕನ ಐನ ತು ಹಮೊನೆ ಕಯು ಅದ್ಭುತ ಕಾಮನು ವಳಕ ದೆಕಾಡಶಿ? ತಿಕ್ಹು ತು ಸು ಕರಾಯೊಸ ತೆ ಕರಾನೆ ತುನೆ ಅದಿಕಾರ ಛೆ ಕವಾನು ಸಬುತ ದೆಕಾಡಾನಾ ಹುತಿ ಪುಚ್ಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ಯೆಸು\"ಎ ದೆವಾಲಯ ಪಾಡಿಪಾಡೊ, ಅಗಲ್ಯಾ ತನ್ನ ದಿನ್ಮಾ ವರಿ ಫರಿನ ತೆ ಭಾಂದುಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","\"ತಿನಾಹುತಿ ಯಹುದ್ಯೊ ತಿನೆ, ಎ ದೆವಾಲಯ ಭಾಂದಾನೆ ಚಾಳಕ್ಹಪರ ಛೆ ವರಕ್ಹ ಲಾಗ್ಯಾಸ! ವರಿ ತು ತನ್ನ ದಿನ್ಮಾ ಎ ಫರಿನ ಭಾಂದಶಿ ಸು? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ತೆನೈಸೊ ಯೆಸು ಕೈ ದೆವಾಯಲನಾ ಹುತಿ ಕವಾಡೊತೊ ತೆ ತಿನಾ ಸ್ವಂತ ಅಂಗನಾ ಹುತಿಜ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ಯೆಸು, ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆತಾಮಾ ತಿನಾ ಶಿಷ್ಯಾ ತಿನಿಯೊ ವಾತೊ ಶೆ ಕರಿನ, ತ್ಯುನೆ ಪವಿತ್ರ ಗ್ರಂಥ ವರಿ ತೆ ಕದಲ ವಾತೊಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ಯೆಸು ಫಸ್ಕ ಸನ್ನಾ ಹುತಿ ಯೆರುಸಲೆಮ್ಮಾ ವ್ಹತ್ತೊ. ತೆ ಕರಲ ಅದ್ಭುತೊ ಮನಕ್ಹೊ ದೆಕಿನ ತಿಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ತೆನೈಸೊ ಯೆಸು ತಿನೆ ತೆಜ಼ ತ್ಯುನಾ ಬರೊಕ್ಹಾಪರ ಛೊಡಿನ ದಿದ್ಯೊ ನೈ. ಕಾಕದ್ಯಾಮ ತೆ ತ್ಯುನೊನೆ ವಳಕ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ಕುನ್ನಜ ಮನಕ್ಹೊನಾ ಹುತಿ ತಿನೆ ಕವಾನೆ ಸುಜ಼ ಜರುರತ ನ್ಹೊತಿ. ಮನಕ್ಹನಾ ಮನಸ್ಮಾ ಸು ಛೆ ಕವಾನು ಯೆಸುನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ಯಕ್ಲೊ ಯಹುದಿಯೊನೊ ಅದಿಕಾರಿ ವ್ಹತ್ತೊ ತಿನು ನಾಮ ನಿಕೊದೆಮ ವ್ಹತ್ತು. ತೆ ಫರಿಸಾಯರ ಗುಂಪನೊ ಸದಸ್ಯ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ಯಕ್ಕ ರಾತೆ ನಿಕೊದೆಮ ಯೆಸುಕನ ಆಯೊ. ನಿಕೊದೆಮ\"ಗುರು, ತು ಕ್ಹುದಾ ವಳಾಯಲ ಮಾಸ್ತರ ವ್ಹೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತು ಕರಾನಾ ಆ ತರಾನಾ ಅದ್ಭುತೊ ಕ್ಹುದಾನೊ ಆಸ್ರೊವಾಚಿ ಕುನ್ನಜ ನೈ ಕರತು \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ಯೆಸು\"ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ಯಕ್ಲೊ ನವೊ ಥೈನ ಹುಟ್ಟುಜ. ಯಕ್ಲೊ ನವೊ ಥೈನ ನೈ ಹುಟ್ಯೊಮ ತೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯ ನೈ ದೆಕತೊ \"ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ನಿಕೊದೆಮ\"ಮನಕ್ಹೊ ಗಡಿಯೊ ಥಯಲ್ಪರ ಹುಟ್ಟಾನು ಕಿಮ್ಮ? ಯಕ್ಲೊ ತಿನಿ ಯಾನಾ ಪೆಟ್ಮಾ ವರಿಯಕ್ಕೆಮ ಜಾ಼ವಾನೆ ಸಾಧ್ಯ ಛೆಸು? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ತಿನೆ ಯೆಸು\"ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ಯಕ್ಲೊ ಪಾನಿಕ್ಹು ಆತ್ಮಾಕ್ಹು ಹುಟ್ಟುಜ. ನೈತೊ ತೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯನೆ ನೈ ಜಾತೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ಅಂಗ ಯಕ್ಕ ಮನಕ್ಹೊ ಶರಿರಮಾ ತಿನಾ ಮಾ ಬಾ ಕ್ಹು ಹುಟ್ಯೊಸ. ತೆನೈಸೊ ಆತ್ಮಿಕಮಾ ತೆ ಆತ್ಮಾ ಕ್ಹು ಹುಟ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","\"ತು ನವೊ ಥೈನ ಹುಟ್ಟುಜ \"ಕೈನ ಮಿ ಕದಲ ಕ್ಹು ಘಾಬ್ರೊ ಥೌ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ವಾರೊ ತಿನೆ ಮನಸ ಆಯಲ ಜ಼ಗಾ ಜಾ಼ವಸ. ವಾರೊ ಆವಾನು ಆವಾಜ ತು ಐಕ್ಸಿ. ತೆನೈಸೊ ವಾರೊ ಕಿಜ್ಗಾತೊ ಆವಾಡ್ಯೊಸ ವರಿ ಕಿಜಾ಼ ಜಾ಼ವಸ ತುನೆ ಗ್ವತ ನೈ ಥಾತು. ಆತ್ಮಾಕ್ಹು ಹುಟ್ಟಲ ಹರಿ ಯಕ್ಲೊ ತಿನಾಲಿಂಗತ ಛೆ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ನಿಕೊದೆಮ\"ಎ ಕ್ಹಾರು ಕಿಮ್ಮ ಸಾಧ್ಯ ಛೆ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ಯೆಸು\"ತು ಇಸ್ರಾಯಲನೊ ಮಾಸ್ತರ ವ್ಹೈ. ತೆನೈಸೊ ತುನೆ ಎ ಸಂಗತಿಯೊ ಹಜು಼ನ ಗ್ವತ್ತ ನತ್ತಿ ಥಯು ಸು? ");
INSERT INTO sle_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ಅಪೊನೆ ಗ್ವತ್ತ ರ‍್ಹಯಲನಾ ಹುತಿ ಅಪೆ ಬೊಲಿಯೆಸ. ಅಪೆ ದೆಕಲನೆ ಸಾಕ್ಷಿ ದಿಯೆಸ. ತೆನೈಸೊ ಹಮೆ ಕವಾನು ತುಮೆ ಸ್ವಿಕಾರ ಕರ್ಲೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ಮಿ ಎ ದುನಿಯಾನಿ ಸಂಗತಿಯೊನಾ ಹುತಿ ಸು ಕದ್ಯೊತಬಿ ತುಮೆ ಬರೊಕ್ಹೊ ನೈ ಕರ್ತಾ. ಇಮ್ಮ ರ‍್ಹಯೊಮ ಮಿ ಸ್ವರ್ಗನಿ ಸಂಗತಿಯೊನಾ ಹುತಿ ಕದ್ಯೊಮ ತುಮೆ ಕಿಮ ಬರೊಕ್ಹೊ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆಯಲ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಯಕ್ಲೊಜ ವ್ಹೈ. ತೆನೈಸೊ ಬಿಜು಼ ಕುನ್ನಜ ಸ್ವರ್ಗನೆ ಗಯು ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","\"ಮೊಶೆ ಉಸುಕನಾ ಗಾಮಮಾ ತಾಂಬಾನಾ ಕ್ಹಾಪನೆ ಉಚ್ಚು ರ‍್ಹಯಲ ಖಾಂಪರ ಮ್ಹೆಲ್ಯೊ. ತಿನಾಲಿಂಗತಜ಼ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆಬಿ ಉಚೈನ ಉಚ್ಚು ರ‍್ಹಯಲ ಖಂಬಾಪರ ಮ್ಹೆಲಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ತಿನಾಹುತಿ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಹರಿ ಯಕ್ಲೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಹೊಂದಿಲಿವಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ಹೊ, ಕ್ಹುದಾ ದುನಿಯಾನೆ ಕೆಕ್ಲಿಕೆ ಮಯಾ ಕರಿನ ತಿನಾ ಯಕ್ಕಜ಼ ದಿಕ್ರಾನೆ ದಿದ್ಯೊ; ತಿನೆ ಬರೊಕ್ಹೊ ಕರಾಲೊ ಯಕ್ಲೊಬಿ ಹಾಳ ಥಯಾವಾಚಿ ಕ್ಹಾರಾ ಜ಼ನಾ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಿಲ್ಯು ಕೈನ ತಿನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ಕ್ಹುದಾ ತಿನಾ ದಿಕ್ರಾನೆ ಎ ದುನಿಯಾಮಾ ವಳಾಯಲ, ತಿನಾ ಮುಲಕ ಎ ದುನಿಯಾನಾ ಮನಕ್ಹೊನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಕರಾನೆ ನ್ಹವೈ. ತೆನೈಸೊ ರಕ್ಷಣೆ ವ್ಹಂದಿಲ್ಯು ಕೈನ ಕ್ಹುದಾ ತಿನೆ ವಳಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ಕ್ಹುದಾನಾ ದಿಕ್ರಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾವಾಲಾನೆ ಫೈಸಲೊ ನೈ ಥಾತೊ. ತೆನೈಸೊ ನೈ ಬರೊಕ್ಹೊ ಕರಾಲಾನೆ ತೆಳಾಮಾಜ಼ ಫೈಸಲೊ ಥಯೊಸ. ಕಾಕದ್ಯಾಮ ತೆ ಕ್ಹುದಾನೊ ಯಕ್ಲೊಜ ದಿಕ್ರಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ತೆ ನ್ಯಾಯನೊ ಫೈಸಲೊ ಅಮ್ಮ ರ‍್ಹವಸ ಉಜಾಲು ದುನಿಯಾಮಾ ಆಯು ವರಿಬಿ ಮನಕ್ಹೊ ಉಜಾಲಾನಾ ಬದಲ ಅಂದಾರಾನೆ ಮಯಾ ಕರ‍್ಯಾ ಕಾಕದ್ಯಾಮ ತಿನಾ ಕಾಮೊ ಕೆಟ್ಟ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ಕೆಟ್ಟ ಕರಾಲೊ ಹರಯಕ್ಲೊ ಉಜಾಲಾನೆ ಇನ್ಕಾರಸ. ತೆ ಉಜಾಲಾಮಾ ಆತೊ ನೈ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಕರ‍ಲ ಕೆಟ್ಟ ಕಾಮೊ ಕ್ಹಾರಾ ಉಜಾಲಾಮಾ ದಿಕ್ಹು ಕೈನ ಮನಸ ರ‍್ಹತು ನೈ.. ");
INSERT INTO sle_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ತೆನೈಸೊ ಕುನ್ನ ಕ್ಹರಿನಿ ಕಾಮ ಕರಸ ತೆ ಉಜಾಲಾನಾ ನಜಿಕ ಆವಸ. ಕಾಕಾದ್ಯಾಮ ಉಜಾಲು ತ್ಯುನು ಕಾಮ ದಿಕ್ಹಾದೆ ಕೈನ ತ್ಯುನೆ ಸು-ಸು ಕರ‍್ಯಾಸ ತೆ ಕ್ಹಾರು ಕ್ಹುದಾನಾ ಮುಲಕ ಕರಾಯಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ಎ ಥಯಲ್ಪರ, ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ಯುದೆಯ ಕವಾನಾ ಪ್ರಾಂತ್ಯನೆ ಗಯಾ. ತ್ಯಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ದಕ್ಹಾ ದಿನ್ನ ರ‍್ಹೈನ, ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ಕರಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ಯೊಹಾನಬಿ ಸಲಿಮನಾ ನಜಿಕ ರ‍್ಹಯಲ ಐನೊನ ಗಾಮ್ಮಾ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾಡ್ಯೊತೊ. ಕಾಕದ್ಯಾಮ ತ್ಯಾ ಘನ್ನು ಪಾನಿ ರ‍್ಹಯಲಕ್ಹು ಯೊಹಾನ ತ್ಯಾ ಮನಕ್ಹೊ ತ್ಯಾ ಐನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(ತೆಳಾಮಾ ಯೊಹಾನೆ ಹಜು಼ನ ಜೈಲಮಾ ಘಾಲ್ಯಾ ನ್ಹೊತಾ) ");
INSERT INTO sle_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ಯೊಹಾನನಾ ಶಿಷ್ಯಾವೊನಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಯಕ್ಲಾ ಯೆಹುದಿಯೊನಾ ಪದ್ದತನಿ ಶುದ್ಧಾಚಾರನಾ ಹುತಿ ವಾದ-ವಿವಾದ ಚಾ಼ಲಾಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ತಿನಾಹುತಿ ಶಿಷ್ಯಾ ಯೊಹಾನ ಕನ ಐನ\"ಗುರು, ತುನೆ ಶೆ ಛೆಸು? ತೆ ಮನಕ್ಹ ಯೊರ್ದನನಿ ಪುರ್ವ ದಿಕ್ಮಾ ತಾರಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ ವರಿ ತು ತಿನಾ ಹುತಿ ಕದ್ಯೊತೊತೊ? ತೆ ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾವಾಡ್ಯೊಸ. ಘನ್ನಾ ಮನಕ್ಹೊ ತಿಕನ ಚಾ಼ಲ್ಯಾಸ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ಯೊಹಾನ, ಕಯಾಜ ಮನಕ್ಹನೆ ತ್ಯಾಲಕ್ಕಾ ಮಳತು ನೈ, ಕಿಜಾ಼ ಲಕ್ಕಾ ತಿನೆ ಕ್ಹುದಾ ದೆತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ತುಮೆ ಕ್ಹಾರಾ ಸಾಕ್ಷಿ ಥಯಾಸ ಮಿ ಕದ್ಯೊತೊ; ಮಿ ಕ್ರಿಸ್ತ ನ್ಹೈ. ತೆನೈಸೊ ಮನೆ ತಿನಾತಿ ಪೈಲಾ ವಳಾಯಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ನೌರಿ ನೌರಾನಿಜ ವ್ಹೈ. ನೌರಾನೆ ಸಹಾಯ ಕರಾಲೊ ದೊಸ್ತ ನೌರೊ ಆವಾನಾ ಹುತಿ ಕೈದತೊ ರ‍್ಹವಸ ವರಿ ತೆ ಬಲಾವಸ ಕೈನ ಕಾನ ದಿನ್ನ ಐಕ್ತೊ ರ‍್ಹವಸ. ನೌರಾನೊ ಗಳೊ ಐಕ್ತಾಮಾ ತೆ ದೊಸ್ತ ಘನ್ನೊ ಖುಶಿ ಥಾವಸ. ತೆಜ಼ ಮಾರಿ ಖುಶಿ ಪುರಾ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ತೆ ಮ್ಹೊಟೊ ಥೌ ವರಿ ಮಿ ನ್ಹಾನೊ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","\"ಉಪ್ಪರ್ತೊ ಆವಾಲೊ ಯಕ್ಲೊ ಬಿಜಾ಼ ಕ್ಹಾರಾ ಮನಕ್ಹೊತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ಕುನ್ನ ದುನಿಯಾವಾಲೊ ವ್ಹೈ ತೆ ದುನಿಯಾನೆ ಸಂಭಂದ ರ‍್ಹಯಲವಾಲೊ ವ್ಹೈ. ತೆ ದುನಿಯಾನಾನಿ ಸಂಗತಿಯೊನಾ ಹುತಿ ಬೊಲಸ. ಕುನ್ನ ಸ್ವರ್ಗತು ಆವಸ ತೆ ಕ್ಹಾರಾವೊತಿ ಮ್ಹೊಟೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ತೆ ದೆಕಲ ಕ್ಹಾರಾನಾ ಹುತಿ ವರಿ ಐಕಲ ಕ್ಹಾರಾನಾ ಹುತಿ ಸಾಕ್ಷಿ ದಿವಸ. ತೆನೈಸೊ ತಿನಿ ಸಾಕ್ಷಿನೆ ಮನಕ್ಹೊ ಸ್ವಿಕಾರ ನೈ ಕರ‍್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ತೆನೈಸೊ ತಿನಿ ಸಾಕ್ಷಿನೆ ಕುನ್ನ ಸ್ವಿಕಾರ ಕರಿಲಿವಸ ತೆ ಅಮ್ಮ ಕರಾಕ್ಹು ಕ್ಹುದಾಜ ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾ ಕಿನೆ ಮೊಕ್ಲ್ಯೊಸ ತೆ ಕ್ಹುದಾನಿಯೊ ವಾತೊ ಬೊಲಸ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾ ತಿನೆ ಪರಿಪುರ್ಣ ಆತ್ಮಾ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ಬಾ ದಿಕ್ರಾನೆ ಮಯಾ ಕರಸ. ಬಾ ದಿಕ್ರಾನೆ ಹರಯಕ್ಕ ಪರ ಅದಿಕಾರ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ಕುನ್ನ ದಿಕ್ರಾ ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಸ ತಿನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಮಳಸ. ತೆನೈಸೊ ದಿಕ್ರಾನೆ ವಿಧೆಯ ನೈ ಥಾತೊ ತಿನೆ ತೆ ಜ಼ಲಮ ಕೆಳಾಮಾಜ ಮಳ್ತೊ ನೈ. ಕ್ಹುದಾನಿ ಶಿಟ್ಟ ತಿನಾ ಉಪ್ಪರ ರ‍್ಹವಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ತೆ ಯೊಹಾನತಿಬಿ ಹೆಚ್ಕಿ ಶಿಷ್ಯಾ ಕರಲಿನ ತ್ಯುನೊನೆ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾಡ್ಯೊಸ ಕೈನ ಕವಾನಿ ಸುದ್ದಿ ಫರಿಸಾಯರೊನೆ ಗ್ವತ್ತ ಥಯುಸ ಕೈನ ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ಕ್ಹರಿಮಾಜ಼ ಮನಕ್ಹೊನೆ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾಯಲ ಯೆಸು ನ್ಹವೈ. ತಿನಾ ಶಿಷ್ಯಾಜ಼ ದಿಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ಮನಕ್ಹೊ ಸು ಕವಾಡ್ಯಾಸ ಕವಾನು ಯೆಸು ಐಕಿನ ತೆ ಯುದಾಯ ಛೊಡಿನ ವರಿ ಗಲಿಲಾಯಯೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ತೆ ಸಮಾರ್ಯಾ ಪ್ರಾಂತ್ಯಮಾತೊಜ ಗಲಿಲಾಯೆ ಜಾ಼ವಾನಿ ವಾಟ ದಾಟಿನ ಜಾ಼ವಾನು ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ಯೆಸು ಸಮರ್ಯಾ ಕವಾನೆ ಗಾಮ್ಮಾ ರ‍್ಹಯಲ ಸುಖಾರ ಕವಾನಿ ಜ಼ಗಾಪರ ಆಯೊ. ಯಾಕೊಬ ತಿನಾ ದಿಕ್ರಾ ಯೊಸೆಫನೆ ದಿದಲ ಜ಼ಗಾನಾ ನಜಿಕ ಎ ಗಾಮ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ಯಾಕೊಬನಿ ಇರ ತ್ಯಾಜ ವ್ಹತ್ತಿ. ಯೆಸು ಘನ್ನು ದುರತೊ ಚಾಲ್ತೊ ಆಯಲ ಹುತಿ ತೆ ಸುಸ್ತ ಥಯೊತೊ. ತಿನಾಹುತಿ ತೆ ಇರಕನ ಬೈಟ್ಯೊ. ತೆಳಾಮಾ ಕಮ್ಸಿ ಕಮ ದುಪ್ಪಾರ ಥೈತಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ಸಮಾರ್ಯಾವಾಲಿ ಯಕ್ಕ ಬಾಕ್ಡಿ ಪಾನಿ ಲಿವಾನೆ ತೆ ಇರಕನ ಐ. ಯೆಸು ತಿನೆ\"ಮನೆ ಪಿವಾನೆ ದಕ್ಹು ಪಾನಿ ದೆಶಿ ಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ಯೆಸುನಾ ಶಿಷ್ಯಾ ಖಾವಾನಾ ಹುತಿ ಇಕ್ಕಾತು ಅನ್ನಲಾವಾನೆ ಗಾಮೆ ಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ಸಮಾರ್ಯಾವಾಲಿ ತೆ ಬಾಕ್ಡಿ ತುತೊ ಯಹುದಿ ವ್ಹೈ. ಮಿತೊ ಸಮಾರ್ಯಾವಾಲಿ ವ್ಹೈ\" ಪಿವಾನೆ ಪಾನಿ ತು ಮಕನ ಪುಚ್ಚಾನು ಕಾ? ಕದಿ. ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊ ಸಮಾರ್ಯಾವಾಲಾನಾ ಕ್ಹಾತೆ ಕಯುಜ಼ ಸಂಭಂದ ಮ್ಹೆಲ್ತಾ ನ್ಹೊತಾ.. ");
INSERT INTO sle_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ಯೆಸು ತಿನೆ\"ಕ್ಹುದಾ ಸು ದಿವಸ ಕವಾನು ತುನೆ ಗ್ವತ್ತ ನತ್ತಿ ಪಾನಿ ಪುಚ್ತಾಮಾ ಮಿ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ತುನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತುನೆ ಎ ಕ್ಹಾರು ಗ್ವತ್ತ ರ‍್ಹವತ್ತೊ, ತು ಮಕನ ಮಾಂಗಿಲೆತಿತಿ, ವರಿ ಮಿ ತುನೆ ಜಿವ ಜಲ ದೆತೊತೊ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ತೆ ಬಾಕ್ಡಿ ಅಯ್ಯಾ, ತೆ ಜಿವ ಜಲ ತುನೆ ಕಿಜ್ಗಾ ಮಳಸ? ಇರ ಘನ್ನಿ ಉಂಡಿ ಛೆ ವರಿ ತಿಮಾತು ಪಾನಿ ಕಾಡಾನೆ ತುಕನ ಸುಜ಼ ಸಾಮನ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ಹಮೊನೆ ಆ ಇರ ಯಾಕೊಬ ದಿದ್ಯೊಸ. ತೆಬಿ ಎಜ಼ ಪಾನಿ ಪಿದ್ಯೊ. ತೆನೈಸೊ ತಿನಾ ಬಚ್ಚಾಬಿ ಎಜ಼ ಇರನು ಪಾನಿ ಪಿದ್ಯಾ ತಿನಾ ಜಾನ್ವರೊಬಿ ಎಜ಼ ಇರಮಾನು ಪಾನಿ ಪಿತಾತಾ. ಹಮಾರೊ ಪಿತೃ ಥಯಲ ಯಾಕೊಬತಿಬಿ ತು ಮ್ಹೊಟೊ ವ್ಹೈಸು? ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ಯೆಸು, ಎ ಪಾನಿ ಪಿವಾಲಾ ಹರಿ ಯಕ್ಲಾನೆ ಫರಿನ ತರಕ್ಹ ಲಾಗಸ, ");
INSERT INTO sle_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ವರಿ ಮಿ ದಿವಾನು ಪಾನಿ ಕುನ್ನ-ಕುನ್ನ ಪಿವಸ ತ್ಯುನೊನೆ ಫರಿನ ತರಕ್ಹ ಲಾಗ್ತಿಜ ನೈ. ಮಿ ದಿವಾನು ಪಾನಿ ತ್ಯುನಾ ಮ್ಹೈತು ಜ಼ಲಮ ದಿವಾನು ಪಾನಿನು ಝರಿಲಿಂಗತ ರ‍್ಹವಸ. ವರಿ ತೆ ತ್ಯುನೊನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ತೆ ಬಾಕ್ಡಿ ಯೆಸುನೆ\"ಗುರು, ತೆ ಪಾನಿ ಮನೆ ದೆ! ತೆಳಾಮಾ ಮನೆ ವಟ್ಟಜ ತರಕ್ಹ ಲಾಗ್ತಿ ನೈ. ಪಾನಿ ಲಿನ ಜಾ಼ವಾಲಾನೆ ಮಿ ನ್ಯ್ಹಾ ವರಿ ಆವಾನೆ ಜರುರತ್ತ ರ‍್ಹತಿ ನೈ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ಯೆಸು ತಿನೆ\"ತು ಗೈನ ತಾರಾ ಮಾಟಿನೆ ಬಲೈ ಲಿನ ಫರಿನ ಆ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ತೆ ಬಾಕ್ಡಿನೆ \"ಮನೆ ಮಾಟಿ ನತ್ತಿ\" ಕದಿ. ಯೆಸು ತಿನೆ\"ತಾರೊ ಮಾಟಿ ನತ್ತಿ ಕೈನ ಕ್ಹರಿ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ಕ್ಹರಿಮಾಜ಼ ತುನೆ ಪಾಂಚ಼ ಜ಼ನಾವೊನಾ ಕ್ಹಾತೆ ಹಿವಾ ಥಯಾತಾ. ವರಿಬಿ ತು ಹಮ್ನಾ ಕಿನಾ ಕ್ಹಾತೆ ಛೆ ತೆ ಕ್ಹರಿಮಾಜ಼ ತಾರೊ ಮಾಟಿ ನ್ಹವೈ. ತು ಮನೆ ಕ್ಹರಿಜ ಕದಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ತೆ ಬಾಕ್ಡಿ, ಗುರು, ತು ಪ್ರವಾದಿ ವ್ಹೈ ಕೈನ ಮನೆ ದಿಕ್ಹಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ಹಮಾರಾ ಸಮಾರ್ಯಾನಾ ಪಿತ್ರೊ ಆ ಡೊಂಗರಪರ ಆರಾಧನಾ ಕರ್ತಾತಾ ತೆನೈಸೊ ಮನಕ್ಹೊ ಆರಾಧನಾ ಕರಾನಿ ಜ಼ಗಾ ಯೆರುಸಲೆಮ ವ್ಹೈ ಕೈನ ಯೆಹುದಿಯೊ ಥಯಲ ತುಮೆ ಕವೊಶಿ\" ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ಯೆಸು ತಿನೆ\"ಎ ಬಾಕ್ಡಿಮನೆ ನಂಬ! ತು ಹಬ್ದಾತಿ ಕೆಳಾಮಾಜ ಬಾನೆ ಯೆರುಸಲೆಮಾ ರ‍್ಹೈನೆಕಾ ಆ ಡೊಂಗರಪರ ರ‍್ಹೈನೆಕಾ ಆರಾಧನಾ ಕರಾನೆ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ತುಮೆ ಸಮಾರ್ಯಾವಾಲಾ ಕಿನೆ ಆರಾದನಾ ಕರಾಡಾಸ ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ಹಮೆ ಯಹುದಿಯೊ ಕಿನೆ ಆರಾದನಾ ಕರಿಯೆಸ ಕೈನ ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಕಾಕದ್ಯಾಮ ಬಿಡುಗಡೆ ಯೆಹುದಿಯೊಕ್ಹುಜ಼ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ಕ್ಹರಿಕ್ಹು ಆರಾಧನಾ ಕರಾಲಾ ಬಾನಿ ಆರಾಧನಾ ಆತ್ಮಾಕ್ಹು ವರಿ ಕ್ಹರಿಕ್ಹು ಕರಾನೊ ಟೈಮ ಆವಸ. ತೆ ಟೈಮ ಹಮ್ನಾಜ ಆಯೊಸ. ವರಿ ತೆವಾಜ ಆರಾಧನಾ ಕರಾಲಾವೊನೆ ಬಾ ಹುಡ್ಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ಕ್ಹುದಾ ಆತ್ಮಾ ವ್ಹೈ. ತಿನಾ ಹುತಿ \"ಕ್ಹುದಾನೆ ಆರಾಧನಾ ಕರಾಲಾ ಆತ್ಮಾಕ್ಹು ಕ್ಹರಿಕ್ಹು ಆರಾಧನಾ ಕರು\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ತೆ ಬಾಕ್ಡಿ ಮಸ್ಸಿಹಾ ಆವಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ. ತೆ ಆತಾಮಾ ಮನೆ ಹರಿ ಯಕ್ಕ ಕವಸ ಕೈನ ಕದಿ. ಮಸ್ಸಿಹಾ ಕದ್ಯಾಮ ಕ್ರಿಸ್ತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ತೆಳಾಮಾ ಯೆಸು ತಿನೆ, ತಾರಾ ಕ್ಹಾತೆ ಬೊಲಾಲೊ ಮಿಜ಼ ತೆ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ತೆ ಟೈಮ್ಮಾ ತಿನಾ ಶಿಷ್ಯಾ ಫರಿನ ಆಯಾ. ಯೆಸು ಯಕ್ಕ ಬಾಕ್ಡಿನಾ ಕ್ಹಾತೆ ಬೊಲಾನು ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ. ತೆನೈಸೊ ತ್ಯುನೆ, ತುನೆ ಸು ಚಾ಼ಯೆ? ಕೈನ ತು ತಿನಾ ಕ್ಹಾತೆ ಸು ಬೊಲಾಡೊಸ? ಕೈನ ತ್ಯುನೆ ಕುನ್ನಜ ತ್ಯುನೊನೆ ಪುಚ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ಪಾಚಾ಼ತಿ ತೆ ಬಾಕ್ಡಿ, ತಿನೊ ಪಾನಿನೊ ಘಡೊ ತ್ಯಾಜ ಛೊಡಿನ ಗಾಮ್ಮಾ ಫರಿನ ಗೈನ ಮನಕ್ಹೊಕನ, ");
INSERT INTO sle_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"ಮಿ ನ್ಯ್ಹಾ ಲಕ್ಕಾಬಿ ಕರಲ ಹರಿ ಯಕಬಿ ಯಕ್ಕ ಮನಕ್ಹ ಮನೆ ಕದ್ಯೊ. ಐನ ತುಮೆ ತಿನೆ ದೆಕೊ. ತೆಜ಼ ಕ್ರಿಸ್ತ ವಸೆ ಸು? ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ತಿನಾಹುತಿ ಮನಕ್ಹೊ ತಿನೆ ದೆಕಾನೆ ಗಾಮ್ಮಾತಾ ಭಾರಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ತೆಕ್ಲಾಮಾಜ಼ ಯೆಸುನಾ ಶಿಷ್ಯಾ \"ಗುರು, ಅನ್ನ ಖಾ ಕೈನ ತಿನೆ ಘನ್ನಾ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ತೆ ವಾತೆ ಯೆಸು, ಮಕನ ಖಾವಾನೆ ಅನ್ನ ಛೆ. ತೆ ಅನ್ನನಾ ಹುತಿ ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ತಿನಾಹುತಿ ಶಿಷ್ಯಾ, ಕುನ್ನಬಿ ತಿನೆ ಪೈಲಾಜ ಅನ್ನ ಲೈನ ದಿದ್ಯಾ ವಸೆ ಸು? ತ್ಯುನೊ-ತ್ಯುನೊಮಾಜ಼ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ಯೆಸು ತ್ಯುನೊನೆ, ಮನೆ ಮೊಕ್ಲಲವಾಲೊ ಮಿ ಸು ಕರು ಕೈನ ಆಸ ಕರಸ ತೆ ಕರಾನುಜ ಮನೆ ಅನ್ನ ವ್ಹೈ. ತೆ ಮನೆ ದಿದಲ ಕಾಮ ಪುರಾ ಕರು. ");
INSERT INTO sle_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ಸುಗ್ಗಿನೆ ಹಜು಼ನ ಚಾರ ಮ್ಹೈನಾ ಕೈದು, ಕೈನ ತುಮೆ ಕವೊಸಿ. ತೆ ಮಿ ತುಮೊನೆ ಕವಾಡ್ಯೊಸ, ತುಮಾರಾ ಡೊಳಾ ಖುಲ್ಲಾ ಕರೊ. ಖೆತರನಾ ಸುತ್ತೆ ದೆಕೊ, ತೆ ಕಾಟಾನೆ ತಯ್ಯಾರ ಥಯಾಸ.. ");
INSERT INTO sle_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ಹಮ್ನಾಬಿ, ಬೆಳಿ ಕಾಟಾಲಾವೊನೆ ಕುಲಿ ಮಳಸ. ತೆ ಬೆಳಿ ಹಮೆಶಾ ರ‍್ಹವಾನೆ ಜ಼ಲಮನಾ ಹುತಿ ಮಳಾವಸ. ತಿನಾ ಹುತಿ ಬಿತ್ತಾಲಾ ವರಿ ಕಾಟಾಲಾ ಮಳಿನಜ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ಯಕ್ಲೊ ಬಿತ್ತಸ, ಯಕ್ಲೊ ತೆ ಬೆಳೆನೆ ಕಾಟಸ. ಕವಾನಿ ಯಕ್ಕ ಕಹಾವತ ಕ್ಹರಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ತುಮೆ ನೈ ರಾಬಲ ಬೆಳಿ ಕಾಟಾನೆ ತುಮೊನೆ ಮೊಕ್ಲಾಡ್ಯೊಸ. ಬಿಜಾ಼ ರಾಬ್ಯಾ, ತೆನೈಸೊ ತ್ಯುನೆ ರಾಬಲ ಹುತಿ ತುಮೆ ಫೈದೊ ಖಾವೊಸಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ತೆ ಗಾಮನಾ ಘನ್ನಾ ಸಮಾರ್ಯಾವಾಲಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ನಂಬ್ಯಾತಾ. ಕಾಕದ್ಯಾಮ ತೆ ಬಾಕ್ಡಿ ತಿನಾಹುತಿ ತ್ಯುನೊನೆ\"ಮಿ ಕರಲ ತೆಕ್ಲುಬಿ ಮನೆ ತೆ ಕದ್ಯೊತೊ\" ಕೈನ ಕದಿತಿ. ");
INSERT INTO sle_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ಸಮಾರ್ಯಾವಾಲಾ ಯೆಸುಕನ ಐನ ಹಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೆ ಕೈನ ಕೈಲಿದ್ಯಾತಾ. ತಿನಾಹುತಿ ತೆ ತ್ಯಾ ಬೆ ದಿನ್ನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ತೆ ಕದಲ ವಾತೊ ತ್ಯಾನಾ ಮನಕ್ಹೊ ಘನ್ನಾ ನಂಬ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ತ್ಯುನೆ ತೆ ಬಾಕ್ಡಿ ತೆ ಕದಲ ವಾತೊಕ್ಹು ಹಮೆ ಯೆಸುನೆ ನಂಬ್ಯಾತಾ. ತಿನಾ ಹುತಿ ಹಮೆಜ಼ ಖುದ್ದ ದೆಕಿನ ಹಮೆ ನಂಬಿಯೆಸ. ಕ್ಹರಿಮಾಜ಼ ಎಜ಼ ದುನಿಯಾನೆ ವಚಾ಼ಡಾಲೊ ವ್ಹೈ ಹಮ್ನಾ ಹಮೊನೆ ಗ್ವತ್ತ ಥಯುಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ಬೆ ದಿನ್ನ ತ್ಯಾ ರ‍್ಹಯಲ್ಪರ ಯೆಸು ತ್ಯಾಂತೊ ಗಲಿಲಾಯೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ಪ್ರವಾದಿನೆ ತಿನಾ ಸ್ವಂತ ಗಾಮ್ಮಾ ಮರ್ಯಾದಿ ನತ್ತಿ ಖುದ್ದನಾ ಹುತಿ ಯೆಸುಜ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ತೆ ಗಲಿಲಾಯಯೆ ಆತಾಮಾ, ತ್ಯಾನಾ ಮನಕ್ಹೊ ತಿನೆ ಬಲೈ ಲಿದ್ಯಾ. ಕಾಕದ್ಯಾಮ ತೆ ಫಸ್ಕ ಸನ್ನನಾ ಟೈಮ್ಮಾ ಯೆಸು ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊ ದೆಕ್ಯಾತಾ. ತೆ ಸನ್ನಮಾ ತೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಗಲಿಲಯಾಯೆ ಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ಯೆಸು ಗಲಿಲಾಯನಾ ಕಾನಾ ಗಾಮೆ ವರಿ ಯಕ್ಕೆಮ ಆಯೊ. ತೆ ಪಾನಿಕ್ಹು ದ್ರಾಕ್ಷಿಯೊನು ರಕ್ಹ ಕರಲ ತೆ ಗಾಮ್ಮಾ ವ್ಹೈ. ತೆಜ಼ ಗಾಮ್ಮಾ ಯಕ್ಕ ಮ್ಹೊಟೊ ಅದಿಕಾರಿ ಕಪೆನೌರ್ಮಿಮಾ ರ‍್ಹತೊತೊ. ತಿನಾ ದಿಕ್ರಾನೆ ಅರಾಮ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ಯೆಸು ಯುದೆಯತೊ ಐನ ಗಲಿಲಾಯಮಾ ಛೆ ಕೈನ ಸುದ್ದಿ ತೆ ಐಕ್ಯೊ. ತಿನಾ ಹುತಿ ತೆ ತಿಕನ ಗೈನ ತಿನಾ ದಿಕ್ರಾನೆ ಅರಾಮ ಕರಾನಾಹುತಿ ತಿನೆ ಕಪೆನೌರ್ಮಿ ಔ ಕೈನ ತಿಕನ ಕೈಲಿದ್ಯೊ. ತಿನೊ ದಿಕ್ರೊ ಮರ್ವಾನಿ ಪರಸ್ತಿತಿಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ಯೆಸು ತಿನೆ\"ಸುಚಕ ಕಾಮೊ ವರಿ ಘಾಬ್ರಾಥಾವಾನಾ ಕಾಮೊ ದೆಕ್ಯಾವಾಚಿ ಮನೆ ನಂಬತಾಜ಼ ನೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ತೆ ಮ್ಹೊಟೊ ಅದಿಕಾರಿ\"ಸ್ವಾಮಿ, ಮಾರೊ ದಿಕ್ರೊ ಮರಾತಿ ಪೈಲಾಜ ತು ಔ\" ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ಯೆಸು ತಿನೆ\"ಜಾ಼ ತಾರೊ ದಿಕ್ರೊ ವಾಚಸ \"ಕೈನ ಕದ್ಯೊ. ಯೆಸುನಿ ವಾತ ನಂಬಿನ ತೆ ತಿನಾ ಘರೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ತೆ ಘರೆ ಜಾ಼ತಾಮಾ ತಿನಾ ಆಳೊ ತಿಕನ ಐನ\"ತಾರೊ ದಿಕ್ರೊ ಅರಾಮ ಥಯೊಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ತೆ, ಮಾರಾ ದಿಕ್ರಾನೆ ಕೆಳಾಮಾ ಅರಾಮ ಥಯು ಕೈನ ಪುಚ್ಚೊ. ತೆಳಾಮಾ ತೆ ಆಳೊ \"ತಾರಾ ದಿಕ್ರಾನೆ ಕಾಲ ದುಪಾರೆಜ ಯಕ್ಕ ವಾಸ್ತಾ ತಿನೆ ರ‍್ಹಯಲ ತೌ ಛೊಡಿನ ಗೈ ಪಾಡ್ಯೊಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ತಾರೊ ದಿಕ್ರೊ ವಾಚಸ\" ಕೈನ ಯೆಸು ಕದಲ ಎಜ಼ ಟೈಮೆ ವ್ಹೈ ಕೈನ ತೆ ದಿಕ್ರಾನಾ ಬಾನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತಿನಾಹುತಿ ತೆ ವರಿ ತಿನಾ ಘರವಾಲಾ ಕ್ಹಾರಾ ಯೆಸುನೆ ನಂಬ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ಯೆಸು ಯುದೆಯತೊ ಗಲಿಲಾಯಯೆ ಆಯಲ್ಪರ ಎ ಬೆಂವಾ ಸುಚಕ ಕಾರ್ಯ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ಎ ಥಯಲ್ಪರ ಯೆಸು ಯೆಹುದಿಯೊನಾ ಯಕ್ಕ ಸನ್ನನಾ ಹುತಿ ಯೆರುಸಲೆಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ಯೆರುಸಲೆಮಾ ಪಾಂಚ಼ ಮಂಟಪೊ ಮಳಲ ಯಕ್ಕ ವ್ಹಂಡ ಛೆ. ಯಹುದಿಯೊನೆ ವಾತೊಮೊ ತಿನೆ \"ಬೆತ್ಸಥ\" ಕೈನ ಕವಸ. ಎ ವ್ಹಂಡ \"ಬಕ್ರಾನು ಬಾಕಲ\" ಕವಾನಿ ಜ಼ಗಾನಾ ನಜಿಕ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ವ್ಹಂಡಕನ ರ‍್ಹಯಲ ಮಂಟಪಮಾ ಘನ್ನಾ ರೊಗಿಯೊ ಪಡಲ ರ‍್ಹತಾತಾ. ತ್ಯುನಾಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಕುಡ್ಡಾ ವ್ಹತ್ತಾ. ದಕ್ಹಾ ಜ಼ನಾ ಲಂಗ್ಡಾ ವ್ಹತ್ತಾ, ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಲಕ್ವೊ ಮಾರಲವಾಲಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಪಾನಿ ಹಲ್ಲೆಲಕ್ಕಾ ಕೈದತಾ ರ‍್ಹತಾತಾ, ");
INSERT INTO sle_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ಕಾಕದ್ಯಾಮ ಹರಿಯಕ್ಕಸಲಾ ದಕ್ಹೊ ಟೈಮ್ಮ ಥಯಲ್ಪರ ಪ್ರಭುನೊ ದುತ ಹೆಟೊ ಉತ್ರಿನ ಐನ ತೆ ವ್ಹಂಡಮಾನು ಪಾನಿ ಹಲಾತೊತೊ ಅರಾಮ ನೈಸೊವಾಲೊ ಕಯೊಬಿ ಮನಕ್ಹ ಪಾನಿ ಹಲ್ತಾಮಾ ಪೈಲಾ ಗೈಯಾಮ ತೆ ಕಯಾಬಿ ರೊಗ್ಮಾ ರ‍್ಹಯೊತಬಿ ಅರಾಮಾ ಥಾತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ಮುವತ್ತಪರ ಆಟ ವರಕ್ಹತೊ ರೊಗ್ಮಾ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲೊ ತ್ಯಾ ಪಡಲ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ಯೆಸು ತಿನೆ ದೆಕ್ಯೊ. ತೆ ಘನ್ನಾ ದಿನ್ನತೊ ರೊಗ್ಮಾ ರ‍್ಹಯಲ ತಿನೆ ಗ್ವತ್ತ ವ್ಹತ್ತೊ. ತಿನಾಹುತಿ ತೆ ತಿನೆ\"ಅರಾಮ ಥಾವಾನೆ ಮನಸ ಛೆ ಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ತೆ ರೊಗಿ\"ಅಯ್ಯಾ, ಪಾನಿ ಭರ್ತಾಮಾ ಉತಾರಾನೆ ಮನೆ ಕುನ್ನಜ ಆಸ್ರೊ ಕರ್ತು ನೈ. ಮಿ ಕ್ಹಾರಾವೊತಿ ಪೈಲಾಜ ಪಾನಿಮಾ ಉತ್ರಾನೆ ಕೊಶಿಶ ಕರುಸ. ತೆನೈಸೊ ಹರಯಕ್ಕ ಸಲಾ ಮತ್ತಿಬಿ ಪೈಲಾಜ ಉತ್ರಿಪಡಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ತೆಳಾಮಾ ಯೆಸು\"ಉಟಿನ ಹುಬ್ರೆ! ತಾರು ವಚ್ಚಾ಼ನು ಉಚೈನ ಲಿನ ಜಾ಼\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ತೆಳಾಮಾಜ಼ ತೆ ಮನಕ್ಹ ಅರಾಮ ಥೈನ ತಿನಾ ವಚ್ಚಾನ ಲಿನ ಚಾಲ್ಯೊ. ಎ ಕ್ಹಾರು ಥಯಲ ಸಬ್ಬತನಾ ದಿನ್ನಮಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ತಿನಾಹುತಿ ಯೆಹುದಿಯೊನಾ ಅದಿಕಾರಿಯೊ ಅರಾಮ ಥಯಲ ತೆ ಮನಕ್ಹನೆ\"ಆಜ ಸಬ್ಬತನೊ ದಿನ್ನ ವ್ಹೈ. ತು ವಚ್ಚಾ಼ನಾ ಉಚೈಲಿನ ಜಾ಼ವಾನು ಅಪ್ನಾ ಧರಮಶಾಸ್ತ್ರನಾ ವಿರುದ್ದ ವ್ಹೈ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ತೆಳಾಮಾ ತೆ\"ಮನೆ ಅರಾಮ ಕರಲವಾಲೊ ಮನಕ್ಹ \"ತಾರು ವಚ್ಚಾ಼ನು ಲಿನ ಜಾ಼\" ಕದ್ಯೊ ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ತಿನೆ ತ್ಯುನೆ\"ತಾರು ವಚ್ಚಾ಼ನು ಉಚೈಲಿನ ಜಾ಼ವಾನೆ ತುನೆ ಕದಲವಾಲು ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ತೆನೈಸೊ ಅರಾಮ ಥಯಲ ಮನಕ್ಹನೆ ಯೆಸು ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಗ್ವತ್ತ ನ್ಹೊತು. ತೆ ಜ಼ಗಾಪರ ಘನ್ನಾ ಮನಕ್ಹೊನು ಗುಂಪ ವ್ಹತ್ತು. ಯೆಸು ತೆ ಜ಼ಗಾತೊ ತ್ಯುನೊಕಂತೊ ಗಪ್ಪ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ತೆ ಥಯಲ್ಪರ ಯೆಸು ತೆ ಮನಕ್ಹನೆ ದೆವಾಲಯಮಾ ದೆಕಿನ ತಿನೆ, ಐಕ ಹಮ್ನಾ ತು ಅರಾಮ ಥಯೊಸ. ತೆನೈಸೊ ಪಾಪ ಕರಾನು ಛೊಡಿಪಾಡ. ತಿನಾಹುತಿ ತುನೆ ಕಯುಜ಼ ಕೆಟ್ಟ ಥೌ ನೈ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ತೆಳಾಮಾ ತೆ ಮನಕ್ಹ ತೆ ಯಹುದ್ಯೊನಾ ಅದಿಕಾರಿಯೊ ಕನ ಗೈನ ತಿನೆ ಅರಾಮ ಕರಲವಾಲೊ ಯೆಸು ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆಸು ಎ ಕಾಮೊ ಸಬ್ಬತ ದಿನ್ನೊಮಾ ಕರಲಹುತಿ ತ್ಯುನೆ ತಿನೆ ತ್ರಾಸ ಕರಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ \"ಮಾರೊ ಬಾ ತಿನಾ ಕಾಮೊ ಕೆಳಾಮಾಬಿ ಕರ್ತೊಜ ರ‍್ಹವಸ. ತಿನಾಹುತಿ ಮಿಬಿ ಕಾಮ ಕರ್ತೊಜ\" ಕೈನ ತಿನಾಹುತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ಎ ವಾತ ಯೆಹುದಿನಾ ಅದಿಕಾರಿಯೊ ತಿನೆ ಖಲಾಸ ಕರುಜ ಕೈನ ಫೈಸಲೊ ಕರಾ ವರ್ಕ್ಹು ಥಯು, ತೆಕ್ಲುಜ ನೈಸೊ ತೆ ಕ್ಹುದಾನಿ ಸಬ್ಬತನು ನಿಯಮ ತೊಡ್ಯೊ ನ್ಹೊತೊ, ತೆನೈಸೊ ತೆ ಕ್ಹುದಾ ತಿನೊ ಸ್ವಂತ ಬಾ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ ವರಿ ಇನಾಲಿಂಗತ ತಿನಾಕ್ಹು ತಿನೆ ಕ್ಹುದಾ ಲಿಂಗತ ಕರಿಲಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ತಿನಾಹುತಿ ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ದಿಕ್ರೊ ತಿನಾಕ್ಹು ತೆ ಸುಜ಼ ನೈ ಕರತೊ, ಬಾ ಕರಾನು ದೆಕಿನ ತೆಬಿ ತಿಮ್ಮಜ ಕರಸ. ಬಾ ಕರಾನಾ ಕಾಮೊಜ ದಿಕ್ರೊಬಿ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ಬಾ ದಿಕ್ರಾನೆ ಮಯಾ ಕರಸ ವರಿ ತೆ ಕರಾನಾ ಕ್ಹಾರಾ ಕಾಮೊ ದಿಕ್ರಾನೆ ದೆಕಾಡಸ. ಇತ್ತಿಬಿ ಹೆಚ್ಕಿ ಕಾಮೊ ಬಾ ದಿಕ್ರಾನೆ ದೆಕಾಡಸ. ತೆಳಾಮಾ ತುಮೆ ಕ್ಹಾರಾ ಘಾಬ್ರಾ ಥಾವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ಬಾ ಮರಲವಾಲಾವೊನೆ ಉಟಾಡಿನ ತ್ಯುನೊನೆ ಜ಼ಲಮ ದಿವಸ. ತಿನಾಲಿಂಗತ ದಿಕ್ರೊಬಿ ತಿನೆ ಚಾ಼ಯೆ ಥಯಲವಾಲಾವೊನೆ ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","\"ಎನೈಸೊ ಬಾ ತಿನಾಕ್ಹು ತೆ ಕಿನೆ ಫೈಸಲೊ ಕರ‍್ತೊ ನೈ ತೆನೈಸೊ ಬಾ ಪೈಸ್ಲೊ ಕರಾನು ಪುರಾ ಅದಿಕಾರ ದಿಕ್ರಾನೆ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ತಿನಾಹುತಿ ಕ್ಹಾರಾ ಜ಼ನಾ ಬಾನೆ ಮರ್ಯಾದಿ ದಿದಲ ಲಿಂಗತ ದಿಕ್ರಾನೆಬಿ ಮರ್ಯಾದಿ ದ್ಯುಕೈನ ಕ್ಹುದಾ ಇಮ್ಮ ಕರ‍್ಯೊ. ಕುನ್ನ ದಿಕ್ರಾನೆ ಮರ್ಯಾದಿ ನೈ ದೆತು ತೆ ತಿನೆ ಮೊಕ್ಲಲವಾಲೊ ಬಾನೆ ಮರ್ಯಾದಿ ನೈ ದೆತೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಮಾರಿ ವಾತ ಐಕಿನ ಮನೆ ಮೊಕ್ಲಲವಾಲಾನೆ ನಂಬಾಲೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಿಲಿದ್ಯೊಸ. ತಿನೆ ಫೈಸಲೊ ಥಾತೊ ನೈ. ತೆನೈಸೊ ತೆ ಹಮ್ನಾಜ ಮರಣ ದಾಟಿನ ಜ಼ಲಮಮಾ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ಮರಲವಾಲಾ ಕ್ಹುದಾನಾ ದಿಕ್ರಾನು ಅವಾಜ಼ ಐಕಾನೊ ದಿನ್ನ ಆವಸ. ತೆ ಹಮ್ನಾಜ ಆಯುಸ. ಕುನ್ನ ಐಕಸ ತ್ಯುನೆ ಜ಼ಲಮ ವ್ಹಂದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ಬಾ ಜ಼ಲಮ ದಿವಾನಿ ತಾಕತ ತೆ ವ್ಹಂದಲಲಿಂಗತ ದಿಕ್ರಾನೆ ಜ಼ಲಮ ದಿವಾನಿ ತಾಕತ ದಿದ್ಯೊಸ, ");
INSERT INTO sle_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ವರಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೊ ಫೈಸಲೊ ಕರಾನು ಅದಿಕಾರ ಬಾ ದಿಕ್ರಾನೆ ಬಿ ದಿದ್ಯೊಸ. ಕಾಕದ್ಯಾಮ ತೆ ದಿಕ್ರೊ ಮನಕ್ಹೊನೆ ದಿಕ್ರೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","\"ತಿನಾಹುತಿ ಘಾಬ್ರಾ ಥಾವೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ಮರಲವಾಲಾ ಕ್ಹಾರಾ ತಿನೊ ಅವಾಜ಼ ಐಕಾನೊ ದಿನ್ನ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ವರಿ ತ್ಯುನೆ ತಿವ್ನೊ ಮಾತೊ ಉಟಿನ ಆವಸ; ಕುನ್ನ ಚೊ಼ಕು ಕರಲ ರ‍್ಹವಸ ತ್ಯುನೆ ಜಿವ್ತಾ ಥೈನ ಉಟಸ, ವರಿ ಕುನ್ನ ಕೆಟ್ಟ ಕರ‍್ಯುಸ ಜಿವ್ತಾ ಥೈನ ತ್ಯುನೊನೆ ಪೈಸ್ಲೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","\"ಮಾರಾಕ್ಹು ಮಿಜ಼ ಸುಜ಼ ಕರತೊ ನೈ. ಕ್ಹುದಾ ಕದಲ ತಿಮ್ಮಜ ಮಿ ಐಕಿನ ಫೈಸಲೊ ಕರುಸ. ತಿನಾಹುತಿ ಮಾರೊ ಫೈಸಲೊ ಕರೆಟ್ಟ ವ್ಹೈ. ಕಾಕದ್ಯಾಮ, ಮಾರಿ ಮರ್ಜಿ ಲಿಂಗತ ಕರಾಡ್ಯೊ ನತ್ತಿ. ಮನೆ ವಳಾಯಲವಾಲಾನಿ ಮರ್ಜಿ ಲಿಂಗತ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","\"ಮಾರಾ ಹುತಿ ಮಿಜ಼ ಸಾಕ್ಷಿ ದಿದ್ಯೊಮ, ತೆ ಸಾಕ್ಷಿ ಕ್ಹರಿನಿ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ತೆನೈಸೊ ಮಾರಿ ಹುತಿ ಸಾಕ್ಷಿ ದಿವಾಲೊ ಯಕ್ಕ ಮನಕ್ಹ ಛೆ. ತೆ ದಿವಾನಿ ಸಾಕ್ಷಿ ಕ್ಹರಿಜ ವ್ಹೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","\"ತುಮೆ ಯೊಹಾನ ಕನ ಸಂದೆಶ ಕವಾಲಾವೊನೆ ಮೊಕ್ಲ್ಯಾ. ತೆ ತುಮೊನೆ ಕ್ಹರಿನಾ ಹುತಿ ಸಾಕ್ಷಿ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ತೆನೈಸೊ ಮಾರಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಕವಾನಾ ಹುತಿ ಮನೆ ಮನಕ್ಹನಿ ಸಾಕ್ಷಿನಿ ಜರುರತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ತುಮೊನೆ ಬಿಡುಗಡೆ ಥಾವಾನಾ ಹುತಿ ಮಿ ಎ ಸಂಗತಿಯೊ ಕವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ಯೊಹಾನ ದಿವ್ವೊ ಲಾಗಲಲಿಂಗತ ವ್ಹತ್ತೊ ತೆ ಉಜಾಲು ದಿದ್ಯೊ, ವರಿ ತುಮೆ ತಿನು ಉಜಾಲಾನೆ ದಕ್ಹಾ ಟೈಮ ಖುಶಿಕ್ಹು ಅನುಭವ ಲಿವಾನೆ ದೆಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ತೆನೈಸೊ ಮಾರಿ ಸಾಕ್ಷಿ ಯೊಹಾನತಿಬಿ ಮ್ಹೊಟಿ ಸಾಕ್ಷಿ ಛೆ. ಮಿ ಕರಾನಾ ಕಾಮೊಜ ಮಾರಿ ಸಾಕ್ಷಿಯೊ ಥಯೊಸ. ಬಾ ಮನೆ ದಿದಲ ಎ ಕಾಮೊಜ, ಬಾ ಮನೆ ವಳಾಯೊಸ ಕೈನ ದೆಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ವರಿ ಮನೆ ವಳಾಯಲ ಬಾ ಮಾರಾ ಹುತಿ ಸಾಕ್ಷಿ ದಿದ್ಯೊಸ. ತೆನೈಸೊ ತುಮೆ ತಿನಿ ಆವಾಜ ಕೆಳಾಮಾಜ ಐಕ್ಯಾ ನೈ. ತೆ ಕಿಮ್ಮ ಛೆ ಕೈನ ತುಮೆ ಕೆಳಾಮಾಜ ದೆಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ವರಿ ತುಮೆ ಬಾನು ಉಪದೆಶನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ಕಾಕದ್ಯಾಮ ಬಾ ವಳಾಯಲವಾಲಾನೆ ತುಮೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ತುಮೆ ಪವಿತ್ರ ಗ್ರಂಥೊ ಅಬ್ಯಾಸ ಕರೊಶಿ. ಕಾಕದ್ಯಾಮ ತೆ ಪವಿತ್ರ ಗ್ರಂಥ ತುಮೊನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವಸ ಕವಾನು ತುಮಾರಿ ವಿಚಾರ ವ್ಹೈ ತೆನೈಸೊ ತೆಜ಼ ಪವಿತ್ರ ಗ್ರಂಥೊಮಾ ಮಾರಾ ಹುತಿ ತಿಳ್ಸಾವಸ! ");
INSERT INTO sle_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ತೆನೈಸೊ ಜ಼ಲಮ ವ್ಹಂದಿಲಿವಾನೆ ತುಮೆ ಮಕನ ಆವಾನೆ ಮನಸ ಕರ‍್ತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ಮನಕ್ಹತಿ ಆವಾನಿ ಹೊಗಳಿಕೆ ಮನೆ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ತೆನೈಸೊ ತುಮೆ ಕೆವಾ ಮನಕ್ಹೊ ವ್ಹೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ವರಿ ಕ್ಹುದಾನಾ ಉಪ್ಪರ ತುಮೊನೆ ಮಯಾ ನತ್ತಿ ಕೈನ ಮನೆ ಗ್ವತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ಮಿ ಮಾರಾ ಬಾನಾ ಅದಿಕಾರನಾ ಕ್ಹಾತೆ ಆಯೊಸ. ತೆನೈಸೊ ತುಮೆ ಮನೆ ಸ್ವಿಕಾರ ನೈ ಕರಿಲೆತಾ. ತೆನೈಸೊ ಕುನ್ನಬಿ ಯಕ್ಲೊ ತಿನಾ ಸ್ವಂತ ಅದಿಕಾರಕ್ಹು ಆಯಾಮ ತುಮೆ ತಿನೆ ಸ್ವಿಕಾರ ಕರೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ತುಮೆ ಯಕ್ನೆ ಯಕ್ಕ ಸನ್ಮಾನ ದ್ಯು ಕೈನ ಆಸ ಕರೊಶಿ. ತೆನೈಸೊ ಯಕ್ಕಜ಼ ಕ್ಹುದಾತಿ ಆವಾನಿ ಸನ್ಮಾನ ಲಿವಾನೆ ತುಮೆ ಕೆಳಾಮಾಜ ಕೊಶಿಶ ನೈ ಕರ‍್ತಾ. ಇಮ್ಮ ರ‍್ಹಯುಮ ತುಮೆ ಮನೆ ಕಿಮ್ಮ ಬರೊಕ್ಹೊ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ಮಿ ಬಾನಾ ಕ್ಹಾಮೊ ಹುಬ್ರೈನ ತುಮೊನೆ ತಪ್ಪ ಕರಲವಾಲಾ ವ್ಹೈ ಕೈನ ಕೌಸ ಕೈನ ತುಮೆ ವಿಚಾರ ಕರೊ ನಕೊ. ತುಮೊನೆ ವಚಾ಼ಡಸ ಕೈನ ತುಮೆ ಆಸ ಕರಲ ಮೊಶೆ ತುಮಾರಾ ಉಪ್ಪರ ಸಾಕ್ಷಿ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ತುಮೆ ಕ್ಹರಿಬಿ ಮೊಶೆನೆ ಬರೊಕ್ಹೊ ಕರಲ ರ‍್ಹವತೊ, ಮಪರಬಿ ಬರೊಕ್ಹೊ ಕರ‍್ತಾತಾ. ಕಾಕದ್ಯಾಮ ತೆ ಮಾರಾ ಹುತಿಜ ಬರ್ದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ತೆನೈಸೊ ಮೊಶೆ ಬರ್ದಲ ತುಮೆ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ತಾ ಇಮ್ಮ ರ‍್ಹಯುಮ ಮಿ ಕವಾನಿಯೊ ವಾತೊಪರ ತುಮೆ ಕಿಮ್ಮ ಬರೊಕ್ಹೊ ಕರ ಸಕೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ತೆಳಾಮಾ, ಯೆಸು ಗಲಿಲಾಯ ಸಮುಂದರ ದಾಟಿನ ಬಿಜಿ ದಂಡಿಯೆ ಗಯೊ. ತೆ ಸಮುಂದರನೆ ತಿಬೆರಿಯ ಸಮುಂದರಬಿ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಪಾಚಾ಼ ಗಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಯೆಸುನಾ ಮುಲಕ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರಾನು ಅದ್ಭುತ ದೆಕ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ತೆಳಾಮಾ ಯೆಸು ಡೊಂಗರ ಚ಼ಡಿನ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಬೈಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ಯಹುದ್ಯೊನಾ ಫಸ್ಕ ಸನ್ನ ಘನ್ನು ನಜಿಕ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ಯೆಸು ಡೊಳಾ ಉಚೈನ ದೆಕ್ತಾಮಾ, ತಿಕನ ಆವಾನು ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪನೆ ದೆಕಿನ ತಿನಾಹುತಿ ಫಿಲಿಪ್ಪನೆ\"ಎ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಚಾ಼ಯೆ ಥಯಲ ತೆಕ್ಲು ಅನ್ನ ಅಪೆ ಕಿಜ್ಗಾ ಲಿಯೆ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ಫಿಲಿಪ್ಪನೆ ಪರಿಕ್ಷಾ ಕರಾಹುತಿ ತೆ ಅಮ್ಮ ಪುಚ್ಯೊ. ತೆನೈಸೊ ಕ್ಹರಿಮಾಜ಼ ತೆ ಸು ಕಾಮ ಕರು ಕವಾನು ತಿನೆ ಪೈಲಾಜ ಗ್ವತ್ತ ವ್ಹತ್ತು ");
INSERT INTO sle_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ಫಿಲಿಪ್ಪ \"ನ್ಹ್ಯಾ ರ‍್ಹಯಲ ಹರಿ ಯಕ್ಲಾನೆ ರೊಕ್ಲಾನು ಯಕ್ಕ ತುಕ್ಡೊ ದ್ಯು ಕದ್ಯಾಮ, ಬೆಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ತಿಬಿ ಜಾಸ್ತಿ ಚಾ಼ಯೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ಯೆಸುನೊ ಬಿಜೆಕ್ಲೊ ಶಿಷ್ಯೊ ರ‍್ಹಯಲ ಸಿಮೊನ ಪೆತ್ರಾನೊ ಭೈ ಅಂದ್ರೆಯಾ ಕದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"ನ್ಹ್ಯಾ ರ‍್ಹಯಲ ಯಕ್ಲಾ ಪಟ್ಟಾಕನ ಘ್ಹೌನಾ ಪಾಂಚ಼ ರೊಕ್ಲಾ ವರಿ ಬೆ ನ್ಹಾನಿಯೊ ಮಚ್ಲಿಯೊ ಛೆ. ತೆನೈಸೊ ಕ್ಹರಿಮಾಜ಼ ತೆ ಎ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಬಸ್ಸ ಥಾತು ನೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ಯೆಸು\"ಮನಕ್ಹೊನೆ ಬೈಟಾನೆ ಕವೊ\" ಕೈನ ಕದ್ಯೊ. ತೆ ಜ಼ಗಾಪರ ಚಾರೊ ಘನ್ನೊ ಬೆಳದ್ಯೊತೊ ತ್ಯಾ ಬೈಟಲವಾಲಾವೊಮಾ ಕಮ್ಸೆ ಕಮ ಪಾಂಚ಼ ಹಜಾರ ದಾಣ್ಗಾಜ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ಪಾಚಲ್ತೊ ಯೆಸು ತೆ ರೊಕ್ಲಾ ಲಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕರಿನ, ಬೈಟಲ ಮನಕ್ಹೊನೆ ವಾಟ್ಯೊ. ತೆ ಮಚ್ಲಿಯೊನೆಬಿ ತಿನಾಲಿಂಗತ ಕರ‍್ಯೊ. ಕ್ಹಾರಾ ಜ಼ನಾ ತ್ಯುನೊನೆ ಚಾ಼ಯೆ ಥಯಲ ತೆಕ್ಲು ಕೈನ ತೃಪ್ತ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ತ್ಯುನೆ ಕ್ಹಾರಾ ಕೈನ ತೃಪ್ತ ಥಯಲ್ಪರ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ\"ಉಗ್ರಲ ತುಕ್ಡಾ ಕ್ಹಾರಾ ಜಮಾ ಕರೊ. ಕಯುಜ಼ ಹಾಳ ಕರೊ ನಕೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ವರಿ ಶಿಷ್ಯಾ ಮನಕ್ಹೊನೆ ವಾಟಲ ಪಾಂಚ಼ ರೊಕ್ಲಾಮಾ ಉಗ್ರಲ ತುಕ್ಡಾವೊಕ್ಹು ಬಾರಾ ಟೊಪ್ಲಿಯೊ ಭರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ಯೆಸು ಕರಲ ಎ ಅದ್ಭುತ ಕಾಮ ದೆಕಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ\"ಎ ದುನಿಯಾಮಾ ಆವಾನೊ ರ‍್ಹಯಲ ಪ್ರವಾದಿ ಕ್ಹರಿಮಾಜ಼ ಎಜ಼ ವ್ಹೈ\" ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ತಿನೆ ಜಬರದಸ್ತಿಕ್ಹು ರಾಜೊ಼ ಕರಾನೆ ಮನಕ್ಹೊ ವಿಚಾರ ಕರಾಡಾಸ ಕೈನ ಯೆಸುನೆ ಗ್ವತ್ತ ಥೈಯುತು. ತಿನಾಹುತಿ ತ್ಯಾಂತೊ ತೆ ಯಕ್ಲೊಜ ಡೊಂಗರಪರ ವರಿ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ತೆ ದಿನ್ನಾ ಖಾಂಜೆ ಯೆಸುನಾ ಶಿಷ್ಯಾ ಸಮುಂದರನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ತಿನಾಹುತಿ ಶಿಷ್ಯಾ ಹಡ್ಗೊ ಚ಼ಡಿನ ಸಮುಂದರನಾ ತಿನಾ ದಂಡಿತಾ ಕಪೆನೌರ್ಮಿಯೆ ಚಾ಼ಲ್ಯಾತಾ. ತೆಳಾಮಾ ಅಂದಾರು ಥಯುತು. ಯೆಸು ತ್ಯುನೊಕನ ಹಜು಼ನ ಆಯೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ತೆಳಾಮಾ ವಾರೊ ಘನ್ನೊ ಜೊ಼ರ ಆವಾಡ್ಯೊತೊ. ಸಮುಂದರನಾ ಧಡ್ಕಿಯೊ ಮ್ಹೊಟಿಯೊ ಥಾವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ತ್ಯುನೆ ಹುಟ್ಟ ಘಾಲತಾ ತನ್ನ ನೈತೊ ಚಾರ ಮೈಲ ಯಕ್ಕ ಹಡಗಾನೆ ಚಲಾಯಲ ಪರ ಯೆಸುನೆ ದೆಕ್ಯಾ. ತೆ ಪಾನಿ ಪರ ಚಾಲ್ತೊ ಹಡಗಾನಾ ನಜಿಕ ಆವಾನು ದೆಕಿನ ತ್ಯುನೆ ಭುಚ್ಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ಯೆಸು ತ್ಯುನೊನೆ\"ಭುಚ಼ಕೊ ನಕೊ, ಮಿಜ಼ ವ್ಹೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ತೆಳಾಮಾ ತ್ಯುನೆ ಯೆಸುನೆ ಹಡಗಾಮಾ ಬಲೈಲ್ಯು ಕೈನ ಕರ‍್ಯಾತಾ. ತೆಕ್ಲಾಮಾಜ಼, ತ್ಯುನೆ ಜೌ ಕೈನ ರ‍್ಹಯಲ ಜ಼ಗಾನಿ ದಂಡಿಯೆ ಹಡ್ಗೊ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ಮರ್ನಾ ದಿನ್ನೆ ಬಿಜಿ ದಂಡಿಯೆ ರ‍್ಹಯಲ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ತ್ಯಾ ಯಕ್ಕಜ಼ ಹಡ್ಗೊ ವ್ಹತ್ತೊ ಕೈನ ಗ್ವತ್ತ ವ್ಹತ್ತು. ಯೆಸು ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಗಯೊ ನ್ಹೊತೊ ಕೈನ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ತಿನೆ ಪಾಚಾ಼ ಛೊಡಿನ ಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ತೆಳಾಮಾ ಬಿಜಿಯೊ ಹಡಗಾ ತಿಬೆರಿಯಸ ಸಮುಂದರಮಾತಾ ಕರ್ತಾನೆ ಸ್ತೊತ್ರಾ ಕದಲ್ಪರ ದಿದಲ ರೊಕ್ಲಾ ಮನಕ್ಹೊನು ಗುಂಪ ಖಾದಲ ಜ಼ಗಾನಾ ನಜಿಕ ದಂಡಿಯೆ ಐನ ಮುಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ತ್ಯಾ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ದೆಕಿನ ಹಡಗಾ ಚ಼ಡಿನ ಯೆಸುನೆ ಹುಡ್ಕತಾ ಕಪೆನೌರ್ಮಿಯೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ಮನಕ್ಹೊ ಯೆಸುನೆ ಸಮುಂದರನಿ ಬಿಜಿ ದಂಡಿಪರ ದೆಕ್ಯಾ. ತ್ಯುನೆ ತಿನೆ\"ಗುರು ತು ನ್ಹ್ಯಾ ಕೆಳಾಮಾ ಆಯೊ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ, ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ತುಮೆ ಮನೆ ಮಿ ಕರಲ ಅದ್ಭುತ ಕಾಮೊ ದೆಕಲಕ್ಹು ಹುಡಕಾಡ್ಯಾ ನತ್ತಿ ತೆನೈಸೊ ರೊಕ್ಲೊ ಪೆಟ ಭರಿನ ಖಾದಲ ಹುತಿ ಹುಡ್ಕಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ಹಾಳ ಥಾವಾನು ರ‍್ಹಯಲ ಅನ್ನನಾ ಹುತಿ ರಾಬೊ ನಕೊ ತೆನೈಸೊ ಹಮೆಶಾನಾ ಜ಼ಲಮ ದಿವಾನು ಅನ್ನನಾಹುತಿ ರಾಬೊ. ತೆ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ದಿವಸ. ತಿಪರ ಬಾ ಥಯಲ ಕ್ಹುದಾ ಅದಿಕಾರನೊ ಶಿಕ್ಕೊ ಮಾರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ಮನಕ್ಹೊ ಯೆಸುನೆ\"ಹಮೆ ಕಯಾ ಕಾಮೊ ಕರು ಕೈನ ಕ್ಹುದಾ ಆಸ ಕರಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ಯೆಸು ತ್ಯುನೊನೆ\"ಕ್ಹುದಾ ಮೊಕ್ಲಲವಾಲಾನೆ ತುಮೆ ನಂಬು ಎ ಕಾಮಜ ಕ್ಹುದಾ ತುಮೊಕ್ಹು ಆಸ ಕರಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ತಿನಾಹುತಿ ಮನಕ್ಹೊ\" ಕ್ಹುದಾ ಮೊಕ್ಲಲವಾಲೊ ತುಜ಼಼ ವ್ಹೈ ಕೈನ ದೆಕಾಡಾನಾ ಹುತಿ ತು ಕಯು ಅದ್ಭುತ ಕಾಮ ಕರಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ಅಪ್ನಾ ಪಿತೃವೊನೆ ಕ್ಹುದಾ ಉಸುಕನಿ ಜಿಮಿನಪರ ದಿದಲ ಮನ್ನಾ ಖಾದ್ಯಾ. ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ \"ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಖಾವಾನೆ ಸ್ವರ್ಗತೊ ರೊಕ್ಲಾ ದಿದ್ಯೊ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ಯೆಸು\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ತುಮಾರಾ, ಮನಕ್ಹೊನೆ ಸ್ವರ್ಗತೊ ರೊಕ್ಲೊ ದಿದಲವಾಲೊ ಮೊಶೆ ನ್ಹವೈ. ತೆನೈಸೊ ಮಾರೊ ಬಾ ತುಮೊನೆ ಸ್ವರ್ಗತೊ ಕ್ಹರಿನೊ ರೊಕ್ಲೊ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ಕ್ಹುದಾ ದಿವಾನೊ ತೆ ರೊಕ್ಲೊ ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆಯೊಸ ವರಿ ದುನಿಯಾನೆ ಜ಼ಲಮ ದಿವಸ. ತೆಜ಼ ಕ್ಹುದಾ ದಿವಾನೊ ರೊಕ್ಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ಮನಕ್ಹೊ ತಿನೆ\"ಗುರು, ತೆ ರೊಕ್ಲೊ ಹಮೊನೆ ಹಮೆಶಾಬಿ ದೆ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿಜ಼ ಜ಼ಲಮ ದಿವಾನೊ ರೊಕ್ಲೊ ವ್ಹೈ. ಮಕನ ಆವಾಲಾನೆ ಕೆಳಾಮಾಜ ಭುಕ್ಕ ಲಾಗ್ತಿ ನೈ. ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ವಾಲಾವೊನೆ ಕೆಳಾಮಾಜ ತರಕ್ಹ ಲಾಗ್ತಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ಮಿ ತುಮೊನೆ ಪೈಲಾಜ ಕದಲ ಲಿಂಗತ, ತುಮೆ ಮನೆ ದೆಕ್ಯಾ ತಬಿ ಹಜು಼ನಬಿ ತುಮೆ ಬರೊಕ್ಹೊ ಕರಾಡ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ಮಾರೊ ಬಾ ದಿವಾನಾ ತೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಮಕನ ಆವಸ. ವರಿ ಕುನ್ನ ಮಕನ ಆವಸ ತ್ಯುನೊನೆ ಮಿ ಕೆಳಾಮಾಜ ಢಕ್ಲಿಪಾಡ್ತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ಕಾಕದ್ಯಾಮ ಮಿ ಸ್ವರ್ಗತೊ ಮಾರಿ ಚಿತ್ತ ಲಿಂಗತ ಕರಾನೆ ಆಯೊಸ ಕೈನ ತಿಳ್ದೊ ನಕೊ. ತೆನೈಸೊ ಕುನ್ನ ಮನೆ ವಳಾಯೊಸ ತಿನಿ ಚಿತ್ತ ಪುರಾ ಕರಾನೆ ಆಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ವರಿ ಮನೆ ಮೊಕ್ಲಲವಾಲಾನಿ ಮರ್ಜಿ ಅಮ್ಮ ವ್ಹೈ ಕ್ಹುದಾ ಮೊಕ್ಲಲವಾಲಾನೆ ಮಿ ಕಿನೆಜ಼ ಜವೈ ಲ್ಯು ನೈ ವರಿ ಲಾಸ್ಟನಾ ದಿನೊಮಾ ಜಿವ್ತೊ ಕರಿ ಉಟಾಡು. ");
INSERT INTO sle_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ದಿಕ್ರಾನೆ ದೆಕಿನ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಹರಿ ಯಕ್ಲೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದ್ಯೊಸ. ಲಾಸ್ಟನಾ ದಿನ್ಮಾ ಮಿ ತೆ ಮನಕ್ಹನೆ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡುಸ ಮಾರೊ ಬಾ ಆಸ ಕರಾನು ಎಜ಼ ವ್ಹೈ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ಯಹುದ್ಯೊ ಯೆಸುನಾ ಹುತಿ ಗುಣ ಗುಟ್ಟಾಡಾತಾ. ಕಾಕದ್ಯಾಮ\"ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆವಾಲೊ ರೊಕ್ಲೊಜ ಮಿ ವ್ಹೈ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ಯಹುದ್ಯೊ, ಎ ಯೊಸೆಫನೊ ದಿಕ್ರೊ ಯೆಸು ನ್ಹವೈ ಸು? ಇನಾ ಮಾ ಬಾಪ ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ\" ಮಿ ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆಯೊಸ ಕೈನ ಎ ಕಿಮ್ಮ ಕವಾಡ್ಯೊಸ? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ತೆ ವಾತೆ ಯೆಸು\"ತುಮೆ ಗುಣ ಗುಟ್ಟಾನು ಹುಬ್ರಾಡೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ಕುನ್ನಜ ಕಿಜಾ಼ ಲಕ್ಕಾ ನೈ ಆತಾ ಕದ್ಯಾಮ ಮನೆ ಮೊಕ್ಲಲ ಬಾ ತ್ಯುನೊನೆ ನೈ ಮೊಕಲ್ತೊ. ಬಾ ಮನೆ ಮೊಕ್ಲೊಸ ವರಿ ಬಾ ಮಕನ ಮನಕ್ಹೊ ಬಲೈ ಲಾವಸ. ಲಾಸ್ಟನಾ ದಿನೊಮಾ ತೆ ಮನಕ್ಹೊನೆ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡುಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","\"ಪ್ರವಾದಿಯೊನಾ ಪುಸ್ತಕೊಮಾ ಅಮ್ಮ ಬರ್ದ್ಯಾಸ ವರಿ ತ್ಯುನೆ ಕ್ಹಾರಾ ಕ್ಹುದಾಕ್ಹು ಶಿಕ್ಕಲವಾಲಾ ರ‍್ಹವಸ. ಕುನ್ನ ಬಾ ಕ್ಹು ಐಕಿನ ಶಿಕ್ಕಿನ ತೆ ಮಕನ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ಬಾ ಕ್ಹು ಆಯಲವಾಲೊ ಯಕ್ಕಜ಼ ಬಾನೆ ದೆಕಲವಾಲೊ ವ್ಹೈ. ಬಿಜೊ ಕಯೊಜ ಬಾನೆ ಕೆಳಾಮಾಜ ದೆಕ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ನಂಬಲವಾಲೊ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ಮಿಜ಼ ಜ಼ಲಮ ದಿವಾನೊ ರೊಕ್ಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ತುಮಾರಾ ಪಿತ್ರೊ ತ್ಯುನೊನೆ ಕ್ಹುದಾ ಉಸುಕನಿ ಜಿಮಿನ್ಮಾ ದಿದಲ ಮನ್ನಾ ಖಾದ್ಯಾತಾ ರ‍್ಹೈತುಬಿ ತ್ಯುನೆ ಮರಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ತೆನೈಸೊ ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆವಾನೊ ರೊಕ್ಲೊ ಕುನ್ನ ಖಾವಸ ತೆ ನೈ ಮರ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ಸ್ವರ್ಗತೊ ಉತ್ರಿನ ಆಯಲ ಜ಼ಲಮ ರ‍್ಹಯಲ ರೊಕ್ಲೊ ಮಿಜ಼ ವ್ಹೈ. ಎ ರೊಕ್ಲೊ ಖಾವಾಲೊ ಹಮೆಶಾಬಿ ಜಿವ್ತೊ ರ‍್ಹವಸ. ಎ ರೊಕ್ಲೊಜ ಮಾರು ಅಂಗ ವ್ಹೈ. ಎ ದುನಿಯಾನೆ ದ್ಯುಸ ಕಾಕದ್ಯಾಮ‍ ತ್ಯುನೆ ಜಿವ್ತಾ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ತೆಳಾಮಾ ಯಹುದ್ಯೊ\"ಎ ಮನಕ್ಹ ತಿನಾ ಅಂಗನೆ ಅಪೊನೆ ಖಾವಾನೆ ಕಿಮ್ಮ ದಿವಾನೆ ಥಾವಸ? ಕೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾ ಶಿಟ್ಟಕ್ಹು ವಾದ-ವಿವಾದ ಕರ್ತಾ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ಯೆಸು\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ತುಮೆ ಮನಕ್ಹನಾ ದಿಕ್ರಾನು ಅಂಗ ಖಾದ್ಯಾವಾಚಿ ತಿನು ರಗತ ಪಿದ್ಯಾವಾಚಿ. ತುಮೊಮಾ ಜ಼ಲಮ ರ‍್ಹತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ಕುನ್ನ ಮಾರು ಅಂಗ ಖಾವಸ ವರಿ ಕುನ್ನ ಮಾರು ರಗತ ಪಿವಸ ತೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಿಲಿವಸ. ವರಿ ಮಿ ತಿನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹಂದಿಲಿದ್ಯೊಸ. ಲಾಸ್ಟನಾ ದಿನ್ನೆ ಮಿ ತೆ ಮನಕ್ಹನೆ ಜಿವ್ತೊ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ಮಾರು ಅಂಗ ಕ್ಹರಿನು ಅನ್ನ ಥಯೊಸ. ಮಾರು ರಗತ ಕ್ಹರಿನು ಪಾನಿ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ಕುನ್ನ ಮಾರು ಅಂಗ ಖಾವಸ ವರಿ ಕುನ್ನ ಮಾರು ರಗತ ಪಿವಸ ತೆ ಮಾರಾಮಾ ರ‍್ಹವಸ ಮಿ ತಿನಾಮಾ ರ‍್ಹೌಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","\"ಜಿವ್ತೊ ರ‍್ಹಯಲ ಬಾಜ ಮನೆ ವಳಾಯೊ. ವರಿ ತಿನಾಕ್ಹುಜ ಮಿ ಜಿವ್ತೊ ರ‍್ಹೌಸ, ತಿನಾಹುತಿ ಕುನ್ನ ಮನೆ ಖಾವಸ ತೆ ಮಾರಾಕ್ಹುಜ ಜಿವ್ತೊ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ಎ ಸ್ವರ್ಗೊ ಉತ್ರಿನ ಆಯಲ ರೊಕ್ಲೊ ವ್ಹೈ ತುಮಾರಾ ಪತೃ ಮನ್ನಾ ಖಾದ್ಯಾ ವರಿ ಮರಿಗಯಾ, ತೆನೈಸೊ ಕುನ್ನ ಎ ರಕ್ಲೊ ಖಾವಾಸ ತೆ ಹಮೆಶಾಬಿ ಜಿವ್ತೊ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ಯೆಸು ಕಪೆನೌರ್ಮಿಮಾ ಸಬಾಮಂದಿರಮಾ ಉಪದೆಶ ಕರ್ತಾಮಾ ಎ ಕ್ಹಾರಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ಎ ಐಕಲ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಘನ್ನಾ ಜ಼ನಾ\"ಎ ಉಪದೆಶ ಕಠಿಣ ಛೆ. ಇನೆ ಕುನ್ನ ವಪ್ಪಿಲಿವಸ? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ತಿನಾ ಶಿಷ್ಯಾ ಆಸ ಕರಾನು ತಿಳ್ದಿಲಿದಲ ಯೆಸು\"ಎ ಉಪದೆಶಕ್ಹು ತುಮೊನೆ ತ್ರಾಸ ಥಾವಾಡುಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ಯಕ್ಕೆಳೆ ತುಮೆ ಮನಕ್ಹನಾ ದಿಕ್ರೊ ಪೈಲಾ ಕಿಜಾ಼ ವ್ಹತ್ತೊ ವರಿ ಫರಿನ ತ್ಯಾಜ ಜಾ಼ವಾನು ದೆಕ್ಯಾಮ ತುಮೆ ಸು ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ಜ಼ಲಮ ದಿವಾನು ಕ್ಹುದಾನಿ ಆತ್ಮಾ ವ್ಹೈ. ಮನಕ್ಹನಿ ಸಾಮರ್ಥನು ಸುಜ಼ ನತ್ತಿ. ಮಿ ತುಮೊನೆ ಕಯ್ಯೊ ವಾತೊ ಕದ್ಯೊತೊ ತೆ ಕ್ಹುದಾನಿ ಆತ್ಮಾ ವ್ಹೈ ವರಿ ತೆ ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ವರಿಬಿ ತುಮಾರಾವೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ತಾ\" ಕೈನ ಕದ್ಯೊ. ತಿನೆ ಬರೊಕ್ಹೊ ನೈ ಕರಲವಾಲಾ ಕುನ್ನ-ಕುನ್ನ ವ್ಹೈ ಕೈನ ತಿನೆ ಮೊಸ ಕರಾಲು ಕುನ್ನ ವ್ಹೈ ಕವಾನು ಯೆಸುನೆ ಪೈಲಾತುಜ಼ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ಯೆಸು ಬೊಲ್ತೊಜ ಮಿ ಇನಾಹುತಿ ತುಮೊನೆ ಇನಾಲಿಂಗತ ಕದಲ \"ಬಾನಿ ಇಜಾಜತ ನೈಸೊ ಕುನ್ನಜ ಮಕನ ನೈ ಆಸಕ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ಎ ವಾತನಾ ಹುತಿ ಯೆಸುನಾ ಪಾಚಾ಼ ಜಾ಼ವಾಲಾ ಘನ್ನಾ ಜ಼ನಾ ತಿನೆ ಛೊಡಿನ ಗಯಾ ವರಿ ಕೆಳಾಮಾಜ ತಿನಾ ಪಾಚಾ಼ ಆಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ಯೆಸು ತಿನಾ ಬಾರಾ ಶಿಷ್ಯಾವೊನೆ\"ತುಮೆಬಿ ಮನೆ ಛೊಡಿನ ಜೌ ಕೈನ ಕರ‍್ಯಾಸ ಸು? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ಸಿಮೊನ ಪೆತ್ರಾ ಯೆಸುನೆ\"ಪ್ರಭು, ಹಮೆ ಕಿಕನ ಗಯ್ಯೆ? ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವಾನಾ ವಾತೊ ತಾರಾಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ಹಮೆ ತುಪರ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ. ತು ಕ್ಹುದಾಕಂತೊ ಆಯಲ ಪರಿಶುದ್ಧ ವ್ಹೈ ಕೈನ ಹಮೊನೆ ಗ್ವತ ಛೆ \"ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ಪಾಚಲ್ತೊ ಯೆಸು ಕದ್ಯೊ ಸು ಮಿ ತುಮೊನೆ ಬಾರಾ ಜ಼ನಾವೊನೆ ಇನಿಲಿದ್ಯೊ ನತ್ತಿ ಸು? ವರಿಬಿ ತುಮೊಮಾ ಯಕ್ಲೊ ಸೈತಾನ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ಯೆಸು ಸಿಮೊನ ಇಸ್ಕರಿಯುತನಾ ದಿಕ್ರೊ ಯುದನಾ ಹುತಿ ಬೊಲಾಡ್ಯೊತೊ. ಯುದಾ ಬಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊಮಾ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ತೆನೈಸೊ ಅಗೊ ಯೆಸುನೆ ಮೊಸ ಕರಾಲೊ ಎಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ಎ ಥಯಲ್ಪರ, ಯೆಸು ಗಲಿಲಾಯ ಪುರಾ ಗಾಮಮಾ ಫರ‍್ಯೊ. ಕಾಕದ್ಯಾಮ ಯುದೆಯಮಾ ಜಾ಼ವಾನೆ ಯೆಸುನೆ ಮನಸ ನ್ಹೊತು. ತ್ಯಾನಾ ಯಹುದ್ಯೊ ತಿನೆ ಖಲಾಸ ಕರಾನೆ ಕೈದಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ತೆಳಾಮಾ ಯಹುದ್ಯೊನಾ ಗುಡಾರಮಾ ಅನ್ನ ಕರಿನ ಖಾವಾನೊ ಸನ್ನನೊ ಟೈಮ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ತಿನಾಹುತಿ ಯೆಸುನಾ ಭಾಯೊ ತಿನೆ\"ತು ನ್ಹ್ಯಾಂತೊ ಯುದೆಯನೆ ಜಾ಼. ತೆಳಾಮಾ ತ್ಯಾ ರ‍್ಹವಾನಾ ತಾರಾ ಹಿಂಬಾಲಕೊ ತು ಕರಾನಾ ಅದ್ಭುತ ಕಾಮೊ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ಕಯೊಬಿ ಮನಕ್ಹ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ಪ್ರಸಿದ್ದಿನೆ ಆವಾನೆ ಕರಸ ತೆ ತಿನಾ ಕಾಮೊ ದಡೈನ ಕರ‍್ತೊ ನೈ. ಕಾಕದ್ಯಾಮ ತು ಅದ್ಭುತ ಕಾಮೊ ಕರ್ಸಿ ತಿನಾಹುತಿ ದುನಿಯಾಮಾ ತುನೆ ತುಜ಼಼ ದೆಕಾಡಿನ ದೆ. ");
INSERT INTO sle_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ಯೆಸುನಾ ಭಾಯೊ ಬಿ ತಿನೆ ಬರೊಕ್ಹೊ ಕರ‍್ತಾ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ಯೆಸು ತಿನಾ ಭಾಯೊನೆ\"ಮನೆ ಕರೆಟ್ಟ ಟೈಮ ಹಜು಼ನ ನತ್ತಿ ಆಯೊ. ತುಮೊನೆ ತುಬಿ ಜಾ಼ವಾನೆ ಕ್ಹಾರೊ ಟೈಮ ಕರೆಟ್ಟ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ಎ ದುನಿಯಾ ತುಮೊನೆ ದುಶ್ಮನಿ ನೈ ಕರ‍್ತು. ತೆನೈಸೊ ಎ ದುನಿಯಾ ಮನೆ ದೊಶ ಕರಸ. ಕಾಕದ್ಯಾಮ ಮಿ ಎ ದುನಿಯಾನಾ ಮನಕ್ಹೊನೆ, ತ್ಯುನೆ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊ ವ್ಹೈ ಕೈನ ಕೌಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ತಿನಾಹುತಿ ತುಮೆ ಸನ್ನ ಕರಾನೆ ಜಾವೊ ಮಿ ಎ ಸನ್ನ ಕರಾನೆ ನೈ ಜಾತೊ. ಮನೆ ಕರೆಟ್ಟ ಟೈಮ ಹಜು಼ನ ಆಯೊ ನತ್ತಿ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ಯೆಸು ಇಮ್ಮ ಕೈನ ಗಲಿಲಾಯಮಾ ರ‍್ಹಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ತಿನಾಹುತಿ ಯೆಸುನಾ ಭಾಯೊ ಸನ್ನನಾ ಹುತಿ ಗಯಾ. ತ್ಯುನೆ ಗಯಲ್ಪರ ತೆಬಿ ಮನಕ್ಹೊನೆ ದಿಕ್ಹ್ಯಾವಾಚಿ ದಡಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ಸನ್ನಮಾ ಯಹುದ್ಯೊನಾ ಅದಿಕಾರಿಯೊ\"ಯೆಸು ಕಿಜ್ಗಾ ಛೆ\" ಕೈನ ಪುಚ್ತಾ ತಿನೆ ಹುಡ್ಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ತ್ಯಾ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪ ವ್ಹತ್ತು. ತೆ ಮನಕ್ಹೊಮಾ ಘನ್ನಾ ಜ಼ನಾ ಯೆಸುನಾ ಹುತಿ ಯಕ್ಕನೆ ಯಕ್ಕ ಕುಚು-ಕುಚು ಬೊಲ್ಲಿವಾಡ್ಯಾತಾ\" ತೆ ಚೊ಼ಕೊ ವ್ಹೈ\" ಕೈನ ದಕ್ಹಾ ಜ಼ನಾ ಕದ್ಯಾ. ಬಿಜಾ಼ ದಕ್ಹಾ ಜ಼ನಾ\"ನ್ಹವೈ, ತೆ ಮನಕ್ಹೊನೆ ಮೊಸ ಕರಾಡ್ಯೊಸ\" ಕೈನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ತೆನೈಸೊ ಯೆಸುನಾ ಹುತಿ ಕೆಟ್ಟ ಬೊಲಾನೆ ತೆ ಮನಕ್ಹೊಮಾ ಕಿನೆಜ಼ ತೆಕ್ಲು ದಮ್ಮ ನ್ಹೊತು. ಕಾಕದ್ಯಾಮ ಮನಕ್ಹೊ ಯಹುದ್ಯನಾ ನಾಯಕೊನೆ ಭುಚಿ಼ಕಿನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ಕಮ್ಮಶಿ ಕಮ್ಮ ಸನ್ನನು ಅರ್ದು ಭಾಗ ಕ್ಹರಿ ಗೈತು. ತೆಳಾಮಾ ಯೆಸು ದೆವಾಲಯನೆ ಗೈನ ಉಪದೆಶ ಕರಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ಯಹುದ್ಯೊನಾ ಅದಿಕಾರಿಯೊ ಘಾಬ್ರಾ ಥಯಾ\" ಎ ಮನಕ್ಹ ಕೆಳಾಮಾಜ ಎ ಕಿಜಾಜ ಅಬ್ಯಾಸ ನತ್ತಿ ಕರ‍್ಯೊ. ಎ ಅಕ್ಲು ಕ್ಹಾರು ಕಿಮ್ಮ ಶಿಕ್ಯೊ? ಕೈನ ಪುಚ್ಚಿ ಲಿವಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಉಪದೆಶ ಕರಾನಾ ಸಂಗತಿಯೊ ಮಾರಿಯೊ ಸ್ವಂತ ನ್ಹವೈ. ತೆನೈತೊ ಮಾರು ಉಪದೆಶ ಮನೆ ವಳಾಯಲವಾಲಾತು ಕ್ಹುದಾ ಕಂತು ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ಕ್ಹುದಾ ಆಸ ಕರಾನು ಕರಾಲಾನೆ ಮಾರು ಉಪದೆಶ ಕ್ಹುದಾತಿ ಆಯುಸ ತೆನೈಸೊ ಮಾರು ಸ್ವಂತ ನ್ಹವೈ ಕೈನ ಗ್ವತ್ತ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ಕುನ್ನ ತಿನಾ ಸ್ವಂತ ಅದಿಕಾರಕ್ಹು ಬೊಲಸ ತಿನಾಕ್ಹು ತಿನೆ ಮಹಿಮಾ ಕರ್ಲಿವಸ. ತೆ ನಯಸೊ ಕುನ್ನ ತಿನೆ ಮೊಕ್ಲುಸ ತಿನಿ ಮಹಿಮಾ ಕರಾನೆ ಆಸ ಕರಸ. ತೆ ಕ್ಹರಿನೊ ವ್ಹೈ ವರಿ ತಿನಾಮಾ ಕಯುಜ಼ ತರಾನು ಸುಳ್ಳ ನತ್ತಿ. ತಿ ");
INSERT INTO sle_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ಮೊಶೆ ತುಮೊನೆ ಧರಮಶಾಸ್ತ್ರ ದಿದ್ಯೊ ನತ್ತಿ ಸು? ವರಿ ತುಮೆ ತಿಮಾನಿಯೊ ನಿಯೊಮೊ ಲಿಂಗತ ಚಾ಼ಲ್ತಾ ನೈ ಕರ‍್ತಾ ಕಾ ತುಮೆ ಮನೆ ಮಾರಾನೆ ಕೊಶಿಶ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ಮನಕ್ಹೊ ಕದ್ಯಾ\"ತುನೆ ಭುತಡು ಧರ‍್ಯುಸ. ತುನೆ ಕುನ್ನ ಮಾರಾನೆ ಕೊಶಿಶ ಕರಾಡ್ಯುಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಕರಲ ಯಕ್ಕ ಅಧ್ಭುತ ಕಾಮ ಕರ‍್ಯೊತೊ ತುಮೆ ಕ್ಹಾರಾ ಘಾಬ್ರಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ಮೊಶೆ ತುಮೊನೆ ಸುನ್ನತಿ ಹುತಿ ಆಗನ್ಯಾ ದಿದ್ಯೊತೊ. ತೆನೈಸೊ ಕ್ಹರಿನಿಜ ಸುನ್ನಿತಿ ಕವಾನಿ ಸಂಸ್ಕಾರ ತುಮೊನೆ ದಿದಲವಾಲೊ ಮೊಶೆ ನ್ಹವೈ. ತಿತ್ತಿಬಿ ಪೈಲಾಜ ರ‍್ಹಯಲ ತುಮಾರಾ ಪಿತೃಕ್ಹು ಎ ಸಂಸ್ಕಾರ ಆಯುಸ. ತಿನಾಹುತಿ ಕೆಳಾಮಾಬಿ ಯಕ್ಕೆಮ ತುಮೆ ಸಬ್ಬತ ದಿನ್ಮಾ ಬಚ್ಚಾವೊನೆ ಸುನ್ನತಿ ಕರಾವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ಇಮ್ಮ ರ‍್ಹಯುಮ ರಾಮ ಕರಾನಾ ದಿನ್ಮಾ ಕಿನೆಬಿ ರ‍್ಹೈನೆಕಾ ಸುನ್ನತಿ ಇನಾಹುತಿ ಕರಸ ಕದ್ಯಾಮ ಮೊಶೆನು ನಿಯಮ ತೊಡು ನೈ ಕದ್ಯಾಮ ಇಮ್ಮ ರ‍್ಹಯುಮ ಯಕ್ಕ ಮನಕ್ಹ ಮೊಶೆನಿ ಆಗನ್ಯಾನೆ ವಿಧೆಯ ಥಾವಾನಾ ಹುತಿ ಸಬ್ಬತ ದಿನ್ಮಾ ಸುನ್ನತಿ ಕರೈಲೆಸಕಸ ಕವಾನು ಎ ದೆಕಾಡಿನ ದಿವಸ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಸಬ್ಬತ ದಿನ್ಮಾ ಯಕ್ಲಾನು ತಿನು ಪುರಾ ಅಂಗ ಅರಾಮ ಕರಾನಾಹುತಿ ತುಮೆ ಕಾ ಶಿಟ್ಟ ಥಯಾಸ? ");
INSERT INTO sle_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ಭಾರೊ ದೆಕಾಡಾನಾ ಹುತಿ ಫೈಸಲೊ ಕರ‍್ಯಾವಾಚಿ ಕರೆಟ್ಟ ಫೈಸಲೊ ಕರೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ಪಾಚಲ್ತೊ, ಯೆರುಸಲೆಮಮಾ ರ‍್ಹಯಲ ದಕ್ಹಾ ಮನಕ್ಹೊ\"ಅದಿಕಾರಿಯೊ ಕಲಾಸ ಕರಾನೆ ಕೊಶಿಶ ಕರಾನು ಎಜ಼ ಮನಕ್ಹನೆ ವ್ಹೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ತೆನೈಸೊ ದೆಕೊ ಎ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊಜ಼ ಬೊಲ್ತೊ ರ‍್ಹವಸ. ವರಿ ತೆ ಮನಕ್ಹೊ ತಿನಾ ವಿರುದ್ದ ಸುಜ಼ ಬೊಲಾಡ್ಯಾ ನತ್ತಿ. ಯಕ್ಕ ಟೈಮ ಎಜ಼ ಕ್ಹರಿನೊ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕವಾನಾ ವಳಕ್ಯಾಸು? ");
INSERT INTO sle_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ವರಿಬಿ ಎ ಮನಕ್ಹ ಕಿಜಾತೊ ಆಯೊಸ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ, ಕ್ರಿಸ್ತ ಆತಾಮಾ, ತೆ ಕಿಜಾತೊ ಆಯೊಸ ಕೈನ ಕಿನೆಜ಼ ಗ್ವತ್ತ ನತ್ತಿ. ಕೈನ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ಯೆಸು ದೆವಾಲಯಮಾ ಹಜು಼ನ ಉಪದೆಶ ಕರ‍್ತಾಮಾ ತೆಳಾಮಾ ತೆ ಜೊ಼ರ ವದ್ರಿನ \"ಹೊ, ತುಮೊನೆ ಮಾರಾ ಹುತಿ ಗ್ವತ್ತ ಛೆ. ಮಿ ಕಿಜಾತೊ ಆಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಮಿ ಆಯಲ ಮಾರಾ ಸ್ವಂತ ಅಧಿಕಾರಕ್ಹು ನ್ಹವ್ಹೈ. ಮನೆ ಮೊಕ್ಲ್ಯೊಸ ತೆ ಕ್ಹರಿನೊ ವ್ಹೈ. ತುಮೊನೆ ತಿನಾಹುತಿ ಗ್ವತ್ತ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ತೆನೈಸೊ ಮಿ ತಿನೆ ವಳಕ್ಯೊಸ. ವರಿಬಿ ಮಿ ತಿನಾಕ್ಹುಜ ಆಯೊಸ. ವರಿ ತೆಜ಼ ಮನೆ ಮೊಕ್ಲ್ಯೊಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ಎ ಐಕಿನ ಮನಕ್ಹೊ ತಿನೆ ಧರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯಾ. ತೆನೈಸೊ ಯೆಸುಪರ ಕಿನೆಜ಼ ಹತ ಘಾಲಾನೆ ಸಾದ್ಯ ಥಯು ನೈ. ಕಾಕದ್ಯಾಮ ಯೆಸುನೆ ಹಜು಼ನ ಕರೆಟ್ಟ ಟೈಮ ಆಯೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ತೆನೈಸೊ ಗುಂಪಮಾನಾ ಘನ್ನಾ ಮನಕ್ಹೊನು ಯೆಸುಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ವರಿ ಕದ್ಯಾ ತ್ಯುನೆ\"ಕ್ರಿಸ್ತ ಆವಾಡ್ಯೊಸ ಕೈನ ಹಮೆ ದೆಕಾಡ್ಯಾಸ. ಕ್ರಿಸ್ತ ಆತಾಮಾ ಎ ಮನಕ್ಹ (ಯೆಸು) ಕರ‍ಲತಿಬಿ ಹೆಚ್ಕಿ ಸುಚಕ ಕಾಮೊ ಕರಾಲೊ ವ್ಹೈ ಸು? ನ್ಹವೈ! ತಿನಾಹುತಿ ಎಜ಼ ಕ್ರಿಸ್ತ ವಸೆ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ಯೆಸುನಾ ಹುತಿ ಮನಕ್ಹೊನು ಗುಂಪ ಕುಚು಼-ಕುಚು಼ ಬೊಲನು ಪರಿಸಾಯರೊ ಐಕ್ಯಾ. ತಿನಾಹುತಿ ಖಾಸ ಯಾಜಕೊ ವರಿ ಫರಿಸಾಯರೊ ಯೆಸುನೆ ಧರಾನಾ ಹುತಿ ದಕ್ಹಾ ಕೈದಾಲಾವೊನೆ ಜ಼ನಾವೊನೆ ಮೊಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ತೆಳಾಮಾ ಯೆಸು\"ಹಜು಼ನ ದಕ್ಹಾ ಟೈಮ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌಸ. ಪಾಚಲ್ತೊ ಮನೆ ಮೊಕ್ಲಲವಾಲಾಕನ ಜೌ಼ಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ತುಮೆ ಮನೆ ಹುಡಕೊಸಿ, ವರಿಬಿ ಮನೆ ವಳಕ್ತಾಜ ನೈ. ವರಿ ಮಿ ರ‍್ಹಯಲ ಜ಼ಗಾ ತುಮೆ ಆತಾ ನೈ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ಯಹುದ್ಯೊನಾ ಅದಿಕಾರಿಯೊ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼\"ಇನೆ ಅಪೆ ವಳಕೆ ನೈಸೊ ಎ ಕಿಜಾ಼ ಜಾ಼ವಸ? ಅಪ್ನಾ ರ‍್ಹಯಲ ಗ್ರಿಕ ಮನಕ್ಹೊನಾ ಗಾಮ್ಮಾ ಗೈನ ಗ್ರಿಕ ವಾಲಾವೊನೆ ಉಪದೆಶ ಕರಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ಎ \"ತುಮೆ ಮನೆ ಹುಡ್ಕೊಶಿ ತೆನೈಸೊ ತುಮೆ ಮನೆ ಹುಡಕ್ತಾ ನೈ ಕವಸ ತೆನೈಸೊ ಎ ಮಿ ಕಿಜಾ಼ ಚಾಲ್ಯೊಸ ತುಮೆ ನೈ ಆತಾ ಕೈನ ಕವಸ. ಇನು ಮತ್ಲಬ ಸು ವ್ಹೈ? ಕೈನ ಯಕ್ಕನೆ ಯಕ್ಕ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ಸನ್ನನು ಲಾಸ್ಟ ದಿನ್ನ ಐಯುತು. ತೆ ಕ್ಹಾರಾತಿ ಕಾಸ ದಿನ್ನ ಐಯು ತೆ ದಿನ್ನೆ ಯೆಸು ಹುಬ್ರೈನ, ಜೊ಼ರ ವದ್ರಿನ \"ಕಿನೆಬಿ ತರಕ್ಹ ಲಾಗಲ ರ‍್ಹಯಮ ತೆ ಮಕನ ಐನ ಪಿವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ಮಾರಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲವಾಲಾನಾ ಪೆಟಮಾತು ಜ಼ಲಮನು ಪಾನಿನಿ ಝರಿಯೊ ವೈನ ಜಾ಼ವಸ. ಪವಿತ್ರ ಗ್ರಂಥ ತಿಳ್ಸಾವಾನು ಎಜ಼ ವ್ಹೈ \"ಕೈನ ಜೊ಼ರ ವದ್ರಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ಯೆಸು ಪವಿತ್ರಾ ಆತ್ಮಾನಾ ಹುತಿ ಎ ಕುನ್ನ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲವಾಲಾನೆ ತೆ ತ್ಯುನೆ ಪಡ್ದಿಲಿವಾನು ವ್ಹತ್ತು. ತೆಳಕ್ಕಾ ಪವಿತ್ರ ಆತ್ಮಾ ದಿದಲ ನ್ಹೊತಿ ಕಾಕದ್ಯಾಮ ಹಜುಬಿ ಯೆಸು ಮಹಿಮಾತು ಜಿವ್ತೊ ಥೈನ ಉಟ್ಯೊ ನ್ಹೊತೊ. ಕದ್ಯೊತೊ ತಿನೆ ಬರೊಕ್ಹೊ ಕರಲವಾಲಾ ವ್ಹಂದಿಲಿವಾನು ಪವಿತ್ರ ಆತ್ಮಾನಾ ಹುತಿ ಕದ್ಯೊ. ತೆ ಹಜು಼ನ ತಿನಿ ಮಹಿಮಾ ನೈ ವ್ಹಂದಿಲಿದಲಕ್ಹು ಪವಿತ್ರ ಆತ್ಮಾ ಹಜು಼ನ ದಿದ್ಯೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ಎ ಸಂಗತಿಯೊ ಐಕಲ ಮನಕ್ಹೊನಾ ಗುಂಪಮಾನಾ ದಕ್ಹಾ ಜ಼ನಾ\"ಎ ಮನಕ್ಹ ಕ್ಹರಿಬಿ ಪ್ರವಾದಿ ವ್ಹೈ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ದಕ್ಹಾ ಜ಼ನಾ\"ತೆ ಮಸ್ಸಿಹಾ ವ್ಹೈ\" ಕವಸ. ಬಿಜಾ಼ ದಕ್ಹಾ ಜ಼ನಾ\"ಮಸ್ಸಿಹಾ ಗಲಿಲಾಯತೊ ನೈ ಆತೊ! ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ಕ್ರಿಸ್ತ ದಾವಿದನಾ ಕುಟುಂಬತೊ ದಾವಿದ ರ‍್ಹಯಲ ಬೆತ್ಲೆಹೆಮ ಗಾಮತೊ ಆವಸ ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ್ತೊ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ಇಮ್ಮ ಯೆಸುನಾ ಹುತಿ ಮನಕ್ಹೊನಾ ಗುಂಪಮಾ ಭಾಗೊ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ದಕ್ಹಾ ಜ಼ನಾ ಯೆಸುನೆ ಧರು ಕೈನ ವ್ಹತ್ತಾ. ತೆನೈಸೊ ಕುನ್ನಜ ತಿಪರ ಹತ್ತ ಉಚೈಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ದೆವಾಲಯನೆ ಕೈದಾಲಾವೊನಾ ಪಾಚಾ಼ ಫರಿನ ಗಯಲ ಪರ, ಖಾಸ ಯಾಜಕೊ ವರಿ ಪರಿಸಾಯರೊ ತ್ಯುನೊನೆ\"ತುಮೆ ತಿನೆ ಕಾ ಧರಿನ ಲಾಯಾ ನೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ದೆವಾಲಯನೆ ಕೈದಾಲಾ\"ಹಜು಼ನ ಲಕ್ಕಾಬಿ ತೆ ಬೊಲಲ ಲಿಂಗತ ಕುನ್ನಜ ಬೊಲ್ಯು ನತ್ತಿ ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ಪರಿಸಾಯರೊ\"ಇಮ್ಮ ರ‍್ಹಯುಮ, ಯೆಸು ತುಮೊನೆಬಿ ಮರಳ ಕರ‍್ಯೊಸ! ");
INSERT INTO sle_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ಅದಿಕಾರಿಯೊಮಾ ನೈತೊ ಫರಿಸಾಯರೊಮಾ ಯಕ್ಲೊ ತಬಿ ತಿಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾಸು? ");
INSERT INTO sle_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ತೆನೈಸೊ ಎ ಮನಕ್ಹೊನೆ ಧರಮಶಾಸ್ತ್ರನಾ ಹುತಿ ಸುಜ಼ ಗ್ವತ್ತ ನತ್ತಿ. ತ್ಯುನೆ ಕ್ಹುದಾನಾ ಶ್ರಾಪನೆ ಮ್ಹೈಥಯಾಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ತೆನೈಸೊ ತ್ಯುನೊಮಾ ನಿಕೊದೆಮ ವ್ಹತ್ತೊ. ಪೈಲಾ ಯೆಸುನೆ ದೆಕಾನೆ ಗಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ನಿಕೊದೆಮ\"ಯಕ್ಕ ಮನಕ್ಹನಿ ವಾತ ಐಕ್ಯಾವಾಚಿ ಫೈಸಲೊ ಕರಾನಾ ಅಪ್ನು ಧರಮಶಾಸ್ತ್ರ ಇಜಾಜತ ನೈ ದೆತು. ತೆ ಕರಲ ಹಮೆ ತಿಳದಿಲಿಯೆ ಲಕ್ಕಾ ತಿನೆ ಫೈಸಲೊ ಕರಾನೆ ನೈ ಥಾತು\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ತ್ಯುನೆ ತಿನೆ\"ತು ಗಲಿಲಾಯನೊ ವ್ಹೈ ಸು? ಪವಿತ್ರ ಗ್ರಂಥ ಅಬ್ಯಾಸ ಕರ. ಗಲಿಲಾಯತೊ ಕಯೊ ಪ್ರವಾದಿ ನೈ ಆತೊ ಕೈನ ತೆಳಾಮಾ ತುನೆ ಗ್ವತ್ತ ಥಾವಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಕ್ಹಾರಾ ತ್ಯುನಾ-ತ್ಯುನಾ ಘರೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ಯೆಸು ಒಲಿವ ಝಾಡೊನೊ ಡೊಂಗರಪರ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ವರಿ ತ್ಯಾಂತೊ ಹೆಟೊ ಉತ್ರಿನ ತೆ ದೆವಾಲಯ ಫರಿನ ಗಯೊ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯೆಸುಕನ ಮಳಿನ ಸುತ್ತೆ ಹುಬ್ರಯಾ. ತೆ ಬೈಟಿನ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ಧರ್ಮೊಪದೆಶ ಕರಾಲಾ ವರಿ ಪರಿಸಾಯರೊ ಯಕ್ಕ ಬಾಕ್ಡಿನೆ ತ್ಯಾ ಲಿನ ಆಯಾ. ತೆ ಬಾಕ್ಡಿ ವ್ಯಭಿಚಾರ ಕರ‍್ತಾಮಾ ಕ್ಹಾಪಡಿತಿ. ತ್ಯುನೆ ತೆ ಬಾಕ್ಡಿನೆ ಮನಕ್ಹೊನಾ ಗುಂಪನಾ ಕ್ಹಾಮಾ ಲೈನ ಹುಬ್ರಾಡ್ಯಾ, ");
INSERT INTO sle_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ತೆಳಾಮಾ ಯೆಸುನೆ ಮನಕ್ಹೊ\"ಗುರು, ಎ ಬಾಕ್ಡಿ ವ್ಯಭಿಚಾರ ಕರ‍್ತಾಮಾ ಕ್ಹಾಪಡಿಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ಹವಾ ಕಾಮೊ ಕರಾಲಿ ಹರಿ ಯಕ್ಕ ಬಾಕ್ಡಿನೆ ದಗ್ಡಾ ಮಾರಿನ ಖಲಾಸ ಕರು ಕೈನ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರಮಾ ಆಗನ್ಯಾ ದಿದ್ಯೊಸ. ಇನಾಹುತಿ ತು ಸು ಕಶಿ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ಯೆಸುನೆ ವಾತೊಮಾ ಕ್ಹಾಪಡೈನ ತಿಪರ ತಪ್ಪ ಘಾಲಾನೆ ಥಾವಸ ಕೈನ ತೆ ವಾತ ಪುಚ್ಯಾ. ತೆನೈಸೊ ಯೆಸು ಹೆಟೊ ಬೈಟಿನ ಹತನಾ ಬೊಟಕ್ಹು ಜಿಮಿನಪರ ಬರ್ದಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ತ್ಯುನೆ ತೆಜ಼ ಪ್ರಶ್ನೆ ವರಿ ಪುಚ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ಸಿದಾ ಬೈಟಿನ\"ತೊಮೊಮಾ ಪಾಪ ನೈ ಕರಲವಾಲೊ ತಿನೆ ಪೈಲಾ ದಗ್ಡೊ ಮಾರಾದೆ\" ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ವರಿ ತೆ ಡ್ವಗ್ಗಿನ ಜಿಮಿನಪರ ಬರ್ದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ಯೆಸುನಿಯೊ ಎ ವಾತೊ ಐಕಿನ ಪೈಲಾ ತ್ಯಾ ರ‍್ಹಯಲ ಶಾನಾತಿ ಧರಿನ ಹರಿ ಯಕ್ಲಾ ಮನಕ್ಹೊ ಗೈಪಡ್ಯಾ. ಲಾಸ್ಟೆ ತ್ಯಾ ಹುಬ್ರಯಲ ಯೆಸು ಯಕ್ಲೊಜ ವ್ಹೈ. ವರಿ ತೆ ಬಾಕ್ಡಿ ತಿನಾ ಕ್ಹಾಮಿ ಹುಬ್ರೈತಿ. ");
INSERT INTO sle_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ಯೆಸು ಸಿದಾ ಹುಬ್ರೈನ\"ಬೈ, ತ್ಯುನೆ ಕ್ಹಾರಾ ಕಿಜಾ಼ ಛೆ? ತುಪರ ತಪ್ಪ ಘಾಲಲವಾಲಾ ಯಕ್ಲಾಬಿ ನತ್ತಿ ಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ತೆ ಬಾಕ್ಡಿ\"ಸ್ವಾಮಿ, ತ್ಯುನೊಮಾನೊ ಯಕ್ಲೊಬಿ ನತ್ತಿ\" ಕದಿ. ಯೆಸು ತಿನೆ\"ಮಿ ತುಪರ ತಪ್ಪ ನೈ ಘಾಲ್ತೊ. ತು ಹಮ್ನಾ ಜಾ಼, ಹಬ್ದಾತಿ ತು ಪಾಪ ಕರು ನಕೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ಪಾಚಾ಼ತಾ, ಯೆಸು ವರಿ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ತೊ\"ಮಿಜ಼ ಎ ದುನಿಯಾನೆ ಉಜಾಲು ವ್ಹೈ. ಮಾರಾ ಪಾಚೊ಼ ಆವಾಲೊ ಯಕ್ಲೊಬಿ ಅಂದಾರಾಮಾ ಕೆಳಾಮಾಜ ಚಾಲ್ತೊನೈ. ತೆ ಜ಼ಲಮ ದಿವಾನು ಉಜಾಲು ವ್ಹಂದಿಲಿದಲವಾಲೊ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ಫರಿಸಾಯರೊ ಯೆಸುನೆ\"ತು ತಾರಾ ಹುತಿ ಸಾಕ್ಷಿ ದಿವಾಡೊಸ. ತೆನೈಸೊ ಎ ಸಾಕ್ಷಿ ಕ್ಹರಿ ನ್ಹವೈ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ಯೆಸು, ಹೊ\"ಮಿಜ಼ ಮಾರಾ ಹುತಿ ಕವಾನಿ ಎ ಸಾಕ್ಷಿ ಕ್ಹರಿ ಛೆ. ಕಾಕದ್ಯಾಮ ಮಿ ಕಿಜಾತೊ ಆಯೊಸ ಕವಾನು ಮಿ ಕಿಜಾ಼ ಜೌ಼ಸ ಕವಾನು ಮನೆಜ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಮಿ ಕಿಜಾತೊ ಆಯೊಸ ಮಿ ಕಿಜಾ಼ ಜೌ಼ಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ\" ");
INSERT INTO sle_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ತುಮೆ ಮನಕ್ಹೊ ಕರಲ ಲಿಂಗತ ಫೈಸಲೊ ಕರಾಡಾಸ. ತೆನೈಸೊ ಮಿ ಕಿನೆಜ಼ ಫೈಸಲೊ ಕರ್ತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ತೆನೈಸೊ ಯಕ್ಕೆಳೆ ಮಿ ಫೈಸಲೊ ಕರ‍್ಯೊಮ ತೆ ಕ್ಹರಿನೊ ರ‍್ಹವಸ. ಕಾಕದ್ಯಾಮ ಮಿ ಯಕ್ಲೊಜ ನತ್ತಿ ಮನೆ ವಳಾಯಲವಾಲೊ ಮಾರೊ ಬಾ ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ತುಮಾರಾ ಧರ್ಮ ಶಾಸ್ತ್ರಮಾ ಅಮ್ಮ ಬರ್ದಲ ಛೆ ಬೆ ಜ಼ನಾ ಕದಲ ಸಾಕ್ಷಿ ಕ್ಹರಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ಮಾರಾ ಹುತಿ ಸಾಕ್ಷಿ ಕವಾಲೊ ಮಿ ಯಕ್ಲೊ ವರಿ ಮನೆ ವಳಾಯಲವಾಲೊ ಮಾರೊ ಬಾ ವರಿ ಯಕ್ಕ ಸಾಕ್ಷಿ ಥಯೊಸ \"ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ತೆಳಾಮಾ ತ್ಯುನೆ\"ತಾರೊ ಬಾ ಕಿಜಾ಼ ಛೆ? ಕೈನ ಪುಚ಼್ಚಾ. ಯೆಸು ತ್ಯುನೊನೆ \"ತುಮೊನೆ ಮಿ ರ‍್ಹೈನೆಕಾ ಮಾರೊ ಬಾ ರ‍್ಹೈನೆಕಾ ಗ್ವತ್ತ ನತ್ತಿ. ಯಕ್ಕೆಳೆ ತುಮೆ ಮನೆ ತಿಳ್ದಿಲಿದಲ ರ‍್ಹವತ್ತೊ, ಮಾರಾ ಬಾನೆಬಿ ತಿಳ್ದಿಲಿದಲ ರ‍್ಹತಾತಾ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ಯೆಸು ದೆವಾಲಯಮಾ ಕಾಣಿಕೆನಿ ಪೆಟಕಿ ಕನ ಹುಬ್ರೈನ ಉಪದೆಶ ಕರ್ತಾಮಾ ಎ ವಾತೊ ಕದ್ಯೊ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ತಿನೆ ಧರ‍್ಯು ನೈ ಕಾಕದ್ಯಾಮ ತಿನೆ ಧರಾನೊ ಟೈಮ ಹಜು಼ನ ಆಯೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ವರಿ ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಚಾಲ್ಯೊಸ ತುಮೆ ಮನೆ ಹುಡ್ಕೊಶಿ. ತೆನೈಸೊ ತುಮೆ ತುಮಾರಾ ಪಾಪೊಮಾಜ ಮರೊಶಿ. ಮಿ ಜಾ಼ವಾನಿ ಜ಼ಗಾ ಪರ ತುಮೆ ನೈ ಆಸ್ತಾ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ಎ ಯಹುದಿಯೊನೆ ತೆ ತಿನೊಜ ಜ಼ಲಮ ಲಿವಸ ಸು? ತಿನಾಹುತಿ ತೆ ಮಿ ಕಿಜಾ಼ ಜೌ಼ಸ ತ್ಯಾ ತುಮೊನೆ ಆವಾನೆ ನೈ ಥಾತು ಕೈನ ಕವಾಡ್ಯೊಸ ಸು? ಕೈನ ತ್ಯುನಾ-ತ್ಯುನಾಮಾ ಬೊಲ್ಲಿವಾ ವರ್ಕ್ಹು ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ತೆನೈಸೊ ಯೆಸು\"ತುಮೆ ಹೆಟಲ್ಯಾ ವ್ಹೈ ಮಿ ಉಪ್ಪರಲ್ಯೊ ವ್ಹೈ. ತುಮೆ ಎ ದುನಿಯಾನಾ ವ್ಹೈ ತೆನೈಸೊ ಮಿ ಎ ದುನಿಯಾನೊ ನ್ಹವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ತಿನಾಹುತಿ ಮಿ ಕದಲ ವ್ಹೈ ತುಮೆ ತುಮಾರಾ ಪಾಪೊಮಾ ಕರೊಶಿ ಕೈನ ವರಿ ತುಮೆ ಮಿ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಮಿಜ಼ ತೆ ವ್ಹೈ ಕೈನ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ಯಾಮ ತುಮೆ ತುಮಾರಾ ಪಾಪೊಮಾಜ ಮರೊಶಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ತೆಳಾಮಾ ತ್ಯುನೆ\"ತು ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಕುನ್ನ ವ್ಹೈ ಕವಾನು ತುಮೊನೆ ಪೈಲಾತೊ ಕತೊ ಆಯೊತೊ, ತೆಜ಼ ಮಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ತುಮಾರಾ ಹುತಿ ಫೈಸಲಾನಾ ಹುತಿ ಕವಾನೆ ಘನ್ನು ಛೆ. ತೆನೈಸೊ ವಳಾಯಲವಾಲೊ ಕ್ಹರಿನೊ ವ್ಹೈ ವರಿ ಮಿ ತಿಕಂತೊ ಸು ಐಕ್ಯೊಸ ತೆಜ಼ ದುನಿಯಾನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ಯೆಸು ಕಿನಾಹುತಿ ಬೊಲಾಡೊಸ ಕವಾನು ಮನಕ್ಹೊ ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ಯೆಸು ತ್ಯುನೊನೆ ಬಾನಾ (ಕ್ಹುದಾ) ಹುತಿ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ತಿನಾಹುತಿ ತೆ ತ್ಯುನೊನೆ\"ಕೆಳಾಮಾ ತುಮೆ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಉಪ್ಪರ ಚಡಾವೊಶಿ, ತೆಳಾಮಾ ತೆಜ಼ ಮಿ ವ್ಹೈ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಥಾವಸ ವರಿ ಮಿ ಕರಾನು ಮಾರಾ ಸ್ವಂತ ಚಿತ್ತಕ್ಹು ನ್ಹವ್ಹೈ. ತೆನೈಸೊ ಮಾರೊ ಬಾ ಕದಲ ತಿಮ್ಮ ಮಿ ಶಿಕ್ಲಾವಾಡೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ಮನೆ ವಳಾಯಲವಾಲೊ ಮಾರಾ ಕ್ಹಾತೆ ಛೆ. ತೆ ಮನೆ ಯಕ್ಲಾನೆಜ ಛೊಡಿನ ದಿದ್ಯೊ ನೈ. ತಿನಾಹುತಿ ಮಿ ಕೆಳಾಮಾಬಿ ತಿನೆ ಪಸಂದ ರ‍್ಹಯಲಜ ಕರುಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ಯೆಸು ಎ ಸಂಗತಿಯೊ ಕತಾಮಾ, ಘನ್ನಾ ಮನಕ್ಹೊ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ತಿನಾಹುತಿ ಯೆಸು ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ಯಹುದಿಯೊನೆ\"ತುಮೆ ಮಾರಾ ಉಪದೆಶನೆ ವಿಧೆಯ ಥಯಲ ರ‍್ಹವತ್ತೊ, ತುಮೆ ಕ್ಹರಿಬಿ ಮಾರಾ ಪಾಚಾ಼ ಆವಾಲಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ತುಮೆ ಕ್ಹರಿನೆ ತಿಳ್ದಿಲಿವೊಸಿ. ವರಿ \"ತೆ ಕ್ಹರಿ ತುಮೊನೆ ಸ್ವತಂತ್ರ ಕರಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ತೆಳಾಮಾ ತ್ಯುನೆ, ಹಮೆ ಅಬ್ರಹಾಮನಾ ಸಂತತಿವಾಲಾ ವ್ಹೈ. ಹಮೆ ಕೆಳಾಮಾಜ ಕಿನಾ ಗುಲಾಮೊ ನ್ಹೊತಾ. ಇಮ್ಮ ರ‍್ಹಯುತಬಿ\"ಹಮೊನೆ ಸ್ವತಂತ್ರ ಥಾವಾಸ ಕೈನ ತು ಕವಾನು ಶಾನೆ? ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ಯೆಸು\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಪಾಪ ಕರಾಲೊ ಹರಿ ಯಕ್ಲೊಬಿ ಪಾಪನೆ ಗುಲಾಮ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ಗುಲಾಮ ಯಕ್ಕ ಘರಮಾ ಹಮೆಶಾ ರ‍್ಹತೊ ನೈ. ತೆನೈಸೊ ದಿಕ್ರೊ ಕುಟುಂಬಮಾ ಹಮೆಶಾ ರ‍್ಹಯಲವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ತಿನಾಹುತಿ ದಿಕ್ರೊ ತುಮೊನೆ ಸ್ವತಂತ್ರ ಕರ‍್ಯೊಮ, ತುಮೆ ಕ್ಹರಿಮಾಜ಼ ಸ್ವತಂತ್ರ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ತುಮೆ ಅಬ್ರಹಾಮನಾ ಸಂತತಿವಾಲಾ ವ್ಹೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ತುಮೆ ಮನೆ ಖಲಾಸ ಕರಿಯೆ ಕೈನ ಕೈಲಿದ್ಯಾಸ. ಕಾಕದ್ಯಾಮ ಮಿ ಕವಾನಾ ವಾತೊ ವಪ್ಪಿಲಿವಾತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ಮಾರೊ ಬಾ ದೆಕಾಡಲಜ ಮಿ ತುಮೊನೆ ಕೌಸ. ತುಮೆತೊ ತುಮಾರೊ ಬಾ ತುಮೊನೆ ಕದಲ ಕರೊಶಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ತ್ಯುನೆ\"ಅಬ್ರಹಾಮ ಹಮಾರೊ ಬಾ ವ್ಹೈ\" ಕೈನ ಕದ್ಯಾ. ಯೆಸು\"ತುಮೆ ಕ್ಹರಿಮಾಜ಼ ಅಬ್ರಹಾಮನಾ ಬಚಚಾ ರ‍್ಹಯಾಮ ಅಬ್ರಹಾಮ ಕರಲ ಕಾಮೊಜ ಕರ್ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ಮಿ ಕ್ಹುದಾಕ್ಹು ಐಕಲ ಕ್ಹರಿಜ ತುಮೊನೆ ಕವಾಲೊ ಮನಕ್ಹ ಮಿ ಥಯೊಸ. ತೆನೈಸೊ ತುಮೆ ಮನೆ ಖಲಾಸ ಕರಾನೆ ಕೊಶಿಶ ಕರಾಡಾಸ. ಅಬ್ರಹಾಮ ತೆವೊ ಸುಜ಼ ಕರ‍್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ತಿನಾಹುತಿ ತುಮಾರೊ ಸ್ವಂತ ಬಾ ಕರಲಜ ತುಮೆ ಕರಾಡಾಸ ಕೈನ ಕದ್ಯೊ. ತೆನೈಸೊ ತ್ಯುನೆ\"ಹಮೆ ವ್ಯಭಿಚಾರಕ್ಹು ಹುಟ್ಟಲ ನ್ಹವೈ. ಕ್ಹುದಾ ಯಕ್ಲೊಜ ಹಮೊನೆ ಬಾ ವ್ಹೈ. ವರಿ ಹಮೆ ತಿನಾ ಕ್ಹರಿನಾ ಬಚಚಾ ಥಯಾಸ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ಯೆಸು ತೆ ಯಹುದಿಯೊನೆ\"ಕ್ಹುದಾ ಕ್ಹರಿಮಾಜ಼ ತುಮಾರೊ ಬಾ ರ‍್ಹಯೊಮ, ತುಮೆ ಮನೆ ಮಯಾ ಕರ್ತಾತಾ. ಕಾಕದ್ಯಾಮ, ಮಿ ಕ್ಹುದಾ ಕಂತೊ ಆಯೊಸ ವರಿ ಮಿ ನ್ಹ್ಯಾ ಛೆ. ಮಿ ಆಯಲ ಮಾರು ಸ್ವಂತ ಅದಿಕಾರಕ್ಹು ನ್ಹವೈ. ಕ್ಹುದಾಜ ಮನೆ ಮೊಕ್ಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ಮಿ ಕವಾನಿಯೊ ಎ ಸಂಗತಿಯೊ ತುಮೆ ಕಾ ಕಳೈ ಲೆತಾ ನೈ? ಕಾಕದ್ಯಾಮ ಮಿ ಕದಲ ವಾತೊ ತುಮೊನೆ ತಡ್ದಿಲಿವಾನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ಸೈತಾನಜ ತುಮಾರೊ ಬಾ ವ್ಹೈ. ತುಮೆ ತಿನಾಜ ಸಂತಾನ ವ್ಹೈ. ವರಿ ತುಮಾರಾ ಬಾ ಲಿಂಗತ ಚಾಲಾನೆ ಮನಸ ಕರೊಶಿ. ತೆ ಪೈಲಾತೊಬಿ ಖಲಾಸ ಕರಾಲೊ ರ‍್ಹಯಲ ಹುತಿ ಕ್ಹರಿನೆ ವಿರೊಧಿ ವ್ಹೈ. ತಿಮಾ ಕ್ಹರಿ ಕವಾನು ನತ್ತಿಜ ತೆ ಸ್ವಭಾವ ಲಿಂಗತ ಸುಳ್ಳ ಬೊಲಸ. ತೆ ಸುಳ್ಳ ಕವಾಲು ವ್ಹೈ ತೆ ಸುಳ್ಳನೊ ಬಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ತೆನೈಸೊ ಮಿ ಕ್ಹರಿಜ ಕೌಸ ತಿನಾಹುತಿ ತುಮೆ ನಂಬ್ತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ಮಾರಾಮಾ ಪಾಪ ದೆಕಾಡಿನ ದಿವಾಲೊ ತುಮೊಮಾ ಕುನ್ನಬಿ ಛೆ ಸು? ತೆನೈಸೊ ಮಿ ಕ್ಹರಿ ಕದ್ಯೊಮ ತುಮೆ ಕಾ ನಂಬ್ತಾ ನೈ? ");
INSERT INTO sle_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ಕುನ್ನ ಕ್ಹುದಾನೊ ವ್ಹೈ ತೆ ಕ್ಹುದಾ ಕವಾನಿಯೊ ವಾತೊ ಐಕಸ. ಇನಾಹುತಿ ತುಮೆ ಮಾರಿ ವಾತೊ ನೈ ಐಕ್ತಾ. ಕಾಕದ್ಯಾಮ ತುಮೆ ಕ್ಹುದಾನಾ ನ್ಹವ್ಹೈ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ಯಹುದ್ಯೊ ತಿನೆ, ಸು ಹಮೆ ಕವಾನು ಕರೆಟ್ಟ ನ್ಹೊತು ಸು ತು ಸಮಾರ್ಯವಾಲೊ ವ್ಹೈ ಕೈನ ತಾರಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೆ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಾರಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ನತ್ತಿ. ಮಿ ಮಾರಾ ಬಾನೆ ಮರ್ಯಾದಿ ದ್ಯುಸ, ವರಿಬಿ ತುಮೆ ಮನೆ ಮರ್ಯಾದಿ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ಮನೆ ಮರ್ಯಾದಿ ಮಳು ಕೈನ ಮಿ ಕೊಶಿಶ ಕರಾಡ್ಯೊ ನತ್ತಿ. ಮನೆ ಮರ್ಯಾದಿ ಮಳು ಕೈನ ಕವಾಲೊ ಬಿಜೆಕ್ಲೊ ಛೆ. ತೆಜ಼ ನ್ಯಾಯಾದಿಪತಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ಮಿ ತುಮೊನೆ ಕ್ಹರಿ ರ‍್ಹಯಲಜ ಕೌಸ. ಮಾರಿ ವಾಕ್ಯಾನೆ ವಿಧೆಯ ಥಾವಾಲೊ ಕೆಳಾಮಾಜ ಮರತೊ ನೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ಯೆಹುದಿಯೊ ತಿನೆ\"ಕ್ಹರಿಮಾಬಿ ತಾರಾಮಾ ಕೆಟ್ಟ ಆತ್ಮಾ ಛೆ ಕೈನ ಹಮ್ನಾ ಹಮೊನೆ ಗ್ವತ್ತ ಥಯು! ಅಬ್ರಹಾಮಬಿ ಮರ‍್ಯೊ ವರಿ ಪ್ರವಾದಿಯೊಬಿ ಮರಿಗಯಾ ತೆನೈಸೊ ವರಿಬಿ \"ಮಾರಿ ಉಪದೆಶನೆ ವಿಧೆಯ ಥಾವಾಲೊ ಕೆಳಾಮಾಜ ಮರ್ತೊಜ ನೈ ಕೈನ ತು ಕವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ಹಮಾರೊ ಬಾ ಥಯಲ ಅಬ್ರಹಾಮತೊ ತು‍ ಮ್ಹೊಟೊ ವ್ಹೈ ಕೈನ ಕೈಲಿದ್ಯೊ ಸು? ಅಬ್ರಹಾಮಬಿ ಮರ‍್ಯೊ ವರಿ ಪ್ರವಾದಿಯೊಬಿ ಮರಿ ಗಯಾ ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ತಾರಾಕ್ಹು ತು ಕುನ್ನ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿಲಿದ್ಯೊಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಾರಾಕ್ಹು ಮಿಜ಼ ಮಹಿಮಾ ಕರ್ಲಿದ್ಯೊಮ, ತೆ ಮಹಿಮಾನೆ ಕಯುಜ಼ ಕಿಮ್ಮತ ನತ್ತಿ. ಮಾರೊ ಬಾಜ ಮನೆ ಮಹಿಮಾನೆ ಕರಾವಸ. ತುಮೆ ಕಿನೆ ತುಮಾರೊ ಬಾ ಕವೊಶಿ ತೆ ಕ್ಹುದಾಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ತೆನೈಸೊ ತುಮೆ ತಿನೆ ಕ್ಹರಿಮಾಜ಼ ವಳಕ್ಯಾ ನತ್ತಿ. ತೆನೈಸೊ ಮಿ ತಿನೆ ವಳಕ್ಯೊಸ. ಮಿ ತಿನೆ ವಳಕ್ಯೊ ನತ್ತಿ ಕದ್ಯಾಮ ತುಮಾರಾ ಲಿಂಗತ ಸುಳ್ಳ ಕವಾಲೊ ಥೌಸ. ಮಿ ತಿನೆ ವಳಕ್ಯೊಸ. ತೆನೈಸೊ ಮಿ ತಿನಿ ವಾಕ್ಯಾನೆ ವಿಧಯ ಥೌಸ. ");
INSERT INTO sle_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ಮಿ ಆವಾನೊ ದಿನ್ನ ತೆ ದೆಕಸ ಕೈನ ತುಮಾರೊ ಬಾ ಥಯಲ ಅಬ್ರಹಾಮ ಘನ್ನೊ ಖುಶಿ ಥಯೊ. ತೆ ದಿನೊ ದೆಕ್ಯೊ ವರಿ ತೆ ಘನ್ನೊ ಖುಶಿ ಥಯೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ತ್ಯುನೆ ಯೆಸುನೆ, ತು ಹಜು಼ನ ಐವತ್ತ ವರಕ್ಹನೊಬಿ ನತ್ತಿ ತು ಅಬ್ರಹಾಮನೆ ದೆಕಿ ಪಾಡ್ಯೊ ಸು? ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ಅಬ್ರಹಾಮ ಹುಟ್ಟಾತಿ ಪೈಲಾಜ ಮಿ ಛೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ಎ ಐಕಲ ಬರೊಬ್ಬರ ಮನಕ್ಹೊ ತಿನೆ ನಾಕಾನೆ ದಗ್ಡಾ ಲಿದ್ಯಾ. ತೆನೈಸೊ ಯೆಸು ದಡಿ ರ‍್ಹೈನ ದೆವಾಲಯಮಾತೊ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ಯೆಸು ಚಾಲ್ತೊ ಜಾ಼ತಾ ಟೈಮ್ಮಾ ಯಕ್ಕ ಹುಟ್ಟತೊಜ ಕುಡ್ಡೊ ರ‍್ಹಯಲ ವಾಲಾನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿನೆ\"ಗುರು ಆ ಮನಕ್ಹ ಕುಡ್ಡೊ ಥೈನ ಹುಟ್ಟಾನೆ ಕಿನು ಪಾಪ ಕಾರಣ ವ್ಹೈ? ತೆ ಕರಲ ಪಾಪ ವ್ಹೈ ಸು ತಿನಾ ಮಾ ಬಾಪ ಕರಲ ಪಾಪ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ಯೆಸು ತ್ಯುನೊನೆ\"ತಿನು ಪಾಪ ರ‍್ಹೈನೆಕಾ ತಿನಾ ಮಾ ಬಾಪ ಕರಲ ಪಾಪ ರ‍್ಹೈನೆಕಾ ಕಾರಣ ನವೈ. ಕ್ಹುದಾನು ಕಾಮ ತಿಮಾ ದಿಕ್ಹು ಕೈನ ಇಮ್ಮ ಥಯುಸ. ");
INSERT INTO sle_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ಮನೆ ವಳಾಯಲವಾಲಾನು ಕಾಮ ಅಪೆ ದಿನ್ನ ರ‍್ಹತಾಮಾಜ ಕರು. ರಾತ ಆವಸ. ತೆಳಾಮಾ ಕುನ್ನಜ ಕಾಮ ನೈ ಕರತು. ");
INSERT INTO sle_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ಮಿ ಆ ದುನಿಯಾಮಾ ರ‍್ಹತಾಮಾ, ಮಿಜ಼ ಆ ದುನಿಯಾನೆ ಉಜಾಲು ಥಯೊಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ಯೆಸು ಎ ವಾತ ಕದಲ್ಪರ ಜಿಮಿನ್ಪರ ಥುಕ್ಕಿನ ತಿಕ್ಹು ಚುಕೊಲ ಕರಲಿನ ತೆ ಮನಕ್ಹನಾ ಡೊಳಾವೊನೆ ಲಗಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ಯೆಸು ತೆ ಮನಕ್ಹನೆ\"ಗೈನ ಸಿಲೊವಾ ತಳಾಮಾ ಧ್ವಲೆ\" ಕೈನ ಕದ್ಯೊ. ಸಿಲೊವಾ ಕದ್ಯಾಮ \"ವಳಾಯಲವಾಲೊ\" ತಿನಾಲಿಂಗತ ತೆ ಗೈನ ಧ್ವಲಿದ್ಯೊ. ತೆಳಾಮಾ ತೆ ಆತಾಮಾ ಡೊಳಾ ದಿಕ್ಹ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ವರಿ ಎ ಮನಕ್ಹ ಪೈಲಾ ಭಿಕ ಮಾಂಗ್ತೊತೊ ದೆಕಲ ದಕ್ಹಾ ಜ಼ನಾ ವರಿ ತಿನಾ ಆಜು಼ ಬಾಜುವಾಲಾ\"ದೆಕಿನ! ಹಮೆಶಾಬಿ ಭಿಕ ಮಾಂಗ್ತೊ ಬೈಟಾಲೊ ಎಜ಼ ನ್ಹವೈ ಸು ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ದಕ್ಹಾ ಮನಕ್ಹೊ\"ಹೊ ತೆಜ಼ ವ್ಹೈ ಕೈನ ಕದ್ಯಾ. ಎ ದಕ್ಹಾ ಜ಼ನಾ\"ನ್ಹವೈ ಎ ತೆ ಮನಕ್ಹ ನ್ಹವೈ. ಎ ತಿನಾ ಲಿಂಗತಜ಼ ಛೆ ಕದ್ಯಾ. ತಿನಾಹುತಿ ತೆ ಮನಕ್ಹ \"ಮಿಜ಼ ತೆ ವ್ಹೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ಮನಕ್ಹೊ ತುನೆ\"ತುನೆ ದಿಕ್ಹಾನು ಕಿಜಾ಼ ಮಳ್ಯು? ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ತೆ ಮನಕ್ಹ ತ್ಯುನೊನೆ \"ಯೆಸು ಕವಾಲೊ ದಕ್ಹು ಚುಕೊಲ ಕರಿನ ಮಾರಾ ಡೊಳೆ ಲಗಾಡಿನ ಸಿಲೊವಾ ಇರಮಾ ಧ್ವಲೆ ಕೈನ ಕದ್ಯೊ. ತಿನಾಲಿಂಗತಜ಼ ಮಿ ಗೈನ ಧ್ವಲಿದ್ಯೊ. ಹಮ್ನಾ ಮನೆ ದಿಕ್ಹಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ಪರಿಸಾಯರೊ ತೆ ಮನಕ್ಹನೆ, ತೆ ಮನಕ್ಹ ಹಮ್ನಾ ಕಿಜ್ಗಾ ಛೆ? ಕೈನ ಪುಚ್ಯಾ. ತೆ ಮನಕ್ಹ \"ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ \"ಕೈನ ಕದ್ಯೊ. ಪಾಚಾ಼ತಾ ಮನಕ್ಹೊ ತೆ ಮನಕ್ಹನೆ ಪರಿಸಾಯರೊ ಕನ ಬಲೈ ಲಾಯಾ. ಪೈಲಾ ಕುಡ್ಡೊ ರ‍್ಹಯಲ ಎಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ಯೆಸು ಮಾತಿ ಲಿನ ಚುಕೊಲ ಕರಿನ ತಿನಾ ಡೊಳಾ ಅರಾಮ ಕರ‍್ಯೊ. ಯೆಸು ಎ ಕಾಮ ಕರಲ ಸಬ್ಬತ ದಿನ್ಮಾ ವ್ಹೈ. ತಿನಾಹುತಿ ತ್ಯುನೆ ತೆ ಮನಕ್ಹನೆ \"ಕಿಮ ದಿಕ್ಹಾಡ್ಯು\" ಕೈನ ಪುಚ್ಯಾ. ತೆ ಮನಕ್ಹ\"ತೆ ಮಾರಾ ಡೊಳಾನೆ ಚುಕೊಲ ಲಗಾಡ್ಯೊ. ಮಿ ಧ್ವಲಿದ್ಯೊ. ಹಮ್ನಾ ಮನೆ ಡೊಳಾ ದಿಕ್ಹಾಡ್ಯಾಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ಯೆಸು ಚುಕೊಲ ಕರಿನ ತಿನಾ ಡೊಳಾವೊನೆ ಅರಾಮ ಕರ‍್ಯೊ. ಯೆಸು ಎ ಕಾಮ ಕರಲ ಸಬ್ಬತ ದಿನ್ನಮಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ತಿನಾಹುತಿ ಫರಿಸಾಯರೊ ತೆ ಮನಕ್ಹನೆ ವರಿ ಯಕ್ಕೆಮ, ತುನೆ ಡೊಳಾ ಕಿಮ್ಮ ಆಯಾ? ಕೈನ ಪುಚ಼್ಚಾ. ತೆ ಮನಕ್ಹ\"ತೆ ಮಾರಾ ಡೊಳಾವೊನೆ ಚುಕೊಲ ಲಗಾಡ್ಯೊ. ಮಿ ಧ್ವಲಿದ್ಯೊ. ಹಮ್ನಾ ಮನೆ ಡೊಳಾ ದಿಕ್ಹಾಡಾಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ಫರಿಸಾಯರೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ\"ಎ ಮನಕ್ಹನೆ ಕ್ಹುದಾ ಕಂತೊ ಆಯಲವಾಲೊ ನ್ಹವ್ಯ. ಕಾಕದ್ಯಾಮ ಎ ಅರಾಮ ಕರಾನಾ ದಿನ್ನನೆ ಪಾಲನ ಕರ್ತೊ ನೈ \"ಬಿಜಾ಼ ಮನಕ್ಹೊ\"ಎ ಪಾಪಿ ರ‍್ಹಯೊಮ ಹವಾ ಅಧ್ಭುತ ಕಾಮೊ ಕಿಮ ಕರಸ? ಕದ್ಯಾ. ಇಮ್ಮ ತ್ಯುನೊ ತ್ಯುನೊಮಾ ವಾದ-ವಿವಾದ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ಫರಿಸಾಯರೊ ವರಿ ಯಕ್ಕೆಮ, ಅರಾಮ ಥಯಲವಾಲಾವೊನೆ\"ತೆ ಮನಕ್ಹ ತುನೆ ಡೊಳಾ ದಿಕ್ಹೆ ಲಿಂಗತ ಕರ್ಯೊ ತೆನೈಸೊ ತಿನಾಹುತಿ ತುನೆ ಸು ಕಶಿ? ಕೈನ ಪುಚ್ಯಾ. ತೆ ವಾತೆ \"ತೆ ಯಕ್ಕ ಪ್ರವಾದಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ಎ ಮನಕ್ಹ ಪೈಲಾ ಕುಡ್ಡೊ ವ್ಹತ್ತೊ. ಹಮ್ನಾ ತಿನಾ ಡೊಳಾ ದಿಕ್ಹಾಡಾಸ ಕೈನ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ತಿನಾ ಮಾ ಬಾಪನೆ ಬಲೈ ಲಾಯೆ ಲಕ್ಕಾ ನಂಬ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ತ್ಯುನೆ ತಿನಾ ಮಾ ಬಾಪನೆ\"ಆ ತುಮಾರೊ ದಿಕ್ರೊ ವ್ಹೈ ಸು? ಎ ಹುಟ್ತಾಮಾತೊಜ ಕುಡ್ಡೊ ವ್ಹೈ ಕೈನ ಕವೊಶಿ ತಿಮ್ಮ ರ‍್ಹಯುಮ ಹಮ್ನಾ ಇನೆ ಕಿಮ ದಿಕ್ಹಾಡ್ಯುಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ತಿನಾ ಮಾ ಬಾಪ\"ಆ ಹಮಾರೊ ದಿಕ್ರೊ ವ್ಹೈ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ವರಿ ಎ ಹುಟ್ತಾಮಾತೊಬಿ ಕುಡ್ಡೊ ಛೆ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ತೆನೈಸೊ ಕುನ್ನ ಮಾತಿ ಲಗಾಡಿನ ತಿನೆ ದಕ್ಹಾ ವರಕ್ಹು ಕರ‍್ಯು ಕವಾನು ಹಮೊನೆ ವರಿ ಇನೆ ಕಿಮ್ಮ ದಿಕ್ಹಾಡುಸ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತಿನೆಜ ಪುಚ್ಚೊ. ತೆ ತಿನಾ ಹುತಿ ಕವಾಯಕ್ಲೊ ಹಜು಼ನ ಜಾಂಜಿಮಾನ ಛೆ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ತಿನಾ ಮಾ ಬಾಪ ಗಿನೆ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊನೆ ಭುಚ್ಕಲ ಹುತಿ ಇಮ್ಮ ಕದ್ಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಪೈಲಾತಾಜ ವಿಚಾರ ಕರ್ಲಿದ್ಯಾತಾ ಕುನ್ನ ಯೆಸುನೆ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಕವಸ ತಿನೆ ಸಭಾಮಂದಿರಮಾತಾ ಭಾರಾ ಘಾಲಿಯೆಸ ಕೈನ ಯಹುದ್ಯೊನಾ ನಾಯಕೊ ಕದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ತಿನಾ ಹುತಿಜ ತಿನಾ ಮಾ ಬಾಪ\"ತೆ ಮ್ಹೊಟೊ ಥಯೊಸ ತಿನೆ ಪುಚ್ಚೊ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ಯಹುದಿಯೊನಾ ನಾಯಕೊ, ಕುಡ್ಡೊ ರ‍್ಹಯಲ ತೆ ಮನಕ್ಹನೆ ಬೆಂವಾ ಸಲಾ ಮ್ಹೈ ಬಲೈನ, ವರಿ \"ತು ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ ಕ್ಹರಿ ಬೊಲ. ತುನೆ ಡೊಳಾ ದಿದಲ ಮನಕ್ಹ ಪಾಪಿ ವ್ಹೈ ಕೈನ ಹಮೊನೆ ಗ್ವತ ಛೆ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ತೆ ಮನಕ್ಹ \"ತೆ ಪಾಪಿ ವ್ಹೈ ಸು ನ್ಹವೈ ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ಮಿ ಕುಡ್ಡೊ ವ್ಹತ್ತೊ; ಹಮ್ನಾ ಮಿ ದಿಕಾಡೊಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ಯಹುದಿಯೊನಾ ನಾಯಕೊ\" ತೆ ತುನೆ ಸು ಕರ‍್ಯೊ? ತೆ ತಾರಾ ಡೊಳಾವೊನೆ ಕಿಮ ಅರಾಮ ಕರ‍್ಯೊ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ತೆ ಮನಕ್ಹ ತ್ಯುನೊನೆ\"ತೆಳಾಮಾಜ಼ ತುಮೊನೆ ಕದ್ಯೊಸ್ತೊ. ತೆನೈಸೊ ತುಮೆ ಮನೆ ಕಾನ ದಿದ್ಯಾನೈ. ಹಮ್ನಾ ತೆ ವರಿ ಕಾ ಪುಚ್ಚಾಡ್ಯಾಸ? ತುಮೆಬಿ ತಿನಾ ಶಿಷ್ಯಾ ಥೌಸ ಕೈ ಕೈಲಿದ್ಯಾಸು? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ತ್ಯುನೆ ತೆ ಮನಕ್ಹನೆ ಕದ್ರೈನ\"ತು ತಿನಾ ಪಾಚಾ಼ ಜಾ಼ವಾಲೊ ಥಾವಾಡ್ಯೊಸ. ಹಮೆ ಮೊಶೆನಾ ಪಾಚಾ಼ ಜಾ಼ವಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ಕ್ಹುದಾ ಮೊಶೆನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊಸ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಎ ಮನಕ್ಹ ಕಿಜಾತೊ ಆಯೊಸ ಕವಾನುಬಿ ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ತೆ ಮನಕ್ಹ\"ಎ ಘನ್ನು ಘಾಬ್ರಾ ಥಾವಾನು ಸಂಗತಿ ವ್ಹೈ. ತೆ ಕಿಜಾತೊ ಆಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ತೆ ಮನೆ ಡೊಳಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ಕ್ಹುದಾ ಪಾಪಿಯೊನೆ ನೈ ಐಕ್ತೊ ಕೈನ ಅಪೊನೆ ಕ್ಹಾರಾವೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನೆ ಭಕ್ತಿಮಾ ರ‍್ಹವಾಲಾವೊನೆ ವರಿ ತಿನಿ ಆಸ ಲಿಂಗತ ಕರಲಾವಾಲಾವೊನಿ ಐಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ಪೈಲಾತಾ ಕುನ್ನಬಿ ಕುಡ್ಡೊ ರ‍್ಹಯಲವಾಲಾನೆ ಡೊಳಾ ದಿದಲ ಕೆಳಾಮಾಜ ಐಕ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ಎ ಮನಕ್ಹ ಕ್ಹುದಾ ಕಂತೊ ನೈ ಆಯಲ ರ‍್ಹವತ್ತೊ ಇಕನ ಸುಜ಼ ಕರಾನೆ ಥಾತು ನ್ಹೊತು\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ತ್ಯುನೆ ತಿನೆ\"ಪಾಪಮಾಜ ಹುಟ್ಟಿನ ಬೆಳದಲವಾಲೊ ತು ವ್ಹೈ! ಹಮೊನೆ ಶಿಕ್ಲಾವಾಡೊಸ ಸು? ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ವರಿ ತ್ಯುನೆ ತಿನೆ ಸಭಾಮಂದಿರಮಾತಾ ಭಾರಾ ಢಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ತ್ಯುನೆ ತೆ ಮನಕ್ಹನೆ ಭಾರಾ ಘಾಲ್ಯಲ ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯು. ಯೆಸು ತೆ ಮನಕ್ಹನೆ ಮಳಿನ\"ತು ಮನಕ್ಹನಾ ದಿಕ್ರಾಪರ ಬರೊಕ್ಹೊ ಕರಶಿ ಸು? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ತೆಳಾಮಾ ತೆ ಮನಕ್ಹ ತಿನೆ\"ಸ್ವಾಮಿ, ತೆ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಕುನ್ನ ವ್ಹೈ? ಮನೆ ಕೆ. ಕಾಕದ್ಯಾಮ ಮಿ ತಿಪರಜ ಬರೊಕ್ಹೊ ಕರೆ ಲಿಂಗತ ಥಾವಾದೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ಯೆಸು\"ತು ತಿನೆ ದೆಕ್ಯೊಸ. ವರಿ ಹಮ್ನಾ ತಾರಾ ಕ್ಹಾತೆ ಬೊಲಾಜೊಜ಼ ತೆಜ಼ ವ್ಹೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ತೆ ಮನಕ್ಹ\"ಹೊ ಪ್ರಭು, ಮಿ ಬರೊಕ್ಹೊ ಕರುಸ\" ಕೈನ ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ತೆ ತಿನಾ ಕ್ಹಾಮೊ ಅಡ್ಡ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ಯೆಸು\"ಎ ದುನಿಯಾನೆ ಫೈಸಲೊ ಕರಾನೆ ಆಯೊಸ. ವರಿ ಕುಡ್ಡಾ ದೆಕೆ ಲಿಂಗತ ಥೌ ಕೈನ ಡೊಳಾ ರ‍್ಹಯಲವಾಲಾ ಕುಡ್ಡಾ ಥೌ ಕೈನ ಮಿ ಆಯೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ಯೆಸುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ದಕ್ಹಾ ಫರಿಸಾಯರೊ ಎ ಐಕಿನ\"ಕ್ಹರಿಮಾಜ಼ ತು ಹಮೆಬಿ ಕುಡ್ಡಾ ವ್ಹೈ ಕೈನ ಕವಾಡ್ಯೊಸ ಸು? ಕೈನ ಸವಾಲ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ಯೆಸು ತ್ಯುನೊನೆ\"ತುಮೆ ಕ್ಹರಿಬಿ ಕುಡ್ಡಾ ರ‍್ಹಯಮ ಪಾಪ ಕವಾನಾ ಅಪರಾದನೆ ಗುರಿ ಥಾತಾ ನ್ಹೊತಾ. ತೆನೈಸೊ ತುಮೆ\"ಹಮೊನೆ ಡೊಳಾ ದಿಕ್ಹಸ ಕೈನ ಕವೊಶಿ. ತಿನಾಹುತಿ ತುಮೆ ಪಾಪಿಯೊಜ ಥಯಾಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ಯೆಸು\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಬಕ್ರಾನಿ ಹಕ್ಕಿಮಾ ಬಾಕಲಮಾತೊ ಆಯವಾಚಿ ಬಿಜಿ ಬಗಲ್ತೊ ಗೊಡಿ ಉಡಿನ ಆವಾಲೊ ಚ್ವಟ್ಟೊಜ ವರಿ ಕಾಳ್ಳಿನ ಜಾ಼ವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ಕುನ್ನ ಬಾಕಲಮಾತೊ ಆವಸ ತೆ ಮನಕ್ಹ ಕುರಬುರ‍್ಯೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ಕೈದಾಲೊ ಕುರಬುರ‍್ಯಾನೆ ಬಾಕಲ ಕಾಡಸ. ವರಿ ಬಕ್ರಾ ತಿನಾ ಅವಾಜ಼ ಐಕಸ. ತೆ ಬಕ್ರಾವೊನೆ ನಾಮ ಲಿನ ಬಲಾತಾಮಾ ಬಕ್ರಾ ತಿನಿ ಅವಾಜ಼ ಐಕಸ. ವರಿ ತೆ ತ್ಯುನಾ ಅಗು ಚಾಲ್ತೊ ಪಾಚೊ಼ ಬಲೈ ಲಿನ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ಕೆಳಾಮಾ ತೆ ತಿನಾ ಕ್ಹಾರಾ ಬಕ್ರಾವೊನೆ ಭಾರೊ ಬಲೈ ಲಿನ ಜಾ಼ವಸ ತೆಳಾಮಾ ತೆ ಅಗೊ-ಅಗೊ ಜಾ಼ವಸ ತಿನಾ ಬಕ್ರಾ ತಿನಾ ಪಾಚಾ಼-ಪಾಚಾ಼ ಜಾ಼ವಸ. ಕಾಕದ್ಯಾಮ ತೆ ಬಕ್ರಾ ತಿನಿ ಸ್ವರ ವಳಕಸ.. ");
INSERT INTO sle_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ತೆನೈಸೊ ಬಕ್ರಾ ತ್ಯುನೊನೆ ನೈ ಗ್ವತ್ತ ರ‍್ಹಯಲ ಮನಕ್ಹನಾ ಪಾಚಾ಼ ಕೆಳಾಮಾಜ ನೈ ಜಾ಼ತಾ. ತಿನಾಹುತಿ ತ್ಯುನೆ ತೆ ತಿಕಂತಾ ದುರ ಜಾ಼ವಸ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ನೈ ಗ್ವತ್ತ ರ‍್ಹಯಲ ಮನಕ್ಹನೊ ಅವಾಜ಼ ವಳಕ್ತಾ ನೈ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ಯೆಸು ಕದಲ ಎ ಸಾಮ್ಯ ತ್ಯುನೊನೆ ಕದ್ಯೊ. ತೆನೈಸೊ ಇನು ಮತ್ಲಬ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ತಿನಾಹುತಿ ಯೆಸು ವರಿ\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಮಿಜ಼ ಬಕ್ರಾವೊನೆ ಬಾಕಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ಮಿ ಆವಾತಿ ಪೈಲಾ ಆಯಲವಾಲಾ ಚವಟ್ಟಾ ವ್ಹತ್ತಾ ವರಿ ಉದಾಳ್ಳಿವಾಲಾ ವ್ಹತ್ತಾ. ಬಕ್ರಾ ತ್ಯುನು ಐಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ಮಿಜ಼ ಬಾಕಲ ವ್ಹೈ. ಕುನ್ನ ಮಾರಾ ಮುಲಕ ಮ್ಹೈ ಜಾ಼ವಸ ತೆ ಬಿಡುಗಡೆ ವ್ಹಂದಿಲಿವಸ. ತೆ ಮ್ಹೈ ಆ ಸಕಸ. ಭಾರೊಬಿ ಜಾ಼ ಸಕಸ ವರಿ ತಿನೆ ಚಾರೊ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ಚ್ವಟ್ಟೊ ಚೊ಼ರಿ ಕರಾನೆ ಖಲಾಸ ಕರಾನೆ ಹಾಳ ಕರಾನೆಜ ಆವಸ. ಮಿತೊ ಜ಼ಲಮ ದಿವಾನೆ ಆಯೊಸ ತೆ ಪರಿಪುರ್ಣ ಜ಼ಲಮ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","\"ಮಿಜ಼ ಚೊ಼ಕೊ ಕುರಬುರ‍್ಯೊ ವ್ಹೈ. ಚೊ಼ಕೊ ಕುರಬುರ‍್ಯೊ ಬಕ್ರಾವೊನೆ ಹುತಿ ತಿನು ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ಕುಲಿ ಆಳ ಕುರಬುರ‍್ಯೊ ನ್ಹವೈ ವರಿ ಬಕ್ರಾ ಕುಲಿ ಆಳನಾ ಸ್ವಂತನಾ ನ್ಹವೈ. ತಿನಾಹುತಿ ಕುಲಿ ಆಳ ತೊಳ ಆವಾನು ದೆಕಿನ ಬಕ್ರಾವೊನೆ ಛೊಡಿನ ನ್ಹಾಟಿ ಜಾ಼ವಸ. ತೆಳಾಮಾ ನರಿಯೊ ಬಕ್ರಾವೊಪರ ಹಮ್ಲೊ ಕರಿನ ತ್ಯುನೊನೆ ಜುದಾ ಕರಿ ಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ತೆ ಮನಕ್ಹ ನ್ಹಾಟಿ ಜಾ಼ವಸ. ಕಾಕದ್ಯಾಮ ತೆ ಖಾಲಿ ಕುಲಿ ಆಳ ವ್ಹೈ. ತೆ ಬಕ್ರಾವೊನೆ ಹುತಿ ಕ್ಹರಿಮಾಜ಼ ಚಿಂತಾ ನೈ ಕರ‍್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","\"ಮಿ ಚೊ಼ಕೊ ಕುರಬುರ‍್ಯೊ ವ್ಹೈ. ತಿಮ್ಮ ಮಿ ಮನೆ ಬಾ ತಿಳ್ದಿಲಿದ್ಯೊಸ ತಿಮ್ಮ ಬಾನೆ ಮಿ ತಿಳ್ದಿಲಿದ್ಯೊಸ. ತಿನಾ ಲಿಂಗತಜ ಮಿ ಮಾರಾ ಬಕ್ರಾವೊನೆ ವಳಕುಸ ವರಿ ತೆ ಮನೆ ವಳಕಸ. ವರಿ ಮಿ ಮಾರಾ ಬಕ್ರಾವೊನಾ ಹುತಿ ಜ಼ಲಮ ದಿವಾನೆ ತಯ್ಯಾರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ಮನೆ ಬಿಜಾ಼ ಬಕ್ರಾಬಿ ಛೆ. ತೆ ನ್ಹ್ಯಾ ರ‍್ಹವಾನಾ ಆ ಹಕ್ಕಿಮಾ ನತ್ತಿ. ಮಿ ತೆ ಬಕ್ರಾವೊನೆಬಿ ಮ್ಹೈ ಲೌಜ. ");
INSERT INTO sle_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ತೆ ಬಕ್ರಾ ಮಾರಿ ಸ್ವರ ಐಕಸ. ತೆಳಾಮಾ ಯಕ್ಕಜ಼ ಗುಂಪ ರ‍್ಹವಸ ವರಿ ಯಕ್ಲೊಜ ಕುರಬುರ‍್ಯೊ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ಬಾ ಮನೆ ಮಯಾ ಕರಸ. ಕಾಕದ್ಯಾಮ ಮಿ ಮಾರೊ ಜ಼ಲಮ ವರಿ ವ್ಹಂದಿಲಿವಾನಾ ಹುತಿ ದಿವ್ಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ಮಾರೊ ಜ಼ಲಮ ಮಕಂತೊ ಕುನ್ನಜ ನೈ ಉದಾಳೆ ಲೆಸಕ್ತು; ಮಿಜ಼ ತಿನೆ ಮಾರಿ ಇಷ್ಟಾಕ್ಹು ದಿವ್ಸ. ಮಾರೊ ಜ಼ಲಮ ದಿವಾನೆಬಿ ವರಿ ತಿನೆ ವಾಪಸ ಲಿವಾನೆಬಿ ಮನೆ ಹಕ್ಕ ಛೆ. ಇಮ್ಮ ಕರು ಕೈನ ಬಾಜ ಮನೆ ಆಗನ್ಯಾ ದಿದ್ಯೊಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ವರಿ ಎ ಸಂಗತಿಯೊ ಐಕಿನ ಯೆಹುದಿಯೊಮಾ ವರಿ ಭೆದ ಹುಟ್ಯು. ");
INSERT INTO sle_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ತ್ಯುನೊಮಾ ಘನ್ನಾ ಜ಼ನಾ\"ತಿನಾಮಾ ಭುತಡು ಛೆ. ಎ ಪಿಸಾಳೊ ಛೆ. ತಿನು ಕಾ ಐಕಾಡಾಸ? ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ತೆನೈಸೊ ಬಿಜಾ಼ ಮನಕ್ಹೊ\"ಎ ವಾತೊ ಭುತಡು ಧರಲ ಮನಕ್ಹನಿಯೊ ವಾತೊ ನ್ಹವ್ಯೆ. ಕುಡ್ಡಾವೊನಾ ಡೊಳಾ ದಿವಾನೆ ಭುತಡಾಕ್ಹು ಥಾವಸ ಸು? ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ಯೆರುಸಲೆಮಮಾ ದೆವಾಯಲನೆ ಕರಾನಿ ಪ್ರತಿಷ್ಟೆನು ಸನ್ನ ಚಾಲಾಡ್ಯುತು. ತೆಳಾಮಾ ಥಂಡನಾ ದಿನ್ನೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ಯೆಸು ದೆವಾಲಯಮಾ ಸೊಲೊಮೊನನಾ ಮಂಟಪ ಕನ ಫರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ತೆಳಾಮಾ ಯೆಹುದಿಯೊನಾ ಅದಿಕಾರಿಯೊ ಯೆಸುನಾ ಅಗಾ ಪಾಚಾ಼ ಹುಬ್ರಯಾ. ತ್ಯುನೆ ತಿನೆ\"ಹಜು಼ನ ಕೆಕ್ಲಿ ಯೆಳ ತಾರಾ ಹುತಿ ಹಮೊಕ್ಹು ಕೆಕ್ಲಾ ದಿನ್ನ ಝಾಕಿನ ಮ್ಹೆಲ್ಸಿ? ಕ್ಹರಿ ಸು ಛೆ ಖುಲ್ಲಾ ಕೆ. ತು ಕ್ರಿಸ್ತ ವ್ಹೈ ಸು? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ತೆ ವಾತೆ ಯೆಸು \"ಮಿ ತೆಳಾಮಾಜ಼ ತುಮೊನೆ ಕದ್ಯೊ. ತೆನೈಸೊ ತುಮೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ಮಿ ಮಾರಾ ಬಾನಾ ಅದಿಕಾರಕ್ಹು ಕರಾನಾ ಅದ್ಭುತ ಕಾಮೊ ಮಾರಾಹುತಿ ಸಾಕ್ಷಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ತೆನೈಸೊ ತುಮೆ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ತಾ. ಕಾಕದ್ಯಾಮ ತುಮೆ ಮಾರಾ ಬಕ್ರಾ ನ್ಹವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ಮಾರಾ ಬಕ್ರಾ ಮಾರಿ ಆವಾಜನೆ ಐಕಸ. ಮಿ ತ್ಯುನೊನೆ ತಿಳ್ದಿಲಿದ್ಯೊಸ ವರಿ ತೆ ಬಕ್ರಾ ಮಾರಾ ಪಾಚಾ಼ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ಮಾರಾ ಬಕ್ರಾವೊನೆ ಮಿ ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವ್ಸ. ತ್ಯುನೆ ಕೆಳಾಮಾಬಿ ಮರ್ತಾ ನೈ, ವರಿ ತ್ಯುನೊನೆ ಕುನ್ನಜ ಮಕಂತಾ ಉದಾಳಿನ ದುರ ಕರಾನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ತ್ಯುನೊನೆ ಮಾರೊ ಬಾಜ ಮನೆ ದಿದ್ಯೊ. ತೆ ಕ್ಹಾರಾವೊತಿಬಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ತ್ಯುನೊನೆ ಮಾರಾ ಬಾನಾ ಹತ್ತಮಾತಾ ಕುನ್ನಜ ನೈ ಉದಾಳಿ ಲೆಸಕ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ಬಾ ವರಿ ಮಿ ಯಕ್ಕಜ಼ ವ್ಹೈ \"ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ತೆಳಾಮಾ ವರಿ ಯಹುದ್ಯೊ ಯೆಸುನೆ ಮಾರಾನಾ ಹುತಿ ದಗ್ಡಾ ಇನಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ತೆನೈಸೊ ಯೆಸು ತ್ಯುನೊನೆ\"ಮಿ ಬಾಕಂತೊ ಘನ್ನಾ ಚೊ಼ಕಾ ಕಾಮೊ ಕರಿನ ದೆಕಾಡ್ಯೊಸ. ವರಿ ಎ ಚೊ಼ಕಾ ಕಯಾ ಕಾಮ್ನಾ ಹುತಿ ತುಮೆ ಮನೆ ದಗ್ಡಾಲಿನ ಮಾರಾನೆ ದೆಕಾಡ್ಯಾಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ಯಹುದ್ಯೊ\"ಹಮೆ ತುನೆ ದಗ್ಡಾಲಿನ ಮಾರಾನು ತು ಕರಲ ಕಯಾಜ ಕಾಮೊಕ್ಹು ನ್ಹವೈ. ತು ಕರಾನಾ ಕ್ಹುದಾನಿ ದುಷಣೆನಾ ಹುತಿಜ ವ್ಹೈ. ತು ಖಾಲಿ ಯಕ್ಕ ಮನಕ್ಹ ರ‍್ಹೈನ ತುನೆ ತುಜ಼಼ ಕ್ಹುದಾಜ ವ್ಹೈ ಕೈನ ಕೈಲಿವಾಡ್ಯೊಸ! ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ತಿನೆ ಯೆಸು \"ತುಮಾರಾ ಧರಮಶಾಸ್ತ್ರಮಾ\" ಮಿ ತುಮೆ ಕ್ಹುದಾವೊ ಕೈನ ಕದಲ \"ಬರ್ದಲ ನತ್ತಿ ಸು? ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ಯಕ್ಕೆಳೆ ತೆ ತ್ಯುನೊನೆ ಕ್ಹುದಾವೊ ವ್ಹೈ ಕೈನ ಕ್ಹುದಾನಿ ವಾತೊ ಐಯೊಸ ತ್ಯುನೊನೆ ಕ್ಹುದಾವೊ ವ್ಹೈ ಕೈನ ಬಲಾವಾನು ರ‍್ಹಯುಮ ಪವಿತ್ರ ಗ್ರಂಥನೆ ಸುಳ್ಳ ಕವಾನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ಇಮ್ಮ ರ‍್ಹವಾನು ರ‍್ಹಯುಮ ಬಾ ತಿನಾ ಸ್ವಂತವಾಲಾ ವ್ಹೈ ಕೈನ ಇನಿಲಿನ ದುನಿಯಾಮಾ ಮೊಕ್ಲಲವಾಲಾನ ಹುತಿ ಕಿ ರ‍್ಹಸ? ಮಿ \"ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ\" ಕೈನ ಕದಲ ಹುತಿ ತುಮೆ ಮಿ ದುಷಣೆ ಕರಾಡ್ಯೊಸ ಕೈನ ಕವಾನು ಕಾ? ");
INSERT INTO sle_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ಮಾರೊ ಬಾ ಕಾಮೊ ಮಿ ನೈ ಕರ‍್ಯಾಮ, ಮಿ ಕವಾನು ಬರೊಕ್ಹೊ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ತೆನೈಸೊ ಮಿ ತಿಮ್ಮ ಕರಾನು ರ‍್ಹಯುಮ ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ತುಮೆ ಮನೆ ನಂಬಾಡ್ಯಾ ನತ್ತಿ. ಅದ್ಭುತನೆ ನಂಬೊ ಇಮ್ಮ ಬಾ ಬಿ ಮಾರಾಮಾ ಛೆ ವರಿ ಮಿ ತಿಮಾ ಛೆ ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ಯೆಸುನೆ ಧರಾನೆ ಯಹುದ್ಯೊ ವರಿ ಕೊಶಿಶ ಕರ‍್ಯಾ. ತೆನೈಸೊ ಯೆಸು ತ್ಯುನಾಕ್ಹು ಚುಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ಪಾಚಲ್ತೊ ಯೆಸು ಯೊರ್ದನ ನದಿನಾ ಬಿಜಿ ದಂಡಿಯೆ ಫರಿನ ಗಯೊ. ಯೊಹಾನ ಪೈಲಾ ಬಾಪ್ತಿಸ್ಮ ಕರಾವಾನಿ ಜ಼ಗಾಯೆ ಯೆಸು ಗೈನ ತ್ಯಾಜ ರ‍್ಹಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ತೆಳಾಮಾ ಘನ್ನಾ ಮನಕ್ಹೊ ತಿಕನ ಆಯಾ\" ಯೊಹಾನ ಕೆಳಾಮಾಜ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍್ಯೊ ನೈ. ತೆನೈಸೊ ಯೊಹಾನ ಎ ಮನಕ್ಹನಾ ಹುತಿ ಕದಲ ಹರ ಯಕ್ಕ ಕ್ಹರಿ ವ್ಹೈ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ವರಿ ತ್ಯಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುಪರ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ಲಾಜರ ಕವಾಲೊ ಯಕ್ಲೊ ಅರಾಮ ನೈಸೊ ವ್ಹತ್ತೊ. ತೆ ಬೆಥಾನ್ಯ ಕವಾನಾ ಗಾಮಮಾ ವ್ಹತ್ತೊ. ಮರಿಯಳ ವರಿ ತಿನಿ ಭೆನ ರ‍್ಹಯಲ ಮಾರ್ಥಳ ಎಜ಼ ಗಾಮ್ಮಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ಪ್ರಭುನೆ (ಯೆಸುನೆ) ಬಾಸನು ತೆಲ ಲಗಾಡಿನ ತಿನಾ ಪಗೊನೆ ತಿನಾ ಮಾತಾನಾ ಬಾಲೊಕ್ಹು ನುಚಚಲವಾಲಿ ಎ ಮರಿಯಳ ವ್ಹೈ. ಅರಾಮ ನೈ ರ‍್ಹಯಲ ಲಾಜರ ಮರಿಯಳನೊ ಭೈ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ತಿನಾಹುತಿ ಭಂಬಿ ಭೆನೊ ಯೆಸುನೆ\"ಪ್ರಭು, ತಾರೊ ಮಯಾನೊ ದೊಸ್ತ ಥಯಲ ಲಾಜರ ಅರಾಮ ನೈಸೊ ಪಾಡ್ಯೊಸ\" ಕವಾನು ಸಂದೆಶ ಮೊಕ್ಲಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ಯೆಸು ಎ ಐಕಿನ\"ಎ ರೊಗ ಕ್ಹುದಾನಿ ವರಿ ಕ್ಹುದಾನಾ ದಿಕ್ರಾನೆ ಮಹಿಮಾನಾ ಹುತಿ ಐಸ ತೆನೈಸೊ ಮರಾನಾ ಹುತಿ ನ್ಹವೈ\" ಕೈನ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ಯೆಸು ಮಾರ್ಥಳ, ತಿನಿ ಭೆನನೆ ವರಿ ಲಾಜರನೆ ಮಯಾ ಕರ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ಲಾಜರ ಅರಾಮ ನೈಸೊ ಛೆ ಕವಾನಿ ವಾತ ತೆ ಐಕಲ್ಪರಬಿ ತೆ ರ‍್ಹಯಲ ಜ಼ಗಾಜ ಹಜು಼ನ ಬೆ ದಿನ್ನ ಲಕ್ಕಾ ರ‍್ಹಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ಪಾಚಲ್ತೊ ತೆ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ\"ಅಪೆ ಯುದೆಯನೆ ಫರಿನ ಗಯ್ಯೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ಶಿಷ್ಯಾ ತಿನೆ\"ಗುರು, ದಕ್ಹಾ ಪೈಲಾಜ ಯೆಹುದಿಯೊ ತುನೆ ದಗ್ಡಾವೊಕ್ಹು ಕಲಾಸ ಕರಾನೆ ದೆಕ್ಯಾ. ಹಮ್ನಾ ತು ವರಿ ತ್ಯಾ ಜೌ ಕೈನ ಕವಾಡ್ಯೊಸ ತೊ? ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ಯೆಸು ತ್ಯುನೊನೆ \"ದಿನ್ಮಾ ಬಾರಾ ಘಂಟಾ ರ‍್ಹವಸ ವ್ಹೈ ಸು ನೈ? ದಿನ್ನಮಾ ಚಾಲಾಲೊ ಪಡತೊ ನೈ. ಕಾಕದ್ಯಾಮ ಎ ದುನಿಯಾನಿ ಉಜಾಲಾಕ್ಹು ತೆ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ತೆನೈಸೊ ರಾತಮಾ ಚಾಲಾಲೊ ಟೆಕ್ಹ ಲಾಗಿನ ಪಡಸ. ಕಾಕದ್ಯಾಮ ದೆಕಿನ ಚಾಲಾನೆ ತಿನೆ ಕಯುಜ಼ ಉಜಾಲು ನೈ ರ‍್ಹತು\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ಯೆಸು ಎ ಸಂಗತಿ ಕದಲ ಪರ\"ಅಪ್ನೊ ದೊಸ್ತ ಥಯಲ ಲಾಜರ ಹಮ್ನಾ ಕ್ಹುರಯೊಸ. ತಿನೆ ಉಟಾಡಾನೆ ಮಿ ತ್ಯಾ ಚಾಲ್ಯೊಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ಶಿಷ್ಯಾ ತಿನೆ\"ಪ್ರಭು, ತೆ ನಿಂದರ ಕರತೊ ರ‍್ಹಯಲ ಅರಾಮ ಥಾವಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ಲಾಜರ ಮರಿ ಗಯೊಸ ಕವಾನಾ ಮತ್ಲಬಮಾ ಯೆಸು ಕದ್ಯೊ. ತೆನೈಸೊ ಲಾಜರ ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುರಯೊಸ ಕವಾನಾ ಮತ್ಲಬಮಾ ಯೆಸು ಕದ್ಯೊಸ ಕೈನ ಶಿಷ್ಯಾ ತಿಳ್ದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ತಿನಾಹುತಿ ಯೆಸು ತ್ಯುನೊನೆ ಕರೆಟ್ಟ\"ಲಾಜರ ಮರಿ ಗಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ತೆನೈಸೊ ತುಮಾರಾ ಹುತಿ ಮಿ ತ್ಯಾ ನೈ ರ‍್ಹಯಲ ಹುತಿ ಖುಶಿ ಥೌಸ. ಕಾಕದ್ಯಾಮ, ತೆಳಾಮಾ ತುಮೆ ಮಪರ ಬರೊಕ್ಹೊ ಕರೊಶಿ. ಆವೊ, ತಿಕನ ಗಯ್ಯೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ತೆಳಾಮಾ ಔಳಿ ಜೌಳಿ ಕವಾಲೊ ತೊಮ, ಆವೊ \"ಅಪೆಬಿ ಗುರುನಾ ಕ್ಹಾತೆ ತ್ಯಾ ಗೈಯೆ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ಮರಿಯೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ಯೆಸು ಬೆಥಾನಿಯೆ ಆಯೊ. ಹಮ್ನಾ ತುಬಿ ಲಾಜರ ಮರಿನ ಮಜಾರಮಾ ರ‍್ಹೈನ ಚಾರ ದಿನ್ನ ಥಯಾ ಕೈನ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ಬೆಥಾನ್ಯ ಯೆರುಸಲೆಮತಿ ಕಮ್ಸೆ ಕಮ್ಮ ಬೆ ಮೈಲ ದುರ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ಘನ್ನಾ ಯಹುದ್ಯೊ ಮಾರ್ಥಾ ವರಿ ಮರಿಯಳಕನ ಆಯಾತಾ. ತ್ಯುನೊನೆ ತ್ಯುನೊ ಭೈ ಥಯಲ ಲಾಜರನಾ ಮರಣನಾ ಹುತಿ ಸಮಾದಾನ ಕರಾನೆ ತ್ಯುನೆ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ಯೆಸು ಆವಾಡ್ಯೊಸ ಕೈನ ಐಕಿನ ಮಾರ್ಥಳ ತಿನೆ ಮಳಾನೆ ಭಾರಿ ಗೈ. ತೆನೈಸೊ ಮರಿಯಳ ಘರ್ಮಾಜ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ಮಾರ್ಥಳ ಯೆಸುನೆ\"ಪ್ರಭು, ತು ನ್ಹ್ಯಾ ರ‍್ಹವತ್ತೊ, ಮಾರೊ ಭೈ ಮರ್ತೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ತೆನೈಸೊ ಹಮ್ನಾಬಿ ತು ಸುಬಿ ಕ್ಹುದಾನೆ ಪುಚ್ಚೊ ತುಬಿ ತೆ ತುನೆ ದಿವಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ಯೆಸು ತಿನೆ\"ತಾರೊ ಭೈ ವರಿ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆವಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ಮಾರ್ಥಳ ತಿನೆ\"ಪುನರುತ್ಥಾನ ಥಾವಾನಾ ಲಾಸ್ಟನಾ ದಿನ್ನೆ ತೆ ವರಿ ಉಟಿನ ಆವಸ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ\" ಕೈನ ಉತ್ತರ ದಿದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ಯೆಸು ತಿನೆ\"ಮಿಜ಼ ಪುನರುತ್ಥಾನ ವ್ಹೈ ವರಿ ಮಿಜ಼ ಜ಼ಲಮ ವ್ಹೈ. ಮಪರ ಬರೊಕ್ಹೊ ಕರಾಲೊ ತೆ ಮರಲಪರಬಿ ವರಿ ಜಿವ್ತೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ವರಿ ಜಿವ್ತೊ ರ‍್ಹೈನ ಮಪರ ಬರೊಕ್ಹೊ ಕರಾಲೊ ಕೆಳಾಮಾಬಿ ಮರ್ತೊಜ ನೈ. ತು ಎ ಬರೊಕ್ಹೊ ಕರಶಿ ಸು? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ತೆಳಾಮಾ ಮಾರ್ಥಳ\"ಹೊ ಪ್ರಭು, ತು ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಮಿ ಬರೊಕ್ಹೊ ಕರುಸ, ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಥಯಲ ಎ ದುನಿಯಾನೆ ಆವಾಲೊ ತುಜ಼಼ ವ್ಹೈ\" ಕೈನ ಉತ್ತರ ದಿದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ಮಾರ್ಥಳ ಇಮ್ಮ ಕದಲ ಪರ, ತಿನಿ ಭೆನ ಥಯಲ ಮರಿಯಳ ಕನ ಫರಿನ ಗೈ. ತೆ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಿನ\"ಗುರು ತುನೆ ಬಲಾವಾಡೊಸ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ಎ ಐಕಲ ಬರೊಬ್ಬರ ಮರಿಯಳ ಉಟಿನ ಯೆಸು ಮಳಾನೆ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ಯೆಸು ಹಜನ ಗಾಮನಾ ಮ್ಹೈ ಆಯೊ ನ್ಹೊತೊ. ಮಾರ್ಥಳ ತಿನೆ ಮಳಲ ಜ಼ಗಾಪರ ತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ಯಹುದ್ಯೊ ಮರಿಯಳನಾ ಕ್ಹಾತೆ ಘರಮಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ತಿನೆ ಸಮಾದಾನ ಕರಾಡಾತಾ. ಮರಿಯಳ ಉಟಿನ ಜಲ್ದಿ ಜಾ಼ವಾನು ತ್ಯುನೆ ದೆಕ್ಯಾ. ತೆ ರವಾನಾ ಹುತಿ ಮಜಾರ ಕನ ಚಾ಼ಲಿಸ ಕೈನ ತ್ಯುನೆ ತಿಳ್ದಿಲಿನ ತಿನಾ ಪಾಚಾ಼ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ಯೆಸು ರ‍್ಹಯಲ ಜ಼ಗಾಯೆ ಮರಿಯಳ ಗೈ. ತೆ ಯೆಸುನೆ ದೆಕಲ ಬರೊಬ್ಬರ ತಿನಾ ಪಗೊನೆ ಅಡ್ಡ ಪಡಿನ\"ಪ್ರಭು, ತು ನ್ಹ್ಯಾ ರ‍್ಹವತ್ತೊ, ಮಾರೊ ಭೈ ಮರತೊ ನ್ಹೊತೊ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ಮರಿಯಳ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ಆಯಲ ಯೆಹುದಿಯೊನು ರವಾನು ಯೆಸು ದೆಕಲ ಪರ, ತಿನಾ ಮನಸೆ ಲಾಗಿನ ಘನ್ನೊ ದುಖ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ಯೆಸು ತ್ಯುನೊನೆ\"ತಿನೆ ಕಿಜಾ಼ ಮ್ಹೆಲ್ಯಾಸ? ಕೈನ ಪುಚ್ಚೊ. ತಿನೆ ತ್ಯುನೆ\"ಪ್ರಭು, ಐನ ದೆಕ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ಯೆಸು ರ‍್ವಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ತೆಳಾಮಾ ಯಹುದ್ಯೊ\"ದೆಕೊ! ಎ ಲಾಜರನೆ ಕೆಕ್ಲೊ ಮಯಾ ಕರಸ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ತೆನೈಸೊ ದಕ್ಹಾ ಯಹುದ್ಯೊ\"ಯೆಸು ಕುಡ್ಡಾವೊನಾ ಡೊಳಾ ಅರಾಮ ಕರ‍್ಯೊತೊ ನೈ; ಲಾಜರನೆಬಿ ಸಹಾಯ ಕರಿನ ತಿನೆ ಮರಣಕ್ಹು ಚುಕೌಸು ನೈ? ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ಯೆಸು ತಿನಾ ಮನಸ್ಮಾ ವರಿ ಘನ್ನೊ ದುಖ ಥೈನ, ಲಾಜರ ರ‍್ಹಯಲ ಮಜಾರಕನ ಆಯೊ. ತೆ ಮಜಾರ ಯಕ್ಕ ಗವಿ ವ್ಹತ್ತಿ. ತಿನಾ ಮ್ಹೊಡಾನೆ ಮ್ಹೊಟೊ ದಗ್ಡೊ ಝಾಕ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","\"ತೆ ದಗ್ಡೊ ಕಾಡಿ ಪಾಡೊ \"ಕೈನ ಯೆಸು ಕದ್ಯೊ. ತೆಳಾಮಾ ಲಾಜರನಿ ಮ್ಹೊಟಿ ಭೆನ ಮಾರ್ಥಳ\"ಲಾಜರ ಮರಿನ ಚಾರ ಥೈ ಗೈಯಾಸ. ತಿನಾಹುತಿ ತ್ಯಾ ಕೆಟ್ಟ ಬಾಸ ಛೆ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ತೆ ವಾತೆ ಯೆಸು, ಮಾರ್ಥಳನೆ ಮಿ ತುನೆ ಕದಲ ಶೆ ಕರ್ಲೆಶಿಸು? ತು ಬರೊಕ್ಹೊ ಕರಿಮ ಕ್ಹುದಾನಿ ಮಿ,ಹಿಮಾ ದೆಕಸಿ ಕೈನ ಮಿ ತುನೆ ಕದ್ಯೊತೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ತಿನಾ ಹುತಿ ಸಮಾದಿನಿ ಝಾಕಲ ದಗ್ಡೊ ಕಾಡ್ಯಾ. ತೆಳಾಮಾ ಯೆಸು ಡೊಳಾ ಉಚೈನ ಸ್ವರ್ಗನೆ ದೆಕಿನ ಬಾ ಮಾರಿ ಪ್ರಾಥನಾ ಐಕಲ ಹುತಿ ಮಿ ತುನೆ ಕೊಂಡಾಡುಸ. ");
INSERT INTO sle_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ತು ಹಮೆಶಾಬಿ ಮಿ ಕವಾನು ಐಕಸಿ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಛೆ. ವರಿಬಿ ಮಾರಾ ಸುತ್ತೆ ಮುತ್ತೆ ಮನಕ್ಹೊನಾ ಹುತಿ ಮಿ ಎ ಕ್ಹಾರು ಕವಾಡ್ಯೊಸ. ತು ಮನೆ ಮೊಕ್ಲಲಲ ಹುತಿ ತ್ಯುನೆ ಬರೊಕ್ಹೊ ಕರುಜ ಕೈನ ಮಿ ಆಸ ಕರುಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ಎ ಕ್ಹಾರು ಕದಲ್ಪರ ಯೆಸು ಜೊ಼ರ ಆವಾಜಕ್ಹು\"ಲಾಜರ, ಭಾರೊ ಆ\" ಕೈನ ಬಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ಮರಿ ಗಯಲ ತೆ ಮನಕ್ಹ ಭಾರೊ ಆಯೊ. ತಿನಾ ಹತೊ ಪಗೊ ಫಡ್ಕಾಕ್ಹು ಭಾಂದಲ ವ್ಹತ್ತಾ. ತಿನು ಮ್ಹೊಡು ಫಡಕಾಕ್ಹು ಸುತ್ತಲ ವ್ಹತ್ತು. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನೊನೆ\"ತಿನೆ ಖೊಲೊ ವರಿ ಜಾ಼ವಾನೆ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ಮರಿಯಳನೆ ಮಳಾನೆ ಆಯಲ ಘನ್ನಾ ಯಹುದ್ಯೊ ತ್ಯಾ ವ್ಹತ್ತಾ. ಯೆಸು ಕರಲ ಎ ಕಾಮ ದೆಕಿನ ಇವ್ನಾಮಾ ಘನ್ನಾ ಜ಼ನಾ ತಿನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ತೆನೈಸೊ ದಕ್ಹಾ ಜ಼ನಾ ಫರಿಸಾಯರೊ ಕನ ವಾಪಸ ಗೈನ ಯೆಸು ಕರಲ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ತೆಳಾಮಾ ಯಾಜಕೊ ವರಿ ಫರಿಸಾಯರೊ ಯಹುದಿಯೊನಾ ವಿಚಾರ ಕರಾನಾ ಸಭೆಮಾ ಬಲೈನ\"ಹಮೆ ಸು ಕರಿಯೆ? ಎ ಮನಕ್ಹ ಘನ್ನಾ ಸುಚಕ ಕಾಮೊ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ಎ ಕಾಮೊ ಕರಾನೆ ಹಮೆ ತಿನೆ ಮೌಕೊ ದಿದ್ಯಾಮ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಇನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಕರಸ. ತೆಳಾಮಾ ರೊಮನಾ ರಾಜ್ಯವಾಲಾ ಐನ ಅಪ್ನಾ ದೆವಾಲಯನೆ ಅಪ್ನಾ ದೆಶನೆ ಹಾಳ ಕರಸ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ತ್ಯುನಾಮಾ ಕಾಯಫ ಕವಾಲೊ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ತೆ ವರಕ್ಹ ಖಾಸ ಯಾಜಕ ಥಯೊತೊ. ತೆ\"ತುಮೊನೆ ಸುಜ಼ ಗ್ವತ್ತ ನತ್ತಿ! ");
INSERT INTO sle_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ಇಡಿ ಜನಾಂಗ ಹಾಳ ಥಾವಾತಿ ಯಕ್ಲೊ ತ್ಯುನಾ ಹುತಿ ಮರಾನು ಚೊ಼ಕು ವ್ಹೈ. ತೆನೈಸೊ ತುಮೆ ಇನೆ ತಿಳ್ದಿಲಿವಾಡ್ಯಾ ನತ್ತಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ಎ ಕಾಯಫನು ಸ್ವಂತ ವಿಚಾರ ನ್ಹೊತಿ. ತೆ ವರಕ್ಹನೊ ಖಾಸ ಯಾಜಕ ವ್ಹತ್ತೊ. ತಿನಾ ಹುತಿ ಯೆಹುದಿಯೊನಾ ಹುತಿ ಯೆಸು ಮರಾಡ್ಯೊಸ ಕೈನ ತೆ ಪ್ರವಾದನೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ಹೊ, ಯೆಹುದಿಯೊನಾ ಹುತಿ ಕ್ಹಾರಿ ದುನಿಯಾಮಾ ಜುದಾ ಥಯಲ ಕ್ಹುದಾನಾ ಕ್ಹಾರಾ ಬಚ್ಚಾವೊನೆ ಮಳೌ ಕೈನ ತೆ ಮರಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ತೆಳಾಮಾತಾಜ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ಯೆಸುನೆ ಖಲಾಸ ಕರಾನೆ ವಿಚಾರ ಕರಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ಯೆಸು ಯುದಾಯಾ ಪ್ರಾಂತ್ಯಮಾ ನಾಯಕೊ\"ಪಾಪಮಾಜ ಹುಟ್ಟಿನ ಬೆಳದಲವಾಲೊ ತು ವ್ಹೈ! ಹಮೊನೆ ಉಪದೆಶ ಕರಶಿ ಸು? ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ತೆನೈಸೊ ತ್ಯುನೆ ತಿನೆ ಜಬರದಸ್ತಿಕ್ಹು ಭಾರಾ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ತೆಳಾಮಾ ಯೆಹುದಿಯೊನು ಪಸ್ಕ ಸನ್ನ ನಜಿಕ ವ್ಹತ್ತು. ಪಸ್ಕ ಸನ್ನನಾ ಪೈಲಾಜ ತ್ಯುನಾ ಗಾಮೊತಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆರುಸಲೆಮೆ ಗಯಾತಾ. ಖಾಸ ರ‍್ಹಯಲ ಕಾಮೊ ಕರಿನ ಪಸ್ಕ ಸನ್ನನೆ ತ್ಯುನೊನೆ ಖುದ್ದ ಕರಿಲ್ಯು ಕೈನ ತ್ಯುನೆ ಗಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ತ್ಯುನೆ ತ್ಯಾ ಯೆಸುನೆ ಹುಡ್ಕಾಡಾತಾ ವರಿ ತ್ಯುನೆ ದೆವಾಲಯಮಾ ತ್ಯುನೆ ಯಕ್ಕ ಜ಼ಗಾ ಮಳಿನ, ತುಮಾರಿ ವಿಚಾರ ಸು ವ್ಹೈ? ತೆ ಕ್ಹರಿಮಾಜ಼ ಆ ಸನ್ನನೆ ನೈ ಆತೊ ಸು? ಕೈನ ಯಕ್ನೆ ಯಕ್ಕ ಪುಚ್ಚಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ಖಾಸ ಯಾಜಕೊ ವರಿ ಫರಿಸಾಯರೊ, ಯೆಸು ಕಿಜಾ಼ ಛೆ ಕವಾನು ಕಿನೆತಬಿ ಗ್ವತ್ತ ಥಯುಮ ತ್ಯುನೊನೆ ಕೌ ಕೈನ ಆಗನ್ಯಾ ದಿದ್ಯಾತಾ. ತ್ಯುನೆ ತಿನೆ ಧರು ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ಪಸ್ಕ ಸನ್ನೆ ಹಜು಼ನ ಛೆ ದಿನ್ನ ರ‍್ಹತಾಮಾಜ ಯೆಸು ಬೆಥಾನಿಯೆ ಗಯೊ. ಲಾಜರ ರ‍್ಹಯಲ ಗಾಮಜ ಬೆಥಾನ್ಯ ವ್ಹೈ. ಯೆಸು ಮರಲವಾಲಾವೊಮಾತೊ ಉಟಾಡಲ ಮನಕ್ಹಜ ಲಾಜರ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ತ್ಯುನೆ ಯೆಸುನೆ ರಾತನು ಅನ್ನ ತಯ್ಯಾರ ಕರ‍್ಯಾ. ಮಾರ್ಥಳ ಅನ್ನ ಘಾಲಿನ ದಿವಾಡಿತಿ. ಯೆಸುನಾ ಕ್ಹಾತೆ ಅನ್ನ ಖಾವಾಲಾವೊಮಾ ಲಾಜರಬಿ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ತೆಳಾಮಾ ಮರಿಯಳ ಜಟ ಮಾಂಸಕ್ಹು ಕರಲ ಘನ್ನು ಮೊಗು ರ‍್ಹವಾನು ಬಾಸನು ತೆಲನಿ ಭರಣಿ ಲಿನ ಯೆಸುನಾ ಪಗೊಪರ ರಿಚೈ. ವರಿ ತಿನಾ ಮಾತಾನಾ ಬಾಲೊಕ್ಹು ತಿನಾ ಪಗೊ ನುಚ್ಚಿ. ತೆ ಬಾಸನು ತೆಲನಿ ಚೊ಼ಕಿ ಬಾಸ ಕ್ಹಾರಾ ಘರಮಾ ಫೈಲಿ ಗೈತಿ. ");
INSERT INTO sle_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ಇಸ್ಕರಿಯೊತ ಯುದ ತ್ಯಾ ವ್ಹತ್ತೊ. ತೆ ಯೆಸುನಾ ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ಅಗೊ, ಯೆಸುನೆ ಮೊಸ ಕರ‍ಲವಾಲೊ ಎಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ತೆ\"ತೆ ಬಾಸನು ತೆಲನಾ ಕಿಮ್ಮತ ತನ್ನ ಕ್ಹೊ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಕ್ಹು ಇಕ್ಕಿನ ತೆ ದೊಕ್ಡಾ ಗರಿಬೊನೆ ಕಾ ದಿದಿ ನೈ. ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ತೆನೈಸೊ ಯುದನೆ ಗರಿಬೊನಾ ಹುತಿ ಕ್ಹರಿಬಿ ಚಿಂತಾ ನ್ಹೊತಿ. ತೆ ಚವಟ್ಟೊ ರ‍್ಹಯಲಕ್ಹು ತಿಮ್ಮ ಕದ್ಯೊ. ಶಿಷ್ಯಾವೊನಿ ಗುಂಪನಾ ಹುತಿ ರ‍್ಹಯಲ ದೊಕಡಾವೊನಿ ಗಲ್ಲೊ ತಿಕನ ವ್ಹತ್ತಿ. ತೆ ತೆಳಾಮಾ-ತೆಳಾಮಾ ತೆ ಪೆಟಗಿಮಾನಾ ದೊಕ್ಡಾ ಕಾಳೆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ಯೆಸು ತಿನೆ\"ತಿನೆ ತರಬು ನಕೊ. ಮನೆ ಶವಸಂಸ್ಕಾರಮಾ ಕರಾನಿ ಪದ್ದತ ತೆ ಹಮ್ನಾ ಕರಾಡಿಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ಗರಿಬೊ ಕೆಳಾಮಾಬಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಸ ತೆನೈಸೊ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ಹರ ಹಮೆಶಾ ನೈ ರ‍್ಹತೊ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ಯೆಸು ಬೆಥಾನಿಮಾ ಛೆ ಕವಾನಿ ಸುದ್ದಿ ಘನ್ನಾ ಯಹುದ್ಯೊ ಐಕಿನ ತಿನೆ ವರಿ ಮರಿನ ಜಿವ್ತೊ ಥಯಲ ಲಾಜರನೆ ದೆಕು ಕೈನ ತ್ಯಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ತೆನೈಸೊ ಖಾಸ ಯಾಜಕೊ ಲಾಜರನೆಬಿ ಖಲಾಸ ಕರಾನೆ ವಿಚಾರೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ಲಾಜರಕ್ಹು ಘನ್ನಾ ಯಹುದ್ಯೊ ತ್ಯುನಾ ನಾಯಕೊಕ್ಹು ದುರ ಥೈನ ಯೆಸುನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಡತಾ. ತಿನಾ ಹುತಿಜ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ಲಾಜರನೆಬಿ ಖಲಾಸ ಕರು ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ಮರ್ನಾ ದಿನ್ನೆ ಯೆಸು ಯೆರುಸಲೆಮೆ ಆವಾಡ್ಯೊಸ ಕವಾನಿ ಸುದ್ದಿ ತ್ಯಾನಾ ಮನಕ್ಹೊನಾ ಮ್ಹೊಟಾ ಗುಂಪನೆ ಗ್ವತ್ತ ಥಯು. ಪಸ್ಕ ಸನ್ನನಾ ಹುತಿ ಆಯಲ ಘನ್ನಾ ಜ಼ನಾ ತ್ಯಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ಮನಕ್ಹೊ ಖಜುರನಾ ಗರಿಯೊ ಲಿನ ಯೆಸುನೆ ಮಳಾನೆ ಗಯಾ ವರಿ ಹೊಸನ್ನಾ ಕೈನ ಜೊ಼ರ ವದ್ರಾಡ್ಯಾ. ಧನ್ಯ ವ್ಹೈ ತೆ ಪ್ರಭುನಾ ನಾಮಪರ ಆವಾಡ್ಯೊಸ. ಧನ್ಯ ವ್ಹೈ ಇಸ್ರಾಯಲನೊ ರಾಜಾ಼ನೆ ಕ್ಹುದಾ ಆಶಿರ್ವಾದ ದಿವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ಯೆಸುನೆ ತ್ಯಾ ಯಕ್ಕ ಗದಡು ಮಳ್ಯು, ತಿನಾ ಉಪ್ಪರ ಬೈಟಿನ ಚಾಲ್ಯೊ. ಪವಿತ್ರ ಗ್ರಂಥ ಕದಲ ಲಿಂಗತ ಎ ಥಯು; ");
INSERT INTO sle_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"ಸಿಯೊನಾನಾ ಮನಕ್ಹೊ, ಭುಚಕು ನಕೊ! ತುಮಾರೊ ರಾಜೊ಼ ಗದಡಾನಾ ಬಚ್ಚಾನಾಪರ ಬೈಟಿನ ಆವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ಯೆಸುನಾ ಶಿಷ್ಯಾ ತೆ ಟೈಮಮಾ ಎ ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ತೆನೈಸೊ ಯೆಸು ಮಹಿಮಾತೊ ಉಟಿನ ಆತಾಮಾ, ಎ ಸಂಗತಿಯೊ ತಿನಾ ಹುತಿ ಧರ್ಮ ಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ಛೆ ಕವಾನು ಶಿಷ್ಯಾವೊನೆ ಶೆ ಆಯಿ; ವರಿ ಮನಕ್ಹೊ ತಿನಾ ಕ್ಹಾತೆ ಅಮ್ಮ ಕರ‍್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ಯೆಸು ಲಾಜರನೆ ಮರಣಮಾತೊ ತಿನೆ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡಲ ಪರ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ತಿನಿ ಸಾಕ್ಷಿ ವ್ಹತ್ತಾ.. ");
INSERT INTO sle_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ಯೆಸು ಕರಲ ಎ ಅದ್ಭುತ ಕಾಮ ಐಕಿನ, ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನೆ ಮಳಾನೆ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ತಿನಾಹುತಿ ಫರಿಸಾಯರೊ ಕದ್ಯಾ \"ದೆಕೊ! ಅಪ್ನಿ ವಿಚಾರ ಉಪಯೊಗ ನೈಸೊ ಥೈ. ಮನಕ್ಹೊ ತಿನೆಜ ಹಿಂಬಾಲಕೊ ಥಾವಾಡ್ಯಾಸ\" ಕೈನ ಯಕ್ಕನೆ ಯಕ್ಲಾ ಬೊಲಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ಫಸ್ಕ ಸನ್ನನೆ ಹುತಿ ಆರಾಧನಾ ಕರಾನೆ ಆಯಲವಾಲಾವೊಮಾ ದಕ್ಹಾ ತ್ಯಾ ಗ್ರಿಕನಾ ಮನಕ್ಹೊಬಿ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ತೆ ಗ್ರಿಕ ಮನಕ್ಹೊ ಫಿಲಿಪ್ಪ ಕನ ಗಯಾ. (ಫಿಲಿಪ್ಪ ಗಲಿಲಾಯನೊ ಬೆತ್ಸಾಯಿ ಕವಾನಾ ಗಾಮ ವ್ಹತ್ತೊ) ತ್ಯುನೆ\"ಸಾಬ, ಹಮೆ ಯೆಸುನೆ ದೆಕು\" ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ತೆ ಥಯಲ್ಪರ ಫಿಲಿಪ್ಪ ಅಂದ್ರೆಯ ಕನ ಗೈನ ಎ ವಿಚಾರ ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ಅಂದ್ರೆಯ ವರಿ ಫಿಲಿಪ್ಪ ಮಳಿನಜ ಯೆಸು ಕನ ಗೈನ ಎ ವಿಷಯ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ಯೆಸು ತ್ಯುನೊನೆ\"ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ತಿನಿ ಮಹಿಮಾ ವ್ಹಂದಿಲಿವಾನೊ ಟೈಮ ಹಮ್ನಾ ಆಯೊಸ ಕೈನ ಜವಾಬ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಬಿ ಕೌಸ. ಕಿದಾ ಲಕ್ಕಾ ಘೌನೊ ಬಿಯ್ಯೊ ಜಿಮಿನ ಪರ ಪಡಿನ ಮರತೊ ನೈ ತೆ ಲಕ್ಕಾ ತೆ ಯಕ್ಕಜ಼ ರ‍್ಹವಸ. ವರಿ ತೆ ಕೆಳಾಮಾ ಮರಸ ತೆಳಾಮಾ ತೆ ಮೊಜಾನೆ ಥಾಯೆ ನೈಸೊ ಯಕ್ಲು ಘೌನಾ ಕಾಳೊಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ಕುನ್ನ ತಿನಾ ಸ್ವಂತ ಜ಼ಲಮನೆ ಮಯಾ ಕರಸ ತೆ ತಿನೆ ಜವೈಲಿವಸ. ಕುನ್ನ ತಿನಾ ಜ಼ಲಮನೆ ದ್ವೆಶ ಕರಸ ತೆ ತಿನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮನಾ ಹುತಿ ಕೈದಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ಕುನ್ನ ಮಾರಿ ಸೆವೆ ಕರು ಕೈನ ಛೆ ತೆ ಮಾರಾ ಪಾಚೊ಼ ಔ. ವರಿ ಮಿ ಕಿಜಾ಼ ರ‍್ಹೌಸ ತ್ಯಾ ಮಾರಾ ಸೆವಕೊಬಿ ರ‍್ಹವಸ ವರಿ ಮಾರೊ ಬಾ ಮಾರಿ ಸೆವಾ ಕುನ್ನ ಕರಸ ತ್ಯುನೊನೆ ಮರ್ಯಾದಿ ದಿವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ಯೆಸು ವಾತ ಅಗಿ ಬಡೈನ\"ಹಮ್ನಾ ಮಾರು ಜ಼ಲಮ ಬುಚ್ಕಾಡ್ಯುಸ. ಮಿ ಸು ಕೌ? ಸು ಅಮ್ಮ ಕೌಸು\"ಬಾ, ಎ ಟೈಮ ಮಪರ ಆವಾನೆ ನಕೊ ದ್ಯು? ನ್ಹವೈ! ತೆನೈಸೊ ಇನಾಹುತಿಜ ಮಿ ಆಯೊಸ. ಕಾಕದ್ಯಾಮ ತ್ರಾಸನಾ ಟೈಮ್ಮಾತೊಜ ಜೌ. ");
INSERT INTO sle_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ಬಾ, ತಿನಾ ನಾಮನೆ ಮಹಿಮಾ ಕರ್ಲಿವಾದೆ ತೆಳಾಮಾ ಹಬಾಳಮಾತಿ ಆಕಾಶವಾಣಿ ಥೈ ಮಿ ಇನಿ ಮಹಿಮಾ ಕರ‍್ಯೊಸ ವರಿಬಿ ಮಿ ಇನಿ ಮಹಿಮಾ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ತ್ಯಾ ಹುಬ್ರಯಲ ಮನಕ್ಹೊನು ಗುಂಪ ಎ ಆವಾಜ ಐಕಿನ \"ತೆ ಗುಡುಗ ವ್ಹೈ\" ಕದ್ಯಾ. ತೆನೈಸೊ ಬಿಜಾ಼ ಮನಕ್ಹೊ\"ಕ್ಹುದಾನೊ ದುತ ಯಕ್ಲೊ ಯೆಸುನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ಯೆಸು ಮನಕ್ಹೊನೆ\"ತೆ ಆವಾಜ ಆಯಲ ಮಾರಾ ಚೊ಼ಕಾನಾ ಹುತಿ ನ್ಹವೈ ತುಮಾರಾ ಚೊ಼ಕಾನಾ ಹುತಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ಎ ದುನಿಯಾನೆ ಫೈಸಲೊ ಥಾವಾನೊ ಟೈಮ ಹಮ್ನಾ ಆಯೊಸ.. ಹಮ್ನಾ ಎ ದುನಿಯಾನೊ ಅದಿಪತಿನೆ ಭಾರಾ ಕಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ಮಿ ಜಿಮಿನ ಪರತೊ ಕೆಳಾಮಾ ಉಪ್ಪರ ಜೌ಼ಸ. ತೆಳಾಮಾ ಮಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಮಕನ ಯಳ್ದಿ ಲ್ಯುಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ತೆ ಮರಾನಾ ತರಿಕಾನೆ ಯೆಸು ಎ ವಾತನಾ ಮುಲಕ ದೆಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ಮನಕ್ಹೊ\"ಕ್ರಿಸ್ತ ಹರ ಹಮೆಶಾ ಜಿವ್ತೊ ರ‍್ಹವಸ ಕೈನ ಹಮಾರು ಧರಮಶಾಸ್ತ್ರ ಕವಸ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ\"ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಉಪ್ಪರ ಜಾ಼ವಸ \"ಕೈನ ತು ಕವಾನು ಶಾನೆ? ಎ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ತಿನೆ ಯೆಸು\"ಹಜು಼ನ ದಕ್ಹಿಯೆಳ ಉಜಾಲು ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಸ. ತಿನಾಹುತಿ ಉಜಾಲು ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹತಾಮಾಜ ಚಾ಼ಲೊ. ತೆಳಾಮಾ ಅಂದಾರು ತುಮೊನೆ ಸುತ್ತಿ ಲೆತು ನೈ. ಕಾಕದ್ಯಾಮ ಅಂದಾರಾಮಾ ಚಾಲಾಲಾನೆ ತೆ ಕಿಜಾ಼ ಚಾಲ್ಯೊಸ ಕವಾನು ಗ್ವತ್ತ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ತಿನಾಹುತಿ ತುಮೊಕನ ಉಜಾಲು ಹಜು಼ನ ರ‍್ಹತಾಮಾಜ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲೊ. ತೆಳಾಮಾ ತುಮೆ ಉಜಾಲಾನಾ ಬಚ್ಚಾ ಥಾವೊಶಿ\" ಕೈನ ಕದ್ಯೊ. ಎ ಸಂಗತಿಯೊ ಕದಲ ಪರ ಯೆಸು ತ್ಯಾಂತೊ ಗೈನ, ತಿನೆ ಮನಕ್ಹೊ ನೈಸೊ ಹುಡಕಾನಿ ಜ಼ಗಾಯೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ಯೆಸು ಘನ್ನಾ ಮ್ಹೊಟಾ ಕಾಮೊ ಕರ‍್ಯೊ. ಮನಕ್ಹೊ ತೆ ಕಾಮೊ ಕ್ಹಾರಾ ದೆಕ್ಯಾತಬಿ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ಇನಾಹುತಿ, ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯ ಕದಲ ವಾತೊ ಪುರಾ ಥಾವಾನು. ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾಮ \"ಪ್ರಭು, ಅಪೆ ಕದಲ ಸಂದೆಶಪರ ಕುನ್ನ ಬರೊಕ್ಹೊ ಕರ‍್ಯುಸ? ಪ್ರಭುನಿ ತಾಕತ ಕಿನೆ ಗ್ವತ್ತ ಥಯು? ಯೆಶಾಯ 53:1 ");
INSERT INTO sle_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ತಿನಾಹುತಿಜ ಮನಕ್ಹೊ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ ನೈ. ಕಾಕದ್ಯಾಮ ಯೆಶಾಯ ವರಿ ಯಕ್ಕ ಜ಼ಗಾ ಅಮ್ಮ ಕದ್ಯೊಸ; ");
INSERT INTO sle_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"ತ್ಯುನಾ ಡೊಳಾವೊಕ್ಹು ನೈ ದಿಕ್ಹೆ ಲಿಂಗತ ತ್ಯುನಾ ಮನಸೊಕ್ಹು ನೈ ತಿಳ್ದಿಲಿದಲ ಲಿಂಗತ ಬದ್ಲಿ ಥೈನ ಅರಾಮ ನೈ ಥಾಯೆ ಲಿಂಗತ ತೆ ತ್ಯುನೊನೆ ಕುಡ್ಡಾ ಕರ‍್ಯೊಸ, ತ್ಯುನಾ ಮನಸೊನೆ ದಗ್ಡಾ ಕರ‍್ಯೊಸ\" ಯೆಶಾಯ 6:10 ");
INSERT INTO sle_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ಯೆಶಾಯ ಎ ಕದಲ ತೆ ತಿನಿ ಮಹಿಮಾ ದೆಕ್ಯೊತೊ ವರಿ ತಿನಾಹುತಿ ಬೊಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ತೆನೈಸೊ ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸು ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ಘನ್ನಾ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊಬಿ ಯೆಸು ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ತೆನೈಸೊ ತ್ಯುನೆ ಫರಿಸಾಯರೊನೆ ಭುಚಿ಼ಕಿನ ತ್ಯುನೊ ಬರೊಕ್ಹೊ ದೆಕಾಡಿನ ದಿದ್ಯಾ ನೈ. ತ್ಯುನೊನೆ ಫರಿಸಾಯರೊ ಸಭಾಮಂದಿರತಾ ಭಾರಾ ಘಾಲಸ ಕೈನ ಭುಚುಕ ತ್ಯುನೊನೆ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ಎ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿ ಮಹಿಮಾತಿಬಿ ಮನಕ್ಹೊನಿ ಹೊಗಳಿಕೆನಾ ಹುತಿಜ ಘನ್ನಿ ಮಯಾ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ಪಾಚಲ್ತೊ ಯೆಸು ಜೊ಼ರ ಅಮ್ಮ ಕದ್ಯೊ; \"ಕುನ್ನ ಮಪರ ಬರೊಕ್ಹೊ ಕರಸ ತೆ ಕ್ಹಾಲಿ ಮಪರ ಯಕ್ಕಜ಼ ಬರೊಕ್ಹೊ ನೈ ಕರ್ತೊ ಮನೆ ವಳಾಯಲವಾಲಾಪರಬಿ ಬರೊಕ್ಹೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ಕುನ್ನ ಮನೆ ದೆಕಸ ತೆ ಮನೆ ವಳಾಯಲವಾಲಾನೆಬಿ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ಮಿ ದುನಿಯಾಮಾ ಉಜಾಲು ಥೈನ ಆಯೊ. ಕಾಕದ್ಯಾಮ ಕುನ್ನ ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಸ ತೆ ಅಂದಾರಾಮಾ ರ‍್ಹೌ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","\"ಮಿ ಎ ದುನಿಯಾಮಾ ಆಯಲ ಮನಕ್ಹೊನೆ ಫೈಸಲೊ ಕರಾನೆ ನ್ಹವೈ. ಎ ದುನಿಯಾಮಾ ರ‍್ಹವಾನಾ ಮನಕ್ಹೊನೆ ಉದ್ದಾರ ಕರಾನೆ ಆಯೊಸ. ತಿನಾ ಹುತಿ ಮಾರಿ ವಾತೊ ಐಕಿನಬಿ ನೈ ಬರೊಕ್ಹೊ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ಫೈಸಲೊ ಕರಾಲೊ ಮಿ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ಮಾರಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ನೈ ಕರಾಲಾನೆ ವರಿ ಮಿ ಕವಾನು ಇನ್ಕಾರಾಲಾವೊನೆ ಫೈಸಲೊ ಕರಾನು ಮಿ ಕದಲ ವಾತೊಜ ವ್ಹೈ. ಲಾಸ್ಟನಾ ದಿನ್ನೆ ತೆಜ಼ ತಿನೆ ಫೈಸಲೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ಎ ಕ್ಹರಿ ವ್ಹೈ ಮಿ ಕದಲ ಕಾಕದ್ಯಾಮ, ಮಾರಾ ಅದಿಕಾರಕ್ಹು ಸುಜ಼ ಕದ್ಯೊ ನತ್ತಿ ಮನೆ ಕುನ್ನ ಮೊಕಲ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ಬಾನಿ ಆಗನ್ಯಾ ಹಮೆಶಾನಾ ಜ಼ಲಮ ಕನ ಚ಼ಲಾವಸ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತಿನಾಹುತಿ ಬಾ ಮನೆ ಕದಲ ಸಂಗತಿಯೊಜ ಮಿ ಕೌಸ\" ");
INSERT INTO sle_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ಫಸ್ಕ ಸನ್ನ ಯಕ್ಕ ದಿನ್ನ ಪೈಲಾನು ದಿನ್ನ ಐಯುತು. ತೆ ಎ ಜಗತ ಛೊಡಿನ ಬಾ ಕನ ಜಾ಼ವಾನೊ ಟೈಮ ನಜಿಕ ಆಯುಸ ಕವಾನು ಯೆಸುನೆ ಗ್ವತ್ತ ಥಯು. ಎ ಲೊಕಮಾ ರ‍್ಹಯಲ ತಿನಾ ಮನಕ್ಹೊನೆ ತೆ ಹಮೆಶಾಬಿ ಮಯಾ ಕರ್ತೊತೊ. ವರಿ ತೆ ತ್ಯುನೊನೊಪರ ರ‍್ಹಯಲ ಘನ್ನಿ ಮಯಾ ದೆಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ಯೆಸು ವರಿ ತಿನಾ ಶಿಷ್ಯಾ ರಾತೆ ಖಾವಾನಾ ಹುತಿ ಬೈಟ್ಯಾತಾ. ಯೆಸುನೆ ಮೊಸ ಕರು ಕೈನ ಸೈತಾನ ಇಸ್ಕರಿಯುತ ಯುದನೆ ವಿಚಾರ ಘಾಲ್ಯು. ಯುದ ಸಿಮೊನನೊ ದಿಕ್ರೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ಬಾ ಹರ ಯಕ್ಕಪರ ತಿನೆ ಅದಿಕಾರ ದಿದ್ಯೊಸ ಕವಾನು ಯೆಸುನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತೆನೈಸೊ ತೆ ಕ್ಹುದಾ ಕಂತೊ ಆಯಲ ವರಿ ಹಮ್ನಾ ಕ್ಹುದಾ ಕನ ಫರಿನ ಜಾ಼ವಾನಾ ಹುತಿ ತಿನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ತ್ಯುನೆ ಅನ್ನ ಖಾತಾಮಾ ಯೆಸು ಉಟಿನ ತಿನು ಉಪ್ಪರಲ್ಯು ಅಂಗ್ಡು ಕಾಡಿನ ಮ್ಹೆಲ್ಯೊ; ವರಿ ಯಕ್ಕ ಟುವಾಲ ಲಿನ ತಿನಾ ಕಂಬರೆ ಭಾಂದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ಪಾಚಲ್ತೊ ಯಕ್ಕ ತಾಂಬ್ಯಾಮಾ ಪಾನಿ ಭರ‍್ಯೊ. ಶಿಷ್ಯಾವೊನಾ ಪಗೊ ಧ್ವಯಿನ ತೆ ಭಾಂದಿಲಿದಲ ತೆ ಫೆರ್ಲಿದಲ ಟುವಾಲಕ್ಹು ತ್ಯುನಾ ಪಗೊ ನುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ತೆ ಸಿಮೊನ ಪೆತ್ರಾಕನ ಆಯಲ ಪರ ಪೆತ್ರಾ\"ಪ್ರಭು, ಹಮಾರಾ ಪಗೊ ತು ಧ್ವೌ ನೈ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ಯೆಸು\"ಹಮ್ನಾ ಮಿ ಸು ಕರಾಡ್ಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ಅಗು ತುನೆ ಗ್ವತ್ತ ಥಾವಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ಪೆತ್ರಾ ತಿನೆ\"ನೈ! ಮಾರಾ ಪಗೊ ತು ಕೆಳಾಮಾಜ ಧ್ವೌ ನೈ\" ಕೈನ ಕದ್ಯೊ. ಯೆಸು \"ತಾರಾ ಪಗೊ ಮಿ ನೈ ಧ್ವಯೊಮ ತು ಮಾರೊ ಶಿಷ್ಯೊ ಕೆಳಾಮಾಜ ಥಾತೊ ನೈ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ತೆಳಾಮಾ ಸಿಮೊನ ಪೆತ್ರಾ, ಪ್ರಭು, ಮಾರಾ ಪಗೊ ಯಕ್ಕಜ಼ ನೈಸೊ ಮಾರಾ ಹತೊ ವರಿ ಮಾತು ಧೊ\" ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ಯೆಸು ತಿನೆ \"ಅಂಗ ಧ್ವಯಲವಾಲಾನು ಅಂಗ ಕ್ಹಾರು ಶುದ್ಧ ರ‍್ಹವಸ. ತೆ ತಿನಾ ಪಗೊ ಧ್ವೈಲಿದ್ಯಮ ಬಸ್ಸ. ತುಮೆಬಿ ಶುದ್ಧ ಥಯಾಸ, ತೆನೈಸೊ ತುಮೊಮಾ ಹರ ಯಕ್ಲೊ ಶುದ್ಧ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ತಿನೆ ಮೊಸ ಕರಾಲೊ ಕುನ್ನ ವ್ಹೈ ಕೈನ ತಿನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತಿನಾಹುತಿ ತೆ\"ತುಮಾರಾಮಾ ಹರ ಯಕ್ಲೊ ಶುದ್ಧ ನತ್ತಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ಯೆಸು ತ್ಯುನಾ ಪಗೊ ಧ್ವಯಲ ಪರ ತಿನು ಉಪ್ಪರಲ್ಯು ಅಂಗ್ಡು ಘಾಲಿನ ವರಿ ತಿನಿ ಜ಼ಗಾಪರ ಬೈಟ್ಯೊ. ವರಿ ಅಮ್ಮ ಕದ್ಯೊ; \"ಹಮ್ನಾ ಮಿ ಸು ಕರ‍್ಯೊ ತೆ ತುಮೊನೆ ಗ್ವತ್ತ ಥಯು ಸು? ");
INSERT INTO sle_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ತುಮೆ ಮನೆ\"ಗುರು ವರಿ ಪ್ರಭು ಕೈನ ಬಲಾವೊಸಿ. ತುಮೆ ಇಮ್ಮ ಬಲಾವಾನು ಕರೆಟ್ಟ ವ್ಹೈ. ಕಾಕದ್ಯಾಮ ಮಿ ತೆಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ತಿನಾಹುತಿ ಪ್ರಭು ವರಿ ಗುರು ಥಯಲ ಮಿ ತುಮಾರಾ ಪಗೊ ಸೆವಕ ಲಿಂಗತ ಧ್ವಯೊಸ. ಕಾಕದ್ಯಾಮ ತುಮೆಬಿ ಬಿಜಾ಼ವೊನಾ ಪಗೊ ಧೌ. ");
INSERT INTO sle_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ಎ ಕಾಮೊನೆ ಮಿಜ಼ ಸಾಕ್ಷಿ ಥಯೊಸ. ಕಾಕದ್ಯಾಮ ಮಿ ತುಮೊನೆ ಕರಲ ತಿಮ್ಮಜ಼ ತುಮೆಬಿ ಬಿಜಾ಼ವೊನಾ ಕ್ಹಾತೆ ಕರು. ");
INSERT INTO sle_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಸೆವಕ ಮಾಲಕ್ತಿ ಮ್ಹೊಟೊ ನ್ಹವೈ. ತಿನಾಹುತಿ ಸಂದೆಶ ಹುತಿ ಆಯಲವಾಲೊ ಮೊಕ್ಲಲವಾಲಾತಿ ಮ್ಹೊಟೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ತುಮೆ ಎ ಸಂಗತಿಯೊ ತಿಳದಿಲಿನ ಇನಾಲಿಂಗತ ಚಾ಼ಲಿಲಿನ ಗಯಾಮ ಖುಶಿಕ್ಹು ರ‍್ಹವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","\"ಮಿ ತುಮಾರಾ ಕ್ಹಾರಾವೊನಾ ಹುತಿ ಬೊಲಾಡ್ಯೊ ನತ್ತಿ. ಮಿ ಇನಿಲಿದಲ ಮನಕ್ಹೊನಾ ಹುತಿ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ \"ಮಾರಾ ಕ್ಹಾತೆ ಖಾದಲವಾಲೊ ಮನೆ ಮೊಸ ಕರ‍್ಯೊ \"ಕವಾನಿ ಎ ಪವಿತ್ರ ಗ್ರಂಥಮಾನಿ ವಾತ ಪುರಾ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ತೆ ಪುರಾ ಥಾತಾಮಾ ಮಿಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ತುಮೆ ಬರೊಕ್ಹೊ ಕರು ಕೈನ, ತೆ ಪುರಾ ಥಾವಾತಿ ಪೈಲಾಜ ಎ ತುಮೊನೆ ಕವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ಮಿ ಮೊಕ್ಲಲ ಕಿನೆಬಿ ವಪ್ಪಿಲಿವಾಲೊ ತೆ ಮನೆ ವಪ್ಪಿಲಿವಾಲೊ ಥಯೊಸ. ಮನೆ ವಪ್ಪಿಲಿದಲವಾಲೊ ಮನೆ ಮೊಕ್ಲಲವಾಲಾನೆ ವಪ್ಪಿಲಿದವಾಲೊ ಥಯೊಸ\" ");
INSERT INTO sle_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ಯೆಸು ಎ ಸಂಗತಿಯೊ ಕದಲ್ಪರ ಮನಸ್ಮಾ ದುಖ ಥೈನ\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ ತುಮೊಮಾನೊ ಯಕ್ಲೊ ಮೊಸ ಕರಾನೆ ಚಾಲ್ಯೊಸ\" ಕೈನ ಖುಲ್ಲಾಜ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ಯೆಸುನಾ ಶಿಷ್ಯಾ ಕ್ಹಾರಾ ಯಕ್ಲಾನೆ ಯಕ್ಲೊ ದೆಕಾನು ಚಾಲು ಕರ‍್ಯಾ. ತೆ ಕಿನಾ ಹುತಿ ಕವಾಡ್ಯೊಸ ಕವಾನು ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ಶಿಷ್ಯಾವೊಮಾನೊ ಯಕ್ಲೊ ಯೆಸುನಾ ಬಾಜು಼ಮಾ ವ್ಹತ್ತೊ. ತಿನೆ ಯೆಸು ಘನ್ನೊ ಮಯಾ ಕರ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ಸಿಮೊನ ಪೆತ್ರಾ ಎ ಶಿಷ್ಯಾನೆ \"ಕಿನಾ ಹುತಿ ಕವಾಡ್ಯೊಸ ಕೈನ ಪುಚ್ಚಿನ ತಿಳ್ದಿಲಿವಾನೆ ಇಶಾರೊ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ತೆ ಶಿಷ್ಯೊ ಯೆಸುನಾ ಬಗಲ ಡ್ವಗ್ಗಿನ\"ಪ್ರಭು, ತೆ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ಯೆಸು\"ಮಿ ಎ ರೊಕ್ಲೊ ಥಾಳಾಮಾ ಡುಬೈನ ಕಿನೆ ದ್ಯುಸ ತೆಜ಼ ಮನೆ ಮೊಸ ಕರಸ ಕೈನ ರೊಕ್ಲಾನೊ ತುಕ್ಡೊ ಲಿನ ತೆ ಥಾಳಾಮಾ ಡುಬೈನ ಇಸ್ಕರಿಯೊತ ಸಿಮೊನನೊ ದಿಕ್ರೊ ಥಯಲ ಯುದನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ಯುದ ತೆ ರೊಕ್ಲಾನೊ ತುಕ್ಡೊ ಲೆತಾಮಾಜ಼ ಸೈತಾನ ತಿನಾಮಾ ವ್ಹಕ್ಯೊ. ಯೆಸು ಯುದನೆ\"ತು ಸು ಕರಾನು ಛೆ ತೆ ಭೆಗಿನ ಕರ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ತೆನೈಸೊ ಯೆಸು ಯುದನೆ ತೆ ಇಮ್ಮ ಕಾ ಕದ್ಯೊ ಕೈನ ಖಾವಾನೆ ಬೈಟಲವಾಲವೊಮಾನಾ ಕಿನೆ ಕಳ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ಶಿಷ್ಯಾನಿ ಸಮುದಾಯನಿ ದೊಕ್ಡಾನಿ ಪಿಶಿನಿ ಜವಾಬ್ದಾರಿ ಯುದನಾ ಹತ್ಮಾ ವ್ಹತ್ತಿ. ತಿನಾಹುತಿ ಸನ್ನನೆ ಚಾ಼ಯೆ ಥಯಲ ದಕ್ಹಾ ಸಾಮನೊ ಲಿನ ಆವಾನಾ ಹುತಿ ಗರಿಬ ಮನಕ್ಹೊನೆ ದಿವಾನಾ ಹುತಿ ಯೆಸು ತಿನೆ ಕದ್ಯೊ ವಸೆ ಕೈನ ದಕ್ಹಾ ಶಿಷ್ಯಾ ತಿಳದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ಯೆಸು ದಿದಲ ರೊಕ್ಲೊ ಲಿದಲ ಬರೊಬ್ಬರ ಯುದ ತ್ಯಾಂತೊ ಗೈಪಡ್ಯೊ. ತೆಳಾಮಾ ರಾತ ಥೈ ಗೈತಿ. ");
INSERT INTO sle_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ಯುದ ಗಯಲ್ಪರ ಯೆಸು\"ಹಮ್ನಾ ಮನಕ್ಹನಾ ದಿಕ್ರಾನೆ ಮಹಿಮಾ ಥೈ. ವರಿ ತಿನಾ ಮುಲಕ ಕ್ಹುದಾನೆ ಮಹಿಮಾ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ಯಕ್ಕೆಳೆ ತಿನಾ ಮುಲಕ ಕ್ಹುದಾನಿ ಮಹಿಮಾನಾ ಹುತಿ ಥಾವಾನಿ ರ‍್ಹಯುಮ ಕ್ಹುದಾ ತಿನಾಮಾಜ಼ ದಿಕ್ರಾನೆ ಮಹಿಮಾ ಕರಸ. ವರಿ ತೆ ತೆಕ್ಲಾಮಾಜ಼ ತಿನೆ ಮಹಿಮಾ ಕರಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ಯೆಸು \"ಮಾರಾ ದಿಕ್ರಾವೊ, ಹಜು಼ನ ದಕ್ಹೊ ಟೈಮ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌಸ. ತುಮೆ ಮನೆ ಹುಡ್ಕೊಶಿ. ವರಿ ಮಿ ಯಹುದಿಯೊನೆ ಕದಲಜ಼ ತುಮೊನೆ ಕೌಸ. ಮಿ ಕಿಜಾ಼ ಚಾಲ್ಯೊಸ ತುಮೊನೆ ತ್ಯಾ ಆವಾನೆ ಥಾತು\" ");
INSERT INTO sle_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ಮಿ ತುಮೊನೆ ಯಕ್ಕ ನಯಿ ಆಗನ್ಯಾ ದ್ಯುಸ\" ತುಮೆ ಯಕ್ಕನೆ ಯಕ್ಕ ಮಯಾ ಕರೊ. ಮಿ ತುಮೊನೆ ಕಿಮ್ಮ ಮಯಾ ಕರು ತುಮೆಬಿ ತಿನಾ ಲಿಂಗತ ಮಯಾ ಕರುಜ. ");
INSERT INTO sle_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ಯಕ್ಕೆಳೆ ತುಮೆ ಯಕ್ನಾ ಯಕ್ಕ ಮಯಾ ಕರ‍್ಯಾಮ, ತುಮೆ ಮಾರಾ ಶಿಷ್ಯಾ ವ್ಹೈ ಕವಾನು ಕ್ಹಾರಾವೊನೆ ಗ್ವತ್ತ ಥಾವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ಸಿಮೊನ ಪೆತ್ರಾ ಯೆಸುನೆ \"ಪ್ರಭು, ತು ಕಿಜಾ಼ ಚಾಲ್ಯೊಸ? ಕೈನ ಪುಚ್ಯೊ. ಯೆಸು \"ಮಿ ಜಾ಼ವಾನಿ ಜ಼ಗಾ ಹಮ್ನಾ ತು ಮಾರಾ ಪಾಚ಼ೊ ನೈ ಆಸಕ್ತೊ. ತೆನೈಸೊ ತು ಅಗೊ ಮಾರಾ ಪಾಚೊ಼ ಆಶಿ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ಪೆತ್ರಾ\"ಪ್ರಭು, ಹಮ್ನಾ ಮಿ ತಾರಾ ಪಾಚೊ಼ ಆವಾನೆ ಕಾ ನೈ ಥಾತು? ಮಿ ತಾರಾ ಹುತಿ ಮರಾನೆಬಿ ತಯ್ಯಾರ ಛೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ಯೆಸು\"ತು ಮಾರಾಹುತಿ ಕ್ಹರಿಮಾಜ಼ ಮರಾನೆ ತಯ್ಯಾರ ಛೆ ಸು? ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ಕುಕ್ಡೊ ಬಾಂಗ ದಿವಾತಿ ಪೈಲಾಜ ತು ತನ್ನ ಸಲಾ ಮಾರಾ ಹುತಿ ಮಿ ತುನೆ ವಳಕ ನತ್ತಿ ಕೈನ ಕಶಿ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ಯೆಸು ತ್ಯುನೊನೆ \"ತುಮಾರು ಮನಸ ಕಳವಳ ಕರಿಲಿವೊ ನಕೊ. ಕ್ಹುದಾ ಪರ ವರಿ ಮಪರಬಿ ಬರೊಕ್ಹೊ ಮ್ಹೆಲೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ಮಾರಾ ಬಾನಾ ಘರಮಾ ಘನ್ನಾ ಖೊಲಿಯೊ ಛೆ. ತೆ ನೈ ರ‍್ಹಯಲ ರ‍್ಹವತ್ತೊ, ಮಿ ಗೈನ ತ್ಯಾ ಜ಼ಗಾ ತಯ್ಯಾರ ಕರುಸ ಕೈನ ಕತೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ಮಿ ಗೈನ ತುಮಾರಾ ಹುತಿ ಜ಼ಗಾ ತಯ್ಯಾರ ಕರಲ್ಪರ ವರಿ ಐನ ತುಮೊನೆ ಮಾರಾ ಕ್ಹಾತೆ ಬಲೈಲಿನ ಜೌ಼ಸ. ಇಮ್ಮ ಮಿ ರ‍್ಹಯಲ ಜ಼ಗಾ ತುಮೆ ರ‍್ಹವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ಮಿ ಜಾ಼ವಾನಿ ಜ಼ಗಾ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ತೊಮ ಯೆಸುನೆ\"ಪ್ರಭು, ತು ಜಾ಼ವಾನು ಕಿಜಾ಼ ವ್ಹೈ ಕೈನ ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತೆ ವಾಟ ಹಮೆ ಕಿಮ್ಮ ತಿಳ್ದಿಲಿವಾನೆ ಥಾವಸ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ಯೆಸು \"ಮಿಜ಼ ವಾಟ ವರಿ ಕ್ಹರಿ ವರಿ ಜ಼ಲಮ ಥಯೊಸ. ಕಿನೆಬಿ ಮಾರಾ ಮುಲಕ ನೈಸೊ ಬಿಜಾ಼ ಕಿನಾಜ ಮುಲಕ ಬಾಕನ ಆವಾನೆ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ಯಕ್ಕೆಳೆ ತುಮೆ ಮನೆ ಕ್ಹರಿಬಿ ತಿಳ್ದಿಲಿದಲ ರ‍್ಹಯಮ, ಮಾರಾ ಬಾನೆಬಿ ಚೊ಼ಕಿ ತರಾ ತಿಳ್ದಿಲೆತಾತಾ. ತೆನೈಸೊ ಹಮ್ನಾತಾ ತುಮೆ ಬಾನೆ ತಿಳ್ದಿಲಿದ್ಯಾಸ ವರಿ ದೆಕ್ಯಾಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ಫಿಲಿಪ್ಪ ಯೆಸುನೆ \"ಪ್ರಭು, ಹಮೊನೆ ಬಾನೆ ದೆಕಾಡ ತೆಕ್ಲುಜ಼ ಬಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ಯೆಸು \"ಫಿಲಿಪ್ಪ ಮಿ ಅಕ್ಲಾ ಟೈಮತೊ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೈತಬಿ ತು ಮನೆ ತಿಳ್ದಿಲಿದ್ಯೊ ನತ್ತಿ ಸು? ಮನೆ ದೆಕಲವಾಲೊ ಬಾನೆಬಿ ದೆಕಲವಾಲೊ ವ್ಹೈ. ತಿನಾಹುತಿ \"ಬಾನೆ ಹಮೊನೆ ದೆಕಾಡ, ಕೈನ ಕಾ ಪುಚ್ಚಾಡಾಸ? ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ಮಿ ಬಾ ಮಾ ಛೆ ವರಿ ಬಾ ಮಾರಾಮಾ ಛೆ ಕೈನ ತುಮೆ ಕ್ಹರಿಬಿ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ತಾ ಸು? ಮಿ ತುಮೊನೆ ಕವಾನಿ ಸಂಗತಿಯೊ ಮಾರಾಕ್ಹು ಆಯಲ ನ್ಹವೈ. ತೆನೈಸೊ ತೆ ಮಾರಾಮಾ ರ‍್ಹವಾನಾ ಬಾನಾ ವ್ಹೈ ವರಿ ತೆ ತಿನು ಕಾಮ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ಮಿ ಬಾಮಾ ಛೆ ವರಿ ಬಾ ಮಾರಾಮಾ ಛೆ ಕವಾನಿ ಮಾರಿ ವಾತ ಪರ ಬರೊಕ್ಹೊ ಕರೊ. ತೆನೈಸೊ ಮಿ ಕರಲ ಅದ್ಭುತ ಕಾಮೊಕ್ಹು ತಬಿ ಮಪರ ಬರೊಕ್ಹೊ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","\"ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಮಿ ಕರಲಜ ಕಾಮೊ ಕರಸ. ತೆ ಮಿ ಕರಾನಾ ಕಾಮೊತಿಬಿ ಮ್ಹೊಟಾ ಕಾಮೊ ಕರಸ. ಕಾಕದ್ಯಾಮ ಮಿ ಬಾ ಕನ ಚಾ಼ಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ವರಿ ತುಮೆ ಮಾರಾ ನಾಮ ಪರ ಸುತಬಿ ಮಾಂಗಿಲಿದ್ಯಾರೆ, ಮಿ ತುಮಾರಾ ಹುತಿ ತೆ ಕರುಸ. ತಿನಾಹುತಿ ದಿಕ್ರೊ ಬಾನೆ ಮಹಿಮಾ ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ತುಮೆ ಮಾರಾ ನಾಮ ಪರ ಸುತಬಿ ಮಾಂಗಿಲಿದ್ಯಾರೆ, ಮಿ ತೆ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","\"ಯಕ್ಕೆಳೆ ತುಮೆ ಮನೆ ಮಯಾ ಕರಾಲಾ ಥಯಲ ರ‍್ಹಯಮ, ಮಾರಾ ಆಗನ್ಯಾನೆ ವಿಧೆಯ ಥೈನ ಚಾಲೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ಮಿ ಬಾನೆ ಮಾಂಗಿಲಿವಸ. ತೆಳಾಮಾ ತೆ ಬಿಜಾ಼ ಯಕ್ಲಾ ಸಹಾಯಕನೆ ತುಮೊನೆ ದಿವಸ. ತೆ ಸಹಾಯಕ ಹಮೆಶಾಬಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ಕ್ಹರಿನೊ ಆತ್ಮಾಜ಼಼ ತೆ ಸಹಾಯಕ ವ್ಹೈ. ಎ ದುನಿಯಾ ತಿನೆ ಸ್ವಿಕಾರ ನೈ ಕರತು. ಕಾಕದ್ಯಾಮ ದುನಿಯಾ ತಿನೆ ದೆಕ್ತಾ ನೈ, ತಿಳ್ದಿಲೆತಾಬಿ ನೈ. ತೆನೈಸೊ ತುಮೆ ತಿನೆ ತಿಳ್ದಿಲಿದ್ಯಾಸ. ತಿನಾಹುತಿ ತೆ ತುಮಾರಾ ಕ್ಹಾತೆ ಜಿವ್ನಾ ಕರಸ ವರಿ ತುಮಾರಾಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","\"ಮಿ ತುಮೊನೆ ಪರ್ದೆಶಿ ಲಿಂಗತ ಛೊಡಿನ ನೈ ಜಾತೊ. ಮಿ ತುಮೊಕನ ಔಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ಹಜು಼ನ ದಕ್ಹಿ ಯೆಳ ಥಯಲ್ಪರ ಎ ದುನಿಯಾ ಮನೆ ದೆಕ್ತಿ ನೈ. ತೆನೈಸೊ ತುನೆ ಮನೆ ದೆಕೊಶಿ. ಕಾಕದ್ಯಾಮ ಮಿ ಜಿವ್ತೊ ರ‍್ಹೌಸ ವರಿ ತುಮೆಬಿ ಜಿವ್ತಾ ರ‍್ಹವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ತೆ ದಿನ್ನೆ ತುಮೆ ಮಿ ಮಾರಾ ಬಾ ಮಾ ರ‍್ಹವಾನು, ತುಮೆ ಮಾರಾಮಾ ರ‍್ಹವಾನು ವರಿ ಮಿ ತುಮಾರಾಮಾ ರ‍್ಹವಾನು ತಿಳ್ದಿಲಿವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ಯಕ್ಲೊ ಮಾರಿ ಆಗನ್ಯಾವೊನೆ ಸ್ವಿಕಾರ ಕರಿನ ತಿನಾ ಲಿಂಗತ ಚಾಲ್ಯೊಮ, ತೆ ಮನೆ ಮಯಾ ಕರಾಲೊ ಥಯೊಸ. ಕುನ್ನ ಮನೆ ಮಯಾ ಕರಸ ತಿನೆ ಮಾರೊ ಬಾ ಬಿ ಮಯಾ ಕರಸ ವರಿ ಮಿ ತಿನೆ ಮಯಾ ಕರುಸ. ವರಿ ಮಿ ತಿನೆ ಮನೆಜ ದೆಕಾಡಿನ ದಿವ್ಸ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ತೆಳಾಮಾ ಯುದ ಎ ಇಸ್ಕರಿಯುತ ಯುದ ನ್ಹವೈ. ತೆನೈಸೊ \"ಪ್ರಭು, ತು ತುನೆ ಎ ದುನಿಯಾನೆ ನೈ ದೆಕಾಡ್ಯಾವಾಚಿ ಹಮೊನೆ ದೆಕಾಡುಸ ಕವಾನು ಶಾನೆ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ಯೆಸು ಅಮ್ಮ ಜವಾಬ ದಿದ್ಯೊ; ಮನೆ ಮಯಾ ಕರಾಲೊ ಮಾರಾ ಉಪದೆಶನೆ ವಿಧೆಯ ಥಾವಸ. ಮಾರೊ ಬಾ ತಿನೆ ಮಯಾ ಕರಸ. ಹಮೆ ಭಂಬಿ ಜ಼ನಾ ತಿಕನ ಐನ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ಕುನ್ನ ಮನೆ ನೈ ಮಯಾ ಕರ‍್ತೊ, ತೆ ಮಾರಿ ಉಪದೆಶನೆ ವಿಧೆಯ ನೈ ಥಾತೊ. ತುಮೆ ಐಕಾನಿ ಎ ಉಪದೆಶ ಮಾರಿ ನ್ಹವೈ, ಮನೆ ವಳಾಯಲ ಮಾರಾ ಬಾನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","\"ಹಜು಼ನ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹತಾಮಾಜ ಎ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ತುಮೊನೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ತೆನೈಸೊ ಬಾ ಮಾರಾ ನಾಮ ಪರ ವಳೈನ ದಿವಾನು ಪವಿತ್ರ ಆತ್ಮಾ ತುಮೊನೆ ಹರಿ ಯಕ್ಕಬಿ ಉಪದೆಶ ಕರಸ. ವರಿ ಮಿ ತುಮೊನೆ ಕದಲ ಕ್ಹಾರಾ ಸಂಗತಿಯೊ ತುಮೊನೆ ಶೆ ದಿಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","\"ಮಿ ಶಾಂತಿ ದಿವ್ಸ. ಮಾರಿ ಶಾಂತಿ ತುಮೊನೆ ದಿವ್ಸ. ಮಿ ಎ ದುನಿಯಾ ದಿದಲಲಿಂಗತ ತುಮೊನೆ ದೆತೊ ನೈ. ತಿನಾಹುತಿ ತುಮಾರು ಮನಸೊ ಕಳವಳ ಥೌ ನೈ ವರಿ ತುಮೆ ಭುಚ಼ಕೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ಮಿ ಜೌ಼ಸ. ತೆನೈಸೊ ತುಮೊಕನ ಫರಿನ ಔಸ \"ಕೈನ ಮಿ ತುಮೊನೆ ಕವಾನು ತುಮೆ ಐಕ್ಯಾಸ. ತುಮೆ ಮನೆ ಮಯಾ ಕರಾಲಾ ರ‍್ಹಯಮ, ಮಿ ಬಾಕನ ಜಾ಼ವಾಕ್ಹು ಖುಶಿ ಥಾತಾತಾ. ಕಾಕದ್ಯಾಮ ಬಾ ಮಾರಾತಿ ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ಎ ಥಾವಾತಿ ಪೈಲಾ ಮಿ ತುಮೊನೆ ಕದ್ಯೊಸ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಎ ಥಾತಾಮಾ ತುಮೆ ಬರೊಕ್ಹೊ ಕರೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","\"ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ಹಜು಼ನ ಘನಿಯೆಳ ಬೊಲ್ತೊ ನೈ. ಎ ದುನಿಯಾನೊ ಅದಿಪತಿ ಆವಾಡ್ಯೊಸ. ತಿನೆ ಮಾರಾ ಉಪ್ಪರ ಕಯುಜ಼ ಅದಿಕಾರ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ತೆನೈಸೊ ಮಿ ಬಾನೆ ಮಯಾ ಕರುಸ ವರಿ ಮಿ ಮಾರೊ ಬಾ ಆಗನ್ಯಾ ಕರಲ ತಿಮ್ಮಜ ಕರಾಡ್ಯೊಸ ಕೈನ ದುನಿಯಾ ತಿಳ್ದಿಲ್ಯುಜ \"ಆವೊ ಅಪೆ ನ್ಹ್ಯಾಂತಾ ಗಯ್ಯೆ\" ");
INSERT INTO sle_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ಮಿ ಕ್ಹರಿನು ದ್ರಾಕ್ಷಿಯೊನಿ ಬಳ್ಳಿ ವ್ಹೈ. ವರಿ ಮಾರೊ ಬಾ ಖೆತರವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ಮಕನ ರ‍್ಹಯಲ ಫಲ ನೈ ದಿವಾನು ಹರಯಕ್ಕ ಜಡನೆ ತೆ ಕತ್ರಿನ ನಾಕಸ. ಫಲ ದಿವಾನು ಠೊಂಗಿ ಹಜು಼ನ ಹೆಚ್ಕಿ ಫಲಾ ದಿಯೆ ಲಿಂಗತ ತಿನೆ ಶುದ್ಧ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ಮಿ ತುಮೊನೆ ಕದಲ ಉಪದೆಶ ಕ್ಹು ತುಮೆ ಹಮ್ನಾಜ ಶುದ್ಧ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ತುಮೆ ಮಾರಾಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹವೊ, ತೆಳಾಮಾ ಮಿ ತುಮೊಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹೌಸ. ಕಯು ಠೊಂಗಿ ತಿನಾಕ್ಹು ತೆ ಫಲ ನೈ ದೆತು. ತೆ ದ್ರಾಕ್ಷಿಯೊನಿ ಬಳ್ಳಿಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹೌ. ತೆ ತುಮೊನೆಬಿ ಲಾಗು ಥಾವಸ. ತುಮಾರಾಕ್ಹು ತುಮೆ ಫಲ ನೈ ದೆಸಕ್ತಾ. ತುಮೆ ಮಾರಾಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","\"ಮಿಜ಼ ದ್ರಾಕ್ಷಿಯೊನಿ ಬಳ್ಳಿ ವ್ಹೈ ತುಮೆ ಠೊಂಗಿಯೊ ವ್ಹೈ. ಯಕ್ಲೊ ಮಾರಾಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹಯೊಮ ವರಿ ಮಿ ತಿನಾಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹಯೊಮ, ತೆಳಾಮಾ ತೆ ಘನ್ನು ಫಲ ದಿವಸ. ತೆನೈಸೊ ತೆ ಮನೆ ಛೊಡಿನ ಸುಜ಼ ನೈ ಕರಸಕ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ಮಾರಾಮಾ ರ‍್ಹಯಲವಾಲೊ ವರಾಯಲ ಠೊಂಗಿ ಲಿಂಗತ ರ‍್ಹವಸ. ತಿನೆ ಜಮಾ ಕರಿನ ಆಗಮಾ ಘಾಲಸ. ತೆ ಆಗಮಾ ಪಡಿನ ಮರಿ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ತುಮೆ ಮಾರಾಮಾ ಮಾರಿ ವಾಕ್ಯಾ ತು ಮಾರಾಮಾ ರ‍್ಹಯುಮ ಸು ಚಾ಼ಯೆ ತೆ ಮಾಂಗಿಲಿವೊ, ತೆ ತುಮೊನೆ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ತುಮೆ ಘನ್ನು ಫಲ ದಿನ್ನ, ಮಾರಾ ಬಾನಿ ಮಹಿಮಾ ದೆಕಾಡೊ. ಇನಾಹುತಿ ತುಮೆ ಮಾರಾ ಶಿಷ್ಯಾ ಥಾವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","\"ಕಿಮ್ಮ ಬಾ ಮನೆ ಮಯಾ ಕರಸ ತಿಮ್ಮಜ ಮಿ ತುಮೊನೆ ಮಯಾ ಕರುಸ. ಮಾರಿ ಮಯಾಮಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ಯಕ್ಕೆಳೆ ತುಮೆ ಮಾರಿ ಆಗನ್ಯಾವೊನೆ ವಿಧೆಯ ಥಯಾಮ, ತುಮೆ ಮಾರಿ ಮಯಾಮಾ ಮ್ಹೈ ಥೈನ ರ‍್ಹವೊಶಿ. ಮಿ ಮಾರಾ ಬಾನಾ ಆಗನ್ಯಾನೆ ವಿಧೆಯ ಥೌಸ ವರಿ ತಿನಿ ಮಯಾಮಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ಮನೆ ರ‍್ಹವಾನಿ ಖುಶಿ ತುಮೆ ವ್ಹಂದಿಲಿವ ಕೈನ ಮಿ ತುಮೊನೆ ಎ ಸಂಗತಿಯೊ ಕದ್ಯೊಸ. ತುಮಾರಿ ಖುಶಿ ಪರಿಪುರ್ಣ ಖುಶಿ ಥೈನ ರ‍್ಹೌ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ಮಿ ತುಮೊನೆ ಮಯಾ ಕರಲ ಲಿಂಗತ ತುಮೆ ಯಕ್ಕನೆ ಯಕ್ಕ ಮಯಾ ಕರು ಕವಾನು ಮಿ ತುಮೊನೆ ದಿವಾನಿ ಆಗನ್ಯಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ದೊಸ್ತೊನಾ ಹುತಿ ತಿನು ಸ್ವಂತ ಜ಼ಲಮ ದಿವಾನಾ ಮಯಾತಿಬಿ ಬಿಜಿ ಮಯಾ ಕೈಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ಮಿ ದಿದಲ ಆಗನ್ಯಾ ಲಿಂಗತ ಚಾ಼ಲ್ಯಾಮ, ತುಮೆ ಮಾರಾ ದೊಸ್ತೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ಹಮ್ನಾತೊ ಮಿ ತುಮೊನೆ ಮಾರಾ ಸೆವಕೊ ಕೈನ ಬಲಾತೊ ನೈ. ಕಾಕದ್ಯಾಮ ಮಾಲಕನಾ ಕಾಮೊ ಸೆವಕನೆ ಗ್ವತ್ತ ನೈ ರ‍್ಹತಾ. ತೆನೈಸೊ ಹಮ್ನಾ ಮಿ ತುಮೊನೆ ಮಾರಾ ದೊಸ್ತೊ ಕೈನ ಬಲೌಸ. ಕಾಕದ್ಯಾಮ ಮಾರಾ ಬಾ ಕಂತು ಐಕಲ ಹರಯಕ್ಕ ಮಿ ತುಮೊನೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","\"ತುಮೆ ಮನೆ ಇನಿಲಿದ್ಯಾ ನತ್ತಿ; ಮಿ ತುಮೊನೆ ಇನಿಲಿದ್ಯೊಸ. ತುಮೆ ಗೈನ ಘನ್ನು ಫಲ ದ್ಯು. ಎಜ಼ ಮಿ ತುಮೊನೆ ದಿದಲ ಕಾಮ ವ್ಹೈ. ತೆ ಕೆಳಾಮಾಬಿ ರ‍್ಹವಾನು ಫಲ ವ್ಹೈ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ತುಮೆ ಮಾರಾ ನಾಮ ಪರ ಸುಬಿ ಪುಚ್ಯಾ ತಬಿ ಬಾ ತೆ ತುಮೊನೆ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ತುಮೆ ಯಕ್ನೆ ಯಕ್ಕ ಮಯಾ ಕರು ಕವಾನುಜ ಮಾರಿ ಆಗನ್ಯಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"ಎ ದುನಿಯಾ ತುಮೊನೆ ದ್ವೆಶ ಕರ‍್ಯಾಮ, ತೆ ಪೈಲಾ ಮನೆ ದ್ವೆಶ ಕರಲ ಶೆ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ತುಮೆ ಎ ದುನಿಯಾನೆ ಮಳಲವಾಲಾ ರ‍್ಹಯುಮ, ಎ ದುನಿಯಾ ತಿನಾ ಸ್ವಂತ ಮನಕ್ಹೊನೆ ಮಯಾ ಕರಲ ಲಿಂಗತ ತುಮೊನೆ ಮಯಾ ಕರಸ. ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಎ ದುನಿಯಾತೊ ಇನಿಲಿದ್ಯೊಸ. ತಿನಾಹುತಿ ತುಮೆ ಎ ದುನಿಯಾನೆ ಮಳಲವಾಲಾ ನ್ಹವೈ. ತಿನಾಹುತಿ ಎ ದುನಿಯಾ ತುಮೊನೆ ದ್ವೆಶ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","\"ಸೆವಕ ತಿನಾ ಮಾಲಕತಿ ಮ್ಹೊಟೊ ನ್ಹವೈ \"ಕೈನ ಮಿ ತುಮೊನೆ ಕದಲ ವಾತ ಶೆ ಕರಿಲಿವೊ. ಮನಕ್ಹೊ ಮನೆ ತ್ರಾಸ ಕರಲ ಲಿಂಗತ ತುಮೊನೆ ತ್ರಾಸ ಕರಸ ವರಿ ಮಾರಿ ಉಪದೆಶನೆ ವಿಧೆಯ ಥಯಾಮ ತುಮಾರಾ ಉಪದೆಶನೆ ವಿಧೆಯ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ಮನಕ್ಹೊ ಮಾರಾ ರ‍್ಹಯಲ ಹುತಿ ಎ ಕ್ಹಾರು ತುಮೊನೆ ಕರಸ. ಮನೆ ವಳಾಯಲವಾನೆ ತ್ಯುನೆ ತಿಳ್ದಿಲಿದ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ಮಿ ಐನ ಎ ದುನಿಯಾನಾ ಮನಕ್ಹೊನೆ ನೈ ಬೊಲ್ಯಲ ರ‍್ಹವತ್ತೊ, ತ್ಯುನೊನೆ ತ್ಯುನೆ ಕಯಾಜ಼ ಪಾಪ ಕರಲವಾಲಾ ವ್ಹೈ ಕೈನ ಕವಾನೆ ಥಾತು ನ್ಹೊತು. ತೆನೈಸೊ ಮಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊಸ. ತಿನಾಹುತಿ ಹಮ್ನಾ ತ್ಯುನಾ ಪಾಪೊನೆ ತ್ಯುನೊನೆ ಕಯು ಅರು ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","\"ಮನೆ ದ್ವೆಶ ಕರಾಲೊ ಮಾರಾ ಬಾನೆ ದ್ವೆಶ ಕರಾಲೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ಯಕ್ಕೆಳೆ ಮಿ ತ್ಯುನಾ ವಚ್ಮಾ ತೆ ಕಾಮೊ ನೈ ಕರತೊ ವರಿ ತೆ ಕಾಮೊ ಕುನ್ನಜ಼ ನೈ ಕರಲ ರ‍್ಹವತ್ತೊ, ತ್ಯುನೆ ಪಾಪ ಕರಲವಾಲಾ ಥಾತಾ ನ್ಹೊತಾ. ಹಮ್ನಾ ತ್ಯುನೆ ಎ ದೆಕ್ಯಾಸ ರ‍್ಹೈತುಬಿ ತ್ಯುನೆ ಮನೆ ವರಿ ಮಾರಾ ಬಾನೆ ದ್ವೆಶ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","\"ತ್ಯುನೆ ಮನೆ ಕಾರಣ ನೈಸೊ ದ್ವೆಶ ಕರ‍್ಯಾ \"ಕೈನ ತ್ಯುನಾ ಧರಮಶಾಸ್ತ್ರಮಾ ಬರ್ದಲ ವಾತ ಕ್ಹರಿ ಥೌ ಕೈನ ಇಮ್ಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","\"ಯಕ್ಕ ಸಹಾಯಕ ಆವಸ. ತೆ ಪವಿತ್ರ ಆತ್ಮಾ ವ್ಹೈ. ವರಿ ಕ್ಹುದಾನಿ ಕ್ಹರಿನೆ ದೆಕಾಡಿನ ದಿವಸ ವರಿ ತೆ ಬಾ ಕಂತೊ ಆವಸ. ಮಿ ತಿನೆ ಕ್ಹುದಾ ಕಂತೊ ವಳೌಸ ವರಿ ತೆ ಮಾರಾ ಹುತಿ ಸಾಕ್ಷಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ವರಿ ತುಮೆಬಿ ಮಾರಾ ಸಾಕ್ಷಿ ದಿವೊಶಿ. ಕಾಕದ್ಯಾಮ ಪೈಲಾತಾಬಿ ತುಮೆ ಮಾರಾ ಕ್ಹಾತೆ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","\"ಮಿ ಎ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ತುಮೊನೆ ಕದ್ಯೊಸ. ಕಾಕದ್ಯಾಮ ತುಮೆ ಬರೊಕ್ಹೊ ಛೊಡು ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ತ್ಯುನೆ ತುಮೊನೆ ಸಭಾಮಂದಿರೊಮಾತಾ ಭಾರಾ ಘಾಲಸ. ವರಿ ಯಕ್ಕ ಟೈಮ ಆವಾಡೊಸ ತ್ಯುನೆ ತುಮೊನೆ ಮಾರಸ ವರಿ ತ್ಯುನೆ ಅಮ್ಮ ವಿಚಾರ ಕರಸ ತ್ಯುನೆ ಕ್ಹುದಾನಿ ಸೆವಾ ಕರ‍್ಯಾಸ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ಮನಕ್ಹೊ ಬಾನೆ ವರಿ ಮನೆ ನೈ ತಿಳ್ದಿಲಿದಲ ಹುತಿ ಎ ಕ್ಹಾರು ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ತೆನೈಸೊ ಹಮ್ನಾ ಮಿ ತುಮೊನೆ ಎ ಕ್ಹಾರಾ ಸಂಗತಿ ಕದ್ಯೊಸ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಎ ಕ್ಹಾರಾ ಸಂಗತಿಯೊ ಪುರಾ ಥಾವಾನೊ ಟೈಮ ಆಯಲ ಪರ ತೆಳಾಮಾ ತ್ಯುನಾ ಹುತಿ ತುಮೊನೆ ಪೈಲಾಜ ಕದಲ ಶೆ ಮ್ಹೆಲೊ\" ಮಿ ಎ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ತುಮೊನೆ ಪೈಲಾತೊ ತಿಳ್ಸಾಯೊ ನೈ. ಕಾಕದ್ಯಾಮ, ತೆಳಾಮಾ ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ಹಮ್ನಾ ತುಬಿ, ಮನೆ ವಳಾಯಲವಾಲಾ ಕನ ಮಿ ಚಾಲ್ಯೊಸ. ತೆನೈಸೊ ತುಮೊಮಾ ಯಕ್ಲೊ ತುಬಿ\"ತು ಕಿಜಾ಼ ಚಾಲ್ಯೊಸ? ಕೈನ ಮನೆ ಪುಚ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ಮಿ ತುಮೊನೆ ಎ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ಕದಲ ಹುತಿ ತುಮಾರಾ ಮನಸೊ ದುಖಕ್ಹು ಭರಿ ಗಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ತೆನೈಸೊ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ಮಿ ಜಾ಼ವಾನು ತುಮಾರಾ ಚೊ಼ಕಾನಾ ಹುತಿಜ ವ್ಹೈ ಕಾಕದ್ಯಾಮ ಮಿ ಗೈನ ಸಹಾಯಕನೆ ತುಮೊಕನ ವಳೌಸ. ಮಿ ನೈ ಗಯೊಮ, ಸಹಾಯಕ ತುಮೊಕನ ನೈ ಆತೊ. ");
INSERT INTO sle_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","\"ತೆ ಕೆಳಾಮಾ ಆವಸ ಪಾಪ, ನಿತಿ, ನ್ಯಾಯನೊ ಫೈಸಲೊ ಎ ವಿಷಯನಾ ಹುತಿ ದುನಿಯಾನಿ ಶಕ್ಕ ದುರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ಮನೆ ನೈ ಬರೊಕ್ಹೊ ಕರಾಕ್ಹು ಮನಕ್ಹೊಮಾ ಪಾಪ ಛೆ ಕೈನ ತೆ ಸಹಾಯಕ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ಮಿ ಬಾಕನ ಜಾ಼ವಾನು ನಿತಿನಾ ಹುತಿ ತೆ ಮನಕ್ಹೊನೆ ದೆಕಾಡಿನ ದಿವಸ. ಇತ್ತಿ ಉಪ್ಪರ ಮನೆ ತುಮೆ ದೆಕ್ತಾ ನೈ ");
INSERT INTO sle_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ಕ್ಹರಿನಾ ಫೈಸಲಾನಾ ಹುತಿ ಕ್ಹರಿನೊ ತೆ ಸಹಾಯಕ ಎ ಜಗತ್ನೆ ದೆಕಾಡಿನ ದಿವಸ, ಕಾಕದ್ಯಾಮ ಎ ಜಗತ್ನಾ ಅದಿಪತಿನೆ ಫೈಸಲೊ ಥೈಗಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ಮಿ ತುಮೊನೆ ಕವಾನಿಯೊ ಸಂಗತಿಯೊ ಹಜು಼ನ ಘನಿಯೊ ಛೆ. ವರಿಬಿ ತೆ ಸಂಗತಿಯೊ ತುಮೆ ಸಹಿಸಿ ನೈ ಲೆತಾ. ");
INSERT INTO sle_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ವರಿ ತೆ ಸತ್ಯನಿ ಆತ್ಮಾ ಆತಾಮಾ, ತುಮೊನೆ ತೆ ಹರಿ ಯಕ್ಕ ಟೈಮ್ಮಾ ಕ್ಹರಿಕ್ಹು ಅಗೊ ಚ಼ಲಾವಸ. ಸತ್ಯನಿ ಆತ್ಮಾ ಬೊಲಾನು ತಿನು ನ್ಹವೈ. ತೆ ಐಕಲಜ ತೆ ಕವಸ. ಥಾವಾನಿಯೊ ಸಂಗತಿಯೊಜ ತುಮೊನೆ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ಕ್ಹರಿನಿ ಆತ್ಮಾ ಮಾರಿಯೊಜ ವಾತೊ ಐಕಿನ ತುಮೊನೆ ಕವಾನಾ ಮುಲಕ ಮನೆ ಮಹಿಮಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ಮಾರಾ ಬಾನೆ ರ‍್ಹಯಲ ಕ್ಹಾರುಜ ಮಾರು ವ್ಹೈ. ತಿನಾಹುತಿ, ಪವಿತ್ರ ಆತ್ಮಾ ಮಾರಿಯೊಜ ವಾತೊ ಐಕಿನ, ತುಮೊಕನ ಕವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ದಕ್ಹಿಯೆಳ ಥಯಲ್ಪರ ತುಮೆ ಮನೆ ದೆಕ್ತಾ ನೈ. ತೆ ಥಯಲ್ಪರ ದಕ್ಹು ಟೈಮ ಥಯಲ್ಪರ ತುಮೆ ಮನೆ ವರಿ ದೆಕೊಶಿ\" ");
INSERT INTO sle_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ಶಿಷ್ಯಾವೊನಾ ದಕ್ಹಾ ಜ಼ನಾ\"ದಕ್ಹಿಯೆಳ ಪರ ತುಮೆ ಮನೆ ನೈ ದೆಕ್ತಾ. ತೆನೈಸೊ ಪಾಚಾ಼ತಾ ದಕ್ಹು ಟೈಮ ಥಯಲ್ಪರ ಮನೆ ವರಿ ದೆಕೊಶಿ. ಕಾಕದ್ಯಾಮ ಮಿ ಬಾಕನ ಚಾಲ್ಯೊಸ \"ಕೈನ ತೆ ಕದಲನು ಮತ್ಲಬ ಸು ವ್ಹೈ? ಕೈನ ಯಕ್ನೆ ಯಕ್ಕ ಬೊಲಿ ಲಿವಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ಶಿಷ್ಯಾ\"ದಕ್ಹಿಯೆಳ ಕದ್ಯಾಮ ಸು ವ್ಹೈ? ತಿನಿ ವಾತ ಅಪೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಥಾವಾಡು\" ");
INSERT INTO sle_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ಶಿಷ್ಯಾ ಇನಾಹುತಿ ತಿನೆ ಪುಚ್ಚಸ ಕೈನ ಯೆಸುನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತಿನಾಹುತಿ ತೆ\"ದಕ್ಹಿಯೆಳ ಥಯಲ್ಪರ ತುಮೆ ಮನೆ ನೈ ದೆಕ್ತಾ. ತೆನೈಸೊ? ಪಾಚಾ಼ತಾ ದಕ್ಹು ಟೈಮ ಥಯಲ್ಪರ ಮನೆ ದೆಕೊಶಿ \"ಕೈನ ಮಿ ಕದಲನು ಮತ್ಲಬ ಸು ವ್ಹೈ ಕೈನ ತುಮೆ ಯಕ್ನೆ ಯಕ್ಕ ಪುಚ್ಚಾಡ್ಯಾಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ತುಮೆ ರವೊಶಿ, ಗೊಳಾಡೊಶಿ. ತೆನೈಸೊ ದುನಿಯಾ ಖುಶಿ ಥಾವಸ. ತುಮೆ ದುಖಿ ಥಾವೊಶಿ, ತೆನೈಸೊ ತುಮಾರು ದುಖ ಖುಶಿ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ಪೆಟೆ ರ‍್ಹಯಲ ಬಾಕ್ಡಿ ಜನ್ನಾನೊ ಟೈಮ ಆತಾಮಾ ತ್ರಾಸ ಖಾವಸ. ಬಚ್ಚು಼ ಹುಟ್ಟಲ ಪರ, ದುನಿಯಾಮಾ ಯಕ್ಕ ಬಚ್ಚು಼ ಹುಟ್ಯು ಕೈನ ಖುಶಿಕ್ಹು ತೆ ತಿನೆ ಥಯಲ ತ್ರಾಸ ಇಕ್ಹರಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ಎ ತುಮೊನೆಬಿ ಲಾಗು ಥಾವಸ. ಹಮ್ನಾ ತುಮೆ ದುಖಮಾ ಛೆ. ತೆನೈಸೊ ತುಮೆ ನೆ ವರಿ ದೆಕಲ್ಪರ ಖುಶಿ ಥಾವೊಶಿ. ತೆ ಖುಶಿನೆ ಕುನ್ನಜ ತುಮೊ ಕಂತು ನೈ ಕಾಳೆತು. ");
INSERT INTO sle_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ತೆ ದಿನೊಮಾ ತುಮೆ ಮನೆ ಸುಜ಼ ಪುಚತಾ ನೈ. ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ ಕೌಸ. ತುಮೆ ಮಾರಾ ನಾಮಪರ ಸು ಪುಚ್ಯಾ ತಬಿ ಬಾ ತುಮೊನೆ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ಹಜು಼ನ ಲಕ್ಕಾ ತುಮೆ ಮಾರಾ ನಾಮಪರ ಸು ಮಾಂಗಿಲಿದ್ಯಾ ನೈ, ಮಾಂಗೊ ವರಿ ತೆಳಾಮಾ ತುಮೊನೆ ಮಳಸ. ವರಿ ತುಮಾರಿ ಖುಶಿ ಪುರಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","\"ಮಿ ತುಮೊನೆ ಎ ಸಂಗತಿಯೊ ಕಾನಿಯೊನಾ ಮುಕಾಂತರ ಕದ್ಯೊ. ವರಿ ಟೈಮ ಆವಸ. ತೆಳಾಮಾ ಮಿ ಕಾನಿ ಕದ್ಯಾವಾಚಿ ಮಾರಾ ಬಾನಾ ಹುತಿ ಸಿದಾ ವಾತೊಮಾ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ತೆಳಾಮಾ ತುಮೆ ಮಾರಾ ನಾಮಪರ ಬಾಕನ ಮಾಂಗಿಲಿವೊಸಿ. ತೆಳಾಮಾ ಮಿ ತುಮಾರಾ ಹುತಿ ಬಾನೆ ಮಾಂಗಿಲಿವಾನು ಜರುರತ್ತಜ ರ‍್ಹತಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ಹೊ, ಬಾಜ ಕ್ಹುದ್ದ ತುಮೊನೆ ಮಯಾ ಕರಸ. ತುಮೆ ಮನೆ ಕಯಾ ಕರಲ ಹುತಿ ವರಿ ಮಿ ಕ್ಹುದಾ ಕಂತೊ ಆಯೊಸ ಕೈನ ತುಮೆ ಬರೊಕ್ಹೊ ಕರಲ ಹುತಿ ತೆ ತುಮೊನೆ ಮಯಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ಮಿ ಬಾಕಂತೊ ಎ ದುನಿಯಾಮಾ ಆಯೊ. ಹಮ್ನಾ ಮಿ ಎ ದುನಿಯಾ ಛೊಡಿನ ಬಾಕನ ವರಿ ಚಾಲ್ಯೊಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ತೆಳಾಮಾ ಶಿಷ್ಯಾ\"ಹಮ್ನಾ ತು ಮಾರಾ ಕ್ಹಾತೆ ಕರೆಟ್ಟ ಬೊಲಾಡೊಸ. ನೈ ಕಳಾನು ಕಠಿನ ವಾತೊ ತು ಉಪಯೊಗ ನತ್ತಿ ಕರಾಡ್ಯೊ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ತುನೆ ಕ್ಹಾರಿಯೊ ಸಂಗತಿಯೊ ಕಳಿಯೊಸ ಕೈನ ಹಮೊನೆ ಹಮ್ನಾ ಕಳಿಯೊ. ಯಕ್ಲೊ ಪ್ರಶ್ನೆ ಪುಚ್ಚಾತಿ ಪೈಲಾಜ ತು ತಿನಾ ಪ್ರಶ್ನೆನೆ ಜವಾಬ ದೆಶಿ. ಇನಾಹುತಿ, ತು ಕ್ಹುದಾಕಂತೊ ಆಯೊಸ ಕೈನ ಹಮೆ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ಯೆಸು ತ್ಯುನೊನೆ\"ಸು ತುಮೆ ಹಮ್ನಾ ಬರೊಕ್ಹೊ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ಮನೆ ಐಕೊ ತುಮೆ ಜುದಾ ಥಾವಾನೊ ಟೈಮ ಆಯೊಸ. ತುಮೊಮಾ ಹರಿ ಯಕ್ಲೊ ತಿನಾ ಸ್ವಂತ ಘರೆ ಜಾ಼ವಸ. ತುಮೆ ಮನೆ ಯಕ್ಲಾನೆಜ ಛೊಡಿನ ಜಾವೊಸಿ. ತೆನೈಸೊ ಕ್ಹರಿಮಾಜ಼ ಮಿ ಕೆಳಾಮಾಜ ಯಕ್ಲೊ ನತ್ತಿ. ಕಾಕದ್ಯಾಮ ಬಾ ಮಾರಾ ಕ್ಹಾತೆ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","\"ತುಮೊನೆ ಮಾರಾಮಾ ಶಾಂತಿ ಮಳಾದೆ ಕೈನ ಮಿ ತುಮೊನೆ ಎ ಕ್ಹಾರಿಯೊ ಸಂಗತಿಯೊ ಕದ್ಯೊಸ. ಎ ದುನಿಯಾಮಾ ತುಮೊನೆ ತ್ರಾಸ ದಿವಸ. ವರಿಬಿ ಧೈರ್ಯಕ್ಹು ರ‍್ಹವೊ! ಕಾಕದ್ಯಾಮ ಮಿ ಎ ದುನಿಯಾನೆ ಝಿತ್ಯೊಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ಎ ಕ್ಹಾರಾ ಸಂಗತಿಯೊ ಕದಲ್ಪರ ಯೆಸು ಸ್ವರ್ಗ ಬಗಲ ದೆಕಿನ ಅಮ್ಮ ಪ್ರಾಥನಾ ಕರ‍್ಯೊ; \"ಬಾ, ಟೈಮ ಆಯೊಸ. ತಾರಾ ದಿಕ್ರಾನೆ ಮಹಿಮಾ ಕರ. ತಿನಾಹುತಿ ತೆ ದಿಕ್ರೊ ತುನೆ ಮಹಿಮಾ ಕರಾದೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ಕಾ ದ್ಯಾಮ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪರ ತು ತಿನೆ ಅದಿಕಾರ ದಿದ್ಯೊಸ. ಅಮ್ಮ ತೆ ತು ತಿನೆ ದಿದಲ ಕ್ಹಾರಾವೊನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ಯಕ್ಲೊಜ ಕ್ಹರಿನೊ ಕ್ಹುದಾ ರ‍್ಹಯಲ ತುನೆ ವರಿ ತು ವಳಾಯಲ ಯೆಸು ಕ್ರಿಸ್ತನೆ ತಿಳ್ದಿಲಿವಾನುಜ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ತು ಮನೆ ದಿದಲ ಕಾಮ ಮಿ ಪುರಾ ಕರ‍್ಯೊ. ಮಿ ಜಿಮಿನ ಪರ ಮಹಿಮಾ ದೆಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ಹಮ್ನಾ, ಬಾ, ತು ತಾರಾ ಸನ್ನಿದಿಮಾ ಮಾರಿ ಮಹಿಮಾ ಕರ. ಎ ದುನಿಯಾ ಸೃಷ್ಟಿ ಥಾವಾತಿ ಪೈಲಾ ಮಿ ತಾರಾ ಕ್ಹಾತೆ ಹೊಂದಿಲಿದಲ ಮಹಿಮಾ ಮನೆ ದೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","\"ತು ಎ ದುನಿಯಾನಾ ಮನಕ್ಹೊನೆ ಮನೆ ದಿದ್ಯೊ ಮಿ ತ್ಯುನೊನೆ ತುನೆ ದೆಕಾಡಿನ ದಿದ್ಯೊ. ತ್ಯುನೆ ತಾರಾ ವ್ಹತ್ತಾ, ತೆನೈಸೊ ತು ತ್ಯುನೊನೆ ಮನೆ ದಿದ್ಯೊ ವರಿ ತ್ಯುನೆ ತಾರಿ ಆಗನ್ಯಾವೊನೆ ವಿಧೆಯ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ತು ಮನೆ ದಿದಲ ಹರಯಕ್ಕಬಿ ತಾರಾಕ್ಹು ಆಯುಸ ಕವಾನು ಇವ್ನೊನೆ ಹಮ್ನಾ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ತು ಮನೆ ದಿದಲ ಸಂದೆಶ ಮಿ ಇವ್ನೊನೆ ದಿದ್ಯೊಸ. ಇವ್ನೆ ತೆ ಸಂದೆಶ ಸ್ವಿಕಾರ ಕರಿಲಿದ್ಯಾಸ. ಮಿ ಕ್ಹರಿಬಿ ತುಕಂತೊ ಆಯೊಸ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಛೆ. ತುಜ಼಼ ಮನೆ ವಳಾಯಲ ವ್ಹೈ ಕೈನ ಇವ್ನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ಮಿ ಇವ್ನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರುಸ. ಎ ದುನಿಯಾಮಾ ರ‍್ಹವಾನಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಮಿ ಪ್ರಾಥನಾ ಕರಾಡೊ ನತ್ತಿ. ತೆನೈಸೊ ತು ಮನೆ ದಿದಲ ಇವ್ನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರಾಡ್ಯೊಸ. ಕಾಕದ್ಯಾಮ ಇವ್ನೆ ತಾರಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ಮಾರಾಮಾ ರ‍್ಹವಾನು ಕ್ಹಾರು ತಾರುಜ ವ್ಹೈ ವರಿ ತುಕನ ರ‍್ಹವಾನು ಕ್ಹಾರು ಮಾರುಜ ವ್ಹೈ. ಇನಾಹುತಿ ಮನೆ ಮಹಿಮಾ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","\"ಹಮ್ನಾ ಮಿ ತುಕನ ಆವಾಡ್ಯೊಸ. ಹಜು಼ನ ಮಿ ಎ ದುನಿಯಾಮಾ ರ‍್ಹತೊ ನೈ. ವರಿಬಿ ಇವ್ನೆ ಹುಜನ ಎ ದುನಿಯಾಮಾ ರ‍್ಹವಸ. ಪವಿತ್ರ ಥಯಲ ಬಾ, ತು ಮನೆ ತಾರಾ ನಾಮನಿ ತಾಕತಕ್ಹು ಇವ್ನೊನೆ ಕೈದಿನ ವಚಾಡ. ತೆ ನಾಮನೆ ಮಿ ಹಮೆಶಾ ಮ್ಹೆಲು. ತುಬಿ ಮಿ ಮಳಿನ ರ‍್ಹಯಲ ಲಿಂಗತ ಇವ್ನೆ ಯಕ್ಕ ಥೈನ ರ‍್ಹವಾನೆ ತೆಳಾಮಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ಮಿ ಇವ್ನಾ ಕ್ಹಾತೆ ರ‍್ಹತಾಮಾ ತಾರಾ ನಾಮನಿ ತಾಕತ ಕ್ಹು ಇವ್ನೊನೆ ಕೈದಿನ ವಚಾ಼ಡ್ಯೊ. ತೆ ನಾಮ ಮನೆ ತು ದಿದ್ಯೊತೊ. ಪವಿತ್ರ ಗ್ರಂಥಮಾ ರ‍್ಹಯಲ ಪುರಾ ಥಾವಾನಾ ಹುತಿ ಮಿ ತ್ಯುನೊನೆ ವಚಾಡು ವರಿ ತ್ಯುನೊಮಾನೊ ಯಕ್ಲೊಬಿ ಹಾಳ ಥಯೊ ನೈ. ವಿನಾಶನೊ ದಿಕ್ರೊ ಥಯಲವಾಲಾನೆ ಛೊಡಿನಜವೈ ಜಾ಼ವಾನೆ ಇನಿಲಿದಲ (ಯುದ ಕವಾಲೊ) ಯಕ್ಕಲೊಜ ಇವ್ನೊಮಾ ಹಾಳ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","\"ಹಮ್ನಾ ಮಿ ತುಕನ ಆವಾಡ್ಯೊಸ. ವರಿಬಿ ಮಿ ಎ ದುನಿಯಾಮಾ ರ‍್ಹತಾಮಾಜ ಎ ಸಂಗತಿಯೊನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರುಸ. ಎ ಮನಕ್ಹೊ ಮಾರಿ ಖುಶಿ ವ್ಹಂದಿಲ್ಯು ಕೈನ ವರಿ ಮಾರಿ ಖುಶಿ ಪುರಾ ರ‍್ಹೌ ಕೈನ ಎ ಸಂಗತಿಯೊ ಕವಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ಮಿ ಇವ್ನೊನೆ ತಾರಿ ವಾಕ್ಯಾ ದಿದ್ಯೊಸ. ಎ ದುನಿಯಾ ಇವ್ನೊನೆ ಶಿಟ್ಟ ಮ್ಹೆಲಸ. ಮಿ ಎ ದುನಿಯಾನೆ ಕೈ ತರಾ ಮಿ ನತ್ತಿ ಮಳ್ಯೊ. ತಿನಾ ಲಿಂಗತಜ ಇವ್ನೆ ಎ ಲೊಕನೆ ಮಳಲ ವಾಲಾ ನ್ಹವೈ. ತಿನಾಹುತಿ ಎ ದುನಿಯಾ ಇವ್ನೊನೆ ಶಿಟ್ಟ ಮ್ಹೆಲಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","\"ತು ಇವ್ನೊನೆ ಎ ದುನಿಯಾಮಾತೊ ಕಾಳ್ಯು ಕೈನ ಮಿ ಪುಚ್ಚಾಡೊ ನತ್ತಿ. ತೆನೈಸೊ ಇವ್ನೊನೆ ಕೆಟ್ಟಕ್ಹು ವಚ್ಚಾಡಿನ ಚೊ಼ಕಿ ಥರಾ ರ‍್ಹೌ ಕೈನ ಮಿ ಪ್ರಾಥನಾ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ಮಿ ಎ ದುನಿಯಾಮಾ ಕಿಮ ನತ್ತಿ ಮಳ್ಯೊ ತಿನಾ ಲಿಂಗತಜ ಇವ್ನೆ ಎ ದುನಿಯಾನಾ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","\"ತಾರಿ ಕ್ಹರಿನಾ ಮುಲಕ ತು ಇವ್ನೊನೆ ತಾರಿ ಸೆವೆನೆ ಸಮರ್ಪಣೆ ಕರಿ ಲೆ. ಕ್ಹರಿನಾ ಹುತಿ ತಾರಾ ವಾತೊ ಕ್ಹರಿಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ತು ಮನೆ ಎ ದುನಿಯಾಮಾ ವಳಾಯಲ ಲಿಂಗತ ಮಿ ಇವ್ನೊನೆ ಎ ದುನಿಯಾಮಾ ಮೊಕ್ಲೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ಇವ್ನೆ ಕ್ಹರಿಮಾಜ಼ ತಾರಿ ಸೆವೆನೆ ಒಪ್ಸಿನ ದಿವ್ ಕೈನ ಮನೆ ಮಿಜ಼ ತುನೆ ಒಪ್ಸಿನ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","\"ಮಾರಿ ಪ್ರಾಥನಾ ಇವ್ನಾ ಹುತಿ ಯಕ್ಕಜ಼ ನ್ಹವೈ ತೆನೈಸೊ ಇವ್ನಿಯೊ ವಾಕ್ಯಾಕ್ಹು ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ಬಾ, ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯಕ್ಕಜ಼ ಥೌ. ಕಿಮ್ಮ ತು ಮಾರಾಮಾ ಛೆ ವರಿ ಮಿ ತಾರಾ ಛೆ. ತ್ಯುನೆಬಿ ಅಪ್ನಾಮಾ ಯಕ್ಕ ಥಾವಾದೆ ತಿನಾಹುತಿ ದುನಿಯಾ ತುಜ಼಼ ಮನೆ ವಳಾಯೊಸ ಕೈನ ಬರೊಕ್ಹೊ ಕರಾದೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ತು ಮನೆ ದಿದಲ ಮಹಿಮಾ ಮಿ ಎ ಮನಕ್ಹೊನೆ ದಿದ್ಯೊಸ. ಇನಾಹುತಿ ತ್ಯುನೆ ಯಕ್ಕ ಥಾವಾವೆ ಕಿಮ್ಮ ತು ವರಿ ಮಿ ಯಕ್ಕ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ಮಿ ಇವ್ನೊಮಾ ರ‍್ಹೌಸ ವರಿ ತು ಮಾರಾಮಾ ಛೆ. ಇಮ್ಮ ತ್ಯುನೆ ಪುರಾಜ ಯಕ್ಕ ಥೈನ ರ‍್ಹವಸ. ತುಜ಼಼ ಮನೆ ಮೊಕ್ಲಲ ಹುತಿ ತು ಮನೆ ಮಯಾ ಕರಲ ಲಿಂಗತ ಎ ಮನಕ್ಹೊನೆಬಿ ಮಯಾ ಕರಶಿ ಕೈನ ಎ ದುನಿಯಾ ವಳಕಸ. ");
INSERT INTO sle_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","\"ಬಾ, ತು ಮನೆ ದಿದಲ ಇವ್ನೆ, ಮಿ ರ‍್ಹವಾನಿ ಕ್ಹಾರಿ ಜ಼ಗಾ ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹೌ ಕೈನ ವರಿ ಮಾರಿ ಮಹಿಮಾ ದೆಕು ಕೈನ ಆಸ ಕರುಸ. ಎ ದುನಿಯಾ ತಯ್ಯಾರ ಥಾವಾತಿ ಅಗ್ದುರಜ಼ ತು ಮನೆ ಮಯಾ ಕರಲ ಹುತಿ ತುಜ಼಼ ಎ ಮಹಿಮಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ನಿತಿ ಕ್ಹು ರ‍್ಹಯಲ ಬಾ, ಎ ದುನಿಯಾ ತುನೆ ವಳಕಿ ನತ್ತಿ ವರಿಬಿ ಮಿ ತುನೆ ವಳಕ್ಕಯೊಸ. ವರಿ ತುಜ಼಼ ಮನೆ ಮೊಕ್ಕಲ್ಯೊಸ ಕವಾನು ಎ ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ಮಿ ತಾರು ಕ್ಹರಿನು ರುಪ ಇವ್ನೊನೆ ವಳಕ ಲಗಾಡ್ಯೊಸ. ಮಿ ತಾರು ರುಪ ವರಿ ಇವ್ನೊನೆ ದೆಕಾಡುಸ. ತೆಳಾಮಾ ತಾರಿ ಮಯಾ ಮಪರ ಕಿಮ್ಮ ಛೆ, ತೆಜ಼ ಮಯಾ ಇವ್ನೊಮಾ ರ‍್ಹವಸ ವರಿ ಮಿ ಇವ್ನೊಮಾ ರ‍್ಹೌಸ\" ");
INSERT INTO sle_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ಯೆಸು ಪ್ರಾಥನಾ ಕರಲ ಪರ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಗಯೊ. ತ್ಯುನೆ ಕಿದ್ರೊನ ಕಣವಿ ದಾಟಿನ ಗಯಾ. ಯಕ್ಕ ಮಳಾಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ಯೆಸುನೆ ಮೊಸ ಕರಲ ಯುದನೆಬಿ ಎ ಜ಼ಗಾ ಗ್ವತ್ತ ವ್ಹತ್ತಿ. ಕಾಕದ್ಯಾಮ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ತೆಳಾಮಾ-ತೆಳಾಮಾ ಆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ಯುದ ಸೈನಿಕೊನು ಯಕ್ಕ ಗುಂಪ ಖಾಸ ಯಾಜಕ ವರಿ ಫರಿಸಾಯರೊನಾ ಕೈದಾಲಾ ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಬಲೈ ಲಿನ ಮಳೊ ಆಯೊ. ತ್ಯುನೆ ಬರಚಿಯೊ, ಅಯುದೊಕ್ಹು ತಯ್ಯಾರ ಥೈನ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ತಿನೆ ಥಾವಾನು ಹರಯಕ್ಕ ಯೆಸುನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತೆ ಅಗೊ ಗೈನ\"ತುಮೆ ಕಿನೆ ಹುಡಕಾಡಾಸ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ತ್ಯುನೆ ತಿನೆ \"ನಜರೆತನಾ ಯೆಸುನೆ\" ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ತೆ \"ತೆ ಮಿಜ಼ ವ್ಹೈ\" ಕದ್ಯೊ. ಯೆಸುನೆ ಮೊಸ ಕರಲ ಯುದ ತ್ಯಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ಹುಬ್ರಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ತೆ\"ತೆ ಮಿಜ಼ ವ್ಹೈ\" ಕದಲ ಪರ ತ್ಯುನೆ ಪಾಚಾ಼ ಸರಕಿನ ಜಿಮಿನ ಪರ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ಯೆಸು ತ್ಯುನೊನೆ ವರಿ \"ತುಮೆ ಕಿನೆ ಹುಡಕಾಡಾಸ? ಕೈನ ಪುಚ್ಚೊ. ತ್ಯುನೆ\"ನಜರೆತನಾ ಯೆಸುನೆ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ಯೆಸು, ತೆಳಾಮಾ ಕದಲ ತಿಮ್ಮ \"ತೆ ಮಿಜ಼ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಕದ್ಯೊಸ್ತೊ. ತುಮೆ ಮನೆ ಹುಡುಕತಾ ರ‍್ಹಯುಮ, ಉಗ್ರಲ ಇವ್ನೊನೆ ಜಾ಼ವಾನೆ ದಿವೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","\"ತು ಮನೆ ದಿದಲ ಮನಕ್ಹೊಮಾ ಮಿ ಜವೈಲಿದ್ಯೊ ನೈ\" ಕೈನ ಯೆಸು ಪೈಲಾಜ ಕದಲ ವಾತ ಅಮ್ಮ ಕ್ಹರಿ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ಸಿಮೊನ ಪೆತ್ರಾಕನ ಯಕ್ಕ ತಲ್ವಾರ ವ್ಹತ್ತು. ತೆ ತಿನಿ ತಲ್ವಾರ ಕಾಡಿನ ಖಾಸ ಯಾಜಕನಾ ಸೆವಕನೊ ತಿನೊ ಸಿದಾ ಬಗಲನೊ ಕಾನ ಕತ್ರಿ ಪಾಡ್ಯೊ. ತೆ ಸೆವಕನು ನಾಮ ಮಾಲ್ಕುಸ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ಯೆಸು ಪೆತ್ರಾನೆ\"ತಾರಿ ತಲ್ವಾರ ಮ್ಯಾನಮಾ ಘಾಲ! ಬಾ ಮನೆ ದಿದಲ ತ್ರಾಸನೊ ತಾಂಬ್ಯೊ ಮಿ ತೆ ಸ್ವಿಕಾರ ಕರು\" ತು ಇಮ್ಮ ಸೊಚತೊ ಸು? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ಪಾಚಾ಼ತಾ ತೆ ರೊಮನಾ ಸೈನಿಕೊ, ತ್ಯುನಾ ಸೆನಾದಿಪತಿ ವರಿ ಯಹುದಿಯೊನೆ ಕೈದಾಲಾ ಯೆಸುನೆ ಧರಿನ ಭಾಂದಿನ, ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ಅನ್ನಸಕನ ಲಾಯಾ. ತೆ ವರಕ್ಹ ಕಾಯಫ ಖಾಸ ಯಾಜಕ ವ್ಹತ್ತೊ. ಅನ್ನ ಕಾಯಫನೊ ಮಾಮೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಯಕ್ಲೊಜ ಮರಾನು ಚೊ಼ಕು ವ್ಹೈ ಕವಾನು ಯೆಹುದಿನಾ ಅದಿಕಾರಿಯೊನೆ ಸಲಹೆ ದಿದಲವಾಲೊ ಎಜ಼ ಕಾಯಫ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ಸಿಮೊನ ಪೆತ್ರಾ ವರಿ ಯೆಸುನಾ ಶಿಷ್ಯಾವೊನಾ ಬಿಜೆಕ್ಲೊ ಯೆಸುನಾ ಪಾಚಾ಼ ಗಯಾ. ತೆ ಬಿಜೆಕ್ಲಾ ಶಿಷ್ಯಾನೆ ಖಾಸ ಯಾಜಕನಿ ವಳಕ ವ್ಹತ್ತಿ. ತಿನಾಹುತಿ ತೆ ಖಾಸ ಯಾಜಕನಾ ಘರನಾ ಅಂಗಳ ಕನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ತೆನೈಸೊ ಪೆತ್ರಾ ಭಾರಲ್ಯಾ ಬಾಕಲನಾ ನಜಿ಼ಕ ಹುಬ್ರಯೊ. ಖಾಸ ಯಾಜಕನಿ ವಳಕ ರ‍್ಹಯಲ ವರಿ ಯಕ್ಕ ಶಿಷ್ಯೊ ಭಾರೊ ಐನ ದ್ವಾರನು ಬಾಕಲ ಕೈದಾಲಿ ಕನ ಐನ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಿನ ಪೆತ್ರಾನೆ ಮ್ಹೈ ಬಲೈಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ದ್ವಾರನು ಬಾಕಲ ಕೈದಾಲಿ ಪೆತ್ರಾನೆ\"ತೆ ಮನಕ್ಹನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಶಿಷ್ಯಾವೊಮಾನೊ ತುಬಿ ಯಕ್ಲೊ ನ್ಹವೈಸು? ಕೈನ ಪುಚ್ಚಿ. ಪೆತ್ರಾ\"ನ್ಹವೈ, ಮಿ ನ್ಹವೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ತೆಳಾಮಾ ಥಂಡ ರ‍್ಹಯಲ ಹುತಿ ಕೈದಾಲಾ ವರಿ ಸೆವಕೊ ಆಗ ಲಗಾಡಿನ ತಿನಾ ಸುತ್ತೆ ಹುಬ್ರೈನ ತ್ಯುನೆ ಶೆಕಿಲಿವಾಡ್ಯಾತಾ. ಪೆತ್ರಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ತ್ಯಾ ಗೈನ ಹುಬ್ರೈನ ಶೆಕಿಲಿವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ಖಾಸ ಯಾಜಕ ಯೆಸುನೆ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಹುತಿ ತೆ ಉಪದೆಶ ಕರಲ ಸಂಗತಿಯೊನಾ ಹುತಿ ಪ್ರಶ್ನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ತಿನಾ ಹುತಿ ಯೆಸು \"ಮಿ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊಸ\" ಹಮೆಶಾಬಿ ಸಬಾಮಂದಿರೊಮಾ ವರಿ ದೆವಾಲಯಮಾ ಬೊದನೆ ಕರ‍್ಯೊಸ. ಯಹುದ್ಯೊ ಕ್ಹಾರಾ ತ್ಯಾ ಮಳಿನ ಆತಾತಾ. ಮಿ ಕಯುಜ಼ ಝಾಕಿನ ಕದ್ಯೊ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ತು ಮನೆ ಪ್ರಶ್ನೆ ಪುಚ್ಚಾನು ಕಾ? ಮಾರು ಉಪದೆಶ ಐಕಲ ಮನಕ್ಹೊನೆ ಪುಚ್ಚೊ ಮಿ ಕದಲ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ಯೆಸು ಇಮ್ಮ ಕದಲ ಬರೊಬ್ಬರ, ತ್ಯಾ ಹುಬ್ರಯಲ ಕೈದಾಲಾವೊಮಾನೊ ಯಕ್ಲೊ ಯೆಸುನೆ ಛಕ್ಕಡ ಮಾರಿನ\"ತು ಖಾಸ ಯಾಜಕನಾ ಕ್ಹಾತೆ ತಿಮ್ಮ ಬೊಲಾನೆ ಕಕ್ಲಿ ಧೈರ್ಯ ಛೆ\" ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ಯೆಸು ತಿನೆ, ಯಕ್ಕೆಳೆ \"ಮಿ ತಪ್ಪ ಬೊಲ್ಯಲ ರ‍್ಹಯಮ ಮಿ ಕದಲ ತಪ್ಪ ವ್ಹೈ ಕೈನ ಕ್ಹಾರಾವೊನೆ ಕ್ಹಾಮೆ ಕೆ ಮಿ ಸು ತಪ್ಪ ಕದ್ಯೊ. ತೆನೈಸೊ ಮಿ ಕದಲ ಕರೆಟ್ಟ ಕದಲ ರ‍್ಹಯುಮ ತು ಮನೆ ಮಾರ‍್ಯೊ ಶಾನೆ? ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ತೆಳಾಮಾ ಅನ್ನಸ ಯೆಸುನೆ ಭಾಂದಿನ, ಖಾಸ ಯಾಜಕ ಥಯಲ ಕಾಯಫ ಕನ ವಳೈನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ಸಿಮೊನ ಪೆತ್ರಾ ತ್ಯಾಜ ಹುಬ್ರೈನ ಶೆಕಿಲಿವಾಡೊತೊ. ತ್ಯಾಂತಾ ತ್ಯುನೆ ಪೆತ್ರಾನೆ\"ತೆ ಮನಕ್ಹನಾ ಶಿಷ್ಯಾವೊನಾ ತುಬಿ ಯಕ್ಲೊ ವ್ಹೈ ನೈ? ಕೈನ ಪುಚ್ಯಾ. ತೆನೈಸೊ ಪೆತ್ರಾ\"ನ್ಹವೈ, ಮಿ ನ್ಹವೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ಖಾಸ ಯಾಜಕನಾ ಸೆವಕೊಮಾ ಯಕ್ಲೊ ಪೆತ್ರಾ ಕಾನ ಕಾಟಲ ಸೆವಕನೊ ಸಂಬದಿಕ ವ್ಹತ್ತೊ. ತೆ ಸೆವಕ\"ತು ಮಳಾಮಾ ತಿನಾ ಕ್ಹಾತೆ (ಯೆಸುನಾ ಕ್ಹಾತೆ) ರ‍್ಹಯಲ ಮಿ ದೆಕಲ ಲಿಂಗತ ಛೆ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ತೆನೈಸೊ ಪೆತ್ರಾ ವರಿ\"ನ್ಹವೈ, ಮಿ ತಿನಾ ಕ್ಹಾತೆ ನ್ಹೊತೊ\" ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ಕುಕ್ಡೊ ಬಾಂಗ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ಪಾಚಾ಼ತಾ ಯಹುದ್ಯೊ ಯೆಸುನೆ ಕಾಯಫನಾ ಘರತಾ ರೊಮ ರಾಜ್ಯಪಾಲನಾ ಭವನ ಕನ ಲಿನ ಆಯಾ. ತೆಳಾಮಾ ಪಾಟ ಥೈತಿ. ಯಹುದ್ಯೊ ಭವನನಾ ಮ್ಹೈ ಗಯಾ ನೈ. ತ್ಯುನೆ ಪಸ್ಕ ಸನ್ನನು ಅನ್ನ ಚಾ಼ಯೆ ಕೈನ ರ‍್ಹಯಲ ಹುತಿ ತ್ಯುನೊನೆ ಅಶುದ್ಧೊ ಥೈನ ಕರಿಲಿವಾನೆ ಪಸಂದ ಕರ‍್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ತಿನಾಹುತಿ ಪಿಲಾತನ ತೆ ಯಹುದ್ಯೊ ಕನ ಐನ\"ಎ ಮನಕ್ಹನಾ ಉಪ್ಪರ ತುಮೆ ಘಾಲ್ಯಲ ಅಪರಾದ ಸು ವ್ಹೈ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ಯಹುದ್ಯೊ\"ಎ ಯಕ್ಕ ಕೆಟ್ಟ ಮನಕ್ಹ ವ್ಹೈ. ತಿನಾಹುತಿ, ಹಮೆ ಇನೆ ತುಕನ ಬಲೈನ ಲಾಯಾಸ\" ಕೈನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ಪಿಲಾತನ ಯಹುದಿಯೊನೆ\"ಯಹುದ್ಯೊ ಥಯಲ ತುಮೆಜ಼ ಅನೆ ಬಲೈ ಲಿನ ಗೈನ ತುಮಾರಾ ಧರಮಶಾಸ್ತ್ರನಾ ಲಿಂಗತ ಫೈಸಲೊ ಕರೊ\" ಕೈನ ಕದ್ಯೊ. ಯಹುದ್ಯೊ\"ತೆನೈಸೊ ಯಕ್ಲಾನೆ ಮೌತನೊ ಫೈಸಲೊ ಕರಾನೆ ಹಮಾರು ಕಾನುನ ಮೌಕೊ ನೈ ದೆತು\" ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ತಿನೆ ಮರಾನಾ ತರಿಕಾನಾ ಹುತಿ ಯೆಸು ಕದಲ ವಾತ ಇಮ್ಮ ಕ್ಹರಿ ಥಾವಾನಾ ಹುತಿ ಇಮ್ಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ಪಾಚಲ್ತೊ ಪಿಲಾತನ, ಭವನಮಾ ಫರಿನ ಗೈನ, ಯೆಸುನೆ ಬಲೈನ\"ತು ಯಹುದ್ಯೊನೊ ರಾಜೊ಼ ವ್ಹೈ ಸು? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ಯೆಸು\"ಎ ತಾರು ಸವಾಲ ವ್ಹೈ ಸು? ತೆನೈಸೊ ಮಾರಾ ಹುತಿ ಬಿಜಾ಼ ಮನಕ್ಹೊ ತುನೆ ತಿಳಸ್ಯಾ ಸು? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ತೆಳಾಮಾ ಪಿಲಾತನ ಕದ್ಯೊ\"ಮಿ ಯಹುದ್ಯನೊ ನ್ಹವೈ! ತಾರಾ ಸ್ವಂತ ಮನಕ್ಹೊ ವರಿ ತ್ಯುನಾ ಖಾಸ ಯಾಜಕೊ ತುನೆ ಬಲೈನ ಐನ ಮಾರಾ ಕ್ಹಾಮಾ ಹುಬ್ರಾಡ್ಯಾಸ. ತು ಸು ಕರ‍್ಯೊ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ಯೆಸು\"ಮಾರಿ ರಾಜ್ಯ ಎ ದುನಿಯಾನೆ ಮಳಲ ನ್ಹವೈ. ತೆ ಎ ದುನಿಯಾನೆ ಮಳಲ ರ‍್ಹವತ್ತು ಯಹುದ್ಯೊನಾ ಹತ್ಮಾ ಕ್ಹಾಪಡ್ಯಾವಾಚಿ ಮಿ ಕ್ಹಾಪಡೆ ನೈಸೊ ಮಾರಾ ಸೆವಕೊ. ತೆನೈಸೊ ಮಾರಿ ರಾಜ್ಯ ನ್ಹ್ಯಾನು ನ್ಹವ್ಹೈ\" ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ಪಿಲಾತನ\"ತಿಮ್ಮ ರ‍್ಹಯುಮ ತು ರಾಜೊ಼ ವ್ಹೈ ಸು? ಕದ್ಯೊ. ಯೆಸು ತಿನೆ\"ತುಜ಼಼ ಮನೆ ರಾಜೊ಼ ವ್ಹೈ ಕೈನ ಕವಾಡ್ಯೊಸ. ಮಿ ಮನಕ್ಹೊನೆ ಕ್ಹರಿ ಹುತಿ ಕವಾನೆ ಮಿ ಎ ದುನಿಯಾಮಾ ಹುಟ್ಯೊಸ. ಕ್ಹರಿಮಾ ರ‍್ಹಯಲ ಹರಿ ಯಕ್ಲೊ ಮಿ ಕದಲ ಐಕಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ಪಿಲಾತನ \"ಕ್ಹರಿ ಕದ್ಯಾಮ ಸುವ್ಹೈ? ಕೈನ ಪುಚ್ಚಿನ ವರಿ ಯಹುದ್ಯೊಕನ ಭಾರೊ ಆಯೊ. ತೆ ಯಹುದಿಯೊನೆ\"ಎ ಮನಕ್ಹಪರ ಅಪವಾದ ಘಾಲಾನೆ ಮನೆ ಸುಜ಼ ದಿಕ್ಹಾಡ್ಯು ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ವರಿಬಿ ಫಸ್ಕ ಸನ್ನಮಾ ಮಿ ತುಮಾರಾ ಹುತಿ ಕೈದಿಯೊಮಾನಾ ಯಕ್ಲಾನೆ ಬಿಡುಗಡೆ ಕರಾನು ಹಮಾರಿ ಪದ್ದತ ವ್ಹೈ. ಮಿ ಯಹುದ್ಯೊನಾ ರಾಜಾ಼ನೆ ಬಿಡುಗಡೆ ಕರುಕೈನ ತುಮಾರಿ ಆಸ ಛೆಸು? ಕೈನ ಪುಚ್ಯು. ");
INSERT INTO sle_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ಯಹುದಿ \"ನೈ ತಿನೆ ನ್ಹೈ\" ಬರಬ್ಬನೆ ಬಿಡುಗಡೆ ಥಾವಾದೆ\" ಕೈನ ವದ್ರ್ಯಾ. ಬರಬ್ಬ ಯಕ್ಲೊ ಹೊರಾಟ ಕರಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ಪಾಚಾ಼ತಾ, ಯೆಸುನೆ ಧರಿನ ಲಿನ ಗೈನ, ಬಾರಕೊಲ ಕ್ಹು ಮಾರು ಕೈನ ಪಿಲಾತನ ಆಗನ್ಯಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ಸೈನಿಕೊ ಕಾಟಾವೊನಾ ಝಾಕ್ರಾಕ್ಹು ಯಕ್ಕ ಕಿರಿಟ ಕರಿನ ಯೆಸುನಾ ಮಾತಾ ಪರ ಮ್ಹೆಲ್ಯಾ. ಪಾಚಾ಼ತಾ ಸೈನಿಕೊ ಯೆಸುನೆ ಜಾಂಬಳಾನು ಕಲರ ರ‍್ಹಯಲ ಮ್ಹೊಟು ಅಂಗ್ಡು ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ಸೈನಿಕೊ ಹಗ್ಲೆಲ್ಲಾ ಯೆಸು ಕನ ಐನ\"ಯಹುದ್ಯೊನಾ ರಾಜಾ಼ ತು ಘನ್ನಾ ಕಾಲ ಜಿವ್ತೊ ರ‍್ಹವಾದೆ\" ಕೈನ ಕತಾ ತಿನಾ ಗಾಲೊಪರ ಮಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ಪಿಲಾತನ ವರಿ ಭಾರೊ ಐನ, ಯಹುದಿಯೊನೆ\"ದೆಕೊ ಮಿ ಯೆಸುನೆ ತುಮೊಕನ ಲಾವಾಡ್ಯೊಸ. ಮನೆ ತಿಮಾ ಕಯುಜ಼ ಅಪರಾದ ದಿಕ್ಹ್ಯು ನೈ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹವಾದೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ತೆಳಾಮಾ ಯೆಸು ಭಾರೊ ಆಯೊ. ತಿನಾ ಮಾತಾಪರ ಕಾಟಾನು ಕಿರಿಟ ಘಾಲ್ಯಾತಾ ವರಿ ಜಾಂಬಳಾನು ಕಲರನು ಅಂಗ್ಡು ತಿನೆ ಘಾಲ್ಯಾ. ಪಿಲಾತನ ಯಹುದಿಯೊನೆ\"ದೆಕೊ, ಎಜ಼ ಮನಕ್ಹ ವ್ಹೈ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ಖಾಸ ಯಾಜಕೊ ಯಹುದಿಯೊನೆ ದೆವಾಲಯ ಕೈದಾಲಾ ಯೆಸುನೆ ದೆಕಿನ\"ತಿನೆ ಶಿಲುಬಿಪರ ಘಾಲ ತಿನೆ ಶಿಲುಬಿಪರ ಗಾಲ\" ಕೈನ ವದ್ರ್ಯಾ. ತೆನೈಸೊ ಪಿಲಾತನ\"ತುಮೆಜ಼ ತಿನೆ ಲಿನ ಗೈನ ಶಿಲುಬೆಪರ ಘಾಲೊ ಮನೆ ತಿಮಾ ಕಯುಜ಼ ಅಪರಾದ ದಿಕ್ಹ್ಯು ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ಯೆಹುದಿಯೊ \"ಹಮೊನೆ ಯಕ್ಕ ನಿಯಮ ಛೆ ತಿನಾಲಿಂಗತ ಇನಿ ಮರವಾನಿ ಶಿಕ್ಷಾ ಥೌಜ. ಕಾಕದ್ಯಾಮ ಎ ತಿನೆ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಕೈಲಿದ್ಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ಎ ಕವಾನು ಪಿಲಾತನ ಐಕಿನ ಘನ್ನೊ ಭುಚಿ಼ಕಿನ, ");
INSERT INTO sle_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ವರಿ ಭವನಮಾ ಗೈನ ಯೆಸುನೆ\"ತು ಕಿಜಾತೊ ಆಯೊಸ? ಕೈನ ಪುಚ್ಯೊ. ತೆನೈಸೊ ಯೆಸು ಸುಜ಼ ಕದ್ಯೊ ನೈ? ");
INSERT INTO sle_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ಪಿಲಾತನ\"ಮಾರಾ ಕ್ಹಾತೆ ಬೊಲ್ತೊ ನೈಸು? ತುನೆ ಛೊಡಾವಾನೆ ಅದಿಕಾರ ತುನೆ ಶಿಲುಬಿ ಪರ ಘಾಲಾನು ಅದಿಕಾರಬಿ ಮನೆ ಛೆ ಕವಾನು ತುನೆ ಗ್ವತ್ತ ಛೆ ಸು? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ಯೆಸು ತಿನೆ \"ಮಪರ ತುನೆ ರ‍್ಹಯಲ ಅದಿಕಾರ ಛೆ. ತೆ ಕ್ಹುದಾಜ ತುನೆ ದಿದಲ ಅದಿಕಾರ ವ್ಹೈ. ತಿನಾಹುತಿ ಮನೆ ತಾರಾ ಹತ್ಮಾ ದಿದಲವಾಲಾವೊನೆ ಘನ್ನು ಪಾಪ ದೊಶ ರ‍್ಹವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ಎ ಥಯಲ್ಪರ ಯೆಸುನೆ ಬಿಡುಗಡೆ ಕರಾನೆ ಪಿಲಾತನ ಕೊಶಿಶ ಕರ‍್ಯೊ. ತೆನೈಸೊ ಯೆಹುದಿಯೊ\"ತಿನಾಕ್ಹು ತಿನೆ ರಾಜೊ಼ ವ್ಹೈ ಕೈನ ಕೈಲಿವಾನು ಕಯೊಬಿ ಮನಕ್ಹ ರ‍್ಹೈನಕಾ ಸಿಸರನೊ ವಿರೊಧಿ ವ್ಹೈ. ತಿನಾಹುತಿ ತು ಎ ಮನಕ್ಹನೆ ಬಿಡುಗಡೆ ಕರ‍್ಯೊಮ ತು ಸಿಸರನೊ ದೊಸ್ತ ನ್ಹವೈ ಕೈನ ತಿನೊ ಮತ್ಲಬ ವ್ಹೈ ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ಯಹುದಿಯೊ ಕದಲ ಐಕಿನ ಪಿಲಾತನ ಯೆಸುನೆ ಭಾರೊ ಬಲೈನ ಹಾಸುಗಲ್ಲ ಕವಾನು ಕಟ್ಟಾಕನ. ರ‍್ಹಯಲ ಫೈಸಲಾನಿ ಜ಼ಗಾಪರ ಬೈಟ್ಯೊ. ಇಬ್ರಿಯ ವಾತೊಮಾ ತಿನು ನಾಮ ಗಬ್ಬಥ ವ್ಹೈ ");
INSERT INTO sle_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ತೆ ಪಸ್ಕ ಸನ್ನನು ತಯ್ಯಾರನೊ ದಿನ್ನ ವ್ಹೈ. ವರಿ ತೆಳಾಮಾಜ಼ ದುಪಾರ ಥೈಗೈತಿ ಪಿಲಾತನ ಯೆಹುದಿಯೊನೆ\"ದೆಕೊ, ತುಮಾರೊ ರಾಜೊ಼\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ಯಹುದಿಯೊನೆ\"ಲಿವೊ, ತಿನೆ ಶಿಲುಬಿಪರ ಘಾಲೊ\" ಕೈನ ವದ್ರ್ಯಾ. ಪಿಲಾತನ ಯಹುದಿಯೊನೆ\"ತುಮಾರಾ ರಾಜಾ಼ನೆ ಶಿಲುಬಿಪರ ಘಾಲು ಕೈನ ಆಸ ಕರೊಶಿ ಸು? ಕೈನ ಕದ್ಯೊ. ಖಾಸ ಯಾಜಕ\"ಹಮೊನೆ ಸಿಸರನೆ ಛೊಡಿನ ಬಿಜೊ ಕಯೊ ರಾಜೊ಼ ನತ್ತಿ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ತೆಳಾಮಾ ಪಿಲಾತನ ಯೆಸುನೆ ಶಿಲುಬಿಪರ ಘಾಲಾನೆ ತಿವ್ನಾ ಹತ್ಮಾ ದಿದ್ಯೊ. ಸೈನಿಕೊ ಯೆಸುನೆ ಬಲೈಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ಯೆಸು ತಿನಿ ಸ್ವಂತ ಶಿಲುಬಿ ಉಚೈಲಿನ ಭಾರೊ ಆಯೊ. ಕಪಾಲ ಕವಾನಿ ಜ಼ಗಾಪರ ಗಯೊ. ಯಹುದಿಯೊನಿ ವಾತೊಮಾ ಎ ಜ಼ಗಾನು ನಾಮ ಗೊಲ್ಗೊಥಾ\" ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ತ್ಯುನೆ ತ್ಯಾ ಯೆಸುನಿ ತಿನಾ ಕ್ಹಾತೆ ಬಿಜಕ್ಲಾ ಬೆ ಜ಼ನಾವೊನೆ ಶಿಲುಬಿಪರ ಘಾಲ್ಯಾ. ತ್ಯುನೆ ಭಂಬಿಜ಼ನಾ ಆಜು಼ ಬಾಜು಼ಮಾ ಘಾಲಿನ, ಯೆಸುನೆ ತ್ಯುನಾ ವಚ್ಮಾ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ಪಿಲಾತನ ಯಕ್ಕ ಫಳಿಪರ ಬರ್ದಿನ ಶಿಲುಬೆನಾ ಉಪ್ಪರ ಲಗಾಡ್ಯೊ. ತೆ ಫಳಿಪರ\"ನಜರೆತನೊ ಯೆಸು ಯಹುದಿಯೊನಾ ರಾಜ಼ೊ ಕವಾನು ಬರ್ದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ತೆ ಫಳಿಪರ ಇಬ್ರಿಯ ವಾತೊಮಾ ಲ್ಯಾಟಿನ ವರಿ ಗ್ರಿಕ ವಾತೊಮಾ ಬರ್ದಲ ವ್ಹತ್ತು. ಫಳಿಪರ ಬರ್ದಲ ಘನ್ನಾ-ಘನ್ನಾ ಮನಕ್ಹೊ ಒದ್ಯಾ. ಕಾಕದ್ಯಾಮ ಯೆಸು ಶಿಲುಬಿಪರ ಘಾಲ್ಯಾತಾ ತೆ ಜ಼ಗಾ ಗಾಮನಾ ನಜಿಕ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ಖಾಸ ಯಾಜಕೊ ಪಿಲಾತನನೆ ತೆ ಯಹುದಿಯೊನೊ ರಾಜ಼ೊ ವ್ಹೈ ಕೈನ ಬರ್ದೊ ನಕೊ. ತೆನೈಸೊ\"ಎ ತಿನೆ ಯಹುದಿಯೊನೊ ರಾಜೊ಼ ಕೈನ ಕೈಲಿದ್ಯೊಸ \"ಬರ್ದೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ಪಿಲಾತನ\"ಮಿ ಬರ್ದಾಯಲ ಬದಲಿ ಕರಾನೆ ಥಾತು ನೈ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ಸೈನಿಕೊ ಯೆಸುನೆ ಶಿಲುಬಿಪರ ಘಾಲ್ಯಲಪರ ತಿನಾ ವಣ್ಣಾ ಚಾರ ಭಾಗ ಕರಿನ ಯಕೆಕ್ಲೊ ಯಕೆಕ ಭಾಗ ವಾಟಿಲಿದ್ಯಾ. ತ್ಯಾಂತಾ ತೆನೈಸೊ ತಿನು ಮ್ಹೈನು ಅಂಗ್ಡುಬಿ ಕಾಡಿಲಿದ್ಯಾ. ತೆ ಹೊಲಗಿ ನೈಸೊ ಉಪ್ಪರತಾ ಶಿಯಲ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ತಿನಾಹುತಿ ಸೈನಿಕೊ\"ಅಪೆ ಅನೆ ಫಾಡಿನ ಪಾಲ ಕರು ನೈ. ಅಪೆ ಚಿಟಿ ಘಾಲಿನ ತೆ ಕಿನೆ ಆವಸ ದೆಕೆ\" ಕೈನ ಬೊಲಿನ ಅಮ್ಮ ಕರ‍್ಯಾ\" ತ್ಯುನೆ ಮಾರಾ ವಣ್ಣಾ ತ್ಯುನಾಮಾ ಪಾಲ ಕರಿಲಿದ್ಯಾ\" ಮಾರಾ ಅಂಗ್ಡಾನಾ ಹುತಿ ಚಿಟಿ ಘಾಲ್ಯಾ\" ಕಿರ್ತನೆ 22:18 ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ವಾತ ಅಮ್ಮ ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ಯೆಸುನಿ ಯಾ, ಯಾನಿ ಭೆನ, ಕ್ಲೊಪನನಿ ಬೈಕೊ ಥಯಲ ಮರಿಯಳ ವರಿ ಮಗ್ದಲನಿ ಮರಿಯಳ ಶಿಲುಬಿ ಕನ ಹುಬ್ರಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ಯೆಸು ತಿನಿ ಯಾನೆ ತ್ಯಾ ಹುಬ್ರಯಲ ತಿನಾ ಮಯಾನೊ ಶಿಷ್ಯಾನೆ ದೆಕಿನ ತಿನಿ ಯಾನೆ\"ಯಾ ದೆಕ, ತಾರೊ ದಿಕ್ರೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ಪಾಚಲ್ತೊ ಯೆಸು ತೆ ಶಿಷ್ಯಾನೆ\"ದೆಕ, ತಾರಿ ಯಾ\" ಕದ್ಯೊ. ತೆ ದಿನ್ನತೊ ತೆ ಶಿಷ್ಯೊ ತಿನೆ ಬಲೈಲಿನ ಗೈನ ತಿನಾ ಘರಮಾ ಮ್ಹೆಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ಎ ಥಯಲ್ಪರ ಕ್ಹಾರು ಪುರಾ ಥಯು ಕೈನ ತಿಳ್ದಿಲಿನ ಪವಿತ್ರ ಗ್ರಂಥನಿ ವಾತ ಪುರಾ ಕರಾನಾ ಹುತಿ ತೆ\"ಮನೆ ತರಕ್ಹ ಲಾಗಿಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ತ್ಯಾ ಖಾಟು ರಕ್ಹ ಭರಲ ಹಂಡೊ ವ್ಹತ್ತು. ಸೈನಿಕೊ ಸ್ಪಂಜ ಖಾಟಾ ರಕ್ಹಮಾ ಡುಬೈನ ಹಿಸ್ಸೊಪ್ ಕವಾನಾ ಝಾಡನಿ ಲಾಕ್ಡಿನೆ ಟಂಗೈನ ತಿನೆ ಉಪ್ಪರ ಉಚೈನ ಯೆಸುನಾ ಮ್ಹೊಡಾನೆ ಲಗಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ಯೆಸು ಖಾಟು ರಕ್ಹನೆ ಸುರ್ಕಿನ\"ಪುರಾ ಥಯು\" ಕೈನ ಮಾತು ಜು಼ಕೈನ ಜ಼ಲಮ ಛೊಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ತೆ ದಿನ್ನ ತಯ್ಯಾರಿನು ದಿನ್ನ ವ್ಹತ್ತು. ಮರ್ನಾ ದಿನ್ನೆ ಖಾಸ ಸಬ್ಬತ ದಿನ್ನ ವ್ಹತ್ತು. ಸಬ್ಬತ ದಿನ್ನೆ ಅಂಗೊ ಶಿಲುಬಿ ಪರ ಚಡಾನು ಯಹುದಿಯೊನೆ ಪಸಂದ ನ್ಹೊತು. ತಿನಾಹುತಿ ತ್ಯುನಾ ಪಗೊನೆ ತೊಡಿನ ಜಲ್ದಿ ಖಲಾಸ ಕರಾನು ಆಜ್ಞಾ ದಿವ ಕೈನ ತ್ಯುನೆ ಪಿಲಾತನ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ತಿನಾಹುತಿ ಸೈನಿಕೊ ಐನ ಯೆಸುನಾ ಕ್ಹಾತೆ ಶಿಲುಬಿ ಪರ ಚ಼ಡಾಯಲ ಬೆ ಜ಼ನಾವೊನಾ ಪಗೊ ಭಾಗಿ ಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಯೆಸುನಾ ನಜಿಕ ಆಯಲ ಪರ ತೆ ತೆಳಾಮಾಜ಼ ಮರ‍್ಯಲ ದೆಕಿನ ತಿನಾ ಪಗೊ ತೊಡ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ತೆನೈಸೊ ಸೈನಿಕೊಮಾನೊ ಯಕ್ಲೊ ತಿನಿ ಬರ್ಚಿಕ್ಹು ಯೆಸುನಾ ಪಾಖಳಿಮಾ ಚೊಟ್ಯೊ. ಪಾಖಳಿಮಾತು ರಗತ ವರಿ ಪಾನಿ ಭಾರು ಐಯು. ");
INSERT INTO sle_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ಎ ದೆಕಲವಾಲೊ ಇನಾಹುತಿ ಕದ್ಯೊಸ. ತುಮೆಬಿ ಬರೊಕ್ಹೊ ಕರು ಕೈನ ತೆ ತುಮೊನೆ ಎ ತಿಳ್ಸಾಯೊಸ. ತೆ ಕವಾನಿ ಸಂಗತಿಯೊ ಕ್ಹರಿಜ ವ್ಹೈ. ತೆ ಕವಾನು ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ತಿನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ\"ತಿನಾ ಹಡಕಾವೊಮಾ ಯಕ್ಕಬಿ ನೈ ತೊಡಸಕ್ತಾ\" ಕವಾನಿ ವಾತ ಇಮ್ಮ ಪುರಾ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ಪವಿತ್ರ ಗ್ರಂಥನಾ ವರಿ ಯಕ್ಕ ಜ಼ಗಾ\"ಮನಕ್ಹೊ ತ್ಯುನೆ ಬರ್ಚಿಕ್ಹು ಚೊಟೈ ಲಿದ್ಯಲಕ್ಹು ತಿನೆಜ ಡೊಳಾ ಫಾಡಿನ ದೆಕಸ\" ಕೈನ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ಪಾಚಾ಼ತಾ, ಅರಿಮಥಾಯ ಗಾಮನೊ ಯೊಸೆಫ ಕವಾಲೊ ಯೆಸುನು ಅಂಗ ತಿನೆ ದೆ ಕೈನ ಪಿಲಾತನ ಕನ ಮಾಂಗಿಲಿದ್ಯೊ. ಯೊಸೆಫ ಯೆಸುನೊ ಯಕ್ಕ ಅನುಯಾಯಿ ವ್ಹತ್ತೊ. ತೆನೈಸೊ ತೆ ಯೆಹುದಿಯೊನಾ ಅದಿಕಾರಿಯೊನೆ ಭುಚಿ಼ಕಿನ ರ‍್ಹಯಲಕ್ಹು ತಿನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಕದ್ಯೊ ನ್ಹೊತೊ. ಯೆಸುನು ಅಂಗ ಲಿನ ಜಾ಼ವಾನೆ ಪಿಲಾತನ ತಿನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ತಿನಾಹುತಿ ತೆ ಐನ ಯೆಸುನು ಅಂಗ ಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ನಿಕೊದೆಮ ಯೊಸೆಫನಾ ಕ್ಹಾತೆ ಗಯೊ. ಪಾಚೊ಼ ಯಕ್ಕೆಮ, ರಾತೆ ಯೆಸು ಕನ ಐನ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಲವಾಲೊಜ ನಿಕೊದೆಮ ವ್ಹೈ. ತೆ ಮುವತ್ತ ಕಿಲೊ ತೆಕ್ಲು ಬಾಸನು ತೆಲ ಲಿನ ಆಯೊ. ತೆ ಬಾಸನು ತೆಲ ರಕ್ತಬೊಳ ವರಿ ಅಗರು ಮಳೈನ ಕರಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ಎ ಭಂಬಿ ಜ಼ನಾ ಯೆಸುನು ಅಂಗ ಲಿನ ತಿನೆ ಬಾಸನು ತೆಲ ಲಗಾಡಿನ ಖಾದಿನಾ ಫಡಕಾಕ್ಹು ಸುತ್ಯಾ. ಯಹುದ್ಯೊ ಪದ್ದತ ಲಿಂಗತಜ ಸಮಾದಿ ಕರಾನೆ ತಯ್ಯಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ಯೆಸುನೆ ಶಿಲುವಿ ಪರ ಘಾಲ್ಯಲ ಜ಼ಗಾ ಯಕ್ಕ ಕ್ಹೆತರ ವ್ಹತ್ತು. ತೆ ಕ್ಹೆತರಮಾ ಯಕ್ಕ ನಯಿ ಮಜಾರ ವ್ಹತ್ತಿ. ತಿಮಾ ಕೆಳಾಮಾಜ ಕಿನೆ ಸಮಾದಿ ಕರ‍್ಯಾ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ತೆ ಸಬ್ಬತನು ತಯ್ಯಾರನು ದಿನ್ನ ಶುಕ್ರಾರ ವ್ಹತ್ತು. ವರಿ ಸಮಾದಿ ಘನ್ನಿ ನಜಿಕ ವ್ಹತ್ತಿ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಯೆಸುನೆ ತಿಮಾ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ಐತ್ವಾರ ಪಾಟೆ ಮಗ್ದಲನಿ ಮರಿಯಳ ಯೆಸುನಾ ಅಂಗ ರ‍್ಹಯಲ ಮಜಾರ ಕನ ಐ. ತೆಳಾಮಾ ಹಜು಼ನ ಅಂದಾರು ವ್ಹತ್ತು. ಮಜಾರನಾ ಬಾಕಲನೆ ಝಾಕಲ ಮ್ಹೊಟೊ ದಗ್ಡೊ ತ್ಯಾಂತೊ ಸರಕಾಯಲ ದೆಕಿನ ಮರಿಯಳ ");
INSERT INTO sle_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ಸಿಮೊನ ಪೆತ್ರಾ ವರಿ ಯೆಸು ಮಯಾ ಕರಾನಾ ವರಿಯಕ್ಲಾ ಶಿಷ್ಯಾ ಕನ ನ್ಹಾಟಿನ ಐನ\"ತ್ಯುನೆ ಮಜಾರಮಾತಾ ಪ್ರಭುನೆ ಲಿನ ಗಯಾಸ, ತಿನೆ ಕಿಜಾ಼ ಮ್ಹೆಲ್ಯಾಸ ಕವಾನು ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ತಿನಾಹುತಿ ಪೆತ್ರಾ ವರಿಯಕ್ಕ ಶಿಷ್ಯೊ ಮಜಾರ ಕನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ತ್ಯುನೆ ಭಂಬಿ ಜ಼ನಾ ನ್ಹಾಟತಾ ಗಯಾ. ತೆನೈಸೊ ತೆ ವರಿಯಕ್ಕ ಬಿಜೊ ಶಿಷ್ಯೊ ಪೆತ್ರಾತಿಬಿ ಜೊ಼ರ ನ್ಹಾಟತೊ ಮಜಾರ ಕನ ಗೈನ ಪೈಲಾ ಮುಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ತೆ ಶಿಷ್ಯೊ ಡೊಗ್ಗಿನ ಮ್ಹೈ ದೆಕ್ಯೊ. ತ್ಯಾ ಫಡಕಾನಾ ತುಕ್ಡಾ ಪಡ್ಯಾತಾ ತೆನೈಸೊ ತೆ ಮ್ಹೈ ಗಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ಪಾಚಲ್ತೊ ಆಯಲ ಪೆತ್ರಾ ಸಿದಾ ಮಜಾರನಾ ಮ್ಹೈ ಹೊಕ್ಯೊ. ಖಾದಿನಾ ಫಡಕಾ ತ್ಯಾ ಪಡಲ ತೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ಪಸ್ಟ ನ್ಹಾಟಿನ ಗಯಲ ತೆ ಶಿಷ್ಯೊಬಿ ಮ್ಹೈ ಗಯೊ. ವರಿ ದೆಕ್ಯೊ, ವರಿ ಬರೊಕ್ಹೊ ಕರ‍್ಯೊ. ತೆ ಪ್ಹಡಕು ಸುತ್ತಲ ರ‍್ಹೈನ, ಬಿಜಾ಼ ಖಾದಿನಾ ಫಡಕಾವೊತಿ ಜ಼ುದು ಥೈನ ಪಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ಪಾಚಲ್ತೊ ತೆ ವರಿಯಕ್ಕ ಶಿಷ್ಯೊ ಮ್ಹೈ ಗಯೊ. ಮಜಾರ ಪೈಲಾ ಗೈನ ಮುಟ್ಯಲವಾಲೊ ತೆ ಶಿಷ್ಯೊ ವ್ಹೈ. ತೆ ಥಯಲ ಕ್ಹಾರು ದೆಕಿನ ಬರೊಕ್ಹೊ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ತೆ ಮರಿನ ವರಿ ಜಿವ್ತೊ ಥೈನ ಆವಸ ಕವಾನು ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಎ ಶಿಷ್ಯಾವೊನೆ ಹಜು಼ನ ಗ್ವತ್ತ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ಪಾಚಾ಼ತಾ ಶಿಷ್ಯಾ ಪಾಚಾ಼ ಫರಿನ ಘರೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ತೆನೈಸೊ ಮರಿಯಳ ರೊತಿ ಮಜಾರನಾ ಭಾರಿ ಹುಬ್ರೈತಿ. ತೆ ರೊತಿ ಡೊಗ್ಗಿನ ಮಜಾರಮಾ ದೆಕ್ತಾಮಾ, ");
INSERT INTO sle_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ಧೊಳಾ ವಣ್ಣಾ ಘಾಲ್ಲಿದಲ ಬೆ ಕ್ಹುದಾನಾ ದುತೊ ದೆಕಿ. ಯೆಸುನು ಅಂಗ ಮ್ಹೆಲಲ ಜ಼ಗಾ ಕನ ತ್ಯುನೊಮಾ ಯಕ್ಲೊ ಯೆಸುನಾ ಮಾತಾ ಕನ ವರಿ ಯಕ್ಲೊ ಪಗೊ ರ‍್ಹಯಲ ಜ಼ಗಾ ಕನ ಬೈಟ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ಕ್ಹುದಾನಾ ದುತೊ ಮರಿಯಳನೆ\"ಬೈ, ಕಾ ರವಾಡಿಸ? ಕೈನ ಪುಚ್ಯಾ. ಮರಿಯಳ\"ಮಾರಾ ಪ್ರಭುನು ಅಂಗ ದಕ್ಹಾ ಜ಼ನಾ ಲಿನ ಗಯಾಸ. ತ್ಯುನೆ ತಿನೆ ಕಿಜಾ಼ ಮ್ಹೆಲ್ಯಾಸ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ\" ಕೈನ ಉತ್ತರ ದಿದಿ. ");
INSERT INTO sle_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ಮರಿಯಳ ಇಮ್ಮ ಕೈನ ಪಾಚಿ ಫರತಾಮಾ ಯೆಸು ತ್ಯಾಜ ಹುಬ್ರಯಲ ದೆಕಿ. ತೆನೈಸೊ ತೆ ಯೆಸುಜ ವ್ಹೈ ಕವಾನು ತಿನೆ ಗ್ವತ್ತ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ಯೆಸು ತಿನೆ\"ಬೈ, ಕಾ ರವಾಡಿಸ? ತು ಕಿನೆ ಹುಡಕಾಡಿಸ? ಕೈನ ಪುಚ್ಚೊ. ತೆ ಕ್ಹೆತರ ದೆಕಿಲಿವಾಲೊ ವಸೆ ಕೈನ ಮರಿಯಳ ತಿಳ್ದಿಲಿನ ತಿನೆ\"ಬಾ, ತು ಯೆಸುನೆ ಲಿನ ಗಯೊಸ ಸು? ತಿನೆ ಕಿಜಾ಼ ಮ್ಹೆಲ್ಯೊಸ, ಮನೆ ಕೆ. ಮಿ ಗೈನ ತಿನೆ ಲಿನ ಔಸ\" ಕೈನ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ಯೆಸು ತಿನೆ\"ಮರಿಯಳ\" ಕದ್ಯೊ. ಮರಿಯಳ ಯೆಸು ಕನ ಫರಿನ, ಇಬ್ರಿಯ ಭಾಶಾಮಾ \"ರಬ್ಬುನಿ\" ಕದಿ. ರಬ್ಬುನಿ ಕದ್ಯಾಮ \"ಗುರು ವ್ಹೈ\" ");
INSERT INTO sle_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ಯೆಸು ತಿನೆ ಮನೆ ಮುಟ್ಟು ನಕೊ. ಮಿ ಬಾಕನ ಹಜು಼ನ ಫರಿನ ಗಯೊ ನತ್ತಿ. ತೆನೈಸೊ ಮಾರಾ ಭಾಯೊಕನ (ಶಿಷ್ಯಾ) ಗೈನ ಮಾರೊ ಬಾ ತುಮಾರೊ ಬಾ ಮಾರೊ ಕ್ಹುದಾ ತುಮಾರೊ ಕ್ಹುದಾ ಥಯಲವಾಲೊ ಮಿ ಫರಿನ ಚಾಲ್ಯೊಸ. ಕವಾನು ತ್ಯುನೊಕನ ಕೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ಮಗ್ದಲನಿ ಮರಿಯಳ ಶಿಷ್ಯಾವೊಕನ ಗೈನ ಮಿ ಪ್ರಭುನೆ ದೆಕಿಶಿ ಕೈನ ಕದಿ ತೆ ಕ್ಹಾರಿಯೊ ಸಂಗತಿಯೊ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ತೆ ದಿನ್ನ ಐತ್ವಾರ ವ್ಹತ್ತೊ. ತೆ ದಿನ್ನಾ ಕ್ಹಾಂಜೆ ಶಿಷ್ಯಾ ಕುಡಿನ ವ್ಹತ್ತಾ. ಯೆಹುದಿಯೊನಾ ಅದಿಕಾರಿಯೊನೆ ಭುಚಿ಼ಕಿನ ಬಾಕಲೊ ಘಾಲ್ಲಿನ ಘರನಾ ಮ್ಹೈ ವ್ಹತ್ತಾ. ತೆಳಾಮಾ ಯೆಸು ತ್ಯುನಾ ವಚ್ಮಾ ಐನ ಹುಬ್ರೈನ ತ್ಯುನೊನೆ ಶಾಂತಿ ತುಮೊಮಾ ರ‍್ಹವಾದೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ಯೆಸು ಇಮ್ಮ ಕದಲ್ಪರ ತಿನಾ ಹತೊ ವರಿ ಪಾಕ್ಹಳಿ ದೆಕಾಡ್ಯೊ. ಪ್ರಭುನೆ ದೆಕಿನ ತ್ಯುನೆ ಘನ್ನಾ ಖುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ಪಾಚಲ್ತೊ ಯೆಸು ವರಿ ಶಾಂತಿ ತುಮೊಮಾ ರ‍್ಹವಾದೆ ಬಾ ಮನೆ ಮೊಕಲ್ಯೊ. ತಿನಾ ಲಿಂಗತಜ ಮಿ ತುಮೊನೆ ಮೊಕಲಾಡೊಸ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ಯೆಸು ಇಮ್ಮ ಕದಲ್ಪರ ಶಿಷ್ಯಾವೊಪರ ಯೆಸು ಪ್ಹುಕ್ಕಿನ ಪವಿತ್ರ ಆತ್ಮಾನೆ ಸ್ವಿಕಾರ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ತುಮೆ ಕಿನಾ ಪಾಪ ಮಾಫ ಕರೊಶಿ ತ್ಯುನಾ ಪಾಪೊ ಮಾಫ ಕರಸ. ತುಮೆ ಕಿನಾ ಪಾಪೊ ಮಾಫ ನೈ ಕರತಾ ತ್ಯುನಾ ಪಾಪೊ ಮಾಫ ನೈ ಕರತಾ. ತ್ಯುನಾ ಪಾಪೊನೆ ಮಾಫಿ ನೈ ಮಳ್ತಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ಯೆಸು ಆತಾಮಾ ಔಳಿ ಜೌಳಿ ಕವಾಲೊ ತೊಮ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ನ್ಹೊತೊ. ಬಾರಾ ಶಿಷ್ಯಾವೊಮಾನಾ ತೊಮ ಕವಾಲೊ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ಉಗ್ರಲ ಶಿಷ್ಯಾ ತೊಮಾನೆ ಹಮೆ ಪ್ರಭುನೆ ದೆಕ್ಯಾ ಕೈನ ಕದ್ಯಾ. ವರಿಬಿ ತೊಮಾ ತಿನಾ ಹತೊಮಾ ರ‍್ಹಯಲ ಮೊಳಾ ಮಾರಲ ದುಕಪರ ವರಿ ಪಾಕ್ಹಳಿಯೊನು ದುಖಪರ ಹತ ಮ್ಹೆಲಿನ ದೆಕೆ ಲಕ್ಕಾ ಮಿ ನಂಬತೊ ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ಯಕ್ಕ ಹಪ್ತೊ ಥಯಲಪರ ಕ್ಹಾರಾ ಶಿಷ್ಯಾ ಯಕ್ಕ ಘರಮಾ ಮಳ್ಯಾತಾ. ತೊಮಾ ತ್ಯುನ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ಪುರಾ ಬಾಕಲೊ ಘಾಲ್ಯಾತಾ ತೆಳಾಮಾ ಯೆಸು ಐನ ತ್ಯುನಾ ವಚ್ಮಾ ಹುಬ್ರೈನ ತ್ಯುನೊನೆ ಶಾಂತಿ ತುಮೊಮಾ ರ‍್ಹವಾದೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ಪಾಚಲ್ತೊ ಯೆಸು ತೊಮಾನೆ ತಾರೊ ಬೊಟ ಘಾಲಿನ ಮಾರಾ ಹತೊ ದೆಕ. ತಾರೊ ಹತ ಮಾರಿಯೊ ಪಾಕ್ಹಳಿಮಾ ಘಾಲ ಸಂಶೊ ಕರ‍್ಯಾವಾಚಿ ಮನೆ ನಂಬಾಲೊ ಥಾ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ತೊಮಾ ಯೆಸುನೆ \"ಮಾರಾ ಪ್ರಭು ಮಾರಾ ಕ್ಹುದಾ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ಯೆಸು ತುತೊ ಮನೆ ತು ದೆಕಿನ ನಂಬ್ಯೊ ಮನೆ ದೆಕ್ಯಾವಾಚಿ ನಂಬಾಲಾ ‍ಕ್ಹರಿಮಾಜ಼ ಧನೈ ವ್ಹೈ. ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ಯೆಸು ಹಜು಼ನ ತಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾಮೊ ಅದ್ಭುತ ಕಾಮೊ ಕರ‍್ಯೊ. ಎ ಅದ್ಭುತ ಕಾಮೊ ಪುಸ್ತಕಮಾ ಬರ್ದ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ಯೆಸು ಹಜು಼ನ ಬಿಜಾ಼ ಅದ್ಭುತ ಕಾಮೊ ತಿನಾ ಶಿಷ್ಯಾನಾ ಕ್ಹಾಮೊ ಕರ‍್ಯೊಸ. ತೆನೈಸೊ ಎ ಬುಕ್ಮಾ ನತ್ತಿ ಬರ್ದ್ಯಾ. ವರಿ ಅಕ್ಲು ಕ್ಹಾರು ಬರ್ದಲ ಛೆ. ಕಾಕದ್ಯಾಮ ತುಮೆ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲು ಕೈನ ಎ ಕ್ಹಾರು ಬರ್ದಲ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ತೆ ಥಯಲ್ಪರ, ವರಿ ಯಕ್ಕಸಲಾ ಯೆಸು ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ತಿಬೆರಿಯಾ ಸಮುಂದರಕನ ದಿಕ್ಹ್ಯೊ. ತೆ ಅಮ ಥಯು; ");
INSERT INTO sle_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ದಕ್ಹಾ ಶಿಷ್ಯಾ ತ್ಯಾ ಮಳಿನ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ, ಸಿಮೊನ ಕವಾಲೊ ಪೆತ್ರಾ, ದಿದುಮ ಕವಾಲೊ ತೊಮ, ಗಲಿಲಾಯನೆ ಮಳಲ ಕಾನಾ ಗಾಮವಾಲೊ ನತಾನಿಯೆಲ, ಜೆಬೆದಾಯನಾ ಭಂಬಿ ದಿಕ್ರಾನೆ ವರಿ ಬೆ ಜ಼ನಾ ಶಿಷ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ಪೆತ್ರಾ, ತ್ಯುನೊನೆ \"ಮಿ ಮಚ್ಲಿಯೊ ಧರಾನೆ ಚಾಲ್ಯೊಸ \"ಕದ್ಯೊ. ಉಗ್ರಲ ಶಿಷ್ಯಾ \"ಹಮೆಬಿ ತಾರಾ ಕ್ಹಾತೆ ಐಯೆಸ ಕೈನ ಕದ್ಯಾ. ತಿಮ್ಮ ಕತಾಮಾ ಕ್ಹಾರಾ ಶಿಷ್ಯಾ ಮಳಿನ ಹಡಗಾಮಾ ಚಡ್ಯಾ. ತ್ಯುನೆ ಕ್ಹಾರಿ ರಾತ ಸಮುಂದರಮಾ ಬಲಿಯೊ ಘಾಲ್ಯಾ. ಯಕ್ಕಬಿ ಮಚ್ಲಿ ಮಳಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ತೆ ದಿನ್ನೆ ದಿನ್ನ ನಿಕ್ಹಳ್ತಾಮಾ, ಯೆಸು ದಂಡಿಪರ ಹುಬ್ರಯೊತೊ. ತೆನೈಸೊ ತೆಜ಼ ಯೆಸು ವ್ಹೈ ಕೈನ ವಳಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ತೆಳಾಮಾ ತೆ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ \"ದೊಸ್ತೊ, ತುಮೊನೆ ಮಚ್ಲಿಯೊ ಮಳಿಯೊ ಸು, ಕೈನ ಪುಚ್ಯೊ. ಶಿಷ್ಯಾ\"ನತ್ತಿ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ಯೆಸು \"ತುಮಾರೊ ಹಡಗನಾ ಸಿದಾ ಹತ ಬಗಲ ತುಮಾರಿಯೊ ಬಲಿ ನಾಕೊ ತ್ಯಾ ದಕ್ಹಿಯೊ ಮಚ್ಲಿಯೊ ಮಳಸ, ಕೈನ ಕದ್ಯಾ. ಶಿಷ್ಯಾ ಕದಲ ತಿಮ್ಮಜ ಕರ‍್ಯಾ. ಘನ್ನಿಯೊ ಮಚ್ಲಿಯೊ ಬಲಿಮಾ ಕ್ಹಾಪ್ಡಲ ಹುತಿ ತ್ಯುನೆ ಬಲಿಯೊ ಹಡಗಾಮಾ ಜಗ್ಗಾನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ಯೆಸುನೊ ಮಯಾನೊ ಶಿಷ್ಯಾನೆ\"ತೆ ಮನಕ್ಹನೆ ಪ್ರಭು, ಕೈನ ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ಪೆತ್ರಾ ತಿನು ಅಂಗ್ಡು ಘಾಲ್ಲಿನ ಪಾನಿಮಾ ಉಡ್ಯೊ. ಪೆತ್ರಾ ಪೈಲಾಜ ತಿನು ಅಂಗ್ಡು ಕಾಡಿನ ಮ್ಹೆಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ಉಗ್ರಲ ಶಿಷ್ಯಾ ಹಡಗಾಮಾ ಚ಼ಡಿನ ಗೈಪಡ್ಯಾ. ತ್ಯುನೆ ಬಲಿಯೊ ಭರಿನ ಮಚ್ಲಿಯೊ ದಂಡಿಯೆ ಜಗ್ಗಿಲಿನ ಗಯಾ. ತ್ಯುನೆ ದಂಡಿತಾ ಘನ್ನಾ ದುರ ನ್ಹೊತಾ ಕ್ಹಾಲಿ 300 ಪುಟ ಯಕ್ಲಾ ದುರ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ಶಿಷ್ಯಾ ಹಡಗಾಮಾತಾ ಉತ್ರಿನ ದಂಡಿಪರ ಜಾ಼ತಾಮಾ ಆಗನಾ ಕಂಡಾ ದೆಕ್ಯಾ. ಆಗ ಪರ ಮಚ್ಲಿಯೊ ವ್ಹತ್ತಿಯೊ. ವರಿ ದಕ್ಹಾ ರೊಕ್ಲಾಬಿ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ಪಾಚಲ್ತೊ ಯೆಸು\"ತುಮೆ ಧರಲ ಮಚ್ಲಿಯೊಮಾ ದಕ್ಹಿಯೊ ಲಿನ ಆವೊ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ಪೆತ್ರಾ ಹಡಗಾಮಾ ಗೈನ ಬಲಿ ದಂಡಿಯೆ ಜಗ್ಗಿಲಿನ ಆಯೊ. ಬಲಿ ಮ್ಹೊಟಿಯೊ ಮಚ್ಲಿಯೊಕ್ಹು ಭರಿ ಗೈತಿ. ತಿಮಾ 153 ಮಚ್ಲಿಯೊ ವ್ಹತ್ತಿಯೊ. ತೆ ಘನ್ನಿಯೊ ವಜ್ಜಿಯೊ ರ‍್ಹೈತಬಿ ಬಲಿ ಪ್ಹಾಟಿ ನ್ಹೊತಿ. ");
INSERT INTO sle_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ಯೆಸು ತ್ಯುನೊನೆ \"ಐನ ಖಾವೊ\" ಕೈನ ಕದ್ಯೊ. ಶಿಷ್ಯಾವೊಮಾನಾ ಯಕ್ಲೊಬಿ \"ತು ಕುನ್ನ ವ್ಹೈ? ಕೈನ ತಿನೆ ಪುಚ್ಯಾ ನೈ. ತೆ ಪ್ರಭು ವ್ಹೈ ಕೈನ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ಯೆಸು ನಜಿಕ ಐನ ರೊಕ್ಲಾ ಲಿನ ವರಿ ತ್ಯುನೊನೆ ದಿದ್ಯೊ. ಇನಾಲಿಂಗತಜ಼ ಮಚ್ಲಿಯೊಬಿ ಲಿನ ಇಮ್ಮಜ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ಯೆಸು ಪುನರುತ್ಥಾನ ಥಯಲ್ಪರ ತಿನಾ ಶಿಷ್ಯಾವೊನೆ ದಿಕ್ಹಲ ಎ ತನ್ವಾ ಸಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ತ್ಯುನೆ ಖಾದಲ್ಪರ ಯೆಸು ಪೆತ್ರಾನೆ \"ಯೊಹಾನನೊ ದಿಕ್ರಾ ಸಿಮೊನ, ನ್ಹ್ಯಾ ರ‍್ಹಯಲ ಇವ್ನೆ ಮನೆ ಮಯಾ ಕರಾತಿಬಿ ತು ಮನೆ ಜಾಸ್ತಿ ಮಯಾ ಕರಶಿ ಸು? ಕೈನ ಪುಚ್ಯೊ. ಪೆತ್ರಾ \"ಹೊ ಪ್ರಭು ಮಿ ತುಪರ ಮಯಾ ಛೆ ಕವಾನು ಕದ್ಯೊ. ಯೆಸು ಪೆತ್ರಾನೆ \"ಮಾರಾ ಬಕ್ರಾವೊನೆ ಚರಾ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ವರಿ ಬೆವಾ ಸಲಾ ಯೆಸು ಪೆತ್ರಾನೆ \"ಯೊಹಾನನಾ ದಿಕ್ರಾ ಥಯಲ ಸಿಮೊನ ತು ಮನೆ ಮಯಾ ಕರಶಿ ಸು? ಕೈನ ಪುಚ್ಯೊ. ಪೆತ್ರಾ \"ಹೊ, ಪ್ರಭು ಮಿ ತುಪರ ಮಯಾ ಛೆ ಕವಾನು ತುನೆ ಗ್ವತ್ತ ಛೆ\" ಕದ್ಯೊ. ಯೆಸು ಪೆತ್ರಾನೆ \"ಮಾರಾ ಬಕ್ರಾವೊನೆ ಕೈದಶಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ಯೆಸು, ತನ್ವಾ ಸಲಾ \"ಯೊಹಾನನಾ ದಿಕ್ರಾ ಸಿಮೊನ ತು ಮನೆ ಮಯಾ ಕರಶಿ ಸು? ಕೈನ ಪುಚ್ಯೊ. ಯೆಸು \"ತು ಮನೆ ಮಯಾ ಕರಶಿ ಸು? ಕೈನ ತನ ಸಲಾ ಪುಚ್ತಾಮಾ ಪೆತ್ರಾನೆ ದುಖ ಥಯು. ಪೆತ್ರಾ \"ಪ್ರಭು, ತುನೆ ಹರಿ ಯಕ್ಕ ಗ್ವತ್ತ ಛೆ. ಮಿ ತುಪರ ಮಯಾ ಮ್ಹೆಲ್ಯೊಸ ಕವಾನು ತುನೆ ಗ್ವತ್ತ ಛೆ ಕದ್ಯೊ. ಯೆಸು ಪೆತ್ರಾನೆ \"ಮಾರಾ ಬಕ್ರಾವೊನೆ ಚರಾ. ");
INSERT INTO sle_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ಮಿ ತುನೆ ಕ್ಹರಿಜ ಕೌಸ. ತು ಜಾಂಜಿಮಾನ ರ‍್ಹತಾಮಾ ಕಂಬರ ಭಾಂದಲಿನ ತುನೆ ಮನಸ ರ‍್ಹಯಲ ಜ಼ಗಾ ಗಯೊ. ವರಿಬಿ ತು ಗಡಿಯೊ ಥಾತಾಮಾ ತಾರಿ ಮರ್ಜಿಲಿಂಗತ ಹತೊ ಅಗೊ ನೈ ಕರತೊ ಕರಶಿ ವರಿ ಬಿಜಕ್ಲೊ ತಾರಿ ಕಂಬರ ಭಾಂದಿನ ತುನೆ ಮನಸ ನೈ ರ‍್ಹಯಲ ಜ಼ಗಾ ಲಿನ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ಕ್ಹುದಾ ಮಹಿಮಾ ಕರಿಲಿವಾನಾ ಹುತಿ ಪೆತ್ರಾ ಕೈ ತರಾ ಮರಸ ಕವಾನು ದೆಕಾಡಾ ಹುತಿ ಯೆಸು ಇಮ್ಮ ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ಯೆಸು ಪೆತ್ರಾನೆ \"ಮಾರಾ ಪಾಚೊ಼ ಆ\" ");
INSERT INTO sle_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ಪೆತ್ರಾ ಪಾಚೊ಼ ಫರಿನ ದೆಕ್ತಾಮಾ ಯೆಸುನೊ ಮಯಾನೊ ಶಿಷ್ಯೊ ತ್ಯುನಾ ಪಾಚಾ಼ ಆವಾನು ದೆಕ್ಯಾ. ರಾತೆ ಖಾವಾನಾ ಟೈಮ್ಮಾ ಯೆಸುನಾ ಛಾತಿಪರ ಲಾಗಿನ\"ಪ್ರಭು, ತುನೆ ಮೊಸ ಕರಾಲೊ ಕುನ್ನ ವ್ಹೈ? ಕೈನ ಪುಚಲ ಶಿಷ್ಯೊ ಎಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ಪೆತ್ರಾ ತ್ಯುನಾ ಪಾಚಾ಼ ಆತಾ ರ‍್ಹಯಲ ಎ ಶಿಷ್ಯಾನೆ ದೆಕ್ತಾಮಾ \"ಪ್ರಭು, ಇನಾಹುತಿ ಸು ವ್ಹೈ? ಕೈನ ಪುಚ್ಚೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ಯೆಸು \"ಮಿ ಆಯೆಲಕ್ಕಾ ತೆ ಜಿವ್ತೊ ರ‍್ಹೌ ಕೈನ ಮನೆ ಮನಸ ರ‍್ಹಯುಮ ತಿನಾ ಹುತಿ ತುನೆ ಸು ವ್ಹೈ? ತು ಮಾರಾ ಪಾಚೊ಼ ಆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ಇನಾಹುತಿ ಶಿಷ್ಯೊ ಮರ್ತೊಜ಼ ನೈ ಕೈನ ವಾತ ಕ್ಹಾರಾ ಭಾಯೊಮಾ ಫೈಲಿ ಗೈ. ತೆ ನೈಸು ಯೆಸು ತೆ ಮರ್ತೊಜ಼ ನೈ ಕೈನ ತಿನೆ ಕದ್ಯೊ ನತ್ತಿ. ಮಿ ಆಯೆಲಕ್ಕಾ ತೆ ರ‍್ಹೌ ಮನೆ ಮನಸ ರ‍್ಹಯೊಮ ತೆ ತುನೆ ಕಾ? ಕೈನ ತೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ಎ ಸಂಗತಿಯೊ ಹಮ್ನಾ ಬರ್ದಲ ವರಿ ಇನಾಹುತಿ ಹಮ್ನಾ ಸಾಕ್ಷಿ ಕವಾಲೊ ಎಜ಼ ವ್ಹೈ. ತೆ ಕವಾನು ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ಯೆಸು ಹವಾ ಘನ್ನಾ ಕಾಮೊ ಕರ‍್ಯೊ. ತಿಮಾನು ಕ್ಹಾರುಜ಼ ಬರ್ದು ಕದ್ಯಾಮ ಬರ್ದಾನು ಪುಸ್ತಕಮಾ ಕ್ಹಾರಿ ಜಗತ್ತಜ ನೈ ಪುರ್ತಿ ಕೈನ ಮಿ ನೆಣಸುಸ.");
INSERT INTO sle_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ಮಯಾನಾ ಥೆಯೊಫಿಲ, ಯೆಸು ಕರಲ ಕಾಮೊನಾ ಹುತಿ ವರಿ ದಿದಲ ಬೊಧನೆನಾ ಹುತಿ ಹರಿಯಕ್ಕ ಮಿ ಮಾರಾ ಪೈಲಾನಾ ಬುಕ್ಮಾ ಬರ್ದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ಮಿ ಯೆಸುನಾ ಪುರಾ ಜಿವ್ನಾನಾ ಹುತಿ ಕದ್ಯಾಮ ತೆ ಸ್ವರ್ಗನೆ ಗಯೆ ಲಕ್ಕಾ ಥಯಲ ಕ್ಹಾರಿ ಸಂಗತಿಯೊ ಬರ್ದ್ಯೊ. ಯೆಸು ಸ್ವರ್ಗನೆ ಜಾ಼ವಾತಿ ಪೈಲಾ, ತೆ ಇನಿಲಿದಲ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊ; ತ್ಯುನೆ ಸು ಕಾಮ ಕರಾನು ಹೊತ್ತು ಪವಿತ್ರ ಆತ್ಮಾನಿ ಮದತಕ್ಹು ತ್ಯುನೊನೆ ತಿಳಶ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ಎ ತಿನಿ ಮೌತ ಥಯಲ್ಪರ ಥಯಲ ಸಂಗತಿಯೊ ವ್ಹೈ. ತೆ ಜಿವ್ತೊ ರ‍್ಹಯಲ ತೆ ಅಪೊಸ್ತಲೊನೆ ದೆಕಾಡಿನ ದಿದ್ಯೊ ವರಿ ತಿನಿ ತಾಕತಕ್ಹು ಘನ್ನಾ ಅದ್ಭುತ ಕಾಮೊ ಕರಾಕ್ಹು ತೆ ದೆಕಾಡಿನ ದಿದ್ಯೊ. ಯೆಸು ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯಲ್ಪರ ಚಾ಼ಳಕ್ಹ ದಿನ್ನ ಲಕ್ಕಾ ಅಪೊಸ್ತಲೊ ತಿನೆ ಘನ್ನಿ ಸಲಾ ದೆಕ್ಯಾ. ಯೆಸು ಕ್ಹುದಾನಾ ರಾಜ್ಯನಾ ಹುತಿ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ಯಕ್ಕ ಸಲಾ, ಯೆಸು ತ್ಯುನಾ ಕ್ಹಾತೆ ಅನ್ನ ಖಾತಾಮ, ಯೆರುಸಲೆಮ ಛೊಡಿನ ಜೌ಼ ನೈ ಕೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ\" ಬಾ ತುಮೊನೆ ಯಕ್ಕ ವಾಗ್ದಾನ ಕರ‍್ಯೊಸ. ಮಿ ಪೈಲಾಜ಼ ತಿನಾ ಹುತಿ ತುಮೊನೆ ತಿಳ್ಸಾಯೊಸ. ಎ ವಾಗ್ದಾನನು ವರ್ದಾನ ಲಿವಾನಾ ಹುತಿ ಯೆರುಸಲೆಮಮಾ ಕೈದತ್ತಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ಯೊಹಾನ ಮನಕ್ಹೊನೆ ಪಾನಿಮಾ ಬಾಪ್ತಿಸ್ಮ ಕರಾಯೊ, ತೆನೈಸೊ ಹಜು಼ನ ದಕ್ಹಾ ದಿನೊಮಾ ತುಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾಮಾ ಬಾಪ್ತಿಸ್ಮ ಥಾವಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ಅಪೊಸ್ತಲೊ ಕ್ಹಾರಾ ಮಳ್ತಾಮಾ, ತ್ಯುನೆ ಯೆಸುನೆ\"ಪ್ರಭು, ತು ಇಸ್ರಾಲಯನಾ ಮನಕ್ಹೊನೆ ತ್ಯುನಿ ರಾಜ್ಯ ಫರಿನ ದಿವಾನು ಎಜ಼ ಟೈಮಮಾ ವ್ಹೈಸು? ಕೈನ ಪುಚ಼್ತಾಮಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ಯೆಸು ತ್ಯುನೊನೆ, ಕೆಳೆ ಕಿನೆ ಸು ದ್ಯು ಕಯಾ ಟೈಮಮಾ ದ್ಯು ಕವಾನಾ ಅದಿಕಾರ ರ‍್ಹಯಲ ಬಾನೆ ಯಕ್ಕಜ಼ ವ್ಹೈ. ತುಮೆ ತೆ ಕ್ಹಾರು ತಿಳ್ದಿಲಿವಾನೆ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ತೆನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾ ತುಮೊಪರ ಆಯಲ ಟೈಮಮಾ ತಾಕತ ವ್ಹಂದಿಲಿನ ಯೆರುಸಲೆಮಮಾ ಪುರಾ ಯುದೆಯಮಾಬಿ ಸಮರ್ಯಾಮಾಬಿ ವರಿ ಭುಲೊಕಮಾ ಹರ ಜ಼ಗಾ ಸಾಕ್ಷಿ ಥೈನ ರ‍್ಹವೊಶಿ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ಯೆಸು ಎ ಸಂಗತಿಯೊ ಅಪೊಸ್ತಲೊನೆ ಕದಲ್ಪರ ಅಪೊಸ್ತಲೊ ದೆಕ್ತಾ ರ‍್ಹತಾಮಾಜ಼ ಹಬಾಳ ಪರ ಯೆಸುನೆ ಉಚೈ ಲಿದ್ಯಾ. ಮ್ಹಾಡ ತಿನೆ ಜಾ಼ಕಿಪಾಡಲ ಹುತಿ ತ್ಯುನೆ ತಿನೆ ದೆಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ಯೆಸು ಜಾ಼ತಾಮಾ ಅಪೊಸ್ತಲೊ ಹಬಾಳನೆಜ಼ ದೆಕ್ತಾ ಹುಬ್ರಯಾತಾ. ತೆಳಾಮಾ, ಧೊಳಾ ವಣ್ಣಾ ಘಾಲ್ಲಿದಲ ಬೆ ಜ಼ನಾ ದಾಣ್ಗಾ ತ್ಯುನಾಕ್ಹು ತ್ಯುನೆ ತಿನಾ ಬಾಜು಼ಮಾ ಹುಬ್ರೈನ, ");
INSERT INTO sle_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","\"ಗಲಿಲಾಯವಾಲಾ ಕಾ ಹಬಾಳನೆಜ಼ ದೆಕ್ತಾ ಹುಬ್ರಯಾಸ? ಯೆಸು ತುಮಾರಾ ಡೊಳಾವೊನಾ ಕ್ಹಾಮೊ ಸ್ವರ್ಗನೆ ಕಿಮ್ಮ ಗಯೊ ತಿನಾ ಲಿಂಗತಜ಼ ವಾಪಸ ಆವಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ಪಾಚಾ಼ತಾ ಅಪೊಸ್ತಲೊ ಆಲಿವ ಝಾಡೊನಾ ಡೊಂಗರತಾ ಯೆರುಸಲೆಮನೆ ವಾಪಸ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ಅಪೊಸ್ತಲೊ ಗಾಮಮಾ ಐನ ತ್ಯುನೆ ರ‍್ಹಯಲ ಜ಼ಗಾಯೆ ಗಯಾ. ತೆ ಉಪ್ಪರಲ್ಯಾ ಮಹಡಿ ಪರ ವ್ಹತ್ತು. ತೆ ಅಪೊಸ್ತಲೊ ಕುನ್ನ-ಕುನ್ನ ವ್ಹೈ ಕದ್ಯಾಮ; ಪೆತ್ರಾ, ಯೊಹಾನ, ಯಾಕೊಬ, ಅಂದ್ರೆಯ, ಫಿಲಿಪ್ಪ, ತೊಮ, ಬಾರತೊಲೊಮಾಯ, ಮತ್ತಾಯ, ಯಾಕೊಬ (ಅಲ್ಫಾಯನೊ ದಿಕ್ರೊ) ದೆಶನೊ ಮಯಾ ಥಯಲ ಸಿಮೊನ ವರಿ ಯಾಕೊಬ್ನೊ ದಿಕ್ರೊ ಯುದ. ");
INSERT INTO sle_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ಅಪೊಸ್ತಲೊ ಕ್ಹಾರಾ ಮಳಿನ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಯಕ್ಕಜ಼ ಉದ್ದೆಶಕ್ಹು ಛೊಡ್ಯಾವಾಚಿ ಪ್ರಾಥನಾ ಕರಾಡಾತಾ. ದಕ್ಹಿಯೊ ಬಾಕ್ಡಿಯೊನೆ ಯೆಸುನಿ ಯಾ ಮರಿಯಳ ತಿನಾ ಭಾಯೊ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ದಕ್ಹಾ ದಿನ್ನ ಥಯಲ್ಪರ ವಿಸ್ವಾಸಿಮಾ ಭಾಯೊ ಥಯಲ ಸಭೆ ಥೈನ ಮಳ್ಯಾತಾ. ತ್ಯಾ ಕಮ್ಸಿ ಕಮ್ಮ ಯಕ್ಹೊನ ಇಕ್ಹ ಜ಼ನಾ ವ್ಹತ್ತಾ. ಪೆತ್ರಾ ಉಟಿನ ಹುಬ್ರೈನ ಅಮ್ಮ ಕದ್ಯೊ; ");
INSERT INTO sle_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"ಭಾಯೊ ಭೆನೊ, ಪವಿತ್ರ ಆತ್ಮಾ ದಾವಿದನಾ ಮುಲಕ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಪೈಲಾಜ಼ ಕದಲ ಸಂಗತಿಯೊ ಪುರಾ ಥಾವಾನು ವ್ಹತ್ತು. ಅಪ್ನಾ ಸ್ವಂತ ಗುಂಪಮಾನೊ ಯುದನ ಹುತಿ ದಾವಿದ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ಯುದ ಅಪ್ನಾ ಕ್ಹಾತೆ ಸೆವೆ ಕರ‍್ಯೊ. ಯೆಸುನೆ ಧರೆಲಕ್ಕಾ ಯುದ ವಾಟ ದೆಕಾಡಾಲೊ ಥಾವಸ ಕೈನ ಪವಿತ್ರ ಆತ್ಮಾ ತಿಳಸಾಯೊತೊ\" ");
INSERT INTO sle_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ಎ ಮೊಸನು ಕಾಮ ಕರಾನೆ ಯುದನೆ ದೊಕ್ಡಾ ದಿದ್ಯಾತಾ. ತೆ ದೊಕ್ಡಾಕ್ಹು ಯಕ್ಕ ಖೆತರ ತಿನಾಹುತಿ ಲಿದ್ಯಾ. ತೆನೈಸೊ ಯುದ ಮಾತು ಹೆಟು ಕರಿನ ಪಡಲ್ಪರ ತಿನು ಪೆಟ ಫುಟಿ ಗೈಯು. ತಿನಾ ಕ್ಹಾರಾ ಅತ್ತೊಡಾ ಭಾರಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ಆ ಕ್ಹಾರು ಯೆರುಸಲೆಮನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ಥೈಯು. ತಿನಾಹುತಿ ತ್ಯುನೆ ತೆ ಖೆತರನೆ ಅಕೆಲ್ದಮಾ ಕೈನ ನಾಮ ಮ್ಹೆಲ್ಯಾ. ತ್ಯುನಾ ವಾತೊಮಾ ಅಕೆಲ್ದಮಾ ಕದ್ಯಾಮ ‘ರಗತನು ಹೊಂಡ’ ಕದಲ ಲಿಂಗತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ತಿನು ಘರ ಹಾಳ ಥಾವಾದೆ! ತ್ಯಾ ಕುನ್ನಜ಼ ರ‍್ಹಯಲ ನೈಸೊ ಥಾವಾದೆ. ಕಿರ್ತನೆ. 69:25 ಕೈನ ಕಿರ್ತನೆನಾ ಪುಸ್ತಕಮಾ ಯುದನಾ ಹುತಿ ಲಿಕ್ಕಲ ಛೆ ತೆನೈಸೊ ಬಿಜೆಕ್ಲೊ ತಿನು ಕಾಮ ಲಿವಾದೆ’ ಕಿರ್ತನೆ. 109:8 ಕೈನ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ತಿನಾಹುತಿ ಬಿಜೆಕ್ಲೊ ಹಮಾರಾ ಕ್ಹಾತೆ ಮಳಿನ, ಯೆಸುನು ಪುನರುತ್ಥಾನನೆ ಸಾಕ್ಷಿ ಥೌ. ಪ್ರಭು ಥಯಲ ಯೆಸು ಅಪ್ನೊಕನ ರ‍್ಹತಾಮಾ ತೆ ಅಪ್ನಾ ಗುಂಪಮಾ ರ‍್ಹಯಲ ವಾಲಾವೊಮಾನೊ ಯಕ್ಲೊ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ಯೊಹಾನ ಬಾಪ್ತಿಸ್ಮ ದಿವಾನಾ ಶುರು ಕರಲ ದಿನ್ನತೊ ಧರಿನ ಯೆಸು ಅಪ್ನೊಕಂತೊ ಸ್ವರ್ಗನೆ ಗಯಲ ದಿನ್ನ ಲಕ್ಕಾ ಅಪ್ನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲೊ ರ‍್ಹೌ\" ");
INSERT INTO sle_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ಅಪೊಸ್ತಲೊ ಬೆ ಜ಼ನಾವೊನೆ ಸಭೆನಾ ಕ್ಹಾಮಾ ಹುಬ್ರಾಡ್ಯಾ. ಯಕ್ಲೊ ಬಾರಸಬ ಕವಾಲೊ ಯೊಸೆಫ. ಅನೆ ಯುಸ್ತ ಕೈನ ಬಲಾತಾತಾ. ವರಿ ಯಕ್ಲೊ ಮತ್ತೀಯ. ");
INSERT INTO sle_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ಮತ್ತಿಯವಾವೊನೆ ಬೆ ಜ಼ನಾವೊ ಹುಬ್ರಾಡಿನ ಪ್ರಾರ್ಥನೆ ಕರತ್ತೊ,ಕರ್ತಾ ಕ್ಹಾರಾವೊನಾ ಮನಸ್ಸ ವಳಾಕಾವಾಲೊ ಯುದ ಅಪೊಸ್ತಲ ಕವಾಲೊ ತೆ ಸೆವಾ ಜ಼ಗಾಕ್ಹು ಹಾಳ ಥೈನ ತೆ ನೈಜಾ಼ವಾನು ಜ಼ಗಾಕನ ಗಯೆಲಕ್ಹು ತೆ ಸ್ಥಾನ ಹೊಂದಾನಾಹುತಿ ತೆ ಬೆಜ಼ನಾವೊಮಾ ತು ಇನಿಲಿದಲ ದೆಕಾಡಿನ ದ್ಯುಕೈನ ಪ್ರಾರ್ಥಾನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ತೆಳಾಮಾ ತ್ಯುನೆ ಅಮ್ಮ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ\" ಪ್ರಭು ತು ಕ್ಹಾರಾ ಮನಕ್ಹೊನು ಮನಸ್ಸ ತಿಳ್ದಿಲಿದ್ಯೊಸ. ಎ ಕಾಮ ಕರಾನಾ ಹುತಿ ಎ ಬೆ ಜ಼ನಾವೊಮಾ ತು ಕಿನೆ ಇನಿಲಿದ್ಯೊಸ ಕವಾನು ಹಮೊನೆ ದೆಕಾಡ. ಯುದ ಎ ಕಾಮನೆ ವಿರುದ್ದ ಥೈನ ತೆ ಕಿಜಾ಼ ಜಾ಼ವಾನು ವ್ಹತ್ತು ತ್ಯಾ ಗಯೊ. ಪ್ರಭು, ತಿನಿ ಜ಼ಗಾಪರ ಅಪೊಸ್ತಲ ಕುನ್ನ ಥೌ ಕೈನ ಹಮೊನೆ ದೆಕಾಡ\" ");
INSERT INTO sle_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ಪಾಚಾ಼ತಾ ಅಪೊಸ್ತಲೊ ತ್ಯುನಾ ಬೆ ಜ಼ನಾವೊಮಾ ಇನಿಲಿವಾನೆ ಚಿಟಿ ಘಾಲ್ಯಾ. ಚಿಟಿ ಮತ್ತಿಯನೆ ಆಯಲ ಹುತಿ ಗ್ಯಾರಾ ಜ಼ನಾವೊನಾ ಕ್ಹಾತೆ ತೆಬಿ ಅಪೊಸ್ತಲ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ಪಂಚಾಶತ್ತಮ ಸನ್ನಮಾ ತ್ಯುನೆ ಕ್ಹಾರಾ ಜ಼ನಾ ಯಕ್ಕ ಜ಼ಗಾ ಮಳಿನ ಆಯಾ ತೆಳಾಮಾ, ಯಕ್ಕ ದುಮ್ಮ ಹಬಾಳಮಾತು ಯಕ್ಕ ಆವಾಜ಼ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ತುಫಾನ ಆವಾಡುಸ ಕೌ ತಿಮ್ಮ ವ್ಹತ್ತು ತೆ ಆವಾಜ಼. ತ್ಯುನೆ ಬೈಟಲ ಘರಮಾ ಪುರಾ ತೆ ಆವಾಜ಼ ಭರಿ ಗಯುತು. ");
INSERT INTO sle_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ತೆನೈಸೊ ಆಗ ಲಿಂಗತ ರ‍್ಹಯಲ ಸುಯಕ್ಕ ತ್ಯುನೆ ದೆಕ್ಯಾ. ತೆ ಆಗ ಜು಼ದಿ ಥೈನ ತ್ಯಾ ರ‍್ಹಯಲ ಹರಯಕ್ಕ ಮನಕ್ಹ ಪರ ಗೈನ ಹುಬ್ರಯು. ");
INSERT INTO sle_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ತ್ಯುನೆ ಕ್ಹಾರಾ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರ‍ಲ ವ್ಹತ್ತಾ ವರಿ ಬಿಜಾ಼-ಬಿಜಾ಼ ಭಾಶಾಮಾ ಬೊಲಾನು ಶುರು ಕರ‍್ಯಾ. ಪವಿತ್ರ ಆತ್ಮಾಜ಼಼ ತ್ಯುನೊನೆ ತೆ ತಾಕತ ದಿದ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ಘನ್ನಾ ಧಾರಮಿಕೊ ಘನ್ನಾ ಯೆಹುದಿಯೊ ತೆ ಟೈಮಮಾ ಯೆರುಸಲೆಮಮಾ ವ್ಹತ್ತಾ. ತ್ಯುನಾಮಾ ಜಗತನಾ ಹರಯಕ್ಕ ದೆಶತಾ ಆಯಲ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ತೆ ಆವಾಜ಼ ಐಕಿನ ತೆ ಮನಕ್ಹೊ ಗುಂಪ ಥೈನ ಮಳಿನ ಐನ ಅಪೊಸ್ತಲೊ ಬೊಲಾನು ಹರ ಯಕ್ಲಾನೆ ತ್ಯುನಿ ತ್ಯುನಿ ಭಾಶಾಮಾ ಐಕು ಆವಾನು ದೆಕಿನ ತ್ಯುನೆ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ಎ ದೆಕಲ ಕ್ಹಾರಾ ಜ಼ನಾ ಘಾಬ್ರಾ ಥಯಾ. ಇಮ್ಮ ಕರಾನೆ ಅಪೊಸ್ತಲೊನೆ ಕಿಮ್ಮ ಸಾಧ್ಯ ಥಯು ಕೈನ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಥಯು ನೈ\" ಬೊಲ್ತಾ ರ‍್ಹಯಲ ಎ ಮನಕ್ಹೊ (ಅಪೊಸ್ತಲೊ) ಗಲಿಲಾಯನಾ ನ್ಹವೈಸು. ");
INSERT INTO sle_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ತೆನೈಸೊ ಇವ್ನೆ ಅಪ್ನಿ ಸ್ವಂತ ಭಾಶಾಮಾ ಬೊಲಲ ಲಿಂಗತ ಐಕಾಡಾಸ್ತೊ, ಎ ಕಿಮ್ಮ ಸಾಧ್ಯ ಛೆ? ಅಪೆ ಬಿಜಿ಼ ಬಿಜಿ಼ ಜ಼ಗಾನಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ಅಪ್ನೊಮಾ ಪಾರಥ್ಯರೊ, ಮೆದ್ಯರೊ, ಎಲಾಮ್ಯರೊ, ಮೆಸೊಪೊತಾಮ್ಯರೊ, ಯುದಾಯರೊ, ಕಪ್ಪದೊಕ್ಕಯರೊ, ಪೊಂತ, ಆಸ್ಯ, ಫ್ರುಗ್ಯ, ಪಂಫುಲ, ");
INSERT INTO sle_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ಫ್ರಿಜಿನಾ ಮನಕ್ಹೊ,ಪಾಂಫಿಲಿನಾ ಮನಕ್ಹೊ,ಇಜಿಪ್ತನಾ ವರಿ ಸಿರೆನಾ ಕ್ಹಾಮಾ ಲಿವಿನಾ ಕ್ಹಾಂದಾನಾ ರೊಮ್ನಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ಧರಮನೆ ಚಾ಼ಲಾಲಾ ಕ್ರೆತ್ಯವಾಲಾ ವರಿ ಅರಬಿ ದೆಶನಾ ಛೆ. ಅಪೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಹುಟ್ಟಲತಾಬಿ ಯೆಹುದಿಯೊ ವ್ಹೈ. ಬಾಕಿನಾ ಪರಿವರ್ತನ ವ್ಹಂದಲವಾಲಾ ವ್ಹೈ. ಅಪೆ ಬಿಜಾ಼ ಬಿಜಾ಼ ದೆಶನಾ ವ್ಹೈ. ತೆನೈಸೊ ಎ ಮನಕ್ಹೊ ಬೊಲಾನು ಅಪ್ನಿ ಸ್ವಂತ ಭಾಶಾಮಾ ಅಪೊನೆ ಐಕು ಆವಾಡುಸ! ತ್ಯುನೆ ಕ್ಹುದಾನಾ ಹುತಿ ಕವಾನಿ ಮ್ಹೊಟಿಯೊ ಸಂಗತಿಯೊ ಅಪೊನೆ ಕ್ಹಾರಾವೊನೆ ಗ್ವತ್ತ ಥಾವಾಡುಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ಕ್ಹಾರಾ ಘಾಬ್ರಾ ಥಯಾ. ತ್ಯುನೆ \"ಎ ಸು ಥಾವಾಡುಸ? ಕೈನ ಯಕ್ಕನೆ ಯಕ್ಕ ಪುಚ್ಚಾ಼ಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ದಕ್ಹಾಜ಼಼ನಾ ಅಪೊಸ್ತಲೊನೆ ದೆಕಿನ ಅಕ್ಹಾತಾ\"ಇವ್ನೆ ಘನ್ನು ದ್ರಾಕ್ಷಾ ರಕ್ಹ ಪಿನ ಅಮ್ಮ ಕರಾಡಾಸ\" ಕೈನ ಕದ್ರಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ತೆಳಾಮಾ ಪೆತ್ರಾ ಗ್ಯಾರಾ ಜ಼ನಾ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾತೆ ಉಟಿನ ಹುಬ್ರಯೊ. ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಘಟ್ಟ ಆವಾಜ಼ಕ್ಹು ಅಮ್ಮ ಕದ್ಯೊ \"ಯೆಹುದ್ಯೊ, ಯೆರುಸಲೆಮಮಾ ರ‍್ಹವಾನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ, ಮಿ ಕವಾನು ಕಾನ ದಿನ ಐಕೊ. ತುಮೆ ತಿಳ್ದಿಲಿವಾನಿಯೊ ಸಂಗತಿಯೊ ಮಿ ತುಮೊನೆ ಕೌಸ. ");
INSERT INTO sle_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ತುಮೆ ತಿಳ್ದಿಲಿದಲ ಲಿಂಗತ ಎ ಮನಕ್ಹೊ ನಶಾಮಾ ರ‍್ಹಯಲವಾಲಾ ನ್ಹವೈ. ಹಮ್ನಾ ಪಾಟ್ನಾ ನೌ ವಾಜಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ತೆನೈಸೊ ಆ ಟೈಮಮಾ ನ್ಹ್ಯಾ ಥಾವಾನಿಯೊ ಸಂಗತಿಯೊನಾ ಹುತಿ ಪ್ರವಾದಿ ಥಯಲ ಯೊವೆಲ ಅಮ್ಮ ಬರ್ದ್ಯೊಸ; ");
INSERT INTO sle_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ಕ್ಹುದಾ ಅಮ್ಮ ಕವಸ; ಲಾಸ್ಟನಾ ದಿನೊಮಾ ಮಾರಿ ಆತ್ಮಾ ಖಾರಾವೊಪರ ಆವಸ ತೆನೈಸೊ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ದಾಣ್ಗಾ ವರಿ ಬಾಕ್ಡಿಯೊ ಪ್ರವಾದನೆ ಕರಸ ವರಿ ಜಾಂಜಿಮಾನೊನೆ ದರ್ಶನ ಥಾವಸ ತುಮಾರಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊನೆ ಕ್ಹಪನೊ ಪಡಸ ");
INSERT INTO sle_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ತೆನೈಸೊ ತೆ ದಿನೊಮಾ ಮಿ ಮಾರಾ ದಾಸ ದಾಸಿಯೊನಾ ಉಪ್ಪರ ಮಾರಿ ಆತ್ಮಾ ಘಾಲುಸ. ತ್ಯುನೆ ಪ್ರವಾದನೆ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ಮಿ ಹಬಾಳ ಪರ ಅದ್ಭುತ ಕಾಮೊ ಕರಿನ ದೆಕಾಡುಸ, ಜಿಮಿನಪರ ಮ್ಹೊಟಾ ಕಾಮೊ ದೆಕೊಶಿ, ರಗತ ಆಗನು ವಾಪಲಿಂಗತ ಧವಾಂಡೊ ದೆಕೊಸಿ ");
INSERT INTO sle_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ಸುರ‍್ಯೊ ಅಂದಾರೊ ಥಾವಸ,ಚಂದಪ್ಪಾ ರಗತನಾ ರಂಗನೊ ಥಾವಸ ");
INSERT INTO sle_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ತೆನೈಸೊ ಕರ್ತಾನು ನಾಮ ಕೈಲಿವಾಲಾವೊನೆ ರಕ್ಷಣೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊ ಎ ವಾತೊ ಐಕೊ ಕ್ಹುದಾನಜರೆತನಾ ಯೆಸುನಾ ಮುಲಕ ಕರಲ ಮ್ಹೊಟಾ ಕಾಮೊ ವರಿ ಅದ್ಭುತ ಕಾಮೊನಾ ಮುಲಕ ತೆ ಚೊ಼ಕಿ ತರಾ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ಎ ಸಂಗತಿಯೊ ತುಮೆ ಕ್ಹಾರಾ ಜ಼ನಾ ದೆಕ್ಯಾಸ. ತಿನಾಹುತಿ ಎ ಕ್ಹಾರು ಕ್ಹರಿಜ಼ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ಯೆಸುನೆ ತುಮೊಕನ ವಪ್ಸಾಯಾ. ತುಮೆ ಕೆಟ್ಟ ಮನಕ್ಹೊನಾ ಮದತಕ್ಹು ತಿನೆ ಶಿಲುಬಿ ಪರ ಘಾಲ್ಯಾ. ತೆನೈಸೊ ಎ ಕ್ಹಾರು ಥಾವಸ ಕವಾನು ಕ್ಹುದಾನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ಎ ಕ್ಹುದಾನಿ ಚಿತ್ತ ವ್ಹತ್ತಿ. ಘನ್ನಾ ಟೈಮನಾ ಪಾಚೊ಼ಜ಼ ಎ ಫೈಸ್ಲೊ ಥಯಲ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ಯೆಸು ಮೌತನೊ ತ್ರಾಸ ಖಾದ್ಯೊ. ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನೆ ಛೊಡಾಯೊ. ಕ್ಹುದಾ ಯೆಸುನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡ್ಯೊ. ಮೌತನೆಬಿ ಯೆಸುನೆ ಧರಲಿವಾನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ದಾವಿದ ಯೆಸುನಾ ವಿಷಯನಾ ಹುತಿ ಅಮ್ಮ ಕದ್ಯೊಸ ಕರ್ತಾ ಹಮೆಶಾಬಿ ಮಾರಾಖಾತೆ ಛೆ ಮಿ ಕೆಳೆಜ ಪಡು ನೈಕೈನ ತೆ ಮಾರಾ ಬಾಜು಼ಮಾ ಛ. ");
INSERT INTO sle_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ತಿನಾಹುತಿ ಮಾರಾ ಮನಸ್ಮಾ ಖುಶಿ ಥಾವಸ. ಮಾರಿ ಜಿಬ್ ಕೆಳಾಮಾಬಿ ಜೊಸಖು ತಿನೆ ಸ್ತೊತ್ರ ಕವಸ ಮಾರು ಅಂಗ ಕೆಳಾಮಾಬಿ ನಿರಾಸೆ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ಕಾಕದ್ಯಾಮ ತು ಮಾರಿ ಜಿವ ಆತ್ಮಾನೆ ಪಾತಾಳಮಾ ಛೊಡತೊ ನೈ. ತಾರಾ ಮಯಾನಾ ಆಳನೆ ಪಡೆಲ ಜ಼ಗಾ ಪಡಾನೆ ದಿನ ಕ್ಹಡಾನೆ ದಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ತು ಮನೆ ಜ್ಯು ಮಳಾನಿ ವಾಟ ದೆಕಾಡಿನ ದಿದ್ಯೊ ತಾರಾ ಪ್ರಸನ್ನತೆಮಾ ಕ್ಹುಶಿ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","\"ಮಾರಾ ಭಾಯೊ ಭೆನ, ಅಪ್ನೊ ಮುಲ ಪಿತೃ ಥಯಲ ದಾವಿದನಾ ವಿಷಯಮಾ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ. ತೆ ಮರಿ ಗಯೊ ವರಿ ತಿನಿ ಸಮಾದಿ ಥೈ. ತಿನಿ ಸಮಾದಿ ಅಪ್ನಾ ವಚ್ಮಾ಼ ಎ ದಿನ್ನ ಲಕ್ಕಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ದಾವಿದ ಯಕ್ಕ ಪ್ರವಾದಿ ವ್ಹತ್ತೊ ವರಿ ‘ತಾರಾ ಘರನಾ ಯಕ್ಲಾನೆ ತಾರಾ ಲಿಂಗತ ರಾಜೊ಼ ಕರುಸ’ ಕೈನ ಕ್ಹುದಾ ತಿನೆ ಕ್ಹಮ್ಮ ಘಾಲಿನ ವಾಗ್ದಾನ ಕರಲ ತಿನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ತೆ ಥಾವಾತಿ ಪೈಲಾಜ಼ ದಾವಿದನೆ ಗ್ವತ್ತ ಥಯುತು. ತಿನಾಹುತಿ ದಾವಿದ ಮೌತಮಾತೊ ಜಿವ್ತೊ ಥಾವಾನಾ ಕ್ರಿಸ್ತನಾ ಹುತಿ ತಿನೆ ಪಾತಾಳಮಾ ಛೊಡತಾ ನೈ ತಿನು ಅಂಗ ನೈ ಕ್ಹಡತು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ತಿನಾಹುತಿ ಕ್ಹುದಾ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡಲ ಯೆಸುನೆಜ಼ ಅಪೆ ಕ್ಹಾರಾ ಜ಼ನಾ ಸಾಕ್ಷಿಯೊ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ಯೆಸು ಸ್ವರ್ಗನೆ ಗಯೊ. ಹಮ್ನಾ ಯೆಸು ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಛೆ, ಕ್ಹುದಾನಾ ಸಿದಾ ಬಗಲ ಛೆ. ಹಮ್ನಾ ಬಾ (ಕ್ಹುದಾ) ಪವಿತ್ರ ಆತ್ಮಾ ಯೆಸುನೆ ದಿದ್ಯೊಸ. ಪವಿತ್ರ ಆತ್ಮಾ ದಿವ್ಸ ಕೈನ ಕ್ಹುದಾ ವಾಗ್ದಾನ ಕರ‍್ಯೊತೊ. ತಿನಾಹುತಿ ಯೆಸು ಹಮ್ನಾ ತೆ ಆತ್ಮಾನೆ ದಿದ್ಯೊಸ. ತುಮೆ ದೆಕಾನು ವರಿ ಐಕಾನು ಆಜ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ಸ್ವರ್ಗನೆ ಗಯಲವಾಲೊ ದಾವಿದ ನ್ಹವೈ, ಯೆಸುಜ಼ ವ್ಹೈ. ದಾವಿದಜ಼ ಇನಾ ಹುತಿ ಕವಸ, ");
INSERT INTO sle_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ಮಿ ತಾರಾ ವಿರೊಧಿಯೊನೆ ತಾರಾ ಪಗನು ಥಳ ಕರೆಲಕ್ಕಾ ತು ಮಾರಾ ಬಾಜು಼ಮಾ ಬೈಟಶಿ ಕೈನ ಕ್ಹುದಾ ಥಯಲ ಕರ್ತಾ ಮಾರಾ ಕರ್ತಾನೆ ಕದ್ಯೊ’ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","\"ತಿನಾಹುತಿ ಯೆಹುದಿಯೊ ಕ್ಹಾರಾ ಎ ಕ್ಹರಿಬಿ ತಿಳದಿಲಿವ. ಕ್ಹುದಾ ಯೆಸುನೆ ಪ್ರಭು ಥೈನ ಕ್ರಿಸ್ತ ಥೈನ ಕರ‍್ಯೊಸ. ತುಮೆ ಶಿಲುಬಿ ಪರ ಘಾಲ್ಯಲ ಮನಕ್ಹಜ಼ ತೆ ವ್ಹೈ\" ");
INSERT INTO sle_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ಎ ಐಕಲ ಪರ ತ್ಯಾನಾ ಪುರಾ ಮನಕ್ಹೊ, ತ್ಯುನಾ ಮನಸ್ಸೊಮಾ ಮ್ಹೆಲಿದ್ಯಲವಾಲಾ ಥೈನ ಪೆತ್ರನೆ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಅಪೊಸ್ತಲೊನೆ \"ಭಾಯೊ, ಹಮ್ನಾ ಹಮೆ ಸು ಕರು? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ಪೆತ್ರಾ ತ್ಯುನೊನೆ\"ತುಮೊಮಾನೊ ಹರಯಕ್ಲೊ ತುಮಾರಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾನಾ ಬಗಲ ಫರೊ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಮಾ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿವೊ. ತೆಳಾಮಾ ಕ್ಹುದಾ ತುಮಾರಾ ಪಾಪೊ ಮಾಫ ಕರಸ. ತೆನೈಸೊ ಕ್ಹುದಾ ವಾಗ್ದಾನ ಕರಲ ಪವಿತ್ರ ಆತ್ಮಾನೆ ವ್ಹಂದಿಲಿವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ತೆ ವಾಗ್ದಾನ ತುಮೊನೆ ತುಮಾರಾ ಬಚ್ಚಾವೊನೆ ದುರ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆಬಿ ದಿದಲ ಛೆ. ಅಪ್ನೊ ಕ್ಹುದಾ ಥಯಲ ಪ್ರಭು ತಿಕನ ಬಲಾವಾನಾ ಹರ ಯಕ್ಲಾನೆ ಎ ವಾಗ್ದಾನ ದಿದ್ಯೊಸ\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ಪೆತ್ರಾ ಹಜು಼ನ ಘನ್ನಾ ವಾತೊಕ್ಹು ತ್ಯುನೊನೆ ಹುಶಾರ ಕರಿನ\"ಎ ಕೆಟ್ಟ ಸಂತತಿವಾಲಾಕ್ಹು ಚು಼ಕೈಲಿವೊ\" ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ಪೆತ್ರಾನಿ ವಾತೊನೆ ವಪ್ಪಿಲಿದ್ಯಲವಾಲಾ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯಾ. ತೆ ದಿನ್ನ ತನ್ನ ಹಜಾ಼ರ ಮನಕ್ಹೊ ತ್ಯಾ ಮಳ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ಇವ್ನೆ ಅಪೊಸ್ತಲೊನಿ ಬೊಧನೆ ಐಕಾಮಾಬಿ ಭಾಯೊನಾ ಕ್ಹಾತೆ ರೊಕ್ಲೊ ತೊಡಾಮಾಬಿ ಪ್ರಾಥನಾ ಕರಾಮಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ಅಪೊಸ್ತಲೊ ಘನ್ನಾ ಚೊ಼ಕಾ ವರಿ ಅದ್ಭುತ ಕಾಮೊ ಕರಾಡಾತಾ; ವರಿ ಹರ ಯಕ್ಲಾನೆ ಕ್ಹುದಾ ಪರ ಭೆ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ಕ್ಹಾರಾ ವಿಶ್ವಾಸಿಯೊ ಮಳಿನ ರ‍್ಹವಾಡಾತಾ. ತ್ಯುನೆ ಹರ ಯಕ್ಕ ವಾಟಿ ಲಿವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ತ್ಯುನಾ ತ್ಯುನಾ ಆಸ್ತಿಯೊ ಇಕ್ಕಿನ ಆಯೆಲ ದೊಕಡಾಕ್ಹು ಕ್ಹಾರಾವೊನೆ ತ್ಯುನಾ ತ್ಯುನಾ ಜರುರತ್ತಕ್ಹು ವಾಟಿಲಿವಾಡಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ಹರಯಕ್ಕ ದಿನ್ನ ದೆವಾಲಯನೆ ಮಳಿನ ಆತಾತಾ. ತ್ಯುನಾ ಕ್ಹಾರಾವೊನು ಉದ್ದೆಶ ಯಕ್ಕಜ಼ ವ್ಹತ್ತು. ತ್ಯುನೆ ತ್ಯುನಾ ಘರೊಮಾನಾ ರೊಟ್ಲೊ ತೊಡಿನ ಮಳಿನ ಖಾತಾತಾ. ತ್ಯುನಾ ಮನಕ್ಹೊ ಖುಶಿಕ್ಹು ಭರಲವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ತ್ಯುನೆ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕತಾರ‍್ಹತಾತಾ ವರಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತಿನೆ ಪಸಂದ ಕತಾರ‍್ಹತಾತಾ ದಿನ್ನೆಬಿ ಘನ್ನಾ-ಘನ್ನಾ ಮನಕ್ಹೊ ರಕ್ಷಣೆ ವ್ಹಂದಿಲೆತಾತಾ; ಪ್ರಭು ತ್ಯುನೊನೆ ಕ್ಹಾರಾವೊನೆ ಸಭೆನೆ ಮಳಾತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ಯಕ್ಕ ದಿನ್ನ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ದುಪ್ಪಾರನಾ ಟೈಮೆ ತನ್ನ ವಾಸ್ತಾ ಚ಼ಾಲಾನೆ ಪ್ರಾಥನಾನಾ ಹುತಿ ದೆವಾಲಯನೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ದೆವಾಲಯಮಾ ಜ಼ಾವಾಲಾವೊಕಂತೊ ಭಿಕ ಮಾಂಗಾನಾಹುತಿ ತಿನೆ ದೆವಾಲಯನಾ ಸುಂದರ ದ್ವಾರಬಾಕಲಕನ್ನ ದಿನ್ನೆ ಬೈಟಾಡತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ತೆ ದೆವಾಲಯಮಾ ಜ಼ಾವಾಲಾ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ ದೆಕಿನ ಭಿಕ ದಿವೊ ಕೈನ ಪುಚ಼್ತಮಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಭಂಬಿಜ಼ನಾ ತಿನೆ ಯಕ್ಕಸಂವಾ ದೆಕಿನ. ಪೆತ್ರಾ \"ಹಮೊನೆ ದೆಕ\"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ತೆ ತ್ಯುನೊಕ್ಹು ಸುಬಿ ಮಳಸ ಕೈನ ತ್ಯುನೊನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ತೆಳಾಮಾ ಪೆತ್ರಾ ಕ್ಹೊನು ರುಪ್ಪುತೊ ಮಕನ ನತ್ತಿ, ಮಕನ ರವಾನು ತುನೆ ದ್ಯುಸ. ನಜರೆತನಾ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಪರ ಚಾ಼ಲ ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ತಿನೆ ಸಿದಾಹತ್ತ ಧರಿನ ಉಟಾಡ್ಯೊ. ತೆಳಾಮಾಜ಼ ತಿನಾ ಪಗೊಮಾ ವರಿ ಗುಡ್ಗಾವೊಮಾ ತಾಕತ ಐ; ");
INSERT INTO sle_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ತೆ ಜಿ಼ಗ್ದಿನ ಹುಬ್ರೈನ ಚ಼ಾಲ್ಯೊ; ಚ಼ಾಲ್ತೊ ಉಡತೊ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರ‍್ತೊ ತ್ಯುನಾ ಕ್ಹಾತೆ ದೆವಾಲಯಮಾ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ತೆ ಚ಼ಾಲಾನು ವರಿ ಕ್ಹುದಾನೆ ‍ಸ್ತುತಿ ಕರಾನು ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ದೆಕಿನ. ");
INSERT INTO sle_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ಎ ದೆವಾಲಯನಾ ಸುಂದರ ದ್ವಾರಬಾಕಲಕನ ಬೈಟಿನ ಭಿಕ ಮಾಂಗಾಲೊ ವ್ಹೈ. ಕೈನ ವಳಕಿನ. ತಿನೆ ಥಯಲ ಅದ್ಭುತ ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ. ಪೆತ್ರಾನು ದೆವಾಲಯಮಾ ಸಂದೆಶ ");
INSERT INTO sle_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ತೆ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ ಧರ್ಲಿನಜ಼ ರ‍್ಹತಾಮಾ ಘಾಬ್ರಾ ಥಯಲ ತೆ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ತ್ಯುನೊಕನ ಸೊಲೊಮೊನ ಕವಾನಾ ಮಂಟಪಕನ ರ‍್ಹಯಲ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನಕನ ಗುಂಪ ಗುಂಪ ಥೈನ ನ್ಹಾಟಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ಪೆತ್ರಾ ತಿನೆ ದೆಕಿನ ಇಸ್ರಾಯಲನಾ ಮನಕ್ಹೊ, ತುಮೆ ಕಾ ತಿಕ್ಹು ಘಾಬ್ರಾ ಥಾವೊಶಿ? ತುಮೆ ಹಮೊನೆ ಯಕ್ಕಸಂವಾ ದೆಕಾನು ಶಾನೆ ವ್ಹೈ. ಹಮೆ ಸ್ವಂತ ತಾಕತಕ್ಹು ರ‍್ಹವಾದೆ ಕ್ಹುದಾಪರ್ಲಿ ಭಕ್ತಿಕ್ಹು ಇನೆ ಚ಼ಾಲೆಲ ಲಿಂಗತ ಕರ‍್ಯಾಸ ಕೈನ ತಿಳ್ದಿಲಿವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ಆ ಕಾರ್ಯ ಕರಲ ಹಮೆ ನ್ಹವೈ ಕ್ಹುದಾ ವ್ಹೈ. ಅಬ್ರಹಾಮನೊ ಕ್ಹುದಾ, ಇಸಾಕನೊ ಕ್ಹುದಾ, ವರಿ ಯಾಕೊಬ್ನೊ ಕ್ಹುದಾ. ತೆಜ಼ ಅಪ್ನಾ ಕ್ಹಾರಾ ಪಿತೃವೊನೊ ಕ್ಹುದಾ ವ್ಹೈ. ತೆ ತಿನೊ ಖಾಸ ಸೆವಕ ಥಯಲ ಯೆಸುನೆ ಮಹಿಮಾ ಕರೆಯೆಸ. ತೆನೈಸೊ ತುಮೆ ಯೆಸುನೆ ಖಲಾಸ ಕರಾನೆ ವಪ್ಸಿನ ದಿದ್ಯಾ. ಯೆಸುನೆ ಛೊಡಾನೆ ಪಿಲಾತನ ಫೈಸ್ಲೊ ಕರ‍್ಯೊತೊ. ತೆನೈಸೊ ಪಿಲಾತನನೆ, ಹಮೊನೆ ಯೆಸು ನಕೊ ಕೈನ ಇನ್ಕಾರ‍ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ಯೆಸು ಪರಿಶುದ್ಧ ವ್ಹತ್ತೊ ವರಿ ಚೊ಼ಕು ವ್ಹತ್ತೊ. ತೆನೈಸೊ ತುಮೆ ತಿನೆ ಇನ್ಕಾರ‍್ಯಾ. ತಿನಾ ಬದ್ಲಿ ಕಲಾಸ ಕರಲವಾಲಾನೆ ಛೊಡು ಕೈನ ಪಿಲಾತನ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ಇಮ್ಮ ತುಮೆ ಜ಼ಲಮ ದಿವಾಲಾನೆ ಖಲಾಸ ಕರಾಯಾಸ! ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಉಟಾಡ್ಯೊ. ಇನೆ ಹಮೆಜ಼ ಸಾಕ್ಷಿಯೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","\"ತುಮಾರಾ ಡೊಳಾ ಕ್ಹಾಮು ರ‍್ಹವಾನು ಇನಿ ವಳಕ ತುಮೊನೆ ಕ್ಹಾರಾವೊನೆ ಛೆ. ಎ ಅರಾಮ ಥಯಲನೆ ಎ ಯೆಸುನಾ ನಾಮ ಪರ ಮ್ಹೆಲಲ ಬರೊಕ್ಹೊಜ಼ ಕಾರಣ ವ್ಹೈ. ತೆ ನಾಮಜ಼ ಅನೆ ತಾಕತಕ್ಹು ಭರ‍್ಯು. ತಿನಾ ಮುಲಕ ಥಯಲ ಬರೊಕ್ಹೊಜ಼ ಇನೆ ತುಮಾರಾ ಕ್ಹಾಮೊ ಅರಾಮ ಕರ‍್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","\"ಭಾಯೊ ತುಮೆ ಕರಲ ರ‍್ಹವಾದೆ, ತುಮೆ ಗ್ವತ್ತ ವಾಚಿ ಯೆಸುನೆ ಇಮ್ಮ ಕರ‍್ಯಾಸ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತುಮಾರಾ ನಾಯಕೊಬಿ ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ಕ್ರಿಸ್ತ ತ್ರಾಸ ಖೈನ ಮರಸ ಕೈನ ಕ್ಹುದಾ ತಿನಾ ಪ್ರವಾದಿಯೊನಾ ಮುಲಕ ಪೈಲಾಜ಼ ಕದಲ ಇಮ್ಮ ಪುರಾ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ತಿನಾಹುತಿ ತುಮೆ ತುಮಾರಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತ್ತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ಫರೊ. ತೆಳಾಮಾ ತೆ ತುಮಾರಾ ಪಾಪೊ ಮಾಫ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ತೆಳಾಮಾ ಪ್ರಭು ತುಮೊನೆ ಆತ್ಮಿಕನಿ ತಾಕತ ದಿವಸ. ತೆ ಕ್ರಿಸ್ತ ಕೈನ ಇನಿಲಿದಲ ಯೆಸುನೆಜ಼ ತುಮೊನೆ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","\"ತೆನೈಸೊ ಕ್ಹಾರು ಸಿದಾ ಕರಾನೊ ದಿನ್ನ ಆಯೆ ಲಕ್ಕಾ ಯೆಸು ಸ್ವರ್ಗಮಾಜ಼ ರ‍್ಹೌ. ಕ್ಹುದಾ ಘನ್ನಾ ದಿನ್ನನಾ ಪಾಚೊಜ಼ ತಿನಾ ಪವಿತ್ರ ಪ್ರವಾದಿಯೊನಾ ಸಂದೆಶನಾ ಮುಲಕ ಬೊಲಲ ಪರ, ಎ ಕಾಲನಾ ಹುತಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ತಿನಾಹುತಿ ಮೊಶೆ ಅಮ್ಮ ಕದ್ಯೊಸ \"ತುಮಾರೊ ಕ್ಹುದಾ ಥಯಲ ಪ್ರಭು ತುಮೊನೆ ಯಕ್ಕ ಪ್ರವಾದಿ ದಿವಸ. ತುಮಾರಾ ಭಾಯೊನಾ ವಚ್ಮಾತೊಜ಼ ತೆ ಪ್ರವಾದಿ ಆವಸ. ತೆ ಮಾರಾ ಲಿಂಗತಜ಼ ರ‍್ಹವಸ. ತೆ ಪ್ರವಾದಿ ಕವಾನಿ ಹರಯಕ್ಕನೆಬಿ ತುಮೆ ವಿಧೆಯ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ತಿನೆ ನೈ ವಿಧೆಯ ಥಯಲವಾಲಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊಕ್ಹು ಜು಼ದೊ ಕರಿನ ಹಾಳ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","\"ಸಮುವೆಲ ವರಿ ತಿಪರ್ತಾ ಆಯಲ ಪ್ರವಾದಿಯೊ ಎ ದಿನೊಮಾ ಥಾವಾನಾ ಹುತಿ ಪೈಲಾಜ ಕದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ತೆ ಪ್ರವಾದಿಯೊ ಕದಲ ಸಂಗತಿಯೊ ತುಮೆ ಸ್ವಿಕಾರ ಕರಿಲಿದ್ಯಾಸ. ಕ್ಹುದಾ ತುಮಾರಾ ಪಿತೃವೊನಾ ಕ್ಹಾತೆ ಬೊಲಲ ವಾತೊ ತುಮೆ ಸ್ವಿಕಾರ ಕರಿಲಿದ್ಯಾಸ. ಕ್ಹುದಾ ತುಮಾರೊ ಪಿತೃ ಥಯಲ ಅಬ್ರಹಾಮನೆ, ‘ತಾರಿ ಸಂತತಿಕ್ಹು ಜಿಮಿನಪರ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಆಶಿರ್ವಾದ ವ್ಹಂದಿಲಿವಸ’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ಕ್ಹುದಾ ತಿನಾ ಖಾಸ ಸೆವಕನೆ ಮೌತಮಾತೊ ಉಟಾಡಿನ ಪೈಲಾ ತುಮೊಕನ ವಳಾಯೊ. ತುಮೊನೆ ಆಶಿರ್ವಾದ ದಿವಾನಾ ಹುತಿ ಕ್ಹುದಾ ಯೆಸುನೆ ವಳಾಯೊ. ತೆ ತುಮೊನೆ ತುಮಾರಾ ಕೆಟ್ಟಕಾಮೊಕ್ಹು ದುರ ಕರಿನ ಆಶಿರ್ವಾದ ಕರಸ\" ");
INSERT INTO sle_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲ್ತಾಮಾ, ದಕ್ಹಾ ಮನಕ್ಹೊ ತ್ಯುನೊಕನ ಆಯಾ. ತ್ಯಾ ದಕ್ಹಾ ಯಾಜಕೊ ವ್ಹತ್ತಾ. ದಕ್ಹಾ ಸದ್ದುಕಾಯರೊ ವ್ಹತ್ತಾ ವರಿ ದೆವಾಲಯ ಕೈದಾಲಾ ಸೈನಿಕೊನೊ ಅಧಿಪತಿ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ಎ ಭಂಬಿ ಅಪೊಸ್ತಲೊ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರಾನು ದೆಕಿನ ತ್ಯುನೆ ಶಿಟ್ಟ ಥಯಾತಾ. ಯೆಸುನಿ ತಾಕತಕ್ಹು ಮನಕ್ಹೊ ಪುನರುತ್ಥಾನ ಥಾವಸ ಕೈನ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ ಧರಿನ ಮರ್ನಾ ದಿನ್ನ ಲಕ್ಕಾ ಜೆಲ್ಮಾ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ತೆನೈಸೊ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನಿ ಬೊಧನೆ ಐಕಿನ ಘನ್ನಾ ಮನಕ್ಹೊ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ತೆಳಾಮಾ ತೆ ಪಂಚಾತಿಮಾ ವಿಶ್ವಾಸಿಯೊ ಥಯಲ ದಾಣ್ಗಾವೊನಾ ಇಸಾಬ ಪಾಂಚ಼ ಹಜಾ಼ರನೆ ಚ಼ಡ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ಮರ್ನಾ ದಿನ್ನೆ ಯೆಹುದಿ ನಾಯಕೊ, ಯೆಹುದಿನಾ ಮ್ಹೊಟಾ ಶಾನಾ ನಾಯಕೊ ವರಿ ಧರಮ ಶಿಕ್ಲಾವಾನಾ ಯೆರುಸಲೆಮಮಾ ಸಭೆ ಥೈನ ಮಳ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ತ್ಯಾ ಮ್ಹೊಟೊ ಯಾಜಕ ಅನ್ನಸ, ಕಾಯಫ,ಯೊಹಾನ ವರಿ ಅಲೆಕ್ಸಾಂಡರ ವ್ಹತ್ತಾ. ಮ್ಹೊಟಾ ಯಾಜಕನಾ ಘರವಾಲಾ ಕ್ಹಾರಾ ಜ಼ನಾ ತ್ಯಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ತ್ಯುನೆ ಪೆತ್ರಾ ಯೊಹಾನನೆ ತ್ಯಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ಹುಬ್ರಾಡ್ಯಾ. ಯೆಹುದಿ ನಾಯಕೊ ತ್ಯುನೊನೆ \"ತುಮೆ ಎ ಲಂಗ್ಡಾನೆ ಕಿಮ್ಮ ಅರಾಮ ಕರ‍್ಯಾ? ತುಮೆ ಕೈ ತಾಕತ ಉಪಯೊಗ ಕರ‍್ಯಾ? ಎ ಕಿನಾ ಅದಿಕಾರಕ್ಹು ಕರ‍್ಯಾಸ? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ತೆಳಾಮಾ ಪೆತ್ರಾ, ಪುರಾ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರ‍್ಯೊ. ತೆ ತ್ಯುನೊನೆ \"ಮನಕ್ಹೊಪರ ಮ್ಹೊಟಾ ರ‍್ಹಯಲವಾಲಾ ವರಿ ಶಾನಾವೊ, ");
INSERT INTO sle_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ಎ ಲಂಗ್ಡಾನೆ ಥಯಲ ಚೊ಼ಕಾನಾ ಹುತಿ ತೆ ಕಿಮ ಅರಾಮ ಥಯೊ ಕೈನ ತುಮೆ ಹಮೊನೆ ಪುಚಾ಼ಡಾಸ ಸು, ");
INSERT INTO sle_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ನಜರೆತನಾ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಕ್ಹು ಎ ಮನಕ್ಹನೆ ಅರಾಮ ಥಯುಸ ಕವಾನು ತುಮೆ ವರಿ ಇಸ್ರಾಯೆನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತಿಳ್ದಿಲಿವ ಕೈನ ಮಿ ಆಸ ಕರುಸ! ತುಮೆ ಯೆಸುನೆ ಶಿಲುಬಿ ಪರ ಘಾಲ್ಯಾ. ಕ್ಹುದಾ ತಿನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡ್ಯೊ. ಎ ಮನಕ್ಹ ಲಂಗ್ಡೊ ವ್ಹತ್ತೊ, ತೆನೈಸೊ ಹಮ್ನಾ ಎ ಅರಾಮ ಥಯೊಸ ವರಿ ಯೆಸುನಾ ನಾಮಕ್ಹು ತುಮಾರಾ ಕ್ಹಾಮೊಜ಼ ಹುಬ್ರಯೊಸ! ");
INSERT INTO sle_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ಘರ ಭಾಂದಾಲಾ ತುಮೆ ನಕೊ ಕೈನ ಛೊಡ್ಯಲ ದಗ್ಡೊಜ಼ ಯೆಸು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ರಕ್ಷಣೆ ಯೆಸುಕ್ಹುಜ಼ ವ್ಹೈ ಬಿಜಾ಼ ಕಿಕನಜ಼ ನೈ ಮಳ್ತು. ತಿನಾ ನಾಮಕ್ಹುಜ಼ ನೈಸೊ ಹಬಾಳನಾ ಹೆಟಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ದಿದಲ ಬಿಜಾ಼ ಕಯಾ ನಾಮಕ್ಹುಬಿ ಅಪೊನೆ ರಕ್ಷಣೆ ನೈ ಥಾತು\" ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ ಖಾಸ ಕಯಿಬಿ ತರಬೆತಿ ಗ್ಯಾನ ರ‍್ಹವಾದೆ ನತ್ತಿ ಕವಾನು ಯೆಹುದಿಯೊನಾ ನಾಯಕೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತೆನೈಸೊ ತ್ಯುನೆ ಭುಚಕ್ಯಾವಾಚಿ಼ ಬೊಲಾನುಬಿ ನಾಯಕೊ ದೆಕಾಡಾತಾ. ತಿನಾಹುತಿ ಎ ನ್ಯಾಯಕೊ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ. ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಯೆಸುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ ಕಾವಾನು ಎ ಥಯಲಪರ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ಎ ಭಂಬಿ ಅಪೊಸ್ತಲೊನಾ ಬಾಜು಼ಮಾ ಹುಬ್ರಾಯಲ ಅರಾಮ ಥಯಲ ಲಂಗ್ಡಾನೆ ತ್ಯುನೆ ದೆಕ್ಯಾ. ತಿನೆ ಅರಾಮ ಥಯಲ ತ್ಯುನೆ ದೆಕ್ಯಾ. ತಿನಾಹುತಿ ಅಪೊಸ್ತಲೊನಾ ವಾತೊನಾ ವಿರುದ್ಧ ತ್ಯುನೆ ಸುಜ಼ ಕವಾನೆ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ಯೆಹುದಿ ನಾಯಕೊ ಅಪೊಸ್ತಲೊನೆ ಸಭೆತಾ ಭಾರಾ ಮೊಕ್ಲಿನ, ");
INSERT INTO sle_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","\"ಇವ್ನೊನೆ ಅಪೆ ಸು ಕರಿಯೆ? ಇವ್ನೆ ಮ್ಹೊಟಾ ಅದ್ಭುತ ಕಾಮೊ ಕರಾನು ಯೆರುಸಲೆಮಮಾ ರ‍್ಹಯಲ ಹರಯಕ್ಕನೆ ಗ್ವತ್ತ ಛೆ. ಎ ಅದ್ಭುತ ಕಾಮೊ ಕರೆಟ್ಟ ರ‍್ಹಯಲ ಹುತಿ ತಿನೆ ಮಾಂಡ್ಯಾ ವ್ಹೈ ಕೈನ ಕವಾನೆ ನೈ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ತೆನೈಸೊ ತೆ ಮನಕ್ಹನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಕಯೆ ನೈಸೊ ಅಪೆ ತ್ಯುನೊನೆ ಭುಚ್ಕಾಡು. ತೆಳಾಮಾ ಎ ಸಮಾಚಾರ ಮನಕ್ಹೊನಾ ವಚ್ಮಾ಼ ಫೈಲ್ತಿ ನೈ\" ಕೈನ ತ್ಯುನೆ ಬೊಲಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ತಿನಾಹುತಿ ಯೆಹುದಿ ನಾಯಕೊ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನನೆ ಮ್ಹೈ ಬಲೈನ, ಯೆಸುನಾ ನಾಮಪರ ಸುಜ಼ ಕೌ ನೈ ಕೈನ, ಸುಜ಼ ಬೊದನೆ ಕರು ನೈ ಕೈನ ತಾಕಿತ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ತಿಮ್ಮ ಕತಾಮಾ ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ತ್ಯುನೊನೆ \"ಹಮೆ ತುಮೊನೆ ವಿದೆಯ ಥಯೆ ಸು ಕ್ಹುದಾನೆ ವಿದೆಯ ಥಯೆ? ಇಮಾ ಕಯು ಕ್ಹುದಾನೆ ಚಾ಼ಯೆ ಥಯಲ ವ್ಹೈ? ತುಮೆಜ಼ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ಹಮೆತೊ ಗಪ್ಪ ನೈ ರ‍್ಹೆ ಸಕ್ತಾ. ಹಮೆ ದೆಕಲ ವರಿ ಐಕಲ ಸಂಗತಿಯೊನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಕೌಜ಼\" ಕೈನ ಉತ್ತರ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ಯೆಹುದಿ ನಾಯಕೊನೆ ಅಪೊಸ್ತಲೊನೆ ಶಿಕ್ಷಾ ದಿವಾನೆ ಕಯಿಜ಼ ವಾಟ ದಿಕ್ಹಿ ನೈ, ಕಾಕದ್ಯಾಮ, ಥಯಲ ಕಾಮೊನಾ ಹುತಿ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ಎ ಸುಚಕ ಕಾಮೊಕ್ಹು ಅರಾಮ ಥಯಲ ಮನಕ್ಹೊನಿ ವೈಸ ಚಾ಼ಳಕ್ಹತಿಬಿ ಜಾಸ್ತ ವೈಸ ವ್ಹತ್ತಿ! ತಿನಾಹುತಿ ಯೆಹುದಿ ನಾಯಕೊ ಅಪೊಸ್ತಲೊನೆ ವರಿ ತಾಕಿತ ಕರಿನ ವಳೈ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ತ್ಯುನೊನೆ ಛೊಡ್ತಾಮಾ ತ್ಯುನೆ ಸಭೆತಾ ಗೈನ ತ್ಯುನಿ ಸಮುದಾಯನೆ ಗಯಾ. ಮ್ಹೊಟಾ ಯಾಜಕೊ ವರಿ ಯೆಹುದಿಯೊನಾ ಶಾನಾ ನಾಯಕೊ ತ್ಯುನೊನೆ ಕದಲ ಹರಯಕ್ಕ ತ್ಯುನೆ ತ್ಯುನಿ ಸಮುದಾಯಮಾ ತಿಳ್ಸಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ಎ ಐಕಲಪರ ವಿಶ್ವಾಸಿಯೊ ಯಕ್ಕ ಮನಸ್ಸಕ್ಹು ಕ್ಹುದಾನೆ ಝೊರ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ; \"ಮಾಲಕ, ಹಬಾಳನೆ ಜಿಮಿನನೆ ಸಮುಂದರನೆ ವರಿ ದುನಿಯಾಮಾ ರ‍್ಹವಾನು ಹರಯಕ್ಕನೆ ಸೃಷ್ಟಿ ಕರಲವಾಲೊ ತುಜ಼಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ಹಮಾರೊ ಪಿತೃ ಥಯಲ ದಾವಿದ ತಾರೊ ಸೆವಕ ವ್ಹತ್ತೊ. ತೆ ಪವಿತ್ರ ಆತ್ಮಾನಾ ಮದತಕ್ಹು ಎ ವಾತೊ ಬರ್ದ್ಯೊಸ; ");
INSERT INTO sle_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ಭುಲೊಕನಾ ರಾಜಾ಼ ಜಾ಼ವಾನೆ ತಯ್ಯಾರ ಛೆ; ");
INSERT INTO sle_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ಕ್ಹರಿಬಿ ತಿನಾ ಲಿಂಗತ ಥಯು ಹೆರೊದನೊ ರಾಜೊ಼, ಪೊಂತಿಯಸ ಪಿಲಾತನ, ಸಂತತಿಯೊ ವರಿ ಇಸ್ರಾಯಲ ಗಾಮತಾ ಕ್ಹಾರಾ ಮಳಿನ ಯೆಸುನೆ ವಿರೊದ ಕರಲ ಪರ ಎ ಸಂಗತಿಯೊ ಕ್ಹರಿಜ಼ ಥಯಾ. ಕ್ರಿಸ್ತ ಥಯಲ ಯೆಸು ತಾರೊ ಪವಿತ್ರ ಸೆವಕ ಥಯೊಸ. ತು ತಿನೆ ಅಭಿಷೆಕ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ಯೆಸುನೆ ವಿರುದ್ಧ ಥೈನ ಮಳಿನ ಆಯಲ ಎ ಮನಕ್ಹೊ ತಾರಿ ವಿಚಾರ ಪುರಾ ಥಾಯೆ ಲಿಂಗತ ಕರ‍್ಯಾ. ತಾರಿ ತಾಕತಕ್ಹು ತಾರಿ ಚಿತ್ತಕ್ಹು ಎ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ಪ್ರಭು, ತ್ಯುನೆ ಕವಾನು ಐಕ. ತ್ಯುನೆ ಹಮೊನೆ ಭುಚ್ಕಾಡಾನೆ ಕೊಶಿಶ ಕರಾಡಾಸ! ಪ್ರಭು ಹಮೆ ತಾರಾ ಸೆವಕೊ ವ್ಹೈ. ತಾರಿ ವಾಕ್ಯಾ ಭೆ ವಾಚಿ ಕವಾನೆ ತುಜ಼಼ ಹಮೊನೆ ಮದತ ಕರ. ");
INSERT INTO sle_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ತಾರೊ ಹತ್ತ ಅಗೊ ಕರಿನ ಯೆಸುನಾ ನಾಮನಾ ಮುಲಕ ರೊಗಿಯೊನೆ ಅರಾಮ ಕರ; ಸುಚಕ ಕಾಮೊ ಅದ್ಭುತ ಕಾಮೊ ಕರ\" ಕೈನ ತ್ಯುನೆ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ಇಮ್ಮ ವಿಶ್ವಾಸಿಯೊ ಪ್ರಾಥನಾ ಕರ‍್ತಾಮಾ, ತ್ಯುನೆ ಸಭೆ ಮಳಲ ಜ಼ಗಾ ಹಲ್ಯು. ತ್ಯುನೆ ಕ್ಹಾರಾ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಿನ ವರಿ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಭೆ ವಾಚಿ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ವಿಶ್ವಾಸಿಯೊನು ಮನಸ್ಸ ಜ಼ಲಮ ಯಕ್ಕಜ಼ ವ್ಹತ್ತು. ಸಮುದಾಯಮಾ ರ‍್ಹಯಲ ಕುನ್ನಬಿ ರ‍್ಹೈನಕಾ ತಿಕನ ರ‍್ಹಯಲ ಕ್ಹಾರು ತಿನು ವ್ಹೈ ಕೈನ ಕವಾಡಾ ನ್ಹೊತಾ. ತಿನಿ ಜ಼ಗಾ, ತ್ಯುನೆ ಹರಯಕ್ಕನೆ ವಾಟಿಲಿವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ಹರಿಬಿ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯೊಸ ಕೈನ ಅಪೊಸ್ತಲೊ ಘನ್ನಾ ಜೊ಼ರೆ ಮನಕ್ಹೊನೆ ಕವಾಡಾತಾ. ಕ್ಹುದಾ ವಿಶ್ವಾಸಿಯೊ ಕ್ಹಾರಾವೊನೆ ಘನ್ನೊ ಆಶಿರ್ವಾದ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ತ್ಯುನೆ ಕ್ಹಾರಾವೊನಾ ಜ಼ರುರತೊ ಪುರಾ ಥಾವಾಡಾತಾ. ಜ಼ಗಾ ವರಿ ಘರೊ ರ‍್ಹಯಲ ಹರಯಕ್ಲಾ ತೆ ಇಕ್ಕಿನ, ");
INSERT INTO sle_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ಆಯಲ ದೊಕ್ಡಾ ಅಪೊಸ್ತಲೊನಾ ಹತೊಮಾ ದೆತಾತಾ.. ಪಾಚಾ಼ತಾ ತೆ ಹರಯಕ್ಲಾನೆ ತಿನಾ ತಿನಾ ಜ಼ರುರತ ಲಿಂಗತ ವಾಟಿಲೆತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ತೆ ವಿಶ್ವಾಸಿಯೊಮಾ ಯೊಸೆಫ ಕವಾಲೊ ವ್ಹತ್ತೊ. ಅಪೊಸ್ತಲೊ ತಿನೆ ಬಾರ್ನಬ ಕೈನ ಬಲಾತಾತಾ. ಬಾರ್ನಬ ಕದ್ಯಾಮ ‘ಧೈರೈವಾಲೊ’ ಸೈಪ್ರಸ್ಮಾ ಹುಟ್ಟಲ ಎ ಲೆವಿ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ಯೊಸೆಫನೆ ಯಕ್ಕ ಖೆತರ ವ್ಹತ್ತು. ತೆ ತಿನೆ ಇಕ್ಕಿನ ಆಯಲ ದೊಕ್ಡಾ ಅಪೊಸ್ತಲೊನಾ ಹತೊಮಾ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ಅನನಿಯ ಕವಾಲೊ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ತಿನಿ ಬೈಕೊನು ನಾಮ ಸಫೈರಳ ವ್ಹೈ. ಅನನಿಯ ತಿಕನ ರ‍್ಹಯಲ ದಕ್ಹಿ ಜಿಮಿನ ಇಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ತೆನೈಸೊ, ಆಯಲ ದೊಕ್ಡಾಮಾ ಯಕ್ಕ ಭಾಗ ತೆ ಅಪೊಸ್ತಲೊನಾ ಪಗೊ ಕನ ಮ್ಹೆಲ್ಯೊ. ತೆ ದಕ್ಹಾ ದೊಕ್ಡಾ ತಿನಾಹುತಿ ಝಾಕಿನ ಮ್ಹೆಲ್ಯೊ. ತಿನಿ ಬೈಕೊನೆ ತೆ ಕ್ಹಾರು ಗ್ವತ್ತ ವ್ಹತ್ತು. ತಿನೆ ತೆ ವಪ್ಪಿಲಿದಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ಪೆತ್ರಾ\"ಅನನಿಯ, ತಾರು ಮನಸ್ಸ ಆಳಾನೆ ತು ಸೈತಾನನೆ ವಪ್ಸಿನ ಕಾ ದಿದ್ಯೊಸ? ತು ಸುಳ್ಳ ಕೈನ, ಪವಿತ್ರ ಆತ್ಮಾನೆ ಮೊಸ ಕರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊಸ. ತು ತಾರಿ ಜಿಮಿನ ಇಕ್ಯೊ, ತೆನೈಸೊ ಆಯಲ ದೊಕ್ಡಾಮಾ ಯಕ್ಕ ಭಾಗ ತು ತಾರಾ ಹುತಿ ಮ್ಹೆಲಿದಲ ಕಾ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ತು ಜಿಮಿನ ಇಕಾತ್ತಿ ಅಗ್ದುರಜ಼ ತೆ ತಾರಿ ಥೈತಿ. ತು ಇಕ್ಕಲ ಪರಬಿ ಆಯಲ ದೊಕ್ಡಾ ತಾರಾ ಥಯತಾ. ಎ ಕೆಟ್ಟ ಕಾಮೊ ಕರಾನೆ ತು ಕಾ ವಿಚಾರ ಕರ‍್ಯೊ? ತು ಸುಳ್ಳ ಕದಲ ಕ್ಹುದಾನೆ ವ್ಹೈ ಮನಕ್ಹೊನೆ ನ್ಹವೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ಅನನಿಯಾ ಆ ಐಕಲ ಪರಬಿ ತೆಳಾಮಾ ಹೆಟೊ ಪಡಿನ ಮರಿ ಗಯೊ. ಎ ಸುದ್ದಿ ಐಕಿನ ಹರಿಯಕ್ಕಲೊ ಭುಚ್ಕಾ಼ ವರಕ್ಹಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ದಕ್ಹಾ ಜಾಂಜಿಮಾನೊ ಐನ ತಿನು ಅಂಗ ಪ್ಹಡ್ಕಾಮಾ ಸುತ್ತಿನ ತ್ಯುನೆ ತೆ ಅಂಗನೆ ಉಚೈಲಿನ ಮಜಾ಼ರಮಾ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ಕಮ್ಸೆ ಕಮ ತನ್ನ ವಾಸ್ತಾ ಥಯಲ ಪರ ತಿನಿ ಬೈಕೊ ಥಯಲ ಸಪೈಲರ ಮ್ಹೈ ಐ. ಥಯಲ ಸಂಗತಿಯೊನಾ ಹುತಿ ಸಪೈಲರ ನೆ ಗೊತ್ತ ನೊತು. ");
INSERT INTO sle_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ಪೆತ್ರಾ ತಿನೆ \"ತುಮಾರಿ ಜ಼ಮಿನಕ್ಹು ತುಮೊನೆ ಕೆಕ್ಲಾದೊಕ್ಡಾ ಆಯಾತಾ. ಕ್ಹರಿಮಾಜ಼ ಅಕ್ಲಾಜ಼ ದೊಕ್ಡಾ ವ್ಹೈಸು? ಕದ್ಯೊ. ಸಫೈಲರ \"ಹೊ, ತೆಕ್ಲಾಜ಼ ವ್ಹೈ ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ತೆಳಾಮಾ ಪೆತ್ರಾ ತಿನೆ ತು ವರಿ ತಾರೊ ಮಾಟಿ ಪ್ರಬುನಿ ಆತ್ಮನೆ ಪರಿಕ್ಷಾ ಲಿವಾನೆ ಕಾ ವಪ್ಪಿಲಿದ್ಯಾ? ದೆಕ ತಾರಾ ಮಾಟಿನೆ ಸಮಾದಿ ಕರಿನ ಐಯಲ ಮನಕ್ಹೊ ಬಾಕಲ ಕನ ಆಯಾಸ ತ್ಯುನೆ ತುನೆ ತಿನಾ ಲಿಂಗತಜ಼ ಉಚೆ಼ಲಿನ ಜಾ಼ವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ತೆಳಾಮಾಜ಼ ಸಫೈಲರ ತಿನಾ ಪಗೊಕನ ಪಡಿನ ಜ಼ಲಮ ಛೊಡಿ ತೆ ಜಾ಼ಂಜಿಮಾನೊ ಮ್ಹೈ ಐನ ದೆಕ್ತಾಮಾ ತೆ ಮರಿ ಗೈತಿ ತ್ಯುನೆ ತಿನೆ ಉಚೈಲಿನ ಗೈನ ತಿನಾ ಮಾಟಿನಾ ಬಾಜು಼ಮಾ ಬುರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ಎ ಸಂಗಯೊತಿನಾ ಹುತಿ ಸಬೆನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ವರಿ ಐಕಲ ಕ್ಹಾರಾಜ಼ನಾ ಭುಚ್ಕಾ಼ ವರಕ್ಹಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ಅಪೊಸ್ತಲೊ ಕೆಕ್ಲಾಕಿ ಸುಚಕ ಕಾಮೊ ಅಬ್ದುತ ಕಾಮೊ ಕರ‍್ಯಾ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ತೆ ಕಾಮೊ ದೆಕ್ತಾತಾ. ವರಿ ಅಪೊಸ್ತಲೊ ಮಳಿನ ಸೊಲೊಮೊನಾ ಮಂಟಪಮಾ ರ‍್ಹತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ತ್ಯುನಾ ಕ್ಹಾತೆ ಹುಬ್ರವಾನೆ ಬಿಜು಼ ಕಿನೆಜ಼ ಧೈರ್ಯ ಥೈ ನೈ ರ‍್ಹೈತಬಿ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಅಪೊಸ್ತಲೊನಾ ಹುತಿ ಚೊ಼ಕಿಯೊ ಸಂಗತಿಯೊ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ತೆನೈಸೊ ಘನ್ನಾ ಮನಕ್ಹೊ ಗುಂಪಮಾ ಮಳಿನ ಆತಾತಾ ವರಿ ದಾಣ್ಗಾ ಬಾಕ್ಡಿಯೊ ಕರ್ತಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಶಾಮಿಲ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಅಪೊಸ್ತಲೊನಿ ಸುದ್ದಿ ಐಕಿನ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಅರಾಮ ನೈಸೊ ವಾಲಾವೊನೆ ಪಲಂಗನಾ ಕ್ಹಾತೆ ವರಿ ವಚ್ಚಾನಾನಾ ಕ್ಹಾತೆಜ಼ ಉಚೈ ಲೈನ ತ್ಯುನಿ ಜಾ಼ವಾನಿ ವಾಟಪರ ಲೈ ಪಡತಾತಾ ಕಾಕದ್ಯಾಮ ಪತ್ರಾನಿ ಛೌಲಿ ಪಡ್ಯಾಮ ಅರಾಮ ಥಾವಸ ಕೈನ ತ್ಯುನೊನೆ ಬರೊಕ್ಹೊ ವ್ಹತ್ತೊ.. ");
INSERT INTO sle_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ಜೆರುಸಲೆಮನಾ ಸುತ್ತೆ ಮುತ್ತೆನಾ ಗಾಮೊ ಮಾತಾ ಮನಕ್ಹೊ ಆವಾಡಾತಾ. ತ್ಯುನೆ ರೊಗ್ಯೊನೆ ಭುತ್ಡಾ ದರಲ ವಾಲಾವೊನೆ ಉಚೈಲಿನ ಆವಾಡಾತಾ. ಎ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಅರಾಮ ಥಯ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ಪ್ರದಾನ ಯಾಜಕೊ ವರಿ ತ್ಯುನಾ ದೊಸ್ತೊ ಕ್ಹಾರಾ ಸದ್ದುಕಾಯೊ ಅಪೊಸ್ತಲೊ ಕಾಮೊನಾ ಹುತಿ ಸಂಗಟ ಘಾಲಿದ್ಯಾ ವರಿ ತ್ಯುನೊನೆ ಸುಬಿ ಕರು ಕೈನ ವಿಚಾರ ಕರಲಿದ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ತ್ಯುನೆ ಅಪೊಸ್ತಲೊನೆ ಧರೈನ ಜೆಲಮಾ ಘಾಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ತೆನೈಸೊ ಕರ್ತಾನೊ ದುತ ರಾತೆ ಜೆಲನಾ ಬಾಕ್ಲೊ ಖುಲ್ಲಾ ಕರಿನ ತ್ಯುನೊನೆ ಭಾರೊ ಬಲೈಲೈನ, ");
INSERT INTO sle_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"ಗೈನ ದೆವಾಲಯಮಾ ಹುಬರೈನ. ಯೆಸುಮಾ ರ‍್ಹಯಲ ಎ ನವಿ ಜಿವಿತನಾ ಹುತಿ ಹರಿ ಯಕ್ಕ ಮನಕ್ಹೊನೆ ಕವೊ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ತೆನೈಸೊ ತ್ಯುನೆ ಪಾಟ್ಟೆ ದೆವಾಲಯನೆ ಗೈನ ಉಪದೆಶ ಕರಾಡಾತಾ. ತ್ಯುನೆ ಉಪದೆಶ ಕರಾನು ಐಕಿನ ಮಹಾ ಯಾಜಕೊ ವರಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲ ಸಬೆನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಸಬೆನೆ ವರಿ ಇಸ್ರಾಯೆಲನಾ ಶ್ಯಾನಾವೊನೆ ಮಳೈನ ತ್ಯುನೊನೆ ವರಿ ಜೆಲಮಾತಾ ಬಲೈಲೌ ಕೈನ ಜೆಲೆ ವಳಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ಸಿಪಾಯೊ ಅಪೊಸ್ತಲೊ ಜೆಲಮಾ ನೈ ರ‍್ಹಯಲ ದೆಕಿನ ಕವಾನೆ ಫರಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ಜೆಲನಾ ಕ್ಹಾರಾ ಬಾಕಲೊ ಘಾಲೆಲ ವ್ಹತ್ತಾ ವರಿ ಜೆಲನೆ ಕಾಯ್ದಾಲಾ ಘನ್ನಾ ಹುಶಾರಕ್ಹು ವ್ಹತ್ತಾ ಸಿಪಾಯೊ ಜೆಲನಾ ಬಾಕಲೊ ಕಾಡ್ತಾಮಾ ತ್ಯಾ ಯಕ್ಲೊಬಿ ನ್ಹೊತೊ ಕೈನ ಐನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ದೆವಾಲಯನಾ ಅದಿಕಾರಿಯೊ ವರಿ ಮಹಾಯಾಜಕೊ ಆ ಕ್ಹಾರು ಐಕಿನ ಸು ಥೈಯು ಗಯುಸ ಕೈನ ಘಾಬ್ರಾ ಥಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ಪಾಚಾ಼ ತು ಬಿಜೆಕ್ಲೊ ಐನ ತ್ಯುನೊನೆ\"ಐಕಿನ! ತುಮೆ ಸೆರೆಮನಿಮಾ ಘಾಲಲ ಮನಕ್ಹೊ ದೆವಾಲಯಮಾ ಅಂಗಳಾಮಾ ಹುಬ್ರಯಾಸ. ತುನೆ ಮನಕ್ಹೊನೆ ಉಪದೆಶ ಕರಾಡಾತಾ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ತೆಳಾಮಾ ದಳಪತಿ ವರಿ ತ್ಯಾನಾ ಮನಕ್ಹೊ ಕನ ಅಪೊಸ್ತಲೊನೆ ಫರಿನ ಬಲಾಯಾ. ವರಿಬಿ ಸೈನಿಕೊ ಜ಼ಬರದಸ್ತಿ ಕರ‍್ಯಾನೈ ಕಾಕದ್ಯಾಮ ತುನೆ ಮನಕ್ಹೊ ಬುಚೆ಼ಕ್ಯಾ. ಮನಕ್ಹೊ ಶಿಟ್ಟ ಥೈನ ಮುಕಲ್ಯಾ ತ್ಯುನೊನೆ ಖಲಾಸ್ಸ ಕರಸ ಕೈನ ತುನೆ ಬುಚೆ಼ಕೈ. ");
INSERT INTO sle_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ತ್ಯುನೆ ಅಪೊಸ್ತಲೊನೆ ಸಭೆನೆ ಬಲೈಲಿನ ಐನ ಯೆಹುದಿ ನಾಯಕೊನೆ ಕ್ಹಾಮಾ ಹುಬರಾಡ್ಯಾ. ಪ್ರಧಾನ ಯಾಜಕೊ ಅಪೊಸ್ತಲೊನೆ. ");
INSERT INTO sle_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","\"ಎ ಮನಕ್ಹನು ವಾಸ್ತರ ತುಮೆ ಬೊದನೆ ಕರುನೈ ಕೈನ ಹಮೆ ತುಮೊನೆ ಅಪ್ಪಣೆ. ವರಿಬಿ ತುಮೆ ರ‍್ಹಯಲ ಸುವೈ? ತುಮೆ ಜೆರುಸೆಲಿಮಾ ತುಮಾರಿ ಉಪದೆಶನೆ ಕರಿಪಾಡ್ಯಾಸ. ಎ ಮನಕ್ಹನೆ (ಯೆಸುನಾ) ಮೌತನೆ ಜವಾಬ್ದಾರ ತಯಿನ ತುಮೆ ಕೊಶಿಶ\" ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ಪೆತ್ರಾ ವರಿ ಉಗ್ರಲ ಅಪೊಸ್ತಲೊ\"ಹಮೆ ವಿದೆಯತೆ ಕೈನ ಕ್ಹುದಾನೆ ವ್ಹೈ ತುಮೊನೆ ನ್ಹವೈ! ");
INSERT INTO sle_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ತುಮೆ ಯೆಸುನೆ ಶಿಲುವಿಪರ ಘಾಲಿನ ಖಲಾಸ ಕರ‍್ಯಾ. ವರಿಬಿ ಕ್ಹುದಾ ಯೆಸುನೆ ಮರಲವಾಲಾವೊನೆ ಮಾತೊ ಜುತೊ ಕರ‍್ಯೊ! ");
INSERT INTO sle_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ಕ್ಹುದಾ ತಿನೆ ಇಸ್ರಾಯೆಲ ಮನಕ್ಹೊನೆ ಪಾಪ ಮಾಫ ಕರಾನಾಹುತಿ ತಿನೆ ಪ್ರಭು ಥೈನ, ರಕ್ಷಕ ಥೈನ ತಿನಾ ಶಿದಾ ಹತ್ತ ಬಗಲ ಉನ್ನತ ಸ್ಥಾನಪರ ಉಟಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ತೆ ಕಾಮ್ಮೊನೆ ಹಮೆ ಸಾಕ್ಷಿ ವ್ಹೈ ಕ್ಹುದಾ ತಿನೆ ನಂಬಿನ ಚಾಲಿದೆಲವಾಲಾವೊನೆ ದಿದಲ ಪವಿತ್ರಾತ್ಮಜ ಸಾಕ್ಷಿ ವ್ಹೈ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ತೆ ವಾತೊ ಐಕಿನ ಶಿಟ್ಟ ಥೈನ ತ್ಯುನೊನೆ ಖಲಾಸ ಕರು ಕೈನ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ತಿನಾಹುತಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊಕ್ಹು ಮರ್ಯಾದಿ ದಿದೆಲ ಧರಮಶಾಸ್ತ್ರಿ ಥಯಲ ಗಮಲಿಯೆಲ ಕವಾಲೊ ಯಕ್ಕ ಫರಿಸಾಯ ಮ್ಹೊಟಾ ಸಬೆಮಾ ಉಟಿನ ಹುಬ್ರೈನ ತೆ ಮನಕ್ಹೊನೆ ದಕ್ಹಿಯೆಳ ಭಾರಾ ಜೌವು ಕೈನ ಅಪ್ಪಣೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ತೆಳಾಮಾ ಸಬೆವಾಲಾವೊನೆ,ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊ ತಮೆ ತೆ ಮನಕ್ಹೊನಾ ವಿಷಮಾ ಲಿವಾನು ನಿರ್ಧಾರನಾ ಹುತಿ ಹುಶಾರ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ಇನಾಹುತಿ ಪೈಲಾ ಥೈಯಲ ಕವಾಲೊ ಯಕ್ಲೊ ಉಟಿನ ತೆ ಯಕ್ಲೊ ಮಹಾಪುರುಷ ಕವಾನು ಕಲಿದ್ಯೊ. ತಿನಾ ಪಮಾಫ ಕಮ್ಸೆ ಕಮ್ಮ ಕ್ಹೊ ಮನಕ್ಹೊ ಮಳೆಲಿದ್ಯಾ,ತೆ ಮಾರಿ ಪಡ್ಯಾ,ವರಿ ತಿನೆ ನಂಬಾವಾವೊನೆ ಇಕ್ಹರಿನ ನೈಸೊವಾಲಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ತಿನಾ ತೆಳಾಮಾ ಜನಗಣತಿನಾ ಕಾಲಮಾ ಗಲಿಲಾಯನೊ ಯುದಾ ಫರಿನ ಪಡಾನಾಹುತಿ ಉಟಿನ ಮನಕ್ಹೊ ತಿನಾ ಪಮಾಫ ಮಳೆಲಿವಾನಾಹುತಿ ಘನ್ನಾ ಮನಕ್ಹೊ ತಿನೆ ಕದ್ಯಾ. ತೆ ನಾಶ ಥಯೊ ವರಿ ತಿನೆ ನಂಬಲವಾಲಾವೊನೆ ಚದರಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಮಿ ತಮನೊನೆ ಸು ಕೌ ಕದ್ಯಾಮ ತಮೆ ತೆ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಜಾವೊ ನಕೊ,ತ್ಯುನೊನೆ ಚ್ಹೊಡೊ. ಕಾಕದ್ಯಾಮ ತೆ ವಿಚಾರ ತೆನೈಸೊ ಇ ಕಾಮ್ಮ ಮನಕ್ಹೊಕ್ಹು ಥಯಲ ತೆಜ಼ ಕೆಟ್ಟಸ; ");
INSERT INTO sle_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ತೆ ಕ್ಹುದಾಕ್ಹು ಥಯಲ ತಿನೆ ಕೆಟ್ಟಾನಾಹುತಿ ತಮೊಕ್ಹು ನೈ ಥಾತು; ತಮೆ ಯಕ್ಕ ಸಲಾ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ಯುದ್ದ ಕರಾಲಾ ಥೈನ ದೆಕಾಡಿನ ದಿವೊ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ತ್ಯುನೆ ತಿನಾ ವಾತೊನೆ ಒಪ್ಪಿನ ಅಪೊಸ್ತಲಾ ಬಲೈನ ಮಾರಿನ ಯೆಸುನು ನಾಮಲಿನ ಬೊಲುಜ಼ ನೈಕೈನ ಅಪ್ಪಣೆ ದಿನ ತ್ಯುನೊನೆ ಛೊಡಿ ಪಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ಅಪೊಸ್ತಲೊ ತ್ಯುನೆ ಯೆಸುನು ನಾಮಕ್ಹು ಮರ್ಯಾದಿ ಕಾಡಾನಾಹುತಿ ಯೊಗ್ಯ ನತ್ತಿ ಕೈನ ಕ್ಹುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ಮ್ಹೊಟಾ ಸಭೆನಾ ಕ್ಹಾಮಾ ಗೈನ, ಹರಯಕ್ಕ ದಿನ ಚು಼ಕ್ಯಾವಾಚಿ ದೆವಾಲಯಮಾ ಬಿ ವರಿ ಘರ ಘರಮಾ ಉಪದೆಶ ಕರತ್ತಾ ಕ್ರಿಸ್ತ ಥಯಲ ಯೆಸುನಾ ಹುತಿ ಚೊ಼ಕು ಸುರ್ವಾತ್ತಾ ಕತ್ತಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ಯೆಸುನಾ ಶಿಷ್ಯಾ ಹೆಚ್ಕಿ಼ ಥಾವಾಡಾತಾ. ತೆನೈಸೊ ತೆ ಟೈಮಮಾ ಗ್ರಿಕನಾ ಮನಕ್ಹೊ ವರಿ ಇಬ್ರಿಯನಾ ಶಿಷ್ಯಾ ಚಾ಼ಡಿ ಕದ್ಯಾ. ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾಮ ತ್ಯುನೆ ಮಾಟಿಮರಲವಾಲಿಯೊನೆ ಆರಾಕಿ ಶಿದಾ ನೈ ಕರತಾ ಕೈನ ವರಿ ತಿವ್ನೊ ವಾಟೊ ತ್ಯುನೊನೆ ನೈ ದೆತಾ ಕೈನ ಬೊಲ್ಯಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ತೆಳಾಮಾ ಬಾರಾ ಅಪೊಸ್ತಲೊ ಕ್ಹಾರಾ ಶಿಷ್ಯಾವೊನಾ ಗುಂಪನೆ ಸಭೆನೆ ಬಲೈನ ತ್ಯುನೊನೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಭೊಧನೆ ಕರಾನಾ ಅಪ್ನು ಕಾಮ ವ್ಹೈ. ತೆ ಹುಬ್ರೈ ಪಡಾನು ಚೊ಼ಕು ನ್ಹವೈ! ಅಪೆ ಮನಕ್ಹೊನೆ ಅನ್ನನಿ ಮದತ ಕರಾತಿಬಿ ಹೆಚ್ಕಿ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಉಪದೆಶ ಆಗು ಬಡಾವಾನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ತಿನಾಹುತಿ, ಭಾಯೊ, ಪವಿತ್ರಾತ್ಮಖು ಭರಲ ವರಿ ಗ್ಯಾನಖು ಭರಲ ತಿವ್ನಿ ಸಾಕ್ಷಿನಿ ಜಿವ್ನಾ ಚೊ಼ಕಿ ರ‍್ಹೌ ವರಿ ತ್ಯುನೆ ಬರೊಕ್ಹಾನಾ ಲಾಯಕ ರ‍್ಹೌ ತ್ಯವಾ ಕ್ಹಾತ ಜ಼ನಾವೊನೆ ಇನಿಲಿವೊ ಹಮೆ ತ್ಯುನೊನೆ ಆ ಕಾಮ ಒಪ್ಸಿನ ದಿಯೆಸ ");
INSERT INTO sle_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ತೆಳಾಮಾ ಹಮ್ನೊನೆ ಕ್ಹಾರೊ ಟೈಮ ಪ್ರಾಥನಾನೆ ವರಿ ಉಪದೆಶ ಕವಾನೆ ಥಾವಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ತೆಳಾಮಾ ಕ್ಹಾರಾ ವಿಶ್ವಾಸಿಯೊ ಎ ವಿಚಾರನೆ ವಪ್ಪಿಲಿದ್ಯಾ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಪವಿತ್ರತ್ಮಾಕ್ಹು ಭರಲ ವರಿ ಬರೊಕ್ಹಾನಾ ಲಾಯಕ ರ‍್ಹಯಲ ಸ್ತೆಫನ, ಫಿಲಿಪ್ಪ, ಪ್ರೊಖೊರ, ನಿಕೊನೊರ ತಿಮೊನ ಪರ್ಮೆನ ವರಿ ನಿಕೊಲಾಯ ಮತಾಂತರ ಥೈನ ಯಹುದಿ ಥೈನ ಎ ಅಂತಿಯೊಕ್ಯಯವಾಲೊ ಥಯೊತೊ ಇವ್ನೊನೆ ಇನಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ತೆ ಥಯಲ್ಪರ ಅಪೊಸ್ತಲೊ ತ್ಯುನೊನೆ ಖಾಮಾ ಬಲೈನ ತಿವ್ನಾ ಮಾತಾಪರ ಹತೊ ಮುಕ್ಕಿನ ಪ್ರಾರ್ಥನಾ ಕರಿನ ತೆ ಕಾಮನಾ ಹುತಿ ನೆಮಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ವರಿ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಘನ್ನಾ ಮನಕ್ಹೊಕನ ಫೈಲತಿ ಗೈ, ಯೆರುಸೆಲೆಮಾ ರ‍್ಹಯಲ ಶಿಷ್ಯಾವೊನು ಗುಂಪ ಮ್ಹೊಟು ಥಾತು ಚಾ಼ಲ್ಯು. ಘನ್ನಾ ಯೆಹುದಿಯೊನಾ ಯಾಜಕೊ ಯೆಸು ಕ್ರಿಸ್ತಪರ ಬರೊಕ್ಹೊ ಮುಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ಸ್ತೆಫಾನ ಕ್ಹುದಾನಿ ಕೃಪೆ ವರಿ ತಾಕತಕ್ಹು ಭರಲವಾಲೊ ಥೈನ ಮನಕ್ಹೊನಾ ವಚ್ಮಾ ಅದ್ಬುತ ಕಾಮೊ ವರಿ ಸುಚಕ ಕಾಮೊ ಕರತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ತೆನೈಸೊ ದಕ್ಹಾ ಯೆಹುದಿಯೊ ಐನ ತಿನಾಕ್ಹಾತೆ ವಾದ ವಿವಾದ ಕರಾಡ್ಯಾ. ಇವ್ನೆ ಸಭಾಮಂದಿರನಾ ವ್ಹತಾ. ಸಿರೆನ ವರಿ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾತಾ ಆಯಲ ಯೆಹುದಿಯೊನಾ ಹುತಿ ತೆ ಸಭಾಮಂದಿರ ವ್ಹತ್ತಿ. ಸಿಲಿಸಿನಾ ವರಿ ಎಶ್ಯಾತಾ ಆಯಲ ಯೆಹುದಿಯೊ ತ್ಯುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ತಿನಾಹುತಿ ವಿವೆಕಕ್ಹು ಬೊಲಾನೆ ಪವಿತ್ರ ಆತ್ಮಾ ತಿನೆ ಮದತ ಕರಿತಿ. ಸ್ತೆಫನನಾ ವಾತೊ ಘನ್ನಿ ಶಕ್ತಿ ರ‍್ಹಯಲಕ್ಹು ತಿನಾ ಕ್ಹಾತೆ ವಾದ ವಿವಾದ ಕರಾನೆ ತ್ಯುನೊನೆ ಸಾದ್ಯ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","\"ಸ್ತೆಫಾ ಮೊಶೆನಾ ವರಿ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ಕೆಟ್ಟ ವಾತೊ ಬೊಲ್ಯೊಸ \"ಕೈನ ಕವೊ ಕೈನ ದಕ್ಹಾಜ಼಼ನಾವೊನೆ ದೊಕ್ಡಾ ದಿನ ಶಿಕ್ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ಇಮ್ಮ ತ್ಯುನೆ ಮನಕ್ಹೊನೆ ವರಿ ಶ್ಯಾನವೊನೆ ಧರ್ಮೊಪದೆಶಕೊನೆ ಭಡಕಾಯಾ. ತ್ಯುನೆ ಆ ವಾತ ಐಕಿನ ಘನ್ನಾ ಶಿಟ್ಟ ಥೈನ ಸ್ತೆಫನನೆ ಧರಲೈನ ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊನಾ ಸಭೆನೆ ಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ತೆಳಾಮಾ ತ್ಯುನೆ ದಕ್ಹಾ ಸುಳ್ಳ ಸಾಕ್ಷಿ ಕವಾಲಾವೊನೆ ಬಲೈ ಲೈನ \"ಎ ಮನಕ್ಹ ದೆವಾಲಯನಾ ವರಿ ಮೊಶೆನಾ ನಿಯೊಮೊನಾ ವಿರುದ್ದ ಹಮೆಶಾಬಿ ಕೆಟ್ಟ ಬೊಲಸ ಕೈನ ಕವಾಲಗಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ನಜೆರೆತನೊ ಯೆಸು ಎ ದೆವಾಲಯ ಪಾಡಿನ ಮೊಶೆನಾ ನಿಯೊಮೊನೆ ಬದಲಿ ಕರಸ ಕೈನ ಕವಾನು ಹಮೆ ಐಕ್ಯಾಸ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ಸಭೆಮಾ ಬೈಟಲವಾಲಾ ಕ್ಹಾರಾ ಸ್ತೆಫನನೆ ಯಕ್ಕಜ಼ ಸಂವಾ ದೆಕ್ತಾಮಾ ತಿನು ಮ್ಹೊಡು ದೆವದುತ ಲಿಂಗತ ದಿಕ್ಹಾಡುತು. ");
INSERT INTO sle_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ತೆಳಾಮಾ ಮ್ಹೊಟೊ ಯಾಜಕ ಸ್ತೆಫನನೆ\"ಎ ಸಂಗತಿಯೊ ಕ್ಹರಿ ವ್ಹೈಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ತೆ ವಾತೆ ಸ್ತೆಫನ ಅಮ್ಮ ಉತ್ತರ ದಿದ್ಯೊ; \"ಮಾರಾ ಬಾವೊ, ಭಾಯೊ, ಮಿ ಕವಾನು ಧ್ಯಾನ ದಿನ್ನ ಐಕೊ. ಅಪ್ನೊ ಪಿತೃ ಥಯಲ ಅಬ್ರಹಾಮನೆ ಸ್ವರ್ಗಮಾತೊ ಕ್ಹುದಾ ದಿಕ್ಹ್ಯೊ. ಅಬ್ರಹಾಮ ಹಾರಾನಮಾ ರ‍್ಹವಾತಿ ಅಗ್ದುರ ಮೆಸಪೊಟೆಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ಕ್ಹುದಾ, ಅಬ್ರಹಾಮನೆ ತಾರು ದೆಶ ತಾರಾ ಮನಕ್ಹೊನೆ ಛೊಡಿನ ಮಿ ತುನೆ ದೆಕಾಡಾನಾ ದೆಶೆ ಜಾ಼’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ತಿನಾಹುತಿ ಅಬ್ರಹಾಮನೆ ಖಾಲ್ದಿಯಾ ದೆಶ ಛೊಡಿನ ಹಾರಾನ ಕವಾನಾ ಗಾಮೆ ಗೈನ ರ‍್ಹವಾನೆ ಗಯೊ. ವರಿ ತಿನಬಾ ಮರೆಲಪರ ತುಮೆ ರಹವಾನಿ ಜ಼ಗಾ ಬಲೈ ಲಾಯೊ ");
INSERT INTO sle_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ನ್ಯ್ಹಾತಿನೆ ಪಗ ಮ್ಹೆಲಾ ಅಕ್ಲಿಬಿ ಜ಼ಗಾ ಕ್ಹುದಾ ತಿನಾ ಹಕ್ಮಾ ದಿದ್ಯೊ ನೈ. ತುಪರತೊ ತಾರಿ ಸ್ವಂತ ಸಂತತಿನೆ ದ್ಯುಸ ಕವಾನಿ ವಾಗ್ದಾನ ಯಕ್ಕಜ಼ ವ್ಹತ್ತಿ. ತೆಳಾಮಾ ಅಬ್ರಹಾಮನೆ ಬಚ್ಚಾ಼ಬಿ ನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ತೆನೈಸೊ ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೆ, ತಾರಾ ಸಂತತಿಯೊ ಬಿಜಾ಼ ದೆಶಮಾ ಜಾ಼ವಸ ವರಿ ತ್ಯುನಾ ಗುಲಾಮೊ ಥಾವಸ ವರಿ ಚ್ಯಾರಕ್ಹೊ ವರಕ್ಹ ತ್ಯಾನಾ ಮನಕ್ಹೊ ತ್ಯುನೊನೆ ಘನ್ನಾ ತ್ರಾಸ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ತೆನೈಸೊ ತ್ಯುನೊನೆ ಗುಲಾಮ ಕರಿಲಿವಾಲಾ ಜ಼ನಾಂಗನೆ ಮಿ ಶಿಕ್ಷಾ ದ್ಯುಸ. ತ್ಯಾಂತಾ ತ್ಯುನೆ ಭಾರಾ ಐನ ಮನೆ ತೆ ಜ಼ಗಾಪರ ಆರಾಧನಾ ಕರಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ಕ್ಹುದಾ ಅಬ್ರಹಾಮನಾ ಕ್ಹಾತೆ ಯಕ್ಕ ವಡಂಬಡಿಕೆ ಕರ್ಲಿದ್ಯೊ. ತೆ ವಡಂಬಡಿಕೆ ವಳಕ ಖತ್ನಾ ವ್ಹೈ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಅಬ್ರಹಾಮನೆ ಯಕ್ಕ ಪಟ್ಟೊ ಥಯೊ. ತೆ ಪಟ್ಟಾನೆ ಆಟ್ವಾ ದಿನ್ನೆ ಖತ್ನಾ ಕರ‍್ಯಾ. ತಿನಾ ದಿಕ್ರಾನು ನಾಮ ಇಸಾಕ ವ್ಹೈ. ಇಸಾಕಬಿ ತಿನಾ ದಿಕ್ರಾನೆ ಖತ್ನಾ ಕರ‍್ಯೊ. ವರಿ ಯಾಕೊಬ ತಿನಾ ಕ್ಹಾರಾ ಪಟ್ಟಾವೊನೆ ಖತ್ನಾ ಕರಾಯೊ. ಎಜ಼ ಬಾರಾ ಪಟ್ಟಾವೊಖು ಬಾರಾ ಕ್ಹಾಂದಾನೊ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ಯಾಕೊಬನಾ ದಿಕ್ರಾ ಯೊಸೆಫಪರ ಸಂಗಟ ಘಾಲ್ಲಿನ ತಿನೆ ಇಜಿಪ್ತವಾಲಾವೊನೆ ಇಕ್ಕಿಪಾಡ್ಯಾ. ತೆನೈಸೊ ಕ್ಹುದಾ ಯೊಸೆಫನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ಯೊಸೆಫನೆ ತ್ಯಾ ಘನ್ನೊ ತ್ರಾಸ ಆಯೊ. ವರಿಬಿ ಕ್ಹುದಾ ತೆ ಕ್ಹಾರಾ ತ್ರಾಸೊಕ್ಹು ತಿನೆ ವಚಾ಼ಡ್ಯೊ. ತೆಳಾಮಾ ಫರೊಹನ ಇಜಿಪ್ತನೊ ರಾಜೊ಼ ವ್ಹತ್ತೊ. ಕ್ಹುದಾ ಯೊಸೆಫನೆ ದಿದಲ ಗ್ಯಾನಕ್ಹು ಫರೊಹನ ಯೊಸೆಫನೆ ತಿನಾ ರಾಜ್ಯಪರ ಅದಿಕಾರಿ ವರಿ ಘರನಾ ಮನಕ್ಹೊಪರಬಿ ಅದಿಕಾರಿ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ಇಜಿಪ್ತ ವರಿ ಕಾನಾನಮಾ ಬರಗಾಲ ಆತಾಮಾ ಮನಕ್ಹೊ ತ್ರಾಸೊಮಾ ಪಡ್ಯಾ ಅಪ್ನಾ ಪುರವಿಕೊಬಿ ಅನ್ನ ಮಳೆ ನೈಸೊ ಭುಕ್ಕಾ ರ‍್ಹೈ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ಇಜಿಪ್ತ ದೆಶಮಾ ಅನಾಜ಼ ಛೆ ಕವಾನು ವಳಕಿನ ಯಾಕೊಬ ತಿನಾ ದಿಕ್ಕರಾವೊನೆ ಪಸ್ಟ ಸಲಾ ತ್ಯಾ ಮೊಕಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ ತ್ಯಾ ಬೆವಾ ಸಲಾ ಗಯಾ. ಎ ಸಲಾ ತೆ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಕವಾನು ಯೊಸೆಫ ತಿನಾ ಭಾಯೊನೆ ಕದ್ಯೊ. ವರಿ ಯೊಸೆಫನಾ ಘರದಾನಾ ಹುತಿ ಫರೊಹನನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ಪಾಚಲ್ತೊ ಯೊಸೆಫ ತಿನೊ ಬಾ ಥಯಲ ಯಾಕೊಬನೆ ವರಿ ತಿನಾ ಪುರಾ ಘರದಾನಾವಾಲಾ ವರಿ ಸತ್ತರಪರ ಪಾಂಚ಼ ಜ಼ನಾವೊನೆ ಇಜಿಪ್ತನೆ ಬಲೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ತಿನಾಹುತಿ ಯಾಕೊಬ ಇಜಿಪ್ತೆ ಐನ ತೆ ವರಿ ತಿನಾ ಬಚ್ಚಾ಼ ಮರೆ ಲಕ್ಕಾ ತ್ಯಾಜ಼ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ತ್ಯುನಾ ಮುರ್ದಾವೊನಾ ಹಡ್ಕಾ ಫರಿನ ಶೆಕೆಮನೆ ಲಿನ ಗಯಾ. ತ್ಯಾ ಹಮೊರ ಕವಾಲಾನಾ ಬಚ್ಚಾ಼ವೊಕ್ಹು ಅಬ್ರಹಾಮ ರೊಪ್ಪೊ ಲಿದಲ ಮಜಾ಼ರೊಮಾ ಮ್ಹಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","\"ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೆ ದಿದಲ ವಾಗ್ದಾನ ಪುರಾ ಥಾವಾನು ದಿನ್ನ ನಜಿಕ ಆಯು. ಯಕ್ಲಾಮಾಜ಼ ಇಜಿಪ್ತ ದೆಶಮಾ ಅಪ್ನಾ ಮನಕ್ಹೊನಿ ಸಂಖ್ಯಾ ಘನ್ನಿ ಬೆಳದಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ಲಾಸ್ಟಮಾ ಯೊಸೆಫನಿ ವಳಕ ನೈ ರ‍್ಹಯಲ ರಾಜೊ಼ ಇಜಿಪ್ತ ಆಳಾನೆ ಶುರು ಕರ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ಎ ರಾಜೊ಼ ಹಮಾರಾ ಮನಕ್ಹೊನೆ ಮೊಸ ಕರ‍್ಯೊ. ತೆ ಅಪ್ನಾ ಪಿತೃವೊನೆಬಿ ಕೆಟ್ಟ ಕರ‍್ಯೊ. ತ್ಯುನಾ ನ್ಹಾನಾ ಬಚ್ಚಾ಼ ಮರು ಕೈನ ತ್ಯುನೊನೆ ಭಾರೊ ನಾಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ಎಜ಼ ಟೈಮಾ ಮೊಶೆ ಹುಟ್ಯೊತೊ. ತೆ ದೆಕಾನೆ ಘನ್ನೊ ಚಂದ ವ್ಹತ್ತೊ. ವರಿ ತೆ ತನ್ನ ಮ್ಹೈನಾ ಲಕ್ಕಾ ಘರಮಾಜ಼ ಬೆಳದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ಪಾಚಾ಼ತಾ ತಿನೆ ಘರ್ಮಾತಾ ಭಾರಾ ಮ್ಹೆಲ್ತಾಮಾ, ರಾಜಾ಼ನಿ ದಿಕ್ರಿ ತೆ ಪಟ್ಟಾನೆ ಲಿನ ತಿನಾ ಸ್ವಂತ ದಿಕ್ರಾ ಲಿಂಗತ ಜ಼ತ್ತನ ಕರಿ. ");
INSERT INTO sle_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ತೆ ಇಜಿಪ್ತ ರಾಜ್ಯನಿ ಕ್ಹಾರಿಜ಼ ವಿದ್ಯಾ ಶಿಕ್ಯೊ. ವರಿ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ಬೊಲಾನೆ ವರಿ ತಿವ್ನಾ ಕ್ಹಾತೆ ರ‍್ಹವಾನೆ ಘನ್ನೊ ಶಾಣ್ಯೊ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ಮೊಶೆ ಚಾ಼ಳಕ್ಹ ವರಕ್ಹನೊ ಥಯಲ್ಪರ ತೆ ತಿನಾ ಭಾಯೊನೆ ಮಳು ಕೈನ ಮನಸ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ತೆಳಾಮಾ ತ್ಯಾ ಯಕ್ಲೊ ಇಜಿಪ್ತವಾಲಾನಾ ಹತೆ ಘನ್ನೊ ತ್ರಾಸ ಖಾವಾನು ಮೊಶೆ ದೆಕಿನ ತಿನೆ ಮದದ ಕರಾನೆ ಗೈನ ಶೆಡ ಮ್ಹೆಲ್ಲಿನ ಇಜಿಪ್ತವಾಲಾನೆ ಖಲಾಸ ಕರಿ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ತಿನಾ ಸ್ವಂತ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ತಿನೆ ನೆಮಶ್ಯೊಸ ಕೈನ ತಿನಾ ಮನಕ್ಹೊ ವಳಕಿ ಲೆಸ ಕೈನ ಮೊಶೆ ತಿಳ್ದಿಲಿದ್ಯೊತೊ. ತೆನೈಸೊ ತ್ಯುನೆ ತಿನೆ ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ಮರ್ನಾ ದಿನ್ನೆ ಇಸ್ರೆಲನಾ ಬೆ ಜ಼ನಾ ಲಡೈ ಕಾಡಾನು ಮೊಶೆ ದೆಕ್ಯೊ. ತ್ಯುನೊನೆ ಸಮಾಧಾನ ಕರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊ. ತ್ಯುನೊನೆ ಭಾಯೊ ತುಮೆ ತುಮೆ ಅನಾ ಲಿಂಗತ ಲಡೈ ಕಾಡಾನು ತುಮೊನೆ ಚೊ಼ಕುಲಾಗ ಸು? ");
INSERT INTO sle_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ತೆನೈಸೊ ತ್ಯುನೊಮಾನೊ ಅನ್ಯಾಯ ಕರಾಲೊ ಯಕ್ಲೊ ಮೊಶೆನೆ ಪಾಚೊ಼ ಢಕ್ಲಿನ ಹಮಾರೊ ಫೈಸ್ಲೊ ಕರಾನೆ ಅದಿಕಾರ ಕುನ್ನ ದಿದ್ಯುಸ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ವರಿ ತೆ ಕಾಲ ಇಜಿಪ್ತವಾಲಾನೆ ಖಲಾಸ ಕರಲಲಿಂಗತ ಮನೆ ಬಿ ಖಲಾಸ ಕರು ಕೈನ ಛೆ ಸು? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ಎ ಕದಲ ಐಕಿನ ಮೊಶೆ ಇಜಿಪ್ತ ಛೊಡಿನ ನ್ಹಾಟಿನ ಗೈನ ಮಿದ್ಯಾನ ಕವಾನಾ ಗಾಮ್ಮಾ ಗೈನ ಬಿಜಾ಼ ದೆಶವಾಲಾ ಲಿಂಗತ ರ‍್ಹವಾಡ್ಯೊ. ತ್ಯಾ ತಿನೆ ಬೆ ಪಟ್ಟಾ ಹುಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ಚಾಳಕ್ಹ ವರಕ್ಹ ಥಯಲ್ಪರ ಯಕ್ಕ ದಿನ್ನ ಮೊಶೆನೆ ಸಿನಾಯಿ ಕವಾನಾ ಡೊಂಗರಪರ ಝಾಡಮಾ ಆಗ ಲಾಗಲ ದೆಕ್ಯೊ ವರಿ ತಿಮಾ ಯಕ್ಕ ದೆವ ದುತ ದಿಕ್ಹ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ಎ ಕ್ಹಾರು ಮೊಶೆ ದೆಕಿನ ಆಶ್ಚರ್ಯ ಥೈನ ತಿನೆ ನಜಿಕ ಗೈನ ದೆಕು ಕೈನ ಜಾ಼ತಾಮಾ ತ್ಯಾ ಪ್ರಭು ಝೊರ ಅವಾಜ಼ಕ್ಹು; ");
INSERT INTO sle_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ಮಿ ತಾರಾ ಪಿತೃವೊನೊ ಕ್ಹುದಾ ವ್ಹೈ; ಅಬ್ರಹಾಮ, ಇಸಾಕ ವರಿ ಯಾಕೊಬ್ನೊ ಕ್ಹುದಾ ವ್ಹೈ’ ಕೈನ ಕತಾಮಾ ಮೊಶೆ ಥರ ಥರ ಕಾಪ್ತೊ ಪಾಚೊ಼ ಸರಕಿ ಗಯೊ ವರಿ ಡೊಳಾ ಉಚೈನ ದೆಕ್ಯೊಬಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ಕರ್ತಾ ತಿನೆ\"ತು ಘಾಲ್ಲಿದಲ ಕಾರಮಲಿಯೊ ದುರ ಮ್ಹೆಲ. ಕಾಕದ್ಯಾಮ ತು ಹುಬ್ರಯಲ ಜ಼ಗಾ ಪವಿತ್ರ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ಇಜಿಪ್ತಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಮನಕ್ಹೊನಿ ಕೆಟ್ಟ ಸ್ತಿತಿ ಮನೆ ಗ್ವತ್ತ ಛೆ. ತ್ಯುನೆ ನೆಳ್ಳಾನು ದೆಕಿನ ತ್ಯುನೊನೆ ಬಿಡುಗಡೆ ಕರಾನೆ ಹೆಟೊ ಉತ್ರಿನ ಆಯೊಸ. ಆ, ಮಿ ತುನೆ ಇಜಿಪ್ತೆ ಮೊಕ್ಲುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ಅಪ್ನೊ ಫೈಸ್ಲೊ ಕರಾನೆ ಅದಿಕಾರ ತುನೆ ಕುನ್ನ ದಿದ್ಯೊಸ? ಕೈನ ಇಸ್ರಾಯಲೊಕ್ಹು ತಿರಸ್ಕಾರ ಥಯಲಜ಼ ಎ ಮೊಶೆ ವ್ಹೈ. ಆಗ ಲಾಗಲ ಝಾಡಮಾ ದಿಕ್ಹಲ ದುತನಾ ಮುಲಕ ಕ್ಹುದಾ ಅದಿಪತಿ ಕರಿನ ವಿಮೊಚ಼ಕ ಕರಿನ ನೆಮ್ಸಲ ಇನೆಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ಇಜಿಪ್ತಮಾ ಲಾಲ ಸಮುಂದರಮಾ ಚಾ಼ಳಕ್ಹ ವರಕ್ಹ ಉಸುಕನು ಗಾಮ್ಮಾ ಅದ್ಭುತ ಕಾಮೊ ವರಿ ಸುಚಕ ಕಾಮೊ ಕರಿನ ಇಸ್ರೆಯಲೊನೆ ಬಿಡುಗಡೆ ಕರಲವಾಲೊಜ಼ ಎ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ಕ್ಹುದಾ ಮನೆ ಮೊಕ್ಲಲ ಲಿಂಗತ ತುಮಾರಿ ಜನಾಂಗ್ತೊಜ಼ ಯಕ್ಕ ಪ್ರವಾದಿನೆ ಮೊಕಲ್ಯೊಸ ಕೈನ ಇಸ್ರೆಲೊನೆ ತಿಳಸಲ ಎಜ಼ ಮೊಶೆ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ಇಸ್ರಾಯಲೊ ಉಸುಕನಾ ಗಾಮ್ಮಾ ಸಬೆ ಮಳ್ತಾಮಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನಜ಼ ಸಿನಾಯಿ ಡೊಂಗರಪರ ಬೊಲಲ ದೆವ ದುತನಾ ಕ್ಹಾತೆ ಅಪ್ನಾ ಪಿತೃವೊನಾ ಕ್ಹಾತೆ ಸಂಭಾಶಣೆ ಕರಲ ವಾಲೊಜ಼ ಎಜ಼ ವ್ಹೈ. ಜ಼ಲಮ ರ‍್ಹಯಲ ತೆ ವ್ಹಂದಿಲಿನ ಅಪೊನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ತೆನೈಸೊ ಅಪ್ನಾ ಪಿತೃವೊ ತಿನೆ ವಿದೆಯ ಥಾವಾನೆ ಇನ್ಕಾರ‍್ಯಾ. ವರಿ ತ್ಯುನೆ ಇಜಿಪ್ತ ದೆಶ ಜಾ಼ವಾನೆ ಮನಸ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ಅಪ್ನಾ ಪಿತೃವೊ ಆರೊನನೆ, ‘ಮೊಶೆ ತುಮೊನೆ ಇಜಿಪ್ತ ದೆಶತೊ ಲಿನ ಆಯೊ. ತೆನೈಸೊ ತಿನೆ ಸು ಥೈಯು ಹಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತಿನಾಹುತಿ ಹಮಾರಾ ಕ್ಹಾಮೊ ಜಾ಼ವಾನೆ ವರಿ ಹಮೊನೆ ಚ಼ಲಾವಾನೆ ದಕ್ಹಾ ದೆವಸ್ಥಾನೊ ಕರ’ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ತಿನಾಹುತಿ ಮನಕ್ಹೊ ಬೈಲನಾ ಬಚ಼್ಚಾನು ಯಕ್ಕ ಮುರ್ತಿ ಕರಿನ, ತಿನೆ ಬಲಿ ದಿದ್ಯಾ. ತೆ ಮನಕ್ಹೊ ತ್ಯುನಾ ಹತೊಕ್ಹು ಕರಿಲಿದಲ ಮುರ್ತಿನಾ ವಿಷಯಮಾ ಘನ್ನಾ ಖುಶಿ ಕರ‍್ಯಾ! ");
INSERT INTO sle_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ತೆನೈಸೊ ಕ್ಹುದಾ ತ್ಯುನೊನೆ ವಿರುದ್ದ ಥೈನ, ಹಬಾಳನಾ ರ‍್ಹಯಲ ಸುರ‍್ಯಾನೆ ವರಿ ಚ಼ಂದಪ್ಪಾನೆ ಚುಕ್ಕಿಯೊನೆ ಪುಜಾ ಕರೆ ಲಿಂಗತ ತ್ಯುನೊನೆ ಛೊಡಿ ಪಾಡ್ಯೊ. ಇನಾಹುತಿ ಪ್ರವಾದಿಯೊನಾ ಪುಸ್ತಕೊಮಾ ಅಮ್ಮ ಬರ್ದಲ ಛೆ; ಕ್ಹುದಾ ಅಮ್ಮ ಕವಸ, ‘ಯೆಹುದಿನಾ ಮನಕ್ಹೊ ಥಯಲ ತುಮೆ ಚ಼ಾಳಕ್ಹ ವರಕ್ಹ ಲಕ್ಕಾ ಉಸುಕನಾ ಗಾಮಮಾ ರ‍್ಹತಾಮಾ ಮನೆ ಯಜ್ಞ ದಿದ್ಯಾ ನೈ? ");
INSERT INTO sle_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ತುಮೆ ತುಮಾರಾ ಕ್ಹಾತೆ ಮೊಲೊಖನ ಗುಡಾರ ವರಿ ತುಮಾರಾ ರೆಫಾ ದೆವಸ್ಥಾನ ಚಿಕ್ಕಿನು ರುಪ ಉಚೈಲಿನ ಗಯಾ ಪುಜಾ ಕರಾನಾ ಹುತಿ ತುಮೆ ಕರಿಲಿದಲ ಮುರ್ತಿಯೊ ಎಜ಼ ವ್ಹೈ. ತಿನಾಹುತಿ ಮಿ ತುಮೊನೆ ಬಾಬಿಲೊನನಾ ಹತ್ಮಾ ದಿಪಾಡುಸ. ಅಮ್ಮೊಸಾ 5:25-27 ");
INSERT INTO sle_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ಕ್ಹುದಾ ಅಪ್ನಾ ಪಿತೃವೊನಾ ಕ್ಹಾತೆ ಕಯಾ ಗುಡಾರಮಾ ಬೊಲ್ಯೊತೊ ತೆ ಗುಡಾರ ಎ ಯೆಹುದಿಯೊನಾ ಕ್ಹಾತೆ ಉಸುಕನಾ ಗಾಮಮಾ ವ್ಹತ್ತು. ಎ ಗುಡಾರ ತಯ್ಯಾರ ಕರಾನಿ ನಿಯಮ ಕ್ಹುದಾ ಮೊಶೆನೆ ಕೈನ ದಿದ್ಯೊ. ಕ್ಹುದಾ ತಿನೆ ದೆಕಾಡಲ ರುಪ ಲಿಂಗತ ಮೊಶೆ ತೆ ತಯ್ಯಾರ ಕರ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ಪಾಚಲ್ತೊ ಬಿಜಾ಼ ಜನಾಂಗನಾ ಗಾಮೊನೆ ವಶಮಾ ಕರಿಲಿವಾನೆ ಯೆಹುಶುವಾ ಅಪ್ನಾ ಪಿತೃವೊನೆ ಅಗೊ ಚ಼ಲಾಯೊ. ಅಪ್ನಾ ಮನಕ್ಹೊ ತೆ ದೆಶೊನೆ ಗಯಲ ಪರ, ಕ್ಹುದಾ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ತ್ಯಾಂತೊ ವಳೈ ಪಾಡ್ಯೊ. ಅಪ್ನಾ ಮನಕ್ಹೊ ತೆ ನವಾ ದೆಶಮಾ ಗಯಲ ಪರ ಎ ಗುಡಾರ ತ್ಯುನಾ ಕ್ಹಾತೆ ಲಿನ ಗಯಾ. ಅಪ್ನಾ ಮನಕ್ಹೊ ಎ ಗುಡಾರನೆ ತ್ಯುನಾ ಪಿತೃವೊ ಕಂತು ಸ್ವಿಕಾರ ಕರಿಲಿನ ದಾವಿದನಾ ಕಾಲ ಲಕ್ಕಾ ತೆ ಮ್ಹೆಲ್ಲಿದ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ಕ್ಹುದಾ ದಾವಿದನೆ ಘನ್ನೊ ಮೆಚ಼್ಚೊ. ‘ಯಾಕೊಬನಾ ಕ್ಹುದಾ ಥಯಲ ತಾರಾ ಹುತಿ ಯಕ್ಕ ಆಲಯ ಭಾಂದಾನೆ ಮನೆ ಮೌಕೊ ದೆ’ ಕೈನ ದಾವಿದ ಕ್ಹುದಾ ಕನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ತೆನೈಸೊ ಪ್ರಾಥನಾನಿ ಆಲಯ ಭಾಂದಲ ದಾವಿದನೊ ದಿಕ್ರೊ ಸೊಲೊಮೊನಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","\"ತೆನೈಸೊ ಮನಕ್ಹೊ ತ್ಯುನಾ ಹತೊಕ್ಹು ಕರಲ ಘರೊಮಾ ಮಹೊನ್ನತ ರ‍್ಹತೊ ನೈ. ಪ್ರವಾದಿ ಅಮ್ಮ ಬರ್ದ್ಯೊಸ; ");
INSERT INTO sle_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ಪ್ರಭು ಅಮ್ಮ ಕವಸ, ಸ್ವರ್ಗ ಮಾರಿ ಸಿಂಹಾಸನ ವ್ಹೈ. ಜಿಮಿನ ಮಾರಿ ಪಗೊ ಮ್ಹೆಲಾನಿ ಜ಼ಗಾ ವ್ಹೈ. ತುಮೆ ಮಾರಾ ಹುತಿ ಕಯಾ ತರಾನಿ ಘರ ಭಾಂದ ಸಕೊಶಿ? ಮಿ ಅರಾಮ ಕರಾನಿ ಜ಼ಗಾ ಕಿಜ್ಗಾ ಛೆ? ");
INSERT INTO sle_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ಶೆಂ ರ‍್ಹವಾದೆ, ಎ ಸಾಮನೊ ಕ್ಹಾರು ಕರಲವಾಲೊ ಮಿಜ಼ ವ್ಹೈ! ಯೆಶಾಯ 66:1-2 ");
INSERT INTO sle_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ಜಿದ್ದಕರಾಲಾವೊ, ತುಮಾರು ಮನಸ್ಸ ವರಿ ಹತೊ ಚೊ಼ಕಾ ನೈ ರ‍್ಹಯಲಕ್ಹು ತುಮೆ ತಿನಿ ವಾತ ನೈ ಐಕಲಖು ವರಿ ಪವಿತ್ರಾತ್ಮ ತಮನೊನೆ ತಿಳಸಾವಾನಿ ವಿಷಯಮ್ಮಾ ತುಮೆ ಕೆಳಾಮಾಬಿ ವಿರುದ್ದ ಥೈನ ವ್ಹತ್ತಾ. ತಮಾರಾ ಪಿತೃವೊ ಅಮ್ಮಜ಼ ಕರ‍್ಯಾ ವರಿ ತುಮೆ ತ್ಯುನಾಲಿಂಗತ ಛೆ! ");
INSERT INTO sle_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ಜುವತ್ತಾ ರ‍್ಹಯಲ ಪ್ರವಾದಿಯೊಮಾ ಹರಯಕ್ಲಾನೆ ತಮಾರಾ ಪಿತೃವೊ ತ್ರಾಸ ಕರ‍್ಯಾ. ನಿತಿವಾಲೊ ಯಕ್ಲೊ ಆವಸ ಕೈನ ಘನ್ನಾ ಟೈಮನಾ ಪಚಾ಼ಜ಼ ತೆ ಪ್ರವಾದಿಯೊ ಕದ್ಯಾ. ತಿನಾಹುತಿ ತಮಾರಾ ಪಿತೃವೊ ತೆ ಪ್ರವಾದಿಯೊನೆ ಖಲಾಸ ಕರಿ ಪಾಡ್ಯಾ. ಹಮ್ನಾ ತಿನಾಲಿಂಗತ ಸುಜ಼ ತಪ್ಪ ನೈ ಕರಲವಾಲಾ ಯೆಸು ಕ್ರಿಸ್ತನಾ ವಿರುದ್ದ ಥೈನ ತಿನೆಬಿ ಖಲಾಸ ಕರಿ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ಕ್ಹುದಾ ತಿನಾ ದುತೊನಾ ಮುಕಾಂತರ ದಿದಲ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರ ಲಿನ ತುಮೆಜ಼ ತಿನೆ ವಿಧೆಯ ಥಾತಾ ನೈ! ");
INSERT INTO sle_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ಸ್ತೆಫನಾ ಆ ವಾತೊ ಐಕಿನ ತೆ ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ಶ್ಯಾನ್ಯಾ ಘನ್ನಾ ಶಿಟ್ಟ ಥಯಾ. ತ್ಯುನೆ ಶಿಟ್ಟಕ್ಹು ಸ್ತೆಫಾನಾ ಉಪ್ಪರ ದಾತೊ ಕ್ಹಾವಾಡಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ತೆನೈಸೊ ಸ್ತೆಫನ ಪವಿತ್ರಾತ್ಮಕ್ಹು ಭರಿನ ತೆ ಸ್ವರ್ಗನೆ ದೆಕಿನ ಕ್ಹುದಾನಿ ಮಹಿಮಾ ವರಿ ಕ್ಹುದಾನಾ ಬಾಜು಼ಮಾ ಬೈಟೆಲ ಯೆಸುನೆ ದೆಕ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ದೆಕೊ ಸ್ವರ್ಗ ಖುಲ್ಲಾ ಥಯಲ ಮನಕ್ಹನೊ ದಿಕ್ರೊ ಕ್ಹುದಾನಾ ಶಿದಾ ಬಗಲ ಹುಬ್ರಯೆಲ ಮಿ ದೆಕಾಡೊಸ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ತೆಳಮಾ ಯೆಹುದಿಯೊನಾ ನಾಯಕೊ ಜೊ಼ರ ವದ್ರಿನ, ತ್ಯುನಾ ಕಾನೊ ಹತ್ತೊಕ್ಹು ಝಾಕಿಲಿದ್ಯಾ. ತ್ಯುನೆ ಕ್ಹಾರಾ ಸ್ತೆಫನ ಕನ ಮಳಿನ ನ್ಹಾಟತ್ತಾ, ");
INSERT INTO sle_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ತಿನೆ ಗಾಮ್ತಾ ಭಾರಾ ಎಳದಿನ ಲೈನ ತೆ ಮರೆಲಕ್ಕಾ ತಿನಾ ಉಪ್ಪರ ದಗ್ಡಾ ನಾಕ್ಯಾ ಸ್ತೆಫಾನೆ ವಿರುದ್ದ ಥೈನ ಸುಳ್ಳ ಕದಲ ಮನಕ್ಹೊ ತ್ಯುನಾ ಅಂಗ್ಡಾ ಕಾಡಿನ ಸೌಲಾ ಕವಾಲಾನೆ ದಿನ, ");
INSERT INTO sle_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ಸ್ತೆಫನನೆ ದಗ್ಡಾ ನಾಕ್ಯಾ ತೆನೈಸೊ ಸ್ತೆಫನ ಪ್ರಾರ್ಥನಾ ಕರತೊ \"ಪ್ರಭು ಥಯಲ ಯೆಸು ಮಾರಿ ಆತ್ಮಾನೆ ಒಪ್ಸುಸ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ತೆ ಉಂದಾಘುಡಗಾ ಘಾಲಿನ \"ಪ್ರಭು ಆ ಪಾಪ ತ್ಯುನಾ ಉಪ್ಪರ ಘಾಲು ನಕೊ! ಕೈನ ಜ಼ಲಮ ಛೊಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ಸೌಲಾನೆ ತಿನೆ ಖಲಾಸ ಕರಲ ತಿನೆ ಪಸಂದ ಐಯು. ತೆ ದಿನಮಾ ಯೆರುಸಲೆಮಾ ರ‍್ಹಯಲ ಸಭೆನೆ ಘನ್ನು ತ್ರಾಸ ಥಯು. ಅಪೊಸ್ತಲೊನೆ ಛೊಡಿನ ಬಿಜಾ಼ ಕ್ಹಾರಾ ವಿಶ್ವಾಸಿಯೊ ಯುದಾಯಮಾ, ಸಮಾರ್ಯಮಾ ಬಿಕರೈಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ತೆನೈಸೊ ಸೌಲಾ ಘರೊ ಘರೊಮಾ ಗೈನ ಮನಕ್ಹೊನೆ ಯಳ್ದಿಲೈನ ಕ್ಹಾರಾವೊನೆ ಜೆಲ್ಮಾ ಘಲೈನ ರ‍್ಹಯಲ ಸಭೆನೆ ಹಾಳ ಕರಾಡೊತೊ ");
INSERT INTO sle_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ವಿಸ್ವಾಸಿಯೊ ಜೆರುಸಲೆಮ ಛೊಡಿನ ಗೈ ಪಡಾಡಾತಾ. ಅಪೊಸ್ತಲೊ ಯಕ್ಕಜ಼ ತ್ಯಾಜ ವ್ಹತ್ತಾ. ವಿಸ್ವಾಸಿಯೊ ಜುದೆಯ ವರಿ ಸಮಾರ್ಯನಾ ಬಿಜಿ-ಬಿಜಿ ಜ಼ಗಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ತಿಮ್ಮ ಝುದಾ ಥಯಲ ಮನಕ್ಹೊ ತ್ಯಾ ತ್ಯಾ ಗೈನ ಸುವಾರ್ತೆ ಕವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ಪಿಲಿಪ್ಪ ಸಮಾರ್ಯಾ ಕವಾನಾ ಗಾಮೆ ಗೈನ ಕ್ರಿಸ್ತನಾ ಹುತಿ ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊಕನ ಸುವಾರ್ತೆ ಕವಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ಗುಂಪ ಥೈನ ಕುಡಿನ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಫಿಲಿಪ್ಪ ಕವಾನಿಯೊ ವಾತೊ ಐಕಿನ ತೆ ಕರಲ ಸುಚಕ ಕಾಮೊ ದೆಕಿನ ತೆ ಕದಲ ಸಂಗತಿಯೊನೆ ಧ್ಯಾನ ದಿನ ಐಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ತ್ಯಾ ಘನ್ನಾ ಮನಕ್ಹೊಮಾತಾ ಭುತ್ಡಾ ವದ್ರಿನ ಭಾರಾ ಆಯಾ, ವರಿ ಘನ್ನಾ ಜ಼ನಾ ಲಕ್ವೊ ಮಾರಲವಾಲಾ ರೊಗಿಯೊನೆ ವರಿ ಹತೊ ಪಗೊ ವಾಕಾ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊ ಅರಾಮ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ತಿನಾಹುತಿ ತೆ ಗಾಮನಾ ಮನಕ್ಹೊ ಘನ್ನಾ ಖುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ತೆನೈಸೊ ಘನ್ನಾ ದಿನತೊ ತೆ ಗಾಮ್ಮಾ ರ‍್ಹಯಲ ಸಿಮೊನ ಕವಾಲೊ ತೆ ಯಕ್ಕ ಮ್ಹೊಟೊ ಮನಕ್ಹ ವ್ಹೈ ಕೈನ ಕೈಲಿನ ಮಾಟಾ ಮಂತ್ರಾ ಕರ್ತೊ ಸಮರ್ಯಾಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊಮಾ ಭೆ ಘಾಲ್ಯೊತೊ. ವರಿ ಮಿಜ಼ ವ್ಹೈ ಕೈನ ಘನ್ನು ಹೊತ್ತು ತಿಮಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ನ್ಹಾನಾ ಮನಕ್ಹೊತಿ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಕ್ಹಾರಾ, ಇಕನ ಮ್ಹೊಟಿ ಕ್ಹುದಾನಿ ತಾಕತ ಛೆ ಕೈನ ಕವೈಲೆತೊ ತಿನಿ ತೆ ಕದಲಜ಼ ತಿಮ್ಮ ಐಕ್ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ಘನ್ನಾ ದಿನ್ತಾ ತೆ ಕರಾನಾ ಮಾಟಾ ಮಂತ್ರಾಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ತೆ ಕದಲ ತಿಮ್ಮಜ಼ ಐಕ್ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ತೆನೈಸೊ ಫಿಲಿಪ್ಪ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ವರಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಹುತಿ ಚೊ಼ಕಿಯೊ ವಾತೊ ಕವಾಕ್ಹು ದಾಣ್ಗಾ ವರಿ ಬಾಕ್ಡಿಯೊ ಬರೊಕ್ಹೊ ಕರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ತೆಳಾಮಾ ಸಿಮೊನಬಿ ಬರೊಕ್ಹೊ ಕರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯೊ ಫಿಲಿಪ್ಪನಾ ಕ್ಹಾತೆ ಹಮೆಶಾ ರ‍್ಹೈನ ಸುಚಕ ಕಾಮೊ ಮ್ಹೊಟಾ ಕಾಮೊ ಥಾವಾನು ದೆಕಿನ ಘಾಬ್ರೊ ಥಾತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ಸಮರ್ಯಾ ಗಾಮವಾಲಾ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಸ್ವಿಕಾರ ಕರಲ ವಾತ ಯೆರುಸೆಲೆಮಾ ರ‍್ಹಯಲ ಅಪೊಸ್ತಲೊ ಐಕಿನ, ಪೆತ್ರಾನೆ ವರಿ ಯೊಹಾನೆ ತ್ಯುನೊಕನ ಮೊಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ತ್ಯುನೆ ತೆ ಮನಕ್ಹೊಕನ ಐನ ತ್ಯುನೊನೆ ಪವಿತ್ರ ಆತ್ಮಾ ಮಳಾದೆ ಕೈನ ತ್ಯುನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ಕಾಕದ್ಯಾಮ ತ್ಯುನೊಮಾ ಕಿನೆಜ಼಼ ಹಜು಼ನಬಿ ಪವಿತ್ರ ಆತ್ಮಾ ಮಳಿ ನ್ಹೊತಿ. ತ್ಯುನೆ ಕ್ಹಾಲಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಪರ ಬಾಪ್ತಿಸ್ಮ ಯಕ್ಕಜ಼ ಕರೈಲಿದ್ಯಾತಾ. ತಿನಾಹುತಿಜ ಯೊಹಾನ ವರಿ ಪೆತ್ರಾ ತ್ಯಾ ಪ್ರಾರ್ಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ಅಪೊಸ್ತಲೊ ತೆ ಮನಕ್ಹೊನಾ ಮಾತಾಪರ ಹತೊ ಮ್ಹೆಲ್ತಾಮಾ ತ್ಯುನೊಪರ ಪವಿತ್ರ ಆತ್ಮಾನಿ ವರಾ ಮಳಿ. ");
INSERT INTO sle_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ಪೆತ್ರಾ ವರಿ ಯೊಹಾನ ಮನಕ್ಹೊನಾ ಮಾತಾಪರ ಹತ ಮ್ಹೆಲ್ತಾಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ಮಳಾನು ಸಿಮೊನೆ ದೆಕಿನ ದೊಕ್ಡಾಲೈನ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾಮೊ ಮುಕ್ಕಿನ, ");
INSERT INTO sle_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ವರಿ \"ಮಿ ಕಿನಾ ಮಾತಾಪರ ಹತ ಮ್ಹೆಲುಸ ತ್ಯುನೆ ಪವಿತ್ರ ಆತ್ಮಾನಿ ವರಾ ಮಳು ಕೈನ ಮನೆ ತೆವೊ ಅದಿಕಾರ ದಿವೊ ಕೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ತೆಳಾಮಾ ಪೆತ್ರಾ ತಿನೆ, ತಾರು ರುಪ್ಪು ತಾರಾ ಕ್ಹಾತೆಜ಼ ಹಾಳ ಥೈನ ಜಾ಼ವಾದೆ. ಕ್ಹುದಾ ದಿವಾನಿ ವರಾ ದೊಕ್ಡಾ ದಿನ್ನ ಇಕ್ಕಾತು ಲಿವಾನು ವ್ಹೈ ಕೈನ ತಿಳ್ದಿಲಿದ್ಯೊಸ? ");
INSERT INTO sle_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ಎ ಕಾಮಮಾ ತುನೆ ವಾಟೊಜ಼ ನತ್ತಿ ಕಾಕದ್ಯಾಮ ತಾರು ಮನಸ ಕ್ಹುದಾನಾ ಕ್ಹಾಮು ಚೊ಼ಕು ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ತಿನಾ ಹುತಿ ತು ತುಕನ ರ‍್ಹಯಲ ಕೆಟ್ಟತನಾ ಛೊಡಿನ ತು ಕರಲ ಪಾಪೊನೆ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ಫರ ಕರ್ತಾ ತಾರಾ ಮನಸ್ಮಾ ರ‍್ಹಯಲ ವಿಚಾರೊನೆ ಮಾಫ ಕರಸ ತಿಕನ ಮಾಂಗಿಲೆ. ");
INSERT INTO sle_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ತು ಘನ್ನಾ ಕೆಟ್ಟ ವಿಚಾರೊಕ್ಹು ಭರ‍್ಯೊಸ ವರಿ ಪಾಪ ತುಪರ ರಾಜ ಕರಸ, ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ತೆ ವಾತೆ ಸಿಮೊನ, ತುಮೆ ಕದಲ ವಾತೊ ಲಿಂಗತ ಕಯುಜ಼ ಮಪರ ರ‍್ಹಯೆ ನೈಸೊ ಮಾರಾ ಹುತಿ ಕರ್ತಾಕನ ಮಾಂಗಿಲಿವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ಇಮ್ಮ ರ‍್ಹೈನ ತ್ಯುನೆ ಕರ್ತಾನಿ ವಾಕ್ಯಾ ತ್ಯುನೆ ರ‍್ಹಯಲ ಕ್ಹಾರಿ ಜ಼ಗಾ ಕದಲ್ಪರ ಯೆರುಸೆಲೆಮ ಫರಿನ ಐನ ಸಮರ್ಯಾಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನಾ ಗಾಮೊಯೆ ಗೈನ ಸುವಾರ್ತೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ಕರ್ತಾನೊ ದುತ ಫಿಲಿಪ್ಪನೆ ತು ಉಟಿನ ದಕ್ಷಿಣನಾ ಕ್ಹಾಮೊ ರ‍್ಹಯಲ ಜೆರುಸೆಲಿಮ್ಮಾ ಗಾಜನೆ ಜಾ಼ವಾನಿ ವಾಟೆ ಜಾ಼ ತೆ ವಾಟ್ಮಾ ಕುನ್ನಜ಼ ಆತು ಜಾ಼ತು ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ತಿನಾ ಲಿಂಗತಜ಼ ಫಿಲಿಪ್ಪ ದುತ ಕದಲ ಲಿಂಗತಜ ಗಯೊ ತೆ ವಾಟ್ಮಾ ಇಥೊಪಿಯಾನೊ ಯಕ್ಲೊ ಮನಕ್ಹ ದಿಕ್ಹೊ ತೆ ಮನಕ್ಹ ಇಥಿಯೊಪಿಯಾನಾ ಕಂದಾಕೆ ಕವಾಲಿ ರಾಣಿನಾ ದರಬಾರಮಾ ಯಕ್ಕ ಅದಿಕಾರಿ ವ್ಹತ್ತೊ. ತೆ ತಿನಾ ದೊಕ್ಡಾ ಕ್ಹಮಾಳಾವಾಲೊ ವ್ಹೈ. ತೆ ಮನಕ್ಹ ಜೆರುಸಲೆಮನೆ ಕ್ಹುದಾನಿ ಆರಾಧನಾ ಕರಾನೆ ಗಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ತೆ ತಿನಾ ಗಾಮೆ ಫರಿನ ರಥಮಾ ಬೈಟಿನ ಯೆಶಾಯನು ಬುಕ್ಕ ಒದತೊ ಚಾ಼ಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ಪವಿತ್ರ ಆತ್ಮಾ ಫಿಲಿಪ್ಪನೆ, ತು ಅಗೊ ಗೈನ ರಥಾನಾ ಕ್ಹಾಮೊ ಹುಬ್ರೆ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ತಿನಾ ನಿಗಂತಜ ಫಿಲಿಪ್ಪ ಅಗೊ ಗೈನ ತೆ ಯೆಶಾಯನಿ ಪ್ರವಾದನೆ ಒದಾನು ಐಕ್ಯೊ. ತು ಒದಾನು ತುನೆ ಗ್ವತ್ತ ಥಾವಾಡ್ಯುಸು? ಕೈನ ತಿನೆ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ತೆ ಅದಿಕಾರಿ ತಿನೆ ಮಿ ಒದಾನು ಕುನ್ನಬಿ ತಿಳಶ್ಯಾವಾಚಿ ಮನೆ ಕಿಮ ಗ್ವತ್ತ ಥಾಸ? ಕೈನ ಕದ್ಯೊ. ರಥಾ ಚ಼ಡಿನ ಬೈಟಾ ಕೈನ ಫಿಲಪ್ಪನೆ ತೆ ಅದಿಕಾರಿ ಬಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ತೆ ಒದಾನು ಪ್ರವಾದನೆ ಅಮ್ಮ ವ್ಹತ್ತಿ; ಕತ್ರಾನಿ ಜ಼ಗಾಪರ ನಿಂಜಾಯಲ ಬಕ್ರಾ ಲಿಂಗತ ತೆ ವ್ಹತ್ತೊ. ಬಕ್ರು ಕಿಮ ಬಾಲೊ ಕತ್ರಾಲಾನಾ ಕ್ಹಾಮು ಗಪ್ಪ ರ‍್ಹವಸ ತಿನಾ ಲಿಂಗತಜ಼ ತೆ ಗಪ್ಪ ವ್ಹತ್ತೊ. ತೆ ವಟ್ಟಜ ಮ್ಹೊಡು ಖೊಲ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ತಿನಿ ಮರ್ಯಾದಿ ಕಾಡ್ಯಾ ತಿನೆ ನ್ಯಾಯ ಮಳ್ಯೊ ನೈ ಲಾಸ್ಟೆ ತಿನೊ ಜಲಂಬಿ ಕಾಡಿ ಪಡ್ಯಾ ತಿನಾ ಖಾಂದಾನನಾ ಹುತಿ ಕುನ್ನ ಬೊಲಸಕಸ ");
INSERT INTO sle_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ತೆ ಮನಕ್ಹ ಪಿಲಿಪನೆ ಎ ಪ್ರವಾದಿ ಕಿನಾ ಹುತಿ ಕವಾಡ್ಯೊಸ. ತಿನಾ ಹುತಿಜ಼ ವ್ಹೈ ಸು? ಸು ಬಿಜಾ಼ ಪ್ರವಾದಿನಾ ಹುತಿ ವ್ಹೈ ಸು? ಮನೆ ಕೆ ಕೈನ ಫಿಲಿಪ್ಪನೆ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ತಿನಾಹುತಿ ಫಿಲಿಪ್ಪ ತಿನೆ ಯೆಶಾಯನಾ ಬುಕ್ಕಕಂತೊ ಧರಿನ ಯೆಸು ಸ್ವಾಮಿನಾ ವಿಷಯಮಾ ಹರಿಯಕ್ಕ ತಿಳಸಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ತ್ಯುನೆ ವಾಟ್ಮಾ ಜಾ಼ತಾಮಾ ಯಕ್ಕ ತಳಾನಾ ನಜಿಕ ಆಯಾ. ತೆಳಾಮಾ ತೆ ಮನಕ್ಹ ದೆಕ ನ್ಹ್ಯಾ ಪಾನಿ ಛೆ ಬಾಪ್ತಿಸ್ಮ ಲಿವಾನೆ ಮನೆ ಸುಬಿ ಅಡ್ಡ ಛೆಸು? ಕೈನ ಫಿಲಿಪ್ಪನೆ ಪುಚ್ಯೊ಼. ");
INSERT INTO sle_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ತೆ ವಾತೆ ಫಿಲಿಪ್ಪ ತಾರಾ ಮನಸ ಕ್ಹರಿನೆ ನಂಬಾನೊ ರ‍್ಹಯೊಮ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲೆ ಸಕಸ ಕೈನ ಕದ್ಯೊ. ತೆ ವಾತೆ ಯೆಸು ಕ್ರಿಸ್ತನೆ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ಮಿ ಬರೊಕ್ಹೊ ಕರುಸ ಕೈನ ");
INSERT INTO sle_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ರಥಾ ಹುಬ್ರಾಡಾನೆ ಆಗ್ಯಾ ದಿದ್ಯೊ\" ತೆಳಾಮಾ ಅದಿಕಾರಿ ವರಿ ಫಿಲಿಪ್ಪ ಪಾನಿಮಾ ಉತ್ರ್ಯಾ ಫಿಲಿಪ್ಪ ಅದಿಕಾರಿನೆ ಬಾಪ್ತಿಸ್ಮ ದಿಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ತ್ಯುನೆ ಪಾನಿಮಾತಾ ಭಾರಾ ಆತಾಮಾ ಕರ್ತಾನಿ ಆತ್ಮಾ ಫಿಲಿಪ್ಪನೆ ಲಿನ ಗೈ ಅದಿಕಾರಿನೆ ತೆಳಾಮಾತೊ ತೆ ದಿಕ್ಹ್ಯೊಜ಼ ನೈ. ತೆ ಜಾ಼ವಾನಿ ವಾಟೆ ಜಾ಼ತಾಮಾ ಖುಶಿಮಾಜ಼ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ತೆ ಥಯಲ್ಪರ ಫಿಲಿಪ್ಪ ಅಜೊತಿಮಾ ದಿಕ್ಹಿನ ತ್ಯಾಂತೊ ಕೈಸೆರೆ ಆಯೆಲಕ್ಕಾ ಕ್ಹಾರಾ ಗಾಮೊಮಾ ಸುವಾರ್ತೆ ಕತೊಜ಼ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ಸೌಲಾ ಕರ್ತನಾ ಶಿಷ್ಯಾವೊನೆ ಭುಚ್ಕಾ಼ಡತೊ ವರಿ ತ್ಯುನೊನೆ ಖಲಾಸ ಕರು ಕೈನ ಕೊಶಿಶ ಕರಾಡೊತೊ. ತಿನಾಹುತಿ ತೆ ಮ್ಹೊಟಾ ಯಾಜಕಕನ ಗೈನ, ");
INSERT INTO sle_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ಪ್ರಭುನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ದಾಣ್ಗಾ ರ‍್ಹಯಾತಬಿ ಬಾಕ್ಡಿಯೊ ರ‍್ಹಯ್ಯೊತಬಿ ತೆ ತ್ಯುನೊನೆ ಭಾಂದಿನ ಯೆರುಸೆಲೆಮೆ ಲೌ ಕೈನ ದಮಸ್ಕಮಾ ರ‍್ಹಯಲ ಬಿಜಿಯೊ ಸಭಾಮಂದಿರೊಮಾ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಚಿಟಿಯೊ ದ್ಯು ಕೈನ ತಿಕನ ಮಾಂಗಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ತಿನಾಹುತಿ ತೆ ದಮಸ್ಕನೆ ಜಾ಼ತಾ ಟೈಮಾ ತಿನಾ ಕ್ಹಾಮು ಮ್ಹೊಟ್ಟೊ ಉಜಾಲು ಹಬಾಳಮಾತು ಉತ್ರಿನ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ತೆಳಾಮಾ ತೆ ಜಿಮಿನ್ಪರ ಪಡ್ತಾಮಾ -ಸೌಲಾ ಸೌಲ, ತು ಮನೆ ಕಾ ತ್ರಾಸ ಕರಾಡ್ಯೊಸ ಕೈನ ಯಕ್ಕ ಆವಾಜ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ತೆಳಾಮಾ ತೆ, ಪ್ರಭು ತು ಕುನ್ನ ವ್ಹೈ” ಕೈನ ಪುಚ಼ತಾಮಾ ತು ಕಿನೆ ತ್ರಾಸ ಕರಾಡೊಸ ದೆಕ ತೆ ಯೆಸುಜ಼ ಮಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ತೆ ವಾತೆ ಕರ್ತಾ ತಿನೆ ತು ಉಟಿನ ಗೈನ ಗಾಮ್ನಾ ಮ್ಹೈ ಜಾ಼, ತ್ಯಾ ತು ಸುಕರು ಕೈನ ಮಿ ತುನೆ ತಿಳಸೌಸ. ");
INSERT INTO sle_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ತಿನಾ ಕ್ಹಾತೆ ಆಯಲವಾಲಾ ಕ್ಹಾಲಿ ಅವಾಜ಼ ಯಕ್ಕಜ಼ ಐಕ್ಯಾ ತ್ಯಾ ಕುನ್ನಜ ನೈ ರ‍್ಹಯಲ ದೆಕಿನ ಘನ್ನಾ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ಸೌಲಾ ಜಿಮಿನ್ಪರ್ತೊ ಉಟಿನ ಡೊಳಾ ಕಾಡಿನ ದೆಕ್ತಾಮಾ ಕುನ್ನಜ಼ ದಿಕ್ಹು ನೈ. ತೆಳಾಮಾ ತಿನಾ ಕ್ಹಾತೆ ಆಯಲ ಮನಕ್ಹೊ ತಿನೊ ಹತ್ತ ಧರಿನ ದಮಸ್ಕ ಗಾಮೆ ಲಿನ ಗಯಾ; ");
INSERT INTO sle_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ತಿನೆ ತನ್ನ ದಿನ್ನ ಲಕ್ಕಾಬಿ ಡೊಳಾ ದಿಕ್ಹ್ಯಾ ನೈ ವರಿ ತೆ ತನ್ನ ದಿನ್ನ ಲಕ್ಕಾಬಿ ಅನ್ನ ಖಾದ್ಯೊನೈ ಪಾನಿಬಿ ಪಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ದಮಸ್ಕ ಗಾಮಮಾ ಅನನಿಯ ಕವಾಲೊ ಯೆಸು ಸ್ವಾಮಿನೊ ಯಕ್ಕ ಶಿಶ್ಶೊ ವ್ಹತ್ತೊ; ಕರ್ತಾ ತಿನೆ ದರ್ಶನಮಾ, ಅನನಿಯಾ ಕೈನ ಬಲಾತಾಮಾ ತೆ ಪ್ರಭು ಮಿ ನ್ಹ್ಯಾ ಛೆ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ಪ್ರಭು ಅನನಿಯನೆ, ತು ಉಟಿನ ಮಿ ಕದಲ ವಾಟೆ ಜಾ಼ ತುನೆ ತ್ಯಾ ಯುದನು ಘರ ಮಳಸ ತೆ ಘರಮಾ ಗೈನ ತ್ಯಾ ತಾರ್ಸತೊ ಆಯಲ ಸೌಲನಾ ಹುತಿ ಪುಚ್ಚ ತೆ ಹಮ್ನಾ ತ್ಯಾ ಪ್ರಾರ್ಥನಾ ಕರಾಡೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ಪೌಲ ಯಕ್ಕ ದರ್ಶನ ದೆಕ್ಯೊಸ ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾಮ; ಅನನಿಯ ಕವಾಲೊ ಯಕ್ಕ ಮನಕ್ಹ ಮ್ಹೈ ಐನ ತಿನಾ ಮಾತಾಪರ ಹತ ಮ್ಹೆಲಸ ತೆಳಾಮಾ ಫರಿನ ತಿನೆ ಡೊಳಾ ದಿಕ್ಹಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ತೆ ವಾತೆ ಅನನಿಯಾ - ಪ್ರಭು, ತೆ ಮನಕ್ಹ ಯೆರುಸೆಲಿಮಮಾ ತಾರಾ ಪರಿಶುದ್ಧ ಮನಕ್ಹೊನೆ ಕೆಕ್ಲು ಕೆಟ್ಟ ಕರ‍್ಯೊಸ ಕವಾನು ಮಿ ಮನಕ್ಹೊನಾ ಮ್ಹೊಡಾತೊ ಐಕ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ತೆ ಹಮ್ನಾ ದಮಸ್ಕ ಗಾಮೆ ಆಯೊಸ ವರಿ ತುಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾವಾಲಾ ಮನಕ್ಹೊನೆ ಜೆಲಮಾ ಘಾಲಾನು ಅದಿಕಾರ ಮ್ಹೊಟಾ ಯಾಜಕೊ ತಿನೆ ದಿದ್ಯಾಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ತೆನೈಸೊ ಕರ್ತಾ ತಿನೆ, ತು ಜಾ಼; ಮ್ಹೊಟಾ ಕಾಮನಾ ಹುತಿ ಮಿ ಸೌಲಾನೆ ಇನಿಲಿದ್ಯೊಸ. ತೆ ಮಾರಾ ಹುತಿ ರಾಜಾ಼ವೊನೆ ಯಹುದಿಯೊನೆ ವರಿ ಬಿಜಾ಼-ಬಿಜಾ಼ ಮನಕ್ಹೊವೊನೆಬಿ ತಿಳಸು ಕೈನ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ತೆ ಮಾರಾ ನಾಮಪರ ಕೆಕ್ಲೊ ತ್ರಾಸ ಖೌ ಕೈನ ತಿನೆ ಮಿಜ಼ ದೆಕಾಡಿನ ದ್ಯುಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ತೆಳಾಮಾ ಅನನಿಯಾ ಪೌಲಾ ರ‍್ಹಯಲ ಘರ್ಮಾ ಗೈನ ತಿನಾ ಮಾತಾಪರ ತಿನಾ ಹತೊ ಮ್ಹೆಲಿನ, ಮಾರಾ ಭೈ, ತು ಆಯಲ ವಾಟ್ಮಾ ತುನೆ ದಿಕ್ಹಲ ಪ್ರಭು ಥಯಲ ಯೆಸು ತುನೆ ಡೊಳಾ ದಿಕ್ಹಾ ವರಕ್ಹು, ತು ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರು ಕೈನ ಮನೆ ತುಕನ ಮೊಕ್ಲ್ಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ತೆಳಾಮಾ ತಿನಾ ಡೊಳಾಮಾತು ಪರಿ ಲಿಂಗತ ಸು ಯಕ್ಕ ಪಡಿನ ತಿನಾ ಡೊಳಾ ದಿಕ್ಹ್ಯಾ. ತೆಳಾಮಾ ತೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ತೆಳಾಮಾ ತೆ ಅನ್ನ ಖಾದ್ಯೊ. ತೆ ದಮಸ್ಕಮಾ ರ‍್ಹಯಲ ಯೆಸು ಸ್ವಾಮಿನಾ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ತ್ಯಾಜ ದಕ್ಹಾ ದಿನ್ನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ತೆ ತೆಳಾಮಾಜ಼ ಸಬಾಮಂದಿರೊಮಾ ಯೆಸುನಾ ಹುತಿ ತೆಜ಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕವಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ತೆ ಐಕಲವಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಗಾಬ್ರಾ ಥೈನ ಕ್ರಿಸ್ತನು ನಾಮ ಕವಾಲಾವೊನೆ ಯೆರುಸೆಲೆಮಮಾ ಖಲಾಸ ಕರಾಲೊ ಎಜ಼ ನ್ಹವ್ಹೈ ಸು? ಯೆಸುನಾ ಶಿಷ್ಯಾವೊನೆ ಬೆಡಿಯೊ ಘಾಲಿನ ಖಾಸ ಯಾಜಕೊಕನ ಲಿನಜಾ಼ವಾದೆ ಕೈನ ನ್ಹ್ಯಾ ಆಯೊಸ ಸು ಕೈನ ಬೊಲ್ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ಸೌಲಾ ವರಿ ಯೆಸುಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಘನ್ನಾ ಬರೊಕ್ಹಾಕ್ಹು ಜೊ಼ರ-ಜೊ಼ರ ಕವಾಡೊತೊ. ತೆ ಕವಾನಾ ವಾತೊ ಕ್ಹರಿ ರ‍್ಹಯಲಕ್ಹು ದಮಸ್ಕಮಾ ರ‍್ಹಯಲ ಯೆಹುದಿಯೊ ತಿನೆ ಸುಜ಼ ಬೊಲ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ಘನ್ನಾ ದಿನ್ನೊ ಥಯಲ್ಪರ ಯಹುದಿಯೊ ಸೌಲನೆ ಖಲಾಸ ಕರು ಕೈನ ವಿಚಾರ ಕರಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ತಿನೆ ಖಲಾಸ ಕರಾನಾ ಹುತಿ ತ್ಯುನೆ ದಿನ್ನ ರಾತ ಗಾಮ್ನಾ ಬಾಕಲನಾ ಕ್ಹಾಮಾ ತ್ಯುನೆ ಕೈದತಾತಾ. ತೆನೈಸೊ ತ್ಯುನೆ ವಿಚಾರ ಕರಿಲಿದಲ ಸೌಲಾನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ತೆನೈಸೊ ಸೌಲಾನೆ ಯೆಸು ಸ್ವಾಮಿನಾ ಶಿಷ್ಯಾ ರಾತನಾ ಟೈಮಮಾ ತಿನೆ ಬಲೈ ಲಿನ ಗೈನ, ಯಕ್ಕ ಟೊಪ್ಲಾಮಾ ಬೈಟಾಡಿನ ಗೊಡಿನಾ ಸಂದಿಮಾ ಉತಾರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ತೆ ಯೆರುಸಲೆಮೆ ಐನ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಮಳು ಕೈನ ಕೊಶಿಶ ಕರ‍್ತಾಮಾ ತ್ಯಾ ರ‍್ಹಯಲವಾಲಾ ತಿನೆ ಯೆಸುನಾ ಶಿಷ್ಯೊ ನ್ಹವೈ ಕೈನ ನಂಬಿನ ಭುಚ಼ಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ತೆನೈಸೊ ಬಾರ್ನಬ ತಿನಿ ಮದತ ಕರನಾ ಹುತಿ ಅಪೊಸ್ತಲೊಕನ ಬಲೈಲಿನ ಗೈನ ತೆ ದಮಸ್ಕನಿ ವಾಟ್ಮಾ ಕರ್ತಾನೆ ದೆಕಲ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಲ ದಮಸ್ಕಮಾ ಯೆಸುನಾ ನಾಮಪರ ಧೈರ‍್ಯಕ್ಹು ಕೈನ ತ್ಯುನೊನೆ ತಿಳಸೈನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ತೆ ಥಯಲ್ಪರ ಸೌಲಾ ಯೆರೊಸೆಲಿಮಾ ರ‍್ಹೈನ ತ್ಯುನೊಕನ ಆತಾ ಜಾ಼ತಾ ರ‍್ಹಯಲವಾಲಾವೊನ ಪ್ರಭುನಾ ನಾಮಪರ ಧೈರ್ಯಕ್ಹು ಭೊದನೆ ಕರ‍್ತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ವರಿ ಗ್ರಿಕಮಾ ಬೊಲಾಲಾ ಯಹುದಿಯೊನಾ ಕ್ಹಾತೆ ವಾದ-ವಿವಾದ ಕರ‍್ತೊತೊ. ತೆನೈಸೊ ತ್ಯುನೆ ತಿನೆ ಖಲಾಸ ಕರು ಕೈನ ಕೊಶಿಶ ಕರ‍್ತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ಕ್ರಿಸ್ತಮಾ ಭಾಯೊ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಎ ಕ್ಹಾರು ಗ್ವತ್ತ ಥಾತಾಮಾ ತ್ಯುನೆ ತಿನೆ ಕೈಸರೈಯೆ ಲಿನ ಗೈನ, ತ್ಯಾಂತಾ ತಾರ್ಸನೆ ಮೊಕಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಯುದಾಯ ವರಿ ಗಲಿಲಾಯ ಸಮಾರ್ಯಾ ಸಿಮೆಮಾ ರ‍್ಹಯಲ ಸಬೆ ಸಮಾಧಾನ ವ್ಹಂದ್ಯು ವರಿ ಕರ್ತಾನಿ ಭೆಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹು ಪ್ರೊತ್ಸಾಹ ಹೊಂದಿನ ಬೆಳದತು ಆಯು. ");
INSERT INTO sle_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ಪೆತ್ರಾ ಕ್ಹಾರಿ ಬಗಲ ಫರಿನ ಆತಾಮಾ ಲುದ್ದಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊಕನ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ತ್ಯಾ ಲಕ್ವೊ ಮಾರಲವಾಲಾನೆ ಆಟ ವರಕ್ಹತೊ ವಚ್ಚಾ಼ನಾಪರ ಪಡಲ ಐನೆಯ ಕವಾಲೊ ಯಕ್ಲಾ ಮನಕ್ಹನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ಪೆತ್ರಾ ತಿನೆ ಐನೆಯಾ ಯೆಸು ಕ್ರಿಸ್ತ ತುನೆ ಅರಾಮ ಕರಸ ತು ಉಟಿನ ತಾರು ವಚ್ಚಾ಼ನು ತುಜ಼಼ ಮಡಚ಼ ಕೈನ ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತೆ ಉಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ವರಿ ಲುದ್ದಮಾ, ಶಾರೊನಮಾ ರ‍್ಹವಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತಿನೆ ದೆಕಿನ, ತ್ಯುನೆ ಕರ್ತಾಕನ ಫರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ಯೊಪ್ಪ ಗಾಮಾಮಾ ತಬಿಥಾ ಕವಾಲಿ ಯಕ್ಕ ವಿಸ್ವಾಸಿ ವ್ಹತ್ತಿ. ತೆ ನಾಮನೆ ಗ್ರಿಕಮಾ ಭಾಶಾಮಾ ದೊರ್ಕ ಕದ್ಯಾಮ ಚಿಗರಿ ವ್ಹೈ. ತೆ ಚೊ಼ಕಾ ಕಾಮೊ ವರಿ ದಾನ ಧರ್ಮ ಘನ್ನಾ ಕರತಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ತೆ ಕಾಲಮಾ ತೆ ರೊಗ ಲಾಗಿನ ಮರಿಗೈ. ತಿನಾ ಮರಲ ಅಂಗನೆ ಧ್ವಯಿನ ಉಪ್ಪರಲ್ಯಾ ಅಂಟಾಪರ ಖೊಲಿಮಾ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ಯೊಪ್ಪನಾ ನಜಿಕ ರ‍್ಹಯಲ ಹುತಿ ಪೆತ್ರಾ ತ್ಯಾ ಛೆ ಕೈನ ಶಿಷ್ಯಾ ಐಕಿನ ಬೆ ಮನಕ್ಹೊನೆ ತಿಕನ ಮೊಕಲ್ಯಾ. ತಡಾ ಕರ‍್ಯಾವಾಚಿ ಹಮೊಕನ ಔ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ಪೆತ್ರಾ ಉಟಿನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಗಯೊ. ತೆ ಆಯಲಬರೊಬ್ಬರ ತ್ಯುನೆ ತಿನೆ ಅಂಟಾಪರ ರ‍್ಹಯಲ ಖೊಲಿಮಾ ಬಲೈಲಿನ ಗಯಾ ತ್ಯಾ ಮಾಟಿ ಮರಲವಾಲಿಯೊ ರವಾಡಿಯೊತ್ಯೊ. ತೆ ನಜಿಕ ಹುಬ್ರೈನ ದೊರ್ಕಳ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹತಾಮಾ ಕರಿನ ದಿದಲ ಪೆರಿಲಿವಾನಾ ವಣ್ಣಾ ಪೆತ್ರಾನೆ ದೆಕಾಡಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ಪೆತ್ರಾ ತ್ಯುನೊನೆ ಕ್ಹಾರಾವೊನೆ ಭಾರೊ ಮೊಕಲಿನ ಉಂದಾಗುಡಗಾ ಘಾಲ್ಲಿನ ಪ್ರಾಥನಾ ಕರಿನ ಮುರ್ದಾ ಬಗಲ ಫರಿನ ತಬಿಥಾ ಉಟ್ಟ ಕದ್ಯೊ. ತೆ ಡೊಳಾ ಕಾಡಿನ ಪೆತ್ರಾನೆ ದೆಕಿನ ಉಟಿನ ಬೈಟಿ. ");
INSERT INTO sle_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ತೆ ತಿನೊ ಹತ ಧರಿನ ಉಟಾಡಿ ಮಾಟಿ ಮರಲವಾಲಿಯೊಕನ ವರಿ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊಕನ ಲಿನ ಗೈನ ಜಿವಿತಿ ಥಯಲವಾಲಿನೆ ತ್ಯುನಾ ಕ್ಹಾಮೊ ಹುಬ್ರಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ಎ ಸಂಗತಿ ಯೊಪ್ಪಮಾ ಫೈಲಿನ ಘನ್ನಾ ಜ಼ನಾ ಪ್ರಭು ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ತೆ ಥಯಲ್ಪರ ಪೆತ್ರಾ ಯೊಪ್ಪಮಾ ಚಾ಼ಮ್ಡಾನು ಕಾಮ ಕರಾಲೊ ಸಿಮೊನ ಕವಾಲಾನಾ ಘರಮಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ಕೈಸರೈಯ ಗಾಮಮಾ ಕೊರ್ನೆಲಿಯ ಕವಾಲೊ ವ್ಹತ್ತೊ. ರೊಮನಾ ಸೈನ್ಯನೆ ಮಳಲ ‘ಇಟಲಿನಾ ದಳ’ ಮಾ ತೆ ಅದಿಕಾರಿ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ಕೊರ್ನೆಲಿಯ ಕ್ಹುದಾನೊ ಭಕ್ತ ವ್ಹತ್ತೊ. ತೆ ವರಿ ತಿನಾ ಘರಮಾ ರ‍್ಹಯಲ ಬಿಜಾ಼ ಕ್ಹಾರಾ ಜ಼ನಾ ಕ್ಹರಿನಾ ಕ್ಹುದಾನೆ ಆರಾಧನಾ ಕರ‍್ತಾತಾ. ತೆ ಗರಿಬೊನೆ ದೊಕ್ಡಾವೊನಿ ಮದತ ಕರ್ತೊತೊ. ಕೆಳಾಮಾಬಿ ಕ್ಹುದಾನೆ ಪ್ರಾಥನಾ ಕರ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ಯಕ್ಕ ದಿನ್ನ ದುಪ್ಪಾರೆ ತನ್ನ ವಾಸ್ತಾನಾ ಸುಮಾರೆ ಕೊರ್ನೆಲಿಯನೆ ಯಕ್ಕ ದರ್ಶನ ಥಯು. ತೆ ತಿನೆ ಯಕ್ಕಜ಼ ಸಂವಾ ದೆಕ್ಯೊ. ತೆ ದರ್ಶನಮಾ ಕ್ಹುದಾನೊ ದುತ ಯಕ್ಲೊ ತಿಕನ ಐನ\"ಕೊರ್ನೆಲಿಯ \"ಕೈನ ಬಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ಕೊರ್ನೆಲಿಯ ಕ್ಹುದಾನಾ ದುತನೆ ದೆಕಿನ ಭೆಂಕ್ಹು \"ಸ್ವಾಮಿ, ಆ ಸುವೈ? ಕೈನ ಪುಚ್ಯೊ. ತೆ ಕ್ಹುದಾನೊ ದುತ ತಿನೆ \"ಕ್ಹುದಾ ತಾರಿ ಪ್ರಾಥನಾ ಐಕ್ಯೊಸ. ತು ಗರಿಬೊನೆ ದಿದಲ ಕ್ಹಾರು ದೆಕ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ಹಮ್ನಾ ಸಿಮೊನ ಕವಾಲಾ ಮನಕ್ಹನೆ ಬಲೈಲಿನ ಆವಾನಾ ಹುತಿ ತು ಮನಕ್ಹೊನೆ ಯೊಪ್ಪ ಗಾಮೆ ವಳಾ. ಸಿಮೊನನೆ ‘ಪೆತ್ರಾ’ ಕೈನ ಬಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ಸಿಮೊನ ಚಾ಼ಮ್ಡಾನು ಕಾಮ ಕರಾಲಾನಾ ಘರಮಾ ಛೆ. ತಿನು ಘರ ಸಮುಂದರನಾ ದಂಡಿಯೆ ಛೆ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ಕೊರ್ನೆಲ್ಯನ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಲ ದೆವದುತ ಗಯಲ್ಪರ, ತಿನಾ ಘರ್ಮಾ ರ‍್ಹಯಲ ಆಳೊಮಾ ಬೆ ಜ಼ನಾ ವರಿ ತಿನಾ ಕ್ಹಾಮಾ ಕೆಳಾಮಾಬಿ ರ‍್ಹವಾಲಾ ಸಿಪಾಯಿಯೊಮಾ ಯಕ್ಕ ಕ್ಹುದಾನಾ ಭಕ್ತನೆ ಬಲೈನ, ");
INSERT INTO sle_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ಕೊರ್ನೆಲಿಯ ತೆ ತನ್ನೆ ಜ಼ನಾವೊನೆ ಹರಯಕ್ಕ ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ತ್ಯುನೊನೆ ಯೊಪ್ಪ ವಳಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ಮರ್ನಾ ದಿನ್ನೆ ಎ ಮನಕ್ಹೊ ಯೊಪ್ಪನಾ ನಜಿಕ ರ‍್ಹತಾಮಾ ದುಪ್ಪಾರ ಥೈತಿ. ತೆ ಟೈಮಮಾ ಪೆತ್ರಾ ಪ್ರಾಥನಾ ಕರಾನಾ ಹುತಿ ಘರ್ನಾ ಉಪ್ಪರ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ಪೆತ್ರಾನೆ ಭುಕ್ಕ ಲಾಗಿನ ಅನ್ನ ಖೌ ಕೈನ ಲಾಗ್ಯುತು. ತ್ಯಾ ತಿನೆ ಅನ್ನ ಕರಾಡಾತಾ. ತ್ಯಾ, ಪೆತ್ರಾನೆ ಯಕ್ಕ ದರ್ಶನ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ಖುಲ್ಲಾ ಥಯಲ ಹಬಾಳಮಾತು ಕಯುಬಿ ಯಕ್ಕ ಚಿಜ಼ ಉತ್ರಿನ ಆವಾನು ತೆ ದೆಕ್ಯೊ. ತೆ ಮ್ಹೊಟೊ ಥಾಳೊ ಲಿಂಗತ ವ್ಹತ್ತು. ತಿನಾ ಚಾರೆ ಮುಲಾವೊನೆ ರಾಖೊಕ್ಹು ಭಾಂದಿನ ಜಿಮಿನ ಪರ ಉತಾರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ತಿಮಾ ಕ್ಹಾರಾ ತರಾನಾ ಜಾನವರೊ ವ್ಹತ್ತಾ. ಕದ್ಯಾಮ ಚಾ಼ಲಾನಾ ಜಾನವರೊ ಫರಾನಾ ಕಿಡಾ ವರಿ ಉಡಾನಾ ಪಕ್ಷಿಯೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ತೆಳಾಮಾ ಯಕ್ಕ ಅವಾಜ಼\"ಪೆತ್ರಾ, ಉಟ್ಟ! ಕಾಟಿನ ಖಾ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ತೆನೈಸೊ ಪೆತ್ರಾ\"ಪ್ರಭು, ಮಿ ತಿಮ್ಮ ನೈ ಕರಸಕ್ತೊ! ಪವಿತ್ರ ನೈ ರ‍್ಹಯಲನೆ ವರಿ ಶುದ್ಧ ನೈ ರ‍್ಹಯಲನೆ ಮಿ ಕೆಳಾಮಾಜ಼ ಖಾದಲವಾಲೊ ನ್ಹವೈ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ತೆನೈಸೊ ತೆ ಅವಾಜ಼ ತಿನೆ\"ಕ್ಹುದಾ ಎ ಕ್ಹಾರು ಶುದ್ಧ ಕರ‍್ಯೊಸ. ಎ ಕ್ಹಾರಾನೆ ಪವಿತ್ರ ನ್ಹವೈ ಕೈನ ಕೌ ನಕೊ \"ಕೈನ ವರಿ ಕದ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ಇಮ್ಮ ತನ್ನ ಸಲಾ ಥಯು. ಪಾಚಾ಼ತು ತೆ ಪರಾತನೆ ಹಬಾಳಮಾ ವಾಪಸ ಲಿವಾ ಲಗಾಡ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ಪೆತ್ರಾ ತೆ ದೆಕಲ ಎ ದರ್ಶನನು ಮತ್ಲಬ ಸು ವಸೆ ಕೈನ ಘಾಬ್ರೊ ಥಯೊ. ತೆಕ್ಲಾಮಾಜ಼಼, ಕೊರ್ನೆಲಿಯ ವಳಾಯಲ ಮನಕ್ಹೊ ಸಿಮೊನನು ಘರ ಗ್ವತ್ತ ಕಳಿ ಲಿದ್ಯಾ. ತ್ಯುನೆ ಗೆಟಕನ ಹುಬ್ರೈನ, ");
INSERT INTO sle_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","\"ಸಿಮೊನ ಪೆತ್ರಾ ನ್ಹಾ ರ‍್ಹವಸ ಸು? ಕೈನ ಪುಚ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ಎ ದರ್ಶನನಾ ಹುತಿ ಪೆತ್ರಾ ಹಜು಼ನ ಸೊಚಾ಼ಡೊತೊ. ತೆನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾ ತಿನೆ\"ಸಿಮೊನ, ತುನೆ ತನ್ನ ಜ಼ನಾ ಹುಡಕ್ತಾ ಆಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ತು ಉಟಿನ ಹೆಟೊ ಗೈನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಜಾ಼ವಾ ಹುತಿ ಪಾಚೊ಼ ಸರಕು ನಕೊ. ಮಿಜ಼ ತ್ಯುನೊನೆ ತುಕನ ವಳಾಯೊಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ತಿನಾಹುತಿ ಪೆತ್ರಾ ಹೆಟೊ ಉತ್ರಿನ ತ್ಯುನೊ ಕನ ಗೈನ\"ತುಮೆ ಹುಡ್ಕಾನೊ ಮನಕ್ಹ ಮಿಜ಼ ವ್ಹೈ, ತುಮೆ ನ್ಹ್ಯಾ ಕಾ ಆಯಾಸ? ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ತೆ ಮನಕ್ಹೊ \"ಕೊರ್ನೆಲಿಯ ಕವಾನಾ ಯಕ್ಕ ಶತಾದಿಪತಿ ಛೆ. ತೆ ಧಾರ್ಮಿಕ ಮನಕ್ಹ ವ್ಹೈ. ತೆ ಕ್ಹುದಾನೆ ಆರಾಧನಾ ಕರಸ. ಯೆಹುದಿ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ತಿನೆ ಮರ್ಯಾದಿ ದಿವಸ. ತುನೆ ತಿನಾ ಘರೆ ಬಲಾವಾನೆ ಕರಿನ ತು ಕವಾನಿಯೊ ಸಂಗತಿಯೊ ಐಕು ಕೈನ ಕ್ಹುದಾನೊ ದುತ ಯಕ್ಲೊ ಕೊರ್ನೆಲಿಯನೆ ಕದ್ಯೊಸ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ಪೆತ್ರಾ ತ್ಯುನೊನೆ ಮ್ಹೈ ಬಲೈನ, ತೆ ರಾತ ತ್ಯಾಜ಼ ರ‍್ಹೌ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ಮರ್ನಾ ದಿನ್ನೆ ಪೆತ್ರಾ ತಯ್ಯಾರ ಥೈನ, ತೆ ತನ್ನೆ ಜ಼ನಾವೊನಾ ಕ್ಹಾತೆ ಗಯೊ. ಯೊಪ್ಪನಾ ವಿಸ್ವಾಸಿಯೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ತಿನಾ ಕ್ಹಾತೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ಮರ್ನಾ ದಿನ್ನೆ ತ್ಯುನೆ ಗಾಮೆ ಕೈಸರೈಯ ಮುಟ್ಯಾ. ಕೊರ್ನೆಲಿಯ ತ್ಯುನಾ ಹುತಿ ಕೈದಾಡೊತೊ. ತೆ ತಿನಾ ಸಂಬಂದಿಕೊನೆ ವರಿ ಖಾಸ ದೊಸ್ತೊನೆ ಪೈಲಾಜ಼ ತಿನಾ ಘರೆ ಬಲೈ ಲಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ಪೆತ್ರಾ ಘರ ಆತಾಮಾ ಕೊರ್ನೆಲಿಯ ತಿನೆ ಮಳಿನ ಕೊರ್ನೆಲಿಯ ಪೆತ್ರಾನಾ ಪಗೆ ಪಡಿನ ನಮಸ್ಕಾರ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ತೆನೈಸೊ ಪೆತ್ರಾ ತಿನೆ ಉಪ್ಪರ ಉಟಾಡಿನ\"ಉಟಿನ ಹುಬ್ರೆ! ಮಿ ತಾರಾ ಲಿಂಗತಜ಼ ಯಕ್ಕ ಮನಕ್ಹ ವ್ಹೈ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ಪೆತ್ರಾ ಕೊರ್ನೆಲಿಯನಾ ಕ್ಹಾತೆ ವಾತೊ ಬೊಲ್ತಾಮಾ. ಪಾಚಲ್ತೊ ಪೆತ್ರಾ ಮ್ಹೈ ಗಯಲ್ಪರ, ತ್ಯಾ ಬಲಾವಾನೆ ಕರಲ ಮನಕ್ಹೊನು ಮ್ಹೊಟು ಗುಂಪನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ಪೆತ್ರಾ ತ್ಯುನೊನೆ\"ಯಕ್ಲೊ ಯೆಹುದಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಸಂಬಂಧ ಮ್ಹೆಲ್ಯಾನು ರ‍್ಹವಾದೆ ತ್ಯುನೊನೆ ಮಳಾನು ರ‍್ಹವಾದೆ ಅಪ್ನಾ ಯೆಹುದಿ ಧರಮಶಾಸ್ತ್ರನಾ ವಿರುದ್ದ ವ್ಹೈ ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಕಯಾಬಿ ಮನಕ್ಹನೆ ಪವಿತ್ರ ನೈ ರ‍್ಹಯಲ ವ್ಹೈ ಕೈನ ಶುದ್ಧ ನೈ ರ‍್ಹಯಲ ವ್ಹೈ ಕೈನ ಬಲೌ ನೈ ಕೈನ ಕ್ಹುದಾ ಮನೆ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ತಿನಾಹುತಿ, ಮನೆ ನ್ಹ್ಯಾ ಔ ಕೈನ ಬಲಾಯಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಮಿ ವಾದ-ವಿವಾದ ಕರ‍್ಯೊ ನೈ. ತೆನೈಸೊ ತುಮೆ ಮನೆ ಕಾ ಬಲಾಯಾಸ ಕೈನ ಹಮ್ನಾ ತುಬಿ ಕವೊ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ತೆಳಾಮಾ ಕೊರ್ನೆಲಿಯ, ತನ್ನ ದಿನ್ನನಾ ಪಾಚೊ಼, ಮಿ ಮಾರಾ ಘರಮಾ ಪ್ರಾಥನಾ ಕರಾಡೊತೊ. ತೆಳಾಮಾ ದುಪ್ಪಾರನಾ ತನ್ನ ವಾಜ್ಯಾತಾ. ತಿನಾಕ್ಹು ತೆ ಯಕ್ಕ ಮನಕ್ಹ ಮಾರಾ ಕ್ಹಾಮೊ ಹುಬ್ರಯೊ. ತೆ ಘಾಲ್ಲಿದಲ ವಣ್ಣಾ ಘನ್ನಾ ಚಮ್ಕಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ತೆ ಮನಕ್ಹ, ‘ಕೊರ್ನೆಲಿಯ! ಕ್ಹುದಾ ತಾರಿ ಪ್ರಾಥನಾ ಐಕ್ಯೊಸ. ತು ಗರಿಬೊನೆ ದಿದಲ ಕ್ಹಾರು ದೆಕ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ತಿನಾಹುತಿ ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಯೊಪ್ಪ ಗಾಮೆ ವಳೈನ ಸಿಮೊನ ಕವಾಲಾ ಪೆತ್ರಾನೆ ಆ ಕೈನ ಮಾಂಗಿಲೆ. ಪೆತ್ರಾ ಚಾ಼ಮ್ಡಾನು ಕಾಮ ಕರಾಲಾನಾ ಸಿಮೊಮನ ಕವಾಲಾನಾ ಘರಮಾ ರ‍್ಹಯೊಸ. ತಿನು ಘರ ಸಮುಂದರನಾ ದಂಡಿಕನ ಛೆ’ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ತಿನಾಹುತಿ, ಮಿ ತೆಳಾಮಾಜ಼ ತುನೆ ಬಲಾವಾನೆ ಕರ‍್ಯೊ. ತು ನ್ಹ್ಯಾ ಆಯಲ ಉಪಕಾರ ಥಯು. ಹಮೊನೆ ತಿಳಸಾ ಕೈನ ಪ್ರಭು ತುನೆ ಆಜ್ಞಾ ಕರಲ ಹರಯಕ್ಕ ಐಕಾನೆ ಹಮೆ ಕ್ಹಾರಾ ಕ್ಹುದಾನಿ ಸನ್ನಿದಿಮಾ ಮಳ್ಯಾಸ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ಪೆತ್ರಾ ಬೊಲಾನು ಶುರು ಕರಿನ ಅಮ್ಮ ಕದ್ಯೊ; \"ಕ್ಹುದಾನೆ ಕ್ಹಾರಾ ಜ಼ನಾ ಯಕ್ಕಜ಼ ವ್ಹೈ ಕೈನ ಮನೆ ಹಮ್ನಾ ಕ್ಹರಿಜ಼ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ತಿನೆ ಆರಾಧನೆ ಕರಾಲಾ ನಿತಿವಂತ ಕುನ್ನಬಿ ರ‍್ಹೈನಕಾ ತ್ಯುನೊನೆ ಕ್ಹುದಾ ಸ್ವಿಕಾರ ಕರಿ ಲಿವಸ. ತೆ ಕೈ ಜಾ಼ತನಾ ಮನಕ್ಹೊ ವ್ಹೈ ಕವಾನು ಖಾಸ ನ್ಹವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ಕ್ಹುದಾ ತಿನು ಸಂದೆಶ ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊಕನ ಮಕಲ್ಯೊ. ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಶಾಂತಿ ಐಸ ಕವಾನಿ ಸುವಾರ್ತೆನೆ ಕ್ಹುದಾ ತ್ಯುನೊನೆ ವಳಾಯೊ. ಯೆಸು ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಪ್ರಭು ಥಯೊಸ! ");
INSERT INTO sle_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ಯುದೆಯ ಪ್ರಾಂತ್ಯ ಸು ಥಯುಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಗಲಿಲಾಯಮಾ ಯೊಹಾನ ಬಾಪ್ತಿಸ್ಮನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಬೊದನೆ ಕರಲ್ಪರ ತೆ ಶುರು ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ನಜರೆತನಾ ಯೆಸುನಾ ಹುತಿ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಕ್ಹುದಾ ತಿನೆ ಪವಿತ್ರ ಆತ್ಮಾನೆ ತಾಕಾತನೆ ದಿವಾನಾ ಮುಲಕ ತಿನೆ ಅಭಿಶೆಕ ಕರ‍್ಯೊ. ತೆ ಕ್ಹಾರಿ ಜ಼ಗಾ ಮನಕ್ಹೊನೆ ಚೊ಼ಕು ವರಿ ಅರಾಮ ಕರ್ತೊ ಫರ‍್ಯೊ. ಭುತ್ಡಾವೊಕ್ಹು ತ್ರಾಸ ಖಾವಾಲಾವೊನೆ ಯೆಸು ಅರಾಮ ಕರ‍್ಯೊ. ಕ್ಹುದಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ ಕವಾನು ತೆ ದೆಕಾಡಿನ ದಿದ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","\"ಯುದೆಯಾ ಪ್ರಾಂತ್ಯ ವರಿ ಯೆರುಸಲೆಮಮಾ ಯೆಸು ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊ ಅಪೆ ದೆಕ್ಯಾ. ತೆ ಕಾಮೊನೆ ಹಮೆ ಸಾಕ್ಷಿಯೊ ಥಯಾಸ. ತೆನೈಸೊ ಯೆಸುನೆ ಖಲಾಸ ಕರ‍್ಯಾ. ತ್ಯುನೆ ತಿನೆ ಶಿಲುಬಿ ಪರ ಮಾರ್ಯಾ ವರಿ ತಿಪರ ಚ಼ಡಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ತೆನೈಸೊ, ಕ್ಹುದಾ ತಿನೆ ತನ್ವಾ ದಿನ್ನೆ ಮೌತಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡ್ಯೊ! ಯೆಸುನೆ ದೆಕಾನೊ ಮೌಕೊ ಕ್ಹುದಾ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ತೆನೈಸೊ ಯೆಸು ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ದಿಕ್ಹ್ಯೊ ನೈ. ಕ್ಹುದಾ ಪೈಲಾಜ಼ ಸಾಕ್ಷಿ ಥೈನ ಇನಿಲಿದಲ ಮನಕ್ಹೊ ತಿನೆ ದೆಕ್ಯಾ! ಯೆಸು ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯಲ್ಪರ ಹಮೆ ತಿನಾ ಕ್ಹಾತೆ ಖಾದ್ಯಾ ವರಿ ಪಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","\"ಮನಕ್ಹೊನೆ ಬೊದನೆ ಕರು ಕೈನ ಯೆಸು ಹಮೊನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ಜಿವ್ತಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆಬಿ ವರಿ ಮರಲ ಮನಕ್ಹೊನೆಬಿ ಕ್ಹುದಾಕ್ಹು ನ್ಯಾಯಾದಿಪತಿ ಥೈನ ಇನಿಲಿದಲ ಮನಕ್ಹ ತೆಜ಼ ವ್ಹೈ ಕವಾನು ಮನಕ್ಹೊನೆ ತಿಳ್ಸಾವೊ ಕೈನ ತೆ ಹಮೊನೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ಯೆಸು ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಹರಯಕ್ಕನಾ ಪಾಪೊ ತಿನಾ ನಾಮನಾ ಮುಲಕ ಮಾಫ ಕರಸ. ಎ ಕ್ಹರಿಜ಼ ವ್ಹೈ ಕೈನ ಪ್ರವಾದಿಯೊ ಕದ್ಯಾಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ಪೆತ್ರಾ ಹಜು಼ನ ತಿಮ್ಮ ಕತಾಮಾಜ಼, ತಿನು ಸಂದೆಶ ಐಕಾಲಾವೊನಾ ಉಪ್ಪರ ಪವಿತ್ರ ಆತ್ಮಾ ಉತ್ರಿನ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ಪೆತ್ರಾನಾ ಕ್ಹಾತೆ ಆಯಲ ಯೆಹುದಿನಾ ವಿಶ್ವಾಸಿಯೊ ಥಂಡಾ ಥಯಾ. ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊನೆಬಿ ಪವಿತ್ರ ಆತ್ಮಾನಿ ವರಾ ಉತ್ರಿನ ಆಯಲ ದೆಕಿನ ತ್ಯುನೆ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಬಿಜಿ಼ ಬಿಜಿ಼ ಭಾಶಾಮಾ ಬೊಲ್ತಾ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕರಾನು ತೆ ಯೆಹುದಿನಾ ವಿಶ್ವಾಸಿಯೊ ಐಕ್ಯಾ. ಪಾಚಲ್ತೊ ಪೆತ್ರಾ ಬೊಲ್ತೊ ");
INSERT INTO sle_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","\"ಪಾನಿಮಾ ಬಾಪ್ತಿಸ್ಮ ನೈ ಲಿಯೆ ಲಿಂಗತ ಅಪೆ ಎ ಮನಕ್ಹೊನೆ ಅಡ್ಡ ಕರಾನೆ ಸಾಧ್ಯ ನತ್ತಿ. ಅಪೆ ಹೊಂದಿಲಿದಲ ಲಿಂಗತ ಇವ್ನೆ ಪವಿತ್ರ ಆತ್ಮಾ ಹೊಂದಿಲಿದ್ಯಾ \"ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ತಿನಾಹುತಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಪರ ಬಾಪ್ತಿಸ್ಮ ಕರೈ ಲಿವಾನೆ ತ್ಯುನೊನೆ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ದಕ್ಹಾ ದಿನ್ನ ಲಕ್ಕಾ ರ‍್ಹೌ ಕೈನ ಪೆತ್ರಾ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ಯೆಹುದಿ ನೈಸೊ ವಿಸ್ವಾಸಿಯೊ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾನೆ ಸ್ವಿಕಾರ ಕರ‍್ಯಾಸ ಕವಾನು ಅಪೊಸ್ತಲೊನೆ ಯುದೆಯನಾ ವಿಸ್ವಾಸಿಯೊನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ತೆನೈಸೊ ಪೆತ್ರಾ ಯೆರುಸಲೆಮೆ ಆಯಲ್ಪರ ದಕ್ಹಾ ಯೆಹುದಿನಾ ವಿಶ್ವಾಸಿಯೊ ಖತ್ನಾ ಕರೈಲ್ಯು ಕೈ ಕವಾಲಾ ತಿನಾ ಕ್ಹಾತೆ ವಾದ ವಿವಾದ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ತ್ಯುನೆ\"ಯೆಹುದಿ ನೈಸೊ ರ‍್ಹಯಲ ವರಿ ಖತ್ನಾ ನೈ ಕರೈ ಲಿದಲವಾಲಾವೊನಾ ಘರೊನೆ ತು ಗಯೊ! ತು ತ್ಯುನಾ ಕ್ಹಾತೆ ಅನ್ನಬಿ ಖಾದ್ಯೊ\"ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ತಿನಾಹುತಿ ಪೆತ್ರಾ ಥಯಲ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ತ್ಯುನೊನೆ ತಿಳ್ಸಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ಪೆತ್ರಾ ತ್ಯುನೊನೆ\"ಮಿ ಯೊಪ್ಪ ಗಾಮಮಾ ವ್ಹತ್ತೊ. ಮಿ ಪ್ರಾಥನಾ ಕರ‍್ತಾಮಾ ಮನೆ ಯಕ್ಕ ದರ್ಶನ ಥಯು. ತೆ ದರ್ಶನಮಾ, ಹಬಾಳತು ಉತ್ರಿನ ಆವಾನು ಯಕ್ಕ ಚಿಜ಼ ದೆಕ್ಯೊ. ತೆ ಮ್ಹೊಟೊ ಥಾಳೊ ಲಿಂಗತ ವ್ಹತ್ತು. ತಿನಾ ಚಾರೆ ಮುಲಾವೊನೆ ರಾಕ್ಹೆ ಭಾಂದಿನ ತೆ ಉತ್ರಿನ ಐನ ಮಾರಾ ನಜಿಕ ಹುಬ್ರಯು. ");
INSERT INTO sle_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ಮಿ ತಿಮಾ ದೆಕ್ಯೊ. ತಿಮಾ ಜಾನವರೊ ಖತರ್ನಾಕ ಜಾನವರೊ ಇಶಾಡಾನಾ ಜಾನವರೊ ಉಡಾನಾ ಪಕ್ಷಿಯೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ತೆಳಾಮಾ, ‘ಪೆತ್ರಾ, ಉಟ್ಟ! ಇಮಾ ರ‍್ಹಯಲ ಕಿನೆಬಿ ಖಲಾಸ ಕರಿನ ಖಾ! ಕೈನ ಮನೆ ಕವಾನಿ ಅವಾಜ಼ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","\"ತೆನೈಸೊ ಮಿ, ‘ಪ್ರಭು, ಮಿ ತಿಮ್ಮ ನೈ ಕರಸಕ್ತೊ! ಪವಿತ್ರ ನೈ ರ‍್ಹಯಲ ವರಿ ಶುದ್ಧ ನೈ ರ‍್ಹಯಲ ಸುಬಿ ರ‍್ಹವಾದೆ ಮಿ ಕೆಳಾಮಾಜ಼ ನತ್ತಿ ಖಾದ್ಯೊ’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","\"ತೆನೈಸೊ, ‘ಎ ಕ್ಹಾರಾನೆ ಕ್ಹುದಾ ಶುದ್ಧ ಕರ‍್ಯೊಸ. ಎ ಕ್ಹಾರು ಶುದ್ಧ ನ್ಹವೈ ಕೈನ ಕೌ ನಕೊ! ಕೈನ ತೆ ಅವಾಜ಼ ಮನೆ ಜವಾಬ ದಿದ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","\"ಇಮ್ಮ ತನ್ನ ಸಲಾ ಥಯು. ಪಾಚಾ಼ತು ತೆ ಪುರಾ ಚಿಜ಼ ಹಬಾಳೆ ವಾಪಸ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ತೆಜ಼ ಟೈಮಮಾ ಮಿ ರ‍್ಹಯಲ ಘರೆ ತನ್ನ ಜ಼ನಾ ಆಯಾ. ಎ ತನ್ನೆ ಜ಼ನಾವೊನೆ ಸೆಜರೆಯ ಗಾಮತಾ ವಳಾಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ಶಕ್ಕ ಕರ‍್ಯವಾಚಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ಜಾ಼ ಕೈನ ಪವಿತ್ರ ಆತ್ಮಾ ಮನೆ ಕದ್ಯೊ. ನ್ಹ್ಯಾ ರ‍್ಹವಾನಾ ಎ ಛೆ ಜ಼ನಾ ಭಾಯೊ ಮಾರಾ ಕ್ಹಾತೆ ಆಯಾ. ಹಮೆ ಕೊರ್ನೆಲಿಯನಾ ಘರೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ತಿನಾ ಘರಮಾ ಕ್ಹುದಾನು ದುತ ಯಕ್ಲೊ ಹುಬ್ರಯಲ ತೆ ದೆಕಲ ಕೊರ್ನೆಲಿಯ ಮನೆ ಕದ್ಯೊ. ತೆ ಕ್ಹುದಾನೊ ದುತ ಕೊರ್ನೆಲಿಯನೆ, ‘ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಯೊಪ್ಪ ಗಾಮೆ ವಳಾ. ಸಿಮೊನ ಪೆತ್ರಾನೆ ಬಲಾವಾನೆ ಕರಿನ ತುಮೊಕನ ಬಲಾವಾನು ಕರಲೆ. ");
INSERT INTO sle_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ತೆ ತುಮೊಕನ ಸಂದೆಶ ಲಾವಸ. ತೆ ಸಂದೆಕ್ಹು ತುನೆ ತಾರಾ ಘರವಾಲಾವೊನೆ ರಕ್ಷಣೆ ಕರಸ’ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ಮಿ ಮಾರಿ ಉಪದೆಶ ಶುರು ಕರಲ್ಪರ, ಶುರುವಾತಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ಅಪ್ನಾ ಉಪ್ಪರ ಆಯಲ ಲಿಂಗತ ತ್ಯುನಾ ಉಪ್ಪರಬಿ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ತೆಳಾಮಾ ಮಿ ಪ್ರಭುನಾ ವಾತೊ ಶೆಂ ಕರ‍್ಯೊ. ‘ಯೊಹಾನ ಮನಕ್ಹೊನೆ ಪಾನಿಮಾ ಬಾಪ್ತಿಸ್ಮ ಕರಾಯೊ, ತೆನೈಸೊ ತುಮೆ ಪವಿತ್ರ ಆತ್ಮಾಮಾ ಬಾಪ್ತಿಸ್ಮ ಲಿವೊಶಿ. ಕೈನ ಪ್ರಭು ಕದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತಮಾ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ಅಪೊನೆ ದಿದಲ ವರಾನೆಜ಼ ಕ್ಹುದಾ ಎ ಮನಕ್ಹೊನೆ ದಿದ್ಯೊ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಮಿ ಕ್ಹುದಾನು ಕಾಮ ಹುಬ್ರಾಡಾನೆ ಸಾಧ್ಯ ನ್ಹೊತು \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ಯಹುದ್ಯ ವಿಶ್ವಾಸಿಯೊ ಎ ಸಂಗತಿಯೊ ಐಕಲ್ಪರ ವಾದ-ವಿವಾದ ಹುಬ್ರಾಡೊ, ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರ್ತಾ\"ತಿಮ್ಮ ರ‍್ಹಯಮ ಅಪ್ನಾ ಲಿಂಗತಜ಼ ತ್ಯುನಾ ಮನಸೊ ಫರೈಲಿನ ಜ಼ಲಮ ಹೊಂದಿಲಿವಾನೆ ಕ್ಹುದಾ ಯೆಹುದಿ ನೈ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಮೌಕೊ ದಿದ್ಯೊಸ \"ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ಸ್ತೆಫನನೆ ಖಲಾಸ ಕರ‍ಲ್ಪರ ಥಯಲ ತ್ರಾಸಕ್ಹು ವಿಶ್ವಾಸಿಯೊ ದುರ ದುರ ಥಯಾ. ವಿಶ್ವಾಸಿಯೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಘನ್ನಾ ದುರ ರ‍್ಹಯಲ ಫೆನಿಶ್ಯ, ಸೈಪ್ರಸ್ ವರಿ ಅಂತಿಯೊಕ್ಯನೆ ಗಯಾ. ವಿಶ್ವಾಸಿಯೊ ಎ ಜ಼ಗಾವೊಮಾ ಸುವಾರ್ತೆ ತಿಳಸಾಯಾ. ತೆನೈಸೊ ತ್ಯುನೆ ಯೆಹುದಿಯೊನೆಜ಼ ತಿಳಸಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ಎ ವಿಶ್ವಾಸಿಯೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಸೈಪ್ರನ್ ವರಿ ಸಿರೆನ್ ಜ಼ಗಾವಾಲಾ ವ್ಹತ್ತಾ. ಎ ಮನಕ್ಹೊ ಅಂತಿಯೊಕ್ಯನೆ ಆಯಲ್ಪರ ತ್ಯುನೆ, ಪ್ರಭು ಥಯಲ ಯೆಸುನಿ ವಿಷಯಮಾ ರ‍್ಹಯಲ ಸುವಾರ್ತೆ ತ್ಯಾನಾ ಗ್ರಿಕ ಮನಕ್ಹೊನೆಬಿ ತಿಳಸಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ಪ್ರಭು ವಿಶ್ವಾಸಿಯೊನೆ ಮದತ ಕರಾಡೊತೊ. ಮನಕ್ಹೊ ಘನ್ನಾ ಸಂಖ್ಯೆಮಾ ಪ್ರಭುನೆ ಬರೊಕ್ಹೊ ಕರಿನ ಚಾ಼ಲಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ಅಂತಿಯೊಕ್ಯಮಾ ರ‍್ಹಯಲ ಎ ನವಾ ವಿಶ್ವಾಸಿಯೊನಾ ಹುತಿ ಯೆರುಸಲೆಮನೆ ಸಬೆವಾಲಾವೊನೆ ಗ್ವತ್ತ ಥಯು. ತಿನಾಹುತಿ ಜೆರುಸಲೆಮನಾ ವಿಶ್ವಾಸಿಯೊ ಬಾರ್ನಬನೆ ಅಂತಿಯೊಕ್ಯನೆ ವಳಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ಬಾರ್ನಬ ಚೊ಼ಕೊ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ತೆ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರಲ ವ್ಹತ್ತೊ ವರಿ ಪುರಾ ಬರೊಕ್ಹೊ ರ‍್ಹಯಲವಾಲೊ ವ್ಹತ್ತೊ. ಬಾರ್ನಬ ಅಂತಿಯೊಕ್ಯನೆ ಗಯಲ್ಪರ, ಕ್ಹುದಾ ತೆ ಮನಕ್ಹೊನೆ ಘನ್ನೊ ಆಶಿರ್ವಾದ ಕರಾನು ದೆಕ್ಯೊ. ಇಕ್ಹು ಬಾರ್ಬನನೆ ಘನ್ನಿ ಖುಶಿ ಥಯು. ಅಂತಿಯೊಕ್ಯಮಾ ರ‍್ಹವಾಲಾ ವಿಶ್ವಾಸಿಯೊನೆ ಕ್ಹಾರಾ ತೆ ಪ್ರೊತ್ಸಾಹ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ತೆ ಚೊ಼ಕೊ ವ್ಹೈ. ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹು ಭರಲವಾಲೊ ವರಿ ಬರೊಕ್ಹಾಕ್ಹು ಭರಲವಾಲೊ ವ್ಹತ್ತೊ. ತಿನಾಹುತಿ ತ್ಯಾ ಐನ ಕ್ಹುದಾನು ಕೃಪಾನಾ ಕಾಮೊ ದೆಕ್ತಾಮಾ ಘನ್ನೊ ಖುಶಿ ಥಯೊ. ತುಮೆ ಘಟ್ಟ ಮನಸಕ್ಹು ಕರ್ತಾಮಾ ಹುಬ್ರೊ ಕೈನ ತ್ಯುನೊನೆ ಗ್ಯಾನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ಪಾಚಲ್ತೊ ಬಾರ್ನಬ ಸೌಲಾನೆ ಹುಡಕ್ತೊ ತಾರ್ಸ ಗಾಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ಬಾರ್ನಬ ತ್ಯಾ ಸೌಲಾನೆ ಮಳಿನ ತಿನೆ ಅಂತಿಯೊಕ್ಯನೆ ಬಲೈಲಿನ ಗಯೊ. ಸೌಲಾ ವರಿ ಬಾರ್ನಬ ಅಂತಿಯೊಕ್ಯಮಾ ಯಕ್ಕ ವರಕ್ಹ ಪುರಾ ಸಭೆನಾ ಅನ್ಯುನ್ಯತೆಮಾ ರ‍್ಹೈನ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ಬೊದನೆ ಕರ‍್ಯಾ. ಯೆಸುನಾ ಹಿಂಬಾಲಕೊನೆ \"ಕ್ರೈಸ್ತರೊ \"ಕವಾನು ನಾಮ ಆಯಲ ಅಂತಿಯೊಕ್ಯಮಾಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ತೆ ಕಾಲಮಾ ದಕ್ಹಾ ಪ್ರವಾದಿಯೊ ಯೆರುಸಲೆಮತಾ ಅಂತಿಯೊಕ್ಯನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ಎ ಪ್ರವಾದಿಯೊಮಾ \"ಅಗಬ \"ಕವಾಲೊ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ಅಗಬ ಅಂತಿಯೊಕ್ಯಮಾ ಪವಿತ್ರ ಆತ್ಮಾನಿ ಪ್ರೆರಣೆಕ್ಹು\"ಪುರಾ ದುನಿಯಾನೆ ಮ್ಹೊಟಿ ಬರಾ ಆವಾನಿ ಛೆ \"ಕದ್ಯೊ. ಎ ಬರಗಾಲ ಕ್ಲಾಡಿಯಸ್ ಚಕ್ರವತಿನಾ ಕಾಲಮಾ ಐಯುತು. ");
INSERT INTO sle_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ಯುದೆಯಮಾ ರ‍್ಹವಾನಾ ಭಾಯೊ ಭೆನೊನೆ ಮದತ ಕರಾನೆ ವಿಶ್ವಾಸಿಯೊ ನಿರ್ಧಾರ ಕರ‍್ಯಾ. ವಿಶ್ವಾಸಿಯೊಮಾ ಹರಯಕ್ಲಾ ತ್ಯುನೊನೆ ಥಯಲ ತೆಕ್ಲು ತ್ಯುನೊನೆ ವಳೈನ ದಿವಾನೆ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ತ್ಯುನೆ ದೊಕ್ಡಾ ಮಳೈನ ಬಾರ್ನಬ ವರಿ ಸೌಲಾನೆ ದಿದ್ಯಾ. ಪಾಚಾ಼ತಾ ಬಾರ್ನಬ ವರಿ ಸೌಲಾ ತಿನೆ ಲೈನ ಯುದೆಯಮಾ ರ‍್ಹಯಲ ಸಭೆನಾ. ಮ್ಹೊಟಾವೊನೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ತೆ ಕಾಲಮಾ ರಾಜೊ಼ ಹೆರೊದ ಸಭೆವಾಲಾವೊಮಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ತ್ರಾಸ ಕರಾನೆ ಶುರು ಕರ‍್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ಯೊಹಾನನಾ ಭೈನೆ ಯಾಕೊಬನೆ ತಲ್ವಾರಕ್ಹು ಖಲಾಸ ಕರಾ ಲಗಾಡ್ಯೊ. ಯಾಕೊಬ ಯೊಹಾನನೊ ಮ್ಹೊಟೊ ಭೈ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ಯೆಹುದಿಯೊ ಅನೆ ಮೆಚ್ಚಿ ಲಿದ್ಯಾಸ ಕವಾನು ಹೆರೊದನೆ ಗ್ವತ್ತ ಥಯು. ತಿನಾಹುತಿ ತೆ ಪೆತ್ರಾನೆ ಧರಿನ ಎ ಥಯಲ ಯೆಹುದಿಯೊನಾ ಪಸ್ಕ ಸನ್ನನಾ ಕಾಲಮಾ ಜೈಲಮಾ ಘಾಲಾ ಲಗಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ಕ್ಹೊಳಾ ಜ಼ನಾ ಸಿಪಾಯೊ ಪೆತ್ರಾನೆ ಕೈದಾಡಾತಾ. ಪಸ್ಕ ಸನ್ನನು ಕಾಲ ಕ್ಹರಲ ಪರ ಪೆತ್ರಾನೆ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ಹುಬ್ರಾಡು ಕೈನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ಇಮ್ಮ ಪೆತ್ರಾ ಜೈಲಮಾ ರ‍್ಹತಾಮಾ ಸಭೆವಾಲಾ ತಿನಾಹುತಿ ಮನಸೆ ಕ್ಹುದಾನೆ ಪ್ರಾಥನಾ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ಪೆತ್ರಾ ಬೆ ಸೈನಿಕೊನಾ ವಚ್ಮಾ ನಿಂದರ ಕರಾಡೊತೊ. ತಿನೆ ಬೆ ಕಾಕ್ಹಳಿಕ್ಹು ಭಾಂದ್ಯಾತಾ. ಘನ್ನಾ ಸೈನಿಕೊ ಜೈಲನಾ ಬಾಕಲ ಕನ ಕೈದಾಡಾತಾ. ತೆಳಾಮಾ ರಾತ ಥೈತಿ. ಮರ್ನಾ ದಿನ್ನೆ ಪೆತ್ರಾನೆ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮಾ ಲೌ ಕೈನ ಹೆರೊದ ವಿಚಾರ ಕರ‍್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ಅಚಾನಕ ಪ್ರಭುನೊ ದುತ ಯಕ್ಲೊ ತ್ಯಾ ಹುಬ್ರಯೊ. ಉಜಾಲು ಖೊಲಿಮಾ ದಿಕ್ಹ್ಯು. ಕ್ಹುದಾನು ದುತ ಪೆತ್ರಾನಿ ಪಾಕ್ಹಳಿನೆ ಧರಿನ ತಿನೆ ಉಟಾಡಿನ \"ಭರ್ನೆ ಉಟ್ಟ\" ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ಕಾಕ್ಹಳಿಯೊ ಪೆತ್ರಾನಾ ಹತೊಮಾತಾ ತುಟಿನ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ಕ್ಹುದಾನೊ ದುತ ಪೆತ್ರಾನೆ \"ವಣ್ಣಾ ಘಾಲ್ಲೆ, ಪಗೊಮಾನಿಯೊ ಘಾಲ್ಲೆ \"ಕದ್ಯೊ. ತಿನಾ ಲಿಂಗತಜ಼ ಪೆತ್ರಾ ಕರ‍್ಯೊ. ಪಾಚಲ್ತೊ ಕ್ಹುದಾನೊ ದುತ\"ತಾರು ಉಪ್ಪರ್ಲ್ಯು ಅಂಗ್ಡು ಭಾಂದಿಲಿನ ಮಾರಾ ಪಾಚೊ಼ ಆ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ಕ್ಹುದಾನೊ ದುತ ಭಾರೊ ಗಯೊ. ಪೆತ್ರಾ ತಿನಾ ಪಾಚೊ಼ ಗಯೊ. ಕ್ಹುದಾನೊ ದುತ ಕ್ಹರಿಮಾಜ಼ ಇಮ್ಮ ಕರಾಡ್ಯೊಸ ಕವಾನು ಪೆತ್ರಾನೆ ಗ್ವತ್ತ ನ್ಹೊತು. ತೆ ಕ್ಹಪನ ದೆಕಾಡೊ ವಸೆ ಕೈನ ತೆ ತಿಳ್ದಿಲಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ಪೆತ್ರಾ ವರಿ ಕ್ಹುದಾನೊ ದುತ ಪಸ್ಟನು ವರಿ ಬೆವಾನು ಕೈದಾನಿ ಜ಼ಗಾ ದಾಟ್ಯಾ. ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ತ್ಯುನೊನೆ ಗಾಮ ಕನ ಲಿನ ಜಾ಼ವಾನಾ ಲ್ಹೊಡಾನಾ ಬಾಕಲೆ ಆಯಾ. ತೆ ಬಾಕಲ ತ್ಯುನೊನೆ ತಿನಾಕ್ಹು ತೆಜ಼ ಕಡೈಯು. ಪೆತ್ರಾ ವರಿ ತೆ ಕ್ಹುದಾನೊ ದುತ ತೆ ಬಾಕಲನಾ ಮುಲಕ ಭಾರಾ ಐನ ಯಕ್ಕ ಒಣಿ ದಾಟ್ಯಾ. ತೆಳಾಮಾ ಅಚಾನಕ ತೆ ಕ್ಹುದಾನೊ ದುತ ತಿನೆ ಛೊಡಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ಥಯಲ ಸಂಗತಿ ತೆಳಾಮಾ ತಿಳ್ದಿಲಿದಲ ಪೆತ್ರಾ \"ಪ್ರಭು ಮಕನ ತಿನಾ ದುತನೆ ಕ್ಹರಿಮಾಜ಼ ವಳಾಯೊ ಕೈನ ಹಮ್ನಾ ಮನೆ ಗ್ವತ್ತ ಥಯು. ತೆ ಮನೆ ಹೆರೊದನಾ ಹತ್ಮಾತೊ ಪಾರ ಕರ‍್ಯೊ. ಮನೆ ಸುಬಿ ಥಾವಸ ಕೈನ ಯೆಹುದಿವಾಲಾ ವಿಚಾರ ಕರ‍್ಯಾತಾ. ತೆನೈಸೊ ಪ್ರಭು ಮನೆ ತೆ ತ್ರಾಸಕ್ಹು ವಚಾ಼ಡ್ಯೊ \"ಕೈನ ಕೈಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ಪಾಚಲ್ತೊ ಪೆತ್ರಾ ಮರಿಯಳನಾ ಘರೆ ಗಯೊ. ತೆ ಯೊಹಾನನಿ ಯಾ ವ್ಹೈ. ಯೊಹಾನನೆ ಮಾರ್ಕ ಕೈನ ಬಲಾತಾತಾ. ಘನ್ನಾ ಮನಕ್ಹೊ ತ್ಯಾ ಮಳ್ಯಾ. ತ್ಯುನೆ ಕ್ಹಾರಾ ಪ್ರಾಥನಾ ಕರಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ಪೆತ್ರಾ ಭಾರ್ಲ್ಯು ಬಾಕಲ ವಜಾ಼ಡ್ಯೊ. ಕುನ ವ್ಹೈ ಕೈನ ಪುಚ್ಚಾ಼ನೆ ರೊದೆ ಕವಾನಿ ಸೆವಕಿ ಐ. ");
INSERT INTO sle_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ರೊದೆ ಪೆತ್ರಾನಿ ಅವಾಜ಼ ವಳಕಿ. ತಿನೆ ಘನ್ನಿ ಖುಶಿ ಥೈ. ಬಾಕಲ ಕಾಡಾನು ತೆ ಇಕ್ಹರಿನ, ಘರೆ ಆಯಲ ಮನಕ್ಹೊ ಕನ ನ್ಹಾಟಿನ ಗೈನ \"ಪೆತ್ರಾ ಬಾಕಲ ಕನ ಹುಬ್ರಯೊಸ\" ಕದಿ. ");
INSERT INTO sle_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ತೆ ವಿಶ್ವಾಸಿಯೊ ತಿನೆ ತುನೆ ಪಿಸಾಳು ಲಾಗ್ಯುಸ! ಕದ್ಯಾ. ತೆನೈಸೊ ತೆ ಕವಾನು ಕ್ಹರಿಜ಼ ವ್ಹೈ ಕೈನ ಕದಿ. ತಿನಾಹುತಿ ತ್ಯುನೆ\"ತೆ ಪೆತ್ರಾನೊ ದುತ ರ‍್ಹೌ \"ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ತೆನೈಸೊ ಪೆತ್ರಾ ಬಾಕಲ ವಜಾ಼ಡತೊಜ಼ ವ್ಹತ್ತೊ. ತೆ ವಿಶ್ವಾಸಿಯೊ ಬಾಕಲ ಕಾಡಲ ಪರ ತ್ಯುನೆ ಪೆತ್ರಾನೆ ದೆಕಿನ ಘಾಬ್ರಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ಪೆತ್ರಾ ತ್ಯುನೊನೆ ಗಪ್ಪ ರ‍್ಹೌ ಕೈನ ಇಶಾರೊ ಕರ‍್ಯೊ. ಪ್ರಭು ತಿನೆ ಜೈಲಮಾತೊ ಛೊಡಾಯಲ ತರಿಕಾನೆ ತೆ ತ್ಯುನೊನೆ ಕೈನ \"ಯಾಕೊಬನೆಬಿ ವರಿ ಭಾಯೊನೆಬಿ ಎ ಸಂಗತಿ ಕವೊ\" ಕೈನ ಕದ್ಯೊ. ಪಾಚಲ್ತೊ ಪೆತ್ರಾ ಬಿಜೆಕ್ಕ ಜ಼ಗಾನೆ ತ್ಯಾಂತೊ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ಮರ್ನಾ ದಿನ್ನೆ, ಪೆತ್ರಾ ಸು ಥಯೊ ಕೈನ ಸೈನಿಕೊನಾ ವಚ್ಮಾ ಮ್ಹೊಟಿ ಗದ್ದಲ ಉಟಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ಹೆರೊದ ಕ್ಹಾರಿ ಜ಼ಗಾ ಹುಡಕಿತಬಿ ಪೆತ್ರಾ ಮಳ್ಯೊ ನೈ. ತಿನಾಹುತಿ ಹೆರೊದ ಕೈದಾಲಾವೊನೆ ಪುಚ್ಚಿನ ತ್ಯುನೊನೆ ಖಲಾಸ ಕರಾನಿ ಶಿಕ್ಷಾ ದಿವಸ.. ಪಾಚಲ್ತೊ ಹೆರೊದ ಯುದೆಯತೊ ಸೆಜರೆಯ ಗಾಮೆ ಐನ ತ್ಯಾಜ಼ ದಕ್ಹಾ ದಿನ್ನ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ಟೈರ ವರಿ ಸಿದೊನ ಗಾಮೊಮಾ ಮನಕ್ಹೊನಾ ಉಪ್ಪರ ಹೆರೊದ ಘನ್ನೊ ಶಿಟ್ಟ ಥಯೊತೊ. ತೆ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಹೆರೊದನೆ ಮಳಾನೆ ಕ್ಹಾರಾ ಜ಼ನಾ ಮಳಿನ ಗಯಾ. ತ್ಯುನೆ ಬ್ಲಾಸ್ತನ ತ್ಯುನೊಕನ ವಲಸಿ ಲಿದ್ಯಾ. ಬ್ಲಾಸ್ತನ ರಾಜಾ಼ನೊ ಖಾಸ ಸೆವಕ ವ್ಹತ್ತೊ. ತೆ ಮನಕ್ಹೊ ತ್ಯುನಾ ಕ್ಹಾತೆ ಶಾಂತಿ ಸಮಾಧಾನ ಕರಿಲ್ಯು ಕೈನ ಹೆರೊದನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ಕಾಕದ್ಯಾಮ ತ್ಯುನಾ ಗಾಮೆ ಹೆರೊದ ಗಾಮತೊ ಆಹಾರ ಮಂಗೈಲಿವಾನೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ತ್ಯುನೊನೆ ಮಳಾನಾ ಹುತಿ ಹೆರೊದ ಯಕ್ಕ ದಿನ್ನೆ ಸೊಚಿನ ಮ್ಹೆಲ್ಯೊ. ತೆ ದಿನ್ನೆ ಹೆರೊದ ಸುಂದರ ರ‍್ಹಯಲ ರಾಜವಸ್ತ್ರ ಘಾಲ್ಲಿದ್ಯೊತೊ. ತೆ ತಿನಿ ಸಿಂಹಾಸನನಾ ಉಪ್ಪರ ಬೆಟಿನ ಮನಕ್ಹೊನೆ ಶಿಕ್ಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ತೆ ಮನಕ್ಹೊ\"ಎ ಆವಾಜ಼ ಮನಕ್ಹನಿ ನ್ಹವ್ಹೈ, ಕ್ಹುದಾನಿಜ಼ ವ್ಹೈ\" ಕೈನ ಅಡ್ಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ಹೆರೊದ ಎ ಹೊಗಳಿಕೆ ತೆಜ಼ ಸ್ವಿಕಾರ ಕರಿಲಿದ್ಯೊ. ಕ್ಹುದಾನೆ ಮಹಿಮೆ ಕರ‍್ಯೊ ನೈ. ತಿನಾಹುತಿ ತೆಜ಼ ಕ್ಷಣಮಾ, ಪ್ರಭುನೊ ಯಕ್ಕ ದುತ ತಿನೆ ರೊಗ ಲಾಯೊ. ತಿನಾ ಅಂಗನಾ ಮ್ಹೈನಾ ಭಾಗನೆ ಕಿಡಾ ಖಾದಲಕ್ಹು ತೆ ಮರಿ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ಕ್ಹುದಾನಿ ಸಂದೆಶ ಫೈಲಾಡಿತಿ ವರಿ ಘನ್ನಾ ಘನ್ನಾ ಮನಕ್ಹೊನಾ ಉಪ್ಪರ ಪ್ರಭಾವ ಪಡಾಡುತು. ಇಕ್ಹು ವಿಶ್ವಾಸಿಯೊನು ಸಮುದಾಯ ಮ್ಹೊಟು ಥಾವಾನು ಶುರು ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ಬಾರ್ನಬ ವರಿ ಸೌಲಾ ಯೆರುಸಲೆಮಮಾ ತ್ಯುನು ಕಾಮ ಕ್ಹರಾಯಲಪರ ಅಂತಿಯೊಕ್ಯನೆ ಫರಿನ ಗಯಾ. ಮಾರ್ಕ ಕವಾಲೊ ಯೊಹಾನ ತ್ಯುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ಅಂತಿಯೊಕ್ಯನಾ ಸಭೆಮಾ ದಕ್ಹಾ ಪ್ರವಾದಿಯೊ ವರಿ ಉಪದೆಶ ಕರಾಲಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಕುನ್ ವ್ಹೈ ಕದ್ಯಾಮ; ಬಾರ್ನಬ, ಸಿಮೆಯೊನ್ ಇನೆ ನಿಗರ ಕೈನಬಿ ಬಲಾತಾತಾ. ಲುಸಿಯಸ ಸಿರೆನ ಗಾಮ ವಾಲೊ ವ್ಹೈ. ಮೆನಹೆನ ಹೆರೊದ ರಾಜಾ಼ನಾ ಕ್ಹಾತೆ ಬೆಳದಲವಾಲೊ ವರಿ ಸೌಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ಇವ್ನೆ ಕ್ಹಾರಾ ಪ್ರಭುನಿ ಸೆವೆ ಕರಾಡಾತಾ ವರಿ ಉಪಾಸ ಕರಾಡಾತಾ. ಪವಿತ್ರ ಆತ್ಮಾ ತ್ಯುನೊನೆ\"ಮಿ ಖಾಸ ರ‍್ಹಯಲ ಕಾಮೊನಾ ಹುತಿ ಬಾರ್ನಬ ವರಿ ಸೌಲಾನೆ ಇನಿಲಿದ್ಯೊ. ತೆ ಕಾಮೊನಾ ಹುತಿ ತ್ಯುನೊನೆ ಪ್ರೊತ್ಸಾಹ ಕರೊ \"ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ತಿನಾಹುತಿ ಸಭೆವಾಲಾ ಉಪಾಸ ರ‍್ಹೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ. ತ್ಯುನೆ ಬಾರ್ನಬ ವರಿ ಸೌಲಾನಾ ಉಪ್ಪರ ಹಸ್ತಾರ್ಪಣೆ ಕರಿನ ತ್ಯುನೊನೆ ವಳೈನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ಬಾರ್ನಬ ವರಿ ಸೌಲಾನೆ ಪವಿತ್ರ ಆತ್ಮಾಜ಼಼ ವಳೈನ ದಿದ್ಯೊ. ತ್ಯುನೆ ಸೆಲುಸಿಯಾ ಗಾಮೆ ಗಯಾ. ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಸೆಲುಸಿಯಾತಾ ಸೈಪ್ರಸ ದ್ವಿಪೆ ಹಡಗಾಮಾ ಪ್ರಯಾಣ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ಬಾರ್ನಬ ವರಿ ಸೌಲಾ ಸಲಾಮಿಸ ಗಾಮೆ ಆಯಲ್ಪರ ಯೆಹುದಿನಾ ಸಭಾ ಮಂದಿರಮಾ ಕ್ಹುದಾನಿ ಸಂದೆಶ ಕದ್ಯಾ. ಮಾರ್ಕ ಕವೈಲಿವಾಲೊ ಯೊಹಾನ ಮದತ ಕರಾನಾ ಹುತಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ತ್ಯುನೆ ತೆ ದ್ವಿಪಮಾ ಪ್ರಯಾಣ ಕರ‍್ತಾ ಪಾಫೊಸ್ ಕವಾನಾ ಗಾಮೆ ಗಯಾ. ಮಂತ್ರ ತಂತ್ರ ಕರಾಲಾ ಯಕ್ಕ ಯೆಹುದಿವಾಲಾನೆ ತ್ಯುನೆ ಪಾಫೊಸಿಮಾ ದೆಕ್ಯಾ. ತಿನು ನಾಮ \"ಬಾರ್ ಯೆಸು\" ತೆ ಯಕ್ಕ ಸುಳ್ಳ ಪ್ರವಾದಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ಸೆರ್ಗ್ಯ ಪೌಲಾ ರಾಜ್ಯಪಾಲನಾ ನಜಿಕಜ಼ ತೆ ಕೆಳಾಮಾಬಿ ರ‍್ಹತೊತೊ. ಸೆರ್ಗ್ಯಪೌಲಾ ಗ್ಯಾನಿ ವ್ಹತ್ತೊ. ತ್ಯುನೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾನೆ ಐಕಾನೆ ಬಾರ್ನಬ ವರಿ ಸೌಲಾನೆ ಬಲಾವಾನೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ತೆನೈಸೊ ಮಾಟಾ ಮಂತ್ರಾ ಕರಾಲೊ ರ‍್ಹಯಲ ಎಲಿಮ ಬಾರ್ನಬ ವರಿ ಸೌಲಾನೆ ವಿರುದ್ಧ ವ್ಹತ್ತೊ. ಗ್ರಿಕ ಭಾಶಾಮಾ ಎಲಿಮ ಕೈನ ಬಲಾತಾತಾ. ರಾಜ್ಯಪಾಲ ಯೆಸುಪರ ಬರೊಕ್ಹೊ ನೈ ಮ್ಹೆಲೆ ಲಿಂಗತ ಕರಾನೆ ಎಲಿಮ ಕೊಶಿಶ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ತೆನೈಸೊ ಪೌಲಾ ಸೌಲಾನು ವರಿಯಕ್ಕ ನಾಮ ಪೌಲಾ ವ್ಹೈ. ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರ‍್ಯೊ. ಪೌಲಾ ಎಲಿಮನೆ ಡೊಳಾ ಫಾಡಿನ ದೆಕಿನ, ");
INSERT INTO sle_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ತಿನೆ, ತು ಸೈತಾನನೊ ದಿಕ್ರೊ ವ್ಹೈ! ಹರಯಕ್ಕ ಚೊ಼ಕಾನೆ ತು ದುಶ್ಮನ ವ್ಹೈ! ತು ಕೆಟ್ಟ ತಂತ್ರೊಕ್ಹು ಸುಳ್ಳಕ್ಹು ಭರಲ ಛೆ. ಪ್ರಭುನಿ ಸತ್ಯನೆ ಸುಳ್ಳ ಕೈನ ಬದಲಾನೆ ತು ಕೊಶಿಶ ಕರಾಡ್ಯೊಸ! ");
INSERT INTO sle_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ಐಕ, ಪ್ರಭುನೊ ಹತ್ತ ತಾರಾ ವಿರುದ್ದ ಉಚಾಯೊಸ.. ತು ಕುಡ್ಡೊ ಥೈನ ದಕ್ಹಿಯೆಳ ಸುಜ಼ ದೆಕ್ತೊ ನೈ; ಸುರ್ಯಾನು ಉಜಾಲುಬಿ ನೈ ದೆಕ ಸಕ್ತೊ \"ಕದ್ಯೊ. ತೆಳಾಮಾ ಎಲಿಮನೆ ಕ್ಹಾರು ಅಂದಾರು ಥಯು. ತಿನೆ ಕುನ್ನತಬಿ ಹತ್ತ ಧರಿನ ಚ಼ಲಾವೊ ಕೈನ ತೆ ಕಾಪ್ತೊ ಸುತ್ತೆ ಚಾ಼ಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ಇನೆ ದೆಕಲ ರಾಜ್ಯಪಾಲ ಪ್ರಭುನೆ ಬರೊಕ್ಹೊ ಕರ‍್ಯೊ. ಪ್ರಭುನಿ ವಿಶಯ ಥಯಲ ಉಪದೆಶ ಐಕಿನ ಘಾಬ್ರೊ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ಪೌಲಾ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ಪಾಫೊಸಿನತಾ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ಪಾಂಫಿಲಿನಾ ಪ್ರಾಂತ್ಯಮಾ ರ‍್ಹಯಲ ಪೆರ್ಗ ಕವಾನಾ ಗಾಮೆ ತ್ಯುನೆ ಆಯಾ. ತೆನೈಸೊ ಮಾರ್ಕ ಕವೈಲಿವಾಲೊ ಯೊಹಾನ ತ್ಯುನೊನೆ ಛೊಡಿನ ಯೆರುಸಲೆಮೆ ಫರಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ತ್ಯುನೆ ತ್ಯುನು ಪ್ರಯಾಣ ಪೆರ್ಗತಾ ಅಗಾ ಬಡೈನ, ಪಿಸಿದಿ ಗಾಮನಿ ರ‍್ಹಯಲ ಅಂತಿಯೊಕ್ಯನೆ ಗಯಾ. ತ್ಯುನೆ ಅಂತಿಯೊಕ್ಯನೆ ಸಬ್ಬತ ದಿನ್ನೆ ಯೆಹುದಿನಾ ಸಭಾ ಮಂದಿರಮಾ ಗೈನ ಬೆಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರ ವರಿ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥೊ ಒದ್ಯಾ. ಪಾಚಾ಼ತಾ ಸಭಾ ಮಂದಿರನಾ ನಾಯಕೊ ಪೌಲಾ ಬಾರ್ನಬನೆ, ಭಾಯೊ, ನ್ಹ್ಯಾ ರ‍್ಹವಾನಾ ಮನಕ್ಹೊನೆ ಮದತ ಥಯೆ ಲಿಂಗತ ಸು ತುಬಿ ತುಮೆ ಕವಾನು ರ‍್ಹಯಮ ಕವೊ \"ಕವಾನು ಸಂದೆಶ ವಳಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ಪೌಲಾ ಉಟಿನ ಹುಬ್ರೈನ ತಿನಾ ವಾತೊ ಐಕು ಕೈನ ಮನಕ್ಹೊನೆ ಹತೆ ಇಶಾರೊ ಕರಿನ ಅಮ್ಮ ಕದ್ಯೊ; \"ಮಾರಾ ಯೆಹುದಿನಾ ಭಾಯೊ, ಕ್ಹರಿನಾ ಕ್ಹುದಾನೆ ಆರಾಧನಾ ಕರಾಲಾ ಬಿಜಾ಼ ಮನಕ್ಹೊ, ಮಿ ಕವಾನು ಐಕೊ! ");
INSERT INTO sle_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ಇಸ್ರಾಯೆಲನೊ ಕ್ಹುದಾ ಅಪ್ನಾ ಪಿತೃವೊನೆ ಇನಿಲಿದ್ಯೊ. ಇಜಿಪ್ತಮಾ ಪ್ರವಾಸಿಯೊ ಥೈನ ರ‍್ಹವಾಲಾ ತಿನಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ಮದತ ಕರಿನ ಅಭಿವೃದ್ದಿ ಕರ‍್ಯೊ. ಕ್ಹುದಾ ತಿನಿ ಮ್ಹೊಟಿ ತಾಕತ ಕ್ಹು ತ್ಯುನೊನೆ ತೆ ದೆಶತೊ ಚ಼ಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ಉಸುಕನಾ ಗಾಮಮಾ ತ್ಯುನೊನೆ ಚಾ಼ಳಕ್ಹ ವರಕ್ಹ ತ್ಯುನೊನೆ ತಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ಕಾನಾನ್ ಕ್ಹಾತ ಪ್ರಾಂತ್ಯನೆ ಹಾಳ ಕರಿನ ತಿನಾ ಮನಕ್ಹೊನೆ ತೆ ದೆಶ ಸ್ವಾದಿನ ಕರಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ಎ ಕ್ಹಾರು ಕ್ಹೊನೈವತ್ತ ವರಕ್ಹ ಲಕ್ಕಾ ಚಾ಼ಲ್ಯು\" ಎ ಥಯಲ್ಪರ ಪ್ರವಾದಿ ಥಯಲ ಸಮುವೆಲನಾ ಕಾಲ ಲಕ್ಕಾ ಕ್ಹುದಾ ಅಪ್ನಾ ಮನಕ್ಹೊನೆ ನ್ಹಾಯಸ್ಥಾಪಕೊನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ಪಾಚಾ಼ತಾ ಮನಕ್ಹೊ ತ್ಯುನೊನೆ ರಾಜೊ಼ ಚಾ಼ಯೆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಕಿಶನನೊ ದಿಕ್ರೊ ರ‍್ಹಯಲ ಸೌಲಾನೆ ದಿದ್ಯೊ. ಸೌಲಾಬೆನ್ಯಾನಿನ್ ಘರ್ದಾನನೊ ವ್ಹೈ. ತೆ ಚಾ಼ಳಕ್ಹ ವರಕ್ಹ ಲಕ್ಕಾ ರಾಜೊ಼ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ಕ್ಹುದಾ ಸೌಲಾನೆ ಕಾಡಲ ಪರ ದಾವಿದನೆ ತ್ಯುನೊ ರಾಜೊ಼ ಥೈನ ಕರ್ಯೊ. ‘ಇಶಯನನೊ ದಿಕ್ರೊ ಥಯಲ ದಾವಿದ ಮನೆ ಮೆಚ್ಚಿಗೆ ಥಯಲವಾಲೊ ವ್ಹೈ. ತೆ ಮಾರಿ ಆಸ ಲಿಂಗತ ಕಾಮೊ ಕರಸ’ ಕೈನ ಕ್ಹುದಾ ತೆ ದಾವಿದನಾ ಹುತಿ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","\"ಕ್ಹುದಾ ತಿನಾ ವಾಗ್ದಾನನಾ ಲಿಂಗತ ದಾವಿದನಾ ಸಂತಾನಮಾನೊ ಯಕ್ಲಾನೆ ಇಸ್ರಾಯೆಲ ರಕ್ಷಕ ಥೈನ ವಳೈನ ದಿದ್ಯೊಸ. ತೆಜ಼ ಯೆಸು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ಯೆಸು ಆವಾತಿ ಪೈಲಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಾವಾಲೊ ಯೊಹಾನ ಯೆಹುದಿನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ‘ತುಮಾರಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಕನ ಫರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈ ಲಿವೊ’ ಕೈನ ಬೊದನೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","‘ಮಿ ಕುನ್ನ ವ್ಹೈ ಕೈನ ಸೊಚೊ಼ಶಿ ತುಮೆ? ಮಿ ಕ್ರಿಸ್ತ ನ್ಹವ್ಹೈ. ತೆ ಮಾರಾ ಪಾಚೊ಼ ತೆ ಆವಸ. ತಿನಾ ಚಪ್ಪಲನಿ ದೊರಿಯೊಬಿ ಖೊಲಾನೆ ಮಿ ಯೊಗ್ಯ ನ್ಹವ್ಹೈ’ ಕೈನ ಯೊಹಾನ ತಿನು ಕಾಮ ಕರಿನ ಪುರಾ ಕರ್ತಾಮಾ ಕೈಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","\"ಮಾರಾ ಭಾಯೊ, ಅಬ್ರಹಾಮನಾ ಕುಟುಂಬನಾ ಬಚ್ಚಾ಼, ಕ್ಹರಿನಾ ಕ್ಹುದಾನೆ ಆರಾಧನಾ ಕರಾಲಾ ಯೆಹುದಿಯೊ ನೈ ರ‍್ಹಯಲವಾಲಾ, ಐಕೊ! ಎ ರಕ್ಷಣೆನಾ ಸಂದೆಶನೆ ವಳಾಯಲ ಅಪ್ನಾ ಹುತಿಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ಯೆರುಸಲೆಮಮಾ ರ‍್ಹಯಲ ಯೆಹುದಿಯೊ ವರಿ ಯೆಹುದಿನಾ ನಾಯಕೊ ಯೆಸುಜ಼ ರಕ್ಷಕ ವ್ಹೈ ಕವಾನು ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ಪ್ರವಾದಿಯೊ ಯೆಸುನಾ ಹುತಿ ಬರ್ದಲ ವಾತೊ ಹರ ಸಬ್ಬತ್ತನಾ ದಿನ್ನೆ ಒದತಾತಾ. ತೆನೈಸೊ ತ್ಯುನೆ ತಿಳ್ದಿಲಿದ್ಯಾ ನೈ. ತೆ ಯೆಹುದಿಯೊ ಯೆಸುನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಪೈಸ್ಲೊ ಕರ‍್ಯಾ. ಇಮ್ಮ ಕರಾನಾ ಮುಲಕ ತ್ಯುನೆ ಪ್ರವಾದಿ ಕದಲ ಪುರಾ ಕರ‍್ಯಾ! ");
INSERT INTO sle_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ಯೆಸು ಮರುಜ಼ ಕವಾನೆ ಕರೆಟ್ಟ ಕಾರಣ ತ್ಯುನೆ ಕಂಡ ಧರಾನೆ ನೈ ಥಯು ತುಬಿ ಯೆಸುನೆ ಖಲಾಸ ಕರೌ ಕೈನ ಪಿಲಾತನ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","\"ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಲಿಂಗತ ಯೆಸುನೆ ಥಾವಾನು ರ‍್ಹಯಲ ಕ್ಹಾರು ಕೆಟ್ಟ ಯಹುದಿಯೊ ತಿನೆ ಕರ‍್ಯಾ. ಪಾಚಾ಼ತಾ ತ್ಯುನೆ ಯೆಸುನೆ ಶಿಲುಬಿತಾ ಹೆಟಾ ಉತಾರಿನ ಮಝಾರಮಾ ಮ್ಹೆಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡ್ಯೊ! ");
INSERT INTO sle_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ಎ ಥಯಲ್ಪರ ಗಲಿಲಾಯತಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ಯೆರುಸಲೆಮೆ ಆಯಲವಾಲಾ, ಘನ್ನಾ ದಿನ್ನ ಲಕ್ಕಾ ತಿನೆ ದೆಕ್ಯಾ. ಹಮ್ನಾ ತ್ಯುನೆಜ಼ ಮನಕ್ಹೊನೆ ಸಾಕ್ಷಿಯೊ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","\"ಕ್ಹುದಾ ಅಪ್ನಾ ಪಿತೃವೊನೆ ಕರಲ ವಾಗ್ದಾನನಾ ವಿಷಯಮಾ ರ‍್ಹಯಲ ಸುವಾರ್ತೆ ಹಮೆ ತುಮೊನೆ ಕೈಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ಹಮೆ ತ್ಯುನಾ ತ್ಯುನಾ ಸಂತತಿವಾಲಾ ಥಯಾಸ. ಕ್ಹುದಾ ಯೆಸುನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡಾನಾ ಮುಲಕ ತೆ ವಾಗ್ದಾನ ಅಪ್ನಾ ಹುತಿ ಪುರಾ ಕರ‍್ಯೊಸ. ಇನಾ ಹುತಿ ಬೆಂವಾ ಕಿರ್ತನೆಮಾ ಅಮ್ಮ ಬರ್ದಲ ಛೆ, ತುಜ಼಼ ಮಾರೊ ದಿಕ್ರೊ ವ್ಹೈ. ಆಜ಼ಜ಼ ಮಿ ತುನೆ ಪಡ್ದಿಲಿದ್ಯೊ. ಕಿರ್ತನೆ 2:7 ");
INSERT INTO sle_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ಕ್ಹುದಾ ಯೆಸುನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡಲ ಹುತಿ ತೆ ವರಿ ಕೆಳಾಮಾಜ಼ ಸಮಾದಿಮಾ ಗೈನ ಖಡ್ತು ನೈ ಕವಾನಿ ವಿಷಯಮಾ ಕ್ಹುದಾ ಅಮ್ಮ ಕದ್ಯೊಸ. ‘ಮಿ ದಾವಿದನೆ ಕರಲ ಕ್ಹರಿ ಪವಿತ್ರ ರ‍್ಹಯಲ ವಾಗ್ದಾನೊ ತುನೆ ದಿವ್ಸ. ಯೆಶಾಯ 55:3 ");
INSERT INTO sle_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ತೆನೈಸೊ ವರಿಯಕ್ಕ ಜ಼ಗಾ ಪರ ಕ್ಹುದಾ ಇಮ್ಮ ಕವಸ. ‘ತು ತಾರು ಪರಿಶುದ್ಧ ಅಂಗನೆ ಸಮಾದಿಮಾ ಖಡಾನೆ ಛೊಡತೊ ನೈ. ಕಿರ್ತನೆ 16:10 ");
INSERT INTO sle_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","\"ದಾವಿದ ತಿನಿ ಜಿವಿತಮಾ ಕ್ಹುದಾನಿ ಚಿತ್ತ ಲಿಂಗತ ಜಿವ್ನಾ ಕರ‍್ಯೊ. ಪಾಚಲ್ತೊ ತೆ ಮರ‍್ಯೊ. ದಾವಿದನೆ ತಿನಾ ಪಿತೃವೊನಾ ಕ್ಹಾತೆ ಸಮಾದಿ ಕರ‍್ಯಾ. ತಿನು ಅಂಗ ಸಮಾದಿಮಾ ಕ್ಹಡಿ ಗಯು! ");
INSERT INTO sle_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ತೆನೈಸೊ ಕ್ಹುದಾಕ್ಹು ಜಿವ್ತೊ ಥೈನ ಉಟಾಡಲ ಯೆಸುನು ಅಂಗ ಸಮಾದಿಮಾ ಕ್ಹಡ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ಭಾಯೊ ಭೆನೊ, ಎ ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹವಾದೆ; ತಿನಾ ಮುಲಕ ತುಮಾರಾ ಪಾಪೊನೆ ಮಾಫಿ ಮಳಸ. ಮೊಶೆ ಧರಮಶಾಸ್ತ್ರನೆ, ತುಮೊನೆ ತುಮಾರಾ ಪಾಪೊಕ್ಹು ಛೊಡಾವಾನೆ ಥಯು ನೈ. ತೆನೈಸೊ ಯೆಸು ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಹರಯಕ್ಲೊ ತಿನಾ ಮುಲಕ ತಿನಾ ಕ್ಹಾರಾ ಪಾಪೊಕ್ಹು ಛುಟಸ. ");
INSERT INTO sle_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ತಿನಾಹುತಿ ಪ್ರವಾದಿಯೊ ತಿಳಸಾಯಲ ಎ ");
INSERT INTO sle_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ಪ್ರವಾದಿಯೊನಾ ದಕ್ಹಾ ಸಂಗತಿಯೊ ತುಮೊಮಾ ಕ್ಹರಿ ಥಾಯೆ ನೈಸೊ ಹುಶಾರ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ಕದ್ರಾವಾಲಾ, ಘಾಬ್ರಾ ಥಾತಾ ಹಾಳ ಥೈನ ಜಾ಼ವೊ. ತುಮೆ ನೈ ಬರೊಕ್ಹೊ ಕರಾನು ಯಕ್ಕ ಕಾಮ ಮಿ ಕರುಸ. ಬಿಜೊ಼ ಯಕ್ಲೊ ತುಮೊನೆ ತೆ ವಿವರಣೆ ಕರ‍್ಯೊ ತುಬಿ ತುಮೆ ನೈ ಬರೊಕ್ಹೊ ಕರ‍್ತಾ (ಹಬಕ್ಕುಕ 1:5) ");
INSERT INTO sle_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ಪೌಲಾ ವರಿ ಬಾರ್ನಬ ಸಭಾಮಂದಿರತಾ ಜಾ಼ತಾಮಾ, ಎ ಸಂಗತಿಯೊನಾ ಹುತಿ ಹಜು಼ನ ಜಾಸ್ತ ತಿಳ್ಸಾನಾ ಹುತಿ ಅಗಲ್ಯಾ ಸಬ್ಬತ್ ದಿನ್ನೆ ವರಿ ಔ ಕೈನ ಮನಕ್ಹೊ ತ್ಯುನೊ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ಸಭೆ ಕ್ಹರಲ ಪರ ಘನ್ನಾ ಯಹುದಿಯೊ ಪೌಲಾ ಬಾರ್ನಬನೆ ತೆ ಜ಼ಗಾತಾ ಪಾಚಾ಼ ಲಾಗ್ಯಾ. ಯೆಹುದಿಯೊನಾ ಧರ್ಮನೆ ಮಳಲ ಘನ್ನಾ ಬಿಜಾ಼ ಮತನಾ ತೆ ಯೆಹುದಿಯೊನಾ ಕ್ಹಾತೆ ವ್ಹತ್ತಾ. ಧರ್ಮ ಬದ್ಲಿ ಕರಲ ಇವ್ನೆಬಿ ಕ್ಹರಿನಾ ಕ್ಹುದಾನೆ ಆರಾಧನೆ ಕರಾಡಾತಾ. ಪೌಲಾ ಬಾರ್ನಬ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬೊಲಿನ, ಕ್ಹುದಾನಿ ಕೃಪೆಮಾ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿನ ಅಗು ಬಡು ಕೈನ ಪ್ರೊತ್ಸಾಹ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ಅಗಲ್ಯಾ ಸಬ್ಬತ ದಿನ್ನೆ, ಪ್ರಭುನಿ ವಾಕ್ಯಾ ಐಕಾನಾ ಹುತಿ ಘನ್ನಾ ಗಾಮನಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ತ್ಯಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ಇನೆ ದೆಕಿನ ಯಹುದಿಯೊನೆ ಘನ್ನು ಅಸೈ ಥಯು. ತ್ಯುನೆ ಪೌಲಾನಾ ವಾತಾ ದೊಶ ಕರಿನ ತಿನೆ ವಿರುದ್ದ ವಾದ-ವಿವಾದ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ತೆನೈಸೊ ಪೌಲಾ ಬಾರ್ನಬ ಘನ್ನಾ ಧೈರ್ಯಾಕ್ಹು ಬೊಲಿನ\"ಹಮೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಯೆಹುದಿಯೊ ಥಯಲ ತುಮೊನೆ ಪೈಲಾ ಕೌ. ತೆನೈಸೊ ತುಮೆ ತುಮೊನೆ ಹಮೆಶಾನು ಜ಼ಲಮನೆ ಪಾತ್ರ ನ್ಹವೈ ಕೈನ ತಿರಸ್ಕಾರ ಕರಾಡಾಸ. ತಿನಾಹುತಿ ಹಮೆ ಬಿಜಾ಼ ಧರ್ಮವಾಲಾವೊ ಕನ ಗೈಯೆಸ! ");
INSERT INTO sle_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ಕಾಕದ್ಯಾಮ ಪ್ರಭು ಹಮೊನೆ ದಿದಲ ಆಜ್ಞಾ ಅಮ್ಮ ಛೆ ದುನಿಯಾನಾ ಲಾಸ್ಟ ಲಕ್ಕಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ತು ವಚಾ಼ಡಾಲೊ ಥೌ ಕೈನ ಮಿ ತುನೆ ಬಿಜಾ಼ ಜನಾಂಗೊನೆ ಉಜಾಲು ಕರ‍್ಯೊಸ. (ಯೆಶಾಯ 49:6) ");
INSERT INTO sle_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ಪೌಲಾ ಎ ವಾತೊ ಐಕಿನ ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊ ಘನ್ನಾ ಖುಶಿ ಥೈನ ಪ್ರಭುನಿ ಸಂದೆಶನಾ ಹುತಿ ಸ್ತುತಿ ಕರ‍್ಯಾ. ಹಮೆಶಾನು ಜ಼ಲಮ ವ್ಹಂದಿಲಿವಾನೆ ಇನಿಲಿದಲ ಕ್ಹಾರಾ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ಪ್ರಭುನಿ ಸಂದೆಶ ತೆ ಕ್ಹಾರಾ ಗಾಮಮಾ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ತೆನೈಸೊ ಯೆಹುದಿಯೊ ದಕ್ಹಾ ಧಾರ್ಮಿಕ ಬಾಕ್ಡಿಯೊನೆ ಗಾಮನಾ ನಾಯಕೊನೆ ಪ್ರೊತ್ಸಾಹ ಕರಿನ, ಪೌಲಾ ಬಾರ್ನಬನಾ ಉಪ್ಪರ ತ್ಯುನೆ ಶಿಟ್ಟ ಥಾಯೆ ಲಿಂಗತ ತ್ಯುನೊನೆ ವಿರೊದಿಯೊ ಥಾಯೆ ಲಿಂಗತ ಕರಿನ ಪೌಲಾ ಬಾರ್ನಬನೆ ಗಾಮತಾ ಭಾರಾ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ತಿನಾಹುತಿ ಪೌಲಾ ಬಾರ್ನಬ ತ್ಯುನಾ ವಿರುದ್ದ ಥೈನ ತ್ಯುನಾ ಪಗೊನು ಧುಳ್ಳ ಝಾಡ್ಸಿನ, ಇಕೊನಿಯಾ ಗಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ತೆನೈಸೊ ತಂತ್ಯಯೊಕ್ಕನಾ ವಿಸ್ವಾಸಿಯೊ ಖುಶ ಥಯಾತಾ ವರಿ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಭರ‍್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ಪೌಲಾ ಬಾರ್ನಬ ಇಕೊನಿಯಾ ಗಾಮೆ ಗಯಾ. ಹರಯಕ್ಕ ಗಾಮಮಾಬಿ ತ್ಯುನೆ ಬೊಲಲ ಲಿಂಗತ ನ್ಹ್ಯಾಬಿ ಯೆಹುದಿಯೊನಾ ಸಭಾಮಂದಿರಮಾ ಗೈನ ಮನಕ್ಹೊನೆ ಬೊಧನೆ ಕರ‍್ಯಾ. ಪೌಲಾ ಬಾರ್ನಬನಿ ಚೊ಼ಕಿ ಬೊದನೆ ಐಕಿನ ಘನ್ನಾ ಯೆಹುದಿಯೊ ವರಿ ಗ್ರಿಕವಾಲಾ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ತೆನೈಸೊ ಯೆಹುದಿಯೊಮಾ ನೈ ಬರೊಕ್ಹೊ ಕರಲ ದಕ್ಹಾ ಯೆಹುದಿ ನೈಸೊವಾಲಾವೊನೆ ಮನಸ ಭಾಯೊನೆ ವಿರುದ್ದ ಥೈನ ಮನಕ್ಹೊನೆ ಕದ್ರೈನ ಕೆಡ್ಸಿ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ತೆನೈಸೊ ಪೌಲಾ ಬಾರ್ನಬ ಇಕೊನಿಯಾಮಾ ಘನ್ನಾ ದಿನ್ನ ರ‍್ಹೈನ ಪ್ರಭುನಾ ಹುತಿ ಧೈರ್ಯಕ್ಹು ಬೊಲ್ಯಾ. ಪ್ರಭು ತ್ಯುನಾ ಮುಲಕ ಸುಚಕ ಕಾಮೊ ವರಿ ಅದ್ಭುತ ಕಾಮೊ ಕರಿನ ತಿನಿ ಕೃಪಾನಿ ಸಂದೆಶ ದೆಕಾಡಿನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ತೆನೈಸೊ ತೆ ಗಾಮನಾ ಮನಕ್ಹೊ ಬೆ ಭಾಗ ಥಯಾ ದಕ್ಹಾ ಜ಼ನಾ ಯೆಹುದಿವಾಲಾ ಕಂತಾ ಥಯಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ಅಪೊಸ್ತಲೊಕನ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ಯೆಹುದಿಯೊ ನೈಸೊಲಾವಾವೊಮಾ ವರಿ ಯೆಹುದಿಯೊಮಾ ದಕ್ಹಾ ತ್ಯುನಾ ನಾಯಕೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ಅಪೊಸ್ತಲೊನೆ ದಗ್ಡಾ ನಾಕಿನ ಖಲಾಸ ಕರು ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ಎ ಗ್ವತ್ತ ಥಯಲ ಪೌಲಾ ಬಾರ್ನಬ ತೆ ಗಾಮ ಛೊಡಿನ ಲುಕವೊನಿಯಾನಾ ಗಾಮೊ ರ‍್ಹಯಲ ಲುಸ್ತ್ರ ವರಿ ದರ್ಬೆನೆ ವರಿ ತೆ ಗಾಮೊನಾ ಸುತ್ತಮುತ್ತ ರ‍್ಹಯಲ ಜ಼ಗಾವೊನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ತ್ಯುನೆ ತ್ಯಾಬಿ ಸುವಾರ್ತೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ಲುಸ್ತ್ರಮಾ ಯಕ್ಕ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ತಿನಾ ಪಗೊಮಾ ತಾಕತ ನ್ಹೊತಿ. ಹುಟ್ಯಲ ತೆಳತೊ ಲಂಗ್ಡೊ ವ್ಹತ್ತೊ ತೆ ಕೆಳಾಮಾಜ಼ ಚಾ಼ಲ್ಯೊ ನ್ಹೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ಎ ಮನಕ್ಹ ತೆ ಬೆಟಲ ಜ಼ಗಾಜ಼ ಪೌಲಾನಿ ವಾತೊ ಐಕಾಡೊತೊ. ಪೌಲಾ ತಿನೆ ಡೊಳಾ ಕಾಡಿನ ದೆಕ್ಯೊ. ಕ್ಹುದಾ ಅರಾಮ ಕರಸ ಕವಾನೊ ಬರೊಕ್ಹೊ ತಿನಾಮಾ ರ‍್ಹಯಲ ಪೌಲಾ ದೆಕಿನ, ");
INSERT INTO sle_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ತಿನೆ\"ಉಟ್ಟ, ತಾರಾ ಪಗೊಪರ ಹುಬ್ರೆ\" ಕೈನ ಜೊ಼ರ ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತೆ ಮನಕ್ಹ ಜಿಗ್ದಿನ ಹುಬ್ರೈನ ಚಾ಼ಲಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ಪೌಲಾ ಕರಲ ಎ ಕಾಮ ದೆಕಲ ಮನಕ್ಹೊ ತ್ಯುನಾ ಸ್ವಂತ ಲುಕವೊನಿ ಬಾಶಾಮಾ \"ದಿವಸ್ತಾನೊ ಮನಕ್ಹನು ರುಪ ಲಿನ ಅಪೊಕನ ಉತ್ರಿನ ಆಯಾಸ\" ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ಮನಕ್ಹೊ ಬಾರ್ನಬನೆ \"ಜೆಯುಸ \"ಕ್ಹುದಾ ಕೈನ ಖಾಸ ಬೊದಕ ಥಯಲ ಪೌಲಾನೆ \"ಹೆರ್ಮೆ \"ಕ್ಹುದಾ ಕೈನ ಬಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ಜೆಯುಸನಿ ಗುಡಿ ಗಾಮನಾ ನಜಿಕಮಾ ವ್ಹತ್ತಿ. ಎ ಗುಡಿನೊ ಪುಜಾರಿ ದಕ್ಹಾ ಗೈಯೊ ವರಿ ಫುಲ್ಲೊ ಗಾಮನಾ ಬಾಕಲ ಕನ ಲಿನ ಆಯೊ. ತೆ ಪುಜಾರಿ ವರಿ ಮನಕ್ಹೊ ಪೌಲಾ ಬಾರ್ನಬನೆ ಬಲಿ ದಿನ ತ್ಯುನೊನೆ ಆರಾಧನಾ ಕರು ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ಎ ಐಕಿನ ಅಪೊಸ್ತಲ ಥಯಲ ಪೌಲಾ ಬಾರ್ನಬ ತ್ಯುನಾ ವಣ್ಣಾ ಫಾಡಿ ಲಿನ ಮನಕ್ಹೊನಾ ಗುಂಪಮಾ ಗೈನ ಅಮ್ಮ ವದ್ರಿನ ಕದ್ಯಾ; ");
INSERT INTO sle_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","\"ಮನಕ್ಹೊ ತುಮೆ ಎ ಕಾಮೊ ಕರಾನು ಶಾನೆ? ಹಮೆ ಕ್ಹುದಾವೊ ನ್ಹವ್ಹೈ. ಹಮೆ ತುಮಾರಾ ಲಿಂಗತ ಮನಕ್ಹೊಜ಼ ವ್ಹೈ. ತುಮೊನೆ ಸುವಾರ್ತೆ ಕವಾನಾ ಹುತಿ ಹಮೆ ಆಯಾಸ. ವ್ಯರ್ಥ ರ‍್ಹಯಲ ಕಾಮೊ ತುಮೆ ಛೊಡಿ ಪಡೊ; ಜಿವ ಸ್ವರುಪ ಥಯಲ ಕ್ಹುದಾ ಕನ ಫರೊ. ಹಬಾಳನೆ ಜಿಮಿನನೆ ಸಮುಂದರನೆ ವರಿ ತೆ ಕ್ಹಾರಾವೊಮಾ ರ‍್ಹವಾನು ಹರಯಕ್ಕನೆ ತಯ್ಯಾರ ಕರಲವಾಲೊ ತೆಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","\"ಪೈಲಾನಾ ಕಾಲಮಾ ಕ್ಹುದಾ ಕ್ಹಾರಾ ಜನಾಂಗೊನೆ ತ್ಯುನಿ ಇಶ್ಟಾ ಲಿಂಗತ ಚಾ಼ಲಾನೆ ಛೊಡಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ತೆನೈಸೊ ತೆ ಯಕ್ಲೊಜ಼ ಕ್ಹರಿನೊ ಕ್ಹುದಾ ವ್ಹೈ ಕವಾನು ತೆ ತಿನಾ ಚೊ಼ಕಾ ಕಾಮೊಕ್ಹು ದೆಕಾಡಾಡೊಸ. ತೆ ತುಮೊನೆ ಹಬಾಳಮಾತೊ ಪಾನಿ ತುಮಾರಾ ಅನ್ನನಾ ಹುತಿ ಹಮೆಶಾಬಿ ಸುಗ್ಗಿ ಕಾಲ ದಿನ್ನ ತುಮಾರಾ ಮನಸೊ ಖುಶಿಕ್ಹು ಭರಾಡೊಸ\" ");
INSERT INTO sle_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ಪೌಲಾ ಬಾರ್ನಬ ಅಕ್ಲು ಕ್ಹಾರು ಕದ್ಯಾ ತುಬಿ ಯಜ್ಞ ದಿನ್ನ ಆರಾಧನಾ ಕರೆ ನೈಸೊ ಮನಕ್ಹೊನೆ ಹುಬ್ರಾಡಾನೆ ಘನ್ನಾ ಕೊಶಿಶ ಕರು ಲಾಗ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ಪಾಚಾ಼ತಾ ದಕ್ಹಾ ಯೆಹುದಿಯೊ ಅಂತಿಯೊಕ್ಯತಾ ವರಿ ಇಕೊನಿಯತಾ ಐನ ಪೌಲಾನೆ ವಿರುದ್ದ ಮನಕ್ಹೊನೆ ಭಡಕೈನ ಪೌಲಾನೆ ದಗ್ಡಾ ನಾಕಿನ, ತೆ ಮರ‍್ಯೊ ಕೈನ ತಿಳ್ದಿಲಿನ ಗಾಮತಾ ಭಾರಾ ಜಗ್ಗಿನ ಕಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ತೆನೈಸೊ, ಯೆಸುನಾ ಶಿಷ್ಯಾ ತಿನಾ ಸುತ್ತೆ ಆತಾಮಾ ತೆ ಉಟಿನ ಗಾಮಮಾ ಗಯೊ. ಮರ್ನಾ ದಿನ್ನೆ ತೆ ವರಿ ಬಾರ್ನಬ ದರ್ಬೆ ಗಾಮನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ಪೌಲಾ ಬಾರ್ನಬ ದರ್ಬೆ ಗಾಮಮಾಬಿ ಸುವಾರ್ತೆ ಕದ್ಯಾ. ಘನ್ನಾ ಮನಕ್ಹೊ ಯೆಸುನಾ ಶಿಷ್ಯಾ ಥಯಾ. ಪೌಲಾ ಬಾರ್ನಬ ಲುಸ್ತ್ರ, ಇಕೊನಿಯ ವರಿ ಅಂತಿಯೊಕ್ಯ ಗಾಮೊಯೆ ಫರಿನ, ");
INSERT INTO sle_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ಯೆಸುನಾ ಶಿಷ್ಯಾವೊನೆ ಘಟ್ಟ ಕರಿನ, ಬರೊಕ್ಹಾಮಾ ಘಟ್ಟ ಥೈನ ರ‍್ಹವಾನೆ ತ್ಯುನೊನೆ ಪ್ರೊತ್ಸಾಹ ಕರ‍್ಯಾ\"ಹಮೆ ಕ್ಹುದಾನಿ ರಾಜ್ಯನೆ ಘನ್ನಾ ತ್ರಾಸೊನಾ ಮುಲಕ ಜಾ಼ವಾನಾ ಛೆ \"ಕೈನ ಬೊದನೆ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ಪೌಲಾ ಬಾರ್ನಬ ಹರ ಯಕ್ಕ ಸಭೆನೆ ಮ್ಹೊಟಾವೊನೆ ಇನಿ ಲಿದ್ಯಾ. ತ್ಯುನೆ ಎ ಮ್ಹೊಟಾವೊನಾ ಹುತಿ ಉಪಾಸ ರ‍್ಹೈನ ಪ್ರಾಥನಾ ಕರಿನ ತ್ಯುನೊನೆ ಪ್ರಭುನಾ ಹತ್ಮಾ ವಪ್ಸಿನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ಪೌಲಾ ಬಾರ್ನಬ ಪಿಸಿದಿ ಗಾಮತಾ ಪಾಂಪಿಲಿಯ ಗಾಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ತ್ಯುನೆ ಕ್ಹುದಾನಿ ಸಂದೆಶನೆ ಪೆರ್ಗ ಗಾಮಮಾ ಬೊದನೆ ಕರಿನ, ತ್ಯಾಂತಾ ಅತ್ತಾಲಿಯ ಗಾಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ತ್ಯಾಂತಾ ತ್ಯುನೆ ಸಿರಿಯಾಮಾ ಅಂತಿಯೊಕ್ಯನೆ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ಹಜು಼ನ ಲಕ್ಕಾ ಕರಿನ ಕ್ಹರಾಯಲ ಸೆವಾನಾ ಕಾಮನಾ ಹುತಿ ಕ್ಹುದಾನಾ ಹತ್ಮಾ ವಪ್ಸಿನ ದಿದಲವಾಲಾ ಎ ಗಾಮನಾ ವಿಶ್ವಾಸಿಯೊಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ಪೌಲಾ ಬಾರ್ನಬ ನ್ಹ್ಯಾ ಆಯಲ್ಪರ, ಸಭೆವಾಲಾ ಕ್ಹಾರಾವೊನೆ ಮಳೈನ, ಕ್ಹುದಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊನಾ ಹುತಿ ತ್ಯುನೊನೆ ಕದ್ಯಾ. ವರಿ \"ಬಿಜಾ಼ ಜನಾಂಗವಾಲಾಬಿ ಬರೊಕ್ಹೊ ಕರೆ ಲಿಂಗತ ಕ್ಹುದಾ ಬಾಕಲ ಕಾಡ್ಯೊಸ\" ಕೈನ ತಿಳ್ಸಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ತ್ಯಾ ಪೌಲಾ ಬಾರ್ನಬ ಶಿಷ್ಯಾವೊನಾ ಕ್ಹಾತೆ ಘನ್ನಾ ದಿನ್ನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ಪಾಚಾ಼ತಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ಯುದೆಯತಾ ಅಂತಿಯೊಕ್ಯನೆ ಆಯಾ\" ತುಮೆ ಸುನ್ನತಿ ನೈ ಕರಾಯಾಮ ತುಮೊನೆ ಬಿಡುಗಡೆ ಥಾತು ನೈ. ಸುನ್ನತಿ ಕರೈಲ್ಯು ಕೈನ ಮೊಶೆ ಕದ್ಯೊಸ \"ಕೈನ ತ್ಯುನೆ ಯೆಹುದಿಯೊ ನೈ ರ‍್ಹಯಲ ವಿಸ್ವಾಸಿಯೊನೆ ಉಪದೆಶ ಕರಾನು ಶುರು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ಪೌಲಾ ಬಾರ್ನಬ ಎ ಉಪದೆಶನೆ ತ್ಯುನಾ ವಿರುದ್ದ ದೆಕಾಡಿನ ತ್ಯುನಾ ಕ್ಹಾತೆ ವಾದ ಕರ‍್ಯಾ. ಎ ಸಮಸ್ಯಾನಾ ಹುತಿ ಅಪೊಸ್ತಲೊನಾ ಕ್ಹಾತೆ ವರಿ ಬಿಜಾ಼ ಶಾನಾವೊನಾ ಕ್ಹಾತೆ ಚರ್ಚಾ ಕರಾನೆ ಪೌಲಾ ಬಾರ್ನಬನೆ ವರಿ ಬಿಜಾ಼ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಯೆರುಸಲೆಮೆ ವಳಾವಾನೆ ಸಭೆ ಮಳಾನೆ ಫೈಸ್ಲೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ತಿನಾಲಿಂಗತ ಸಭೆವಾಲಾ ಇವ್ನೊನೆ ಸಭೆ ವಳೈಯು. ಇವ್ನೆ ಫೆನಿಶ್ಯ ವರಿ ಸಮಾರ್ಯ ವಾಟತಾ ಗಯಾ. ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊ ಕ್ಹರಿನೊ ಕ್ಹುದಾ ಕನ ಫರಲನಾ ಹುತಿ ಎ ಗಾಮೊಮಾ ಕದ್ಯಾ. ಎ ಐಕಿನ ಭಾಯೊನೆಬಿ ಘನ್ನಿ ಖುಶಿ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ಪೌಲಾ ಬಾರ್ನಬ ವರಿ ಬಿಜಾ಼ ಯೆರುಸಲೆಮ ಮುಟ್ಯಾ. ಅಪೊಸ್ತಲೊ, ಶಾನಾ ವರಿ ಸಭೆವಾಲಾ ಇವ್ನೊನೆ ಸ್ವಾಗತ ಕರ‍್ಯಾ. ಕ್ಹುದಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ ಕರಲ ಕ್ಹಾರಾ ಕಾಮೊನಾ ಹುತಿ ಪೌಲಾ ಬಾರ್ನಬ ವರಿ ಬಿಜಾ಼ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ಯೆರುಸಲೆಮಮಾ ರ‍್ಹಯಲ ವಿಶ್ವಾಸಿಯೊಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಫರಿಸಾಯರೊನಾ ಗುಂಪನೆ ಮಳಲವಾಲಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಉಟಿನ ಹುಬ್ರೈನ, ಯೆಹುದಿಯೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ವಿಶ್ವಾಸಿಯೊ ಸುನ್ನತಿ ಕರೈಲಿವ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥೌ ಕೈನ ಅಪೆ ತ್ಯುನೊನೆ ಕೌ \"ಕೈನ ");
INSERT INTO sle_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ಪಾಚಾ಼ತಾ ಅಪೊಸ್ತಲೊ ವರಿ ಶಾನಾ ಎ ಸಮಸ್ಯಾನೆ ಪರಿಕ್ಷಾ ಕರಾನೆ ಮಳಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ಘನ್ನಿ ಚರ್ಚಾ ಥೈ. ಪಾಚಾ಼ತಾ ಪೆತ್ರಾ ಉಟಿನ ಹುಬ್ರೈನ ತ್ಯುನೊನೆ\"ಮಾರಾ ಭಾಯೊ, ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹಯಲ ತಿಮ್ಮ, ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊನೆ ಸುವಾರ್ತೆ ಕವಾನಾ ಹುತಿ ತುಮಾರಾ ವಚ್ಮಾ಼ತೊ ಕ್ಹುದಾ ಮನೆ ಘನ್ನಾ ದಿನ್ನಾ ಪಾಚೊ಼ ಇನಿಲಿದ್ಯೊ. ತ್ಯುನೆ ಮಾರಾಕ್ಹು ಸುವಾರ್ತೆ ಐಕಿನ ಬರೊಕ್ಹೊ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ವಿಚಾರೊ ಗ್ವತ್ತ ರ‍್ಹಯಲ ಕ್ಹುದಾ ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊನೆ ಸ್ವಿಕಾರ ಕರಿಲಿದ್ಯೊ. ಕ್ಹುದಾ ಹಮೊನೆ ಪವಿತ್ರ ಆತ್ಮಾ ದಿದಲ ಲಿಂಗತಜ಼ ತ್ಯುನೊನೆಬಿ ಪವಿತ್ರ ಆತ್ಮಾ ದಿನ್ನ ಎ ಕ್ಹರಿ ದೆಕಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ಕ್ಹುದಾ ದೃಶ್ಟಿಮಾ ತ್ಯುನೊನೆಬಿ ಹಮೊನೆಬಿ ಕಯು ಫರಕ ನತ್ತಿ. ತ್ಯುನೆ ಬರೊಕ್ಹೊ ಕರಲ್ಪರ, ಕ್ಹುದಾ ತ್ಯುನಾ ಮನಸೊ ಶುದ್ಧ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಯೆಹುದಿಯೊ ನೈಸೊವಾಲಾ ಭಾಯೊನಾ ಖಾಂದಾನಾ ಉಪ್ಪರ ವಜ಼್ಜು ಕಾ ಘಾಲೊಶಿ? ತುಮೆ ಕ್ಹುದಾನೆ ಶಿಟ್ಟ ಕರು ಕೈನ ಕೊಶಿಶ ಕರಾಡಾಸು? ಹಮೊನೊ ರ‍್ಹಂದೆ ಹಮಾರಾ ಪಿತೃನೆ ರ‍್ಹಂದೆ ತೆ ವಜ್ಜು ಉಚಾವಾ ವರಕ್ಹು ತಾಕತ ನ್ಹೊತಿ! ");
INSERT INTO sle_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ತಿನಾಹುತಿ ಹಮೆ ರ‍್ಹಂದೆ ತ್ಯುನಾಹುತಿ ರಕ್ಷಣೆ ಹೊಂದಾನಾ ಹುತಿ ಪ್ರಭು ಥಯಲ ಯೆಸುನಾ ಮರಗಾಕ್ಹು ಕೈನ ಹಮೆ ನಂಬ್ಯೆಸ! ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ತೆಳಾಮಾ ಕ್ಹಾರಿ ಸಭಾ ಗಪ ವ್ಹತ್ತಿ. ತ್ಯುನೆ ಪೌಲಾ ವರಿ ಬಾರ್ನಬನೆ ಕಾನ ದಿನ್ನ ಐಕ್ಯಾ. ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊನಾ ವಚಾಮಾ ಕ್ಹುದಾ ತಿನಾ ಮುಕಾಂತರ ಕರಲ ಕ್ಹಾರಾ ಅದ್ಭುತ ಕಾಮೊ ವರಿ ಸುಚಕ ಕಾಮೊನಾ ಹುತಿ ಪೌಲಾ ಬಾರ್ನಬ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ತೆನೈಸೊ ಯಾಕೊಬ, ಮಾರಾ ಭಾಯೊ ಮನೆ ಕಾನ ದಿನ್ನ ಐಕೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊ ಕ್ಹುದಾ ತಿನಿ ಮಯಾ ಕಿಮ್ಮ ದೆಕಲಾಡ್ಯೊ ಸಿಮೊನ ಹಮನೊನೆ ತಿಳಸಾಯೊ ಪೈಲಾಜ ಹಮನಾಜ, ಕ್ಹುದಾ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊನೆ ಮಳೆಲಿದ್ಯಾಸ. ತ್ಯುನೊನೆ ತ್ಯುನಾ ಮನಕ್ಹೊ ವ್ಹೈ ಕೈನ ಕರಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ಪ್ರವಾದಿಯೊನಾ ವಾತೊಬಿ ತಿನೆ ಸಾಮರಸ್ಯ ಥೈಯುಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ತೆ ಥಯಲಪರ ಅಪೆ ಪಾಚಾ಼ ಪ್ಹರ‍್ಯಾ. ಮಿ ದಾವಿದನು ಘರ ವರಿ ಭಾಂದೆಯೆಸ ತೆ ಪಡಿ ಗಯುಸ. ತಿನಾಹುತಿ ತುಟಿ ಗಯೆಲ ತಿನು ಘರನಾ ತುಕಡಾ ಮಿ ವರಿ ಯಕ್ಕ ಕರುಸ. ಮಿ ತಿನು ಘರ ನವು ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ತೆನೈಸೊ ಬಿಜಾ಼ ಮನಕ್ಹೊ ಪ್ರಭುನಾ ಹುತಿ ಹುಡಕಸ. ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ವರಿ ಮಾರಾ ಮನಕ್ಹೊ ಥೈಯಾಸ. ಪ್ರಭು ಯೆ ಕದ್ಯೊಸ. ತೆ ಕ್ಹಾರಾ ಕಾಮೊ ಕರಾಲೊ ತೆಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ಪೈಲಾತೊಜ ಯೆ ಕ್ಹಾರಾ ಕಾಮೊ ತಿಳಸಾಡೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ತಿನಾಹುತಿ, ಕ್ಹುದಾ ಕನ ಫರಿನ ಯೆಹುದಿಯೊ ನೈಸೊ ಭಾಯೊನೆ ಅಪೆ ತರಾಸ ದ್ಯುನೈ. ");
INSERT INTO sle_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ತಿನಾಹುತಿ ಅಪೆ ತ್ಯುನೊನೆ ಯಕ್ಕ ಪತ್ರ ಲಿಕಿನ ತೆ ವಿಷಯೊ ಕ್ಹಾರಾ ತಿಳಸಯೆ ಮುರ್ತಿನೆ ಚಡಾಯೆಲ ಅನ್ನ ಖಾವೊ ನಕೊ. ತೆ ಅನ್ನ ಅಶುದ್ಧ ವ್ಹೈ. ಕೈಯುಜ ಲೈಂಗಿಕ ಪಾಪ ಕರೊ ನಕೊ. ರಗತ ಖಾವೊ ನೈಕೊ. ನಡ್ಡಿ ಚಿಕಲಿನ ಜಾನವರೊನು ಮಾಕ್ಹ ಕ್ಹಾವೊ ನೈಕೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ತ್ಯುನೆ ತೆ ಕ್ಹಾರು ಕರು ನೈ. ಕಾಕದ್ಯಾಮ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನೆ ಬೊಧಿಸ ಕರಲ ಮನಕ್ಹೊ ಹರಯಕ್ಕ ಗಾಮ್ಮಾ ಹಜುಬಿ ಛೆ. ಘನ್ನಾ ವರಕ್ಹತ್ತಾ ಹರಯಕ್ಕ ಸಬ್ಬತ ದಿನಮಾ ಮೊಶೆನಾ ವಾತೊ ಒದತ್ತಾ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ತೆಳಾಮಾ ಅಪೊಸ್ತಲೊ, ಸಭೆನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ವರಿ ಕ್ಹಾರಿ ಸಬೆನಿ ಇಜಾಜತ ಲಿನ ತ್ಯುನಾಮಾ ದಕ್ಹಾಜ಼಼ನಾ ವೊನೆ ಇನಿಲಿನ ಪೌಲಾ ವರಿ ಬಾರ್ನಬನಾ ಕ್ಹಾತೆ ದಕ್ಹಾ ಮನಕ್ಹೊ ಅಂತಿಯೊಕ್ಯನೆ ವಳಾವಾನು ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ನಿರ್ದಾರ ಕರ‍್ಯಾ. ತಿನಾಹುತಿ ಭಾಯೊಮಾ ಖಾಸ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾಲೊ ಬಾರಬನ ಕೈನ ಕವೈಲಿವಾಲಾ ಯುದನೆ ವರಿ ಶಿಲಾನೆ ಇನಿಲಿನ ");
INSERT INTO sle_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ತ್ಯುನಾ ಹತ್ತಮಾ ಪತ್ರನೆ ದಿನ ವಳಾಯಾ. ತೆ ಪತ್ರಮಾ ಅಮ್ಮ ಲಿಕ್ಯಾತ್ತಾ. ಭಾಯೊ, ಅಪೊಸ್ತಲೊ ವರಿ ಶಾನಾ, ಅಂತಿಯೊಕ್ಯ,ಸಿರಿಯ,ಕಿಲಿಕ್ಯ ರ‍್ಹವಾಲಾ ಯೆಹುದ್ಯ ನೈ ರ‍್ಹಯಲ ಭಾಯೊನೆ ನಮಸ್ಕಾರ. ");
INSERT INTO sle_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ಹಮಾರಾ ಸಮುದಾಯನಾ ತಮನೊ ಕನ ಆಯೆಲ ದಕ್ಹಾಜ಼಼ನಾ ತಮನೊನೆ ದಕ್ಹಾ ಸಂಗತಿಯೊ ಕವಾನಾಹುತಿ ತಮನೊನೆ ತ್ರಾಸನೆ ಘನು ಕರಿನ ತಮಾರಾಮಾ ಗಲಿಬಿಲಿ ಕರಾನಾಹುತಿ ಸುದ್ದಿ ಹಮನೊನೆ ಗ್ವತ್ತ ಥಯು. ತಿನಾಹುತಿ ಇಮ್ಮ ಕರಾನಾಹುತಿ ಹಮೆ ತ್ಯುನೊನೆ ಕದ್ಯಾನ್ಹೊತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ತಿನಾಹುತಿ ಹಮೆಕ್ಹಾರಾ ದಕ್ಹಾ ಜ಼ನಾ ಸರ್ವಾನುಮತಕ್ಹು ಇನಲಿನ ತಮನೊ ಕನ ವಳಾವಾನೆ ಫೈಸಲೊ ಕರ‍್ಯಾ. ಮಾರಾ ಮಯಾನಾ ಭಾಯೊ ಥಯಲ ಬಾರ್ನಬ ವರಿ ಪೌಲಾನಾ ಕ್ಹಾತೆ ತ್ಯುನೆ ಆವಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ಬಾರ್ನಬ ವರಿ ಪೌಲಾ ಹಮಾರೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಸೆವಾನಾ ಹುತಿ ಹಮಾರಾ ಜ಼ಲ್ಮೊ ದಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ತಿನಾಹುತಿ ಹಮೆ ಯುದಾನೆ ವರಿ ಸಿಲನೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ವಳಾಯೊಸ. ಹೆಟ್ಟಾ ಮ್ಹೆಲೆಲ ಸಂಗತಿಯೊ ಕ್ಹಾರಾ ತ್ಯುನೆ ತಮನೊನೆ ತಿಳಸಾವಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ತಮನೊನೆ ಹಜು ಘನು ವಜ್ಜು ರ‍್ಹವಾಂದೆ ಕೈನ ಪವಿತ್ರಾತ್ಮನಿ ನಿರ್ಧಾರ ತಿನೆ ಹಮೆ ಒಪ್ಪಿಲಿದ್ಯಾ. ತಮೆ ತೆ ನಿಯಮೊನೆ ಯಕ್ಕಜ಼ ಅನುಸರಿಸಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ಅನಾಕ್ಹು ಹೆಚ್ಚಗಿ ವಜು ತಮಾರಾ ಉಪ್ಪರ ಉಚೈವು ನೈ ಕೈನ ಪ್ರವಿತ್ರಾತ್ಮನೆ ಬಿ ಅಪನೊನೆ ಬಿ ಚೊ಼ಕು ದಿಕ್ಹು;ತಮೆ ಹುಶಾರಕ್ಹು ರ‍್ಹೈನ ತ್ಯುನಾ ಕ್ಹಾತೆ ನೈ ಗಯಾಮಾ ತಮ್ಮನೊನೆ ಬಿ ಚೊ಼ಕು ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ತ್ಯುನೆ ಅಮ್ಮ ಅಪ್ಪಣೆ ಲಿನ ಅಂತಿಯೊಕ್ಯನೆ ಐನ ಸಭೆನೆ ಮಳೈನ ತೆ ಪತ್ರನೆ ತ್ಯುನೊನೆ ಒಪ್ಪಸ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ತ್ಯುನೆ ಒದಿನ ತ್ಯುನಾಕ್ಹು ಧೈರ್ಯ ಲಿನ ಕ್ಹುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ಯುದಾ, ಸಿಲಾ ತ್ಯುನೆಜ ಪ್ರವಾದಿಯೊ ಥಯಲಕ್ಹು ಭಾಯೊನೆ ಘನ್ನಾ ವಾತೊಕ್ಹು ಕೈನ ಘಟ್ಟ ಕರಿನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ತ್ಯಾ ದಕ್ಹಾ ದಿನ ರ‍್ಹಯೆಲ ಪರ ತ್ಯುನೊನೆ ವಳಾಯೆಲವಾವೊ ಕನ ವರಿ ಜೌಕೈನ ಭಾಯೊಕ್ಹು ಅಪ್ಪಣೆ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ತಿನಾಹುತಿ ಸಿಲಾನೆ ತ್ಯಾಜ ರ‍್ಹವಾನು ಚೊ಼ಕುಜ ವ್ಹೈ ಕೈನ ದಿಕ್ಹು. ");
INSERT INTO sle_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ತಿನಾಹುತಿ ಪೌಲಾ ವರಿ ಬಾರ್ನಬ ಅಂತಿಯೊಕ್ಯಮಾ ಹುಬ್ರೈನ ಬಿಜಾ಼ ದಕ್ಹಾಜ಼಼ನಾವೊನಾ ಕ್ಹಾತೆ ಉಪದೆಶ ಕರತ್ತಾ ಕರ್ತಾ ವಾಕ್ಯ ಕವಾನು ಸುವಾರ್ತೆ ಕತ್ತಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ದಕ್ಹಾ ದಿನೊ ಥಯಲ ಪರ ಪೌಲಾ ಬಾರ್ನಬ; ಅಪೆ ಕರ್ತಾನಿ ವಾಕ್ಯ ಕೈನ ಕ್ಹಾರಾ ಗಾಮ್ಮೊನೆ ವರಿ ಗೈನ ತ್ಯಾ ರ‍್ಹಯಲ ಭಾಯೊ ಕಿಮ್ಮ ಛೆ ಕೈನ ದೆಕಾನೆ ಆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ತಿನಾಹುತಿ ಬಾರ್ನಬ ಮಾರ್ಕ ಕವೈಲಿವಾಲೊ ಯೊಹಾನನೆ ");
INSERT INTO sle_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ತ್ಯುನಾ ಕ್ಹಾತೆ ಬಲೈಲಿನ ಜೌವು ಕತ್ತಾಮಾ ಪೌಲಾ; ಹಮಾರಾ ಕ್ಹಾತೆ ಸವೆ ನೈಸೊ ಪಂಫುಲ್ಯಮಾ ಹಮ್ಮನೊನೆ ಚ್ಹೊಡಿಪಾಡೆಲ ಬಲೈ ಲೌವು ಕೈನ ಜಾ಼ವಾನಾ ಹುತಿ ಚೊ಼ಕು ನ್ಹವೈ ಕೈನ ಶೆ ಕರಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ತೆ ವಿಷಯಮಾ ಘನ್ನು ವಾಗ್ವಾದ ಥಯಲಕ್ಹು ತ್ಯುನೆ ಯಕ್ನಾ ಯಕ್ಕ ಲಡಾಡಾತ್ತಾ. ಬಾರ್ನಬ ಮಾರ್ಕನೆ ಬಲೈಲಿಂಗೈನ ಸಮುಂದರನಿ ವಾಟತ್ತಾ ಕುಪ್ರದ್ವಿಪನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ಪೌಲಾ ಸಿಲಾನೆ ಇನಲಿನ ಭಾಯೊಕ್ಹು ಕರ್ತಾನಾ ಕೃಪಾ ಆಶ್ರಮನೆ ವಳೈ ಲಿವಾಲೊ ಥೈನ ತ್ಯಾತ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ಗೈನ ಸಿರಿಯಾ ವರಿ ಕಿಲಿಕ್ಯ ಸಿಮೆಮಾ ಜಾತ್ತಾ ಕ್ಹಾರಾ ಸಭೆನೆ ಘಟ್ಟ ಕರಾಡಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ಪೌಲಾ ದರ್ಬೆ ವರಿ ಲುಸ್ತ್ರ ಗಾಮೊಯೆ ಗಯೊ. ತಿಮೊಥಿ ಕವಾಲೊ ಕ್ರಿಸ್ತನೊ ಶಿಷ್ಯೊ ತ್ಯಾ ವ್ಹತ್ತೊ. ತಿನಿ ಯಾಬಿ ವಿಸ್ವಾಸಿ ವ್ಹತ್ತಿ. ತಿನೊ ಬಾ ಗ್ರಿಕವಾಲಾ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ಲುಸ್ತ್ರ ವರಿ ಇಕೊನಿಯ ಗಾಮ್ನಾ ವಿಸ್ವಾಸಿಯೊ ತಿಮೊಥಿನೆ ಮರ್ಯಾದಿ ದೆತಾತಾ; ವರಿ ತಿನಾ ಹುತಿ ಚೊ಼ಕುಜ಼ ಕತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ಪೌಲಾ ತಿಮೊಥಿನೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ಬಲೈಲಿಂಜಾ಼ವಾನೆ ಮನಸ ಕರ‍್ಯೊ. ತೆನೈಸೊ ತಿಮೊಥಿನೊ ಬಾ ಗ್ರಿಕವಾಲೊ ವ್ಹೈ ಕೈನ ತ್ಯಾನ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಗ್ವತ್ತ ವ್ಹತ್ತು. ತಿನಾಹುತಿ ಪೌಲಾ ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊನೆ ಮೆಚ್ಸಾನಾ ಹುತಿ ತಿಮೊಥಿನೆ ಸುನ್ನಿತಿ ಕರಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ತೆ ಥಯಲ್ಪರ ಪೌಲಾ ವರಿ ತಿನಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ಬಿಜಾ಼ ಗಾಮೊಯೆ ಗಯಾಸ, ಯೆರೊಸೆಲಿಮಾನಾ ರ‍್ಹಯಲ ಅಪೊಸ್ತಲೊ ವರಿ ಶಾನಾ ಮನಕ್ಹೊ ತ್ಯುನೊನೆ ವಿಧೆಯ ಥೌ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ಇನಾಹುತಿ ಸಭೆ ಬರೊಕ್ಹೊಮಾ ತಾಕತವರ ಥಯಾ ವರಿ ಸಂಖ್ಯಾಮಾ ದಿನೆ ದಿನೆ ಜಾಸ್ತಿ ಥಾವಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ಪೌಲಾ ವರಿ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ಫ್ರಿಜಿಯಾ ವರಿ ಗಲಾತ್ಯ ಪ್ರಾಂತ್ಯನಾ ಮುಲಕ ಗಯಾ. ಎಶ್ಯಾ ಸಿಮೆಮಾ ಸುವಾರ್ತೆ ಕೌ ನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾ ತ್ಯುನೊನೆ ತರ್ಬ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ಪೌಲಾ ತಿಮೊಥಿ ಮುಸಿಯಸಸ ನಾಡನಾ ನಜಿಕ ಗಯಾ. ತ್ಯುನೆ ಬಿಥೊನಿಯಾ ನಾಡಮಾ ಜೌ಼ ಕೈನ ವ್ಹತ್ತಾ. ತೆನೈಸೊ ಯೆಸುನಿ ಆತ್ಮಾ ತ್ಯುನೊನೆ ತ್ಯಾ ಜೌ಼ ನೈಸೊ ತಡದಿ. ");
INSERT INTO sle_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ತಿನಾಹುತಿ ತ್ಯುನೆ ಮುಸಿಯಸಸ ನಾಡಪರ್ತಾ ಶಿದಾ ತ್ರೊವಾ ಗಾಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ತೆ ದಿನ್ನಾ ರಾತೆ ಪೌಲಾನೆ ಯಕ್ಕ ದರ್ಶನ ಥಯು. ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾಮ ");
INSERT INTO sle_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ಪೌಲಾನೆ ಎ ದರ್ಶನ ಥಯಲ ತೆಳಾಮಾಜ಼ ತೆ ಮನಕ್ಹೊನೆ ಚೊ಼ಕು ಸಂದೆಶ ಕವಾನೆ ಕ್ಹುದಾ ಹಮೊನೆ ಬಲಾಯೊಸ ಹಮೆ ತಿಳ್ದಿಲಿನ ಮೆಕೆದೊನಿಯಾನೆ ಜ಼ವಾನೆ ತಯ್ಯಾರ ಥಯಲ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ಹಮೆ ತ್ರೊವಾಮಾ ಹಡಗೊ ಚ಼ಡಿನ ಸಮುಂದರಮಾತಾ ಸಿದಾ ಐನ ಸಮೊಥ್ರಾನೆ ಆಯಾ. ಮರ್ನಾ ದಿನ್ನೆ ನೆಯಪೊಲ ಮುಟ್ಟಿನ ");
INSERT INTO sle_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ತ್ಯಾಂತಾ ಮೆಕೆದೊನಿಯಾನೆ ಖಾಸ ಗಾಮ ರ‍್ಹಯಲ ಪಿಲಿಪ್ಪಿನೆ ಆಯಾ. ಎ ರೊಮವಾಲಾವೊನೆ ಪ್ರವಾಸನೆ ಜ಼ಗಾ ಥಯುಸ. ");
INSERT INTO sle_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ನದಿನಾ ದಂಡಿಯೆ ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ಪ್ರಾಥನಾ ಕರಾನಿ ಜ಼ಗಾ ಛೆ ಕೈನ ತಿಳ್ದಿನ ಸಬ್ಬತ ದಿನ್ಮಾ ಗಾಮ್ನಾ ಭಾರಾ ಗೈನ ತ್ಯಾ ಮಳಿನ ಆಯಲ ಬಾಕ್ಡಿಯೊನಾ ಕ್ಹಾತೆ ಬೈಟಿನ ಬೊಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ಹಮಾರಿಯೊ ವಾತೊ ಐಕಲವಾಲಾವೊಮಾ ಲುದ್ಯ ಕವಾಲಿ ಬಾಕ್ಡಿ ವ್ಹತ್ತಿ. ತೆ ಜಾ಼ಂಬ್ಳಾನೊ ಕಲರ್ನು ವಣ್ಣಾ ಇಕ್ಕಾಲಿ ಥುವತೈರ ಕವಾನಿ ಗಾಮವಾಲಿ ಕ್ಹುದಾನಿ ಪೌಲಾ ಕವಾನಿಯೊ ವಾತೊನೆ ಧ್ಯಾನ ದಿವಾಹುತಿ ಕರ್ತಾ ತಿನೆ ಮನಸ ಖುಲ್ಲಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ತಿನಾ ಘರವಾಲಾ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದಲಪರ ತೆ ಕರ್ತಾನೆ ಬರೊಕ್ಹೊ ಕರಾಲಿ ವ್ಹೈ ಖಯನ ತುಮೆ ಮಾರಾ ಹುತಿತಿಳ್ದಿಲಿದಲ ರ‍್ಹವಾಮಾ ಮಾರಾ ಘರ್ಮಾ ಐನ ರ‍್ಹೌ ಕೈನ ಮಾಂಗಿಲಿನ ಹಮೊನೆ ವತ್ತಾಯ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ತೆ ತಯಲ್ಪರ ಪ್ರಾಥನಾ ಥಾವಾನಿ ಜ಼ಗಾಪರ ಅಪೆ ಜಾ಼ತಾಮಾ ಸಕ್ಣಾ ಕವಾಲಿ ಯಕ್ಕ ಹೆಣ ಮನಕ್ಹ ತ್ಯುನಾ ಕ್ಹಾಮಿ ಐ. ತೆ ಬಾಕ್ಡಿ ಸಕಾಣಾ ಕವಾಕ್ಹು ತಿನಾ ಮಾಲಕನೆ ಘನ್ನಿ ಆದಾಯಾ ಥಾತಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ಹಮೆ ಜಾ಼ತಾಮಾ ತೆ ಬಾಕ್ಡಿ ಹಮಾರಾ ಪಾಚಿ಼ ಐನ ಎ ಮನಕ್ಹೊ ಪರಾತ್ಪರ ಥಯಲ ಕ್ಹುದಾನಾ ಸೆವಕೊ ವ್ಹೈ; ತುಮೊನೆ ರಕ್ಷಣೆನು ಮಾರ್ಗ ದೆಕಾಡಾತಾ ರ‍್ಹವಸ. ಕೈನ ವದ್ರಿನ ಕತಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ತೆ ಘನ್ನಾ ತಿನತಿಬಿ ಇಮ್ಮಜ಼ ಕರತಿ ರ‍್ಹಯಲ ಹುತಿ ಪೌಲಾ ಘನ್ನೊ ಬೆಜ್ಜಾರ ಥಯೊ. ತಿನಾ ಪಾಚೊ಼ ಫರಿನ ತಿಮಾ ರ‍್ಹಯಲ ಕೆಟ್ಟ ಆತ್ಮಾನೆ; ತಿನೆ ಛೊಡಿನ ಜಾ಼ ಕೈನ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಪರ ತುನೆ ಆಗನ್ಯಾ ದ್ಯುಸ. ಕದ್ಯೊ. ತೆಳಾಮಾಜ಼ ತೆ ಕೆಟ್ಟ ಆತ್ಮಾ ತಿಮಾತಿ ಚೊ಼ಡಿನ ಗೈಪಡಿ. ");
INSERT INTO sle_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ತಿನಾ ಮಾಟಿಯೊ ತ್ಯುನಿ ಆಸ್ತಿನು ಕೈದಾನು ತಪ್ಪೆಲ ನ್ಹವೈ ಕೈನ ತಿಳ್ದಿನ ಪೌಲಾನೆ ವರಿ ಸಿಲಾನೆ ಧರಿನ ಬಾಜಾರಮಾ ಅದಿಕಾರಿಯೊ ಕನ ಯಳದಿಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ತ್ಯುನೊನೆ ಅದಿಕಾರಿಯೊ ಕನ ಲೈನ ;ತೆ ಮನಕ್ಹೊ ಹಮಾರಾ ಗಾಮ್ನೆ ಘನ್ನಾ ಹಾಳ ಕರಾಡಾಸ; ");
INSERT INTO sle_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ತ್ಯುನೆ ಯಹುದ್ಯೊ ಥೈನ ರೊಮವಾಲಾ ಥಯಲ ಹಮೆ ಅವಲಂಬನೆ ಕರಿನ ನೈ ಕರಾನಾ ಪದ್ದತಿಯೊ ನೈ ಕರು ಕೈನ ಕವಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ತೆಳಾಮಾ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಗುಂಪ ಕರಿನ, ತ್ಯುನೊನೆ ವಿರುದ್ದ ಥೈನ ಮಳಿನ ಉಟ್ಯಾ. ವರಿ ಅದಿಕಾರಿಯೊ; ತ್ಯುನಾ ವಣ್ಣಾ ಫಾಡಿನ, ಕಾಡಿನ, ಬಾರಕೊಲಕ್ಹು ಮಾರು ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ತ್ಯುನೊನೆ ಘನ್ನಾ ಮಾರೊ ಕ್ಹಲೈನ ಜೆಲಮಾ ಘಾಲಿನ, ತ್ಯುನೊನೆ ಘನಿ ಹುಶಾರಕ್ಹು ಕೈದು ಕೈನ ಜೆಲನಾ ಮಾಲಿಕನೆ ಆಜ್ಞೆ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ತೆ ಅಪ್ಪಣೆ ಹೊಂದಿನ ತ್ಯುನೊನೆ ಜೆಲನಾ ಮ್ಹೈನಿ ಖೊಲಿಮಾ ಘಾಲಿನ ತ್ಯುನಾ ಹತ್ತೊ ಪಗೊನೆ ರಾಕ್ಹ ಭಾಂದಿನ ಬಿಗದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ಅರದಿ ರಾತೆ ಪೌಲ ವರಿ ಸಿಲಾ ಪ್ರಾರ್ಥನಾ ಕರ್ತಾಮಾ ಕ್ಹುದಾನೆ ಸ್ತುತಿನಾ ಗಿದ್ದೊ ಕವಾಡ್ಯಾತಾ; ಜೆಲಮಾ ರ‍್ಹಹೆಲವಾಲಾ ಕ್ಹಾರಾ ಲಕ್ಷ ದಿನ ಐಕಾಡಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ಯಕ್ಕದುಮ್ಮ ಮ್ಹೊಟು ಭುಕಂಪ ಥೈಯು; ಜೆಲನಾ ಗೊಡಿಯೊ ಹಲ್ಲಿಯೊ. ತೆಳಾಮಾಜ಼ ಬಾಕಲೊ ಕ್ಹುಲಿ ಗಯಾ, ಕ್ಹಾರಾವೊನಾ ಬೆಡಿಯೊ ಚ್ಹುಟಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ಜೆಲನೊ ಮಾಲಿಕ ನಿಂದರಕ್ಹು ಹುಶಾರ ಥೈನ ಜೆಲನಾ ಬಾಕಲೊ ಕ್ಹುಲಾನು ದೆಕಿ ಜೆಲಮಾ ರ‍್ಹಹೆಲವಾಲಾ ಕ್ಹಾರಾ ನ್ಹಾಟಿ ಗಯಾಸ ಕೈನ ಕೈಲಿನ ತಲವಾರಕ್ಹು ಆತ್ಮಹತ್ಯೆ ಕರಲಿವಾಡೊತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ತಿನಾಹುತಿ ಪೌಲಾ ಮ್ಹೊಟಿ ಆವಾಜಕ್ಹು ಅಡ್ಡಿನ ತಿನೆ ತು ಸುಜ಼ ಕರಲ್ಯು ನಕೊ,ಹಮೆ ಕ್ಹಾರಾ ಯ್ಹಾಜ ಛೆ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ತೆಳಾಮಾ ತೆ; ದಿವೊ ಲೌವು ಕೈನ ಅಡ್ಡಿನ ಮ್ಹೈ ಉಡಿನ ಬುಚುಕ್ಹು ಕಾಪತ್ತೊ ಪೌಲ ವರಿ ಸಿಲನಾ ಕ್ಹಾಮೊ ಅಡ್ಡ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ವರಿ ತ್ಯುನೊನೆ ಭಾರೊ ಬಲೈನ ಸ್ವಾಮಿಯೊ, ಹಮೆ ರಕ್ಷಣೆನಾ ಹುತಿ ಸು ಕರು ಕೈನ? ಪುಚ್ಚಾ಼ನೆ, ");
INSERT INTO sle_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ತ್ಯುನೆ ಕರ್ತಾ ಥಯಲ ಯೆಸುನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ,ತೆಳಾಮಾ ತು ರಕ್ಷಣೆ ಹೊಂದಶಿ, ತಾರಾ ಘರನಾ ಕ್ಹರಾ ರಕ್ಷಣೆ ಥಾವಸ ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ತಿನೆಬಿ, ತ್ಯುನಾ ಘರಮಾ ರ‍್ಹಹೆಲವಾಲಾ ಕ್ಹಾರಾವೊನೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ತಿಳಸೈನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ತೆಳಾಮಾ ತೆ ರಾತ್ತನಾ ತೆಜ಼ ಟೈಮ್ಮಾ ತ್ಯುನೊನೆ ಬಲೈಲಿನ ಗೈನ ತ್ಯುನಾ ದುಕೊ ಕ್ಹಾರಾ ನುಚಿನ ತೆಳಾಮಾ ತೆ ತ್ಯುನಾ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ಬಾಪ್ತಿಸ್ಮ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ತೆಳಾಮಾ ತ್ಯುನೊನೆ ತಿನಾ ಘರೆ ಬಲೈಲಿನ ಗೈನ ಅನ್ನ ಕ್ಹಲಾಯೊ ತೆ ವರಿ ತಿನಾ ಘರವಾಲಾವೊನಾ ಕ್ಹಾತೆ ಕ್ಹುದಾನೆ ನಂಬಿನ ಕ್ಹುಶಿ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ಪಾಟ ಥಯಲ ಪರ ಅಧಿಕಾರಿಯೊ; ತೆ ಮನಕ್ಹೊನೆ ಚ್ಹೊಡಿಪಾಡ ಕೈನ ಸಿಪಾಯೊನೆ ಕೈನ ವಳಾವೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ಜೆಲನೊ ಮಾಲಿಕ ತೆ ವಾತೊ ಕ್ಹಾರಾ ಪೌಲಾನೆ ಕವೊ;ಅಧಿಕಾರಿಯೊ ತಮನೊನೆ ಚ್ಹೊಡಿಪಾಡು ಕೈನ ವಳಾಯಾಸ,ತಿನಾಹುತಿ ಹಮ್ನಾ ತಮೆ ಸಮಾಧಾನಕ್ಹು ಜಾವೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ತಿನಾಹುತಿ ಪೌಲಾ ತ್ಯುನೊನೆ \"ಹಮನೊನೆ ಶಿಕ್ಷಾ ದಿವಾ ವರಕ್ಹು ಕೈಯುಜ ಅಪರಾದ ಹಮೆ ನತ್ತಿ ಕರ‍್ಯಾ. ತೆನೈಸೊ ಹಮೆ ರೊಮವಾಲಾ ವ್ಹೈ. ತೆನೈಸೊ ಹಮನೊನೆ ಮ್ಹೈನಾ ಮ್ಹೈ ಛಡಿಕ್ಹು ಮಾರ‍್ಯಾ ಲಗಡ್ಯಾ. ಜೆಲಮಾ ಘಾಲ್ಯಾ; ಹಮ್ನಾ ಗುಪ್ತಕ್ಹು ಹಮನೊನೆ ವಳೈಪಡುಸ ಕದ್ಯಾ? ನತ್ತಿ,ತೆ ಸಾಧ್ಯನತ್ತಿ. ನ್ಯಾಯಾಧಿಪತಿ ತ್ಯುನಾಕ್ಹು ತ್ಯುನೊ ಔ ಕೈನಹಮನೊನೆ ಬಿಡುಗಡೆ ಕರಾದೆ\" ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ಜವಾನೊ ತೆ ವಾತೊ ಕ್ಹಾರಾ ನ್ಯಾಯಾಧಿಪತಿನೆ ವರದಿ ಕರ‍್ಯಾ. ತ್ಯುನೊ ಪೌಲಾ ವರಿ ಸಿಲಾ ರೊಮನಾ ಪೌಲಾ ವ್ಹೈ ಕೈನ ಭುಚ಼ಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ತಿನಾಹುತಿ ತ್ಯುನೆ ಐನ ಮಾಫಿ ಮಾಂಗಿನ,ಜೆಲಮಾತ್ತಾ ಬಿಡುಗಡೆ ಕರಿನ ಗಾಮ್ಮ ಛೊಡಿನ ಜೌಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ಪೌಲಾ ವರಿ ಸಿಲ ಜೆಲಮಾತ್ತಾ ಗೈನ ಲಿಡಿಯಳನಾ ಘರೆ ಗಯಾ. ಭಕ್ತ ವಿಸ್ವಾಸಿಯೊನೆ ಸಂಧಿಸಿನ ತ್ಯುನೊನೆ ಪ್ರೊತ್ಸಾಹನಾ ವಾತೊ ಕೈನ ತ್ಯಾಂತ್ಯಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ಪೌಲ ವರಿ ಸಿಲ ಅಗಾ ಪ್ರಯಾಣ ಕರಿ ಅಂಪಿಪೊಲಿ ವರಿ ಅಪೊಲೊನ್ಯ ಕವಾನಾ ಗಾಮೊ ದಾಟಿನ ಥೆಸಲೊನಿಕನೆ ಆಯಾ. ತ್ಯಾ ಯಹುದ್ಯೊನಿ ಸಬಾಮಂದಿರ ವ್ಹತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ಪೌಲ ತಿನಿ ಪದ್ದತನಿಂತ ತ್ಯಾ ರಹೆಲ ಮನಕ್ಹೊಕನ ಗೈನ ತನ ಐತವಾರೊ ಕ್ಹುದಾನಾ ವಾತೊ ತ್ಯುನಾ ಕ್ಹಾತೆ ವಾದಸಿನ ");
INSERT INTO sle_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ತೆ ವಾಕ್ಯನು ಅರ್ಥ ತಿಳಸಾಯಾ. ಕ್ರಿಸ್ತ ತರಾಸ ಕ್ಹಯಿನ ಮರಿನ ಉಟಿನ ಆವಾನು ಜ಼ರುರತ ಛೆ ಕೈನ ಮಿ ತಮನೊನೆ ಪ್ರಸಿದ್ದಿಪಡಿಸಾನಾ ಹುತಿ ಯೆಸು ತೆ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಸ್ಥಿರಪಡಿಸ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ತಿಮಾ ದಕ್ಹಾಜ಼಼ನಾ ಕ್ಹುದಾನಾ ಭಕ್ತೊ ಥೈಯೆಲ ಗ್ರಿಕನು ಮ್ಹೊಟು ಗುಂಪ ವರಿ ಪ್ರಮುಖ ಬಾಕಡಿಯೊಮಾ ದಕ್ಹಜ಼ನಾ ವಾದಸಿನ ಪೌಲ ವರಿ ಸಿಲಾನೆ ಮಳೆಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ನಂಬೆಲವಾಲ ಯಹುದ್ಯೊ ಸಂಗಟ ಪಡಿನ ಬಾಜಾ಼ರಮಾ ಫರಾವಾಲಾ ದಕ್ಹಾಜ಼಼ನಾ ಪಾಲತು ಮನಕ್ಹೊನೆ ಬಲೈನ ಗುಂಪ ಕರಿನ ಗಾಮ್ಮಾ ಗದ್ದಲ ಕರಿನ ಪೌಲ ವರಿ ಸಿಲನೆ ಗಾಮಾನಾ ಸಬೆನಾ ಕ್ಹಾಮಾ ಲೌ ಕೈನೈ ತ್ಯುನೊನೆ ಹುಡಕತ್ತಾ ಯಾಸೊನಾ ಘರಕನ ಐನ ಮುಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ತ್ಯುನೆ ಮಳೆವಾಚಿ ಗಯೆಲುಕ್ಹು ತೆ ಮನಕ್ಹೊ ಭಾಯೊನೆ ಯಾಸೊನೆ ವರಿ ದಕ್ಹಾ ಮನಕ್ಹೊನೆ ಗಾಮಾನಾ ಅದಿಕಾರಿಯೊ ಕನ ಯಳ್ದಿನ ಲೈನ ದುನಿಯಾನೆ ಅಲೊಲ್ಲಕಲ್ಲೊಲ ಕರಲ ಮನಕ್ಹೊ ನ್ಹ್ಯಾಬಿ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ಯಾಸೊನ ತುನೊತೆ ಮಳೆಲಿದ್ಯೊತೊ, ತ್ಯುನೆ ಕ್ಹಾರಾಜ಼ನಾ ಯೆಸು ನಾಮನೊ ಬಿಜೆಕ್ಲೊ ರಾಜೊ಼ ಛೆಕೈನ ಚಕ್ರವರ್ತಿನಾ ಆಗನ್ಯೆ ವಿರುದ್ದ ಥೈನ ಚಾಲಾಡಾಸ ಕೈನ ವದರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ಗಾಮ್ಮವಾಲಾ ವರಿ ಗಾಮ್ಮನಾ ಅದಿಕಾರಿಯೊ ಆ ವಾತೊ ಐಕಿನ ಘಾಬ್ರಾ ಥೈಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ವಿಸ್ವಾಶಿಯೊನೆ ವರಿ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಜಾಮಿನ ಪರ ಛೊಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ತೆಳಾಮಾ ತೆ ಭಾಯೊ ರಾತಮಾ ಪೌಲಾ ವರಿ ಸಿಲಾನೆ ಬೆರೆಯೊನನೆ ಮೊಕ್ಲಾಯಾ. ತ್ಯುನೆ ತ್ಯಾ ಗೈನ ಯಹುದ್ಯೊನಾ ಸಬಾಮಂದಿರಮಾ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ತೆ ಸಬೆವಾಲಾ ಕ್ಹುದಾನಿ ವಾಕ್ಯನೆ ಸ್ವಚ್ಚ ಮನಸೆ ಒಪಿಲಿನ ತ್ಯುನೆ ಕದಲ ವಾತೊ ವ್ಹೈಸು ನ್ಹವೈ ಕೈನ ವಪಿಲಿವಾನಹುತಿ ದಿನ್ನೆಬಿ ಪವಿತ್ರ ಗ್ರಂಥ ಪರಿಕ್ಷಾ ಕರಾನಾ ಹುತಿ ತುನೆ ಥೆಸೆಲೊನಿಕ ಸಬೆವಾಲೊತಿ ಚೊ಼ಕಾ ವ್ಹತಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ತಿಮ್ಮ ರ‍್ಹತಾಮಾ ತ್ಯುನಾಮಾ ಘನ್ನಾ ಜ಼ನಾ ನಂಬ್ಯಾತಾ, ತೆನೈಸೊ ಕಾಮ ಕರಾಲಾ ಗ್ರಿಕನಾ ಬಾಕ್ಡಿಯೊಮಾ ದಾಣ್ಗಾಮಾ ಘನ್ನಾ ಜ಼ನಾ ನಂಬ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ವರಿ ಪೌಲಾ ಬೆರೆಯೊಮಾಬಿ ಕ್ಹುದಾನಿ ವಾಕ್ಯ ಪ್ರಸಿದ್ದಿಪಡಿಸಾನಾಹುತಿ ವರ್ತಮಾನಬಿ ಥೆಸೆಲೊನಿಕನಾ ಯಹುದಿಯೊನೆ ಗ್ವತ್ತ ಥಾತಾಮಾ ತ್ಯುನೆ ತ್ಯಾ ಐನ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಪ್ರಚೊದ ಕರಿನ ತಡಾಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ತೆಳಾಮಾ ಭಾಯೊ ಪೌಲಾನೆ ಸಮುಂದರ ಕನ ಜಾ಼ವಾನೆ ತಿನೆ ವೈಳೈನ ದಿದ್ಯಾ. ತೆಳಾಮಾ ಸಿಲಾ ವರಿ ತಿಮೊಥಿ ತ್ಯಾಜ಼ ಹುಬ್ರಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ಪೌಲಾನೆ ವಳೈಲವಾಲಾ ತಿನೆ ಅಥೆನೆತಕ ಬಲೈಲಿನ ಗಯಾ ಸಿಲಾ ವರಿ ತಿಮೊಥಿನೆ ಭೆಟಿ ಥಯಲ ಪರ ಭರನೆಜ ತಿಕನ ಆವಾನೆ ಅಪ್ಪಣೆ ಲಿನ ಪೌಲಾ ಕಂತೊ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ಪೌಲ ತ್ಯುನಾ ಹುತಿ ವಾಟ ದೆಕತಾ ಟೆಮಾ ತೆ ಗಾಮ್ಮಾ ತ್ಯಾ ತ್ಯಾ ಮೊರ್ತಿಯೊ ದೆಕಿನ ತಿನು ಮನಸ ಬಳಾಡ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ತಿನಾಹುತಿ ತೆ ಸಬಾಮಂದಿರಮಾ ಯಹುದ್ಯೊ ವರಿ ಭಕ್ತನಾ ಕ್ಹಾತೆ ವರಿ ತ್ಯಾ ಮಳೆಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ವರಿ ದಿನ್ಯೆಬಿ ಬಾಜಾರಮಾ ವರಿ ತ್ಯಾ ದಿಕ್ಹೆಲ ಮನಕ್ಹೊನೆ ವಾದಾ ಕರಾಡೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ತೆನೈತೊ ಎಪಿಕೊರಿಯೊನೆ ಸ್ತೊಯಿಕರೊನೆ ಕವಾಲಾ ತತ್ವ ವಿಚಾರವಾಲಾ ದಕ್ಹಾಜ಼಼ನಾ ತಿನಾ ಕ್ಹಾತೆ ವಾದಾ ಕರಾಡಾತಾ. ತ್ಯಾ ರಹೆಲ ದಕ್ಹಜ಼ನಾ ತೆ ಸು ವಾತ ಕವಾನೆ ಕೊಶಿಶ ಕರಾಡ್ಯೊಸ ಕೈನ ಕದ್ಯಾ. ತೆ ಯೆಸುನಾ ಹುತಿ ವರಿ ಮರಿನ ಜುತೊ ಥಯಲ ಹುತಿ ಕವಡೊಸ ಕೈನ ವರಿ ತೆ ಭಾರ ಗಾಮಾನಾ ದೆವಸ್ಥಾನವೊನಾ ಬಗೆ ಪ್ರಚಾರ ಕರಾವಾಲೊ ದಿಕ್ಹಾಡೊಸ ಕೈನ ಬಿಜಾ಼ ದಕ್ಹಾಜ಼಼ನಾ ಕವಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ತೆ ಮನಕ್ಹೊ ತಿನೆ ಧರ್ಲಿನ ಅರಿಯೊಪಾಯ ಗಾಮ್ನೆ ಗಯಾ ವರಿ ತಿನೆ ಕದ್ಯಾ ತು ಕವಾನು ಆ ನೈ ಉಪದೆಶ ಹಮೆಬಿ ತಿಳದಿ ಲಿಯೆಸು. ");
INSERT INTO sle_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ವಿಚಿತ್ರ ಥಯಲ ಸಂಗತಿಯೊನೆ ಹಮನೊನೆ ತಿಳಸಾಯಲಕ್ಹು ತಿನಾ ಬಗೆ ಹಮನೊನೆ ತಿಳದಿ ಲಿವಾನೆ ಹಮನೊನೆ ಅಪೆಕ್ಷ ಛೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ಅಥೆನೆಯೊನೊ ರಹೆಲ ಗಾಮ್ಮಾ ಬಿಜಾ಼ ಗಾಮಾವಾಲಾ ನವಾ ನವಾ ಸಂಗತಿಯೊ ಕವಾನು ವರಿ ಐಕಾನು ಛೊಡಿನ ವರಿ ಬಿಜಾ಼ ಕಾಮನೆ ಟೈಮ ನೈ ದೆತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ಪೌಲ ಅರಿಯೊಪಾಯಮಾ ವಚ಼ಮಾ ಹುಬರೈನ ಕದ್ಯೊ ಅಥೆನೆಯೊನಾ ಮನಕ್ಹೊ ತಮೆ ಕ್ಹಾರಾಮಾಜ ಘನ್ನಾ ಕ್ಹುದಾನೆ ನಂಬಾವಾಲಾ ವ್ಹೈ ಕೈನ ಮನೆ ದಿಕ್ಹಾಡುಸ. ");
INSERT INTO sle_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ಮಿ ತಮಾರಾ ಗಾಮ್ಮಾ ಮಿ ಫರತಾಮಾ ಮನೆ ತಮೆ ಪೊಜಾ ಕರಾನಾ ದೆವಸ್ಥಾನೊ ಮೊರ್ತಿಯೊ ದೆಕ್ತಾಮಾ ತಿಮಾ ಮನೆ ಎಕ ಬಲಿಪಿಟ ಡೊಳಾನೆ ಪಡ್ಯು ತಿನಾ ಉಪ್ಪರ ‘ಅಜ್ಞಾತ ರ‍್ಹಯಲ ದೆವಸ್ಥಾನ ಕೈನ ಲಿಕ್ಯಾತಾ. ತಿನಾ ಹುತಿ ತಮೆ ಸುಜ಼ ತಿಳದ್ಯಾವಾಚಿ ಪುಜಾಕರಾನು ತಮನೊನೆ ತಿಳಸಿನ ಕವಾನೆ ಆಯೊಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ಜಗತ್ಮಾ ವರಿ ತಿಮಾ ಕ್ಹಾರು‍ ಸೃಷ್ಟಿ ಕರಲ ಜಿಮಿನ ಆಕಾಶನೊ ಒಡೆಯೊ ಥೈಯೆಲ ತೆ ಹತೆ ಬಾಂದೆಲ ಗುಡಿಯೊಮಾ ವಾಸ ನೈ ಕರತೊ. ತೆಜ಼ ಕ್ಹಾರಾವೊನೆ ಉಸುಲ ಜಿವಸಾವೊನೆ ಕ್ಹಾರು ದಿವಾಲೊ ಮನಕ್ಹೊನ ಹತೆ ಮದತ ಕರಲೆವಾಲೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ತೆಜ಼ ಕ್ಹಾರಾವೊನೆ ಉಸುಲ ಜಿವಸಾವೊನೆ ಕ್ಹಾರು ದಿವಾಲೊ ಛೆ ಕೈಜ಼ ಜರುತ ನೈಸೊ ಮನಕ್ಹೊನ ಹತೆ ಮದತ ಕರಲೆವಾಲೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ಕ್ಹುದಾ ಎಕ ಮನಕ್ಹು ಕ್ಹಾರಾ ಜನಾಂಗನೆ‍‍‍ ಸೃಷ್ಟಿ ಕರಿನ ತ್ಯುನಾ-ತ್ಯುನಾ ರಹೆಲತೆ ವ್ಹಕತನೊ ತ್ಯುನಾ-ತ್ಯುನಾ ರಹೆಲ ಜ಼ಗಾನೆ ತಯಾರ ಕರಿನ ತ್ಯಾ ಮ್ಹೆಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ಎಕ ಟೈಮ್ಮಾ ತ್ಯುನೆ ತಡಾ ಕರ್ಯಮ ತಿನೆ ದೆಕಾನ ಹುತಿ ತ್ಯುನೊನೆ ಧುಂಡಾ ಲಗಾಡ್ಯೊ. ತೆ ಹಮನೊನೆ ತಿನಾಕ್ಹು ದುರ ಕರ್ಯೊನೈ. ");
INSERT INTO sle_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ಕಾಕದ್ಯಾಮ ತಿಮಾ ಅಪೆ ಜಿವಿಸೆಸ ಚಾಲಿಯೆಸ ವರಿ ರಹೆಸ ತಮಾರಾ ಕವಿಯೊ ದಕ್ಹಾ ಜ಼ನಾ ಹಮೆ ತಿನಾ ಸಂತಾನಾ ವ್ಹೈ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ಹಮೆ ಕ್ಹುದಾ ಸಂತಾನಾ ಥಯಲ ಪರ ಕ್ಹುದಾ ಮನಕ್ಹುನು ಗ್ಯಾನಕ್ಹು ವರಿ ವಿಚಾರಕ್ಹು ಕೆತೆಲ ರುಪು ಕ್ಹೊನು ವರಿ ದಹಡಾವೊನೆ ಸಮಾನ ವ್ಹೈ ಕೈನ ಅಪೆ ಭಾವಿಸಾನೆ ಜವುನೈ. ");
INSERT INTO sle_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ತೆ ಗ್ಯಾನ ನೈಸೊ ದಿನೊನೆ ಕ್ಹುದಾ ಲೆಕಾಮಾ ಲಿದ್ಯೊನೈ. ಕ್ಹುದಾ ಹಮ್ನಾ ಬಿ ಚಾರ ದಿಕೊಮಾ ಮನಕ್ಹೊನೆ ಪಚಾತಾಪ ಪಡಿನ ಮಕನ ಪ್ಹರೊ ಕೈನ ಕ್ಹುದಾ ಅಪ್ಪಣೆ ಕರ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ಕಾಕದ್ಯಾಮ ತೆ‍ಸೃಷ್ಟಿ ಕರಲ ದಾಣಗಾನೊ ಹತಕ್ಹೊ ನಿತಿಕ್ಹು ಭುಲೊಕಮಾ ಫೈಸಲೊ ಕರನಾ ಹುತಿ ಎಕ ದಿನ್ನ ಗೊತ ಕರ್ಯೊ. ತಿನೆ ಮರೆಲ ಮಾತೊ ಜುತೊ ಕರಲ ವ್ಹೈ ಕೈನ ನಂಬಾ ಹುತಿ ಕ್ಹಾರಾವೊನೆ ಆ ಕಾನಿ ದಿದೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ಮರೆಲ ಮಾತೊ ಜುತೊ ಥೈಲ ತ್ಯುನಾಹುತಿ ಐಕಿ ದಕ್ಹಾಜ಼಼ನಾ ಪೌಲಾನೆ ಹಿನಾಯಾ ತಿಮಾನಾ ದಕ್ಹಾಜ಼಼ನಾ ಕದ್ಯಾ ತು ಕದಲ ವಾತೊ ಹಮೆ ಹಜಿ ಎಕ ಸಲಾ ಐಕಿಯೆಸ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ಇಮ್ಮ ರ್‍ಹತಾಮಾ ಪೌಲಾ ತ್ಯುನಾ ವಚಮಾತೊ ಗೈ ಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ಬಿಜಾ಼ ದಕ್ಹಾಜ಼಼ನಾ ತಿನೆ ಮಳೆಲಿನ ನಂಬಾ ನಂಬೆಲವಾಲಾ ದಕ್ಹಾಜ಼಼ನಾ ಅರಿಯೊಪಾಯನಿ ಸಬೆಮಾ, ದಿಯೊನುಸ, ದಾಮರಿಯೆ ಕವಾಲಿ ವರಿ ದಕ್ಹಾಜ಼಼ನಾ ತ್ಯಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ಎ ಥಯಲ್ಪರ ಪೌಲಾ ಅಥೆನೆ ಛೊಡಿನ ಕೊರಿಂಥನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ಪೊಂತಮಾ ಕವನಾ ಗಾಮಮಾ ಹುಟ್ಟಲ ಅಕ್ವಿಳ ಕವಾನಾ ಯಕ್ಕ ಯೆಹುದಿನೆ ಪೌಲಾ ದೆಕ್ಯೊ. ಯೆಹುದಿಯೊ ಕ್ಹಾರಾ ರೊಮಾಪುರ ಛೊಡಿನ ಜೌ ಕೈನ ಕ್ಲೌದಿಯನೊ ಚಕ್ರವರ್ತಿ ಆಗನ್ಯಾ ದಿದಲ ಶಾನಾಹುತಿ ಕದ್ಯಾಮ ಅಕ್ವಿಳನೆ ತಿನಿ ಬೈಕೊ ಪ್ರಿಸ್ಕಿಳ ದಕ್ಹಾ ದಿನ್ನ ಪೈಲಾಜ಼ ಇತ್ಯಾಳ ದೆಶತಾ ಆಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ಕಾ ಕದ್ಯಾಮ ಪೌಲಾ ತ್ಯುನಾ ಘರೆ ಗೈನ ತ್ಯುನೆಬಿ ವರಿ ತೆಬಿ ಯಕ್ಕಜ಼ ವ್ಹೈ ಕೈನ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ ಕಾಮ ಕರಾಡೊತೊ; ಗುಡಾರ ಕರಾನು ತ್ಯಯುನು ಕಾಮ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ತ್ಯುನೆ ಹರಿ ಯಕ್ಕ ಸಬ್ಬತ ದಿನೆ ಸಬಾಮಂದಿಮಾ ಚರ್ಚೆ ಕರಿನ ಗ್ರಿಕವಾಲಾವೊನೆ ಯೆಹುದಿಯೊನೆ ಕೈನ ದೆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ಸಿಲಾ ವರಿ ತಿಮೊಥಿ ಮೆಕೆದೊನಿಯೆ ಆತಾಮಾ ಪೌಲಾ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಕವಾಮಾ ಡುಬಿನ ಯೆಸುಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಯೆಹುದಿಯೊನೆ ಖಾಸ ಸಾಕ್ಷಿ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ತ್ಯುನೆ ಎದುರಿಸಿನ ದೊಶ ದಿನ ತೆ ತಿನಾ ವಣ್ಣಾ ಝಾಡ್ಸಿನ ತ್ಯುನೊನೆ ತುಮೆ ಹಾಳ ಥಾವಾನೆ ತುಮೆಜ಼ ಕಾರಣ ವ್ಹೈ. ಮಿ ಶುದ್ಧ ವ್ಹೈ. ಮಿ ಆಜ಼ತೊಜ಼ ಬಿಜಾ಼ ಮನಕ್ಹೊಕನ ಜೌ಼ಸ. ಕೈನ, ");
INSERT INTO sle_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ತೆ ಜ಼ಗಾ ಛೊಡಿನ ಕ್ಹುದಾಕ್ಹು ಭುಚ್ಕಾ಼ಲೊ ತಿತ ಯುಸ್ತ ಕವಾಲಾನಾ ಘರೆ ಗಯೊ. ತಿನು ಘರ ಸಭಾಮಂದಿರನಾ ಬಾಜು಼ಮಾ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ಸಭಾಮಂದಿರನೊ ಅದಿಕಾರಿ ರ‍್ಹಯಲ ಕ್ರಿಸ್ಪನ ತಿನಾ ಘರಲ್ಯಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಕರ್ತಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯೊ. ವರಿ ಕೊರಿಂಥೆಮಾ ಘನ್ನಾ ಮನಕ್ಹೊ ಪೌಲಾ ಕದಲ ಐಕಿನ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ತೆನೈಸೊ ಕರ್ತಾ ಪೌಲಾನೆ ಯಕ್ಕ ದಿನ್ನ ರಾತೆ ದರ್ಶನ ದಿನ ತು ಭುಚ್ಕು಼ ನಕೊ; ಗಪ್ಪ ರ‍್ಹಯಾವಾಚಿ ಸುವಾರ್ತೆ ಮನಕ್ಹೊಕನ ಕತೊಜ಼ ರ‍್ಹೆ, ");
INSERT INTO sle_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ಕಾಕದ್ಯಾಮ ಮಿಜ಼ ತಾರಾ ಕ್ಹಾತೆ ಛೆ; ಕುನ್ನಜ಼ ತಾರಾ ಕ್ಹಾತೆ ಕೆಟ್ಟ ಕರ್ತು ನೈ; ಎ ಗಾಮ್ಮಾ ಮನೆ ಘನ್ನಾ ಮನಕ್ಹೊ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ತೆ ತ್ಯಾ ಯಕ್ಕ ವರಕ್ಹ ಛೆ ಮ್ಹೈನಾ ತ್ಯಾಜ಼ ರ‍್ಹೈನ ತೆ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಶಿಕ್ಲಾತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ಗಲ್ಲಿಯೊನಾ ಅಖಾಯಾ ಪ್ರಾಂತ್ಯನೆ ಅದಿಪತಿ ರ‍್ಹತಾಮಾ ಯೆಹುದಿಯೊ ಮಳಿನ ಪೌಲಾಪರ ಪಡಿನ ತಿನೆ ಫೈಸ್ಲೊ ಕರಾನಿ ಜ಼ಗಾ ಲಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ಎ ಕ್ಹುದಾನೆ ಧರಮಶಾಸ್ತ್ರನಾ ವಿರುದ್ದ ಮನಕ್ಹೊನೆ ಪ್ರೊತ್ಸಾಹಾ ಕರಾಡ್ಯೊಸ. ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ಪೌಲಾ ಪ್ರತಿವಾದ ಕರು ಕತಾಮಾ ಗಲ್ಲಿಯೊನ ಯೆಹುದಿಯೊನೆ ಎ ಯಹುದಿಯೊ, ಅನ್ಯಾಯ, ದುಶ್ಕರ್ಮೊ ಹೆವು ಸುಬಿ ರ‍್ಹಯುಮ ಮಿ ತುಮಾರಿಯೊ ವಾತೊ ಸಮಾಧಾನಕ್ಹು ಐಕಾನು ನ್ಯಾಯ ವ್ಹೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ತೆನೈಸೊ ತುಮೆ ಕರಾನಾ ವಿವಾದ ಭೊದನೆನಾ ನಾಮೊ, ತುಮಾರಾ ಧರಮಶಾಸ್ತ್ರನಾ ಹುತಿ ತಿನಾಹುತಿ ತುಮೆಜ಼ ದೆಕಿಲಿವು. ಹಯ್ಯೊ ವಿಚಾರಣೆ ಕರಾನಾ ಹುತಿ ಮನೆತೊ ಮನಸ ನತ್ತಿ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ತ್ಯುನೆ ನ್ಯಾಯ ಕರಾನಿ ಜ಼ಗಾಕಂತಾ ಮೊಕ್ಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ತೆಳಾಮಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಸಭಾ ಮಂದಿರನೊ ಅದಿಕಾರಿ ಥಯಲ ಸೊಸ್ಥೆನೆ ಧರಿನ ನ್ಯಾಯಲಯನಾ ಕ್ಹಾಮಾಜ಼ ಮಾರ‍್ಯಾ. ಗಲ್ಲಿಯೊನನ ತ್ಯುನೊಮಾ ನಕ್ಕರ ಬಿ ಧ್ಯಾನ ದಿದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ಪೌಲಾ ಹಜು಼ನ ದಕ್ಹಾ ದಿನೊ ಲಕ್ಕಾ ತ್ಯಾ ರ‍್ಹೈನ ತೆ ಥಯಲ್ಪರ ಭಾಯೊಕ್ಹು ಅಪ್ಪಣೆ ಲಿನ ತಿನೆ ದಿಕ್ಷೆ ರ‍್ಹಯಲ ಹುತಿ ಕೆಂಖ್ರೆಯ ಗಾಮಮಾ ಬಾಲೊ ಕಟ್ಟ ಕರೈಲಿವಾನೆ ಹಡ್ಗೊ ಚ಼ಡಿನ ಸಿರಿಯಾ ಗಾಮೆ ಚಾ಼ಲ್ಯೊ. ಕಾಕದ್ಯಾಮ ತೆ ಕ್ಹಮ ಘಾಲ್ಯೊತೊ. ಪ್ರಿಸ್ಕಿಳ ವರಿ ಅಕ್ವಿಳನಾ ತಿನಾ ಕ್ಹಾತೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ಎಫೆಸೆಯೆ ಆತಾಮಾ ತ್ಯುನೊನೆ ತ್ಯಾಜ಼ ಛೊಡಿನ ತೆ ಸಭಾಮಂದಿರ್ಮಾ ಮ್ಹೈ ಗೈನ ಯಹುದಿಯೊನಾ ಕ್ಹಾತೆ ವಾದ ವಿವಾದ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ತ್ಯುನೆ ತಿನೆ ಹಜು಼ನ ದಕ್ಹಾ ದಿನ್ನ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹೆ ಕೈನ ಕೈಲೆತಾಮಾ ತೆ ವಪ್ಯಾವಾಚಿ಼, ");
INSERT INTO sle_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ತಿನಾಹುತಿ ತ್ಯುನೊನೆ ಕದ್ಯೊ ಕ್ಹುದಾನಿ ಚಿತ್ತ ರ‍್ಹೈ ಕದ್ಯಾಮ ಮಿ ತುಮೊಕನ ವರಿ ಹಜಿಯಕ್ಕ ಸಲಾ ಔಸ ಕೈನ. ತೆ ಥಯಲ್ಪರ ಎಫೆಸತೊ ಸಮುಂದರಪರ್ತೊ ಪ್ರಯಾಣ ಕರಿನ ಚಾ಼ಲ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ತೆ ಕೈಸರೈನೆ ಐನ ಮುಟ್ಟಲ ಪರ ಯೆರೊಸೆಲಿಮೆ ಗೈನ ಸಭೆನೆ ವಂದನೆ ಕರಿನ ತೆಳಾಮಾ ಅಂತಿಯೊಕ್ಯನೆ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ಪೌಲಾ ಅಂತಿಯೊಕ್ಯಮಾ ದಕ್ಹಾ ದಿನ್ನ ರ‍್ಹೈನ ವರಿ ತ್ಯಾಂತೊ ಗೈನ ಗಲಾತ್ಯ ಸಿಮೆಮಾ ಫ್ರಗ್ಯಮಾ ಸಂಚಾರ ಕರ್ತಾ ಕ್ಹಾರಾ ವಿಶ್ವಾಸಿಯೊನೆ ಘಟ್ಟ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ತೆಕ್ಲಾಮಾಜ಼಼ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾಮಾ ಹುಟ್ಟಲ ಅಪೊಲೊಸ ಕವಾಲೊ ಯಕ್ಲೊ ಯೆಹುದ್ದಿ ಆಯೊ. ತೆ ವಾತೊಮಾ ಹುಷಾರ ವ್ಹತ್ತೊ ಧರಮಶಾಸ್ತ್ರಮಾ ಪ್ರವಿಣ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ತೆ ಕರ್ತಾನಿ ವಾಟನಾ ಹುತಿ ಉಪದೆಶ ವ್ಹಂದಲವಾಲೊ ವ್ಹತ್ತೊ. ವರಿ ಆಸಕ್ತಿನೊ ಮನಸವಾಲೊ ವ್ಹತ್ತೊ. ಯೊಹಾನ ದಿವಾನು ಬಾಪ್ತಿಸ್ಮಾನು ಯಕ್ಕಜ಼ ವಳಕಲ ರ‍್ಹಯೊತಬಿ ಯೆಸು ಕರಾಲ ಸಂಗತಿಯೊನೆ ಸುಕ್ಷಮಕ್ಹು ಕೈನ ಉಪದೆಶ ಕರ‍್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ತೆ ಸಭಾಮಂದಿರಮಾ ಧೈರ್ಯಕ್ಹು ಬೊಲಾನು ಶುರು ಕರ‍್ಯೊ. ತಿನಿಯೊ ವಾತೊ ಪ್ರಿಸ್ಕಿಳ ವರಿ ಅಕ್ವಿಳ ಐಕಿನ ತಿನೆ ತಿನಾ ಘರೆ ಬೈಲಿನ ಗೈನ ಕ್ಹುದಾನಿ ವಾಟನಾಹುತಿ ತಿನಿ ಸುಕ್ಷಮ ಕ್ಹು ದೆಕಾಡಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ತೆ ಥಯಲ್ಪರ ಅಖಾಯಾನೆ ಜೌ಼ ಕೈನ ತಿನು ಮನಸ ಥಾತಾಮಾ ಭಾಯೊ ತಿನೆ ಪ್ರೊತ್ಸಾಹ ಕರಿನ ತ್ಯಾ ರ‍್ಹಯಲ ವಿಶ್ವಾಸಿಯೊ ಇವ್ನೊನೆ ಮಳೈ ಲ್ಯು ಕೈನ ಪತ್ರಿಕೆ ಬರ್ದಿನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ಕಾಕದ್ಯಾಮ ತೆ ತ್ಯಾ ಗಯೆಲ ಪರ ಯೆಸುಜ಼ ಕ್ರಿಸ್ತ ವ್ಹೈ ಕೈನ ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ಕ್ಹು ಯೆಹುದಿಯೊನೆ ದೆಕಾಡಿನ ದಿನ್ನ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಧರಮಶಾಸ್ತ್ರಾನಿ ತಾಕತಕ್ಹು ಇನಾಹುತಿ ದೆಕಾಡಿನ ದೆತಾ ಯೆಹುದಿಯೊನೆ ಖಂಡನೆ ಕರಿನ ಕ್ಹುದಾನಿ ಮರ್ಗಾಕ್ಹು ಬರೊಕ್ಹೊ ಕರಲವಾಲವೊನೆ ಘನ್ನೊ ಮದತ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ಅಪೊಲೊಸ ಕೊರಿಂಥಮಾ ರ್‍ಹತಾಮಾ ಪೌಲ ಬ್ಹಾರಲ್ಯಾ ಗಾಮ್ಮಾ ಫರಿನ ಎಪೆಸಮಾ ಐನ ದಕ್ಹಾಜ಼಼ನಾ ಶಿಷ್ಯಾವೊನೆ ದೆಕಿನ. ");
INSERT INTO sle_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ತುಮೆ ನಂಬೆಲಪರ ಪವಿತ್ರ ಆತ್ಮಾನಿ ವರ ವ್ಹಂದಿಲಿದ್ಯಾಸು? ಕೈನ ತ್ಯುನೊನೆ ಪುಚ಼ತಾಮಾ ತ್ಯುನೆ ಕದ್ಯಾ ನತಿ ಕೈನ ಕದ್ಯಾ ಪವಿತ್ರ ಆತ್ಮಾ ಕವಾನು ಹಮೆ ಐಕ್ಯಾ ನತ್ತಿ ತ್ಯುನೊನೆ ಛೆ ಕೈನ ಗ್ವತ್ತ ನತಿ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ತೆ ತ್ಯುನೊನೆ ತಮೆ ಕೈ ತರಾನಿ ಬಾಪ್ತಿಸ್ಮ ಲಿದ್ಯಾಸ. ಕೈನ ಪುಚ಼ತಾಮಾ ತ್ಯುನೆ ಕದ್ಯಾ ಯೊಹಾನನು ಬಾಪ್ತಿಸ್ಮ ಕರಲಿದ್ಯಾಸ ಕದ್ಯಾ ");
INSERT INTO sle_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ತಿನಾಹುತಿ ಪೌಲಾ ಯೊಹಾನ ಪಶ್ಚಾತ್ತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಕನ ಫರಿನ ಬಾಪ್ತಿಸ್ಮ ಕರೈನ ಕದ್ಯೊ ತಿನ್ಯಾ ಐನ ವರಿ ತಿಪರ ಬರೊಕ್ಹೊ ಕರಾವಾಲಾ ಮನಕ್ಹೊವೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ತ್ಯುನೆ ತೆ ವಾತೊ ಐಕಿನ ಕರ್ತಾ ಥಯಲ ಯೆಸು ನಾಮಪರ ಬಾಪ್ತಿಸ್ಮ ಕರಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ಪೌಲಾ ತ್ಯುನೊಪರ ಹತ ಮ್ಹೆಲೆಲಪರ ಪವಿತ್ರಾತ್ಮ ತ್ಯುನಾ ಉಪ್ಪರ ಐಯ್ಯೊ. ವರಿ ತ್ಯುನೆ ಬಿಜಿಯೊ-ಬಿಜಿಯೊ ವಾತೊ ಬೊಲ್ಯಾ,ಕ್ಹುದಾನು ಸಂದೆಶ ಕತಾ ಚಾ಼ಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ತ್ಯುನೆ ಕಮಸೆ ಕಮ ಬಾರಾ ಜ಼ನಾ ದಾಣ್ಗಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ತೆ ಗಾಮ್ಮಾ ಪೌಲಾ ಸಬಾಮಂದಿರಮಾ ಗೈನ ತನ ಮ್ಹೈನಾ ತ್ಯಾ ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ಕವಾಡೊತೊ. ಮನಕ್ಹೊನೆ ಧೈರ್ಯಕ್ಹು ಬೊಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ದಕ್ಹಾ ಮನಕ್ಹೊ ತ್ಯುನಾ ಮನಸಮಾ ಕಟಿನ ಕರಲಿನ ವರಿ ನಂಬ್ಯಾ ನೈ ಗುಂಪ ಕರಿನ ಮನಕ್ಹೊನ ಕ್ಹಾಮಾ ಆ ವಾಟ ಕೆಟ್ಟ ಛೆ ಕವಾನೆ ತಿನಾಹುತಿ ಪೌಲಾ ತ್ಯುನೊನೆ ಛೊಡಿನ ಗೈನ ಶಿಷ್ಯಾವೊನೆ ಬಿಜಾ಼ ಕರಿನ ತುರನ್ನ ಕವಾನಿ ಶಿಕ್ಲಾವೊನಿ ಕ್ಹೊಲಿಮಾ ತಿನಾಹುತಿ ತರ್ಕಸಾಲಿಮಾಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ತೆ ಬೆ ವರಕ್ಹತು ಥಯಲ ಅಸ್ಯಸಿಮೆಮಾ ಕ್ಹಾರಾ ಯೆಹುದಿಯೊ ವರಿ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊ ಗ್ರಿಕವಾಲಾ ಪ್ರಭು ಯೆಸುನು ಸಂದೆಶ ಐಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ಕ್ಹುದಾ ಪೌಲಾನಾ ಹತಕ್ಹು ಖಾಸ ಅದ್ಭುತ ಕರತಾ ರ‍್ಹತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ತಿನಾಹುತಿ ಪೌಲಾನಾ ಉಪ್ಪರಲ್ಯಾ ವಣಾ ವರಿ ನ್ಹಾನು ಟುವಾಲ ಮನಕ್ಹೊ ಲಿನ ರೊಗಿಯೊನಾ ಉಪ್ಪರ ಘಾಲ್ತಾಮಾ ತ್ಯುನಾ ರೊಗೊ ವಾಸಿ ಥಯಾ ವರಿ ಭುತ್ಡಾ ಛೊಡಿನ ಜಾತ್ತಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ಭುತ್ಡಾ ಛೊಡಾವಾಲಾ ಗಾಮೊ-ಗಾಮೊ ಪ್ಹರ್ತಾ ರ‍್ಹಯಲ ದಕ್ಹಾ ಯೆಹುದಿಯೊ ಯೆಸುನು ನಾಮ ಕೈನ ಭುತ್ಡಾ ಛೊಡಾವಾನೆ ಕೊಶಿಶ ಕರ್ತಾತಾ ದಕ್ಹಾ ಕೆಟ ಆತ್ಮವೊನಾ ಉಪ್ಪರ ಪೌಲಾ ಕವಾನು ಯೆಸುನು ಕ್ಹಮ್ಮ ಕೈನ ಕರ್ತಾ ಥಯಲ ಯೆಸು ನಾಮ್ಮಪರ ಪ್ರಯೊಗ ಕರಾನೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ಖಾಸ ಯಾಜಕ ಸ್ಕೆವ ಕವಾಲೊ ಎಕ ಯಹುದಿ ವ್ಹತೊ. ತಿನಾ ಕ್ಹಾತ ಬಚ್ಚಾ಼ ವ್ಹತಾ. ತ್ಯುನೆ ಬಿ ಅಮ್ಮಜ಼ ಕರತಾ ಥಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ತೆನೈಸೊ ದುರಾತ್ಮ ತ್ಯುನೊನೆ ಕದ್ಯು ಯೆಸುನು ವಳಕ ಮನೆ ಛೆ ವರಿ ಪೌಲಾ ಬಿ ಮನೆ ಗೊತ್ತ ಛೆ. ತೆನೈಸೊ ತ್ಯುನೊನೆ ಗೊತ್ತಚ್ಹೆ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ವರಿ ಕೆಟ ಆತ್ಮ ಧರಲವಾಲಾ ತೆ ಮನಕ್ಹೊ ಪರ ತೆ ಆಕ್ರಮಣ ಕರಿನ ತ್ಯುನೊನೆ ಸೊಲಸಿನ ಘಾಬ್ರಾ ಥೈನ ದುಕ ಕರಲಿನ ಭೊಗಳಾ ಥೈನ ತಿನಾ ಘರಮಾ ನ್ಹಾಟಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ತೆ ಸಂಗತಿಯೊ ಎಪೆಸಮಾ ರಹೆಲ ಕ್ಹಾರಾ ಯೆಹುದಿಯೊನೆ ವರಿ ಗ್ರಿಕರೊನೆ ತಿಳ್ದಿನ ಆತಾಮಾ ತ್ಯುನೆ ಘನಾ ಭುಚ಼ಕಿ ಗಯಾ ವರಿ ಕರ್ತಾ ಯೆಸುನು ನಾಮ ಘನ್ನು ಉಚ್ಚು಼ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ತ್ಯುನೊಮಾ ನಂಬೆಲವಾಲಾ ಐನ ಘನಾಜ಼ನಾ ಕ್ಹಾಮಾ ತ್ಯುನೆ ಕರಲ ಕಾಮೊ ಒಪಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ತೆನೈತೊ ಮಾಟಾ ಮಂತ್ರಾ ಕರೆಲವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ತ್ಯುನಾ ಮಾಟಾ ಮಂತ್ರಾನಾ ಬುಕೊ ಲೈನ ಬಾಳಿ ಪಾಡ್ಯಾ. ತಿನಿ ಕಿಮ್ಮತ ಹಿಸಾಬ ಕರಿನ ಐವತ್ತ ಹಜಾರ ರುಪ್ಪಾನಾ ಬಿಲ್ಲಾ ಥಯಾ ಕೈನ ಕೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ತೆ ರಿತಿಮಾಜ಼ ಕರ್ತಾನಿ ವಾಕ್ಯ ಘನಿ ಬಡತಿ ತಾಕತವರ ಥೈ. ");
INSERT INTO sle_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ಎ ಸಂಗತಿ ಥಯಲ ಪರ ಪೌಲಾ ಬಿ ಮಕೆದೊನ್ಯಮಾ ಅಖಾಯಾಮಾ ಸಂಚಾರ ಕರಿನ ಯೆರುಸಲೆಮೆ ಜೌ ಕೈನ ಮನಸ್ಸಮಾ ಸೊಚ಼ಾಡೊ ಥೊ. ತ್ಯಾ ಗಯೆಲ ಪರ ರೊಮಾಪುರವಾಲಾವೊಬಿ ದೆಕು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ತೆನೈಸೊ ತೆ ತಿನಾಮಾ ಸೆವೆ ಕರಾವಾಲಾ ಬೆ ಜ಼ನಾ ತಿಮೊಥಿ ವರಿ ಎರಸ್ತನ ಮಕೆದೊನ್ಯನೆ ವಳೈನ ತೆ ಆಸ್ಯಸಿಮೆಮಾ ದಕ್ಹಾ ದಿನ್ನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ತೆ ದಿನೊಮಾ ತೆ ವಾಟನಾ ಪರ ಘನು ಧಾಂದಲ ಉಟಿತಿ. ");
INSERT INTO sle_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ಕಿಮ್ಮ ಕದ್ಯಾಮ ದೆಮೈತ್ರಿ ಕವಾಲೊ ಎಕ ಅಕ್ಕಸಾಲಿಗಾ ರುಪಾಕ್ಹು ಅರ್ತೆಮಿನಿ ದೆವಿನಿ ಗುಡಿಯೊಕ್ಹು ನ್ಹಾನಾ ನ್ಹಾನಾ ಗುಡಿಯೊ ಕರಾವಾಲೊ ತೆ ಕಾಮ್ಮ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ಘನು ಫಯದೊ ದೆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ತೆ ತ್ಯುನೊನೆ ವರಿ ತೆ ಕುಸುಬಿಯೊನೆ ಸಂಬಂಧ ರ‍್ಹಯಲ ಕಾಮವಾಲಾವೊನೆ ಎಕ ದಮ್ಮ ಬಲೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ ಮನಕ್ಹೊ ಆ ಕಾಮಕ್ಹು ಅಪೆ ಘನ್ನಾ ಸೌಕಾರ ಥೈಯೆಸ ಕೈನ ತಮನೊನೆ ಗ್ವತ್ತ ರ‍್ಹೌ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ತೆ ನೈಸೊ ಹತಕ್ಹು ಕರಲ ಮೂರ್ತಿಯೊ ದೆವಸ್ಥಾನ ನ್ಹವೈ ಕೈನ ತೆ ಪೌಲಾ ಕೈನ ಎಪೆಸಮಾ ಎಕಜ಼ನೈ ಕಮ್ಮಸೆ ಕಮ್ಮ ಆಸ್ಯಸಿಮೆಮಾ ಘನಾ ಮನೊಕ್ಹೊನೆ ದೆಕಾಡಿನು ದಿವಾನು ಪ್ಹರೈಪಾಡ್ಯೊ ಕೈನ ತುಮೆ ದೆಕೊಶಿಬಿ ವರಿ ಐಕೊಶಿಬಿ. ");
INSERT INTO sle_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ತಿನಾಹುತಿ ಹಮಾರಾ ಕಾಮನೆ ಲುಕ್ಸಾನ ನೈ ಆತು ಕೈನ ಅರ್ತೆಮಿನಾ ಮಹಾದೆವಿ ದೆವಸ್ಥಾನೆ ಲೆಕ್ಕಾನೆ ನೈ ಆವಾನಾ ಹುತಿ ತಿನಾ ಹುತಿ ಕ್ಹಾರಾ ಆಸ್ಯಸಿಮೆ ವಾಲಾ ಜಗತ್ನೆ ಪುಜಾ ಕರಾಲಾ ದೆವಿನು ಶೃಂಗಾರನೆ ಲುಕ್ಸಾನ ಥೈ ಕೈನ ತ್ರಾಸ ಥಾವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ತ್ಯುನೆ ಆ ವಾತೊ ಐಕೆಲ ಮನಕ್ಹೊನು ಗುಂಪ ಶಿಟ ಥೈನ ಎಪೆಸೊನಾ ಅರ್ತೆಮಿ ದೆವಿ ಮಹಾದೆವಿ ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ತೆಳಾಮಾ ಗಾಮ್ಮಾ ಪುರಾ ಗಲಿಬಿಲಿ ಥೈ. ಪ್ರಯಾಣಮಾ ಪೌಲಾನಾ ಕ್ಹಾತೆ ಮಕೆದೊನ್ಯ ಗಾಯೊಸೆನೆ ವರಿ ಅರಿಸ್ತಾರ್ಕನೊನೆ ಮನಕ್ಹೊ ಧರ್ಲಿನ ಮಳಿನ ನಾಟಕ ಸಾಲಿಮಾ ಹೊಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ಪೌಲಾ ಮನಕ್ಹೊನಾ ಗುಂಪನಾ ಕ್ಹಾಮೊ ಜಾ಼ತಾಮಾ ವಿಶ್ವಾಸಿಯೊ ತಿನೆ ಛೊಡ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ತೆ ನೈಸೊ ಆಸ್ಯಸಿಮೆನಾ ಅದಿಕಾರಿಯೊಮಾ ದಕ್ಹಾಜ಼಼ನಾ ಪೌಲಾನಾ ದೊಸ್ತೊ ಥಯಲ ಕ್ಹು ತಿಕನ ಮನಕ್ಹೊನೆ ವಳೈನ ತು ನಾಟಕ ಸಾಲಿನಮಾ ನಕೊ ಜೌ಼ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ಮನಕ್ಹೊಮಾ ಗಲಿಬಿಲಿ ಥೈ ಕೈನ ದಕ್ಹಾಜ಼಼ನಾ ಎಕ ತರಾಮಾ ಅಡ್ಯಾಮ ಬಿಜಾ಼ ದಕ್ಹಾಜ಼಼ನಾ ಹಜೆಕ ತರಾಮಾ ಅ‍ಡ್ಡಾಡ್ಯಾ ಥಾ. ಘನಾ ಜ಼ನಾ ತ್ಯಾ ಮಳಿನ ಆಯೆಲ ಕಾರಣ ಗ್ವತ್ತ ನ್ಹೊತು ");
INSERT INTO sle_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ಯೆಹುದಿಯೊ ಅಲೆಕ್ಸಾಂಡರನೆ ಅಗಾ ಢಕಲ್ತಾಮಾ ಗುಂಪಮಾ ದಕ್ಹಜ಼ನಾ ತಿನೆ ಸುಚನೆ ದಿದ್ಯಾ. ತೆಳಾಮಾ ಅಲೆಕ್ಸಾಂದ್ರನೆ ಇಶಾರೊ ಕರಿನ ಶಾಂತ ಕರಸ. ಮಳೆಲ ಮನಕ್ಹೊನೆ ಪ್ರತಿವಾದ ಕರುಕೈನ ವ್ಹತೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ತೆಳಾಮಾ ತೆ ಯಹುದ್ಯೊ ವ್ಹೈ ಕೈನ ತಿಳದ ತಾಮಾ ಕ್ಹಾರಾಜ಼ನಾ ಎಕ ಅವಾಜಕ್ಹು ಎಫೆಸೊನಿ ಅರ್ತೆಮಿದೆವಿ ಮಹಾದೆವಿ ವ್ಹೈ ಕೈನ ಬೆ ಘಂಟಾ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ಲಾಸ್ಟಮಾ ಗಾಮನೊ ಮಾಲಕ ಮನಕ್ಹೊನಾ ಗುಂಪನೆ ಸಮಾಧಾನ ಕರಿನ ವರಿ ಎಪೆಸೆವಾಲಾ ಎಪೆಸ ಗಾಮ್ಮವಾಲಾ ಅರ್ತೆಮಿ ಮಹಾದೆವಿ ದೆವಸ್ಥಾನೆ ಹಬಾಳಮ್ಯಾತು ಪಡೆಲ ತಿನಾ ಮೂರ್ತಿನೆ ಮಾ ಬಾಪ ಥಯಾಸ ಕೈನ ತಿಳದಲವಾಲೊ ಮನಕ್ಹ ಕುನ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ಎ ಸಂಗತಿಯೊ ನ್ಹವೈ ಕವಾನಾ ಹುತಿ ಕಿನೆಕ್ಹುಜ಼ ನೈ ಥಯಲಕ್ಹು ತುಮೆ ಶಾಂತಿಕ್ಹು ರ‍್ಹವೊ. ಗಡಬಡ ಕರಿನ ಸುಜ಼ ಕರುನೈ. ");
INSERT INTO sle_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ತುಮೆ ದ್ಹರಲಿನ ಆಯೆಲ ಆ ಮನಕ್ಹೊ ಗುಡಿಮಾ ಚೊ಼ರಿ ಕರಾಲಾ ನ್ಹವೈ ಹಮಾರಿ ದೆವಿನೆ ದುಷಿಕವಾಲಾ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ತಿಮ್ಮ ರ‍್ಹಯಲಕ್ಹು ದೆಮೆತ್ರಿಯೊನೆ ತ್ಯುನಾ ಬಗಲ ರಹೆಲವಾಲಾ ಕಾಮ ಕರಾವಾವೊನೆ ಕುನಬಿ ತಿಪರ ತಪೊ ರ‍್ಹಯಾಮಾ ಫೈಸಲಾನಿ ಜ಼ಗಾವೊ ಅಧಿಪತಿಯೊ ಛೆ ಎಕನಾ ಉಪ್ಪರ ಎಕ ಅಪವಾದ ಘಾಲ್ಲಿವಾನು. ");
INSERT INTO sle_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ಸುಬಿ ಘನು ವಿಚಾರಣೆ ಚಾ಼ಯೆ ಥಯು ತೆ ನ್ಯ ಫೈಸಲೊಕ್ಹು ಸಬೆಮಾ ತಿರ್ಮಾನ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ತೆ ದಿನೊಮಾ ಫೈಸಲೊಕ್ಹು ಸುಜ಼ ಕಾರಣ ನೈಸೊ ಆಯೆಲ ಮನಕ್ಹೊನಾ ವಿಷಯಮಾ ತೆ ಎಕ ದಂಗೊ ಹಮಾರಾ ಉಪ್ಪರ ತಪ್ಪ ಘಾಲಾನೆ ಕಾರಣ ಥಯು. ತೆ ತಪನಾ ಹುತಿ ವಿಚಾರ ಕರ್ಯಾಮ್ಮ ಹಮನೊಕ್ಹು ಜವಾಬ ದಿವಾನೆ ಥಾತು ನೈ ಕೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ತೆ ಥಯಲ ಪರ ವಾತೊ ಐಕಿನ ಪಂಚಾತಿ ಮುಗಶ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ಗದ್ದಲ ಹುಬ್ರಯಲ್ಪರ ಪೌಲಾ ವಿಶ್ವಾಸಿಯೊನಾ ಕ್ಹಾತೆ ಬಲೈನ ಯಕ್ಕ ಜ಼ಗಾ ದೈರ್ಯದಿನ ತ್ಯುನೊಕಂತೊ ಅಪ್ಪಣೆ ಲಿನ ಮಕೆದೊನಿಯಾನೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ತೆ ಗಾಮ್ಮಾ ಫರಿನ ತ್ಯಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಘನ್ನಾ ಸಂದೆಶ ದಿನ್ನ ಧೈರ್ಯದಿನ ಗ್ರಿಸ ದೆಶೆ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ತ್ಯಾ ತನ್ನ ಮ್ಹೈನಾ ಥಯಲ್ಪರ ಸಿರಿಯಾ ದೆಶೆ ಸಮುಂದರನಿ ವಾಟತೊ ಜೌ಼ ಕೈನ ಕೈಲೆತಾಮಾ ತಿನಾ ವಿರುದ್ದ ಯೆಹುದಿಯೊ ಪ್ಲಾನ ಕರಲ ತಿನೆ ಗ್ವತ್ತ ಥಯಲ ಹುತಿ ತೆ ಮೆಕೆದೊನಿಯಾನಿ ವಾಟತೊ ಪಾಚೊ಼ ಪ್ಹರಿನ ಜಾ಼ವಾನೆ ಫೈಸಲೊ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ಪುರ್ರನೊ ದಿಕ್ರೊ ಥಯಲ ಬೆರೊಯೊ ಗಾಮವಾಲೊ ಸೊಪತ್ರನು, ಥೆಸಲೊನಿಕ ಅರಿಸ್ತಾರ್ಕ, ಸೆಕುಂದನದೆರ್ಬೆ ಥೆಸಲೊನಿಕ ಗಾಮವಾಲೊ ಗಾಯೊಸನೊ,ತಿಮೊಥಿಯೊನ, ಆಸ್ಯಸಿಮೆಮಾ ರ‍್ಹಯಲವಾಲಾ ಮನಕ್ಹೊ ತುಖಿಕನ, ತ್ರೊಫಿಮನೊ, ಆಸ್ಯಸಿಮೆ ಲಕ್ಕಾ ತಿನಾ ಕ್ಹಾತೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ತ್ಯುನೆ ಪೈಲಾಜ಼ ಗೈನ ಹಮಾರಾ ಹುತಿ ತ್ರೊವಾಮಾ ಕೈದಾಡ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ನೈ ಫುಗ್ಗಲ ರೊಕ್ಲಾನಾ ಸನ್ನನಾ ದಿನೊಮಾ ಪುರಾ ಥಯಲ್ಪರ ಹಮೆ ಪಿಲಿಪ್ಪಮಾತಾ ಹಡಗಾಮಾ ಪಾಂಚ಼ ದಿನೊಮಾ ತ್ರೊವಾಮಾ ಐನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಮಳ್ಯಾ. ತ್ಯಾ ಕ್ಹಾತ ದಿನ್ನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ಹಪ್ತಾನಾ ಪಸ್ಟಲ್ಯಾ ದಿನ್ಮಾ ರೊಕ್ಲೊ ತೊಡಿನ ಖಾವಾನಾ ನಿಯಮನಾ ಹುತಿ ಮಳಿನ ಆತಾಮಾ ಪೌಲಾ ತ್ಯಾ ಮಳಿನ ಆಯಲ ವಿಸ್ವಾಸಿಯೊನೆ ಭೊದನ ಕರ್ತೊ ಅರ್ದಿ ರಾತಲಕ್ಕಾ ಉಪನ್ಯಾಸ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ಹಮೆ ಮಳಿನ ರ‍್ಹಯಲ ಅಂಟಾನಾ ಘರ್ಪರ ಘನ್ನು ಉಜಾಲು ದಿವಾನಾ ದಿವ್ವಾ ವ್ಹತಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ಯುತಿಕ ಕವಾಲೊ ಯಕ್ಲೊ ಜಾಂಜಿಮಾನ ಖಿಡ್ಕಿಕನ ಹುಬ್ರೈನ ನಿಂದರ್ಮಾ ಜ಼ುಕತ್ತೊ ರ‍್ಹವಸ. ಪೌಲಾ ಭೊದನೆ ಕರ್ತೊ ರ‍್ಹತಾಮಾ ತೆ ಜಾಂಜಿಮಾನ ತನ್ನ ಮಹಡಿ ಮ್ಹಾಡಿಪರ್ತೊ ಹೆಟೊ ಪಡಿಗಯೊ; ತಿನೆ ಉಟಾಡಾನೆ ಜಾ಼ತಾಮಾ ತೆ ಮರಿಗಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ತೆನೈಸೊ ಪೌಲಾ ಹೆಟೊ ಉತ್ರಿನ ಗೈನ ತಿಪರ ಪಡಿನ ತಿನೆ ಔಳಗಿಲಿನ; ಚಿಂತಾ ನಕೊ ಕರೊ, ತೆ ಜಿವ್ತೊ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ತೆಳಾಮಾ ತೆ ಉಪ್ಪರ ಗೈನ ರೊಕ್ಲೊ ತೊಡಿನ ಖೈನ ದಿನ್ನ ನಿಕ್ಹಳೆ ಲಕ್ಕಾಬಿ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲಿನ ಗೈಪಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ತ್ಯುನೆ ತೆ ಜಿವ್ತೊ ಥಯಲ ಪಟ್ಟಾನೆ ಘರೆ ಬಲೈಲಾತಾಮಾ ತ್ಯುನೊನೆ ಘನ್ನು ಸಮಾಧಾನ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ಅಪೆ ತ್ಯಾ ಪೈಲಾಜ಼ ಗೈನ ಅಸ್ಸೊಸಿಮಾ ಪೌಲಾನೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ಚ಼ಡೈಲ್ಯು ಕೈನ ವ್ಹತ್ತಾ. ಸಮುಂದರನಿ ವಾಟತ್ತಾ ಪ್ರಯಾಣ ಕರ‍್ಯಾ. ಪೌಲಾ ತಿಮ್ಮಜ಼ ಅಪ್ಪಣೆ ದಿನ ಚಾ಼ಲ್ತೊ ಜೌ಼ ಕೈನ ಮನಸ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ಅಸ್ಸೊಸಿಮಾ ತೆ ಅಪ್ನಾ ಕ್ಹಾತೆ ಮಳ್ತಾಮಾ ಹಮೆ ಹಮಾರಾ ಕ್ಹಾತೆ ಹಡಗಾಮಾ ತಿನೆ ಮಳೈಲಿನ ಮಿತಿಲಿನ ಗಾಮೆ ಚಾ಼ಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ತ್ಯಾಂತಾ ಗೈನ ಮರ್ನಾ ದಿನ್ನೆ ಖಿಯೊನ ದ್ವಪನಾ ಕ್ಹಾಮಾ ಐನ ವರಿ ತಿನಾ ಮರ್ನಾ ದಿನ್ನೆ ಸಾಮೊಸಿನನಾ ನಜಿಕ ಆಯಾ. ಮರ್ನಾ ದಿನ್ನೆ ಮಿಲೆತಕ್ಕಮಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ಪೌಲಾ ಮನೆ ಸಾದ್ಯಥಯುಮ ಪಂಚಾಶತಮನಾ ಸನ್ನನೆ ಯೆರುಸೆಲಿಮಮಾ ರ‍್ಹೌ ಕೈನ ಗಡಬಡ ಕರ್ತೊ ರ‍್ಹತಾಮಾ ಆಸ್ಸಿಸಿಮಾ ರ‍್ಹವಾನೆ ಮನಸ ನೈಸೊ ಎಫೆಸ ಗಾಮ ದಾಟಿನ ಜೌ಼ ಕೈನ ವಿಚಾರ ಕರ್ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ತೆ ಮಿಲೆತತೊ ಎಫೆಸೆಯೆ ಮೊಕ್ಲಿನ ತ್ಯಾನಾ ಸಭೆಮಾ ಮ್ಹೊಟಾವೊನೆ ಬಲಾವಾನಾಹುತಿ ಸಂದೆಶ ವಳಾಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ತ್ಯುನೆ ತಿಕನ ಆತಮಾ ತ್ಯುನೊನೆ ತೆ ಸು ಕದ್ಯೊ ಕದ್ಯಾಮ; ಮಿ ಆಸ್ಯಸಿಮೆಮಾ ಪ್ರಾಂತ್ಯ ಪಗ್ಗ ಮ್ಹೆಲಲ ಪೈಲಾ ದಿಂತಾ ತುಮಾರಾ ವಚ್ಮಾ಼ ಕ್ಹಾರಾ ಕಾಲೊಮಾ ಕಿಮ ಚಾ಼ಲಿಲಿನ ಗಯೊ ಕವಾನು ತುಮೊನೆಜ಼ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ಯೆಹುದಿಯೊನು ತ್ಯುನೆ ಮ್ಹೈನು ವಿಚಾರ ಕಸ್ಟೊಮಾ ಮಿ ಘನ್ನೊ ನಮ್ರೆತೆಕ್ಹು, ಡೊಳಾನಾ ಪಾನಿಕ್ಹು ಕರ್ತಾನಿ ಸೆವೆ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ಮಿ ತುಮಾರಿ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ತಮನೊನೆ ಚೊ಼ಕಾನಿಕ್ಹು ಕವಾಕ್ಹು, ಘರ ಘರಮಾ,ಐನ ತಮನೊನೆ ಸಹಾಯ ಕರಾನು ಉಪದೆಶ ಕವಾನಿಕ್ಹು ಪಾಚೊ಼ ಸರಕ್ಯಾವಾಚಿ ");
INSERT INTO sle_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ಯೆಹುದಿಯೊನೆ ವರಿ ಗ್ರಿಕವಾಲಾಬಿ ಪಶ್ಚಾತಾಪ ಪಡಿನ ಕ್ಹುದಾ ಬಗಲ ಫರು ಕೈನ, ಅಪ್ನೊ ಕರ್ತಾ ಥಯಲ ಯೆಸುಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲು ಕೈನ ಮಿಜ಼ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ದೆಕೊ, ಮಿ ಹಮ್ನಾ ಪವಿತ್ರ ಆತ್ಮಾಕ್ಹು ಬಂದನಮಾ ರ‍್ಹೈನ ಯೆರುಸೆಲೆಮೆ ಚಾಲ್ಯೊಸ. ತ್ಯಾ ಮಾರಾಕ್ಹಾತೆ ಸು ತಾವಸ ಮನೆ ಗ್ವತ್ತ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ತುನೆ ಜೆಲಮಾ ಬೆಡಿಯೊ ವರಿ ತ್ರಾಸೊ ಕೈದಾಡ್ಯಾಸ. ಕೈನ ಪವಿತ್ರ ಆತ್ಮಾ ಹರಯಕ್ಕ ಗಾಮೊಮಾ ಮನೆ ಎಚ್ಚರಿಕೆ ದಿದ್ಯೊಸ ಕವಾನು ಮಿ ವಳಕ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ತೆನೈಸೊ ಜ಼ಲಮ ವಚಾ಼ಡಿಲಿವಾನು ಶ್ರೆಷ್ಠೆ ವ್ಹೈ ಕೈನ ಮಿ ವಿಚಾರ ಕರ್ತೊ ನೈ; ಕ್ಹುದಾನಿ ಮರ್ಗಾನಾ ಹುತಿ ಸುವಾರ್ತೆ ಆಸಕ್ತಿ ಕ್ಹು ಸಾಕ್ಷಿನಾ ರೊಪಮಾ ಕವಾನು ನಿಯೊಗ ಕರ್ತಾ ಥಯಲ ಯೆಸುಕ್ಹು ಮಿ ವ್ಹಂದ್ಯೊಸ. ಎಜ಼ ನಿಯೊಗ ಉಪಯೊಗ ಕರಾನು ಮಾರಿ ಆಸ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ದೆಕೊ, ಯಕ್ಲಾ ದಿನ್ನ ತುಮೊಕನ ಐನ ಕ್ಹುದಾನಿ ರಾಜ್ಯನ ಹುತಿ ಉಪ್ಪರ ತುಮೆ ಮಾರು ಮ್ಹೊಡು ಯಕ್ಲೊಬಿ ದೆಕ್ತಾ ನೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ತಿನಾಹುತಿ ಹಮ್ನಾ ಕ್ಹರಿಜ಼ ಕೌಸ, ತುಮೊಮಾ ಕುನಬಿ ಹಾಳ ಥಯಾಮ ತೆ ಮಾರಾ ತಪ್ಪಕ್ಹು ನ್ಹ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ಕಾಕದ್ಯಾಮ ಯಕ್ಕಬಿ ಝಾಕ್ಯಾವಾಚಿ ಕ್ಹುದಾನಿ ಕ್ಹಾರಿ ವಿಚಾರ ತುಮೊನೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ಕರ್ತಾ ತಿನಾ ಸ್ವಂತನು ರಗತಕ್ಹು ಕಮಾಯಲ ಕ್ಹುದಾನಿ ಸಬೆವಾಲಾ ಪಾಲನ ಕರಾನಾಹುತಿ ಪವಿತ್ರ ಆತ್ಮಾ ತುಮೊನೆ ಎ ಗುಂಪಮಾ ಸಭಾದಕ್ಷ ಕರಿನ ಮ್ಹೆಲಲ ಹುತಿ ತುಮಾರಾ ಹುತಿ, ಕ್ಹಾರಿ ಗುಂಪನಾ ಹುತಿ ಹುಷಾರಮಾ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ಮಿ ಗಯಲ್ಪರ ಘನ್ನಾ ಕ್ರುರ ರ‍್ಹಯಲ ರಾನ್ನಾ ಕುತ್ರಾ ತುಮೊಮಾ ಆವಸ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ; ತೆ ಹಿಂಡನೆ ಮರಗತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ಎನೈಸೊ ತುಮೊಮಾ ದಕ್ಹಾಜ಼಼ನಾ ಉಟಿನ ಸುಳ್ಳ ರ‍್ಹಯಲ ಭೊದನೆ ಕರಿನ ಶಿಷ್ಯಾವೊನಾ ತ್ಯುನಾ ಬಗಲ ಜಗ್ಗಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ತಿನಾಹುತಿ ಮಿ ಡೊಳಾಮಾನು ಪಾನಿ ಕಾಡ್ತೊ ತನ್ನ ವರಕ್ಹ ದಿನ್ನ ರಾತ ಛೊಡ್ಯಾವಾಚಿ ಹರಿ ಯಕ್ಲಾನೆ ಗ್ಯಾನ ಕದ್ಯೊಸ ಕವಾನು ತುಮೆ ಶೆ ಕರ್ಲಿನ ಹುಶಾರ ಥೈನ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ಮಿ ಹಮ್ನಾ ತುಮೊನೆ ವರಿ ಕ್ಹುದಾನೆ, ತಿನಾ ಕೃಪಾನಿ ವಾಕ್ಯಾಕ್ಹು ವಪ್ಸಿನ ದ್ಯುಸ. ತೆ ತುಮೊಮಾ ಭಕ್ತಿವೃದ್ದಿ ಕರಾನೆ, ಪರಿಶುದ್ಧನಾ ಕ್ಹಾತೆ ತುಮಾರಾ ಹಕ್ಕ ಅನುಗ್ರಹ ದಿವಾನೆ ಹಕ್ಕ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ಮಿ ಕಿನು ಕ್ಹೊನು ರುಪ್ಪು ರ‍್ಹೈನೆಕಾ ಫೆರಾವಡಾನೆ ರ‍್ಹಯನೆಕಾ ಆಸ ಕರ‍್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ಮಿ ಮಾರಾ ಸ್ವಂತ ಹತೊಕ್ಹು ಕಾಮ ಕರಿನ, ಮನೆ ಕಮಿ ರ‍್ಹಯಲ ಮಾರಾಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾವೊನೆ ಚಾ಼ಯೆ ಥಯಲ ಪುರಾ ಕರ‍್ಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ಕ್ಹಾರಿ ವಿಷಯಮಾ ಮಿ ತುಮೊನೆ ವಾಟ ದೆಕಾಡ್ಯೊಸ. ತುಮೆ ತಿಮ್ಮಜ಼ ರಾಬಿನ ತಾಕತ ನೈಸೊವಾಲಾವೊನೆ ಮದತ ಕರು; ವರಿ; ಪಡ್ದಿಲಿವಾತಿಬಿ ದಿವಾನುಜ಼ ಹೆಚ್ಕಿ಼ ಆಶಿರ್ವಾದ ವ್ಹೈ, ಕರ್ತಾ ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತ ತೆಜ಼ ಕದಲ ವಾತೊ ಶೆ ಮ್ಹೆಲ್ಯು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ಎ ವಾತೊ ತ್ಯುನೆ ಕದಲ್ಪರ ಉಂದಾ ಗುಡ್ಗಾ ಘಾಲ್ಲಿನ ತ್ಯುನಾ ಕ್ಹಾತೆ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ತ್ಯುನೆ ಕ್ಹಾರಾ ರೊಯಾ ತೆ ಥಯಲ್ಪರ ಪೌಲಾ; ತುಮೆ ಮಾರು ಮ್ಹೊಡು ಹಬ್ದಾತಾ ದೆಕ್ತಾ ನೈ ಕತಾಮಾ, ತ್ಯುನೆ ಕ್ಹಾರಾ ದುಖಿ ಥೈನ, ರೊತಾ ತ್ಯುನೊನೊ ಔಳ್ಗಿಲಿನ ತಿನೆ ಮಟ್ಟಿ ಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ತ್ಯುನೆ ಘನ್ನಾ ದುಖ ಕರಲಿನ ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ ಹಡಗಾ ಲಕ್ಕಾ ತಿನಾ ಕ್ಹಾತೆ ಗೈನ ತಿನೆ ಮೊಕ್ಲಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ಹಮ್ಮೆ ತ್ಯುನೊನೆ ಛೊಡಿನ ಹಡ್ಗೊ ಚ಼ಡಲಪರ ಶಿದಾ ಐನ ಕೊಸ ದ್ವಿಪನೆ ಐನ ಮುಟ್ಯಾ. ಮರನಾದಿನ್ನೆ ರೊದ ದ್ವಿಪನೆ ಗೈನ ತ್ಯಾತಾ ಪತರ ಗಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ತ್ಯಾ ಫೊಯಿನಿಕೆನೆ ಜಾ಼ವಾಲೊ ಎಕ ಹಡಗನೆ ದೆಕ್ಯಾ. ತಿನಾ ಕ್ಹಾತೆ ಜಾ಼ವಾನು ಅಗಾ ಬಡಾಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ಅಗಾ ಕುಪ್ರದ್ವಿಪ ದೆಕಿನ ರೊಡಾಬಗಲ ಚ್ಹೊಡಿ ಸಿರಿಯದೆಶನೆ ಬಗಲ ಗೈನ ತುರ ಗಾಮೆ ಐನ ಉತರ‍್ಯಾ. ಕಾಕದ್ಯಾಮ್ಮ ತ್ಯಾ ಸಾಮನ ಉತಾರಾನು ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ತ್ಯಾ ವಿಶ್ವಾಯೊನೆ ಹುಡಕಿನ, ದೆಕಿನ ಕ್ಹಾತ ದಿನ್ನ ತ್ಯಾ ವ್ಹತ್ಯಾ. ತ್ಯುನೆ ಪವಿತ್ರಾತ್ಮನಿ ಪ್ರೆರಣಾಕ್ಹು ಪೌಲಾನೆ ತು ಯೆರುಸಲೆಮಾ ಪಗ ನಕೊ ಮ್ಹೆಲು ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ತೆ ದಿನೊ ಕ್ಹರೆಲಿನ ಹಮೆ ಜಾ಼ತಾಮಾ ತ್ಯುನೆ ಕ್ಹಾರಾ ತುನಾ ಬಾಕಡ್ಯೊ ಬಚ್ಚಾವೊನಾ ಕ್ಹಾತೆ ಹಮ್ನೊನೆ ಗಾಮ್ತಾ ಭಾರಾ ಐನ ವಳೈನ ದಿದ್ಯಾ. ಹಮ್ಮೆ ಸಮುಂದರನಿ ದಂಡಿಪರ ಐನ ಉಂದಾಘುಡಗಾ ಘಾಲಿನ ಪ್ರಾರ್ಥನಾ ಕರಿನ. ");
INSERT INTO sle_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ಎಕನಾ ಎಕ ವಂದನೆ ಕರಿನ ಹಡ್ಗೊ ಚಡ್ಯಾ. ತ್ಯುನೆ ಪಾಚಾ಼ ಫರಿನ ತ್ಯುನಾ ತ್ಯುನಾ ಘರೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ಹಮ್ಮೆ ತುರ ಗಾಮ್ಮಾತಾ ಗೈನ ಪ್ತೊಲೆಮಾಯನೆ ಮಳ್ಯಾ ಸಮುಂದರ ಪ್ರಯಾಣ ಕರಿನ ಕ್ಹರೆಲಿದ್ಯಾ. ತ್ಯಾತಾ ವಿಸ್ವಾಸಿಯೊನೆ ವಂದಸಿನ ತ್ಯುನಾ ಮಳತ್ತಾ ಎಕ ದಿನ್ನ ರ‍್ಹೈನ, ");
INSERT INTO sle_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ಮರನಾದಿನೆ ಗೈನ ಕೈಸರೈನೆ ಐನ ಸುವಾರ್ತಿಕ ಥಯಲ ಪಿಲಿಪ್ಪನಾ ಘರೆ ಗೈನ ತಿಕನ ವ್ಹತ್ತಾ. ತೆ ತೆ ಯೆರುಸಲೆಮಾ ಸಹಾಯ ಕರಾನಾಹುತಿ ತೆ ಕ್ಹಾತ ಜ಼ನಾವೊಮಾ ಯಕ್ಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ತಿನೆ ಜಾಂಜಿಮಾನ ಥಯಲ ಚಾ಼ರ ಪಟ್ಟಾ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಕ್ಹುದಾನು ಪ್ರವಾದನೆ ಕರಾವಾಲಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ಹಮೆ ತ್ಯಾ ದಕ್ಹ ದಿನ ರ‍್ಹಯೆಲ ಪರ ಅಗಬ ನಾಮನೊ ಕವಾಲೊ ಎಕ ಪ್ರವಾದಿ ಯುದಾಯತೊ ಐಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ತೆ ಹಮನೊ ಕನ ಐನ ಪೌಲಾನೊ ಕಂಬರ ಪಟ್ಟೊ ಕಾಡಿನ ತಿನಾ ಹತೊಪಗೊ ಭಾಂದಿನ ತೆ ಕಂಬರಪಟ್ಟೊ ಕಿನೊವೈ ತಿನೆ ತೆಜ಼ ರಿತಿಮಾ ಯೆರುಸಲೆಮಾ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊಕನಾ ಹತ್ತಮಾ ಒಪಸಿನ ದಿವಾನು ಕೈನ ಪವಿತ್ರಾತ್ಮ ಕವಾಡೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ಕೆಳಮಾ ತೆ ವಾತೊ ಐಕ್ತಾಮಾ ಹಮೆ ವರಿ ತೆ ಜ಼ಗಾವಾಲಾ ವ್ಹೈ. ತು ಯೆರುಸಲೆಮಿನೆ ನೈ ಜೌ ಕೈನ ಪೌಲಾನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ತೆನೈಸೊ ಪೌಲಾ, ತುಮೆ ದುಖ ಕರಲಿನ ಕಾ ಮನೆ ಛಾತಿ ಪ್ಹುಟಾ ವರಕ್ಹು ಕರಾಡಾಸ? ಮಿ ಕರ್ತಾ ಥಯಲ ಯೆಸು ನಾಮ್ಮಹುತಿ ಯೆರುಸಲೆಮಾ ಬೆಡಿಯೊ ಘಲ್ಯಾನಾಹುತಿ ಎಕ ನೈ ಮರಾನೆಬಿ ತಯಾರ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ತೆ ನೈ ಒಪ್ಪಲಕ್ಹು ತಿನಾಹುತಿ ಕರ್ತಾನಿ ಮರ್ಜಿ ಥಾವಾದೆ ಕೈನ ತ್ಯುನೆ ಗಪ ಬೈಟ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ತೆ ದಿನೊ ಥಯಲಪರ ಹಮೆ ತಯ್ಯಾರ ಥೈನ ಯೆರುಸಲೆಮನೆ ಚಾ಼ಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ಕೈಸರೈನಕ್ಹು ದಕ್ಹಾ ಶಿಷ್ಯಾ ಹಮಾರಾ ಕ್ಹಾತೆ ಐನ ಹಮೆ ರ‍್ಹವಾಲಾನಾ ಘರಮಟ್ಟಾ ಹಮ್ನೊನೆ ಬಲೈಲಿನ ಗಯಾ ತೆ ಘರವಾಲಾ ಪೈಲಾ ಶಿಷ್ಯಾಮಾ ಎಕಲೊ ಥಯಲ ಮ್ನಾಸೊನ ಕವಾಲೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ಹಮೆ ಯೆರುಸಲೆಮಿನೆ ಆತಾಮಾ ವಿಸ್ವಾಸಿಯೊ ಹಮೊನೆ ಖುಶಿಕ್ಹು ಮಳೈಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ಮರನ್ನಾ ದಿನ್ನೆ ಪೌಲಾ ಹಮನೊನೆ ಬಲೆಲಿನ ಯಾಕೊಬನೆ ದೆಕಾನಾಹುತಿ ಗಯಾ ತ್ಯಾ ಸಭೆನಾ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ಪೌಲಾ ತ್ಯುನೊನೆ ವಂದನೆ ಕರಿನ ಕ್ಹುದಾ ಕರಲ ಕಾಮಮೊ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊ ಕನ ಹಂಚಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ತ್ಯುನೆ ಕ್ಹಾರಾ ತೆ ಐಕಿನ ಕ್ಹುದಾನಿ ಸ್ತುತಿ ಕರ‍್ಯಾ. ತೆಳಾಮಾ ತ್ಯುನೆ ತಿನೆ ; ಹಜಾರೊ ಯೆಹುದಿಯೊ ಮನಕ್ಹೊ ವಿಸ್ವಾಸಿ ಥಯಾಸ ಕೈನ ತಮೆ ದೆಕಾಡಾತ್ತಾ. ತ್ಯುನೆ ಕ್ಹಾರಾ ಧರಮಶಾಸ್ತ್ರಮಾನಾ ಮನಕ್ಹೊ ಥಯಾಥಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ತುಮೆ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊನಾ ವಚ್ಮಾ಼ ರ‍್ಹಯಲಕ್ಹು ಯಹುದಿಯೊನೆ ತುಮೆ ತಮಾರಾ ಬಚಾವೊನೆ ಖತ್ನಾ ಕರೊನಕೊ. ತಮಾರಿ ಪದ್ದತಿ ಕರಿನ ನಕೊ ಚಾ಼ಲೊ ಕೈನ ಕದ್ಯೊ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನೆ ಕೆಡಸೊ ನಕೊಕೈನ ಬೊದನೆ ಕರಾಡೊತೊ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ತು ಆಯೊತೊ ಕೈನ ತ್ಯುನೆ ಕಿಮ್ಮ ವಳಕ್ಯಾ. ತಿಮ್ಮ ರ‍್ಹಯುಮ ಹಮೆ ಸು ಕರೆಯೆ? ");
INSERT INTO sle_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ತಿಮ್ಮ ರ‍್ಹಯುಮ ಹಮೆ ಕದಲ ಕಾಮ ಕರ. ಹಮೊಮಾ ಕ್ಹಮ ಘಾಲಲವಾಲಾ ಚಾರ ಜ಼ನಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ತು ತ್ಯುನೊನೆ ಬಲೈಲಿನ ಗೈನ ತ್ಯುನಾಕ್ಹಾತೆ ತುನೆಬಿ ಶುದ್ಧಕರಲಿನ ತ್ಯುನೆ ತಿನಾ ಕ್ಷೌರನಿ ಕ್ಹಮ್ಮ ಪುರಾ ಕರಾಹುತಿ ಥಾವೊನಾ ಖರ್ಚೊ ತುಬಿ ದ್ಯು. ತಿಮ್ಮ ಕರ‍್ಯಾಮ ಕ್ಹಾರಾ ತಾರಾ ವಿಷಯಮಾ ತ್ಯುನೆ ಐಕೆಲ ಸುದ್ದಿ ಕ್ಹರಿ ನ್ಹವೈ ಕೈನ ತು ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರನೆ ಕೈದಿನ ಚಾ಼ಲಾಲೊ ಕೈನ ತಿಳಿಲಿದ್ಯಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","\"ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊಮಾ ಯೆಸು ನೆ ನಂಬಲವಲಾನಾಹುತಿ ಬಿ ಮುರ್ತಿನೆ ಚಡಾಯೆಲ ರಗತ, ಗರದನ ಚಿಕಲಿನ ಖಲಾಸ ಕರಲ ಜಾನವರ ಕೌ ನಕೊ ಕೈನ ವ್ಯಬಿಚಾರಕ್ಹು ವರಿ ಅನೈತಿಕ ಸಂಬಂಧಕ್ಹು ಛೊಡಿನ ದುರ ರ‍್ಹೌ ಕೈನ ಕವಾನಾ ಹುತಿ ಫೈಸಲೊ ಕರಲ ಪದ್ದತೊ ಬರ್ದಿನ ಮೊಕಲ್ಯಾಸ್ತೊ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ತೆಳಾಮಾ ಪೌಲಾ ಮರ್ನಾ ದಿನೆ ತೆ ಚಾರ ಜನ್ನಾನಾ ಕ್ಹಾತೆ ಗೈನ ಶುದ್ಧ ರ‍್ಹಯಲ ಪದ್ದತೊ ಪುರಾ ಕರ‍್ಯೊ. ತೆಳಾಮಾ ಶುದ್ಧಚಾರನ್ಯೊ ಪದ್ದತಿಯೊ ಖಲಾಸ ಥಾವಾನಾ ದಿನ್ನಾ ಹುತಿ ಕವಾನಾ ಹುತಿ ದೆವಾಲಯಮಾ ಗಯೊ. ತ್ಯುನೊಮಾ ಹರಯಕ್ಕಲಾನಾ ಹುತಿ ಕೆಳಾಮಾ ಬಲಿ ದ್ಯುಕೈನ ತ್ಯುನೊನೆ ಕೈನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ತೆ ಕ್ಹಾತ ದಿನೊ ಕ್ಹರತಾ ಟೈಮ್ಮಾ ಅಸ್ಯಸಿಮ್ಮೆತೊ ಆಯೆಲ ಯೆಹುದಿಯೊ ಪೌಲಾನೆ ದೆವಾಲಯಮಾ ದೆಕಿನ ತ್ಯಾ ಗುಂಪ ಥಯಲ ಮನಕ್ಹೊನೆ ಸರಕೈನ ತಿನ್ನೆ ಧರಿನ; ");
INSERT INTO sle_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊ, ಮನೆ ಮದತ ಕರೊ, ಅಪಾನಾ ಮನಕ್ಹೊನೆ, ಧರಮಶಾಸ್ತ್ರನೆ, ಯೆ ಆಲಯನಾ ವಿರುದ್ದ ಕ್ಹಾರಿ ಜ಼ಗಾ ಕ್ಹರವೊನೆ ಭೊದನೆ ಕವಾನು ಮನಕ್ಹ ಎಜ಼ ವ್ಹೈ. ಎನೈಸೊ ಗ್ರಿಕವಾಲಾವೊನೆ ದೆವಾಲಯಮಾ ಬಲಲೈನ ಯೆ ಪರಿಶುದ್ಧ ಜ಼ಗಾನೆ ಹೊಲಸ ಕರ‍್ಯೊಸ ಕೈನ ವದ್ರ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ಪೈಲಾ ತ್ಯುನೆ ಎಫೆಸನಾ ತ್ರೊಫಿಮ ತಿನಾ ಕ್ಹಾತೆ ಗಾಮ್ಮಾ ದೆಕಲ ಹುತಿ ತಿನೆ ಪೌಲಾ ದೆವಾಲಯಮಾ ಬಲೈನ ಆಯೊಸ ಕೈನ ತಿಳ್ದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ತೆಳಾಮಾ ಗಾಮಾ ಗದ್ದಲ ಉಟಿನ ಕ್ಹಾರಿ ಬಗಲ ಫೈಲಿ ಜಾ಼ವಸ. ಕ್ಹಾರಿ ಬಗಲ್ತಾ ಮನಕ್ಹೊ ಐನ ತ್ಯಾ ಮಳ್ಯಾ. ಪೌಲಾನೆ ಧರಿ ದೆವಾಲಯನಾ ಭಾರಾ ಯಳ್ದಿಲೈನ ಆಯೆಲ ಪರ ಬಾಕ್ಲೊ ಝಾಕ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ತ್ಯುನೆ ತಿನೆ ಖಲಾಸ ಕರಾನಾ ಹುತಿ ಕೊಶಿಸ ಕರ್ತಾಮಾ ಯೆರುಸೆಲಮಮಾ ಗಲಿಬಿಲ ಥೈನ ಕೈನ ಪಟಾಲಿನ ಅದಿಕಾರಿನೆ ಸುದ್ದಿ ಐ. ");
INSERT INTO sle_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ತೆಳಾಮಾ ತೆ ಸಿಪಾಯಿಯೊನೆ ಶತಾದಿಪತಿಯೊನೆ ಲಿನ ಮನಕ್ಹೊ ಮಳಲ ಜ಼ಗಾ ಆಯೊ. ತ್ಯುನೆ ತೆ ಅದಿಕಾರಿನೆ ಸಿಪಾಯಿಯೊನೆ ದೆಕಿನ ಪೌಲಾನೆ ಮಾರಾನು ಛೊ಼ಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ತೆ ಸೆನಾದಿಪತಿ ತಿನಾ ನಜಿಕ ಐನ ತಿನೆ ಧರಿನ ಬೆಡಿಯೊ ಘಾಲೊ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ; ವರಿ ಎ ಕುನ ವ್ಹೈ? ಸು ಕರ‍್ಯೊಸ? ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ಕೈನ ಪುಚ್ತಾ಼ಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಅಮ್ಮ ದಕ್ಹಾ ಜ಼ನಾ ತಿಮ್ಮ ಅಡ್ತಾಮಾ ಗದ್ದಲನಾ ಹುತಿ ಕ್ಹರಿನಿ ವಾತ ಗ್ವತ್ತ ನೈಸೊ ತಿನೆ ಕೊಟೆಮಾ ಬಲೈಲಿನ ಜಾ಼ವೊ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ಕಾಕದ್ಯಾಮ ಪೌಲಾ ಪೌಟಂಗಿಯೊಪರ ರ‍್ಹತಾಮಾ ಮನಕ್ಹೊ ಢಕ್ಲಾನಾ ಹುತಿ ಸಿಪಾಯಿಯೊ ತಿನೆ ಉಚೈಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ಗುಂಪ ಥೈನ ಮನಕ್ಹೊ ಪಾಚಾ಼ತಾ ಐನ; ತಿನೆ ಖಲಾಸ ಕರೊ ಕೈನ ವದರ್ತಾ ತಿನಾ ಪಾಚಾ಼ ಆವಾಡಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ಪೌಲಾನೆ ಕೊಟೆಮಾ ಬಲೈನ ಲಿನ ಜೌ಼ ಕೈನ ಕತಾಮಾ ತೆ ಅದಿಕಾರಿನೆ ತಾರಾ ಕ್ಹಾತೆ ಯಕ್ಕ ಬೊಲಾನೆ ಮನೆ ಅಪ್ಪಣೆ ದೆಶಿಸು ಕೈನ ತೆ; ಗ್ರಿಕ ಭಾಷಾ ತುನೆ ಆವಸ್ಸು? ");
INSERT INTO sle_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ದಕ್ಹಾ ದಿನ್ನ ಪಾಚಾ಼ ದಂಗೊ ಉಟಲ ತೆ ಚಾರ ಹಜಾ಼ರ ಕೆಟ್ಟ ಮನಕ್ಹೊನೆ ರಾನ್ಮಾ ಬಲೈಲಿನ ಗಯಲ ತೆ ಇಜಿಪ್ತ ತುಜ಼಼ ವ್ಹೈಸು ಕೈನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ತೆ ವಾತೆ ಪೌಲಾ ಉತ್ತರ ದಿದ್ಯೊ \"ಮಿ ಯಹುದಿ, ತಾರ್ಸಮಾ ಹುಟ್ಟವಾಲೊ ವ್ಹೈ. ಕಿಲಿಕ್ಯ ಸಿಮೆನೊ ಪ್ರಖ್ಯಾತ ರ‍್ಹಯಲ ಗಾಮವಾಲೊ ವ್ಹೈ. ಎ ಮನಕ್ಹೊನೆ ದಕ್ಹಿಯೊ ವಾತೊ ಕವಾನೆ ಮನೆ ಮರಗಿನ ಅಪ್ಪಣೆ ಥೌಕೈನ ಮಾಂಗಿಲ್ಯುಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ಸೆನಾಧಿಪತಿ ಅಪ್ಪಣೆ ದೆತಾಮಾ, ಪೌಲಾ ಪೌಟಂಗಿಯೊಪರ ಹುಬ್ರೈನ, ಮನಕ್ಹೊನೆ ಹತ ಕರಿನ ದೆಕಾಡಿನ. ಗದ್ದಲ ಘನ್ನಿಯಳಪರ ಶಾಂತ ಥಯಲ್ಪರ ತೆ ಹಿಬ್ರಿಯ ಭಾಶಾಮಾ ಬೊಲಾನು ಶುರು ಕರ‍್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","\"ವಿಶ್ವಾಸಿಯೊ ವರಿ ಬಾಪೊ, ಹಮ್ನಾ ಮಿ ಕವಾನಿ ಸಮರ್ಥನೆನಿ ವಾತ ವ್ಹೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ತೆ ತ್ಯುನಾ ಕ್ಹಾತೆ ಹಿಬ್ರಿಯ ಭಾಶೆಮಾ ಬೊಲಾನು ಐಕೊ ತ್ಯುನೆ ವರಿ ಶಾಂತ ಥೈಗೈಯಾ. ತೆಳಾಮಾ ತೆ ಸು ಕದ್ಯೊಮ; ");
INSERT INTO sle_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ಮಿ ಯಹುದಿ ವ್ಹೈ. ಕಿಲಿಕ್ಯನಿ ತಾರ್ಸಮಾ ಹುಟ್ಟಲ ವ್ಹೈ,ತೆನೈಸೊ ಎ ಗಾಮ್ಮಾ ಬೆಳದಲವಾಲೊ. ಗಮಲಿಮಾ ಪಾದ ಸನ್ನಿದಿಮಾ, ಅಪ್ನಾ ಪಿತೃವೊನಾ ಧರಮಶಾಸ್ತ್ರಮಾ ಪುರಾ ಶಿಕ್ಷಣ ಲಿದ್ಯೊ; ತುಮೆ ಕ್ಹಾರಾ ಹಮ್ನಾ ಕ್ಹುದಾನಾ ಹುತಿ ಅಭಿಮಾನ ರ‍್ಹಯಲವಾಲಾವೊಲಿಂಗತ, ಮಿಬಿ ಅಭಿಮಾನಿ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ಎ ವಾಟಮಾ ರ‍್ಹಯಲವಾವೊನೆ ತ್ರಾಸ ದಿವಾಲೊ ಥೈನ ದಾಣ್ಗಾವೊನೆ ವರಿ ಬಾಕ್ಡಿಯೊನೆ ಬೆಡಿಯೊ ಘಾಲಿನ, ತ್ಯುನೊನೆ ಜೆಲ್ಮಾ ಘಲಾತೊ ವ್ಹತ್ತೊ, ಖಲಾಸ ಕರಾನೆಬಿ ಪಾಚೊ಼ ಸರಕ್ತೊ ನ್ಹೊತೊ ತೆಕ್ಲೊ ತ್ರಾಸ ದೆತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ಇನಾಹುತಿ ಮಾಹಾ ಯಾಜಕ, ಮ್ಹೊಟಿ ಸಬೆವಾಲಾ ಮನಕ್ಹೊ ಸಾಕ್ಷಿಯೊ ಥಯಾಸ; ತ್ಯುನಾ ಹುತಿಜ಼ ಮಿ ದಮಸ್ಕಮಾ ರ‍್ಹಯಲ ವಿಶ್ವಾಸಿಯೊನೆ ಪತ್ರೊ ಕಾಳ್ಳಿನ, ತ್ಯಾ ಗಯಲವಾಲಾವೊನೆ ಬೆಡಿಯೊಕ್ಹು ಭಾಂದಿನ ಶಿಕ್ಷಾನಾ ಹುತಿ ಯೆರೊಸೆಲಿಮೆ ಲೌ ಕೈನ ಜಾ಼ವಾಲೊ ");
INSERT INTO sle_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ಮಿ ಪ್ರಯಾಣ ಕರ್ತೊ ದಮಸ್ಕನಾ ನಜಿಕ ಆತಾಮಾ ದುಪಾರ ಥೈತಿ ತೆಳಾಮಾ ಹಬಾಳಮಾತು ಯಕ್ಕ ಮ್ಹೊಟು ಉಜಾಲು ಮಾರಾ ಸುತ್ತೆ ಫೈಲಿ ಗಯು. ");
INSERT INTO sle_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ಮಿ ಜಿಮಿನಪರ ಪಡ್ಯೊ ತೆಳಾಮಾ, ಸೌಲಾ, ಸೌಲಾ ಮನೆ ಕಾ ತ್ರಾಸ ದಿವಾಡ್ಯೊಸ? ಕದಲ ಮಿ ಆವಾಜ಼ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ತಿನಾಹುತಿ ತೆ ಉತ್ತರ ದಿದ್ಯೊ; ಕರ್ತಾ, ತು ಕುನ ವ್ಹೈ? ಕೈನ ಪುಚ್ತಾ಼ಮಾ ತೆ; ತು ತ್ರಾಸ ದಿವಾನು ನಜ಼ರೆತನೊ ಯೆಸು ಮಿಜ಼ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ಹುಜಾಲು ಯಕ್ಕಜ಼ ದೆಕ್ಯಾ, ಮರಾ ಕ್ಹಾತೆ ಬೊಲಲವಾಲಾನು ಅವಾಜ಼ ಐಕ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ತೆಳಾಮಾ ಮಿ; ಕರ್ತಾ, ಮಿ ಸು ಕರು? ಕೈನ ಪುಚ್ತಾ಼ಮಾ ಕರ್ತಾ ಮನೆ; ತು ಉಟಿನ ದಮಸ್ಕಮಾ ಜಾ಼. ತು ಸು ಕರು ಕೈನ ಕವಾನು ತುನೆ ತ್ಯಾ ಕವಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ತೆ ಉಜಾಲಾನಿ ಮಹಿಮಾಕ್ಹು ಮನೆ ಡೊಳಾ ನೈ ದಿಕ್ಹಲ ಹುತಿ ಮನಾರಾ ಕ್ಹಾತೆ ರ‍್ಹಯಲವಾಲಾ ಮಾರೊ ಹತ ಧರಿನ ದಮಸ್ಕನಾ ಗಾಮ್ಮಾ ಹತ ಧರಿನ ಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ತೆ ಗಾಮಮಾ ಅನನಿಯ ಕವಾಲೊ ಯಕ್ಕ ತ್ಯಾ ಧರಮಶಾಸ್ತ್ರನೆ ಕರೆಟ್ಟ ಚಾ಼ಲಾಲಾ, ತೆ ಜ಼ಗಾನಾ ಕ್ಹಾರಾ ಯಹುದಿಯೊಕ್ಹು ");
INSERT INTO sle_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ಚೊ಼ಕೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿದಲ ನಾಮ ಅನ್ಯನಿಯ ಕವಾಲೊ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ಹುಬ್ರೈನ; ಭೈ ಥಯಲ ಸೌಲಾ ತಾರಾ ಡೊಳಾ ದಿಕ್ಹಾದೆ. ತೆಳಾಮಾಜ಼ ಮಾರಾ ಡೊಳಾ ದಿಕ್ಹ್ಯಾ, ಮಿ ತಿನೆ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ತೆಳಾಮಾ ತೆ; ಹಮಾರಾ ಪಿತೃವೊನೊ ಬಾ, ತಿನಿ ಚಿತ್ತ ತು ತಿಳ್ದಿಲಿವಾನೆ, ತೆ ಕ್ಹರಿ ರ‍್ಹಯಲವಾಲಾನೆ ದೆಕಾನೆ ತಿನಾ ಮ್ಹೊಡಾಮಾತಿಯೊ ಆವಾನಿಯೊ ವಾತು ಐಕಾನೆ ಮನೆ ನೆಮಶ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ತು ದೆಕಿನ ಐಕಲ ಕ್ಹಾರ ಮನಕ್ಹೊನಾ ಕ್ಹಾಮೊ ತು ಸಾಕ್ಷಿ ಕೌ ");
INSERT INTO sle_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ಹಮ್ನಾ ತು ಕಾ ತಡಾ ಕರಡ್ಯೊಸ? ಉಟಿನ ಕರ್ತಾನು ನಾಮ ಕೈಲಿವಾಲೊ ಥೌ ಕೈನ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿನ ತಾರು ಪಾಪ ಧವೈಲೆ ಕೈನ ಕದ್ಯೊ ತಿನಾಹುತಿ ಪ್ರಾರ್ಥನಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ತೆ ಥಯಲ್ಪರ ಮಿ ಯೆರುಸಲಿಮೆ ಫರಿನ ಐನ ದೆವಾಲಯಮಾ ಪ್ರಾಥನಾ ಕರ್ತಾಮಾ ಯಕ್ಕ ದರ್ಶನ ಥೈಯು. ");
INSERT INTO sle_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ಮಿ ಪ್ರಭುನೆ ದೆಕ್ಯೊ ತೆ; ತು ಭೆಗಿನ ಯೆರುಸೆಲಿಮಾತೊ ಗೈಪಡ ಮರಾಹುತಿ ತು ಕವಾನಿ ಸಾಕ್ಷಿ ತ್ಯುನೆ ವಪ್ಪಿಲೆತಾ ನೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ತಿನಾಹುತಿ ಮಿ,ಕರ್ತಾ, ಕ್ಹಾರಾ ಸಭಾಮಂದಿರಮಾ ತಾರಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾವಾಲಾವೊನೆ, ಮಿ ಜೆಲ್ಮಾ ಘಲಾತೊ ವರಿ ಮಾರ ಕ್ಹಲಾತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ವರಿ ತುನೆ ಸಾಕ್ಷಿಥಯಲ ಸ್ತೆಫನು ರಗತ ನಾಕತಾ ಟೈಮ್ಮಾ, ಮಿ ಕ್ಹಾಮೊ ಹುಬರೈನ ತೆ ಸಮ್ಮತಿಸಿ,ತಿನೆ ಮಾರೆಲವಾಲಾನಾ ವಣಾ ಕಾಯಿದಾಡೊತೊ. ಕವಾನು ತ್ಯುನೆ ಗೊತ್ತಥಯಲವಾಲಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ತೆಳಾಮಾ ಪ್ರಭು ಮನೆ ಕದ್ಯೊ; ತು ಜಾ಼,ಮಿ ದುರ ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊ ಕನ ವಳಾವಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ತ್ಯಾ ಲಕ್ಕಾ ಪೌಲಾನಿಯೊ ವಾತೊ ಕತಾಮಾ ವಾತೊನೆ ಕಾನ ದಿನ್ನ ಐಕ್ಯಾ ಐಕಿನ ಚಾಲಾಡಾ ತಾ. ತೆಳಾಮಾ ತಿನೆ ಜಿಮಿನಮಾತಾ ಭಾರಾಕಾಡಿಪಡು. ತೆ ಜಿತೊ ರ‍್ಹವಾನೆ ಯೊಗ್ಯ ನತಿ ಕೈನ ವದರಿವ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ತ್ಯುನೆ ಅಡತಾ ತ್ಯುನಾ ವಣಾ ಪ್ಹಾಡಿಲೆತಾ ಮಾತಿ ಭಿರಕಾತಾ ");
INSERT INTO sle_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ರೊಮ್ಮನಾ ಶತಾದಿಪತಿ ಆಗನ್ಯೆ ದಿವಸ ಮನಕ್ಹೊ ಪೌಲಾನೆ ವಿರುದ್ದ ಥೈನ ವದರತ್ತಾ ರ‍್ಹತಾಮಾ ಅದಿಕಾರಿ ತಿಳಿದಿಲಿನ ಆತ್ತಾಮಾ ತಿನೆ ಕೊಟೆಮಾ ಲೈನ ಬಾರಕೊಲಕ್ಹು ಮಾರಿನ ವಿಚಾರಣೆ ಕರಿಯೆ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ತ್ಯುನೆ ಪೌಲಾನೆ ಬಾರಕೊಲಕ್ಹು ಭಾಂದಿನ ತಿಕನ ಹುಬರೈಲ ಶತಾದಿಪತಿನೆ ; ರೊಮಾಪುರನೊ ಮನಕ್ಹ ನ್ಯಾಯ ವಿಚಾರ ಕರೆವ್ಯಾಚಿ ಬಾರಕೊಲಕ್ಹು ಮಾರಾ ಲಗಾಡಾನು ಕಯು ನ್ಯಾಯ ವ್ಹೈ? ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ಶತಾಧಿಪತಿ ತೆ ವಾತೊ ಐಕಿನ ಅದಿಕಾರಿಕನ ಗೈನ \"ತು ಸು ಕರುಕೈನ ಛೆ? ತೆ ಮನಕ್ಹ ರೊಮಾಪುರವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ತೆಳಾಮಾ ಅದಿಕಾರಿ ಪೌಲಾನಾ ಕ್ಹಾಮೊ ಐನ. ತು ರೊಮಾಪುರನೊ ಹಕ್ಕದಾರ ವೈಸು \"ಮನೆ ಕೆ ಕೈನ ತಿನೆ ಪುಚ್ಯೊ ತೆ ಹೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ತೆಳಾಮಾ ತೆ ಅದಿಕಾರಿ ಕದ್ಯೊ, ಮಿ ಘನ್ನಾ ದೊಕಡಾ ದಿನ್ನ ತೆ ಹಕ್ಕ ಮಿ ಲಿದ್ಯೊಸ ಕತಾಮಾ ಪೌಲಾ ಮಿತೊ ರೊಮಾಪುರ ಹಕ್ಕದಾರ ಥೈನ ಹುಟೆಲವಾಲೊ ವ್ಹೈ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ತಿನೆ ಮಾರಿನ ವಿಚಾರ ಕರಿನ ಆಯೆಲ ಪರ ತೆಳಾಮಾ ತಿನೆ ಛೊಡಿಪಾಡ್ಯಾ. ತೆನೈಸೊ ತೆ ರೊಮಾಪುರನೊ ಹಕ್ಕದಾರ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿನ ಆತ್ತಾಮಾ ತೆ ತಿನೆ ಭಾಂದಿನ ಘಾಲತ್ತಾಮಾ ಸೆನಾಧಿಪತಿ ನೆ ಬುಚುಕು ಹುಟ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ಮರ್ನಾ ದಿನೆ ಪಾಟೆ ಪೌಲಾನೆ ವಿರುದ್ದ ಯೆಹುದಿಯೊ ಕೈಜ಼ ತಪ್ಪಘಾಲಾನಾ ವಿಷಯಮಾ ಕ್ಹರಿನಿಜ಼ ಸಂಗತಿ ತಿಳದಿಲಿವಾನಾ ಹುತಿ ಅದಿಕಾರಿ ಮರ್ನಾದಿನ್ನೆ ತೆ ತಿನಾ ಬೆಡಿಯೊ ಕಾಡಿನ ಖಾಸ ಯಾಜಕ, ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ಸಬೆವಾಲಾ ಕುಡಿನ ಆವಾನಾ ಹುತಿ ಅಪ್ಪಣೆ ದಿನ ಪೌಲಾನೆ ಬಲೆಲಿನ ಗೈನ ತ್ಯುನಾ ಕ್ಹಾಮೊ ಹುಬಾರಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ತೆಳಾಮಾ ಪೌಲಾ ಫೈಸಲಾ ಕರಲ ಸಬೆವಾಲಾಮಾ ಎಕ್ಕಸವಾ ದೆಕಿನ; ಭಾಯೊ ಮಿ ಆ ದಿನೊಮಾ ಚೊ಼ಕಿ ಸಾಕ್ಷಿಕ್ಹು ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ ಚಾ಼ಲಿಲಿದ್ಯೊ. ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ತಿನಾಹುತಿ ಮಹಾಯಾಜಕ ಅನನಿಯ; ತಿನಾ ಮ್ಹೊಡಾಪರ ಮಾರೊ ಕೈನ ಕ್ಹಾಮಾ ಹುಬರೈಲ ವಾಲಾವೊನೆ ಅಪ್ಪಣೆ ದೆತ್ತಾಮಾ ಪೌಲಾ ತಿನೆ; ");
INSERT INTO sle_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ಚು಼ನ್ನೊ ಮಾರಲ ಗೊಡಿ, ಕ್ಹುದಾ ತುನೆ ಮಾರಸ. ತು ಧರಮಶಾಸ್ತ್ರನಿಂಗತ ಮನೆ ಪೌಸಲೊ ಕರಾನೆ ಬೈಟಿನ ಧರಮಶಾಸ್ತ್ರನಾ ವಿರುದ್ದ ಮನೆ ಮಾರಾನಾ ಹುತಿ ಅಪ್ಪಣೆ ದೆಶಿಸು? ಕದ್ಯೊ ");
INSERT INTO sle_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ಕ್ಹಾಮಾ ಹುಬರೆಲವಾಲಾ; ಕ್ಹುದಾ ನೆಮ್ಸಲ ಮಹಾಯಾಜಕನೆ ತು ಗಾಳೊ ದಿವಾಡ್ಯೊಸು? ಕತಾಮಾ ");
INSERT INTO sle_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ಪೌಲಾ; ಭಾಯೊ ಮಹಾಯಾಜಕಕೊ ಮನೆ ತಿಳದ್ಯಾನ್ಹೊತ್ತಾ. ತಮಾರಾ ಮನಕ್ಹೊಮಾ ಅದಿಪತಿ ಥಯಲ ವಿಷಯಮಾ ಕೆಟ್ಟನು ಬೊಲು ನೈ ಕೈನ ಬರ್ದ್ಯಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ಸಬೆಮಾ ಮನಕ್ಹೊನೆ ದೆಕತ್ತಾಮಾ ದಕ್ಹಾ ಜ಼ನಾ ಸದ್ದುಕಾಯಿವಾಲಾ,ವರಿ ದಕ್ಹಾ ಜ಼ನಾ ಫರಿಸಾಯರೊ,ರಹೆಲ ಪೌಲಾ ದೆಕಿನ; ಮಿ ಪರಿಸಾಯನೊ, ಪರಿಸಾಯನೊ ದಿಕ್ರೊ; ಮರೆಲವಾಲಾ ಪುನರುತಾನ ಥಾವಸ ಕೈನ ಆಸನಾ ಹುತಿ ಫೈಸೊಲೊ ಕರ‍್ಯೊಸೊ. ಕೈನ ವದರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ತೆ ಇಮ ಕತಾಮಾ ಫರಿಸಾಯರೊನೆ, ಸದ್ದುಕಾಯವಲೊನೆ ಬಿ ವಾದ ವಿವಾದ ಹುಟ್ಯು; ಸಬೆಮಾ ಭೆದ ಹುಟ್ಯು. ");
INSERT INTO sle_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ಕಾಕದ್ಯಾಮ, ಪುನರುತ್ಥಾನ ರ‍್ಹವಾದೆ , ದೆವದುತ ರ‍್ಹವಾದೆ, ಅಂಗನೈಸೊ ಆತ್ಮಾ ರ‍್ಹವಾದೆ, ನತಿ ಕೈನ ಸದುಕಾಯವಾಲಾ ಕವಾಲಾ. ತೆನೈಸೊ ಎ ಭಂಬಿ ಛೆ ಕೈನ ಫರಿಸಾಯರೊ ವಪ್ಪಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ತೆಳಾಮಾ ಮ್ಹೊಟಿ ಗದ್ದಲ ಥೈ. ಫರಿಸಾಯರನಾ ಬಗಲ್ತಾ ರಹೆಲವಾಲಾ ಶಾಸ್ತ್ರಿಯೊಮಾ ದಕ್ಹಾಜ಼಼ನಾ ಉಟಿನ\"ತೆ ಮನಕ್ಹಮಾ ಹಮ್ಮನೊನೆ ಕೆಟ್ಟ ಸುಜ಼ ದಿಕ್ಹ್ಯು ನತ್ತಿ”, ಆತ್ಮಾ ರ‍್ಹವಾದೆ ದೆವದುತ ರ‍್ಹವಾದೆ ತಿನಾ ಕ್ಹಾತೆ ಬೊಲ್ಯಾತಬಿ ಬೊಲ್ಯೊವಸ ಕೈನ ವಾದಿಸ್ಯಾ, ");
INSERT INTO sle_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ಲಡಯಿ ಘನಿ ಥಾತಾಮಾ ತ್ಯುನೆ ಪೌಲಾನೆ ಯಳ್ದಿನ ಚುರ-ಚುರ ಕರಸ ಕೈನ ಅದಿಕಾರಿ ಬುಚಕಿನ ಸಿಪಾಯೊನೆ ತುಮೆ ಗೈನ ತ್ಯುನಾ ವಚ಼ಮಾತ್ತಾ ತಿನೆ ಝಬರದಸ್ತಿ ಕರಿನ ಧರಲೈನ ಕೊಟೆಮಾ ಘಾಲುಕೈನ ಅಪ್ಪಣೆ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ಕೈನ ತೆ ರಾತೆ ಕರ್ತಾ ಪೌಲಾನಾ ಕ್ಹಾತೆ ಹುಬರೈನ \"ಧೈರ್ಯಕ್ಹು ರ‍್ಹೊ; ತು ಯೆರುಸೆಲಿಮ್ಮಾ ಮಾರಾ ಸಂಗತಿಯೊ ಸಾಕ್ಷಿಯೊ ಥೈಯೆಲ ಕ್ಹು ರೊಮಾಪುರಮಾ ಬಿ ಸಾಕ್ಷಿ ಥೌ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ಪಾಟ ಥಯಲಪರ ಯೆಹುದಿಯೊ ಮ್ಹೈ ವಿಚಾರ ಕರಿನ ಹಮೆ ಪೌಲಾನೆ ಖಲಾಸ ಕರೆಲಕ್ಕಾ ಅನ್ನ ಪಾನಿ ನೈ ಮುಟತ್ತಾ ಕರಿನ ಕ್ಹಮ ಘಾಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ಅಮ್ಮ ಕರೆಲವಾಲಾ ಚಾಳಾಕ್ಹತಿ ಹೆಚ್ಚಕಿ ಮಂದಿ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ತೆ ಮುಖ್ಯಯಾಜಕ ವರಿ ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ಕನ ಗೈನ; ಹಮೆ ಪೌಲಾನೆ ಮಾರೆ ಮಟ್ಟಾ ಮ್ಹೊಡಾಮಾ ಸುಜ಼ ನೈ ಘಾಲ್ಲೆತಾ ಕೈನ ಕ್ಹಮ್ಮ ಘಾಲ್ಯಾಸ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ತಿನಾಹುತಿ ತುಮೆಬಿ ವರಿ ನ್ಯಾಯ ಸಭೆವಾಲಾ ರೊಮನ ಶತಾಧಿಪತಿ ಕನ ಗೈನ ಪೌಲಾನಿ ಸಂಗತಿನೆ ಹಜು಼ನ ನಿಧಾನಕರಿನ ಪರಿಶಿಲನೆ ಕರಿನ ತಿನೆ ಕೊಟೆಮಾ ತುಕನ ಬಲೈನ ಔಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ಹಮೆತೊ ತಿನಾ ಕ್ಹಾಮಾ ಆವಾತಿ ಪೈಲಾ ತಿನೆ ಮಾರಾನೆ ತಯ್ಯಾರ ಥಯಾಸ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ತ್ಯುನೆ ವಿಚಾರ ಕರಲ ಪೌಲಾನೊ ಭೆನನೊ ದಿಕ್ರೊ (ಭತ್ರಿಜೊ಼) ಐಕಿನ ಕೊಟೆಮಾ ಗೈನ ಪೌಲಾನೆ ಎ ಸುದ್ದಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ಪೌಲಾ ಅದಿಕಾರಿಯೊಮಾನಾ ಯಕಲಾನೆ ಬಲೈನ ;ಆ ಜಾಂಜಿಮಾನನೆ ಅದಿಕಾರಿ ಕನ ಬಲಲಿನ ಜಾ಼; ತಿನೆ ತಿಳಸಾವೊನಿ ಯಕ್ಕ ವಾತ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ತಿನೆ ಅದಿಕಾರಿ ಕನ ಲಿನಗೈನ ಜೆಲಮಾ ರ‍್ಹಯೆಲ ಪೌಲಾ ಮನೆ ಬಲೈನ ಕದ್ಯೊ ಆ ಜಾಂಜಿಮಾನ ತುಕನ ಬಲೆಲಿನ ಜಾ಼ ಕೈನ ಮಾಂಗಿಲಿದ್ಯೊ. ತುನೆ ಕವಾನಿ ಯಕ್ಕ ವಾತ ಛೆ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ಅದಿಕಾರಿ ತಿನೆ ಹತ್ತಧರಲಿನ ಕುನಜ ನೈಸೊ ಜ಼ಗಾ ಬಲೆಲಿಂಗನ \"ತು ಮನೆ ಕವಾನು ಸುವೈ ಕನ ಪುಚ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ತೆ ಯೆಹುದಿಯೊ ಪೌಲಾನಾ ಹುತಿ ಹಜು಼ನಬಿ ಚೊ಼ಕಿತರಾ ಒಳಕಿನ ನೆವಾ ಕೈನ ತುಮೆ ವ್ಹಂತಾ ತಿನೆ ನ್ಯಾಯಸಭೆನಾ ಕ್ಹಾಮಾ ಬಲೆ ಲೌಕೈನ ಪುಚ್ಚು಼ ಕೈನ ಒಪ್ಪಂದ ಕರಲಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ತುಮೆ ತ್ಯುನಾ ವಾತೆ ಒಪಿಲ್ಯು ನಕೊ ಕಾಕದ್ಯಾಮ್ಮ ಚಾಳಕ್ಹತಿ ಹೆಚ್ಚಗಿ ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊ ತಿನೆ ಖಲಾಸ ಕರೆ ಮಟಾ ಅನ್ನ ಪಾನಿ ಸುಬಿ ನೈ ಮುಟತ್ತಾ ಕೈನ ಕ್ಹಮ ಘಾಲಿನ ತಿನಾ ಹುತಿ ಪ್ಲಾನ ಕರ‍್ಯಾಸ. ತ್ಯುನೆ ತುಮಾರಾ ಪೈಸಲಾನಾ ಹುತಿ ಐಕಾನೆ ತಯಾರ ಥಯಾಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ತೆಳಾಮಾ ತೆ ಅದಿಕಾರಿ ತೆ ಜಾಂಜಿಮಾನೆ ಕದ್ಯೊ ಆ ಸಂಗತಿಯೊ ಮನೆ ಗೊತ್ತ ಥಯಲ ತು ಕಿಕನಜ಼ ಕೌನಕೊ ಕೈನ ಅಪ್ಪಣೆ ದಿನ್ನ ಕೈನ ತಿನೆ ಮೊಕ್ಲಿಪಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ತೆ ಥಯಪರ ತೆ ಶತಾದಿಪತಿಮಾನಾ ಬೆ ಜ಼ನಾವೊನೆ ಬಲಲಿನ ರಾತ್ತೆ ನೌವಸ್ತಾ ಕೈಸರ ಲಕ್ಕಾ ಜೌಕೈನ ಬೆಕ್ಹೊ ಜ಼ನಾ ಸಿಪಾಯಿನೊ ಸತ್ತರಜ಼ನಾ ಘೊಡಾಪರ ಬೈಟವಾಲಾವೊನೆ ಬೆಕ್ಹೊಜ಼ನಾ ಇಟಿ ದ್ಹರಲ ಸೈನಿಕೊನೆ ತಯಾರ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ವರಿ ಘೊಡಾವೊನೆ ಸಿದ್ದಕರ‍್ಯೊ,ಪೌಲಾನೆ ಚಡೈನ, ದೆಶಾದಿಪತಿ ಥಯಲ ಫೆಲಿಕ್ಸ ಕನ ಸುರಕ್ಷಿತಕ್ಹು ಬಲಿನ ಜೌ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ಸೆನಾದಿಪತಿ ತೆ ಇನಾನಿಂಗತ ಯಕ್ಕ ಪತ್ರ ಬರ್ದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ಮ್ಹೊಟೊ ಪ್ರತಾಪಿ ರಹೆಲ ಫೆಲಿಕ್ಸ ರಾಜ್ಯಪಾಲನೆ ಕ್ಲೌದಿಯೊಸ ಲಿಸಿಯಸನೆ ನಮಸ್ಕಾರ\" ");
INSERT INTO sle_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ಯೆಹುದಿಯೊ ತೆ ಮನಕ್ಹನೆ ಧರಿನ ಕಲಾಸ ಕರು ಕೈನ, ಮಿ ಸಿಪಾಯಿನಾ ಕ್ಹಾತೆ ಗೈನ ತಿನೆ ರೊಮಾಪುರನೊ ಹಕ್ಕದಾರ ವ್ಹೈ ಕೈನ ತಿನೆ ತಪಿಸ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ತೆನೈಸೊ ತಿನಾ ಉಪ್ಪರ ತಪ್ಪ ಘಾಲೆಲ ಕಾರಣ ತಿಳಸಾನಾ ಹುತಿ ತಿನೆ ತ್ಯುನಾ ನ್ಯಾಯ ಸಭೆನೆ ಬಲೈಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ತ್ಯಾ ತ್ಯುನೆ ಧರಮಶಾಸ್ತ್ರಾನಾ ವಿಷಯ ಧರ್ಲಿನ ತಿನಾ ವಿರುದ್ದ ತಪ್ಪ ಯಕಜ ಘಾಲ್ಯಾ ತೆನೈಸೊ ಮಾರಾನಿ ಶಿಕ್ಷಾ ರ‍್ಹೈನೆಕಾ ಬೆಡಿಯೊಕ್ಹು ಭಾಂದಾನು ರ‍್ಹೈನೆಕಾ ತಿನಾ ತಕ ಕಯುಜ಼ ಅಪರಾದ ರ‍್ಹೈನೆಕಾ ಘಾಲಾನೆ ಸ ಮನೆ ಧಿಕ್ಹಿನ ಐಯು. ");
INSERT INTO sle_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ತೆ ಮನಕ್ಹನಾ ವಿರುದ್ದ ಥೈನ ಮ್ಹೈ ಪ್ಲಾನ ಘಾಲಾನಾ ಹುತಿ ಮನೆ ತಿಳ್ದಿನ ಆತ್ತಾಟೆಮ್ಮಾ, ಮಿ ತಿನೆ ತುಕನ ವಳಾಯಾಸ, ತಿನಾ ವಿರುದ್ದ ತಪ್ಪ ಘಲಾವಾಲಾ ತಾರಾ ಕ್ಹಾಮಾ ತಿನಾ ವಿರುದ್ದ ಥಯಲ ಒಪಿಲಿವಾಲಾನಿಂತ ಅಪ್ಪಣೆ ದಿದ್ಯೊ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ಸಿಪಾಯಿಯೊ ತ್ಯುನೊನೆ ಅಪ್ಪಣೆ ಥಯಲ ರಾತಮಾ ಪೌಲಾನೆ ಅಂತಿಪತ್ರಿನಾ ಗಾಮೆ ಬಲೆಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ಮರನಾದಿನೆ ತ್ಯುನೆ ಸವಾರನೆ ತಿನಾ ಕ್ಹಾತೆ ಜಾ಼ವಾ ವರಕ್ಹು ಕರಿನ,ತ್ಯುನೆ ಪಾಚಾಫರಿನ ಕೊಟೆಮಾ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ಕೈಸರೈನೆ ಐನ ದೆಶಾದಿಪತಿನೆ ಪತ್ರ ಒಪಸಿನ, ಪೌಲಾನೆ ತಿನಾ ಕ್ಹಾಮಾ ಹುಬರಾಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ದೆಶಾದಿಪತಿ ತೆ ಕಾಗತ ಒದಿನ ಪೌಲಾ ಕಯೊ ಸಿಮೆನೊ ವ್ಹೈ? ಕೈನ ಪುಚಿ಼ನ ತೆ ಕಿಲಿಕ್ಯವಾಲೊ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿನ; ");
INSERT INTO sle_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","\"ತುಪರ ತಪ್ಪ ಕದಲವಾಲಾ ಆಯೆಲ ಪರ, ತಾರು ಕಾರ್ಯ ಪುರಾ ವಿಚಾರ ಕರುಸ ಕೈನ ಕದ್ಯೊ, ತಿನೆ ಹೆರೊದನಾ ಜೆಲಮಾಘಾಲಿನ ಕೈದು ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ಪಾಂಚ಼ ದಿನ್ನ ಥಯಲ್ಪರ ಮ್ಹೊಟೊ ಯಾಜಕ ಥಯಲ ಅನನಿಯಾ ಶಾನಾವೊಮಾ ದಕ್ಹಾಜ಼಼ನಾವೊಮಾ ತೆರ್ತುಲ ಕವಾಲೊ ಯಕ್ಕ ವಕಿಲನೆ ಬಲೈಲೈನ, ಪೌಲಾನಾ ವಿರುದ್ದ ದೆಶಾದಿಪತಿನೆ ದುರ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ಪೌಲಾನೆ ಬಲಾಯಲ್ಪರ ತೆರ್ತುಲ್ಯ ತಿಪರ ತಪ್ಪ ಘಾಲಾನೆ ಶುರು ಕರಿನ ಅಮ್ಮ ಕದ್ಯೊ\"ಮ್ಹೊಟೊ ಶ್ರೆಷ್ಠ ರ‍್ಹಯಲ ಫೆಲಿಕ್ಸ, ತಾರಾ ಮುಲಕ ಹಮೊನೆ ಘನ್ನು ಸಮಾಧಾನ ಹುಟ್ಟಸ ಕೈನ, ತಾರಿ ಅಗ್ಲಿ ವಿಚಾರನಾ ಹುತಿ ಎ ದೆಶನಾ ಮನಕ್ಹೊನೆ ಕ್ಹಾರಿ ತರಾಮಾ ಕ್ಹಾರಿ ಜ಼ಗಾಮಾ, ತುಟ್ಟಿ ಗಯೆಲ ಸಂಗತಿಯೊನೆ ಸುಧಾರಣೆ ಥಾವಾನಾ ಹುತಿ ");
INSERT INTO sle_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ಹಮೆ ಎ ಉಪಕಾರ ಕೃತಜ್ಙತೆಕ್ಹು ವಪ್ಪಿಲಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ತೆನೈಸೊ ತುನೆ ಬೆಜ್ಜಾರ ಕರಾನು ಹಮೊನೆ ಮನಸ ನೈಸೊ ಹಮೆ ಖುಲ್ಲಾ ಕವಾನಿಯೊ ವಾತೊ ಮರ್ಗಾಕ್ಹು ಐಕು ಕೈನ ಮಾಂಗಿಲಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ಎ ಮನಕ್ಹಮಾ ಅಪಾಯ ದೆಕ್ಯಾ. ದುನಿಮ್ಮಾ ಕ್ಹಾರಿ ಜ಼ಗಾ ರ‍್ಹಯಲ ಯೆಹುದಿಯೊಮಾ ದಂಗೊ ಉಟಾಡಸ ಕವಾನು, ನಜರೆನ ಕವಾನು ಪಂಥನೊ ನಾಯಕ ವ್ಹೈ ಕೈನ ದೆಕ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ಯಕ್ಲುಜ಼ ನೈಸೊ ತೆ ಮನಕ್ಹ, ದೆವಾಲಯಮಾ ಹೊಲಸ ಕರಾನೆ ಕೊಶಿಶ ಕರ‍್ಯೊ. ತಿನಾಹುತಿ ಹಮೆ ತಿನೆ ಧರಿನೆ ಘ್ಯಾಲ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ತೆನೈಸೊ ಸಹಸ್ರಾದಿ ಪತಿ ಥಯಲ ಲುಸ್ಯನ ವಚ್ಮಾ಼ ಐನ ಜ಼ಬರದಸ್ತಿ ಕರಿನ ತಿನೆ ಹಮಾರಾ ಹತೊಮಾತೊ ಛೊಡೈಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ಇನೆ ತುಜ಼಼ ವಿಚಾರ ಕರ‍್ಯೊಮ, ಹಮೆ ಇನಾ ಉಪ್ಪರ ಘಾಲಲ ತಪ್ಪೊ ಕ್ಹರಿ ವ್ಹೈ ಸು ಸುಳ್ಳ ವ್ಹೈಸು ಇನಾಕ್ಹು ವಳಕಿಲಿಯೆಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ತೆಳಾಮಾ ಯಹುದಿಯೊ ವಕಿಲನಾ ಕ್ಹಾತೆ ಮಳಿನ ಸಂಗತಿಯೊ ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ತ್ಯುನೆ ತೆ ದೊಶಾರೊಪಣೆ ಕರಾಲಾವೊನಾ ಕ್ಹಾತೆ ಮಳ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ದೆಶಾದಿಪತಿ ಪೌಲಾನೆ, ತು ಬೊಲಸಕ್ಸಿ ಸ್ವನ್ನಿ ಕರ್ತಾಮಾ, ತೆ ಫರಿನ ಉತ್ತರ ಸು ದಿದ್ಯೊ ಕದ್ಯಾಮ; ತು ಘನ್ನಾ ವರಕ್ಹತೊ ಎ ದೆಶನಾ ಮನಕ್ಹೊನೆ ನ್ಯಾಯಾದಿ ಪತಿ ಥೈನ ರ‍್ಹೌ ಕೈನ, ಕೈನ ತಿಳದಿಲಿನ ಮಿ ಖುಶಿಕ್ಹು ಪ್ರತಿವಾದ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ಮಿ ಕ್ಹುದಾನಿ ಅರಾಧಾನಾ ಕರಾನಾಹುತಿ ಯೆರುಸೆಲೆಮೆ ಗೈನ, ಕ್ಹಾಲಿ ಬಾರಾ ದಿನ್ನ ಥಯಾಸ ಕೈನ ತು ತಿಳ್ದಿಲೆಸಕ್ಸಿ. ");
INSERT INTO sle_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ತ್ಯಾ ದೆವಾಲಯಮಾ ರ‍್ಹೈನೆಕಾ, ಸಭಾಮಂದಿರಮಾ ರ‍್ಹೈನೆಕಾ, ಗಾಮ್ಮಾ ರ‍್ಹೈನೆಕಾ, ಯೆಹುದಿನಾ ಕ್ಹಾತೆ ವಾದಾ ಕರಾನು, ನೈತೊ ಮನಕ್ಹೊನು ಗುಂಪ ಮಳಾವಾನು ಇವ್ನೆ ದೆಕ್ಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ಎನೈಸೊ ಇವ್ನೆ ಮಪರ ಘಾಲಾನು ತಪ್ಪೊ ಸಾಬಿತ ಕರಾನಾಹುತಿ ತಾರಾ ಕ್ಹಾಮಾ ತುನೆ ದೆಕಾಡಿನ ದೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ಯಕ್ತೊ ತಾರಾ ಕ್ಹಾಮೊ ವಪ್ಪಿಲ್ಯುಸ, ತೆ ಸು ವ್ಹೈ ಕದ್ಯಾಮ;ಇವ್ನೆ ಮನೆ ಧರ್ಮನೊ ವಿರೊದಿ ವ್ಹೈ ಕೈನ ಕವಾನು, ಮಿತೊ ಮಾರಾ ಪಿತೃ ಆರಾಧನ ಕರಾನಾ ಕ್ಹುದಾನೆಜ಼ ಮಿ ಆರಾದಾನಾ ಕರಾಲೊ ಥಯೊಸ. ಮೊಶೆನು ಧರ್ಮ ಶಾಸ್ತ್ರನಾ ಲಿಂಗತ ರ‍್ಹಯಲ ವರಿ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥೊಮಾ ಬರ್ದಲ ಕ್ಹಾರಿ ವಿಷಯನಾ ಹುತಿ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ತೆನೈಸೊ ನಿತಿವಂತವಾಲಾವೊನೆ ವರಿ ಅನಿತಿವಂತವಾಲಾವೊನೆ ಪುನರುತ್ಥಾನ ಥಾವಾಸ ಕೈನ ಇನ್ವೆ ಕ್ಹುದಾಪರ ಬರಿಕ್ಹೊ ಮ್ಹೆಲಲ ಲಿಂಗತಜ಼ ಮಿಬಿ ಆಸ ಮ್ಹೆಲಲವಾಲೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ಇನಾಹುತಿ ಕ್ಹುದಾನಾ ಕ್ಹಾಮಾ ಶುದ್ಧ ಮನಸಕ್ಹು ರ‍್ಹವಾನೆ ಮನಸಾಕ್ಷಿಲಿಂಗತ ಮಿ ಕೆಳಾಮಾಬಿ ಮನೆ ಥಾವಾಕ್ಲು ಕೆಳಮ್ಮಾನಿ ಕೊಶಿಷ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ದಕ್ಹಾ ವರಕ್ಹ ಥಯಲ್ಪರ, ಯೆರುಸಲೆಮ್ಮಾ ರ‍್ಹಹೆಲವಾಲಾವೊನೆ ದೊಕಡಾ ವರಿ ಕಾಣಿಕೆ ಯಜ್ಞನೆ ಒಪ್ಪಿಸಾನಾಹುತಿ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ಮಿ ಶುದ್ಧಿಕರಿಲಿದಲ ಲಿಂಗತ, ತೆ ವಪಸ್ತಾಮಾ,ತ್ಯುನೆ ಮನೆ ದೆವಾಲಯಮಾ ದೆಕ್ಯಾ, ತೆಳಾಮಾ ಮಾರಾಕ್ಹಾತೆ ಮನಕ್ಹೊನು ಗುಂಪ ನ್ಹೊತು. ಗದ್ದಲಬಿ ನ್ಹೊತಿ. ಮನೆ ದೆಕಲವಾಲಾ. ");
INSERT INTO sle_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ಆಸ್ಯಸಿಮೆತ್ತಾ ಆಯೆಲವಾಲಾ ದಕ್ಹಾ ಯೆಹುದಿಯೊ ವ್ಹೈ. ಮಾರಾ ವಿರುದ್ದ ತ್ಯುನೊನೆ ಸುಬಿ ರ‍್ಹೈಯುಮ, ತ್ಯುನೆ ಕ್ಹಾಮಾ ಅಪರಾದ ಘಾಲಾನಾ ಹುತಿ ನ್ಹ್ಯಾ ಆವಾನ ವ್ಹತು. ");
INSERT INTO sle_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ನೈರ‍್ಹತಾಮ್ಮಾ ಮಿ ನ್ಯಾಯ ಸಬೆನಾ ಕ್ಹಾಮೊ ಹುಬ್ರೆತಾಮಾ, ಮಾರಾಮಾ ಅಪರಾದ ದಿಕ್ಹ್ಯುಮ ಇವ್ನೆಜ಼ ಕವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ಮಿ ಇವ್ನಾ ವಚ್ಮಾ಼ ಹುಬ್ರ್ಯೆನ; ಮರಿನ ಪುನರುತ್ಥಾನ ಥಾವಸ ಕೈನ ನಂಬಾನಾಹುತಿ ತುಮೊಕ್ಹೊ ಮನೆ ವಿಚಾರಣೆನೆ ಗುರಿ ಥಾವಾಸ’ ಕೈನ ಜೊ಼ರ ವದ್ರಿನ ಕದಲ ಹುತಿ ಕೌ ಯಕ್ಕಜ಼ ತೆನೈಸೊ ಬಿಜು಼ ಸುಜ಼ ಕತಾ ನೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ಫೆಲಿಕ್ಸ ಎ ವಾಟ, ತಕ್ಕ ಟೈಮ್ಮ ತಿಳದಿಲಿದಲ ರ‍್ಹಯೊತಬಿ ತ್ಯುನೊನೆ; ತಿರ್ಮಾನ ಕರುಸ ಕೈನ, ಫೈಸ್ಲೊ ಕರಾನೆ ನಿರ್ಧಾರ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ತೆ ಥಯಲ್ಪರ ಪೌಲಾನೆ ಕಾವಲಮಾ ಮ್ಹೆಲು ಕೈನ, ಆದರೆ ಕಟ್ಟು ನಿಟ್ಟ ನಕೊ ಚಾ಼ಯೆ ಕೈನ, ತಿನೆ ರ‍್ಹಯೆಲ ದೊಸ್ತೊನೆ ತಿನೆ ಉಪಚಾರ ಕರಾನು, ಅಡ್ಡಿಕರು ನೈ ಕೈನ ಶತಾದಿಪತಿನೆ ಅಪ್ಪಣೆ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ದಕ್ಹಾ ದಿನ್ನ ಥಯಲ್ಪರ ಫೆಲಿಕ್ಸ, ಯಹುದಿಯೊನೆ ರ‍್ಹಯಲ ದ್ರೊಸಿಲ್ಲ ಕವಾಲಿ ಬಾಕ್ಡಿ ತಿನಾ ಕ್ಹಾತೆ ಐನ, ಪೌಲಾನೆ ಬಲೈನ ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ಮ್ಹೆಲಾನಾ ಬರೊಕ್ಹಾನಾ ಹುತಿ ತೆ ಕವಾನಿ ವಾತೊ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ತಿನಾಹುತಿ ತ್ಯಾಂತೊ ಗೈನ ಪೌಲಾ ಸ್ವ ನಿಯಂತ್ರಣ ವರಿ ಅಗು ಥಾವಾನು ಚೊ಼ಕಾನಾಹುತಿ ಚೆರ್ಚಾ ಕರಿನಾಹುತಿ ಇವ್ನಾ ಹುತಿ ಕತಾಮಾ ಫೆಲಿಕ್ಸ ಭುಚಿ಼ಕಿನ ತಿನೆ; ತೆ ಕವಸ ಹಮ್ನಾ ತು ಜಾ಼; ಮಿ ತುನೆ ಟೈಮ ಮಳಲಪರ ತುನೆ ಬಲೌಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ತೆಜ಼ ಟೈಮ್ಮಾ ತೆ ಪೌಲಾನೆ ಸುಬಿ ತಿನೆ ಸುಬಿ ದೊಕ್ಡಾ ದೆಸ ಕೈನ ಆಸ ಕರಿನ, ತೆಳಾಮಾ ತಿನೆ ಬಲೈನ ತಿನಾ ಕ್ಹಾತೆ ಸಲ್ಲಾಪ ಕರ್ತೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ಬೆ ವರಕ್ಹ ಥಯಲ್ಪರ ಫೆಲಿಕ್ಸನಿ ಜ಼ಗಾಪರ ಪೊರ್ಕಿಯ ಪೆಸ್ತನ ಕವಾನೊ ರಾಜ್ಯಾಪಾಲ ಆಯೊ. ಫೆಲಕ್ಸ ಯಹುದಿಯೊನಿ ಮಯಾ ಗಳಸು ಕೈನ ಪೌಲಾನೆ ಜೆಲ್ಮಾಜ಼ ಮ್ಹೆಲಿನ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ಫೆಸ್ತಾ ಅದಿಕಾರ ಹೊಂದೆಲ ಪರ ತನ ದಿನ್ನ ಥಯಲಪರ ಕೈಸರೈತೊ ಯೆರುಸಲೆಮ್ಮೆ ಗಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ತ್ಯಾ ಖಾಸ ಯಾಜಕವೊ, ಯೆಹುದಿಯೊನಾ ಮ್ಹೊಟಾ ತಿನೆ ಪೌಲಾನಾ ಉಪ್ಪರ ತಪ್ಪಕೈನ ಯೆರುಸಲೆಮ್ಮಾ ವಳೌ ಕೈನ ಫೆಸ್ತ ಕನ ಮಾಂಗಿಲಿದ್ಯಾ, ");
INSERT INTO sle_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ಕಾಕದ್ಯಾಮ್ಮಾ ಯೆರುಸಲೆಮ್ಮಾ ಜಾತ್ತಾಮ್ಮಾ ರಸ್ತಾಮ್ಮಾ ತಿನೆ ಮಾರಾನಾ ಹುತಿ ವಿಚಾರ ಕರ‍್ಯಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ಫೆಸ್ತ ಅಮ್ಮ ಕದ್ಯೊ;ಪೌಲಾ ಕೈಸರೈನಾ ಜೆಲಮ್ಮಾ ಛೆ,ಮಿ ತ್ಯಾ ಜಲದಿ ಜೌ ಕೈನ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ತಿನಾಹುತಿ, ತಮಾರಾಮ್ಮಾ ಖಾಸ, ಮಾರಾಕ್ಹಾತೆ ಕೈಸರೈಮ್ಮಾ ಐನ ತೆ ಮನಕ್ಹಮಾ ಅಪರಾದ ಕೈಬಿ ರ‍್ಹೈಮ್ಮ ತಿನಾ ಉಪ್ಪರ ತಪ್ಪ ಘಾಲಾಂದೆ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ತೆ ಯೆರುಸಲೆಮ್ಮಾ ಆಟ ದಕ್ಹತಿ ಹೆಚ್ಕಿ ದಿನೊ ಹುಬರಯಾವಾಚಿ ಕೈಸರೈನೆ ಗೈನ ಮರನಾದಿನೆ ಫೆಸ್ತ ಫೈಸಲಾನಿ ಜ಼ಗಾ ಬೈಟಿನ, ಪೌಲಾನೆ ಬಲೆಲಿನ ಆವೊ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ತೆ ಆತ್ತಾ ಟೆಮ್ಮಾ ಯೆರುಸಲೆಮಾತ್ತಾ ಆಯೆಲ ಯೆಹುದಿಯೊ, ತಿನಾ ಸುತ್ತೆ ಹುಬರೈನ ತ್ಯುನೆ ಸಾಬಿತ ನೈಥಯಲ ಘನ್ನಾ ಮ್ಹೊಟಾ ಮ್ಹೊಟಾ ತಪ್ಪೊ ಘಾಲತ್ತಾ ಟೆಮ್ಮಾ, ತ್ಯುನೊನೆ ತೆ ಯಕ್ಕಬಿ ಸಾಬಿತ ಕರಾನೆ ಥೈಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ತೆನೈಸೊ ಪೌಲಾ;ಯೆಹುದಿಯೊ ಧರಮಶಾಸ್ತ್ರನಾ ವಿಷಯಮ್ಮಾ ರ‍್ಹಂದೆ ದೆವಾಲಯನಿ ವಿಷಯಮ್ಮಾ ಥಾವಾಂದೆ, ಚಕ್ರವರ್ತಿನಾ ವಿಷಯಮ್ಮಾ ಥಾವಾಂದೆ, ಮಿ ಸುಜ಼ ತಪ್ಪ ನತಿ ಕರ‍್ಯೊ ಕೈನ ಉತ್ತರ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ತೆನೈಸೊ ಫೆಸ್ತಾ ಯೆಹುದಿಯೊನಿ ಮಯಾ ಗಳಸಿಲ್ಯು ಕೈನ ಆಸ ಮ್ಹೆಲಿನ ಪೌಲಾನೆ; ತು ಯೆರುಸಲೆಮನೆ ಜಾ಼ವಾವು ಕೊಶಿಶ ಕರತ್ತಾಮ್ಮಾ ತ್ಯಾ ಆ ಕಾಮನಾ ವಿಷಯಮ್ಮಾ ಮಾರಾ ಕ್ಹಾಮೊ ವಿಚಾರ ಕರಾನೆ ತುನೆ ಮನಸಚೆ? ಕೈನ ಪುಚತ್ತಾಮ್ಮಾ, ಪೌಲಾ; ");
INSERT INTO sle_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ಮಿ ಪೌಲಾ ಕದ್ಯೊ ಚಕ್ರವರ್ತಿ ಥಯಲ ಕೈಸರೈನಾ ಫೈಸಲಾನಿ ಜ಼ಗಾನಾ ಕ್ಹಾಮೊ ಹುಬರಯೊಸ; ನ್ಹ್ಯಾಜ಼ ಮಾರು ವಿಚಾರಣೆ ಥೌ. ಯೆಹುದಿಯೊನೆ ಮಿ ಅನ್ಯಾಯ ನತಿ ಕರ‍್ಯೊ; ತೆ ತುನೆಬಿ ಚೊ಼ಕಿತರಾ ಗೊತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ಮಿ ಧರಮಶಾಸ್ತ್ರಾನೆ ವಿರೊದ್ದ ಥಯೊಮ್ಮ ಮೌತ್ತನಿ ಶಿಕ್ಷಾನೆ ಕಾರಣ ಥಯಲ ಸುಬಿ ಕರಲ ರ‍್ಹಯುಮ ಮೌತ್ತನಿ ಶಿಕ್ಷಾನೆ ಇನಾಕಾರತೊ ನೈ. ವರಿ ತ್ಯುನೆ ಮಾರಾ ಉಪ್ಪರ ಘಾಲೆಲ ತಪ್ಪೊ ತಾಕತ ನೈಸೊ ಪಕ್ಷಮ್ಮಾ,ಕುನಬಿ ಮನೆ ತ್ಯುನಾ ಹತೆ ಒಪಸಾನೆ ನೈ ಥಾತು. ಮಿ ಕೈಸರನಾ ಕ್ಹಾಮೊ ಕೈಲ್ಯುಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ತೆಳಾಮಾ ಫೆಸ್ತಾನೆ ತ್ಯುನಾ ಸಭೆವಾಲಾವೊನಾ ಕ್ಹಾತೆ ಕ್ಹಾರು ವಿಚಾರ ಕರಲ ಪರ ಪೌಲಾನೆ; ತು ಕೈಸರನಾ ಕ್ಹಾಮೊ ಕೈಲ್ಯುಸ ಕದ್ಯೊ ತೊ ತಿನಾ ಹುತಿ ಕೈಸರ ಕನ ಜೌ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ದಕ್ಹಾದಿನೊ ಥಯಲ ಅಗ್ರಿಪ್ಪ ರಾಜೊ಼, ಬೆರ್ನಿಕೆರಾಣಿ, ಫೆಸ್ತಾನೆ,ಮಳಾನೆ ಸ್ವಾಗತ ಕರಾನೆ ಕೈಸರೈನೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ತ್ಯುನೆ ದಕ್ಹಾ ದಿನ್ನ ತ್ಯಾ ರ‍್ಹತ್ತಾಮ್ಮಾ ಫೆಸ್ತಾ ಪೌಲಾನಿ ಸಂಗತಿಯೊ ರಾಜಾ಼ನೆ ತಿಳಸಿ ಕದಲ ; ಫೆಲಿಕ್ಸ ಛೊಡಿನ ಗಯೆಲ ಎಕ ಜೆಲಮ್ಮಾನೊ ಮನಕ್ಹ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ಮಿ ಯೆರುಸಲೆಮ್ಮಾ ರ‍್ಹತ್ತಾಮ್ಮಾ ಯೆಹುದಿಯೊನಾ ಖಾಸ ಯಾಜಕೊ, ಮ್ಹೊಟಾ ಮನಕ್ಹೊ ತಿನಾ ವಿಷಯಮ್ಮಾ ಮನೆ ತಪ್ಪ ಕೈನ ತಿನೆ ವಿರುದ್ದ ಥೈನ ಫೈಸಲೊ ಥಾನಾದೆ ಕೈನ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ಮಿ ತ್ಯುನಾ ಪ್ರಾವಾದಿಯೊ ವಾದಾ ಕರಾವಾಲಾ ವೊನೆ ತ್ಯುನಾ ಕ್ಹಾಮಾಜ಼ ಹುಬರೈನ ತಿಪರ ಘಾಲೆಲ ದೊಷನಾ ಹುತಿ ಪ್ರತಿವಾದ ಕರಾನೆ ದಿದ್ಯಾವಾಚಿ ತಿನೆ ಒಪ್ಪನಿ ದಿವಾನೆ ರೊಮ್ಮಾವಲೊನಿ ಪದ್ದತ ನ್ಹೊವೈ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ತ್ಯಾ ತ್ಯುನೆ ಮಳಿನ ಮಿ ದಕ್ಹಿಯೆಳ ಬಿ ತಡಾ ಕರೆವಾಚಿ ಮರ್ನಾ ದಿನೆ ಫೈಸಲಾನಿ ಜ಼ಗಾಪರ ಬೈಟಿನ ತೆ ಮನಕ್ಹನೆ ನಿನೌ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ, ");
INSERT INTO sle_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ಯೆಹುದಿಯೊ ತ್ಯಾ ಹುಬರೈನ ತಿನಾ ಉಪ್ಪರ ತಪ್ಪ ಘಾಲ್ಯಾ. ತಿನಾಹುತಿ ಮಿ ವಿಚಾರ ಕರಲ ತ್ಯುನೆ ಅಪರಾಧಮಾ ಯಕಬಿ ತಿನಾ ಉಪ್ಪರ ಘಾಲ್ಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ತ್ಯುನೆ ಕದಲ ಸಂಗತಿಯೊ ತ್ಯುನಾ ಧರಮಶಾಸ್ತ್ರನಾ ಪ್ರಕಾರ ಜಿವ್ನಾ ಕರಾಡೊತೊ ಕೈನ, ಪೌಲಾ ಕವಾನು ಮರಿಗಯೆಲ ಯೆಸು ಜಿವಾಸಾಡೊಸ ಕೈನ ಯಕ್ಲಾನಾ ವಿಚಾರಮಾ, ತಿನಾ ಉಪ್ಪರ ದಕ್ಹಾ ವಿವಾದ ಥವಾನು ವಾತೊ ಬೊಲ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ಹವಾ ಕಾಮೊ ಕಿಮ್ಮ ವಿಚಾರ ಕರು ಕೈನ ಮನೆ ಕಳೆ ನೈಸೊ. ತು ಯೆರುಸಲೆಮೆ ಗೈನ ತಾರಾ ಅಪರಾಧನಾ ವಿಷಯಮಾ ವಿಚಾರ ಕರಾನಾಹುತಿ ಕೊಶಿಶ ಕರಾನೆ ಮನಸ ಛೆ ಸು? ಕೈನ ಮಿ ಪುಚ್ಯೊ಼. ");
INSERT INTO sle_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ತಿನೆ ಪೌಲಾ ಚಕ್ರವರ್ತಿ ಥಯಲ ಕೈಸರನಾ ಕ್ಹಾಮೊ ಹುಬರೈನ ಕದೆಮಟಾ, ಮಾರಾ ಹುತಿ ಕೈದು ಕೈನ ಮಾಂಗಿಲೆತ್ತಾಮ್ಮಾ ಮಿ ಕೈಸರ ಕೈನ ಮೊಕಲೆ ಲಕ್ಕಾ ತಿನೆ ಕೈದಾನಾ ಹುತಿ ಅಪ್ಪಣೆ ದಿದ್ಯೊ ಕೈನ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","\"ತಿನೆ ಅಗ್ರಿಪ್ಪ; ತೆ ಮನಕ್ಹ ಕಲಿವಾನು ಕತ್ತಾಮ್ಮಾ ಮನೆಬಿ ಮನಸ್ಸ ಛೆ ಕೈನ ಪುಚತ್ತಾಮ್ಮಾ ಫೆಸ್ತಾ ಉತ್ತಾರಾ ದಿದ್ಯೊ ವಂತಾ ಪುಚಸಕಸಿ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ಮರಾನಾ ದಿನೆ ಅಗ್ರಿಪ್ಪ ರಾಜೊ಼,ಬೆರ್ನಿಕೆರಾಣಿ ಘನ್ನಾ ವತಡಕ್ಹು ಐನ ಅದಿಕಾರಿಯೊ ವರಿ ಗಾಮನಾ ಖಾಸ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಸಭಾಮಂದಿರಮ್ಮಾ ಮಳಿನ ಆತ್ತಾಮ್ಮಾ ಫೆಸ್ತಾ ಅಪ್ಪಣೆ ದೆತಾಮ್ಮಾ ಪೌಲಾನೆ ಬಲೆಲಿನ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ತೆಳಾಮಾ ಫೆಸ್ತಾ; ಅಗ್ರಿಪ್ಪ ರಾಜೊ಼,ಹಮ್ಮಾರಾ ಕ್ಹಾತೆ ಮಳಿನಾಯೆಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊ, ಆ ಮನಕ್ಹನೆ ದೆಕೊಶಿನೈ,ಅನಾ ವಿಷಯಮ್ಮಾ ಯೆಹುದಿಯೊ ಆ ಅಬಾದಾತೊ ಜಿವ್ನಾ ಕರುನೈ ಕೈನ ವದರತ್ತಾ ಯೆರುಸಲೆಮ್ಮಾ ವರಿ ಯ್ಹಾಬಿ ಮನೆ ಮಾಂಗಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ತೆ ಮಾರಾನೆ ದಂಡನೆ ಕಾರಣಾ ಥಾವಾನೆ ಸು ನತ್ತಿ ಕರ‍್ಯೊಕೈನ ಮನೆ ದಿಕ್ಹಿನ ಐಯು. ತೆಜ಼ ಕೈಸರನೆ ಮಾಂಗಿಲೆತ್ತಾಮ್ಮಾ ತಿನೆ ಕೈಸರಕನ ವಳಾವಾನೆ ಫೈಸಲೊ ಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ತೆನೈಸೊ ತಿನಾಹುತಿ ಕೈಸರ ಆವಾನೆ ಕೈಜ಼ ಕಾರಣ ದಿಕ್ಹಿನ ಆಯು ನೈ. ಜೆಲಮ್ಮಾರಹೆಲವಾಲಾನಾ ಹುತಿ ಆರೊಪ ಘಾಲೆಲ ತಪ್ಪ ದಿಕ್ಹೆವಾಚಿ, ತಿನೆ ವಳಾವಾನು ಚೊ಼ಕು ನ್ಹವೈ ಕೈನ ಮನೆ ದಿಕ್ಹಿ ಐ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ತಿನಾಹುತಿ ವಿಚಾರ ಕರಲ ಪರ ಸುಬಿ ಲಿಕಾನೆ ಮಳಸ ಕೈನ ತಿನೆ ತಾರಾ ಕ್ಹಾಮಾ ಖಾಸ ಕರಿನ ಅಗ್ರಿಪ್ಪ ರಾಜಾ಼ ತಾರಾ ಕ್ಹಾಮಾ ಲಾಯಾಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ತೆಳಾಮಾ ಅಗ್ರಿಪ್ಪನೆ, ಪೌಲಾನೆ ತು ತಾರಾ ಪರಾ ಬೊಲಸಕ್ಸಿ ಕತಾಮಾ, ಪೌಲಾ ಹತ ಉಚೈನ, ಪ್ರತಿವಾದ ಸು ಕರ‍್ಯೊ ಕದ್ಯಾಮ. ");
INSERT INTO sle_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ಅಗ್ರಿಪ್ಪ ರಾಜಾ಼, ಯೆಹುದಿಯೊ ಮಪರ ಆರೊಪ ದಿವಾನು ಕ್ಹಾರಾ ಆರೊಪನಾ ಹುತಿ ತಾರಾ ಕ್ಹಾಮೊ ಮಿ ಹಮ್ನಾಜ಼ ಪ್ರತಿವಾದ ಕರಾನು ರ‍್ಹಯಲ ಹುತಿ, ಮನೆ ಧನ್ಯ ವ್ಹೈನ ಕವೈಲ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ಕಾಕದ್ಯಾಮ, ಯೆಹುದಿಯೊಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಿಯೊ ಪದ್ದತಿಯೊ, ವಿವಾದೊ ತು ಘನ್ನೊ ಬಲ್ಲಲವಾಲೊ ರ‍್ಹಶಿ. ಮಾರಿಯೊ ವಾತೊ ತಾಳ್ಮೆಕ್ಹು ಐಕು ಕೈನ ಮಾಂಗಿಲ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ಮಿ ನ್ಹಾನೊ ರ‍್ಹತಾಮಾತೊ, ಯೆರುಸೆಲಿಮಮಾ ಮಾರಾ ಸ್ವಂತ ದೆಶನಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ರ‍್ಹೈನ, ಜಿವ್ನಾ ಕರಲ ತರಿಕೊ ಕ್ಹಾರಾ ಯಹುದಿಯೊನೆ ಗ್ವತ್ತ ರ‍್ಹಯಲಜ಼ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","\"ಮಿ ಮಾರಾ ಧರ್ಮಮಾ ಘನ್ನು ಕಟ್ಟ ನಿಟ್ಟ ಕರಾನು ಪದ್ದತ ಫರಿಸಾಯರ ಪಾಳಿಮಾ ಕರಲ ಲಿಂಗತ ಫರಿಸಾಯರ ಲಿಂಗತ ಚಾ಼ಲಿಲಿನ ಗಯೊಸ ಕೈನ, ಶುರುತೊಬಿ ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಛೆ ಸಾಕ್ಷಿ ಕವಾನು ಮನಸ ರ‍್ಹಯುಮ ತ್ಯುನೆ ಕೆ ಸಕಸ\" ");
INSERT INTO sle_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ಹಮ್ನಾಬಿ ಕ್ಹುದಾ ಹಮಾರಾ ಪಿತೃವೊನೆ, ದಿದಲ ವಾತ ಪುರಾ ಥಾವಸ ಕವಾನು ಆಸನಾ ಹುತಿಜ಼, ಹಮೆ ಹಮ್ನಾ ಫೈಸಲಾನಾ ಹುತಿ ನ್ಹ್ಯಾ ಹುಬ್ರಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ಅಪ್ನಾ ಬಾರಾ ಖಾಂಧಾವಾಲಾ ದಿನ್ನ ರಾತ ಆಸಕ್ತಿಕ್ಹು ಕ್ಹುದಾನೆ ಆರಾದಾನಾ ಕರ್ತಾ ತೆ ವಾತನಿ ಫಲ ಮಳಾನಾ ಹುತಿ ಆಸ ಕರ್ತಾ ಛೆ. ರಾಜಾ಼, ತೆಜ಼ ಆಸನಾ ಹುತಿ ಯೆಹುದಿಯೊ, ಮಾರಾ ವಿರುದ್ದ ದೊಶಾರೊಪಣೆ ಕರಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","(ಮಲಾಕಿ 7:9) ಕ್ಹುದಾ ಮರಲವಾಲಾವೊನೆ ಉಟಾಡಲ ಬರೊಕ್ಹೊ ಕರಾನೆ ಅಸಾದ್ಯ ವ್ಹೈ ಕೈನ ತುಮೆ ಕಾ ಫೈಸ್ಲೊ ಕರೊಶಿ? ");
INSERT INTO sle_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ಯಕ್ಕ ಕಾಲ್ಮಾ ನಜೆರೆತನಾ ಯೆಸುನಾ ನಾಮನೆ ವಿರುದ್ದ ಘನ್ನಾ ಕಾರ‍್ಯೊ ಕರು ಕೈನ ಹಮೆ ವಿಚಾರ ಕರ್ಲಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ಯೆರುಸೆಲಿಮಮಾ ತಿಮ್ಮಜ಼ ಕರ‍್ಯೊತೊ. ಖಾಸ ಯಾಜಕ ಕ್ಹು ಅದಿಕಾರ ಪಡ್ದಿನ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊಮಾ ಘನ್ನಾ ಜ಼ನಾವೊನೆ ಜೆಲ್ಮಾ ಮುಕ್ಕಿನ, ತ್ಯುನೊನೆ ಮರ್ವಾನಿ ಶಿಕ್ಷಾ ಥಯಲ್ಪರ, ಮಿ ತಿನೆ ಸಮ್ಮತಿ ಕರೊಸ. ");
INSERT INTO sle_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ಕ್ಹಾರಿಯೊ ಸಬಾ ಮಂದಿರೊಮಾ, ಮಿ ತ್ಯುನೊನೆ ಘನ್ನಿ ಸಲಾ ತ್ಯುನೊನೆ ಶಿಕ್ಷಾ ದಿನ್ನ ತ್ಯುನೊಕ್ಹು ಕ್ಹುದಾನಾ ವಿರುದ್ದ ವಾತೊ ಬೊಲಾನಿಯೊ ಕೊಶಿಶ ಕರ‍್ಯೊ. ತೆನೈಸೊ ತ್ಯುನೊಪರ ಘನ್ನೊ ಶಿಟ್ಟ ಥೈನ ಬಿಜಾ಼ ಗಾಮ ಲಕ್ಕಾ ಗೈನ ತ್ಯುನೊನೆ ತ್ರಾಸ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ಎ ಉದ್ದೆಶಕ್ಹು ಮಿ ಖಾಸ ಯಾಜಕ ಕ್ಹು ಅದಿಕಾರ, ಆದೆಶ ವ್ಹಂದಿನ ದಮಸ್ಕ ಗಾಮೆ ಜಾ಼ವಾನಿ ವಾಟ್ಮಾ ರಾಜಾ಼, ");
INSERT INTO sle_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ದುಪಾರ್ನಾ ವಕ್ಹತ್ಮಾ ಆಕಾಶತೊ ಯಕ್ಕ ಉಜಾಲು ಮಾರಾ ಸುತ್ತೆ ವರಿ ಮಾರಾ ಕ್ಹಾತೆ ಆವಾಲಾವೊನಾ ಸುತ್ತೆ ಸುರ್ಯಾನು ಉಜಾಲಾ ಲಿಂಗತ ಘನು ಮಿಂಚಾ಼ನು ಮಿ ದೆಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ಹಮೆ ಕ್ಹರಾ ಜಿಮಿನ್ಪರ ಪಡ್ತಾಮಾ, ಸೌಲಾ, ಸೌಲಾ, ತು ಮನೆ ಕಾ ತ್ರಾಸ ಕರಾಡ್ಯೊಸ? ಕಾಟಾನಾ ಝಾಡೊನೆ ವದ್ದ್ಯೊಮ ತುನೆಜ಼ ತ್ರಾಸ ನ್ಹವೈ ಸು? ಕೈನ ಹಿಬ್ರಿನಿ ಭಾಶಾಮಾ ಕವಾನಿ ವಾತ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ತೆಳಾಮಾ ಮಿ, ಕರ್ತಾ, ತು ಕುನ ವ್ಹೈ? ಕತಾಮಾ ಕರ್ತಾ \"ತು ತ್ರಾಸ ಕಾರಾನೊ ಯೆಸುಜ಼ ಮಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ತು ಉಟಿನ ತಾರಾ ಪಗೊಪರ ಹುಬ್ರೆ ತುನೆ ಮಾರೊ ಸೆವಕ ಕರಿನ ಸಾಕ್ಷಿನಾ ಹುತಿ ನೆಮಸಾನಾ ಹುತಿ ತುನೆ ದಿಕ್ಹ್ಯೊಸ ಹಮ್ನಾಬಿ ಅಗೊಬಿ ತುನೆ ದೆಕಾಡಾನು ದರ್ಶನೊಮಾ, ತುನೆ ದಿಕ್ಹಲನಾ ಹುತಿ ತು ಮಾರಿ ಸಾಕ್ಷಿ ಥೈನ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ಮಿ ತಾರಾ ಇಸ್ರಯೆಲ ಸ್ವಂತ ಮನಕ್ಹೊಕಂತೊ, ಯೆಹುದಿಯೊ ನೈಸೊ ಮನಕ್ಹೊಕ್ಹು ತ್ಯುನೊಕನ ತುನೆ ವಳೌಸ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ತ್ಯುನೆ ಅಂದಾರಾಮಾತಾ ಉಜಾ಼ಲಾನೆ, ಸೈತನನಾ ಹತ್ಮಾತಾ ಕ್ಹುದಾಕನ ಫರಿನ, ಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲಕ್ಹು ಪಾಪನಿ ಮಾಫಿ, ಪರಿಶುದ್ಧ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಕ್ಹಾತೆ ತ್ಯುನು ಹಕ್ಕ ವ್ಹಂದಿಲಿವಾನಾ ಹುತಿ, ತ್ಯುನಾ ಡೊಳಾ ಕ್ಹುಲು ಕೈನ ಮಿ ತುನೆ ತ್ಯುನೊಕನ ವಳೌಸ” ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ತಿನಾಹುತಿ \"ರಾಜಾ಼ ಥಯಲ ಅಗ್ರಿಪ್ಪ,ಮನೆ ಮಳೆಲ ಮಿ ಪರಲೊಕನು ದರ್ಶನ ದೆಕಲಪರ ತಿನೆ ಅವಿಧೆಯ ನೈ ಥೈನ. ");
INSERT INTO sle_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ತೆಳಾಮಾ ದಮಸ್ಕಮ್ಮಾ ಬಿ ವರಿ ಯೆರುಸಲೆಮ್ಮಾ ಬಿ ಯುದಾಯಮ್ಮಾಬಿ ಕ್ಹಾರಾ ಸಿಮೆ ರ‍್ಹಹೆಲವಾಲಾವೊನೆ ಬಿ ಮನಕ್ಹೊನೆ\"ತುಮಾರಾ ಪಾಪೊನಾ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡಿನ ");
INSERT INTO sle_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","\"ತೆ ತಿನಾಹುತಿ ಯೆಹುದಿಯೊ ದೆವಾಲಮ್ಮಾ ಮನೆ ಧರ್ಲಿನ ಖಲಾಸ ಕರು ಕೈನ ಕೊಶಿಶ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ತೆಳಾಮಾ ಕ್ಹುದಾ ಮನೆ ಮದತ ಕರ‍್ಯೊ. ತೆ ಹಮನಾತೊ ಹಮನೊನೆ ಮದತ ಕರಾಡ್ಯೊಸ. ತಿನಾಹುತಿ ಹಮ್ನಾ ಯ್ಹಾ ಹುಬರಯೊತೊ ವರಿ ಮಿ ದೆಕೆಲ ಸಂಗತಿಯೊನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ಸಾಕ್ಷಿ ಕವಾಡೊತೊ. ತಿನಾಹುತಿ ಮಿ ಕೈಜ಼ ನವು ಕದೆವಾಚಿ, ಮೊಶೆ ವರಿ ಪ್ರವಾದಿಯೊನಾ ಕ್ಹಾಮೊ ನೆರವೆರಸ ಕೈನ ಕದಲ ಸಂಗತಿಯೊ ಕತೊವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ಕ್ರಿಸ್ತಾ ದುಕ ಕರಲಿನ ಮರಿನ ಮರೆಲಮಾತೊ ಪೈಲಾನೊ ಥೈನ ಉಟಿನ ಐನ ಯೆಹುದಿಯೊನೆ ವರಿ ಯೆಹುದಿಯೊನೆ ನೈಸೊ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ರಕ್ಷಣೆ ಉಜಾಲು ಲಾವಸ ಕೈನ ಪ್ರಸಿದ್ದಿ ಕರಾವಾಲೊ ಥಾಶಿ ಕೈನ\" ");
INSERT INTO sle_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ಇಮ್ಮ ಪೌಲಾ ತಿನಾಕ್ಹು ವಾದ ಕರೊತ್ತೊ ಕತ್ತಾಮ್ಮಾ ಫೆಸ್ತಾ. ಪೌಲಾ ತುನೆ ಪಿಸಾಳೊ ಧರ‍್ಯುಸು, ಘನು ಒದಾನು ತುನೆ ಪಿಸಾಳು ಕರಿಪಡಸ, ಕೈನ ವದರಿನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ತಿನಾಹುತಿ ಪೌಲಾ ಮಹಾರಾಜಾ಼ ಥಯಲ ಫೆಸ್ತಾ. ಮಿ ಪಿಸಾಳೊ ನ್ಹೈವೈ ಮಿ ಕವಾನು ಕ್ಹರಿನಾ ವಾತೊ ಛೆ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ರಾಜೊ಼ ಥಯಲ ಅಗ್ರಿಪ್ಪನೆ ತೆ ಸಂಗತಿಯೊ ಗೊತ್ತ ಛೆ. ತಿನಾಹುತಿ ತಿನಾ ಕ್ಹಾಮೊ ಮಿ ಧೈರ್ಯಕ್ಹು ಬೊಲುಸಕೈ. ತೆ ಸಂಗತಿಯೊಮ್ಮಾ ಯಕ್ಕಬಿ ಜ್ಹಾಕಿಲಿದೆಲ ನತ್ತಿ ನಂಬಾನು ಸುವೈ ಕದ್ಯಾಮ, ಕಾಕದ್ಯಾಮ್ಮಾ ತೆ ಯಕ್ಕ ಮೂಲಾಮ್ಮಾ ಥಯಲ ಕಾಮ್ಮ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ರಾಜೊ಼ ಅಗ್ರಿಪ್ಪ, ಪ್ರವಾದಿಯೊನೆ ತು ನಂಬಶಿಸು? ಮನೆ ಗೊತ್ತಛೆ ಕೈನ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","\"ತಿನಾಹುತಿ ಅಗ್ರಿಪ್ಪ ರಾಜೊ಼ ಉತ್ತರಾ ದಿದ್ಯೊ ; ದಕ್ಹಿ ಕೊಶಿಶಕ್ಹು \"ಮನೆ ಆಸಾನಕ್ಹು ಕ್ರಿಸ್ತ ಥವಾನಾಹುತಿ ಒಂಡಬಡಿ ಸು ತು? ಕೈನ ಕತ್ತಾಮ್ಮಾ\" ");
INSERT INTO sle_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ಪೌಲಾ ಚೊ಼ಕು ವೈಸು ಕಟ್ಟವೈ ತೆ ಮನೆ ಖಾಸ ನ್ಹವೈ. ತು ಯಕ್ಲೊಜ಼ ನ್ಹವೈ ತೆಳಾಮಾ ಮನೆ ಕರಾನು ಹರಯಕ್ಲೊ ಮಾರಾನಿಂತ ಥೌ ಕೈನೆ ಮಿ ಕ್ಹುದಾನೆ ಪ್ರಾರ್ಥನಾ ಕರುಸ. ತಿನಾಹುತಿ ತೆ ಸಂಕೊಲೆಯೊ ಯಕ್ಕಜ಼ ತಮನೊನೆ ನಕೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ರಾಜೊ಼ ಅಗ್ರಿಪ್ಪ,ರಾಜ್ಯಪಾಲ ಫೆಸ್ತಾ,ಬೆರ್ನಿಕೆ ವರಿ ತ್ಯುನಾಕ್ಹಾತೆ ಬೈಟೆಲ ಮನಕ್ಹೊ ಕ್ಹಾರಾ ಹುಬರೈನ. ");
INSERT INTO sle_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ತ್ಯಾತಾ ಭಾರಾ ಆಯಾ ತ್ಯುನೆ ಯಕ್ಕನೆ ಯಕ್ಕ ತೆ ಮನಕ್ಹನೆ ಮೌತನಿ ಶಿಕ್ಷಾ ದ್ಯು ನೈ ಕೈನ ವರಿ ಜೆಲಮ್ಮಾ ಘಾಲು ನೈ ಕೈನ ತೆ ಕ್ಹರಿ ಕೆಟ್ಟನು ಸುಜ಼ ನತಿ ಕರ‍್ಯೊ ಕೈನ ಕದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ತೆಳಾಮಾ ಅಗ್ರಿಪ್ಪ ಫೆಸ್ತಾನಾ, ತೆ ಸಿಸರನೆ ಮಾಂಗಿ ನೈ ಲಿದ್ಯೊಮ್ಮ,ಅನೆ ಚೊಡಾನಿ ವಾತ್ತ ವ್ಹತ್ತಿ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ಅಪೆ ಇಟಲಿನೆ‍ ಹಡಗಾಮಾತಾ ಜೌ಼ ಕೈನ ಫೈಸ್ಲೊ ಥಯೊ. ಪೌಲಾನಾ ವರಿ ಬಿಜಾ಼ ಕೈದಿಯೊನೆ ಜುಲಿಯಸ ಕವಾಲೊ ಸೆನಾಧಿಕಾರಿ ಕೈದಾಲು ವ್ಹತ್ತೊ. ರೊಮ್ಮನೊ ಶತಾದಿಪತಿ ಥಯಲ ಜೊಲಿಯಸ ಚಕ್ರವರ್ತಿನಾ ಸೈನ್ಯಮಾ ಸೆವೆ ಕರಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ಹಮೆ ತೆ ಹಡ್ಗೊ ಚ಼ಡಿನ ತ್ಯಾಂತಾ ಚಾ಼ಲ್ಯಾ. ತೆ ಹಡ್ಗೊ ಅದ್ರಮಿತ್ತ ಗಾಮ್ತೊ ಆಯೊತೊ ವರಿ ಎಶ್ಯಾಮಾ ರ‍್ಹಯಲ ಬಿಜಾ಼ ಬಿಜಾ಼ ಗಾಮೊಯೆ ಜಾ಼ವಾನೆ ತಯ್ಯಾರ ವ್ಹತ್ತೊ. ಅರಿಸ್ತರ್ಕಬಿ ಹಮಾರಾ ಕ್ಹಾತೆ ಆಯೊ. ತೆ ಮೆಕೆದೊನಿಯಾನೆ ಮಳಲ ಥೆಸಲೊನಿಕ ಗಾಮವಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ಮರ್ನಾ ದಿನ್ನೆ ಹಮೆ ಸಿದೊನ ಗಾಮೆ ಆಯಾ. ಜೊಲಿಯಸ ಪೌಲಾನೆ ಮರಗತೊತೊ. ದೊಸ್ತೊನೆ ಗೈನ ಮಳಾನಾ ಹುತಿ ತೆ ಪೌಲಾನೆ ಅನುಮತಿ ದೆತೊತೊ. ದೊಸ್ತೊ ಪೌಲಾನೆ ಚಾ಼ಯೆ ಥಯಲ ಕ್ಹಾರುಜ಼ ದೆತಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ಹಮೆ ಸಿದೊನ ಗಾಮ್ತಾ ಚಾ಼ಲ್ಯಾ. ಹಮಾರಾ ವಿರುದ್ದ ವಾರೊ ಛುಟಲಹುತಿ ಹಮೆ ಸೈಪ್ರಸ ದ್ವಿಪನಾ ನಜಿಕ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ಸಿಲಿಸಿಯಸನೆ ಪಾಂಫಿಯಾನೆ ಕ್ಹಾಮು ರ‍್ಹಯಲ ಸಮುಂದರ ದಾಟ್ಯಾ. ತೆ ಥಯಲ್ಪರ ಹಮೆ ಲುಸಿಯಾ ಪ್ರಾಂತ್ಯಮಾ ರ‍್ಹಯಲ \"ಮುರ \"ಕವಾನಾ ಗಾಮೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾತೊ ಆಯಲ ಹಡಗೊ \"ಮುರ \"ಮಾ ರ‍್ಹಯಲ ಸೆನಾದಿಕಾರಿ ದೆಕ್ಯೊ. ಎ ಹಡ್ಗೊ ಇಟಲಿಯೆ ಚಾ಼ಲ್ಯೊತೊ. ತಿನಹುತಿ ತೆ ಹಮೊನೆ ತೆ ಹಡಗಾಮಾ ಚ಼ಡಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ಹಮೆ ನಿಧಕ್ಹು ಘನ್ನಾ ದಿನ್ನ ಲಕ್ಕಾ ಪ್ರಯಾಣ ಕರಾತ್ತಾ ಘನಾ ಕಷ್ಟ ಖಾತಾ ಸ್ನಿಡ ಗಾಮೆ ಮೂಟ್ಯಾ. ವಾಟ್ಮಾ ಹಜು಼ನ ಅಗಾ ಜಾ಼ವಾನೆ ಥಯು ನೈ. ತಿನಾಹುತಿ ಹಮೆ ಸಾಲ್ಮೊನೆಯ ನಜಿಕ್ಮಾ ರ‍್ಹಯಲ ಕ್ರೆಟ ದ್ವಿಪ ದಕ್ಷಿಣ ಭಾಗಮಾ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ಹಮೆ ತ್ರಾಸ ಕ್ಹು ಕರಾವಳಿಮಾ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ತೆ ಥಯಲ್ಪರ ಹಮೆ ಚೊ಼ಕಿ ತರಾರೆವು ಕವಾನಾ ಜ಼ಗಾಪರ ಆಯಾ. ಲಸಾಯಾ ಗಾಮ ತಿನಾ ನಜಿಕ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ತೆನೈಸೊ ಘನ್ನೊ ವಕ್ಹತ ಥೈಗೈಯೊತೊ. ಹಮ್ನಾ ನೌಕಾಯಾನ ಕರಾನು ಘನ್ನು ಖತರ್ನಾಕ ವ್ಹತ್ತು. ಕಾಕದ್ಯಾಮ ಯೆಹುದಿಯೊನು ಉಪವಾಸನೊ ದಿನ್ನ ತೆಳಾಮಾಜ಼ ಥೈಗಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ತಿನಾಹುತಿ ಪೌಲಾ ತ್ಯುನೊನೆ\"ಮನಕ್ಹೊ, ಎ ಪ್ರಯಾಣಮಾ ಹಮೊನೆ ಘನ್ನೊ ತ್ರಾಸ ಛೆ ಕೈನ ಮನೆ ತಿಳದಾಡ್ಯುಸ. ಹಡ್ಗೊ ವರಿ ತಿಮಾರ‍್ಹಯಲ ಸಾಮನ ಹಾಳ ಥಾವಸ. ಅಪ್ನೊ ಜ಼ಲಮಬಿ ಹಾಳ ಥೈ ಜಾ಼ಸ! ಕೈನ ಹುಷಾರ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ವರಿಬಿ ಹಡಗಾನೊ ನಾಯಕ ವರಿ ಹಡಗಾನೊ ಮಾಲಕ ಪೌಲಾ ಕದಲನೆ ವಪ್ಯಾ ನೈ. ತಿನಾಹುತಿ ಸೆನಾದಿಕಾರಿ ಪೌಲಾನಿ ವಾತ ಐಕ್ಯಾವಾಚಿಹಡಗಾನಾ ಮಾಲಕನಿ ವರಿ ಹಡಗಾನಾ ನಾಯಕನಿ ವಾತ ಐಕ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ತೆ ರೆವು ಥಂಡಾನಾ ದಿನೊಮಾ ಹುಬ್ರವಾನೆ ಚೊ಼ಕಿ ನ್ಹೊತಿ. ತಿನಾಹುತಿ ಹಡ್ಗೊ ತ್ಯಾಂತೊ ಲಿನ ಜಾ಼ಜ಼ ಕೈನ ಘನ್ನಾ ಮನಕ್ಹೊ ಕದ್ಯಾ. ಹಮೆ ಫೆಲಿಕ್ಸನೆ ಮುಟ್ಟಿಯೆಸ ಕೈನ ತ್ಯುನಿ ಆಸ ವ್ಹತ್ತಿ. ಥಂಡನಾ ದಿನೊಮಾ ಹಡ್ಗೊ ತ್ಯಾ ರ‍್ಹವಾನು ವ್ಹತ್ತು. ಫೆನಿಕ್ಸ ಕ್ರೆಟ ದ್ವಿಪನು ಬಂದರ ತೆ ವ್ಹಂದ್ಯುತು. ಇಶ್ಯಾನನಾ ದಿಕ್ಕನೆ ಆಗ್ನೆಯಾ ದಿಕ್ಕನೆ ಕ್ಹಾಮು ರ‍್ಹಯಲ ಮ್ಹೊಡು ಕರಿನ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ತೆ ಥಯಲ್ಪರ ಚೊ಼ಕೊ ವಾರೊ ದಕ್ಷಿಣ ಬಗಲ್ತಾ ಛುಟಾನು ಚಾಲು ಥಯೊತೊ. ಹಡಗಾಮಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊ, ಅಪೊನೆ ಚಾ಼ಯೆ ಥಯಲ ಎಜ಼ ವಾರೊ ವ್ಹೈ, ಹಮ್ನಾ ತೆ ಹಮೊನೆ ಮಳ್ಯೊ! ಕೈನ ವಿಚಾರ ಕರ್ಲಿದ್ಯಾ. ತಿನಾ ಹುತಿ ತ್ಯುನೆ ಹಡಗಾನಾ ಲಂಗತ ಉಪ್ಪರ ಯಳದ್ಯಾ. ಹಮೆ ಕ್ರೆಟ ದ್ವಿಪನಾ ಕರಾವಾಳಿಮಾ ನೌಕಾಯಾನ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ತೆನೈಸೊ ಇಶಾನ್ಯ ಮಾರುತ ಕವಾನಿಬಿರುಗಾಳಿ ದ್ವಿಪಮಾ ಛುಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ಹಡ್ಗಗಾನೆಬಿ ಲಾಗ್ಯು ಹಡ್ಗೊ ತಿನಾ ವಿರುದ್ದ ಜಾ಼ವಾನೆ ಥಯು ನೈ. ತಿನಾ ಹುತಿ ವಾರೊ ಐನ ಹಮ್ಮಾರಾ ಹಡ್ಗೊ ಲಿನ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ಅಪೆ \"ಕಾವ್ದ \"ಕವಾನಿ ದ್ವಿಪ ಮೆರೆಮಾತಾ ಗಯಾ ತೆಳಾಮಾ ಅಪೆ ಹಡಗಾಮಾ ರಯೆಲ ನ್ಹಾನಿ ದ್ವಿಪ ಲಿವಾನಾಹುತಿ ಹಮೊನೊಕ್ಹು ಥೈಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ತೆಳಾಮಾ ಡೊಣಿಮ್ಮಾ ತುಟು ನೈ ಕೈನ ಹಡಗಮ್ಮಾ ಸುತೆ ರಾಕ್ಹೊ ಭಾಂದಿನ. ತೆಳಾಮಾ ಸುರ್ತಿಸ ಕವಾನು ಕಳ್ಳುಸುಬಿಮ್ಮಾ ಹಡಗೊ ಕಿಲಗಾ ಅಟಕೆಲ ಕೈನ ತ್ಯುನೊನೆ ಬುಚುಕ ವಾಟ್ಯು. ತಿನಾಹುತಿ ತ್ಯುನೆ ಪ್ಹಡಕಾನೆ ಉತರಾಡಿನ ಡೊಣಿನೆ ಲಾಗಿನ ಜಾ಼ವಾನೆ ವಾರಾನೆ ಮೌಕೊ ಕರಿನ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ಬಿರುಗಾಳಿ ವರಿ ಪಾನಿ ಹಮನೊನೆ ಜೊ಼ರಕ್ಹು ಚ್ಹುಟಾಕ್ಹು ಮನಕ್ಹೊ ಹಡಗಮ್ಮಾ ದಕ್ಹಜ಼ನಾ ಸಾಮಾನೊ ಒಗದಿಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ತಿನಾ ಮೆರ್ನಾ ದಿನ ಥಯಲ ಪರ ಹಡಗನಾ ಸಾಮಾನೊ ತ್ಯುನಾ ಹತೊಕ್ಹು ನಾಕಿ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ಘನ್ನಾ ದಿನೊಪರ ಹಮೆ ಸುರ್ಯನೆ ಥಾವಾದೆ ನಕ್ಷತ್ರವೊನೆ ಥಾವಾದೆ ದೆಕ್ಯಾನೈ. ಮ್ಹೊಟೊ ವಾರ‍್ಯೊ ಭಿಕರ ಥಯೊತೊ. ಹಮೆ ಜ಼ಲಮ್ಮಕ್ಹು ವಾಚು ಕೈನ ನಿರಿಕ್ಷೆ ಜುನೈ ಗೈ. ");
INSERT INTO sle_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ತೆ ಮನಕ್ಹೊ ಗನಾದಿನ ತಕ್ಕ ಕ್ಹಾದ್ಯಾ ನ್ಹೊತ್ತಾ. ತೆಳಾಮಾ ಯಕ್ಕ ದಿನ್ನ ಪೌಲಾ ಉಟಿನ ಹುಬರೈನ ತ್ಯುನೊನೆ ಮನಕ್ಹೊ ಕ್ರೆಟ ದ್ವಿಪಕಂತ್ತಾ ನಕೊ ಜಾವೊ ಕೈನ ಮಿ ತಮನೊನೆ ಕದ್ಯೊ. ತಮೆ ಮಾರಿ ವಾತ್ತ ಐಕಾನು ವ್ಹತ್ತು. ತೆಳಾಮಾ ತಮನೊನೆ ದುಖ ರ‍್ಹವಾದೆ ಲುಕ್ಸಾನ ರ‍್ಹವಾದೆ ನೈ ಆತುತು. ");
INSERT INTO sle_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ಹಮ್ನಾ ತಬಿ ತುಮೆ ಧೈರ್ಯಕ್ಹು ರ‍್ಹೈ ಕೈನ ತಮನೊನೆ ಕವಾಡೊಸ. ತಮನೊಮ್ಮಾ ಯಕ್ಲೊಬಿ ನೈ ಮರತೊ. ತೆನೈಸೊ ಹಡ್ಗೊ ಹಾಳ ಥೈನ ಜಾ಼ವಸ. ");
INSERT INTO sle_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ಕಾಕದ್ಯಾಮ ಮಿ ಕಿನೊ ವ್ಹೈ ಕೈನ, ಕಿನೆ ಸ್ತುತಿ ಕರಶಿ ತೆ ಕ್ಹುದಾಕ್ಹು ಆಯೆಲ ಯಕ್ಕ ದುತ ಗಯೆಲ ರಾತ್ತಮ್ಮಾ ಮಾರಾಕ್ಹಾತೆ ಹುಬರೈನ ");
INSERT INTO sle_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ಪೌಲಾ ಬುಚಕು ನಕೊ ತು ಕೈಸರನಾ ಕ್ಹಾಮೊ ಹುಬರೌ ತೆನೈಸೊ ತಾರಾ ಕ್ಹಾತೆ ತೆ ಹಡಗಮ್ಮಾ ಪ್ರಯಾಣ ಕರಾವಾ ವಾಲಾವೊನೆ ಜ಼ಲಮ್ಮ ಕ್ಹುದಾ ತುಪರ ರ‍್ಹಯಲ ಮರಗಾ ಕ್ಹು ವಚಾಡ್ಯೊಸ ಕೈನ ಮಾರಾ ಕ್ಹಾತೆ ಬೊಲ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ತಿನಾಹುತಿ, ಮನಕ್ಹೊ ಧೈರ್ಯಕ್ಹು ರವೊ ಮನೆ ಕದಲ ಲಿಂಗತ ಥಾವಸ ಕೈನ ಕ್ಹುದಾನೆ ನಂಬೆಸೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ತಿನಾಹುತಿ, ಮಿ ಕೈಜ಼ ಯಕ್ಕ ದ್ವಿಪನಿ ದಂಡಿ ಮುಟು ಕೈನ ಕದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ಚ಼ೌದಾ ರಾತ್ತೊ ರಾತೆ ಹಮೆ ಆದ್ರಿಯ ಸಮುಂದರಮಾ ಹೈತಾ ತಿತಾ ಹಲ್ತಾ ಅಗಾ ಬಡ್ಯಾ. ಹಮೆ ಜಿಮಿನ್ನಾ ನಜಿಕ ವ್ಹತ್ತಾ ಕೈನ ಹಡಗಾಮಾ ರ‍್ಹಯಲವಾಲಾ ವಿಚಾರ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ತ್ಯುನೆ ಅಳತಿ ಕರಾನು ಗುಂಡ ರಾಕ್ಹನಾ ತುದಿಯೆ ಭಾಂದಿನ ರಾಕ್ಹ ಪಾನಿಮಾ ಘಲಿನ ಪಾನಿ ಕ್ಹೊನ ಇಕ್ಹ ಅಡಿ ಉಂಡು ವ್ಹತ್ತು. ತ್ಯುನೆ ವರಿ ನಕ್ಕರ ದುರ ಗೈನ ರಾಕ್ಹ ಪಾನಿಮಾ ಗಾಲಿನ ತ್ಯಾ ಪಾನಿ ನವ್ವದ ಅಡಿ ಉಂಡು ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ಹಡ್ಗೊ ದಗ್ಡಾನೆ ಲಾಗ್ಸ ಕೈನ ಹಡ್ಗೊ ಚಹಲಾವಾಲಾ ಭುಚ಼ಕ್ಯಾ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಚಾರ ಲಂಗುರು ಪಾನಿಮಾ ಉತಾರ‍್ಯಾ. ತೆ ಥಯಲ್ಪರ ತ್ಯುನೆ ದಿನ್ನ ನಿಕ್ಹಳಾದೆ ಕೈನ ಪ್ರಾಥನಾ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ಯಕ್ಕ ಸಲಾ ಹಡ್ಗೊ ಚ಼ಲಾವಾಲಾ ತೆ ದಕ್ಹಾಜ಼಼ನಾ ತೆ ಹಡ್ಗೊ ಛೊಡಿನ ಜೌ಼ ಕೈನ ಕೈಲಿವಾಡ್ಯಾತಾ. ತ್ಯುನೆ ಹಡಗೊ ಪಾನಿಮಾ ಉತಾರಿನ ಹಡಗಾನಾ ಕ್ಹಾಮಲ್ಯಾ ಹಿಸ್ಸಾಮಾ ಹಜು಼ನ ದಕ್ಹಾ ಲಂಗುರೊ ಪಾನಿಮಾ ಉತಾರಾನಾ ಲಿಂಗತ ನಾಟಕ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ತೆ ಲಾಮಾ ಪೌಲಾ ಶತಾದಿಪತಿನೆ ವರಿ ಸಿಪಾಯಿಯೊನೆ; ತ್ಯುನೆ ಹಡಗಾಮಾ ಉಗರ‍್ಯಾಮ್ಮಾ ತುಮಾರು ಜ಼ಲಮ್ಮ ನೈ ವಾಚತು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ತೆಳಾಮಾ ಸಿಪಾಯಿಯೊ ಹಡಗನಾ ರಾಕ್ಹೊ ಕಟ್ಟ ಕರಿನ ತೆ ಪಡಿನ ಜೌವರಕ್ಹು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ಪಾಟ ಥಾತಾಟೆಮ್ಮಾ ಪೌಲಾ ಸುಬಿ ಕ್ಹಾವಾನೆ ಲ್ಯು ಕೈನ ಕ್ಹಾರಾವೊನೆ ಮಾಂಗಿಲೆತೊ. ಹಮನಾತೊ ತಮೆ ಚ಼ೌದಾ ದಿನತ್ತಾ ಕೈದಿನ ಕ್ಹಾವಾನೆ ಲಿದೆವಾಚಿ ಬುಖಾಜ಼ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ತಿನಾಹುತಿ, ಕ್ಹಾವಾನೆ ಸುಬಿ ಲ್ಯುಕೈನ ತಮನೊನೆ ಮಾಂಗಿಲ್ಯುಸ. ತೆ ತಮನೊನೆ ಜ಼ಲಮನೆ ಜ಼ರುರತ ಛೆ. ತಮಾರಾಮ್ಮಾ ಕುನಜ ಮಾತ್ತಾಮಾತು ಯಕ್ಕ ಬಾಲಬಿ ನೈ ಉದರತ್ತು ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ಅಮ್ಮ ಕೈನ ಪೌಲಾ ರೊಕ್ಲೊ ಲಿನ ಕ್ಹಾರಾವೊನಾ ಕ್ಹಾಮೊ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರ ಕರಿನ ತೆ ತೊಡಿನ ಕ್ಹಾವಾನು ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ತೆಳಾಮಾ ಕ್ಹಾರಾ ಜ಼ನಾ ಧೈರ್ಯ ಕರಲಿನ, ತ್ಯುನೆಬಿ ಅನ್ನ ಕ್ಹಾದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ತೆಳಾಮಾ ಹಡಗಮ್ಮಾ ರಹೆಲವಾಲಾ ಹಮೆ ಕ್ಹಾರಾಜ಼ನಾ ಬೆಕ್ಹೊನ ಸತ್ತರಪರ ಕ್ಹಾತ್ತಜ಼ನಾ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ಬಸಥೈಯೆಲಕುನ ಕ್ಹಾದೆಲ ಪರ, ಉಗರೆಲ ಘ್ಹೈ ಸಮುಂದರಮ್ಮಾ ನಾಕಿನ ಹಡ್ಗೊ ಹಲಕು ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ಪಾಟ ಥಯಲ ಪರ ತೆ ದೆಶನು ವಳಕ ನೈಸೊ ಉಸುಬಿನಾ ದಡ ಕವಾನು ಯಕ್ಕ ಕೊಲ್ಲಿ ದೆಕಿನ ತೆ ದಡಮ್ಮಾ ಹಡ್ಗೊ ಜಾಸ ಕೈನ ಯೊಚನೆ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ತ್ಯುನೆ ಲಂಗುರೊ ಕಾಡಿನ ಸಮುಂದರಮ್ಮಾ ಛೊಡಿನ ಚುಕ್ಕಾಣಿನಾ ಕಟ್ಟೊ ಚ್ಹಡಿನ, ಮ್ಹೊಟಾ ಹಾಯಿಯೊ ವಾರಾನೆ ಉಟಿನ ಭಾಂದಿನ ಡೊಣಿನೆ ತೆ ದಡನೆ ಚಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ತಿನಿಹುನಾ ಹಡ್ಗೊ ವಚಮ್ಮಾತ್ಯುನೊನೆ ಮಾತಿನಿ ವಾಟ ಮಳಾತ್ತಾಮ್ಮಾ ತೆಳಾಮಾ ಹಡ್ಗೊ ಚಡ್ಯಾ. ಕ್ಹಾಮಲ್ಯು ಭಾಗ ದಿಣ್ಣೆನೆ ಲಾಗಿನ ಹಲೆವಾಚಿ ಹುಬರೈತು. ಪಾಚಲು ಭಾಗ ಹುಚ್ಚು ಅಲೆಕ್ಹು ಮಾರಕ್ಹು ಟುಟಿನ ಚುರ ಥೈಗೈಯು. ");
INSERT INTO sle_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ಜೆಲಮ್ಮಾನಾ ದಕ್ಹಜ಼ನಾ ಚುಕೈಲಿದ್ಯಾಸ ಕೈನ ಸಿಪಾಯಿಯೊ ತ್ಯುನೊನೆ ಮಾರು ಕೈನ ಯೊಚನೆ ಕರಾಡಾತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ತೆಳಾಮಾ ಶತಾದಿಪತಿ ಪೌಲಾನೆ ವಚಾಡು ಕೈನ ವಿಚಾರ ಕರಿನ ತ್ಯುನೆ ಯೊಚನೆನೆ ನೊ ಕೈನ, ಇಜತ್ತಾ ನೈ ಕೈನ ಹಡಗಮ್ಮಾತ್ತಾ ಡುಕಲಿನ ಪೈಲಾ ದಂಡಿನೆ ಜೌ ಕೈನ ");
INSERT INTO sle_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ಅಪೆ ಕ್ಹಾರಾ ಉಗರೆಲಮ್ಮಾ ದಕ್ಹಜ಼ನಾ ಹಲಿಗ್ಯೊನಾ ಉಪ್ಪರ, ದಕ್ಹಜ಼ನಾ ಡೊನಿನಾ ತುಕಡಾಪರ ಜೌ ಕೈನ ಅಪ್ಪಣೆ ದಿದ್ಯೊ. ತೆ ರಿತಿಕ್ಹು ಕ್ಹರಾಜ಼ನಾ ಚೊ಼ಕಿ ತರಾ ದಂಡಿ ಪೊಂಚಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ಹಮ್ಮೆ ಸುರಕ್ಷಿತಕ್ಹು ದಂಡಿ ಮುಟ್ಟೆಲಪರ, ತೆ ಉಪರತೊ ದಿವೊ ಉತರಿನ ಆಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ಬಿಜಾ಼ವಾತೊನಾ ತೆ ದ್ವಿಪವಾಲಾ ಹಮೊನೆ ವಿಶೆಷ ಸನಾಹುಬುತಿ ದೆಕಾಡ್ಯಾ. ತೆಳಾಮಾಜ಼ ಪಾನಿ ಐನ ಥಂಡ ಲಾಗಾಕ್ಹು, ತ್ಯುನೆ ಆಗ ಲಗಾಡಿನ ಹಮೊನೆ ಕ್ಹಾರಾ ಜ಼ನಾವೊನೆ ಮಳೆಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ಪೌಲಾ ಯಕ್ಕ ಗುಂಪ ಲಾಕ್ಡಾ ಮಳೈನ,ಲೈನ ತೆ ಆಗಮ್ಮಾ ಘಾಲಕ್ಹು, ತೆ ಕೌವಕ್ಹು ಯಕ್ಕ ಕ್ಹಾಪ ಭಾರು ಐನ, ತಿನಾ ಹತೆ ಘಟ್ಟ ಧರಲಿದ್ಯುತು. ");
INSERT INTO sle_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ತೆ ತಿನಾ ಹತತೊ ಜೊತಾಡುನು ದ್ವಿಪವಾಲಾ ದೆಕಿನ ; ತೆ ಮನಕ್ಹೊನೆ ಖಲಾಸ ಕರಾವಾಲೊ ವ್ಹೈ ಕದ್ಯಾ. ಸಮುಂದರ ಕಂತಾ ತಪಸಿನ ಆಯಾ ಫೈಸ್ಲಾನಿ ದೆತಾ ತ್ಯುನೊನೆ ವಾಚಾನೆ ನೈದೆತಿ ಕೈನ ತ್ಯುನಾ ತ್ಯುನಾಮ್ಮಾ ಬೊಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ತೆನೈಸೊ ಪೌಲಾ ಕ್ಹಾಪನೆ ಆಗಮ್ಮಾ ನಾಕಿ ಪಾಡ್ಯೊ; ತಿನೆ ಸುಜ಼ ಅಪಾಯ ಥನೈ. ");
INSERT INTO sle_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ತ್ಯುನೆ ; ತಿನು ಅಂಗ ಹಮ್ಮನಾ ಫುಗಸ, ತೆನೈಸೊ ತೆ ಗಪಕ್ನೆ ಮರಿ ಪಡಸ ಕೈನ ತ್ಯುನೆ ಕಾಯಿದಾಡಾತ್ತಾ ಕೆಕಲಿಕೆ ತ್ಯುನೆ ಕಾಯಿದಾಡಾತ್ತಾ. ತಿನೆ ಸುಜ಼ ಹಾನಿ ಥಯು ನೈ. ತೆ ದೆಕಿನ ತ್ಯುನೆ ತ್ಯುನೆ ವಿಚಾರ ಬದಲಿನ ತೆ ಯಕ್ಲೊ ಕ್ಹುದಾ ಕೈನ ಕಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ತೆ ದ್ವಿಪನೊ ಖಾಸ ಥಯಲ ಪೊಪ್ಲಿನಾ ಕ್ಹೆತರೊ ಮಿ ರಹೆಲ ಜ಼ಗಾಮಾ ನಜಿಕಮ್ಮಾ ವ್ಹತ್ತಾ. ತೆ ಹಮನೊನೆ ಸ್ವಾಗತ ಕರಿನ ತನ್ನ ದಿನ ತಕ್ಕಾ ಘನ್ನಾ ಇಜತ್ತಕ್ಹು ವರಿ ಮರ್ಯಾದಿ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ತ್ಯುನೊ ಬಾಪ ತೌಕ್ಹು ವರಿ ರಕ್ತಬೆದಿಕ್ಹು ವಚಾನು ಧರ‍್ಯೊತೊ. ಪೌಲಾ ತಿಕನ ಗೈನ ಪ್ರಾರ್ಥಾನಾ ಕರಿನ ತಿನಾ ಹತೊ ಮ್ಹೆಲಿನ ತಿನೆ ಅರಾಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ತೆ ಥಹೆಲ ಪರ ತೆ ದ್ವಿಪಮ್ಮಾ ಉಗರೆಲ ರೊಗಿಯೊ ಪೌಲಾ ಕನ ಐನ ಆರಾಮ್ಮ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ತ್ಯುನೆ ಹಮನೊನೆ ಘನ್ನಾ ಮರ್ಯಾದಿ ದಿನ್ನ ಹಮೆ ತ್ಯಾತಾ ಹಮ್ಮಾರು ಪ್ರಯಾಣ ಅಗಾ ಬಡಾಯೆಲ ಪರ ಹಮನೊನೆ ಚಾಯೆಲ ಥಯಲ ಕ್ಹಾವಾನು ಲೈನ ಹಡಗಮ್ಮಾಮ್ಹೆಲಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ಎ ಥಯಲ ಪರ ಅಲೆಕ್ಸಾಂಡ್ರಿಮ್ಮಾತ್ತಾ ಐನ ತೆ ದ್ವಿಪಮ್ಮಾ ಥಂಡನೊ ದಿನ್ನ ದಾಟಿನ ತ್ಯಾ ರಹೆಲ ಯಕ್ಕ ಹಡ್ಗೊ ಚ಼ಡಿನ ಚಾ಼ಲ್ಯಾ. ತೆ ಹಡಗನೆ ಅಶ್ವಿನಿ ದೆವಸ್ಥಾನ ಕವಾನು ಯಕ್ಕ ವಳಕ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ಹಮ್ಮೆ ಸುರಕುಸಿನೆ ಗೈನ ತ್ಯಾ ತನ್ನ ದಿನ್ನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ತ್ಯಾತಾ ಅಗಾ ಗೈನ ರೆಗಿನ ಗಾಮ್ಮೆ ಗಯಾ. ಯಕ್ಕ ದಿನ ಥಯಲ ಪರ ತೆಂಕಣ ವಾರೊ ಆಯೆಲಕ್ಹು ಬೆವಾ ದಿನ್ನೆ ಪೊತಿಯೊಲನೆ ಗಾಮೆ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ತ್ಯಾ ವಿಸ್ವಾಸಿಯೊ ಮನಕ್ಹೊನೆ ದೆಕ್ಯಾ. ತ್ಯುನೆ ಹಮನೊನೆ ತ್ಯುನೊ ಕೈನ ಬಲೆಲಿನ ಕ್ಹಾತ ದಿನ ರ‍್ಹೈವು ಕೈನ. ಮಾಂಗಿಲಿದ್ಯಾ ತೆಳಾಮಾ ರೊಮಾಪುರನೆ ಆಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ತ್ಯಾ ರಹೆಲ ಭಾಯೊ ಹಮ್ಮಾರು ಸಮಾಚಾರ ಐಕಿನ ಹಮ್ಮನೊನೆ ಮಳಾನೆ ದಕ್ಹಜ಼ನಾ ಅಪ್ಪಿಯಪೆಟೆಲಕುನ ವರಿ ದಕ್ಹಾಜ಼಼ನಾ ತ್ರಿ ಛತ್ರಕವಾನು ಜ಼ಗಾಮಟಾ ಆಯಾ. ಪೌಲಾ ತ್ಯುನೊನೆ ದೆಕಿನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕರಿನ ಧೈರ‍್ಯಕ್ಹು ರ‍್ಹಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ಹಮ್ಮೆ ರೊಮಾಪುರನೆ ಆಯಲ್ಪರ, ಪೌಲಾ ತಿನೆ ಕೈದಾಲಾ ಸಿಪಾಯಿನಾ ಕ್ಹಾತೆ ಜ಼ುದೊ ಥೈನ ರ‍್ಹೌ ಕೈನ ಅಪ್ಪಣೆ ಹೊಂದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ತನ ದಿನ್ನ ಥಯಲ್ಪರ ಯೆಹುದಿಯೊನೊ ಖಾಸ ಮನಕ್ಹೊನೆ ತಿಕನ ಬಲೈಲಿದ್ಯೊ. ತ್ಯುನೆ ಆತಾಮಾ ತೆ ತ್ಯುನೊನೆ; ಭಾಯೊ, ಮಿ ಮಾರಾ ಮನಕ್ಹೊನೆ, ಮಾರಾ ಪಿತೃವೊನೆ ಪದ್ದತಿಯೊನಾ ವಿರುದ್ದ ಥೈನ ಸುಜ಼ ಕರಾವಾಲೊ ನೈಸೊಜ಼ ಯೆರುಸಲೆಮತೊ ರೊಮವಾಲಾವೊನಾ ಹತೊಮಾ ಜೆಲಮ್ಮಾ ರ‍್ಹವಾಲೊ ಥೈನ ಒಪ್ಪಸಿ ದಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ತ್ಯುನೆ ಮನೆ ವಿಚಾರಣೆ ಕರಿನ, ಮಾರಾವಾನಿ ದಂಡನೆನೆ ಕಾರಣ ಸು ನೈಸೊ ಮನೆ ಚ್ಹೊಡೌ ಕೈನ ವ್ಹತ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ತಿನಾಹುತಿ ಯೆಹುದಿಯೊ ವಿರುದ್ದ ಕರಲಕ್ಹು, ಮಿ ಕೈಸರನಾ ಕ್ಹಾಮೊ ಕಲಿದ್ಯುಸ ಕೌವ ಕೈನ ಐಯು. ಮಾರಾ ಸ್ವಂತ ದೆಶವಾಲಾವೊನಾ ಉಪ್ಪರ ದೊಷಾರೊಪಣೆ ಘಾಲುನಾ ಮನಸ ಕ್ಹು ತೆ ಕದ್ಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ಎ ಕಾರಣನಾ ಹುತಿ ಮಿ ತುಮನೊನೆ ದೆಕಿನ ಬೊಲು ಕೈನ ಬಲೆಲಿದ್ಯೊ. ಇಸ್ರಾಯೆಲ ಮನಕ್ಹೊನಾ ಕೈದಾನಾ ಹುತಿ ಎ ಬೆಡಿಯೊಕ್ಹು ಭಂದಿ ಥಯೊಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ತಿನಾಹುತಿ ತ್ಯುನೆ ತಿನೆ; ತಾರಾ ವಿಷಯಮಾ ಹಮೊನೆ ಯುದಾಯತಿ ವರದಿ ಐ ನೈ, ಭಾಯೊಮಾ ಯಕ್ಲೊ ಐನ ತಾರಾ ವಿಷಯಮಾ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಸುಬಿ ಕದೊನೈ. ಸುಜ಼ ಬೊಲ್ಯಾ ಬಿ ನೈ. ");
INSERT INTO sle_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ತೆನೈಸೊ, ತಾರಾ ವಿಚಾರಮಾ ತಾರಾಕ್ಹುಜ಼ ಐಕು ಕೈನ ಹಮೊನೆ ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ದಿಕ್ಹಸ. ತೆ ಗುಂಪನಾ ವಿಷಯಮಾ ಮನಕ್ಹೊ ಕಜ಼ಾ ಕಜಾ಼ ಕಿಜ಼ ವಿರುದ್ದ ಥೈನ ಬೊಲಸ ಕರಿನ ಕೈನ ಯಕಜ಼ ಹಮೊನೆ ಗ್ವತ್ತ ಛೆ ಕದ್ಯಾ”. ");
INSERT INTO sle_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ತ್ಯುನೆ ತಿನೆ ಯಕ್ಕದಿನ್ನ ಪೌಲಾ ಗ್ವತ್ತ ಕರಾಯಲಕ್ಹು, ಘನ್ನಾ ಜ಼ನಾ ತಿನಾ ಝುಪ್ಡಾಮಾ ತಿಕನ ಆಯಾ. ತೆ ಪಾಟತೊ ಧರಿನ ಕ್ಹಾಂಜ ಮಟಾ ಕ್ಹುದಾನಾ ರಾಜ್ಯನಾ ಹುತಿ ಕ್ಹರಿಮ್ಮಾಜ಼ ಸಾಕ್ಷಿ ಕೈನ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನೆ ಪ್ರವಾದಿಯೊನಾ ಗ್ರಂಥತೊನೆ ಆದಾರ ಕರಲಿನ ಯೆಸುನಾ ವಿಷಯಮಾ ತ್ಯುನೊನೆ ಕತೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ತೆ ಕದಲ ವಾತೊ ದಕ್ಹಾಜ಼಼ನಾ ಐಕ್ಯಾ; ದಕ್ಹಾಜ಼಼ನಾ ನಂಬ್ಯಾವಾಚಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ತ್ಯುನೆ ವಾದ ಕರಿನ ತ್ಯಾಂತಾ ಜ಼ಾವಾನೆ ತಯಾರ ಥಯಲ ಟೈಮಮಾ ಪೈಲಾ ತ್ಯುನೊನೆ ಅಮ್ಮ ಕದ್ಯೊ; ಪವಿತ್ರಾತ್ಮಾ ಪ್ರವಾದಿ ಥಯಲ ಯೆಶಾಯನಾ ಮ್ಹೊಡಾಕ್ಹು ");
INSERT INTO sle_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ತಮ್ಮಾರಾ ಪಿತೃವೊನೆ ತಿಳಸೈನ ಕದಲ ಸವೈ ಕದ್ಯಾಮ; ‘ತು ತೆ ಮನಕ್ಹೊಕನ ಗೈನ ತ್ಯುನೊನೆ ಕದ್ಯೊ ತಮೆ ಕಾನೊ ಐಕ್ಯಾತಬಿ ತಿಳದಿಲೆತ್ತಾ ನೈ. ಡೊಳಾ ರ‍್ಹೈನ ದೆಕೆವಾಚಿ ರ‍್ಹವೊಸಿ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ಕಾಕದ್ಯಾಮ ತೆ ಮನಕ್ಹೊನು ಮನಸಮ್ಮಾ ಘಟ್ಟ ಥಯಾಸ; ತ್ಯುನಾ ಕಾನೊ ಕ್ಯುಡಾ ಥಯಾಸ; ತ್ಯುನೆ ಡೊಳಾ ಝಾಕಿ ಲಿದ್ಯಾಸ ;ತ್ಯುನೆ ಡೊಳಾಕ್ಹು ದೆಕಿ, ಕಾನೊಕ್ಹು ಐಕಿನ ಮನಸ್ಸ ತಿಳಿದಿಲಎತ್ತು ಮಕನ ಫರ‍್ಯಾಮ್ಮಾ ಮಾರಾಕ್ಹು ಅರಾಮ ಕಿಮ್ಮ ಹೊಂದಿಲ್ಯು ಕೈನ ಕ್ಹುದಾ ಕ್ಹದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ತಿನಾಹುತಿ ಪೌಲಾ ಥಯಲ ತೆ ಕ್ಹುದಾಕ್ಹು ರಕ್ಷಣೆ ಬಿಜಾ಼ ಮನಕ್ಹೊ ಕೈನ ವಳಾಯೊ ಕೈನ ತಮನೊನೆ ಚೊ಼ಕಿ ತಂಗ ಗೊತ್ತ ರ‍್ಹವಾದೆ; ತ್ಯುನೆ ತಬಿ ಐಕಸ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ತೆ ವಾತೊ ಕದಲ ಪರ ತ್ಯುನೆ ಗೈಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ತೆ ಥಯಲ ಪರ ಪೌಲಾ ಬಾಡಿಗೆ ಲಿದೆಲ ಘರಾಮ್ಮಾ ಬೆ ವರಕ್ಹ ತ್ಯಾ ರ‍್ಹೈನ ತಿಕ ಆವಾವಾ ಲಾವೊನೆ ಮರ್ಯಾದಿನ ಬಲಾವುನು ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ಕೈಜ಼ ಅಡ್ಡಿ ನೈಸೊ, ಘನೊ ಧೈರ್ಯಕ್ಹು ಕ್ಹುದಾನಿ ರಾಜ್ಯನಾ ಹುತಿ ಬೊದನೆ ಕರತೊ, ಕರ್ತಾ ಥಯಲ ಯೆಸುಕ್ರಿಸ್ತನಾ ವಿಷಯಮ್ಮಾ ಉಪದೆಶ ಕರತೊ ವ್ಹತ್ತೊ.");
INSERT INTO sle_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ಯೆಸು ಕ್ರಿಸ್ತನೊ ಸೆವಕ ಥಯಲ ಪೌಲಾ ಬರ್ದಾನು ಪತ್ರ. ಕ್ಹುದಾ ಮನೆ ಅಪೊಸ್ತಲ ಥಾವಾನಾ ಹುತಿ ಮನೆ ಬಲಾಯೊ. ಕ್ಹುದಾನಿ ಸುವಾರ್ತೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊಕನ ಕವಾನಾ ಹುತಿ ಮನೆ ಇನಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊಕನ ಎ ಸುವಾರ್ತೆ ದಿವಾನಾ ಹುತಿ ಘನ್ನಾ ದಿನ್ನ ಪಾಚೊ಼ಜ಼ ವಾತ ದಿದಲ ತಿಮ್ಮ ತಿನಾ ಪ್ರವಾದಿಯೊನಾ ಮುಲಕ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಹುತಿಜ಼ ತೆ ಸುವಾರ್ತೆ ವ್ಹೈ. ಮನಕ್ಹ ಥೈನ ತೆ ದಾವಿದನಾ ಖಾಂದಾನಮಾ ಹುಟ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ತೆನೈಸೊ ಯೆಸು ಪವಿತ್ರ ಆತ್ಮಾನಾ ಮುಲಕ ಮ್ಹೊಟಿ ತಾಕತನಾ ಕ್ಹಾತೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ತೆಜ಼ ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ಕ್ಹುದಾ ತಿನಾ ಮುಲಕ ಮನೆ ಕ್ರಿಸ್ತನಾ ಹುತಿ ಅಪೊಸ್ತಲ ಥಾವಾನೆ ನಸಿಬ ದಿದ್ಯೊ. ಕ್ಹಾರಾ ದೆಶನಾ ಮನಕ್ಹೊನೆ ತಿನಾ ಬರೊಕ್ಹಾಮಾ ಲೌ ಕೈನ ಕ್ಹುದಾ ಮನೆ ಎ ಭಾಗ್ಯ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ರೊಮಮಾ ರ‍್ಹಯಲವಾಲಾ ತುಮೊನೆ ಬಿ ಕ್ರಿಸ್ತನಾ ಥಾವಾನಾ ಹುತಿ ಕ್ಹುದಾ ಬಲಾಯಲವಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ರೊಮಮಾ ರ‍್ಹಯಲವಾಲಾ ಕ್ಹುದಾನಾ ಸ್ವಂತ ಮನಕ್ಹೊ ಥಾವಾನಾ ಹುತಿ ಕ್ಹುದಾಜ಼ ಬಲಾಯಲವಾಲಾ ಥಯಲ ತುಮೊನೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಎ ಪತ್ರ ಬರ್ದಾಡ್ಯೊಸ. ತುಮೆ ಕ್ಹುದಾನೆ ಮಯಾನಾ ಮನಕ್ಹೊ ಥಯಾಸ. ಅಪ್ನೊ ಬಾ ಥಯಲ ಕ್ಹುದಾಕ್ಹು ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತಕ್ಹು ತುಮೊನೆ ಕೃಪಾ ವರಿ ಶಾಂತಿ ಮಳಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ಪೈಲಾ, ಮಿ ತುಮಾರಾ ಹುತಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಮಾರಾ ಕ್ಹುದಾನೆ ಧನ್ಯವಾದ ಕೌಸ. ಕಾಕದ್ಯಾಮ ತುಮಾರೊ ಬರೊಕ್ಹೊ ಕ್ಹಾರಿ ಜಗತ್ಮಾ ಫೈಲಿ ಗಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ಕ್ಹುದಾ ತಿನಿ ಸೆವೆ ತಿನಾ ದಿಕ್ರಾನಾ ಹುತಿ ಸುವಾರತೆನು ಉಪದೆಶ ಕರತೊ ಮಿ ಮಾರಾ ಮನಸೆ ತಿನಿ ಸೆವಾ ಕರಾಡ್ಯೊಸ. ಇನೆ ಕ್ಹುದಾಜ಼ ಸಾಕ್ಷಿ ವ್ಹೈ. ಕಾಕದ್ಯಾಮ ಮಿ ಪ್ರಾಥನಾ ಕರತಾಮಾ ತುಮೊನೆ ಹಮೆಶಾಬಿ ಶೆ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ಮಾರಿ ಪ್ರಾಥನಾಮಾ ಹಮೆಶಾಬಿ ಸು ಮಾಂಗಿಲ್ಯುಸ ಕದ್ಯಾಮ ಕ್ಹುದಾನಿ ಮರ್ಜಿ ಲಿಂಗತ ತುಮೊಕನ ಕಿಮ್ಮೆಬಿ ಆವಾನೆ ಥಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ಮಿ ತುಮೊನೆ ದೆಕಾನೆ, ತುಮೊನೆ ಆತ್ಮಿಕನಾ ಆಶಿರ್ವಾದೊ ವಾಟಿ ಲಿವಾನೆ ವರಿ ತುಮೊನೆ ಘಟ್ಟ ಕರಾನೆ ಮಾರು ಘನ್ನು ಮನಸ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ಕದ್ಯಾಮ ಅಪೊಮಾ ರ‍್ಹಯಲ ಬರೊಕ್ಹೊ ಕ್ಹು ಅಪೆ ಯಕ್ನಾ ಯಕ್ಕ ಮದದ ಕರು ಕೈನ ಮಾರಿ ಆಸ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ಭಾಯೊ ಭೆನೊ, ಮಿ ತುಮೊಕನ ಆವಾನೆ ಘನ್ನಿ ಸಲಾ ಕೊಶಿಶ ಕರ‍್ಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ರ‍್ಹವಾದೆ. ತೆನೈಸೊ ಮನೆ ತುಮೊಕನ ಆವಾನೆ ದಕ್ಹಿಯೊ ವಾತೊ ತಡ್ದಿಯೊ. ಮಿ ವಿಚಾರ ಕರುಸ ಕಿಮ ಯಹುದ್ಯೊ ನೈರ‍್ಹಯಲ ಮನಕ್ಹೊಕನ ಫಲ ಮಳ್ಯುಸ ತಿನಾ ಲಿಂಗತ ತುಮೊಕ್ಹೊ ಮನೆ ಫಲ ಮಳು ಕೈನ ಮಾರಿ ಆಸ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ಮಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಕದ್ಯಾಮ ಗ್ರಿಕವಾಲಾ ವರಿ ಗ್ರಿಕ ನೈಸೊವಾಲಾ ಮನಕ್ಹೊನೆ, ವರಿ ಗ್ಯಾನಿಯೊನೆ ವರಿ ಗ್ಯಾನ ನೈಸೊವಾಲಾವೊನೆ ಸುವಾರ್ತೆ ಕವಾನು ಭಾರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ತಿನಾಹುತಿ ರೊಮಮಾ ರ‍್ಹಯಲ ತುಮೊನೆ ಸುವಾರ್ತೆ ಕವಾನೆ ಮನೆ ಘನ್ನಿ ಆಸ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ಮಿ ಸುವಾರ್ತೆನಾ ಹುತಿ ಆತ್ಮ ವಿಸ್ವಾಸಕ್ಹು ಛೆ. ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ಹರ ಯಕ್ಲಾನಾ ರಕ್ಷಣೆನಾ ಹುತಿ ಕದ್ಯಾಮ ಪೈಲಾ, ಯಹುದಿಯೊನೆ ಪಾಚಾ಼ತಾ ಯೆಹುದಿ ನೈಸೊವಾಲಾವೊನೆ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ವಾಲಾವೊನೆ ರಕ್ಷಣೆ ಕ್ಹುದಾನಿ ತಾಕತ ಥೈಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ಕಾಕದ್ಯಾಮ ಸುವಾರ್ತೆ ಎ ದೆಕಾಡಿನ ದಿವಸ ಕ್ಹುದಾ ಮನಕ್ಹನೆ ತಿನಾ ಕ್ಹಾತೆ ನಿತಿವಂತ ಥೈನ ಇಮ್ಮ ಕರಸ ಎ ಪೈಲಾತು ಲಾಸ್ಟ ಲಕ್ಕಾ ಬರೊಕ್ಹಾಕ್ಹು ಥಾವಸ. ಇನಾ ಲಿಂಗತ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ; \"ಕಯೊ ಮನಕ್ಹ ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ ತಿನಾಕ್ಹು ತಿನೆಜ ನಿತಿವಂತ ಕರಿಲಿವಸ ತೆ ಬರೊಕ್ಹಾಕ್ಹು ಜಿವ್ನಾ ಕರಸ\" ");
INSERT INTO sle_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ಕ್ಹುದಾನಿ ಶಿಟ್ಟ ಸ್ವರಗತಿ ದಿಕ್ಹಿನ ಆವಸ. ಮನಕ್ಹೊ ಕ್ಹುದಾನಾ ವಿರುದ್ದ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊ ವರಿ ದುಶಕೃತ್ಯನಾ ಹುತಿ ಕ್ಹುದಾ ಶಿಟ್ಟ ಥಯೊಸ. ತ್ಯುನೊನೆ ಕ್ಹರಿ ಸುವೈ ಕವಾನು ಗ್ವತ್ತ ಥಯುಸ, ತೆನೈಸೊ ತ್ಯುನಾ ಕೆಟ್ಟ ಕಾಮೊಜ಼ ಕ್ಹರಿ ಕವಾನು ಝಾಕಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಶಿಕ್ಷಾ ದಿವಸ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾನಾ ಹುತಿ ತಿಳದಿಲಿವಾನು ಹರಿಯಕ್ಕ ತ್ಯುನೊನೆ ಆಸಾನ ಛೆ. ಕ್ಹುದಾಜ಼ ತೆ ಆಸಾನ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ಮನಕ್ಹೊನಿಯೊ ಕ್ಹುದಾನಿ ಹಮೆಶಾನಿ ತಾಕತನೆ ತಿನಿ ಮಹಿಮಾ ರ‍್ಹೈನೆಕಾ ದೆಕತಾ ನೈ. ತೆನೈಸೊ ಜಗತ್ನಿ ಶುರುತಾಬಿ ತೆ ಸಂಗತಿಯೊ ಮನಕ್ಹೊನೆ ಆಸಾನ ತರಿಕಾ ಕ್ಹು ಗ್ವತ್ತ ಥಾವಸ. ಕ್ಹುದಾ ಕರಲ ಸೃಷ್ಟಿಮಾ ತೆ ಸಂಗತಿಯೊ ದಿಕ್ಹಿನ ಆವಸ. ತಿನಾಹುತಿ ಮನಕ್ಹೊ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊನೆ ನೆವಾ ಕವಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ ಕ್ಹುದಾನೆ ತಿಳದಿಲಿದ್ಯಾತಬಿ ಕ್ಹುದಾನೆ ಮೆಚ್ಚಶ್ಯಾ ನೈ, ತಿನೆ ಕೃತಜ್ಞತಾ ಸ್ತುತಿ ಕರ‍್ಯಾ ನೈ. ಮನಕ್ಹೊನಿಯೊ ವಿಚಾರೊ ಸುಜ಼ ಫೈದೊ ಥಯ್ಯೊ ನೈ. ಸು ನೈ ಕಳಲ ತ್ಯುನಾ ಮನಸೊ ಅಂದಾರಾ ಕ್ಹು ಭರಿ ಗಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ತ್ಯುನಾಕ್ಹು ತ್ಯುನೊನೆ ಗ್ಯಾನಿಯೊ ವ್ಹೈ ಕೈನ ಕೈಲಿನ ಪಿಸಾಳಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ಹಮೆಶಾಬಿ ರ‍್ಹವಾನಿ ಕ್ಹುದಾನಿ ಆರಾಧನಾ ಕಾರಾನು ತ್ಯುನೆ ಛೊಡಿನ ದಿನ್ನ ಹಾಳ ಥಾವಾನಾ ಮನಕ್ಹೊನಾ ಲಿಂಗತ ರ‍್ಹಯಲ, ಪಕ್ಷಿಯೊ ಲಿಂಗತ ರ‍್ಹಯಲ, ಜಾನವರೊ ಲಿಂಗತ ವರಿ ಕ್ಹಾಪೊ ಲಿಂಗತ ರ‍್ಹಯಲ ಮೊರತಿಯೊ ಕರಲಿನ ತ್ಯುನೊನೆ ಆರಾಧನಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ಕ್ಹುದಾ ತ್ಯುನಾ ಮನಸೆ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊನೆ ತ್ಯುನೊನೆಜ಼ ವಪ್ಸಿನ ದಿದ್ಯೊ. ವರಿ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಸರಮಾವಾನಾ ಕಾಮೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ತ್ಯುನೆ ಕ್ಹುದಾನಿ ಕ್ಹರಿನೆ ಸುಳ್ಳಮಾ ಬದಲಿ ಕರ‍್ಯಾ. ತ್ಯುನೆ ತಯ್ಯಾರ ಕರಲ ಸಾಮನ್ನೆ ಪುಜಾ ಕರ‍್ಯಾ.. ತೆನೈಸೊ ಎ ಕ್ಹಾರು ತಯ್ಯಾರ ಕರಲ ಕ್ಹುದಾನೆ ತ್ಯುನೆ ಆರಾಧನಾ ಕರಾನು ಛೊಡಿ ಪಾಡ್ಯಾ; ತೆ ಕ್ಹುದಾನೆ ಹಮೆಶಾಬಿ ಸ್ತುತಿ ಥಾವಾದೆ. ಆಮೆನ. ");
INSERT INTO sle_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ತ್ಯುನೆ ಇಮ್ಮ ಕರಲ ಹುತಿಜ಼, ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಸರಮಾವಾನಾ ಕಾಮ್ಮಾಜ಼ ಛೊಡಿನ ದಿದ್ಯೊ. ತ್ಯುನೆ ಬಾಕ್ಡಿಯೊ ದಾಣಗಾವೊನಾ ಕ್ಹಾತೆ ಮಳಿನ ಕರಾನಾ ಲೈಂಗಿಕ ಕಾಮೊನೆ ಹುಬ್ರಾಡಿನ, ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಸಂಭಂಧ ಮ್ಹೆಲ್ಲಿದಿಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ತಿನಾ ಲಿಂಗತಜ಼, ದಾಣ್ಗಾ ಬಾಕ್ಡಿಯೊನಾ ಕ್ಹಾತೆ ಕರಾನು ಮಾಮುಲಿ ಲೈಂಗಿಕ ಕಾಮೊಮಾ ಹುಬ್ರಾಡಿನ ಉದ್ರೆಕ ಥೈನ ತ್ಯುನೊ ತ್ಯುನೊಮಾಜ಼ ಸಂಭಂಧ ಮ್ಹೆಲ್ಲಿದ್ಯಾ. ದಾಣ್ಗಾ ತ್ಯುನೊ ತ್ಯೊನೊಮಾಜ಼ ಸರಮಾವಾನಾ ಕಾಮೊ ಕರ‍್ಯಾ. ತ್ಯುನಿ ಕೆಟ್ಟ ನಡೆತೆಕ್ಹು ತಿನಾ ತಕ್ಕ ದಂಡ ತ್ಯುನಾ ಅಂಗನೆ ಆವಾ ವರಕ್ಹು ಕರಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ಕ್ಹುದಾನು ಕ್ಹರಿನು ಗ್ಯಾನ ಹೊಂದಿಲಿವಾನೆ ವಪ್ಪಿಲಿದ್ಯಾ ನೈ ತ್ಯುನೊನೆ ಕ್ಹುದಾ ತ್ಯುನೊನೆ ತ್ಯುನಾ ಅಯೊಗ್ಯ ಮನಸನೆ ವಪ್ಸಿನ ದಿದ್ಯೊ. ತಿನಾಹುತಿ ತ್ಯುನೆ ನೈಸೊ ಕರಾನಾ ಕಾಮೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ತ್ಯುನೊಮಾ ಹರಿ ಯಕ್ಕ ತರಾನಾ ಪಾಪೊ, ದುಷ್ಟತನಾ, ಸ್ವಾರ್ಥ, ಶಿಟ್ಟ, ಸಂಗಟ ಘಾಲ್ಲಿವಾನು, ಖಲಾಸ ಕರಾನು ಲಡೈ ಕಾಡಾನು, ಸುಳ್ಳ ಬೊಲಾನು ವರಿ ಕೆಟ್ಟ ವಿಚಾರೊ ಎ ಕ್ಹಾರು ಭರಿ ಗಯೊಸ. ಯಕ್ಕಲಾಪರ ಯಕ್ಲೊ ಚಾ಼ಡಿ ಕವಸ; ");
INSERT INTO sle_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ಯಕ್ಕನೆ ಯಕ್ಕ ಕೆಟ್ಟ ವಾತೊ ಬೊಲಸ. ಕ್ಹುದಾನೆ ದ್ವೆಷ ಕರಸ. ತ್ಯುನೆ ಸ್ವಕ್ಕವಾಲಾ ಥೈನ ಅಹಂಕಾರಿಯೊ ಥೈನ ವರಿ ತ್ಯುನಾ ಕ್ಹು ತ್ಯುನೆ ಮಿ ವ್ಹೈ ಕೈನ ಕವೈಲಿನ ಥಯಲ ರ‍್ಹವಸ. ತ್ಯುನೆ ಕೆಟ್ಟ ವಾತೊ ಬೊಲಾನೆ ಘನಿಯೊ ವಾಟೊ ಹುಡ್ಕಸ. ಮಾ ಬಾಪನೆ ಅವಿಧೆಯ ಥೈನ ಪಿಸಾಳಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ತ್ಯುನೆ ದಿದಲ ವಾತ ಪುರಾ ನೈ ಕರಾಲಾ ಬಿಜಾ಼ವೊನೆ ಮರಗಾ ದೆಕಾಡಾಲಾ ಥಾತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ಹೆವಾವೊನೆ ಮರವಾನಿ ಶಿಕ್ಷಾ ಮಳು ಕೈನ ಧರಮಶಾಸ್ತ್ರ ಕವಸ ಕವಾನು ತ್ಯುನೊನೆ ಗ್ವತ್ತ ಛೆ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ಹವಾ ಕಾಮೊ ಕರ‍್ತಾಜ಼ ರ‍್ಹವಸ. ವರಿ ಹವಾ ಕಾಮೊ ಕರಾನಾ ಮನಕ್ಹೊನೆ ಪ್ರೊತ್ಸಾಹಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","\"ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಫೈಸಲೊ ಕರಿಯೆಸ \"ಕೈನ ತುಮಾರಿ ವಿಷಯಮಾ ವಿಚಾರ ಕರೊ ನಕೊ. ಕಾಕದ್ಯಾಮ ತುಮೆಬಿ ಪಾಪ ಕರಿನ ಅಪರಾದಿಯೊ ಥಯಾಸ. ತುಮೆ ತೆ ಮನಕ್ಹೊನೆ ಫೈಸಲೊ ಕರೊಶಿ. ತೆನೈಸೊ ತೆಜ಼ ಕಾಮೊ ತುಮೆ ಕರೊಶಿ. ತಿನಾಹುತಿ ತುಮೆ ತ್ಯುನೊನೆ ಫೈಸಲೊ ಕರತಾಮಾ, ಕ್ಹರಿಮಾಜ಼ ತುಮೊನೆಜ಼ ಫೈಸಲೊ ಕರಿಲಿವಾಲಾ ಥಾವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ಅಪರಾದ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ಫೈಸಲೊ ಕರಸ. ತಿನೊ ಫೈಸಲೊ ಕ್ಹರಿನೊ ವ್ಹೈ ಕೈನ ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ತೆ ಅಪರಾದೊ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ತುಮೆಬಿ ಫೈಸಲೊ ಕರೊಶಿ. ತೆನೈಸೊ ತುಮೆಜ಼ ತೆ ಅಪರಾದೊ ಕರೊಶಿ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಕ್ಹುದಾನಿ ನ್ಯಾಯ ಕ್ಹು ಚು಼ಕೈಲಿವಾನೆ ಸಾದ್ಯ ನತ್ತಿ ಕೈನ ತುಮೊನೆ ಕ್ಹರಿಬಿ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ಕ್ಹುದಾ ತುಮಾರಿ ವಿಷಯಮಾ ಘನ್ನು ಮರಗಾಲೊ ಥಯೊಸ; ತಡ್ದಿಲಿವಾಲೊ ವ್ಹೈ. ತುಮೆ ಬದಲಿ ಥೌ ಕೈನ ಕ್ಹುದಾ ತುಮಾರಾ ಹುತಿ ಕೈದಾಡ್ಯೊಸ. ವರಿಬಿ ತುಮೆ ತಿನಿ ಮರಗಾನಾ ಹುತಿ ವಿಚಾರ ಕರತಾ ನೈ. ತುಮೆ ತುಮಾರಿ ಮನಸೊ ಜಿವ್ನಾ ಬದಲಿ ಕರಲಿವಾನೆ ಥಾವಸ ಕೈನ ಕ್ಹುದಾನಿ ಮರಗಾನೆ ತಿಳ್ದಿಲಿದ್ಯಾವಾಚಿ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ತೆನೈಸೊ ತುಮೆ ಘಟ್ಟ ಮನಸನಾ ವರಿ ಮಂಡ ಚಾಳಿನಾ ಥಯಾಸ. ತಿನಾಹುತಿ ತುಮೊನೆ ಆವಾನು ರ‍್ಹಯಲ ಶಿಕ್ಷಾ ತುಮೆ ಹೆಚ್ಕಿ-ಹೆಚ್ಕಿ ಕರಲಿವಾಡ್ಯಾಸ. ಕ್ಹುದಾ ತಿನಿ ಶಿಟ್ಟ ದೆಕಾಡಾನಾ ಟೈಮಾ ತುಮೊನೆ ತೆ ಶಿಕ್ಷಾ ಥಾವಾಸ. ತೆ ದಿನ್ಮಾ ಕ್ಹುದಾನಿ ನ್ಯಾಯನಿ ಫೈಸಲೊ ಮನಕ್ಹೊ ದೆಕಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾ ಹರಿ ಯಕ್ಲಾನೆ ತ್ಯುನೆ-ತ್ಯುನೆ ಕರಲ ಕಾಮೊನಾ ತಕ್ಕ ಪ್ರತಿ ಫಲ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ದಕ್ಹಾ ಮನಕ್ಹೊ ಮಹಿಮಾನಾ ಹುತಿ, ಮರಯಾದಿನಾ ಹುತಿ ವರಿ ತ್ಯುನು ಹಮೆಶಾನು ಜ಼ಲಮ ರ‍್ಹೌ ಕೈನ ಕೆಳಾಮಾಬಿ ಚೊ಼ಕಾ ಕಾಮೊ ಕರತಾ ಜಿವ್ನಾ ಕರಸ. ಕ್ಹುದಾ ತೆ ಮನಕ್ಹೊನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ತೆನೈಸೊ ಉಗ್ರಲ ಮನಕ್ಹೊ ಸ್ವಾರಥಿಯೊ ಥೈನ,ಕ್ಹರಿಪರ ಚಾ಼ಲ್ಯಾವಾಚಿ ಕೆಟ್ಟ ಕಾಮೊಪರ ಚಾ಼ಲಾಲಾ ಥಯಾಸ. ತ್ಯುನೊಪರ ಕ್ಹುದಾನಿ ಶಿಟ್ಟ ವರಿ ರುದ್ರ ಅವತಾರ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ಕೆಟ್ಟಜ಼ ಕರಾಲಾ ಹರಿ ಯಕ್ಲಾನೆ ಕದ್ಯಾಮ ಪೈಲಾ ಯಹುದಿಯೊನೆ, ಪಾಚಾ಼ತು ಯಹುದ್ಯೊ ನೈಸೊವಾಲಾವೊನೆ ಕಷ್ಟ ತ್ರಾಸೊ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ತೆನೈಸೊ ಚೊ಼ಕುಜ಼ ಕರಾಲಾ ಹರಿ ಯಕ್ಲಾನೆ ಕದ್ಯಾಮ ಪೈಲಾ ಯಹುದಿಯೊನೆ, ಪಾಚಲ್ತೊ ಯಹುದ್ಯೊ ನೈಸೊವಾಲಾವೊನೆ ಕ್ಹುದಾ ಮಹಿಮಾ, ಮರ್ಯಾದಿ ವರಿ ಶಾಂತಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ಕ್ಹುದಾ ಕಿನು ಸೈಡ ಲಿದ್ಯಾವಾಚಿ ಕ್ಹಾರಾವೊನೆ ಯಕ್ಕಜ಼ ತರಾ ಫೈಸಲೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ಯೆಹುದಿ ನೈಸೊ ಮನಕ್ಹೊಕನ ಮೊಶೆನಾ ನಿಯಮೊ ನತ್ತಿ. ತೆ ಮನಕ್ಹೊ ಧರಮಶಾಸ್ತ್ರ ಗ್ವತ್ತ ನೈಸೊ ಪಾಪ ಕರಸ. ಯಹುದ್ಯೊಕನ ಧರಮಶಾಸ್ತ್ರ ಛೆ ತ್ಯುನೆಬಿ ಪಾಪ ಕರಸ ವರಿ ತ್ಯುನೊ ನ್ಯಾಯನೊ ಫೈಸಲೊ ಧರಮಶಾಸ್ತ್ರನಾ ನಿಯಮ ಪ್ರಕಾರ ಫೈಸಲೊ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ಧರಮಶಾಸ್ತ್ರನೆ ಐಕಲಕ್ಹು ಮನಕ್ಹೊ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ನಿತಿವಂತವಾಲಾ ಥಾತಾ ನೈ. ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರ ಕವಾನಿ ಹರಿ ಯಕ್ಕ ವಾತನೆ ವಿಧೆಯ ಥಾವಾಲಾ ಮನಕ್ಹೊನೆ ಧರಮಶಾಸ್ತ್ರ ನಿತಿವಂತವಾಲಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ಧರಮಶಾಸ್ತ್ರ ಹೊಂದ್ಯಾ ನತ್ತಿ. ತೆನೈಸೊ ತ್ಯುನೆ ಧರಮಶಾಸ್ತ್ರನಾ ಲಿಂಗತ ಚಾ಼ಲಿನ ಜಾ಼ವತ್ತೊ, ತ್ಯುನೊನೆ ಧರಮಶಾಸ್ತ್ರನಿ ಜ಼ರುರತ್ತಜ಼ ನ್ಹೊತಿ. ");
INSERT INTO sle_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ತ್ಯುನಿ ಮನಸ್ಸನಾ ನಿಯಮೊ ಲಿಂಗತ ಕಯು ಕರೆಟ್ಟ ವ್ಹೈ, ಕಯು ತಪ್ಪ ವ್ಹೈ, ಕವಾನು ತ್ಯುನೆ ತ್ಯುನಾ ನಡತೆಕ್ಹು ದೆಕಾಡಿನ ದಿವಸ. ಎ ಕ್ಹರಿ ವ್ಹೈ ಕೈನ ತ್ಯುನಾ ಮನಸನಿ ಸಾಕ್ಷಿಕ್ಹು ದೆಕಾಡಿನ ದಿವಸ. ತ್ಯುನಿ ತೈಜ಼ ಗ್ಯಾನಕ್ಹು ತ್ಯುನೊನೆ ದೊಶಿ ವ್ಹೈ ಕೈನ ನೈತೊ ನಿರದೊಶಿ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ಮನಕ್ಹೊನು ಮನಸ್ಮಾ ದಡಿ ರ‍್ಹಯಲ ಸಂಗತಿಯೊನೆ ಕ್ಹುದಾ ಫೈಸಲೊ ಕರಾನಾ ದಿನ್ನೆ ಎ ಕ್ಹಾರು ಥಾವಸ. ಕ್ಹುದಾ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಮನಕ್ಹೊನೆ ಫೈಸಲೊ ಕರಸ ಕವಾನು ಸುವಾರ್ತೆ ಕೈನ ದಿವಸ. ಮಿ ಮನಕ್ಹೊನೆ ಕವಾನು ತೆಜ಼ ಸುವಾರ್ತೆ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","\"ಮಿ ಯಹುದ್ಯನೊ ವ್ಹೈ \"ಕೈನ ಕೈಲಿವಾನು ತಾರಿ ವಿಷಯ ಸುತೊ ವ್ಹೈ? ಧರಮಶಾಸ್ತ್ರಮಾ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿನ ಕ್ಹುದಾನಾ ನಜಿಕ ರ‍್ಹವಾನಾ ಹುತಿ ತು ಖುಶಿ ಥಾಶಿ. ");
INSERT INTO sle_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ಕ್ಹುದಾನಿ ಚಿತ್ತ ಲಿಂಗತ ರ‍್ಹಯಲ ಕಾಮೊ ಧರಮಶಾಸ್ತ್ರಕ್ಹು ಶಿಕ್ಕಲ ಹುತಿ ತು ಕೈಲೆಶಿ. ");
INSERT INTO sle_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ಚೊ಼ಕಿ ರ‍್ಹಯಲ ವಾಟ ನೈ ಗ್ವತ್ತ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ವಾಟ ದೆಕಾಡಾಲೊ ಅಂದಾರಾಮಾ ರ‍್ಹವಾಲಾ ಮನಕ್ಹೊನೆ ಉಜಾಲು ಥೈನ ರ‍್ಹೌ ಕೈನ ತಾರಾಹುತಿ ವಿಚಾರ ಕರಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ಮಡ್ಡ ರ‍್ಹಯಲವಾಲಾವೊನಾ ವಾಟ ದೆಕಾಡಾಲೊ ಲಿಂಗತ ವಳಕ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಮಾಸ್ತರ ಲಿಂಗತ ವ್ಹೈ ಕೈನ ತಾರಾಮಾ ಧರಮಶಾಸ್ತ್ರನು ಪುರಾ ಗ್ಯಾನ ವರಿ ಕ್ಹರಿ ಗ್ವತ್ತ ಛೆ ಕೈನ ತು ಕೈಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ತು ಬಿಜಾ಼ವೊನೆ ಶಿಕ್ಕಲಾಶಿ. ಇಮ್ಮ ರ‍್ಹಯುಮ ತು ತುನೆಜ಼ ಕಾ ಶಿಕ್ಲೈಲೆತೊ ನೈ? ಚೊ಼ರಿ ಕರು ನೈ ಕೈನ ತು ಮನಕ್ಹೊನೆ ಕಶಿ, ತೆನೈಸೊ ತುಜ಼಼ ಚೊ಼ರಿ ಕರಶಿ. ");
INSERT INTO sle_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ಮನಕ್ಹೊ ವ್ಯಭಿಚಾರ ಕರು ನೈ ಕೈನ ತುಜ಼಼ ಕಶಿ, ತೆನೈಸೊ ತುಜ಼಼ ತೆ ವ್ಯಭಿಚಾರ ನೈ ಕರ‍್ತೊ ಸು? ತು ಮೊರತಿಯೊನೆ ದ್ವೆಷ ಕರಶಿ, ತೆನೈಸೊ ತುಜ಼಼ ತೆ ಕ್ಹಾರು ಚೊ಼ರಿ ಕರ‍್ತೊ ನೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ತು ಕ್ಹುದಾನಾ ಧರಮಶಾಸ್ತ್ರನಾ ಹುತಿ ಘಮಂಡ ಕರಶಿ. ತೆನೈಸೊ ತು ಧರಮಶಾಸ್ತ್ರನೆ ದಾಟಿನ ಕ್ಹುದಾನೆ ಮರ್ಯಾದಿ ಕಾಡ್ತೊ ನೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","\"ಯಹುದ್ಯೊ ಥಯಲ ತಮಾರಾ ಹುತಿ ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಕ್ಹುದಾನಾ ನಾಮನೆ ವಿರುದ್ದ ಥೈನ ಬೊಲಸ \"ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ತು ಧರಮಶಾಸ್ತ್ರ ಲಿಂಗತ ಚಾ಼ಲ್ಯೊ ಕದ್ಯಾಮ ತು ಕರಿಲಿದಲ ಸುನ್ನತಿನೆ ಮತ್ಲಬ ಛೆ. ತೆನೈಸೊ ತು ಧರಮಶಾಸ್ತ್ರನೆ ದಾಟಿನ ಗಯೊಮ ತುನೆ ಸುನ್ನತಿ ನತ್ತಿ ಥೈ ಕೈನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಸುನ್ನತಿ ಥೈ ನತ್ತಿ, ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರ ಕವಾನು ತ್ಯುನೆ ಕರತಾ ರ‍್ಹಯಾಮ, ತ್ಯುನೆ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ಸುನ್ನತಿ ಕರೈಲಿದಲ ಲಿಂಗತ ನ್ಹವೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ಯಹುದ್ಯೊ ರ‍್ಹಯಲವಾಲಾ ತುಮೊನೆ ಬರ್ದಲ ಧರಮಶಾಸ್ತ್ರ ಛೆ ವರಿ ಸುನ್ನಿತಿ ಥೈಸ. ತೆನೈಸೊ ತುಮೆ ಧರಮಶಾಸ್ತ್ರನೆ ದಾಟಿನ ಚಾ಼ಲೊಶಿ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಅಂಗಮಾ ಸುನ್ನಿತಿ ನೈ ಥಯಲ ರ‍್ಹೈತಬಿ ಧರಮಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥಾವಾಲಾ ಮನಕ್ಹೊ ತುಮೊನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿವಸ. ಎ ");
INSERT INTO sle_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ಕ್ಹಾಲಿ ಭಾರಲ್ಯಾ ಅಂಗಮಾ ಯೆಹುದಿ ಥೈನ ರ‍್ಹವಾಲೊ ಯೆಹುದಿ ನ್ಹವೈ. ಕ್ಹಾಲಿ ಅಂಗನು ಭಾರಲ್ಯು ಸುನ್ನತಿ ಕ್ಹರಿನಿ ಸುನ್ನತಿ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ಮನಸ್ಮಾ ಯೆಹುದಿ ರ‍್ಹಯಲವಾಲೊಜ಼ ಕ್ಹರಿನೊ ಯೆಹುದಿ ವ್ಹೈ. ಮನಸ್ಮಾ ಥಯಲ ಸುನ್ನತಿ ಕ್ಹರಿನಿ ಸುನ್ನತಿ ವ್ಹೈ. ಎ ಸುನ್ನತಿ ಥಯಲ ಕ್ಹುದಾನಿ ಆತ್ಮಾಕ್ಹುಜ಼ ಥಯಲ ವ್ಹೈ ತೆನೈಸೊ ಬರ್ದಲ ಧರಮಶಾಸ್ತ್ರ ಕ್ಹು ನ್ಹವೈ. ಕ್ಹುದಾನಿ ಆತ್ಮಾಕ್ಹು ಮನಸ್ಮಾ ಸುನ್ನತಿ ಥಯಲ ಮನಕ್ಹ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾನು ಕ್ಹುದಾಕ್ಹು ವ್ಹೈ ತೆನೈಸೊ ಮನಕ್ಹೊ ಕ್ಹು ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ಇಮ್ಮ ರ‍್ಹಯುಮ ಯೆಹುದಿ ಥೈನ ರ‍್ಹವಾನು ಫೈದೊ ಸುವೈ? ಸುನ್ನತಿ ಕರೈಲಿದಲ ವಾಲಾವೊಮಾ ಸುಬಿ ಫೈದೊ ಛೆಸು? ");
INSERT INTO sle_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ಹೊ, ಯಹುದಿಯೊನೆ ಘನ್ನಾ ತರಾನು ಖಾಸ ಕವಾನು ಛೆ. ಕ್ಹಾರಾವೊತಿ ಘನ್ನು ಖಾಸ ಸು ವ್ಹೈ ಕದ್ಯಾಮ, ಕ್ಹುದಾ ಯೆಹುದಿಯೊಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿನ ತಿನು ವಾಕ್ಯಾ ತ್ಯುನೊನೆ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ದಕ್ಹಾ ಯೆಹುದಿಯೊನಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನೊ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಲಿದ್ಯಾನೈತೊ ಸು ಥಯು? ಇನು ಮತ್ಲಬ ಕ್ಹುದಾ ಬರೊಕ್ಹೊ ನೈಸೊ ರ‍್ಹವಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ನೈ! ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಸುಳ್ಳ ರ‍್ಹಯಾತಬಿ ಕ್ಹುದಾ ಕ್ಹರಿಕ್ಹು ರ‍್ಹವಾಲೊ ವ್ಹೈ. ಪವಿತ್ರ ಗ್ರಂಥ ಇಮ್ಮ ಕವಸ. ತಾರಿಯೊ ವಾತೊಮಾ ತು ಕ್ಹರಿನೊ ಫೈಸಲೊ ಕರಾಲೊ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದ್ಯು. ತುನೆ ಫೈಸಲೊ ಥಾತಾಮಾ ತು ಝಿತ್ತು. ");
INSERT INTO sle_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ಕ್ಹುದಾ ಕ್ಹರಿಕ್ಹು ರ‍್ಹವಾಲೊ ವ್ಹೈ ಕೈನ ಅಪೆ ಹಗ್ಲೆಲ್ಲಾ ಕರಾನಾ ತಪ್ಪೊ ದೆಕಾಡಿನ ದಿವಸ. ಇಮ್ಮ ರ‍್ಹಯೊತಬಿ ಕ್ಹುದಾ ಅಪೊನೆ ಶಿಕ್ಷಾ ದೆತಾಮಾ, ತೆ ಅನ್ಯಾಯ ಕರಾಡ್ಯೊಸ ಕೈನ ಅಪೆ ಕವಾನೆ ಥಾವಸ್ಸು? ಕ್ಹುದಾ ತಿನಿ ಶಿಟ್ಟ ಅಪ್ನೊಪರ ಲೈನ ಅನ್ಯಾಯ ಕರಸು? ");
INSERT INTO sle_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ಕ್ಹರಿಜ಼ ನೈ! ಕ್ಹುದಾ ಅಪೊನೆ ಶಿಕ್ಷಾ ನೈ ದಿವತ್ತೊ, ಕ್ಹುದಾ ಜಗತ್ನೆ ಫೈಸಲೊ ಕರಾನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","\"ಮಿ ಕವಾನು ಸುಳ್ಳ ರ‍್ಹಯಲ ಕ್ಹುದಾನೆ ಕ್ಹರಿಮಾಜ಼ ಮಹಿಮಾ ಥಾವಸ. ಇಮ್ಮ ರ‍್ಹಯುಮ ಮನೆ \"ಪಾಪಿ \"ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಥಾವಾನು ಕಾ? ");
INSERT INTO sle_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ಚೊ಼ಕು ಥಾವಾನಾ ಹುತಿ ಅಪೆ ಕೆಟ್ಟ ಕರಿಯೆ ಕೈನ ಕವಾಕ್ಹು ತಿನೆ ಸುಜ಼ ಫರಕ ನತ್ತಿ. ಘನ್ನಾ ಮನಕ್ಹೊ ಹಮೊನೆ ನಾಮ-ಬೊಟ ಮ್ಹೆಲಸ ವರಿ ಹಮೆ ತ್ಯಯ್ಯೊ ಸಂಗತಿಯೊ ಕಯೆಸ ಕೈನ ಕವಸ. ತೆ ಮನಕ್ಹೊ ತಪ್ಪ ಕರಾಲಾ ಥಯಾಸ. ತ್ಯುನೊನೆ ಶಿಕ್ಷಾ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ಇಮ್ಮ ರ‍್ಹತಾಮಾ,ಹಮೆ ಲಾಸ್ಟಮಾ ಸು ಕೈಯೆ? ಯಹುದ್ಯೊ ಥಯಲ ಅಪೆ ಬಿಜಾ಼ವೊತಿ ಚೊ಼ಕಾ ವ್ಹೈ ಸು? ನ್ಹವೈ! ಯಹುದಿಯೊನೆ ಯಹುದ್ಯೊ ನೈಸೊವಾಲಾ ಪಾಪಮಾ ಛೆ ಕೈನ ತೆಳಾಮಾಜ಼ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ಪವಿತ್ರ ಗ್ರಂಥ ಅಮ್ಮ ಕವಸ\" ನಿತಿವಂತವಾಲೊ ಕುನ್ನಜ಼ ನತ್ತಿ. ಯಕ್ಲೊಬಿ ನತ್ತಿ ");
INSERT INTO sle_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ಯಕ್ಲೊಬಿ ಶಾಣ್ಯೊ ನತ್ತಿ. ಕ್ಹುದಾನಿ ಆರಾಧನಾ ಕರಾಲು ಕುನ್ನಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಕ್ಹುದಾ ಕಂತಾ ಫರಿ ಗಯಾಸ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಉಪಯೊಗ ನೈಸೊ ಥಯಾಸ. ಚೊ಼ಕು ಕರಾಲೊ ಯಕ್ಲೊಬಿ ನತ್ತಿ. ನತ್ತಿಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","\"ತ್ಯುನಾ ವಾತೊ ಖುಲ್ಲಾ ಥಯಲ ಮಜಾ಼ರ ಲಿಂಗತ ಛೆ. ತ್ಯುನೆ ಸುಳ್ಳ ಬೊಲಾನೆ ತ್ಯುನಿ ಜಿಬ್ಬ ಉಪಯೊಗ ಕರಸ\" \"ತ್ಯುನೆ ಕವಾನಾ ಸಂಗತಿಯೊ ಜ಼ಹರ ರ‍್ಹಯಲ ಕ್ಹಾಪೊಲಿಂಗತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","\"ತ್ಯುನಾ ಮ್ಹೊಡಾ ಕ್ಹರಾಪಾಕ್ಹು ವರಿ ಇಸಾಕ್ಹು ಭರಿ ಗಯಾಸ\" ");
INSERT INTO sle_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","\"ದುಖ ದಿವಾನೆ ವರಿ ಖಲಾಸ ಕರಾನೆ ತ್ಯುನೆ ಕೆಳಾಮಾಬಿ ತಯ್ಯಾರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ತ್ಯುನೆ ಗಯಲ ಕ್ಹಾರಿ ಜ಼ಗಾ ತ್ರಾಸೊ ವರಿ ಬರಬಾದಿ ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ತ್ಯುನೆ ಶಾಂತಿನಿ ವಾಟ ತಿಳ್ದಿಲಿದ್ಯಾ ನತ್ತಿ\" ");
INSERT INTO sle_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","\"ತ್ಯುನಾ ನಜ಼ರಮಾ ಕ್ಹುದಾನೊ ಭೆ ನತ್ತಿ\" ");
INSERT INTO sle_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ಹಮೊನೆ ಹಮ್ನಾ ಗ್ವತ್ತ ಛೆ ನಿಯೊಮೊಮಾ ಸು ಕದ್ಯಾಸ. ಎ ನಿಯಮೊನಾ ಅದಿನಮಾ ಕುನ ಛೆ ತಿನೆ ತ್ಯುನೊನೆ ಧರಮಶಾಸ್ತ್ರನೆ ಅದಿನ ಥೈನ ರ‍್ಹವಾಲಾ ತ್ಯುನಾ ವಿಷಯಮಾ ಧರಮಶಾಸ್ತ್ರ ಎ ಸಂಗತಿಯೊ ಕವಾಡ್ಯುಸ. ಇನಾಹುತಿ ಹರಯಕ್ಕ ಮ್ಹೊಡು ಭಂದೈನ ವರಿ ಕ್ಹಾರಿ ಜಗತ್ತ ಕ್ಹುದಾನಿ ನ್ಯಾಯನಾ ಫೈಸ್ಲಾನೆ ಯೊಗ್ಯ ವ್ಹೈ ಕೈನ ದಿಕ್ಹಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ಕಾಕದ್ಯಾಮ ಧರಮಶಾಸ್ತ್ರ ಲಿಂಗತ ಚಾ಼ಲಾನಾ ಮುಕಾಂತರ ಕಯೊಜ಼ ಮನಕ್ಹ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ನಿತಿವಂತವಾಲಾ ಥಾವಾನೆ ಕಿನೆಜ಼ ಸಾದ್ಯ ನತ್ತಿ. ಧರಮಶಾಸ್ತ್ರ ಅಪೆ ಕರಲ ಪಾಪೊ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ತೆನೈಸೊ ಹಮ್ನಾ ಕ್ಹುದಾ ಧರಮಶಾಸ್ತ್ರ ನೈಸೊಜ಼ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ನಿತಿವಂತವಾಲಾ ಥಾವಾ ಹುತಿ ವಾಟ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ಎನೈಸೊ ಎ ವಾತನಿ ಸಾಕ್ಷಿ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರ ವರಿ ಪ್ರವಾದಿಯೊ ದಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ಬರೊಕ್ಹಾನಾ ಮುಲಕ ಕದ್ಯಾಮ ಯೆಸು ಕ್ರಿಸ್ತಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ನಿತಿವಂತವಾಲಾ ಕರಸ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಯಕ್ಕಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ವರಿಬಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪಾಪ ಕರಿನ ಕ್ಹುದಾನಿ ಮಹಿಮಾ ದೆಕ್ಯಾವಾಚಿ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ತೆನೈಸೊ ಯೆಸು ಕ್ರಿಸ್ತನ ಬಿಡುಗಡೆನಾ ಮುಕಾಂತರ ಕ್ಹುದಾನಿ ಫ್ರಿ ಗಿಫ್ಟನಿ ವರಾ ಮರಗಾಕ್ಹು ತಿನಾ ಕ್ಹಾಮಾ ನಿತಿವಂತವಾಲಾ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ಕ್ಹುದಾ ಬರೊಕ್ಹಾನಾ ಮುಕಾಂತರ ಮನಕ್ಹೊನಾ ಪಾಪೊನೆ ಮಾಫ ಕರಾನಿ ವಾಟ ದೆಕಾಡ್ಯೊಸ. ತೆ ವಾಟ ಯೆಸು ಕ್ರಿಸ್ತ ವ್ಹೈ. ಕ್ಹುದಾ ಯೆಸುನು ರಗತನಾ ಮುಲಕ ಪಾಪ ಮಾಫ ಕರಸ. ಕ್ಹುದಾ ಕರಾನು ಕ್ಹಾರುಜ಼ ಚೊ಼ಕೊಜ಼ ವ್ಹೈ. ವರಿ ಕ್ಹರಿಕ್ಹು ರ‍್ಹವಸ ಕವಾನು ಎ ದೆಕಾಡಿನ ದಿವಸ. ಕ್ಹುದಾ ಪಾಚ಼ಲ್ಯಾ ಕಾಲಮಾ ತಡ್ದಿಲಿವಾನು ಮನಕ್ಹೊನಾ ಪಾಪನೆ ದಂಡದಿದ್ಯಾವಾಚಿ ಜಾ಼ತಾಮಾ ತೆಳಾಮಾಬಿ ಕ್ಹುದಾ ನಿತಿವಂತವಾಲೊ ವ್ಹತ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ಇಮ್ಮ ಕ್ಹುದಾ ತೆಜ಼ ನಿತಿವಂತವಾಲೊ ವ್ಹೈ ಕೈನ ವರಿ ಯೆಸುಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ಕಯೊಬಿ ರ‍್ಹೈನೆಕಾ ನಿತಿವಂತವಾಲೊ ಥಾವಸ ಕೈನ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ತೆನೈಸೊ ಅಪೆ ಕಯಾ ವಿಷಯನಾ ಹುತಿ ಮ್ಹೊಟುಪನ ಕರಸಕೆಸ. ಕಯುಜ಼ ನ್ಹವ್ಹೈ! ವರಿ ತಿನೆ ಕಾರಣ ಸುವ್ಹೈ? ಅಪೆ ಧರಮಶಾಸ್ತ್ರ ಲಿಂಗತ ಚಾ಼ಲಾನು ತಿನು ಕಾರಣ ವ್ಹೈಸು? ನ್ಹವೈ! ತೆನೈಸೊ ಅಪೆ ಕಿಪರ ಬರೊಕ್ಹೊ ಕರೆಸ ತೆ ಅಪ್ನು ಮ್ಹೊಟಾಪನನೆ ಕಾರಣ ಥಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ಲಾಸ್ಟಮಾ ಮಿ ಅಮ್ಮ ಕೌಸ ಕಯೊಬಿ ಧರಮಶಾಸ್ತ್ರನಾ ಕಾಮೊಕ್ಹು ನೈ ತೆನೈಸೊ ಬರೊಕ್ಹಾಕ್ಹುಜ಼ ತೆ ನಿತಿವಂತ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ಕ್ಹುದಾ ಯಹುದ್ಯೊನೊ ಕ್ಹುದಾ ಯಕ್ಕಜ಼ ವ್ಹೈ ಸು? ತೆ ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೊಬಿ ಕ್ಹುದಾ ನ್ಹವೈ ಸು? ಹೊ, ತೆ ಯೆಹುದಿಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೊಬಿ ಕ್ಹುದಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ತೆ ಖತ್ನಾ ಕರಿಲಿದಲವಾಲಾವೊನೆ ನಿತಿವಂತವಾಲಾ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಕರಾನು ತ್ಯುನೊ ಬರಕ್ಹೊಜ಼ ಆಧಾರ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಬರೊಕ್ಹಾನಿ ವಾಟಮಾ ಚಾ಼ಲಾನಾ ಮುಕಾಂತರ ಅಪೆ ಧರಮಶಾಸ್ತ್ರನೆ ನೈ ವಪ್ಪಿಲೆತಾ ನೈ ಸು? ನೈ! ನ್ಹವೈ ಕ್ಹರಿಜ಼ ನ್ಹವೈ! ತೆನೈಸೊ ಅಪೆ ಧರಮಶಾಸ್ತ್ರಮಾ ಹಜು಼ನ ಘನ್ನಿ ತಾಕತ ಕ್ಹು ಘಟ್ಟ ಥೈನ ರ‍್ಹವಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ತಿಮ್ಮ ರ‍್ಹಯುಮ, ಅಪ್ನೊ ಪಿತೃಥಯಲ ಅಬ್ರಹಾಮನಾ ಹುತಿ ಅಪೆ ಸು ಕ್ಯೆಯೆ? ತೆ ಬರೊಕ್ಹಾನಾ ಹುತಿ ಸು ಶಿಕ್ಯೊ? ");
INSERT INTO sle_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ತೆನೈಸೊ ತೆ ಕರಾನಾ ಕಾಮೊಕ್ಹು ನಿತಿವಂತವಾಲೊ ವ್ಹೈ ಕೈನ ಕವೈಲಿವಾನೆ ಕಾರಣ ರ‍್ಹತುತು. ವರಿಬಿ ಅಬ್ರಹಾಮ ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ ಮಿ ವ್ಹೈ ಕೈನ ಕವೈಲಿನ ಥಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","\"ಅಬ್ರಹಾಮ ಕ್ಹುದಾನೆ ನಂಬ್ಯೊ. ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೊ ಬರೊಕ್ಹಾನಾ ಹುತಿ ತೆ ನಿತಿವಂತವಾಲೊ ಕ್ಹುದಾ ಸ್ವಿಕಾರ ಕರ‍್ಯೊ \"ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ರಾಬಾಲಾನೆ ಮಳಾನೊ ಪಗಾರ ಮಳು ಗಿಫ್ಟ ನ್ಹವೈ. ತೆ ತಿನೆ ಮಳಾನೊ ಹಕ್ಕ ವ್ಹೈ,ಎ ");
INSERT INTO sle_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ತೆನೈಸೊ ಯಕ್ಲೊ ತೆ ಕರಾನು ಕಾಮ ಪರ ಬರೊಕ್ಹೊ ಕರಾತಿ ಕ್ಹುದಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಸ. ಕ್ಹುದಾ ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲಾನೆ ಧರಮಿ ಕರಾಲೊ ಕ್ಹುದಾ ವ್ಹೈ. ತೆ ಕ್ಹುದಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಲ ಎ ಬರೊಕ್ಹೊ ತಿನೆ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ನಿತಿವಂತ ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ಕ್ಹುದಾ ಯಕ್ಲಾನು ಚೊ಼ಕು ಕಾಮ ದೆಕ್ಯಾವಾಚಿ ತೆ ನಿತಿವಂತವಾಲೊ ವ್ಹೈಕೈನ ವಪ್ಪಿಲಿದ್ಯೊಮ ಕ್ಹರಿಮಾ ತೆ ಮನಕ್ಹ ನಸಿಬವಾಲೊ ವ್ಹೈ ಕೈನ ದಾವಿದಬಿ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","\"ಕಿನು ತಪ್ಪ ಮಾಫ ಥೈಗೈಯುಸ ಕಿನಾ ತಪ್ಪೊ ಝಕೈ ಗಯಾಸ. ತೆ ಕ್ಹರಿಮಾಜ಼ ನಶಿಬವಾಲೊ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ಕ್ಹುದಾ ಕಿನು ತಪ್ಪ ಶೆ ನೈ ಕರತೊ ತೆ ಕ್ಹರಿಮಾಜ಼ ನಸಿಬವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ಎ ನಸಿಬ ಖತ್ನಾ ಕರೈಲಿದಲವಾಲಾ ಯಹುದಿಯೊನೆ ಯಕ್ಕಜ಼ ವ್ಹೈಸು? ನೈತೊ ಖತ್ನಾ ನೈ ಕರೈಲಿದವಾಲಾವೊನೆ (ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊ) ಇವ್ನೊ ನಸಿಬ ವ್ಹೈಸು? ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೊ ಬರೊಕ್ಹೊ ವಪ್ಪಿಲಿದ್ಯೊಸ ಕೈನ ತೆಳಾಮಾಜ಼ ಕದ್ಯಾಸ. ತೆ ಬರೊಕ್ಹೊ ತಿನೆ ನಿತಿವಂತವಾಲೊ ಕರ‍್ಯು. ");
INSERT INTO sle_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ವರಿಬಿ ಎ ಕೆಳಾಮಾ ಥಯು? ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೆ ವಪ್ಪಿಲಿದಲ ತಿನೆ ಸುನ್ನತಿ ಥಾವಾತಿ ಅಗ್ದುರಜ಼ ವ್ಹೈಸು ಸುನ್ನತಿ ಥಯಲ್ಪರ ವ್ಹೈ? ಕ್ಹುದಾ ತಿನೆ ವಪ್ಪಿಲಿದಲ ಸುನ್ನತಿ ಥಾವಾತಿ ಅಗ್ದುರಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ಕ್ಹುದಾ ತಿನೆ ವಪ್ಪಿಲಿದ್ಯೊಸ ಕೈನ ದೆಕಾಡಾನಾ ಹುತಿ ಅಬ್ರಹಾಮ ಪಾಚಾ಼ತು ಸುನ್ನತಿ ಕರೈಲಿದ್ಯೊ. ಅಬ್ರಹಾಮ ಸುನ್ನತಿ ಕರೈಲಿವಾತಿ ಅಗ್ದುರಜ಼ ಬರೊಕ್ಹಾನಾ ಮುಲಕ ನಿತಿವಂತವಾಲೊ ವ್ಹತ್ತೊ. ತಿನಾಹುತಿ ಅಬ್ರಹಾಮ ಕ್ಹುದಾನೆ ಬರೊಕ್ಹೊ ಕರಾಲಾ ಕ್ಹಾರಾವೊನೆ ಆತ್ಮಿಕ ಬಾ ಥಯೊಸ ವರಿ ತ್ಯುನೆ ಸುನ್ನತಿ ನೈ ಕರೈಲಿ ತುಬಿ ತ್ಯುನೊಕ್ಹು ನ್ಯಾಯಮಾ ಸ್ವಿಕಾರ ಕರೈಲಿದಲವಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ತೆನೈಸೊ ಸುನ್ನತಿ ಕರೈಲಿದಲ ಮನಕ್ಹೊನೆಬಿ ಅಬ್ರಹಾಮ ಮುಲ ಪಿತೃ ಥಯೊಸ. ತೆನೈಸೊ ತೆ ತ್ಯುನೊನೆ ಮುಲ ಪಿತೃ ಥಯಲ ತ್ಯುನೆ ಕರೈಲಿದಲ ಸುನ್ನತಿ ಕ್ಹು ನ್ಹವೈ. ಅಪ್ನೊ ಮುಲ ಪಿತೃ ಥಯಲ ಅಬ್ರಹಾಮ ಸುನ್ನತಿ ಕರೈಲಿವಾತಿ ಅಗ್ದುರಜ಼ ತೆ ಕಿಮ ಬರೊಕ್ಹಾಮಾ ವ್ಹತ್ತೊ ತಿನಾ ಲಿಂಗತಜ಼ ರ‍್ಹಯಲವಾಲಾವೊನೆ ತೆ ಮುಲ ಪಿತೃ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ಅಬ್ರಹಾಮನೆಬಿ ತಿನಾ ಸಂತತಿನೆಬಿ ದುನಿಯಾಜ಼ ದ್ಯುಸ ಕೈನ ಕ್ಹುದಾ ವಾಗ್ದಾನ ದಿದ್ಯೊ. ತೆನೈಸೊ ಅಬ್ರಹಾಮ ಎ ವಾಗ್ದಾನ ಮಳು ಕದ್ಯಾಮ ಧರಮಶಾಸ್ತ್ರಮಾ ರ‍್ಹಯಲತಿಮ್ಮ ಚಾ಼ಲಲಕ್ಹು ನ್ಹವೈ. ಅಬ್ರಹಾಮ ನಿತಿವಂತ ಥೈನ ಬರೊಕ್ಹೊ ಕರಲಕ್ಹು ಎ ವಾಗ್ದಾನ ವ್ಹಂದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಕ್ಹುದಾ ದಿವಾನಿಯೊ ವಾಗ್ದಾನೊ ಧರಮಶಾಸ್ತಮಾ ರ‍್ಹಯಲ ತಿಮ್ಮ ಚಾ಼ಲಾಲಾವೊನೆ ದಿವಾನೆ ರ‍್ಹವತ್ತೊ, ಬರೊಕ್ಹೊ ಸುಜ಼ ಉಪಯೊಗ ನ್ಹೊತೊ. ತೆನೈಸೊ ಅಬ್ರಹಾಮನೆ ಕ್ಹುದಾ ದಿದಲ ವಾತ ಸುಜ಼ ಉಪಯೊಗ ನ್ಹೊತಿ. ");
INSERT INTO sle_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ಧರಮಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥಯಾವಾಚಿ ರ‍್ಹತಾಮಾ, ಧರಮಶಾಸ್ತ್ರ ಕ್ಹುದಾನೆ ಶಿಟ್ಟಲಾವಾ ವರಕ್ಹು ಥಾತುತು. ವರಿಬಿ ಧರಮಶಾಸ್ತ್ರ ನಾ ರ‍್ಹವತ್ತೊ ಅವಿಧೆಯ ಥಾವಾನೆ ಸುಜ಼ ರ‍್ಹತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ತಿನಾಹುತಿ ಮನಕ್ಹೊ ಬರೊಕ್ಹೊನಾ ಮುಲಕ ವಾಗ್ದಾನ ಹೊಂದಿಲಿವಸ. ವಾತೊ ಫ್ರಿಮಾ ಮಳು ಕೈನ ವರಿ ಗಿಫ್ಟ ರ‍್ಹೌ ಕೈನ ಇಮ್ಮ ಥಯು. ವಾಗ್ದಾನ ಫ್ರಿನಿ ಗಿಫ್ಟ ರ‍್ಹಯ್ಯೊಮ, ಅಬ್ರಹಾಮನಾ ಮನಕ್ಹೊ ತೆ ವಾತೊ ಹೊಂದಿಲಿವಸ. ಎ ವಾಗ್ದಾನ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನೆ ಅಧಿನ ಥೈನ ಜಿವ್ನಾ ಕರತಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಯಕ್ಕಜ಼ ನ್ಹವೈ, ಅಬ್ರಹಾಮ ಲಿಂಗತ ಬರೊಕ್ಹಾಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಹುತಿ ವ್ಹೈ. ಅಬ್ರಹಾಮ ಅಪೊನೆ ಕ್ಹಾರಾವೊನೆ ಮುಲ ಪಿತೃ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","\"ಮಿ ತುನೆ ಘನ್ನಿ ಜನಾಂಗನಾ ಮನಕ್ಹೊನೆ ಬಾ ಥಾವಾ ವರಕ್ಹು ಕರ‍್ಯೊಸ \"ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ಎ ಕ್ಹುದಾನಿ ಸನ್ನಿದಿಮಾ ಕ್ಹರಿ ವ್ಹೈ. ಮರಲವಾಲಾವೊನೆ ಜ಼ಲಮ ದಿವಾನು ಹಜು಼ನಬಿ ನೈ ಥಯಲ ಕಾಮೊ ಕರಾಲಾ ಕ್ಹುದಾನೆ ಅಬ್ರಹಾಮ ನಂಬ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ಅಬ್ರಹಾಮನೆ ಬಚ್ಚಾ಼ ಥಾವಾನೆ ವಾಟಜ಼ ನ್ಹೊತಿ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ತೆ ಕ್ಹುದಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲ್ಯೊ ವರಿಬಿ ತೆ ಆಸ ಮ್ಹೆಲಲ ಹುತಿ ತೆ ಘನ್ನಿ ಜ಼ನಾಂಗ್ನೆ ಬಾ ಥಯೊ. ಕ್ಹುದಾ ತಿನೆ\"ತು ಘನ್ನಿ ಜ಼ನಾಂಗ್ನೆ ಪಡ್ದಿಲೆಶಿ\" ಕೈನ ಕದಲ ಪುರಾ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ಅಬ್ರಹಾಮನೆ ಕಮ್ಸಿ ಕಮ ಕ್ಹೊ ವೈಸ ಥಯಲ ಹುತಿ ತಿನು ಅಂಗಬಿ ತಾಕತ ನೈಸೊ ಥೈ ಗಯುತು. ತಿನಾಹುತಿ ತಿನೆ ಬಚ್ಚಾ಼ ಥಾವಾನೆ ಸಾದ್ಯ ನ್ಹೊತು. ತೆನೈಸೊ ಸಾರಳನೆಬಿ ಬಚ್ಚಾ಼ ಥಾವಾ ವರಕ್ಹು ನ್ಹೊತು. ಅಬ್ರಹಾಮ ಇನಾಹುತಿ ವಿಚಾರ ಕರ‍್ಯೊ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ಕ್ಹುದಾಪರ ರ‍್ಹಯಲ ತಿನೊ ಬರೊಕ್ಹೊ ಕಮ ಥಯೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ಕ್ಹುದಾ ದಿದಲ ವಾಗ್ದಾನಪರ ತೆ ಸಂಶೊ ಕರ‍್ಯೊ ನೈ ವರಿ ತಿನಾ ಬರೊಕ್ಹೊನಾ ಕಮ ಥಾವಾನೆ ದಿದ್ಯೊ ನೈ. ತಿನೊ ಬರೊಕ್ಹೊಜ಼ ತಿನೆ ಘಟ್ಟ ಕರ‍್ಯು ವರಿ ತೆ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ಕ್ಹುದಾ ದಿದಲ ವಾಗ್ದಾನ ಪುರಾ ಕರಸ ಕೈನ ಅಬ್ರಹಾಮ ನಂಬ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ತಿನಾಹುತಿ\"ಕ್ಹುದಾ ಅಬ್ರಹಾಮನಾ ಬರೊಕ್ಹೊನಾ ಹುತಿ ತಿನೆ ನಿತಿವಂತವಾಲಾ ವ್ಹೈ ಕೈನ ಕ್ಹುದಾ ವಪ್ಪಿಲಿದ್ಯೊ\" ");
INSERT INTO sle_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","\"ನಿತಿವಂತ\" ಕವಾನಿ ಎ ವಾತ ಅಬ್ರಹಾಮನೆ ಯಕ್ಕಜ಼ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ತೆ ಅಪ್ನಾ ಹುತಿಬಿ ಬರ್ದಲ ವ್ಹೈ. ಅಪೆ ಬರೊಕ್ಹೊ ಕರಿಯೆಸ. ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡಲ ವಾಲಾನೆ ಅಪೆ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ಅಪ್ನಾ ಪಾಪೊನಾ ಹುತಿ ಯೆಸುನೆ ಮರಾನೆ ದಿದ್ಯಾ. ಅಪೊನೆ ನಿತಿವಂತವಾಲಾ ಕರಾನಾಹುತಿ ತಿನೆ ಮರಲವಾಲಾವೊಮಾತೊ ವರಿ ಜಿವ್ತೊ ಕರಿನ ಉಟಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಅಪೆ ಬರೊಕ್ಹಾ ಕ್ಹು ನಿತಿವಂತವಾಲಾ ಥಯಾಸ. ತಿನಾಹುತಿ ಅಪ್ನೊ ಪ್ರಬು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಅಪೊನೆ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಸಮಾಧಾನ ಕ್ಹು ಛೆ ");
INSERT INTO sle_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ಹಮ್ನಾ ಅಪೆ ಕ್ಹುಶಿ ಕರತಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನಿ ಮರಗಾ ಕ್ಹು ಕ್ರಿಸ್ತಜ಼ ಅಪೊನೆ ಅಪ್ನೊ ಬರೊಕ್ಹಾನಾ ಮುಲಕ ಲಾಯೊಸ. ಕ್ಹುದಾನಿ ಮಹಿಮಾ ಹೊಂದಿಲಿಯೆಸ ಕವಾನು ಆಸ ಅಪೊನೆ ರ‍್ಹಯಲ ಹುತಿ ಅಪೆ ಬರೊಕ್ಹಾನಿ ಘಮಂಡಿ ಕ್ಹು ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ತೆನೈಸೊ ಅಪೊನಾ ತ್ರಾಸೊಮಾಬಿ ಖುಶಿ ಕ್ಹು ಛೆ. ಕಾಕದ್ಯಾಮ ಎ ತ್ರಾಸೊ ಅಪೊನೆ ಹೆಚ್ಕಿ಼ ತಡ್ದಿಲಿವಾನು ಶಿಕ್ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ತಡ್ದಿಲಿವಾಕ್ಹು ಅಪೊಮಾ ಚೊ಼ಕಾ ಸ್ವಭಾವ ಹುಟ್ಟಸ. ಚೊ಼ಕಾ ಸ್ವಭಾವಕ್ಹು ಬರೊಕ್ಹೊ ಹುಟ್ಟಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ಎ ಆಸ ಅಪೊನೆ ಕೆಳಾಮಾಜ಼ ನಿರಾಶ ಕರತು ನೈ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾ ಅಪೊನೆ ದಿದಲ ಗಿಫ್ಟ ಪವಿತ್ರ ಆತ್ಮಾನಾ ಮುಲಕ ತಿನಿ ಮಯಾ ಘನ್ನಿ ದೆಕಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ಅಪೆ ಆಸ ನೈಸೊವಾಲಾ ರ‍್ಹತಾಮಾ, ಕ್ಹುದಾ ಇನಿಲಿದಲ ಟೈಮಮಾ ಕ್ರಿಸ್ತ ಅಪ್ನಾ ಕೆಟ್ಟ ರ‍್ಹಯಲವಾಲಾವೊನಾ ಹುತಿ ಮರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ನಿತಿವಂತವಾಲಾನೊ ಜ಼ಲಮ ವಚಾ಼ಡಾನಾಹುತಿ ಯಕ್ಲೊ ಜ಼ಲಮ ದಿವಾನು ಅಪರುಪ ವ್ಹೈ. ಕ್ಹರಿಮಾಜ಼ ಚೊ಼ಕೊ ರ‍್ಹಯಲವಾಲೊ ಯಕ್ಲಾನಾ ಹುತಿ ಜ಼ಲಮ ದಿವಾನು ಯಕ್ಲೊ ತಯ್ಯಾರ ಥಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ತೆನೈಸೊ ಅಪೆ ಪಾಪಿಯೊ ರ‍್ಹತಾಮಾಜ಼ ಕ್ರಿಸ್ತ ಪಾಪಿಯೊನಾ ಹುತಿ ಜ಼ಲಮ ದಿದ್ಯೊ. ಇನಾಹುತಿ ಕ್ಹುದಾ ಅಪೊಪರ ರ‍್ಹಯಲ ಘನ್ನಿ ಮಯಾ ಇಮ್ಮ ಅಪೊನೆ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ಅಪೆ ಕ್ರಿಸ್ತನಾ ರಗತನಾ ಮುಲಕ ಕ್ಹುದಾನಿ ನಜ಼ರಮಾ ನಿತಿವಂತವಾಲಾ ಥಯಾಸ. ತಿನಾಹುತಿ ತಿನಾ ಮುಲಕ ಕ್ಹುದಾನಿ ಶಿಟ್ಟ ಕ್ಹು ವಾಚಿಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ಕಾಕದ್ಯಾಮ ಅಪೆ ಕ್ಹುದಾನಾ ವಿರೊಧಿಯೊ ರ‍್ಹತಾಮಾಜ಼ ಕ್ಹುದಾ ತಿನಾ ದಿಕ್ರಾನಾ ಮರಣನಾ ಮುಲಕ ಅಪೊನೆ ತಿನಾ ದೊಸ್ತೊ ಕರಲಿದ್ಯೊಸ. ಹಮ್ನಾ ಅಪೆ ಕ್ಹುದಾನಾ ದೊಸ್ತೊ ಥಯಲ ಹುತಿ ಕ್ಹುದಾ ತಿನಾ ದಿಕ್ರಾನಾ ಜ಼ಲಮನಾ ಮುಲಕ ಅಪೊನೆ ವಚಾ಼ಡಾನು ಹೆಚ್ಕಿ ದೆಕಾಡಿನ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ಯಕ್ಲುಜ಼ ನೈಸೊ, ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಅಪೆ ಕ್ಹುದಾಮಾ ಕ್ಹುಶಿ ಕ್ಹು ರ‍್ಹೈಯೆಸ. ಹಮ್ನಾ ಅಪೆ ಹಮ್ನಾ ತಿಕ್ಹುಜ಼ ಕ್ಹುದಾನಾ ದೊಸ್ತೊ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ಯಕ್ಕ ಮನಕ್ಹ ಆದಾಮ ಕರಲ ಕಾಮೊಕ್ಹು ಪಾಪ ಕ್ಹಾರಿ ಜಗತ್ನೆಜ಼ ಐಯು. ತಿನಾಹುತಿ ತೆ ಪಾಜ಼ ಮರಣ ಕವಾನು ಐಯು. ತಿನಾಹುತಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಮರುಜ಼; ಕಾಕದ್ಯಾಮ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪಾಪ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರತಿ ಅಗ್ದುರಜ಼ ಜಗತ್ಮಾ ಪಾಪ ವ್ಹತ್ತು. ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರ ನೈ ರ‍್ಹವತ್ತೊ, ಕಿನುಜ಼ ಪಾಪ ಮೊಜಾ಼ನೆ ಥಾತು ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ತೆನೈಸೊ ಆದಾಮಾನಾ ಕಾಲ್ತೊ ಮೊಶೆನಾ ಕಾಲ ಲಕ್ಕಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಮರಾನು ಥೈಯು. ಆದಾಮ ಪಾಪ ಕರಲ ಹುತಿ ಮರ‍್ಯೊ. ಕ್ಹುದಾನಿ ವಾತ ದಾಟಿನ ಗೈಯಲ ತೆ ಪಾಪ ವ್ಹೈ. ವರಿಬಿ ಆದಾಮ ಕರಲ ಪಾಪ ಲಿಂಗತ ಮ್ಹೊಟು ಪಾಪ ನೈ ಕರಲವಾಲಾಬಿ ಮರವಾನೆಜ಼ ಥಯು. ಆದಾಮ ಅಗಲ್ಯಾ ಲೊಕಮಾ ಆವಾನೊ ರ‍್ಹಯಲ ಯಕ್ಲಾನೆ (ಕ್ರಿಸ್ತನೆ) ವಳಕ ಥಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ತೆನೈಸೊ ಕ್ಹುದಾ ಗಿಫ್ಟ ಲಿಂಗತ ದಿದಲ ಆದಾಮ ಪಾಪ ಕವಾನು ನ್ಹವೈ. ತೆ ಯಕ್ಲೊ ಪಾಪ ಕರಲ ಹುತಿ ಘನ್ನಾ ಮನಕ್ಹೊ ಮರ‍್ಯಾ. ತೆನೈಸೊ ಕ್ಹುದಾನಿ ಮರಗಾ ಮನಕ್ಹೊನೆ ಮಳಲ ತಿತ್ತಿಬಿ ಮ್ಹೊಟಿ ವ್ಹೈ. ಯೆಸು ಕ್ರಿಸ್ತ ಕವಾಲಾ ಯಕ್ಕ ದಾಣ್ಗಾನಾ ಕೃಪಾನಾ ಮುಲಕ ಕ್ಹುದಾ ದಿವಾನೊ ಫ್ರಿನೊ ಜ಼ಲಮ ಘನ್ನಾ ಮನಕ್ಹೊ ಹೊಂದಿಲಿದ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ಆದಾಮ ಯಕ್ಕ ಸಲಾ ಪಾಪ ಕರಲ ಹುತಿ ತಿನೆ ತಿನೆ ಅಪರಾದಿ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ಥಯೊ. ಕ್ಹುದಾ ದಿವಾನು ಫ್ರಿನು ಗಿಫ್ಟ ತಿನಾ ವಿರೊಧ ವ್ಹೈ. ಘನ್ನಾ ಮನಕ್ಹೊ ಪಾಪ ಕರಲ ಹುತಿ ಕ್ಹುದಾನಾ ಘನ್ನಾ ಫ್ರಿನಾ ಗಿಫ್ಟ ಆಯಾತಾ. ತೆ ಫ್ರಿನು ಗಿಫ್ಟ ಘನ್ನಾ ಮನಕ್ಹೊನೆ ನಿತಿವಂತವಾಲಾ ಕರ‍ಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ಯಕ್ಲೊ ಪಾಪ ಕರ‍್ಯೊ, ತೆ ಯಕ್ಲಾನಾ ಹುತಿ ಕ್ಹಾರಾ ಜ಼ನಾವೊಪರ ಮರಣ ಕವಾನು ರಾಜ಼ ಕರ‍್ಯು. ತೆನೈಸೊ ದಕ್ಹಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಿ ಘನ್ನಿ ಮರಗಾ ಕ್ಹು ವರಿ ನಿತಿವಂತವಾಲಾ ಕರಾನಿ ತಿನಿ ಮ್ಹೊಟಿ ಗಿಫ್ಟನೆ ಸ್ವಿಕಾರ ಕರಸ. ಕ್ಹರಿಮಾಜ಼ ತ್ಯುನೆ ಯೆಸು ಕ್ರಿಸ್ತ ದಾಣ್ಗಾನಾ ಮುಲಕ,ಕ್ಹರಿನೊ ಜ಼ಲಮ ಹೊಂದಿಲಿವಸ. ವರಿ ರಾಜ಼ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ಇಮ್ಮ ರ‍್ಹೈನಬಿ ಆದಾಮನು ಯಕ್ಕ ಪಾಪ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಮರವಾನೊ ಫೈಸಲೊ ಆಯೊ. ತೆನೈಸೊ ತಿನಾ ಲಿಂಗತಜ಼, ಕ್ರಿಸ್ತ ಕರಲ ಯಕ್ಕ ಚೊ಼ಕು ಕಾಮ, ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ನಿತಿವಂತವಾಲಾ ಕರಸ. ವರಿ ತೆ ಮನಕ್ಹೊನೆ ಕ್ಹರಿನೊ ಜ಼ಲಮ ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ಯಕ್ಲೊ ಕ್ಹುದಾನೆ ವಾತ ದಾಟಿನ ಗಯಲ ಹುತಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪಾಪಿ ಥಯಾ. ತೆನೈಸೊ ಯಕ್ಲೊ ಕ್ಹುದಾನಿ ವಾತ ಪುರಾ ಕರಲ ಹುತಿ ಕ್ಹಾರಾ ಮನಕ್ಹೊ ನಿತಿವಂತವಾಲಾ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ಧರಮಶಾಸ್ತ್ರ ಆಯಲ ಹುತಿ ಮನಕ್ಹೊನಾ ಘನ್ನಾ ಪಾಪೊ ಹೆಚ್ಕಿ಼ ದಿಕ್ಹಿನ ಆಯಾ. ತೆನೈಸೊ ಮನಕ್ಹೊ ಘನ್ನಾ ಪಾಪೊ ಕರಲ ಟೈಮ್ಮಾ, ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಹೆಚ್ಕಿ಼ ಮರಗಾ ದೆಕಾಡ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ಯಕ್ಕ ಕಾಲ್ಮಾ ಪಾಪ ಮರಣನಾ ಮುಲಕ ಅಪ್ನೊ ಪರ ರಾಜ಼ ಕರ‍್ಯು. ತೆನೈಸೊ ಕ್ಹುದಾ ಮನಕ್ಹೊನೆ ನಿತಿವಂತವಾಲಾ ಕರು ಕೈನ ತಿನಿ ಘನ್ನಿ ಮರಗಾ ದೆಕಾಡ್ಯೊ. ಎ ಮರಗಾ ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಅಪೊನೆ ಹಮೆಶಾನೊ ಜ಼ಲಮ ಲಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ತಿಮ್ಮ ರ‍್ಹಯಾಮ ತುಮಾರಿ ವಿಚಾರ ಸು ವ್ಹೈ? ಕ್ಹುದಾ ಅಪೊನೆ ಘನ್ನಿ ಮರಗಾ ದೆಕಾಡಸ ಕೈನ ಅಪೆ ಹಜು಼ನ ಪಾಪ ಕರತಾ ರ‍್ಹೌ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ಕ್ಹರಿಜ಼ ನೈ! ಅಪೆ ಅಪ್ನಾ ಪಾಚ಼ಲ್ಯಾ ಪಾಪನಿ ಜಿವ್ನಾನಾ ಪಾಲೆ ಮರಿ ಗಯಾಸ. ತಿಮ್ಮ ರ‍್ಹಯಾಮ, ಅಪೆ ಪಾಪಮಾಜ಼ ಜಿವ್ನಾ ಕರಾನು ಕಿಮ ಸಾದ್ಯ ಛೆ? ");
INSERT INTO sle_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ಅಪೆ ಬಾಪ್ತಿಸ್ಮ ಕರಲೆತಾಮಾ, ಕ್ರಿಸ್ತಮಾ ಪಾಲ ಲಿವಾಲಾ ಥಯಾ ಕವಾನು ತುಮೆ ಇಕ್ಹರಿ ಪಡ್ಯಾ ಸು? ಅಪ್ನಿ ಬಾಪ್ತಿಸ್ಮ ಕ್ಹು ತಿನಾ ಮರಣಮಾ ಪಾಲ ಲಿವಾಲಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ತಿಮ್ಮ ರ‍್ಹತಾಮಾ, ಅಪೆ ಬಾಪ್ತಿಸ್ಮ ಕರಲೆತಾಮಾ, ಅಪೊನೆ ಕ್ರಿಸ್ತನಾ ಕ್ಹಾತೆ ಸಮಾದಿ ಥೈ ವರಿ ಅಪೆ ತಿನಾ ಮರಣಮಾ ಪಾಲ ಲಿವಾಲಾ ಥಯಾ. ಅಪೆ ಜಿವ್ತಾ ಥೈನ ಉಟಿನ ನಯಿ ಜಿವ್ನಾ ಕರುಕೈನ ಅಪೊನೆ ಕ್ರಿಸ್ತ ಕ್ಹಾತೆ ಸಮಾದಿ ಥೈ. ಕ್ರಿಸ್ತ ಬಾನಿ ಅದ್ಬುತ ಕರಾನಿ ತಾಕತ ಕ್ಹು ಮರ‍ಲವಾಲಾವೊಮಾತೊ ಜು಼ವ್ತೊ ಥೈನ ಆಯಲ ಲಿಂಗತ ಅಪೆ ಬಿ ಜಿವ್ತಾ ಥೈನ ಆಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ಕಿಮ್ಮ ಅಪೆ ಕ್ರಿಸ್ತ ಮರಣನಾ ಪಾಲ ಥಯಾಸ ತಿಮ್ಮಜ಼ ತೆ ಜಿವ್ತೊ ಥೈನ ಆಯಲ ಲಿಂಗತ ಅಪೆಬಿ ಜಿವ್ತಾ ಥೈನ ಆಯಲ ತಿನಾ ಪಾಲಮಾ ಮಳ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ಅಪ್ನಿ ಜು಼ನ್ನಿ ಜಿವಿತ ಕ್ರಿಸ್ತನಾ ಕ್ಹಾತೆ ಶಿಲುಬಿಪರ ಮರಿ ಗೈಸ ಕವಾನು ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ. ಅಪ್ನಿ ಪಾಪನಿ ಚಾಳಿಕ್ಹು ಅಪೊಪರ ಕಯೊ ಅದಿಕಾರ ರ‍್ಹೌ ನೈ ಕೈನ ಅಪೆ ಅಗಾ ಪಾಪನಾ ಗುಲಾಮೊ ಥೈ ರ‍್ಹೌ ನೈ ಕೈನ ಇಮ್ಮ ಥಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ಪಾಪನಾ ಪಾಲೆ ಮರಲವಾಲೊ ಪಾಪನಾ ಹತ್ಮಾತೊ ಛೊಡೈಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ಅಪೆ ಕ್ರಿಸ್ತನಾ ಕ್ಹಾತೆ ಮರಿ ಗಯಾ, ವರಿ ಅಪ್ನೊ ಬರೊಕ್ಹೊ ತಿನಾ ಕ್ಹಾತೆ ಜಿವ್ತೊ ಕರಸ ಕವಾನು ಕ್ಹರಿಜ಼ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ಕ್ರಿಸ್ತ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯೊ. ತೆ ವರಿ ಮರಾನೆ ಕೆಳಾಮಾಜ಼ ಸಾದ್ಯ ನತ್ತಿ ಕವಾನು ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ. ಹಮ್ನಾ ಮರಣನೆ ತಿಪರ ಕಯೊ ಅದಿಕಾರ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ಹೊ, ಕ್ರಿಸ್ತನೆ ಹಬ್ದಾ ಪಾಪನಿ ತಾಕತ ಸೊಲ್ಸಾನೆ ಸಾದ್ಯ ನತ್ತಿ. ಹಮ್ನಾ ತಿಮಾ ನೈ ಜಿವ್ನಾ ಛೆ. ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಜಿವ್ತಾ ರ‍್ಹವಾನು ತೆಜ಼ ನೈ ಜಿವಿತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ತಿನಾ ಲಿಂಗತಜ಼ ತುಮೆಬಿ ತುಮೊನೆ ಪಾಪನಿ ತಾಕತನಿ ಪಾಲೆ ಮರ‍್ಯಾಸ ಕೈನ ವರಿ ಪಾಪನಿ ಅದಿಕಾರಮಾ ನಕೊ ಚಾ಼ಲೊ ಕ್ರಿಸ್ತ ಯೆಸುನಾ ಮುಕಾಂತರ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಜಿವ್ನಾ ಕರಿಯೆಸ ಕೈನ ತಿಳ್ದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ತೆನೈಸೊ ಪಾಪ ತುಮಾರಾ ಮರಾನಾ ಅಂಗಮಾ ಇತ್ತಿ ಉಪ್ಪರ ಅದಿಕಾರ ಕರು ನೈ, ತಿನಾಹುತಿ ತುಮೆ ತುಮಾರಾ ಸ್ವಾಭಾವಿಕ ಸ್ವಭಾವನಾ ಆಸೊ ಪುರಾ ಕರು. ");
INSERT INTO sle_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ತುಮಾರು ಅಂಗನು ಭಾಗನೆ ಪಾಪನಿ ಸೆವೆ ಕರಾನೆ ವಪ್ಸಿನ ದಿವೊನಕೊ. ತುಮಾರು ಅಂಗ ಪಾಪನೆ ವಪ್ಸಿನ ಕೆಟ್ಟ ಕಾಮನೆ ಚ಼ಲಾವಾನು ಚಿ಼ಜ ಕರಿಲಿವೊ ನಕೊ. ತಿನಾ ಬದ್ಲಿ ಮರಿನ ಹಮ್ನಾ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯಲ ಲಿಂಗತ ತುಮೊನೆ ಕ್ಹುದಾನೆ ವಪ್ಸಿನ ದಿಪಾಡೊ. ಚೊ಼ಕಾ ಕಾಮೊ ಕರಾನೆ ತುಮಾರು ಅಂಗ ಸಾಮನ ಥೈನ ಕ್ಹುದಾನೆ ವಪ್ಸಿನ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ಪಾಪ ತುಮಾರೊ ಮಾಲಕ ಥೈನ ರ‍್ಹತೊ ನೈ. ಕಾಕದ್ಯಾಮ ತುಮೆ ಧರಮಶಾಸ್ತ್ರನೆ ಅದಿನ ನ್ಹವೈ ತೆನೈಸೊ ಹಮ್ನಾ ತುಮೆ ಮರಗಾಮಾ ಜಿವ್ನಾ ಕರಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಹಮೆ ಸು ಕರಿಯೆ? ಅಪೆ ಧರಮಶಾಸ್ತ್ರನೆ ಅದಿನಮಾ ರ‍್ಹಯಾವಾಚಿ಼ ಕ್ಹುದಾನಿ ಮರಗಾನಿ ಅದಿನಮಾ ರ‍್ಹಯಲ ಹುತಿ ಪಾಪ ಕರುಸು? ಕ್ಹರಿಜ಼ ನೈ! ");
INSERT INTO sle_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ತುಮೆ ಕಿನೆತುಬಿ ತಿನಾ ಆಗನ್ಯಾ ಪಾಲ್ಸಾನೆ ವಪ್ಸಿನ ದಿವೊಶಿ. ತೆ ತುಮೊನೆ ಮಾಲಕ ಥಾವಸ ವರಿ ತುಮೆ ತಿನೆ ಗುಲಾಮೊ ಥಾವೊಶಿ. ತಿನಾಹುತಿ ತುಮೆ ಪಾಪನೆ ಗುಲಾಮೊ ಥಾವೊಶಿ ತಿನು ಪರಿಣಾಮ ಮೌತ ಥಯುಸ. ತೆನೈಸೊ ವಿಧೆಯತೆನೆ ಗುಲಾಮೊ ಥಾವಾನು ತೆ ತುಮೊನೆ ಕ್ಹುದಾನಿ ಸನ್ನಿಧಿಮಾ ನಿತಿವಂತವಾಲಾ ಕೈನ ಫೈಸಲೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ಪಾಚ್ಲಯಾ ದಿನೊಮಾ ತುಮೆ ಪಾಪೊನೆ ಗುಲಾಮೊ ವ್ಹತ್ತಾ. ಪಾಪ ತುಮೊನೆ ತಿನಾ ಹತೊಟಿಮಾ ಧರಲಿದ್ಯುತು. ತುಮೊನೆ ಕದಲ ವಿಷಯನೆ ತುಮೆ ಕ್ಹಾರಿ ತರಾಮಾ ವಿದೆಯ ಥಯಲ ಹುತಿ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಥಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ತುಮೆ ಪಾಪಕ್ಹು ಬಿಡುಗಡೆ ಥಯಾಸ. ಹಮ್ನಾ ತುಮೆ ನಿತಿನೆ ಗುಲಾಮೊ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ಮನಕ್ಹೊನೆ ಕಳಲ ಉದಾಹರಣೆ ಮುಲಕ ಮಿ ಎ ತುಮೊನೆ ಕವಾಡ್ಯೊಸ. ಪಾಚ಼ಲ್ಯಾ ಕಾಲ್ಮಾ ತುಮೆ ತುಮಾರಾ ಅಂಗಕ್ಹು ಪಾಪನೆ ಕೆಟ್ಟ ಕಾಮೊನೆ ವರಿ ದುಷ್ಟ ಕಾಮೊನೆ ಗುಲಾಮ ಲಿಂಗತ ವಪ್ಸಿನ ದಿದ್ಯಾತಾ ತಿನಾ ಲಿಂಗತಜ಼ ಹಮ್ನಾ ತುಮಾರಾ ಅಂಗೊನಾ ಭಾಗನೆ ಪವಿತ್ರ ಆತ್ಮಾನೆ ವಪ್ಸಿನ ದಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ತೆಳಾಮಾ ತುಮೆ ಪಾಪೊನೆ ಗುಲಾಮೊ ವ್ಹತ್ತಾ ವರಿ ನಿತಿನೆ ಹತೊಟಿಮಾ ಪಡ್ಯಾನ್ಹೊತಾ. ");
INSERT INTO sle_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ತುಮೆ ಹಮ್ನಾ ಸರಮಾವಾನಾ ಕಾಮೊ ಕರೆ ನೈಸೊ ತುಮೆ ಸು ಪಡ್ದಿಲಿದ್ಯಾಸ? ತೆ ಕಾಮೊನು ಪರಿಣಾಮ ಮೌತ ವ್ಹೈ! ");
INSERT INTO sle_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ತೆನೈಸೊ ಹಮ್ನಾ ತುಮೆ ಪಾಪಕ್ಹು ಬಿಡುಗಡೆ ಥೈನ ಕ್ಹುದಾನಾ ಗುಲಾಮೊ ಥಯಾಸ. ಇನಾಹುತಿ ತುಮೊನೆ ಪರಶುಧ್ದ ಜಿವನ ಹಮೆಶಾನು ಜ಼ಲಮ ಮಳಸ. ");
INSERT INTO sle_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ಕಾ ಕದ್ಯಾ ಪಾಪನಿ ಪಗಾರ ಮರಣ ವ್ಹೈ. ತೆನೈಸೊ ಕ್ಹುದಾ ಫ್ರಿ ದಿವಾನು ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ರ‍್ಹಯಲ ಹಮೆಶಾನೊ ಜ಼ಲಮ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ಭಾಯೊ ಭೆನೊ, ತುಮೆ ಕ್ಹಾರಾ ಮೊಶೆನು ಧರಮಶಾಸ್ತ್ರನೆ ತಿಳ್ದಿಲಿವೊಶಿ. ಯಕ್ಕ ಮನಕ್ಹ ಜಿವ್ತೊ ರ‍್ಹತಾಮಾಜ಼ ಧರಮಶಾಸ್ತ್ರ ತೆ ಮನಕ್ಹನೆ ರಾಜ಼ ಕರಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ನತ್ತಿ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ಮಿ ತುಮೊನೆ ಯಕ್ಕ ಉದಾಹರಣೆ ಕೌಸ ಮಾಟಿ ಜಿವ್ತೊ ರ‍್ಹಯೆ ಲಕ್ಕಾ ಬೈಕೊ ಕಾನುನನಾ ಪ್ರಕಾರ ತಿನಾ ಹತ್ಮಾ ರ‍್ಹೌ. ತೆನೈಸೊ ತಿನೊ ಮಾಟಿ ಮರ‍್ಯೊಮ, ಹಿವಾನಾ ಕಾನುನ ನತ್ತಿ ತೆ ಛುಟಲ ಲಿಂಗತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ತೆನೈಸೊ ತಿನೊ ಮಾಟಿ ಜಿವ್ತೊ ರ‍್ಹತಾಮಾಜ಼ ಬಿಜೆ಼ಕ್ಲಾನೆ ಹಿವಾ ಕರಲಿದಿಮ ತೆ ವ್ಯಭಿಚಾರ ಕವಾನಾ ಪಾಪಮಾ ಪಡಲ ಲಿಂಗತ ವ್ಹೈ ಕೈನ ಧರಮಶಾಸ್ತ್ರ ಕವಸ. ತೆನೈಸೊ ತಿನೊ ಮಾಟಿ ಮರ‍್ಯೊಮ ತೆ ಹಿವಾನಾ ಬಂದನಮಾತಿ ಛುಟಿ ಗೈಸ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ತಿನೊ ಮಾಟಿ ಮರ‍ಲ್ಪರ ಬಿಜೆ಼ಕ್ಲಾನೆ ಹಿವಾ ಕರಲಿದಿಮ ತೆ ವ್ಯಭಿಚಾರ ಕವಾನಾ ಅಪರಾದನೆ ಗುರಿ ನೈ ಥಾತಿ. ");
INSERT INTO sle_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ಮಾರಾ ಭಾಯೊ ಭೆನೊ, ಇನಾಲಿಂಗತಜ಼ ತುಮಾರಾ ಜು಼ನ್ನಿಯೊ ಚಾಳಿಯೊ ಮರಿ ಗಯ್ಯೊ; ತುಮೆ ಕ್ರಿಸ್ತನಾ ಅಂಗನಾ ಮುಲಕ ಧರಮಶಾಸ್ತ್ರಕ್ಹು ಬಿಡುಗಡೆ ಥಯಾಸ. ಹಮ್ನಾ ತುಮೆ, ಮರಲ ಮನಕ್ಹೊಮಾತಾ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯಲವಾಲಾನೆ ಮಳಲವಾಲಾ ಥಯಾಸ. ಅಪೆ ಕ್ಹುದಾನಾ ಹುತಿ ಫಲ ದಿವಾನಾ ಹುತಿ ಕ್ರಿಸ್ತನೆ ಮಳಲವಾಲಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ಅಪ್ನಿ ಮಾನವ ಸ್ವಭಾನಾ ಲಿಂಗತ ಅಪೆ ಜಿವ್ತಾ ರ‍್ಹತಾಮಾ, ಧರಮಶಾಸ್ತ್ರಕ್ಹು ಹುಟ್ಟಲ ಪಾಪನಾ ಆಸೊ ಅಪ್ನಾ ಅಂಗೊಮಾ ಕಾಮ ಕರಾಡಾಸ, ವರಿ ಅಪೆ ಎ ಕ್ಹಾರು ಮರೆ ಲಕ್ಕಾ ಕರೆಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ತೆನೈಸೊ ಹಮ್ನಾ ಅಪೊನೆ ಧರಮಶಾಸ್ತ್ರಕ್ಹು ಬಿಡುಗಡೆ ಮಳ್ಯುಸ. ಕಾಕದ್ಯಾಮ. ಕಯಾ ಧರಮಶಾಸ್ತ್ರಮಾ ಭಾಂದ್ಯಾತಾ ಅಪೆ ತಿನಾಹುತಿ ಮರ‍್ಯಾಸ ಜು಼ನ್ನಾ ಅಕ್ಷರೊಕ್ಹು ನ್ಹವೈ ಆತ್ಮಾನಿ ನೈ ತರಾಮಾ ಅಪೆ ಕ್ಹುದಾನಿ ಸೆವೆ ಕರೆಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ಪಾಪ ವರಿ ಧರಮಶಾಸ್ತ್ರ ಎ ಭಂಬಿ ಯಕ್ಕಜ಼ ವ್ಹೈ ಕೈನ ಮಿ ಕವಾಡ್ಯೊಸ ಕೈನ ತುಮೆ ತಿಳದಿಲಕ್ಹು. ತೆನೈಸೊ ತೆ ಕ್ಹರಿ ನ್ಹವೈ. ಪಾಪ ಕದ್ಯಾಮ ಸು ವ್ಹೈ ಕವಾನು ಶಿಕ್ಕಾನೆ ಧರಮಶಾಸ್ತ್ರ ಯಕ್ಕಜ಼ ಮನೆ ಯಕ್ಕಜ಼ ಯಕ್ಕ ವಾಟ ಥೈಸ. ಧರಮಶಾಸ್ತ್ರ ನೈ ರ‍್ಹವತ್ತೊ, ಕೆಟ್ಟ ಆಸ ಸುವೈ ಕವಾನು ಮನೆ ಗ್ವತ್ತ ಥಾತು ನ್ಹೊತು. ಬಿಜ಼ಾವೊನಾ ಸಾಮ್ನೊನೆ ತುಮೆ ಆಸ ಕರು ನೈ\" ಕೈನ ಧರಮಶಾಸ್ತ್ರ ಕದಲಕ್ಹುಜ಼ ತೆ ಮನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ತೆನೈಸೊ ಪಾಪ ತೆ ಆಗನ್ಯಾನೆ ಉಪಯೊಗ ಕರಿನ ಮಾರಾಮಾ ಹರಯಕ್ಕ ತರಾನಾ ಕೆಟ್ಟ ಆಸೊನೆ ಶೆ ದಿಲೈಯು. ತಿನಾಹುತಿ ತೆ ಆಜ್ಞಾಕ್ಹು ಪಾಪ ಮಾರಾ ಕ್ಹಾಮು ಐಯು. ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರ ನೈ ರ‍್ಹವತ್ತೊ, ಪಾಪ ಕವಾನು ರ‍್ಹತುಜ಼಼ ನ್ಹೊತು.. ");
INSERT INTO sle_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ಮಿ ಧರಮಶಾಸ್ತ್ರನೆ ತಿಳ್ದಿಲಿವಾತಿ ಪೈಲಾ ಧರಮಶಾಸ್ತ್ರ ನೈ ರ‍್ಹಯಲವಾಲೊ ಥೈನ ಜಿವ್ತೊ ವ್ಹತ್ತೊ. ತೆನೈಸೊ ಧರಮಶಾಸ್ತ್ರನಿ ಆಜ್ಞಾ ಮಕನ ಆತಾಮಾ, ಪಾಪ ಜಿವ್ತು ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ಮಿ ಪಾಪನಾ ಹುತಿ ಆತ್ಮಿಕಮಾ ಮರಿ ಗಯೊ. ಜ಼ಲಮ ದಿವಾನಿ ಆಜ್ಞಾಜ಼ ಮನೆ ಮೌತ ಲೈ. ");
INSERT INTO sle_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ಪಾಪ ತೆ ಆಗನ್ಯಾನೆ ಉಪಯೊಗ ಕರಿನ ಮನೆ ಮೊಸ ಕರಿನ, ಮಾರಾಮಾ ಆತ್ಮಿಕ ಮೌತ ಲೈಯು. ");
INSERT INTO sle_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಧರಮಶಾಸ್ತ್ರ ಪವಿತ್ರ ವ್ಹೈ. ಆಗನ್ಯಾ ಪವಿತ್ರ ಫೈಸಲೊ ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ತಿಮ್ಮ ರ‍್ಹಯುಮ, ಚೊ಼ಕೊಜ಼ ಮನೆ ಮೌತ ಲೈಯುಸ ಕೈನ ಮತ್ಲಬ ವೈಸು? ಕ್ಹರಿಜ಼ ನ್ಹವೈ! ತೆನೈಸೊ ಪಾಪ ಚೊ಼ಕೊಜ಼ ಉಪಯೊಗ ಕರಿನ ಮನೆ ಮೌತ ಲೈಯು. ಇನಾಹುತಿ, ಮಿ ಪಾಪನು ಅಸ್ಲಿ ರುಪ ದೆಕಾವರಕ್ಹು ಥಯು. ಪಾಪ ಘನ್ನು ಕೆಟ್ಟ ವ್ಹೈ ಕೈನ ಆಜ್ಞಾಕ್ಹು ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ಧರಮಶಾಸ್ತ್ರ ಆತ್ಮಿಕ ರ‍್ಹಯಲ ವ್ಹೈ ಕೈನ ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆನೈಸೊ ಮಿ ಶಾರಿರಿಕ ಮನಕ್ಹ ವ್ಹೈ. ಮಿ ಪಾಪನೆ ಇಕ್ಕಲ ಗುಲಾಮ ವೈಸು ಕೈನ ಪಾಪ ಮಪರ ರಾಜ಼ ಕರಾಡ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ಮಿ ಕರಾನಾ ಕಾಮೊ ಮನೆ ಗ್ವತ್ತ ಥಾತು ನೈ. ಮಿ ಕಯಾ ಚೊ಼ಕಾ ಕಾಮೊ ಕರು ಕೈನ ಆಸ ಕರುಸ ತೆ ಕಾಮೊ ಕರ‍್ಯಾವಾಚಿ ಮಿ ನೈ ಶೆರಾನಾ ಕೆಟ್ಟ ಕಾಮೊಜ಼ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ಮಿ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊ ಕರಾನೆ ಮನೆ ನೈ ಮನಸ ರ‍್ಹೈತುಬಿ, ಧರಮಶಾಸ್ತ್ರ ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ಮಿ ವಪ್ಪಿಲಿದಲ ಲಿಂಗತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಎ ಕೆಟ್ಟ ಕಾಮೊ ಕರಾಲೊ ಕ್ಹರಿಮಾಜ಼ ಮಿ ನ್ಹವೈ. ಮಾರಾಮಾ ರ‍್ಹಯಲ ಪಾಪಜ಼ ವ್ಹೈ ಎ ಕೆಟ್ಟ ಕಾಮೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ಹೊ, ಮಾರಾಮಾ ಕದ್ಯಾಮ ಮಾರಾ ಮಾನವ ಸ್ವಭಾವನಿಯೊ ಚಾಳಿಯೊಮಾ ಚೊ಼ಕು ಸುಜ಼ ನತ್ತಿ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ಚೊ಼ಕಾ ಕಾಮೊ ಕರಾನೆ ಮನೆ ಮನಸ ರ‍್ಹೈತುಬಿ ತೆ ಕರಾನೆ ಮನೆ ಥಾತು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ಮಿ ಕರಾನೆ ಆಸ ಕರಲ ಚೊ಼ಕಾ ಕಾಮೊ ಕರಾನೆ ಮನಸ ಕರುಸ ತೆನೈಸೊ ಮಿ ನೈ ಕರಾನಾ ತೆ ಕೆಟ್ಟ ಕಾಮೊಜ಼ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಮಿ ನೈ ತೆ ಕರಾನಾ ಕಾಮೊ ಮಿ ಕರ‍್ಯೊಮ, ತೆ ಕರಾಲೊ ಕ್ಹರಿಬಿ ಮಿ ನ್ಹವೈ. ಮಾರಾಮಾ ರ‍್ಹಯಲ ಪಾಪಜ಼ ತೆ ಕೆಟ್ಟ ಕಾಮೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಮಿ ಎ ನಿಯಮ ಶಿಕ್ಶಯೊಸ; ಮಿ ಚೊ಼ಕು ಕರಾನೆ ಜಾ಼ತಾಮಾ, ಕೆಟ್ಟ ಮಾರಾಮಾ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ಮಾರಾ ಅಂತರಂಗಮಾ ಕ್ಹುದಾನಿ ನಿಯಮನಾ ವಿಷಯಮಾ ಮಿ ಖುಶಿ ಥೌಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ತೆನೈಸೊ ಮಿ ಮಾರಾ ಅಂಗಮಾ ಬಿಜು಼ ನಿಯಮ ಕಾಮ ಕರಾನು ಮಿ ದೆಕುಸ. ಮಾರು ಅಂತರಂಗ ವಪ್ಪಿಲಿವಾನಾ ನಿಯಮನೆ ವಿರುದ್ದ ಥೈನ ತೆ ನಿಯಮ ಹೊರಾಡಸ. ಮಾರಾ ಅಂಗಮಾ ಕಾಮ ಕರಾನಾ ತೆ ಬಿಜು಼ ನಿಯಮಜ಼ ಪಾಪನು ನಿಯಮ ಭಾಂದಸ. ತೆ ನಿಯಮ ಮನೆ ಪಾಪನು ಗುಲಾಮ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ಮಿ ಕೆಕ್ಲೊ ಕೆಟ್ಟ ನಸಿಬವಾಲೊ ವ್ಹೈ. ಮನೆ ಮೌತ ಲಾವಾನಾ ಎ ಅಂಗಕ್ಹು ಮನೆ ವಚಾ಼ಡಾಲು ಕುನ್ನ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ಕ್ಹುದಾ ಮನೆ ವಚಾ಼ಡಸ! ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಕ್ರಿಸ್ತ ಯೆಸುನಾ ಮುಲಕ ತೆ ದಿವಾನಿ ರಕ್ಷಣೆನಾ ಹುತಿ ತಿನೆ ಸ್ತೊತ್ರ ಥಾವಾದೆ! ತಿನಾಹುತಿ ಮಾರಾ ಅಂತರಂಗಮಾ ಮಿ ಕ್ಹುದಾನಿ ನಿಯಮನೆ ಗುಲಾಮ ಥಯೊಸ. ತೆನೈಸೊ ಮಾರಾ ಮಾನವ ಸ್ವಭಾವನಿಯೊ ಚಾಳಿಯೊಮಾ ಮಿ ಪಾಪನಾ ನಿಯಮೊನೆ ಗುಲಾಮ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ತಿನಾಹುತಿ ಹಮ್ನಾ ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ರ‍್ಹವಾಲಾ ಮನಕ್ಹೊನೆ ಅಪರಾದಿಯೊ ವ್ಹೈ ಕೈನ ಫೈಸಲೊ ನೈ ಥಾತೊ. ");
INSERT INTO sle_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ಕಾಕದ್ಯಾಮ ಯೆಸು ಕ್ರಿಸ್ತಮಾ ಜ಼ಲಮ ದಿವಾನಿ ಆತ್ಮಾನಿ ನಿಲಯ ಮನೆ ಮೌತನೆ ಲಿನ ಜಾ಼ವಾನಾ ಪಾಪನಾ ನಿಯಮಕ್ಹು ಮನೆ ಸ್ವತಂತ್ರ ಕರ‍್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ಧರಮಶಾಸ್ತ್ರ ತಾಕತ ನೈಸೊ ವ್ಹತ್ತು. ಕಾಕದ್ಯಾಮ ಅಪ್ನಾ ಮಾನವ ಸ್ವಭಾವನಿಯೊ ಚಾಳಿಯೊಜ಼ ತಿನೆ ತಾಕತ ನೈಸೊ ಕರ‍್ಯು. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಧರಮಶಾಸ್ತ್ರ ನೈ ಕರಾನು ಕ್ಹುದಾ ಕರ‍್ಯೊ. ಕ್ಹುದಾ ತಿನಾ ಸ್ವಂತ ದಿಕ್ಕರಾನೆಜ಼ ಪಾಪನಾ ಚಾಳಿಯೊನಾ ಮನಕ್ಹನಾ ಚಾಳಿಯೊಮಾ ಪಾಪನೆ ಪ್ರಾಯಶ್ಚಿತ ಥೈನ ವಳೈನ ದಿದ್ಯೊ. ತಿನಾಹುತಿ ಕ್ಹುದಾ ಪಾಪನೆ ಮೌತನೊ ಫೈಸಲೊ ದಿವಾನೆ ಮನಕ್ಹನಾ ಚಾಳಿಯೊನೆ ಉಪಯೊಗ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ಹಮ್ನಾ ಅಪ್ನಾ ಚಾಳಿಯೊ ಲಿಂಗತ ಜಿವ್ನಾ ಕರ‍್ಯಾವಾಚಿ ಪವಿತ್ರ ಆತ್ಮಾ ಕದಲ ಲಿಂಗತ ಜಿವ್ನಾ ಕರಾಲಾ ಅಪೊಮಾ ಧರಮಶಾಸ್ತ್ರನಾ ನಿಯಮೊ ಥೌ ಕೈನ ಕ್ಹುದಾ ಇಮ್ಮ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ತ್ಯುನಾ ಮನಕ್ಹೊ ಶಾರಿರಿಕನಿಯೊ ಚಾಳಿಯೊ ಲಿಂಗತ ಜಿವ್ನಾ ಕರಾಲಾ ಮನಕ್ಹೊ ತ್ಯುನಾ ಮನಕ್ಹೊನಾ ಸ್ವಭಾವನಿಯೊ ಚಾಳಿಯೊ ಸಂಗತಿಯೊನಾ ಹುತಿ ಯಕ್ಕಜ಼ ವಿಚಾರ ಕರಸ. ತೆನೈಸೊ ಆತ್ಮಾ ಕದಲ ಲಿಂಗತ ಜಿವ್ನಾ ಕರಾಲಾ ಮನಕ್ಹೊ ತ್ಯುನಾಕ್ಹು ಆತ್ಮಾ ಆಸ ಕರಾನಾ ಕಾಮೊನಾ ಹುತಿ ವಿಚಾರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ಯಕ್ಲಾನಿ ವಿಚಾರ ತಿನಾ ಪಾಪನಾ ಸ್ವಭಾವ ಲಿಂಗತ ರ‍್ಹಯುಮ ತಿನೆ ಆತ್ಮಿಕ ಮೌತ ಥಾವಸ. ತೆನೈಸೊ ಯಕ್ಲಾನಿ ವಿಚಾರ ಪವಿತ್ರ ಆತ್ಮಾನಾ ಹತ್ಮಾ ರ‍್ಹಯಲ ರ‍್ಹಯುಮ, ತಿನಾಮಾ ಜ಼ಲಮ ಸಮಾದಾನ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ಕಾಕದ್ಯಾಮ ಯಕ್ಲಾನಿ ವಿಚಾರ ತಿನಿ ಪಾಪನಿ ಚಾಳಿನಾ ಹತ್ಮಾ ರ‍್ಹಯಲ ರ‍್ಹಯುಮ, ತೆ ಕ್ಹುದಾನೆ ವಿರೊದ ಥಯೊಸ. ತೆ ಕ್ಹುದಾನಿ ನಿಯಮನೆ ವಿಧೆಯ ಥಾತೊ ನೈ, ವಿಧೆಯ ಥಾವಾನೆ ಸಾದ್ಯಾಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ತ್ಯುನಾ ಪಾಪನಾ ಚಾಳಿಯೊ ಲಿಂಗತ ರ‍್ಹವಾಲಾ ತೆ ಮನಕ್ಹೊ ಕ್ಹುದಾನೆ ಮೆಚ್ಚಸಾನೆ ಸಾದ್ಯಾಜ಼ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ತೆನೈಸೊ ತುಮೆ ತುಮಾರಾ ಪಾಪೊನಾ ಸ್ವಭಾವ ಲಿಂಗತ ನತ್ತಿ. ಕ್ಹುದಾನಿ ಆತ್ಮಾ ತುಮೊಮಾ ಕ್ಹರಿಬಿ ರ‍್ಹಯಲ ರ‍್ಹಯುಮ, ತುಮೆ ಆತ್ಮಾನಾ ಹತ್ಮಾ ಛೆ. ಕಿನಾಮಾಬಿ ಕ್ರಿಸ್ತನಿ ಆತ್ಮಾ ನೈ ರ‍್ಹಯುಮ, ತೆ ಕ್ರಿಸ್ತಮಾ ರ‍್ಹಯಲವಾಲೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ತೆನೈಸೊ ಕ್ರಿಸ್ತ ತುಮೊಮಾ ರ‍್ಹಯೊಮ, ಆತ್ಮಾ ತುಮಾರಿ ಜಿವಿತ ಥಯುತು, ಕಾಕದ್ಯಾಮ ತುಮಾರಾ ಅಂಗೊ ಪಾಪಕ್ಹು ಮರ‍್ಯಾತುಬಿ ತುಮೆ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ಯೆಸುನೆ ಮೌತಕ್ಹು ಉಟಾಡಲ ಕ್ಹುದಾನಿ ಆತ್ಮಾ ತುಮೊಮಾ ರ‍್ಹಯಮ, ಕ್ರಿಸ್ತನೆ ಮೌತಕ್ಹು ಉಟಾಡಲವಾಲೊ ತುಮಾರಿ ಆತ್ಮಾ ಕಂತೊ ತುಮಾರಾ ಮರಲ ಅಂಗೊನೆ ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ತಿನಾಹುತಿ ಮಾರಾ ಭಾಯೊ, ಭೆನೊ, ಅಪೊನೆ ಯೊಗ್ಯತಾ ಛೆ, ತೆನೈಸೊ ಅಪ್ನಿ ಮಾನವ ಸ್ವಭಾವ ಅಪೊನೆ ಪಸಂದ ಆಯಲ ಲಿಂಗತ ಜಿವ್ಸಾನೆ ಸಾಧ್ಯ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ತುಮಾರಿ ಪಾಪ್ನಿ ಸ್ವಭಾವ ಛಾಳಿಯೊ ಆಸ ಕರಾನಿಯೊ ಕೆಟ್ಟ ಕಾಮೊ ಕರಾನಾಹುತಿ ತುಮೆ ತುಮಾರಿ ಜಿವಿತ ಉಪಯೊಗ ಕರ‍್ಯಾಮ, ತುಮೆ ಆತ್ಮಿಕಮಾ ಮರೊಸಿ. ತೆನೈಸೊ ತುಮೆ ತುಮಾರಿ ಅಂಗನಾ ಮುಕಾಂತರ ಕರಾನಾ ಕೆಟ್ಟ ಕಾಮೊ ಪವಿತ್ರ ಆತ್ಮಾನಿ ಸಹಾಯಾ ಕ್ಹು ಹುಬ್ರಾಡ್ಯಾಮ ಜಿವ್ತಾ ರ‍್ಹವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ಕುನ್ನ ತ್ಯುನೊನೆ ಕ್ಹುದಾನಿ ಆತ್ಮಾ ಚ಼ಲಾವಾನೆ ವಪ್ಸಿನ ದಿವಸ. ತ್ಯುನೆಜ಼ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ಅಪೆ ಹೊಂದಿಲಿದಲ ಆತ್ಮಾ ವರಿ ಅಪೊನೆ ಗುಲಾಮೊ ಕರ‍್ತೊ ನೈ ವರಿ ಅಪೊಮಾ ಬೆ ಹುಟ್ಸಾತೊ ನೈ. ಅಪೆ ಹೊಂದಲಿದಲ ಪವಿತ್ರ ಆತ್ಮಾ ಅಪೊನೆ ಕ್ಹುದಾ ಬಚ್ಚಾಲಿಂಗತ ಕರಸ. ಎ ಆತ್ಮಾನಾ ಮುಲಕ ಅಪೆ ಕ್ಹುದಾನೆ ಬಾ ಬಲೈಯೆಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ಅಪೆ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ ಥಯಾಸ ಕೈನ ಪವಿತ್ರ ಆತ್ಮಾಜ಼಼ ಅಪ್ನಾ ಆತ್ಮಾಮಾ ಸಾಕ್ಷಿ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ಅಪೆ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ಼ ಥಯಾಮ, ಹೊ ಕ್ಹುದಾನೆ ವಾರಸ್ದಾರ ಥಯಾಸ. ವರಿ ಕ್ರಿಸ್ತನಾ ಕ್ಹಾತೆ ಛೆ, ಇಮ್ಮ ಥಯುಮ, ಕ್ರಿಸ್ತನಾ ಕ್ಹಾತೆ ಅಪೆ ವಾರಸ್ದಾರ ಥಯಾಸ. ತಿನಿ ಮಹಿಮಾಮಾ ವಾಟೊಲಿವಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ಮನೆ ಕಳಲ ತೆಕ್ಲು ಹಮ್ನಾ ಅಪೆ ತ್ರಾಸೊಮಾ ತಡ್ದಿಲಿವಾಡ್ಯಾಸ. ವರಿಬಿ ಅಪೊನೆ ಅಗು ದಿವಾನು ಮಹಿಮಾನೆ ಎ ಕಸ್ಟ ತ್ರಾಸೊ ಹೊಲಶ್ಯಾಮ ಎ ಮೊಜಾ಼ನೆ ಥಾತೊ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ಕ್ಹುದಾ ತಿನಾ ಬಚ್ಚಾ಼ವೊನೆ ದೆಕಾಡಾನಾ ದಿನೊಮಾ ಕ್ಹುದಾನಿ ಕ್ಹಾರಿ ಸೃಷ್ಟಿ ಉತ್ಸಾಹಕ್ಹು ಆಸ ಕರಾಡ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ಕ್ಹಾರಿ ಸೃಷ್ಟಿಜ಼ ನಿರಾಶನೆ ಮ್ಹೈನ ಥೈನ ಛೆ. ಇಮ್ಮ ಥಯಲ ತಿನಿ ಸ್ವಂತ ಉದ್ದೆಶಕ್ಹು ವರಿ ಮನಸಕ್ಹು ನ್ಹವೈ, ಕ್ಹುದಾನಿ ಮನಸ ಕ್ಹುಜ಼ ವ್ಹೈ ವರಿ ಇಮ್ಮ ಥೌ ಕೈನ ಕ್ಹುದಾನಿ ಆಸ ವ್ಹತ್ತಿ. ತಿನಾಹುತಿ ಸೃಷ್ಟಿ ಹಜು಼ನಬಿ ಆಸ ಕರಾಡಿಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ಕ್ಹಾರಿ ಸೃಷ್ಟಿ ನಾಶಕ್ಹು ಬಿಡುಗಡೆ ಥೈನ ಕ್ಹುದಾನಾ ಬಚ್ಚಾವೊನೆ ಸ್ವತಂತ್ರ ಮಹಿಮಾ ಹೊಂದಿಲಿವಸ ಕವಾನು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ಕ್ಹಾರಿ ಸೃಷ್ಟಿ ಜ಼ನ್ನಾನಿ ಬಾಣತಿ ತ್ರಾಸ ಖಾತಿ ರ‍್ಹಯಲ ಹೆಣ ಮನಕ್ಹ ಲಿಂಗತ ದುಖ ಕ್ಹು ನೆಳ್ತಿ ಹಜು಼ನ ಲಕ್ಕಾ ಕೈದಾಡ್ಯುಸ ಕವಾನು ಅಪೊನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ಸೃಷ್ಟಿ ಯಕ್ಕಜ಼ ನೈ, ಅಪೆಬಿ ಅಪ್ನೊಮಾ ದುಖ ಕ್ಹು ನೆಳ್ತಾ ಕೈದಾಡ್ಯಾಸ. ಕ್ಹುದಾನಿ ವಾತನಿ ಪೈಲಾನೊ ಭಾಗ ಥಯಲ ಕ್ಹುದಾನಿ ಆತ್ಮಾನೆ ಅಪೆ ಹೊಂದಿಲಿದ್ಯಾಸ. ಅಪೊನೆ ತಿನಾ ಸ್ವಂತ ಬಚ್ಚಾ಼ ಥೈನ ಕರಿಲಿವಾನೆ ಕ್ಹುದಾ ಕರತೊ ರ‍್ಹಯಲ ಕಾಮ ಪುರಾ ಥಾವಾನುಜ಼ ಕದ್ಯಾಮ, ಅಪ್ನಾ ಅಂಗನೆ ಥಾವಾನೆ ಬಿಡುಗಡೆಜ಼ ಅಪೆ ಕೈದಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ಅಪೆ ರಕ್ಷಣೆ ಹೊಂದಿಲಿದ್ಯಾಸ ವರಿ ಅಪೊನೆ ಹಜು಼ನಬಿ ತೆ ಆಸ ಛೆ. ಅಪೆ ಶಾನಾಹುತಿ ಕೈದಾಡ್ಯಾಸ ತೆ ದೆಕಾಲಾ ರ‍್ಹಯಾಮ, ತೆ ಕ್ಹರಿನಿ ಆಸ ನ್ಹವ್ಹೈ. ಮನಕ್ಹೊ ತ್ಯುನೆ ಹಮ್ನಾ ಹೊಂದಿಲಿದಲ ಕೈಜ಼ ಆಸ ಕರಸಕೆಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ತೆನೈಸೊ ಅಪೆ ಹಜು಼ನಬಿ ನೈ ಹೊಂದಿಲಿದಲ ರ‍್ಹಯಲ ಆಸ ಕರತಾ ತಡ್ದಿಲಿನ ತಿನಾ ಹುತಿ ಕೈದಾಡ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ತಿನಾ ಲಿಂಗತಜ ಅಪೊಮಾ ತಾಕತ ಕಮ ರ‍್ಹಯಲ ಹುತಿ ಅಪ್ನಿ ಕಮ ತಾಕತಮಾ ಪವಿತ್ರ ಆತ್ಮಾ ಅಪೊನೆ ಸಹಾಯಾ ಕರಸ. ಅಪೆ ಕಿಮ್ಮ ಪ್ರಾಥನಾ ಕರು ವರಿ ಶಾನಾ ಹುತಿ ಪ್ರಾಥನಾ ಕರು ಕವಾನು ಅಪೊನೆ ಗ್ವತ್ತ ನತ್ತಿ. ತೆನೈಸೊ ಪವಿತ್ರ ಆತ್ಮಾ ತೆ ಅಪ್ನಾ ಹುತಿ ಕ್ಹುದಾನೆ ಕವಾನೆ ಥಾಯೆ ನೈಸೊ ಮನಸೆ ಮಾಂಗಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ಅಂತರಂಗ ದೆಕಾಲೊ ಕ್ಹುದಾನೆ ಪವಿತ್ರ ಆತ್ಮಾನೆ ಮನಸ್ಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರುಜ಼ ಗ್ವತ್ತ ಛೆ, ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾನಿ ಚಿತ್ತ ಲಿಂಗತಜ಼ ಪವಿತ್ರ ಆತ್ಮಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊನಾ ಹುತಿ ಕ್ಹುದಾಕನ ಮಾಂಗಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ಕ್ಹುದಾ ತಿನೆ ಮಯಾ ಕರಾಲಾವೊನಾ ಹುತಿ ಚೊ಼ಕಾ ಕ್ಹು ಹರಿ ಯಕ್ಕ ಕಾಮ ಆಸಾನ ಕರಸ ಕೈನ ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ತೆ ಮನಕ್ಹೊ ಕ್ಹುದಾಜ಼ ಇನಿಲಿದ್ಯೊಸ, ಕಾಕದ್ಯಾಮ ತೆ ತಿನು ಉದ್ದೆಶ ವ್ಹತ್ತು. ");
INSERT INTO sle_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ಕ್ಹುದಾ ಪೈಲಾತೊಜ಼ ತೆ ಭಾಯೊನೆ ಇನಿಲಿದ್ಯೊತೊ ವರಿ ತೆ ಮನಕ್ಹೊ ಇನಾ ದಿಕ್ರಾನಾ ಲಿಂಗತ ರ‍್ಹೌ ಕೈನ ಫೈಸಲೊ ಕರ‍್ಯೊ. ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಬರೊಕ್ಹಾಮಾ ರ‍್ಹಯಲವಾಲಾವೊಮಾ ತಿನೊ ದಿಕ್ಕರೊಜ಼ ಮ್ಹೊಟೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಕಿನೆ ತೆ ಬಲಾವಸ ತಿನೆ ಇನಿಲಿದ್ಯೊಸ ವರಿ ತ್ಯುನೊನೆ ತೆ ನಿತಿವಂತ ಥೈನ ಕರಸ ವರಿ ಮಹಿಮಾಮಾಬಿ ಬಲೈಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ಇನಾಹುತಿ ಅಪೆ ಸು ಕಯ್ಯೆ? ಕ್ಹುದಾ ಅಪ್ನಾ ಕ್ಹಾತೆ ರ‍್ಹತಾಮಾ, ಅಪೊನೆ ವಿರುದ್ದ ಕರಾಲಾ ಕುನ್ನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ಕ್ಹುದಾ ತಿನಾ ಸ್ವಂತ ದಿಕ್ರಾನೆ ವಚಾ಼ಡಿ ಲಿದ್ಯಾವಾಚಿ ಅಪೊನೆ ಕ್ಹಾರಾವೊನಾ ಹುತಿ ವಪ್ಸಿನ ದಿದ್ಯೊ. ತಿನಾಹುತಿ ಹಮ್ನಾ, ಕ್ಹುದಾ ಯೆಸುನಾ ಕ್ಹಾತೆ ಅಪೊನೆ ಕ್ಹಾರುಜ಼ ಕ್ಹರಿಬಿ ದಿದ್ಯಾವಾಚಿ ರ‍್ಹವಸ ಸು? ");
INSERT INTO sle_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ಕ್ಹುದಾ ಇನಿಲಿದಲ ಮನಕ್ಹೊನಾ ಉಪ್ಪರ ಕುನ್ನಜ಼ ದೊಷ ನೈ ಘಾಲಸಕ್ಕತಾ? ತ್ಯುನೊನೆ ದೊಷಿ ನ್ಹವೈ ಕೈನ ಕ್ಹುದಾಜ಼ ಫೈಸಲೊ ಕರ‍್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ದೊಷಿ ವ್ಹೈ ಕೈನ ಕವಾಲಾ ಕುನ್ನ ವ್ಹೈ? ಕ್ರಿಸ್ತ ಯೆಸು ಅಪ್ನಾ ಹುತಿ ಜ಼ಲಮ ದಿದ್ಯೊ. ತೆಕ್ಲುಜ಼ ನ್ಹವ್ಹೈ, ತೆ ಮರಲವಾಲಾವೊಮಾತೊ ಜಿವ್ತೊ ಥೈನ ಉಟಿನ ಆಯೊ. ಹಮ್ನಾ ತೆ ಕ್ಹುದಾನಾ ಸಿದಾ ಬಗಲ ಶೆ ವರಿ ಅಪ್ನಾ ಹುತಿ ಕ್ಹುದಾಕನ ಮಾಂಗಿಲಿವಾಡೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ತಿಮ್ಮ ರ‍್ಹಯಮ ಕ್ರಿಸ್ತನಿ ಮಯಾಕ್ಹು ಅಪೊನೆ ಜು಼ದಾ ಕರಾಲಾ ಕುನ್ ವ್ಹೈ? ತ್ರಾಸೊ ತೆನೈಸೊ ಕಷ್ಟ ತೆನೈಸೊ ಕಿರಿಕಿರಿ ತೆನೈಸೊ ಭುಕ್ಕಕು ರ‍್ಹವಾನು ತೆನೈಸೊ ಗರಿಬಿ ತೆನೈಸೊ ಮುಸಿಬತ ತೆನೈಸೊ ಮೌತನು ತ್ರಾಸ ಛೆಸು? ");
INSERT INTO sle_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ಕ್ಹುದಾ, ತಾರಾ ಹುತಿ ಹಮೆ ದಿನ್ನಾ ಮೌತನೆ ಗುರಿ ಥಯಾಸ; ಮನಕ್ಹೊ ಹಮೊನೆ ಕಾಟಾನಾ ಬಕ್ಕರಿಯೊ ಲಿಂಗತ ಅಪ್ನಾ ಕ್ಹಾತೆ ಥಾವಾಡ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ತೆನೈಸೊ ಅಪೊನೆ ಮಯಾ ಕರಲವಾಲಾ ಕ್ಹುಜ಼ ಎ ಕ್ಹಾರಿ ವಿಷಯಮಾ ಜಯಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ಕಯುಜ಼ ತಿನಿ ಮಯಾಕ್ಹು ಅಪೊನೆ ಜು಼ದು ಕರಾನೆ ಸಾಧ್ಯ ನತ್ತಿ ಕೈನ ಮಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕೌಸ; ಮೌತ ನೈತೊ ಜ಼ಲಮ ನೈತೊ, ದೆವದುತೊ ನೈತೊ ಬಿಜಾ಼ ಸ್ವರ್ಗನಾ ಅದಿಕಾರಿಯೊ ನೈತೊ ಕ್ಹಾರಾ ಅದಿಕಾರಿಯೊ ನೈತೊ ಹಮ್ನಾ ನೈತೊ ಭವಿಷ್ಯ, ");
INSERT INTO sle_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ಮಹತ್ವನಿ ಸಂಗತಿಯೊ ರ‍್ಹೈನೆಕಾ, ಉಪ್ಪರ‍ಲ್ಯು ಲೊಕ ರ‍್ಹೈನೆಕಾ ಲೊಕ ರ‍್ಹೈನೆಕಾ ಬಿಜು಼ ಕಯುಬಿ ಸೃಷ್ಟಿ ರ‍್ಹೈನೆಕಾ ಅಪೊನೆ ಅಪ್ನೊ ಕರತಾ ಥಯಲ ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ದಿಕ್ಹಿನ ಆಯಲ ಕ್ಹುದಾನಿ ಮಯಾಕ್ಹು ದುರ ಕರಾನೆ ಥಾತುಜ಼಼ ನೈ ಕೈನ ಕ್ಹರಿಜಮಾಜ಼ ಮನೆ ಗ್ವತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ಮಿ ಕ್ರಿಸ್ತಮಾ ಛೆ ವರಿ ತುಮೊನೆ ಕ್ಹರಿಜ಼ ಕವಾಡ್ಯೊಸ. ಮಿ ಸುಳ್ಳ ನೈ ಬೊಲ್ತೊ. ಮಾರಿಯೊ ವಿಚಾರೊ ಪವಿತ್ರ ಆತ್ಮಾನಿ ಅದಿಕಾರಮಾ ಛೆ. ಎಜ಼ ಅನೆ ಸಾಕ್ಷಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ಮನೆ ಘನ್ನು ದುಖ ಛೆ; ಹಮೆಶಾಬಿ ಮನಸ್ಮಾ ಕಷ್ಟ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ಮಾರಾ ಮನಕ್ಹೊನೆ, ಮಾರು ಮಾಕ್ಹ ವರಿ ರಗತ! ತ್ಯುನಾಕ್ಹು ಮಿ ಕ್ಹುದಾನಾ ಶ್ರಾಪನೆ ಮ್ಹೈ ಥಯೊಸ ವರಿ ಕ್ರಿಸ್ತಕ್ಹು ಜು಼ದೊ ಥಯೊ ಕೈನ ಮಿ ಆಸ ಕರುಸ. ತ್ಯುನೆ ಮಾರಾ ಭಾಯೊ ಭೆನೊ ಥಯಾಸ; ಇಹಲೊಕನಾ ಕುಟುಂಬ ಥಯಾಸ. ತ್ಯುನೊನೆ ಮದತ ಕರಾನೆ ಕ್ರಿಸ್ತನೆ ಛೊಡಿನ ಶ್ರಾಪ ಲಿವಾನೆ ತಯ್ಯಾರ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ತ್ಯುನೆ ಇಸ್ರೆಲನಾ ಮನಕ್ಹೊ ವ್ಹೈ. ತ್ಯುನೆ ಕ್ಹುದಾ ಇನಿಲಿದಲ ಬಚ್ಚಾ಼ ವ್ಹೈ. ತ್ಯುನೆ ಕ್ಹುದಾನಿ ಮಹಿಮಾ ವರಿ ಕ್ಹುದಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ಕರಲ ವಡಂಬಡಿಕೆ ಹೊಂದಿಲಿವಸ. ಕ್ಹುದಾ ತ್ಯುನೊನೆ ಮೊಶೆನಾ ಧರಮಶಾಸ್ತ್ರನಿ ಚೊ಼ಕಿ ಆರಾಧನೆ ತಿನಿ ವಾಗ್ದಾನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ತ್ಯುನೆ ಅಪ್ನಾ ಪಿತೃವೊನಾ ಸಂತಾನೊನೆ ಮಳಲವಾಲಾ ಥಯಾಸ; ಕ್ರಿಸ್ತ ಮನಕ್ಹನು ಅಂಗ ಲಿನ ಇವ್ನಾ ಖಾಂದಾನಮಾ ಹುಟ್ಯೊ. ಕ್ರಿಸ್ತ ಕ್ಹಾರಾನೆಬಿ ಮಾಲಕ ಥಯೊಸ. ಕ್ಹಾರಾವೊಪರ ಅದಿಕಾರ ಕರಾಲಾ ಕ್ಹುದಾನೆ ಹಮೆಶಾಬಿ ಸ್ತೊತ್ರಾ ಥಾವಾದೆ! ಆಮೆನ್. ");
INSERT INTO sle_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ಹೊ, ಮಿ ಯೆಹುದಿಯೊನಾ ವಿಷಯಮಾ ದುಖಿ ಥೌಸ. ಕ್ಹುದಾ ತಿನಿ ವಾಗ್ದಾನ ಪುರಾ ಕರಾನೆ ಥಯು ನತ್ತಿ ಕೈನ ಮಿ ಕವಾಡೊ ನತ್ತಿ. ಕಾಕದ್ಯಾಮ ಇಸ್ರಾಯೆಲ ಖಾಂದಾನಮಾ ಹುಟ್ಟಲವಾಲಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ತೆನೈಸೊ ಅಬ್ರಹಾಮನಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ನ್ಹವೈ ಕ್ಹುದಾ ಅಬ್ರಹಾಮನೆ ಅಮ್ಮ ಕದ್ಯೊ ಮಿ ವಾಗ್ದಾನ ಕರು \"ಇಸಾಕಕ್ಹು ಆವಾಲಾ ಬಚ್ಚಾ಼ ತ್ಯುನೆ ಯಕ್ಕಜ಼ ತಾರಾ ಮನಕ್ಹೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ಇನು ಮತ್ಲಬ ಸುವ್ಹೈ ಕದ್ಯಾಮ, ಅಂಗಕ್ಹು ಹುಟ್ಟಲವಾಲಾ ಮನಕ್ಹೊ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ಼ ನ್ಹವೈ. ವಾಗ್ದಾನನಾ ಪ್ರಕಾರ ಹುಟ್ಟಲವಾಲಾಜ಼ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ಼ (ಕ್ಹರಿನಾ ಬಚ್ಚಾ಼) ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ಕ್ಹುದಾ ತಿನೆ, ಕರೆಟ್ಟ ಟೈಮಮಾ ಮಿ ವರಿ ಔಸ\" ತೆಳಾಮಾ ಸಾರಳನೆ ಯಕ್ಕ ದಿಕ್ರೊ ರ‍್ಹವಸ ಕವಾನಿ ವಾಗ್ದಾನ ಕರ‍್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ತೆಕ್ಲುಜ಼ ನೈಸೊ, ರೆಬೆಕ್ಕಕಳನೆಬಿ ಬೆ ಪಟ್ಟಾ ವ್ಹತ್ತಾ. ತ್ಯುನೊನೆ ಭಂಬಿ ಜ಼ನಾವೊನೆಬಿ ಯಕ್ಕಲೊಜ಼ ಬಾ ವ್ಹೈ. ತೆಜ಼ ಅಪ್ನೊ ಪಿತೃ ಥಯಲ ಇಸಾಕ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ತೆನೈಸೊ ತೆ ಭಂಬಿ ಪಟ್ಟಾ ಹುಟ್ಟಾತಿ ಪೈಲಾಜ಼, ಕ್ಹುದಾ ರೆಬೆಕ್ಕಕಳನೆ\"ಮ್ಹೊಟೊ ರ‍್ಹಯಲವಾಲೊ ನ್ಹಾನಾ ರ‍್ಹಯಲವಾನೆ ಸೆವೆ ಕರಸ \"ಕದ್ಯೊ. ತೆ ಪಟ್ಟಾ ಕಯುಜ಼ ಕೆಟ್ಟ ರ‍್ಹವಾದೆ ಚೊ಼ಕು ರ‍್ಹವಾದೆ ಕರಾತಿ ಪೈಲಾಜ಼ ಎ ಕ್ಹಾರು ಥಯು. ಕ್ಹುದಾ ತೆ ಪಟ್ಟಾನೆ ತಿನಾ ಸ್ವಂತ ವಿಚಾರಕ್ಹು ಇನಿಲಿದಲ ಹುತಿ ತೆ ಪಟ್ಟಾ ಹುಟ್ಟಾತಿ ಪೈಲಾಜ಼ ಇಮ್ಮ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ಕ್ಹುದಾ ತಿನೆ ಇನಿಲಿದಲ ಹುತಿ ತಿನೆಜ಼ ಬಲೌ ಕೈನ ವ್ಹತ್ತೊ. ತೆನೈಸೊ ತೆ ಪಟ್ಟಾವೊನಾ ಕಯಾಜ಼ ಕಾಮೊ ಪರ ಆಧಾರ‍ ನ್ಹೊತು. ");
INSERT INTO sle_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ತಿನಾಹುತಿಜ಼\"ಮಿ ಯಾಕೊಬನೆ ಮಯಾ ಕರ‍್ಯೊ. ತೆನೈಸೊ ಎಸಾವನೆ ದ್ವೆಶ ಕರ‍್ಯೊ \"ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ಇಮ್ಮ ರ‍್ಹಯುಮ, ಅಪೆ ಕ್ಹುದಾನೆ ಅನ್ಯಾಯ ಕರಾಲೊ ವ್ಹೈ ಕೈನ ಕೆ ಸಕೆಸ ಸು? ಕೆಳಾಮಾಬಿ, ನ್ಹವೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ಕ್ಹುದಾ ಮೊಶೆನೆ\"ಮಿ ಕಿನೆ ಕರುಣಾ ದೆಕಾಡು ಕೌಸ ತಿನೆ ಕರುಣಾ ದೆಕಾಡುಸ. ಮಿ ಕಿನೆ ಮರಗಾ ದೆಕಾಡು ಕೌಸ ತ್ಯುನೊನೆ ಮರಗಾ ದೆಕಾಡುಸ \"ಕೈನ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ತಿನಾಹುತಿ ಕ್ಹಾರು ಮನಕ್ಹ ಥಯಲ ಅಪೆ ಸು ಕರೆಸ ನೈತೊ ಅಪೊನೆ ಸು ಚಾ಼ಯೆ ಕವಾನಾ ಉಪ್ಪರ ನತ್ತಿ. ತೆನೈಸೊ ಕ್ಹಾಲಿ ಕ್ಹುದಾ ಮರ್ಗಾಕ್ಹು ಛೆ. ತಿನೆ ಇನಿಲಿವಾನು ಮನಕ್ಹೊ ಸು ಕರು ಕವಸ ತೆನೈಸೊ ಸು ಕರಾನೆ ಕೊಶಿಶ ಕರಸ ಕವಾನಾ ಉಪ್ಪರ ಆದಾರ ನತ್ತಿ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಕ್ಹುದಾ ಇಜಿಪ್ತನೊ ರಾಜಾ಼ನೆ\"ಮಿ ತುಮೊನೆ ಮಾರಿ ತಾಕತ ದೆಕಾಡು ಕೈನ ಜಗತ್ಮಾ ಕ್ಹಾರಿ ಜ಼ಗಾ ಮಾರು ನಾಮ ಲೌ ಕೈನ ಮಿ ತುನೆ ರಾಜೊ಼ ಥೈನ ಕರ‍್ಯೊ \"ಕೈನ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ತಿನಾಹುತಿ ಕ್ಹುದಾ ತೆ ಕಿನೆ ಕರುಣಾ ದೆಕಾಡು ಕವಸ ತ್ಯುನೊನೆ ಕರುಣಾ ದೆಕಾಡಸ. ಕ್ಹುದಾ ಕಿನೆ ಮಂಡ ಕರು ಕೈನ ಕವಸ ತ್ಯುನೊನೆ ಮಂಡ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ಅಪೊಮಾ ಯಕ್ಲೊ ಕುನ್ನ ತಬಿ ಮನೆ \"ಇಮ್ಮ ರ‍್ಹಯಮ, ಕುನ್ನಬಿ ತಪ್ಪಮಾ ಛೆ ಕೈನ ಕ್ಹುದಾ ಹುಡಕಾನು ಕಿಮ್ಮ ವ್ಹೈ? ಕ್ಹುದಾನಿ ಚಿತ್ತನೆ ಅಡ್ಡ ಕರಾಲಾ ಕುನ್ ವ್ಹೈ? ");
INSERT INTO sle_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ತೆನೈಸೊ ಎ ಮನಕ್ಹ ಕ್ಹುದಾನೆ ಇಮ್ಮ ಪುಚ್ಚಾ಼ಲೊ ತು ಕುನ್ನ ವ್ಹೈ. ಗಾಡಗಿ ತಿನೆ ತಯ್ಯಾರ ಕರಲವಾಲಾನೆ\"ತು ಮನೆ ಇಮ್ಮ ತಯ್ಯಾರ ಕಾ ಕರ‍್ಯೊ \"ಕೈನ ಪುಚ಼್ಚಲ ಛೆಸು? ");
INSERT INTO sle_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ಕ್ಹಾರು ಥಯಲ್ಪರ, ಗಾಡಗಿಯೊ ತಯ್ಯಾರ ಕರಾಲೊ ಮನಕ್ಹ ತೆ ಮಾತಿನೆ ಉಪಯೊಗ ಕರಾನು ಹಕ್ಕ ವ್ಹಂದಿಲಿದಲ ರ‍್ಹವಸ, ವರಿ ಯಕ್ಕಜ಼ ಮಾತಿಕ್ಹು ಬೆ ಗಾಡಗಿ ತಯ್ಯಾರ ಕರಾನೆ, ಖಾಸ ಮೌಕಾಮಾ ಯಕ್ಕ ವರಿ ದಿನ್ನೆ ಉಪಯೊಗ ಕರಾನೆ ವರಿಯಕ್ಕ ತಯ್ಯಾರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ಕ್ಹುದಾ ಕರಲಬಿ ಅಮ್ಮಜ಼ ವ್ಹೈ. ತೆ ತಿನಿ ಶಿಟ್ಟ ದೆಕಾಡಿನ, ತಿನಿ ತಾಕತ ಮನಕ್ಹೊನೆ ದೆಕ್ಕಲಾಡಿನ ದ್ಯು ಕೈನ ವ್ಹತ್ತೊ. ವರಿಬಿ ತೆ ತಿನಿ ಶಿಟ್ಟನೆ ಗುರಿ ಥೈನ ಹಾಳ ಥಾವಾನಾ ಮನಕ್ಹೊನೆ ಘನ್ನಿ ಸಮಾದಾನಕ್ಹು ತಡ್ದಿಲಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ಕ್ಹುದಾ ತಿನಿ ಮ್ಹೊಟಿ ಮಹಿಮಾ ದೆಕಾಡು ಕೈನ ಸಮಾದಾನಕ್ಹು ಕೈದಾಡೊತೊ. ತಿನಿ ಕರುಣಾ ಹೊಂದಿಲಿವಾನಾ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾ ತೆ ಮಹಿಮಾ ದ್ಯು ಕೈನ ವ್ಹತ್ತೊ. ತಿನಿ ಮಹಿಮಾ ಹೊಂದಿಲ್ಯು ಕೈನ ಕ್ಹುದಾ ತೆ ಮನಕ್ಹೊನೆ ತಯ್ಯಾರ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ಅಪೆಜ಼ ತೆ ಮನಕ್ಹೊ ವ್ಹೈ. ಕ್ಹುದಾ ಬಲಾಯಲ ಮನಕ್ಹೊ ಅಪೆಜ಼ ವ್ಹೈ. ಕ್ಹುದಾ ಅಪೊನೆ ಯಹುದ್ಯೊ ವಾಲಾವೊಮಾತೊ ವರಿ ಯಹುದ್ಯೊ ನೈಸೊ ವಾಲಾವೊಮಾತೊ ಬಲಾಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ಪವಿತ್ರ ಗ್ರಂಥನಾ ಹೊಶೆಯನನಾ ಪುಸ್ತಕ್ಕಮಾ ಇಮ್ಮ ಬರ್ದಲ ಛೆ; \"ಮಾರಾ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಮಾರಾ ಮನಕ್ಹೊ ವ್ಹೈ ಕೈನ ಕೌಸ. ಮನೆ ಮಯಾ ನೈ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಮನೆ ಮಯಾ ರ‍್ಹಯಲವಾಲಾ ವ್ಹೈ ಕೈನ ಕೌಸ\" ಹೊಶೆಯ 2:23 ");
INSERT INTO sle_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ವರಿ \"ಕಯಾ ಜ಼ಗಾಪರ ತುಮೆ ಮಾರಾ ಮನಕ್ಹೊ ನ್ಹವೈ ಕೈನ ಕದ್ಯೊತೊತೊ ತೆಜ಼ ಜ಼ಗಾಪರ ತ್ಯುನೊನೆ ಜಿವ್ತೊ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ಬಚ಼್ಚಾ ವ್ಹೈ ಕೈನ ಬಲಾವಸ\" ಹೊಶೆಯ 1:10 ");
INSERT INTO sle_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ಎನೈಸೊ ಯೆಶಾಯ ಇಸ್ರೆಲನಾ ಹುತಿ ಅಡ್ಡಿನ ಕದ್ಯೊಸ; \"ಸಮುಂದರನಿ ದಂಡಿನಾ ಉಸುಕ ಲಿಂಗತ ಇಸ್ರೆಲವಾಲಾ ಮೊಜಾ಼ನೆ ನೈ ಆಯೆ ಲಿಂಗತ ಥಾವಸ. ತೆನೈಸೊ ತೆ ಮನಕ್ಹೊಮಾ ಖಾಲಿ ದಕ್ಹಾಜ಼಼ನಾ ರಕ್ಷಣೆ ಹೊಂದಿಲಿದವಾಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ಹೊ, ಪ್ರಭು ಜಿ಼ಮಿನ್ಪರ ತಿನಿ ವಾತ ಕ್ಷಣಮಾ ಪುರಾ ಕರಿಪಾಡಸ\" ಯೆಶಾಯ 10:22-23 ");
INSERT INTO sle_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ಯೆಶಾಯ ಕದಲ ಸುವೈ ಕದ್ಯಾಮ; \"ಪ್ರಭು ಸರವಶಕ್ತ ಥಯೊಸ. ಪ್ರಭು ತಿನಾ ಮನಕ್ಹೊಮಾ ದಕ್ಹಾ ಜ಼ನಾವೊನೆ ಅಪ್ನಾ ಹುತಿ ವಚಾ಼ಡ್ಯೊಸ. ತೆ ಇಮ್ಮ ನೈ ಕರತ್ತೊ, ಹಮ್ನಾ ಅಪೆ ಸೊದೊಮಿನ ಲಿಂಗತ ಗೊಮುರ ಲಿಂಗತ ರ‍್ಹತಾತಾ\" ಯೆಶಾಯ 1:9 ");
INSERT INTO sle_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ಇನು ಮತ್ಲಬ ಸುವೈ ಕದ್ಯಾಮ, ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ನಿತಿವಂತವಾಲಾ ಥಾವಾನೆ ಕೊಶಿಶ ಕರತಾ ನ್ಹೊತಾ. ತೆನೈಸೊ ತ್ಯುನೊನೆ ನಿತಿವಂತವಾಲಾ ಥೈನ ಕರ‍್ಯೊ. ತ್ಯುನೆ ಬರೊಕ್ಹಾಕ್ಹು ನಿತಿವಂತವಾಲಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ಕ್ಹುದಾನಾ ಮನಕ್ಹೊನೆ, ಧರ್ಮ ಶಾಸ್ತ್ರನಾನಿಂಗತ ಚಾ಼ಲಿಲಿನ ಜಾ಼ವಾನಾನಿಂಗತ ನಿತಿವಂತವಾಲಾ ಥವಾನೆ ಕೊಶಿಕರ‍್ಯಾತುಬಿ ತ್ಯುನೆ ಥಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ಕಾಕದ್ಯಾಮ ಕಾಮೊಕ್ಹು ನಿತಿವಂತವಾಲಾ ಥಾವಾನೆ ತ್ಯುನೆ ಕೊಶಿಶ ಕರ‍್ಯಾ ತೆನೈಸೊ ಬರೊಕ್ಹಾನೆ ಆದಾರ ಕರಿಲಿದ್ಯಾ ನೈ. ಮನಕ್ಹೊನೆ ಪಾಡಾನ ದೆಕಾನಾ ದಗ್ಡಾಪರ ತ್ಯುನೆ ಟೆಕ್ಹ ಲಾಗಿನ ತ್ಯುನೆ ಪಡ್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ಪವಿತ್ರ ಗ್ರಂಥ ತೆ ದಗ್ಡಾನಾ ಹುತಿ ಇಮ್ಮ ಕದ್ಯುಸ; \"ಅದೆಕ್ಕ, ಮಿ ಸಿಯೊನಮಾ ಪಾಡಾನೆ ಯಕ್ಕ ದಗ್ಡೊ ಮ್ಹೆಲುಸ. ಎ ದಗ್ಡಾಕ್ಹು ಮನಕ್ಹೊ ಪಡಸ. ತೆನೈಸೊ ತೆ ದಗ್ಡಾಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಕೆಳಾಮಾಬಿ ತಿನಿ ಆಸ ಭಂಗ ನೈ ಥಾತಿ\" ಯೆಶಾಯ 8:14; 28:16 ");
INSERT INTO sle_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ಭಾಯೊ ಭೆನೊ, ಮಾರಾ ಸ್ವಂತ ಮನಕ್ಹೊ ರಕ್ಷಣೆ ಹೊಂದಿಲ್ಯು ಕೈನ ಮಾರಿ ಘನ್ನಿ ಮ್ಹೊಟಿ ಆಸ ಛೆ. ಮಿ ಕ್ಹುದಾಕನ ತಿನಾಹುತಿ ಪ್ರಾಥನಾ ಕರಾಡ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ತ್ಯುನೊನೆ ಘನ್ನಿ ಕ್ಹುದಾಪರ ಭಕ್ತಿ ಛೆ ಮಿ ತಿನಾ ಹುತಿ ಮಿ ಸಾಕ್ಷಿ ದ್ಯುಸ. ಕ್ಹರಿಜ಼ ಕೌಸ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಭಕ್ತಿ ಕ್ಹರಿನಿ ಗ್ಯಾನಪರ ಆದಾರ ಥಯಾ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ನಿತಿವಂತ ಕರಾನು ಕ್ಹುದಾನಿ ವಾಟ ತ್ಯುನೆ ನೈ ತಿಳದಿಲಿದಲ ಹುತಿ ತ್ಯುನಿ ಸ್ವಂತ ವಾಟನಾ ಮುಲಕ ತ್ಯುನೊನೆಜ಼ ನಿತಿವಂತೊ ಥೈನ ಕರಲಿವಾನೆ ಕೊಶಿಶ ಕರ‍್ಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ತಿನಾಮಾ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲೊ ಹರಯಕ್ಲೊ ನಿತಿನೊ ಫೈಸಲೊ ಹೊಂದಿಲಿವ ಕೈನ ಕ್ರಿಸ್ತ ಧರಮಶಾಸ್ತ್ರ ಪುರಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ಧರಮಶಾಸ್ತ್ರಕ್ಹು ಥಾವಾನಾ ನಿತಿನಾ ಹುತಿ\"ಧರಮಶಾಸ್ತ್ರನೆ ಚಾ಼ಲಿಲಿನ ಜಾ಼ವಾನಾ ಮುಲಕ ಜ಼ಲಮ ಪಡ್ದಿಲ್ಯು ಕೈನ ಕವಾಲೊ, ಧರಮಶಾಸ್ತ್ರ ಕವಾನಾ ಕಾಮೊ ಕರುಜ಼ \"ಎ ಮೊಶೆ ಕದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ತೆನೈಸೊ ಬರೊಕ್ಹಾನಾ ಮುಲಕ ನಿತಿನೊ ಫೈಸಲೊ ಹೊಂದಿಲಿವಾನಾ ಹುತಿ (ಕ್ರಿಸ್ತನೆ ಹೆಟಾ ಬಲೈಲಿನ ಆತಾಮಾ) ಕುನ್ ಪರಲೊಕನೆ ನೈ ಜಾ಼ಸ? ಕೈನ ರ‍್ಹವಾದೆ (ಕ್ರಿಸ್ತನೆ ಮರಲವಾಲಾವೊಮಾತೊ ಉಟಾಡಿನ ಲಾವಾಕ್ಹು) ");
INSERT INTO sle_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","\"ಕುನ ಪಾತಾಳನೆ ನೈ ಜಾ಼ತು ಕೈನ ರ‍್ಹವಾದೆ ಕವೊ ನಕೊ \"ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ಕ್ಹುದಾನಿ ವಾಕ್ಯಾ ತುಮಾರಿ ಕ್ಹಾಮಿಜ಼ ಛೆ; ತೆ ತಾರಾ ಮ್ಹೊಡಾಮಾ ತಾರಾ ಮನಸಮಾಬಿ ಛೆ ಕವಸ. ತೆ ವಾಕ್ಯಾ ಅಪೆ ಕವಾನು ಬರೊಕ್ಹಾನಿ ವಿಷಯಮಾನಿ ವಾಕ್ಯಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ತೆ ಸುವೈ ಕದ್ಯಾಮ ತು ಯೆಸುನೆಜ಼ ಕರತಾ ವ್ಹೈ ಕೈನ ಮ್ಹೊಡಾಕ್ಹು ಕೈನ ಕ್ಹುದಾ ತಿನೆ ಮರಲ ವಾಲಾವೊಮಾತೊ ಉಟಾಡ್ಯೊಸ ಕೈನ ಮನಸಕ್ಹು ಬರೊಕ್ಹೊ ಮುಕ್ಯಾಮ ತುನೆ ರಕ್ಷಣೆ ಥಾವಸ ಕೈನ. ");
INSERT INTO sle_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ಮನಸಕ್ಹು ಬರೊಕ್ಹೊ ಕರ‍್ಯಾಮ ನಿತಿ ಮಳಸ. ಮ್ಹೊಡಾಕ್ಹು ಕದ್ಯಾಮ ರಕ್ಷಣೆ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ತಿನಾ ಉಪ್ಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಳವಾಲೊ ಕಯೊಬಿ ನಿರಾಶ ಥಾತೊ ನೈ ಕೈನ ಶಾಸ್ತ್ರ ಕವಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ಆ ವಿಷಯಮಾ ಯೆಹುದಿವಾಲಾನೆಬಿ ವರಿ ಗ್ರಿಕವಾಲಾನೆಬಿ ಜಾಸ್ತ ಕಮ ಸು ನತ್ತಿ. ಕ್ಹಾರಾವೊನೆಬಿ ಯಕ್ಲೊಜ಼ ಪ್ರಭು ವ್ಹೈ; ತೆ ತಿನು ನಾಮ ಕವಾಲಾವೊನೆ ಘನ್ನೊಆಶಿರ್ವಾದ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ಅಮ್ಮ ಪವಿತ್ರ ಗ್ರಂಥ ಕದಲ ತಿಮ್ಮ ಕರ್ತಾನು ನಾಮ ಕವಾಲಾವೊನೆ ರಕ್ಷಣೆ ಮಳಸ ಕೈನ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ತೆನೈಸೊ ತುಮೆ ಕಿಪರ ಬರೊಕ್ಹೊ ನತ್ತಿ ಕರ‍್ಯಾ ತಿನು ನಾಮ ಕವಾನೆ ಕಿಮ ಥಾವಸ? ತಿನಿ ವಾಕ್ಯಾ ನೈ ಐಕ್ಯಾಮ ತಿಪರ ಬರೊಕ್ಹೊ ಮುಕ್ಕಾನು ಕಿಮ? ಕವಾಲೊ ನೈ ರ‍್ಹಯಾರೆ ಐಕಾನು ಕಿಮ? ಕವಾಲಾನೆ ಕವಾನೆ ಮೊಕಲ್ಯಾ ಬಗರ ತೆ ಕವಸ ಕಿಮ? ");
INSERT INTO sle_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ಇನೆ ಕರೆಟ್ಟ ಚೊ಼ಕಿ ಸುವಾರ್ತೆ ಕವಾಲಾವೊನಾ ಪಗೊ ಕೆಕ್ಲಾಕಿ ಚೊ಼ಕಾ ಶೆ ಕೈನ ಬರ್ದಲ ಶೆ. ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ಚೊ಼ಕಿಯೊ ವಾತ ಕ್ಹಾರಾ ಜ಼ನಾ ಐಕ್ತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ಆ ವಿಷಯಮಾ ಯೆಶಾಯ- ");
INSERT INTO sle_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ತಿನಾಹುತಿ ಕದಲ ವಾಕ್ಯಾ ಐಕಾಕ್ಹು ಬರೊಕ್ಹೊ ಆವಸ. ವರಿ ವಾಕ್ಯಾ ಯೆಸುನಾ ಹುತಿ ತೆ ಸವಾರತೆ ಐಕಾಕ್ಹು ವರಿ ಕ್ರಿಸ್ತನಿ ವಾಕ್ಯಾ ಐಕಾಕ್ಹು ಸಂದೆಶ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ತಿಮ್ಮ ರ‍್ಹಯುತಬಿ ತ್ಯುನೊನೆ ಐಕು ಐಯು ನೈ ಕೈನ ಪುಚ್ಯೊ. ಐಕು ಆಯಲ ಕ್ಹರಿಜ಼ ವ್ಹೈ. ಕವಾವಾಲವೊನಿ ಆವಾಜ಼ ಜಿ಼ಮಿನ ಪುರಾ ಐಕೈಸ, ತಿವ್ನಾ ವಾತೊ ಜಗತ್ನಾ ಲಾಸ್ಟಲಕಾಬಿ ಫೈಲ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ತೆನೈಸೊ ಇಸ್ರಾಯೆಲನಾ ಮನಕ್ಹೊ ತೆ ಸುವಾರ್ತೆ ತಿಲದಿಲಿದ್ಯಾ ನೈಸು ಕೈನ ವರಿ ಮಿ ಪುಚ್ಚು಼ಸ. ಹೊ, ಆ ವಿಷಯಮಾ- ಮಾರಿ ಜನಾಂಗ ನೈ ರ‍್ಹಯಲ ವಾಲಾವೊಕ್ಹು ತುಮೊಮಾ ಹೊಚ್ಚಿಗಿಟ್ಟಿ ಹುಟಸೌಸ; ಗ್ಯಾನ ನೈಸೊವಾಲಾವೊಕ್ಹು ತುಮೆ ಶಿಟ್ಟ ಹುಟಸೌಸ ಕೈನ ಪೈಲಾಜ಼ ಮೊಶೆ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ತೆನೈಸೊ ಯೆಶಾಯ ಧೈರಕ್ಹು ಬೊಲ್ಯೊ- ಮನೆ ನೈ ಹುಡ್ಕಲ ವಾಲಾವೊನೆ ಮಳ್ಯೊ,ಮಾರಿ ವಿಷಯಮಾ ವಿಚಾರ ಕರೆಲವಾಲಾವೊನಾ ಕ್ಹಾಮೊ ಆಯೊ ಕೈನ ಕದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ತೆನೈಸೊ ಕ್ಹುದಾ ಅಮ್ಮ ಕವಸ ತೆ ಇಸ್ರಾಯೆಲ ವಾಲಾವೊನಾ ವಿಷಯಮಾ- ಮಾರಿ ವಾತನೆ ಅವಿಧೆಯ ಥೈನ ಫರಿನ ಬೊಲಲ ಮನಕ್ಹೊನೆ ಮಿ ದಿನ್ನ ಕ್ಹಾರಿ ಹತ ಕರಿನ ಬಲಾಯೊ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ತಿಮ್ಮ ರ‍್ಹಯುಮ ಕ್ಹುದಾ ತಿನಾ ಮನಕ್ಹೊನೆ ನಕೊ ಕೈನ ಢಕ್ಲಿ ಪಾಡಸ ಸು ಕೈನ ಪುಚ್ಚು಼ಸ. ಕೆಳಾಮಾಬಿ ನೈ. ಮಿಬಿ ಇಸ್ರೆಲೊನೆ, ಅಬ್ರಹಾಮನಾ ಸಂತತಿನೆ, ಬೆನ್ಯಾಮಿಯ ಖಾಂದಾನವಾಲೊ ಥಯೊಸ್ತೊ. ");
INSERT INTO sle_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ಕ್ಹುದಾ ತೆ ಅಗೊ ಥೈನ ತಿನಾ ಮನಕ್ಹೊ ಥಾವಾನೆ ಗ್ವತ್ತ ಕರಿಲಿದಲ ಮನಕ್ಹೊನೆ ಢಕ್ಲಿ ಪಾಡ್ಯೊ ನೈ. ಎಲೀಯಾನಿ ಜವ್ನಾನಾ ಹುತಿ ಪವಿತ್ರ ಗ್ರಂಥ ಕವಾನಿ ವಾತ ತುಮೊನೆ ಗ್ವತ್ತ ನೈ ಥಾತು ಸು? ತೆ ಕ್ಹುದಾನಾ ಕ್ಹಾಮೊ- ");
INSERT INTO sle_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ಕರತಾ\"ತ್ಯುನೆ ತಾರಾ ಪ್ರವಾದಿಯೊನೆ ಖಲಾಸ ಕರ‍್ಯಾಸ, ತಾರಾ ಬಲಿ ದಿವಾನಿ ಜ಼ಗಾ ಪ್ಹೊಡಿ ಪಾಡ್ಯಾಸ, ಮಿ ಯಕ್ಲೊಜ಼ ಉಗರ್ಯೊಸ, ಹಮ್ನಾ ಮನಕ್ಹೊ ಮಾರು ಜ಼ಲಮ ಕಾಡು ಕೈನ ಕರ‍್ಯಾಸ\" ");
INSERT INTO sle_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ಕೈನ ಇಸ್ರೆಲೊನಾ ಉಪ್ಪರ ತಪ್ಪ ಕದಲಕ್ಹು ಕ್ಹುದಾನು ಜವಾಬ ಸು ವ್ಹೈ ಕದ್ಯಾಮ ಬಾಳನಿ ಮುರತಿನೆ ಆರಾಧನಾ ನೈ ಕರಲ ಕ್ಹಾತ ಹಜಾ಼ರ ದಾಣ್ಗಾವೊನೆ ಮಾರಾಹುತಿ ವಚಾ಼ಡಿಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ತಿನಾಲಿಂಗತ ಹಮ್ನಾನಾ ಕಾಲಮಾಬಿ ಕ್ಹುದಾನಿ ಕೃಪಾಕ್ಹು ಇನಿಲಿದಲವಾಲಾ ದಕ್ಹಾ ಜ಼ನಾ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ಕ್ಹುದಾನಿ ಕೃಪಾಕ್ಹು ಇನಿಲಿದಲವಾಲೊ ಕದಲ್ಪರ ಪುಣ್ಯನಾ ಕಾಮೊನಾ ಹುತಿ ಇನಿಲಿದಲ ನ್ಹವೈ ತೆಕ್ಲುಜ಼; ತಿಮ್ಮ ನೈಸೊ ಪಕ್ಷನೆ ಕೃಪಾನೆ ಹಜು಼ನಬಿ ಕೃಪಾ ನೈ ಕವಾನೆ ಥಾತು. ");
INSERT INTO sle_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ಇನಾಕ್ಹು ತಿಳದಿಲಿವಾನು ಸುವೈ? ಇಸ್ರೆಲೊ ಹುಡ್ಕಲ ತ್ಯುನೊನೆ ಮಳ್ಯು ನೈ, ತ್ಯುನೊಮಾ ಇನಿಲಿದಲವಾಲಾವೊನೆ ಮಳ್ಯು. ಬಿಜಾ಼-ಜ಼ನಾ ಪಿಸಾಳಾ ಥಯಾ. ");
INSERT INTO sle_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ಕ್ಹುದಾ ತ್ಯುನೊನೆ ವಜ್ಜು಼ ಕದ್ಯಾಮ ನೈ ದಿಕ್ಹಾನಾ ಡೊಳಾ ನೈ ಐಕಾನಾ ಕಾನೊ ದಿದ್ಯೊ; ಎ ವಜ್ಜು಼ ಆಜ಼ ಲಕ್ಕಾಬಿ ತಿಮ್ಮಜ಼ ಛೆ ಕೈನ ಬರ್ದಲ ತಿಮ್ಮ ತ್ಯುನೊನೆ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ಎನೈಸೊ- ತ್ಯುನು ಅನ್ನಜ಼ ತ್ಯುನೊನೆ ಪಾಖೊ ಸುಜ಼ ಅಡು ಆಯೆ ನೈಸೊ ಶಿಕ್ಷಾ ಥಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ತ್ಯುನಾ ಡೊಳಾ ಮಬ್ಬ ಥೈನ ದಿಖ್ಯಾವಾಚಿ ಥಾವಾದೆ; ತ್ಯುನಿ ಕಂಬರ ಕೆಳಾಮಾಬಿ ಡುಗಾ ಥಾವಾ ವರಕ್ಹು ಕರ ಕೈನ ದಾವಿದ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ತಿಮ್ಮ ರ‍್ಹಯುಮ ತ್ಯುನೆ ಪಡಿನ ಜಾ಼ಯೆ ಲಿಂಗತ ಪಡ್ಯಮ ಸುವೈ ಕೈನ ಪುಚ್ಚು಼ಸ. ತಿಮ್ಮ ಕೆಳಾಮಾಬಿ ಕೌ ನೈ. ತ್ಯುನೆ ಪಡಿಗಯಲಕ್ಹು ಕ್ರಿಸ್ತಕ್ಹು ಥಾವಾನಿ ರಕ್ಷಣೆ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಮಳಿ. ಇನಾಕ್ಹು ಕ್ಹುದಾ ತ್ಯುನಾಮಾ ಹುರುಡು ಹುಟ್ಸಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ಯಹುದ್ಯೊನಾ ಅಪರಾದ ಜಗತ್ನೆ ಘನ್ನಾ ಆಶಿರ್ವಾದೊ ತ್ಯುನಾ ಸೊಲನೆ ಯಹುದಿಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಘನ್ನಾ ಆಶಿರ್ವಾದೊ ಆವಾನೆ ಕಾರಣ ಥಯು. ಕ್ಹುದಾನಿ ಚಿತ್ತನಾ ನಿಂಗತ ಯೆಹುದಿಯೊ ನೈಸೊವಾಲಾವೊನೆ ಬದಲಿ ಥಾತಾಮಾ ದುನಿಯಾ ವರಿ ಜಾಸ್ತಿ ಆಶಿರ್ವಾದೊ ವ್ಹಂದಾನು ಕ್ಹರಿ ವ್ಹೈ ನೈ? ");
INSERT INTO sle_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ಹಮ್ನಾ ಮಿ ಯಹುದ್ಯೊ ನೈ ರಹೆಲ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಬೊಲಾಡೊಸ. ಮಿ ತ್ಯುನೊನೆ ಅಪೊಸ್ತಲ ಥಯೊಸ. ತಿನಾಹುತಿ ಮಿ ಆ ಕಾಮ ಮಾರಾ ಹತೆ ಥಯಲ ತೆಕ್ಲು ಚೊ಼ಕಿ ತರಾ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ಮಿ ಮಾರಾ ಸ್ವಂತ ಮನಕ್ಹೊಮಾ ಅಸೈ ಕರಿನ ತ್ಯುನೊಮಾ ದಕ್ಹಾಜ಼಼ನಾ ತುಬಿ ರಕ್ಷಣೆ ಹೊಂದಿಲಿವಾ ವರಕ್ಹು ಕರುಸ ಕೈನ ಆಸ ಮನೆ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ಯಹುದಿ ಮನಕ್ಹೊನೆ ಇನ್ಕಾರಲ ಹುತಿ ದುನಿಯಾ ಕ್ಹುದಾನಾ ಕ್ಹಾತೆ ಸಂಧಾನ ಥಾವಾನೆ ಸಾದ್ಯ ಛೆ. ಕದ್ಯಾಮ ತ್ಯುನೆ ಮಳೈಲಿದಲದ್ಪರ ಹಜು಼ನ ಸು ಥಾಸ? ಮರಲವಾಲಾ ಜಿವ್ತಾ ಥೈನ ಉಟಿನ ಆಯಲ ಲಿಂಗತ ಥಾವಸು ನೈ? ");
INSERT INTO sle_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ರೊಕ್ಲಾನು ಪಸ್ಟಲ್ಯೊ ತುಕ್ಡೊ ಕ್ಹುದಾನೆ ಚ಼ಡಾಯಲ ಟೈಮ್ಮಾ, ಪುರಾ ರೊಕ್ಲೊಜ಼ ಕ್ಹುದಾನೊ ಥಯೊ. ಝಾಡನಾ ಬೆರಜ಼ ಕ್ಹುದಾನೆ ದಿದ್ಯಾಮ ಪುರಾ ಝಾಡಜ಼ ಕ್ಹುದಾನು ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ಎ, ಆಲಿವ ತೆಲನಾ ಝಾಡೊನಿಯೊ ಠೊಂಗಿಯೊ ತುಟಲ್ಪರ ರಾನ್ಮಾ ರ‍್ಹಯಲ ಆಲಿವ ಝಾಡನಿ ಯಕ್ಕ ಠೊಂಗಿ ಪೈಲಾ ರ‍್ಹಯಲ ಆಲಿವ ಝಾಡನೆ ಮಳಲ ಲಿಂಗತ ಛೆ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ತುಮೆ ರಾನ್ಮಾ ರ‍್ಹಯಲ ಝಾಡನಿಯೊ ಠೊಂಗಿಯೊ ಲಿಂಗತ ಛೆ. ತೆನೈಸೊ ಹಮ್ನ ತುಮೆ ಪೈಲಾನಾ ಝಾಡನೆ ತಾಕತನೆ ಜ಼ಲಮಮಾ ವಾಟೊ ಲಿವಾಲಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ತಿನಾ ಹುತಿ ತುಟಿ ಗಯೆಲ ತೆ ಠೊಂಗಿಯೊನೆ ಇನ್ಕಾರೊ ನಕೊ. ತ್ಯುನೊನೆ ಇನ್ಕಾರಾನೆ ತುನೆ ಕಯುಜ಼ ಕಾರಣ ನತ್ತಿ. ಕಾಕದ್ಯಾಮ ತುಮೆ ಬೆರನೆ ಜ಼ಲಮ ದೆತಾ ನೈ. ಬೆರ ತುಮೊನೆ ಜ಼ಲಮ ದಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ಅಪೆ ತೆ ಝಾಡನೆ ಠೊಂಗಿಯೊನೆ ಮಳಿ ಕೈನ ತೆ ಠೊಂಗಿಯೊ ತುಟಿಯೊ ಕೈನ ತುಮೆ ಕೆ ಸಕೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ತೆ ಕ್ಹರಿ ವ್ಹೈ. ತೆ ಠೊಂಗಿಯೊ ತುಟಿಯೊ. ತಿನೆ ಬರೊಕ್ಹೊ ನೈ ಕರಲ ಕಾರಣ ವ್ಹೈ. ತುಮೆ ತೆ ಝಾಡನು ಯಕ್ಕ ಭಾಗ ಥಯಲ ತುಮಾರಾ ಬರೊಕ್ಹಾಕ್ಹುಜ಼ ವ್ಹೈ. ತಿನಾಹುತಿ ಸ್ವಕ್ಕ ಕರು ನಕೊ, ಭುಚಿ಼ಕಿನ ರ‍್ಹೆ. ");
INSERT INTO sle_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ಕ್ಹುದಾ ಪೈಲಾಜ಼ ಹುಟ್ಟಲ ಠೊಂಗಿಯೊನೆ ನೈ ವಚಾ಼ಡಲ್ಪರ ತುಮೆ ಬರೊಕ್ಹೊ ನೈ ಕರ‍್ಯಾಮ ತೆ ತುನೆ ವಚ಼ಾಡಸು? ");
INSERT INTO sle_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ತಿನಾಹುತಿ ಕ್ಹುದಾ ಮರಗಾಲೊ ವ್ಹೈ ಘನ್ನೊ ಕಠೊರಬಿ ವ್ಹೈ ಕವಾನೊ ವಳಕ. ಕ್ಹುದಾ ತಿನೆ ಪಾಚಾ಼ ನೈ ಆವಾಲಾ ಮನಕ್ಹೊನೆ ಶಿಕ್ಷಾ ದಿವಸ. ತೆನೈಸೊ ತು ಕ್ಹುದಾನಿ ಮರಗಾಮಾ ರ‍್ಹಯೊಮ, ಕ್ಹುದಾ ತುನೆ ಮರಗಾಲೊ ರ‍್ಹವಸ. ನೈತೊ, ತುನೆ ಝಾಡತೊ ಕತ್ರಿನ ನಾಕಿ ಪಾಡಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ಇಸ್ರಾಯೆಲ ಮನಕ್ಹೊ ತಿವ್ನಾ ಬರೊಕ್ಹೊ ನೈ ಛೊಡ್ಯಾಮ ಮಿ ತ್ಯುನೊನೆ ಭಾಂದುಸ, ಕ್ಹುದಾ ತ್ಯುನೊನೆ ವರಿ ತೆ ಝಾಡನೆ ಜೊಡ್ಸಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ರಾನ್ಮಾನಿಯೊ ಠೊಂಗಿಯೊನೆ ಚೊ಼ಕಾ ಝಾಡನೆ ಠೊಂಗಿಯೊ ಥಾವಾನೆ ಆಸಾನ ನ್ಹವೈ. ವರಿಬಿ ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ತುಮೆ ರಾನ್ಮಾ ರ‍್ಹಯಲ ಒಲಿವ ಝಾಡನಾ ಕತ್ರಲ ಠೊಂಗಿಯೊ ರ‍್ಹಯಲ ಚೊ಼ಕಿಯೊ ಆಲಿವ ಝಾಡನೆ ರಾಕ್ಹ ಭಾಂದಲ ಲಿಂಗತ ಛೆ. ಯಹುದ್ಯೊ ಚೊ಼ಕಾ ರ‍್ಹಯಲ ಆಲಿವ ಝಾಡನೆ ಬೆಳದಲ ಠೊಂಗಿಯೊ. ತಿನಾಹುತಿ ತ್ಯುನೆ ತ್ಯುನಾ ಸ್ವಂತ ಝಾಡನೆ ವರಿ ಮಳಾನು ಕ್ಹರಿಬಿ ಸಾದ್ಯ ಛೆ. ಕ್ಹುದಾನೆ ಕೆಕಲು ಆಸಾನ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ಭಾಯೊ, ಭೆನೊ ತುಮೊನೆ ತುಮಾರಿಕ್ಹು ತುಮೆಜ಼ ಶಾಣ್ಯಾ ವ್ಹೈ ಕೈನ ಕವೈಲಿದ್ಯಾವಾಚಿ ಹಜು಼ನ ಲಕ್ಕಾಬಿ ದಡಿ ರ‍್ಹಯಲ ಕ್ಹರಿ ತುಮೊನೆ ಕೌಸ. ತೆ ಸುವೈ ಕದ್ಯಾಮ ಇಸ್ರಾಯೆಲನಾ ದಕ್ಹಾ ಮನಕ್ಹೊ ಮಡ್ಡ ಥಯಾತಬಿ ತೆನೈಸೊ ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ಕ್ಹುದಾಕನ ಆತಾಮಾ ತ್ಯುನೊನೆ ಮಡ್ಡ ರ‍್ಹಯಲ ಗೈಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ಇಮ್ಮ ಕ್ಹಾರಾ ಇಸ್ರಾಯೆಲೊ ರಕ್ಷಣೆ ಹೊಂದಿಲಿವಸ. ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಅಮ್ಮ ಬರ್ದ್ಯಾಸ; \"ಸಿಯೊನತೊ ರಕ್ಷಕ ಆವಸ; ತೆ ಯಾಕೊಬನಾ ಕುಟುಂಬಮಾತೊ ಕ್ಹಾರು ಕೆಟ್ಟತನಾ ಕಾಡಿಪಡಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ಮಿ ತೆ ಮನಕ್ಹೊನಾ ಪಾಪೊ ಪರಿಹಾರ ಕರತಾಮಾ ತ್ಯುನಾ ಕ್ಹಾತೆ ಎ ವಡಂಬಡಿಕೆ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ಯಹುದ್ಯೊ ಸುವಾರ್ತೆ ಒಪ್ಪಿಲಿದ್ಯಾ ನೈ. ತಿನಾಹುತಿ ತ್ಯುನೆ ಕ್ಹುದಾನಾ ವಿರೊಧಿ ಥಯಾಸ. ಯಹುದಿ ನೈಸೊ ಮನಕ್ಹೊನೆ ಮದತ ಥೌಕೈನ ಎ ಥಯು. ತೆನೈಸೊ ಯಹುದ್ಯೊ ಹಜ಼ುನ ಕ್ಹುದಾತಿ ಇನಿಲಿದಲ ಮನಕ್ಹೊ ಥಯಾಸ. ತಿನಾಹುತಿ ತೆ ಪಿತೃವೊನಾ ಕ್ಹಾತೆ ಕರಲ ವಡಂಬಡಿಕೆನಾ ಮುಲಕ ತ್ಯುನೊನೆ ಮಯಾ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ಕ್ಹುದಾ ವರಾ ದಿದಲ ಹುತಿಬಿ ಮನಕ್ಹೊನೆ ಬಲಾಯಲ ಹುತಿ ಪಶ್ಚಾತಾಪ ಪಡಾಲೊ ನ್ಹ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ಯಕ್ಕ ಟೈಮಮಾ ಯೆಹುದಿಯೊ ನೈ ರ‍್ಹಯಲ ತಿನೆ ವಿಧೆಯ ಥೈನ ನ್ಹೊತಾ. ಹಮ್ನಾತುಬಿ ತುಮೆ ಮರಗಾ ಹೊಂದಿಲಿದ್ಯಾಸ. ಕಾಕದ್ಯಾಮ ತ್ಯುನೆ (ಯಹುದ್ಯೊ) ತಿನೆ ವಿಧೆಯ ಥಯಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ಕ್ಹುದಾ ತುಮೊನೆ ಮರಗಾ ದೆಕಾಡಲ ಹುತಿ ಹಮ್ನಾ ಯಹುದ್ಯೊ ವಿಧೆಯ ಥಾತಾ ನೈ. ತೆನೈಸೊ ತ್ಯುನೆಬಿ ಕ್ಹುದಾ ಕಂತಾ ಮರಗಾ ಹೊಂದಿಲ್ಯು ಕೈನ ಇಮ್ಮ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ಕಾಕದ್ಯಾಮ ಕ್ಹಾರಾ ಜ಼ನಾ ಕ್ಹುದಾನೆ ವಿಧೆಯ ಥಯಾ ನೈ. ಕ್ಹುದಾ ಕ್ಹಾರಾವೊನೆ ಮರಗಾ ದೆಕಾಡು ಕೈನ ಕ್ಹಾರಾವೊನೆ ಮಳೈನ ಅವಿಧೆಯ ಕ್ಹು ಭಾಂದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ಹೊ, ಕ್ಹುದಾನಿ ಆಸ್ತಿ ವರಿ ಘನ್ನಿ ಛೆ! ಕ್ಹುದಾನಿ ಗ್ಯಾನ ಘನ್ನಿ ಛೆ. ಕ್ಹುದಾ ಫೈಸಲೊ ಕರಾನಾ ಸಂಗತಿಯೊನೆ ಕುನ್ನಜ಼ ತಿಳ್ಸಾತುನೈ ಕ್ಹುದಾನೊ ಫೈಸಲೊ ದೆಕಾಡಾಲು ಕುನ? ತಿನಾ ವಾಟೊ ತಿಳದಿಲಿವಾನು ಕುನ? ");
INSERT INTO sle_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ಪವಿತ್ರ ಗ್ರಂಥ ಕದಲ ಲಿಂಗತ; ಪ್ರಭುನು ಮನಸ ಕುನ್ ತಿಳ್ದಿಲಿದ್ಯುಸ? ಕ್ಹುದಾನೆ ಕುನ ಸಲಹೆ ಕುನ ದಿವಾನೆ ಥಾವಸ? ಯೆಶಾಯ 40:13 ");
INSERT INTO sle_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ಪೈಲಾ ಕ್ಹುದಾನೆ ಕುನ ಸು ದಿದ್ಯಾಸ? ಕ್ಹುದಾ ಕಿನೆಜ಼಼ ಸಾಲಾ ದಿವಾಲೊ ನ್ಹವ್ಹೈ\" ಯೊಬ 41:11 ");
INSERT INTO sle_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ಹೊ, ಕ್ಹುದಾ ಕ್ಹಾರುಜ಼ ಸೃಷ್ಟಿ ಕರ‍್ಯೊ. ಕ್ಹಾರು ಕ್ಹುದಾನಾ ಮುಲಕ ಕ್ಹುದಾನಾ ಹುತಿಜ಼ ವ್ಹೈ. ಕ್ಹುದಾನೆ ಹಮೆಶಾಬಿ ಮಹಿಮಾ ಥಾವಾದೆ! ಆಮೆನ್. ");
INSERT INTO sle_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ತಿನಾಹುತಿ ಭಾಯೊ, ಭೆನೊ, ಕ್ಹುದಾ ಘನ್ನೊ ಮರಗಾಲೊ ವ್ಹೈ ತುಮೊನೆ ಶೆ ಕರಲಿನ ತುಮೊಕನ ಸು ಮಾಂಗಿಲ್ಯುಸ ಕದ್ಯಾಮ, ತುಮೊನೆಜ಼ ಕ್ಹುದಾನೆ ಒಪ್ಸಿನ, ಮೆಚ್ಚಿಗೆ ರ‍್ಹಯಲ ಖುದ್ದನೆ ಒಪ್ಸಿನ ದಿವೊ. ಎಜ಼ ತುಮೆ ಕರಾನಿ ಕ್ಹರಿನಿ ಆರಾಧನಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ಎ ದುನಿಯಾ ರ‍್ಹಯಲಲಿಂಗತ ನೈ ರ‍್ಹಯಾವಾಚಿ ಮನಸ ಬದ್ಲಿ ಕರಲಿನ ನವು ಮನಸ ಕರಲಿನ ರ‍್ಹವೊ. ತೆಳಾಮಾ ತುಮೆ ಕ್ಹುದಾನಿ ಚಿತ್ತನಾ ಲಿಂಗತ ಕಯು ಚೊ಼ಕು ವ್ಹೈ, ಕಯು ಕೆಟ್ಟ ವ್ಹೈ ಕವಾನು ತಿಳ್ದಿಲಿವೊಸಿ. ");
INSERT INTO sle_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ಕ್ಹುದಾ ಮನೆ ಖಾಸ ಯಕ್ಕ ವರಾ ದಿದ್ಯೊಸ. ತಿನಾಹುತಿಜ಼, ತುಮೊಮಾ ರ‍್ಹಯಲ ಹರ ಯಕ್ಕಲಾವೊನೆ ಎ ಸಂಗತಿಯೊ ತಿಳ್ಸಾವಾಡ್ಯೊಸ. ತುಮೆ ತುಮಾರಾ ಔಕಾತತಿಬಿ ಘನ್ನು ತುಮಾರಾ ವಿಷಯಮಾ ತಿಳ್ದಿಲಿವೊ ನಕೊ. ತುಮೆ ತುಮಾರಿ ವಿಷಯಮಾ ಸು ತಿಳ್ದಿಲಿದ್ಯಾತಬಿ ತೆ ವಿಚಾರ ತುಮಾರಿ ಔಕಾತನೆ ಕರೆಟ್ಟ ರ‍್ಹೌ. ಕ್ಹುದಾ ತುಮೊನೆ ಕೆಕ್ಲೊ ಬರೊಕ್ಹೊ ದಿದ್ಯೊಸ ತೆ ಬರೊಕ್ಹಾ ಲಿಂಗತಜ಼ ತುಮಾರಿ ವಿಷಯಮಾ ತಿಳ್ದಿಲಿವೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ಹರ ಯಕ್ಕಲಾವೊನೆ ಯಕ್ಕ ಅಂಗ ಛೆ. ತೆ ಅಂಗನೆ ಘನ್ನಾ ಭಾಗೊ ಛೆ. ತೆ ಭಾಗೊ ಯಕ್ಕಜ಼ ಕಾಮ ನೈ ಕರ‍್ತಾ. ");
INSERT INTO sle_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ಇಮ್ಮ ಅಪೆ ಘನ್ನಾ ಜ಼ನಾ ರ‍್ಹಯಾತಬಿ ಕ್ರಿಸ್ತಮಾ ಅಪೆ ಕ್ಹಾರಾ ಯಕ್ಕಜ಼ ಅಂಗ ವ್ಹೈ. ಅಪೆ ತೆ ಅಂಗನಾ ಬಿಜಾ಼ ಬಿಜಾ಼ ಭಾಗೊ ಥಯಾಸ. ತೆ ಅಂಗನು ಹರ ಯಕ್ಕ ಭಾಗ ಬಿಜಾ಼ ಭಾಗೊನೆ ಮಳ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ಅಪೆ ಕ್ಹಾರಾ ಬಿಜಾ಼-ಬಿಜಾ಼ ವರಾ ಹೊಂದಿಲಿದ್ಯಾಸ. ಕ್ಹುದಾ ಅಪೊನೆ ದಿದಲ ಕೃಪಾಕ್ಹು ಹರಯಕ್ಕ ವರಾ ಆಯುಸ. ಪ್ರವಾದನೆ ಕರಾನು ವರಾ ವ್ಹಂದಲವಾಲೊ ತಿನೆ ರ‍್ಹವಾನಾ ಬರೊಕ್ಹಾನಾ ಕ್ಹಾತೆ ತೆ ವರಾನೆ ಉಪಯೊಗ ಕರು. ");
INSERT INTO sle_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ಸೆವಾ ಕರಾನಿ ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ಸೆವಾ ಕರಾದೆ. ಶಿಕ್ಕಲಾವಾನಿ ವರಾ ಹೊಂದಿಲಿದಲ ವಾಲೊ ಶಿಕ್ಕಲಾವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ಪ್ರೊತ್ಸಾಹ ಕರಾನಿ ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ಬಿಜಾ಼ವೊನೆ ಪ್ರೊತ್ಸಾಹ ಕರಾದೆ. ವಾಟಿಲಿವಾನೊ ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ಮ್ಹೊಟಾ ಮನಸೆ ದಿವಾದೆ. ಅದಿಕಾರನಿ ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ಅದಿಕಾರಮಾ ರ‍್ಹತಾಮಾ ಮ್ಹೈನತ ಕರಿನ ರಾಬು. ಮರಗಾನು ವರಾ ಹೊಂದಿಲಿದಲವಾಲೊ ಖುಶಿಕ್ಹು ತೆ ಕರಾದೆ ");
INSERT INTO sle_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ತುಮಾರಿ ಮಯಾ ಕಪಟವಾಚಿ ರ‍್ಹವಾದೆ. ಕೆಟ್ಟ ಕಾಮೊನೆ ದ್ವೆಶ ಕರೊ. ಚೊ಼ಕಾ ಕಾಮೊ ಯಕ್ಕಜ಼ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ಕ್ರಿಸ್ತನಾ ಬರೊಕ್ಹಾಮಾ ಭಾಯೊ ಭೆನೊ ಲಿಂಗತ ರ‍್ಹೈನ ಯಕ್ನೆ ಯಕ್ಕ ಮಯಾ ಕರೊ. ತುಮೆ ತುಮಾರಾ ಹುತಿ ಆಸ ಕರಾನಿ ಮರಯಾದಿತಿಬಿ ಘನ್ನಿ ಮರ್ಯಾದಿ ತುಮಾರಾ ಭಾಯೊ ಭೆನೊನೆ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ತುಮೆ ಪ್ರಭುನಾ ಹುತಿ ಸೆವಾ ಕರಾನೆ ಜರುರತ ರ‍್ಹಯಲ ಟೈಮಮಾ ಮೈಗಳ ಥೈನ ರ‍್ಹವೊ ನಕೊ. ಆತ್ಮಿಕನಿ ಖುಶಿಕ್ಹು ತಿನಿ ಸೆವಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ತುಮೊನೆ ನಿರಿಕ್ಷೆ ರ‍್ಹವಾಕ್ಹು ಖುಶಿ ರ‍್ಹವೊ. ತುಮೊನೆ ತ್ರಾಸ ರ‍್ಹತಾಮಾ ತಡ್ದಿಲಿನ ರ‍್ಹವೊ. ಕ್ಹಾರಾ ಟೈಮಮಾ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ಕಮಿಮಾ ರ‍್ಹಯಲ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊನೆ ಮದತ ಕರೊ. ಅತಿಥಿ ಸತ್ಕಾರ ಕರೈಲಿವಾಲಾವೊನೆ ಹುಡಕೊ, ತುಮಾರಾ ಘರೊನೆ ಬಲಾವೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ತುಮೊನೆ ಕೆಟ್ಟ ಕರಾಲಾವೊನೆ ಕ್ಹರಾಪ್ಯಾವಾಚಿ ತ್ಯುನಾ ಹುತಿ ಪ್ರಭು ಕನ ಆಶಿರ್ವಾದ ಮಾಂಗೊ.. ");
INSERT INTO sle_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ಖುಶಿ ಥಾವಾಲಾವೊನಾ ಕ್ಹಾತೆ ಖುಶಿ ಥಾವೊ. ದುಖ ಥಾವಾಲಾವೊನಾ ಕ್ಹಾತೆ ದುಖ ಥಾವೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ತುಮೆ ಯಕ್ಕನೆ ಯಕ್ಕ ಸಮಾಧಾನಕ್ಹು ಮಳಿನ ರ‍್ಹವೊ. ಸೊಕ್ಕಕ ಕರೊ ನಕೊ. ತೆನೈಸೊ ದಿನಕ್ಹು ತೆ ಕಾಮೊ ಕರೊ. ಸಮಾಜಮಾ ಕಿನೆ ನೈ ಚಾ಼ಯೆ ಥಯಲವಾಲಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ದೊಸ್ತಿ ಕರಿನ ರ‍್ಹವಾನೆ ಆಸ ಕರೊ. ತುಮೊನೆ ತುಮೆಜ಼, ಶಾಣ್ಯಾ ವ್ಹೈ ಕೈನ ತಿಳ್ದಿಲಿವೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ಕುನ ತಬಿ ತುಮೊನೆ ಕೆಟ್ಟ ಕರ‍್ಯೊಮ, ತಿನಾ ಲಿಂಗತ ತಿನೆ ಕೆಟ್ಟ ಕರೊ ನಕೊ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ವಿಚಾರ ಕರಾನಾ ಕಾಮೊ ಕರಾನೆ ಕೊಶಿಶ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ಶಾಂತಕ್ಹು ರ‍್ಹವಾನೆ ತುಮೊನೆ ಥಾಯೆ ತೆಕ್ಲು ಕೊಶಿಶ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ಮಾರಾ ಮಯಾನ ದೊಸ್ತೊ, ತುಮೊನೆ ಕೆಟ್ಟ ಕರಾನಾ ಮನಕ್ಹೊನೆ ಬದಲೊ ಲಿವಾನೆ ಕೊಶಿಶ ಕರೊ ನಕೊ. ತೆನೈಸೊ ಕ್ಹುದಾ ತಿನಾ ಶಿಟ್ಟನೆ ವಪ್ಸಿನ ದಿವೊ. ಮಿಜ಼ ಶಿಕ್ಷಾ ದಿವಾಲೊ ವ್ಹೈ. ಮಿಜ಼ ಮನಕ್ಹೊನೆ ಬದ್ಲೊಲಿವಾಲೊ ವ್ಹೈ ವರಿ ಮಿಜ಼ ಪ್ರತಿ ಫಲ ದಿವಾಲೊ ವ್ಹೈ ಕೈನ ಪ್ರಭು ಕವಸ\" ಕೈನ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ತೆನೈಸೊ ಪವಿತ್ರ ಗ್ರಂಥ ಅಮ ಕವಸ. ತುಮಾರೊ ದುಷ್ಮನ ಭುಕ್ಕೊ ಥಯೊಮ, ತಿನೆ ಖಾವಾನೆ ಅನ್ನ ದಿವೊ. ತುಮಾರೊ ದುಶ್ಮನ ಪಾನಿನೊ ತರಕ್ಹೊ ಥಯೊಮ, ತಿನೆ ಪಿವಾನೆ ಪಾನಿ ದಿವೊ. ತುಮೆ ಅಮ ಕರ‍್ಯಾಮ, ತಿನೆ ಸರಮವಾಟಸ\" ");
INSERT INTO sle_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ಕೆಟ್ಟತನಾ ತುಮೊನೆ ಹಾರಾ ಲಗಾಡಾನೆ ಮೌಕೊ ದಿದ್ಯಾವಾಚಿ ಚೊ಼ಕು ಕರ‍್ತಾಜ಼ ಕೆಟ್ಟನೆ ಹಾರಾ ಲಗಾಡೊ. ");
INSERT INTO sle_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ತುಮೆ ಕ್ಹಾರಾ ಅದಿಕಾರಿಯೊನೆ ವಿದೆಯ ಥೈನ ರ‍್ಹೌ. ಕಾಕದ್ಯಾಮ ಕ್ಹುದಾನಿ ಅನುಮತಿ ನೈಸೊ ಕುನ್ನಜ಼ ಅದಿಕಾರಿ ಥಾತೊ ನೈ. ಹರಿ ಯಕ್ಕ ಅದಿಕಾರಿನೆ ಅದಿಕಾರ ದಿದಲ ಕ್ಹುದಾಜ಼ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ತಿನಾಹುತಿ ಅಧಿಕಾರಿಯೊನೆ ವಿರೊದ ಥಯಲ ಮನಕ್ಹ ಕ್ಹರಿಮಾಜ಼ ಕ್ಹುದಾನಿ ಆಗ್ನಾನೆ ವಿರೊದ ವ್ಹೈ. ಅಧಿಕಾರಿಯೊನೆ ವಿರೊದ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ತಿನಾಕ್ಹು ತಿನೆಜ಼ ಶಿಕ್ಷಾ ಲಿದಲ ಲಿಂಗತ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ಚೊ಼ಕು ಕರಾಲಾ ಮನಕ್ಹೊನೆ ಅದಿಕಾರಿಯೊನೊ ಭೆ ರ‍್ಹತೊ ನೈ. ವರಿಬಿ ಕೆಟ್ಟ ಕರಾಲಾ ಮನಕ್ಹೊನೆ ಅದಿಕಾರಿಯೊನೊ ಭೆ ರ‍್ಹವಸ. ತುಮೆ ಅದಿಕಾರಿಯೊನೆ ಭೆ ನೈ ರ‍್ಹಯಲವಾಲಾ ರ‍್ಹೌ ಕೈನ ಆಸ ಕರೊಶಿಸು? ತಿಮ್ಮ ರ‍್ಹಯುಮ ತುಮೆ ಚೊ಼ಕಾ ಕಾಮೊ ಕರೊ. ತೆಳಾಮಾ ಅದಿಕಾರಿಯೊ ತುಮೊನೆ ನೆಣಸಸ. ");
INSERT INTO sle_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ಕಾಕದ್ಯಾಮ ಅದಿಕಾರಿಯೊ ತುಮಾರಾ ಚೊ಼ಕಾನಾ ಹುತಿಜ಼ ನೆಮ್ಸಲ ಕ್ಹುದಾನೊ ಸೆವಕ ವ್ಹೈ. ತೆನೈಸೊ ತುಮೆ ಕೆಟ್ಟಜ಼ ಕರ‍್ಯಾಮ ಭುಚ್ಕುಜ಼. ತುಮೊನೆ ಶಿಕ್ಷಾ ದಿವಾನೆ ತಿನೆ ಅದಿಕಾರ ಛೆ. ತೆ ಅದಿಕಾರ ಉಪಯೊಗ ಕರಸ. ಅದಿಕಾರಿ ಕೆಟ್ಟ ರ‍್ಹಯಲ ಕರಾಲೊ ಮನಕ್ಹೊನೆ ಶಿಕ್ಷಾ ದಿವಾನಾ ಹುತಿ ನೆಮ್ಸಲ ಕ್ಹುದಾನೊ ಸೆವಕ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ತಿನಾಹುತಿ ತುಮೆ ಅಧಿಕಾರಿನೆ ವಿಧೆಯ ಥೌ ತುಮೆ ಶಿಕ್ಷಾನೆ ಗುರಿ ಥೌಸ ಕವಾನು ಕಾರಣ ಕ್ಹು ನೈಸೊ, ತುಮಾರಿ ಮನಸನಿ ಸಾಕ್ಕಷಿಕ್ಹು ತುಮೆ ತ್ಯುನೊನೆ ವಿಧೆಯ ಥೌ. ");
INSERT INTO sle_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ಎ ಕಾರಣಕ್ಹು ತುಮೆ ಭು ಭಾಡೊಬಿ ದಿವೊಸಿ. ತೆ ಅದಿಕಾರಿಯೊ ಕ್ಹುದಾನಾ ಹುತಿ ಕಾಮ ಕರಾಲಾ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ಇಮ್ಮ ರ‍್ಹತಾಮಾ ತುಮೆ ಕಿನೆ-ಕಿನೆ ಸು-ಸು ದ್ಯು ತೆ ಕ್ಹಾರು ತ್ಯುನೊನೆ ದಿವೊ. ಕಯೊ ಭಾಡೊ ರ‍್ಹವಾದೆ ದಿವಾನು ರ‍್ಹಯುಮ ತೆ ದಿಪಾಡೊ. ಕಿನೆ ಮರ್ಯಾದಿ ದ್ಯು ತ್ಯುನೊನೆ ಮರ್ಯಾದಿ ದಿವೊ ಕಿನೆ ಇಜ್ಜತ ದ್ಯು ತಿನೆ ಇಜ್ಜತ ದಿವೊ. ");
INSERT INTO sle_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ಮನಕ್ಹೊನೆ ಕೈ ವಿಷಯಮಾಜ಼ ಸಾಲಾಮಾ ರ‍್ಹವೊನಕೊ. ತೆನೈಸೊ ಯಕ್ಲಾನೆ ಯಕ್ಲೊ ಮಯಾ ಕರು ಕವಾನು ವಿಷಯಮಾ ಯಕ್ಕಜ಼ಮಾ ಸಲಾವಾಲಾ ಥಯಾಸ. ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಮಯಾ ಕರಾಲೊ ಮನಕ್ಹ ಇಡಿ ಧರಮಶಾಸ್ತ್ರನೆ ವಿಧೆಯ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ಕಾಕದ್ಯಾಮ \"ವ್ಯಭಿಚಾರ ಕರು ನೈ, ಖಲಾಸ ಕರುನೈ, ಚೊ಼ರಿ ಕರು ನೈ, ಬಿಜಾ಼ವೊನು ಸಾಮನ್ನೆ ಆಸ ಕರು ನೈ \"ಕೈನ ಧರಮಶಾಸ್ತ್ರ ಕವಸ. ಎ ಆಗನ್ಯಾ ಪೈಲಾ ಉಗ್ರಲ ಕ್ಹಾರಿಯೊ ಆಗನ್ಯಾ\"ತುನೆ ತು ಮಯಾ ಕರಲಲಿಂಗತ ಬಾಜು಼ವಾಲಾ ಮನಕ್ಹೊನೆ ಮಯಾ ಕರ \"ಕವಾನು ಯಕ್ಕಜ಼ ಆಗನ್ಯಾಮಾ ದಡಿ ರ‍್ಹಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ಮಯಾ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಕೆಟ್ಟ ಕರತು ನೈ. ತಿನಾಹುತಿ ಮಯಾ ಕರಾನೆಬಿ ಕ್ಹಾರಿ ಆಗನ್ಯಾವೊನೆ ವಿಧೆಯ ಥಾವಾನೆ ಸುಜ಼ ಫರಕ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ಹಮೆ ಕರೆಟ್ಟ ಟೈಮ್ಮಾ ಜಿವ್ನಾ ಕರತಾ ರ‍್ಹಯಲ ಹುತಿ ಎ ಕ್ಹಾರು ಕವಾಡ್ಯೊಸ ಕವಾನು ತುಮೊನೆ ಗ್ವತ್ತ ಛೆ. ಹೊ, ತುಮೆ ಹುಷಾರ ರ‍್ಹವಾನು ಟೈಮ ಎ ವ್ಹೈ. ಅಪೆ ವಿಷ್ವಾಶಿಯೊ ಥಯಲ ಟೈಮ್ತಾಬಿ ಹಮ್ನಾ ಅಪ್ನಿ ರಕ್ಷಣೆ ನಜಿಕ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ರಾತ ಕ್ಹಾರಿ ಮುಗ್ದಿ ಗೈಸ. ದಿನ್ನ ನಜಿಕ ಅಯೊಸ. ತಿನಾಹುತಿ ರಾತನಾ ಕರಾನಾ ಕಾಮೊ ಕರಾನು ಛೊಡಿನ ದಿನ್ಮಾ ಕರಾನಾ ಕಮೊ ಕರಾನೆ ತುಮೆ ಆಯುಧೊ ಘಾಲ್ಲಿನ ಯುದ್ದನೆ ತಯ್ಯಾರ ಥಾವೊ. ");
INSERT INTO sle_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ದಿನ್ಮಾ ರ‍್ಹವಾನಾ ಮನಕ್ಹೊ ಲಿಂಗತ ಚೊ಼ಕಿತರಾ ಜಿವ್ನಾ ಕರಿಯೆ. ಕೆಟ್ಟ ರ‍್ಹಯಲ ವರಿ ವ್ಯರ್ಥ ರ‍್ಹಯಲ ಔತಣೊ ಅಪೆ ತಯ್ಯಾರ ಕರು ನೈ; ಪಿನ ನಿಷಾಮಾ ರ‍್ಹೌ ನೈ; ಅಪೆ ಲೈಂಗಿಕ ಪಾಪೊ ರ‍್ಹೈನೆಕಾ ವರಿ ಸರಮಾವಾನಾ ಕಾಮೊ ಕಯಾಜ಼ ಕರು ನೈ. ವಾದ ವಿವಾದ ರ‍್ಹೈನೆಕಾ ವರಿ ಲಡೈ ಲಗಾಡು ನೈ; ವರಿ ಸಂಗಟ ಘಾಲ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ತೆನೈಸೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನೆ ಆಯುದ್ಧ ಲಿಂಗತ ಭಾಂದಿಲ್ಯು, ತುಮಾರು ಪಾಪನು ಸ್ವಭಾವೊ ಕಿಮ ತೃಪ್ತ ಕರಿಲಿಯೆ ಕೈನ ಕೆಟ್ಟ ಕಾಮೊ ಕರಿಯೆ ಕವಾನು ಆಸ ಕಿಮ ಪುರಾ ಕರಿಯೆ ಕೈನ ವಿಚಾರ ಕರಾನು ಬಂದ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ಬರೊಕ್ಹಾಮಾ ಕಮ್ಜೊ಼ರ ರ‍್ಹಯಲ ಮನಕ್ಹನೆ ತುಮಾರಾ ಕ್ಹಾತೆ ಮಳೈ ಲಿವೊ ತಿವ್ನಾ ಸ್ವಂತ ವಿಷಯಮಾ ತಿನಾ ಕ್ಹಾತೆ ವಾಗ್ವಾದ ಕರೊ ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ಯಕ್ಲೊ ಕೈ ತರಾನಿ ಅನ್ನ ಖೌ ಕೈನ ವಿಚಾರ ಕರಸ. ತೆನೈಸೊ ಬರೊಕ್ಹಾಮಾ ಬಲಹಿನ ರ‍್ಹಯಲ ಮನಕ್ಹ ತೆ ತರಕಾರಿಯೊ ಯಕ್ಕಜ಼ ಖೌ ಕೈನ ವಿಚಾರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ಕೈ ತರಾನು ಅನ್ನ ಖೌ ಕೈನ ಬರೊಕ್ಹೊ ಕರಾನೊ ಮನಕ್ಹ ತರಕಾರಿ ಯಕ್ಕಜ಼ ಖಾವಾಲಾ ಮನಕ್ಹನೊ ಫೈಸಲೊ ಕರು ನೈ. ತಿನಾಲಿಂಗತಜ಼ ತರಕಾರಿಯೊ ಯಕ್ಕಜ಼ ಖಾವಾಲೊ ಮನಕ್ಹ ಕ್ಹಾರು ತರಾನು ಅನ್ನ ಖಾವಾಲೊ ಮನಕ್ಹನೆ ತಪ್ಪ ಕರ‍್ಯೊಸ ಕೈನ ಫೈಸಲೊ ಕರು ನೈ. ಕ್ಹುದಾ ತೆ ಮನಕ್ಹನೆ ವಪ್ಪಿಲಿದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ತು ಬಿಜೆ಼ಕ್ಕಲಾ ಮನಕ್ಹನಾ ಸೆವಕನೆ ಫೈಸಲೊ ಕರಾಲೊ ತು ಕುನ ವ್ಹೈ? ತೆ ಕರತೊ ರ‍್ಹಯಲ ಚೊ಼ಕು ವ್ಹೈಸು ನೈತೊ ಕೆಟ್ಟ ವ್ಹೈಸು ಕವಾನು ತಿನೊ ಸ್ವಂತ ಮಾಲಕಜ಼ ಫೈಸಲೊ ಕರಸ. ವರಿ ತ್ಯುನೆ ಕರೆಟ್ಟಜ಼ ರ‍್ಹವಸ, ಕಾಕದ್ಯಾಮ ಪ್ರಭು ತ್ಯುನೊನೆ ಸಫಲ ಕರಾನೆ ಶಕ್ತ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ಯಕ್ಲೊ ಯಕ್ಕ ದಿನ್ನನೆ ಕ್ಹಾರಾ ದಿನ್ನೊತಿಬಿ ಘನ್ನೊ ಖಾಸ ವ್ಹೈ ಕೈನ ಬರೊಕ್ಹೊ ಕರ ಸಕಸ. ವರಿಬಿ ಬಿಜೆಕಲೊ ಕ್ಹಾರಾ ಯಕ್ಕಜ಼ ದಿನೊ ವ್ಹೈ ಕೈನ ಬರೊಕ್ಹೊ ಕರಸ. ಹರಿ ಯಕ್ಕ ಮನಕ್ಹ ತಿನಾ ಸ್ವಂತ ಮನಸ್ಮಾ ರ‍್ಹಯಲ ತಿನಿ ಸ್ವಂತ ಬರೊಕ್ಹಾನಾ ಹುತಿ ಫೈಸಲೊ ಕರಿನ ರ‍್ಹೌ. ");
INSERT INTO sle_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ಕಯೊ ಮನಕ್ಹ ಬಿಜಾ಼ ದಿನ್ನೊತಿ ಯಕ್ಕ ದಿನ್ನ ಖಾಸ ವ್ಹೈ ಕೈನ ವಿಚಾರ ಕರಾಲೊ ಮನಕ್ಹ ಪ್ರಭುನೆ ಸನ್ಮಾನ ದಿವಾನಾ ಹುತಿ ಕರಾಲೊ ಥಯೊಸ. ತಿನಾ ಲಿಂಗತಜ಼ ಕ್ಹಾರಿ ತರಾಕ್ಹು ಅನ್ನ ಖಾವಾಲೊ ಮನಕ್ಹ ಪ್ರಭುನೆ ಸನ್ಮಾನ ದಿವಾನೆ ತೆ ಕ್ಹಾರು ಖಾವಸ. ಹೊ, ತೆ ತೆ ಅನ್ನನಾ ಹುತಿ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರಸ. ವರಿ ಕುನ ತರಕಾರಿಯೊ ಖಾವಸ ತೆಬಿ ಪ್ರಭುನೆ ಸನ್ಮಾನ ದಿನಾನೆಜ಼ ತಿಮ್ಮ ಕರಸ. ತೆಬಿ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರಾಲೊ ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ಅಪ್ನೊಮಾ ಕುನ್ನಬಿ ಅಪ್ನಾ ಹುತಿ ಜಿವ್ನಾ ನೈ ಕರ‍್ತಾ ವರಿ ಅಪೆ ಅಪ್ನಾ ಹುತಿಜ಼ ನೈ ಮರ‍್ತಾ. ");
INSERT INTO sle_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ಅಪೆ ಜಿವ್ತಾ ರ‍್ಹವಾನು ರ‍್ಹಯುಮ, ಪ್ರಭುನಾ ಹುತಿಜ಼ ಜಿವ್ತಾ ರ‍್ಹಯೆಸ; ಮರವಾನು ರ‍್ಹಯುಮ ಪ್ರಭುನಾ ಹುತಿಜ಼ ವ್ಹೈ. ತಿನಾಹುತಿ ಅಪೆ ಜಿವ್ತಾ ರ‍್ಹವಾನು ವರಿ ಮರಾನು ರ‍್ಹಯುಮ ಪ್ರಭುನಾಜ಼ ಹುತಿ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ತಿನಾಹುತಿ ವರಿ ಜಿವ್ನಾ ಕರಾನೆ ಕ್ರಿಸ್ತ ಮರಿನ ಮಜಾ಼ರೊಮಾತೊ ಜಿವ್ತೊ ಥೈ ಆಯೊ. ಮರಿಗಯಲ ಮನಕ್ಹೊನೆ ವರಿ ಜಿವ್ತಾ ರ‍್ಹಯಲ ಮನಕ್ಹೊನಾ ಹುತಿ ತೆ ಪ್ರಭು ವ್ಹೈ ಕೈನ ದೆಕಾಡಿನ ದಿದ್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ಇಮ್ಮ ರ‍್ಹತಾಮಾ, ಕ್ರಿಸ್ತಮಾ ತಾರೊ ಭೈ ಥಯಲ ತು ಕೆಟ್ಟ ವ್ಹೈ ಕವಾನು ಕಾ? ತು ತಾರಾ ಭೈ ತಿಬಿ ಚೊ಼ಕೊ ಛೆ ಕೈನ ಕೈಲಿವಾನು ಕಾ? ಅಪೆ ಕ್ಹಾರಾ ಕ್ಹುದಾನಾ ಕ್ಹಾಮಾ ಹುಬ್ರೈಯೆಸ. ತೆಳಾಮಾ ತೆ ಅಪೊನೆ ಫೈಸಲೊ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ಹೊ, ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಇಮ್ಮ ಬರ್ದ್ಯಾಸ; ಹರಿ ಯಕ್ಲೊ ಮನೆ ಪಗೆ ಪಡಸ. ಹರಿ ಯಕ್ಲೊ ಮನೆ ಕ್ಹುದಾ ವ್ಹೈ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ತಿನಾಹುತಿ ಅಪ್ನೊಮಾ ಹರಿ ಯಕ್ಲೊ ತ್ಯುನಿ-ತ್ಯುನಿ ಜಿವಿತನಾ ಹುತಿ ಕ್ಹುದಾಕನ ಲೆಕ್ಯೊದ್ಯು. ");
INSERT INTO sle_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ತಿನಾಹುತಿ, ಅಪೆ ಯಕ್ನಾ ಯಕ್ಕ ಫೈಸಲೊ ಕರಾನು ಛೊಡಿಪಾಡು. ಅಪ್ನೊ ಭೈಯೊನೆ ವರಿ ಭೆನೊನೆ ರ‍್ಹೈನೆಕಾ ಕಮ್ಜೊ಼ರ ಕರಾನು ವರಿ ಪಾಪ ಕರಾನೆ ಕಯುಜ಼ ನೈ ಕರಾನೆ ಅಪೆ ಫೈಸಲೊ ಕರು. ");
INSERT INTO sle_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ಮಿ ಪ್ರಭು ಥಯಲ ಯೆಸುಮಾ ಛೆ. ಕಯುಬಿ ಅನ್ನ ಪದಾರ್ಥನೆ ರ‍್ಹೈನೆಕಾ ಖಾವಾನು ತಪ್ಪ ನ್ಹವೈ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ಯಕ್ಲೊ ಕಯುಬಿ ಅನ್ನ ಖಾವಾನು ತಪ್ಪ ವ್ಹೈ ಕೈನ ನಂಬ್ಯಾಮ, ತೆ ಅನ್ನ ತಿನೆ ಅಶುದ್ಧಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ತು ಖಾವಾನಿ ಅನ್ನಕ್ಹು ತಾರಾ ಭೈ ಬರೊಕ್ಹೊನಾ ತು ತ್ರಾಸ ಕರತೊ ರ‍್ಹಯೊಮ, ತು ಮಯಾ ಕರಾನಿ ವಾಟ್ಮಾ ಕ್ಹರಿಮಾಜ಼ ಚಾ಼ಲಾಡ್ಯೊ ನತ್ತಿ. ಯಕ್ಲೊ ಕಯುಬಿ ಖಾವಾನಾ ಅನ್ನನೆ ತಪ್ಪ ವ್ಹೈ ಕೈನ ಕೈ ಲಿದ್ಯೊಮ, ತು ತೆ ಅನ್ನನೆ ಖಾದ್ಯೊಮ ತಿನೊ ಬರೊಕ್ಹೊ ಪಡಿ ಜಾ಼ವಸ. ತಿನಾಹುತಿ ತು ತಿಮ್ಮ ಕರು ನೈ. ಕ್ರಿಸ್ತ ತೆ ಮನಕ್ಹನಾ ಹುತಿ ಮರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ತು ಕಯೊ ಚೊ಼ಕು ವ್ಹೈ ವಿಚಾರ ಕರ‍ಶಿಸು ತೆ ಬಿಜಾ಼ವೊನೆ ಕೆಟ್ಟ ವ್ಹೈ ಕೈನ ಕೈಲಿವಾನೆ ದ್ಯು ನಕೊ. ");
INSERT INTO sle_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ತೆ ನೈಸು ಕ್ಹುದಾನಿ ರಾಜ್ಯಮಾ ಖಾವಾನು ರ‍್ಹೈನೆಕಾ ಪಿವಾನು ರ‍್ಹೈನೆಕಾ ಖಾಸ ನ್ಹವೈ. ನಿತಿ ಸಮಾಧಾನ ಪವಿತ್ರ ಆತ್ಮಾನು ಥಾವಾನಿ ಖುಶಿ ತ್ಯಾ ಖಾಸ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ಎ ತರಾಮಾ ಕ್ರಿಸ್ತನಿ ಸೆವೆ ಕರಾಲೊ ಕ್ಹುದಾನೆ ಖುಶಿ ಕರಾಲೊ ವ್ಹೈ. ಮನಕ್ಹೊ ತಿನೆ ಮಳೈ ಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ತಿನಾಹುತಿ ಸಮಾದಾನ ಕರಾನಾ ಕಾಮೊ ಅಪ್ನಾ ಹತೆ ಥಾವಾನು ತೆಕ್ಲು ಕೊಶಿಶ ಕರಿಯೆ. ");
INSERT INTO sle_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ಕ್ಹುದಾನು ಕಾಮ ಅನ್ನಾ ಹುತಿ ಹಾಳ ಕರಾನೆ ದಿವೊ ನಕೊ. ಕ್ಹಾರು ಖಾವಾನು ಅನ್ನ ಚೊ಼ಕುಜ಼ ವ್ಹೈ. ವರಿ ಖಾವಾನೆ ಯೊಗೈ ವ್ಹೈ. ತೆನೈಸೊ ಯಕ್ಲೊ ತೆ ಖಾವಾನು ಅನ್ನನಾ ಮುಲಕ ಬಿಜಕ್ಲಾನೆ ಪಾಪಮಾ ಪಾಡಾನು ರ‍್ಹಯುಮ, ತೆ ಅನ್ನ ಖಾವಾನು ತಪ್ಪ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ತು ಮಾಕ್ಹ ಖಾವಾನು ವರಿ ದ್ರಾಕ್ಷಾರಸ ಪಿವಾನು, ದ್ರಾಕ್ಷಾರಸ ಪಿದ್ಯಾವಾಚಿ ರ‍್ಹವಾನು ಚೊ಼ಕು ವ್ಹೈ. ಬರೊಕ್ಹಾ ರ‍್ಹಯಲ ತಾರಾ ಭೈನೆ ರ‍್ಹೈನೆಕಾ ಭೆನ್ನೆ ರ‍್ಹೈನೆಕಾ ಪಾಪಮಾ ಪಾಡ್ಯಾವಾಚಿ ರ‍್ಹವಾನು ಚೊ಼ಕು ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ಎ ಸಂಗತಿಯೊ ಯೊನಾ ಹುತಿ ತುನೆ ರ‍್ಹಯಲ ವಿಶ್ವಾಸ ತುನೆ ವರಿ ಕ್ಹುದಾನೆ ಯಕ್ಕಜ಼ ಗ್ವತ್ತ ರ‍್ಹವಾದೆ. ತಿನೆ ಚೊ಼ಕು ವ್ಹೈ ಕೈನ ತಿಳದಲ ಕಾಮೊ ತೆ ದೊಶಿ ಥೌಸ ಕೈನ ಸಂಶೊ ನೈಸೊ ಕರಾಲೊ ನಷಿಬವಾಲೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ತೆನೈಸೊ ಯಕ್ಲೊ ತೆ ಖಾವಾನು ಅನ್ನ ದೊಶ ನತ್ತಿ ಕೈನ ಸಂಶೊ ಮ್ಹೆಲ್ಲಿನ ಖಾದ್ಯೊಮ, ತಿನಾಕ್ಹು ತಿನೆಜ಼ ತಪ್ಪ ಕರಾಲೊ ವ್ಹೈ ಕೈನ ಕವೈ ಲಿವಸ ಕಾಕದ್ಯಾಮ ತೆ ದೊಶ ನತ್ತಿ ಕವಾನೊ ಬರೊಕ್ಹೊ ತಿಕನ ನತ್ತಿ. ಬರೊಕ್ಹೊನಾ ಆದಾರ ನತ್ತಿ ಕೈನ ಕರಾನುಜ಼ ಪಾಪ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ತಿನಾಹುತಿ ಬರೊಕ್ಹಾಮಾ ಕಮಿ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಕಮಜೊ಼ರ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಅಪೆ ತಡ್ದಿಲ್ಯು. ಅಪೆ ಕ್ಹಾಲಿ ಅಪ್ನು ಯಕ್ಕಜ಼ ಚೊ಼ಕು ದೆಕಿಲ್ಯು ನೈ. ");
INSERT INTO sle_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ಅಪ್ನೊಮಾ ಹರಿ ಯಕ್ಲೊ ತಿನಾ ಆಜು಼ ಬಾಜು಼ ವಾಲವೊನಾ ಹುತಿ ಚೊ಼ಕಾನಾ ಹುತಿ ಬಯಸ್ತಾ ರ‍್ಹೌ. ಬರೊಕ್ಹಾಮಾ ಕಮಿ ರ‍್ಹಯಲ ವಾಲಾವೊನೆ ಹೆಚ್ಕಿ಼ ಬರೊಕ್ಹಾಮಾ ಘಟ್ಟ ರ‍್ಹವಾನೆ ಮದದ ಕರು. ");
INSERT INTO sle_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ಕಾಕದ್ಯಾಮ ಕ್ರಿಸ್ತಬಿ ತಿನಾ ಜ಼ಲಮ್ಮಾ ತಿನಿ ಜಿವಿತನಾ ಹುತಿ ವಿಚಾರ ಕರ‍್ಯೊ ನೈ\" ತುನೆ ಮರ್ಯಾದಿ ಕಾಡಲ ಮನಕ್ಹೊ ಮನೆ ಬಿ ಮರ್ಯಾದಿ ಕಾಡ್ಯಾ\" ಕವಾನಾ ಹುತಿ ತಿನಾ ಹುತಿ ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಬರ್ದಲ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ಪಾಚಾಲ್ಯಾ ದಿನೊಮಾ ಬರ್ದಲ ಹರಿ ಯಕ್ಕ ಅಪ್ನಾ ಹುತಿಜ಼ ಬರ್ದಲ ಛೆ. ಅಪೆ ಕೈದಾಲಾ ರ‍್ಹೌ ಕೈನ ಎ ಸಂಗತಿಯೊ ಬರ್ದಲ ಛೆ. ಪವಿತ್ರ ಗ್ರಂಥ ಅಪೊನೆ ದಿವಾನೆ ತಡ್ದಿಲಿವಾನು ವರಿ ಕೈದಾನು ಎ ಉತ್ಸಾಹ ಆವಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ತಡ್ದಿಲಿವಾನು ವರಿ ಉತ್ಸಾಹ ಕ್ಹುದಾಜ಼ ದಿದಲ ರ‍್ಹವಸ. ಕ್ರಿಸ್ತ ಯೆಸು ಆಸ ಕರಲ ವಾಟ ತುಮೆ ಕ್ಹಾರಾ ವಪ್ಪಿಲ್ಯು. ಕ್ಹುದಾ ತುಮೊನೆ ಮದದ ಕರಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ಇಮ್ಮ ಕ್ಹಾರಾ ತುಮೆ ಯಕ್ಕಜ಼ ಮನಸಕ್ಹು ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನೊ ಬಾ ಥಯಲ ಕ್ಹುದಾನಿ ಮಹಿಮಾ ಕರುಸಿ. ");
INSERT INTO sle_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ಕ್ರಿಸ್ತ ತುಮೊನೆ ಮಳೈ ಲಿದ್ಯೊ. ತಿನಾಹುತಿ ತುಮೆ ಯಕ್ನಾ ಯಕ್ಕ ಮಳೈಲ್ಯು ಎ ಕ್ಹುದಾನೆ ಮಹಿಮಾ ಕರಾಲ ಲಿಂಗತ ಥಾವಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ಕ್ಹುದಾ ಅಪ್ನಾ ಪಿತೃವೊನೆ ದಿದಲ ವಾತ ಕ್ಹರಿನಿಯೊ ವ್ಹೈ ಕೈನ ದೆಕಾಡಾನಾ ಹುತಿ ಕ್ಹುದಾ ತೆ ವಾತೊ ಪುರಾ ಕರಸ ಕೈನ ಕವಾನು ದೆಕಾಡಾನಾ ಹುತಿ ");
INSERT INTO sle_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ಕ್ಹುದಾ ತ್ಯುನೊನೆ ದೆಕಾಡಾನಿ ಮರಗಾನಾ ಹುತಿ ಕ್ಹಾರಾ ಯೆಹುದಿಯೊತಿನೆ ಮಹಿಮಾ ಕರಾದೆ ಕೈನ ಕ್ರಿಸ್ತ ಯಹುದ್ಯೊನೊ ಸೆವಕ ಥಯೊ. ಪವಿತ್ರ ಗ್ರಂಥಮಾ ಇಮ್ಮ ಬರ್ದ್ಯಾಸ; \"ತಿನಾಹುತಿ ಯಹುದ್ಯೊ ನೈಸೊವಾಲಾವೊನಾ ವಚ್ಮಾ಼ ಮಿ ತುನೆ ಸ್ತುತಿ ಕರುಸ. ಮಿ ತಾರು ನಾಮ ಉಚ್ಚು಼ ಕರುಸ\" ");
INSERT INTO sle_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ಎನೈಸೊ ಪವಿತ್ರ ಗ್ರಂಥ ಅಮ್ಮ ಕವಸ; \"ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ತುಮೆ ಕ್ಹುದಾನಾ ಖಾಸ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ತುಮೆ ಮಳಿನ ಖುಶಿ ಥಾವೊ! ");
INSERT INTO sle_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ಬಿಜೆಕ ಜ಼ಗಾ ಪವಿತ್ರ ಗ್ರಂಥ ಅಮ್ಮ ಕವಸ; \"ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲವಾಲಾ ತುಮೆ ಕ್ಹಾರಾ ಪ್ರಭುನೆ ಸ್ತುತಿ ಕರೊ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಪ್ರಭುನೆ ಸ್ತೊತ್ರಾ ಕವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ವರಿ ಯೆಶಾಯಾ ಅಮ್ಮ ಕದ್ಯೊಸ; ಇಷಯನ್ನಾ ಖಾಂದಾನಮಾ ಯಕ್ಕ ಮನಕ್ಹ ಆವಸ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಆಳಾನೆ ಆವಸ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊ ತಿಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ಆಸ ದಿವಾಲೊ ಕ್ಹುದಾ ಬರೊಕ್ಹಾಕ್ಹು ಥಾವಾನಿ ಖುಶಿ ಸಮಾಧಾನ ಪುರಾ ದಿವಾದೆ ಕೈನ ತೆಳಾಮಾ ಪವಿತ್ರ ಆತ್ಮಾನಿ ತಾಕತಕ್ಹು ತುಮೊಮಾ ಭರಾದೆ ");
INSERT INTO sle_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ಮಾರಾ ಭಾಯೊ ಭೆನೊ, ತುಮೊಮಾ ಚೊ಼ಕೊಜ಼ ಭರ‍್ಯುಸ ಕೈನ ಮನೆ ಕ್ಹರಿಮಾಜ಼ ಗ್ವತ್ತ ಛೆ. ಚಾ಼ಯೆ ಥಯಲ ಕ್ಹಾರುಜ಼ ಗ್ಯಾನ ತುಮೊನೆ ಛೆ ಕೈನ ವರಿ ಯಕ್ನಾ ಯಕ್ಕ ಸಲಹೆ ದಿವೊಸಿ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ತುಮೆ ಶೆ ಮ್ಹೆಲ್ಲಿವೊ ಕೈನ ಮಿ ಆಸ ಕರಲ ದಕ್ಹಿಯೊ ಸಂಗತಿಯೊ ತುಮೊನೆ ಧೈರ್ಯ ಕರಿನ ಬರ್ದ್ಯೊಸ. ಯೆಸು ಕ್ರಿಸ್ತನೊ ಸೆವಕ ವ್ಹೈ ಕೈನ ಖಾಸ ರ‍್ಹಯಲ ವರಾ ಮನೆ ಕ್ಹುದಾ ದಿದಲ ಹುತಿ ಮಿ ಇಮ್ಮ ಬರ್ದ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ಯಹುದಿ ನೈ ರ‍್ಹಯಲ ಪವಿತ್ರ ಆತ್ಮಾನಾ ಮುಲಕ ಪವಿತ್ರ ಥಯಾ. ಮನಕ್ಹೊನೆ ಮದದ ಕರಾನಾ ಹುತಿ ಕ್ಹುದಾ ಮನೆ ಯಾಜಕನಿ ಸೆವಾ ವ್ಹೈ ಕೈ ಕರಲ್ದಯ. ಕ್ಹುದಾನೆ ಸುವಾರ್ತೆ ಕೈನ ಉಪದೆಶ ಕರಿನ ಮಿ ತಿನೆ ಸೆವಕ ಥಾವಾ ವರಕ್ಹು ಕರ‍್ಯೊ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ಕ್ಹುದಾಕನ ಔ ಕೈನ ಮಿ ಸೆವೆ ಕರಾ ವರಕ್ಹು ಥಯೊ. ತೆ ಮನಕ್ಹೊ ಕ್ಹುದಾನಾ ಹುತಿ ");
INSERT INTO sle_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ತಿನಾಹುತಿ ಕ್ರಿಸ್ತ ಯೆಸುನೆ ಮಿ ಕ್ಹುದಾನಾ ಹುತಿ ಕರಾನಾ ಕವಾನಾ ಹುತಿ ಮಿ ಹೆಮ್ಮೆ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ಮಿ ಮಾರಾ ಸ್ವಂತ ಕಾಮೊನಾ ಹುತಿ ಬೊಲ್ತೊ ನೈ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಮನಕ್ಹೊನೆ ತಿನೆ ವಧೆಯ ಕರಿಲಿವಾನಾ ಹುತಿ ಕ್ರಿಸ್ತ ಮಾರಾ ಮುಕಾಂತರ ವಾತೊಕ್ಹು ಕರಲ ಕಾಮೊ ಕೈಲ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ಅದ್ಭುತ ಕಾಮೊ ಕರಾನಿ ತಾಕತ ವರಿ ಮ್ಹೊಟಾ ಕಾಮೊ ದೆಕಲ ಹುತಿ ಕ್ಹುದಾನಿ ಆತ್ಮಾನಿ ತಾಕತಕ್ಹುಜ಼ ಮಾರು ಕಾಮ ಪುರಾ. ಮಿ ಜೆರುಸೆಲಿಮತೊ ಇಲ್ಲುರಿನೆ ಪ್ರಾಂತ್ಯ ಲಕ್ಕಾ ಕ್ರಿಸ್ತನಿ ಸುವಾರ್ತೆ ಕೈನ, ಮಿ ತೆ ಕರ್ತವ್ಯ ಪುರಾ ಕರ‍್ಯೊ. ");
INSERT INTO sle_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ಕ್ರಿಸ್ತನಾ ಹುತಿ ಮನಕ್ಹೊ ನೈ ಐಕಲ ಜ಼ಗಾವೊಪರ ಮಿ ಸುವಾರ್ತೆ ಕವಾನೆ ಹಮೆಶಾ ಮಿ ಆಸ ಕರುಸ. ಕಾಕದ್ಯಾಮ ಯಕ್ಲೊ ಶುರು ಕರಲ ಕಾಮಪರ ಮಿ ತೆ ಕಾಮ ಕರಾನೆ ಮನಸ ನತ್ತಿ. ");
INSERT INTO sle_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ತೆನೈಸೊ ಪವಿತ್ರ ಗ್ರಂಥ ಎಬಿ ಬರ್ದ್ಯಾಸ. ತಿನಾ ಹುತಿ ನೈ ಕೈಳೈ ಲಿದಲ ಮನಕ್ಹೊ ತಿನೆ ದೆಕಸ. ತಿನಾ ಹುತಿ ನೈ ಐಕಲ ಮನಕ್ಹೊ ತಿನೆ ತಿಳ್ದಿಲಿವಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ಇನಾ ಹುತಿಜ಼, ತುಮೊಕನ ಮನೆ ಆವಾನೆ ಘನ್ನಿ ಸಲಾ ಅಡ್ಚನ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ತೆನೈಸೊ ಎ ಪ್ರಾಂತ್ಯಮಾ ಕರಾನಿ ಸೆವೆ ಮಿ ಕರಿನ ಮುಗಷ್ಯೊ. ವರಿ ಘನ್ನಾ ವರಕ್ಹತೊ ಮಿ ತುಮೊಕನ ಔ ಕೈನ ಕೈಲಿದ್ಯೊತೊ. ");
INSERT INTO sle_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ತಿನಾ ಹುತಿ ಮಿ ಸ್ಪೆನ ದೆಶೆ ಜಾ಼ತಾಮಾ ತುಮೊನೆ ಮಳುಸ, ದಕ್ಹಿಯೆಳ ತುಮಾರಾ ಕ್ಹಾತೆ ಖುಶಿಕ್ಹು ರ‍್ಹೌಸ ಕವಾನು ಆಸ ಮನೆ ಛೆ. ಪಾಚಾ಼ತಾ ತುಮೆ ಮಾರಾ ಪ್ರಯಾಣನೆ ಆಸ್ರೊ ಕರೊಶಿ ಕೈನ ಆಸ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ಮಿ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊನೆ ಸೆವಾ ಕರಾನಾ ಹುತಿ ಜೆರುಸಲೆಮೆ ಚಾ಼ಲ್ಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ಕಾಕದ್ಯಾಮ ಯೆರುಸೆಲಮಾ ರ‍್ಹವಾನಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊಮಾ ಗರಿಬೊನಾ ಹುತಿ ದೊಕಡಾನಾ ಹುತಿ ಮದತ ಕರೊ ಕೈನ ಮೆಕೆದೊನಿ ವರಿ ಅಖಾಯನಾ ಮನಕ್ಹೊ ಆಸ ಕರ‍್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ಮೆಕೆದೊನಿಯಾ ವರಿ ಅಖಾಯಾಮಾ ರ‍್ಹಯಲ ವಿಸ್ವಾಸಿಯೊ ತ್ಯಾನಾ ಗರಿಬ ಮನಕ್ಹೊನೆ ಕ್ಹುಶಿಕ್ಹು ದೊಕ್ಡಾವೊಕ್ಹು ಸಹಾಯಾ ಕರ‍್ಯಾಸ. ಮೆಕೆದೊನಿಮಾನಾ ವರಿ ಅಖಾಯಾಮಾನಾ ವಿಶ್ವಾಸಿಯೊ ತ್ಯುನಾ ಮನ್ಸೆಜ಼ ಎ ಕಾಮೊ ಕರ‍್ಯಾ. ತೆ ತ್ಯುನು ಕರ್ತವ್ಯ ವ್ಹೈ. ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ತ್ಯುನೆ ಆತ್ಮಿಕಾಮನಾ ರ‍್ಹಯಲ ಆಶಿರ್ವಾದೊ ಪಾಲ ಹೊಂದಿಲಿದಲ ಹುತಿ ತ್ಯುನೆ ತ್ಯುನೊಕನ ರ‍್ಹಯಲ್ಮಾ ದಿನ್ನ ತ್ಯುನೆ ತೆ ಆಶಿರ್ವಾದೊ ಹೊಂದಿಲಿದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ಜೆರುಸೆಲಿಮಾ ರ‍್ಹಯಲ ಗರಿಬ ಮನಕ್ಹೊನೆ ದಿವಾನಾ ದೊಕ್ಡಾ ಎ ಕ್ಹಾರಾ ದೊಕ್ಡಾ ತ್ಯುನೊನೆ ದಿದಲ್ಪರ ಮಿ ಸ್ಪೆನೆ ಔಸ. ಮಿ ಸ್ಪೆನೆ ಆತಾಮಾ ರೊಮಾಮಾ ರ‍್ಹೈನ ಮಿ ತುಮೊನೆ ಕೈನ ಮೊಕ್ಕಲುಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ಮಿ ತುಮೊಕನ ಆತಾಮಾ ಕ್ರಿಸ್ತನಾ ಘನ್ನಾ ಆಶಿರ್ವಾದ ಲೌಸ ಕೈನ ಮನೆ ಆಸ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ಭಾಯೊ ಭೆನೊ, ತುಮೆ ಮಾರಾ ಹುತಿ ಪ್ರಾಥಾನಾ ಕರಾನಾ ಮುಲಕ ಮನೆ ಮಿ ಸೆವೆ ಕರೊ ಕೈನ ಮಿ ತುಮೊಕನ ಮಾಂಗಿಲ್ಯುಸ. ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಿ ವರಿ ಪವಿತ್ರ ಆತ್ಮಾ ದಿವಾನಿ ಮಯಾ ಕ್ಹು ಪ್ರಾಥನಾ ಕರೊ. ಜುದೆಯಮಾ ರ‍್ಹಯಲ ಅವಿಶ್ವಾಸಿಯೊನಾ ಹತೆ ಮಿ ಚು಼ಕೈಲಯವಾನೆ ತುಮೆ ಪ್ರಾಥನಾ ಕರೊ. ವರಿ ಮಿ ಲಿನಂಜಾ಼ವಾನಾ ದೊಕ್ಡಾ ವರಿ ತೆ ದೊಕ್ಡಾ ಕ್ಹುದಾನಾ ಬಚ್ಚಾ಼ವೊನೆ ಮನಸೆ ಔ ಕೈನ ಪ್ರಾಥನಾ ಕರೊ. ");
INSERT INTO sle_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ತೆ ಥಯಲ್ಪರ, ಕ್ಹುದಾನಿ ಚಿತ್ತ ರ‍್ಹೈಮ ಮಿ ತುಮೊಕನ ಔಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ಮಿ ತುಮಾರಾ ಕ್ಹಾತೆ ಶಾಂತಿಯೆ ವರಿ ಕ್ಹುಶಿಕ್ಹು ರ‍್ಹೌಸ. ");
INSERT INTO sle_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ಶಾಂತಿ ದಿವಾಲೊ ಕ್ಹುದಾ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಾದೆ. ಆಮೆನ್. ");
INSERT INTO sle_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ಕ್ರಿಸ್ತಮಾ ರ‍್ಹೈನ ಅಪನಿ ಭೆನ ಥಯಲ ಪೊಯಿಬೆನೆ ಮಿ ತುಮೊನೆ ತಿನಾಹುತಿ ಕವಾನೆ ಆಸ ಕರುಸ. ತೆ ಕೆಂಖ್ರೆಯ ಗಾಮ್ನಿ ಸಭೆನೆ ಖಾಸ ಮದದ ಕರಿಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ತುಮೆ ತಿನೆ ಪ್ರಭುನಾ ನಾಮಪರ ಮಳೈಲ್ಯು ಕೈನ ಮಿ ತುಮೊಕನ ಕೈಲ್ಯುಸ. ತಿನೆ ಚಾ಼ಯೆ ಥಯಲನೆ ಮದದ ಕರೊ. ತೆ ಮನೆ ಘನ್ನಿ ಮದದ ಕರಿಸ. ತೆನೈಸೊ ಬಿಜಾ಼ ಮನಕ್ಹೊನೆ ಬಿ ಮದದ ಕರಿಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ಪ್ರಿಸ್ಕಿಳನೆ ಅಕ್ವಿಳನೆ ಮಾರಿ ವಂದನಾ ಕವೊ. ತ್ಯುನೆ ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ಮಾರಾ ಕ್ಹಾತೆ ಸೆವೆ ಕರಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ತ್ಯುನೆ ಮಾರೊ ಜ಼ಲಮ ವಚಾ಼ಡಾನಾ ಹುತಿ ತ್ಯುನೊ ಜ಼ಲಮ ದಿವಾನೆ ತಯ್ಯಾರ ಥಯಾತಾ. ಮಿ ತ್ಯುನೊನೆ ಅಭಾರಿ ಥಯೊಸ. ಮನೆ ಯಕ್ಕಜ಼ ನೈಸೊ ಯಹುದ್ಯೊ ನೈ ರ‍್ಹಯಲ ಸಭೆವಾಲಾ ತ್ಯುನೊನೆ ಆಭಾರಿ ತಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ತೆನೈಸೊ ತ್ಯುನಾ ಘರೊಮಾ ಮಳಾಲಾ ಮನಕ್ಹೊನೆಬಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ಮಾರೊ ಮಯಾನೊ ಥಯಲ ದೊಸ್ತ ಎಪೈನೆತನೆ ಮಾರಿ ವಂದನಾ ಕವೊ. ಎಶ್ಯಾ ದೆಶಮಾ ಯೆಸು ಸ್ವಾಮಿನೆ ನಂಬಲವಾಲಾ ಕದ್ಯಾಮ ತೆಜ಼ ಪೈಲಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ಮರಿಯಳನಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ತೆ ತುಮಾರಾ ಹುತಿ ಘನ್ನಿ ಕಷ್ಟಮಾ ಕಾಮ ಕರಿಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ಅಂದ್ರೊನಿಕನೆ ವರಿ ಯುನ್ಯನೆ ಮಾರಿ ವಂದನಾ ಕವೊ. ತ್ಯುನೆ ಮಾರಾ ಕಳಬಳ ವ್ಹೈ. ತೆನೈಸೊ ತ್ಯುನೆ ಮಾರಾ ಕ್ಹಾತೆ ಜೆಲಮಾ ವ್ಹತ್ತಾ. ಅಪೊಸ್ತಲೊನೆ ತ್ಯುನೆ ವಳಕ ವ್ಹತ್ತಾ. ಅಪೊಸ್ತಲೊನೆ ತ್ಯುನೆ ವಳಕ ವ್ಹತ್ತಾ. ತ್ಯುನೆ ಪೈಲಾಜ಼ ಕ್ರಿಸ್ತನಾ ವಿಸ್ವಾಸಿಯೊ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ಪ್ರಭುಮಾ ರ‍್ಹಯಲ ಮಾರಾ ಮಯಾನಾ ದೊಸ್ತನೆ ಅಂಪ್ಲಿಯಾತನ್ನೆ ಬಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ಉರಬಾನನೆ ಬಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ತೆ ಕ್ರಿಸ್ತನಾ ಹುತಿ ಮಾರಾ ಕ್ಹಾತೆ ಸೆವೆ ಕರ್ತೊತೊ. ಮಾರೊ ಮಯಾನೊ ದೊಸ್ತ ಥಯಲ ಸ್ತಾಖುನೆಬಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ಅಪೆಲನ್ನೆಬಿ ಮಾರಿ ವಂದನಾ ಕವೊ. ತೆ ಕ್ಹರಿಮಾಜ಼ ಕ್ರಿಸ್ತನೆ ಮಯಾ ಕರಸ ಕೈನ ಮೆಚ್ಚಿಕೆನೆ ಪಾತ್ರ ಥೈನ ದೆಕಾಡಿನ ದಿದ್ಯೊಸ. ಕರಕರಿನೆ ದೆಕ್ಯಾತಾ. ಅರಿಸ್ತೊಬುಲನಾ ಕುಟುಂಬಮಾ ರ‍್ಹಯಲ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ಮಾರು ವಂದನಾ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ಮಾರಾ ಸಂಬದಿಕೊ ಥಯಲ ಹೆರೊಡಿಯೊನನೆ ಪ್ರಭುನೆ ಮಳ್ಯಲವಾಲೊ ನಾರಕಿಸ್ಸನಾ ಕುಟುಂಬವಾಲಾ ಕ್ಹಾರಾವೊನೆ ಮಾರು ನಮಸ್ಕಾರ ಕವೊ. ");
INSERT INTO sle_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ತ್ರುಫೈನಳನೆ ತ್ರುಫೊಸಳನೆಬಿ ಮಾರು ನಮಸ್ಕಾರ ಕವೊ. ತ್ಯುನೆ ಪ್ರಭುನಾ ಹುತಿ ಘನ್ನು ತ್ರಾಸ ಖೈನ ಸೆವಾ ಕರ‍್ಯಾಸ. ಮಾರಿ ಮಯಾನಿ ಭೆನ ಥಯಲ ಪೆರಸಿಸಳನೆ ಮಾರಾ ನಮಸ್ಕಾರ ಕವೊ. ತೆಬಿ ಪ್ರಭುನಾ ಹುತಿ ಘನ್ನಿ ತ್ರಾಸ ಖೈನ ಸೆವಾ ಕರಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ವರಿ ರುಫನೆ ಮಾರು ನಮಸ್ಕಾರ ಕವೊ. ತೆ ಪ್ರಭುನಿ ಸೆವಾಮಾ ಖಾಸ ಮನಕ್ಹ ವ್ಹೈ. ತಿನಿ ಯಾ ನೆಬಿ ಮಾರು ನಮಸ್ಕಾರ ಕವೊ. ತೆ ಮನೆ ಸ್ವಂತ ದಿಕ್ರಾ ಲಿಂಗತ ದೆಕಿಲಿದಿಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ಅಸುಂಕ್ಕರಿತನೆ ಪ್ಲೆಗೊನನೆಬಿ ಹೆರ್ಮೆಯನೆಬಿ ಪತ್ರೊಬನೆಬಿ ಹೆರ್ಮಾನನೆಬಿ ವರಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹವಾಲಾ ಕ್ಹಾರಾ ಕ್ರಿಸ್ತ ಭಾಯೊನೆಬಿ ಮಾರಿ ವಂದನೆ ");
INSERT INTO sle_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ಫಿಲೊಲೊಗನನೆ ಯುಲ್ಯಳನೆಬಿ ನೆರಯನೆಬಿ ತಿನಿ ಭೆನನೆಬಿ ವರಿ ಒಲುಂಪನೆಬಿ ವರಿ ತ್ಯುನಾ ಕ್ಹಾತೆ ರ‍್ಹವಾಲಾ ಕ್ಹಾರಾ ಕ್ಹುದಾನಾ ಮನಕ್ಹೊ ಮಾರು ನಮಸ್ಕಾರ. ");
INSERT INTO sle_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ತುಮೆ ಯಕ್ಕನೆ ಯಕ್ಕ ಮಳ್ತಾಮಾ ಪವಿತ್ರ ರ‍್ಹಯಲ ನಮಸ್ಕಾರ ಕರೊ. ಕ್ರಿಸ್ತನಾ ಸಭೆವಾಲಾ ಕ್ಹಾರಾ ತುಮೊನೆ ನಮಸ್ಕಾರ ಕರಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ಭಾಯೊ ಭೆನೊ, ತುಮೊಮಾ ತಪ್ಪ ಹುಟ್ಸಾವಾನಾ ಮನಕ್ಹೊನಾ ವಿಷಯಮಾ ತುಮೆ ಘನ್ನಾ ಹುಶಾರಕ್ಹು ರ‍್ಹೌ ಕೈನ ಮಿ ತುಮೊಕನ ಮಾಂಗಿಲ್ಯುಸ. ಬಿಜಾ಼ವೊನಾ ಬರೊಕ್ಹೊನಾ ಕೆಡ್ಸಾಲಾವೊನಾ ಹುತಿ ತುಮೆ ಘನ್ನಾ ಹುಶಾರಕ್ಹು ರ‍್ಹವೊ. ತುಮೆ ಶಿಕ್ಕಯಲ ಉಪದೆಶನೆ ತ್ಯುನೆ ವಿರುದ್ದ ಥಯಾಸ. ತುಮೆ ತ್ಯುನೊಕ್ಹು ದುರ ರ‍್ಹವೊ ಕೈನ ವರಿ ಮಿ ತುಮೊಕನ ಮಾಂಗಿಲ್ಯುಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ಕಾಕದ್ಯಾಮ ತ್ಯವಾ ಸಂಗತಿಯೊ ಕರಲ ಮನಕ್ಹೊ ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಕ್ರಿಸ್ತನಿ ಸೆವಾ ಕರಾಡ್ಯಾ ನತ್ತಿ. ತ್ಯುನೆ ಖಾಲಿ ತ್ಯುನೆ ಪೆಟನಾ ಹುತಿ ಕರಾಡಾಸ. ಕೆಟ್ಟನಾ ಹುತಿ ನೈ ತಿಳದ್ಯಲ ಮನಕ್ಹೊನಾ ಮನಸೊನೆ ಮೊಸ ಕರಾನೆ ತ್ಯುನೆ ಚೊ಼ಕಾ ಮಯಾನಾ ವಾತೊ ಬೊಲಸ ವರಿ ಮ್ಹೊಡಾನೆ ಪಸಂದ ಆವಾನಾ ವಾತೊ ಬೊಲಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ತುಮಾರಿ ವಿಧೆಯ ಕ್ಹಾರಾ ವಿಶ್ವಾಸಿಯೊನೆ ತಿಳದಲ ಛೆ. ತಿನಾಹುತಿ ತುಮಾರಾ ವಿಷಯಮಾ ಮಿ ಘನ್ನೊ ಖುಶಿ ಥೌಸ. ತೆನೈಸೊ ಚೊ಼ಕಿಯೊ ಸಂಗತಿಯೊನಾ ಹುತಿ ತುಮೆ ಶಾಣ್ಯಾ ಥೈನ ರ‍್ಹೌಕೈನ ವರಿ ಕೆಟ್ಟ ಸಂಗತಿಯೊನಾ ಹುತಿ ಸುಜ಼ ಗ್ವತ್ತ ನೈ ರ‍್ಹಯಲವಾಲಾ ರ‍್ಹೌಕೈನ ಮಿ ಆಸ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ವರಿ ಶಾಂತಿ ದಿವಾಲೊ ಕ್ಹುದಾ ಜ಼ಲ್ದಿಜ಼ ಸೈತಾನನೆ ಹರಾಡಿನ, ತಿನೆ ತುಮಾರಾ ಪಗನಾ ಹೆಟೊ ಘಾಲಸ. ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸುನಿ ಕೃಪಾ ತುಮಾರಾ ಕ್ಹಾತೆ ರ‍್ಹವಾದೆ. ");
INSERT INTO sle_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ವರಿ ಮಾರಾ ಕ್ಹಾತೆ ಕಾಮ ಕರಾಲೊ ಥಯಲ ತಿಮೊಥೆಯನೆ ವರಿ ಮಾರಾ ಸಂಬಂದಿಕ ಥಯಲ ಲುಕ್ಕಯ, ಯಾಸೊನ ವರಿ ಸೊಸಿಪತ್ರ ತುಮೊನೆ ನಮಸ್ಕಾರ ಕದ್ಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ಪೌಲಾ ಕವಾನಿ ಸಂಗತಿಯೊನೆ ಬರ್ದಾಲೊ ತೆರತ್ಯೆಯ ಕವಾಲೊ ಮಿ ಬಿ ತುಮೊನೆ ಪ್ರಭುಮಾ ತುಮೊನೆ ನಮಸ್ಕಾರ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ಗಾಯನ ಮನೆ ಅಥಿತಿ ಸತ್ಕಾರ ಕರಾಡ್ಯೊಸ. ತೆನೈಸೊ ಸಭಾ ಕುಟನಾ ಹುತಿ ತಿನಾ ಘರನೆ ಉಪಯೊಗ ಕರೆಸ. ತೆಬಿ ತುಮೊನೆ ನಮಸ್ಕಾರ ಕವಾಡ್ಯೊಸ. ಎ ಗಾಮನೊ ಇಸಾಬ ಮ್ಹೆಲ್ಯಾಲೊ ಎರಸ್ತಸ ವರಿ ಅಪ್ನೊ ಬರೊಕ್ಹೊಮಾ ರ‍್ಹಯಲ ಭೈ ಕ್ವರತಬಿ ತುಮೊನೆ ನಮಸ್ಕಾರ ಕವಾಡಾಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಿ ಕೃಪಾ ಮಳಾದೆ. ಆಮೆನ್ ");
INSERT INTO sle_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ಕ್ಹುದಾನೆ ಮಹಿಮಾ ಥಾವಾದೆ. ತುಮೊನೆ ಬರೊಕ್ಹಾಮಾ ತಾಕತ ದಿವಾಲೊ ಕ್ಹುದಾ ಯಕ್ಲೊಜ಼ ವ್ಹೈ. ಮಿ ಉಪದೆಶ ಕರಾನಿ ಸುವಾರ್ತೆನಾ ಮುಲಕ ಹಮೆಶಾ ರ‍್ಹವಾಲೊ ಕ್ಹುದಾ ತುಮೊನೆ ತಾಕತವಾಲಾ ಕರಸ. ಮಿ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಹುತಿ ಮನಕ್ಹೊನೆ ತಿಳಸಾವಾನುಜ಼ ತೆ ಸುವಾರ್ತೆ ಕ್ಹುದಾ ತಿಳಸಾಯಲ ತೆ ಸುವಾರ್ತೆ ರಹಸ್ಯ ರ‍್ಹಯಲ ಕ್ಹರಿಜ಼ ವ್ಹತ್ತು ವರಿ ಪೈಲಾತುಬಿ ಝಕೈ ಗೈತು. ");
INSERT INTO sle_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ತೆನೈಸೊ ರಹಸ್ಯ ರ‍್ಹಯಲ ತೆ ಸತ್ಯನೆ ಹಮ್ನಾ ತುಮೊನೆ ದೆಕಾಡ್ಯಾಸ. ವರಿ ತೆ ಸತ್ಯನೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ತಿಳಸಾಯಲ ಛೆ. ಕ್ಹುದಾ ಆಜ್ಞಾ ಕರಲ ಎಜ಼ ವ್ಹೈ. ಕ್ಹಾರಾ ಮನಕ್ಹೊ ಬರೊಕ್ಹೊ ಕರಿನ ಕ್ಹುದಾನೆ ವಿಧೆಯ ಥೌ ಕೈನ ರಹಸ್ಯ ರ‍್ಹಯಲ ಎ ಸತ್ಯನೆ ಕ್ಹಾರಾ ಮನಕ್ಹೊನೆ ತಿಳಸಾಯಲ ಛೆ. ಕ್ಹುದಾ ಹರ ಹಮೆಶಾ ಜಿವ್ತೊ ರ‍್ಹವಸ. ");
INSERT INTO sle_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ಯಕ್ಲೊಜ಼ ಗ್ಯಾನಿ ಥಯಲ ಕ್ಹುದಾನೆ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಮುಲಕ ಕೆಳಾಮಾಬಿ ಮಹಿಮಾ ಥಾವಾದೆ. ಆಮೆನ್.");
INSERT INTO sle_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ಪೌಲಾ ಬರ್ದಾನು ಪತ್ರ. ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ಅಪೊಸ್ತಲ ಥಾವಾನಾಹುತಿ ಮಿ ಕ್ಹುದಾನಾ ಚಿತ್ತನಿಂಗತ ಬಲಾಯಲವಾಲೊ ವ್ಹೈ. ಮಿ ಎ ಪತ್ರ ಕ್ರಿಸ್ತಮಾ ಅಪ್ನೊ ಭೈ ಥಯಲ ಸೊಸ್ಥೆನನಾ ಕ್ಹಾತೆ ಬರ್ದಾಡೊಸ. ");
INSERT INTO sle_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ಪವಿತ್ರ ಥೈನ ಕರಲ ಕೊರಿಂಥನಾ ಕ್ಹುದಾನಾ ಸಬೆವಾಲಾವೊನೆ ಎ ಪತ್ರ ಬರ್ದಾಡೊಸ. ತುಮೆ ಕ್ಹುದಾನಾ ಪವಿತ್ರ ಮನಕ್ಹೊ ಥಾವಾನೆ ಬಲಾಯಲವಾಲಾ ವ್ಹೈ. ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮಪರ ಬರೊಕ್ಹೊ ಮ್ಹೆಲಾಲಾ ಕ್ಹಾರಾ ಮನಕ್ಹೊನಾ ಕ್ಹಾತೆ ತುಮೆಬಿ ಬಲಾಯಲವಾಲಾ ಥಯಾಸ. ಯೆಸು ಕ್ರಿಸ್ತ ತ್ಯುನೊನೆಬಿ ವರಿ ಅಪೊನೆಬಿ ಪ್ರಭು ಥಯೊಸ. ");
INSERT INTO sle_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ಅಪ್ನೊ ಬಾ ಥಯಲ ಕ್ಹುದಾಕ್ಹು ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತಕ್ಹು ತುಮೊನೆ ಕೃಪಾ ಶಾಂತಿ ಮಳಾದೆ. ");
INSERT INTO sle_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ಕ್ಹುದಾ ತುಮೊನೆ ದಿದಲ ಕೃಪಾನಾ ಹುತಿ ಮಿ ತುಮಾರಾ ಹುತಿ ಕೆಳಾಮಾಬಿ ಕ್ಹುದಾನೆ ಸ್ತುತಿ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ಕಾಕದ್ಯಾಮ, ಕ್ರಿಸ್ತ ಯೆಸುಮಾ ತುಮೆ ಕ್ಹಾರಿ ತರಾಮಾ ಸೌಕಾರೊ ವ್ಹೈ, ಗ್ಯಾನಿಯೊ ವ್ಹೈ ವರಿ ವಾತೊ ಬೊಲಾಮಾ ಹುಷಾರ ಥಯಾಸ. ");
INSERT INTO sle_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ಎನೈಸೊ, ಕ್ರಿಸ್ತ ಯೆಸುನಾ ಹುತಿ ಸಾಕ್ಷಿ ತುಮೊಮಾ ಛೆ ತಿನಾಹುತಿ ತುಮೆ ಘಟ್ಟ ಛೆ. ");
INSERT INTO sle_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ಇಮ್ಮ ರ‍್ಹಯಮ, ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತ ವರಿ ಆವಾನು ಕೈದತಾ ರ‍್ಹಯಲ ತುಮೆ ಕ್ಹುದಾ ಕಂತು ಆವಾನಿ ಹರಯಕ್ಕ ಆತ್ಮಿಕನಿ ವರಾ ವ್ಹಂದಿಲಿವಾನು ಚು಼ಕೈಲೆತಾ ನೈ. ");
INSERT INTO sle_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ಯೆಸು ತುಮೊನೆ ಲಾಸ್ಟ ಲಕ್ಕಾ ವಚಾ಼ಡಸ. ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತ ನ್ಯಾಯನೊ ಫೈಸಲಾನಾ ದಿನ್ಮಾ ತುಮೆ ನಿರದೊಷಿಯೊ ಥಾವೊಶಿ. ");
INSERT INTO sle_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ಕ್ಹುದಾ ಬರೊಕ್ಹೊವಾಲೊ ಥಯೊಸ. ಕ್ಹುದಾನೊ ದಿಕ್ರೊ ಥಯಲ ವರಿ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ಜ಼ಲಮಮಾ ವಾಟೊ ಲಿವಾಲಾ ಥೌ ಕೈನ ತುಮೊನೆ ಬಲಾಯಲವಾಲೊಜ಼ ಕ್ಹುದಾ ವ್ಹೈ. ");
INSERT INTO sle_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ಭಾಯೊ ಭೆನೊ, ಅಪ್ನೊ ಪ್ರಭು ಥಯಲ ಯೆಸು ಕ್ರಿಸ್ತನಾ ನಾಮ ಪರ ಮಿ ತುಮೊಕನ ಮಾಂಗಿಲಿವಾನು ಸು ವ್ಹೈ ಕದ್ಯಾಮ, ವಾದವಿವಾದ ನೈಸೊ ಬಿನ್ನಭೆದ ನೈಸೊ ಯಕ್ಕಜ಼ ಮನಸ್ಸಕ್ಹು ಯಕ್ಕಜ಼ ಉದ್ದೆಶಕ್ಹು ತುಮೆ ಯಕ್ಕಜ಼ ಥೈನ ರ‍್ಹವೊ. ");
INSERT INTO sle_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ಮಾರಾ ಭಾಯೊ ಭೆನೊ, ಖ್ಲೊಯೆಯನಾ ಘರತಾ ಆಯಲ ದಕ್ಹಾ ಜ಼ನಾ ತುಮಾರಾ ಹುತಿ ಮನೆ ಕದ್ಯಾ. ತುಮಾರಾ ವಚ್ಮಾ ವಾದ ವಿವಾದ ಚಾ಼ಲಾಡುಸ ಕೈನ ಮನೆ ಗ್ವತ್ತ ಥಯು. ");
INSERT INTO sle_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ಕದ್ಯಾಮ, ತುಮೊಮಾ ಯಕ್ಲೊ \"ಮಿ ಪೌಲಾ ನಿಂಗತ ಚಾ಼ಲಾಲೊ ವ್ಹೈ ಕೈನ ಯಕ್ಲೊ, ಅಪೊಲೊಸ ನಿಂಗತ ಚಾ಼ಲಾಲೊ ವ್ಹೈ ಕೈನ ವರಿಯಕ್ಲೊ, ತೆ ಪೆತ್ರಾ ನಿಂಗತ ಚಾ಼ಲಾಲೊ ವ್ಹೈ ಕೈನ ವರಿಯಕ್ಲೊ, ತೆ ಕ್ರಿಸ್ತ ನಿಂಗತ ಚಾ಼ಲಾಲೊ ವ್ಹೈ ಕೈನ ಕವಸ. ");
INSERT INTO sle_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ಕ್ರಿಸ್ತ ಯೆಸು ಭಾಗ ಭಾಗ ಜು಼ದೊ ಥಯೊಸ ಸು? ತುಮಾರಾ ಹುತಿ ಶಿಲುಬಿಪರ ಮರಲವಾಲೊ ಪೌಲಾ ವ್ಹೈ ಸು? ತುಮೆ ಬಾಪ್ತಿಸ್ಮ ಕರೈಲಿದಲ ಪೌಲಾನಾ ನಾಮಪರ ವ್ಹೈ ಸು? ");
INSERT INTO sle_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ತುಮೊಮಾ ಕ್ರಿಸ್ಪ ವರಿ ಗಾಯನ ಇವ್ನೊನೆ ಛೊಡಿನ ಬಿಜಾ಼ ಕಿನೆಜ಼ ಮಿ ಬಾಪ್ತಿಸ್ಮ ಕರಾಯೊ ನತ್ತಿ ಕೈನ ಕ್ಹುದಾನೆ ಸ್ತೊತ್ರಾ ಕರುಸ. ");
INSERT INTO sle_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ತಿನಾಹುತಿ ತುಮೊಮಾ ಕುನ್ನಜ಼ ಬಾಪ್ತಿಸ್ಮ ಮಾರಾ ನಾಮಪರ ಲಿದ್ಯಾಸ ಕವಾನು ಕೆ ನೈ ಸಕ್ತಾ. ");
INSERT INTO sle_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","