﻿USE sofia;
DROP TABLE IF EXISTS sofia.sjaNT_vpl;
CREATE TABLE sjaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sjaNT_vpl WRITE;
INSERT INTO sjaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo uchiaji chonaarãwedapema Rey Daviddeepa mãik'aapa Abrahamdeepa. Chonaarãwedapemaarãpa iru ëreerã t'ɨ̃ p'ãjida ichi t'ẽepemaarãpa k'awaadamerã k'airãdeepa uchiaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac ak'õre paji. Isaac Jacob ak'õre paji. Jacob Judá ak'õre paji mãik'aapa Judá ɨ̃pemaarãde ichiaba. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Fares mãik'aapa Zara ak'õre paji. Ãchi nawe Tamar paji. Fares Hesrón ak'õre paji. Hesrón Aram ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab ak'õre paji. Aminadab Nahasón ak'õre paji. Nahasón Salmón ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz ak'õre paji mãik'aapa Rahab Booz nawe paji. Booz Obed ak'õre paji mãik'aapa Rut Obed nawe paji. Obed Jesé ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesé Rey David ak'õre paji. Rey David Salomón ak'õre paji mãik'aapa Urías wẽra pada Salomón nawe paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboam ak'õre paji. Roboam Abías ak'õre paji. Abías Asá ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asá Josafat ak'õre paji. Josafat Joram ak'õre paji. Joram Ozías ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozías Jotam ak'õre paji. Jotam Acaz ak'õre paji. Acaz Ezequías ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés ak'õre paji. Manasés Amón ak'õre paji. Amón Josías ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconías, chi ɨ̃pemaarã ome ak'õre paji. Mãɨrã p'anapachida Babilónia p'uurudepemaarãpa Israel pidaarã p'oyaadap'eda, presok'a ateedak'ãri ãchi eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ma Babilónia p'uurudee wãdap'edaa, Jeconías Salatiel ak'õre paji. Salatiel Zorobabel ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abihud ak'õre paji. Abihud Eliaquim ak'õre paji. Eliaquim Azor ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadoc ak'õre paji. Sadoc Aquim ak'õre paji. Aquim Eliud ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar ak'õre paji. Eleazar Matán ak'õre paji. Matán Jacob ak'õre paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José ak'õre paji. José María ɨmɨk'ĩra paji. María Jesús nawe paji. Ma Jesús ichiaba t'ɨ̃jarapachida Cristo; jara k'inia bɨ Tachi Ak'õrepa pëida eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahamdeepa uchiada catorce uchiadap'edaarã uchiajida Rey David parumaa. Daviddeepa ichiaba uchiada catorce uchiadap'edaarã uchiajida Israel pidaarã ateerutamaa Babilónia p'uurudee. Ichiaba madeepa uchiada catorce uchiadap'edaarã uchiajida Jesucristo t'orumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo t'oda nãga paji. Iru nawe, María, pedeetee baji José ome miak'ãidait'ee. Mamĩda araa padai naaweda, Tachi Ak'õre Jaurepa biak'oopiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josepa biak'oo bɨ unuk'ãri, miak'ãi-e pait'ee paji iru ome. Mamĩda José t'ãri pia bada perã, María k'ĩra nejasiapiamaapa k'ĩup'ee amaat'aait'ee paji, awaraarãpa k'awaanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mãga k'ĩsia bɨde, k'ãimok'araaji ɨt'aripema ángel ome. Mãgɨpa mãgaji: —José, Rey Daviddeepa uchiada, waaweenáaji María ome miak'ãiit'ee, Ak'õre Jaurepata ma warra oopida perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariapa ɨmɨk'ĩra warra t'oit'ee. T'ɨ̃ bɨit'eeda aji, Jesús, irua eperãarã k'aripait'ee perã atuanaadamerã ãchia p'ek'au k'achia oopata k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mãga paji Tachi Ak'õrepa jarapidak'a chonaarãweda ichi pedee jarapari it'aideepa: ");
INSERT INTO sjaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Awẽra ɨmɨk'ĩra ome k'ãi-ee bɨta biak'ooit'ee mãik'aapa ɨmɨk'ĩra warra t'oit'ee. Iru t'ɨ̃jaradait'ee Emanuel.’ Mãgɨ́ t'ɨ̃ jara k'inia bɨ: “Tachi Ak'õre tachi ome bapari.” ");
INSERT INTO sjaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José ɨ̃rɨmak'ãri, ooji ma angelpa jaradak'a. María ataji ichi wẽra pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mamĩda miak'ãida-e paji, chi warra t'oru misa. T'ok'ãri, Josepa t'ɨ̃ bɨji Jesús. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús t'oji Belén p'uurude Mãgɨ́ p'uuru Judea eujãde bɨ. T'ok'ãri, Herodes Judea eujãdepema rey paji. Maapai k'ĩsia k'awaa beerã ak'õrejĩru uchiapari eereepa Jerusalén p'uurudee chejida. Ãchia lucero ak'ɨpachida k'awaadait'ee ne-inaa p'asait'ee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pachedak'ãri, eperãarã iidijida: —¿Sãma bɨma ajida, Judiorã Rey t'oda? Iru lucero uchiak'ãri ak'õrejĩru uchiapari eere, rey waibɨa t'oda k'awaajida. Mapa ma lucero t'ẽe chejida parã rey jɨrɨde. Irumaa ɨt'aa t'ɨ̃de chejidada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey Herodepa mãga ũrik'ãri, p'era pɨk'a nɨ̃beeji, Jerusalén p'uuru pidaarã ichiaba. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mãpai Herodepa t'ɨ̃ pëiji p'aareerã poroorã mãik'aapa Moisepa p'ãda jarateepataarã. Iidiji sãmata Tachi Ak'õrepa pëiit'ee bada t'oit'ee paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mãpai p'anaujida: —Belén p'uurude, Judea eujãde t'oit'ee. Chonaarãweda Ak'õre pedee jaraparipa nãga p'ãji: ");
INSERT INTO sjaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belén p'uuru apema Judea eujãdepema p'uuru k'ãyaara ek'ariara bɨ-e, ma p'uurude eperãarã poro waibɨa t'oit'ee perã. Irua Israel pidaarã ak'ɨit'ee mɨ pari.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodepa mãga ũrik'ãri, ma k'ĩsia k'awaa beerã mera t'ɨ̃ pëiji iidiit'ee sãaweda ma lucero unujida. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Maap'eda ãchi Belendee pëiji. Mamĩda mãgaji: —Wã́tɨ ma warra jɨrɨde. Pia iididapáde aji, ma warra pari. Unu atadak'ãri, mɨmaa jara chedapáde aji, mɨ jida ichiaba irumaa ɨt'aa t'ɨ̃de wã k'inia bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mãpai k'ĩsia k'awaa beerã wãjida. Ma lucero ãchi naa wãpachi. Mata ak'ɨnɨ̃ banaji ma warra badamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mãga unudak'ãri, o-ĩadachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Teeda t'ĩudak'ãri, unujida ma warra chi nawe María ome. Mãpai bedabaidap'eda, ɨt'aa t'ɨ̃jida ma warra k'ĩrapite mãik'aapa ãchi net'aa aneedap'edaa ewat'ɨdak'ãri, teejida nẽe, ne-inaa t'ũa bapari bajũbak'a mãik'aapa k'era pia t'ɨ̃jarapatap'edaa mirra. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Maap'eda k'ãimok'araade Tachi Ak'õrepa jaraji waa wãnaadamerã Herodemaa. Mapa awaraa ode wãjida ãchi eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","K'ĩsia k'awaa beerã wãdap'edaa t'ẽepai, k'ãimok'araade ɨt'aripema angelpa Josemaa mãgaji: —P'irabáiji mãik'aapa wã́ji Egipto eujãdee pɨchi wẽra iru warra ome. Mama p'ananadapáde aji, mɨa jararumaa, Herodepa na warra jɨrɨpiit'ee perã peepiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aramãgá José p'irabaiji. María mãik'aapa chi warra atap'eda, p'ãrik'ua Egiptodee wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mama p'aneejida Herodes piurumaa. Mãga paji Tachi Ak'õrepa jaradak'a, ichi pedee jarapari it'aideepa: ‘Egipto eujãdeepa mɨ warra t'ɨ̃ pëiji chemerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodepa k'awaak'ãri ma k'ĩsia k'awaa beerãpa ichi k'ũrat'aadap'edaa, k'ĩraudachi. Ãchia jaradade k'ĩsiap'eda, ichi soldaorã pëiji Belén p'uurudee mãik'aapa p'uuru k'ait'a p'anadap'edaamaa, warrarã año omeedeepa edaa peek'oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mãgá Tachi Ak'õre pedee jarapari Jeremiapa jaradak'a uchiaji: ");
INSERT INTO sjaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Rama p'uurude jẽepi ororoo ũrijida. Jẽepi chupɨria ũrijida. Raquel jẽe nɨ̃baji ichi warrarã-it'ee. Apidaapa ichi t'ãri o-ĩ-ĩapidak'aa paji, chi warrarã k'iniidaidap'edaa perã.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes piuda t'ẽepai, Egiptode at'ãri p'anɨde k'ãimok'araade angelpa jaraji Josemaa: ");
INSERT INTO sjaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wãpáde aji, Israel eujãdee pɨchi wẽra, chi warra ome, warra pee k'inia p'anadap'edaarã piudap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mãgá wãjida Ak'õrepa jara pëidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mamĩda Josepa k'awaak'ãri Arquelao rey bɨ chi ak'õre Herodes pari Judea eujãde, waawee baji mama banait'ee. Mãga nɨde k'ãimok'araade Tachi Ak'õrepa jaraji Galilea eujãdee wãdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mama panadak'ãri, Nazaret p'uurude p'ananajida. Mãga paji Ak'õre pedee jarapataarãpa jaradap'edaak'a: “Eperãarãpa Jesús t'ɨ̃jarapataadait'ee Nazaret pida.” ");
INSERT INTO sjaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma t'ẽepai eperã t'ɨ̃jarapatap'edaa Juan Bautista Tachi Ak'õrepa jara pëida jara cheji Judea eujãde, eujã pania wẽe bɨmãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mãgaji: —¡P'ek'au k'achia oo amáatɨ mãik'aapa Tachi Ak'õrede ijãapatáatɨ! Taarã-e nɨde Tachi Ak'õrepa eperãarã p'e bɨit'eeda aji, ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chonaarãweda Tachi Ak'õre pedee jarapari Isaíapa jaraji: ‘Eujã pania wẽe bɨde eperã bia bɨ: “O pi-ia oopatak'a poro waibɨa chei naaweda, mãga pɨk'a p'ek'au k'achia oo amáatɨ Tachi Waibɨa chei naaweda.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mãgɨ́ eperã Juan paji. P'aru camello k'aradee k'ada jɨ̃pachi. Chi k'ɨrrɨde jɨ̃pari ne-edee ooda paji. K'opachi sisi mãik'aapa topachi jɨrrɨ miéle. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eperãarã Jerusalén p'uurude p'anadap'edaarã awaraa Judea eujãdepemaarã ome mãik'aapa Jordán to k'ait'a p'anadap'edaarã ome chejida Juan pedee ũride. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tachi Ak'õremaa chupɨria iidi chejida ãchia p'ek'au k'achia oopatap'edaa k'aurepa. Mãpai Juanpa ãchi poro choo wãpachi Jordán to jãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseorã saduceorã ome chok'ara ichiaba chejida Juanmaa poro choopide. Mamĩda Juanpa mãgaji: —¡Parã k'achia-idaa beerãdeepa uchiadap'edaarã! ¡Taamák'apɨ p'anɨ! ¿Poro choopi chejida-ek'ã Tachi Ak'õre juapa mia k'iniada-e p'anadairã? ");
INSERT INTO sjaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mãga pɨrã, p'ek'au k'achia oo amáatɨ mãik'aapa p'anapatáatɨ Tachi Ak'õrepa k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","K'ĩsianáatɨ Tachi Ak'õrepa parãta miapi-e pait'ee Abrahamdeepa uchiadap'edaa perã. Mɨa jara bɨ: Na mãudeepa Tachi Ak'õrepa Abrahamdeepa uchiadap'edaarã oo atai. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ara chaarapa nejõ bɨɨrɨ chauk'aa bɨ t'u peet'aapatak'a t'ɨpɨtaude bat'at'aadait'ee paa jõmerã, mãga pɨk'a taarã-e Tachi Ak'õrepa jõpiit'ee parã, chi oodaamaa p'anapataarã irua k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mɨa parã poro choopari paniapa, ak'ɨpidamerã pãchia p'ek'au k'achia oopata oodaamaa p'anɨ mãik'aapa wãara Tachi Ak'õrede ijãa p'anɨ. Mamĩda eperã mɨ t'ẽe cheru mɨ k'ãyaara waibɨara bɨ. Mɨa iru chancla ateeik'araa bɨ, mɨ iru k'ãyaara ek'ariara bairã. Irua eperãarã nãgá poro chooit'ee. Tachi Ak'õre Jaure ba chepiit'ee parã k'ap'ɨade. Mamĩda ichide ijãadak'aa beerã t'ɨpɨtaude jõpiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ooit'ee trigo ewaparipa ooparik'a. Mãgɨpa pala aneek'ãri, trigo ewada ɨt'aa jira bat'apari chi tau uchiamerã mãik'aapa nãupa chi e ãyaa ateemerã. Maap'eda ma trigo tau ɨa bɨpari chi ɨapatamãi. Mamĩda chi e beeda t'ɨpɨtaude bat'at'aapari. Mãgɨ́ t'ɨpɨtau k'ĩik'aada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Maapai Jesús wãji Galilea eujãdeepa Jordán todee, Juan badamaa poro choopide. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ewaa weda Juanpa iru poro choo-e pait'ee paji. Mapa mãgaji: —Pɨata mɨ poro chooipia bɨ. ¿Sãap'eda mɨmaa cheruma aji, pɨ poro choopide? ");
INSERT INTO sjaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mamĩda Jesupa p'anauji: —Mɨ poro choopáde aji, Tachi Ak'õrepa jara bɨk'a uchiamerã. Mãpai Juanpa poro chooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Poro choop'eda, Jesús toiduupa uchiak'ãri, pajã ewadachi mãik'aapa irua unuji Tachi Ak'õre Jaure ichi ɨ̃rɨ palomak'a baai cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mãpai ũriji ɨt'ariipa nãga pedeeru: —Nata mɨ Warra k'inia. Irua mɨ t'ãri o-ĩapipari. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Maap'eda Tachi Ak'õre Jaurepa Jesús wãpiji eujã pania wẽe bɨmaa, Netuara Poro Waibɨapa irumaa ne-inaa k'achia oopi k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mama k'ãima cuarenta nek'o-ee baji. Mapa jarrapisia nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mãga nɨde Netuara Poro Waibɨapa ne-inaa k'achia oopide cheji mãik'aapa mãgaji: —Wãara pɨ Tachi Ak'õre Warra pɨrã, na mãu pan papit'aapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesupa p'anauji: —¡Oo-eda! aji. Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Eperã chik'o k'o bɨpapai chok'ai bak'aa. Tachi Ak'õre pedee k'awa bɨpa ichita chok'ai bapari.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","T'ẽepai Netuara Poro Waibɨapa iru ateeji Jerusalendee, Tachi Ak'õrepa jɨrɨt'erada p'uurudee. Mama Tachi Ak'õre te waibɨa ek'arra ɨ̃rɨ ɨt'ɨ́ ateeji ");
INSERT INTO sjaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","mãik'aapa mãgaji: —Wãara pɨ Tachi Ak'õre Warra pɨrã, namãik'aapa jɨ̃tɨdaipáde aji, Tachi Ak'õre Ũraa p'ãdade jara bairã: ‘Ak'õrepa ichi angeleerã pëiit'ee pɨ k'aripadamerã. Ãchia pɨ jita atadait'ee mãik'aapa pɨ t'ɨdɨk'adait'ee, pɨchi bɨɨrɨ pida mãumaa p'u oopiamaapa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesupa p'anauji: —¡Jɨ̃tɨ-eda! aji. Ichiaba Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Ne-inaa pariatua oonáaji k'awaait'ee wãara Tachi Ak'õre Waibɨapa tachi ak'ɨpari wa mãga-e.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Maap'eda Netuara Poro Waibɨapa iru ee ɨt'ɨara bɨ nok'ode ateeji. Mama ak'ɨpiji jõmaweda na p'ek'au eujãdepema p'uuru, net'aa pi-ia ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mãpai mãgaji: —Pɨta mɨ k'ĩrapite bedabaip'eda, mɨmaa ɨt'aa t'ɨ̃rura, mãgara na jõmaweda përé payada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesupa p'anauji: —¡Oo-eda! aji. Ãyaa wãpáde aji, Satanás. Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Tachi Ak'õre Waibɨamaa aupai ɨt'aa t'ɨ̃patáatɨ mãik'aapa jĩp'a oopatáatɨ irua jara bɨk'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mãpai Netuara Poro Waibɨa ãyaa wãji. Mãga nɨde angeleerã chejida Jesús k'aripade. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesupa ũrik'ãri Juan Bautista carcelde t'ɨ nɨ̃bɨdap'edaa, wãji Galilea eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mamĩda Nazaret p'uurude bana-e paji. Ma k'ãyaara banaji Capernaum p'uurude, lago ik'aawa bɨ Zabulón, Neftalí ëreerã eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mãgá uchiaji Tachi Ak'õre pedee jarapari Isaíapa p'ãdak'a: ");
INSERT INTO sjaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Zabulón ëreerã eujãde mãik'aapa Neftalí ëreerã eujãde, Jordán to k'ĩraik'a eere p'usadee o wãparide, Galilea apata eujãde Israel pidaarã-eerã p'anapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mãpemaarã p'ãriu pɨk'a bɨde p'anapatap'edaa, ɨ̃daa pi-ia unudait'ee. Tachi Ak'õrepa ma ɨ̃daa pëiit'ee chi p'ãriu pɨk'a bɨde p'anɨɨrãmaa atuanaadamerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Maadak'ãriipa Jesupa jarateemaa beeji: —P'ek'au k'achia oo amáatɨ mãik'aapa Tachi Ak'õrede ijãapatáatɨ. Taarã-e nɨde Tachi Ak'õrepa eperãarã bɨ k'inia bɨ ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ewari aba Jesús Galilea Lago ide nipak'ãri, unuji ɨ̃pemaarã omé: Simón; ichiaba t'ɨ̃jarapatap'edaa Pedro mãik'aapa Andrés. To-ɨapataarã paji. Mapa t'ɨrɨ t'aamaa p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ãra unuk'ãri, Jesupa mãgaji: —Mɨ ome nipapatáatɨ mãik'aapa óotɨ mɨa ooparik'a. Idideepa eperãarã jɨrɨdait'ee Tachi Ak'õre-it'ee, to-ɨapataarãpa chik'o jɨrɨpatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aramata ãchi t'ɨrɨ atabëijida mãik'aapa wãjida iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ipu nok'ode Jesupa awaraa ɨ̃pemaarã omé unuji: Santiago mãik'aapa Juan. Zebedeo warrarã paji. Barcode t'ɨrɨ pi-ia p'e bɨmaa p'anajida chi ak'õre ome. Mãga oomaa p'anɨde Jesupa ãchi t'ɨ̃ji ichi ome wãdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aramata chi ak'õre atabëijida barcode mãik'aapa wãjida Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Maapai Jesús Galilea eujã jõmaade nipaji. Tachi Ak'õre pedee jaratee nipapachi judiorã Tachi Ak'õre Ũraa jarateepata te bee chaa. Pedee pia jarateepachi k'awaadamerã taarã-e Tachi Ak'õrepa eperãarã p'e bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã. Ma awara k'ayaa jõmaweda jɨpa nipapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria eujãdepemaarãpa mãga ũridak'ãri, irumaa aneejida k'ayaa beerã k'ĩra t'ãdoo: k'ap'ɨa p'ira-idaa beerã; netuara k'ap'ɨade merãtɨa beerã; wawa beerã; k'ap'ɨa chiwa beerã. Ma k'ayaa jõmaweda Jesupa jɨpapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eperãarã chok'ara iru ome nipapachida: Galilea eujãdepemaarã; Decápolis eujãdepemaarã; Jerusalén p'uurudepemaarã, awaraa Judea eujãdepemaarã ome mãik'aapa Jordán to ak'õrejĩru uchiapari eerepemaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesupa eperãarã chok'ara unuk'ãri, su-ak'ɨ banaji ee bide. Ichi ome nipapataarã wãjida iru k'ait'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mãpai ichia jarateemaa beeji: ");
INSERT INTO sjaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—T'ãri o-ĩa p'anɨ chi chupɨria chedeerã. Tachi Ak'õre k'awa k'inia p'anadairã, ichideerã p'aneedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","T'ãri o-ĩa p'anɨ chi k'ĩsia p'ua p'anɨɨrã, Tachi Ak'õrepa chupɨria k'awaait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","T'ãri o-ĩa p'anɨ chi audua-ee p'anɨɨrã, atadait'ee perã jõmaweda Tachi Ak'õrepa jarada ichideerãmaa teeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","T'ãri o-ĩa p'anɨ chi Tachi Ak'õrepa jara bɨk'a oo k'inia p'anɨɨrã, irua k'aripait'ee perã mãga oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","T'ãri o-ĩa p'anɨ chi awaraarã chupɨria k'awaa p'anɨɨrã, Tachi Ak'õrepa ãchi jida chupɨria k'awaait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","T'ãri o-ĩa p'anɨ chi t'ãri jĩp'a oopataarã Tachi Ak'õrepa k'inia bɨk'a, iru unudait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","T'ãri o-ĩa p'anɨ chi t'ãri auk'a bɨpataarã awaraarã ome mãik'aapa Tachi Ak'õre ome, mãɨrã t'ɨ̃jaradait'ee perã Tachi Ak'õre warrarã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","T'ãri o-ĩa p'anɨ eperãarã awaraarãpa ãchi jɨrɨdak'ãri miapidait'ee, Tachi Ak'õrepa k'inia bɨk'a oopata perã. Ichia ãchi bɨit'ee ichi jua ek'ari ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’T'ãri o-ĩa p'anɨ awaraarãpa parãmaa ik'achia jaradak'ãri, maa-e pɨrã ne-inaa k'achia oodak'ãri, maa-e pɨrã seewadak'ãri parã ɨmɨateedait'ee, mɨde ijãapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mãga oodak'ãri, t'ãri o-ĩa, k'ãiwee p'anéetɨ, Tachi Ak'õre truade panadak'ãri, irua parãmaa ne-inaa pi-ia teeit'ee perã. Mãgá chonaarãweda Tachi Ak'õre pedee jarapataarãmaa ne-inaa k'achia ichiaba oopachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Na p'ek'au eujãdepema ijãadak'aa beerã-it'ee parã t'ã́k'apɨ p'anɨ. K'awa p'anɨ chik'o warraa bɨ t'ã ome. Mamĩda t'ã k'ɨyaa-edaik'ãri, warraa-ee bɨ. ¿Sãga k'ɨyaapii waya? T'ã k'ɨyaa-ee bak'ãri, bat'at'aapata o jãde eperãarã aɨ ɨ̃rɨ t'ɨadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ichiaba na p'ek'au eujãdepema ijãadak'aa beerã-it'ee parã ɨ̃daa pɨk'a p'anɨ. P'uuru ee nok'ode bɨ p'oyaa meradak'aa, p'ãrik'ua chi uchiterree t'ɨmɨɨpa unupata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ichiaba lámpara k'oodak'aa ne-inaa ek'ari mera bɨdait'ee. Ma k'ãyaara k'oodak'ãri, ne-inaa ɨ̃rɨ ɨt'ɨ́ ata bɨpata jõma te jãde p'anɨɨrãpa ɨ̃daa unudamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mãga pɨk'a jɨrɨ́tɨ jõmaarãpa parã ɨ̃daa pɨk'a unudamerã. Mãgá unudak'ãri parãpa t'ãri pia ne-inaa pia oomaa p'anɨ, ɨt'aa t'ɨ̃dait'ee parã Ak'õre Waibɨa ɨt'ari bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—K'ĩsianáatɨ mɨ cheji Moisepa p'ãda maa-e pɨrã Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaa jõpide. Ma k'ãyaara mɨ cheji k'awaapiit'ee mãgɨ́ pedee p'ãda k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mɨa wãarata jararu. Pajã bɨ misa mãik'aapa na p'ek'au eujã bɨ misa, apidaapa ãyaa atada-e pai ma p'ãdadepema letra bɨɨrɨ chak'e apida, Tachi Ak'õrepa ooit'ee bɨ p'asarumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mapa eperãpa Moisepa p'ãdade jara bɨk'a oo-e bɨ pɨrã, ũraa abapai oo-e pɨjida, maa-e pɨrã awaraarãmaa jarateeru pɨrã ma ũraade jara bɨk'a oonaadamerã, mãgɨ́ apemaarã k'ãyaara ek'ariara bait'ee Tachi Ak'õre k'ĩrapite. Jõdee eperãpa ook'ãri ma ũraade jara bɨk'a mãik'aapa awaraarãmaa jarateek'ãri mãga oodamerã, ichi apemaarã k'ãyaara waibɨara bait'ee Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɨa wãarata jararu. Parãpa Tachi Ak'õrepa jara bɨk'a pipɨara ooda-e pɨrã Moisepa p'ãda jarateepataarãpa oopataadai k'ãyaara mãik'aapa fariseorãpa oopataadai k'ãyaara, Tachi Ak'õredeerã p'anada-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Parãpa ũridooda pãchi chonaarãpa ũraapatap'edaa: ‘Eperã peenaadapáde apachida, eperã peeru pɨrã, awaraarãpa charraarãmaa ateedait'ee perã.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mamĩda mɨata jara bɨ: Apida ichi auk'aa ome k'ĩraudaru pɨrã, ma k'ĩrau bɨ charraarãmaa ateedait'ee. Ichiaba apidaapa ichi auk'aamaa ik'achia jararu pɨrã, ma pedee jarada k'aurepa Junta Supremadee ateedait'ee. Ma awara apidaapa ichi auk'aamaa jararu pɨrã: “¡Netuara!” ma pedee k'achia jaradapa atuait'ee tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Maperã parãdepemapa primisia Tachi Ak'õre altarde ateek'ãri, k'irãparu pɨrã pɨchi auk'aapa nepɨra iru bɨ pɨ ome, ");
INSERT INTO sjaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma primisia altar k'ĩrapite atabëipia bɨ. Mãpai wãipia bɨ t'ãri auk'a bɨde pɨchi auk'aa ome. Maap'eda waya chei altarmaa ma primisia teede Tachi Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Eperã nepɨra iru bɨ pɨrã pɨ ome mãik'aapa pɨ charramaa atee k'inia bɨ pɨrã, wãi naaweda t'ãri pia pedeeipia bɨ iru ome t'ãri auk'a bɨdait'ee. Maa-e pɨrã charra k'ĩrapite panadak'ãri, mãgɨpa pɨ ata bɨi jɨ̃apataarã juade carcelde t'ɨ nɨ̃bɨnadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mɨa wãarata jararu. Mamãik'aapa uchia-e pai p'arat'a jõmaweda p'aa-emaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Parãpa ũridooda naawedapemaarãpa ũraapatap'edaa: ‘Miak'ãi p'anɨɨrã awaraarã ome k'ãinaadapáde apachida.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mamĩda mɨata jara bɨ: Eperãpa wẽra unuk'ãri, k'ĩsiaru pɨrã aɨ ome k'ãiit'ee, mãgɨ́ p'ek'au ooji ma wẽra ome, ichi t'ãridepai ooji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Maperã pɨ tau juaraarepema ne-inaa unuda k'aurepa pɨ k'achiade baairu pɨrã, piara bak'aji ma tau ẽt'at'aamerã mãik'aapa t'ɨmɨ́ bat'at'aamerã, ma k'aurepa k'achiade baai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ichiaba pɨ jua juaraarepemapa ne-inaa ooda k'aurepa pɨ k'achiade baairu pɨrã, piara bak'aji ma jua t'ɨap'et'aamerã mãik'aapa t'ɨmɨ́ bat'at'aamerã, k'achiade baai k'ãyaara ma k'aurepa. Piara bɨ pɨchi k'ap'ɨadepema ne-inaa atuamerã, k'ap'ɨa jõmaweda atuai k'ãyaara tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Ichiaba naawedapemaarãpa ũraapachida: ‘Wẽra amaat'aak'ãri, mia amaada k'art'a irumaa p'ã teeipia bɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mamĩda mɨata jara bɨ: Eperãpa ichi wẽra amaat'aaru pɨrã, chi wẽra awaraa ome k'ãi-ee badata, ma wẽramaa p'ek'au oopii, k'ãidarii perã awaraa ɨmɨk'ĩra ome. Ma awara eperãpa wẽra amaat'aada ataru pɨrã ichi wẽra pamerã, ma eperãpa p'ek'au oomaa bɨ awaraa wẽra ome Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Ichiaba ũridooda parã chonaarãpa ũraapatap'edaa: ‘Ichita oodapáde apachida, parãpa juraadap'edaak'a Tachi Ak'õre k'ĩrapite.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mamĩda mɨata jara bɨ: juraanáatɨ ne-inaa apida k'ĩrapite awaraarãpa parã pedee ijãadamerã. Juraanáatɨ Tachi Ak'õre trua k'ĩrapite, iru mama su-ak'ɨ bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ichiaba juraanáatɨ na p'ek'au eujã k'ĩrapite, Tachi Ak'õrepa na p'ek'au eujã ooda perã. Ichiaba juraanáatɨ Jerusalén k'ĩrapite, Jerusalén Tachi Ak'õre, Tachi Rey Waibɨa p'uuru perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma awara juraanáatɨ pãchi poro k'ĩrapite, parãpa puda k'ãu apida p'ãimaapida-e pai perã maa-e pɨrã t'orroopida-e pai perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mãgá ne-inaa k'ĩrapite juraadak'ãri awaraarãpa ma pedee ijãadamerã, ne-inaa k'achia oomaa p'anɨ. Parãpa ne-inaa oodait'ee pak'ãri, jaradaipia bɨ: “Ooit'eeda” adaipia bɨ. Jõdee ne-inaa ooda-e pait'ee pak'ãri, jaradaipia bɨ: “Oo-eda” adaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Parãpa ũridooda naawedapemaarãpa ũraapatap'edaa: ‘Sĩdapa eperã tau ãriru pɨrã, chi sĩda tau auk'a jĩat'aadapáde apachida; ichiaba sĩdapa k'ida k'õradaru pɨrã, chi sĩda k'ida auk'a k'õrat'aadapáde ajida.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mamĩda mɨata jara bɨ: Awaraapa pɨmaa ne-inaa k'achia ooru pɨrã, k'ĩra jõ-ee banáaji mãgɨ́ ome. Ma k'ãyaara pɨchi k'ĩra tarramaa sĩru pɨrã, t'ãri pia chi apema k'ĩra tarra ak'ɨpíji, auk'a sĩmerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ichiaba nepɨrade bɨde awaraapa pɨchi camisa jãri ataru pɨrã, t'ãri pia téeji pɨchi ɨ̃rɨpema p'aru jida. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ichiaba tachi poro waibɨapa ne-inaa chɨk'ɨa uapiru pɨrã kilometro aba, t'ãri pia atéeji kilometro omé. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma awara apidaapa pɨmaa ne-inaa iidiruta pɨrã, téeji mãik'aapa wãak'anáaji ne-inaa presta k'inia p'anadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Ichiaba ũridooda naawedapemaarãpa ũraapatap'edaa: ‘Awaraarã k'inia iru baparíiji mãik'aapa pɨ k'ĩra unuamaa iru p'anapataarã k'ĩra unuamaa iru baparíiji.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mamĩda mɨata jara bɨ: Parã k'ĩra unuamaa iru p'anapataarã k'inia iru p'anapatáatɨ mãik'aapa eperãarãpa parã jɨrɨdak'ãri ne-inaa k'achia oodait'ee, ɨt'aa t'ɨ̃patáatɨ ãra pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mãga ooruta pɨrã, pãchi ɨt'aripema Ak'õre Waibɨa warrarã p'anadait'ee. Irua ak'õrejĩru jẽrapipari jõmaarã ɨ̃rɨ; pia beerã ɨ̃rɨ, k'achia beerã ɨ̃rɨ paara. Ma awara irua k'oi chepipari ichi ũraade jara bɨk'a oopataarãmaa, ichi ũraade jara bɨk'a ooamaa p'anapataarãmaa paara. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Parãpa k'inia iru p'anɨ pɨrã pãchi k'inia iru p'anapataarã aupai, ¿k'ãare-it'ee Tachi Ak'õrepa parã pia ak'ɨima? Romadepemaarã rey-it'ee impuesto p'epataarãpa paara k'inia iru p'anɨ ãchi k'inia iru p'anɨɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma awara parãpa pãchi auk'aarã aupai auteebairuta pɨrã, ¿ne-inaa pipɨara oomaa p'anɨk'ã? Ijãadak'aa beerãpa paara ãchi auk'aarã auteebaipata. ");
INSERT INTO sjaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mãgá eperãarã jĩp'aarãk'a p'anadai k'ãyaara, t'ãri pia p'anapatáatɨ ne-inaa k'achia ooda-ee, pãchi ɨt'aripema Ak'õre Waibɨa baparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—K'ĩrak'aupai awaraarã taide ne-inaa pia oodai Tachi Ak'õre-it'ee, ãchia t'o p'anadamerã. Mãga ooruta pɨrã, parã ɨt'aripema Ak'õre Waibɨapa parãmaa tee-e pait'ee ne-inaa pia ichia k'ĩsia iru bɨ teeit'ee ichideerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Maperã parãdepemapa ne-inaa chupɨria beerãmaa teek'ãri, jõmaarãmaa pɨa ooda jaranáaji. Seewata Tachi Ak'õrede ijãapatada apataarãpa mãga oopata Tachi Ak'õre Ũraa jarateepata tede mãik'aapa calle jãde, eperãarãpa ãchi t'o p'anadamerã. Mɨa wãarata jararu. Ma t'o p'anɨɨrã pedee pia aupai iru p'anadait'ee, Tachi Ak'õrepa ãchimaa tee-e pait'ee perã ne-inaa pia irua k'ĩsia iru bɨdepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ãchia oopata k'ãyaara pɨa net'aa teek'ãri chupɨria beerãmaa, jaranáaji, pɨchi k'õp'ãyo piara bɨmaa paara. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","K'ĩup'ee óoji pɨ ɨt'aripema Ak'õre Waibɨapa unu bairã. Ichiata ne-inaa pia teeit'ee pɨmaa ichia k'ĩsia iru bɨdepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Parãpa ɨt'aa t'ɨ̃dak'ãri, oonáatɨ Tachi Ak'õrede ijãapatada apataarãpa oopatak'a. Tachi Ak'õre Ũraa jarateepata tede jõmaarã taide ãchi ak'ɨnɨ̃ p'aneepata ɨt'aa t'ɨ̃dait'ee. Ichiaba p'uuru jãde plaza bee k'idaa mãga oopata eperãarãpa unudamerã. Mɨa wãarata jararu. Eperãarã pia pedeepata aupai iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maperã pɨ ɨt'aa t'ɨ̃k'ãri, pɨchi cuartode t'ĩ́uji mãik'aapa chi puerta pia jɨ̃́aji. Mãpai ɨt'aa t'ɨ̃́ji pɨchi Ak'õre Waibɨamaa, iru mama bairã pɨ ome. Irua pɨa oomaa bɨ unuk'ãri, ne-inaa pia teeit'ee pɨmaa, ichia k'ĩsia iru bɨdepema ma ne-inaa ichideerãmaa teeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ɨt'aa t'ɨ̃k'ãri, pia-e bɨ ip'ii ichi aɨ pedeeta jara nɨ̃bait'ee. Ijãadak'aa beerãpa mãga oopata, k'ĩsiapata perã audú pedee jõnɨpa Tachi Ak'õrepa audupɨara ũriit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mãɨrãk'a p'ananáatɨ, Tachi Ak'õrepa k'awa bapari perã parãpa falta p'anɨ, iididai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nãga ɨt'aa t'ɨ̃daipia bɨ: ‘Tachi Ak'õre ɨt'ari bɨ, pɨ t'ɨ̃ awaraa t'ɨ̃ k'ãyaara pipɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Eperãarã bɨ́ji pɨchi jua ek'ari pɨchideerã p'aneedamerã. Óoji pɨchia k'inia bɨk'a na p'ek'au eujãde, ɨt'ari ooparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tai-it'ee chik'o téeji ewari chaa k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Taipa p'ek'au k'achia oopata chupɨria k'awáaji mãik'aapa perdonáaji taipa perdonaapatak'a, awaraarãpa taimaa ne-inaa k'achia oodak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tai k'achiade baaipináaji. Tai k'aripa atáji Netuara Poro Waibɨa juadeepa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Parãpa perdonaaruta pɨrã awaraarãpa ne-inaa k'achia oopata parãmaa, Tachi Ak'õre ɨt'ari bɨpa ichiaba perdonaait'ee parãpa ne-inaa k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mamĩda parãpa perdonaada-e p'anɨ pɨrã awaraarãpa ne-inaa k'achia oopata parãmaa, mãgara Tachi Ak'õrepa ichiaba perdonaa-e parãpa ne-inaa k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Parã nek'oda-ee p'anadak'ãri jĩp'a k'ĩsiait'ee Ak'õre net'aade, k'ĩra pia-ee p'ananáatɨ Ak'õrede ijãapatada apataarãpa oopatak'a. Mãga nipapata awaraarãpa k'awaadamerã nek'oda-ee p'anɨ, mãik'aapa ãchi t'o p'anadamerã. Mɨa wãarata jararu. Mãgapai iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pɨ ɨt'aa t'ɨ̃ bak'ãri nek'o-ee, k'ĩra sɨ́ɨji mãik'aapa t'ɨ̃-irúji ");
INSERT INTO sjaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","apidaapa k'awanaadamerã pɨ nek'o-ee bɨ. Eperãarãpa pɨ ɨt'aripema Ak'õre Waibɨa p'oyaa unuda-e p'anɨ mĩda, irua k'awa bɨ pɨa ne-inaa mera oo bɨ, pɨ ome bairã. Ma pari iruata ne-inaa pia teeit'ee pɨmaa ichia k'ĩsia iru bɨdepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—P'arat'a, net'aa pia p'enáatɨ na p'ek'au eujãde p'anɨ misa iru p'anadait'ee, polillapa ma net'aa ãrit'aai perã, maa-e pɨrã mogosiadarii perã taarã ɨa iru bɨpa, maa-e pɨrã nechɨapataarãpa chɨa atadaridai perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma k'ãyaara jɨrɨ́tɨ ɨt'aripema ne-inaa iru p'anadait'ee, mãpema ne-inaa polillapa ãrik'aa perã, mogosiak'aa perã mãik'aapa nechɨapataarã mama t'ĩudak'aa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Na p'ek'au eujãdepema ne-inaa pia audú ata k'inia bak'ãri, pɨ t'ãri araa bait'ee ma ne-inaa ome. Jõdee ɨt'aripema ne-inaa pia audú ata k'inia bak'ãri, pɨ t'ãri araa bait'ee mãgɨ́ ne-inaa ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Tachi tau lamparak'a ɨ̃daa pɨk'a bɨ tachi k'ap'ɨa-it'ee. Pɨchi tau pia bak'ãri, k'ap'ɨa jõmaweda ɨ̃daa pɨk'a bɨde bait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mamĩda pɨchi tau k'achia bɨ pɨrã, k'ap'ɨa jõmaweda p'ãriu pɨk'a bɨde bait'ee. Mãgá pɨ k'ap'ɨade ɨ̃daa pɨk'a bɨ wãara p'ãriu pɨk'a bɨ pɨrã, audupɨara p'ãriu pɨk'a bɨde bait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Eperã chipariirã omé jua ek'ari mimia baik'araa bɨ. Mãga bɨ pɨrã, chipari aba k'ĩra unuamaa iru bai mãik'aapa chi apema k'inia iru bai, maa-e pɨrã abaapa jara bɨk'a ooi mãik'aapa chi apemapa jara bɨk'a ooamaa bai. Mãga pɨk'a apidaapa ooda-e pai Tachi Ak'õrepa jara bɨk'a, p'arat'a, net'aa pia p'e bɨ misa. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Maperã mɨa jara bɨ: K'ĩsia jõnanáatɨ k'ãata k'odait'ee maa-e pɨrã todait'ee, mãgá chok'ai p'anadait'ee. Ichiaba k'ĩsianáatɨ sãga p'aru atadait'ee. Tachi Ak'õrepa parã k'ap'ɨa ooji mãik'aapa parã chok'ai p'anapiji. Mãga bɨta, ¿p'aru tee-e paik'ã mãik'aapa chik'o, ne-inaa toparii tee-e paik'ã parãmaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ak'ɨ́tɨ, ipanaarã ɨt'ɨ́ wãabai p'anɨ. Ãchia net'atau uudak'aa, ewadak'aa mãik'aapa ɨa bɨdak'aa chi net'atau ɨapatamãi. Mamĩda parã ɨt'aripema Ak'õre Waibɨapa ne-inaa teepari k'odamerã. ¡Iru-it'ee parã pipɨara p'anɨ ipanaarã k'ãyaara! ");
INSERT INTO sjaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eperã audú k'ĩsia nɨ̃bɨpa hora aba pida waa chok'ai ba-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ma awara ¿k'ãare-it'ee parã audú k'ĩsiapata p'aru-it'ee? Ak'ɨ́tɨ, sãga nep'ono p'ũajara t'ãide nɨ̃bɨ waripata. Mimiadak'aa mãik'aapa p'aru k'adak'aa mãgá pi-ia p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mamĩda mɨa jara bɨ: Rey Salomonpa p'arat'ara, net'aa pia iru bapachi mĩda, iru p'aru piara jɨ̃ bak'ãri, eperãarãpa iru pi-iara unuda-e paji nãgɨ́ nep'ono k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Idi na p'ũajara wari wã. Mamĩda nu uratɨdaik'ãri, t'ɨpɨtaude paa jõdariit'ee. Tachi Ak'õrepa mãgá pia ak'ɨ bɨ pɨrã nep'ono p'ũajara t'ãide nɨ̃bɨ, audupɨara parã ak'ɨ bapariit'ee, at'ãri irude mak'ɨara ijãada-e p'anɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tachi Ak'õrepa mãgá ichia ooda pia ak'ɨ bapari perã, k'ĩsia jõnanáatɨ: “¿K'ãata k'odait'ee?” maa-e pɨrã “¿K'ãata todait'ee?” maa-e pɨrã “¿K'ãata jɨ̃dait'ee?” ");
INSERT INTO sjaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mãgá k'ĩsiapata ijãadak'aa beerãpa. Mamĩda parã́pata ɨt'aripema Ak'õre Waibɨa iru p'anɨ. Irua k'awa bɨ ne-inaa parãpa falta p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Maperãpɨ naapɨara jɨrɨ́tɨ iru jua ek'ari p'anapataadait'ee mãik'aapa oopatáatɨ irua jara bɨk'a. Mãga ooruta pɨrã, ma ne-inaa jõma iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Audú k'ĩsianáatɨ nupema ne-inaade, nu ne-inaa paraait'ee perã aɨde k'ĩsiadamerã. Ewari chaa ne-inaa audupai paraa aɨde k'ĩsiadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Awaraarãpa ne-inaa oopata ak'ɨnáatɨ jaradait'ee ne-inaa k'achia oomaa p'anɨ. Mãga ooruta pɨrã, ma jaradap'edaa k'aurepa Tachi Ak'õrepa parã mãgá ak'ɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Parãpa awaraarãpa oo p'anɨ ak'ɨpatak'a, mãgá Tachi Ak'õrepa ak'ɨpariit'ee parãpa oo p'anɨ. Ne-inaa k'achia aupai jɨrɨruta pɨrã pedee k'achia jaradait'ee ãra ãpɨte, Tachi Ak'õrepa auk'a jɨrɨit'ee parãpa ne-inaa k'achia oopata aupai jarait'ee iru k'ĩrapite p'anadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿K'ãare-it'ee ak'ɨ bɨma nejarra pɨchi auk'aa tau jãde bɨ, mamĩda unu-e bɨ pak'uru pɨchi tau jãde bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pɨchi tau jãde pak'uru iru bɨ pɨrã, ¿sãga pɨchi auk'aamaa jaraima: “Mɨmaa ẽepíji jã nejarra pɨchi tau jãde bɨ”? ");
INSERT INTO sjaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Seewata pɨa chĩara k'aripa k'inia bɨ, irua oo bɨ ak'ɨk'ãri! Pɨchi tau jãde bɨ pak'uruta naapɨara ẽt'at'áaji. Mãpaipɨ unui nejarra pɨchi auk'aa tau jãde bɨ, mãgá wãara iru k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Net'aa awara bɨdap'edaa Tachi Ak'õre-it'ee teeruta pɨrã usa k'achia beemaa, orradaidap'eda k'aak'oodai. Ma awara ne-inaa ɨ̃pɨa perlak'a atabëiruta pɨrã sinaarã p'anɨmãi, yoorode jaut'aadai. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Iidipatáatɨ Tachi Ak'õremaa. Irua teeit'eepɨ. Jɨrɨpatáatɨ. Irua k'awapiit'eepɨ. Eperãpa t'ɨ̃parik'a puerta t'aide, Ak'õremaa t'ɨ̃patáatɨ. Irua parã k'aripait'eepɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi iidi bɨmaa Tachi Ak'õrepa teepari; chi jɨrɨ bɨmaa Tachi Ak'õrepa k'awapipari mãik'aapa chi t'ɨ̃ bɨmaa ewapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Parãdepemapa mãu teeik'ã ichi warramaa, irua pan iidik'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Maa-e pɨrã, ¿taama teeik'ã irumaa, chik'o iidik'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","¡Mãga-epɨ! Parã ne-inaa k'achia oopataarã mĩda, pãchi warrarãmaa net'aa pia tee k'awa p'anɨ. Parãpa mãga ooruta pɨrã, ¡audupɨara pãchi ɨt'aripema Ak'õre Waibɨapa ne-inaa pia teeit'ee chi iidirutaarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Maperã, óotɨ apemaarãmaa parãpa k'inia p'anɨk'a ãchia parãmaa oodamerã, mãgata jara bairã Moisepa p'ãdade mãik'aapa Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaade. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Tachi Ak'õre truadee wãit'ee puerta p'ĩrup'ee bɨde t'ĩupaták'ata bɨ. Mapa t'ĩ́utɨ puerta p'ĩrup'ee bɨde, chi atua beerã puerta jet'ee bapari perã. Ichiaba ãchi o k'achia ewaraa k'obɨ, chok'ara aɨde wãpata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wãit'ee eperãarã ichita p'anapatamãi Tachi Ak'õre ome puerta p'ĩrup'ee bɨde t'ĩupaták'ata bɨ mãik'aapa Ak'õre o p'ĩrup'ee bapari, mãgɨde chok'ara-ee wãpata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—K'ĩrak'aupai ijãadai jõmaweda Tachi Ak'õre pedee jarapatada apataarãde, mãɨrã ũk'uru seewa-idaa bee perã. Seewata eperã pia beerãk'a parãmaa chepata. Mamĩda ãchi t'ãride k'ĩsia k'achia iru p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Parãpa mãɨrã k'awaadai ãchia oopata pia ak'ɨdak'ãri. Pak'uru ɨɨrɨ-idaa bɨde uva chauk'aa; ichiaba mãgeede higojõ chauk'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma awara nejõ bɨɨrɨ pia bɨpa nejõ pia chaupari. Mamĩda nejõ bɨɨrɨ k'achia bɨpa nejõ k'achia chaupari. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nejõ k'achia chauk'aa pak'uru pia bɨde. Ichiaba nejõ pia chauk'aa pak'uru k'achia bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Maperã pak'uru nejõ pia chauk'aa bee t'u peepata t'ɨpɨtaude bat'at'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mãgá ma Ak'õre pedee jarapatada apataarãpa ne-inaa oopata k'aurepa parãpa k'awaadai wãara Ak'õrepa pëida wa mãga-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Eperãarã ũk'uruurãpa mɨmaa: “Tachi Waibɨa, Tachi Waibɨa” a p'anɨ mĩda, jõmaweda wãda-e pait'ee Tachi Ak'õre truadee. Jĩp'a chi oopataarãpa mɨ Ak'õre ɨt'ari bɨpa oopi bɨk'a; mãgɨɨrãta ɨt'aa wãdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ak'õre ewari waibɨa ewate chok'araarãpa mɨmaa jaradait'ee: “Tachi Waibɨa, Tachi Waibɨa, tai pɨ ome p'anapíji. Taipa pɨ t'ɨ̃de jarateejida mãik'aapa pɨ t'ɨ̃de netuaraarã uchiapik'oojida. Ma awara pɨ t'ɨ̃de oojida ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mamĩda mɨa p'anaut'ee: “¡Mɨa parã k'awa-e bɨ! ¡Ãyaa wã́tɨ mɨ ik'aawaapa, ne-inaa k'achia oopataarã!” ");
INSERT INTO sjaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Eperã k'ĩsia k'awaa bɨpa mɨ ũraa ũripari mãik'aapa oopari mɨa jara bɨk'a. Mãgɨ́ eperã ichi te oo bɨ́k'ata bɨ mãu ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","K'oi cheji; to chedachi mãik'aapa nãu golpe p'uaji ichi temãi. Mamĩda t'ee-e paji mãu ɨ̃rɨ oo bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jõdee chi mɨ ũraa ũrip'eda, oo-e bɨpa mɨa jara bɨk'a k'ĩsia k'awa-ee bɨ. Eperã ichi te ipude oodak'a bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","K'oi cheji; to chedachi; nãu golpe p'uaji mãik'aapa ichi te tudú t'eedachi. Mãgá ichi te jõdachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús pedee aupak'ãri, eperãarã jõmaweda ak'ɨtrua para beeji irua jarateeda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mãga p'anajida irua jĩp'a jarateeda perã Tachi Ak'õrepa jarateepidak'a. Ak'õre Ũraa pipɨara jarateeji Moisepa p'ãda jarateepataarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús eedeepa edaa chek'ãri, eperãarã chok'ara iru t'ẽe chejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mãgá che wãde iru k'ait'a cheji eperã leprapa k'ayaa bɨ. Mãgɨ́ iru k'ĩrapite bedabai nɨ̃ba cheji mãik'aapa mãgaji: —Tachi Waibɨa, pɨa k'inia bɨ pɨrã, mɨ k'ayaa wẽpapipáde aji, Ak'õre k'ĩrapite mɨ pia beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesupa juapa t'õbaip'eda, mãgaji: —¡K'inia bɨda! aji. Jɨpa beepáde aji. Aramata jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mãpai Jesupa mãgaji: —¡Ũríji! Jaranáaji apidaamaa. Jĩp'a p'aaremaa ak'ɨpináji mãik'aapa Moisepa p'ãdade jara bɨk'a ipana omé atéeji teeit'ee Tachi Ak'õremaa. Mãgá jõmaarãpa pɨ jɨpa beeda k'awadayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","T'ẽepai Jesús Capernaum p'uurude panak'ãri, Romadepema soldaorã poro waibɨapa irumaa chupɨria iidi cheji: ");
INSERT INTO sjaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Jesús, mɨ mimiapari k'ayaa bɨda aji. P'oyaa mimik'a-e bɨ mãik'aapa chupɨria nɨ̃bɨda aji, p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesupa p'anauji: —Wãit'eeda aji, jɨpade. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mamĩda ma soldaorã poro waibɨapa mãgaji: —Tachi Waibɨa, mɨ pɨ k'ãyaara ek'ariara bɨ. Pɨ mɨ temaa wã-e pɨjida, namãik'aapa pedeeru pɨrã, mɨ mimiapari jɨpa beeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mɨ jida waibɨarã jua ek'ari bɨ. Ma awara mɨa soldaorã iru bɨ mɨchi jua ek'ari. Mɨa abaamaa wãpáde ak'ãri, wãpari; awaraamaa chepáde ak'ãri, chepari. Ichiaba mɨ mimiaparimaa ne-inaa oopáde ak'ãri, oonaparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesupa mãga ũrik'ãri, p'era pɨk'a beeji ma soldaorã poropa jara bada k'aurepa. Mapa ichi ome nipapataarãmaa mãgaji: —Mɨa wãarata jararu. Israel pidaarã t'ãide na eperãk'a apida waide unu-e bɨ, iru wãara ijãapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eperãarã chok'ara chedait'ee ak'õrejĩru uchiapari eereepa mãik'aapa ak'õrejĩru baaipari eereepa. Mãɨrãta Tachi Ak'õre truade su-ak'ɨ p'ana chedait'ee nek'ode Abraham ome, Isaac ome mãik'aapa Jacob ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mamĩda chi ɨt'ari p'anadaipia bɨɨrã Ak'õrepa jërek'ooit'eeda aji, taawaa p'ãriudee, atua beerã ome jẽedamerã mãik'aapa k'ida kierrkierree para bamerã p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mãga jarap'eda, Jesupa ma soldaorã poromaa mãgaji: —Wãpáde aji, pɨchi temaa pɨa ijãadak'a uchiada perã. Aramata chi k'ayaa bada jɨpadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mãpai Jesús wãji Pedro temaa. Mama ununaji Pedro p'ãk'õre k'ayaa bɨ k'ɨamiapa. P'arude baji k'ayaa bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesupa iru jua t'õbaik'ãri, ma k'ɨamia tuudachi. Mãpai ma wẽra p'irabaidaip'eda, nek'opiji Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","K'eudaik'ãri, netuara k'ap'ɨade merãtɨa beerã chok'ara aneejida Jesumaa. Pedee jarada abaapa netuaraarã jõmaweda uchiapik'ooji. Ichiaba k'ayaa beerã jõmaweda jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mãga ooji p'asamerã Tachi Ak'õre pedee jarapari Isaíapa chonaarãweda jaradak'a: ‘Irua k'ayaa tachimaa baridap'edaa awara ãyaa ataji mãik'aapa tachi k'ayaa beerã jɨpaji.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Awaraa ewaride Jesupa unuk'ãri eperãarã chok'ara ichi wap'ɨra iru p'anɨ, chi k'õp'ãyoorãmaa jaraji sĩadait'ee lago k'ĩraik'a eeree. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mamĩda wãdai naaweda, Moisepa p'ãda jarateepari k'ait'a cheji mãik'aapa mãgaji: —Tachi Jarateepari, pɨ ome wã k'inia bɨda aji, chi wãrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesupa p'anauji: —Usap'ã́ yooro te uria iru bee mãik'aapa ipanaarã te iru bee. Mamĩda mɨ, chi Eperã Ak'õre Truadepema arajãgaa ni, k'ãipari wẽe. Made k'ĩsíaji jarai naaweda wãara mɨ ome nipa k'inia bɨ wa mãga-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Awaraa Jesús ome nipadapa mãgaji: —Tachi Waibɨa, mɨ jida pɨ ome nipaparii k'inia bɨ. Mamĩda aɨ naaweda, mɨ ak'õre ɨapipáde aji, iru piuk'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesupa p'anauji: —Chepáde aji, mɨ ome mãik'aapa ichiak'au bɨpáde aji, atuadait'eerãpa ãchi piudap'edaarã ɨadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma t'ẽepai Jesús wãji barcode chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mãga nɨde p'usara t'o nɨ̃beeji. P'usapa barco pirubaai wã nipaji. Mãɨmisa Jesús k'ãi baji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mapa chi k'õp'ãyoorãpa ɨ̃rɨmat'aajida mãik'aapa mãgajida: —Tachi Waibɨa, ¡tai k'aripáji! ¡Tachi pirubaai wãdapɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesupa p'anauji: —¿Sãap'eda p'era jõnɨma? aji. ¡Parã pia ijãada-e p'anɨda! aji. Mãga jarap'eda, p'irabaidachi mãik'aapa pedeeji nãumaa mãik'aapa p'usamaa. Aweda jõma ip'ii ũu beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mãga unudak'ãri, chi k'õp'ãyoorã ak'ɨtrua para beeji mãik'aapa ãchi pitapai iidi para beeji: —¿K'aima ajida, nãgɨ́? Nãu, p'usa paara iru pedee ũripatada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús chi k'õp'ãyoorã ome panadak'ãri lago k'ĩraik'a eere Gadara eujãde, jãɨra mãu te uriade badadeepa uchiajida eperãarã omé netuara ãchi k'ap'ɨade merãtɨa bee. Ma eperãarã Jesús k'ait'a chejida. Ãchi audú t'ãri k'achia-idaa p'anadap'edaa perã, eperãarã ma ode p'oyaa wãyaadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesumaa bia chejida: —¡Jesús, Ak'õre Waibɨa Warra, tai ome t'ĩunáaji! ¿At'ãri-e weda tai miapide cheji-ek'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma k'ait'a sinaarã chok'ara nek'omaa p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mapa netuaraarãpa Jesumaa chupɨria iidijida ma sinaarã k'ap'ɨade t'ĩupimerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aramãgá Jesupa jaraji mamaa wãdamerã. Mãpai ma netuaraarã ma eperãarã k'ap'ɨadeepa uchiak'oodachida mãik'aapa sinaarã k'ap'ɨade t'ĩudachida. Aramata sinaarã jõmaweda p'irak'oodachida ee k'õot'ari jira bɨdee. Mata lagode baainajida mãik'aapa ɨ̃yapa jɨ̃ak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma sinaarã jɨ̃a p'anadap'edaarãpa mãga unudak'ãri, p'irak'oodachida p'uurudee. Nepɨrɨnajida ãchia unudap'edaa ma netuara merãtɨa p'anadap'edaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mãpai p'uuru pidaarã jõmaweda chejida mãik'aapa Jesumaa chupɨria iidijida ãchi eujãdeepa wãmerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ma t'ẽepai, Jesús barcode bataup'eda, wãji lago k'ĩraik'a eeree. Mãgá ichi p'uurude pacheji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mama bɨde eperãarãpa jira aneejida eperã chiwa bɨ p'arude. Jesupa k'awaak'ãri ãchia wãara ichide ijãa p'anɨ, ma chiwa bɨmaa mãgaji: —Warra, t'ãri o-ĩa báji pɨa p'ek'au k'achia oopata jõmaweda wẽpada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ũk'uru arii p'anadap'edaa Moisepa p'ãda jarateepataarãpa mãga ũridak'ãri, k'ĩsiajida: “Jãgɨpa ik'achia pedeemaa bɨ Tachi Ak'õre ãpɨte. Tachi Ak'õrepapai p'ek'au k'achia wẽpapiyada” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mamĩda Jesupa k'awaji ãchia k'ĩsia p'anɨ. Mapa iidiji: —¿Sãap'eda parãpa k'ĩsia k'achia k'ĩsia p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mɨa irumaa jarai: “Pɨa p'ek'au k'achia oopata wẽpajipɨ” maa-e pɨrã jarai: “P'irabáiji mãik'aapa wã́ji”. Mamĩda irua maarepida oo-e pai, Tachi Ak'õrepa oopi-e pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mɨa ak'ɨpiit'ee na p'ek'au eujãde mɨ, chi Eperã Ak'õre Truadepema k'ap'ɨa pari, Tachi Ak'õre Waibɨapa wẽpapipari eperãarãpa p'ek'au k'achia oopata. Mãpai mãgaji ma eperã chiwa bɨmaa: —¡P'irabáiji! Pɨchi p'aru atáji mãik'aapa wã́ji pɨchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aramãgá ma chiwa bada p'irabaidachi mãik'aapa wãji ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mãga unudak'ãri, eperãarã p'era pɨk'a para beeji mãik'aapa Tachi Ak'õremaa o-ĩa ɨt'aa t'ɨ̃jida, irua ma eperãmaa mãga ooda perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mamãik'aapa Jesús wãji. Ma wãrude eperã t'ɨ̃jarapatap'edaa Mateo unuji. Su-ak'ɨ baji Cesar-it'ee impuesto p'aapatamãi. Jesupa mãgaji irumaa: —Mɨ ome nipaparíiji. Aramãgá bainɨ̃ beep'eda, Jesús ome wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","T'ẽepai Jesús chi k'õp'ãyoorã ome teeda nek'omaa bak'ãri, impuesto p'epataarã Roma pidaarã rey-it'ee pachejida awaraa eperãarã k'achia-idaa beerã apatap'edaarã ome. Mãɨrã aɨ mesade su-ak'ɨ p'aneejida Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseorãpa mãga unudak'ãri, Jesús k'õp'ãyoorãmaa iidijida: —¿Sãap'eda parã jarateepari nek'omaa bɨma ajida, impuesto p'epataarã ome mãik'aapa awaraa p'ek'au k'achia oopataarã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mãɨrãpa iididap'edaa ũrik'ãri, Jesupa mãgaji: —Médico pëidak'aa k'ap'ɨa pia beerãmaa. Jĩp'a pëipata k'ayaa beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Parã wãdak'ãri, k'ĩsiadapáde aji, nãgɨ́ Ak'õre Ũraa jara k'inia bɨ: ‘Mɨa k'iniara bɨ awaraarã chupɨria k'awaadamerã, ne-animalaarã peedap'eda, paadai k'ãyaara mɨ-it'ee.’ Mãpai Jesupa mãgaji: —Tachi Ak'õrepa mɨ pëi-e paji t'ãri pia beerã jɨrɨde. Ma k'ãyaara p'ek'au k'achia oopataarã jɨrɨdeta pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mãpai Juan Bautista k'õp'ãyoorã Jesumaa chejida mãik'aapa iidijida: —Edaare tai, fariseorã ome nek'oda-ee p'aneepata jĩp'a Tachi Ak'õre net'aade k'ĩsiadait'ee. ¿Sãap'eda pɨ k'õp'ãyoorãpa mãga oodak'aama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesupa p'anauji: —Miak'ãipata fiestade t'ɨ̃ pëidap'edaarã k'ĩra pia-ee p'anadak'aa chi miak'ãiit'ee bɨ ãchi ome bɨ misa. Mamĩda ewari cherude iru ata chedak'ãripɨ, t'ãri p'uapa nek'oda-ee p'aneedait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Eperã apidaapa p'aru chiwididepema pite aba t'ɨɨik'araa bɨda aji, p'aru sorede parchaait'ee. Mãga ooru pɨrã, chi p'aru chiwidi ãridariit'ee mãik'aapa ma pite auk'a bee-e pait'ee chi p'aru sore ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ichiaba vino ewaa juda t'ɨdak'aa ne-e sorede, ma vino baak'ak'ãri, ma ne-e sore jĩadarii perã mãik'aapa chi vino atuadarii perã. Maperã vino ewaa juda t'ɨdaipia bɨ ne-e chiwidide, ma ne-e chi vino ome atuapiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús at'ãri pedeemaa bɨde, judiorã poro waibɨa t'ɨ̃jarapatap'edaa Jairo Jesús k'ĩrapite bedabai nɨ̃ba cheji mãik'aapa mãgaji: —Et'ewapai mɨ k'au jai-idaajida aji. Mamĩda mɨa k'awa bɨ pɨ cheru pɨrã mɨ ome mãik'aapa pɨ jua bɨru pɨrã iru ɨ̃rɨ, waya chok'ai beeyada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mãpai Jesús wãji chi k'õp'ãyoorã ome ma eperã temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma wãdade wẽra doce años bi k'ayaa bɨ waamiapa Jesús ãpɨteik'aapa k'ait'a wãp'eda, iru ɨ̃rɨpema p'aru i t'õbait'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mãga ooji k'ĩsia bada perã iru p'aru i t'õbairupapai jɨpa beei. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mamĩda mãgá t'õbaik'ãri, Jesupa ãpɨtee ak'ɨji mãik'aapa mãgaji ma wẽramaa: —Wẽra, t'ãri o-ĩa béeji. Pɨa mɨde ijãa bairã, jɨpa beejida aji. Aramata ma wẽra jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Maap'eda Jesús ma judiorã poro waibɨa temaa panak'ãri, unuji siru chaapataarã mãik'aapa eperãarã jẽepi ororoo nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mãpai Jesupa mãgaji: —Taawaa uchíatɨ. Na wẽra k'au jai-idaa-e bɨ. Jĩp'a k'ãita bɨda aji. Mãga ũridak'ãri, arii p'anadap'edaarã ëik'oodachida, Jesús k'ĩra k'awa-ee bɨ jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mamĩda Jesupa eperãarã uchiapik'ooji mãik'aapa jai-idaada badamãi t'ĩup'eda, iru jua jita atanaji. Mãpai ma wẽra k'au p'irabaidachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Maap'eda ma eujãdepemaarã jõmaarãpa k'awaa wãjida Jesupa mãga ooda. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mamãik'aapa uchia wãdade, Jesús t'ẽe tau p'ãriu bee omé bia che wãpachida: —¡Rey David Warra, tai chupɨria k'awaapáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús teeda t'ĩunak'ãri, ma tau p'ãriu beerã auk'a t'ĩujida. Mãpai Jesupa iidiji: —¿Parãpa ijãa p'anɨk'ã aji, mɨa jɨpai? P'anaujida: —Tachi Waibɨa, ijãa p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mãpai Jesupa taumãi t'õbaip'eda, mãgaji: —Parãpa ijãa p'anɨk'a, mãgá p'aneedapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aweda tau eratɨk'oodachida. Mãpai Jesupa jĩp'a mãgaji: —Mɨa ooda chĩaramaa nepɨrɨnaadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mãga jaraji mĩda, mamãik'aapa uchiarutata Jesupa ooda nepɨrɨ wãpachida ma eujãdepemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma tau p'ãriu p'anadap'edaarã uchiarutade, eperãarãpa aneejida eperã pedee atua bɨ Jesumaa. Mãga baji netuara ichi k'ap'ɨade merãtɨa bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesupa ma netuara uchiapit'aak'ãri, ma eperã pedee beeji. Mãga unudak'ãri, arii p'anadap'edaarãpa ak'ɨtrua para beeji mãik'aapa mãgajida: —¡Israelde waide nãga unudak'aada! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mamĩda fariseorãpa mãgajida: —Netuara Poro Waibɨa juapata jãgá netuaraarã uchiapiparida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús nipapachi p'uuru beede mãik'aapa aɨ ik'aawa p'uuru k'aipee beede. Tachi Ak'õre Ũraa jarateepata te chaa pedee pia jarateepachi k'awaadamerã taarã-e Tachi Ak'õrepa eperãarã p'e bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã. Ma awara k'ayaa k'ĩra t'ãdoo jɨpapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eperãarã chok'ara see nɨ̃bɨ unuk'ãri, chupɨria k'awaaji, ãra chupɨria, k'ĩra pia-ee para bada perã, oveja chak'eerã ak'ɨpari wẽe chitoonɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mãpai chi k'õp'ãyoorãmaa mãgaji: —Eperãarã chok'ara mɨde waide ijãada-e p'anɨ. Ne-uu audú chau bɨ́k'apɨ p'anɨ. Mamĩda mimiapataarã chok'ara-ee p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mapa ɨt'aa iididapáde aji, ma ne-uu chiparimaa, irua awaraa mimiapataarã pëimerã chi chau bɨ p'ede. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesupa chi k'õp'ãyoorã doce t'ɨ̃ p'eji mãik'aapa ãchi ichi jua ek'ari bɨji netuaraarã uchiapidamerã mãik'aapa k'ayaa k'ĩra t'ãdoo jɨpadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nãgɨ́ ɨmɨk'ĩraarã doce jɨrɨt'eraji pëiit'ee ichi ũraa jarateede. Naapɨara jɨrɨt'eraji Simón, ichiaba t'ɨ̃jarapatap'edaa Pedro, chi ɨ̃pema Andrés ome. Ma t'ẽepai jɨrɨt'eraji Santiago chi ɨ̃pema Juan ome. Mãɨrã Zebedeo warrarã paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ichiaba jɨrɨt'eraji Felipe; Bartolomé; Tomás; mɨ, Mateo, chi impuesto p'epari bada Roma pidaarã-it'ee; Alfeo warra, Santiago; Tadeo; ");
INSERT INTO sjaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón Celote apatap'edaa mãik'aapa Judas Iscariote, ma t'ẽepai Jesús traicionaada. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesupa ma k'õp'ãyoorã doce pëiji eperãarã paraamaa. Pëi naaweda jaraji: —Wãnáatɨ judio-eerã p'anapatamaa. Ichiaba wãnáatɨ Samaria eujãdepema p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma k'ãyaara wã́tɨ Israel eujãdepema ovejaarã atua pɨk'a beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jaratéetɨ taarã-e Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨit'ee ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","K'ayaa beerã jɨpátɨ; piudap'edaarã chok'ai p'irabaipítɨ; leprapa k'ayaa beerã jɨpátɨ mãik'aapa netuara k'ap'ɨade merãtɨa bee jɨpátɨ. Mɨa parã mɨchi jua ek'ari bɨk'ãri mãga oodamerã, p'arat'a maarepida iidi-e paji. Mapa p'arat'a iidináatɨ ma pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ateenáatɨ nẽe, p'arat'a, cobre, pãchi k'ɨrrɨde jɨ̃pata. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ichiaba ateenáatɨ muchila, awaraa chancla mãik'aapa p'aru jɨ̃dait'ee, pak'uru jida t'ɨdɨk'adait'ee, parã mimia pari ma ne-inaa teedaipia p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’P'uurude maa-e pɨrã te chok'ara-ee beemãi panadak'ãri, eperã t'ãri piata jɨrɨ́tɨ arii p'aneedait'ee mamãik'aapa wãruta misa. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Teeda t'ĩudak'ãri, arii p'anɨɨrãmaa pedee pia jarátɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aɨ tede p'anɨɨrãpa parã auteebairuta pɨrã, ma pedee pia jaradak'a ãramaa uchiait'ee. Mamĩda auteebaida-e pɨrã, ma pedee pia jaradak'a ãramaa uchia-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Parã auteebaida-e pɨrã mãik'aapa parãpa jarateepata ũridaamaa p'anɨ pɨrã, uchíatɨ ma tedeepa maa-e pɨrã ma p'uurudeepa mãik'aapa bɨɨrɨdepema yooro p'ora nẽep'étɨ ak'ɨpidait'ee Tachi Ak'õrepa ãra k'aripa-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mɨa wãarata jararu. Tachi Ak'õre ewari waibɨa ewate irua ma p'uurudepemaarã audupɨara k'achia ooit'eeda aji, Sodoma p'uurudepemaarã, Gomorra p'uurudepemaarã k'achia ooda k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—¡Ũrítɨ! Mɨa parã pëiru eperãarãmaa jarateede. Pëiru ovejaarã pëik'ajik'a ne-animalaarã k'achia beerã t'ãide. Mapa k'ĩra k'awaa nipapatáatɨ, taama k'ĩra k'awaa nipaparik'a. Ichiaba k'ãiwee nipapatáatɨ paloma nipaparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tauk'a nipapatáatɨ eperãarãpa parã ateedait'ee perã ãchi charraarãmaa miapidamerã, maa-e pɨrã parã p'ua oodait'ee Tachi Ak'õre Ũraa jarateepata tede. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma awara mɨde ijãapata k'aurepa ateedait'ee ãchi poro waibɨarãmaa mãik'aapa ãchi reyrãmaa. Mãgá parãpa mɨ ũraa jaradai mãɨrã k'ĩrapite mãik'aapa awaraa ijãadak'aa beerã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mamĩda mãɨrã k'ĩrapite p'anadak'ãri, k'ĩsianáatɨ sãga pedeedait'ee, maa-e pɨrã k'ãata jaradait'ee, pedeedait'ee pak'ãri, Tachi Ak'õrépata pedeepiit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Parã pedeeda-e pait'ee pãchi k'ĩradoopa. Tachi Ak'õre Jaurepata pedeeit'ee parã k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Maapai eperãarãpa ãchi ɨ̃pemaarã paara teedait'ee miapidamerã piurutamaa. Ma awara chi ak'õreerãpa ãchi warrarã paara mãgá peepidait'ee; maa-e pɨrã warrarãpa ãchi ak'õreerã peepidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jõmaarãpa parã k'ĩra unuamaa iru p'anapataadait'ee mɨde ijãapata k'aurepa. Mamĩda t'ãridepai chooruta pɨrã, Tachi Ak'õrepa parã k'aripait'ee atuanaadamerã na p'ek'au eujã jõrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","P'uuru abaade parã jɨrɨ p'aneedak'ãri, mirútɨ awaraa p'uurude. Mɨa wãarata jararu. Parã Israel p'uuru jõmaade jaratee nipadai naaweda, mɨ, chi Eperã Ak'õre Truadepema, cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’K'irãpátɨ eperã apida ichi jarateepari k'ãyaara waibɨara bɨ-e. Ichiaba mimiapari apida chipari k'ãyaara waibɨara bɨ-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chi ne-inaa k'awaa k'inia bɨ o-ĩa baipia bɨ chi jarateepari jĩak'a pait'ee. Ichiaba mimiapari o-ĩa baipia bɨ chipari jĩak'a pait'ee. Chi te chipari t'ɨ̃jarapata pɨrã Beelzebú, Netuara Poro Waibɨa, audupɨara irudeerãmaa mãgɨ́ t'ɨ̃ bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Mãga jara p'anɨ mĩda, eperãarã waaweenáatɨ. Ɨ̃rá Tachi Ak'õre net'aa mera pɨk'a bɨ mĩda, t'ẽepai parãpa jõmaarãmaa jaradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mɨa ũraa jarada p'ãriu pɨk'a baji. Mamĩda jõmaarãmaa mãga jĩp'a jaradaipia bɨ. Ma awara mɨa ũraa mera pɨk'a jarada, golpe jaradaipia bɨ terraza ɨ̃rɨɨpa biaruk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Waaweenáatɨ parã jɨrɨ p'anɨɨrã peedait'ee, ãrapa parã p'oyaa atuapida-e perã tok'arradee. Ma k'ãyaara Tachi Ak'õre waawéetɨ. Iruata tachi piupii mãik'aapa atuapii. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Netopata-ek'ã ipana chak'e omé p'arat'a tau abaa pari? Eperãarãpa mãga oopata, ipana chak'e mak'ɨara vale-e bɨ jĩak'aapa. Mamĩda ipana chak'e apida eujãde baaidak'aa, parã Ak'õre Waibɨapa mãga jara-emãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Parã puda paara irua juasia iru bɨ. Mapa waaweenáatɨ, Tachi Ak'õrepa parã k'iniara iru bapari perã ipanaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Eperãpa tau taawa jararu pɨrã ichi Jesucristode ijãapari, mɨa pida jarai: “Mãgɨ́ mëré” mɨ Ak'õre k'ĩrapite ɨt'ari. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mamĩda eperãpa meraru pɨrã mɨde ijãapari, mãgara mɨa pida merait'ee. “Mãgɨ́ mëre-eda” ait'ee mɨ Ak'õre k'ĩrapite ɨt'ari. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—K'ĩsianáatɨ mɨ cheji na p'ek'au eujãdee eperãarã k'ãiwee p'anapide. Jĩp'a cheji chõopide. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mɨ cheji ‘warra t'ãri auk'a banaamerã chi ak'õre ome, wẽra k'au t'ãri auk'a banaamerã chi nawe ome mãik'aapa ãigu t'ãri auk'a banaamerã chi p'ãk'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ma k'aurepa eperãarã t'ãri auk'a para ba-e pait'ee ãchi ëreerã ome.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Eperãpa ichi ak'õre wa chi nawe k'iniara iru bɨ pɨrã mɨ k'inia iru bai k'ãyaara, mëré pa-e pai. Ichiaba eperãpa chi warra wa chi k'au k'iniara iru bɨ pɨrã mɨ k'inia iru bai k'ãyaara, mãgɨ́ mëré pa-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma awara mɨde ijãapari k'aurepa eperã piuamaa bɨ pɨrã kurusode piu wãk'a, mãgɨ́ mëré pa-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Eperã piuamaa bɨ pɨrã mɨde ijãapari k'aurepa, mãgɨ́ piuk'ãri, atuait'ee. Mamĩda eperã piuru pɨrã mɨde ijãapari k'aurepa, mãgɨ́ eperã piuk'ãri ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Eperãpa parã auteebaik'ãri, mɨ jida auteebai bɨ mãik'aapa mɨ Ak'õre, mɨ pëida, auk'a auteebai bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma awara eperãpa auteebaik'ãri Tachi Ak'õre pedee jarapari, Tachi Ak'õrepa pëida perã, ne-inaa pia atait'ee Tachi Ak'õre pedee jarapataarãpa atapatak'a. Ichiaba auteebaik'ãri eperã t'ãri pia, mãgɨ́ t'ãri pia bairã, ne-inaa pia atait'ee eperã t'ãri pia beerãpa atapatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma awara eperãpa teek'ãri pania vaso aba mɨ ome nipaparimaa mãgɨ́ mëré perã, Tachi Ak'õrepa ne-inaa pia ichiaba teeit'ee ma pania teedamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesupa chi k'õp'ãyoorã doce ũraap'eda, mamãik'aapa wãji Ak'õrepa jara pëida jarateede ma eujãdepema p'uuru bee chaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan carcelde bɨ misa, ũriji Cristopa oomaa bɨ. Aramata ichi ome nipapatap'edaarã ũk'uru pëiji Jesumaa. Iidinajida: ");
INSERT INTO sjaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Pɨk'ã ajida, tai k'aripapari chonaarãpa cheit'ee bɨda adap'edaa? Maa-e pɨrã, ¿taipa awaraa nɨdaipia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesupa p'anauji: —Wã́tɨ Juanmaa mãik'aapa nepɨrɨ́tɨ parãpa nama unu p'anɨ mãik'aapa ũri p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jarátɨ tau p'ãriu beeda ɨ̃rá unu p'anɨ; bɨɨrɨ nɨk'anɨk'aa beeda t'ɨa nĩutee; leprapa k'ayaa beeda jɨpa p'anɨ; k'ɨɨrɨ k'ĩ beeda ɨ̃rá ũri p'anɨ; piudap'edaarã waya chok'ai p'anɨ mãik'aapa chupɨria chedeerãmaa Tachi Ak'õrepa pedee pia jara pëida jarateemaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡T'ãri o-ĩa bɨda aji, chi mɨde ijãa bɨ, k'awa-e bɨ mĩda mɨa ne-inaa jõma oo bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpa eperãarã pëida wãdap'edaa t'ẽepai, eperãarãmaa Jesupa pedee pia jaramaa beeji Juande: —¿K'ãata parãpa ak'ɨnajidama aji, eujã pania wẽe bɨmaa wãdak'ãri? ¿K'ĩsiajida-ek'ã ak'ɨnadait'ee eperã pariatua k'ĩsia bɨ, p'ũajara nãupa pariatua nẽunẽuwaa p'uaparik'a? ");
INSERT INTO sjaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Maa-e pɨrã, ¿k'ĩsiajida-ek'ã ak'ɨnadait'ee eperã p'aru pi-ia jɨ̃ bɨ? Parãpa pia k'awa p'anɨ eperã p'aru pi-ia jɨ̃ beerã rey tede p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mãga-e pɨrã ¿k'ĩsiajida-ek'ã ak'ɨnadait'ee Ak'õre pedee jarapari? Wãara, iru Ak'õre pedee jarapari k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Na Juandeta Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Mɨa eperã chok'a pëiit'ee pɨ naa o pia oonamerã pɨ, eperãarã poro waibɨa, chei naaweda.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mɨa wãarata jararu. Juan Bautista k'ãyaara eperã apida waibɨara bɨ-e. Mamĩda chi ek'ariara bɨta iru k'ãyaara waibɨara pait'ee Tachi Ak'õrepa ma eperã ichi jua ek'ari bɨk'ãri, ichideerã ome beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan Bautista chedak'ãriipa, eperãarã chõo pɨk'a p'anɨ t'ĩudait'ee Tachi Ak'õre jua ek'ari, ichideerã p'aneedait'ee mãik'aapa k'achia beerã auk'a chõo pɨk'a p'anɨ apida mãga p'ananaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan jaratee chei naaweda, Tachi Ak'õre pedee jarapataarãpa jarapachida Tachi Ak'õrepa mãgá eperãarã bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã. Moisepa p'ãdade ichiaba mãga jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Parãpa k'awaa k'inia p'anɨ pɨrã Juanta Elías chi cheit'ee bada jara p'anadap'edaa; ichipɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Mɨa jarait'ee sãga p'anɨ parã, mɨde ijãadak'aa beerã. Warrarã su-ak'ɨ p'aneedap'eda, jemenemaa p'anɨ́k'ata p'anɨ p'uuru jãde. Ãchi k'õp'ãyoorãmaa biapata: ");
INSERT INTO sjaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Taipa siru chaajida. Mamĩda parã pëirada-e paji. K'ari k'ĩsia paraa k'arijida. Mamĩda parã jẽeda-e paji.” ");
INSERT INTO sjaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mãga pɨk'a baji Juan ome. Iru cheji mãik'aapa nek'ok'aa paji, ne-inaa tok'aa paji, eperã jĩp'aarãpa oopatak'a. Maperã eperãarãpa: “Netuara iru k'ap'ɨade merãtɨa bɨda” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","T'ẽepai mɨ, chi Eperã Ak'õre Truadepema cheji mãik'aapa nek'oji, ne-inaa toji eperã jĩp'aak'a. Maperã jara p'anɨ mɨ nek'oyaa, ne-inaa toyaa bapari. Ma awara mɨ k'õp'ãyo meraaparida a p'anɨ, k'achia-idaa beerã ome mãik'aapa Cesar-it'ee impuesto p'epataarã ome. Mamĩda Tachi Ak'õrepa wãarata ak'ɨpimaa bɨda aji, mɨa oo bɨ k'aurepa parã jõmaarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mãpai Jesús ijɨ̃atɨ pedeemaa beeji awara-awaraa p'uurudepemaarãmaa, ãchia p'ek'au k'achia oopata oodaamaa p'anadap'edaa perã. Mãga p'anajida unupachida mĩda irua ooda ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Jesupa ãchimaa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Aai, Corazín p'uurudepemaarã! ¡Aai, Betsaida p'uurudepemaarã! ¡Tachi Ak'õrepa parã k'achiadee pëiit'eepɨ! Tiro p'uurude, Sidón p'uurude eperãpa ooda paara ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa mɨa parã p'uurude oodak'a, taarã-e weda ijãak'ajida. Ãrapa p'ek'au k'achia oopata oo amaa k'inia jõnɨpa chupɨria iidik'ajida Tachi Ak'õremaa. Ma p'ek'au k'achia oopata k'aurepa t'ãri p'uapa p'aru p'ãimaa jɨ̃k'ajida mãik'aapa it'abarre p'ora ɨt'aa p'ok'ajida ãchi poro ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Maperã mɨa jara bɨ: Tachi Ak'õre ewari waibɨa ewate irua parã k'achiara ooit'ee ma Tiro p'uurudepemaarã k'ãyaara mãik'aapa Sidón p'uurudepemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ichiaba parã Capernaum p'uurudepemaarã, ¿k'ĩsia p'anɨk'ã parã p'uuruta awaraa p'uuru k'ãyaara waibɨara pait'ee Ak'õre k'ĩrapite? ¡Mãga-e! ¡Ma k'ãyaara irua parã p'uuruta jõt'aait'ee! Sodoma p'uurude eperãpa ooda paara ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa, mɨa parã t'ãide oodak'a, ma p'uuru at'ãri bak'aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mamĩda mɨa jara bɨ: Tachi Ak'õre ewari waibɨa ewate irua parã k'achiara ooit'eeda aji, Sodoma p'uurudepemaarã k'achia ooi k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Maapai Jesupa mãgaji: —Ak'õre Waibɨa, pɨ jõmaarã k'ãyaara waibɨara bɨ. Ne-inaa jõmaweda ɨt'ari nɨ̃bɨ, na p'ek'au eujãde nɨ̃bɨ paara pɨ jua ek'ari bɨ. Mɨ t'ãri o-ĩa bɨ pɨa eperãarã jĩp'aarãmaa k'awapiru perã ne-inaa pɨa waide k'awapi-e pada k'ĩsia k'awaa beerãmaa mãik'aapa poro wẽsaa beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pɨa mãga ooji mãga oo k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Mɨ Ak'õrepa ne-inaa jõma bɨji mɨ jua ek'ari mɨa ak'ɨpariimerã. Tachi Ak'õrepapai wãara mɨ, ichi Warra k'awa bɨ. Mãgá ichiaba mɨ, chi Warrapapai wãara iru k'awa bɨ. Mamĩda mɨa iru k'awapii mɨa k'awapi k'inia bɨ eperãarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maperã mɨmaa chétɨ parã jõmaweda sẽ p'anɨɨrã mimia p'anɨpa mãik'aapa k'ĩsia jõnɨpa. Mɨa parã t'ãri a-tu beepiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","K'õp'ãyo meráatɨ mɨ ome. Ũrítɨ mɨa jaratee bɨ mãik'aapa óotɨ mɨa jara bɨk'a. Mɨ t'ãri pia, chupɨria k'awaayaa bapari. Mɨde ijãadak'ãri, k'ãiwee p'anapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mɨa jara bɨk'a oodayada aji, mɨa k'aripak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Maapai judiorã ɨ̃ipata ewate Jesús nipaji trigo k'ãide. Chi k'õp'ãyoorã jarrapisia p'anadap'edaa perã, trigo k'ɨmɨ chak'eerã oro atadap'eda, chi tau jonamaa p'aneejida k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Arii p'anadap'edaa fariseorãpa mãga unudak'ãri, Jesumaa mãgajida: —¡Pɨchá ak'ɨ́ji! Pɨchi k'õp'ãyoorãpa ne-inaa oomaa p'anɨda ajida, ɨ̃ipata ewate oodaik'araa bɨta. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesupa p'anauji: —¿Parãpa Ak'õre Ũraa p'ãdade leeda-e p'anɨk'ã aji, Rey Davidpa ooda chonaarãweda jarrapisiadaidak'ãri chi k'õp'ãyoorã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iru t'ĩuji Tachi Ak'õre te ne-edee oodade mãik'aapa ma tedepema pan awara bɨdap'edaa Tachi Ak'õre-it'ee atap'eda, k'oji chi k'õp'ãyoorã ome. Mãga oojida p'aareerãpapai mãgɨ́ pan k'odaipia baji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ichiaba Moisepa p'ãdade parãpa leedooda p'aareerãpa ne-inaa k'achia ooda-e paji ɨ̃ipata ewate, Tachi Ak'õre te waibɨade ɨ̃ida-ee mimiadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mɨa jara bɨ: Nama ne-inaa pipɨara paraa Tachi Ak'õre te waibɨa k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wãara parãpa k'awada-e na p'ãdade jara k'inia bɨ: ‘Mɨa k'inia bɨ awaraarã chupɨria k'awaadamerã, mɨ-it'ee ne-animalaarã peedap'eda, paadai k'ãyaara.’ Parãpa k'awadap'edaa paara ma pedee jara k'inia bɨ, ne-inaa k'achia ooda-e p'anɨɨrã peepida-e pak'aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ɨ̃ipata ewate mɨ, chi Eperã Ak'õre Truadepema jua ek'ari bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mamãik'aapa Jesús wãji Tachi Ak'õre Ũraa jarateepata tedee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mama baji eperã jua chiwa bɨ. Jesús ɨmɨatee k'inia p'anadap'edaarãpa iidijida irumaa: —¿Eperã k'ayaa bɨ pɨrã, ɨ̃ipata ewate jɨpaipia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesupa p'anauji: —Ɨ̃ipata ewate pɨchi oveja toidú padarida paara, ¿taawaa uchia ata-e pak'ajik'ã? ");
INSERT INTO sjaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Eperã pipɨara bɨ-ek'ã oveja k'ãyaara? Mapa ɨ̃ipata ewate ne-inaa pia ooipia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mãpai Jesupa ma jua chiwa bɨmaa mãgaji: —Pɨchi jua jĩrupáde aji. Mãpai jua jĩruji. Aramata jɨpa beeji chi apema juak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mãpai fariseorã taawaa uchiadak'ãri, pedeeteemaa p'aneejida Jesús peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesupa mãɨrã k'ĩsia k'awaak'ãri, mamãik'aapa wãji. Eperãarã chok'ara iru t'ẽe wãjida. Jesupa madepema k'ayaa beerã jõmaweda jɨpaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mamĩda jarapachi ichia ooda jõmaarãmaa nepɨrɨnaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mãga jaraji Tachi Ak'õre pedee jarapari, Isaíapa p'ãdade jara bɨk'a uchiamerã: ");
INSERT INTO sjaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Nama bɨ mɨ mimiapari, mɨa jɨrɨt'erada. Mɨa iru k'inia iru bɨ; mɨ t'ãri o-ĩapipari. Mɨ Jaure iru ome bapariit'ee. Mɨ k'ap'ɨa pari irua eperãarã jõmaarãpa oopata ak'ɨit'ee mãik'aapa jarait'ee pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aupedee-e pait'ee; ichiaba bia-e pait'ee. Apidaapa iru biapi ũrida-e pait'ee calle jãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Irua yiaraa iru ba-e pait'ee chupɨria chitoonɨɨrã wa k'ĩra pia-ee jõnɨɨrã. Mãga bait'ee Tachi Ak'õrepa jõmaarãmaa wãarata jara pëida k'awaapirumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mãga pak'ãri, jõmaarãpa irude ijãadait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesumaa aneejida eperã tau p'ãriu bɨ mãik'aapa pedee atua bɨ, netuara iru k'ap'ɨade merãtɨa bada perã. Jesupa iru tau pia unupiji mãik'aapa pedeepiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mãga unudak'ãri, arii p'anadap'edaarãpa ak'ɨtrua para beeji mãik'aapa ãchi pitapai iidi para beeji: —¿Nãgɨ́ chonaarãwedapema Rey David Warra-ek'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mamĩda mãga ũridak'ãri, fariseorãpa mãgajida: —Beelzebú, Netuara Poro Waibɨa juapata jãgá netuaraarã uchiapiparida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesupa k'awaji ãchia k'ĩsia p'anɨ. Mapa mãgaji: —P'uuru pidaarãpa maa-e pɨrã ëreerãpa maa-e pɨrã te pidaarãpa ãchi auk'aarã jëreruta pɨrã, waa araa p'anapataada-e pai mãik'aapa ãchi p'uuru jõdaridai. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mãga pɨk'a Netuara Poro Waibɨapa ichi auk'aarã jëreru pɨrã, waa araa p'anada-e pai mãik'aapa ãchi itu jõdaridai. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Parãpa jara p'anɨ mɨa netuaraarã uchiapipari Beelzebú juapa. Mãgara, ¿k'ai juapa uchiapipatama parã eere p'anɨɨrãpa? Ãchia ak'ɨpipata parã pia k'ĩsiada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mɨa netuaraarã uchiapipari pɨrã Tachi Ak'õre Jaurepa, jara k'inia bɨ ɨ̃rá Tachi Ak'õredeerã poro waibɨa nama bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿K'aita t'ĩuyama aji, eperã juataura bɨ tede iru net'aa chɨade? Naapɨara jɨ̃ nɨ̃bɨ-e pɨrã, iru net'aa jãri p'e ata-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Eperã mɨ eere bɨ-e pɨrã, mɨ k'ĩra unuamaa iru bɨ. Ichiaba mɨ k'aripa-e bɨ pɨrã awaraarã Tachi Ak'õre jua ek'ari p'anapataadamerã, eperãarã ãyaa pëipari mɨ ik'aawaapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Maperã mɨa jara bɨ: Tachi Ak'õrepa wẽpapii eperãarãpa p'ek'au k'achia oopata jõmaata mãik'aapa iru ãpɨte ik'achia jarapata paara. Mamĩda iru Jaure ãpɨte ik'achia jarapata wẽpapi-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ichiaba wẽpapii ik'achia jarapata mɨ, chi Eperã Ak'õre Truadepema ãpɨte. Mamĩda wẽpapi-e pait'ee ik'achia jararuta pɨrã iru Jaure ãpɨte. Mãgee p'ek'au k'achia oopata wẽpapi-e pait'ee chi ma pedee jarapataarã na p'ek'au eujãde p'anɨde maa-e pɨrã ɨt'ari iru k'ĩrapite p'anɨde paara, iru ewari waibɨa ewate. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Nejõ bɨɨrɨ pia iru bɨ pɨrã, chauk'ãri, nejõ pia iru bait'ee. Jõdee nejõ bɨɨrɨ k'achia iru bɨ pɨrã, chauk'ãri, nejõ k'achia iru p'anadait'ee. Nejõ bɨɨrɨ k'awapata chi nejõdeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Parã k'achia-idaa beerãdeepa uchiadap'edaarã! ¡Taamák'apɨ p'anɨ! ¿Sãga pedee pia jaradai, parã t'ãri k'achia p'anɨta? Pãchi t'ãride k'ĩsia p'anɨta jarapata pãchi it'aideepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Eperã t'ãri pia bɨpa pedee pia jarapari k'ĩsia pia iru bairã ichi t'ãride. Jõdee eperã t'ãri k'achia bɨpa pedee k'achia jarapari k'ĩsia k'achia iru bairã ichi t'ãride. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mɨa jara bɨ: Tachi Ak'õre ewari waibɨa ewate ichia eperã chaachaa k'awapiit'ee ãchia pedee k'achia pariatua jaradap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma ewate Tachi Ak'õrepa ak'ɨit'ee eperãarãpa pedee jaradap'edaa mãik'aapa ichiata jarait'eeda aji, k'achia-idaa bɨ, maa-e pɨrã t'ãri pia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mãpai ũk'uru fariseorãpa mãik'aapa Moisepa p'ãda jarateepataarãpa Jesumaa mãgajida: —Tachi Jarateepari, taipa unu k'inia p'anɨda ajida, pɨa oo bɨ ne-inaa Tachi Ak'õrepapai oopari. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesupa p'anauji: —Ɨ̃rapemaarã t'ãri k'achia-idaa p'anɨ, Tachi Ak'õrede ijãadak'aa perã. Unu k'inia p'anɨda a p'anɨ ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mamĩda mɨa mãga oo-e pait'ee. Jĩp'a Tachi Ak'õrepa ooit'ee ichi pedee jarapari Jonás ome oodak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás k'ãima õpee baji chik'o choma bɨ bide. Mãga pɨk'a mɨ, chi Eperã Ak'õre Truadepema k'ãima õpee eujã ek'ari bait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tachi Ak'õre ewari waibɨa ewate Nínive p'uuru pidaarãpa ɨ̃rapemaarã ɨmɨateedait'ee, Tachi Ak'õrepa parã k'achiadee pëimerã. Chonaarãweda Tachi Ak'õrepa Jonás pëik'ãri ma Nínive pidaarãmaa, ãrapa p'ek'au k'achia oopatap'edaa oo amaajida. Mamĩda ɨ̃rapemaarãpa p'ek'au k'achia oopata oo amaada-e p'anɨ, aba Jonás k'ãyaara waibɨara bɨpa jara cheji mĩda mãga oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ichiaba ma ewate Reina Sur Eerepemapa auk'a ɨ̃rapemaarã ɨmɨateeit'ee Tachi Ak'õrepa parã k'achiadee pëimerã. Chonaarãweda ma reina t'ɨmɨɨpa cheji Rey Salomón k'ĩsia k'awaa bɨ pedee ũride. Mamĩda ɨ̃rapemaarãpa ũridaamaa p'anɨ, aba Salomón k'ãyaara k'ĩsia k'awaara bɨ pedee bɨ mĩda parã t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Eperã k'ap'ɨadeepa netuara uchiapidak'ãri, mãgɨpa jɨrɨ nipapari eujã p'ũasaa sãma ɨ̃iit'ee. Mamĩda unu-e pak'ãri, k'ĩsiapari: ");
INSERT INTO sjaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Waya merãtɨanait'ee ma eperã k'ap'ɨade; mɨ naaweda badamãi.” Chek'ãri, unu chepari ma eperã k'ap'ɨa pi-ia bɨ; te barrep'eda, sɨɨp'eda, pi-ia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mãga unuk'ãri, jɨrɨnapari awaraa netuara siete k'achiara ichi k'ãyaara mãik'aapa ma eperã k'ap'ɨade merãtɨa chepata. Mãgá ma eperã audupɨara k'achiade beeit'ee naaweda bada k'ãyaara. Mãga p'asait'eeda aji, ɨ̃rapemaarã t'ãri k'achia-idaa beerã ome; audupɨara k'achiade p'aneedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús at'ãri pedeemaa bɨde pachejida chi nawe chi ɨ̃pemaarã ome. Pedee k'inia p'anajida iru ome. Mamĩda taawa p'aneedap'edaa perã, ");
INSERT INTO sjaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","eperãpa Jesumaa jaranaji: —Pɨ nawe, pɨ ɨ̃pemaarã ome taawa nɨmaa p'anɨ. Pedee k'inia p'anɨda aji, pɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mãpai Jesupa p'anauji: —¿K'aima mɨ nawe? ¿K'áirãma, mɨ ɨ̃pemaarã? ");
INSERT INTO sjaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mãpai juapa ɨaji chi k'õp'ãyoorãmaa mãik'aapa mãgaji: —Nãgɨɨrãta mɨ nawek'a mãik'aapa mɨ ɨ̃pemaarãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi mɨ ɨt'aripema Ak'õre Waibɨapa jara bɨk'a oo bɨ, mata mɨ ɨ̃pemak'a, mɨ ɨ̃pewẽrak'a mãik'aapa mɨ nawek'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma ewate Jesús uchiaji temãiipa mãik'aapa lago ide su-ak'ɨ banaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eperãarã chedap'edaa irumãi see nɨ̃bada perã, Jesús barcode bataudachi mãik'aapa su-ak'ɨ beeji. Jõdee eperãarã ipude para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mãpai Jesupa eperãarãmaa nepɨrɨmaa beeji Ak'õre Ũraa jarateeit'ee: —Eperã wãji net'atau p'ode. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma p'o wãk'ãri, ũk'uru baaijida o jãde. Mãpai ipanaarãpa k'ok'oo chejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ũk'uru baaijida mãu-idaade, mak'ɨara yooro wẽe badamãi. Mãgɨ́ isapai t'onojida, mak'ɨara yooro wẽe bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mamĩda ak'õrejĩru jẽrak'ãri, pɨɨdachi chi k'arra ɨ̃rɨɨ bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ũk'uru baaijida ne-ɨɨrɨ-idaade. Mamĩda ne-ɨɨrɨ k'ap'ip'iara waripari perã, mãgɨ́ net'atau t'ono wãdap'edaa piuk'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jõdee awaraa net'atau baaijida eujã piade. Mãgɨ́ t'onop'eda, chau nɨ̃beeji. Ũk'uru net'atau abaadeepa uchiajida cien, sesenta maa-e pɨrã treinta. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Maap'eda chi k'õp'ãyoorã k'ait'aara chejida mãik'aapa iidijida: —¿K'ãare-it'ee nepɨrɨparima ajida, jarateeit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesupa p'anauji: —Tachi Ak'õrepa parãmaa k'awapimaa bɨda aji, ne-inaa naaweda k'awapik'aa pada awaraarãmaa; sãga ichideerã p'aneedai. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Parã Ak'õre ũraa pia k'awa beerãmaa waapɨara k'awapiit'ee; awaraarã k'ãyaara ne-inaa chok'araara k'awarutamaa. Mamĩda chi ne-inaa mak'ɨara k'awa-ee beerãmaa, ãchia k'awa p'anɨ paara irua wẽpapiit'ee, waa k'awa k'iniada-e p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Maperãpɨ mɨa nepɨrɨpari. Ãchia ak'ɨ p'anɨ mĩda, wãara unuda-e. Ũri p'anɨ mĩda, k'awada-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ãrapa oomaa p'anɨ Tachi Ak'õre pedee jarapari Isaíapa jaradak'a: ‘Ũri p'anɨ mĩda, k'awada-e. Ak'ɨ p'anɨ mĩda, unuda-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na eperãarã k'ɨɨrɨ k'isua p'anadairã, mɨa jara bɨ ũridaamaa p'anɨ; mɨa oo bɨ unudaamaa p'anɨ mãik'aapa k'awadaamaa p'anɨ. Mãga p'anada-e pada paara, mɨde ijãak'ajida mãik'aapa mɨa ãchia p'ek'au k'achia oopata wẽpapik'aji.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Parã t'ãri o-ĩa p'anɨ mɨa oo bɨ unu p'anadairã mãik'aapa mɨa jara bɨ ũri p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mɨa wãarata jararu. Chonaarãweda Ak'õre pedee jarapataarãpa mãik'aapa Tachi Ak'õrede ijãapataarãpa unu k'inia p'anajida parãpa unu p'anɨ. Mamĩda unuda-e paji. Ichiaba ũri k'inia p'anajida parãpa nama ũri p'anɨ. Mamĩda ũrida-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Ũrítɨ k'awaadamerã mɨa nepɨrɨda net'atau p'oparide k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Net'atau ode baaida jara k'inia bɨ chi ũri p'anɨɨrã Tachi Ak'õrepa eperãarã bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã. Mamĩda mãgɨɨrãpa k'awada-e k'ãata jara k'inia bɨ. Ipanaarã chedap'edaak'a ma net'atau k'ok'oodait'ee, mãga pɨk'a Netuara Poro Waibɨa chepari ne-inaa ooit'ee, t'ãripa ma pedee ijãanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jõdee chi net'atau mãu-idaade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida o-ĩa ũri p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mamĩda chi mãu-idaade t'onoda taarã-e weda pɨɨdaiparik'a, mãga pɨk'a mãgɨɨrãpa ma jara pëida taarã-epai ijãapata. Ma ũraade ijãadap'edaa k'aurepa nepɨrade baairuta pɨrã maa-e pɨrã awaraarãpa ãchi jɨrɨruta pɨrã miapidait'ee, ijãa amaapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jõdee chi net'atau ne-ɨɨrɨ-idaade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida pia ũri p'anɨ. Mamĩda audupɨara k'ĩsiapata ne-inaa netodait'ee maa-e pɨrã p'arat'a waibɨa atadait'ee, ãchia ũridap'edaa k'ĩra atuadarutamaa. Mãgá p'aneepata ne-uu warip'eda, chauk'aa bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mamĩda chi net'atau eujã piade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida ũridap'eda, k'awaa wãpata ma ũraa jara k'inia bɨ mãik'aapa t'ãride wãara ijãapata. Net'atau aba p'oda eujã piade pia t'onop'eda, chauparik'a net'atau cien, sesenta wa treinta; mãga pɨk'a ma eperãarãpa oo k'awaa wãpata ma ũraade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mãpai Jesupa awaraa nepɨrɨji jarateeit'ee: —Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Eperãpa trigo tau pia p'oji ichi eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mamĩda p'ãrik'ua, eperãarã k'ãi p'anɨ misa, ichi k'ĩra unuamaa iru bɨpa cheji mãik'aapa ma trigo p'odade mera p'oji p'ũajara tau chak'eerã, aɨdee neera k'achia oopata. Mãpai jirabodoji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maap'eda ma eperãpa trigo p'oda t'onop'eda, wari wãji ma p'ũajara ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mãga unudak'ãri, ma eujã chipari mimiapataarãpa irumaa jaranajida: “Señor, pɨa trigo tau p'oda pia badata, ¿sãmãik'aapa uchiajima ajida, jãgee p'ũajara?” ");
INSERT INTO sjaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chiparipa p'anauji: “¿Tachi k'ĩra unuamaa iru bɨ́pata jãga ooji-ek'ã?” aji. Mãpai chi mimiapataarãpa iidijida: “¿Pɨa k'inia bɨk'ã ajida, taipa jã p'ũajara ẽt'anadamerã?” ");
INSERT INTO sjaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mamĩda chiparipa mãgaji: “Nãgaweda ichiak'au bɨdapáde aji. Ɨ̃raweda parãpa jã p'ũajara ẽt'at'aarutara, auk'a ẽt'adariit'ee chi trigo k'arra, aɨ ik'aawa nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Piara bɨ ichiak'au bɨdamerã trigo ewarutamaa. Mamãik'aapata mɨa ewapataarã naapɨara pëiit'ee jã p'ũajara ẽt'ak'oodamerã mãik'aapa p'edamerã k'õrajɨ̃made paat'aadait'ee. T'ẽepai trigo ewadak'ãri, ɨadait'ee mɨ ne-inaa ɨaparide.” ");
INSERT INTO sjaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesupa ichiaba awaraa nepɨrɨji jarateeit'ee: —Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Eperãpa mostaza tau uuji ichi eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chi tau ma-ãriara bɨ awaraa net'atau tachia uupata k'ãyaara. Mamĩda warik'ãri, waibɨara waripari awaraa ne-uu k'ãyaara pak'uruk'a nɨ̃beerumaa. Mãgá waibɨara waripari perã, chi jua t'aide ipanaarã chepata ɨ̃idait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ichiaba Jesupa nãga nepɨrɨji jarateeit'ee: —Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Wẽrapa levadura p'oiraparik'a bɨ harina waibɨa ome, pan masa pia warimerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús jarateek'ãri, audú nepɨrɨpachi. Nepɨrɨ-ee jarateek'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mãga ooji uchiamerã Tachi Ak'õre chonaarãwedapema pedee jaraparipa irude jaradak'a: ‘Jarateek'ãri, mɨa nepɨrɨit'ee mãik'aapa jarait'ee ne-inaa Tachi Ak'õrepa waide k'awapi-e pada na p'ek'au eujã ooru wedapema.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ma jõma nepɨrɨp'eda, Jesupa eperãarã bëiji mãik'aapa t'ĩuji chi k'õp'ãyoorã p'anadap'edaamãi. Mãpai ãchi iru k'ait'a chedak'ãri, iidijida k'ãata jara k'inia bɨ ma nepɨrɨda p'ũajara tau p'oda trigo k'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesupa p'anauji: —Chi eperã net'atau pia p'oda jara k'inia bɨ Eperã Ak'õre Truadepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma net'atau p'oda eujã jara k'inia bɨ na p'ek'au eujã. Ma trigo tau pia jara k'inia bɨ Tachi Ak'õrede ijãapataarã. Jõdee p'ũajara k'achia jara k'inia bɨ Netuara Poro Waibɨa jua ek'ari p'anɨɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma k'ĩra unuamaa iru bada, chi ma p'ũajara k'achia p'oda jara k'inia bɨ Netuara Poro Waibɨa. Ma ne-inaa p'oda ewadap'edaa ewate jara k'inia bɨ Tachi Ak'õre ewari waibɨa ewate, ichi angeleerãpa eperãarã p'e ateedak'ãri iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mɨa nepɨrɨdade ma p'ũajara k'achia p'edap'edaak'a paat'aadait'ee, mãga pɨk'a oodait'ee na p'ek'au eujã jõt'aak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɨ, chi Eperã Ak'õre Truadepemapa angeleerã pëiit'ee mɨ jua ek'ari p'anɨɨrã t'ãide k'achia beerã jõmaweda p'ede; chi awaraarãmaa p'ek'au k'achia oopidap'edaarã, awaraa ne-inaa k'achia ooi awaa p'anapatap'edaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma k'achia beerã jõmaweda bat'ak'oodait'ee t'ɨpɨtau jẽrajẽraa jira bɨde. Mama jẽe para bait'ee mãik'aapa k'ida kierrkierree para bait'ee p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jõdee Tachi Ak'õrepa jara bɨk'a oopataarã urua pɨk'a para beeit'ee ak'õrejĩruk'a, ɨt'ari p'anɨ perã ãchi ak'õre waibɨa ome. Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Chok'o unuji jau bɨ nẽe ome. Eperãpa mãgɨ́ unu atak'ãri, waya mera nɨ̃bɨp'eda chi badamãi, t'ãri o-ĩa wãji jõmaweda ichi net'aa iru bada netok'oode. Mãpai ãpɨtee cheji ma nẽe mera bada eujã neto atade. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Ichiaba nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Net'aa netoparipa perla jɨrɨ nipaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Perla ɨ̃pɨa unu atanak'ãri, wãji ichi net'aa jõmaweda netok'oode mãik'aapa ma perla pi-ia neto ata cheji. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Ichiaba nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. To-ɨapataarãpa t'ɨrɨ t'aadak'ãri, chik'o k'ĩra t'ãdoo peejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma t'ɨrɨde chik'oradaik'ãri, chipariirãpa jidiu atajida ipudee mãik'aapa jɨrɨt'eramaa p'aneejida chik'o piara bee awara p'edait'ee k'oraade. Jõdee chik'o k'achia bee bat'ak'oojida toidaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mãga pɨk'a pait'ee na p'ek'au eujã jõk'ãri. Angeleerã chedak'ãri, jɨrɨt'era chedait'ee eperã pia beerã awara p'edait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jõdee chi k'achia beerã t'ɨpɨtau jẽrajẽraa jira bɨde bat'ak'oodait'ee, mama jẽe para bamerã mãik'aapa k'ida kierrkierree para bamerã p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mãpai Jesupa chi k'õp'ãyoorãmaa iidiji: —¿Parãpa ma nepɨrɨda jõmaweda k'awajidak'ã? aji. Mãpai p'anaujida: —K'awajidapɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mãpai Jesupa mãgaji: —Moisepa p'ãda jarateeparipa k'awaa wãk'ãri Tachi Ak'õrepa eperãarã bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã, nãga pɨk'a bɨ. Eperã te chiparipa ichi net'aa ɨa p'e iru bɨdepema net'aa atak'ãri, k'awa bɨ chisãgɨ́ net'aa chiwidi, chisãgɨ́ net'aa sore. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesupa ma nepɨrɨda jaratee aupak'ãri, mamãik'aapa wãji ");
INSERT INTO sjaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ichi warida p'uurudee. Mama jarateemaa beeji mãpema Ak'õre Ũraa jarateepata tede. Irua jaratee bɨ ũridak'ãri, eperãarã ak'ɨtrua para beeji mãik'aapa mãgapachida: —¿Sãma k'awaajima ajida, na jõma irua jarateemaa bɨ? ¿Sãga ooparima ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa? ");
INSERT INTO sjaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Jãgɨ́ eperã ne-inaa pak'urudee oopari warra-ek'ã? ¿Chi nawe Maria-ek'ã? ¿Santiago, José, Simón, Judas chi ɨ̃pemaarã-ek'ã? ");
INSERT INTO sjaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Chi ɨ̃pewẽraarã nama p'anapata-ek'ã? ¿Sãga k'awaajima ajida, na jõma ichia oo bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma eperãarãpa Jesús ichi te pidaarã ome mãgá k'awadap'edaa perã, iru pedee ũri k'iniada-e paji. Mapa Jesupa mãgaji: —Jõmaarã t'ãide ũri k'inia p'anapata Tachi Ak'õre pedee jaraparipa jara bɨ. Mamĩda ichi p'uurudepemaarã ichi tedepemaarã ome iru pedee ũridaamaa p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mãgá mãpemaarãpa irude ijãada-e p'anadap'edaa perã, mama Jesupa mak'ɨara oo-e paji ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Maapai Galilea eujãdepema poro waibɨa t'ɨ̃jarapachida Herodes. Ichia ũrik'ãri Jesupa oo bɨ, ");
INSERT INTO sjaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ichi ek'ariirãmaa mãgaji: —¿Mãgɨ́ Juan Bautista-epaa, piup'eda p'irabaida? Maperãpɨ oopari ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aɨ naaweda Herodepa Juan jɨ̃ atapiji mãik'aapa carcelde t'ɨpit'aaji. Mãga ooji chi ɨ̃pema Filipo wẽra Herodías k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aɨ naaweda Juanpa Herodemaa mãgaji: “Pɨa p'ek'au k'achia oomaa bɨda aji, pɨ ɨ̃pema wẽra iru bairã pɨchi wẽrak'a.” ");
INSERT INTO sjaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mãga ũrik'ãri, Herodepa Juan pee k'inia bapachi. Mamĩda mãga oo-e paji eperãarã waawee bada perã. Jõmaarãpa ijãajida Juan Tachi Ak'õre pedee jarapari paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mamĩda ewari aba Herodepa jara pëiji eperãarã chedamerã ichi t'oda fiesta oode. Ma fiesta o-ĩa oo jõnɨ misa, Herodías k'au pëirade cheji see nɨ̃badaarã taide. Mãga unuk'ãri, Herodes audupɨara o-ĩadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Maperã jaraji ma awẽramaa: —Tachi Ak'õre k'ĩrapite mɨa juraa bɨ teeit'ee pɨchia iidiruta. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mãpai chi nawepa jaradak'a jaraji: —Ɨ̃raweda Juan Bautista poro mɨ-it'ee p'arat'ude teepáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mãga ũrik'ãri, Rey Herodes k'ĩra pia-eedachi. Mamĩda Tachi Ak'õre k'ĩrapite mãik'aapa jõmaweda arii p'anadap'edaarã k'ĩrapite juraada perã, ");
INSERT INTO sjaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","jaraji chi ek'ariirãmaa Juan poro t'ɨap'e atanadamerã carcelde. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mãga oojida. Ma awẽra nawepa jaradak'a aneejida p'arat'ude mãik'aapa teejida ma awẽramaa. Mãpai ichia teenaji chi nawemaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan k'õp'ãyoorãpa ũri atadak'ãri iru peedap'edaa, chejida iru k'ap'ɨa ɨanadait'ee. Maap'eda jaranajida Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesupa Juan piuda ũrik'ãri, barcode t'ɨmɨ́ wãji eperãarã mak'ɨara wẽemaa. Mamĩda eperãarãpa k'awaadak'ãri, t'ẽe wãjida ode. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús barcodeepa batauk'ãri, eperãarã chok'ara unuji. Mapa ãra chupɨria k'awaaji mãik'aapa ode wãdap'edaarãpa k'ayaa beerã ateedap'edaa jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","K'eu wãda perã chi k'õp'ãyoorã ichi k'ait'a chedap'eda, mãgajida: —K'eu wãpɨ; nama te wẽ-epɨ. Mapa eperãarã pëipáde ajida, p'uuru beemaa chik'o netonadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesupa p'anauji: —Ãra ãyaa wãdaik'araa bɨ. Parãpa chik'o téetɨ k'odamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mãpai mãgajida: —Mamĩda taipa iru p'anɨda ajida, pan joisomaa mãik'aapa chik'o omé; mãgɨ́ aupai. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesupa p'anauji: —Mɨmaa aneedapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mãpai Jesupa jaraji eperãarã su-ak'ɨ p'aneedamerã eujãde p'ũajara ɨ̃rɨ. Maap'eda jita ataji ma pan joisomaa chik'o omee ome mãik'aapa ɨt'aa ak'ɨp'eda, gracias jaraji Tachi Ak'õremaa. Ma pan k'õrak'ook'ãri, chok'ara eepadachi. Mãpai chi k'õp'ãyoorãpa eperãarãmaa jedenajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jõmaweda nek'ojida bi jãwaa p'aneerutamaa. Ma pan pite chik'o ome nɨ̃beeda p'ejida k'oraa docena aba. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chi nek'odap'edaarã ɨmɨk'ĩraarã cinco mil paji, wẽraarã, warrarã juasiada-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma t'ẽepai Jesupa chi k'õp'ãyoorã barcode bataupiji ichi naa lago sĩadamerã. Mãga ooji ãra k'ĩraik'a eere panadamerã, ichia eperãarã pëiru misa ãchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eperãarã erreuk'oodaidak'ãri, Jesús ituaba wãji ee nok'odee ɨt'aa t'ɨ̃de. Mama bɨde k'eudachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mãɨmisa chi barcode wãdap'edaarã tok'esá panadak'ãri, p'usara nɨ̃beeji, ãchimaa nãu p'ua nɨ̃bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taujaaweda Jesús chi k'õp'ãyoorãmaa t'ɨa wã nipaji pania ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chi k'õp'ãyoorãpa mãga unudak'ãri, p'eradachida mãik'aapa ãchobeepa biajida: —¡Netuarada! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mãpai Jesupa mãgaji: —¡P'eranáatɨ! ¡Mɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mãpai Pedropa mãgaji: —Tachi Waibɨa, wãara pɨ pɨrã, pɨmaa mɨ wãpipáde aji, pania ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesupa: —Chepáde, aji. Mãpai Pedro toida bataup'eda, t'ɨa wãji pania ɨ̃rɨ Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mamĩda nãu audú p'ua nɨ̃bɨ unuk'ãri, ãchobeedachi mãik'aapa pirubaai wãji. Mãpai biaji: —Tachi Waibɨa, ¡mɨ k'aripáji! ");
INSERT INTO sjaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aramata Jesupa juade jita ataji mãik'aapa mãgaji: —¿At'ãri pɨa ijãa-e bɨk'ã? aji. ¿Sãap'eda pia ijãa-e bɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Barcode bataudak'ãri, nãu p'ua-edachi mãik'aapa p'usa t'umãtɨdachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mãpai ma barcode nipadap'edaarã Jesús k'ĩrapite bedabaik'oodachida mãik'aapa mãgajida: —¡Wãarada ajida, pɨ Tachi Ak'õre Warra! ");
INSERT INTO sjaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mata panajida lago k'ĩraik'a eere mãik'aapa wiibainajida Genesaret eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ariipemaarãpa Jesús pacheru k'awaadak'ãri, ma eujãdepema jõmaarãmaa jara pëijida. Mapa k'ayaa beerã ateepachida irumaa ");
INSERT INTO sjaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","mãik'aapa chupɨria iidipachida ichi p'aru ide pɨjida t'õbaipimerã. Mãgá chi t'õbaidap'edaarã jɨpa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maapai ũk'uru fariseorã mãik'aapa Moisepa p'ãda jarateepataarã pachejida Jerusalendeepa. Jesumaa iidijida: ");
INSERT INTO sjaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Sãap'eda pɨ k'õp'ãyoorãpa ooda-e p'anɨma ajida, tachi chonaarãpa chonaarãweda oopatap'edaak'a? ¿Sãap'eda nek'odai naaweda, ãchi jua sɨɨdak'aama ajida, tachi chonaarãpa jarateedap'edaak'a? ");
INSERT INTO sjaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","P'anau k'ãyaara, Jesupa iidiji: —¿Sãap'eda parãpa oodak'aama aji, Tachi Ak'õrepa jara bɨk'a? Ma k'ãyaara chonaarãweda oopatap'edaak'a oo k'inia p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tachi Ak'õrepa jaraji: ‘Pɨchi ak'õre mãik'aapa pɨchi nawe k'inia iru baparíiji mãik'aapa ãra pedee ũriparíiji.’ Ma awara jaraji: ‘Warrapa ik'achia jararu pɨrã ichi ak'õremaa wa ichi nawemaa, peet'aadaipia bɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mamĩda parãpa jarateepata eperãpa jarai chi ak'õremaa wa chi nawemaa: “Pɨ p'oyaa k'aripa-epɨ, jõma mɨa iru bɨ primisiak'a teeda perã Tachi Ak'õremaa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Eperãpa mãga jarak'ãri, pia bɨda apata, chi ak'õreerã k'aripanaamerã. Mamĩda parãpa mãga jarateedak'ãri, jarateemaa p'anɨ piara bɨ oodait'ee pãchia jarapatak'a, Tachi Ak'õre Ũraa p'ãdade jara bɨk'a oodai k'ãyaara. ¡Tachi Ak'õre Ũraa yiaraa iru p'anɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Seewata Tachi Ak'õrede ijãapataarãda apata! Chonaarãweda Ak'õre pedee jarapari Isaíapa parã ãpɨte wãara pedee baji jarak'ãri: ");
INSERT INTO sjaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na eperãarãpa mɨ k'inia iru p'anɨda apata it'aipa. Mamĩda ãchi t'ãripa wãara mɨ k'iniada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Páripɨ mɨ k'ĩrapite ɨt'aa t'ɨ̃pata, oo k'inia p'anapata perã eperãarãpa jara p'anɨk'a, mɨa jara bɨk'a oodai k'ãyaara.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Maap'eda, Jesupa eperãarã t'ɨ̃ p'e ataji mãik'aapa mãgaji: —Ũrítɨ k'awaadamerã mɨa jararu. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chik'o k'odak'ãri, tachi k'ap'ɨade edú banapari. Ma chik'o k'odap'edaa k'aurepa tachi k'achia p'aneedak'aa Tachi Ak'õre k'ĩrapite. Ma k'ãyaara, ne-inaa eperã t'ãrideepa uchiarúpata, k'achia beepiparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mãpai chi k'õp'ãyoorã Jesús k'ait'a chedap'eda, iidijida: —¿K'awa-e bɨk'ã ajida, fariseorãpa ma pedee ũridak'ãri, k'ĩrau p'aneedap'edaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesupa p'anauji: —Mɨ Ak'õre ɨt'ari bɨpa pak'uru uu-e pada ẽt'ak'oodait'eeda aji, chi k'arra paara. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ichiak'au bɨ́tɨ ma tau p'ãriu pɨk'a beerãpa awaraa tau p'ãriu pɨk'a beerã jarateedamerã. Tau p'ãriu bɨpa awaraa tau p'ãriu bɨmaa o jarateeru pɨrã, omeeweda uriade baainadait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mãpai Pedropa Jesumaa mãgaji: —Pɨa nepɨrɨda eperãarãmaa taimaa jarateepáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesupa p'anauji: —¿Parãpa pida k'awada-ek'ã aji, k'ãata jara k'inia bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ne-inaa jõmaweda t'ĩuru eperã it'aide bide banapari, maap'eda uchiapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mamĩda pedee k'achia it'aideepa uchiaru iru t'ãrideepa uchiada. Mapata eperã k'achia beepipari Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eperã t'ãrideepa nãgee k'ĩsia k'achia uchiaparida aji: chĩara peeit'ee; miak'ãi bɨ awaraarã ome k'ãiit'ee; p'ek'au ooit'ee awaraarã ome; nechɨait'ee; seewa jarait'ee; ik'achia jarait'ee; jãgee k'ĩsia. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mãgee k'ĩsia k'aurepata eperã k'achia beepipari Tachi Ak'õre k'ĩrapite. Mamĩda nek'oit'ee jua sɨɨ-ee chonaarãweda tachi chonaarãpa oopatap'edaak'a apidaamaa k'achia beepik'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mamãik'aapa Jesús wãji Tiro p'uuru mãik'aapa Sidón p'uuru k'ait'a bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaán eujãdepema wẽra bapachi ma eujãde. Mãgɨpa Jesús unuk'ãri, irumaa chupɨria iidi cheji: —Tachi Waibɨa, Rey David Warra, ¡mɨ chupɨria k'awáaji! ¡Mɨ k'au k'ap'ɨade netuara merãtɨa bɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mamĩda Jesupa p'anau-e paji. Mãpai chi k'õp'ãyoorã k'ait'aara chedap'eda, Jesumaa mãgajida: —Jarapáde ajida, jã wẽramaa ãyaa wãmerã, tachi t'ẽe bia cheru perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mãpai Jesupa mãgaji: —Tachi Ak'õrepa mɨ pëijida aji, k'aripamerã Israel pidaarã, ovejaarã atua p'anɨk'a p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mamĩda ma wẽra bedabai nɨ̃banaji Jesús k'ĩrapite mãik'aapa mãgaji: —Tachi Waibɨa, ¡mɨ k'aripáji! ");
INSERT INTO sjaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mãpai Jesupa p'anauji: —Pia-e bɨ warrarã chik'o jãri atait'ee mãik'aapa usaarãmaa teebaibɨit'ee. Naapɨara judiorãmaa ita-aria chupɨria iidipipáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma wẽrapa mãgaji: —Wãarapɨ, Tachi Waibɨa. Mamĩda usaarãpa paara k'opata chipari mesadeepa baaida juajãra. Mapa, mɨ judio-e mĩda, pɨmaa chupɨria iidi bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mãpai Jesupa mãgaji: —Wẽra, ¡pɨa wãara ijãa bɨda! aji. Oojida aji, pɨchia k'inia badak'a. Aramata ma wẽrapa k'au iru bada jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús mamãik'aapa uchiak'ãri, wãji Galilea Lago idee. Mama bɨde ee nok'odee wãji mãik'aapa su-ak'ɨ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Eperãarã seedachida irumãi. Aneepachida bɨɨrɨ chiwa beerã; tau p'ãriu beerã; jua k'achia beerã; pedee atua beerã; awaraa k'ayaa beerã ome. Ma jõmaweda Jesús bɨɨrɨmãi bɨ chepachida. Mãpai ichia jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eperãarã ak'ɨtrua para beeji unudak'ãri pedee atua p'anadap'edaarã pedee jĩwaa para bee; jua k'achia beeda jɨpa bee; bɨɨrɨ chiwa beeda ãchi bɨɨrɨpa nĩutee; tau p'ãriu p'anadap'edaarã unu bee. Ma jõma unudak'ãri, o-ĩa ɨt'aa t'ɨ̃ p'aneejida Israel pidaarã Ak'õre Waibɨamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesupa chi k'õp'ãyoorã t'ɨ̃ p'eji mãik'aapa mãgaji: —Mɨa na eperãarã chupɨria k'awaa bɨda aji, k'ãima õpee p'anadairã nama mɨ ome nek'oda-ee. Ãyaa pëi k'inia-e bɨda aji, ewaa ode wãdade k'ap'ɨa t'ũmaadaridai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mãpai chi k'õp'ãyoorãpa mãgajida: —Mamĩda ¿sãma taipa unudayama ajida, chik'o na eperãarã chok'ara-it'ee, nama eperãarã wẽ-e perã taimaa chik'o neto pëidamerã? ");
INSERT INTO sjaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesupa ãchimaa iidiji: —¿Pan jõmasaa iru p'anɨma? aji. P'anaujida: —Iru p'anɨda ajida, pan siete, chik'o chok'ara-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mãpai Jesupa eperãarãmaa jaraji eujãde su-ak'ɨ p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Maap'eda ma pan siete chik'o ome juade ataji mãik'aapa ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa. Ma pan k'õrak'ook'ãri, chok'ara eepadachi. Mãpai chi k'õp'ãyoorãpa eperãarãmaa jedenajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jõmaarãpa k'ojida bi jãwaadarutamaa. Ma pan pite chik'o ome nɨ̃beeda p'ejida k'oraa siete. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chi nek'odap'edaarã ɨmɨk'ĩraarã cuatro mil paji; wẽraarã, warrarã juasiada-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Maap'eda Jesupa eperãarã pëiji ãchi temaa mãik'aapa barcode bataup'eda, wãji Magadán eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mama p'anɨde fariseorã saduceorã ome chejida Jesumaa. Iru ɨmɨatee k'inia p'anadap'edaa perã, iidijida ne-inaa oomerã Tachi Ak'õrepapai oopari ak'ɨpimerã wãara ichi Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mãpai Jesupa p'anauji: —K'ewaraa parãpa jarapata: “Eu pia wãit'ee, pajã p'oree wã perã.” ");
INSERT INTO sjaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ichiaba tap'eweda jarapata: “Idi eu k'achia bait'ee pajã p'oree nɨ̃bairã mãik'aapa jɨ̃ararara nɨ̃bairã.” Parãpa mãgá pajã ak'ɨ p'anɨpa eu k'achia wa eu pia k'awa p'anɨ pɨrã, ¿sãap'eda ne-inaa nãgaweda p'asamaa bɨ k'awada-e p'anɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɨ̃rapemaarã t'ãri k'achia-idaa p'anɨ Tachi Ak'õrede ijãadak'aa perã. Iidi p'anɨ mɨa oomerã ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mamĩda mɨa mãga oo-e pait'ee. Jĩp'a Tachi Ak'õrepa ooit'eeda aji, ichia oodak'a Jonás ome. Mãga jarap'eda, ãchi atabëiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lago k'ĩraik'a eere panadak'ãri, k'irãpajida pan aneeda-e padap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma t'ẽepai Jesupa mãgaji ãchimaa: —¡Ũrítɨ! K'ĩra k'awaa nipapatáatɨ fariseorã pan, saduceorã pan k'onaadamerã, ãchi levadura k'achia bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mãga ũridak'ãri, chi k'õp'ãyoorã ãchi pitapai pedee para beeji: —¡Pan aneeda-e paji! Mãga jarajida irua jara k'inia bada k'awada-e p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesupa k'awaji ãrapa k'ĩsiadap'edaa. Mapa mãgaji: —¿Sãap'eda pan wẽe p'anɨda a p'anɨma? ¿At'ãri ijãada-e p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿At'ãri k'awada-e p'anɨk'ã mɨa jaratee k'inia bɨ? ¿K'irãpada-e p'anɨk'ã pan joisomaadeepa ɨmɨk'ĩraarã cinco milmaa k'opida mãik'aapa parãpa chi beeda k'oraa sietede p'e atadap'edaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Maa-e pɨrã ¿k'irãpada-e p'anɨk'ã pan sietedeepa jedepida ɨmɨk'ĩraarã cuatro milmaa mãik'aapa parãpa chi beeda k'oraa sietede p'e atadap'edaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Sãap'eda mɨa jarada k'awada-e p'anɨma? aji. Mɨa pande pedee-e paji jarak'ãri k'onaadamerã fariseorã pan saduceorã pan ome, ãchi levadura k'achia bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mãpai k'awaajida Jesupa jara-e baji levadura jĩp'aade, pan jĩp'aa k'onaadamerã. Jara baji ijãanaadamerã fariseorãpa jarateepata saduceorãpa jarateepata ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipo p'uuru k'ait'a panak'ãri, Jesupa iidiji chi k'õp'ãyoorãmaa: —¿K'aita chi Eperã Ak'õre Truadepema a p'anɨma aji, eperãarãpa? ");
INSERT INTO sjaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","P'anaujida: —Ũk'uruurãpa jara p'anɨ pɨ Juan Bautista, piup'eda p'irabaida. Awaraarãpa jara p'anɨ pɨ Elías maa-e pɨrã Jeremías maa-e pɨrã awaraa Ak'õre pedee jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mãpai Jesupa iidiji: —Parãpárama, ¿mɨ k'aima adaima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedropa p'anauji: —Pɨ Cristoda aji; Tachi Ak'õrepa pëida eperãarã rey pamerã. Pɨ Tachi Ak'õre Waibɨa ichita chok'ai bapari Warra. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mãpai Jesupa mãgaji: —¡Simón, Juan warra, pɨ t'ãri o-ĩa bɨda aji, eperã apidaapa pɨmaa mãga k'awapi-e pada perã! Jĩp'a mɨ Ak'õre ɨt'ari bɨpata mãga k'awapiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mɨa jara bɨ: Pɨ t'ɨ̃jaradait'ee Pedro; jara k'inia bɨ “mãu”. Mãu ɨ̃rɨ te oopatak'a pia beemerã, mãga pɨk'a pɨa et'ewa jarada eperãarãpa jaradak'ãri, mɨchideerã p'aneedait'ee. Mãga p'aneedak'ãri, ichita chok'ai p'anapataadait'ee, piuruta pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Llave teepatak'a puerta ewadamerã, mãga pɨk'a mɨa pɨ k'aripait'ee eperãarã p'anapimerã Tachi Ak'õre jua ek'ari, mãgá ichideerã p'aneedamerã mãik'aapa ichi truadee wãdamerã. Na p'ek'au eujãde bɨ misa, pɨa ne-inaa oopi-e bɨ pɨrã ichideerãmaa, Tachi Ak'õrepa auk'a oopi-e pait'ee. Jõdee ne-inaa oopi bɨ ichideerãmaa, irua auk'a oopiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Maap'eda Jesupa jaraji chi k'õp'ãyoorãmaa awaraarãmaa nepɨrɨnaadamerã ichi Cristo, Tachi Ak'õrepa pëida eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Maadamãiipa Jesupa jaramaa beeji chi k'õp'ãyoorãmaa ichi wãit'ee Jerusalendee. Mama judiorã poro waibɨarãpa, p'aareerã poroorãpa mãik'aapa Moisepa p'ãda jarateepataarãpa iru miapidait'ee mãik'aapa peepit'aadait'ee. Mamĩda ewari õpeemaa chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mãga ũrik'ãri, Pedropa Jesús awara ãyaa ateeji mãik'aapa ɨtrɨamaa beeji: —¡Tachi Ak'õrepa mãga k'inia-e! ¡Pɨmaa mãga oopi-eda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mãpai Jesús p'ɨrrabaiji mãik'aapa Pedromaa mãgaji: —¡Mɨ ik'aawaapa ãyaa wã́ji, Satanapa mãga jarapida perã! ¿Pɨa mɨ wãpiamaata bɨk'ã? Mãgara k'ĩsia-e bɨ Tachi Ak'õrepa k'ĩsia bɨk'a. Jĩp'a k'ĩsiamaa bɨda aji, eperãarãpa k'ĩsiapatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Maap'eda, Jesupa mãgaji chi k'õp'ãyoorãmaa: —Eperã mɨ ome nipa k'inia bɨ pɨrã, k'ĩsiaik'araa bɨ ichia ne-inaa oo k'inia bɨdepai. Ichi kuruso ãp'aipia bɨ eperã peenadait'eek'a. Pia jarait'eera, ooipia bɨ mɨa oopi bɨk'a, ma k'aurepa miapiruta pɨjida piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Eperã piuamaa bɨ pɨrã mɨde ijãapari k'aurepa, mãgɨ́ piuk'ãri, atuait'ee. Mamĩda eperã mɨde ijãapari k'aurepa piuru pɨrã, ɨt'aa wãit'ee ichi piuk'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿K'ãare piata baima eperãpa na p'ek'au eujãde nɨ̃bɨ jõmaweda ataru pɨrã, mamĩda piup'eda chok'ai p'irabai-e pɨrã Ak'õre eujãde? Maa-e pɨrã, ¿k'ãata teeima Tachi Ak'õremaa ɨt'aa wãpimerã? ");
INSERT INTO sjaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mɨ, chi Eperã Ak'õre Truadepemapa mɨ Ak'õre k'ĩra wãree unupiit'ee, ɨt'ariipa chek'ãri iru angeleerã ome. Maapaita ak'ɨit'ee na p'ek'au eujãdepemaarãpa oopata mãik'aapa jarait'ee pia wa k'achia. Ne-inaa pia ooit'ee chi ne-inaa pia oodap'edaarãmaa. Jõdee k'achiadee pëiit'ee chi ne-inaa k'achia oopatap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mɨa wãarata jararu. Nama p'anɨɨrã ũk'uru piudai naaweda, unudait'ee mɨ, chi Eperã Ak'õre Truadepema, reyk'a pacheru. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","K'ãima seismaa Jesús wãji ee ɨt'ɨa bɨ nok'ode. Ichi ome ateeji Pedro, Santiago mãik'aapa chi ɨ̃pema Juan. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mama ãra taide Jesús k'ĩra awaradachi. Ichi k'ĩra urua nɨ̃beeji ak'õrejĩruk'a mãik'aapa chi p'aru t'o-t'oo uchiterreedachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mãga nɨde chi k'õp'ãyoorãpa unujida chonaarãweda p'anapatap'edaarã Moisés jaure mãik'aapa Elías jaure pedeemaa p'anɨ Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mãpai Pedropa mãgaji Jesumaa: —¡Tachi Waibɨa, pia bɨ nama p'anadait'ee pɨ ome! Pɨa k'inia bɨ pɨrã, mɨa ooyada aji, te chak'eerã õpee; aba pɨ-it'ee, aba Moise-it'ee, chi apema Elia-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro at'ãri mãgá pedeemaa bɨde, jɨ̃arara t'o-t'oo ɨ̃daa bɨpa ãchi aneu cheji. Madeepa Tachi Ak'õrepa pedeeji: —Nãgɨda aji, mɨ Warra k'inia; mɨa jɨrɨt'erada. Irua mɨ t'ãri o-ĩapipari. Ũrítɨ iru pedee. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mãga ũridak'ãri, ãchobeepa Jesús k'õp'ãyoorã bedabaik'oodachida tau bɨɨrɨ eujãde t'õbairutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mamĩda Jesús ãra k'ait'a chep'eda, t'õbaik'ooji mãik'aapa mãgaji: —P'irabáitɨ. Ãchobeenaadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ak'ɨdak'ãri, ãchi ik'aawa apida unuda-e paji; Jesús aupaita ãchi ome baji. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eedeepa cherutade Jesupa mãgaji: —Parãpa unudap'edaa nepɨrɨnaadapáde aji, apidaamaa mɨ, chi Eperã Ak'õre Truadepema piup'eda, chok'ai p'irabai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mãpai chi k'õp'ãyoorãpa Jesumaa iidijida: —¿Sãap'eda Moisepa p'ãda jarateepataarãpa jarapatama ajida, chonaarãwedapema Elías naapɨara cheit'ee, Tachi Ak'õrepa pëiit'ee bɨ chei k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesupa p'anauji: —Wãarata jara p'anɨ Elías naapɨara cheit'eeda adak'ãri mãik'aapa ne-inaa jõmaweda pia ooit'eeda adak'ãri, eperãarãpa auteebaidamerã iru t'ẽe cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mɨa jara bɨ: Elías jĩak'aa cheji. Mamĩda ãchia iru k'awada-e paji. Mapa ãchia oo k'iniata oojida iru ome. Ma awara auk'a oodait'ee mɨ, chi Eperã Ak'õre Truadepema ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mãpai chi k'õp'ãyoorãpa k'awaajida Jesús pedee baji Juan Bautistade. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús, Pedro, Santiago mãik'aapa Juan pachedak'ãri eperãarã see nɨ̃badamãi, eperã bedabai nɨ̃ba cheji Jesús k'ĩrapite mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tachi Waibɨa, mɨ warra chupɨria k'awáaji. Audú chupɨria nɨ̃bɨ. Wawadaipari mãik'aapa at'apai t'ɨpɨtaude maa-e pɨrã toida baainapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nama aneejida aji, pɨ k'õp'ãyoorãmaa. Mamĩda ãrapa p'oyaa jɨpada-e pajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mãpai Jesupa p'anauji: —Aai, eperãarã, ¿at'ãrita mɨde ijãada-e p'anɨk'ã? ¡Ijãadak'aarã́k'apɨ p'anɨ! ¿Jõmasaa taarãit'ee parã ome ijãarutamaa? Anéetɨ ma warra. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mãpai Jesupa ma netuara ɨtrɨat'aap'eda, uchiapit'aaji ma warra k'ap'ɨadeepa. Aweda jɨpadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maap'eda awaraarã wẽ-e pak'ãri, chi k'õp'ãyoorãpa Jesumaa iidijida: —¿Sãap'eda taipa ma netuara p'oyaa uchiapida-e pajima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesupa mãgaji: —Parãpa ijãada-e p'anadairã p'oyaa uchiapida-e paji. Mɨa wãarata jararu. Mostaza tau ma-ãri bɨk'a, mãga pɨk'a parãpa ma-ãri pida ijãarutara, jaradai ara bɨ eemaa: “Jãmãik'aapa uchiap'eda, awara ãyaa wã́ji” mãik'aapa parãpa jaradak'a ma ee ãyaa wãi. Mɨa parã k'aripak'ãri, parãpa ne-inaa jõma oodai. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nek'o-ee ɨt'aa t'ɨ̃ bɨpapai mãgee netuara uchiapiparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","At'ãri ãchi jõmaweda Galilea eujãde nidade, Jesupa mãgaji chi k'õp'ãyoorãmaa: —Eperãpa mɨ, chi Eperã Ak'õre Truadepema, k'achia beerã juade baaipiit'ee mãik'aapa ");
INSERT INTO sjaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ãchia mɨ peepit'aadait'ee. Mamĩda ewari õpeemaa chok'ai p'irabaiit'eeda aji. Mãga ũridak'ãri, k'ĩra pia-ee para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús chi k'õp'ãyoorã ome panadak'ãri Capernaum p'uurude, Tachi Ak'õre te waibɨa-it'ee impuesto p'epataarãpa Pedromaa iidi chejida: —¿Pɨ poro waibɨapa impuesto p'aaparik'ã ajida, Tachi Ak'õre te waibɨa-it'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedropa p'anauji: —P'aaparida aji. Maap'eda Pedro t'ĩuk'ãri Jesús badamãi, Jesús naapɨara pedeeji: —Simón, ¿k'ãata k'ĩsia bɨma? aji. ¿K'airãmaa impuesto p'aapipatama aji, na p'ek'au eujãdepema reyrãpa; ãchi jua ek'ari p'anɨɨrãmaa wa k'ĩra tewaraarãmaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedropa p'anauji: —K'ĩra tewaraarãmaa. Mãpai Jesupa maaji: —Mãgara ãchi jua ek'ari p'anɨɨrãpa impuesto p'aadaik'araa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mamĩda tachi ãpɨte ik'achia jaranaadamerã, wã́ji lagodee to-ɨade. Naapɨara chik'o peeru it'aide unuit'ee p'arat'a tau aba. Ma p'arat'apa impuesto p'aanapáde aji, mɨ pari mãik'aapa pɨchi k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mama p'anɨde chi k'õp'ãyoorã Jesumaa chedap'eda, iidijida: —¿Chisãgɨ́ Ak'õredeerã waibɨara bɨma ajida, iru jua ek'ari? ");
INSERT INTO sjaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mãpai Jesupa warra chai t'ɨ̃ ataji mãik'aapa ãchi esajĩak'a ak'ɨnɨ̃ bɨji. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Maap'eda mãgaji: —Mɨa wãarata jararu. Parãpa awaraa k'ĩsia atada-e pɨrã mãik'aapa na warra chak'ek'a t'ãripa ijãada-e pɨrã, p'oyaa p'aneeda-e pai Tachi Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chi ijãapari chok'ek'ee bɨ na warra chak'ek'a; mãgɨ́ waibɨara bɨ apema Tachi Ak'õre jua ek'ari p'anɨɨrã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mɨde ijãa bɨ k'aurepa nãgɨ́ warra chaik'a auteebairu pɨrã, mɨ jida auteebaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Apidaapa p'ek'au k'achia oopiru pɨrã nãgee warra chaik'a mɨde t'ãripa ijãa bɨmaa, piara bak'aji k'ũruma iru otaude jɨ̃ atadap'eda, to t'ai nãpɨa bɨmãi toidú bat'at'aadait'ee, ɨ̃yapa jɨ̃a piumerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Na p'ek'au eujãdepemaarã k'achiade p'anapata p'ek'au k'achia oopipataarã nama p'anapata perã. Ichita mãgeerã paraait'ee. Mamĩda ¡aai, chi eperãpa chĩaramaa ne-inaa k'achia oopiru, Tachi Ak'õrepa miapiit'ee perã! ");
INSERT INTO sjaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mapa pɨchi juapa maa-e pɨrã pɨchi bɨɨrɨpa ne-inaa ooda k'aurepa pɨ k'achiade baairu pɨrã, ma k'achia oo amáaji, pɨchi jua maa-e pɨrã bɨɨrɨ t'ɨap'et'aak'ajik'a. Piara bɨ ɨt'aa wãit'ee jua mosaa maa-e pɨrã bɨɨrɨ mosaa, k'ap'ɨa jõmaweda atuai k'ãyaara t'ɨpɨtau ichita jẽrajẽraa jira bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ichiaba pɨchi taupa ne-inaa unuda k'aurepa pɨ k'achiade baairu pɨrã, ma k'achia oo amáaji pɨchi tau ẽt'ak'ajik'a mãik'aapa t'ɨmɨ́ bat'at'aak'ajik'a. Piara bɨ ɨt'aa wãit'ee tau apai ome, k'ap'ɨa pia tau omeepa atuai k'ãyaara t'ɨpɨtau ichita jẽrajẽraa jira bɨde tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Nãgee warrarã apida unuamaa iru p'ananáatɨ. Mɨa jara bɨ: Ɨt'aripema angeleerã Tachi Ak'õre k'ĩrapite p'anɨɨrãpa ãra chaachaa ak'ɨpata. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mɨ, chi Eperã Ak'õre Truadepema cheji atua beerã o k'achiadeepa k'aripa atade. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—K'ĩsíatɨ nãgɨ́ nepɨrɨrude. Eperãpa cien oveja p'e iru bɨdepema aba atuadaru pɨrã, ¿atabëi-e paik'ã chi apemaarã noventa y nueve ãchi p'anapatamãi, chi atuadaida jɨrɨnait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Unu ataru pɨrã, o-ĩara bait'ee ma oveja k'aurepa, chi apemaarã atuada-e p'anɨ k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mãga bɨ ichiaba parã ɨt'aripema Ak'õre Waibɨa ome. Apida atuapiamaa bɨ, ma-ãriara bɨ pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Awaraa ijãaparipa pɨmaa ne-inaa k'achia ooru pɨrã, iru k'ĩrapite pedéeji k'awaapiit'ee irua k'achia ooda. Irua pɨ pedee ũriru pɨrã, t'ãri auk'a bɨdai. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mamĩda irua pɨ pedee ũri k'inia-e bɨ pɨrã, t'ɨ̃ atáji eperã omé maa-e pɨrã õpee, mãɨrã wãdamerã pɨ ome mãik'aapa auk'a ũridamerã pɨa ɨmɨateeru. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","At'ãri ũri k'inia-e bɨ pɨrã, jaráji ijãapataarã jõmaarãmaa; pɨ ome chip'epataarã ɨt'aa t'ɨ̃pataadait'ee. Mãgɨɨrã pedee paara ũri k'inia-e bɨ pɨrã, mãgara ichi beeit'ee Ak'õrede ijãak'aa bɨk'a, maa-e pɨrã impuesto p'eparik'a Roma pidaarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Mɨa wãarata jararu. Na p'ek'au eujãde p'anɨ misa, parãpa ne-inaa oopida-e p'anɨ pɨrã, Tachi Ak'õrepa auk'a oopi-e pait'ee. Jõdee ne-inaa oopiruta pɨrã, irua auk'a oopiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Waya mɨa jara bɨ: Parãdepema omé pedeedak'ãri, t'ãri a-ba ne-inaa ɨt'aa iidiruta pɨrã, mɨ Ak'õre ɨt'ari bɨpa teei. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Eperãarã omé maa-e pɨrã õpee chip'edaidak'ãri mɨde ijãapata k'aurepa, mɨ auk'a bait'ee ãchi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mãpai Pedropa Jesumaa iidiji: —Tachi Waibɨa, ijãapari awaraapa mɨmaa ne-inaa k'achia ook'ãri, ma ooda ¿jõmasaa perdonaaipia bɨma? aji. ¿Siete k'achia ooda aupai perdonaaipia bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesupa p'anauji: —Mɨa pɨmaa sietepai jara-e bɨ. Pɨmaa setenta ne-inaa k'achia ooda juasiada siete perdonaaipia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Maperã nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Reypa ichi ek'ariirãpa p'arat'a p'aa p'anadap'edaa ak'ɨ k'inia baji k'awaait'ee tewe paraa p'anɨ wa wẽe p'anɨ ichi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mãga nɨde eperã aneejida. Mãgɨ́ eperãpa millón chok'ara paraa baji ma reymaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma mimiaparipa p'oyaa p'aai wẽe bada perã, reypa jaraji netot'aadamerã esclavok'a; chi wẽra, chi warrarã ome, jõma ichi net'aa iru bɨ paara. Mãgá chi tewe paraa bada p'aayada aji, reypa. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mamĩda ma mimiapari rey k'ĩrapite bedabaidachi mãik'aapa chupɨria iidiji: “Mɨ chupɨria k'awaapáde aji. Choopáde aji, mɨ ome mɨa jõma p'aait'ee perã.” ");
INSERT INTO sjaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mãga ũrik'ãri, reypa chupɨria k'awaaji. Ma eperã tewe paraa bada perdonaaji mãik'aapa pëiji ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Mamĩda ma eperã taawaa uchiarude unuji ichi k'õp'ãyo ome. Mãgɨpa ichimaa mak'ɨara p'arat'a paraa-e baji. Mamĩda ichia chi k'õp'ãyo otaude jita ataji mãik'aapa ɨ̃yapa jɨ̃a wãk'ãri, mãgaji: “¡P'aapáde aji, mɨmaa paraa bɨ!” ");
INSERT INTO sjaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mãpai chi k'õp'ãyo bedabaidachi ichi k'ĩrapite mãik'aapa chupɨria iidiji: “Choopáde aji, mɨ ome. Mɨa jõma p'aait'eepɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mamĩda chi apemapa ũri k'inia-e paji. Ma k'ãyaara carcelde t'ɨpit'aaji p'aa jõrumaa chi tewe paraa bada. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mãga unudak'ãri, apema rey ek'ari p'anadap'edaarã k'ĩra pia-ee p'aneejida mãik'aapa reymaa ma jõma jaranajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mãga ũrik'ãri, ma reypa chi tewe paraa bada t'ɨ̃ pëiji. Pachek'ãri, reypa mãgaji: “¡T'ãri k'achia-idaa bɨda! aji. ¡Pɨa chupɨria iidi chek'ãri mɨmaa, mɨa chupɨria k'awaaji mãik'aapa pɨa tewe paraa bada perdonaaji! ");
INSERT INTO sjaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Sãap'eda pɨa auk'a oo-e pajima aji, pɨchi k'õp'ãyo ome?” ");
INSERT INTO sjaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma rey audú k'ĩrau bada perã ma mimiapari ome, carcelde t'ɨpit'aaji chi tewe p'aa jõrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mãpai Jesupa mãgaji: —Mãga pɨk'a ooit'ee mɨ Ak'õre ɨt'ari bɨpa ichiaba parã ome, parãpa awaraarã chupɨria k'awaada-e pɨrã mãik'aapa t'ãripa perdonaada-e pɨrã ãrapa parãmaa ne-inaa k'achia ooda. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ma pedee jarap'eda, Jesús wãji Galilea eujãdeepa. Panaji Judea eujãde, Jordán to k'ĩraik'a eere. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eperãarã chok'ara wãjida Jesús t'ẽe. Mãgá irua ãchi k'ayaa jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mama fariseorã ũk'uru irumaa chejida. Moisepa p'ãda merapii jĩak'aapa, iidijida: —¿Ɨmɨk'ĩrapa ichi wẽra ichi k'inia amaaipia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesupa p'anauji: —¿Tachi Ak'õre Ũraa p'ã bɨde parãpa nãga leeda-e p'anɨk'ã? aji. Na eujã ook'ãri, ‘Ooji ɨmɨk'ĩra mãik'aapa wẽra’. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Mapa ɨmɨk'ĩrapa atabëiit'ee chi ak'õre chi nawe ome, araa p'anapataadait'ee chi wẽra ome. Mãgá eperã omee weda eperã apai pɨk'a p'aneedait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eperã omé p'anɨ mĩda, jĩp'a eperã apai pɨk'a p'aneepata. Mapa Tachi Ak'õrepa eperãarã omé araa papik'ãri, apidaapa amaapidaik'araa bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mãpai ma fariseorãpa iidijida: —Mãgara, ¿sãap'eda Moisepa jarajima ajida, wẽra amaaru pɨrã, mia amaada k'art'a p'ã teeipia bɨ jëret'aadai naaweda? ");
INSERT INTO sjaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesupa p'anauji: —Mãga jaraji parã k'ɨɨrɨ k'isua p'anadairã. Moisepa pãchi wẽra amaapiji. Mamĩda Tachi Ak'õrepa na eujã ewaa ook'ãri, mãga-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mɨa jara bɨ: Eperãpa amaat'aaru pɨrã chi wẽra awaraa ɨmɨk'ĩra ome bɨ-eeta, maap'eda awaraa wẽra ome miak'ãiru pɨrã, p'ek'au oomaa bɨda aji, ma t'ẽepema wẽra ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mãpai chi k'õp'ãyoorãpa mãgajida: —Mãga pɨrã, ɨmɨk'ĩra miak'ãik'araa bɨda ajida, wẽra ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mãpai Jesupa mãgaji: —Jõmaarãpa k'awada-e mɨa et'ewa jarada. Jĩp'a k'awadait'ee Tachi Ak'õrepa k'awapi k'inia bɨɨrãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Edaare ɨmɨk'ĩraarã wẽra ata k'iniadak'aa. Ɨmɨk'ĩraarã ũk'uru ãchi t'oruta weda p'oyaa warra oodak'aa. Ũk'uru k'ap'adap'edaa perã p'oyaa warra oodak'aa. Awaraarã miak'ãi k'iniadak'aa jĩp'a ɨt'aa t'ɨ̃dait'ee Tachi Ak'õremaa mãik'aapa oodait'ee irua oopi bɨk'a, wẽrade k'ĩsia-ee. Mãga p'oyaa ooruta pɨrã, oodapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maap'eda eperãarãpa ãchi warrarã aneejida Jesumaa iru jua bɨmerã ãra ɨ̃rɨ mãik'aapa ɨt'aa t'ɨ̃merã ãra pari. Mamĩda Jesús k'õp'ãyoorãpa mãga unudak'ãri, ma warrarã aneedap'edaarã ɨtrɨajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mãpai Jesupa mãgaji: —¡Ɨtrɨanáatɨ! Ichiak'au mɨmaa warrarã chepítɨ, Tachi Ak'õrepa ãra jĩak'aarã bɨit'ee perã ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mãga jarap'eda, ichi jua ãra ɨ̃rɨ bɨ wãpachi mãik'aapa ɨt'aa t'ɨ̃ji ãra pari. Maap'eda ichi ode wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maapai k'ũtrãapa Jesumaa iidi cheji: —Tachi Jarateepari, ¿k'ãare ne-inaa piata ooipia bɨma aji, ɨt'aa wãit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesupa p'anauji: —¿Sãap'eda mɨmaa mãga iidi bɨma? aji. Tachi Ak'õre aupaita pia bɨ. Pɨ ɨt'aa wã k'inia bɨ pɨrã, oopáde aji, Tachi Ak'õrepa Moisemaa p'ãpidade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma k'ũtrãapa iidiji: —¿Chisãgɨ́ ũraade jara bɨk'a ooipia bɨma? aji. Jesupa p'anauji: —‘Eperã peenáaji; miak'ãi bɨ pɨrã, awaraarã ome k'ãináaji; nechɨanáaji; seewa jaranáaji chĩara k'achiade baaipiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pɨchi ak'õre mãik'aapa pɨchi nawe k'inia iru baparíiji mãik'aapa ãra pedee ũriparíiji. Awaraarã k'inia iru baparíiji pɨchi k'ap'ɨa k'inia iru baparik'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mãpai ma k'ũtrãapa mãgaji: —Ma jõma ooparida aji. ¿K'ãata waa ooyama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesupa p'anauji: —Ne-inaa jõma oo k'inia bɨ pɨrã Tachi Ak'õrepa k'inia bɨk'a, pɨchi net'aa netok'oonáji mãik'aapa chupɨria beerãmaa ma p'arat'a téeji. Mãga ooru pɨrã, ne-inaa pipɨara iru bait'ee Tachi Ak'õre eujãde. Mãga oop'eda, mɨ ome nipa chéji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma k'ũtrãapa mãga ũrik'ãri, k'ĩra pia-ee wãji, p'arat'a audú k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Maap'eda Jesupa mãgaji chi k'õp'ãyoorãmaa: —Mɨa wãarata jararu. Chaaree bait'ee p'arat'ara bɨ beeit'ee Tachi Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Waya jarait'ee. Chaareera bɨda aji, p'arat'ara bɨ beeit'ee Tachi Ak'õre jua ek'ari, camello aguja taude wãyaai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chi k'õp'ãyoorãpa mãga ũridak'ãri, waapɨara p'era pɨk'a para beeji. Mãpai iidijida: —Mãgara, ¿k'aita p'oyaa ɨt'aa wãyama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesupa ãchimaa ak'ɨji mãik'aapa p'anauji: —Eperãarãpa p'oyaa ooda-e, audú chaaree bairã. Mamĩda Tachi Ak'õre-it'ee ne-inaa chaaree wẽ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mãpai Pedropa mãgaji: —Tai net'aa jõmaweda atabëijida pɨ ome nipapataadait'ee. ¿K'ãata atadait'eema aji, ma pari? ");
INSERT INTO sjaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesupa p'anauji: —Mɨa wãarata jararu. Tachi Ak'õrepa k'inia bak'ãri, mɨ, chi Eperã Ak'õre Truadepema, su-ak'ɨ beepiit'ee ichi rey su-ak'ɨ beeparide ɨt'ari ichi k'ĩra wãreede. Maapai parã mɨ ome nipapatap'edaarã auk'a mama su-ak'ɨ p'aneedait'ee rey su-ak'ɨ beepari docede. Mama parãpa Israeldeepa ëreerã doce uchiadap'edaarã iru p'anadait'ee parã jua ek'ari mãik'aapa jaradait'ee mãɨrãpa oopatap'edaa pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eperã mɨde ijãa bɨ k'aurepa atabëiru pɨrã ichi te, ɨ̃pemaarã, ɨ̃pewẽraarã, ak'õre, nawe, warrarã maa-e pɨrã eujã, ma k'ãyaara mãgee ne-inaa pia atada cien atait'ee na p'ek'au eujãde bɨ misa. Ma awara piuk'ãri, ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mamĩda ɨ̃rapema waibɨara p'anɨɨrã eperãarã k'ĩrapite, ek'ariara p'anadait'ee Tachi Ak'õre k'ĩrapite. Jõdee ek'ariara p'anɨɨrã eperãarã k'ĩrapite waibɨara p'anadait'ee Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Tap'eda eujã chipari uchiaji mimiapataarã jɨrɨde ichi uva k'ãide mimianadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mimiapataarãmaa jaraji ewari aba mimiada pari denario aba p'aait'ee ma mimiapataarã chaachaa. Mãpai pëiji mimiade. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ãstaawa ma eujã chipari waya uchiaji mimiapataarã jɨrɨde. P'uuru jãde net'aa netopatamãi unu cheji mimiapataarã mimia wẽe para bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mãga unuk'ãri, mãgaji: “Parã ichiaba wãdapáde aji, mimiade mɨ uva k'ãide. Mɨa pia p'aayada aji, parã mimia pari.” Mãpai wãjida mimiade. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Imat'ɨpa ma eujã chipari waya uchiaji mimiapataarã jɨrɨde, aɨ naaweda oodak'a. Ichiaba k'ewara auk'a ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mata waya k'ewaraa uchiaji mãik'aapa waya unu cheji awaraa mimiapataarã p'uuru jãde p'anɨ, mimia wẽe para bɨ. Mapa mãgaji: “¿Sãap'eda parã nama mimiada-ee k'eu wãdama?” aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","P'anaujida: “Apidaapa taimaa mimia teeda-e perã, mimiada-e p'anɨda” ajida. Mãpai ma eujã chiparipa mãgaji: “Mimianadapáde aji, mɨ uva k'ãide.” ");
INSERT INTO sjaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’P'ãriupodopa ma eujã chiparipa mãgaji chi mimiapataarã poro waibɨamaa: “T'ɨ̃páde aji, mimiapataarã jõmaweda. Naapɨara p'aapáde aji, chi t'ẽe t'ĩudap'edaarãmaa mãik'aapa jõmaarã k'ãyaara t'ẽe p'aapáde aji, chi naapɨara t'ĩudap'edaarãmaa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mãga ooji. K'ewara t'ĩudap'edaarãmaa p'aaji denario aba, eperã chaachaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Apemaarãmaa p'aa aupak'ãri, pachejida chi naa mimiadap'edaarã. Mãgɨɨrãpa k'ĩsiajida p'arat'a audupɨara jitadait'ee apemaarã k'ãyaara. Mamĩda mãga-e paji. Ãchimaa ichiaba denario abapai p'aaji ãchi mimiadap'edaa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ãchi p'arat'a jitadak'ãri, ik'achia pedee p'aneejida ma eujã chipari ome: ");
INSERT INTO sjaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ma t'ẽe hora apai mimiadap'edaarãmaa pɨa denario aba p'aajida ajida. Jõdee tai tap'eda weda ak'õrejĩrumaa mimia k'eudap'edaa párita ãchi ome auk'a p'aaji. ¡Taimaa audupɨara teeipia bɨda!” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mamĩda ma eujã chiparipa ãchidepema abaamaa p'anauji: “Mɨa parã k'ũra-eda aji. ¿Parãpa jarajida-ek'ã aji, ewari aba mimiada pari denario abapai iididait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pɨchi p'arat'a jitapáde aji, mãik'aapa k'ãiwee wãpáde aji. Mɨa auk'a p'aa k'inia bɨ pɨrã chi t'ẽe t'ĩudap'edaarãmaa, mãga ooit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mɨ na eujã chipari-ek'ã? aji. Mɨchi p'arat'a ome ooi mɨchia oo k'inia bɨk'a, mëré perã. ¿Parã t'ãri k'achia jõnɨk'ã aji, mɨ t'ãri pia bairã?” ");
INSERT INTO sjaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mãga nepɨrɨp'eda, Jesupa mãgaji: —Mãga bɨ Tachi Ak'õre ome. Ɨ̃rapema t'ẽe chedap'edaarã Tachi Ak'õrepa ãchi bɨmerã ichi jua ek'ari, naapɨara ichideerã p'aneedait'ee ichi k'ĩrapite. Mamĩda chi naapɨara chedap'edaarã Tachi Ak'õrepa ãchi bɨmerã ichi jua ek'ari, mãga p'aneeda-e payada aji, t'ẽe p'aneedait'ee perã ichi k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús wãrude Jerusalén p'uurudee, chi k'õp'ãyoorã doce awara ãi t'ɨ̃ p'e ataji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Tachi wãruta Jerusalendee. Mama mɨ, chi Eperã Ak'õre Truadepema, jita atadait'ee mãik'aapa ateedait'ee p'aareerã poroorãmaa mãik'aapa Moisepa p'ãda jarateepataarãmaa peepit'aadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mãɨrãpa mɨ teedait'ee k'ĩra tewaraarãmaa mɨ oo iru p'anadamerã, wɨdamerã, mãik'aapa kurusode peet'aadamerã. Mamĩda ewari õpeemaa waya chok'ai p'irabaiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo wẽra chi warrarã Santiago, Juan ome Jesús k'ait'a chejida. Ma wẽra iru k'ĩrapite bedabai nɨ̃ba cheji chupɨria iidiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mãga unuk'ãri, Jesupa iidiji: —¿K'ãata k'inia bɨma? aji. Ma wẽrapa p'anauji: —Jarapáde aji, pɨ eperãarã rey beek'ãri, mɨ warrarã su-ak'ɨ p'aneedamerã pɨ ik'aawa, aba juaraare, aba juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mãpai Jesupa mãgaji ma warrarãmaa: —Parãpa wãara k'awada-e p'anɨ k'ãata iidi p'anɨ. ¿Parãpa ne-inaa k'achia choodaik'ã aji, mɨa chooit'ee bɨk'a? P'anaujida: —¡P'oyaadaipɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mãpai Jesupa mãgaji: —Parãpa ne-inaa k'achia choodait'eeda aji, mɨa chooit'ee bɨk'a. Mamĩda mɨa p'oyaa jara-e k'airãta mɨ juaraare wa juabi eere su-ak'ɨ p'aneedait'ee. Mɨ Ak'õrepapai jarayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Apemaarã diez k'õp'ãyoorãpa ũridak'ãri Santiago Juan ome iididap'edaa, k'ĩraudachida ãchi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mapa Jesupa chi k'õp'ãyoorã jõmaweda t'ɨ̃ p'e atap'eda, mãgaji: —Parãpa k'awa p'anɨ ijãadak'aa beerã poro waibɨarãpa ãchia oo k'iniata oopipata eperãarãmaa. Waaweepa ãchi jua ek'ari p'anɨɨrãpa oopata ãchia jara p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mamĩda parãpa oodaik'araa bɨ ma poro waibɨarãpa oopatak'a. Ma k'ãyaara ijãapataarã t'ãide chi waibɨara pa k'inia bɨpa apemaarã chupɨria k'awaaipia bɨ mãik'aapa k'aripaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pia jarait'eera, parãdepema aba poro waibɨa pa k'inia bɨ pɨrã, awaraarã k'aripaipia bɨ esclavopa chipari k'aripaparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mɨ, chi Eperã Ak'õre Truadepema mĩda, na p'ek'au eujãde che-e paji eperãarãpa mɨ jĩia ɨadamerã. Jĩp'a cheji eperãarã k'aripa atait'ee o k'achiadeepa. Piut'ee eperãarã chok'ara uchiadamerã p'ek'au k'achia jua ek'ariipa. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús chi k'õp'ãyoorã ome Jericó p'uurudeepa uchia wãdak'ãri, eperãarã chok'ara t'ẽe nipajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mama tau p'ãriu bee omé o bi ik'aawa su-ak'ɨ p'anajida. Ũridak'ãri Jesuta wãyaa wã, biajida: —¡Tachi Waibɨa, Rey David Warra, tai chupɨria k'awaapáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eperãarã auk'a wã nipadap'edaarãpa ɨtrɨat'aapachida k'ĩup'ee p'aneedamerã. Mamĩda waapɨara biapachida: —¡Tachi Waibɨa, Rey David Warra, tai chupɨria k'awaapáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mãpai Jesús ak'ɨnɨ̃ beep'eda, t'ɨ̃ ataji mãik'aapa iidiji: —¿K'ãata k'inia p'anɨma aji, mɨa oomerã parã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","P'anaujida: —Tachi Waibɨa, tachi taupa pia unu k'inia p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mãga ũrik'ãri, Jesupa chupɨria k'awaaji mãik'aapa taumãi t'õbaiji. Aweda tau pia unujida. Mãpai wãjida Jesús t'ẽe. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalendee wãdak'ãri, panajida Betfagé p'uuru k'idaa. Ma p'uuru Olivo Eede baji, Jerusalén k'ait'a. Mama p'anɨde Jesupa chi k'õp'ãyoorã omé naa pëiji p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Mãgaji: —Wã́tɨ ara bɨ p'uuru tachi k'ĩrapite bɨmaa. Jãma ununadait'ee burro wẽra jɨ̃ bainɨ̃ bɨ chi warra ome. Ẽra atátɨ mãik'aapa anéetɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Apidaapa ateepi-e pɨrã, jarátɨ: “Tachi Waibɨapa arak'atɨa atee k'inia bɨ. Waya tee chedait'eepɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mãga paji chonaarãweda Ak'õre pedee jaraparipa jaradak'a: ");
INSERT INTO sjaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Jarátɨ Sión p'uurudepemaarãmaa: “¡Ak'ɨ́tɨ! Pãchi Rey cheru, chupɨria beerã chepatak'a burro ɨ̃rɨ. Cheru ne-animal ne-inaa uapata warra, burro chak'e ɨ̃rɨ.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús k'õp'ãyoorã wãjida mãik'aapa oojida irua jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aneejida ma burro wẽra chi warra chai ome. Maap'eda ma ɨ̃rɨ ata bɨjida ãchi ɨ̃rɨpema p'aru jɨ̃patap'edaa, Jesús bataup'eda aɨde su-ak'ɨ beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eperãarã ode see nɨ̃baji. Ũk'uruurãpa ãchi p'aru t'õ jẽra bɨjida o jãde, Jesús aɨde wãmerã. Awaraarãpa k'iru t'ɨap'edap'eda, bɨpachida ma o jãde, ãchi rey pai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesús naa wãdap'edaarãpa mãik'aapa t'ẽe che wãdap'edaarãpa o-ĩa biapachida: —‘¡Hosana! ¡Tachi K'aripapari, Rey David Warra cheru! ¡Tachi Ak'õrepa ichita pia ak'ɨ bapariit'ee ichia rey pëida! ¡K'ĩra wãree Ak'õre eujãde, Tachi K'aripapari cheru perã! ¡Hosana!’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalén p'uurude panak'ãri, p'uuru pidaarã jõma biuk'a nɨ̃beeji. Chok'araarãpa iidipachida: —¿K'aima ajida, jãgɨ́? ");
INSERT INTO sjaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mãpai awaraarãpa p'anaujida: —Nãgɨ́ Jesús, Tachi Ak'õre pedee jaraparipɨ, Nazaret p'uurudepema. Mãgɨ́ p'uuru Galilea eujãde bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Maap'eda Jesús Tachi Ak'õre te waibɨade t'ĩuji mãik'aapa net'aa netopataarã taawaa jërek'ooji. P'arat'a tau t'erabaipataarã mesa sĩa bat'ak'oo wãji, paloma netopataarã banco paara. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mãpai mãgaji: —Tachi Ak'õre Ũraa p'ã jẽra bɨde jara bɨ: ‘Mɨ te ɨt'aa t'ɨ̃pata teda apataadait'ee.’ ‘Mamĩda parãpa nechɨapataarã ték'ata oo iru p'anɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús at'ãri Ak'õre te waibɨade bɨde, irumaa chejida tau p'ãriu beerã mãik'aapa chiwa beerã. Mãpai Jesupa jõma jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mamĩda p'aareerã poroorã Moisepa p'ãda jarateepataarã ome k'ĩraudachida unudak'ãri Jesupa ma ne-inaa pia oo bɨ mãik'aapa ũridak'ãri warrarã nãga bia para bɨ Tachi Ak'õre te waibɨade: “¡Hosana! ¡Tachi K'aripapari, Rey David Warra!” ");
INSERT INTO sjaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mãpai Jesumaa mãgajida: —K'ĩup'ee beepipáde ajida. ¿Ũri-e bɨk'ã ajida, ãchia jara jõnɨ? Jesupa p'anauji: —Ũri bɨda aji. ¿Parãpa nãgɨ́ leeda-e p'anɨk'ã? ‘Ak'õre, pɨa warra chak'eerãmaa k'aripipari mãik'aapa jude beerãmaa t'ãri o-ĩa ɨt'aa t'ɨ̃ k'awapipari.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mãpai Jesupa mãɨrã atabëiji mãik'aapa wãji Betania p'uurudee k'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tap'eda Jesús waya chek'ãri p'uurudee, jarrapisia nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma che wãde higuera bɨɨrɨ unuji o bi ik'aawa bainɨ̃ bɨ, k'iru paraa. Mãpai araa ak'ɨnaji, chau bɨ jĩak'aapa. Mamĩda chau-ee baji. Chi k'iru aupaita unuji. Mãpai ma higuera bɨɨrɨmaa mãgaji: —¡Pɨ waa chauk'aa pait'eeda! aji. Aweda ma higuera bɨɨrɨ pɨɨdachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mãga unudak'ãri, chi k'õp'ãyoorã ak'ɨtrua para beeji mãik'aapa mãgajida: —¿Sãap'eda aweda jã higuera bɨɨrɨ jãgá pɨɨdachima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesupa p'anauji: —Mɨa wãarata jararu. Parãpa Tachi Ak'õrede wãara ijãaruta pɨrã, iididaipia bɨ irua ne-inaa oomerã; pãchi t'ãridepai k'ĩsiada-ee: “¿Tachi Ak'õrepa ooik'ã?” Mãgara mɨa oodak'a jã higuera bɨɨrɨ ome, parãpa oodai. Ma awara ara bɨ eemaa jararutara “Jãmãik'aapa ãyaa wã́ji mãik'aapa p'usa jãde baaináji”, mãga oopidaipɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Parãpa ne-inaa jõma iidiruta ɨt'aa t'ɨ̃ p'anɨde t'ãripa ijãa p'anadairã, ma ne-inaa iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ma t'ẽepai Jesús t'ĩunaji Tachi Ak'õre te waibɨade. Mama jarateemaa bɨ misa, p'aareerã poroorãpa judiorã poro waibɨarã ome Jesumaa iidijida: —¿Tachi Ak'õrepa tai bɨji-ek'ã ajida, ichi te waibɨa ak'ɨdamerã? ¿K'aipa pɨmaa nãga oopi bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesupa p'anauji: —Mɨa pida parãmaa iidiit'ee: ¿K'aipa pëijima aji, Juan Bautista poro choo chemerã; Tachi Ak'õrepa maa-e pɨrã eperãarãpa? Parãpa p'anaurutara, mɨa pida jarayada aji, k'aipa mɨmaa nãga oopi bɨ. Mãpai ãchi pitapai pedee para beeji: —Tachi Ak'õrepa pëidada aruta pɨrã, irua iidiit'ee: “Mãgara ¿sãap'eda Juan ũraa ijãada-e pajima?” ");
INSERT INTO sjaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jõdee jararuta pɨrã “eperãarãpa Juan pëijida”, jõmaweda k'ĩraudaridait'ee tachi ome, ãchia ijãapata perã Juan Tachi Ak'õre pedee jarapari paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mapa p'anaujida: —K'awada-e p'anɨda ajida, k'aipa Juan pëiji. Mãpai Jesupa mãgaji: —Mãgara mɨa pida jara-eda aji, k'aipa mɨmaa nãga oopi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mãpai Jesupa iidiji: —¿K'ãata k'ĩsia p'anɨma aji, parãpa? Eperãpa warrarã omé iru baji. Abaamaa jaraji: “Warra, wãpáde aji, mimiade mɨ uva k'ãide.” ");
INSERT INTO sjaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chi warrapa p'anauji: “¡Mɨ wã k'inia-eda!” aji. Mamĩda t'ẽepai, k'ĩsia awara ataji mãik'aapa wãji mimiade. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Maap'eda ma eperãpa chi apema warramaa auk'a jaranaji. Ma warrapa p'anauji: “Ak'õre, mɨ wãit'eeda aji, mimiade.” Mamĩda mimiana-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mãpai Jesupa iidiji: —¿Chisãgɨ́ warrapa oojima aji, chi ak'õrepa k'inia badak'a? P'anaujida: —Chi naa chok'ada warrapa. Mãpai Jesupa mãgaji: —Mɨa wãarata jararu. Cesar-it'ee impuesto p'epataarã mãik'aapa prostitutaarã Tachi Ak'õredeerã p'aneedait'ee parã naa. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","¿Sãap'eda? Juan Bautista chek'ãri jarateede eperãarãpa p'ek'au k'achia oo amaadamerã mãik'aapa t'ãri pia p'anapataadamerã, parãpa ijãada-e paji. Jõdee ma Cesar-it'ee impuesto p'epataarã mãik'aapa ma prostitutaarãpa ijãajida Juan pedee mãik'aapa oojida irua jaradak'a. Mamĩda parãpa mãga unujida mĩda, k'ĩsia awara atada-e paji iru pedee ijãadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Ũrítɨ mɨa nepɨrɨru jarateeit'ee: Eujã chiparipa uva eujã uuji mãik'aapa t'ɨak'auk'ooji. Ichiaba bõgo mãudee ooji uva aɨde piart'ɨdait'ee. Mãpai te ɨt'ɨa ooji ɨt'ɨɨpa uva eujã jõma ak'ɨ p'anadamerã. Maap'eda ne-uu eujã ak'ɨpataarã jɨrɨji aɨde mimiadamerã mãik'aapa awara ãyaa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","T'ẽepai uva oropata ewari pak'ãri, pëiji chi mimiapataarã iidinadamerã ichi eere bee bɨ chauda tee pëidamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mamĩda chi eujã ak'ɨpataarãpa ma mimiapataarã jita atadak'ãri, aba sĩk'oojida, awaraa jĩp'a peejida mãik'aapa awaraamaa mãupa bat'ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Maap'eda ma eujã chiparipa awaraa mimiapataarã pëiji. Mamĩda ma ne-uu ak'ɨpataarãpa naaweda oodap'edaak'a oojida mãɨrã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Maap'eda, chi warra pëiji. K'ĩsiaji: “Mɨ warra perã iru waaweedait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mamĩda mãgɨ́ unudak'ãri, mãgajida: “Jãgɨpa ichi ak'õre net'aa jõmaweda atait'ee chi ak'õre piuk'ãri. Peet'aadáma ajida. Mãgá na eujã jõmaweda tachide payada” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mãga k'ĩsiadap'edaa perã, chi warra atadachida mãik'aapa ma uva eujãdeepa uchia atadap'eda, peet'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mãpai Jesupa mãgaji arii p'anadap'edaarãmaa: —Chipari wãk'ãri ma eujã ak'ɨpataarãmaa, ¿k'ãata k'ĩsia p'anɨma aji, irua ooit'ee ma ak'ɨpataarã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","P'anaujida: —Ma eujã ak'ɨpataarã jõmaweda peek'ooit'ee, chupɨria k'awa-ee. Mãpai ma uva eujã bɨyada ajida, awaraarã jua ek'ari, chaujara pak'ãri ãchia teedamerã ichi eerepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mãpai Jesupa mãgaji: —¿Parãpa waide nãga leeda-e p'anɨk'ã aji, Tachi Ak'õre Ũraa p'ã jẽra bɨde? ‘Te oopataarãpa mãu k'iniada-e padap'edaa pipɨara padachi. Tachi Ak'õrepa mãga ooji, tachia unudamerã mãik'aapa ak'ɨtrua para beemerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Maperã mɨa jara bɨ: Tachi Ak'õrepa parã bɨ-e pait'ee ichi jua ek'ari, ichideerã p'aneedamerã. Ma k'ãyaara awaraarãta ichideerã p'aneedait'ee, ãchia teepata perã ichi eerepema chauru, parãpa teedai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","‘Eperã ma mãu pipɨara bɨ ɨ̃rɨ t'ĩutɨru pɨrã, mãgɨ́ p'u oodaipari, p'arat'u mãu ɨ̃rɨ baaik'ãri ãridaiparik'a. Jõdee ma mãu eperã ɨ̃rɨ baairu pɨrã, mãgɨ́ jõt'aait'ee mãu choma p'arat'u ɨ̃rɨ baaik'ãri jõdaiparik'a; chi p'ora aupai beeparik'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","P'aareerã poroorãpa fariseorã ome Jesupa nepɨrɨda ũri aupadak'ãri, k'awaajida irua ãchideta jara baji. ");
INSERT INTO sjaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mapa iru jita atapi k'iniadachida. Mamĩda waawee p'anajida eperãarãpa ijãa p'anadap'edaa perã Jesús Tachi Ak'õre pedee jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesupa waya jarateemaa beek'ãri, nepɨrɨji: ");
INSERT INTO sjaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Reypa k'ĩsia iru baji miak'ãipata fiesta ooit'ee ichi warra-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chi mimiapataarã pëiji ichia eperãarã t'ɨ̃ pëida p'e atanadamerã. Mamĩda che k'iniada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Waya awaraa mimiapataarã chok'ak'ãri, mãgaji: “Jaranadapáde aji, mɨa t'ɨ̃ pëida eperãarã chedamerã chik'o ĩipa nɨ̃bairã. Peepiji p'ak'a, awaraa ne-animal poreera iru bada ome. Mãgɨ́ jõma ĩipa ak'ɨnɨ̃ bairã, chedapáde aji, miak'ãipata fiesta oode.” ");
INSERT INTO sjaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mamĩda ma eperãarãpa ũri k'iniada-e paji irua jara pëida. Fiesta oode chedai k'ãyaara, aba wãji ichi eujãdee. Jõdee awaraa wãji net'aa netode. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Apemaarãpa eperãarã reypa pëida jita atadak'ãri, p'ua oojida peet'aarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Reypa mãga k'awaa atak'ãri, k'ĩraudachi. Mapa pëiji ichi soldaorã ma eperãarã peenadamerã mãik'aapa ãchi p'uuru paat'aadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maap'eda mãgaji chi mimiapataarãmaa: “Miak'ãipata fiesta at'ãri oodait'ee. Mamĩda ooda-e ma t'ɨ̃ pëida eperãarã ome, chedaamaa p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mapa wãdapáde aji, calle jãdee mãik'aapa chi unurutaarãmaa jaradapáde aji, mɨ ome fiesta oode chedamerã.” ");
INSERT INTO sjaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aramãgá chi mimiapataarã wãjida calle jãdee. Chok'ara p'e aneejida; eperãarã pia beerã, k'achia beerã paara. Mãgá ma rey te p'ĩu nɨ̃beeji eperãarãpa. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Mamĩda rey t'ĩuk'ãri ma p'e aneedap'edaarã ak'ɨde, unuji eperã miak'ãipata fiestade jɨ̃pata p'aru jɨ̃-ee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mapa mãgaji: “K'õp'ãyo, ¿sãga t'ĩujima aji, nama, fiestade p'aru jɨ̃pata jɨ̃-ee?” Mamĩda ma eperã k'ĩup'ee beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Maperã reypa jaraji chi mesa ak'ɨpataarãmaa: “Jã eperã bɨɨrɨ, jua ome jɨ̃ nɨ̃bɨdapáde aji, mãik'aapa taawaa p'ãriudee ateedapáde aji, mama jẽemerã, k'ida kierrkierree para bamerã p'uapa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tachi Ak'õrepa chok'ara t'ɨ̃ pëipari. Mamĩda chok'ara-ee jɨrɨt'erapari wãpiit'ee ichi truadee. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma t'ẽepai fariseorã chip'edaidap'eda, pedeeteejida Jesús k'ũradait'ee. P'anauru pɨrã, ɨmɨateedai mãik'aapa peepit'aadai. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma-it'ee pëijida ãchi eere p'anadap'edaarã, Rey Herodes eere p'anadap'edaarã ome Jesumaa. Mãɨrãpa mãgajida: —Tachi Jarateepari, taipa k'awa p'anɨ pɨa wãarata jarapari mãik'aapa jarateepari p'anapataadamerã Tachi Ak'õrepa k'inia bɨk'a, eperãarãpa ãchia k'iniata oopata mĩda. K'awa p'anɨ pɨa eperãarã ɨ̃rɨpai ak'ɨk'aa; ma k'ãyaara tachi t'ãride iru bɨ ak'ɨpari. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maperã k'awa k'inia p'anɨ pɨa k'ãata k'ĩsia bɨ. ¿Pia bɨk'ã ajida, impuesto p'aadait'ee Cesarmaa, wa mãga-e? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesupa k'awa bada perã mãɨrãpa k'ĩsia k'achia iru p'anɨ, mãgaji: —¡Seewata parãpa Tachi Ak'õrede ijãapatada apata! ¿Sãap'eda mɨ k'ũra k'inia p'anɨma? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ak'ɨpidapáde aji, p'arat'a tau impuesto p'aapata. Aramãgá denario aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mãpai Jesupa iidiji: —¿K'ai k'ĩrata nade bɨ mãik'aapa k'ai t'ɨ̃ta p'ã bɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","P'anaujida: —César k'ĩra mãik'aapa ichi t'ɨ̃ta p'ã bɨda ajida. Mãpai Jesupa mãgaji: —Mãgara téetɨ Cesarmaa irua net'aa iidipari, mãik'aapa auk'a téetɨ Tachi Ak'õremaa irua iidipari. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mãga ũridak'ãri, ak'ɨtrua para beeji mãik'aapa erreujida. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ewate weda saduceorã ũk'uru Jesumaa chejida. Mãgɨɨrãpa ijãadak'aa tachi piup'eda chok'ai p'irabai. Maperã mãgajida: ");
INSERT INTO sjaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tachi Jarateepari, Moisepa jaraji eperã miak'ãi bɨ warra wẽe piuru pɨrã, chi ɨ̃pemapa iru wẽra ataipia bɨ mãik'aapa aɨ ome warra ooipia bɨ chi ɨ̃pema piuda k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tai t'ãide p'anapachida ɨ̃pemaarã siete. Chi naapema miak'ãiji. Mamĩda warra wẽe piuji. Mãgá chi wẽra beeji chi araarepema ɨ̃pema ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mamĩda mãgɨ́ ichiaba warra wẽe piuji. Chi araarepema mãik'aapa araarepema miak'ãijida ma p'ẽtrãa ome. Mamĩda auk'a warra wẽe piujida. Ma t'ẽepai chi apemaarã jida miak'ãijida ma p'ẽtrãa ome. Mamĩda ãchi jõmaweda warra wẽe piujida. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Maap'eda, ma wẽra ichiaba piuji. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿K'ãata k'ĩsia bɨma? ajida. Eperãarã piudap'eda chok'ai p'irabaidak'ãri, ¿chisãgɨ́ ɨ̃pemata ma wẽra ɨmɨk'ĩra pait'eema ajida, ãchi jõmaweda iru ome miak'ãi p'anadap'edaa perã? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesupa p'anauji: —Parãpa pia k'awada-e p'anɨ Tachi Ak'õre Ũraa p'ãda mãik'aapa k'awada-e p'anɨ ne-inaa jõmaweda iru juapa oopari. Mapa parãpa pia k'ĩsiada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Eperãarã piudap'eda chok'ai p'irabaidak'ãri, ɨmɨk'ĩraarã wẽraarã ome waa miak'ãida-e pait'ee. Angeleerã ichi truade p'anɨɨrã́k'apɨ p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma awara parãpa k'achia k'ĩsia p'anapata jaradak'ãri piudap'edaarã chok'ai p'irabaidak'aa. ¿Parãpa leeda-e p'anɨk'ã Tachi Ak'õre Ũraa p'ãdade jara bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mɨ pɨ chonaarã Ak'õre Waibɨa; Abraham, Isaac, Jacob ijãadap'edaa Ak'õre Waibɨa.’ ¡Tachi Ak'õre piudap'edaarã Ak'õre Waibɨa-epɨ. Chok'ai p'anɨɨrã Ak'õre Waibɨa! ");
INSERT INTO sjaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mãga ũridak'ãri, eperãarã ak'ɨtrua para beeji, Jesupa mãgá k'ĩsia k'awaa jarateeda perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseorãpa k'awaa atadak'ãri Jesupa ma saduceorã k'ĩup'eepik'ooda, chip'ejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Maap'eda Jesús k'ũra k'iniapa Moisepa p'ãda jarateeparipa iidiji: ");
INSERT INTO sjaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tachi Jarateepari, ¿chisãgɨ́ ũraata waibɨara bɨma aji, apema Ak'õre Ũraa p'ãdadepema k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesupa p'anauji: —‘Tachi Ak'õre Waibɨa k'inia iru baparíiji pɨchi t'ãripa mãik'aapa ne-inaa jõmaa k'ãyaara iru k'inia iru baparíiji. Ewari chaa k'ĩsíaji irude pɨchi t'ãripa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mãgɨta chi ũraa naapɨara; awaraa ũraa k'ãyaara pipɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Araarepema mãgɨk'a bɨ: ‘Awaraarã k'inia iru baparíiji pɨchi k'ap'ɨa k'inia iru baparik'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma ũraa omeeweda waibɨara p'anɨ, madeepa uchiadap'edaa perã awaraa ũraa jõmaweda Moisepa p'ãda mãik'aapa Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseorã at'ãri see nɨ̃bɨde, ");
INSERT INTO sjaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesupa iidiji: —¿K'ãata k'ĩsia p'anɨma aji, parãpa? ¿K'aideepa uchiayama aji, Tachi Ak'õrepa pëiit'ee bɨ, Mesías apata? P'anaujida: —Rey Daviddeepa uchiait'eeda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mãpai Jesupa mãgaji: —Mãgara, ¿sãap'eda Rey Davidpa irumaa: “Tachi Waibɨa” aji, Tachi Ak'õre Jaurepa nãga jarapik'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tachi Ak'õrepa jaraji Tachi Waibɨamaa: “Pɨ mɨ ome auk'a waibɨa bairã, su-ak'ɨ beepáde aji, mɨ juaraare, mɨa pɨ k'ĩra unuamaa iru p'anapataarã p'oyaaru misa.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidpa ichi ëreerãdeepa uchiait'ee bɨmaa t'ɨ̃jaraji “Tachi Waibɨa”. ¿Mapa k'awada-ek'ã aji, Mesías waibɨara bɨ chonaarãwedapema Rey David k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma fariseorãpa maarepida p'oyaa p'anauda-e paji. Maadamãiipa waawee p'aneejida waa iididait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ma t'ẽepai Jesupa mãgaji eperãarãmaa mãik'aapa chi k'õp'ãyoorãmaa: ");
INSERT INTO sjaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisepa p'ãda jarateepataarãpa fariseorã ome jarateepata k'ãata jara k'inia bɨ Moisepa p'ãda. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Maperã ũrítɨ ãchia jarateepata mãik'aapa óotɨ ãchia jara p'anɨk'a. Mamĩda p'ananáatɨ ãchi p'anapatak'a, ne-inaa jaradap'eda, ne-inaa awaraata oopata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eperãarãmaa ne-inaa audú chok'ara oopipata. Mamĩda chupɨria k'awaadak'aa ãrapa p'oyaa ooda-e pak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ãchia ne-inaa jõma oopata awaraarãpa ãchi t'o p'anadamerã. Porode mãik'aapa juade p'ãrajɨ̃pata ne-e jobɨadee ooda Tachi Ak'õre Ũraa p'ãda ome. Ma awara p'aru teesoo sidibai i jiichoo jɨ̃pata awaraarãpa pia unudamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nek'onadak'ãri awaraarã ome, su-ak'ɨ p'aneepata jõmaarã taide, poro waibɨarã su-ak'ɨ p'aneepatamãi. Ichiaba Tachi Ak'õre Ũraa jarateepata tede p'anadak'ãri, su-ak'ɨ beepari pipɨara bɨde su-ak'ɨ p'aneepata. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma awara calle jãde nipadak'ãri, k'inia p'anapata jõmaarãpa ãchimaa saludaadamerã mãik'aapa “Tachi Jarateepari” adamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Parãpa jõdee mãga oodaik'araa bɨ, parã auk'a p'anadairã ɨ̃pemaarãk'a mãik'aapa Jarateepari Waibɨa apai iru p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ichiaba na p'ek'au eujãdepema apidaamaa “Tachi Ak'õre” adaik'araa bɨ, parãpa Ak'õre apai iru p'anadairã Ak'õre truade. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ichiaba jɨrɨdaik'araa bɨ awaraarãpa parã “tachi waibɨarã” adamerã mɨ, Cristo aupaita, parã Poro Waibɨa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Parãdepema waibɨara bɨta apemaarã jua ek'ari baipia bɨ ãchi mimiaparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi waibɨara pa k'inia bɨ ek'ariara beeit'ee. Jõdee chi ek'ariara bɨ mĩda t'ãri o-ĩa bapari pɨrã, waibɨara pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Parã k'aurepa eperãarã p'anadak'aa Tachi Ak'õre jua ek'ari. Parã jida ichideerã p'aneeda-e pait'ee, eperãarãmaa ijãapi k'iniada-e p'anadairã irua pëidade. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Parãpa p'ẽtrãarã te jãri atapata mãik'aapa taarã ɨt'aa t'ɨ̃pata eperãarãpa parã pia ak'ɨdamerã. ¡Maperãpɨ Tachi Ak'õrepa parã k'achiara ooit'ee awaraarã k'achia ooi k'ãyaara! ");
INSERT INTO sjaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! T'ɨmɨ́ wãpata parãpa ijãapata jarateede, mãgá eperãarã pãchi eere t'ĩudamerã. Mãpai aba pãchi eere pa atadak'ãri, parãpa jaratee jõnɨpa mãgɨ́ papipata pãchi k'ãyaara audupɨara atuamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Aai, Tachi Ak'õrepa parã k'achiadee pëiit'ee! ¡Parã tau p'ãriu beerã́k'apɨ p'anɨ, pariatua o ak'ɨpimaa p'anadairã awaraarãmaa! Parãpa jarapata pipɨara bɨ eperãarãpa juraadamerã Tachi Ak'õre tede nɨ̃bɨ nẽe k'ĩrapite, ichi te waibɨa k'ĩrapite juraadai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡K'ĩra k'awa-ee pɨk'a p'anɨ mãik'aapa tau p'ãriu pɨk'a p'anɨ! ¿Tachi Ak'õre te waibɨa piara bɨ-ek'ã nẽe iru tede awara bɨda k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Parãpa ichiaba jarapata pipɨara bɨ juraadamerã ne-inaa altar ɨ̃rɨ bɨdap'edaa paadait'ee k'ĩrapite, Tachi Ak'õre tedepema altar k'ĩrapite juraadai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tau p'ãriu pɨk'a p'anɨɨrã! ¿Altar awara bɨda Tachi Ak'õre-it'ee piara bɨ-ek'ã ne-inaa ma altar ɨ̃rɨ bɨda k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eperãpa ne-inaa ooit'eeda ak'ãri Tachi Ak'õre altar k'ĩrapite, ma altar k'ĩrapitepai juraa-e bɨ. Auk'a juraa bɨ ne-inaa ma altar ɨ̃rɨ bɨ k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma awara eperãpa ne-inaa ooit'eeda ak'ãri Tachi Ak'õre te waibɨa k'ĩrapite, ma te k'ĩrapitepai juraa-e bɨ. Auk'a juraa bɨ Tachi Ak'õre k'ĩrapite, iru ma tede bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ichiaba eperãpa ne-inaa ooit'eeda aru pɨrã ne-inaa ɨt'ari nɨ̃bɨ k'ĩrapite, ma pedee auk'a jara bɨ Tachi Ak'õre su-ak'ɨ beepari k'ĩrapite mãik'aapa Tachi Ak'õre k'ĩrapite, iru ma su-ak'ɨ beeparide su-ak'ɨ bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Tachi Ak'õre-it'ee awara bɨpata nãgee aliño: menta, anís, comino; mãgɨ́ diezdepema chaa, aba. Mamĩda oodak'aa nãgɨ́ Tachi Ak'õre Ũraa p'ãdadepema ũraa waibɨara jara bɨk'a: “Awaraarã k'ũradaik'araa bɨ; awaraarã chupɨria k'awaadaipia bɨ; oodaipia bɨ parãpa oodait'eeda apatak'a.” Mãgɨ́ ũraa jara bɨ́k'ata oodaipia bɨ, auk'a ne-aliño ome oopatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Parã tau p'ãriu beerã́k'apɨ p'anɨ; pariatua o ak'ɨpimaa p'anadairã awaraarãmaa! ¡Pania nẽesipata ne-animal chak'eerã t'ĩunaadamerã pania toparide! Mamĩda parãpa k'awada-ee, camello k'ap'ɨa jõma mit'aak'ajík'apɨ p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Parãpa vaso mãik'aapa p'arat'u taawaik'a eere pi-ia sɨɨpata. Mamĩda mãgɨ́ edajãde ipuru bɨ ne-inaa k'achiapa, parã t'ãri k'achia p'anadairã. Chĩara net'aa chɨapata mãik'aapa chĩara k'ũrapata. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo, pɨ tau p'ãriu pɨk'a bɨ! Naapɨara chi vaso edajãde sɨ́ɨji. ¡Mãgá chi taawaik'a eere ichiaba sɨɨ beeipɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Parã nãga pɨk'a p'anɨ. Jãɨradepema mãu te t'o-t'oo p'urupata taawaik'a eere, pi-ia unudamerã. Mamĩda ma mãu te edajãde paraa piudap'edaarã k'ap'ɨa mik'ia bɨɨrɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mãga pɨk'a parãpa ne-inaa k'ĩra t'ãdoo oopata taawaik'a eere pi-ia unudamerã. Mamĩda parã edajãde k'ũrayaa, t'ãri k'achia-idaa p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã fariseorã ome k'achiadee pëiit'ee! ¡Seewata Tachi Ak'õrede ijãapatada apata! Parãpa te chak'e pi-ia mãudee oopipata chonaarãwedapema Ak'õre pedee jarapataarã ɨadap'edaa ɨ̃rɨ. Ma awara chonaarãwedapema t'ãri pia p'anadap'edaarã ɨadap'edaamãi parãpa pi-ia nep'ono p'ɨrrabai uuk'oopata. Ma jõma oopatada apata ma chonaarã k'irãpadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Maap'eda mãgapata: “Tai p'anadap'edaa paara tai chonaarãpa Ak'õre pedee jarapataarã peedak'ãri, táipata k'aripada-e pak'ajida” apata. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mãga jaradak'ãri, ak'ɨpipata parãpa k'awa p'anɨ pãchi chonaarãpa Ak'õre pedee jarapataarã peedap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Parã mãgá uchiadap'edaa perã Tachi Ak'õre pedee jarapataarã peedap'edaarãdeepa, ¿parãpa auk'a oodai-ek'ã ɨ̃rapema Ak'õre pedee jarapari ome? ");
INSERT INTO sjaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Parã k'achia-idaa beerãdeepa uchiadap'edaarã! ¡Taamák'apɨ p'anɨ! ¿Sãga uchiadai Tachi Ak'õre juadeepa? ¡Irua parã atuapiit'eepɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Maperã mɨa pëiit'ee Ak'õre pedee jarapataarã, k'ĩsia k'awaa beerã, mɨ ũraa jarateepataarã ome. Mamĩda parãpa mãɨrã ũk'uru jĩp'a peedait'ee kurusode baijira bɨdak'ãri piurutamaa. Ichiaba ũk'uru p'ua oodait'ee Tachi Ak'õre Ũraa jarateepata tede mãik'aapa ũk'uru p'uuru bee chaa jɨrɨ nipapataadait'ee miapi k'inia p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Parãpa mãga oodait'ee perã, Tachi Ak'õrepa parã k'achia ooit'ee jõmaweda irude wãara ijãapataarã peedap'edaa k'aurepa, Abeldeepa Berequías warra Zacarías parumaa. Pãchi auk'aarãpa iru peejida Tachi Ak'õre tede, te t'ĩupata, altarmãi esajĩak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mɨa wãarata jararu. Ma peedap'edaa k'aurepa Tachi Ak'õrepa ɨ̃rapemaarã k'achia ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—¡Jerusalén, Jerusalén, pɨdepemaarãpa Tachi Ak'õre pedee jarapataarã peepata mãik'aapa irua pëida eperãarã mãupa bat'a peepata! At'apai mɨa pɨdepemaarã araa p'e k'inia bapachi, et'erre wẽrapa chi chak'eerã p'e ataparik'a ichi isia ek'ari. ¡Mamĩda parãpa k'iniada-e paji! ");
INSERT INTO sjaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Ũrítɨ! ¡Pãchi te ituaba beeit'ee, Tachi Ak'õrepa parã waa ak'ɨ-e pait'ee perã! ");
INSERT INTO sjaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mɨa jara bɨ: Parãpa mɨ waa unuda-e pait'ee nãga jararutamaa: ‘¡Tachi Ak'õrepa ichia pëida ichita pia ak'ɨ bapariit'ee!’ ");
INSERT INTO sjaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús uchiak'ãri Tachi Ak'õre te waibɨadeepa, chi k'õp'ãyoorãpa jara chejida Ak'õre te waibɨa pi-ia oo k'obɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mãpai Jesupa mãgaji: —¿Parãpa na te jõma pia unu p'anɨ-ek'ã? aji. Mɨa wãarata jararu. Ewari cherude nama mãu apida bee-e pait'ee awaraa mãu ɨ̃rɨ. Na jõmaweda t'eek'oo chedait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Maap'eda wãjida Olivo Eedee. Jesús ituaba su-ak'ɨ beek'ãri, chi k'õp'ãyoorãpa iidi chejida: —Jaráji sãapai Ak'õre te waibɨa t'eet'aa chedait'ee. ¿Sãga nɨ̃beeyama ajida, pɨ chei naaweda mãik'aapa Tachi Ak'õre ewari waibɨa ewate pai naaweda? ");
INSERT INTO sjaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesupa p'anauji: —Tauk'a nipapatáatɨ apidaamaa k'ũrapiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mɨ jĩak'a chok'ara chedait'ee. Seewata jaradait'ee: “Mɨ Cristopɨ, Tachi Ak'õrepa pëida.” Mãga jara p'anɨpa eperãarã chok'ara k'ũradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mɨ chei naaweda parãpa ũridait'ee nama mãik'aapa awara ãi jura chõo jõnɨ. Mamĩda p'eranáatɨ. Ichita mãga p'asait'ee. Mamĩda at'ãri na p'ek'au eujã jõ-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aɨ naaweda eperãarã awaraarã ome chõodait'ee. Jarra oodait'ee mãik'aapa awẽrachai wãyaapariit'ee, eujã awara-awaraade. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mamĩda mãga p'asak'ãri, ewaapɨ na p'ek'au eujãdepemaarã miamaa p'aneedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Maapai parã jita atadak'ãri, p'ua oodait'ee mãik'aapa peedait'ee. Jõmaarãpa parã k'ĩra unuamaa iru p'anapataadait'ee mɨde ijãapata k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mãga oo p'anadak'ãri, eperãarã chok'ara mɨde ijãa amaadait'ee mãik'aapa chik'ĩra unuamaa jõnadait'ee, ãchi k'õp'ãyoorã traicionaarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Seewa-idaa beerã chok'ara uchiadait'ee Ak'õre pedee jarapataarã jĩak'a. Mãɨrãpa eperãarã chok'ara k'ũradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mãgá na p'ek'au eujãdepemaarãpa audú ne-inaa k'achia oodait'ee perã, eperãarã chok'araarãpa awaraarã waa k'inia iru p'anada-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mamĩda Tachi Ak'õrepa k'aripait'ee atuanaadamerã k'ĩra jĩp'a nipapataarã Ak'õre ode jai-idaarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mɨa pëiit'ee eperãarãpa mãga jaradait'ee na p'ek'au eujã jõmaade, p'uuru pidaarã jõmaarãpa k'awaadamerã. Mãpaipɨ na p'ek'au eujã jõit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Tachi Ak'õre pedee jarapari Danielpa p'ãdade jara bɨ abaapa ne-inaa audú k'achia ooit'ee Tachi Ak'õre te waibɨa edajãde. Chi nãgɨ́ leerupa pia k'ĩsíaji k'awaait'ee k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mapa Judea eujãde p'anɨɨrãpa mãga unudak'ãri, p'ira mirudaipia bɨ eera jẽra bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ichiaba eperã terrazade bɨ pɨrã, teedaa t'ĩuk'araa bɨ ichi net'aa p'e atade. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma awara eperã ichi ne-uu k'ãide ni pɨrã, teedaa cheik'araa bɨ p'aru p'ede pida. Aramata wãipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Aai, maapai chupɨria jõneedait'ee wẽraarã biak'oo bee maa-e pɨrã warra chak'eerã jude iru bee! ");
INSERT INTO sjaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chupɨria iidítɨ Tachi Ak'õremaa ma ewari p'asapinaamerã k'oijara nɨ̃bɨde maa-e pɨrã ɨ̃ipata ewate. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maapai eperãarã audupɨara chupɨria mia jõnadait'ee, na p'ek'au eujã ooru weda chupɨria para bada k'ãyaara mãik'aapa ma t'ẽepai waa mãgá chupɨriara p'anada-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tachi Ak'õrepa ma ewari isapai wãyaapi-e pɨrã, apida chok'ai p'aneeda-e pai. Mamĩda isapai wãyaapiit'ee ichia jɨrɨt'eradaarã k'aurepa, ãra chupɨria k'awaa bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Maapai apidaapa parãmaa jararuta pɨrã: “¡Pɨchá, ak'ɨ́tɨ! ¡Nama bɨ Cristo, Tachi Ak'õrepa pëida!” maa-e pɨrã jararuta pɨrã: “¡Ara bɨta Cristo!” ijãanáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mɨ jĩak'aarã mãik'aapa Tachi Ak'õre pedee jarapataarã jĩak'aarã chok'ara chedait'ee. Mamĩda mãɨrãpa jara p'anɨ ijãanáatɨ, seewa-idaa bee perã. Ne-inaa k'ĩra t'ãdoo eperãarãpa p'oyaa oodak'aa ãchi juadoopa oo p'anɨpa eperãarã k'ũradait'ee, perá Tachi Ak'õrepa jɨrɨt'eradaarã k'ũrarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mɨa parãmaa ũraapari k'awaadamerã mãga p'asai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mapa parãmaa jararuta pɨrã: “¡Ak'ɨ́tɨ! Achú bɨ Tachi K'aripapari, eujã pania wẽe bɨde,” mamaa wãnáatɨ mɨ jɨrɨde. Maa-e pɨrã jararuta pɨrã: “¡Ak'ɨ́tɨ! Ichi nama miru bɨ,” ijãanáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Atu p'anɨde pa tau jẽra t'ĩuparik'a ak'õrejĩru uchiapari eereepa baaiparimaa, mãga pɨk'a eperãarã atu p'anɨde mɨ, chi Eperã Ak'õre Truadepema waya cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Piuda k'ap'ɨa bɨmãi ãkoso seedaipatada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Ma chupɨria jõnadap'edaa t'ẽepai, nãga pait'ee: ‘Tachi Ak'õrepa pajã wërepiit'ee. Ak'õrejĩru p'ãriudariit'ee; atane waa ɨ̃daa-e pait'ee mãik'aapa lucero baaik'oodaridait'ee pajãdeepa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mãpai pajãde eperãarãpa ne-inaa unudait'ee. Ma k'aurepa k'awaadait'ee mɨ, chi Eperã Ak'õre Truadepema, cheru. Mãpai na p'ek'au eujãdepemaarã jẽe para beeit'ee ãchobeepa. Unudait'ee mɨ, chi Eperã Ak'õre Truadepema, jõmaarã k'ãyaara waibɨara bɨ k'ĩra wãree cheru jɨ̃ararade. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mãpai mɨa trompeta golpe chaapiit'ee angeleerãmaa, p'e chedamerã eperãarã mɨa jɨrɨt'era iru bɨɨrã na p'ek'au eujã jõmaade, t'ɨmɨ́ bee pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—K'ĩsíatɨ higuera bɨɨrɨde. Higuera k'iru t'u-k'ua uchia nɨ̃beek'ãri mãik'aapa ewaa t'ono nɨ̃beek'ãri, k'awaapata eujã wãsia wã. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mãga pɨk'a mɨa et'ewa jaradak'a unudak'ãri, k'awa p'anɨ taarã-e mɨ, chi Eperã Ak'õre Truadepema cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mɨa wãarata jararu. Ɨ̃rapemaarã piudai naaweda, ma ne-inaa jõmaweda p'asait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ewari cherude pajã na p'ek'au eujã ome jõdait'ee. Mamĩda ichita p'asait'ee mɨa pedee jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Eperã apidaapa k'awada-e p'anɨ Eperã Ak'õre Truadepema cheit'ee ewate; chi hora jida. Ɨt'aripema angeleerãpa pida k'awada-e p'anɨ; mɨa pida ichiaba. Mɨ Ak'õrepapai k'awa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé bada ewaride p'asadak'a mãga pɨk'a p'asait'ee mɨ, chi Eperã Ak'õre Truadepema waya chek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maapai na p'ek'au eujã ũui naaweda, eperãarã nek'opachida, ne-inaa topachida mãik'aapa miak'ãipachida Noé ichi barcode bataurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mamĩda atu p'anɨde k'oi chedachi, eujã ũudachi mãik'aapa jõmaweda k'iniidachida. Mãga pɨk'a p'asait'ee ichiaba mɨ, chi Eperã Ak'õre Truadepema waya chek'ãri. Atu p'anɨde cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma ewate eperãarã omé mimiamaa p'anadait'ee ãchi eujãde. Angeleerãpa aba ɨt'aa ateedait'ee; chi apema atabëidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ichiaba wẽraarã omé trigo bamaa p'anadait'ee k'ũrumade. Aba ɨt'aa ateedait'ee; chi apema atabëidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Maperã tauk'a p'anapatáatɨ k'awada-e p'anadairã sãapaita cheit'ee Pãchi Waibɨa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nãgɨ́ pedee pia k'awáatɨ. Te chiparipa k'awa bada paara nechɨapari cheit'ee hora p'ãrik'ua ichi net'aa chɨa atait'ee, chok'ai bak'aji ma nechɨapari ichi tede t'ĩupiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mãgá parã jida chok'ai pɨk'a p'anadaipia bɨ, atu p'anɨde mɨ, chi Eperã Ak'õre Truadepema, cheit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—¿Sãgá baparima aji, mimiapataarã poro waibɨa pia? Mãgɨpa k'ĩsia k'awaa oopari chiparipa oopi bɨk'a. Pia ak'ɨpari chipari net'aa atabëida ichi juade mãik'aapa chiparimaa nek'opip'eda, mimiapataarãmaa chik'o tawapari. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","O-ĩa bapari chipari pachek'ãri, ichi mimiamaa unu chepari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mɨa wãarata jararu. Chiparipa mãga unu chek'ãri, jõma ichia net'aa iru bɨ bɨit'ee ma mimiapari jua ek'ari ak'ɨ bamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mamĩda ma mimiapari t'ãri k'achia bɨ pɨrã, nãga k'ĩsiai: “Taarãit'ee mɨ chipari.” ");
INSERT INTO sjaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mapa apemaarã mimiapataarã wɨmaa beei mãik'aapa tomaa beei, nek'omaa beei toyaa beerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mamĩda ma mimiapari k'achia atu bɨde chi te chipari pacheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mãpai irua ooda k'awaa atak'ãri, iru miapiit'ee mãik'aapa ãyaa pëit'aait'ee mimiapataarã seewata mimiapatada apataarã ome bade. Mama jẽe nɨ̃bait'ee mãik'aapa k'ida kierrkierree nɨ̃bait'ee p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Diez wẽraarã ɨmɨk'ĩra ome waide k'ãida-ee beerã wãjida miak'ãipata fiestadee. Ãchi lámpara atadap'eda, nɨjida k'ĩrachuudait'ee chi ɨmɨk'ĩra miak'ãiit'ee bɨ ome, iru k'õp'ãyaadait'ee pada perã fiesta oo p'anɨmãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma wẽraarã diezdepema joisomaa pia k'ĩsiada-e paji, ne-inaa oodai naaweda. Jõdee chi apema joisomaa pia k'ĩsiapachida, ne-inaa oodai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chi pia k'ĩsiada-e p'anadap'edaarãpa ãchi lámpara atadak'ãri, k'ĩsiada-e paji aceite waapɨara ateedait'ee ãchi ome. Mapa ãchi lamparade bada aupai anipajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jõdee chi pia k'ĩsia p'anadap'edaarãpa ãchi lamparade bɨ awara ateejida aceite botella aba-abaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mamĩda chi miak'ãiit'ee bɨ taarã nɨ̃bada perã cheit'ee, ma wẽraarã jõmaweda k'ãidachida ãchia nɨ p'anadap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Esapɨte pa wãk'ãri, ũrijida bia cheruta: “¡Miak'ãiit'ee bɨ pacheruda! ajida. ¡Uchiadapáde ajida, iru k'ĩrachuude!” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ma wẽraarã k'ãi jõnadap'edaa aramata p'irabaik'oodachida mãik'aapa ãchi lamparadepema mecha t'ɨɨk'oojida pia unudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mãpai chi pia k'ĩsiada-ee p'anadap'edaarãpa mãgajida apemaarãmaa: “Taimaa aceite ma-ãri teedapáde ajida, tai lámpara k'ĩik'oodaruta perã.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mamĩda apemaarãpa p'anaujida: “Taipa teeda-eda ajida, jõmaarã-it'ee araa-e perã. Wãdapáde ajida, aceite netopatamaa pãchi-it'ee netode.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mamĩda ma wẽraarãpa aceite netonaruta misa, pacheji chi ɨmɨk'ĩra miak'ãiit'ee bada. Mãgá ma awẽraarã pia k'ĩsiadap'edaarã auk'a t'ĩujida iru ome fiesta oodait'eemãi. T'ĩudak'ãri, irua ma te t'ĩupata jɨ̃a nɨ̃bɨji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Taarã-e nɨde pachejida chi aceite netonadap'edaarã. Te taawaik'a eereepa mãgajida: “¡Tachi Waibɨa, Tachi Waibɨa, ewapáde ajida, tai t'ĩudait'ee!” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mamĩda irua p'anauji: “Mɨa wãarata jararu. Parã k'awa-e bɨda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mãga nepɨrɨp'eda, Jesupa mãgaji chi k'õp'ãyoorãmaa: —Mãga pait'ee perã, tauk'a p'anapatáatɨ parãpa k'awada-e p'anadairã sãapai mɨ cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Ichiaba nãga pɨk'a pait'ee Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã. Eperã awara ãyaa wãi naaweda, ichi mimiapataarã t'ɨ̃ p'eji mãik'aapa p'arat'a teeji ãchi chaachaa ak'ɨ p'anadamerã, ichi cheru misa. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mimiapari abaamaa teeji p'arat'a tau cinco mil; awaraamaa teeji p'arat'a tau dos mil; apemamaa p'arat'a tau mil. Mãgá p'arat'a tau awara-awaraa teeji, k'awa bada perã ãchi auk'a mimiadak'aa. Maap'eda ãyaa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma t'ẽepai ma mimiapari cinco mil jitadapa ne-inaa netomaa beeji ma p'arat'apa. Mãgá ne-inaa neto bɨpa awaraa cinco mil eepa ataji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mãgá ichiaba ma p'arat'a tau dos mil jitadapa awaraa dos mil eepa ataji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mamĩda ma p'arat'a tau mil jitadapa chi poro waibɨa p'arat'a eujãde jau nɨ̃bɨnaji, atuadarii jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Taarãpai pacheji chi p'arat'a chipari. Juasia k'inia baji ma p'arat'a atabëida chi mimiapataarã ome. Mapa ãchi t'ɨ̃ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naapɨara pacheji chi mimiapari p'arat'a tau cinco mil jitada. Mãgɨpa chi p'arat'a chiparimaa mãgaji: “Señor, pɨa mɨmaa teejida aji, p'arat'a tau cinco mil. Nama bɨda aji, waa awaraa cinco mil uchiada ne-inaa neto bɨpa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chi p'arat'a chiparipa mãgaji: “¡Pɨ pia bɨda aji, pia mimiapari perã! Mɨa atabëida pia ak'ɨji mãik'aapa aɨ ɨ̃rɨ waapɨara uchiapiji. Mãga ooda perã ɨ̃rá pɨ jua ek'ari bɨit'eeda aji, ne-inaa audupɨara ak'ɨmerã. Teedaa t'ĩupáde aji, o-ĩa bapariimerã mɨ ome.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mãgɨ́ t'ẽe pacheji chi mimiapari p'arat'a tau dos mil jitada. Ichia mãgaji: “Señor, pɨa mɨmaa teejida aji, p'arat'a tau dos mil. Nama bɨda aji, waa awaraa dos mil, uchiada ne-inaa neto bɨpa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chi p'arat'a chiparipa mãgaji: “¡Pɨ pia bɨda aji, pia mimiapari perã! Mɨa atabëida pia ak'ɨji mãik'aapa aɨ ɨ̃rɨ waapɨara uchiapiji. Mãga ooda perã ɨ̃rá pɨ jua ek'ari bɨit'eeda aji, ne-inaa audupɨara ak'ɨmerã. Teedaa t'ĩupáde aji, o-ĩa bapariimerã mɨ ome.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Mamĩda chi mimiapari p'arat'a tau mil jitada pachek'ãri, mãgaji chiparimaa: “Señor, mɨa k'awa bɨda aji, pɨa eperãarã pia chupɨria k'awak'aa. K'awa bɨ pɨchia ne-inaa jõma p'e atapari awaraarã mimiadap'edaa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mɨa waawee baji pɨchi p'arat'a atuadarii jĩak'aapa. Mapa ma p'arat'a jau iru baji eujãde. Nama bɨda aji, pɨchi p'arat'a.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mãpai chi p'arat'a chiparipa mãgaji: “¡Pɨ k'achia bɨda aji, pia mimiak'aa perã mãik'aapa k'oo-idaa bapari perã! Wãara k'awa baji pɨrã mɨa mɨchi-it'ee ne-inaa jõma p'e atapari awaraarã mimiadap'edaa pari, ");
INSERT INTO sjaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mãgara ¿sãap'eda mɨ p'arat'a ɨana-e pajima aji, p'arat'a ɨapata tede, mãpemaarãpa aɨ ɨ̃rɨ p'aadamerã, mɨ p'arat'a taarã iru p'anadap'edaa pari?” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mãpai ma p'arat'a chiparipa mãgaji arii p'anadap'edaarãmaa: “Ma p'arat'a tau mil jãri atadapáde aji, mãik'aapa teedapáde aji, chi diez mil iru bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eperãpa iru bɨmaa waapɨara teeit'ee, audupɨara iru bamerã. Mamĩda chi mak'ɨara wẽe bɨpa ma-ãri iru bɨ paara jãri atait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mimiapari k'achia taawaa ateedapáde aji, p'ãriudee jẽenamerã mãik'aapa k'ida kierrkierree nɨ̃bamerã p'uapa.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Mɨ, chi Eperã Ak'õre Truadepema, chek'ãri mɨ angeleerã ome, su-ak'ɨ beeit'ee rey su-ak'ɨ beepari k'ĩra wãreede. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na p'ek'au eujãdepemaarã k'ĩra t'ãdoo cheepurudait'ee iru k'ĩrapite. Mãpai irua eperãarã awara-awaraa bɨit'ee, ne-animalaarã chiparipa ichi oveja, cabra awara-awaraa bɨparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ovejaarãk'a bee pëiit'ee ichi juaraare; jõdee cabrak'a bee chi juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Maap'eda Reypa mãgait'ee ichi juaraare p'anɨɨrãmaa: “¡Chétɨ, mɨ Ak'õrepa parã pia ak'ɨda perã! Wã́tɨ Tachi Ak'õre truadee, na p'ek'au eujã ewaa oodak'ãriipa irua parã jɨrɨt'erada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mɨ jarrapisia nɨ̃bak'ãri, parãpa mɨmaa nek'opijida mãik'aapa opisia nɨ̃bak'ãri, ne-inaa topijida. Ma awara mɨ chĩara eujãde nipak'ãri, mɨ auteebaijida pãchi tede. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","P'aru wẽe chidi pak'ãri, parãpa p'aru teejida. K'ayaa bak'ãri, parã wãjida mɨ ak'ɨde. Carcelde bak'ãri, ichiaba mɨ ak'ɨnajida.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mãpai ichi juaraare k'achia wẽe p'anɨɨrãpa iididait'ee: “Tachi Waibɨa, ¿sãaweda unujidama ajida, pɨ jarrapisia nɨ̃bɨ mãik'aapa nek'opijida? Maa-e pɨrã ¿sãaweda unujidama opisia nɨ̃bɨ mãik'aapa ne-inaa topijida? ");
INSERT INTO sjaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Sãaweda unujidama pɨ chĩara eujãde ni mãik'aapa auteebaijida tai tede maa-e pɨrã p'aru wẽe ni mãik'aapa p'aru teejida pɨmaa? ");
INSERT INTO sjaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Sãaweda pɨ ak'ɨnajidama ajida, k'ayaa bak'ãri maa-e pɨrã carcelde bak'ãri?” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mãpai Reypa p'anaut'ee: “Mɨa wãarata jararu. Parãpa mãgee ne-inaa oodap'edaa mɨ ɨ̃pemaarã, na chupɨria beerãmaa, auk'a mɨmaa oojida.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Maap'eda Reypa ichi juabi eere p'anɨɨrãmaa mãgait'ee: “¡Parã, chi k'achia-idaa beerã, ãyaa wã́tɨ mɨ ik'aawaapa! Wã́tɨ t'ɨpɨtau ichita jẽrajẽraa jira bɨdee, ooda Netuara Poro Waibɨa-it'ee; ichideerã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mɨ jarrapisia nɨ̃bak'ãri, parãpa mɨmaa nek'opida-e paji mãik'aapa opisia nɨ̃bak'ãri, ne-inaa topida-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma awara chĩara eujãde t'ɨmɨ́ nipak'ãri, mɨ auteebaida-e paji pãchi tede. P'aru wẽe nipak'ãri, parãpa p'aru teeda-e paji. Mɨ k'ayaa bak'ãri mãik'aapa carcelde bak'ãri, mɨ ak'ɨnada-e paji.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mãpai mãɨrãpa iididait'ee: “Tachi Waibɨa, ¿sãaweda pɨ unujidama ajida, jarrapisia nɨ̃bɨ maa-e pɨrã opisia nɨ̃bɨ; chĩara eujãde t'ɨmɨ́ ni maa-e pɨrã p'aru wẽe ni; k'ayaa bɨ maa-e pɨrã carcelde bɨ, taipa pɨ k'aripada-eeta?” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mãpai Reypa p'anaut'ee: “Mɨa wãarata jararu. Parãpa mãgee ne-inaa ooda-e p'anadap'edaa eperãarã chupɨria beerãmaa, auk'a mɨmaa ooda-e paji.” ");
INSERT INTO sjaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mãpai ma k'achia beerã pëiit'ee t'ɨpɨtau ichita jẽrajẽraa jira bɨdee. Jõdee chi pia beerã Tachi Ak'õre ome ichita p'anapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ma jõma jara aupak'ãri, Jesupa mãgaji chi k'õp'ãyoorãmaa: ");
INSERT INTO sjaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Parãpa k'awa p'anɨ k'ãima omeemaa Pascua fiesta pait'ee. Maapaita mɨ, chi Eperã Ak'õre Truadepema, jita atapidait'ee mãik'aapa kurusode baijira bɨpidait'ee piumerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesupa mãga jaradadeepa p'aareerã poroorã judiorã poro waibɨarã ome chip'ejida p'aareerã poro waibɨara bɨ, Caifás palaciode. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mama p'anɨde pedeeteejida Jesús mera jita atapidait'ee mãik'aapa peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mamĩda mãgajida: —Fiestade ooda-eda ajida, eperãarã k'ĩrau para beepiamaapa tachi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania p'uurude bak'ãri, Simón, chi leprapa k'ayaa bada apatap'edaa tede baji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mãga nɨde wẽra Jesús k'ait'a cheji chok'o chak'ek'a mãu pi-ia alabastrodee ooda ome. Ma chok'o chak'e ipuru baji k'era ɨ̃pɨapa. Jesús mesade su-ak'ɨ bɨde mãgɨ́ wẽrapa ma k'era weet'aaji iru poro ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chi k'õp'ãyoorãpa mãga unudak'ãri, k'ĩraudachida mãik'aapa pedee para beeji: —¿Sãap'eda jã k'era ichi k'inia weemaa bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿Ɨ̃pɨa netot'aak'aji-ek'ã ajida, mãik'aapa ma p'arat'a chupɨria beerãmaa teek'aji-ek'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesupa ma pedee ũrik'ãri, mãgaji: —Ita-aria bɨ́tɨ. Irua mɨmaa oo bɨ pia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chupɨria beerã ichita paraait'ee parã t'ãide. Mamĩda mɨ parã ome ichita ba-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na wẽrapa mɨ ɨ̃rɨ k'era weeji, mak'ɨara taarã-e mɨ peedap'eda, ɨadait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mɨa wãarata jararu. Na p'ek'au eujãde jarateepata chaa mɨa ooda eperãarã k'aripait'ee, ichiaba nepɨrɨpataadait'ee na wẽrapa ooda mɨ-it'ee. Mãgá iru ichita k'irãpadait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Maap'eda Jesús k'õp'ãyoorã docedepema aba, Judas Iscariote, wãji p'aareerã poroorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Iidiji: —Parãpa, ¿jõmasaa mɨmaa p'aadayama aji, Jesús jita teeru pari? —Teedayada ajida, p'arat'a tau treinta. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Maadak'ãriipa Judapa jɨrɨ bapachi sãga Jesús ãchimaa jitapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Naapema ewaride fiesta pan levadura wẽe k'opatade Jesús k'õp'ãyoorãpa irumaa iidi chejida: —¿Sãma k'inia bɨma ajida, k'odait'ee Pascua fiesta ewatepema chik'o? ");
INSERT INTO sjaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesupa p'anauji: —Wã́tɨ p'uurudee parãpa k'awa p'anɨ tede mãik'aapa jaranátɨ chi te chiparimaa: “Tachi Jarateeparipa jara pëiji: ‘Mɨ ewari k'ait'a bɨ. Wãit'ee pɨ temaa Pascua fiesta ewatepema chik'o k'ode mɨchi k'õp'ãyoorã ome.’ ” ");
INSERT INTO sjaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chi k'õp'ãyoorãpa oojida Jesupa jaradak'a mãik'aapa mama ne-inaa jõma oojida Pascua chik'o k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","P'ãriupodopa Jesús mesade nek'omaa baji chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nek'omaa p'anɨde Jesupa mãgaji: —Mɨa wãarata jararu. Parãdepema abaapa mɨ traicionaait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mãga ũridak'ãri, chi k'õp'ãyoorã k'ĩra pia-ee para beeji mãik'aapa aba-abaa iidijida: —Tachi Waibɨa, ¿mɨk'ã? apachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesupa p'anauji: —Mɨ ome auk'a p'arat'ude pan sã atarupata mɨ traicionaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɨ, chi Eperã Ak'õre Truadepema, ichita piut'ee Tachi Ak'õre Ũraa p'ãdade jara bɨk'a. Mamĩda ¡aai, Tachi Ak'õrepa k'achiadee pëit'ee chi mɨ traicionaait'ee bɨ! Piara bak'ajida aji, mãgɨ́ t'o-e pada paara. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mãpai Judas, chi traicionaait'ee badapa, iidiji: —Tachi Jarateepari, ¿mɨk'ã? aji. Jesupa mãgaji: —Pɨchia jara bɨk'ada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nek'omaa p'anɨde Jesupa pan ataji mãik'aapa ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa. Ma pan k'õrat'aaji mãik'aapa chi k'õp'ãyoorãmaa teeji. Mãpai mãgaji: —Jitátɨ mãik'aapa k'ótɨ. Nãgɨ́ pan mɨ k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nek'odap'edaa t'ẽepai ichiaba mãgá ooji ma vino ome. Ɨt'aa t'ɨ̃p'eda, gracias jaraji Tachi Ak'õremaa mãik'aapa chi k'õp'ãyoorãmaa teeji. Mãpai mãgaji: —Nãgɨ́ vino mɨ waa. Todapáde aji, pãchi jõmaarãpa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tachi Ak'õrepa nãgɨ́ ũraa chiwidi jara bɨ. Mɨ piuk'ãri, mɨchi waa bat'ait'ee k'aurepa irua wẽpapiit'ee eperãarã chok'araarãpa p'ek'au k'achia oopata mãik'aapa mɨchideerã papiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mamĩda mɨa jara bɨ: Parã ome vino waa to-e pait'eeda aji, ɨt'aripema vino torumaa mɨ Ak'õre truade. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tachi Ak'õre Ũraa p'ãdadepema k'ari k'aridap'eda, Olivo Eedee wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mama Jesupa mãgaji: —Idi p'ãrik'ua parã jõmaweda ijãadaamaa p'aneedait'ee mãik'aapa mɨ ituaba atabëidait'ee Tachi Ak'õre Ũraa p'ã jẽra bɨde jara bɨk'a: ‘Mɨa oveja ak'ɨpari peepiit'ee mãik'aapa chi ovejaarã jĩchoodaridait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mamĩda mɨ chok'ai p'irabaik'ãri, Galilea eujãdee wãit'ee parã naa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mãpai Pedropa mãgaji: —Apemaarãpa pɨ atabëiruta pɨjida, mɨa pɨ atabëi-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesupa p'anauji: —Mɨa wãarata jararu. Idi p'ãrik'ua et'erre k'arii naaweda, jarada õpee pɨa mɨ k'awa-e bɨda ait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Waapɨara Pedropa mãgaji: —Pɨ ome auk'a piuru pɨjida, mɨa jara-eda aji. Apemaarã k'õp'ãyoorãpa ichiaba auk'a jarapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Maap'eda Jesús wãji chi k'õp'ãyoorã ome Getsemaní ne-uu eujã apatap'edaamaa. Mama panadak'ãri, mãgaji: —Nama su-ak'ɨ p'anéetɨ mɨ ɨt'aa t'ɨ̃naru misa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ichi ome ateeji Pedro mãik'aapa Zebedeo warrarã omé. Mãga nɨde Jesús k'ĩsia paraa nɨ̃beeji t'ãri p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mapa mãgaji ãchimaa: —Mɨ piut'ee pɨk'a nɨ̃bɨ t'ãri p'uapa. Nama p'anéetɨ, k'ãida-ee. Chok'ai p'anadapáde aji, mɨ ome auk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mãpai Jesús waawipai wãp'eda, bedabaiji tau bɨɨrɨ eujãde t'õbairumaa mãik'aapa ɨt'aa iidiji: —Ak'õre, k'inia bɨ pɨrã, mɨ k'aripáji na miait'ee bɨdeepa. Mamĩda oonaapáde aji, mɨa k'inia bɨk'a. Jĩp'a pɨa k'inia bɨ́k'ata oopáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Maap'eda, ak'ɨ chek'ãri, chi k'õp'ãyoorã k'ãi jõnɨta unu cheji. Mãpai Pedromaa mãgaji: —¿Hora apida p'oyaa chok'ai p'anada-ek'ã aji, k'ãida-ee? ");
INSERT INTO sjaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chok'ai p'anátɨ mãik'aapa ɨt'aa t'ɨ̃́tɨ p'ek'au k'achiade baaipiamaapa. Tachi Ak'õrepa oopi k'inia bɨk'a t'ãripa oo k'inia p'anɨ. Mamĩda pãchi k'ap'ɨapa chooda-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Waya wãji nãga ɨt'aa iidide: —Ak'õre, mɨ na miait'ee bɨta uchia ata-e pɨrã, mãgara pia bɨda aji. Pɨa oo k'inia bɨ́k'ata oopáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Waya chek'ãri, naa unu chedak'a unu cheji; k'ãi jõnɨ tap'ok'eepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mãpai ichiak'au bɨji mãik'aapa wãda õpee ɨt'aa t'ɨ̃naji. Wãru chaa ichi aɨ pedeeta jarapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maap'eda waya chek'ãri chi k'õp'ãyoorã p'anadap'edaamaa, mãgaji: —¿At'ãri parã k'ãi jõnɨk'ã? aji. Mɨ peepidait'ee hora pajipɨ. Eperã Ak'õre Truadepema teedait'ee p'ek'au k'achia oopataarã juade. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Eperã mɨ traicionaait'ee bɨ k'ait'a cheru. ¡P'irabáitɨ mãik'aapa wãdáma apemaarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús at'ãri pedeemaa bɨde, ichi k'õp'ãyo Judas pacheji eperãarã chok'ara ome. Espada pak'uru ome anipajida. P'aareerã poroorãpa mãik'aapa judiorã poro waibɨarãpa ma eperãarã pëijida ãchi pari. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Panadai naaweda, Judapa mãɨrãmaa jaraji: —Chi mɨa k'ĩra ɨ̃ruta saludaak'ãri, mãgɨta jita atadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mapa pachedak'ãri Jesumãi, Judas pedee cheji: —Tachi Jarateepari, ¿k'ap'ɨa pia bɨk'ã? aji. Mãga jarap'eda, k'ĩra ɨ̃t'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesupa p'anauji: —K'õp'ãyo, oopáde aji, pɨa ne-inaa oode cheda. Mãpai Judas ome che p'anadap'edaarãpa Jesús jita atadap'eda, mamãik'aapa ateejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mãga nɨde Jesús ik'aawa badapa ichi espada ẽt'a atap'eda, p'aareerã poro waibɨa mimiapari k'ɨɨrɨ orp'et'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mãpai Jesupa mãgaji: —¡Pɨchi espada ata bɨ́ji ichi badamãi! Chi espadapa chõopataarã piupata espadapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿K'awa-e bɨk'ã aji, mɨ Ak'õremaa k'aripa iidiru pɨrã, irua angeleerã setenta y dos mil ɨ̃raweda pëik'aji? ");
INSERT INTO sjaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mamĩda mãga ooru pɨrã, uchia-e pai Tachi Ak'õre Ũraa p'ã jẽra bɨde nãga p'asait'ee jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mãpai Jesupa iidiji ichi jita ata chedap'edaarãmaa: —¿Sãap'eda parã chejidama aji, espada ome mãik'aapa pak'uru ome mɨ jita atade, eperã nechɨayaa bɨ jita atapatak'a? Ewari chaa mɨ Tachi Ak'õre te waibɨade bapari iru pedee jarateemaa. Mamĩda mɨ jitada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na jõma p'asaruda aji, Tachi Ak'õre pedee jarapataarãpa jaradap'edaak'a iru Ũraa p'ãdade. Jesupa mãga jaramaa bɨde jõmaweda chi k'õp'ãyoorãpa atabaibëijida mãik'aapa miruk'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús jita atadap'edaarãpa ateejida Caifás temaa. Caifás p'aareerã poro waibɨa paji. Mama Junta Supremadepemaarã see nɨ̃baji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro t'ɨmɨɨpapai t'ẽe wãk'ãtɨ wãji. Mãgá wãpa panaji Caifás temãi. Ma te t'ɨak'au badamãi edú t'ĩup'eda, Tachi Ak'õre te waibɨa jɨ̃apataarã ome su-ak'ɨ banaji ak'ɨit'ee sãga oodai Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","P'aareerã poroorãpa jõmaweda Junta Supremadepemaarã ome testigo jɨrɨ p'anapachida. Mãgá Jesús peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eperãarã chok'ara seewa jarade chejida mĩda, maarepida unuda-e paji ɨmɨateedait'ee. Mamĩda seewa-idaa beerã omé pachejida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mãɨrãpa mãgajida: —Na eperãpa jaraji: “Mɨa Tachi Ak'õre te waibɨa t'eet'aap'eda, k'ãima õpeemaa waya oo atai.” ");
INSERT INTO sjaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mãga ũrik'ãri, p'aareerã poro waibɨa bainɨ̃ beeji mãik'aapa iidiji Jesumaa: —¿Wãarak'ã aji, pɨ k'ĩrapite jara p'anɨ pedee? ¿Maarepida p'anau-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mamĩda Jesupa maarepida p'anau-e paji; k'ĩup'ee beeji. Mãpai p'aareerã poro waibɨapa mãgaji: —¡Tachi Ak'õre ichita chok'ai bɨ k'ĩrapite wãarata jaráji! ¿Pɨk'ã Tachi Ak'õrepa pëida eperãarã rey pamerã? ¿Pɨk'ã aji, Tachi Ak'õre Waibɨa Warra? ");
INSERT INTO sjaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesupa p'anauji: —Mɨda aji, pɨa jara bɨk'a. Mɨa jara bɨ: Parãpa Eperã Ak'õre Truadepema unudait'ee su-ak'ɨ bɨ Tachi Ak'õre Waibɨa juaraare mãik'aapa jɨ̃ararade cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mãpai Caifapa ichi p'aru jẽt'aaji t'ãri k'achiapa mãik'aapa mãgaji: —¡Na eperãpa pedee k'achia jaramaa bɨda aji, Tachi Ak'õre ãpɨte! ¿K'ãare-it'ee waa jɨrɨdayama aji, eperãarãpa ichia ooda jaradamerã? ¿Parãpa ũrijida-ek'ã ichia ma pedee k'achia jarada? ");
INSERT INTO sjaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿K'ãata k'ĩsia p'anɨma? aji. P'anaujida: —Piupia bɨda ajida, ichia jarada k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mãpai Jesús k'ĩramaa idujida mãik'aapa p'ua oo wãjida. Awaraarãpa k'ĩramaa sĩjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mãga oo jõnɨde mãgajida: —¡Pɨ wãara Tachi Ak'õre Warra pɨrã, jarapáde ajida, k'aipata pɨ sĩji! ");
INSERT INTO sjaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mãɨmisa Pedro taawa su-ak'ɨ baji te ãuk'idaa. Mãga nɨde awẽra mama mimiapari cheji mãik'aapa mãgaji Pedromaa: —Pɨ auk'a nipajida aji, jã eperã Jesús Galileadepema ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mamĩda Pedropa meraji jõmaarã taide: —Mɨa k'awa-e bɨda aji, k'ãaredeta pɨa jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Maap'eda Pedro wãji puerta edú t'ĩupatamãi. Mama awaraa awẽra mimiaparipa iru unuk'ãri, arii p'anadap'edaarãmaa mãgaji: —Pɨchá, na eperã nipajida aji, Jesús Nazaretdepema ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Waya Pedropa meraji: —Tachi Ak'õre k'ĩrapite mɨa juraaru: ¡Jã eperã k'awa-e bɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Taarã-e nɨde arii see nɨ̃badaarã Pedro k'ait'a chejida mãik'aapa mãgajida: —Wãara pɨ ãchi k'õp'ãyo. Pedeedeepa p'oyaa mera-eda aji, pɨ Galilea eujãdepema. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mãpai Pedropa juraaji Tachi Ak'õre k'ĩrapite: —¡Mɨa jã eperã k'awa-e bɨda! aji. ¡Seewa jaramaa bɨ pɨrã, Tachi Ak'õrepa mɨ miapiipia bɨda! aji. Aramata et'erre k'ariji. ");
INSERT INTO sjaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mãpai Pedropa k'irãpaji Jesupa jarada: “Et'erre k'arii naaweda, pɨa jarada õpee jarait'ee mɨ k'awa-e bɨ.” Mãpai Pedro taawaa uchiap'eda, jẽe nɨ̃beeji audú k'ĩsia p'ua bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tap'eda weda p'aareerã poroorã judiorã poro waibɨarã ome pedeeteejida Jesús peet'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jɨ̃dap'eda, ateejida Romadepemaarã poro waibɨa Poncio Pilatomaa. Mãgɨ́ Romadepema paji. Judea eujã ak'ɨpari paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesús traicionaadapa unuk'ãri Jesús peet'aadait'ee p'anɨ, t'ãri p'uadachi ichia traicionaada perã. Mapa ma p'arat'a tau treinta ichimaa p'aadap'edaa teenaji p'aareerã poroorãmaa mãik'aapa judiorã poro waibɨarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mãgaji: —Mɨa p'ek'au k'achia oojida aji, ma eperãpa k'achia ook'aata peepit'aada perã. Mãpai ãchia p'anaujida: —¡Tai-it'ee p'ua-e bɨda ajida, pɨata ooda perã! ");
INSERT INTO sjaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mãpai Judapa ma p'arat'a tau Ak'õre te waibɨade bat'ak'oop'eda, mamãik'aapa uchiaji. Maap'eda ichi juadoopa otau jɨ̃ atap'eda, ɨt'ɨ́ baijira beeji piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aɨ naaweda Judas Ak'õre te waibɨadeepa uchiak'ãri, p'aareerã poroorãpa ma p'arat'a tau p'e atajida mãik'aapa mãgajida: —Na p'arat'a tau bɨdaik'araa bɨ p'arat'a ɨa bɨpatade Tachi Ak'õre-it'ee, tachi ũraade jara bairã p'arat'a p'aada eperã peeda pari teenaadamerã Tachi Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Maperã ma p'arat'apa eujã neto atajida aɨde ɨadamerã ãchi eujãde k'ĩra tewaraarã piurutaarã. Aɨ naaweda ma eujã t'ɨ̃jarapachida Chok'o K'apataarã Eujã. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mamĩda mãgá netodap'eda eperã peeda pari p'arat'apa, eperãarãpa t'ɨ̃ bɨjida “Waa Eujã.” ");
INSERT INTO sjaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mãga paji Ak'õre pedee jarapari, Jeremiapa chonaarãweda jaradak'a: ‘P'arat'a tau treinta jitajida; Israel pidaarãpa bɨdap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma p'arat'apa neto atajida Chok'o K'apataarã apata eujã Tachi Ak'õrepa mɨmaa jaradak'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús Pilato k'ĩrapite ateedak'ãri, Pilatopa iidiji: —¿Pɨk'ã aji, Judiorã Rey? Jesupa p'anauji: —Mɨda aji, pɨa jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mãpai p'aareerã poroorãpa judiorã poro waibɨarã ome Jesús ɨmɨatee jõnapachida. Mamĩda irua maarepida p'anauk'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mapa Pilatopa iidiji: —¿Ũri-e bɨk'ã aji, pɨ k'ĩrapite jara p'anɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mamĩda Jesupa pedee apida p'anauk'aa paji. Mapa Pilatopa k'awa-e paji k'ãata ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ma fiestade Pilatopa preso aba k'ena pëipachi, eperãarãpa iidirutata. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Maapai eperã t'ɨ̃jarapatap'edaa Jesús Barrabás carcelde baji. Eperãarãpa ma eperã t'o p'anajida, irua ne-inaa k'achia ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jesús at'ãri Pilato k'ĩrapite bɨde, Pilatopa see nɨ̃badaarãmaa iidiji: —¿K'aita k'inia p'anɨma aji, mɨa k'ena pëimerã, Jesús Barrabás maa-e pɨrã Jesús, Mesías apata? ");
INSERT INTO sjaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatopa mãga iidiji ãchi k'ĩraupiit'ee, k'awa bada perã Jesús aneedap'edaarãpa iru k'ĩra unuamaa iru p'anadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato at'ãri su-ak'ɨ bɨde poro waibɨa su-ak'ɨ beeparimãi, chi wẽrapa jara pëiji: —K'ĩrak'aupai ne-inaa k'achia ooi jã eperã ome, irua k'achia ook'aa perã. P'ãrik'ua mɨ k'ãimok'araa k'achia nɨ̃bajida aji, iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mamĩda p'aareerã poroorãpa judiorã poro waibɨarã ome eperãarãmaa jarajida iididamerã Pilatopa Barrabata k'ena pëimerã; jõdee Jesús peepit'aamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mãpai waya Pilatopa iidiji: —¿Chisãgɨta k'inia p'anɨma aji, mɨa k'ena pëimerã? Eperãarãpa p'anaujida: —¡Barrabata k'ena pëipáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mãpai Pilatopa iidiji: —Mãgara mɨa ¿k'ãata ooyama aji, Jesús, Mesías apata ome? Jõmaarãpa p'anaujida: —¡Kurusode peepit'aapáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mãpai Pilatopa mãgaji: —¿K'ãare k'achiata oojima? aji. Mamĩda waya eperãarãpa biajida: —¡Kurusode peepit'aapáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatopa unuk'ãri eperãarã mãgá audupɨara biuk'a nɨ̃beeruta, k'awaji ãchi ome p'oyaa-e pai. Maperã pania atapiji mãik'aapa jõmaarã taide jua sɨɨji. Mãpai mãgaji: —Mɨa ne-inaa k'achia oo-e na eperã ome. ¡Pãchia oo k'iniata oodapáde! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mãpai jõma see nɨ̃badaarãpa p'anaujida: —¡Ichi tai k'aurepa piuru pɨrã, auk'a tai warrarã k'aurepa adaipia bɨda! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mãpai Pilatopa Barrabás k'ena pëiji. Maap'eda Jesús soopa wɨpiji ichi soldaorãmaa mãik'aapa pëiji kurusode baijira bɨdamerã piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilato soldaorãpa Jesús ateejida ichi palaciode. Mama soldaorã chok'araara seedachida Jesús ik'aawa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iru p'aru ẽrat'aadap'eda, p'aru teesoo, p'oree jɨ̃ bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mãpai poro jɨ̃ra pak'uru jua ne-ɨɨrɨ-idaa bɨdee ooda jɨ̃ bɨjida. Ichiaba pak'uru jitapijida reypa jita iru baparik'a. Maap'eda iru oo iru p'aneejida. Iru k'ĩrapite bedabaidap'eda, mãgapachida: —¡Ak'ɨ́tɨ Judiorã Rey! ");
INSERT INTO sjaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ichiaba irumaa idupachida mãik'aapa juade iru bada pak'urupa wɨpachida poromaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mãgá oo iru p'anadap'eda, ma p'aru p'oree ẽrat'aajida mãik'aapa ichi p'aru waya jɨ̃ bɨjida. Mãpai ateejida kurusode baijira bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","P'uurudeepa uchia wãdade unujida eperã, t'ɨ̃jarapatap'edaa Simón. Mãgɨ́ eperã Cirene p'uurudepema paji. Mãgɨmaa Jesús kuruso ateepijida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Panajida Gólgota apatap'edaamãi. (Gólgota jara k'inia bɨ “Tachi Poro Bɨɨrɨ.”) ");
INSERT INTO sjaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mama Jesumaa topijida vino hiel ome p'oiradap'edaa. Mamĩda Jesupa ma-ãri to chaap'eda, to-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldaorãpa Jesús jua mãik'aapa chi bɨɨrɨ kurusode merap'ejida mãik'aapa baijira bɨjida piumerã. Mãgɨɨrãpa suerte jemenejida k'awaadait'ee k'aipata iru p'aru atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maap'eda, su-ak'ɨ p'aneejida ak'ɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Soldaopa iru poro ɨt'aik'a eere kurusode letrero merap'eji jarait'ee k'ãare-it'ee kurusode baijira bɨjida piumerã. P'ã baji: Nãgɨ́ Jesús; Judiorã Rey. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ichiaba Jesús ik'aawa nechɨapataarã omé kurusode baijira bɨjida, aba ichi juaraare, chi apema juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chi arii wãyaa wã nipadap'edaarãpa irumaa ik'achia jarapachida. Ãchi poro p'ɨrap'ɨraa ");
INSERT INTO sjaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mãgapachida: —¿Pɨ-ek'ã ajida, Tachi Ak'õre te waibɨa t'eet'aap'eda ewari õpeemaa waya oo atayada ada? ¡Mãgara pɨchi itu jãmãik'aapa uchiadaríji! ¡Pɨ Tachi Ak'õre Warra pɨrã, kurusodeepa ɨrabaidaipáde! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ichiaba mãgá oo iru p'anapachida p'aareerã poroorãpa Moisepa p'ãda jarateepataarã ome, judiorã poro waibɨarãpa paara. Mãgapachida: ");
INSERT INTO sjaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Awaraarã k'aripajida ajida. Mamĩda ichi itu p'oyaa uchia-e nadeepa. Israel pidaarã Rey pɨrã, ¡ɨrabaidaríji! ¡Mãgara taipa ijãadaipɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¡Tachi Ak'õrede ijãa bɨda apari perã, mãgara Tachi Ak'õrepa iru k'aripaipia bɨ, wãara k'inia iru bɨ pɨrã! ¿Jaraji-ek'ã ajida, ichi Tachi Ak'õre Warra? ");
INSERT INTO sjaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iru ik'aawa baijira p'anadap'edaarãpa ichiaba irumaa ik'achia jarapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Imat'ɨpa ak'õrejĩru k'iat'ɨdachi. Na eujã jõma p'ãriudachi las tres parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma hora Jesupa golpe biaji: —‘Elí, Elí, ¿lemá sabactani?’ (Ma pedee jara k'inia bɨ: ‘Mɨ Ak'õre, Mɨ Ak'õre, ¿K'ãare-it'ee mɨ atabaibëijima?’) ");
INSERT INTO sjaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ũk'uru arii p'anadap'edaarãpa ũridak'ãri, mãgajida: —Elías, chonaarãwedapema Ak'õre pedee jarapari, t'ɨ̃maa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aramata eperã p'ira wãji mãik'aapa esponjak'a p'ẽesap'ẽesaa bɨ topa ataji vino achuchuade. Sia k'ɨ̃de jõi bɨp'eda, sãji mãik'aapa Jesús it'aimãi t'ɨ atanaji sõmerã, opisia bɨ jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mamĩda apemaarãpa mãgajida: —Ichiak'au bɨ́ji. Unu k'inia p'anɨda aji, Eliapa iru k'aripa chei wa mãga-e. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mãga nɨde Jesús waya golpe biaji mãik'aapa jai-idaaji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mãɨmisa Jerusalende Tachi Ak'õre te waibɨade chi edupɨara bɨ cuarto t'ĩupatamãi p'aru teesoo eebai jira bada esajĩak'a jẽdachi ɨt'ɨɨpa edaa. Eujã wëre nɨ̃beeji mãik'aapa mãu tapɨa t'oop'ek'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mãu te piudap'edaarã ɨa jẽra bada ewat'ɨk'oodachida mãik'aapa chonaarãwedapema Ak'õrede ijãapatap'edaarã chok'ara chok'ai p'irabaijida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ãchi ɨa jẽra badamãiipa uchiajida mãik'aapa Jesús chok'ai p'irabaip'eda, wãjida Tachi Ak'õrepa jɨrɨt'erada p'uuru Jerusalendee. Mama eperãarã chok'araarãpa mãɨrã unujida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús ik'aawa bada soldaorã poro ichi jua ek'ari p'anadap'edaarã ome unudak'ãri eujã wëre nɨ̃bɨ mãik'aapa awaraa ne-inaa p'asa nɨ̃bɨ, audú p'eradachida. Mãpai mãgajida: —¡Wãara, na eperã Tachi Ak'õre Warra paji! ");
INSERT INTO sjaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mama t'ɨmɨɨpapai ak'ɨ p'anajida wẽraarã chok'ara, Galilea eujãdeepa che p'anadap'edaa Jesús ome. Ãchia Jesús k'aripapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ãra ome baji María Magdalena. Ichiaba baji Santiago mãik'aapa José nawe t'ɨ̃jarapatap'edaa María. Ichiaba baji Zebedeo wẽra. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","P'ãriupodopa pacheji eperã p'arat'ara bɨ, t'ɨ̃jarapatap'edaa José. Mãgɨ́ eperã Arimatea p'uurudepema paji. Ichiaba Jesude ijãapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José wãji Pilatomaa Jesús k'ap'ɨa piuda iidide ɨait'ee. Pilatopa teepiji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mãpai Josepa Jesús k'ap'ɨa lienzo chiwidide pɨraji ");
INSERT INTO sjaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mãik'aapa bɨji mãu te uria k'oropida ichi-it'ee iru badade. Made piuda apida waide ɨada-e p'anajida. Maap'eda ma mãu te uria t'ai jɨ̃a bëiji mãu choma bɨpa mãik'aapa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mamĩda María Magdalena apema María ome su-ak'ɨ p'aneejida ma mãu te uria t'ai k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Aɨ norema ɨ̃ipata ewate paji. Ma ewate p'aareerã poroorã fariseorã ome wãjida Pilatomaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mãganajida: —Señor, taipa k'irãpa p'anɨ jã seewa-idaa bada chok'ai bak'ãri, jaraji ichi piup'eda ewari õpee parumaa chok'ai p'irabaiit'eeda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mapa soldaorã pë́iji jãgɨ́ ɨadap'edaamãi jɨ̃ade k'ãima õpee paru misa, maa-e pɨrã chi k'õp'ãyoorã p'ãrik'ua chedap'eda, atadaridai iru k'ap'ɨa piuda mãik'aapa eperãarãmaa jaradai iru waya chok'ai bɨ. Mãga ooruta pɨrã, eperãarãpa ma seewa audupɨara ijãadayada ajida, naawedapema k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatopa p'anauji: —Acha p'anɨ soldaorã atéetɨ mãik'aapa chi ɨadap'edaamãi jɨ̃a paraa bɨnadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aramãgá mamaa wãdap'eda, ma mãu te uria t'aide mãu choma bɨpa t'ap'a bɨjida. Pi-ia sellaa ata bɨjida. Maap'eda soldaorã jɨ̃a paraa atabëijida mama. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɨ̃ipata ewate wãyaap'eda, tomia ewate ta-p'eda weda María Magdalena awaraa María ome wãjida Jesús k'ap'ɨa ɨadap'edaamaa iru ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mãga nɨde eujã wëre nɨ̃beeji, ɨt'ariipa ángel ma eujãdee cheda perã. Mãgɨpa Jesús ɨa bada mãu te uria t'aidepema mãu choma jɨ̃a bada ãyaa atap'eda, aɨ ɨ̃rɨ su-ak'ɨ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ma ángel ɨ̃daa ak'ɨ baji, pa tau ẽe-ẽeparik'a. Chi p'aru audú t'o-t'oo baji nievek'a. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldaorãpa mãgɨ́ unudak'ãri, k'ap'ɨa wëree para beeji p'era jõnɨpa mãik'aapa piudak'a baip'aneejida eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mãga nɨde angelpa mãgaji ma wẽraarãmaa: —Waaweenáatɨ. Mɨa k'awa bɨ parãpa jɨrɨmaa p'anɨ Jesús, chi kurusode baijira bɨdap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iru nama wẽ-e. Chok'ai p'irabaiji ichia jaradak'a. Pɨchá, ak'ɨ chétɨ iru ɨadap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Maap'eda, isapai wã́tɨ mãik'aapa chi k'õp'ãyoorãmaa jaranátɨ: “¡Chok'ai p'irabaijipɨ! Parã naa iru wãit'ee Galilea eujãdee. Mama iru unudait'ee.” Mata mɨa parãmaa jara chejida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aramata Jesús k'ap'ɨa ɨadap'edaamãiipa ma wẽraarã isapai wãjida chi k'õp'ãyoorãmaa jarade. Mamãik'aapa ãchobee, ma awara t'ãri o-ĩa p'ira wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mãgá wãdade Jesús ãchi k'ĩrapite uchiaji mãik'aapa ãchimaa saludaaji. Aramata ma wẽraarãpa Jesumaa orradachida. Maap'eda iru bɨɨrɨ wëre atajida mãik'aapa irumaa ɨt'aa t'ɨ̃jida. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mãpai Jesupa mãgaji: —Waaweenáatɨ. Wã́tɨ jarade mɨ k'õp'ãyoorãmaa Galileadee wãdamerã. Mama mɨ unudayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ma wẽraarã wãruta misa, ma jɨ̃amaa p'anadap'edaarã ũk'uru wãjida p'uurudee ãchi ome p'asada nepɨrɨde p'aareerã poroorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mãɨrã wãjida pedeeteede judiorã poro waibɨarã ome. Maap'eda soldaorãmaa p'arat'a waibɨa p'aajida mãik'aapa ");
INSERT INTO sjaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mãgajida: —Jarátɨ parã k'ãi jõnɨ misa, Jesús k'õp'ãyoorã chedap'eda, iru k'ap'ɨa chɨa atadachida. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilatopa ma p'asada k'awaa ataru pɨrã, taipa pedeedait'ee parã k'ap'ɨa. Mãgá parã k'aripa atadayada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldaorãpa ma p'arat'a jitadap'eda, oojida mãɨrãpa jaradap'edaak'a. Ma seewa at'ãri jarapata judiorã t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","T'ẽepai Jesús k'õp'ãyoorã once wãjida Galileadee. Panajida irua jarada eemãi. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús unudak'ãri, irumaa t'ãri o-ĩa ɨt'aa t'ɨ̃jida. Mamĩda ũk'uruurãpa at'ãri pia ijãada-e p'anajida iru wãara chok'ai p'irabaida. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mãga nɨde Jesús ãra k'ait'a cheji mãik'aapa mãgaji: —Tachi Ak'õrepa jõmaweda ne-inaa ɨt'ari nɨ̃bɨ, na p'ek'au eujãde nɨ̃bɨ bɨji mɨ jua ek'ari. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maperã wã́tɨ na p'ek'au eujã eperãarã paraamaa, mɨchi k'õp'ãyoorã papide. Ãra poro chóotɨ Tachi Ak'õre t'ɨ̃de, ichi Warra t'ɨ̃de mãik'aapa ichi Jaure t'ɨ̃de. ");
INSERT INTO sjaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jaratéetɨ oodamerã mɨa parãmaa jaradak'a. Mɨ parã ome bapariit'ee ewari chaa, na p'ek'au eujã jõrumaa.");
INSERT INTO sjaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mɨ, Marcopa p'ãru Jesucristode; iru Tachi Ak'õre Warra; Tachi Ak'õrepa eperãarãmaa pedee pia Jesucristode k'awapida. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chonaarãweda Tachi Ak'õre pedee jarapari Isaíapa p'ãji: ‘Tachi Ak'õrepa mãgaji ichi Warramaa: “Mɨa eperã chok'a pëiit'ee pɨ naa o pia oonamerã pɨ, eperãarã poro waibɨa, chei naaweda.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Eujã pania wẽe bɨde eperã bia bɨ: “O pi-ia oopatak'a poro waibɨa chei naaweda, mãga pɨk'a p'ek'au k'achia oo amáatɨ Tachi Waibɨa chei naaweda.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ewari aba Isaíapa p'ãdak'a p'asaji. Eperã t'ɨ̃jarapatap'edaa Juan Bautista cheji eujã pania wẽe bɨmaa. P'aru camello k'aradee k'ada jɨ̃pachi. Chi k'ɨrrɨde jɨ̃pari ne-edee ooda paji. K'opachi sisi mãik'aapa topachi jɨrrɨ miéle. Judea eujãdepemaarã mãik'aapa Jerusalendepemaarã chok'ara wãpachida iru ũraa ũride. Irua jarateepachi Tachi Ak'õrede ijãadamerã mãik'aapa poro choopidamerã ak'ɨpidait'ee ãchia p'ek'au k'achia oopata oodaamaa p'anɨ. Mãgá Tachi Ak'õrepa ãchia p'ek'au k'achia oopata wẽpapii. Mãga ũridak'ãri, eperãarãpa Tachi Ak'õremaa chupɨria iidi chejida ãchia p'ek'au k'achia oopata k'aurepa. Mãpai Juanpa poro chooji Jordán to jãde. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ichiaba jarateepachi: —Eperã mɨ t'ẽe cheru. Mãgɨ́ waibɨara bɨ mɨ k'ãyaara p'ek'au k'achia wẽe bairã. Mapa ɨ̃jaabaip'eda, iru chancla jida ẽraik'araa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɨa parã poro choopari paniapa, mamĩda irua parã nãgá poro chooit'ee. Ak'õre Jaure ba chepiit'eeda aji, parã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Maapai Jesús cheji Nazaret p'uurudeepa. Ma p'uuru Galilea eujãde bɨ. Cheji Juanpa jaratee badamaa. Mãpai Juanpa Jesús poro chooji Jordán tode. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús toiduupa uchiak'ãri, unuji pajã ewadaru mãik'aapa Tachi Ak'õre Jaure ichi ɨ̃rɨ palomak'a baai cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mãpai ɨt'ariipa Tachi Ak'õrepa jaraji: —Pɨda aji, mɨ Warra k'inia, mɨa jɨrɨt'erada. Pɨa mɨ t'ãri o-ĩapipari. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mãga bap'eda, Ak'õre Jaurepa Jesús wãpiji eujã pania wẽe bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mama ne-animal k'achia paraamãi ituaba baji k'ãima cuarenta. Netuara Poro Waibɨapa ne-inaa k'achia oopi k'inia baji, mamĩda p'oyaa-e paji. Jesupa oo-e pak'ãri, angeleerã chejida iru k'aripade. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan Bautista carcelde t'ɨ nɨ̃bɨdap'eda, Jesús wãji Galilea eujãdee Tachi Ak'õre pedee pia jarateede. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jarapachi: —Idi weda eperãarãpa k'awaadait'ee Tachi Ak'õrepa eperãarã bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã. Mapa k'ĩsia p'ua bap'eda, p'ek'au k'achia oo amaadapáde aji, mãik'aapa ijãadapáde aji, iru pedee pia jara pëidade. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maap'eda Jesús Galilea Lago ide nide unuji Simón mãik'aapa chi ɨ̃pema Andrés. To-ɨapataarã paji. Mapa t'ɨrɨ t'aamaa p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesupa mãgaji: —Mɨ ome nipapatáatɨ mãik'aapa óotɨ mɨa ooparik'a. Idideepa eperãarã jɨrɨdait'ee Tachi Ak'õre-it'ee, to-ɨapataarãpa chik'o jɨrɨpatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aramata ãchi t'ɨrɨ atabëijida mãik'aapa wãjida iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ipu nok'ode unuji Santiago mãik'aapa chi ɨ̃pema Juan. Zebedeo warrarã paji. T'ɨrɨ pi-ia p'e bɨmaa p'anajida barcode. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesupa ãra unuk'ãri, t'ɨ̃ji ichi ome auk'a nipapataadamerã. Aramata atabëijida ãchi mimia barcode ãchi ak'õre chi k'aripapataarã ome mãik'aapa wãjida Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Panajida Capernaum p'uurude. Mãgɨ́ p'uuru Galilea eujãde bɨ. Judiorã ɨ̃ipata ewate pada perã, Jesús wãji Ak'õre Ũraa jarateepata tedee. Mama jarateemaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jõmaarã taide jĩp'a jarateeji Tachi Ak'õrepa jarateepidak'a. Moisepa p'ãda jarateepataarã k'ãyaara pipɨara jarateeji. Mapa eperãarã ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mama t'ĩuji eperã k'achia bɨ Tachi Ak'õre k'ĩrapite, netuara iru k'ap'ɨade merãtɨa bada perã. Ma netuarapa biaji: ");
INSERT INTO sjaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús Nazaret p'uurudepema, ¿k'ãata oo chejima aji, taimaa? ¡Tai ichiak'au bɨ́ji! ¿Tai k'enat'aadeta cheruk'ã? aji. Mɨa pɨ k'awa bɨ. Tachi Ak'õrepa pɨ pëiji. Mapa pɨde p'ek'au k'achia wẽe bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mãpai Jesupa ma netuara ɨtrɨat'aaji: —¡K'ĩup'ee beepáde aji, mãik'aapa uchiapáde aji, na eperã k'ap'ɨadeepa! ");
INSERT INTO sjaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mãpai ma netuarapa eperã wawat'aaji mãik'aapa golpe biap'eda, k'ap'ɨadeepa uchiadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mãga unudak'ãri, jõmaweda ak'ɨtrua para beeji mãik'aapa pedee para beeji ãchi pitapai: —¿K'aima na eperã? ¡Eperã poro waibɨak'a jaratee bɨ! Irua jarateeda waide ũridak'aa nama. ¡Ma awara netuaramaa pedeek'ãri, irua jararuk'a auk'a oo p'anɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mapa taarã-e weda Galilea eujãdepemaarãpa Jesús k'awaajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús, Santiago Juan ome uchiadak'ãri Ak'õre Ũraa jarateepata tedeepa, wãjida Simón mãik'aapa Andrés temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón p'ãk'õre k'ɨamiapa p'arude baji. Mapa jaranajida Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús irumaa wãji mãik'aapa juade jita atap'eda, p'irabai ataji. Aramata k'ɨamia tuudachi. Mãpai chi k'ayaa badapa nek'opiji Jesumaa mãik'aapa chi k'õp'ãyoorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","K'eudaik'ãri, eperãarãpa k'ayaa beerã chok'ara aneejida Jesumaa. Ichiaba aneejida netuara k'ap'ɨade merãtɨa beerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","P'uuru pidaarã chok'ara see nɨ̃beeji te t'ĩupatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesupa k'ayaa k'ĩra t'ãdoo iru p'anadap'edaarã jɨpaji. Ichiaba netuaraarã eperã k'ap'ɨade merãtɨa beeda uchiapik'ooji. Ma awara ma netuaraarãmaa pedeepi-e paji, ãchia k'awa p'anadap'edaa perã iru Tachi Ak'õrepa pëida eperãarã k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tap'edapodopa Jesús p'irabaiji mãik'aapa uchiaji p'uurudeepa ɨt'aa t'ɨ̃nait'ee eperãarã p'anadak'aamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón p'irabaik'ãri, iru unu-e paji. Mapa apemaarã k'õp'ãyoorã ome wãji Jesús jɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Unu atadak'ãri, mãgajida: —Jõmaarãpa pɨ jɨrɨ nidada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mamĩda Jesupa mãgaji: —Tachi Ak'õrepa mɨ pëiji ichi ũraa jõmaarãmaa jarateemerã. Mapa wãdáma aji, awaraa p'uuru k'ait'a beemaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús mãgá jaratee nipapachi jõma Galilea eujãde chi k'õp'ãyoorã ome. Jarateepachi Ak'õre Ũraa jarateepata tede p'uuru bee chaa mãik'aapa eperã k'ap'ɨade netuara merãtɨa bee uchiapipachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ewari aba eperã leprapa k'ayaa bɨ cheji Jesumaa mãik'aapa bedabaip'eda, mãgaji: —K'inia bɨ pɨrã, mɨ k'ayaa wẽpapipáde aji, Ak'õre k'ĩrapite mɨ pia beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesupa iru chupɨria k'awaaji. Juapa t'õbaiji mãik'aapa mãgaji: —¡K'inia bɨda! aji. Jɨpa beepáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aramata ichi k'ap'ɨadeepa lepra k'ayaa wẽpadachi mãik'aapa jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesupa ãyaa pëik'ãri, ũraaji: ");
INSERT INTO sjaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—¡Ũríji! Jaranáaji apidaamaa. Jĩp'a p'aaremaa ak'ɨpináji. Moisepa p'ãdade jara bɨk'a ipana omé atéeji, teeit'ee Tachi Ak'õremaa. Mãgá jõmaarãpa pɨ jɨpa beeda k'awadayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mamĩda wãk'ãri, ma eperãpa pariatua jara wãpachi. Maperã Jesús p'oyaa wãk'aa paji p'uurudee. Eperãarã p'anadak'aamãi nipapachi. Mamĩda at'ãri p'uuru pidaarã irumaa wãpachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma t'ẽepai Jesús waya wãji ichi bapatamaa Capernaum p'uurudee. Mamĩda eperãarãpa k'awaadak'ãri iru mama bɨ, ");
INSERT INTO sjaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","taarã-ee eperãarã chok'ara teeda see nɨ̃ba cheji. T'ĩupatamãi pida araa-ee nɨ̃beeji. Irua Ak'õre Ũraa jaratee bɨ misa, ");
INSERT INTO sjaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","eperãarã k'ĩmariirãpa irumaa aneejida eperã chiwa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mamĩda Jesumãi p'oyaa t'ĩuda-e paji, chok'ara see nɨ̃bada perã ma tede. Maperã terrazade wãjida mãik'aapa uria ewa atajida. Mãgɨ́ uriadeepa chi chiwa bɨ ɨrabai atajida ichi p'arude. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesupa mãga unuk'ãri, k'awaji wãara ichide ijãa p'anɨ. Mapa mãgaji ma chiwa bɨmaa: —Warra, pɨa p'ek'au k'achia oopata jõmaweda wẽpajipɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisepa p'ãda jarateepataarã ũk'uru mama su-ak'ɨ p'anajida. Mãga ũridak'ãri, k'ĩsiajida: ");
INSERT INTO sjaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Jã eperã ik'achia pedeemaa bɨ Tachi Ak'õre ãpɨte. Na eujãdepemaarãpa p'ek'au k'achia wẽpapidak'aa; Tachi Ak'õrepapaita mãga ooi.” ");
INSERT INTO sjaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mamĩda Jesupa ichi t'ãride k'awaji ãchia k'achia k'ĩsia p'anɨ. Mapa mãgaji: —¿Sãap'eda parãpa k'ĩsia k'achia k'ĩsia p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mɨa irumaa jarai: “Pɨa p'ek'au k'achia oopata wẽpajipɨ” maa-e pɨrã jarai: “P'irabáiji mãik'aapa wã́ji”. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mɨ chi Eperã Ak'õre Truadepema. Mapa Tachi Ak'õre jua ek'ari mɨa p'ek'au k'achia wẽpapipari na p'ek'au eujãde. Parãpa mãgɨ́ k'awaadamerã mɨa jarait'ee: ");
INSERT INTO sjaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","¡P'irabáiji! Pɨchi p'aru atáji mãik'aapa wã́ji pɨchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mãpai ma chiwa bada p'irabaidachi mãik'aapa ichi p'aru atap'eda, uchiadachi jõmaarã taide. Mãpai jõmaarãta ak'ɨtrua para beeji. O-ĩapa jarapachida Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ: —Waide nãga unudak'aada apachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Maap'eda Jesús waya wãji Galilea Lago idee. Eperãarã irumaa chepachida. Mãpai Ak'õre Ũraa jarateepachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wãyaa wãde, unuji Leví. Mãgɨ́ Alfeo warra paji. Su-ak'ɨ baji Cesar-it'ee impuesto p'aapatamãi. Jesupa mãgaji irumaa: —Mɨ ome nipaparíiji. Aramata p'irabaip'eda wãji Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Maap'eda chok'ara impuesto p'epataarã Roma pidaarã rey-it'ee mãik'aapa awaraa eperãarã k'achia-idaa beerã apatap'edaa Jesús ome nipapachida. Maapai Jesús nek'onaji Leví tede. Jesús mãik'aapa ichi ome nipapataarã su-ak'ɨ p'aneejida mesade. Auk'a mãgɨ́ eperãarã su-ak'ɨ p'aneejida mama Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisepa p'ãda jarateepataarã, fariseorã eere p'anapatap'edaarãpa mãga unudak'ãri, iidijida Jesús k'õp'ãyoorãmaa: —¿Sãap'eda parã jarateepari nek'omaa bɨma ajida, impuesto p'epataarã ome mãik'aapa awaraa p'ek'au k'achia oopataarã ome? Jãga ooik'araa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesupa ãchia jaradap'edaa ũrik'ãri, mãgaji: —Médico pëidak'aa k'ap'ɨa pia beerãmaa. Jĩp'a pëipata k'ayaa beerãmaa. Mãga pɨk'a Tachi Ak'õrepa mɨ pëi-e paji t'ãri pia beerã jɨrɨde; ma k'ãyaara p'ek'au k'achia oopataarã jɨrɨdeta pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ewari aba Juan Bautista k'õp'ãyoorã mãik'aapa fariseorã ɨt'aa t'ɨ̃maa p'anajida nek'oda-ee Tachi Ak'õre waaweepa. Eperãarã ũk'uruurãpa mãga unudak'ãri, Jesumaa iidinajida: —Juan ome nipapataarã mãik'aapa fariseorã ome nipapataarã edaare nek'odak'aa. ¿Sãap'eda pɨ k'õp'ãyoorãpa auk'a oodak'aama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesupa p'anauji: —Eperãarã miak'ãipata fiesta oodak'ãri, o-ĩa p'anapata. Mapa k'õp'ãyoorã miak'ãidait'ee p'anɨɨrã ome p'anɨ misa, nek'opata o-ĩa p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mamĩda ewari aba miak'ãiit'ee bada ɨmɨk'ĩra ata chedait'ee chi k'õp'ãyoorã ik'aawaapa. Wãara, ma ewate chi k'õp'ãyoorã nek'oda-e pait'ee t'ãri p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Eperã apidaapa p'aru chiwididepema pite aba t'ɨɨik'araa bɨda aji, p'aru sorede parchaait'ee. Mãga ooru pɨrã, chi p'aru chiwidi ãridariit'ee mãik'aapa ma pite auk'a bee-e pait'ee chi p'aru sore ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ichiaba vino ewaa juda t'ɨdak'aa ne-e sorede. Mãga ooruta pɨrã, baak'adaipari mãik'aapa ne-e jĩadaipari. Vino jida ichiaba atuadaipari. ¡Maperã vino ewaa juda t'ɨdaipia bɨ ne-e chiwidi bɨde! ");
INSERT INTO sjaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Judiorã ɨ̃ipata ewate Jesús nipaji trigo k'ãide mãik'aapa chi k'õp'ãyoorã wãyaa wãdak'ãri, trigo k'ɨmɨ chak'eerã oro ata wãjida chi tau k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Arii p'anadap'edaa fariseorãpa mãga unudak'ãri, Jesumaa mãgajida: —¡Pɨchá ak'ɨ́ji! ¿Sãap'eda pɨ k'õp'ãyoorãpa jãga oomaa p'anɨma? ajida. Chonaarãweda Moisepa jaraji mimiadaik'araa bɨ ɨ̃ipata ewate. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesupa mãgaji: —Parãpa Tachi Ak'õre Ũraa p'ã jẽra bɨde pia k'ĩsiada-e p'anɨ. Chonaarãweda Rey David chi k'õp'ãyoorã ome audú jarrapisia p'anadak'ãri, ");
INSERT INTO sjaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ichi t'ĩuji Tachi Ak'õre te ne-edee oodade. Abiatar, p'aareerã poro waibɨapa, pan k'opiji Davidmaa, aɨ naaweda Tachi Ak'õrepa jaraji mĩda p'aareerãpa aupai mãgee pan k'odamerã. Davidpa ma pan k'op'eda, ichi ome nipapataarãmaa teeji. Tachi Ak'õrepa ãra miapi-e paji mãga oodap'edaa k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tachi Ak'õrepa eperãarã oo-e paji ɨ̃ipata ewari ɨadamerã. Naapɨara Tachi Ak'õrepa eperã ooji. T'ẽepai ooji ɨ̃ipata ewari eperãarã ɨ̃idamerã mimiada-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɨ̃ipata ewate paara mɨ, chi Eperã Ak'õre Truadepema jua ek'ari bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Waya Jesús wãji Ak'õre Ũraa jarateepata tedee. Mama baji eperã jua chiwa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ũk'uru arii p'anadap'edaarãpa Jesumaa ak'ɨ para baji, ɨ̃ipata ewate jɨpai jĩak'aapa. Mãgá ãchi charraarãmaa jaranadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mãpai Jesupa jua chiwa bɨmaa maaji: —P'irabáiji mãik'aapa jõmaarã esajĩak'a ak'ɨnɨ̃ béeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mãpai apemaarãmaa iidiji: —¿K'ãare p'ãdata iru p'anɨ Ak'õre Ũraade ɨ̃ipata ewate oodamerã? ¿Pia ooipia bɨ wa k'achia? ¿Jɨpaipia bɨ piupiamaapa wa piupiipia bɨ, k'aripada-ee? Mamĩda ãchi k'ĩup'ee para beeji k'awa p'anadap'edaa perã piata ooipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesupa k'ĩrau ak'ɨji ãchimaa. Ma eperã chupɨria k'awaa k'iniada-e p'anadap'edaa perã, Jesús k'ĩra pia-ee beeji. Mãpai ma eperãmaa mãgaji: —Pɨchi jua jĩrupáde aji. Mãpai jua jĩruji. Aramata jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mapa fariseorã mamãik'aapa uchiadap'eda, Rey Herodes eere p'anadap'edaarã ome pedeeteemaa p'aneejida Jesús peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Galilea eujãdepemaarã chok'ara Jesús t'ẽe chejida. Mapa iru wãji chi k'õp'ãyoorã ome Galilea Lago idee. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesupa ne-inaa pia oopari k'awaadak'ãri, eperãarã chok'araara cheepurujida irumaa: Judea eujãdepemaarã, Jerusalén p'uurudepemaarã, Idumea eujãdepemaarã. Ichiaba chejida Jordán to k'ĩraik'a eerepemaarã, Tiro p'uuru k'ait'a p'anapatap'edaarã mãik'aapa Sidón p'uuru k'ait'a p'anapatap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Chok'ara jɨpada perã, k'ayaa beerãpa iru p'ĩsua ata chejida, t'õbairupa jɨpa p'aneedai jĩak'aapa. Eperãarã audú chok'ara nɨ̃bada perã, ichi ome nipapataarã pëiji barco jɨrɨde, eperãarã ichimaa chenaadamerã. Mãpai jarateeji barcodeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Netuara merãtɨa beerãpa Jesús unudak'ãri, iru k'ĩrapite bedabaik'oodachida mãik'aapa biapachida: —¡Pɨ Tachi Ak'õre Warrapɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mamĩda Jesupa netuaraarã ɨtrɨapachi ichia ooda nepɨrɨnaadamerã eperãarã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Maap'eda Jesús ee nok'odee wãji chi k'õp'ãyoorã ome mãik'aapa jɨrɨt'eraji ichi k'ĩsiade iru bada. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doce jɨrɨt'eraji ichi ome nipapataadamerã mãik'aapa Ak'õre Ũraa jarateepataadamerã awara ãi. Mãgɨɨrã t'ɨ̃ bɨji apóstoles. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mãgɨɨrã ichiaba pëiji netuara merãtɨa bee uchiapidamerã eperãarã k'ap'ɨadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nãgɨɨrã paji chi doce jɨrɨt'erada: Simón, (Jesupa t'ɨ̃ bɨda Pedro); ");
INSERT INTO sjaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo warrarã, Santiago Juan ome; Jesupa ichiaba ãra t'ɨ̃ bɨda Boanerges; ");
INSERT INTO sjaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés; Felipe; Bartolomé; Mateo; Tomás; Santiago (Alfeo warra); Tadeo; Simón Celote apatap'edaa; ");
INSERT INTO sjaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mãik'aapa Judas Iscariote; mãgɨpa t'ẽepai Jesús traicionaada. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma t'ẽepai Jesús teeda t'ĩuji chi k'õp'ãyoorã ome mãik'aapa waya eperãarã chok'ara irumaa chejida. Mapa p'oyaa nek'odak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús ëreerãpa mãga k'awaadak'ãri, iru ata chejida jaradap'edaa perã k'ĩra k'awa-ee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisepa p'ãda jarateepataarã che p'anajida Jerusalendeepa. Ãchia jarapachida: —Beelzebú, Netuara Poro Waibɨa juapata jãgá netuaraarã uchiapiparida apachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesupa ãchi t'ɨ̃ p'e atap'eda, nepɨrɨji: —¿Sãga Satanapa uchiapiima ichi auk'aarã? ");
INSERT INTO sjaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","P'uuru pidaarã chik'ĩra unuamaa p'aneeruta pɨrã, taarãda-e ãchi itu jõdaridait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Auk'a te pidaarã awara-awaraadaidak'ãri, waa araa p'anapataada-e pait'ee mãik'aapa jõdaridait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mãga pɨk'a Netuara Poro Waibɨapa ichi auk'aarã jëreru pɨrã, ãchi itu jõdaridai. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ma awara, apida t'ĩudak'aa eperã juataura bɨmãi iru net'aa jãri atade. Naapɨara jɨ̃ nɨ̃bɨ-e pɨrã, iru net'aa jãri p'e ata-e pai. Mɨ waibɨara bɨ Netuara Poro Waibɨa k'ãyaara. Mapa netuaraarã mɨ jua choodak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Mɨa wãarata jararu. Tachi Ak'õrepa p'ek'au k'achia jõmaata wẽpapii, pedee k'achia jaradap'edaa paara iru ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mamĩda ik'achia jararuta pɨrã iru Jaure ãpɨte, Tachi Ak'õrepa perdonaak'aa. Mãgee p'ek'au k'achia wẽpapi-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Moisepa p'ãda jarateepataarãpa jarapachida Jesupa ne-inaa oopachi netuara juapa mãik'aapa merapachida Tachi Ak'õre Jaure. Mapa mãga jaraji Jesupa. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mãpai pachejida Jesús nawe chi ɨ̃pemaarã ome. Mamĩda taawa p'aneejida mãik'aapa t'ɨ̃ pëijida Jesús ãchimaa uchiamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesús ik'aawa su-ak'ɨ p'anadap'edaarãpa jarajida: —Pɨ nawe pɨ ɨ̃pemaarã ome taawa nɨmaa p'anɨda ajida. Ãrapa pɨ jɨrɨ nidada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Irua p'anauji: —Parãpa k'awa p'anɨ mɨ nawe mãik'aapa mɨ ɨ̃pemaarã. Mamĩda ¿k'airãta mɨa k'inia iru bɨma mɨ nawek'a mãik'aapa mɨ ɨ̃pemaarãk'a? ");
INSERT INTO sjaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ak'ɨp'eda ichi ik'aawa su-ak'ɨ p'anadap'edaarãmaa, mãgaji: —Acha p'anɨɨrãta mɨa k'inia iru bɨ mɨ nawek'a mãik'aapa mɨ ɨ̃pemaarãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tachi Ak'õrepa k'inia bɨk'a oopataarãta mɨ ɨ̃pemak'a, mɨ ɨ̃pewẽrak'a p'anɨ mãik'aapa mɨ nawek'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Waya Jesús jarateemaa beek'ãri lago ide, eperãarã chok'ara chejida. Audú chok'ara chedap'edaa perã, Jesús batauji barco lago jãde badade mãik'aapa su-ak'ɨ beeji. Jõdee eperãarã jõmaweda p'aneejida lago ide. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mamãik'aapa Jesupa eperãarãmaa nepɨrɨmaa beeji Ak'õre Ũraa jarateeit'ee: ");
INSERT INTO sjaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Mɨa nepɨrɨru pia k'ĩsíatɨ. Eperã wãji net'atau p'ode. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma p'o wãk'ãri, ũk'uru baaijida o jãde. Mãpai ipanaarãpa k'ok'oo chejida. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ũk'uru baaijida mãu-idaade mak'ɨara yooro wẽe badamãi. Mãgɨ́ isapai t'onojida, mak'ɨara yooro wẽe bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mamĩda ak'õrejĩru jẽrak'ãri, chi k'iru pɨɨdachi, chi k'arra ɨ̃rɨɨ bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ũk'uru baaijida ne-ɨɨrɨ-idaade. Mamĩda ne-ɨɨrɨ k'ap'ip'iara waripari perã, mãgɨ́ net'atau t'ono wãdap'edaa piuk'oodachida. Maperã chauda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jõdee awaraa net'atau baaijida eujã piade. Mãgɨ́ t'onojida, warijida mãik'aapa pia chaujida. Ũk'uru net'atau abaadeepa uchiajida treinta, sesenta maa-e pɨrã cien. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mãpai Jesupa mãgaji: —¡Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","T'ẽepai Jesús ituaba beeji chi k'õp'ãyoorã doce ome, awaraa ichi ome nipapatap'edaarã paara. Mãpai ãchia iidijida: —¿K'ãata jara k'inia bɨma ajida, pɨa nepɨrɨ bada? ");
INSERT INTO sjaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesupa p'anauji: —Tachi Ak'õrepa parãmaa k'awapimaa bɨ ne-inaa naaweda k'awapik'aa pada; sãga ichideerã p'aneedai. Mamĩda awaraarãmaa mɨa nepɨrɨpari jarateeit'ee, k'awada-ee p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Mɨa oo bɨ ak'ɨ p'anɨ mĩda, wãara unuda-e mãik'aapa mɨa jara bɨ ũri p'anɨ mĩda, k'awada-e. Mɨa jarateepari pia k'awadap'edaa paara, Tachi Ak'õrede ijãak'ajida mãik'aapa irua ãchia p'ek'au k'achia oopata wẽpapik'aji. Mamĩda wãara mãga k'iniadak'aa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mãpai Jesupa iidiji chi k'õp'ãyoorãmaa: —¿Parãpa k'awada-e p'anɨk'ã mɨa jaratee k'inia bɨ ma nepɨrɨdade? ¿Sãga k'awaadait'ee awaraa nepɨrɨk'ãri jarateeit'ee? Nãga jara k'inia bɨ: ");
INSERT INTO sjaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Ma net'atau p'opari Ak'õre Ũraa jarateeparik'a bɨ mãik'aapa ma net'atau Ak'õre ũráak'ata bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Net'atau baairutamãi eperãarã Ak'õre Ũraa ũripataarã́k'ata bɨ. Mamĩda ũridap'eda, Netuara Poro Waibɨa chepari ne-inaa ooit'ee, t'ãripa ma pedee ijãanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Awaraa eperãarã chi net'atau mãu-idaade baaidap'edáak'apɨ p'anɨ. Tachi Ak'õre Ũraa o-ĩa ũripata. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mamĩda ma net'atau t'onoda taarã-e weda pɨɨdaiparik'a, mãga pɨk'a mãgɨɨrãpa ma jara pëida taarã ijãada-e. Maperã ma ũraade ijãadap'edaa k'aurepa awaraarãpa nepɨra jɨrɨ cheruta pɨrã ãchi ome, maa-e pɨrã awaraarãpa ãchi jɨrɨruta pɨrã miapidait'ee, ijãa amaapata. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Awaraa eperãarã chi net'atau ne-ɨɨrɨ-idaade baaidap'edáak'apɨ p'anɨ. Ak'õre Ũraa ũri p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mamĩda ãchia na p'ek'au eujãdepema net'aa k'ĩsia p'aneepata ãchi-it'ee atadait'ee. Tachi Ak'õre Ũraa ũridai k'ãyaara, p'arat'a mãik'aapa awaraa ne-inaa waapɨara k'inia p'anapata. Maperã Tachi Ak'õrepa oopi k'inia bɨk'a oodak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jõdee awaraa eperãarã chi net'atau eujã piade baaidap'edáak'apɨ p'anɨ. Net'atau aba eujã piade uuda chauparik'a tau treinta maa-e pɨrã sesenta maa-e pɨrã cien, mãga pɨk'a ma eperãarãpa Ak'õre Ũraa ũridak'ãri, t'ãride ijãa p'aneepata. Mãgá Tachi Ak'õre Ũraa waapɨara k'awaa wãpata mãik'aapa oopata irua k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ichiaba jarateeji: —Tachia lámpara k'oodak'aa cajón ek'ari ata bɨdait'ee maa-e pɨrã cama ek'ari. Ma k'ãyaara lámpara k'oodak'ãri, ɨt'ɨ́ ata bɨpata pia ɨ̃daamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mãga pɨk'a, ɨ̃rá Tachi Ak'õre net'aa mera pɨk'a bɨ mĩda, t'ẽepai parãpa jõmaarãmaa jaradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ichiaba jaraji: —Pia k'ĩsíatɨ mɨa jararude. Eperãpa ne-inaa pia ook'ãri mɨa jarateeda pia k'ĩsia bairã, pia oo bɨ. Tachi Ak'õrepa ichi ũraa audú k'awaapii irumaa, mãik'aapa ne-inaa pipɨara ooyada aji, iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tachi Ak'õrepa eperã k'ĩsia k'awaa bɨmaa k'ĩsia k'awaara bapiit'ee, Ak'õre Ũraa Pia ijãapari perã. Jõdee mɨa jarateeda pia k'ĩsia k'inia-e bak'ãri, ichia naaweda k'awa bada k'ĩra atuapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ichiaba Jesupa nepɨrɨji: —Tachi Ak'õre jua ek'ari p'anɨɨrã ĩwapata net'atau eujãde p'odak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tachia net'atau p'odap'eda, k'euru chaa k'ãiruta pɨjida mãik'aapa ewari chaa p'irabairuta pɨjida, ma net'atau t'onopari mãik'aapa wari wãpari. Tachia k'awada-e sãga mãgá waripari. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yoorode net'atau ichi itu t'onopari. Naapɨara uchiapari chi t'uk'u; mamãik'aapa chi k'iru. Maap'eda uchiapari chi k'ɨmɨ chak'e; t'ẽepai net'atau chok'ara chaupari. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","P'oo bak'ãri, ewapata. Mãga bɨ Tachi Ak'õre jua ek'ari p'anɨɨrã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesupa ichiaba awaraa nepɨrɨji jarateeit'ee: —¿K'ãarek'a bɨma aji, Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã? ¿K'ãata nepɨrɨit'eema pia k'awaadamerã? ");
INSERT INTO sjaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza tau uudák'apɨ bɨ. Mãgɨ́ net'atau apemaarã net'atau k'ãyaara ma-ãriara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mamĩda uup'eda, apemaarã ne-uu k'ãyaara waibɨara waripari. Mãgá waibɨa warik'ãri, ipanaarãpa ãchi te oopata chi juade. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesupa mãga nepɨrɨ wãpachi Tachi Ak'õrede k'ĩsia p'aneedamerã. Ichia nepɨrɨda pia ũridak'ãri, waa nepɨrɨpachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jarateek'ãri, ichita mãgá nepɨrɨpachi. Nepɨrɨ-ee jarateek'aa paji. Mamĩda chi k'õp'ãyoorã ituaba p'aneedak'ãri, ma nepɨrɨda jõma jara k'inia bɨ jarateepachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma ewate k'eu wãk'ãri, Jesupa maaji ichi ome nipapataarãmaa: —Wãdáma aji, lago k'ĩraik'a eeree. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eperãarã atabëijida mãik'aapa bataujida Jesús su-ak'ɨ bada barcode. Awaraarã jida auk'a wãjida awaraa barcode. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mãgá lago sĩa wãdade nãu golpe p'ua nɨ̃beeji mãik'aapa p'usara t'o nɨ̃beeji. Mapa barco pirubaai wã nipaji. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mãɨmisa Jesús k'ãi baji barco trumaa. Su-ak'ɨ beepata ɨ̃rɨ porok'au baji. Aramata ɨ̃rɨmat'aajida mãik'aapa mãgajida: —¡Tachi Waibɨa! ¡P'irabáiji! ¡Tachi pirubaai wãdapɨ! ¿Pɨ-it'ee p'ua-ek'ã ajida, tachi pirubaaidaruta pɨjida? ");
INSERT INTO sjaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mãpai Jesús p'irabaip'eda, mãgaji nãumaa: —Waa p'uanaapáde aji. Mãpai nãu waa p'ua-e paji. Ichiaba p'usamaa maaji: —T'umãtɨ beepáde aji. Aramata jõmaweda ip'ii ũu beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mãpai Jesupa maaji ichi ome nipapataarãmaa: —¿Sãap'eda p'era jõnɨma? ¿At'ãri ijãada-eeta p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mamĩda ãchi p'era para beeji, waide mãga unudak'aa pada perã. Ãchi pitapai iidi para beeji: —¿K'aima nãgɨ́? Tachi Ak'õrepapaita pedeepari nãumaa, p'usamaa ip'ii beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lago k'ĩraik'a eere panajida Gerasa eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús barcodeepa batauk'ãri, irumaa cheji jãɨradeepa eperã k'ap'ɨade netuara merãtɨa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma eperã ãk'adaa bapachi jãɨra mãu te uriade. Ichi ome p'oyaadak'aa paji; cadenapa pida. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Edaare cadenapa bɨɨrɨde mãik'aapa juade jɨ̃ nɨ̃bɨpachida. Mamĩda t'ɨɨt'aapachi. Mapa p'oyaadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ãstaawa, p'ãrik'ua pida bia nipapachi ee beede mãik'aapa jãɨra bee chaa. Ichi itu p'u oo nipapachi mãupa. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mamĩda t'ɨmɨ́ weda mãgɨ́ eperãpa Jesús unuk'ãri, p'iradachi irumaa mãik'aapa bedabaidachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mãpai Jesupa mãgaji: —¡Netuara, uchiapáde aji, na eperã k'ap'ɨadeepa! Biaji: —Jesús, pɨ Ak'õre Waibɨa Warrapɨ. ¿K'ãata ooit'eema aji, mɨ ome? Tachi Ak'õre k'ĩrapite jaráji mɨ k'achia oo-e pait'ee. Mɨ ichiak'au bɨpáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mãpai Jesupa iidiji: —¿Pɨ, k'asaa t'ɨ̃jarapatama? aji. —Mɨ t'ɨ̃jarapatada aji, Legión, chok'ara nipapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mãpai Jesumaa chupɨria iidipachi awara ãyaa pëinaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma ee k'arraya sinaarã chok'ara nek'omaa p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mapa netuaraarãpa chupɨria iidijida: —Awara ãyaa pëii k'ãyaara, ara p'anɨ sina k'ap'ɨade t'ĩupipáde ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mãpai Jesupa netuaraarã mamaa pëiji. Uchiapiji ma eperã k'ap'ɨadeepa mãik'aapa t'ĩupiji sinaarã k'ap'ɨade. Mãɨrã p'irak'oodachida ee k'õot'ari jira bɨdee mãik'aapa lago jãde baainajida. Mama jõmaweda ɨ̃yapa jɨ̃ak'oodachida. Sinaarã perá dos mil paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma sina jɨ̃a p'anadap'edaarãpa mãga unudak'ãri, p'era p'irak'oodachida. Ãchia unudap'edaa nepɨrɨnajida p'uuru pidaarãmaa mãik'aapa p'uuru k'ait'a beerãmaa. Eperãarãpa Jesupa ooda k'awaa k'inia p'anadap'edaa perã, chejida ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesumãi pachedak'ãri, ma eperã netuaraarã merãtɨa p'anadap'edaa unujida, p'aru jɨ̃p'eda, su-ak'ɨ bɨ Jesús ik'aawa mãik'aapa k'ĩra pia ak'ɨ baji. Mãga unudak'ãri, p'era para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chi unudap'edaarãpa nepɨrɨjida apemaarãmaa netuaraarã merãtɨa p'anadap'edaa mãik'aapa sinaarã k'ap'ɨade pëik'ooda. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mãpai waaweepa Jesumaa chupɨria iidijida ãchi eujãdeepa wãmerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús barcode batauk'ãri, ma eperã naaweda netuaraarã merãtɨa badapa chupɨria iidiji Jesupa ichi ome auk'a wãpimerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mamĩda Jesupa oo-e paji; jĩp'a jaraji: —Wã́ji pɨchi temaa. Nepɨrɨnapáde aji, jõmaweda Ak'õrepa ooda mãik'aapa pɨ chupɨria k'awaada. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mãpai nepɨrɨ wãpachi Jesupa ooda ichi ome Decápolis eujãde, p'uuru bee chaa. Mãga ũridak'ãri, eperãarã jõmaweda o-ĩa ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Waya Jesús chek'ãri k'ĩraik'a eereepa barcode, eperãarã chok'ara chejida irumaa lago ide. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mãga nɨde Tachi Ak'õre Ũraa jarateepata tedepema poro pacheji. Ichi t'ɨ̃jarapachida Jairo. Jesús unu atak'ãri, bɨɨrɨmãi bedabaidachi ");
INSERT INTO sjaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mãik'aapa chupɨria iidiji: —Mɨ k'au juak'aya nɨ̃bɨ. Chupɨria k'awáaji. Pɨ jua bɨnapáde aji iru ɨ̃rɨ, mãgá jɨpa beemerã mãik'aapa chok'ai beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mãpai Jesús ichi ome wãji. Ichiaba eperãarã chok'ara wãjida Jesús ome. Maperã p'ĩsua wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma eperãarã see nɨ̃bɨde baji wẽra bi k'ayaa bɨ waamiapa. Doce años mãgá baji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","At'apai mia baji. Jõma chi p'arat'a jõdai baji jɨpapataarã juade nipa, jɨpa-ee. Waapɨara k'ayaa k'erapachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesupa ooda ũri bada perã awaraarã it'aideepa, k'ait'a wãji ãpɨteik'a eereepa iru p'aru t'õbait'aade. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mãga ooji k'ĩsia bada perã iru p'aru i t'õbairupapai jɨpa beei. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","T'õbaik'ãri, aramata waamia t'ɨbaidachi, mãik'aapa ichia k'awaaji Jesupa ichi jɨpada. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aweda Jesupa k'awaaji jɨparu ichia jara-eeta. Mapa ãpɨtee ak'ɨp'eda, iidiji: —¿K'aipa mɨ p'aru t'õbaijima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ichi ome nipapataarãpa mãgajida: —¿Pɨa unu-e bɨk'ã ajida, eperãarã p'ĩsua nɨ̃bɨ? Mãga bɨta iidi bɨ: “¿K'aipa mɨ t'õbaijima?” ");
INSERT INTO sjaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mamĩda Jesupa tau k'it'aa ak'ɨ nɨ̃beeji unui jĩak'aapa k'aipa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma wẽra k'ap'ɨa wëre nɨ̃bapachi p'era nɨ̃bɨpa, k'awa bada perã ichita jɨpa bɨ. Mapa bedabaidachi Jesús k'ĩrapite mãik'aapa jõmaweda jaraji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mãpai Jesupa mãgaji irumaa: —Wẽra, pɨa mɨde ijãa bairã, jɨpa beejida aji. K'ãiwee wãpáde aji, pɨ k'ayaa wẽpada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús pedeemaa bɨde Jairo tedeepa eperãarã chejida mãik'aapa mãgajida Jairomaa: —Pɨ k'au jai-idaaji. Mapa ¿k'ãare-it'ee Jesús ateedayama ajida, pɨchi temaa? ");
INSERT INTO sjaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mamĩda Jesupa mãga ũrik'ãri, mãgaji Jairomaa: —Waaweenáaji; jĩp'a mɨde ijãapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mamãik'aapa k'õp'ãyapi-e paji apemaarãmaa; aba ateeji Pedro, Santiago mãik'aapa chi ɨ̃pema, Juan. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo temãi panadak'ãri, biuk'a nɨ̃baji. Ununajida eperãarã jarajẽe para nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","T'ĩujida teedaa mãik'aapa Jesupa mãgaji: —¿Sãap'eda audupai jẽe para bɨma? aji. Na wẽra k'au jai-idaa-e bɨ. Jĩp'a k'ãita bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mãga ũridak'ãri, ëik'oodachida. Mãpai Jesupa jõmaweda taawaa uchiapik'ooji. Aba t'ĩupiji ma wẽra k'au jai-idaada k'ap'ɨa badamaa, chi ak'õre, chi nawe mãik'aapa Jesús ome wãdap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Juade jita atap'eda mãgaji: —Talita, cum; (jara k'inia bɨ: “Wẽra k'au, p'irabáiji”.) ");
INSERT INTO sjaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aramata p'irabaidachi mãik'aapa p'ɨrrɨa beeji. (Ma wẽra k'au doce años iru baji.) Mãga unudak'ãri, eperãarã ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mamĩda Jesupa ũraaji apidaamaa nepɨrɨnaadamerã. Maap'eda jaraji nek'opidamerã ma wẽra k'aumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mamãik'aapa Jesús wãji ichi warida p'uurudee chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ɨ̃ipata ewate Ak'õre Ũraa jarateemaa beeji mãpema Ak'õre Ũraa jarateepata tede. Eperãarãpa Jesupa jarateeda ũridak'ãri, p'era pɨk'a iidi para beeji: —¿Sãmapɨ k'awaajima ajida, ichia jarateemaa bɨ? ¿Sãgapɨ k'ĩsia k'awaa beejima? Ma awara, ¿Sãga ooparima ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa? ");
INSERT INTO sjaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Jãgɨpa ne-inaa pak'urudee oopari-ek'ã? ¿Ichi María warra-ek'ã? ¿Santiago, José, Judas mãik'aapa Simón chi ɨ̃pemaarã-ek'ã? Ichiaba, ¿ichi ɨ̃pewẽraarã nama p'anapata-ek'ã ajida, tachi t'ãide? Mapa iru pedee ijãa k'iniadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mãpai Jesupa maaji: —Jõmaarã t'ãide ũri k'inia p'anapata Tachi Ak'õre pedee jaraparipa jara bɨ. Mamĩda ichi p'uurudepemaarãmaa jaratee chek'ãri, ijãadak'aa. Auk'a ijãadak'aa jarateek'ãri ichi ëreerãmaa mãik'aapa ichi tedepemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mama irua ne-inaa eperãarãpa p'oyaa oodak'aa oo-e paji, ichide ijãada-e p'anadap'edaa perã. K'ayaa beerã chok'ara-eepai jɨpaji ichi juapa t'õbaik'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","P'era pɨk'a beeji ichi p'uurudepemaarãpa ichide pia ijãada-e pada perã. Jesús p'uuru bee chaa nipaji jarateede. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mãgá nidade chi k'õp'ãyoorã doce t'ɨ̃ p'eji mãik'aapa ome-omee pëiji netuara uchiapidamerã ichi t'ɨ̃de, ichi jõmaarã k'ãyaara waibɨara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jaraji ne-inaa ateenaadamerã; jĩp'a ateedamerã pak'uru t'ɨdɨk'adait'ee ode wãdak'ãri. Wãdaipia bɨ muchila wẽe, chik'o wẽe mãik'aapa p'arat'a wẽe. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ãchi chancla mãik'aapa p'aru jɨ̃daipia bɨ, mamĩda awaraa p'aru ateedaik'araa bɨ jɨ̃dait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mãpai mãgaji: —Parã teedaa wãdak'ãri, aɨ tede p'anéetɨ, mamãik'aapa wãruta misa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mamĩda eperãarãpa parã auteebaida-e pɨrã, ichiaba parãpa jarateeruta ũri k'iniada-e pɨrã, mamãik'aapa uchíatɨ. Uchiadak'ãri, bɨɨrɨdepema yooro p'ora nẽep'edapáde aji, ak'ɨpidait'ee Ak'õrepa mãga k'inia-e bɨ. Ãra k'achiara uchiadait'ee Sodoma pidaarã mãik'aapa Gomorra pidaarã k'ãyaara Tachi Ak'õre k'ĩrapite panadak'ãri, iru ewari waibɨa ewate. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mãpai chi k'õp'ãyoorã wãjida jarateede. Eperãarãpa ma jarateeda ũridak'ãri, ãchia p'ek'au k'achia oopata oo amaajida mãik'aapa Tachi Ak'õrede ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ichiaba netuara chok'ara uchiapipachida eperãarã k'ap'ɨadeepa mãik'aapa aceitepa p'urudak'ãri, k'ayaa beerã chok'ara jɨpapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Awaraarã ideepa Rey Herodepa ũriji Jesupa ooda, iru t'o p'anadap'edaa perã. Jarapachida: —Mãgɨ́ eperã Juan Bautistada apachida, chi piuda chok'ai p'irabaida. Mapa ne-inaa eperãarãpa p'oyaa oodak'aa oopari. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ũk'uruurãpa jarapachida: —Jãgɨ́ Elías, chonaarãwedapema Ak'õre pedee jarapari. Jõdee awaraarãpa jarapachida: —Ak'õre pedee jarateeparipɨ, chonaarãwedapema Ak'õre pedee jarapataarã jĩak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodepa eperãarãpa jaradap'edaa ũrik'ãri, maaji: —Mãgɨ́ Juanpɨ, mɨa otau t'ɨap'epit'aada; mãik'aapa ɨ̃rá chok'ai p'irabaida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aɨ naaweda Herodepa Juan cadenapa jɨ̃ atapiji mãik'aapa carcelde t'ɨpit'aaji chi ɨ̃pema Filipo wẽra Herodías k'aurepa. Herodepa ma wẽra ataji ichi ome beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanpa mãga k'awaa atak'ãri, mãgapachi Herodemaa: “Pɨa pɨchi ɨ̃pema wẽra iru baik'araa bɨ pɨchi wẽrak'a.” ");
INSERT INTO sjaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Maperã Herodiapa Juan k'ĩra unuamaa iru beeji mãik'aapa peepit'aa k'inia baji Herodemaa. Mamĩda p'oyaa oo-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodepa Juan waawee baji, irua Ak'õrepa oopi bɨk'a oopachi perã mãik'aapa Tachi Ak'õrepa iru pia ak'ɨ bapachi perã. Maperã Juan jɨ̃a paraa iru bapachi. Ma awara Juanpa jaratee bɨ ũri k'inia bapachi, k'awak'aa paji mĩda irua k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mamĩda Herodiapa k'ĩsia ataji Herodepa ichi t'oda fiesta ook'ãri. Ichi ek'ariirã poroorã, soldaorã poroorã, mãik'aapa eperãarã waibɨarã Galilea eujãdepemaarã pachejida ma nek'opari fiesta oode. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma fiesta oomaa p'anɨde Herodías k'au t'ĩuji nek'odap'edaamãi mãik'aapa pëiramaa beeji. Rey Herodepa mãik'aapa ichi ome p'anadap'edaarãpa ma pëira bada audú k'inia p'anajida. Mapa reypa mãgaji ma awẽramaa: —Mɨmaa iidíji, pɨchia iidi k'iniata. Mɨa teeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wãarapɨ; Tachi Ak'õre k'ĩrapite mɨa juraa bɨ, mɨa teeit'ee pɨchia iidiruta. Mɨa eujã ak'ɨ bɨ esajĩak'a teeit'ee, k'inia bɨ pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma awẽra taawaa uchiap'eda, iidinaji chi nawemaa: —¿K'ãata iidiyama? aji. Chi nawepa p'anauji: —Iidipáde aji, Juan Bautista poro. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma awẽra isapai waya t'ĩuji rey badamãi mãik'aapa maaji: —K'inia bɨda aji, ɨ̃raweda teemerã Juan Bautista poro p'arat'ude. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rey Herodes k'ĩra pia-ee beeji, Juan peepi k'inia-e bada perã. Mamĩda chi che p'anadap'edaarã k'ĩrapite juraada k'aurepa mera k'inia-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aramata pëiji soldao Juan poro aneemerã. Soldao wãp'eda carcelde, Juan otau t'ɨap'et'aaji ");
INSERT INTO sjaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mãik'aapa ma awẽra nawepa jaradak'a aneeji iru poro p'arat'ude. Ma awẽramaa tee cheji. Maap'eda ichia teenaji ichi nawemaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan k'õp'ãyoorãpa ũri atadak'ãri iru peedap'edaa, chi piuda k'ap'ɨa iidinajida ɨadait'ee. Mãga paji Juan Bautista peepidap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús k'õp'ãyoorã waya araa p'anadak'ãri iru ome, irumaa nepɨrɨjida jõma ãchia oodap'edaa mãik'aapa jarateedap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eperãarã chok'ara wãpachida mãik'aapa chepachida. Maperã chi k'õp'ãyoorã ome p'oyaa nek'odak'aa paji. Mapa Jesupa mãgaji ãchimaa: —K'õp'ãyoorã, chétɨ. T'ɨmɨ́ ɨ̃inadáma eperãarã wãdak'aamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mãpai barcode bataujida awara ãyaa wãdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mamĩda chok'araarãpa unujida ãra wã nidá mãik'aapa k'awaajida Jesús aɨde wã. Maperã eperãarã jõmaweda p'irajida, naapɨara nɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús barcodeepa batauk'ãri, eperãarã chok'ara unuji. Ãra chupɨria k'awaaji ovejaarãk'a para bada perã, ak'ɨpari wẽe. Mãpai Jesupa Ak'õre Ũraa jarateemaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","K'eupodopa chi k'õp'ãyoorã ik'aawa chejida mãik'aapa mãgajida: —K'eu wãpɨ; nama eperãarã p'anadak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pëipáde ajida, eperãarã wãdamerã te chaa mãik'aapa p'uuru bee chaa ne-inaa k'oparii netonadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mamĩda Jesupa p'anauji: —Parãpa chik'o téetɨ k'odamerã. Mãpai mãgajida: —¿Pɨa k'inia bɨk'ã taipa pan netonadamerã k'opidait'ee ãramaa? ¿K'ãare p'arat'apa netodayama ajida? ¿Atane ocho mimiada valorta pande netonadaik'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mãpai Jesupa iidiji: —¿Pan jõmasaa iru p'anɨma? aji. Ak'ɨnátɨ. K'awaadak'ãri, jara chejida: —Pan joisomaa mãik'aapa chik'o omé iru p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mãpai jaraji eperãarã su-ak'ɨ p'aneepidamerã awara-awaraa chok'ara, eujãde p'ũajara ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Su-ak'ɨ p'aneejida awara-awaraa cien mãik'aapa cincuenta. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mãpai Jesupa pan chik'o ome jitaji ichi juade, maap'eda ɨt'aa ak'ɨji. Ɨt'aa t'ɨ̃p'eda gracias jarait'ee Tachi Ak'õremaa, ma pan k'õrak'ooji. Mãga oop'eda, pan chok'ara teeji chi k'õp'ãyoorãpa eperãarãmaa jedenadamerã. Ichiaba chik'o jedejida jõmaarãmaa mãgɨ́ chik'o omé iru p'anadap'edaadepema. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jõmaweda nek'ojida bi jãwaa p'aneerutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jesús k'õp'ãyoorãpa k'oraa docena aba p'ejida pan pite mãik'aapa chik'o nɨ̃beeda. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chi mãgɨ́ pan k'odap'edaarã ɨmɨk'ĩraarã cinco mil paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma t'ẽepai Jesupa chi k'õp'ãyoorã barcode bataupiji ichi naa lago sĩadamerã Betsaida p'uurudee ichi eperãarã ome despediiru misa. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eperãarã erreuk'oodaidak'ãri, iru wãji ee nok'odee ɨt'aa t'ɨ̃de. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","K'eudaik'ãri, chi k'õp'ãyoorã barcode lago esa-auk'a ewaa wã nipajida. Mãɨmisa Jesús truwá bee baji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesupa unu baji chupɨria jõnɨ, ãchimaa nãu p'ua nɨ̃bada perã. Mãpai taujaaweda wãji ãramaa lago ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Barco k'ait'a wã nipak'ãri, unujida mãik'aapa k'ĩsiajida netuara. Mapa biajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jõmaweda audú p'eradachida. Mamĩda irua mãgaji: —¡P'eranáatɨ! ¡Mɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mãpai batauji ãra ome mãik'aapa nãu p'ua nɨ̃bada t'umãtɨdachi. Ak'ɨtrua para beeji ");
INSERT INTO sjaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ãra waide ijãada-e p'anadap'edaa perã Tachi Ak'õrepa ne-inaa mãgá chaaree bee oopipari Jesumaa. Mãgá p'anajida, unujida mĩda irua pan k'opida eperãarãmaa, pan wẽe p'anadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Panadak'ãri lago k'ĩraik'a eere, wiibainajida Genesaret eujãde. Mama barco jɨ̃ bɨjida to ide. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Barcodeepa bataurutade, eperãarã mama p'anapataarãpa Jesús k'awa atajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Isapai jõmaarãmaa jara wãjida. Mapa k'ayaa beerã chok'ara aneejida Jesús wãyaait'ee ũridap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iru wãrumaa p'uuru beede mãik'aapa p'uuru awara ãi te beede, ichiaba k'ayaa beerã ateepachida ãchi p'arude. Ata bɨpachida eperãarã ode wãyaapatamãi mãik'aapa Jesús wãyaa wãk'ãri, chupɨria iidipachida ichi p'aru ide pɨjida t'õbaipimerã. K'ayaa beerãpa t'õbaidak'ãri, jõmaweda jɨpa p'aneepachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moisepa p'ãda jarateepataarã Jerusalendeepa chejida Jesús badamaa fariseorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mãɨrãpa unudak'ãri Jesús k'õp'ãyoorã ũk'uru jua sɨɨda-ee nek'o p'anɨ, pedee k'achia jarapachida ãra ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseorãpa mãik'aapa awaraa judiorã pia bee k'inia p'anɨɨrãpa jua pi-ia sɨɨpata. Mãga jarateepachida chonaarãweda mãik'aapa at'ãri mãga oopata ãchi naawedapemaarãpa oopatap'edaak'a. Ãchi k'ĩsiade judiorã pia beerã nek'odaik'araa bɨ, mãgá ãchi jua sɨɨda-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne-inaa k'oparii netodap'eda p'uurude, nek'odak'aa pia sɨɨdai naaweda. Ichiaba oopata nãgee ne-inaa awaraa ãchi naawedapemaarãpa oopatap'edaak'a: nek'odai naaweda ne-inaa mesade sɨɨpata; vaso, k'uuru metaldee, chok'o mãik'aapa ãchi sĩu-ak'ɨ p'aneepatamãi.) ");
INSERT INTO sjaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mãga oopata perã iidijida k'ũradait'ee: —¿Sãap'eda pɨ ome nipapataarãpa ooda-e p'anɨma ajida, tachi chonaarãpa chonaarãweda oopatap'edaak'a? Ma k'ãyaara jua pia sɨɨda-e p'anɨ nek'odai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesupa p'anauji: —Chonaarãweda Ak'õre pedee jarapari Isaíapa parã ãpɨte wãara pedeeji. ¡Seewata Tachi Ak'õrede ijãapataarãda apata! Isaíapa mãgaji: ‘Na eperãarãpa mɨ k'inia iru p'anɨda apata it'aipa. Mamĩda ãchi t'ãripa wãara mɨ k'iniadak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Páripɨ mɨ k'ĩrapite ɨt'aa t'ɨ̃pata, oo k'inia p'anapata perã eperãarãpa jara p'anɨk'a, mɨa jara bɨk'a oodai k'ãyaara.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mãpai Jesupa mãgaji: —Parãpa audupɨara ijãapata eperãarãpa ãchi k'ĩsiadeepa jarateepata. Jõdee Ak'õre Ũraade p'ã jẽra bɨk'a oodait'ee k'ĩsiadak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ichiaba mãgaji: —Ak'õre Ũraa yiaraa iru p'anɨ. Jõdee chonaarãweda oopatap'edaak'a oo k'inia p'anapata. ¿Mãga-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chonaarãweda Tachi Ak'õrepa jaraji Moisés it'aideepa: ‘Pɨchi ak'õre mãik'aapa pɨchi nawe k'inia iru baparíiji mãik'aapa ãra pedee ũriparíiji.’ Ma awara jaraji: ‘Warrapa ik'achia jararu pɨrã ichi ak'õremaa wa ichi nawemaa, peet'aadaipia bɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mamĩda parãpa jarateepata eperãpa jarai chi ak'õremaa wa chi nawemaa: “Pɨ p'oyaa k'aripa-epɨ, jõma mɨa iru bɨ Corbán perã.” ");
INSERT INTO sjaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Eperãpa mãga jarak'ãri, pia bɨda apata chi ak'õreerã k'aripanaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mãgɨ́ ũraa uchiapari eperãarã k'ĩsiadeepa. Mãgɨde ijãadak'ãri, Tachi Ak'õre Ũraa yiaraa iru p'aneepata. Ichiaba awaraa ũraa jarateepata mãik'aapa ma k'aurepa eperãarãpa oodak'aa Tachi Ak'õre Ũraade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","T'ẽepai Jesupa eperãarã t'ɨ̃ p'e atap'eda, maaji: —Jõmaarãpa mɨ pedee ũrítɨ, mãik'aapa k'awáatɨ mɨa jararu. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chik'o k'odak'ãri, tachi k'ap'ɨade edú banapari. Ma chik'o k'odap'edaa k'aurepa tachi k'achia p'aneedak'aa Tachi Ak'õre k'ĩrapite. Ma k'ãyaara, ne-inaa eperã t'ãrideepa uchiarúpata k'achia beepipari. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pia k'ĩsiadapáde aji, mɨa jaradade. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesupa eperãarã atabëip'eda, t'ĩuji teedaa. Mama chi k'õp'ãyoorãpa iidijida: —¿K'ãata jara k'inia bɨma ajida, pɨa eperãarãmaa jarateeda? ");
INSERT INTO sjaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Irua jaraji: —¿Mãgara, parãpa ichiaba k'awada-e p'anɨk'ã? Chik'o k'odak'ãri, tachi k'achia beepik'aa Tachi Ak'õre k'ĩrapite, ");
INSERT INTO sjaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","t'ãride banak'aa perã. Jĩp'a bide banapari, maap'eda uchiapari. (Mãga jarak'ãri, Jesupa jara k'inia baji Tachi Ak'õrede ijãapataarãpa chik'o k'ĩra t'ãdoo k'odaipia bɨ.) ");
INSERT INTO sjaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ichiaba jaraji: —Mamĩda ne-inaa k'achia eperã t'ãrideepa uchiadapa tachi k'achia beepipari Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Eperã t'ãrideepa nãgee k'ĩsia k'achia uchiaparida aji: p'ek'au ooit'ee awaraarã ome; nechɨait'ee; chĩara peeit'ee; ");
INSERT INTO sjaNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","miak'ãi bɨ awaraarã ome k'ãiit'ee; chĩara net'aa k'ɨ̃ait'ee; chĩaramaa ne-inaa k'achia ooit'ee; chĩara k'ũrait'ee; ne-inaa k'achia ooi awaa bapariit'ee; chĩara k'ĩra unuamaa iru bapariit'ee irua ne-inaa iru bɨ k'aurepa; chĩara ãpɨte seewa jara nipait'ee; audua bapariit'ee mãik'aapa ne-inaa pariatua oopariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jõmaweda ma ne-inaa k'achia uchiapari eperã t'ãrideepa. Ma ne-inaa oodak'ãri, k'achia p'aneepata Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mamãik'aapa Jesús Tiro p'uuru k'ait'a wãji chi k'õp'ãyoorã ome. Wãji teedaa ichi unupi k'inia-e bada perã. Mamĩda p'oyaa miru-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Mãga nɨde wẽra k'au netuara merãtɨa bada nawepa ũriji Jesús mama bɨ. Ma wẽra judio-e paji; Sirofenicia eujãdepema paji. Teedaa wãp'eda, bedabai nɨ̃banaji Jesús k'ĩrapite mãik'aapa irumaa chupɨria iidiji: —Mɨ k'au k'ap'ɨade netuara merãtɨa bɨ. Chupɨria k'awáaji mãik'aapa uchiapit'aapáde aji, iru k'ap'ɨadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mamĩda Jesupa mãgaji: —Judiorãmaa ita-aria naa mɨmaa chupɨria iidipíji. Pia-e bɨda aji, warrarã chik'o jãri atait'ee mãik'aapa usaarãmaa tee baibɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wẽrapa p'anauji: —Mãgada aji, Tachi Waibɨa. Mamĩda usaarãpa paara k'opata warrarã juadeepa baaida mesa ek'ari. Mapa, mɨ judio-e mĩda, pɨmaa chupɨria iidi bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mãpai Jesupa maaji: —Pia p'anauji. Wãpáde aji, pɨ k'au k'ap'ɨadeepa netuara uchiada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma wẽra teedaa panak'ãri, chi k'au p'arude k'ãiwee ununaji. Netuara uchiadai baji chi k'au k'ap'ɨadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús uchiaji Tiro p'uuru k'ait'a bɨ eujãdeepa chi k'õp'ãyoorã ome. Wãyaaji Sidón p'uurude panait'ee Decápolis eujãde, Galilea Lago k'ait'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mama Jesumaa eperã ateejida. Ma eperã k'ɨɨrɨ k'ĩ baji mãik'aapa pedee atua baji. Chupɨria iidijida Jesumaa iru jua bɨmerã ma eperã ɨ̃rɨ, jɨpa beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesupa awara ãyaa ateeji see nɨ̃badamãiipa mãik'aapa ichi jua chak'epa t'ɨt'aaji ma eperã k'ɨɨrɨ chaa. Ichiaba idubapa t'õbait'aaji iru k'ĩrame. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maap'eda ɨt'aa ak'ɨji, golpe ĩyapaaji mãik'aapa mãgaji ma eperãmaa: —¡Efatá! (Jara k'inia bɨ: “¡K'ɨɨrɨ ẽesáaji!”) ");
INSERT INTO sjaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aramata pedee atua bada pia pedeeji mãik'aapa k'ɨɨrɨ ẽesaadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mãpai Jesupa jaraji apidaamaa jaranaadamerã. Mãga jarapachi mĩda, waapɨara jara wãpachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chi ũridap'edaarã o-ĩa ak'ɨtrua para beeji mãik'aapa pedee para beeji: —Jesupa jõma pia ooparipɨ. ¡K'ɨɨrɨ k'ĩ bɨ ũripipari mãik'aapa pedee atua bɨ paara pedeepipari! ");
INSERT INTO sjaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ewari aba eperãarã chok'ara waya see nɨ̃baji Jesús badamãi. Mamĩda nek'odait'ee wẽe p'anadap'edaa perã, chi k'õp'ãyoorã t'ɨ̃ p'eji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Mɨa na eperãarã chupɨria k'awaa bɨ, mɨ ome k'ãima õpee p'anadairã mãik'aapa ɨ̃rá ãchi nek'odait'ee wẽe p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mãgá pëiru pɨrã ãchi te chaa, ode k'ap'ɨa t'ũmaak'oodaridait'ee jarrapa, ũk'uru t'ɨmɨɨpa che p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chi k'õp'ãyoorãpa iidijida: —Mamĩda ¿sãga nek'opidayama ajida, nama eperãarã wẽ-e perã chik'o netodait'ee taimaa? ");
INSERT INTO sjaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Pan jõmasaa iru p'anɨma? aji. Maajida: —Siete. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eperãarã su-ak'ɨ beepiji mãik'aapa ma pan atap'eda, ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa. K'õrak'oop'eda teeji chi k'õp'ãyoorãpa eperãarãmaa jedenadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ichiaba chik'o chak'eerã chok'ara-ee iru p'anajida. Jesupa ɨt'aa iidik'ãri, chok'araara eepadachi mãik'aapa jedepiji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jõmaarãpa k'ojida bi jãwaadarutamaa. K'oraa siete ipuru p'ejida pan chik'o ome beeda. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chi nek'odap'edaarã perá cuatro mil paji. Maap'eda Jesupa ãchi temaa pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mãpai Jesús chi k'õp'ãyoorã ome barcode bataup'eda, wãji Dalmanuta eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mama bɨde fariseorã pachejida mãik'aapa aupedeemaa p'aneejida Jesús ome. Ɨmɨatee k'inia p'anadap'edaa perã, iidijida ne-inaa oomerã Tachi Ak'õrepapai oopari, mãik'aapa ak'ɨpimerã wãara Tachi Ak'õrepa iru pëida. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús golpe ĩyapaaji mãik'aapa mãgaji: —¿K'asaa parã pedeeta? ¿Awaraa ne-inaa unu k'inia p'anɨk'ã Tachi Ak'õre juapa ooda? Mɨa wãarata jararu. Mɨa oo-e pait'ee parãpa iidi p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Maap'eda mama atabëiji. Barcode bataup'eda, uchiaji lago k'ĩraik'a eere chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma wã nidade chi k'õp'ãyoorãpa k'ĩra atuadai p'anajida ateedait'ee ne-inaa k'oparii. Pan apai iru p'anajida barcode. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesupa ãra ũraaji: —K'ĩra k'awaa nipapatáatɨ fariseorã pan, Herodes pan k'onaadamerã, ãchi levadura k'achia bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesús k'õp'ãyoorã pedee para baji ãchi pitapai, irua jara k'inia bada k'awada-e p'anadap'edaa perã. Maajida: —Mãga jara bɨ, tachi pan wẽe p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesupa k'awaji ãrapa k'ĩsiadap'edaa. Mapa mãgaji: —¿Sãap'eda pan wẽe p'anɨda a p'anɨma? aji. ¿At'ãri k'awada-e p'anɨk'ã mɨa jaratee k'inia bɨ? ¿Pandepai k'ĩsia p'anɨ-ek'ã? aji. Mapa k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Parã tau iru p'anɨ mĩda, unudak'aa mɨa oo bɨ. K'ɨɨrɨ iru p'anɨ mĩda, mɨa jaratee bɨ ũridak'aa. ¿Maarepidata k'irãpada-ek'ã? ");
INSERT INTO sjaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mɨa pan joisomaa jedek'ãri ɨmɨk'ĩraarã cinco milmaa, ¿chi pite beedapa k'oraa jõmasaa ipurujidama? aji. P'anaujida: —K'oraa docena aba. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ichiaba pan siete jededak'ãri ɨmɨk'ĩraarã cuatro milmaa, nek'odap'eda, ¿k'oraa jõmasaa ipurujidama? aji. Maajida: —K'oraa siete. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mãpai maaji: —¿Parãpa at'ãri k'awada-ek'ã? aji. K'ĩra k'aupai ijãadai fariseorã pedee mãik'aapa Herodes pedee. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida p'uurude panadak'ãri, tau p'ãriu bɨ ateejida Jesumaa chupɨria iidide irua t'õbaimerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesupa ma tau p'ãriu bɨ juade jitap'eda, p'uuru k'idaa ateeji. Mãpai ma eperã tau jãde idut'aaji mãik'aapa ichi tau wãk'a atap'eda juapa, Jesupa maaji: —¿Ɨ̃rá pia unuruk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ak'ɨp'eda, maaji: —Unu bɨpɨ eperãarã pak'uruk'a nĩutee. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesupa jua waya tau ɨ̃rɨ bɨji mãik'aapa ãyaa atak'ãri, ma eperãpa pia unu beeji. Mãgá jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mãpai Jesupa ichi temaa pëiji mãik'aapa maaji: —P'uurudee wãnaapáde aji, mãik'aapa p'uuru pidaarãmaa maarepida jaranaapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma t'ẽepai, Jesús chi k'õp'ãyoorã ome wãji p'uuru k'aipee beedee, Cesarea de Filipo p'uuru k'ait'a bɨ eujãde. Ode wãdade, Jesupa iidiji chi k'õp'ãyoorãmaa: —¿Mɨ k'aima a p'anɨma aji, eperãarãpa? ");
INSERT INTO sjaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","P'anaujida: —Ũk'uruurãpa jara p'anɨ pɨ Juan Bautista, piup'eda p'irabaida. Awaraarãpa jara p'anɨ Elías. Ichiaba ũk'uruurãpa jara p'anɨ pɨ awaraa Ak'õre pedee jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Parãpárama, ¿mɨ k'aima adaima? aji. Pedropa p'anauji: —Pɨ Cristo; Tachi Ak'õrepa pëida tachi k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mamĩda Jesupa jaraji: —Awaraarãmaa mãga nepɨrɨnaadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesupa jarateemaa beeji: —Mɨde ijãadak'aa p'anadairã, tachi judiorã poro waibɨarãpa, p'aareerã poroorãpa, mãik'aapa Moisepa p'ãda jarateepataarãpa mɨ miapidait'ee mãik'aapa yiaraa iru p'anadait'ee. Maap'eda mɨ, chi Eperã Ak'õre Truadepema, peepit'aadait'ee. Mamĩda ewari õpeemaa mɨ chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mãgɨ́ pedee jaraji jõmaarã k'ĩrapite. Mãpai Pedropa Jesús awara ãyaa ateeji mãik'aapa ɨtrɨamaa beeji, mãgá pedee bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mamĩda Jesús p'ɨrrabaiji mãik'aapa chi k'õp'ãyoorã k'ĩra ak'ɨp'eda, mãgaji Pedromaa: —¡Mɨ ik'aawaapa ãyaa wã́ji, Satanapa mãga jarapida perã! Pɨa k'ĩsia-e Ak'õrepa k'ĩsia bɨk'a. Jĩp'a k'ĩsiamaa bɨda aji, eperãarãpa k'ĩsiapatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mãga bap'eda, Jesupa chi k'õp'ãyoorã t'ɨ̃ p'e ataji awaraarã ome mãik'aapa maaji: —Eperã mɨ ome nipa k'inia bɨ pɨrã, k'ĩsiaik'araa bɨ ichia ne-inaa oo k'inia bɨdepai. Ichi kuruso ãp'aipia bɨ eperã peenadait'eek'a. Ooipia bɨ mɨa ooparik'a, ma k'aurepa miapiruta pɨjida piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Eperã piuamaa bɨ pɨrã mɨde ijãapari k'aurepa, mãgɨ́ piuk'ãri atuait'ee. Mamĩda eperã piuru pɨrã mɨde ijãapari k'aurepa, mãgɨ́ ɨt'aa wãit'ee ichi piuk'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma awara ¿k'ãare piata baima eperãpa ne-inaa pia na p'ek'au eujãde nɨ̃bɨ jõmaweda ataru pɨrã, mamĩda piup'eda chok'ai p'irabai-e pɨrã Ak'õre eujãde? ");
INSERT INTO sjaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ichiaba, ¿k'ãata teeima Tachi Ak'õremaa, tachi piudap'eda chok'ai p'irabaipimerã? Mãga p'oyaa ooda-e. ");
INSERT INTO sjaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨ̃rapema eperãarã audú p'ek'au oo k'inia p'anapata mɨde ijãadak'aa perã. Mãɨrã taide eperã k'ĩra nejasia bɨ pɨrã jarait'ee mɨde ijãa bɨ maa-e pɨrã mɨ ũraa jarait'ee awaraarãmaa, mãgara mɨ, chi Eperã Ak'õre Truadepema jida k'ĩra nejasia bait'ee mëreda ait'ee, mɨ Ak'õre Waibɨa k'ĩra wãreede chek'ãri iru angeleerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesupa ichiaba mãgaji: —Mɨa wãarata jararu. Nama p'anɨɨrã ũk'uru piudai naaweda unudait'ee Tachi Ak'õrepa eperãarã bɨru ichi jua ek'ari ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","K'ãima seismaa Jesús wãji ee ɨt'ɨa bɨ nok'ode. Ichi ome ateeji Pedro, Santiago mãik'aapa Juan. Mama ãra taide Jesús k'ĩra awaradachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ichi p'aru t'o-t'oo ɨ̃daadachi pi-ia t'õdak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mãga nɨde chi k'õp'ãyoorãpa unujida chonaarãweda p'anapatap'edaarã Elías mãik'aapa Moisés pedeemaa p'anɨ Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mãpai Pedropa mãgaji Jesumaa: —Tachi Jarateepari, ¡pia bɨ nama p'anadait'ee pɨ ome! Oodait'ee te chak'eerã õpee; aba pɨ-it'ee, aba Moise-it'ee, chi apema Elia-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedropa k'ĩsia-ee mãga jaraji, p'era ak'ɨ nɨ̃bada perã apemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mãga nɨde jɨ̃ararapa ãra aneu cheji. Madeepa Tachi Ak'õrepa pedeeji: —Nãgɨda aji, mɨ Warra k'inia. Ũrítɨ iru pedee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aramata ak'ɨdak'ãri, ãchi ik'aawa apida unuda-e paji; Jesús aupaita ãchi ome baji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eedeepa cherutade Jesupa jaraji ãchia unudap'edaa nepɨrɨnaadamerã, ichi jai-idaap'eda waya chok'ai p'irabai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Maperã nepɨrɨda-e paji ãchia unudap'edaa. Mamĩda ãchi pitapai pedee p'anapachida k'asaa jara k'inia bɨ “jai-idaap'eda waya chok'ai p'irabaiit'ee”. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Maap'eda Jesumaa iidijida: —¿Sãap'eda Moisepa p'ãda jarateepataarãpa jarapatama ajida, chonaarãwedapema Elías naapɨara cheit'ee Tachi K'aripapari k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Irua p'anauji: —Wãarata jara p'anɨ. Elías naapɨara cheit'ee mãik'aapa ne-inaa jõmaweda pia ooit'ee, eperãarãpa auteebaidamerã iru t'ẽe cheru. Mamĩda mɨa jara bɨ: Ak'õre Ũraa p'ãdade ichiaba jara bɨ mɨ, chi Eperã Ak'õre Truadepema, miapidait'ee mãik'aapa k'ĩra unuamaa iru p'anadait'ee. Tachi Ak'õre Ũraa p'ãdade p'ã jẽra bɨk'a ichia oopiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mamĩda eperã Elías jĩak'aa chejipɨ. Mãgɨ́ t'ɨ̃jarapachida Juan Bautista. Ãchia oo k'iniata oojida iru ome Ak'õre Ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús, Pedro, Santiago mãik'aapa Juan pachedak'ãri apemaarã k'õp'ãyoorã p'anadap'edaamãi, unu chejida eperãarã chok'araarãpa wap'ɨra iru p'anɨ mãik'aapa Moisepa p'ãda jarateepataarã ũk'uru aupedee jõnɨ ma k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús unudak'ãri, ak'ɨtrua para beeji mãik'aapa p'ira wãjida irumaa auteebaide. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mãpai Jesupa iidiji ãchimaa: —¿K'ãaredeta aupedee p'anɨma mɨ k'õp'ãyoorã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eperãpa p'anauji: —Tachi Jarateepari, mɨ warra aneeji pɨmaa netuarapa ichiwa iru bairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma netuarapa wawat'ɨ bat'at'aapari eujãde. Maap'eda it'aidee k'õp'ep'ee che nɨ̃beepari, k'ida kierrkierree nɨ̃beepari, ichiaba k'ap'ɨa ɨbɨa nɨ̃beepari. Mɨa chupɨria iidiji pɨ k'õp'ãyoorãmaa ma netuara uchiapit'aadamerã. Mamĩda p'oyaada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mãpai Jesupa mãgaji arii p'anadap'edaarãmaa: —Aai, eperãarã, ¿at'ãrita mɨde ijãada-e p'anɨk'ã? ¡Ijãadak'aarã́k'apɨ p'anɨ! ¿Jõmasaa taarãit'ee parã ome ijãarutamaa? Anéetɨ ma warra. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mãpai aneejida Jesumaa. Mamĩda netuarapa Jesús unuk'ãri, warra wawat'aaji mãik'aapa bat'at'aaji eujãde. It'aideepa k'õp'ep'ee eujãde pɨrabai nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesupa iidiji ma warra ak'õremaa: —¿Sãaweda mãgá nɨ̃bɨma? aji. Chi ak'õrepa p'anauji: —Ma-ãri weda. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","At'apai netuarapa bat'at'aapari t'ɨpɨtau urua nɨ̃bɨde maa-e pɨrã toida peet'aait'ee. Mapa p'oyaa ooita bɨ pɨrã, tai chupɨria k'awáaji mãik'aapa k'aripapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesupa p'anauji: —¿K'asaa pɨ pedee? ¿P'oyaa ooik'ã a bɨk'ã? ¡Eperãpa mɨde ijãa bɨ pɨrã, mɨa ne-inaa jõma oopari! ");
INSERT INTO sjaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mãpai chi warra ak'õrepa golpe pedeeji: —Ijãa bɨda aji. ¡Mɨ k'aripáji waapɨara ijãait'ee! ");
INSERT INTO sjaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesupa unuk'ãri eperãarã seedaruta, mãgaji netuaramaa: —Netuara, ichiwapipari mãik'aapa k'ɨɨrɨ k'ĩpipari, uchíaji jã warra k'ap'ɨadeepa mãik'aapa waa iru k'ap'ɨade t'ĩunaapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mãpai netuara biadachi mãik'aapa warra golpe wawat'aaji. Maap'eda uchiadachi warra k'ap'ɨadeepa. Ma warra piudak'a atabaibeeji. Mãpai arii see nɨ̃badaarãpa mãgajida: —Piudachida, ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mamĩda Jesupa juade jita atap'eda, p'irabai ataji. Mãpai ma warra k'ap'ɨa pia beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Maap'eda Jesús wãji teedaa chi k'õp'ãyoorã ome. Ituaba bak'ãri, chi k'õp'ãyoorãpa iidijida Jesumaa: —¿Sãap'eda taipa ma netuara p'oyaa uchiapida-e pajima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesupa p'anauji: —Ɨt'aa t'ɨ̃ bɨpapai mãgee netuara uchiapiparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mamãik'aapa wãdak'ãri, Galilea eujãde wãyaajida. Mamĩda eperãarãmaa k'awapi k'inia-e bada perã, ");
INSERT INTO sjaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesupa ne-inaa oo-e paji mama, chi k'õp'ãyoorãmaa jarateemaa bada perã. Mãgapachi: —Eperãpa mɨ, chi Eperã Ak'õre Truadepema, baaipiit'ee k'achia beerã juade mãik'aapa ãchia mɨ peepit'aadait'ee. Mamĩda ewari õpeemaa mɨ waya chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chi k'õp'ãyoorãpa k'awada-e paji sãap'eda irua mãga jaraji. Mamĩda waawee p'anajida iididait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pachejida Capernaum p'uurude. Teeda p'anɨde, Jesupa iidiji: —¿Parã k'ãata pedee che wãjidama aji, ode? ");
INSERT INTO sjaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mamĩda k'ĩra nejasiapa k'ĩup'ee para beeji, ode aupedee che wãdap'edaa perã, ãchidepema k'aita waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús su-ak'ɨ beeji mãik'aapa chi k'õp'ãyoorã doce t'ɨ̃ p'e atap'eda, maaji: —Eperã apemaarã k'ãyaara waibɨara pa k'inia bɨ pɨrã, ek'ariara baipia bɨ mãik'aapa t'ãri o-ĩa apemaarã k'aripaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mãpai Jesupa warra chai jua jita atap'eda, ak'ɨ nɨ̃bɨji ãchi esajĩak'a. Jira atap'eda, wëre ataji jarateeit'ee mãik'aapa jaraji: ");
INSERT INTO sjaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Eperãpa mɨde ijãa bɨ k'aurepa nãgɨ́ warra chaik'a auteebairu pɨrã, mɨ jida auk'a auteebaipari. Ma awara mɨ aupai auteebai-e; ichiaba Tachi Ak'õre auteebai bɨ, iruata mɨ pëida perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mãpai Juanpa maaji: —Tachi Jarateepari, taipa unujida eperãpa pɨ t'ɨ̃ jarap'eda, netuara uchiapi bɨ eperãarã k'ap'ɨadeepa. Mãga unudak'ãri, taipa waa oonaapáde ajida, tachi ome nipak'aa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesupa p'anauji: —Ichiak'au oopítɨ. Eperãpa ne-inaa pia ooru pɨrã mɨ t'ɨ̃de eperãarãpa p'oyaa oodak'aa, mãga oop'eda, pedee k'achia jara-e pai mɨ ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tachi ome nipak'aa pɨjida, tachi eere bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mɨa wãarata jararu. Eperãpa parãmaa pania vaso aba pida teeru pɨrã todamerã, parãpa mɨ, Cristode ijãapata perã, Tachi Ak'õrepa ma eperãmaa ne-inaa pi-ia teeit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Mamĩda eperãpa mɨde ewaa ijãa p'anɨɨrãmaa acha bɨ warra chaik'a, ijãapiamaa bɨ pɨrã, piara bak'aji k'ũruma iru otaude jɨ̃ atadap'eda, p'usa jãde bat'at'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Pɨchi juapa ne-inaa ooda k'aurepa pɨ k'achiade baairu pɨrã, ma k'achia oo amáaji, pɨchi jua t'ɨap'et'aak'ajik'a. Piara bɨ ɨt'aa wãit'ee jua mosaa, k'ap'ɨa jõmaweda atuai k'ãyaara t'ɨpɨtau ichita jẽrajẽraa jira bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ichiaba pɨchi bɨɨrɨpa ne-inaa ooda k'aurepa k'achiade baairu pɨrã, ma k'achia oo amáaji, pɨchi bɨɨrɨ t'ɨap'et'aak'ajik'a. Piara bɨ Ak'õre ode nɨk'anɨk'aa nipait'ee bɨɨrɨ abapai bɨk'a, k'ap'ɨa pia tok'arradee bat'a atapëi k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ichiaba pɨchi taupa ne-inaa unuda k'aurepa pɨ k'achiade baairu pɨrã, ma k'achia oo amáaji pɨchi tau ẽt'ak'ajik'a. Piara bɨ Tachi Ak'õre ode nipait'ee tau abapai bɨk'a, tau omeeweda nipai k'ãyaara netuara ode tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Mama ichita miapiit'ee tachi chiara k'opari k'ipa piuk'aa mãik'aapa tachi k'ap'ɨa paapari t'ɨpɨtau k'ĩik'aa bɨde.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—T'ã p'urupata chik'ode mik'iapiamaapa. Auk'a Tachi Ak'õrepa ichideerã pia ak'ɨ bapari atuapiamaapa netuara o k'achiade. ");
INSERT INTO sjaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ma awara chik'o warraara bɨ t'ã ome. Mamĩda t'ã k'ɨyaa-edaik'ãri, ma chik'o warraa-ee bɨ. ¿Sãga ma t'ã waya k'ɨyaapiima? Ichiaba tachi t'ãri pia p'anada-e pak'ãri, Tachi Ak'õre k'ĩrapite servi-e p'anɨ. Mapa óotɨ Ak'õre Ũraade jara bɨk'a. Mãgá k'ãiwee p'anadait'ee apemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús uchiap'eda chi k'õp'ãyoorã ome Capernaumdeepa, wãjida Jordán to k'ĩraik'a eeree, Judea eujãde panarutamaa. Mama p'anɨde waya Jesús badamãi eperãarã cheepurupachida, eperãarãpa oopatap'edaak'a iru wãrumaa. Waya Jesupa jarateemaa beeji naaweda oopatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mãga nɨde fariseorã ũk'uru irumaa chejida. Moisepa p'ãda merapii jĩak'aapa, iidijida: —¿Ɨmɨk'ĩrapa ichi wẽra amaaipia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Irua p'anauji: —¿K'ãata ũraaji Moisepa? ");
INSERT INTO sjaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jarajida: —Moisepa ũraajida ajida, wẽra amaaru pɨrã, mia amaada k'art'a p'ã teeipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mãpai Jesupa maaji: —Moisepa mãga jaraji parã judiorã k'ɨɨrɨ k'isua p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mamĩda Tachi Ak'õrepa na eujã ook'ãri, ‘Ooji ɨmɨk'ĩra mãik'aapa wẽra.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mapa ɨmɨk'ĩrapa atabëiit'ee chi ak'õre chi nawe ome, araa p'anapataadait'ee chi wẽra ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mãgá eperã omee weda eperã apai pɨk'a p'aneedait'ee.’ Eperã omé p'anɨ mĩda, jĩp'a eperã apai pɨk'a p'aneepata Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tachi Ak'õrepa mãgá eperãarã omé araa papik'ãri, apidaapa amaapidaik'araa bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aɨ t'ẽepai teeda p'anadak'ãri, Jesús ome nipapataarãpa pedee p'aneejida fariseorãpa iididap'edaade. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesupa jaraji: —Eperãpa chi wẽra amaat'aaru pɨrã, awaraa wẽra ataik'araa bɨ. Mãga ooru pɨrã, p'ek'au oomaa bɨ Tachi Ak'õre k'ĩrapite mãik'aapa chi wẽra k'ĩrapite, Tachi Ak'õre Ũraa p'ãdade jara bairã wẽra iru bak'ãri, awaraa ome k'ãik'araa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ichiaba wẽrapa chi ɨmɨk'ĩra amaat'aaru pɨrã, awaraa ɨmɨk'ĩra ataik'araa bɨ. Mãga ooru pɨrã, auk'a p'ek'au oomaa bɨ Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Warrarã aneejida Jesumaa iru jua bɨmerã ãra ɨ̃rɨ. Mamĩda Jesús k'õp'ãyoorãpa ma warrarã aneedap'edaarã ɨtrɨajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesupa mãga unuk'ãri, t'ãri ãriidachi chi k'õp'ãyoorã ome. Mãpai mãgaji: —¡Ɨtrɨanáatɨ! Ichiak'au mɨmaa warrarã chepítɨ, Tachi Ak'õrepa ãra jĩak'aarã bɨit'ee perã ichi jua ek'ari ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mɨa wãarata jararu. Warra chak'eerãpa waawee-ee ijãapata t'ãri o-ĩa Tachi Ak'õrede. Auk'a tachi chonaarãpa pida ijãadaipia bɨ p'aneedait'ee Tachi Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Warra chak'eerã jira atap'eda, ichi jua ãra ɨ̃rɨ bɨ wãpachi mãik'aapa bendicia wãpachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús wãit'ee arude, eperã p'ira chep'eda, iru k'ĩrapite bedabaidachi mãik'aapa mãgaji: —Tachi Jarateepari t'ãri pia, ¿k'ãata mɨa ooipia bɨma aji, ɨt'aa wãit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesupa p'anauji: —¿Sãap'eda mɨmaa t'ãri pia bɨda a bɨma? aji. T'ãri pia apaita bɨ; mãgɨ́ Tachi Ak'õre. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pɨa k'awa bɨ Tachi Ak'õrepa Moisemaa ũraa p'ãpida: ‘Eperã peenáaji; miak'ãi bɨ pɨrã, awaraarã ome k'ãináaji; nechɨanáaji; seewa jaranáaji chĩara k'achiade baaipiit'ee; ichiaba chĩara k'ũranáaji; pɨchi ak'õre mãik'aapa pɨchi nawe k'inia iru baparíiji mãik'aapa ãra pedee ũriparíiji.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mãpai ma eperãpa maaji: —Tachi Jarateepari, mɨa ma jõma ooparida aji, k'ũtrãa weda. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesupa irumaa k'inia ak'ɨji mãik'aapa mãgaji: —Ne-inaa aba waide oo-e bɨ. Pɨchi net'aa jõmaweda netok'oonáji mãik'aapa chupɨria beerãmaa ma p'arat'a téeji. Mãga ooru pɨrã, ne-inaa pipɨara iru bait'ee Tachi Ak'õre eujãde. Mãga oop'eda, mɨ ome nipa chéji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma eperãpa mãga ũrik'ãri, k'ĩsia paraadachi mãik'aapa k'ĩra pia-ee wãji, p'arat'a audú k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesupa ichi ik'aawa p'anadap'edaarãmaa ak'ɨp'eda, mãgaji chi k'õp'ãyoorãmaa: —¡Chaaree bait'ee p'arat'ara beerã p'aneedait'ee Tachi Ak'õre jua ek'ari ichideerã ome! ");
INSERT INTO sjaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús k'õp'ãyoorã ak'ɨtrua para beeji mãga ũridak'ãri. Mãpai waya Jesupa maaji: —Aai, warrarã, ¡chaaree bɨ p'arat'ara bɨ beeit'ee Tachi Ak'õre jua ek'ari ichideerã ome! ");
INSERT INTO sjaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chaareera bɨda aji, p'arat'ara bɨ beeit'ee Tachi Ak'õre jua ek'ari, camello aguja taude wãyaai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chi k'õp'ãyoorãpa mãga ũridak'ãri, waapɨara p'era pɨk'a para beeji mãik'aapa ãchi pitapai iidi para beeji: —Mãgara, ¿k'aita p'oyaa ɨt'aa wãyama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesupa ãchimaa ak'ɨji mãik'aapa p'anauji: —Eperãarãpa p'oyaa ooda-e, audú chaaree bairã. Mamĩda Tachi Ak'õre-it'ee ne-inaa chaaree wẽ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mãpai Pedropa mãgaji: —Tai net'aa jõmaweda atabëijida pɨ ome nipapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesupa maaji: —Mɨa wãarata jararu. Parãpa atabëijida pãchi te, ɨ̃pema, ɨ̃pewẽra, nawe, ak'õre, warrarã mãik'aapa eujã, mɨ k'aurepa mãik'aapa mɨa pedee pia jaratee bɨ k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Mamĩda net'aa atabëidap'edaarãpa ma k'ãyaara na p'ek'au eujãde p'anɨ misa, na ne-inaa atada cien audú atadait'ee: te, ɨ̃pemaarã, ɨ̃pewẽraarã, naweerã, warrarã mãik'aapa eujã, chĩarapa ãra miapi iru p'anɨ jida mɨ k'aurepa. Ma awara piuk'ãri, ichita chok'ai bapariit'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mamĩda ɨ̃rapema waibɨara p'anɨɨrã eperãarã k'ĩrapite, ek'ariara p'anadait'ee Tachi Ak'õre k'ĩrapite. Jõdee ek'ariara p'anɨɨrã eperãarã k'ĩrapite waibɨara p'anadait'ee Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aɨ t'ẽepai Jesús apemaarã naa wãji Jerusalendee. Chi k'õp'ãyoorã p'era pɨk'a iru t'ẽe wãjida. Awaraarã ichiaba iru t'ẽe waaweede wãjida. Mãpai Jesupa waya chi k'õp'ãyoorã doce awara ãi t'ɨ̃ p'e ataji mãik'aapa nepɨrɨji ichi p'asait'ee bɨ: ");
INSERT INTO sjaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Tachi wãruta Jerusalendee. Mama mɨ, chi Eperã Ak'õre Truadepema, jita atadait'ee mãik'aapa ateedait'ee p'aareerã poroorãmaa mãik'aapa Moisepa p'ãda jarateepataarãmaa. Ãchia iididait'ee k'ĩra tewaraarãmaa mɨ peet'aadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mɨ oo iru p'anadait'ee; k'ĩramaa idudait'ee; soopa wɨdait'ee mãik'aapa peet'aadait'ee. Mamĩda ewari õpeemaa mɨ waya chok'ai p'irabaiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo warrarã, Santiago mãik'aapa Juan, Jesús k'ait'a chejida mãik'aapa mãgajida: —Tachi Jarateepari, taipa ne-inaa audú k'inia p'anɨ. Mapa chupɨria iidi p'anɨ mãga oomerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Irua iidiji: —¿K'ãata k'inia p'anɨma aji, mɨa oomerã parã ome? ");
INSERT INTO sjaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mãgajida: —Pɨ truade jõmaarã poro waibɨa pak'ãri, tai auk'a poro waibɨarã pɨ ek'ari p'anee k'inia p'anɨ; aba su-ak'ɨ beei pɨ juaraare, apema pɨ juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mãpai Jesupa p'anauji: —Parãpa wãara k'awada-e p'anɨ k'ãata iidi p'anɨ. ¿Parãpa ne-inaa k'achia choodaik'ã aji, mɨa chooit'ee bɨk'a? Maap'eda ¿parã piu k'iniadaik'ã aji, mɨ piut'ee bɨk'a? ");
INSERT INTO sjaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ãchia p'anaujida: —¡P'oyaadaipɨ! Jesupa maaji: —Parãpa ne-inaa k'achia choodait'eeda aji, mɨa chooit'ee bɨk'a. Ma awara piudait'ee mɨ piut'ee bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mamĩda mɨa p'oyaa jara-e k'airãta mɨ juaraare wa juabi eere su-ak'ɨ p'aneedait'ee. Tachi Ak'õrepapai mãga jarai. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Apemaarã diez k'õp'ãyoorãpa ũridak'ãri Santiago Juan ome iididap'edaa, k'ĩraudachida ãchi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mapa Jesupa t'ɨ̃ p'e ataji mãik'aapa maaji: —Parãpa k'awa p'anɨ ijãadak'aa beerã poro waibɨarãpa ãchia oo k'iniata oopipata eperãarãmaa. Waaweepa ãchi jua ek'ari p'anɨɨrãpa oopata ãchia jara p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mamĩda parãpa oodaik'araa bɨ ma poro waibɨarãpa oopatak'a. Ma k'ãyaara ijãapataarã t'ãide chi waibɨara pa k'inia bɨpa apemaarã chupɨria k'awaaipia bɨ mãik'aapa k'aripaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pia jarait'eera, parãdepema aba poro waibɨa pa k'inia bɨ pɨrã, awaraarã k'aripaipia bɨ, esclavopa chipari k'aripaparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mɨ, chi Eperã Ak'õre Truadepema mĩda, na p'ek'au eujãde che-e paji eperãarãpa mɨ jĩia ɨadamerã. Jĩp'a cheji eperãarã o k'achiadeepa k'aripa atait'ee. Piut'ee eperãarã chok'ara uchiadamerã p'ek'au k'achia jua ek'ariipa. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús wãyaa wãk'ãri Jericó p'uurude chi k'õp'ãyoorã ome, eperãarã chok'ara auk'a chejida ãra ome. Ma p'uurudeepa uchia wãdade, o bi ik'aawa eperã tau p'ãriu bɨ su-ak'ɨ baji p'arat'a iidimaa. Ma eperã t'ɨ̃jarapachida Bartimeo. Mãgɨ́ Timeo warra paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ũrik'ãri Jesús Nazaretdepema ichi ik'aawa wãyaa wã, ma tau p'ãriu bɨpa golpe biamaa beeji: —¡Jesús! ¡Rey David Warra, mɨ chupɨria k'awáaji! ");
INSERT INTO sjaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma ode p'anadap'edaarãpa ɨtrɨat'aapachida k'ĩup'ee beemerã. Mamĩda waapɨara biapachi: —¡Rey David Warra, mɨ chupɨria k'awáaji! ");
INSERT INTO sjaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mãpai Jesús ak'ɨnɨ̃ beeji mãik'aapa mãgaji: —T'ɨ̃ atanátɨ. Mãpai t'ɨ̃ atanajida tau p'ãriu bɨ: —Isapai, p'irabáiji. Pɨ t'ɨ̃ bɨpɨ. ¡Waaweenáaji! ");
INSERT INTO sjaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mãpai chi poroba ãyaa bat'at'aap'eda, p'inajɨ̃tɨ bainɨ̃ beeji mãik'aapa Jesumaa cheji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mãpai Jesupa iidiji: —¿K'ãata k'inia bɨma aji, mɨa oomerã pɨ ome? Tau p'ãriu bɨpa p'anauji: —Jesús, Tachi Waibɨa, mɨchi taupa pia unu k'inia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesupa mãgaji: —Jɨpajipɨ mɨde ijãada perã. Wãipia bɨda aji. Aweda tau p'ãriu badapa pia unuji mãik'aapa Jesús t'ẽe wãji ode. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús Jerusalén p'uuru k'ait'a wãk'ãri, Olivo Ee k'ĩrapite panaji chi k'õp'ãyoorã ome. Mama p'anɨ Betfagé mãik'aapa Betania p'uuru. Jesupa chi k'õp'ãyoorã omé naa pëik'ãri, mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Wã́tɨ ara bɨ p'uuru tachi k'ĩrapite bɨmaa. Ará panadak'ãri, ununadait'ee burro jɨ̃ bainɨ̃ bɨ, waide apida batauda-e p'anɨ iru ɨ̃rɨ. Ẽra atátɨ mãik'aapa anéetɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Apidaapa iidiruta pɨrã, k'ãare-it'ee ẽramaa p'anɨ, jarátɨ: “Tachi Waibɨapa arak'atɨa atee k'inia bɨ. Waya tee chedait'eepɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chi k'õp'ãyoorã wãdak'ãri, ununajida burro jɨ̃ bainɨ̃ bɨ o bi ik'aawa te ãuk'idaa. Mãpai ẽra atajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mamĩda arii p'anadap'edaarãpa iidijida: —¿K'ãata oomaa p'anɨma parãpa? ¿K'ãare-it'ee ẽra ataruta jã burro? ");
INSERT INTO sjaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mãpai Jesupa jaradak'a p'anaudak'ãri, ichiak'au pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Burro ateedap'eda Jesumaa, ãchi ɨ̃rɨpema p'aru jɨ̃patap'edaa ata bɨjida aɨ ɨ̃rɨ mãik'aapa Jesús batauji. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesús mãgá wãyaa wãk'ãri, chok'araarãpa ãchi p'aru t'õ jẽra bɨjida o jãde Jesús k'ĩrapite; ichiaba ũk'uruurãpa t'õ jẽra bɨjida k'iru t'ɨap'edap'edaa, ãchi rey pai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesús naa wãdap'edaarãpa mãik'aapa t'ẽe che wãdap'edaarãpa o-ĩa biapachida: —‘¡Hosana! ¡K'ĩra wãree! ¡Tachi Ak'õrepa pia ak'ɨ bapari ichia pëida ichi pari nipamerã na eujãde! ¡K'ĩra wãree Ak'õre eujãde, Tachi K'aripapari cheru perã!’ ");
INSERT INTO sjaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tachi Ak'õrepa pia ak'ɨ bapariit'ee ichia rey pëida! ¡David tachi rey padak'a waya rey iru p'anadait'ee! Tachi Ak'õrepa nãgɨ́ auk'a pia ak'ɨ bapariit'ee. ¡Hosana! ¡K'ĩra wãree Ak'õre eujãde, Tachi K'aripapari cheru perã! ");
INSERT INTO sjaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús Jerusalende pachek'ãri, wãji Ak'õre te waibɨadee. Aɨde eperãarãpa oo para bɨ unup'eda, waya wãji Betania p'uurudee chi k'õp'ãyoorã ome, k'ewara bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aɨ norema, Betania p'uurudeepa uchiadak'ãri, Jesús jarrapisia nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","T'ɨmɨɨpa unuji higuera bɨɨrɨ bainɨ̃ bɨ k'iru paraa. Mãpai araa ak'ɨnaji chau bɨ jĩak'aapa. Mamĩda chau-ee baji. Chi k'iru aupaita unuji, chaujara-e pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mãpai ma higuera bɨɨrɨmaa mãgaji: —¡Pɨ waa chauk'aa pait'eeda! aji. Chi k'õp'ãyoorãpa irua jarada ũrijida. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aɨ norema waya Jerusalende pachedak'ãri, Jesús Ak'õre te waibɨade t'ĩuji mãik'aapa net'aa netopataarã taawaa jërek'ooji. P'arat'a tau t'erabaipataarã mesa sĩa bat'ak'oo wãji, paloma netopataarã banco paara. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ak'õre te waibɨadee wãyaapik'aa paji net'aa ateerutaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mãpai jarateemaa beeji: —Tachi Ak'õre Ũraa p'ã jẽra bɨde jara bɨ: ‘Mɨ te ɨt'aa t'ɨ̃pata teda apataadait'ee, jõma na eujãdepemaarã-it'ee.’ ‘Mamĩda parãpa nechɨapataarã ték'ata oo iru p'anɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mãga ũridak'ãri, p'aareerã poroorã Moisepa p'ãda jarateepataarã ome k'ĩsia p'aneejida Jesús peepit'aadait'ee. Iru waawee p'anajida, eperãarãpa ak'ɨtrua para bada perã irua jaratee bɨ k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","K'ewaraa Jesús chi k'õp'ãyoorã ome uchiajida p'uurudeepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aɨ norema tap'eda waya Jesús chi k'õp'ãyoorã ome wãyaajida higuera bɨɨrɨ badamãi. Unujida chi k'arra jõmaweda p'oo ak'ɨnɨ̃ bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mãpai Pedropa k'irãpaji Jesupa jarada mãik'aapa jaraji Jesumaa: —¡Tachi Jarateepari, ak'ɨ́ji! Pɨa higuera bɨɨrɨmaa ijɨ̃atɨ pedeeda p'oodachida aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesupa p'anauji: —Ijãapatáatɨ Tachi Ak'õrede. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mɨa wãarata jararu. Eperã wãara Tachi Ak'õrede ijãa bɨ pɨrã, iidiipia bɨ ne-inaa oomerã, ichi t'ãridepai k'ĩsia-ee: “¿Ooik'ã wa oo-e pai?” Mãgá Tachi Ak'õrepa irua jaradak'a ooit'ee. Jararu pɨrã eemaa: “Jãmãik'aapa ãyaa wã́ji mãik'aapa p'usa jãde baaináji,” Tachi Ak'õrepa mãga ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mãgá ɨt'aa iididak'ãri, naapɨara ijã́atɨ Tachi Ak'õrepa ooru parãpa k'iniata, pãchi t'ãri auk'a p'anɨ perã iru ome. Mãgá p'anadairã irua ooit'ee parãpa ɨt'aa iididap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Parã ɨt'aa t'ɨ̃dak'ãri, k'ĩsianáatɨ apemapa k'achia ooda parãmaa. Ɨt'aa t'ɨ̃dai naaweda, iru chupɨria k'awáatɨ mãik'aapa perdonáatɨ irua k'achia ooda. Mãga ooruta pɨrã, Tachi Ak'õre ɨt'ari bɨpa perdonaait'ee parãpa p'ek'au k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mamĩda awaraarãpa k'achia oodap'edaa parãmaa perdonaada-e pɨrã, mãgara Tachi Ak'õrepa ichiaba perdonaa-e parãpa ne-inaa k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ma t'ẽepai waya chejida Jerusalendee. Jesús Tachi Ak'õre te waibɨade ni misa, irumaa chejida p'aareerã poroorã, Moisepa p'ãda jarateepataarã mãik'aapa judiorã poro waibɨarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iidijida: —¿Tachi Ak'õrepa tai bɨji-ek'ã ichi te waibɨa ak'ɨdamerã? ¿K'aipa pɨmaa nãga oopi bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Jesupa p'anauji: —Mɨa pida parãmaa iidiit'ee: ¿K'aipa pëijima aji, Juan Bautistapa poro choo chemerã; Tachi Ak'õrepa maa-e pɨrã eperãarãpa? P'anauruta pɨrã, mɨa pida ichiaba jarait'ee k'ai juapa mɨa nãgɨ́ ne-inaa oo bɨ. P'anaudapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mãpai ãchi pitapai pedee para beeji: —Tachi Ak'õrepa pëidada aruta pɨrã, irua iidiit'ee: “Mãgara, ¿sãap'eda Juan ũraa ijãada-e pajima?” Mapa mãga p'oyaa jarada-e. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma awara ¿tachia sãga jaradaima eperãarãpa Juan pëidap'edaa? Mãga jararuta pɨrã eperãarã k'ĩraudaridait'ee tachi ome. Ãchia waawee p'anapachida k'awa p'anadap'edaa perã jõmaarãpa ijãa p'anapachida Juan Tachi Ak'õre pedee jarapari paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mapa p'anaujida: —K'awada-e p'anɨda ajida, k'aipa Juan pëiji. Mãpai Jesupa mãgaji: —Mãgara mɨa pida jara-eda aji, k'aipa mɨmaa nãga oopi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesupa nepɨrɨmaa beeji ãchimaa: —Eperãpa uva eujã uuji mãik'aapa t'ɨak'auk'ooji. Ichiaba bõgo mãudee ooji uva piart'ɨdait'ee. Ma awara te ɨt'ɨa ooji ma ɨ̃rɨɨpa ak'ɨdait'ee. Mãga oop'eda, ne-uu eujã ak'ɨpataarã jɨrɨji mimiadamerã ichi-it'ee. Maap'eda awara ãyaa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","T'ẽepai uva oropata ewari pak'ãri, ma eujã chiparipa ichi mimiapari pëiji mimiapataarãmaa iidinamerã ichi eere bee bɨ chauda tee pëidamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mamĩda ãchia iru jita atadak'ãri, sĩk'oojida maap'eda jua arajãa pëit'aajida chiparimaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mãpai chi eujã chiparipa waya awaraa mimiapari pëiji. Mamĩda mãgɨ́ poro k'õop'et'aajida mãik'aapa waajarak'oojida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pëiji awaraa mimiapari; mãgɨ́ peet'aajida. Mãpai awaraarã chok'ara pëiji. Mãgɨɨrãdepema ũk'uru wɨk'oojida, apemaarã peek'oojida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Mamĩda at'ãri ichi ome iru baji ichi warra k'inia iru bada. K'ĩsiaji: “Mɨ mimiapataarã ome k'achia oojida. Mamĩda acha bɨ mɨ warra perã, waaweedait'ee. Mapa mɨa iru pëiit'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","T'ɨmɨ́ weda iru warra unudak'ãri, ma mimiapataarã pedee para beeji: “Jãgɨpa ichi ak'õre net'aa jõmaweda atait'ee chi ak'õre piuk'ãri. Peet'aadáma ajida, tachi eujã chiparik'a p'aneedait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mãpai iru pachek'ãri, jita atajida mãik'aapa peet'aajida. Maap'eda chi k'ap'ɨa ma uva eujãdeepa bat'at'aanajida. Mãgapai paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mamĩda, ma nepɨrɨ aupak'ãri, iidiji: —¡K'ĩsíatɨ! ¿K'ãata ooit'ee chiparipa? Mɨa jarait'ee. Wãk'ãri, ma eujã ak'ɨpataarã peek'oonait'ee mãik'aapa awaraa mimiapataarã jɨrɨnait'ee chi ne-uu eujã ak'ɨpataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Parãpa Ak'õre Ũraa p'ãda leeda-e p'anɨk'ã? ‘Te oopataarãpa mãu k'iniada-e padap'edaa pipɨara padachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tachi Ak'õrepa mãga ooji, tachia unudamerã mãik'aapa ak'ɨtrua para beemerã.’ Mãgara k'ĩsiadapáde aji, pia k'awaadait'ee mɨa jarateeda. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mãpai judiorã poroorãpa Jesús jita atapidait'ee paji, k'awadap'edaa perã irua ãchideta pedee baji. Mamĩda eperãarã chok'ara paraaji Jesús eere. Ma k'aurepa waawee p'anajida jitapidait'ee. Mapa ichiak'au atabëijida; maap'eda wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","T'ẽepai waya judiorã poroorãpa pëijida fariseorã mãik'aapa Rey Herodes eere p'anadap'edaarã Jesús ɨmɨateedamerã mãik'aapa peepit'aadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wãjida mãik'aapa iidijida: —Tachi Jarateepari, taipa k'awa p'anɨ pɨa wãarata jarapari. Ma awara pariatua ijãak'aa awaraarã k'ĩsiadeepa jara p'anɨ. Ichiaba pɨa auk'a jarateepari eperãarã waibɨarãmaa mãik'aapa chi chupɨria beerãmaa. Pɨa jarateepari tachi p'anapataadamerã Ak'õrepa k'inia bɨk'a. Maperã taipa iidi k'inia p'anɨ: ¿Pia bɨk'ã tachia impuesto p'aadait'ee Cesarmaa? ¿P'aadaipia bɨk'ã irua jara bɨk'a wa p'aadaik'araa bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mamĩda Jesupa k'awaji ãchia Tachi Ak'õrede ijãapatada apata mĩda, wãara ijãadak'aa. Maperã mãgaji: —¿Sãap'eda mɨ k'ũra k'inia p'anɨma? aji. Denario p'arat'a tau anéetɨ mɨa ak'ɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jesupa p'arat'a tau ak'ɨk'ãri, iidiji: —¿K'ai k'ĩrata nade bɨ, mãik'aapa k'ai t'ɨ̃ta p'ã bɨma? aji. P'anaujida: —César k'ĩra mãik'aapa ichi t'ɨ̃ta p'ã bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mãpai Jesupa mãgaji: —Mãgara téetɨ Cesarmaa irua net'aa iidipari, mãik'aapa téetɨ Tachi Ak'õremaa irua iidipari. Iru pedee ũridak'ãri, ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mãpai saduceorã ũk'uru wãjida Jesumaa ne-inaa iidide iru k'ũradait'ee. Mãɨrãpa jarateepata piudap'edaarã chok'ai p'irabaidak'aa. Maperã iidijida: ");
INSERT INTO sjaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tachi Jarateepari, Moisepa nãga p'ã bëiji tachi-it'ee: Eperã miak'ãi bɨ warra wẽe piuru pɨrã, chi ɨ̃pemapa iru wẽra ataipia bɨ mãik'aapa aɨ ome warra ooipia bɨ chi ɨ̃pema piuda k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mapa ¿pɨa k'ãata k'ĩsia bɨ nãgɨde? Ɨ̃pemaarã siete p'anajida. Chi naapema miak'ãiji. Mamĩda warra wẽe piuji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mãpai araarepema ɨ̃pema miak'ãiji ma p'ẽtrãa ome. Mamĩda ichiaba warra wẽe piuji. Ichiaba mãga p'asaji chi araarepema ɨ̃pemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jõmaweda miak'ãijida mĩda ma wẽra ome, warra ooda-e paji. Maap'eda ichiaba ma wẽra piuji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mãpai wãara pɨrã piudap'edaarã chok'ai p'irabaipata, waya chok'ai p'aneeruta ewate, ¿k'ai wẽra pait'eema ajida, jõmaweda iru ome miak'ãi p'anadap'edaa perã? ");
INSERT INTO sjaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesupa p'anauji: —Ak'õre Ũraa pia k'awada-e p'anadairã, parãpa awara k'ĩsia iru p'anɨ. Ichiaba k'awada-e Tachi Ak'õrepa ne-inaa jõmaweda oopari. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Eperãarã piudap'eda chok'ai p'irabaidak'ãri, ɨmɨk'ĩraarã wẽraarã ome waa miak'ãida-e pait'ee. Angeleerã ichi truade p'anɨɨrã́k'apɨ p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma awara parãpa k'achia k'ĩsia p'anapata jaradak'ãri piudap'edaarã chok'ai p'irabaidak'aa. ¿Waide parãpa Ak'õre Ũraade pia k'ĩsiada-e p'anɨk'ã? Abraham, Isaac mãik'aapa Jacob jai-idaajida mĩda, Tachi Ak'õrepa maaji Moisemaa pak'uru jep'eda urua jira bɨdeepa t'ɨpɨtauk'a: ‘Mɨ pɨ chonaarã Ak'õre Waibɨa; Abraham, Isaac, Jacob ijãadap'edaa Ak'õre Waibɨa.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jara-e paji: “Mɨ ãra Ak'õre paji.” Mapa Tachi Ak'õredeerã jai-idaajida mĩda, at'ãri chok'ai p'anɨ. ¡Iru piu beerã Ak'õre-epɨ! Ma k'ãyaara iru chok'ai beerã Ak'õrepɨ. Maperã parãpa ne-inaa awaraata k'ĩsia p'anɨ, Tachi Ak'õrepa jarada k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mãgá pedee jõnɨ misa, cheji Moisepa p'ãda jarateepari. Ãchi pedee ũrii beeji. Jesupa apemaarãpa iididap'edaa pia p'anauk'ãri, mãgɨ́ jarateeparipa iidiji: —Tachi Ak'õre Ũraa jõmaweda p'ãdadepema, ¿chisãgɨta waibɨara bɨma aji, apemaarã k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesupa p'anauji: —Tachi Ak'õre Ũraa waibɨara bɨde jara bɨ: ‘Ũrítɨ Israel pidaarã. Tachi Ak'õre Waibɨa apaita bɨ. Tachi Ak'õre awara wẽ-e. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tachi Ak'õre Waibɨa wãara k'inia iru baparíiji pɨchi t'ãripa mãik'aapa ne-inaa jõmaa k'ãyaara iru k'inia iru baparíiji. Ewari chaa k'ĩsíaji t'ãripa irude. T'ãri o-ĩa ooparíiji irua jara bɨk'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Araare jara bɨ: ‘Awaraarã k'inia iru baparíiji pɨchi k'ap'ɨa k'inia iru baparik'a.’ Ak'õre Ũraa waibɨara wẽ-eda aji, mãgɨ́ omé jara aupada k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mãpai Moisepa p'ãda jarateeparipa mãgaji: —Pia bɨ, Jesús. Wãarapɨ pɨa jara bɨ: ‘Tachi Ak'õre Waibɨa abapai bɨ. Awaraa wẽ-e iruk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tachi Ak'õre wãara k'inia iru baipia bɨ t'ãripa. Iru k'inia iru baipia bɨ ne-inaa jõma iru bɨ k'ãyaara. Ewari chaa k'ĩsiaipia bɨ t'ãripa irude mãik'aapa irua jara bɨk'a ooipia bɨ t'ãri o-ĩa.’ ‘Ichiaba awaraarã k'inia iru baparíiji pɨchi k'ap'ɨa k'inia iru baparik'a.’ Mãgata oodaipia bɨ awaraa ne-inaa oodai k'ãyaara; net'atau bɨda altarde wa ne-animal peeda altarde paadai k'ãyaara Ak'õre-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mãgá Moisepa p'ãda jarateeparipa pia p'anauru ũrik'ãri, Jesupa maaji: —Pɨa Ak'õre Ũraade ewaa ijãa wãda aji, Ak'õrepa k'inia bɨk'a ichi jua ek'ari o-ĩa nipamerã iru ode. Maadamãiipa waawee p'aneejida waa iididait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesupa jarateemaa bɨde Ak'õre te waibɨa ãuk'idaa, iidiji: —¿K'ãata jara k'inia p'anɨ Moisepa p'ãda jarateepataarãpa jaradak'ãri Mesías David ëreerãdeepa uchiait'ee? ¿David poro waibɨara bɨ-ek'ã, iru ëreerãdeepa uchiait'ee bɨ k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","¡Pia k'ĩsíatɨ! Tachi Ak'õre Jaurepa p'ãpiji Rey David ëreerãdeepa uchiait'ee badade: ‘Tachi Ak'õrepa jaraji Tachi Waibɨamaa: “Pɨ mɨ ome auk'a waibɨa bairã, su-ak'ɨ beepáde aji, mɨ juaraare, mɨa pɨ k'ĩra unuamaa iru p'anapataarã p'oyaaru misa.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidpa ichi ëreerãdeepa uchiait'ee bɨmaa t'ɨ̃jaraji “Tachi Waibɨa”. ¿Mapa k'awada-ek'ã aji, Mesías waibɨara bɨ chonaarãwedapema Rey David k'ãyaara? Eperãarã chok'ara mama p'anadap'edaarãpa Jesús pedee ũridak'ãri, o-ĩadachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesupa jaratee bɨ misa, mãgaji: —K'ĩrak'aupai p'anapataadai Moisepa p'ãda jarateepataarãk'a. Ãchi audua p'anadairã, p'aru teesoo jɨ̃i awaa p'anapata mãik'aapa k'inia p'anapata jõmaarãpa ãchimaa saludaadamerã plaza bee chaa, tachi poro waibɨarã ome oopatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ichiaba su-ak'ɨ p'aneepata su-ak'ɨ beepari pipɨara bɨde Tachi Ak'õre Ũraa jarateepata tede mãik'aapa nek'odak'ãri, chi su-ak'ɨ beepari pipɨara bɨde su-ak'ɨ p'aneepata. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ma awara, p'ẽtrãa chupɨria beerã te jãri atapata mãik'aapa seewata taarã ɨt'aa t'ɨ̃pata eperãarã k'ĩrapite. Tachi Ak'õre ewari waibɨa ewate ichia ãchi audupɨara miapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ewari aba Jesús su-ak'ɨ baji primisia p'arat'a p'epata k'ait'a, ak'ɨmaa eperãarãpa eda ata bɨdak'ãri. P'arat'ara beerãpa waibɨa ata bɨ chepachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mãga nɨde p'ẽtrãa chupɨria k'ɨrɨ pacheji. Ata bɨ cheji p'arat'a tau omé cobredee. Mãgɨ́ p'arat'a tau mak'ɨara ɨ̃pɨa-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mãga unuk'ãri, Jesupa chi k'õp'ãyoorãmaa maaji: —Mɨa wãarata jararu. Tachi Ak'õre k'ĩrapite na p'ẽtrãapa primisia waibɨara teejida aji, apemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jõmaarãpa tee p'anɨ ãchi p'arat'a waibɨa iru p'anadap'edaadepema beeda. Jõdee na p'ẽtrãa, chupɨria k'ɨrɨ mĩda, ichia iru k'erada jõmaweda teeji Tachi Ak'õremaa. Teejida aji, chi p'arat'a iru bada paara chik'o netoit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús uchiak'ãri Tachi Ak'õre te waibɨadeepa chi k'õp'ãyoorã ome, abaapa maaji: —¡Tachi Jarateepari, ak'ɨ́ji, acha bɨ mãu ta-pɨa p'anɨ mãik'aapa Tachi Ak'õre te waibɨa pi-ia oo k'obɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesupa maaji: —Wãara, acha p'anɨ te pi-ia p'anɨ. Mamĩda ewari cherude mãu apida bee-e pait'ee awaraa mãu ɨ̃rɨ. Na jõmaweda t'eek'oo chedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","T'ẽepai wãjida Olivo Eedee; Ak'õre te waibɨa k'ĩrapite beepari. Jesús ituaba su-ak'ɨ beek'ãri, Pedro, Santiago, Juan mãik'aapa Andrés iru k'ait'a wãjida mãik'aapa iidijida: ");
INSERT INTO sjaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Sãapai p'asait'ee pɨa jarada Ak'õre te waibɨade? ¿Sãga taipa k'awadayama ajida, ma ewari k'ait'a pak'ãri p'asait'ee pɨa jaradak'a? ");
INSERT INTO sjaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesupa p'anauji: —Tauk'a nipapatáatɨ apidaamaa k'ũrapiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mɨ jĩak'a chok'ara chedait'ee. Seewata jaradait'ee: “Mɨta Ak'õre Warra, Tachi Ak'õrepa pëida.” Mãga jara p'anɨpa eperãarã chok'ara k'ũradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Parãpa ũridak'ãri nama mãik'aapa awara ãi jura chõo jõnɨ, p'eranáatɨ. Ichita mãga p'asait'ee. Mamĩda at'ãri na p'ek'au eujã jõ-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aɨ naaweda eperãarã awaraarã ome chõodait'ee. Jarra oodait'ee mãik'aapa awẽrachai wãyaapariit'ee eujã awara-awaraade. Mamĩda mãga p'asak'ãri, ewaapɨ na p'ek'au eujãdepemaarã miamaa p'aneedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’¡Tauk'a nipapatáatɨ! Mɨ k'ĩra unuamaa iru p'anapataarãpa parã atapidait'ee judiorã poroorãmaa, mɨde ijãapata k'aurepa. P'ua oodait'ee Ak'õre Ũraa jarateepata tede. Ateedait'ee ãchi poro waibɨarãmaa mãik'aapa ãchi reyrãmaa. Mãɨrã k'ĩrapite parãpa jaradai Tachi Ak'õrepa ooda parã-it'ee mɨ k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mamĩda na eujã jõi naaweda, Ak'õrepa ooda eperãarã k'aripait'ee ichita nepɨrɨdait'ee eperãarãmaa awara ãi t'ɨmɨ́ na eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mɨ k'ĩra unuamaa iru p'anapataarãpa parã charraarã k'ĩrapite ateedak'ãri, k'ĩsianáatɨ k'ãata jaradai. Maapai jarapatáatɨ Ak'õrepa jarapi bɨk'a. Ak'õre Jaurepata k'awapipariit'ee k'ãata jaradai. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Maapai ɨ̃pemaarãpa peepidait'ee ãchi ɨ̃pemaarã. Ak'õreerãpa peepidait'ee ãchi warrarã. Ichiaba warrarã k'ĩraudaridait'ee ãchi ak'õreerã ome peepirutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jõmaarãpa parã k'ĩra unuamaa iru p'anapataadait'ee mɨde ijãapata k'aurepa. Mamĩda Tachi Ak'õrepa k'aripait'ee atuanaadamerã k'ĩra jĩp'a nipapataarã Ak'õre ode jai-idaarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","—Ewari cherude abaapa ne-inaa audú k'achia ooit'ee Tachi Ak'õre te waibɨa edupɨara bɨ cuartode ichi baik'araa bɨmãi. Mãgɨ́ Tachi Ak'õrepa yiaraa iru bapari, k'ĩra unuamaa iru bairã. Mãga unudak'ãri, Judea eujãde p'anɨɨrã p'ira mirudaipia bɨ ee nok'odee. (Acha bɨ pedee p'ãda leerupa pia k'awaipia bɨ, miapiamaapa.) ");
INSERT INTO sjaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maapai eperã ichi terrazade bɨ pɨrã, teedaa t'ĩuk'araa bɨ ichi ne-inaa p'e atade. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Eperã ne-uu k'ãide ni pɨrã, teedaa cheik'araa bɨ ichi p'aru atade pida. Aramata wãipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Aai, maapai chupɨria jõneedait'ee wẽraarã biak'oo bee maa-e pɨrã warra chak'eerã jude iru bee! ");
INSERT INTO sjaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mãga wãyaai naaweda, chupɨria iidítɨ Tachi Ak'õremaa ma ewari p'asapinaamerã k'oijara nɨ̃bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mãgɨ́ ewate jõmaarãta chupɨria mia jõnadait'ee. Ak'õrepa na eujã oodak'ãriipa mãga ook'aa paji, ma awara t'ẽepai waa mãga oo-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mamĩda Tachi Ak'õrepa k'ĩsiait'ee: “Mɨa eperãarã taarã miapi-e pait'ee.” Mãga pada paara, eperã apida bee-e pak'aji. Ak'õrepa audú chaaree miapi-e pait'ee ichia jɨrɨt'eradaarã k'inia p'e iru bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Maapai apidaapa parãmaa jararuta pɨrã: “¡Pɨchá, ak'ɨ́tɨ! ¡Nama bɨ Cristo, Tachi Ak'õrepa pëida!” maa-e pɨrã jararuta pɨrã: “¡Ara bɨta Cristo!” ijãanáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mɨ jĩak'aarã mãik'aapa Tachi Ak'õre pedee jarapataarã jĩak'aarã chok'ara chedait'ee. Mamĩda mãɨrãpa jara p'anɨ ijãanáatɨ, jĩp'a seewa-idaa bee perã. Ne-inaa k'ĩra t'ãdoo eperãarãpa p'oyaa oodak'aa ãchi juadoopa oo p'anɨpa eperãarã k'ũradait'ee, perá Tachi Ak'õrepa jɨrɨt'eradaarã k'ũrarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jesupa ichi ome nipapataarãmaa waya maaji: —¡Tauk'a p'anapatáatɨ! Mɨa mãga jaraji parãpa k'awaadamerã mãga p'asai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Ichiaba maapai mia p'anadap'eda, ‘Ak'õrejĩru p'ãriudariit'ee; atane waa ɨ̃daa-e pait'ee ");
INSERT INTO sjaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mãik'aapa lucero baaik'oodaridait'ee pajãdeepa. Tachi Ak'õrepa pajã wërepiit'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","’Mãpai eperãarãpa unudait'ee mɨ, chi Eperã Ak'õre Truadepema jõmaarã k'ãyaara waibɨara bɨ, k'ĩra wãree cheru jɨ̃ararade. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pëiit'ee mɨ angeleerã Ak'õre truadeepa mɨa jɨrɨt'eradaarã chip'e atadamerã, jõmaweda ãchi p'anapatamãiipa. T'ɨmɨ́ bee jida na p'ek'au eujãde, p'e atanadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—K'ĩsíatɨ higuera bɨɨrɨde. Higuera k'iru t'u-k'ua uchia nɨ̃beek'ãri mãik'aapa ewaa t'ono nɨ̃beek'ãri, k'awaapata eujã wãsia wã. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mãga pɨk'a mɨa et'ewa jaradak'a unudak'ãri, k'awa p'anɨ taarã-e mɨ, chi Eperã Ak'õre Truadepema cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mɨa wãarata jararu. Ɨ̃rapemaarã piudai naaweda, ma ne-inaa jõmaweda p'asait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ewari cherude pajã na p'ek'au eujã ome jõdait'ee. Mamĩda ichita p'asait'ee mɨa pedee jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Eperã apidaapa k'awada-e p'anɨ Eperã Ak'õre Truadepema cheit'ee ewate, chi hora jida. Ɨt'aripema angeleerãpa pida k'awada-e p'anɨ; mɨa ichiaba k'awa-e, Tachi Ak'õre Warra mĩda. Mɨ Ak'õrepapaita k'awa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Maperã tauk'a p'anapatáatɨ, parãpa k'awada-e p'anadairã sãapai mɨ waya na eujãdee cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Oopatáatɨ te chiparipa oodak'a. Mãgɨ́ tedeepa awara ãyaa wãi naaweda, ichi mimiapataarãmaa jara bëiji te pia ak'ɨdamerã. Ãchi chaachaa mimia teeji mãik'aapa chi te t'ĩupata ak'ɨparimaa ũraaji tauk'a bamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chi mimiapataarãpa k'awada-e sãapaita chi te chipari waya cheit'ee ichi temaa. Mãga pɨk'a bɨ parã ome. Tauk'a p'anapatáatɨ k'awada-e p'anadairã sãapai pãchi Chipari Waibɨa waya cheit'ee. Chei p'ãriupodopa, esapɨte, et'erre k'arik'ãri, maa-e pɨrã tap'edapodopa. ¡Parãpa k'awada-epɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tachi Ak'õre mimiapataarã, k'ĩrak'aupai k'awada-e p'anadairã pariatua mimia p'anɨ pɨrã, k'ĩra nejasia p'anadait'ee Tachi Chipari Waibɨa chek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mɨa parãmaa ũraada, auk'a jõmaarãmaa jararu: ¡Tauk'a p'anapatáatɨ! ");
INSERT INTO sjaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","K'ãima omé falta baji Pascua fiesta pait'ee. Mãgɨ́ fiestade pan levadura wẽe k'opata. P'aareerã poroorãpa Moisepa p'ãda jarateepataarã ome jɨrɨpachida sãga Jesús k'ũrat'aadait'ee. Mãgá jita atadait'ee paji mãik'aapa peepit'aadait'ee paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mamĩda ũk'uru arii p'anadap'edaarãpa maapachida: —Fiestade ooda-eda ajida, eperãarã k'ĩrau para beepiamaapa tachi ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania p'uurude bak'ãri, Simón, chi leprapa k'ayaa bada apatap'edaa tede baji. Jesús su-ak'ɨ beep'eda, nek'omaa baji. Mãga nɨde wẽra pacheji. Ateeji chok'o chak'ek'a mãu pi-ia alabastrodee ooda. Mãgɨ́ ipuru baji k'era ɨ̃pɨa nardodee oodapa. Chok'o t'ap'a ewa ataji mãik'aapa weeji Jesús poro ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ũk'uru arii p'anadap'edaarã k'ĩraudachida mãik'aapa pedee para beeji ãchi pitapai: —¿Sãap'eda jã k'era ichi k'inia weejima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jã wẽrapa netot'aada paara, trescientos denarios iru bak'aji chupɨria beerã k'aripait'ee. Mapa ma wẽra ɨtrɨapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mamĩda Jesupa mãgaji ãchimaa: —Ita-aria bɨ́tɨ; ¿K'ãare-it'ee ik'achia jara jõnɨma? Irua ooda pia bɨpɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chupɨria beerã nama p'anapata parã t'ãide ewari chaa. Ãchi k'aripa k'inia p'anɨ pɨrã, chupɨria k'awaadai mãik'aapa ãchimaa ne-inaa pia oodai. Mamĩda mɨ parã ome ichita ba-e pait'ee. Na ewari parãpa waa mɨ unuda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na wẽrapa ooji ichia p'oyaarutapai mɨ-it'ee; mɨ p'urut'aaji k'erapa mɨ k'ap'ɨa ɨadai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mɨa wãarata jararu. Mɨa ooda eperãarã k'aripait'ee, mãga jarateepata chaa na p'ek'au eujãde, ichiaba nepɨrɨpataadait'ee na wẽrapa ooda mɨ-it'ee. Mãgá iru ichita k'irãpadait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, Jesús k'õp'ãyoorã docedepema aba, wãji p'aareerã poroorãmaa. Jaraji ichia ãchi k'aripait'ee Jesús jitadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mãga ũridak'ãri, o-ĩadachida mãik'aapa pedeejida p'arat'a teedait'ee Judamaa. Mãpai Judapa jɨrɨmaa beeji sãga Jesús ãchimaa jitapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Perá Pascua fiesta ewari pait'ee baji. Ma fiestade oveja chak'e peepata mãik'aapa pan levadura wẽe k'opata. Fiesta pai naaweda Jesús k'õp'ãyoorãpa iidijida irumaa: —¿Sãma k'oit'ee Pascua fiesta ewatepema chik'o tai ome? Mama taipa ne-inaa oodait'ee nek'odai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mãpai Jesupa pëiji chi k'õp'ãyoorã omé: —Wã́tɨ p'uurudee. Mama ununadait'ee eperã pania chok'ode ateeru. T'ẽe wã́tɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Teedaa wãk'ãri, chi te chiparimaa jarátɨ: “Tachi Jarateeparipa iidi pëiji: ‘¿Chisãgɨ́ cuartode Pascua chik'o k'oit'ee mɨchi k'õp'ãyoorã ome?’ ” ");
INSERT INTO sjaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Irua ak'ɨpiit'ee ɨt'ɨpema pisode cuarto waibɨa pia oo bɨ. Mama ne-inaa jõma óotɨ tachi nek'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chi k'õp'ãyoorã wãjida p'uurudee. Jõmaweda ununajida Jesupa jaradak'a mãik'aapa mama ne-inaa jõma oojida Pascua chik'o k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","P'ãriupodopa Jesús pacheji chi k'õp'ãyoorã doce ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mesade nek'omaa p'anɨde, Jesupa mãgaji: —Mɨa wãarata jararu. Mɨa k'awa bɨ parãdepema abaapa mɨ traicionaait'ee. Iru mɨ ome nama nek'omaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mãpai chi k'õp'ãyoorã k'ĩra pia-ee para beeji mãik'aapa aba-abaa iidijida Jesumaa: —¿Mɨk'ã? apachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mãpai Jesupa p'anauji: —Parã docedepema aba mɨ ome auk'a p'arat'ude pan sã atarupata mɨ traicionaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɨ, chi Eperã Ak'õre Truadepema, ichita piut'ee Tachi Ak'õre Ũraa p'ãdade jara bɨk'a. Mamĩda, ¡aai, Tachi Ak'õrepa k'achiadee pëiit'ee chi mɨ traicionaait'ee bɨ! Piara bak'aji mãgɨ́ t'o-e pada paara. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nek'omaa p'anɨde Jesupa pan ataji mãik'aapa ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa. Ma pan k'õrat'aaji mãik'aapa chi k'õp'ãyoorãmaa teeji. Mãpai mãgaji: —Jitátɨ mãik'aapa k'ótɨ. Nãgɨ́ pan mɨ k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Maap'eda mãgá ooji ma vino ome. Ɨt'aa t'ɨ̃p'eda, gracias jaraji Tachi Ak'õremaa mãik'aapa chi k'õp'ãyoorãmaa teeji. Jõmaarãpa aɨdepema vino tojida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mãpai mãgaji: —Nãgɨ́ vino mɨ waa, mɨchi waa bat'ait'ee perã mɨ piuk'ãri chok'araarã pari. Tachi Ak'õrepa nãgɨ́ ũraa chiwidi jara bɨ. Mɨchi waa bat'ada k'aurepa irua wẽpapiit'ee eperãarã chok'araarãpa p'ek'au k'achia oopata mãik'aapa mɨchideerã papiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mɨa wãarata jararu. Vino waa to-e pait'eeda aji, parã ome ɨt'aripema vino torumaa Tachi Ak'õre truade. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tachi Ak'õre Ũraa p'ãdadepema k'ari k'aridap'eda, Olivo Eedee wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mama Jesupa mãgaji: —Parã jõmaweda ijãadaamaa p'aneedait'ee mãik'aapa mɨ ituaba atabëidait'ee Tachi Ak'õre Ũraa p'ã jẽra bɨde jara bɨk'a: ‘Mɨa oveja ak'ɨpari peepiit'ee mãik'aapa chi ovejaarã jĩchoodaridait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mamĩda mɨ chok'ai p'irabaik'ãri, Galilea eujãdee wãit'ee parã naa. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mãpai Pedropa mãgaji: —Apemaarãpa pɨ atabëiruta pɨjida, mɨa pɨ atabëi-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesupa p'anauji: —Mɨa wãarata jararu. Idi p'ãrik'ua et'erre k'arida omé k'arii naaweda, jarada õpee pɨa mɨ k'awa-e bɨda ait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mamĩda Pedropa waapɨara mãgapachi: —Pɨ ome auk'a piuru pɨjida, mɨa jara-eda aji. Apemaarãpa ichiaba mãga jarapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Maap'eda wãjida Getsemaní ne-uu eujã apatap'edaamaa. Mama panadak'ãri, Jesupa mãgaji chi k'õp'ãyoorãmaa: —Nama su-ak'ɨ p'anéetɨ mɨ ɨt'aa t'ɨ̃naru misa. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ichi ome ateeji Pedro, Santiago mãik'aapa Juan. Jesús k'ĩsia paraa nɨ̃beeji t'ãri p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mapa mãgaji ãchimaa: —Mɨ piut'ee pɨk'a nɨ̃bɨ t'ãri p'uapa. Nama p'anéetɨ, k'ãida-ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mãpai Jesús waawipai wãp'eda, bedabaiji tau bɨɨrɨ eujãde t'õbairumaa mãik'aapa Ak'õremaa chupɨria iidiji k'inia bɨ pɨrã, iru mãgɨ́ miapi p'asapinaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɨt'aa t'ɨ̃ji: —Abbá, Mɨ Ak'õre, pɨa jõma p'oyaapari. K'aripáji na miait'ee bɨdeepa. Mamĩda oonáaji mɨa k'inia bɨk'a. Jĩp'a pɨa k'inia bɨ́k'ata óoji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Maap'eda, ak'ɨ chek'ãri, chi k'õp'ãyoorã k'ãi jõnɨta unu cheji. Mãpai mãgaji Simón Pedromaa: —Simón, ¿k'ãi nɨ̃bɨk'ã? aji. ¿Hora apida p'oyaa chok'ai p'anada-ek'ã k'ãida-ee? ");
INSERT INTO sjaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chok'ai p'anátɨ mãik'aapa ɨt'aa t'ɨ̃́tɨ p'ek'au k'achiade baaipiamaapa. Tachi Ak'õrepa oopi k'inia bɨk'a t'ãripa oo k'inia p'anɨ. Mamĩda pãchi k'ap'ɨapa chooda-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Waya wãji ɨt'aa t'ɨ̃de naaweda oodak'a: —K'aripáji na miait'ee bɨdeepa. Mamĩda oonáaji mɨa k'inia bɨk'a; jĩp'a pɨa oo k'inia bɨ́k'ata oopáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Waya chek'ãri, naa unu chedak'a unu cheji; k'ãi jõnɨ tap'ok'eepa. Ɨ̃rɨmadap'eda, k'ĩup'ee p'anapachida, k'awada-e pada perã k'ãata jaradai. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ɨt'aa t'ɨ̃da õpeemaa waya chek'ãri, Jesupa mãgaji: —¿At'ãri k'ãi jõnɨk'ã? Jãgapaipɨ. Mɨ peepidait'ee hora pajipɨ. Eperã Ak'õre Truadepema teedait'ee p'ek'au k'achia oopataarã juade. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eperã mɨ traicionaait'ee bɨ k'ait'a cheru. ¡P'irabáitɨ mãik'aapa wãdáma apemaarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús at'ãri pedeemaa bɨde ichi k'õp'ãyo Judas pacheji eperãarã chok'ara ome. Espada pak'uru ome anipajida. P'aareerã poroorãpa, Moisepa p'ãda jarateepataarãpa mãik'aapa judiorã poro waibɨarãpa ma eperãarã pëijida ãchi pari. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","K'awaadamerã chisãgɨta Jesús, panadai naaweda, Judapa jaraji mãɨrãmaa: —Chi mɨa k'ĩra ɨ̃ruta saludaak'ãri, mãgɨta pia jita atadapáde aji, mãik'aapa atadaridapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mapa pachedak'ãri Jesumãi, Judas pedee cheji: —¡Tachi Jarateepari! Mãga jarap'eda, k'ĩra ɨ̃t'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mãpai Jesús jita atajida mãik'aapa ateejida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mamĩda eperã Jesús k'ait'a badapa ichi espada ẽt'a atap'eda, p'aareerã poro waibɨa mimiapari k'ɨɨrɨ orp'et'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mãpai Jesupa iidiji ichi jita ata chedap'edaarãmaa: —¿Sãap'eda parã chejidama aji, espada ome mãik'aapa pak'uru ome mɨ jita atade eperã nechɨayaa bɨ jita atapatak'a? ");
INSERT INTO sjaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ewari chaa mɨ Tachi Ak'õre te waibɨade bapari iru pedee jarateemaa. Maapai mɨ jitada-e paji. Mamĩda nãga p'asaru Ak'õre Ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesupa mãga jaramaa bɨde, jõmaweda chi k'õp'ãyoorãpa atabëijida mãik'aapa miruk'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mamĩda k'ũtrãa aba Jesús t'ẽe nipaji. Chi k'ap'ɨa pɨra baji sabanapa, ãk'adaa nipada perã. Judas ome nipadap'edaarãpa ma k'ũtrãa jita atajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mamĩda, waaweepa sabana k'enat'aaji mãik'aapa ãk'adaa p'ira uchiadachi. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mãpai ãchia Jesús ateejida Caifás temaa. Ichi p'aareerã poro waibɨa paji. Mama ichiaba see nɨ̃baji p'aareerã poroorã, judiorã poro waibɨarã mãik'aapa Moisepa p'ãda jarateepataarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro t'ɨmɨɨpapai t'ẽe wãk'ãtɨ wãji. Mãgá wãpa Caifás te t'ɨak'au badamãi edú t'ĩuji. Mama t'ɨpɨtau ik'aawa su-ak'ɨ beeji k'ara p'aiit'ee Ak'õre te jɨ̃apataarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","P'aareerã poroorãpa jõmaweda Junta Supremadepemaarã ome testigo jɨrɨ p'anapachida. Mãgá Jesús peepit'aadait'ee. Mamĩda maarepida unuda-e paji ɨmɨateedait'ee, ");
INSERT INTO sjaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ma eperãarã chok'araarãpa wãara jaradak'aa pada perã mãik'aapa auk'a pedeedak'aa pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ũk'uru chi poroorã k'ĩrapite p'irabaijida mãik'aapa seewa jarajida: ");
INSERT INTO sjaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Taipa ũrijida irua jararu: “Chonaarãweda eperãarãpa Tachi Ak'õre te waibɨa oojida. Mɨa mãgɨ́ te t'eet'aap'eda, k'ãima õpeemaa waya oo atai. Mamĩda eperãarãpa oopatak'a oo-e pait'eeda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mãga jarajida mĩda, at'ãri auk'a pia pedeeda-e paji tachi judiorã ũraade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mãga ũrik'ãri, p'aareerã poro waibɨa Caifás bainɨ̃ beeji jõmaarã k'ĩrapite mãik'aapa iidiji Jesumaa: —¿Wãarak'ã aji, pɨ k'ĩrapite jara p'anɨ pedee? ¿Maarepida p'anau-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mamĩda Jesupa maarepida p'anau-e paji; k'ĩup'ee beeji. Waya mãgaji: ’¿Pɨk'ã Mesías, Tachi Ak'õrepa pëida eperãarã rey pamerã? ¿Pɨk'ã aji, Tachi Ak'õre Waibɨa Warra? ");
INSERT INTO sjaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesupa p'anauji: —Mɨda aji. Parãpa mɨ unudait'ee Ak'õre Waibɨa juaraare su-ak'ɨ bɨ. Ichiaba mɨ, chi Eperã Ak'õre Truadepema waya chek'ãri, unudait'ee jɨ̃ararade cheru. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mãpai Caifapa ichi p'aru jẽt'aaji t'ãri k'achiapa mãik'aapa mãgaji: —¿K'ãare-it'ee waa jɨrɨdaima eperãarãpa jaradamerã ichia ooda? ");
INSERT INTO sjaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¿Parãpa ũrijida-ek'ã ichia pedee k'achia jarada Tachi Ak'õre ãpɨte? ¿K'ãata k'ĩsia p'anɨma? aji. Jõma auk'a bia para beeji: —Ichia jarada k'aurepa piupia bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ũk'uru arii p'anadap'edaarãpa Jesumaa idujida mãik'aapa tau p'ãrajɨ̃ atadap'eda, sĩjida. Mãga oo jõnɨde mãgajida: —¡Pɨ wãara Tachi Ak'õre Warra pɨrã, jarapáde aji, k'aipata pɨ sĩji! Ichiaba Ak'õre te jɨ̃apataarãpa k'ĩramaa sĩpachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mãɨmisa Pedro tuda baji te ãuk'idaa. Mãga nɨde Caifás mimiapari awẽra irumaa cheji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma wẽrapa Pedro unuk'ãri k'ara p'aimaa bɨ t'ɨpɨtau ik'aawa, pi-ia ak'ɨji mãik'aapa mãgaji: —Pɨ auk'a nipajida aji, jã eperã Jesús Nazaretdepema ome. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mamĩda Pedropa meraji: —¡Seewa! Mɨa iru k'awa-e bɨ. Ichiaba k'awa-e bɨda aji, pɨa k'ãaredeta pedee bɨ. Maap'eda mamãik'aapa uchiaji chi cercao edú t'ĩupatamaa. Mãga nɨde et'erre k'ariji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma wẽrapa waya unu atak'ãri, mãgaji arii p'anadap'edaarãmaa: —Pɨchá, jãgɨ́ Jesús k'õp'ãyo. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mamĩda Pedropa waya meraji. Taarã-e nɨde chi arii p'anadap'edaarãpa waya mãgajida: —Wãara, pɨ ãchi k'õp'ãyo. Ma awara, pɨ Galilea eujãdepemak'a pedee bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mãpai Pedropa juraaji: —¡Seewa! ¡K'awa-e bɨ parãpa jara p'anɨ eperã! Mɨa seewa jaramaa bɨ pɨrã, Tachi Ak'õrepa mɨ miapiipia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aramata et'erre waya k'ariji. Mãpai Pedropa k'irãpaji Jesupa jarada: “Et'erre k'arida omé k'arii naaweda, pɨa jarada õpee jarait'ee mɨ k'awa-e bɨ.” Mãga k'ĩsiap'eda, Pedro jẽedachi t'ãri p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tap'eda weda p'aareerã poroorã, judiorã poro waibɨarã mãik'aapa Moisepa p'ãda jarateepataarã, mãgɨ́ Junta Supremadepemaarã chip'edaidap'eda, pedeeteejida k'awaadait'ee k'ãata oodait'ee Jesús ome. Jesús jua jɨ̃ atapidap'eda, teenajida Pilato temaa. Ichi Romadepemaarã poro waibɨa paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatopa iidiji Jesumaa: —¿Pɨk'ã aji, Judiorã Rey? Jesupa p'anauji: —Mɨda aji, pɨa jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","P'aareerã poroorãpa audupai ɨmɨatee jõnadap'edaa perã, ");
INSERT INTO sjaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatopa waya iidiji: —¿Maarepida p'anau-ek'ã aji, ɨmɨatee jõnɨta? ");
INSERT INTO sjaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mamĩda Jesupa maarepida p'anauk'aa paji. Mapa Pilatopa k'awa-e paji k'ãata ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ma fiestade Pilatopa preso aba k'ena pëipachi, eperãarãpa iidirutata. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eperã t'ɨ̃jarapatap'edaa Barrabás carcelde baji awaraa k'õp'ãyoorã ome, Roma pidaarã juadeepa uchia k'iniapa chĩara pee p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eperãarãpa iidinadak'ãri Pilatomaa preso k'ena pëimerã ichia ooparik'a, ");
INSERT INTO sjaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","irua p'anauji: —¿K'inia p'anɨk'ã aji, mɨa Judiorã Rey apata k'ena pëimerã? ");
INSERT INTO sjaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mãga iidiji k'awa bada perã judiorã p'aareerã poroorãpa Jesús k'ĩra unuamaa iru p'anadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mamĩda p'aareerã poroorãpa eperãarãmaa jarajida iididamerã Pilatopa Barrabata k'ena pëipimerã. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mapa Pilatopa iidiji: —¿Sãga oopi k'inia p'anɨma aji, parãpa Judiorã Reyda a p'anɨ ome? ");
INSERT INTO sjaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mãpai biajida: —¡Kurusode peepit'áaji! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatopa mãgaji: —¿K'ãare k'achiata oojima? aji. Mamĩda waya eperãarãpa biajida: —¡Kurusode peepit'áaji! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato pia bee k'inia bada perã eperãarã ome, Barrabata k'ena pëiji. Jesús soopa wɨpip'eda, pëiji kurusode baijira bɨdamerã piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldaorãpa Jesús ateejida Pilato palaciode, t'ɨ̃jarapatap'edaa pretorio. Mama tuda soldaorã chok'araara seedachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oo iru p'anapachida. Rey p'aruk'a p'oree k'ĩra p'ãimap'ãimaa jɨ̃ bɨdap'eda, poro jɨ̃ra pak'uru jua ne-ɨɨrɨ-idaa bɨdee oojida mãik'aapa jɨ̃ bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maap'eda bia ëipachida: —¡Ak'ɨ́tɨ Judiorã Rey! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Poromaa wɨpachida pak'urupa. Idupachida mãik'aapa bedabaidaipachida iru k'ĩrapite ɨt'aa t'ɨ̃ pɨk'adait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mãgá oo iru p'anadap'eda, ma p'aru p'oree ẽrat'aajida mãik'aapa ichi p'aru waya jɨ̃ bɨjida. Maap'eda ateejida kurusode baijira bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Uchia wãdak'ãri Jerusalendeepa, unujida eperã Cirene p'uurudepema t'ɨ̃jarapatap'edaa Simón. Ewaa p'uurude panaji. Mãgɨ́ eperã Alejandro mãik'aapa Rufo ak'õre paji. Simón ik'aawa wãyaa wãdak'ãri, soldaorãpa kuruso ateepijida Jesús pari. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesús ateejida Gólgota apatap'edaamaa. (Gólgota jara k'inia bɨ: “Tachi Poro Bɨɨrɨ”.) ");
INSERT INTO sjaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Maap'eda teejida vino mirra ome p'oirada, mamĩda Jesupa to-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mãpai soldaorãpa Jesús jua mãik'aapa chi bɨɨrɨ merap'ejida mãik'aapa kurusode baijira bɨjida piumerã. Mãgɨɨrãpa suerte jemenejida k'awaadait'ee k'aipata iru p'aru atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mãga oojida tap'eweda, las nueve. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Soldaopa iru poro ɨt'aik'a eere kurusode letrero merap'eji, jarait'ee k'ãare-it'ee kurusode baijira bɨjida piumerã. P'ã baji: Judiorã Rey. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mama ichiaba nechɨapataarã omé kurusode baijira bɨjida, aba Jesús juaraare, chi apema juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mãga p'asaji Tachi Ak'õre Ũraa jaraparipa p'ãdak'a chonaarãweda: ‘Iru p'ek'au k'achia oopataarã ome auk'a ata bɨjida.’ ");
INSERT INTO sjaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chi arii wãyaa wã nipadap'edaarãpa irumaa ik'achia jarajida. Ãchi poro p'ɨrap'ɨraa mãgapachida: —¡Aai, pɨa Tachi Ak'õre te waibɨa jõmaweda t'eet'aait'ee paji mãik'aapa waya oo atait'ee paji ewari õpeemaa! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pɨa jarada wãara pɨrã, ¡jãmãik'aapa ɨrabáiji piunaamerã! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ichiaba mãgá oo iru p'anapachida p'aareerã poroorãpa Moisepa p'ãda jarateepataarã ome: —¡Awaraarã k'aripajida ajida. Mamĩda ichi itu nadeepa p'oyaa uchia-e! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Ak'ɨ́tɨ! ¿Jãgɨ́ Tachi Ak'õrepa pëida tachi k'aripamerã, Israel pidaarã Rey poro waibɨak'ã? ¡Jãmãik'aapa ɨrabáiji ɨ̃raweda tai k'ĩrapite! Mãga ooru pɨrã, taipa ichiaba pɨde ijãadait'eepɨ. Kurusode iru ik'aawa baijira p'anadap'edaarãpa ichiaba irumaa ik'achia jarapachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Imat'ɨpa ak'õrejĩru k'iat'ɨdachi. Na eujã jõma p'ãriudachi las tres parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma hora Jesupa golpe biaji: —‘Eloí, Eloí, ¿lemá sabactani?’ (Ma pedee jara k'inia bɨ: ‘Mɨ Ak'õre, Mɨ Ak'õre, ¿K'ãare-it'ee mɨ atabëijima?’) ");
INSERT INTO sjaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ũk'uru arii p'anadap'edaarãpa ũridak'ãri, maajida: —¡Ũrítɨ! Elías, chonaarãwedapema Ak'õre pedee jarapari t'ɨ̃maa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eperã p'ira wãji mãik'aapa esponjak'a p'ẽesap'ẽesaa bɨ topa ataji vino achuchuade. Sia k'ɨ̃de jõi bɨp'eda, Jesús it'aimãi t'ɨ atanaji sõmerã, opisia bɨ jĩak'aapa mãik'aapa maaji: —Ɨ̃rá, ichiak'au bɨdait'ee. Unu k'inia p'anɨ Elías cheru pɨrã ichi ɨrabai atade. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mamĩda Jesús golpe biaji mãik'aapa jai-idaaji. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mãɨmisa Jerusalende Tachi Ak'õre te waibɨade chi edupɨara bɨ cuarto t'ĩupatamãi p'aru teesoo eebai jira bada esajĩak'a jẽdachi ɨt'ɨɨpa edaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesús k'ĩrapite ak'ɨ nɨ̃bada soldaorã poropa iru mãgá piu wã unuk'ãri, mãgaji: —¡Wãara, na eperã Tachi Ak'õre Warra paji! ");
INSERT INTO sjaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","T'ɨmɨɨpapai ũk'uru wẽraarã p'anadap'edaarãpa ak'ɨ p'anajida: María Magdalena; María, Santiago (chi t'ẽepema) mãik'aapa José nawe; ichiaba Salomé. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea eujãde nipak'ãri, ma wẽraarãpa iru chi k'õp'ãyoorã ome k'aripa nipapachida. Mama ichiaba wẽraarã chok'ara p'anajida iru ome Jerusalendee chedap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma ewate p'ãriupodopa jõmaweda ne-inaa aupa jẽra bait'ee paji ɨ̃ipata ewate pai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José Arimatea p'uurudepema waawee-ee wãji Pilatomaa Jesús k'ap'ɨa piuda iidide ɨait'ee. Mãgɨ́ Junta Supremadepema paji mãik'aapa apemaarã judiorãpa iru pia ak'ɨpachida. Ma awara irua unu k'inia baji Tachi K'aripaparipa ichita eperãarã pia ak'ɨpari. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatopa Jesús piuda k'awaak'ãri, p'eraji isapai piuda perã. Mapa soldaorã poro t'ɨ̃ ataji mãik'aapa iidiji: —¿Wãara piujik'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mãpai Jesús piu bɨda ak'ãri, Pilatopa teeji iru k'ap'ɨa Josemaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mãpai Josepa neto ataji p'aru lienzodee mãik'aapa Jesús k'ap'ɨa kurusodeepa ɨrabai atap'eda, aɨde pɨra bɨji. Maap'eda bɨnaji mãu te uria k'oro iru p'anadap'edaade mãik'aapa chi t'ai t'ap'a bëiji mãu choma bɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María (José nawe), María Magdalena ome ak'ɨ p'anajida sãma ɨaruta. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ɨ̃ipata ewate wãyaap'eda, p'ãrik'ua María Magdalena, María (Santiago nawe) mãik'aapa Salomepa neto atajida k'era Jesús k'ap'ɨade p'urudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tomia ewate, tap'eda weda ak'õrejĩru uchiaruta wãjida iru k'ap'ɨa ɨadap'edaamaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pedee wãjida: —¿K'aipa ãyaa ata bɨyama ajida, mãu choma chi t'aide jɨ̃a bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mamĩda t'ɨmɨ́ weda ak'ɨnadak'ãri, unujida mãu pɨradai bɨ awara ãi. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mãu te uriade edú t'ĩudak'ãri, ununajida k'ũtrãa su-ak'ɨ bɨ ãchi juaraare. Chi p'aru jɨ̃ bada t'o-t'oo teesoo baji. Mãgɨ́ ángel Tachi Ak'õre truadepema paji. Ma wẽraarãpa mãga unudak'ãri, p'eradachida. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mamĩda mãgɨpa mãgaji: —P'eranáatɨ. Parãpa jɨrɨ p'anɨ Jesús Nazaretdepema kurusode baijira bɨdap'edaa. ¡Iru nama wẽ-e! ¡Chok'ai p'irabaijipɨ! Pɨchá, ak'ɨ chétɨ iru ɨadap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wã́tɨ jarade Pedromaa ichiaba chi apemaarã k'õp'ãyoorãmaa: “Iru wãit'ee Galilea eujãdee parã naa. Mama iru unudait'ee irua jaradak'a.” ");
INSERT INTO sjaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mãpai wẽraarã k'ĩra k'awa-ee pɨk'adachida p'era jõnadap'edaa perã. P'ira uchiajida Jesús k'ap'ɨa ɨadap'edaamãiipa. K'ap'ɨa wëree jõnajida waaweepa. Mapa maarepida p'oyaa jarada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tomia ewate Jesús chok'ai p'irabaiji. Naapɨara unupiji María Magdalenamaa. Ma wẽra naaweda netuara siete merãtɨa baji ichi k'ap'ɨade. Mamĩda Jesupa jõmaweda ãyaa uchiapik'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús unup'eda, María Magdalenapa jaranaji iru ome nipapatap'edaarãmaa. Ãra k'ĩsia paraa jarajẽe p'anajida Jesús k'ap'ɨa-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mãga nɨde Mariapa jara cheji: —¡Mɨa Jesús chok'ai unujida! aji. Mamĩda ãrapa mãga ũridak'ãri, ijãada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","T'ẽepai, Jesupa k'ĩra awara unupiji chi k'õp'ãyoorã omeemaa ode nidade. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ãchia iru k'awa atadak'ãri, aramata ãpɨtee nepɨrɨde wãjida apemaarãmaa. Mamĩda ãrapa pida ijãada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","T'ẽepai, Jesupa chok'ai unupiji chi k'õp'ãyoorã oncemaa, nek'omaa p'anɨde. Iru chok'ai bɨ pia ijãadak'aa paji k'ɨɨrɨ k'isua p'anadap'edaa perã. Ma awara apemaarãpa mãga nepɨrɨdap'edaa jida ijãada-e paji. Mapa irua ik'ɨ̃atɨ pedeeji. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ichiaba jaraji ãramaa: —Wã́tɨ na p'ek'au eujã eperãarã paraamaa mãik'aapa jaratéetɨ Tachi Ak'õre pedee pia mɨa k'awapida parãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Apidaapa ma ũraa chiwidide ijãa bɨ pɨrã, poro choopiipia bɨ k'awapiit'ee mɨ ome araa bɨ. Mãgá ɨt'aa wãit'ee ichi piuk'ãri. Jõdee mɨde ijãa-e pɨrã, tok'arradee mianait'ee ichia p'ek'au k'achia ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mɨde ijãa p'anɨɨrãpa oodak'ãri ne-inaa eperãarãpa p'oyaa oodak'aa, awaraarãpa k'awaadait'ee Tachi Ak'õre ãchi ome bɨ. Mɨ t'ɨ̃de netuara uchiapidait'ee; awaraa pedee k'awada-e p'anɨ mĩda, Ak'õre Jaurepa pedeepiit'ee; ");
INSERT INTO sjaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","taama k'achia jitadait'ee ãchi juapa; mãik'aapa neera k'achia todait'ee. Mamĩda mãgee ne-inaapa ãchi maarepida k'achia ooda-e pait'ee. Jõdee ãchi juapa k'ayaa beerã t'õbaidak'ãri, k'ayaa jɨpadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tachi Waibɨa Jesús pedeep'eda chi k'õp'ãyoorã ome, Tachi Ak'õrepa iru ɨt'aa ateeji ichi eujãdee. Mama su-ak'ɨ beeji Ak'õre juaraare, ijãapataarã poro waibɨa perã. ");
INSERT INTO sjaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mãpai chi k'õp'ãyoorãpa Ak'õre Ũraa chiwidi o-ĩa jarateenajida awara ãi eperãarã paraamaa. Jesupa ne-inaa pia oopachi ãchi k'ap'ɨa pari. Mãgá ãchia ne-inaa eperãarãpa oodak'aa oodak'ãri, awaraarãpa k'awaajida Jesús ũraa wãara.");
INSERT INTO sjaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eperãarã poro waibɨa Teófilo, mɨ naa awaraarãpa p'ãjida ne-inaa p'asada tachi t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","P'ãjida Jesús ãchi taupa unudap'edaa mãik'aapa tachimaa irude nepɨrɨdap'edaa. Tachi Ak'õrepa ãra jɨrɨt'eraji mãgá irua ooda jarateepataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mɨa ma p'ãdap'edaa pia ak'ɨji. Ma awara ãramaa mãik'aapa Jesús unudap'edaarã awaraarãmaa iidi wãji. Mãgá Jesús t'odadeepa p'asada pia k'awaaji. Eperãarã poro waibɨa Teófilo, ");
INSERT INTO sjaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ma jõmaade k'ĩsiap'eda, mɨa nãga p'ã bɨ, pɨa ma wãara pedee jarateedap'edaa pipɨara k'awaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesús t'oi naaweda Herodes rey paji Judea eujãde. Mama bapachi p'aare t'ɨ̃jarapatap'edaa Zacarías. Iru p'aare Abías eere p'anadap'edaarãdepema paji. Chi wẽra, Isabel, ichiaba chonaarãwedapema p'aareerã poro waibɨa Aarondeepa uchiada paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías chi wẽra ome k'achia wẽe p'anapachida Tachi Ak'õre k'ĩrapite, iru ũraade jara bɨk'a oopachida perã. Maperã apidaapa ãra p'oyaa ɨmɨateedak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mamĩda ãra warra wẽe p'anajida, Isabel warra t'ok'aa pada perã. Ma awara ãchi omee weda audú chonaa p'anajida warra oodait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ewari aba p'aareerã poroorãpa jarajida Abías eerepema p'aareerã mimia p'aneedamerã Tachi Ak'õre te waibɨade. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","P'aareerãpa oopatak'a suerte jemenejida k'awaadait'ee k'aita t'ĩut'ee Tachi Ak'õre te waibɨa edupema cuartode ne-inaa t'ũa bapari paade. Mãgá Zacariata uchiaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","T'ĩuji ma ne-inaa t'ũa bapari paade. Mãga oomaa bɨ misa, eperãarã jõmaweda taawa ɨt'aa t'ɨ̃ para baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías mama te jãde bɨde ɨt'aripema angelpa ichi unupiji. Bainɨ̃ baji ma ne-inaa t'ũa bapari paapata altar juaraare. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacariapa mãga unuk'ãri, p'eradachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mamĩda ma angelpa mãgaji: —Zacarías, waaweenaapáde aji. Tachi Ak'õrepa pɨa ɨt'aa iidida ũrijipɨ. Pɨ wẽra Isabelpa warra t'oit'ee. T'ɨ̃ bɨit'eeda aji, Juan. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Parã o-ĩ-ĩa p'anadait'ee iru ome. Ichiaba eperãarã chok'ara o-ĩa p'anadait'ee iru t'oda k'awaadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pɨ warra waibɨa pait'ee Tachi Ak'õre k'ĩrapite. Maarepida it'ua, vino jida tok'aa pait'ee. Iru t'oi naaweda, Tachi Ak'õre Jaure bapariit'ee iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Irua Israel pidaarã chok'araarãmaa waya ijãapiit'ee Tachi Ak'õrede. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na Juanpa Ak'õre pedee jaranait'ee, Tachi Waibɨa chei naaweda. Audú Ak'õrede ijãapariit'ee. Ne-inaa ooit'ee Tachi Ak'õre juapa mãik'aapa sõcharra bait'ee Ak'õre pedee jarapari Elías chonaarãweda bapatak'a. Ak'õreerãmaa k'ĩsiapiit'ee ãchi t'ãri auk'a bɨdamerã ãchi warrarã ome. T'ãri k'achia beerãmaa jarateeit'ee oo k'awaa wãdamerã Ak'õrepa oopi bɨk'a. Mãga oo bɨpa Israel pidaarã k'aripait'ee Tachi Waibɨa k'awaadamerã mãik'aapa irude ijãapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mãga ũrik'ãri, Zacariapa ma angelmaa iidiji: —¿Sãga mɨa pɨ pedee ijãayama? aji. Mɨ audú chonaa bɨda aji, warra ooit'ee; mɨ wẽra jida. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mãpai angelpa mãgaji: —Mɨ Gabrielda aji. Tachi Ak'õrepa jararuk'a mɨa ooparida aji. Irua mɨ pëiji pɨ ome pedeede mãik'aapa pɨmaa ma pedee pia jarade. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mamĩda pɨa mɨ pedee ijãa-e pada perã, ɨ̃raweda pɨ p'oyaa pedee-ee beeit'eeda aji, mɨa jaradak'a parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías mãgá edú bɨ misa, eperãarã taawa ɨt'aa t'ɨ̃ para badaarãpa k'ĩsia p'aneejida: “¿Sãgap'edapɨ taarãruma?” apachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías uchiak'ãri, p'oyaa pedeek'aa paji. Jĩp'a juapa jarapachi. Mapa ma eperãarãpa k'awaajida irua k'ãimok'araa pɨk'a bɨde ne-inaa unuda Ak'õre te waibɨade. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacariapa ichi mimia Ak'õre te waibɨade aupak'ãri, ichi temaa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","T'ẽepai chi wẽra Isabel biak'oo beeji. Atane joisomaa wãyaaru misa, uchia-e paji ichi tedeepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","K'ĩsiaji: “Tachi Ak'õrepa mɨmaa ne-inaa pia ooji. Mɨ k'ĩra nejasia bapachi, biak'ook'aa pada perã. Mamĩda irua mɨ chupɨria k'awaada perã, ɨ̃rá mɨ biak'oo bɨda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Atane seismaa Isabel biak'ooda, Tachi Ak'õrepa ichi ángel Gabriel pëiji Galilea eujãdepema p'uuru Nazaretdee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mama bapachi awẽra waide ɨmɨk'ĩra ome k'ãi-ee. T'ɨ̃jarapachida María. Mama ichiaba bapachi ɨmɨk'ĩra t'ɨ̃jarapatap'edaa José. Ichi chonaarãwedapema Rey Daviddeepa uchiada paji. María José ome pedeetee p'anajida miak'ãidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel cheji Mariamaa mãik'aapa mãgaji: —¡Pia baparíiji! Tachi Ak'õrepa pɨ piara ak'ɨpari awaraarã k'ãyaara. Iru pɨ ome bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mãga ũrik'ãri, María p'era pɨk'a beeji mãik'aapa k'ĩsiaji: “¿Sãap'edata mɨmaa mãga jara cheruma?” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mãpai Gabrielpa mãgaji: —María, waaweenaapáde aji. Tachi Ak'õrepa pɨ jɨrɨt'eraji k'inia iru bairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pɨ biak'oo beeit'ee mãik'aapa ɨmɨk'ĩra warra t'oit'ee. T'ɨ̃ bɨit'ee Jesús. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iru Tachi Waibɨa pait'ee. Tachi Ak'õre Warrada adait'ee. Tachi Ak'õre Waibɨapa iru rey papiit'ee, iru chonaarãwedapema Rey Davidk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iru ichita Jacobdeepa uchiadap'edaarã rey pait'ee, na p'ek'au eujã jõru pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mãpai Mariapa iidiji ma angelmaa: —Mamĩda, ¿sãga biak'ooyama aji, mɨ ɨmɨk'ĩra ome k'ãi-ee bɨta? ");
INSERT INTO sjaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabrielpa p'anauji: —Pɨ biak'oo-e pait'ee awaraa wẽraarãk'a. Ak'õre Jaure pɨ ome bait'ee. Tachi Ak'õrepa ne-inaa jõmaata oopari. Iru Jaurepa pɨ aneu pɨk'a cheit'ee jɨ̃ararak'a. Mãgá ɨmɨk'ĩra wẽe bɨ mĩda, biak'oo beeit'ee. Ak'õrepa mãga ooit'ee perã, pɨ warra k'achia wẽe bapariit'ee. Iru Tachi Ak'õre Warrada apataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma awara pɨchi ëreerã Isabel, chõtrãa k'ɨrɨ mĩda, atane seis iru bɨ biak'ooda. Iru warra t'ok'aada apachida mĩda, ɨmɨk'ĩra warrata t'oit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tachi Ak'õrepa mãga ooi, wẽ-e perã ne-inaa irua p'oyaa oo-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mãpai Mariapa mãgaji: —Mɨ Tachi Ak'õre jua ek'ari bapari. Irua jara bɨk'a ooipia bɨda aji, mɨ ome. Maap'eda Gabriel wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma t'ẽepai María wãji Isabel bada p'uurudee ee jẽra bɨmãi Judea eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarías temãi panak'ãri, Mariapa Isabelmaa saludaaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabelpa María pedee ũrik'ãri, chi chai o-ĩapa jɨ̃tɨ jira beeji iru bide. Mãpai Tachi Ak'õre Jaure ba cheji Isabel ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mapa golpe pedeeji: —Tachi Ak'õrepa pɨta pipɨara ak'ɨ bɨda aji, awaraa wẽraarã k'ãyaara. Irua pɨ warra bide bɨ pia ak'ɨ bapariit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mɨ ek'ariara bɨ mĩda Tachi Ak'õre k'ĩrapite, mɨ o-ĩa bɨ, pɨ, Mɨchi Waibɨa nawepa mɨ ak'ɨ cheda perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pɨ salude ũriruta mɨ warra o-ĩapa jɨ̃tɨ jira beeji mɨ bide. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Pɨ o-ĩa bɨ ijãada perã Tachi Ak'õrepa ooit'ee ichia jara pëidak'a! ");
INSERT INTO sjaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mãpai Mariapa mãgaji: —T'ãripa mɨa jara bɨ: Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mɨchi t'ãride o-ĩa nɨ̃bɨ, Tachi Ak'õrepa mɨ o k'achiadeepa k'aripa atapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mɨ chupɨria k'ɨrɨ mĩda iru esclavak'a, irua mɨ jɨrɨt'eraji mãik'aapa t'ãri o-ĩapiji. Mapa ɨ̃raweda jõmaarãpa mɨ t'ɨ̃jaradait'ee chi Tachi Ak'õrepa t'ãri o-ĩapida. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","¡Tachi Ak'õre Waibɨa t'ɨ̃jarapata Chi K'achia Wẽe Bapari! Iruata ne-inaa pi-ia ooji mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tachi Ak'õrepa chupɨria k'awaapari ichide ijãapataarã; ãchi warrarã; ãichak'eerã paara. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne-inaa pi-ia oodoo ichi juapa. T'ãride audua beerã jërek'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Reyrã uchiapiji ãchi mimiadeepa mãik'aapa ãra k'ãyaara audua-ee beerã poro waibɨarã papiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jarrapisia beerã irumaa chedak'ãri, ne-inaa pia teeji k'ãiwee nipadamerã ichi ode. Jõdee net'aa piara iru p'anadap'edaarã arajãgaa wãpiji ãchi ode. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tachi Israel pidaarã, ichi eperãarã k'aripapachi ichia oopi bɨk'a oopatap'edaa perã. Ãra ichita chupɨria k'awaaji ");
INSERT INTO sjaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","mãga ooit'eeda ada perã tachi chonaarãmaa; Abrahammaa mãik'aapa irudeepa uchiadait'eerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María Isabelmãi atane õpee beeji. Maap'eda cheji ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabel warra t'ok'ãri, ɨmɨk'ĩra warrata t'o ataji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ãchi te k'ait'a p'anapatap'edaarãpa mãik'aapa ãchideerãpa k'awaadak'ãri Tachi Ak'õrepa mãgá ãchi k'aripada, ãramaa chejida pedee pia jarade. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Warra t'op'eda, k'ãima ocho pak'ãri, iru k'ap'ɨade tauchaa bɨpijida. Arii p'anadap'edaarãpa t'ɨ̃ bɨdait'ee paji Zacarías, chi ak'õrek'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamĩda chi nawepa mãgaji: —Mãga-e. Iru t'ɨ̃ bɨdait'ee Juan. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mãpai mãgajida: —Parãdeerã apidaamaa ma t'ɨ̃ bɨda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mãpai juapa jarajida chi ak'õremaa, chi warra t'ɨ̃ k'awaadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mãpai Zacariapa juapa jaraji ichi-it'ee tabla pite aneedamerã mãik'aapa aɨde p'ãji: Iru t'ɨ̃ bɨit'ee Juan. Mãga unudak'ãri, eperãarã jõmaweda ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aramata Zacarías pedee uchiaji mãik'aapa Tachi Ak'õrede pia pedeeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jõmaweda iru k'ait'a p'anapatap'edaarã ak'ɨtrua para beeji mãik'aapa mãgɨ́ p'asada pia t'opachida jõmaweda eperãarã eede p'anapataarãmãi Judea eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mãga ũridak'ãri, jõmaarãpa k'ĩsia p'anapachida ãchi t'ãridepai: “¿K'ãata ooit'eepaama ajida, ma warrapa?” ¿Chonaa pak'ãri, eperã waibɨa pait'ee-epaa? ¿Wãara Tachi Ak'õre iru ome bapariit'ee-epaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mãpai Tachi Ak'õre Jaure ba cheji Zacarías ome. Mapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—¡Tachi Ak'õre, tachi Israel pidaarã Ak'õre Waibɨa t'ãri pia bapari, ichi p'uuru pidaarã k'aripa cheda perã! ");
INSERT INTO sjaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ichi mimiapari Daviddeepa uchiada pëiji Tachi K'aripa Atapari bamerã. Mãgɨ́ jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chonaarãweda mãgɨde pedeepachi ichi pedee jarapataarã k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jaraji mãgɨpa tachi k'aripa atait'ee tachi k'ĩra unuamaa iru p'anapataarã juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ichiaba jaraji mãgɨpa tachi chonaarã chupɨria k'awaait'ee mãik'aapa ooit'ee irua jaradak'a ãra poro waibɨarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","K'irãpaji ichi pedee jarada ichi t'ɨ̃ waibɨade tachi ak'õchona Abrahammaa: ");
INSERT INTO sjaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","K'aripait'ee tachi k'ĩra unuamaa iru p'anapataarã juadeepa, waawee-ee oopataadamerã irua oopi bɨk'a iru jua ek'ari p'anɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","K'aripait'ee chok'ai p'anɨde k'achia wẽe p'anapataadamerã iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mamĩda warra, pɨ t'ɨ̃jaradait'eeda aji, Ak'õre Waibɨa pedee jarapari. Tachi Waibɨa naa jarateenait'ee, eperãarãpa iru pedee ũri k'inia p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jarait'ee Tachi Ak'õrepa eperãarãpa p'ek'au k'achia oopata wẽpapipari mãik'aapa ãra o k'achiadeepa k'aripa atapari atuanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tachi Ak'õrepa tachi chupɨria k'awaapari perã, aba ak'õrejĩruk'a urua bɨ ɨt'ariipa pëiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mãgɨ́ ɨ̃daa pɨk'a bait'ee na p'ek'au eujãdepema p'ãriu pɨk'a p'anɨɨrã atuadait'eerã t'ãide. Tachi Ak'õre o ak'ɨpiit'ee, aɨde tachi nipapataadamerã mãik'aapa k'ãiwee p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zacarías warra wari wãji mãik'aapa audú ijãa beeji Tachi Ak'õrede. K'ũtrãa pak'ãri, banaji eujã pania wẽe bɨde Israel pidaarãmaa jarateemaa beerumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Juan at'ãri ma-ãri bak'ãri, César Augusto Romadepema reyrã poro waibɨa paji Romadepemaarã eujãde, ichiaba awaraa eujã iru jua ek'ari badade. Cirenio ichi jua ek'ari baji. Mãgɨpa Siria eujã ak'ɨpachi. Maapai eperãarã ichi truadepema jõmaweda t'ɨ̃ p'ãpiji k'awaait'ee jõmasaa p'anɨ. Mãgɨ́ chi naapema t'ɨ̃ p'ãpida paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mãgá eperãarã juasiadak'ãri, jõmaweda wãpijida ãchi chonaarã p'uurudee t'ɨ̃ p'ãpide. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Maperã José uchiaji Galilea eujãdepema Nazaret p'uurudeepa wãit'ee Judea eujãdee. Ichi chonaarãwedapema Rey Daviddeepa uchiada perã, wãji David t'oda p'uuru Belendee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mamaa wãji ichi t'ɨ̃ p'ãpide María ome, ichi wẽra pait'ee bada perã. Uchiadak'ãri, María warra t'oyama baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belende panadak'ãri, María bi p'ira nɨ̃beeji chi warra t'oit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mamĩda te unuda-e paji, araada-e pada perã jõmaweda t'ɨ̃ p'ãpi chedap'edaarã-it'ee. Mapa mama Belende chi warra naapema t'oji, ne-animalaarã nek'opata tede. Chi warra p'arude pɨra atap'eda, bɨji ne-animalaarã nek'opatade k'ãimerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma p'ãrik'ua Belén k'ait'a p'ũajara paraamãi eperãarãpa ãchi ovejaarã ak'ɨmaa p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mãga nɨde angelpa ichi unupiji mãik'aapa Tachi Ak'õre k'ĩra wãree ɨ̃daadachi ãchi ik'aawa. Mapa p'eradachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mamĩda ma angelpa mãgaji: —P'eranaadapáde aji, mɨa pedee pia jara cheru perã. Mɨa nepɨrɨru k'aurepa eperãarã jõmaweda audú o-ĩa p'aneedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Idi p'ãrik'ua Rey David t'oda p'uurude t'oji eperãarã o k'achiadeepa k'aripa atapari. Iru Tachi Waibɨa, Tachi Ak'õrepa pëida eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jɨrɨnadapáde aji. Ununadak'ãri ɨmɨk'ĩra warra p'arude pɨra bɨ ne-animalaarã nek'opatade, k'awadayada aji, mɨa wãarata jarada. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aramata unujida ɨt'aripema angeleerã cho-k'ara chi apema ik'aawa para bɨ. Jõmaarãpa o-ĩa ɨt'aa t'ɨ̃ para beeji. Mãgapachida: ");
INSERT INTO sjaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Tachi Ak'õre ɨt'ari bɨta jõmaarã k'ãyaara waibɨara bɨ! ¡Irua pia ak'ɨ bɨɨrã t'ãri o-ĩa p'anapata mãik'aapa k'ãiwee p'anapata! ");
INSERT INTO sjaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ma angeleerã jõmaweda wãdak'ãri Ak'õre eujãdee, ma oveja ak'ɨpataarãpa mãga jõnapachida: —Wãdáma apachida Belendee, Ak'õrepa jara pëida ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mãpai isapai wãjida. Wãara ununajida María José ome mãik'aapa María warra k'ãi bɨ ne-animalaarã nek'opatade. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mãga unudap'eda, nepɨrɨnajida ma angelpa jarada ma warrade. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jõmaweda ãra pedee ũridap'edaarã ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mamĩda ma jõmaade Mariapa ichi t'ãridepai k'ĩsiaji. K'ĩra atuak'aa paji ãrapa jaradap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jõdee ma oveja ak'ɨpataarã o-ĩa wãjida ãchi p'anadap'edaamaa. Wãk'ãtɨ wãdapa mãgapachida: —Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. Iru t'ãri pia bɨ. Jõma unujida irua jara pëidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma warra t'op'eda, ewari ochomaa iru k'ap'ɨade tauchaa bɨjida mãik'aapa t'ɨ̃ bɨjida Jesús, María biak'oo beei naaweda, angelpa jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ewari cuarenta wãyaak'ãri, wãjida Jerusalendee oodait'ee Moisepa p'ãdade jara bɨk'a, t'ĩu pia p'aneedait'ee Ak'õre te waibɨade. María k'ap'ɨa pari oojida Ak'õre Ũraa p'ãdade jara bɨk'a wẽraarãpa oodamerã warra t'op'eda: ‘Peepidap'eda, paapidaipia bɨ tortola omé maa-e pɨrã paloma chak'eerã omé.’ Ichiaba chi warra awara bɨjida Tachi Ak'õre-it'ee Moisepa p'ãdade jara bɨk'a: ‘Israel pidaarãpa ãchi warrarã naapemaarã awara bɨdaipia bɨ Tachi Ak'õre-it'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Maapai Jerusalende bapachi chonaa aba t'ɨ̃jarapatap'edaa Simeón. Iru Tachi Ak'õrede ijãapachi mãik'aapa oopachi irua oopi bɨk'a. Ijãapachi Tachi Ak'õrepa Israel pidaarã k'aripait'ee ãchi k'ĩra unuamaa iru p'anapatap'edaarã juadeepa. Tachi Ak'õre Jaure bapachi Simeón ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iruata k'awapiji Simeón piu-e pait'ee unui naaweda Cristo, Tachi Ak'õrepa pëida eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma ewate Ak'õre Jaurepa iru wãpiji Tachi Ak'õre te waibɨadee. Mãga nɨde Jesús ak'õreerã wãjida mamaa. Oomaa p'anajida Moisepa p'ãdade jara bɨk'a oodamerã ãchi warra ewaa t'oda ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónpa ãra unuk'ãri, ma warra chai jira ataji mãik'aapa t'ãri o-ĩa mãgaji Tachi Ak'õremaa: ");
INSERT INTO sjaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Ak'õre, jõmaarã Ak'õre Waibɨa, ɨ̃rá mɨ, pɨ mimiapari, k'ãiwee piut'ee, pɨa eperã jaradak'a unuru perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mɨchi taupa unuru Tachi K'aripapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pɨa na ɨmɨk'ĩra warra pëiji pɨ o ak'ɨpimerã na p'ek'au eujãdepemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iru ɨ̃daa pɨk'a bɨ k'aurepa judio-eerãpa paara pɨ o k'awaadait'ee mãik'aapa iru k'aurepa eperãarãpa Israel pidaarã t'o p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón pedee ũridak'ãri, Jesús ak'õreerã p'era pɨk'a p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mãpai Simeónpa iidiji Ak'õrepa ãra pia ak'ɨ bapariimerã mãik'aapa Mariamaa mãgaji: —Pɨ warra k'aurepa Israel eujãdepemaarã chok'ara ɨt'aa wãdait'ee mãik'aapa chok'ara atuadait'ee. Ichiaba chok'araarãpa jaradait'ee Tachi Ak'õrepa iru pëi-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mãgá Tachi Ak'õrepa k'awaapiit'ee eperãarãpa k'ĩsiapata ãchi t'ãridepai; wãara irude ijãa p'anɨ maa-e pɨrã ijãada-e p'anɨ. Mamĩda ma jõmaade pɨ t'ãri p'ua nɨ̃bait'ee, espadapa pɨ t'ãride su atarutak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","P'ẽtrãa t'ɨ̃jarapatap'edaa Ana ichiaba mama baji. Tachi Ak'õre pedee jarapari paji. Chi ak'õre Aser ëreerãdepema paji. T'ɨ̃jarapachida Penuel. Awẽra weda Ana miak'ãiji. Mamĩda siete añopai baji chi ɨmɨk'ĩra ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mamãik'aapa p'ẽtrãa beeji ochenta y cuatro años parumaa. Ak'õre te waibɨade bapachi. Ewari chaa ɨt'aa t'ɨ̃pachi. Edaare nek'ok'aa paji ɨt'aa t'ɨ̃ k'iniapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón pedee auparude Ana uchiaji. José mãik'aapa María unuk'ãri ma warra ome, Tachi Ak'õremaa gracias jaraji iru pari. Mãpai arii p'anadap'edaarãmaa jarapachi: —Na warrata tachi Jerusalén pidaarãpa nɨ p'anɨ tachi k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José María ome ne-inaa jõma oo aupadak'ãri Moisepa p'ãdade jara bɨk'a, waya chejida Galilea eujãdee ãchi p'uuru Nazaretde. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ãchi warra juatau chaareera wari wãpachi mãik'aapa k'ĩsia k'awaara wãpachi. Ichiaba Tachi Ak'õre o-ĩa baji iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Año chaa Jesús ak'õreerã wãpachida Jerusalén p'uurudee Pascua fiesta oode. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce años iru bak'ãri, mãga oojida mãik'aapa iru auk'a wãji ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ma fiesta jõdaik'ãri, eperãarã erreujida ãchi te chaa. Mamĩda Jesús Jerusalende beeji, chi ak'õreerãpa k'awada-ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ode wãdade chi ak'õreerãpa k'awada-e paji, chok'ara cheepuru wãdap'edaa perã. K'ĩsia p'anajida Jesús cheru apemaarã ome. Mapa k'ewara iidipachida ãchi ëreerãmaa mãik'aapa k'ĩra k'awaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mamĩda unuda-e pak'ãri, ãpɨtee jɨrɨnajida Jerusalende. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","K'ãima õpeemaa ãchi warra unu atajida Ak'õre te waibɨade. Su-ak'ɨ baji Moisepa p'ãda jarateepataarã esajĩak'a. Mãɨrãpa jaratee p'anɨ ũrii bap'eda, iidipachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Arii p'anadap'edaarã jõmaarãpa iru pedee ũridak'ãri, ak'ɨtrua para beepachi, poro wẽsaa bada perã mãik'aapa pia p'anaupata perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mamĩda chi ak'õreerãpa iru mãgá unudak'ãri, p'era pɨk'a p'aneejida. Mãpai chi nawepa mãgaji: —Warra, ¿sãap'eda nãga oojima? aji. Taipa pɨ unuda-e pak'ãri, k'ĩsia p'ua jõnajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mãpai Jesupa mãgaji: —¿Sãap'eda mɨ jɨrɨ p'anɨma? aji. ¿K'awada-eta p'anɨk'ã aji, mɨ Ak'õre tede ichita bait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mamĩda ãrapa k'awada-e paji ma pedee k'ãata jara k'inia baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mãpai iru wãji ãra ome Nazaret p'uurudee. Mama ãra ome chok'ek'ee bapachi. Mamĩda Mariapa irua ooda k'ĩra atuak'aa paji. Ichi t'ãridepai ma ne-inaa jõmaweda audú k'ĩsiapachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mãgá Jesús wari wãpachi. Ichiaba k'ĩsia k'awaapɨara wãpachi, Tachi Ak'õrepa iru pia ak'ɨ bada perã, eperãarãpa pida ichiaba. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","César Tiberio quince años rey bɨde, ichi ek'ari bada Poncio Pilato Judea eujã ak'ɨpari paji. Jõdee judiorã Tiberio ek'ari reyrãk'a p'anadap'edaarãpa eujã awara-awaraa ak'ɨpachida. Herodepa Galilea eujã ak'ɨpachi. Chi ɨ̃pema Filipopa Iturea mãik'aapa Traconite eujã ak'ɨpachi. Jõdee Lisaniapa Abilene eujã ak'ɨpachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás mãik'aapa Caifás p'aareerã poro waibɨarã paji. Maapai Tachi Ak'õrepa ichi pedee jara cheji Zacarías warra Juanmaa eujã pania wẽe bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Maap'eda Juanpa Tachi Ak'õre pedee jaratee nipapachi jõma Jordán tode. Jarateepachi eperãarãpa ichimaa poro choopidamerã ak'ɨpidait'ee ãchia p'ek'au k'achia oopata oodaamaa p'anɨ mãik'aapa wãara Tachi Ak'õrede ijãa p'anɨ. Mãgá ijãadak'ãri, Tachi Ak'õrepa ãchia p'ek'au k'achia oopata wẽpapii. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mãga p'asaji Ak'õre pedee jarapari Isaíapa chonaarãweda jaradak'a: ‘Eujã pania wẽe bɨde eperã bia bɨ: “O pi-ia oopatak'a poro waibɨa chei naaweda, mãga pɨk'a p'ek'au k'achia oo amáatɨ Tachi Waibɨa chei naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iru k'aurepa eujã joobai beeda jewedaa beeit'ee mãik'aapa ee nok'o jida jewedaak'oodariit'ee. O jõmaweda jĩp'a beeit'ee mãik'aapa eujã mãu-idaa bɨ k'ak'ayaa beeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Maapai jõmaarãpa k'awaadait'ee iru k'aurepa Ak'õrepa eperãarã k'aripait'ee atuanaadamerã.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juanpa mãgá jaratee bɨde eperãarã chok'ara chejida irua poro choomerã. Mamĩda Juanpa ãramaa mãgaji: —¡Parã k'achia-idaa beerãdeepa uchiadap'edaarã! ¡Taamák'apɨ p'anɨ! ¿Poro choopi chejida-ek'ã, Tachi Ak'õre juapa mia k'iniada-e p'anadairã? ");
INSERT INTO sjaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mãga pɨrã, p'ek'au k'achia oo amáatɨ mãik'aapa p'anapatáatɨ Tachi Ak'õrepa k'inia bɨk'a. K'ĩsianáatɨ Tachi Ak'õrepa parãta miapi-e pait'ee Abrahamdeepa uchiadap'edaa perã. Mɨa jara bɨ: Na mãudeepa Tachi Ak'õrepa Abrahamdeepa uchiadap'edaarã oo atai. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ara chaarapa nejõ bɨɨrɨ chauk'aa bɨ t'u peet'aapatak'a t'ɨpɨtaude bat'at'aadait'ee paa jõmerã, mãga pɨk'a taarã-e Tachi Ak'õrepa jõpiit'ee parã, chi oodaamaa p'anapataarã irua k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mãga ũridak'ãri, eperãarãpa Juanmaa iidipachida: —Mãgara, ¿k'ãata oodaipia bɨma apachida, ak'ɨpidait'ee tai Ak'õre ode nipapata? ");
INSERT INTO sjaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanpa p'anauji: —Chi p'aru omé iru bɨpa aba chi wẽe bɨmaa teeipia bɨda aji. Auk'a chik'o jede k'odaipia bɨda aji, chi wẽe beerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Cesar-it'ee impuesto p'epataarã ichiaba chejida poro choopide. Mãgajida: —Tachi Jarateepari, ¿k'ãata oodaipia bɨma ajida, ak'ɨpidait'ee taipa p'ek'au k'achia oopata oo amaa k'inia p'anɨ? ");
INSERT INTO sjaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanpa p'anauji: —P'aapináatɨ Romadepemaarãpa jarapata impuesto ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldaorãpa ichiaba iidijida: —¿Mãgara taipárama? ajida. ¿K'ãata oodaipia bɨma taipa ak'ɨpidait'ee p'ek'au k'achia oopata oo amaa k'inia p'anɨ? Juanpa p'anauji: —Ichi k'inia chĩara p'arat'a jãri atanáatɨ mãik'aapa seewa jaranáatɨ chĩara k'achiade baaipidait'ee. K'ãiwee p'anapatáatɨ parãmaa p'arat'a p'aapata ome pãchi mimiapata pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eperãarãpa Juanpa jarateeda ũridak'ãri, ãchi t'ãridepai k'ĩsia p'aneejida: “¿Juan Cristopaa ajida, Tachi Ak'õrepa pëida tachi rey pamerã?” ");
INSERT INTO sjaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mamĩda Juanpa jõmaarãmaa mãgaji: —Mɨa wãara parã poro chooparida aji, paniapa. Mamĩda eperã mɨ t'ẽe cheru mɨ k'ãyaara waibɨara bɨ. Mɨa iru chancla jida ẽraik'araa bɨ, iru k'ãyaara ek'ariara bairã. Irua eperãarã nãgá poro chooit'ee. Tachi Ak'õre Jaure ba chepiit'ee parã k'ap'ɨade. Mamĩda ichide ijãadak'aa beerã jõpiit'ee t'ɨpɨtaupa. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ooit'ee trigo ewaparipa ooparik'a. Mãgɨpa pala aneek'ãri, trigo ewada ɨt'aa jira bat'apari, chi tau uchiamerã mãik'aapa nãupa chi e ãyaa ateemerã. Maap'eda ma trigo tau ɨa bɨpari chi ɨapatamãi. Mamĩda chi e beeda t'ɨpɨtaude bat'at'aapari. Mãgɨ́ t'ɨpɨtau k'ĩik'aada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mãgá awaraa ũraa chok'ara ome, Juanpa jarateepachi Ak'õrepa pedee pia jara pëida. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mamĩda mãga jaratee ni misa, ɨtrɨaji Romadepemaarãpa rey bɨdap'edaa, Herodes. Mãga ooji Herodepa chi ɨ̃pema wẽra Herodías iru bada perã ichi wẽrak'a mãik'aapa awaraa ne-inaa k'achia k'ĩra t'ãdoo oopachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma t'ẽepai Herodepa awaraa ne-inaa k'achia ooji. Juan carcelde t'ɨ nɨ̃bɨpiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mamĩda aɨ naaweda, Juanpa at'ãri eperãarã poro choomaa bɨde ichiaba Jesús poro chooji. Poro choopip'eda, Jesús ɨt'aa t'ɨ̃k'ãri, pajã ewadachi ");
INSERT INTO sjaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mãik'aapa Tachi Ak'õre Jaure iru ɨ̃rɨ palomak'a baai cheji. Mãga nɨde ɨt'ariipa Tachi Ak'õrepa jaraji: —Pɨda aji, mɨ Warra k'inia, mɨa jɨrɨt'erada. Pɨa mɨ t'ãri o-ĩapipari. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesupa mãgá ne-inaa oo beek'ãri eperãarã taide, treinta años iru baji. Eperãarãpa jĩp'a k'ĩsia p'anapachida iru José warra. José ak'õre paji Elí. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ak'õre paji Matat. Matat ak'õre paji Leví. Leví ak'õre paji Melquí. Melquí ak'õre paji Janai. Janai ak'õre paji José. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ak'õre paji Matatías. Matatías ak'õre paji Amós. Amós ak'õre paji Nahúm. Nahúm ak'õre paji Eslí. Eslí ak'õre paji Nagai. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ak'õre paji Máhat. Máhat ak'õre paji Matatías. Matatías ak'õre paji Semeí. Semeí ak'õre paji Josec. Josec ak'õre paji Joiadá. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joiadá ak'õre paji Johanán. Johanán ak'õre paji Resá. Resá ak'õre paji Zorobabel. Zorobabel ak'õre paji Salatiel. Salatiel ak'õre paji Nerí. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerí ak'õre paji Melquí. Melquí ak'õre paji Adí. Adí ak'õre paji Cosam. Cosam ak'õre paji Elmadam. Elmadam ak'õre paji Er. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ak'õre paji Jesús. Jesús ak'õre paji Eliézer. Eliézer ak'õre paji Jorim. Jorim ak'õre paji Matat. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ak'õre paji Leví. Leví ak'õre paji Simeón. Simeón ak'õre paji Judá. Judá ak'õre paji José. José ak'õre paji Jonam. Jonam ak'õre paji Eliaquim. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ak'õre paji Meleá. Meleá ak'õre paji Mená. Mená ak'õre paji Matatá. Matatá ak'õre paji Natán. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ak'õre paji David. David ak'õre paji Jesé. Jesé ak'õre paji Obed. Obed ak'õre paji Booz. Booz ak'õre paji Salmón. Salmón ak'õre paji Nahasón. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasón ak'õre paji Aminadab. Aminadab ak'õre paji Admín. Admín ak'õre paji Arní. Arní ak'õre paji Hesrón. Hesrón ak'õre paji Fares. Fares ak'õre paji Judá. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ak'õre paji Jacob. Jacob ak'õre paji Isaac. Isaac ak'õre paji Abraham. Abraham ak'õre paji Térah. Térah ak'õre paji Nahor. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ak'õre paji Serug. Serug ak'õre paji Ragau. Ragau ak'õre paji Péleg. Péleg ak'õre paji Éber. Éber ak'õre paji Sélah. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélah ak'õre paji Cainán. Cainán ak'õre paji Arfaxad. Arfaxad ak'õre paji Sem. Sem ak'õre paji Noé. Noé ak'õre paji Lámec. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámec ak'õre paji Matusalén. Matusalén ak'õre paji Enoc. Enoc ak'õre paji Jared. Jared ak'õre paji Mahalaleel. Mahalaleel ak'õre paji Cainán. ");
INSERT INTO sjaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ak'õre paji Enós. Enós ak'õre paji Set. Set ak'õre paji Adán mãik'aapa Adán ak'õre paji Tachi Ak'õre. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ak'õre Jaure Jesús ome bapachi mãik'aapa irua Jesús wãpiji Jordán todeepa eujã pania wẽe bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mama baji k'ãima cuarenta. Mãga nɨde Netuara Poro Waibɨapa ne-inaa k'achia oopi k'inia baji Jesumaa. Mama bɨde Jesús nek'o-ee bada perã, jarrapisia nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mãpai Netuara Poro Waibɨapa mãgaji: —Wãara pɨ Tachi Ak'õre Warra pɨrã, na mãu pan papit'aapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesupa p'anauji: —¡Oo-eda! aji. Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Eperã chik'o k'o bɨpapai chok'ai bak'aa. Tachi Ak'õre pedee k'awa bɨpa ichita chok'ai bapari.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maap'eda Netuara Poro Waibɨapa iru ee ɨt'ɨara bɨ nok'ode ateeji. Jõmaweda na p'ek'au eujãdepema p'uuru ak'ɨpiji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Mɨa pɨ jã p'uurudepemaarã poro waibɨa papiyada aji. Ãchi net'aa pia jõmaweda përé papii. Mëré perã chi tee k'inia bɨmaa teei. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mɨ k'ĩrapite bedabaip'eda, mɨmaa ɨt'aa t'ɨ̃rura, jõmaweda përé payada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesupa p'anauji: —¡Oo-eda! aji. Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Tachi Ak'õre Waibɨamaa aupai ɨt'aa t'ɨ̃patáatɨ mãik'aapa jĩp'a oopatáatɨ irua jara bɨk'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","T'ẽepai Netuara Poro Waibɨapa iru ateeji Jerusalén p'uurudee. Mama Tachi Ak'õre te waibɨa ek'arra ɨ̃rɨ ɨt'ɨ́ ateeji mãik'aapa mãgaji: —Wãara pɨ Tachi Ak'õre Warra pɨrã, namãik'aapa jɨ̃tɨdaipáde aji, ");
INSERT INTO sjaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tachi Ak'õre Ũraa p'ãdade jara bairã: ‘Ak'õrepa ichi angeleerã pëiit'ee pɨ k'aripadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ãchia pɨ jita atadait'ee mãik'aapa pɨ t'ɨdɨk'adait'ee, pɨchi bɨɨrɨ pida mãumaa p'u oopiamaapa.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesupa p'anauji: —¡Jɨ̃tɨ-eda! aji. Ichiaba Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Ne-inaa pariatua oonáaji k'awaait'ee wãara Tachi Ak'õre Waibɨapa tachi ak'ɨpari wa mãga-e.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Netuara Poro Waibɨapa p'oyaa-e pak'ãri Jesús ome, atabëiji awaraa ewaride cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús wãji Galilea eujãdee. Ne-inaa jõmaweda oopachi Ak'õre Jaurepa oopi bɨk'a. Maperã iru t'opachida ma eujã jõmaade. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Irua jarateepachi Ak'õre Ũraa jarateepata tede p'uuru bee chaa. Maapai jõmaarãpa iru pia ak'ɨpachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Maapai Jesús wãji ichi warida p'uuru Nazaretdee. Ichia oopatak'a ɨ̃ipata ewate pak'ãri, t'ĩuji Ak'õre Ũraa jarateepata tede. Ma ewate bainɨ̃ beeji Ak'õre Ũraa p'ãda leeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Irumaa teejida Ak'õre pedee jarapari Isaíapa p'ãda. Ewat'ɨ atap'eda unuji na pedee mãik'aapa leeji: ");
INSERT INTO sjaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—‘Tachi Ak'õre Jaure mɨ ome bapari, Ak'õrepa mɨ jɨrɨt'erada perã pedee pia jarateemerã chupɨria beerãmaa. Mɨ pëiji jaramerã carcelde pɨk'a beerã uchiapiit'ee mãik'aapa tau p'ãriu beerãmaa unupiit'ee; ma awara chupɨria beerã k'aripait'ee mãik'aapa ichi eperãarã pia ak'ɨ bapariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mãga mɨmaa jarapiji irua eperãarã pia oo k'inia bairã na año irua jɨrɨt'eradade.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mãga pedeep'eda, Jesupa ma p'ãda pɨrat'ɨ ataji mãik'aapa teeji Ak'õre Ũraa jarateepata te ak'ɨparimaa. Mãpai su-ak'ɨ beeji jarateeit'ee. Jõma arii p'anadap'edaarãpa irumaa ak'ɨ para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mãpai irua mãgaji: —Idi weda parã t'ãide p'asamaa bɨ ma ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mãga ũridak'ãri, arii p'anadap'edaarãpa iru t'o p'anajida mãik'aapa ak'ɨtrua para beeji, irua pedee pia jarapachi perã. Ãchi pitapai iidi para beeji: —¿Sãga jarayama ajida, ma p'ãdade jara bɨk'a idi p'asaru? ¿Na José warra-ek'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mãpai Jesupa mãgaji: —¿Parãpa na pedee jarapata jara k'inia p'anɨ-ek'ã? aji. Eperãpa mɨ medicoda ak'ãri, k'awa p'anɨ wãara pedee jara bɨ ichi k'ayaadaip'eda, jɨpa beeru pɨrã ichi juadoopa. Mapa pɨ wãara Tachi Ak'õrepa pëida pɨrã pɨa jara bɨk'a, mãgara nama pɨchi warida p'uurude ne-inaa pia óoji pɨa oodak'a Capernaum p'uurude. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mãpai Jesupa mãgaji: —Mɨa wãarata jararu. Tachi Ak'õre pedee jarapari p'uurudepemaarãpa iru pedee ũridaamaa p'anapata. Mapa parãpa mɨ pedee ijãa k'iniada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ichiaba mãga paji chonaarãweda Tachi Ak'õre pedee jarapari Elías ome. K'oi che-e bɨde año õpee ap'eda esa-auk'a, jarra oojida Israel eujã jõmaade. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mamĩda parã chonaarãpa Tachi Ak'õrede ijãada-e p'anadap'edaa perã, irua Elías pëi-e paji Israel eujãdepema p'ẽtrãarã k'aripade. Ma k'ãyaara pëiji Sarepta p'uurudee, Sidón p'uuru k'ait'a, mãpema p'ẽtrãa k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ichiaba Ak'õre pedee jarapari Eliseo chok'ai bak'ãri, Israel eujãde leprapa k'ayaa beerã chok'ara paraaji. Mamĩda irua apida jɨpa-e paji. Aba Siria eujãdepema k'ayaa bada t'ɨ̃jarapatap'edaa Naamán jɨpa beeji iru juapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mãga ũridak'ãri, ma Ak'õre Ũraa jarateepata tede p'anadap'edaarã jõmaweda k'ĩraudachida Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jita atajida mãik'aapa jidi babataa atadachida p'uurudeepa. Ateejida ee nok'ode ɨra bada eere mãik'aapa sĩa bat'at'aanadait'ee paji piudaimerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mamĩda Jesús ãchi juadeepa uchiadaip'eda, wãyaaji ãchi esajĩak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Maap'eda Jesús wãji Capernaum p'uurudee. Mãgɨ́ p'uuru Galilea eujãde bɨ. Ɨ̃ipata ewate Tachi Ak'õre Ũraa jarateemaa beeji Ak'õre Ũraa jarateepata tede. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mãpemaarãpa iru pedee ũridak'ãri, ak'ɨtrua para beeji irua jĩp'a jarateeda perã Tachi Ak'õrepa jarateepidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mama baji ɨmɨk'ĩra netuara merãtɨa bada iru k'ap'ɨade. Jesús jarateeda ũrik'ãri, netuarapa golpe biapiji: ");
INSERT INTO sjaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Aai, Jesús Nazaretdepema, ¿k'ãata oo chejima aji, taimaa? ¡Tai ichiak'au bɨ́ji! ¿Tai k'enat'aadeta cheruk'ã? ajida. Mɨa pɨ k'awa bɨda aji. Pɨta chi k'achia wẽe bapari, Ak'õre Waibɨapa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mãpai Jesupa ma netuara ɨtrɨat'aaji: —¡K'ĩup'ee beepáde aji mãik'aapa uchiapáde aji, na eperã k'ap'ɨadeepa! Mãpai ma netuarapa ma eperã te jãde baaipiji jõmaarã k'ĩrapite mãik'aapa uchiadachi, iru p'ua oo-ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mãga unudak'ãri, jõmaweda ak'ɨtrua para beeji mãik'aapa ãchi pitapai pedee para beeji: —¡Aai, irua jarateeda waide nama ũridak'aada! ajida. ¡Eperã poro waibɨak'a jaratee bɨ! Netuaraarãpa pida iru pedee ũri p'anɨ mãik'aapa uchiapata, iru Tachi Ak'õre k'ap'ɨa pari pedeepari perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesupa mãga ooda perã, irude nepɨrɨpachida p'uuru bee chaa Galilea eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús uchiak'ãri Ak'õre Ũraa jarateepata tedeepa, wãji Simón Pedro temaa. Simón p'ãk'õre k'ayaa baji k'ɨamiapa. Mapa chupɨria iidijida Jesumaa iru jɨpamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iru ik'aawa ak'ɨnɨ̃ banaji mãik'aapa ma k'ɨamia ɨtrɨat'aaji. Aramata tuudachi. Mãpai chi k'ayaa bada p'irabaip'eda, nek'opiji Jesumaa mãik'aapa chi k'õp'ãyoorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","K'eudaik'ãri, k'ayaa k'ĩra t'ãdoo iru beerã aneejida Jesumaa. Iru jua bɨk'ãri mãɨrã ɨ̃rɨ, jɨpak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ichiaba eperãarã chok'ara k'ap'ɨadeepa netuara merãtɨa beeda bia uchiak'oodachida: —Pɨta Tachi Ak'õre Warrada ajida. Mamĩda Jesupa ɨtrɨak'ooji pedeepiamaapa, ãchia k'awa p'anadap'edaa perã iru Tachi Ak'õrepa pëida eperãarã k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Taujaaweda Jesús uchiaji ma p'uurudeepa wãit'ee eperãarã p'anadak'aamaa. Mamĩda p'uuru pidaarãpa jɨrɨnajida mãik'aapa chupɨria iidijida wãnaamerã awara ãyaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mamĩda Jesupa mãgaji: —Awaraa p'uurudee ichita wãit'ee pedee pia jarateede, ichiaba k'awaadamerã Tachi Ak'õrepa ãra bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã. Ma-it'eepɨ irua mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mãgá Jesupa jaratee nipapachi Ak'õre Ũraa jarateepata te bee chaa judiorã p'anapata eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ewari aba Jesús Genesaret Lago ide bainɨ̃ bak'ãri, eperãarã chok'ara p'ĩsua seedachida irumãi, Tachi Ak'õre Ũraa ũri k'iniapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mãga nɨde Jesupa barco omé unuji to ide. Chipariirãpa ãchi t'ɨrɨ sɨɨmaa p'anajida ipu ide. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús Simón Pedro barcode bataup'eda, iidiji tok'esaapai ateemerã. Mãpai ma barcode su-ak'ɨ beeji jarateeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jaratee aupak'ãri, Simonmaa mãgaji: —Nãpɨadee wãdáma mãik'aapa jãma pãchi t'ɨrɨ t'aadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonpa p'anauji: —Tachi Jarateepari, t'ɨrɨ t'aamaa ewarijidada aji, maarepida peeda-ee. Mamĩda pɨa jara bairã, t'ɨrɨ t'aanait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mãgá t'aadap'eda, jira atadak'ãri, chik'ora nɨ̃baji t'ɨrɨ jãde. Perá jẽdachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mãga unurutata juapa t'ɨ̃jida apema barco pidaarãmaa k'aripa chedamerã. Chejida mãik'aapa ma chik'ora pee aupadak'ãri, barco omee weda perá pirubaaidachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mãga unuk'ãri, Simón Pedro Jesús k'ĩrapite bedabaidachi mãik'aapa mãgaji: —Tachi Waibɨa, mɨ ik'aawaapa ãyaa beepáde aji, mɨ p'ek'au ooyaa bairã. Pia-e bɨ pɨ mɨ k'ait'a bamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón awaraa arii p'anadap'edaarã ome ak'ɨtrua para beeji mãgá chik'o cho-k'ara peedap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Auk'a p'anajida Simón k'õp'ãyoorã, Zebedeo warrarã Santiago Juan ome. Mãpai Jesupa mãgaji Simonmaa: —Waaweenaapáde aji. Idideepa pɨa eperãarã jɨrɨit'ee Tachi Ak'õre-it'ee, to-ɨapataarãpa chik'o jɨrɨpatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mãpai barco ipu ide bɨnadap'eda, jõmaweda ãchi net'aa atabëijida ãchi ak'õreerã ome mãik'aapa wãjida Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ewari aba Jesús p'uurude nide eperã leprapa k'ayaa bɨpa ununaji. Jesumaa chep'eda, bedabaidachi tau bɨɨrɨ eujãde t'õbairumaa mãik'aapa chupɨria iidiji: —Tachi Waibɨa, pɨa k'inia bɨ pɨrã, mɨ k'ayaa wẽpapipáde aji, Ak'õre k'ĩrapite pia beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesupa juapa t'õbaiji mãik'aapa mãgaji: —K'inia bɨda aji. Jɨpa beepáde aji. Aramata chi lepra k'ayaa wẽpaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mãpai Jesupa mãgaji: —Jaranáaji apidaamaa. Jĩp'a p'aaremaa ak'ɨpináji. Moisepa p'ãdade jara bɨk'a ipana omé atéeji teeit'ee Tachi Ak'õremaa. Mãgá jõmaarãpa pɨ jɨpa beeda k'awadayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesupa mãga jarapachi mĩda, audupɨara pedeepachida irua oodade. Ma awara eperãarã chok'araara cheepurujida iru pedee ũridait'ee mãik'aapa ãchi k'ayaa jɨpapidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma k'aurepa Jesús wãpachi eperãarã p'anadak'aamaa ɨt'aa t'ɨ̃de. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ewari aba Jesupa jarateemaa bɨ misa, iru k'ait'a su-ak'ɨ p'anajida fariseorã mãik'aapa Moisepa p'ãda jarateepataarã. Che p'anajida jõmaweda Galilea eujãdepema p'uurudeepa, ichiaba Judea eujãdeepa mãik'aapa Jerusalén p'uurudeepa. Tachi Ak'õre baji Jesús ome, k'ayaa beerã jɨpamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mãga nɨde pachejida eperãarã eperã chiwa bɨ ome. Jira aneejida ichi p'arude. T'ĩu ata k'inia p'anajida teedaa, Jesús k'ĩrapite bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mamĩda unudak'aa paji sãmãik'aapa t'ĩudai, eperãarã chok'ara see nɨ̃bada perã. Maperã ɨt'ɨ́ ateejida terraza ɨ̃rɨ mãik'aapa uria ewa atajida. Mãpai ma chiwa bɨ ichi p'arude ɨrabai atajida jõmaarã taide Jesús k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesupa k'awaak'ãri ãchia wãara ichide ijãa p'anɨ, ma chiwa bɨmaa mãgaji: —K'õp'ãyo, pɨa p'ek'au k'achia oopata jõmaweda wẽpajipɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mãga ũridak'ãri, Moisepa p'ãda jarateepataarãpa mãik'aapa fariseorãpa k'ĩsia p'aneejida: “Jã eperã nãga pedeeik'araa bɨ. Tachi Ak'õrepapaita p'ek'au k'achia wẽpapipari. Jã eperã Tachi Ak'õre ãpɨte ik'achia pedeemaa bɨ jarak'ãri ichiata mãgee ne-inaa oopari.” ");
INSERT INTO sjaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mamĩda Jesupa k'awaji ãchia k'ĩsia p'anɨ. Mapa iidiji: —¿Sãap'eda parãpa k'ĩsia k'achia k'ĩsia p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mɨa irumaa jarai: “Pɨa p'ek'au k'achia oopata wẽpajipɨ” maa-e pɨrã jarai: “P'irabáiji mãik'aapa wã́ji”. Mamĩda irua maarepida oo-e pai Tachi Ak'õrepa oopi-e pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mɨa ak'ɨpiit'ee na p'ek'au eujãde mɨ, chi Eperã Ak'õre Truadepema k'ap'ɨa pari, Tachi Ak'õre Waibɨapa wẽpapipari eperãarãpa p'ek'au k'achia oopata. Mãpai mãgaji ma eperã chiwa bɨmaa: —Mɨa jara bɨ: ¡P'irabáiji! Pɨchi p'aru atáji mãik'aapa wã́ji pɨchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aramata chiwa bada p'irabaidachi jõmaarã taide mãik'aapa ichi p'aru jẽra bada atap'eda, Ak'õre ome o-ĩa wãji ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mãga unudak'ãri, jõmaweda ak'ɨtrua para beeji mãik'aapa o-ĩapa jarapachida Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. Mãgá p'era pɨk'a jõnɨpa mãgajida: —Idi ne-inaa pia unujidada ajida, Tachi Ak'õre juapa ooda. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","T'ẽepai, Jesús mamãik'aapa uchiap'eda, ununaji eperã t'ɨ̃jarapatap'edaa Leví. Mãgɨ́ Cesar-it'ee impuesto p'epari paji. Su-ak'ɨ baji ma impuesto p'epataarã su-ak'ɨ p'anapatamãi. Jesupa irumaa mãgaji: —Mɨ ome nipaparíiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mãpai Leví p'irabaip'eda, ichi net'aa p'e atabëiji mãik'aapa wãji Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma t'ẽepai, Levipa fiesta ooji ichi tede Jesu-it'ee. Impuesto p'epataarã Roma pidaarã rey-it'ee t'ɨ̃ pëiji awaraa k'õp'ãyoorã ome. Ma fiesta oo p'anɨde Jesús chi k'õp'ãyoorã ome su-ak'ɨ p'anajida mesade, nek'omaa apemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mamĩda fariseorãpa mãik'aapa Moisepa p'ãda jarateepataarãpa k'ĩsia p'anadap'edaa perã ãchi chonaarãpa oopatap'edaade, aupedeemaa p'aneejida Jesús k'õp'ãyoorã ome. Iidijida: —¿Sãap'eda nek'omaa p'anɨma mãik'aapa ne-inaa tomaa p'anɨma jãgee impuesto p'epataarã ome mãik'aapa awaraa p'ek'au k'achia oopataarã ome? Parãpa jãga oodaik'araa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesupa p'anauji: —Médico pëidak'aa k'ap'ɨa pia beerãmaa. Jĩp'a pëipata k'ayaa beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tachi Ak'õrepa mɨ pëi-e paji t'ãri pia beerã jɨrɨde. Ma k'ãyaara p'ek'au k'achia oopataarã jɨrɨdeta pëiji, p'ek'au k'achia oo amaadamerã mãik'aapa irude ijãapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesumaa mãgajida: —Juan Bautista k'õp'ãyoorã mãik'aapa fariseorã audú ɨt'aa t'ɨ̃pata nek'oda-ee. ¿Sãap'eda pɨ k'õp'ãyoorã ichita nek'opata mãik'aapa ne-inaa topatama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesupa p'anauji: —Miak'ãipata fiestade t'ɨ̃ pëidap'edaarã pachedak'ãri, ma fiesta o-ĩa oopata chi miak'ãiit'ee bɨ ome. Mama p'anɨde ¿parãpa nek'opida-e paik'ã aji, ãramaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ewari cherude chi miak'ãiit'ee bɨ wẽ-e pak'ãri ãra ome, fiesta ooda-e pait'ee t'ãri p'uapa. Ma ewatepɨ nek'oda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ichiaba Jesupa nãga nepɨrɨji jarateeit'ee ichi ũraa p'oiradaik'araa bɨ Moisepa p'ãda ome: —Eperã apidaapa p'aru chiwididepema pite aba t'ɨɨik'araa bɨda aji, p'aru sorede parchaait'ee. Mãga ooru pɨrã, chi p'aru chiwidi ãridariit'ee mãik'aapa ma pite auk'a bee-e pait'ee chi p'aru sore ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ichiaba vino ewaa juda t'ɨdak'aa ne-e sorede. Mãga oodak'aa ma vino baak'ak'ãri, ma ne-e sore jĩadarii perã mãik'aapa chi vino atuadarii perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Maperã vino ewaa juda t'ɨdaipia bɨ ne-e chiwidide. ");
INSERT INTO sjaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eperãpa vino chona bɨ tok'ãri, to k'inia-e chi ewaa juda jarapata perã: “Chi chonata warraara bɨda” apata. Mãga pɨk'a parãpa chonaarãwedapema ũraa k'iniara iru p'anɨda aji, mɨa ũraa jaratee bɨ k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Judiorã ɨ̃ipata ewate Jesús nipaji trigo k'ãide. Ma wãyaa wãde chi k'õp'ãyoorãpa trigo k'ɨmɨ chak'eerã oromaa p'aneejida. Jua jãde sirat'ɨdap'eda, chi trigo tau chak'eerã k'opachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mãga unudak'ãri, ũk'uru arii p'anadap'edaa fariseorãpa iidijida: —¿Sãap'eda parãpa oo p'anɨma ajida, tachi ũraade jara bɨ oonaadamerã? Ɨ̃ipata ewate mimiadaik'araa bɨda a bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesupa k'awaji chi k'õp'ãyoorãpa ne-inaa k'achia ooda-e paji ma trigo tau k'odak'ãri. Mapa p'anauji: —¿Parãpa Ak'õre Ũraa p'ãdade leeda-e p'anɨk'ã aji, Rey Davidpa ooda chonaarãweda jarrapisiadaidak'ãri chi k'õp'ãyoorã ome? ");
INSERT INTO sjaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","T'ĩuji Tachi Ak'õre te ne-edee oodade mãik'aapa ataji pan awara bɨdap'edaa Tachi Ak'õre-it'ee. Mãgɨ́ pan ũk'uru k'oji mãik'aapa teeji chi k'õp'ãyoorãmaa auk'a k'odamerã. Mãga oojida, p'aareerãpapai mãgɨ́ pan k'odaipia baji mĩda. Tachi Ak'õrepa ãra miapi-e paji mãga oodap'edaa k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesupa ichiaba mãgaji: —Ɨ̃ipata ewate mɨ, chi Eperã Ak'õre Truadepema jua ek'ari bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Awaraa ɨ̃ipata ewate Jesús t'ĩuji Tachi Ak'õre Ũraa jarateepata tede mãik'aapa jarateemaa beeji. Mama baji eperã jua juaraarepema chiwa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisepa p'ãda jarateepataarã fariseorã ome Jesús ɨmɨatee k'inia p'anajida. Mapa ak'ɨ p'anajida Jesupa ma k'ayaa bɨ jɨpai maa-e pɨrã jɨpa-e pai ma ewate. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mamĩda Jesupa k'awaji ãrapa k'ĩsiadap'edaa. Mapa ma jua chiwa bɨmaa jaraji: —P'irabáiji mãik'aapa jõmaarã esajĩak'a ak'ɨnɨ̃ béeji. Aramãgá ma eperã ɨt'a ak'ɨnɨ̃ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mãpai Jesupa mãgaji apemaarãmaa: —Mɨa parãmaa ne-inaa iidiit'ee. ¿K'ãata oodaipia bɨma aji, ɨ̃ipata ewate; ne-inaa pia maa-e pɨrã ne-inaa k'achia? ¿Eperã k'aripadaipia bɨk'ã piunaamerã maa-e pɨrã piupidaipia bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","T'ẽepai mãɨrãmaa ak'ɨji. Maap'eda ma eperã jua chiwa bɨmaa mãgaji: —Pɨchi jua jĩrupáde aji. Mãpai jua jĩruji. Aramata jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mamĩda mãɨrãpa mãga unudak'ãri, audú k'ĩraudachida mãik'aapa pedeeteemaa p'aneejida Jesús peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Maapai Jesús ee nok'odee wãji ɨt'aa t'ɨ̃de. Mama ewariji ɨt'aa t'ɨ̃maa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ãstaawa pak'ãri, ichi ome nipapataarã t'ɨ̃ji. Mãɨrãdepema jɨrɨt'eraji doce mãik'aapa ãra t'ɨ̃ bɨji apóstoles. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nãgɨɨrã paji: Simón, Jesupa ichiaba t'ɨ̃ bɨda Pedro; chi ɨ̃pema Andrés; Santiago; Juan; Felipe; Bartolomé; ");
INSERT INTO sjaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Alfeo warra Santiago; Simón Celote apatap'edaa; ");
INSERT INTO sjaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiago warra Judas mãik'aapa Judas Iscariote; ma t'ẽepai Jesús traicionaada. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ma k'õp'ãyoorã jɨrɨt'erap'eda, Jesús edaa cheji ma ee ɨt'ɨa bɨdeepa ãra ome mãik'aapa pachejida eujã jewedaade. Mama chip'e p'anajida iru ome nipapatap'edaarã mãik'aapa awaraa eperãarã chok'ara: Judea eujãdepemaarã, Jerusalén p'uurudepemaarã, p'usa ide p'anɨ Tiro p'uurudepemaarã Sidón p'uurudepemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Che p'anajida Jesús pedee ũridait'ee mãik'aapa irua ãchi k'ayaa jɨpamerã. Mama bɨde Jesupa netuara merãtɨa iru beerã ichiaba jɨpak'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eperãarã jõmaarãpa Jesús k'ap'ɨa t'õbai k'inia p'anapachida, iru juapa ãchi jõmaweda jɨpak'ooda perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Maap'eda Jesupa ichi ome nipapataarãmaa ak'ɨji mãik'aapa mãgaji: —T'ãri o-ĩa p'anɨ, parã chi chupɨria chedeerã. Tachi Ak'õre k'awa k'inia p'anadairã, irudeerã p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","T'ãri o-ĩa p'anɨ, parã chi jarrapisia jõnɨɨrã, parãmaa Tachi Ak'õrepa nek'opiit'ee perã. Ichiaba t'ãri o-ĩa p'anɨ, parã chi ɨ̃raweda jẽe jõnɨɨrã t'ãri p'uapa, t'ẽepai Tachi Ak'õrepa parã ëipiit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","T'ãri o-ĩa p'anɨ eperãarãpa parã k'ĩra unuamaa iru p'aneedak'ãri; yiaraa iru p'aneedak'ãri; parãmaa ik'achia pedeedak'ãri, maa-e pɨrã parã ãpɨte pedee k'achia jaradak'ãri mɨ, chi Eperã Ak'õre Truadepemade ijãapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mãga oodak'ãri, t'ãri o-ĩa, k'ãiwee p'anéetɨ, Tachi Ak'õrepa ne-inaa pi-ia teeit'ee perã, parã iru truade panadak'ãri. Chonaarãweda ichiaba mãgá ne-inaa k'achia oopachida Tachi Ak'õre pedee jarapataarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mamĩda ¡aai, Tachi Ak'õrepa k'achiadee pëiit'eepɨ parã, chi p'arat'ara beerã, na p'ek'au eujãdepai o-ĩa p'anadait'ee perã! ");
INSERT INTO sjaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Aai, Tachi Ak'õrepa k'achiadee pëiit'eepɨ parã, chi ɨ̃raweda bi jãwaa p'anɨɨrã, t'ẽepai jarrapisia p'aneedait'ee perã! ¡Aai, Tachi Ak'õrepa k'achiadee pëiit'eepɨ parã, chi ɨ̃raweda ëi jõnɨɨrã, t'ẽepai jẽe jõnadait'ee perã t'ãri p'uapa! ");
INSERT INTO sjaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Aai, Tachi Ak'õrepa k'achiadee pëiit'eepɨ parã, chi jõmaarãpa t'o p'anapataarã! ¡Mãga oopachida Judea eujãdepemaarã chonaarãpa, seewata Tachi Ak'õre pedee jarapatada apatap'edaarã ome! ");
INSERT INTO sjaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Mamĩda parã, mɨ pedee ũri p'anɨɨrãmaa mɨa jara bɨ: Parã k'ĩra unuamaa iru p'anapataarã k'inia iru p'anapatáatɨ mãik'aapa ãramaa ne-inaa pia óotɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pia óotɨ ãrapa parã k'achia oopata pari. Ɨt'aa t'ɨ̃patáatɨ pãchimaa ik'achia jarapataarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Eperãpa pɨ k'ĩra tarramaa sĩru pɨrã, auk'a oonáaji irumaa. Ma k'ãyaara chi apema k'ĩra tarra ak'ɨpíji, auk'a sĩmerã. Ichiaba eperãpa pɨchi ɨ̃rɨpema p'aru jɨ̃ bɨ jãri ataru pɨrã, ichiaba pɨchi camisa t'ãri pia téeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Apidaapa pɨmaa ne-inaa iidiruta pɨrã, téeji. Ichiaba pɨ net'aa jãri ataruta pɨrã, iidináaji waya pɨmaa teemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Óotɨ apemaarãmaa parãpa k'inia p'anɨk'a ãchia parãmaa oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Parãpa k'inia iru p'anɨ pɨrã pãchi k'inia iru p'anapataarã aupai, ¿ne-inaa pipɨara oomaa p'anɨk'ã? P'ek'au k'achia ooyaa beerãpa paara mãga oopata. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Parãpa ne-inaa pia oo p'anɨ pɨrã pãchi pia oopataarãmaa aupai, ¿ne-inaa pipɨara oomaa p'anɨk'ã? P'ek'au k'achia oopataarãpa paara mãga oopata. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ichiaba pãchi net'aa presta pëiruta pɨrã, ma pari awaraa net'aa jitait'ee aupai, ¿ne-inaa pipɨara oomaa p'anɨk'ã? P'ek'au k'achia oopataarãpa pida prestapata ãchi pitapai, ma pari ne-inaa jitadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Parãpa pãchi k'ĩra unuamaa iru p'anapataarã k'inia iru p'anapataadaipia bɨ mãik'aapa ãra pia oopataadaipia bɨ. Ãramaa net'aa prestadaipia bɨ, nɨda-ee ne-inaa jitadait'ee ma pari. Mãga ooruta pɨrã, Tachi Ak'õrepa ne-inaa pia teeit'ee parãmaa mãik'aapa parã Ak'õre Waibɨa warrarã p'anadait'ee. Iruata ne-inaa pia oopari gracias jaradak'aarãmaa mãik'aapa t'ãri k'achia-idaa beerãmaa paara. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maperã awaraarã chupɨria k'awáatɨ pãchi Ak'õre Waibɨapa ooparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Awaraarãpa ne-inaa oopata ak'ɨnáatɨ jaradait'ee ne-inaa k'achia oomaa p'anɨ. Mãgá Tachi Ak'õrepa auk'a oo-e pait'ee parã ome. Ne-inaa k'achia aupai jɨrɨnáatɨ pedee k'achia jaradait'ee awaraarã ãpɨte, maa-e pɨrã Tachi Ak'õrepa auk'a jɨrɨit'ee parãpa ne-inaa k'achia oopata aupai jarait'ee, p'anadak'ãri iru k'ĩrapite. Chĩarapa parãmaa ne-inaa k'achia ook'ãri, perdonáatɨ. Mãgá Tachi Ak'õrepa parãpa ne-inaa k'achia oopata perdonaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Awaraarãmaa téetɨ. Mãgá Tachi Ak'õrepa parãmaa teeit'ee. T'ãri pia teedak'ãri awaraarãmaa, ma pari irua audupɨara teeit'ee parãmaa. Irua parãmaa ooit'ee parãpa oopatak'a awaraarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ichiaba Jesupa nãga nepɨrɨji jarateeit'ee, chi k'õp'ãyoorãpa k'awaa wãdamerã oodait'ee irua jara bɨk'a. —P'ananáatɨ chi wãara k'awada-e p'anɨɨrãk'a. Mãgɨɨrã tau p'ãriu beerã́k'apɨ p'anɨ awaraa tau p'ãriu beerã atee k'inia p'anadak'ãri awara ãyaa. ¿Ãchi omee weda uriade baainada-e paik'ã? ");
INSERT INTO sjaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mɨ ũraa k'awaa wãdak'ãri, pia p'anapataadait'ee. Estudiante apida ichi jarateepari k'ãyaara k'awaara bɨ-e. Mamĩda jõmaweda estudia aupak'ãri, ichi jarateepari jĩak'a uchiai. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿K'ãare-it'ee ak'ɨ bɨma nejarra pɨchi auk'aa tau jãde bɨ, mamĩda unu-e bɨ pak'uru pɨchi tau jãde bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pɨchi tau jãde pak'uru iru bɨ pɨrã, ¿sãga pɨchi auk'aamaa jaraima: “Ɨ̃pema, mɨmaa ẽepíji jã nejarra pɨchi tau jãde bɨ”? ¡Seewata pɨa chĩara k'aripa k'inia bɨ, irua oo bɨ ak'ɨk'ãri! Naapɨara ẽt'aipia bɨ ma pak'uru pɨchi tau jãde bɨ. Mãpaipɨ pia unui ma nejarra pɨchi auk'aa tau jãde bɨ mãik'aapa mãgá iru k'aripai. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Nejõ bɨɨrɨ pia bɨpa nejõ k'achia chauk'aa. Jõdee nejõ bɨɨrɨ k'achia bɨpa nejõ pia chauk'aa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nejõ bɨɨrɨ chaa k'awapata chi nejõdeepa. Eperãarãpa higojõ orodak'aa pak'uru ɨɨrɨ-idaa bɨdeepa. Ichiaba uva orodak'aa mãgee pak'urudeepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mãga pɨk'a eperã t'ãri pia bɨpa pedee pia jarapari, k'ĩsia pia iru bairã ichi t'ãride. Jõdee eperã t'ãri k'achia bɨpa pedee k'achia jarapari, ichi t'ãride k'ĩsia k'achia iru bairã. Ma k'ĩsia jõma uchiaru ichi t'ãrideepa ichi it'aipa jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—¿K'ãare-it'ee parãpa mɨ t'ɨ̃jarapatama: “Tachi Waibɨa, Tachi Waibɨa”, mamĩda ooda-e p'anɨ mɨa jara bɨk'a? ");
INSERT INTO sjaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mɨa jarait'ee k'aik'a bɨ chi mɨmaa cheru ũriit'ee mɨ pedee mãik'aapa oopariit'ee mɨa jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mãgɨ́ eperã te oo bɨ́k'ata bɨ. Naapɨara irua edú k'orop'eda, chi te bɨɨrɨ mãu ɨ̃rɨ bɨpari. Maap'eda to chek'ãri, wee jira beepari ma te bɨɨrɨ sudamãi. Mamĩda p'oyaa mimik'api-e, basa mãu ɨ̃rɨ bɨda perã. Mãgɨ́ eperãpa ichi te mãgá basa mãu ɨ̃rɨ pia oopari perã, jõ-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jõdee chi mɨ ũraa ũrip'eda, oo-e bɨpa mɨa jara bɨk'a nãga pɨk'a bɨ. Ichi te ook'ãri, te bɨɨrɨ pariatua supari ipu nãusaade, basa wẽe. Maap'eda to chek'ãri mãik'aapa wee jira beek'ãri ma te bɨɨrɨ sudamãi, ma te t'eedaipari mãik'aapa jõmaweda jõdaipari, chi te chipari paara. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesupa ma eperãarãmaa mãga jara aupap'eda, wãji Capernaum p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mama bapachi Romadepema soldaorã poro waibɨa. Ichi esclavo k'inia iru bapachi. Mamĩda mãgɨ́ juak'aya nɨ̃baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma soldaorã poro waibɨapa ũrik'ãri Jesús mama ni, pëiji judiorã poro waibɨarã Jesumaa chupɨria iidide, ichi esclavo jɨpa chemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ãra Jesumaa wãjida mãik'aapa chupɨria iidijida: —Na capitán t'ãri pia baparida ajida, tachi ome. Mapa pɨa k'aripaipia bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Irua tachi judiorã k'inia iru bapari. Oopijida ajida, namapema Ak'õre Ũraa jarateepata te. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mãpai Jesús wãji ãra ome. Mamĩda ma soldaorã poro waibɨa te k'ait'a panadak'ãri, irua jara pëiji chi k'õp'ãyoorã ome: —Tachi Waibɨa, mɨ temaa chenaapáde aji, mɨ pɨ k'ãyaara ek'ariara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Maperã mɨchi itu wã-e paji pɨ jɨrɨde. Mamĩda k'awa bɨ ne-inaa jõmaweda pɨ jua ek'ari nɨ̃bɨ. Jĩp'a jarapáde aji, mɨ esclavo jɨpa beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mɨ jida waibɨarã jua ek'ari bɨ. Ma awara mɨa soldaorã iru bɨ mɨchi jua ek'ari. Mɨa abaamaa wãpáde ak'ãri, wãpari; awaraamaa chepáde ak'ãri, chepari. Ichiaba mɨ esclavomaa ne-inaa oopáde ak'ãri, oonapari. Mɨ jua ek'ari p'anɨɨrãpa mãga oopata perã, mɨa k'awa bɨ pɨa jararupapai mɨ esclavo jɨpait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mãga jaranadak'ãri, Jesús p'era pɨk'a beeji. Mapa ichi ome nipapataarãmaa ak'ɨji mãik'aapa mãgaji: —Mãgara mɨ wã-eda aji. Mɨa wãarata jararu. Tachi Israel pidaarã t'ãide mɨa apida unu-e bɨda aji, ma eperãk'a; Tachi Ak'õrede wãara ijãa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma pëidap'edaarã capitán temaa pachedak'ãri, chi esclavo jɨpa bɨta unu chejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma t'ẽepai, Jesús wãji Naín p'uurudee. Chi k'õp'ãyoorã mãik'aapa awaraa eperãarã chok'ara wãjida iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","P'uuru k'ait'a panadak'ãri, unujida eperãarãpa jai-idaada atee wãruta ɨade. Mãgɨ́ p'ẽtrãa warra apai iru bada paji. Aɨ ome chi p'uurudepemaarã chok'ara wã nipajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesupa mãgɨ́ p'ẽtrãa unuk'ãri, chupɨria k'awaaji mãik'aapa mãgaji: —Jẽenaapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aramata araa wãp'eda, Jesupa t'õbait'aaji ma k'ap'ɨa atee wãdap'edaa p'aru. Chi atee wã nipadap'edaarã ak'ɨnɨ̃ p'aneedak'ãri, Jesupa mãgaji ma jai-idaa badamaa: —K'ũtrãa, p'irabáiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mãpai chi jai-idaa bada su-ak'ɨ beeji mãik'aapa pedeemaa beeji. Maap'eda, Jesupa chi nawemaa mãgaji: —Acha bɨda aji, pɨ warra. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mãga unudak'ãri, arii p'anadap'edaarã jõmaweda p'era pɨk'adachida mãik'aapa Tachi Ak'õrede pia pedee para beeji: —Ak'õre pedee jarapari waibɨa tachi t'ãide uchiajida ajida. Ichiaba mãgajida: —Tachi Ak'õre che bɨ tachi p'uuru pidaarã k'aripade. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mãgá Jesupa ooda k'awaajida Judea eujãdepemaarãpa mãik'aapa ma ik'aawapemaarãpa. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautista ome nipapatap'edaarã wãjida iru badamãi carcelde ma jõma nepɨrɨde. Mãga ũrik'ãri, omé t'ɨ̃ pëiji wãdamerã Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mãɨrã pëiji Jesumaa iididamerã iru chi cheit'ee bada eperãarã k'aripait'ee maa-e pɨrã awaraa nɨdaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesús k'ait'a panadap'eda, mãgajida: —Juan Bautistapa tai pëijida ajida, iidide: “¿Pɨk'ã tai k'aripapari chonaarãpa cheit'ee bɨda adap'edaa? Maa-e pɨrã, ¿awaraa nɨdaipia bɨk'ã?” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mãga iidi p'anadak'ãri, Jesupa eperãarã chok'ara jɨpaji: k'ayaa beerã; k'ap'ɨa p'ira beerã; netuara k'ap'ɨade merãtɨa beerã mãik'aapa tau p'ãriu beerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Maap'eda ma Juanpa eperãarã pëidamaa p'anauji: —Wã́tɨ Juanmaa mãik'aapa nepɨrɨ́tɨ parãpa nama unu p'anɨ mãik'aapa ũri p'anɨ. Jarátɨ tau p'ãriu beeda ɨ̃rá unu p'anɨ; nɨk'anɨk'aa beeda t'ɨa nĩutee; leprapa k'ayaa beeda jɨpa p'anɨ ãchi k'ayaadeepa; k'ɨɨrɨ k'ĩ beeda ɨ̃rá ũri p'anɨ; piudap'edaarã waya chok'ai p'anɨ mãik'aapa chupɨria chedeerãmaa Ak'õrepa pedee pia jara pëida jarateemaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡T'ãri o-ĩa bɨda aji, chi mɨde ijãa bɨ, k'awa-e bɨ mĩda mɨa ne-inaa jõma oo bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa eperãarã pëida wãdap'edaa t'ẽepai, eperãarãmaa Jesupa pedee pia jaramaa beeji Juande: —¿K'ãata parãpa ak'ɨnajidama aji, eujã pania wẽe bɨmaa wãdak'ãri? ¿K'ĩsiajida-ek'ã ak'ɨnadait'ee eperã pariatua k'ĩsia bɨ, p'ũajara nãupa pariatua nẽunẽuwaa p'uaparik'a? ");
INSERT INTO sjaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Maa-e pɨrã, ¿k'ĩsiajida-ek'ã ak'ɨnadait'ee eperã p'aru pi-ia jɨ̃ bɨ? Parãpa pia k'awa p'anɨ eperã p'aru pi-ia jɨ̃ beerã rey tede p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mãga-e pɨrã ¿k'ĩsiajida-ek'ã ak'ɨnadait'ee Ak'õre pedee jarapari? Wãara, iru Ak'õre pedee jarapari k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Na Juandeta Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Mɨa eperã chok'a pëiit'ee pɨ naa o pia oonamerã pɨ, eperãarã poro waibɨa, chei naaweda.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mɨa jara bɨ: Eperã apida Juan k'ãyaara waibɨara bɨ-e. Mamĩda chi ek'ariara bɨta iru k'ãyaara waibɨara pait'ee, Tachi Ak'õrepa ma eperã ichi jua ek'ari bɨk'ãri, ichideerã ome beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Jõmaweda Juan pedee ũridap'edaarã, Cesar-it'ee impuesto p'epataarã paara, irumaa poro choopijida. Mãga oodak'ãri, ak'ɨpijida Tachi Ak'õre wãarata jara baji Juan k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mamĩda fariseorã Moisepa p'ãda jarateepataarã ome Juanmaa poro choopida-e pak'ãri, ak'ɨpijida ãchia k'iniada-e p'anɨ Tachi Ak'õrepa ãchimaa pia oo k'inia bada. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’Mɨa jarait'ee sãga p'anɨ parã, mɨde ijãadak'aa beerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Warrarã su-ak'ɨ p'aneedap'eda, jemenemaa p'anɨ́k'ata p'anɨ p'uuru jãde. Ãchi k'õp'ãyoorãmaa biapata: “Taipa siru chaajida. Mamĩda parã pëirada-e paji. K'ari k'ĩsia paraa k'arijida. Mamĩda parã jẽeda-e paji.” ");
INSERT INTO sjaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista chek'ãri, pan k'o-e paji eperãarã jĩp'aarãk'a mãik'aapa vino tok'aa paji. Maperã parãpa jarajida: “Netuara iru k'ap'ɨade merãtɨa bɨda” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","T'ẽepai mɨ, chi Eperã Ak'õre Truadepema cheji mãik'aapa nek'oji, ne-inaa toji eperã jĩp'aak'a. Maperã jara p'anɨ mɨ nek'oyaa, ne-inaa toyaa bapari. Ma awara mɨ k'õp'ãyo meraaparida a p'anɨ k'achia-idaa beerã ome mãik'aapa Cesar-it'ee impuesto p'epataarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mamĩda Tachi Ak'õrepa wãarata ak'ɨpimaa bɨda aji, mɨa oo bɨ k'aurepa parã jõmaarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo t'ɨ̃jarapatap'edaa Simonpa Jesús t'ɨ̃ pëiji nek'o chemerã ichi ome. Mãgá Jesús wãji iru temaa. Su-ak'ɨ beeji mesade. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma p'uurude wẽra p'ek'au k'achia ooyaa bapachi. Mãgɨpa k'awaak'ãri Jesús wãda nek'ode ma fariseo tede, ataji chok'o chak'ek'a mãu pi-ia alabastrodee ooda ipuru bɨ k'erapa mãik'aapa wãji irumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jẽe wãpa su-ak'ɨ banaji Jesús bɨɨrɨmãi mãik'aapa iru bɨɨrɨ sɨɨmaa beeji ichi taubapa. Maap'eda ichi pudapa p'ooji. Mãpai Jesús bɨɨrɨ wëre atap'eda, ɨ̃t'aaji mãik'aapa ma k'era weet'aaji aɨ ɨ̃rɨ ak'ɨpiit'ee Jesús k'inia iru bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simonpa mãga unuk'ãri, k'ĩsiaji: “Na eperã wãara Ak'õre pedee jarapari pada paara, k'awak'ajida aji, k'ãare eperãpa ichi t'õbaimaa bɨ mãik'aapa mãga oopi-e pak'aji, ma wẽra p'ek'au k'achia ooyaa bairã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mãpai Jesupa Simonmaa mãgaji: —Simón, mɨa pɨmaa ne-inaa jara k'inia bɨda aji. Simonpa p'anauji: —Tachi Jarateepari, jaráji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesupa nepɨrɨji: —Eperãarã omé p'arat'a paraa p'anajida p'arat'a prestapatamãi. Abaapa paraa baji quinientos denarios; chi apemapa cincuenta denarios. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","P'oyaa p'aada-e pak'ãri, chi p'arat'a presta pëidapa ãra chupɨria k'awaaji mãik'aapa omeerãmaa p'aapi-e paji. Ɨ̃rá mɨmaa jaráji: ¿chisãgɨpa ma p'arat'a prestapari audú k'iniara iru bait'eema? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simonpa p'anauji: —¿Chi p'arat'a waibɨara paraa bada-ek'ã? aji. Jesupa mãgaji: —Wãarada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mãpai Jesupa ma wẽramaa ak'ɨji mãik'aapa Simonmaa mãgaji: —¿Na wẽra unu bɨk'ã? aji. Mɨ t'ĩuk'ãri pɨ tede, pɨa mɨ pia auteebai-e paji. Pania tee-e paji mɨ bɨɨrɨ sɨɨmerã. Jõdee na wẽrapa mɨ bɨɨrɨ sɨɨji ichi taubapa mãik'aapa p'ooji ichi pudapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mɨ t'ĩuk'ãri, pɨa mɨ k'ĩra ɨ̃-e paji. Mamĩda mɨ nama t'ĩuru weda na wẽrapa mɨ bɨɨrɨ ɨ̃maa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pɨa mɨ poro ɨ̃rɨ aceitepa p'uru-e paji. Mamĩda irua k'era weeji mɨ bɨɨrɨ ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mapa mɨa jara bɨ: Irua p'ek'au k'achia chok'ara oopata wẽpapiji, mɨ audú k'inia iru bairã. Mamĩda eperãpa k'ĩsia bɨ pɨrã ichia mak'ɨara p'ek'au k'achia oo-e bɨ, mãgara ma eperãpa mɨ mak'ɨara k'inia-e bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","T'ẽepai Jesupa mãgaji ma wẽramaa: —Pɨa p'ek'au k'achia oopata wẽpajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mãpai apemaarã arii p'anadap'edaarãpa iidi para beeji: —¿K'aima ajida, jãgɨ́? ¿Eperãarãpa p'ek'au k'achia oopata paara wẽpapi bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mãpai Jesupa waya jaraji ma wẽramaa: —Pɨ wãara Ak'õrede ijãa bairã, irua pɨ o k'achiadeepa k'aripa ataji atuanaamerã. K'ãiwee wãpáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma t'ẽepai Jesús nipapachi p'uuru beede mãik'aapa aɨ ik'aawa p'uuru k'aipee beede. Jaratee nipapachi Ak'õrepa pedee pia jara pëida; irua eperãarã bɨ k'inia bɨ ichi jua ek'ari, ichideerã p'aneedamerã. Chi k'õp'ãyoorã doce auk'a nipapachida iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ichiaba wẽraarã nipapachida iru ome. Aɨ naaweda ma wẽraarã ũk'uru netuara k'ap'ɨade merãtɨa p'anajida mãik'aapa ũk'uru k'ayaa p'anajida. Mamĩda Jesupa ma jõmaweda jɨpaji. Mãɨrãdepema paji María, ichiaba t'ɨ̃jarapatap'edaa Magdalena. Iru k'ap'ɨadeepa Jesupa netuara siete uchiapiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ichiaba baji Cuza wẽra t'ɨ̃jarapatap'edaa Juana. Ma Cuza Rey Herodes tedepema mimiapataarã poro waibɨa paji. Ichiaba baji Susana, awaraa wẽraarã chok'ara ome. Ma wẽraarãpa Jesús chi k'õp'ãyoorã ome k'aripapachida; teepachida net'aa mãik'aapa p'arat'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Maapai eperãarã chok'ara uchiajida p'uurudeepa Jesús ak'ɨde. Mãgá eperãarã chok'ara chip'edachida. Mãga nɨde Jesupa na pedee nepɨrɨji Ak'õre Ũraa jarateeit'ee: ");
INSERT INTO sjaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Eperã wãji net'atau p'ode. Ma p'o wãk'ãri, ũk'uru baaijida o jãde. T'ẽepai mama eperãarã bɨɨrɨpa t'ɨak'oojida mãik'aapa ipanaarãpa k'ok'oo chejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ũk'uru baaijida mãu-idaade mãik'aapa t'onojida mĩda, taarã-e weda pɨɨk'oodachi, pania wẽede baaidap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ũk'uru baaijida ne-ɨɨrɨ-idaade mãik'aapa auk'a t'onojida. Mamĩda ne-ɨɨrɨ k'ap'ip'iara waripari perã, mãgɨ́ net'atau t'ono wãdap'edaa piuk'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jõdee awaraa net'atau baaijida eujã piade. Mãgɨ́ t'onojida, warijida mãik'aapa pia chaujida. Ũk'uru net'atau abaadeepa tau cien uchiajida. Nepɨrɨp'eda, Jesupa golpe pedeeji: —¡Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ma t'ẽepai Jesús k'õp'ãyoorãpa iidijida: —¿K'ãata jara k'inia bɨma ajida, pɨa nepɨrɨ bada? ");
INSERT INTO sjaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesupa p'anauji: —Tachi Ak'õrepa parãmaa k'awapimaa bɨda aji, ne-inaa naaweda k'awapik'aa pada awaraarãmaa: sãga ichideerã p'aneedai. Mamĩda awaraarãmaa mɨa nepɨrɨpari jarateeit'ee: ‘Ãrapa mɨa oo bɨ ak'ɨ p'anɨ mĩda, wãara unuda-e mãik'aapa mɨa jara bɨ ũri p'anɨ mĩda, k'awada-ee p'aneedamerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mãpai Jesupa mãgaji: —Mɨa nepɨrɨda net'atau p'oparide nãga jara k'inia bɨ. Ma net'atau p'oda jara k'inia bɨ Tachi Ak'õre Ũraa jara pëida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chi o jãde baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida ũripata. Mamĩda Netuara Poro Waibɨa chepari ne-inaa ooit'ee, t'ãripa ma pedee ijãanaadamerã mãik'aapa wãnaadamerã Ak'õre eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jõdee chi net'atau mãu-idaade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida o-ĩa ũri p'anɨ. Mamĩda chi mãu-idaade t'onoda taarã-e weda pɨɨdaiparik'a, mãga pɨk'a mãgɨɨrãpa ma jara pëida taarã-epai ijãapata. Ma ũraade ijãadap'edaa k'aurepa nepɨrade baairuta pɨrã, maa-e pɨrã awaraarãpa ãchi jɨrɨruta pɨrã miapidait'ee, ijãa amaapata. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jõdee chi net'atau ne-ɨɨrɨ-idaade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida pia ũri p'anɨ. Mamĩda t'ẽepai k'ĩsia p'aneeruta piara bɨ p'arat'a atadait'ee maa-e pɨrã ãchia ne-inaa audú oo k'inia p'anɨ oodait'ee, Ak'õrepa k'inia bɨk'a oodai k'ãyaara. Mãgá p'aneepata ne-uu warip'eda chauk'aa bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mamĩda chi net'atau eujã piade baaidap'edaa jara k'inia bɨ eperãarãpa ma jara pëida wãara ijãapata ãchi t'ãride. Mãpai p'anapata ma ũraade jara bɨk'a mãik'aapa choopata ãchi ijãa p'anɨde. Mãgá p'aneepata ne-uu pia chauparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Maap'eda Jesupa awaraa nepɨrɨji: —Tachia lámpara k'oodak'aa ata bɨdait'ee ne-inaa edajãde maa-e pɨrã cama ek'ari. Ma k'ãyaara lámpara k'oodap'eda, ɨt'ɨ́ ata bɨpata pia ɨ̃daamerã te jãde p'anɨɨrã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mãga pɨk'a Tachi Ak'õrepa oo bɨ mera pɨk'a bɨ eperãarãpa k'awanaadamerã. Mamĩda t'ẽepai irua jõmaarãmaa k'awaapiit'ee k'ãata jara k'inia bɨ. Ichiaba ɨ̃rá irua oo bɨ jõmaarãmaa k'awapi-e. Mamĩda t'ẽepai k'awaapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Maperã pia ũrítɨ. Chi k'awa bɨmaa Tachi Ak'õrepa audupɨara k'awaapiit'ee. Mamĩda chi ne-inaa k'awaara k'ĩsia bɨpa k'awa bɨ paara wẽpapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús nawe chi ɨ̃pemaarã ome wãjida irumaa. Mamĩda iru k'ait'a p'oyaa wãda-e paji eperãarã see nɨ̃bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mãpai eperãpa jaranaji Jesumaa: —Pɨ nawe pɨ ɨ̃pemaarã ome taawa nɨmaa p'anɨda aji, pɨ ak'ɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mãga ũrik'ãri, ichia mãgaji: —Ak'õre Ũraa ũripataarã mãik'aapa oopataarã Ak'õrepa jara bɨk'a, mãɨrãta mɨ nawek'a bɨ mãik'aapa mɨ ɨ̃pemaarãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ewari aba Jesupa mãgaji chi k'õp'ãyoorãmaa: —Wãdáma aji, lago k'ĩraik'a eeree. Mãpai barcode bataujida mãik'aapa wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sĩa wãdade Jesús k'ãidachi. Mãɨmisa p'usara t'o nɨ̃beeji. Mapa barco pirubaai wã nipaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mapa Jesús ɨ̃rɨmat'aajida mãik'aapa mãgajida: —¡Tachi Jarateepari, pirubaai wãdapɨ! Jesús p'irabaidachi mãik'aapa pedeeji nãumaa mãik'aapa p'usamaa. Jõmaweda t'umãtɨdachi mãik'aapa ip'ii ũu beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mãpai Jesupa chi k'õp'ãyoorãmaa iidiji: —¿Sãap'eda parãpa ijãada-e p'anɨma aji, mɨa parã ak'ɨit'ee? Mamĩda ãchi jõmaweda p'era jõnɨpa ak'ɨtrua para beeji mãik'aapa ãchi pitapai iidi para beeji: —¿K'aima ajida, nãgɨ́? Iru pedeepa nãu, p'usa paara t'umãtɨpiparida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","T'ẽepai panajida Gerasa eujãde lago k'ĩraik'a eere, Galilea eujã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús batauk'ãri, eperã netuara merãtɨa bɨ iru k'ait'a cheji. P'uurudepema paji mĩda, taarã p'aru jɨ̃-e baji; ichiaba teeda bak'aa paji. Bapachi jãɨra mãu te uriade. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mãgɨ́ eperãpa Jesús unuk'ãri, iru k'ĩrapite sinapotepa bia baainaji: —Jesús, Ak'õre Waibɨa Warra, mɨ ome t'ĩunáaji. ¡Mɨ chupɨria k'awáaji! ¡Ichiak'au bɨ́ji! ");
INSERT INTO sjaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mãga jaraji Jesupa jara bada perã uchiamerã ma eperã k'ap'ɨadeepa. Taarã baji ma netuara merãtɨa bɨ iru k'ap'ɨade. At'apai ma netuarapa irumaa ne-inaa pariatua oopiji. Mãɨmisa eperãarãpa iru jua bɨɨrɨ ome cadenapa jɨ̃ nɨ̃bɨjida ãyaa wãnaamerã. Mamĩda ma netuara juapa irua ma cadena t'ɨɨt'aapachi mãik'aapa jirabodoji t'ɨmɨ́ eperãarã p'anadak'aamaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mãpai Jesupa iidiji: —¿Pɨ, k'asaa t'ɨ̃jarapatama? aji. Ichia p'anauji: —Mɨ t'ɨ̃jarapatada aji, Legión. Mãga jaraji netuara chok'ara ichi k'ap'ɨade t'ĩudap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mãpai ma netuaraarãpa Jesumaa chupɨria iidipachida ãchi pëinaamerã uria audú nãpɨa bɨdee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma k'ait'a ee k'arraya sinaarã chok'ara nek'omaa p'anajida. Mapa netuaraarãpa chupɨria iidijida ma sinaarã k'ap'ɨade t'ĩupimerã. Mãpai Jesupa mãga ooji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aramãgá netuaraarã uchiajida eperã k'ap'ɨadeepa mãik'aapa t'ĩujida ma sinaarã k'ap'ɨade. Aramata sinaarã p'irak'oodachida ee k'õot'ari jira bɨdee. Toida baainadap'eda, ɨ̃yapa jɨ̃ak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma sinaarã jɨ̃a p'anadap'edaarãpa mãga unudak'ãri, p'irak'oodachida p'uurudee nepɨrɨdait'ee p'uuru pidaarãmaa mãik'aapa ma p'uuru k'ait'a beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mapa eperãarã uchiajida ak'ɨde. Jesumãi pachedak'ãri, unujida ma eperã netuara k'ap'ɨade merãtɨa bada su-ak'ɨ bɨ Jesús bɨɨrɨ k'ait'a. P'aru jɨ̃p'eda, k'ãiwee su-ak'ɨ baji. Mãga unudak'ãri, ma eperãarã p'era para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mãpai chi unudap'edaarãpa nepɨrɨjida sãgapɨ Jesupa jɨpaji ma eperã netuara k'ap'ɨade merãtɨa bada. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Maap'eda ma Gerasa eujãdepemaarãpa Jesumaa chupɨria iidijida ãyaa wãmerã mamãik'aapa, audú nejasia p'anadap'edaa perã. Mãpai Jesús barcode bataup'eda, wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wãi naaweda, ma eperã netuara k'ap'ɨade merãtɨa badapa chupɨria iidiji Jesupa ichi ome auk'a wãpimerã. Mamĩda Jesupa jaraji beemerã. Mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wãpáde aji, pɨchi temaa mãik'aapa nepɨrɨpáde aji, Tachi Ak'õrepa pɨ ome ooda. Aramãgá ma eperã wãji ma p'uurudepema jõmaarãmaa nepɨrɨde Jesupa ichi ome ooda. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús lago k'ĩraik'a eere pachek'ãri, eperãarãpa iru o-ĩa auteebaijida, jõmaarãpa iru nɨ p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mãga nɨde pacheji eperã t'ɨ̃jarapatap'edaa Jairo. Ichi Ak'õre Ũraa jarateepata tedepema poro paji. Jesús bɨɨrɨmãi bedabaidachi mãik'aapa chupɨria iidiji wãmerã ichi temaa ");
INSERT INTO sjaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","chi k'au jɨpade, juak'aya nɨ̃bada perã. K'au apai iru baji; mãgɨ́ doce años iru baji. Jesús wãrude Jairo temaa, iru ome nipapataarã see nɨ̃bada k'aurepa p'ĩsua baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma eperãarã ome baji wẽra bi k'ayaa bɨ. Doce años waamiapa k'ayaa baji. Ichi p'arat'a jõdai baji jɨpapataarã juade nipa. Mamĩda apidaapa p'oyaa jɨpadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ma wẽra Jesús ãpɨteik'aapa k'ait'a wãji mãik'aapa iru ɨ̃rɨpema p'aru i t'õbait'aaji. Aramata ma waamia t'ɨbaidachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mãpai Jesupa iidiji: —¿K'aipa mɨ t'õbaijima? aji. Chi k'õp'ãyoorã jõmaarãpa ãchia-e pajida apachida. Mãpai Pedropa mãgaji: —Tachi Jarateepari, eperãarãpa pɨ t'ɨsĩa wãrutada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mamĩda Jesupa mãgaji: —Eperã k'ayaa bɨpa mɨ t'õbaijida aji. Mɨdeepa uchiajida aji, Ak'õre juapa ma eperã jɨpait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mãpai ma wẽrapa unuk'ãri p'oyaa miru-e paji, bɨɨrɨ wërewëree wãji mãik'aapa bedabaidachi Jesús bɨɨrɨmãi. Jõmaarã taide jaraji k'ãare-it'ee t'õbait'aaji mãik'aapa sãgá jɨpa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mãpai Jesupa mãgaji irumaa: —Wẽra, pɨa mɨde ijãa bairã, jɨpa beejida aji. K'ãiwee wã́ji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","At'ãri Jesús pedeemaa bɨde Jairo tedeepa pëida pacheji mãik'aapa mãgaji ma Ak'õre Ũraa jarateepata tedepema poromaa: —Pɨ k'au jai-idaajipɨ. Tachi Jarateepari ichiak'au bɨpáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mamĩda Jesupa mãga ũrik'ãri, mãgaji Jairomaa: —Waaweenaapáde aji. Jĩp'a ijãapáde aji. Pɨ k'au jɨpa beeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Temãi panadak'ãri, Jesupa chi k'õp'ãyoorã jõmaweda t'ĩupi-e paji. Aba t'ĩupiji Pedro, Santiago, Juan mãik'aapa chi k'ayaa nawe chi ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eperãarã taawa p'anadap'edaarã jõmaweda jẽe para baji t'ãri p'uapa. Mamĩda Jesupa mãgaji: —Jẽenáatɨ. Na wẽra k'au jai-idaa-e bɨ. Jĩp'a k'ãita bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mãga ũridak'ãri, jõmaarãta ëidachida iru-it'ee, k'awa p'anadap'edaa perã jai-idaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mamĩda Jesupa ma wẽra k'au juade jita atap'eda, golpe pedeeji: —Wẽra chai, ¡p'irabáiji! ");
INSERT INTO sjaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aweda chok'ai beeji mãik'aapa aramata p'irabaidachi. Mãpai Jesupa jaraji nek'opidamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chi ak'õreerã p'era pɨk'a jõneejida. Mamĩda Jesupa jaraji ma p'asada awaraarãmaa nepɨrɨnaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesupa chi k'õp'ãyoorã doce t'ɨ̃ p'e atap'eda, jaraji Tachi Ak'õre juapa netuara uchiapidamerã mãik'aapa k'ayaa k'ĩra t'ãdoo jɨpadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mãpai ãra pëiji k'ayaa beerã jɨpadamerã mãik'aapa jarateedamerã Tachi Ak'õrepa eperãarã bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mãgá pëirude Jesupa mãgaji: —Ode wãrutade ateenáatɨ pak'uru t'ɨdɨk'a wãdait'ee, muchila, pan, p'arat'a, maa-e pɨrã awaraa p'aru jɨ̃dait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","K'eudaik'ãri, parãpa unuruta tede p'anéetɨ, mamãik'aapa wãruta misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","P'uuru abaade parã auteebaida-e pɨrã mãik'aapa parãpa jarateepata ũridaamaa p'anɨ pɨrã, uchíatɨ ma p'uurudeepa mãik'aapa bɨɨrɨdepema yooro p'ora nẽep'étɨ ak'ɨpidait'ee Tachi Ak'õrepa ãra k'aripa-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mãpai chi k'õp'ãyoorã wãjida p'uuru bee chaa. Tachi Ak'õre pedee pia jara pëida jaratee wãpachida mãik'aapa k'ayaa beerã jɨpapachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herodepa ũrik'ãri Jesupa mãgee ne-inaa jõmaweda oo bɨ, k'awa-e paji k'ãata k'ĩsiait'ee. Eperãarã ũk'uruurãpa jarapachida Juan Bautista, chi piuda chok'ai p'irabaijida apachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ũk'uruurãpa jarapachida iru chonaarãwedapema Ak'õre pedee jarapari Elías. Jõdee awaraarãpa jarapachida awaraa chonaarãwedapema Ak'õre pedee jarapari, chok'ai p'irabaida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mamĩda Herodepa mãgaji: —Taarãru mɨa jara pëida Juan Bautista otau t'ɨap'et'aadamerã. ¿K'aipaa mãgɨ́ eperã? Mɨa ũridoo irua oopari ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mapa Herodepa Jesús k'ĩra unu k'inia baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús k'õp'ãyoorã pachedak'ãri ãchia jaratee nipadap'edaamaapa, irumaa nepɨrɨjida jõma ãchia oodap'edaa. Mãpai irua ãra ãyaa ateeji Betsaida p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mamĩda eperãarãpa k'awaadak'ãri, t'ẽe wãjida. Mãɨrã pacheruta unuk'ãri, Jesupa ãra auteebaiji mãik'aapa jarateeji Ak'õrepa eperãarã bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã. Ma awara ãra k'ayaa beerã jɨpaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","K'eupodopa chi k'õp'ãyoorã Jesumaa chejida mãik'aapa mãgajida: —Eperãarã pëipáde ajida, ɨ̃inadamerã mãik'aapa chik'o jɨrɨnadamerã p'uuru beemaa maa-e pɨrã aɨ ik'aawa eperãarã beemaa, nama wẽ-e perã nek'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mãpai Jesupa mãgaji: —Parãpa chik'o téetɨ k'odamerã. Ãchia p'anaujida: —Taipa iru p'anɨda ajida, pan joisomaa mãik'aapa chik'o omé. Mãgɨ́ araa-e pait'ee wãda-e pɨrã chik'o netode na eperãarã chok'ara para bɨɨrã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɨmɨk'ĩraarã cinco mil paji. Mamĩda Jesupa mãgaji chi k'õp'ãyoorãmaa: —Su-ak'ɨ p'aneepidapáde aji, cincuentacincuentaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aramãgá jõmaarãta su-ak'ɨ p'aneepijida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","T'ẽepai, Jesupa jitaji ma pan joisomaa chik'o omee ome mãik'aapa ɨt'aa ak'ɨp'eda, gracias jaraji Tachi Ak'õremaa ma chik'o pari. Mãpai k'õrak'oop'eda, teeji chi k'õp'ãyoorãpa eperãarãmaa jedenadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eperãarã nek'ojida bi jãwaa p'aneerutamaa. Maap'eda Jesús k'õp'ãyoorãpa p'ejida k'oraa docena aba, ma chik'o pan pite ome nɨ̃beeda. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ewari aba Jesús ɨt'aa t'ɨ̃maa bak'ãri chi k'õp'ãyoorã ome, ãramaa iidiji: —¿Mɨ k'aima a p'anɨma aji, eperãarãpa? ");
INSERT INTO sjaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","P'anaujida: —Ũk'uruurãpa jara p'anɨ pɨ Juan Bautista, piup'eda p'irabaida. Awaraarãpa jara p'anɨ pɨ chonaarãwedapema Elías. Jõdee awaraarãpa jara p'anɨ pɨ chonaarãwedapema Ak'õre pedee jarapari, chok'ai p'irabaida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mãpai Jesupa iidiji: —Parãpárama, ¿mɨ k'aima adaima? aji. Mãpai Pedropa p'anauji: —Pɨ Cristo, Tachi Ak'õrepa pëida eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mamĩda Jesupa jĩp'a jaraji mãga nepɨrɨnaadamerã awaraarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mãpai mãgaji: —Mɨ, chi Eperã Ak'õre Truadepema ichita chupɨria nɨ̃bait'ee. Judiorã poro waibɨarãpa, p'aareerã poroorãpa, mãik'aapa Moisepa p'ãda jarateepataarãpa mɨ k'ĩra unuamaa iru p'anadait'ee mãik'aapa mɨ peepit'aadait'ee. Mamĩda ewari õpeemaa mɨ chok'ai p'irabaiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","T'ẽepai Jesupa mãgaji jõmaweda ichi ome nipapataarãmaa: —Eperã mɨ ome nipa k'inia bɨ pɨrã, k'ĩsiaik'araa bɨ ichia ne-inaa oo k'inia bɨdepai. Ichi kuruso ãp'aipia bɨ eperã peenadait'eek'a. Pia jarait'eera, ewari chaa ooipia bɨ mɨa oopi bɨk'a, ma k'aurepa miapiruta pɨjida piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Eperã piuamaa bɨ pɨrã mɨde ijãapari k'aurepa, mãgɨ́ piuk'ãri, atuait'ee. Mamĩda eperã piuru pɨrã mɨde ijãapari k'aurepa, mãgɨ́ ɨt'aa wãit'ee ichi piuk'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma awara ¿k'ãare piata baima eperãpa ne-inaa pia na p'ek'au eujãde nɨ̃bɨ jõmaweda ataru pɨrã, mamĩda piup'eda chok'ai p'irabai-e pɨrã Ak'õre eujãde? Ichia net'aa iru bɨ atuait'ee mãik'aapa banait'ee tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Eperã k'ĩra nejasia bɨ pɨrã jarait'ee mɨde ijãa bɨ maa-e pɨrã mɨ ũraa jarait'ee awaraarãmaa, mãgara mɨ, chi Eperã Ak'õre Truadepema jida k'ĩra nejasia bait'ee mëreda ait'ee, mɨ Ak'õre Waibɨa k'ĩra wãreede chek'ãri iru angeleerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mɨa wãarata jararu. Nama p'anɨɨrã ũk'uru piudai naaweda, unudait'ee Tachi Ak'õrepa eperãarã bɨru ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tomiamaa mãga jarada t'ẽepai, Jesús wãji ee nok'odee. Ichi ome ateeji Pedro, Santiago mãik'aapa Juan. Mama iru ɨt'aa t'ɨ̃maa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mãgá ɨt'aa t'ɨ̃maa bɨde ichi k'ĩra awaradachi mãik'aapa chi p'aru t'o-t'oo uchiterreedachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mãga nɨde eperãarã jaure omé chejida mãik'aapa pedee p'aneejida iru ome. Chonaarãwedapemaarã Moisés Elías ome paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ãchi ik'aawa ɨ̃daa pia urua nɨ̃baji. Chejida Jesumaa jarade taarã-e nɨde chupɨria nɨ̃bait'ee mãik'aapa piut'ee Jerusalende. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mama ee nok'ode Pedro chi k'õp'ãyoorã ome tap'ok'ee jõnajida mĩda, k'ãida-ee p'anajida. Maperã unujida Jesús mãgá k'ĩra wãree mãik'aapa ma eperãarã omé. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma eperãarã Jesús ik'aawaapa uchiarutade Pedropa mãgaji: —Tachi Jarateepari, ¡pia bɨ nama p'anadait'ee pɨ ome! Oodait'eeda aji, te chak'eerã õpee, aba pɨ-it'ee, aba Moise-it'ee, chi apema Elia-it'ee. Mamĩda Pedropa k'ĩsia-ee mãga jaraji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iru pedee nɨ̃bɨde jɨ̃ararapa ãchi jõmaweda aneu ata cheji. Mãgá jɨ̃arara esajĩak'a ãchi unudak'ãri, nejasiadachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mãpai ma jɨ̃araradeepa Tachi Ak'õrepa pedeeji: —Nãgɨda aji, mɨ Warra k'inia, mɨa jɨrɨt'erada. ¡Ũrítɨ iru pedee! ");
INSERT INTO sjaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma pedee ũridap'eda, Jesús ituaba beeji ãra ome. Mãpai k'ĩup'ee p'aneejida. Ma t'ẽepai ãchia unuda ma ewate apidaamaa nepɨrɨda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Aɨ norema Jesús, Pedro, Santiago mãik'aapa Juan ee nok'odeepa edaa chedak'ãri, eperãarã chok'ara chejida Jesús ome unudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mãɨrãdepema eperã abaapa golpe pedeeji: —Tachi Jarateepari, mɨ chupɨria k'awaapáde aji. Mɨ warra apai iru bɨ ak'ɨnapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Netuarapa iru jita atak'ãri, biapipari, wawapipari mãik'aapa iduba k'õp'ep'ee uchiapipari iru it'aideepa. Iru ichiak'au bɨk'aa. Maperã piupiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mɨa pɨ k'õp'ãyoorãmaa chupɨria iidiji ma netuara uchiapit'aadamerã. Mamĩda p'oyaada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesupa p'anauji: —Aai, eperãarã, ¿at'ãrita mɨde ijãada-e p'anɨk'ã? ¡Ijãadak'aarã́k'apɨ p'anɨ! ¿Jõmasaa taarãit'ee parã ome ijãarutamaa? Anéetɨ ma warra. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma warra Jesús k'ait'a chek'ãri, netuarapa eujãde bat'at'aaji mãik'aapa waya wawat'aaji. Mamĩda Jesupa ma netuara ɨtrɨat'aaji mãik'aapa uchiapit'aaji. Ma warra mãgá jɨpap'eda, teeji chi ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Arii p'anadap'edaarã jõmaweda p'era pɨk'a para beeji, Ak'õrepa ne-inaa pia ooda unudap'edaa perã. Eperãarã ak'ɨtrua para beeru misa Jesupa ooda k'aurepa, irua mãgaji chi k'õp'ãyoorãmaa: ");
INSERT INTO sjaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Na pedee pia ũrítɨ mãik'aapa k'ĩra atuanáatɨ: eperãpa mɨ, chi Eperã Ak'õre Truadepema baaipiit'ee k'achia beerã juade. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mamĩda ãchia k'awada-e paji irua jara k'inia bada. Tachi Ak'õrepa ãramaa at'ãri mãga k'awapi k'inia-e baji. Ma awara ãchia waawee p'anajida iididait'ee k'ãata jara k'inia baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maapai Jesús k'õp'ãyoorã aupedee p'aneejida k'awaadait'ee ãchidepema k'aita waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesupa k'awaak'ãri ãrapa k'ĩsia p'anɨ, warra chai ataji mãik'aapa ak'ɨnɨ̃ bɨji ichi ik'aawa ");
INSERT INTO sjaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mãik'aapa mãgaji: —Eperãpa mɨde ijãa bɨ k'aurepa nãgɨ́ warra chaik'a auteebairu pɨrã, mɨ jida auteebaipari. Ma awara chi mɨ auteebairupa mɨ pëida auk'a auteebaipari. Mapa chi parãdepema ek'ariara pɨk'a bɨ audua-ee bairã, mãgɨta waibɨara pait'ee Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mãpai Juanpa mãgaji: —Tachi Jarateepari, taipa unujida eperãpa pɨ t'ɨ̃ jarap'eda, netuara uchiapi bɨ eperãarã k'ap'ɨadeepa. Mãga unudak'ãri, taipa oonaapáde ajida, tachi ome nipak'aa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesupa p'anauji: —Ichiak'au oopítɨ. Tachi ome nipak'aa pɨjida, tachi eere bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ewari k'ait'a pa wãk'ãri Jesús ɨt'aa wãit'ee, sõcharra wãji Jerusalén ode. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ichi naa eperãarã chok'a pëiji Samaria eujãdepema p'uuru k'aipee bɨmaa, te jɨrɨdamerã aɨde k'ãidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mamĩda ma Samaria eujãdepemaarãpa iru auteebai k'iniada-e paji, k'awa p'anadap'edaa perã judiorã p'uuru Jerusalendee wãru. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chi k'õp'ãyoorã Santiago Juan ome mãga k'awaa atadak'ãri, Jesumaa mãgajida: —Tachi Waibɨa, ¿k'inia bɨk'ã ajida, taipa pa ɨt'ɨɨpa baaipidamerã mãɨrã ɨ̃rɨ, jõdaidamerã? ");
INSERT INTO sjaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mamĩda Jesupa ãra ɨtrɨak'ooji, mãgá k'achia k'ĩsiadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mãpai wãjida awaraa p'uuru k'aipeedee. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ode wãdade eperãpa Jesumaa mãgaji: —Tachi Waibɨa, pɨ ome wã k'inia bɨda aji, chi wãrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesupa p'anauji: —Usap'ã́ yooro te uria iru bee mãik'aapa ipanaarã te iru bee. Mamĩda mɨ, chi Eperã Ak'õre Truadepema arajãgaa ni, k'ãipari wẽe. Made k'ĩsíaji, jarai naaweda wãara mɨ ome nipa k'inia bɨ wa mãga-e. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mãpai Jesupa mãgaji awaraa eperãmaa: —Mɨ ome nipa chéji. Irua p'anauji: —Tachi Waibɨa, mɨ jida pɨ ome nipaparii k'inia bɨ. Mamĩda aɨ naaweda mɨ ak'õre ɨapipáde aji, iru piuk'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesupa p'anauji: —Ichiak'au bɨpáde aji, atuadait'eerãpa ãchi piudap'edaarã ɨadamerã. Pɨ, jõdee, nipa chéji mɨ ome mãik'aapa jaratéeji Tachi Ak'õrepa eperãarã bɨit'ee ichi jua ek'ari ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mãpai awaraa eperãpa mãgaji: —Tachi Waibɨa, pɨ ome nipa k'inia bɨda aji. Mamĩda aɨ naaweda wãpíji mɨ tedepemaarã ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesupa p'anauji: —Eperãpa eujã p'ëirat'ɨmaa bɨ pɨrã aradopa, jĩp'a nok'ooree ak'ɨipia bɨ. Ãpɨtee ak'ɨru pɨrã, pia ba-e pait'ee Tachi Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Maap'eda Jesupa chi k'õp'ãyoorã awara setenta y dos jɨrɨt'eraji ichi ome nipapataarãdepema. Ãra ome-omee pëiji ichi naa wãdamerã p'uuru bee chaa ichi wãit'ee badamaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ãra pëik'ãri, mãgaji: —Eperãarã chok'ara mɨde waide ijãada-e p'anɨ. Ne-uu audú chau bɨ́k'apɨ p'anɨ. Mamĩda mimiapataarã chok'ara-ee p'anɨ. Mapa iidipatáatɨ Tachi Ak'õre, ma ne-uu chiparimaa awaraa mimiapataarã pëimerã chi chau bɨ p'ede. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wã́tɨ eperãarãmaa jarateede. Mɨa parã pëiru oveja chak'eerã pëik'ajik'a ne-animalaarã k'achia beerã t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na wãrutade ateenáatɨ muchila, p'arat'a maa-e pɨrã awaraa chancla. Ichiaba taarã ak'ɨnɨ̃ p'aneenáatɨ pedeedait'ee chi unurutaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Eperã tede t'ĩudak'ãri, naapɨara jarapatáatɨ: “Na te pidaarã pia p'anapatáatɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mãgá eperã t'ãri pia paraa pɨrã ma tede, iru k'ãiwee beeit'ee. Mamĩda iru t'ãri pia-e bɨ pɨrã parã ome, Tachi Ak'õrepa iru k'ãiwee bapi-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma tede p'anéetɨ. Ãrapa teeruta k'ótɨ mãik'aapa tótɨ, parã, mɨ mimiapataarãpa mãga atadaipia bairã pãchi mimia pari. Te awara-awaraa nipanáatɨ; te abaadepai p'anéetɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’P'uurude panadak'ãri, ma p'uurudepemaarãpa parã auteebairuta pɨrã, k'ótɨ ãrapa teeruta. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma p'uurudepema k'ayaa beerã jɨpak'óotɨ mãik'aapa mãɨrãmaa jarátɨ: “Tachi Ak'õrepa parã bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mamĩda awaraa p'uurude panadak'ãri, ma p'uurudepemaarãpa parã auteebaida-e pɨrã, calle jãde wãyaarutade nãga jarátɨ: ");
INSERT INTO sjaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Pãchi p'uurudepema yooro p'ora tai bɨɨrɨde beeda paara nẽep'eruta, parã t'ãri k'achia p'anadairã tai ome! K'awáatɨ Tachi Ak'õrepa parã bɨ k'inia bɨ ichi jua ek'ari ichideerã p'aneedamerã. Mamĩda parãpa mãga k'iniada-e.” ");
INSERT INTO sjaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mɨa jara bɨ: Ak'õre ewari waibɨa ewate irua ma p'uurudepemaarã audupɨara k'achia ooit'ee, chonaarãweda Sodoma pidaarã k'achia ooda k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—¡Aai, Corazín p'uurudepemaarã! ¡Aai, Betsaida p'uurudepemaarã! ¡Tachi Ak'õrepa parã k'achiadee pëiit'eepɨ! Tiro p'uurude, Sidón p'uurude eperãpa ooda paara ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa, mɨa parã p'uurude oodak'a, taarã-e weda ijãak'ajida. Ãrapa p'ek'au k'achia oopata oo amaa k'inia jõnɨpa chupɨria iidik'ajida Tachi Ak'õremaa. Ma p'ek'au k'achia oopata k'aurepa t'ãri p'uapa p'aru p'ãimaa jɨ̃k'ajida mãik'aapa it'abarre p'ora ɨt'aa p'ok'ajida ãchi poro ɨ̃rɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Maperã mɨa jara bɨ: Tachi Ak'õre ewari waibɨa ewate irua parã k'achiara ooit'ee ma Tiro p'uurudepemaarã k'ãyaara mãik'aapa Sidón p'uurudepemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ichiaba parã Capernaum p'uurudepemaarã, ¿k'ĩsia p'anɨk'ã parã p'uuruta awaraa p'uuru k'ãyaara waibɨara pait'ee Ak'õre k'ĩrapite? ¡Ma k'ãyaara irua parã p'uuruta jõt'aait'ee! ");
INSERT INTO sjaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’K'õp'ãyoorã, eperãpa parã pedee ũrik'ãri, mɨ pedeek'a ũriit'ee. Jõdee chi parã yiaraa iru bɨpa mɨ jida yiaraa iru bɨ. Ma awara mɨ yiaraa iru bɨ pɨrã, ichiaba mɨ Ak'õre, mɨ pëida, yiaraa iru bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma setenta y dos pëida eperãarã ãpɨtee chedak'ãri, t'ãri o-ĩ-ĩa p'anajida. Mãgapachida: —Tachi Waibɨa, ¡taipa pɨ k'ap'ɨa pari pedeedak'ãri, netuaraarãpa paara oopachida taipa jaradap'edaak'a! ");
INSERT INTO sjaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesupa p'anauji: —Wãara. Mɨa Satanás unuji ɨt'ariipa baaik'ãri pa baaiparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mɨa parã k'aripaji t'ɨadamerã taamaarã ɨ̃rɨ mãik'aapa tusõre ɨ̃rɨ, parãmaa maarepida k'aada-ee. K'aripaji chõopataadamerã Netuara Poro Waibɨa ome; irua parã p'ua oo-ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maperã parã t'ãri o-ĩa p'anadaipia bɨ. Mamĩda ma k'ãyaara o-ĩara p'anadaipia bɨ Tachi Ak'õrepa parã t'ɨ̃ p'ã iru bairã ɨt'ari ichideerã t'ɨ̃ p'ã jẽra bɨ librode. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mãgá pedee bɨde Tachi Ak'õre Jaurepa iru audú t'ãri o-ĩapiji. Mãpai irua mãgaji: —Ak'õre Waibɨa, pɨ jõmaarã k'ãyaara waibɨara bɨ. Ne-inaa jõmaweda ɨt'ari nɨ̃bɨ, na p'ek'au eujãde nɨ̃bɨ paara pɨ jua ek'ari bɨ. Mɨ t'ãri o-ĩa bɨ pɨa eperãarã jĩp'aarãmaa k'awapiru perã ne-inaa pɨa waide k'awapi-e pada k'ĩsia k'awaa beerãmaa mãik'aapa poro wẽsaa beerãmaa. Mãga ooji mãga oo k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Mɨ Ak'õrepa ne-inaa jõma bɨji mɨ jua ek'ari mɨa ak'ɨpariimerã. Tachi Ak'õrepapai wãara mɨ, ichi Warra k'awa bɨ. Mãgá ichiaba mɨ, chi Warrapapai wãara iru k'awa bɨ. Mamĩda mɨa iru k'awapii mɨa k'awapi k'inia bɨ eperãarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mãpai Jesupa ak'ɨji chi k'õp'ãyoorãmaa mãik'aapa mãgaji: —Parã, chi na ne-inaa unu p'anɨɨrã, wãara t'ãri o-ĩa p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mɨa jara bɨ: Chonaarãweda Ak'õre pedee jarapataarãpa mãik'aapa reyrãpa unu k'inia p'anajida parãpa unu p'anɨ. Mamĩda unuda-e paji. Ichiaba ũri k'inia p'anajida parãpa nama ũri p'anɨ. Mamĩda ũrida-e paji, ewari ma-it'ee waide pa-e bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ewari aba Moisepa p'ãda jarateepari pedeenaji Jesús ome. K'awaait'ee Jesupa wãara Ak'õre Ũraa k'awa bɨ wa mãga-e, mãgɨpa iidiji: —Tachi Jarateepari, ¿k'ãata ooyama aji, mɨ ɨt'aa wãit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesupa p'anauji: —¿K'ãata jara bɨ Moisepa p'ãdade? ¿K'ãata unu bɨma aji, aɨde? ");
INSERT INTO sjaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma Moisepa p'ãda jarateeparipa p'anauji: —‘Tachi Ak'õre Waibɨa k'inia iru baparíiji pɨchi t'ãripa mãik'aapa ne-inaa jõmaa k'ãyaara iru k'inia iru baparíiji. Ewari chaa k'ĩsíaji irude pɨchi t'ãripa;’ ‘ma awara awaraarã k'inia iru baparíiji, pɨchi k'ap'ɨa k'inia iru baparik'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mãpai Jesupa mãgaji: —Pia p'anaujipɨ. Mãga ooru pɨrã, ichita bapariit'ee Ak'õre eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mamĩda ma Moisepa p'ãda jarateeparipa waapɨara k'awaa k'inia baji. Mapa iidiji: —Pɨa awaraarãda ak'ãri, ¿k'aita jara k'inia bɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mãpai Jesupa nãga nepɨrɨji jarateeit'ee: —Eperã Jerusalén ode wãji Jericó p'uurudee. Mãgá ode wãde nechɨapataarã uchiajida. Ma eperã p'ua oojida mãik'aapa iru p'aru paara chɨa atajida. Perá peet'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɨɨ-ap'eda, p'aare cheji ma ode. Mamĩda ma eperã eujãde bɨ unuk'ãri, jĩp'a wãyaaji ichi ode. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","T'ẽepai Leví ëreerãdepema uchiada ichiaba ma ode che wãji. Mamĩda ma eperã mãgá unuk'ãri, ichiaba jĩp'a ichi ode wãyaaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma t'ẽepai Samariadepema ichiaba ma ode cheji. Mãgɨpa ma eperã unuk'ãri, iru chupɨria k'awaaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iru k'ait'a wãp'eda, aceite vino ome p'uruji iru k'ap'ɨa p'ua bɨmãi mãik'aapa p'aru sorede beda ataji. Mãpai ma eperã su-ak'ɨ bɨnaji ichi burrode mãik'aapa ateeji eperãarã temaa ak'ɨ p'anadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aɨ norema ma Samariadepemapa p'arat'a tau omé ẽt'a atap'eda, teeji ma te chiparimaa mãik'aapa mãgaji: “Jã eperã ak'ɨ baparíiji mɨ cheru misa. Na p'arat'a awara faltaru pɨrã, mɨa p'aait'eeda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mãga nepɨrɨp'eda, Jesupa iidiji ma Moisepa p'ãda jarateeparimaa: —¿K'ãata k'ĩsia bɨma? aji. ¿Ma õpeedepema chisãgɨpa ma eperã ak'ɨjima ichi k'ap'ɨa ak'ɨparik'a? ");
INSERT INTO sjaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma Moisepa p'ãda jarateeparipa p'anauji: —Chi chupɨria k'awaadapa pajida aji. Mãpai Jesupa mãgaji: —Pɨa auk'a oopáde aji, chupɨria chedeerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Maap'eda ma ode Jesús waya wã nipaji Jerusalendee. Panaji p'uuru k'aipeede. Mama wẽra t'ɨ̃jarapatap'edaa Martapa iru auteebaiji ichi tede. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ɨ̃pewẽra María mama baji. Ichi Jesús bɨɨrɨ ik'aawa su-ak'ɨ beeji ũriit'ee irua jararu. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mamĩda Marta ne-inaa audú oomaa beeji nek'opiit'ee Jesumaa mãik'aapa chi k'õp'ãyoorãmaa. Mapa Jesús k'ait'a cheji mãik'aapa mãgaji: —Tachi Waibɨa, ¿pɨ-it'ee p'ua-e bɨk'ã aji, mɨ ɨ̃pewẽrapa mɨ k'aripa-e bɨ? Mɨa ne-inaa chok'ara iru bɨ ooit'ee. Mapa jaráji irua k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mamĩda Jesupa p'anauji: —Marta, Marta, pɨ audú k'ĩsia nɨ̃bɨda aji, ne-inaa pi-ia oo k'iniapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mamĩda Mariapa ne-inaa piara jɨrɨji ooit'ee, mɨ nama bɨ misa. Apidaapa jarada-e pait'ee irua mãga oonaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ewari aba Jesús ɨt'aa t'ɨ̃ aupak'ãri, k'õp'ãyo abaapa mãgaji: —Tachi Waibɨa, jaratéeji taipa ɨt'aa t'ɨ̃ k'awaadamerã, Juan Bautistapa chi k'õp'ãyoorãmaa jarateedak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mãpai Jesupa mãgaji: —Parã ɨt'aa t'ɨ̃dak'ãri, nãga jarátɨ: Tachi Ak'õre ɨt'ari bɨ, pɨ t'ɨ̃ awaraa t'ɨ̃ k'ãyaara pipɨara bɨ. Eperãarã bɨ́ji pɨchi jua ek'ari pɨchideerã p'aneedamerã. Óoji pɨchia k'inia bɨk'a na p'ek'au eujãde, ɨt'ari ooparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tai-it'ee chik'o téeji ewari chaa k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Taipa p'ek'au k'achia oopata chupɨria k'awáaji mãik'aapa perdonáaji taipa perdonaapatak'a, awaraarãpa taimaa ne-inaa k'achia oodak'ãri. Tai k'achiade baaipináaji. Tai k'aripa atáji Netuara Poro Waibɨa juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ichiaba Jesupa mãgaji: —K'ĩsiadáma nãgɨde. Parãdepemapa k'õp'ãyo iru bai. Esapɨte pɨ wãi iru temaa mãik'aapa jarai: “K'õp'ãyo, mɨ-it'ee pan õpee téeji, ");
INSERT INTO sjaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","k'õp'ãyo aba et'ewapai t'ɨmɨɨpa pacheda perã mɨ temãi. Maarepida wẽe bɨ teeit'ee k'omerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mãga p'asada paara, irua jara-e pai: “Mɨ ichiak'au bɨ́ji. Puerta jɨ̃a iru bɨ. Mɨ warrarã mɨ ome nama k'ãi p'anɨpɨ. Mapa p'irabai-eda a-e pai, pɨmaa ne-inaa teede.” ");
INSERT INTO sjaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mɨa jara bɨ: Mãgɨ́ k'õp'ãyo p'irabai-e pɨrã ne-inaa teeit'ee pɨ ichi k'õp'ãyo perã, mãgara p'irabaiit'ee waa iidi nɨ̃banaamerã. Teeit'ee ne-inaa jõma pɨa falta bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Maperã mɨa nãga jara bɨ. Iidipatáatɨ Tachi Ak'õremaa. Irua teeit'eepɨ. Jɨrɨpatáatɨ. Irua k'awapiit'eepɨ. Eperãpa puerta t'aide t'ɨ̃parik'a, Ak'õremaa t'ɨ̃patáatɨ. Irua parã k'aripait'eepɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi iidi bɨmaa Tachi Ak'õrepa teepari; chi jɨrɨ bɨmaa Tachi Ak'õrepa k'awapipari mãik'aapa chi t'ɨ̃ bɨmaa ewapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Parãdepema ak'õrepa taama teeik'ã ichi warramaa, irua chik'o iidik'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Maa-e pɨrã, ¿tusõre teeik'ã irumaa, ne-ɨmɨ iidik'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","¡Mãga-epɨ! Parã, ne-inaa k'achia oopataarã mĩda, pãchi warrarãmaa net'aa pia tee k'awa p'anɨ. Parãpa mãga ooruta pɨrã, ¡audupɨara pãchi ɨt'aripema Ak'õre Waibɨa ichi Jaure teeit'ee chi iidirutaarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ewari aba Jesupa netuara uchiapimaa baji eperã pedee atua bɨ k'ap'ɨadeepa. Ma netuara uchiak'ãri, ma eperã pedee beeji. Mãga unudak'ãri, arii p'anadap'edaarã ak'ɨtrua para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mamĩda ũk'uruurãpa mãgajida: —Beelzebú, Netuara Poro Waibɨa juapata jãgá netuaraarã uchiapiparida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mãpai awaraarãpa Jesús ɨmɨatee k'inia p'anadap'edaa perã, iidijida ne-inaa oomerã Tachi Ak'õrepapai oopari. Mãga ooru pɨrã, k'awadayada ajida, Tachi Ak'õre juapa ooda. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mamĩda Jesupa k'awaji ãchia k'ĩsia p'anɨ. Mapa mãgaji: —P'uuru pidaarãpa ãchi auk'aarã jëreruta pɨrã, waa araa p'anapataada-e pai. Ãchi itu jõdaridait'ee mãik'aapa ãchi te ãri baibeeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mãga pɨk'a Netuara Poro Waibɨapa ichi auk'aarã jëreru pɨrã, ãchi itu jõdaridai. Parãpa jara p'anɨk'a mɨ Beelzebú eere bada paara, ichideerã jëre-e pak'aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma awara mãga pada paara ¿k'ai juapa parã eere p'anɨɨrãpa netuaraarã uchiapipatama? ¡Netuara juapa-epɨ! Ãchiata ak'ɨpipata parã pia k'ĩsiada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jõdee mɨa netuaraarã uchiapipari pɨrã Tachi Ak'õre Waibɨa juapa, jara k'inia bɨ ɨ̃rá Tachi Ak'õredeerã poro waibɨa nama bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Eperã juataura bɨpa ichi te jɨ̃ak'ãri espada ome, k'ĩsia bɨ apida t'ĩuda-e pai ichi net'aa chɨade. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mamĩda eperã iru k'ãyaara juataura bɨ cheru pɨrã mãik'aapa iru p'oyaaru pɨrã, iru espada jãri atai mãik'aapa iru net'aa p'e atadari. Mɨ waibɨara bɨ Netuara Poro Waibɨa k'ãyaara. Mapa netuaraarã mɨ jua choodak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Eperã mɨ eere bɨ-e pɨrã, mɨ k'ĩra unuamaa iru bɨ. Ichiaba mɨ k'aripa-e bɨ pɨrã awaraarã Tachi Ak'õre jua ek'ari p'anapataadamerã, eperãarã ãyaa pëipari mɨ ik'aawaapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Eperã k'ap'ɨadeepa netuara uchiapidak'ãri, mãgɨpa jɨrɨ nipapari eujã p'ũasaa sãma ɨ̃iit'ee. Mamĩda unu-e pak'ãri, k'ĩsiapari: “Waya merãtɨanait'ee ma eperã k'ap'ɨade, mɨ naaweda badamãi.” ");
INSERT INTO sjaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chek'ãri, unu chepari ma eperã k'ap'ɨa pi-ia bɨ; te barrep'eda, sɨɨp'eda pi-ia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mãga unuk'ãri, jɨrɨnapari awaraa netuara siete k'achiara ichi k'ãyaara mãik'aapa ma eperã k'ap'ɨade merãtɨa chepata. Mãgá ma eperã audupɨara k'achiade beeit'ee naaweda bada k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesupa mãgá pedeemaa bɨde arii p'anadap'edaarãdepema wẽrapa mãgaji: —¡T'ãri o-ĩa bapari pɨ nawe, chi pɨ t'oda mãik'aapa warida! ");
INSERT INTO sjaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesupa p'anauji: —¡Ma k'ãyaara t'ãri o-ĩara bapari chi Tachi Ak'õre pedee ũrip'eda, ooparipa ma jara bɨk'a! ");
INSERT INTO sjaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mãgá pedee bɨde eperãarã cho-k'ara chepachida iru ik'aawa seedarutamaa. Mãpai ichia jaramaa beeji ãramaa: —Parã ɨ̃rapemaarã t'ãri k'achia-idaa p'anɨda aji. Iidipata mɨa oomerã ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mamĩda Tachi Ak'õrepa ooit'ee chonaarãweda Jonás ome oodak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tachi Ak'õrepa Jonás pëidak'a Nínive p'uurudepemaarãmaa ichi pedee jaramerã, mãga pɨk'a mɨ, chi Eperã Ak'õre Truadepema pëiji ichi pedee jaramerã parã ɨ̃rapemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tachi Ak'õre ewari waibɨa ewate irua parã ɨ̃rapemaarãpa oopatap'edaa ak'ɨk'ãri jarait'ee pia wa k'achia, Reina Sur Eerepemapa parã ɨmɨateeit'ee Tachi Ak'õrepa k'achiadee pëimerã. Chonaarãweda ma reina t'ɨmɨɨpa cheji Rey Salomón k'ĩsia k'awaa bɨ pedee ũride. Mamĩda nama bɨ aba waibɨara bɨ Salomón k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma ewate ichiaba Nínive p'uuru pidaarãpa parã ɨ̃rapemaarã ɨmɨateedait'ee, Tachi Ak'õrepa parã k'achiadee pëimerã. Chonaarãweda Tachi Ak'õrepa Jonás pëik'ãri Nínive pidaarãmaa, ãrapa p'ek'au k'achia oopatap'edaa oo amaa wãjida. Mamĩda parã ɨ̃rapemaarãpa p'ek'au k'achia oopata oo amaada-e, aba Jonás k'ãyaara waibɨara bɨpa jara cheji mĩda mãga oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Lámpara k'oodak'aa mera bɨdait'ee ne-inaa ek'ari. Ma k'ãyaara k'oodak'ãri, ne-inaa ɨ̃rɨ ɨt'ɨ́ ata bɨpata, jõma te jãde p'anɨɨrãpa ɨ̃daa unudamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tachi tau lamparak'a ɨ̃daa pɨk'a bɨ tachi k'ap'ɨa-it'ee. Pɨchi tau pia bak'ãri, k'ap'ɨa jõmaweda ɨ̃daa pɨk'a bɨde bait'ee. Mamĩda pɨchi tau k'achia bɨ pɨrã, k'ap'ɨa jõmaweda p'ãriu pɨk'a bɨde bait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","K'ĩrak'aupai pɨ ɨ̃daa pɨk'a bɨ p'ãriu pɨk'a padarii. Pia jarait'eera, k'ĩrak'aupai k'ĩsiai pɨa Tachi Ak'õre wãara k'awa bɨ, mɨ ũraade ijãa-e bɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɨ ũraade ijãa bɨ k'aurepa pɨ k'ap'ɨa jõmaweda ɨ̃daa pɨk'a bɨde bɨ pɨrã, Tachi Ak'õre wãara k'await'ee, lámpara uruade ne-inaa pia unupatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús pedee aupak'ãri, fariseo abaapa jaraji ichi ome wãmerã ichi temaa nek'ode. Ma tede t'ĩup'eda, Jesús mesade su-ak'ɨ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma fariseo p'era pɨk'a baji Jesupa ichi jua sɨɨ-e pada perã nek'oi naaweda, fariseorãpa oopatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mamĩda Jesupa mãgaji: —Parã fariseorãpa vaso mãik'aapa p'arat'u taawaik'a eere pi-ia sɨɨpatada aji. Mamĩda mãgɨ́ edajãde ipuru bɨ ne-inaa k'achiapa, parã t'ãri k'achia p'anadairã. Chĩara net'aa chɨapata mãik'aapa chĩara k'ũrapata. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Parã k'ĩsia k'awada-ee p'anɨ! ¿K'awada-e p'anɨk'ã chi parã k'ap'ɨa oodapa parã t'ãri ichiaba ooda? ");
INSERT INTO sjaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eperãarã chupɨria k'awáatɨ mãik'aapa t'ãripa ãchimaa ne-inaa téetɨ. Mãpaipɨ Tachi Ak'õrepa parã pia ak'ɨpariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Aai, Tachi Ak'õrepa parã fariseorã k'achiadee pëiit'ee! Tachi Ak'õre-it'ee nãgee aliño awara bɨpata: menta, ruda, awaraa ne-inaa k'arra ome; mãgɨ́ diezdepema chaa, aba. Mamĩda parã-it'ee p'ua-e bɨ ne-inaa oodait'ee Ak'õrepa oopi bɨk'a, iru k'inia iru p'anadairã. Mãgata oodaipia bɨ parãpa ne-inaa oopata ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Aai, Tachi Ak'õrepa parã fariseorã k'achiadee pëiit'ee! Tachi Ak'õre Ũraa jarateepata tede p'anadak'ãri, su-ak'ɨ beepari pipɨara bɨde su-ak'ɨ p'aneepata, k'inia p'anapata perã eperãarãpa parã ak'ɨdamerã ãchi waibɨarãk'a. Ma awara calle jãde nipadak'ãri, k'inia p'anapata jõmaarãpa parãmaa saludaadamerã, ãchi poro waibɨarã ome oopatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Aai, Tachi Ak'õrepa parã k'achiadee pëiit'ee! Eperãarã pariatua jãɨra ɨ̃rɨ t'ɨapata, k'awada-ee aɨde eperã piuda bɨ. Parã ma jãɨrák'ata p'anɨ, pãchi t'ãride k'ĩsia k'achia iru p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mãpai Moisepa p'ãda jarateeparipa mãgaji: —Tachi Jarateepari, pɨa ma pedee jarak'ãri, ichiaba taimaa ik'achia jara bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mamĩda Jesupa mãgaji: —¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã ichiaba k'achiadee pëiit'ee! Eperãarãmaa audú ne-inaa chok'ara oopipata tachi chonaarãpa chonaarãweda oopatap'edaak'a. Mamĩda ãrapa ma jõma p'oyaa ooda-e pak'ãri parãpa jarapatak'a, maarepida k'aripada-e. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Aai, Tachi Ak'õrepa parã k'achiadee pëiit'ee! Pi-ia oopata chonaarãwedapema Ak'õre pedee jarapataarã ɨadap'edaamãi, eperãarãpa ãra k'irãpadamerã. ¡Mamĩda parã chonaarã́pata ãra peek'oojida! ");
INSERT INTO sjaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Parãpa mãga oodak'ãri, ak'ɨpipata auk'a ook'ajida pãchi chonaarãpa oodap'edaak'a, parã ɨ̃rapemaarãpa auk'a ũridaamaa p'anapata perã Ak'õre pedee jarapataarãpa jara p'anɨ. Ãchia ma Ak'õre pedee jarapataarã peek'oojida mãik'aapa parãpa mãgɨɨrã ɨadap'edaamãi pi-ia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Mapa Tachi Ak'õrepa na k'ĩsia k'awaa pedee jaraji: “Mɨ pedee jarapataarã pëiit'eeda aji, mɨ ũraa jarateepataarã ome. Mamĩda ũk'uru peedait'ee; jõdee awaraarã jɨrɨdait'ee miapidait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Parã chonaarãpa mãga oopachida. Ak'õre pedee jarapataarã peepachida. Maperã ɨ̃rá Tachi Ak'õrepa parã k'achia ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Na eujã oodak'ãriipa iru pedee jarapataarã peepata; Abeldeepa Zacarías parumaa. Ma Zacarías peejida Tachi Ak'õre tede, te t'ĩupata altarmãi esajĩak'a. Maperãpɨ mɨa jara bɨ: Tachi Ak'õrepa ɨ̃rapemaarã k'achia ooit'ee ma oopatap'edaa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Aai, Tachi Ak'õrepa parã Moisepa p'ãda jarateepataarã k'achiadee pëiit'ee! Eperãarãpa llave iru p'anapatak'a puerta ewadait'ee, mãga pɨk'a parãpa Tachi Ak'õre Ũraa iru p'anapata. Mamĩda ma ũraade jara bɨ awaraarãmaa k'awapidaamaa p'anɨ. K'iniadak'aa awaraarãpa ma pedee ũridamerã mãik'aapa oodamerã irua jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesupa ma jõma jarap'eda, ma Moisepa p'ãda jarateepataarã mãik'aapa fariseorã k'ĩraudachida. Iidida chok'ara iidi p'aneejida iru k'achiade baaipidai jĩak'aapa irua p'anauda k'aurepa. Mamĩda p'oyaa ɨmɨateeda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús at'ãri mama bɨde eperãarã audupɨara see nɨ̃ba cheji iru badamãi. Audú cho-k'ara nɨ̃bada perã, awaraarã bɨɨrɨ ɨ̃rɨ paara t'ɨak'oo wãpachida. Mãpai Jesupa jarateemaa beeji chi k'õp'ãyoorãmaa: —K'ĩrak'aupai fariseorã levadura ome; pia jarait'eera, ãchia jarateepata ome. Jarateepatada apata Tachi Ak'õrepa k'inia bɨ eperãarãpa oodamerã. Mamĩda ãchia mãga oodak'aa, t'ãri k'achia p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tachi Ak'õrepa ãchi k'ĩsia t'ãridepai k'awaapiit'ee mãik'aapa ãchia ne-inaa mera oopata unupiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wãara ne-inaa jõmaweda parãpa mera jarapata irua tau taawa k'awaapiit'ee. Pãchi puerta jɨ̃adap'eda pedee mera jaradap'edaa paara tau taawa k'awaapiit'ee terraza ɨ̃rɨɨpa biaruk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Mɨchi k'õp'ãyoorã, mɨa nãga jara bɨ. Waaweenáatɨ parã jɨrɨ p'anɨɨrã peedait'ee, ãrapa parã p'oyaa atuapida-e perã tok'arradee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jarait'ee k'aita waaweedaipia bɨ. Tachi Ak'õre waawéetɨ iruata tachi piupii perã mãik'aapa atuapii perã. Wãara iruta waaweedaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Netopata-ek'ã ipana chak'e joisomaa p'arat'a tau omee pari? Eperãarãpa mãga oopata ipana chak'e mak'ɨara vale-e bɨ jĩak'aapa. Mamĩda Tachi Ak'õrepa ma ipana chak'eerã pia ak'ɨpari. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Parã jida mãgá ak'ɨpari. Parã puda paara irua juasia iru bɨ. Mapa waaweenáatɨ, Tachi Ak'õrepa parã k'iniara iru bapari perã ipanaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Mɨa nãga jara bɨ. Eperãpa tau taawa jararu pɨrã ichi Jesucristode ijãapari, mɨ, chi Eperã Ak'õre Truadepemapa pida jarait'ee: “Mãgɨ́ mëré” Tachi Ak'õre angeleerã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mamĩda eperãpa meraru pɨrã mɨde ijãapari, mãgara mɨa pida merait'ee. “Mãgɨ́ mëre-eda” ait'ee Tachi Ak'õre angeleerã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Tachi Ak'õrepa eperãarãpa p'ek'au k'achia oopata wẽpapik'ãri, wẽpapii ãchia ik'achia jarapata paara Eperã Ak'õre Truadepema ãpɨte. Mamĩda ik'achia jararuta pɨrã iru Jaure ãpɨte, mãgee p'ek'au k'achia wẽpapi-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Parã mɨde ijãapata k'aurepa eperãarãpa parã ateedak'ãri Ak'õre Ũraa jarateepata tede maa-e pɨrã charraarãmaa mãik'aapa poro waibɨarãmaa ɨmɨateedait'ee, k'ĩsianáatɨ sãga p'anaudait'ee maa-e pɨrã k'ãata jaradait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mãɨrã k'ĩrapite panadak'ãri mãik'aapa pedeedait'ee pak'ãri, Tachi Ak'õre Jaurepa jarateeit'ee, p'anau k'awaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","See nɨ̃badadepema abaapa Jesumaa mãgaji: —Tachi Jarateepari, jaráji mɨ ɨ̃pemamaa tai ak'õrepa net'aa bëida t'oomerã mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesupa p'anauji: —K'õp'ãyo, ¿k'aipa mɨ bɨjima aji, parã charrak'a mãga jaramerã? ");
INSERT INTO sjaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ichiaba mãgaji: —K'ĩrak'aupai net'aa k'ɨ̃adai. Eperãarã t'ãri o-ĩa p'anadak'aa net'aara p'e iru p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mãpai Jesupa nãga nepɨrɨji jarateeit'ee ma et'ewa jaradade: ’Eperã p'arat'ara bɨ bapachi. Ne-uu waibɨa iru bada perã, net'atau waibɨa ewapachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mapa k'ĩsia beeji: “¿K'ãata ooyama? aji. Te wẽe bɨ mɨchi net'atau jõmaweda ɨait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mãpai ma p'arat'ara bɨpa k'ĩsia ataji. “K'awa bɨda aji, k'ãata ooit'ee. Mɨ net'atau ɨapata te wãrait'ee mãik'aapa awaraa te waibɨara oo atait'ee. Mãgá mɨchi net'atau net'aa iru bɨ ome, jõmaweda ɨayada aji, ma tede. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Maapai mɨa jarai mɨchi t'ãridepai: ‘Mɨa net'aara iru bɨ. Nãgɨ́ ome año chok'ara pia bapariit'ee. Ɨ̃rá ɨ̃iit'ee, nek'oit'ee, ne-inaa toit'ee mãik'aapa o-ĩa bapariit'eeda’ aji.” ");
INSERT INTO sjaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mamĩda ma p'arat'ara bɨpa mãga k'ĩsia bɨde Tachi Ak'õrepa irumaa mãgaji: “¡Pɨ k'ĩsia k'awa-ee bɨ! Idi weda p'ãrik'ua pɨ piut'ee. Maap'eda, ¿k'aipa atait'eema aji, pɨa net'aara ɨa iru bɨ?” ");
INSERT INTO sjaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma nepɨrɨ aupak'ãri, Jesupa mãgaji: —Mãgá uchiait'eeda aji, eperãpa net'aara p'e atak'ãri ichi-it'ee, Tachi Ak'õrede ijãa-ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Maap'eda Jesupa mãgaji chi k'õp'ãyoorãmaa: —Mɨa jara bɨ: K'ĩsia jõnanáatɨ k'ãata k'odait'ee mãgá chok'ai p'anadait'ee. Ichiaba k'ĩsianáatɨ sãga p'aru atadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tachi Ak'õrepa tachi chok'ai p'anapipari. Iruata tachimaa chik'o teeit'ee. Ma awara irua tachi k'ap'ɨa ooda perã, tachimaa p'aru teeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pɨchá, ak'ɨ́tɨ jã ipanaarã. Ãchia net'atau uudak'aa, ewadak'aa mãik'aapa ɨa bɨdak'aa chi net'atau ɨapatamãi. Mamĩda Tachi Ak'õrepa ne-inaa teepari k'odamerã. ¡Iru-it'ee parã pipɨara p'anɨ ipanaarã k'ãyaara! ");
INSERT INTO sjaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Eperã audú k'ĩsia nɨ̃bɨpa hora aba pida waa chok'ai ba-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma ne-inaa ma-ãri p'oyaa oodak'aa pɨrã, ¿sãap'eda k'ĩsia jõnɨma awaraa ne-inaa p'oyaa ooda-e p'anadak'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ak'ɨ́tɨ sãga nep'ono waripata. Mimiadak'aa mãik'aapa p'aru k'adak'aa mãgá pi-ia p'anadait'ee. Mamĩda mɨa jara bɨ: Rey Salomonpa p'arat'ara, net'aa pia iru bapachi mĩda, iru p'aru piara jɨ̃ bak'ãri, eperãarãpa iru pi-iara unuda-e paji nãgɨ́ nep'ono k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tachi Ak'õrepa na p'ũajara pia t'onopipari. Idi wari wã. Mamĩda nu uratɨdaik'ãri, t'ɨpɨtaude paa jõdariit'ee. Tachi Ak'õrepa mãgá pia ak'ɨ bɨ pɨrã nep'ono p'ũajara t'ãide nɨ̃bɨ, audupɨara parã ak'ɨ bapariit'ee, at'ãri irude mak'ɨara ijãada-e p'anɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tachi Ak'õrepa mãgá ichia ooda pia ak'ɨ bapari perã, k'ĩsia jõnanáatɨ jɨrɨdait'ee ne-inaa k'odait'ee maa-e pɨrã ne-inaa todait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mãga k'ĩsiapata na p'ek'au eujãdepema ijãadak'aa beerãpa. Mamĩda parã́pata ɨt'aripema Ak'õre Waibɨa iru p'anɨ. Irua k'awa bɨ ne-inaa parãpa falta p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Maperãpɨ jɨrɨ́tɨ p'anapataadait'ee iru jua ek'ari. Mãga ooruta pɨrã, ma ne-inaa jõma iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—K'õp'ãyoorã, parã mɨchi ovejaarãk'a p'anɨ. Mapa waaweenáatɨ. Parã chok'ara-ee p'anɨ. Mamĩda Tachi Ak'õrepa parã k'inia iru bɨ. Mapa parã bɨji ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Maperã parãpa net'aa iru p'anɨ netok'óotɨ mãik'aapa chupɨria beerãmaa téetɨ. Na p'ek'au eujãdepema muchila atadai k'ãyaara, óotɨ Tachi Ak'õrepa k'inia bɨk'a. Mãgá atadai ɨt'aripema ne-inaa, sore pak'aa. Ma ne-inaa pi-ia bɨmãi nechɨapataarã p'oyaa t'ĩudak'aa mãik'aapa polillapa p'oyaa ãridak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na p'ek'au eujãdepema ne-inaa pia audú ata k'inia bak'ãri, pɨ t'ãri araa bait'ee ma ne-inaa ome. Jõdee ɨt'aripema ne-inaa pia audú ata k'inia bak'ãri, pɨ t'ãri araa bait'ee mãgɨ́ ne-inaa ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Mɨ parã poro waibɨa perã, mɨ waya cheit'ee nɨdaipia bɨ, mimiapataarãpa p'aru jɨ̃dap'eda lámpara k'oopatak'a ãchi chipari cheru misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mimiapataarãpa nɨpatak'a chipari teedaa cheru misa miak'ãipata fiesta oop'eda, puerta ewadait'ee iru t'ɨ̃k'ãri, mãga pɨk'a parã nɨdaipia bɨ parã poro waibɨa cheit'ee ewate. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma mimiapataarã chiparipa ãra pia ak'ɨpariit'ee, chok'ai p'anaruta pɨrã iru pachek'ãri. Mɨa jara bɨ: Irua ãra mãgá unuk'ãri, jarait'ee su-ak'ɨ p'aneedamerã mesade, ichia ãchimaa chik'o teeru misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ichia ma mimiapataarã pia ak'ɨpariit'ee mãgá chok'ai p'anadak'ãri, ichi esapɨte maa-e pɨrã ɨ̃datɨpodopa cheru pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mamĩda nãga k'awáatɨ parãpa. Te chiparipa k'awa bada paara nechɨapari cheit'ee hora ichi net'aa chɨa atait'ee, chok'ai bak'aji ma nechɨapari ichi tede t'ĩupiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mãgá parã jida chok'ai pɨk'a p'anadaipia bɨ, atu p'anɨde mɨ, chi Eperã Ak'õre Truadepema, cheit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedropa Jesumaa iidiji: —Tachi Waibɨa, ¿ma pedee nepɨrɨjik'ã aji, tai-it'ee aupai, wa jõmaarã-it'ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesupa nãga nepɨrɨji: ¿Sãgá baparima aji, mimiapataarã poro waibɨa pia? Mãgɨpa k'ĩsia k'awaa oopari chiparipa oopi bɨk'a. Pia ak'ɨpari chipari net'aa atabëida ichi juade mãik'aapa chiparimaa nek'opip'eda, mimiapataarãmaa chik'o tawapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","O-ĩa bapari chipari pachek'ãri, ichi mimiamaa unu chepari perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mɨa wãarata jararu. Chiparipa mãga unu chek'ãri, jõma ichia net'aa iru bɨ bɨit'ee ma mimiapari jua ek'ari ak'ɨ bamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mamĩda ma mimiapari t'ãri k'achia bɨ pɨrã, nãga k'ĩsiai: “Taarãit'ee mɨ chipari.” Mapa apemaarã mimiapataarã wɨmaa beei mãik'aapa tomaa beei, nek'omaa beei toyaa beerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mamĩda ma mimiapari k'achia atu bɨde, chi te chipari pacheit'ee. Mãpai irua ooda k'awaa atak'ãri, iru miapiit'ee mãik'aapa ãyaa pëit'aait'ee awaraa ijãadak'aa beerã chupɨria chitoonɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mimiaparipa k'awaak'ãri chiparipa oopi bɨ, mamĩda chipari nɨ-e mãik'aapa oo-e irua k'inia bɨk'a, chiparipa ma mimiapari wɨma chok'ara wɨpiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mamĩda mimiaparipa mãgee ne-inaa k'achia ooru pɨrã k'awa-eeta, mak'ɨara wɨpi-e pait'ee. Tachi Ak'õrepa eperãmaa k'ĩsia k'awaapik'ãri ne-inaa oo k'awaamerã, k'inia bɨ ma eperãpa mãga oomerã, ma ne-inaa chaaree bɨ mĩda. Ma awara eperãarã bɨk'ãri ma eperã jua ek'ari, k'inia bɨ irua ãra pia ak'ɨ bapariimerã, chaaree bɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Mɨ cheji na p'ek'au eujãdee t'ɨpɨtauk'a k'oode, aɨde ijãadak'aa beerã miapiit'ee. ¡Mãga oo aupada paara, mɨ o-ĩa bak'aji! ");
INSERT INTO sjaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mamĩda aɨ naaweda mɨmaa ne-inaa k'achia p'asait'ee. Chupɨria nɨ̃bait'ee mãga parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Parãpa k'ĩsia p'anɨk'ã mɨ cheji eperãarã k'ãiwee p'anapide? Mãga-e. K'ĩsia awara-awaraa papideta cheji. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Idideepa te pidaarã joisomaadepema õpeerãpa mɨde ijãadait'ee; jõdee omeerãpa ijãada-e pait'ee. Maa-e pɨrã omeerãpa ijãadait'ee; jõdee õpeerãpa ijãada-e pait'ee. Mɨ k'aurepa t'ãri auk'a p'anada-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ak'õre t'ãri auk'a ba-e pait'ee chi warra ome maa-e pɨrã chi warra t'ãri auk'a ba-e pait'ee chi ak'õre ome. Nawe t'ãri auk'a ba-e pait'ee chi k'au ome maa-e pɨrã chi k'au t'ãri auk'a ba-e pait'ee chi nawe ome. P'ãk'õre t'ãri auk'a ba-e pait'ee chi ãigu ome maa-e pɨrã chi ãigu t'ãri auk'a ba-e pait'ee chi p'ãk'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesupa ichiaba mãgaji eperãarã arii p'anadap'edaarãmaa: —Parãpa unudak'ãri jɨ̃arara uchiaruta ak'õrejĩru baaipari eere, jarapata k'oi cheit'ee. Mãga p'asapari parãpa jarapatak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ichiaba nãu p'uak'ãri sur eereepa, jarapata wãsia nɨ̃bait'ee. Mãga p'asapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡K'ĩsia atua p'anɨɨrã! Parãpa mãgá pajã mãik'aapa eujã ak'ɨ p'anɨpa eu k'achia wa eu pia k'awa p'anɨ pɨrã, ¿sãap'eda ne-inaa mɨa oomaa bɨ k'awada-e p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Mɨa oo bɨ mãik'aapa jaratee bɨ ak'ɨ́tɨ k'awaadait'ee Tachi Ak'õrepa oopi bɨ wa mãga-e. Mãpai parã t'ãri auk'a bɨ́tɨ iru ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eperã nepɨra iru bɨ pɨrã pɨ ome mãik'aapa pɨ charramaa atee k'inia bɨ pɨrã, wãi naaweda t'ãri pia pedeeipia bɨ iru ome t'ãri auk'a bɨdait'ee. Maa-e pɨrã charra k'ĩrapite panadak'ãri, mãgɨpa pɨ ata bɨi jɨ̃apataarã juade carcelde t'ɨ nɨ̃bɨnadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mɨa wãarata jararu. Mamãik'aapa uchia-e pai p'arat'a jõmaweda p'aa-emaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Maapai eperãarã ũk'uru wãjida Jesús ak'ɨde. Nepɨrɨjida Pilatopa Galilea eujãdepema ɨmɨk'ĩraarã peepida, ãrapa p'aareerãmaa ne-animalaarã peepidap'eda, paapidak'ãri. Mãgá ma eperãarã waa p'oira beeji ma ne-animalaarã waa ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mãga ũrip'eda, Jesupa mãgaji: —¿Parãpa k'ĩsia p'anɨk'ã aji, Tachi Ak'õrepa mãga p'asapiji ma Galilea eujãdepemaarãpa p'ek'au k'achiara oodap'edaa perã ma eujãdepemaarã awaraarã k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mãga-e. Mamĩda pãchia p'ek'au k'achia oopata oo amaada-e pɨrã, ichiaba piudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mãga-e pɨrã ¿k'ĩsia p'anɨk'ã dieciocho piudap'edaarã Siloé torre t'eek'ãri, mãgá piujida ne-inaa k'achiara oopachida perã awaraa Jerusalendepemaarã k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mãga-e. Mamĩda pãchia p'ek'au k'achia oopata oo amaada-e pɨrã, ichiaba piudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mãpai Jesupa nãga nepɨrɨji jarateeit'ee: —Eperãpa higuera bɨɨrɨ uu iru baji ichi uva k'ãide. Ewari aba ak'ɨnaji, higojõ chau bɨ jĩak'aapa. Mamĩda chau-ee baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mapa jaraji eperã chi ne-uu ak'ɨ baparimaa: “Año õpee iru bɨda aji, higojõ jɨrɨ che bɨ nama. Mamĩda unuk'aada aji. T'ɨap'et'aapáde aji. ¿K'ãare-it'ee ichi k'inia jãma bainɨ̃ bayama aji, eujã jɨ̃amaa?” ");
INSERT INTO sjaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mamĩda ma eujã ak'ɨparipa p'anauji: “Señor, ichiak'au bɨpáde aji, na año aupai. Yooro p'oirait'ee ujãra ome mãik'aapa arii p'e bɨnait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mãga ook'ãri, ¿chau-e paik'ã? aji. Mata chau-e pɨrã, t'ɨap'et'aait'eeda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ewari aba ɨ̃ipata ewate Jesupa jarateemaa baji Tachi Ak'õre Ũraa jarateepata tede. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mama baji wẽra dieciocho años k'ayaa bɨ. Netuarapa ma wẽra eburuk'uk'uapiji. Mapa jĩp'a p'oyaa bainɨ̃ beek'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesupa ma wẽra unu atak'ãri, t'ɨ̃ ataji mãik'aapa mãgaji: —Wẽra, pɨ jɨpa bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mãpai ichi jua bɨji ma wẽra ek'arra ɨ̃rɨ. Aramata jĩp'a bainɨ̃ beeji mãik'aapa Ak'õremaa ɨt'aa t'ɨ̃maa beeji o-ĩapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mamĩda ma Ak'õre Ũraa jarateepata tedepema poro waibɨa k'ĩraudachi, ɨ̃ipata ewate Jesupa jɨpat'aada perã. Mapa eperãarãmaa mãgaji: —Ewari seis paraada aji, mimiadait'ee. Chedapáde aji, mãgɨ́ ewate jɨpapide. Ɨ̃ipata ewate chenaadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mãpai Tachi Waibɨapa p'anauji: —¡Mamĩda parãpa paara oodak'aa pãchia jarateepatak'a! ¡Ɨ̃ipata ewate ichiaba mimiapata! ¿Ɨ̃ipata ewate pãchi p'ak'a maa-e pɨrã burro ẽrapata-ek'ã aji, ateedait'ee pania topide? ");
INSERT INTO sjaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na wẽra Abrahamdeepa uchiada Satanapa dieciocho años k'ayaa iru baji. ¿Ɨ̃ipata ewate p'oyaa jɨpaik'araa baji-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesupa mãga jarak'ãri, ichi k'ĩra unuamaa iru p'anadap'edaarã k'ĩra nejasia p'aneejida eperãarã k'ĩrapite. Mamĩda arii p'anadap'edaarã o-ĩa para baji Jesupa ne-inaa pia ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesupa ichiaba awaraa nepɨrɨji jarateeit'ee: —¿K'ãarek'a bɨma aji, Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã? ¿K'ãare ome auk'a bɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza tau p'isi k'edéek'ata bɨda aji, eperãpa uuda ichi te ãuk'idaa. Wari wãpachi pak'uruk'a nɨ̃beerumaa. Waibɨa nɨ̃beek'ãri, chi jua t'aide ipanaarã chepata ɨ̃idait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ichiaba Jesupa nãga nepɨrɨji jarateeit'ee: —¿K'ãarek'a bɨma aji, Tachi Ak'õrepa eperãarã ichi jua ek'ari bɨk'ãri, ichideerã p'aneedamerã? ");
INSERT INTO sjaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wẽrapa levadura p'oiraparik'a bɨ harina waibɨa ome, pan masa pia warimerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén ode wãdade Jesupa jarateeji p'uuru bee chaa mãik'aapa aɨ ik'aawa eperãarã p'anapatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Maapai eperãpa iidiji: —Tachi Waibɨa, ¿eperãarã chok'ara-ee Ak'õre eujãdee wãdait'eek'ã? aji. Jesupa p'anauji: ");
INSERT INTO sjaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tachi Ak'õre truadee wãit'ee puerta p'ĩrup'ee bɨde t'ĩupaták'ata bɨ. Mɨa jara bɨ: Eperãarã chok'ara wã k'inia p'anadait'ee Tachi Ak'õre truadee. Mamĩda p'oyaa wãda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te chipari p'irabaip'eda, ichi puerta jɨ̃a nɨ̃bɨparik'a, mãga pɨk'a ewari cherude mɨ, parã poro waibɨapa Ak'õre truadepema puertak'a bɨ jɨ̃ait'ee. Mãpai parã taawa p'anɨɨrãpa mãgadait'ee: “Tachi Waibɨa, ewapáde adait'ee tai t'ĩudait'ee.” Mamĩda mɨa p'anaut'ee: “Mɨa parã k'awa-e bɨ. Mapa parã t'ĩupi-e pait'ee. Parã mɨchideerã-eda ait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mãpai parãpa jara p'aneedait'ee: “Tai pɨ ome nek'opachida mãik'aapa ne-inaa topachida. Tai p'uuru jãde pɨa jaratee nipapachida” adait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mamĩda mɨa p'anaut'ee: “¿Mɨa jara-e pajik'ã parã mɨchideerã-e? ¡Ãyaa wã́tɨ mɨ ik'aawaapa, ne-inaa k'achia oopataarã!” ");
INSERT INTO sjaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Parãpa unudak'ãri Abraham, Isaac, Jacob, jõmaweda Ak'õre pedee jarapataarã ome Tachi Ak'õre truade, k'awaadait'ee parã taawa p'anɨ. Mãpai jẽedait'ee mãik'aapa pãchi k'ida kierrkierree para bait'ee p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eperãarã chedait'ee norte eereepa, sur eereepa, ak'õrejĩru uchiapari eereepa mãik'aapa ak'õrejĩru baaipari eereepa. Mãɨrãta su-ak'ɨ p'ana chedait'ee nek'ode Tachi Ak'õre ome ichi truade. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Maapai chi ɨ̃rapema ek'ariara beerã Tachi Ak'õrepa waibɨara papiit'ee. Jõdee ɨ̃rapema waibɨara beerã irua ek'ariara papiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mãpai fariseorã ũk'uru chejida mãik'aapa mãgajida Jesumaa: —Wã́ji namãik'aapa, Herodepa pɨ peet'aa k'inia bairã. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Irua p'anauji: —Wã́tɨ jarade jã ik'awaa bɨmaa: “Idi mãik'aapa nu uchiapik'ooit'ee netuara merãtɨa bee eperãarã k'ap'ɨadeepa mãik'aapa k'ayaa beerã jɨpak'ooit'ee. Maap'eda nunorema parumaa aupait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mamĩda idi, nu mãik'aapa nunorema ichita wãit'ee mɨchi ode, pia-e bairã Ak'õre pedee jarapari Jerusalén p'uurudeepa taawa piumerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén, Jerusalén, pɨdepemaarãpa Tachi Ak'õre pedee jarapataarã peepata mãik'aapa irua pëida eperãarã mãupa bat'a peepata! At'apai mɨa pɨdepemaarã araa p'e k'inia bapachi, et'erre wẽrapa chi chak'eerã p'e ataparik'a ichi isia ek'ari. Mamĩda parãpa k'iniada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Ũrítɨ! ¡Pãchi te ituaba beeit'ee, Tachi Ak'õrepa parã waa ak'ɨ-e pait'ee perã! Mɨa jara bɨ: Parãpa mɨ waa unuda-e pait'ee ewari cherude nãga jararutamaa: ‘¡Tachi Ak'õrepa ichia pëida ichita pia ak'ɨ bapariit'ee!’ ");
INSERT INTO sjaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ewari aba ɨ̃ipata ewate Jesús wãji nek'ode fariseorã poro waibɨa temaa. Mama bɨde awaraa fariseorãpa iru ak'ɨ p'anajida, ɨmɨatee k'inia p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mama ichiaba baji eperã aba k'ap'ɨa ooro bɨ k'ayaapa. Mãgɨ́ Jesús k'ĩrapite bainɨ̃ ba cheji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mãpai Jesupa iidiji Moisepa p'ãda jarateepataarãmaa mãik'aapa fariseorãmaa: —¿Ɨ̃ipata ewate k'ayaa bɨ jɨpaipia bɨk'ã aji, maa-e pɨrã jɨpaik'araa bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mamĩda ãchi k'ĩup'ee para beeji. Mãpai irua chi k'ayaa bɨ jita atap'eda, jɨpat'aaji mãik'aapa jaraji wãmerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mãpai fariseorãmaa mãgaji: —Pɨchi warra maa-e pɨrã p'ak'a toidú padarida paara, ¿isapai jitana-e pak'ajik'ã aji, ɨ̃ipata ewate mĩda? ");
INSERT INTO sjaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mamĩda maarepida p'anauda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesupa unuk'ãri ma fariseopa awaraarã t'ɨ̃ pëida su-ak'ɨ p'aneeruta su-ak'ɨ beepari piara bɨde, nãga nepɨrɨji jarateeit'ee: ");
INSERT INTO sjaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Eperãpa pɨ t'ɨ̃ pëik'ãri miak'ãipata fiesta oode, su-ak'ɨ beenáaji su-ak'ɨ beepari piara bɨde, eperã pɨ k'ãyaara waibɨara bɨ t'ẽe chei perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mãgara chi t'ɨ̃dapa pɨmaa mãgai: “Téeji pɨ su-ak'ɨ beepari na eperãmaa.” Mãpai pɨ k'ĩra nejasia bai mãik'aapa su-ak'ɨ banai su-ak'ɨ beepari t'ɨmɨpɨara bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma k'ãyaara pɨ t'ɨ̃ pëidak'ãri, su-ak'ɨ banáji su-ak'ɨ beepari t'ɨmɨara bɨde, pɨ t'ɨ̃dapa mãga chemerã: “K'õp'ãyo, su-ak'ɨ ba chéji su-ak'ɨ beepari piara bɨde.” Mãgara pɨ o-ĩa su-ak'ɨ banai apemaarã waawí mesade. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tachi Ak'õrepa chi waibɨara pa k'inia bɨ ek'ariara papiit'ee. Jõdee chi audua-ee bɨ waibɨara papiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ichiaba Jesupa mãgaji ma fariseorã poro waibɨamaa: —Eperãarã t'ɨ̃ pëik'ãri nek'o chedamerã pɨchi temaa, t'ɨ̃ pëináaji pɨchi k'õp'ãyoorã, ɨ̃pemaarã, ëreerã, wa pɨ te k'ait'a p'anɨ p'arat'ara beerã, ma pari ãrapa ichiaba pɨ t'ɨ̃dai perã nek'ode ãchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma k'ãyaara fiesta ook'ãri, t'ɨ̃ pëipia bɨ chupɨria chedeerã, p'oyaa t'ɨa-ee beerã, bɨɨrɨ nɨk'anɨk'aa beerã mãik'aapa tau p'ãriu beerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mãgá o-ĩa bait'ee, ma pari ãrapa ne-inaa oodait'ee wẽe p'anadairã. Ma awara ma pari Tachi Ak'õrepa pɨmaa ne-inaa pia ooit'ee, ichia pia ak'ɨ bɨɨrã jai-idaadap'eda p'irabairuta ewate. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mãga ũrik'ãri, ma mesade su-ak'ɨ p'anadap'edaadepema abaapa mãgaji Jesumaa: —¡O-ĩa bait'eepɨ chi nek'oru nek'opata waibɨade Ak'õre truade! ");
INSERT INTO sjaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mãpai Jesupa nãga nepɨrɨji jarateeit'ee: —Eperãpa chik'o waibɨa joopiji mãik'aapa eperãarã chok'ara t'ɨ̃ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chik'o aupa nɨ̃bak'ãri, pëiji chi chok'apari jarade ma t'ɨ̃ pëida eperãarãmaa: “Chétɨ, jõma aupa jẽra bairã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mamĩda jõmaarãpa: “P'oyaa wãda-eda” ajida. Chi naapemapa mãgaji: “Et'ewapai mɨa eujã neto ataji. Ichita wãit'ee ak'ɨde. Mɨ chupɨria k'awaapáde aji, p'oyaa wã-e perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Awaraapa mãgaji: “Et'ewapai p'ak'a diez neto atajida aji, mimiapinait'ee mɨchi eujãde. Mɨ chupɨria k'awaapáde aji, p'oyaa wã-e perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jõdee awaraapa mãgaji: “Ewaa miak'ãiji. Mapa p'oyaa wã-eda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chi chok'a pëida ãpɨtee cheji chiparimaa jarade. Mãpai ma te chipari k'ĩraudachi mãik'aapa mãgaji chi chok'aparimaa: “Wã́ji p'uuru jãdee mãik'aapa p'e anéeji chupɨria chedeerã, p'oyaa t'ɨak'aa beerã, tau p'ãriu beerã mãik'aapa bɨɨrɨ nɨk'anɨk'aa beerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bɨɨ-ap'eda, mãgaji chi chok'a pëidapa: “Señor, mɨa ooji pɨa jaradak'a. Mamĩda su-ak'ɨ beepari at'ãri pari jẽra bɨda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mãpai ma te chiparipa mãgaji chi chok'aparimaa: “Mãgara wã́ji o bee chaa eperãarã jɨrɨde, mɨ te p'ĩu nɨ̃ba chemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mɨa jara bɨ: Chi eperãarã naa t'ɨ̃ pëida apidaapa k'oda-e pait'ee mɨ chik'o.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eperãarã chok'ara nipajida Jesús t'ẽe. Mapa irua ãpɨtee ak'ɨji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mɨ ome niparupa mɨ k'iniara iru ba-e pɨrã chi ak'õre, chi nawe, chi wẽra, chi warrarã, chi ɨ̃pemaarã, chi ɨ̃pewẽraarã, ichi paara k'inia bai k'ãyaara, mãgɨ́ p'oyaa mëré pa-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ichiaba eperã piuamaa bɨ pɨrã mɨde ijãa bɨ k'aurepa, mãgɨ́ mëré pa-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Parãdepema abaapa te ɨt'ɨa oo k'inia bɨ pɨrã, naapɨara juasia-e paik'ã k'awaait'ee jõmasaa p'arat'a falta bɨ ma te oo aupait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mãga oo-e pɨrã, ma te basa oop'eda, p'oyaa oo aupa-e pak'ãri, chi unurutaarãpa pɨ oomaa iru p'aneedai. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jarapataadai: “Na eperãpa te oomaa beeji. Mamĩda p'oyaa oo aupa-e paji.” ");
INSERT INTO sjaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Maa-e pɨrã, rey wã k'inia bak'ãri jura chõode awaraa rey ome, naapɨara chi soldaorã juasiapari k'awaait'ee diez mil soldaorãpa p'oyaadai wa p'oyaada-e pai soldaorã veinte mil ãra ɨ̃rɨ chõo cherutaarã. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","P'oyaa-e paita bɨ pɨrã, ¿chi apema rey t'ɨmɨ́ cheru weda jara pëiit'ee-ek'ã k'ĩra jĩp'a p'aneedait'ee chõoda-ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mãga pɨk'a parãdepemapa k'ĩsiap'eda mɨde ijãait'ee, ma k'aurepa ichia ne-inaa jõmaweda iru bɨ atuaamaa beeru pɨrã, mãgara p'oyaa mëré pa-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—T'ã pia bɨ. Mamĩda k'ɨyaa-edaru pɨrã, ¿sãga waya k'ɨyaapiima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pia-e bɨ eujã-it'ee pɨjida. Ichiaba ne-uu k'arra ik'aawa p'eit'ee pida pia-e bɨ. Jĩp'a bat'at'aaipia bɨda aji. Pia k'ĩsíatɨ parãpa et'ewa ũridap'edaade k'awaadamerã k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma t'ẽepai Cesar-it'ee impuesto p'epataarã mãik'aapa awaraa k'achia oopataarãda apatap'edaa k'ait'a chejida Jesús pedee ũride. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mapa fariseorã Moisepa p'ãda jarateepataarã ome iru ãpɨte ik'achia pedeejida: —Jãgɨpa p'ek'au k'achia oopataarã auteebaipari mãik'aapa nek'opari ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mãpai Jesupa nãga nepɨrɨji jarateeit'ee: ");
INSERT INTO sjaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Parãdepema abaapa cien oveja iru bɨ pɨrã mãik'aapa madepema aba atuadaru pɨrã, ¿atabëi-e paik'ã aji, chi apemaarã noventa y nueve ãchi p'anapatamãi chi atuadaida jɨrɨnait'ee unu atarumaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Unu atak'ãri, o-ĩapa pɨ ik'ia ɨ̃rɨ jira atap'eda, ");
INSERT INTO sjaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aneeit'ee mãik'aapa pachek'ãri teeda, pɨchi k'õp'ãyoorã t'ɨ̃ p'e atait'ee. Mãpai mãgait'ee: “O-ĩa p'anadáma mɨ oveja atua bada unu atada perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mɨa jara bɨ: Ak'õre truade mãgá ichiaba audú o-ĩadaipata p'ek'au k'achia ooparipa ichia p'ek'au k'achia oopata oo amaak'ãri mãik'aapa Tachi Ak'õrede ijãa beek'ãri. O-ĩara p'anapata ma k'ap'ɨa, o-ĩa p'anadai k'ãyaara noventa y nueve t'ãri pia beerã k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Wẽrapa p'arat'a tau diez iru bɨpa madepema aba atuadaru pɨrã, ¿lámpara k'oo atap'eda, piak'ãa te jã barremaa bee-e paik'ã unu atarumaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Unu atak'ãri, chi k'õp'ãyoorã t'ɨ̃ p'e atait'ee mãik'aapa mãgait'ee: “O-ĩa p'anadáma mɨa unu atada perã p'arat'a tau atuadaida.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mɨa jara bɨ: Angeleerãpa ichiaba mãgá o-ĩadaipata p'ek'au k'achia ooparipa ichia p'ek'au k'achia oopata oo amaak'ãri mãik'aapa Tachi Ak'õrede ijãa beek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesupa ichiaba nãga nepɨrɨji jarateeit'ee: —Eperãpa warrarã omé iru baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ewari aba chi k'ũtrãara badapa mãgaji chi ak'õremaa: “Ak'õre, teepáde aji, mɨ eerepema net'aa pɨ piuk'ãri atabëiit'ee bɨdepema.” Mãga ooji chi ak'õrepa. Ma k'ũtrãa eerepema net'aa teeji irumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Maap'eda ma warra t'ẽepemapa ichi eerepema net'aa p'e atap'eda, netok'ooji mãik'aapa ma p'arat'apa t'ɨmɨ́ wãji awaraa todee. Mama p'arat'a pariatua gasta wãpachi mãik'aapa jõt'aaji ichia oo k'iniata oo bɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma awara p'arat'a jõma jõdaik'ãri, at'apai jarra oojida ma eujãde. Maperã jarra choomaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mapa wãji mimia jɨrɨde ma eujãdepema eperãmaa. Ma eperãpa pëiji sinaarã jɨ̃ade. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Audú jarrapa bi jãwaa k'inia bapachi sinaarã chik'opa. Mamĩda apidaapa nek'opidak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mãpai k'ĩsia beeji: “Mɨ ak'õre tede mimiapataarã chok'araarãpa nek'odait'ee iru p'anɨda aji. ¡Jõdee mɨ nama jarrapa piu wã! ");
INSERT INTO sjaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɨ ak'õremaa wãit'eeda aji. Panak'ãri, nãga jarait'eeda aji: Ak'õre, mɨa p'ek'au k'achiata ooji Tachi Ak'õre k'ĩrapite mãik'aapa pɨ ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Waa pɨchi warrak'a mɨ iru banáaji. Jĩp'a pɨchi mimiaparik'a iru báji anait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Maap'eda cheji chi ak'õre temaa. ’At'ãri t'ɨmɨ́ cheru weda, chi ak'õrepa unu ataji mãik'aapa chupɨria k'awaaji. P'iraji chi warramaa mãik'aapa wëre atap'eda, k'ĩra ɨ̃t'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mãpai chi warrapa mãgaji: “Ak'õre, mɨa p'ek'au k'achiata oojida aji, Tachi Ak'õre k'ĩrapite mãik'aapa pɨ ãpɨte. Waa pɨchi warrak'a iru banáaji. Jĩp'a pɨchi mimiaparík'ata iru báji.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mamĩda chi ak'õre audú o-ĩa bada perã, mãgaji chi mimiapataarãmaa: “P'aru pipɨara bɨta atanátɨ mãik'aapa jɨ̃ bɨ́tɨ. Ichiaba ichi juade sortija jɨ̃ bɨ́tɨ mãik'aapa ichi bɨɨrɨde chancla jɨ̃ bɨ́tɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anéetɨ p'ak'a poreera bɨta mãik'aapa peet'áatɨ. ¡K'odait'ee mãik'aapa pëiradait'ee! ");
INSERT INTO sjaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Mɨ warra piu pɨk'a bada waya chok'ai bɨ! ¡Chi atua pɨk'a bada unu atajidapɨ!” Mãpai fiesta oojida. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Mãɨmisa chi warra naapema ne-uu k'ãide baji. Teedaa chek'ãri, ũri cheji o-ĩa pëira para bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mapa mimiapari aba t'ɨ̃ ataji mãik'aapa iidiji: “¿Sãga jõnɨma?” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mãpai ma mimiaparipa mãgaji: “Pɨ ɨ̃pema pachejida aji. Pɨ ak'õrepa p'ak'a poreera bɨta peepiji, iru k'ap'ɨa k'ayaa wẽe pacheda perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mãga ũrik'ãri, chi ɨ̃pema ne-uu k'ãideepa cheda k'ĩraudachi mãik'aapa teedaa t'ĩuamaa beeji. Maperã chi ak'õre taawaa uchiaji enenee pedeede t'ĩumerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mamĩda chi warrapa mãgaji chi ak'õremaa: “Pɨa k'awa bɨda aji, mɨ taarã mimiadoo. Ichita k'ĩra jĩp'a oodoo pɨa jaradak'a. Mamĩda mɨmaa tee-e paji cabra chak'e pida, o-ĩa nek'omerã mɨchi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jõdee pɨ warra pacheda-it'eeta peepiji p'ak'a poreera bɨ, jõma pɨchi p'arat'a teeda jõt'aaji mĩda prostitutaarã ome.” ");
INSERT INTO sjaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Mãpai chi ak'õrepa p'anauji: “Warra, pɨ ichita mɨ ome bapari. Net'aa jõmaweda mɨa iru bɨ përé. ");
INSERT INTO sjaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mamĩda ɨ̃rá o-ĩa p'anadaipia bɨ pɨ ɨ̃pema piu pɨk'a bada chok'ai bairã; chi atua bada unu atadap'edaa perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesupa ichiaba nãga nepɨrɨji chi k'õp'ãyoorãmaa jarateeit'ee: —Eperã p'arat'ara bɨ bapachi. Ichia iru baji mimiapataarã poro waibɨa ichi jua ek'ari. Ewari aba mãgɨ́ ɨmɨateejida irua net'aa pariatua atuapi bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mapa chi mimia chiparipa t'ɨ̃ atap'eda, mãgaji: “¿Wãarak'ã aji, pɨ ãpɨte jara chedap'edaa? Ɨ̃raweda p'ã téeji jõmaweda mɨ net'aa iru bɨ, pɨ waa mɨ mimiapataarã poro waibɨa pa-e pait'ee perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mãga ũrik'ãri, ma mimiapataarã poro waibɨapa k'ĩsiaji: “Ɨ̃rá ¿sãgapɨ ooit'eema mɨ mimia chiparipa mɨ mimia wẽe bɨk'ãri? Juatau wẽe bɨ mimia chaaree ooit'ee mãik'aapa k'ĩra nejasia bɨ ne-iidipariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","K'awa bɨda aji, sãga ooit'ee eperãarãpa mɨ auteebaidamerã mimia wẽe beek'ãri.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mãpai t'ɨ̃piji aba-abaa chedamerã chi paraa p'anadap'edaarã chi mimia chiparimaa. Chi naa chedamaa iidiji: “Pɨa ¿jõmasaa paraa bɨma aji, mɨchi poro waibɨamaa?” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","P'anauji: “Aceite olivodee ooda ochocientos galones paraa bɨda” aji. Mãpai ma mimiapataarã poro waibɨapa mãgaji: “Acha bɨda aji, pɨa paraa bada p'ãda. Nãgɨ́ jẽt'áaji mãik'aapa awaraata oo atapáde aji, cuatrocientos pari.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Maap'eda iidiji awaraamaa: “¿Pɨa jõmasaa paraa bɨma?” aji. Ma eperãpa p'anauji: “Trigo bulto cien paraa bɨda” aji. Mãpai mimiapataarã poro waibɨapa mãgaji: “Acha bɨda aji, pɨa paraa bada p'ãda. Nãgɨ́ jẽt'aap'eda, awaraata oo atapáde aji, ochenta bulto pari.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chi mimia chiparipa k'awaji ma mimiapataarã poro waibɨa k'achia bada ik'awaa bɨ. Mapa ɨtrɨa-e paji. Ichiaba mãga pɨk'a p'anɨ na p'ek'au eujãdepema ijãadak'aa beerã. Ik'awaara p'anapata Tachi Ak'õredeerã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Maperã mɨa parãmaa ũraait'ee. Na p'ek'au eujãdepema net'aa iru p'anɨ téetɨ k'õp'ãyoorã atadait'ee mɨ-it'ee. Mãga ooruta pɨrã, ma net'aa jõdaik'ãri, Tachi Ak'õrepa parã auteebaiit'ee ichi truade. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Chi t'ãri jĩp'a bɨpa net'aa chok'ara-ee iru bɨ pɨjida, awaraarãmaa teeru pɨrã, auk'a teepariit'ee net'aa chok'ara iru bak'ãri. Jõdee chi k'ũrayaa bɨpa teeamaa bɨ pɨrã net'aa chok'ara-ee iru bɨdepema, auk'a teeamaa bapariit'ee net'aara iru bak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mapa parã t'ãri jĩp'a p'anada-e pɨrã na p'ek'au eujãdepema net'aa, p'arat'a ome, ¿k'aipa ɨt'aripema net'aa parã jua ek'ari bɨima? ");
INSERT INTO sjaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ichiaba na p'ek'au eujãde p'anɨde chĩara net'aa t'ãri jĩp'a ak'ɨda-e pɨrã, ¿k'aipa parãmaa ɨt'aripema net'aa pia teeima? ");
INSERT INTO sjaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Eperã chipariirã omé jua ek'ari mimia baik'araa bɨ. Mãga bɨ pɨrã, chipari aba k'ĩra unuamaa iru bai mãik'aapa chi apema k'inia iru bai, maa-e pɨrã abaapa jara bɨk'a ooi mãik'aapa chi apemapa jara bɨk'a ooamaa bai. Mãga pɨk'a apidaapa ooda-e pai Tachi Ak'õrepa jara bɨk'a; p'arat'a, net'aa pia p'e bɨ misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseorãpa ma ũraa ũridak'ãri, Jesús oo iru p'aneejida, p'arat'a k'inia p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mapa Jesupa mãgaji: —Parã t'ãri pia beerãk'a p'anapata eperãarã k'ĩrapite. Mamĩda Tachi Ak'õrepa k'awa bɨ k'ĩsia k'achia parã t'ãride iru p'anɨ. Ne-inaa parãpa audupɨara k'inia iru p'anɨ; ma ne-inaa Tachi Ak'õrepa unuamaa iru bapari. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Moisepa ũraa p'ãdak'ãriipa mãik'aapa Tachi Ak'õre pedee jarapataarãpa ũraa p'ãdak'ãriipa Juan Bautistapa ũraa jarada parumaa, eperãarãpa jɨrɨpachida Tachi Ak'õredeerã p'aneedait'ee ma ũraade jara bɨk'a oo p'anɨpa. Mamĩda ma ũraa jõru. Juan badak'ãriipa mɨa pedee pia jarateepari, eperãarãpa k'awaadamerã mɨ k'aurepa Tachi Ak'õrepa eperãarã bɨit'ee ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Pajã mãik'aapa na p'ek'au eujã jõdaridai, jõma Tachi Ak'õrepa ũraa p'ãpidade jara bɨk'a p'asai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Eperãpa ichi wẽra amaat'aaru pɨrã mãik'aapa miak'ãiru pɨrã awaraa ome, p'ek'au oomaa bɨ Tachi Ak'õre k'ĩrapite. Ichiaba eperã miak'ãiru pɨrã wẽra amaat'aada ome, p'ek'au oomaa bɨ Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Eperã p'arat'ara bɨ bapachi. Mãgɨ́ p'aru pi-ia jɨ̃pachi mãik'aapa ewari chaa fiesta waibɨa oopachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ichiaba mama bapachi eperã chupɨria chɨ t'ɨ̃jarapatap'edaa Lázaro. Mãgɨ́ k'ap'ɨa jõma aida-idaa baji. Eujãde su-ak'ɨ beepachi ma p'arat'ara bɨ te t'ĩupatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mãga oopachi ma p'arat'ara bɨ mesadeepa chik'o baaida k'o k'inia bada perã. Mama bɨde usaarãpa iru aida senepachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ewari aba ma chupɨria chɨ jai-idaaji mãik'aapa angeleerãpa iru jaure ɨt'aa ateejida Abraham ome bade. Ichiaba ma p'arat'ara bada piuji mãik'aapa ɨajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Ma p'arat'ara bada jaure chupɨria nɨ̃baji piudap'edaarãmãi. Mamãik'aapa ɨt'aa ak'ɨk'ãri, t'ɨmɨɨpa unuji Abraham Lázaro ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mãpai biaji: “Mɨchi chonaarã ak'õchona Abraham, ¡mɨ chupɨria k'awáaji! Lázaro jua k'ɨ̃ paniade beepíji mãik'aapa pë́iji mɨ k'ĩrame k'urãtɨpide, na t'ɨpɨtaude chupɨria nɨ̃bairã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mamĩda Abrahampa p'anauji: “Warra, k'irãpáji pɨ pia bapachi chok'ai bak'ãri; jõdee Lázaro chupɨria bapachi. Ɨ̃rá iru ɨ̃imaa bɨ nama; jõdee pɨ chupɨria nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma awara tachi p'anɨ esajĩak'a waibɨa k'õot'ari jira bɨ. Mapa chi nãik'aapa wã k'inia p'anɨɨrã p'oyaa wãda-e jãmaa. Ichiaba chi jãik'aapa che k'inia p'anɨɨrã p'oyaa cheda-e namaa.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Mãpai ma p'arat'ara badapa mãgaji: “Mãgara ak'õchona Abraham, mɨ chupɨria k'awáaji. Pë́iji Lázaro mɨchi ak'õre temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mama mɨchi ɨ̃pemaarã joisomaa p'anapata. Jara pë́iji chenaadamerã namaa, mɨ mia nɨ̃bɨmaa.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mamĩda Abrahampa p'anauji: “Ãrapa iru p'anɨda aji, Moisepa p'ãda mãik'aapa Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaa. Mãgɨ́ ũraa ũridaipia bɨ mãik'aapa Ak'õrede ijãadaipia bɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mamĩda ma p'arat'ara badapa p'anauji: “Wãarada aji, ak'õchona Abraham. Mamĩda piuda chok'ai p'irabaip'eda, wãru pɨrã ãramaa, mãgara wãara ãchia p'ek'au k'achia oopata oo amaadait'ee mãik'aapa Ak'õrede ijãadait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mamĩda Abrahampa mãgaji ma p'arat'ara badamaa: “Moisepa p'ãda mãik'aapa Ak'õre pedee jarapataarãpa p'ãdap'edaa ũri k'iniada-e p'anɨ pɨrã, ichiaba ijãada-e pait'ee eperã piuda p'irabaip'eda, wãru pɨjida ãramaa jarade.” ");
INSERT INTO sjaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesupa mãgaji chi k'õp'ãyoorãmaa: —Na p'ek'au eujãde ichita p'ek'au k'achia paraait'ee. ¡Mamĩda Tachi Ak'õrepa k'achiadee pëiit'eepɨ chi eperãpa p'ek'au k'achia oopi bɨ awaraarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Piara bak'aji k'ũruma iru otaude jɨ̃ atadap'eda, p'usa jãde bat'at'aadait'ee, ichia na warrarãmaa p'ek'au k'achia oopii k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡K'ĩrak'aupai parãpa mãga oodai! ’Awaraa ijãaparipa p'ek'au k'achia ooru pɨrã, ɨtrɨ́atɨ. Mamĩda irua p'ek'au k'achia oo amaa bɨ pɨrã, chupɨria k'awáatɨ mãik'aapa ma k'achia ooda perdonáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ewari abaade pɨmaa ne-inaa k'achia ooda siete ooru pɨjida, jarada siete irua jara cheru pɨrã mãga waa oo-e, ichita chupɨria k'awáaji mãik'aapa ma k'achia ooda perdonáaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mãpai chi k'õp'ãyoorãpa Jesumaa iidijida: —Taimaa waapɨara ijãapíji Tachi Ak'õrede. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesupa p'anauji: —Mostaza tau p'isi k'edee mĩda, waibɨadaipari pak'uruk'a. Mãga pɨk'a ɨ̃rá parãpa wãara ijãaruta pɨrã, ma-ãri pida, ne-inaa oodai Ak'õrepa k'inia bɨk'a. Waapɨara ijãadak'ãri, ne-inaa waibɨara oodai iru-it'ee. Mãga p'anadak'ãri, na nejõ bɨɨrɨmaa jaradai: “Jãmãik'aapa ãyaa wã́ji mãik'aapa p'usa jãde baaináji.” Mãgá wãara ijãarutara, ma nejõ bɨɨrɨpa ooi parãpa jararutak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Parãdepemapa chok'apari aba iru bɨ ne-uu k'ãide mimia bap'eda maa-e pɨrã oveja ak'ɨdeepa cheru pɨrã, ¿nãga jarak'ajik'ã? “Su-ak'ɨ béeji mãik'aapa nek'óji.” ");
INSERT INTO sjaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mãga-e. Ma k'ãyaara nãga jarai: “Mɨ-it'ee nejóoji mãik'aapa mɨa iidiruta anéeji, mɨ nek'omaa, ne-inaa tomaa bɨ misa. T'ẽepai pɨ nek'oi mãik'aapa ne-inaa toi.” ");
INSERT INTO sjaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma awara pɨa gracias jara-e pait'ee ma chok'aparipa ooda pari pɨa jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mãga pɨk'a parãpa oodap'eda jõmaweda Ak'õrepa jaradak'a, irumaa nãga jaradaipia bɨ: “Pɨata tai chok'apari. Jĩp'a oojida pɨa jaradak'a.” ");
INSERT INTO sjaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús ode wãde Jerusalendee, wãyaaji Samaria eujãde mãik'aapa Galilea eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Panaji p'uuru chak'ede. Mama irumaa chejida diez ɨmɨk'ĩraarã leprapa k'ayaa p'anɨ. Mamĩda t'ɨmɨ́ p'aneejida mãgá k'ayaa p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mãga nɨde biajida: —Jesús, Tachi Jarateepari, ¡tai chupɨria k'awáaji! ");
INSERT INTO sjaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesupa ãchi unuk'ãri, mãgaji: —P'aareerãmaa wã́tɨ jarade Tachi Ak'õre juapa pãchi k'ap'ɨa jɨpak'ooda. Mãgá wãrutade, jɨpa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma diezdepema abaapa unuk'ãri ichi k'ap'ɨa jɨpada, ãpɨtee o-ĩa cheji. Tachi Ak'õremaa golpe pedee pia jara cheji. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mãpai Jesús k'ĩrapite bedabaidachi ichi tau bɨɨrɨ eujãde t'õbairumaa. Mãga ooji gracias jarait'ee ichi jɨpada perã. Ma eperã judio-e paji. Samaria eujãdepema paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mãpai Jesupa mãgaji: —¿Diez paji-ek'ã aji, jɨpa p'aneedap'edaarã ãchi k'ayaadeepa? ¿Sãma p'anɨma apemaarã nueve? ");
INSERT INTO sjaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Na k'ĩra tewaraa aupaita chejik'ã aji, gracias jarade Tachi Ak'õremaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mãpai Jesupa mãgaji ma eperãmaa: —P'irabáiji mãik'aapa wã́ji. Pɨa wãara ijãada perã, jɨpa beejida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseorãpa Jesumaa iidijida: —¿Sãapaita Tachi Ak'õrepa ichia pëida rey papiit'ee na eujãde? Jesupa p'anauji: —Tachi Ak'õrepa pëida rey papi-e pait'ee eperãarã taide. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eperãarãpa jarada-e pait'ee: “Iru nama bɨ” maa-e pɨrã “iru jãma bɨ”. Mãga p'oyaa jarada-e iru parã ome bapari perã, unuda-e p'anɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mãpai Jesupa chi k'õp'ãyoorãmaa mãgaji: —Ewari cherude parãpa mɨ, chi Eperã Ak'õre Truadepema, audú unu k'inia jõnadait'ee. Mamĩda unuda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eperãarã ũk'uruurãpa jaradait'ee: “Iru nama bɨ” maa-e pɨrã “iru jãma bɨ”. Mamĩda wãnáatɨ ãchia jara p'anɨmaa mãik'aapa ijãanáatɨ ãchi pedee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Atu p'anɨde pa tau p'orep'orek'ãri pajã jõmaweda ɨ̃daa ataparik'a, mãga pɨk'a atu p'anɨde mɨ, chi Eperã Ak'õre Truadepema, waya cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mamĩda mãga pai naaweda ɨ̃rapemaarãpa mɨ chupɨria papidait'ee mãik'aapa yiaraa iru p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé bada ewaride p'asadak'a, mãga pɨk'a p'asait'ee mɨ, chi Eperã Ak'õre Truadepema waya chek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Maapai eperãarã nek'opachida, ne-inaa topachida mãik'aapa miak'ãipachida Noé ichi barcode bataurumaa. Mãpai k'oi che nɨ̃beeji, na p'ek'au eujã ũudachi mãik'aapa eperãarã jõmaweda k'iniidachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mãga paji ichiaba Lot bapariik'ãri. Eperãarã nek'o para bapachi, to para bapachi, ne-inaa neto para bapachi, ne-uu para bapachi mãik'aapa te oo para bapachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mamĩda Lot Sodoma p'uurudeepa uchiak'ãri, ma ewate ɨt'ariipa k'oi tau baaiparik'a, azufre mãuk'a baaiji t'ɨpɨtau ome ma p'uuru ɨ̃rɨ. Mapa ma p'uurudepemaarã jõmaweda k'iniidachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mãga pɨk'a pait'ee Eperã Ak'õre Truadepema waya chek'ãri. Eperãarãpa Tachi Ak'õrede k'ĩsiada-e p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ma ewate eperã terrazade bɨ pɨrã, mamãik'aapa ɨrabaik'ãri, teedaa t'ĩuk'araa bɨ ichi net'aa p'e atade. Ma awara eperã ichi ne-uu k'ãide ni pɨrã, teedaa cheik'araa bɨ ichi net'aa atade. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","K'irãpátɨ Lot wẽra p'asada. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Eperã piuamaa bɨ pɨrã mɨde ijãapari k'aurepa, mãgɨ́ piuk'ãri atuait'ee. Mamĩda eperã piuru pɨrã mɨde ijãapari k'aurepa, mãgɨ́ eperã piuk'ãri, ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Mɨa jara bɨ: Ma ewate p'ãrik'ua mɨ waya cheit'ee. Omé araa p'aru abaade k'ãi p'anɨde angeleerãpa aba ɨt'aa ateedait'ee; chi apema atabëidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ichiaba wẽraarã omé trigo bamaa p'anadait'ee k'ũrumade. Aba ɨt'aa ateedait'ee; chi apema atabëidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ichiaba ɨmɨk'ĩraarã omé ne-uu k'ãide mimiamaa p'anadait'ee. Aba ɨt'aa ateedait'ee; chi apema atabëidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mãpai Jesús k'õp'ãyoorãpa iidijida: —Tachi Waibɨa, ¿sãma mãga p'asait'eema? ajida. P'anauji: —Piuda k'ap'ɨa bɨmãi, ãkoso seedaipatada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesupa chi k'õp'ãyoorãmaa nãga nepɨrɨji jarateeit'ee ichita sẽda-ee ɨt'aa t'ɨ̃pataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mãgaji: —P'uuru abaade charra bapachi. Mãgɨpa Tachi Ak'õre, eperãarã paara waaweek'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma p'uurude ichiaba bapachi p'ẽtrãa. Mãgɨ́ nepɨra iru baji awaraa eperã ome. Mapa wãpachi ma charramaa irua ma nepɨra ak'ɨmerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ewari chaa ma charrapa iru pedee ũripachi mĩda, k'aripa k'iniak'aa paji. Mamĩda t'ẽepai k'ĩsiaji: “Mɨa Tachi Ak'õre waaweek'aa, eperãarã jida. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mamĩda na p'ẽtrãapa mɨ itu bɨ-e bairã, mɨ t'ãri k'achiadai naaweda, k'aripait'ee waa chenaamerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mãpai Jesupa ichiaba mãgaji: —Ma charra k'achia bɨpa mãga ooji pɨrã ma p'ẽtrãa ome, ");
INSERT INTO sjaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","audupɨara Tachi Ak'õrepa ichia jɨrɨt'eradaarã k'aripait'eeda aji, ãrapa ɨt'aa iidipata perã ãstaawa, p'ãrik'ua pida. ¿Ãramaa taarã nɨpiik'ã? ");
INSERT INTO sjaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mɨa jara bɨ: Taarã-e weda ãra k'aripait'ee. Mamĩda mɨ, chi Eperã Ak'õre Truadepema waya chek'ãri, ¿unu cheik'ã aji, na p'ek'au eujãde p'anɨ ijãapataarã at'ãri mɨde wãara ijãapata? ");
INSERT INTO sjaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesupa awaraa nepɨrɨji jarateeit'ee chi awaraarã ek'ariara ak'ɨ p'anɨɨrãmaa, ãchi t'ãri piara p'anɨ jĩak'aapa: ");
INSERT INTO sjaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ɨmɨk'ĩraarã omé wãjida Tachi Ak'õre te waibɨadee ɨt'aa t'ɨ̃de. Aba fariseo paji. Jõdee chi apemapa Cesar-it'ee impuesto p'epachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ma fariseo ak'ɨnɨ̃ beep'eda, nãga ɨt'aa t'ɨ̃pachi: “Aai, Ak'õre, pɨmaa gracias jarapari, mɨ apemaarãk'a bak'aa perã. Mɨ nechɨayaa bak'aa; k'achia ooyaa bak'aa; chĩara wẽra ome k'ãik'aa mãik'aapa ook'aa jã impuesto Cesar-it'ee p'eparipa ooparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tomia chaa k'ãima omé nek'ok'aa ɨt'aa t'ɨ̃it'ee mãik'aapa mɨa jitaru ne-inaa diezdepema chaa aba pɨmaa teepari.” ");
INSERT INTO sjaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mamĩda ma Cesar-it'ee impuesto p'epari t'ɨmɨ́ bainɨ̃ baji, audú p'ek'au k'achia ooyaa bɨ jĩak'aapa. Mapa ɨt'aa pida ak'ɨk'aa paji. Jĩp'a t'ũa t'aap'e nɨ̃bapachi mãik'aapa ɨt'aa t'ɨ̃pachi: “Aai, Ak'õre, mɨ chupɨria k'awáaji p'ek'au k'achia ooyaa bairã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mɨa jara bɨ: Ma impuesto p'epari k'ãiwee wãji ichi temaa, Tachi Ak'õrepa irua p'ek'au k'achia oopata wẽpapida perã. Jõdee mãga-e paji ma fariseo ome. Tachi Ak'õrepa irua p'ek'au k'achia oopata wẽpapi-e paji. Chi awaraarã k'ãyaara waibɨara pa k'inia bɨ ek'ariara bait'ee Tachi Ak'õre k'ĩrapite. Jõdee chi audua-ee bɨ awaraarã k'ãyaara waibɨara pait'ee Tachi Ak'õre k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ichiaba eperãarãpa warra chak'eerã aneejida Jesumaa iru jua bɨmerã ãra ɨ̃rɨ mãik'aapa bendiciamerã. Mamĩda chi k'õp'ãyoorãpa mãga unudak'ãri, ma warrarã aneedap'edaarã ɨtrɨajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mãpai Jesupa chi k'õp'ãyoorã t'ɨ̃ p'eji mãik'aapa mãgaji: —Ichiak'au mɨmaa warrarã chepítɨ, Tachi Ak'õrepa ãra jĩak'aarã bɨit'ee perã ichi jua ek'ari, ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mɨa wãarata jararu. Warra chaipa t'ãripa wãara ijãapari. Eperãpa mãgá Tachi Ak'õrede ijãa-e pɨrã, p'oyaa ba-e pai iru jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Eperãarã poro waibɨapa iidiji Jesumaa: —Tachi Jarateepari t'ãri pia, ¿k'ãata mɨa ooipia bɨma aji, ɨt'aa wãit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesupa p'anauji: —¿Sãap'eda mɨmaa t'ãri pia bɨda a bɨma? aji. T'ãri pia apaita bɨ: mãgɨ́ Tachi Ak'õre. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pɨa k'awa bɨ Tachi Ak'õrepa Moisemaa ũraa p'ãpida: ‘Eperã peenáaji; miak'ãi bɨ pɨrã, awaraarã ome k'ãináaji; nechɨanáaji; seewa jaranáaji chĩara k'achiade baaipiit'ee; pɨchi ak'õre mãik'aapa pɨchi nawe k'inia iru baparíiji mãik'aapa ãra pedee ũriparíiji.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mãpai ma eperãpa mãgaji: —Mɨa ma jõma ooparida aji, k'ũtrãa weda. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mãga ũrik'ãri, Jesupa p'anauji: —Ne-inaa aba waide oo-e bɨ. Pɨchi net'aa jõmaweda netok'oonáji mãik'aapa chupɨria beerãmaa ma p'arat'a téeji. Mãga ooru pɨrã, ne-inaa pipɨara iru bait'ee Tachi Ak'õre eujãde. Mãga oop'eda, mɨ ome nipa chéji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mamĩda mãga ũrik'ãri, ma eperã k'ĩra pia-ee wãji, p'arat'a audú k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mãga unuk'ãri, Jesupa mãgaji: —¡Chaaree bɨ p'arat'ara beerã p'aneedait'ee Tachi Ak'õre jua ek'ari ichideerã ome! ");
INSERT INTO sjaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Chaareera bɨda aji, p'arat'ara bɨ beeit'ee Tachi Ak'õre jua ek'ari, camello aguja taude wãyaai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mãpai chi ũri p'anadap'edaarãpa iidijida: —Mãgara, ¿k'aita p'oyaa ɨt'aa wãyama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesupa p'anauji: —Eperãarã p'oyaa ɨt'aa wãda-eda aji, ãchi k'ĩradoopa, audú chaaree bairã. Mamĩda Tachi Ak'õre-it'ee ne-inaa chaaree wẽ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mãpai Pedropa mãgaji: —Tachi Waibɨa, tai net'aa jõmaweda atabëijida pɨ ome nipapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesupa p'anauji: —Mɨa wãarata jararu. Eperã mɨde ijãa bɨ k'aurepa atabëiru pɨrã ichi te, wẽra, ɨ̃pemaarã, ak'õreerã maa-e pɨrã warrarã, ");
INSERT INTO sjaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mãgɨ́ eperãpa waapɨara atait'ee na p'ek'au eujãde bɨ misa, mãik'aapa piuk'ãri, ichita chok'ai bapariit'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","T'ẽepai Jesupa chi k'õp'ãyoorã doce awara ãi t'ɨ̃ p'e ataji mãik'aapa mãgaji: —Ɨ̃rá tachi Jerusalendee wãdait'ee. Mama jõmaweda chonaarãwedapema Ak'õre pedee jarapataarãpa p'ãdap'edaak'a p'asait'ee mɨ, chi Eperã Ak'õre Truadepema ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","K'achia beerãpa mɨ k'ĩra tewaraarãmaa teedait'ee. Mãgɨɨrãpa mɨ oo iru p'anadait'ee, ik'achia jaradait'ee mɨmaa mãik'aapa k'ĩramaa idudait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Maap'eda mɨ wɨdait'ee mãik'aapa peet'aadait'ee. Mamĩda ewari õpeemaa mɨ waya chok'ai p'irabaiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesús k'õp'ãyoorãpa maarepida k'awada-e paji irua jarada. Ichiaba k'awada-e paji k'ãaredeta pedee baji. Irua jara k'inia bada p'oyaa k'awadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó p'uuru k'ait'a pak'ãri, unuji tau p'ãriu bɨ o bi ik'aawa su-ak'ɨ bɨ. Mãgɨ́ chupɨria chɨpa chi wãyaarutaarãmaa p'arat'a iidimaa baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ũrik'ãri eperãarã chok'ara wãyaa wãruta ichi ik'aawa, iidiji: —¿K'aita nama wãyaa wãdama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","P'anaujida: —Jesús Nazaret p'uurudepemata wãyaa wãda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mãga ũrik'ãri, ma tau p'ãriu bɨpa biaji: —¡Jesús, Rey David Warra, mɨ chupɨria k'awáaji! ");
INSERT INTO sjaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chi naa wãdap'edaarãpa ɨtrɨat'aapachida k'ĩup'ee beemerã. Mamĩda waapɨara biapachi: —Rey David Warra, mɨ chupɨria k'awáaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mãpai Jesús ak'ɨnɨ̃ beeji mãik'aapa jaraji aneedamerã. K'ait'a pachek'ãri, Jesupa iidiji: ");
INSERT INTO sjaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿K'ãata k'inia bɨma aji, mɨa pɨ ome oomerã? Tau p'ãriu bɨpa p'anauji: —Tachi Waibɨa, mɨchi taupa pia unu k'inia bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mãpai Jesupa mãgaji: —¡Unúji! Pɨa ijãada perã, jɨpa beejida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aramãgá ma tau p'ãriu badapa pia unu beeji mãik'aapa Jesús t'ẽe wãji. O-ĩapa pia pedeeji Tachi Ak'õremaa. Ichiaba Jesupa ooda unudap'edaarãpa o-ĩapa pia pedee p'aneejida Tachi Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericó p'uurude panak'ãri, nipaji calle jãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mama bapachi eperã p'arat'ara bɨ, t'ɨ̃jarapatap'edaa Zaqueo. Mãgɨ́ Cesar-it'ee impuesto p'epataarã poro waibɨa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma eperãpa Jesús k'awa k'inia baji. Mamĩda p'oyaa unuk'aa paji, eperãarã audú chok'ara nipadap'edaa perã iru ome. Ma awara ichi audú jep'eda baji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mapa Jesús naa p'iraji mãik'aapa ɨt'ɨ́ padachi pak'uru o bi ik'aawa badade Jesús wãyaait'eemãi. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mãpai Jesús Zaqueo badamãi wãyaa wãk'ãri, ɨt'aa ak'ɨji mãik'aapa mãgaji: —Zaqueo, isapai ɨrabáiji jãmãik'aapa, idi mɨ pɨ tede beeit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aramãgá Zaqueo ɨrabaidachi mãik'aapa t'ãri o-ĩa Jesús ateeji ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mãga unudak'ãri, arii p'anadap'edaarã jõmaarãpa ik'achia pedee p'aneejida Jesús ãpɨte, iru wãda perã p'ek'au k'achia ooyaa bɨda apata tede. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","T'ẽepai teeda p'anadak'ãri, Zaqueo bainɨ̃ beeji mãik'aapa mãgaji: —Tachi Waibɨa, mɨa net'aa p'e iru bɨdepema esa-auk'a chupɨria beerãmaa teeit'eeda aji. Ichiaba chĩara p'arat'a chɨadoo pɨrã, ma chɨada aba chaachaa pari k'ĩmari teeit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mãpai Jesupa mãgaji: —Idi Tachi Ak'õrepa na te chipari k'aripa ataji iru o k'achiade wãdadeepa, auk'a Tachi Ak'õrede ijãapari perã, ichi chonaarãwedapema ak'õchona Abrahampa ijãadak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma-it'eepɨ mɨ, chi Eperã Ak'õre Truadepema cheji; atua beerã jɨrɨit'ee mãik'aapa o k'achiadeepa k'aripa atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eperãarãpa ũrimaa p'anajida Jesupa mãga jarak'ãri. Jerusalén k'ait'a bada perã, ãchia k'ĩsiajida taarã-ee Tachi Ak'õrepa iru rey papiit'ee. Mapa Jesupa nãga nepɨrɨji jarateeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—P'arat'ara beerãdepema aba bapachi. Mãgɨ́ t'ɨmɨ́ wãji awaraa eujãdee, Cesarpa ichi rey bɨmerã mãik'aapa t'ẽepai ichi ãpɨtee chemerã ichi eujã ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mamĩda wãi naaweda, t'ɨ̃ p'eji ichi mimiapataarã diez mãik'aapa p'arat'a waibɨa teeji ãchi chaachaa. Mãpai mãgaji: “Na p'arat'apa net'aa neto p'e atátɨ mãik'aapa netótɨ awaraarãmaa waapɨara eepadamerã, mɨ cheru misa.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mamĩda ichi eujãdepemaarãpa iru k'ĩra unuamaa iru p'anapachida. Mapa iru t'ẽe eperãarã pëijida jaradamerã: “K'iniada-e jã eperã tai rey pamerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Mãga jara pëijida mĩda, Cesarpa iru rey bɨji. Ma t'ẽepai waya cheji ichi eujãdee. Pachek'ãri, t'ɨ̃ pëiji ichi mimiapataarã, mãgɨ́ p'arat'a teedaarãmaa, k'awaa k'inia bada perã jõmasaa eepa iru p'anɨ ãchi chaachaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chi naa chedapa mãgaji: “Señor, pɨa p'arat'a teeda mɨmaa, ma p'arat'a tau chaa waa diez eepa wãjida” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Reypa mãgaji: “¡Pɨ pia bɨda aji, pia mimiapari perã! Mɨa atabëida pia ak'ɨji mãik'aapa aɨ ɨ̃rɨ waapɨara uchiapiji. Mãga ooda perã ɨ̃rá mɨa pɨ eperãarã poro waibɨa papiit'ee p'uuru diez ak'ɨpariimerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Araarepema mimiaparipa ichiaba jara cheji: “Señor, pɨa p'arat'a teeda mɨmaa, ma p'arat'a tau chaa waa joisomaa eepa wãjida” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ichiaba mãgɨmaa reypa mãgaji: “Mãgara pɨa p'uuru joisomaa ak'ɨpariit'eeda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Mamĩda awaraa mimiapari chedapa mãgaji: “Señor, acha bɨda aji, pɨa p'arat'a mɨmaa teeda. P'arude pia jɨ̃ bɨp'eda, ɨa iru bajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mɨa pɨ waawee bapari, k'awa bairã pɨa eperãarã pia chupɨria k'awak'aa. K'awa bɨ pɨchia ne-inaa jõma p'e atapari awaraarã mimiadap'edaa pari.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mãpai ma reypa mãgaji: “¡Mimiapari k'achia! Pɨa jaradak'a ooit'eeda aji, pɨ ome. K'awa bɨda a bɨ, mɨa pia chupɨria k'awak'aa mãik'aapa mɨa ne-inaa jõma p'e atapari awaraarã mimiadap'edaa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mãgara ¿sãap'eda pɨa mɨ p'arat'a ɨana-e pajima aji, p'arat'a ɨapata tede, mɨ chek'ãri, mãpemaarãpa mɨmaa waya teedamerã aɨ ɨ̃rɨ eepadap'edaa ome?” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mãpai ma reypa mãgaji arii p'anadap'edaarãmaa: “Jãri atátɨ mɨa p'arat'a teeda irumaa mãik'aapa téetɨ ma p'arat'a tau chaa waa diez eepadamaa.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mãpai ãchia mãgajida: “Mamĩda tachi poro waibɨa, ¡irua ma tau chaa waa diez eepada iru bɨda!” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mãpai ma reypa mãgaji: “Mɨa jara bɨ: Chi iru bɨmaa waapɨara teeit'ee. Mamĩda chi mak'ɨara wẽe bɨpa ma-ãri iru bɨ paara jãri atait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma awara jɨrɨnátɨ mɨ k'iniada-ee p'anadap'edaarã ãchi rey pamerã. Anéetɨ mɨ k'ĩrapite mãik'aapa peek'óotɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ma pedee jara aupap'eda, Jesús wãji Jerusalén ode. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivo Eede, Betfagé mãik'aapa Betania p'uuru k'ait'a panadak'ãri, chi k'õp'ãyoorã omé naa pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ãramaa mãgaji: —Wã́tɨ ara bɨ p'uuru tachi k'ĩrapite bɨmaa. Panadak'ãri, ununadait'ee burro jɨ̃ bainɨ̃ bɨ, waide apida batauda-e p'anɨ iru ɨ̃rɨ. Ẽra atátɨ mãik'aapa anéetɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Apidaapa iidiruta pɨrã k'ãare-it'ee ẽramaa p'anɨ, jarátɨ: “Tachi Waibɨapa arak'atɨa atee k'inia bɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mãpai Jesús k'õp'ãyoorã wãjida mãik'aapa ununajida jõma irua jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma burro ẽramaa p'anɨ misa, chipariirãpa iidijida: —¿K'ãare-it'ee ẽramaa p'anɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","P'anaujida: —Tachi Waibɨapa arak'atɨa atee k'inia bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mãpai ma burro Jesumaa ateedap'eda, ãchi ɨ̃rɨpema p'aru jɨ̃patap'edaa ata bɨjida aɨ ɨ̃rɨ mãik'aapa bataupijida. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wãruta misa, eperãarãpa ãchi ɨ̃rɨpema p'aru t'õ jẽra bɨjida o jãde, ãchi rey pai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mãpai Olivo Eedeepa ɨrabaipata o k'ait'a pa wãdak'ãri, jõmaweda iru ome nipapataarã o-ĩapa biuk'a para beeji, taarã-ee ãchi rey pai jĩak'aapa. O-ĩapa Tachi Ak'õremaa pedee pia pedeepachida, ãchia unudap'edaa perã Jesupa oo bɨ; ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mãgapachida: —‘¡K'ĩra wãree Ak'õre eujãde, Tachi K'aripapari reyk'a cheru perã! ¡Ɨ̃rá Tachi Ak'õre k'ãiwee bapariit'ee ichi eperãarã ome! ¡Iru jõmaarã k'ãyaara waibɨara bɨ!’ ");
INSERT INTO sjaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mãpai ũk'uru fariseorã ma eperãarã t'ãide p'anadap'edaarãpa Jesumaa mãgajida: —Tachi Jarateepari, pɨ ome nipapataarã ɨtrɨapáde ajida, mãga jaranaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mamĩda Jesupa p'anauji: —Na eperãarã k'ĩup'ee p'aneeruta pɨrã, mãu paara mãga biadait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén p'uuru k'ait'a parutade Jesupa araa ak'ɨk'ãri, jẽedachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mãpai mãgaji: —¡Pɨdepemaarãpa mɨde ijãadap'edaa paara, idi weda mɨa parã k'ãiwee p'aneepik'aji! Mamĩda mãga k'awada-e p'anadairã, parã-it'ee mera pɨk'a bɨ. Mapa p'oyaa unuda-e Tachi Ak'õrepa oo bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jerusalén, ewari cherude pɨmaa ne-inaa k'achia p'asait'ee. Pɨ k'ĩra unuamaa iru p'anapataarãpa muralla yoorodee oodait'ee pɨ ik'aawa. Pɨ wap'ɨra atadait'ee mãik'aapa ma muralladeepa pɨ k'idaa chaa wawadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pɨ muralla jõma t'eet'aadait'ee, edajãdepema te jẽra bɨ paara. Aɨde p'anɨɨrã chok'ara peedait'ee. Mãu apida bee-e pait'ee awaraa mãu ɨ̃rɨ, pɨdepemaarãpa ũridaamaa p'anadap'edaa perã mɨa parã k'aripa chek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalén p'uurude panadak'ãri, Jesús Tachi Ak'õre te waibɨade t'ĩuji mãik'aapa jëremaa beeji aɨde ne-inaa netomaa p'anadap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mãgaji: —Tachi Ak'õre Ũraa p'ã jẽra bɨde jara bɨ: ‘Mɨ te ɨt'aa t'ɨ̃pata teda apatadait'ee.’ ‘Mamĩda parãpa nechɨapataarã ték'ata oo iru p'anɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ewari chaa Jesupa jarateepachi Tachi Ak'õre te waibɨade. Maapai p'aareerã poroorã, Moisepa p'ãda jarateepataarã mãik'aapa Jerusalén p'uuru pidaarã poro waibɨarãpa jɨrɨpachida Jesús peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mamĩda p'oyaadak'aa paji, eperãarãpa iru pedee audú ũri k'inia p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ewari aba Tachi Ak'õre te waibɨade Jesupa jarateemaa baji pedee pia Ak'õrepa jara pëida. Mãga nɨde pachejida p'aareerã poroorã, Moisepa p'ãda jarateepataarã mãik'aapa judiorã poro waibɨarã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mãɨrãpa Jesumaa iidijida: —¿Tachi Ak'õrepa tai bɨji-ek'ã ichi te waibɨa ak'ɨdamerã? ¿K'aipa pɨmaa nãga oopi bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesupa p'anauji: —Mɨa pida parãmaa iidiit'eeda aji. P'anáutɨ p'oyaa p'anaudai pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿K'aipa pëijima aji, Juan Bautistapa poro choo chemerã; Tachi Ak'õrepa maa-e pɨrã eperãarãpa? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mãpai ãchi pitapai pedee para beeji: —Tachi Ak'õrepa pëidada aruta pɨrã, irua iidiit'ee: “Mãgara, ¿sãap'eda Juan ũraa ijãada-e pajima?” ait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ichiaba jaradaik'araa bɨ: “eperãarãpa Juan pëijida”. Mãga jararuta pɨrã, na eperãarã k'ĩraudaridait'ee tachi ome mãik'aapa tachi mãupa bat'a peedai. Jõmaarãpa ijãa p'anɨ Juan Tachi Ak'õre pedee jarapari paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mapa ãchia p'anaujida: —K'awada-e p'anɨda ajida, k'aipa Juan pëiji poro choo chemerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mãpai Jesupa mãgaji: —Mãgara mɨa pida jara-eda aji, k'aipa mɨmaa nãga oopi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Maap'eda Jesupa nãga nepɨrɨmaa beeji jarateeit'ee eperãarãmaa: —Eperãpa uva eujã uuji. Maap'eda ne-uu eujã ak'ɨpataarã jɨrɨji aɨde mimiadamerã. Mãpai awara ãyaa t'ɨmɨ́ wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","T'ẽepai uva oropata ewari pak'ãri, ma eujã chiparipa ichi mimiapari pëiji ma ne-uu ak'ɨpataarãmaa, ichi eere bee bɨ chauda tee pëidamerã. Mamĩda ãchia ma mimiapari sĩk'oojida mãik'aapa pëit'aajida waya chiparimaa, maarepida net'aa wẽe. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mãpai ma ne-uu chiparipa awaraa mimiapari pëiji. Mamĩda mãgɨmaa ichiaba ik'achia jaradap'eda, p'ua oot'aajida mãik'aapa jua arajãgaa pëit'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma t'ẽepai awaraa mimiapari pëiji. Mamĩda ma ne-uu ak'ɨpataarãpa iru auk'a p'ua oojida mãik'aapa taawaa pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Mãpai ma ne-uu chiparipa mãgaji: “Ɨ̃rá, ¿k'ãata ooyama? aji. Pëiit'eeda aji, mɨ warra k'inia iru bɨ. Taawa iru waaweedayada” aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mamĩda ma ne-uu ak'ɨpataarãpa iru warra t'ɨmɨ́ cheru unu atadak'ãri, ãchi pitapai mãgapachida: “Jãgɨpa ichi ak'õre net'aa jõmaweda atait'ee chi ak'õre piuk'ãri. Peet'aadáma ajida, tachi-it'ee na ne-uu eujã beemerã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mapa ma uva eujãdeepa uchia atajida mãik'aapa peet'aajida. Mãpai Jesupa mãgaji: —Parãpa, ¿k'ãata k'ĩsia p'anɨma aji, ma uva eujã chiparipa ooit'ee ma eujã ak'ɨpataarã ome? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mɨa jarait'ee. Wãk'ãri, ma eujã ak'ɨpataarã peek'ooit'eeda aji, mãik'aapa chi eujã teeit'eeda aji, awaraarãmaa ãchia ak'ɨpataadamerã. Mãga ũridak'ãri, eperãarãpa mãgajida: —¡Mãga p'asa-e pait'eeda! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mamĩda Jesupa ãramaa ak'ɨji mãik'aapa mãgaji: —Mãgara, ¿k'ãata jara k'inia bɨma aji, na pedee Tachi Ak'õre Ũraa p'ãdadepema? ‘Te oopataarãpa mãu k'iniada-e padap'edaa pipɨara padachi.’ ");
INSERT INTO sjaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Eperã ma mãu pipɨara bɨ ɨ̃rɨ t'ĩutɨru pɨrã, chupɨria nɨ̃beeit'ee. Jõdee ma mãu eperã ɨ̃rɨ baairu pɨrã, iru peet'aait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","P'aareerã poroorãpa Moisepa p'ãda jarateepataarã ome ma nepɨrɨda ũri aupadak'ãri, k'awaajida Jesupa ãchideta pedee baji. Mapa aramata jita atapi k'inia p'anajida. Mamĩda mãga ooda-e paji eperãarã waawee p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Maperã t'ẽepai ma judiorã poroorãpa pëijida t'ãri jĩp'a pɨk'a beerã Jesús ome pedeede. K'inia p'anapachida ma eperãarãpa iidi p'anɨpa Jesupa pedee k'achia jarapidai Romadepemaarã poro waibɨarã ãpɨte. Mãgá ma eujã ak'ɨpari, Romadepemaarã poro waibɨapa iru atapii. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma-it'ee ma pëida eperãarãpa Jesumaa iidijida: —Tachi Jarateepari, taipa k'awa p'anɨda ajida, pɨa pedee wãara jarapari mãik'aapa jarateepari eperãarãpa ne-inaa pia oo k'awaadamerã. Eperãarã maarepida k'ũrak'aa. Ichita jara bɨ eperãarã k'ĩra jĩp'a p'anapataadamerã Tachi Ak'õrepa k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mãga bɨta, nãga iidi k'inia p'anɨ: ¿Pia bɨk'ã ajida, taipa Cesarmaa impuesto p'aadait'ee wa mãga-e? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesupa k'awa bada perã mãɨrãpa k'ĩsia k'achia iru p'anɨ, mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ak'ɨpítɨ denario p'arat'a tau. ¿K'ai k'ĩrata nade bɨ mãik'aapa k'ai t'ɨ̃ta p'ã bɨma? aji. P'anaujida: —César k'ĩra mãik'aapa ichi t'ɨ̃ta p'ã bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mãpai Jesupa mãgaji: —Mãgara téetɨ Cesarmaa irua net'aa iidipari, mãik'aapa auk'a téetɨ Tachi Ak'õremaa irua iidipari. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mãga ũridak'ãri, k'awaajida Jesumaa pedee k'achia p'oyaa jarapida-e pai eperãarã taide. Mapa ak'ɨtrua para beeji mãik'aapa k'ĩup'eek'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Maap'eda saduceorã ũk'uru wãjida Jesumaa. Saduceorãpa ijãadak'aa eperã piup'eda waya chok'ai p'irabaii. Maperã iidijida: ");
INSERT INTO sjaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tachi Jarateepari, Moisepa nãga p'ã bëijida ajida. Eperã miak'ãi bɨ warra wẽe piuru pɨrã, chi ɨ̃pemapa iru wẽra ataipia bɨ mãik'aapa aɨ ome warra ooipia bɨ chi ɨ̃pema piuda k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mãga jaradap'eda, ma saduceorãpa nãga nepɨrɨjida. P'anajida ɨ̃pemaarã siete. Chi naapema miak'ãiji. Mamĩda warra wẽe piuji. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chi araarepema ");
INSERT INTO sjaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","mãik'aapa araarepema miak'ãijida ma p'ẽtrãa ome. Mamĩda auk'a warra wẽe piujida. Ma t'ẽepai chi apemaarã jida miak'ãijida ma p'ẽtrãa ome. Mamĩda ãchi jõmaweda warra wẽe piujida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Maap'eda ma wẽra ichiaba piuji. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ɨ̃rá taipa nãga k'awa k'inia p'anɨ. Piudap'edaarã waya chok'ai p'irabaidak'ãri, ¿chisãgɨ́ ɨ̃pemata ma wẽra ɨmɨk'ĩra pait'eema ajida, ãchi jõmaweda iru ome miak'ãi p'anadap'edaa perã? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesupa p'anauji: —Na p'ek'au eujãde ɨmɨk'ĩraarã mãik'aapa wẽraarã miak'ãipata. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mamĩda Ak'õrepa jɨrɨt'eradaarã ichi eujãde p'anadak'ãri, ɨmɨk'ĩraarã wẽraarã paara waa miak'ãida-e pait'ee, ");
INSERT INTO sjaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","waa piuda-e pait'ee perã. Angeleerãk'a p'anadait'ee mãik'aapa Tachi Ak'õre warrarã padait'ee, chok'ai p'irabaidap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisepa paara tachimaa k'awapipari piudap'edaarã chok'ai p'irabaidait'ee. Chonaarãweda Tachi Ak'õrepa irumaa pedeek'ãri pak'uru jep'eda urua jira bɨdeepa t'ɨpɨtauk'a, jaraji ichi Abraham, Isaac, Jacob ijãadap'edaa Ak'õre Waibɨa. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Tachi Ak'õre piudap'edaarã Ak'õre Waibɨa-e! ¡Chok'ai p'anɨɨrã Ak'õre Waibɨa, iru-it'ee eperãarã jaureerã jõma chok'ai p'anadairã! ");
INSERT INTO sjaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mãpai ũk'uru Moisepa p'ãda jarateepataarãpa mãgajida: —Tachi Jarateepari, pia p'anaujida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Maadamãiipa waawee p'aneejida waa iididait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mãpai Jesupa iidiji: —¿Sãap'eda jara p'anɨma aji, Mesías chonaarãwedapema Rey Daviddeepa uchiait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Salmos p'ãdade Rey Davidpa paara jara bɨ: ‘Tachi Ak'õrepa jaraji Tachi Waibɨamaa: “Pɨ mɨ ome auk'a waibɨa bairã, su-ak'ɨ beepáde aji, mɨ juaraare, ");
INSERT INTO sjaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mɨa pɨ k'ĩra unuamaa iru p'anapataarã p'oyaaru misa.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidpa ichi ëreerãdeepa uchiait'ee bɨmaa t'ɨ̃jaraji “Tachi Waibɨa”. ¿Mapa k'awada-ek'ã aji, Mesías waibɨara bɨ chonaarãwedapema Rey David k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eperãarã jõmaarãpa ũrimaa p'anajida, Jesupa chi k'õp'ãyoorãmaa mãgak'ãri: ");
INSERT INTO sjaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—K'ĩrak'aupai p'anapataadai Moisepa p'ãda jarateepataarãk'a. Ãchi audua p'anadairã p'aru teesoo jɨ̃i awaa p'anapata mãik'aapa k'inia p'anapata jõmaarãpa ãchimaa saludaadamerã plaza bee chaa, tachi poro waibɨarã ome oopatak'a. Ichiaba su-ak'ɨ p'aneepata su-ak'ɨ beepari pipɨara bɨde Tachi Ak'õre Ũraa jarateepata tede mãik'aapa nek'odak'ãri, chi su-ak'ɨ beepari pipɨara bɨde su-ak'ɨ p'aneepata. ");
INSERT INTO sjaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma awara p'ẽtrãarã k'aripadai k'ãyaara, ãra te jãri atapata mãik'aapa taarã ɨt'aa t'ɨ̃pata, eperãarãpa ãchi t'o p'anadamerã. Mãga p'anapata perã, Tachi Ak'õrepa ãra audupɨara miapiit'ee, k'achia beerã miapik'ãri ichi ewari waibɨa ewate. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesupa ak'ɨmaa baji, p'arat'ara beerãpa primisia ata bɨ p'anɨ misa p'arat'a p'epatade Tachi Ak'õre te waibɨade. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mãpai ichia unuji p'ẽtrãa chupɨria k'ɨrɨpa ata bɨ cheru p'arat'a tau omé cobredee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mãga unuk'ãri, Jesupa mãgaji: —Mɨa wãarata jararu. Na p'ẽtrãa chupɨria k'ɨrɨpa primisia waibɨara teejida aji, apemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jõmaarãpa tee p'anɨ ãchi p'arat'a waibɨa iru p'anadap'edaadepema beeda. Jõdee na p'ẽtrãa, chupɨria k'ɨrɨ mĩda, ichia iru k'erada jõmaweda teeji Tachi Ak'õremaa. Teejida aji, chi p'arat'a iru bada paara chik'o netoit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eperãarã ũk'uru pedeemaa p'anajida Tachi Ak'õre te waibɨade. Jarapachida mãu pi-iadee oo k'obɨ mãik'aapa k'ĩra wãree bainɨ̃ bɨ eperãarãpa net'aa tee p'anadap'edaa k'aurepa. Mãga ũrik'ãri, Jesupa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ewari cherude parãpa na jõma unu p'anɨ unuda-e pait'ee. Mãu apida bee-e pait'ee awaraa mãu ɨ̃rɨ, na jõmaweda t'eek'oo chedait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mãpai Jesumaa iidijida: —Tachi Jarateepari, ¿sãapaita mãga p'asait'eema? ajida. ¿Sãga k'awadayama ajida, ma ewari k'ait'a pak'ãri p'asait'ee pɨa jaradak'a? ");
INSERT INTO sjaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesupa p'anauji: —Tauk'a nipapatáatɨ apidaamaa k'ũrapiamaapa. Mɨ jĩak'a chok'ara chedait'ee. Seewata jaradait'ee: “Mɨta Ak'õre Warra; ɨ̃rapɨ paji chi cheit'ee bada.” Mamĩda ãchia jara p'anɨ ijãanáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ũridak'ãri eperãarãpa jura chõo jõnɨ mãik'aapa oodaamaa p'anɨ ãchi poro waibɨarãpa jara p'anɨk'a, p'eranáatɨ. Ichita mãga p'asait'ee naapɨara. Mamĩda Tachi Ak'õre ewari waibɨa ewate at'ãri pa-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ichiaba Jesupa mãgaji: —Eperãarã awaraarã ome chõodait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Awẽrachai wëre nɨ̃beeit'ee; jarra oodait'ee mãik'aapa k'ayaara paraait'ee eujã awara-awaraade. Ma awara pajãde ne-inaa waide unudak'aa unupataadait'ee; ne-inaa tachi p'erapipari. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Mamĩda mãga p'asai naaweda, ijãadak'aa beerãpa parã jɨrɨpataadait'ee miapidait'ee mãik'aapa jita atadap'eda, ateedait'ee Tachi Ak'õre Ũraa jarateepata tede. Mama parã ak'ɨdait'ee jaradait'ee eperãarã pia wa k'achia. Ichiaba carcelde t'ɨ nɨ̃bɨnadait'ee mãik'aapa ateedait'ee reyrã k'ĩrapite maa-e pɨrã eperãarã poro waibɨarã k'ĩrapite. Ma jõma parãmaa oopataadait'ee, mɨde ijãapata k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mãga oodak'ãri, ãchi k'ĩrapite parãpa jarapataadai Tachi Ak'õrepa ooda parã-it'ee mɨ k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Maapai k'ĩsianáatɨ k'ãare pedeeta jaradai. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mɨa k'ĩsia k'awaa pedee jarapiit'ee, parã k'ĩra unuamaa iru p'anapataarãpa p'anaupiamaapa mãik'aapa jarapiamaapa parãpa seewa jara jõnɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mamĩda pãchi ak'õreerãpa, ɨ̃pemaarãpa, ëreerãpa mãik'aapa k'õp'ãyoorãpa paara parã traicionaadait'ee. Maapai parã ũk'uru peepidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jõmaarãpa parã k'ĩra unuamaa iru p'anapataadait'ee mɨde ijãapata k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mamĩda parã puda k'ãu apida atuada-e, mɨa parã ak'ɨ bapariit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mapa ¡t'ãripa choopatáatɨ! Mãgá parã ɨt'aa wãdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Unudak'ãri soldaorãpa Jerusalén p'uuru wap'ɨra iru p'anɨ, k'awáatɨ taarã-e jõdariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Maapai Judea eujãde p'anɨɨrã mirudaipia bɨ eera jẽra bɨdee. Jõdee Jerusalén p'uurude p'anɨɨrã mamãik'aapa uchiadaipia bɨ. Ichiaba chi taawa p'anɨɨrã chedaik'araa bɨ p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mãga oodaipia bɨ ma ewate Tachi Ak'õrepa mɨde ijãadak'aa beerã k'achia ooit'ee perã. Eperãarã chupɨria chitoonadait'ee, Tachi Ak'õrepa ãra k'achia ooit'ee perã ichi ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Aai, ma ewate chupɨria jõneedait'ee wẽraarã biak'oo bee maa-e pɨrã warra chak'eerã jude iru bee, isapai p'oyaa wãda-e pait'ee perã! Ma eujãde audú chupɨria jõnadait'ee mãik'aapa Tachi Ak'õrepa ne-inaa k'achia ooit'ee na p'uurudepemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ũk'uru piudait'ee espadapa; awaraarã ateedait'ee awaraa eujãdee esclavoorãk'a p'aneedamerã. Maapai Tachi Ak'õrede ijãadak'aa beerãpa Jerusalén p'uuru iru p'anadait'ee ãchi jua ek'ari, Tachi Ak'õrepa ewari awara bɨda parumaa ãra k'achia ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Maapai ne-inaa eperãarãpa waide unudak'aa unudait'ee ak'õrejĩrude, atanede mãik'aapa lucerode. Na p'ek'au eujãdepemaarãpa mãga unudak'ãri, k'awada-e pait'ee k'ãata k'ĩsiadai mãik'aapa p'eradait'ee, audú p'usa t'o jĩwaa nɨ̃bait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eperãarã k'ĩra k'ĩdaipataadait'ee p'era jõnɨpa, k'ĩsiadak'ãri na p'ek'au eujã p'asarude, pajã wëre nɨ̃bait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mãpai eperãarãpa unudait'ee mɨ, chi Eperã Ak'õre Truadepema jõmaarã k'ãyaara waibɨara bɨ, k'ĩra wãree cheru jɨ̃ararade. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mãga p'asak'ãri, sõcharra p'anapatáatɨ mãik'aapa t'ãri o-ĩa para bátɨ, taarã-e nɨde mɨ cheit'ee perã parã k'aripade atuanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ichiaba Jesupa nãga nepɨrɨji jarateeit'ee ichi waya cheit'ee pak'ãri: —K'ĩsíatɨ higuera bɨɨrɨde maa-e pɨrã awaraa nejõ bɨɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Unudak'ãri k'iru t'uk'ua uchia nɨ̃beeru, parãpa k'awaapata eujã wãsia wã. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mãga pɨk'a unudak'ãri mãgɨ́ ne-inaa p'asaruta, k'awaadait'ee Tachi Ak'õre ewari waibɨa ewate k'ait'a bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Mɨa wãarata jararu. Ɨ̃rapemaarã piudai naaweda, ma ne-inaa jõmaweda p'asait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ewari cherude pajã na p'ek'au eujã ome jõdait'ee. Mamĩda ichita p'asait'ee mɨa pedee jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’K'ĩrak'aupai k'ɨɨrɨ k'isua p'aneedai pãchi k'inia ne-inaa oo k'iniapa; it'ua to k'iniapa maa-e pɨrã audú k'ĩsia jõnɨpa na p'ek'au eujãdepema ne-inaade. Maa-e pɨrã atu bɨde ");
INSERT INTO sjaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ne-animal trampade baaiparik'a, mãga pɨk'a parã atu p'anɨde mɨ waya cheit'ee. Ma ewate ne-inaa k'achia p'asait'ee jõmaweda na p'ek'au eujãdepemaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mapa tauk'a nipapatáatɨ mãik'aapa ichita ɨt'aa t'ɨ̃patáatɨ. Mãgá baaida-e pait'ee ma ne-inaa k'achia p'asait'ee bɨ juade mãik'aapa panadait'ee mɨ, chi Eperã Ak'õre Truadepema k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ewari chaa ãstaawa Jesupa jarateepachi Tachi Ak'õre te waibɨade. Jõdee p'ãrik'ua beepachi Olivo Eede. ");
INSERT INTO sjaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Maperã tap'eda weda eperãarã wãpachida Tachi Ak'õre te waibɨadee iru pedee ũride. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","K'ait'a baji fiesta pan levadura wẽe k'opata t'ɨ̃jarapatap'edaa Pascua. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","P'aareerã poroorãpa Moisepa p'ãda jarateepataarã ome eperãarã waawee p'anadap'edaa perã, ãra taide Jesús jita atapida-e paji. Mamĩda ichita jɨrɨpachida sãga iru peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mãpai Satanás Judas k'ap'ɨade t'ĩuji. Mãgɨ́ Judas Jesús k'õp'ãyoorã docedepema paji. Ichiaba t'ɨ̃jarapachida Iscariote. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mãgɨ́ wãji p'aareerã poroorãmaa mãik'aapa Tachi Ak'õre te waibɨa jɨ̃apataarãmaa. Mama pedeeji ãchi ome sãga Jesús atapii. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mãpai ãchi o-ĩadachida mãik'aapa pedeejida p'arat'a teedait'ee Judamaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ichia ma p'arat'a jitap'eda, jɨrɨmaa beeji sãga Jesús ãchimaa atapii, eperãarã wẽ-e misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Fiesta pan levadura wẽe k'opata ewate pak'ãri, oveja chak'e peepata Pascua fiesta-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mapa Jesupa jaraji Pedro Juan ome Pascua fiestadepema chik'o jɨrɨdamerã mãik'aapa awaraa ne-inaa oodamerã, nek'odai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mãpai ãchia iidijida: —¿Sãma mãga oodaipia bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesupa p'anauji: —Parã p'uurude panadak'ãri, unudait'ee eperãpa pania chok'ode ateeru. Iru t'ẽe wã́tɨ ichi temãi t'ĩurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mãpai chi te chiparimaa jarátɨ: “Tachi Jarateeparipa iidi pëiji: ‘¿Chisãgɨ́ cuartode Pascua chik'o k'oit'ee mɨchi k'õp'ãyoorã ome?’ ” ");
INSERT INTO sjaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ɨt'ɨpema pisode irua ak'ɨpiit'eeda aji, cuarto waibɨa ne-inaa jõmaa ome. Mama ne-inaa jõma óotɨ tachi nek'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ãchi wãdak'ãri, jõmaweda ununajida Jesupa jaradak'a mãik'aapa mama ne-inaa jõma oojida Pascua chik'o k'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nek'odait'ee pak'ãri, Jesús chi k'õp'ãyoorã ome mesade su-ak'ɨ p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mãpai ichia mãgaji: —¡Wãara mɨ piu naaweda, parã ome na Pascua fiestadepema chik'o audú k'o k'inia baji! ");
INSERT INTO sjaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mɨa jara bɨ: Parã waa nãgá nek'oda-e pait'ee mɨ ome, Tachi Ak'õre truade p'anadai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mãpai copa jitap'eda, gracias jaraji Tachi Ak'õremaa mãik'aapa mãgaji: —Jitátɨ na copa mãik'aapa jedétɨ pãchi pitapai. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mɨa jara bɨ: Mɨa vino waa to-e pait'eeda aji, Tachi Ak'õre truade pai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Maap'eda Jesupa pan ataji mãik'aapa ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa. Ma pan k'õrat'aaji mãik'aapa chi k'õp'ãyoorãmaa teeji. Mãpai mãgaji: —Nãgɨ́ pan mɨ k'ap'ɨa, mɨ peepiit'ee parã k'aripait'ee. Nãgá pan k'odak'ãri, k'opatáatɨ k'irãpadait'ee mɨ piuda parã pari. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nek'odap'edaa t'ẽepai, ichiaba mãgá ooji ma vino ome. Mãgaji: —Nãgɨ́ vino mɨ waa, mɨchi waa bat'ait'ee perã mɨ piuk'ãri eperãarã pari. Tachi Ak'õrepa nãgɨ́ ũraa chiwidi jara bɨ. Mɨchi waa bat'ada k'aurepa irua wẽpapiit'ee parãpa p'ek'au k'achia oopata mãik'aapa mɨchideerã papiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mamĩda chi mɨ traicionaait'ee bɨ jua na mesa ɨ̃rɨ bɨ mɨchi jua ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɨ, chi Eperã Ak'õre Truadepema ichita piut'ee Ak'õrepa oopi bɨk'a. Mamĩda, ¡aai, Tachi Ak'õrepa k'achiadee pëiit'ee chi mɨ traicionaait'ee bɨ! ");
INSERT INTO sjaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mãpai ãchi pitapai iidi para beeji k'aipata traicionaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mãpai chi k'õp'ãyoorã aupedee para beeji k'awaadait'ee k'aita pipɨara bɨ apemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mapa Jesupa mãgaji: —Ijãadak'aa beerã t'ãide reyrãpa ãchia oo k'iniata oopipata eperãarãmaa mãik'aapa mãɨrã poro waibɨarãpa ãchi jua ek'ari p'anɨɨrã pia ak'ɨ p'anɨda apata. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mamĩda parã mãgá p'anadaik'araa bɨ. Ma k'ãyaara parã t'ãidepema waibɨara bɨ warra chok'ek'ee baparik'a baipia bɨ. Ma awara parã t'ãidepema poro waibɨara bɨ mimiapari jĩp'aak'a beeipia bɨ parã k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Chisãgɨ́ eperã waibɨara bɨ; chi mesade su-ak'ɨ bɨ nek'oit'ee maa-e pɨrã chi chik'o jedepari? ¿Chi mesade su-ak'ɨ bɨ-ek'ã? Jõdee mɨ nama bɨ parã t'ãide chi chik'o jedeparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Parã ichita mɨ ome p'anɨ, nepɨrade wa ne-inaa k'achiade p'anajida mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mapa mɨa parã reyrã papiit'ee mɨ Ak'õrepa mɨ rey papidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Parã nek'odait'ee Ak'õre truade mãik'aapa ne-inaa todait'ee mɨ ome mɨ ɨt'aripema mesade. Ma awara su-ak'ɨ p'aneedait'ee rey su-ak'ɨ beeparide. Israeldeepa ëreerã doce uchiadap'edaarã iru p'anadait'ee parã jua ek'ari mãik'aapa jaradait'ee mãɨrãpa oopatap'edaa pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ichiaba Jesupa mãgaji: —Simón, Simón, Satanapa parã iididoo oo k'inia bairã trigo ome oopatak'a nẽesidak'ãri chi tau ãyaa atadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mamĩda mɨ ɨt'aa t'ɨ̃pari pɨ pari mɨde ijãa bapariimerã. Waya mɨ ome nipak'ãri, k'aripáji pɨchi ɨ̃pemaarã mɨ k'ap'ɨa, ichita ijãapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mãpai Simonpa mãgaji: —Tachi Waibɨa, mɨ pɨ ome nipa k'inia bɨda aji, mɨ carcelde t'ɨ nɨ̃bɨruta pɨjida maa-e pɨrã piuru pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesupa p'anauji: —Pedro, mɨa jara bɨ: Idi p'ãrik'ua et'erre k'arii naaweda, jarada õpee pɨa mɨ k'awa-e bɨda ait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Maap'eda Jesupa iidiji: —Mɨa parã pëik'ãri muchila wẽe, p'arat'a te wẽe, chancla wẽe, ¿net'aa apida faltajidak'ã? aji. P'anaujida: —Maarepida faltada-e pajida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mãpai irua mãgaji: —Ɨ̃rá, jõdee, chi muchila iru bɨpa ateeipia bɨ ichi p'arat'a te ome; chi espada wẽe bɨpa ichi ɨ̃rɨpema p'aru jɨ̃ bɨ netoipia bɨ mãik'aapa espada aba neto ataipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mɨa mãga jara bɨ ichita uchiait'ee perã mɨde jara bɨk'a Ak'õre Ũraa p'ãdade: ‘Eperã t'ãri k'achia-idaak'a iru p'anajida.’ Jõma ma p'ãdade jara bɨ mɨde ichita p'asait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mãpai ãchia mãgajida: —Tachi Waibɨa, nama espada omé iru p'anɨda ajida. Mãpai irua p'anauji: —Jãgapaipɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Maap'eda Jesús wãji Olivo Eedee ichi wãpatak'a mãik'aapa chi k'õp'ãyoorã t'ẽe wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mama panadak'ãri, ichia ãramaa mãgaji: —Ɨt'aa t'ɨ̃́tɨ p'ek'au k'achiade baaipiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Maap'eda Jesús waawipai wãji chi k'õp'ãyoorã p'anadap'edaamãiipa. Mama bedabaiji ɨt'aa t'ɨ̃it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mãgaji: —Ak'õre, pɨchia k'inia bɨ pɨrã, k'aripáji na miait'ee bɨdeepa. Mamĩda oonaapáde aji, mɨa k'inia bɨk'a. Jĩp'a pɨa k'inia bɨ́k'ata oopáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mãga nɨde ɨt'aripema ángel iru ik'aawa bainɨ̃ ba cheji iru k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús audú t'ãri p'ua nɨ̃bada perã, audupɨara ɨt'aa t'ɨ̃pachi, ichi jɨa eujãde baairumaa waa t'eut'ewaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɨt'aa t'ɨ̃ aupak'ãri, chi k'õp'ãyoorã atabëidamaa wãji. Mamĩda ununaji k'ãi para bɨ, audú t'ãri p'ua jõnɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mãpai irua mãgaji ãramaa: —¿Sãap'eda k'ãi jõnɨma? aji. P'irabáitɨ mãik'aapa ɨt'aa t'ɨ̃́tɨ p'ek'au k'achiade baaipiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús at'ãri pedeemaa bɨde, eperãarã chok'ara pachejida. Ma eperãarã chok'ara chedap'edaa naa che wãji Judas, Jesús k'õp'ãyoorã docedepema. Mãgɨ́ Jesús k'ait'a chek'ãri k'ĩra ɨ̃t'aait'ee, ");
INSERT INTO sjaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesupa mãgaji: —Judas, ¿mɨ k'ĩra ɨ̃rupa mɨ, chi Eperã Ak'õre Truadepema traicionaaruk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús ome p'anadap'edaarãpa mãga unudak'ãri, iidijida: —Tachi Waibɨa, ¿espadapa chõodaipia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aramata ãradepema abaapa p'aareerã poro waibɨa mimiapari juaraarepema k'ɨɨrɨ orp'et'aaji espadapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mãpai Jesupa mãgaji: —Ichiak'au bɨ́tɨ; jãgapaipɨ. Mãpai Jesupa ma eperã k'ɨɨrɨ orp'et'aadamãi t'õbait'aaruta, anidachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mãpai mãgaji ichi ata chedap'edaa p'aareerã poroorãmaa, Tachi Ak'õre te waibɨa jɨ̃apataarãmaa mãik'aapa judiorã poro waibɨarãmaa: —¿Sãap'eda parã espada ome mãik'aapa pak'uru ome chejidama aji, mɨ jita atade, nechɨayaa bɨ jita atapatak'a? ");
INSERT INTO sjaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ewari chaa mɨ Tachi Ak'õre te waibɨade bapari parã ome. Maapai parãpa mɨ jita atada-e paji. Mamĩda hora pajipɨ parãpa ne-inaa k'achia oodamerã mɨmaa, Netuara Poro Waibɨapa k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesús mãgá jita atadap'eda, ateejida p'aareerã poro waibɨa temaa. Mãɨmisa Pedro t'ɨmɨɨpapai t'ẽe wãk'ãtɨ wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mama te taawaik'a eere t'ɨak'au bɨmãi t'ɨpɨ oro iru p'anajida mãik'aapa aɨ ik'aawa eperãarã su-ak'ɨ p'anajida. Pedro jida ichiaba su-ak'ɨ beeji ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mãga nɨde ariipema mimiapari awẽrapa Pedro unuji, t'ɨpɨtau ik'aawa su-ak'ɨ bɨ. Ma mimiaparipa pi-ia ak'ɨji mãik'aapa mãgaji: —Nãgɨ́ jida auk'a jã eperã ome bajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mamĩda Pedropa meraji: —Mɨa iru k'awa-e bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Taarã-e nɨde awaraapa Pedro unu atak'ãri, ichiaba mãgaji: —Pɨ auk'a jã eperã k'õp'ãyoorãdepemada aji. Pedropa p'anauji: —¡Mɨ iru k'õp'ãyo-eda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hora abaamaa awaraapa ichiaba mãgaji: —Wãara na eperã ichiaba bajida aji, jãgɨ́ ome. Ma awara ichi Galilea eujãdepemada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedropa p'anauji: —Mɨa k'awa-e bɨda aji, k'ãaredeta pedee bɨ. Aramata Pedro at'ãri pedeemaa bɨde, et'erre k'ariji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mãpai Jesupa ãpɨtee ak'ɨji Pedromaa mãik'aapa Pedropa k'irãpaji irua jarada: “Et'erre k'arii naaweda, pɨa jarada õpee jarait'ee mɨ k'awa-e bɨ.” ");
INSERT INTO sjaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mãpai Pedro taawaa uchiap'eda, jẽe nɨ̃beeji audú t'ãri p'ua nɨ̃bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesús jɨ̃a p'anadap'edaarãpa iru oo iru p'aneepachida mãik'aapa sĩpachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iru tau p'ãrajɨ̃ atadap'eda, mãgapachida: —¡Pɨ wãara Tachi Ak'õre Warra pɨrã, jarapáde aji, k'aipata pɨ sĩji! ");
INSERT INTO sjaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ichiaba awaraa ik'achia pedee jarapachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tap'eda weda judiorã poro waibɨarã, p'aareerã poroorã mãik'aapa Moisepa p'ãda jarateepataarã, pia jarait'eera, chi Junta Supremadepemaarã chip'ejida. Mãpai Jesús aneejida ãra k'ĩrapite. Irumaa iidijida: ");
INSERT INTO sjaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Pɨk'ã ajida, Mesías, Tachi Ak'õrepa pëida eperãarã rey pamerã? Ichia p'anauji: —Mɨa mãgada aru pɨrã, parãpa ijãada-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jõdee mɨa parãmaa ne-inaa iidiru pɨrã, p'anauda-e. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mamĩda mɨa jara bɨ: Ɨ̃raweda mɨ, chi Eperã Ak'õre Truadepema Tachi Ak'õre Waibɨa juaraare su-ak'ɨ banait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mãpai jõmaarãpa iidijida: —¿Mãgara pɨ Tachi Ak'õre Warrak'ã? ajida. Jesupa p'anauji: —Pãchia jara p'anɨk'a, mãgada aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mãpai ãchia mãgajida: —¿K'ãare-it'ee eperãarã waa jɨrɨdayama ajida, irua ooda jaradamerã? Tachi k'ɨɨrɨpa ũrijidada ajida, ma pedee k'achia ichi it'aideepa jarada Ak'õre Waibɨa ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma judiorã poro waibɨarã p'irabaik'oodaidap'eda, Jesús ateejida Pilato k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mama iru k'ĩrapite ɨmɨateemaadachida: —Taipa na eperã unujidada ajida, tai p'uuru pidaarãmaa k'ĩsia awara-awaraa papimaa bɨ. Jara bɨ taipa Cesarmaa impuesto p'aadaik'araa bɨ. Ma awara jara bɨ ichi Mesías, Tachi Ak'õrepa pëida rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mãpai Pilatopa iidiji: —¿Pɨk'ã aji, Judiorã Rey? Jesupa p'anauji: —Mɨda aji, pɨa jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mãpai Pilatopa mãgaji ma p'aareerã poroorãmaa mãik'aapa arii p'anadap'edaarãmaa: —Mɨa unu-e bɨda aji, na eperãpa ne-inaa k'achia ooda. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mamĩda audupɨara golpe pedeejida: —Ichia jaratee bɨ k'aurepa tai p'uuru pidaarã jõmaweda chõo pɨk'a para bɨ. Naa Galilea eujãde jaratee nipa beeji. Ɨ̃rá nama Judea eujãde auk'a oomaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mãga ũrik'ãri, Pilatopa iidiji: —¿Na eperã Galilea eujãdepemak'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ichida adak'ãri, Pilatopa pëiji Herodemaa. Mãgɨ́ Galilea eujã ak'ɨpari paji. Auk'a baji Jerusalende. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodepa Jesús unuk'ãri, o-ĩadachi aɨ naaweda iru k'ĩra unu k'inia bada perã mãik'aapa ũrida perã nepɨrɨ p'anɨ irua oopari ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mapa unu k'inia baji ichi taide irua mãgee ne-inaa oomerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ma-it'ee iidida chok'ara iidiji Jesumaa. Mamĩda Jesupa maarepida p'anauk'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mama ichiaba p'aareerã poroorã mãik'aapa Moisepa p'ãda jarateepataarã p'anajida. Ãchiata audú Jesús ɨmɨateepachida. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mapa Herodes ichi soldaorã ome Jesumaa ik'achia pedee jarajida mãik'aapa reypa jɨ̃pari p'aru pi-iara bɨta jɨ̃ bɨjida iru oo iru p'anadait'ee. Maap'eda Herodepa waya ãpɨtee pëit'aaji Pilatomaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma ewate Pilato k'õp'ãyo meraaji Herodes ome, aɨ naaweda chik'ĩra unuamaa p'anapachida mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatomãi panadak'ãri, irua waya t'ɨ̃ p'eji p'aareerã poroorã, judiorã poro waibɨarã mãik'aapa p'uuru pidaarã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Maap'eda mãgaji: —Parãpa mɨmaa jara chejida na eperãpa p'uuru pidaarã k'ĩsia awara-awaraa papik'oomaa bɨ. Mamĩda parã k'ĩrapite irumaa mɨa iidida chok'ara iidiji mãik'aapa unu-e ne-inaa k'achia apida ichia oo bɨda a p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","¿Ichiaba Herodepa iru mãga unu bɨ-ek'ã? aji. Maa-e pɨrã waya namaa pëi-e pak'aji. Parãpa k'awa p'anɨ irua ne-inaa k'achia oo-e bɨ ma k'aurepa iru peepimerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mapa wɨpip'eda, ichiak'au wãpiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mãgɨ́ fiestade Pilatopa k'ena pëipachi carceldepema preso; chi iidirutata p'uuru pidaarãpa. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mamĩda arii p'anadap'edaarã jõmaweda biuk'adachida: —¡Jãgɨ́ ãyaa atáji! ¡Barrabata k'ena pë́iji! ");
INSERT INTO sjaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ma Barrabás carcelde baji ooamaa bada perã Romadepemaarãpa oopipatak'a ma p'uurude; ma awara chĩara peet'aada perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mãpai Pilatopa Jesús uchia pëi k'inia bada perã, waya pedeeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mamĩda ãchi waapɨara biuk'a nɨ̃beeji: —¡Kurusode peepit'áaji! ¡Kurusode peepit'áaji! ");
INSERT INTO sjaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mãpai waya jarada õpee Pilatopa mãgaji: —¿K'ãare k'achiata oojima aji, irua? Mɨa unu-e bɨ ne-inaa k'achia ooda ma k'aurepa peepiit'ee. Wɨpip'eda, ichiak'au k'ena pëiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mamĩda audupɨara biapachida Jesús kurusode baijira bɨpimerã. Mãgá bia jõnɨpa ãchia k'inia p'anadap'edaak'a oopijida. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatopa ooji ãchia iidi p'anadap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","K'ena pëiji Barrabás, ãchia k'inia p'anadap'edaa, ma ooamaa bada Romadepemaarãpa oopidap'edaak'a mãik'aapa chĩara peeda. Jõdee Jesús ateepiji kurusode baijira bɨnadamerã, ãchia k'inia p'anadap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesús ateedak'ãri kurusode baijira bɨdait'ee, jita atajida eperã aba p'uurudee che wã nipada, Cirene p'uurudepema t'ɨ̃jarapatap'edaa Simón. Mãgɨmaa kuruso ateepijida Jesús t'ẽe. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma wãdade eperãarã chok'ara ichi t'ẽe wã nipapachida. Mãɨrã ome wãdap'edaarã wẽraarã chok'ara jẽe wãpachida mãik'aapa biuk'a wãpachida t'ãri p'uapa, Jesús mãgá atee wãdap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mamĩda Jesupa ãchimaa ak'ɨji mãik'aapa mãgaji: —Jerusalendepema wẽraarã, jẽenáatɨ mɨ pari. Jẽ́etɨ pãchi pari mãik'aapa pãchi warrarã pari, ewari cherude audú chupɨria chitoonadait'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tachi Ak'õrepa na eujãdepemaarã k'achia ook'ãri, mãgadait'ee: “O-ĩa p'anɨ chi ju tawadak'aa beerã warra t'odak'aa perã.” ");
INSERT INTO sjaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma ewate eperãarãpa eemaa jaradait'ee: ‘¡Tai ɨ̃rɨ ɨrak'oodarítɨ!’ mãik'aapa: ‘¡Tai t'ap'a atátɨ!’ ");
INSERT INTO sjaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eperãarãpa pak'uru õdoo bɨ t'ɨpɨtaude bat'at'aapata pɨrã, ¿audupɨara pak'uru p'ũasaa bɨ bat'at'aada-e paik'ã, taarã-ee paa jõdaipari perã? ");
INSERT INTO sjaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ichiaba Jesús ome atee wã nipajida k'achia beerã omé auk'a kurusode baijira bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Panadak'ãri eujã “Tachi Poro Bɨɨrɨ” apatap'edaamãi, Jesús ma k'achia beerã ome kurusode baijira bɨjida; aba juaraare, chi apema juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mãpai Jesupa mãgaji: —Ak'õre, mɨ nãgá oo p'anɨɨrã perdonáaji, k'awada-e p'anadairã ne-inaa k'achiata oomaa p'anɨ. Mãpai soldaorãpa suerte jemenejida k'awaadait'ee k'aipata iru p'aru atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mãɨmisa arii p'anadap'edaarãpa Jesumaa ak'ɨ para bapachi mãik'aapa judiorã poroorãpa iru nãga oo iru p'anapachida: —Awaraarã k'aripadak'a, pɨchi k'ap'ɨa jida k'aripa atáji, wãara Tachi Ak'õrepa pɨ pëida pɨrã, maa-e pɨrã irua jɨrɨt'erada pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaorãpa ichiaba Jesús oo iru p'anapachida. Iru k'ait'a wãdap'eda, vino achuchua teepachida ");
INSERT INTO sjaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mãik'aapa mãgapachida: —¡Pɨ wãara Judiorã Rey pɨrã, jãmãik'aapa uchiadaríji! ");
INSERT INTO sjaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ichiaba Jesús poro ɨt'aik'a eere letrero bɨjida: Nãgɨ́ Judiorã Rey. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma awara iru ik'aawa baijira badapa ik'achia jarapachi: —¡Pɨ wãara Tachi Ak'õrepa pëida pɨrã, jãmãik'aapa uchiadaipáde apachi, mãik'aapa tai jida auk'a k'aripapáde! apachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mamĩda chi apemapa mãgɨ́ pedee bada ɨtrɨat'aaji: —¿Pɨa Tachi Ak'õre waawee-e bɨk'ã aji, nama auk'a baijira bɨta? ");
INSERT INTO sjaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tachi nama chupɨria chitoonɨ ne-inaa k'achia oodap'edaa perã. Mamĩda na eperãpa ne-inaa k'achia ook'aa pajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Maap'eda, mãgaji: —Jesús, pɨ Ak'õre Waibɨa truade rey beek'ãri, mɨ k'irãpáji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesupa p'anauji: —Mɨa wãarata jararu. Idi pɨ mɨ ome bapariit'eeda aji, Ak'õre Waibɨa eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Imat'ɨpa ak'õrejĩru k'iat'ɨdachi. Na eujã jõma p'ãriudachi las tres parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ak'õrejĩru k'iat'ɨdachi mãik'aapa Tachi Ak'õre te waibɨadepema cuarto edupɨara t'ĩupatamãi p'aru eebai jira bada esajĩak'a jẽdachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mãpai Jesús golpe biaji: —‘¡Ak'õre, mɨchi jaure pɨ juade bɨru!’ Mãga jarap'eda, jai-idaaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romadepema soldaorã poropa ma jõma unuk'ãri, pedee pia jaraji Tachi Ak'õremaa mãik'aapa mãgaji: —Wãara na eperãpa ne-inaa k'achia ook'aa pajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eperãarã jõmaweda mama see nɨ̃badaarãpa mãga unudak'ãri, ãchi t'ũa t'aap'e erreudachida t'ãri p'uapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mamĩda Jesús ome nipapatap'edaarã, ɨmɨk'ĩraarã mãik'aapa wẽraarã iru ome chedap'edaa Galilea eujãdeepa, ma ne-inaa p'asada t'ɨmɨɨpa ak'ɨmaa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ma eujãde eperã t'ãri pia bapachi. Ne-inaa k'achia ook'aa paji. Mãgɨ́ t'ɨ̃jarapachida José. Iru Arimatea p'uurudepema paji. Mãgɨ́ p'uuru Judea eujãde bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nɨ baji Tachi Ak'õrepa pëida eperãarã rey pamerã. Junta Supremadepema paji. Mamĩda ijãa-e paji mãɨrãpa oodap'edaade Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mapa wãji Pilatomaa Jesús k'ap'ɨa piuda iidide ɨait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","T'ẽepai Jesús k'ap'ɨa kurusodeepa ɨrabai atap'eda, pɨrat'aaji lienzode mãik'aapa bɨnaji mãu te uria k'oro iru p'anadap'edaade. Made piuda apida waide ɨada-e p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma ewate judiorã ɨ̃ipata noreweda paji. P'ãriupodopa pada perã, ne-inaa waa ooik'araa baji, ɨ̃ipata ewate wãyaaru misa. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ma wẽraarã Jesús ome Galilea eujãdeepa chedap'edaa ichiaba wãjida ma mãu te uriade iru bɨdap'edaamaa mãik'aapa ak'ɨjida sãga Jesús k'ap'ɨa ata bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Maap'eda teedaa chedak'ãri, k'era oojida ne-inaa awaraa t'ũa bee ome Jesús k'ap'ɨa ɨ̃rɨ bɨdait'ee, judiorãpa oopatak'a ãchi auk'aarã piudak'ãri. Ɨ̃ipata ewate ma wẽraarã ɨ̃ijida Tachi Ak'õre Ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tomia ewate tap'eweda ma wẽraarã wãjida Jesús k'ap'ɨa ɨadap'edaamaa. Ateejida k'era ne-inaa t'ũa ome ãchia oodap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Panadak'ãri, unujida chi mãu te uria t'ai mãupa t'ap'a bada awara ãi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","T'ĩudak'ãri, Tachi Waibɨa Jesús k'ap'ɨa unuda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","K'awadak'aa paji k'ãata oodait'ee. Mãga nɨde unujida ɨmɨk'ĩraarã omé p'aru t'o-t'oo uchiterree jɨ̃ bainɨ̃ p'anɨ ãchi ik'aawa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mãpai ãchobeepa bedabaidachida tau bɨɨrɨ eujãde t'õbairutamaa. Mamĩda mãɨrãpa mãgajida: —¿Sãap'eda jãɨramãi jɨrɨ p'anɨma ajida, iru chok'ai bɨta? ");
INSERT INTO sjaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iru nama wẽ-e. ¡Chok'ai p'irabaiji! K'irãpátɨ iru at'ãri Galilea eujãde bak'ãri, ");
INSERT INTO sjaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","jaraji ichi, chi Eperã Ak'õre Truadepema, k'achia beerã juade bɨdait'ee; ãrapa kurusode baijira bɨdait'ee piumerã mãik'aapa ewari õpeemaa ichi chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mãga ũridak'ãri, ma wẽraarãpa Jesupa jarada k'irãpajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mãpai iru k'ap'ɨa ɨadap'edaamãiipa wãdak'ãri, ma jõmaweda nepɨrɨnajida Jesús k'õp'ãyoorã oncemaa mãik'aapa awaraarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chi mãga nepɨrɨnadap'edaarã paji María Magdalena, Juana, Santiago nawe María mãik'aapa awaraa wẽraarã. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mamĩda ãrapa nepɨrɨdap'edaa ũridak'ãri, Jesús k'õp'ãyoorãpa k'ĩsiajida pariatua pedeemaa p'anɨ. Mapa ijãa k'iniada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mãga jarajida mĩda, Pedro p'iradachi Jesús k'ap'ɨa ɨadap'edaamaa mãik'aapa edajãde ak'ɨk'ãri, chi k'ap'ɨa lienzode beda bada unu-e paji. Jĩp'a chi p'aru aupai unuji. Mãpai p'era pɨk'a teedaa cheji. K'awa-e paji k'ãata ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma ewate weda Jesús ome nipapatap'edaarã omé wã nipajida Emaús p'uurudee. Ma p'uuru Jerusalendeepa perá once kilometros bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma ode wãdade ãchi pedee wã nipajida ma jõma Jesús ome p'asadade. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mãgá pedee wãdade, Jesús cheji ãchi ik'aawa mãik'aapa auk'a t'ɨa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Unu p'anajida mĩda auk'a wãru awaraa eperã ãchi ome, k'awada-e paji k'aita mãga bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mãpai Jesupa iidiji ãramaa: —¿K'ãaredeta parã pedee wãdama? aji. Mãpai ãchi k'ĩra pia-ee bainɨ̃ p'aneejida ");
INSERT INTO sjaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","mãik'aapa ãchidepema Cleofás apatap'edaapa p'anauji: —¿Pɨ Jerusalende badata k'awa-e bɨk'ã aji, mama p'asada? ");
INSERT INTO sjaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mãpai ichia iidiji: —¿K'ãata p'asajima? aji. Ãchia mãgajida: —Jesús Nazaretdepema Ak'õre pedee jarapari paji. Ne-inaa pi-ia oopachi mãik'aapa pedee pia jarateepachi Tachi Ak'õre k'ĩrapite mãik'aapa p'uuru pidaarã k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","P'aareerã poroorãpa mãik'aapa tachi poro waibɨarãpa iru ateejida Romadepema poro waibɨa Pilatomaa kurusode peepit'aamerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Taipa ijãa p'anajida ma Jesupata tachi Israel pidaarã uchiapiit'ee Romadepemaarã juadeepa. Mamĩda ewari õpee paru mãgɨ́ ne-inaa jõma p'asada. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma awara wẽraarã tai ome nipapataarãpa tai p'erapijida. Taujaaweda wãjida Jesús ɨadap'edaamaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mamĩda iru k'ap'ɨa unuda-e pak'ãri, ãpɨtee chejida teedaa mãik'aapa taimaa nepɨrɨjida angeleerã unudap'edaa. Mãɨrãpa jarajidada ajida, Jesús chok'ai bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mãga ũridak'ãri, tai k'õp'ãyoorã ũk'uru wãjida iru ɨadap'edaamaa mãik'aapa ununajida ma wẽraarãpa jaradap'edaak'a. Mamĩda iru unuda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mãpai Jesupa mãgaji: —¡Parã k'ĩsia k'awada-ee p'anɨ! ¿Ijãada-e p'anɨk'ã Ak'õre pedee jarapataarãpa chonaarãweda jaradap'edaa? ");
INSERT INTO sjaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tachi Ak'õrepa pëida mãgá chupɨria nɨ̃bait'ee paji-ek'ã aji, Ak'õrepa iru ateei naaweda ichi truadee? ");
INSERT INTO sjaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mãpai Jesupa jarateemaa beeji ichi p'asait'ee bada Tachi Ak'õre Ũraa p'ãdade jara bɨk'a. Jarateeji Moisepa p'ãdadeepa, Ak'õre pedee jarapataarãpa p'ãdap'edaade jara bɨ parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chi p'uuru wãdap'edaamaa panadak'ãri, Jesús k'ĩra jiwaa wãyaait'ee paji, p'uurude bee-ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mamĩda ãchia mãgajida: —Tai ome béeji k'ewara bairã mãik'aapa p'ãriu wã perã. Mãpai Jesús auk'a teedaa wãji ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","T'ẽepai mesade su-ak'ɨ p'aneedak'ãri nek'odait'ee, Jesupa ichi juade pan ataji. Mãpai ɨt'aa t'ɨ̃ji gracias jarait'ee Tachi Ak'õremaa mãik'aapa t'oop'eda ãramaa teeji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mata Tachi Ak'õrepa aweda ãra tau eratɨk'oopiji mãik'aapa ãramaa Jesús k'awapiji. Mamĩda mamãik'aapa iru wẽpadachi. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mãpai mãgajida: —¿Wãara-ek'ã? ajida. ¡Iru paji! Tachi t'ãripa mãga jara nɨ̃baji, ode Ak'õre Ũraa p'ãda tachimaa jaratee che wã nipak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aramata waya ãpɨtee chejida Jerusalendee. Mama unu chejida iru k'õp'ãyoorã once awaraa nipapatap'edaarã ome see nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mãgɨ́ see nɨ̃badaarãpa mãgajida: —Wãarada ajida, Jesús chok'ai bɨ. Simón Pedromaa ichiaba unupijida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mãpai ãchi omeerãpa nepɨrɨjida ode p'asada mãik'aapa Jesupa pan t'oop'eda, jedek'ãri k'awaadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","At'ãri mãgá nepɨrɨmaa p'anɨde, Jesús ãra esajĩak'a bainɨ̃ ba cheji mãik'aapa mãgaji: —K'ãiwee p'anapatáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jesús unudak'ãri, ãchi p'eradachida, iru jaureta unu p'anɨ jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mamĩda Jesupa mãgaji: —¿Sãap'eda p'era jõnɨma? aji. ¿Sãap'eda pãchi t'ãride at'ãri ijãada-e p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ak'ɨ́tɨ mɨ jua, mɨ bɨɨrɨ ome. Mɨpɨ. Mɨ k'ap'ɨa t'õbáitɨ mãik'aapa ak'ɨ́tɨ. Eperã jaure chiara wẽe bɨ, bɨɨrɨ jida mɨa iru bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mãga jarap'eda, ãramaa ak'ɨpiji ichi jua mãik'aapa ichi bɨɨrɨ. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mamĩda at'ãri pia ijãada-e p'anajida, audú o-ĩa p'anadap'edaa perã mãik'aapa p'era pɨk'a p'anadap'edaa perã. Jesupa ichi k'awapi k'inia bada perã, iidiji: —¿Nama ne-inaa k'oparii iru p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mãpai ãchia chik'o paada esajĩak'a teejida. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Irua jitaji mãik'aapa ãchi taide k'ot'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Maap'eda mãgaji: —Mɨmaa p'asajida aji, mɨa jaradak'a, at'ãri parã ome bak'ãri. Jaraji ne-inaa jõmaweda p'asait'ee paji Moisepa p'ãdade jara bɨk'a mãik'aapa Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaade jara bɨk'a, Salmos libro p'ãdade jara bɨk'a paara. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mãpai jarateeji Tachi Ak'õre Ũraa p'ãdade jara bɨ Mesiade. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mãgaji: —Tachi Ak'õre Ũraa p'ãdade jara bɨ Mesías ichita piut'ee mãik'aapa ewari õpeemaa chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ak'õrepa k'aripap'eda, Jerusalendeepa na p'ek'au eujã eperãarã paraamaa jarateenátɨ p'ek'au k'achia oo amaadamerã mãik'aapa Tachi Ak'õrede ijãapataadamerã. Mãgá irua ãchia p'ek'au k'achia oopata wẽpapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Parãpa mɨ p'asada jõmaweda k'awa p'anɨ, unudap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mapa parãmaa mɨa ne-inaa pëiit'ee mɨ Ak'õrepa jaradak'a. Mamĩda mãga ooru misa, nama p'anéetɨ Jerusalén p'uurude. T'ẽepai ɨt'ariipa Tachi Ak'õrepa ichi jaure pëiit'ee parã ome bapariimerã. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Maap'eda Jesupa ãra ateeji ma p'uurudeepa Betania p'uuru k'ait'a. Mama ichi jua ɨt'aa ɨap'eda, ãra bendiciaji. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mãpai mãgá pedeemaa bɨde Tachi Ak'õrepa iru ɨt'aa ateeji ãra ik'aawaapa. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","T'ẽepai chi k'õp'ãyoorãpa ɨt'aa t'ɨ̃dap'eda, pedee pia jarajida irude mãik'aapa t'ãri o-ĩa ãpɨtee chejida Jerusalendee. ");
INSERT INTO sjaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Maadamãiipa ewari chaa Tachi Ak'õre te waibɨade p'anapachida ɨt'aa t'ɨ̃maa mãik'aapa pedee pia jaramaa Tachi Ak'õremaa.");
INSERT INTO sjaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na p'ek'au eujã bai naaweda Jesucristo, Tachi Ak'õre Pedee apata, bapachi. Mãgɨ́ bapachi Tachi Ak'õre ome. Iru ichita Tachi Ak'õre bapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tachi Ak'õre ome bapachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iru k'ap'ɨa pari Tachi Ak'õrepa ne-inaa jõmaweda ooji. Iru wẽe Tachi Ak'õrepa ne-inaa maarepida oo-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Irua chok'ai bapipachi ne-inaa jõmaweda chok'ai bɨ. Ɨ̃daa pɨk'a bapachi eperãarã t'ãide, ma k'aurepa eperãarãpa Tachi Ak'õre k'awapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","At'ãri irua Tachi Ak'õre k'awapimaa bɨ eperãarãmaa. Apidaapa p'oyaa jarada-e irua mãga oonaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bapachi eperã, t'ɨ̃jarapatap'edaa Juan Bautista. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tachi Ak'õrepa mãgɨ́ eperã jɨrɨt'eraji jaramerã ma ɨ̃daa pɨk'a bɨde, jõmaarãpa Ak'õrede ijãadamerã ma jarateeda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ɨ̃daa pɨk'a ba-e paji. Jĩp'a cheji jarateede ");
INSERT INTO sjaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ma wãara ɨ̃daa pɨk'a bɨ na p'ek'au eujãdee cheji, Tachi Ak'õre eperãarãmaa k'awapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mãgɨ́ Pedee, Jesucristo ba cheji na p'ek'au eujãde, ichia eujã oodade. Mamĩda na p'ek'au eujãdepemaarãpa k'awada-e paji iru Tachi Ak'õre Warra. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cheji mĩda ichi auk'aarã t'ãide, ãchia auteebaida-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mamĩda eperãarã ũk'uruurãpa iru auteebaijida mãik'aapa wãara irude ijãajida. Irua mãgɨɨrã Tachi Ak'õre warrarã papiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tachi Ak'õre warrarã mãgá padait'ee, mãgɨ́ eperãarã t'oda-e paji warra jĩp'aarã t'opatak'a, eperãpa warra oo k'inia ooparik'a. Ma k'ãyaara Tachi Ak'õrépata mãgɨɨrã ichi warrarã papiji, irude ijãa p'aneedap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mãgɨ́ Pedee, Jesucristo Tachi Ak'õrepa pëida. T'oji eperã k'ap'ɨade mãik'aapa tachi t'ãide bapachi. Iru Tachi Ak'õre Warra pada perã, Tachi Ak'õre k'ĩra wãree unupiji tachimaa. Eperãarã k'inia iru bapachi mãik'aapa Tachi Ak'õre wãarata ãchimaa k'awapipachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Bautistapa k'awaji mãgɨ́ Pedee Tachi Ak'õrepa pëida. Mapa jarapachi: —Nãgɨde mɨa jara baji jarak'ãri eperã mɨ t'ẽepai cheru mɨ k'ãyaara waibɨara bɨ, mɨ t'oi naaweda iru bapachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma eperã t'ãri pia bapari tachi jõmaarã ome mãik'aapa tachi ichita k'aripapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tachi Ak'õrepa ichi ũraa k'awapiji eperãarãmaa Moisés k'ap'ɨa pari. Mamĩda eperãarã k'inia iru baji mãik'aapa ichi wãarata k'awapiji ãramaa Jesucristo k'ap'ɨa pari. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Eperã apidaapa Tachi Ak'õre unudak'aa. Mamĩda Jesucristo, iru Warra apai iru bɨ, iru ome auk'a bairã, iru eperãarãmaa k'awapiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judiorã poroorãpa Jerusalendeepa pëijida p'aareerã Leví ëreerãdepemaarã ome, mãɨrãpa Juanmaa iididamerã: —¿Pɨ k'aima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan Bautistapa wãarata p'anauji: —Mɨ Tachi Ak'õrepa pëida-epɨ, eperãarã rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mãpai iidijida: —Mãgara, ¿pɨ Tachi Ak'õre pedee jarapari Eliak'ã? ajida. —Mãga-eda aji. Mamĩda waya iidijida: —¿Pɨ Tachi Ak'õre pedee jaraparik'ã ajida, tachia nɨ p'anɨ? —Mãga-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mãpai mãgajida: —Mãgara, ¿pɨ k'aima? Jarapáde ajida. Tai pëidap'edaarãmaa jaranadait'ee. ¿K'ãata jara pëiit'eema? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanpa p'anauji Tachi Ak'õre pedee jarapari Isaíapa chonaarãweda p'ãdade jara bɨk'a: —Mɨ ni eujã pania wẽe bɨde mãik'aapa bia bɨ: ‘O pi-ia oopatak'a poro waibɨa chei naaweda, mãga pɨk'a p'ek'au k'achia oo amáatɨ Tachi Waibɨa chei naaweda.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma fariseorãpa pëidap'edaarãpa ");
INSERT INTO sjaNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Juanmaa iidijida: —Pɨ Tachi Ak'õrepa pëida-e pɨrã eperãarã rey pamerã, Elia-e pɨrã wa Tachi Ak'õre pedee jarapari-e pɨrã, ¿k'ãare-it'ee eperãarã poro chooparima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanpa mãgaji: —Mɨa parã poro choopari paniapa. Mamĩda pãchi t'ãide bɨda aji, awaraa eperã, parãpa k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mãgɨ́ mɨ t'ẽepai parãmaa jaratee cheru. Iru mɨ k'ãyaara waibɨara bɨ. Mɨa iru chancla jida ẽraik'araa bɨda aji, mɨ iru k'ãyaara ek'ariara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mãga p'asaji Betania p'uurude Jordán to k'ĩraik'a eere, Juanpa poro choomaa badamãi. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Aɨ norema Juanpa unuk'ãri Jesús ichi k'ait'a cheru, mãgaji: —¡Ak'ɨ́tɨ! Nãgɨ́ eperã oveja chak'ek'a bɨ, Tachi Ak'õrepa pëida perã piumerã eperãarã pari. Nãgɨpa wẽpapiit'ee eperãarãpa p'ek'au k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nãgɨ́ eperãde mɨa pedee baji nãga jarak'ãri: “Eperã mɨ t'ẽepai cheru mɨ k'ãyaara waibɨara bɨ, iru mɨ t'oi naaweda bapachi perã.” ");
INSERT INTO sjaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aɨ naaweda mɨa pida k'awa-e baji iru Tachi Ak'õrepa pëida tachi k'aripamerã. Mamĩda ma-it'ee mɨa eperãarã poro choo cheji; mãgá Israel pidaarãpa iru k'awadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mãpai Juanpa jaraji ichia unuda: —Mɨa Tachi Ak'õre Jaure unuji iru ɨ̃rɨ palomak'a baai chek'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɨa k'awa-e bak'aji iru Tachi Ak'õre Warra. Mamĩda aɨ naaweda mɨ pëidapa eperãarã paniapa poro choomerã, mɨmaa jaraji: “Pɨa unuit'eeda aji, mɨ Jaure baai cheru eperã ɨ̃rɨ, ichita iru ome bapariit'ee. Mãgɨ́ eperãpa mɨ Jaure ba chepiit'eeda aji, eperãarã ome.” ");
INSERT INTO sjaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tachi Ak'õrepa jaradak'a mɨa mãga unuji. Maperãpɨ mɨa parãmaa jara bɨ: Nãgɨ́ Jesús, Tachi Ak'õre Warra. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Aɨ norema Juan Bautista waya mama baji chi k'õp'ãyoorã omeerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús wãyaa wã unuk'ãri, mãgaji: —¡Ak'ɨ́tɨ! Jãgɨta chi oveja chak'ek'a bɨ, Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chi k'õp'ãyo omeerãpa mãga ũridak'ãri, Jesús t'ẽe wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús ãpɨtee p'ɨrrabaik'ãri, unuji ichi t'ẽe cheruta mãik'aapa mãgaji: —¿K'ãata k'inia p'anɨma? aji. Mãgajida: —Rabuni (jara k'inia bɨ Tachi Jarateepari), ¿pɨ, sãma baparima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesupa p'anauji: —Chétɨ k'awaadamerã. Mãgá wãjida iru baparimaa mãik'aapa ma ewate p'aneejida iru ome k'ewara las cuatro pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","K'õp'ãyo abaapa Juan pedee ũrida mãik'aapa Jesús t'ẽe wãda Andrés paji. Iru Simón Pedro ɨ̃pema paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mãgɨ́ Jesús ome bap'eda, ne-inaa awaraa ooi naaweda, isapai wãji chi ɨ̃pema jɨrɨde. Unu atak'ãri, mãgaji: —Mesías unujidada aji. (Mãgɨ́ t'ɨ̃ jara k'inia bɨ Cristo, Tachi Ak'õrepa pëida eperãarã rey pamerã.) ");
INSERT INTO sjaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mãpai Andrepa chi ɨ̃pema aneeji Jesumaa. Jesupa iru unuk'ãri, mãgaji: —Pɨ Simón, Juan warra. Mamĩda pɨ t'ɨ̃jaradait'eeda aji, Cefas. (Mãgɨ́ t'ɨ̃ griego pedeede jara k'inia bɨ Pedro.) ");
INSERT INTO sjaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aɨ norema Jesús wãji Galilea eujãdee. Mama unuji eperã t'ɨ̃jarapatap'edaa Felipe. Mãpai mãgaji: —Mɨ ome nipaparíiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Mãgɨ́ Felipe, Andrés mãik'aapa Pedro Betsaida p'uurudepemaarã paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipepa Natanael jɨrɨnaji mãik'aapa unu atak'ãri, mãgaji: —Unujidada aji, eperã Moisepa jarada Tachi Ak'õre Ũraa p'ãdade. Mãgɨ́ ichiaba Tachi Ak'õre pedee jarapataarãpa chonaarãweda ãchi p'ãdap'edaade jaradap'edaa. Mãgɨ́ eperã José warra; t'ɨ̃jarapata Jesús Nazaretdepema. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelpa mãgaji: —¡Nazaretdepema! ¿Nazaret p'uurudeepa eperã pia uchiaik'ã? aji. Felipepa mãgaji: —Wãdáma aji, ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesupa Natanael ichi k'ait'a cheru unuk'ãri, mãgaji: —Na Israel pida wãara t'ãri pia bapari. Apida k'ũrak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelpa Jesumaa iidiji: —¿Sãga pɨa mɨ k'awa bɨma? aji. Jesupa p'anauji: —Felipepa pɨ atanai naaweda, mɨa pɨ unuji higuera k'arra ek'ari. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mãpai Natanaelpa mãgaji: —Tachi Jarateepari, pɨ Tachi Ak'õre Warra. Pɨ Israel pidaarã Rey, chi cheit'ee bada. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesupa mãgaji: —¿Ijãa bɨ-ek'ã aji, mɨa jarada perã pɨ unuji ma pak'uru ek'ari? Pɨa unuit'ee ne-inaa awara ma k'ãyaara pi-iara. ");
INSERT INTO sjaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mɨa wãarata jararu. Parãpa unudait'ee Tachi Ak'õre eujã ewaraa k'obɨ mãik'aapa angeleerã ɨt'aa wãruta mãik'aapa edaa cheruta mɨ, chi Eperã Ak'õre Truadepema, k'aripade. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Natanael ome pedeep'eda, k'ãima õpeemaa miak'ãipata fiesta oojida Caná p'uurude. Mãgɨ́ p'uuru Galilea eujãde bɨ. Jesús nawe mama baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús chi k'õp'ãyoorã ome ichiaba t'ɨ̃ pëijida chedamerã ma fiestade. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mama p'anɨde vino jõdachi. Maperã Jesús nawepa mãgaji: —Vino jõdachida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mãpai Jesupa mãgaji: —Nawe, ¿sãap'eda pɨa mɨmaa mãga jara bɨma? aji. Waide ewari pa-eeta mɨa Ak'õre jua ak'ɨpimerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mãpai chi nawepa mãgaji vino jedepataarãmaa: —Óotɨ jõma irua jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mama bainɨ̃ p'anajida chok'o seis, mãudee ooda. Judiorãpa mãgee chok'o iru p'anapachida aɨde pania t'ɨdait'ee. Mãgá sɨɨdai ãchi jua, bɨɨrɨ maa-e pɨrã net'aa Tachi Ak'õre Ũraa p'ãdade jaradak'a. Chok'o abaade cincuenta wa setenta litros araapachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesupa vino jedepataarãmaa mãgaji: —Paniapa na chok'o ipuruk'óotɨ. Pania atanajida mãik'aapa ma chok'o ipuruk'oojida. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mãpai Jesupa mãgaji: —Ɨ̃rá ma-ãri joi atadapáde aji, mãik'aapa teepáde aji, na fiesta chiparimaa. Mãga oojida. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma fiesta chiparipa pania vino padai bada tok'ãri, k'awa-e paji sãmãik'aapa uchiaji ma vino. Ma vino jedepataarãpapai k'awajida, ãchia ma vino chok'odeepa joidap'edaa perã. Mãgá top'eda, ma fiesta chiparipa chi ɨmɨk'ĩra miak'ãiit'ee bada t'ɨ̃ ataji ");
INSERT INTO sjaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mãik'aapa mãgaji: —Fiesta oodak'ãri, jõmaarãpa naapɨara vino piara bɨta jedepata. Maap'eda, waibɨa to p'anadap'eda, jedepata chi vino mak'ɨara pia-e bɨ. Mamĩda pɨa ɨa nɨ̃bɨjida aji, chi vino piara bɨta ɨ̃raweda todamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mãgɨ́ ooda Jesupa Galilea eujãdepema Caná p'uurude paji irua naapɨara ooda eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mãga ook'ãri, unupiji ichi wãara Tachi Ak'õrepa pëida. Ma ooda unudak'ãri, chi k'õp'ãyoorãpa audupɨara irude ijãa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma t'ẽepai Jesús wãji Capernaum p'uurudee chi nawe ome, chi ɨ̃pemaarã ome mãik'aapa chi k'õp'ãyoorã ome. K'ãima chok'ara-ee mama p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judiorã Pascua fiesta ɨ̃rɨ pa wãda perã, Jesús wãji Jerusalendee. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mama Tachi Ak'õre te waibɨa ãuk'idaa t'ɨak'au bɨde ununaji p'ak'a netopataarã, oveja netopataarã mãik'aapa paloma netopataarã. Ichiaba unuji p'arat'a tau t'erabaipataarã mama su-ak'ɨ p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mãga unuk'ãri, Jesupa soo oo ataji mãik'aapa ma jõmaweda taawaa jërek'ooji ãchi p'ak'a, oveja ome. Ma p'arat'a tau t'erabaipataarã mesa eujãde sĩa bat'ak'oop'eda, ãchi p'arat'a eujãde p'ok'ooji ");
INSERT INTO sjaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","mãik'aapa paloma netopataarãmaa mãgaji: —¡Pãchi net'aa atéetɨ namãik'aapa! ¡Mɨ Ak'õre te net'aa netopata tek'a papináatɨ! ");
INSERT INTO sjaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesupa mãga oo bɨde chi k'õp'ãyoorãpa k'irãpajida Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Mɨa pɨ te k'inia iru bapari perã, mɨ peet'aadait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mãpai judiorã poroorã, arii p'anadap'edaarãpa mãgajida Jesumaa: —Wãara Tachi Ak'õrepa nãga oopiru pɨrã pɨmaa, ¿k'ãata ooit'eema ajida, taipa ijãadamerã wãara Ak'õrepa pɨ pëida? ");
INSERT INTO sjaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesupa p'anauji: —Na te t'eet'aaruta pɨrã, ewari õpeemaa mɨa waya baik'o bɨit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mãpai judiorãpa mãgajida: —Cuarenta y seis años mimiajidada ajida, na te oodait'ee. ¿T'eep'eda pɨa ewari õpeede baik'o bɨit'eek'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mamĩda Jesupa “na te” ak'ãri, jara k'inia baji ichi k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mapa aɨ t'ẽepai, iru piup'eda, chok'ai p'irabaik'ãri, chi k'õp'ãyoorãpa k'irãpajida irua ma ewate jarada. Mãpai wãara ijãajida Tachi Ak'õre Ũraa p'ãdade jarada mãik'aapa Jesupa jarada. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalende bɨde Pascua fiesta wãyaaru misa, eperãarã chok'araarãpa irude ijãajida, unudak'ãri irua ne-inaa oomaa bɨ eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mamĩda Jesupa k'awaji wãara ijãada-e p'anajida, ãchi t'ãri pia k'awada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Faltak'aa paji apidaapa eperãarã k'ĩsia k'awaapidamerã irumaa, irua eperãarã t'ãri k'awa bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bapachi fariseo t'ɨ̃jarapatap'edaa Nicodemo. Judiorã poro waibɨarãdepema paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","P'ãrik'ua mãgɨ́ eperã Jesumaa p'asiade wãji mãik'aapa mãgaji: —Tachi Jarateepari, k'awa p'anɨda aji, Tachi Ak'õrépata pɨ pëida taimaa jarateede. Pɨa p'oyaa oo-e pak'ajida aji, nãgee ne-inaa pia pɨa ooparik'a, Tachi Ak'õre pɨ ome ba-e pada paara. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesupa mãgaji: —Mɨa wãarata jararu. Eperã waya t'o-e pɨrã, p'oyaa ba-e pai Tachi Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mãpai Nicodemopa iidiji: —Mamĩda ¿sãga waya t'oyama aji, eperã chona bɨta? ¡P'oyaa t'ĩuk'aa chi nawe bide waya t'oit'ee! ");
INSERT INTO sjaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesupa p'anauji: —Mɨa wãarata jararu. Eperã paniapa t'o-e pɨrã mãik'aapa Tachi Ak'õre Jaurepa t'opi-e pɨrã, p'oyaa ba-e pai Ak'õre jua ek'ari ichideerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Eperãdeepa uchiapari eperã. Mamĩda Tachi Ak'õre Jauredeepa uchiapari Tachi Ak'õredeerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","P'era pɨk'a banáaji mɨa jarada perã eperãarã waya t'odaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nãu p'uapari chi p'ua k'iniamaa. Pɨa ma nãu ũriru mĩda, k'awak'aa sãmãik'aapa cheru wa sãmaa wã. Mãga pɨk'a bɨ ichiaba eperã Tachi Ak'õre Jaurepa t'opida. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mãpai Nicodemopa waya iidiji: —Mamĩda ¿sãga mãga payama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesupa p'anauji: —Pɨ Israeldeepa uchiadap'edaarã jarateepari. ¿K'awa-e bɨk'ã aji, mɨa jara bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mɨa wãarata jararu. Taipa jarapata ne-inaa k'awa p'anɨ mãik'aapa unudap'edaa. Mamĩda parãpa ijãadak'aa taipa jarapata. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Parãpa ijãada-e p'anɨ pɨrã mɨa na eujãdepema ne-inaa jarak'ãri, ¿sãga ijãadayama aji, mɨa ɨt'aripema ne-inaa jarak'ãri? ");
INSERT INTO sjaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Apida Ak'õre eujãdee wãda-e p'anɨ. Jõdee aba, chi Eperã Ak'õre Truadepema, Ak'õre eujãdeepa cheji. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés eujã pania wẽe bɨde Israel pidaarã ome nipak'ãri, taama broncedee ooda pak'urude jiraji eperãarãpa mãgɨ́ ak'ɨdamerã. Mãgá piuda-e paji. Mãga pɨk'a ichiaba chi Eperã Ak'õre Truadepema pak'urude ichita jiradait'ee ");
INSERT INTO sjaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","eperãarãpa iru ak'ɨdamerã. Mãgá jõmaarãpa irude ijãapata ichita iru ome ɨt'ari p'anapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Tachi Ak'õrepa na p'ek'au eujãdepemaarã audú k'inia iru bada perã, ichi warra apai iru bada pëiji piumerã eperãarã pari. Eperãpa iru Warrade ijãa bɨ pɨrã, atua-e. Jai-idaak'ãri, Ak'õre eujãde banait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tachi Ak'õrepa ichi Warra pëi-e paji na p'ek'au eujãdepemaarã atuapiit'ee. Jĩp'a pëiji eperãarã o k'achiade wãdap'edaadeepa k'aripa atade atuanaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Mapa Tachi Ak'õrepa atuapi-e ichi Warrade ijãa bɨ. Mamĩda atuapiit'ee chi ijãa-ee bɨ, mãgɨpa ijãak'aa perã Tachi Ak'õre Warra apai iru badade. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chi ɨ̃daa pɨk'a bɨ cheji na p'ek'au eujãdee. Mamĩda eperãarã ũk'uruurãpa ma ɨ̃daa pɨk'a bɨ k'iniadak'aa paji, p'ãriu pɨk'a bɨde p'anee k'inia p'anadap'edaa perã ne-inaa k'achia oodait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chi k'achia ooyaa beerãpa ma ɨ̃daa pɨk'a bɨ unuamaa iru p'anapata. Iru k'awa k'iniadak'aa. Mãga p'anɨ k'iniadak'aa perã irua unupimerã ãchia ne-inaa k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jõdee chi oopataarãpa Tachi Ak'õrepa wãarata jara pëidak'a, ma ɨ̃daa pɨk'a bɨ k'awa k'inia p'anapata. Mãga p'anapata jõmaarãmaa k'awapi k'inia p'anadairã ãchia ne-inaa pia oo p'anɨ Tachi Ak'õrepa oopiparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma t'ẽepai, Jesús chi k'õp'ãyoorã ome wãjida Judea eujãdee. Mama taarãji ãchi ome, ãchia eperãarã poro choodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanpa ichiaba eperãarã poro choomaa baji Enonde, Salim k'ait'a, mama paniara paraada perã. Mama eperãarã chepachida poro choopidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Mãga paji Herodepa Juan carcelde t'ɨpit'aai naaweda.) ");
INSERT INTO sjaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ewari aba Juan k'õp'ãyoorã aupedeemaa p'aneejida awaraa judío ome, eperãarã poro choopata k'ap'ɨa. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juanmaa chejida mãik'aapa mãgajida: —Tachi Jarateepari, ma eperã pɨ ome bada Jordán to k'ĩraik'a eere mãik'aapa pɨa jarada taimaa, mãgɨpa eperãarã poro choomaa bɨda ajida. Ma awara jõmaarãta irumaa wã p'anɨ poro choopide. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mãpai Juanpa p'anauji: —Apidaapa mãgee ne-inaa ooda-e pak'ajida aji, Tachi Ak'õrepa oopi-e pada paara. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pãchia pia ũrijida mɨa jarak'ãri mɨ Tachi Ak'õrepa pëida-e eperãarã rey pamerã. Iru pëi naaweda, Tachi Ak'õrepa mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","K'ĩsiadáma nãgɨde. Miak'ãidak'ãri, wẽra chi ɨmɨk'ĩra wẽra paru. Mamĩda ma ɨmɨk'ĩra k'õp'ãyo k'ait'a bainɨ̃ beepari mãik'aapa o-ĩadaipari ũrik'ãri ma ɨmɨk'ĩrapa jararu chi wẽramaa. Mãga pɨk'a mɨ ma poro choomaa bɨ k'õp'ãyok'a bɨ. Maperãpɨ mɨ o-ĩa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iru mɨ k'ãyaara waibɨara pait'ee eperãarã k'ĩrapite. Jõdee mɨ iru ek'ariara pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Eperã ɨt'ariipa cheda jõmaarã k'ãyaara waibɨara bɨ. Eperã na p'ek'au eujãdepema na eujãde bapari perã, ichita jarapari na eujãdepema ne-inaa. Jõdee chi ɨt'ariipa cheda jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Irua jarapari ichia unuda mãik'aapa ũrida ɨt'ari, apidaapa ijãa k'iniada-e p'anɨ pɨjida irua jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mamĩda eperãpa irua jara bɨ ijãak'ãri, k'awa bɨ Tachi Ak'õrepa ichita wãarata jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tachi Ak'õrepa pëidapa jarapari Tachi Ak'õre pedee, Ak'õrepa ichi Jaure pëipari perã iru ome bapariimerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tachi Ak'õrepa ichi Warra k'inia iru bapari. Ne-inaa jõmaweda iru jua ek'ari bɨji irua ak'ɨmerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Eperãpa iru Warrade wãara ijãak'ãri, ichita bapariit'ee Tachi Ak'õre ome. Mamĩda eperãpa iru Warrade ijãa k'inia-e bɨ pɨrã, Ak'õre trua unu-e pait'ee. Tachi Ak'õre ichita k'ĩrau bait'eeda aji, mãgɨ́ eperã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseorãpa ũrijida Jesupa Juan k'ãyaara k'õp'ãyoorãra p'e wã mãik'aapa eperãarã chok'araara poro choopachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mãga ũrijida Jesupa poro chook'aa paji mĩda. Chi k'õp'ãyoorã́pata poro choopachida.) ");
INSERT INTO sjaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesupa mãga k'awaa atak'ãri, waya uchiaji Judea eujãdeepa Galilea eujãdee wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma wãdade wãyaaji Samaria eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mãgá Jesús pacheji Sicar p'uurude. Mãgɨ́ p'uuru Samaria eujãde bɨ. Chonaarãweda ma p'uuru Jacobpa ichi warra Josemaa eujã teeda k'ait'a baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma eujãde Jacob pozo baji. Ma che wãdade ode cherupa Jesús ĩyapaa cheda perã, ma pozo ik'aawa su-ak'ɨ beeji. Imat'ɨpa pa wã nipaji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Chi k'õp'ãyoorã p'uurudee wã p'anajida chik'o netode.) Mãga nɨde Samariadepema wẽra cheji ma pozodee pania joide. Mãpai Jesupa mãgaji irumaa: —Mɨmaa pania teepáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mamĩda judiorã, Samariadepemaarã ome pedeedak'aa pada perã, mãgɨ́ wẽrapa mãgaji: —Mɨ Samaria eujãdepemapɨ. ¿Sãap'eda pɨ, judío bɨta mɨmaa pania iidi cheruma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesupa p'anauji: —Pɨa k'awada paara jõma Tachi Ak'õrepa oo k'inia bɨ eperãarã k'aripait'ee mãik'aapa k'awada paara k'aipata pɨmaa pania iidimaa bɨ, mɨmaa iidik'aji teemerã pania eperãarã ichita chok'ai p'anapipari. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mãpai mãgɨ́ wẽrapa mãgaji: —Señor, na pozo nãpɨa bɨda aji. Pɨa ne-inaa wẽe bɨ pania joi atait'ee. ¿Sãma mãgee pania atayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Na pozo tachi chonaarãwedapema Jacobpa bëida. Irua na pozodepemata pania topachi, ichi warrarã ome mãik'aapa chi ne-animalaarã ome. ¿Pɨ iru k'ãyaara waibɨara k'ĩsia bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesupa p'anauji: —Eperãarãpa na pozodepema pania toruta waya opisiadaridait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mamĩda mɨa pania teerudepema todak'ãri, waa opisiada-e pait'ee. Ma k'ãyaara ara pania poatrɨ uchiaparik'a eujãdeepa, mãga pɨk'a mɨa pania teeru uchiait'ee ãra t'ãrideepa mãik'aapa ma k'aurepa k'awaadait'ee ichita p'anapataadait'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mãpai mãgɨ́ wẽrapa mãgaji: —Señor, mɨ-it'ee teepáde aji, mãgɨ́ pania, mɨ waa opisia-e pait'ee, ichiaba waa che-e pait'ee pania joide na pozode. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesupa p'anauji: —Wãpáde aji, pɨchi ɨmɨk'ĩra atade mãik'aapa waya namaa chepáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mãgɨ́ wẽrapa p'anauji: —Mɨ ɨmɨk'ĩra wẽe bɨda aji. Jesupa mãgaji: —Wãarata jaraji ɨmɨk'ĩra wẽe bɨda ak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ɨmɨk'ĩraarã joisomaa iru badoo mãik'aapa chi ɨ̃rá iru bɨ përe-e. Mapa wãarada aji, pɨa jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mãga ũrik'ãri, ma wẽrapa mãgaji: —Señor, pɨa pedee jarada k'aurepa mɨa k'awaa wãda aji, pɨ Tachi Ak'õre pedee jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tai chonaarã nãgɨ́ eede ɨt'aa t'ɨ̃pachidada aji. Mamĩda parã judiorãpa jarapata Jerusalende eperãarãpa ɨt'aa t'ɨ̃pataadaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mãpai Jesupa mãgaji: —Wẽra, mɨa jararu ijã́aji. Ewari paruda aji, parãpa wãara ɨt'aa t'ɨ̃pataadait'ee Tachi Ak'õremaa. Mamĩda mãga ooda-e pait'ee nãgɨ́ eede wa Jerusalende. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Parãpa ɨt'aa t'ɨ̃pata Tachi Ak'õremaa. Mamĩda iru pia k'awada-e p'anɨ. Jõdee táipata iru pia k'awa p'anɨ, tai judiorã k'ap'ɨa pari irua jara pëida perã sãga eperãarã o k'achiadeepa k'aripa atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mamĩda ewari pait'ee mãik'aapa ɨ̃raweda paru wãarata ɨt'aa t'ɨ̃pataarã Tachi Ak'õremaa ɨt'aa t'ɨ̃pataadait'ee iru Jaure k'ap'ɨa pari, Tachi Ak'õre wãara k'awapata perã. Tachi Ak'õrepa mãgeerã jɨrɨpari mãgá ichimaa ɨt'aa t'ɨ̃pataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tachi Ak'õreta, Jaure. P'aareerã irumaa ɨt'aa t'ɨ̃pataadaipia bɨda aji, iru Jaure k'ap'ɨa pari, iru wãarata k'awapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mãpai mãgɨ́ wẽrapa mãgaji: —Mɨa k'awa bɨ Mesías (ichiaba t'ɨ̃jarapata Cristo) cheit'eeda aji. Iru chek'ãri, tachimaa ne-inaa jõmaata jarateeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesupa mãgaji: —Mãgɨ́ mɨda aji, pɨ ome pedeemaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mãgá pedeemaa bɨde chi k'õp'ãyoorã pachejida. Ãchi t'ãridepai k'ĩsiajida: “¿Sãap'eda Jesús pedeemaa bɨ jã wẽra ome?” Mamĩda apidaapa iidida-e paji ma wẽrapa k'ãata k'inia baji, maa-e pɨrã k'ãare-it'ee iru pedeemaa baji ma wẽra ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mãpai mãgɨ́ wẽrapa ichi chok'o atabëip'eda, wãji p'uurudee mãik'aapa jaranaji eperãarãmaa: ");
INSERT INTO sjaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Ak'ɨ chétɨ! Eperãpa mɨmaa nepɨrɨji ne-inaa jõma mɨa oopari. ¿Mãgɨ́ Mesia-epaama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mãpai eperãarã wãjida Jesumaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mãgá cherutade, Jesús k'õp'ãyoorãpa enenee jõnajida nek'omerã: —Tachi Jarateepari, nek'óji, ma-ãri pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mamĩda irua mãgaji: —Parãpa k'awada-e p'anɨda aji, chik'o mɨa iru bɨ k'oit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chi k'õp'ãyoorã ãchi pitapai pedeepachida: —¿Apidaapa chik'o aneejida-epaama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mamĩda Jesupa mãgaji: —Mɨ-it'ee chik'o nãga pɨk'a bɨ: ooit'ee mɨ pëidapa k'inia bɨk'a mãik'aapa aupait'ee mimia irua k'ĩsia iru bɨ mɨ-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Parãpa jarapata-ek'ã? “Atane k'ĩmari falta bɨ ne-uuda ewadait'ee.” ¡Ak'ɨ́tɨ parã ik'aawa! Unudait'ee ne-uuda chiwari nɨ̃bɨ. Mapa ewadaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ne-uuda ewaparipa ma ne-uuda ewak'ãri, o-ĩadaipari p'arat'a jitait'ee perã ichi mimia pari. Mãga pɨk'a mɨ, Tachi Ak'õre Ũraa jarateepari, o-ĩadaipari parãpa eperãarã p'e atadak'ãri mɨde ijãapataadamerã, ma k'aurepa ichita p'anapataadait'ee perã Tachi Ak'õre ome. Maperã chi ne-uupari chi ne-uu ewapari ome o-ĩa para beepari. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nãgɨ́ pedee eperãarãpa jarapata wãara bɨ. “Abaapa uupari mãik'aapa awaraapa ewapari.” ");
INSERT INTO sjaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mɨa parã pëiji ne-uu ewanadamerã, parãpa uuda-e paji mĩda. Awaraarã parã naa mimiajida eperãarãpa mɨde ijãadamerã. Maap'eda parãpa ãra mimia aupajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariadepemaarã chok'ara Jesude ijãajida mãgɨ́ Samariadepema wẽrapa jarada perã: —Jõma mɨa ne-inaa ooda jarajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Maperãpɨ ma Samariadepemaarã Jesumãi pachedak'ãri, chupɨria iidijida iru ãchi ome beemerã. Mapa iru mama beeji k'ãima omé. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mama bɨde chok'araarãpa irua jarateeda ũridak'ãri, ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mãpai mãɨrãpa mãgɨ́ Samariadepema wẽramaa mãgajida: —Ɨ̃rapɨ ijãada-eda ajida, pɨa taimaa nepɨrɨda k'aurepapai. Ichiaba ijãapata irua jarateeda ũridap'edaa perã. Maperãpɨ k'awa p'anɨ wãara nãgɨ́ eperã cheji na p'ek'au eujãdepemaarã o k'achiadeepa k'aripa atade. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","K'ãima omé wãyaap'eda, Jesús uchiaji Samaria eujãdeepa mãik'aapa wãji Galilea eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ichi ome nipapatap'edaarãpa k'ĩsiajida mãpemaarãpa ãchi auteebaida-e pai, ichia jarada perã Tachi Ak'õre pedee jarapari p'uurudepemaarãpa iru waaweedak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mamĩda Galileade panadak'ãri, ma eujãdepemaarãpa iru auteebaijida. Mãɨrãpa irua ooda Jerusalende unujida, mama p'anadap'edaa perã Pascua fiesta oodait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús waya cheji Caná p'uurudee, ichia pania vino papidamãi. Maapai Capernaum p'uurude bapachi rey mimiapataarã poro waibɨa. Mãgɨ́ warra k'ayaa baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mãgɨpa k'awaa atak'ãri Jesús cheda Judea eujãdeepa Galileadee, wãji iru ak'ɨde mãik'aapa chupɨria iidiji wãmerã ichi temaa ichi warra jɨpade, chi warra juak'aya bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mãga ũrik'ãri, Jesupa mãgaji: —Parãpa unuda-e pɨrã mɨa ooru ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa, mɨde ijãadak'aa pait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mamĩda mãgɨ́ poro waibɨapa mãgaji: —Tachi Waibɨa, chepáde aji, mɨ warra jai-idaai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mãpai Jesupa mãgaji: —Wãpáde aji, pɨchi temaa. Pɨ warra jɨpa beeit'eeda aji. Ma eperãpa Jesupa jarada ijãaji mãik'aapa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ichi temaa wãrude, ichi mimiapataarãpa unu chejida mãik'aapa mãgajida: —Pɨ warra jɨpa beejida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ichia iidik'ãri chisãgɨ́ horade jɨpa beeji, p'anaujida: —Nuweda la una k'ɨamia tuu beejida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chi ak'õrepa k'awaji mãgɨ́ hora paji Jesupa jarak'ãri: “Pɨ warra jɨpa beeit'ee.” Mapa ichia mãik'aapa ichi te pidaarãpa Jesude ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma cheda omeede Judea eujãdeepa Galilea eujãdee, Jesupa ichiaba ooji ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma t'ẽepai Jesús cheji Jerusalendee judiorã fiesta oode. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén p'uuru murallade t'ĩupata aba Ovejaarã T'ĩupata apachida. Mãgɨ́ k'ait'a baji eperãarã k'uipatamãi, hebreo pedeede t'ɨ̃jarapata Betzatá. Mãgɨ́ pozo wap'ɨra baji joisomaa tarimbak'a bɨpa. Mãgɨ́ wãk'a beeji te k'irupa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mama eujãde k'ayaa beerã chok'ara p'aneepachida: tau p'ãriu beerã, nɨk'anɨk'aa t'ɨa beerã mãik'aapa chiwa beerã. Nɨpachida pania p'ërebai jira beerumaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mãga oopachida edaare angelpa pania p'ërebai jira beepik'ãri, chi naa t'ĩuru aɨde jɨpa beepachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mama baji eperã treinta y ocho años k'ayaa bada. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesupa iru mama jẽra bɨ unuk'ãri mãik'aapa k'awaa atak'ãri taarã weda ichi mãgá che bapachi, irumaa iidiji: —¿Jɨpa bee k'inia bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chi k'ayaa bɨpa p'anauji: —Eperã wẽ-eda aji, mɨ toida ata bɨmerã jã pozode pania p'ërebai jira beek'ãri. Mɨ t'ĩudariit'ee pak'ãri, awaraata mɨ naa t'ĩudaiparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mãpai Jesupa mãgaji: —¡P'irabáiji! Pɨchi p'aru atáji mãik'aapa wã́ji pɨchi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aramata ma eperã jɨpa beeji. Bainɨ̃ beep'eda mãik'aapa ichi p'aru atap'eda, t'ɨa wãji. Mamĩda ɨ̃ipata ewate pada perã, ");
INSERT INTO sjaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","arii p'anadap'edaa judiorã poro waibɨarãpa chi jɨpa beedamaa mãgajida: —Idi tachi ɨ̃ipata ewate. Tachi Ak'õre Ũraa p'ãdade jara bɨ ɨ̃ipata ewate mimia oodaik'araa bɨ. Jã p'aru pɨa ateeik'araa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mãpai mãgɨ́ eperãpa p'anauji: —Mɨ jɨpadapa jarajida aji: “Pɨchi p'aru atáji mãik'aapa wã́ji.” ");
INSERT INTO sjaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ãchia iidijida: —¿K'aipata pɨmaa mãga jarajima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mamĩda ma k'ayaa badapa k'awa-e paji k'aipata ichi jɨpat'aada, Jesús tau atuat'aada perã t'ĩuk'ãri eperãarã chok'ara see nɨ̃bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma t'ẽepai, Tachi Ak'õre te waibɨade Jesupa ma eperã unuk'ãri, irumaa mãgaji: —¡Ũríji! Ɨ̃rá pɨ jɨpa bɨda aji. P'ek'au k'achia oo amáaji ne-inaa k'achiara p'asanaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Maap'eda mãgɨ́ eperãpa judiorã poroorãmaa nepɨrɨnaji Jesupa ichi jɨpada. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɨ̃ipata ewate Jesupa mãgá jɨpapachi perã, judiorã poro waibɨarãpa iru jɨrɨpachida peedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mamĩda Jesupa p'anaupachi ichi ɨmɨatee p'anadap'edaarãmaa: —Mɨ Ak'õre ichita mimiapari mãik'aapa ɨ̃raweda mimiamaa bɨ. Mɨ jida mãgá mimiaparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mãga ũridak'ãri, ma judiorãpa audupɨara peet'aa k'inia p'anapachida, ɨ̃ipata ewate mimiapachi perã mãik'aapa Tachi Ak'õre ome auk'a bɨda ada perã. Mãga jaraji Tachi Ak'õre ichi Ak'õreda ak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ãchia ɨmɨateeda ũrik'ãri, Jesupa mãgaji: —Mɨa wãarata jararu. Tachi Ak'õre Warrapa ne-inaa p'oyaa oo-eda aji, ichi k'ĩradoopa. Ma k'ãyaara irua unupari chi Ak'õrepa oo bɨ mãik'aapa auk'a oopari. Jõmaweda chi Ak'õrepa oo bɨ ichiaba oopari chi Warrapa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mãga bɨ chi Ak'õrepa ichi Warra k'inia iru bapari perã. Mapa jõma ichia oo bɨ ak'ɨpipari chi Warramaa. Wãara na ewari ne-inaa pi-iara ak'ɨpiit'ee chi warramaa. Mãga unudak'ãri, parã p'era pɨk'a para beeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chi Ak'õrepa piu beerã p'irabaipiparik'a ichita chok'ai p'anapataadamerã, chi Warrapa auk'a ichia k'inia bɨɨrã p'irabaipiparida aji, ichita chok'ai p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chi Ak'õrepa jara-e chisãgɨ́ na p'ek'au eujãdepemaarã ichita chok'ai p'anapataadait'ee mãik'aapa chisãgɨ́ atuadait'ee. Ma-it'ee chi Warra pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","K'inia baji jõmaarãpa ichi Warra waaweedamerã iru waaweepatak'a. Eperã iru Warra waawee-ee bɨpa ichiaba waawee-e Tachi Ak'õre, chi Warra pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Mɨa wãarata jararu. Tachi Ak'õre Waibɨapa mɨ pëiji. Mɨ pedee ũri bɨpa mãik'aapa irude ijãa bɨpa ɨt'aa wãit'eeda aji. Mãgɨ́ eperã atua-e pait'ee. Irua ijãadak'ãriipa ichita bapariit'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mɨa wãarata jararu. Ewari pait'ee mãik'aapa ɨ̃raweda paru piu pɨk'a beerãpa ũridait'ee Tachi Ak'õre Warra pedee. Chi ma pedee ijãarutaarã ichita p'anapataadait'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tachi Ak'õrepa eperãarã ichita chok'ai p'anapiparik'a, ichi Warra bɨji auk'a oomerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma awara ichi Warra bɨji ichik'a jõmaarã k'ãyaara waibɨara bamerã. Mãgá irua jarai chisãgɨ́ eperãarã ichita chok'ai p'anapataadait'ee mãik'aapa chisãgɨ́ atuadait'ee. Tachi Ak'õrepa iru mãga bɨji iru Eperã Ak'õre Truadepema perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","P'era pɨk'a p'ananáatɨ mɨa jararu ũridak'ãri. Ewari cherude jõmaweda jãɨrade p'anɨɨrãpa mɨ pedee ũridait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chok'ai p'irabaidait'ee mãik'aapa jãɨradeepa uchiadait'ee. Ne-inaa pia oopatap'edaarã ichita p'anapataadait'ee Tachi Ak'õre ome. Mamĩda chi ne-inaa k'achia oopatap'edaarã atuadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Mɨa ne-inaa p'oyaa oo-eda aji, mɨchi k'ĩradoopa. Mɨa ũripari mɨ Ak'õrepa jara bɨ mãik'aapa irua jara bɨk'a oopari. Mapa mɨa eperãarãpa oopata ak'ɨpari jarait'ee pia wa k'achia. Mɨa mãga jarak'ãri, wãarata jarapari, mɨchia oo k'iniata oo k'iniak'aa perã. Jĩp'a oo k'inia bɨ mɨ pëidapa k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mɨchi k'ĩsiadoopapai na pedee jarada paara, mãgara eperãarãpa wãarata jara-e bɨda ak'ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mamĩda awaraapa jara bɨ mɨ ichi Warra. Mɨa k'awa bɨ irua ichita wãarata jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Parãpa eperãarã pëidak'ãri Juan Bautistamaa iidide, irua p'anauda wãarata paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɨa p'ua-e bɨda aji, eperãpa jarada. Mamĩda mãga jaraji parãpa k'irãpadamerã Juanpa jarada mãik'aapa mɨde ijãadamerã. Mãgá mɨa parã o k'achiadeepa k'aripa atai. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan urua pɨk'a bapachi lamparak'a na p'ek'au eujã p'ãriu pɨk'a bɨde. Maapai parã o-ĩa p'anapachida iru ome ma urua pɨk'a bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mamĩda ne-inaa piara paraa Juanpa jarada k'ãyaara. Mɨa ne-inaa jõma oopari mɨ Ak'õrepa k'ĩsia iru bɨk'a. Mãga ook'ãri, ak'ɨpipari wãara irua mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Irua pida ak'ɨpidoo mɨ pëiji, parãpa jara p'anɨ mĩda waide iru pedee ũridak'aa mãik'aapa iru k'ĩra unudak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma awara parãpa ak'ɨpipata iru pedee jara pëida wãara ijãadak'aa, irua pëidade ijãada-e p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Parãpa Tachi Ak'õre Ũraa p'ãda pi-ia ak'ɨpata, ijãapata perã ma k'aurepa ɨt'aa wãdait'ee. Mãgɨ́ ũraade mɨdeta jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mamĩda parãpa mɨde ijãa k'iniada-e p'anɨ, mɨa parã ɨt'aa wãpimerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mɨa mãga jara-e paji k'inia bairã eperãarãpa mɨ ak'ɨdamerã eperã t'ãri piak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma awara mɨa parã k'awa bɨda aji. Wãara Tachi Ak'õre k'inia iru p'anada-e. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mɨ chejida aji, mɨ Ak'õre pari. Mamĩda parãpa mɨ auteebaida-e paji. Jõdee awaraa eperã ichi k'inia cheru pɨrã, mata parãpa auteebaipata. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Sãga mɨde ijãadayama? aji. Jɨrɨpata eperãarãpa parã ak'ɨdamerã judiorã pia beerãk'a, jɨrɨdai k'ãyaara Tachi Ak'õrepa parã ak'ɨmerã ichideerãk'a. ¡Iru aupaita Ak'õre Waibɨa! ");
INSERT INTO sjaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","K'ĩsianáatɨ mɨa parã ɨmɨateeit'ee mɨ Ak'õre k'ĩrapite. Ma k'ãyaara Moisepa p'ãdapa parã ɨmɨateepari, ma ũraade ijãa p'anɨ mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Parãpa wãara Moisepa p'ãda ijãadap'edaa paara, ichiaba mɨde ijãak'ajida, irua mɨde p'ãda perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mamĩda wãara irua p'ãda ijãada-e p'anadairã, audupɨara mɨ pedee ijãada-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma t'ẽepai, Jesús wãji Galilea Lago k'ĩraik'a eeree. Mãgɨ́ lago ichiaba t'ɨ̃jarapata Tiberias. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Eperãarã chok'ara iru t'ẽe nipapachida, irua k'ayaa beerã jɨpada perã mãik'aapa ãrapa unudap'edaa perã irua oo bɨ ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mãpai Jesús wãji ee nok'odee mãik'aapa su-ak'ɨ banaji chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judiorã Pascua fiesta ɨ̃rɨ pa baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesupa unuk'ãri ma eperãarã chok'ara ichi t'ẽe che wãda, Felipemaa mãgaji: —¿Sãma chik'o netodait'eema aji, na eperãarã jõmaweda nek'odamerã? ");
INSERT INTO sjaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesupa k'awa baji k'ãata ooit'ee. Mapa iidiji k'awaait'ee k'ãata p'anau Felipepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipepa p'anauji: —Doscientos denariopa pida araa-e pak'aji, pan netodait'ee ma-ãri ma-ãria pida k'odamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mãpai Jesús k'õp'ãyo Andrés, Simón Pedro ɨ̃pemapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nama bɨda aji, warra aba. Ichia iru bɨda aji, pan cebadadee ooda joisomaa mãik'aapa chik'o omé. Mamĩda, ¿k'ãata araayama aji, na eperãarã see nɨ̃bɨ-it'ee? ");
INSERT INTO sjaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesupa p'anauji: —Jarátɨ jõmaweda su-ak'ɨ p'aneedamerã. Mama p'ũajara jep'eda paraaji. Mama su-ak'ɨ p'aneejida. Ãchi ɨmɨk'ĩraarã cinco mil paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesupa ma pan jita atap'eda, ɨt'aa t'ɨ̃ji gracias jarait'ee mãik'aapa jõmaarãmaa jedepiji. Ichiaba mãga ooji chik'o ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jõmaweda bi jãwaa p'aneedak'ãri, Jesupa chi k'õp'ãyoorãmaa mãgaji: —Chi nɨ̃beeda p'e atadapáde aji, maarepida ãrinaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ãrapa ipurujida k'oraa docena aba ma pan joisomaadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eperãarãpa unudak'ãri Jesupa oo bɨ ma ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa, jarapachida: —Wãara nata Ak'õre pedee jarapari tachia nɨ p'anadap'edaa chemerã na p'ek'au eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mamĩda Jesupa k'awa bada perã ichi rey papi k'inia p'anɨ, ee nok'odee waya wãji, ituaba ba k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","P'ãriupodopa Jesús k'õp'ãyoorã lago idee chejida ");
INSERT INTO sjaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","mãik'aapa barcode bataudap'eda, Capernaum p'uurudee wãjida. P'ãriudaik'ãri, waide Jesús pache-e baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mãgá ãchi ituaba wãrutade p'usara t'o nɨ̃beeji, nãu golpe p'ua nɨ̃bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tok'esaa wã nidade kilometro joisomaa maa-e pɨrã seis, unujida Jesús barco k'ait'a t'ɨa cheru pania ɨ̃rɨ. Mãpai ãchi p'eradachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mãpai irua mãgaji: —¡P'eranáatɨ! ¡Mɨda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ãchia mãga ũridak'ãri, o-ĩa iru batau atajida. Taarã-ee panajida ãchi wã nipadap'edaamaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Aɨ norema eperãarã lago k'ĩraik'a eere p'anadap'edaarãpa k'awaajida Jesús k'õp'ãyoorã wãdap'edaa barco mama badade. Ichiaba k'awaajida Jesús ãra ome wã-e pada. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mãga nɨde barco pachejida Tiberias p'uurudeepa, Jesupa Ak'õremaa gracias jarap'eda, eperãarãpa pan k'odap'edaa k'ait'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mãgá eperãarãpa Jesús chi k'õp'ãyoorã ome mama unuda-e pak'ãri, ma barcode bataudap'eda, Capernaum p'uurudee wãjida iru jɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma eperãarã lago k'ĩraik'a eere panadak'ãri, Jesús ununajida mãik'aapa iidijida: —Tachi Jarateepari, ¿sãaweda pachejima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesupa mãgaji: —Mɨa wãarata jararu. Parãpa mɨ jɨrɨ nidada aji, mɨa parã bi jãwaa netawada perã, jɨrɨdai k'ãyaara k'awaadait'ee mɨa ne-inaa pi-ia oopari eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mimianáatɨ chik'o k'odait'ee aupai, mãgee chik'o jõpari perã. Ma k'ãyaara mimíatɨ k'awaadamerã mɨ, chi ne-inaa jõk'aa. Mɨ, chi Eperã Ak'õre Truadepema k'aurepata parã ichita p'anapataadai Tachi Ak'õre ome. Irua ak'ɨpi bɨ mɨ pia ak'ɨ bapari, iru juapa mɨa ook'ãri ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mãpai arii p'anadap'edaarãpa Jesumaa iidijida: —¿K'ãata oodayama ajida, Tachi Ak'õrepa tai pia ak'ɨpariimerã? ");
INSERT INTO sjaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesupa p'anauji: —Tachi Ak'õrepa k'inia bɨda aji, ijãadamerã eperã irua na eujãdee pëidade. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mãpai iidijida: —¿K'ãata pɨa ooit'eema ajida, taipa ijãadamerã pɨ Tachi Ak'õrepa pëida? ¿K'ãata pɨa taimaa ak'ɨpiit'eema? ");
INSERT INTO sjaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eujã pania wẽe bɨde tachi chonaarãpa ɨt'aripema chik'o maná, k'ojidada ajida, Tachi Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Tachi Ak'õrepa ãramaa ɨt'aripema chik'o teeji nek'odamerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesupa p'anauji: —Mɨa wãarata jararu. Moisepa parãmaa mãgɨ́ chik'o tee-e paji. Mɨ Ak'õre ɨt'aripemapata chik'o jõmaweda teepari. Mãgɨ́ chik'o chi pipɨara bɨ-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi pipɨara bɨta ɨt'ariipa cheji na p'ek'au eujãdepemaarã chok'ai p'anapiit'ee ichita p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ãchia mãgajida: —Tai-it'ee mãgɨ́ chik'ota teeparíiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mãpai Jesupa mãgaji: —Mɨda aji, chi chik'o eperãarã ichita chok'ai p'anapipari. Eperã ewaa nek'oda jarrapisia-e bɨk'a mãik'aapa chi ewaa ne-inaa toda opisia-e bɨk'a, mãga pɨk'a eperã mɨde ijãa bɨ o-ĩa bapariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mamĩda mɨa parãmaa et'ewa jaradak'a, parãpa mɨde ijãada-e p'anɨ, mɨ unupata mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jõmaweda eperãarã mɨ Ak'õrepa mɨ jua ek'ari bɨda mɨmaa chedait'ee. Chi cherutaarãmaa mɨa k'inia-eda a-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mɨ ɨt'ariipa che-e paji ooit'ee mɨchia oo k'iniata. Ma k'ãyaara cheji ooit'ee mɨ Ak'õrepa k'inia bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma-it'ee mɨ pëiji; jõmaweda mɨ jua ek'ari bɨdaarã ak'ɨ bamerã apida atuanaamerã. Mãgá Ak'õre ewari waibɨa ewate ãra chok'ai p'irabaidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mɨ Ak'õrepa k'inia bɨ jõmaweda ichi Warra k'awa p'anɨɨrã mãik'aapa irude ijãa p'anɨɨrã ɨt'aa wãdamerã. Ak'õre ewari waibɨa ewate mɨata mãgɨɨrã p'irabaipiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mãpai judiorã poro waibɨarãpa Jesús ãpɨte pedee k'achia pedee p'aneejida irua jarada perã: “Mɨda aji, chi chik'o ɨt'ariipa cheda”. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Maperã mãgajida: —¿Nãgɨ-ek'ã Jesús, José warra? Taipa k'awa p'anɨda ajida, chi ak'õre mãik'aapa chi nawe. ¿Sãgapɨ ɨt'ariipa chejida a bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mãpai Jesupa mãgaji: —¡Pedee k'achia pedee amáatɨ! ");
INSERT INTO sjaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mɨ Ak'õrepa mɨ pëiji. Eperã apida mɨmaa p'oyaa cheda-eda aji, irua anee-emãi. Ak'õre ewari waibɨa ewate irua aneeda eperãarã mɨa p'irabai atait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ak'õre pedee jarapataarãpa p'ãdap'edaade jara bɨ: ‘Tachi Ak'õrepa eperãarãmaa ichi ũraa jarateeit'ee.’ Mapa jõmaarãpa iru ũraa ũri p'anɨ mãik'aapa k'awaa wãda mɨmaa chedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mɨa mãga jarak'ãri, jara k'inia-e bɨ eperãarãpa Tachi Ak'õre unupata. Eperã apidaapa Tachi Ak'õre unuda-e p'anɨ. Irua ɨt'ariipa pëidapapaita iru unupari. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mɨa wãarata jararu. Eperãpa mɨde ijãa bɨ ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɨda aji, chi chik'o eperãarã ichita chok'ai p'anapipari. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Parã chonaarã eujã pania wẽe bɨde wãyaadak'ãri, maná k'ojidada aji. Mamĩda ma chik'opa ãra ichita chok'ai p'anapi-e paji, aɨ t'ẽepai ãchi piudap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mɨa “chik'o” ak'ãri, jara k'inia bɨ chik'o ɨt'ariipa cheda. Eperãpa mãgɨ́ chik'o k'oru pɨrã, atua-e. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɨda aji, ma chik'o ɨt'ariipa cheda eperãarã chok'ai p'anapiit'ee. Chi nãgɨ́ chik'o k'o bɨpa ichita chok'ai bapariit'ee. Nãgɨ́ chik'o mɨ k'ap'ɨa, mɨa teeit'eeda aji, piumerã jõmaarã pari, ichita chok'ai p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mãga ũridak'ãri, judiorã aupedee para beeji: —¿Sãga na eperãpa tachimaa ichi k'ap'ɨa k'opiit'eema? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mãpai Jesupa mãgaji: —Mɨa wãarata jararu. Parãpa Eperã Ak'õre Truadepema k'ap'ɨa k'oda-e pɨrã mãik'aapa iru waa toda-e pɨrã, ɨt'aa wãda-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chi mɨ k'ap'ɨa k'o bɨpa mãik'aapa mɨ waa to bɨpa Ak'õre eujãde banait'ee. Ak'õre ewari waibɨa ewate mɨata iru chok'ai p'irabai atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mapa mɨ k'ap'ɨata chi chik'o pipɨara bɨda aji. Ichiaba mɨ waata chi ba pipɨara bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chi mɨ k'ap'ɨa k'o bɨpa, ichiaba mɨ waa to bɨpa mɨ ome araa bapariit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mɨ Ak'õre ichita chok'ai bapari; mɨ jida auk'a. Irua mɨ pëiji mɨ k'ap'ɨa k'opataarã ichita chok'ai p'anapimerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mɨa jara bɨda aji, chik'o ɨt'ariipa chedade. Nãgɨ́ chik'o parã chonaarãpa maná k'odap'edaak'a bɨ-e. Ãrapa maná k'ojida. Mamĩda ma chik'opa ãra ichita chok'ai p'anapi-e paji, aɨ t'ẽepai piudap'edaa perã. Jõdee chi nãgɨ́ chik'o k'o bɨpa ichita chok'ai bapariit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesupa ma jõma jara aupada jarateeji Tachi Ak'õre Ũraa jarateepata tede Capernaum p'uurude. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesupa jarateemaa bɨ ũridak'ãri, iru ome nipapataarãpa mãgajida: —Pɨa jara bɨ p'oyaa k'awada-eda ajida. ¿K'aipa ijãayama? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesupa k'awa bada perã ichi ãpɨte mãgá pedeemaa p'anɨ, iidiji: —¿Na pedee parãpa k'achia ũri p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mãgara audupɨara ijãada-e pai, parãpa Eperã Ak'õre Truadepema unuruta pɨrã ɨt'aa wãru ichi badamaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tachi Ak'õre Jaurepa eperãarã ichita chok'ai p'anapipari. Tachi k'ĩradoopa apida ichita chok'ai p'anada-e pai. Mɨa jaradak'a parãpa mɨ k'ap'ɨa k'oruta pɨrã, pia jarait'eera, mɨde wãara ijãaruta pɨrã, Tachi Ak'õre Jaure cheit'ee parã ichita chok'ai p'anapide. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mamĩda waide parã ũk'uru ijãada-e p'anɨ. Jesupa mãga jaraji aɨ naaweda k'awa bada perã k'airãpa ijãada-e p'anɨ mãik'aapa k'aipa ichi traicionaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ichiaba mãgaji: —Mapa mɨa parãmaa jaraji eperã apida mɨmaa p'oyaa cheda-eda aji, mɨ Ak'õrepa anee-e pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Maadamãiipa chok'ara Jesús ome nipadap'edaarãpa iru atabaibëijida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mãpai Jesupa iidiji chi k'õp'ãyoorã docemaa: —¿Parã jida ichiaba wã k'inia p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedropa p'anauji: —Tachi Waibɨa, pɨk'a awaraa wẽ-e. Pɨ ũraa k'aurepa k'awa p'anɨ ɨt'aa wãdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Taipa pɨde ijãa p'anɨda ajida, mãik'aapa k'awa p'anɨ pɨ chi k'achia wẽe bapari, Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesupa p'anauji: —Mɨa parã doce weda jɨrɨt'erajida aji. Mamĩda parãdepema aba netuara eere bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesupa mãga jarak'ãri, jara k'inia baji Simón Iscariote warra Judapa ichi traicionaait'ee, chi k'õp'ãyoorã docedepema paji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma t'ẽepai Jesús nipaji Galilea eujãde. Judea eujãde ba k'inia-e paji, judiorã poro waibɨarãpa iru jɨrɨ p'anadap'edaa perã peepit'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mamĩda judiorã fiesta Rancho Oopata ɨ̃rɨ p'anadap'edaa perã, ");
INSERT INTO sjaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesús ɨ̃pemaarãpa mãgajida: —Nama beenaapáde ajida. Wãpáde ajida, Judea eujãdee, arapemaarã pɨde ijãapataarãpa ichiaba pɨa ne-inaa oo bɨ ak'ɨdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Eperãpa ichia oo bɨ merak'aa ma oo bɨ k'awapi k'inia bɨ pɨrã. Mapa pɨa ne-inaa oo bɨ nama jõmaarãmaa ak'ɨpinapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mãga jarajida chi ɨ̃pemaarãpa pida ijãada-e p'anadap'edaa perã iru Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mãpai Jesupa mãgaji: —Ewari Tachi Ak'õrepa awara bɨda ma-it'ee waide pa-e bɨda aji. Mamĩda parã wã k'inia p'anadak'ãri, wãdaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Na p'ek'au eujãdepemaarãpa parã k'ĩra unuamaa iru p'anadak'aada aji. Mamĩda mɨ k'ĩra unuamaa iru p'anapata, mɨa jarapari perã ãchia k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wã́tɨ fiestadee. Mɨ wã-eda aji, waide mɨ ewari pa-e perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mãga jarap'eda, beeji Galilea eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mamĩda chi ɨ̃pemaarã wãdap'edaa t'ẽepai, Jesús ichiaba wãji ma fiestadee. Mamĩda awaraarã ome wã-e paji. Ituaba miru wãji, chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mãɨmisa judiorã fiestade p'anadap'edaarãpa Jesús jɨrɨpachida mãik'aapa mãgapachida: —¿Sãma bɨma apachida, jã eperã? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eperãarã chok'ara ãchi pitapai osausawaa pedeepachida iru ãpɨte. Ũk'uruurãpa mãgapachida: —Jã eperã t'ãri pia bapari. Mamĩda awaraarãpa mãgapachida: —Jã eperãpa eperãarã k'ũramaa nipapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mamĩda judiorã poroorã waidoopa, jõmaarã taide apidaapa mãga jarada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma fiesta tomia esa-auk'a wãyaa wãde Jesús t'ĩuji Ak'õre te waibɨade mãik'aapa jarateemaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Arii p'anadap'edaa judiorã ak'ɨtrua para beeji mãik'aapa iidijida: —¿Sãgapɨ na eperãpa Tachi Ak'õre Ũraa audú k'awa bɨma ajida, estudia-e padata awaraarãk'a? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesupa p'anauji: —Mɨchi k'ĩsiadoopa jaratee-e bɨda aji. Mɨa jaratee bɨ mɨ pëidapa jarateepi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Eperãpa oo k'inia bɨ pɨrã Tachi Ak'õrepa oopi bɨk'a, ma eperãpa k'awaait'ee mɨa wãara jarateemaa bɨ Ak'õre Ũraa, maa-e pɨrã wãara jarateemaa bɨ mɨchi k'ĩsiadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Eperãpa ichi k'ĩsiadoopa jarateek'ãri, mãga oopari awaraarãpa ichi t'o p'anadamerã. Mamĩda eperãpa jarateek'ãri awaraarãpa Tachi Ak'õre Ũraa pia ak'ɨ p'anapataadamerã, mãgɨpa wãarata jarateepari. Seewa jarak'aa mãik'aapa eperãarã k'ũrak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisepa parã chonaarãmaa Ak'õre Ũraa p'ã teeji. ¿Wãara-ek'ã? Mamĩda apidaapa ichita oodak'aa ma ũraade jara bɨk'a. ¿Sãap'eda parãpa mɨ peet'aa k'inia p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Arii p'anadap'edaarãpa mãgajida: —¿Netuara pɨ k'ap'ɨade merãtɨa bɨ-ek'ã? ajida. ¿K'aipa pɨ jɨrɨ bɨma ajida, peet'aait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesupa mãgaji: —Parãpa ijãa p'anɨ ɨ̃ipata ewate mimiadaik'araa bɨda aji, Moisepa p'ãdade mãga jara bairã. Mapa parã jõmaweda p'era pɨk'a para baji, ɨ̃ipata ewate mɨa ook'ãri ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mamĩda ɨ̃ipata ewate parãpa paara ne-inaa oopata. Pãchi ɨmɨk'ĩra warrarã k'ap'ɨade tauchaa bɨpata. Mãga oopata Moisepa jarada perã mãga oodamerã. (Wãara Moisepa naapɨara mãga oopi-e paji. Iru t'oi naaweda, parã chonaarãpa mãga oopachida.) ");
INSERT INTO sjaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ɨ̃ipata ewate parãpa mãga oopata, oo k'inia p'anadairã Moisepa p'ãdade jara bɨk'a. Mãga bɨta, ¿sãap'eda k'ĩrau p'anɨma aji, ɨ̃ipata ewate mɨa eperã jɨpada perã? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mɨa oo bɨ ɨ̃rɨpai ak'ɨnáatɨ jaradait'ee pia wa k'achia. Ak'ɨ́tɨ Tachi Ak'õrepa mɨ ak'ɨparik'a, iruapai jarapii perã chisãgɨ́ pia mãik'aapa chisãgɨ́ k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Maapai Jerusalén p'uurudepemaarãpa iidi para beeji: —¿Nãgɨ́ eperã-ek'ã ajida, tachi poroorãpa jɨrɨmaa p'anɨ peet'aadait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jãma jõmaarã taide pedeemaa bɨ. Mamĩda apidaapa jarada-e p'anɨ iru pedeenaamerã. ¿Tachi poroorãpa ijãa p'anɨk'ã na eperã Mesías, Tachi Ak'õrepa pëida tachi k'aripamerã? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Taipa k'awa p'anɨ sãmapema na eperã. Mamĩda Mesías chek'ãri, apidaapa k'awada-e pait'ee iru sãmapema. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mãɨmisa Tachi Ak'õre te waibɨade Jesupa jarateemaa baji. Mãɨrã pedee ũrik'ãri, Jesupa golpe mãgaji: —Wãara parãpa mɨ k'awa p'anɨ mãik'aapa k'awa p'anɨ mɨ sãmapema. Mamĩda mɨchi k'ĩradoopa che-e bɨda aji. Abaapa mɨ pëiji. Mãgɨ́ wãara bapari. Mamĩda parãpa iru k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jõdee mɨa iru k'awa bɨ, iru baparimãiipa cheda perã. Iruata mɨ pëijida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mãga ũridak'ãri, Jesús jita atadait'ee paji. Mamĩda p'oyaada-e paji, at'ãri iru ewarimaa pa-e bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mãga baji mĩda judiorã poroorã ome, eperãarã chok'ara Jesude ijãajida mãik'aapa mãgapachida: —Mesías chek'ãri, ¿ne-inaa piara ooik'ã ajida, na eperãpa oo bɨ k'ãyaara? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseorãpa ũrijida eperãarã mãgá pedee p'anɨ. Mapa ma fariseorãpa p'aareerã poroorã ome pëijida Tachi Ak'õre te waibɨa jɨ̃apataarã Jesús jita atadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mamĩda Jesupa mãgaji: —Mɨ parã ome mak'ɨara taarã-eda aji. Ma t'ẽepai mɨ waya wãit'ee mɨ pëida baparimaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Parãpa mɨ jɨrɨdayada aji. Mamĩda mɨ unuda-e pait'ee, p'oyaa wãdak'aa perã mɨ wãit'ee bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mãpai judiorã poroorã pedee para beeji: —¿Sãmapɨ wãit'eema ajida na eperã, tachia p'oyaa unuda-e pait'ee? ¿Tok'esaa wãit'ee-epaa jarateede judiorãmaa, k'ĩra tewaraarã p'uurudepemaarãmaa, maa-e pɨrã judio-eerãmaa? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿K'ãata jara k'inia bɨma ajida, irua jarak'ãri: “Parãpa mɨ jɨrɨdait'ee. Mamĩda mɨ unuda-e pait'ee, p'oyaa wãdak'aa perã mɨ wãit'ee bɨmaa”? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta Rancho Oopata jõ wãda ewate, ma ewari waibɨara paji. Ma ewate Jesús bainɨ̃ beeji mãik'aapa golpe pedeeji: —Apida opisia bɨ pɨrã, mɨmaa chepáde aji, tode. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Chi mɨde ijãa bɨ bait'ee Tachi Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Eperã t'ãrideepa to chak'ek'a jĩchooyada aji, paniapa eperãarã chok'ai p'anapiparik'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ma pedee “paniapa eperãarã chok'ai p'anapiparida” ak'ãri, Jesupa jara k'inia baji Tachi Ak'õre Jaure, mãgɨ́ pëiit'ee bada perã irude ijãapataarãmaa. Mamĩda Jesupa mãga jarak'ãri, waide Ak'õre Jaure pëi-e paji, ichi waide ɨt'aa wã-e bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma pedee ũridak'ãri, eperãarã ũk'uruurãpa mãgapachida: —Wãara, na eperã Ak'õre pedee jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Awaraarãpa mãgapachida: —Na Mesías, Tachi Ak'õrepa pëida eperãarã rey pamerã. Mamĩda awaraarãpa mãgapachida: —Mãga-epɨ. ¿Sãga Mesías adaima? Iru Galilea eujãdepema. Galilea eujãdeepa Mesías uchia-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Tachi Ak'õre Ũraa p'ãdade jara bɨ-ek'ã ajida, Mesías uchiait'ee Rey David ëreerãdeepa mãik'aapa t'oit'ee Belén p'uurude Rey David t'odamãi? ");
INSERT INTO sjaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mapa eperãarã k'ĩsia awara-awaraadachida. Ũk'uruurãpa ijãajida Jesús Tachi Ak'õrepa pëida; ũk'uru ijãadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mãɨrãpa Jesús jita ata k'inia p'anajida. Mamĩda apidaapa p'oyaa ooda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mãpai Tachi Ak'õre te waibɨa jɨ̃apataarã ãchi pëidap'edaarãmaa chejida. Pachedak'ãri, fariseorãpa mãik'aapa p'aareerã poroorãpa iidijida: —¿Sãap'eda Jesús aneeda-e pajima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma Ak'õre te waibɨa jɨ̃apataarãpa p'anaujida: —¡Eperã apida pedeeda-eda ajida, mãgɨ́ eperãk'a! ");
INSERT INTO sjaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mãpai fariseorãpa mãgajida: —¿Parãpa pida irumaa k'ũrapijidak'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Sãma tachi poroorãpa maa-e pɨrã tai fariseorãpa irude ijãa p'anɨma? ajida. ¡Mãga oodak'aa! ");
INSERT INTO sjaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jã eperãarãpa k'awadak'aa Tachi Ak'õrepa Moisemaa ũraa p'ãpida, irude ijãadak'aa perã. Mapa Ak'õrepa ãra k'achia ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mãpai fariseo Jesumaa naaweda wã bada, Nicodemopa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Tachi Ak'õre Ũraa p'ãdade nãga jara bɨ-ek'ã? aji. Ũridaipia bɨ eperãpa jara bɨ mãik'aapa k'awaadaipia bɨ irua oo bɨ, jaradai naaweda ma eperã pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ãchia p'anaujida: —¿Pɨ jida ichiaba Galilea eujãdepemak'ã? ajida. Tachi Ak'õre Ũraa p'ãda pia léeji. Mãga ooru pɨrã, k'awaait'ee Tachi Ak'õre pedee jarapataarã Galilea eujãdeepa uchiadak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mãpai jõmaweda wãjida ãchi te chaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mamĩda Jesús wãji Olivo Eedee. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aɨ norema tap'eda, waya cheji Tachi Ak'õre te waibɨadee. Mama pachek'ãri, eperãarã chok'ara chejida irumaa. Mapa iru su-ak'ɨ beeji mãik'aapa jarateemaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Moisepa p'ãda jarateepataarãpa fariseorã ome aneejida wẽra unu atadap'edaa p'ek'au oomaa bɨ. Eperãarã taide ata bɨjida ");
INSERT INTO sjaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","mãik'aapa Jesumaa mãgajida: —Tachi Jarateepari, taipa na wẽra miak'ãi bɨta unujidada ajida, awaraa ome nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ak'õre Ũraa p'ãdade Moisepa jaraji nãgee wẽraarã mãupa bat'a peet'aadamerã. Mamĩda taipa k'awaa k'inia p'anɨ ¿pɨa k'ãata jara bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ãchia mãga iidijida Jesupa Moisepa p'ãda merai jĩak'aapa. Mãgá ɨmɨateek'ajida. Mamĩda Jesupa made t'ĩupi-e paji. Edaa ɨ̃jaabaip'eda, p'ãmaa beeji yooro p'orade ichi jua k'ɨ̃pa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mãpai ãchia iidi jõnɨde Jesús jĩp'a su-ak'ɨ beeji mãik'aapa mãgaji: —Naapɨara ichimaa mãupa bat'apáde aji, parãdepema chi p'ek'au k'achia wẽe bɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maap'eda waya edaa ɨ̃jaabaip'eda, yooro p'orade waya p'ãmaa beeji ichi jua k'ɨ̃pa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mãgɨ́ pedee ũridak'ãri, jõmaweda aba-abaa uchia wãdapa erreudachida. Naapɨara wãjida chonaarã, maap'eda apemaarã. Jesús ituaba beeji mãgɨ́ wẽra ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mapa Jesús jĩp'a su-ak'ɨ beep'eda, irumaa iidiji: —¿Sãma p'anɨma? aji. ¿Apidaapa pɨ pee k'iniada-e pajik'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma wẽrapa mãgaji: —Apidaapa, Tachi Waibɨa. Jesupa mãgaji: —Mɨa pida pɨ pee k'inia-eda aji. Ɨ̃rá wãpáde aji, mãik'aapa ɨ̃raweda p'ek'au k'achia oo amáaji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mãpai Jesupa waya jarateemaa beeji eperãarãmaa: —Mɨda aji, ɨ̃daa pɨk'a bɨ na p'ek'au eujãdepemaarã-it'ee, mɨa ãramaa Tachi Ak'õre o ak'ɨpipari perã. Mɨde ijãa bɨ p'ãriu pɨk'a bɨde nipa-e pait'ee, Tachi Ak'õre k'awa-ee. Ma k'ãyaara ichita chok'ai bapariit'ee, ɨ̃daa pɨk'a bɨde Tachi Ak'õre ode nipapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mãpai fariseorãpa irumaa mãgajida: —Pɨchi k'ĩsiadoopa mãgɨ́ pedee jaramaa bɨda ajida. Awaraa wẽ-e perã auk'a jarait'ee, pari pɨ pedeemaa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesupa p'anauji: —Mɨ pedeek'ãri, wãarata jarapari. Mɨa k'awa bɨda aji, sãmãik'aapa cheda mãik'aapa sãmaa wãit'ee. Jõdee parãpa mãga k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Awaraarãpa oo p'anɨ ɨ̃rɨpai ak'ɨpata jaradait'ee pia wa k'achia. Jõdee mɨa mãgá ak'ɨ-epɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mamĩda eperãpa oo bɨ ak'ɨk'ãri, mɨa jararu pɨrã pia wa k'achia, wãarata jarait'ee, mɨ pëidapa mɨ k'aripapari perã. Mɨchi ituabaapa eperãarãpa oopata mãgá ak'ɨk'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pãchi ũraa p'ãdade jara bɨ eperã omeerãpa ne-inaa unudap'edaa auk'a jaradak'ãri, ma jarada wãara. Auk'a bɨ mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɨchia oo bɨ jarapari mãik'aapa mɨ Ak'õre, mɨ pëidapa, auk'a jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mãpai ãchia iidijida: —¿Sãma bɨma ajida, pɨ Ak'õre? Jesupa p'anauji: —Parãpa mɨ wãara k'awada-eda aji. Mɨ Ak'õre jida wãara k'awada-e. Mɨ wãara k'awa p'anadap'edaa paara, mɨ Ak'õre jida wãara k'awa p'anak'ajidada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesupa mãga jaraji, Tachi Ak'õre te waibɨade primisia ɨapatamãi jaratee bɨ misa. Eperãarã chok'ara mama wãyaa wãjida mĩda, apidaapa iru jitada-e paji irua jarateeda k'aurepa, ewari Tachi Ak'õrepa awara bɨda ma-it'ee waide pa-e bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mãpai waya Jesupa mãgaji: —Mɨ ãyaa wãit'eeda aji. Parãpa mɨ jɨrɨdait'ee. Mamĩda mɨ unuda-e pait'ee. Atuadait'ee pãchia p'ek'au k'achia oopata k'aurepa. Mapa mɨ wãit'ee bɨmaa parã p'oyaa wãda-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mãga ũridak'ãri, judiorã poroorã pedee para beeji: —Tachi p'oyaa wãda-eda a bɨ, iru wãit'ee bɨmaa. ¿Ichi juadoopa piut'ee-epaama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mãpai Jesupa ãchimaa mãgaji: —Parã ek'aripemaarãda aji. Mamĩda mɨ ɨt'aripema. Parã na p'ek'au eujãdepema. Mamĩda mɨ na p'ek'au eujãdepema-e. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mapa mɨa jaraji parã atuadait'ee pãchia p'ek'au k'achia oopata k'aurepa. Wãara mãgá atuadait'eeda aji, ijãada-e p'anɨ pɨrã Mɨta jõmaarã Ak'õre Waibɨa. Mɨa aupaita eperãarãpa p'ek'au k'achia oopata wẽpapii. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mãpai irumaa iidijida: —Pɨ, ¿k'aima? ajida. Jesupa p'anauji: —Mɨ chedak'ãriipa, parãmaa mãga jaraparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mɨa unupari pãchia ne-inaa k'achia oopata mãik'aapa pedee chok'araapa parã ɨmɨateek'aji. Mamĩda mãga oo-e pait'ee. Jĩp'a jarait'ee mɨ pëidapa jarapi bɨk'a na p'ek'au eujãdepemaarãmaa. Irua ichita wãarata jaraparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mamĩda ãchia k'awada-e paji, Jesupa jarak'ãri ichi Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mapa Jesupa mãgaji: —Parãpa Eperã Ak'õre Truadepema kurusode jiradak'ãri peedait'ee, k'awaadait'ee Mɨta Tachi Ak'õrepa pëida. Ma awara k'awaadait'ee mɨa ne-inaa jõma oopari irua oopi bɨk'a mãik'aapa jõma jarapari irua jarapi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mɨ pëida na p'ek'au eujãdee mɨ ome baparida aji. Mɨ ituaba atabëi-epɨ, irua k'inia bɨk'a oopari perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesupa mãga jarak'ãri, eperãarã chok'ara irude ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mãpai Jesupa judiorã irude ijãadap'edaarãmaa mãgaji: —Parãpa oo p'anɨ pɨrã mɨa ũraa bɨk'a, wãara mɨ k'õp'ãyoorã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mãga ooruta pɨrã, k'awaadait'ee Tachi Ak'õrepa wãarata jara pëida mãik'aapa ma k'aurepa waa esclavoorã p'anada-e pait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ãchia p'anaujida: —Tai Abrahamdeepa uchiadap'edaarã. Mapa tai esclavoorã-epɨ. Apidaa jua ek'ari p'anadak'aa. Tachi Ak'õre juadepai p'anapata. ¿Sãap'eda taimaa jara cheruma ajida, waa esclavoorã p'anada-e pait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesupa p'anauji: —Mɨa wãarata jararu. Jõmaweda p'ek'au k'achia oopataarã esclavoorãk'a p'anɨda aji, p'ek'au k'achia jua ek'ari p'anapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","K'ĩsiadáma nãgɨde. Esclavo ichita ba-e chipari tede. Jõdee ma te chipari warra ichita bapari ma tede, ichi ak'õrede perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mapa Tachi Ak'õre Warrapa parã p'ek'au k'achia jua ek'ariipa uchia ataru pɨrã, wãara uchiadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mɨa k'awa bɨ parã Abrahamdeepa uchiadap'edaarã. Mamĩda mɨ peet'aa k'inia p'anɨ, mɨ ũraa wãara ijãa k'iniada-e p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mɨa jaraparida aji, mɨ Ak'õrepa mɨmaa ak'ɨpida. Jõdee parãpa oopata pãchi ak'õrepa jarateedak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mãpai ãchia mãgajida: —¡Tai ak'õre Abrahamda! ajida. Mamĩda Jesupa p'anauji: —Parã wãara Abraham warrarã pada paara, irua oodak'a ook'ajidada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mamĩda mãga ooda-e p'anɨ. Mɨa parãmaa Tachi Ak'õre wãarata jaraji, irua mɨmaa mãga jarada perã. Mamĩda ɨ̃rá parãpa mɨ peet'aa k'inia p'anɨ. Abrahampa mãga oo-e paji Ak'õre pedee jarapataarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Parãpa ne-inaa k'achia oomaa p'anɨda aji, pãchi ak'õrepa ooparik'a. Ãchia mãgajida: —¡Tai awaraa ak'õredeepa uchiada-e pajida! ajida. ¡Ak'õre abapaita iru p'anɨda! ajida. ¡Mãgɨ́ Tachi Ak'õre! ");
INSERT INTO sjaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesupa p'anauji: —Tachi Ak'õre wãara parã ak'õre pada paara, mɨ k'inia iru p'anak'ajidada aji, mɨ Tachi Ak'õremãiipa cheda perã. Mapa mɨ nama bɨ. Mɨchi k'ĩradoopa nama che-e paji. Tachi Ak'õrépata mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Parãpa mɨa jaratee bɨ at'ãri k'awada-e p'anɨk'ã? Parãpa mɨ ũraa ũri k'iniada-e p'anɨ. Maperãpɨ mɨa jara bɨ k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Parã ak'õre Netuara Poro Waibɨa. Ichideerã perã ichia oopi k'iniata oo k'inia p'anɨ. Na eujã beedak'ãriipa ichia eperãarã peeyaa bapari. Ma awara ne-inaa wãara unuamaa iru bapari, wãarata k'awak'aa perã. Seewa jarapari wãarak'a; mãga bapari. Ichi seewa-idaa beerã ak'õre, seewa-idaa bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mamĩda mɨa Tachi Ak'õre wãarata jarak'ãri, parãpa mɨ pedee ijãadak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿K'aipa ak'ɨpii mɨa p'ek'au k'achia aba pida ooda? ¡Mãga p'oyaa ooda-e! Mãga bɨta, mɨa wãarata jarak'ãri, ¿parãpa sãap'eda mɨ pedee ijãada-ema? ");
INSERT INTO sjaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tachi Ak'õredeerãpa iru Ũraa ũri k'inia p'anapata. Mamĩda parã Ak'õredeerã-e p'anadairã, iru ũraa ũri k'iniadak'aada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mãpai judiorã poroorãpa Jesumaa mãgajida: —¿Pɨ Samariadepema-ek'ã? ajida. Ma awara pɨchi k'ap'ɨade netuara merãtɨa bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesupa p'anauji: —Mɨ k'ap'ɨade netuara wẽe bɨda aji. Ma k'ãyaara mɨa mɨ Ak'õre waawee bapari. Mamĩda parãpa mɨ waaweedak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɨa jɨrɨ-e bɨ eperãarãpa mɨ t'o p'anadamerã, mɨ Ak'õrepa mãga k'inia bɨ mĩda. Iruata ak'ɨ bɨ parãpa oopata mãik'aapa jarait'ee pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mɨa wãarata jararu. Eperãpa mɨ ũraa ũrip'eda, ooru pɨrã ma ũraade jara bɨk'a, piu-e pait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mãpai ma judiorãpa mãgajida: —¡Ɨ̃rapɨ k'awa p'anɨ wãara pɨ k'ap'ɨade netuara merãtɨa bɨ! Abraham mãik'aapa Tachi Ak'õre pedee jarapataarã jõmaweda piujida. Mamĩda pɨa jara bɨ pɨ ũraa jara bɨk'a oopari piu-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mãgara, ¿pɨ waibɨara bɨk'ã tai chonaarãwedapema piuda Abraham k'ãyaara? ¿Waibɨara bɨk'ã Tachi Ak'õre pedee jarapataarã piudap'edaa k'ãyaara? ¿K'ãata k'inia bɨma ajida, taipa k'ĩsiadamerã pɨde? ");
INSERT INTO sjaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesupa p'anauji: —Mɨa jarada paara mɨ waibɨara bɨ awaraarã k'ãyaara, pari mãga jarak'aji. Mamĩda mɨ Ak'õrépata mãga jarapari. Mãgɨ́ Ak'õre parãpa “Tachi Ak'õre” apata. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mamĩda parãpa Tachi Ak'õre k'awada-e p'anɨ. Jõdee mɨa iru wãara k'awa bɨ. Mɨa iru k'awa-e bɨda ada paara, seewa-idaa bak'aji parã jĩak'a. Mamĩda mãga-e. Mɨa wãara iru k'awa bɨ mãik'aapa oopari irua jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pãchi chonaarãwedapema Abraham o-ĩadachi mɨ na eujãdee cheda unuit'ee bada perã. Wãara mãga unuji mãik'aapa o-ĩa beejida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mãpai ãchia mãgajida Jesumaa: —Pɨ waide cincuenta años wẽe bɨ. Mãga bɨta, ¿Abraham unujida a bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesupa p'anauji: —Mɨa wãarata jararu. Abraham t'oi naaweda, Mɨta bapachida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mãga ũridak'ãri, ãchia mãu p'e atajida bat'adait'ee Jesumaa, ichi Tachi Ak'õreda ada perã. Mamĩda Jesús mirudachi mãik'aapa Ak'õre te waibɨadeepa uchiadachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Maap'eda Jesús awara ãi wã nide unuji eperã tau p'ãriu bɨ ichi t'oru weda. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma eperã unudak'ãri, Jesús ome nipapataarãpa iidijida: —Tachi Jarateepari, ¿k'ãare k'aurepata na eperã tau p'ãriu t'ojima? ajida. ¿Ichia p'ek'au k'achia oopata k'aurepa pajik'ã ajida, maa-e pɨrã chi ak'õreerãpa p'ek'au k'achia oopata k'aurepa? ");
INSERT INTO sjaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesupa p'anauji: —Ichi k'aurepa-epɨ; ichiaba ichi ak'õreerã k'aurepa-epɨ. Tachi Ak'õrepa mãga t'opiji eperãarãpa ak'ɨdamerã iruata ne-inaa pia ooi ma eperã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ãstaawa tachia oodaipia bɨ mɨ pëidapa oopi bɨk'a, p'ãrik'ua pak'ãri, apidaapa mãga p'oyaa oodak'aa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mɨ na p'ek'au eujãde bɨ misa, ɨ̃daa pɨk'a bɨ na eujãdepemaarã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mãga jarap'eda, Jesupa eujãde idut'aaji mãik'aapa yooro p'ora ome p'oirat'aap'eda, tau p'ãriu bɨ taude p'urut'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mãpai mãgaji: —Wãpáde aji, pɨchi tau sɨɨde pania t'ɨpata Siloé apatamaa. (Siloé jara k'inia bɨ “Pëida”.) Mãpai tau p'ãriu bɨ wãji ichi tau sɨɨde. Ãpɨtee chek'ãri, pia unu beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","T'ẽepai ma eperã k'ait'a p'anadap'edaarãpa mãik'aapa iru ne-iidimaa unudap'edaarãpa mãgapachida: —¿Nãgɨ́ chi ne-inaa iidimaa su-ak'ɨ bapariida-ek'ã? apachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ũk'uruurãpa mãgapachida: —Jã ichipɨ. Awaraarãpa mãgapachida: —Jã iru-epɨ, iru k'ĩra papaa bɨ mĩda. Mamĩda ichia p'anauji: —Mɨpɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mãpai iidijida: —¿Sãga ɨ̃rá pɨa unu bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ichia p'anauji: —Eperã t'ɨ̃jarapata Jesupa iduba yooro p'ora ome p'oirap'eda, mɨ taude p'urut'aajida aji, mãik'aapa mãgaji: “Wã́ji pɨchi tau sɨɨde pania t'ɨpata Siloé apatamaa.” Aramãgá mɨ wãjida aji, mãik'aapa mɨchi tau sɨɨt'aak'ãri, unuji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mãpai ãchia iidijida irumaa: —¿Sãma bɨma ajida, ma eperã? Ichia p'anauji: —K'awa-e bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesupa ma yooro ook'ãri p'uruit'ee tau p'ãriu bada taude, ɨ̃ipata ewate paji. Maperã judiorã poro waibɨarãpa ma tau p'ãriu bada ateejida fariseorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mãpai ãchia iidijida: —¿Sãga ɨ̃rá unu bɨma? ajida. Ichia p'anauji: —Yooro mɨ taude p'urujida aji. Maap'eda mɨa sɨɨt'aaji. Mapa ɨ̃rá pia unu bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseorã ũk'uruurãpa mãgajida: —Jãgɨ́ eperã Tachi Ak'õrepa pëida-eda ajida, ɨ̃ipata ewate mãga ooda perã. ¿Tachi Ak'õre Ũraa p'ãdade jara bɨ-ek'ã ajida, ɨ̃ipata ewate mimiadaik'araa bɨ? Mamĩda awaraarãpa mãgapachida: —¿Sãgá eperã p'ek'au k'achia ooparipa nãgee ne-inaa pia ooyama? ajida. Mãgá ãchi k'ĩsia awara-awaraadachida mãik'aapa ãchi k'õp'ãyoorã ome aupedee jõnapachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Maap'eda waya iidijida naaweda tau p'ãriu badamaa: —Pɨa ¿k'ãata k'ĩsia bɨma ajida, jã eperãpa pɨ tau jɨpadade? Ichia p'anauji: —Mɨ-it'ee iru Ak'õre pedee jaraparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mamĩda ma judiorãpa ijãada-e paji ma eperã wãara naaweda tau p'ãriu baji mãik'aapa ɨ̃rá pia unu bɨ. Mapa chi ak'õre chi nawe ome t'ɨ̃ pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mãpai iidijida: —¿Na parã warrak'ã? ajida. ¿Parãpa jaradaik'ã ichi tau p'ãriu t'oda? ¿Sãga ɨ̃rá pia unu bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chi ak'õreerãpa p'anaujida: —Taipa k'awa p'anɨda ajida, nãgɨ́ tai warra mãik'aapa k'awa p'anɨ ichi tau p'ãriu t'oda. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mamĩda k'awada-e ɨ̃rá sãga ichi taupa unu bɨ. Ichiaba k'awada-e k'aipa ichi taupa unupiji. Iidítɨ irumaa. Iru chona bairã, ichi itu jarayada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chi ak'õreerãpa mãga jarajida judiorã waidoopa. Aɨ naaweda judiorã poro waibɨarãpa pedeeteejida chi eperã Jesús Mesías aru pɨrã, waa t'ĩupida-e pait'ee Tachi Ak'õre Ũraa jarateepata tede. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mapa chi ak'õreerãpa jarajida: “Ichimaa iidítɨ. Iru chona bɨda” ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maperã judiorã poro waibɨarãpa waya t'ɨ̃ pëijida ma naaweda tau p'ãriu bada mãik'aapa mãgajida: —Wãara jarapáde ajida, Tachi Ak'õre k'ĩrapite. Taipa k'awa p'anɨda ajida, jã eperã p'ek'au k'achia ooyaa bapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ichia p'anauji: —Mɨa k'awa-e bɨda aji, ma eperãpa p'ek'au k'achia oopari wa mãga-e. Nãgapai k'awa bɨ. Mɨ tau p'ãriu baji. Mamĩda ɨ̃rá pia unu bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Waya iidijida: —¿K'ãata oojima? ajida. ¿Sãga pɨ tau pia unupijima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ichia p'anauji: —Mɨa parãmaa jarajida aji. Mamĩda mɨ pedee ijãada-e p'anɨ. ¿Waya jarapi k'inia p'anɨk'ã? ¿Parãpa ichiaba irude ijãa k'inia p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mãga ũridak'ãri, ik'achia pedee p'aneejida ma tau p'ãriu badamaa: —¡Pɨata jã eperãpa jaratee bɨde ijãa bɨda! ajida. ¡Jõdee taipa Moisepa p'ãdade ijãapata! ");
INSERT INTO sjaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Taipa k'awa p'anɨda ajida, Tachi Ak'õrepa Moisemaa pedeeda. Mamĩda k'awada-eda ajida, sãmãik'aapa cheji jã eperã. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ichia p'anauji: —¿Sãga? ¡Parãpa k'awada-eda a p'anɨ sãmãik'aapa cheji! ¡Mamĩda irua mɨ tau unupiji! ");
INSERT INTO sjaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jõmaarãpa k'awa p'anɨ Tachi Ak'õrepa p'ek'au k'achia ooyaa beerã pedee ũrik'aa. Mamĩda ũripari ichimaa ɨt'aa t'ɨ̃pataarã pedee, mãɨrãpa irua k'inia bɨk'a oopata perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na p'ek'au eujã beedak'ãriipa waide ũridak'aa eperãpa tau p'ãriu bee pia unupida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma eperã Tachi Ak'õrepa pëi-e pada paara, nãgee ne-inaa oo-e pak'ajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mãpai ma fariseorã k'ĩraudachida mãik'aapa mãgajida: —Pɨchi t'oru weda p'ek'au k'achia ooyaa bapari. Mãga bɨta, ¿taimaa jaratee k'inia bɨk'ã? ajida. Maap'eda taawaa jëret'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesupa k'awaaji mãgɨ́ tau p'ãriu bada taawaa jëret'aadap'edaa. T'ẽepai iru ome unuk'ãri, iidiji: —¿Pɨa Eperã Ak'õre Truadepemade ijãa bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ichia p'anauji: —Mɨmaa jarapáde aji, k'aita pɨa jara bɨ. Mɨa irude ijãait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesupa mãgaji: —Pɨa mãgɨ́ unuda; mɨda aji, pɨ ome pedeemaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mãpai Jesús k'ĩrapite bedabaiji mãik'aapa mãgaji: —Tachi Waibɨa, mɨa ijãa bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma t'ẽepai Jesupa mãgaji: —Mɨ na p'ek'au eujãdee chejida aji, eperãarã ak'ɨde, k'awaait'ee wãara ijãa p'anɨ wa ijãada-e p'anɨ. Chejida aji, Tachi Ak'õre k'awapiit'ee tau p'ãriu pɨk'a beerãmaa, ãchia iru k'awaadamerã. Ichiaba cheji ak'ɨpiit'ee tau ɨ̃daa pɨk'a beerãmaa, ãchia Tachi Ak'õre wãara k'awada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseorã ũk'uruurãpa mãga ũridak'ãri, iidijida: —¿K'ãata jara k'inia bɨma? ajida. ¿Tai jida Tachi Ak'õre k'awada-e p'anɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesupa p'anauji: —Parã mãga p'anadap'edaa paara, apidaapa parã ɨmɨateeda-e pak'aji. Mamĩda parãpa jarapata Tachi Ak'õre wãara k'awa p'anɨ. Mãga jaradak'ãri, p'ek'au k'achia oomaa p'anɨ, seewa jara p'anɨ perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mãpai Jesupa mãgaji: —Mɨa wãarata jararu. Eperãarã oveja k'ãipatamãi t'ĩudak'ãri, puerta eere t'ĩupata. Maperã eperã ma puerta eere t'ĩu-e pɨrã, mãgɨ́ nechɨayaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mamĩda chi eperã puerta eere t'ĩupari; mãgɨ́ chi ovejaarã ak'ɨpari. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Puerta jɨ̃aparipa ewapari mãgɨ́ oveja ak'ɨpari t'ĩumerã. Mãpai irua ichi ovejaarã aba-abaa t'ɨ̃pari. Ma ovejaarãpa iru pedee k'awapata perã, ãchi k'ãipatamãiipa uchiadak'ãri, iru t'ẽe k'ĩup'ee wãpata. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ichi ovejaarã jõmaweda uchia atak'ãri, ãra naa wãpari mãik'aapa chi ovejaarã iru t'ẽe wãpata, chipari pedee k'awapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mamĩda awaraa eperãpa ma ovejaarã atee k'inia bɨ pɨrã, wãdak'aa mãgɨ́ ome. Ãyaa wãpata, mãgɨ́ pedee k'awadak'aa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesupa mãga nepɨrɨji jarateeit'ee ma fariseorãmaa. Mamĩda ãchia k'awada-e paji irua k'ãata jara k'inia bada. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mapa Jesupa ãchimaa waya mãgaji: —Mɨa wãarata jararu. Mɨda aji, ma puertak'a, ovejaarã t'ĩupatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jõmaarãpa mɨ naa jara chedap'edaa ãchita Tachi Ak'õrepa pëida, nechɨayaa beerãk'a p'anajidada aji. Mapa mɨchi ovejaarã, pia jarait'eera, mɨchideerãpa mãɨrã pedee ijãada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɨda aji, puertak'a bɨ. Mɨa eperãarã o k'achiadeepa k'aripa atapari t'ĩudamerã mɨchi jua ek'ari mɨchideerã ome. Oveja ak'ɨpari pia bɨpa ichi ovejaarã ak'ɨparik'a, mãga pɨk'a mɨa mɨchideerã ak'ɨpari mãik'aapa k'aripapari pia p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Chi nechɨapari chepari nechɨait'ee aupai mãik'aapa peeit'ee aupai; ichiaba ne-inaa jõma p'e atadariit'ee aupai. Jõdee mɨ nama cheji eperãarã pia p'anapiit'ee mãik'aapa ichita p'anapiit'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Mɨ chi ovejaarã ak'ɨpari t'ãri piara bɨk'a mãik'aapa eperãarã mɨ ovejaarãk'a. Ovejaarã ak'ɨpari t'ãri pia bak'ãri, chi ovejaarã pia ak'ɨpari, mãga oo bɨ k'aurepa piuru pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mamĩda mãga-e mimiapari jĩp'aa ome. Chĩara ovejaarã ak'ɨ bɨde, mãgɨpa ne-animal k'achia cheru unuk'ãri, mirudaipari ma ovejaarã k'iniak'aa perã. Maperãpɨ ne-animal k'achia bɨpa ma ovejaarã ũk'uru ata chepari mãik'aapa apemaarã awara ãyaa jĩchoopipari. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma eperã mirudaipari ma ovejaarã ak'ɨpari-e perã mãik'aapa ma ovejaarã ichide-e perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Ovejaarã ak'ɨpari t'ãri piara bɨpa ichi ovejaarã pia ak'ɨparik'a, mãga pɨk'a mɨa mɨchideerã pia ak'ɨpari. Mɨ Ak'õrepa mɨ t'ãri k'awa bɨ; ichiaba mɨa pida mɨ Ak'õre t'ãri k'awa bɨ. Mãgá ichiaba mɨa mɨchi ovejaarã t'ãri k'awa bɨ mãik'aapa ãrapa pida mɨ t'ãri k'awa p'anɨ. Mɨchi k'ap'ɨa peepiit'ee ãra k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mɨa ichiaba awaraa ovejaarã iru bɨ. Mãgɨ́ ovejaarã nãpemaarã-e, judiorã-e perã. Mamĩda mɨa ichiaba ãra k'aripa k'inia bɨ. Ãrapa ichiaba mɨ pedee ũripataadayada aji. Mapa mɨa ãra p'e bɨit'ee apemaarã mɨchideerã, judiorã mɨde ijãapataarã ome, jõmaweda ak'ɨpari apai jua ek'ari p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Mɨ Ak'õrepa mɨ k'inia iru bapari mɨchi k'ap'ɨa peepiit'ee perã eperãarã pari. Mamĩda waya chok'ai p'irabaiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awaraarãpa mɨ k'ap'ɨa peepida-e pai. Ma k'ãyaara mɨata ãchimaa mɨchi k'ap'ɨa peepiit'ee. Mɨa mãga ooit'ee mãik'aapa waya chok'ai p'irabaiit'ee, mɨ Ak'õrepa mãga jara bairã. Iru jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma pedee ũridak'ãri, judiorã waya k'ĩsia awara-awaraa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ũk'uruurãpa mãgapachida: —¿Sãap'eda parãpa jã eperã pedee ũri p'anɨma? ajida. Iru k'ap'ɨade netuara merãtɨa bɨ mãik'aapa k'ĩra k'awa-ee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mamĩda awaraarãpa mãgapachida: —Eperã k'ap'ɨade netuara merãtɨa bak'ãri, mãga pedeek'aada ajida. ¿Netuarapa tau p'ãriu beerã pia unupiik'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma t'ẽepai k'oijara pak'ãri, judiorãpa fiesta oojida Jerusalén p'uurude. Ma fiesta oopachida k'irãpadait'ee chonaarãwedapema ewari Tachi Ak'õre te waibɨa awara bɨdap'edaa iru-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús mama nipaji Ak'õre te ãuk'idaa, Salomón Pórtico apatap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Maperã judiorã poro waibɨarãpa iru wap'ɨra ata chejida mãik'aapa iidijida: —¿At'ãri tai audú k'ĩsiapimaa iru bait'eek'ã? ajida. Pɨ Tachi Ak'õrepa pëida, Mesías pɨrã, aweda jaráji. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesupa p'anauji: —Naaweda mɨa parãmaa mãga jarajida aji. Mamĩda ijãada-e paji. Mɨa oopari mɨ Ak'õrepa oopi bɨk'a. Oopari ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Ma k'aurepata ijãadaipia bɨ mɨ Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mamĩda parãpa ijãada-e p'anɨ, mɨchideerã-e perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɨchideerãpa mɨ pedee k'awapata mãik'aapa mɨa ãchi k'awapari. Mapa ãchi mɨ t'ẽe nipapata. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɨa ãchi o k'achiadeepa k'aripa atapari atuanaadamerã; jĩp'a ichita chok'ai p'anapataadamerã Tachi Ak'õre ome. Apidaapa ãchi p'oyaa jãri atada-e pai mɨ juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɨ Ak'õrepa ãchimaa mɨde ijãapiji. Iru jõmaarã k'ãyaara waibɨara bɨ. Maperãpɨ apidaapa ãchi p'oyaa jãri atada-e pai iru juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mɨ, mɨ Ak'õre ome abapai. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mãga ũridak'ãri, ma judiorãpa mãu p'e atajida iru bat'a peedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mamĩda Jesupa mãgaji: —Mɨ Ak'õrepa mɨmaa oopiparida aji, ne-inaa pia chok'ara eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ¿Chisãgɨ́ k'aurepata mɨ bat'a pee k'inia p'anɨma aji, mãupa? ");
INSERT INTO sjaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma judiorãpa p'anaujida: —Pɨa ne-inaa pia oo bɨ k'aurepa pɨ bat'a pee k'iniada-eda ajida. Mãga oodait'ee pɨa Tachi Ak'õre ãpɨte ik'achia pedeeda perã. Jaraji pɨ Tachi Ak'õre ome auk'a, pɨ eperã bɨ mĩda taik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mãpai Jesupa mãgaji: —¿Parã ũraa p'ãdade Tachi Ak'õrepa jara bɨ-ek'ã: ‘Mɨa jaraji parã mɨk'a; ak'õre waibɨarã’? ");
INSERT INTO sjaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tachi Ak'õre Ũraa jõk'aa. Maperã p'oyaa merada-e. Ma ũraa p'ãdade Ak'õrepa t'ɨ̃jaraji ‘ak'õre waibɨarã mɨk'a’ iru pedee ũridap'edaarãmaa, parã chonaarãpa mãɨrã awara bɨdap'edaa perã iru-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tachi Ak'õrepa mɨ auk'a awara bɨji mãik'aapa pëiji na p'ek'au eujãdee. Mãga bɨta, ¿sãga parãpa jaradai mɨa ik'achia pedee baji Tachi Ak'õre ãpɨte, jarak'ãri mɨ Tachi Ak'õre Warra? ");
INSERT INTO sjaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Oo-e pɨrã mɨ Ak'õrepa oopi bɨk'a, mãgara ijãanáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mamĩda oo bɨ pɨrã mɨ Ak'õrepa oopi bɨk'a, mɨa jara bɨ ijãada-e p'anɨ mĩda, ijã́atɨ mɨa ooda k'aurepa. Mãgá parãpa wãara k'awaadai mɨ Tachi Ak'õre ome abapai. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mãga ũridak'ãri, waya iru jita atadait'ee paji. Mamĩda Jesús mirudachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Maap'eda Jesús wãji Jordán to k'ĩraik'a eeree. Mama Juanpa naaweda poro choopatamãi beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mama bɨde eperãarã chok'ara irumaa wãjida mãik'aapa ãchi pitapai mãgapachida: —Juanpa oo-e paji ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa, na eperãpa ooparik'a. Mamĩda irua wãarata jarapachi na eperãde. ");
INSERT INTO sjaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Maperãpɨ mama eperãarã chok'ara Jesude ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Eperã, t'ɨ̃jarapatap'edaa Lázaro k'ayaa baji. Ma eperã chi ɨ̃pewẽraarã María, Marta ome Betania p'uurudepema paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(T'ẽepai mãgɨ́ Mariapa k'era weeji Jesús bɨɨrɨ ɨ̃rɨ mãik'aapa Jesús bɨɨrɨ p'ooji ichi pudapa.) ");
INSERT INTO sjaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro k'ayaa bada perã, chi ɨ̃pewẽraarãpa jara pëijida Jesumaa: —Tachi Waibɨa, pɨ k'õp'ãyo k'inia Lázaro k'ayaa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesupa mãga ũrik'ãri, mãgaji chi k'õp'ãyoorãmaa: —Ma k'ayaapa jai-idaaru pɨjida, chok'ai p'irabaiit'ee. Iru k'ayaa bɨ eperãarãpa k'awaadamerã Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ mãik'aapa k'awaadamerã Tachi Ak'õre Warrapa ne-inaa jõma ooi ichi Ak'õrepa oopi bɨk'a. Mãga ook'ãri, jarapataadait'ee Tachi Ak'õre t'ãri pia bapari eperãarã ome; chi Warra jida auk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesupa k'inia p'e iru bapachi Marta, María mãik'aapa Lázaro. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jesumaa jara pëijida mĩda, ichi badamãi k'ãima omé beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Maap'eda mãgaji chi k'õp'ãyoorãmaa: —Waya wãdáma aji, Judea eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","P'anaujida: —Mamĩda Tachi Jarateepari, mak'ɨara taarã-e bɨda ajida, judiorã poro waibɨarãpa pɨ mãupa peedait'ee p'anadap'edaa. ¿Waya jãmaa wã k'inia bɨk'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesupa p'anauji: —¿Ewari doce hora ɨ̃daa nɨ̃bapari-ek'ã? aji. Eperã ãstaawa nipak'ãri, t'ĩutɨk'aa, ɨ̃daa nɨ̃bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mamĩda eperã p'ãrik'ua ni pɨrã, t'ĩutɨpari ɨ̃daa-e bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mãga jarap'eda, Jesupa mãgaji: —Tachi k'õp'ãyo Lázaro k'ãi bɨ. Mamĩda mɨa ɨ̃rɨmat'aanait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chi k'õp'ãyoorãpa p'anaujida: —Tachi Waibɨa, iru k'ãi bɨ pɨrã, jɨpait'eeda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesupa jara k'inia baji Lázaro jai-idaa bɨ. Mamĩda ãrapa k'awada-e p'anajida. K'ĩsiajida jĩp'a k'ãi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mãpai Jesupa jĩp'a mãgaji: —Lázaro jai-idaajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pia bɨ mɨ naaweda wã-e paji, ma k'aurepa ɨ̃rá parãpa waapɨara ijãadait'ee perã Tachi Ak'õrede. Ɨ̃rá wãdáma aji, Lazaromaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mãpai Tomapa (ichiaba t'ɨ̃jarapatap'edaa Me-iso) apemaarãmaa mãgaji: —Wãdáma aji, iru ome, tachi peek'ooruta pɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús pachek'ãri Lázaro bapatamãi, k'ãima k'ĩmari baji ɨadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalendeepa Betania p'uuru perá kilometro õpee baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mamãik'aapa judiorã chok'ara cheepuru p'anajida Marta mãik'aapa María k'õp'ãyaadait'ee, ãra ɨ̃pema jai-idaa bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martapa k'awaak'ãri Jesús cheru, wãji iru k'ĩrachuude. Mamĩda María teeda beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesús unuk'ãri, Martapa mãgaji: —Tachi Waibɨa, pɨ cheda paara, mɨ ɨ̃pema jai-idaa-e pak'ajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mamĩda mɨa k'awa bɨ at'ãri pɨa iidiruta Tachi Ak'õrepa ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesupa mãgaji: —Pɨ ɨ̃pema p'irabaiit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martapa p'anauji: —Mɨa k'awa bɨ na p'ek'au eujã jõdaik'ãri, iru chok'ai p'irabaiit'ee mãik'aapa ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mãpai Jesupa mãgaji: —Mɨa piu beerã waya chok'ai p'anapiparida aji. Chi jai-idaada Ak'õre eujãde ichita chok'ai bapariit'eeda aji, mɨde ijãa bapachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma awara chi chok'ai bɨ jida atua-e. Ichita ɨt'ari banait'eeda aji, ijãa bapari perã. ¿Pɨa mãga ijãa bɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martapa mãgaji: —Ijãa bɨpɨ. Pɨta Mesías, chi na p'ek'au eujãdee cheit'ee bada eperãarã k'aripade. Pɨta Tachi Ak'õre Warra. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mãga jarap'eda, Marta wãji ichi ɨ̃pewẽra Mariamaa mãik'aapa k'ɨɨrɨ ik'aawa mãganaji: —Tachi Waibɨa nama bɨ. Pɨ t'ɨ̃ bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariapa mãga ũrik'ãri, isapai Jesumaa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús waide pana-e baji p'uurude; at'ãri Marta ome unudamãi baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judiorã María ome p'anadap'edaarãpa ichi isapai uchiaru unudak'ãri, iru t'ẽe wãjida, wãit'ee jĩak'aapa jẽede Lázaro ɨadap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mamĩda Mariapa Jesús unuk'ãri, bedabaidachi mãik'aapa mãgaji: —Tachi Waibɨa, pɨ nama bada paara, mɨ ɨ̃pema jai-idaa-e pak'ajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesupa unuk'ãri María chi che p'anadap'edaarã ome jẽe para nɨ̃bɨ, t'ãri p'ua nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mãpai iidiji: —¿Sãma ɨajidama? aji. P'anaujida: —Chepáde ajida, ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús jẽedachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mãga unudak'ãri, judiorãpa mãgajida: —¡Ak'ɨ́tɨ! ¡Mãgara Lázaro k'inia iru baji! ");
INSERT INTO sjaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mamĩda mãɨrã ũk'uruurãpa mãgajida: —Na Jesupa tau p'ãriu beerã pia unupipari. Maperã ¿Lázaro jɨpak'aji-ek'ã ajida, jai-idaanaamerã? ");
INSERT INTO sjaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lázaro piuda k'aurepa Jesús at'ãri t'ãri p'ua nɨ̃bɨde, panaji Lázaro ɨadap'edaamãi. Mãu te uria baji mãik'aapa chi t'ai jɨ̃a nɨ̃baji mãu choma bɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mapa Jesupa mãgaji: —Jã mãu ãyaa ata bɨnadapáde aji. Mãpai Marta, chi piuda ɨ̃pewẽrapa mãgaji: —Mamĩda Tachi Waibɨa, ɨ̃rá iru k'ap'ɨa mik'ia jo nɨ̃bɨda aji, k'ãima k'ĩmari bairã ɨadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mãpai Jesupa mãgaji: —¿Mɨa pɨmaa jaraji-ek'ã? aji. Ijãa bɨ pɨrã, Ak'õrepa ne-inaa pia ooit'ee eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mãpai chi mãu ãyaa ata bɨjida. Maap'eda Jesús ɨt'aa ak'ɨji mãik'aapa mãgaji: —Ak'õre, gracias mɨa chupɨria iidida ũrida perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","K'awa bɨ mɨa iidipari chaa pɨa ũripari. Mamĩda na pedee jararu na eperãarãpa ũridamerã mãik'aapa ijãadamerã pɨa mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mãga jarap'eda, Jesupa golpe biaji: —¡Lázaro, uchíaji jãmãik'aapa! ");
INSERT INTO sjaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mãpai chi jai-idaa bada uchiaji. Ichi k'ap'ɨa jõma at'ãri pɨra baji p'arupa; chi jua, jĩru paara. Ichiaba ichi poro pɨra baji p'arupa. Mapa Jesupa mãgaji: —Iru ɨa bada p'aru ẽrat'aadapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesupa ooda unudak'ãri, judiorã chok'ara María ome wã p'anadap'edaarãpa irude ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mamĩda mãɨrãdepema ũk'uru fariseorãmaa wãjida Jesupa ooda nepɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mapa ma fariseorã p'aareerã poroorã ome t'ɨ̃ pëijida Junta Supremadepemaarã mãik'aapa mãgajida: —¿K'ãata oodait'eema? ajida. Jã eperãpa oomaa bɨ ne-inaa chok'ara eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ita-aria bɨrutara, jõmaarãpa irude ijãadai. Mãgara Romadepemaarã chedayada ajida, Tachi Ak'õre te waibɨa t'eet'aade mãik'aapa tachi auk'aarã jõt'aade. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Judío t'ɨ̃jarapatap'edaa Caifás p'aareerã poro waibɨa paji ma añode. Ichia mãgaji: —Parãpa maarepida k'awada-e p'anɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Piara bɨ eperã aba piumerã tachi p'uuru pidaarã pari, tachi p'uuru pidaarã jõmaweda piudai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mamĩda Caifapa mãga jara-e paji ichi k'ĩsiadoopa. Ma añode p'aareerã poro waibɨa pada perã, Tachi Ak'õrepa ne-inaa p'asait'ee bada ichimaa jarapiji. Maperãpɨ ichia jaraji Jesús piut'ee ãchi p'uuru pidaarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mamĩda wãara ma eujãdepemaarã-it'ee aupai piu-e pait'ee paji. Ichiaba piut'ee paji eperãarã jõmaarã pari, chi Tachi Ak'õrede ijãapataadait'eerã awara-awaraa eujãde p'anapataarã pari. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifapa mãga jarada ewatedeepa judiorã poroorãpa pedeeteepachida Jesús peedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Maperã Jesús judiorã t'ãide tau taawa nipak'aa paji naawedapemak'a. Mamãik'aapa wãji eujã pania wẽe bɨ k'ait'a, eperãarã mak'ɨara p'anadak'aa p'uurude. Mãgɨ́ p'uuru t'ɨ̃jarapachida Efraín. Mama beeji chi k'õp'ãyoorã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma t'ẽepai judiorã Pascua fiesta ɨ̃rɨ pak'ãri, eperãarã chok'ara awara ãiipa chejida Jerusalendee Tachi Ak'õre Ũraa p'ãdade jara bɨk'a oodait'ee mãik'aapa pia p'anadait'ee iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mama p'anɨde ma eperãarã Jesús jɨrɨ nipapachida mãik'aapa Tachi Ak'õre te waibɨade pedee para baji ãchi k'õp'ãyoorã ome: —¿K'ãata k'ĩsia p'anɨma? ajida. ¿Iru cheipaa na fiestade wa mãga-e? ");
INSERT INTO sjaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mamĩda fariseorãpa mãik'aapa p'aareerã poroorãpa Jesús jita atapi k'inia p'anapachida. Mapa jarajida apidaapa Jesús unuruta pɨrã, ãchimaa jara chedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ewari seis falta bak'ãri Pascua fiesta oodait'ee, Jesús wãji Betania p'uurudee, Lázaro bapatamãi. Ma Lázaro paji Jesupa chok'ai p'irabaipida. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mama bɨde k'ewara Jesumaa nek'opijida. Martapa jedepachi. Jõdee Lázaro Jesús ome nek'omaa baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mãɨmisa Mariapa aneeji k'era ɨ̃pɨa nardodee ooda. Litro k'audaa baji. Ma k'era Jesús bɨɨrɨ ɨ̃rɨ weet'aaji mãik'aapa ichi pudapa p'oot'aaji. Te jã t'ũa jo nɨ̃beeji k'erapa. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mãpai Jesús k'õp'ãyo, Judas Iscariote, Jesús traicionaait'ee badapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Jã k'era ichi k'inia weemaa bɨda aji. Netot'aak'aji trescientos denarios pari mãik'aapa chupɨria beerã k'aripak'aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mamĩda Judapa mãga jara-e paji chupɨria beerã k'aripa k'inia bada perã. Ma k'ãyaara mãga jaraji nechɨayaa bada perã. Ichia ãra p'arat'a anipapachi mãik'aapa aɨdepema chɨa atapachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mãpai Jesupa mãgaji: —Ita-aria bɨ́ji. Irua nãgɨ́ k'era ɨa iru bajida aji, mɨ ɨaruta ewatepema-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chupɨria beerã ichita paraait'ee parã t'ãide. Mamĩda mɨ parã ome ichita ba-e pait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ũridak'ãri Jesús Betania p'uurude bɨ, judiorã chok'ara wãjida iru ak'ɨde. Ichiaba wãjida Lázaro ak'ɨde, Jesupa iru chok'ai p'irabaipida perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Maperã p'aareerã poroorãpa pedeeteejida Lázaro ichiaba peet'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","K'ĩsiajida Jesupa iru p'irabaipida k'aurepa judiorã chok'ara ãchi ũraade ijãadaamaa p'aneeruta Jesude ijãadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Aɨ norema eperãarã chok'ara, chi wã p'anadap'edaarãpa k'awaajida Jesús Jerusalendee Pascua fiesta oode cheru. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mapa t'ap'uru k'iru t'ɨap'edap'eda, wãjida iru auteebaidait'ee mãik'aapa biapachida: —‘¡Hosana! ¡Tachi K'aripapari cheru Tachi Ak'õre k'ap'ɨa pari! ¡Tachi Ak'õrepa iru pia ak'ɨji mãik'aapa pëiji Israel pidaarã Rey pamerã!’ ");
INSERT INTO sjaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesupa burro chak'e atapiji mãik'aapa bataudachi aɨ ɨ̃rɨ, Ak'õre Ũraa p'ãdade jara bɨk'a: ");
INSERT INTO sjaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Sión p'uurudepemaarã, waweenáatɨ. ¡Ak'ɨ́tɨ! Pãchi Rey cheru burro chak'e ɨ̃rɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chi k'õp'ãyoorãpa k'awada-e paji ma pedee p'ãda k'ãata jara k'inia bɨ. Mamĩda Jesús ɨt'aa wãda t'ẽepai k'irãpajida ma pedee mãik'aapa Jesús p'asada. Mãpai k'awaajida ma pedee p'ãda irude jara baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesupa Lázaro p'irabaipida unudap'edaarãpa irua ooda jõmaarãmaa nepɨrɨpachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mapa eperãarã chok'ara wãjida Jesús ome unudait'ee. Mãgá wã k'inia p'anajida ũridap'edaa perã irua ne-inaa ooda eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseorã ũk'uruurãpa mãga unudak'ãri, ãchi k'õp'ãyoorãmaa mãgajida: —¿Parãpa unu p'anɨk'ã? ajida. ¡Iru maarepida p'oyaada-e pai! ¡Jõmaarãta irude ijãa wãdada! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua fiesta pai naaweda, eperãarã wãpachida Jerusalendee ɨt'aa t'ɨ̃de Tachi Ak'õremaa. Ma wãdap'edaarã t'ãide p'anajida judio-eerã, judiorã ũraade ijãadap'edaarã. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mãɨrã Felipemaa wãjida. Mãgɨ́ Felipe Betsaida p'uurudepema paji. Mãgɨ́ p'uuru Galilea eujãde bɨ. Ma judio-eerãpa mãgajida irumaa: —Señor, taipa Jesús unu k'inia p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mãpai Felipepa nepɨrɨnaji Andreemaa. Maap'eda ãchi omé wãjida Jesumaa nepɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ũrik'ãri judio-eerãpa iru jɨrɨmaa p'anɨ, Jesupa mãgaji: —Ewari paruda aji, Eperã Ak'õre Truadepema ɨt'aa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mɨa wãarata jararu. Eperãpa trigo tau apai iru bɨta, mãgɨ́ tau uu-e pɨrã, tau apai iru bait'ee. Jõdee mãgɨ́ tau uuru pɨrã, baaip'eda yoorode piu pɨk'a bɨ mĩda, madeepa trigo k'arra chiwidi t'onopari mãik'aapa warip'eda, chaupari. Mãgá tau apaideepa chok'ara uchiadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na p'ek'au eujãde bɨ misa, eperãpa jɨrɨru pɨrã ooit'ee ichia oo k'iniata, ichi piuk'ãri atuait'ee. Mamĩda na p'ek'au eujãde bɨ misa, eperãpa jɨrɨru pɨrã ooit'ee Tachi Ak'õrepa k'inia bɨk'a, ma k'aurepa ichita chok'ai bapariit'ee Tachi Ak'õre ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Apidaapa oo k'inia bɨ pɨrã mɨa oopi bɨk'a, mãgɨ́ nipaipia bɨ mɨ ome mɨ wãrumaa. Mãga ooru pɨrã, mɨ Ak'õrepa iru pia ak'ɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Ɨ̃rá mɨ t'ãri p'ua nɨ̃bɨda aji. ¿K'ãata jaraima? ¿Nãga jaraik'ã: “Ak'õre, mɨ k'aripáji nãgá banaamerã”? Ma-it'ee mɨ cheji, chupɨria chait'ee. Mapa mɨa jara bɨ mɨ Ak'õremaa: ");
INSERT INTO sjaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Ak'õre, ak'ɨpíji wãara pɨ jõmaarã k'ãyaara waibɨara bɨ. ¡Óoji pɨchia oo k'iniata!” Mãpai arii p'anadap'edaarãpa ũrijida ɨt'ariipa jara bɨ: —Mɨa mãga ak'ɨpidoo pɨ k'ap'ɨa pari mãik'aapa waya mãga ak'ɨpiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eperãarãpa mãgɨ́ pedee ũridak'ãri, k'ĩsiajida pata k'ĩrau nɨ̃bɨ. Mamĩda mãɨrã ũk'uruurãpa mãgajida: —Ɨt'aripema ángel paji. Mãgɨ́pata pedeejida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mãpai Jesupa mãgaji: —Jã pedee ũridap'edaa, mɨ-it'ee-e pajida aji. Parã-it'eeta paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ɨ̃rapɨ Tachi Ak'õrepa k'awapiit'ee na p'ek'au eujãdepemaarãpa k'achia oopata. Ɨ̃rapɨ Tachi Ak'õrepa p'oyaait'ee na p'ek'au eujãdepemaarã poro waibɨa Satanás. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mamĩda mɨchi k'ap'ɨa kurusode jira atadak'ãri eujãdeepa, eperãarãpa mɨde ijãa p'aneedait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mãga jarak'ãri, Jesupa jara k'inia baji ichi sãgá piut'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mãpai eperãarãpa p'anaujida: —Tai ũraade jara bɨ Mesías ichita bapariit'ee. ¿Sãga pɨa jaraima Eperã Ak'õre Truadepema kurusode jiradait'ee? ¿K'aima ma Eperã Ak'õre Truadepema? ");
INSERT INTO sjaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesupa mãgaji: —Mɨ, chi ɨ̃daa pɨk'a bɨ mak'ɨara taarã-e parã ome. Nipapatáatɨ mɨ ɨ̃daa pɨk'a bɨde p'ãriu pɨk'a bɨde t'ĩunaadamerã. Chi p'ãriu pɨk'a bɨde nipaparipa k'awa-e bɨ sãmaa wãru. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mɨ, chi ɨ̃daa pɨk'a bɨ parã ome bɨ misa, mɨde ijãapatáatɨ. Mɨa Tachi Ak'õrepa wãarata jara pëida jarateepari, parãpa ma pedee ijãadap'eda, iru warrarã p'aneedamerã. Mãga jarap'eda, Jesús ãyaa wãji ichi ununaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesupa ne-inaa eperãarãpa p'oyaa oodak'aa ãchi taide oopachi mĩda, judiorã chok'araarãpa irude ijãadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mãga paji wãara uchiamerã nãgɨ́ pedee Ak'õre pedee jarapari Isaíapa p'ãdade jara bɨk'a: ‘Tachi Ak'õre, ¿k'aipa ijãajima aji, taipa jarateedap'edaa? ¿K'aimaa pɨa ooda ak'ɨpijima?’ ");
INSERT INTO sjaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaíapa p'ãdade ichiaba jara bɨ ãchia p'oyaa ijãadak'aa paji nãga perã: ");
INSERT INTO sjaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Tachi Ak'õrepa ãchi tau p'ãriu pɨk'apiji irua ooda ak'ɨ p'anɨ mĩda, ununaadamerã. Ma awara k'ɨɨrɨ k'isua pɨk'apiji irua jarada ũri p'anɨ mĩda, k'awanaadamerã mãik'aapa irumaa chenaadamerã, irua ãchia p'ek'au k'achia oopata wẽpapimerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaíapa mãga jaraji, k'ãimok'araa pɨk'a bɨde Jesús unuda perã Tachi Ak'õre k'ĩra wãree eujãde. Maperãpɨ Jesude pedee baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isaíapa jaradak'a wãara uchiaji mĩda chok'araarã ome, judiorã ũk'uruurãpa Jesude ijãajida; ichiaba ãchi poroorã ũk'uruurãpa pida ijãajida. Mamĩda fariseorã waidoopa mãɨrãpa ijãadap'edaa eperãarã taide jaradak'aa paji. Waawee p'anajida fariseorãpa ãchi t'ĩupida-e pai jĩak'aapa Tachi Ak'õre Ũraa jarateepata tede. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Audupɨara k'inia p'anapachida ãchi auk'aarãpa ãchi ak'ɨdamerã judiorã pia beerãk'a, k'inia p'anadai k'ãyaara Tachi Ak'õrepa ãchi ak'ɨmerã ichideerãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Maap'eda Jesupa golpe pedeeji judiorã arii p'anadap'edaarãmaa: —Chi mɨde ijãa bɨ mɨdepai ijãa-e bɨda aji. Ichiaba mɨ Ak'õrede ijãa bɨ, iruata mɨ na p'ek'au eujãdee pëida perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chi mɨ unu bɨpa ichiaba mɨ pëida unu bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mɨta chi ɨ̃daa pɨk'a bɨ. Mɨ cheji na p'ek'au eujãdee mɨde ijãapataarã p'ananaadamerã p'ek'au oopataarã p'anapatak'a p'ãriu pɨk'a bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Eperãpa mɨ ũraa ũrip'eda, made jara bɨk'a oo-e pɨrã, mɨa jara-e ma eperã atuait'ee. Mɨ che-e paji na p'ek'au eujãdepemaarã atuapiit'ee. Ma k'ãyaara mɨ cheji eperãarã o k'achiadeepa k'aripa atade. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eperãpa mɨ yiaraa iru bɨ pɨrã mɨ ũraa ũri k'inia-e bairã, Tachi Ak'õre ewari waibɨa ewate ichia mãgɨ́ eperã miapiit'ee. Mɨa jarada k'aurepa irua eperãarãpa oopata ak'ɨit'ee k'awaait'ee ijãapachida wa ijãadak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mɨchi k'ĩsiadoopa pedee-e bajida aji. Mɨ Ak'õre, mɨ na eujãdee pëidapa ma pedee jõma mɨmaa jarapiji. Irua jaraji mɨa pedeeit'ee mãik'aapa jarateeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mɨa k'awa bɨ jõmaweda mɨ Ak'õrepa mɨmaa jarapiru, mãga jara bɨ eperãarãpa ijãadamerã mãik'aapa ɨt'aa wãdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiesta ewate pai naaweda, Jesupa k'awa baji ewari awara bɨda ichi na p'ek'au eujãdeepa uchiait'ee mãik'aapa ichi Ak'õremaa wãit'ee; mãgɨ́ ewari paru. Ichia chi k'õp'ãyoorã na p'ek'au eujãde p'anɨ k'inia iru bapachi. Mãgá ãchi k'inia iru bapachi ichi piurumaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Aɨ k'ewara Pascuadepema chik'o jedei naaweda, Netuara Poro Waibɨapa k'ĩsia k'achia k'ĩsiapiji Judas, Simón Iscariote warramaa, ichia Jesús traicionaamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mamĩda Jesupa k'awa baji ichi Tachi Ak'õredeepa cheda mãik'aapa Ak'õremaa wãit'ee. Ichiaba k'awa baji Tachi Ak'õrepa ne-inaa jõmaweda bɨji ichi jua ek'ari. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mapa nek'omaa p'anɨde Jesús bainɨ̃ beeji mãik'aapa ichi ɨ̃rɨpema p'aru jɨ̃ bada ẽrat'aap'eda, ãyaa bɨji. Maap'eda toalla jɨ̃ nɨ̃bɨji ichi k'ɨrrɨde, mimiapataarãpa oopatak'a chĩara bɨɨrɨ sɨɨdait'ee pak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mãpai jarrade pania wee atap'eda, chi k'õp'ãyoorã bɨɨrɨ sɨɨmaa beeji. Maap'eda ma toallapa p'ook'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mamĩda Simón Pedro bɨɨrɨ sɨɨnait'ee pak'ãri, irua mãgaji: —Tachi Waibɨa, ¿mɨ bɨɨrɨ paara sɨɨit'eek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesupa p'anauji: —Ɨ̃rá pɨa k'awa-e bɨda aji, mɨa oomaa bɨ. Mamĩda t'ẽepai k'awayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mãpai Pedropa mãgaji: —¡Mɨ bɨɨrɨ sɨɨpi-eda! aji. Jesupa p'anauji: —Pɨ bɨɨrɨ sɨɨpi k'inia-e bɨ pɨrã, mãgara waa nipanaapáde aji, mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mãpai Simón Pedropa mãgaji: —¡Tachi Waibɨa, mãgara mɨ bɨɨrɨ aupai sɨɨnaapáde aji. Ichiaba mɨ jua mãik'aapa poro paara sɨɨpáde! aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mamĩda Jesupa p'anauji: —Eperã ewaa k'uip'eda mãik'aapa taawaa uchiap'eda, waya k'ui-eda aji. Chi bɨɨrɨ aupaita sɨɨpari, k'ap'ɨa jõma t'ãu-ee bairã. Mãga pɨk'a parã t'ãu-ee pɨk'a p'anɨ p'ek'au k'achiapa. Mamĩda parã jõmaweda mãga p'anɨ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesupa mãga jaraji k'awa bada perã k'aipa ichi traicionaait'ee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chi k'õp'ãyoorã bɨɨrɨ sɨɨp'eda, waya ichi ɨ̃rɨpema p'aru jɨ̃ beeji. Maap'eda mesade su-ak'ɨ beeji mãik'aapa mãgaji: —¿Parãpa k'awa p'anɨk'ã aji, k'ãata jara k'inia bɨ mɨa et'ewa ooda? ");
INSERT INTO sjaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Parãpa mɨmaa “Jarateepari” mãik'aapa “Tachi Waibɨa” apata. Mãga jaradak'ãri, wãarata jara p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mɨ parã Waibɨa mãik'aapa parã Jarateepari bɨ mĩda, parã bɨɨrɨ sɨɨji. Mapa parãpa pida pãchi k'õp'ãyoorã bɨɨrɨ sɨɨdaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mɨa mãga ooji parãpa auk'a oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mɨa wãarata jararu. Mimiapari ichi poro waibɨa k'ãyaara waibɨara bɨ-e. Ichiaba chok'a pëida iru pëida k'ãyaara waibɨara bɨ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Parãpa mɨa et'ewa jarada ũrijida. Ma jaradak'a ooruta pɨrã, t'ãri o-ĩa p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mamĩda mãga-e pait'ee parã jõmaarã ome. Mɨa k'awa bɨ mɨ k'õp'ãyoorã jɨrɨt'erada. Mapa ichiaba k'awa bɨ wãara p'asait'ee Tachi Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Mɨ ome nek'orupa mɨ peepit'aait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ɨ̃rá mɨa mãga jara bɨ mãga p'asak'ãri, parãpa wãara ijãadamerã Mɨta, Tachi Ak'õrepa pëida eperãarã k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mɨa wãarata jararu. Chi mɨa pëida auteebairupa mɨ jida auteebai bɨ. Mãga pɨk'a chi mɨ auteebairupa mɨ Ak'õre, mɨ pëida, auk'a auteebai bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mãga jarap'eda, Jesús t'ãri p'ua nɨ̃beeji. Mãpai mãgaji: —Mɨa wãarata jararu. Parãdepema abaapa mɨ traicionaait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jesupa mãga jarak'ãri, chi k'õp'ãyoorã ak'ɨ trua para beeji, k'awada-e p'anadap'edaa perã k'aita jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mãɨrãdepema aba, Jesupa audú k'inia iru bada, iru ik'aawa sĩu-ak'ɨ baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mapa Simón Pedropa taupa jarapachi mãgɨmaa iidimerã k'aipata Jesús traicionaait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mãpai mãgɨ́ k'õp'ãyopa k'ɨɨrɨ ik'aawa iidiji Jesumaa: —Tachi Waibɨa, ¿k'aima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesupa p'anauji: —Nãgɨ́ pan pite sã atak'ãri, mɨa teeit'eeda aji, mãgɨmaa. Aramata Jesupa ma pan pite sã ataji mãik'aapa teeji Judamaa. Mãgɨ́ Judas Simón Iscariote warra paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judapa mãgɨ́ pan jitak'ãri, Satanás iru t'ãride t'ĩudachi. Mãpai Jesupa mãgaji: —Pɨchia ooit'ee bɨ isapai oopáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mamĩda Jesús ome nek'omaa p'anadap'edaarãpa k'awada-e paji sãap'eda mãga jaraji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judapa ãchi p'arat'a anipapachi perã, ũk'uruurãpa k'ĩsiajida Jesupa jara baji ne-inaa netonamerã fiesta-it'ee, maa-e pɨrã chupɨria beerãmaa ne-inaa teenamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judapa ma pan jitap'eda, uchiadachi taawaa. P'ãrik'ua paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas taawaa uchiada t'ẽepai, Jesupa mãgaji: —Ɨ̃rá Tachi Ak'õrepa ichi k'ĩra wãree unupiit'ee, mɨ chi Eperã Ak'õre Truadepema k'ap'ɨa pari. Mɨ k'aurepa jõmaarãpa wãara k'awaadait'ee Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mɨa mãga ak'ɨpik'ãri, taarã-e nɨde Tachi Ak'õrepa ichiaba ak'ɨpiit'ee mɨ wãara irua pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","’Warrarã, naapai mɨ taarã-e parã ome. Parãpa mɨ jɨrɨdayada aji. Mamĩda unuda-e pait'ee. Mɨa judiorã poro waibɨarãmaa jaradak'a parãmaa auk'a jarait'ee; p'oyaa wãda-e mɨ wãrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Parãmaa ũraa chiwidi jararu. Chik'inia p'anapatáatɨ. Mɨa parã k'inia iru baparik'a, mãgá parã jida chik'inia p'anapatáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mãgá chik'inia p'anaruta pɨrã, jõmaarãpa k'awadayada aji, parã mɨ k'õp'ãyoorã. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mãpai Simón Pedropa Jesumaa iidiji: —Tachi Waibɨa, ¿sãmaa wãit'eema? aji. Jesupa p'anauji: —Mɨ wãrumaa waide pɨ p'oyaa wã-eda aji. Mamĩda t'ẽepai wãit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedropa mãgaji: —Tachi Waibɨa, ¿sãap'eda mɨ pɨ t'ẽe wã-e payama? aji. ¡Pɨ ome wã k'inia bɨ, pɨ k'aurepa piuru pɨjida! ");
INSERT INTO sjaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mãpai Jesupa p'anauji: —¿Wãara pɨchi k'ap'ɨa peepit'aaik'ã aji, mɨ k'aurepa? Mɨa wãarata jararu. Et'erre k'arii naaweda, jarada õpee pɨa mɨ k'awa-e bɨda ait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—K'ĩsia paraa p'ananáatɨ. Ma k'ãyaara ijãapatáatɨ Tachi Ak'õrede mãik'aapa mɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mɨ Ak'õre eujãde te chok'ara paraada aji, ichideerã-it'ee. Mãga-e pada paara, mɨa jarak'aji. Parã naa wãit'ee te pi-ia oode parã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma t'ẽepai mɨ waya cheit'ee parã atade, mɨ ome p'ananadamerã mɨ baparimaa. Mãgá parã ichita p'anapataadait'ee mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mɨ wãrumaa parãpa k'awa p'anɨda aji, chi o k'awa p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mãpai Tomapa mãgaji Jesumaa: —Tachi Waibɨa, k'awada-e p'anɨda aji, pɨ sãmaa wãru. ¿Sãga chi o k'awadayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesupa p'anauji: —Mɨta Tachi Ak'õre truadee wãpari ok'a bɨ. Mɨata Tachi Ak'õre wãarata jarapari. Mɨata eperãarã chok'ai p'anapipari ichita p'anapataadamerã Tachi Ak'õre ome. Mɨ awara apidaapa eperãarã wãpida-e pai Tachi Ak'õremaa. Mapa mɨdepai ijãadak'ãri, mɨ Ak'õremaa wãdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Parãpa wãara mɨ k'awada paara, ichiaba mɨ Ak'õre k'awak'ajida. Wãara, ɨ̃raweda iru k'awadait'ee, iru unupata perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mãpai Felipepa mãgaji: —Tachi Waibɨa, Ak'õre Waibɨa k'ĩra taimaa ak'ɨpipáde aji. Mãgapaita k'inia p'anɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesupa p'anauji: —Felipe, mɨ taarã nipapari parã ome. Mãga bɨta, ¿waide mɨ k'awa-e bɨk'ã? aji. Chi mɨ unuparipa ichiaba Ak'õre Waibɨa unupari. ¿Sãga pɨa “Ak'õre Waibɨa k'ĩra ak'ɨpipáde” ayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ijãa-e bɨk'ã aji mɨ, Ak'õre Waibɨa ome araa bapari? Mɨ araa bapari iru Jaure ome; jõdee iru araa bapari mɨ k'ap'ɨa ome. Mɨa jaramaa bɨ mɨchi k'ĩsiadoopa jara-e bɨda aji. Mɨ Ak'õrépata mãga jarapi bɨ. Ma awara mɨa ne-inaa oo bɨ ook'aa mɨchi juadoopa. Mɨ Ak'õrépata mãga oopi bɨ, mɨ ome bapari perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ijã́atɨ mɨa jarak'ãri mɨ, Ak'õre Waibɨa ome araa bapari. Maa-e pɨrã ijã́atɨ mɨa ne-inaa ooda k'aurepapai, oopari perã ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mɨa wãarata jararu. Chi mɨde wãara ijãa bɨpa auk'a ooyada aji, mɨa ne-inaa oo bɨk'a. Ma awara ne-inaa pi-iara ooyada aji, mɨ wãit'ee perã mɨ Ak'õre bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mɨa oopariit'ee jõmaweda parãpa ɨt'aa iidiruta mɨ t'ɨ̃de mɨchideerã perã. Mãgá iru Warra k'aurepa jõmaarãpa unudai Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Parã mɨchideerã perã, mɨ t'ɨ̃de ɨt'aa iididak'ãri, mɨa nejõmaata oopariit'eeda aji, parãpa iidi p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Parãpa mɨ k'inia iru p'anɨ pɨrã, oopataadait'eeda aji, mɨ ũraade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mãpai mɨa chupɨria iidiit'ee mɨ Ak'õremaa, irua awaraa K'aripapari pëimerã mɨ pari, mãgɨ́ ichita parã ome bapariimerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mãgɨ́ Tachi Ak'õre Jaure. Ichia wãara aupaita jarateepari. Ijãadak'aa beerã ome iru ba che-e, iru unuda-e p'anadairã mãik'aapa k'awada-e p'anadairã. Mamĩda parã́pata iru k'awa p'anɨ, parã ome bapari perã mãik'aapa parã t'ãride bapariit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Mɨa parã chupɨria atabëi-eda aji. Waya cheit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taarã-e na p'ek'au eujãdepemaarãpa mɨ waa unuda-e pait'ee. Mamĩda parã́pata mɨ unudait'ee. Mɨ ichita chok'ai bapari perã, parã jida auk'a ichita chok'ai p'anapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Maapai parãpa wãara k'awaadait'ee mɨ, Tachi Ak'õre Waibɨa ome araa bapari mãik'aapa parã mɨ ome ichiaba araa p'anapataadait'ee, t'ãri a-ba. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chi mɨ ũraa ũri bɨpa mãik'aapa oo bɨpa ma ũraade jara bɨk'a wãara mɨ k'inia iru bɨ. Mɨ Ak'õrepa mãgɨ́ eperã ichiaba k'inia iru bapariit'ee. Ma awara mɨa pida iru k'inia iru bapariit'ee mãik'aapa irumaa unupiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mãpai Judas, chi Simón Iscariote warra-ee badapa iidiji: —Tachi Waibɨa, ¿sãap'eda pɨa taimaa unupiit'eema aji, mamĩda ijãadak'aa beerãmaa unupi-e pait'ee? ");
INSERT INTO sjaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesupa p'anauji: —Eperãpa mɨ k'inia iru bɨ pɨrã, mɨ ũraade jara bɨk'a oopariit'eeda aji. Mɨ Ak'õrepa mãgɨ́ eperã k'inia iru bapariit'ee mãik'aapa mɨ Ak'õre mɨ ome chedait'ee iru ome p'anapataade. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jõdee chi mɨ k'inia-e bɨpa oo k'inia-e bɨ mɨ ũraade jara bɨk'a. Na pedee parãpa ũri p'anɨ mëre-eda aji; mɨ Ak'õrede. Iruata mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mɨa na ũraa jara bɨda aji, parã ome bɨ misa. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mamĩda mɨ uchiada t'ẽepai, Ak'õre Waibɨapa pëiit'ee awaraa K'aripapari mɨ pari; mãgɨ́ iru Jaure. Mãgɨpa ne-inaa jõmaata jarateeit'ee parãpa oodamerã mɨa oopi bɨk'a. Ma awara irua k'aripait'ee mɨa jarada jõmaweda k'irãpadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mɨ wãi naaweda, parã t'ãri k'ãiweepi k'inia bɨ. T'ãri k'ãiwee p'anapatáatɨ. Mɨa arak'atɨapai k'ãiwee p'anapi-e, na p'ek'au eujãdepemaarãpa oopatak'a. Mapa t'ãri p'ua p'ananáatɨ mãik'aapa p'eranáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Parãpa ũrijida mɨa jarak'ãri: “Mɨ wãit'ee, maap'eda waya cheit'ee.” Parãpa wãara mɨ k'inia iru p'anadap'edaa paara, t'ãri o-ĩa p'anak'ajida mɨa nãga jarak'ãri. O-ĩa p'anadaipia bɨ mɨ wãru perã Ak'õre Waibɨamaa; mɨ k'ãyaara waibɨara bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma jõma p'asai naaweda, mɨa mãga jaraji, p'asak'ãri, parãpa mɨ pedee ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Waa mak'ɨara pedee-e pait'ee parã ome, Satanás, na p'ek'au eujãdepemaarã poro waibɨa, cheru perã. Ichia mɨ p'oyaa chok'ak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mamĩda na p'ek'au eujãdepemaarãpa k'awaadamerã mɨa Ak'õre Waibɨa k'inia iru bapari, ooit'ee irua jara bɨk'a. ’P'irabaidapáde aji. Ãyaa wãdáma namãik'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Uchiadai naaweda, Jesupa mãgaji: —Mɨ uva k'arrak'a pipɨara bɨda aji. Jõdee mɨ Ak'õre chi uva uuda ak'ɨparik'a bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mɨ k'arradepema jɨ̃k'ara chau-e bɨ pɨrã, irua mãgɨ́ jɨ̃k'ara t'ɨap'et'aapari. Jõdee chi jɨ̃k'ara chauparidepema jua chak'eerã jarit'aapari mãgɨ́ jɨ̃k'ara waapɨara chaumerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Parã mãgɨ́ jɨ̃k'ara jaridák'ata p'anɨ mɨa ũraa jarada ijãadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mɨ ome araa p'anapatáatɨ mɨ parã ome araa baparik'a. Uva jɨ̃k'ara ichi itu chauk'aa chi k'arra ome araa ba-e pɨrã. Mãga pɨk'a pãchi k'ĩradoopa mɨa oopi bɨk'a p'oyaa ooda-e, mɨ ome araa p'anapataada-e pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Mɨda aji, uva k'arrak'a bɨ. Jõdee parã chi jɨ̃k'arák'ata p'anɨ. Uva jɨ̃k'ara pia chauparik'a araa bak'ãri chi k'arra ome, mãga pɨk'a parã mɨ ome araa p'anapataadak'ãri, ne-inaa chok'ara mɨa oopi bɨk'a oopataadait'ee. Mamĩda mɨ wẽe parãpa maarepida ooda-e pai mɨa oopi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uva jɨ̃k'ara chauk'aa bak'ãri, t'ɨap'ek'oodap'eda, p'e nɨ̃bɨpata ak'õrejĩrumaa p'ook'oodaimerã. Maap'eda t'ɨpɨtaude bat'ak'oopata paak'oodaimerã. Mãga pɨk'a pait'ee chi mɨ wẽe beerã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mamĩda parã araa p'anaruta pɨrã mɨ ome mãik'aapa mɨ ũraade jara bɨk'a ooruta pɨrã, ɨt'aa iidipatáatɨ pãchia iidi k'iniata. Mɨ Ak'õrepa ooit'ee parãpa iidi p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Parãpa ne-inaa chok'ara mɨa oopi bɨk'a oodak'ãri, ak'ɨpipata wãara mɨ k'õp'ãyoorã. Mãga unudak'ãri, awaraarãpa “Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨda” adait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mɨ Ak'õrepa mɨ k'inia iru baparik'a, mɨa auk'a parã k'inia iru bapari. Mɨ ome chik'inia p'anapatáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mɨ, mɨ Ak'õre ome chik'inia bapari, mɨa oopari perã irua jara bɨk'a. Mãgá parã mɨ ome chik'inia p'anapataadait'ee, mɨa jara bɨk'a ooruta pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mɨa mãga jaraji mɨk'a parã t'ãri o-ĩa p'anapataadamerã. K'inia bɨ parã t'ãri o-ĩa p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mɨa nãga jara bɨ: Chik'inia p'anapatáatɨ, mɨa parã k'inia iru baparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Eperãpa chi k'õp'ãyo audú k'inia iru bak'ãri, iru k'aripapari ma k'aurepa piuru pɨjida. Ma k'ãyaara apidaapa awaraa eperã audupɨara k'inia iru p'anada-e pai. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Parã wãara mɨ k'õp'ãyoorã, mɨ ũraa jara bɨk'a oo wãruta pɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Waa mɨa parã t'ɨ̃jara-e “mimiapataarã”, mimiaparipa k'awa-e bairã ne-inaa jõmaweda chi poropa oo bɨ. Ma k'ãyaara t'ɨ̃jara bɨ “mɨchi k'õp'ãyoorã” mɨa k'awapida perã jõmaweda mɨ Ak'õrepa mɨmaa jarada. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Parãpa mɨ jɨrɨt'erada-e paji. Mɨata parã jɨrɨt'eraji mãik'aapa awara bɨji mɨ ũraa jarateenadamerã. Mãgá parã k'aurepa eperãarãpa ma ũraa ũridap'eda, mɨde ijãadai mãik'aapa ichita p'anapataadai mɨ ome. Ma awara ma jarateenadap'edaa k'aurepa parãpa mɨ t'ɨ̃de ne-inaa iididak'ãri mɨ Ak'õremaa mɨchideerã perã, irua ooit'ee parãpa iidi p'anɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Waya mɨa jara bɨ: chik'inia p'anapatáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Mɨde ijãadak'aa beerãpa parã k'ĩra unuamaa iru p'anɨ pɨrã, k'irãpátɨ mɨta naapɨara k'ĩra unuamaa iru p'anapachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Parã p'anadap'edaa paara ãchi p'anapatak'a, ãchia parã k'inia iru p'anak'ajida ãchideerãk'a. Mamĩda parã ãchideerã-e. Mɨata parã jɨrɨt'eraji ãchi k'ãyaara awara p'anapataadamerã. Maperãpɨ ãchia parã k'ĩra unuamaa iru p'anapata. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","K'irãpátɨ mɨa jarada: “Mimiapari ichi poro waibɨa k'ãyaara waibɨara bɨ-e.” Mɨ jɨrɨ nipapatap'edaak'a ichiaba parã jɨrɨ nipapataadait'ee. Jõdee mɨa jarateeda ijãajida pɨrã, parãpa jaratee p'anɨ ichiaba ijãadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mamĩda ma k'ãyaara audupɨara parã jɨrɨ nipapataadait'ee, mɨchideerã perã. Mãga oodait'ee k'awada-e p'anadairã k'aipata mɨ pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Mɨa Ak'õre net'aa jara che-e pada paara, ãrapa k'ĩsiada-e p'anak'ajida ãchia p'ek'au k'achia oopata. Mamĩda mɨ Ak'õrepa jara pëida jara cheji. Mapa ɨ̃rá “taipa k'awada-e p'anɨda” adaik'araa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mɨ k'ĩra unuamaa iru p'anɨɨrãpa mɨ Ak'õre jida k'ĩra unuamaa iru p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Unuda-e pada paara mɨa ne-inaa ooda awaraarãpa p'oyaa oodak'aa, ãchia p'ek'au k'achia ooda-e pak'aji Tachi Ak'õre k'ĩrapite. Mamĩda ãchia mãga unujida mĩda, at'ãri mɨ, mɨ Ak'õre ome k'ĩra unuamaa iru p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","P'asaji ãchi ũraa p'ãdade jara bɨk'a: ‘Ãchi k'inia mɨ k'ĩra unuamaa iru p'anapachida.’ ");
INSERT INTO sjaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Mamĩda mɨa awaraa K'aripapari pëiit'eeda aji. Mãgɨpa wãara aupaita jarapariit'ee. Mãgɨ́ uchiapari Tachi Ak'õredeepa, iru Jaure perã. Mãgɨ́ chek'ãri, irua mɨ k'awapiit'ee eperãarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Parãpa pida mɨ k'awapidait'ee awaraarãmaa, mɨde ijãadak'ãriipa mɨ ome p'anapatap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Mɨa ma jõma jaraji parãpa mɨde ijãapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tachi Ak'õre Ũraa jarateepata tedeepa parã jëret'aapataadait'eeda aji. Ma awara parã peet'aadait'eeda aji. Mãga oodak'ãri, ãchia k'ĩsiadait'ee mãgata pia oomaa p'anɨ Tachi Ak'õre-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mãga oodait'ee mɨ, mɨ Ak'õre ome wãara k'awada-e p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mapa ma jõma jaraji parãmaa, mãga p'asak'ãri, k'irãpadamerã. Naaweda mãga jara-e paji, parã ome bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","—Ɨ̃rá mɨ wãit'ee mɨ pëida baparimaa. Mamĩda parãdepema apidaapa iidida-e p'anɨ mɨ sãmaa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma k'ãyaara parã k'ĩra pia-ee p'anɨ, mɨa mãga jarada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mɨa wãarata jararu. Parã-it'ee piara bɨ mɨ wãmerã. Mɨ wã-e pɨrã, Ak'õre Jaure, Tachi K'aripapari, che-e pait'ee parã ome bapariit'ee. Mamĩda mɨ wãru pɨrã, mɨa iru pëiit'ee parãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iru chek'ãri, na p'ek'au eujãdepemaarãmaa k'awapiit'ee ãchia p'ek'au k'achia oopata. Ichiaba ãchimaa k'awapiit'ee Tachi Ak'õredeerãpa ne-inaa pia oopata irua k'inia bɨk'a. Ma awara k'awapiit'ee Tachi Ak'õre ewari waibɨa ewate ichia ak'ɨit'ee eperãarãpa oopata jarait'ee pia wa k'achia. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","K'awapiit'ee eperãarãpa mɨde ijãada-e p'anadak'ãri, k'achia oomaa p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","K'awapiit'ee mɨa oopachi Tachi Ak'õrepa k'inia bɨk'a, mɨ irumaa wãru perã. Mãga ook'ãri, parãpa mɨ waa unuda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","K'awapiit'ee Tachi Ak'õrepa pia ak'ɨ-e na p'ek'au eujãdepemaarã poro waibɨapa oo bɨ. Mapa iru, iru eere p'anɨɨrã ome miapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Mɨa k'ĩsia chok'ara iru bɨda aji, parãmaa jarait'ee. Mamĩda ɨ̃rá waa jara-e, parãpa ma jõma k'irãpada-e pai perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mamĩda Ak'õre Jaure chek'ãri, ne-inaa wãarata jõma k'awapiit'ee parãmaa, ichia wãara aupaita jarapari perã. Ichi k'ĩsiadoopa pedee-e pait'ee. Tachi Ak'õrepa jara bɨ ũrip'eda, mãga jarapariit'ee mãik'aapa jarapariit'ee ne-inaa waide p'asa-e bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ak'ɨpiit'ee mɨ apemaarã k'ãyaara waibɨara bɨ, mɨa ne-inaa k'awa bɨ parãmaa k'awapik'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jõma mɨ Ak'õrepa k'awa bɨ mɨa pida k'awa bɨ. Maperãpɨ mɨa jaraji Ak'õre Jaurepa k'awapiit'ee jõma mɨa ne-inaa k'awapi k'inia bɨ parãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Na ewari mɨ waa unuda-e pait'ee. Mamĩda aɨ t'ẽepai taarãpai waya unudait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mãga ũridak'ãri, chi k'õp'ãyoorã ũk'uru ãchi pitapai pedee para beeji: —¿K'ãata jara k'inia bɨma, ajida, na pedee: “Na ewari mɨ unuda-e pait'ee, mamĩda aɨ t'ẽepai waya unudait'ee”? ¿Ichiaba k'ãata jara k'inia bɨma nãgɨ́ pedee: “mɨ Ak'õremaa wãru perã”? ");
INSERT INTO sjaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿K'ãata jara k'inia bɨma na pedee: “taarãpai”? K'awada-e p'anɨda ajida, irua k'ãata jara k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesupa k'awaji chi k'õp'ãyoorãpa k'ãata iidi k'inia p'anɨ. Mapa mãgaji: —Mɨa jarajida aji, na ewari parumaa mɨ waa unuda-e pait'ee, mamĩda aɨ t'ẽepai waya unudait'ee. ¿Mata parãpa iidi para bɨ-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mɨa wãarata jararu. Parã jarajẽedait'ee mãik'aapa t'ãri p'ua p'aneedait'ee. Jõdee na p'ek'au eujãdepema ijãadak'aarã o-ĩa p'aneedait'ee. Mamĩda parã k'ĩra pia-ee p'anadap'eda, o-ĩa p'aneedayada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","K'ĩsiadáma nãgɨde. Wẽra warra t'oit'ee pak'ãri, p'ua nɨ̃beepari, t'oit'ee perã. Mamĩda chi warra t'o atak'ãri, k'ĩra atuadaipari p'ua nɨ̃bada mãik'aapa o-ĩa nɨ̃beepari warra chai t'o atada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mãga pɨk'a bɨ parã ome. Ɨ̃rá parã k'ĩra pia-ee p'anɨ mɨ wãru perã. Mamĩda mɨa parã waya unuit'ee. Maapai parã t'ãri o-ĩa p'aneedak'ãri, apidaapa ma o-ĩa wẽpapida-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Maapai parãpa mɨmaa maarepida iidida-e pait'ee. Mɨa wãarata jararu. Mɨ t'ɨ̃de mɨ Ak'õremaa ne-inaa iidiruta pɨrã, irua parãpa iidi p'anɨ teepariit'ee, mɨchideerã perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Waide mɨ t'ɨ̃de parãpa maarepida ɨt'aa iidida-e p'anɨ. Iidítɨ mɨ Ak'õrepa teemerã parãpa iidi p'anɨ. Mãgá parã wãara t'ãri o-ĩa p'anapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ma et'ewa jarada mɨa imeraa pɨk'a jarateeji. Mapa parãpa pia k'awada-e paji. Mamĩda na ewari mãgá jaratee-e pait'eeda aji. Jĩp'a pedeeit'ee Ak'õre net'aa pia k'awaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Maapai parãpa mɨ t'ɨ̃de ɨt'aa iididait'ee, mɨchideerã perã. Mapa mɨa jara-e chupɨria iidiit'ee parã pari Tachi Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ak'õrépata parã k'inia iru bapari parãpa mɨ k'inia iru p'anapata perã mãik'aapa ijãapata perã mɨ wãara cheji iru baparimãiipa. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Cheji na p'ek'au eujãdee eperã jĩp'aak'a bapariit'ee. Ɨ̃rá jõdee na p'ek'au eujã atabëiit'eeda aji, mãik'aapa waya irumaa wãit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mãpai chi k'õp'ãyoorãpa mãgajida: —Ɨ̃rapɨ jĩp'a pedee bɨda ajida. Imeraa pɨk'a jaratee-e bɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ɨ̃rapɨ k'awa p'anɨ pɨa ne-inaa jõmaata k'awa bɨ. Apidaapa pɨmaa iidida-e pait'ee, taipa iididai naaweda, pɨa k'awa bairã taipa iidi k'inia p'anɨ. Mapa ijãa p'anɨda ajida, pɨ wãara cheji Tachi Ak'õre baparimãiipa. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesupa p'anauji: —¿Mãgara ɨ̃rá wãara ijãa p'anɨk'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ewari k'ait'a pa wã, parã jĩchoodait'ee pãchi te chaa mãik'aapa mɨ ituaba atabëidait'ee. Mamĩda wãara mɨ ituaba bɨ-eda aji, mɨ Ak'õre mɨ ome bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma jõma jaraji parã t'ãridepai choodamerã mɨde ijãa p'anɨde mãik'aapa parã k'ãiwee p'anapataadamerã. Na p'ek'au eujãde p'anɨ misa, nepɨrade baaidait'ee parã jɨrɨdait'ee perã. Mamĩda sõcharra p'anapatáatɨ. Mɨata na p'ek'au eujãdepema ijãadak'aa beerã ãchi poro waibɨa ome p'oyaajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ma pedee jarap'eda, Jesupa ɨt'aa ak'ɨji mãik'aapa mãgaji: —Ak'õre, mɨ ewari pajida aji. Ak'ɨpíji mɨ wãara pɨchi Warra, mãgá mɨa ak'ɨpimerã pɨ wãara jõmaarã k'ãyaara waibɨara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pɨa eperãarã jõmaweda bɨji mɨ jua ek'ari, chi mɨde ijãa p'anɨɨrã jõmaweda ichita p'anapataadamerã pɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mãgá ichita p'anapataadait'ee pɨ ome, k'awaadak'ãri pɨ aupaita wãara Tachi Ak'õre mãik'aapa k'awaadak'ãri mɨ, Jesucristo, pɨchia pëida eperãarã k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Na p'ek'au eujãde bɨ misa, mɨa ak'ɨpiji pɨ aupaita Tachi Ak'õre, ook'ãri pɨa mɨmaa oopidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ɨ̃rá Ak'õre, ak'ɨpíji mɨ wãara pɨchi Warra. Mɨ atéeji pɨmaa bapariit'ee pɨchi k'ĩra wãreede, na p'ek'au eujã bai naaweda badak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—Mɨa pɨ k'ĩra unupipachi mɨ ome nipapatap'edaarãmaa, ma-it'ee pɨa ãra jɨrɨt'era atada perã na p'ek'au eujãdepemaarã t'ãideepa. Përé paji mãik'aapa pɨa mɨchideerã papiji. Pɨ ũraade ijãa p'anɨpɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ɨ̃rá ãrapa k'awa p'anɨ ne-inaa jõmaweda mɨa k'awa bɨ pɨata mɨmaa k'awapida. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mɨa jõma jarateeji pɨa jarapidak'a. Ãrapa ma pedee ijãajida, ijãa p'anadap'edaa perã wãara pɨata mɨ pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Mɨa chupɨria iidimaa bɨ ãra pari. Na p'ek'au eujãdepemaarã jĩp'aarã pari chupɨria iidi-e bɨ. Pɨa jɨrɨt'eradaarã mɨde ijãadamerã, mãɨrã párita chupɨria iidimaa bɨ, ãra pɨchideerã perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɨchideerã pɨchideerã auk'a. Ichiaba pɨchideerã mɨchideerã auk'a. Ãrapa ne-inaa oodak'ãri mɨa oopi bɨk'a, ak'ɨpipata mɨ waibɨara bɨ apemaarã k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Mɨ na p'ek'au eujãde waa ba-e pait'ee. Mamĩda ãra p'aneedait'ee, mɨ pɨ ome banaru misa. Mapa Ak'õre, pɨ jõmaarã k'ãyaara t'ãri piara bairã, ãra ak'ɨ baparíiji pɨchi juapa pɨa mɨmaa teeda juapa, ãra t'ãri a-ba, chik'inia p'anapataadamerã, pɨ mɨ ome baparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mɨ na p'ek'au eujãde ãra ome bak'ãri, ãra ak'ɨ bapachi pɨ k'ap'ɨa pari, apida atuanaadamerã. Aba chi atuait'ee bɨta atuait'ee, p'asamerã pɨ ũraa chonaarãweda p'ãdade jaradak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ɨ̃rá mɨ wãit'ee pɨmaa. Na p'ek'au eujãde bɨde mɨa nãgɨ́ pedee jara bɨ, ãrapa o-ĩa ũridamerã mãik'aapa t'ãri o-ĩadaidamerã, mɨ t'ãri o-ĩa bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɨa ãramaa pɨ ũraa jarateeji. Mɨde ijãadak'ãri, na p'ek'au eujãdepema ijãadak'aa beerãpa ãra k'ĩra unuamaa iru p'aneejida, mɨk'a mãɨrã eere p'anɨ-e perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɨa iidi-e bɨ pɨa ãra na p'ek'au eujãdeepa uchia atamerã. Ma k'ãyaara iidi bɨ ãra chi k'achia ooyaa bɨ juadeepa k'aripa atamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mɨ mãgɨ́ jua ek'ari bak'aak'a, ãra jida mãgɨ́ jua ek'ari p'anada-e, iru eere p'anɨ-e perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mapa ãra awara bɨ́ji pɨ wãarata bɨde t'ãri pia p'anapataadamerã pɨ baparik'a. Mãga p'anapataadai pɨ ũraa k'awaadak'ãri, wãara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pɨa mɨ na p'ek'au eujãdee pëidak'a, mãgá ichiaba mɨa ãra na p'ek'au eujãdepemaarãmaa pëiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ãra k'aurepa mɨa ne-inaa jõma oopari pɨa oopi bɨk'a, mɨchi k'ap'ɨa piuru pɨjida mãga oo k'iniapa. Mɨa mãga oopari ãrapa pida auk'a wãara ne-inaa jõma pɨa oopi bɨk'a oopataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Ãra-it'ee aupai mɨa iidi-e bɨda aji. Ichiaba iidimaa bɨ jõmaarã eperãarã pari, chi t'ẽepai mɨde ijãadait'eerã ãrapa jarateepata k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ak'õre, mɨa iidi bɨ mãgɨ́ ijãapataarã ichiaba t'ãri a-ba, chik'inia p'anapataadamerã, pɨ mɨ ome t'ãri a-ba, chik'inia baparik'a. Mãgá p'anapataadak'ãri, jõmaarãpa ijãadait'ee wãara pɨa mɨ pëiji na p'ek'au eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pɨa mɨmaa pia oodak'a mɨa ichiaba ãramaa pia ooji, t'ãri a-ba p'anapataadamerã, pɨ mɨ ome t'ãri a-ba baparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mɨ t'ãri a-ba bapari ãra ome, pɨ mɨ ome baparik'a, ãra mãgá t'ãri a-ba p'anapataadamerã ãchi k'õp'ãyoorã ome. Mãgapɨ na p'ek'au eujãdepemaarãpa k'awaadait'ee wãara pɨa mɨ pëiji mãik'aapa pɨa ãra auk'a k'inia iru bapari, mɨ k'inia iru baparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ak'õre, pɨa ãra jɨrɨt'eraji mɨde ijãapataadamerã. Mɨa k'inia bɨ ãra p'ananadamerã mɨ ome, mɨ wãrumaa. Mãgá jõma mɨ k'ĩra wãree unudait'ee, pɨa mɨmaa teeda mɨ k'inia iru bapachi perã na p'ek'au eujã bai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ak'õre, pɨ jõmaarã k'ãyaara t'ãri piara bɨ. Na p'ek'au eujãdepemaarãpa pɨ k'awada-e p'anɨ mĩda, mɨa pɨ k'awa bɨ mãik'aapa nãgɨɨrãpa pida k'awa p'anɨ pɨa mɨ pëida. ");
INSERT INTO sjaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɨa pɨ ãramaa k'awapiji mãik'aapa at'ãri k'awapiit'ee, mɨ ãra t'ãride bapariit'ee perã. Mãgá pɨa mɨ k'inia iru baparik'a, ãra jida ichiaba k'inia iru bapariit'eeda aji, ãrapa jõdee awaraarã k'inia iru p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mãgá ɨt'aa t'ɨ̃p'eda, Jesús chi k'õp'ãyoorã ome Cedrón to chak'e sĩajida. Mama t'ĩujida olivo k'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jesús traicionaait'ee badapa k'awa baji ãra t'ĩudap'edaamãi, Jesús chi k'õp'ãyoorã ome mama chip'epatap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mapa Judapa mamaa ateeji Romadepema soldaorã chok'ara mãik'aapa Tachi Ak'õre te waibɨa jɨ̃apataarã, judiorã p'aareerã poroorãpa pëidap'edaa; ichiaba fariseorãpa pëidap'edaa. Espada pak'uru ome, lámpara, ĩpirã paara anipajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesupa k'awa baji ichi p'asait'ee bada. Mapa mãɨrã cheruta unu atak'ãri, uchiaji ma ne-uu k'ãideepa mãik'aapa iidiji: —¿K'aita jɨrɨ p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ãchia p'anaujida: —Jesús Nazaretdepema. Jesupa mãgaji: —Mɨda aji. Judas, chi traicionaait'ee bada mama bainɨ̃ baji ma chedap'edaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesupa “mɨda” ak'ãri, ãchi jõma ãpɨtee jɨ̃tɨjida mãik'aapa eujãde baainajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mãpai Jesupa waya iidiji: —¿K'aita jɨrɨ p'anɨma? aji. Waya p'anaujida: —Jesús Nazaretdepema. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mãpai Jesupa mãgaji: —Mɨa jaraji mɨ Jesús Nazaretdepema. Mɨta jɨrɨ p'anɨ pɨrã, mɨ ome p'anɨɨrã ichiak'au wãpítɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesupa mãga jaraji p'asamerã ichia naaweda jaradak'a. “Pɨa mɨ juade bɨdaarã apida atuada-e pait'ee.” ");
INSERT INTO sjaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mãpai Simón Pedropa espada iru bada ẽe atap'eda, t'uji mãɨrãdepema aba, t'ɨ̃jarapatap'edaa Malco. Mãgɨ́ k'ɨɨrɨ juaraarepema orp'et'aaji. Mãgɨ́ p'aareerã poro waibɨa esclavo paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mãpai Jesupa mãgaji Pedromaa: —¡Pɨchi espada ata bɨ́ji ichi badamãi! ¿Mɨa choo-e paik'ã aji, mɨ Ak'õrepa miapiru? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mãpai ma soldaorã see nɨ̃bada ãchi poro ome mãik'aapa judiorã, chi Tachi Ak'õre te waibɨa jɨ̃apataarã paara, Jesús jita atadachida. Mãpai jɨ̃ nɨ̃bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Naapɨara ateejida Anás temaa, ichi Caifás chãure pada perã. Aɨ naaweda Anás p'aareerã poro waibɨa paji. Mamĩda ma año Caifás ãchi poro waibɨa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás paji chi jarada: “Piara bɨ eperã aba piumerã tachi judiorã p'uuru pidaarã pari.” ");
INSERT INTO sjaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús jita atadak'ãri, Simón Pedro awaraa k'õp'ãyo ome ãra t'ẽe wãjida. P'aareerã poro waibɨapa mãgɨ́ k'õp'ãyo k'awa bada perã, t'ĩupiji ma te t'ɨak'au badamãi Jesús ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mamĩda Pedro taawa bainɨ̃ beeji puerta t'aide. Mapa chi apema k'õp'ãyo Caifás k'awa badapa pedeenaji awẽra puerta jɨ̃apari ome Pedro ichiaba t'ĩupimerã. Mãgá Pedro ichiaba t'ĩuji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ma puerta jɨ̃aparipa Pedromaa iidiji: —¿Pɨ jã eperã k'õp'ãyo-ek'ã? aji. Mãpai Pedropa p'anauji: —Mɨ-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jĩsua nɨ̃bada perã, p'aareerã poro waibɨa mimiapataarãpa mãik'aapa te jɨ̃apataarãpa t'ɨpɨ orojida mãik'aapa k'ara p'aimaa p'aneejida. Bainɨ̃ p'anɨde t'ɨpɨtau ik'aawa, Pedro ichiaba ãchi ome k'ara p'aimaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mãɨmisa p'aareerã poro waibɨapa Jesumaa iidiji: —¿K'áirãma aji, pɨ k'õp'ãyoorã? Pɨa, ¿k'ãata jarateeparima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesupa p'anauji: —Mɨ jĩp'a pedeeparida aji, jõmaarã taide Ak'õre te waibɨade mãik'aapa Tachi Ak'õre Ũraa jarateepata te beede. Judiorã chepatamãi mɨa jarateepari. Maarepida chĩara ãpɨte pedee-e bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Sãap'eda mɨmaa mãga iidi bɨma? aji. Mɨ pedee ũridap'edaarãmaa iidináji. Ãrapa jaradaipɨ, k'awa p'anadairã mɨa jarapari. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesupa mãga jarak'ãri, te jɨ̃aparipa iru k'ĩramaa sĩji mãik'aapa mãgaji: —¿Jãgata p'anauparik'ã aji, p'aareerã poro waibɨamaa? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesupa mãgaji: —Mɨa pedee k'achia jaraji pɨrã, jarapáde aji, k'ãare pedeeta k'achia baji. Mamĩda mɨa jarada wãara pɨrã, ¿sãap'eda mɨ sĩjima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mãpai Anapa Jesús jua jɨ̃p'eda, Caifamaa pëiji. Maapai Caifás p'aareerã poro waibɨa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mãɨmisa taawa Simón Pedro bainɨ̃ baji t'ɨpɨtau ik'aawa k'ara p'aimaa. Arii p'anadap'edaarãpa iidijida: —¿Pɨ jã eperã k'õp'ãyo-ek'ã? ajida. Pedropa meraji: —¡Mɨ iru k'õp'ãyo-eda! aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mamĩda awaraa eperãpa Pedro k'ĩra k'awa ataji. Mãgɨ́ p'aareerã poro waibɨa mimiapari paji. Ëreerã paji Pedropa k'ɨɨrɨ orp'et'aada ome. Mãgɨpa mãgaji: —¿Pɨ-ek'ã mɨa ne-uu k'ãide Jesús ome unuda? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mãpai Pedropa waya meraji. Aramata et'erre k'ariji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tap'eda weda judiorã poro waibɨarãpa Jesús ateejida Caifás tedeepa Pilato palaciodee. Pascua fiesta ɨ̃rɨ pada perã, aɨ tede t'ĩuda-e paji. K'awa p'anajida judio-eerã tede t'ĩudap'edaa paara, Pascua chik'o p'oyaa k'oda-e pak'aji. Mãga k'awajida ãchi ũraade jara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Maperã Pilato uchiaji pedeede ãchi ome: —¿K'ãare k'aurepata na eperã nãgá iru p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","P'anaujida: —Na eperã t'ãri k'achia-idaa-e bada paara, pɨmaa aneeda-e pak'ajida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mãpai Pilatopa mãgaji: —Mãgara pãchia atadarítɨ mãik'aapa iru ak'ɨ́tɨ pãchi ũraade jara bɨk'a. Maap'eda óotɨ pãchia oo k'iniata. Mamĩda ma judiorãpa p'anaujida: —Pãchi Romadepemaarã ũraade jara bɨ tai judiorãpa chĩara peedaik'araa bɨ irua ne-inaa k'achia ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mãga jarajida uchiamerã Jesupa aɨ naaweda jaradak'a, irua jarak'ãri sãga ichi piut'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato waya ichi palaciode t'ĩup'eda, Jesús t'ɨ̃ ataji mãik'aapa iidiji: —¿Pɨk'ã aji, Judiorã Rey? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesupa mãgaji: —¿Pɨchi k'ĩradoopapai mãga iidi bɨk'ã, maa-e pɨrã awaraarãpa pɨmaa mãga jaradap'edaa perã? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatopa p'anauji: —¡Mɨ judio-epɨ! Pɨchi auk'aarã́pata mãik'aapa p'aareerã poroorã́pata pɨ mɨmaa aneejida. ¿Pɨa k'ãata oojima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesupa p'anauji: —Mɨ rey-eda aji, na p'ek'au eujãdepema reyrãk'a. Ãchik'a pada paara, mɨ ome nipapataarã chõok'ajida, judiorã poro waibɨarãpa mɨ jitanaadamerã. Mamĩda mɨ rey-e na p'ek'au eujãdepema reyrãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mãpai Pilatopa iidiji: —¿Wãara pɨ reyk'ã? aji. Jesupa p'anauji: —Pɨchia jarajipɨ. Mɨ reypɨ. Ma-it'ee mɨ t'oji mãik'aapa cheji na p'ek'au eujãdee; Tachi Ak'õre wãarata jarait'ee. Wãarata k'awa k'inia p'anɨɨrã jõmaarãpa mɨ pedee ũripatada aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mãpai Pilatopa mãgaji: —¿K'aipa wãarata k'awayama? aji. Mãga jarap'eda, Pilato taawaa uchiaji waya pedeede ma judiorã poro waibɨarã ome: —Mɨa maarepida k'achia unu-eda aji, na eperãde. ");
INSERT INTO sjaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mamĩda k'irãpátɨ año chaa Pascua fiestade mɨa preso aba k'ena pëipari. Mapa ¿k'inia p'anɨk'ã aji, mɨa Judiorã Rey apata k'ena pëimerã? ");
INSERT INTO sjaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mãpai arii p'anadap'edaarã jõmaweda waya biajida: —¡Jãgɨ́ k'ena pëináaji! ¡Barrabata k'ena pë́iji! Barrabás nechɨayaa bapachi mãik'aapa chõoyaa bapachi Romadepemaarã ome, ãchi jua ek'ariipa uchia k'inia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mãpai Pilatopa Jesús wɨpiji soldaorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldaorãpa poro jɨ̃ra pak'uru jua ne-ɨɨrɨ-idaa bɨdee oodap'eda, Jesús porode jɨ̃ bɨjida mãik'aapa p'aru p'oree teesoo, k'ĩra p'ãimap'ãimaa bɨ, jɨ̃ bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Maap'eda irumaa chejida mãik'aapa mãgajida: —¡Ak'ɨ́tɨ Judiorã Rey! mãik'aapa k'ĩramaa sĩpachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato waya tedeepa uchiak'ãri, mãgaji: —Ak'ɨ́tɨ. Mɨa iru nama aneeru parã taide. K'awapi k'inia bɨ parãmaa mɨa maarepida ne-inaa k'achia unu-e na eperãde. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús uchiak'ãri, ma poro jɨ̃ra jɨ̃ baji mãik'aapa p'aru teesoo. Mãpai Pilatopa mãgaji: —¡Nama bɨ chi eperã! ");
INSERT INTO sjaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesús unu atadak'ãri, p'aareerã poroorãpa mãik'aapa Tachi Ak'õre te waibɨa jɨ̃apataarãpa biapachida: —¡Kurusode peepit'áaji! ¡Kurusode peepit'áaji! Mamĩda Pilatopa mãgaji: —Mãgara pãchia atadaidapáde aji, mãik'aapa peet'aanadapáde aji. Mɨa maarepida unu-e bɨ ne-inaa k'achia ooda ma k'aurepa peepiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mamĩda ma judiorã poro waibɨarãpa p'anaujida: —Tai ũraade jara bɨ eperãpa ichi Tachi Ak'õre Warrada aru pɨrã, piupia bɨ. Mãga ooji jãgɨ́ eperãpa. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mãga ũrik'ãri, Pilato waapɨara p'eradachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Waya ichi palaciode t'ĩuji mãik'aapa Jesumaa iidiji: —¿Pɨ, sãpemama? aji. Mamĩda Jesupa maarepida p'anauk'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mãpai Pilatopa mãgaji: —¿Mɨ pedee p'anau-ek'ã? aji. ¿K'awa-e bɨk'ã aji, mɨa pɨ kurusode peepi k'inia bait'eera peepit'aai, maa-e pɨrã peepi k'inia-e bait'eera k'ena pëi? ");
INSERT INTO sjaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mãpai Jesupa p'anauji: —Pɨa mɨmaa maarepida oo-e pak'aji, ɨt'ari baparipa pɨ eperãarã poro waibɨa papi-e pada paara. Maperã chi eperã mɨ nama pëidapa ne-inaa k'achiara oo bɨda aji, pɨ k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Maadak'ãriipa Pilatopa k'ĩsiapachi sãga Jesús k'ena pëii. Mamĩda judiorãpa biapachida: —¡Jãgɨ́ eperã peepi-e pɨrã, pɨ César k'õp'ãyo-eda! apachida. ¡Eperãpa ichi reyda a bɨ pɨrã, mãgɨpa César k'ĩra unuamaa iru bɨda! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatopa mãga ũrik'ãri, Jesús taawaa ateepiji mãik'aapa ichi su-ak'ɨ beeji charra su-ak'ɨ beeparimãi, hebreo pedeede Gabatá apatap'edaa, griego pedeede “Mãu Choma P'ep'edee Bɨmãi”. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mãgɨ́ ewate Pascua fiesta norema paji. Imat'ɨpa Pilatopa mãgaji ma judiorã poro waibɨarãmaa: —¡Ak'ɨ́tɨ! ¡Nama bɨda aji, pãchi rey! ");
INSERT INTO sjaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mamĩda ãchia biapachida: —¡Ãyaa ateepíji! ¡Ãyaa ateepíji! ¡Kurusode peepit'áaji! Pilatopa iidiji: —¿K'inia p'anɨk'ã aji, mɨa pãchi rey peepimerã? P'aareerã poroorãpa p'anaujida: —¡Taipa rey awaraa wẽe p'anɨda ajida, César k'ãyaara! ");
INSERT INTO sjaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mãpai Pilatopa Jesús teeji ichi soldaorãmaa kurusode peet'aanadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesumaa kuruso ateepidap'eda, uchiajida p'uurudeepa taawaa wãdait'ee “Tachi Poro Bɨɨrɨ” apatap'edaamaa. (Hebreo pedeede Gólgota apachida.) ");
INSERT INTO sjaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mama merap'edap'eda, ma kurusode baijira bɨjida piumerã. Iru ik'aawa bɨjida awaraarã omé, aba juaraare, aba juabi eere. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatopa letrero p'ãji Jesús kurusode bɨdamerã. Nãga p'ãji: Jesús Nazaretdepema, Judiorã Rey. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Judiorã chok'araarãpa leejida ma p'ãda, Jesús peedap'edaamãi p'uuru k'ait'a bada perã. Ma p'ãda p'ã baji hebreo pedeede, latín pedeede mãik'aapa griego pedeede. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma p'ãda leedak'ãri, p'aareerã poroorãpa mãgajida Pilatomaa: —P'ãnáaji Judiorã Rey. Ma k'ãyaara nãga p'ãpáde ajida. Na eperãpa jaraji ichita Judiorã Rey. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mamĩda Pilatopa p'anauji: —Mɨa p'ãda perã jãgá p'ã beeit'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldaorãpa Jesús kurusode baijira bɨdap'eda mãik'aapa iru p'aru atadap'eda, ãchi k'ĩmariirãmaa jedet'aajida. Mamĩda chi edupema p'aru teesoo baji, k'aat'ɨ-ee; jĩp'a k'a baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mapa mãgajida: —Jẽnaadáma. Ma k'ãyaara suerte jemenedáma k'awaadait'ee k'aipata atait'ee. Mãga oojida uchiamerã Tachi Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Mɨchi p'aru jedejida mãik'aapa suerte jemenedap'eda, mɨchi p'aru jitajida’. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Soldaorãpa mãga oo p'anɨ misa, kuruso k'ait'a bainɨ̃ p'anajida Jesús nawe chi nawe ɨ̃pewẽra ome, awaraa María, mãgɨ́ Cleofás wẽra pada, mãik'aapa María Magdalena. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesupa unuk'ãri chi nawe k'ait'a bainɨ̃ bɨ mɨ, chi k'õp'ãyo k'inia iru bada ome, chi nawemaa mãgaji: —Nawe, jã pɨchi warrapɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Maap'eda mɨmaa mãgaji: —Jã pɨchi nawepɨ. Maadak'ãriipa mɨa María iru bapachi mɨ tede mɨchi nawek'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma t'ẽepai Jesupa k'awaak'ãri jõmaweda ichia ooit'ee bada auparu, mãgaji: —‘Opisia nɨ̃bɨda aji.’ Mãga jaraji uchiamerã Tachi Ak'õre Ũraa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mama iru p'anajida vino achuchua chok'ode. Aɨde esponjak'a p'ẽesap'ẽesaa bɨ topa atadap'eda, jõi bɨjida hisopo k'ɨ̃de mãik'aapa it'aimãi t'ɨ atajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sõp'eda, Jesupa mãgaji: —Ɨ̃rá jõma aupajida aji, mãik'aapa ichi poro ɨ̃jaabaip'eda, jai-idaaji. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma ewate Pascua fiesta ɨ̃ipata ewate norema paji. Judiorãpa mãgɨ́ ewate ɨapata perã, k'iniada-e p'anajida piuda k'ap'ɨa kurusode p'aneedamerã. Maperã iidijida Pilatomaa kurusode p'anadap'edaarã jĩru k'õrapik'oomerã, mãgá isapai piudamerã. Mãgá chi piuda k'ap'ɨa kurusodeepa ɨrabai atapidai. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilatopa ooji ãchia iididap'edaak'a. Romadepema soldaorã wãdap'eda, Jesús ik'aawa baijira p'anadap'edaarã jĩru k'õrak'oonajida, waide piuda-e p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mamĩda Jesús k'ait'a panadak'ãri, piu bɨ unujida. Maperã iru jĩru k'õrada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma k'ãyaara soldaopa Jesús orrode miasupa sut'aaji. Aramata uchiaji waa pania ome. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mɨ, chi mãga unudapa nepɨrɨmaa bɨ mɨa unuda. Mɨa k'awa bɨ wãarata jara bɨ, mɨa mãga unuda perã. Mɨa nãga jara bɨ parãpa pida ichiaba ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mãga p'asaji uchiamerã Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Iru bɨɨrɨ apida bɨada-e paji’. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ichiaba mãga p'asaji uchiamerã pedee awaraa Ak'õre Ũraa p'ãdade jara bɨk'a: ‘Ak'ɨdait'ee eperã ãchia sut'aadap'edaa’. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma t'ẽepai Josepa Pilatomaa Jesús k'ap'ɨa iidinaji, ichimaa ɨapimerã. Ichi Arimatea p'uurudepema paji mãik'aapa Jesude ijãa bapachi. Mamĩda judiorã poro waibɨarã waidoopa, awaraarãmaa k'awapi-e paji. Pilatopa Josemaa jaraji Jesús k'ap'ɨa atanamerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","José ome cheji Nicodemo, chi naaweda Jesús ome p'ãrik'ua pedeenada. Mãgɨpa aneeji treinta kilos mirra k'era áloe k'era ome p'oirada Jesús piuda k'ap'ɨa ɨ̃rɨ p'odait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Judiorãpa oopatak'a piuda ɨadak'ãri, ãchia Jesús k'ap'ɨa ma k'era ome pi-ia pɨrat'aajida lienzode. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús peedap'edaamãi ne-uu eujã k'ait'a baji. Mama baji mãu te uria ewaa k'orodap'edaa piuda ɨadait'ee. Mamĩda waide apida ɨada-e p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jesús k'ap'ɨa mama bɨnajida, ma mãu te uria k'ait'a bada perã mãik'aapa judiorã ɨ̃ipata ewate ɨ̃rɨ bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tomia ewate tap'eweda, María Magdalena wãji Jesús k'ap'ɨa ɨadap'edaamaa. Panak'ãri, unuji chi mãu te uria t'ai mãupa t'ap'a bada awara ãi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mapa p'ira cheji Simón Pedromaa mãik'aapa mɨ, chi apema k'õp'ãyo Jesupa k'inia iru badamaa. Mãpai mãgaji: —¡Tachi Waibɨa k'ap'ɨa ateejidada! aji. ¡K'awada-e p'anɨ sãma ata bɨnajida! ");
INSERT INTO sjaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mãga ũridak'ãri, Pedro mɨ ome araa wãjida ak'ɨde. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Omee weda auk'a p'ira wãjida. Mamĩda mɨ Pedro k'ãyaara isapaira p'iradachi. Mapa naapɨara panaji Jesús ɨadap'edaamãi mãu te uriade. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɨ̃jaabaik'ãri ak'ɨit'ee edaa, chi p'aru aupai unuji. Mamĩda t'ĩu-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mãga nɨde Simón Pedro pacheji mãik'aapa t'ĩuji edú. Ma lienzo ichiaba unuji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma awara unuji Jesús poro pɨra bada p'aru, bedap'eda awara ãi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mãpai mɨ auk'a t'ĩuji. Ak'ɨk'ãri, ijãaji Jesús chok'ai p'irabaida, aɨ naaweda taipa ijãada-e paji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Waide k'awada-e paji Tachi Ak'õre Ũraa p'ãdade jara k'inia bɨ Jesús piup'eda, chok'ai p'irabaiit'eeda ak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Maap'eda tai omee weda temaa wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mamĩda María beeji mãu te uria k'ait'a jẽemaa. Mãgá jẽe nɨ̃bɨde ɨ̃jaabaiji edaa ak'ɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Unuji angeleerã omé p'aru t'o-t'oo jɨ̃ p'anɨ. Su-ak'ɨ p'anajida Jesús k'ap'ɨa badamãi, aba chi poro bada eere, aba chi jĩru bada eere. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ãchia iidijida Mariamaa: —Wẽra, ¿sãap'eda jẽemaa bɨma? ajida. Mãpai Mariapa mãgaji: —Mɨchi Waibɨa k'ap'ɨa ateejidada aji. K'awa-eda aji, sãmaapɨ bɨnajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mata ãpɨtee ak'ɨk'ãri, unuji Jesús mama bainɨ̃ bɨ. Mamĩda iru k'ĩra k'awa-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mãpai Jesupa iidiji: —Wẽra, ¿sãap'eda jẽe nɨ̃bɨma? aji. ¿K'aita jɨrɨ bɨma? aji. Mariapa k'ĩsiaji ma eperã chi jãɨradepema ne-uu ak'ɨpari. Mapa mãgaji: —Mɨ chupɨria k'awáaji. Pɨa Jesús k'ap'ɨa ateeji pɨrã, jaráji sãma iru bɨ. Mɨa atanait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mãpai Jesupa mãgaji: —¡María! Ichi t'ɨ̃jarak'ãri, waya ãpɨtee ak'ɨji mãik'aapa hebreo pedeede mãgaji: —¡Rabuni! (Jara k'inia bɨ “Tachi Jarateepari”.) ");
INSERT INTO sjaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesupa mãgaji: —Mɨ k'ena pë́iji waide mɨ Ak'õremaa wã-e bairã. Jaranapáde aji, mɨ k'õp'ãyoorãmaa: “Mɨ wãit'ee mɨ Ak'õremaa; iru ichiaba parã Ak'õre. Mɨ wãit'ee mɨ Ak'õre Waibɨamaa; iru ichiaba parã Ak'õre Waibɨa.” ");
INSERT INTO sjaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mãpai María Magdalena wãji Jesús k'õp'ãyoorãmaa nepɨrɨde ichia unuda mãik'aapa Jesupa jarada. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mãgɨ́ ewate tomia ewate paji. K'eupodopa Jesús k'õp'ãyoorã teeda p'anajida. Puerta jɨ̃a iru p'anajida judiorã poro waibɨarã waidoopa. Mãga nɨde Jesús ãra esajĩak'a bainɨ̃ ba cheji mãik'aapa mãgaji: —P'eranáatɨ. K'ãiwee p'anapatáatɨ. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mãga jarap'eda, ãramaa ak'ɨpiji ichi jua mãik'aapa ichi orro. Jesús k'awaadak'ãri, t'ãri o-ĩadachida. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Waya Jesupa mãgaji: —¡K'ãiwee p'anapatáatɨ! Mɨ Ak'õrepa mɨ pëidak'a, mɨa parã jida auk'a pëiru. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mãga jarap'eda, jãrap'uaji ãchi ɨ̃rɨ mãik'aapa mãgaji: —Ak'õre Jaure auteebáitɨ, parã ome ba chemerã. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eperãarãpa ãchia p'ek'au k'achia oopata oo amaaruta pɨrã mɨde ijãadait'ee, parãpa ãramaa jaradai: “Tachi Ak'õrepa pãchia p'ek'au k'achia oopata wẽpapiit'ee,” mãik'aapa Ak'õrepa ooit'ee parãpa jaradap'edaak'a. Jõdee eperãarãpa mɨde ijãadaamaaruta pɨrã, parãpa ãramaa jaradai: “Tachi Ak'õrepa pãchia p'ek'au k'achia oopata wẽpapi-e pait'ee,” mãik'aapa Ak'õrepa ooit'ee parãpa jaradap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, ichiaba t'ɨ̃jarapatap'edaa Me-iso, Jesús k'õp'ãyoorã docedepema paji. Mamĩda mãgɨ́ wẽ-e paji Jesús chek'ãri apemaarãmãi. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mapa chi k'õp'ãyoorãpa irumaa mãgajida: —Taipa Tachi Waibɨa unujidada ajida. Mãga ũrik'ãri, Tomapa mãgaji: —Mɨa unuk'ãri clavopa merap'edap'edaamãi iru juade mãik'aapa aɨde mɨ jua k'ɨ̃ t'ɨk'ãri, maap'eda iru orrode sudamãi mɨ jua t'ɨk'ãri, ijãayada aji, Jesús chok'ai bɨ. Mãga-e pɨrã, ijãa-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tomia abaamaa waya Jesús k'õp'ãyoorã ma tede p'anadak'ãri, Tomás jida baji. Puerta jɨ̃a baji mĩda, Jesús ãchi t'ãide bainɨ̃ ba cheji mãik'aapa mãgaji: —¡K'ãiwee p'anapatáatɨ! ");
INSERT INTO sjaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mãpai Tomamaa mãgaji: —Ak'ɨ chéji mɨ jua, mãik'aapa pɨchi jua k'ɨ̃ t'ɨt'áaji. Ichiaba pɨchi jua mɨ orrode t'ɨt'áaji. ¡Ijãa-eda ai k'ãyaara, ijãa bɨda aparíiji! ");
INSERT INTO sjaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mãpai Tomapa mãgaji: —¡Mɨchi Waibɨa, ɨ̃rá mɨa ijãa bɨpɨ. Pɨ Tachi Ak'õre Waibɨa! ");
INSERT INTO sjaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mãpai Jesupa mãgaji: —Pɨa ijãa bɨ mɨ unuda perã. ¡T'ãri o-ĩa p'anɨ chi mɨde ijãa p'anɨɨrã, mɨ unuda-e p'anɨ mĩda! ");
INSERT INTO sjaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Wãara chi k'õp'ãyoorã taide Jesupa awaraa ne-inaa chok'ara ooji, ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mɨa na p'ãdade ma jõma p'ã-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mamĩda nãgɨ́ p'ãji parãpa ijãapataadamerã Jesús Tachi Ak'õre Warra; irua pëida eperãarã k'aripamerã. Jesude ijãa p'anɨ pɨrã, ɨt'aa wãdait'ee jai-idaadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma t'ẽepai Jesupa ichi waya unupiji chi k'õp'ãyoorãmaa, Tiberias Lago ik'aawa. Nãga paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ma lago ik'aawa p'anajida Simón Pedro; Tomás ichiaba t'ɨ̃jarapatap'edaa Me-iso; Natanael, Caná p'uurudepema Galilea eujãde bɨ; Zebedeo warrarã omé mãik'aapa Jesús k'õp'ãyoorã awaraarã omé. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mama p'anɨde Simón Pedropa mãgaji: —Mɨ to-ɨanait'eeda aji. Apemaarãpa p'anaujida: —Tai jida wãdait'eeda ajida, pɨ ome. Mãgá wãjida mãik'aapa barcode batauk'oodachida. Mamĩda ma ewate p'ãrik'ua maarepida peeda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Taujaaweda unujida Jesús bainɨ̃ bɨ lago ide. Mamĩda iru k'awada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mãpai Jesupa iidiji: —Warrarã, ¿Peeda-ek'ã? aji. Ãchia p'anaujida: —Maarepida peeda-eda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mãpai Jesupa mãgaji: —Barco juaraare t'ɨrɨ t'aadapáde aji. Mãgara peedayada aji. Irua jaradak'a oodak'ãri, ma t'ɨrɨ p'oyaa jirada-e paji chik'o chɨk'ɨapa. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mãpai mɨ, chi k'õp'ãyo Jesupa audú k'inia iru badapa Pedromaa mãgaji: —¡Jãgɨ́ Tachi Waibɨa! Simón Pedropa “Tachi Waibɨa” ũriruta, ichi ɨ̃rɨpema p'aru jɨ̃ beeji, ma p'aru ẽrapachi perã ma mimia ook'ãri. Mãpai toidú jɨ̃tɨdachi. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jõdee chi apemaarã k'õp'ãyoorã barcode chejida. T'ɨrɨ jidiu aneejida chik'o ome, mak'ɨara t'ɨmɨa-e bada perã lago ideepa; cien metropai baji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ipude bataudak'ãri, unujida ok'ok'ĩra urua nɨ̃bɨ chik'o ome mãik'aapa pan. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mãpai Jesupa mãgaji: —Chik'o ũk'uru anéetɨ parãpa et'ewa peedap'edaadepema. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro barcode bataudaip'eda, t'ɨrɨ ipu idee jidiu aneeji. Aɨde ciento cincuenta y tres chik'o waibɨa bee p'aneejida. Mamĩda ma t'ɨrɨ jẽ-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesupa mãgaji: —Nek'o chétɨ. Chi k'õp'ãyoorã apidaapa iididak'aa paji k'aita iru, Jesuta k'awa p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mãpai Jesús ãra k'ait'aara cheji. Ma pan chik'o paada ome atap'eda, ãramaa jedet'aaji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ma Jesupa unupida õpee paji chi k'õp'ãyoorãmaa, iru chok'ai p'irabaida t'ẽepai. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nek'odap'edaa t'ẽepai, Jesupa Simón Pedromaa iidiji: —Simón, Juan warra, ¿pɨa mɨ k'inia iru baparik'ã aji, apemaarãpa mɨ k'inia iru p'anapata k'ãyaara? Pedropa p'anauji: —Tachi Waibɨa, pɨata k'awa bɨ. Mɨa pɨ k'inia iru bɨ. Mãpai Jesupa mãgaji: —Ewaa ijãa p'anɨɨrã ak'ɨpariipáde aji, oveja ak'ɨparipa oveja chak'eerã ak'ɨparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesupa waya iidiji: —Simón, Juan warra, ¿pɨa mɨ k'inia iru baparik'ã? aji. Pedropa p'anauji: —Tachi Waibɨa, pɨata k'awa bɨ. Mɨa pɨ k'inia iru bɨ. Jesupa mãgaji: —Mɨde ijãapataarã ak'ɨpariipáde aji, oveja ak'ɨparipa ovejaarã ak'ɨparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Waya iidida õpee iidiji: —Simón, Juan warra, ¿pɨa mɨ k'inia iru bɨk'ã? aji. Pedro k'ĩra pia-ee baji Jesupa iidida õpee mãgá iidida perã. P'anauji: —Tachi Waibɨa, pɨa jõma k'awa bɨ. K'awa bɨda aji, mɨa pɨ k'inia iru bɨ. Jesupa mãgaji: —Mɨde ijãapataarã ak'ɨpariipáde aji, oveja ak'ɨparipa ichi ovejaarã ak'ɨparik'a. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mɨa wãarata jararu. Pɨ k'ũtrãa bak'ãri mãik'aapa ãyaa wãit'ee pak'ãri, pɨchi p'aru pɨchi juadoopa jɨ̃ beepachi. Mamĩda pɨ chonaa pak'ãri, pɨchi jua eratɨit'ee mãik'aapa awaraapa pɨ p'aru jɨ̃ bɨit'ee, maap'eda pɨ ateeit'ee pɨ wã k'inia-e bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesupa mãga jarak'ãri, jara k'inia baji sãgá Pedro piut'ee paji, mãga p'asak'ãri, eperãarãpa jaradamerã Tachi Ak'õre jõmaarã k'ãyaara waibɨara bɨ. Mãga jarap'eda, Jesupa Pedromaa mãgaji: —Mãga p'asait'ee mĩda, mɨde ijãaparíiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ãpɨtee ak'ɨk'ãri, Pedropa unuji mɨ, chi k'õp'ãyo Jesupa audú k'inia iru bada. (Pascua chik'o k'odak'ãri, mɨ Jesús ik'aawa baji iru k'õp'ãyoorã ome. Mɨ paji chi iidida: “Tachi Waibɨa, ¿k'áipapɨ pɨ traicionaait'eema?” ada.) ");
INSERT INTO sjaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedropa mɨ unuk'ãri, Jesumaa iidiji: —Tachi Waibɨa, ¿k'ãata p'asait'eema aji, iru ome? ");
INSERT INTO sjaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesupa p'anauji: —Mɨa k'inia bɨ pɨrã iru chok'ai bamerã mɨ waya cherumaa, pɨ-it'ee p'ua-e bɨda aji. Mɨde ijãaparíiji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesupa mãga jarada perã irude ijãapataarãpa k'ĩsiapachida mãgɨ́ k'õp'ãyo piu-e pait'ee. Mamĩda Jesupa mãga jara-e paji. Jĩp'a jaraji: “Mɨa k'inia bɨ pɨrã iru bamerã mɨ waya cherumaa, pɨ-it'ee p'ua-e bɨda” aji. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mãgɨ́ “k'õp'ãyo” et'ewa jarada mɨ, Juanpa nãgɨ́ pedee nepɨrɨmaa bɨ parãmaa. Na jõma mɨa p'ãji. Mapa k'awa p'anɨ jõma nepɨrɨda na p'ãdade wãara. ");
INSERT INTO sjaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús na p'ek'au eujãde bak'ãri, awaraa ne-inaa chok'ara oopachi. Ma ne-inaa jõma aba-abaa p'ãdap'edaa paara, mɨa k'ĩsia bɨ ma p'ãda jõmaweda araa-e pak'aji na eujãde.");
INSERT INTO sjaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, naapɨara k'art'a p'ãdade pɨmaa mɨa p'ãji Jesupa ne-inaa ooda mãik'aapa jarateeda ɨt'aa wãrumaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Wãi naaweda, Ak'õre Jaure k'ap'ɨa pari jaraji ichia jɨrɨt'eradaarãmaa k'ãata oopataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Piuda t'ẽepai chi k'õp'ãyoorãmaa cheji mãik'aapa unupiji wãara ichi chok'ai bɨ. K'ãima cuarenta wãyaaru misa, ichi k'ap'ɨa unupipachi mãik'aapa jarateepachi Tachi Ak'õrepa oopi k'inia bɨ ichide ijãapataarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ewari aba chi k'õp'ãyoorã ome bak'ãri, mãgaji: —Wãnaadapáde aji, Jerusalendeepa awara ãyaa. Nɨdapáde aji, mɨ Ak'õrepa jarada oorumaa, mɨa parãmaa jaradak'a ooit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautistapa poro choopachi paniapa. Mamĩda taarã-e Tachi Ak'õrepa ichi Jaure ba chepiit'ee parã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma t'ẽepai Olivo Eede p'anadak'ãri, Jesús k'õp'ãyoorãpa iidijida: —Tachi Waibɨa, ¿ɨ̃raweda Israel pidaarã p'uuru waibɨa papiit'eek'ã ajida, aɨ naawedapemak'a, chĩara jua ek'ari p'anada-ee? ");
INSERT INTO sjaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Irua p'anauji: —Parãpa k'awadaik'araa bɨda aji, sãapai Tachi Ak'õrepa ne-inaa ooit'ee, parã-it'ee-e perã. Irua aupaita mãgee net'aa k'awa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mamĩda Tachi Ak'õre Jaure parã ome ba chek'ãri, ichia k'aripait'ee nejõmaata oodamerã Ak'õrepa oopi k'inia bɨk'a. K'awapiit'eeda aji, jõmaweda mɨa ooda eperãarã k'aripait'ee, parãpa jarateenadamerã Jerusalén p'uurude, Judea eujãde, Samaria eujãde, awaraa eujã t'ɨmɨ́ beede paara. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mãga jarap'eda, Tachi Ak'õrepa iru ɨt'aa ateeji. Ãchia ak'ɨ jõnɨde jɨ̃ararade t'ĩudachi mãik'aapa waa unuda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mãgá ɨt'aa ak'ɨ jõnɨ misa, angeleerã omé ãchi ik'aawa bainɨ̃ p'ana chejida. P'aru t'o-t'oo jɨ̃ p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mãɨrãpa mãgajida: —Galilea pidaarã, ¿sãap'eda ɨt'aa ak'ɨ jõnɨma? ajida. Jãgɨ́ Jesús parã ome bada mãik'aapa ɨt'aa wãda waya cheit'eeda ajida, parãpa iru ɨt'aa wãru unudap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Maap'eda Olivo Eedeepa Jesús ome nipapatap'edaarã waya chejida Jerusalendee. Ɨ̃ipata ewate paji mãik'aapa ãchi ũraade jara bɨ ma ewate t'ɨmɨ́ wãdaik'araa bɨ. Mamĩda t'ɨmɨa-e bada perã, chejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","P'uurude panadak'ãri, wãjida ãchi p'anapatap'edaamaa ɨt'ɨpema pisode. Ma chedap'edaarã paji Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo warra Santiago, Simón Celote apatap'edaa mãik'aapa Santiago warra Judas. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mama ãchi ɨt'aa t'ɨ̃pachida Jesús ɨ̃pemaarã ome mãik'aapa Jesús nawe María ome, ichiaba awaraa wẽraarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ewari aba Jesucristode ijãapataarã ciento veinte see nɨ̃bɨde Pedro bainɨ̃ beeji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ɨ̃pemaarã Cristo k'aurepa, chonaarãweda Ak'õre Jaurepa jarajida aji, Rey David it'aideepa eperã abaapa Jesús peepiit'ee. Mãga jara bɨ Tachi Ak'õre Ũraa p'ãdade. Ɨ̃rá Davidpa jaradak'a uchiaji Judas ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas tachi k'õp'ãyo paji mãik'aapa tachi ome auk'a mimiapachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mamĩda k'achia ooda pari p'arat'a p'aadap'edaapa irua eujã neto ataji. Mama iru baaidachi mãik'aapa chi jɨ̃si chedachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalende p'anapatap'edaarãpa iru piuda k'awaadak'ãri, ma eujã t'ɨ̃ bɨjida Hacéldama, ãchi pedeede jara k'inia bɨ “Waa Eujã”. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mãga p'asada perã Judas ome, awaraa jɨrɨdaipia bɨ iru mimia oomerã. Mãga oodaipia bɨ Tachi Ak'õre Ũraa p'ãdadepema Salmode jara bairã: ‘Pɨ tede apida p'anada-e. Mapa ichita te tuma bait'ee.’ mãik'aapa awara ãi ichiaba jara bairã: ‘Awaraapa pɨ mimia atait'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nama p'anɨda aji, eperãarã tachi ome nipapatap'edaarã, Jesús tachi ome niparu weda. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan Bautistapa iru poro choodak'ãriipa ɨt'aa wãrumaa mãgá nipapachida. Judas pari ãchidepema jɨrɨdaipia bɨ aba tachi ome auk'a Jesús unuda chok'ai p'irabaip'eda. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mãpai madepema omé jɨrɨjida aba jɨrɨt'eradait'ee. Aba paji José. Mãgɨ́ ichiaba t'ɨ̃jarapachida Barsabás, maa-e pɨrã Justo. Chi apema t'ɨ̃jarapachida Matías. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma omé jɨrɨdap'eda, ɨt'aa t'ɨ̃jida: —Tachi Waibɨa, pɨa jõmaarã t'ãri k'awa bɨda ajida. Maperã k'awapíji na omeedepema k'aita pɨa k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mãgɨpa pɨ ũraa jarateenait'eeda aji, Judas pari, irua k'achia ooda k'aurepa ichi wãit'ee padamaa wãda perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mãga ɨt'aa t'ɨ̃dap'eda, suerte jemenejida jɨrɨt'eradait'ee. Mãpai Matiata uchiaji. Ma ewate weda apemaarã once Cristopa jɨrɨt'eradaarã ome mimiamaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jerusalén p'uurude Pentecostés fiesta ewate pak'ãri, jõmaweda Cristode ijãapataarã abaamaa see nɨ̃baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mãga nɨde nãumia pururua jĩwaaparik'a ũrijida ɨt'ariipa cheru ãchimaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mãpai unujida t'ɨpɨtauk'a jẽrajẽraa cheru ãchi ɨ̃rɨ. Maap'eda ãchi chaachaa ɨ̃rɨ urua jẽrajẽraa nɨ̃beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jõmaweda Ak'õre Jaure ome p'aneejida mãik'aapa Ak'õre Jaurepa pedeepiji ichia k'inia badak'a. Pedeepachida ãchia aɨ naaweda k'awada-e p'anadap'edaa pedeede. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Maapai Jerusalende p'anajida judiorã Tachi Ak'õrede ijãapataarã fiesta-it'ee chedap'edaarã awara ãiipa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ãchia mãgɨ́ nãu pururua jĩwaaparik'a ũridak'ãri, jõmaweda seedachida ma ciento veinte ijãapataarã p'anadap'edaamãi. K'awadak'aa paji k'ãata k'ĩsiadai, ũripachida perã ãchi t'odap'edaa pedeede. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mapa ãchi ak'ɨtrua para beeji mãik'aapa mãgapachida: —¿Jõmaweda na eperãarã pedee para bɨ Galileadepemaarã-ek'ã? ");
INSERT INTO sjaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Sãgapɨ k'ĩra t'ãdoo pedee para bɨma ajida, eperãarã nama para bɨ pedee chaa? ");
INSERT INTO sjaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nama eperãarã p'anɨ Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto mãik'aapa Ásia eujãdepemaarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ma awara chejida Frigiadepemaarã, Panfiliadepemaarã, Egiptodepemaarã, ichiaba Libiadepemaarã Cirene p'uuru k'ait'a p'anapataarã. Ichiaba Roma p'uurudepemaarã ũk'uru chejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judiorã ũk'uru mãga t'odap'edaa perã mãik'aapa ũk'uru judiorã pak'oodaidaarã, judiorã ũraade ijãadap'edaa perã. Ichiaba chejida Creta isladepemaarã mãik'aapa Arabia eujãdepemaarã. Nãgɨɨrã Galilea eujãdepemaarã mĩda, tachi chaachaa t'odap'edaa pedeede tachia ũri p'anɨda ajida. Ãchia pedee para bɨda ajida, jaradait'ee Tachi Ak'õrepa ne-inaa pia ooda. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mãgá ãchi t'odap'edaa pedeede ũridap'edaa perã, jõmaarãta ak'ɨtrua para beeji mãik'aapa k'awadak'aa paji k'ãata k'ĩsiadai. Ãchi pitapai mãgapachida: —Na ¿k'ãata jara k'inia bɨma? apachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mamĩda ũk'uru, chĩara oo k'iniapa, mãgapachida: —¡Vinopata piu para bɨ! ¡Mapa pariatua pedee p'anɨda! apachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mãpai Pedro, ɨt'a ak'ɨnɨ̃ beep'eda chi k'õp'ãyoorã once ome, golpe pedeeji: —Tachi auk'aarã mãik'aapa jõmaweda nama Jerusalende p'anɨɨrã, mɨa jararu pia ũrítɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","At'ãri tap'eda nɨ̃bairã tai vinopa piuda-e p'anɨda aji, parãpa k'ĩsia p'anɨk'a. Parãpa pia k'awa p'anɨ tai judiorã tap'eda weda todak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Parãpa nama unu p'anɨ chonaarãwedapema Ak'õre pedee jarapari Joelpa nãga jaradak'a: ");
INSERT INTO sjaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tachi Ak'õrepa jara bɨ: Na ewari na eujã jõi naaweda, eperãarã chok'araarãmaa mɨ Jaure pëiit'eeda aji. Parã warrarã mãik'aapa parã k'aurãpa jaradait'ee mɨa jarapiruk'a. K'ũtrãarãpa k'ãimok'araa pɨk'a bɨde mɨa ooru unudait'ee mãik'aapa chonaarã k'ãimok'araadait'ee mɨ ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wãara, maapai mɨa oopi bɨk'a oopataarãmaa mɨ Jaure pëiit'ee; ɨmɨk'ĩraarãmaa, wẽraarãmaa auk'a. Mɨa ooru ãrapa jarapataadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pajãde mãik'aapa eujãde ne-inaa eperãarãpa waide unudak'aa unupiit'ee: waa, t'ɨpɨtau mãik'aapa nari jɨ̃rak'awaa nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ak'õrejĩru k'ĩidariit'ee mãik'aapa atane k'ĩra p'oree waak'a padariit'ee. Mãgá pait'ee Ak'õre ewari waibɨa ewate, na eujã jõi naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mamĩda aɨ naaweda Tachi Ak'õrepa ichimaa chupɨria iidirutaarã k'aripa atait'eeda aji, atuanaadamerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mãpai Pedropa mãgaji: —K'awa p'anɨda aji, Joelpa jaradak'a wãara uchiaru idi, Tachi Ak'õrepa ichi Jaure taimaa pëida perã. Israel pidaarã, ũrítɨ mɨa jararu. Tachi Ak'õrepa Jesús Nazaretdepema pëiji tachi t'ãide. Mãga k'awa p'anɨ Tachi Ak'õrepa irumaa oopipachi perã ne-inaa eperãarãpa p'oyaa oodak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mamĩda Tachi Ak'õrepa k'ĩsia iru badak'a, parãpa iru jita atadachida, maap'eda ijãadak'aa beerãmaa peepijida. Mãɨrãpa kurusode baijira bɨjida mama piumerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mamĩda Tachi Ak'õrepa chok'ai p'irabai ataji. Mãgá chok'ai p'irabai atada perã, waa piu-e; ichita chok'ai bait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chonaarãweda Tachi Ak'õrepa Jesús ome ooit'ee bada jaraji Rey David it'aideepa: ‘Ichita mɨ Ak'õre Waibɨa unupachida aji, mɨ k'ĩrapite. Ichi mɨ ome bairã, maarepida mɨ waawee-e. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mapa mɨ t'ãri o-ĩa nɨ̃bɨ, mãik'aapa k'ari k'inia bɨ, k'awa bairã Tachi Ak'õrepa mɨ k'aripapari. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ak'õre, pɨa mɨ k'ap'ɨa beraupi-e pait'ee mɨ ɨarutamãi, mɨa oopari perã pɨa oopi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ak'õre eujãdee wãpari o mɨmaa ak'ɨpiji. Mapa mɨ o-ĩa bait'eeda aji, pɨ k'ĩrapite.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Maap'eda Pedropa mãgaji: —Tachi auk'aarã nama see nɨ̃bɨ, ũrítɨ. Tachi chonaarãwedapema Rey David jai-idaaji mãik'aapa ɨajida. Iru k'ap'ɨa at'ãri jãɨrade bɨ tachi t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","K'awa p'anɨ David chok'ai bak'ãri, Ak'õre pedee jarapari paji. Mapa irua k'awa baji Tachi Ak'õrepa jarada irumaa, irudeepa rey uchiapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mãgá, wãara Davidpa unu pɨk'aji mãik'aapa jaraji sãga Cristo p'irabaiit'ee iru ɨadap'edaamãiipa mãik'aapa iru k'ap'ɨa berau-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","K'awa p'anɨ na pedee Jesudeta jara bɨ, Tachi Ak'õrepa iru p'irabai atada perã mãik'aapa taipa unudap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tachi Ak'õrepa iru ɨt'aa ateeji ichi juaraare ak'ɨ banamerã. Maap'eda ichia jaradak'a ichi Jaure teeji Jesumaa, irua pëimerã irude ijãapataarãmaa. Mãgɨta parãpa et'ewa unujida mãik'aapa ũrijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tachi Ak'õrepa Rey David k'ap'ɨa piuda chok'ai p'irabaipi-e paji ɨt'aa ateeit'ee. Mamĩda Davidpa jaraji: ‘Tachi Ak'õrepa jaraji Tachi Waibɨamaa: “Pɨ mɨ ome auk'a waibɨa bairã, su-ak'ɨ beepáde aji, mɨ juaraare, ");
INSERT INTO sjaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mɨa pɨ k'ĩra unuamaa iru p'anapataarã p'oyaaru misa.” ’ ");
INSERT INTO sjaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Israel pidaarã, pia k'awáatɨ mãgɨ́ Jesús parãpa kurusode peepidap'edaa Tachi Ak'õrepa Tachi Waibɨa papiji. Iruta Tachi Ak'õrepa pëijida aji, tachi rey pamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mãga ũridak'ãri, arii p'anadap'edaarã k'ĩsia p'uadachida. Mapa iidijida Pedromaa mãik'aapa chi k'õp'ãyoorãmaa: —¿K'ãata oodayama ajida, taipa? ");
INSERT INTO sjaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedropa p'anauji: —P'ek'au k'achia oo amáatɨ, Tachi Ak'õrepa parã p'ek'au k'achia wẽpapik'oomerã mãik'aapa Jesucristo t'ɨ̃de poro choopítɨ. Mãga ooruta pɨrã, Ak'õrepa ichi Jaure pëiit'ee parã ome bapariimerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mãgɨ́ jarada parã-it'ee aupai-eda aji; ichiaba pãchi warrarã-it'ee mãik'aapa t'ɨmɨ́ p'anɨɨrã-it'ee; pia jarait'eera, Tachi Ak'õre Waibɨapa ichi odee atee k'inia bɨɨrã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mãgɨ́ pedee jõma jarap'eda, Pedropa ũraaji: —P'ananáatɨ Jesús peedap'edaarãk'a; jĩp'a ijã́atɨ mãik'aapa óotɨ Tachi Ak'õrepa oopi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma ewate weda Pedro pedee ijãadap'edaarãpa poro choopijida mãik'aapa apemaarã Cristode ijãapataarã ome t'ĩujida. Ma ijãadap'edaarã Pedro k'aurepa eperãarã tres mil paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mamãik'aapa ãchia ũri k'inia p'anapachida Cristopa jɨrɨt'eradaarãpa jarateepata mãik'aapa jedepachida ãchia ne-inaa iru bee. Ichiaba jõmaweda cheepurupachida ɨt'aa t'ɨ̃dait'ee mãik'aapa ne-inaa jedek'odait'ee, mãgá k'irãpadait'ee Cristo piuda ãchi pari. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Maapai eperãarã p'era pɨk'a para bapachi, Tachi Ak'õrepa oopipachi perã Cristopa jɨrɨt'eradaarãmaa ne-inaa eperãarãpa p'oyaa oodak'aa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma awara Cristode ijãapataarã chik'inia para bapachi mãik'aapa chi wẽe beerãmaa ãchi ne-inaa jedepachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pia jarait'eera, netopachida ãchi net'aa iru p'anɨ mãik'aapa ma p'arat'a t'oopachida teedait'ee chi wẽe beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ewari chaa cheepurupachida Ak'õre te waibɨade ɨt'aa t'ɨ̃dait'ee mãik'aapa t'ãri o-ĩapa ne-inaa jedek'opachida ãchi tede. ");
INSERT INTO sjaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ak'õremaa ɨt'aa t'ɨ̃pachida jaradait'ee iru t'ãri pia bɨ. Jerusalén pidaarãpa pia pedeepachida ãra ãpɨte. Maperã ewari chaa chok'araara o k'achiadeepa uchiapachida ãchi k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ewari aba Pedro Juan ome wãjida Tachi Ak'õre te waibɨadee a las tres, ma hora judiorã ɨt'aa t'ɨ̃patap'edaa hora pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mama Ak'õre te waibɨade baji eperã chiwa bɨ, ichi t'oru weda. Ewari chaa eperãarãpa mãgɨ́ ateepachida mãik'aapa bɨnapachida Ak'õre tede chi T'ĩupata Pi-ia apatamãi, p'arat'a iidipariimerã chi mama t'ĩurutaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mãgɨ́ eperãpa unuk'ãri Pedro mãik'aapa Juan Ak'õre tede t'ĩu wãda, p'arat'a iidiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mãpai ãchia ak'ɨjida irumaa mãik'aapa Pedropa mãgaji: —Taimaa ak'ɨpáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mãgɨ́ eperãpa ak'ɨji, p'arat'a teedai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mamĩda Pedropa mãgaji: —Mɨa wẽe bɨda aji, p'arat'a, nẽe jida. Mamĩda mɨa pɨ k'aripait'ee. Jesucristo Nazaretdepemapa mɨmaa nãga oopi bairã, iru t'ɨ̃de mɨa jararu: p'irabáiji mãik'aapa wã́ji. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mãga jararuta, Pedropa juaraarepema juade jitap'eda, p'irabai ataji. Aramata ma chiwa bada bɨɨrɨ pia beeji ");
INSERT INTO sjaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","mãik'aapa p'inajɨ̃tɨ bainɨ̃ beeji. Maap'eda p'ɨrrɨa beeji. Ma t'ẽepai ichi bɨɨrɨpa t'ĩuji Ak'õre tede ãchi ome. Jɨ̃tɨjɨ̃tɨa wãji mãik'aapa o-ĩapa ɨt'aa t'ɨ̃ wãji Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mãga unudak'ãri, jõmaweda arii p'anadap'edaarã ");
INSERT INTO sjaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","p'era pɨk'a para beeji. Mãgá p'anajida aɨ naaweda ãchia unupatap'edaa perã ma eperã su-ak'ɨ bɨ p'arat'a iidimaa Ak'õre tede, chi T'ĩupata Pi-ia apatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mãgɨ́ chiwa bada jɨpa beeda perã, Pedro mãik'aapa Juan ik'aawaapa ãyaa wãk'aa paji. Ãchi p'anajida Ak'õre te waibɨa ãuk'idaa, Salomón Pórtico apatap'edaamãi. Ãchimaa eperãarã jõmaweda p'era pɨk'a p'ira erreujida. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedropa mãga unuk'ãri, mãgaji: —Israel pidaarã, ¿sãap'eda parã p'era para bɨma? aji. ¿Sãap'eda tai k'ĩra ak'ɨ jõnɨma? ¿Parãpa k'ĩsia p'anɨk'ã taipa tachi juadoopa na eperã jɨpajida? ");
INSERT INTO sjaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tachi chonaarã Abraham, Isaac mãik'aapa Jacob ijãadap'edaa Ak'õre Waibɨapa ichi Warra Jesús waibɨara papiji jõmaarã k'ãyaara, ichia oopi badak'a oopachi perã. Mamĩda parãpa mãgɨ́ Jesús jita atadap'eda, charraarãmaa teenajida. Maap'eda Pilatopa uchia pëiit'ee pak'ãri, parãpa k'iniada-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Eperã t'ãri pia bɨ p'ek'au k'achia wẽe k'ena pëidai k'ãyaara, chĩara peeparita parãpa uchiapit'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mãgá peepit'aajida Tachi Ak'õre o ak'ɨpipari. Mamĩda parãpa peepidap'eda, Tachi Ak'õrepa chok'ai p'irabai ataji. Taipa mãga unujida tachi taupa. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nãgɨ́ eperã jɨpa beeji ichia ijãada perã Jesupa jɨpai. Maperãpɨ jɨpa beeji, parãpa unu p'anɨk'a. Jesús jõmaarã k'ãyaara waibɨara bairã, k'ayaa beerã jɨpai. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Mɨchi auk'aarã, mɨa k'awa bɨ pãchi poroorãpa mãik'aapa parãpa Jesús peepidak'ãri, k'awada-e paji iru Tachi Ak'õrepa pëida tachi k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mamĩda parãpa mãga oo p'anɨpa Tachi Ak'õrepa uchiapiji ichia jaradak'a, ichi pedee jarapataarã it'aideepa: ichia pëida piut'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mãpai Tachi Ak'õrepa k'ĩsia iru badade pia k'ĩsiadap'eda, k'achia oo amáatɨ mãik'aapa irude ijã́atɨ, irua pãchi p'ek'au k'achia wẽpapik'oomerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mãga ooruta pɨrã, Ak'õrepa parã k'ãiwee p'anapiit'ee mãik'aapa pëiit'ee Jesucristo, ichia jɨrɨt'erada parã k'aripapariimerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mamĩda Jesús at'ãri Ak'õre eujãde bait'ee, Ak'õrepa ne-inaa jõmaweda chiwidi pɨk'a ooru misa, chonaarãweda ichi pedee jarapataarã it'aideepa jaradap'edaak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Maapai Moisepa tachi chonaarãmaa mãgaji: ‘Ak'õrepa ichi pedee jarapari uchiapiit'ee parã t'ãide mɨ jĩak'a. Oopatáatɨ irua jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mãgɨ́ Ak'õre pedee jaraparipa jara bɨ pedee ũri k'iniada-e p'anɨɨrã Ak'õre eperãarã p'anɨmãiipa ãyaa jërek'ooit'ee mãik'aapa peek'ooit'ee.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ichiaba Samuel beedak'ãriipa jõma apemaarã Ak'õre pedee jarapataarãpa jarapachida tachia ɨ̃rá unu p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mapa parãpa k'awa p'anɨ Tachi Ak'õrepa jarada chonaarãweda ichi pedee jarapataarã it'aideepa parã ɨ̃rapemaarã-it'ee. Ichiaba ichia jarada Abrahammaa parã ɨ̃rapemaarã-it'ee. Mãgaji Abrahammaa: ‘Mɨa na p'ek'au eujãdepemaarã jõmaweda k'aripait'eeda aji, pɨdeepa uchiadait'eerã k'ap'ɨa pari.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ichia jaradak'a Abrahammaa Tachi Ak'õrepa parã pia ooji, ichi Warra piup'eda chok'ai p'irabai atak'ãri parã t'ãide. Mãga ooji k'inia bada perã parãpa naapɨara ijãadamerã mãik'aapa pãchia k'achia oopata oo amaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","At'ãri Pedro Juan ome pedeemaa p'anɨ misa, judiorã p'aareerã pachejida Ak'õre te waibɨa jɨ̃apataarã poro ome. Ichiaba ãchi ome chejida saduceorã. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","K'ĩrau p'anajida Pedropa mãik'aapa Juanpa jaratee p'anadap'edaa perã eperãarã piudap'eda chok'ai p'irabaidai, Jesús p'irabaidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mapa jita atadachida. K'ewara bada perã, carcelde t'ɨt'aanajida, aɨ norema ma nepɨra ak'ɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mãga oojida mĩda, eperãarã chok'araarãpa Cristode ijãajida, ãrapa jarateedap'edaa k'aurepa. Ijãapataarã jõmaweda ɨmɨk'ĩraarã aupai cinco mil paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aɨ norema Jerusalende abaamaa see nɨ̃baji judiorã poro waibɨarã, ãchi chonaarã mãik'aapa Moisepa p'ãda jarateepataarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mama baji ichiaba Anás, judiorã p'aareerã poro waibɨa pada. Ichiaba baji p'aareerã poro waibɨa Caifás, Juan, Alejandro mãik'aapa Anás ëreerã awaraarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro Juan ome atapijida mãik'aapa ãchi k'ĩrapite bainɨ̃ beepidap'eda, iidijida: —¿K'ai juapa parãpa jãgee net'aa oo p'anɨma? maa-e pɨrã ¿k'aipa jãgá oopi bɨma? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ak'õre Jaure Pedro ome bada perã, pia p'anauji: —Judiorã poro waibɨarã mãik'aapa chonaarã, ");
INSERT INTO sjaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","parãpa taimaa iidiruta, sãga nãgɨ́ k'ayaa bada k'aripajida mãik'aapa sãga jɨpa beeji. ¿Mãga-ek'ã? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pia bɨ. Taipa parã k'ĩrapite jaradait'ee, jõmaweda Israel pidaarãpa k'awaadamerã. Nãgɨ́ eperã parã jõmaarã k'ĩrapite bainɨ̃ bɨ, jɨpa beeji Jesucristo Nazaretdepema juapa, parãpa kurusode peepidap'edaa mãik'aapa Tachi Ak'õrepa chok'ai p'irabai atada. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tachi Ak'õre Ũraa p'ãdade jara bɨ: ‘Te oopataarãpa mãu k'iniada-e padap'edaa pipɨara padachi.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mapa Jesucristodepai ijãa p'anɨ pɨrã, ɨt'aa wãdait'ee, maarepida awaraa eperã wẽ-e perã iruk'a na p'ek'au eujãde, tachi o k'achiadeepa k'aripa atait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Judiorã poroorã arii p'anadap'edaarãpa unudak'ãri Pedro mãik'aapa Juan jĩp'a pedeemaa p'anɨ waaweeda-ee, mãik'aapa k'awaadak'ãri ãchi eperã jĩp'aarã, mak'ɨara k'art'a tau k'awada-ee, ak'ɨtrua para beeji. K'awaajida Jesús ome nipapatap'edaa perã, mãga pedeejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma awara chiwa bada ãchia jɨpadap'edaa arii baji. Mapa judiorã poroorãpa p'oyaa p'anaudak'aa paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mãpai ãchia Juan, Pedro, ma chiwa bada ome taawaa uchiapijida. Maap'eda pedee para beeji ãchi pitapai: ");
INSERT INTO sjaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿K'ãata oodait'eema ajida, jã eperãarã ome? Jõmaweda Jerusalendepemaarãpa k'awa p'anɨ ãrapa ne-inaa pia oodap'edaa, eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Tachia p'oyaa merada-e. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mamĩda ɨ̃rá jaradáma ajida, ma eperãarãmaa jarateenaadamerã Jesupa ne-inaa oopata, mãga-e pɨrã miapidai. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mãpai waya t'ɨ̃ p'e atajida mãik'aapa jarajida waa jarateenaadamerã Jesupa ne-inaa oopata. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mamĩda Pedropa Juan ome p'anaujida: —Pia k'ĩsíatɨ parãpa. ¿K'ãare piata bayama ajida, Ak'õrepa jara bɨ ooda-e pait'ee, parã pedee ũri k'iniapa? ");
INSERT INTO sjaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Taipa unudap'edaa mãik'aapa ũridap'edaa p'oyaa nepɨrɨ amaada-eda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Judiorã poroorã arii p'anadap'edaarãpa ãchi juade iru p'anajida mĩda miapidait'ee, arajãgaa pëijida eperãarã waidoopa. Jõmaweda eperãarã o-ĩa ɨt'aa t'ɨ̃maa p'anapachida Tachi Ak'õremaa, ");
INSERT INTO sjaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jesús Jaurepa ma eperã jɨpat'aada perã, cuarenta años audú iru bɨta. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","K'ena pëidap'eda, Pedro Juan ome chejida ãchi k'õp'ãyoorã p'anadap'edaamaa. Nepɨrɨjida judiorã p'aareerã poroorãpa mãik'aapa awaraa judiorã poro waibɨarãpa ãchimaa jaradap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mãgɨ́ pedee ũridap'eda, jõmaweda auk'a ɨt'aa t'ɨ̃jida: —Tachi Waibɨa, pɨa pajã, na eujã, p'usa mãik'aapa ne-inaa jõmaweda aɨde nɨ̃bɨ ooji. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pɨ Jaurepa tachi chonaa Davidmaa nãga pedeepiji irua pɨde ijãa bada perã: ‘¿K'ãare-it'ee awaraa eujãdepemaarã k'ĩrau p'anapatama? Mɨchi eperãarã paara pariatua k'ĩsiapata. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na p'ek'au eujãdepema reyrã mãik'aapa poro waibɨarã audua p'anadairã, pedeeteepata k'achia oodait'ee. Pedee k'achia jarapata Tachi Ak'õre ãpɨte mãik'aapa ichia rey pëida ãpɨte.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tachi Waibɨa, pɨa jaradak'a David it'aideepa, mãga uchiaji. Rey Herodes, Poncio Pilato mãik'aapa awaraarã judio-eerã na p'uurude pedeeteejida Israel pidaarã ome k'achia oodait'ee Jesús, pɨa pëida oo chemerã pɨa oopi k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mãga oojida pɨa naaweda k'ĩsia iru badak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ɨ̃rá Tachi Waibɨa, ak'ɨ́ji pɨ ãpɨte k'achia pedee p'anɨɨrã mãik'aapa taimaa waapɨara pɨ ũraa waawee-ee jarateepíji, taipa oo k'inia p'anadairã pɨa oopi bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ichiaba tai k'aripáji k'ayaa beerã jɨpapataadamerã mãik'aapa ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa oopataadamerã Jesús t'ɨ̃de. Iruata pɨchia oopi bɨk'a ichita oopari. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɨt'aa t'ɨ̃ aupadak'ãri, ãchi p'anadap'edaamãi wɨrrɨwɨrrɨa nɨ̃beeji. Mãpai jõmaweda Ak'õre Jaurepa oopi bɨk'a oo k'inia p'aneejida mãik'aapa Tachi Ak'õrepa ooda Jesús piuda k'aurepa waawee-ee jarateepachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Maapai ijãapataarã jõmaweda auk'a k'ĩsiapachida mãik'aapa chik'aripa p'anapachida. Apidaapa ãchi net'aa iru p'anɨ ãchi-it'ee aupaida adak'aa paji. Jĩp'a jõmaarã-it'ee paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mapa Ak'õrepa ãchi pia oopachi. K'aripaji Cristopa jɨrɨt'eradaarãpa jarateedamerã Jesús chok'ai p'irabaida mãik'aapa oodamerã ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ãchi chupɨria p'anadak'aa paji. Chi eujã iru beerãpa mãik'aapa ne-inaa awaraa iru beerãpa netot'aapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Mãpai ma p'arat'a Cristopa jɨrɨt'eradaarãmaa teepachida, jedenadamerã wẽe beerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mãga ooji Leví ëreerãdepema Josepa. Mãgɨ́ eperã Chipre isladepema paji. Mãgɨmaa Cristopa jɨrɨt'eradaarãpa pedida t'ɨ̃ bɨjida Bernabé (jara k'inia bɨ “T'ãri O-ĩapipari”). ");
INSERT INTO sjaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mãgɨ́ eperãpa eujã iru bada netot'aaji mãik'aapa ma p'arat'a Cristopa jɨrɨt'eradaarãmaa teeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mamĩda Bernabepa oodak'a ooda-e paji Ananías chi wẽra Safira ome. Mãgɨɨrãpa ãchi eujã netot'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mamĩda mãgɨ́ eperã chi wẽra ome pedeeteejida p'arat'a jõma teeda-e pait'ee Cristopa jɨrɨt'eradaarãmaa. Ananiapa mãgɨ́ p'arat'a ũk'urupai teenak'ãri, ");
INSERT INTO sjaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedropa mãgaji: —Ananías, ¿pɨ seewa cheruk'ã aji, Ak'õre Jauremaa, p'arat'a jõma tee che-ee? ¿Sãap'eda oojima Satanapa oopi bɨk'a? ");
INSERT INTO sjaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Jã eujã pɨchide paji-ek'ã netot'aai naaweda? ¿Ma p'arat'a pɨchide paji-ek'ã netot'aap'eda? ¿Sãap'eda nãga oo k'iniadachima? Pɨa eperãarãmaa seewa-e paji. Ak'õremaata seewajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mãga ũriruta, Ananías eujãde piu baainaji. Arii p'anadap'edaarãpa unudak'ãri, p'erak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mãpai k'ũtrãarã ũk'uruurãpa chi piuda beda atajida mãik'aapa ateejida ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hora õpeemaa Ananías wẽra t'ĩuji, chi ɨmɨk'ĩra piuda k'awa-ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mãpai Pedropa irumaa iidiji: —¿Wãara nãgɨ́ p'arat'a pari eujã netot'aajidak'ã? aji. Ichia p'anauji: —Netot'aajidapɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedropa mãgaji: —¿Sãap'eda parã pedeeteejida Ak'õre Jauremaa seewadait'ee? Ara cherutada aji, pɨ ɨmɨk'ĩra ɨadeepa. Naade pɨ jida auk'a ateedait'eeda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aramata Safira piu baainaji Pedro bɨɨrɨ ik'aawa. K'ũtrãarã t'ĩudak'ãri, unujida piu bɨ. Maap'eda ɨanajida chi ɨmɨk'ĩra ik'aawa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jõmaweda ijãapataarã mãik'aapa awaraarã mãga k'awadap'edaarã p'era para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","At'ãri Jerusalende p'anɨde Cristopa jɨrɨt'eradaarãpa oopachida ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Maapai jõmaweda Cristode ijãapataarã cheepurupachida Salomón Pórtico apatap'edaamãi, Tachi Ak'õre te waibɨa ãuk'idaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Apemaarã judiorã Tachi Ak'õre te waibɨade t'ĩupataarã waaweepa araa p'anada-e paji ãchi ome. Mamĩda pia pedeepachida ãchi ãpɨte, apemaarã Jerusalendepemaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mãɨrã mãgá t'ĩuda-e paji mĩda ãchi ome, Cristode ijãapataarã ĩwajida, wẽraarã mãik'aapa ɨmɨk'ĩraarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cristopa jɨrɨt'eradaarãpa ne-inaa pia oo p'anadap'edaa perã, eperãarãpa ãchi k'ayaa beerã calle jã ik'aawa uchia atapachida joip'aruk'a bɨ ɨ̃rɨ, Pedro wãyaa wãk'ãri, chi jaurepa pida ãra t'õbaimerã mãik'aapa jɨpamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ichiaba p'uuru k'ait'a beerãpa Jerusalendee k'ayaa beerã chok'ara aneepachida mãik'aapa ichiaba eperã netuara merãtɨa bee aneepachida. Tachi Ak'õrepa jõmaweda jɨpak'oopachi Cristopa jɨrɨt'eradaarã juapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Unudak'ãri jõmaweda Cristopa jɨrɨt'eradaarãpa oopata, judiorã p'aareerã poro waibɨa mãik'aapa ũk'uru saduceorã iru ome nipapatap'edaarãpa Cristopa jɨrɨt'eradaarã k'ĩra unuamaa iru p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mapa Tachi Ak'õre te waibɨa jɨ̃apataarãmaa atapijida carcelde t'ɨk'oonadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mamĩda p'ãrik'ua angelpa carcelde t'ĩupata ewat'aa cheji. Maap'eda ãchi taawaa uchiapik'ooji. Mãpai mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Wã́tɨ Tachi Ak'õre te waibɨadee mãik'aapa arii p'anɨɨrãmaa jaratéetɨ Cristopa ooda eperãarã k'aripait'ee ɨt'aa wãdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mãgá aɨ norema tap'eweda t'ĩujida Ak'õre tede mãik'aapa jarateemaa p'aneejida. Mãɨmisa ma p'aareerã poro waibɨapa mãik'aapa ichi ome p'anadap'edaarãpa t'ɨ̃ pëijida Junta Supremadepemaarã jõmaweda. Ichiaba carceldeepa Cristopa jɨrɨt'eradaarã atapijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mamĩda Ak'õre te jɨ̃apataarãpa carcelde jɨrɨnadak'ãri, unuda-e paji. Maperã nepɨrɨ chejida: ");
INSERT INTO sjaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Ununajidada ajida, carcel te pia jɨ̃a nɨ̃bɨ, mãik'aapa chi jɨ̃apataarã aɨ t'aide jɨ̃a p'anɨ. Mamĩda ewa atadak'ãri, apida unuda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mãga ũridak'ãri, ma p'aareerã poro waibɨa apemaarã p'aareerã poroorã ome mãik'aapa Ak'õre te jɨ̃apataarã poropa k'awada-e paji k'ãata oodai. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mãga nɨde eperã pacheji mãik'aapa mãgaji: —Parãpa carcelde t'ɨk'oodap'edaarã Ak'õre te waibɨade eperãarãmaa jarateemaa p'anɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aramata Ak'õre te waibɨa jɨ̃apataarã poro apemaarã jɨ̃apataarã ome wãjida jita p'e atade. Mamĩda k'ĩra jĩp'a p'e aneejida, eperãarãpa ãchimaa mãupa bat'adai jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pachedak'ãri, ak'ɨnɨ̃ p'aneepijida Junta Suprema k'ĩrapite. Mãpai ma p'aareerã poro waibɨapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Taipa parãmaa jarajida waa jarateenaadamerã jã eperãpa oopata. Mamĩda mãga ooda-e p'anɨ. Waapɨara jõmaweda Jerusalén pidaarãmaa jarateemaa p'anɨ. Ma awara táipata jã eperã peet'aajidada a jõnɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Apemaarã pari Pedropa p'anauji: —Taipa ichita Ak'õrepa oopi bɨk'a oodait'eeda aji, eperãpa jara bɨk'a oodai k'ãyaara. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tachi chonaarãwedapema Ak'õrépata Jesús, parãpa kurusode peepidap'edaa, chok'ai p'irabaipiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tachi Ak'õrepa iru p'irabai atap'eda, su-ak'ɨ bɨji ichi juaraare, jõmaarã k'ãyaara waibɨara bairã. Mama bɨji eperãarã ak'ɨpariimerã mãik'aapa o k'achiadeepa k'aripa atamerã. K'inia baji Jesús piuda k'aurepa Israel pidaarãpa p'ek'au k'achia oopata oo amaadamerã. Mãgá irua wẽpapik'ooi ãrapa p'ek'au k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tachi Ak'õre Jaurepa ma jõma k'awa bɨda aji. Taipa pida ichiaba mãga k'awa p'anɨda aji, Cristode ijãadak'ãri, Ak'õrepa ichi Jaure taimaa pëida perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Judiorã poroorãpa mãga ũridak'ãri, Cristopa jɨrɨt'eradaarã peek'oo k'iniadachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mamĩda ãra t'ãide baji fariseo t'ɨ̃jarapatap'edaa Gamaliel. Mãgɨ́ Gamalielpa Moisepa p'ãda pia k'awaa baji. Mapa eperãarãpa iru t'o p'anapachida. Mãgɨ́ bainɨ̃ beep'eda, Cristopa jɨrɨt'eradaarã arak'atɨa taawaa uchia atapiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","T'ẽepai mãgaji apemaarã judiorã poroorãmaa: —Israel pidaarã, pia k'ĩsíatɨ ne-inaa oodai naaweda jã eperãarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","K'irãpátɨ mak'ɨara taarã-e bɨ eperã Teudas apatap'edaapa k'ĩsiaji ichita jõmaarã k'ãyaara waibɨara pai. Mãgɨ́ eere cuatrocientos ɨmɨk'ĩraarã p'anajida. Mamĩda mãgɨ́ peet'aadak'ãri, iru ome nipapatap'edaarã jĩchoodachida. Mãgá ãchia k'ĩsia iru p'anadap'edaa jõdachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aɨ t'ẽepai, Romadepemaarãpa eperãarã t'ɨ̃ p'ãpimaa p'anadak'ãri, ichiaba Judas Galileadepemapa mãga k'ĩsiaji. Eperãarã ũk'uruurãpa iru pedee ijãajida. Mamĩda ichiaba peet'aadak'ãri, iru ome nipapatap'edaarã ãyaa erreudachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mapa mɨa parãmaa ũraait'ee jã eperãarã k'achia oonaadamerã. Ãchia jaratee p'anɨ pɨrã ãchi k'ĩsiadeepa mãik'aapa ne-inaa oo p'anɨ pɨrã ãchi juadoopa, ãchia oopata jõdariyada aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mamĩda Tachi Ak'õrépata ãchimaa mãga oopi bɨ pɨrã, parãpa p'oyaada-eda aji. K'ĩrak'aupai, Tachi Ak'õre ome chõomaa p'aneedai. Ãchia Gamaliel ũraa ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Maap'eda Cristopa jɨrɨt'eradaarã t'ɨ̃ p'e atajida mãik'aapa wɨk'oojida. Jarajida waa jarateenaadamerã Jesupa ooda. Maap'eda k'ena pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mamĩda Cristopa jɨrɨt'eradaarã judiorã poroorã k'ĩrapiteepa o-ĩa uchiajida, Ak'õrepa ãchi ita-aria miapida perã Jesús k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Maap'eda ewari chaa jarateepachida Jesucristota Tachi Ak'õrepa pëida eperãarã k'aripamerã. Mãga jaratee wãpachida Tachi Ak'õre te waibɨade mãik'aapa te bee chaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Maapai ijãapataarã chok'arapɨara ĩwajida. Judiorã griego pedee pedeepataarãpa ɨmɨateejida judiorã hebreo pedee pedeepataarãmaa, ãchia griego pedee pedeepataarã p'ẽtrãarã pia ak'ɨdak'aa pada perã ewari chaa ne-inaa jededak'ãri k'aripadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Maperã chi doce jɨrɨt'eradaarãpa t'ɨ̃ pëijida jõmaweda Cristode ijãapataarã cheepurudamerã. See nɨ̃beek'ãri, mãgajida: —K'õp'ãyoorã, tai jua araada-e ijãapataarã jõmaweda ak'ɨdait'ee. Pia-e bɨda ajida, taipa waa jarateeda-e pait'ee Ak'õrepa jara pëida Jesucristo k'ap'ɨa pari, chi ne-inaa wẽe beerã ak'ɨ k'iniapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mapa eperãarã siete jɨrɨt'erátɨ ma mimia oodamerã. Jɨrɨdaipia bɨ nãgee eperãarã: k'ĩsia k'awaa beerã; t'ãri pia beerã mãik'aapa Ak'õre Jaurepa oopi bɨk'a oo k'inia beerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tai jõdee ɨt'aa t'ɨ̃maa p'anadait'ee mãik'aapa Ak'õrepa jara pëida jarateedait'eeda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mãpai ãchia p'anaujida: —Pia bɨda ajida. Maap'eda jɨrɨt'erajida Esteban. Ma eperã Cristode pia ijãaji mãik'aapa Ak'õre Jaurepa oopi bɨk'a oopachi. Ichiaba jɨrɨt'erajida Felipe, Prócoro, Nicanor, Timón, Pármenas mãik'aapa Nicolás Antioquiadepema. Naaweda mãgɨ́ Nicolás Tachi Ak'õrede ijãak'aa bap'eda, judiorãpa ijãapatade ijãa baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma t'ẽepai ateejida Cristopa jɨrɨt'eradaarã p'anadap'edaamaa. Mãgɨɨrã ɨt'aa t'ɨ̃jida ãchi pari mãik'aapa jua bɨjida ãchi ɨ̃rɨ. Mãga oojida ak'ɨpidait'ee ma mimia ãchimaa teeruta. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma t'ẽepai, Ak'õrepa ooda Cristo piuda k'aurepa waapɨara jarateepachida mãik'aapa ijãapataarã waapɨara ĩwapachida Jerusalende. Judiorã ũk'uru, p'aareerã jida ichiaba Cristode ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Maapai Jerusalendepemaarã t'ãide Estebanpa oopachi ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. Mãga oopachi Tachi Ak'õrepa iru k'aripa bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mamĩda ewari aba pachejida judiorã Tachi Ak'õre Ũraa jarateepata tedepema. Ma te t'ɨ̃jarapachida Esclavoorã P'anadap'eda Uchiadap'edaa. Mãɨrãpa nepɨra jɨrɨ chejida Estebanmaa. Ãchi ome chejida auk'a Cirene p'uurudepemaarã, Alejandría p'uurudepemaarã, Cilicia eujãdepemaarã mãik'aapa Ásia eujãdepemaarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mamĩda aupedeedak'ãri, Esteban p'oyaa k'ĩup'eepidak'aa paji, Ak'õre Jaurepa iru k'ĩsia k'awaapida perã ãchia iidida p'anaut'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mapa awaraarãmaa p'aajida seewa jaradamerã ichia pedee k'achia pedeemaa bɨ Moisés ãpɨte mãik'aapa Tachi Ak'õre ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mãgá p'uuru pidaarã, judiorã poro waibɨarã mãik'aapa Moisepa p'ãda jarateepataarã k'ĩraupik'oojida Esteban ome. Mãɨrãpa Esteban jita atadap'eda, atadachida Junta Suprema k'ĩrapite Tachi Ak'õre te waibɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mãpai ma p'aadap'edaarã aneejida seewa jaradamerã. Mãɨrãpa mãgajida: —Nãgɨ́ eperãpa ik'achia pedeeparida ajida, Tachi Ak'õre te ãpɨte mãik'aapa Moisepa p'ãda ãpɨte. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jara bɨ Jesús Nazaretdepemapa nãgɨ́ te t'eet'aait'ee mãik'aapa tachimaa waa oopi-e pait'ee Moisepa p'ãdade jaradak'a, tachia oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Judiorã poroorãpa mãik'aapa arii p'anadap'edaarãpa Esteban ak'ɨdak'ãri, chi k'ĩra ángel k'ĩrak'a unujida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mãpai p'aareerã poro waibɨapa iidiji Estebanmaa: —¿Wãarak'ã aji, na eperãarãpa jara p'anɨ? ");
INSERT INTO sjaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Irua p'anauji: —Mɨchi auk'aarã mãik'aapa chonaarã, ũrítɨ. Tachi Ak'õre k'ĩra wãree bɨpa ichi unupijida aji, tachi ak'õchona Abrahammaa Mesopotamia eujãde bak'ãri, Harande banai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ak'õrepa jaraji: ‘Atabëipáde aji, pɨ eujã pɨ ëreerã ome mãik'aapa wãpáde aji, mɨa ak'ɨpiit'ee eujãmaa.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mãpai Abraham uchiaji Caldea eujãdeepa mãik'aapa banaji Harande. T'ẽepai chi ak'õre piuk'ãri, Tachi Ak'õrepa Abraham aneeji na eujãdee tachi ɨ̃rá p'anɨmãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mamĩda na eujã maarepida waide tee-e paji irumaa; bɨɨrɨ aba t'ɨait'ee pida. Jĩp'a jaraji teeit'ee irudeepa uchiadait'eerãmaa iru piuda t'ẽepai, Abraham waide warra wẽe baji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ma awara Ak'õrepa jaraji: ‘Pɨdeepa uchiadait'eerã p'anapataadait'eeda aji, awaraa eujãde mimiamaa chĩara-it'ee. Mama esclavoorã p'anadait'ee mãik'aapa jãpemaarãpa ãra miapi iru p'anadait'ee cuatrocientos años.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mamĩda Ak'õrepa ichiaba jaraji: ‘Mɨa k'achia ooit'eeda aji, ãra esclavoorã papirutaarã. T'ẽepai ãra mamãik'aapa uchiadait'ee mãik'aapa mɨmaa ɨt'aa t'ɨ̃dait'eeda aji, na eujãde.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mãgá pedee nɨ̃bɨde Abraham ome, Ak'õrepa jaraji Abrahampa tauchaa bɨmerã ichi warra k'ap'ɨade. Tachi Ak'õrepa k'inia baji mãga oodamerã ichi eperãarãpa ak'ɨpidait'ee ichide ijãa p'anɨ. Mapa Abraham warra Isaac t'ok'ãri, k'ãima ocho parumaa iru k'ap'ɨade tauchaa bɨji. Isaacpa mãga ooji ichi warra Jacob ome. Ichiaba Jacobpa mãga ooji chi warrarã doce ome. Mãɨrãdeepa Israel pidaarã ëreerã doce uchiajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Mãgɨ́ Jacob warrarã pada, tachi chonaarãpa, ãchi ɨ̃pema José k'ĩra unuamaa iru p'anapachida. Maperã netot'aajida esclavok'a Egiptodee wãyaa wãdap'edaarãmaa. Mamĩda Tachi Ak'õre José ome baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Maperã k'aripa ataji jõmaweda ne-inaa k'achiadeepa. Ma awara k'ĩsia k'awaapiji mãik'aapa k'inia iru bapiji rey Egiptodepema Faraonmaa. Mãgɨpa José Egiptodepemaarã poro waibɨa papiji ichi palaciode. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ma t'ẽepai jarra oojida Egipto eujãde mãik'aapa Canaán eujãde. Maperã mak'ɨara nek'odait'ee wẽ-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mamĩda Jacobpa k'awaak'ãri Egiptode ne-inaa k'oit'ee paraa, jãmaa pëiji ichi warrarã, ne-inaa netode. Mãgɨ́ paji tachi chonaarã naapɨara wãdap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aɨ t'ẽepai wãdak'ãri, Josepa ichi ɨ̃pemaarãmaa k'awaapiji. Madeepa Faraónpa José ëreerã k'awaji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","T'ẽepai, Josepa jara pëiji chi ak'õre Jacob mãik'aapa chi ëreerã jõmaweda chedamerã Egiptodee. Ãchi setenta y cinco paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mãgapɨ Jacob banaji Egiptode. Mama jai-idaaji. Ichiaba mama tachi chonaarã jai-idaajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacob bɨɨrɨ mãik'aapa chi warrarã bɨɨrɨ ateejida Siquem p'uurudee mãik'aapa mama ɨajida Abrahampa Hamor ëreerã juak'aawa netoda jãɨrade. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ewari k'ait'a pak'ãri Tachi Ak'õrepa uchiapiit'ee Abrahamdeepa uchiadap'edaarã Egiptodeepa ichia jaradak'a, ãchi chok'ara p'anajida, ĩwa p'anadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Maapai Egiptodepema reypa José k'awa-e pada Faraón paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mãgɨ́ reypa tachi chonaarã k'ũraji waa ĩwanaadamerã. Ãchi chupɨria ooji. Jaraji ãchi warrarã ewaa t'o k'edeerã ita-aria piupidamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Maapai t'oji Moisés. Tachi Ak'õrepa mãgɨ́ warra chai pia ak'ɨji. Mapa chi ak'õreerãpa atane õpee warimaa iru p'anajida ãchi tede. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mamĩda p'oyaa waa merada-e paji. Mapa ituaba atabëidak'ãri, Faraón k'aupa unu ataji mãik'aapa wari ataji ichi warrak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mãgapɨ Moisés wariji Egipto pidaarã t'ãide mãik'aapa k'awaa wãji ne-inaa k'ĩra t'ãdoo Egiptodepemaarãpa k'awa p'anadap'edaak'a. Mãpai jõmaarãpa iru k'awajida, irua pedeeda k'aurepa mãik'aapa ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’‘Cuarenta años iru bak'ãri, k'ĩsiaji wãit'ee Israel pidaarã ak'ɨde, ichi auk'aarã pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mamĩda unuk'ãri Egiptodepemapa ichi auk'aa sĩmaa bɨ, Moisepa k'aripanaji mãik'aapa ma Egipto pida pee atapëiji.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisepa k'ĩsiaji ichi auk'aarãpa ijãadai Tachi Ak'õrepa ichi pëida ãchi k'aripamerã. Mamĩda ãchia mãga ooda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","‘Aɨ norema unuji Israel pidaarã omé chõomaa p'anɨ. Mãgá chõonaadamerã mãgaji: “¿Pãchi auk'aarã-ek'ã aji, jãgá chõo jõnadait'ee?” ");
INSERT INTO sjaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mãpai chi k'õp'ãyo sĩmaa badapa Moisés sĩat'aaji mãik'aapa mãgaji: “¿K'aipa pɨ tai porok'a bɨjima aji, taipa oopata ak'ɨmerã? ");
INSERT INTO sjaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mɨ peet'aa k'inia bɨk'ã aji, nuweda Egipto pida peet'aadak'a?” ’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mãga ũrik'ãri, Moisés mirudachi. Maap'eda t'ɨmɨ́ wãji Madián eujãdee. Mama banaji k'ĩra tewaraak'a. Ariipema wẽra atap'eda, warrarã omé paraaji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cuarenta años wãyaap'eda, ewari aba Moisés baji eujã pania wẽe bɨmãi Sinaí ee k'ait'a. Mama bɨde unuji pak'uru jep'eda t'ɨpɨtauk'a urua nɨ̃bɨ, angelpa aɨde ichi unupi bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mãgá urua unuk'ãri, Moisés k'ait'aara wãji pi-iara ak'ɨit'ee k'ãata mãga bɨ. Mãga nɨde ũriji Tachi Ak'õrepa mãgaru: ");
INSERT INTO sjaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɨ pɨ chonaarã Ak'õre Waibɨa; Abraham, Isaac, Jacob ijãadap'edaa Ak'õre Waibɨa.’ Mãga ũrik'ãri, Moisés bɨɨrɨ wëre nɨ̃beeji p'era nɨ̃bɨpa mãik'aapa p'oyaa ak'ɨk'aa paji ma pak'urumaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mãpai Tachi Ak'õrepa mãgaji: ‘Pɨchi chancla ẽrat'aapáde aji, nama pɨ mɨ k'ĩrapite bainɨ̃ bairã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mɨa k'awa bɨ mɨ eperãarã chupɨria chitoonɨ Egiptode. Ũri bɨ ãchi bia chitoonɨ. Mapa cheji k'aripait'ee. Pɨa auk'a k'aripanáji. Mɨa pɨ Egiptodee pëiit'eeda aji.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Aɨ naaweda ãchia Moisés pedee ũri k'iniada-e paji nãga p'anauda perã: ‘¿K'aipa pɨ tai porok'a bɨjima ajida, taipa oopata ak'ɨmerã?’ Mãgá yiaraa pɨk'a iru p'anajida mĩda, Tachi Ak'õrepa ichi ángel pak'uru ɨɨrɨ-idaade unupida k'ap'ɨa pari Moisés pëiji ãchi porok'a. Tachi Ak'õrepa k'inia baji Moisepa ãchi uchia atamerã Egipto pidaarã juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mãgá Moisepa tachi chonaarã uchia p'e ataji Egiptodeepa. Ichia ne-inaa ooji eperãarãpa p'oyaa oodak'aa ãchi juadoopa mãgɨ́ eujãde, Mar Rojode mãik'aapa cuarenta años wãyaaruta misa eujã pania wẽe bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mãgɨ́ Moisepa jaraji Israel pidaarãmaa: ‘Parãdeepa Ak'õrepa uchiapiit'ee ichi pedee jarapari mɨ jĩak'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","P'anadak'ãri eujã pania wẽe bɨde, Israel pidaarã pari Moiseta pedeeji ángel ome Sinaí eede. Ichiata Ak'õrepa jarada naapɨara p'ãji, tachi chonaarãpa mãik'aapa tachia mãgɨ́ ũraa ijãadap'eda, ichita p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Mamĩda tachi chonaarãpa iru pedee ijãa k'iniada-e paji. Ma k'ãyaara waya Egiptodee wã k'iniadachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mapa Moisés wẽ-e pak'ãri, ichi ɨ̃pema Aaronmaa mãgajida: ‘Tachi-it'ee ak'õre waibɨarã oopáde ajida, tachi naa o jaratee wãdamerã, k'awada-e p'anadairã sãgataji jã Moisés ome, Egiptodeepa tai ãyaa aneeda.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mãpai oojida p'ak'a chak'ek'a aɨ k'ĩrapite ɨt'aa t'ɨ̃dait'ee. Ne-animalaarã peejida aɨ k'ĩrapite paadait'ee mãik'aapa fiesta oojida o-ĩapa, ma p'ak'a chak'ek'a ooda-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Maperãpɨ Tachi Ak'õre ãchi ik'aawaapa ãyaa wãji. Mapa pajãde nɨ̃bɨ ne-inaamaa ɨt'aa t'ɨ̃pachida, Tachi Ak'õremaa ɨt'aa t'ɨ̃dai k'ãyaara. Oojida Ak'õre pedee jarapataarãpa p'ãdap'edaade jara bɨk'a: ‘Israel pidaarã, parã cuarenta años eujã pania wẽe bɨde p'anadak'ãri, ¿mɨ-it'ee ne-animalaarã peedap'eda, paapachidak'ã, mɨde ijãa p'anadap'edaa perã? ");
INSERT INTO sjaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma k'ãyaara parãpa ɨt'aa t'ɨ̃pachida Canaandepemaarã ak'õre waibɨa Molocmaa mãik'aapa Egiptodepemaarã ak'õre waibɨa Refanmaa. Mɨa mãga k'awa bɨ ne-inaa pãchi juapa oodap'edaa atee p'anadap'edaa perã pãchi wãrutamaa. Mapa mɨa parã ãyaa jërek'ooit'eeda aji, Babilónia p'uuru k'ãyaara t'ɨmɨara.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tachi chonaarã eujã pania wẽe bɨde p'anadak'ãri, ateepachida Tachi Ak'õre te ne-edee ooda, k'irãpadait'ee Tachi Ak'õre arii bɨ ãchi ome. Mãgɨ́ te oojida Tachi Ak'õrepa Moisemaa ak'ɨpidak'a. Oojida aɨde ɨt'aa t'ɨ̃pataadait'ee Tachi Ak'õremaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ma t'ẽepai tachi chonaarã mãgɨ́ tede ɨt'aa t'ɨ̃pachida ãchi chonaarãpa oodap'edaak'a. Mapa Tachi Ak'õrepa awaraa p'uuru ome jura chõo p'oyaapik'ãri, Josué ome chedap'edaarãpa ãchi ome aneejida mãgɨ́ te ne-edee ooda. Mãgá iru p'anapachida David rey parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tachi Ak'õrepa Rey David k'inia iru bapachi. Mapa Davidpa iidiji Tachi Ak'õremaa te waibɨa oo teeit'ee, te pia oo k'inia bada perã Jacobpa ijãadap'edaa Ak'õre-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mamĩda David warra Salomonpa Tachi Ak'õre te waibɨa ooji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Salomonpa mãgɨ́ te ooji mĩda, k'awa p'anɨ Tachi Ak'õre Waibɨa bak'aa te eperãarã juapa oodade. Mãga k'awa p'anɨ Ak'õre pedee jaraparipa jarada perã: ");
INSERT INTO sjaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mɨ, Jõmaarã Rey, ɨt'arita baparida aji, mãik'aapa eujã mɨ jua ek'ari bɨ. ¿Te k'ãaredeeta mɨmaa oo teedait'eema? ¿Sãmata mɨ ɨ̃inait'eema? ");
INSERT INTO sjaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mɨchi juadoopa jõmaweda ooji-ek'ã? aji.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mãpai Estebanpa mãgaji: —Parãpa Tachi Ak'õrede ijãa p'anɨda apata mĩda, t'ãri k'achia-idaa p'anapatada aji, ijãadak'aa beerãk'a. Ma awara k'ɨɨrɨ k'isua p'anapata, oo k'iniadak'aa perã Ak'õre Jaurepa oopi bɨk'a. Pãchi chonaarã́k'apɨ p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Parã chonaarãpa ichita Tachi Ak'õre pedee jarapataarã jɨrɨjida peedait'ee. Peejida chi p'ek'au k'achia wẽe bɨ cheit'ee bɨda apatap'edaarã. Maap'eda chi p'ek'au k'achia wẽe bɨ chek'ãri Tachi Ak'õrepa oopi bɨk'a ooit'ee, iru ichiaba jita atapidap'eda, peepijida parãpa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Parã́pata Ak'õre Ũraa iru p'anapata angeleerã k'aurepa. Mamĩda at'ãri ooda-e p'anɨda aji, mãgɨ́ ũraa jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mãga ũridak'ãri, t'ãri k'achiapa Esteban peet'aa k'inia p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mamĩda Ak'õre Jaure ichi ome bada perã, ɨt'aa ak'ɨji mãik'aapa unuji Ak'õre k'ĩra wãree mãik'aapa Ak'õre juaraare Jesús bainɨ̃ bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mãpai mãgaji: —Ak'ɨdapáde aji. Mɨa unu bɨ pajã ewa nɨ̃bɨ mãik'aapa unu bɨ Eperã Ak'õre Truadepema Ak'õre Waibɨa juaraare. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mamĩda ãchi k'ɨɨrɨ t'ap'ak'oodachida mãik'aapa golpe biadap'eda, jõmaweda iru ɨ̃rɨ wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jerusalén p'uurudeepa uchia atadap'eda, mãupa bat'amaa p'aneejida iru peet'aadait'ee. Auk'a k'aripajida Esteban ɨmɨateedap'edaarãpa. Ãchi ɨ̃rɨpema p'aru jɨ̃patap'edaa ata bɨjida eperã Saulo apatap'edaa bɨɨrɨ ik'aawa irua ak'ɨmerã, ãchia mãu bat'aruta misa. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mãupa bat'amaa p'anɨde Esteban ɨt'aa t'ɨ̃ji: —Tachi Waibɨa Jesús, mɨ jaure pɨchimaa atéeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","T'ẽepai bedabaiji mãik'aapa golpe ɨt'aa t'ɨ̃ji: —Tachi Waibɨa, ãchi chupɨria k'awáaji, mɨ nãgá k'achia oo p'anɨ mĩda. Mãga jarap'eda, piuji. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Esteban peedak'ãri, Saulo mama baji ak'ɨit'ee, ichi judiorã poroorã eere bada perã. Esteban piup'eda, ũk'uru Tachi Ak'õrede ijãapataarãpa ɨajida; ichiaba audú jẽejida iru-it'ee. Ma ewatedeepa Jerusalende Cristode ijãadak'aa beerãpa irude ijãapataarã jɨrɨjida peedait'ee. Mapa jõmaweda miruk'oodachida Judea eujãdee mãik'aapa Samaria eujãdee. Cristopa jɨrɨt'eradaarã aupai miruda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mãgá jɨrɨ p'anɨ misa, Saulopa Cristode ijãapataarã auk'a jɨrɨpachi. Te chaa t'ĩu wãpachi wẽraarã ɨmɨk'ĩraarã ome jita p'eit'ee. Maap'eda carcelde t'ɨpik'oopachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Saulopa mãga oo baji mĩda, chi Jerusalendeepa mirudap'edaarãpa jaratee wãpachida Cristopa ooda eperãarã k'aripait'ee ãchi wãrutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe wãji Samaria eujãdee mãik'aapa Cristopa ooda jarateepachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Arii p'anadap'edaarãpa mãga ũridak'ãri mãik'aapa unudak'ãri irua ooda eperãarãpa p'oyaa oodak'aa ãchi juadoopa, waapɨara k'awa k'inia p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mama Felipepa uchiapik'oopachi netuaraarã merãtɨa bee eperãarã chok'ara k'ap'ɨadeepa. Mãgɨ́ netuaraarã ãra k'ap'ɨadeepa bia uchia wãpachida. Ma awara Felipepa jɨpak'oopachi eperãarã chok'ara chiwa beerã mãik'aapa p'oyaa ãchi bɨɨrɨpa pia nipadak'aarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Maperã ma p'uurudepemaarã o-ĩa p'anapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mamĩda mama bapachi eperã t'ɨ̃jarapatap'edaa Simón. Mãgɨpa petau tau k'awaa baji mãik'aapa ma eujãdepemaarã k'ũra p'e iru bapachi ichia oo bɨ k'aurepa. Mapa ãchi t'ãide eperã waibɨak'a bapachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Waibɨara beerã, ek'ariara beerãpa paara iru pedee ũri k'inia p'anapachida mãik'aapa mãgapachida: —Tachi Ak'õrépata irumaa nãga oopi bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Irua jararu ijãapachida, ichi petau taupa k'ũrap'e iru bada perã. Taarãji ma k'apɨte bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mama bɨde Felipepa jarateeji: Jesucristo Tachi Ak'õrepa pëida mãik'aapa iru k'aurepa Tachi Ak'õrepa eperãarã p'ek'au k'achia wẽpapik'oopari. Mãga ijãadak'ãri, mãpema ɨmɨk'ĩraarã mãik'aapa wẽraarã poro choopijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simonpa pida ijãaji. Maap'eda poro choopiji mãik'aapa nipaji Felipe ome. Unuk'ãri Felipepa ne-inaa oo bɨ eperãarãpa p'oyaa oodak'aa ãchi juadoopa, ichia k'awa-e bapachi sãga k'ĩsiai. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Cristopa jɨrɨt'eradaarã Jerusalende p'anadap'edaarãpa ũridak'ãri Samaria pidaarãpa ijãaruta Ak'õrepa ooda Cristo piuda k'aurepa, mamaa pëijida Pedro Juan ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Arii panadak'ãri, ɨt'aa t'ɨ̃jida Samaria pidaarã Cristode ijãapataarã pari, Tachi Ak'õre Jaure ãra ome ba chemerã, ");
INSERT INTO sjaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","waide Ak'õre Jaure ãra k'ap'ɨade ba che-e bada perã. Jĩp'a poro choopijida Tachi Waibɨa Jesús t'ɨ̃de, ak'ɨpidait'ee irude ijãadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mãpai Pedropa mãik'aapa Juanpa jua bɨdak'ãri ãra ɨ̃rɨ, mãgá Ak'õre Jaure ba cheji ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simonpa unuk'ãri Ak'õre Jaure che bɨ Cristopa jɨrɨt'eradaarãpa jua bɨrutade eperãarã ɨ̃rɨ, p'arat'a teeit'ee paji, ichia auk'a mãga ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Mãgaji: —Mɨmaa k'awaapidapáde aji, ichiaba mɨa jua bɨk'ãri eperã ɨ̃rɨ, Ak'õre Jaure iru ome ba chemerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mãpai Pedropa p'anauji: —¡Pɨchi p'arat'a ome atua baibeepáde aji, k'ĩsia bairã neto atai Tachi Ak'õrepa oopipari ichi jɨrɨt'eradaarãmaa! ");
INSERT INTO sjaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Pɨa na mimia p'oyaa oo-e, Ak'õre k'ĩrapite k'ĩra jĩp'a k'ĩsia-e bairã. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mãgá k'ĩsia amáaji mãik'aapa Tachi Ak'õremaa chupɨria iidíji. Mãga oorura, Tachi Ak'õrepa perdonaaipɨ pɨa k'achia oo k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mɨa mãga jara bɨ k'awa bairã pɨ t'ãride tai ome k'ĩrau bɨ, waibɨara paruta perã pɨ k'ãyaara nãpemaarã k'ĩrapite. Wãara pɨ at'ãri p'ek'au k'achia jua ek'ari bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mãpai Simonpa p'anauji: —Parãpa Ak'õremaa chupɨria iididapáde aji mɨ pari, mɨ baainaamerã parãpa mɨmaa jaradap'edaade. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Maap'eda Pedropa Juan ome ma p'uurudepemaarãmaa jarajida ãchia unudap'edaa Jesús ome nipadak'ãri. Ichiaba Tachi Ak'õrepa jara pëida jarateejida. Ma t'ẽepai chejida Jerusalendee. Mamĩda ode Samariade p'uuru bee chaa jaratee che wãpachida Tachi Ak'õrepa pedee pia jara pëida Cristode. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma t'ẽepai, Tachi Ak'õrepa ichi ángel pëiji Felipemaa jaramerã: —Wã́ji barree, Jerusalendeepa chonaarãwedapema Gaza p'uurudee wãpari ode. Mãgɨ́ o wãyaapari eujã pania wẽe bɨde. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mãpai Felipe wãji mãik'aapa ode unuji eperã Etiopía eujãdepema. Mãgɨ́ Etiopiadepemaarã poro waibɨara paji. Ãchi reina p'arat'a jɨ̃apari paji. Ichi wã baji Jerusalendee Tachi Ak'õremaa ɨt'aa t'ɨ̃de. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mata waya che wãji ichi eujãdee. Su-ak'ɨ baji ichi caballopa jidiupata carrode mãik'aapa lee wãji chonaarãwedapema Ak'õre pedee jarapari Isaíapa p'ãda. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mãgá wãde, Ak'õre Jaurepa mãgaji Felipemaa: —Wã́ji jã carro k'ait'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe ma carro ik'aawa pak'ãri, ũriji Etiopiadepemapa Isaíapa p'ãda leemaa bɨ. Mãpai iidiji: —¿K'awa bɨk'ã aji, k'ãata jara k'inia bɨ pɨa leemaa bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopiadepemapa p'anauji: —¿Sãga mɨa k'awaayama aji, apidaapa mɨmaa jarateeda-eeta? Mãpai Felipemaa chupɨria iidiji bataumerã mãik'aapa ichi ik'aawa su-ak'ɨ beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Isaíapa p'ãdadepema ichia leemaa badade nãga p'ã baji: ‘Iru ateejida oveja ateepatak'a chi peepatamaa. Ara oveja k'ĩup'ee baparik'a chi k'ara t'ɨɨmaa p'anadak'ãri, mãga pɨk'a iru k'ĩup'ee baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iru k'ĩra nejasiapijida mãik'aapa maarepida chupɨria k'awada-e paji. Ãchi audú t'ãri k'achia-idaa p'anadap'edaa perã, pee atapëijida. Maperã irudeepa warra apida uchiada-e paji. Mãgá iru peedak'ãri, uchiapijida na p'ek'au eujãdeepa.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mãpai Etiopiadepemapa Felipemaa iidiji: —Mɨ chupɨria k'awáaji. ¿K'aideta pedeemaa bɨma aji, na Ak'õre pedee jaraparipa; ichide wa awaraa eperãde? ");
INSERT INTO sjaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mãpai Felipepa ma Etiopiadepemamaa mãgaji: —Pɨa leemaa bɨ Tachi Ak'õre Warrade; Jesús p'asada. Mãpai Felipepa jarateemaa beeji jõma Jesupa ooda eperãarã k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Maap'eda waawipai ode wãyaadak'ãri pania paraamãi, mãgɨ́ eperãpa mãgaji: —Nama pania paraa. ¿Sãap'eda mɨ poro choo-ema? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipepa p'anauji: —Pɨa wãara Jesucristode ijãa bɨ pɨrã, pia bɨda aji. Ma eperãpa mãgaji: —Mɨa ijãa bɨda aji, Jesucristo Tachi Ak'õre Warra. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma carro t'ɨbaipip'eda, ãchi omee weda ɨrabaijida mãik'aapa wãjida pania paraamaa. Mama Felipepa poro chooji. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paniadeepa uchiadak'ãri, Felipe wẽpadachi Tachi Ak'õre Jaurepa ateeda perã. Ma Etiopiadepemapa waa unu-e paji. Mamĩda ichi o-ĩa wãji ichi eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mãɨmisa Ak'õre Jaurepa Felipe uchiapiji Azoto p'uurude. Mamãik'aapa p'uuru bee chaa Cristopa ooda eperãarã k'aripait'ee jaratee wãpachi Cesarea p'uurude panarumaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Felipepa mãga oo bɨ misa, Saulopa Cristode ijãapataarã peek'ooit'eeda apachi. Mapa wãji judiorã p'aareerã poro waibɨamaa ");
INSERT INTO sjaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mãik'aapa iidiji k'art'a p'ã teedamerã. K'ĩsia iru baji wãit'ee Damasco p'uurudee Tachi Ak'õre Ode P'anɨɨrãda apata jɨrɨde, ɨmɨk'ĩraarã wẽraarã ome, mãgɨɨrã jita p'e ateeit'ee Jerusalendee. Ma k'art'a p'ãdap'edaade jaraji Saulopa oo k'inia bɨ, judiorã poroorãpa Tachi Ak'õre Ũraa jarateepata te bee chaa k'awaadamerã mãik'aapa k'aripadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma k'art'a p'ãdap'edaa atap'eda, Saulo wãji. Damasco k'ait'a pa wãk'ãri, ɨt'ariipa ichi ɨ̃rɨ ɨ̃daa jẽra t'ĩudachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mãga unuk'ãri, Saulo eujãde baainaji. Maap'eda pedee ũriji: —Saulo, Saulo ¿sãap'eda mɨchideerã jɨrɨ nima? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulopa iidiji: —¿Pɨ, k'aima? aji. Chi pedee badapa p'anauji: —Mɨ Jesupɨ, pɨa jɨrɨ ni eperãarã poro waibɨa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","P'irabáiji mãik'aapa wã́ji p'uurudee. Mama jaradai pɨa k'ãata ooit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo ome wã nipadap'edaarã pedee wẽe ak'ɨnɨ̃ p'aneejida p'era jõnɨpa, ãrapa pedee ũridap'edaa perã. Mamĩda unuda-e paji k'aipata pedee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ma t'ẽepai Saulo p'irabaidachi. Mamĩda tau ẽek'ãri, maarepida unuk'aa paji. Mãgá juade jitadap'eda, ateejida Damascodee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","K'ãima õpee mama baji tau p'ãriu; maarepida ne-inaa to-ee mãik'aapa nek'o-ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ma p'uurude bapachi eperã Cristode ijãapari, t'ɨ̃jarapatap'edaa Ananías. Saulo mãga bɨ misa, Ak'õrepa k'ãimok'araa pɨk'a bɨde Ananías t'ɨ̃jaraji. Ichia p'anauji: —Tachi Waibɨa, mɨ nama bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ak'õrepa mãgaji: —Wã́ji calle t'ɨ̃jarapata Derechamaa mãik'aapa Judas tede iidíji Tarso pida, t'ɨ̃jarapata Saulo. Mãgɨpa mɨmaa ɨt'aa t'ɨ̃maa bɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mãgɨmaa k'ãimok'araa pɨk'a bɨde mɨa unupijida aji, eperã t'ɨ̃jarapata Ananías wãru irumaa mãik'aapa jua bɨru iru ɨ̃rɨ, waya pia unumerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mãga ũrik'ãri, Ananiapa mãgaji: —Tachi Waibɨa, mɨa ũridooda aji, jã eperãpa pɨde ijãapataarã miapida Jerusalende. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɨ̃rá nama che bɨ p'aareerã poroorãpa k'aripa k'inia p'anadairã. Maperã pëijidada aji, pɨde ijãapataarã jita p'e atade. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mamĩda Ak'õrepa p'anauji: —Wãpáde aji, mɨa iru jɨrɨt'erada perã mɨ ũraa jarateenamerã awaraa eujãdepemaarãmaa mãik'aapa ãchi reyrãmaa, ichiaba Israel pidaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɨa irumaa k'awapiit'eeda aji, sãgapɨ iru mia iru p'anapataadait'ee, mɨa ooda jaratee k'inia bɨ k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Maap'eda Ananías wãji Saulo badamaa. Teeda panap'eda, jua bɨji iru ɨ̃rɨ mãik'aapa mãgaji: —K'õp'ãyo Saulo, pɨa unuda ode che wãk'ãri, Tachi Waibɨa Jesupata mɨ pëijida aji, pɨa waya unumerã mãik'aapa Tachi Ak'õre Jaure ome beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aramata Saulo taudeepa chik'o escamak'a baaijida mãik'aapa waya pia unu beeji. Maap'eda poro choopiji Ananiamaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","T'ẽepai nek'oji waya juatau paraait'ee. Ewari chok'ara-ee beeji Damascodepemaarã Cristode ijãapataarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulopa jarateenapachi Ak'õre Ũraa jarateepata tede. Jarapachi Jesuta Tachi Ak'õre Warra. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mãga ũridak'ãri, jõmaarãpa ak'ɨtrua para beepachi mãik'aapa mãgapachida: —¿Nãgɨ́ paji-ek'ã ajida, Jerusalende jɨrɨ nipapata peeit'ee jõmaweda Jesude ijãapataarã? ¿Ichiaba nama cheji-ek'ã ajida, ijãapataarã jita p'e ateede p'aareerã poroorãmaa? ");
INSERT INTO sjaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mãga jarapachida mĩda, Saulopa ewari chaa waapɨara jarateepachi Jesuta Tachi Ak'õrepa pëida eperãarã k'aripamerã. Mapa judiorã Damascode p'anapatap'edaarãpa k'awadak'aa paji k'ãata k'ĩsiadai. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma t'ẽepai taarã pak'ãri, judiorãpa pedeeteejida Saulo peet'aadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mamĩda ichia k'awaa ataji. Ãstaawa mãik'aapa p'ãrik'ua p'uuru t'ĩupata chaa ot'ewa p'anapachida uchiak'ãri jita atadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mamĩda ijãapataarãpa k'oraa choma bɨde t'ɨ atajida mãik'aapa chi p'uuru ik'aawa t'ɨak'au jẽra bɨ ɨ̃rɨɨpa ɨrabai pëijida. Mãgá mirudachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mamãik'aapa Saulo Jerusalendee wãji. Mama ijãapataarã ome k'õp'ãyo meraa k'inia baji. Mamĩda jõmaarãpa iru waawee p'anapachida. Ijãadak'aa paji wãara irua Cristode ijãa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Awaraa ijãapataarã mãga p'anajida mĩda, Bernabepa ateeji Cristopa jɨrɨt'eradaarãmaa. Nepɨrɨji Saulopa Tachi Waibɨa unuda Damasco ode mãik'aapa Jesupa irumaa pedeeda. Maap'eda nepɨrɨji Saulo Damascode bak'ãri, waawee-ee jarateemaa bada Jesupa ooda. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mãgá Saulo beeji Jerusalende mãik'aapa nipapachi Cristode ijãapataarã ome. Mama bɨde Cristopa ooda waawee-ee jarateepachi judiorãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ichiaba aupedeepachi judiorã griego pedee pedeepataarã ome. Mapa ãrapa iru peet'aa k'inia p'anapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cristode ijãapataarãpa mãga k'awaadak'ãri, ateejida Cesarea p'uurudee. Mamãik'aapa pëijida Tarso p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Maapai ijãapataarã Judeadepemaarã, Galileadepemaarã mãik'aapa Samariadepemaarã k'ãiwee p'anapachida. Ak'õre Jaurepa ãchi k'aripapachi perã, waapɨara oo k'awaa wãpachida Tachi Ak'õrepa oopi k'inia bɨ mãik'aapa chok'araara ĩwa wãpachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Maapai Pedropa Cristode ijãapataarãmaa p'asia nipak'ãri, panaji Lida p'uurude. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mama ununaji eperã t'ɨ̃jarapatap'edaa Eneas. Mãgɨ́ ocho años iru baji chiwa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma eperã unuk'ãri, Pedropa irumaa mãgaji: —Eneas, Jesucristopa pɨ jɨparupɨ. P'irabaipáde aji, mãik'aapa pɨchi p'aru bedáji. Aramata Eneas p'irabaidachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chok'ara Lida p'uurude p'anapatap'edaarãpa mãik'aapa Sarón eujãde p'anapatap'edaarãpa Eneas jɨpa bɨ unudak'ãri, Jesucristode ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Maapai Jope p'uurude baji wẽra Cristode ijãapari, t'ɨ̃jarapachida Tabita; griego pedeede Dorcas apata. Mãgɨ́ wẽrapa awaraarã k'aripapachi mãik'aapa chupɨria beerãmaa ne-inaa teepachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma wẽra k'ayaadachi mãik'aapa jai-idaaji. Judiorãpa oopatap'edaak'a iru k'ap'ɨa k'uit'aadap'eda, te ɨt'ɨpema pisode bɨnajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Maapai Pedro Lida p'uurude baji. Lida Jope p'uuru k'ait'a bada perã, ijãapataarãpa eperãarã omé pëijida irumaa. Mãganajida: —Isapai chepáde ajida, Jopedee. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro wãji ãchi ome mãik'aapa panadak'ãri, ateejida piuda bɨmaa. Jõmaweda p'ẽtrãarã jẽe para baji iru ik'aawa mãik'aapa Pedromaa ak'ɨpijida Dorcapa p'aru k'aat'ɨda chok'ai bak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedropa jõmaweda taawaa uchiapik'ooji. Mãpai bedabaip'eda, ɨt'aa t'ɨ̃ji. T'ẽepai jai-idaa badamaa ak'ɨji mãik'aapa mãgaji: —¡Tabita, p'irabáiji! Iru tau ẽeji mãik'aapa Pedro unuk'ãri, su-ak'ɨ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedropa juadeepa p'irabai ataji mãik'aapa t'ɨ̃ p'eji chi p'ẽtrãarã mãik'aapa awaraa ijãapataarã, ãchimaa ak'ɨpiit'ee chok'ai bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jopedepemaarãpa mãga k'awaadak'ãri, chok'ara Cristode ijãajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Maperã Pedro k'ãima chok'ara beeji ma p'uurude, ne-e p'oopari t'ɨ̃jarapatap'edaa Simón tede. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pedro Jope p'uurude bɨ misa, Cesarea p'uurude baji eperã t'ɨ̃jarapatap'edaa Cornelio. Mãgɨ́ Romadepema soldaorã batallondepema poro paji. Ma batallón t'ɨ̃jarapachida Italiadepema. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mãgɨ́ eperã t'ãri pia bapachi. Ichi tedepemaarã ome Tachi Ak'õrede ijãapachida. Ichiaba p'arat'a teepachi judiorã k'aripait'ee mãik'aapa Tachi Ak'õremaa ɨt'aa t'ɨ̃pachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ewari aba a las tres, k'ãimok'araa pɨk'a bɨde taawapemak'a unuji ɨt'aripema ángel ichimãi t'ĩuru mãik'aapa jararu: —¡Cornelio! ");
INSERT INTO sjaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Corneliopa waaweede mãgɨ́ ángel k'ĩra ak'ɨ nɨ̃beep'eda, iidiji: —¿K'ãata k'inia bɨma? aji. P'anauji: —Tachi Ak'õrepa ũrijida aji, pɨa ɨt'aa iidida mãik'aapa unu bɨ pɨa p'arat'a teepari chupɨria beerãmaa. Pɨa pia oo bɨ iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eperã pë́iji Jope p'uurudee aneemerã Simón Pedro apata. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Irua pɨmaa Ak'õre net'aa jarateeit'ee. Awaraa Simón, ne-e p'oopari tede bɨ. Mãgɨ́ p'usa ide baparida aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ma ángel ichi ome pedeemaa bada wãk'ãri, Corneliopa t'ɨ̃ pëiji ichi mimiapataarã omé mãik'aapa Romadepema soldao aba Ak'õrede ijãa bada. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ichia k'ãimok'araa pɨk'a bɨde unuda nepɨrɨp'eda, ãchi pëiji Jopedee. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aɨ norema imat'ɨpa ãchi Jope p'uuru k'ait'a wãrutade, Pedro wãji terrazade ɨt'aa t'ɨ̃de. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mama bɨde jarrapisia nɨ̃beeji. Nejoomaa p'anɨ misa, ichia k'ãimok'araa pɨk'a bɨde ");
INSERT INTO sjaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","unuji pajã ewadaru. Madeepa ɨt'ariipa che wãji lienzok'a bɨ. Ma k'ɨ̃ chaa jɨ̃ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mãgɨ́ p'arude ne-animalaarã k'ĩra t'ãdoo p'anajida: bɨɨrɨpa nĩuteepata, bipa nĩuteepata mãik'aapa wãabaipata. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pedropa mãga ak'ɨ bɨde pedee ũriji: —Pedro, p'irabáiji. Péeji mãik'aapa k'opáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedropa p'anauji: —Tachi Waibɨa, k'o-eda aji, mɨchi t'oru weda waide k'ok'aa perã jãgee ne-animalaarã, pɨa k'oik'araa bɨda ada. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Waya pedee ũriji: —Ak'õrepa k'oipia papida k'oik'araa bɨda anaapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jarada õpee mãga jarap'eda, mãgɨ́ lienzok'a bɨ waya ɨt'aa wãji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedropa k'ĩsia beeji k'ãata jara k'inia baji ichia unuda mãgɨ́ k'ãimok'araa pɨk'a badade. Mãga nɨde Simón te iidi wãdapa Cornelio mimiapataarã pachejida te t'ĩupata t'aide. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Arii panadak'ãri, iidijida: —¿Nama bɨk'ã ajida, eperã t'ɨ̃jarapata Simón Pedro? ");
INSERT INTO sjaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","At'ãri Pedro k'ĩsiamaa bɨde ichi k'ãimok'araa pɨk'a badade, Ak'õre Jaurepa mãgaji irumaa: —Eperã õpeerãpa pɨ jɨrɨ nidada aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","P'irabáiji mãik'aapa ɨrabáiji. Wã́ji ãra ome k'ĩsia-ee, mɨata ãra pëida perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro ɨrabaip'eda, mãgaji ma eperãarãmaa: —Mɨda aji, parãpa jɨrɨ p'anɨ. ¿K'ãata oo che p'anɨma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","P'anaujida: —Tai chejida Cornelio, Romadepema soldaorã poropa pëida perã. Iru Tachi Ak'õrede ijãapari mãik'aapa t'ãri pia bapari. Mapa jõmaweda Cesareadepema judiorãpa iru k'inia iru p'anapata. Ɨt'aripema angelpa jaraji irumaa tai pëimerã pɨ atade, pɨ iru temaa wãmerã jarateede. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mãpai Pedropa teeda t'ĩupip'eda, nek'opiji mãik'aapa p'aru teeji k'ãidamerã. Aɨ norema, Pedro wãji ãchi ome. Jopedepema ijãapataarã ũk'uruurãpa iru k'õp'ãyanajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aɨ norema panajida Cesareade, Corneliopa nɨmaa badamãi, ichi te pidaarã ome mãik'aapa ichia t'ɨ̃ pëida k'õp'ãyoorã k'iniarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro aɨ temaa panak'ãri, Cornelio taawaa cheji mãik'aapa Pedro k'ĩrapite bedabaidachi, irumaa ɨt'aa t'ɨ̃it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mamĩda Pedropa p'irabaipiji, mãik'aapa mãgaji: —Mɨ jida pɨk'a, eperã jĩp'aada aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Maap'eda pedee wãdapa teeda t'ĩujida eperãarã see nɨ̃badamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mãpai Pedropa mãgaji: —Parãpa k'awa p'anɨda aji, tai judiorã t'ĩudaik'araa bɨ judio-eerã tede mãik'aapa k'õp'ãyo meraadaik'araa bɨ parã ome. Mamĩda Tachi Ak'õrepa mɨmaa k'awapijida aji, jõmaarã ome k'õp'ãyo meraaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Maperã jararutata mɨ cheji, k'ĩsia-ee. Ɨ̃rá k'awa k'inia bɨda aji, ¿k'ãare-it'eeta mɨ t'ɨ̃ pëiji? ");
INSERT INTO sjaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliopa p'anauji: —K'ãima k'ĩmari paruda aji, na horak'a k'ewara, mɨ ɨt'aa t'ɨ̃maa bɨ misa, eperã p'aru uchiterree jɨ̃ bɨ mɨ k'ĩrapite bainɨ̃ ba cheji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jaraji ma eperãpa: “Cornelio, Ak'õrepa ũrijida aji, pɨa ɨt'aa iidida mãik'aapa unu bɨda aji, pɨa p'arat'a teepari chupɨria beerãmaa. Pɨa pia oo bɨ iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eperã pëipáde aji, Jope p'uurudee eperã t'ɨ̃jarapata Simón Pedro atade. Iru baparida aji, awaraa Simón ne-e p'oopari tede p'usa ide.” ");
INSERT INTO sjaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Maperã mɨa isapai pëiji pɨ jɨrɨde mãik'aapa pɨ t'ãri pia bairã, cheji. Ɨ̃rá nama jõmaweda p'anɨ misa Ak'õre k'ĩrapite, taipa ũri k'inia p'anɨda aji, jõma Tachi Ak'õrepa pɨmaa jarapiru. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mãpai Pedro pedeemaa beeji: —Ɨ̃rá wãara mɨa k'awaaruda aji, Tachi Ak'õrepa mɨ auk'aarã apemaarã k'ãyaara pipɨara ak'ɨ-e bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Awaraa eujãdepemaarã jida k'inia iru bapari ichide ijãadak'ãri mãik'aapa ne-inaa pia oodak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tachi Ak'õrepa k'awapiji Israeldeepa uchiadap'edaarãmaa ichia ãchi k'ãiwee p'anapiit'ee Jesucristo k'aurepa, iru jõmaarã Waibɨa perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Parãpa pia k'awa p'anɨ Tachi Ak'õrepa ooda Galilea eujãde mãik'aapa Judea eujãde, Juanpa poro chooipia bɨda a nipada t'ẽepai. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ichiaba k'awa p'anɨ Tachi Ak'õrepa Jesús Nazaretdepema pëida ichia oopi bɨk'a oomerã, ichi Jaurepa k'aripap'eda. Mãgɨ́ Jesupa ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa oo nipaji mãik'aapa jɨpapachi eperãarã netuara merãtɨa beerã. Mãga oopachi Tachi Ak'õre iru ome bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tai iru ome nipapatap'edaarãpa unujida jõmaweda irua ooda Judea eujãde mãik'aapa Jerusalén p'uurude. Ichiaba p'anajida iru kurusode peedak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mamĩda Tachi Ak'õrepa iru chok'ai p'irabai ataji k'ãima õpeemaa, maap'eda taimaa unupiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Judiorã jõmaarãmaa unupi-e paji. Jĩp'a taimaapaita unupiji, Tachi Ak'õrepa aɨ naaweda tai jɨrɨt'erada perã iru unudamerã. Chok'ai p'irabaida t'ẽepai iru tai ome nek'oji ak'ɨpiit'ee wãara chok'ai bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aɨ t'ẽepai irua tai pëiji judiorãmaa jaranadamerã taipa unudap'edaa mãik'aapa jarateenadamerã iruta Tachi Ak'õrepa bɨda jõmaarã Waibɨa. Ak'õre ewari waibɨa ewate chok'ai p'anɨɨrãpa oopata mãik'aapa piudap'edaarãpa oopatap'edaa ak'ɨit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jõmaweda Ak'õre pedee jarapataarãpa irua ooit'ee bada k'awa p'anajida mãik'aapa jarapachida Tachi Ak'õrepa iru k'aurepa wẽpapipariit'ee irude ijãarutaarãpa p'ek'au k'achia oopata. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","At'ãri Pedro pedeemaa bɨde, Ak'õre Jaure cheji chi ũrimaa p'anadap'edaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judiorã ijãapataarã Pedro ome chedap'edaarã ak'ɨtrua para beeji, Tachi Ak'õrepa ichi Jaure ba chepida perã judio-eerã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ũripachida pedee para bɨ ãchia k'awada-e p'anɨ pedeede mãik'aapa Ak'õremaa ɨt'aa iidi para bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Mãpai Pedropa mãgaji: —Tachi Ak'õrepa na eperãarãmaa ichi Jaure pëiru taimaa pëidak'a. Mãga bɨta, ¿k'aipa poro choonaapáde adayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mãpai Pedropa jaraji Jesucristo t'ɨ̃de poro choopidamerã. Maap'eda Corneliopa chupɨria iidiji Pedromaa ãchi ome taarã beemerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Cristopa jɨrɨt'eradaarã mãik'aapa apemaarã ijãapataarã Judea eujãde p'anɨɨrãpa ũrijida judio-eerãpa Tachi Ak'õrepa jara pëida ũridap'eda, ichiaba Cristode ijãadap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mapa Pedro waya chek'ãri Jerusalendee, ũk'uru judiorã Cristode ijãa p'anadap'edaarã k'ĩrau p'anajida irua ooda k'aurepa judio-eerã t'ãide. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Iidijida: —¿Sãap'eda judio-eerã ak'ɨnajima? ajida. ¿Sãap'eda ãra ome nek'ojima? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mãpai Pedropa nepɨrɨmaa beeji jõmaweda Tachi Ak'õrepa ichimaa k'awapida: ");
INSERT INTO sjaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Mɨ bajida aji, Jope p'uurude. Ɨt'aa t'ɨ̃maa bɨde k'ãimok'araa pɨk'a bɨde unuji lienzok'a bɨ ɨt'ariipa mɨmaa che wã. Ma k'ɨ̃ chaa jɨ̃ beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pi-ia ak'ɨji k'awaait'ee k'ãata edajãde paraaji. Unuji ne-animalaarã k'ĩra t'ãdoo, bɨɨrɨpa nĩuteepata, k'achia beepata, bipa nĩuteepata mãik'aapa wãabaipata. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Maap'eda pedee ũriji: “Pedro, p'irabáiji. Peep'eda, k'óji.” ");
INSERT INTO sjaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mãpai mɨa p'anauji: “Waide jãgee ne-animalaarã pɨa k'oik'araa bɨda adadepema k'ok'aada” aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","’Mãpai ɨt'ariipa waya pedeeji: “Ak'õrepa k'oipia papida k'oik'araa bɨda anáaji.” ");
INSERT INTO sjaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jarada õpee mãga jaraji. Maap'eda ma lienzok'a bɨ waya ɨt'aa jidiu ataji. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aramata eperãarã õpee pëidap'edaa Cesareadeepa mɨ jɨrɨ chejida mɨ te badamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tachi Ak'õre Jaurepa mɨmaa jaraji wãmerã ãra ome, k'ĩsia-ee. Na k'õp'ãyoorã seis wãjida ichiaba mɨ ome. Jõmaweda t'ĩujida ma eperã ichi mimiapataarã pëi bada temãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma eperãpa taimaa nepɨrɨji ichia ángel unuda mãik'aapa ma angelpa jarada: “Eperã pëipáde aji, Jope p'uurudee eperã t'ɨ̃jarapata Simón Pedro atanadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Irua jarayada aji, sãga Ak'õrepa pɨ o k'achiadeepa k'aripa atai pɨchi te pidaarã ome.” ");
INSERT INTO sjaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","’Mɨ pachep'eda, pedeemaa beek'ãri, Ak'õre Jaure ãramaa cheji, naaweda tachi judiorãmaa chedak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mãga pak'ãri, mɨa k'irãpaji Tachi Waibɨapa jarada: “Wãara Juan Bautistapa poro choopachi paniapa. Mamĩda Tachi Ak'õrepa ichi Jaure ba chepiit'ee parã k'ap'ɨade.” ");
INSERT INTO sjaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mãgá mɨa k'awaaji Tachi Ak'õrepa ichi Jaure ba chepi k'inia bɨ ãra ome tachi ome ba chepidak'a, auk'a ijãapata perã Tachi Waibɨa Jesucristode. Mãga bɨta ¿sãga mɨa Tachi Ak'õrepa ooda k'achia bɨda ayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jerusalendepema ijãapataarãpa mãga ũridak'ãri, k'ĩup'ee para beeji. Maap'eda ɨt'aa t'ɨ̃jida Tachi Ak'õremaa. Mãgajida: —¡Mãgara Tachi Ak'õrepa ichi Jaure judio-eerã k'ap'ɨade ichiaba ba chepiit'ee, k'achia oodaamaa p'aneedak'ãri mãik'aapa Jesucristode ijãadak'ãri! ¡Mãgá ichita iru ome chok'ai p'anapataadait'ee! ");
INSERT INTO sjaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esteban piuda t'ẽepai, Jesucristode ijãapataarã jɨrɨmaa p'anadak'ãri peedait'ee, ũk'uru miruk'oodachida Fenicia eujãdee, Chipre isladee mãik'aapa Antioquía p'uurudee. Ãchi wãdap'edaa chaa Cristopa ooda eperãarã k'aripait'ee jarateepachida judiorãmaa aupai. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mamĩda Cristode ijãapataarãpa Chipredepemaarã mãik'aapa Cirene p'uurudepemaarã chedap'eda Antioquía p'uurude, Jesupa ooda eperãarã k'aripait'ee jarateepachida judio-eerãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tachi Ak'õrepa ãra k'aripaji. Mapa judio-eerã chok'ara Jesucristode ijãa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ijãapataarã Jerusalendepemaarãpa mãga ũridak'ãri, Bernabé pëijida Antioquiadee. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Panak'ãri, Bernabepa unuji Tachi Ak'õrepa ãra k'aripada. Mapa o-ĩadachi. Ũraaji t'ãripa Cristode ijãadamerã mãik'aapa irua oopi bɨk'a oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé eperã t'ãri pia bapachi. Cristode pia ijãapachi mãik'aapa oopachi Tachi Ak'õre Jaurepa oopi bɨk'a. Maperã eperãarã chok'ara Cristode ijãajida iru k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ma t'ẽepai Bernabé wãji Tarso p'uurudee Saulo jɨrɨde. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Unu atak'ãri, ateeji Antioquiadee. Mama p'aneejida año aba ijãapataarã ome jarateemaa Cristopa ooda eperãarã k'aripait'ee. Eperãarã chok'araarãpa ãchia jarateeda ũripachida. Antioquía p'uurude naapɨara Cristode ijãapataarã t'ɨ̃ bɨjida Cristodeerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Maapai Ak'õre pedee jarapataarã ũk'uru wãjida Jerusalendeepa Antioquiadee. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mama p'anɨde mãɨrãdepema aba t'ɨ̃jarapatap'edaa Agabo, ijãapataarã k'ĩrapite bainɨ̃ beep'eda, Tachi Ak'õre Jaurepa jarapiji jarra oodait'ee jõmaweda Roma jua ek'ari p'anɨɨrã eujãde. Wãara, aɨ t'ẽepai mãgɨpa jaradak'a p'asaji César Claudio Romadepema reyrã poro waibɨa bak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antioquiadepema Cristode ijãapataarãpa mãga ũridak'ãri, pedeeteejida Judeadepema ijãapataarã k'aripadait'ee, ãchia p'arat'a teedai pitapai. ");
INSERT INTO sjaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mãgɨ́ p'arat'a p'edap'eda, Judeadepema ijãapataarã ak'ɨpataarãmaa tee pëijida Bernabé ome mãik'aapa Saulo ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bernabé Saulo ome Antioquía p'uurude at'ãri p'anɨ misa, Rey Herodepa Cristode ijãapataarã ũk'uru jɨrɨmaa beeji miapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jaraji Juan ɨ̃pema, Santiago espadapa peet'aadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodepa k'awaak'ãri judiorã o-ĩa p'anɨ ichia oo bɨ unudap'eda, ichiaba Pedro jita atapiji. Mãga ooji judiorãpa fiesta pan levadura wẽe k'opata oo p'anɨde. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedro jita atadap'eda, Herodepa carcelde t'ɨ nɨ̃bɨpiji. Mama Romadepema soldaorã dieciséis p'epachida k'ĩmarik'ĩmarii carcel jɨ̃adamerã. Herodepa k'ĩsia iru baji Pedro ɨmɨateeit'ee eperãarã taide Pascua fiesta t'ẽepai. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mãgá Pedro baji carcelde jɨ̃apari paraa. Mamĩda awaraa Cristode ijãapataarãpa ewari chaa ɨt'aa t'ɨ̃pachida iru pari. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodepa Pedro ɨmɨateeit'ee pada ewate aɨ noreweda p'ãrik'ua, Pedro jua cadenapa soldao jua k'ĩraichaa jɨ̃p'eda, k'ãi baji ãchi esajĩak'a. Mãɨmisa apemaarã soldaorã taawa jɨ̃amaa p'anapachida chi t'ĩupatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mãga nɨde Pedromãi ɨ̃daadachi mãik'aapa ɨt'aripema ángel bainɨ̃ ba cheji. Mãgɨpa Pedro orromãi t'õbaiji mãik'aapa mãgaji: —¡Isapai p'irabáiji! Mãga jararuta, cadena baaik'oodachida Pedro juadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mãpai ma angelpa mãgaji: —P'aru jɨ̃ beep'eda, pɨchi chancla jɨ̃ béeji. Mãga ooji Pedropa. Maap'eda mãgaji angelpa: —Pɨchi ɨ̃rɨpema p'aru jɨ̃ beep'eda, mɨ ome chéji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro uchiaji iru t'ẽe, k'awa-ee wãara wa seewa angelpa oo bɨ. Ichi k'ĩsia-it'ee k'ãimok'araa pɨk'a baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mamĩda wãyaajida chi jɨ̃apari naapema, maap'eda araarepema ichiaba. Carcel puerta hierrodee ooda badamãi pachedak'ãri calle jãdee uchiadait'ee, ma puerta ichi itu ewadachi. Uchiadap'eda, calle jãde wãjida mãik'aapa ma angelpa ituaba atabëiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mãpai Pedropa k'awaaji k'ãimok'araa-e bɨ. Mapa mãgaji: —Ɨ̃rá mɨa k'awa bɨda aji, wãara Tachi Ak'õrepa ichi ángel pëiji mɨ k'aripait'ee Herodes juadeepa mãik'aapa judiorã poroorã k'achia oodait'ee padadeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mãga k'awaak'ãri, Pedro wãji María temaa. Mãgɨ́ Juan nawe paji. Ma Juan ichiaba t'ɨ̃jarapachida Marcos. Arii ijãapataarã chok'ara ɨt'aa t'ɨ̃maa p'anajida Pedro pari. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ma te t'ĩupata taawaik'a eereepa Pedropa t'ɨ̃ji. Mãpai te ak'ɨpari awẽra Rode apatap'edaapa ak'ɨ cheji k'awaait'ee k'aita mãga ni. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro otau k'awaak'ãri, o-ĩadachi. O-ĩapa puerta ewa-ee, edaa p'iradachi jarade Pedro taawa bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mãga ũridak'ãri, mãgajida: —¿K'ĩra k'awa-ee nɨ̃bɨk'ã? ajida. Mamĩda ichia wãarada ak'ãri, ãchia mãgapachida: —Iru-epɨ, Tachi Ak'õre angelpɨ; iru ome nipaparida ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mãɨmisa Pedropa taawaik'a eereepa t'ɨ̃maa bapachi. Mãpai puerta ewadap'eda, unudak'ãri, p'eradachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mamĩda ichi juapa jaraji k'ĩup'ee p'aneedamerã mãik'aapa nepɨrɨji sãga Tachi Ak'õrepa ichi carceldeepa uchia atada. Maap'eda mãgaji: —Nepɨrɨde wã́tɨ Santiagomaa mãik'aapa apemaarã Cristode ijãapataarãmaa. T'ẽepai Pedro wãji awara ãyaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ewarik'ãri, carcelde k'ĩraupik'a para beeji, k'awada-e pada perã sãmaa wãji Pedro. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodepa k'awaa atak'ãri, jaraji jɨrɨnadamerã. Mamĩda p'oyaa unuda-e pada perã, chi soldaorã jɨ̃a p'anadap'edaarãmaa iidip'eda, jita p'e atapiji mãik'aapa peepik'ooji. Ma t'ẽepai Herodes uchiaji Judeadeepa mãik'aapa Cesarea p'uurude banaji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Maapai Herodes k'ĩrau baji Tiro p'uurudepemaarã ome mãik'aapa Sidón p'uurudepemaarã ome. Mapa ãchi wãjida iru ome pedeede. Mamĩda panadak'ãri, p'aajida Herodes mimiapataarã poro aba, Blastomaa, irua naapɨara chupɨria iidinamerã ãchi pari, chõoda-e pait'ee. Mãga oojida ãchia ne-inaa k'odait'ee netonapachida perã Herodes jua ek'ari p'anadap'edaarã eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ma eperãpa iidinak'ãri, Herodepa jaraji ichia jararu ewate chedamerã. Ma ewate pak'ãri, ichi p'aru pia jɨ̃ beep'eda, rey su-ak'ɨ beeparide su-ak'ɨ banaji mãik'aapa pedeemaa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ichi pedeemaa ũridak'ãri, eperãarã biuk'a nɨ̃beeji mãik'aapa mãgapachida: —Nãgɨ́ eperã nama pedeemaa bɨ eperã-eda ajida. Ak'õre waibɨ́ak'ata bɨda apachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aramata, angelpa Herodes k'ayaapit'aaji, irua ɨtrɨa-e pada perã mãga jaradak'ãri. Mapa mok'it'a k'ida p'uapa piuji. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Maapai ijãapataarã chok'araara ĩwa wãpachida. T'ɨmɨpɨara jaratee wãpachida Tachi Ak'õrepa ooda Cristo piuda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé Saulo ome Jerusalendepema ijãapataarãmaa tee chejida ma p'arat'a ijãapataarãpa teedap'edaa Antioquiade. Maap'eda waya wãjida Antioquiadee. Ãchi ome ateejida Juan. Mãgɨ́ ichiaba t'ɨ̃jarapachida Marcos. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquiadepema Cristode ijãapataarã t'ãide paraaji Ak'õre pedee jarapataarã mãik'aapa jarateepataarã. Mãgɨɨrã paji Bernabé, Simón (ichiaba t'ɨ̃jarapata Nerro), Lucio Cirene p'uurudepema, Menahem (auk'a warida Galilea pidaarã poro Herodes ome) mãik'aapa Saulo. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ewari aba mãɨrã ɨt'aa t'ɨ̃maa p'anɨde nek'oda-ee, Ak'õre Jaurepa mãgaji: —Awara bɨdapáde aji, Bernabé mãik'aapa Saulo, mɨa ãra jɨrɨt'erada perã oodamerã mimia mɨa k'ĩsia iru bɨ ãchi-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ɨt'aa t'ɨ̃dap'eda nek'oda-ee, mãgɨɨrã ɨ̃rɨ jua bɨjida, maap'eda pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tachi Ak'õre Jaurepa mãgá pëida perã, Bernabé Saulo ome wãjida Seleucia p'uurudee. Mama barcode bataudap'eda, Chipre isladee wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina p'uurude panadak'ãri, Tachi Ak'õrepa ooda Cristo piuda k'aurepa judiorãmaa jarateemaa p'aneejida, Tachi Ak'õre Ũraa jarateepata tede. Ichiaba Juan Marcos mama nipaji ãchi ome k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Chipre isla jõmaweda bɨɨrɨpa wãyaa wãdapa, jaratee wãjida Pafos p'uurude panarutamaa. Mama ununajida judío t'ɨ̃jarapatap'edaa Barjesús. Mãgɨpa petau tau k'awaa baji. Seewa-idaa bapachi, ichia Tachi Ak'õre pedee jaraparida apachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mãgɨ́ Romadepema poro Sergio Paulo k'õp'ãyo paji. Sergio Paulo k'ĩsia k'awaa baji. Mapa t'ɨ̃ pëiji Bernabé mãik'aapa Saulo, ũri k'inia bada perã ãchia jarateepata Tachi Ak'õrepa ooda Cristo piuda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mamĩda ãchia jarateemaa p'anɨ misa, mãgɨ́ petau tau k'awaa bɨpa, (griego pedeede Elimas apatap'edaa) jarapachi Romadepema poromaa irua ijãanaamerã ãchia jaratee p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mãpai Saulo, ichiaba Pablo apatap'edaapa, Ak'õre Jaure iru ome bapachi perã, mãgɨ́ petau tau k'awaa bɨ k'ĩra pia ak'ɨji mãik'aapa mãgaji: ");
INSERT INTO sjaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—¡Seewa-idaa, netuara warra! ¡K'achia ooyaa bɨ! ¿Chĩara k'ũra k'inia bɨ-ek'ã seewa jara bɨpa? ¿Sãap'eda Ak'õrepa jarateepida pɨa seewada aparima? ");
INSERT INTO sjaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ɨ̃raweda Ak'õrepa pɨ k'achia ooit'ee. Pɨ tau p'ãriu baibeeit'ee. Taarã mãgá nipait'eeda aji, ak'õrejĩru unu-ee. Aramata Elimas tau p'ãriudachi mãik'aapa pariatua jɨrɨ nipapachi ichi juadeepa jidibai ateedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Romadepema poropa mãga unuk'ãri mãik'aapa ãchia jaratee p'anɨ ũrik'ãri, k'awaaji wãarata pedee p'anɨ. Mapa Cristode ijãaji. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo mãik'aapa ichi ome nipapatap'edaarã Pafos p'uurudeepa barcode wãjida Perge p'uurudee. Mãgɨ́ p'uuru Panfilia eujãde bɨ. Mama p'anɨde Juan Marcopa ãchi atabëiji mãik'aapa ãpɨtee wãji Jerusalendee. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mamĩda ãchi Pergedeepa wãjida Antioquía p'uurudee. Mãgɨ́ p'uuru Pisidia eujãde bɨ. Mama p'anɨde ɨ̃ipata ewate t'ĩujida judiorã Tachi Ak'õre Ũraa jarateepata tede mãik'aapa su-ak'ɨ p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mãgɨ́ tedepema judiorã poroorãpa Moisepa p'ãda mãik'aapa Ak'õre pedee jarapataarãpa p'ãdap'edaa pedeedap'eda, jara pëijida Pablomaa mãik'aapa Bernabemaa: —Tachi auk'aarã, parãpa eperãarãmaa pedee pia jara k'inia p'anɨ pɨrã, ɨ̃raweda jaradapáde aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mãpai Pablo ɨt'a ak'ɨnɨ̃ beep'eda mãik'aapa juapa jarap'eda k'ĩup'ee p'aneedamerã, mãgaji: —Ũrítɨ Israel pidaarã mãik'aapa parã awaraa eujãdepemaarã, Tachi Ak'õrede ijãa p'anɨɨrã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tai Israel pidaarãpa ijãa p'anɨda aji, chonaarãweda Tachi Ak'õrepa tai chonaarã jɨrɨt'eraji ichi-it'ee. Ãchi ĩwapiji Egiptode, at'ãri awaraa eujãdepemaarãk'a p'anajida mĩda. Ichi juapa ãchi mamãik'aapa uchiapiji, ichi jõmaarã k'ãyaara waibɨara bairã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ma awara ãchi ak'ɨpachi cuarenta años eujã pania wẽe bɨde wãyaadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaán eujãde panadak'ãri, ichia Canaandepema awara-awaraa to pidaarã siete k'iniipiji, ãra eujã tai judiorã chonaarãpa atadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ak'õrepa tai judiorã jɨrɨt'eradak'ãriipa mãgɨ́ eujã Canaánde atarutamaa cuatrocientos cincuenta años paji. ’Ma t'ẽepai Tachi Ak'õrepa eperãarã charraarãk'a bɨji aba-abaa, ãchi ak'ɨpataadamerã, ichi pedee jarapari Samuel ãchi poro waibɨa parumaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mãpai ãchia iidijida Samuelmaa rey bɨmerã ãchi ak'ɨpari. Mapa Tachi Ak'õrepa Saúl ãchi rey papiji cuarenta años. Mãgɨ́ Quis warra paji, Benjamín ëreerãdepema. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Aɨ t'ẽepai Saúl uchiapip'eda, Tachi Ak'õrepa Rey David bɨji iru pari. Mãgaji: ‘Mɨa Jesé warra David unujida aji, mɨa k'inia bɨk'a. Ichiaba mɨa k'awa bɨda aji, irua ooit'ee mɨa oopi k'inia bɨk'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","’Rey David ëreerãdeepa uchiaji Tachi K'aripapari. Mãgɨ́ Jesús, Tachi Ak'õrepa pëida Israel pidaarã k'aripamerã, ichia naaweda jaradak'a ichi pedee jarapataarã it'aideepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mãgɨ́ Jesús chei naaweda, Juan Bautistapa jarateepachi jõmaweda Israel pidaarãmaa ãchi p'ek'au k'achia oo amaadamerã mãik'aapa poro choopidamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mãpai Juanpa, ichi mimia aupa wãk'ãri, mãgaji: ‘Mɨ parã poro waibɨa-e, parãpa k'ĩsia p'anɨk'a. Mamĩda mɨ t'ẽepai cheit'eeda aji, eperãarã poro waibɨara bɨ. Mɨa iru chancla jida ẽraik'araa bɨda aji, iru mɨ k'ãyaara waibɨara bairã.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Mɨchi auk'aarã, Abrahamdeepa uchiadap'edaarã, ichiaba parã judio-eerã, ¡ũrítɨ! Tachi Ak'õrepa tachi jõmaarãmaa jara pëi bɨ sãga ichia tachi o k'achiadeepa k'aripa ata k'inia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Eperãarã Jerusalende p'anapatap'edaarãpa mãik'aapa ãchi poroorãpa k'awada-e p'anajida Jesús Tachi Ak'õrepa pëida eperãarã k'aripamerã. Ichiaba k'awadak'aa paji Tachi Ak'õrepa jara k'inia bada chonaarãwedapema Ak'õre pedee jarapataarãpa p'ãdap'edaade, ɨ̃ipata ewari chaa judiorãpa mãgɨ́ leepata mĩda Ak'õre Ũraa jarateepata tede. Maperã ãchiata oojida ma ũraade jaradap'edaak'a Jesús peepidak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Irua maarepida k'achia oo-e paji. Mamĩda ãchia iru pee k'inia p'anajida. Mapa Pilatomaa iidinajida peepit'aamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Maap'eda jõma oodap'eda iru ome Tachi Ak'õre Ũraa p'ãdade jara badak'a, awaraarãpa kurusodeepa ɨrabai atadap'eda, ɨanajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mamĩda Tachi Ak'õrépata chok'ai p'irabaipiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aɨ t'ẽepai iru ome chedap'edaarãpa Galileadeepa Jerusalendee unuda chok'ara unupachida, mãik'aapa ɨ̃rá tai auk'aarãmaa ãchia unudap'edaa jara p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Mapa taipa parãmaa nãgɨ́ pedee pia jara k'inia p'anɨ. Tai judiorã chonaarãmaa Tachi Ak'õrepa jaraji ");
INSERT INTO sjaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","aba pëiit'ee eperãarã k'aripade. Mamĩda ichia mãgɨ́ pëi-e paji tai chonaarã chok'ai p'anɨ weda. Jĩp'a pëiji ãchideepa uchiadap'edaarã, tachi ɨ̃rapemaarã chok'ai p'anɨde. Mãgɨ́ pëida paji ichi Warra Jesús, ichia chok'ai p'irabaipida. K'awa p'anɨ ichi Warra pëiji ichi ũraa p'ãdadepema Salmode jara bairã: ‘Mɨa idi jõmaarãmaa jara bɨ pɨ mɨ Warra.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tachi Ak'õrepa jaraji ichi Warra chok'ai p'irabaipiit'ee, waa piu-e pait'ee ichi ũraa p'ãdade jara bɨk'a: ‘Rey Davidmaa jaradak'a mɨa ooit'ee, mɨa wãarata jarapari perã.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ichiaba jara bɨ awaraa Salmo p'ãdade: ‘Pɨa mɨ k'ap'ɨa beraupi-e pait'ee, mɨa oopari perã pɨa mɨmaa oopi bɨk'a.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","’Wãara na eujãde bak'ãri, Rey Davidpa ooji Tachi Ak'õrepa k'ĩsia iru badak'a. Maap'eda jai-idaaji. Ɨajida chi ak'õreerã ik'aawa mãik'aapa ichi k'ap'ɨa beraudachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mamĩda Tachi Ak'õrepa Jesús chok'ai p'irabaipida k'ap'ɨa berau-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Maperãpɨ, tachi auk'aarã, k'awaadaipia bɨ Tachi Ak'õrepa tachia p'ek'au k'achia oopata wẽpapipari Jesús piuda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ma k'aurepa ichide ijãapataarã p'ek'au k'achia wẽe p'anɨ Tachi Ak'õre k'ĩrapite. Moisepa p'ãdak'a oodap'edaa k'aurepa p'ek'au k'achia wẽpak'aa paji mĩda, Tachi Ak'õrepa Jesude ijãapataarã p'ek'au k'achia wẽpapipari, Jesupa ooda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","K'ĩrak'aupai p'anadai Tachi Ak'õre pedee jarapataarãpa p'ãdap'edaade jara bɨk'a: ");
INSERT INTO sjaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ũrítɨ parã chi oo iru p'anapataarãpa Tachi Ak'õrepa jara bɨ. Ak'ɨ́tɨ mãik'aapa ak'ɨtrua para bátɨ. Parã at'ãri chok'ai p'anɨde mɨa ooit'ee ne-inaa parãpa ijãada-e pai, aɨ naaweda abaapa parãmaa mãga jararu pɨjida.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo Bernabé ome judiorã Ak'õre Ũraa jarateepata tedeepa uchiadak'ãri, chi waa k'awa k'inia p'anadap'edaarãpa chupɨria iidijida ɨ̃ipata ewate pak'ãri waya jaratee chedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Judiorã mãik'aapa judio-eerã Tachi Ak'õrede ijãapataarã uchiadap'eda, chok'ara wãjida Pablo mãik'aapa Bernabé t'ẽe. Maperã ãchia ma Ak'õrede ijãapatap'edaarãmaa ũraajida k'irãpadamerã Tachi Ak'õrepa ãchi k'aripada Cristo piuda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Apema tomiade ɨ̃ipata ewate, perá jõmaweda p'uuru pidaarã cheepurujida Ak'õrepa jarapida ũride. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mamĩda judiorãpa unudak'ãri eperãarã chok'ara see nɨ̃bɨ, k'ĩraudachida mãik'aapa Pablomaa ik'achia jaramaa p'aneejida, Cristo ãpɨte paara. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mãpai Pablopa Bernabé ome waawee-ee p'anaujida: —Tachi Ak'õrepa tai naapɨara pëijida ajida, parã judiorãmaa ichia jara pëida Cristode jarateedamerã. Mamĩda parãpa ũri k'iniada-e p'anadairã, pãchi k'ĩradoopa atuadait'ee. Mãga p'anadairã, tai wãdait'ee judio-eerãmaa jarateede. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mãga oodait'ee Tachi Ak'õre Ũraa p'ãdade jara bairã: ‘K'õp'ãyoorã ome lámpara pëipatak'a ɨ̃daamerã ode p'ãrik'ua nipadak'ãri, mãga pɨk'a mɨa pɨ pëiru mɨ o ak'ɨpimerã na p'ek'au eujãdepemaarãmaa. Mɨa mãgá pëiru k'inia bairã pɨa chi t'ɨmɨara beerã paara o k'achiadeepa k'aripa atamerã.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Judio-eerãpa mãga ũridak'ãri, o-ĩa para beeji mãik'aapa Tachi Ak'õrepa jara pëida pia bɨda apachida. Mãpai Cristode ijãajida chi Tachi Ak'õrepa k'ĩsia iru bada ichita chok'ai p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mãgɨɨrãpa Tachi Ak'õrepa ooda jaratee wãpachida ãchi wãrutamaa. Cristo piuda k'aurepa irua tachi o k'achiadeepa k'aripa ataji. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mamĩda judiorãpa pedeejida wẽraarã ãchik'a Tachi Ak'õre waaweepataarã ome. Pablo Bernabé ome ãpɨte ik'achia pedeejida. Maperã ma p'arat'ara beerãpa mãik'aapa ɨmɨk'ĩraarã chi p'uuru pidaarã poroorãpa Pablo Bernabé ome ma eujãdeepa jëret'aajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mãɨrãpa mãga oodak'ãri, Pablo Bernabé ome ãchi bɨɨrɨ p'ora nẽep'ejida ak'ɨpidait'ee waa jarateeda-e pait'ee ma judiorãmaa, Cristode ijãadak'aa p'anadap'edaa perã. Maap'eda wãjida Iconio p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pablo Bernabé ome mãgá jërek'oojida mĩda, chi Cristode ijãapataarã ma eujãde o-ĩa p'anajida, Tachi Ak'õre Jaure ãchi ome bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconiode panadak'ãri, oojida Antioquiade oodap'edaak'a. T'ĩujida judiorã Ak'õre Ũraa jarateepata tede mãik'aapa jarajida Tachi Ak'õre Jaurepa jarapidak'a. Mapa judiorã chok'ara Cristode ijãajida, judio-eerã jida ichiaba. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mamĩda judiorã Cristode ijãa k'iniada-ee p'anadap'edaarãpa pedee k'achia jaramaa p'aneejida Pablo mãik'aapa Bernabé ãpɨte. Mapa judio-eerã k'ĩraudachida ãra ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mãga p'anajida mĩda, ãchi omé arii taarãjida mãik'aapa waawee-ee jarateepachida Tachi Ak'õrepa jarapidak'a, Cristopa ãchi k'aripa bapachi perã. Jarateepachida Tachi Ak'õrepa eperãarã pia ooda Cristo piuda k'aurepa. Maperã Ak'õrepa ãchimaa oopiji ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mamĩda, mãga oo p'anajida mĩda, ma p'uuru pidaarã k'ĩsia awara-awaraa p'anajida. Ũk'uru judiorã eere p'anajida, jõdee chi apemaarã Cristopa jɨrɨt'eradaarã eere. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Maapai ũk'uru judiorã mãik'aapa judio-eerã pedeeteejida ãchi poroorã ome miapidait'ee; mãupa bat'a peedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mamĩda Pablopa Bernabé ome k'awaadak'ãri, mirudachida Licaonia eujãdee, Listra p'uurude mãik'aapa Derbe p'uurude, ichiaba ma p'uuru ik'aawa. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mama ichiaba Jesupa ooda eperãarã k'aripait'ee jarateepachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra p'uurude p'anɨde unujida eperã p'oyaa t'ɨak'aa bɨ, ichi t'oru weda chiwa bada perã. Ma eperã su-ak'ɨ baji ");
INSERT INTO sjaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ũrimaa Pablopa jarateemaa bɨ. Pablopa irumaa ak'ɨk'ãri mãik'aapa unuk'ãri wãara ijãa bɨ, k'awaji jɨpaipia bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mapa ma eperãmaa golpe pedeeji: —P'irabáiji mãik'aapa jĩp'a bainɨ̃ béeji. Aramata ma eperã p'inajɨ̃tɨ bainɨ̃ beeji mãik'aapa p'ɨrrɨa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablopa ooda unudak'ãri, arii p'anadap'edaarã biuk'a nɨ̃beeji Licaonia pidaarã pedeede. Mamĩda Pablopa Bernabé ome ãrapa jara p'anɨ k'awada-e paji. Ãrapa mãgajida: —¡Nãgɨɨrã ak'õre waibɨarã, ɨt'ariipa edaa che p'anɨ tachi t'ãide eperãarãk'a! ");
INSERT INTO sjaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mãpai Bernabé t'ɨ̃ bɨjida Greciadepemaarã ak'õre waibɨa Zeus. Jõdee Pablo t'ɨ̃ bɨjida Hermes, ichiata pedee bapachi perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ma p'uuru t'ĩupata k'ait'a Zeumaa ɨt'aa t'ɨ̃pata te iru p'anajida. Maperã atapijida Zeus p'aaremaa aneemerã p'ak'a ɨmɨk'ĩra, paadait'ee Pablo mãik'aapa Bernabé k'ĩrapite; ma awara nep'ono aneemerã teedait'ee Pablomaa mãik'aapa Bernabemaa, ãchi ak'õre waibɨarã jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mamĩda Bernabé Pablo ome k'awaadak'ãri mãgá oo p'anɨ ɨt'aa t'ɨ̃dait'ee ãchi k'ĩrapite, ãchi p'aru jẽt'aajida t'ãri p'uapa. Maap'eda nãga bia t'ĩudachida eperãarã t'ãide: ");
INSERT INTO sjaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Eperãarã, ¿sãap'eda nãga oorutama? ajida. Tai ichiaba eperãarãpɨ parãk'a. Ma-it'eepɨ tai che p'anɨ jaradait'ee nãgee net'aa vale-ee baibɨde ijãa amaadamerã; ma k'ãyaara Tachi Ak'õrede ijãadamerã, iru ichita bapari perã. Tachi Ak'õrepa ooji pajã, na eujã, p'usa mãik'aapa ne-inaa jõmaweda aɨde nɨ̃bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Naaweda Tachi Ak'õrepa na p'ek'au eujãdepemaarãmaa ita-aria ãchia oo k'iniata oopiji. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mamĩda ichia ãra ak'ɨ baji. Mãga oo bɨpa ak'ɨpiji ichi Tachi Ak'õre. Ichiata parã-it'ee k'oi chepipari ne-uu pia chaumerã. Mãgá iru p'anɨ nek'odait'ee mãik'aapa o-ĩa p'anadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pablopa Bernabé ome ma jõma jarajida mĩda, perá p'oyaada-e paji eperãarã p'ak'a ɨmɨk'ĩra peenaadamerã mãik'aapa ɨt'aa t'ɨ̃naadamerã ãchi k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Aɨ t'ẽepai pachejida judiorã Antioquía p'uurudeepa mãik'aapa Iconio p'uurudeepa. Eperãarã ãchi eere pa atadap'eda, Pablomaa mãupa bat'ajida peet'aadait'ee. Piu bɨ jĩak'aapa, p'uuru k'idaa jidiu baibɨnajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mamĩda Cristode ijãapataarã Pablomãi seedaidak'ãri, waya p'irabaiji. Maap'eda waya wãji p'uurudee mãik'aapa aɨ norema wãji Bernabé ome Derbe p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Cristopa ooda eperãarã k'aripait'ee jarateedak'ãri Derbede, eperãarã chok'ara ijãajida. Mama bap'eda, ãpɨtee chejida Listradee, Iconiodee mãik'aapa Antioquiadee. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ma nipadap'edaa chaa ũraajida Cristode ijãapataarã waapɨara ijãa p'aneedamerã mãik'aapa mãgajida: —Ɨt'aa wãdai naaweda, tachi ichita miadait'eeda ajida, Cristode ijãapata perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ichiaba ijãapataarã para bee chaa ũk'uru jɨrɨt'erajida ijãapataarã ak'ɨ p'anapataadamerã. Mãpai ɨt'aa t'ɨ̃dap'eda nek'oda-ee, ijãapataarã jõmaweda Ak'õre juade bɨjida. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Maap'eda Pisidia eujãde wãyaajida Panfilia eujãde panarutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mama bɨde Ak'õrepa jarapidak'a jarateejida Perge p'uurude. Mamãik'aapa wãjida Atalía p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mama barcode bataudap'eda, wãjida Antioquía p'uurudee, chi ijãapataarãpa Ak'õre juade bɨdap'edaamãi, irua ãchi pia ak'ɨ bapariimerã. Mãgá irua k'aripapachi perã, ãchia oojida jõma irua k'inia badak'a oodamerã ma wãdade. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pachedak'ãri Antioquiade, Cristode ijãapataarã t'ɨ̃ p'ejida mãik'aapa nepɨrɨjida Tachi Ak'õrepa ãchi pari ooda. Ichiaba nepɨrɨjida Ak'õrepa judio-eerãmaa ijãapida. ");
INSERT INTO sjaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Maap'eda Pablo Bernabé ome mama taarã p'aneejida Cristode ijãapataarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Maapai eperãarã Judeadeepa chejida Antioquiadee. Mãgɨɨrãpa Jesude ijãapataarãmaa jarateemaa p'aneejida. Mãgajida: —Pãchi ɨmɨk'ĩraarã k'ap'ɨade tauchaa bɨda-e pɨrã Moisepa p'ãdade jara bɨk'a, ɨt'aa wãda-e pait'eeda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mãpai Pablo Bernabé ome ijɨ̃atɨ pedeejida ãchi ome. Maap'eda Jesude ijãapataarãpa Pablo, Bernabé mãik'aapa awaraarã pëijida Jerusalendee mãgɨ́ jarateeda iidinadamerã Cristopa jɨrɨt'eradaarãmaa mãik'aapa Jerusalendepema ijãapataarã ak'ɨpataarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquiadepema ijãapataarãpa ãchi pëidap'eda, Fenicia eujãde mãik'aapa Samaria eujãde wãyaajida. Nepɨrɨjida judio-eerãpa Cristode ijãa p'anadap'edaa. Mãga ũridak'ãri, mãpema Cristode ijãapataarã o-ĩadachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo Bernabé ome Jerusalende pachedak'ãri, awaraa ijãapataarãpa ãra auteebaijida Cristopa jɨrɨt'eradaarã ijãapataarã ak'ɨpataarã ome. Chip'edaidap'eda ãra ome, Pablo mãik'aapa Bernabé nepɨrɨjida jõma Tachi Ak'õrepa ooda ãchi pari. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mamĩda ũk'uru fariseorã Cristode ijãapataarã, p'irabaijida mãik'aapa mãgajida: —Judio-eerã ijãa p'anɨɨrãmaa tauchaa bɨpidaipia bɨ ãchi ɨmɨk'ĩraarã k'ap'ɨade mãik'aapa oopidaipia bɨda ajida, Moisepa p'ãdade jara bɨk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mãpai seedachida Cristopa jɨrɨt'eradaarã mãik'aapa ijãapataarã ak'ɨpataarã k'ĩsiadait'ee ma pedee jaradade. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Taarã aupedee jõnɨde, Pedro p'irabaiji mãik'aapa mãgaji: —Ɨ̃pemaarã Cristo k'aurepa, parãpa k'awa p'anɨda aji, taarãru Tachi Ak'õrepa mɨ jɨrɨt'eraji Jesucristopa ooda eperãarã k'aripait'ee jaranamerã judio-eerãmaa, ãchia auk'a Jesude ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tachi Ak'õrepa ãchi t'ãride iru p'anadap'edaa k'awa bada perã, ak'ɨpiji ichia ãchi jida k'inia iru bɨ, tachi k'inia iru bɨk'a. Mãga ak'ɨpiji ãchimaa pëik'ãri ichi Jaure, tachimaa pëidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tachi Ak'õrepa ãchi auk'a ak'ɨpari tachik'a. Mãga k'awa p'anɨ ãchia p'ek'au k'achia oopata auk'a wẽpapik'ooda perã Cristode ijãadak'ãri, tachi ome oodak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɨ̃rá, ¿tachia sãga oodaima? ¿Oodaipia bɨk'ã Tachi Ak'õrepa jara-e padata? ¿Jõma ijãapataarãmaa oopidaik'ã mãgee ne-inaa chaaree Moisepa p'ãdade jara bɨk'a? Tachia mãik'aapa tachi chonaarãpa mãgee ne-inaa jõmaweda p'oyaa ooda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Maperã mãga oodaik'araa bɨ. Tachia ijãa p'anɨ Tachi Waibɨa Jesucristo tachi ome t'ãri pia bairã, tachi o k'achiadeepa k'aripa atait'ee ɨt'aa wãdamerã. Ãchia auk'a mãga ijãa p'anɨda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Maap'eda jõma k'ĩup'ee para beeji Bernabé Pablo ome nepɨrɨmaa p'aneedak'ãri Tachi Ak'õrepa oopida ãchimaa judio-eerã t'ãide, eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pedee aupadak'ãri, Santiagopa mãgaji: —Ɨ̃pemaarã, mɨ pedee ũrítɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedropa et'ewa nepɨrɨjida aji, Tachi Ak'õrepa judio-eerã k'aripada. Tachi Ak'õrepa ãchi jida jɨrɨpari ichideerã p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mãga bɨ iru pedee jarapataarãpa p'ãdap'edaade jara bɨk'a: ");
INSERT INTO sjaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nãga bap'eda, mɨa Rey David trua waya papiit'ee irudeepa uchiada jua ek'ari. Mɨa ooit'ee Israel pidaarã t'ãidepema te k'arawapataarãpa oopatak'a. Te t'eedaik'ãri, ãrapa t'eedeechoo jẽra bada araa p'epata te chiwidik'a bainɨ̃ bɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mãga pɨk'a Rey Daviddeepa uchiadap'edaarã mɨde ijãa p'anɨ mɨa araa p'eit'ee apemaarã mɨde ijãa p'anɨɨrã ome. Maap'eda ma jõmaweda mɨchideerã papiit'ee mɨ Warra k'aurepa. Mãga ooit'ee chi mɨde ijãa p'anɨɨrã, Daviddeepa uchiada-e paji mĩda. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chonaarãweda mɨa k'awapidak'a eperãarãmaa, mãga ooit'ee. Mɨ, Tachi Ak'õre Waibɨapa mãga jara bɨ.’ ");
INSERT INTO sjaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mãpai Santiagopa mãgaji: —Tachi Ak'õrepa mãga jara bairã, mɨa nãga k'ĩsia bɨda aji. Tachia Moisepa p'ãdade jara bɨk'a oopidaik'araa bɨ judio-eerãmaa, mãgɨɨrã Tachi Ak'õrede ijãadak'ãri. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma k'ãyaara k'art'a p'ã pëidáma jaradait'ee k'onaadamerã nechiara ata bɨdap'edaa ne-inaa juapa ooda k'ĩrapite, aɨ k'ĩrapite ɨt'aa t'ɨ̃pata; wẽra apai ome p'anadamerã; ne-animal ɨ̃yapa jɨ̃a piuda chiara k'onaadamerã, aɨde waa paraa perã mãik'aapa ne-animal waa k'onaadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mãgɨ́ ũraa aupai pëidaipia bɨ. Awaraa ũraa k'awa k'inia p'anɨ pɨrã, ɨ̃ipata ewari chaa ũridai Tachi Ak'õre Ũraa jarateepata tede. Chonaarãweda Moisepa p'ãda jarateepachidada aji, mãgee tede mãik'aapa ɨ̃rá at'ãri mãga oopata. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mãpai Cristopa jɨrɨt'eradaarã, ijãapataarã ak'ɨpataarã mãik'aapa jõmaweda Jerusalendepema ijãapataarãpa pedeeteejida ũk'uru jɨrɨt'eradait'ee mãik'aapa pëidait'ee Antioquiadee Pablo ome mãik'aapa Bernabé ome. Nãgɨ́ eperãarã jɨrɨt'erajida: Judas, ichiaba t'ɨ̃patap'edaa Barsabás mãik'aapa Silas. Apemaarã ijãapataarãpa mãgɨ́ omé pia ak'ɨ p'anapachida ãchi poroorãk'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","K'art'a p'ãdap'edaade nãga jara pëijida: Tai, Cristopa jɨrɨt'eradaarãpa, ijãapataarã ak'ɨpataarã ome na k'art'ade salude pëiruta parã judio-eerãmaa Cristode ijãa p'anɨɨrã Antioquía p'uurudepema, Siria eujãdepema mãik'aapa Cilicia eujãdepemaarã-it'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Taipa ũrijida nãpemaarã ũk'uru parãmaa wãdap'edaa, mamĩda taipa pëida-eeta. Mãgɨɨrãpa pariatua ãchi k'ĩradoopa jaratee nipajida. Maperã parãpa k'awada-e paji ijãadait'ee Moisepa p'ãdade wa Pablopa jarateedade. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mapa taipa pedeeteejida taidepemaarã ũk'uru jɨrɨt'eradait'ee mãik'aapa pëidait'ee parãmaa tai k'õp'ãyoorã k'iniarã Bernabé Pablo ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Taipa k'awa p'anɨ Pablo Bernabé ome waaweedak'aa piudait'ee Tachi Waibɨa Jesucristode ijãa p'anɨ k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mapa ãchi ome parãmaa pëiruta Judas Silas ome. Ãchia parãmaa jõma taipa k'ĩsiadap'edaa na p'ãdade jara bɨk'a nepɨrɨdait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tachi Ak'õre Jaurepa tai k'aripaji parãmaa ne-inaa audú chaaree oopinaadamerã. Nãgapai jara k'inia p'anɨ parãpa oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","K'onáatɨ nechiara ata bɨdap'edaa ne-inaa juapa ooda k'ĩrapite, aɨ k'ĩrapite ɨt'aa t'ɨ̃pata. Ne-animal ɨ̃yapa jɨ̃a piuda chiara k'onáatɨ mãik'aapa ne-animal waa k'onáatɨ. Ma awara p'ek'au oonáatɨ. Taipa jara p'anɨk'a ooruta pɨrã, pia oodait'ee. Mãgapai paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mãpai ma k'art'a p'ãdap'eda, pëijida Antioquiadee wãdap'edaarã ome. Mama panadap'eda, ijãapataarã jõmaweda t'ɨ̃ p'ejida mãik'aapa ma k'art'a ãchimaa teejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ijãapataarãpa ma k'art'a leedak'ãri, o-ĩadachida, ãchi-it'ee ũraa pia bada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silas ome Tachi Ak'õre Jaurepa jarapiru jarapataarã pada perã, ichiaba ma ijãapataarãmaa ũraajida t'ãri o-ĩa p'aneedamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mama p'anadap'eda, ijãapataarãpa ãchi despediijida k'ãiwee wãdamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mamĩda Silas arii beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo Bernabé ome ichiaba p'aneejida awaraa ijãapataarã ome Antioquiade, Tachi Ak'õrepa pedee pia jara pëida Cristode jarateedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mãga p'anadap'eda, ewari aba Pablopa mãgaji Bernabemaa: —Waya wãdáma aji, ijãapataarã ak'ɨde, Tachi Ak'õrepa jara pëida Cristode jaratee nipadap'edaa p'uuru chaa. Ak'ɨdait'eeda aji, at'ãri ijãa p'anɨ wa mãga-e. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabepa ichiaba atee k'inia baji Juan; mãgɨ́ Juan ichiaba t'ɨ̃jarapatap'edaa Marcos. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mamĩda Pablopa atee k'inia-e paji, ãchi ik'aawaapa uchiada perã Panfilia eujãde, ãchi mimia at'ãri aupada-eeta. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ijɨ̃atɨ pedeedap'eda, ãchi o chaachaa jitak'oodachida. Bernabé wãji Chipre isladee Marcos ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Jõdee Pablopa jɨrɨt'eraji Silas ichi k'õp'ãyo pamerã. Ijãapataarãpa ãchi omé Ak'õre juade bɨjida irua ãchi pia ak'ɨ bapariimerã. Mãpai Pablo ichi k'õp'ãyo ome wãji. ");
INSERT INTO sjaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wãyaajida Siria eujãde mãik'aapa Cilicia eujãde. Ijãapataarã ũraa wãjida ãchi para bee chaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mamãik'aapa Pablo Silas ome panajida Derbe p'uurude mãik'aapa Listra p'uurude. Mama unujida ijãapari t'ɨ̃jarapatap'edaa Timoteo. Chi nawe judío wẽra Cristode ijãapari paji. Jõdee chi ak'õre Greciadepema paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ijãapataarã Listradepemaarã mãik'aapa Iconiodepemaarãpa Timoteo pia t'o p'anadap'edaa perã, ");
INSERT INTO sjaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablopa ichi ome ateeji mamãik'aapa. Mamĩda uchiadai naaweda, iru k'ap'ɨade tauchaa bɨji mãpemaarã judiorã k'aurepa. Ma eujãdepema jõmaarãpa k'awajida Timoteo ak'õre Greciadepema paji mãik'aapa ãrapa tauchaa bɨdak'aa paji ãchi warrarã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","P'uuru bee chaa wãyaa wãdak'ãri, jara bëi wãpachida Cristopa jɨrɨt'eradaarãpa mãik'aapa ijãapataarã ak'ɨpataarãpa jara pëidap'edaa Jerusalendeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mãgá ijãapataarãpa pipɨara k'awaajida Cristopa oopi k'inia bɨ ãchimaa mãik'aapa waapɨara ijãajida irude. Ma awara ewari chaa ijãapataarã chok'araara ĩwa wãjida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ma wãrutade wãyaajida Frigia eujãde mãik'aapa Galacia eujãde, Tachi Ak'õre Jaurepa jarateepi-e pada perã Ásia eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia eujãde panadak'ãri, wãdait'ee paji Bitinia eujãdee. Mamĩda Jesús Jaurepa wãpi-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mapa Misia eujãde wãyaajida Troas p'uurude parutamaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Panadap'edaa ewate p'ãrik'ua, Pablo k'ãimok'araa pɨk'a bɨde unuji Macedonia eujãdepema ɨmɨk'ĩra bainɨ̃ bɨ. Mãgɨpa chupɨria iidiji Pablo wãmerã ichi eujãdee. Mãgaji: —Chéji Macedoniadee tai k'aripade. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo mãgá k'ãimok'araa pɨk'a bap'eda, aramata net'aa p'e atajida wãdait'ee Macedoniadee, k'ĩsia p'anadap'edaa perã Tachi Ak'õrepa jarateepi k'inia bɨ Cristopa ooda eperãarã k'aripait'ee ma eujãde. Ma wãdap'edaade mɨ jida auk'a wãji. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas p'uurudeepa tai barcode bataujida. Mata Samotracia islade panajida. Mamãik'aapa aɨ norema Neápolis p'uurude panajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Neapolideepa wãjida Filipodee. Mãgɨ́ p'uuru waibɨa Macedonia eujãde bɨ. Ma p'uurude Romadepemaarã chok'ara p'anapachida. Mama k'ãima chok'ara-ee p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ɨ̃ipata ewate tai wãjida p'uurudeepa to idee, ma p'uurudepema judiorã ɨt'aa t'ɨ̃patamãi unudai jĩak'aapa. Unu atadak'ãri, su-ak'ɨ p'aneejida mãik'aapa jarateemaa p'aneejida wẽraarã cheepurudap'edaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ma wẽraarã t'ãide baji aba t'ɨ̃jarapatap'edaa Lidia. Ma wẽra Tiatira p'uurudepema paji. Mãgɨpa netopachi p'aru pia t'ɨda p'up'uchia. Mãgɨ́ wẽrapa Tachi Ak'õremaa ɨt'aa t'ɨ̃pachi. Maperã Ak'õrepa irumaa ũripiji Pablopa jaratee bɨ. Pia ũrik'ãri, Cristode ijãa beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iru poro choopip'eda ichi te pidaarã ome, taimaa mãgaji: —Parãpa unu p'anɨ pɨrã mɨ wãara ijãa bɨ Jesucristode, mɨ tede p'ana chétɨ. Mãga jara bɨpa wãjida ichi temaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ewari aba tai waya ɨt'aa t'ɨ̃de wãdak'ãri ɨt'aa t'ɨ̃patap'edaamaa, unujida awẽra. Mãgɨ́ awẽra esclava paji. Mãgɨpa ne-inaa p'asait'ee bɨ jarapachi, ichi k'ap'ɨade netuara merãtɨa bada perã. Mapa ma awẽra chiparipa p'arat'ara jitapachi ichi k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mãgɨ́ awẽra tai t'ẽe bia wãpachi: —Nãgɨ́ eperãarã Tachi Ak'õre Waibɨapa pëida jarateedamerã sãga eperãarã ɨt'aa wãdai. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ewari chok'ara mãga oopachi tai wãrutamaa. Mata ewari aba Pablopa ũriamaadaik'ãri, ãpɨtee ak'ɨji mãik'aapa mãgaji ma netuara k'ap'ɨade merãtɨa badamaa: —Jesucristo jõmaarã poro waibɨa perã, ichi t'ɨ̃de mɨa pɨmaa jara bɨ uchiadaimerã jã wẽra k'ap'ɨadeepa. Aramata ma netuara uchiadachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ma awẽra chipariirãpa mãga unudak'ãri, k'awaajida ãchi p'arat'a waa p'oyaa jitada-e iru k'ap'ɨa. Mapa Pablo Silas ome jita atadap'eda, ateejida ãchi p'uurudepema poroorãmaa, mãgɨɨrã chip'edaipatap'edaamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ma Romadepema poroorãmaa ateedap'eda, mãgajida: —Na judiorãpa tachi p'uuru pidaarã k'ĩraupirutada ajida, ");
INSERT INTO sjaNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","mãik'aapa ne-inaa jarateemaa p'anɨ tachi Romadepemaarãpa oopata awara. Taipa mãga ũri k'iniada-e p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mãpai p'uuru pidaarã chok'ara seedachida. Ãchi poroorãpa Pablo Silas ome p'aru ẽrapijida mãik'aapa wɨpijida pak'urupa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pia wɨpit'aadap'eda, carcelde t'ɨt'aajida mãik'aapa carceldepema jɨ̃aparimaa jarajida pia jɨ̃amerã, carceldeepa uchiapiamaapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chi jɨ̃aparipa mãga ũrik'ãri, calabozo edupɨara badade t'ɨ nɨ̃bɨji mãik'aapa ãchi bɨɨrɨ t'ɨk'ooji cepode. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mãgá iru p'anajida mĩda, Pablo Silas ome ɨt'aa t'ɨ̃maa mãik'aapa k'arimaa p'anajida Tachi Ak'õremaa. Jõdee chi apemaarã carcel pidaarãpa ũrii p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Esapɨte pak'ãri, awẽrachai golpe wëre nɨ̃beeji. Ma carcel perá t'eedachi. Aramata chi puerta jõmaweda ewak'oodachida. Presoorã juade nɨ̃bada cadena mãik'aapa cepo ichiaba jõma ẽt'ak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ma carceldepema jɨ̃aparipa unuk'ãri chi puerta jõma ewa jẽra bɨ, ichi espada ẽt'a ataji ichi juadoopa piudariit'ee, carcel pidaarã jõma uchiadai p'anɨ jĩak'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mamĩda Pablopa biaji ichi badamãiipa mãgɨ́ jɨ̃aparimaa: —¡Jãgá oonáaji! ¡Tai jõma nama p'anɨpɨ! ");
INSERT INTO sjaNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mãpai carceldepema jɨ̃aparipa lámpara aneepip'eda, t'ĩudachi Pablo mãik'aapa Silas p'anadap'edaamãi. Ãchi k'ĩrapite wɨrrɨwɨrrɨa bedabai nɨ̃banaji p'era nɨ̃bɨpa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Uchia p'e atap'eda calabozo edupɨara bɨdeepa, mãgaji: —Jarateepataarã, ¿k'ãata ooipia bɨma aji, mɨ ɨt'aa wãit'ee? ");
INSERT INTO sjaNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mãpai p'anaujida: —Jesucristode ijã́aji. Mãgara pɨ, pɨchi tedepemaarã ome ɨt'aa wãdayada ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mãpai Tachi Ak'õrepa jara pëida Cristode jarateejida ma jɨ̃aparimaa mãik'aapa ichi tede p'anadap'edaarãmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Aramata ma carceldepema jɨ̃aparipa Pablo Silas ome ateeji sɨɨk'ooit'ee ãchi k'ap'ɨade t'udak'a jẽra bada. Maap'eda iru ichi tedepemaarã ome poro choopijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mãpai teedaa p'e ateep'eda, nek'opiji. Ma carcel jɨ̃apari ichi tedepemaarã ome o-ĩa p'anajida Tachi Ak'õrede ijãadap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Aɨ norema tap'eda Romadepema poroorãpa ãchi jɨ̃apataarã pëijida ma carceldepema jɨ̃aparimaa, Pablo Silas ome uchia pëimerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Maperã carceldepema jɨ̃aparipa mãgaji Pablomaa: —Mɨ poroorãpa jara pëi p'anɨda aji, parã uchia pëimerã. Mapa k'ãiwee wã́tɨ namãik'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mamĩda Pablopa mãgaji Romadepema poroorãpa pëidap'edaarãmaa: —Tai auk'a Romadepemaarã p'anɨta, wɨjidada aji, jõmaarã k'ĩrapite, charramaa ateeda-ee. Maap'eda carcelde t'ɨpijida. Ɨ̃rá jõdee, ¿merã uchiapi k'inia p'anɨ-ek'ã? ¡Mãga-epɨ! Namãik'aapa wãda-eda aji, ãchia uchia pëi cheda-emãi ãchi k'ĩradoopa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pablopa jarada ãchi poroorãmaa jaranadak'ãri mãik'aapa jã eperãarã auk'a Romadepemaarãda adak'ãri, mãɨrã poroorã p'eradachida, ãchia wɨpidap'edaa perã mãik'aapa carcelde t'ɨ nɨ̃bɨdap'edaa perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mapa chedap'eda, chupɨria iidijida Pablomaa Silas ome perdonaadamerã ãchia oodap'edaa. Mãpai uchiapijida carceldeepa mãik'aapa p'uurudeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo Silas ome ma carceldeepa uchiadap'eda, wãjida Lidia temaa. Mama ijãapataarã jõmaarãmaa ũraajida t'ãri o-ĩa p'aneedamerã. Maap'eda wãjida ma p'uurudeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mamãik'aapa ãchi wãdade Pablo Silas ome wãyaajida Anfípolis p'uurude mãik'aapa Apolonia p'uurude. Maap'eda Tesalónica p'uurude panajida. Mãgɨ́ p'uurude baji Tachi Ak'õre Ũraa jarateepata te. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Maperã Pablo ichia oopatak'a p'uurude panak'ãri, jãmaa wãji. Mama beeji tomia õpee mãik'aapa ɨ̃ipata ewari chaa aupedeeji arii p'anadap'edaarã ome. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ak'õre Ũraa p'ãdade ak'ɨpipachi sãga Cristo chupɨria nɨ̃bait'ee mãik'aapa piup'eda, p'irabaiit'ee. Jarapachi: —Nãgɨ́ Jesús parãmaa mɨa jaratee bɨ Cristota, Tachi Ak'õrepa pëida eperãarã k'aripamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mãga ũridak'ãri, judiorã ũk'uru Cristode ijãajida mãik'aapa araa nipapachida Pablo mãik'aapa Silas ome. Ichiaba ijãajida judio-eerã; Tachi Ak'õrede ijãa p'anadap'edaarã chok'ara mãik'aapa wẽraarã p'arat'ara beerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Judiorã Cristode ijãada-ee p'anadap'edaarãpa mãga unudak'ãri, k'ĩraudachida. Mapa jɨrɨjida eperãarã mimiadak'aa p'anadap'edaarã, p'uuru pidaarã k'ĩraupit'aadamerã Pablo mãik'aapa Silas ome, pedee jõnɨpa ãra ãpɨte. Mãgá p'uuru pidaarã jõma k'ĩraupit'aadap'eda, Jasón tede t'ĩudachida, Pablo Silas ome uchia atadap'eda, p'uuru pidaarãmaa teedait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mamĩda mãgɨ́ tede ãra unuda-e pak'ãri, uchia atajida Jasonta mãik'aapa awaraa ijãapataarã. Maap'eda ãchi p'uurudepema poroorãmaa ateejida. Mama panadak'ãri, biapachida: —¡Ɨ̃rá eperãarã Roma jua ek'ari p'anɨɨrã k'ĩsia awarapipataarã nama che p'anɨda! ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma awara mãgɨɨrã Jasonpa ichi tede auteebaiji. Mãɨrãpa oodak'aa Cesarpa oopi bɨk'a. Jĩp'a jara p'anɨ ichi k'ãyaara rey aba waibɨara bɨda ajida, t'ɨ̃jarapata Jesús. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mãga ũridak'ãri, ma p'uuru pidaarã mãik'aapa ãchi poroorã k'ĩraupik'a para beeji. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mamĩda Jasonpa apemaarã ijãapataarã ome p'aajida ãchi uchia pëidamerã. Mãpai k'ena pëijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ma p'ãrik'ua weda ijãapataarãpa Pablo Silas ome Berea p'uurudee pëijida. Mama panadak'ãri, t'ĩujida judiorã Ak'õre Ũraa jarateepata temãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mãpema judiorã Tesalonicadepema k'ãyaara k'ĩsia k'awaara p'anajida. Mapa Pablopa jaratee bɨ ũri k'inia p'anajida. Mãga ũridap'eda, ewari chaa Tachi Ak'õre Ũraa p'ãda ak'ɨpachida k'awaadait'ee wãara jara bɨ Pablopa jara bɨk'a maa-e pɨrã awara jara bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","K'awaadak'ãri wãarata jara bɨ, mãgɨdepemaarã judiorã chok'ara ijãajida. Ichiaba judio-eerã wẽraarã p'arat'ara beerã chok'ara ijãajida, ɨmɨk'ĩraarã jida ichiaba. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mamĩda Tesalonicadepema judiorãpa ũridak'ãri Pablopa Tachi Ak'õrepa jara pëida jarateemaa bɨ Bereade, wãjida ma p'uuru pidaarã k'ĩraupit'aade. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aramata mãpema ijãapataarãpa Pablo pëijida k'õp'ãyoorã ũk'uru ome p'usa idee. Jõdee Silas Timoteo ome Bereade p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Chi Pablo ome wãdap'edaarãpa iru ateejida Atenas p'uurudee. Waya ãpɨtee uchiadait'ee pak'ãri, Pablopa jara pëiji Silamaa Timoteo ome taarã-ee chedamerã ichimaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas p'uurude Pablopa Silas mãik'aapa Timoteo nɨmaa beeji. Mama bɨde unuk'ãri chok'ara ne-inaa iru p'anɨ eperã juapa ooda aɨ k'ĩrapite ɨt'aa t'ɨ̃pata, t'ãri ãriidachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mapa aupedeepachi judiorã ome mãik'aapa judio-eerã Tachi Ak'õre waaweepataarã ome Ak'õre Ũraa jarateepata temãi. Ichiaba mãga oopachi ewari chaa chi unuru ome ma p'uurude net'aa netopatamãi. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mama ũk'uru poro wẽsaa beerã t'ɨ̃jarapatap'edaa Epicúreo eerepemaarã mãik'aapa Estoico eerepemaarã aupedee p'aneejida Pablo ome. Mãɨrã ũk'uruurãpa mãgapachida: —¿K'ãata jara k'inia bɨma apachida, na pedee-idaa bɨpa? Awaraarãpa mãgapachida: —Awaraa eujãdepemaarã ak'õre waibɨapa ooda jaratee bɨda apachida. Mãga jarapachida Pablopa jarateemaa bada perã Tachi Ak'õrepa ooda Jesús piuda k'aurepa mãik'aapa jarateepachi perã tachi piuda t'ẽepai waya chok'ai p'irabaidait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mãpai ãchia Pablo ateejida Areopagomaa, ãchi poro wẽsaa beerã cheepurupatamaa ũraa ũride. Mama iidijida: —¿Taipa pɨa jaratee bɨ k'awaadaik'ã? ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Taipa waide ũrida-e p'anɨda ajida, pedee pɨa jaratee bɨk'a. Mapa k'awa k'inia p'anɨda ajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ma Atenas pidaarã mãik'aapa awaraarã arii p'anadap'edaarã mimiada-e p'anadak'ãri, p'anapachida ne-inaa chiwidi pedeemaa mãik'aapa ũrimaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mãpai Pablo bainɨ̃ beeji ãchi k'ĩrapite Areopagode mãik'aapa mãgaji: —Atenas p'uuru pidaarã, mɨa unu bɨ parãpa ak'õre waibɨa k'ĩra t'ãdoo waaweepata. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mɨ wãyaak'ãri parã ɨt'aa t'ɨ̃patamãi, unuji net'aa chok'ara iru p'anɨ aɨ k'ĩrapite ɨt'aa t'ɨ̃pata. Mama bɨde unuji parã altar bide p'ã bɨ: Tachi Ak'õre Waibɨa k'awada-e p'anɨ-it'ee. Parãpa k'awada-eda a p'anɨ Ak'õrepa ooda mɨa jaratee bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Nãgɨ́ Ak'õrépata ooji na eujã mãik'aapa jõma aɨde nɨ̃bɨ. Nãgɨta, Tachi Ak'õre, jõmaarã Waibɨa na p'ek'au eujãde mãik'aapa pajãde. Nãgɨ́ Ak'õre eperãarãpa te oodade bak'aa, ");
INSERT INTO sjaNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ichi-it'ee p'ua-e bairã ne-inaa eperãarãpa oopata ichi-it'ee. Ichiata eperãarã chok'ai p'anapipari, ĩyapaapipari mãik'aapa tachimaa ne-inaa jõmaata teepari pia p'anapataadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Eperã abaadeepa eperãarã k'ĩra t'ãdoo uchiapiji, na p'ek'au eujã jõmaade p'anapataadamerã. Aɨ naaweda k'ĩsia iru baji sãapai uchiapiit'ee mãik'aapa sãmaata p'anapiit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tachi Ak'õrepa mãga ooji eperãarãpa iru jɨrɨdamerã. Tachi taupa nãgɨ́ Ak'õre unuda-e p'anɨ mĩda, iru k'awadai, wãara tachimãiipa t'ɨmɨa-ee bairã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Iru k'aurepa tachi chok'ai p'anɨ; p'ɨrrɨapata mãik'aapa na eujãde p'anapata. Pãchi k'arik'a p'ãpataarãpa jaradap'edaak'a mãga bɨ: “Tachi, Tachi Ak'õre Waibɨapa ooda”. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Maperã k'ĩsiadaik'araa bɨ Tachi Ak'õre santok'a bɨ, eperãarãpa k'ĩsiadap'eda oopatak'a nẽedee, p'arat'adee maa-e pɨrã mãudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Naaweda Tachi Ak'õrepa miapi-e paji mãgee k'ĩrapite ɨt'aa t'ɨ̃patap'edaarã, iru waide k'awada-e p'anadap'edaa perã. Mamĩda ɨ̃rá jõmaarãmaa jara bɨ p'ek'au k'achia oo amaadamerã mãik'aapa ichide ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ichia mãga jara bɨ na ewari na p'ek'au eujãdepemaarãpa oopata jõmaweda ak'ɨit'ee perã, k'awaait'ee pia wa k'achia. Mãga ooit'ee ichia pëida Jesucristopa. Cristopa eperãarãpa oopata mãgá ak'ɨi, ichia k'achia ook'aa pada perã na eujãde nipak'ãri. Tachia k'awa p'anɨda aji, Ak'õrepa iru jɨrɨt'eraji, iru piup'eda, chok'ai p'irabaipida perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Arii p'anadap'edaarãpa ũridak'ãri eperã piup'eda chok'ai p'irabaida, ũk'uru ëi para beeji mãik'aapa ũk'uruurãpa mãgajida: —Na ewari waya ũridayada ajida, pɨ pedee. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mãpai Pablo uchiaji mamãik'aapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mamĩda ũk'uruurãpa ijãajida Pablopa jarada mãik'aapa Cristode ijãa p'aneejida. Ma ijãadap'edaarã t'ãide baji ɨmɨk'ĩra t'ɨ̃jarapatap'edaa Dionisio. Mãgɨ́ Areópago poro wẽsaa beerã cheepurupatadepema paji. Ichiaba baji wẽra t'ɨ̃jarapatap'edaa Dámaris mãik'aapa awaraarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ma t'ẽepai Pablo wãji Atenas p'uurudeepa Corinto p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mama ununaji judío t'ɨ̃jarapatap'edaa Áquila. Mãgɨ́ Ponto eujãdepema paji. Ewaa pache baji chi wẽra Priscila ome Italia eujãdeepa, César Claudiopa judiorã jõmaweda jërek'ooda perã Roma p'uurudeepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pablo p'asiade wãk'ãri ma judío badamaa, k'awaa ataji ichi jĩak'a Aquilapa carpa oopari. Mapa Pablo ãra ome beeji ma mimia oomaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mama bɨde ɨ̃ipata ewari chaa wãpachi Ak'õre Ũraa jarateepata temaa jarateede judiorãmaa mãik'aapa judio-eerãmaa Cristode ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas Timoteo ome pachedak'ãri Macedoniadeepa, Pablopa ewari chaa Tachi Ak'õrepa jara pëida Cristode jarateemaa bapachi, judiorãpa ijãadamerã Jesuta Cristo, Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mamĩda judiorã, ichi pedee ijãa k'iniada-ee p'anadap'edaarãpa ik'achia jaramaa p'aneejida. Mapa Pablopa ichi p'aru jɨ̃ bada jĩap'eji ak'ɨpiit'ee ãchimaa waa jaratee-e. Maap'eda mãgaji: —Pãchi k'ĩradoopa atuadait'eeda aji, piudak'ãri. Idideepa mɨ wãit'eeda aji, judio-eerãmaa Tachi Ak'õrepa jarapi bɨ jarateede. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mãga jarap'eda, Pablo wãji Ticio Justo apatap'edaa temaa jarateede. Mãgɨ́ eperãpa Tachi Ak'õremaa ɨt'aa t'ɨ̃pachi. Ichi te baji Tachi Ak'õre Ũraa jarateepata te ik'aawa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pablopa mama jarateemaa bɨde, Cristode ijãaji ma Ak'õre Ũraa jarateepata tedepema poro, t'ɨ̃jarapatap'edaa Crispo. Chi te pidaarã jida auk'a ijãajida mãik'aapa apemaarã Corinto pidaarã chok'ara Pablopa jarateeda ũridap'edaarã ichiaba ijãajida. Mapa mãɨrã jõma poro choopijida. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","At'ãri Corinto p'uurude p'anɨde ewari aba p'ãrik'ua k'ãimok'araa pɨk'a bɨde Tachi Ak'õrepa mãgaji Pablomaa: —Waawee-ee jaratéeji na p'uurude ");
INSERT INTO sjaNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","mɨchideerã nama chok'ara nɨ̃bairã. Mɨ pɨ ome bairã, apidaapa pɨ k'achia ooda-e. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tachi Ak'õrepa mãga jarada perã, Pablo mama beeji año aba ap'eda esa-auk'a, Tachi Ak'õrepa jara pëida Cristode jarateemaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mamĩda, mama bɨde, Romadepema Galión apatap'edaa Acaya eujãdepema poro waibɨa bak'ãri, judiorã chok'ara pedeeteejida mãik'aapa Pablo jita ateejida iru k'ĩrapite. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mama mãgajida: —Na eperãpa jaratee bɨ Tachi Ak'õrede ijãadamerã mãik'aapa irumaa ɨt'aa t'ɨ̃pataadamerã. Mamĩda jaratee-eda ajida, Moisepa p'ãdade jara bɨk'a oodamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mãpai Pablo pedeeit'ee arude, Galionpa mãgaji ma judiorãmaa: —Na eperãpa ne-inaa k'achia oo bada paara maa-e pɨrã chĩara pee bada paara, mɨa ak'ɨk'ajida aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mamĩda jara p'anadairã chĩara t'ɨ̃ mãik'aapa parãpa ũraa p'ãdade, pãchi pitapai ma nepɨra ak'ɨdapáde aji. Mɨa parã nepɨra ak'ɨ k'inia-eda aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aramata jërek'ooji ichimãiipa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mãpai arii ak'ɨ p'anadap'edaarãpa Tachi Ak'õre Ũraa jarateepata tedepema poro Sóstenes jita atadap'eda, wɨjida Galión k'ĩrapite. Mamĩda iru-it'ee maarepida p'ua-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Aɨ t'ẽepai Pablo taarã beeji Corinto p'uurude. Mãpai ijãapataarãmaa despediip'eda, Siria eujãdee wãji Priscila mãik'aapa Áquila ome. Cencrea p'uurude barcode batau naaweda, Pablopa ichi poro bi-si wẽt'aaji. Mãga ooji ak'ɨpiit'ee ichia Tachi Ak'õremaa ooit'eeda ada ooda. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ma wãrutade Éfeso p'uurude panadak'ãri, Pablo t'ĩunaji Tachi Ak'õre Ũraa jarateepata tede judiorã ome pedeeit'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ichia jarateeda ũridak'ãri, chupɨria iidijida ãchi ome taarã beemerã. Mamĩda Pablopa k'inia-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mãgaji: —Ɨ̃rá wãit'eeda aji. Mamĩda waya cheit'eeda aji, Tachi Ak'õrepa k'inia bɨ pɨrã. Mãpai Pablo batauji mãik'aapa wãji. Jõdee Priscila Áquila ome mama p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pablo Cesarea p'uurude panak'ãri, mamãik'aapa wãji Jerusalendee ijãapataarã ak'ɨde. Maap'eda wãji Antioquía p'uurudee. Mãgɨ́ p'uuru Siria eujãde bɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antioquiade bap'eda, wãji ijãapataarã para bee chaa ãchi ak'ɨde mãik'aapa ũraade. Mãga oo wãji Galacia eujãde mãik'aapa Frigia eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Maapai judío t'ɨ̃jarapatap'edaa Apolo pacheji. Mãgɨ́ Alejandría p'uurudepema paji. Mãgɨ́ p'uuru Egipto eujãde bɨ. Mãgɨ́ judiopa Tachi Ak'õre Ũraa p'ãda pia k'awa baji. Ma awara pia jarateepachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mãgɨpa o-ĩ-ĩa jarateepachi Juan Bautistapa jarateedak'a, eperãarãpa ãchia p'ek'au k'achia oopata oo amaadamerã mãik'aapa poro choopidamerã ak'ɨpidait'ee Tachi Ak'õrede ijãa p'anɨ. Ichiaba jarateepachi Jesucristo Tachi Ak'õrepa pëida. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo Éfeso p'uurude pachek'ãri, waawee-ee jarateemaa beeji judiorã Ak'õre Ũraa jarateepata temãi. Mãga ũridak'ãri, Priscila Áquila ome ãchi temaa ateejida. Mãpai Apolomaa jarateejida jõma ãchia k'awadap'edaa, Tachi Ak'õrepa ooda Jesucristo k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Maap'eda, Apolo Acaya eujãdee wã k'inia bak'ãri, Efesodepema ijãapataarãpa k'art'a p'ãjida jãpemaarãmaa iru auteebaidamerã. Mãgá mama panak'ãri, irua k'aripai Cristode ijãapataarã waapɨara ijãadamerã. Tachi Ak'õre t'ãri pia bapari perã, ãchimaa Cristode ijãapiji, Apolo mamaa wãi naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolo mama bɨde jõmaarã taide Tachi Ak'õre Ũraa p'ãda ak'ɨpachi mãik'aapa jarateepachi Jesucristo Tachi Ak'õrepa pëida eperãarã k'aripamerã. Mapa judiorãpa maarepida p'oyaa p'anauda-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo Corinto p'uurude bɨ misa, Pablo wãyaaji Galacia mãik'aapa Frigia eujãde Éfeso p'uurude parumaa. Mama Cristode ijãapataarã ununaji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mãpai Pablopa iidiji: —Parãpa Cristode ijãadak'ãri, ¿Tachi Ak'õre Jaure parã k'ap'ɨade ba chejik'ã? aji. P'anaujida: —Taipa k'awada-eda ajida, Tachi Ak'õre Jaure ba chepari ijãapataarã k'ap'ɨade. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mãpai Pablopa iidiji: —Parãpa poro choopidak'ãri, ¿k'ãare-it'ee poro choopijidama? aji. P'anaujida: —Juanpa jaradak'a poro choopijida ak'ɨpidait'ee p'ek'au k'achia oo amaa k'inia p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mãpai Pablopa mãgaji: —Juanpa wãara poro choojida aji, waa p'ek'au k'achia oo k'iniada-e p'anadap'edaarã. Mamĩda Juanpa ichiaba jarapachi ijãadamerã ichi t'ẽe cheru eperãde. Mãgɨ́ eperã Jesucristo. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ma eperãarãpa mãga ũridak'ãri, aramata ãchi poro choopijida Tachi Waibɨa Jesús t'ɨ̃de ak'ɨpidait'ee irude ijãa p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Maap'eda Pablopa jua bɨji ma poro choodap'edaarã ɨ̃rɨ. Mãgá bɨk'ãri, Tachi Ak'õrepa ichi Jaure ãra k'ap'ɨade ba chepiji. Mãgɨpa ãramaa pedeepipachi k'awada-e p'anɨ pedeede. Mãgá jarajida Tachi Ak'õrepa jarapidak'a. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Chi mãgá poro choodap'edaa eperãarã doce paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Maap'eda Pablo wãji Tachi Ak'õre Ũraa jarateepata tedee. Mama ɨ̃ipata ewari chaa atane õpee Tachi Ak'õre Ũraa waawee-ee jarateeji. Jaraji Tachi Ak'õrepa pia ooda Jesucristo pëik'ãri, judiorãpa irude ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mamĩda ũk'uruurãpa ijãa k'iniada-e paji Pablopa jaratee bada mãik'aapa waapɨara pedee k'achia jarajida Tachi Ak'õre Ode P'anɨɨrã ãpɨte. Maperã Pablo mamãik'aapa ãyaa wãji ijãapataarã ome. Jaratee banaji eperã t'ɨ̃jarapatap'edaa Tirano escuelade. Mama ewari chaa jarateepachi. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Irua Tachi Ak'õre Ũraa jarateeji año omé. Mãgá judiorã mãik'aapa judio-eerã Ásia eujãde p'anapatap'edaarãpa ũrijida Tachi Ak'õrepa jara pëida Jesude. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ichiaba Tachi Ak'õrepa Pablomaa oopipachi ne-inaa eperãarãpa p'oyaa oodak'aa ãchi juadoopa. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pablo k'ap'ɨade p'aru t'õbaidapapai, k'ayaa beerã jɨpapachida. Ichiaba netuara eperãarã k'ap'ɨade merãtɨa bee uchiapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Mãpema judiorã ũk'uru Cristode ijãada-e p'anadap'edaarãpa netuara merãtɨa bee eperãarã k'ap'ɨadeepa uchiapik'oopachida. Mãga oo nipajida judiorã p'aareerã poro Esceva warrarã. Ãra siete paji. Mãɨrãpa k'awaadak'ãri netuaraarã uchia p'anɨ Pablo k'aurepa ichia Tachi Waibɨa Jesús t'ɨ̃ jarak'ãri, auk'a oo k'inia p'aneejida. Mapa jarajida netuara merãtɨa bɨmaa: —¡Pablopa jara bɨ Jesús t'ɨ̃de uchíatɨ! ");
INSERT INTO sjaNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mamĩda mãga oodak'ãri, ma netuara eperã k'ap'ɨade merãtɨa badapa mãgaji: —Mɨa k'awa bɨda aji, Jesús. Ichiaba k'awa bɨ k'aita Pablo. Mamĩda parã ¿k'airã́ma? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mãpai ma netuara k'ap'ɨade merãtɨa bada eperãpa ãchi ɨ̃rɨ cheji mãik'aapa ãchi jõmaweda sĩk'ooji. Mãgá p'u oop'eda, chi netuara uchiapi chedap'edaarã mamãik'aapa ãk'adaa p'ira uchiak'oodachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Éfeso p'uurude p'anapataarã, judiorã mãik'aapa judio-eerãpa mãga ũridak'ãri, jõmaarãta p'erajida mãik'aapa Tachi Waibɨa Jesús t'ɨ̃ pia t'o p'anajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mãpemaarã ũk'uru Cristode ijãa p'aneejida. Maap'eda Pablomaa jara chepachida ãchia k'achia oopatap'edaa, aɨ naaweda ijãa p'anadap'edaa perã petau tau k'awaa beerãpa oo p'anadap'edaade. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ichiaba ũk'uru petau tau k'awaa beerãpa aneepachida ãchi libro jõmaarã taide paak'oodait'ee. Mãgɨ́ libro valor p'arat'ade juasiadak'ãri, uchiaji p'arat'a tau cincuenta mil. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ma jõma oo p'anadap'edaa k'aurepa ma eujãdepemaarãpa waapɨara ijãapachida Tachi Ak'õrepa jarapidade. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ma t'ẽepai, Tachi Ak'õre Jaurepa Pablomaa k'ĩsiapiji wãit'ee Jerusalendee, wãyaap'eda Macedonia eujãde mãik'aapa Acaya eujãde. Ichiaba Jerusalendeepa Pablo wã k'inia baji Romadee. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mãga k'ĩsiap'eda, Pablopa chi k'õp'ãyoorã Timoteo Erasto ome naa pëiji Macedonia eujãdee. Jõdee ichi Ásia eujãde jarateemaa beeji. Maap'eda wãji ãra t'ẽe. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Maapai Tachi Ak'õre Ode P'anɨɨrã k'aurepa, Éfeso p'uurudepemaarã jõma k'ĩraupik'a para baji ");
INSERT INTO sjaNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ne-inaa p'arat'adee oopari Demetrio apatap'edaapa ãra ãpɨte pedee k'achia jarada perã. Mãgɨ́ eperãpa ne-inaa ma-ãri santok'a p'arat'adee oopachi, ãchi ɨt'aa t'ɨ̃pata nawe Artemisa te waibɨa k'irãpapataadamerã. Mãga oo bɨpa ichia mãik'aapa apemaarã ne-inaa oo k'awaa beerãpa p'arat'a waibɨa jitapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Maperãpɨ Demetriopa mãgɨɨrã mãik'aapa awaraa ne-inaa oo k'awaa beerã t'ɨ̃ p'e atap'eda, mãgaji: —K'õp'ãyoorã, parãpa k'awa p'anɨda aji, nãgɨ́ mimia oo p'anɨpa tachi p'arat'a jitapata. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma awara parãpa unu p'anɨ mãik'aapa ũri p'anɨ Pablopa jaratee bɨ, ne-inaa ooda eperãarãpa aɨ k'ĩrapite ɨt'aa t'ɨ̃pata ak'õre waibɨarã-e. Mãga jara bɨpa eperãarã chok'ara ichi eere ũraa p'e iru bɨ. Mãga jara-e bɨ nama Éfeso p'uurudepai. Ichiaba mãga jara bɨ jõma Ásia eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iru pedee ijãaruta pɨrã, tachia ooda neto amaadai mãik'aapa tachia p'arat'a waa jitada-e pai. Ma awara tachi nawe Artemisade ijãada-e pai mãik'aapa ichiaba waa iru ĩgreste ak'ɨda-e pai. Mãgɨ́ tede na Ásia eujãdepemaarã mãik'aapa jõmaweda Roma jua ek'ari p'anɨɨrã irumaa ɨt'aa t'ɨ̃pata. ¿Wãara-ek'ã aji, mɨa jara bɨ? ");
INSERT INTO sjaNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Arii p'anadap'edaarãpa mãga ũridak'ãri, k'ĩraudachida mãik'aapa biuk'a nɨ̃beeji: —¡Artemisa Waibɨa; tachi Éfeso pidaarã nawe! ");
INSERT INTO sjaNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mãpai eperãarã waapɨara cheepuru nɨ̃beeji mãik'aapa p'uuru pidaarã jõma k'ĩraupik'a para beeji. Mãpai Gayo, Aristarco ome jita atajida mãik'aapa atadachida ãchi chip'edaipatamaa. Ma eperãarã omé Macedonia eujãdepemaarã paji. Ichiaba Pablo ome nipapachida. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo wãit'ee paji ma p'uuru pidaarã k'ĩrapite pedeede. Mamĩda ijãapataarãpa wãpida-e paji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ichiaba Asiadepema poroorã ũk'uru Pablo ome k'õp'ãyo meraadap'edaa perã, jara pëijida wãnaamerã ma eperãarã k'ĩraupik'a para bɨmaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mãɨmisa, chi cheepurudap'edaarã waapɨara k'ĩraupik'a para beeji. Ũk'uruurãpa ne-inaa jarapachida; awaraarãpa biapachida. Mapa biuk'a nɨ̃baji. Ũk'uruurãpa k'awada-e p'anajida sãap'eda cheepurudap'edaa. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Judiorã arii p'anadap'edaarãpa Alejandromaa nepɨrɨdap'eda, jõmaarã taide ateejida. Mãpai Alejandropa juapa jaraji k'ĩup'ee p'aneedamerã, ãchi k'ap'ɨa pedeeit'ee perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mamĩda eperãarã k'ĩraupik'a para badaarãpa ichi judío k'awaadak'ãri, perá hora omé waapɨara biuk'a nɨ̃beeji. Mãgapachida: —¡Artemisa Waibɨa; tachi Éfeso pidaarã nawe! ");
INSERT INTO sjaNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mãpai aɨ p'uurudepema secretariopa eperãarã k'ĩup'ee p'anapiji mãik'aapa mãgaji: —Éfeso pidaarã, jõmaarãpa k'awa p'anɨda aji, na p'uuru pidaarã́pata tachi nawe Artemisa jĩak'a ɨt'ariipa baaida ichi ĩgrestede jɨ̃apata. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Apidaapa nãgɨ́ p'oyaa merada-e perã, k'ĩra jĩp'a p'anéetɨ, ne-inaa k'achia pariatua ooda-ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Na eperãarã parãpa anee p'anɨ tachi ĩgrestedepema net'aa maarepida chɨada-e p'anɨ mãik'aapa tachi nawe ãpɨte pedee k'achia jarada-e p'anɨ. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio wa chi k'õp'ãyoorã nepɨra iru p'anɨ pɨrã awaraa ome, Romadepema charraarãmaa wã́tɨ. Ãrapa ak'ɨdaipɨ, ma-it'ee p'anadairã. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mamĩda jõmaarãpa awaraa nepɨra iru p'anɨ pɨrã, k'ĩra jĩp'a cheepurudak'ãri, ma nepɨra jõ pëidai. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Idipema oodap'edaa k'aurepa Romadepemaarãpa k'ĩsiadait'ee tachi chõoyaa p'anɨ. Nãga bɨde ãchia iidi p'anɨ pɨrã sãap'eda idi nãga oojida, ¿sãga p'anaudayama? aji. ");
INSERT INTO sjaNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mãga jarap'eda, eperãarã jõmaweda ãchi te chaa pëik'ooji. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Eperãarã ãchi te chaa wãdap'edaa t'ẽepai, Pablopa ijãapataarã t'ɨ̃ p'eji ũraait'ee. Maap'eda wãji Macedonia eujãdee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mama ijãapataarã ũraa nipap'eda, panaji Grecia eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Atane õpee mama beeji. Mamãik'aapa barcode wãit'ee bɨde Siria eujãdee, k'awaaji judiorãpa ichi peedait'ee ot'ewa p'anɨ. Mapa waya ãpɨtee p'ɨrrabaidachi. Mata wãyaaji Macedonia eujãde. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ma wãdade iru k'õp'ãyaajida nãgɨ́ ijãapataarãpa: Pirro warra Sópatro, Berea p'uurudepema; Aristarco mãik'aapa Segundo, Tesalónica p'uurudepema; Gayo, Derbe p'uurudepema; Timoteo, Tíquico mãik'aapa Trófimo, Ásia eujãdepema. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mãɨrã tai naa wãjida mãik'aapa nɨnajida Troas p'uurude. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma t'ẽepai tai wãjida Filipos p'uurudeepa, fiesta pan levadura wẽe k'opata wãyaap'eda. Barcode wã nipadap'edaa perã, k'ãima joisomaamaa panajida Troas p'uurude. K'ĩrachuunadap'eda apemaarã ome, mama k'ãima siete p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tomia ewate tai chip'ejida apemaarã ijãapataarã ome nek'odait'ee mãik'aapa Cristo piuda k'irãpadait'ee. Pablopa ijãapataarãmaa jarateemaa baji esapɨte parumaa, ichi aɨ norema wãit'ee pada perã. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Te piso ɨt'ɨpema cuartode chip'e p'anajida mãik'aapa lamparara ɨ̃daa nɨ̃baji. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pablo jarateemaa bɨ misa, k'ũtrãa Eutico apatap'edaa su-ak'ɨ baji ventanade ũrimaa. Mamĩda Pablopa taarã jarateeda perã, ma k'ũtrãa k'ãidaip'eda, tudú padachi piso õpeedeepa. Aramata piu jira atanajida. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mãpai Pablo ɨrabaip'eda, ma k'ũtrãa k'ap'ɨa wëre ataji mãik'aapa mãgaji chi k'õp'ãyoorã arii p'anadap'edaarãmaa: —¡P'eranáatɨ! ¡Iru chok'ai bɨpɨ! ");
INSERT INTO sjaNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mãpai Pablo waya teedaa wãk'ãri, nek'ojida mãik'aapa Cristo piuda k'irãpajida. Mata waya ichi jarateemaa beeji ewarirumaa. Ewarik'ãri, wãji ichi ode. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ma k'ũtrãa piu bada chok'ai ateedap'edaa perã ichi temaa, ijãapataarã o-ĩa p'aneejida. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo ode wã k'inia baji. Mapa tai naa wãjida barcode Aso p'uurudee. Mama nɨjida iru batau atadait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso p'uurude unudak'ãri, batauji tai ome mãik'aapa wãjida Mitilene p'uurudee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mamãik'aapa uchiadap'eda, aɨ norema Quío isla k'ĩrapite wãyaajida. Ma norema Samos p'uurude panajida. Mamãik'aapa panajida Mileto p'uurude. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Mãgá oojida Pablo waa wã k'inia-e bada perã Ásia eujãdee. Ma awara Éfeso p'uurude wiibai k'inia-e paji, Jerusalende isapai pana k'inia bada perã, Pentecostés fiesta ewate pai naaweda. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mãgá Éfeso p'uurude wiibai k'inia-e paji taarãi jĩak'aapa. Mamĩda Mileto p'uurude pachedak'ãri, Pablopa t'ɨ̃ pëiji Efesodepema ijãapataarã ak'ɨpataarã. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ãchi pachedak'ãri, ichia mãgaji: —Parãpa k'awa p'anɨda aji, sãgata mɨ nipapari parã t'ãide, na Ásia eujãde ewaa pachedak'ãriipa. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Taarãru parã ome Tachi Ak'õrepa oopi bɨk'a oomaa bɨ, chupɨria nɨ̃bɨde mãik'aapa nepɨrade nɨ̃bɨde judiorã juapa. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mamĩda jõmaarã taide waawee-ee jarateeji, parã te chaa paara. Mãga ooji parã ũraait'ee mãik'aapa k'aripait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Auk'a jarateeji judiorãmaa mãik'aapa judio-eerãmaa, ãchia p'ek'au k'achia oopata oodaamaa p'aneedamerã mãik'aapa Tachi Waibɨa Jesucristode ijãadamerã. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ɨ̃rá wãru Jerusalendee, Tachi Ak'õre Jaurepa mãga k'inia bairã. Wãit'ee k'awa-e bɨ mĩda k'ãata mɨ ome oodait'ee mama. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nãgapai k'awa bɨ. P'uuru bee chaa wãyaarude Tachi Ak'õre Jaurepa mɨmaa k'awapiru mɨ miait'ee mãik'aapa carcelde chupɨria nɨ̃banait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mamĩda mɨa p'ua-e bɨ, piuru pɨjida Jesupa oopi bɨk'a oo k'inia bairã. Jĩp'a jaratee k'inia bɨ na pedee pia: Tachi Ak'õrepa eperãarã k'inia iru bairã, tachi k'aripaji Jesucristo piuda k'aurepa. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Mãga jarateeji parã t'ãide. Ma awara Tachi Ak'õrepa parãmaa jarateeji ichia oopi k'inia bɨ Cristode ijãapataarãmaa. Mɨa k'awa bɨ parãpa mɨ k'ĩra waa unuda-e pait'ee. ");
INSERT INTO sjaNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mapa idi weda Tachi Ak'õre k'ĩrapite mɨa jara bɨ: parãdepema aba piuk'ãri atuaru pɨrã, mɨ k'aurepada 