﻿USE sofia;
DROP TABLE IF EXISTS sofia.six_vpl;
CREATE TABLE six_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES six_vpl WRITE;
INSERT INTO six_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Karainaku apu Tiopilusu, ekime xokupa apue xupuniki eruruneri Xoiteue sini xopu asinaku kapia kakeyaire mua kuna xayawoniai. ");
INSERT INTO six_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ximuximu kapia xotapa yara xati apu ekinikie xekoniai nikau kuna taineri, xayawoteneai. Pa apu teu nini Xoiteupo kunapu saina apu purirounerie, mua kuna asi siketeneai. ");
INSERT INTO six_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pa xati ye rania, mua kuna asi xayau xesarinepure xine. Ye xuwau yause saina tine xokupa kapia xotapaure ati kotoniki sipauweine, pa kapia yaraxeyaireni kutu xayaune. ");
INSERT INTO six_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ne nina xinau ati sipawowai, mua kuna ninie uworineniai paiya, xiri suwauni kutu. ");
INSERT INTO six_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erotie Yutiapu kokemu purotai yause xosa, kire xuria titie purotai, nupo wenumu Sekaraia. Nu Apiyapu apu kinipo xuria titi. Nupo xui wenumu Elisapeti, nu Aronipo apu nou. ");
INSERT INTO six_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nini Xoiteu ekero ati purineri, nupo xokupa tu xeika, kuna xeika ati tairounexeri. Kakineri Xoiteu ekero asinaku kapia tainexeri poripori xuweu purirouneri. ");
INSERT INTO six_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nini nono xuwe. Pa amure, Elisapeti xoso xati ai sakauwexeteneai. ");
INSERT INTO six_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kire yause Sekaraiapu emeumanae xuria titi saina teri, nue rania Xoiteu ekero xuria tepi saina tetai. ");
INSERT INTO six_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yu xuria titierau akeri Xoiteupo ata minika mana xepi kararati xepitutu asinaku uritukuwe Xoiteu xou iwopinaure, xuria titi nikou kapia taineri satu nerawoteneai. Pa kapiarei Sekaraia tumuworeri, nue Xoiteu xou iwopure ata minikani kutu manetai. ");
INSERT INTO six_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pa yause xosa, xokupa xuiapue kisau kunununeri, kunikuni puroteneai. ");
INSERT INTO six_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kakeria, kire Xoiteupo xenikorokoroe, lemeni Sekaraia maiyeuna Xoiteu xouineri xepi karareri xepi tu xirouna sakapu xupo meru kisaro tumu purotai. ");
INSERT INTO six_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kakatia Sekaraiae xenikorokoro xekerina ureri xouxouwari ximiketai. ");
INSERT INTO six_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kakatia xenikorokoroe ipaki kauna, “Sekaraia, ne kaki xanau ximikeu, Xoiteue neu kunikuni iyesetai. Neu ineni Elisapetie sawai nono iyarepina. Wenunauwa Yoni wowai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Pa nono iyarepina yause xosa, xonikemu asinaku purati nimaririwowai. Kakauwa xokupa xui apue nimaririwopineri. ");
INSERT INTO six_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pa amure, nu Xoiteu ekero kokai wenumu tuku xepina. Nu xisa xeika sokisoki ene xeika nepuwati xana xuwe. Nu ana kamoro puratiporoni, Xoiteupo Sokisoki Supo Youyae nu xosa xopoke xepina. ");
INSERT INTO six_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nue kakatia Israilipo xokupa xuiapue pirixineri, nikou Xoiteu Kokaipa xosa xowopineri. ");
INSERT INTO six_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nue Ilaisapu kapia xeika sokisoki xeika tinapa Kokaipa xosa akeri xowopina. Kakinapa nonomi eminikimanapu xoniki tumainikepina. Pani kuna seki ereteneai apu nikau nanunanu kutunikatia, asinaku apu nikau nanunanu sie tepineri. Yonie xuiapu ireinikatia, nini ati purineri Kokaipa yakuwopineri,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kakati Sekaraiae xenikorokoro ipaki kauna, “Amakinei neu kuna suwau xinei sipawopinena? Ye sakau xiti, yeu xui rania sakaurotai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kakatia xenikorokoroe xiyeri kuna kauna, “Ye Kepreli, ye Xoiteu ekero puriroune, Xoiteu nukoini xesayati asinaku kuna kanepure koutiai. ");
INSERT INTO six_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Paina iyese. Ne yeu kuna xonisuwopu xuweutiaiya, ximine ne kunawopu xuweu supuni motoki purauweye, Xoiteupo kapia yara xepina. Xoiteue iyaretai yause putawati paieye yeu kuna suwau xewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Xuiapue Sekaraia yakuworia xuwe xati xouxou wari kunauneri, “Amakatirau Xoiteupo ata minika xuwau yause purina?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Xurise kisau toiti mana supoe kuna kanikepina itou xuwe xati ai supo motoki puri xupoe irauna kuna kanikati sipari kunauneri, Xoiteupo ata minika kire xonuxonu kapia xekerina kakina xeteneai. ");
INSERT INTO six_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Xurise, Sekaraiapu saina yause xuwe xati, nukou wese xowotai. ");
INSERT INTO six_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Utu puratia, nupo xui Elisapetie mupo xu tuku saitina atoro poita autapa teu xosa ximiaki puri kunauna, ");
INSERT INTO six_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kokaipae yeure xousuawati, xuiapu ekinikiro yeu maya xuwe xepineure mua kapia ye xosa akiparina,” xetai. ");
INSERT INTO six_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapetie mupo xu tukuweina poita tai mana poita autapa kireni xosa puratia, Xoiteue xenikorokoro nupo wenumu Kepreli xesawati Kalilipo wese Nasareti xowotai. ");
INSERT INTO six_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xoiteue xesawati kire xui makuna wenumu Maria, nu apu xeika texepu xuweu xui xosa kuna tixowotai. Maria nu kokemu Tepitipo apu noupo apu teruwopure unareteneai. Apu wenumu Yosepu. ");
INSERT INTO six_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Keprelie Maria xosa xouna tapae kusou kauna, “Xui, asinaku yause. Kokaipae ne xeika purina, asinaku purowaire mupuni xusi ouna siwanetai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariae pa kuna iyeserina, ureri nanunanu tiei kunauna, “Mua amu kunana?” xetai. ");
INSERT INTO six_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kakati xenikorokoroe kauna, “Maria ne kaki xanau ximikeu. Xoiteue neure xoukemu xumuna. ");
INSERT INTO six_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iyese. Ne mupuni xu tuku xinau kire sawai nono iyarinauwa, wenunau Yesusu xewai. ");
INSERT INTO six_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nu Kokai Apu puropina. Wenuneria, nu Xouropu Xoiteupo Nononi Kutu, wopineri. Paxati, Xoiteue asa yasiyasi Tepiti sie kokemu tumuworepina. ");
INSERT INTO six_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nu Yekopupo apu noupo kokemu sipesi puropina. Nupo kokemu saina, xuwe xepu wati xana xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kakina kawati, Mariae xenikorokoro kotouna, “Ye mupi xouni kutu, kire apu tine nu xeika xini xana, amakina mua kapia yara xepinana?” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kakati xenikorokoroe kauna, “Xoiteupo Sokisoki Supo Youyae kouyenatia, Xouropu Xoiteupo sokisokini kutue xesuwaki taunepina. Sewai pa nono iyarau Xoiteupo nono xeseuni kutu puratia, wenuneri Xoiteupo Nono,” xepineri. ");
INSERT INTO six_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Iyese. Xepeni Elisapeti nu sakaurotai sorena mupo xu tuku purina, sewai nono iyarepina. Ekime kunauneri nu nono iyarepuwati xana xuwe xirouneri sorena, mupo xu tukuweina poita autapa kireni teu emeseriwotai. ");
INSERT INTO six_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoiteue kire sapi atewopu watixe,” xetai. ");
INSERT INTO six_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kakati Mariae kauna, “Iyese. Ye Xoiteupo saina xui. Nueni ne kunautia sie ye xosa pa kapia kakepina,” wotai. Kakati xenikorokoroe weu xowotai. ");
INSERT INTO six_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pa yause xosa Mariae sarouna sapauni Yuta Tistirikipo kire erewese totouyau purotai xosa xowotai. ");
INSERT INTO six_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Utuna Sekaraiapu atoro mana tapae Elisapeti kusouna asinaku yause wotai. ");
INSERT INTO six_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariae Elisapeti kusouna asinaku yause wati Elisapetie iyesatia, ukauropu nonoe sarotai. Kakati, Xoiteupo sokisoki Supo Youyae kou Elisapeti xesuwaki tauwati, ");
INSERT INTO six_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ere kunairae Maria kauna, “Xoiteue mupuni xusi ouna siwanati xokupa xui nei emeserinikine. Pa nono kamuniro purotai rania, Xoiteue mupo xusi ouna siwawotai. ");
INSERT INTO six_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ye yu xati yeu Kokaipapu ana ye xosa kotaina? ");
INSERT INTO six_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iyese. Ye neu asinaku kuna xakeritia, kamiro purotai nonoe nimaririeina sarotai. ");
INSERT INTO six_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne Xoiteue kanetai sieni, kakepina xine xonisutiai. Pa xati Xoiteue neu xosa asinaku kapia kakatia ne xiri nimaririwowai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariae ipaki kunauna, “Kokaipapu wenumu yeu xoikemue xourorine. ");
INSERT INTO six_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yeu xenimi Xoiteure nimaririxina, nue ye soyetai. Pa kakati ye asinakuni kutu puriroune. ");
INSERT INTO six_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ye nupo saina xui, ye wenimi xuweu sorena, nue xekeyerina xoukemu sina. Mua kaketaia sewai rania, xokupa xui apue Xoiteu Kokaipae nimariri sietaire kunawopineri. ");
INSERT INTO six_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Xoiteu nu kokaipa sokisoki tuku, nue ye tianiyepure xetau kapiani kutu tetai, nupo wenumu xeseuni kutu purina. ");
INSERT INTO six_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Xui apu nuko irue puroteneai xoukemu tinikirouna. Mua puroteneai xuiapu xeika xurisepu xeika rania, pani sipesi sipesi kakiniki puropina. ");
INSERT INTO six_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nukou xupoe, sokisoki saina teyai. Apue totoniki ouneri weniniki xourorirouneri xesanikiati, xetaxetau sarauweniai. ");
INSERT INTO six_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pani sokisoki kokemu xesanikieina, weniniki xuweu apimi xouroretai. ");
INSERT INTO six_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Apu irianiketaia xokupa sapi asinaku tinikati ukaniketai. Kakerina apu xokupa sapi tukua, xesanikati aini xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nupo saina apu Israil tianu purina, xokupa yause nupo xuiapu xoukemu tinikirouna. ");
INSERT INTO six_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kakina Apraxamu xeika asisikimana xeika kanikina, ‘Ye sipesi tinipo xuiapu xurise puputawopineri rania, xoikemu tinikepine xina kanikeyai xati, nanu purina kakina,’” xetai. ");
INSERT INTO six_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariae Elisapeti xeika xeimore poita sie purianuwotaie, xurise nukou wese xiyeri xowotai. ");
INSERT INTO six_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapetie nono iyarepina yause xati, sawai nono iyaretai. ");
INSERT INTO six_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kakati wese emeumana xeika apunou xeikae, Xoiteue xoukemu tuwotaire kuna iyeserineri Elisapeti xeika nimariri woteneai. ");
INSERT INTO six_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Asau autapa xeimore xosa nono mari takeruneri, omo Sekaraia wenu turewopure koteneai. ");
INSERT INTO six_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kakeria nonopu anae kunauna, “Pa xuwe! Wenunuku Yoni wopu,” niketai. ");
INSERT INTO six_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kakati kauneri, “Tini apunouwa, kire muanumu wenitiki xuwe,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kakerineri amu wenumu nono tuwopinana xineri, xupunikie irauneri Sekaraia kotowoteneai. ");
INSERT INTO six_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kotoworia xupoe irau kanikati, na masa tuwori nono wenuna, “Yoni xina xayaretai.” Kakati xokupa xuiapue xouxouworoteneai. ");
INSERT INTO six_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pa yause xosa Sekaraiae sapauni supo pereu kunarina, Xoiteupo wenumu xouroretai. ");
INSERT INTO six_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pa kakati xokupa wese emeumanae pa xonuxonu kapia yara xetai xekerineri ximiketeneai. Pa xokupa kapiapu kuna oi paiye, Yutia Tistirikipo wese totouyau puroteneai xosa kuna ou papaiwotai. ");
INSERT INTO six_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Xokupa xuiapue kuna oi iyeserineri xouxouwari kotoxineri, “Sewai mua nono amukau apu saiyepinana?” xeteneai. Xoiteupo sokisokie nu xeika purati sipawoteneai. ");
INSERT INTO six_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Xoiteupo Supo Youyae, pa nonopu omo Sekaraia xosa koiroati, kunatureture irae ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sini Xoiteupo wenumu xourorepu, Israili nikau Kokaipa. Sini nukou xuiapu kou tianisikina xiyeri tisikina. ");
INSERT INTO six_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nupo saina apu Tepitipo apu kini xosa, Kokaipae sini xiyeri tisikepina sokisoki apu iyaretai. ");
INSERT INTO six_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ekiekimeni nupo xeseu saina apimi kunatureture supunikirei, kunawoyai sie. ");
INSERT INTO six_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kunauna apu xiwaixiwai tikineri xotikikemu xoxixoxi xeteneai nikau xupunikiropu, xiyeri titikepine xeyai. ");
INSERT INTO six_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nue sikou asisikimanaure xousuawati xouwenikina tianikeyai. Ekime nu pa kakina nukoini nukou xouwenisuna nini xeika sokisoki xeseu kuna wareyaireni nanunanuna. ");
INSERT INTO six_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Xupo xouro wari Apraxamu kawoyai. Ekime kunawoyai sie, mua rania sini xosa kakepina. ");
INSERT INTO six_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Xiwai nikau xupunikiropu sosikepure xinana sosikatia, nukou saina tinuku ximikepu xuweu asinaku puropu. ");
INSERT INTO six_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pa xati xokupa yause ekisiki oma purinuku, nukou ekero asinaku kapiarei texepu. Kakinukua nukou asinaku asinaku kapia taiwopu xina nanu woyai sieni puropu. ");
INSERT INTO six_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nakieni, nono, sewai wenineria Xouropu Xoiteupo Kunaturetureni Kutu panepineri. Kokaipapu ime sayeruwowaire akerewai. ");
INSERT INTO six_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Xoiteue ninipo xunu xesauna xiyeri sonikepure xinana, nei nupo xuiapu uworinikauwa, Xoiteue xoukemu tiniketaire sipawopineri. Kakeria mena xouropu xumi xesawati kouyesikatia, ");
INSERT INTO six_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","apu ukumu xosa purineri xumopure xeteneai memeremu tinikepina. Kakina nue tusiki taiwatia, xosikikemu yoroni puropu imerei texepu,” xetai. ");
INSERT INTO six_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Xurise pa nono asaipa utuna Xoiteupo sokisoki xeika xoutuwatia, Xoiteue nupo xenumu sokisokierati apu xuweu wese xouna purotaie, xurise Israili ekinikiro yaraxetai. ");
INSERT INTO six_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pa yause xosa Sisa Akustusue xokupa xuiapu nikau weniniki xayawopinerire tu xotapa iyaretai. ");
INSERT INTO six_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mua saina paiya ximuximu Kwiriniusue Siriapu akereki tumu puratia kapmanie weniniki xayawopi saina tetai. ");
INSERT INTO six_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pa xati kapmanie weniniki xayawopinaure xokupa xui apue nikou weseni kutu xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepu nu Kokemu Tepitipo apu nou. Pa xati Kalili Tistrikipo wese Nasareti wetina Tepitipo wese xouna Yutia Petiliemu xeteneairo manetai. ");
INSERT INTO six_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kapmanie weniniki tepinaure, teruwopure xeteneai xui Mariano xowoxeteneai. Pa yause xosa Maria mupo xu tukuwetai. ");
INSERT INTO six_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nini Petiliemu utu puroxeria, Maria nu nono iyarepina yause tomuroirotai. ");
INSERT INTO six_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toro kou xinirouneri ata koirotai xati, nupo asawapu nono iyarina marie xotori noto nikau maruaro xineretai. ");
INSERT INTO six_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Petiliemu kisauira sanawa xosa, kireu apu sipsipu yayakue purineri ninipo sipsipu ukumu yakuniketeneai. ");
INSERT INTO six_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kakeria Xoiteupo xenikorokoroe maiyeniketai. Kakati Kokaipae nukou kokai naku oi xati una tutututuwati, ekiniki piririkati xiri ximiketeneai. ");
INSERT INTO six_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kakeria xenikorokoroe ipaki kanikina, “Tini kaki xanari ximikaku. Iyesa! Ye xokupa xuiapu nimaririwopinerire, asinaku kuna tikoune. ");
INSERT INTO six_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ximine Tepitipo wese xosa, kire xuie nono iyaretai. Pa nonoe tini xokupa xiyeri sotikepina. Nu Kokaipa, nue xuiapu xiyeri tinikepinaure Xoiteue tumuworetai. ");
INSERT INTO six_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tini nu xekeunaria sipawakuai. Kire nono marie xotoreteneai, noto nikau xoye maruaro xinipurinana xekowakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pa xenikorokoroe kunauwatia, sapauni mena xouropu xokupa xomatua xenikorokoroe kou turuwei, Xoiteupo wenumu xourori ipaki kunauneri, ");
INSERT INTO six_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Xouro purirouna, Xoiteupo wenumu xourora. Ouropu xuiapu xoniki yoroara puropineri. Xoiteue xoniki ina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Xenikorokoroe weniki xiyeri mena xouro xouweria, sipsipu yayakue ipaki kunauneri, “Eseko, sini Kokaipae kasiketai sie, Petiliemu xounuku pa kapia yaraxetai xekopu,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kakeri sapauni xouneri Mariano Yosepuno puroxeri xekeniketeneai. Nonopa, noto nikau xoye maruaro xinipurotai. ");
INSERT INTO six_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Utu xekerineri, xenikorokoroe pa nonoure kaniketeneai sieni xokupa xuiapu kuna uteineri kaniketeneai. ");
INSERT INTO six_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kakeri pa xuiapue, sipsipu yayaku nikau supunikiropu kuna iyeserineri xouxouworoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariae pa kuna xokupa xouro iyarina, nanueni purotai. ");
INSERT INTO six_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsipu yayakue xiyeri xouneri xokupa kapia iyesete, xekotowoteneaire, Xoiteu wenumu xouroreteneai. Xenikorokoroe kaniketai sieni xokupa kapia akipa xetai. ");
INSERT INTO six_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mariae nono iyarati autapa xeimore asau xowatia mari takerupuri wenuneri Yesusu woteneai. Ana kamoro puropu xuweuni xenikorokoroe mua wenumu iyaretai. ");
INSERT INTO six_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yosepuno Marianoe Xoiteupo ekero ekiniki pitixineri asinaku xepineri yause putawati, Mosesipo tu xotapa tainexeri ninipo nono souti Xoiteu tuwoxepure, Yerusalemu xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Xoiteupo tue kunauna, “Akereki sawai nono anae iyarati paiya, Xoiteu nuko tuwakuai,” xeyai. Kakeyai xati pa tu taineri, pa nono xiri xeseuni kutu Xoiteu tuwopure xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kokaipapu tue pani ipaki kunauna, “Ni manapa akereki axiri re turopu motou axiri paiye, Xoiteu xouinari xuria takuai,” xeyai. Yosepuno Marianoe pani pa tu taineri ni manapa rania xuru xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pa yause xosa kire apu Yerusalemu purotai, nupo wenumu Simioni. Nu Xoiteu ekero asinaku kapia taina Xoiteure muris tirouna. Xoiteue unaretai apu, Israilipo xuiapu xonikikemu yororepure kopinaure yakuwotai. Xoiteupo Sokisoki Supo Youyae Simioni xosa purotai. ");
INSERT INTO six_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Xoiteupo Sokisoki Supo Youyae ekime ipaki kauna, “Ne sapauni xumowaixe. Xuwe. Kokaipae nupo xuiapu tinikepure xesawati kopina apu xekerinauweye,” woyai. ");
INSERT INTO six_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kakeyai xati pani Xoiteupo Sokisoki Supo Youyae Simioni sarina, xesawati Xoiteupo ata kama supuro manetai. Tue kunawoyai sie Yesusupo omono ananoe taineri, pa kapia tepure Yesusu norumu sou maneteneai. ");
INSERT INTO six_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kakexeri Simionie Yesusu norumu tina xonikeri Xoiteupo wenumu xourori kunauna, ");
INSERT INTO six_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kokaipa, ye neu saina apu. Ekime nakieni kunauyai sie, ne ye weitau xoi merurei xounei puropine. ");
INSERT INTO six_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ye ikou ekikemueni sini xiyeri sosikepure xesawau kotai apu itou xekeune. ");
INSERT INTO six_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ne xokupa xuiapu ekinikiro pa saina ireitiai, paxati xokupa sanawa sanawapu xuiapue rania, xekopineri. ");
INSERT INTO six_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nu kire naku, xetau xuiapu teu memeremu tinikepina, kakina paiya nakipo xuiapu Israil nikau weniniki xourorepina,” xetai. ");
INSERT INTO six_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simionie pa kuna kunawati Yesusupo omono ananoe iyeserinexeri, xouxouworoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionie pani mupuniki xusi ouna, Maria nono ana kauna, “Iyese. Xoiteue mua nono xesawati kotaie kakatia, xokupa Israilipo xuiapu nikau puropi paiya, kireu xouro xeria, kireu ouro xepineri. Nu xetau puropi purati paiya niniauneri mukise kuna kawopineri. ");
INSERT INTO six_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pa kakatia xokupa xuiapu nikau ximiaropu nanunanu paiya yaraxepina. Kakeria ne rania kire xoma xirouneri xeime siei xonikemu tupo waiyewopina,” wotai. ");
INSERT INTO six_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kire kunatureture xui, wenumu Anae purotai. Nu Panuelipo moke, Aseripo apu nou. Nu xiri sakauni kutu. Ekime apu tina 7-teu xitosani xamu xeika puroyai. ");
INSERT INTO six_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Xurise xamu xumati aini purotai. Muaiya nu 84-teu xitosani tuku. Nu Xoiteupo ata wetirouwati xana xuwe. Nu xokupa yause xoye nepi wetina, kunikuni xosa puri, Xoiteupo saina asau ukumu tirouna. ");
INSERT INTO six_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pa yauseni nue rania nono nutiemu mana Xoiteu eiyase wotai. Kakerina Xoiteue Yerusalemupo xuiapu xiyeri tinikepinaure xokupa xuiapue yakuwoteneai xati, pa nonoure kuna uteiwotai. ");
INSERT INTO six_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nini xokupa kapia Xoiteupo tue kunawoki sieni kakieineri, xiyeri nikou wese Kalili wese Nasareti xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesusu nono asaxinani xokupa sokisoki tina asinaku nanunanu tuku sayatia, Xoiteu nukou xoukemu nu xeika purotai. ");
INSERT INTO six_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xokupa xitosani xosa, Yesusupo omo anae Xoiteue Israil Weinikitati Ati Puroniai Yause Nanuneri xekopure Yerusalemu xourouneri. ");
INSERT INTO six_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesusu asaxina 12-teu xitosani tukuwatia, nikou pa kokaipa yauseure nanuneri Yerusalemu souti xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pa kokaipa yause xuwe xatia, xokupa xuiapue nikou wese yau xouxanau woteneai. Kakeria Yesusu liolio nu Yerusalemuni purotai. Nu poroni purotaia omoye anaye nini sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ninie nanuwoxeteneaia kireu xui apu xeika xouna xeteneai. Kakerinexeri nini rania asau xuwau xuwexi xowoxeteneai. Utorineri, emenikimana kotokotonikineri xirekuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Xireketeneai xireketeneaia, xekopu xuwe xati Yerusalemu xiyeri xirekepure xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Omoye anayei xeimore asau xirekupa teixanerieye, xurise Xoiteupo ata tumau purati xekoxeteneai. Tu xotapa sipa apimi xopu misi purina ninipo kuna iyesete, kotoniketeu purotai. ");
INSERT INTO six_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Apimie nupo kuna iyeserineri, nupo sipa xeika kuna xapa kaniketai xeikaure urewoteneai. ");
INSERT INTO six_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Omoye anayei xekeri urewoxeteneai. Kakeri anae kauna, “Nono ne ama sini mua kapia kakisikinena? Sini eminino xosikikemu xoxixoxi xati xirekinikiriai,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kakexeria Yesusue ipaki kanikina, “Tini ama ye xirekinuana? Ye Xauwapu atoro puropine tini sipa xuwere?” niketai. ");
INSERT INTO six_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yesusue kakati omoye anayei pa kuna xononomu sipawopu xuweuwoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesusue nupo omoye anaye xeika xiyeri xou Nasareti putawoteneai. Xokupa yause ninipo kuna tairouna. Anaepa Yesusupo xokupa kuna xoukemuro iyarina nanu purirouna. ");
INSERT INTO six_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusu asaxina nupo sipa asinakuni kutu xetai. Kakati Xoiteue nu xiri xouwe wati apimie rania nu xonikiewoteneai. ");
INSERT INTO six_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiperiusi nu 15-teu xitosani purati, Pontiasi Pailatie Yutia Tistrikipo kapmani sainapu akereki tumu purotai. Pa yause xosa, Erotie Kalili Tistrik yakuwotai. Kakati nupo xameyau Pilipue Ituria Tistrik xeika Trakonaitis xeika yakuwotai. Kakeri Lisaniasie Apilini Tistrik yakuwotai. ");
INSERT INTO six_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasino Kaiapasinoe ere xuriatiti saina tapai puroxeteneai. Pa yause Yoni, Sekaraiapu nono, nu apu xuweu wese purati Xoiteue nukou kuna kawotai. ");
INSERT INTO six_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kakati Yonie Yotani ene mayau purotai wesewese texina, xuiapue xoniki pirixineri ene isepinerire kuna utei kanikina, “Tini xotiki pirixinari Xoiteupo wenumurei ene isa, kakaria, tinipo xunu Xoiteue xesauweritikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kunatureture Aisaiapu kuna, nakau xosa purotai sie mua kapia akipa xina. “Apu xuweu wesei, kire apu supoe ipaki yaxina, ‘Kokaipa apupo ime atinari kutuni ireinari saya. ");
INSERT INTO six_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Xokupa wese ku xokopexinari, totou porowari ku sayepina. Xokupa ime xoxixoxi xina xupiou sasaiwotai atiwari kutuni puropina. ");
INSERT INTO six_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Xoiteue tisikepure tetai saina ouropu xuiapu xokupae xekopineri,’ ” xetai. ");
INSERT INTO six_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Xokupa xui apue Yoni xosa ene isepure kori, ipaki kanikina, “Tini matu xoxipo nonomi, Xoiteue tinire kisamairaunana xaro titikepuwatixe. Tini yue katikati mua yause xoxi maiyetikepure xetai emeseriwopure xinukuna? ");
INSERT INTO six_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tini sukauni kutu xotiki pirixikiriai xatia, tinipo asinaku kapia paiye sukau xotiki pirixeki sie xepina. Kaki xanari takieni kunaunari, ‘Apraxamu nu sinipo asisiki xaku.’ Ye katikine, Xoiteue mua xe teu pirixati, Apraxamupo asamana xepineri itou. ");
INSERT INTO six_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mani na xotaparo purinana, xokupa na atineri meru erepu xuweurouneri paiya, tataineri xepiro purerewopineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Xokupa xuiapue Yonipo kuna iyeseri kotouneri, “Sini amu amakepinukuna?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kakeri ipaki kanikina, “Apu nu muporopu nekei aimore tukua, apu nekei xuweu kire tuwopina. Apu xoye tukue rania pani pa kapiani kakepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kireu apimi nini kapmanipo xe titie rania ene isepure koteneai. Ninie kotouneri, “Xesepesiki, sini amu amakepinukuna?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kakeri ipaki kanikina, “Tini kapmanie katiketai sieni xe takuai. Kaki xanari xekepu kireu aini taku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kireu xomatuae rania kotouneri, “Sini amu amakepinukuna?” woteneai. Kakeri Yonie ipaki kanikina, “Tini kaki xanari kireu apu xoxixoxiniki kuna xosa iyainikeri, ninipo xe pe taku. Tini nanunari sini isaya sikineri sikirouneri xe paiya itouxa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Xui apue pa kapia xekeri xonikikemu saroati xokupa nanunanu tineri, “Mua apu Yonia Xoiteue nupo xuiapu xiyeri tinikepure unareyai apu rau?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kakeri Yonie ipaki kanikina, “Ye paiya ai ene iseritikiroune. Xurise kire apu kopina paiya nupo sokisoki yeu sokisoki emeseruna. Ye asinaku apu xati nupo erieripo muri xurexepixe. Nue Xoiteupo Sokisoki Supo Youya xeika xepi xeikae ene iseritikepina. ");
INSERT INTO six_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nu apue nupo wit waxi xosa xokupa inaina xesawopure kasira masa xupoe tikouyewopina. Kakinapa wit waxi teukirouneri atoro kununuwopina. Inaina paiya sokisoki xepi sipes u purirouna xosa esiepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yonie Xoiteupo kuna xetaxetau imeirae xuiapu xoniki pirixepinerire, kuna uteiwotai. ");
INSERT INTO six_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yonie ninipo akereki kapmani Erot auwotai. Pa amure, xameyaupo xui Erotias terina, xokupa xoxixoxi kapia teyai xeikaure auwotai. ");
INSERT INTO six_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kakati Erotie pani xiyeri kire kapia xoxini kutu tina, Yoni kakauya atoro iyaretai. ");
INSERT INTO six_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pa yause xokupa xui apue ene isieria, Yesusu rania ene isetai. Ene isieina kunikuni puratia, mena taiyati, ");
INSERT INTO six_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Xoiteupo Sokisoki Supo Youyae kire ni manapa siei kouyewati xekoteneai. Kakati mena xourei kire apu supoe ipaki uru yaxina, “Ne yeu Nono. Neure ye xoi xumuna. Yeu xoikem neure nimaririna,” xetai. ");
INSERT INTO six_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesusupo xitosani muanumu 30 sie xosa nu saina saretai. Kakati xuiapue nanuneri nu Yosepupo nirau xeteneai. Yosepua Elipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nu Matatipo nirau. Matati nu Liwaipo nirau. Liwai nu Melkipo nirau. Melki nu Yanaipo nirau. Yanai nu Yosepupo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepu nu Matatiasipo nirau. Matatiasi nu Emosipo nirau. Emos nu Naumupo nirau. Naumu nu Eslipo nirau. Esli nu Nakaipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai nu Matipo nirau. Mati nu Matatiasipo nirau. Matatiasi nu Semenipo nirau. Semeni nu Yosekipo nirau. Yoseki nu Yotapu nirau. ");
INSERT INTO six_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota nu Yoananipo nirau. Yoanani nu Resapu nirau. Resa nu Serupapelipo nirau. Serupapeli nu Sealtielipo nirau. Sealtieli nu Neripo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nu Melkipo nirau. Melki nu Atipo nirau. Ati nu Kosamupo nirau. Kosam nu Elmatamupo nirau. Elmatamu nu Eripo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nu Yosuapu nirau. Yosua nu Elieseripo nirau. Elieseri nu Yorimupo nirau. Yorimu nu Matatipo nirau. Matati nu Liwaipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai nu Simionipo nirau. Simioni nu Yutapu nirau. Yuta nu Yosepupo nirau. Yosepu nu Yonamupo nirau. Yonamu nu Eliakimupo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu nu Meleapu nirau. Melea nu Menapu nirau. Mena nu Matatapu nirau. Matata nu Natanipo nirau. Natani nu Tepitipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tepiti nu Yesipo nirau. Yesi nu Opetipo nirau. Opeti nu Poasipo nirau. Poasi nu Salmonipo nirau. Salmoni nu Nasonipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni nu Aminatapu nirau. Aminatapu nu Atminipo nirau. Atmini nu Arnipo nirau. Arni nu Esronipo nirau. Esroni nu Peresipo nirau. Peresi nu Yutapu nirau. ");
INSERT INTO six_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuta nu Yekopupo nirau. Yekopu nu Aisakipo nirau. Aisaki nu Apraxamupo nirau. Apraxamu nu Terapu nirau. Tera nu Naorupo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naoru nu Serukupo nirau. Seruku nu Reupo nirau. Reu nu Pelekipo nirau. Peleki nu Eperipo nirau. Eperi nu Selapu nirau. ");
INSERT INTO six_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nu Kainanupo nirau. Kainanu nu Arpasatipo nirau. Arpasati nu Siemupo nirau. Siemu nu Noapu nirau. Noa nu Lamekipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nu Metuselapu nirau. Metusela nu Enokupo nirau. Enoku nu Yaretipo nirau. Yareti nu Malalelipo nirau. Malaleli nu Kenanipo nirau. ");
INSERT INTO six_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani nu Enosipo nirau. Enos nu Setipo nirau. Seti nu Atamupo nirau. Atamu nu Xoiteupo nono. ");
INSERT INTO six_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xoiteupo Sokisoki Supo Youyae Yesusu xosa korekixati, Yotani ene weti xiyeri xowatia, pani Xoiteupo Sokisoki Supo Youyae, sou tina apu xuweu wese xowotai. ");
INSERT INTO six_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Apu xuweu wese xou 40-teu asau purati, Satanie eruruwotai. Pa yause xosa Yesusu xoye nepu xuweu iriapu purotai. ");
INSERT INTO six_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kakati Satanie ipaki kauna, “Ne suwau Xoiteupo Nono xatia, kunawau mua xe pirixina tupumoru xepina,” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kakati Yesusue xiyeri ipaki kauna, “Xoiteupo Nakaue kunauna, ‘xuiapu nini tupumoru xosa kireni ekinikioma puropuworixe,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kakati Satanie xouro sou xouna, sapauni mua ouropu xokupa sokisoki sanawa Yesusu ataruwotai. ");
INSERT INTO six_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kakerina Satanie ipaki kauna, “Ye mua xokupa sanawa yakuwowaire sokisoki tinitia, ne xiri kokaipa wenini tuku xewai.” Pani Yesusu kauna, “Mua xokupa sapia yeu. Ye kire apu tuwopure xineia, ye tuwopine.” ");
INSERT INTO six_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pani xiyeri kauna, “Ne xonitapa ukurounau ye xosa muris tinauwa, ye mua xokupa sapi tinepine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kakati Yesusue xiyeri ipaki kauna, “Xoiteupo Nakaue kunauna, ‘Ne neu Xoiteu Kokaipa irue purinau, nu xosa kireni xonitapa ukurounau muris te xetai,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kakati Satanie Yesusu Yerusalemu sou xouna Xoiteupo ata xouroni kutu iyaretai. Kakerina ipaki kauna, “Ne suwau Xoiteupo Nono xatia, paina oro potixe. ");
INSERT INTO six_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pa amure, Xoiteupo Nakaue kunauna, ‘Xoiteue nupo xenikorokoro kanikatia ati yakunepineri.’ ");
INSERT INTO six_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kakineria ‘Ninie xupunikiro xemeinepineri, kakeria kire xei sieni woropuwati xana xuwe,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kakati Yesusue xiyeri kauna, “Xoiteupo nakaue kunauna, ‘Ne neu Xoiteu Kokaipa kaki xanau eruruwou,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satanie Yesusu erururou erururouwatia xuwe xati, kire yause eruruwopure weu xowotai. ");
INSERT INTO six_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Xoiteupo Sokisoki Supo Youyapu sokisokirei, Yesusu Kalili Tistrik xiyeri xowotai. Kakati xuiapu payau puroteneaie, Yesusu kou Kalili purina kuna iyeseteneai. ");
INSERT INTO six_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xokupa yause Yuta nikau kununu ata yau xuiapu kuna utei tinikirouna. Kakati xokupa xuiapue wenumu xouroreteneai. ");
INSERT INTO six_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesusue Nasareti xowotai. Nu nono yauseni, pa wese purina asaxetai. Xokupa yause kakirouna sieni, Yuta nikau arikepi yause xosa kununu atoro manetai. Mana Xoiteupo kuna ninaxepure tumuratia, ");
INSERT INTO six_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kunatureture Aisaiapu nakau tuwoteneai. Yesusue ti kaiyeina mua kuna masa purotai xekeri ninaxina, ");
INSERT INTO six_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Xoiteupo Sokisoki Supo Youyae kou ye xosa purina, amure, nukoe tumuyerati xounei xauna puroteneai apimi xosa asinaku kuna utei kanikepineure, Xoiteu nukoe tapiro oripu xona kusawotai. Ye apimi kakauya xosa puroteneai kanikiti kakauya weti xowori, ekiniki sasauwoki xiyeri ekiniki perewopinerire xesayati kanikepure koutiai. Xesayati apimi nikau xu xuweiyerinikepure koutiai, kireue xoronikineri xoxixoxiniketeneai apimi nikau xu xesauwepure xesayati koutiai. ");
INSERT INTO six_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kokaipae nupo xuiapu ati kutunikepina yause putawotai xi yei kanikepineure xesayetai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesusue nakau xotorina apu nakau yakurouna xiyeri tuwati tina iyaratia, nuko misirotai. Kakati xokupa xuiapu kununu atoro puroteneaie Yesusu soki kukowoteneai. ");
INSERT INTO six_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kakeri kanikina, “Mua Xoiteupo nakau xosa kuna iyesikiriaia, mua suwauni kutu yaraxina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kakati Yesusupo wenumu xourorineri, asinaku kuna kunawotaire nanunanu ti xouxou woroteneai. Kakeri kunauneri, “Sini sipa, nu Yosepupo nono, nu amaki muanumu kuna kunawopinana?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kakeri Yesusue ipaki kanikina, “Tini mua kuna xuiapue yeure kunaurouneri kuna kunawakuairau, kunaunaria, ‘Sipetua, ne nakipo mupuni atierinauweye xakuai.’ Kaki kunaunaria, ‘Ne Kapaneamu saina tiai kuna sini iyesikiriai. Paina nakipo weseni kutu pa saina titiai sieni kake xakuai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kakeri kunauna, “Ye suwauni kutu katikine, kire kunatureturepu kuna paiya nukou wesepu xuiapuni kutue nupo kuna iyesirouwori xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ye suwauni kutu katikine, Ilaisapu yause xosa xokupa xui xamunikimana xumuweki oyemasie Israil puroniai. Pa yause xosa mena xirini paraurati, xeimore xitosani 6-teu poita ene mopu xuwe. Kakati wesewese kokaipa mause xosa puroniai. ");
INSERT INTO six_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pa yause Xoiteue kire Israilipo xui xosa Ilaisa xesawopu xuwe. Kire xui oyemasi Sarepati ere wesepu kokaipa erewese Saiton tomuro purota xosa kireni xesawoyai. ");
INSERT INTO six_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kunatureture Elisapu yause xosa rania, xokupa apu lilies supa tuku Israil puroniai. Pa supa xopua kire apu ara nupo supa xuwe xepu xuwe. Xuwena. Siria sanawapu apu Namani kireni nupo supa xuweiroati, xoukemu teteiwoki puroyai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Xokupa apu pa kununu atoro puroteneaie pa kuna iyeserineri, xiri kisamaira niketai. ");
INSERT INTO six_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kakeri sarineri, Yesusu erewese kisauira xesawori xowotai. Pa ninipo erewese paiya kire totou xouro purina. Pa xati kire iri xoxi kararo otuwopure sou xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kakeria Yesusue apu xopurei weniki xourotai. ");
INSERT INTO six_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesusue Kalili Tistrikipo erewese toupa Kapaneam xou purina, kire Yuta nikau arikepi yause xosa Xoiteupo kuna xuiapu uworiniketai. ");
INSERT INTO six_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kakati ninie nupo kuna iyeserineri kokai ure urewoteneai. Pa amure, nu apu weniniki tukue kuna uteiyewati kaketeneai. ");
INSERT INTO six_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kire yause kire apu xoxi yaniyani tukue kununu atoro Yuta nikau purotai. Ere urue Yesusu ipaki yauna, ");
INSERT INTO six_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eio! Nasaretipo Yesusu, ne sini amu amakisikepure koutiana? Sini xoxixoxi sikepure ne koutiairau? Ye ne sipa. Ne apu xeseu asinakuni kutu Xoiteu nukoreini koutiai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kakatia Yesusue pa xoxi yaniyani auwori ipaki kauna, “Ne kuna wetinau mua apu wete,” wotai. Kakati pa xoxi yaniyanie pa apu wasuwati apu xopu oro uraki munatia, xoma xuweuni weu xowotai. ");
INSERT INTO six_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kakati xokupa xuiapue urerineri nikoniko ipaki kunauneri, “Xawaxura, mua amukau kunarau? Nu apu sokisoki weniniki tukue xoxi yaniyani kuna tinikieuna. Kakati nupo kuna iyeserineri, weti xourouneri,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesusue saina tina asinaku kapia kaketaire kuna, Kapaneam sanawayau ou papaiwotai. ");
INSERT INTO six_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesusue sarouna pa kununu ata wetina Saimonipo atoro manetai. Saimonipo tanau xui supa tuku xati mupokemu xepie keriewotai. Kakati Yesusue atiwopinaure kotowoteneai. ");
INSERT INTO six_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kakeri Yesusue xui nutiemu xona tumurouna sokisoki kuna kunawotai, supae pa xui wetepinaure. Kakati supae pa xui wetati, sapauni sarouna xoye ireiyeriniketai. ");
INSERT INTO six_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Asau iru munopure xatia, apimie emenikimana xetaxetau supa tukutuku, xurinikeri Yesusu xosa soniki koteneai. Kakeri Yesusue kireni kireni xui apu xosa xupo iyarati, supa ekiniki kakatiwoteneai. ");
INSERT INTO six_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yesusue xoxi yaniyani xesaxesanikati, xokupa xuiapu wetinikiteteneai. Kakati xoxi yaniyanie xuiapu weniki xouneria ipaki yaxirouneri, “Ne Xoiteupo Nono,” xirouneri. Kakeria aunikeri kanikina, kaki xanari kunawakunikirouna. Pa amure, nini sipa, Yesusu nu xuiapu tinikepinaure Xoiteue xesawati kotai apu. ");
INSERT INTO six_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yesusue xoripesauni kutu erewese wetina kire apu xuweu wese xowotai. Kakati xuiapue xirekipa utu xekeri, kire wese xowopina xineri taiyeruwopure xeteneai. ");
INSERT INTO six_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kakeri ipaki kanikina, “Ye Xoiteu waiwai purotai wesepu asinaku kuna kireu erewese rania uteiwopine. Ye mua saina tepineure Xoiteue xesayati koutiai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kakerina Yutia Tistriki texina Yuta nikau kununu ata yau kuna uteipa texetai. ");
INSERT INTO six_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kire yause Yesusue Kenesaret ene maro usie ukauro tumu puratia, xokupa xuiapue Xoiteupo kuna iyesepure kouneri, nutiemu tumuneri xiri koitauwoteneai. ");
INSERT INTO six_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kakeri Yesusue wese titinikau tauro aimore ene maro xekotai. Niko pa tauro aimore wetineri urinakinaki kurowopi saina teteneai. ");
INSERT INTO six_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesusue Saimon Pitapu tauro xosa epiti manetai. Marina Saimon kawati mana pa tauro suwati, xayakaxayaka usie wetetai. Kakati Yesusue tauro xouro misirouna xuiapu kuna uworiniketai. ");
INSERT INTO six_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesusue kuna tinikieinapa Saimon ipaki kauna, “Wese takuaire ene nukuroni kutu tauro iraupa munanari, wese takuai urinakinaki otuworinau wese ta,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kakati Saimonie ipaki kauna, “Xesepei apu, sini ukumani irerei xinikiri ekisikiro xumi xetaina, xayaka xi kire wese ara tepu xuwe,” wotai. Kakeri kauna, “Muaiya neu kuna tainei urinakinaki otuxanauwopine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yesusupo kuna taineri, wese xana wese teri, urinakinaki teu kurukerewopure xetai. ");
INSERT INTO six_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kakati saina emenikimana kire tauro xosa puroteneaie ma tianikepinerire xupunikie mariniketeneai. Kakeri ninie maneri aimore tauro xosa tianikineri imoroteneai. Pa tauro aimore xiri koiroati ene minika munautepure xeteneai. ");
INSERT INTO six_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pitae pa kapia xekerina, Yesusu nutiemu xoutapa ukurourouna ipaki kauna, “Kokaipa, ne wei xouwo ye xunutua,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kakerina emeumanapu pa wese xana wese teteneai xekerineri, kokaipa ureni kutu urewoteneai. ");
INSERT INTO six_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kakeri Saimonipo saina emeumana aimore Yemusino Yonino, nini Sepeti niraumana, ninie rania ureri ximikieteneai. Kakeria Yesusue Saimon kauna, “Ne kaki xanau ximikeu. Ximine xokupa wese titiai sieni sewai xokupa xuiapu tinikauwa iko taiyepineri,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kakeri tauro iraupa utu xururo putarineri, ninipo xokupa xuru weti Yesusu taiwoteneai. ");
INSERT INTO six_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kire yause Yesusue kire erewese purati, kire apu lilies supa tuku mupokemu xiri xoxietaie purotai. Yesusu xekeri xoutapa ukurourouna, tutuki puri sokisoki kunairae ipaki kauna, “Kokaipa, ne atierepure xinauwa, ye atiyau xoikemu teteiwati Xoiteu ekero asinaku xepine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kakati Yesusue nu xosa xupo iyari ipaki kauna, “Ye kakepure xine,” wotai. Kakati sapauni supa lilies xuweiroati, pa apu xou mupo saiyeina meruketai. ");
INSERT INTO six_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesusue pa apu sokisoki xoka kuna ipaki kauna, “Mua kapia ne xosani yaraxetaire, kaki xanau kire apu kawou. Xuwe. Mosesipo tue kunawoyai sie, neu xonikemu teteiwotaire xou xuriatiti atarunau xouiwo neu xonikemu merukepina. Kakauwa neu supa xuweirotaire xuiapue sipawopineri,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pana Yesusue saina tina asinaku kapia kaketaire kuna oi pani wesewese xowotai. Paire xokuxokupa xuiapuni kutue nupo kuna iyesepure koteneai. Pani atinikati supa xuwexepinaure xeika koteneai. ");
INSERT INTO six_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kakeria xokupa yause xuiapu weniki xouna, apu xuweu wese kunikunirouna. ");
INSERT INTO six_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kire yause Yesusue kuna tiniki puratia, Parisi apimie tu xotapa sipa apimi xeika misi puroteneai. Nini Yerusalemu erewese xeika, xokupa wese Kalili Tistrik xeika Yutia Tistrik xeikapue wese weti koteneai. Kakeri Xoiteupo sokisokie Yesusu xosa purati supa tuku xuiapu atiniketai. ");
INSERT INTO six_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kire apu teue kire apu xeme moteneai. Pa apupo eupara xiri xumueki xayaisa xosa xini purotai. Ata minika xeme maneri Yesusu nutiemu iyarepineria, ");
INSERT INTO six_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","xokupa xuiapue purineri ata iri koirotai xati, supa apu xeme manepineri ime xuwe xetai. Kakeri Yesusue purotai ata xouro maneri ata you kereuweineri, pa apu xayaisapu muri xaike iyososowori xuiapu xopu Yesusu nutiemu munotai. ");
INSERT INTO six_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesusue xekenikatia xiri xonikiesuwori, kunauna, “Yewapu, ye neu xunu xesauweitiai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesusupo kuna tu xotapa sipa apimi xeika, Parisi apimi xeikae iyeserineri ipaki kunauneri, “Mua apu nu yue Xoiteupo iri tepure kunaunana? Kire aipu apue xunu xesauwepu wati xana xuwe. Paiya Xoiteupo saina kireni,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kakeri Yesusue ninipo nanunanu sipauweina, xiyeri ipaki kanikina, “Tini amakati xotikiro muanumu nanunanu tuku xinukuna? ");
INSERT INTO six_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ye amu sariau kunani kutu kunawopinena? Ye kunaunei, ‘Neu xunu xesauweine xepinere?’ e ye sariau kunaunei, ‘Ne sarounau xouwo xepine?’ ");
INSERT INTO six_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kakeri pani kanikina, ‘Tini sipawakuaire ye katikine, Apupo Nono nu mua ouro nu sokisoki tuku, paxati, nu xunu xesawopina itou,’ ” niketai. Kunarina pa apu eupara xumueki xekeu puri kauna, “Ye kanine, ne sarounau neu xayaisa tinau, neu atoro xouwo,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kakati pa apue sapauni xuiapu ekinikiro sarouna, nupo xinetai xayaisa tina Xoiteupo wenumu xouroipa xina, nukou atoro xowotai. ");
INSERT INTO six_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Xokupa xuiapue pa kapia xekerineri, kokaipa ureni kutu urewoteneai. Xoiteupo kokaipa sokisoki xekerineri xonikikemu saroati wenumu xourori kunauneri, “Ximine sini xetau xonuxonu kapiani kutu akipa xati xekeunuku,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Xurise Yesusue teipa xonana kire apu kapmanipo xe titie xe tirouna atoro misi purati xekotai. Pa apupo wenumu Liwai. Yesusue ipaki kauna, “Ne manau ye taiye,” wotai. ");
INSERT INTO six_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kakati Liwaie xokupa sapi weti, sarouna Yesusu tai xowotai. ");
INSERT INTO six_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liwaie nukou atoro Yesusu kokaipa xoye xoyeruwotai. Kakati xokupa apu kapmanipo xe titi xeika, xetau apu teu xeikae rania misineri nini xeika xoye neteneai. ");
INSERT INTO six_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kakeri Parisi apimie nikou tu xotapa sipa apimi xeikae, Yesusupo tataiwopi xeika kuna tuwata xineri kunani kunauneri, “Tini amakati xe tineri xoxixoxi kapia tirouneri apimi xeika xoye ninuku xisa neteurounukuna?” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kakeri Yesusue xiyeri kuna kanikina, “Apu supa xuweuwa sipe apu xosa xourouworixe. Xuwe. Supa tuku apu kirenie sipe apu xosa xourouneri. ");
INSERT INTO six_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Panumu sie, ye apu asinaku puroteneai yainikiti xoniki pirixepinerire kopu xuwe. Xuwe. Ye apu xoxi kapia tirouneri yainikiti xoniki pirixepinerire koutiai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Apimie Yesusu ipaki kauneri, “Xokupa yause Yonipo tataiwopie xoye xurikineri kunikunirouworia, Parisi nikau tatainikepie rania kakirouneri. Pana neu tatainepia xoye nineri xisa nirouneri,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kakeri Yesusue ipaki kanikina, “Kire apu xui tepure xatia emeumana kanikari, nu poroni purianikati xoye xurikepinerire?” Xuwe. ");
INSERT INTO six_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sewai, pa apu sou xowori paiyeye xoye xurikepineri. ");
INSERT INTO six_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesusue kire xonu kuna xeika tiniketai. Ipaki kanikina, “Kire xipiki mari yeis tuku xatia, kire apue tatama xepure oma mari xaku kirai tina, xipiki xosa yeis tatamaxepuwatixe. Nu kakina paiya, oma mari iwaurikepina, pa xeika pa oma mari xakua xipiki sieni xepuwatixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pani kanikina, “Apue xipiki meme ipisa xosa oma xisa warouwatixe. Nu kakina paiya, oma xisae xipiki meme ipisa kereuwatia, xisa oro kusawopina. Kakatia meme ipisa rania xoxixepina. ");
INSERT INTO six_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pa xati nini oma meme ipisa xosa oma xisa woropineri. ");
INSERT INTO six_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Apu xipiki xisa netaiepa nu oma xisaure xirouwatixe. Nu kunauna, ‘Xipiki xisa asinaku xirouna,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kire Yuta nikau arikepi yause xosa Yesusue wit saina nikiyau texetai. Kakati nupo tataiwopie wit waxi tineri, xupunikie nouneri samu xesauneri meru neteneai. ");
INSERT INTO six_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kakeri kireu Parisi apimie xekenikeri kunauneri, “Yuta nikau arikepi yause xosa apue mua kapia kakepi xeseuna, amakati tini kakinukuna?” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Kakeri Yesusue xiyeri kuna kanikina, “Tini Tepitie kakeyaire asi ninaxepu xuwerau? Pa yause nupo apu teu xeika iria nikati, Tepitie Xoiteupo ataro mana xuria titie Xoiteu xouineri moaro iyareri, purirouna tupumoru teyaire kunaune. Pa tupumoru paiya xeseu, xuriatiti kirenie nepineri. Tepitie nina nupo apu teu rania arenikeyai. Tini pa kuna ninaxepu xuwere, wo?” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pani Yesusue ipaki kanikina, “Apupo Nono nu Yuta nikau arikepi yause yakuna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pani kire Yuta Nikau Arikepi Yause xosa Yesusue Yuta nikau kununu ata mana xuiapu kuna tiniketai. Kakati kire apu, xupo meruira xumuwekie purotai. ");
INSERT INTO six_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tu xotapa sipa apimi xeika Parisi apimi xeikae Yesusu atineri tuworoteneai. Pa amure, Yuta nikau arikepi yause xosa apu atinikepinare, xuwere xineri sipawopure kaketeneai. Ime xekeunukua kuna xosa iyarepinuku xineri kaketeneai. ");
INSERT INTO six_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kakeri Yesusue ninipo nanunanu sipauweina, pa apu xupo xoxixeki ipaki kauna, “Ne sarounau mua apu ekinikiro tumurouwo,” wotai. Kakati pa apue sarouna tumurotai. ");
INSERT INTO six_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kakati Yesusue ipaki kanikina, “Ye tini kototikepure xine. Mosesipo tu xotapa taiwopure xinukua, sini Yuta nikau arikepi yause xosa asinaku kapia kakepure, e xoxi kapia kakepu? Sini apu tianikikiri ati puropinerire, e apu xoxixoxi nikepu,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kakerina xokupa apimi xekexekenikipa utu suweina, pa apu ipaki kauna, “Neu xupuni kutuwore,” wotai. Pa apue kakati, nupo xupo xiyeri asinakuwetai. ");
INSERT INTO six_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Paire tu xotapa sipa apimi xeika Parisi apimi xeikae xiri kisamairanikati nikoniko kunauneri, “Sini Yesusu amu amakuwopuna?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pa yause xosa Yesusue kunikuniwopure, kire totou xouro xouna Xoiteure kunikuni xinati ekero xumietai. ");
INSERT INTO six_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xoripesau asau moatia, nupo tataiwopi yainikati maiyewoteneai. Mori apu 12-teu tumunikerina, tianiyepi xina weni niketai. ");
INSERT INTO six_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kire Saimon, Yesusue wenuna Pita wotai. Saimonipo xameyau Entru rania tumuworina, pani Yemusu, Yoni, Pilipu, Patolomiu, ");
INSERT INTO six_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomasi, Alpiusi nirau Yemusu, Selotipo apu kini Saimon, ");
INSERT INTO six_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yemusipo nirau Yutas, Yutas Iskoriat, pa apue xurise Yesusu xiwaixiwai woteneai apimi tiniketai. ");
INSERT INTO six_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesusue nupo tianuwopi xeika totou munaneri, kire ou ku xosa nupo kokaipa tataiwopi teu xeika tumuwotai. Kakati xokupa xuiapu Yutia tistrik wesewesepu, Yerusalemu ere wesepu, Tair ere wese xeika Saiton xeikapu usie maropue rania puroteneai. ");
INSERT INTO six_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yesusupo kuna iyesepure koto, atinikati supa xuwe xepinaure xeika kotowoteneai. Xuiapu xoxi yaniyanie xoxixoxi niketai rania, Yesusue atinikati meruketeneai. ");
INSERT INTO six_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kokaipa sokisokie Yesusu xosa purati, nu xosa xupuniki iyareria merukirouneri, pa xati xokupa xuiapue nu xosa xupuniki iyarepure xeteneai. ");
INSERT INTO six_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesusue nupo tataiwopi xekeniki puri kunauna, “Tini xauna teu nimaririwa. Pa amure, tini Xoiteue yakuniketai xuiapu xopuro purinuku. ");
INSERT INTO six_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Tini apu mua iriapu purikiriaia, tini nimaririwa. Sewai tini naria ukatikepina. “Tini apu mua muri purikiriaia, tini nimaririwa. Sewai tini xitepi worakuai. ");
INSERT INTO six_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Sewai apue xeketikeri Apupo Nono taiwaria, nini xonikikemu xoxixoxi xati, ninia tikete xesatiketeuneria, wenitiki ororepineri. Pa xokupa kapia kakeria, tini pani nimaririwakua. ");
INSERT INTO six_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pa xokupa kapia xoxi tini xosa kakeria, tini nimaririrei popotinari xotikikemu asinakuni kutu xakuai. Iyesa. Xoiteue mena xouro asinaku sapie xotiki iwopure iyari purina. Ekime asinikimanae muanumu kapiani kunatureture xosa kakeniai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pani kanikina, “Tini xe tuku xinuku karainaku sasaikiriai apimi, tini sosopa epixakuawai. Tini xotikemu asinaku purakuai xuru tieikiriai. Tini sewai xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tini mua xoye nari ukatikirouna, tini sosopa epixakuai. Sewai tini iriatikatia xoxi puropi purakuai. “Tini mua xitepi warounuku, tini sosopa epixakuai. Sewai moraria morepi waxi ekitikirei kiririwatia. Kakinaria tini xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Xokupa apue wenitiki xouroreria, tini xoxixakuaire kakinerina sosopa epixakuai. Ekime asinikimanae xoreixorei kunatureture xosa panumu kapiani kakinikeniai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pani Yesusue ipaki kanikina, “Tini yeu kuna iyesirounuku apimi, tini xiwaiyatikimana xotiki tinikinari, tinire xonikikemu xoxixoxirouneri apimi xosa asinaku kapia kaka. ");
INSERT INTO six_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kireu apue kunauneri, Xoiteue tini xoxixoxi tikepina xeria, tinie Xoiteu kotowaria, nue asinaku kapia nini xosa kakepina. Tini kunikuni waria, Xoiteue tini xoxixoxitiketeneai apimi xosa asinaku kapia kakepina. ");
INSERT INTO six_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kire apue ounina sokaniro ratia, pani pirixinau kireira tuwo. Kire apue neu kumukumu keinatia, pani wetau neu mupuniropu erieri rania tepina. ");
INSERT INTO six_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xokupa apue xuru sike xineri kotoneria, tinike. Kire apue neu xuru terinatia, xiyeri tinepinaure sokisoki kuna kunawou. ");
INSERT INTO six_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xokupa asinaku kapia kireu xuiapue tini xosa kakepineri sieni, tinie rania pa kapiani nini xosa kakakuai. ");
INSERT INTO six_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Tinire xonikieurouneri apimire kireni xinaria, yuerau nanunapa tini apu asinaku xepina? Apu xunu tuwae rania, ninire xirouneri apure xonikieurouneri. ");
INSERT INTO six_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tini apu asinaku kapia tini xosa kakirouneri sieni nini xosa kakinaria, yuerau nanunapa tini asinaku xuiapu xepina? Apu xunutuae rania, pa kapiani kakirouneri. ");
INSERT INTO six_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tini apu xiyeri xe xapa sikepineri xinari tinikinaria, yuerau nanunapa, tini asinaku xuiapu, xepina? Apu xunutuae rania emenikimana xunutua xe xapa tinikirouneri, pa amure, nini sipa, pa apu teua nini xiyeri xe xapa tinikepineri. ");
INSERT INTO six_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tini xiwayatikimana xotikikemu tinikinari, asinaku kapia nini xosa kaka. Tini apu xe tinikerinaria, xiyeri xapa tepure xaku. Tini pa kakinaria, sewai asinaku nutupipi puropini kutu tinaria, Xouropu Xoiteupo nono purakuai. Xoiteua nu eiyasewopu xuweurouneri apu xeika xoxi apu xeika rania xoukemu tinikirouna. ");
INSERT INTO six_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xoiteue takire xousuwa xirouna sieni, tinie rania xokupa xuiapure xotikisuwa xa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesusue pani kunauna, “Tini kireu nikau kapia sapauni uteiwopu xuweunaria Xoiteue tinipo kapia sapauni uteiwopu xana xuwe. Tini apu xoxi xuwe xi kunaunaria Xoiteue tini xoxi tikepu wati xana xuwe. Panumu kapiani Xoiteue taki xosa rania kakexete. Tini kireu nikau xunu wetaria, Xoiteue tinipo xunu weteritikepina. ");
INSERT INTO six_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tini kireu apu xuru tinikaria, Xoiteue tini xapasi xuru tikepina. Tini asinakuni kutu uteiyeri tikina xiri xokoperi kotowatia, xiri koirouna kusawopu sie xatia tikepina. Tini kireu apu amukaurau tinikirounuku sieni, Xoiteue xapa panumu sieni tikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusue kire xonu kuna xeika ipaki tinikina, “Kire apu ekesaue kire apu ekesau ime ataruwopinare? Xuwe. Axirini upuro kiririwopineri. ");
INSERT INTO six_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kire makunae nupo xesepeu emeseru puratixe. Nu atina xaya uweina paiyeye, xesepeu nuko sieni xepina. ");
INSERT INTO six_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Amakati emeni ekero inaina misiara xekeunena, pana nakipo ekiniro kokaipa na masa puratia nanuwau xana xuwere? ");
INSERT INTO six_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne nakipo ekiniro kokaipa na masa purotai xekopu xuweunaua, amakinau emeni kaunau, ‘Emei, ye neu ekiniro inaina sirawepure xine xewaina?’ Ne xoreixoreitua, ximuximua nakipo ekiniro kokaipa na masa siraweinau paiye, naki ati xekexekeu purinaua, emeni ekero inaina misiara purotai sirawewai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesusue pani kunauna, “Na asinakua xoye xoxi erirowatixe. Panumu sieni na xoxi paiya asinaku xoye erirouwatixe. ");
INSERT INTO six_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Apue na ereki xekerineri paiyeye, na asinaku re, xoxirau xineria sipawopineri. Apue kotou muri sire kupari waxi tepure xourouwori xana xuwe. Nini na xoxi kotou tuku xosaupo xisa waxi tirouwori xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Apu xokupa nanunanu asinaku xoukemuro purotaia, nu asinaku apu. Pa xati nu asinaku kapia kakirouna. Apu xoxia nu xokupa nanunanu xoxi xoukemuro purina. Pa xati nu kapia xoxi kakirouna. Panumu nanunanu xoukemuro xokopexati, supoe xesaurouna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesusue pani ipaki kunauna, “Tini ama yeu wenimi tinuku, ‘Kokaipa, Kokaipa’, xinukua yeu kuna taiwopuxuweurounukuna? ");
INSERT INTO six_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kire apue maiyeina, yeu kuna iyeseri taiwatia, ye panumu apupo kapiaure katikepine. ");
INSERT INTO six_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pa apua nu kire apue oma ata xuwopure kakieuna. Ximuximua upu xuruweina, simeni kusauwati upuro munana kokakokai xe xeika erarauna sokisoki xetai. Kakerina pa upu minika xe xouro ata kotoretai. Ene mana xuyaie pa ata suwatia, ata suruna munopu xuwe, pa amure, pa apu nu sokisoki ata asinaku xuworetai. ");
INSERT INTO six_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Apue yeu kuna iyesina taiwopu xuweuwotaia, nu kire apue ata ouro aini xuworetai sie. Nu simeni akeri upuro iyarepu xuwe. Xurise enei pa ata suwatia, sapauni pa ata suruna xiri xoxietai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesusue xuiapu kuna tinikieina, Kapaneam ere wese xowotai. ");
INSERT INTO six_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kakati kire tumu nu 100 xomatua kini yakunikirounae purotai. Nu kire aipu saina apu tuku. Pa saina apure xiri xouweurounana, kokaipa supa tina xumopure ekesimu narairotai. ");
INSERT INTO six_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kakati pa tumue Yesusu kou purina kuna iyeserina, nupo saina apu kou atiwopinaure, Yuta nikau tumu xesanikati kotowopure xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yesusu xosa utu putari sokisoki kuna ipaki kauneri, “Pa xomatua nikau tumua nu asinaku apu, nu tianuwowai sie itou. ");
INSERT INTO six_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nu siko Yuta xouwesikirouna. Kakina nukoini sinipo kununu ata xuworisiketai,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kaki kawori, Yesusue nini xeika xowotai. Nu ata tomuro manatia, pa xomatua nikau tumue emeumana xesanikati maneri nupo suporopu kuna Yesusu ipaki kauneri, “Kokaipa, kaki xanau yeure irereiwou. Ne yeu atoro mowaia, ye asinaku apu xati mowaixe. ");
INSERT INTO six_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ye ikoini manei xekenepinepa ye asinaku apu xati manepixe. Ne ai supunie kunawau yeu saina apu ekekatiwopina. ");
INSERT INTO six_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ye mua kuna kunautiaia, amure, ye rania yeu yayakuyepi apu wenumu tuku irue purine. Ye xomatua teu tuku nini iko irue purineri. Ye kire kaune, ‘Ne xouwo xitia,’ nu xourouna. Kire kaune, ‘Ne mouwo xitia,’ nu marouna. Kire kaune, ‘Ne mua saina te xitia,’ nu tirouna,” xina kuna xesawotai. ");
INSERT INTO six_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusue pa apupo kuna iyeserina kokaipa ure urewotai. Kakeri pirixina pa kokaipa xuiapu kinie taiwoteneai ipaki kanikina, “Ye tini katikine, Israil sanawa mua apue xousuwotai sie kire apue kakati ye xekopu xuwe,” nikeketai. ");
INSERT INTO six_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Xomatua nikau tumue xesanikati Yesusu kawopure koteneai apu teue, atoro xiyeri xouneri, pa saina apu supa ekekatieina purati xekoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Emeu yause xosa, Yesusue kire erewese wenumu Naini xowotai. Kakati nupo tataiwopi xeika kokaipa xui apu teu xeikae xirini xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesusue pa erewesepu sepuripo kokaipa isima tomuro munatia, kireu apu teue kire apu xumoki moupu xemetineri, erewese weti kisau mori tutumaniketai. Pa apupo ana nu xamu xumoki oyemas, nu nono pa kireni tuku. Pa xati xokupa xuiapu kini pa ere wesepue pa xui xeika moteneai. ");
INSERT INTO six_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kokaipae pa xui xekoatia, xiri xou suawati, pa xui ipaki kauna, “Ne kaki xanau morou,” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kakerina nutienikini xonana, pa xayaisa xosa xupo iyarati, pa apu mou xemeroteneaie tumuwoteneai. Kakeri Yesusue kunauna, “Apu tenemai, ye kanine, ne sarouwo,” xetai. ");
INSERT INTO six_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kakati pa apu xumokie, sarouna misirou kunawotai. Yesusue pa apu xumoki ekemiri kusaweina, xiyeri ana tuwotai. ");
INSERT INTO six_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Xokupa xuiapue Xoiteupo kokaipa sokisoki xekerineri, urewei ximiketeneai, Xoiteupo wenumu xouroreteneai. Kunauneri, “Kire kokaipa kunatureture sini xopu kotai,” xeteneai. Pani kunauneri, “Xoiteue nupo xuiapu tianikepure kotai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Xuiapue Yutia tistrik sanawa xeika, xetau sanawa yau xeika xouxanauneri, Yesusue kaketai kapiaure, kunaupa texeteneai. ");
INSERT INTO six_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yonipo tataiwopie, pa xokupa kapia Yesusue kakati xekoteneaire, Yoni kawoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kakeri Yonie nupo tataiwopi aimore yainikeri, xesaniati Kokaipa ipaki kotowopure xowoxeteneai. “Mua apu, ne Xoiteue kunauna xesautia kopina xeyai apure, e sini kire apu yakuwopinuku re?” kuna tixowoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pa apu aimorei, Yesusu xosa putari, kunauneri, “Yoni nu ene iserinikirounae xesasiati ne xosa kounua, nue ipaki kotonepure xina, ‘Mua apu, ne Xoiteue kunauna xesautia kopina xeyai apure, e sini kire apu yakuwopinukure xetai?’ ” woteneai. ");
INSERT INTO six_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pa yause xosa Yesusue xuiapu xetaxetau supa tuku atinikati meruketeneai. Kakina xoxi yaniyani arierinikina, ekiniki komosi atinikete wati, meruketeneai. ");
INSERT INTO six_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaki purina Yonipo tataiwopi aimore ipaki kuna xapa kanikina, “Tini xounaxari taiyeni mua kapia xekoto iyeseteuyatiaire Yoni kawaxa. Ekiniki sasauwoki xiyeri ekiniki perewori, sieniki xoxi texineri. Apu lilies supa tukua, mupuniki asinakuweri, apu xakuniki susu kuna iyesineri. Apu xumoteneai xiyeri sarori, apu xauna nini Xoiteupo asinaku kuna iyesineri. ");
INSERT INTO six_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Apimie ye xekeineri, xonikisuneria, nini ouro uraki kopuworixe nimaririwopineri,” xetai. ");
INSERT INTO six_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yonipo tataiwopi aimore kuna tikoxeteneaie xiyeri xouwexeria,Yesusue Yonire xuiapu ipaki kanikina, “Tini apu xuweu wese xoukiriai yause xosa, amu xekopure xoukiriaina? Tini xupeue kire xauta initati xekewopure xoukiriairau? Xuwe. ");
INSERT INTO six_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tini amu xekopure xoukiriana? Tini kire apue asinaku asinaku nekei erati xekopure xoukiriaire? Xuwe. Apu nini asinaku nekei erineri, mupunikiropu asinaku asinaku xuru tukueteneaia, nini kokemu nikau atoro purirouneri. ");
INSERT INTO six_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pana tini amu xekopure xoukiriaina? Tini kire kunatureture xekopure xoukiriaire, wo? Nu sore. Ye tini katikine, pa kunatureture paiye xokupa kunatureture emeserinikina. ");
INSERT INTO six_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pa apure sore Xoiteupo nakaue ipaki kunauna, ‘Iyese. Ye kire apu yeu kuna uteiwopinaure, xesautia akeri xowopina. Kakinapa nue akeri ime sayepina,’ xeyai. ");
INSERT INTO six_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ye tini katikine, Yonie xokupa apu ouro puroteneai emeserinikina. Pana pa apu nu Xoiteue yakuniketai xuiapu xopuro misiarani kutu purotaia, nu Yoni emeseruna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Xuiapu xeika xe titi xeikae pa kuna iyesiei kunauneri, “Xoiteupo kapia paiya xiri kutu asinaku,” xeteneai. Kaki kunawoteneaia, amure, nini Yoni xuporo ene iseteneaie kunawoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisi apimi xeika tu xotapa sipa apimi xeikapa, nini Yoni xosa ene isepuxuweuwoteneaie, Xoiteue asinaku ime atariniketai sorena nikiniki tuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesusue pani ipaki kunauna, “Ye mua yausepu xuiapu nikau kapiaure kunawopurepa, ye amu xonu kunairae kunawopinena? Nini amu apu siena? ");
INSERT INTO six_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nini nono teu siei kununu wese yau misi purineri nono emenikimana ipaki yainikineri, ‘Tini liawakuaire sini xopu yaxikiria, tini liawopu xiraxinuku. Sini karimasu wakiria, tini moropi xiraxinuku,’ nonoe pa kakieu purineri,” xetai. ");
INSERT INTO six_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesusue pani ipaki kunauna, “Yoni nu ene iserinikirounae kouna tupumoru nina, xisa ninaurouwati xana xuwe. Tini kunaunuku, ‘Xoxi yaniyanie nu xosa purina,’ xikiriai. ");
INSERT INTO six_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ximine Apupo Nonoe kouna, xoye nina xisa nina wati, xokupa yause tinie ipaki kunaunuku, ‘Xekoa, nu ere xoye xeika xisa xeika nini. Nu xe titi xeika xunutua xeika nikau emeniki,’ xirounuku. ");
INSERT INTO six_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tini kaki kunaurounuku sorena, xuiapu nini Xoiteupo sipa teteneaiepa, nupo sipa asinaku xineri, asinaku kapia atarisikirouneri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kire Parisi apue Yesusu xeika xoye nepure yauwotai. Kakati Yesusue pa apupo atoro manati xinirou kiseniki sese xoye neteneai. ");
INSERT INTO six_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kire xui nu xoxixoxi kapiani kutu kakirounae pa erewese purotai. Yesusu kouna Parisi apupo ata xoye nina kuna iyeserina, kire asinaku kikise xopu tikotai. ");
INSERT INTO six_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mana Yesusu nikeroni tumuna siau sakoro muri purotai. Kakati morepi waxie Yesusupo siau yorukaro yau kiririwati, pa xui nukou tapa urieni kieruwotai. Kakinani Yesusupo siau yorukaro uritokotokouna, kikise xopu kusauna siau yorukaro yau iseruwotai. ");
INSERT INTO six_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pa Parisi apu Yesusu yauwati motaie, pa xuie kaketai kapia xekerina, parumeikarei yopini ipaki nanuna, “Mua apu nu suwau kunatureture xatia, mua xuie nu xosa xupo iyaretai sipawoto, nupo kapia sipawoto wopina. Mua xui nu xunu tua,” xina nanuwotai. ");
INSERT INTO six_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusue pa apupo nanunanu sipari ipaki kauna, “Saimon, ye kire kuna tuku, ne tinepurexine,” wotai. Kakati Saimonie kunauna, “Xesepei, ne neu kuna kaye,” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kakati Yesusue kauna, “Aimore apue kireni apu xosa xe ekeu tuku. Kire 500 kina xe ekeu tukuna, kire 50 kina kireni. ");
INSERT INTO six_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ninie pa xe ekeu, xapa tuwopineri itou xuwe xati, pa apu xe xatakue ninipo xe ekeu weteriniketai. Paina ne nanuwo, yueni kutue pa apu xe xataku xiri xouwewopinana?” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kakati Saimonie ipaki kauna, “Ye nanutiaia pa apu xe kokaipa ekeu weteruwotaie,” wotai. Kakati Yesusue kauna, “Neu nanunanu suwau,” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kakeri Yesusue pirixina pa xui xekeu puri Saimon ipaki kauna, “Ne mua xui xekowo. Ye neu atoro matia, ye siai kurowopine ene nei siepu xuwe. Mua xuie nukou morepi waxie siai kurowotai. Kakerina nukou tapa urie siai yorukaro kixetai. ");
INSERT INTO six_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ye ekimeni mane puritia, ne uritoko yepu xuwe. Mua xuieye mana yeu siai uritokotokouna. ");
INSERT INTO six_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne orip xona xopu tine tapiro oine kixepu xuwe. Mua xuieye kikise xopu timana siai yorukaro kixina. ");
INSERT INTO six_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pa xati ye ne kanine, sini mua xui xekeukiria, ye xiri xouweni kutu xouweina, pa amure Xoiteue nupo xokupa xunu weteruwotai. Pana apue xunu misiara kakati, Xoiteue pa xunu weteruwotaia, nue rania ere Xoiteu xouwewopu watixe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kakeri Yesusue pa xui ipaki kauna, “Ye neu xunu xokupa xuweiyerinitiai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Paire Yesusu nuko xeika sakamaro kiseniki sese xinipuroteneai apu teue kuna iyeserineri, nikoniko ipaki kunauneri, “Mua apu nu yue xunu weterunana?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kakeri, Yesusue pa xui ipaki kauna, “Neu sokisoki xonsue kakati ximine ne Xoiteu xeika asinakuni kutu purine. Ne xounau xonukuruwei puro,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xurise Yesusue pa wese wetina erewese yau texete, wesewese xeika texeteuna, Xoiteue mua ouropu xuiapu amu yause xosaurau yakunikepinaure Yesusue asinaku kuna uteiwotai. Kakati nupo 12-teu tataiwopie nu xeika texeteneai. ");
INSERT INTO six_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kakeri kireteu xui, ekime Yesusue xoxi yaniyani arierinikina, supa tuku atinikete wati meruketeneaie nu xeika xowoteneai. Kire paiya Maria, wenuneri Maktala erewesepu Maria woniai. Ekime Yesusue nu xosaupo xoxi yaniyani 7-teu arieruna xesauweruwoyai. ");
INSERT INTO six_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoanano Susananoe rania nu xeika xowoteneai. Yoana paiya nu Kusapu xui, Kusa apua nu Erotipo ata yayaku tumu. Pa xui teue ninipo sapi arara, Yesusu nupo tataiwopi xeika tianikirouneri. ");
INSERT INTO six_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xokupa erewesepu xuiapue Yesusu xosa kouneri ere kununu puroteneai. Kakeri kire xonu kuna ipaki tinikina, ");
INSERT INTO six_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kire apue sainoro xouna wit waxi purerewotai. Nue purereupa xowatia, kireu wit waxi paiya imero kiririwati, apue xorowori ni tupusorisorie maneri neteneai. ");
INSERT INTO six_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kireu wit waxi paiya xe tuku ou xosa kiririwotai. Wit waxi puputa wotai sorena, ou enekemu xuwexati xiri kurakurauna xumuwetai. ");
INSERT INTO six_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kireu wit waxi paiya kotou muri sireu xopu kiririwotai. Kakati kotou muri xeika puputawotaina, kotou murieni kururuna wit kururutauwotai. ");
INSERT INTO six_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kireteu wit waxi paiya asinaku ouro kiririwati mana meruni erina, 100 100 waxi eretai,” niketai. Yesusue pa xonu kuna kunauweinapa ipaki yaxina, “Apu xaku tukuepa mua kuna iyesepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesusu nukou tataiwopie pa xonu kuna xotapa kaniketaire kotowoteneai. ");
INSERT INTO six_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kakeri ipaki kanikina, “Xoiteue ximiaropu kapiapu kuna xotapa Xoiteue xuiapu yakunikepine yause xosa Xoiteu kakepina. Ataritikati sipauweikiriai. Pana kireu xuiapua nini xonu kuna kireni iyesirouneri. Paxati, nini xokupa yause xekexekewopineri sorena, kire sapi xekeu sipawopuworixe. Nini xokupa yause kuna iyesepineri sorena, nini pa sapi xotapa sipawopuworixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesusue pani ipaki kanikina, “Mua xonu kuna xotapa paiya muanumu. Pa wit waxi paiya Xoiteupo kunaure kunauna. ");
INSERT INTO six_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit waxi imero kiririwotaia muanumu, xuiapue Xoiteupo kuna iyeseteneai sorena, xurise Satanie mana, xonikiropu kuna xesauweriniketai. Satanie nanuna, ‘Nini xonikisuworia, Xoiteue xiyeri tinikexete xina kaketai.’ ");
INSERT INTO six_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit waxi xe tuku ouro kiririwotaia, apue kuna iyesineri tineria paire nimariri woteneai. Pana nini wit waxi ou minika kinimu munopuxuweiyeuneri, kakineri, xekepu yause xonikisuwopu xuweu purineri. Eruru yause moatia, Xoiteu wetirouneri. ");
INSERT INTO six_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit waxi kotou muri sireu xopu kiririwotaia, apue kuna iyeseteneai sorena, mua ouropu misepire nanunanuneri xe tuku sasaiwopure nimaririneri. Pa xokupa kapiaure xineri Xoiteupo kuna ati taiworixe. Nini pa kakineri xoye ati xureixepixuweiyeuneri. ");
INSERT INTO six_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pa wit waxi asinaku ouro kiririwotaia muanumu, apue kuna iyesineri sokisoki teteneai. Ninipo xonikikemu kutu asinaku, nini sokisoki purineri meru eri purineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesusue pani ipaki kunauna, “Apue naku oi tineri kokoto iruworo iyarirounerire, e suwari iruworo iyarirouworixe. Xuwe. Apue atoro maneri memeremu xekopinerire, naku oiti saka xouro iyarirouneri. ");
INSERT INTO six_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Xokupa sapi ximiaki purotaia, sewai yarani akipa xepina. Xokupa sapi apue xotoreri purotaia, sewai yarani akipa xeria, apue sipa nikepineri. ");
INSERT INTO six_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Tini sosopa epixinari, kuna ati iyesakuai. Kire apu nu kireu xuru tukuwetaia, Xoiteue pani kireu tuwopina. Apu xuru xuweue, ye xuru tuku xina nanuwotaia, Xoiteue xesauweruwopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pa yause xosa Yesusupo anae niraumanapu Yesusu xekopure koteneai. Xokupa xuiapue kununu purori, nini Yesusu nutiemu mopineria itou xuwe xeteneai. ");
INSERT INTO six_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kakeri kireu apue Yesusu ipaki kauneri, “Neu aninie xameyanimanapu ne xekenepure kisau tumu purineri,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kakeri xiyeri kanikina, “Xui apu nini Xoiteupo kuna iyesineri taiwoteneaia, nini yeu anikamana xameyaimana,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kire yause Yesusue nupo tataiwopi xeika kire tauro xouro maneteneai. Marineria ipaki kanikina, “Sini Kalili ene pira xowopu nikati,” xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tauro ene xourei munauti mautipa xowatia, Yesusu xona xinetai. Kakati kokaipa xupeue mana ene sarati, ene emusauna tauro kamaro koiropure xati xuwe xepure xeteneai. ");
INSERT INTO six_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kakati Yesusu xona koruei kauneri, “Kokaipa apu, Kokaipa apu, sini ximine xuwe xepure xinuku,” woteneai. Kakeri sarouna pa xupeu xeika xasi xeika aunikati xuwexeteneai. Kakati ene xiyeri miriaxepu xuwe. ");
INSERT INTO six_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Paire Yesusue ipaki kotonikina, “Tini ama? Tinipo xotikisu anoro purinana?” niketai. Tataiwopie pa sokisoki saina xekeri, ximikiei xokupa nanunanu teteneai. Kakeri nikoniko ipaki kunauneri. “Mua apu nu yuerau? Nu xupeu xeika ene xeika sokisoki kuna kanikati, nupo kuna iyeseteneai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesusue nupo tataiwopi xeika Kerasa nikau ou masaira utu putawoteneai. Pa wese paiya Kalili ene pira purina. ");
INSERT INTO six_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesusue tauro wetina manatia, kire apu pa erewesepue maiyewotai. Kireu xoxi yaniyanie pa apu xosa puroteneai. Nu ekimeni mari takina purirouwati xana xuwe. Kire atoro rania purirouwati xana xuwe. Nu kopaupuyau purirouna. ");
INSERT INTO six_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pa apue Yesusu xekerina, xira puei nutiemu siau sakaro oro titikiri xowotai. Kakerina ere urue ipaki yaxina, “Yesusu, ne Xouropu Xoiteupo Nononi Kutu, ye amakiyepure kakinena? Eio, ne kaki xanau ye xoxixoxiyeu,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nue pa kaki uru yaxetaia amure, Yesusue kunauna, xoxi yaniyani ne mua apu wete wotairo kunawotai. Xokupa yause xoxi yaniyanie pa apu xorou tina xinerirouna. Apimie sokisoki xumei taurouneri sorena, pa apue xume kakatirouna. Kakati pa xoxi yaniyanie apu weu weseyau soutexirouna. ");
INSERT INTO six_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesusue ipaki kotouna, “Neu wenini yuna,” wotai. Kakati kauna, “Yeu wenimi Xokupa,” wotai. Pa amure, xokupa xoxi yaniyanie nu xosa mauweteneai xati kunawotai. ");
INSERT INTO six_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kakati pa xoxi yaniyani teue Yesusu ipaki sokisoki yauneri, “Ne kaki xanau upu xotapa xuweu mini minika xosa xesasikeu,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kire kokaipa pu teue kire totou ara xosa xoye nipuroteneai. Kakeri xoxi yaniyani teue Yesusu sokisoki kotouneri, “Ne sini weisikitau pia pu kamunikiro mauwepinuku,” woteneai. Kakeri Yesusue weinikitati pu kamunikiro mauweteneai. ");
INSERT INTO six_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kakati pa xoxi yaniyani teue pa apu wetineri, pu kamunikiro mauweteneai. Kakeri pa pu teue kire iri xoxi xosa keikei kururukururu munoteneai. Munaneri ene nukuro munauwei ene nineri xumueteneai. ");
INSERT INTO six_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pu yayakue pa kapia akipa xetai xekeri, ximixouneri erewese kuna tixowoto, wese wese kuna tixowoto woteneai. ");
INSERT INTO six_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kakeri xuiapue pa kapia akipa xetai xekopure koteneai. Yesusu xosa kouneri, xoxi yaniyanie pa apu weteri meruki purati xekoteneai. Nupo nanunanu teteiyati, mari takerina Yesusupo siau sakaro misi purotai. Kakati xuiapue xekerineri ximikieteneai. ");
INSERT INTO six_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pa kapia xekoteneai apu teue, Yesusue pa apu ekime xoxi yaniyani tuku puroyai xosa, kapia kakati meruketaire perariniketeneai. ");
INSERT INTO six_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Paire xokupa xuiapu Kerasa nikau tistrikipoe Yesusue kaketai kapiaure ximikeri, sokisoki nanunanu terineri, Yesusu xesawori weniki xowopinaure sokisoki kuna kunawoteneai. Kakeri Yesusue tauro xouro epitina xiyeri xowotai. ");
INSERT INTO six_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Kakati pa apu Yesusue atierati xoxi yaniyanie weteri merukirotaie Yesusu kotouna, “Xirini xowaxau itoure?” wotai. Kakati Yesusue kauna, “Ne nakipo wese xiyeri xounau, Xoiteue ne tianinepure xokupa kapia kaketaire xuiapu kanike,” wotai. Kakati pa apue xouna Yesusue kaketaire xokupa xuiapu kaniketai. ");
INSERT INTO six_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesusue ene xusatina pira xiyeri xowatia, xokupa xuiapue nu yaku puroteneairo nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kire apue maiyewotai, nupo wenumu Yairus. Nu Yuta nikau kununu atapu kire akereki tumu. Yesusue nupo atoro xowopinaure, nupo siau sakaro xoutapa ukurourouna sokisoki kotowotai. ");
INSERT INTO six_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pa apu nu suwasuwau momuko kireni tuku. Pa momuko nu 12 teu xitosani tukue xiri xumopure ekesimu narairotai. Kakati Yesusue Yairus xeika xowatia, xokupa xuiapue Yesusu turoni susuwataipa xineri xirini xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kire xui purotai, xui nikou supa sie sipes tirouna, pa supa tukuni 12 teu xitosani purirouna. Sipe apimie atieri merukepine xina xe wetirouna sorena merukirowatixe. Kire sipe apue atiwati supa xuwe xepina sie itou xuwe. ");
INSERT INTO six_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pa xuie Yesusu nikeroni kutu ma tumurouna, Yesusupo nekei xuwau maro xupo iyaretai. Pa kakati sapauni xaria tikirati xou mupo saiyetai. ");
INSERT INTO six_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kakati Yesusue ipaki kotonikina, “Yue ye xosai xupo iyaretaina?” niketai. Kakati xokupae kauneri, “Ye xuwe, Ye xuwe,” xi kunau xowoteneai. Kakeri Pitae kauna, “Xesepei apu, xokupa xuiapu teue tumuneri koitaunineri susuwata xineri,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kaki kawatia Yesusue kunauna, “Kirei ye xosai xupo iyaretai. Kakati yeu kireu sokisoki wei xouweineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pa xui nu ximiakepina sie itou xuwe. Itou nu sipauweri, ximikeri kirekireupa mana Yesusu nutiemu xoutapa ukurourouna korume xetai. Kakerina xuiapu ekinikiro Yesusu kauna, “Ye ama ne xosa xupi iyariti, yeu supa sapauni xuweirounana,” xetai. ");
INSERT INTO six_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kakati Yesusue ipaki kauna, “Momuko, ne yeure xonsutiai, pa xati ne xiyeri merukine. Ne xonikuruei xouwo,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusue kunau puratia, kire apue Yuta nikau kununu atapu tumupo atarei kotai. Mana pa tumu ipaki kauna, “Neu momuko xumurotaina, kaki xanau xesepesiki pani xu tuwou,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusue pa kuna iyeserina, pa kununu atapu tumu ipaki kauna, “Ne kaki xanau eini kirekirewou. Ne sokisoki xonisuwauweye, neu momuko meru kepina,” wotai. ");
INSERT INTO six_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesusue Yairuspo atoro xouna, xuiapue pa atoro manaku xina taiyeriniketai. Kakerina Pitano Yonino tinikina, Yemusu tina, pa momukopu omono anano tiniketeuna atoro maneteneai. ");
INSERT INTO six_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Xokupa xuiapu pa atoro puroteneaie, pa momukoure xonikikemu xiri pirixina pawati, murineri ururu kerarau puroteneai. Kakeri Yesusue ipaki kanikina, “Tini kaki xanari moraku. Nu xumati xana ai xini purina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kakati Yesusu xitepi wauwoteneai. Pa amure, momuko xiri xumurotai xati sipari kaketeneai. ");
INSERT INTO six_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kakeri Yesusue pa momukopu xupo tina ipaki yaxina, “Momuko ne sarouwo,” xetai. ");
INSERT INTO six_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kakati pa momuko xumotaia, ekeoma puropina youyae muporo manati, xiyeri eke mirina sapauni sarotai. Kakati Yesusue kanikina, “Paina, momuko xoye tuwa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pa momukopu omoye anayei xonikikemu nimaririrei urewoxeteneai. Kakeri Yesusue sokisoki kuna ipaki kanikina, “Tini kaki xanari kire apu mua kapia akipa xetaire kawaku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesusue nupo 12-teu tianuwopi yainikati moteneai. Xouneri xuiapu xosanikipo xoxi yaniyani xesaxesarinikineri, xetaxetau xoxi supa tuku rania xuweiyeri nikepinerire, kokaipa sokisoki xeika weniniki xeika tiniketai. ");
INSERT INTO six_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xouneri Xoiteue yakunikirouna kuna utei kanikineri, supa xuweiyeri nikepineri xeikaure xesaniketai. ");
INSERT INTO six_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kakeri ipaki kanikina, “Tini kakixanari kire sapi arari tixowaku. Tini kakixanari tou tinari, ari pokia tinari, tupumoru xeika xe xeika teteunari xowaku. Muputikiropu erieri rania aimore aimore taku. ");
INSERT INTO six_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tini kire wese putaunari kire atoro manaria, pa atoroni purakuaiye pa wese wetinaria kire wese xowakuai. ");
INSERT INTO six_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kire erewesepu xuiapue ninipo atoro sotiki xowopu xuweuworia, pa wese wetakuai. Tini weu xowopurexinaria siatikiropu mai pokuwei xowari paiyeye, sini, kapia xoxi tikiriaia, xu tuku xineria, sipawopineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kakati tianuwopie wese wese xowoteneai. Xouneri Xoiteupo asinaku kuna utei kanikineri, wesewesepu xuiapu atinikeri meruketeneai. ");
INSERT INTO six_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Akereki kapmani Erotie Yesusue xokupa kapia kakati iyeserina, xouxouworotai. Pa amure kireteu apue kunauneri, “Yoni nu ene iserinikirouna apue kopaupurei xiyeri sarotai,” xirouneri. ");
INSERT INTO six_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kireue kunauneri, “Paiya nu Ilaisae putauna,” xirouneri. Kireue kunauneri, “Kire ekimenikeu kunatureture kopaupurei xiyeri sarotai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kakeri Erotie kunauna, “Ye Yonipo parukana katieiyai. Pana mua apua nu yu nukoni kutue xonuxonu saina tati xuiapue kunawori ye iyesinenarina?” Xekopure xetai. ");
INSERT INTO six_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusu nukou tianuwopie xiyeri kouneri xokupa saina teteneaire kawoteneai. Kakeri, Yesusue kireu xuiapu weinikiteri, nupo tianuwopi kireni sonikitina, kire erewese xowoteneai. Pa wesepu wenumua Petsaita. ");
INSERT INTO six_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Xokupa xuiapue Yesusu xowotai sipauweineri tai xowoteneai. Utuyewori xoukemu nimaririeina, Xoiteue yakunikirouna yauseurei kuna utei kanikinani, supa tuku xuiapu atinikati meruketeneai. ");
INSERT INTO six_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Xoruwatini kutu Yesusu nukou 12-teu tianwopie maneri kauneri, “Ne xuiapu xesanikau weseyau xouxanauneri xoye xireki nete, ata xekeu xinete wopineri. Mua sanawa purikiriaia apu xuweu sanawa,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kaki kaworia xiyeri kanikina, “Takieni xoye tinika,” niketai. Kaki kanikati ninie xiyeri kauneri, “Sini xokupa xoye xuwe. Tupumoru autapa xeika wese axiri xeika kireni purina. Sini xounuku mua xokupa xuiapu nikau xoye isayarinikepinukure?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Apimi 5,000 siei puroteneai. Kakeri, Yesusue nupo tataiwopi ipaki kanikina, “Tini kanikari 50-teu 50-teu xineri misepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesusupo tataiwopie kakeri, apimie misieteneai. ");
INSERT INTO six_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pani Yesusue 5-teu tupumoru xeika wese axiri xeika tina mena eisau puri Xoiteu eiyasewotai. Kakerina tupumoru xeika wese xeika tina puruporouweina, nupo tataiwopi tinikati ninie xuiapu tinikixowoteneai. ");
INSERT INTO six_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pani xokupa xuiapue pa xoye neri ukaniketai. Xoye maisa kunununeri, murinakai 12-teu xosa imoroteneai. ");
INSERT INTO six_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kire yause Yesusu nukoni kunikuni puratia, nupo tataiwopie nu xeika puroteneai. Yesusue kotonikina, “Xuiapue yeurepa yuxirounerina?” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kakati xiyeri kauneri, “Ne kireue kunauneri, ‘Ne Yoni ene iserikikirouna apue,’ xirouneri. Kireue ipaki kunauneri, ‘Ne Ilaisae,’ xi kunaurouneri. Kireue kunauneri, ‘Nepa ekimenikeu Xoiteupo kunatureture xiyeri sarotai xineri,’ ” woteneai. ");
INSERT INTO six_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kakeri kotonikina, “Takiepa ye yu paxinukuna?” niketai. Kakati Pitae Yesusu xiyeri kauna, “Ne Kristus, Xoiteue tumunerina nukou xuiapu xiyeri sonikewaire xesanati koutiai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pani Yesusue nukou tataiwopi sokisoki xoka tinikipuri kanikina, “Mua kuna kire apu arari xakusu kawaku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kakeri kunauna, “Apupo Nono nu xokupa tatau tepina. Akereki tumu teu xeika, kokaipa xuriatiti xeika, tu xotapa sipa apimi xeika paiye nikiniki tuworineri ouweria, xumuna xeimore asau xowatia xiyeri saropina,” xina kaniketai. ");
INSERT INTO six_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesusue xokupa xuiapu ipaki kanikina, “Yuerau ye taiyepure xinapa, nukoure nanunanu wetina, xokupa yause nukou na nikitoto xemena ye taiyepina. ");
INSERT INTO six_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pa amure, yuerau nuko ekeoma puropi soki tepure xinapa, nuko ekeoma puropisui xuwexepina. Yuerau yeure nanuna nu xuwexina paiya, nu asinaku ekeoma puropina. ");
INSERT INTO six_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yuerau ouropu xokupa sapi tipurina, nuko xoxixina xuwexina paiya, pa xokupa sapie amaki tianuwopinana? ");
INSERT INTO six_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yuerau yeure mayaxina, yeu kunaure mayaxina paiya, sewai, Apupo Nono nukou kokaipa naku memeremu xeika, omopu xeika Xoiteupo xenikorokoro nikau xeika xosa puropinae kouna paiya, pa xuimi apimire rania mayaxepina. ");
INSERT INTO six_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Suwauni kutu katikine, kireu apimi nini mua tumu puroteneai nini xumopu xuweuni, Xoiteue xuiapu yakunepina yause xekopineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusue pa kuna kunauwati kireni muris sie xowatia, Pita, Yemusu, Yoni nini soniki ti kire totou xouro kunikuniwopure xowotai. ");
INSERT INTO six_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesusue kunikuni puratia, nupo moakemu pirixina xetau korowati nupo nekei paiya xiri karaini kutu xina peririketai. ");
INSERT INTO six_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kakatia axiri apue Yesusu xeika kunau puroteneai. Paiya Mosesino Ilaisanoe. ");
INSERT INTO six_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mosesino Ilaisanoe Xoiteu nukou memeremu xeika maneri, Yesusu Yerusalemu saina tieina mua ou weti xowopinaure kunau puroteneai. ");
INSERT INTO six_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita xeika kire Yesusupo tataiwopi aimore xeikae xinimenikati xineteneai. Xiyeri sauweineria Yesusu xeika pa apu aimore xosa xeika memeremu xekoteneai. ");
INSERT INTO six_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pa apu aimorei Yesusu weti xowopure xeria, Pitae Yesusu kauna, “Xesepesiki, sini muoro puropua asinaku. Sini xeimore yana ata xuworepinuku. Kire neu, kire Mosesipo, kirepa Ilaisapu,” wotai. Pitae pa kuna kunawotaia, nu amu kuna rau kunawotai, nu sipa xuwe. ");
INSERT INTO six_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitae kunau puratia, pani kire iyouwe ma xesuaki taunikati ximikieteneai. ");
INSERT INTO six_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pa iyou waiwaie kire apu supoe ipaki kunauna, “Muaiya yeu Nono. Yeu saina teriyepinaure unaritiai. Tini nupo kuna iyesa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Xoiteue kunauwatia, Yesusu nukoni purati xekoteneai. Kakerineri pa totou weti munaneria, Yesusupo tataiwopie pa kapia xekoteneaire kire apu kawopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Xurise kire asau xosa Yesusue nupo tataiwopi xeika totou weti munoria, kokaipa xuiapu teue maneri nu tutumawoteneai. ");
INSERT INTO six_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kire apu nini xopurei Yesusu ipaki yauna, “Xesepei, yeu sawai nono xekowaire ne sokisoki kotonine. Ye pa nono kireni tuku. ");
INSERT INTO six_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xokupa yause kire xoxi yaniyanie kamoro manati, sapauni xoxi xiraxaraurouna. Pa xoxi yaniyanie kakati sirosarouna si maua xana maua paiye xarei kusaurouna. Pa xoxi yaniyanie, pa nonopu mupokemu xiri xoxixoxi xina sapauni wetirouwatixe. ");
INSERT INTO six_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kakati neu tatainepi sokisoki kotonikine, ‘Tini mua xoxi yaniyani xesauweya,’ xitiai sorena nini itou xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kakati Yesusue xiyeri kauna, “Tini xuimiapimi xotikisuwari xana xuwe. Tinipo nanunanu xeika kapia xeika paiya asinakuni kutu xuwe. Ye amakau yause tini xeika purinei tinipo xu xemeropinena? Neu nono sou tinau mouwo,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pa nonoe Yesusu nutiemu moatia, xoxi yaniyanie pa nono oro otuwati utu xiri sirosarowotai. Kakati Yesusue pa xoxi yaniyani auworina, pa nono atieri omo xiyeri tuwotai. ");
INSERT INTO six_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Paire xokupa xuiapue Xoiteupo kokaipa sokisoki xekeri, xiri ureni kutu urewoteneai. Yesusue xokupa kapia kaketaire xuiapue xemu xokupa nanunanu teria, nupo tataiwopi ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tini mua kuna xosa atinari xakutiki iyara. Apupo Nono apu xupunikiro iyarepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kakati nupo tataiwopie pa kuna xotapa sipawopu xuwe. Kuna xotapa ximiaki purati, nini ati sipawopu xuwe. Paire kotouneri sipawopineria, ximikieteneai. ");
INSERT INTO six_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kire yause Yesusupo tataiwopie kunauneri, “Yurau sinipo akereki kokaipa?” xineri niko niko kuna tuwata xeteneai. ");
INSERT INTO six_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kakeri Yesusue ninipo nanunanu xonikiro purotai siparina, kire nono misiara sou mana nuko nutiemu tumuworetai. ");
INSERT INTO six_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kakeri nupo tataiwopi kanikina, “Apue yeure nanuna mua nono misiara souna paiya, nu ye tianina. Apue ye tianina paiya nu yeu xauwa tianuna, nue ye xesayati koutiai. Pa amure, apu wenumu xuweu misiarani kutu tini xokupa xopuro purotai paiya nu akeri purina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yonie Yesusupo kuna iyeserina, xiyeri kauna, “Kokaipa apu, sini kire apue neu weninirei xoxi yaniyani xesauwerinikepi saina tati xekeukiriai. Kaketaina pana siko taisikepu xuweu wati taiyerukiriai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kakatia Yesusue xiyeri kauna, “Tini kakixanari wete waku. Apu nu xiwaitikepu xuweu paiya nu tinipo emetiki,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Xoiteue Yesusu mena xouro sou xowopina yause tomuroirotai. Paxati Yesusue Yerusalemu xowopina nanunanureni sokisoki xetai. ");
INSERT INTO six_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kireu apimi akeri xesanikati, kire Samaria nikau wese xuru ireiyeruwopure akeri xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kakeria pa wesepu apimie, Yesusu ninipo atoro souxowopi xirexeteneai. Pa amure, Yesusu Yerusalemu xowopure xati siparineri xirexeteneai. ");
INSERT INTO six_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Axiri tataiwopi, Yemusino Yoninoe, Samaria apimi nikau kapia xekerineri, Yesusu ipaki kotouneri, “Kokaipa apu, ne iyo xau sini mena xouropu xepi uru yauyatia, kou mua xuiapu u nikepinare?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kakeria Yesusue pirixina auniketai. ");
INSERT INTO six_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kakerineri kire wese xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusue nupo tataiwopi xeika imeyau xoworia, kire apue Yesusu kauna, “Xokupa wese xowauwa, ye tataini texepine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kakati Yesusue kauna, “Mamumamua nini ouro xinirouneri upu tukuna, nia nini teu tuku. Pana Apupo Nono paiya nu xinepina suwari xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesusue kire apu kauna, “Ne ma taiye,” wotai. Kaki kawatia pa apue kauna, “Kokaipa apu, weitau ye xou xauwa upuwarineye,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kakati Yesusue kauna, “Xeuxana. Apu xumoteneaieni ninipo apu teu upuainikepineri. Ne paiya xounau Xoiteue yakunikirouna xuimiapimi xosa kuna uteiwo,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kire apue Yesusu ipaki kauna, “Kokaipa, ye ne tainepurexinena pana, weitau ye xounei yeu apu kini kusonikerineye,” wotai. ");
INSERT INTO six_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kakati Yesusue kauna, “Apu taitai tirouna sorena, nu xokupa yause nikero oioirouna. Panumu apu paiya nu Xoiteue yakunikirouna xuimiapimi xosa saina tepu watixe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Xurise Kokaipae xiyeri pani 72 apu teu tumunikeri, axiri axiri xesanikati weu akeri xowoteneai. Nuko texepina xokupa erewese xeika, wesewese xeika xosa xesanikati xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ipaki kanikina, “Sainoro xokupa xoye itou xuxurexetaina pana, tepineri saina apu xokupa xuwe. Pa xati tinie saina Xataku kotou kunikuniwari, nue saina apu xesanikati xou xoye kununuworuwopineri. ");
INSERT INTO six_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Tini xouwa. Iyesa, tini sipsipu arara sie mamumamu xopu xesatiki tixounuku. ");
INSERT INTO six_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tini kaki xanari xexopu re ari pokia re e kireu sietikiropu erieri arari tixowaku. Xounaria kakixanari xuiapu imero tutumanikinaria kusonikaku. ");
INSERT INTO six_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tini kire atoro manaria, akeri ipakinaria kunaunari, ‘Mua atoropu xuiapu tini xotiki kururei pura,’ xakuai. ");
INSERT INTO six_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kakari kire apu nu siomoue pa atoro puropina paiya, tinipo asinaku kuna pa apu xosa xou puropina. Panumu apu puropu xuweua, tinipo asinaku kuna taki xosatikini xiyeri kopina. ");
INSERT INTO six_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tini pa kireni atoroni purakuai. Ninie xoye xeika ene xeika tikeria nakuai, pa amure, saina tirouna apua nupo xe tepina. Tini kaki xanari xetaxetau ata yau xowaku. ");
INSERT INTO six_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tini kire erewese manari ninipo atoro sotiki xoworia, paina ninie tikepineri xoye nakuai. ");
INSERT INTO six_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kakinaria pa erewese puroteneai supa apu atinikari, supa xuwexepineri. Pani ipaki kuna utei kanikinari, ‘Xoiteu xuiapu yakunikirouna yause, pa nutietiki tomuroirouna xinari,’ kanikakuai. ");
INSERT INTO six_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kire erewese manari ninipo atoro sotiki xowopu xuweuworia, pa erewesepu xokupa imero ma tumupuri kunaunari, ");
INSERT INTO six_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tinipo erewesepu maie sinipo siasikiro erarawotai, tinipo kapia xoxi xati atari tikikiri sipawakuaire siasiki pokunuku. Pana tini ati nanunanuwa. Xoiteu xuiapu yakunikirouna yause, pa ma tomuroirouna,’ nikakuai. ");
INSERT INTO six_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ye katikine, Xoiteue xuiapu kuna xosa tumunikerepina yause paiya, pa erewesepu xuiapu xosa xu mopinapa, Sotomu xuiapue xu teniai emeserinikepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesusue pani kunauna, “Xousuwani kutu, tini Korasin erewesepu xuiapu xeika Petsaita apimi xeika tini xotiki pirixepu xuweunaria tini xoxi xakuai. Kire apue, ikoe taki xopu kakitiai sie xouna Tair erewese xeika Saiton erewese xeika xonuxonu kapia eretai xakua, ekimeni Tair xeika Saiton xeika paiya, xoniki pirixinaku eiyoxi xoniki pirixepi nekei erinaku tepeu tauworo misaku. ");
INSERT INTO six_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Xoiteue xuiapu kuna xosa tumunikerepure iyaretai yause xosa paiya, xu tini xosa yaraxepinapa, Tair xeika Saiton xeika nikau xu xiri emeseriwakuai. ");
INSERT INTO six_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tini Kapaneam, tini mena xouroni kutu iyaitikerepinerire? Xuweni kutu. Tini toupaini kutu apu xumoki nikau wese xowakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesusue nupo tataiwopi ipaki kanikina, “Apue tinipo kuna iyesinapa, nu yeu kuna iyesina. Apue tini nike tikinapa, nu ye nike sina. Apue ye nike sinapa, ye xesayati koutiai Xoiteu nike tuna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesusue 72 apu teu xesanikati xowoteneaie, xiyeri kouneri xiri nimaririwoteneai. Kunauneri, “Kokaipa, sini neu wenini tikiria, xoxi yaniyanie rania sinipo kuna taiwoteneai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kakeri Yesusue kanikina, “Ye Satan xekeutia mena wetina xore memeremue miriaiti uraki kouyeuna. ");
INSERT INTO six_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iyesa. Ye itou wenitiki sokisoki tikieitiai, tini matu xeika apu xoxixoxinikepineri teki xeika xoronikakuai itou, pa xeika tinipo xiwaiatiki Satanipo xokupa sokisoki emeseriwakuai itou. Paxati tini kire sapie xoxixoxitikepina sie itou xuwe. ");
INSERT INTO six_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tini kaki xanari nimaririrei kunaunari, ‘Xoxi yaniyanie sinipo kuna taineri xaku.’ Xuwe. Xoiteue tinipo wenitiki mena xouro nukou nakau xosa xayaretaire nimaririwa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pa yause xosa Xoiteupo Supo Youyae Yesusupo xoukemu nimaririerati, Yesusue ipaki kunauna, “Xauwa, ne ou xeika mena xeikapu Kokaipa, ye ne eiyasenine, pa amure, apu nini asinaku sipa tuku nanunanu tuku xosa mua sapi ximiakerine, apu nono arara puroteneai sie xosa kireni atarinikitiai. Iyo, Xauwa, ne nakipo nanunanu kireni tainau pa kake,” xetai. ");
INSERT INTO six_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesusue pani kunauna, “Yeu Xauwae xokupa sapi yeu xupiro iyaretai. Kire apue Nono sipa xuwe. Xauwa kirenie nu sipa. Kire apue Xauwa sipa xuwe. Nono nuko kirenie, pa apu teu Nono nukoe Omo atariniketai xeika kirenie Xauwa sipa,” xetai. ");
INSERT INTO six_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tataiwopi kirenie purianuwori, pirixina xekenikeri, ipaki kanikina, “Apue tini xekeurounuku sapi xekeuneria, nini nimariri wopineri. ");
INSERT INTO six_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ye tini katikine, ekime xokupa kunatureture xeika kokemu xeikae mua sapi tinie xekeukiriai xekopure xeniai sorena xekopu xuwe. Tinie mua kuna iyesirounuku, ninie iyesepure xirouneri sorena nini iyesepu xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kire tuxotapa sipa apue sarotai. Yesusu eruru wopure ipaki kotouna, “Xesepei, ye amakinei sipes ekioma puropi sui tepinena?” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kakati Yesusue ipaki kauna, “Amu kuna tuxotapa xosa purinana? Ne amu kunaure nina xitiaina?” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kakati pa tuxotapa sipa apue kauna, “Tini sikou Xoiteu Kokaipa xotikiewa. Tini takipo xotikieni xenitikieni sokisokieni nanutikieni nure xiri xotikiewa. Kakinarini takire xikiriai sieni emetikimanaure xotikiewa,” xetai. ");
INSERT INTO six_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kakati Yesusue ipaki kauna, “Paiya. Ne kutuni kunaune. Ne pa kakinauwa, ekinioma puropi sui tewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pa tuxotapa sipa apue nanuna, ye xurarauyepineri parina, Yesusu ipaki kotouna, “Tuxotapae kunauna yeu emeire xetaia, yureni kutu kunawotaina?” xetai. ");
INSERT INTO six_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kakati Yesusue mua kuna kauna, “Kire apue Yerusalemu wetina toupa erewese Yeriko xowotai. Petuae imero ximiaki puroteneaie nanana ou ouworineri, nupo xokupa xuru tineri xowoteneai. Kakeri pa apue imero xini purina xiri xumopureirotai. ");
INSERT INTO six_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pa yause kire xuriatitie ime tai munotai. Pa apu imero xini purati xekerina weu ime marei emeseru xowotai. ");
INSERT INTO six_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pani kire Liwaie rania pareini mana pa apu xekerina weu ime marei emeseru xowotai. ");
INSERT INTO six_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Kire Samariapu apue imeyau xouna pa apu xosa putawotai. Nue pa apu xekerina xiri xousua wotai. ");
INSERT INTO six_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pa apu nutiemu xonana, orip xona xeika xisa enekemu xeika usi xosa oina ereruwotai. Kakerina pa apu xeme tina nukou tonki xouroni miserina, kire toro ata xosa sou xouna ati yakuwotai. ");
INSERT INTO six_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kire yause xosa xe aimore waxi tina pa toro ata xataku tuwori kauna, ‘Nei mua apu ati yakuwo,’ wotai. Pani kauna, ‘Ne nakipo xeini tinau mua apu yakunauwa, ye xiyeri kouneia xapa tinepine,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesusue pa tuxotapa sipa apu kotouna, “Ne amu xi nanunena? Yu nupo emeuni kutue pa apu petua xupunikiro xoxixetai xouwewotaina?” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kakati, nue kauna, “Pa apure xousuawati tianuwotai apu,” wotai. Yesusue ipaki kauna, “Ne xounau panumu kapiani kake,” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesusue nupo tataiwopi xeika teipa xouneri, kire wese manetai. Pa wesepu kire xui, wenumu Mata, nue Yesusu atoro sou xowotai. ");
INSERT INTO six_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata nu xameyau xuisani tuku, nupo wenumu Maria. Mariae mana Kokaipa nutiemu siau sakoro misirouna nupo kuna iyesetai. ");
INSERT INTO six_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata paiya nu xoye ireipurina kokaipa sainaure xokupa nanunanu tetai. Paire Yesusu xosa xona kunauna, “Kokaipa, yeu xameyaie weitati ikoni xoyewopi saina tine. Ne paire nanuwau xana xuwerau? Mana tianiyepinaure kawo,” wotai. ");
INSERT INTO six_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kakati Kokaipae nupo kuna xapa ti kauna, “Mata, Mata, ne xokupa nanunanu tine xokupa sapire xonieune. ");
INSERT INTO six_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ne kire sapire kireni nanunanuwowai. Mua sapi Mariae tepure xetaia, pa asinaku sapini kutu, pa xati nu mua asinaku sapi tepure xetaia sini taiyeruwopuxe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesusue kire iriro kunikuni purotai. Nu kunikuniatia, kire tataiwopie ipaki kauna, “Kokaipa, ekime Yonie nupo tataiwopi kunikuniwopi kapia uworinikeyai sie, sini uworisike,” wotai. ");
INSERT INTO six_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kakati Yesusue ipaki kanikina, “Tini kunikuni naria, ipaki kunaunari, ‘Xauwa, neu wenini xeseu puropina. Neu, Xoiteue xuiapu yakunikirouna yause kopina. ");
INSERT INTO six_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xokupa asau ne pa yausepu xoye sike. ");
INSERT INTO six_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne sinipo xunu weterisike, pa amure, kireue sini xosa kaketeneai xunu weterinikirounuku. Ne kaki xanau eruru wetau sini xosa moxete,’ ” xi uworiniketai. ");
INSERT INTO six_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesusue pani ipaki kanikina, “Kire apu tini xopuropu nu kire xatau tuku, xinepi nikini kutu xouna pa xatau ipaki kotouna, ‘Xatai, ye xeimore tupumoru sie,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Yeu kire maroue imerei kouna yeu atoro putawati, ye xoye tuwopine sie xuwe,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kakati pa atoro purotai apue xiyeri kuna kauna, ‘Ne kaki xanau ye irerei sieu. Isima nakerekina yeu nono teu xeika xinieikiriai. Ye sanei pa sapi tinepi xana xuwe,’ wopina. Paina, amakepinana? ");
INSERT INTO six_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ye tini katikine, ata xatakue sanapa xatau xokupa sapi xuweitauwotai tuwopina. Nu xatau tianuwopureni kutu nanuna kakepu watixe. Xuwe. Nu xataue uru yexekiyexekiwopina xirarina sarouna pa sapi tuwopina. ");
INSERT INTO six_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Paxati ye tini katikine, tini Xoiteu kunikuninari kotowaria sapi tikepina, nu xemu tikepina. Tini sapi xirekepi saina tinaria, xemu xekowakuai. Tini isima korukoru xaria Xoiteue taiyeritikepina. ");
INSERT INTO six_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Xokupa apue Xoiteure kunikunineria, nini sapi tirouneri. Apue sapi xirekepi saina tina paiya nu xekeurouna. Apue isima korukoru xina paiya Xoiteue isima taiyeriwopina. ");
INSERT INTO six_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kire nono takipoe kire wese masa omoe tuwopinaure kotowatia, omoe kire matu xoxi tuwopinare, wo? Xuwe. ");
INSERT INTO six_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nonoe kire kaira waxi omoe tuwopinaure kotowatia, omoe kire teki tuwopinare, wo? Pa rania xuwe. ");
INSERT INTO six_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tini eminikimanapa xokupa xoxi kapia kakirounuku sorena, tinipo nono asinaku sapini kutu tinikepi tini sipa. Pa xati tini paire ati sipawakuai, apue mena xouro purotai emitiki kotoworia, nu nimaririrei Xoiteupo Sokisoki Supo Youya tikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesusue kire xoxi yaniyani kire apu xosa purina supo pararetai xesauweruwotai. Pa xoxi yaniyanie xouratia, pa apu supo motokekie kunawotai. Kakati xuiapue xekerineri xiri urewoteneai. ");
INSERT INTO six_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Paire kireu apue kunauneri, “Nu Pelsepulupo sokisokirei xoxi yaniyani xesaurouna, nu xoxi yaniyani nikau tumu,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kireu apu teue Yesusu Xoiteupo saina tinarexi eruruneri sipawopure, “Mena xouropu kire xonuxonu kapia atarisikexi,” kotowoteneai. ");
INSERT INTO six_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kakeria Yesusue ninipo nanunanu sipauweina, ipaki kanikina, “Kire sanawapu apu teue uteineri aimore tutuxi waraxeria, pa sanawa paiya xoxi xepina. Kire apu noue uteineri nikoniko xiwai waraxeria, pa apu nou purixepina. ");
INSERT INTO six_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanipo apu teue uteineri aimore tutu xineri nikoniko xiwai sayeria, pa xuru Satanie yakuwotaia amakineri puropinerirau? Tini kunaunuku ye Pelsepulupo sokisokirei xoxi yaniyani xesauroune xirounuku. ");
INSERT INTO six_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pana suwau ye Pelsepulue tianiyati xoxi yaniyani xesauroune xatia, yue emetikimana tianikirouwati, ninie xoxi yaniyani xesaunerina? Takipo emetikimanaini kapia ataritikineria tinipo kuna xoxi patikepineri. ");
INSERT INTO six_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Xoiteu nukoini ye sokisoki siati xoxi yaniyani xesanikitia, tini sipaukiriai, Xoiteue xuiapu yakunikirouna yause tini xeika purina. ");
INSERT INTO six_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kire apu sokisokie saripiripiri sie tina nupo ata ati yakuwatia, nupo xokupa xuru ati puropina. ");
INSERT INTO six_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pana kire apu xiri sokisokini kutue mana pa apu nueni ouna paiya, nupo xokupa kupira xeika saripiripiri xeikae sokisoki wati purotai tepina. Pa xokupa xuru tina paiya kireu apimi xosa uteiyerinikepina. ");
INSERT INTO six_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Apu yeu marou xuweu paiya, nu ye xeika xiwairouna. Apue ye tianina xokupa sapi kununuwopu xuweuwotaia, nu sirisoroweirouna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesusue pani kunauna, “Xoxi yaniyanie kire apu wetina paiya, kire xiri xekeuna arikepure xiri yau xourouna. Kire iri xekeuna arikepure. Kire iri asinaku xekopu xuweunapa, ipaki kunawopina, ‘Ye ekime puriai atoro xiyeri xowopine,’ xepina. ");
INSERT INTO six_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Xounapa inaina kasauneri nekeiwoteneai ata xekopina. ");
INSERT INTO six_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kakeri xounapa, kireu xoxi yaniyani 7-teu nuko emeseruneri xoxi kapia tirouneri sonikepina. Kakatia pa ata minika maneria puropineri. Ximuximua pa apu xoxi purotai, pana muaia xiri xoxini kutu puropina,” xetai. ");
INSERT INTO six_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusue kokaipa xuiapu teu puroteneai yause xosa kuna uteiwotai. Kakati kire xui nini xopu purotaie ipaki yaxina, “Pa xuie iyainerina apuri tinetaia, nu nimaririwopina,” xetai. ");
INSERT INTO six_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kakati Yesusue kunauna, “Pa xuwena ipaki kunaunuku, apue Xoiteupo kuna iyesineri taineria, nini nimariri wopineri xepu,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Xokupa xuiapuni kutue Yesusu xosa pani kouyewori, Yesusue ipaki kanikina, “Mua yausepu xuiapua nini xuiapu xoxi. Ye Xoiteupo saina tinaxi xonuxonu kapia atarinikepineure yaxineri. Pana nini amu xonuxonu kapia xekopuworixe. Xuwe. Nini kunatureture Yonapu kire xonuxonu kapia kireni xekopineri. ");
INSERT INTO six_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ekime Xoiteupo xonuxonu kapia Yonae kakina Niniwe apimi atarinikeyai. Panumu sieni Apupo Nonoe Xoiteupo xonuxonu kapia tina Xoiteu nuko siei puratia, mua yausepu xuiapue xekopineri. ");
INSERT INTO six_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Xoiteue xuiapu kuna xosa iyainikerepina yause xosa paiya, Sepapu kokemu xuie kuna xosa tumunapa mua yausepu xuiapu nikau kapia xoxire kunawopina. Pa amure, pa kokemu xuie ou maroni kutu purotaina pana, Solomonie nupo sipa asinaku uteiwati iyesepure kotai. Pana kire apu tini xopuro purina, nue Solomoni xiri emeseruna. ");
INSERT INTO six_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xoiteue xuiapu kuna xosa iyainikeratia, Niniwepu apimie kuna xosa tumuneria mua yausepu xuiapu nikau kapia xoxire kunawopineri. Pa amure, Niniwe xuiapue Yonae uteiwoyai kuna iyesineri, xoniki pirixeniai. Pana kire apu mua purotaia, nu Yona emeseruna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesusue pani ipaki kunauna, “Apimie naku oineri ata iruworo upu minika iyarirounerire, e kire kokoto iruworo iyarirouworixe. Xuwe. Nini saka xouro iyareri, apimie maneria pa memeremu xekopineri. ");
INSERT INTO six_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ekinikemu paiya mupunipo naku sie. Neu ekinikemu asinaku xatia, memeremue neu mupuni xokupa xokope xepina. Pana ekinikemu xoxi xatia, neu mupunikomu paiya ukumu xepina. ");
INSERT INTO six_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pa xati ne ati yakuwo. Neu memeremu naki xoniro purotai xukuna ukumu xete. ");
INSERT INTO six_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Neu xokupa mupunikomu memeremu tuku xati kireira masa ukumuwopu xuweu paiya, neu mupunikomu xiri una, nakupo memeremue tiniewopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusue kuna uteiyatia, kire Parisi apue Yesusu kawotai nu xeika xoye nepinaure. Kakati Yesusue atareira mana sakamaro misina apaipurotai. ");
INSERT INTO six_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesusue ene xupo kurowopu xuweuni xoye nati, pa Parisipo apue xokupa nanunau tetai. ");
INSERT INTO six_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kakati Kokaipae ipaki kauna, “Tini Parisia, marua xeika sai masa xeika atinuku nikekemu kurourounuku. Pana kamareira paiya, tini pe xepi kapia xeika xoxixoxi kapia xeikae xokope xinuku. ");
INSERT INTO six_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tini nananana xura! Apue sapi nikereira kesina kamareira kesixepu xuwere? ");
INSERT INTO six_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sapi minikareira purotaia, tini apu sapi xuweu tianikinari tinika. Tini pa kakinari paiya, tinipo xokupa sapi xosei puropina. ");
INSERT INTO six_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pana tini Parisi, sosopa epixa. Xokupa sainoropu sani arara paiya uteinuku 10-teu worinuku kire teupu paiya Xoiteu turounuku. Pana tini kutu xepu kapia wetinuku, Xoiteu xouwewopi kapia weteteurounuku. Xeuxana tini Xoiteu taiwopi kapia sokisoki tinari, kireu tuxotapa taiwa. Kakinari, tini sosopa epixa. Sewai tini xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tini Parisi, sosopa epixa. Tini Yuta nikau kununu ata yau akeri tumauro iri tinuku misepure xirounuku, kakinukuni kununu wese yau xuiapue kuso tikepinerire xirounukuna sosopa epixa. Tini sewai xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Tini sosopa epixa. Tinapa kopaupu teu ou minika ximiaki purori, apue sipa xuweuni pa upu xouyau texineri, Xoiteu ekero xunu tuku xirouneri sie kakinukuna, tini sewai xoxi puropi purakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kire tuxotapa sipa apue pa kuna iyeserina Yesusu ipaki kauna, “Xesepei, ne Parisi apimi muanumu kuna kanikitiaia, sini rania xoxisikine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kakati Yesusue kunauna, “Tini tu xotapa sipa apimi, taki rania sosopa epixakuai. Tini kokai xuru xu tinuku apu tinikari nikoni irereineri xemeiyeuneri. Pana takiepa pa xu tianiki xemeropure kire xuputiki waxi iyarirouwarixe. Paxati, tini xurise xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Tini sosopa epixa. Tinipo asitikimanae kunatureture ounikieri xumori, tinie kunatureture nikau upu atiatinuku nekeirounuku. Paxati, tini xurise xoxi puropi purakuai. ");
INSERT INTO six_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Asitikimanae kakirouneri kapiani tinie apu ekinikiro asinaku kapia xi kakirounaku. Pa amure, asitikimanae kunatureture ounikieri xumoniaina, tinie ninipo upu atiatinuku nekeirounuku. ");
INSERT INTO six_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Xoiteupo asinaku nanunanuni kutue ipaki kunawoyai, ‘Ye kunatureture xeika tianiyepi xeika pa apu xosaniki xesaniki xoworia, ninie kire teu xoxixoxinikineria ounikiepineri,’ xeyai. ");
INSERT INTO six_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pa xati ximuximu Xoiteue mua ou iyarati kouna kouna pani mua yause xosa, apue kunatureture ounikieri xumoteneai nikau xu paiya, mua yausepu xuiapu xosa puratia, ninie pa xoxi kapiapu xu tepineri. ");
INSERT INTO six_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ninie kunatureture ounikieniai, ximuximu Apel ouweineri pani ounikipa kouneri Sekaraia ouweniai. Nu paiya xepi karawori xepi tutu xirouna saka xeika Xoiteupo ata xeika xopuro ouweniai. Suwauni kutu, ye katikine, pa xokupa xoxi kapiapu xuni kutua, mua puroteneai xuiapue tepineri. ");
INSERT INTO six_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tini tu xotapa sipa apimi, tini sosopa epixa. Tinie manuku sipa takuaipo isimapu imetaitai takie xesauwekiriai. Takieni pa wese manakuaia xiraxinukuna pana, kireu xuiapue sipa tepure pa wese manepure xeria, takie ime pararinikinukuna, tini sosopa epixakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesusue nuko purotai ata wetatia, tu xotapa sipa apimi xeika Parisi apimi xeikae xonikikemu xiri xoxixoxi xati kotokoto woteneai. ");
INSERT INTO six_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Xoreuwori kire kuna ateratia, kuna xosa iyarepure kaketeneai. ");
INSERT INTO six_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Xokuxokupa xuiapuni kutue kou kunununeri wese xiri xokoperineri, nikoniko xororuwata xeteneai. Kakeri Yesusue nukou tataiwopi xite kuna ipaki tinikina, “Tini Parisi nikau pususure sosopa epixakuai. Ninipo xoreixorei kapiaure kunaune. ");
INSERT INTO six_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Xokupa sapi xotoi purotaia yarani akipa xepina. Xokupa kuna ximiaropu paiya apue sipawopineri. ");
INSERT INTO six_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pa xati xokupa kuna ukumu xosa kunaukiriaia, xuiapue asau iyesepineri. Xokupa kuna usiasinuku atareira kunaukiriaia, ata xouro tumuneria xuiapu uteiyerinikepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesusue pani ipaki kunauna, “Emeimana, ye mua kuna katikine. Tini apue muputiki kireni ouweirounerire ximikaku, sewaia nini pani amu amakepuworixe. ");
INSERT INTO six_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tini yuni kutu rau ximikuwakuwaire ye ati katikepurexine. Tini Xoiteure kireni ximika. Xoiteue apu ouwati xumuratia, nu sipesi tatau tepi sokisoki xepiro pa apu otuwopina sokisoki tuku. Ye suwauni kutu katikine, tini Xoiteureni kutu ximika. ");
INSERT INTO six_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tini sipa, apue 5-teu ni misiarara xe waxi axiri misiara kirenie isayaxirouneri. Pa ni teure Xoiteue kire araxi xakusirouwatixe. ");
INSERT INTO six_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pa xeika, Xoiteue tinipo xokupa taputiki uri ninaieina, tini ati sipaitikietai. Pa xati tini kaki xanari ximikaku. Tinie xokupa ni misiarara emeserinikinuku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesusue pani ipaki kunauna, “Ye tini katikine, apue xuiapu kanikina ye Yesusu xeika purine xatia, Apupo Nonoe rania Xoiteupo xenikorokoro ipaki kanikinapa mua apua nu ikouni xepina. ");
INSERT INTO six_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pana apue xuiapu kanikina ye Yesusupo apu teu xeika puri xana xuwe xinapa, ‘Ye rania Xoiteupo xenikorokoro kanikineia nu yeu xuwe xepine.’ ");
INSERT INTO six_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Apue Apupo Nono niniauna paiya Xoiteue pa xunu weteruwopina. Pana apue Xoiteupo Supo Youya niniaunapa, Xoiteue pa xunu weteruwopuwatixe. ");
INSERT INTO six_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Tini sotikineri Yuta nikau kununu ata yau, tumu ekinikiro xeika weniniki tuku apimi ekinikiro xeika xoworia, tini kaki xanari ximikeri nanunari, ‘Sini amu paxi kuna xapa kanikepinukuna xaku.’ Xuwe. ");
INSERT INTO six_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pa yauseni kutu Xoiteupo Supo Youyae nini kanikakuai kuna ataritikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kire apue ere xuiapu xopurei Yesusu ipaki kauna, “Xesepei, yeu xauwa xumotaina, nei yeu awai kawau emisie wetetai xuru, uteina kireira ye siepina,” wotai. ");
INSERT INTO six_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kakatia Yesusue kotouna, “Pa ama? Yue ye tini uteitiepineure tumuyeretai xati tinipo xuru uteiyeritiepinena?” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kakerina xuiapu ipaki kanikina, “Tini ati sosopa epixakuai. Tini xuruxana xuru tepure xotikiewaku. Ne xuruxana xuru tuku sorena, neu ekinioma paiya pa xururopu tewai xana xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesusue kire xonu kuna ipaki utei kanikina, “Kire apu karainakupo saina xosa xoye xokupa eri purina. ");
INSERT INTO six_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pa apue ipaki nanuna, ‘Ye amu amakepinena? Yeu xokupa xoye kununuwopine ata itou xuwe.’ ");
INSERT INTO six_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kakeri kunauna, ‘Ye ipakepinerau. Yeu xoye ata kurukereunei, kokakokai ata xuxuwopine. Kakerineia yeu xokupa wit xeika xokupa asinaku xuru xeika pa ata yau soxepine. ");
INSERT INTO six_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kakerineia ikoure ipaki kunauneia, Xawaxura, ye karainakuni kutu xine. Ye xokupa xitosani puropine xuru xokupa asinaku asinaku tuku. Paina ye arikinei puropine. Ye xokupa yause kokai xoye xoyexoyeu ninei xisa ninei nimariri puropine,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kakati Xoiteue ipaki kauna, ‘Ne xiri topini kutu. Ximine ukumanini neu xenini tieitia xumowai. Mua xokupa xuru nei kununuwau purotaia, yue tepinana?’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kakeri Yesusue kunauna, “Apimie xokupa sapie ekinikie nepi kapia xonikiro koxati xokupa sapi nikoni tepenikurouneria, ninie pa sapi Xoiteu nuko tuneri nupo xuiapu tinikirouwori xana xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesusue nupo tataiwopi kanikina, “Ye katikine, takipo puropire xokupa nanunanu ti, kunaunari, ‘Sini amu nepuna?’ xaku. Takipo muputikire xokupa nanunanu ti kunaunari, ‘Sini amu mari takepuna?’ xaku. ");
INSERT INTO six_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ekisikioma puropia xoyepu kireni xuwe. Mupusikia nu nekei emeseruna. ");
INSERT INTO six_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tini ni xalokure nanuwa. Nini uyaxineri xoye kununurouworixe. Nini xuru soxepineri xitamu atare ata paiya xuwe. Nini Xoiteue xoye tinikirouna. Tini xuiapue nini xiri emeserinikinuku. ");
INSERT INTO six_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kire apu tini xopuropue asinaku puropina imeure xokupa nanunanu tinapa, pa xokupa nanunanu tepi paiye ekeoma puropi pani xayakaxayaka xuwau yausereruwopinare? Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tini panumu sapi misiara kakepu itou xuwe xinaria, tini ama kireu sapire xokupa nanunanu tinukuna? ");
INSERT INTO six_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tini ati kakai xekenika, nini amaki perewoteneaina. Nini irereirouworixe. Nini mari kenaurouworixe. Pana ye katikine, ekime kokemu Solomonie nupo nekei asinaku asinaku erirouna, pana mua kakaipo asinaku nekei paiye Solomonipo nekei xiri emeseruna. ");
INSERT INTO six_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ximine mua urei purixanaunana iyatini kutu apue kakatineria xepiro purerewopineri. Panumu aipu urei paiya, Xoiteue nekeiyerinikirouna. Pa xati tini xuiapu xotikisu misiara tukua, ati sipawakuai, tini rania Xoiteue nekei tikepina. ");
INSERT INTO six_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pa xati tini kaki xanari amu xoye ninuku ene nepinukunaxi xokupa nanunanu tinari eiyo xaku. ");
INSERT INTO six_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ouropu xokupa xuiapue panumu sapi tepure xirekineri eiyo xirouneri. Pana Xoiteu tinipo emitikia tini pa xokupa sapi takuai, nu sipauwetai. ");
INSERT INTO six_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Paxati tini sokisoki xotikisunari Xoiteu wetari tinipo kokemu puropinaure sokisoki nanunanuwa. Kakaria pa sapi teu rania tikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesusue pani ipaki kanikina, “Tini sipsipu misiara teu, tini kaki xanari ximikaku. Xoiteu tinipo emitikie itou kunawoyai, nu tinipo kokemu purina paiya, Xoiteue yakunikirouna xuiapu xopuro purakuai xeyai. ");
INSERT INTO six_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tini apu weinikitari ninie tinipo xokupa sapi isayaworia, apu xousua tuku puroteneai pa xe tinika. Tini xe xopuxopu xoxixepuxuweurouna tinaria, mena xouro asinaku asinaku xuru kununuwopi saina ta. Mena xouro paiya xuru ximiakirouwatixe, petuae tirouworixe, xapusikaikaie xoxixoxirouwatixe. ");
INSERT INTO six_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pa wese tinipo asinaku xuru purotai xosauni, tinipo xotikie xotikieukiriai rania puropina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesusue pani ipaki kunauna, “Tini mari kuwori kikai takitauwori, naku oi tinari irei pura. ");
INSERT INTO six_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Apu teue ninipo kokai apue xui kopeu saineri xoye neteneai wese weti xiyeri kopure xati yakurouneri sie pura. Nu mana isima korukoru xatia, sapauni isima taiyepineri. ");
INSERT INTO six_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kokai apue kou nupo saina apu xekenikati xinepu xuweuworia, pa saina apu teu nini nimaririwopineri. Ye suwau katikine, kokai nukoe mari kuwori kikai takerina paiya kanikati sakamaro kiseniki sese misepineri. Kakeria nukoini mana xoye tinikepina. ");
INSERT INTO six_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kokai apue xinepi nikini kuture kakarau akeri yexepina xosa kou saina apu xekenikati xinepi xuweworia, pa saina apu teu nini nimaririwopineri. ");
INSERT INTO six_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Tini mua kapia nanuwa. Ata xatakue petua mopina yause nu sipauna paiya pa petua wetati nupo ata kereuwei manepuwatixe. ");
INSERT INTO six_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tini rania ireiwa. Kire yause Apupo Nono nu kopu wati xana xuwe xikiriai yause xosa kopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitae Yesusu ipaki kotouna, “Kokaipa, sini kireni mua xonu kuna sikinere e xokupa apu xeikani?” wotai. ");
INSERT INTO six_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kakati Kokaipae ipaki kunauna, “Amu apu yayaku asinaku nanunanu tukue, nupo saina ati tirounana? Nukou saina apu teu yakunikepinaure kokai apu nukoe panumu apu yayaku tumunikerirouna, pa xeika kokai apue iyaretai yause xosa xoye tinikepinerire. ");
INSERT INTO six_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Panumu saina apue nukou saina tipurati, nukou kokai apue xiyeri kou xekopina yause xosa nu xiri nimaririwopina. ");
INSERT INTO six_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ye suwauni kutu katikine, kokai apue nukou xokupa sapi yakuwopinaure mua saina apu tumuworepina. ");
INSERT INTO six_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pana pa saina apue xourei nanuna, ‘Yeu kokai apu sapauni kopuwatixerina,’ kireu saina xuiapu ounikina, xoye nina xisa nina xoxi kapia tipuropinapa, ");
INSERT INTO six_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kire yause nu kokai apu sipa xuweuna ireiwopu xuweu puratia nu kopina. Kakatia kokai apue pa saina apu xiri xoxixoxiworinapa, seki erirouneri apimi xeika iyaratia puropina. ");
INSERT INTO six_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Saina apua kokaipa apupo nanunanu sipauwetai sorena, nupo nanunanu taina xuru ireyepu xuweuwotaia, kokai apue sokisoki ouwopina. ");
INSERT INTO six_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pana saina apu nu kokaipapu nanunanu sipa xuweuni seki erina paiya xekepu ouwopu watixe. Apue xokupa xuru teteneaia, xokupa xuru xiyeri xapa tinikepineri. Xuiapue kire apu xuporo xokupa xuru iyarineri kaworia, nue xokupa xuruni kutu xiyeri xapa tinikepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesusue pani ipaki kunauna, “Ye ouro xepi otuti sapauni uwopinaureni kutu koutiai. ");
INSERT INTO six_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye kire xonuxonu ene isepi tepine. Ye tepu xuweune xoikemu xuereni kutuxinana, maneia ye tepineni kutu. ");
INSERT INTO six_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tini nanunari ye mua ouro xokupa xoma xuweiyepure koutiai xaku. Xuwe. Ye katikine, ye xuiapu uteiniki xetaxetau nikepure koutiai. ");
INSERT INTO six_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mua sieni sewai rania, autapa xuiapu teu kireni atoro purineria, uteineri aimore tutu xepineri. Xeimorei aimore xiwai nikeria, aimorei xeimore xiwai nikepineri. ");
INSERT INTO six_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uteineria omoe nirau xiwaiwatia, niraue omo xiwaiwopina. Anae moke xiwaiwatia, mokei ana xiwaiwopina. Kire apupo anae pa apupo xui xiwaiwatia, xuie xamupo ana xiwai wopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesusue xokupa xuiapu ipaki kanikina, “Tini asau munarouna sanawa xosa iyouwe tawatia, sapauni kunaunuku, ‘Ene mopurexina,’ xirounuku. Kakaria suwauni kutu, ene marouna. ");
INSERT INTO six_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pani tini sanawa nikisikiro, saut xeteneaipo sokisoki xupeu koati, xekeri kunaunuku, ‘Xiri mopina,’ xirounuku. Kakaria suwauni kutu, xiri marouna. ");
INSERT INTO six_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tini apu xoreixoreitua, tini mena xouropu sapi xeika ouropu sapi xeika xoiya mua putawori ati uteirounuku. Pana ama mua yause akipa xetaipo kapia sipawopu xuweunukuna?” niketai. ");
INSERT INTO six_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesusue pani ipaki kunauna, “Tini amakati takieni asinaku kapiaure ati nanunuku uteiwopuxuweurounukuna? ");
INSERT INTO six_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Apu kuna xosa iyainerepure xetai xeika kuna xosa xounauwa, imero purinaxarini kuna kuturaxakuai. Amure, kuna xekeritiepina apu xosa soni xouxana, nue xokai xupunikiro iyainerati xokaie kakauya atoro iyainerexete. ");
INSERT INTO six_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye suwauni kutu kanine, ne kakauya atoro purinauni, xokupa xe arara xiri isayaxe xeteneai tinikewai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesusue kuna tinikiatia, Kalilipo apu teure kireu apue Yesusu peraruwoteneai. Pa apu teue noto ouneri Xoiteu xouiwori Pailatie xomatua kanikati ounikieri ninipo yawi notopu yawi xouro kusawotai. ");
INSERT INTO six_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kakeri Yesusue ipaki kanikina, “Tini nanunuku pa Kalilipo apimie xunu xana xunu erineri kireu Kalilipoe erirouneri xunu emeseriniketeneai paire, mua kapia xoxini kutu nini xosa yaraxetaire, wo? ");
INSERT INTO six_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Xuweni kutu. Ye suwau katinikine, tini xotiki pirixepu xuweunaria, muanumu kapiani tini xokupa xosa mopina. ");
INSERT INTO six_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ekime Siloamu mena titi ata xuwau suruna, apu 18-teu ounikieyai, paiya tini nanunuku ninipo xunu paiya, kireu apu Yerusalemu puroteneai nikau xunu emeseriniketeneai, xinukure, wo? ");
INSERT INTO six_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Xuweni kutu. Ye suwau katikine, tini xotiki pirixepu xuweunaria, nini xumoteneai siei xoxinaria xumakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesusue kire xonu kuna ipaki kanikina, “Kire apue kire na kupari nupo xisa xitoro wareyaie, xurise pa na xosa meru tepure kotai sorena meru xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pa xati saina yakuwotai apu ipaki kauna, ‘Iyese. Ye mua na kupari erati tepine xine xeimore xitosani korikoritia xuwexina. Pa xati ne mua na taiyewai. Ama ou kaumu aini xuwexinana?’ ");
INSERT INTO six_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kakati saina apue nupo kuna xapa ti kauna, ‘Kokai apu, wetikiri mua xitosani pani puropina. Xotaporo ou porounei pulmakau sine soxinei misi tuwopine. ");
INSERT INTO six_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Emeu xitosani xosa meru erepinarau. Erepu xuweuwatia, taiyewai,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yuta nikau arikepi yause xosa Yesusue kire Yuta nikau kununu atoro xuiapu kuna tiniketai. ");
INSERT INTO six_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kakati kire xui, nu xosa kire xoxi yaniyani purotaie purotai. Pa xoxi yaniyanie 18-teu xitosani supa tu purotai. Kakati pa xuie xiri komu ouworati, komu ei kuturopina itou xuweuwotai. ");
INSERT INTO six_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusue xekerina, yauwati moatia, ipaki kauna, “Xui, yei neu supa xesauweitiai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kakerina, pa xui xosa xupo axiri iyarati, sapauni pa xuie kutuni tumurouna Xoiteupo wenumu xouroretai. ");
INSERT INTO six_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kakati kununu atapu tumue Yesusure kisamaira wotai, Yuta nikau arikepi yause xosa xui atierati. Kakerina xuiapu ipaki kanikina, “Asau 6-teu xosa saina tepu purina. Apue tinipo supa xesauweritikepinaurepa, saina yause xosa koakuai. Kakixanari apu kaunari, ‘Yuta nikau arikepi yause xosa atisike waku,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kakatia Kokaipae nupo kuna xapa ti kauna, “Tini xoreixorei tua. Tinipo kuna xeika kapia xeika paiya xetaxetau. Yuta nikau arikepi yause xosa paiya tini xokupae pulmakau nikau atoro xou pulmakau xeika tonki xeika xuxureinikinuku, ene nepinerire xuruniki xourounuku. ");
INSERT INTO six_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pana mua xui paiya, nu Apraxamupo kire moke. Satanie 18 xitosani komu mayeri purotai. E amakatina? Ye Yuta nikau arikepi yause xosa supae mua xui tatamari purotai xesauwepine itou xuwere, wo?” ");
INSERT INTO six_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kakina kunawatia, nupo xiwayaumanae mayani kutu mayexeteneai. Kakati xokupa xuiapue Yesusue xokupa asinaku kapiani kutu kaketaire nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesusue pani ipaki kunauna, “Xoiteue xuiapu yakunikepina kapia paiya amu siena? Ye amuxi xonu kuna kunawopinena? ");
INSERT INTO six_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pa sani mastet waxi paiya poise waxipo sarimu sie kire apue pa sani waxi tina nupo sainoro waretai. Kakati xoa putauna na sie kokaipa xati nie kouneri ne yau teu ereteneai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesusue pani ipaki kunauna, “Ye Xoiteue xuiapu yakunikepina kapiaure amuxi xonu kuna kunawopinena? ");
INSERT INTO six_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Paiya pususu sie. Kire xuie pususu tina kokaipa wit punupunu sumaro piriparawotai. Kakati pa wit punupunu xokupa ukau tikina pususuwotai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesusue Yerusalemupo imerei xowotai. Wese wese xeika ere wese yau xeika texina kuna xuiapu uworiniketai. ");
INSERT INTO six_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kakati kire apue kotouna, “Kokaipa, Xoiteue kireni kireni apu kireni xiyeri tinikepinare wo?” wotai. Kakati Yesusue ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tini xayaka isimarei manepurepa, tini atinari sokisokini kutu xakuai. Ye katikine, xokupa apue manepure xepineri sorena, nini itou xuwexepineri. ");
INSERT INTO six_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sewai ata xatakue sana paiya ata isima nakerepina. Kakatia tini kisau ma tumunari isima korukorunaria ipaki yaxakuai, ‘Kokai apu, sini isima taiyerisike,’ xakuai. Kakaria nue xiyeri kuna katikinapa, ‘Ye tini sipa xuwena, tini anaiseunatikepina?’ ");
INSERT INTO six_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kakatia tinie ipaki kaunaria, ‘Sinie ne xeika xoye ninuku ene nikiri, nakie sinipo imero tumune taitaisikiai,’ xakuai. ");
INSERT INTO six_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kakaria nue ipaki katikinapa, ‘Tini anaiseuna, ye tini sipa xuwe. Tini xoxixoxi kapia kakirounuku apu teu, ye xosa moakuna xauweya,’ xepina. ");
INSERT INTO six_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tini Apraxamu xuna Aisaki xuna Yekopu xuna, xokupa kunatureture xuna xekenikaria, Xoiteue xuiapu yakunikirouna yause xosa puropinerina, tini paiya xesatikeria kisau purakuai. Kakeria xoxi morepi murinaria maitiki kiritiwakuai. ");
INSERT INTO six_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kakaria xuiapu muira pairapue sanawa sanawa weti kouneria, Xoiteue xuiapu yakunikirouna yausepu xoye xosa misepineri. ");
INSERT INTO six_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iyesa. Kireteu apu nini mua xuriseni kutu purinerina ninie akeri putawopineri. Kireu apu nini mua akereteneaia, nini xuriseni kutu puropineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pa yause xosauni kutu kireu Parisi apimie Yesusu xosa kou ipaki kauneri, “Erotie ouniepure xinana, ne mua wese wetinau kirero xouwo,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kakeri Yesusue ipaki kanikina, “Tini yeu kuna iyesi xounari pa mamumamu xoxi ipaki kawa, ‘Iyese. Ximine xeika iyati xeikapa xoxi yaniyani xesaunei supa apu atinikepine. Kakineia asau 3 xosa yeu saina xuweiyepine.’ ");
INSERT INTO six_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pana ximine xeika iyati xeika ayaira xeikai paiya ye xowopine. Amure. Kunatureture nu kire wese purati ouwepuworixe. Xuwe. Nini Yerusalemuni ouwepineri. ");
INSERT INTO six_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalemu, Yerusalemu, nei kunatureture ounikieine, Xoiteue xesanikati kouyeneteneai apu tinikine ounikiepure xe tapuniki kururoune. Ye xokupa yause neu nonomi, kakarau anapu sauxokie ara xoronikirouna sie kunununikepure xiroune sorena tinie xiraxinuku. ");
INSERT INTO six_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iyesa. Ximine tinipo wese xoxi xina aini puropina. Ye suwauni kutu katinikine. Tini ye xekeyepu xuweu purokie kunaunaria, mua apu nu ‘Kokaipapu wenumurei kotai Xoiteue mupo xusi ouwopina xakuai!’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kire Yuta nikau arikepi yause xosa Yesusue kire Parisi nikau tumupo atoro xoye netai. Kakati xiri atineri tuworoteneai. ");
INSERT INTO six_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kire apu, nupo mupokemu kokaipa ore orewotaie Yesusu nutiemu purotai. ");
INSERT INTO six_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesusue pa apu xekerina, tu xotapa sipa apimi xeika Parisi apimi xeika ipaki kotonikina, “Sini Yuta nikau arikepi yause xosa Mosesipo tu xotapa taiwopurenuku apu atinikikiri kutuwopineri itoure, e xuwe?” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kakatia kunawopu xuweuweteneai. Kakeri Yesusue pa apu tina atierati xowotai. ");
INSERT INTO six_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kakerina ipaki kanikina, “Tinipo kire nonore kire pulmakau rau ene nukuro Yuta nikau arikepi yause xosa uraki xowatia, tini sapauni pa nonore pulmakau paiya puruwari xouro mopinare, xuwe?” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kakati ninie kuna xapa teruwopineri itou xuwexeteneai. ");
INSERT INTO six_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesusue apu xoye xosa koteneai xekenikatia, tumauropu sai xosa misepure xeteneai. Kakeri kire xonu kuna tiniketai. Ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kire apue yainati xui tepi xoye xosa xounauwa kaki xanau tumauropu sai xosa miseu. Pa sai paiya neu wenini emeseriwotai apure iyareteneairau. ");
INSERT INTO six_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kakauwa, sewai yainetai apue manapa ipaki kanepina, ‘Ne pa tumauropu sai mua apu tuwo,’ nepina. Kakatia kokai maya mayarinauwa xuriseni kutu xou misewai. ");
INSERT INTO six_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pa xati kire apue yainati xoye nepu xounauwa, xou xuriseni kutu mise. Pa kakauweye, yainetai apue ma kaninapa, ‘Emei, ne manau tumauropu sai xosa mise,’ nepina. Nue pa kakatia, ne xeika xoye neteneai apu ekinikiro wenini tuku sayewai. ");
INSERT INTO six_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Apue nukou wenumuni xourorina paiya, Xoiteue touwepina. Pana apue nukou wenumu ororina paiya, Xoiteue wenumu xourorepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesusue nuko xoyeure yauwati kotai apu ipaki kauna, “Ne kire xoye xoyeunauwa, kaki xanau emenimana yainikinau, nakipo xariani kutu yainikinau, wese emenimana xe tuku karainaku apimi yainikinauwou. Sewai yaineri ninipo ata utu xoye nauwa, xoye xapa tinexeni. ");
INSERT INTO six_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xuwe. Ne kokaipa xoye xoyeunauwa, apu xauna, mupuniki xoxi, sieniki xoxi, ekiniki komosi, pa apu teu yainikewai. ");
INSERT INTO six_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Panumu apu teuwa, nini xiyeri ne xoyerinepuworixe. Kakinauwa ne nimaririwowai, pa amure, sewai asinaku apimini kutu xumoki upurei saroria, Xoiteue neu xapa tinepina,” wotai. ");
INSERT INTO six_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kire apu Yesusu xeika xoye netaie pa kuna iyeserina, Yesusu ipaki kauna, “Xui apue Xoiteue xuiapu yakunikirouna yause xosa misineri tupumoru nepineria, nini nimariri wopineri,” xetai. ");
INSERT INTO six_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kakatia Yesusue ipaki kauna, “Kire apue kokaipa xoye xoyewopure, xokupa apu yainiketai. Pa xoye xosa kopinerire. ");
INSERT INTO six_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Xoyewopure iyaretai yause xosa, nupo saina apu xesawati ekime kanikeyai apu xekenikepure xowotai. Xouna muanumu kuna kanikina, ‘Tini kouwa, xokupa sapi itou ireiyetai,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kakati pa xokupa apue kunauneri, ‘Sini xowopukiri xana xuwe,’ xeteneai. Kakerineri kire apue kunauna, ‘Ye kire ou masa isayaiyeitiaina, xouneia xekopine. Kakepinena ye utopi xana xuweni kutu,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kakati kirei kunauna, ‘Ye pulmakau 10-teu saina tepure isayaiyeitiaina, saina xosa eruru nikepure xowopure. Kakepinena ye utopi xana xuwe,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kireipa kunauna, ‘Ye mukatie xui titiai. Pa xati ye utopi xana xuwe,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kakeri saina apue ninipo kuna nupo kokaipa apu xosa tina xiyeri xowotai. Kokaipa apue pa kuna iyeseri kisamaira wati nupo saina apu ipaki kauna, ‘Ne sapauni xounau mua erewesepu xokupa kokaipa imeyau xeika xayaka imeyau xeika texinau, apimi xauna, mupuniki xoxi xeki, ekiniki komosi, sianiki xoxi xeki, sonikinau yeu atoro kouwo,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kakati saina apue kakieina, kauna, ‘Kokaipa apu, naki kunautiai sie kakitiaina pana ata koxati xana xuwe,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kakati kokai apue saina apu kauna, ‘Ne erewese weti kokaipa imeyau xounau sainapu sepuri tainau xuiapu xekenikinauwa, sokisoki kuna kanikau yeu xoye xosa kopineri. Yeu ata xokope xepinaure xine wotai. ");
INSERT INTO six_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ye tini katikine, pa apu teu yei ekime yainikiaia, nini xakusu yeu kire misiara xoye maisa tepuworixe,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kokaipa xuiapu teue Yesusu nuko xeika xoupurineri, pirixina ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Apue ye xosa mana paiya, nu aini yeu tataiyepi xepuwati xana xuwe. Paxati nupo omo ana, xui, nono xeika momuko xeika, ukomana, xataumana, nini nike tinikinapa pani nukoure rania nike tuna ye xoukemuni kutu siepina. ");
INSERT INTO six_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Apue nupo na nikitoto xemena taiyepu xuweuna paiya, nu yeu tataiyepi puropu watixe. ");
INSERT INTO six_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kire tini xopuropue sapi yakuna xekeu puropure ata mena titi xuwopure xinapa, ye amukau xei mua ata sarepine rau xinapa ati nanunanu tepina. Mua xei ata xuweyepinere, xuwere xina sipawopure kakepina. ");
INSERT INTO six_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nu ximuximu pa kakepu xuweuni, aini simeni iyarina ata xuweiyepu xuweuna paiya, apue xekeuneria pirewopineri. ");
INSERT INTO six_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kunauneria, ‘Mua apu ata aini monimonikerina xuweiyepu xuweuna,’ xepineri. ");
INSERT INTO six_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kire kokemue kire kokemu xeika xoma xepurepa, nu misina ati nanunanu tepina. Nu xomatua 10 ariwaka tuku xati, kire kokemu nu 20 ariwaka xomatua tukue kounarau. Pa xati nu kire kokemu xeika xomaxinapa ikoini ouwopinere, xuwere? xepina. ");
INSERT INTO six_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nu nanuwati itou xuwe xatia, nupo xiwai xetauro puratiporoni, apu xesanikati, xoma weti xokumo tuwata xepineri kuna ti xowopineri. ");
INSERT INTO six_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Panumu sie, kire tini xopuropue nupo xokupa sapire nike tuwopu xuweuna paiya, nu yeu tataiyepi puropu watixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesusue pani ipaki kunauna, “Iwapa asinaku sapi. Pana nupo somu xuweiroatia, sini amu amakikiri xiyeri somu i xepinana? ");
INSERT INTO six_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Panumu iwapa sainoropu xoye kaumu tuwopuwatixe. Pa xeika pulmakaupo sine xeika panakunuku sainoro soxepuxe. Xuwe. Ai xesauweirounuku. Apu xaku tukuwa mua kuna iyesepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Xe titi apu teu xeika xunu erirouneri apu teu xeikae Yesusupo kuna iyesepure nutiemu moteneai. ");
INSERT INTO six_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kakeri Parisi apimi xeika tu xotapa sipa apimi xeikae ipaki makauneri, “Mua apue, xunu erirouneri apu xeika lixina nini xeika xoye nirouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kakeri Yesusue mua xonu kuna tinikina, ");
INSERT INTO six_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kire tini xopuropue 100 sipsipu tuku, kire xautatia, 99 sipsipu weinikitati kirero pure nipuropinerirau. Kakeria nuko xounapa kireni sipsipu xautetai xirekina xekopina. ");
INSERT INTO six_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tina paiya, xaurauro xemerina nimariripa xina wesa xiyeri kopina. ");
INSERT INTO six_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nukou atoro putaunapa, emeumana yainikina wese emeumana yainikina watia, kou kununuwopineri. Kakeria kanikepina, ‘Tini ye xeika nimariri wopu! Yeu kire sipsipu xautetai xirekine xiyeri titiai!’ ” xepina. ");
INSERT INTO six_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesusue pani kanikina, “Ye kutuni katikine, mena xouro kire apu xunu erirounae xou pirixatia, muanumu nutupipi misepini misirouneri. Suwau, 99 apimi nini merukieteneaire nimaririrouneri, amukati, nini xoniki pirixepineri saina xuwe. Pana kire apu, nu xunu erirounae xou pirixatia, kokaipa nimaririni kutu nimaririrouneri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesusue pani ipaki kunauna, “Kire xui nu xe kireni poka tuku, paiya 10-teu memera waxi. Kire xautetaina amakepinana? Naku oi tina atoro inaina kasaunapa ati xirekipa utunaye, nupo xe xiyeri tepina. ");
INSERT INTO six_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Xe memera waxi tina paiya, nupo emeumana xeika wese emeumana xeika yainikatia kou kununuwopineri. Koria kanikepina, ‘Tini ye xeika nimaririwopu! Yeu kire xe memera waxi xautetaina, xirekine xiyeri titiai,’ ” xepina. ");
INSERT INTO six_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kakeri kanikina, “Ye kutuni katikine, kire apu xunu erirounae xou pirixatia, panumu nimaririni Xoiteupo xenikorokoroe nimaririrouneri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesusue pani kunauna, “Kire apu nu sawai nono aimore tuku. ");
INSERT INTO six_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Xurisepue omo ipaki kauna, ‘Xauwa, ye awaino xokupa sapi uteiyerisikepure xitiaire nanune. Kireira xuru masapa yeuna, ximineni sie,’ wotai. Kakati eminikie nupo xokupa sapi uteiyerinietai. ");
INSERT INTO six_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xekepu yause xowopu xuweuni, pa nono xurisepue nupo xokupa xuru kunununa kire xetauro wese xuru xowotai. Pa wese utu purina, xoxixoxi poripori kapia kaki purina, nupo xuru xokupa xuweiyetai. ");
INSERT INTO six_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nupo xuru xokupa xuweiroatia, pa wese kokaipa mause motai. Kakati nu xuru xuweu purotai. ");
INSERT INTO six_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kakina kire apu pa wesepu xosa xona saina tetai. Pa apue xesawati nupo pu sepuri yakuwopinaure xowotai. ");
INSERT INTO six_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pue papai samu neri kamereuwati kireu tina nati xukawopinaure nepure xetai. Nu kaki puratia, kire apuarae xoye turouwatixe. ");
INSERT INTO six_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Xurise asinaku nanunau teri, kunauna, ‘Yeu xauwapu xokupa saina apu nini xokupa xoye tuku. Ye muoro iria xuweu purine xumopure xine. ");
INSERT INTO six_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Xeuxana, ye sanei xauwa xiyeri xouyewopine.’ Utu kauneia, ‘Xauwa ye tini Xoiteuno tiau ekitikiro xunu eritiai. ");
INSERT INTO six_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ye asinaku apu xati yeu nono yewaixe. Ye weitau neu kire saina apu sie puri,’ ” xepina. ");
INSERT INTO six_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kakeri sana omo xosa xowotai. “Utatia, omoe xetaureini koati xekotai. Xekeri xiri xou suawotai. Kakeri keikei mana, nirau xonikina uritoko wotai. ");
INSERT INTO six_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kakati nirauwe omo ipaki kauna, ‘Xauwa ye tini Xoiteuno tiau ekitikiro xunu eritiai. Ye asinaku apu xati, ne yeu nono yewaixe,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kaketa sorena, omoe nupo saina apu yainikati mori ipaki kanikina, ‘Tini ikou akereki nekei asinakuni kutu sapauni timanari takereruworinari, kire saia tinari xupo waxiro erereruwa. Kakerinari erieri siauro erereruwa. ");
INSERT INTO six_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kakerinaria xona pulmakau peri xoroka timanari ouweyari, misinuku nimariri xoye nepu. ");
INSERT INTO six_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pa amure, yeu mua nono xumurotai sorena, xiyeri ekeoma purina. Nu xuwexetai sorena, xiyeri sounuku,’ xetai. Kakeri misineri kokaipa xoye nineri nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pa yausepa asawapu nono nu sainoro purotai. Purotaie xiyeri kouna, ina samuro manatia, xuiapue akise ouneri liawori iyesetai. ");
INSERT INTO six_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kakeri kire saina apu yauwori kotouna, ‘Amakinerina?’ wotai. ");
INSERT INTO six_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kakati saina apue kauna, ‘Xameyanie asinakuni xiyeri koati eminie xekeri nimaririeina, pulmakau peri xoroka ouwotai,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Asawapu nonoe pa kuna iyeserina, kisamaira wati atoro manepu xirexetai. Kakati omoe kisau mana kisa tina nirawotai. ");
INSERT INTO six_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kaketa sorena, nirauwe xiyeri kuna xapa kauna, ‘Pa amakatina? Xokupa xitosani ye neu aipu saina apu siei irereine neu saina titiai. Ye neu kuna seki eriroui xana xuwe. Xakusu kire yause kire meme ara siau yeu emeimanapu nimaririnuku misepu xuwe. Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Neu pa nono paiye, neu xokupa xuru xui ayaka tua xosaniki xuweiyetai. Kakerina mua xiyeri koati, nu xeika misepure pulmakau peri xoroka oune,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kakati omoe ipaki kauna, ‘Nono, xokupa yause ne ye xeika puritiaina, yeu xokupa sapia neu. ");
INSERT INTO six_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pana muaiya nimaririnuku, xosikikemu asinaku xepu, amure xameyani xumurotaina, xiyeri ekeoma eri purina. Xautetaina, pana mua xiyeri sounuku,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesusue nupo tataiwopi ipaki kanikina, “Kire apu karainaku nu saina yayaku tuku. Kireu apimie maneri nupo saina apu kuna xosau suneri, ‘Neu saina yayakue neu sapi aini xuwexina,’ woteneai. ");
INSERT INTO six_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kakeri karainakue nupo saina yayaku yauwati moatia kauna, ‘Neu kapiaure ye kuna iyesitiaia ama? Ne xounau yeu xokupa saina neu xupuniro purotaire kire nakau xayawo. Ne pani yeu saina yayaku purowaixe,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kakati pa saina yayakue nukoni kunauna, ‘Ye amu amakepinena? Tumue ye xesaiyepinarau. Ye kire apupo saina apu xinei nupo ou porowopine sokisoki xuwe. Ye kireu apue xe siepinerire kotonikepi mayaxine. ");
INSERT INTO six_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pa xati ye amu amakepine ye sipa, kokai apue tumu saina titiai pa xesayatia, apue ninipo atoro soi xowopineri,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kakerina nupo kokaipa apu xosa xuru xapa teniai yainikati kireni kireni maiyewoteneai. Kire apue akeri moati, saina yayakue kotouna, ‘Ne yeu kokaipa apu xosa amukau xapa titiaina?’ ");
INSERT INTO six_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kakati nue kauna, ‘100 orip xona suma,’ xetai. Kakati saina yayakue kauna, ‘Nupo xuru ne xosa xapa purotai, nakau xosa xayawoteneai muai, tinau misirou sapauni 50 xayare,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Xurise kire apue moati, saina yayakue kotouna, ‘Neu xapa amukauna?’ wotai. Kakati kunauna ‘100 wit ari,’ wotai. Kakati saina yayakue kauna, ‘Nupo xuru ne xosa xapa purotai, nakau xosa xayareteneai muai, tinau 80 xayare,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Xurise, kokai apue nupo saina apue kapia xoxi kaketai sipari, pa saina yayakupo wenumu xiri xouroretai, amure, apu nanunanu tukue kakiewotai. Apue mua ouropu kapia tairouneria, nini xokupa xonuxonu kapia taineri ninipo saina tineri, apu asinaku memeremu kapia taiwoteneai oronikineri. ");
INSERT INTO six_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ye tini katikine, mua ouropu xe xoxi paiye xuiapu marounikinari ememeinika. Xurise, pa xe tipurikiriai yause xuwe xatia, ata yau sotiki xoworia sipesisipesi asinaku purakuai. ");
INSERT INTO six_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kire apue misiarara sapi xouwenisuna ati yakurouna xatia, nu kokaipa xuru rania ati yakuwopina. Apue sapi misiarara xosa asinaku kapia kakepu xuweuna paiya, nu kokaipa xuru rania asinaku kapia kakepu watixe. ");
INSERT INTO six_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tini mua ouropu xe xoxi ati yakuwopu xuweurounuku xatia, yue sapini kutu yakuwakuaire tikepinana? ");
INSERT INTO six_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tini kireu apu nikau xuru ati yakuwopu xuweunaria, yue takipo xuruni tikepinana? ");
INSERT INTO six_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kire saina apue aimore tumu irue puropu watixe. Nu kire xouweunapa kireure xoukemu xoxi xepina. Kireure xinapa kireure xepu watixe. Kirepu kuna iyesinapa kire nike tuwopina. Tini Xoiteu irue purinari xeure xeika purakuaixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi apimie xe xonikieurouneri, pa xati pa xokupa kuna Yesusue kunawotai iyesineri pirewoteneai. ");
INSERT INTO six_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kakeri ipaki kanikina, “Tini paiya apue nanuneria, tini asinaku kapia kireni kakirounuku patikepineri xinuku. Pana tinipo kapia xotikiro ximiaki purotai paiya Xoiteu nu sipa. Apue xoxi kapia asinaku kapiani kutu xeteneaia, Xoiteu ekeropa xiri kapia xoxini kutu. ");
INSERT INTO six_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tu xotapapu kuna xeika kunatureture nikau xeikapa ekimeni puroyai, pani kouna kouna Yonipo yause xosa xetai. Yonipo yause xosa Xoiteue xuiapu yakunikirouna yause xosa asinaku kuna xokupa wese wese puputawotai. Kakati xokupa apue pa Xoiteue xuiapu yakunikirouna xopuro manepure xiri sokisoki xineri. ");
INSERT INTO six_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Mena xeika ou xeika paiya xuwexepina. Pana Xoiteupo tu xotapu kuna paiya xakusu kire kuna masa ara xuwe xepuwatixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesusue pani kunauna, “Amu apue rau nupo xui wetina kire xui tinapa, nu ayaka kapia tina. Kire apue kire xui ekime xamue weteyai tina rania, ayaka kapia tina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesusue pani ipaki kunauna, “Ekime kire karainakue purina nue mupuropu asinaku asinaku nekei xeika nekei ewou teketekewoki xosei kokaipa xei isaya xeki xeika erina asinaku asinaku xoye nirouna. ");
INSERT INTO six_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Nupo ata isima tomuro kire apu xaunae purirouna. Pa apupo wenumu Lasarus, Lasarusue pa karainakupo sai iruworopu xoye maisa kiririwotai tina nepurexirouna. Usi xaria purorowokie nikeyau koxati, mamue maneri minonikie meraruwoteneai. ");
INSERT INTO six_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Xurise pa apu xaunae xumati, xenikorokoroe xeme xouneri Apraxamu xeika iyareri purotai. Pa apu karainaku rania xumati, upuareteneai. ");
INSERT INTO six_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nu xumoki nikau wese kokaipa tatau tuku purina. Xouro eisauna xekoatia Apraxamue xetauroni kutu purati, Lasarusue nu xeika purotai. ");
INSERT INTO six_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kakati karainakue ipaki yaxina, ‘Xauwa Apraxamu, ne yeure xonsua xinau Lasarus kawau xupo waxiro ene kopu ti mana minoikemuro iyarati xayakaxayaka urukepina. Ye mua xepiro puritia xiri xoi poru itina,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Kakati Apraxamue kunauna, ‘Nono, ne nakipo kapia nanuwo. Ne ekinioma puriai yause, nakie xokupa asinaku sapi tiai. Kakau Lasarusue xokupa sapi xoxi teyai. Nu ximine mua wese xosa, xoukemu asinaku purina. Kakati ne tatau xoxi tine. ");
INSERT INTO six_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kire kuna rania kanine. Sini xeika tini xeika xopua Xoiteue kire kokaipa xupiou iyarati opokaineri tini xosa xonopineri sie itou xuwe. Pira puroteneai apue xupiou opokaineri sini xosa mopuworixe.’ ");
INSERT INTO six_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kakati karainakue kunauna, ‘Panumu xatia, xauwa, ye kotonine, ne Lasarus xesawau yeu xauwapu atoro xowopina. ");
INSERT INTO six_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yeu xaria 5-teu tenemai nono emisiki kireni xosaupo purineri, Lasarusue sokisoki kuna kanikatiporo ninipo xoxixoxi kapia kutuwopineri. Nini rania mua wese kouxaneri kokaipa tatau texeni.’ ");
INSERT INTO six_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kakati Apraxamue kunauna, ‘Mosesipo kuna xeika kunatureture nikau kuna xeika purina. Nini pa xosa xakuniki iyarepineri.’ ");
INSERT INTO six_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kakati karainakue kunauna, ‘Xauwa Apraxamu, xuwe. Pa itou xuwe. Kire apu xumotaie kopa upurei sarouna utuyenikati paiyeye, nini xoniki pirixepineri.’ ");
INSERT INTO six_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Kakati Apraxamue ipaki kauna, ‘Nini Mosesipo kuna xeika kunatureture nikau kuna xeika iyesepu xuweurouneri xatia, kire apue kopa upurei xiyeri sarouna utuyenikati rania nini xonikisuwopuworixe,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusue nupo tataiwopi ipaki kanikina, “Xuiapue xunu xerepinerire xokupa sapie eruru nikepure mopina, pana yuerau xunu xosa eruru niketai paiya, nini xiri xoxi xepineri. ");
INSERT INTO six_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nue kakati mua nonomi xopuropu kire nono xunu xosa titikiri xatia, xeuxana kire xe wauro kokaini kutu parukanaro tarineri xasi nukuro otuwori xouna xumopina. Paire tini ati sosopa epixakuai. ");
INSERT INTO six_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Xatanie xunu eratia, kawau nupo kapia xoxi kutuwopina. Nupo xoukemu pirixatia, nupo xunu weteruwowai. ");
INSERT INTO six_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nue ne xosa xoxixoxi kapia kireni asauni kakipa utu 7-teu yause rina, 7-teu yause xiyeri ma kanina, ‘Ye xoi suaxati xoi pirixine xatia,’ nupo xunu weteruwowai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tianuwopie Kokaipa ipaki kauneri, “Ne sinipo xosikisuwopi kapia pani kokaipare,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kakeri Kokaipae ipaki kanikina, “Tinipo xotikisuwopi paiya, sani mastet waxi sie xiri misiara rania tini mua kokaipa na kaunari, ‘Ne porureini siraronau xasi xosa xou tumu puro xaria,’ pa nae tinipo kuna taiwopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesusue pani ipaki kunauna, “Kire apu tini xopuropue saina apu kawati xou ou porowopinare e xou sipsipu yakunikepina, pa saina apue atoro xiyeri koatia, nupo kokai apue kauna, ‘Ne sapauni ma misinau xoye ne wopinare?’ ");
INSERT INTO six_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Xuwe. Kokai apue ipaki kaunapa, ‘Ne yeu xoye xoyerinau, xoye worowai nekei nekeiyerinau xoye wa timanau sie. Ye xoye nieine ene nieiti paiye, xurise ne xoye ninau ene ne,’ xepina. ");
INSERT INTO six_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Saina apue nupo kuna supo taina kakatia, kokai apue saina apu eiyase wopinare? Xuwe. ");
INSERT INTO six_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pa xati tini rania, Xoiteue katiketai sie xokupa saina tieikiriai xatia, kunaunaria, ‘Sini asinaku saina apu xuwe. Sini saina tikiriai saina paiya, ai Xoiteue siketai saina tikiriai,’ ” xakuai. ");
INSERT INTO six_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesusue Yerusalemu ime tai xoupopouna, Samaria Tistrik xeika Kalili Tistrik xeika ou tumarei xowotai. ");
INSERT INTO six_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kire wese putawatia, 10-teu apimi lilies supa tukue maneri imero tutumawoteneai. Xetaureini tumuneri, ");
INSERT INTO six_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ipaki uru yauneri, “Yesusu, Kokai Apu, ne sinire xoni suaxe,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kakeri Yesusue xekenikeri, ipaki kanikina, “Tini xounari tinipo muputiki xuriatiti atarinika,” niketai. Kakati xoworia, ninipo mupuniki asinakuwati lilies supa xuwexetai. ");
INSERT INTO six_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kire apu nini xopuropue nupo mupokemu asinaku xati xekerina, xiyeri xoupopouna ere urue Xoiteupo wenumu xouroretai. ");
INSERT INTO six_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesusu xosa utu putarina xoutapa ukurou Yesusu nutiemu siau sakaro tutukina Yesusu eiyase wotai. Pa apua nu Samariapu. ");
INSERT INTO six_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesusue pa apu xekeri, kunauna, “10-teu apimi ninipo lilies supa xuweiroati meruketeneai. Pana kireu 9-teu apua anoro purinerina? ");
INSERT INTO six_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Xiyeri kouneri Xoiteu wenumu xourorepineri apu xuwere? Mua apu nu kire sanawapu, nu kireni re?” xetai. ");
INSERT INTO six_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kakerina Yesusue pa apu kauna, “Ne sarounau xouwo. Nakipo xonisue ne xiyeri asinaku xitiai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi apimie Yesusu ipaki kotouneri, “Anakise Xoiteupo Xoiteue xuiapu yakunikirouna yause xosa kopinana?” woteneai. Kakeri Yesusue kuna kanikina, “Xoiteupo Xoiteue xuiapu yakunikirouna yause xosa kopinapa xuiapue xekeuneri sipawopineri imerei kopuwatixe. ");
INSERT INTO six_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nini xekeri kunauneri, ‘Xekoa, nu mua purina,’ xepinerire ‘Nu pia purina xepuworixe?’ Iyesa. Xoiteupo Xoiteue xuiapu yakunikirouna yause paiya taki xopu purina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesusue nupo tataiwopi kanikina, “Sewai xurise yause xosa, tinie Apupo Nonopu kire yause xekopureni kutu xakuai. Pana tini xekoakuaixe. ");
INSERT INTO six_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ipaki katikineria, ‘Xekoa nu pia purina,’ pare ‘Xekoa mua purina,’ xepineri. Tini kaki xanari xou nini tainikaku. ");
INSERT INTO six_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tini sipa, xore lei xatia mena xourei, pa memeremue muira u tina kireira xourouna. Apupo Nonoe koupurina panumu kakatia, xokupa xuiapue xekopineri. ");
INSERT INTO six_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nu xokupa tatau xemeyati paiyeye, mua yausepu apue nikiniki tuwopineri. ");
INSERT INTO six_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noapu yause xosa panumu kapia kakeniai, panumu kapiani Apupo Nono kopure xatia kakepineri. ");
INSERT INTO six_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noapu yause xosa xoye nineri ene nineri, xuiapu tiwata xeneai, kakipa utuneri Noae kokouna minika maneyai. Kakati kokaipa xuyaie mana xokupa xuiapu xuweinikieyai. ");
INSERT INTO six_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lotipo yause xosa rania xuiapue panumu kapiani kakeniai. Nini xoye nineri ene nineri, xuru xesauneri isayauneri, saina erineri ata xuxuneri pa kapia kapia tipuroniai. ");
INSERT INTO six_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kakeri Lotie Sotomu wetina xowati, pa yauseni ene sie xepi xeika xepiropu xe xeikae mena xourei kouna xuiapu xuweinikieyai. ");
INSERT INTO six_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Apupo Nono yara putawopina yause xosa panumu kapiani kakepina. ");
INSERT INTO six_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Pa yause xosa kire apue ata tupauro purati, nupo xuru ata kamoro puratia, nu kaki xana nupo xuru muna texete. Panumu sie, apue sainaro purokie, atoro xiyeri xowoxete. ");
INSERT INTO six_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tini Lotipo xui xosa kapia akipa xeyai nanuwa. ");
INSERT INTO six_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kire apue nukou puropi suini soki tepure xina paiya, nupo ekeoma puropi xuwexepina. Pana kire apue nukou puropi sui wetina paiya, nupo ekeoma puropi ati puropina. ");
INSERT INTO six_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ye katikine, ukumani Apupo Nono koati aimore xuiapue kireni suwariro xini puroria, Xoiteue kire tina kire wetatia puropina. ");
INSERT INTO six_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Aimore xuie tupumorupo wit punupunu tou puroria, Xoiteue kire xui tina kire wetatia puropina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesusupo tataiwopie pa kuna iyeserineri Yesusu ipaki kotouneri, “Kokaipa, anoro pa kapia akipa xepinerina?” woteneai. Kakeri Yesusue ipaki kanikina, “Sapi xumoki seke moupu xini puroteneairo, pa iriro kireni xunouwe kou kununurouneri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesusue nupo tataiwopi ouye xuweu xokupa yause kunikuniwopinerire kire xonu kuna tiniketai. ");
INSERT INTO six_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ipaki kunauna, “Kire erewese xosa, kire kuna uteitua purotai. Pa kuna uteitua nu Xoiteu ximikuna apure rania xekepu nanunikirouwatixe. ");
INSERT INTO six_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kire xui oyemasie pa erewese purotai. Xokupa yause pa kuna uteitua xosa kou kauna, ‘Yeu xiwaie ye kuna xosa yaiyerepure xinana, nei kuna tianie,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ximuximua pa kuna uteituae pa xui tianuwopi xirexetai. Xurise ipaki nanuna, ‘Ye Xoiteure ximiki xana xuwe, apure xekepu nanunanuti xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pana pa xui oyemasie, xokupa yause xu sirouna. Xeuxana ye kuna xosa tianuwopine. Xokupa yause korikori wati, nupo kuna iyesepi xirexekini,’ ” xetai. ");
INSERT INTO six_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kokaipae pani ipaki kunauna, “Tini mua kuna uteitua xoxipo kuna iyesa. ");
INSERT INTO six_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pa ama? Xoiteue xuiapu ikou niketaie xokupa yause asau ukumu nure murinerina, Xoiteue sapauni kuna tianikepuwati xana xuwere? Nu sapauni tianikepu xuweuwopinare? Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ye katikine, nu sapauni kuna xosa tianikepina. Pana Apupo Nono kouna paiya, ouro puroteneai xuiapu xonikisunerire, xuwerau xina xekenikepina?” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kireu apue nanuneri siko kireni apu kutu asinakuna kireua siko sie xuwe xineri. Yesusue panumu apure xonu kuna tinikina, ");
INSERT INTO six_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Aimore apue kunikuniwopure, Xoiteupo ata tumau xowoteneai. Kire Parisipona kire kapmanipo xe titie. ");
INSERT INTO six_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi apua xetauni tumurouna nukoure paru meikarei ipaki kunikunina, ‘Xoiteu, ye kireu apu sie xuwe, pa xati ye ne eiyasenine. Ninie pexineri xoxixoxi kapia kakineri xui apu tuku xosa esiesirouneri. Ye paiya xuwe. Ye paiya pa apu xe titi sie xuwe. ");
INSERT INTO six_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Xokupa muris ye aimore asau xoye xurikepure iyariroune. Xokupa sapi tinepa, uteine 10 teuworine kireni teupu ne tiniroune,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Xe titi apua xetauro tumu purina, mena xouro eisawopi xirexetai. Xuwe. Ai totomu ou puri kunauna, ‘Xoiteu, ye xunu tua. Nei ye xonisuaye,’ ” xetai. ");
INSERT INTO six_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesusue kunauna, “Ye tini katikine, pa xe titi apue nukou atoro xiyeri xouna, nu kirenie Xoiteu ekero asinaku apu xetai. Pana kire apu paiya nu xuwe. Pa amure, xokupa apue nikou weninikini xouroreria, Xoiteue weniniki ororepina. Xokupa apue weniniki ororeria, Xoiteue weniniki xourorepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesusue xupo xosaniki iyarepinaure, xuiapue nonomi momukomi misiarara sonikineri Yesusu xosa koteneai. Kakeri Yesusupo tataiwopie xekenikeri, xuiapu auniketeneai. ");
INSERT INTO six_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesusue nonomi momukomi arara yainikati nutiemu mori, nupo tataiwopi kanikina, “Tini nonomi momukomi arara weinikitari iko xosa kouwa. Tini kaki xanari taiyerinikaku. Xoiteue yakunikepina xuiapu tutu xosa paiya nini muanumu nonomi momukomi arara sie apu nikau. ");
INSERT INTO six_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ye suwauni kutu katikine, nonomie tirouneri sie, kire apue Xoiteue yakuwotai xuiapu tutu tepu xuweu paiya nu pa xosa manepuwatixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kire tumue Yesusu ipaki kotouna, “Asinaku xesixesi, ye amakinei asinaku ekioma sipesi sipesi tipuropinena?” xetai. ");
INSERT INTO six_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kakati Yesusue ipaki kauna, “Ne amakati ye asinaku xinena? Xoiteu kireni nu asinaku. ");
INSERT INTO six_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne Xoiteupo tu xotapapu kuna sipa, ‘Tini xuiapu tiwata xeki, kaki xanari ayaka kapia kakaku. Tini kaki xanari xuiapu ounikiaku. Tini kaki xanari pexaku. Tini kaki xanari xoreiyeri kireu xuiapu kuna xosa soinikaku. Tini emitikimana anitikimana irue purinari, ninipo kuna tainari, ninipo weniniki xourorinari, tianiketewa,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kakati pa tumue kunauna, “Ye nonoini pa xokupa tu tai koune apuxine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesusue pa kuna iyeseri, tumu ipaki kauna, “Ne kire sapire tokou xine. Neu xokupa sapi xesaunau, xe xokupa tinau xauna xuiapu utei tinike. Ne pa kakinauwa, ne mena xouro asinaku xuruni tuku xewai. Kakerinau ma taiye,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pa tumu nu xokupa xuru kutu xati, pa kuna iyeserina xoukemu xiri xoxixoxi xetai. ");
INSERT INTO six_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pa tumue xoukemu xoxixoxi xati Yesusue xekeri ipaki kunauna, “Apu xokupa xuru tukua nini Xoiteue yakunikepina xuiapu tutu xosa manepure irereiwopineri. ");
INSERT INTO six_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelie nekei tatamaxepu kotou yeisiro manepure paiya, nu karainakue Xoiteue yakunikepina xuiapu tutu xosa manepure irerei wopina sie xuwe,” xetai. ");
INSERT INTO six_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Apue pa kuna iyeseri ipaki kunauneri, “Panumu xatia, yue sipesisipesi ekeoma asinaku puropi tepinana?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kakeri Yesusue kunauna, “Apue kakepu xuweuwopina sapia, Xoiteue kakepina itou,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kakati Pitae ipaki kunauna, “Iyese. Sinipo wese xeika xokupa sapi xeika wetinuku, ne taininuku,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kakati Yesusue ipaki kanikina, “Ye suwauni kutu katikine, xokupa apue Xoiteue xuiapu yakunikepina yauseure nanuneri ata wetineri, xui wetineri, xatanikimana weinikiterineri, eminikimana aninikimana weinikiterineri, nono weinikiterineri koteneaia, ");
INSERT INTO six_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nini mua ouro puroriporoni, ekime teneai xuru Xoiteue emeserina xokupa xuruni kutu tinikepina. Sewai xurise yause, moatia, nini sipesisipesi ekinikioma asinaku puropineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesusue 12-teu tataiwopi soniki xona ipaki kanikina, “Iyesa. Ximine Yerusalemu xounuku. Xokupa kuna ekime kunatureturei xayauneri, Apupo Nono xosa kapia yaraxepina xeniai, ximine suwauni kutu yaraxepina. ");
INSERT INTO six_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kireu apimie xetau apu teu xupunikiro tinikepineri. Kakeria pireuneri xoxixoxiuneria si xosau orowopineri. ");
INSERT INTO six_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kakineri kasieineria ouwepineri. Kakeria asau xoka 3 xosa saropina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kakati Yesusupo tataiwopie pa kuna xotapa sipawopu xuwe. Kuna xotapa ximiaki purati, nue kunawotai kuna sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesusue Yeriko erewese tomuro moatia, kire apu eke sauwe ime maro misi purina xuiapu xeureara kotoniketai. ");
INSERT INTO six_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Xokupa xuiapue kori iyeseri, kotoninikina, “Nini amakinerina?” niketai. ");
INSERT INTO six_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kakati kauneri, “Nasaretipo Yesusue emeserisikina,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kakeri pa eke sauwe ipaki yaxina, “Yesusu, ne Tepitipo Yasiyasi, ne yeureni kutu xonisuaxe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Apu akeri moteneaie ipaki aupuri kauneri, “Ne yourowo,” woteneai. Kakeria pani ere urue ipaki yaxina, “Ne Tepitipo Yasiyasi, ne yearaureni kutu xonisuaxe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kakati Yesusue ma tumurouna pa apu sou mouwa niketai. Pa apu eke sauwe nutiemu maiyewati, Yesusue ipaki kotouna, ");
INSERT INTO six_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Yei ne amakinepinena?” wotai. Kakati kauna, “Kokaipa, ye eki pereu xekopure,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kakati Yesusue kauna, “Neu ekini pereuna itou xepina, nakipo xonisue itou xine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kakati sapauni eke pereuweina, Yesusu tai xouna Xoiteupo wenumu xouroretai. Xokupa xuiapue pa kapia xekerineri, ninie rania Xoiteupo wenumu xouroreteneai. ");
INSERT INTO six_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusue Yeriko erewese mana erewese wetepure suesueni ime taiwotai. ");
INSERT INTO six_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kire apue pa erewese purotai, nupo wenumu Sakiusi. Nu xe titinikau akereki tumu, nu xe xokupa tuku. ");
INSERT INTO six_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesusu nu amukau apurau xi xekopure xetaina, xokupa xuiapue koitauwori, Sakiusi nu apu tokouara xati Yesusu xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kakeri nue akeri keikei xouna, Yesusu xekopinaure kire na kupari xouro manetai. Nu sipa, Yesusu pa imerei mopina xati kaketai. ");
INSERT INTO six_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusue pa imerei mana, pa na xouro eisau puri Sakiusi ipaki kauna, “Sakiusi, ne sapauni oro mouwo. Ye ximine neu atoro puropine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kakati Sakiusie sapauni oro mana, xoukemu nimaririei Yesusu nupo atoro sou xowotai. ");
INSERT INTO six_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xokupa apue xekeri, ipaki kenakenarei kunauneri, “Nu xunu erirouna apupo atoro xou purina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nini atoro xou purineria Sakiusie sarouna, Kokaipa ipaki kauna, “Kokaipa, ne iyese. Ximine yeu xokupa xuru uteinei aimore teuworineia, kireira xuru paiya xousua tuku xauna apimi tinikepine. Ye kire apu xoreuwori nupo kire sapi perei tiai xatia, ye xapa sapi surup teu tuwopine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kakati Yesusue ipaki kauna, “Ximine Xoiteue mua atoropu xuiapu xiyeri tinikietai. Pa apu rania nu Apraxamupo yasiyasi. ");
INSERT INTO six_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Apupo Nonoe, apu xuwexeteneai xirekinikina xiyeri tinikepure kotai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesusue kunau purati, xuiapue nupo kuna iyeseri, kire xonu kuna rania kaniketai, pa amure, nu Yerusalemu tomuro putawati nanuneri, Xoiteu xuiapu yakunikepina yause ximineni yara akipa xepina xeteneai. ");
INSERT INTO six_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesusue ipaki kunauna, “Kire kokai apue kokemu tumuworepinerire kire xetauro wese xowopure xetai. Sewai nukou wese xiyeri kounapa nukou xuiapu yakunikepina. ");
INSERT INTO six_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nu xowopure xina, nupo 10 teu saina apu yainikati mori, xe kireni ariwaka kireni ariwaka xina tiniketai. Kakeri ipaki kanikina, ‘Tini mua xe tinari paiye saina tipuraria, ye xiyeri kopine,’ niketai. ");
INSERT INTO six_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kakati nupo wese emeumanae nu xiri xirauneri emumuketeneai. Kakineri nu xouratia, kireu apu xesanikeri kokai apu xowotai wese kuna tixowoteneai. Ipaki kunauneria, ‘Sini pa apu sinipo kokemu tumuwopi xiraxinuku,’ xi kanikepineri. ");
INSERT INTO six_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kaketeneai sorena pa apu nu kokemu tumuworeri, xurise xiyeri kotai. Xiyeri korina ipaki kunauna, ‘Ye ekime xe tinikiai saina apu yainika. Nini xe tineri saina teteneai, amukau amukau xe xouro kireni kireni apue teteneai ye sipawopure,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Kakati kire apue akeri mana ipaki kunauna, ‘Kokai apu neu kireni ariwakae saina tine 10-teu ariwaka xe xouro titiai,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kakati kokemue kauna, ‘Ne asinaku saina apu xati, asinaku sainani kutu titiai. Ne pa sapi misiarani kutu ati yakutiai, pa xati nei 10 teu erewese yakuwowaire wenini xouro tinine,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Pani kire saina apue mana, kunauna, ‘Kokaipa apu, neu kireni ariwakae saina tine autapa ariwaka xe titiai,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kakati kokemue kauna, ‘Ne 5-teu erewese yakuwowaire tumunerine,’ wotai. ");
INSERT INTO six_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kire apue paiya ma kauna, ‘Kokai apu, neu kireni ariwaka xe mua purina. Kire mari xaku xosa xotorine iyariti purotai, ");
INSERT INTO six_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","pa amure, ye xekenitia, ne emumutua. Kireu apue iyareri purotai sapi nei tiroune. Kireu apue uyaxeteneai xoye pa rania ne tiroune. Pa xati ye ne ximikinitiai,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kakati kokemue pa saina apu ipaki kauna, ‘Ne saina apu xoxini kutu! Nakipo kunaini ye kuna xosa iyainerepine. Ye ne sipaitiai, ye emumutua, ye kireu apue sapi iyareri puroki tiroune, kireu apue woroki xoye tiroune. ");
INSERT INTO six_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pa xati yeu xe xitamu atoro iyareriyau puratiporo ye xiyeri kounei xe xouro tepine sie itouna ama?’ ");
INSERT INTO six_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kakerina apimi nutiemu tumu puroteneai ipaki kanikina, ‘Tini nu xosaupo kireni ariwaka xe tinari pa apu 10-teu ariwaka xe tuku tuwa,’ xetai. ");
INSERT INTO six_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kakati kuna xiyeri kauneri, ‘Kokaipa apu, nu 10-teu ariwaka xe tuku,’ woteneai. ");
INSERT INTO six_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kakeri nue kanikina, ‘Ye tini katikine, xokupa apu nini kireu xuru tukua, ikoe kireu xuru xousokuworinikepine. Kire apu nu xuru xuweu, paiye xuru misiara tipuratia, ye xesauweruwopine. ");
INSERT INTO six_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pana yeu xiwai teue ye ninipo kokemu puropi xiraxinerina, soniki manari ekiro ounikiari xuma,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesusue pa xonu kuna tinikieina xiyeri teipa xina ime taiti Yerusalemu manetai. ");
INSERT INTO six_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesusue Orip Totou xosa purotai wese Petipake xeika Petani xeika tomuro mana, aimore tataiwopi xesaniki ");
INSERT INTO six_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ipaki kanikina, “Tini esipa pia wese purotai xosa xouwa. Tini pa wese xounaxaria, kire tonki pusopusonaku tuwareri purinana xekoxakuai. Kire apue pa tonki xosa misati xana xuwe. Muri xureiyeinari muoro tikouwa. ");
INSERT INTO six_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kire apue kototikina, ‘Tini amakati mua tonki xurexinuana?’ xatia. Tinie ipaki kuna kaunaxaria, ‘Kokaipa nu saina tuku xakuai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesusue xesaniati xounexeri, kaniketai sie xokupa sapi purati xekoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tonki xosaupo muri xurexepi sainateria, pa tonki xatakue kotonikineri, “Tini amakati mua tonki xurexinuana?” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kakeri ninie kunauneri, “Kokaipa nu saina tuku,” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yesusupo tataiwopi aimorei Yesusu xosa tonki tikouneri, niyou nekei xuwau tonki xouro soxeteneai. Kakerineri Yesusu tianuwori tonki xouro misetai. ");
INSERT INTO six_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesusue tonki xourei misina xowati, xuiapue nikou nekei xuwaxuwau axiri axiri xeki xuxurexineri imero iwapa xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesusue Yerusalemu tomuroni mana Orip Totou wetepi ime munotai. Kakati nupo tataiwopi teue kurauneri mamarika woteneai. Yesusue xokupa xonuxonu kapia kakati xekoteneairo, ere urue yaxineri, Xoiteupo wenumu xouroreteneai. ");
INSERT INTO six_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ipaki yaxineri, “Mua kokemu nu Kokaipapu wenumurei kotai. Xoiteue asinaku kapia nu xosa kakepina. Mena xouro xosikemu yorowopi kapia puratia sini Xoiteupo wenumu Xouroni Kutu xourorepu!” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kireu Parisi apimi kokaipa xuiapu xopu puroteneaie Yesusu ipaki kauneri, “Xesixesi, ne neu tatainepi aunike. Nini panumu kuna kunawopi wetepineri,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kakeri Yesusue xiyeri kanikina, “Tini katikine, nini supuniki paraworia xe teu nikoini uru yaxineri Xoiteu wenumu xourorepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesusue Yerusalemu tomuro mana erewese xekerina xousuwawati morotai. ");
INSERT INTO six_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ipaki kunauna, “Yerusalemu, amu sapie ne xonikemu yoroati purinauwa ximineni ne sipawowaire xine. Pana pa sapia ximiaki purinerina ne xekowai xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne iyese. Xurise kire yause putawati, neu xiwaie maneria neu kokaipa sepuri ou soxineri katowopineri. Kakineri xokupa iri ne xiri koi katonepineri. ");
INSERT INTO six_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kakineria naki xeika naki kamuniro puroteneai nonomi xeika xiri totokitikepineri. Kakinerini neu kire xe weteri, kire xe xouro puropu watixe, pa amure Xoiteue tianinepure kotai yause ne sipawopu xuweuyai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesusue Xoiteupo ata tumau mana apimie xuru xesauneri xe teri xesaniketai. ");
INSERT INTO six_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yesusue ipaki kanikina, “Xoiteupo Nakau xosa mua kuna tuku, ‘Yeu Ata paiya kunikuni wakuai ata puropina.’ Pana tinie petuae ximiakirouneri wese kakieunuku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kakina xokupa asau Xoiteupo ata tumau xuiapu kuna taitainiketai. Kakati ere xuriatiti xuno tu xotapa sipa apimi xuno xuiapu nikau tumu xunae, Yesusu ouwepure ime xireketeneai. ");
INSERT INTO six_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Xokupa xuiapue Yesusupo kuna iyesepi xiri sokisoki xeri, tumu teue Yesusu ouwepineri ime kire xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kire yause Yesusue Xoiteupo ata tumau xuiapu Xoiteupo asinaku kuna uteina uworiniketai. Kakati ere xuriatiti xeika tu xotapa sipa xeika tumu teu xeikae Yesusu maiyewoteneai. ");
INSERT INTO six_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma ipaki kauneri, “Ne sini kasike, ne mua wenini xeika sokisoki xeika anaiseu tine mua kapia kakinena? Yue apu wenini tuku saineretaina?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kakeri nue ipaki kuna xapa kanikina, “Ye rania tini kire sapire kototikepure xine. Tini ye kaya, ");
INSERT INTO six_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yonie xuiapu ene iserinikeyai paiya, mena xouropu sapire, e apu nikau kapia kireni xi nanunuku?” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kakati nikonikoni ipaki kunauneri, “Sini kunaunuku, ‘Paiya mena xouropu sapi xikiria,’ nue kunaunapa, ‘Tini ama nure xotikisuwopuxuweukiriaina xepina?’ ");
INSERT INTO six_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sini kunaunuku, ‘Paiya apu nikau kapia kireni xikiria,’ xokupa apue xe kurusikepineri, pa amure, Yoni nu kunatureture xineri sokisoki xonikisuneri,” xeteneneai. ");
INSERT INTO six_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pa xati Yesusu ipaki kauneri, “Yoni nu anaiseu kapia tina apu ene iseriniketai, sini sipa xuwe,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kakeri Yesusue ipaki kanikina, “Ye rania yuerau sokisoki wenimi siati mua saina tinena, katikepi xana xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesusue xuiapu kire xonu kuna ipaki kanikina, “Kire apue xisa xito eretai. Kakerina kireu apimie xe saina tepure xeteneai xupunikiro pa xisa xito iyaretai. Nukopa xouna kire xetauro wese xuwau yause purotai. ");
INSERT INTO six_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Xisa meru eretai yause xosa kire saina apu xesawati, saina teteneai apimi xosa xouyeniketai. Pa sainoropu kireu xoye tuwopinerire xowotaina pana, pa saina teteneai apimie ouneri aini xesawori xowotai. ");
INSERT INTO six_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kakeri xisa xito xatakue kire saina apu xesawati xouyeniketai. Pa rania ouneri xoxixoxi kapia terineri aini xesawori xowotai. ");
INSERT INTO six_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pani xeimore yauserina kire saina apu xesawati xowotai. Pa rania xiri xoxixoxiuneri kisau xesawori xowotai. ");
INSERT INTO six_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pa xati xisa xito xatakue kunauna, ‘Ye ximine amakepinena? Ye ikou nono xokiai xiri xoiyeutiai, xesauti xowatia, nupo kuna iyeseruwopineri rau.’ ");
INSERT INTO six_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pa saina aini yakuwoteneai apimie nirau koati xekeri nikonikoni ipaki kunauneri, ‘Mua apue omopu xokupa sapi tepina. Ouweikiri xumatia, sikoini mua saina tepu xeteneai.’ ");
INSERT INTO six_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kakerineri saina kisauira xesawori munati, ouweri xumotai, ‘Paina xisa xito xatakue pa apimi amakinikepina xi nanunukuna? ");
INSERT INTO six_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nu manapa saina teteneai apimi ounikiepina. Kakerinapa xisa xito kireu apimi tinikepina,’ niketai. Apimie pa kuna iyeseri kunauneri, ‘Nu panumu kapia kakexete,’ ” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kakeri Yesusue xekeniki puri kunauna, “Pana Xoiteupo nakau xosa mua kuna amakati xayareri purinana, ‘Mua xe ataxuxue nanuneri xoxieri xesawoteneai, ximine ata kisa sokisokiwopina asinaku xeni kutu xina’? ");
INSERT INTO six_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Xokupa apue mua xe xouro uraki kouneria, nini xiri nisinasiepineri. Mua xei kire apu xosa uraki xounapa pa apu xiri nomutouwepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesusue xonu kunairei kuna xosasiki sunarineri, tu xotapa sipa xeika ere xuriatiti xeikaie Yesusu soki tepure xeteneai sorena, xuiapu ximikiniketeneai. ");
INSERT INTO six_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ere xuriatiti xeika tuxotapa sipa apimi xeikae Yesusu ati xeke tataiwoteneai. Kakineri apu xesanikeri tuworopure xowoteneai. Pa apimie kunauneri sini Yesusupo kuna iyesepureni kutu xinuku xineri xorei xeteneai. Akereki ere tumue kuna xosa iyarepinaure, xoreukiri kuna ateratia nu xuporo iyarepinuku xineri, kaketeneai. ");
INSERT INTO six_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yesusu ipaki kotouneri, “Xesixesi, sini sipa, neu kuna paiya asinaku, ne xuiapu asinaku kuna tinikiroune. Apu weniniku tukure weniniki xuweu rania, kireni kunani nei tinikiroune. Ne sokau kunairai kirenie xuiapu Xoiteupo kapia uworinikiroune. ");
INSERT INTO six_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Paina, ne amu xi nanunena? Sini Xoiteupo tu taiwopure xinukua, sini xe tinuku Sisa tuwopure e xuwe?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kakeri Yesusue ninipo xoreixorei kapia sipari kanikina, ");
INSERT INTO six_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kire xe waxi atariya. Mua xeniroroi xeika wenumu xeika xe xosa purotai paiya yupona,” niketai. Kakati ninie kunauneri, “Sisapu,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kakeri ipaki kanikina, “Paina Sisapu sapia, Sisa tuwakuai. Xoiteupo sapi paiya, Xoiteu tuwakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesusue xuiapu xeika purati, kire xoreixorei kunae xoreuwori kuna xosa iyarepineri itou xuwexetai. Ninipo kuna xiyeri kanikati ureri, kuna xuweuweteneai. ");
INSERT INTO six_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kireu Satusi apimie Yesusu xosa koteneai. Satusi apimie kunaurouneri, apu xumokia, xiyeri saropuwori xana xuwe xirouneri. ");
INSERT INTO six_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pa apu teue Yesusu ipaki kauneri, “Xesixesi, Mosesie sikou kire kuna ipaki xayawoyai. Kire apue xui tina sewai nono xuweu xumatia, xameyaue oye tinapa oapu wenumurei ekepos ouwopina. ");
INSERT INTO six_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ekime nono tenemai 7-teu puroniai. Asawapue xui tina nono xuweu xumotai. ");
INSERT INTO six_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kakati asawapu turopue pa oyemasi tetai, ");
INSERT INTO six_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","nu rania xumati kirei xapasi tetai. Pa nono 7-teue pa kireni xui tirou tirouwoniaina, nono xuweu xumuweteneai. ");
INSERT INTO six_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Xurise pa xui rania xumotai. ");
INSERT INTO six_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Paina sewai xurise yause apu xumoki xiyeri saroria, pa xuia yupo xuini kutu puropinana? Ne sipa, apu 7-teue teri ninipo xui xeyai,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kakeri Yesusue ipaki kanikina, “Mua yausepu xuiapu nini tiwata xirouneri. ");
INSERT INTO six_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Xoiteue kunauna, xurise xuiapu xiyeri saneria, ye xeika ekinikioma puropineri xeyai xuiapua nini tiwata xepuworixe, ");
INSERT INTO six_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","pa amure, nini xiyeri xumopuworixe. Nini xenikorokoroe purieuneri. Xoiteue kopaupuropu sainikeretai, pa xati nini Xoiteupo nono purineri. ");
INSERT INTO six_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Apu xumokie xiyeri kopaupurei sarouneri kapia paiya, Mosesie rania atarisikeyai. Pa na misiara uwoyaipo asi, ipaki kunauna, Kokaipa nu Apraxamupo Xoiteu, Aisakipo Xoiteu, Yekopupo Xoiteu. ");
INSERT INTO six_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Panumu xati, Xoiteu nu apu xumoki nikau Xoiteuxe. Xuwe. Nu apu ekinikioma puroteneai nikau Xoiteu. Nupo ekeropa xokupa xuiapu nini ekinikioma purineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kireu tu xotapa sipa apue Yesusue kunawotai kuna iyeseri, ipaki kauneri, “Xesixesi, neu kuna asinaku,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Apimie Yesusu kire sapire pani kotowopineria ximiketeneai. ");
INSERT INTO six_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesusue xuiapu ipaki kotonikina, “Amakati tuxotapa sipa apimie kunauneri, Xoiteue nukou xiyeri tinikepure tumuworetai apua Tepitipo yasiyasi xirounerina? ");
INSERT INTO six_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nakau siri xosa, Tepiti nukoini ipaki kunauna, ‘Kokaipae yeu Kokaipa ipaki kauna, “Ne yeu xupi meruira misau ");
INSERT INTO six_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","neu xiwayanimana nakipo sokisoki irue iyainikerepine,” xeyai.’ ");
INSERT INTO six_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Tini xekoa. Tepiti nukoini pa apu kauna ikou Kokaipa xeyai. Paina amakati pa apua nu Tepitipo yasiyasina?” niketai. ");
INSERT INTO six_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesusue kuna utei purati xokupa xuiapue iyeseria, nupo tataiwopi ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tini tu xotapa sipa apimi xosa sosopa epixakuai. Nini nekei xuwau nekeiyeri xowopure xirouneri. Nini xuiapue kununu wese yau kuso nikepinerire xirouneri. Nini Yuta nikau kununu ata yau akeri tumauro iri tepure xineri, kokaipa xoye xosa akeri tumauropu sai tepure xirouneri. ");
INSERT INTO six_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Xui oyemasi nikau xoreinikineri ninipo atoropu xuru pexirouneri. Kakinerini xoreixineri kunikuni xuwauworirouneri. Sewai kuna yause paiya nini kokaipa xuni kutu tepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesusue xekeu puratia, apu karainakue maneri Xoiteupo atapu xe waku xosa Xoiteu xou iwoteneai. ");
INSERT INTO six_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yesusue kire xui xauna xamu xumoki oyemasie, xe waxi aimore isoitati xe wakuro munati xekotai. ");
INSERT INTO six_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kakati Yesusue kunauna, “Ye suwauni kutu katikine, mua xui xauna xamu xumoki oyemasie, mua xokupa xuiapue Xoiteu tuwoteneai xe emeserinikina mua xe aimore waxi iyarina. ");
INSERT INTO six_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mua xokupa xuiapu nini xokupa xe purinana pana, nini xe misiarani kutu xe wakuro soxeteneai. Pa xuia nu xe xiri xuweni kutu sorena, xoye isayaxi nepina xe xiri xokupani iyarina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kireu apimie Xoiteupo ata xekeri ipaki kunauneri, “Asinaku asinaku xe xuruneri, xuiapue Xoiteu xouineri tuwoteneai xuru xoseixosei xeika paiye, mua ata ati nekeineri teketekewoteneai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kakeri Yesusue kunauna, “Tini mua xuru ximine xekeukiriaire ye katikepurexine. Yause xatia kire xe weteri kire xe xouro puropuwatixe. Xuwe. Xokupani kereuneria oro otuwopineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Apimie Yesusu ipaki kotouneri, “Xesepesiki, anakise pa xokupa kapia akipa xepinana? Amu wauni kutu akeri akipaxati paiye sipaunuku yause pa tomuroirouna xepinukuna?” woteneai. ");
INSERT INTO six_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kakeri Yesusue kunauna, “Tini xoreitikexenina, sosopa epixa. Pa amure, xokupa apue ma yeu wenimi tineri kunauneria, ‘Ye ikoini, pa apue xepina.’ Kakeri kunauneria, ‘Yause pa tomuroirouna xepineri.’ Kakeria tini kaki xanari tainikaku. ");
INSERT INTO six_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sewai, sanawa sanawa ere waraxeri kuna iyesinaria, tini kaki xanari ximikeri urewaku. Pa kapia xoia akeri akipa xepinerina pana, xurise yause paiya sapau akipaxepu watixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesusue pani ipaki kanikina, “Kire sanawapu apu kinie kireropu kireropu sanawapu apu kini xeika xoma tuwata xepineri. Kireu kokemupo apu kini xeika kireropu kireropu kokemupo apu kini xeika xoma tuwata xepineri. ");
INSERT INTO six_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kokakokai mimi ouro mopina. Kakatia kireropa kokaipa mause xeika supa xeika xosa puropineri. Mena xouro paiya kokakokai sapi xekeurouwopu xuweue iririkararawopineri. Kakeria xekeri ximi meru ximikakuai. ");
INSERT INTO six_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pa xokupa kapia akipaxepu xuweuni, soki xorotiki titikineria xoxixoxi kapia kakitikepineri. Kakineria Yuta nikau kununu ata yau kuna xosa soitikineri kakauya ata yatatikepineri. Tinie yeu wenimi xouroraria, kokemu xeika ere tumu xeika nikau moanikiro sotiki xou tumutikerepineri. ");
INSERT INTO six_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ninie pa kakeria, tinie Xoiteupo kuna uteinari kanikakuai ime sie xepina. ");
INSERT INTO six_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pa xati kaki xanari amu kuna kanikepuna xi xokupa nanunanu taku, ");
INSERT INTO six_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pa amure, ikoini kuna suputikiro iyarineia, asinaku sipa tikepine. Kakitia kuna xosatiki iyaitikereteneaie mua kuna tikitiai sokau porouneri ororepuworixe. ");
INSERT INTO six_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Takipo emitikimana anitikimana, xatatikimana, kirenini yawi kinipu, marouyatikimana, nikoe rania xiwai xupunikiro iyaitikerepineri. Kakeri kireu outikieria xumakuai. ");
INSERT INTO six_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yeu wenimi tini xosa purati paire, xokupa apue emumu tikepineri. ");
INSERT INTO six_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kakepinerina pana tinipo kire taputiki uriara siroropu wati xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tini sokisoki purinaria, ekitikioma asinaku sipesisipesi purakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesusue pani ipaki kunauna, “Tini xekoari xomatuae Yerusalemu koi katori puroria, erewese xoxi xepina yause tomuroirouna xinari sipawakuai. ");
INSERT INTO six_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pa yause xosa paiya Yutia tistrik puroteneai xuiapu nini totou yau ximi xowopinerini kutu. Yerusalemu puroteneai apimi rania nini erewese wetineri kirero xowopinerini kutu. Apu erewese kisauira puroteneai rania nini erewese manexeni. ");
INSERT INTO six_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pa yause xosa paiya, Xoiteue xoxixoxi kapiapu xapa tepina yause xati, xokupa kuna Xoiteupo nakau xosa purotaia suwauni kutu akipa xepina. ");
INSERT INTO six_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pa yause xosa xui nono kamupu xeika xui nono norumu apuri tiniketeneai xeika nini xousuwani kutu. Pa amure, kokaipa xuni kutu mua ouro putawatia, Xoiteupo kisamairae xuiapu teu xosaniki kopina. ");
INSERT INTO six_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kakatia xiwaie maneri sawaruwarue ounikeria xumopineri. Kakineria mua ouropu sanawa sanawa xosa xuruniki xouneri soiniki xanauworia, ai saina tineri purei puropineri. Kakeria xetau apimi nikau sienikie Yerusalemu xorowopineri, kaki utuneria xetau apimie Yerusalemu yakuwopineri yause Xoiteue tinikeyai xosa xuwe xepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesusue pani ipaki kunauna, “Pa yause xosa xumu xonuxonu kapia asau xeika poita xeika pai xeika xosa yaraxepina. Kakati ouropu xokupa apu nikau nanunanu xiri xoxi xatia, xasie emusauna kokaipa miria miria xati xokupa nanunanu tineria kokaipa ximi ximikepineri. ");
INSERT INTO six_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Xokupa xuiapue xonuxonu kapia mua ouro yara xepure xetaire xiri ximikeria akimiminikepina, pa amure, mena xouropu xokupa sokisoki sapi litowopina. ");
INSERT INTO six_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pa yause xosa Apupo Nono kire iyou xosa purokie kokaipa sokisoki xeika memeremu xeika tuku koatia, xuiapue xekopineri. ");
INSERT INTO six_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pa kapia akipa xineri putaworia, tini tumunaria taputiki kakaurowakuai. Pa amure, Xoiteue titikepina yause tomuroirouna,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesusue kire xonu kuna tiniketai. Ipaki kanikina, “Tini na kupari xekeunari kireu na rania xekoa. ");
INSERT INTO six_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Oma kau uyawati xekeunaria, xiri yause mopure xina xakuai. ");
INSERT INTO six_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Panumu sie, pa xokupa sapie yaraxati xekeunari paiya, tini sipaunari Xoiteue xuiapu yakunikirouna yause ma tomuroirouna xakuai. ");
INSERT INTO six_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ye suwauni kutu katikine, mua yausepu xuiapu xumopu xuweuni, mua xokupa kapia akipa xepina. ");
INSERT INTO six_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mena xeika ou xeika paiya xuwexepinerina, yeu kuna paiya xuwexepu watixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesusue pani ipaki kunauna, “Tini sosopa epixakuai. Tini sipesi sipesi xisa nekinekinari taputiki ninanana waku. Tini muputikipo xurure eiyo xaku. Panumu kapiae tini xorotikatia, Xoiteupo yause paiya, ");
INSERT INTO six_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","noto tirouneri urinakinaki siei sapauni maiyetikepina, pa amure, xokupa xuiapu sanawa sanawa puroteneai xosa mua yause akipa xepina. ");
INSERT INTO six_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tini sipesi sipesi yaku purinari, xokupa yause kunikuniwari sokisoki tikepina. Kakinaria pa xokupa xu tini xosa mopure xetai emeserinaria, Apupo Nono ekero tumuwakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Xokupa yause Yesusue xuiapu Xoiteupo ata tumau taitainikirouna. Ukumua xouna Orip Totou xosa xinirouna. ");
INSERT INTO six_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kakati xokupa xuiapue xoripesauni kutu saneri Xoiteupo atoro kuna iyesepure kourouneri. ");
INSERT INTO six_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pereti Pususu Xuweupo Kokaipa Yause paiya, kunauneri Xoiteue Israil Tianikati Ati Puroniaipo Kokaipa Yause xeteneai, mopure xetai. ");
INSERT INTO six_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ere xuriatiti xeika tu xotapa sipa apimi xeikae xuiapu ximikinikerineri, Yesusu ouwepure ime xireketeneai. ");
INSERT INTO six_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kakeri Satanie Yutasi Iskoriati xeteneaipo xoukemuro manetai, nu paiya Yesusupo kire tataiwopi 12-teu xosaupo. ");
INSERT INTO six_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nue xouna ere xuriatiti teu xeika Xoiteupo ata tumaupo xomatua teu xeika kuna ouwotai. Ime xireki xekerinapa nini xupunikiro Yesusu tinikepure kaketai. ");
INSERT INTO six_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pa apu teue Yutasi xekeri nimaririei kauneri, kireu xe tinepinuku woteneai. ");
INSERT INTO six_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kakeri Yutasie ninipo kuna iyorina, Yesusu xupunikiro iyarepure kire ime xireketai. Paiya kireni kireni xuiapue Yesusu xeika puroria kakepure xetai. ");
INSERT INTO six_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tupumoru Pususu Xuweupo Kokaipa Yause putawotai. Pa yause xosa sipsipu ara ouneri xoye nineria, Xoiteue Israil Weinikitati Ati Puroniaire nanuwopineri. ");
INSERT INTO six_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pa xati Yesusue Pitano Yonino xesaniati xowoxeri, ipaki kanikina, “Tini xounaxari sikou xoye pa kokaipa yausepu xoye ireiyaxa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kakati kotouneri, “Sini anoro xou xoye ireiyepinukuna?” woxeteneai. ");
INSERT INTO six_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kakeri Yesusue ipaki kanikina, “Iyesaxa. Tini erewese munaxaria, kire apue kokaipa ene suma xeme manapa imero tutumatiepina. Kakatia taitinari pa ata kamoro xowota xosa xowakuai. ");
INSERT INTO six_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Manaria pa ata xataku ipaki kaunari, ‘Xesepesikie ne kotonina, “Yeu ata kama anaina, yeu tataiyepi xeika Xoiteue Israil Weinikitati Ati Puroniai Yause nanunuku xoye nepinuku xina?” ’ xakuai. ");
INSERT INTO six_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kakaria kire kokaipa ata kama xosa, xokupa sapi xouro purinana ataritikepina. Kakatia tini pa ata kamoro xoye ireiyaxa,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesusupo tataiwopi aimorei xounexeri, Yesusue kanietai sieni xokupa sapi xekeri Xoiteue Israil Weinikitati Ati Puroniai Yausepu xuru ireiyexeteneai. ");
INSERT INTO six_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Xoye nepineri yause xati Yesusue kisasese saka xosa misati, nupo tianutianuwopie kisenikisese misianuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kakeri Yesusue ipaki kanikina, “Xoiteue Israil Weinikitati Ati Puroniaipo Kokaipa Yause nanunuku tini xeikani kutu ye xoye nepine. Kakerineia sewai tatau xemeropine. ");
INSERT INTO six_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ye tini katikine, ye mua xoye xiyeri nepu xuweuni Xoiteue xuiapu yakunikirouna yause xosa mua kapia akipa xepinani kutu,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kunarina kire xisa noikoi tina, Xoiteu eiyasewei, kunauna, “Tini mua xisa noikoi tinari ni xouwa. ");
INSERT INTO six_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pa amure, ye tini katikine, ximine xeika sewai xeika rania ye xiyeri xisa nepu xuweu puria, Xoiteue xuiapu yakunikirouna yause yaraxepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesusue kire tupumoru tina, Xoiteu eiyasewei poroporouna nupo tataiwopi tiniketai. Kakeri kunauna, “Muaiya yeu mupi, tini tianitikepure tikine. Tini panumu kakinaria ye nanuyakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Xoye nieria, xisa noikoi tina panumu kapiani kaketai. Ipaki kunauna, “Mua xisa noikoia yeu yawie tini xeika oma marou xosiki tumaxine, tini tianitikepure kusaune. ");
INSERT INTO six_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pana xekoa, pa apu, ye xiwai xupunikiro iyaiyerepure xetaipo xupo ye xeika mua saka xosa purina. ");
INSERT INTO six_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ekime Xoiteue kunawoyai sie Apupo Nonoe pa ime taiwopina. Pana pa apue nu xiwai xupunikiro tiniketaia nu xousua tuku nu xiri xoxixepina,” xetai. ");
INSERT INTO six_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesusupo tataiwopie pa kuna iyeseri saneri nikoniko ipaki kotokotowata xineri, “Yue pa kapia kakepinana?” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yu akerekina xineri Yesusupo tataiwopie nikoniko kuna tuwata xeteneai. ");
INSERT INTO six_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kakeri Yesusue ipaki kanikina, “Xetau xeteneai xuiapu kini nikau kokemua nini weniniki tuku xati yakunikineri, pa xati weniniki xourori kunauneri sini nini yakunikirounuku asinaku wenisiki tuku xineri. ");
INSERT INTO six_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Paina tini kaki xanari panumu kakaku. Xuwe. Apue tini xopu akereki purina paiya, nu amaike apu puriewopina. Tinipo tumu paiya nu tinipo saina apu tianitikepure puriewopina. ");
INSERT INTO six_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nanuwa. Yu akerekina? Apu misina xoye netare xoye wana tikouye wotai? Pa apu misina xoye netai, nu kireni akereki. Yepa tianitikepure tini xopu saina apu purine. ");
INSERT INTO six_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ye eruruyepure akipa xetai yause xosa, tini ye xeika purinuku weitepu xuwe. ");
INSERT INTO six_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yeu Xauwae xuiapu yakunikepine sokisoki sietai, panumu sie ye tini sokisoki tikine. ");
INSERT INTO six_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ye xuiapu yakunikitia, tinie yeu sai xosa misinari xoye nakuai. Kakinari, yeu kokemu sai xosa misinaria 12-teu Israil apimi kini yakunikakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesusue ipaki kunauna, “Saimon, Saimon, iyese. Apue wit ouneri uteineria inaina xesaurouneri sie Satanie tinipo xotikisu erurutikepure kunawotai. ");
INSERT INTO six_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kaketaina, neu xonisu oro kopu xuweu wopinaure tianine kunikuni xitiai. Ne pirixinau xiyeri kounauwa xatanimana sokisokinikewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kakati Pitae ipaki kauna, “Kokaipa, ye ne xeika kakauya ata xounuwai xirini xumaxaure ireine,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kakati Yesusue kunauna, “Pita, ye ne kanine, ximine ukumani, kakarau sona yaxepu xuweuni, xeimore yause kunaunauwa ye nu sipa xuwe xewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesusue nupo tataiwopi ipaki kanikina, “Tini xesatikiti yeu saina tepure xoukiriai yause, tini xe xopu xeika ari pokia xeika erieri xeika tixowopu xuwe. Pa yause xosa tini kire sapi xuweitau tikati eiyo xikiriaire, e xuwe?” niketai. Kakati kunauneri, “Xuwe,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kakeri ipaki kanikina, “Paina, muaiya apu xe xopu tukua nu tepina. Apu ari pokia tuku rania tepina. Apu nu saripiripiri masa xuweuwa, nupo kumukumu xesauna xe tinapa kire saripiripiri masa isaya xepina. ");
INSERT INTO six_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pa amure, Xoiteupo nakau xosa mua kuna tuku, ‘Xuiapue nu kire apu xoxi sie xekoteneai.’ Ye katikine xuiapue pa kapia ye xosa kakepineri. Pa amure, Xoiteupo nakauwe kunauna xokupa kapia ye xosa akipa xepina xetaia, akipa xepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kakati ninie kunauneri, “Kokaipa, ne xekowo. Sini aimore saripiripiri masa tuku, mua purina,” woteneai. Kakeri nue ipaki kanikina, “Pa itou,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesusue xokupa yause kakirouna sie, erewese wetina Orip totou xosa xowotai. Kakati nupo tataiwopie taiwoteneai. ");
INSERT INTO six_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Totou xosa utu putarineri nupo tataiwopi ipaki kanikina, “Tini kunikuniwa, eruru tini xosa mopu xuweuwopinaure,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kakerina weniki xayaka xayaka xetauro apue xe otuwori xourouna xe xe sie xosa xonana xoutapa ukurouna ipaki kunikunina, ");
INSERT INTO six_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Xauwa, ne kakepure xinauwa, mua noikoi ye xosaipo xesauweye. Kaki xanau yeu nanunanu taiwou. Xuwe. Ne nakipo nanunanu kireni taiwo,” xetai. ");
INSERT INTO six_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kakati kire mena xouropu xenikorokoroe kouyeuna sokisokiwotai. ");
INSERT INTO six_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesusupo mupokemu xiri xememesina tuitaiwatia pani sokisoki xina kunikuni wotai. Kakati nupo nesie yawi sie oro kusawotai. ");
INSERT INTO six_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesusue kunikunieina tumurou nupo tataiwopi xonaiyeniketai. Xona xekenikatia, xonikikemu xiri pauwati xinipuroteneai. ");
INSERT INTO six_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kakeri kanikina, “Tini ama xininukuna? Tini sarounari kunikuniwa. Eruru xosatiki moati, urakiarakiwaku,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusue xemu kunau puratia, kokaipa apu teue moteneai. Pa apu Yutasi xeteneaia, nu Yesusupo 12-teu tataiwopi xopuropu, nue ime atariniketai. Kakina, Yesusu uritokowopure nutiemu motai. ");
INSERT INTO six_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kakati Yesusue ipaki kotouna, “Yutasi ne Apupo Nono uritokoworine pa kapiarei apu xupunikiro tinikepure nanutiaire, wo?” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kakati Yesusu nuko xeika puroteneai tataiwopie, kapia akipa xepure xati xekeri kunauneri, “Kokaipa, kunawau sini saripiripirie ounikiepinukure,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kakeri kire nini xopuropue saripiripiri tina ere xuriatitipo saina apu ouna meruirapu xakumasa puromuwati oro kotai. ");
INSERT INTO six_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kakati Yesusue xekeri kunauna, “Mua kapia wete,” wotai. Kakerina pa apupo xaku xosa xupo iyarati, pa apupo xaku xiyeri meruketai. ");
INSERT INTO six_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kakerina ere xuriatiti xuno, Xoiteupo ata tumaupo xomatua nikau tumu xuno, Israil nikau tumu xunae kou soki tepure xeteneai ipaki kuna kanikina, “Tini kire apue, xomaxina pexina wopure xati, soki tepure kakieunuku saripiripiri xeika nawa xeika xaure xari kounukure, wo? ");
INSERT INTO six_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye xokupa asau Xoiteupo ata tumau tini xeika puritiaina pana, tini ye xosai xuputiki iyarepu xuwe. Pana mua yause paiya tinipo yause. Ximine ukumupo sokisoki paiye ye emeserina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesusue kunaratia, soki sou ti xouneri, ere xuriatitipo ata kamoro yatawoteneai. Kakeri Pitae tainiki xouna xayaka xayaka xetauro purotai. ");
INSERT INTO six_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kireu apue pa ata tumauro xepi karari misi puroteneai. Kakeri Pitae nini xeika misi purotai. ");
INSERT INTO six_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Xepiro misi purati kire saina xuie ati xeke tataipa utu xekotai. Pa saina xuie Pita xekeu puri kunauna, “Mua apu rania Yesusu xeika puroyai,” xetai. ");
INSERT INTO six_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kakati Pitae ipaki iwakina, “Xui, ye nu sipa xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xurise kire apue xekeri kunauna, “Ne rania pa apu teu nikau apu,” wotai. Kakati Pitae kunauna, “Xuwe. Ye pa apu xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yause xuwau xouratia, kire apue sokisoki kuna kunauna, “Suwauni kutu, mua apu rania nu xeika puroyai. Nu Kalilipo apu sore,” xetai. ");
INSERT INTO six_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pa rania Pitae kunauna, “Ne pa kuna kunautiaia ye xiri sipa xuweni kutu,” wotai. Pitae xemu kunau puratia, sapauni kakaraue yaxetai. ");
INSERT INTO six_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kakati Kokaipae pirixina Pita xekotai. Kakati Kokaipae kunawotai kunaure Pitae xiyeri nanuwotai. Kokaipae Pita ipaki kauna, “Ximine ukumani, kakarau sona yaxepu xuweni, xeimore yause ipaki kunaunauwa ye nu sipa xuwe xewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Paire Pitae kisau munana xoxi morepi morotai. ");
INSERT INTO six_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesusu teteneai apu teue pireuneri ouwoteneai. ");
INSERT INTO six_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kakineri marie ekekemu kurorineri ipaki kotouneri, “Ne kunatureture kunairae kunawo. Mua apu ounetaia, nu yuena,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kakerineri kireu xokupa ninia nu xosa xuwe xeteneai. ");
INSERT INTO six_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Asau xouro moatia, xuiapu nikau tumue kou kununuwori, tu xotapa sipa apimie nini xeika ere xuriatiti xeika kununuwoteneai. Kakerineri ninipo kununu xosa Yesusu sou korineri kunauneri, ");
INSERT INTO six_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ne sini kasike, Xoiteue nukou xuiapu xiyeri tinikepure iyaretai apua nere, xuwe?” woteneai. Kakeri nue kanikina, “Ye katikitia, tini yeu kuna xotikisuwakua xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ye kireu kunaure kototikia, tini yeu kuna xapa kayakua xana xuwe. ");
INSERT INTO six_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pana ximine xeika sewai sipesi sipesi yause xeika paiya Apupo Nonoe Xoiteu Kokaipa Sokisoki Tukupo xupo meruira, xosa misepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kakati xokupa apue kotouneri, “Pa xati nakieni Xoiteupo, Nonore?” woteneai. Kakeri nue kanikina, “Takieni kunaunuku. Paiya ye kireni,” niketai. ");
INSERT INTO six_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kakati ninie kunauneri, “Sini kireu apu yainikikiri kouneri nupo kapiaure kunawopi wetepu. Nukou supoini kunawati iyesinuku,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pa xokupa kokai apue saneri Yesusu Pailat xosa sou xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Utuneri kuna xotapa sarineri ipaki kunauneri, “Mua apue sinipo xuiapu nikau kapia porowati xekeukiriai. Sini Sisa xe tuwopinukua nue taiyerisiketai. Kakina kunauna Xoiteue nukou xuiapu xiyeri tinikepure iyaretai kokemua iko kireni xirouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kakeri Pailatie Yesusu ipaki kotouna, “Ne Yuta nikau kokemure, wo?” Kakati Yesusue kuna xapa ipaki kauna, “Nakieni pa kuna kunaune,” wotai. ");
INSERT INTO six_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kakati Pailatie ere xuriatiti xeika xuiapu xeika ipaki kanikina, “Ye mua apu xosa kire xu xekeui xana xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kakatia ninie pani ipaki sokisoki kuna kunauneri, “Nu Yutia sanawapu wesewese texirouna, Kalilie akeri kouna kounapa sikou erewese xexe xina xuiapu taitainikina xonikikemu xusirouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatie pa kuna iyeserina ipaki kotonikina, “Mua apua nu Kalilipo apure, wo?” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesusua Erotie yakuwotaipo sanawapu apu xati Pailatie kuna iyeserina, Erot xosa xesawati xowotai. Pa yause xosa Eroti rania Yerusalemu purotai. ");
INSERT INTO six_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erotie Yesusu xekerina, nimaririwotai. Nure kuna iyeseyaina xuwau yause xekopu xuwe xati kire xonuxonu kapia kakatia xekopure xetai. ");
INSERT INTO six_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erotie Yesusu xokupa sapire kotowotai. Kakatia Yesusue kire kuna xapa kawopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kakati ere xuriatiti xeika tu xotapa sipa apimi xeikae nutiemu ma tumuneri mua tutuneri sokisoki kuna nu xosau suwoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kakeri Erotie nupo xomatua xeikae xisiworineri pirewoteneai. Kakerineri kire mari xosei tineri, takereruworineri, Pailati xosa xiyeri xesawoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ekimepa Erotie Pailati xeika xiwai sairounana pana, pa yause xosa paiya, xiwai turuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailatie ere xuriatiti yainikina, xuiapu nikau tumu teu yainikina, xuiapu yainikina wati maneri kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pailatie ipaki kanikina, “Tini ye xosa, mua apu sou ma kunaunuku, nue xuiapu nikau kapia porouna xikiriai. Taki purikiriai yauseni, pa xokupa kapiaure nu ati kotoutiai. Paina iyesa. Ye kire xu mua apu xosa xekopu xuwe. Ye nanutiaia nu kire kapia xoreiyerati tini kuna xosa iyarepu xuwe. ");
INSERT INTO six_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eroti rania nu mua nanunanu tuku xati, siko xosa xiyeri xesawati kotai. Iyesa. Mua apu nu kire kapia xoreiyeretai xati kunaunei xumopina xepixe. ");
INSERT INTO six_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Pa xati ai kasieineia wetiti xowopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Paire xokupa xuiapu xeikae, ere urue ipaki yaxineri, “Pa apu ouwari xumati, Parapas wetari maiyesika,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapas apua erewese kapmani xeika xoma sarina, apu ouwati xumati, kakauya atoro iyareniai. ");
INSERT INTO six_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailatie xiyeri kuna kanikina, “Ye Yesusu wetiti xowopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kakati ipaki yaxineri, “Na nikitoto xosa wara! Na nikitoto xosa wara!” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailatie xeimore yause xi kuna kanikina, “Amakatina? Nu amu kapia xoreiyeretaina? Nu kire kapia xoreieretai xati ye xekeri kunaunei nu xumopina xepixe. Pa xati ai kasieineia wetiti xowopina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kaniketai sorena Yesusu na nikitoto xosa warepinaure ninie eririkineri pani sokisoki yaxeteneai. Kakineri ninipo urue Pailatipo kuna ekoyawoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kakeri Pailatie ninipo kuna taina, Yesusu xumopina xetai. ");
INSERT INTO six_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pa apu kapmani xeika xoma sarina apu ouwati xumati, Romupoe kakauya ata iyareneai, Pailatie wetepinaure xuiapue yaxeteneai. Pailatie xuiapu nikau kuna taina pa apu wetati, xowati, Yesusu xomatua xupunikiro tiniketai. ");
INSERT INTO six_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xomatuae Yesusu sou xoworia, kire apue erewese xowopure moati xekoteneai. Apu wenumu Saimon, nu Sairini ere wesepu soki teteneai. Na nikitoto xaurauro xemereruwori Yesusu taiwotai. ");
INSERT INTO six_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kokaipa xuiapu kinie Yesusu taiwoteneai. Kakeri xokupa xuie Yesusure murineri karu masi woroteneai. ");
INSERT INTO six_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kakeri Yesusue pirixina ipaki kanikina, “Tini Yerusalemu xuimi, kakixanari yeure moraku. Tini takire murinari, niretikimanaure mora,” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Iyesa. Xurise kire yause putawatia ipaki kunauneria, ‘Xuimi nono iyarepu xuweu wopineri xeika, xuimi nono iyarepu xuweuwoniai xeika, xuimi nono apuri tinikepu xuweuwoteneai, xeikae nimaririwopineri,’ xepineri. ");
INSERT INTO six_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pa yause xosa siri ipaki kanikineria, ‘Sini xorosikari,’ totou ararae ‘Sini kururusikepineri,’ xepineri. ");
INSERT INTO six_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ximine muanumu kapia, ene tuku na xosa kakinerina, amu kapia na mouweki xosa kakepinerina?” niketai. ");
INSERT INTO six_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xomatuae aimore apu poriporitua rania, Yesusu xeika ounikiepure, soniki xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kire wese wenumu Tapa Sekoromu xosa utu putawoteneai. Pa wese xosa Yesusu na nikitoto xouro wareteneai. Apu xoxi aimore rania wainikereteneai, kirepa Yesusupo xupo meruirapu na nikitoto xosana, kire paiya xupo sakipairapu na nikitoto xosa wareteneai. ");
INSERT INTO six_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kakeri Yesusue kunauna, “Xauwa, ne ninipo xunu weterinike. Mua kapia kaketeneaia nini sipa xuwe xati kakineri,” xetai. Xomatuae Yesusupo nekei xuru niko utei tepure satu nerawoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Xuiapue tumuneri xekeu puroria, Yuta nikau tumue Yesusu ipaki pireuneri, “Nu kireu apu tianikeyai. Suwau Xoiteue mua apu iyarati nupo saina tina nupo xuiapu xiyeri tinikepina xatia, nukoini nuko tianuwopina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xomatuae rania pirewoteneai. Yesusu nutiemu maneri xisa isi worotai tuwopure xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kakeri ipaki kunauneri, “Ne suwau Yuta nikau kokemu xatia, nakieni naki tianiwo,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kakerineri kire kuna xayau tineri Yesusupo taporo na nikitoto xosa tareteneai. Pa kuna muanumu, “Mua apu nu Yuta nikau kokemu,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apu xoxi aimore Yesusu xeika wainikereteneai, kirei Yesusu ipaki pireuna. “Xoiteue iyaretai apu nere, wo? Paina ne naki tianinau, sini rania tianisike,” wotai. ");
INSERT INTO six_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kakati kire apue pa kuna iyeserina, xatau ipaki auna, “Ne rania mua apu tetai sie xu titiai, ne Xoiteure ximikau xana xuwere? ");
INSERT INTO six_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sini ousieri xumuyatia, nini asinaku kapia kakineri. Sioe xoxi kapia kakiyatiareni kutu mua xu tinuwa. Pana mua apu nu kire poripori kapia kakepu xuwe,” wotai. ");
INSERT INTO six_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kakeri kunauna, “Yesusu, ne xuiapu yakunikewai yause xosa, ye nanuyewai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kakati Yesusue ipaki kauna, “Ye suwauni kutu kanine, ximine ne ye xeika mena xouro purowai,” wotai. ");
INSERT INTO six_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Asauniki yause 12 kiloku sie xosa, ou xiri ukumu utu 3 kiloku xoruwati xetai, ");
INSERT INTO six_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","pa amure, asau memeremu pa yause xosa xuweirotai. Kakati kokaipa mari Xoiteupo atoro tua purotai, xiri kiraxina aimore xakuwetai. ");
INSERT INTO six_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kakati Yesusue pani ere uru yaxina, “Xauwa yeu xenimi neu xupuniro iyarine,” xetai. Kaki uru yarina xumotai. ");
INSERT INTO six_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Xomatua nikau tumue pa kapia xekerina, Xoiteupo wenumu xouroretai, kunauna, “Suwauni kutu, mua apu nu siomou, nu poripori erepu xuwe,” xetai. ");
INSERT INTO six_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Xokupa xuiapu pa kapia xekopure, kou kununuwoteneaie pa kapia xekeri, eiyorineri totoniki ouneri nikou ata yau xiyeri xouxanau woteneai. ");
INSERT INTO six_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesusupo xokupa xataumana xeika xui teu Kalili wetineri Yesusu tai koteneai xeikae, xayaxayaka xetauro tumuneri pa xokupa kapia yaraxetai xekoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kire apue purotai, nupo wenumu Yosepu. Nu Yuta nikau kire erewese, Arimatia xeteneaipo apu. Nu apu kutu asinaku, nu rania Yutapu kire kuna xekexeketua. ");
INSERT INTO six_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nu kireu kuna xekexeke tua nikau nanunanu xeika kapia xeikaure iyo nikepu xuwe. Nu Xoiteue xuiapu yakunikepina yause xekopure yakurouna. ");
INSERT INTO six_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nue Yesusu mou tepure Pailati xou kotowatia, Pailatie iyo wotai. ");
INSERT INTO six_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kakati Yesusu mou oro tikouna, mari xoseie xotori ekime apu upuworopu xuweu kopaupuro iyaretai. Pa kopaupua apue xe porouneri xuroreki. ");
INSERT INTO six_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pa asauwa Yuta Nikau Arikepi Yausepu xuru ireiyepineri, pa xati pa yause tomuroirotai. ");
INSERT INTO six_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kalili wetineri Yesusu xeika koteneai xuimie Yosepu tai xouneri pa kopaupu xekoteneai. Yosepue amaki Yesusu mou iyaretai rania xekoteneai. ");
INSERT INTO six_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Xuimie xekerineri, nikou atoro xiyeri xouneri, kireu kasuwei xeika orip xona asinaku xuri tuku xeika ireiyeteneai. Kakerineri tuxotapae kunawoki sie Yuta Nikau Arikepi Yause xosa ariketeneai. ");
INSERT INTO six_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Murisiro akereki asau xosa, xoripesauni kutu xuimie kopaupuro xowoteneai. Pa kasuwei xuru asinaku xuri tuku ireiyeteneai ti xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Utu xekoria apue pa xe kopaupu parareteneai upu suporo puropu xuwe. Yauweri ekorekore xowotai. ");
INSERT INTO six_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Upu minika maneteneai sorena, Yesusu Kokaipa seke moupu xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yesusu mou anoro purotai nini sipa xuwe xati, xokupa nanunanu tipuroteneai. Kakeria aimore apu, ninipo nekeiye xiri una piririkati nutieniki tumu puroteneai. ");
INSERT INTO six_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xuimie xiri ximikerineri kokorumeuneri ou xekoteneai. Kakeri pa apu aimorei ipaki kanikineri, “Tini apu xumoki nikau wesepa amakati apu ekeoma tuku kou xirekinukuna? ");
INSERT INTO six_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nu muoro puratixe. Nu itou sarotai. Nu Kalili purotai yauseni, mua kuna tiketai tini xiyeri nanuwa. ");
INSERT INTO six_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nue ipaki katikina, xunu erirouneri apu xupunikiro Apupo Nono tinikeria, na nikitoto xosa warepineri. Kakeria asau xeimore xosa xiyeri saropina xetai,” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanikeri ekime Yesusue kanikeyai kuna nanuworineri, ");
INSERT INTO six_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","kopaupu wetineri xiyeri xowoteneai. Xouneri Yesusupo tataiwopi 11-teu kanikineri, kireu xuiapu rania pa xokupa kapiaure kanikete woteneai. ");
INSERT INTO six_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yesusupo tianuwopi kaniketeneai xui teu muai, Maktala erewesepu Maria, Yoana, Yemusipo ana Maria, kireu xui teu xeika, nini paiye kunawoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yesusupo tianuwopie, xui nikau kuna aini peroro kuna parineri ninipo kuna suwau xepu xuwe. ");
INSERT INTO six_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pita nukoini sana kopaupuro keikei xowotai. Xouna korumeirou upuro oioiwotaia, mari xaku teu kireni purati xekotai. Atoro xiyeri xouna pa kapia yaraxetaire xokupa nanunanu tetai. ");
INSERT INTO six_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Xuimie kopaupuro xowoteneai yauseni, Yesusupo tataiwopi aimorei, Emeus xeteneai wese teipa xowoxeteneai. Pa wese paiya Yerusalemu tomuro purati xana 11 kilomita xeteneai sie xosa xetauro purina. ");
INSERT INTO six_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aimore apue xoupurineria, pa xokupa kapia yaraxetaire kunaupa xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pa kapia yaraxetaire xokupa kuna kunauneri kotoxeria, Yesusu nukoe nutieniki moati xirini xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kakati kire sapie ninipo ekiniki kirikiriwati, muaiya Yesusue xineri sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xoupurineria nini ipaki kotonikina, “Tini amure kunaupa xounuana?” niketai. Nue kaki kunawatia, xoniki sua tuku muanikie tumuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pa aimore apu, kirepu wenumu Kliopasi, nue kuna xapa kauna, “Xokupa xuiapu xetaxetau wesepue Yerusalemu mua purineri. Pa yause xosa Yerusalemu pa kapia yaraxetaia ne kireni sipa xuwerau?” wotai. ");
INSERT INTO six_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kaki kunawatia, Yesusue kotonikina, “Amu kapiana?” niketai. Kakati ninie ipaki kauneri, “Sini Nasaretipo Yesusu xosa pa xokupa kapia yaraxetaire kunaunuku. Nu kire kunatureture, nu Xoiteu ekero xeika xuiapu ekinikiro xeika sokisoki saina tina sokisoki kuna kunaurouna. ");
INSERT INTO six_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sikou ere xuriatiti xeika tumu teu xeikae kapmani xupuro iyareteneai. Kakeri kapmanie ouwepure kuna ouworineri, na nikitoto xosa wareteneai. ");
INSERT INTO six_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pa apu Yesusua nu Xoiteue Israil apimi xiyeri tinikepure iyaretai xinuku ekimeni xosikisukiriai. Pa xeika kire kuna rania. Ouweri xumotai yausei kouna ximine asau xeimore xina. ");
INSERT INTO six_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ximine sinipo xui tuturopu kireu xuimie sini xiri uresiketeneai. Nini xoripesauni kutu kopaupuro xowoteneaiana, ");
INSERT INTO six_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yesusu mou purati xekopu xuwe. Xiyeri kou ipaki kunauneri, ‘Sini xiniwepie sie xenikorokoro xekenikikiria, kunauneri, “Nu ekeoma purina siketeneai,” ’ xeteneai. ");
INSERT INTO six_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kakeri sini kireue kopaupuro xouneri, xuie kunawoteneai sie upu xekoteneai sorena, Yesusu nuko xekopu xuwe,” woteneai. ");
INSERT INTO six_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kakexeri Yesusue ipaki kanina, “Tini nananatua, tini nanunanu xuwe xati, xokupa kuna kunatureturei kunawoniaire sapauni xotikirei saroati xotikisuwarixe. ");
INSERT INTO six_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pa ama? Pa apua Xoiteue sokisoki kuna kunauna, xesauti xounapa ikou xuiapu xiyeri tinikepina xeyaiya tini sipa xuwere? Nu tatau xemerina paiyeye sewai Xoiteu xosa kokaipa wenumuni kutu tepina,” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kakerina kuna utei kaniketai. Mosesipo kuna xeika xokupa kunatureture nikau xeikarei kuna xotapa tayetai, kanikinani Xoiteupo nakau xosa nukoure xokupa kuna masa purotai rania kaniketai. ");
INSERT INTO six_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Utuneria pa apu aimorei xowopureiyewotai wese inasamuro munoteneai. Yesusua pani xouyewopureiye wotai. ");
INSERT INTO six_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kakati ninie taiyeru puri kunauneri, “Ne sini xeika puro. Asau iriropure xinana puripurinapa xorixepina,” woteneai. Kakeri atoro mana nini xeika purotai. ");
INSERT INTO six_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Xurise xoye nepure xineria, Yesusue nini xeika misetai. Tupumoru tina Xoiteu eiyaseuweina poroporouna tiniketai. ");
INSERT INTO six_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yesusue pa kakatia, ekiniki sisirauweineri, muaiya Yesusu xineri sipawoteneai. Kakeria sapauni lemeni xuweiroati, pani xiyeri xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Paire nioninioni ipaki kunauneri, “Suwauni kutu, sini imero kouyati, nue kuna sikina, Xoiteupo nakaupo nanunanu xotapa kasiati, xosikikemu xiri sarotai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pa aimore apue kunarineri sapauni sarou Yerusalemu xiyeri xowoteneai. Utuneri Yesusupo tataiwopi 11-teu xeika kireu xatanikimana xeikae kununu purori xekeniketeneai. ");
INSERT INTO six_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kakexeri ninie pa apu aimore ipaki kanikineri, “Suwauni kutu Kokaipae xiyeri sarotai! Saimonie xekotai!” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kakeri ninie xokupa kapia imero xekoteneaire kuna kaniketeneai. Pani kunauneri, “Nu tupumoru porowotai yauseye, sini xekeu sipauyatiai,” niketeneai. ");
INSERT INTO six_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yesusupo tataiwopie pani kunau puroria, Yesusu nukoini nini xopu tumuwotai. Yesusue ipaki kanikina, “Tinipo xotikikemu yoroarani pura,” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kakatia ureuwei ximikieteneai. Kire kopa xekeunuku xi nanuwoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kakeri ipaki kanikina, “Tini amakati xoxi ure ureunukuna? Tini amakati xokupa nanunanu tinukuna? ");
INSERT INTO six_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yeu xupi yoruka axiri xeika siai yoruka axiri xeika xekoa. Ye ikoini purine. Yeu mupi tiurutiuru nari xekoa. Kopa paiya iko xosa xekeukiriai sie nini tepu xeika ei xeika xekoakuaixe,” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pa kuna kunarina, nupo xupo yoruka xeika siau yoruka xeika nini atariniketai. ");
INSERT INTO six_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Xekeri xiri nimariri woteneaina pana xonikisuwopu xuweu xokupa nanunanu teteneai. Kakeri ipaki kanikina, “Tini kireu xoye muoro purinare?” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kakati xuwoteneai wese masa tuwori, ");
INSERT INTO six_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nue tina nati, xekoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesusue ipaki kanikina, “Ye taki tukuni puriai yause xosa ipaki katikine, yeure ekime xokupa kuna Mosesipo tu xosa xayauneri, kunatureture nikau nakau xosa xayauneri, nakau siri xosa xayauneri woniaia, pa xokupa kapia paiya suwauni kutu yaraxepina xine katikiai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Xoiteupo nakau xosa purotai kuna xotapa ati sipawopinerire tianiniketai. ");
INSERT INTO six_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ipaki kanikina, “Xoiteupo nakau xosa mua kuna tuku, Xoiteue nupo xuiapu xiyeri tinikepure iyaretai apua nu tatau xemenapa asau xeimore xosa kopaupurei xiyeri saropina. ");
INSERT INTO six_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kakatia nupo wenumurei xokupa sanawa sanawa xuiapu xosa kuna uteiwori xoniki pirixeria, Xoiteue ninipo xunu weterinikepina. Tini Yerusalemue saina xotapa tainaria, ");
INSERT INTO six_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","pa xokupa kapia ekitikiro yaraxetaire kuna kanikakuai. ");
INSERT INTO six_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iyesa. Ekime Xauwae sokisoki kuna kunauna, Xoiteupo Sokisoki Supo Youya tikepine xeyai, paiya yei xesaritikepine yause tomuroxina. Tini mua erewese purokieni pa Xoiteupo sokisoki takuai,” niketai. ");
INSERT INTO six_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesusue nupo tataiwopi Petani wese xexe soniki xowotai. Xupo xouro wawaieina Xoiteue atinikepinaure kotowotai. ");
INSERT INTO six_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mupuniki xusi ounani, weniki xowati, Xoiteue mena xouro sou xowotai. ");
INSERT INTO six_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kakati tataiwopie onikitapa ukurouneri nure muris teteneai. Kakerineri xiri nimariri eineri Yerusalemu xiyeri xowoteneai. ");
INSERT INTO six_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ninie xokupa yause Xoiteupo ata tumau purineri Xoiteupo wenumu xourorirouneri.");
INSERT INTO six_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilusu, ye ekime xayautiai nakau xosauwa, ximuximuni kutu Yesusue xokupa saina tina xokupa xuiapu taitainikipa, ");
INSERT INTO six_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kouna kounawati Xoiteue mena xouro sou xowotai yauseure xayautiai. Xoiteupo Sokisoki Supo Youyae Yesusu kawati mana Yesusu nukoe tumunikikereyai tianuwopie saina tepinerire kuna kaniketai. Kakatia xurise Xoiteue xouro sou xowotai. ");
INSERT INTO six_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ximuximua tatau xemena xumotaina, xurise xiyeri ekeoma tina tianutianuwopi xosa maiyeniketai. Nu ekeoma purina xineri ati sipawopinerire, xokupa kapia kaketai. Nu 40-teu asau xosa xekori, Xoiteue xuiapu yakunikepina yauseure kaniketai. ");
INSERT INTO six_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nini xeika purotai yauseni, ipaki kanikina, “Tini Yerusalemu kaki xanari wetaku. Xauwae sapi tinikepine xi kunawati paire ekime katikiaina, yakuwa. ");
INSERT INTO six_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yonie xuiapu enero ene iserinikeyai. Pana Xoiteupo Supo Youya xosa ene isakuai yause xekepu xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pa yause xosa tianutianuwopie xirini kununurou, kotouneri, “Kokaipa, mua yause xosa Israili kokemu saina tuwau xiyeri sokisoki tina, sanawa yakuwopina kokemu xepinare, e xuwe?” woteneai. ");
INSERT INTO six_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kakeri nue xiyeri ipaki kanikina, “Xauwae iyaretai yause xeika asau xeika paiya tinipo sapi xati sipawakuaixe. Xuwe. Nukoini pa xokupa sapi yakuna. ");
INSERT INTO six_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pana sewai Xoiteupo Supo Youyae kou tini xosa puratia, tini sokisoki takuai. Kakinaria, taki ekitikieni xekeikiriaire Yerusalemu kuna tinikinari, Yutia sanawayau tinikinari, Samaria Tistiriki tinikinari, ou papaiwotai xokupa sanawa tinika,” niketai. ");
INSERT INTO six_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesusue pa kuna kunauwati, xekeu puroria, xouro xowotai. Kire iyoue ximiakerati pani xekeu puropu xuwe. ");
INSERT INTO six_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nu xourati pani mena xekeu puroria, sapauni aimore apue nini xeika tumuwoteneai. Nini nekei karai tuku. ");
INSERT INTO six_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ipaki kunaunexeri, “Tini Kalili apimi, tini ama aini tumunuku mena xekeunukuna? Yesusua Xoiteue sowati, tini wetiki mena xouro xounana, mua xekoari mena xouro xowotai kapiareini xiyeri kopina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yesusupo tianutianuwopie Oripu xeteneai totou wetineri, Yerusalemu xiyeri xowoteneai. Oripu totoua Yerusalemu tomuro kireni kilomita sie xosa purina. ");
INSERT INTO six_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Erewese minika xouneri, xouro niko purirouneri ata kamoro maneteneai. Ninipo weniniki teu muai, Pita, Yoni, Yemusu, Entru, Pilipu, Tomas, Patolomiu, Matyu, Alpiusipo nirau Yemusu, Saimon nu Seloti apu kinipo apu, Yutasia, nu Yemusipo nirau. ");
INSERT INTO six_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pa xokupa apu teue kunununeri xonikitumaixi kunikunirouneri. Xui teu, Yesusupo ana Maria xeika, Yesusupo xataumana xeika, ninie rania kouneri nini xeika kunikunirouneri. ");
INSERT INTO six_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa yause xosa Yesusure xoniki suwoteneai xuiapu nikau xoka 120-teu sie. Pitae nini xopu tumuna ipaki kuna tinikina, ");
INSERT INTO six_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Xataimana, ekime Xoiteupo Supo Youyae kakati Tepitie kire kuna kunawoyai Xoiteupo nakau xosa purina. Apu teu ime atarinikati, Yesusu soki teteneai apu Yutasire kunawoyai. Tepitie kunawoyai sie mua kapia akipa xetai. ");
INSERT INTO six_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ekime Yutasie sini tuku lixina, sini tikiriai sie saina tetai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pa apu Yutasie pa xoxi kapia tetai xosaupo xe tina, kire ou masa isayaxetai. Kakerina xurise pa ouro titikiri xouna ukaukemu porouwati, kamoropu sine muri ouro kusawotai. ");
INSERT INTO six_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Paire xokupa apu Yerusalemu puroteneaie sipawoteneai. Ninipo kunairae, pa ou wenumu Akeltama. “Akeltama” wenumu muanumu kuna sie, “Ou Yawi Tuku.” ");
INSERT INTO six_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pitae pani ipaki kunauna, “Mua kuna Nakau Siri xosa xayawoniaiya muanumu, ‘Nu puroyai wese paiya, aini puropinana, kire apu wetau pa xosa puropu watixe.’ Kire kuna masa mua nakau xosa muanumu kuna tuku, ‘Kire apue nupo saina tepina xeyai.’ ");
INSERT INTO six_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Pa xati Kokaipa Yesusue siko xeika xokupa yause xowori kori wati, siko xeika texeteneai apu xopuropu kire tumuworepu, ");
INSERT INTO six_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ximuximu Yonie xuiapu ene iserinikati, Yesusue saina xotapa sari tipa kouna kouna Xoiteue sowati wesiki xouro xowotai yause xetai. Kire apu nukou ekeini pa xokupa kapia xekotai tumuworikiri sini xeika saina tina Yesusu xiyeri sarotaire kuna uteiwopina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pitae kaki kunawati, aimore apu tumunikereteneai. Kire nu Yosepu, wenuneri Parsapasi xeteneai, nuni Yastusu wenumu tuku, kire apua Matiasi. ");
INSERT INTO six_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Kakerineri ipaki kunikunineri, “Kokaipa ne xokupa apu nikau xonikikemu sipa. Yutasipo iri tina Yesusupo tiantianuwopi saina tepinaure aimore apu tumunikerinukuna, yurau xonieutiai atarisike. Yutasie mua saina wetina nu puropina wese xosa xowotai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kakeri yuerau pa saina tepinaure xe pureworia, Matiasipoe putawotai. Kakati Matiasi Yesusupo tianuwopi 11-teu tuku iyareteneai. ");
INSERT INTO six_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosipo Kokaipa Yause koati, Yesusure xonikisuwoteneai xuiapue kireni atoro xirini kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kakeria sapauni mena xourei kire sapie sokisoki xupeue miriaiyeu kouna, misipuroteneai ata xiri xokoperetai. ");
INSERT INTO six_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kakati xepi sie sapie koati xekoria, xokupa apu nikau minoniki sie xekeuyewoteneai. Pa minoniki paiye xokupa apu yau xouxanauwotai. ");
INSERT INTO six_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Xoiteupo Supo Youyae pa xokupa xuiapu xosaniki koxeri, xetaxetau kunairae kuna xotapa tayeteneai. Xoiteupo Supo Youyae kakati pa xokupa kuna kunawoteneai. ");
INSERT INTO six_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kireu Yutae kouneri Yerusalemu purineri, Xoiteure muris tirouneri. Nini mua ouropu xokupa sanawapue koteneai. ");
INSERT INTO six_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pa miriae miriai koati, xokupa xuiapue iyeserineri kou kununuwoteneai. Yesusure xonikisuwoteneai xuiapu nikau kuna iyeserineri, urewoteneai, pa amure, kireni kireni xuiapue ninipo kuna iyeseria nikou kunaini kunawori iyeserineri kaketeneai. ");
INSERT INTO six_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yutapu xuiapue kokai ure ureri kunauneri, “Mua xokupa xuiapu teua nini Kalilipo kireni. ");
INSERT INTO six_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Amakati sini mua xokupa kireni kireni xuiapue sikou kunaini ninie kunawori iyesinukurau? ");
INSERT INTO six_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sini Partia sanawapu, Mitia sanawapu, Elam sanawapu xuiapu teu, sini Mesepotemia tistirikipo, Yutia tistirikipo, Kapatosia propinsipo, Pontusu propinsipo, Esiapu, ");
INSERT INTO six_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prikia tistrikipo, Pampiliapu, Isipu sanawapu, Lipia tistirikipo, Sairini erewese tomuro puroteneaipo, Romu sanawapu apue kou muoro purikiriai. ");
INSERT INTO six_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sini Yuta xeika Yentail xeteneai xuiapu teu xeikae sini Xoiteupo muris tainuku, sini Kriti soupo xeika, Arepia tistirikipo xeika, siko xokupae iyesikiria ninie sikou kunaini Xoiteupo sokisoki sainaure kuna siketeneai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Paire xokupae kokaipa nanunanu teteneai. Kakerineri nikoniko ipaki kunauneri, “Mua kapia ximine yaraxetaia amu kapiani kuturau?” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kakeri kireu paiye ipaki pirenikineri, “Nini xokupa oma xisa nerineri kakineri,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pitae Yesusupo kireu tianuwopi 11-teu xeika tumurouna xuiapu ere supoe sokisoki kuna ipaki kanikina, “Tini Yuta apimi xeika xokupa apimi kou Yerusalemu purikiriai xeika, tini yeu kuna xosa xakutiki iyarinari, mua kapia ximine yaraxati xekeukiriai xotapaure sipawakuai. ");
INSERT INTO six_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tini nanunuku mua apimi xisa neri kakineri xinukure, wo? Xuweni kutu. Muaiya 9 kiloku xoripesau. ");
INSERT INTO six_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mua kapia ximine yaraxetaia, ekime kunatureture Yoelie muaire kunawoyai. Nue ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Xoiteue kunauna, “Yause xuwe xepure tomuroiratia, xokupa xuiapu xosa yeu Youya kusawopine. Kakitia tinipo nonomi xeika momukomi xeikae yeu kuna kunatureturei uteiyewopineri. Tinipo apu tenemaie xiniwepi sie sapi xekoria, apu sakaue xiniwepiwopineri. ");
INSERT INTO six_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pa yause xosa yeu saina apu xeika saina xui xeika xosa yeu Youya kusautia, ninie yeu kuna kunatureturei uteiyewopineri. ");
INSERT INTO six_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ye mena xouro xetau kapiani kutu kakineia, toupa oro paiya xurisepu yause sie xonuxonu kapia erepine. Yawi xeika xepi xeika kokaipa xepitutu xeika mopina. ");
INSERT INTO six_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kakati asaue ukumu xatia, poita paiya ewou xina yawi sie xepina. Kakati xurise Kokaipapu yause moati paiya, Kokaipae nukou kokaipa sokisoki xeika memeremu xeika atarisikepina yause. ");
INSERT INTO six_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pa yause xosa Kokaipae tianikepinaure xokupa xuiapue yaxepineri, kakeria xiyeri sonikati ati puropineri,” ’ xina kunawoyai. Mua kuna paiya kunatureture Yoelie sikeyai xina Pitae kunawotai. ");
INSERT INTO six_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tini Israili apimi, yeu kuna xosa xakutiki iyara. Ye Nasaretipo Yesusure katikepurexine. Xoiteue pa apu xuporei xokupa sokisoki saina xeika xonuxonu kapia xeika taki xopu erati takieni sipaukiriai. Xoiteu nukoini xesawati kotai xinari sipawakuaire Xoiteu nukoe kaketai. ");
INSERT INTO six_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ekimeni nukoe nanuna kuna ouwoyai sie tini xuputikiro iyaretai. Kakati apu xoxi xupunikiro takie na nikitoto xosa warinuku ouwari xumotai. ");
INSERT INTO six_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kakari Xoiteue pa apu xiyeri sarina xumopipo tatau xoxi xosa iyarati puratixe, pa amure, xumopie pa apu sokisoki tepuwati xana xuwe. ");
INSERT INTO six_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ekime Tepitie rania nure ipaki kunauna, ‘Ye xekeutia Kokaipae Ye nutiemini kutu xokupa yause purina. Nue ye nutiemi purina ye sokisoki sina, pa xati kire sapie kakati ye ximikinei urewopixe. ");
INSERT INTO six_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pa xati yeu xoikemu xiri asinaku xati, ye nimariri kuna kunaune. Xoiteue ye xosa asinaku kapia kakepure xetai yakune. ");
INSERT INTO six_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ne yeu xenimi wetau xumoki apimi nikau wese puroxete. Panumu xati ne nakipo xokiaune tumuworitiai apu xokumo wetau kopaupuro xusaxete. ");
INSERT INTO six_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nei ekioma puropine ime ataritiai. Nei ye weitau naki xeika puria, nakie apoyau ye xiri nimaririwopine.’” Mua kuna xokupa Tepitie kunawoyai. ");
INSERT INTO six_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Yewapu xura, Asisiki Tepitireni kutu, ye katikepure xine. Nu xumurati, upuareneai. Nupo upua mua siko xopu xokupa yause purina. ");
INSERT INTO six_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tepiti nu kunatureture xati, nuko sipa, Xoiteue xupo xouro wari ipaki kunauna, ‘Sewai neu kire asinimana tumuworitia, naki sie kokemu tumuwopina woyai.’ ");
INSERT INTO six_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pa xati Xoiteue Tepiti nuko wetati apu xumoki nikau wese purina kopaupuro xusaxepu watixe kuna paiya, Tepiti nukoure kunawopu xuwe. Xoiteue pa saina tepure xetaia, Tepiti nu sipauwetai. Paiya Xoiteue nukou xuiapu tinikepure tumuworetai apue xiyeri saropinaure kunawoyai. ");
INSERT INTO six_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Paina pa apu Yesusu paiya, Xoiteue kopaupuropu saretai. Nu xumorina saroati sini xokupae xekeukiriai paire, sini kunaurounuku. ");
INSERT INTO six_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesusu nu xouro xowotai Xoiteupo xupo meruira purina. Xauwa xuporopu Supo Youya tetai, ekime Xauwa nukoe kunauna tuwopine xeyai sie, ximine kusauwati takieni xekoto iyeseteunuku. ");
INSERT INTO six_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tepiti nu Yesusue mena xouro xowotai sie xowopu xuwe. Pana Tepitie ipaki kunauna, ‘Kokaipae yeu kokaipa ipaki kauna, “Ne yeu xupi meruira misauporo ");
INSERT INTO six_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","neu xiwayanimana naki irue soinitiki puropineriwotai,” ’ xetai. ");
INSERT INTO six_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pa xati tini xokupa Israil kini, tini paire atinari sipawakuai, tini Yesusu na nikitoto xosa warikiriaia, Xoiteue tumuworati Kokaipa purina, nukou xuiapu sonikepina apu purina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Xuiapue Pitapu kuna iyeseria, pa kunae xonikikemu tupo xiri worotai. Kakati Pita xeika kireu Yesusupo tiantianuwopi xeika ipaki kotonikineri, “Yewapu xura, sini amakepinukuna?” niketai. ");
INSERT INTO six_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kakeri Pitae ipaki kanikina, “Tini mua xokupa apu, kireni kirenie xotiki pirixinari Yesusu wenumurei ene isari, Xoiteue tinipo xunu weteritikepina. Tini panumu kakaria, Xoiteue nuko Supo Youya tikepina. ");
INSERT INTO six_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ekime Xoiteue tini xeika, takipo nono teu xeika, xetauro puroteneai xuiapu xeika Supo Youya tikepure sokisoki kuna kunawoyai. Xoiteu, sikou kokaipa, nukoe yainiketai xuiapu Supo Youya tinikepure sokisoki kuna kunawoyai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitae kireu xokupa kuna rania tinikina, sokisoki kuna ipaki kanikina, “Sosopa epixa. Tini atinari sosopa epixakuai, mua apimi xoxixoxi kapia erirouneri xeika xoxi xaku,” niketai. ");
INSERT INTO six_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitapu kunae xokupa xuiapu nikau xonikikemu tupo worati, Yesusu wenumurei ene iseteneai. Pa asau xosa 3,000 xuiapu siei Yesusure xoniki pirixeteneai xuiapu teu xeika moteneai. ");
INSERT INTO six_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Xuiapue Yesusupo tianutianuwopi nikau taitai kuna iyeseri, kireu tianikepi kapia xeika, kou kununu xoye nepi kapia xeika, kunikuniwopi kapia xeikaure taitainiketeneai. ");
INSERT INTO six_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Xoiteue Yesusupo tianutianuwopi xupunikiro xonuxonu xonuxonu kapia ereri, xokupa kireni kireni xuiapue xekeri ureuneri ximiketeneai. ");
INSERT INTO six_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Xokupa xuiapu Yesusure xoniki suwoteneaie xiri xoniki tumaxi puroteneai. Kakineri ninipo xokupa sapi paiya Yesusure xoniki suwoteneai xuiapu nikau xetai. ");
INSERT INTO six_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Apimie ninipo ou masa xeika xuru xeika isayarinikeri, paiseu xe tineri, xokupa apimi xuru xuweu tiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Xokupa asau nini Xoiteupo atoro xirini kununurouneri. Kakineri xetaxetau atoro kirenini xoye nirouneri. Xonikikemu asinakurei nimaririneri kirenini xoye nirouneri. ");
INSERT INTO six_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xokupa yause Xoiteupo wenumu xouroxeri, xuiapue xonikemu ninire asinaku xirouneri. Xokupa asau Xoiteue kireu xuiapu tinikepi saina tetai, panumu kapiarei Yesusure xonikisuwoteneai xuiapu nikau xoka xokupani kutu xetai. ");
INSERT INTO six_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kire yause Pitano Yoninoe 3 kiloku xoruwati kunikuniwopi yause xosa, Xoiteupo Atoro xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kireu apimie kire apu siau xoxi tuku sou mori xekeniketeneai. Xokupa yause Xoiteupo Atapu isimaro, Isima Xosei xeteneai xosa xeme maneri isima turo iyarirouneri. Kakeri nue xearaure xuiapue Xoiteupo Atoro maneria yainikirouna. Ana kamoroni siau xoxixeki. ");
INSERT INTO six_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pitano Yoninoe Xoiteupo Atoro manepure xeri, pa apue xuruara tuwopinexerire kotonietai. ");
INSERT INTO six_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kakati Pitano Yoninoe soki kukou purineri, Pitae kunauna, “Ne sini xekesike,” wotai. ");
INSERT INTO six_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kakati pa apue sokisoki kukonietai, pa amure, nue nanuwotaia, ninie kire sapi siepineri xina kaketai. ");
INSERT INTO six_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kakati Pitae ipaki kunauna, “Ye xe xuwena pana, ye mua sapi tuku, ne tinepure xine. Nasaretipo Yesusu Kristusupo wenumurei ye kanine, ne sarounau texe,” wotai. ");
INSERT INTO six_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pitae kakerina xupo meruira xaike tina saretai. Kakati sapauni nupo siau xeika xoutapa xeika sokisoki xetai. ");
INSERT INTO six_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kakati pa apue potirouna texetai. Xoiteupo atoro Pitano Yonino xeika ma texina popotipopotixina Xoiteupo wenumu xouroretai. ");
INSERT INTO six_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Xokupa xuiapue xekoria Xoiteupo wenumu xourori texati, ");
INSERT INTO six_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sipauneri, pa apue sore Xoiteupo Atapu isima, Isima Xosei xeteneairo misirouna xearaure yaxirouna xi sipawoteneai. Xekoria merukirati, urerineri, xouxou woreteneai. ");
INSERT INTO six_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Xuiapue pa kapia yaraxetaire kuna iyeserineri ureri pa apu xekopure keikei koteneai. Ma xekoria Xoiteupo Atapu misepi iri, Solomonipo misepi iri xeteneairo Pitano Yonino soki xonikinikina tumu purotai. ");
INSERT INTO six_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pitae xuiapu xekeniki puri, ipaki kunauna, “Tini Israili apimi, tini ama mua kapia yaraxetaire ureunukuna? Tini ama sini sokisoki kukosikinukuna? Tini nanunuku, nioini kokaipa sokisoki tukue Xoiteupo ekero ati purineri mua apu atiwori texinaxi, nanunukure, wo? Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Apraxamu xura, Aisaki xura Yekopu xuranikau Xoiteu, sikou asisikimana nikau Xoiteu, nue nukou saina apu Yesusu kokaipa wenumuni kutu tuwotai. Pa apu sore takie xiwai xupunikiro iyarikiriai. Pailatie wetepure xetai yausepa, takie nikitiki tuwori kunaunuku Pailati ne wetau nu aini pepei xowoxete xikiriai. ");
INSERT INTO six_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mua apu nu siomou nu Xoiteu irue asinaku kapiani kutu kaki purirouna. Pana takieni nikitiki tuworinuku, kire apu nu apu ouweirouna Pailatie wetati maiyetikepinaure yaukiriai. ");
INSERT INTO six_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nu ekisikioma puropu imero sosiki xowopina akereki apu takie ouwari xumotai. Kakari Xoiteue kopaupuropu sarati, sioini kutu xekeuyatiai paire kunaunua. ");
INSERT INTO six_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pa amure, sini Yesusupo wenumurei sore xosisuyatiai xati, Yesusue tini sipaukiriai apu merukeretai. Kakati takipo xekitikieni xekuari asinaku purina. ");
INSERT INTO six_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Suwau, yewapu xura, ye sipa, tini takipo tumu xeikae ati sipawopu xuwe xati pa kapia Yesusu xosa kakikiriai. ");
INSERT INTO six_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ekime Xoiteue xokupa kunatureture supunikerei kunauna, pa apu tumuworitia ikou xuiapu xiyeri sonikepure, tatau xemeropina xeyai. Pa xati tinie mua kapia tikiriaia, Xoiteue nukou kuna taina kakina. ");
INSERT INTO six_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Pa xati tinipo xoxi nanunanu wetinari, xotiki pirixari Xoiteue tinipo xunu xesauweri tikepina. ");
INSERT INTO six_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tini panumu kakinaria, Kokaipae tini oma sokisoki tikepina. Kakinapa nukou xuiapu xiyeri sonikepure tumuworetai apu xesawatia, tini xosa kopina. Pa apu Xoiteue tini tianitikepure tumuworetai apua, Yesusu kireni. ");
INSERT INTO six_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ekime nukou saina teruwopinerire tumunikereyai kunatureture nikau supinikirei kunawoyai sie, nu mena xouro purina, Xoiteue xokupa sapi xiyeri oma xepinerire iyareyai yause yakuna. ");
INSERT INTO six_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Ekime Mosesie ipaki kunauna, ‘Takipo Xoiteu, Kokaipae, kire takipo xatatiki tumuworatia, iko sie kunatureture xepina. Kakatia nue xokupa kuna katikatia iyesakuai xeyai. ");
INSERT INTO six_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Xokupa apue pa kunatureturepu kuna iyesepu xuweuworia, Xoiteue ounikiati xumopineri. Nini Israil xuiapu teu pani xiyeri puropuworixe.’ ");
INSERT INTO six_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ekime xokupa kunatureturei Xoiteupo kuna uteiwoniai, kunatureture Samueli nukoe akerati nu turopue rania kunawoniaia, mua itou yaraxina. ");
INSERT INTO six_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Tini kunatureture teu nikau nonomi, Xoiteue asitikimana xeika xoukemu tumaxina sokisoki kuna kunawoyai sapia tinie takuai. Nue Apraxamu ipaki kauna, ‘Neu asini nono parei xokupa ouropu xuiapu teu atinikepinewoyai.’ ");
INSERT INTO six_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Paire Xoiteue nupo pa saina apue, tini xokupa kirenikireni apu atitikina tianitikati tinipo kapia xoxi wetakuaire sarina tini xosa akeri xesawati kotai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitano Yoninoe xuiapu xeika xemu kunau puroria, xuria titi teu xeika Satusi xeika Xoiteupo Atapu xokai nikau kire tumu xeikae moteneai. ");
INSERT INTO six_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pitano Yoninoe xuiapu ipaki kanikineri, Yesusu kopaupurei sarotaina, xokupa apu xumoteneai rania saropineri xineri kanikeri sipawoteneai. Paire ere makarineri, ");
INSERT INTO six_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","soki tinikineri kuna xosa iyainikerepure xeteneai. Pana asau iriropure xati, iyatieye kakepure kakauya xosa yainikereteneai. ");
INSERT INTO six_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Xokupa xuiapue kuna iyesieineri Yesusure xoniki suwoteneai. Yesusure xonikisuwoteneai xuiapu nikau xoka 5,000 sie xouro manetai. ");
INSERT INTO six_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xurise kire asau xosa Yuta nikau kokaipa apu teu xeika muris atapu tumu teu xeika tu xotapa sipa apu teu xeikae Yerusalemu kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ere xuriatiti Anasie, Kaiapas xura, Yoni xura, Aleksanta xura xeika xuriatitipo xokupa apu teu xeikae kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pitano Yonino nini ekinikiro tumunierineri, ipaki kotonikineri, “Tinie amukau sokisoki tiniku mua kapia kakinukuna? Yupo wenumurei kakinukuna,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Xoiteupo Supo Youyae Pita xosa koxati, ipaki kanikina, “Tini Israilipo kokaipa apimi xeika, muris atapu tumu xeika, ");
INSERT INTO six_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","sinie kire apu siau xoxi tianuyatiaire ximine kotosiepure xinukure. Pa xeika pa apu nu amaki asinaku xetai tinie sipawopure xinukure. ");
INSERT INTO six_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Panumu xatia, Nasaretipo Yesusu Kristusupo wenumurei mua apu siau xoxi asinakuweina mua taki ekitikiro tumu purotai, tini xokupae sipawari, Israilipo xokupae rania sipawopineri. Takie Yesusu na nikitoto xosa warari, Xoiteue kopaupuropu xiyeri saretai. ");
INSERT INTO six_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesusua ‘tini ata xuxue pa xe xoxi parinuku xesauweikiriai. Pana muaiya nu ata masa sokisoki wopina xe xiri asinaku xina.’ ");
INSERT INTO six_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kire apue sini xiyeri sosikepu watixe. Xuwe. Yesusu Kristusu wenumurei kireni sini ouropu xuiapu asinaku puropu. Siko tisikepinaure Xoiteue nu kireni tumuworetai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kokaipa apimi nini sipa, Pitano Yonino nini xaya ata manepu xuwena nini aipu apu. Xekenikeria ximikepu xuweu sokisoki kuna kunawori, xokupa nanunanu teteneai. Kakerineri Pitano Yonino sipaniketeneai, nini ekime Yesusu xeika puroniai. ");
INSERT INTO six_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pa apu xekoria nupo mupokemu merukirati nini xeika tumu purotai. Paire kire kuna xapa kanikepineria xuwexetai. ");
INSERT INTO six_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kokaipa apimie kanikineri tini kaunsolu ata wetinari kisau munaxa nieteneai. Nini xouwexeria, apimie ipaki kuna ouneri, ");
INSERT INTO six_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Sini mua apu aimore amu amakinikepuna? Ninie xumu xonuxonu ereri, Yerusalemupo xokupa xuiapue paire sipauweteneai. Sini ximiakerepuxe. ");
INSERT INTO six_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pana mua kuna xuiapu xosa pani xouxanauwoxete. Pa xati nini axiri sokisoki kuna kanikikiri, mua wenumurei kireu apu pani kuna tinike xeni,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yainieri moxeri kanikineri Yesusu wenumurei kire kuna pani kunaunaxari, nu wenumurei xuiapu kuna tinikaku xineri xoka tiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kakeria Pitano Yoninoe kuna xapa ipaki kanikineri, “Xoiteu ekero amu kapia asinakuxi tini nanunukuna? Sini Xoiteupo kuna taiwopinuare e tinipo kuna taiwopinua? Takieni uteiwa. ");
INSERT INTO six_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sini supusi parawopuyatixe. Sini xokupa kapia sioni xekoto iyeseteuyatiaireni kuna uteiwopinua,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Paire kaunsolue nanuneri xuiapue xaro tisikepuwori xana xuwerineri, kireu sokisoki kuna pani tinikerineri weinikiteri xowoxeteneai. Xoiteue kaketai kapiaure nanuneri xokupa xuiapue wenumu xouroreteneai. Kakeri kokaipa apimie Pitano Yonino kakauya xosa iyainikerepineri ime xuwexetai. ");
INSERT INTO six_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pitano Yoninoe pa apu xumu xonuxonu erineri atiereri asinaku xetaia nu 40 xitosani xuwexetai. ");
INSERT INTO six_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaunsolue Pitano Yonino weinitexeria, ninipo xatanikimana xosa xiyeri xounexeri, ere xuriatiti xeika tumu teu xeika nikau xokupa kuna kaniketeneai. ");
INSERT INTO six_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ninie pa kuna iyeserineri, xonikikemu xokupa tumaxineri, Xoiteu xosa ipaki kunikunineri, “Kokaipa, nakie mena iyarine, ou iyarine, xasi sarine xokupa sapi pa xosa puroteneai iyariyai. ");
INSERT INTO six_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ekime nakipo Supuni Youyoe sinipo asisiki kire kuna tuwoyai, nu nakipo saina apu Tepiti. Kakati Tepitie ipaki kunauna, ‘Amakati xokupa xetau apimie xiri kisamaira nikinana? Amakati mua xuimi apimie xoxi kapia aini kakepure kuna ounerina? ");
INSERT INTO six_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sanawasanawapu kokemue xomaxepure ireineri. Tumu teue Kokaipa ororineri, pa apu nukou xuiapu tinikepinaure tumuworetai ororepure kirenini kunununeri,’ xetai. ");
INSERT INTO six_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Suwauni kutu, Erotino Pontiasi Pailatinoe xetau apimi teu xeika Israil apimi xeika pa erewese kunununeri, nakipo saina terinepinaure ekime tumuworiyai apu Yesusu ororepure xineri. ");
INSERT INTO six_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nakieni kakepure xiyai nanunanu taineri, mua kapia teteneai. Nakipo sokisokirei ekime nakieni kuna oune mua kapia yaraxepina xiyai. ");
INSERT INTO six_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Paina Kokaipa, sini eise kurosikineri xokupa kuna kunawoteneai nanunanunau sini neu saina apu tianisike. Kakauwa sini ximikepu xuweu, neu kuna sokisoki uteiwopinuku. ");
INSERT INTO six_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Supa apimi xosa nakipo xupuni iyarau xiyeri merukeria, nakipo xokumo saina apu Yesusu wenumurei xumu xonuxonu kapia erewaixi kunikuni,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kunikunieria, kununuwoteneai ata litowotai. Kakati Xoiteupo Supo Youyae nini xosa koxati, ximikepu xuweu Xoiteupo kuna pani sokisoki xineri uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Xokupa xuimiapimi Yesusure xonikisuwoteneaie, xoniki tumaxineri kireni nanunanu tuku xeteneai. Kire apue nupo kire sapi xekeri ipaki kunauna, “Pa sapia ikou kireni,” xepu watixe. Xuwe. Ninipo xokupa sapia niko xokupa nikau kireni. ");
INSERT INTO six_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yesusupo tianutianuwopie Kokaipa Yesusue xiyeri sarotaire kuna uteiwopi saina teri, ninipo kuna kokaipa sokisoki tuku xetai. Kakeri Xoiteue pa xuiapu tianikepure ere xouwenikina, asinaku kapiani kutu nini xosa kaketai. ");
INSERT INTO six_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kire nini xopuropue xuru ara xuweitauwotaixe. Xokupa apimi nini ou tukure ata tukua, kireu apimi xosa xesauneri pa xosaupo xe tirouneri. ");
INSERT INTO six_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kakineri pa xe tikouneria, Yesusupo tianutianuwopi tinikirouneri, kakeri ninie xuiapu xuru xuweu puroteneai uteineri tinikirouneri. ");
INSERT INTO six_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kire apu purotai, nupo wenumu Yosepu. Yesusupo tianutianuwopie kire wenumu tuneri Parnapasi woteneai. Parnapasi wenumua mua kuna sie, “Xosikikemu sokisoki xepina apu,” xina. Parnapasi nu kire Liwai, nu Saiprusi souropu. ");
INSERT INTO six_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nupo kire ou masa kire apu xosa xesawotai. Pa xe tikouna Yesusupo tianutianuwopi tiniketai. ");
INSERT INTO six_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kire apu purotai, nupo wenumu Ananaiasi, nupo xuipo wenumu Sapaira. Ananaiasie nupo kire ou masa kire apu xosa xesawotai. ");
INSERT INTO six_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Xe tinapa uteina, kireira xe masa paiya nukouni iyaretai. Kakati nupo xuie rania sipawotai. Ananaiasie kakerinapa ipaki xoreixina, xokupa tikoune Yesusupo tianutianuwopi tinikitiai xetai. ");
INSERT INTO six_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kakati Pitae ipaki kauna, “Ananaiasi, amakati Satani wetau xoniro xokoperina, Xoiteupo Supo Youya xoreuwopure, neu ou xosaupo xe tine kireira xe masa ximiakeritiaina? ");
INSERT INTO six_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nakieni pa ou xesaune xe titiaina, pa xosaupo xe titiai rania neu sapina, amu amakepurepa kake. Amakati pa xoxi nanunanu titiaina? Ne kaki xanau nanunau apimi kireni xoreinikepure xine xeu. Xuwe. Ne Xoiteuni xoreuwopure xine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaiasie pa kuna iyeserina titikiri xouna sapauni xumurotai. Apimie Ananaias xosa akipa xetai kapiaure iyeserineri xiri ximikieteneai. ");
INSERT INTO six_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Apu tenemai teue maneri Ananaias mou marie xotorineri, xeme tixou upuworoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yause xuwauratia, Ananaiasipo xuie xamu xosa kapia akipa xetai sipawopu xuweu motai. ");
INSERT INTO six_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Moati Pitae ipaki kauna, “Ne ye kaye, tinipo ou xosaupo xe tiatiai pa kirenire?” wotai. Kakati xuie kunauna, “Paiya suwau. Pa kireni,” wotai. ");
INSERT INTO six_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kakati Pitae ipaki kauna, “Tini amakati Kokaipapu Supo Youya eruruwopure kuna ouyatiaina? Iyese. Neu xamuni upuworoteneai apimi isimaro manerina, ne rania xemeini xowopineri,” wotai. ");
INSERT INTO six_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kakati pa xuie sapauni Pitapu siau sakaro titikiri xouna xumurotai. Apu tenemai teue maneri, pa xui xekoria xumurotai. Pani xeme tixouneri xamu upu kikimuro upuareteneai. ");
INSERT INTO six_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Paire Xoiteure xonikisurouneri xokupa xuiapu xeika xetau xuimiapimi xeikae pa kapia akipa xetaire kuna iyeserineri, xiri ximikieteneai. ");
INSERT INTO six_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesusupo tianutianuwopie xuiapu xopu xetaxetau xumu xonuxonu ereteneai. Kakeri xokupa xuiapue Xoiteure xonikisuneri, xonikikemu tumaxineri Xoiteupo ata tumau maneri Solomonipo kununuwopi xiri xosa kununurouneri. ");
INSERT INTO six_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kakeri nini xopu puropu xuweu xuiapue, ninipo weniniki xourorirouneri. Kakirounerina pana ximikerineri, nini xeika ma kununurouwori xana xuwe. ");
INSERT INTO six_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pana xokupa xuiapuni kutue Kokaipaure xonikisuneri, nupo apu kini xosa moteneai. ");
INSERT INTO six_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yesusupo tianutianuwopie xumu xonuxonu ereri xuiapue sipawoteneai. Pa xati supa tuku tuku xuiapu xurunikineri kisau Pitae teipa kourouna ime mayau konoyau sakayau xineinikirouneri, pa amure, asaue Pitapu xeniroroi woratia supa apimi xosa xowopinaure kaketeneai. ");
INSERT INTO six_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yerusalemu tomuro puroteneai erewesepu xuiapue rania, Yesusupo tianutianuwopi xekenikepure koteneai. Supa tuku apimi xeika xoxi yaniyanie xoxixoxi niketai apimi xeika xuruniki koteneai. Kakeri pa xokupa xuimi apimie xiyeri meruketeneai. ");
INSERT INTO six_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ere xuriatitie nupo emeumana Satusi apimi xeikae, Yesusupo tianutianuwopie kaketeneai kapia xekerineri paire ekinikie nineri xonikikemu xiri xoxixoxi xetai. ");
INSERT INTO six_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kakeri Yesusupo tianutianuwopi soki tinikineri apimi xoxi xeika kakauya xosa soiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kakeria ukumani kire Kokaipapu xenikorokoroe kakauya atapu isima taiyeina kisau sonikimana, ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tini xounari Xoiteupo atapu sepurireira tumunari, mua oma puropi suire xuiapu kanika,” niketai. ");
INSERT INTO six_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesusupo tianutianuwopie iyeserineri xoripesauni kutu Xoiteupo Ata xouneri, xuiapu kuna tinikepi saina teteneai. Kakeri ere xuriatitie nupo emeumanapu, kaunsolu xeika Israilipo xokupa tumu teu xeika yainikeri kou kununuwoteneai. Kakerineri Yesusupo tianutianuwopi soniki kopinerire, kakauya ata kuna xesawoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Xokaie kakauya ata xowoteneai sorena, Yesusupo tianutianuwopie purori xekenikepu xuwe. Xiyeri xouneri kokaipa apimi ipaki kanikineri, ");
INSERT INTO six_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sini kakauya atapu xokupa isima xekeukiria, sokisoki kiritieineri ata yayakue xokupa isima yayakuwoteneai. Kaketeneaina pana sini isima taikiriaia kire apue ata kamoro purati xekopu xuwe,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Xoiteupo Atapu xokai nikau tumu xeika ere xuriatiti xeikae pa kuna iyeserineri xokupa nanunanu teri ipaki kunauneri, “Pa apimia amaki xauweteneaina?” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kakeria kire apue mana ipaki kanikina, “Iyesa. Pa apimi tinie kakauya ata soinikikiriaia, Xoiteupo ata tumaureira tumu purineri xuiapu Xoiteupo kuna tinikineri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kaki kanikati, Xoiteupo Atapu xokai nikau tumu xeika xokai xeikae xouneri Yesusupo tiantianuwopi soniki koteneai. Kouneri nini amakinikepu xuwe. Xuiapue xe kurunikepineri xati, ximiketeneai. ");
INSERT INTO six_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Xokai teue Yesusupo tianutianuwopi soniki kouneri kaunsolu ekinikiro tumunikereteneai. Kakeri ere xuriatitie ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sini xiri xoka tikinuku tini kaki xanari pa apu wenumurei xuiapu kuna kanikaku xikiriai. Pana tinie kuna uteiwopi saina pani tari, Yerusalemu purixanau woteneai xuiapue tinipo kuna iyesieteneai. Kakinuku sinie pa apu ouweikiriai xi kuna xosasiki suwopure xinuku,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kakeri Pita xeika kireu Yesusupo tianutianuwopi xeikae ipaki kuna xapa kanikineri, “Sini Xoiteupo kuna kireni taiwopinukuna, sini apu nikau kuna taiwopukiri xana xuwe. ");
INSERT INTO six_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tinie Yesusu kire na xosa warinuku ouwari xumotaina, pana asisikimana nikau Xoiteue xiyeri saretai. ");
INSERT INTO six_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kakerina xouro sou xouna nukou xupo meruira iyarati purina. Nue siko ime atarisikina xiyeri tisikinapa, siko Israil tianisikati xosiki pirixikiria, sikou xunu weterisikepina apu. ");
INSERT INTO six_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sini Xoiteue kaketai xokupa kapia xekerinuku, paire kuna uteirounuku. Xoiteupo Supo Youyae rania pa xokupa kapiaure kuna uteina. Xuiapue Xoiteupo kuna taiwori Xoiteu nukoie Supo Youya tinikeyai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsolue Pitapu kuna iyeserineri, xiri kisamairanikirati, Yesusupo tianutianuwopi ounikiepure xeteneai. ");
INSERT INTO six_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kakeri kire kaunsolue sarotai. Nu kire Parisipo apu, nupo wenumu Kamalieli. Nu tu xotapapu xesepeniki, xokupa xuiapue nupo wenumu xourorirouneri. Nue apimi kanikati Yesusupo xokupa tianutianuwopi soniki munaneri kisau xayakaxayaka puroteneai. ");
INSERT INTO six_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kisau munauweria, Kamalielie kireu kaunsolu ipaki kanikina, “Tini Israilipo apimi, tini mua apimi xosa kire kapia kakepure xinaria, xeuxana ati nanunanu terinarieye niketai. ");
INSERT INTO six_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tini sipa, xuwau yause xowopu xuweni. Teutasie sarou kunauna, ‘Iko kokai apu, ye wenimi tuku,’ xetai. Kakati 400 apu siei nu taiwoteneai. Paire kapmanie ouwati xumati, nure xonikisuwoteneai apimie ximi xouxanauwori ninipo saina aini xuwexetai. ");
INSERT INTO six_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Xurise kapmanie xuiapu weniniki xuruwotai yause xosa, Kalilipo Yutasie sarouna xuiapu nikau nanunanu tururutarara wotai. Kakati nu taineri kapmani xesawopure xoma sareteneai. Pana nu ouweri xumati, nure xonikisuwoteneai apimie, ximi xouxanauwoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pa xati ye muaini katikine, tini kaki xanari mua apimi xosa kire kapia kakaku. Xuwe. Nini weinikitari pura. Mua saina ninie teteneai pa apu nikau nanunanurei sarotai xatia, saina xoxixepina. ");
INSERT INTO six_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pana Xoiteue mua saina saretai xatia, tini taiyerinikakuaixe. Panumu tini Xoiteu ouwaku!” niketai. Kakati kaunsolue Kamalielipo kuna taiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaunsolue Yesusupo tianutianuwopi yainikeri moria, xokai teu kanikeri kasiniketeneai. Kakeri kanikineri tini Yesusupo wenumurei kaki xanari pani kuna uteiwaku niketeneai. Kunari weinikiteri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesusupo tianutianuwopie kaunsolu weinikiterineri kisau munoteneai. Xoiteue nanuna Yesusu wenumurei maya tepineri xetai sie maya terineri nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Xokupa asau Yesusupo tianutianuwopie Xoiteupo Ata xeika xuiapu nikau atayau xeika xouneri, xuiapu kuna tinikirouneri. Nini asinaku kuna uteiwopi saina wetepu xuwe. Kuna ipaki piteu kanikineri, “Yesusu apua nu Xoiteue nukou xuiapu xiyeri tinikepinaure sokisoki kuna kunawoyai,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pa yause xosa Yesusupo tataiwopi nikau xoka paiya pani xokupa xetai. Kriki kuna kunaurouneri tataiwopie Aramu kuna kunaurouneri tataiwopi xeika kawata xeteneai. Ipaki kunauneri, “Xokupa asau tinie xuiapu xoye ara xuweuwoteneai tinikirounukuna pana, sinipo xuimi xamunikimana xumuweki, tianikirouwari xana xuwe,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kakeri 12-teu tianutianuwopie xokupa tataiwopi yainikeri moria, ipaki kanikineri, “Sikoe Xoiteupo kuna uteiwopi saina wetinuku xoye uteiwopi saina tikiria, pa itou xuwexepina. ");
INSERT INTO six_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pa xati yewapu xura, taki xopuropu apu 7-teu xireki tinika, nini xuiapu xopu asinaku weniniki tuku, Xoiteupo Supo Youyae nini xosa koxetai nini asinaku sipa tuku. Sini pa apu teu iyainikerikiri pa saina yakuwopineri. ");
INSERT INTO six_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sini paiya xokupa yause kunikuniwopi saina tete Xoiteupo kuna xuiapu tianikete wopinuku,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Xokupa xuiapue Yesusupo tianutianuwopi nikau kuna asinaku xonikiewoteneai. Kakerineri Stiweni tumuworeteneai, nu sokisoki xousu tuku, Xoiteupo Supo Youyae nu xosa koxetai. Pani Pilipu xura, Prokorus xura, Nikanor xura, Timon xura, Parmenas xura, Nikolas xura tumunikereteneai. Nikolas apua nu Antiokupo, nu Yutapu xuwena pana, ninipo muris tairouna. ");
INSERT INTO six_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yesusupo tianutianuwopi ekinikiro pa apimi tumunikereri, pa saina tepinerire xupuniki xosaniki sorineri kunikuni niketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xoiteupo kunae Yerusalemu sanawayau koxetai. Kakati xokupa xuiapuni kutue Yerusalemu Yesusupo tataiwopi sayeteneai. Kakeri xokupa xuriatitie rania Xoiteupo kuna taineri xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pana Xoiteue xiri xousuawati xouwesikirouna sokisoki kapia xeika xuru xonuxonu kapia erirouna kapiapu sokisoki xeika Stiweni xosa purati, Stiwenie xuiapu xopu kokaipa kokaipa xumu xonuxonu erirouna. ");
INSERT INTO six_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kakati kireu apimie saneri Stiweni xeika kuna tuwata xeteneai. Nini paiya Yuta nikau kire kununu atapu apimi, pa ata wenumu apu so nikau kununu ata xeteneai. Nini erewese Sairinipo apimi xeika Aleksantriapu apimi xeikae. Pa xeika aimore propinsipo. Silisiapu xeika Esiapu apimi xeikae kaketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Xoiteupo Supo Youyae Stiweni asinaku sipani kutu tuwati, nupo kunaini nini emeseriniketai. ");
INSERT INTO six_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Paire kireu apimie xorei kuna ipaki kunauneria, “Stiwenie Xoiteuno Mosesino ninianietai xi kunawopinerire,” ximiarei xakuxakuniketeneai. ");
INSERT INTO six_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pa kapiarei xuiapu nikau xoniki xusineri, tumu nikau xusineri, tu xotapa nikau xusineri woteneai. Kakeri, Stiweni xosa xouneri soki xorou tineri kaunsolu xosa sou xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kakineri kireu apimie xorei kunae xoniki xusepinerire tumunikereteneai. Kakeri pa apu teue ipaki kunauneri, “Xokupa xokupa yause mua apue Xoiteupo Ata niniawoto tuxotapa niniawotourouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Pani iyesikiria ipaki kunauna, ‘Pa apu Nasaretipo Yesusue mua ata xoxierinapa Mosesie ekime sikeyai kapia pirierepine xetai xineri,’ ” kunawoteneai. ");
INSERT INTO six_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kakeri xokupa kaunsolue Stiweni sokisoki kukoworia, nupo moakemue kire xenikorokoropu moakemue uyewotai. ");
INSERT INTO six_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ere xuriatitie Stiweni ipaki kotouna, “Apimie mua kuna ne xosa suwoteneaia suwaure, e xoreinineri?” wotai. ");
INSERT INTO six_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kakati Stiwenie ipaki kunauna, “Yewapu xura xauwa xura, tini iyesa, sikou asisiki Apraxamue erewese Aran xowopu xuweuni Mesepotemia puroyai yause xosa, mena xouropu Xoiteu nu kokaipa sokisoki tukue Apraxamu maiyewoyai. ");
INSERT INTO six_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xoiteue ipaki kauna, ‘Ne neu ou wetinau xatanimana weinikiterinau, kire ou atarinepine xosa xouwo,’ woyai. ");
INSERT INTO six_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kakati Apraxamue Kaltia nikau ou wetina Aran xou puroyai. Omo xumuratia, Xoiteue xesawati kouna mua ou, tini purikiriai xosa puroyai. ");
INSERT INTO six_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Xoiteue mua kire ou masa ara kireni nuxuto sie, Apraxamupo apu kinipo ouni kutu puropinaure nu tuwopu xuwe. Sokisoki kuna kunauna sewai mua ou Apraxamu tutia, nuko xeika nukou nonomi xeika nikau ou puropina xeyai. Xoiteue mua kuna kunawoyai yausepa Apraxamu nu nono xuweu. ");
INSERT INTO six_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xoiteue Apraxamu ipaki kauna, ‘Neu asinimanae kireu nikau sanawa xouneria puropineri. Xouneri aipu saina apimi puroria, xetau apimie 400 xitosani xosa xoxixoxi nikepineri. ");
INSERT INTO six_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pana pa xoxixoxi kapia teteneai apimia sewai kuna xosa tumunikerepine. Kakitia sewai Apraxamupo nonomie pa sanawa weti kouneria, mua wese iko xosa muris tepineri xeyai. ");
INSERT INTO six_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xoiteue kunauna yei Apraxamu xeika lixine xoikemu sokisoki tuyai xati maritakepina xeyai. Xurise Apraxamue Aisaki omo xina, 8-teu asau xosa Aisaki maritakeru woyai. Aisakie Yekopu omo xati, Yekopue asisikimana 12-teu nikau eminiki xeyai. ");
INSERT INTO six_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Pa asisikimanae xameyaniki, Yosepure xoxi nanunanu terineri, aipu saina apu sie xesawori xetau apimi xosa xowoyai. Kakeri, pa apimie Isipu sou xowoniai. Kakeri, Xoiteue nu xeika puroyai. ");
INSERT INTO six_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xoiteue tianu wati nupo xokupa xu xuweieyai. Kakati Yosepue Isipupo kokemu xeika kunakuna wati, Xoiteue asinaku sipa tuwati kokemue nu xouwewoyai. Pa kokemue nu tumuworati Isipupo akereki kapmani purina, kokemupo atoropu xokupa xuru yakuworuwoyai. ");
INSERT INTO six_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Xurise xokupa Isipu sanawa xeika Kenan sanawa xeika mause yause xati, xokupa xuiapu xoye xuweitau nikeyai. Kakati sikou asisikimana xoye xuweitau nikeyai. ");
INSERT INTO six_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yekopue Isipu wit purina kuna iyeserina, kopou asisikimana xesanikati xowoniai. ");
INSERT INTO six_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xiyerineri xowoniai yause xosa, Yosepue oamana ipaki kanikina, ‘Ye Yosepue,’ nikeyai. Kakati kokemue rania xurise Yosepupo oamana sipanikeyai. ");
INSERT INTO six_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosepue omo Yekopu kuna xesaruwati, nupo xuiapu 75-teu sie xeikae kouyewoniai. ");
INSERT INTO six_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yekopue Isipu xowoyai. Purixana xumatia, sikou asisikimana rania xumuweneai. ");
INSERT INTO six_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kakeri, erewese Sekem xiyeri xemeiniki xouneri ekime Apraxamue Amorupo nono nikau kopa upu isayawoyai xosa upuainikeneai. ");
INSERT INTO six_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Paina ekime Xoiteue Apraxamu sokisoki kuna kawoyai yause putawopure tomuroirotai. Kakati Israil apimi Isipu puroniaia xiri inainauweneai. ");
INSERT INTO six_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Xurise kire apue Isipupo kokemu puroyaia, nu Yosepu sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pa kokemue sikou xuiapu kini xorexoreinikina xoxixoxi kapia tinikirouna. Nue kunawati nono misiarara xumopinerire purereinikeneai. ");
INSERT INTO six_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pa yause xosa Mosesipo anae Mosesi iyareyai. Nu nono xoseiara xati Xoiteue xouwewoyai. Kakati omopu atoro Moses xeimore poita xosa yakuwoneai. ");
INSERT INTO six_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Xurise kisau iyareri purati, kokemupo mokei tina nukou nononi kutu sie yakuwoyai. ");
INSERT INTO six_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kakati Mosesie Isipu nikau xokupa asinaku sipa tieina, sokisoki kuna tua saina xokupa sokisoki saina tua sayeyai. ");
INSERT INTO six_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mosesipo xitosani 40-teu xatia, nukou xataumana Israil apimi xekenikepure nanunanu woyai. ");
INSERT INTO six_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mosesie xekoatia, kire Isipupo apue kire Israilipo apuara xoxi kapia tiwotai. Kakati, Mosesie pa Israilipo apu tianuworina, xoma xapa tina pa Isipupo apu ouwati xumoyai. ");
INSERT INTO six_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesie nanuwotaia, Xoiteue Moses xuporei tianisikepure xina xi xataimanae sipawopineri xeyai. Paire nini sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kire asau xosa, Mosesie xekoatia Israilipo apu aimorei waraxeteneai. Kakexeri putaraniepure xona kunauna, ‘Ei eri xatauno. Tini ama taitai waraxinuana?’ nieyai. ");
INSERT INTO six_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kakati pa apu poripori xotapae Moses xiyeri wasuwetai. Kakeri kunauna, ‘Yue kanati sinipo tumu saine kuna xekexeke sainena? ");
INSERT INTO six_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Xorise kire Isipupo ouweitiai sie ye ouwiyepure xinere, wo?’ woyai. ");
INSERT INTO six_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kakati Mosesie pa kuna iyeseri ximi xouna, Mitiani nikau ouro puroyai. Poro xui tina sawai nono aimore tuku xeyai. ");
INSERT INTO six_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kakina 40-teu xitosani xouwatia, Sainai totou tomuro ou apu xuweu xosa kire xenikorokoroe Moses maiyewoyai. Nu kire na misiarapu ne teu xosaupo xepi minika xopuro puroyai. ");
INSERT INTO six_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosesie pa kapia akipaxetai xekerina xokupa nanunanu teyai. Ati xekopure nutiemu xonatia, Kokaipae ipaki kauna, ");
INSERT INTO six_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ye neu asinimana nikau Xoiteu. Ye Apraxamupo Xoiteu, Aisakipo Xoiteu, Yekopupo Xoiteu.’ Kakati Mosesie urerina xekopu ximikeyai. ");
INSERT INTO six_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kakati Xoiteue kauna, ‘Ne neu erieri xureieye, pa amure, mua ou ne tumutiaia ikouna xeseu. ");
INSERT INTO six_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ninie Isipu yeu xuiapu xokupa kapia xoxi kakinikeri xekeutiai. Ye ninipo morepi iyeserine, Israili apimi Isipu xupunikiropu sonikepure koune. Pa xati ne sarouwo. Ye Isipu xesanepure xine,’ woyai. ");
INSERT INTO six_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ximuximua Israili kinie Mosesipo supo wari ipaki kauneri, ‘Yue kanati sinipo tumu saine kuna xekexeke sainena?’ woniai. Pa apu Mosesie sore tumu saina tina, Israili xiyeri tinikepinaure Xoiteue xesawoyai. Pa xenikorokoroe na misiara xosa puroyai xati nupo kunae Moses xesauwati xowoyai. ");
INSERT INTO six_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesie Isipu weti soniki xoupopouna, 40-teu xitosani xosa xumu xonuxonu kapia Isipu erina pa Ewou Xasi xosa erina apu xuweu ou xosa eretewoyai. ");
INSERT INTO six_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pa Mosesie sore Israili ipaki kanikina, ‘Xoiteue tinipo kire xatatiki tumuworatia, iko sie kunatureture puropina,’ xeyai. ");
INSERT INTO six_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Xurise sikou asisikimanae apu xuweu ou xosa utu kununuwori, pa Mosesie sore nini xeika puroyai. Kakina Sainai totou xouro xowati, xenikorokoroe kuna tuwoyai. Nue Xoiteupo kuna ekeoma tuku tina siko sikeyai. ");
INSERT INTO six_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kakatia, sikou asisikimanae Mosesipo kuna iyesepu xirexeniai. Xuwe. Nupo kuna supo warineri, ninipo xonikikemuepa Isipu xiyeri xowopure xeniai. ");
INSERT INTO six_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aroni ipaki kauneri, ‘Pa apu Mosesie Isipupo sosiki kotaia amu amakinarauna sini sipa xuwe. Pa xati nei xoiteu erinau sikau, ninie akerineri ime atarisikepineri,’ woniai. ");
INSERT INTO six_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Pa yause xosa kire pulmakau ara kesirou tumuworineri, pa oropu xoiteu xouineri noto ouneri xuria teneai. Kakerineri, nikou xupunikieni kesiwoniai sapire nimaririwoniai. ");
INSERT INTO six_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pa xati asau xeika, poita xeika, pai xeikaure muris tepinerire Xoiteue nike tinikeyai. Kunatureture nikau nakau xosa kuna purotai sie, ‘Tini Israili tini xiri xosa usie ukauro 40-teu xitosani purikiniai yause xosa pulmakau xeika sipsipu xeika ounuku xuria tikiniai, tini yeure xuria tikiniaire, wo? Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pa kokaipa kesia ata tinie xemekiniaia yeu kesia ata xuwe. Paiya xorei xoiteu Molekipo. Tini xorei xoiteu Repanipo paipo xenumu rania xemekiniai. Tinie pa ouropu xoiteu xeniniki xosa muris takuaire kesirou tumuworikiriai. Pa xati ye tinipo sanawa xosau xesatikitia, pira ou Papilon sanawa purotai xosa xounaria purakuai.’ ");
INSERT INTO six_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Stiwenie pani ipaki kunaunua, “Sikou asisikimanae apu xuweu ou xosa puroniai yause xosa paiya, nini Xoiteupo kesia ata tuku. Pa ata xosa Xoiteue nukou kunani kutu yararirouna. Pa kesia ata xuwoniai yausepa, Mosesie amukau atarau” xuwopina xina Xoiteue kawotai sieni taineri xuwoniai. ");
INSERT INTO six_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Xurise asisikimana nikau nonoe pa kesia ata tineri xetau apimi nikau ou tepure Yosua xeika koniai. Kakeri, Xoiteue asisikimana nikau muanikiro pa xetau apimi xesanikeyai. Kakati, kesia ata xuworeri nuko pa ou xosa purina utu Tepitipo yause xeyai, ");
INSERT INTO six_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","pa apu Tepitia Xoiteue asinaku kapia nu xosa kakirouna. Pa xati Tepitie ipaki kunikunina, “Yekopupo Xoiteupo Ata xuwopinere? Xuwere?” xeyai. ");
INSERT INTO six_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kakeyaina pana xurise, Solomonie pa ata xuworeyai. ");
INSERT INTO six_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Xoiteu Xouroni Kutua apue xuwoniai ata yau purirouwatixe. Kunatureturei kunawoyai sie, ");
INSERT INTO six_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kokaipae ipaki kunauna, “Mena paiya yeu kokemu sai, ou paiya yeu siai iyaritiai wese. Pa xati tini amukau ata yeu xuworiyakuaina? Ye arikepine iri ana wese puropinana? ");
INSERT INTO six_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ye ikoini pa xokupa sapi iyariai,” ’ xeyai niketai. ");
INSERT INTO six_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Stiwenie kaunsolu pani kanikina, ‘Tini poripori tutua apimi. Tinipo xotikikemu xeika nanunanu xeika paiya xukumi nikau sie sokisoki xina. Tinipo xakutiki susuworati, Xoiteupo kuna iyesirouwarixe. Ekime tinipo asitikimanae kakeneai sie, tinie sipesi Xoiteupo Supo Youyapu kuna supo warounuku. ");
INSERT INTO six_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amu kunatureturei ekime purati, tinipo asitikimanae asinaku kapia nu xosa kakeniaina? Xuwe. Ninie ekime apimie ipaki kunawoniai ounikieniai, kunauneri, Apu Asinaku Kapia Kakepina, kopina xeniai. Pa apu mua koati xiwai xupunikiro iyarinuku ouwari xumotai. ");
INSERT INTO six_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tini xenikorokoro xupunikiropu Xoiteupo tu tikiriai sorena, tini taiwopu xuwe,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsolu teue Stiwenipo kunaure, xiri kisamaira nikati maikuku woroteneai. ");
INSERT INTO six_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kakeria, Xoiteupo Supo Youyae Stiweni xosa xokope xati, mena xouro eisa wotai. Xoiteupo asinaku memeremu xeika nekei xeika mena xouro xekerina, Yesusue Xoiteupo xupo meruira tumu puroto wati xekotai. ");
INSERT INTO six_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stiwenie ipaki kunauna, “Iyesa. Ye mena xekeutia taiyati, Apupo Nonoe Xoiteupo xupo meruira tumu purina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ninie pa kuna iyeserineri ere xiraxarauneri xakuniki parapara woteneai. Kakeri sauweineri keikei xona Stiweni soki xorou teteneai. ");
INSERT INTO six_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Erewese kisauira xesawori munati, ouwepure xe kuruwoteneai. Ximuximu kuna xosau suwoteneai apimie, nikou nekei xuwau xurexineri apu tenemai wenumu Solu, nu nutiemu soxeteneai. ");
INSERT INTO six_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Apimie Stiweni xosa xe kuruworia, Stiwenie ipaki kunikuni xina, “Kokaipa Yesusu ne yeu xenimi te,” xetai. ");
INSERT INTO six_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kakerina xoutapa ukurourouna sokisoki uru yaxina, “Kokaipa, ne kaki xanau ninipo xunu xapa teu,” xetai. Stiwenie kaki kunarina, xumotai. ");
INSERT INTO six_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Solu ekero, pa kapia ninie kaketeneaia asinaku xetai. Stiweni ouweteneai yause xosa xotapa taineri Yesusu taiwoteneai xuiapu Yerusalemu puroteneai xiri xoxixoxi niketeneai. Kakeri Yesusu taiwoteneai xuiapu xokupae ximi Yutia tistiriki xeika Samaria tistiriki xeikapu sanawa yau xouxanau woteneai. Yesusupo tianutianuwopia nini Yerusalemuni puroteneai. ");
INSERT INTO six_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kireu apimi nini Xoiteue xouweurouna kapia tairounerie, Stiweni upuarineri nure kokaipa morepi moroteneai. ");
INSERT INTO six_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Solua nu Yesusu tairouneri xuiapu xoxixoxi nikepi saina tetai. Ninipo atayau xouna xui xeika apu xeika tiniketai. Kakina puruniki xouna kakauyaro soiniketai. ");
INSERT INTO six_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pa xuiapu ximi xouxanau woteneaie, puroteneai wese yau asinaku kuna uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipue kire Samariapu erewese xouna, Kristusurei asinaku kuna nini xosa uteiwotai. ");
INSERT INTO six_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Xokupa xuiapuni kutue Pilipupo kuna iyesete xumu xonuxonu kapia kakati xekotouneri, nupo kuna xosa ati xakuniki iyareteneai. ");
INSERT INTO six_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilipue xokupa xuiapu xosanikipo xoxi yaniyani xesanikati xekoria, pa yaniyani teue xoxi xiraxarauweineri weniki xowoteneai. Xokupa apu einiki xumuna sianiki xoxixekie, xiyeri meruketeneai. ");
INSERT INTO six_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Paire pa erewesepu xuiapue kokaipa nimariri nimariri woteneai. ");
INSERT INTO six_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kire apue pa erewese purotai, nupo wenumu Saimoni. Ekime nue kireu tianikete xoxixoxiniketewopure osauna xoxixoxi yaniyani yainikirouna, kakati Samariapu xuiapue xekeri xokupa nanunanu teteneai. Nue ipaki kunauna, “Ye kokaipa apu,” xirouna. ");
INSERT INTO six_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kakati xokupa kokaipa apimi xeika kireu aipu xuimi apimi xeikae rania Saimonipo kuna iyesepure xeteneai. Ninie ipaki kunauneri, “Muaiya, kire Xoiteupo sokisoki, wenuneri Kokaipa Sokisokini Kutu, nue Saimoni xosa purina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nupo kuna sokisoki iyeseteneaia, pa amure, xokupa yause xekoria xetau kapiani kutu kakati xokupa nanunanu tirouneri. ");
INSERT INTO six_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pana Pilipue Xoiteue xuiapu yakunikepina yauseure asinaku kuna xeika Yesusu Kristusupo wenumu xeikaure uteiwatia, xuimi xeika apimi xeikae xonikisuneri Yesusupo wenumurei ene iseteneai. ");
INSERT INTO six_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimonie rania xousuna Yesusupo wenumurei ene isetai. Kakerina Pilipu xeika texineri Pilipue kokaipa xumu xonuxonu kapia kakixanau wati xekerina xokupa nanunanu tetai. ");
INSERT INTO six_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalemu puroteneai Yesusupo tianutianuwopie, Samaria apimie Xoiteupo kuna teneai kuna iyeseteneai. Pa xati Yonino Pitano xesanieri nini xouyeniketeneai. ");
INSERT INTO six_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Utu putarinexeri, Xoiteue Supo Youya pa Samaria apimi tinikepinaure kunikuniwoxeteneai, ");
INSERT INTO six_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","pa amure, Xoiteupo Supo Youyae nini xosa kopu xuwe, ai Yesusu wenumurei ene iseteneai. ");
INSERT INTO six_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kunikunieinexeri, xupuniki xosaniki iyarexeri, Xoiteupo Supo Youya teteneai. ");
INSERT INTO six_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Yesusupo aimore tianutianuwopie xupuniki xosaniki iyareri Xoiteupo Supo Youya teri Saimonie xekeniketai. Pa xati xe nini xosa timana, ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Tini mua sokisoki ye rania siari, kire apu xosa xupi iyaritia, Xoiteupo Supo Youya tepina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kakati Pitae Saimon ipaki kauna, “Neu xe paiya naki xeikani xoxi xepina! Xoiteue aini tinikerina xiyeri xapa tepu xuwerouna sapia, ne xei isayawopine xi nanunere, wo? Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Xoiteu ekero neu xonikemu teteiwatixe. Pa xati sini mua Xoiteupo saina tikiriai xopu ne purowai itou xuwe. Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ne xoni pirixinau neu xoxi kapia nikini tuwo. Kakinau Xoiteu kunikuninau kotowau neu xoxi nanunanu xoniro purotai xesauwepina. ");
INSERT INTO six_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ye mua kuna kunautiaia, amure, ye xekenitia ne Xoiteue ai xoniki ina tinikirouna sapi tepure ekinieni kutu nau pa kapiae kasuei xoxi siei neu nanunanu xoxi xati paie xunupo kakauya xosa purine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kakati Saimonie kuna xapa kauna, “Tinie Xoiteu kunikuniwari yeure xou kuruwati, tini kunauyatiai sapi ye xosa moxete,” niketai. ");
INSERT INTO six_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yesusupo tianutianuwopi aimorei Kokaipapu kuna utei xuiapu kanikineri, Xoiteue nio xosa kapia kaketaire xeika kanikete woteneai. Kakeri xurise Yerusalemu xiyeri xowoxeteneai. Xowoxeteneai yause xosa, Samaria nikau xokupa wese yau asinaku kuna uteiwoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kire Kokaipapu xenikorokoroe Pilipu ipaki kauna, “Ne sarounau asau munarounaro xounau, Yerusalemue utu Kasa putawotai imerei xouwo,” wotai. Pa imepa apu xuweu masaira purina. ");
INSERT INTO six_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kakati Pilipue sana xowotai. Pa imeropa kire Itiopiapu apu xekotai. Nu paiya Itiopia sanawapu kokemu xuipo kokaipa saina apu. Pa xuipo wenumu Kantasi, pa saina apue pa kokemu xui Kantasipo xe re xuruara yakurouna. Itiopiapu kapmanie para waruwoniai. Pa apue Yerusalemu muris tepure kotaiye, ");
INSERT INTO six_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","xiyeri xowopure xetai. Nukoe misitati notoe pururouna saka xosa misitina kunatureture Aisaiapu nakau, ninaipa xowotai. ");
INSERT INTO six_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Xoiteupo Supo Youyae Pilipu ipaki kauna, “Ne pa saka nutiemu xono,” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kakati Pilipue nutiemu keikei xonatia, pa apue kunatureture Aisaiapu nakau nina xati iyesetai. Pilipue kotouna, “Ne mua kuna ninaxitiai kuna xotapa sipaunere, e xuwe?” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kakati pa apue kuna xapa kauna, “Ye amakinei kuna xotapa sipawopinena? Kire apue kayati paiyeye sipawopine,” wotai. Kakati Pilipu kauna, “Xouro manau ye xeika mise,” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pa kuna masa ninaxetaia, mua kuna tuku, “Nue kire kuna kunawopu xuwe. Sipsipu ouwepure tixowori xiraxepu xuweurouna sie. Pa xeika sipsipu ara uri katiwori xiraxepu weurouna sie. ");
INSERT INTO six_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wenumu xiri ororineri, atineri kutuni kunawopu xuwe. Pa xati apue kuna asi warinikepineri, nono teu puropu xuwe. Xuwe. Ninie ouweri, mua ouro pani puropu xuwe,” xetai. ");
INSERT INTO six_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pa apue pa kuna ninaiyeina, Pilipu ipaki kotouna, “Ye ne kotonine, kunatureturei yure mua kuna kunawotaina? Nu nukoure kunawotaire e kire apure kunawotai?” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kakati Pilipue pa apu kuna uteina kawotai. Akerina pa apue ninaxetai kuna xotapa uteiyeina, xurise Yesusupo asinaku kunaure uteiwotai. ");
INSERT INTO six_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Imeyau pani xouneria utu kire enero putawoxeteneai. Pa apue kunauna, “Xekowo, ene purina. Kire sapie ime parawati ye ene isepi xuweuwopinere?” wotai. ");
INSERT INTO six_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kakerina, saka titi kauwati nue muri keuwati saka puruwoteneai notoe tumuwoteneai. Kakeri Pilipue pa apu xeika enero munaneri, Pilipue Yesusupo wenumurei ene iseruwotai. ");
INSERT INTO six_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nini ene wetineri xouro moxeria, sapauni Kokaipapu Youyae Pilipu sou xowati, pa apue nu xiyeri xekopu xuwe. Pa apue nimaririeina nukou ime tai xowotai. ");
INSERT INTO six_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipue Astot erewese putarina, xokupa erewese yau texina Yesusupo asinaku kuna uteipa texetai. Teipa xouna xurise utu Sisaria erewese putawotai. ");
INSERT INTO six_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pa yause xosa Solue Kokaipapu tataiwopi xoxixoxi nikina ounikiepure sokisoki kunani kunawotai. Kakerina, ere xuriatiti xosa xouna, ");
INSERT INTO six_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yuta nikau kununu atapu tumu teu erewese Tamaskusu puroteneai xosa, nakau xayarinikepinaure ere xuriatiti kotowotai. Kakati ere xuriatitie nakau xayaxayauna Solu tuwotai. Nakau teu xosa mua kuna tuku, “Solue xekenikati kireu xuimie re apimie Yesusupo ime taiworia, nue kakauyaro soinikinapa Yerusalemu soniki kopina,” xi xayawotai. ");
INSERT INTO six_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Solue Yerusalemu wetina Tamaskusu xowotai. Nu Tamaskusu ma putauropina yause xosa paiya, mena xouropu kire memeremue sapauni kouyewotai. Pa memeremue xiri sokisoki xati, ");
INSERT INTO six_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Solue oro uraki xouna iyesatia, kire apu supoe ipaki kunauna, “Solu, Solu, ne amakati ye xoxixoxi yepi saina tinena?” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kakati Solue kunauna, “Kokaipa, ne yuena?” wotai. Kokaipae kauna, “Ye Yesusu, nei ye xoxixoxiyepi saina tine. ");
INSERT INTO six_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ne sarounau erewese xouwo. Sewai kire apue kire sapi kakewaire kanepina,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Solu xeika xowoteneai apimie ureuweineri, kuna xuweuweteneai. Apu supue kunawati iyeseteneaina pana, kire apu xekopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Solue sarouna eke perewotai sorena, kire sapi xekopu xuwe. Pa xati xupo xaike tineri Tamaskusu sou xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Xou xeimore asau purotaina pana, ekekemu ukumuni purotai. Nu xoye xeika ene xeika nepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesusupo kire taitaiwopie Tamaskusu purotai, nupo wenumu Ananaias. Kokaipae xiniwepirei nupo wenumu tina, “Ananaias,” xetai. Kakati kunauna, “Kokaipa, ye purine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kokaipae ipaki kauna, “Ne sanau mua ime xouwo, ime wenumu Ime Kutu. Yutasipo atoropa kire apu Tarsusu erewesepure kotoxewai, nupo wenumu Solu. Nue kunikuni purina. ");
INSERT INTO six_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ekekemu ukumuna pana, xiniwepie kire apu wenumu Ananaiasi xekoatia ma xupo xosau iyarati xiyeri eke teteiwopinaure, atoro manetai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kakati Ananaiasie ipaki kuna xapa kauna. “Kokaipa, pa apue neu xokupa xuiapu Yerusalemu puroteneai xosaniki xoxixoxi kapia kakati kunawori iyesitiai. ");
INSERT INTO six_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Neu weninirei muris tineri kunikunirouneri wesepu xuimi apimi kakauyaro soinikepure ere xuriatiti supunikiropu iyo kuna tetai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kakati Kokaipae ipaki kauna, “Ne xouwo. Pa apu nu ximine yeu saina apu xina. Nu xetau xuimi apimi xeteneai xuimiapimi xuna kokemu xuna, Israili xuna xosa xouna yeu wenimi nini xosa uteiwopinaure tumuworitiai. ");
INSERT INTO six_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nu xouna yeu wenimi uteiwopina yause xosa xokupa tatau xeika xu xeika xemeropinaure ataruwopine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananaiasie xouna atareira mana, Solu xosa xupo iyari ipaki kauna, “Yewapu Solu, Kokaipa Yesusue ne imero maiyenerina, xesayati ne kouyenine. Neu ekini ati teteiwati xiyeri sapi xekowaua, Xoiteupo Supo Youyae ne xosa xokope xepina,” wotai. ");
INSERT INTO six_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaiasie kunauwatia, sapauni kesimasa siei Solupo ekero purotaie uraki koati, xiyeri sapi xekotai. Kakati sarouna Yesusupo wenumurei ene isetai. ");
INSERT INTO six_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kakerina xoye nina xiyeri sokisoki tetai. Solue Yesusupo tataiwopi xeika Tamaskusu kireu asau purianiketai. ");
INSERT INTO six_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Xurise Yuta nikau kununu atoroni kutu xouna, ipaki kuna uteina, “Yesusu nu Xoiteupo Nono,” xetai. ");
INSERT INTO six_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Xokupa apue Solupo kuna iyeserineri kokaipa ure urewoteneai. Kakeri kunauneri, “Yesusu wenumurei muris tineri kunikunirouneri xuimi apimi mua apue sore xoxixoxinikirouna. Yerusalemu kaketaie ximine muoro kouna kakauyaro soinikina ere xuriatiti xosa soniki xowopina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pana Solupo sokisokie xiri kokaipa xati Yuta apimi Tamaskusu puroteneai xosa atina kutuni ipaki kanikina, “Yesusu apua Xoiteue nukou xuiapu sonikepure unareyai,” xetai. Yuta apimie Solupo kuna iyeseri ureuweineri wenumu ororepure kire kuna kunawopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Xokupa asau xouwatia, Yuta apimie Solu ouwepure kunununeri kuna ouwoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kakeri, Solue nini kuna ouwoteneaire iyesetai. Yuta apimie Solu ouweri xumopinaure asau xeika ukumu xeika rania, erewesepu xokupa isima parawoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kakeria, Solupo tataiwopie kokaipa sepuri erewese katoreki xouro ukumani sou xowoteneai. Kawori kire keri xosa misitati, xupeu isimarei iyososowori erewese kisauira xowotai. ");
INSERT INTO six_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Solue Yerusalemu xouna, Yesusupo tataiwopi xeika kununuwopure xetai. Kakati nu Yesusupo tataiwopi xana xuweworineri ximikuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kakeria, Parnapasie Yesusupo tianutianuwopi xosaniki sou xou yatawotai. Solue imero Kokaipa xekoati, Kokaipae kuna tuwotaire, Parnapasie asi wariniketai. Solue ximikepu xuweu Yesusupo wenumu Tamaskusu sokisoki uteiwotaire rania Parnapasie asi worotai. ");
INSERT INTO six_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kakati, Solue nini xeika Yerusalemu purina nini xeika texetai. Nu ximikepu xuweu Kokaipapu wenumurei sokisoki kuna uteiwopi saina tetai. ");
INSERT INTO six_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Solue Yuta apimi Kriki kuna kunaurouneri xeika kuna tuwata xeteneai. Kakati ouwepure ime xireketeneai. ");
INSERT INTO six_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Solupo xataumana Yesusu tairounerie paire siparineri, Solu Sisaria sou xouneri, erewese Tarsusu xesawori xowotai. ");
INSERT INTO six_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pa xati xokupa Yutia sanawapu xuiapu xeika Kalili sanawapu xuiapu xeika Samaria sanawapu xuiapu teu xeikae Yesusurei xonikisuneri tairounerie ati puroteneai. Kireu apimie nini xoxixoxinikepu xuweuwori, Xoiteu taineri xonikisuwoteneai xuiapu xokupa xina sokisoki xetai. Ninie Kokaipa irue puropi kapia taiwori, Xoiteupo Supo Youyae ninipo xonikikemu sokisoki wotai. Kakati xokupa xuiapue maneri Xoiteure xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitae xokupa sanawa teipa xouna Lita erewese rania xouna Xoiteupo xuiapu tuku poro purotai. ");
INSERT INTO six_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kire apu nupo wenumu Ainiasi pa wese xekotai. Nupo xokupa eupara xumueki, suariro kireni 8-teu xitosani xini purotai. ");
INSERT INTO six_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitae ipaki kauna, “Ainiasi, ximine Yesusu Kristusue atinati xiyeri merukine. Ne sarounau neu suari atiwo,” wotai. Kakati sapauni sarotai. ");
INSERT INTO six_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kakati Lita erewesepu xokupa apimi xeika Saroni ku xosaupa xeikae, Ainiasi xiyeri merukati xekerineri, Kokaipa xosa xoniki pirixeteneai. ");
INSERT INTO six_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kire Yesusupo tataiwopi xuie Yopa purotai, nupo wenumu Tapita. Kriki kunae Torkas xineri. Nue sipesi asinaku kapia tina xuiapu xuru xuweu tianikirouna. ");
INSERT INTO six_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pa yause xosa supa tina xumotai. Ene isieruworineri iri ata kama tureture xouro xosa iyareteneai. ");
INSERT INTO six_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lita erewesepa Yopa tomuro purati, Yesusupo tataiwopie Pita Lita purina kuna iyeseteneai. Pa xati aimore apu xesanikeri xouneri ipaki kauneri, “Eio, ne sini xosa sapauni kouwo. Ne kaki xanau xororowou,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kakeri Pitae mana nini xeika xowotai. Putawatia souneri, ata kama xouroni kutu xosa xowoteneai. Kakeri xokupa xui oyemasie Pita nutiemu maneri tumuneri muripuroteneai. Kakineri Tapitae xokupa nekei tatama xetai ataruwoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pitae xokupa xuiapu xesanikati kisau mauweria, xoutapa ukurourouna kunikuniwotai. Kakerina moakemu pirixina xui mou xekeuna ipaki kunauna, “Tapita, ne sarouwo,” xetai. Kakati xuie eke pereuweina, Pita xekeri, sarouna misetai. ");
INSERT INTO six_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitae xupo xaike tina sarati, tumurotai. Kakati Pitae Xoiteupo xuiapu xeika xui oyemasi teu xeika yainikeri atarinikina, Tapita ekeoma purina xetai. ");
INSERT INTO six_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pitae kaketai kapiaure Yopa erewesepu xokupa sanawa yau kuna oi xouxanau wati, xuiapue iyeseteneai. Paire xokupae Kokaipaure xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitae xokupa asau Yopa purotai. Kire apu nupo wenumu Saimoni xeika purotai. Pa apue pulmakau nikau ipisa tina kireu sainapure atiatina teukirouna. ");
INSERT INTO six_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kire apue Sisaria erewese purotai, wenumu Korniliusu. Nu Romupo 100 xomatua teu nikau tumu. Nu paiya Itali nikau xomatua kini xeteneaipo xomatua. ");
INSERT INTO six_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nu Xoiteue xouweurouna kapia tairouna. Xokupa apimie nuko xeika nukou atoro purirounerie Xoiteu irue purirouneri. Yuta apimi xauna puropi puroria, xokupa tinikina tianikirouna. Kakina xokupa yause Xoiteu xosa kunikunirouna. ");
INSERT INTO six_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kire asau, 3 kiloku xoruwatisie xosa xiniwepi sie kire sapi yarani xekotai. Xoiteupo kire xenikorokoroe atoro mana ipaki kauna, “Korniliusu,” xetai. ");
INSERT INTO six_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kakati, Korniliusue xekerina xiri ximikerina, ipaki kunauna, “Kokaipa apu, amakatina?” wotai. Kakati, xenikorokoroe Korniliusu ipaki kauna, “Xoiteue neu kunikuni iyeserina, nei xuiapu xeara xuweu purori tianikiroune kapiaure nanunanuna. Neu pa kapia Xoiteue xouweuna. ");
INSERT INTO six_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Ximine kireu apimi xesanikari Yopa xouneri, kire apu nupo wenumu Saimon, kire wenumu Pita. Nu xekeri kaworia kopina. ");
INSERT INTO six_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kire Saimoni nu pulmakaupo ipisa xosa saina tirouna. Nu nupo atoro purina. Pa atapa xasi maro purina,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Xenikorokoroe Korniliusu kuna kaworina xowotai. Kakati, nupo aipu saina apu aimore xeika kire xomatua xeika yainikati moteneai. Pa xomatuae rania Xoiteue xouweurouna kapiaure xina Korniliusu xeika sipesi purirouna. ");
INSERT INTO six_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korniliusue pa xokupa kapia yaraxetaire pa xeimore apimi ati kanikati Yopa xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Korniliusue xesaniketai apimie xouneri ime kamamu xineteneai. Xumi xati pani xouneri asauniki xepure xatia Yopa erewese tomuro xonoteneai. Pa yause xosa Pitae kunikuniwopure ata youpo saka xouro xowotai. ");
INSERT INTO six_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pitae iriawati xoye nepure xetai. Nini xoye irei purineria, kire sapi xiniwepi sie xekotai. ");
INSERT INTO six_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Menae taiyati, kire sapie kokaipa mari sie koati xekotai. Kire sapie muira pairapu xaku xaku teri iyososo wati oro kotai. ");
INSERT INTO six_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pa mari xosa xokupa noto xeika xaima xeika xetaxetau ni xeika puroteneai. ");
INSERT INTO six_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kire supue ipaki kunauna, “Pita, ne sanau noto ounau ne,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kakati Pitae kunauna, “Kokaipa, ye kakepi xana xuweni kutu! Ye xakusu kire yause ne ekiniro kire xeseu xeki sapi nepu xuwe xati, nepinukua xeseu,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xiyeri xina pa supoini ipaki kunauna, “Xoiteue kakati asinaku xina xeseu xuweuwotai sapia, nei kunaunau xeseu xeu,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Xeimore yause pa kapia kakerina, sapauni pa marie mena xouro xiyeri xowotai. ");
INSERT INTO six_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitae xokupa nanunanu tiei kunauna, “Ye mua xiniwepi xekeutaia, amu xiniwepi xotaparau?” xetai. Paire nanunanu watia, Korniliusue xesanikati koteneai apimie putawoteneai. Apimi kotonikineri Saimonipo ata anoro purinanarineri, ma ata isimaro tumuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kakeri uru ipaki yaxineri, “Saimoni, kire wenumu Pita, nu muoro purinare e xuwe?” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitae pa xiniwepireni nanunanu puratia, Xoiteupo Supo Youyae ipaki kunauna, “Iyese. Xeimore apue ma ne xirekinineri. ");
INSERT INTO six_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pa xati ne sarou munanau nini xeika xouwo. Ne kaki xanau ere nanunanuwou. Ye ikoini xesanikiti koteneai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pitae pa apimi xosa muna ipaki kunauna, “Pa apu tini xirekepi saina tikiriaia, ye sore. Tini amure kounukuna?” niketai. ");
INSERT INTO six_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kakati ninie ipaki kunauneri, Korniliusu nu 100 xomatua teu nikau tumu. Nue xesasikati kounuku. Nu asinaku apu Xoiteure ximikirouna. Xokupa Yuta kinie kunauneri, nu asinaku apu xirouneri. “Nei nupo atoro utunau kireu kuna kunawau iyesepinaure, kire Xoiteupo xenikorokoroe kawati yainetai,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kakeri Pitae atoro soniki mana yakuniki xinetai. Xumi xatia saneri xirini xowoteneai. Yesusupo kireu tataiwopi Yopa puroteneaie Pita xeika xirini xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pita xeika pa apimi xeikae teipa xouneri, kireni ukumu ime kamamu xineteneaie, Sisaria erewese utu putawoteneai. Kakeri Korniliusue nini yakuniki purotai. Nupo emeumana xeika marouyaumanani kutu xeika yainikati, kouneri kununu puroteneai. ");
INSERT INTO six_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pitae atoro manatia, Korniliusue nutiemu mana siau sakoro xoutapa ukurouna nu xosa muris tetai. ");
INSERT INTO six_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kakati Pitae ti sari ipaki kauna, “Ne sarouwo. Ye rania apu sore,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kakerina nu xeika atareira kunaupa maneri, xokupa xuiapue kununu purori xekeniketai. ");
INSERT INTO six_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kakeri nue ipaki kanikina, “Takieni sipa, sini Yuta paiya sinipo asisikimana nikau kapia tuku. Pa xati xetau sanawapu xuiapu kini tuku puropinukure e nutieniki xonopukiri xana xuwe. Xeseuni kutu. Pana Xoiteue kapia atariyetaina, ye Xoiteu ekero kire apu xunu tukuna nu xeika lixepi xana xuwe xepixe. ");
INSERT INTO six_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pa xati ye tinipo kuna suputiki woropixe. Ye tinipo uru iyeserine koune. Paina ye kototikine, amakati ye yaikiriaina?” niketai. ");
INSERT INTO six_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kakati Korniliusue ipaki kunauna, “Xeimore asau xowotai xosa, kire sapie ye xosa putawotai. Paiya muai. Yeu atoro purine 3 kiloku xosa kunikunitiai, paiya muanumu yause sie xosa kunikunitia, sapauni kire apue yeu ekiro tumuwotai, nupo mari paiya xiri una puromuwoki. ");
INSERT INTO six_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Pa apue kunauna, ‘Korniliusu, Xoiteue neu kunikuni iyeserina, nei xuiapu xeara xuwe xati xuru xuweu purori tianikiroune kapiaure nanunanuna. ");
INSERT INTO six_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pa xati apimi xesanikau Yopa xouneri apu Saimoni kire wenumu Pita yauwopineri. Pa apua nu kire Saimonipo atoro purina. Nu pulmakau ipisa xosa saina tirouna, nupo ata xasi maro purina,’ yetai. ");
INSERT INTO six_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kakati, sapauni kireu apimi xesanikiti ne xosa utoteneai. Kakeri, ne asinaku kapia tine koune. Paina ne xokupa kuna Kokaipae kanetai sini kasikau iyesepinukure, sini xokupae kounuku Xoiteu ekero purinuku,” wotai. ");
INSERT INTO six_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pitae ipaki kunauna, “Suwauni kutu, ximine ye sipaune, xuiapu nini xetaxetau kinipo sorena, Xoiteue kireni kapiani kakirouna. ");
INSERT INTO six_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Xokupa sanawapu xuiapu tutue nu irue purineri asinaku kapia kakirouneria, Xoiteue xouwenikirouna. ");
INSERT INTO six_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoiteue sini Israili kini sikeyai kuna tini sipa. Nue asinaku kuna ipaki uteina, Yesusu Kristusu nu xokupa apu nikau Kokaipa, nue kakati sini Xoiteu xeika xosiki tumaxirounuku. ");
INSERT INTO six_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Xokupa xuiapue ene isepinerire Yonie kuna uteiyatia, Yutia Propinsi xosa xokupa kapia akipa xeyai tini sipa. Kalili tistrikie pa kapia xotapa tayeyai. ");
INSERT INTO six_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tini sipa, Xoiteue Nasaretipo Yesusu tumuworina, Xoiteupo Supo Youya xeika sokisoki xeika tuwotai. Kakati, wese yau xouna xuiapu tianiketai. Xoiteue nu xeika purati, xokupa apu Satanie xoxixoxi niketai xiyeri atiniketai. ");
INSERT INTO six_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nue sini Yuta xeika Yerusalemu xeika sikau ekisikiro wesewese saina tetaire sini kuna uteinuku. Nu kire na nikitoto xosa isarineri, pa kapiarei ouweri xumotai. ");
INSERT INTO six_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pana asau xeimore xosa Xoiteue xiyeri sarati xuiapu ekinikiro putawotai. ");
INSERT INTO six_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nu xokupa Yuta ekinikiro putawotaixe. Xuwe. Xoiteue ekime sini nupo kuna uteiwopinuku apu tumusikereyai ekisikiro putawotai. Nu upurei xiyeri saroatia, sinie nu xeika xoye tuku ene tuku nikiriai. ");
INSERT INTO six_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yesusue kasikina sinie asinaku kuna uteinuku xuiapu ipaki kanikinukua, ‘Yesusu apu paiya xumoteneai apu nikau kuna iyesete, ekinikioma puroteneai apu nikau kuna iyesete, wopina apu Xoiteue tumoretai xepinuku.’ ");
INSERT INTO six_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nue kakepina sainaure, xokupa kunatureturei ipaki kunauneri, mua apu wenumurei kireni, Xoiteue xokupa apue nure xonikisuwoteneaipo xunu weterinikepina xeneai,” xetai. ");
INSERT INTO six_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitae kuna uteiwatia, Xoiteupo Supo Youyae xokupa xuiapue purineri kuna iyeseteneai xosaniki kotai. ");
INSERT INTO six_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Yutapu Yesusupo tataiwopie Pita xeika koteneaie xuiapue xetaxetau kuna irae lirauneri Xoiteupo wenumu xouroreri, ureuwei ipaki kunauneri, “Xekoa. Xoiteue nupo Supo Youya xetau xuiapu teu rania aini tinikerina xiyeri xapa tepu xuweurouna sapi tinikina xeteneai.” Kakeri, Pitae ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mua xuimi apimie siko sie Xoiteupo Supo Youya tieineri. Pa xati sini Yesusupo wenumurei ene iserinikepua yue taiyerisikepinana?” xetai. ");
INSERT INTO six_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kakeri Pitae pa xuiapu ipaki kanikina, “Tini Yesusu Kristusu wenumurei ene isakuai,” niketai. Nini ene isieineria, Pitae kireu asau pani purianikepinaure kawoteneai. ");
INSERT INTO six_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesusupo tianutianuwopi teu xeika xuimiapimi xonikisuwoteneai xeikae Yutia Tistriki purixanauwoteneaie, xetau xuimiapimie rania Xoiteupo kuna teteneaire kuna iyeseteneai. ");
INSERT INTO six_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pitae Yerusalemu xowotai yause xosa, Yesusupo tataiwopi nini mari takepi kapia sokisoki taiwoteneaie auwoteneai. ");
INSERT INTO six_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ipaki kunauneri, “Ne amu kapia tine mari takepu xuweurouneri apimi nikau atoro xoune nini xeika xoye ninena?” woteneai. ");
INSERT INTO six_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kakeri Pitae xokupa kapia nu xosa yaraxetaire perawotai. Ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ye Yopa erewese purine, kunikuni purine, kire sapi xiniwepi sie xekeutiai. Ye kire sapi kokaipa marini kutu sie, mena xourei koati xekeutiai. Kire sapie mari xaku xaku tipurina ye xosa iyososowati kotai. ");
INSERT INTO six_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ye atinei pa sapi sipawopure pa mari minika oioixitia, apue yakunikirouneri noto xekenikine, noto pas xekenikine, xaima xekenikine, ni xekenikineutiai. ");
INSERT INTO six_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kakitia kire supue ipaki kaina, ‘Pita, ne sanau noto ounau ne,’ yetai. ");
INSERT INTO six_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kakatia yei kunaune, ‘Kokaipa ye kakepi xana xuweni kutu! Sini nepi xuweuwopinuku sapi ye xakusu kire yause kire sapi xeseu xeki ne ekiniro niaixana xuwe,’ utiai. ");
INSERT INTO six_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kakatia mena xourei pa supo kotaie xiyeri aimore yause ipaki kunauna, ‘Xoiteue kunauna na xetai sapia, kaki xanau xeseu xeu,’ yetai. ");
INSERT INTO six_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Pa kapia xeimore yauserina, xokupa sapi mena xouro xiyeri manetai. ");
INSERT INTO six_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Pa yause xosauni kutu, xeimore apue sini purikiriai ata xosa koteneai. Kire apu Sisaria purotaie xesanikati ye xosa koteneai. ");
INSERT INTO six_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Xoiteupo Supo Youyae ipaki kaina, ‘Ne nini xeika xouwo. Ne kaki xanau xokupa nanunanu teu,’ yetai. Kakati xataimana 6-teu apu rania ye tuku xirini xounuku, pa apupo ata minika makiriai. ");
INSERT INTO six_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Makiria xenikorokoroe nupo atoro mana tumurati xekotaire kasiketai, xenikorokoroe kunauna, ‘Ne apimi xesanikau Yopa xouneri Saimoni xirekepineri, nupo kire wenumu Pita. Nu kopinaure kawopineri. ");
INSERT INTO six_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nue kireu kuna tinatia, pa kunae Xoiteue naki xeika xokupa xuimiapimi xeika neu atoro purikiriai xiyeri titikepina,’ xetai. ");
INSERT INTO six_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pa apu yaiyetaie kunauwatia, yei kuna kereriti, Xoiteupo Supo Youyae ximuximu siko xosa kotai sie nini xosa kotai. ");
INSERT INTO six_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kakati ekime Kokaipae kunawoyai kuna xiyeri nanutiai. Ipaki kunauna, ‘Yonie xuiapu enero ene iseriniketaina pana tini paiya Xoiteupo Supo Youyae ene isakuai,’ xeyai. ");
INSERT INTO six_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ekime sini Yesusu Kristusure xosikisukiri, Xoiteue Supo Youya sikeyai. Panumu sie ximine Xoiteue nini rania tinikina. Pa xati ye yu xati Xoiteu nukoini nini xosa kaketai saina parawopinena?” niketai. ");
INSERT INTO six_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Apimie Pitapu kuna iyeserineri, pani makopineri nanunanu xuwexetai. Xoiteupo wenumu xourori ipaki kunauneri, “Ximine sini sipaunuku, Xoiteue xetau apimi kini rania wetinikati xoniki pirixineri ekinioma tineri,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiweni ouweri xumatia, kireu xuiapue Yesusure xonikisuwoteneai rania xoxixoxiniketeneai. Pa xati nini xokupae ximi xouxanauwoteneai. Kireue Ponisia tistriki xeika Saiprusi sou xeika erewese Antioku xeika xosa xouneri Yesusupo kuna uteiwoteneai. Nini xetau xuimiapimi xosa kuna uteiwopu xuwena Yuta xosa kireni kuna uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nini xopuropu kireu apimia, nini Saiprusipo xeika erewese Sairinipo xeikae Antioku xouneri Kriki apimi rania Yesusupo kuna tiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kakeri Kokaipapu sokisokie nini xosa purati, xokupa xuiapue xonikisuneri xoniki pirixineri Kokaipapu tataiwopi saiyeteneai. ");
INSERT INTO six_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yesusurei xonikisuwoteneai xuiapu Yerusalemupoe pa kuna iyeserineri, Parnapasi xesawori Antioku xowotai. ");
INSERT INTO six_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nue xou putarina xekenikatia, Xoiteue tianikina xiri atinikati, xoukemu asinaku xetai. Kakeri, xokupa xuiapue sipesi Kokaipa taiwopinerire taitainiketai. ");
INSERT INTO six_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Parnapasi nu asinaku apu xati, Xoiteupo Supo Youyae nu xosa koxati, nu sokisoki xousu tuku xetai. Kakati kokaipa xuiapu kinie Kokaipa taiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Parnapasie Solu xekopure Tarsusu xowotai. ");
INSERT INTO six_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Utu xekerina, Antioku sou kotai. Kireni xitosani xosa nini Yesusure xosikisuwoteneai xuimiapimi xeika Antioku misineri, kokaipa xuimiapimi kini Xoiteupo kuna uworiniketeneai. Kakeri, xuimiapimie Yesusu taineri Kristeni weniniki kopou teteneai. ");
INSERT INTO six_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pa yause xosa kireu kunatureturei Yerusalemu wetineri Antioku koteneai. ");
INSERT INTO six_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kire kunatureture wenumu Akapusu xeteneai, nue Xoiteupo Supo Youyapu sokisokirei sana xokupa sanawa kokaipa mause mopinaure kuna uteiwotai. Xurise, kokemu Klotiusue Sisari saina ti puratia, pa mause yause putawotai. ");
INSERT INTO six_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kristusupo xuiapu teue Akapusupo kuna iyeserineri, Yesusupo tataiwopi Yutia puroteneai xosa xe tianikineri xesarinikepure kuna ouwoteneai. Kakerineri nini xokupae xe kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Parnapasino Soluno xesanieri ninie pa xe tixouneri Yesusure xonikisuwoteneai nikau tumu tiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pa yause xosa kokemu Erotie kireu Yesusure xonikisuwoteneai apimi xoxixoxiniketai. ");
INSERT INTO six_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nue kunawati, Yonipo xatau Yemusu, sawaruwarue ouweteneai. ");
INSERT INTO six_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yuta apimie pa kapia xoxi kaketaire xonikiewori xekerina, Pita rania kakauya xosa iyaretai. Pereti Pususu Xuweupo Kokaipa Yause xosa nu pa kapia kaketai. ");
INSERT INTO six_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita soki tina kakauya xosa iyaretai. Xomatua surup teu xosa iyarati, tianitianiwata xineri Pita yakuwoteneai. Pa surup teu xomatua xosa paiya surup teu surup teu xomatua tuku, xokupania 16-teu xomatua. Erotie Xoiteue Israil Weinikitati Ati Puroniai Kokaipa Yause Nanuwoniai yause yakuwati xuwexati paiyeye, xuiapu ekinikiro Pita sou kouna kuna xosa iyarepure xetai. ");
INSERT INTO six_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kakati Pitae kakauya atoro purati xomatuae yakuwoteneai. Pana Xoiteue Pita tianuwopinaure Yesusure xonikisuwoteneai xuiapue sipesi sokisoki kunikunirouneri. ");
INSERT INTO six_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erotie Pita kuna xosa iyarepinaure kire asau iyaretai. Ukumani, asau mopu xuweuni, Pitae xomatua aimore xopuro xinipurotai. Sokisoki xume aimorei tarineri, kireu xomatuae kakauya ata isima yaku puroteneai. ");
INSERT INTO six_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kakeria, Kokaipapu xenikorokoroe sapauni moati, kakauya ata kama xosa memeremu motai. Xenikorokoroe Pita kisa koruwati saroati, kauna, “Ne sapau saro,” wotai. Kakati sokisoki xume aimore Pita xuporo xurexina oro uraki kotai. ");
INSERT INTO six_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Xenikorokoroe kauna, “Kikai ati takerinau erieri erere,” wati Pitae kaketai. Kakati xenikorokoroe kauna, “Neu mupuniropu erieri xuwau ati ererinau taiye,” wotai. ");
INSERT INTO six_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kakati Pitae pa ata kama wetina xenikorokoro taixowotai. Xenikorokoroe pa sainani kutu tetaiya, Pitae paire nanuna ye ai xiniwepixine xetai. ");
INSERT INTO six_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xonanexeri aimore xomatuae isima yaku puroteneai emeserinikineri, kakauya weti erewese xowopineri sokisoki isimaroni kutu xosa putawoteneai. Kakeri pa isima nukoni taiyati, kisau munaneri kire imero xounexeria, xenikorokoroe sapauni lemeni Pita wetina xowotai. ");
INSERT INTO six_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pitapu nanunanu teteiati, ipaki kunauna, “Ximine ye ati sipaune, Kokaipae nupo xenikorokoro xesawati kouna Eroti xuporopu xeika Yuta apimie xokupa kapia kakepure nanunanu woteneai xeikaure xiyeri soina,” xetai. ");
INSERT INTO six_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kakerina Yonipo ana, Mariapu atoro xowotai. Yonipo kire wenumu Maki. Xokupa xuiapue pa ata kunununeri kunikuni puroteneai. ");
INSERT INTO six_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pitae ata kisauira isima korukoru xati, kire saina xui wenumu Rota, nue isima tayepure motai. ");
INSERT INTO six_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pa xuie Pitapu kuna iyeserina, xoukemu xiri nimaririeina, isima taiyepu xuwe. Xuwe. Atareira keikei mana xuiapu ipaki kanikina, “Pitae mana isimaro purina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kakati ninie ipaki kauneri, “Ne nanana xinere?” woteneai. Pana nue ipaki sokisoki kanikina, “Xuwe. Nukoe suauni kutu purina,” niketai. Kakati ninie kunauneri, “Ne nupo xenikorokoro kireni xekeutiairau,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pitae isima pani korukoru xetai. Xonaneri isima taiyeineri xekeri, kokaipa ure urewoteneai. ");
INSERT INTO six_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kakeri, Pitae supuniki parauna xupusoxupuso niketai. Kakerina, kakauya ata wetina kisau kopinaure, Kokaipae kapia kaketaire perariniketai. Kakeri ipaki kunauna, “Tini Yemusu xeika xataimana xeika mua kapiaure kanika,” xetai. Kakerina weniki kire sanawa xowotai. ");
INSERT INTO six_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Xoripesau xomatuae xekoria Pitae puropu xuweu wati ureuweineri nikoniko kotokotowata xineri, “Pita anoro xowotaina?” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erotie Pita puropu xuweu wati siparina, xirekepinerire apu kaniketai sorena, ninie xekopu xuwe. Paire Pita yakuwoteneai xomatua kuna xosa iyainikerina nini xumopineri xetai. Xurise, Erotie Yutia wetina toupa Sisaria erewese xouna purotai. ");
INSERT INTO six_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kokemu Erotie Tairi erewese xeika Saitoni erewese xeikapu xuiapu tuku ere makawotai. Pa xati ninie kirenini kununuworineri kou xekoteneai, pa amure, nini Erotie yakuwotai sanawa xosa xoye tirouneri. Kokemu xinirouna ata kama yakurouna saina apu Plastusu xeika akeri kunakunaworia, iyo niketai. Kakerineria, xouneri Eroti xekeuneri kotowoteneai, xou kuruwati kuna xumuwepinaure. ");
INSERT INTO six_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erotie kire yause iyarina, pa yause xosa kokemupo nekei ererina, nukou kokemu sai xosa misina kokaipa kuna kaniketai. ");
INSERT INTO six_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kakati, xuiapue ipaki yaxineri, “Nu kire xoiteupo supo. Nu apupo supo xuwe,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Erotie ninipo kuna iyeserina, nu Xoiteupo wenumu xourorepu xuweuwati, sapauni Kokaipapu xenikorokoroe ouwotai. Kakati supa xoxie nu xosa moati, temerie kereuneri xumotai. ");
INSERT INTO six_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pana Kokaipapu kuna paie sokisoki xina xokupa wesewese xowotai. ");
INSERT INTO six_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kakati Parnapasino Solunoe Yerusalemu saina xuweiyeinexeri, Antioku xiyeri xouneri Yoni Maki sou xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokupo Yesusure xonikisuwoteneai kireu apimie kunatureture kuna kunaurounerina kireuepa Xoiteue xouweurouna kapia xuiapu taitainikirouneri. Ninipo weniniki paiya, Parnapasi, Simioni, nupo kire wenumu Nikeri, Sairini erewesepu Lusiusi, Solu, Manaini, nu paiya akereki kapmani Erotipo emeu. ");
INSERT INTO six_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kire yause xosa muris tineri xoye xuriketeneai. Kakeri, Xoiteupo Supo Youyae ipaki kanikina, “Tini Parnapasino Soluno tumunikerari, ninie saina tepinerire yainikitiaina saina tepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kanikati xoye xurikeri kunikunineri xupuniki xosaniki sorineri, xesanikeri xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Xoiteupo Supo Youyae xesaniati, Selusia erewese xowoxeteneai. Selusiae kokouna xouro epiteri kokounae Saiprusi sou xosa soniki xowotai. ");
INSERT INTO six_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamisi erewese utu putarineri, Yuta nikau kununu ata yau xouneri Xoiteupo kuna uteiwoteneai. Yoni Makie nini xeika xouna tianietai. ");
INSERT INTO six_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ninie Saiprusi sou xosa xokupa sanawa masa teipa xouneri erewese Paposi putawoteneai. Kire apu nupo wenumu Paryesusue purati xekoteneai. Nu xoreixorei kapia tina osa wowourouna apu. Nu kire Yuta nikau xoreixorei tua kunatureture. ");
INSERT INTO six_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nu akereki kapmani xeika purirouna, wenumu Sekiusu Paulusu. Sekiusu Paulusu apua nu asinaku nanunanu xeika sipa xeika tuku. Nue Xoiteupo kuna iyesepure Parnapasino Soluno yainikati koxeteneai. ");
INSERT INTO six_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pa apu xoreixorei kapia tina osa wowourouna paiya, Kriki kunae wenumu tineri Elimasi xirouneri. Nue Parnapasino Soluno niau saina touwerinikepure xetai, pa amure, nu akereki kapmani Sekiusie Paulusue Yesusure xousuwopina xirarina kaketai. ");
INSERT INTO six_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pana Solu, kire wenumu Polu, Xoiteupo Supo Youyae nu xosa koxati Elimasi sokisoki kukou puri ipaki kauna, ");
INSERT INTO six_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ne Satanipo nono. Ne xokupa kapia kutupo xiwai. Xokupa xoreixorei kapia xeika xoxi kapia xeika ne xosani kutu xokopexina. Ne kokaipapu xokupa ime kutu xoxixoxiroune. Ne pa xoxi kapia wetewaiya ama? ");
INSERT INTO six_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Paina iyese. Ximine Kokaipapu xupoe ouninana, ekini sauworepina. Ximine ne asau xekopu xuweu xayakaxayaka xuwau yause purowai,” wotai. Polue kaki kunawati sapaunini iyou siei xiri ukumurouna Elimasipo eke pararetai. Kakati, xupo tina ime ataruwopinaure, eketutu titoutatouna apu xireketai. ");
INSERT INTO six_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kakati akereki kapmanie pa kapia xekerina xousuwotai. Kakina Kokaipapu kunaure nupo nanunanu xiri sarotai. ");
INSERT INTO six_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polue nu xeika texeteneai apimi xeika erewese Paposi wetineri, kokouna tineri Pampilia propinsipo erewese Perka putawoteneai. Yoni Makia nu weniki Yerusalemu xiyeri xowotai. ");
INSERT INTO six_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perka wetineri, teipa xouneri erewese Antioku tistriki Pisitia xosa putawoteneai. Yuta nikau Arikepi Yause xosa, ninipo kununu atoro maneri miseteneai. ");
INSERT INTO six_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kununu atapu tumue tuxotapapu kuna xeika kunatureture nikau kuna xeika ninaiyeineri, kire apu kawori xona Polu xeika saina emeumana xeika ipaki kanikineri, “Yewapu xura, tini xuiapunikau xonikikemu sokisoki wakuai kuna tuku xatia, paina uteiwa,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polue sarouna punisi xuwexepinerire, xupo korekoreri ipaki kunauna, “Tini Israili apimi xeika, tini xetau apimi xeikae Xoiteu irue purikiriai, tini iyesa. ");
INSERT INTO six_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israili kini nikau Xoiteue sinipo asisikimana, nukou xuiapu sie tumunikereyai. Ninie nikou ou wetineri Isipu xouneri puroria, Xoiteue kakati xuiapu inainauweneai. Xurise nukou sokisokieni Isipupo soniki koyai. ");
INSERT INTO six_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nini aipu usie ukauro puroniai yause xosa, nue ninipo xu 40-teu xitosani xemeroyai. ");
INSERT INTO six_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kenani ouro Xoiteue 7-teu xetaxetau xuiapu tutu xuweinikieina, Israili nikau ou puropinaure pa ou tinikeyai. ");
INSERT INTO six_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ximuximu Israil apimie Isipu xouneri porokireukireu xitosani puroneiaiye, Mosesie sonikati xiyeri apu xuweu wese xiri xosa teipa xouneri xouneri kireu xitosani xuwexeteneai. Pa xokupa kapia kakipa xouneri 450 xitosani sie xeteneai. Xurise Israil apimie ou teri, Xoiteu Israil tumu teu tumunikereyai. Kakipa kouna kunatureture Samuelipo yause xosa xeyai. ");
INSERT INTO six_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Pa yause xosa kire kokemu tepure yaxeri yakunikepinaure Xoiteue Solu tumuworati, nue 40-teu xitosani tumu puroyai. Solu nu Kisipo nono nu Pensaminipo apu kini. ");
INSERT INTO six_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xoiteue Solu xesauwei Tepitie ninipo kokemu puropinaure tumuworeyai. Tepitire apu kanikina, ‘Ye Yesipo nono Tepiti xekeuweitiai, yeu xoikemue pa apu xoieune, nue yeu xoiropu xokupa nanunanu taiwopina.’ ");
INSERT INTO six_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ekime Xoiteu nukoe sokisoki kuna kunawoyai sie, pa apu Tepitipo apu kiniropu siko xiyeri tisikepinaure Xoiteue xesawati Israili kotai. Pa apu nu Yesusu. ");
INSERT INTO six_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Yesusue nupo saina sarepu xuweu yauseni, Israili apimi xoniki pirixineri Yesusupo wenumurei ene isepinerire Yonie Israili apimi kuna tiniketai. ");
INSERT INTO six_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yonie nupo saina xuweiyepure xinapa, ipaki kunauna, ‘Tini ye yue paxi nanunukuna? Yepa tini yakukiriai apu, xuwe. Pana tini iyesa. Xurise kire apu kopinana, ye asinaku apu xati nupo erieripo muri xurexepixe.’ ");
INSERT INTO six_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Yewapu xura, tini Apraxamupo apu kini xeika tini xetau apimi xeika Xoiteu irue purirounuku, iyesa. Xoiteue nuko xuiapu xiyeri sonikepure, xesawoyai kuna, siko xosa rania xesawotai. ");
INSERT INTO six_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Apimie ninipo tumu teu xeika, Yerusalemu puroteneaia, nini pa apu atineri sipawopu xuwe. Nini kunatureture nikau kuna xokupa Yuta nikau arikepi yause xosa ninaxirouneria nanurouworixe. Pa xati kunauneri mua apu xumopinani kutu xeniai, pa kapiarei ekime kunatureturei kunawoniai kuna taiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nu kuna xosa tumuworineri kire xoxi kapia xekeri xumopina sie xeniai xana xuwe, ai akereki kapmani Pailatie ouwepinaure sokisoki xeteneai. ");
INSERT INTO six_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kakerineria, ekime kunatureturei kunauneri apue kakepineri xeniai sie kakerineri na nikitoto xouropu tikouneri kire kopaupuro upuareteneai. ");
INSERT INTO six_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pana Xoiteue kopaupuropu xiyeri sarati, ");
INSERT INTO six_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","xokupa asau xosa apue Kalili wetineri Yerusalemu nu xeika xourounerie nu xekoteneai. Pa apimie ximine nupo kuna Yuta apimi xosa uteirouneri. ");
INSERT INTO six_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Sinie tini xosa asinaku kuna ipaki uteinuku. Xoiteue asisikimana sokisoki kuna kanikina, apu xesautia siko xiyeri kou tisikepina xeyai, ");
INSERT INTO six_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","pa xati sini ninipo nono teu xosa sokisoki kuna kunawoyai sie kakepinaure Yesusu kopaupuropu saretai. Mua kapiapu kuna paiya Siri Nakau xosa xoka 2 siri xosa purina. Kuna paiya muanumu, ‘Ne yeu nono. Ximine ye neu emini xine,’ xeyai. ");
INSERT INTO six_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Xoiteue kopaupuropu saretaina, nu kopaupuro pani xiyeri xouna xusaxepuwatixe. Paiya Xoiteue kunauna, ‘Ekime Kokemu Tepitie sokisoki kuna kauyai sie, ye atiatikineia asinaku asinaku sapi tikepine xeyai. Ye kunautia sieni kutu mua sapi akipa xepina,’ xeyai. ");
INSERT INTO six_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kire kuna rania Xoiteupo nakau xosa purina. Paiya muanumu, ‘Ne apu xokumoe neu saina tepinaure nakie tumuworiai wetau kopaupuro xusaxete,’ xeyai. ");
INSERT INTO six_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Siko sipa, Tepitie ouro puroyai yause xosa, nu Xoiteupo kuna taiwoyai. Xurise xumati nukou asamana nikau kopaupuro upuareri xusaxeyai. ");
INSERT INTO six_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pana mua apua Xoiteue kopaupuro sareyaina, nupo mupokemu xusaxepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pa xati, yewapu xura, sinie tini xosa ipaki mua kuna uteinuku. Tini ati sipawa, mua apu nue tinipo xunu xesauweritikepure kotai. ");
INSERT INTO six_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosesipo tue tinipo xunu xesauweritikina tini apimi asinakuni kutu xepuwatixe. Pana mua apua nu xokupa apue nure xonikisuwoteneai nikau xokupa xunu xesauwerinikina nini asinaku apimini kutu xina. ");
INSERT INTO six_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pa xati tini sosopa epixa. Mua sapi ekime kunatureturei kunawoneai tini xosa moxete. Ninie ipaki kunauneri, ");
INSERT INTO six_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Tini pirexirounuku apimi, tini xekexekewa, tini ure titikatia xoxi xakuai. Tini xopu ye xetau xumu xonuxonu kapia kakitia yaraxepina. Ye kakepure xitiai kapiaure, kire apue katikatia tini xotikisuwakuaixe xeyai,’ ” xina kaniketai. ");
INSERT INTO six_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Polue kuna tinikiatia, nio Parnapasinoe kununu ata wetineri kisau xowopurexeria, xuiapue ipaki niranira kuna kanikineri, “Emeu Yuta Nikau Arikepi Yause xosa xiyeri kounaxari pa sapire kasikakuai,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kakeri Yuta nikau kununu ata weti kisau xouneria, xokupa Yuta xeika xetau apimi xeteneai xuiapu kini xeikae Yuta nikau muris tepi kapia taineri, Poluno Parnapasino tainiketeneai. Kakeri ninie kuna tiniketeneai. Nini Xoiteupo asinaku puropi taineri, nupo sokisoki xoukuru xosa puropinerire kuna tinikineri ninipo nanunanu sareteneai. ");
INSERT INTO six_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Emeu Yuta nikau arikepi yause xosa, pa erewesepu xokupa xuiapue Kokaipapu kuna iyesepure Poluno Parnapasino xosa koteneai. ");
INSERT INTO six_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pana Yuta apimie pa kokaipa xuiapu tutu xekoria, xonikikemu xiri xoxixoxi xetai. Kakati Polu xeika kuna tuwata xineri nupo kuna ororineri pirewoteneai. ");
INSERT INTO six_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kakeri, Poluno Parnapasinoe sokisoki kuna nini ipaki kanikineri, “Suwau, tini Yuta apimi xite Xoiteupo kuna sini akeri katikepinuku. Pana mua kuna nikitiki tunuku takieni ipaki kunaunuku, ‘Sini ekisikioma puropi sipesi tepukirixe xikiriai.’ Pa xati tini iyesa. Sini xetau apimi teu xosa kuna uteiwopinua, ");
INSERT INTO six_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","pa amure, Kokaipae ipaki kasikina, ‘Yei ne xokupa xetau xuiapu nikau memeremu sie iyainerine, nei xokupa ou yaupo xuiapu tianikau, yei xiyeri tinikepine xeyai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Xetau xuimiapimie pa kuna iyeserineri, Kokaipapu kunaure xiri nimaririwoteneai. Kakeri, pa xokupa xuiapu sipesi ekinikioma puropinerire Xoiteue tumunikeretaie xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kakineri ninie Kokaipapu kuna pa tistiriki tixouxanauwoteneai. ");
INSERT INTO six_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kakeri xuimi weniniki tuku xeika, erewesepu tumu teu xeika nini Xoiteure muris tepi kapia tairounerina pana, Yuta apimie xoniki xuseri Poluno Parnapasino xoxixoxiniketeneai. Kakineri pa tistiriki xosaupo xesanieteneai. ");
INSERT INTO six_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kakeri, xuiapue sipauneri sini xoxi kapia tikiriaina xu tuku xepinuku xepinerire, Poluno Parnapasinoe sianikiropu mai pokuwoxeteneai. Kakerineri Antioku wetineri erewese Aikoniamu xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kakexeri Xoiteupo Supo Youyae Antiokupo xuimiapimie Yesusure xoniki suwoteneai xosa xokopexati xiri nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Poluno Parnapasinoe Antioku kakexeteneai kapia sieni Aikoniamu kakexeteneai. Yuta nikau kununu ata manexeri kuna uteiwoxeteneai. Kuna ati piteuneri uteiwoxeri, Yuta xeika Kriki xeikapu kokaipa xuiapu kinie xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kakeria kireu Yutapu xonikisuwopu xuweue, xetau xeteneai xuiapu xoniki xuseri, ninie xonikisuwoteneai xuiapure xonikikemu xoxixoxixeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ninie Aikoniamu xuwau yause purineri, Xoiteue xoukemu tiniketaipo kuna ximikepu xuweu uteiwoxeteneai. Kakexeri Xoiteue sokisoki tiniati, xumu xonuxonu xonuxonu kapia erexeteneai. Pa kapiarei Xoiteue xuiapu ipaki atarinikina, mua kuna ninie uteiwoxeteneai suwani kutu xetai. ");
INSERT INTO six_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pana pa erewesepu xuiapue purixineri aimore tutu xeteneai. Kireue Yuta nikau kuna taiwoteneaina, kireue Yesusupo aimore tianutianuwopi, taiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Xurise Yuta teu xeika xetau xeteneai apimi xeikae ninipo tumu teu xeika saneri, Poluno Parnapasino xiwaxiwainiketeneai. Kakineri, ounikiepure xe tapuniki kuruwopure xeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Apimie pa kapia kakepure xeri Parnapasino Polunoe kuna iyeserinexeri Likonia tistirikipo erewese aimore, Listra erewese xeika Terpe erewese xeika xosa ximi xowoto, pa erewese aimore tomuro puroteneai wese yau xeika xosa ximi xowotowoteneai. ");
INSERT INTO six_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pa wesewese xounexeri asinaku kuna uteiwopi saina texeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra erewese paiya kire apu, nupo siau sokisoki xuweu purotai. Anae iyaratia, siau xoxixati xayakaxayaka texirouwatixe. ");
INSERT INTO six_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Polue kuna uteiwati pa apue kuna iyesetai. Kakati Polue sokisoki kukouna xekoatia, pa apu xousuwotai nu asinaku xepina sie xetai. ");
INSERT INTO six_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paxati Polue sokisoki kuna, kunauna, “Ne sarounau tumuwo,” wotai. Kakati pa apue potirouna sarou texetai. ");
INSERT INTO six_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Xokupa xuiapue pa kapia Polue kakati xekerineri, Likonia nikau kunae ipaki yaxineri, “xoiteue apu sie putauneri sini xosa kouneri,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kakerineri Parnapasi xoiteu Susu woteneai. Polua nu kuna tua xati, wenuneri xoiteu Ermesi woteneai. ");
INSERT INTO six_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pa xoiteu Susupo muris ata paiya erewese koikato wotaipo sepuri isimaro purina. Pa muris atapu xuriatitie kireu pulmakau sona xeika kireu kakai kinuworoki xeika tina, erewesepu sepuri isimaro kotai. Nuko xeika xuimiapimi xeikae Parnapasino Poluno xoniki iwopure kaketeneai. ");
INSERT INTO six_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kakeri Yesusupo tianutianuwopi aimorei nini Parnapasino Polunoe paire kuna iyeserineri kokaipa ure urerineri, ninipo nekei kiraikaraiwoxeteneai. Kakerineri xuiapu xopu keikei xonaneri ipaki yaxineri, ");
INSERT INTO six_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yewapu xura, ama tini mua kapia kakinukuna? Sini apu, taki sieni. Sini tini xosa asinaku kuna ipaki uteinua, tini mua aipu sapi xosa muris tirounuku wetinari, Xoiteu ekeoma tuku xosa pirixinari xouwa. Xoiteu nue xokupa sapi purotai tuku mena iyarina, xasi iyarina ou iyarina woyai. ");
INSERT INTO six_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Suwau, asitikimana nikau yause xosa paiya xokupa xuiapu wetinikati nikou kapiarei texeneai. ");
INSERT INTO six_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pana apue sipawopu xuweuwopinerire xiri ximiakeyaixe. Xuwe. Xokupa yause tini xosa asinaku kapia kakirouna. Nue ene tumuwati mena weti tini xosa kouna, kakati xokupa asinaku xoye mana. Tini xokupa xoye tikati tinipo xotikikemu nimaririnuku,” niketai. ");
INSERT INTO six_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ninie pa kakineri kunawoteneai sorena, xuimiapimie nio xiri xoniki iwopureni kutu xeri taiyerinikineri xiri sokisoki xeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pana xurise kireu Yuta nini Antioku erewesepu xeika Aikoniamu erewesepu xeikae Listra erewese kouneri, xuiapu nikau nanunanu puruporo nikeri Polu xiwaixiwaiwoteneai. Kakerineri Polu xe kuruwoteneai. Kakerineri xumurounarineri, puru ti erewese kisauira weteri purotai. ");
INSERT INTO six_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kakeri Yesusure xoniki suwoteneai xuimiapimie ma tumuneri Polu koitauwori, xiyeri sarouna erewese minika manetai. Xurise kire asau xosa Parnapasi xeika Terpe erewese xowotai. ");
INSERT INTO six_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Poluno Parnapasinoe Terpe asinaku kuna uteiwoxeri xokupa xuiapue Yesusupo tataiwopi sayeteneai. Kakerinexeri xurise xiyerineri Listra xowoto, Aikoniamu xowoto, Antioku xowotouneri, ");
INSERT INTO six_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yesusupo tataiwopi nikau xonikikemu sokisoki niketeneai. Sokisoki kuna ipaki kanikineri, “Tini sokisoki xotikisu xosa pura. Sini Xoiteue Yakunikepina Xuiapu Tutu xosa manepure xinukua, xokupa xu purotai ime xosa akeri marinukueye,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kakerinexeri pa xokupa erewesepu xuiapue Yesusure xonikisuwoteneai nikau tumu tumunikereteneai. Pani nio xoye xuri katieinexeri kunikuniwoxeteneai. Pa kapiarei Kokaipaure xoniki suwoteneai xuimiapimi, Kokaipa xuporo iyainikereteneai. ");
INSERT INTO six_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Xurise Parnapasino Polunoe Pisitia tistiriki xopu xoworinexeri, Pampilia propinsi putawoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Xoiteupo kuna Perka erewese uteieineri, xurise Atalia erewese munoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ataliae kokouna xosa epixeri, sonikina Antioku xowotai, pa erewese paiya ekime Yesusure xonikisuwoteneaie nini sokisoki nikineri pa saina texepinerire Xoiteu xuporo iyainikeretenai. Kakeri saina tieinexeri Antioku xiyeri xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Utu putarinexeri, Yesusue xonikisuwoteneai xuiapu yainikeri kou kununuwoteneai. Kakeri, Xoiteue nini xupunikiro xokupa kapia kaketaire kaniketeneai. Ipaki kunaunexeri, “Xoiteue xetau xeteneai xuiapu nikau ime taiyerinikati xonikisuwoteneai,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kakerineri Yesusupo tataiwopi xeika Antioku xuwau yause puroteneai. ");
INSERT INTO six_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kireu Yutiapu apimie Antioku kouneri Yesusure xonikisuwoteneai xuimiapimi ipaki taitainikineri, “Tini Mosesipo tuxotapa taiwopu xuweuwari muputiki ipisa katiepu xuweuworia, Xoiteue xiyeri sotikepuwatixe,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Poluno Parnapasinoe pa kuna apimie kunawoteneai iyeserineri, nini xeika kuna sari ere tuwatarineri, pani paire kuna ouwoteneai. Kakerineri, Yesusure xonikisuwoteneai xuimiapimie Poluno Parnapasino, nio xeika kireu apimi xeika Yerusalemu xouneri tum teu xeika Yesusupo tianutianuwopi xeika kuna kutuwopinerire tumunikereteneai. ");
INSERT INTO six_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yesusure xonikisuwoteneaie xesanikeri, Ponisia tistiriki xeika Samaria tistiriki xeika xopu xosa xowoteneai. Pa aimore tistrikipo xuimiapimie Yesusure xonikisuwoteneai xosa xouneri ipaki akumenikepi saina tineri, “Xoiteue kakati kireu xeteneai xuiapu kinie xoniki pirixeteneai,” xeteneai. Kakeri, Yesusure xonikisuwoteneai xuiapue pa kuna iyeserineri xonikikemu xiri asinaku xetai. ");
INSERT INTO six_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Xouneri Yerusalemu putawori, Yesusure xonikisuwoteneai xokupa xuiapu xeika Yesusupo tianutianuwopi xeika tumu teu xeikae kusoniketeneai. Kakeri, Poluno Parnapasinoe Xoiteue nio xupunikiro xokupa saina tetaire kaniketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pana Parisi kini nikau kireu Yesusure xonikisuwoteneaie sari ipaki kunauneri, “Xetau apimi xeteneai apimie siko xopu mopure xineria, mupuniki ipisa kakatieinari, kanikari Mosesipo tu taiwopineri,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kakeri,Yesusupo tianutianuwopi teu xeika tumu teu xeikae pa kuna kutuwopure kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Xokupa kuna kunauweineri, Pitae sarouna ipaki kanikina, “Yewapu xura, tini sipa, ekime Xoiteue saina uteina sikeyai, yepa xetau xeteneai apimie asinaku kuna tinikiti iyeserineri xonikisuwopinerire tumuyereyai. ");
INSERT INTO six_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Xoiteue xokupa xuiapu nikau xonikikemu sipauweina, siko sikeyai sie Xoiteupo Supo Youya tiniketai. Nu xoukemu nimaririrei tinikepure pa kapia atarisiketai. ");
INSERT INTO six_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nue kire kapia siko xosa kakina nini xosa xetau kapia kakatixe. Xuwe. Nure xonikisuwori, pa xonikisuwopi imerei sore xunu xesauwerinikati ekero asinaku xeteneai. ");
INSERT INTO six_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pa xati tini ama Xoiteu eruruwopure xinukuna? Tini kaki xanari mua xu sapi Yesusure xonikisuwoteneai xuiapu xauranikiro tawaku. Ekime asisikimana xeika siko xeika rania mua xu xemeropu itou xuwe. ");
INSERT INTO six_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pana pa apimi rania xiyeri tiniketai sie, Kokaipa Yesusupo xousuwarei tianisikati sini Xoiteue xiyeri tisikepina xi xosikisunuku,” niketai. ");
INSERT INTO six_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pitae ipaki kunawatia, apimi kununu puroteneaie kire kuna xapa tepu xuwe. Nini Parnapasino Poluno niau kuna xosa xakuniki iyareteneai. Kakeri, xetau xeteneai xuiapu kini xopu xosa Xoiteue nio xupuniro xumu xonuxonu kapia eretaire kunawoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ninie kunauwexeria, Yemsie ipaki kunauna, “Yewapu xura, tini yeu kuna iyesa. ");
INSERT INTO six_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimonie tini katikina ximuximu yause Xoiteue xetau xeteneai xuiapu xosa kouna, ninipo xuiapu kini ikou xuiapu xi tinikati nukou xuiapu sayeteneai xetai. ");
INSERT INTO six_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kunatureture nikau kuna rania panumuni. Ninie ipaki kuna xayauneri, ");
INSERT INTO six_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kokaipae kunauna, “Tepitipo apu kini paiya kire kesia ata suruwotai sie. Pana xurise ye xiyeri kouneia xiyeri sarepine. Mua atoropu xuru xoxixetaia, yei xiyeri atineia, pa ata xiyeri sarepine. ");
INSERT INTO six_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Kakitia xetau xeteneai xuiapue ye Kokaipa xirekiyepineri. Paiya xetau xeteneai xokupa xuiapu, ikouni tumunikieitiai.” Muaiya Kokaipapu kuna. Ekimeni kutu kunauna mua kapia akipa xepineri xeyai.’ ");
INSERT INTO six_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Pa xati yeu nanunanu muai, sini mua xetau xeteneai xuiapue xoniki pirixineri Xoiteu xosa xowoteneai xu tinikepuxe. Xuwe. ");
INSERT INTO six_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mua kuna nakau xosa xayaunuku xesau ipaki kanikinuku, apue xorei xoiteu xouiwoteneai xoye sapi nini texeni, pa kapia paie nu Xoiteu ekero xunu tuku xina. Nini kakixaneri xoxixoxi ayaka kapia kakexeni. Nini kakixaneri apue noto paru muri tineri ouweri xumotai nexeni. Pa amure noto xosa yawi purati nexeni. ");
INSERT INTO six_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Siko sipa, ekimeni kouna mua xosapa xetau xeteneai nikau xokupa erewese xosa Mosesipo tuxotapa uteirouneri apu tuku. Ninie xokupa Yuta nikau arikepi yause xosa nupo kuna kununu ata yau ninaxirouneri.” ");
INSERT INTO six_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yesusupo tianuwopi xeika tumu teu xeikae Yesusure xonikisuwoteneai xuiapu xeika kuna ouworineri, aimore apu tumunikereteneai. Kire nu Yutasi, nupo kire wenumu Parsapasi, kire Sailasi. Ninie Yesusure xonikisuwoteneai xuiapu xopu tumu puroxeteneai. Nini axiri Poluno Parnapasino tuku xesanikeri erewese Antioku xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nini xupunikiro kire nakau mua kuna tuku xesauneri, “Sini Yesusupo tianutianuwopi xeika tumu teu xeika, sini takipo xatatikimana, sinie mua nakau xayaunuku, tini xetau xeteneai xatasikimana kini erewese Antioku xeika propinsi Siria xeika Silisia xeikapu xokupa sanawa yau purikiriai xosa mua nakau aiyau xesaunuku. Yewapu xura asinaku asau. ");
INSERT INTO six_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Sini kuna ipaki iyesikiria, siniropu kireu apimie tini xosa utuneri kuna xotiki xuseri tini xouxou wakiriai. Kakineri tinipo nanunanu puruporowopi saina teteneai. Paiya sinie panumu kakanikepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pa kapia kaketeneaire kuna sinie iyeserinuku, xatasikimana aimore xesanikikiri tini xosa kopinerire xosiki tumaxi kuna ouwori tumunikeri, emesikimana axiri xiri xosikienikirounuku, nini Parnapasino Poluno tuku xesanikinuku. ");
INSERT INTO six_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nini xumopineri sieni kutu itouna, nini sikou kokaipapu wenumu Yesusu Kristusure kunawopi ximikerixe. ");
INSERT INTO six_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pa xati sinie Yutasino Sailasino xesanikikiri tini xosa utuneri, mua kuna niou supunieni tini katikepineri. ");
INSERT INTO six_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Xoiteupo Supo Youyae sini xeika purati ipaki kuna ounuku tini xosa sini xokupa xu soxepi xiraxinuku. Pa xati tini mua kapia kireni taiwa. ");
INSERT INTO six_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tini kakixanari xorei xoiteu xoniki iwopure noto ouwoteneai naku. Tini kakixanari noto xosa yawi purati naku, kaki xanari apue noto paru muri tineri ouweri xumotai naku. Pa xeika tini xokupa ayaka kapia emeseriwakuai. Tini ati epinari pa kapia kapia emeserinari paiya asinaku. Sinipo kuna pa kireni. Tini asinaku puropi pura,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yesusue xonikisuwoteneai xuiapue pa apimi xesanikeri toupa Antioku xowoteneai. Antioku pa xosa Yesusue xonikisuwoteneai xuiapu kunununikerineri pa nakau tiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xuiapue ninaieineri, niko sokisokinikepina kuna asinaku tiei nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yutasino Sailasino nini kunatureture. Pa xati xokupa kuna asinaku Yesusure xonikisuwoteneai xuiapu tinikineri, pa kapiae ninipo xonikikemu sokisokiniketeneai. ");
INSERT INTO six_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Nini xayakaxayaka xuwau yause Antioku puroxeteneaie, Yesusure xonikisuwoteneai xuiapue nini kusonikineri xoniki kururei xesanieri, koteneai apimi xosa xiyeri xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Poluno Parnapasino paiya nini Antioku puroxeteneai. Kireu xokupa apimi xeika Xoiteupo kuna xuiapu taitainikete, Kokaipapu kuna uteiwopi saina tetewoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kireteu asau xouwatia, Polue Parnapasi ipaki kauna, “Sini xokupa erewese xiyeri xounuai, ekime sioe Kokaipapu kuna xatasikimana tinikianiai xekexekenikaxau. Kakinuai, nini asinaku purinerire, e xuwerauna sipawaxau,” wotai. ");
INSERT INTO six_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kakati Parnapasie Yoni, nupo kire wenumu Maki, nio xeika xowopinaure sowopure xetai. ");
INSERT INTO six_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kakati Polue kunauna, “Pa apue ekime propinsi Pampilia weisiterina, sini xeika xou saina tepi xirexetai, pa xati sini xuweu xowaxau,” wotai. ");
INSERT INTO six_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paire ere kawataxeteneai. Kakerineri xetaxetau uteieineri kirenini saina tepu xuwe. Parnapasie Yoni Maki sou xouna kire kokouna xosa epineri Saiprusi sou xosa xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kakati Polue Sailasi sowotai. Nini xowopuxeri yause paiya, Yesusure xonikisuwoteneai xuiapue nini kanikinexeri, “Kokaipae xousuwawati tiani tikirounae tini xeika purina,” niketenai. ");
INSERT INTO six_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Poluno Sailasinoe propinsi Siria xeika Silisia xeika teixanaunexeri, Yesusure xonikisuwoteneai xuiapu payau puroteneai Polue sokisokiniketai. ");
INSERT INTO six_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polue Terpe xeika Listra xeika xosa utu putawotai. Pa erewese xosa kire Yesusure xousuwotai apu, nupo wenumu Timoti, nue purototai. Nu kire Yutapu Yesusure xousuwotai xuipo nirau. Nupo omo paiya nu Kriki nikau. ");
INSERT INTO six_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listrapu xuiapu Yesusure xonikisuwoteneai xeika Aikoniamupo xuiapu xeikae nupo kapiaure ipaki kunauneri, Timoti nu asinaku apu xeteneai. ");
INSERT INTO six_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polue Timoti sou xowopure, tina mupo ipisa katieruwotai. Yuta apimie pa sanawa yau purori, nanuworina pa kapia kaketai. Pa amure, xokupa Yuta nini sipa, Timotipo omo paiya nu Kriki. ");
INSERT INTO six_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Erewese xouxanauneri, mua kuna ekime Yesusupo tianutianuwopi xeika tumu teu xeikae Yerusalemu ouwoneai, Yesusure xonikisuwoteneai xuimiapimi tiniketeneai. Kunauneri, “Tini mua kuna taiwa,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kakeri Yesusure xonikisuwoteneai xuiapu teu nikau xonikisu xiri sokisoki xati, xokupa asau xosa ninipo xoka xiri kokaipa xetai. ");
INSERT INTO six_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Polu xura Sailasi xura Timoti xurae propinsi Esia kuna uteiwopineria, Xoiteupo Supo Youyae taiyerinikati, Prikia tistiriki xeika Kalesia tistiriki xeika xopurei xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia tistiriki xexe xoworineri, propinsi Pitiniaro manepineria, Yesusupo Supo Youyae taiyeriniketai. ");
INSERT INTO six_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pa xati Misia emeserineri toupa erewese Troasi xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ukumani Polue kire sapi xiniwepi sie xekotai. Xekoatia kire apu propinsi Mesetoniapue tumu puri ipaki yauna, “Ne xasi xusanau Mesetonia kounau tianisike,” wotai. ");
INSERT INTO six_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Polue pa kapia xekerati, sini sapauni Mesetonia xowopure ime xirekiriai. Sini sipa, nini xosa kuna uteiwopinukure Xoiteue yaisiketai. ");
INSERT INTO six_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pa xati Troasie tauro xosa epitikiri, kokounae Samotresi souni kutu munauti mautipa xowotai. Kire asau xosa paiya kokounae Neapolisi xowotai. ");
INSERT INTO six_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pa wese wetinuku Pilipai utu putaukiriai. Paiya kire erewese ekime Romue kou poro miseniai, paiya tistiriki Mesetoniapu akereki erewese. Pa erewese xosa kireu asau purikiriai. ");
INSERT INTO six_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yuta nikau arikepi yause xosa erewesepu sepuripo isima kisauira munanuku, kire enero xoukiriai. Sinie nanukiriaia, pa ene tomuro kire kunikunirouneri iri purina xikiriai. Pa enero kireu xuimie kununu purori xekenikerinuku, nini xeika misinuku kunaukiriai. ");
INSERT INTO six_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kire xui nupo wenumu Litia, nue pa kuna iyesetai. Nue Xoiteu xosa muris tirouna. Nu Taiataira erewesepu xui, nu mari ewou xosa xe saina tirouna. Kokaipae xoukemu pirierati, Polue kunawotai kuna xosa xaku iyaretai. ");
INSERT INTO six_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nuko Yesusupo wenumurei ene isati, ata emeumana rania kaketeneai. Nuko Yesusupo wenumurei ene isieinapa sini kasikina, “Tini nanunuku ye Kokaipaure xiri xousuna xinaria, manari yeu atoro pura,” niketai. Kakerina xiri sokisoki xati nupo kuna taikiriai. ");
INSERT INTO six_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kire asau xosa sinie kunikuniwopure kire iri xosa xoukiria, kire aipu xuie imero tutumasiketai. Pa xui nu kire yaniyani tuku purati, paie xurise akipa xepina sapire kunaurouna. Kakati pa xui yakuwoteneai apimie nupo saina xosa kokaipa xe tirouneri. ");
INSERT INTO six_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pa xuie Polu xeika sini xeika taisikinani ipaki yaxina, “Mua apimia nini Xoiteu Xouropu saina apimini kutu. Xoiteue xiyeri titikepina ime nini katikirouneri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Xokupa asau pa xuie kaketai. Kakati Polue nupo uru iyesepi xiri xirari, pirixina pa yaniyani kauna, “Yesusu Kristusupo wenumurei, ye kanine, ne mua xui wetinau xouwo,” wotai. Kakati pa yaniyanie sapauni pa xui wetina xowotai. ");
INSERT INTO six_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pa xuipo yayakue xekoria ninipo xe tepineri ime xiri xuwexetai. Paire Poluno Sailasino xoroniki tinikineri, kununu wesepu tumu xosa puruniki xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kuna xekexeke xosa soniki xouneri ipaki kanikineri, “Mua apu aimore nini Yuta kinipo. Ninie sikou erewese xosa poripori sarepi saina tinexeri. ");
INSERT INTO six_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kakineri, siko Romu sanawapue kireu xeseu kapia kakepi xeseu paiya, xuiapue nini tainikepinerire purunikepure xineri,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Xuiapu kou kununuwoteneaie rania nini xosauni kuna suwoteneai. Kakeri kuna xekexeke apimie ninipo nekei unonorinikineri, sina pokae ounikepinerire kireu apimi kaniketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ninie xoxi ouounikeri, kuna xekexekei kakauya ata xosa iyainikereteneai. Kakerineri, ati yakuniepinaure kakauya ata yakuwotai apu sokisoki kuna kawoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kakauya yayakue kuna xekexeke nikau kuna iyeserina, kakauya ata kama minikani kutu xosa iyainieretai. Kakerina ninipo sieniki namasae sokisoki taretai. ");
INSERT INTO six_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Xinepiniki Poluno Sailasinoe Xoiteure kunikunineri siri woropi saina texeteneai. Kakeri kireu kakauya apimie iyesi puroteneai. ");
INSERT INTO six_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kukupuni kire kokaipa mimie mana, kakauya atapu xokupa xai litowotai. Kakati kakauya atapu xokupa isima taixanauwati, xokupa kakauya apimi nikau sokisoki xume xuxurexetai. ");
INSERT INTO six_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kakauya apimi yayakue sarouna xekoatia, kakauya atapu xokupa isima tatai purati, nanuna xokupa kakauya apimi ximi xouweteneai xetai. Pa xati nukou sawaruwaru puru tina nukoini nuko ouwepure xetai. ");
INSERT INTO six_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kakati Polue sokisoki uru yaxina, “Ne kakixanau nakieni naki xoxixoxiwou. Sini xokupa purinuku,” wotai. ");
INSERT INTO six_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kakauya apimi yayakue naku timopinerire apimi iyainikerina keikei Poluno Sailasino puroxeteneai ata kamoro manetai. Xiri ximikeri urerina Poluno Sailasino niau siani sakoro utu ukurowotai. ");
INSERT INTO six_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kakerina kisau soniki munana, ipaki kotonikina, “Kokaipa apu axiri, ye amu amakiti Xoiteue ye xiyeri tiyepinana?” niketai. ");
INSERT INTO six_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kakati ninie ipaki kunauneri, “Ne Kokaipa Yesusure xonisuwaua, Xoiteue naki xeika neu kinianimana xeika titikatia tini nukou xakuai,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kakerineri Kokaipapu kuna nuko xeika nukou kiniaumana xeika xosa uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kakexeri, xinepiniki pa kakauya yayakue ninipo usi kurorinietai. Kakerina nuko xeika nukou kiniaumana xeika Yesusupo wenumurei ene iseteneai. ");
INSERT INTO six_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kakerineria kakauya yayakue, nupo atoro soniki xouna xoye tinietai. Pa kakauya yayaku xeika nupo xokupa xuimiapimi kini xeikae Xoiteure xonikisuneri xiri nimaririwoteneai. ");
INSERT INTO six_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xoripesau kuna xekexekei xokai teu xesanikeri, kou kauya yayaku ipaki kauneri, “Kuna xekexeke teue kunauneri, ne pa apu aimore weinikitau xowoxepineri,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kakeri kakauya yayakue Polu xona kawotai. Ipaki kauna, “Tini kakauya weu xowaxakuaire kuna xekexekei kuna xesawoteneai. Pa xati tini kakauya weti xounaxari, xotiki asinakurei puraxa,” nietai. ");
INSERT INTO six_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paire Polue xokai teu ipaki kanikina, “Sini Romu sanawapu apu axiri. Amakati kuna xekexekeipa sinipo kuna ati xekerineri nini pa kapia xoreiereteneai re xuwesikepu xuwena? Xuiapu ekinikiro ai ousiketeneai. Kakineri kakauyaro iyaisikereteneai. Paire rau yopini ximiarei xesasieri xowopinua, wo? Xuweni kutu. Nikoini maneri kisau xesasikepineri,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polupo kuna xokaie kuna xekexeke xosaniki tixowoteneai. Poluno Sailasino nini Romupo xeri kuna xekexekei pa kuna iyeserineri, ximiketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kuna xekexekei kakauya ata xouneri eiyo kuna kanikerineri, kisau muna yataniketeneai. Kakeri kanikineri tini mua erewese weti xouwa niketeneai. ");
INSERT INTO six_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nini kakauya ata wetineri, Litiapu atoro xowoxeteneai. Yesusure xonikisuwoteneai xuiapu xekenikerineri xonikikemu sokisoki nikepure kireu kuna tiniketeneai. Kakerineri erewese wetineri xowoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Polue emeumanapu erewese Ampipolisi teipa xowoteneai. Pa erewese wetineri erewese Apolonia xowoteneai. Pa erewese rania wetineri erewese Tesalonaika xou putawoteneai. Yuta nikau kire kununu ata pa erewese purina. ");
INSERT INTO six_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Polu nuko kakirouna sie kapia kaketai. Yuta apimi xeika pa kununu atoro mana, xeimore asau Yuta nikau arikepi yause xosa Xoiteupo kuna nakau xosa purotaire nini xeika kunawotai. ");
INSERT INTO six_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Xoiteupo kuna xotapa ipaki piteu kanikina, “Mua apu Xoiteue nukou xuiapu xiyeri tinikepinaure tumuworeyai, nu tatau tina xumopinae sewai xiyeri saropina,” niketai. Kakeri ipaki kanikina, “Mua Yesusu, nupo kuna ye uteiyeyeritikitiaia, pa apu nu sore Xoiteue nupo xuiapu tinikepure tumuworetai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kakati kireu xuiapue xonikisuneri Poluno Sailasino tainiketeneai. Kakeri, xokupa Kriki kinie Xoiteure muris tirounerie rania nini tainiketeneai. Kakeri xokupa xui nini ere weniniki tukue rania tainiketeneai. ");
INSERT INTO six_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yuta apimie pa xuimiapimi xekenikeria, nini tainikeri xonikikemu tatauwotai. Paire kireu xoxi apimi kununu wese yau purirouneri tiniketeneai. Kakerineri xokupa xuiapuni kutu kunununikerineri, pa erewesepu xuimiapimi xonikikemu sareri, ninie xouneri Yesonupo ata isima kerewoteneai. Kakineri Poluno Sailasino kisau soniki xouneri, xuimiapimi xupunikiro iyainikerepure xirekinikepi saina teteneai. ");
INSERT INTO six_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pana nini xekenikepu xuwe. Yesonu xeika kireu Yesusure xonikisuwoteneai xuiapu xeika purunikineri pa erewesepu tumu xosa xowoteneai. Kakineri ipaki yaxineri, “Mua apimie xokupa sanawa texineri xoxi kapia kakirounerie ximine mua kou purineri. ");
INSERT INTO six_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yesonue nupo atoro soniki xou purotai. Pa xokupa apimie Sisaripo tu taiworixe. Kunauneri, ‘Kire kokemu purina nupo wenumu Yesusu xirouneri,’ ” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Xuiapu xeika erewesepu tumu teu xeikae pa kuna iyeserineri ureri xiraxarawoteneai. ");
INSERT INTO six_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kakerineri tumu teue Yesonu xeika kireu apimi xeika kanikati xei kuna isayaxeri weinikiteri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Xori euti moati, Yesusure xonikisuwoteneai xuiapue Poluno Sailasino xesanikeri Peria erewese xowoxeteneai. Peria utu putauneri, Yuta nikau kununu atoro manexeteneai. ");
INSERT INTO six_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yuta xuimiapimi Peria puroteneai nikau kapia paiya, Tesalonaika puroteneai nikau kapia xiri emeseriniketeneai. Ninie Polupo kuna iyeserineri xiri xonikiewoteneai. Kakineri Polupo kuna suaure xoreire xi sipawopure, xokupa asau Xoiteupo kuna nakau xosa purotai ninaxineri uteirouneri. ");
INSERT INTO six_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kakineri Yuta xuimiapimi xokupae xonikisuwoteneai. Kakeri xokupa Kriki xuimi weniniki tukue rania xonikisuwori, apimie rania xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Xurise Tesalonikapu Yuta apimie, Polue Xoiteupo kuna Peria utei purina kuna iyeseteneai. Paire pa erewese xouneri xuimiapimi xoniki xusineri nanunanu puruporo niketeneai. ");
INSERT INTO six_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kakeri, Yesusure xonikisuwoteneai xuiapue sapauni Polu xesawori toupa usiemaro xowotai. Sailasino Timotinoe Peria puroxeteneai. ");
INSERT INTO six_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Polu yatawopu koteneai xuimiapimie, Atens xexe Polu yatawoteneai. Xiyeri xowopurexeria, Polue Sailasino Timotino ipaki kuna xesarinikina, “Tini sapauni kouyeyaxakuai xi kuna xesari,” nietai. ");
INSERT INTO six_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Polue Sailasino Timotino Atens yakuniki purina, xokupa xoreixorei xoiteu nikau xeniroroi xekotai. Paie kakati xoukemu xiri xoxixoxixetai. ");
INSERT INTO six_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pa xati Yuta nikau kununu ata xosa xouna, Yuta apimi xeika xetau xeteneai xeikae Xoiteure muris tirouneri xosa kunawotai. Kireni kireni asau xosa kununu wese xouna xuiapue pa wese kou purori kuna kanikirouna. ");
INSERT INTO six_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kakati kireu Epikurian kinipo sipa apimi xeika Stoikipo sipa apimi xeikae nu xeika kuna tuwata xeteneai. Kireue kunauneri, “Mua apu peroroipa nu amu kuna kunawopure xinana?” xeteneai. Kakeri kireue kunauneri, “Kireu wese wesepu xoiteupo kuna uteina rau,” xeteneai. Polue Yesusupo asinaku kuna kanikepure, Yesusure kanikina xumunuku kopa upurei xiyeri saropi kapiaure kanikete wati, ninie pa kuna kunawoteneai. ");
INSERT INTO six_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Polu tineri Areopakusi siriro kununurouneri kaunsolu xosa sou xowoteneai. Ipaki kauneri, “Mua oma kuna nei xuiapu tinikiroune sini sipawopure xinuku. ");
INSERT INTO six_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sinie neu kuna iyesikiria, xiri xetauni kutu. Pa xati ne kunautia kuna xotapa sini sipawopure xinuku,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Xokupa Atensi musimore xeika kireropue kouneri Atensi erewese puroteneai xeika nini kire sapi tirouworixe. Xuwe. Nini sipesi oma nanunanure kunani kutu iyesepure xirouneri. Kakineri nikoniko xetau kuna iyeseteneaire kunaurouneri. ");
INSERT INTO six_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Polue Areopakusi siriro kaunsolu teu xopuro sarou ipaki kunauna, “Tini Atensipo apimi, tinie muris tepi xokupa sokisoki kapia kakari xeketikine. ");
INSERT INTO six_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ye ximuximu teipa xoune, tinie muris tirounuku xuru xekeutiai. Kire alta xosa mua kuna ipaki xayareniai, ‘Mua alta paiya kire xoiteu sini sipa xuweupo xi xayareneai rania xekeutia.’ Pa Xoiteu tini sipa xuweu ai nure muris tikiriaire, ye tini xosa kuna uteiwopurexine. ");
INSERT INTO six_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Xoiteue mena xeika ou xeika iyarina xokupa sapi pa xosa iyarati puroyai, pa Xoiteu nu mena xeika ou xeikapu Kokaipa. Pa xati, nu apimie xuwoteneai muris ata xosa misirouwatixe. ");
INSERT INTO six_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nu amu sapire xuwe xati apu xupusikie kire sapi iyari nu tuwopuxe. Xuwe. Nukoini xokupa xuiapu ekinikioma tinikina, youya tinikina, xokupa sapi tinikinaurouna. ");
INSERT INTO six_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xoiteue kakati kireni asisiki piourei xokupa xuiapu ekinikiposi ouwoyai. Kakina xokupa ouyau soinikati purineri. Nukoini nini puropineri yause iyarina, ninipo oupo atu sorinikeyai. ");
INSERT INTO six_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Xuiapue maneri Xoiteu nuko xiri sipawopineri paire xina, pa xati nu xirekepi saina tepinerire, iyainikerati purineri. Pana siko xokupa kireni kireni weisikiteri xetauro puratixe. ");
INSERT INTO six_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Sini nu xosa ekisikioma tinuku nuko kirenie sokisoki sikati texirounuku.’ Paiya takipo kireu sipa apimie kunauneri, ‘Siko rania nukou nono purinuku,’ xeneai sie. ");
INSERT INTO six_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sini Xoiteupo nono purinukuna, Xoiteu nu kolu sie silwa sie xe sie xinuku nanuwopuxe. Nu siko apu xupusikie, nanusikie erirounuku sapi sie xinuku nanuwopu xana xuwe. ");
INSERT INTO six_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Ekimepu apimi nini sipa xuwe xati, pa yause kakirouneri kapiaure Xoiteue xekepi kunaurouwati xana xuwe. Pana muaiya xokupa wesepu apu xotiki pirixa xina sokisoki kunauna. ");
INSERT INTO six_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nue xuiapu kuna xosa iyainikerepinaure kire yause itou iyaretai. Nukou kutu kapiarei, ouropu xokupa xuiapu nikau kapia uteiwopina. Pa kuna yakuwopina apu itou tumuworetai. Pa apua xumati Xoiteue kopa upuropu xiyeri saretai. Pa xati Xoiteue pa saina tuwotaire sini xiri xosikisuwopu,” niketai. ");
INSERT INTO six_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Apu upurei xiyeri saropi kuna ninie iyeserineri, kireue Polu pirewoteneai. Kakeri kireue kunauneri, “Pa kuna xiyeri kunawau sini iyesepure xinuku,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kakeri Polue weniki xowotai. ");
INSERT INTO six_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kakati kireu apimie taineri xonikisuwoteneai. Kire nu Tionisiusu, nu kaunsolu teu xopuropu Areopakusi siriro kununurouna. Kire xui nupo wenumu Tamarisi, nue xousuwati, kireu xuimiapimie rania xonikisuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Xurise Polue Atensi wetina Korini xouna, ");
INSERT INTO six_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","kire Yuta tutumawotai. Nupo wenumu Akuila. Akuilapu weseni kutua propinsi Pontusu. Ekimenini, nupo xui Prisilano Itali sanawa wetineri koniai, pa amure, xokupa Yutae erewese Romu wetineri kire sanawa xowopinerire Sisari Klotiusue kunawoyai sie kaketeneai. Polue xouna nini xekenietai. ");
INSERT INTO six_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ninie saina tirounexeri sieni nu saina tina kesia ata tatamaxirouna. Polue nini axiri xeika purina saina tipurirouneri. ");
INSERT INTO six_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Xokupa Yuta nikau arikepi yause xosa Polue Yuta nikau kununu atoro xouna nini xeika kunaurouna. Yuta xeika Kriki xeika nikau nanunanu saroati Yesusure xoniki suwopinerire kakirouna. ");
INSERT INTO six_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailasino Timotinoe Mesetonia wetineri koxeria, Polue xokupa asau Xoiteupo kuna uteiwopi saina tetai. Yuta xosaniki ipaki sokisoki kuna uteina, “Yesusu nu Xoiteue nukou xuiapu xiyeri tinikepure tumuworetai apu,” niketai. ");
INSERT INTO six_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pana Yuta apimie nupo kuna iyesepu xirarineri, pirewoteneai. Pa kakeri nukou nekei xosa inaina purotai pokuweina ipaki kanikina, “Tini xuwexinaria, takipo xuni. Ye paire xu xuwe. Muaiya xetau xeteneai apimi xosa xounei kuna uteiwopine,” niketai. ");
INSERT INTO six_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Polue kakerina pa kununu ata wetina, kire apu wenumu Titiusu Yastusu, nupo atoro xowotai. Pa apue Xoiteure muris tirouna, nupo ata paiya Yuta nikau kununu ata tomuroni kutu purina. ");
INSERT INTO six_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yuta nikau kununu atapu tumupo wenumu Krispusu. Nupo xui xeika nono momuko xeika, nini Kokaipaure xonikisuwoteneai. Kakeri, Korinipo xokupa xuiapue Polupo kuna iyesineri, ninie rania xonikisuneri Yesusupo wenumurei ene iseteneai. ");
INSERT INTO six_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kire ukumu xosa Kokaipae Polu xosa kire xiniwepi sie sapie maieuna, ipaki kauna, “Ne kaki xanau ximikeu. Xuwe. Ne kunauweye. Ne supuni xotoxeu. ");
INSERT INTO six_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ye ne xeika purinena, kire apue sarouna ne xoxixoxinepu wati xana xuwe, pa amure, yeu xuiapu xokupa mua erewese purineri,” wotai. ");
INSERT INTO six_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kakati Polue kireni xitosani 6-teu poita Korini purina, Xoiteupo kuna uworiniketai. ");
INSERT INTO six_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pana Kalioe Akaia propinsipo akereki kapmani tumuwotai yause xosa, Yutapue xirini saneri Polu xiwaixiwaiwoteneai. Kakineri kuna xosa sou xouneri, ipaki kunauneri, ");
INSERT INTO six_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Mua apue xuiapu taitainikina tini kaki xanari tu taiwaku nikinani kireu kapiarei Xoiteure muris tirouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Polue ninipo kuna xapa kanikepure xetai sorena, Kalioe Yuta ipaki kanikina, “Tini Yuta, mua apue tu opokaiwatire e kire kapia xoxi kakati xoia, ye tinipo kuna iyesepine itou. ");
INSERT INTO six_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Muaiya tini takipo kunaure, wenitikire, tu xeikaure eiyorinuku ye xosa kounuku. Xeuxana takieni mua kuna kutuwa. Ye panumu sapire kuna xekopixe,” niketai. ");
INSERT INTO six_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kakerina kuna xosa xesaniketai. ");
INSERT INTO six_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kakati Yutapu apimie Sostenesi xorou teteneai. Nu Yuta nikau kununu atapu tumu xati, kuna wese tomuro ouwoteneai. Kakeria Kalioe pa kaketeneai kapiaure ei xepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Polue xokupa asau Korini purotaie, Yesusure xonikisuwoteneai xuiapu xupuniki tina kusoniketai. Kakerina Senkria erewese xouna tistriki Siria xowopure kire kokouna xosa manetai. Prisilano Akuilanoe nu xeika xowoxeteneai. Polue Senkria purotai yause xosa tapa uri asiwotai, pa amure, Xoiteu sokisoki kuna kawoyai xati kaketai. ");
INSERT INTO six_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epesesi erewese utu putarineri, Polue poro weinikitetai. Nukoni Yuta nikau kununu atoro mana nini xeika kunakunawotai. ");
INSERT INTO six_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ninie ipaki kauneri, “Sini xeika xayaka xayaka xuwau yause puro,” woteneai. Kakeri kanikina, “Ye kakepixe,” niketai. ");
INSERT INTO six_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Xurise xupuniki tina kusonikipuri kanikina, “Xoiteue xouweyati xoia ye tini xosa xiyeri kopine,” niketai. Kakerina kokouna xosa xiyeri xouna Epesesi wetetai. ");
INSERT INTO six_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kokounae xouna Sisaria erewese putawatia, Polue kokouna wetina pipa Yerusalemu xouna Yesusure xonikisuwoteneai xuimiapimi kusoniketai. Kakerina xurise weinikiterina toupa erewese Antioku xowotai. ");
INSERT INTO six_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Polue xayakaxayaka xuwau yause Antioku purotaie xurise xowotai. Tistriki Kalesia xeika Prikia xeikapu oupo wesewese puroteneai xosa teipa xouna, Yesusure xonikisuwoteneai xokupa xuiapu nikau xonikisu sokisoki niketai. ");
INSERT INTO six_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kire Yuta, nu erewese Aleksantriapue kouna Epesesi purotai. Nupo wenumu Apolosi. Nu asinaku kuna tua, nu Xoiteupo nakau sipani kutu. ");
INSERT INTO six_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kokaipapu Ime uworuwoniai xati, xuiapu uworinikepure nupo xoukemu xiri sokisoki xati, Yesusue kaketai kapiaureni kutu kanikirouna. Pana nu Yonie ene iserinikirouna xotapa kireni sipa. ");
INSERT INTO six_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yuta nikau kununu atoro xouna kuna uteiwotai. Nu xuimi apimi ximikinikepu xuwe. Kakati Prisilano Akuilanoe nupo kuna iyeserinexeri, sou xouneri Xoiteu ati sipawopinaure nupo Ime kawoxeteneai. ");
INSERT INTO six_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Xurise Apolosie propinsi Akaia xowopure xatia, Epesesipo xuiapu Yesusure xonikisuwoteneaie xowopina nanunanu sokisokiwoteneai. Akaiapu xuiapu Yesusure xonikisuwoteneaie sowopinerire nakau xayauneri kaniketeneai. Apolosie Akaia putauna, pa xuimiapimi Xoiteue xoukurunikina xonikisu tinikeyai xiri tianiketai. ");
INSERT INTO six_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yuta kinie xoreixorei kuna kunawoteneai kuna xapa tina xiri xuweyerinikepure, xuiapu ekinikiro kuna uteina xiri sokisoki xetai. Yesusu nu apu Xoiteue nukou xuiapu xiyeri tinikepure tumuworetai xina, Xoiteupo nakaupo kunarei atina kuna pitewotai. ");
INSERT INTO six_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosie Korini purotai yause xosa, Polu nu siriro purixanauwoteneai weseweseni texetaie, xurise erewese Epesesi kouna putawotai. Kireu Yesusupo tataiwopi Epesesi tutumanikerina, ");
INSERT INTO six_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ipaki kotonikina, “Tini xotikisunukua, Xoiteupo Supo Youya tinukure, e xuwe?” niketai. Kakati ninie kunauneri, “Xuwe. Sini kire Xoiteupo Supo Youya purina kuna iyesepu xuwe,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kakeri Polue ipaki kanikina, “Pa xati tini amukau ene isepi isikiriaina?” niketai. Kakati ninie kunauneri, “Sini Yonipo ene isepi isikiriai,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kakeri Polue ipaki kunauna, “Ekime Yonie xuiapu ene iserinikipuri ipaki kunauna, ‘Tini xotiki pirixinari ene isa. Kakinari pa apu iko tuiro kotai apure xotikisuwa,’ xeyai. Pa apure Yonie kunawotaia nu Yesusu,” niketai. ");
INSERT INTO six_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ninie pa kuna iyeserineri Kokaipa Yesusupo wenumurei ene iseteneai. ");
INSERT INTO six_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polue xosaniki xupo iyarati. Xoiteupo Supo Youyae nini xosa koati, xetaxetau kunarei kunauneri, kunatureturei kuna uteiyewoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pa apimi nini 12-teu siei kaketeneai. ");
INSERT INTO six_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Polue Yuta nikau kununu atoro mana asinaku kunaure sokisoki kunawotai. Nini xeika kunaupuri Xoiteue xuiapu yakunikirouna yausepu sapire ninipo nanunanu saretai. Nu xeimore poita panumu saina kaketai. ");
INSERT INTO six_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pana kireue xonikikemu xiri ukumuworeki xati xonikisuwopu xuwe. Xuiapu ekinikiro kokaipapu Ime niniawoteneai. Kakeri Polu xeika Yesusure xonikisuwoteneai kini xeikae Yuta nikau kununu atoro pani manepu xuwe. Xokupa asau Polue Tiranesipo xaya atoro xouna kuna uteirouna. ");
INSERT INTO six_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aimore xitosani panumu kaketai. Kakati Yuta xeika Kriki xeikapu xuiapu propinsi Esia puroteneaie Kokaipapu kuna iyeseteneai. ");
INSERT INTO six_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Polupo xuporo, Xoiteue sokisoki xumu xonuxonu kapia eretai. ");
INSERT INTO six_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Xuiapue nesikiki xeika mari xaku xeika Polupo muporo sorineria, pa xuru ti xouneri supa apimi tinikirouneri. Supa apimie teri, ninipo supa xuwe xatia, xoxi yaniyanie weniki xourouneri. ");
INSERT INTO six_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kireu Yutae texineri xoxi yaniyani xesauneri xe saina tirouneri. Kireue, Kokaipa Yesusu wenumu tineri pa imerei eruruneri xoxi yaniyani xesawopure xeteneai. Ipaki kunauneri, “Pa Yesusupo wenumurei, Polue nupo kuna uteirouna paie, ye sokisoki kuna kunaune tini xouwa xine,” xirouneri. ");
INSERT INTO six_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kire Yuta nikau ere xuriatiti, nupo wenumu Skepa. Nupo niraumana 7-teue panumu kuna xoxi yaniyani xosa kunaurouneri. ");
INSERT INTO six_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kire asau xosa pa kuna kunawori xoxi yaniyanie ipaki kuna xapa kanikina, “Ye Yesusu sipa ye Polu sipa. Pana tini yuxunani kutuena?” niketai. ");
INSERT INTO six_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kakati pa apu xoxi yaniyani nu xosa purotaie, nini xosa potirouna, nueni xiri ouniketai. Ninipo mupuniki xiri xoxixoxieina, nekei kirakaraieri niketai. Kakati pa ata wetineri mari xuweu xuweu keikei xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Xokupa Yuta xeika Kriki xeika Epesesi puroteneaie pa kapia yaraxetaire kuna iyeserineri, kokaipa ximi ximiketeneai. Paire Kokaipa Yesusupo wenumu xouroreteneai. ");
INSERT INTO six_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Xokupa xuiapu xonikisuwoteneaie kouneri, xetau xuimiapimi ekinikiro, ekime xoxixoxi kapia nikoe kakirounerire kunawoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Xokupa xuiapu osaurounerie, xokupa osapu nakau xokupa kunununeri xokupa xuiapu ekinikiro eseteneai. Pa xokupa nakaupo xe paiya 50,000 xe silwa waxi ninaxeteneai. ");
INSERT INTO six_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pa kapiarei Kokaipapu kuna xuiapu xosa sokisoki saina tati, ninipo misepi asinaku sokisoki xetai. Kakati texineri xokupa sanawa kuna uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Epesesi saina sokisokiati, Xoiteupo Supo Youyae nanunanu taitaiwati, propinsi Mesetonia xeika Akaia xeika xoworina xurise Yerusalemu xowopure kuna ouwotai. Ipaki kunauna, “Pareira masa xou xekerineia, xurise xounei Romu rania xekopine,” xetai. ");
INSERT INTO six_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kakerina tianurouneri apu aimore, Timotino Erastusuno xesaniati Mesetonia akeri xowoxeteneai. Polu nuko paiya xayakaxayaka xuwau yause Esia propinsi purotai. ");
INSERT INTO six_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pa yause xosa kireu apimie Kokaipapu Ime xiwaixiwaineri ere kuna tuwata xeteneai. ");
INSERT INTO six_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kire apu purotai nupo wenumu Temitriusi, nue silwa paie xuru erirouna. Nu xoiteu xui Artemisipo muris atapu xeniroroi erirouna xe saina tuku. Silwa sapi erineri kokaipa xe tirouneri apimi xokupa saina tiniketai. ");
INSERT INTO six_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Temitriusie pa apimi xeika, xetaxetau sapi erirouneri apimi xeika kunununikeri, ipaki kanikina, “Yewapu xura, tini sipa, sinipo asinaku xe mua xepu saina tirounuku xosa marouna. ");
INSERT INTO six_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mua apu Polue kokaipa xuiapu kini purunikina ninipo nanunanu poronikati, tini xekoto iyeseteukiriai. Nu erewese Epesesi kireni muanumu kapia kakatixe. Xuwe. Esia propinsi inainauwepure xina. Nue kunauna, ‘Xupusikie erikiriai xoiteu, nini xoiteuni kutu xuwe,’ xirouna. ");
INSERT INTO six_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Polupo mua kunae sinipo xepu saina wenumu touwerisikepina. Pani kire kuna muanumu. Nupo kunae kokaipa xoiteu xui Artemisipo muris ata paiya, xuiapu nikau nanunanu xosa xoxi sapi xepina. Ximuximua xokupa xuiapu propinsi Esia xeika xokupa sanawa yaupo xeikae mua xoiteu xuire muris tirouneri. Pana Polupo kunae nupo ere wenumu xoxixepure xina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Apue pa kuna iyeserineri, xiri kisamaira niketai. Kakati ipaki sokisoki xiraxarauneri, “Siko Epesesi sikau Artemisi nu akereki,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kakineri pani pa ere wese xosa ere xiraxarawori, xuiapue ere kunauxanauwoteneai. Kakineri xirini saneri kununu wese keikei woxoteneai. Mesetoniapu apu aimore Kaiusino Aristakusuno, nini Polu xeika texirouneri purunikeri niko xeika xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polu nuko xuiapu xopu xowopure xetai sorena, Yesusure xonikisuwoteneai xuiapue taiyeruwoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pa xeika, kireu Esiapu kapmani nini Polupo marou xati kuna xesaruwoteneai. Ne kakixanau kununu wese xowouneri sokisoki kuna xesaruwoteneai. ");
INSERT INTO six_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pa kokaipa xuiapu kinipo, nanunanu tururutararawotai. Kakati xiraxarauneri xetaxetau kuna kunauxanauwoteneai. Xokupa xuiapu nini amu xotapaure kou kununuwoteneai nini paiya sipa xuweni kutu. ");
INSERT INTO six_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yuta apimie Aleksantari suweri xuiapu ekinikiro xona tumuratia, kireu apimie xekeri nanuneri, nue poripori xotapa xeteneai. Xuiapue kuna youweri kuna xapa tinikepure Aleksantarie xupo xourowarina korekorewotai. ");
INSERT INTO six_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kakati xekerineri, nu Yuta kinipo apu xi sipawoteneai. Pa xati xokupa xuiapue supuniki turuneri ipaki ere urue yaxineri, “Siko Epesesi sikau Artemisi nu akerekini kutu,” xeteneai. Xuwau yause panumu uru kireni yexeteneai. ");
INSERT INTO six_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Xurise Epesesi erewesepu nakau xayaxayatuae xuiapu aunikeri, ipaki kanikina, “Tini Epesesipo apimi, iyesa. Epesesi erewese nu kokaipa xoiteu xui Artemisipo muris ata yakuwoto, mena xouropu xeseu xe, uraki koyai xeika yakuwotouna. Paia tini sipa. ");
INSERT INTO six_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Pa xati, apue mua kuna xasese manepuwati xana xuwena youweiya. Tini kaki xanari sapauni kire kapia kakaku. ");
INSERT INTO six_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Takie pa apu aimoro soniki makiriai. Pana ninie sikou muris atoropu sapi tepu xuwe. Pa xeika ninie sikou xoiteu xui pirewopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Temitriusi nu nupo saina apimi xeikae kire apure kuna tuku xatia, kuna iyesepi yause purina. Akereki kapmani purineri. Ninipo kuna, kuna xosa kutuwopineri. ");
INSERT INTO six_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tini pani kireu kuna tuku xatia, kununu yauseni kutuworakuai. ");
INSERT INTO six_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Pa xati iyesa. Sini mua kapia kakikiriaire kapmanipo akereki saina apue iyesineria, sini kokaipa poripori sarepure xinuku xineria, sini kuna xosauni kutu iyaisikerepineri. Sini mua kapia kakikiriaia xiri xotapa xuweu. Sini kotosikineri amakati kou kunununuku xiraxaraunukunaxeria, sini kire kuna xapa tepuxe,” niketai. ");
INSERT INTO six_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nakau xayaxayatuae kunarina, xuiapu xesanikati xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Xuiapu nikau punisi xuweiroatia, Polue Yesusure xonikisuwoteneai xuiapu yainikati kouneri kirero tutumawoteneai. Xonikikemu sokisokinikepi kuna tinikerina, kusonikeri, Mesetonia propinsi xowotai. ");
INSERT INTO six_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pa yau texina Yesusure xonikisuwoteneai xuiapu nikau xonikikemu sokisokinikepure, xokupa kuna tiniketai. Kakerina xurise Kriki sanawa xowotai. ");
INSERT INTO six_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Xeimore poita Kriki purotaie kokouna tina Siria tistriki xowopurexetai. Yuta apimie ouwepure kuna ouwoteneai kuna iyeserina, nanunanu purieina Mesetonia xiyeri xowotai. ");
INSERT INTO six_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kire apu Peria ere wesepu, nu Sopateri, Pirusi nirau, nue Polu xeika xowotai. Tesalonaika erewesepu apu aimore, nini Aristakusuno Sekuntusuno, Terpe erewesepu Kaiusi xeika, Timoti xeika, pa xeika Esia propinsipo apu axiri, nini Tikikusuno, Tropimusino, ninie rania Polu xeika xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pa apimie akeri xouneri Troasi erewese yakusiketeneai. ");
INSERT INTO six_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sini Pilipai purikiri Tupumoru Pususu Xuweupo Kokaipa Yause xuwexeri, kokouna xosa epinuku Pilipai wetikiriai. Autapa asau xuwexatia, Troasi yakusiketeneai apimi xosa xou putaunuku, kireni muris Troasi purikiriai. ");
INSERT INTO six_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Murisipo akereki asau xosa Yesusure xonikisuwoteneai xuiapu xeika xoye nepure kununukiriai. Polue iyati xowopinaro xati xuiapu xosa kuna uteiwotai. Kunaupa xouna xouna xinepi nikietai. ");
INSERT INTO six_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Sini kununukiriai ata kama paiya xouroni kutu tureture ata xosa purati xokupa nakue u purotai. ");
INSERT INTO six_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pa ata kama paiya xouro turetureuneri xeimore iri xuwoki xosa purati, kire nono tenemai, nupo wenumu Yutikusu, nue kire xupeuisima xosa misi purotai. Polue pani kuna suworisuworiwati, Yutikusue xinimewati ekutawotai. Xurise xiri xouiritina oro uraki kotai. Munaneri teteneaia xiri xumuroki. ");
INSERT INTO six_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Polue rania munana pa nono tenemai xosau xinina xoniketai. Xuiapu ipaki kanikina, “Tini kaki xanari eisekurowaku. Nu ekeoma purina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Polue xouro xiyeri mana, tupumoru poroporouna, xuimiapimi xeika netai. Kakerina nini xeika kunau xinati, xumietai. Xumiatia Polue xowotai. ");
INSERT INTO six_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kakati pa nono tenemaie ekeoma purati, xoniki merurei souxowoteneai. ");
INSERT INTO six_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sinie Polu wetinuku kokouna xosa epinuku erewese Asosi xou putaunuku poro Polu yakukiriai. Polu nuko imerei kopure, tini akeri xouwasikati kakikiriai. ");
INSERT INTO six_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nu kouna Asosi tutumasikatia, kokouna xosa souxounuku, erewese Mitilini xoukiriai. ");
INSERT INTO six_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mitilini wetinuku, kire asau xuwexatia Kiosi sou tomuro putaukiriai. Pani kire asau xuwexatia Samosi sou xosa putaukiriai. Pani kire asau xuwexatia erewese Miletusu xou putaukiriai. ");
INSERT INTO six_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polue Epesesi emeseriwopure nanunanu ouwotai, pa amure, nu xuwau yause Esia propinsi puropi xirarina kaketai. Itou xatia Pentikosipo Kokaipa Yause Yerusalemu xekopure, nu sapauwopure xetai. ");
INSERT INTO six_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sinie erewese Miletusu putaunuku Polue Epesesi Yesusure xonikisuwoteneai xuiapu nikau tumu teue xekopinerire kuna xesarinikati, kouneri xekoteneai. ");
INSERT INTO six_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kouneri xekoria, ipaki kanikina, “Ye ximuximu Esia putaune xokupa yause tini xeika purine, kapia kapia kakitiai takieni sipa. ");
INSERT INTO six_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","“Tini sipa, xokupa yause Yuta kinie yeu saina ororepure kuna ouwori, paie xoikemu tatau xeika eruru xeika sieki sieki wati xokupa yause muriroune. Kakeri ikou wenimi xiri ororine, Kokaipapu saina titiai. ");
INSERT INTO six_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ye ximirei tini tianitikepi sie asinaku kuna uteiwopu xuwe. Xuiapu nikau kununu xosa xeika takipo xokupa atoro xeika rania, tini taitaitikitiai, paiya tini sipa. ");
INSERT INTO six_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Sini Xoiteu xosa xosiki pirixirounuku, sikou Kokaipa Yesusure xosikisuwopu xeikaure, sipesi Yuta xeika Kriki xeika xosa sokisoki kuna uteiyai. ");
INSERT INTO six_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Paina iyesa. Muaiya Xoiteupo Supo Youya paie kakati Yerusalemu xoune. Yerusalemu ye xosai amu wau akipa xepina, ye sipa xuwe. ");
INSERT INTO six_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Xokupa wese ye xoutia xosa paiya, Xoiteupo Supo Youyae ipaki kuna utei kairouna, kakauya xeika xokupa xu xeika yakunina xirouna. Ye pa kireni sipa. ");
INSERT INTO six_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","“Ye ikou ekioma akereki sapi xine nanui xana xuwe. Ye ikou ekioma sokisoki tepure sokisoki xitixe. Xuwe. Ye mua ime xoutiai tainei mua saina Yesusu Kokaipa xosaupo titiai xuweiyepure xine. Mua saina paiya Xoiteupo xoukurure asinaku kuna uteiwopire saina. ");
INSERT INTO six_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Paina Yewapu xura, iyesa. Ye ekime tini xopu purine, Xoiteu xuiapu yakunikepina yausepu kuna uteitiai. Pana muaiya ye sipa, sewai tini xokupae yeu muaikemu pani xekoakuai xana xuwe. ");
INSERT INTO six_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Pa xati ye ximine atinei tini kuna katikepure xine. Kire apu tini xopuropu xuwe xinari paiya, yeu xu xuwe, ");
INSERT INTO six_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","pa amure, Xoiteupo xokupa nanunanu ye ximirei tini xosa uteiwopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tini ati sosopani epinari, Xoiteupo xuiapu Yesusure xonikisuwoteneai yakunikinariwa, pa xuimiapimi paiya nukou Nonopu yawieni kutu isayaniketai. Xoiteupo Supo Youyae pa Xoiteupo sipsipu teupo yayaku tini tumutikerati purinuku. ");
INSERT INTO six_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ye sipa, ye tini wetiki xouroutia, mamumamu xoxini kutue tini xopu maneria, sipsipu xoxixoxinikepineri. ");
INSERT INTO six_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Takipo kireu apimieni Xoiteupo xuiapu purunikeri niko tainikepinerire, saneri xoreixorei kuna, kunau xanauwopineri. ");
INSERT INTO six_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pa xati xokupa yause tini atinari sosopa epixakuai. Ye kakiai kapia kaki xanari nanunanu wetaku. Xeimore xitosani xosa asau xeika ukumu xeika xosa tini kireni kireni apu asinaku nanunanu tikepi ye wetepu xuwe. Ye tini taitaitikitia yeu ekiropu morepi kiririwotai. ");
INSERT INTO six_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Yei tini Xoiteu xuporo iyaitikeriti purinukuna, tini xoukurutiketaipo kuna nanuwakuaire xine. Pa xoukurue sokisokitikina, Xoiteue xokupa sapi nukou xuiapuni kutu tumunikeretai tinikirouna paia tini tikepina. ");
INSERT INTO six_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Yei kire apupo silwaurere kolurere e mari sapire ekie nepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Takieni sipa, ye ikoini ikoure saina tete ye xeika purianiyeteneai apimi xeikaure saina teteuroune. ");
INSERT INTO six_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ye xokupa saina tinepa, ipaki ataritikiyai, sini sokisoki saina tepu kapia taiwopu. Kakinukua apimi nikoini niko tianikepu xuweu woteneai tianikepu. Sini mua kuna Kokaipa Yesusu nukoini kunawoyai nanuwopu. Ipaki kunauna, ‘Apue kireu apimi sapi tiniketaipo nimariri paiya, apue nukou sapini tetaipo nimariri emeserina xeyai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Polue pa kuna kunarina, xoutapa ukurouna xokupa tumu teu xeika kunikuni wotai. ");
INSERT INTO six_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kakati xokupae ere murineri, Polu xonikineri uritokowoteneai. ");
INSERT INTO six_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Polue kanikina yeu muaikemu pani xekoakuai xana xuwenikati, nure xiri xonikisuaxetai. Kakerineri kokouna xosa sou xouneri yatawoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tumu weniki xounuku kokouna xosa makiri, kokounae muri wetetai. Kakati sou Kosi xosauni kutu xoukiriai. Kire asau xuwexatia sou Rotesi xosa putaukiriai. Rotesi wetinuku Patara erewese xou putaukiriai. ");
INSERT INTO six_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patarae kire kokouna xekeukiri Ponisia tistriki xowopurexati, pa kokouna xosa epikiri muri xurexetai. ");
INSERT INTO six_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Saiprusi sou xekerinuku sakipaira emeserukiriai. Kokounae xuru Tairi erewese wetepure xati, Siria propinsi putarinuku erewese Tairi kokouna putawotai. Pa amure, pa erewese xosa kokounae xuru wetepure xati kakikiriai. ");
INSERT INTO six_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yesusure xonikisuwoteneai xuiapu utu xekenikerinuku, pa erewese 7-teu asau purikiriai. Xoiteupo Supo Youyae kanikati, Polu kauneri, ne Yerusalemu xowouna wete woteneai. ");
INSERT INTO six_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kokounae Tairi wetepure xatia, erewese wetinuku teipa xoukiriai. Yesusure xonikisuwoteneai apimie ninipo inenikimana xeika nono xeikani sini sosiki xouneri erewese kisauira yatasiketeneai. Utunuku usie maro xosikitapa ukurounuku kunikunikiriai. ");
INSERT INTO six_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kakerinuku sikosiko kusowataieinuku, sini kokouna xouro epikiria, nini nikou atoro xiyeri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tairi wetinuku erewese Tolemesu xounuku putaukiriai. Yesusure xonikisuwoteneai xuiapu kusonikerinuku, nini xeika kireni asau purikiriai. ");
INSERT INTO six_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kire asau xuwe xatia, Tolemesu wetinuku Sisaria erewese xouputaukiriai. Pilipupo atoro xounuku nu xeika purikiriai. Nue asinaku kuna xuiapu xosa uteirouna. Nu Yesusupo tianuwopi teu tianikirouneri apimi 7-teu xosaupo. ");
INSERT INTO six_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nu momuko makuna 4-teu tuku nini apu xuweu. Ninie Xoiteupo kuna kunatureture siei kuna uteirouneri. ");
INSERT INTO six_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sinie Sisaria kireu asau pani purikiri, kire kunatureture, nupo wenumu Akapusu, nue Yutia tistriki wetina Sisaria kotai. ");
INSERT INTO six_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Sini xosa kouna Polupo kikai tina nukoini nukou siau xeika xupo xeika taretai. Kakerina ipaki kunauna, “Xoiteupo Supo Youyae ipaki kunauna, ‘Muanumu kapiarei Yerusalemu puroteneai Yutae mua kikaipo omo tarineria, Xetau apimi xeteneai apimi xupunikiro tinikepineri,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sinie pa kuna iyeserinuku, pa erewesepu xuimi apimi xeikae Polu kaunuku ne kakixanau Yerusalemu xowouna wete xinuku, sokisoki kuna kaukiriai. ");
INSERT INTO six_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pana Polue xiyeri ipaki kunauna, “Tini ama yeure morepi morepinuku xotikemu xotikikemu tutumurikinukuna? Ye kakauya xosa iyaiyerepinerire ireine. Ye Kokaipa Yesusupo wenumurei Yerusalemu xumopineure rania ireine,” siketai. ");
INSERT INTO six_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Polu xekeukiria xowopure sokisoki xati, pani nupo nanunanu porowopi wetikiriai. Kunaunuku, “Kokaipae pa kapia akipa xepina xetaia, akipa xepina,” xikiriai. ");
INSERT INTO six_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kireu asau xuwexatia, xuru ireinuku Yerusalemu xoukiriai. ");
INSERT INTO six_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kakikiri kireu Yesusupo tataiwopi Sisaria puroteneaie xirini xoukiriai. Saiprusipo apu Nasoni, nupo atoro sosiki xowoteneai. Nu ekimeni Yesusupo tataiwopi sayetai. ");
INSERT INTO six_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yerusalemu putaukiria, Yesusure xonikisuwoteneai xuiapue nimaririrei tisiketeneai. ");
INSERT INTO six_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kire asau xuwexatia, Polue Yemusu xekopure xati xirini xoukiriai. Yesusure xonikisuwoteneai nikau xokupa tumue rania pa yause kou kununuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Polue kusonikerina, xetau xeteneai apimi xopuro Xoiteue nu xuporo xokupa kapia kaketaire atina perariniketai. ");
INSERT INTO six_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tumu teue Polupo kuna iyeserineri, Xoiteupo wenumu xouroreteneai. Kakeri kauneri, “Yewapu, ne sipa, xokupa tauseni Yutae Yesusure xonikisuweteneai. Pa xokupa xuimi apimie Mosesipo tu xotapa taiwopi xiri sokisokineri. ");
INSERT INTO six_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pana kireu apimie neure, ipaki kanikineri, ‘Polue Yuta apimi xetau xeteneai apimi xopu puroteneai, Mosesipo tu xotapa weta xina kanikirouna. Ipaki kanikina, “Tini kakixanari tinipo nonomi nikau mupuniki ipisa kakatiwaku xirouna. Pani kaki xanari ekimepu kapia pani taiwaku xina kaniketai xineri,” ’ kawoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Siko sipa, ne kouroutiai kuna iyesepineri. Pa xati sini amu amakepuna? ");
INSERT INTO six_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Paina ne kire kapia taiwowaire sini kanepure xinuku. Sini apu 4-teu tuku, ninie Xoiteu xosa sokisoki kuna kunawoniai. ");
INSERT INTO six_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nei pa apimi tinikinau taki xokupa Xoiteu ekero ekitikipitiwopi kapia taiwa. Kakinari Xoiteu xouiwopineri asinaku sapi isayarinikau paiye Xoiteu xouineri tapuniki uri korowopineri. Nei panumu kakauwa, mua kuna ninie kaneteneai paiya, ai xorei kuna xineria, xokupa apue sipawopineri. Ne rania, tu xotapa tairoune xineria sipawopineri. ");
INSERT INTO six_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Xetau xuimiapimie Yesusure xonikisuwoteneai xosa paiya, ekime oukiniai kuna nakau xayaunuku nini xosa xesarinikikiniai. Kanikinuku ati purinari, apue xorei xoiteu xouiwopure ouwoteneai noto naku, yawi tuku noto nete, apue paru muri kiritiwori xumotai noto neteunari, ayaka kapia kakaku,” xinuku nakau xesarinikikiniai. ");
INSERT INTO six_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Polue pa apimi Xoiteu xosa sokisoki kuna kunauwoteneai tinikina, xurise kire asau xosa nuko eke pitiwopi kapia taina nini xeika eke pitiwotai. Kakerina anakiserau ekiniki pitieineria, niko xetaxetauni Xoiteu xou iwopi sapi xuru tikopinerire xuriatiti kanikepure Xoiteupo ata tumau manetai. ");
INSERT INTO six_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","7-teu asau xuwe xepure xatia, Yuta kinie Esia propinsi koniaie Xoiteupo Ata Tumau Polu purati xekerineri, xokupa xuimiapimi xoniki xuseri Polu xosa makawoteneai. Kakerineri Polu soki xoroutineri, ");
INSERT INTO six_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ipaki uru yaxineri, “Tini Israili apimi tianisika. Mua apue sikou xatasikimana nikau weniniki ororina Mosesipo tu ororina Xoiteupo Atapu wenumu ororeteuna wesewesepu xokupa apimi kanikirouna. Mua kapia kireni kakati xana xuwe. Kriki apimi Xoiteupo Ata Tumau xosa xuruniki koati Xoiteue mua wese ikou xetai wese Xoiteu ekero xunu titouneri,” xeteneai. Mua kuna kunawoteneaia, ");
INSERT INTO six_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pa amure, ekime erewese Epesesipo Tropimusue Polu xeika Yerusalemu erewese purati xekoniairo, Polue Xoiteupo Ata Tumau sou motai xi nanuwoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Xuiapue pa kuna iyeseri, xokupa Yerusalemue xiri urerineri, xuiapue keikei kouneri kununuwoteneai. Kakerineri Polu soki xorou tineri Xoiteupo Ata Tumau kisau puru munoteneai. Pani sapauni Xoiteupo Ata Tumaupo xokupa isima nanakieteneai. ");
INSERT INTO six_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Apimie Polu ouwopi saina teri, Romupo xomatua nikau akereki saina apue muanumu kuna iyesetai, “Xokupa Yerusalemue makarineri waraixanauneri,” kuna iyesetai. ");
INSERT INTO six_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Pa xati sapauni xokupa xomatua kini xeika xomatua nikau tumu xeika tinikina xomatua nikau ata wetineri xuimiapimi puroteneai iri xosa keikei munoteneai. Akereki saina apue xomatua xeika munori, Yuta apimie xekerineri Polu ouwopi weteteneai. ");
INSERT INTO six_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Xomatua nikau akereki tumue Polu nutiemu mana soki xoroutina, aimore xumei tarepinerire xomatua kaniketai. Kakeri Yuta apimi ipaki kotonikina, “Mua apu, nu yuna? Nue amu amaketaina?” niketai. ");
INSERT INTO six_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kokaipa xuiapu kinie purineri, xiraxarauneri xetaxetau kuna kunawoteneai. Kakineri ere xakuririxeri, xomatua nikau akereki tumue ninipo kuna xotapa iyesepina itou xuwe xetai. Pa xati xomatuae nikou atoro Polu souneri xowopinerire kaniketai. ");
INSERT INTO six_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pana Polue pa atapu apasiro mana putawatia, xuimiapimie xiri ouwepure sokisoki xeri xomatuae xekenikerineri xeme tineri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kakeri kokaipa xuimiapimi kinie tainikineri ipaki sokisoki yaxineri, “Ouwari xuma!” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Xomatuae nikou atoro Polu sou manepure xeria, Kriki kunairae xomatua nikau akereki tumu ipaki kauna, “Ye kire kuna ne xosa kunawopinere?” wotai. Kakati xomatua nikau akereki tumue kunauna, “Ne Kriki kuna sipare, wo?” wotai. ");
INSERT INTO six_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kakeri kauna, “Nepa Isipu apue xayaka xayaka ekime kapmani xeika xoma sarina, sawaruwarue xomaxirouneri 4,000 apimi sonikina apu xuweu wese xowoyai apu xi nanune,” wotai. ");
INSERT INTO six_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Kakati Polue ipaki kunauna, “Ye Yuta kinipo apu. Ye tistriki Silisia erewese Tarsusupo apu. Yeu erewese nu kokaipa wenumu tuku. Wo, ye xuiapu kuna tinikepure xine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kotowati xomatua nikau akereki tumue iyo wati, Polue pa apasi xosa tumuna xuiapue kuna youwepinerire xupo ouro warina korekore xetai. Kakati xokupae youweria, Polue nini Ipru kunae kaniketai. Ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Xatai xura xauwa xura, tini iyesa. Ye kire kapia xoreierepu xuwena ximine ati katikepure xine,” niketai. ");
INSERT INTO six_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kakerina Ipru kunae kunawati iyeserineri, youweineri peunini kutu puroteneai. Kakeri Polue pani ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yepa kire Yuta. Yeu anikae tistriki Silisia erewese Tarsusu xosa iyaiyeretaina pana, mua erewese xosa asaxitiai. Ye Kamalielipo makuna, nue ye xesina asisikimana nikau xokupa tu xotapa atinani kutu uworiyeyai. Pa xati tini mua kakikiriai sie, ye Xoiteue xouwewotai kapia sokisokine xiri irerei saina titiai. ");
INSERT INTO six_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Yei xuimi xeika apimi xeikae mua Ime taineri xonikisuwoteneai xoxixoxi nikepi saina tine ounikiepure xitiai. Kakine sokisoki xumei tainikine kakauya atoro xuruniki xouyai. ");
INSERT INTO six_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ere xuriatiti xeika Yutapu tumu teu xeikae yei kakiyai kapia sipana nini paire katikepineri. Sikou xatasikimana Tamaskusu puroteneai xosa nakau xayawoteneai sieniai. Kakeri, pa wesepu xuiapue xonikisuneri pa Ime taiwoteneai, kakauya xosa soinikepure Tamaskusu xouyai. Yerusalemu soniki koutia kokaipa apimie xoxixoxi kapiani kutu nini xosa kakepinerire kakitiai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Polue pani ipaki kunauna, “Ye teipa xoune asauniki 12 kiloku sie xosa Tamaskusu tomuro matiai. Sapauni kire kokaipa memeremue mena xourei kouna ye xosai leiwotai. ");
INSERT INTO six_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kakati oro titikiri xoutia kire apu supoe ipaki kotoyati iyesitia, ‘Solu, Solu, ama ne ye xoxixoxi yepi saina tinena?’ ");
INSERT INTO six_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kakati kunaune, ‘Kokaipa, ne yuena?’ utiai. Kakitia kunauna, ‘Ye Nasaretipo Yesusu, ne ye xoxixoxi yepi saina tine,’ yetai. ");
INSERT INTO six_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ye xeika puroteneai apimie memeremu xekoteneaina pana, ye kuna sietai apupo kuna atineri iyesepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Kakati yei kunaune, ‘Kokaipa ye amu amakepinena?’ utiai. Kakiti Kokaipae ipaki kaina, ‘Ne sarounau Tamaskusu erewese kamoro mane. Yei xokupa saina ne tinitiai poro kire apue kanepina,’ yetai. ");
INSERT INTO six_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pa memeremue xiri una piririkati, ye kire sapi xekopine sie xuwe xitiai. Pa xati ye xeika puroteneai apimie xupi xaike tineri Tamaskusu soi xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kire apue Tamaskusu purotai, nupo wenumu Ananaiasi. Nue Xoiteu irue purina tuxotapa xiri atina tairouna apu. Xokupa Yuta apimi Tamaskusu purirounerie kunauneri, nu asinaku apu xirouneri. ");
INSERT INTO six_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nue ye nutiemi ma tumuna ipaki kaina, ‘Xatai Solu, neu ekinikemu xiyeri pereuwopina,’ yetai. Pa yauseni kutu yeu eki xiyeri merukati, nuko xekeutiai. ");
INSERT INTO six_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kakiti kunauna, ‘Sikou asisimana nikau Xoiteue ne tumuneretaina nukoe xouesiketai kapia nei sipaunauwa, asinaku kapia kaketai apu Yesusu xekoauwa nukou supoini kunawati iyesewai. ");
INSERT INTO six_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nei nu xekerinau nupo kuna iyesinauwa xokupa xuiapu xosa nupo kuna naki xakunieni iyesitiai uteiwowai. ");
INSERT INTO six_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Paina ne amakati purixainena? Ne sanau ene ise. Nupo wenumu tauwa, nue Yesusupo wenumurei ene iserinina neu xunu xesauwerinepina, yetai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Polue xuiapu pani ipaki kanikina, “Xurise Yerusalemu xiyeri koune, ma Xoiteupo Atoro kunikuni puritia, xiniwepi sie ");
INSERT INTO six_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ye Kokaipa xekeutiai. Nue ipaki kaina, ‘Ne sapauni sanau Yerusalemu wetinau xouwo. Ne mua erewese xosa yeu kuna uteinauwa, ninie neu kuna iyesepuworixe yetai.’ ");
INSERT INTO six_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kakati yei kunaune, ‘Kokaipa, nikoini sipa, ekime ye xokupa kununu ata yau texine xuiapu ne xosa xonikisuwoteneai, kakauya xosa soinikine, kasinikitiai. ");
INSERT INTO six_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Neu kuna uteiwoyai apu Stiweni ouweniai yause xosa, nutiemu tumuyai, yeu ekiro pa kapia kakeneaia asinaku.’ Yei Stiweni ouweteneai apimi nikau nekei xuwau yakuworinikitiai utiai. ");
INSERT INTO six_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kakiti Kokaipae ipaki kaina, ‘Ne xouwo. Xetau xeteneai xuiapu xetauro wesewese puroteneai xosa xesanitia xowowai yetai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Yuta kinie iyeseria Polue xetau xuimiapimire kunawati, nupo kuna pani iyesepu xire xeteneai. Paire ere urue ipaki yaxineri, “Ouwari xuma! Panumu apue mua ouro puropuwatixe! Nu ekeoma puropuwatixe!” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Polue kunawotai kuna xiri xirarixineri uru yai xanauneri ninipo kumukumu xurexi purepareuneri, xouro mai purerewoteneai. ");
INSERT INTO six_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Pa xati akereki saina apue kunauwati, xomatua nikau akereki tumue nikou atoro Polu souneri xowoteneai. Kakeri, pa xu xotapa sipawopure kasiworinari kotowa xina kaniketai. Amakatirau xuiapue kisamaira nikati Polure sokisoki uru yaxeteneai, ati sipawopure kaketai. ");
INSERT INTO six_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Polupo xupo xeika siau xeika tawoteneai. Kakeri ninipo tumue nutiemu tumu purati Polue xekerina ipaki kotouna, “Tuxotapae kunauna Romu sanawapu apu xosa mua kapia tini kakakuaire e xuwe? Ye kuna xosa tumuyerepu xuweuni ye kasiyepurexinuku, pa kapia itoure, wo?” wotai. ");
INSERT INTO six_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tumue pa kuna iyeserina, xou xomatua nikau akereki tumu ipaki kauna, “ ‘Sini amu amakepuna?’ Mua apua nu Romupo,” wotai. ");
INSERT INTO six_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Xomatua nikau akereki tumue Polu xosa mana kauna, “Ne ye kaye. Ne Romupo apure, wo?” wotai. Kakati Polue kunauna, “Iyo,” wotai. ");
INSERT INTO six_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kakati xomatua nikau akereki tumue ipaki kunauna, “Ye Romupo apu xepure kokaipa xeni kutu wetitiai,” wotai. Kakati Polue kunauna, “Yepa xuwe. Anikae iyaiyerati ye Romu sanawapu apu purine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Xomatuae kasiwopure xeteneaia pa kuna iyeserineri sapauni kereuwoteneai. Polu nu Romupo xati xomatua nikau akereki tumue siparina, nue rania ximiketai, pa amure xomatua kanikati sokisoki xumei tawoteneairo ximiketai. ");
INSERT INTO six_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Polue amu kapiani kutu rau xoreiyeretaire Yuta apimie nanuwori, xomatua nikau akereki tumue ati sipawopure xetai. Paire kire asau xosa Polu sokisoki xumei tareteneai xureiyeina, xokupa xuriatiti xeika Yuta nikau kaunsolu xeikae kou kununuwopinerire kuna xesariniketai. Kakerina Polu sou kouna nini nutieniki tumuworetai. ");
INSERT INTO six_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polue kaunsolu kukoniki puri ipaki kanikina, “Yewapu xura, ye Xoiteupo ekero texine asinaku kapia kakipa koune koune ximine yeu xoikemu itou xina. Ye kire kapia xoreiyerepu xuwexi nanune,” niketai. ");
INSERT INTO six_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Panumu kaki kunawati, ere xuriatiti Ananaiasie nuko nutiemu tumu puroteneai apimi kanikina supotumau puturuweiya niketai. ");
INSERT INTO six_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kakati Polue ipaki kauna, “Xoiteue ne xemu ounepina, pa amure, nepa sepuri xoxi kore karaie umuweki, apimie sapi xoxi iruworo purotai xekopu xuweu wopineri sie. Ne pa tuxotapa taiwopi kapia nanu purine ye kuna xosa iyaiyerine, pa xati ne mane misipurine. Pana nakieni tuxotapa kereune, ouyepinerire kanikine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nutiemu tumuwoteneai apimie, pa kuna iyeserineri Polu ipaki kotouneri, “Pa amakatina? Ne Xoiteupo ere xuriatiti niniawopure xinere, wo?” woteneai. ");
INSERT INTO six_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Kakeri Polue kunauna, “Yewapu xura, mua apu nu ere xuriatiti paiya, ye sipa xuwe. Ye xoreiyerine, pa amure, Xoiteupo nakau xosa mua kuna tuku, ‘Tini kaki xanari kire tinipo tumu niniawaku xetai,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Polu nu sipa, kireu kaunsolu nini Satusipona kireu nini Parisipo. Pa xati nue kaunsolu xosa ipaki yaxina, “Yewapu xura, ye Parisi kini nikau apu, ye Parisi nikau nono. Ye ipaki xoisune, apimi xumoteneaia xiyeri saropineri xiti, pa kuna xotapa paire ye kuna xosa iyaiyerineri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Polue pa kaki kunawati, Satusi xeika Parisi xeikae kuna tuwatarineri, kununu purieteneai. ");
INSERT INTO six_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Satusie ipaki kunauneri, apimie xiyeri kopa upurei saropuworixana xuwe, xenikorokoro xeika yaniyani xeika rania purori xana xuwe xirouneri. Pana Parisia nini paire xonikisuneri. ");
INSERT INTO six_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pa xati ere uru xourei pani yaxepi saina teteneai. Kakeri kireu Parisipo tuxotapa sipa apimie ipaki sokisoki kunauneri, “Sinie mua apu xekeukiria nu xu xuwe. Nu suwau kunawopina tuku, kire yaniyaniere, e kire xenikorokoroe kuna tuwotai,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Xomatua nikau akereki tumue xekoatia pani ere kuna tuwataxeri, panumu kakineria aimore tutue Polu puruneri kukeu kakeu xaneri mupo sirakieria xumopinarina ximiketai. Pa xati Yuta xupunikiropu Polu munaneri xesauweineri xomatua nikou atoro sou xowopinerire kaniketai. ");
INSERT INTO six_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ukumani Kokaipae Polu nutiemu tumu puri ipaki kauna, “Ne sokisoki tumuwo, kaki xanau ximikeu. Ne Yerusalemu yeu kuna sokisoki uteitiai sie, panumu kapiani yeu kuna Romu uteiwowai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Yuta kinie Polu ouwepure xoripesau kuna ouwoteneai. Sokisoki kuna ipaki kunauneri, “Suwauni kutu suwau, Polu ouwepu. Sini ouweikiri xumopu xuweuwa, xoye ninuku ene nepuxe,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Apimi pa sokisoki kuna kunawoteneaipo xoka paiya 40-teu emeseruwotai. ");
INSERT INTO six_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pa apimie ere xuriatiti xeika Yuta nikau tumu xeika xosa xouneri ipaki kunauneri, “Sini xiri sokisoki kuna ipaki kunaunuku, sini xayaka xayaka xoye tepu xuweu utunuku, Polu ouwepinuku. ");
INSERT INTO six_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Pa xati tini xeika kaunsolu xeikae xomatua nikau akereki tumu xosa kuna xesawari, tini xosa Polu sou kopina. Ipaki xoreunari kaunaria Polupo kireu kuna xotapa ati xirekepure xakuai. Kakaria sini ireinukua yakutiki puropinuku. Kakikiri nu tini xosa munopu xuweu yauseni ouwepinuku,” niketeneai. ");
INSERT INTO six_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pana Polupo ukopu nonoe pa kapia kakepure xeteneai kuna iyeserina, xomatua nikau atoro xouna Polu kawotai. ");
INSERT INTO six_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kakati Polue kire xomatua nikau tumu yauwati moati ipaki kauna, “Mua apu tenemai nu xomatua nikau akereki tumu xosa sou xouwo. Nu kire kuna tuku xati nu tuwopure xina,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kakati xomatua nikau tumue xomatua nikau akereki tumu xosa, sou xou kunauna, “Kakauya apu Polue yaiyeri kaina mua apu tenemai ne xosa sou xouwo xetai. Nu kire kuna tuku xati ne tinepure xina,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kakati xomatua nikau akereki tumue xupo xaike tina, maro sou xonotai. Nioni purinexeri, apu tenemai ipaki kotouna, “Ne amu kuna ye siepurena?” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kakati apu tenemaie ipaki kunauna, “Yuta kinie ne kotoneri iyati kaunsolu xosa Polu sou munowaire kuna ouwoteneai. Xoreinineri kunauneria, nupo kuna xotapa ati xirekepure xepineri. ");
INSERT INTO six_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kakeria ne ninipo kuna taiwou. Apimi nikau xoka 40-teu, ninie sokisoki kuna kunauneri, xoye nineri ene xukoriwopu xuweu purineria Polu ouwepineri xeteneai. Muaiya nei ninipo kuna iyo xewaire yakuni purineri,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kakati xomatua nikau akereki tumue pa apu tenemai, ipaki sokisoki kuna kauna, “Yei mua kuna xomatua nikau akereki tumu kautiai xi kire apu kawouworina,” xesawotai. ");
INSERT INTO six_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Xomatua nikau akereki tumue, xomatua nikau tumu aimore yainikeri ipaki kanikina, “Tinie 200 teu xomatua xeika 70 teu xomatua os xosa misirouneri xeika 200 teu xomatuae xori teteneai xeika tinika. Kakinari ukuman 9 kiloku Sisaria xowakuaire ireiwa. ");
INSERT INTO six_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Polupo os rania ireiyerunari, akereki kapmani Peliksi xosa ati sou utu yatawakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Xomatua nikau akereki tumue nakau ipaki xayauna, ");
INSERT INTO six_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ye Klotiusu Lisiasi ye mua nakau kokai apu xosa xayaune, nu akereki kapmani Peliksi. Asinaku yause. ");
INSERT INTO six_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yuta kinie mua apu soki xorou tineri ouwepure xineri. Pana ye iyesitia nu Romupo apu xati, iko xeika xomatua teu xeikae xounuku nini xupunikiropu xiyeri tikiriai. ");
INSERT INTO six_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mua apu xosa kuna xosau suwoteneai kuna xotapa sipawopure, nikou kaunsolu xosa sou munatiai. ");
INSERT INTO six_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ye kotonikitia, nikou tuxotapapu kireu kuna kaineri pa kuna xosau suwoteneai. Sini ouwepure e kakauya xosa iyarepu sie imerei kuna xosa iyarepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ye iyesitia mua apu ouwepure irue kuna ouwoteneai. Pa xati sapauni ne xosa xesauti utuna. Nu xosa kuna suwoteneai apimi kanikine, Peliksi moaroni kutu xounari kunawari, nu tumuworikiriaire kuna sipawopina nikitiai,” xi xayawotai. ");
INSERT INTO six_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Xomatuae nikou akereki tumupo kuna taineri pa ukumu xosa Polu sou xouneri erewese Antipatrisi yatawoteneai. ");
INSERT INTO six_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Xurise kire asau xosa os xosa misirouneri xomatuae, Sisaria erewese Polu sou xou yatawoteneai. Kireu xomatua paiya xomatua nikau atoro Yerusalemu xiyeri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Os xosa misirouneri xomatuae Sisaria xou putauneri, akereki kapmani nakau tuworineri, Polu rania nutiemu sou maneri tumuworeteneai. ");
INSERT INTO six_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Akereki kapmanie nakau ninaiyeina, Polu ipaki kotouna, “Ne amu sanawapuna,” wotai. Kakati Polue kunauna, “Ye Silisiapu,” wotai. ");
INSERT INTO six_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Akereki kapmanie ipaki kunauna, “Kuna xosani suwoteneai, apimie koria, yei neu kuna iyesepine,” wotai. Kakeri kunauna, Erotipo kapmani ata xosa iyarari yakupineri niketai. ");
INSERT INTO six_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","5-teu asau xuwe xatia, ere xuriatiti Ananaiasie, tumu teu xeika, kire Romu nikau tuxotapa sipa apu wenumu Tertulusu xeika, erewese Sisaria kotai. Kouneri Polu kuna xosa iyarepure xeteneai kuna akereki kapmani kawoteneai. ");
INSERT INTO six_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Akereki kapmanie Polu yauwati moatia, Tertulusue kuna xotapa taina kuna xosau suwotai. Nue ipaki kunauna, “Kokaipa apu Peliksi, sini ati misepinukure ne tianisikau, kire xoma mopu xuwe. Neu asinaku nanunanue, ekime xokupa sapi ati puropu xuweuwotai paiya nei sinipo apimi tianikitiai. ");
INSERT INTO six_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sinie pa xokupa sapi xekeunuku, sinipo xosikikemu xiri asinaku xati, ne xiri eiyaseninuku. ");
INSERT INTO six_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","“Ye ere xuwau yause kuna sosoainepixe. Ne sinire xonikurunau sinipo kuna nuxuto iyeserisike. ");
INSERT INTO six_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sinie mua apu xekeukiria, nu xokupa poripori sarepitua. Nue xokupa Yuta kini xopu xokupa sanawa xoma sarirouna. Nu paiya, apimie sini weisikiterineri xetau konikoni kapia sarineri, Nasareti kini xeteneai nikau tumu. ");
INSERT INTO six_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Nue Xoiteu ekero Xoiteupo ata rania xunu tutuwopure xetaina, sikoe soki xorou tikiriai. Pa xati nakieni mua apu, kotounau sini xokupa kapiaure kuna xosa tumuworikiriaire nukou suporopu kuna te,” wotai. ");
INSERT INTO six_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yuta apimie rania Tertulusupo kuna tianuneri Polu kuna xosau suwoteneai. Ipaki kuna pereuneri, “Mua xokupa kuna paiya suwau,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Polue kunawopinaure akereki kapmanie xupo xourowari korekore xati, Polue ipaki kuna xapa kunauna, “Ye sipa, xokupa xitosani ne mua xuiapu nikau kunaxekexeke puriyai. Pa xati ne xosa kuna ye xapa kunawopure yeu xoikemu asinaku xina. ");
INSERT INTO six_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ne kotokoto xinau, xirekinauwa yei 12-teu asau xowotai xosa Yerusalemu muris tepure, xoutiaire sipawowai. ");
INSERT INTO six_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Yuta apimie ye xekeyeri kire apu xeika Xoiteupo Ata Tumau kuna tuwata xepu xuwe. Nini xekeyeri yei kununu ata yaure e erewese xosa xuiapu nikau kununu saritiaixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ye mua kuna xosa iyaiyereteneaia, suwau xuwe. Ninipo kuna suwau xi atarisikepineri ime xuwe. ");
INSERT INTO six_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Suwau kuna paiya muanumu, ye mua xetau konikoni kini Ime xeteneai tairoune. Ye pa Ime taine sinipo asisikimana nikau Xoiteu xosauni muris tine. Xokupa kuna tuxotapa xosa purotai xeika kunatureturei xayawoniai xeika ye xoisune. ");
INSERT INTO six_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Xumuweteneai apimi, kutu xeika xoxi xeika Xoiteue xiyeri sainikerepinaure ye xoisune yakune. Xoiteue pa kakepinaure mua apimi rania xonikisuneri yakuneri. ");
INSERT INTO six_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Pa xati xokupa yause Xoiteu ekero xeika xuiapu ekinikiro xeika yeu xoikemu kutuni xu xuweu puropinaure ye sokisoki xine. ");
INSERT INTO six_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ye kireu xitosani xosa xetau wesewese puriyaie, xurise ikou kini xosa koutiai. Xuiapu xauna tianikepure xe ara tikoune, Xoiteu xouiwopi sapi tikotoutiai. ");
INSERT INTO six_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Xoiteupo ata tumau xowopure, Xoiteupo ekero ekisiki pitiwopi kapia taiyeine xoutiai. Kakerine Xoiteupo ata tumau puriti xekeyeria, eki pitieki puritiai. Xokupa apue ye xeika puropu xuwe, apimie punisi panisi xanauwopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kireu Esia propinsipo Yutae maneri soki xoroi tiyeteneai. Pa apimi nini yeure kuna tuku xatia, nikoini muoro naki nutieni kouneri kuna xosa tumuyerepineri itou. ");
INSERT INTO six_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Xuwe xatia, mua apimie ye nikou kaunsolu xosa kuna tinikitia yause xosa puroniaina, amu kapia yei xoreiyeriti xekoneaia ninie kanepineri. ");
INSERT INTO six_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ye kire kuna kireni kunauyaire rau nini nimaririworixe. Ye nini xopu tumutiai yause xosa, ipaki yaxine, ‘Ye ipaki xoisune, xumoteneai apimi xiyeri saropineri xiti, pa xotapaure kireni ximine tinipo kuna xosa soi koteneai,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Xuiapue Kokaipapu Ime taineri xonikusuwoteneai nikau kapia paiya, Peliksi nu xiri sipa xati, Polue kunauwatia, Yuta kanikina xemuna pura niketai. Ipaki kunauna, “Xomatua nikau akereki tumu Lisiasi koati yauseye, mua tinipo kuna kutuwopine,” niketai. ");
INSERT INTO six_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kakerina xomatua nikau tumu kauna, Polu kakauya xosa iyarewaina, kaki xanau ere sokisoki kakauya xosa iyareu wotai. Polupo maroue xuru nanuwopinerire kaki xanau xuwe nikeu wotai. ");
INSERT INTO six_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kireu asau xuwe xatia, Peliksie nupo xui Trusila tuku kotai. Trusila nu Yuta kinipo xui. Peliksie Polu yauworina nupo kireu kuna iyesetai. Polue Yesusu Kristusure xosikisuwopi kapiaure kawotai. ");
INSERT INTO six_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pani asinaku kapiaure kauna, apue nukou ekeoma ati yakuwopire kauna, Xoiteue sewai kuna xosa tumusikerepinaure kauna wotai. Peliksie pa xokupa kuna iyeserina ximiketai. Kakeri kunauna, “Ne xouwo. Ye sewai yause tuku xatia, ye xiyeri yainepine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Peliksie kire sapire rania yakuwotai. Polu niraniraina xei xoi iwatia wetiti aini xowopina nanunanu tetai. Pa xati xokupa yause yauwati moatia nu xeika kunakuna wotai. ");
INSERT INTO six_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aimore xitosani xuwe xatia, Porsiusu Pestusue Peliksipo iri tetai. Kakati Yutae Peliksi xurarauwopinerire Polu kakauya xosa wetati purotai. ");
INSERT INTO six_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestusue kouna Yutia tistrikipo akereki kapmani xetai. Xeimore asau purotaie Sisaria erewese wetina pipa Yerusalemu xowotai. ");
INSERT INTO six_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kakati Yuta nikau ere xuriatiti xeika kokaipa apimi xeikae nu xosa xonaneri Polu kuna xosau suwoteneai. Pestusu ipaki sokisoki kuna kauneri, ");
INSERT INTO six_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Ne sini tianisikinau mua apu xesawau Yerusalemu kopina,” woteneai. Ninie ipaki kunawoteneaia, pa amure, apimie imero ximiaki purokie Polu ouwepinerire kaniketeneairo kunawoteneai. ");
INSERT INTO six_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kakeri Pestusue ipaki kuna xapa kanikina, “Polu nu Sisaria kakauya xosa purina. Ikoini Sisaria xowopine yause xuwau xuwe. ");
INSERT INTO six_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kakitia tinipo tumu teue ye xeika munopineri. Pa apu nu kapia xoreyeretai xatia, ninie kuna xosa iyarepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestusue 8-teu asaure 10-teu asau sie, nini xeika purotaie Sisaria munotai. Kire asau xosa kuna atoro misina Polu sou mouwa niketai. ");
INSERT INTO six_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Polue moatia, Yuta kini Yerusalemu wetineri koteneaie, nu nutiemu tumuneri, xokupa kuna nu xosau suwoteneai. Kunauneri, nue xoxixoxi kapiani kutu kaketai xeteneaina pana, Pestusue ninipo kuna suwau xina ati sipawopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ninie kunauweria, Polue ipaki kuna xapa ti kunauna, “Ye kire poripori erepu xuwe. Ye Yuta nikau tu purixepu xuwe, ye Xoiteupo Ata xosa kire kapia xoxi kakepu xuwe, ye Sisari xosa kapia xoxi kakepu xuwe,” niketai. ");
INSERT INTO six_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pestusue Yuta kini nimaririwopinerire, Polu ipaki kotouna, “Ne Yerusalemu xounau kunawowaire? Pa xatia, ye neu kuna Yerusalemu iyeserinepine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kakatia Polue ipaki kunauna, “Muoro mua ata, ximine tumutia xosa paiya Sisaripo kuna ata. Mua ata kireni yeu kuna iyesewai. Ne sipauweitiai, ye Yuta kini xosa kire xoxi kapia kakepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ye kire xoxi kapia xoreiyeritiare xumopine xatia, ye xumopine. Pana nini ye kuna xosai iyareteneai kuna, xorei xatia, apu yue nini xupunikiro iyaiyerepuwatixe. Ye Sisari nukoini yeu kuna iyesepina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kakati Pestusue nanunanu turouneri apimi xeika kunarina, Polu ipaki kauna, “Ne kunaune Sisarie neu kuna iyesepina xinena, paina Sisari xosa xouwo,” wotai. ");
INSERT INTO six_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kireu asau xouwatia, Kokemu Akripano nukou uko Pernaisinoe Pestusu kusowoxepure Sisaria koxeteneai. ");
INSERT INTO six_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Xokupa asau Sisaria purinexeri Pestusue Polupo kunaure kokemu xakume wotai. Ipaki kunauna, “Ekime kire apu Peliksie kakauyaro iyarati purotai, pani kakauya xosa purina. ");
INSERT INTO six_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ye Yerusalemu puritia yause xosa Yuta nikau ere xuriatiti xeika tumu teu xeikae nu kuna xosau suneri, yei ipaki kunaunei, nu xu tukuna xomatuae manman tepineri xinei kunawopineure xeteneai. ");
INSERT INTO six_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kakeri yei ninipo kuna xapa ipaki kanikine, ‘Sini Romua kire apu aini manman tepi kapia xuwe. Apu kuna tukua, nu kuna xosa iyareteneai apu muanikiro tumuwati paiyeye, amu sapire kuna xosa iyareteneaire kuna xapa terinikepina yause tuwopu nikitiai.’ ");
INSERT INTO six_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Ye Sisaria xiyeri koutiai yause xosa, pa apimie ye xeika koteneai. Kakeri ye xenenewopu xuwe. Kire asau xowatia kuna atoro misine pa apu sou mouwa nikitiai. ");
INSERT INTO six_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kakeri, kuna xosa iyareteneai apimie tumuwoteneai. Ye nanutiaiya xoxi kapia kaketaire kunauneri xitiaina, xuwe. ");
INSERT INTO six_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nikou murisipo kapiaure nu xeika kuna tuwata xete kire apu xumotai, nupo wenumu Yesusu, paire xeika kuna tuwata xeteneai. Polue kunauna, pa apu ekeoma purina xetai. ");
INSERT INTO six_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ye pa kuna xotapa xirekepure xitiai sorena, nanaxitiai. Pa xati kotoune, ‘Ne Yerusalemu xowou, neu kuna Yerusalemu iyeserinepinere?’ utiai. ");
INSERT INTO six_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kakiti Polue kunauna, ye kakauya xosa puriti, sewai Sisari nukoini yeu kuna iyesepina xetai. Kakati, yei kunaune kakauya xosa puratieye, ime xekeunei Sisari xosa xesauti xowopina xitiai,” xetai. ");
INSERT INTO six_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Akripae pa kuna iyeserina Pestusu ipaki kauna, “Ikoini mua apupo kuna iyesepure,” wotai. Kakati Pestusue kunauna, “Iyati ne iyesewai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kire asau xosa Akripano Pernaisinoe ninipo asinaku nekei nekeiyeinexeri moxeteneai. Pa erewesepu xomatua nikau akereki tumu teu xeika kokaipa apimi xeikae kununu atoro xirini maneteneai. Kakerineri Pestusue kunawati, Polu sou moteneai. ");
INSERT INTO six_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pestusue ipaki kunauna, “Kokemu Akripa xeika sini xeika purikiriai xokupa apimi xeika, tini mua apu xekoa. Yutapu xokupa xuimiapimie Yerusalemu kuna xosau suwoteneaie, muoro rania kuna xosau suwoteneai. Ninie ye xosa ipaki sokisoki yaxineri, ‘Ne pa apu ouweyewai. Nu ekeoma puroxete,’ xeteneai. ");
INSERT INTO six_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kaketeneaina pana nu xumopina sie ime ye xekeuti kire kapia xoreiyerepu xuwe. Nu Sisarieni nupo kuna iyeseruwopinaure xina. Pa xati Sisari xosa xesauti xowopinaure kuna outiai. ");
INSERT INTO six_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Pana amu kunani kutu sikou kokaipa apu xosa xayaunei xesaruti, amu xotapaure pa apu kuna xosa iyareteneaire sipawopina paiya ye sipauixe. Pa xati Kokemu Akripa, naki xeika mua kireu apimi xokupa xeika xosa rania mua apu tini xosa sou mane. Sini nupo kuna atinuku iyeserinukueye, ye nakau xosa xayawopine kuna sipawopine. ");
INSERT INTO six_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ye kire kakauya apu xesaune nu amurerau kuna xosa iyareteneaire kuna xeika xesawopu xuweuwa, pa asinaku kapia xuwe xi nanune,” niketai. ");
INSERT INTO six_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Akripae Polu ipaki kauna, “Ne nakipo kunani kunawo,” wotai. Kakati Polue xupo xouro warina nupo kuna ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kokemu Akripa, Yuta kinie kuna xosai suwoteneai kuna xapa kunawopure nanutiaiya, ne xosa yeu mua kuna kunawopine itou. ");
INSERT INTO six_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Sini Yuta sikau xokupa kapia xeika, amu sapire kuna tuwata xirounuku xeikaure ne xiri sipa. Pa xati ne peuni misinau yeu xokupa kuna iyese. ");
INSERT INTO six_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Xokupa Yutae ye ati sipayeteneai. Ye nono arani yeu xataimana xopu puriaiye, xurise ye Yerusalemu xoune puriyai nini sipa. ");
INSERT INTO six_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ninie ye sipaiyeteneaina, kunawopure xineria, nikoini yeu kapiaure kanepineri. Ye tenemai yauseni, ye Parisi kini tuku purine ninipo kapia taiyai nini sipa. Parisi kini nini tu xokupani kutu xati taiwopu sie itou xuwe. Sini Yuta sikau kireu apimi kinia, nini Parisi nikau muanumu tu sokisoki tuku sie xuwe. ");
INSERT INTO six_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ye mua tumuti, kuna xosa iyaiyerineri. Kuna xotapa muai. Ekime Xoiteue sinipo asisikimana kanikina ye saina tepine xeyai sie, kakepinaure ye xoisune yakune. ");
INSERT INTO six_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Sinipo apu kini 12-teue Xoiteure asau ukumu muris tineri pa sapi mopinaure kireni xonikisuneri yakuwoneai. Pa xati kokemu, ye rania xoisune pa sapi yakune. Pa kuna xotapaure Yuta kinie ye xosai kuna suneri. ");
INSERT INTO six_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Tini kireu apua ama nanunuku, apimi xumoteneaia Xoiteue xiyeri sainikepu watixana xuwena xosikisuwopuxe xinukuna? ");
INSERT INTO six_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ekime ikoyeni nanune Nasaretipo Yesusu wenumu ororepure xokupa kapia xoxi kakepine xiyai. ");
INSERT INTO six_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kakine pa xokupa kapia Yerusalemu kakiyai. Ye ere xuriatiti xosa wenimi tuku saine, Xoiteupo xokupa xuiapu kakauya xosa soinikiyai. Xuiapu ounikiepure tumue kuna ouworia, yei rania, xumopinerire kunauyai. ");
INSERT INTO six_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Xokupa yause xoroniki tine xemekaskasi nikepure ninipo kununu ata yau maroune. Ninie Kokaipa nikiniki tuneri ninia wopinerire kokaipa saina tiyai. Ninire xiri kisamaira yati, xemekaskasi nikepure xetauro puroteneai erewese yau rania xoune xirekinikiyai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Polue pani kunauna, “Ere xuriatiti teu xosa kokai wenimi titi xesayeri xoune Tamaskusu erewese teipa xoutiai. ");
INSERT INTO six_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Paina Kokemu, 12 kiloku asauniki sie xosa imero teipa xoutia, kire kokaipa memeremue mena xourei koati xekeutiai. Pa memeremue xiri sokisoki una asaupo memeremu emeseriwotai. Iko xosa kou uwoto, xirini xoukiriai apimi xosa uwotowotai. ");
INSERT INTO six_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kakati sini xokupa oro uraki xoukiria, kire apu supoe Ipru kunae ye ipaki kotoina, ‘Solu, Solu ne ama ye xoxixoxiyepi saina tinena? Ne ye xoxixoxiyepi saina tine xinena, pana, naki xoxixoxinepi saina tine yetai.’ ");
INSERT INTO six_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Kakati yei kunaune, ‘Kokaipa, ne yuena utiai.’ Kakiti Kokaipae ipaki kunauna, ‘Ye Yesusu, ne ye xoxixoxi yepi saina tine. ");
INSERT INTO six_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Pana ne sanau tumuwo. Ne yeu saina tewaire tumunerepure ye mane. Ne mua xekeutiai kapia xeika, sewai atarinepine kapia xeikaure kuna uteiwowai. ");
INSERT INTO six_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Ye ne weinititi nakipo xatanimana xeika xetau apu kini xeikae ne xoxixoxinepuworixe. Xuwe. Nini ekiniki perewopinerire ne xesaniti nini xosa xowauwa, ninie ukumu xosa nikiniki tuworineria xoniki pirixineri memeremu xosa kopineri. Nini Satanipo sokisoki weti Xoiteu xosa kopineri itou. Kakeri ninipo xunu weterinikitia, yeure xonikisuwoteneai xuiapu xeika weniniki tuku xineria, ikou xine tinikitiai xuiapu xopu puropineri,’ ” yetai. ");
INSERT INTO six_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Polue pani ipaki kunauna, “Kokemu Akripa, ye mena xouropu sapi xekerine, nupo supo worokixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Tamaskusu apimi xosa akeri kuna uteiyeine, xurise koune Yerusalemu xuiapu xosa uteiyeine, Yutia sanawa yau uteiyeine, xetau xuimiapimi xosa rania uteiyai. Ye ipaki kuna uteine, ‘Tini xotiki pirixinari Xoiteure xotikisunaria, takipo kapia paiye tini xotiki pirieikiriai kapia atarinikakuai.’ ");
INSERT INTO six_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ye muanumu kuna kireni uteirouti, pa xotapaure Yuta apimie ouiyepure, Xoiteupo atoro xoroi tiyeteneai. ");
INSERT INTO six_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Xoiteue ye tianiyati ye ati puritiai xati pani mua purine. Pa xati ximine ye mua tumune xokupa aipu apimi kuna tinikete kokai apimi kuna tiniketeune. Ye xetau kuna uteixana xuwe. Ekime kunatureture teue kunawoniai, Mosesie rania paire kunawoyai kuna kireni sore uteine. ");
INSERT INTO six_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ninie ipaki kunauneri, ‘Pa apu xuiapu xiyeri tinikepinaure Xoiteue tumuworetaia, nu tatau xemeropinae, sewai nu akeri kopa upurei saropina. Kakinapa Xoiteupo memeremupo kuna Israil xosaniki uteinapa xetau apimi xosa rania uteiwopina xi kayetai,’ ” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Polue kunau xowatia, Pestusue ipakina ere xirayeina, “Polu, ne nanana. Ne ere xaya ata puritiaie, neu kokaipa sipae ne xiri nanana xine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kakati Polue kunauna, “Kokaipa apu Pestusu, ye nanana xixe xuwe. Ye suwau kunaune, ye nanunanu tuku xati kunaune. ");
INSERT INTO six_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ye mua xokupa sapire kunauweitiaia, Kokemu Akripa nu sipauwetai. Pa xati ye kutu nu kaunena, ye ximiki xana xuwe. Ye sipa pa xokupa kapia nupo ekei xakue emeseriwokixe. Xuwe. Nu itou sipanikiena, pa amure, pa xokupa kapia ximiarei yaraxepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kokemu Akripa, ne kunatureture nikau kuna xonsunere, e xuwe? Ye sipauweine, ne xonsune,” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kakati Akripae Polu ipaki kotouna, “Pa ama? Mua yause nuxuto xosapa, nei ye Kristusure xoisuwopine apu saiyerewaire?” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Kakati Polue kuna ipaki xapa kauna, “Yause nuxutore xuwau rania ye Xoiteu xosa ipaki kunikunine, naki xeika xuimi apimi xeika yeu kuna mua iyesikiriaia, tini xokupa iko sie xakuai. Tini ikou sie xosa sokisoki xume soxeri tini kakauya xosa puropi xiraxine,” wotai. ");
INSERT INTO six_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kokemu xeika, akereki kapmani Pernaisi xeikae, niko xeika puroteneai apimi xeika saneri, ata kama wetineri xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nikoniko ipaki kunauneri, “Mua apu nu kire kapia xoreiyeretairo, nu kakauya xosa puropinare e xumopina siexe xuwe,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kakerineri Akripae Pestusu ipaki kauna ne mua apu somo wetau xowopina itouna pana, “Nukoe kunauna Sisarie yeu kuna xekeriyepina xetai,” wotai. ");
INSERT INTO six_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sini Itali sanawa xowopinukure, ninie kuna ouweteneai. Kakerineri 100-teu xomatua nikau kire tumu xuporo kireu kakauya apimi xeika Polu iyareteneai. Pa tumupo wenumu Yuliusu, nu Sisaripo xomatua kini xosaupo. ");
INSERT INTO six_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sini Atramitiumu ere wesepu kire kokouna xosa makiriai. Pa kokounae Esia sanawapu erewese yaupo au yau xowopure xetai. Kakati muri ureiyeri xoukiriai. Mesetonia sanawa xosa erewese Tesalonikapu Aristakusie sini xeika xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kire asau xosa Saitoni erewese utu tuarinuku, Yuliusue Polu nakenake wotai. Polue xouna nupo marou xekenikina xoye tepinaure iyowotai. ");
INSERT INTO six_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Xurise Saiton wetikiria, xupeue porosikati, Saiprusi Sou nikereira kokouna xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kakati Silisia sanawa xeika Pampilia sanawa xeika tomuro xasi xusanuku, xurise Lisia sanawapu erewese Maira xosa putaukiriai. ");
INSERT INTO six_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pa erewese xosa xomatua nikau tumue erewese Aleksantriapu kokounae, Itali xowopure purati xekotai. Kakati pa kokouna xosa xona yatasiketai. ");
INSERT INTO six_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Muri ureiyeri kireni muris sie kokounae peuni peuni xowotai. Pa amure kokaipa xupeue porosiketai. Kokouna xosaupo saina apimie saina xiri irereiwori erewese Nitusu tomuro utu putaukiriaina pana, xupeue paraisikati, pani xowopu xuwe. Pa xati Salmone puau tomuro xosa pirixinuku, Kriti sou pira masani kutu xoukiriai. ");
INSERT INTO six_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kokouna xosaupo saina apimie saina irereiwori Kritipo usie ma tai xoukiriai. Xurise kire wese wenuneri Asinaku Au xeteneai, pa wese paiya erewese Lasea purotai tomuro utu putaukiriai. ");
INSERT INTO six_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Xokupa asau xuwe xati, Yuta apimie xoye xurikirouneri yause, aini xuwe xetai. Xasie xiri xoxi xati, Polue nini ipaki kanikina, ");
INSERT INTO six_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Tini apimi, iyesa, ye sipa, sini mua xounukua, sini xiri xoxixinukua, xokupa sapi wetepu. Xuru xeika kokouna xeika kireni xuwexepu watixana. Xuwe. Siko rania xumuwepu,” niketai. ");
INSERT INTO six_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kakatia xomatua nikau tumue Polupo kuna iyesetaixe. Xuwe. Nu kokounatiti xeika kokouna xataku xeika nikau nanunanu taiwotai. ");
INSERT INTO six_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pa au paiya kokounae kokaipa xupeure ximiaki puropina asinaku iri xuwe. Pa xati kokounaropu apimi xokupae pa wese weti xowopure kuna ouwoteneai. Nini itou xatia, Piniksi xou putauneria kokaipa xupeu yause xosa xeimore poita sie poro puropineri. Piniksi paiya Kriti soupo au, asau munarouna sanawa masaira purina. Nu asau munarouna masaira xekeu purina. ");
INSERT INTO six_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Asau munarouna masairapu xupeue sana, ere sokisoki xepu xuwe. Kakati kunawoteneai au xosa ati xowopinuku xineri nanuwoteneai. Kakineri kokouna soki titi naipa puruweineri Kriti usie ma tomuroni kutu munauti mauti xowoteneai. ");
INSERT INTO six_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kakeria xenene xuwe, kire sokisoki xupeue sarotai. Pa xupeua asau marounairapu xupeu xi wenuwoteneai. Pa xupeua Kriti sou masairae mana, ");
INSERT INTO six_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","kokouna sokau xiri sokisoki porowotai. Kokounapu saina apimie kokouna pirixineri xiyeri xowopure xeteneai sorena, itou xuwe xeteneai. Pa xati weteri xupeue kokouna sokau porowati xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","17","Kire sou xayaka wenuneri Kauta xeteneai xosa, asau munarouna masaira kokounae ene xosa munauti mautiwati xoukiriai. Soue xupeu xayaxayaka parawati ouso kokouna nutiemu purunuku irereikiriai. Kokouna xosaupo saina apimie ouso puruweri kokouna xouro moati sokisoki tareteneai. Kakerineri sokisoki xume kokouna iruworo otuworineri kokouna sokisoki xepinaure sokisoki tareteneneai. Aprika tomuro purotai xasi xopu xosaupo usie xosa kitiwopina ximikepi xeikarineri, kesia ororeri xupeue kokouna porowati xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Xupeu xeika sokisoki xasi xeikae xiri sokisoki porosikati, kire asau xosa kokouna xosaupo saina apimie xotapa taineri xuru purerewoteneai. ");
INSERT INTO six_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Asau xeimore xosauwa, kokouna xosaupo saina apimie xoniki xoxixati kokouna xosaupo kesia xeika kireu sapi xeika purewoteneai. ");
INSERT INTO six_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Xokupa asau sini isa xeika pai xeika xekopu xuweukiri, xokupa yause kokaipa xupeuni kutue xiri porosiketai. Pa xati sini pani kakati puropinuku xi nanuwopu xuwe. Sini xokupa xuwe xepinuku xi nanukiriai. ");
INSERT INTO six_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Xokupa asau apimie xoye tepu xuweuwori, Polue nini xopu tumuna ipaki kunauna, “Tini apimi, tini yeu kuna tainuku Kriti sou wetepu xuweukiriai xakua, mua yause xoxi tinuku, xokupa xuru purere wakuxe. ");
INSERT INTO six_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pana ye mua katikine, tini xotiki yorowa, pa amure, sini kire apu xuwe xepuxe. Kokouna kireni xuwe xepina. ");
INSERT INTO six_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ye Xoiteupo apu, ye nure muris tiroune. Ximine ukumani Xoiteupo xenikorokoroe mana ye nutiemi tumuna, ");
INSERT INTO six_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ipaki kaina, ‘Polu ne kaki xanau ximikeu. Ne xounau Sisari moaro tumuwowai. Iyese. Xoiteue neu kunikuni iyesetaina, xokupa apimi kokouna xouro ne xeika puroteneai, nini xuwe xepuworixe.’ ");
INSERT INTO six_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Xenikorokoroe ipaki kunawotaina, tini apimi, tini kaki xanari ximikaku. Xoiteue ye kayetai sie xokupa kapia kakepina xati nure ye xoisune. ");
INSERT INTO six_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Pa xati sini kokouna wetikiri xowati, xupeue kokouna sokau porowati kire sou xosa utu kitiwopina,” niketai. ");
INSERT INTO six_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Xoka 14 ukumu xosa paiya kokaipa xasi Mititerenia xosa xusakiriai. Ukumani 12 kiloku tomuro xosa kokouna xosaupo saina apimie kokouna kire usie xosa putawopure xina xineri xonikie saina teteneai. ");
INSERT INTO six_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Pa xati xasi xiri minikare xuwere xi sipawopure mita xeteneai napoka otuneri, 40 mita xosa otuwoteneai. Kokounae pani xayaka xayaka xounati 30 mita xosa iyareteneai. ");
INSERT INTO six_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kokounae xe tuku iri xosa munauti mauti xonana kitina xiri porouwexete xineri paire ximiketeneai. Pa xati kokouna soki titi naipa 4-teu kokouna xotaporo otuwoteneai. Kakerineri asau sapau mopinaure kunikuniwoteneai. ");
INSERT INTO six_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kokouna xosaupo saina apimie kokouna wetepure ime xireketeneai. Kakerineri ouso iyososowori munati, xoreixineri kokouna soki titi naipa kokouna nuturo otuwopure xinuku xeteneai. ");
INSERT INTO six_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Polue xomatua nikau tumu xeika xomatua xeika ipaki kanikina, “Mua apimie kokouna xosa puropu xuweuworia, tini xuwexakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pa xati xomatuae kokouna tipurotai sokisoki xume puromuweri ouso xasi xosa uraki xouna tiriri xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Asau mopure tomuro xatia, Polue xokupa apu kaniketai. Sainikeri xoye tinikepure ipaki kunauna, “Xuwau yause xotikikemu ati misepu xuweuwati tini xoye nepu xuwe. Tini aini kutu, 14 asau purikiriai. ");
INSERT INTO six_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Pa xati ye sokisoki kuna katikine, tini kireu xoye takuai. Kakaria sokisoki tikepina. Iyesa. Tini kirei xakusu xoxixakuaixe. Xuwe. Tini ati purakuai,” niketai. ");
INSERT INTO six_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kaki kunarina, tupumoru tina ekinikiro Xoiteu eiyase wotai. Kakerina tupumoru porouweina netai. ");
INSERT INTO six_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kakati xokupa apimi nikau xoniki asinaku xati, ninie rania kireu xoye neteneai. ");
INSERT INTO six_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Sini kokouna xosa purikiriai apimi, sini 276-teue apimi teue purikiriai. ");
INSERT INTO six_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Xoye itouni nieineri, kokouna xirikeu xepinaure, wit waxi xasi xosa purerewoteneai. ");
INSERT INTO six_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Asau putawati, kokouna xosaupo saina apimie siko putaukiriai usie ukau xekoteneaina pana, amu sanawapu usie ukau nini sipa xuwe. Kire au xiri xururoni kutu asinaku usie tuku xekoteneai. Paire nanuneri sini itou xatia kokouna xauwakiri pa usie ukau xosa xowopina xeteneai. ");
INSERT INTO six_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Kakerineri xokupa kokouna soki titi naipa xosaupo sokisoki xume kakatieineri xasi xosa weteri purotai. Pani kokouna tairouneri kasira kokai aimore, sokisoki xumei tareneai xureiyeteneai. Kakerineri xupeu tepure kesia xayaka xouropu puruweri, kokouna usiero xemeyouyou xowotai. ");
INSERT INTO six_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Pana kokounae kire usie, xasi ukauro purotai xosa xou nutu warina xiri sokisoki kiti purotai. Kakati xasie kokouna nikekemu ouna porouwotai. ");
INSERT INTO six_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kakauya apimie xasi sopipineria ximi xowopineri xi, xomatuae nanuworineri ounikiepure xeteneai. ");
INSERT INTO six_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kakeri xomatua nikau tumue Polu tianuwopurerina, kakixanari kakauya apimi ounikiaku niketai. Kakerina ene sopipirouneri apimie, xasi xosa potixineri pira putawopinerire kaniketai. ");
INSERT INTO six_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kireu apimia na masamasa xeika kokouna porowotai masamasa xeika tineri, xasi sopipi xouneri putauwopineri xetai. Xomatua nikau tumue kunawotai sie kakeri, sini matotoni utu usie xosa putaukiriai. Kire apue xuwe xepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Sinie usie xosa asinakuni putarinuku, kire sou wenuneri Malta xeteneai xosa purinuku xi sipaukiriai. ");
INSERT INTO six_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Pa wesepu apimie asinaku kapiani kutu sini xosa kaketeneai. Ene moati wese ututua xati ninie xepi kararineri ututua woropinukure sini xokupa xepi tomu sosiki xonoteneai. ");
INSERT INTO six_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Polue kireu xepi mou kunununa karawotai. Kakati kire matu xepi teu xosa purotaia xepi omopue tati, kisau mana Polupo xupo xosa ma katotouna tua purotai. ");
INSERT INTO six_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Pa matue Polupo xupo katotouna tua purati wesapu xuimi apimie xekoteneai. Kakati nikoniko ipaki kunauneri, “Xekoa. Mua apu nu apu ouweirounarau. Nu xasi xosa xumopu xuwena pana muaiya, xoiteu nu wenuneri Xapa Tepina xeteneaie nu ekeoma puropi xiraxina,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Polue pa matu putauwati xepiro munotaina pana, nuko amakepu xuwe. ");
INSERT INTO six_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Xuiapue nanuneri Polupo mupo orewopinare e sapauni titikiri xouna xumopina xineri xuwau yause yakuwoteneai sorena, nu amakepu xuwe. Pa xati nanunanu pirixi kunauneri, “Nu kire xoiteu,” xeteneai. ");
INSERT INTO six_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pa wese tomuro purotai ou paiya, pa sou xosaupo akereki tumupo ou, nupo wenumu Pupliusi. Pa apue nupo atoro sosiki xouna, xeimore asau ati yakusiketai. ");
INSERT INTO six_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupliusipo omo supa purotai. Mupokemu xepie kerieuna pirawotai. Kakati Polue nu xosa xonana kunikuniwotai. Nu xosa xupo iyarati, xiyeri meruketai. ");
INSERT INTO six_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Polue panumu kakati, pa sou xosaupo kireu supa apimie nu xosa kori, nini rania atinikati meruketeneai. ");
INSERT INTO six_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ninie sini atineri yakusiketeneai. Xurise sini weniki xowopure xikiriai yause xosa rania, sinipo xokupa xuru xuwexetai sikineri, kokouna xosa soxeteneai. ");
INSERT INTO six_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sinie xeimore poita Malta sou xosa purikiriai. Xurise kire kokouna, kokaipa xupeu yause xati pa sou xosa purotai xosa epixikiriai. Pa kokouna paiya Aleksantria erewesepu. Nupo moakemuropa xoiteu Susupo nono aimore etopu nikau xeniroroi kesiwoki tuku. Sinie Malta sou wetinuku pa xosa xoukiriai. ");
INSERT INTO six_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sinie erewese Sirakyusu xou putaunuku, xeimore asau purikiriai. ");
INSERT INTO six_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Sirakyusu wetinuku Rekiumu erewese xou putaukiriai. Xurise kire asau xosa, asau munarouna masairapu xupeue saroati, Rekiumu wetikiriai. Asau xoka xeimore xosa paiya sini erewese Puteoli putaukiriai. ");
INSERT INTO six_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Pa erewese xosa kireu Yesusure xonikisuwoteneai xuiapu xekenikikiriai. Nini xeika puropinukure kasikeri, nini xeika 7-teu asau purikiriai. Nini weinikiterinuku, kokaipa erewese Romu xoukiriai. ");
INSERT INTO six_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romupo Yesusure xonikisuwoteneai teue sini kounuku kuna iyeserineri, kamamu tutumasikepure koteneai. Kakeri sinie Apiusipo Maket xeika wenuneri Xeimore Toro Ata wese xeteneai xeika xosa tutumanikikiriai. Polue nini xekenikerina, Xoiteu eiyaseiworina nupo xoukemu sokisokixetai. ");
INSERT INTO six_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romu minika makiria, kapmanie Polu nu nukoni kire atoro kire xomatuae yaku puropinaure iyo wotai. ");
INSERT INTO six_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Polue xeimore asau Romu purina, Yuta nikau tumu yainiketai. Ninie kou kununueria, ipaki kanikina, “Yewapu xura, yei sikou xuiapu oroinikepure re e asisikimana nikau kapia porowopure amu amakepu xuwe. Pana Yerusalemu kakauya xosa iyaiyerineri, Romu xupunikiro iyaiyereteneai. ");
INSERT INTO six_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romue yeu kuna iyeseteneaia, ye ouiepineri sie xu xekopu xuwe xati weitepure xeteneai. ");
INSERT INTO six_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Yuta apimie sokisoki xeteneai. Pa xati ye kire ime xuweitauyetai. Sisarie yeu kuna xekeriyepina xi kunautiai. Ye ikou xuiapu rania kire sapire kuna xosa iyainikerepine sie xuwe. ");
INSERT INTO six_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ye tini xeketikinei kuna tikepure, pa xotapaure kireni ye yaitikiti koukiriai. Siko Israili yakukiriai sapi ye xoisune yakune. Mua sokisoki xumei ye taiyeretaia pa xotapaure,” niketai. ");
INSERT INTO six_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kakati ninie ipaki kauneri, “Kireu Yutiapu apimie neure kasikepure nakau xayau xesarisikepu xuwe. Pa xeika kire Yutapu apue sini xosa kouna perauna neure kireu xoxi kuna kunawopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pa xati nakieni neu nanunanu uteiwau sini iyesepure xinuku, pa amure, sini sipa, xokupa wese paiya, mua oma apu tutu siko Yuta xopu xosa sarotaire xuiapue xoxixoxi kuna kunaurouneri,” woteneai. ");
INSERT INTO six_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Paire kire asau xosa kununu iyareri, xokupa apimie Polu nuko purotai ata xosa koteneai. Kakeri Xoiteue xuiapu yakunikirouna yauseure, xoripesauni kuna utei xouna xouna xoruwati xetai. Polue kireu kuna Mosesipo tuxotapa xosa puroto, kunatureture nikau xosa purotowotai kunae ninipo nanunanu sarati Yesusure xonikisuwopinerire, sokisoki saina tetai. ");
INSERT INTO six_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kakati kireu apimie nanuneri mua kuna Polue kunawotaia, suwau xeteneai. Kireua nupo kunaure xonikisuwopu xuwe. ");
INSERT INTO six_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nikoniko kuna tuwatarineri, xowoteneai. Xowopure xeria Polue kireu kuna ipaki kanikina, “Xoiteupo Supo Youyae suwauni kutu kuna kunatureture Aisaiapu suporei sikou asisikimana kanikeyai. Ipaki kunauna, ");
INSERT INTO six_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ne pa apimi xosa xounau ipaki kanike, “Tini xokupa yause kuna iyesakuai sorena, nupo xotapa sipawakuaixe. Tini xokupa yause oioiwakuai sorena, tini kire sapi xekeu sipawakuaixe,” xeyai. ");
INSERT INTO six_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pa xuiapu nikau nanunanu parauwati, xakunikie kuna iyesepi xiraxineri, ekiniki sasauweteneai, kire sapi xekeri kuna iyeseri kuna xotapa sipauwei, xoniki pirixineri ye xosai kori, yei xiyeri atinikiti merukepi xiraxineri,’ ” niketai. ");
INSERT INTO six_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Polue pani ipaki kunauna, “Pa xati tini sipawa, Xoiteue xiyeri tisikepure asinaku saina teyai kuna paiya, Xoiteue xetau xuiapu xosaniki xesawoyai. Kakati ninie iyesepineri,” niketai. ");
INSERT INTO six_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Polue aimore xitosani kireni ata xosa purotai. Pa ata xosa puropure ata xataku apu xe turouna. Apimie nupo atoro koria xekenikeri nimaririrouna. ");
INSERT INTO six_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kakina Xoiteu xuiapu yakunikirouna yauseure kuna uteina, Kokaipa Yesusu Kristusupo kuna xuiapu kanikirouna. Nu kuna uteiwopi ximikepu xuweuwati kire apue taiyeruwopu xuwe.");
INSERT INTO six_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Ye Polu Yesusupo tianuwopi. Apimie ye xesayeneaixe, kire apue tianuwopi saina xosa iyaiyerekixe. Xuwe. Ye mua saina Yesusu Kristusu xeika Xauwa Xoiteu nukoe Kristusu kopa upuropu sareyai xeika xupunikiropu tiyai. ");
INSERT INTO six_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Iko xeika xokupa xataimanae purianiyeteneai xeikae mua nakau xayaunuku tini Yesusure xotikisukiriai xuiapu Kalesia propinsi purikiriai xosa xesaritikinuku. ");
INSERT INTO six_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Sikou Emisiki Xoiteu xeika, Kokaipa Yesusu Kristusu xeikae, tinire xounikisuaxati xounikietikineria tinipo xotikikemu yororepineri. ");
INSERT INTO six_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Kristusue Emisiki Xoiteupo nanunanu taiwotai xati, sikou xunu wetepure nukou ekeomani wetetai. Mua kapia xoxi mua ouro purotai xosaupo xiyeri tisikepure nue panumu kaketai. ");
INSERT INTO six_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Pa xati sini Xoiteupo wenumu sipesi sipesi xourorepu. Pa suau. ");
INSERT INTO six_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Tinie pa kapia kakari yeu xoikemu xiri karakani kutu karakauna. Kristusue tinire xousuaxati xouwetiketai sainaure, Xoiteue tini nupo xuiapu kini sayakuaire yaitiketaina pana, tinie nu sapauni wetinuku, kire xetau xonuxonu asinaku kuna tainuku. ");
INSERT INTO six_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Pana xetau asinaku kuna puratixe. Xuweni kutu. Kireu apimie tinipo nanunanu parawopi saina kireni tineri, ninie Kristusupo asinaku kuna pirixanauwopurexineri. ");
INSERT INTO six_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Pana sikoini tini xosa asinaku kuna uteikirire kire mena xouropu xenikorokoroe uteiwati, pa asinaku kuna ekime sinie asinaku kuna uteikiniai siexepu xuweuwatia, pa kapia kaketai apu paiya nu xepi xosa xuwexepina. ");
INSERT INTO six_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Mua kuna ekime kunaukiniai, ximine yei xiyeri pa kunani kunaune. Kire apue asinaku kuna tini xosa uteiwati, pa asinaku kuna ekime tinie tikiniai siexepu xuweuwatia, pa apu nu xepi xosa xuwexepina. ");
INSERT INTO six_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Tini amuxi nanunukuna? Yei mua kuna kunautiai paiya, apimie yeure xonikikemu asinaku xepinerire e Xoiteue yeure xoukemu asinakuxepina? Yei apimi ai xakuxakunikinere, wo? Iyesa. Ye apimi xakuxakunikepi saina pani tineia, ye Kristusupo saina apu xuwe. ");
INSERT INTO six_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Xatai xura, ye kutuni katikine, pa asinaku kuna yei ekime tini xosa uteiyai paiya, kire apue yarareyai sapi xuwe. ");
INSERT INTO six_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Mua asinaku kuna ye kire apu xosaupo tepu xuwe. Pa xeika apimie paire ye taitai yepu xuwe. Xiri xuwe. Yesusu Kristusu nukoini ye xosa mua asinaku kunapu ximiaropu kuna xokupa yararetai. ");
INSERT INTO six_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","Yei ekime kakiai kapiaure tini kuna iyesieikiriai. Tini sipa, yei Yuta nikau xonikisu sokisoki taine, Xoiteupo xuiapu Yesusure xonikisuwoteneai xiri xoxixoxinikiai. Kakine nini xiri xoxixoxinikepi saina tiai. ");
INSERT INTO six_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Yeu asukamana nikau xokupa kapia xiri sokisoki taine, pa xokupa kapia kakiroune. Yutapu nono tenemai iko sie emeimana nikau kapia emeserinikitiai. ");
INSERT INTO six_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Panaanikae ye iyaiyerepu xuweu yauseni, Xoiteue ye tumuyerina, nukou xousuaxina xouwesikepi kapiae, ye nukou apu sayepineureni yaiyetai. Kakina nukoini iyaretai yause xosa, ");
INSERT INTO six_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","yei saina tinei xetau xeteneai xuimiapimi xosa nukou asinaku kuna uteiwopineure, nukou Nono ye xosa atariyetai. Xoiteue pa kapia ye xosa kaketai yause xosa, ye xoune kireu apimi kotonikepu xuwe. ");
INSERT INTO six_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Ye Yerusalemu xoune akerineri Yesusupo tiantianuwopi sayeneai apimi xekenikepu xuwe. Ye Arepia sanawa xoune puritiai. Kakerine xurise Tamaskusu erewese xiyeri xoutiai. ");
INSERT INTO six_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Xeimore xitosani xouratia, Pita xeika kunakunawopure Yerusalemu xoutiai. Xoune nu xeika 15-teu asau purianutiai. ");
INSERT INTO six_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Pana pa yause xosa ye kireu Yesusupo tiantianuwopi xekinikepu xuwe. Yemusu, nu Kokaipapu xatau, nu kireni xekeutiai. ");
INSERT INTO six_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Mua kuna ye tini xosa xayautiaia, ye Xoiteu ekero xiri suauni kutu kunaune, ye tini xoreitikiti xana xuwe. ");
INSERT INTO six_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Xurise xiyerine Siria propinsi xeika Silisia propinsi xeika xosa teixanautiai. ");
INSERT INTO six_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Pana Yesusure xonikisuwoteneai apimie Yutia tistrikipo xosa puroteneai, ninie yeu moaikemu xekopu xuweuwoneai. ");
INSERT INTO six_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Ninie yeure kireni kuna ipaki iyesirouneri, “Ximuximu pa apue siko ousikiepi saina teyai, pana muaiya pa xosikisuwopi kapiapu asinaku kuna ekime nukoe xoxixoxiwoyaire uteirouna,” xeteneai. ");
INSERT INTO six_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Xoiteue ye xosa kaketai kapiaure iyeserineri ninie nupo wenumu xouroreteneai. ");
INSERT INTO six_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Ye 14-teu xitosani ere puritiaie, xurise sini Parnapasino Yerusalemu xiyeri xouyatiai. Ikoe Taitusu souti xirini xoukiriai. ");
INSERT INTO six_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Ye xowopineure Xoiteu nukoini atariyeai. Pa xati ye Yerusalemu puritiai yause xosa, Yesusure xonikisuwoteneai kokaipa apimi kireni xeika kunakunau kanikine, pa asinaku kuna xetau xeteneai apimi xosa uteirounexi kanikitiai. Ye nanutiaia, ye mua saina titiai xeika ekime saina tiyai xeika rania, aini xuwexetexine. ");
INSERT INTO six_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Taitusue ye xeika purotai, nu Kriki kinipo apu. Pana nupo mupokemu kesewopinukure kokaipa apimie kunawopu xuwe. ");
INSERT INTO six_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Suau, kireu xoreixorei xatasikimanae sinipo kununu xosa ximiarei moteneai. Yesusu Kristusue Mosesipo tuxotapapu kakauya xosaupo siko xesasikieina somoro iyaisikerina pa kapia siketaire tusikiworopure koteneai. Kakineri siko kakauya xosa xiyeri iyaisikerepure xeteneai. ");
INSERT INTO six_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Pana pa xoreixoreitutuae Taitusupo mupo ipisa kesewopure xeteneai paiya, sinie iyo xepu xuwe. Sinie xayakaxayaka ninipo kuna iruexepu xuwe. Asinaku kunapu kunani kutu pirixepu xuweuwati, tinie kutuni sipesi taiwakuaire xinuku. ");
INSERT INTO six_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Kireu apimi nini Yesusure xonikisurouneri xuiapu sie tumu teu puroteneai. Nini kokaipa weniniki tukure xuwerau, paire ye nanunanu xuwe. Xoiteue apu nikau weninikire nanurouwatixe. Pa weniniki tuku apimie, yeu kuna xosa kire kuna pani turewarerixe. ");
INSERT INTO six_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Xuweni kutu. Pitae Yuta apimi xosa asinaku kuna uteiwopinaure Xoiteue saina tuwotai sie, xetau xeteneai xuimi apimi xosa asinaku kuna uteiwopineure saina siati xekeyeteneai. ");
INSERT INTO six_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Iyo, Pitae Yesusupo tianuwopi saina Yuta apimi xopu saina tepinaure Xoiteue sokisoki tuwotai, panumu sie ye xetau xeteneai xuiapu xopu Yesusupo tianuwopi saina tepineure Xoiteue sokisoki sietai. ");
INSERT INTO six_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Yesusure xonikisuwoteneai xuiapue Yemusi xuno, Pita xuno, Yoni xuno kokaipa tumu sie xekenikeri, Xoiteue yeure xousuwaxati xouweyerina mua saina ye sietai. Ninie pa saina xekerineri sini Parnapasino xeika xosikemu tuma xepinukure xupusi teteneai. Kakeri xosiki tumari ipaki kuna ounuku, sinie xetau xeteneai xuiapu xopu saina tepinua, niko paiya Yuta apimi xopu saina tepineri xikiriai. ");
INSERT INTO six_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Nini kirenie kireni kuna kasieteneai. Ninie Yesusure xonikisuwoteneai xuimiapimi xopu saruku puroteneai apimi tianikepi saina tepinuaure kasieteneai. Ekimeni ye pa saina tine nimaririyai xati, ye sokisokineni saina tine. ");
INSERT INTO six_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Xurise Pitae erewese Antioku koati moa tine autiai, pa amure, nue asinaku kapia kakepu xuweuwotaire. ");
INSERT INTO six_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Yemusipo xataumana kopu xuweuni, Pitae xetau xeteneai apimi xeika xoye nirouna. Pana pa apu teue kouweria, Pitae mari takepure sokisokirouneri Yesusu tairouneri xuimiapimi teure ximiketai. Pa xati xetau xeteneai apimi weinikiteri nukoni purina, nini xeika pani lixepi wetetai. ");
INSERT INTO six_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Kireu Yutae rania nu xeika panumu xoreixorei kapia kaketeneai. Kakeri ninipo pa xoxi kapiae Parnapasipo nanunanu rania porowotai. ");
INSERT INTO six_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Pana yei nini xekenikitia asinaku kunapu kunani kutu ati taiwopu xuweuwori, nini ekinikiro Pita ipaki kaune, “Ne Yuta kinipo kire apuna pana, ne xetau xeteneai nikau apue sie ninipo kapia taiwau, ne Yutapu apu sie xuwexina. Pa xati amakati xetau xeteneai apimie Yuta nikau kapia taiwopinerire ne xiri sokisokixinenaxi?” kautiai. ");
INSERT INTO six_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Suau, sini Yuta kini paiya, sini xunu erirouneri apimi nini xetau xeteneai apimi kinirei putawokixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Pana siko sipa, apue Mosesipo tuxotapa taiwotai, pa xotaparei Xoiteue nu apu kutu asinakuwatixe. Xuwe. Apue Yesusu Kristusure xousuwotai pa kireni, Xoiteue apu asinaku xirouna. Siko rania sini Kristusu Yesusure xosikisukiriai, pa amure, sini sipa, pa imerei kireni Xoiteue sini apu kutu asinakusikepina, tuxotapa taiwopi imerei xuwe. Pa amure, kire apue atina tuxotapa taiwati Xoiteue apu kutu asinakuwopina siexe. Xuwe. ");
INSERT INTO six_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Sini mua ime Kristusure xosikisuwopi tainuku Xoiteu ekero kutu asinaku apu sainukua, siko Yuta rania xekeukiria xetau xeteneaie xunu ereteneai sie xunu erinuku. Paina sini kunaunuku, Kristusu nukoini kakati xunu sokisokixepure xina xepure, wo? Sini panumu kakinuku kunawopuxe. Xuweni kutu. ");
INSERT INTO six_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Ye tuxotapa irue puropi kapia xuweiyeine xurise pa kapia xiyeri sarine paiya, ye ikoini xunu erepi apu saine. ");
INSERT INTO six_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Pana tuxotapae ye xumopine ime iyaiyeretai xati, tuxotapa ekero ye xumoki sie apu purine. Pa imerei ye Xoiteu xeika mua ekioma purine. Ye Kristusu xeika na nikitoto xosa tuane nu xeika xumutiai ");
INSERT INTO six_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","xati oma ekioma titiai. Pana pa ekioma paiya ikounixe. Xuwe. Kristusu xosa ye ekioma purina. Ye ximine xokupa kapia xeika saina xeika mua ouro kakitiai paiya, ye xoisu imerei kakine. Ye Xoiteupo Nonoure xoisuti nue ye xiri xouweina tianiyepure nokou ekeomani wetetai. ");
INSERT INTO six_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Xoiteue yeure xousuaxati xouweyetai kapia yei aipu sapi siexepi xiraxine. Mosesipo tuxotapae Xoiteupo ekero sini asinaku kutu apimi saisikepina paiya, Kristusu nu aini xumotai. ");
INSERT INTO six_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Tini Kalesiapu apimi tini nananatua, sinie Yesusu Kristusu ataritikikiriai. Takipo ekitikieni xekoari na nikitoto xosa tua purotai. Yue tinipo nanunanu porounana? ");
INSERT INTO six_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Ye kire sapire kireni kototikepurexine. Tini amu imerei Xoiteupo Supo Youya tikiriaina? Tuxotapa taiwopi imereire? E asinaku kuna iyesinuku xotikisuwopi imerei? ");
INSERT INTO six_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Tini nananaieikiriaire, wo? Tini Xoiteupo Supo Youyapu sokisokie sesexepi xotapa taikiriaina pana, ximine takipo sokisokieni xuweiepure xinukure? ");
INSERT INTO six_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Ekime tini xosa xu moneai paiya, tini aini xemekiniaire, wo? Pana ye nanutiaia tini aini xemeropu xuwe. ");
INSERT INTO six_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Xoiteue Supo Youya tikerina tini xopu xonuxonu eretai. Amakati nu panumu kaketaina? Tinie tuxotapa taiwari nue kaketaire? E tinie asinaku kuna iyeseri xotikisuari nanuworina kaketaire? ");
INSERT INTO six_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Xoiteupo nakau muanumu kuna tuku, “Apraxamue Xoiteupo kuna xousuwati, Xoiteue apu kutu asinaku,” woyai. ");
INSERT INTO six_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Pa xati tini sipa, asinaku kunaure xonikisuwoteneai apimia, nini Apraxamupo niraumanani kutu. ");
INSERT INTO six_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Xoiteue ekimeni sipauna, xurise xetau xeteneai xuiapue asinaku kunaure xonikisuworia, nini xuiapu kutu asinaku xepinexina nanuwoyai. Pa xati Xoiteupo nakaue kunawotai sie Apraxamu xosa asinaku kuna uteina, “Ne xosa Xoiteue, kakatia xokupa xuiapu asinaku sayepineri,” xeyai. ");
INSERT INTO six_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Apraxamue xousuwati Xoiteue nu atina mupoxusi ouwoyai. Xokupa xuiapue xonikisuworia Xoiteue panumuni kakepina. ");
INSERT INTO six_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Apue nanuneri tuxotapa taiwopi kapiae kakatia sini Xoiteu ekero kutu asinaku xuiapu sayepinuku xeteneaia, Xoiteue xokupa xoxixoxinikepina. Pa amure, Xoiteupo nakaue mua kuna tuku, “Kire apue tuxotapapu nakau xosa purotaipo xokupa kuna xiri taiwopu xuweuna paiya, Xoiteue nu xiri xoxixoxiwopina,” xeyai. ");
INSERT INTO six_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Xoiteupo nakaue pani muanumu kuna tuku, “Xonikisuwoteneai apimia, Xoiteue nini apimi kutu asinaku nikatia nini ekinikioma puropineri,” xeyai. Pa kunae sini yarani ipaki atarisikina, kire apue tuxotapa taiwati Xoiteue nu apu kutu asinakuwopina ime xuwe. ");
INSERT INTO six_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Tuxotapa taiwopi ime paiya, xosikisuwopi sapixe. Xuwe. Paiya nukou sapini. Pa amure, Xoiteupo nakaue ipaki kunauna, “Xokupa tuxotapa taiwotai apua, nu ekeoma puropina,” xeyai. ");
INSERT INTO six_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Tuxotapae ipaki kunauna, sini xokupa apue xokupa tuxotapapu kuna taiwopu xuweunuku paiya, sini xiri xoxiepu. Pana Kristusu nukoini tianisikepure, mua wenumu “xoxixepina apu tetai” xati nue xiyeri tisiketai. Xoiteupo nakaue ipaki kunauna, “Xokupa apimie na xosa toaroteneai paiya, nini xoxixepineri apimi kireni Xoiteue xekeniketai,” xeyai. ");
INSERT INTO six_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Xoiteue Apraxamu mupoxusi ouweina xetau xeteneai xosa asinaku kapia kakepine xina kunawoyai. Kakeyai xati ekime Xoiteue kunawoyai sie, mua saina Yesusu Kristusue teyaie, ximine xokupa xuiapu kini xosa mua mupusikixusi ouwopi saina akipa xati, siko xokupae asinaku kunaure xosikisunuku Xoiteupo Supo Youya tepu. ");
INSERT INTO six_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Xatai xura, ye ximine siko apu sikau kapiaure kunaune. Kire apue nanuna ye xumopinerina, nupo nonomi atina nupo xuru uteiyerinikepure nakau xayawopina, paina nupo pa kuna paiya kire sokisoki xoka kuna siena, kire apue pa kuna xouro kireu kuna pani iyarirouwatixe, pa xeika kire apue kunauna, “Sini mua sokisoki xoka kuna taiwopuxe,” xirouwatixe. ");
INSERT INTO six_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Ekime Xoiteue kunauna asinaku sapi xurise yaraxepina xeyai. Xoiteue pa sokisoki kuna Apraxamu nirauno tinieyai. Xoiteupo nakaue ipaki kunauna, “Neu nonomi xosaxepu,” xuwe. Nu xokupa nonomire kunawokixe. Xuwe. Nu kirenire kireni, ipaki kunauna, “Neu nono xosa,” xeyai. Pa nono paiya Kristusu. ");
INSERT INTO six_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Yeu kuna xotapa muai. Xoiteue ximuximu Apraxamu xeika sokisoki xoka woyai. Xitosani 430-teu xouratia, tuxotapae putawoyai. Pa tuxotapa paiya xuriseni kutu putawoyaina, nue pa sokisoki xoka kuna ekime Xoiteue kunawoyai xesauwepuwatixe. Ekime Xoiteue pa sokisoki kuna kunawoyai xuweiyepuwatixe. ");
INSERT INTO six_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Xoiteue sini akituworisikeyai sapi tepure tu xotapa taiwopua, sini sokisoki kunapu imerei tikirixe. Pana siko sipa, Xoiteue mua xokupa sapi Apraxamu tuwopinexina sokisoki kuna kunawoyai. ");
INSERT INTO six_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Panumu xatia, paina amakati tuxotapa purinana? Paiya muanumu. Xunu yarani akipaxepinaure Xoiteue pairexina, pa xati Xoiteue sokisoki kuna tuweinapa, xurise tuxotapa rania tuwotai. Kakina tuxotapa puratieye pa nono ekime Xoiteue sokisoki kuna kunauna xokupa sapi tuwopine xeyai putawopina. Xoiteue mua tuxotapa xenikorokoro tinikati ninie kire xopuropu apu xosa uteiwori xopuropu apue siko siketai. ");
INSERT INTO six_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Xoiteue Apraxamu sokisoki kuna tuwoyai xati kire xopuropu apu nupo kuna tuwopu xuwe. Pa xati Xoiteu nu kireniara xati, nukoini sokisoki kuna kunawoyai. ");
INSERT INTO six_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Tuxotapa paiya ekime Xoiteue sokisoki kuna kunawoyaipo xiwai siexi kunawopinerau? Xuweni kutu. Sini ekisikioma tepure, Xoiteue xetau tuxotapa sikeyai xakua, paina tuxotapa taiwopi kapia paie kakatia sini apu kutu asinaku sayepu. ");
INSERT INTO six_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Pana Xoiteupo nakaue ipaki kunauna, “Xunue xokupa xuiapu kakauya xosa iyainikerati,” Xoiteue pa sapi wetati moati, paiya apimie xonikisuworia pa sapi tinikepine xina Xoiteue sokisoki kuna kunawoyai xati sini Yesusu Kristusure xosikisukiriai apimia pa sapi tepu. ");
INSERT INTO six_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Xosikisuwopi yause putawopu xuweuni, tuxotapae kakauya xosa iyaisikeri purotai. Sini kakauya xosa purikiri xosikisuwopi yause yara putawotai. ");
INSERT INTO six_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Sini Kristusu xosa sosiki koati, asinaku kuna xosa xosikisukiri Xoiteue sini xuiapu kutu asinaku xepinaure tuxotapae sikou emisiki yayakusikepi purieuna. ");
INSERT INTO six_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Ximine xosikisupo yause putawotai xati, pa emisiki yayakusikepi irue sini purikirixe. ");
INSERT INTO six_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Tini xokupae Yesusu Kristusure xotikisunuku nu xeika etokinuku, pa kapiarei tini Xoiteupo nonomi sainuku. ");
INSERT INTO six_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Tini xuiapue Yesusu wenumurei ene isinuku nu xeika etokikiriai paiya, apue nupo nekei xuwau ereretai sie tini xokupae Kristusu taukiriai. ");
INSERT INTO six_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Yesusupo apu kini xosa paiya, Yuta kini xeika Kriki kini xeika xuwe. Aipu saina apimi xeika somoropu apimi xeika xuwe. Xuimi xeika apimi xeika xuwe. Ximine Kristusu Yesusu xosa paiya tini xokupae xiri kirenieri purinuku. ");
INSERT INTO six_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Tini Kristusupo apu kini purinaria, tini rania Apraxamu nonomi purinuku. Ekime Xoiteue Apraxamupo apu kini pa sapi tinikepure sokisoki kuna kunawoyai paiya tini pa apu kini sore. ");
INSERT INTO six_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Yeu kuna paiya muanumu. Xauwae kireni nono tuku xatia, paina pa nonoe sewai omopu xokupa xuru tepina. Pa xuru teua nonopu xuru sie purotai. Pana pa nono nu tenemai purotai yause paiya nu omopu aipu saina apimi sie purotai. ");
INSERT INTO six_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Nu apu yayaku xeika tumu teu xeika irue puropina puropinae utu omoe iyaretai yause xepina. ");
INSERT INTO six_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Pa xati siko rania panumu sie. Sini nono misiarara sie purinukua, sini mena xeika ou xeikapu sapi yakurouneri yaniyani nikau aipu saina apimi sie purikiriai. ");
INSERT INTO six_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Pana Xoiteue iyareyai yause xosauni kutu paiya, nukou Nono xesawati kotai. Xuie nu iyarati, nue tuxotapa irue puropu apu sayetai, ");
INSERT INTO six_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","paiya sini xuiapu tuxotapa irue purikiriai isayasikati, Xoiteupo nonomi sayepure kaketai. ");
INSERT INTO six_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Ximine tini Xoiteupo nono purinuku. Pa xati Xoiteue nukou Nonopu Youya xesawati sikou xosikiro kotai xati Youyae kakati sinie Xoiteu ipaki uru yaunuku, “Apa, Xauwa,” xinuku. ");
INSERT INTO six_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Pa xati ne pani aipu saina apu purauxe. Xuwe. Xoiteue kakati ne nupo nono saitiai. Ne Xoiteupo nono purinaua, ne sipa, ne nupo xokupa asinaku sapi tewai. ");
INSERT INTO six_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Ekime tini Xoiteu sipa xuwe xati, xoiteuni kutu xuweupo aipu saina apimi purikiriai. ");
INSERT INTO six_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Pana muaia tini Xoiteu sipauweikiriai. E ye kunaunei, Xoiteue tini sipatikietai xepinerau. Pa xati tini amakati pa xoxi yanyani xiri sokisoki xuweu xosa xiyeri xonarinuku, ninipo aipu saina apimi sayepurexinukuna? ");
INSERT INTO six_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Muris tepi kokaipa asau xeika oma poitapu xeika oma xitosanipo kokaipa muris tepi xeikaure tuxotapa taiwopure tinie sipesi nanurounuku. ");
INSERT INTO six_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Tinipo pa kapiaure ye nanuworine ximikine, panumu yei tini xopu saina tiyai paiya aini xuwexete. ");
INSERT INTO six_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Xatai xura, tini iko sie xa xi kototikine. Ye ikoini tuxotapa wetine tini siexiti, pa yause xosa tinie ye xosai kire kapia xoxi kakepu xuwe. ");
INSERT INTO six_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Tini pani nanunukure, wo? Kire supae tiyetai xosa, ximuximu yei koune tini xosa asinaku kuna uteiyai. ");
INSERT INTO six_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Yei mupi sokisokixepu xuweuwati, paie tini kokaipa xu tikitiai. Pana tinie ye nikitiki sinuku, ye xeika puropi tini ouyexepu xuwe. Tinie ye kire Xoiteupo xenikorokoro sie tikiriai, paire tini Kristusu Yesusu nukoni tieukiriai. ");
INSERT INTO six_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Pa yause xosa tini yeure xotikikemu asinaku xati nimaririxikiriaina pana, tinipo pa nimariria ximine amuro purinana? Ye suauni kutu kunaune, pa yause xosa, tinie ye tianiyepure ere xotikieikiriai xakua tinipo ekitiki xexesiraunaku siaku. ");
INSERT INTO six_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Pana muaia amakatina? Ye tini xosa suau kuna uteiti, paie kakati ye tinipo xiwai sainere, wo? ");
INSERT INTO six_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Iyesa. Pa apimie tini xakuxakutikepi saina teteneaia, nini tini tianitikepineri nanunanu tukuxe. Xuwe. Tinie nini tianikakuaire kireni, ninie tini katoitikepurexineri. ");
INSERT INTO six_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Sini kireu xosa asinaku kapia kakepure nanunanu sokisokixinuku paiya, pa itou. Ye tini xeika puropu xuweuti rania, tini sipesi pa kapia kakakuai. ");
INSERT INTO six_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Yeu nonomi, xuie nono iyarepure tatau tirouna sie, ye xiyeri tatau tine, pa amure, tini Kristusu nuko sieni Xoiteupo nononi kutu sayakuairexine. ");
INSERT INTO six_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Ye xiri xoisuaxina, muaia ye tini xeika puri xana xuwe. Ye taki xeika purinei xoia, asinaku kuna tini xeika xayakaxayaka kunawopine. Ye tinire xiri xoisuaxinana, ye sipa xuwe, ye amakinei tianitikepinerau. ");
INSERT INTO six_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Tini tuxotapa irue puropure xikiriai apimi, tini ximine ye kaya. Tini tuxotapapu kuna sipa xuwere, wo? ");
INSERT INTO six_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Xoiteupo Nakaue ipaki kunauna, Apraxamu nu sawai nono aimore tuku. Aipu saina xui, Akari, nu kire iyaretaina, somo purotai xuie kire iyaretai. ");
INSERT INTO six_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Pa aipu saina xuipo nono paiya, xuiapue nono soxirouneri imerei iyareyai. Pana somo purotai xuipo nono paiya, Xoiteue sokisoki kuna kunawoyai xati nu putawoyai. ");
INSERT INTO six_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Mua kuna asi minika xosa xonu kuna tuku. Pa xui aimorei nini sokisoki xoka aimore tukue tumuwoteneai. Akarie Sainai siripo sokisoki xoka kunaure tumuwotai xati nupo nonomi paiya aipu saina apimi sayeteneai. ");
INSERT INTO six_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Akari paiya pa Arepia sanawapu siri Sainaire tumuwotai, pa xeika mua purotai Yerusalemure tumuwotai. Pa Yerusalemua nupo nonomi xeika aipu saina xuimiapimi purineri. ");
INSERT INTO six_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Pana kire Yerusalemu mena xouro purotai paiya, nu somo purina. Nu paiya sikou anisiki. ");
INSERT INTO six_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Xoiteupo nakaue ipaki kunauna, “Ne nono iyarepu xuweuroune xauna xui, ne nimaririwo. Xui ne, nono iyarepi tatau tepu xuweuyai, ne xonikemu asinakuxe. Ne siri wanau nimaririnau uru yaxe, pa amure, nei apu tuku xuipo nonomi emeserinikinaua, xokuxokupa nonomi tuku,” xewai. ");
INSERT INTO six_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Xatai xura, tini paiya Aisaki sie. Xoiteupo sokisoki kunae tini nupo nonomi saikiniai. ");
INSERT INTO six_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Pana pa nono xuiapue nono iyarirouneri imerei putawotai paie, pa kire nono Xoiteupo Supo Youyapu sokisokirei putawoyai nono xoxixoxiwoyai. Kakeki xati mua rania panumu kapiani purina. ");
INSERT INTO six_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Xoiteupo nakau xosa amu kuna tukuna? Nue ipaki kunauna, “Pa saina xui xeika nupo nono xeika xesanika. Saina xuipo nonoe kire sapi masa tepuwatixe. Pa somoropu nono paie xokupa sapi tepina,” xeyai. Xoiteupo nakaue kakina kunawotai. ");
INSERT INTO six_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Paina xatai xura, siko sipa, sini aipu saina xuipo nonomixe. Xuwe. Sini somo purotaipo xuipo nonomi. ");
INSERT INTO six_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Sini tuxotapa irue puropu xuweure, Kristusue somo iyaisikeretai. Pa xati tini sokisoki tumuwa. Tini kakixanari apimi weinikitari xiyerineri tini aipu saina apimi sieitikexeni. ");
INSERT INTO six_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Iyesa. Ye Polue tini katikine, tini weinikitari tinipo muputiki ipisa katiworia, Kristusupo sainae tini xayakaxayaka tianitikepuwatixe. Xiri xuwe. ");
INSERT INTO six_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Tini xokupa apimie weinikitari tinipo muputiki ipisa katiwoteneai paiya, ye mua kuna xiyerinei ati katikepurexine, tini panumu kapia kakinaria, tini xokupa tuxotapa xeikani taiwakuai. ");
INSERT INTO six_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Tini tuxotapa taiwopurexinari, pa imerei Xoiteue sini apimi kutu asinakusikepina xinaria, tini Kristusu wetikiriai. Tini Xoiteue xouwetikina xotikiewotai kapia wetikiriai. ");
INSERT INTO six_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Xoiteupo Supo Youyapu sokisokie Xoiteu xosa xosikisunukuna nue sini apimi kutu asinaku xepinaure yakunuku. ");
INSERT INTO six_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Apue Kristusu xosa purina paiya, nupo mupo ipisa katiwopi kapia paiya aipu sapi, pa xeika apue mupo ipisa katiwopu xuweuna rania, aipu sapi. Pana apue xousuwopi kapia kakati paie kire apimi xonikiewopi kapia saratia, pa asinaku sapini kutu. ");
INSERT INTO six_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Ekime tinie Kristusupo imerei texirounuku. Pana yue ime parawati kunani kutu taiwopu xuweunukuna? ");
INSERT INTO six_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Tinie mua nanunanu taikiriai paiya, Xoiteue yaitikirouna imerei koatixe. ");
INSERT INTO six_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Paiya pususu misiarae kakati xokupa tupumoru pususurouna sie. ");
INSERT INTO six_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Kokaipae tini tianikati, yeu nanunanu tainaria, xetau nanunanu taiwopu xuweuwakuaixi xoisune. Yuerau tinipo nanunanu porowopi saina tetai paiya, ye sipa xuwena pana xeuxana, pa apua nukou xure xu xoxini kutu tepina. ");
INSERT INTO six_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Xatai xura, apimie mupuniki ipisa katiwopinerire yei pani suau kuna uteiroune xatia, amakati ye xoxixoxiyepi saina pani kakinerina? Apimie mupuniki ipisa katiwopinerire kunauneia, na nikitotopu kunae apimi nikau nanunanu pani xoxixoxixepuwatixe. ");
INSERT INTO six_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Pa apimi nini tinipo nanunanu puruporowoteneaie, mupuniki ipisa katiwopi kapiaure xiri sokisoki xineri. Pana kakineria, xeuxana nikou mupuniki ipisani katieineri sakumu xiri xesauwepineri. ");
INSERT INTO six_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Xatai xura, suau, tini somo purakuaire Xoiteue tini yaitikeyai. Pana tini ipaki nanunari, “Sini somo purinukuna, xipiki xosikemupo kapia kakepinuku,” xaku. Xuwe. Tini kaki xanari panumu nanunanu taku. Tini takieni xotikikemu xotikiewatixinari takieni takitaki tianuwataxa. ");
INSERT INTO six_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Tuxotapapu xokupa kuna mua kireni kuna yoira xosa kireni purina, “Ne nakie naki xonieutiai sie kireu xonienike,” xina. ");
INSERT INTO six_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Pana tini takitaki kawataxinari waraxinaria, tini sosopa epixakuai. Panumu taki xokupani xuwexaku. ");
INSERT INTO six_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Yeu kuna paiya muai, tini Xoiteupo Supo Youya wetari nue tinipo sesepi taitaitikepina. Tini panumu kakinaria, tini xipiki xotikikemupo nanunanu taiwakuaixe. ");
INSERT INTO six_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Siko sipa, xipiki xosikikemue Xoiteupo Supo Youya ororepurexati, Xoiteupo Supo Youyae xipiki xosikikemu ororepurexina. Nini axirie xiwaixiwaiwataxeri, tini kakepure xikiriai sapi paiya kakakuaixe. ");
INSERT INTO six_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Pa xati tini Xoiteupo Supo Youya tainaria, tini tuxotapa irue purarixe. ");
INSERT INTO six_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Tini xipiki xotikikemupo kapia sipauweikiriai. Paiya nini muanumu kapia, ayaka kapia xeika xunu kapia xeika xoxi kapia kakepure xosikemu saropi kapia xeika, ");
INSERT INTO six_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","xorei xoiteu teu xosa muris tepi kapia xeika seu tepi kapia xeika xiwai sayepi kapia xeika kisamaira kapia xeika makawopi kapia xeika xosiki xoxixoxixepi kapia, ekisikie nepi kapia, nakieni iko kireni paxine kuna tuwataxine kini purixepi kapia xeika, ");
INSERT INTO six_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ati puroteneai apimi xosa maikukuworopi kapia xeika ene nerineri wou erineri xaniki sirakineri xiraxarawopi kapia, kakineri panumu panumu kapia kakineri. Ekime ye katikiyai xati ximine pa kunani xiyeri kunaune. Xokupa apimie muanumu kapia kaketeneai paiya, nini Xoiteue xuiapu yakunirouna yause manepuworixe. ");
INSERT INTO six_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Pana Xoiteupo Supo Youya paie muanumu asinaku kapia sinie kakepure saisikerirouna, paiya kireu apimi xiri xonikiewopi kapia xeika nimaririwopi kapia xeika xosikikemu yororei puropi kapia xeika sapauni kisamaira sarepi xuweu kapia xeika apimi tianikinuku asinaku kapia nini xosa kakepi kapia xeika, nei xuiapu ekinikiro asinaku kapia kakiroune paiya nakieni nanuroune sieni kake, ");
INSERT INTO six_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","yoroarani purinuku xipiki xosikikemupo puropi ororepi kapia. Kire tuxotapae muanumu kapia kapia xeseuxatixe. ");
INSERT INTO six_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Kristusu Yesusupo kinipo xokupa xuiapue xipiki xonikikemu xeika xoxi sapire xoniki xumati xiri xonikieuroune xeika tineri na nikitoto xosa wareri nu xumotai. ");
INSERT INTO six_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Xoiteupo Supo Youyae sini ekisikioma siketai, pa xati sini Xoiteupo Supo Youya wetikiri nue sinipo xokupa sesepi taitaiwopina. ");
INSERT INTO six_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Sini aini sikou wenisikini xourorinuku, xoma sarepinerire kireu nikau xoniki xusepuxe, pa xeika kireu apimi nikau xurure ekisikie nepuxe. ");
INSERT INTO six_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Xatai xura, tini xopuropu kire apue xunu eretai sipaukiriai xatia, tini Xoiteupo Supo Youya taikiriai apimie, pa apu peuni tianunari nakenakewari nupo kapia kutuwopina. Pana taki rania atinari sosopa epixakuai. Panumu taki rania Satanie erurutikati xunu xosa uraki xowaku. ");
INSERT INTO six_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Tini kireu tianikinari ninipo xu xemeroa. Panumu kapiae tini Kristusupo tuni kutu tainuku. ");
INSERT INTO six_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Kire apue nanuna nu wenumu xeika xepinana pana, nu wenumu xuweuna paiya, pa apu nu nukoini nuko xoreuna. ");
INSERT INTO six_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Pana xokupa apue nikou saina asinakure xoxiraua atinerini kutu uteiwepineri. Apue panumu kakina paiya, nukoini kaketai kapiaure nimaririna nukou kapia xeika kire apupo kapia xeika uteiwopuwatixe, ");
INSERT INTO six_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","pa amure, xokupa apu kirenikirenie nikoini kaketeneaipo xu xemeropineri. ");
INSERT INTO six_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Apue Xoiteupo kuna uwotai paiya, nue nupo kireu asinkau sapi nukou xesepeu tuwopina. ");
INSERT INTO six_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Tini takieni xoreiyerinari Xoiteu eke tepinuku xinari nanuwaku. Tini itouworakuai xana xuweni kutu. Ne amukau xoye waritiai paiya, panumu xoyeni kutu neu sainoro putawopina. ");
INSERT INTO six_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Kire apue nukou xipiki xoukemupo nanunanu taina paiya, pa xipiki xoukemupo kapia paie xoye xoxi yararatia xiri xoxixepina. Pana nu Xoiteupo Supo Youyapu kapia tainapa, Xoiteupo Supo Youyae paiye pa apu nu xoye asinaku sie yararatia ekeoma sipesisipesi asinaku puropina. ");
INSERT INTO six_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Pa xati sini asinaku kapia kakepure ouyexepuxe. Sini saina tepure ouyeouyexepu xuweunukua, xoye tepu yause xosa paiya sini asinaku xoyeni kutu tepu. ");
INSERT INTO six_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Pa xati amu yause sini kireu apimi xosa asinaku kapia kakepua, sini kakepuni kutu. Kakinuku kireu xuiapue Kokaipaure xonikisuwoteneai xosa sini xiri sokisokinuku nini xosa asinaku kapia kakepu. ");
INSERT INTO six_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Mua kuna masa paiya ye ikoini xayaritiai. Iko xupieni yeyekene kokaipa kokaipa xayautiai. ");
INSERT INTO six_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Iyesa. Pa apimie tinipo muputiki ipisa kakatiwopure sokisokixeteneaie panumu kakineri, pa amure, kireu apimi ekinikiro kokaipa weniniki tuku xepure kakineri. Ninie ximikeri ipaki nanurouneri, “Panumu kireu Yuta apimie sipauneri sini Yesusu Kristusupo na nikitotoure xosikisunuku xineria panumu xoxi kapia kakisikepure xepineri,” xetai. ");
INSERT INTO six_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Yuta nikau kapia tieteneaia nini atineri tuxotapa tairouwori xana xuwe. Pana ninie tinipo muputiki ipisa katiwopure xineria, pa kapia tinipo muputiki xosa kakeneaire nini kokaipa weniniki tepineri. ");
INSERT INTO six_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Pana ye ikou wenimini xourorepinerire e kire apupo wenumu xourorepixe. Xuwe. Ye Kokaipa Yesusu Kristusupo wenumu kireni xourorepine. Nue na nikitoto xosa xumotai xati, paire kireni ye nimaririne. Kristusue na nikitoto xosa kaketai saina paie, mua ouropu kapia paiya yeu nanunanu xosa xuweirotai xati, ye ikoini na nikototo xosa xumuyeutiai xati ye ouropu kapia pani taiwopixe. ");
INSERT INTO six_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Ximine mupusiki ipisa katiwopi kapia paiya aipu sapi, pa xeika apue mupo ipisa katiwopu xuweu kapia rania aipu sapi. Xoiteue kakati sini oma xuiapu saikiriai, pa kapia kireni xiri asinaku sapi. ");
INSERT INTO six_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Xokupa xuiapue pa nanunanu tineri tairouneri paiya Xoiteue nini xouwenikina xoukuruwopina, kakinapa ninipo xonikikemu yororepina. Pa xuiapu kini paiya nini Xoiteupo Israilini kutu. ");
INSERT INTO six_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Ye kire apue xu pani siepi xiraxine. Xuwe. Apimie ouyeneai usi kuru yeu mupi xosa puroteneaie ye Yesusupo saina apuni xina atarina. ");
INSERT INTO six_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Xatai xura, sikou Kokaipa Yesusu Kristusupo xousua kapia xeika xouwesikepi kapia xeikae tini kireni kireni xosa puropina. Pa suau.");
INSERT INTO six_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Ye Polu, ye Kristusu Yesusupo tianuwopi. Nukoe ye xouweyati Xoiteue ye Yesusupo tianuwopi tumuyeretai. Tini Xoiteupo xuiapue Epesesi erewese purinuku Kristusu Yesusu taiwopi menamenaukiriai xosa mua nakau xayaritikine. ");
INSERT INTO six_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Sikou Emisiki Xoiteu xeika Kokaipa Yesusu Kristusu xeikae, tini xonikietikineri xonikikemu tikeria tinipo xotikikemu yoroara puropina. ");
INSERT INTO six_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Sini Xoiteupo wenumu xourorepu, nu sikou Kokaipa Yesusu Kristusupo Omo xeika nukou Xoiteu xeika. Sikou xenisiki tianuwopure, nukoe Yesusu wenumurei mena xouropu xokupa asinaku sapi siketai. ");
INSERT INTO six_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Sini xeseu puropure Xoiteue ou iyarepu xuweu yauseni, sini Kristusu xeika etokepure tumusikeretai. Kakeki xati sini nukou ekero kutu asinaku xu xuweu xuiapu puropu. ");
INSERT INTO six_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Yesusu Kristusue saina tina siko xiyeri tisikepinaure, ekimeni kutu nukoe xouwesikina nukou nononi kutu sayepure tumusikeretai. Xoiteue nukou nanunanuni nimaririeina taina panumu kaketai. ");
INSERT INTO six_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Nukoe pa Nono xiri xouwewotai wenumurei, Xoiteue xiri xouwesikina xoukemu sikeyai. Pa xati nue ere xouwesikina xoukemu siketaire nanunuku Xoiteupo wenumu xourorepu. ");
INSERT INTO six_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Xoiteue xouwesikina xoukemu sikepu kapia xiri xokopexina. Pa xati Kristusue sini xiyeri isayasikepure xumotai xati, nupo yawie sikou xokupa xunu Xoiteue xesauwetai. ");
INSERT INTO six_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Xoiteue xouwesikina xoukemu siketai kapia siko xosa panipani kusauna, xokupa xetaxetau sipa xeika asinaku nanunanu xeika siketai. ");
INSERT INTO six_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Ekime Xoiteue Kristusupo saina xosa mua kapia kakepure nanunanuwoyai. Pana nupo pa nanunanu paiya ximiaki puriyai xati ximine nupo nanunanu itou atarisikina. ");
INSERT INTO six_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Pa sapi kakepure xetaia muanumu. Xokupa sapi taitai xouna xouna, pa yause iyaretai xosa paiya, xokupa sapi mena xouropu xeika ouropu xeika rania Kristusu xosa kununuwopina. Kakatia Kristusue xokupa sapi tapaxi puropina. ");
INSERT INTO six_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Xoiteu nukou xouweni nukou nanunanu taina xokupa sapi kakati marouna, kakina ekime nukou xouweni apimi Kristusu xeika etokinuku nupo xuiapu sayepinukure tumusikereyai. ");
INSERT INTO six_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Sinie akerinuku Kristusure xosikisunuku taikiri, nukou kokaipa memeremu xeika sokisoki xeika xosa sipesi nanunuku nukou wenumu xourorepinukure sini Xoiteue tumusikeretai. ");
INSERT INTO six_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Tini xetau xuiapu kini tinie rania suau kuna iyesieikiriai, paiya pa Xoiteupo asinaku kunae tini xiyeri titiketai. Kakati Kristusure xotikisunuku. Tinie nukou xuiapu kinini kutu purinuku, Kristusu xeika etokari, ekime Xoiteue sokisoki kuna kunawoyai taina Xoiteupo Supo Youya tiketai. ");
INSERT INTO six_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Sini Xoiteupo Supo Youya tieikiriai, pa xati siko sipa, Xoiteue kireu asinaku sapi nukou xokupa xuiapu tinikepure sokisoki kuna kunawoyai sie xurise sini rania tepu. Xoiteue xiyeri tisikati nuko xeika somoni kutu puropu yause xosa pa sapi tepure yakunuku. Kakinuku pa sokisoki saina tixanauwoyaire nanunuku nukou kokaipa wenumu xourorepu. ");
INSERT INTO six_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Tinie Kokaipa Yesusure xotikisunuku Xoiteupo xokupa xuimiapimi xosa xotikikemu tinikirounuku kuna ye iyesitiai. ");
INSERT INTO six_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Pa xati ye kunikuninepa, sipesi tinire nanunanune Xoiteu eiyaseuroune. Kakine ");
INSERT INTO six_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ye Xoiteu kotoutiai, nu Kokaipa Yesusu Kristusupo Xoiteu, nu kokaipa memeremu xeika sokisoki xeika nikau Eminiki. Nue asinaku nanunanu tikatia tinie nukou kuna xotapani kutu sipawari, nukoini kakatia, tini nupo xiri sipawakuai. ");
INSERT INTO six_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Nue tinipo nanunanu xosa memeremu tikepinaure xoiyeune, kakatia tini takuai sapire yaitikatia atinari sipawakuai xine, paiya tinie yaku purikiriai sapire kunaune. Kakinaria Xoiteue sini nukou xuiapu xosa asinaku asinaku sapi iyarerisiketai sipawakuai. ");
INSERT INTO six_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Kakinari ipaki sipaunaria, mua Xoiteupo sokisokie sini nure sipesi xosikisuwopi saina tikiriai xuiapu xosa pani kokaipa saina tina xakuai. Sini nupo sokisoki uteiwopu xana xuweni kutu. Pa Xoiteupo kokaipa sokisoki sini xosa saina tirouna, ");
INSERT INTO six_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","paie sore ekime Kristusu xosa saina tetai. Kristusue xumurati, pa Xoiteupo kokaipa sokisokie sarina mena xouro sou xouna nukou xupo meruira miseretai. ");
INSERT INTO six_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Pa xati Kristusue xokupa xetau xetau yaniyani xouroni kutu puroto, xokupa tumu teu xouro puroto, xokupa kapmani xouro puroto, xokupa sapi sokisoki tuku teu xouro purotouna. Nue xokupa apimi mua yause xosa weniniki tuku xeika sewai yausepu xeika tuku xouro purina. ");
INSERT INTO six_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Xoiteue xokupa sapi Kristusu turo iyarina kawati, nue xokupa sapi tapaxi purati, pa kapiarei nu Yesusure xonikisuwoteneai nikau tumu purina. ");
INSERT INTO six_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Kristusure xonikisuwoteneai apimi paiya nini Kristusupo mupokemu. Kristusue xokupa sapi minika purina xiri xokopexina, nue Yesusure xonikisuwoteneai apimi xosa xokope xetai. ");
INSERT INTO six_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Tinie ekime xonuxonu xonuxonu xunu erari paie outikiati xumurounuku. ");
INSERT INTO six_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Pa yause xosa tinie mua ouropu kapia xoxi xosa texikiniai. Kakinuku mena xouro puroteneai xoxi yaniyani nikau tumupo kapia tinie taikiniai, paiya pa sokisoki yaniyanie Xoiteupo kuna sokau porourouneri xuiapimi nikau kamunikiro xemu saina tina. ");
INSERT INTO six_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Ekime siko xokupae pa apimi kini xeika purinuku, sikou xipiki xosikie xouweurouna xoxi kapia kireni sini taikiriai. Sini pa xipiki xosikie xouweurouna kapia kireni tainuku sikou nanunanue xouwewotai kapia taiwotoukiriai. Sini panumu kaki purikiriai yause xosa panumu xoxi kapia xokupa xuiapue kakeri Xoiteue xoxi yause tinikepure ireyetai sini tiku. ");
INSERT INTO six_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","5","Suau, sikou xoxi kapiae sini ousikiati xumuweikiriai. Sini xiri xumuweteneai apimi sie purinuku. Pana Xoiteue sini xouwesikina xoukemu siketai kapiae xiri koxetai. Nukoe kakati sini Kristusu xeika ekisikioma purinuku. Iyo, Xoiteue sini xouwesikina xoukemu siketai kapia kirenie tini xiyeri titiketai. ");
INSERT INTO six_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Nue Kristusu Yesusu xeika siko saisikeretai. Nue mena xouro nukou kokemu sai xosa Kristusu xeika miseisikeretai. ");
INSERT INTO six_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Kristusu Yesusupo saina paie kakati nue mua asinaku kapia siko xosa kaketai, pa amure, xurise xokupa yause xosa xokupa apimi nukoe xiri xouwenikina xoukemu tiniketai kapia atarinikepurexina. ");
INSERT INTO six_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Tinie Kristusure xotikisuxari, Xoiteue tini xouwetikina xoukemu tiketai kapia kirenie, Xoiteue tini xiyeri titiketai. Paiya tini takieni kakikiriai sapixe. Xuwe. Xoiteue tini aini tiketai. ");
INSERT INTO six_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Paiya tini saina tinuku xe tikiriai sie xuwe. Pa xati kire apue nukou wenumuni xourorepuwatixe. ");
INSERT INTO six_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Kristusu Yesusue kakati Xoiteue sini oma xuimiapimi saisikeretai, paiya siko asinaku kapiapu imerei texepure ekimeni Xoiteue ireiyerisikeyai ime. ");
INSERT INTO six_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Tini sipa, Yuta apimie apimi nikau mupuniki ipisa kakirounerie, tini ipaki kakikirouneri, “Nini mupuniki ipisa katiwopu xuweu apimi,” xirouneri. Paiya apimie nikou mupuniki masaureni mamarikaurounerire kunawotai. Paina tini atinari nanuwa, ekime tini xetau xeteneai xuiapu purinuku, ");
INSERT INTO six_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","pa yause xosa Kristusu nutiemu puropu xuwe. Tini Israili kini xeika puropu xuwena kisau purikiniai. Xoiteue Israili xeika sokisoki kuna kunarina nini xeika kuna ouna xoniki tumareyaina tini paiya nini xeika purarixe. Tini mua ouro purinuku, sewai kire asinaku sapi purotai putawopina tini yakuwarixe. Pa xeika tini Xoiteu sipa xuwe. ");
INSERT INTO six_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Ekime tini xetauroni kutu purikiniai. Pana muaiya Kristusupo yawie sotiki koati, Xoiteu nuko nutiemuni kutu purinuku. ");
INSERT INTO six_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Kristusu nukoini kakirouwati sini xosikikururei xirini ati misinuku. Ekime Yuta kinie xetau xeteneai apimi xeika xiwaixirouneri, kakeri pa xiwai kapia paie sepuri sie Yuta kini xeika xetau xeteneai apimi kini xeika purotai. Pana Kristusu nukou mupoini pa sepuri kereuweina pa xiwai kapia xuweiyeina, pa aimore kini kunununikerina kireni kini nikeretai. ");
INSERT INTO six_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Nue Mosesipo tuxotapa xeika xokupa kuna masa xeika nupo kireu xetau tuxotapa xeika xesauwetai. Nue aimore kini kunununikerina, kireni apu sieinikerepure pa kapia kaketai. Nue pa kapia kaketai xati sini xosiki tumaxi purinuku. ");
INSERT INTO six_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Kireni mupoe pa aimore kinie Xoiteu xeika xoniki tumaxi puropinerire na nikitoto xosa xumotai. Kakina ekime puroyai xiwai kapia na nikitoto xosa xumuwetai. ");
INSERT INTO six_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Nue kouna asinaku kuna ipaki uteina, “Tini ximine xotikikemu kirenini pura,” xetai. Nue mua asinaku kuna tini xetauro wese purixanaukiriai apimi kini xosa uteiwotowotai, tomuroni puroteneai xuiapu xosa rania uteiwotai. ");
INSERT INTO six_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Xoiteue wesikitati nukou xosa xouwopure, Kristusue panumu kakati Xoiteupo Youyae sini aimore tutuni tianisiketai. ");
INSERT INTO six_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Muaia tini ou xuweu kamariorio puroteneai apimi siexe. Xuwe. Tini Xoiteupo xuiapu tuku kireni kinipu purinuku. Tini Xoiteupo xuiapuni kutu purinuku. ");
INSERT INTO six_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Tini Xoiteue xuwotai ata sie. Mua atapu xai sie nue sini Yesusupo tianutianuwopi xeika kunatureture xeika waisikereyai. Yesusu Kristusu nuko paiya akereki xaini kutu. ");
INSERT INTO six_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Mua atapu xokupa arawae Kristusu xosa wawaiwoki, kakineri xokupani atineri wawaiwoteneai. Xoiteue pani pa ata xuwati, Xoiteu nukou atani puropinaure pa ata xiri kokaipa xepurexina. ");
INSERT INTO six_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Tini rania Kristusu xosa wawaiwari, Xoiteue nukou kireu xuiapu xeika kununuwati, tini Xoiteupo atani kutu xatia, nuko xeika Xoiteupo Supo Youya xekae pa atoro puropineri. ");
INSERT INTO six_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Xoiteue tini xiri asinakuni kutu saitiketai xati, pa xotapaure sore ye Polu ye kakauya xosa purine pa amure, tini xetau xeteneai xuiapu tianitikepure Kristusu Yesusupo saina tiroune. ");
INSERT INTO six_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Tini xosa rania pa saina kakina xouwetikina xoukemu tiketai sie, yei pa saina tepineure Xoiteue ye xouweina xoukemu sierina tumuyeretaire, tini iyesikiriaixi nanune. ");
INSERT INTO six_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Mua kuna Xoiteue ekime kakeyai kapiaure paiya ximiaki puroyaina pana, Xoiteu nukoini ye xosa yarareyai paiya, ye xayaka xayaka kunauweitiai. ");
INSERT INTO six_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Kristusue ximiarei pa saina tetaire kuna ye xiri sipani kutuna, tinie mua kuna ninaxinaria tini panumu sipawakuai. ");
INSERT INTO six_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Ekime xokupa yause xosa, Xoiteue mua ximiaropu kuna atina uteiwopu xuwe. Pana muaia Xoiteupo Supo Youya xosa, Xoiteue sini Yesusupo tianuwopi xeika Xoiteupo kunatureture xeika xosa atina kuna uteiwotai. ");
INSERT INTO six_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Mua kuna paiya muanumu. Asinaku kuna xosa paie tini xetau xeteneaipo apimi kinie sini xeika kireni kini xinuku kireni mupusiki sainuku. Kakinuku siko xokupae Kristusu Yesusu xosa Xoiteue xokupa sapi akituworisikeyai tirounuku. ");
INSERT INTO six_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Yei mua asinaku kuna uteiwopineure Xoiteue kakati ye saina apu saitiai. Nue ye xouweina xoukemu sierina, nue sokisokiyati pa saina tepineure, nupo sokisoki ye sietai. ");
INSERT INTO six_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Ye paiya Xoiteupo kireu xuiapu irueni kutu purinena pana, nue ye xouweina xoukemu sierina pa saina sietai, paiya xetau xeteneai apimi xosa kuna uteiwopineure. Mua asinaku kuna paiya, asinaku sapi nikau, paiya Kristusu taiwoteneai xuiapue tepineri. Mua xokupa sapi paiya sini apue uteinuku ninaxepu sie xuwe. ");
INSERT INTO six_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Xoiteue xokupa sapi iyarina, ximuximuni nukoe kapia kakepurexeyai nanunanu ximiakereyai. Kakati ekime pa nanunanu sipesi ximiaki purotai. Pana muaia yei nupo nanunanu yarani uteiwopineure saina sietai. ");
INSERT INTO six_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Ekime ximiakereyaina pana, muaia nukoe kakati nukoure xonikisuwoteneai xuiapu putawori, pa kapiarei nupo xokupa xokupa asinaku nanunanu xeika sipa xeika yaraxeri, mena xouropu sokisoki yaniyani xeika tumu xeikae Xoiteupo nanunanu sipawopineri. ");
INSERT INTO six_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Ekimeni Xoiteue mua saina kakepure nanuwoyai xati, ximine sikou Kokaipa Kristusu Yesusupo sainae saina tietai. ");
INSERT INTO six_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Kakati sini Kristusure xosikisunuku, sini ximikiroukirixe. Sini xiri sipa, Kristusu nu Xoiteu xosa putawopu ime. ");
INSERT INTO six_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Pa xati ye ximine tini katikine, tini tianitikepure mua tatau xemetiaire xekepi nanunanuwari, tinipo xotikisu oro koxete. Xuwe. Mua sapi yaraxetaire tini nimaririwa, pa amure, tini Xoiteu xeika ati purakuaire tianitikepina. ");
INSERT INTO six_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Xauwae kakeyai kapiaure nanune nure xoitapa ukurouroune. ");
INSERT INTO six_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Nue xokupa kini mena xouro puroto ouro purotowoteneai nikau Eminiki xati, nukoini nini xokupa weniniketai. ");
INSERT INTO six_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Yei xoitapa ukuroune ipaki kunikunine, Xauwae tini asinaku asinaku sapini kutu tikepure akituworitiketai, pa xati nukou Supo Youya tinipo xotikiro koratia tini xiri sokisokini kutu purakuai xiroune. ");
INSERT INTO six_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Tinipo xotikisue kakatia Kristusue tinipo xotikiro puropina. Kakatia kireu xiri xonikiewopi kapia paie, tinipo xotikikemu tuporo xiri sokisokina paiya ouwe na poru soki tati nae soki tumurouna sie kakatia tini sokisoki tumuwakuai. ");
INSERT INTO six_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","19","Pa xati tinie Xoiteupo xuiapu xeika sokisoki takuai, kakinari Kristusue kireu xiri xouwenikepi kapia paiya, xiri kokaipani kutu xati, tini xokupae atinari sipawakuai, paiya pani xuwau xouna, xouroni kutu xouna, taipa toupaini xouna. Iyo, Kristusue kireu xouwenikepi kapia paiya xokupa sipa xiri emeserinikinana pana, tini nu xiri sipawakuai. Kakinaria xokupa asinaku sapi Xoiteu nuko xosauni koxetai paiya, tini xosa rania koxepineri. ");
INSERT INTO six_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Xoiteupo sokisokieni sikou xosikiro saina tirouna xati, pa sokisokie sikou nanunanu xiri emeserina. Xoiteue xokupa sapi kakepinaure kotourounukua, nini Xoiteupo sokisoki sieni kutu xepuworixe. ");
INSERT INTO six_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Pa xati Yesusure xonikisuwoteneai xuiapue, sipesi sipesi Kristusu Yesusupo wenumurei Xoiteupo wenumu xokupa yause rania xourorepineri. Pa suau. ");
INSERT INTO six_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Ye Polu ye kakauya xosa purine, pa amure, ye Kokaipapu saina tiroune. Xoiteue nukoni kutu taiwakuaire yaitikeyaire ye nanune, pa xati nukoe xouwewotai asinaku kapiarei texakuaire xakumetikepurexine. ");
INSERT INTO six_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Kireu apimi nini Yesusure xonikisuwoteneai irueni kutu tini purinari, asinaku kapia nini xosa kaka. Tini xosa kapia xoreiyereri kakixanari nini xosa kisamairatikexete. Tini kireni kirenie tinipo xotikikemu nini tinikinari ninie tini tiketeneai xu xemeroa. ");
INSERT INTO six_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Xoiteupo Supo Youyae xosikikemu kirenini tumaxi puropu kapia sikati, pa kapiae muri sie taisikerati kireni kinipuere sini purinuku. Pa xati tini pa kapia soki tepure sokisokixa. ");
INSERT INTO six_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Mupusiki kireni tuku, Xoiteupo Supo Youya kireni tuku. Panumu sie tini kireni sapi kireni yakuwakuaire Xoiteue yaitikina, paiya Xoiteue siko xosa kakepurexetai asinaku sapi xousokuwopina. ");
INSERT INTO six_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Kireni Kokaipa kireni purina, xosikisuwopi kapia kireni, Xoiteupo wenumurei ene isepi kireni. ");
INSERT INTO six_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Kireni Xoiteu tuku, nu siko xokupa sikau Emisiki. Nue xokupa xuiapu oronikina, nue xokupa xuiapu xopuro saina tina, xokupa xuiapu xosa purina. ");
INSERT INTO six_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Kristusue kokaipa sokisoki xeika sipa xeika siko siketai xati, panumu sieni Xoiteue siko xokupa kireni kireni xouwesikina xoukemu siketai. ");
INSERT INTO six_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Xoiteupo nakaue ipaki kunauna, “Nue xouroni kutu xouna, kokaipa kakauya apimi kini sonikati nuko xeika xowoteneai. Kakina sokisoki xeika sipa xeika apimi tiniketai,” xetai. ");
INSERT INTO six_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Mua kuna “nu xouro xowotai” paiya Kristusu nu xouro kireni xowopu xuwexi atarisikina. Xuwe. Ximuximua nu ou toupai miniminikani kutu purotai xosa xowotai. ");
INSERT INTO six_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Pa apue ximuximu ou minika xowotaieni, xouro rania xowotai. Nue xokupa sapi inainawopure, xokupa mena xouroni kutu xowotai. ");
INSERT INTO six_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Nue sore muanumu sokisoki xeika sipa xeika siketai. Kireu apimi xosa paiya Yesusupo tianutianuwopi saina tiniketai. Kireu apimi xosa paiya kunatureture saina tiniketai. Kireu xosa paiya xuiapu xosa asinaku kuna uteiwopineri saina tiniketai. Kireu xosa paiya yayakunikepi saina tinikete Xoiteue xouwewotai kapia xuiapu taitainikepineri saina tiniketewotai. ");
INSERT INTO six_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Sini Xoiteupo xuiapue nukou asinaku saina tepuxati Kristusue sokisoki xeika sipa xeika tianisikepure siketai. Pa xati Kristusupo mupokemu sokisoki xinapa ati puropina. ");
INSERT INTO six_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Mua sainae xowoki xowoki wati xosikisukiri paie kakatia, sini xiri xosikikemu tumaxi purinuku siko xokupani Xoiteupo Nono sipawopu. Kakinuku Yesusure xosikisunuku sokisokixinukua Kristusu nuko sieni asinaku kapia tepu. ");
INSERT INTO six_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Sini nono misiarara sie pani puropuxe, pa xakuxakutua nikau kuna paiya nini xoreixepineri xokupa kapia xiri sipani kutu, paie kakati xupeu xeika xasi xeikae sini xosa sokau porourouna sie porosikepuwatixe, ousoe xasi ukauro kamariorio tiririkixanauna xowopurexetai wese xowopu xuweurouna sie xuwe. ");
INSERT INTO six_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Sini panumu kuna xosa xakusiki iyarepuxe. Xuwe. Sini kireu xiri xonikiewopi kapia tainuku nini xosa suau kuna kireni kunawopu. Kakinuku sokisoki xuiapu sainuku, siko tapusiki Kristusu xeika xiri lixepu, ");
INSERT INTO six_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","nue kakati sikou mupusikipo xokupa xupusiki siasiki ekisiki paiya nukoe siko kireni kireni saina siketai xati asinaku saina tirounuku. Nue kakati siko xokupa xosikitapapu tunie xiri kiritinuku kireu xatasikimana xosikienikepi kapia tairouna, pa kapia paie kakati mupusiki kokaipaxina sokisokixirouna. ");
INSERT INTO six_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Pa xati ye tini xosa kire kuna kunawopure xine. Kokaipapu wenumurei ye ipaki sokisoki kuna kunaune, tini xukumi nikau kapia xosa pani texaku. Ninipo nanunanu paiya turutaruwati, ");
INSERT INTO six_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ninipo sipa paiya ukumu sie xina. Nini sipa xiri xuwe xati, xonikikemu kitiere, pa xati nini Xoiteupo misepirei purorixe. ");
INSERT INTO six_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Nini xoxixoxi kapia kakerineri paire mayaxirouworixe. Nini ayaka kapia kamatupo xosa maneri, xoxixoxi kapia kakepure xonikemu sana. ");
INSERT INTO six_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","21","Tini Kristusupo kuna iyesari, Yesusu xosa purotai suau kuna taitaitiketeneaixi nanune. Paina ye sipa, tinie pa xukumi nikau kapia xoxi kakakuaire taitaitikepu xuwe. ");
INSERT INTO six_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Tini rania ekime xipiki xotikikemupo kapia xosa texikiniai, paiya xoreiyeri xosiki saroati xoxi kapia kakepi xotapa, pa kapiae apu xoxixepina ime yatawotai. Pana ximine tini mua xipiki kapia kakepi xotapa xesauwari, ");
INSERT INTO six_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","tinipo nanunanu oma xepina. ");
INSERT INTO six_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Tini oma xuiapu saya, paiya Xoiteu nukoini kakati oma xuiapu saineri Xoiteu nuko sieni purineri, pa amure, Xoiteu nuko ekero ninipo kapia paiya xiri teteiwoki xoseini kutu. ");
INSERT INTO six_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Pa xati tini xoreixepi kapia weta. Tini xokupae kireu xuiapu Yesusure xonikisuwoteneai xosa suau kuna kireni kunawa, pa amure, siko xokupa paiya kireni mupusikipo masa purinuku. ");
INSERT INTO six_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Tini kisamairatikatia, tini sosopa epixakuai. Panumu tini xunu eraku. Panumu tini kisamaira xosa purariporoni asau munoxete. ");
INSERT INTO six_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Panumu tini Satanipo isima taiyaku. ");
INSERT INTO six_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Petuae pani pexeni. Xuwe. Nini mua saina ati tineri, xokupa sapi tineria, kireu apimi xuru xuweu puroteneai tianikepineri. ");
INSERT INTO six_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Tini kakixanari xoxixoxi ninia tinipo suputikerei wetari koxete. Xuwe. Apimi irerewoteneai sokisokinikepure, asinaku kuna kireni kopina. Muanumu kuna paie kuna iyeseteneai apimi xosa Xoiteue xouwesikina xoukemu sikirouna kapia kopina. ");
INSERT INTO six_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Tinie Xoiteupo Supo Youya kakixari xoukemu tutumuriwaku. Xoiteu nukou xuiapuni kutu purakuaire yekutikina Xoiteupo Supo Youya tiketai, kakina xiyeri sotikati somoni kutu purakuai yause ataritikepurexina. ");
INSERT INTO six_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Tini xokupa xotikikemu xoxixoxixepi kapia wetinari, makawopi wetinari, kisamaira wetinari, xatiki kopuwopi wetinari, pire wetinari, xokupa kapia xoxi weta. ");
INSERT INTO six_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Tinie Yesusure xonikisuwoteneai xuiapu xotikikemu tinikinari nini xosa asinaku kapia kakinari, takitaki tianuwataxa. Xoiteue Kristusu wenumurei tinipo xunu wetetai sie, tinie ninipo xunu wetakuai. ");
INSERT INTO six_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Xoiteue tini xiri xouwetikirouna xati, tini nupo nono purinuku. Pa xati nukoe kakirouna kapiani tini taiwa. ");
INSERT INTO six_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Kristusue siko xiri xouwesikina tianisikepure nukou ekeomani siketai. Nue Xoiteu xosa xouiwori asinaku xurituku sapie somu xuri pukaurouna sie nukou ekeoma Xoiteu tuwotai. Pa xati tinie kireu xiri xoutikieninikepi kapiani kuturei texa. ");
INSERT INTO six_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Tini kakixanari ayaka ayaka kapia kakinari xokupa xoxixoxi xunu kapia kakinari, kireu apimi nikau sapire ekitikie netewaku. Pa xoxixoxi kapiapu kuna rania tini xopuro xayaka xayaka moxete. Tinie panumu kapia kakinari ime taiyaria xuiapue tini kuna xosatiki suwopineri. ");
INSERT INTO six_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Tini kakixanari xunu kuna kunaunari nanana kuna kunaunari neraunari ninia kuna kunawaku. Sini panumu kapia xoxi kakepuxe. Xuwe. Xoiteu xosa kireni eiyase kuna kunawa. ");
INSERT INTO six_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Tini panumu atinari sipawa, ayaka kapia kakineri xunu kapia kakepineri xuiapu xeika ekinikie sapi nirouneri xuiapu xeika nini xorei xoiteu xosa muris tepi sie kapia kakineri, nini panumu xuiapu kinia nini Kristusuno Xoiteunoe xuiapu yakunikepineri yause xosa manepuworixe. ");
INSERT INTO six_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Tini sosopa epixa, apimie purutikeri pa xoxi kapia xona kakakuaire katikeri ninipo inainaropu aipu kuna xoxi taiwaku. Panumu kapia sore kakeri Xoiteue xasese maneteneai apimi xosa kisamairauna. ");
INSERT INTO six_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Pa xati tini panumu apimi xeika kakixanari lixaku. ");
INSERT INTO six_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Tini ekime ukumu xosa purikiniai, pana muaia Kokaipae memeremu xosa iyaitikeretai. Pa xati tini memeremu xosaupo xuiapu sie xosa texa. ");
INSERT INTO six_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Memeremu paie xokupa asinaku kapia xeika kutu asinaku kapia xeika suau kunapu kapia xeika yararirouna. ");
INSERT INTO six_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Tini Kokaipae xouweurouna kapia sipawopure xaute sokisokixa. ");
INSERT INTO six_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Tini ukumu xosaupo kapia kakirouneri apimi xeika lixaku. Panumu kapiae asinaku xoye erirouwatixe. Xuwe. Xeuxana, tinie apimi panumu atarinikinari, muanumu kapia xoxi nika. ");
INSERT INTO six_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ninie ximiakineri kakirouneri kapiaure ye kunawopure xuwe. Ye panumu kapiaure kunawopinepa ye mayaxine. ");
INSERT INTO six_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Pana memeremue xokupa kapia xotapa yararatia yarani purirouneri. ");
INSERT INTO six_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Memeremue kakati kire sapi yarani puratia, pa sapi rania memeremu siexina. Pa xati mua kuna purina, “Apu ne mua xinitiaia, ne sarouwo. Ne kopa upurei saroaua Kristusue ne memeremu tinepina,” xetai. ");
INSERT INTO six_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Pa xati tini sesepi texinaria tini sosopani epixakuai. Tini nanana xinari sipa xuweu apue teiyewaku. Xuwe. Tini sipa tuku apue teiyewa. ");
INSERT INTO six_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Tini Xoiteupo kapia kakakuai yause muai. Pana sini mua yause xosa purikiriai paiya xoxi yause, pa xati sosopa xakuai, panumu mau yause aini xuwexete. ");
INSERT INTO six_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Tini kakixanari nanana kapia kakaku. Xuwe. Tini Xoiteue xouwewotai nanunanu atinari sipawakuai. ");
INSERT INTO six_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Tini kakixanari xisa ere ninari nanana xaku. Xuwe. Panumu kapiae tini xoxirounuku. Tini Xoiteupo Youya wetari tini xosa koxepina. ");
INSERT INTO six_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","TiniXoiteupo kireu xuiapu xeika kunaunari paiya, siri Siri Nakau xosa puroteneai kuna tete muris tepupo kireu siri tete, Xoiteupo Supo Youyae xotikiro saretai siri teteunari, tinipo kuna xosa iyara. Kakinari tinipo suputikirei xeika xotikirei xeika rania, tini Kokaipaure siri wawaiwa. ");
INSERT INTO six_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Kakinari sikou Kokaipa Yesusu Kristusupo wenumurei, tini sipesi xokupa sapire Xauwa Xoiteu eiyasewa. ");
INSERT INTO six_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Tini Kristusu sinipo Kokaipaxi nanunari, tini kireni kirenie Xoiteupo kireu xuiapu irue pura. ");
INSERT INTO six_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Tini xuia, tini Kokaipa irue purikiriai sie takipo xamutikimana irue pura. ");
INSERT INTO six_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Pa amure, Kristusue nukoure xonikisuwoteneai nikau tumu sie, apue nupo xui tapaxina. Yesusure xonikisuwoteneaia Kristusupo mupokemu xati, Kristusue xiyeri sowotai. ");
INSERT INTO six_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Yesusure xonikisuwoteneaia Kristusu irue purineri. Panumu sie tini xui rania, xokupa yause tinipo xamutikimana irue pura. ");
INSERT INTO six_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Kristusue nukoure xonisuwoteneai tianikepure xiri xouwenikina nupo ekeoma wetetai sie, tini apue rania tinipo xui xiri xotikienika. ");
INSERT INTO six_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Nukou ene xeika kuna xeika xosa Kristusue nikoure xonikisuwoteneai ene iserinikati nupo ekero asinaku teteiwoteneai. Panumu kapiae nukoe Yesusure xonikisuwoteneai ikou xetai. ");
INSERT INTO six_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Nukoe nukou ekeroni kutu Yesusure xonikisuwoteneai xuiapu atinikati xiri xoseiyeri, panumu xunu xeika kesi xeika tukuxepuwatixe. Xuwe. Yesusure xonikisuwoteneai paiya xu xuweu xeseu puropineri. ");
INSERT INTO six_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Panumu sie tini apu tini takipo muputikini xotikieukiriai sie, tini takipo xuimi xotikienika. Apue nukou xui xiri xouwewotai paiya, nu nukoini nuko xiri xouweuna. ");
INSERT INTO six_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Siko sipa, kire apue nukou mupokemuni xiwairouwatixe. Xuwe. Nu xoye tuna ati yakurouna. Kristusue nukoure xonikisuwoteneai xuiapu yakunikirouna sie, ");
INSERT INTO six_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","pa amure, siko paiya Kristusupo mupokemupo siau xeika xupo xeika ekekemu xeika sie. ");
INSERT INTO six_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Xoiteupo nakaue ipaki kunauna, “Pa xati apue omo ana wetina nupo xui xeika lixirouna, kakina nini kireni mupuniki sairouneri,” xetai. ");
INSERT INTO six_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Mua ximiaropu kuna paiya nu kokaipa nanunanu tuku. Ye ikoni nanune, paiya Kristusu xeika nukoure xonikisuwoteneai xuiapu xeikaure kunaunaxine. ");
INSERT INTO six_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Pana mua kunae rania kunauna tini apu kireni kirenie takire xirounuku sieni tinipo xui xiri xotikienika. Xui paiya nupo xamu irue purina ati yakuwopina. ");
INSERT INTO six_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Tini nonomi, Xoiteue xouweiwotai kapia tinie emitikimana xeika anitikimana xeika nikau kunani kutu taiwa. Tini panumu kapia kakinaria, tini asinaku kapia kakinuku. ");
INSERT INTO six_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Xoiteupo nakaue ipaki kunauna, “Ne eminianinipo kuna tainau nini irue puro,” xetai. Mua tuxotapa paiya akereki tuxotapa sokisoki kuna xeika purina, ");
INSERT INTO six_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","paiya sokisoki kunae ipaki kunauna, “Ne panumu kakinaua, xokupa saina sie kakitiai asinaku xatia, ne mua ouro xuwau yause purowai,” xetai. ");
INSERT INTO six_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Tini eminikimana, tini kakixanari niretikimana nikau nanunanu xoxixoxiwaku. Panumu nini kisamairanikexete. Xuwe. Tini Kokaipa ekero asinaku kapia kakinari, tinipo nono atinari kutunikinari Xoiteupo kuna xosa taitainika. ");
INSERT INTO six_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Tini aipu saina xuimiapimi, tinie tinipo saina yayaku kokaipaure nanunari ninipo kuna taiwa. Tini kakixanari xoreire pa kapia kakaku. Xuwe. Tini Kristusupo kuna iyesinuku tairounuku sieni ninipo kuna xiri taiwakuai. ");
INSERT INTO six_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Ninie tini nutietiki purori ai niraniranikinari ekiniki tepure nanuwori asinaku saina taku. Pa xuwe. Tinie ipaki nanunaria sini Kristusupo aipu saina apuni purinukuxinari, Xoiteupo nanunanu taiwopure xotikikemu nimaririwa. ");
INSERT INTO six_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Pa xati tini xotikikemu nimaririrei saina ta. Tini apu nikau saina tarixe. Xuwe. Tini Kokaipa nukou sainani tinuku. ");
INSERT INTO six_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Tini nanuwa. Kire apu nu aipu saina apure e nu somo purotaie asinaku saina tatia, Kokaipae nu asinaku xe tuwopina. ");
INSERT INTO six_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Tini saina yayuku teu, tinie rania tinipo aipu saina apimi xosa asinaku kapia kaka. Tinie nini ximikepineri kapia kakaku. Mena xouro purotai Kokaipa paiya nu tinipo Kokaipa nini rania ninipo Kokaipa, nu kireni kapiareini xokupa xuiapu nikau kapia uteirouna. ");
INSERT INTO six_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Paina muaia yeu kuna ipaki xuweiyepure xine, tini Kokaipa xeika lixikiriai, pa xati tini nupo xokupa kokaipa sokisokire nanunari tini sokisoki tumuwa. ");
INSERT INTO six_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Tini Xoiteue xokupa xomapu nekei sikirouna nekei nekeiyerinari, sokisoki tumunaria Satanie ximiakina kakirouna xokupa xoreixorei kapia sokau porowakuai. ");
INSERT INTO six_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Atinari nanuwa, sini xuiapu xeika waraxiroukirixe. Xuwe. Sini xokupa tumu teu xouro puroteneai xeika, kokaipa weniniki tuku yaniyani xeika, xokupa sapi sokisoki xeika waraxinuku, ninie ukumupo yause xosa ou yakurouneri. Pa xeika xokupa sokisoki xoxixoxi yaniyani xouro puroteneai xeika rania sini waraxinuku. ");
INSERT INTO six_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Pa xati tini Xoiteue xokupa xuiapu xoma xakuai nekei tikirouna tinari xoxi yause xosa tini sokisoki tumunari xoma xakuai. Kakinari xoma xuwexatia, tini sokisoki tumunaria purakuai. ");
INSERT INTO six_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Tini sokisoki tumuwopurexinari paiya suau kuna tinipo kikai sie takerinari, kutu asinaku kapiae marimasa sokisoki sie tototikiro ererari xotorepina, ");
INSERT INTO six_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","kakinari Xoiteupo xuiapu xonikikemu tumaxepurexetaire asinaku kuna uteinari ireinaria, tinipo erieri sie pa kapia erera. ");
INSERT INTO six_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Tini pa xokupa xomaxakuai sapi tinari, xotikisuwopi kapia rania, kupira masa sie sokisoki tinari paiya, pa apu xoxi Satanie xokupa xepi xori piti xati tini xosa kourouna xukuwakuai. ");
INSERT INTO six_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Tini Xoiteue xiyeri titiketaire nanunanuwari, pa nanunanue koike kapa kuroreki sie xepina. Kakinari Xoiteupo Supo Youyapu saripripiri nu Xoiteupo kuna takuai. ");
INSERT INTO six_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Tini sipesi Xoiteupo Supo Youyapu sokisokirei kunikuniwa. Kakinari Xoiteue tianitikepinaure nu kotounari xonuxonu kunikuni kunikuniwa. Tini sipesi sosopa epinari tini panumu kapia wetakuaixe. Tini kakixanari arikaku. Xoiteue nupo xokupa xuiapu tianikepinaure tini sipesi kunikuninari Xoiteu kotowakuai. ");
INSERT INTO six_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Kakinari ye rania Xoiteu kotounari tianiya. Tini panumu kakinari kunikuniwaria, Xoiteue yeu supiro kuna iyaratia ye ximikepi wetinei asinaku kunapu ximiaropu kuna xiri uteiwopine. ");
INSERT INTO six_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Yei mua asinaku kuna uteiwopineure Xoiteu nukoini xesayati xoutiai xati, ye pa xotapaure kakauya xosa purine. Ye kuna uteiwopine saina tuku, pa xati tinie Xoiteu xosa kunikuniwari ye sokisoki yatia ximikepi wetinei xuiapu xosa sokisoki kunawopine. ");
INSERT INTO six_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Yei xokupa saina titiaire Tikikusie tini xakumetikepina. Tikikusi nu sikou xatasikini kutu, nu Kokaipapu asinaku saina apuni kutu. ");
INSERT INTO six_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Sinipo puropi purikiriai tini sipawakuaire, yei tini xosa nu xesauti utuna, nu utuna paiya tinipo xotikikemu sokisokiwopina. ");
INSERT INTO six_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Xoiteu Emisiki xeika Kokaipa Yesusu Kristusu xeikae tini xatasikimana tikau xotikikemu yorowatia kuruwopina, nue kakatia tini sokisoki xotikisunaria kireu apimi xotikienikakuai. ");
INSERT INTO six_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Xokupa apue sikou Kokaipa Yesusu Kristusu xiri xonikiewopi kapia wetepu xuweurouneri paiya, Xoiteue nini xosa xouwenikina xousuaxepi kapia kakepina.");
INSERT INTO six_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Sini Poluno Timotino, sini Kristusu Yesusupo saina apimi, sinie tini Yesusu Kristusupo xokupa xuiapu erewese Pilipai purikiriai xeika tini yayakutua xeika tini saina apimi xeika xosa mua nakau xayaritikinuku. ");
INSERT INTO six_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Sikou Emisiki Xoiteu xeika, Kokaipa Yesusu Kristusu xeikae tinire xousuaxati xouwetikatia, tini xotiki kurunari purakuai. ");
INSERT INTO six_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Ye xokupa yause tinire nanunanune paiya, yeu Xoiteu xosa eiyaseuroune. ");
INSERT INTO six_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Tini tianitikepure xokupa kunikuni kunikunixine paiya, ye sipesi nimaririne kunikuniroune. ");
INSERT INTO six_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Ye tinire nimaririroune, pa amure, tinie asinaku kuna uteiwopi saina xosa sini xeika lixinuku ximuximuni saina tipa kounuku kounuku mua yause xinuku. ");
INSERT INTO six_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Ye panumu sipauweitiai, Xoiteu nukoini tini xosa asinaku saina sareyai xati, saina tixouna xounapa Kristusu Yesusupo Asau xosa pa saina xuweiyepina. ");
INSERT INTO six_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Tini yeu xoikemu tuporo purinuku, pa xati ye tinire mua asinaku nanunanu tuku xitiaia asinaku. Ye kakauya xosa puritire e ye asinaku kuna tianune sokisokiwopi saina titi rania Xoiteu nukoe yeure xousuaxati xouweina sietai saina xosa tini xokupae ye xeika lixinuku saina tikiriai. ");
INSERT INTO six_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Xoiteu nu muanumu sipa, Kristusu Yesusu nukou xousuae kakati ye saiyerati tini xokupa xeketikepure xiri xoieune. ");
INSERT INTO six_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Ye sipesi ipakine kunikunine, tinipo ekitikioma xosa paiya kireu xotikienikepi kapiae xiri sokisoki xati, tini xokupa sipa tuku xaria, tinipo nanunanu xiri teteiwopinaxi kunikuniroune. ");
INSERT INTO six_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Kakatia tinie xokupa kapia atinari uteinaria asinaku kapiani kutu takuai. Kakaria Kristusue xuiapu kuna xosa iyainikerepina Asau xosa, tini xiri xoseini kutu kire xu tuku purakuaixe. ");
INSERT INTO six_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Kakaria Yesusu Kristusue kapia kutu asinaku yararirounae tini xosa xiri koxepina. Kakati xuiapue xekerineri Xoiteu kokaipa wenumu tuneria nupo wenumu xourorepineri. ");
INSERT INTO six_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Xatai xura, tini sipawakuaire ye kunaune, mua kapia ye xosai akipa xetai paiya, asinaku kuna parawatixe. Xuwe. Paie kakati asinaku kuna sokisoki xina. ");
INSERT INTO six_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Pa xati Sisaripo ata yakuwopineri xokupa xomatua kini xeika kireu apimi xokupa xeikae rania, ye kakauya xosa nikoe iyaiyereteneai nini sipa, pa amure, ye Kristusupo saina tine. ");
INSERT INTO six_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Kakiti xataimana nikau kokaipa apimi kinie, ye kakauya xosa puriti nanuworineri, paie ninipo xonikikemu sokisoki xati Kokaipa xosa sokisoki xonikisuneri. Kakineri ximikepi xuweu pani sokisoki xineri Xoiteupo kuna uteineri. ");
INSERT INTO six_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Suau, kireue xekoria apimie yeu wenimi xouroreri, paire xonikikemu tatauwati, yeu wenimi xororepure xeteneai, pa xotaparei sore ninie Kristusupo kuna uteiwoteneai. Pana kireua nini asinaku nanunanu tuku xati kuna uteiwoteneai. ");
INSERT INTO six_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Pa apimi nini sipa, ye asinaku kunapu saina sokisokiwopure kakauya xosa purine, pa xati yeure xiri xonikieineri kuna uteineri. ");
INSERT INTO six_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Pana kireu apimi paiya nikou weninikini xourorepure, Kristusupo kuna uteineri. Nini nanunanu asinaku kutu tukue kakerixe. Xuwe. Ye kakauya xosa puritia kireu xu pani xosai soxepure kakineri. ");
INSERT INTO six_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Pana nini asinaku nanunanu tukure e xoxi tuku rania, pa xokupa apimie Kristusupo kuna uteirouneri xati, paie kakati yeu xoikemu xiri nimaririna. ");
INSERT INTO six_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Ye pani nimaririwopine, pa amure, ye sipa, Xoiteue tianiyepinaure tinie sipesi kunikunirounuku xati, Yesusu Kristusupo Youyae ye sokisokirouwatia, pa imerei Xoiteue tianiyati ye kakauya wetinei somo puropine. ");
INSERT INTO six_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Pa xati yei kire kapia xoxi kakerinei maya tepi xiraxine. Xuwe. Ye xokupa yause kakiroune sie, ximine xeika sewai xeika rania ye sokisokini kutu tumuneia asinaku asinaku kapia kireni kakepinexi nanune. Kakinei ekioma puropinere e xumutia, ye xokupa kapia kakitiaie Kristusu kokaipa wenumu tuwopina. ");
INSERT INTO six_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Yeu nanunanu paiya muanumu. Ye ekioma purineia, ye Kristusu xeika purine. Ye xumunei paiya, ye asinaku sapini kutu tepine. ");
INSERT INTO six_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Ye pani ekioma purineia, ye xokupa xuiapu tianikepine sie itou. Pana ye amu imerau taiwopine? Ye sipa xuwe. ");
INSERT INTO six_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Ye paire aimore xoikemu tuku. Ye xounei Kristusu xeika puropineure ye xiri xoieune. Paiya xiri asinakuni kutu xepina. ");
INSERT INTO six_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Pana ye tini tianitikepineure, pani ouro puropinerau. ");
INSERT INTO six_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Panumu xati, ye sipa, ye xumopi xana xuwena, ye tini xeika puropine. Ye tini xeika puritia, tinipo xotikisue xiri sokisokina pani kokaipa xatia, tini nimaririwakauai. ");
INSERT INTO six_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Pa xati ye xiyeri kounei tini xosa putautia, tinie yeure nimaririnaria Kristusu Yesusupo wenumu xourorakuai. ");
INSERT INTO six_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Kokaipa sapi paiya, muai. Tinipo sesepi paiya kutuni asinaku purinari Kristusupo asinaku kunani kutu taiwakuai. Kakari ye kounei xeketikinere e tinire kuna kireni iyesine rania ye xemu sipauneia tini sokisoki tumunuku kireni xotikikemu purinuku, kireni nanunanu xeika asinaku kuna xeika xosa xonikisuwoteneai xuiapu sainikepure xirini saina tinukuxi sipawopine. ");
INSERT INTO six_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Tini kakixanari tinipo xiwaiyatikimanaure ximikaku. Tini xeketikeri ximikepu xuweuwaria, sini xuwexepinuku xineria, sipawopineri, pana Xoiteu nukoini kakatia tini xiri atinari purakuai. ");
INSERT INTO six_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Iyesa. Xoiteue tini atitikerina weitikitati tinie Kristusupo saina tinuku. Nue weitikitati Kristusu xosa kireni xotikisuwarixe. Xuwe. Tini weitikitati nukou wenumure xeika tatau xemenuku. ");
INSERT INTO six_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Ekime tinie xekeyari ye xomai puritiai xoma xosa xomaxitiai, muaia ye pani xomai puriti yeu kuna tini iyesinuku. Paina tini tatau xemekiriai, pa amure, tini ye xeika lixinuku pa xoma xosa purinuku. ");
INSERT INTO six_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Kristusue tinipo xotikikemu sokisokirounare? Nue tini xiri xouwetikirouna xati paie kakati tinipo xotikikemu yoro purinare? Tini Xoiteupo Supo Youyapu ekeoma minika xosa purinukure? Tini kireu apimi xosa xotikisua xati xotikisuarei xotikienikirounukure? ");
INSERT INTO six_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Panumu xatia, paina tini asinaku asinaku kapia kakari, yeu nimariri paie xiri koxepina. Tini xokupae kireni nanunanuni kutu tinari kireu apimi xotikiewopi kapia kireni taiwa. Kakinari kireni xotikikemuni kutu pura. ");
INSERT INTO six_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Tini kakixanari takireni nanunanunari, takipo wenitiki xourorepi saina kireni taku. Xuwe. Tini takipo kapia ororinari, kireu apimi nikau kapiae sinipo kapia emeserinaxi nanuwa. ");
INSERT INTO six_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Tini takipo xuru kireni yakuwaku. Xuwe. Tini kireni kirenie takipo kireu xuiapu nikau xuru yakunari tianikari ati puropineri. ");
INSERT INTO six_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Kristusu Yesusu nukoe tipuroyai nanunanu sieni tini panumu nanunanuni kutu tipura. ");
INSERT INTO six_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Nu Xoiteuni kutu purotaina pana, nu Xoiteu sie puropure pa kapia soki tepure nanuwotaixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Nu pa kapia wetina nu aipu saina apu sie sayetai. Nu apu sie putauna, ");
INSERT INTO six_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","apuni kutu purati apimie xekoteneai. Kakina nukoini nuko ororina Xoiteupo kuna taipa xouna xumotai yause xetai, iyo, kakipa xouna na nikitoto xosa xumotai. ");
INSERT INTO six_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Pa xotaparei sore Xoiteue Yesusu xourorina xiri xouroni kutu iyarati purina. Kakina Xoiteue kireu kireu weniniki emeserinikina kire wenumu xouroni kutu tuwotai. ");
INSERT INTO six_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Nue pa wenumu Yesusu tuwotai xati, xokupa sapie mena xouro puroto ouro puroto ou minika puroto woteneai sapi xeikae Yesusu xekero xonikitapa urukurouneri nu irue puropineri. ");
INSERT INTO six_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Kakati nini xokupae ipaki kunauneria, “Yesusu Kristusu nu Kokaipa,” xepineri. Pa kapiarei Xoiteu Emisiki kokaipa wenumu tuwopineri. ");
INSERT INTO six_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Paina, yeu xatai xura ye tinire xoi xumuna, tinie yeu kuna sipesi tairounuku xati, ximine rania panumu kaka. Ye tini xeika puritia pa yause xosa kireni kuna taiwaku. Xuwe. Ximine ye xetauro purinena, tini atinarini kutu kuna taiwa. Xoiteue tini xiyeri titiketai xati, muaiya tini urewoto ximiketeunari pa xotiki iwopure xetai sapini kutu takuaire sokisoki saina ta. ");
INSERT INTO six_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Siko sipa, Xoiteu nukoe tinipo xotikiro saina tirouna. Nukoini xouwewotai kapia tinie kakakuaire tinipo xotikikemu sarirouna. ");
INSERT INTO six_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Tini xokupa kapia kakinaria, tini peuni purinari kaka. Tini kakixanari xekepi kunaunari kuna tuwataxaku. ");
INSERT INTO six_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","16","Tini Xoiteupo nonoe panumu kakinaria, tini ati purinari xoxixoxi kapia xuweu xu xuweu purakuai. Kakinari ekeoma tuku kuna soki tinaria, mua ouropu xuiapu xopu memeremu sie purakuai. Pa xuiapu kinie asinaku kapiani kutu wetineri xoxixoxi kapia kaketeneai. Pa xati Kristusue xiyeri kopina yause xosa yei tinipo kapiaure xiri nimaririwopine. Kakine sipauneia, yei tini xopu irereiyai saina paiya, ye aini kakepu xuwexi sipawopine. ");
INSERT INTO six_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Tinipo xotikisu paiya tini Xoiteu xouieunuku. Ye panumu sipaunei xisae xoniki irouneri sie yeu yawi xeika tinie Xoiteu xouikiriai kapia xeika kusaworia ye paire nimaririwopine. Ye tini xeika nimaririwopine. ");
INSERT INTO six_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Panumu sie tini rania nimaririwakuai. Tini ye xeika xiri nimaririwakuai. ");
INSERT INTO six_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Kokaipa Yesusupo nanunanu xatia, tini xosa Timoti xesawopure xenenewopixe. Nue xiyeri kouna tinire kayatia, ye xiri xoi meruxepine. ");
INSERT INTO six_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Timoti sie apua kire yue ye xeika puratixana xuwe. Nu sipesi ye xeika lixina tini tianitikepure nanunanuna ime xirekirouna. ");
INSERT INTO six_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Xokupa kireu apimie nikou xurureni eiyo xineri, Yesusu Kristusupo saina pani tipa xowopi nini xiraxirouneri. ");
INSERT INTO six_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Pana Timotipo asinaku kapia tini sipa. Tini sipa, nonoe omo tianurouna sie nue asinaku kunapu saina tianiyeyai. ");
INSERT INTO six_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Pa xati ye xosai amu kapiarau yaraxepinana ye xayaka xayaka yakune siparineye, xurise tini xosa xesautia sapauni utopina. ");
INSERT INTO six_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Kokaipae ime taiyepinaxi xoisunena, iko rania xayaxayaka xurise kouneia xeketikepine. ");
INSERT INTO six_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Tini xosa Epaprotitusi xesautia utopinaureni kutu ye nanune. Nu sikou xatasiki, nu pa xoma xosaupo saina emei nu liemei, nu takie xesawari ye tianiyepinaure koyai. ");
INSERT INTO six_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Nu tinire xiri eiyoxina xeketikepurexina. Nu supa tuku kuna tinie iyesari, paire nu siparina xoukemu tatauna. ");
INSERT INTO six_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Suwau, ekime xoia supa tina xiri xumopure xetai. Pana Xoiteue nure xousuawati ekemiri kusawetai. Xoiteue nure kireni xousuaxepu xuwe. Yeure rania xousuaxetai, pa amure, kokaipa xuni kutu ye xoroyepi xirarina kaketai. ");
INSERT INTO six_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Pa xati nu xiyeri xekerinari nimaririwakuaire, nu xesautia utopina. Kakineia iko rania ere xoikemu tatauwopuwatixe. ");
INSERT INTO six_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Pa xati tinie Kokaipapu wenumurei Epaprotitusi sowopure xiri nimaririwa. Tini panumu apimi xosa kokaipa weniniki tinika. ");
INSERT INTO six_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Nue Kristusupo saina tina xiri xumopurexetai. Nu nuko asinaku puropinaure nanuwotaixe. Xuwe. Ye tianiyepina saina takie tukiriai xosa kireni nanunanuna, kakina nupo supa sokau porouna pani saina tina. ");
INSERT INTO six_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Xatai xura, ye mua kuna xuweiyepure ipaki kunawopurexine, tini Kokaipaureni kutu nimaririwa. Ye mua kuna tini xosa xiyeri xayawopure ouyexixe. Xuwe. Pa amure, nue tini tianitikepinaxi nanune. ");
INSERT INTO six_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Apimie mamumamu sie saina xoxi tirouneri xosa sosopa epixakuai. Paiya pa apimie nanuneri Israili nikau kapiarei siko xokupa sikau mupusiki xoxixoxiwopuxi kakineri. ");
INSERT INTO six_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Siko kireni Xoiteupo Israili kinini kutu purinuku mupusiki kesewopi kapiani kutu tainuku. Kakinuku Xoiteupo Youyapu sokisokirei sini Xoiteure muris tinuku Yesusu Kristusupo wenumu xourorirounuku. Sini sipa, apimie mupunikire sapi kaketeneai paiya, nini xayakaxayaka tianikepuwatixe. ");
INSERT INTO six_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Iyesa. Mupusikipo sapie sini tianisikepina itou xatia, iko paiya ye atineni kutu puropine. Apimie mupunikiropu kapia xosaniki moati nimaririwoneai paiya yei xiri emeserinikine. ");
INSERT INTO six_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Anikae ye iyaiyerati, 8-teu asau xosa mari takeriyeneai. Ye Israilipo apu. Ye Pensaminipo apu kini. Ye yeu xauwa anika sieni, Ipru kuna kunauroune. Ye Parisi nikau kapiarei tuxotapa atineni kutu tairoune. ");
INSERT INTO six_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Ye Xoiteupo saina tepure xiri sokisokine, pa xati yei ekime Yesusure xonikisuwoteneai xuiapu xosa xoxi kapia kakiyai. Apimie tuxotapapu kunaure nanuworineri yeu kapia uteineria, ye xu xuwe. ");
INSERT INTO six_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Ye kunauweitiai, ye mua mupusikipo kapia kapiapu ime taineia, yei kireu apimi xiri emeserinikepine. Pana ye mua xokupa sapi xekeutia aipu sapi sie xati, ye Kristusupo ime taine. ");
INSERT INTO six_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Ye mua Yuta nikau kapia kirenire kunauixe. Xuwe. Ye Kristusu Yesusu sipa, nu yeu Kokaipa xati, ye pa sapi kireni xekeuia xiri asinakuni kutuna, mua ouropu xokupa asinaku sapi paiya aipu inaina sie. Ye Kristusu kireni taiwopure ye xokupa kireu sapi wetine, Kristusu soki tineia ");
INSERT INTO six_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","nu xeika lixepine. Ye tuxotapa taiwopure ikoini kakitiai kapiae apu kutu asinaku sayepinexi nanuixe. Xuwe. Ye xetau imerei apu kutu asinaku sayepurexine, paiya Kristusu xosa xoisuwopine ime. Sini Kristusure xosikisukiri Xoiteu nukoini wenisikina kutu asinaku xuiapu xirouna. ");
INSERT INTO six_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Ye Kristusu sipawopureni kutuxine. Kristusue kopa upuropu saroyaina, nu kokaipa sokisoki tuku xati, pa nupo sokisoki ye xiri sipawopurexine. Ye tatau xemeropi kapiaure nu xeika lixepurexine. Kakine nue xumuna nanunanu tipuroyai sie ye panumu nanunanu sie tipuropurexine, ");
INSERT INTO six_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","pa xati ye rania kopa upuropu xiyeri saropinexi nanune. ");
INSERT INTO six_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Ye Kristusupo pa kapia tieine, ye apu asinakuni kutu sainexi nanuixe. Xuwe. Pana Kristusu Yesusue soki tiyeyai sie, sipesi yei pa kapia soki tepi saina tine. ");
INSERT INTO six_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Xatai xura, ye nanutiaiya ye pa kapia xemu titixe. Pana ye kire nanunanu tuku kireni, paiya ekimepu xokupa kapia wetinei, pa sapi sewai putawopina tepure sokisoki saina tepine. ");
INSERT INTO six_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Ye atu xosa putaunei asinaku misepi tepineure sokisoki keikei xouroune. Pa asinaku misepi paiya muanumu. Kristusupo saina xosa, ye xouro xounei Xoiteu nuko xeika xiri ati misepineure yaiyetai. ");
INSERT INTO six_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Sinipo nanunanue asinaku sipa tuku apimi nikau nanunanu sie xatia, paina sini xokupae ye mua uteitiai sie nanunanu taiwopu. Tini xetau nanunanu tuku xatia, paina Xoiteue pa tinipo nanunanu kutuworepina. ");
INSERT INTO six_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Pana sini pa asinaku kapia tieikiriaia, sini sokisokini kutu tepu. ");
INSERT INTO six_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Xatai xura, tini xokupae yeu kapiani kutu taiwa. Kakinari pa apimie sinipo kapia tairouneri atinari xekenika. ");
INSERT INTO six_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Pana xousua tuku, xokupa apimie Kristusupo na nikitotopu xiwai purineri. Xokupa yause ninipo kapia paire katikitiai xati, ximine ye xiyeri katikiti, ekirei morepi waxi kiririna. ");
INSERT INTO six_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Nikou mupunikie xonikiewotai kapiani tairouneri xati, pa xonikiewoteneai kapiae ninipo xoiteu sie purina. Ninie sipesi ouropu sapire kireni nanunanurouneri xati, xoxixoxi kapia maya tuku kakepure nimaririrouneri. Pa apimia nini xepi xosa xuwexepineri. ");
INSERT INTO six_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Pana siko paiya, sini mena xouropu xuiapu purinuku. Sini Kokaipa Yesusu Kristusue mena xouro wetina xiyeri kou tisikepinaure yakunuku. ");
INSERT INTO six_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Nukou sokisokireini, Kristusue kakati xokupa sapi nu irue puratia, pa sokisoki kirenie pa xu sikirouna mupusiki pirixepina, kakatia sinipo mupusiki paiya nukou mupokemu sieni xiri xoseini kutu xoseixepina. ");
INSERT INTO six_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Pa xati, yeu xatai xura, ye kunautiai sie, tini Kokaipa xosa sokisokini tumuwa. Yeu xoikemu tini tikiroune xati, tinire ye xoikemu xiri pirixina. Tini paiya yei sokisoki saina tine asinaku sapi tiyai sie xati, tinire ye pani nimaririroune. ");
INSERT INTO six_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Yuotiano Sintikeno, tini iyesaxa. Tini xui axirini Kokaipapu kini xosaupo, pa xati tini kirenini xotikikemuwaxa. ");
INSERT INTO six_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Ne, ne yeu saina emeini kutu, ye ne kanine, ne mua xui aimore tianike. Asinaku kuna uteiwopi saina xosa ninie ye xeika atineri lixeteneai. Klemeni xeika kireu saina emeumana xeikae sini xeika saina teteneai. Pa xokupa kini nikau weniniki paiya ekisikoma puropu nakau xosa purina. ");
INSERT INTO six_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Tini sipesi Kokaipaureni nimaririwa. Ye xiyeri kunaune, tini xiri nimaririwa. ");
INSERT INTO six_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Tinie xokupa apimi peuni peuni nikari ninie tinipo asinaku kapia xekopineri. Nanuwa. Kokaipa kopure tomuroirouna. ");
INSERT INTO six_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Tini kire sapire eiyo xaku. Xuwe. Tinipo xokupa xure sipesi Xoiteu kauna. Tini Xoiteu xosa kunikuninari eiyase kuna kaunari, tianitikepinaure kotowa. ");
INSERT INTO six_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Xoiteue xosiki yoro sini sikirouna paiya, asinaku sapini kutu xati, sini apue paire xotapani kutu sipawopu xana xuwe. Xoiteue kakati tinipo xotikikemu yoroni purinaria, pa kapiae tini Kristusu Yesusu xeika atinari etokaria, tinipo xotikikemu xeika nanunanu xeika atina kutuni puropina. ");
INSERT INTO six_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Xatai xura, ye kire kuna pani kunawopurexine. Tini xokupa yause suau kapia kirenire nanunari, apimie asinaku kapia kaketeneaire nanunari, kutu kapiaure nanunari, asinaku teteiwoki kapiaure nanunari, sapi xoseixoseire nanunari, asinaku asinaku sapini kuture nanunari, xokupa kapia akerekire nanunari, apimie xokupa kapia kakeri siko apue xekeri xiri nimaririrounuku xeikaure nanuwa. ");
INSERT INTO six_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Tini xokupa kapia kakakuaire ye uworitikiyai paiya ati siparinuku, xokupa kapiaure ye kuna uteiti tinie iyesinuku pani kakiti xekeukiriai, pa xokupa kapia tini sipesi kakakuai. Kakaria Xoiteu, nu xosikemu yorowopu kapia xotapa, nue tini xeika puropina. ");
INSERT INTO six_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Tinie ye xiyeri tianiyepure nanunanu tari, ye Kokaipa xosa xiri nimaririne. Suau, ekime tinie ye tianiyepure nanunanukiniaina pana, ye tianiyakuai ime xuwe. ");
INSERT INTO six_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Ye sapiara xuweitauyati mua kuna kunauixe. Xuwe. Ye amu kapiae xosai moatia, ye peuni puropi kapia sipauweitiai. ");
INSERT INTO six_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Ye xiri xauna purinere e ye xokupa sapi tukuxine rania, ye peuni puriroune. Ye xokupa xoye tukure e ye iriapu puropine, ye xokupa sapi tukure e ye sapiara xuweitauyepina rania ye peuni puropi kapia sipauweitiai. Xokupa sapi ye xosai putawopina, pana ye pani peuni purine xoikemu asinaku xiroune. ");
INSERT INTO six_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Kristusue ye sokisokirouna xati, nupo sokisokie ye xokupa sapi kakepine itou. ");
INSERT INTO six_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Ye ipaki kunaune tinie ye tianikiriai kapiaure ye nimaririne xitiaia, pa amure, ye xu xemetiai yause xosa tinie ye xeika lixepure nanuworinuku, mua asinaku kapia kakikiriai. ");
INSERT INTO six_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Tini Pilipaipo xuiapu, takieni sipaukiriai, ye asinaku kuna uteiwopi saina xotapa taiyeine, Mesetonia Propinsi wetitia, kireu Yesusure xonikisurouneri apimie ye xeika lixineri xeara tianineri siepineri kapia xuwexetai. Xuwe. Tini kirenie panumu kakikiriai. ");
INSERT INTO six_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Ye Tesalonaika erewese puriyai yause xosa, tinie xayaka xayaka xokupa yause tianikiriai. ");
INSERT INTO six_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Tini kakixanari nanunari, tinie ye xoi iwakuaire kototikine xaku. Xuwe. Tinipo asinaku kapiae pani kokaipa xati, Xoiteue tini xosa asinaku kapia kakepinaure ye xoieune. ");
INSERT INTO six_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Pana tinie xokupa sapi Epaprotitusu xuporo iyari kotai paiya ye itou titiai. Kakari ye xokupa sapi tuku xine paie koirotai. Tinie xuru xesawari kotaia xokupa ekeu emeserina. Tinipo xuru paiya Xoiteu xouiwopu sapi asinaku xuri tuku sie, tini Xoiteu tukiriai. Xoiteu xouiwopure panumu kakeria nu panumu tepure xiri nimaririrouna. ");
INSERT INTO six_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Yeu Xoiteue siko Kristusu Yesusupo xuiapu sikau xokupa sapi asinaku asinaku akituworisiketai. Pa xati tini sapi xuweitautiketaia nukoe xokupa sapi xiri xousokuworitikepina. ");
INSERT INTO six_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Xoiteu nu sikou Xoiteu nu sikou Emisiki xati, sini nupo wenumu sipesi sipesi xourorepu. Pa suau. ");
INSERT INTO six_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Tini Kristusu Yesusupo xuiapu xosa kuso kuna tikine. Ye xeika puroteneai xataimanae, tini xosa asinaku asau xeteneai. ");
INSERT INTO six_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Xoiteupo xuiapu xokupae tini xosa ipaki kuso kuna kunauneri asinaku asau xeri, Sisaripo atoro saina tirouneri pa apimi kinie, yei tini asinaku asau kuna tikepineure sokisoki kuna kayeteneai. ");
INSERT INTO six_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Kokaipa Yesusu Kristusue xousuaxina xouwesiketai kapiae tini xokupa xosa puropina.");
INSERT INTO six_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Ye Polu, ye Kristusu Yesusupo tianuwopi. Xoiteu nukoini ye xouweina Yesusupo tianuwopi tumuyeretai. Yeu xatai Timotino ");
INSERT INTO six_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","sinie mua nakau tini Xoiteupo xuiapu Kolosi erewese purikiriai xosa xayaritikinuku, paiya tini xatasikimana ukusikimanae Kristusu xosa xotikisukiriai xosa. Sikou Emisiki Xoiteue tinire xousuaxati xouwetikatia tinipo xotikikemu yoroni purakuai. ");
INSERT INTO six_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Sini kunikuninua paiya, sipesi tinire nanunanunua Xoiteu eiyaseurounua, nu sikou Kokaipa Yesusu Kristusupo Omo. ");
INSERT INTO six_vpl VALUES ("CL1_4","081_1_4","COL","1","4","6","Sinie muanumu kuna tinire iyesikiria, asinaku kunapu suau kuna tini xosa koati tinie iyeserinuku, pa asinaku sapi Xoiteue tini akituworitikina mena xouro iyarati purotai tepure tini xotikisukiriai. Pa xati tinie Kristusu Yesusure xiri xotikisunuku Xoiteupo xokupa xuiapu xosa xotikikemu tinikirounuku. Xokupa wese wese ninie mua asinaku kuna uteiwopi saina teri, xokupa xuiapue xonikisuneri taineri, ninipo kapia asinaku xetai. Ximuximu akereki asau xosa Xoiteue xousuaxati xouwesiketai asinaku kuna tinie iyesinuku xiri sipawari, panumu kapiani tini xopu xosa yaraxetai. ");
INSERT INTO six_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Epaprasie mua asinaku kunapu kuna tini taitaitikati, tinie sipauweikiriai. Epaprasi nu Kristusupo asinaku saina apu. Nu sinipo saina emesiki xati, sinie nu xiri xosikieurounuku. Nue tini tianitikina Kristusupo saina atinani tirouna. ");
INSERT INTO six_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Xoiteupo xuiapu xiri xouwenikepi kapia Xoiteupo Supo Youyae tini tikeyaire nue sini kasietai. ");
INSERT INTO six_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Pa xati ximuximu akereki asau xosauni, tinipo asinaku kapiaure iyeserinua, Xoiteue tini xouwetiketai atinarini kutu sipawakuaire sipesi sinie kunikuninua Xoiteue tianitikepinaure kotourounua. Kakikiri Xoiteupo Supo Youyae asinaku asinaku sipa xeika nanunanu xeika tikatia paie tini xosa xiri xokopexepina. ");
INSERT INTO six_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Kakati tinie Kokaipapu xuiapuni kutu nikau kapiarei texaria, tinipo xokupa kapia xouwewopina. Kakatia tinie xokupa asinaku asinaku saina takuai. Kakinari Xoiteu sipaunaria, pa sipae pani sipesi kokaipa xepina. ");
INSERT INTO six_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Sinie ipaki kunikunirounua, nukou kokaipa sokisoki asinakuni xosa, Xoiteue tini xokupa sokisoki tikatia, tini sokisoki tumunari xokupa xu xemenaria, peuni purinari xu xuwexepineri yause yakuwakuai. Kakatia tinie nimaririeinari ");
INSERT INTO six_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Emisiki eiyasewakuai. Nukoe tini akituworitikeyai asinaku asinaku sapi takuaire, nukoe kakati tini asinaku asinaku kapia taikiniai. Xoiteupo xokupa xuiapu nini nukou memeremu xosa puroteneai xeika pa asinaku asinaku sapi tini takuai. ");
INSERT INTO six_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Sini ukumupo sokisokipo iru xosa purikiri, nue xiyeri tisikina nukou Nonopu kini xosa iyaisikeretai, pa Nono paiya nukoe xiri xouweurouna. ");
INSERT INTO six_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Xoiteupo Nono nukoe sini xiyeri isayasikina sikou xokupa xunu weterisikeyai. ");
INSERT INTO six_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Sini Xoiteu xekopusie itou xuwe, pana Xoiteupo Nono nu Xoiteu nuko sieni. Nu Xoiteupo akereki Nono xati, Xoiteu nukoe xokupa sapi iyareyai xiri tapaxi purina. ");
INSERT INTO six_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Pa Nonopu xuporei Xoiteue xokupa sapi mena xouro xeika ouro xeika xosa iyareyai. Nue xokupa sapi xekopu xuweu xeika xekeurounuku sapi xeika iyareyai, paiya xetauxetau sokisoki xenikorokoro xeika sokisoki youya xeika xokupa sapi sokisoki tuku xeika iyareyai. Nukoe xokupa sapi nukouni iyareyai. ");
INSERT INTO six_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Mua xokupa sapi putawopu xuweu yauseni, nu puroyai. Nue kakati xokupa sapi ati purineri xirini atineri saina tirouneri. ");
INSERT INTO six_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Nue tapaxina Yesusure xonikisuneri tairouneri xuiapu yakunikirouna xati, nini paiya nukou mupokemu. Nu paiya ninipo ekenikioma xotapa. Akerina kopa upuropu xiyeri saroyai apu nuko, pa xati nukoini xokupa sapi tapatapaxi puropina. ");
INSERT INTO six_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Xoiteue pa Nono xosa nukou xokupa ekeoma xeika kapia xeika puropinaure xina, pa xati Xoiteu nukoini nu xosa xiri xokopexina. ");
INSERT INTO six_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Kakina Xoiteue nu xeika xokupa sapi xeika xokumo iyarepurexetai, paiya ouropu sapi xeika mena xouropu sapi xeika rania kakepina. Pa xati Kristusu wetati na nikitoto xosa xumati, nupo yawi kusawati, pa kapiae Xoiteue sinipo xiwai kapia ororetai. ");
INSERT INTO six_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Tini ekime Xoiteu nutiemu puropu xuwe. Tinipo nanunanue, nu xiwaixiwainuku, xoxixoxi kapia tepi saina tikiriai. ");
INSERT INTO six_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Pana Kristusue na nikitoto xosa xumotai xati, pa kapiarei Xoiteue tini nu xeika xotiki tumaretai. Nukou ekero tini Xoiteupo xuiapu sieni purinari muputiki teteiwoki purinari xu xuweu purakuai xati, tini nuko xosa sotiki kopure nu kaketai. ");
INSERT INTO six_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Xoiteue sikou asinaku kunaure kasikekeyai sie tini tinipo xotikisu xosauni kutu puropi puropinari, atapu xai sie sokisoki tumuwaria kire sapie pa asinaku sokisoki kuna yaku purikiriaire tini purutikepuwatixe. Ye Polu ye mua asinaku kunapu saina apu saitiai xati, sinie mua ouro puroteneai xuiapu xosa kuna uteikiriai. ");
INSERT INTO six_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Ximine tini tianitikepure tatau xemeropi nimaririne. Ye Yesusure xonikisuwoteai xuiapu tianikepurexine. Nini nukou mupokemuni. Kristusue Yesusure xonikisuwoteneai xuiapu tianikepure tatau xemerotai paiya xuwe xatixe. Paina ikoe ikou mupi xosa xemetiai tatau paiya, Kristusupo tatau xousokuwopure ye kakitiai. ");
INSERT INTO six_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Xoiteu nukoini ye tumuyerati tini tianitikepure Yesusure xonikisuwoteneai nikau saina apu xitiai. Pa xati ye Xoiteupo xokupa kuna atinei uteiwopine saina tuku. ");
INSERT INTO six_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Ekime xokupa yause paiya mua kuna ximiaki purati, paire xokupa xuiapu kinie sipawopu xuwe. Pana muaia Xoiteupo xuiapu ekinikiro yarani putawotai. ");
INSERT INTO six_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Xoiteu nukou xouweni kakina, mua ximiaropu kuna sini nukou xuiapu atarisikatia, sini sipaunuku, mua kuna xiri asinaku xati paie xokupa xetau xuiapu kini tianikepina xepu. Mua ximiaropu kuna paiya muai. Kristusue tini xopu purinana, sotiki xowati nuko xeika purinari nukou asinaku asinaku sapi mena xouro purotai takuaire nu yakuwa. ");
INSERT INTO six_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Sini xokupa kireni kireni apu xosa Kristusupo asinaku kuna uteirounuku. Sinie asinaku nanunanu xeika sipa xeika tainuku taitainikinuku sokisoki kuna tinikirounuku, pa amure, ninie Kristusu sokisoki taiwopinerire xinukuna, nini kakineria Xoiteu xosa xowopineri. ");
INSERT INTO six_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Pa xati Kristusue xokupa kokaipa sokisoki ye sirouna xati, mua saina tepure ye xiri irereiroune. ");
INSERT INTO six_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Tini sipawakuaire xine, yei tini xeika Yesusure xonikisuwoteneai xuiapu Laotisia erewese puroteneai xeika kireu xokupa xuiapue yeu moaikemu xekopu xuweuwoteneai xeika tianitikepure ye ere irerei saina tiroune. ");
INSERT INTO six_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Tini xokupa tikau xotikikemu sokisokinei saitikeriti Xoiteupo kireu xuiapu xiri xotikienikinari nini xeika xotikikemu xiri tumaxinari purakuaire ye mua saina tiroune. Tini asinaku nanunanu tari, paie tinipo xotikisu sokisokixepinaxine. Pa xati tinie Xoiteupo ximiaropu kuna xotapa ati sipawakuaire xine. Kristusu nukoini mua ximiaropu kuna xotapa. ");
INSERT INTO six_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Xe xitam ata xosa xokopexetai sie, xokupa ximiaropu sipa xeika nanunanu xeikae Kristusu xosa xokopexina. ");
INSERT INTO six_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Kire apue tini niraniratikina xoreitikepi ye xiraxine, pa xati ye mua kuna kunaune. ");
INSERT INTO six_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Ye tini xeika purixana xuwe. Pana yeu nanunanu paiya, ye tini xeika purieune xeketikitia tini kutuni saina tinuku Kristusu xosa sokisoki xotikisuwari ye nimaririne. ");
INSERT INTO six_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Tinie Kokaipa Kristusu Yesusu tieikiriai, pa xati tini nu xeikani texa. ");
INSERT INTO six_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Tini nae ou xosa sokisoki tumuwati, atae sokisoki xai xouro sokisoki tumuwotai sie, tini nu xosa sokisoki tumuwa. Tini sinie pa asinaku kuna taitaitikiniai xosa sokisoki xotikisunari, sipesi Xoiteu xosa eiyasewa. ");
INSERT INTO six_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Tini sosopa epixakuai, panumu kire apue aipu xoreixorei sipa xeika kuna xeika tini xosa uteiwati tinie nupo nanunanu taiwaku. Panumu apimie asinikimana nikau nanunanu tineri mena xeika ou xeika yakuwoteneai yaniyani nikau nanunanu teteneai. Ninie Kristusupo nanunanu tairouworixe. ");
INSERT INTO six_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Siko sipa, Kristusu nue siko apu sie sayetai xati, Xoiteupo xokupa ekeoma nu xosa xiri xokopexina. ");
INSERT INTO six_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Nue xokupa sapi sokisoki tuku tapaxina. Tini Kristusupo xati, Xoiteue tini ekeoma tiketai xati pa ekeomae tini xosa xiri xokopexina. ");
INSERT INTO six_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Tinie nu xeika etokikiriai xati, mari takepi kapiani kutu tinie tikiriai. Paiya mupusikipo sapixe. Xuwe. Kristusupo kapia xosa sini xipiki xosikikemupo kapia xesauweikiriai. Mari takepi kapia paiya paini kutu. ");
INSERT INTO six_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Tini Xoiteupo wenumurei ene isikiriai yause xosa, tinie Kristusu xeika etokari, Xoiteue kopa upuro Kristusu xeika upuaitiketai. Xoiteue Kristusu kopa upuropu sarepure saina teyaire tini xotikisunuku, ene isikiriai yause xosa tini Xoiteue Kristusu xeika xiyeri saitikeretai. ");
INSERT INTO six_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Tinie ekime xoxixoxi kapia kakinuku, xipiki xotikikemupo kapia tairouwari, paie outikiati xumukiriai. Pana Xoiteue kakati Kristusu xeika ekitikioma tari, Xoiteue sikou xokupa xu weterisikeyai. ");
INSERT INTO six_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Mosesipo tuxotapae kuna xosa tumusikerina sikou xokupa xu yararina kakati, sikoe nupo xokupa kuna xeika sokisoki xeika irue purikiriai. Pana Xoiteue kuna xosa iyaisikerepure xeteneai pa xokupa kuna xesauweina nue tuxotapapu sokisoki xuweiyeina Kristusupo na nikitoto xosa wareyai. ");
INSERT INTO six_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Nue sokisoki yaniyani xeika xokupa konikoni sapi sokisoki tuku xeika nikau sokisoki xuweiyetai. Xoiteue na nikitoto xosa xokupa apimi ipaki atarinikina pa xokupa sapi emeserinikiati ninie aipu sapi sieiyeteneai. ");
INSERT INTO six_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Pa xati tini kakixari kire apu wetari kuna xosatiki suna kunauna, tini xoye xeika ene xeika nepi tuxotapa taiwarixe xina, muris tepire kokaipa asaupo tuxotapa taiwarixe oma poitaure muris tepi tuxotapa taiwarixe Yuta nikau arikepi yausepu tuxotapa taiwarixe xina kunawoxete. ");
INSERT INTO six_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Pa xokupa kapia paiya nini aipu xeniroroi sapi sie xurise putawopure xeteneai. Pana Kristusu nuko paiya xiri asinaku. ");
INSERT INTO six_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Kire apue xiniwepirei xekotai sapire kuna utei kunauna tini takipo wenitiki ororinari xenikorokoro xosa muris ta xatia, tini kakixanari nu wetari tini oroitikexete. Panumu apimie xipiki xonikikemupo nanunanu taineri siko kireni asinaku sipani tuku xineri, ");
INSERT INTO six_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","sikou akerekini kutu Kristusu sokisoki tirouworixe. Pa tapae nukou mupo masa xokupa xosa xoye tinikati, paie xokupa muporopu tuni murie tumaxina atina xiri sokisokixirouna sie Xoiteue xouweouna. ");
INSERT INTO six_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Tini Kristusu xeika xumuweikiriai xati yaniyanie mena xouropu sapi xeika ouropu xeika yakurouneri nikau sokisoki irue purarixe. Pa xati muaia tini amakati ouropu apimi sie purirounukuna? Panumu tinie panumu tuxotapa tainuku, ");
INSERT INTO six_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“Ne kakixanau teu, ne kakixanau kireu xoye neu, ne nu wetau mupuniro erarawoxete,” xirounuku. ");
INSERT INTO six_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Panumu tuxotapae kakina kunawotaia siko saina tikiri sapauni xoxirouneri sapire kunawotai. Paiya apimi nikoini pa tuxotapa yararineri nini tainikepure taitaisiketeneai. ");
INSERT INTO six_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Suau, panumu tuxotapa paie Xoiteue xouwewotai kapia sarepinaxi ninie nanuneri, pani nanuneri sini sikou mupusiki ororinuku ou puropu xineri. Pa xati, kireu apimie nanuneri mua tuxotapae asinaku nanunanu xeika sipa xeika taineri xineri. Pa xati kireu apimie nanuneri mua tuxotapae asinaku nanunanu xeika sipa xeika taineri xineri. Pana pa tuxotapae sini tianisikineri xipiki xosikikemupo kapia xiri ororepuworixe. ");
INSERT INTO six_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Xoiteue tini Kristusu xeika saitikeretai xati, tini xouropu sapi tepureni kutu saina ta. Pa xouro wese xosa, Kristusue nukou kokemu sai xosa Xoiteupo xupo meruira misina. ");
INSERT INTO six_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Tini xouropu sapireni kutu sipesi nanunanuwa. Tini ouropu sapire kakixanari nanunanuwaku. ");
INSERT INTO six_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Tini xumuweikiriaina, tinipo ekitikioma Kristusu xeika ximiaki purati tini Xoiteu xeika etokinuku. ");
INSERT INTO six_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Kristusu nukoe tinipo ekitikioma xotapa. Nu yara putawatia, tini rania nuko xeika Xoiteupo kokaipa memeremu xeika nekei xeika xosa putawakuai. ");
INSERT INTO six_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Pa xati mua ouropu xokupa kapia tinipo xotikiro puroteneaia xiri ounikiari xumuwepineri. Ye muanumu muanumu kapiaure kunaune, xuimi apimie ayaka xepi kapia xeika xunu kapia xeika, xosikikemu saroati xoxixoxi kapia kakepi kapia xeika xoirai kapia xeika kireu apimi nikau sapire ekisikie nepi kapia xeikaure kunauna. Mua ekisikie nepi kapia xeika xoirai kapia paiya xorei xoiteu xosa muris tepi kapia sie. ");
INSERT INTO six_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Apimie pa xoxixoxi kapia kakineri Xoiteupo kuna xosa xasese marouneri paiya, nini Xoiteue xarotinikepuwatixe. ");
INSERT INTO six_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Ekime tinie rania pa apimi xeika texinuku, pa xokupa kapia kakirounuku. ");
INSERT INTO six_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Pana muaia tinie pa xokupa xoxixoxi kapia xiri xesauweya, paiya makaunuku kisamairaxinuku xosikikemu xoxixoxixepi kapia, pa xeika kireu ninianikepi kapia xeika xoxixoxi xunu kuna kunawopi kapia xeika. ");
INSERT INTO six_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Tini kirenikirenie kakixanari kireu apimi nini Yesusure xonikisurouneri xoreinikaku, pa amure, tinie xipiki xotikikemupo xokupa kapia xesauweinuku, ");
INSERT INTO six_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","tini oma saiyeikiriai. Xoiteue kakati tini oma apimi saiyari, sipesi tini xokupa asinaku sipa tikati, tini oma saiyeinuku nuko sienixinuku. ");
INSERT INTO six_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Sini apu oma sasaikiriai paiya, sini xokupa panumu sieni panumu sieni purinuku. Sini pani nanunuku sini Kriki kinipo xepuxe sini Yuta kinipo xepuxe, sini mari takikirai xepuxe mari takepu xuwe xepuxe, sini xetauxetau kunapu xepuxe xetauxetau sanawapu xepuxe, sini aipu saina apu purinuku xepuxe sini somo purinuku xepuxe, pa amure, Kristusu kireni purina, Kristusu nukoini siko xokupa xosa purina. ");
INSERT INTO six_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Xoiteuetini tumutikerati, tini nukou xuiapu purari, tini xiri xouwetikirouna. Pa xati tini muanumu kapiani kutu ta. Tini kireu apimire xiri eiyoxinari asinaku kapia nini xosa kaka. Tini takipo kapia ororinari apimi xosa yoro kapia kakinari, apimie tini xosa kapia xoreiyereri sapauni kisamairatikexete. ");
INSERT INTO six_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Kire apu tini xopuropu nu kire apue nu xosa kapia xoreiyeretai xati nu xeika kuna tuku xatia, xeuxana nukoini pa xu xemena xataupo xunu weteruwopina. Kokaipae tinipo xunu weteritiketai xati, tinie rania kireu nikau xunu weterinikakuai. ");
INSERT INTO six_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Tinipo xotikikemu kireu xuimiapimi xosa tinika. Pa kapiae xokupa kireu kapia emeserinikina, paie kakati kireu asinaku kapiae xirini kununu saina tineri sokisoki sairouneri. ");
INSERT INTO six_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Kristusue xosikikemu yorowopi kapia sikirouna xati sini kireni xosikikemue purikiriai, pa kapiae tinipo xotikikemuni kutu yakuwopina. Tini kirenini xotikikemu sainari kireni xotikikemu kutu purakuaire Xoiteue yaitikeyai. Pa xati tini sipesi Xoiteu eiyasewa. ");
INSERT INTO six_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","TiniKristusupo kuna wetari tinipo xotikiro sokisoki puropina. Tini kireni kirenie Yesusure xonikisuwoteneai kireu xuiapu taitainikinari asinaku nanunanu xeika sipa xeika tinikari, asinaku kapia kireni kakepineri. Tini tinipo xotikirei Xoiteu eiyaseunari, Siri Nakaupo xeika kireu siri muris xosaupo xeika Xoiteupo Supo Youyae xotikiro iyaretai xeika sipesi worakuai. ");
INSERT INTO six_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Tinipo kuna xosa xeika saina xosa xeika xokupa sapi xeika kakikiriaia, tini Kokaipa Yesusu wenumurei kakakuai. Kakinari nupo wenumurei tini Emisiki Xoiteu eiyasewakuai. ");
INSERT INTO six_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Tini xuimi, tini takipo xamutikimana irue pura. Kokaipapu ekero pa kapia xiri asinakuni kutu. ");
INSERT INTO six_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Tini apimi, tini takipo inetikimana xiri xotikienikinari, peuni ati yakunepu kapia kaka. ");
INSERT INTO six_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Tini nonomi, tini xokupa sapire takipo emitikimana anitikimana nikau kuna taiwa. Kokaipae panumu kapia xouweurouna. ");
INSERT INTO six_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Tini eminikimana, tinipo nonomie makawopineri kapia kakaku, panumua xonikemu xoxixoxixati kuna iyesepu xuweuwopineri. ");
INSERT INTO six_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Tiniaipu saina apimi paiya tinipo yayakutikepi nikau xokupa kuna taiwakuai. Ninie tini nutietiki purori ai niraniranikepure nanuworinari asinaku saina taku. Xuwe. Tini Kokaipaureni kutu xiri ximikinari, tini asinaku saina takuaire kireni sipesi nanuwa. ");
INSERT INTO six_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Xokupa sapi kakinaria, tini sokisokinari saina takuai. Tini apu nikau saina kireni tinarixe. Xuwe. Tini Kokaipapu saina xeika tinuku. ");
INSERT INTO six_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Tini sipa, Kokaipae sewai tini isayatikepina, paiya asinaku asinaku sapi nukou xuiapu nikau akituworiniketai tinikepina. Nanuwa. Tini Kokaipa Kristusupo saina apimi purinuku. ");
INSERT INTO six_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Apue kapia xoreiyerina paiya, nu xoreiyeretaipo xu xapa tepina. Xoiteue xokupa xuiapu nikau kapia kireni imereini uteirouna. ");
INSERT INTO six_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Tini aipu saina apimi nikau yayakunikepi, tinipo aipu saina apimi xosa tini asinaku kapiani kutu kakakuai. Tini sipa, taki rania tini yayakutikepi tuku nu mena xouro purina. ");
INSERT INTO six_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Tini kunikuniwopi kapia sokisoki takuai. Tini kunikuniwakuai yause paiya, tini ati nanunanu tinari Xoiteu eiyasewakuai. ");
INSERT INTO six_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Tini kunikuninaria Xoiteue sini rania tianisikepinaure kunikuniwakuai. Sini Kristusupo kuna uteiwopinukure tinie kotowari ime taiyerisikepina. Mua kuna paiya ekime ximiaki puroyaie, ximine yarani putawotai. Pana apimie pa kuna iyesepu xirarineri kakauya xosa iyaiyereteneai. ");
INSERT INTO six_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Yei mua kuna ati uteiwopineure Xoiteue xouweyetai xati, tini paire kunikuniwakuai. ");
INSERT INTO six_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Tini Yesusure xonikisuwopu xuweuwoteneai xuimiapimi xeika purinaria tini asinaku nanunanu tainari asinaku kapiani kutu taiwakuai. Nini xokupa yause Kristusupo kapia atarinikepure tini ireiwakuai. ");
INSERT INTO six_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Tini sipesi kunaunari paiya, apimie iyesineri xonikieurouneri kuna kireni kunawakuai. Tini atinari nanunanu tinari xokupa apimi nikau kuna xaute atinari xonikemu tepina kuna xapa kanikakuai. ");
INSERT INTO six_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Yei xokupa saina kakitiaire paiya Tikikusuetini katikepina. Tikikusu nu sikou xatasikini kutu nu sikou saina emesiki, nu Kokaipapu asinaku aipu saina apuni kutu. ");
INSERT INTO six_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Ye pa xotapaure kireni xesauti tini xosa utuna, paiya sini amaki purikiriai sipawakuaire, pa xeika tinipo xotikikemu sokisokiwopinaure utuna. ");
INSERT INTO six_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Ye Onesimusino Tikikusuno xeika xesanikiti utunexeri. Onesimusi nu sikou xatasikini kutu, nu sikou saina emisiki, pa xeika nu takipo kuna emetiki. Ninie xokupa kapia muoro yaraxetaire katikepineri. ");
INSERT INTO six_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristakusi, nu ye xeika kakauya xosa purina, nue tini kusotikina. Maki paiya, nu Parnapasipo xepeu, nue rania tini kusotikina. Ye kuna xesaritikine katikiyaia nure katikiyaina, nu tini xosa utatia, tinie nimaririrei sowakuai. ");
INSERT INTO six_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Kire Yesusu, wenuneri Yastusu xeteneai, nue rania tini kusotikina. Yuta kini xosaupo apimi nini pa apimi kirenie ye xiri atineri taineri Xoiteue xuiapu yakunikirouna yause sarepure saina tirouneri. Ninie ye atineri tianirouneri. ");
INSERT INTO six_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Epaprasi nue tini kusotikina. Nu takipo xatatiki, nu Kristusu Yesusupo saina apu. Tinie Xoiteupo kapia tieinuku xouropu Xoiteupo xokupa nanunanu atinuku xiri sipauwekiriai xati, tini sokisoki tumuwakuaire nue sipesi sokisoki kunikunina Xoiteue tianitikepinaure kotourouna. ");
INSERT INTO six_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Ye nure tini katikepurexine, nue tini xeika Yesusure xonikisuwoteneai xuimiapimi Laotisia erewesepu xeika Ieropolis erewesepu xeika puroteneai xosa tianitikepure xiri irereina saina tirouna. ");
INSERT INTO six_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Apu Luku, pa sipetuaure sini xiri xosikieurounuku, nue Temasino tini kusotikineri. ");
INSERT INTO six_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Tinie yeu kuso Laotisia erewese puroteneai xatasikimana tinikakuaire ye xoieune. Pani Nimpa xeika Yesusure xonikisurouneri xuiapue nupo atoro kununurouneri rania yeu kusotinika. ");
INSERT INTO six_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Tinie mua nakau ninaiyeinaria, Yesusure xonikisuwoteneai xuiapu Laotisia puroteneai xosa xesarinikari, ninie rania ninaxepineri. Tinie rania, ye Laotisia xesauti xowotai nakau ninaxakuai. ");
INSERT INTO six_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Tinie Arkipusi ipaki kaunaria, “Ne Kokaipa xosaupo tiyai saina ati yakunau, pa saina atinauni kutu kake,” xi kawakuai. ");
INSERT INTO six_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Ye Polu, ye ikoini mua kuso kuna tini xosa xayaune. Tini yeureni nanunanuwa, ye kakauyaroni purine. Xoiteue xouwesikina xoukemu sikirouna kapia tini xosa purina.");
INSERT INTO six_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1"," Sini Polu xuno Sailasi xuno Timoti xunoe, mua nakau tini Tesalonaika erewesepu xuiapu xosa xayaritikinuku. Paiya tinie Emisiki xeika Kokaipa Yesusu Kristusu xeikaure xotikisinuku etokipurikiriai xosa. Xoiteue tinire xousuaxina xouwetikatia, tinipo xotikikemu yoroni purakuai. ");
INSERT INTO six_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Xokupa yause sinie tinire nanunanunuku Xoiteu eiyaseurounuku. Sinipo xokupa kunikuni xosa tinipo wenitiki tirounuku. ");
INSERT INTO six_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Tinipo xotikisue saitikerati asinaku kapia kakakuaire, kireu xotikikemu tinikinuku asinaku saina tinuku, xotikikemu sokisoki xinuku sikou Kokaipa Yesusu Kristusu yakukiriaire, sinie sikou Xoiteu Emisiki xosa eiyaseurounuku. ");
INSERT INTO six_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Tini xatasikimana, Xoiteue tini xiri xouwetikina, tini nukouni kutu tumutikeretai xati, sini paire sipauweikiriai. ");
INSERT INTO six_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Mua asinaku kuna sinie tini xosa tikoukiniai paiya, aipu kuna sie tini xosa putawoyaixe. Xuwe. Nue sokisoki xeika Xoiteupo Supo Youya xeika putawati tinie atinuku sinipo sokisoki xosikisu xekeukiniai. Sinie tini xopu purinuku tini tianitikepure, asinaku kapia kakikiriai paiya tini takieni sipa. ");
INSERT INTO six_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Tinie Xoiteupo kuna tari, xokupa xu tini xosa putawotai sorena, tinie sinipo kapia xeika Kokaipapu kapia xeika taiwari, Xoiteupo Supo Youyae tini saitikerati tinie nimaririnuku. ");
INSERT INTO six_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Pa xati Mesetonia propinsi xeika Akaia propinsi xeika xosa xokupa xuiapue Kristusure xonikisuwori tinie asinaku kapia nini atarinikikiniai. ");
INSERT INTO six_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Tinie Kokaipapu kuna uteikiniai paie kiroma miria sie xouna xounawotai. Paiya Mesetonia xeika Akaia xeika masaira kireni xosa xowotaixe. Xuwe. Tinie Xoiteure xotikisuwari xokupa wesewesei tinire kuna iyesieteneai xati, sini pani nini kanikepinuku saina xuwe. ");
INSERT INTO six_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Sinie tini xosa putaukiniai yause xosa kapia akipaxeyaire nikoini asiwarouneri. Tinie xoreixorei xoiteu teu wetinuku, nu sipesi purotai Xoiteuni kutu xosa xotikipirixikiriaire asiworoteneai. Tinie Xoiteupo aipu saina apu sainuku, ");
INSERT INTO six_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","nupo Nono xumati Xoiteue xiyeri saretaie mena xouro wetina koati tinie yakuari ninie asiworoteneai. Nu Yesusu, nue sini xiyeri sosikatia Xoiteupo kisamaira kopina yause xosa sini atinuku puropu. ");
INSERT INTO six_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Yewapu xura, takieni sipa, sinie tini xopu purinuku saina tikiniai paiya, aini xuwexepu xuwe. ");
INSERT INTO six_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Tini sipa, sini tini xosa kopu xuweu yauseni, sini Pilipai erewese purikiri sinipo mupusiki xoxixoxiwori, tatau tikiniai. Pana sinie tini xosa koukiria, sikou Xoiteue sinipo xosikikemu sokisokiwati pa xiwayasikimanaure ximikinikikirixe. Xuwe. Sini sokisoki tumunuku tini xosa Xoiteupo asinaku kuna uteinuku. ");
INSERT INTO six_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Tinie Yesusure xotikisuwakuaire, tini yaitikinukua, sini kuna xoreiyerinuku, sini xunu kapiare e xorei kapia kakekixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Pana Xoiteue sini uteisikieina nukou xouweni sini asinaku kuna uteiwopi saina siketai. Pa xati xuiapue sinipo sainaure xonikiewopineri xinuku nanuwori kuna uteikirixe. Xuwe. Xoiteueni sinipo xosikikemu uteirouna xati, nukoini sinipo saina xouwewopina xinuku. ");
INSERT INTO six_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Tini sipauweikiriai xati Xoiteue rania panumu kunani kunawopina, sinie tini niraniratikepi sie kuna kunawopu xuwe, pa xeika sinie tinipo sapire ekisikie ninuku asinaku kuna katikepu xuwe. ");
INSERT INTO six_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Sinie tini xosare kireu xuimiapimi xosa kokaipa wenisiki tepure saina tepu xuwe. ");
INSERT INTO six_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Suau, sini Kristusupo tianuwopi purikiriai. Pa xati sini sapi xosikieukiriai xakua sini tianisikakuaire tini katikiku. Pana sini tini xeika purikiniai yausepa, sini nono misiarara sie peuni purikiniai. Sini xuie nupo nonomi apuri tiniki purotai siei purikiriai. ");
INSERT INTO six_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Sini tinire xiri xosikieunuku, pa xati sini Xoiteupo asinaku kuna tini tikepure xinuku. Pa xeika sinipo ekisikioma tini tikepure rania sini ireinuku, pa amure, tinie sinipo marouni kutu saikiriai. ");
INSERT INTO six_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Yewapu xura, sinie tini xeika purinuku Xoiteupo asinaku kuna uteinuku irereikiniaia tini sipauweikiriai. Tinie sini xoyeara sikakuai paiya tini xu tikepi xirarinuku, sini asau xeika ukumu xeika xosa sokisoki sainani kutu tikiriai. ");
INSERT INTO six_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Tini sipa xati, Xoiteu rania sinie tini Kristusure xotikisukiriai xuiapu xosa kakikiriai kapia nu sipa. Sinie Xoiteu ekero asinaku asinaku kapia kakikiniaina sini xoxi kapia kakepu xuwe. ");
INSERT INTO six_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Tini sipa, eminikie nupo nonomi xosa kakirouna kapia sieni, sinie tini xosa panumu kapia kakinuku, ");
INSERT INTO six_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","tinipo nanunanu sarinuku xotikikemu sokisokiwopure sinie kunaukiriai. Tini Xoiteupo kapiarei itouni texakuaire kakinuku kunaukiriai, tinie Xoiteue xuiapu yakunikirouna yause minika manari mena xouro asinaku misepini kutu takuaire nu Xoiteue tini yaitikeyai. ");
INSERT INTO six_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Pa sapire rania sipesi sinie Xoiteu eiyaseurounuku. Tinie Xoiteupo kuna sinipo supusikiropu tikiriaia, tini apupo kuna sie tekixe. Xuwe. Tini Xoiteupo kunani kutu sie tikiniai. Kakari pa kuna paie tini Kristusu xosa xotikisukiriai xuiapu xotikiro sokisoki saina tina. ");
INSERT INTO six_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Yewapu xura, tinie Xoiteupo Yesusure xonikisuwoteneai xuiapu, Yutia puroteneai sie saikiriai, nini Yesusu Kristusu xeika etoketeneai xuiapu. Tinie emetikimana nikau xupunikiro kokaipa xuni kutu tikiriai sieni, Yutiapu Xoiteupo xuiapue Yuta xupunikiropu xu teteneai. ");
INSERT INTO six_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Yuta apimie Kokaipa Yesusu ouweineri kunatureture rania ounikieineri, sini xesasiketeneai. Xoiteue xouwewotai kapia nikiniki tuneri, xokupa apimi xiwaixiwainikineri. ");
INSERT INTO six_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Sinie xetau xeteneai xuimiapimi xosa kuna uteiwopinuku paiya, ninie sinipo saina ime parauneri, pa amure, Xoiteue pa xuiapu xiyeri tinikepi nini xiraxineri. Pa xati ninie sipesi kakirouwori ninipo xunue pani kokaipa xati, Xoiteupo kisamairae nini xosa kotai purina. ");
INSERT INTO six_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Yewapu xura, Yuta apimie kakeri tini xayaka xayaka weitikiteri nanukiria, eminikie nupo nonomi weinikiteri xetauro purieuna. Sini tinipo moatikikemu xekeukiri xana xuwena pana, sinipo xosikikemu paiya tini xeikani purina. Pa xati tini xiyeri kounuku xeketikepure ime xirekepi saina pani sokisoki tinuku. ");
INSERT INTO six_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Sinie tini kounuku xeketikepure xikiriai, ye Polu, ye kopure xokupa yause eruruyai. Pana Satanie taiyerisiketai. ");
INSERT INTO six_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Sikou Kokaipa Yesusue xiyeri koati yause paiya, amu sapie sini sokisokisikati nu ekero tumunuku nimaririwopinukuna? Sini amu tikou atarunuku sinie sinipo saina ati tikiniai xepinukuna? Paiya tini kireni. ");
INSERT INTO six_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Iyo, sini tinire nimaririroukiri, takieni kakari sini xosikikemu asinaku purinuku. ");
INSERT INTO six_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Sinie tinire xiri eiyorinuku, xurise sini ere xenenewopuxexi nanukiriai. Pa xati kuna ouwori kunaunuku sio Atensi puraxauna, ");
INSERT INTO six_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Timoti xesauyati tini xosa utopinaxi kuna oukiriai. Timoti nu sikou xatasikina nu Kristusupo asinaku kuna uteiwopina Xoiteupo saina apu. Nue tinipo xotikisu tianitikina sokisokiwopinaure xesauyati utotai, ");
INSERT INTO six_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","pa xu xeika tatau xeika tini xemekiriaie kakatia tini kireue xokupa nanunanu taku. Takieni sipa, sinie muanumu xu xemeropure Xoiteue tumusikereyai. ");
INSERT INTO six_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Sini tini xeika purikiriai yauseni ipaki katikinuku, xu xana xu siko xosa kopina xikiriai. Pa xati itou takieni sipaunuku, pa xu xoxi itou motai. ");
INSERT INTO six_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Pa xotapaure sore ye pani xenenewopu xuwe. Ye tinipo xotikisu sipawopure, pani Timoti xesauti tini xosa utotai. Tinipo xotikisu eruruwopina apue xakuxakutikiati, sinipo saina aini xuwexinaxi ye nanune. ");
INSERT INTO six_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Paina Timotie tini weitikiterina mukatie sini xosa kouna putauna. Nue asinaku kunani kutu sini kasikina. Tinie sokisoki xotikisunuku kireu xiri xonikieurounukure kunawotai. Sipesi tinie sinire nanunanuku asinaku xotiki tuku xirounukure, nu kunauna. Kakinuku tinie sini xekesikepure eiyoxari sinie rania tini xeketikepure eiyoxinuku. ");
INSERT INTO six_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Yewapu xura, tinie xotikisuwopi sokisoki purari sinie iyeserinuku, paie xokupa xu xemekiriaia sinipo xosikikemu sokisokina. ");
INSERT INTO six_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Tinie Kokaipa xosa sokisoki purari sini sipaukiriai xati, ximine sinipo ekisikiomae xiri asinakuni kutu saina. ");
INSERT INTO six_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Sinie tinire nanunanuworinuku sikou Xoiteu ekero xiri nimaririnuku xekeukiria, sinie Xoiteu eiyasewopi kapia paiya nue sini sikeyai nimariri xiri itouwati xana xuwe. ");
INSERT INTO six_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Xoiteue sini weisikitati utunuku tini xeketikepinukure asau xeika ukumu xeika xosa sini kunikuniwoki kunikuniwokinuku. Pa xati tinipo xotikisu xayaxayaka xatia, sinie xemu sokisokiworitikepinuku. ");
INSERT INTO six_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Sikou Emisiki Xoiteu xeika, Yesusu, sikou Kokaipa xeikae tini xosa sosikiutopinerire xosikieunuku. ");
INSERT INTO six_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Kokaipae tini xosa kireu xonikiewopi kapia xiri korepinaure sini xosikieunuku, kakatia tini kirenikirenie Xoiteupo xuiapu xosa xeika xokupa xuiapu xosa xeika xiri xotikikemu tinika, paiya sinie tini xosa xosikikemu tikirounuku sie kaka. ");
INSERT INTO six_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Pa kakaria Kokaipa Yesusue nukou xokupa xuiapu xeika xiyeri kopina yause xosa paiya, tini muputiki xokumo purari xeketikepina. Tinie asinakuni kutu xu xuweu sikou Emisiki Xoiteu ekero purakuai. Pa suau. ");
INSERT INTO six_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Nini Tesalonaika ninipo asinaku kapia sokiteria ninipo ekinikoma sokisokixepina 4—5 Yewapu xura, tinie Xoiteupo nanunanu tainari texakuaire sinie tini xokupa kapia ataritikikiri, tinie pa kapia tairounuku. Pana muaia tinipo xotikikemu xiri sokisokinuku Kokaipa Yesusu wenumurei mua kapia pani kakakuaire tini katikepure xinuku. ");
INSERT INTO six_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Xokupa kuna Kokaipa Yesusupo wenumurei sinie tini tikikiriai tini sipa. ");
INSERT INTO six_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Xoiteupo xoukemu paiya muanumu. Tinipo ekitikiomani kutu xiri tuworinari muputiki xokumo saya. Kakinari xokupa ayaka kapia emeseruwa. ");
INSERT INTO six_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Tini kirenikirenie xotikiropu xoxixoxi kapiapu nanunanu kourouna atinari yakuwakuai, kakinari Xoiteue xouwewotai kapia xeika asinaku kapia xeika taiwakuai. ");
INSERT INTO six_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Pa xotikiropu xoxixoxi kapiapu nanunanue purutikati, xukumie Xoiteu sipawopu xuweue xoxixoxi ayaka kapia kakirouneri sie kakaku. ");
INSERT INTO six_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Tini kakixanari Yesusure xonikisurouneri xatatikimana xosa xu kakerinari, pa xoxi kapia kakinari ekinikiworaku. Muanumu kuna ekime sinie tini sokisoki katikinuku, muanumu kapia xokupa apimie kaketeneai paiya, Kokaipae nini xaro tinikepuwatixe, xikiriai. ");
INSERT INTO six_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Sini xoxi kapia kakepure Xoiteue yaisikepu xuwe. Xuweni kutu. Xoiteue sini xokumo kapia taiwopure yaisikina. ");
INSERT INTO six_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Pa xati apue mua kuna supo wana paiya nu apupo kuna kireni supo woratixe. Xuwe. Nu Xoiteupo kuna supo wana, nu nukou Supo Youya tini tikirouna Xoiteu. ");
INSERT INTO six_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Tinipo xotikikemu Xoiteupo xuiapu tinikepi kapiaure yei tini xosa kireu kuna xayawopixe, pa amure, pa kapiaure Xoiteue tini taitaitikietai. ");
INSERT INTO six_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Kakati Yesusure xonikisuwoteneai xuiapue Mesetonia propinsipo xokupa sanawayau puroteneai tinipo xotikikemu tinikirounuku. Pana yewapu xura, tinie pa kapia pani pani kakakuaire, tinipo xotikikemu sokisokiwopure xinuku. ");
INSERT INTO six_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Tini peuni misepi kapia sokisoki xinari takipo sainani ta. Sinie ekime tini katikikiniai sie tini takipo xuputikieni sokisoki saina tinari paiya, tini takieni sokisoki tumuwakuai. ");
INSERT INTO six_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Kakinaria tini kire sapi xuweitautikepuwatixe, kakaria Yesusure xonikisuwopu xuweuwoteneai xuiapue, tinipo kapiaure nimaririwopineri. ");
INSERT INTO six_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Yewapu xura, xumuweteneai xuimiapimi xosa amuwaurau putawopina paiya, tini atinari sipawakuaire xinuku. Yesusure xonikisuwopu xuweuwoteneai xuiapu kinie xumoteneai xuiapue xiri eiyoxirouneri. Kakineri Xoiteue kopa upuropu sainikerepina yause yakuworixe. Pa xati, sini ninie eiyoxenteneai sie kakepuxe. Sini Xoiteue kopa upuropu saisikeperina yause yakuwopu. ");
INSERT INTO six_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Yesusue xumuna xiyeri sarotaire sini xosikisunuku. Pa xati sini sipa,Yesusupo sokisokie Xoiteue Yesusure xonikisuwoteneai xuimiapimi xumuweteneai xiyeri sainikeratia ninie Yesusu xeika xiyeri kopineri. ");
INSERT INTO six_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Sinie Kokaipapu kuna tini xosa ipaki uteinuku. Kokaipae xiyeri kopina yause paiya, sini ekisikioma tuku xuiapue pani purikiria, xumuweteneai xuiapue purori sinixite akeri xowopuxe. Xuwe. ");
INSERT INTO six_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Xoiteue sokisoki kunawati, akereki xenikorokoroe uru yaxatia, Xoiteupo narie miriaxepina. Kakatia Kokaipae Xoiteupo xaixai wese wetina oro kopina. Kakatia Yesusure xonikisuneri xumuweteneai apimie akerineri saropineri. ");
INSERT INTO six_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Pa yause xosa sini pani ekisikioma purikiriai xuiapue mena xouro pa xuimi apimi xeika xounukua, siko xokupae Kokaipa tutumawopu. Kakinuku paiya sini Kokaipa xeika sipesi sipesi puropu. ");
INSERT INTO six_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Pa xati Xoiteupo kireu xuiapu nikau xonikikemu sokisokiwopure tinie mua kuna takitaki xotikikemu sokisokiwata xakuai. ");
INSERT INTO six_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Yewapu xura, sinie katikinuku panumu asau xosa panumu yause xosa pa sapi akipa xepinaxinuku kuna xayaunuku katikepukirixe. ");
INSERT INTO six_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Takieni sipauweikiriai, Kokaipa kopina asau paiya petuae ukumani marouna sie sapauni kopina. ");
INSERT INTO six_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Xuiapue ipaki kunauneri, “Ximine asinaku yauseni kutu. Xosikikemu yoroni puropu,” xeria, xuie nono iyarepure xeri tatau marouna sie nini xoxi nikepina sapie sapauni nini xosa mopina. Ninie pa sapi emeseriwopuworixana xuwe. ");
INSERT INTO six_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Pana tini yewapu xura tini ukumu xosa purinuku xati, petuae moati apue xekeri urewotai sie tinie pa asau moati xekeri xoxi ure urewakuaixe. Xuwe. ");
INSERT INTO six_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Tini xokupa paiya tini memeremu xeika asau xeika xosaupo apimi. Sini ukumu xeika xori xeikapu kini xuwe. ");
INSERT INTO six_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Pa xati kireu apimi sie sini xinexekini. Xeuxana ekisikie pereu purati, nanusikie teteiwopina. ");
INSERT INTO six_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Sini sipa, xinepineri apimi paiya, nini ukumani xinirouneri. Xisa xukoriwopineri apimi paiya, nini ukumani xisa xukorineri puturouneri. ");
INSERT INTO six_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Pana sini asaupo kinia, sini atinuku nanunanu tepu. Sini Xoiteure xosikisunuku, kireu xiri xonikiewopi kapia tinuku, pa kapiae xomatua nikau nekei sie erepu. Kakinuku Xoiteu yakukiri xiyeri sosikepina kapia paiya, xomatua nikau koike sie kurorinuku, sini sokisoki tumunuku ati yakuwopu. ");
INSERT INTO six_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Sini Xoiteu nukou kisamaira tepure sini tumusikerepu xuwe. Sikou Kokaipa Yesusu Kristusue xiyeri sosikepinaure nue sini tumusikeretai. ");
INSERT INTO six_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Yesusue sini tianisikepure xumotai, pa xati sini ekisikioma purinukure e sini xumunukua, sini nu xeika ekisikioma puropu. ");
INSERT INTO six_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Pa xati tini mua kakirounuku sie, tini kirenikirenie takitaki xotikikemu sokisokiwata akuai. ");
INSERT INTO six_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Yewapu xura, sinie tini ipaki katikepure xinuku, apimie tini tianitikepi saina teteneai irue pura. Kokaipae nini tinipo tumu iyainikerati purineri, tinipo kapia kutuwopure ninie tini kuna tikirouneri. ");
INSERT INTO six_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Ninie pa saina tirounerire, tinie nanunanunari xotikikemu xiri asinaku xinari xiri xotikienika. Kakinari tini xokupae kireni xotikie pura. ");
INSERT INTO six_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Yewapu xura, ouyeouye xirouneri apimi nikau kapia kutunari ximikirouneri apimi nikau xonikikemu sokisokinari sokisokixepu xuweu woteneai apimi tianikinariwakuaire tini saitikerepure xinuku. Kakinari tinie xokupa apimi peuni peuni nika. ");
INSERT INTO six_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Ninie tini xosa xoxixoxi kapia kakeria, tinie kaki xanari xapa taku. Xokupa yause tinie Xoiteupo xokupa xuiapu xeika kireu xuiapu xeika xosa asinaku kapiani kakepure sokisokixa. ");
INSERT INTO six_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Xokupa yause tinie xiri nimaririnari, ");
INSERT INTO six_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","sipesi kunikuniwakuai. ");
INSERT INTO six_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Tini xuiapu Kristusu Yesusu xeika etokikiriaie panumu kapia tini xosa yaraxatia tini Xoiteu eiyasewakuai. Xoiteu nu panumu kapia xouweuna. ");
INSERT INTO six_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Tinie kire sapi kakakuaire Xoiteupo Supo Youyae saitikerepure xatia, tini kakixinari nu paraunari, ");
INSERT INTO six_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","apimie tini xosa kunatureture kuna uteiwopure xeria kakixanari pa kunaure xotikikemu xoxixoxixaku. ");
INSERT INTO six_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Pana xokupa kuna xeika kapia xeika ati erurunari uteiwakuai. Kakinari asinaku kapia kireni sokisoki tinari, ");
INSERT INTO six_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","xokupa xoxi kapia emeseriwa. ");
INSERT INTO six_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Xoiteu nu xoukemu yorowopi xotapa, nue kakati tinie tinipo ekitikioma xiri tuwaria tini xiri xokumo saitikerepina. Kakina tinipo xenitiki xeika muputiki xeika nanunanu xeika ati yakuwati, tini xiri asinaku purinaria sikou Kokaipa Yesusu Kristusue xiyeri kopina yause xosa tinipo xu xuwexepina. ");
INSERT INTO six_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Xoiteue tini yaitikeyaina, nue pa xokupa sapi tini xosa kakepina, pa amure, nukoe xokupa kuna kunawoyaini kutu tairouna. ");
INSERT INTO six_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Yewapu xura, tinie Xoiteu kunikuniwarini kutu sini tianisikepina. ");
INSERT INTO six_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Siko Xoiteupo xuiapu sikau kapia paiya, tini kirenikirenie kireu uritoko nikakuai. ");
INSERT INTO six_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Kokaipapu wenumurei ye tini xosa sokisoki kunaune, mua nakau tinie Xoiteupo xokupa xuiapu xosanikini kutu xosa ninaxakuai. ");
INSERT INTO six_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Sikou Kokaipa Yesusu Kristusue xousuaxina xouwesiketai kapia tini xosa purina.");
INSERT INTO six_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1"," Kokaipapu Asau sewai putawopina 1—2 Sini Polu xuno Sailasi xuno Timoti xuno, sinie tini Yesusure xotikisukiriai xuiapu Tesalonaika erewese purikiriai xosa mua nakau xayaritikinuku, paiya tini xuiapue sikou Emisiki Xoiteu xeika Kokaipa Yesusu Kristusu xeika etokipurikiriai. ");
INSERT INTO six_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Xoiteu sikou Emisiki xeika, Kokaipa Yesusu Kristusu xeikae xonikisuaxati xonikietikeria tini xotiki kurunari purakuai. ");
INSERT INTO six_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Yewapu xura, xokupa yause sinie tinire nanunanunuku Xoiteu eiyaseurounuku. Sinie panumu kakepinuku xiri asinaku, pa amure, tinipo xotikisue xiri sokisoki xati, tini xokupa kirenikirenie kireu xatatikimana xotikikemu tinikirounuku xati, pa kapiae xiri kokaipa xina. ");
INSERT INTO six_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Pa kapia xotaparei sore, sinie Xoiteure xonikisuwoteneai xuiapu xosa xouxanaunukua, tinipo wenitiki xourorirounuku. Xiwaie kakeri xokupa xu tini xosa moyaire sinie nini kanikirounuku. Paire sinie ipaki kunaunuku, “Tesalonaika kinie sokisoki tumuneri ninipo xonikisu soki tineri pa xokupa xu xeika tatau xeika xemeneri,” xirounuku. ");
INSERT INTO six_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Pa xokupa kapia tini xosa motai paiya. Xoiteue asinaku kapiani kutu kireni kakina nukoe sinipo kapia uteipopouna sini panumu atarisiketai. Tini tatau xemekiriaia, pa amure, tinie Xoiteue xuiapu yakunikepina yause sarepurexinukuna, kakaria pa yause xosa Xoiteue atina yakutikepina. ");
INSERT INTO six_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Xoiteue muanumu asinaku kapiani kutu kakepina. Apimie tini xu tikirouneri paiya nue xu xapa teritikepina. ");
INSERT INTO six_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Kakina nue pa xu ximine tinie xemekiriai xuweiyeinapa, tini xeika sini xeikani arikepi sikepina. Kokaipa Yesusu xeika nupo xokupa sokisoki xenikorokoro xeikae mena xouro wetineri yarani putawopineri yause xosa Xoiteue panumu kakepina. Nue kokaipa xepireini kutu kounapa ");
INSERT INTO six_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","apimie Xoiteu sipawopi xiraxineri, Yesusu sikou Kokaipapu asinaku kuna taiwopu xuweuwoteneaia xaro tinikepuwatixana manimani tinikepina. ");
INSERT INTO six_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Pa apimie panumu kakineria xoxiaki xepineri. Ninie Kokaipa xeika nupo sokisoki kokaipa memeremu xeika wetineri, xetauro purineria sipesi sipesi xoxixepineri. ");
INSERT INTO six_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Xoiteue iyareyai Asau xosa, Kokaipae kouna paiya manimani tinikepina, pana Xoiteupo xokupa xuiapu nini xokupae nure xonikisuwoneaia ninie nupo wenumu xourorineria nure xiri nimaririwopineri. Kakeria tinie rania nini xeika nimaririwakuai, pa amure, sinie tini xopu Xoiteupo kuna uteikiri tinie xiri xotikisukiniai. ");
INSERT INTO six_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Pa sapi putawopure xetaire nanuworinuku, sikou Xoiteu kotoukiri tianitikepinaure sinie xokupa yause kunikunirounuku. Tinie kakakuai kapiaure nukoe yaitikeyai xati nukoe pa kapia xiri atina tianitikepinaure sini xinuku. Nue tini sokisoki tikepinaure sinie kunikunirounukuna, tinipo xotikisue kakati tinie xokupa asinaku kapia kakepure xikiniaia kaka. ");
INSERT INTO six_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Pa kapia xosa tinie Kokaipa Yesusupo wenumu xourorari nue rania tinipo wenitiki xourorepina. Sikou Xoiteu xeika Kokaipa Yesusu Kristusu xeikae tinire xonikisuaxati xonikietikineria pa xokupa kapia tini xosa kakepineri. ");
INSERT INTO six_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Yewapu xura, sikou Kokaipa Yesusu Kristusue, xiyeri koati sini nu xeika kununuwopure sini ximine kunawopure xinuku. Sinipo mua kuna xosa tini atinari xakutiki iyarakuaire xinuku. ");
INSERT INTO six_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Kireu apimie rau katikineri Kokaipapu Asau putawotai xeteneai. Kire apue rau nanuna Xoiteupo Supo Youyae kunatureture kuna ye sietai xepinare, e kire apue Xoiteupo kuna uteina pa kuna kunaunare, e kire apue kunauna sinie panumu kuna purotai sie xosa nakau xayaukiriai xepina. Pana tinie muanumu kuna anayau rau iyesikiriai xatia, tini sapauni xoxi ure ureuweinari tinipo nanunanu ere xaku. ");
INSERT INTO six_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Tini kakixanari kire apu wetari nupo kunare e nuko kaketai kapiaure xoreitikexete. Iyesa. Pa Asau paiya aini mopuwatixe. Xuwe. Xokupa apimie akeri wou erineria Xoiteu nikiniki tuwopineri. Kakeria tu xasese marouna apue yarani mopina, pa apua nu sokisoki xepi xosa xoxixepina. ");
INSERT INTO six_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Apimie xokupa sapi xosa muris tirouneri paiya nue xiwaixiwai nikina ye xoiteu paxinapa weninikepina. Kakina wouerina paiya nukou wenumu xourorina pa xokupa sapi ororepina. Kakina nukoe Xoiteupo ata minika misina paiya, ipaki kuna uteina, “Ye ikoini Xoiteu xepine,” xetai. ");
INSERT INTO six_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Ye tini xeika puritiai yause xosa yei tini pa sapire katikieitiai. Tini nanunanu wetikiriaire, wo? ");
INSERT INTO six_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Ximine pa sapie pa apupo ime parawotai tini sipa, kakatia nu sapauni yaraxepuwatixe. Nu yaraxepina yause paiya Xoiteue iyareyai yause xosa nu putawopina. ");
INSERT INTO six_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Tini sipa, ximine paiya tu sokau porowopi kapia ximiaki purina. Nu ximiaki purati paiyeye, pa apu nupo ime parau purotaie kereu xonopina. ");
INSERT INTO six_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Kakatia pa yause xosa pa tu sokau porourouna apue yarani putawopina. Kakatia Kokaipa Yesusue nukou xa youyae ouwatia xumopina. Kokaipae nukou kokaipa memeremu xeika yarani putauna paiya, pa memeremueni pa apu tu sokou porourouna xiri xoxixoxi wopina. ");
INSERT INTO six_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Pa apu nu tu sokau porowopina paiya Satanipo sokisokie yarani putawopina. Kakinapa Satanipo xorei xorei kapiae xokupa sokisoki saina xeika xonuxonu xeika erepina. ");
INSERT INTO six_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Kakina paiya xokupa xoxi kapiapu xorei xoreie pa xuiapu xoreinikatia xoxixepineri imerei texepineri. Pa xuiapu nini xoxixepineri, pa amure, Xoiteue kunani kutu tinikepina yause xosa, nini xiyeri sonikepina xati, ninie mua kuna xiri xiraxineri. ");
INSERT INTO six_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Pa xati ninie xoreixorei kunaure xonikisuwopinerire, Xoiteue ninipo nanunanu turutaruwetai. ");
INSERT INTO six_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Pa xati xokupa apimie kunani kuture xonikisuwopuxuweuneri, nini xoxi kapia kireni kakepure nimaririwoteneai, nini Xoiteupo kuna xosa tumuwopineri yause xiri manimani tinikepina. ");
INSERT INTO six_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Pana xatai xura, Kokaipae tini xiri xouwetikirouna xati sinie sipesi xosikirei nanunanunuku tinire Xoiteu eiyasewopinuku xinuku. Xoiteue xuiapu xiyeri tinikepure xina tinie akereki xuiapu kini xopu xosa purakuaire akitutiketai. Xoiteupo Supo Youyae tini Xoiteu nukou asinaku xuiapu sie akitutiketai xati, tinie suau kuna xotikisuwari, pa kapiarei Xoiteue xiyeri titikina. ");
INSERT INTO six_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Sikou Kokaipa Yesusu Kristusupo kokaipa memeremu xeika sokisoki xeika xosa purakuaire kakina, pa xati, pa asinaku kuna sinie uteikiniai xosa nue tini yaitiketai. ");
INSERT INTO six_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Pa xati, yewapu xura, tini sokisokini kutu tumuwa. Kakinari Xoiteupo xokupa kuna sinie tini xosa uteikiniaire e taitaitikepure nakau xayaukiniai paiya, tini atinarini kutu taiwa. ");
INSERT INTO six_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Sikou Kokaipa Yesusu Kristusu xeika sikou Emisiki Xoiteu xeikae sini xiri xonikiesikineri. Kakina nupo xousuae xouwesikati sinipo xosikikemu sipesi sipesi yoroni asinaku purina. Kakati xosikisunuku Xoiteu yakukiri xiri atiatisikepinaure tianisikina. ");
INSERT INTO six_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Nue tinipo xotikikemu sokisokiwati paiya, tinie xokupa asinaku kapia xeika asinaku kuna xeika kunawakuaire tianitikepina. ");
INSERT INTO six_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Tesalonaika apimie ouyetutua apimi atineri kutunikepineri 3 Yewapu xura, sini pani kire kuna tuku. Kuna paiya muai. Xoiteue sini tianisikepinaure tinie kunikuniwari, Kokaipapu kunae xokupa sanawayau oupapaina taki xopu kokaipa wenumu teyai sie tepina. ");
INSERT INTO six_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Apimie xoxixoxi kapia kakirouneri xati, tinie Xoiteu xosa kunikuniwari nue apimi xoxi xupunikiropu sini xiyeri tisikepina. Tini sipa, xokupa apimie Kristusu xosa xonikisuworixe. ");
INSERT INTO six_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Pana Kokaipae suau kapiani kutu kakirouna. Pa xati sinie nureni kutu xosikisuwopu itou. Kakari nue tini sokisokitikina yakutikatia, Satanie tini xosa kire kapia kakepuwatixe. ");
INSERT INTO six_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Tinie xokupa kapia kakakuaire sinie katikikiriai sie kakari, Kokaipae kakati sini paire atinuku sipaunuku. Pa xati sewai rania tini panumu kapia kireni kakakuai. ");
INSERT INTO six_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Kokaipae tinipo nanunanu taitaitikati, Xoiteue xuiapu xiri xouweniketaipo kapia xiri sipaunari, Kristusue sokisoki tumuna xu xemerotaipo kapia sipaunariwakuaire xinuku. ");
INSERT INTO six_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Yewapu xura, sikou Kokaipa, Yesus Kristusupo wenumurei sinie tini xosa sokisoki kuna ipaki kunaunuku, kireu xatasikimanae aini purineri pa kuna sinie tikiriai taiwopu xuweurouneria, tini weniki xetauro pura. ");
INSERT INTO six_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Tini sipa, tini sinipo kapiani kutu taiwa. Sinie tini xeika purikiriai yause xosa, sini aini puriroukiri xana xuwe. ");
INSERT INTO six_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Sinie tini xuputikiropu xoye aini tekixe. Xuwe. Sini isayaxirounuku. Sinie tini xu tepi xirarinuku, sokisoki saina tinuku asau ukumu irereiwowoukiriai. ");
INSERT INTO six_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Sinie tini xosa xoye tepu xuweuwopinuku sie xuwe. Sini xoye tepinukuni kutu itouna pana sini tepu xuwe, pa amure, takieni asinaku kapia taiwakuaire sini ataritikinuku. ");
INSERT INTO six_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Tini sipa, sini taki xeikani purikiriai yause xosa, tini ipaki katikinuku, apue saina tepu xiraxina paiya, nu xoye tepuwatixana xuwe xikiriai. ");
INSERT INTO six_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Pana kireu tini xosaupoe aini ouye purori sini pa kuna iyesinuku. Ninie kire saina terixe. Nini kireu apimi nikau xokupa sapire kunau xanauwopi saina kireni tineri, paiya ninipo sapi xuwe. ");
INSERT INTO six_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Pa xati ximine Kokaipa Yesusu Kristusupo wenumurei sinie pa apimi mua sokisoki kuna ipaki kanikinuku, nini atinerini kutu misineri, saina tineri, nikou xoye sapini nepineri. ");
INSERT INTO six_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Yewapu xura, tini kakixanari asinaku kapia kakepire ouyexaku. ");
INSERT INTO six_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Sinie mua xokupa kuna nakau xosa xayaukiriai kire apue taiwopu xuweuna paiya, pa apu ati tumuworinari tini weu xetauro purari, nuko kaketai kapiaure mayaxepina. ");
INSERT INTO six_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Paiya tini nupo xiwai xinari nanuwakuaire sini kunaukirixe. Xuwe. Sinipo xatasiki xinari, nupo nanunanu kutuwakuaire kuna tuwakuai. ");
INSERT INTO six_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Kokaipa nu xoukemu yorowopi kapia xotapa, nue sipesi kakatia tinie xokupa sapi xosa xotikikemu yoroni purakuai. Kokaipae tini xokupa xeika puropina. ");
INSERT INTO six_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Ye Polu ye ikoini mua kuso kuna tini xosa xayaune. Ye nakau xayaunepa muanumu kuna xokupa nakau xosa xayauroune. Muaia ye yekuworitiai xupisui. ");
INSERT INTO six_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Sikou Kokaipa Yesusu Kristusue xousuaxati xouwesikirouna kapiae tini xokupa xeika puropina.");
INSERT INTO six_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1"," Pilemonipo aipu saina apue ximi xoworina xurise Yesusupo apu sayati Polue Pilemoni xosa xiyeri xesawotai Ye Polu, ye Yesusu Kristusupo kakauya apu. Ye xeika sikou xatasiki Timoti xeikae, mua nakau ne Pilemoni xosa xayaunua, ne sinipo asinaku marou xeika saina emesiki xeika. ");
INSERT INTO six_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Sinipo ukusiki Apia xosa rania mua nakau xayaunua, Arkipusi xosa rania xayaunua, sikoe mua Xoiteupo xoma xosa purikiriai xosa nue xomatua purina. Pa xeika Yesusure xonikisuneri taiwoteneai xuiapue neu atoro kununurouneri xosa xayaunua. ");
INSERT INTO six_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Sikou Xoiteu Emisiki xeika Kokaipa Yesusu Kristusu xeikae xonikisuaxete xonikietiketewori tinipo xotikikemu yoroni puropina. ");
INSERT INTO six_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Xokupa yause ye yeu Xoiteu xosa kunikuninepa, ye neure nanunanune Xoiteu xosa eiyaseuroune, ");
INSERT INTO six_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","pa amure, ninie ye sipesi ipaki kairouneri, nei Kokaipa Yesusu xonikemu tune nure xiri xonisune, Xoiteupo xokupa xuiapu xonienikiroune xirouneri. ");
INSERT INTO six_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Ne sini xeika etokau sini Kristusure xosikisukiriai xati, sikou xosikisu xosa Xoiteue kakati sikou asinaku sipa yararatia Kristusu xosa xokupa asinaku sapi tirounuku ati sipawopure ye kunikunine. ");
INSERT INTO six_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Iyo, yewapu, nei Xoiteupo xokupa xuiapu xonienikiroune xati, pa kapiarei ninipo xonikikemu nei sokisokinikitiai. Nei kakau paire ye xiri nimaririti yeu xoikemu yoroarani purina. ");
INSERT INTO six_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Ne kire sapi kakewaire ye kunaunena, Kristusu wenumurei kaniti ne pa sapi kakewairau. Pana neu kapia asinaku asinaku ye sipa xati, ");
INSERT INTO six_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ye ne sokisoki kuna kanepixe xi nanune. Kireu xiri xonikiewopi kapiae sini axirini paraisirouna, pa xati ye ne yopini kanepurexine. Ye Polu, ye Kristusu Yesusupo kuna tikoutiai apu xati mua Kristusupo saina xosa sakau xine ye rania kakauya xosa purine, ");
INSERT INTO six_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","yeu nono Onesimusi xosa, asinaku kapia kakewaire ye ne kotonepurexine. Ye kakauya xosa puritiai yause xosa, Onesimusue kouyeyati Kristusure xiri xousuwopinaure tianutiai. Pa xati ye kunaune, nue yeu nononi kutu sayetai. ");
INSERT INTO six_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Ekime nue atina ne saina tianirouwati xana xuwe. Pana muaia nu sio axirini saina tianisiepina sie itou. ");
INSERT INTO six_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Ximine yeu xoikemueni nu xesauti, ne xosa xiyeri utuna. ");
INSERT INTO six_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Yei nu taiyeruti ye xeika puropina rania ye xiri nimaririwopine, ye kakitia nue neu sainani tina paiya, ye asinaku kuna uteiwopi sainapu kakauya apu puritiai yause xosa tianiyepina. ");
INSERT INTO six_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Pana paire ne iyo kuna kunawauweyexine, pa xati ye nu taiyeruixe. Nei amu sapirau kakewaire ye kanepi xiraxine. Xuwe. Ye nanutiaia, nei ye tianiyepure asinaku kapia kakepurexinaua, xeuxana nakipo xonieni kakewai. ");
INSERT INTO six_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Suau, Onesimusue xayaka xayaka weinitetai. Pana mua kapia yaraxetai paiya, nei nu xiyeri sowau, ne xeika sipesi puropinarau. ");
INSERT INTO six_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Muaia nei nanunau nu aipu saina apu xeu. Xuwe. Suau, nu neu aipu saina apu purotaina pana, muaia neu xatanini kutu sayati nei xiri xoniewowai. Nue yeu xataini kutu puriewati xekeuroune xati nu xosa yeu xoikemu tune. Pana ye sipa, nei nu xiri xoniewowai. Nue aipu saina apue kakiewati kapia xoniewowai, Kristusu xosa paiya xatanini kutu xekeuyeunaua, nu xiri xoniewowai. ");
INSERT INTO six_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Pa xati ne ye xekeyau Kristusupo saina xosa ye neu emenini kutu sie xitia, paina iko titiai kapia sieni Onesimusi xiyeri tewai. ");
INSERT INTO six_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Nu kireu kapia xoreiyeretaire e ne xosa xapa tuku xatia, paina nupo wenumu pirixinau pa xapa xosa yeu wenimi iyarewai. ");
INSERT INTO six_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Ye Polu, ye ikou xupieni mua kuna xayautiai. Ye ikoini pa sapi xapa iyarepine. Ye ipakine rania kunaune ne ye xosa xapa tuku, paiya nakipo ekiniomapu xapa. Pana ye paire kunawopi xiraxine. ");
INSERT INTO six_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Xatai, iyese. Kokaipapu wenumurei nei pa asinaku kapia ye xosai kakewai. Sini Kristusupo apu purinua, pa xati pa kapiarei ne yeu xoikemu asinakuworewai. ");
INSERT INTO six_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Nei yeu mua kuna taiwowai xati ye panumu ati sipautiai, pa xati mua nakau ne xosa xayaune. Ye sipa, nei Onesimusi xosa kakewai kapia paiya, nei kakewai xine mua yei kotonitiai kapia xiri emeseriwopina. ");
INSERT INTO six_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Ye pani kire kuna tuku. Ye ipakine xoisutiaia Xoiteue tinipo kunikuni iyeserina paiya ye weitati tini xosa xiyeri utopine. Pa xati neu atoro xinepineure ye kire ata kama ireiyeriyewai. ");
INSERT INTO six_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epaprasie ne kusonina. Nu kakauya xosa purati, sioxororoni Kristusu Yesusupo kakauya xosa purinua. ");
INSERT INTO six_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Yeu emeimana, paiya Maki xuno Aristakusi xuno Temasi xuno, Luku xuno, ninie rania ne kuso tinineri. ");
INSERT INTO six_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Kokaipa Yesusu Kristusue xousuawati xouwetiketai kapia tini xeika purina.");
INSERT INTO six_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1"," Sini memeremu xosa texepuna ukumu xosaupo apimi kini weinikitikiri xoreisikexeni 1.1—3.10 Sinie kuna ekeoma tukupo kuna uteirounuku. Mua kuna paiya ekimeni kutu puroyai xati, sinie iyeserinuku, ekisikie xekeukiriai. Sinie nu xekerinuku nu xosa xupusiki iyarikiriai. ");
INSERT INTO six_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Mua ekisikiomae yarani putauwoyai xati, sinie xekerinuku, paire kuna uteirounuku. Pa ekisikomae atina sipesi sipesi purotaire sinie tini xosa kunaunuku. Ekime nue nupo Omo xeika puroyaie yarani putawati ekeukiriai. ");
INSERT INTO six_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Sinie xekeri iyesikiriai xati, tinie sini xeika xosikikemu tumaxi puropure tini xosa rania, kuna uteirounuku. Pa xati nupo Omo xeika, Nukou Nirau Yesusu Kristusu xeika kirenini xosikikemu tumaxi purinuku. ");
INSERT INTO six_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Sikou nimariri xiri xokopexepinaure sinie mua nakau xayaukiriai. ");
INSERT INTO six_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Yesusu Kristusue kuna uteiwati iyeserinuku, sinie tini xosa uteinuku. Pa kuna muanumu, Xoiteu nu memeremu xati, xayakaxayaka kire ukumu nu xosa puratixe. ");
INSERT INTO six_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Sini kunaunuku, “Ye nu xeika kirenini xoikemu tumaxine,” xepinena pana sini ukumu xosa texinukua, sinipo mua kuna paiya xorei kuna xati, sini suau kapiarei texikirixe. ");
INSERT INTO six_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Pana nuko memeremu xosa purotai sieni, sini memeremu xosa texinukua, sini Xoiteupo kireu xuiapu xeika xosikikemu kirenini tumaxi purinuku. Pa xati Xoiteupo Nono, nu Yesusu, nupo yawie sikou xokupa xunu xesauwati xosei sairounuku. ");
INSERT INTO six_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Sini kunaunuku, “Ye xunu xuwe,” xirounukuna pana sini sikou xosikikemu xoreunuku xati, suau kuna xosikiro puratixe. ");
INSERT INTO six_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Pana sini sikou xunure kunauweikiria Xoiteu nukoe kunawoyai sie panumu kakepina. Nue asinaku kutu kapia kakinapa sikou xunu wetepina. Kakina xokupa kapia xoxi siko xosa purotai xesauwatia xosei puropu. ");
INSERT INTO six_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Sini kunaunuku, “ye xunu eriyaixe,” xepuna pana pa kuna paie kunaunuku Xoiteu nu xoreitua xinuku. Pa xati Xoiteupo kuna xosikiro puratixana xuwe. ");
INSERT INTO six_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Tini yeu nono misiarara xura, tini xunu erepu xuweuwakuaire, mua kuna tini xosa xayaune. Kire apue xunu eratia, sini sikou tianisikepi tuku, nu nupo Omo xeika purina. Nu siko xopuropu apu nu Yesusu Kristusu, pa apue asinaku kutu kapiani kutu kakepina. ");
INSERT INTO six_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Nue nukoini sikou xunu xesawopure saina teyai. Nue sini kireni tianisikepure mua saina teyaixe. Xuwe. Xokupa xuiapu ouro puroteneai tianikepure kakeyai. ");
INSERT INTO six_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Sini Xoiteupo kunani kutu tainukua nu sipaukiriaire xiri atinuku sipawopu. ");
INSERT INTO six_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Kire apue kunauna, “Ye Xoiteu sipani kutu,” xepina. Pana nu Xoiteupo kunani kutu taiwopu xuweuna paiya, pa apu nu xoreitua xati, nupo xoukemuro kunani kutu puratixe. ");
INSERT INTO six_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Kire apue Xoiteupo kuna taina paiya, nu nupo xoukemu Xoiteu tuwopi xiri sipa xati, sini panumu kapiarei, Xoiteu xeika etokinuku. ");
INSERT INTO six_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Kire apue kunauna, “Ye Xoiteu xeika etokine xinapa,” paina pa apua nu Kristusue texeyai sieni texepina. ");
INSERT INTO six_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Yeu waukia xura, mua Xoiteupo kuna tini xosa xayautiai paiya oma kunaxe. Xuwe. Paiya ekime takieni kutu tikiniai kuna. Pa xipiki kuna paiya takieni iyesikiniai. ");
INSERT INTO six_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Pana mua kuna tini xosa xayautiai, pa rania oma kuna xati, Kristusupo ekeoma xeika tinipo ekitikioma xeika xosa rania pa suau, pa amure, ukumu xuwexepure xati memeremuni kutu putawotai purina. ");
INSERT INTO six_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Kire apue kunauna, “Ye memeremu xosa purine,” xepina, pana kire xatau xosa xoukemu xoxixina paiya, pa apu nu ukumu xosauni purina. ");
INSERT INTO six_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Apue xatau xoukemu turouna paiya, nu memeremu xosa purirouna. Memeremu xosa paiya kire sapie kakati nu uraki xowopina puratixe. ");
INSERT INTO six_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Pana apue kire xatau, nu xosa xoukemu xoxirouna paiya, nu ukumu xosa purina. Nu ukumu xosa texina amu ime tainarau nu sipa xuwe. Nu ukumue eke paraeki. ");
INSERT INTO six_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Tini yeu nono misiarara, Xoiteue Kristusupo wenumurei tinipo xunu weteritiketai. Pa xati ye tini xosa mua kuna xayaune. ");
INSERT INTO six_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Tini xauwa xura, tini sipani kutu pa apu nu ekimeni kutu puroyai mua pani purina. Pa xati tini xosa mua kuna xayaune. Tini apimi tenemai xura, tini Satani emeserukiriai. Pa xati tini xosa mua kuna xayaune. ");
INSERT INTO six_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Nono xura, tini Emisiki sipani kutu. Pa xati tini xosa mua kuna xayaune. Tini xauwa xura, tini sipani kutu pa apu nu ekimeni kutu puroyai xati mua pani purina. Pa xati tini xosa ye mua kuna xayaune. Tini apu tenemai, tini sokisoki tuku xati, Xoiteupo kuna tini xosa sokisoki purati, Satani emeserukiriai. Pa xati ye mua kuna tini xosa xayaune. ");
INSERT INTO six_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Tini ouropu kapia kapia xotikiewoto xokupa ouropu sapi xotikiewotowaku. Kire apue ouropu kapia xouweunapa nu Xauwa xiri xouweurouwatixe. ");
INSERT INTO six_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Siko sipa, ouropu apimi nikau xokupa kapia paiya, xonikikemu sarepi kapia xeika ekiniki nepi kapia xeika niko xokupa sapire totoniki ouwopi xeikauneri. Pana xokupa kapia paiya Emisikirei koatixe. Xuwe. Paiya nini ouropu kapia kireni. ");
INSERT INTO six_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Mua ou xuwe xatia, mua ouropu xokupa kapia, paiya xosikikemu saropi kapia xeika ekisikienepi xeika rania xirini xuwexepineri. Pana kire apue Xoiteue xouweuwotai kapia taina paiya nu sipesi puropina. ");
INSERT INTO six_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Yeu nonomi, sini xurisepu asau xosa putaurounuku. Kristusupo xiwayau kopinaxi kuna ekime iyesikiniai. Ximine Kristusupo xokupa xiwaiyaumana kouweteneai. Pa xati siko sipa, sini xurisepu asaupo yause xosa putaukiriai. ");
INSERT INTO six_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Ximuximu pa apimie siko xeika puroneaie, wesiki xowoneai. Pana ninie sikou kini kutu xosauni puropu xuwe. Nini sikouni kutu xakua, nini siko xeikani puraku. Pana muaia siko weisikiteneai, pa xati ati sipaunuku, pa apimi paiya nini sikouni kutu xuwe. ");
INSERT INTO six_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Tinie Xoiteupo Supo Youya tieikiriai xati, tini xokupa sipa tuku. ");
INSERT INTO six_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Pa xati tini kunani kutu sipa xuwexi nanuworine mua kuna tini xosa xayauixe. Xuwe. Ye xayautiaia, pa amure, tinie suau kuna sipauweikiriai xati, suau kunae xorei kuna yararepu xuweuwopina paiya tini sipa. ");
INSERT INTO six_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Xoreixepina apu nu yuna? Paiya pa apu nu kunauna, “Xoiteue nukou xuiapu xiyeri tinikepure tumuworetai apu paiya Yesusu xana xuwexi,” kunaurouna. Apue pa kuna kunawotaia, nue Emisiki xeika Nirau xeika nike tinikirouna, pa xati nu Kristusupo xiwai. ");
INSERT INTO six_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Apue Nono nike tuna paiya Omo rania nike tuna. Apue Nonoure xousuna paiya, nu Omoure rania xousuna. ");
INSERT INTO six_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Ekime tinie pa kuna iyesikiniai paiya, tini sokisoki ta. Tini ekime tikiniai kuna sokisoki tinari paiya, Nono xeika Omo xeikae tini xeika sipesi puropineri. ");
INSERT INTO six_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Kristusue siko sokisoki kuna ipaki kasikina, tini sipesi atinari purakuai ekitikioma tikepine xeyai. ");
INSERT INTO six_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Tini xoreitikepure xeteneai apimi nikau kapiaure tini katikepure mua kuna tini xosa xayaune. ");
INSERT INTO six_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Pana tinie Kristusu xosaupo Xoiteupo Supo Youya tieikiriai xati, nue tini xeikani purina. Pa xati tini sipa xuweitautikati xati, ye tini taitaitikepixe. Xuwe. Xoiteupo Supo Youyaini tini taitaitikirouna xati, pa Youyapu kuna paiya xiri suau. Nu xoreixatixe. Pa xati tini Youyae taitaitiketai sie Kristusu xeika etoka. ");
INSERT INTO six_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Iyo, yeu nono xura, tini Kristusu xeikani kutu etoka. Kakari nue sosikepure xiyeri koatia sini sokisoki tumunukua, nu ekero mayarei tumuwopuxe. ");
INSERT INTO six_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Kristusupo kapia xiri asinakuni kutuxi panumu sipaunaria, xokupa apimie asinaku kutu kapia kaketeneaie, Xoiteupo nono sayeteneai xinari rania panumu sipawakuai. ");
INSERT INTO six_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Xawa xura, Xauwae sini xouwesikerina nupo xoukemu sikeki sikekina! Sini Xoiteupo nonomixi nue wenisikeyai. Paiya suauni kutu, sini Xoiteupo nonomi purinuku. Ouropu apimie Xoiteu sipawoneai xana xuwe, pa xati siko rania sipasikerixe. ");
INSERT INTO six_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Waukia xura, ximine sini Xoiteupo nonomi purinuku. Sewai sini amaki puropua pa sini xemu sipaukirixe. Pana siko sipa, Kristusue yara putawopina yause xosa, sikoe suauni kutu xekeunukua, sini nuko sieni xepu. ");
INSERT INTO six_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Pa xati, yue Kristusu nukou siexepurexineria, nini kapia kutu asinaku tairouneri. Pa xati Kristusue xosei purotai sie nini rania xosei purineri. ");
INSERT INTO six_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Apue xunu eretaia nu Xoiteupo tu sokau porouna. Xunu paiya tu sokau porowopi kapia. ");
INSERT INTO six_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Tini sipa, Kristusue xunu xesauwepure putawoyai xati, nu xosa xunu puratixe. ");
INSERT INTO six_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Apue Kristusu xeika etokina paiya, nu xunupo kapia tairouwatixe. Kire apue xunupo kapia taina paiya, nu Kristusu xekoyai xana xuwexi sipawopu, pa xeika nu Kristusu sipa xuwe xepu. ");
INSERT INTO six_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Tini yeu nono misiarara xura, tini sosopa epixakuai, panumu kire apue xoreitikexete. Apue asinaku kutu kapia kakatia, nu apu asinaku kutu, nu Apu Kristusu asinaku kutu sie. ");
INSERT INTO six_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Ximuximu ekimeni kutu xosa, Satanie sipesi xunu erirouna, pa xati apue xunu erirouna paiya nu Satanipo apu. Pa xati Xoiteupo Nonoe Satanipo saina purieina xesauwepure yarani putawoyai. ");
INSERT INTO six_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Kire apue Xoiteupo nono saina paiya, nu xunupo kapia tairouwatixana xuwe. Xoiteupo ekeomani pa apu xosa purina, pa xati nue xunupo kapia taiwopuwatixe. Xuwe. Nu Xoiteupo nono purina. ");
INSERT INTO six_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Yue Xoiteupo nono xati yue Satanipo nono xinuku sipawopurepa, apue asinaku kutu kapia kakepu xuweuwatia, nu Xoiteupo nono xuwexi sipawopu. Pa xeika apue Xoiteupo kireu nonomi xiri xouwenikepi xuweurouna rania nu Xoiteupo xuwe xepu. ");
INSERT INTO six_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Sini kirenikirenie kireu xiri xosikienikepu 3.11—5.21 Sini kirenikirenie kireu xiri xosikienikepu xetai kuna paiya ximuximuni kutu tinie pa kuna iyesikiniai. ");
INSERT INTO six_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Sini Keini sie puropuxe. Nu Satanipo apu xati xameyau ouweyai. Ama nupo xameyau ouweyaina? Xameyau ouweyaia, amure, nukou kapia xoxi xati, xameyaupo kapia asinaku kutu xati ouweyai. ");
INSERT INTO six_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Xatai xura, ouropu apimie xiwaixiwaitikeria, tini paire kakixanari xoxi ure urewaku. ");
INSERT INTO six_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Sini Xoiteupo kireu xuiapu xosa xosikikemu tinikirounuku, pa xati siko sipa, sini xumopipo kapia wetikiriai xati, ekisikiomapu kapia xosa purinuku. Apue xataumana xoukemu tinikepu xuweurouna paiya, nu xumopipo kapia xosauni purina. ");
INSERT INTO six_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Apu xatau xiri xouwewopu xuweuna xoukemu xoxixoxixina paiya, nu apu ouwetai siexina. Pa xati tini sipa, apue kire apu ouweina paiya, nu sipesi sipesi ati puropina ekeoma tatixe. ");
INSERT INTO six_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Yesusue siko tianisikepure nukou ekeomani wetina xumotai xati, nupo pa kapia paie kireu xiri xosikienikepi kapia atarisiketai. Pa xati sinie rania xatasikimanae Yesusu taiwoteneai tianikepure ekisikioma wetepu. ");
INSERT INTO six_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Pana kire apu nu mua ouropu sapi tukue, kire xatau xekoati xuruara xuweitauwati, nu pa xataure xousuawopu xuweunapa siko sipa, Xoiteue kireu xouwenikirouna kapia pa apu xosa puratixe. ");
INSERT INTO six_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Tini yeu nono misiarara, sini xatasikimana kuna kireniere e supusikie kireni xosikienikepuxe. Xuwe. Sini sikou xosikikemuni kutu tinikinuku asinaku kapia nini xosa kakepu. ");
INSERT INTO six_vpl VALUES ("J13_19","092_3_19","1JN","3","19","20","Sini kireu xiri xosikienikinukua, sini suau kuna tainuku xinukua sipawopu. Sikou xosikie kire sapire kuna xosa iyaisikerepina sorena, Xoiteu ekero sini yoroara puropu. Pa amure, Xoiteu nu xokupa sapi sipa xati, nupo sipae sikou xosikiro purotai sipa xiri orouna. ");
INSERT INTO six_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Waukia xura, sikou xosikie kuna xosa iyaisikerepu xuweuwatia, sini Xoiteu ekero sokisoki tumurounuku. ");
INSERT INTO six_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Kire sapire kunikuninuku nu kotoukiria, nue sikirouna, pa amure, sikoe nupo kuna tainuku, nue xouwewotai kapia kakirounuku. ");
INSERT INTO six_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Pa xati nupo tu paiya muanumu. Sini nupo Nono Yesusu Kristusu wenumurei xosikisunuku, nukoe siko kasikeyai sie siko kireni kirenie kireu xiri xosikienikepu. ");
INSERT INTO six_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Kire apue Xoiteupo kuna taina paiya, nue Xoiteu xeika etokati, Xoiteue nu xeika etokina. Xoiteue Xoiteupo Supo Youya siko sikati, Xoiteue siko xeika purinaxi, pa Youyae siko atarisikina. ");
INSERT INTO six_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Waukia xura, xokupa xoreixoreitua kunatureturei ouro tei xanauneri. Pa xati xokupa apimie tini xosa maneri kunauneri, “Xoiteupo Supo Youyae ye kuna sietai,” xatia kakixanari tini xotikisuwaku. Xuwe. Tini xokupa youya erurunari sipauweinarieye, nini Xoiteurei koteneaire e xuwerau paiya sipawakuai. ");
INSERT INTO six_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Takipo kapiae sipaunapa, Xoiteupo Youya paia muanumu xepina. Apue kunauna, “Yesusu Kristusue apuni kutu sayetai,” xirouna paiya Xoiteupo Youyae pa apu xosa purina. ");
INSERT INTO six_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Apue Yesusure muanumu kuna kunawopu xuweuna paiya, pa apu nu xetau youya tuku, nu Xoiteurei koatixe. Paiya Kristusupo xiwaipo youya, ekime takie kopina kuna iyesikiniai. Ximine nu kourotai ouro purina. ");
INSERT INTO six_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Yeu nono misiarara xura, tini Xoiteupo xati, tinie pa xoreixorei kunatureture xoronikieikiniai, pa amure, pa Youya tini xotikiro purotai paie ouropu apimi nikau xonikiro purotai youya orouna. ");
INSERT INTO six_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Pa apimie nini ouropu apimi. Pa xati ninipo kuna paiya ouropu kireni xati, ouropu apimie ninipo kuna iyesirouneri. ");
INSERT INTO six_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Pana sini paiya Xoiteupo xati, Xoiteu sipa apimie sinipo kuna iyesinouneri. Pana apu Xoiteupo xuwe paiya, nue sikou kuna iyesirouwatixe. Pa kapiarei sini suau kunapu Youya xeika xoreixoreipo youya xeika sipawopu. ");
INSERT INTO six_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Waukia xura, sini kirenikirenie xatasikimana xiri xosikienikepu, pa amure, kireu xosikienikepi kapia paiya Xoiteupo kapia. Pa xati apue kireu xiri xouweniketai paiya, nu Xoiteupo nono xati, nu Xoiteu sipani kutu. ");
INSERT INTO six_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Xoiteu nukoini kireu xonikikiewopi kapia xotapa, pa xati apue kireu xouwenikepi xuweurouna paiya, nu Xoiteu sipa xuwe. ");
INSERT INTO six_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Xoiteu nu Nono kireni tuku xati, siko nu xosa ekisikioma tepure, pa Nono xesawati ouro koyai. Pa kapiarei Xoiteu nukoe sini xiri xouwesiketaie atarisikina. ");
INSERT INTO six_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Kireu xonikiewopi kapia paiya, Xoiteupo kapia. Sini nanunuku ximuximuni sinie Xoiteu xosikieukiniai xepuxe. Xuwe. Xoiteue akerina sini xouwesikeyai. Pa xati sikou xunu wetepure, nue nupo Sawai Nono xesawati ouro koyai. ");
INSERT INTO six_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Waukia xura, nupo kapia paie Xoiteue siko xiri xouwesiketaire atarisiketai. Pa xati sini kirenikirenie kireu xiri xosikienikepu. ");
INSERT INTO six_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Kire apue Xoiteu xekoyaixe. Pana sini kireu xiri xosikienikinukua, Xoiteue siko xeika purati, nupo kireu xonikiewopi kapiae, sikou ekisikioma xosa sokisokietai. ");
INSERT INTO six_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Xoiteue sini xeika etokati sinie nu xeika etokepua, sini amakinuku sipawopuna? Sini paire sipa, pa amure, sini nue nukou Youyani sikeyai. ");
INSERT INTO six_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Emisikie kakeyai kapia sikoe xekeukiniai. Nue ouropu xokupa xuiapu xiyeri tinikepure nukou Nono xesawati koyai xati, pa kapiaure sini kuna uteirounuku. ");
INSERT INTO six_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Kire apue kunauna, “Yesusu nu Xoiteupo Nono xinapa,” Xoiteue pa apu xeika etokati, nue Xoiteu xeika etokina. ");
INSERT INTO six_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Paire siko sipa xati ipaki sokisoki xosikisunuku, Xoiteue siko xiri xouwesikati, nupo pa kapiae sikou ekisikioma xosa purina. Xoiteu nukoini kireu xiri xosikienikepi kapia xotapa. Pa xati apue kireu xiri xouwenikirounae Xoiteu xeika etokati, Xoiteue nu xeika etokina. ");
INSERT INTO six_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Sini panumu purinukua, kireu xosikienikepi kapiae sikou ekisikioma xosa sokisokietai. Pa xati Xoiteupo kokaipa kunapu asaure ximikepuxe. Suau, sini mua ouro purinukuna pana, sini Kristusu nuko sieni purinuku xati, sini ximikepuxe. ");
INSERT INTO six_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Kireu xonikieurouneri xuiapue Xoiteure ximikiroworixe. Ximiketeneai xuiapu kini nini sipa, nini pa kapia xapa xoxi tepineri xati, pa nanunanue kakati Xoiteure ximikineri nini kireu xonikiewopi kapia sokisoki xineri paiya, nini Xoiteure ximikepuworixe. Kire apue Xoiteure ximikirouna paiya, kireu xouwenikepi kapiae pa nupo ekeoma xosa sokisoki xatixe. ");
INSERT INTO six_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Sini Xoiteu xosikieunuku kireu xosikienikinuku paiya amure, Xoiteue ximuximuni siko xouwesikeyai xati kakirounuku. ");
INSERT INTO six_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Kire apue kunauna, “Ye Xoiteu xiri xoieune xepina,” pana Xoiteupo xuiapu xosaupo kire apu xouwewopu xuweuna paiya, pa apu nu xoreixoreitua. Kire apue Xoiteu xekoyaixe. Pa xati apue xekenikieyai xuiapu xouwenikepu xuweuna paiya, nu xekopu xuweuwoyai Xoiteue xekopuwati xana xuwe. ");
INSERT INTO six_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Mua kuna Kristusu xosaupo tikiniai, paiya muanumu. Apue Xoiteu xiri xouweurouna paiya, nu Xoiteupo kireu xuiapu xiri xouwenikepina. ");
INSERT INTO six_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Xoiteue nukou xuiapu xiyeri tinikepure tumuworetai apu nu Yesusu xati xokupa xuiapue nure xonikisuneria, nini Xoiteupo nonomi puropineri. Xokupa apimie Eminiki xonikieuneria, nupo niraumana rania xonikieurouneri. ");
INSERT INTO six_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Sini Xoiteu xiri xosikieunuku nupo xokupa kuna tainuku, pa kapiarei sipaunukua sini Xoiteupo nonomi xiri xosikienikinuku xepu. ");
INSERT INTO six_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Sini Xoiteu xiri xosikieunukua, sini nupo xokupa kuna tairounuku. Pa xati nupo xokupa kunae sini xu sikerixe. ");
INSERT INTO six_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Xokupa apimie Xoiteupo nono puroteneaia, ninie mua ouropu sokisoki orouneri. Sini Xoiteure xosikisunuku xati, pa kapiarei xomaxinuku mua ouropu sokisoki orourounuku. ");
INSERT INTO six_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Yue mua ouropo sokisoki orourounana? Apue Xoiteupo Nono nu Yesusure xousuna paiya, pa apue orourouna. ");
INSERT INTO six_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Yesusu Kristusue enero ene isepi kapiaure koto, nupo yawi na nikitoto xosa kusawopina kapiaure kotowoyai. Nue enepu kapia kirenire koyaixe. Xuwe. Nu ene xeika yawi xeikapu kapiaure koyai. Xoiteupo Supo Youya nu suau kunapu xotapa xati, Xoiteupo Supo Youyae Yesusu Kristusupo kapiaure kuna uteirouna. ");
INSERT INTO six_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Xeimorei purineri nupo kapiaure kunauwoteneai, ");
INSERT INTO six_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","paiya nini Xoiteupo Supo Youya xeika ene xeika yawi xeikae kaketeneai. Nini xeimorei kirenie kuna kireni kunawoteneai. ");
INSERT INTO six_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Apue uteirouneri kuna sikoe xosikisurounuku. Pana Xoiteue uteiwotai kuna paie, apu nikau kuna xiri oronikina. Pa kuna Xoiteue uteiyetai paiya, nukou Nonoure kunawoyai. ");
INSERT INTO six_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Apue Xoiteupo Nonoure xousurounae Xoiteue pa kuna uteiwoyai tietai xati, pa kuna nupo xouro purina. Pana apue Xoiteupo kuna xousuwopu xuweunapa, nue Xoiteu nu xoreixoreituaiyeuna, pa amure, Xoiteue nukou Nonopu kapiaure kuna uteiwoyaire xousuwatixe. ");
INSERT INTO six_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Pa kapiarei Xoiteue nukou kuna suauxi atarisikina. Xoiteue sipesi sipesi puropu ekisikioma sikeyai xati, pa ekisikiomapu xotapa paiya nukou Nono xosa purina. ");
INSERT INTO six_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Apue Xoiteupo Nono xeika etokina paiya, nu pa ekeoma tuku. Apue Xoiteupo Nono xeika etokepu xuweuna paiya, nu pa ekeoma xuwe. ");
INSERT INTO six_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Tini xuiapue Xoiteupo Nonopu wenumurei xotikisurounuku xosa mua kuna xayaune. Tini sipesi sipesi purakuaire ekitikioma tieikiriaire sipawakuai. ");
INSERT INTO six_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Sini Xoiteu nukoe xouwewotai nanunanu tainuku kire sapire kunikuninuku kotounukua, nue sikou kunikuni iyesirouna. Pa xati sini Xoiteure ximikiroukirixe. Xuwe. Sini nuko nutiemu xonarounuku. ");
INSERT INTO six_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Siko sipa, nue sikou xokupa kunikuni iyesirouna. Pa xati nue kire sapi sikepinaure kotounukua, siko sipa pa sapini kutu tepu. ");
INSERT INTO six_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Kire apue xekoati kire xatau Yesusu taiwotaie xunu erati, pa xunue kakati pa apu xumopu xuweuwopina xatia, pa apu nukoini Xoiteu xosa kunikuniwati, Xoiteue pa xatasiki ekeoma tuwopina. Apue xumopi xuweuwopineri xunu erineri xumopu xuweuwopinerire ye kunaune. Apue xunu erineri xumopineri xunu purinana, tini paire kunikuniwakuai xine ye kunautixe. ");
INSERT INTO six_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Xokupa kapia asinaku kutu xuweu paiya xunu. Pana apu xumopu xuweurouneri xunu paiya purina. ");
INSERT INTO six_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Siko sipa, xokupa apimie Xoiteupo nonomi purineria, ninie xunupo kapia tairouworixe. Xuwe. Apue Xoiteupo nono purotaia Xoiteue ati yakurouna xati, Satanie nu xosa xupo iyarepuwatixe. ");
INSERT INTO six_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Siko sipa, siko Xoiteupo nonomi purinuku sorena, mua ou xokupa paiya Satanipo sokisoki irue purina. ");
INSERT INTO six_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Siko sipa, Xoiteupo Nono kourotai xati, sikoe Xoiteuni kutu sipawopure, nue nanunanu sikina. Sini Xoiteuni kutu xeika Nirau Yesusu Kristusu xeika etokinuku. Yesusu Kristusu paiya nu Xoiteuni kutu xati, nue ekisikioma atinuku sipesi sipesi puropu xotapa. ");
INSERT INTO six_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Yeu nono misiarara xura, tini xokupa xoreixorei xoiteu weinikiterinari xetauroni pura.");
INSERT INTO six_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1"," Sini Xoiteupo kunani kutu sokisoki tinuku apimie xetau xonuxonu kuna uteiwoteneaire sosopa epixepu Ye Yesusure xonikisuwoteneai xuiapu nikau tumu, ne xui naki xeika neu nono teu xeika xosa mua nakau xayaune. Xoiteue ne nukouni tumuneretai xati, ye suauni kutu kunaune, yei tini xiri xoietikine. Paiye kirenixe. Xuwe. Suau kuna sipani kutu xuiapue tini xiri xonikietikineri. ");
INSERT INTO six_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","Suau kuna siko xosa purinana, nue sipesi siko xosa puropina, pa xati sinie tini xiri xosikietikinuku. ");
INSERT INTO six_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Suau kunapu kapia xeika kireu xosikienikepi kapia xeika paiya, Xoiteu xeika Yesusu xeika xosaniki purina. Pa xati Xauwa Xoiteu xeika Xoiteupo Nono Kristusu Yesusu xeikae ninire xonikisuwoxati xonikienikineri, siko xosa xonikemu yororoneri. ");
INSERT INTO six_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Emisikie kunauna taiwa xeyai sie neu kireu nonomie suau kuna tairounerire ye kuna iyeserine xiri nimaririne. ");
INSERT INTO six_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Pana xui, yeu kire kuna ne xiri taiwowairexine. Paiya muanumu, sini kirenikirenie kireu xiri xosikienikepu. Paiya yei ne oma kuna tinixe. Xuwe. Ekimeni kutu sikoe mua kuna tieikiniai. ");
INSERT INTO six_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Xoiteu xouwewopi kapia paiya muanumu, sini Xoiteupo kunani kutu taiwopu. Pa xati pa kuna eikimeni kutu iyesikiniai paiya, muanumu, tini kireu xotikienikepi kapiani kutu taiwa. ");
INSERT INTO six_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Iyesa. Xoreisikepurexeteneai apimie ouyau texineri. Nini Yesusu Kristusue apu sayeyai xineri xonikisuworixe. Panumu apua, nu xoreixoreitua xati, Kristusu xiwaiuna. ");
INSERT INTO six_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Pa xati tini atinari sosopani kutu epixa, panumu sini irerei imerei tikiniai sapi wetexekini. Tini sokisoki tumunaria tinipo xokupa asinaku sapi takuai. ");
INSERT INTO six_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Kire apue Kristusupo kuna sokisoki tepu xuweuna, kire kuna xosa potixinapa, Xoiteue nu xeika puratixe. Pana kire apue Kristusupo kuna sokisoki tinapa, Omono Niraunoe nu xeika purinexeri. ");
INSERT INTO six_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Kire apue tinipo atoro kouna, panumu kuna tikopu xuweuwatia, tinie kusounari tinipo atoro sou xowaku. ");
INSERT INTO six_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Apue panumu apu kusouna paiya, nue nupo xoxi kapiapu sainaure tianuna. ");
INSERT INTO six_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Xokupa kuna tini xosa xayawopine itouna pana, kire nakau xosa mua kuna iyarepi xiraxine. Ye koune xeketikinei, xirini kunakunaunuku nimaririwopuxi nanune. ");
INSERT INTO six_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Neu ukunipo nonomi, pa ukuni paiya Xoiteu nukoini tumuworetaipo nonomie ne kusonineri.");
INSERT INTO six_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1"," Sini Xoiteupo saina teteneai apimini kutu tianikepu Ye Yesusure xonikisurouneri nikau tumue, mua nakau ne Kaiusu xosa xayaune, ne yeu xataini kutu. Ye suauni kutu kunaune, ye ne xiri xoienine. ");
INSERT INTO six_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Waukia, ye Xoiteu xosa kunikuniti nei, xokupa sapi kakitiai asinaku xatia, naki rania asinaku purowai. Neu xonikemu asinakuni kutu purati, ye sipauweitiai. ");
INSERT INTO six_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Ekime kireu xataimanae kou xekeyerineri ipaki kunauneri, nei suau kunani kutu tairoune xeneai. Yei pa kuna iyeserine nimaririxitiai. Ye sipa, ne sipesi suau kunapu kapiarei texiroune. ");
INSERT INTO six_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Yeu nonomie suau kuna taiwori kuna iyesine paiya, ye xiri nimaririxiti pa nimaririe yeu kireu xetau nimariri oronikina. ");
INSERT INTO six_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Waukia, ne suau kunapu kapia ati taine Yesusu taiwoteneai xatasikimana xeika ne sipa xuweu xatasikimana xeika rania tianikepure asinaku saina tiroune. ");
INSERT INTO six_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Nei xonikemu tinikiyai kapiaure, kireu xatasikimana paiye Yesusure xonikisuwoteneai xuiapu kanikieneai. Pa xati nini ninipo imerei pani xowopure xeria, ne xiyerixinau kireu xuru tinikau tineri xowopineri sie paiya xiri asinaku. Xoiteue xouwewotai nanunanu sieni tianikewai. ");
INSERT INTO six_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Yesusupo saina tepure nanunanuworineri xokupa saina teteneaina pana, xukumi apimi xosa kire sapiara tirouwori xana xuwe. ");
INSERT INTO six_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Sini panumu apimi tianikepu. Panumu kapiarei Xoiteupo suau kunapu saina sokisokiwopure sini ninipo saina emenikimana sainuku. ");
INSERT INTO six_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Yesusure xonikisuwoteneai xuimiapimi xosa kireu kuna xayauyai. Pana Tiotrepesie ninipo akereki puropure, sinipo kuna iyesirouwati xana xuwe. ");
INSERT INTO six_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Pa xati ikoe tini xosa kounei sie mua, nue pa kapia kireni kaketai kapiaure tini katikepine. Nue sinire xoxixoxi kuna kunauxanaurouna. Nue pa kapia kireni kakatixe. Xuwe. Xatasikimana nupo atoro soniki xourouwati xana xuwe. Kireu apimie ninipo atoro soniki xowopure xeria, nue taiyerinikinani pani Yesusure xonikisurouneri apimi kini xosaupo xesanikirouna. ");
INSERT INTO six_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Asinaku xatai ne kakixanau xoxi kapia taiwou. Xuwe. Ne asinaku kapiani kutu taiwo. Apue asinaku kapia kaketai paiya, nu Xoiteupo apu. Pana apue xoxi kapia kaketai paiya, nu Xoiteu xekoyaixe. ");
INSERT INTO six_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Xokupa apimie Temitriusupo asinaku kapiaure kunauxanaurouneri. Kakeri Xoiteupo suau kunae rania nupo asinaku kapiaure kunauxanaurouna. Pa xati sinie rania nupo asinaku kapiaure kunaurounukuna, ne sipa, siko kuna paiya suau. ");
INSERT INTO six_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Xokupa kuna ne xosa xayawopine itouna pana, kireni nakau xosa mua kuna iyarepi xiraxine. ");
INSERT INTO six_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","Xenene xuwena ye utune xekenitia xirini kunakunawaxauxi nanune. ");
INSERT INTO six_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Neu xonikemu yoro puropina. Xatasikimanae kuso kuna xesarininerina, nei xokupa xatanimana yeu kuso kuna tinike.");
ALTER TABLE six_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
