﻿USE sofia;
DROP TABLE IF EXISTS sofia.sim_vpl;
CREATE TABLE sim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sim_vpl WRITE;
INSERT INTO sim_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais misumu walanga orhi kalira. Or Devithi krahak jitapmatava naha rahandari ria. Devit Abrahamhi krahak jitapmatava naha rahandari ri. ");
INSERT INTO sim_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham avoko Aisakhi ri. Aisak avoko Jekophi ri. Jekop avoko Juda nga jimatama orhi nga lihi avoko ri. ");
INSERT INTO sim_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda avoko Peres fre Serahi ri. Nijava frihi Tamar. Peres avoko Hesronhi ri. Hesron avoko Ramhi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram avoko Aminadaphi ri. Aminadap avoko Nasonhi ri. Nason avoko Salmonhi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon avoko Boashi ri. Nijava orhi Rahap. Boas avoko Obethi ri. Nijava orhi Rut. Obet avoko Jesihi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi avoko King Devithi ria. Devit avoko Solomonhi ri. Nijava orhi Batseba, mas Uria laha or hashirik Devit lari sir. ");
INSERT INTO sim_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon avoko Rehoboamhi ri. Rehoboam avoko Abiyahi ri. Abiya avoko Asahi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa avoko Jehosafathi ri. Jehosafat avoko Jehoramhi ri. Jehoram avoko Usiahi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia avoko Jotamhi ri. Jotam avoko Ahashi ri. Ahas avoko Hesekiahi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia avoko Manasehi ri. Manase avoko Emonhi ri. Emon avoko Josaiahi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia avoko Jehoiakin nga jimatama orhi nga lihi avoko ri. Judama wutari lihi lirin li jihi tukruhu li mbashirik kuyanga Babilonik li liri wolok Josaia jikisi orhin orok eweshirik liri lira. ");
INSERT INTO sim_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uhu os yanga Babilonik li liri wolok sishi raha misumu walanga Jisashi hi lihi kalira. Jehoiakin avoko Sealtielhi ri. Sealtiel avoko Serubabelhi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel avoko Abiuthi ri. Abiut avoko Eliakimhi ri. Eliakim avoko Asorhi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor avoko Sadokhi ri. Sadok avoko Akimhi ri. Akim avoko Eliuthi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut avoko Eleasarhi ri. Eleasar avoko Matanhi ri. Matan avoko Jekophi ri. ");
INSERT INTO sim_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop avoko Josephi ri. Josep hula Mariahi ria. Maria oso Jisasin wari sir. Or Krais oria. Hulaima nokopman jivinakurik Avui Wasilaka kamahanda ma ria. ");
INSERT INTO sim_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma ol Abrahamhik sishi raha Devithik talari misumu walanga ondo 14-pelak nari lira. Ushihi Devithik sishi raha os yanga Babilonik lirin li tolo laha iri erem, misumu walanga 14-pelak nari lira. Ushihi orok sishi raha Krais talari erem, misumu walanga 14-pelak nari lira. ");
INSERT INTO sim_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais or talari nombo karem, nijava orhi Maria angop Josepnjik li tlasashirik wayandari sir. Hako sirin or laha fri li namber li heyeri angop nomok nari sir. Hako os nomok si nari oso Avui Wasilaka Masikome orhi or mbari nombo hom osmu nari sira. ");
INSERT INTO sim_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ma worna ma mende orik Marian men mayam or halakurik hishiri ria. Las avak sirin kormbak or halashinak si humblaraku, karem mbaha mayam sirin halakurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Erem or hishirik Wasilakahi ensel lar suknombo yok orhik or taha ormu mbara, �Josep, mir King Devithi krahak fehenda mirin, mashi kas a mbawan misi, jikisi or sungu Mariahik wawa oto Masikome Avui Wasilakahik nawa ria. Uwosik sirin mi lakwan turawa hala. ");
INSERT INTO sim_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Avak jikishulayi lar wakwa sir. Hi orhi Jisasik ushaka. Jikisi oto kumak hulaima nokopman or jivinaha kavakava os li undan or yoko ermbekwa ria. Ushinak lir mbeek hik ikwa ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mbele mbele ol talakurik nari ondo avak li talanak mashi os Wasilaka profet orhi ondok or mbahandari mashi oso avak omek si naka. Karem li kayeri sir. ");
INSERT INTO sim_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","�Misi, nokopminyongo las hula nga si li namber avak si nomoyihi jikishulayi lar wakwa sir. Hi orhi Emanuel, karem li ushakwa ria. Hi Emanuel oso maintontlo sihi karem, Avui Wasilaka nir nga nakrem linda ria.� ");
INSERT INTO sim_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Urik Josep or usaha os ensel mbari nombo hom sirin ormu lara. ");
INSERT INTO sim_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hako or mbeek sir nga liri ambu ri. Er fri lihi jikishulayin simu wara. Urik Jisasik ormu ushara. ");
INSERT INTO sim_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Jisasin kuyanga Betlehem provins Judiak si wari ria. Oso wolo Herot kingik or nari wolok nari sira. Am Jisasin si waha si ewewarik saveman lal ta rasandari yok fehe Jerusalemik li taha limu silira, ");
INSERT INTO sim_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","�Judama malakama lihik nakunda jikisakri oto mbeyok or wandu? Nir ta rasanda yok tashingra orhin angop ni heyeri ri. Ushihi tashingra oton ni oloho tiyaraha orin ni lotu ukmbaha nimu randuwa.� ");
INSERT INTO sim_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Karem li mbarik Herot wavu musha mushak ormu hishira. Urik Jerusalemik fehe ma amber wavu erem hishiri lir. ");
INSERT INTO sim_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Urik Herot bikpris ondo nga mashi Moseshin sawendari ma nga or mbarik li talandirsarik ormu silira, �Ma kar Avui Wasilaka hulaima nokopman jivinakurik or mbahanda ma oto mbeyok or talaku? Profet ondo mberem li mbar?� ");
INSERT INTO sim_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Urik limu sawera, �Kuyanga Betlehem provins Judiak talakwa ria. Profet ondo karem li kayeri osa, ");
INSERT INTO sim_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","�Jir kuyanga Betlehem provins Judiak fehe ma jirin ji misi, kuyanga jihi awarikandak si naha hi ngashi ambu sir. Hako kumak avak malakama lar jihi nindik usahakwa ria. Uhu ma Israelik fehendan or arangoho nor washilishinak likwa ola. Ushinak yanga jihi oso hi sihi wasilakak si naha yanga yanga wasilakak nanda ondon tikrikwa sira.� � ");
INSERT INTO sim_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Karem li sawerik Herot siyok wayok saveman ondon ormu mainhara. Ushinak li taha os maifuk tashingran li heyeri wolon li sawenak or misikmbahan. ");
INSERT INTO sim_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Urik li tarik or mbashirik Betlehemik limu ira. Uhu normu mbara, �Ji ihi jikisi oton ji lasaka. Am ji heye nahi, kolok indik ji raha ji sawenak a misihi an nga ihi orin avai lotu uka.� ");
INSERT INTO sim_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Karem or mbashirik li ihi kolok tashingra oton indik li heyerik lirin or nombo muku ihi jikisi oto wari mishi akamasuwu orok ormu sira. ");
INSERT INTO sim_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tashingra oton li heyeri wolo sunguwavu mende nga rupshiri lir. ");
INSERT INTO sim_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Uhu aka os jikisi oto or wari mishik li i layihi li heyeri jikisi nga nijava orhi Maria nga orok frimu wara. Uhu kumbambongok li raka lihi orin limu hausimbausihi mbele mbele ol li laharari gol nga sanda jivi nga mbele mbele arme kuvasahandari nga orin limu hara. ");
INSERT INTO sim_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Urik suknombo yok Avui Wasilaka lirin ormu sawera, �Jir avak indik Herotin ji i heyewa hala.� Karem or saweshirik nombo anandi yok indik kuyanga lihik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Saveman ondo am yanga lihik li ishirik Wasilakahi ensel lar suknombo yok Josepik or taha ormu sawera, �Josep misi, Herot ormu jikisin or mandingormekwak mbanduwa. Mir kolok usaha jikisi nga nijava orhi nga laha yanga Ijipik ji tulu ika. Orok er ji linak a mbanakop ji misihi indiyok jivai raka.� ");
INSERT INTO sim_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Karem or mbarik, Josep or usaha nombok fririn nirik or laha yanga Ijipik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yanga Ijip orok li lihi li misirik, Herot or hashirik li misihi limu indiyok tara. Erem si nari nombo orok mashi os Avui Wasilakahi profet maskop li mbahandari mashi osmu omek nara. Profet karem li mbahandari osa, �Jikisi anhin a mbanak yanga Ijipin or halaha ormu rakuwa.� ");
INSERT INTO sim_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot or lihi nor heyeri saveman ondo mbeek orhik indik tari ambu lir. Ushirik sunguwavu mende orhi nga ormu waplelenara. Uhu or mbashirik awun undari ma orhi ondo li ihi yanga Betlehem nga yanga ol pasir nandari ondo nga orok li ihi jikishulayi akri li wari nga asama frijipkop nari nga limu mandingormera. Mberem ushirik? Saveman ondo tashingra os Jisas nijava orhi orin si wari wolok tari oton li heyeri asama frijip angop iri vria. Karem Herotin li saweri osik, or mbashirik, jikishulayi ol oro wolok li wari ondon limu mandingormerakora. ");
INSERT INTO sim_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herot jikisakri ondon or mandingormeri nombo orok mashi Avui Wasilakahi profet Jeremaia or mbahandari mashi osmu omek nara. Karem or mbari osa, ");
INSERT INTO sim_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","�Resel jikisi sihi li hashirik yanga Ramak si lihi tlaholmba oweri osa. Hako, sir mbeek hulaima nokopma hokovinak mayam si likuri nga nari ambu sir. Mberem ushirik? Jikisi sihi angop harakori ola.� ");
INSERT INTO sim_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot am or hashirik Josep le yanga Ijipik li lirik Wasilakahi ensel lar suknombo yok orhik or taha ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","�Ma or jikisin mandingormekurik mbari ma oto angop hari ri. Jikisnokove mihin laha indik yanga Israelik ji ika.� ");
INSERT INTO sim_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Karem or mbarik Josep or usalaha indiyok Israelik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hako or misiri Herot oto jikisi orhi, Arkelaus, avoko orhi Herothi farniyik or sihi provins Judian arangori ria. Karem or misiri osik provins Judia orok or ikurin ormu ajera. Hako Avui Wasilaka suknombo yok or saweshirik provins Galilik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilik li ihi kuyanga ome Nasaretik limu lira. Erem si nari osik mashi os profet ondo mas karem li mbahandari osmu omek nara, �Ma oto kuyanga Nasaretik fehe, karem li ushahakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","3","Mas profet Aisaia karem or mbari sir, �Misamtelmbamba ma ngashi mishi ambu orok ma lar avak or taha mashin karem sawekwa ria, �Wasilakahi nombon ji hundujeka. Uhu nombo oson ji unak wornak si naka.� � Mashi os karem or kayeri Jon talakurin or mbari sira. Ushirik Jon man fak tolofalendari ma oto or taha provins Judiak misamtelmbamba orok or yaha mashin karem ormu sawera, �Avui Wasilaka jirin or arangoshinak jip ji likwa oso am si talakwak osmu nanduwa. Karem uwosik kavakava os ji undan ji heyehe ji mba, �Kas karem a uri kavan a uri sir.� Karem ji mbaha sunguwavu jihin ji tormblehe orhik ji raka.� ");
INSERT INTO sim_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon kowe os or faleri kamel kukwak li undari sir. Uhu kufulombo las jinkupsumbuk or ishitangrindari sir. Akwa orhi intlavi nga hani nga andari ri. ");
INSERT INTO sim_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Urik ma amber Jerusalemik fehe, provins Judiak fehe, ma ol fa Jordanik pasir lindari nga orhik limu rara. ");
INSERT INTO sim_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Li raha kavakava li undarin kormbak li sawerik fa Jordanik lirin ormu tolofalera. ");
INSERT INTO sim_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Urik Farisi lal nga Sadyusi lal nga Jon lirin fak or tolofalekmbaha limu rara. Urik lirin or heyehe ormu mbara, �Jir Laulakahi jikisi jir. Jir men torok ji raha fak ji layihindanak waplelena Avui Wasilakahi os talakwa oso jihik nakwa ambu, karem ji hishihi jimu randu? Wahau, erem nembes. ");
INSERT INTO sim_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Masmas sunguwavu jihin ji tormblehe mbele mbele jivin ji unak ni heyehe nivai mbaka, �Ma tondo angop sunguwavu lihin tormblewa lir.� ");
INSERT INTO sim_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hako jihinjik avak ji mba, �Misumu nihi Abraham oria. Uwosik Avui Wasilaka mbeek nirin kavak nakwa ambu ri.� Karem ji mbawa hala. Jirin amu sawenduwa, Avui Wasilaka os or mba nahi, sunja tondon or mbanak jikisi nirambara Abrahamhik nakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hako ji misi, mi ol akwa ome jivin wawa ambu men li shihi hik li ermbeshinak hi ukwa lir. Kombefa osmu mi tontlok wanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Uhu ormu mbara, �Ma ol kavakava os li undan kormbak sawewa ma ondon men fambak a tolofalenda nir. Hako kumak ma lar avak takwa ri. Kwambu orhi kwambu anhin tikrinda sir. An ma jivi ambu nir. Unda osik an mbeek kumbambongon a huvuhu kuvu os kumba ari orhi orok nawan a sorgondahi ambu nir. Hako or hi nga Avui Wasilaka Masikome orhi nga jirin fak tolofalekwa ri. ");
INSERT INTO sim_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Or avak man toloyarikwa ri, os wit sijin suwak tolonda ma li toloyarinda hom. Wit sijin suwak or tolonak ome nom li takanak aka orhik or owekwa lir. Hako supmbalapmbak nawa ondon hi os usunguanda ambu orok or ermbeshinak hi ukwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oro wolok Jisas provins Galilin or halaha Jon orin fak or tolofalekmbaha fa Jordanik ormu rara. ");
INSERT INTO sim_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Or rarik Jon orin or heyehe ormu mbara, �Ayo, mir Wasilaka anhi om te! Mberemhi os mirin fak a tolofalekmbaha mi randuwa? Mirtonom anin fak tolofalendahik nawa mira, an wahau.� ");
INSERT INTO sim_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Urik Jisas mu mbara, �Mir os a mbawa nombo hom uka. Os erem shi uwa mbele mbele os Avui Wasilaka shi ukmbaha or mbahanda hom os shimu unduwa.� Karem or mbarik Jon mu orin fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Urik Jisas fak or layihi or usasihi nor heyerik, kolok, lersuwu simu sutlara. Urik Masikome Avui Wasilakahi apmuma hom Jisashik ormu raka lira. ");
INSERT INTO sim_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Urik mashi las lersuwu yok simu mbara, �Ma oto jikisi indingo anhi ria. Sunguwavu anhi mende nga orin a rupshihi mbele mbele ol or uwan amu rupshinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Urik Masikome Avui Wasilakahi Jisasin or laha misamtelmbamba orok frimu ira. Ushinak Laulaka orin orok or oweioweiheyekmbahan. ");
INSERT INTO sim_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uhu orok or lihi niri 40-pelak akwan or halari osik ormu erenghara. ");
INSERT INTO sim_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Urik Laulaka or taha ormu mbara, �Os Avui Wasilakahi jikisi indingak mi na nahi, mi mbanak sunja toso avak si tormblehe bretik si nanak mivai aka.� ");
INSERT INTO sim_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Urik ormu mbara, �Wahau! Mashi Avui Wasilakahi karem mbanda osa, �Ma mbeek akwakop linda ambu lir, wahau. Mashi Avui Wasilakahi jelyashiwak limu linda sira.� � ");
INSERT INTO sim_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Urik Laulaka Jisasin or laha Jerusalemik fri ihi akamasuwu tempel aka orok fri lawusihi ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","�Mashi Avui Wasilakahi karem mbanda osa, �Avak Avui Wasilaka or mbashinak ensel orhi ondo li taha sishinak tavarenje lihik mi layinak sunja las mbeek mirin jikwa ambu sir.� Karem li kayehenda osik, os jikisi orhi indingak mi na nahi, akamasuwu torok mi sihi mi kweinalayi nahi, mbeek kavak nakwa ambu mir.� ");
INSERT INTO sim_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Urik Jisas ormu mbara, �Mashi Avui Wasilakahi las er nga karem mbanda sir, �Avak Avui Wasilaka or mirin arangonda kwambu orhin oweioweiheyewa hala.� � ");
INSERT INTO sim_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Urik Laulaka orin or laha telemba laka lasik frimu lawura. Orok fri sihi kolaka misambi torok nanda jivijivi ngashi amber hom Jisasin or mukuhu ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","�Os kumbambongo mihin mi huvuhu hi anhin mi hauowe nahi, avak mbele mbele tondon mirin a hakwa nira.� ");
INSERT INTO sim_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Karem or mbarik ormu mbara, �Laulaka tawe! Mashi Avui Wasilakahi karem mbanda sir, �Mir avak Avui Wasilaka or mirin arangohonda hi orhi nom hauowehe ortonom tiyaka.� � ");
INSERT INTO sim_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Karem or mbarik Laulaka Jisasin or halaha ormu ira. Urik ensel lal li taha orin limu jelyara. ");
INSERT INTO sim_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas Jonin krawuk li eweri mashi oson or misihi provins Judian or halaha indik provins Galilik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hako or mbeek yanga Nasaretik iri ambu ri. Yanga Kaperneam leuku Galili nandari mishi orok or ihi liri ria. Misambi oso Sebulun nga Naptali nga frihi krahak fehendahi ma ondo misambi lihi sira. ");
INSERT INTO sim_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Os orok or lihi mashin or saweri oso si urik mashi os profet Aisaia maskop or mbahandari osmu omek nara. Aisaia karem or kayeri osa, ");
INSERT INTO sim_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","�Jir kraha Sebulunik fehenda nga kraha Naptalik fehenda nga misambi jihi nombo os leuku Galilik inda nga fa Jordanin mbuhu kauyok nanda nga nanda sir. Avui Wasilakahi mashin tiyanda ambu ondo mushak jir nga nakrem linda lir. Hako ji misi. ");
INSERT INTO sim_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jir nirtle nirndum nindik linda ma jirin, ukruharanda wasilaka angop jihik talari sir. Jir ma ol Avui Wasilaka nga nanda ambu jirin, ukruharanda orhi angop jihik si ukruhararik ji heyeri sir.� ");
INSERT INTO sim_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Urik Jisas orok er or sihi mashin ormu saweyara karem, �Avui Wasilaka jirin or arangoshinak jip ji likwa oso am si talakwak osmu nanduwa. Karem uwosik kavakava os ji undan ji heyehe ji mba, �Kas karem a uri kavan a uri sir.� Karem ji mbaha sunguwavu jihin ji tormblehe orhik ji raka.� ");
INSERT INTO sim_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Urik Jisas leuku Galili hapsishikop or ihi mahasanje lap ormu heyera. Lar Saimon, hi yeje orhi Pita, karem li ushandari ria. Lar maha orhi Andru ria. Jisas or ihi or heyeri frir foom kowen leuku orok frimu ermbera. Frir foomen kruwu yan landari ma vria. ");
INSERT INTO sim_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Urik ormu mbara, �Shi ra! Anin shi tiyanak nombo os hulaima nokopman landa nombon a mukunak shi heyeka.� ");
INSERT INTO sim_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Karem or mbarik kolok lerawu frihin fri halaha orin frimu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Urik kandakar nga li ihi mahasanje ome lap limu heyera. Lar Jems, lar Jon, jikisi Sebedihi vria. Avoko frihi Sebedi nga bot akomek li lihi foom kowe os kororin indik limu nara. Urik Jisas orin fri tiyaha fri ikmbaha ormu ushara. ");
INSERT INTO sim_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Urik kolok fri usaha bot nga avoko frihi nga fri halaha Jisasin frimu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas yanga yanga os provins Galilik nanda mishik ormu yara. Uhu aka os Judama li lotu undari mishik or layihi mashi os Avui Wasilaka lirin or arangoshinak jip li likwa mashi oson ormu sawera. Uhu ma ol silawala kavamisindarin or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Urik mashi os Jisas or mbarik jivik li nari mashi oso simbalesik yanga Siriak si irik amber hom limu mistakora. Urik ol kavamisihi tashiyandari ondo nga wasimalengamba tolondari nga ma ol kwarngarnaha misambik takatukuyinda ondo nga ma ol kumbanash tavanashindari nga orhik li lahararik or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ushirik ma musha mende orin limu tiya ira. Ma ol Galilik fehe, distrik Dekapolisik fehe, Jerusalemik fehe, Judiak fehe, fa Jordanin mbuhu kauyok fehe nga amber hom li taha orin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas or heyeri ma musha mendek li rashirik or heyehe telembak or lawuhu ormu lira. Urik ol orin tiyandari ma ondo orhik li tarik mashin ormu ewesawera. ");
INSERT INTO sim_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Uhu lirin ormu ewesawera karem, ");
INSERT INTO sim_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","�Ma ol mba, �Anhinjik Avui Wasilakahi nombon mberem a tiyandahi ambu, wahau. Or ngashik nombo orhin amu tiyanduwa.� Karem mbawa ma ondo li rupshika. Mberem ushiwak? Lir avak orhi mak li naha yanga orhi orok layikwa lira. ");
INSERT INTO sim_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ma ol ter wolok tlaha liwa ma ondo li rupshika. Mberem ushiwak? Kumak avak Avui Wasilaka or unak jip likwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ma ol ter wolok hangisha liwa ma ondo li rupshika. Mberem ushiwak? Lir avak misambi os or hakmbaha or mbahanda oson or hakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ma ol nombo wornan tiyakmbaha hishombashiowewa ma ondo li rupshika. Mberem ushiwak? Avui Wasilaka avak or jelyashinak nombo worna oson tiyakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ma ol ma anandin heyehe mba, am nawa kava sir, karem mbawa ma ondo li rupshika. Mberem ushiwak? Kumak Avui Wasilaka os lir ma anandin li uhunda hom lirin erem or ukwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ma ol kavakavan unda ambu ondo li rupshika. Mberem ushiwak? Kumak avak lir Avui Wasilakan heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ma ol mishamaimbanda ma ondo li rupshika. Mberem ushiwak? Avui Wasilaka kumak lirin jikisi orhik or ushakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ma ol nombo Avui Wasilakahin li tiyawak ma lirin nombo orok kavak li unda ma ondo li rupshika. Mberem ushiwak? Lir avak orhi mak li naha yanga jivi orhi orok layikwa lira.� ");
INSERT INTO sim_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Uhu ormu mbara, �Os li heyenak anhi mak ji nanak jirin kavakavak li uhu li okolehe li unak hi kava jihik si lawu nahi, wa ji holowa hala. Oso men ji rupshika. ");
INSERT INTO sim_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wavu jihi mende nga ji rupshika. Mberem ushiwak? Os erem jirin li uhunda wasan ji lakwa osmu hevenik nikishihi wanduwa. Hako ji hishakashawa hala, profet ol mas lerawun lahandarin kavak li undari hom os jirin erem kavak limu unduwa.� ");
INSERT INTO sim_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Uhu mashi las nga ormu mbara, �Waswo jivi sira. Uhunda hom jir erem, ma misambik fehe lihi nindik waswo hom ji naka. Hako os waswo jivik si nana ambu nahi, mberem nivai unak indik jivik si naku? Wahau, men li ngoro ermbehe li esnerkokwa sir. ");
INSERT INTO sim_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ji hishika, kuyanga os telemba heimak nanda kormbak si nashiwak amber li heyekwa sir. Uhunda hom jir erem, ma misambik fehe nindik ukruharanda hom ji naka. ");
INSERT INTO sim_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Uhunda hom ma mbeek lamin li ukruhu shovok tangri arangonda ambu lir, wahau. Metenjek li shinjishiwak si ukruharawak li heyenda sir. ");
INSERT INTO sim_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Uhunda hom jir erem, mbele mbele jivi nom ji unak ma li heyehe Avui Wasilaka jihi or hevenik linda hi orhin li hauoweka.� ");
INSERT INTO sim_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","�Las avak karem ji hishinan, Moseshi mashi nga profet ondo li mbahandari mashi nga a laha ermbekurik a rari nir, karem ji hishinan. Wahau, erem nembes. A rari karem, os li sawendari mashi mainombo hom a ukmbaha na rari nir. ");
INSERT INTO sim_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Omek jirin amu sawenduwa, lersuwu nga misambi nga mendek nakwa vri. Hako lo Avui Wasilakahi, wahau. Os si nanda hom er si naha inak mbele mbele amber mendek nakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Os ma lar os or mba, �Lo kaso awarikanda sir, oson ni tiyawan ni hala.� Karem or ewesawenak lal er nga os or mbawa hom li u nahi, jirin amu sawenduwa, Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa wolo ma oto mbeek malakamak or naha hi nga nakwa ambu ri, wahau. Hako ma or lo amber ondon tiyaha ma anandin erem ewesawewa ma oto kumak Avui Wasilaka hulaima nokopma orhin or arangoshinak li likwa wolo malakamak or naha hi orhi wasilakak nakwa sira. ");
INSERT INTO sim_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Omendingak jirin amu sawenduwa, os Avui Wasilakahi yanga orok ji ikwak ji hishi nahi, halanak mbele mbele ol ji uwa nga ji hishinda nga jivi mendek li naka. Uhu Farisi nga mashi Moseshin sawendari ma ondo li tiyanda nombon ji tikrihi mbele mbele armek lo si mbanda hom ji uka. Os erem ji una ambu nahi, jir mbeek yanga orhi orok ikwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","�Mashi Moseshi angop ji misinda, karem mbanda sir, �Man mandingormewa hala. Os man ji mandingorme nahi, jirin kotik li ewehe wasan li ukwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hako jirin amu sawenduwa, os mahasanje jihin ji wapkava hishi nahi, man mandingormenda hom angop ji uwa sir. Karem uwa osik kumak mbele mbele am mendek si nakuna wolo avak jirin kotim ukwa lir. Hovok os mahasanje jihin mashi kava menden ji mba nahi, man mandingormenda hom angop ji uwa sir. Karem uwa osik kumak mbele mbele am mendek si nakuna wolo jirin majistrethi tavak li halakwa jir. Hovok os mahasanje jihin ji mba, �Mir ferfar mbaha ambarambasinda ma mira.� Karem ji mba nahi, kumak avak hik ikwa jir. ");
INSERT INTO sim_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Karem uwosik os Avui Wasilakan ofan ji ukunak ji i nahi, ofa jihi oson altak ji ewewa wolo mbele kava las ma larin ji unda oso wavu jihik si rasanak ji hishi nahi, ");
INSERT INTO sim_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wa ofa oson ji halashihi indik ji ihi ma oto nga ji anasawehe ji waphimbijishihi jivai indik ofan ukmbaha raka. ");
INSERT INTO sim_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Os ma lar jirin kotik or ewekunak or mba nahi, jir kolok orin i heyehe ji anasawehe jivai waphimbijika. Las avak ji halashinak jirin kotik or ewenak li mbanak avak polisman jirin krawuk li ewenda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Omek jirin amu sawenduwa, ya os ji hakmbaha li mbawa hom ji ha nahi ambu, mbeek indiyok hikrik talakwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","�Mashi Moseshi angop ji misinda karem mbanda sir, �Nokophirmbirihi hulatolhakawa hala!� ");
INSERT INTO sim_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hako jirin amu sawenduwa, os ma lar nokove las or heyehe sirin or lahayakwak or hishi nahi, sungu akome yeje orhi angop or lahayawa sir. ");
INSERT INTO sim_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Karem uwosik os misokom mama yoko jihi si haihandaheye nahi, oson kwarko ermbehe jip ji lika. Las avak ji halashinak si unak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Os tapmama yoko jihi si mbango nahi, oson ji shikoro ermbenak si ika. Las avak ji halashinak si unak hik ji inda ngashi.� ");
INSERT INTO sim_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","�Mashi Moseshi angop ji misinda karem mbanda sir, �Os ma lar nokove orhin or halashinak si iku nahi, os or turawa nombon jekamba lasik or kayeshinak si heyehe sivai ika.� ");
INSERT INTO sim_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hako jirin amu sawenduwa, os ma lar nokove orhi hula anandi nga si ya namber, men sirin or turaha nor mbashinak si i nahi, ma oto vai kavakavan uwa ri. Ushiwak nokove oso os hula anandin si li nahi, hula maifuk si lihinda oto mu uwak kavakavak simu layinduwa. Ushiwak ma or nokove oson lawa ma oto ormu nokophirmbirinda nombo orok er nga layinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","�Mashi Moseshi angop ji misinda karem mbanda sir, �Os mbele lashi hik ji mbawa omek er ji mbaka. Uhu os mbele las Avui Wasilakan ji ukmbaha ji mbawa, os ji ukmbaha ji mbawa hom erem ji uka.� Karem li kayeri sir. ");
INSERT INTO sim_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hako jirin amu sawenduwa, jir avak mbele mbele nelok avoko jihi hik ji ushaha ji mbawan ji hala. Uhu heven yok ji mawuhu ji mba, �Heven heyewak omek amu mbanduwa,� karem ji mbawa hala, wahau. Mberem ushiwak? Heven Avui Wasilaka kingik or naha nor linda mishi sira. ");
INSERT INTO sim_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Uhu, �Misambi heyewak omek amu mbanduwa,� karem ji mbawa hala, wahau. Mberem ushiwak? Misambi Avui Wasilaka or ese sinda mishi sira. Uhu Jerusalemhi hik mbele las ji mbawa hala, wahau. Mberem ushiwak? Jerusalem kolaka orhi os kingik or naha nor linda mishi sira. ");
INSERT INTO sim_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Uhu karem ushambawa hala, �Os omek a mbana ambu nahi, anin ji mandingormewa.� Karem ji mbawa hala. Mberem ushiwak? Jir mbeek jihinjik ji uwak masikukwa jihi tlek mo avishak nanda ambu sir. Karem uwosik mbele mbele ondohi hik ji ushambawa hala, wahau. ");
INSERT INTO sim_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Os he, karem ji mba nahi, halanak os ji mbawa hom er si naka. Uhu os wahau, karem ji mba nahi, halanak os ji mbawa hom er si naka. Mbele mbele anandi nga ji ushaha mbawa hala. Nelokohi hik, kwarambahi hik ushambanda nombo oso Laulakahi nombo sira.� ");
INSERT INTO sim_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","�Mashi Moseshi angop ji misinda karem mbanda sir, �Os ma lar misokome jihin kavak or na nahi, misokome orhin erem kavak ji uka. Uhu os ma lar fu jihin or jingo nahi, fu orhin erem ji ngoka.� ");
INSERT INTO sim_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hako jirin amu sawenduwa, os jirin kavak li u nahi, wasan ji uwa hala, wahau. Os ma lar jirin or jimblalana nahi, tormbleshinak yoko nga nor jimblalanaka. ");
INSERT INTO sim_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Os ma lar jirin or kotim uhu kowe jihi las or lakunak or mba nahi, kowe anandi las er nga hanak or laka. ");
INSERT INTO sim_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Os ma lar mbele mbele orhin kandakar ji kishakmbaha or mba nahi, wa kar nga kisha lai eweshihi ika. ");
INSERT INTO sim_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Os ma lar mbele mbelenjik or sili nahi, os or siliwa oson ji haka. Uhu os mbele jihi las or lahandanakop wasan orvai ha, karem or mba nahi, ji haka.� ");
INSERT INTO sim_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","�Karem li mbarin angop ji misiri sir, �Jihi man ji rupshihi wutari jihin kavakavak ji uka.� ");
INSERT INTO sim_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hako erem nembes. Jirin a sawekwa karem, wutari jihin ji rupshika. Uhu ma ol jirin kavak ukmbaha uwa ondonjik Avui Wasilakan ji sawenak armek or liri uka. ");
INSERT INTO sim_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mberem ushiwak? Avui Wasilaka jihi or hevenik linda oto ta nga ma nga nor halashiwak ma amber misambik fehe, ma kava nga ma jivi nga nowe lihik ta jiwak, ma rakanda sira. Karem uwosik os wutari jihin ji rupshi nahi, Avui Wasilaka hom ji naha orhi jikisi indingok nakwa jira. ");
INSERT INTO sim_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Os jihi ma nom ji rupshi nahi, oso mbeek lakak nanda ambu sir. Mberem ushiwak? Ma kava ondo er nga mahasanje lihi ambekop rupshinda ola. ");
INSERT INTO sim_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Uhu os mahasanje jihi nom ji howaimbawayi nahi, jir mbeek ma ol Avui Wasilakahi mashin misinda ambu ondon tikrihi jivi mendek nanda ambu jir. Mberem ushiwak? Avui Wasilakahi mashin misinda ambu ondo erem mahasanje lihi ambekop rupshinda ola. ");
INSERT INTO sim_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hako Avui Wasilaka jihi hevenik linda oto ma worna ma indingak nanda ora, mbeek mbele kava las orhik nanda ambu sir. Karem uwosik jir erem, or nanda mende hom ji naka.� ");
INSERT INTO sim_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","�Jir os mbele las ji ha nahi, wa mayam wanyihi haka, ma heyenak nembes. Mberem ushiwak? Os ma li heyenak ji ha nahi, hulaima nokopma os limu hi jihin hauowenduwa. U nahi, Avui Wasilaka jihi or hevenik linda wasa os ji lakmbaha or mbahandan lakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Uwosik mbele las erndakavan ji hakwa wolo avak kormbak larasa tolonak ma li misihi hi jihin li hauowewa hala. Men mayam siyok wayok ji haka. Hako lal erem unda ambu lir. Li hawa wolo li toko ushawak, ma amber haus lotuk mo os li tirsanda mishik li ralandirsaha li heyewak, handa lir. Jirin amu sawenduwa, ol erem unda ma angop wasa lihin lawa lir. ");
INSERT INTO sim_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hako erndakavan ji hawa wolo men mayam ji wanyihi haka. Tapmama hawa, tava ashi mbeek heyekwa ambu sir. Tava ashi hawa, tapmama mbeek heyekwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Os erem ji uwa Avui Wasilaka angop or heyewa sir. Uwosik kumak wasan jirin hakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","�Jir os Avui Wasilakan ji sawewa wolo ma ol hulaima nokopma hi lihin li hauowekmbaha hishinda ma ondo hom ji sawewa hala. Ma ondo ma li tirsaha li lotu unda mishik li sawehe nomtenje nomtenjek li sihi li sawenak, ma amber li heyeku, karem hishinda ola. Hako jirin amu sawenduwa, lir angop wasa lihin lawa lir. Hako jir os li unda nombo hom uwa hala. ");
INSERT INTO sim_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Os Avui Wasilakan ji sawewa wolo aka jihik ji layihi akayangan ji kosoho men mayam ji saweka. Unak Avui Wasilaka or mbele mbele wanyiwandan heyenda oto os mayam ji sawewa oson or misihi wasan jirin hakwa ria. ");
INSERT INTO sim_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Avui Wasilakahi mashin misinda ambu ondo os orin li sawewa wolo mbeek hishiyarihi mbanda ambu lir. Lir men mashin li mbayangonak Avui Wasilaka misi, karem hishinda lira. ");
INSERT INTO sim_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hako jir erem ji uwa hala. Mberem ushiwak? Ji sawe namber os ji sawekmbaha ji hishiwa angop masmas or heyewa sir. ");
INSERT INTO sim_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hako karem orin ji saweka, Avui nihi hevenik linda mirin, halanak ma amber hi mihin li hauoweka. ");
INSERT INTO sim_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mir nirin mi arangoshinak jip ni likwa oso halanak kolomalok si nama naka. Halanak heven yok mashi mihin li tiyanda hom misambiyok erem ni tiyaka. ");
INSERT INTO sim_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akwa os ter ni akmbaha ni mbawa oson nirin hanak ni aka. ");
INSERT INTO sim_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mir avak mbele mbele kavakava os ni undan laha ermbeka, os nir ma ol kavakavan nirin li uwak mirin ni sawewak kavakava lihin mi laha ermbenda hom, kavakava nihin laha ermbeka. ");
INSERT INTO sim_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mir avak jeikayenda nihik si talakwan arangoka. Uhu mir avak taha nirin kavakava nindik laha apsham eweshinak ni lika. ");
INSERT INTO sim_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ji misi, os kavakava ma jirin li uwan ji heyehe ji mba, �Am nawa kava sir.� Karem ji mba nahi, Avui Wasilaka nihi or hevenik linda oto nga kavakava os ji undan laha ermbekwa ri. ");
INSERT INTO sim_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Hako erem ji una ambu nahi, or nga kavakava os ji undan laha ermbekwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","�Jir akwan ji halawa wolo ma ol hulaima nokopma hi lihin li hauowekmbaha hishinda ma ondo hom ji uwa hala. Lir fumushima lihin li halashiwak kumbuninda hom nanda lir. Ushinak ma li heyehe li mba, �Toto akwan halaha Avui Wasilakan sawewa toria.� Karem li mbakmbaha unda ola. Erem nanda ma ondo angop wasa lihin lawa lira. Hako jir erem ji uwa hala. ");
INSERT INTO sim_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jir os akwan ji halawa wolo avak fumushima jihin ji yokoho masiji jihin saka. ");
INSERT INTO sim_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Unak ma lar mbeek os akwan ji halawan heyekrahakorokwa ambu lir. Avui Wasilaka jihi ortonom os mayam ji halawa nombo oson heyewa ri. Ushinak os ji wanyihi ji unda osonjik wasan kumak hakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","�Jir avak mbele mbelen misambi torok ji lahara haumbli haumblikwak ji hishiwa hala. Mberem ushiwak? Mbele mbele ondo kosola koronak, kringrimbain hongonak, ma kava li hirnyakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hako mbele mbele jivi misambik ji ewekmbaha hishiwa ondon ji halaha ji tormblehe heven yok ji eweka. Mberem ushiwak? Heven orok mbeek kosola korokwa ambu lir, kringrimbain hongokwa ambu lir, ma kava mbeek li hirnyakwa ambu lir. Karem uwosik mbele mbele ondon orok ji eweka. ");
INSERT INTO sim_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Os mbele mbele jiviwavi jihin hevenik ji ewe nahi, sunguwavu jihi nga orok ikwak hishikwa oja. Hako os misambik ji ewe nahi, sunguwavu jihi nga orok likwak hishikwa oja.� ");
INSERT INTO sim_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","�Misokome jihi lam hom nanda sir. Os jivik si na nahi, ma harkawu jihi nga harakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hako os misokome jihi kavak si na nahi, ma harkawu jihi nga tangnakwa sir. Hako os erem ji naha jihinjik ji hishihi ji mba, �Nir ukruharandak ni yanda nir.� Os erem ji hishi nahi, angop si tangna arangoshiwak men shushu uyanda hom nawa jir.� ");
INSERT INTO sim_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","�Ma lar mbeek ma frijipnjik lerawun landahi ambu ri. Os erem or u nahi, lar or rupshihi lar or turakwa ri. Uhu lar mbawan or misihi lar mbawan halakwa ri. Unda hom jir erem, os ya mbele mbele mendenjik ji hishombashiowe nahi, jir mbeek Avui Wasilakahi siyok sikwak hishikwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","�Jirin amu sawenduwa, mbele mbele ol maome jihin jelyakwanjik ji hishombashiowewa hala. Uhu ji mba, �Akwa mbelen ni akundan, kowe mbelen ni falekundan?� Ondo mendenjik hishombashiowehe ji holowa hala. Mberem ushiwak? Tos ni hishihi ni liyanda mbeek men akwa nga kowe nga frihik ni liyanda ambu nir, wahau. ");
INSERT INTO sim_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Avi ondon ji heyeka. Lir mbeek lerawun laha akwan fakanda ambu lir, wahau. Hako Avui Wasilaka jihi or hevenik linda lirin armek or unda lir. Hako jir avi ondon tikrinda jir. Mberem ushiwak jirin armek or unda ambu, karem jimu hishindu? Wahau, jirin armek unda ri. ");
INSERT INTO sim_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Os mbele mbele misambik fehe ondonjik ji holo nahi, ondo am jirin jelyanak nambe mendek ji liyakundas? Wahau. ");
INSERT INTO sim_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mberem ushiwak kowenjik ji hishombashiowendu? Mise amase ondon ji heyeka, armek nawak ji heyenda lir. Mise lihi os kowen li falenda hom nanda sir. Hako mbeek lerawun laha kowen tlavanda ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","King Solomon kowe jiviwavin falendari ri. Hako mise amase ondo arme mendek li naha kowe jivi ol or falendari ondon tikrinda lir. ");
INSERT INTO sim_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mise amase ondo mbeek nambek nanda ambu lir. Avak ni heyewak sikwa lir, ushok lewas nenjehe mendek nakwa lir. Hako Avui Wasilaka armek or unda lir. Unda osik mberem ji hishindu, jirin armek or ukwa ambu, karem jimu hishindu? Wahau, avak jirin armek ukwa ri. ");
INSERT INTO sim_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jirin amu sawenduwa, mbele mbele akwa, uku, kowe ondonjik ji holowa hala. ");
INSERT INTO sim_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Avui Wasilakahi mashin misinda ambu ondo ondonjik holonda lir. Hako jir erem ji uwa hala. Avui jihi or hevenik linda ol ji lakwak ji hishinda ondo angop or heyewa lir. ");
INSERT INTO sim_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hako ji halashinak malakama jihik or naha mbele mbele ol ji hishiwan avak or haka. ");
INSERT INTO sim_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Karem uwosik mbele mbele ol ushok talakwan ji hishihi wavu musha mushak ji hishiwa hala. Mbele mbele os ushok talakwa ondo ushokop nakwa lira. Mbele mbele ol avak talakwa avakop nakwa lira. Karem uwosik jir avak mbele mbele ushok talakwan ji hishihi ji holowa hala.� ");
INSERT INTO sim_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","�Jir avak ma uwa yokon ji heyehe ji mba, �Avak hik ikwa jir,� karem ji mbanan. Os erem ji mba nahi, Avui Wasilaka kumak avak jirin erem mbakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Os ma li uwak ji heyembanda hom Avui Wasilaka kumak jirin erem heyembakwa ria. Os ma uwak ji heyembanda yombo orok Avui Wasilaka jirin erem ukwa ri. ");
INSERT INTO sim_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mberem ushiwak minimba wasilaka os misokome jihik nawan ji halashihi misup mbrunga os misokome mahasanje jihik nawan ji heyembandu? ");
INSERT INTO sim_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mberem ushiwak kavakava wasilaka os jihik nawan ji esngishashihi kavakava awarikanda os mahasanje jihik nawan ji heye ji laha ermbekwak ji mbandu? Os erem ji mbawa oso kas tolowa ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Masmas kavakava wasilaka jihin ji laha ermbeshihi mahasanje jihi li uwan ji heyembaka. ");
INSERT INTO sim_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jir avak mbele mbele jivi ol Avui Wasilakahik nahandan ji lashihi asan ji hawa hala. Os erem ji u nahi, lir avak li tormblehe jirin shikwa lir. Uhu jir avak mbele mbele jivi ondon flen ji hawa hala. Os erem ji u nahi, men li esnerkokwa lir. Ushihi li tormblehe jirin shikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","�Ermba ermbak Avui Wasilakan ji silinak os ji siliwan orvai haka. Uhu ji lasanak os ji lasawan orvai mukushinak jivai heyeka. Uhu akayangan ji tirinak or sutlashinak jivai layika. ");
INSERT INTO sim_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mberem ushiwak? Ma ol mbele mbelenjik siliwan or handa lir. Ma ol mbele mbelen lasawan or mukushinak heyekwa lir. Ma ol akayangan tiriwan or sutlashinak layikwa lir. ");
INSERT INTO sim_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Os jikisi jihi akwanjik li siliwa, akwan ji halashihi sunja kava yokon hakundaj? Wahau. ");
INSERT INTO sim_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Os foomenjik li siliwa, foomen ji halashihi hovo kava yokon hakundaj? Wahau. ");
INSERT INTO sim_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ambehoma, angop ji heyewa sir. Jir kavakavan unda ma jir. Hako jikisi jihi li siliwa wolo mbele mbele jivi nom lirin handa jir. Uhunda hom Avui Wasilaka jihi or hevenik linda oto mbele mbelen orin ji sili nahi, hakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lo orhi os Moses jirin or hahanda nga mashi ol profet ondo li mbahanda nga maintontlo os li saweri karem, mbele mbele os ma jirin li ukmbaha ji hishiwa hom, jir masmas lirin erem ji uka.� ");
INSERT INTO sim_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","�Jir avak akayanga os nombo jintlak inda nombo orok ji layika. Mberem ushiwak? Os hik inda nombo oso akayanga sihi wasilakak nanda sir. Uhu nombombana lakak si nashiwak ma mushak li heyehe nombo orok inda lira. ");
INSERT INTO sim_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hako akayanga os ermba ermbak linda mishik inda oto awarikanda ri. Uhu nombo jintla kandak or nashiwak ma laptonom li heyehe orok layinda lir.� ");
INSERT INTO sim_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","�Haimba handambanda mashin sawenda ma ondon ji auheyeka. Ondo kala asa indinga lir. Hako sipsip hom li otlehe jirin kavak nakwak rakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hako avak ji heyekrahakorokwa lir, os mi siji jivi os li anda nga mi sijimbale os li anda ambu nga ji heyenda hom. Liri mbeek hamen wanak ji tle akwa ambu sir. Uhunda hom haimba handambanda ma ondo mbele mbele ol li uwa ondo kormbak mukunak ji heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mi mbele mbele ondo angop ji heyenda lir. Lopwa akwa ome jivin wanda sir. ");
INSERT INTO sim_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lopsantla akwa ome kavan wanda sir, mbeek akwa ome jivin wanda ambu sir. Lopwa erem, mbeek akwa ome kavan wanda ambu sir. Akwa jivi nom wanda sir. ");
INSERT INTO sim_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mi ol akwa ome jivin wawa ambu men li shihi hik li ermbeshinak hi ukwa lir. ");
INSERT INTO sim_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Uhunda hom ma ondo ol li liyawa nombo nombo lihi orok ji heilaha ji mba, �Rondo haimba handambanda mashin sawenda ma lira.� ");
INSERT INTO sim_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ma amber hom ol anin, �Wasilaka, Wasilaka,� karem anin ushanda ma amber hom mbeek hevenik layikwa ambu lir, wahau. Ma ol Avui anhi or hevenik linda mashi orhin misindiyawa ma ondo nom kuyanga orhi orok layikwa lira. ");
INSERT INTO sim_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kumak hulaima nokopma mbele mbele li uhundan or heyembakwa wolo ma musha karem anin mbakwa lir, �Wasilaka, nir hi mihik profet mashik ni sawendari on te! Uhu hi mihik wasimalengamban ni mbru ermbendari on te! Uhu hi mihik mbele mbele ma undahi ambun ni undari on te!� ");
INSERT INTO sim_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hako os erem li mbawa wolo lirin a sawekwa karem, �An mbeek jir kas a heyenda ambu nir. Jir kavakavan unda ma jir, ji ika.� Karem a mbakwa lira.� ");
INSERT INTO sim_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","�Ma or mashi anhin misindiyawa ma oto ma or akan armek tolmiskalmisihi unda hom nanda ri. Wormbonawan yawur sunjak or jishiwak si mborna sinda sir. ");
INSERT INTO sim_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ushiwak ma si rakaha fa si rasawak suwa lakak si rasawa wolo aka oso mbeek tarvlanda ambu sir. Mberem ushiwak? Angop or tolmiskalmisihi nor uhunda osik osmu kwambuk sinduwa. ");
INSERT INTO sim_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hako ma or mashi anhin misindiyawa ambu oto ma or aka orhin armek unda ambu hom nanda ri. Wormbonawan armek or tolmiskalmisihi sunjak or jihinda ambu osik aka oso mbeek kwambuk sinda ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ushiwak ma si rakaha fa si rasawak suwa laka si rasawa wolo aka oso kolok tarvlafarakanda sir.� ");
INSERT INTO sim_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas mashi mashi amber or sawerakorik ma ondo wavu lihi musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mberem ushirik? Or mbeek mashi Moseshin sawendari ma hom saweri ambu ri, wahau. Or malakama hom kwambu nga saweri ri. ");
INSERT INTO sim_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas telemban or hala rakarik ma musha mendek orin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Urik okmbale lepra tolondari ma lar Jisasik or taha kumbambongon or huvuhu ormu mbara, �Wasilaka, os mi rupshi nahi, anin mbanak jivik a naka.� ");
INSERT INTO sim_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Karem or mbarik Jisas tava orhin ma otohik or hauowehe ormu mbara, �An mbawa jivik nakwa mira.� Karem or mbarik kolok okmbale lepra oso mendek si narik jivik ormu nara. ");
INSERT INTO sim_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Urik Jisas ormu mbara, �Ai ai, mir avak ma lar tos mirin a uwan sawewa hala. Hako mi ihi maome mihin prisin layi mukunak os jivik mi nawan or heyeka. Uhu ofa os Moses mas or mbahandari nombo hom haka. Ushinak ma amber avak os jivik mi nawan li heyeka.� ");
INSERT INTO sim_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas yanga Kaperneamik or tarik ma lar mu orin ra heyera. Ma oto kepten Romik fehenda maifuk sihi awun unda ma ria. Jisasik or taha ormu tlara, ");
INSERT INTO sim_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","�Wasilaka, anjik lerawun landa ma lar wasilakak or kavamisihi or kumbanashihi kawukop ormu washi tashinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Karem or mbarik Jisas mu mbara, �Avak shi ihi na mbanak jivik nakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Urik ormu mbara, �Wasilaka, an ma jivi ambu nir. Uwosik aka anhik tawa hala. Men mashimbakop mi mbanak jivik or naka. ");
INSERT INTO sim_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mir kwambu nga nawak a heyenda mir, os mbele las mi mba nahi, mi mbawa hom avak nakwa sir. An malakamahi siyok a sihi os lir mbawa hom a unda nir. Uwak awun unda ma anhi ondo erem, anhi siyok li sihi os a mbawa hom unda lir. Os lihi lar a mba, �Mir i!� Karem a mbawa inda ora. Hovok os lar a mba, �Mir ta!� karem a mbawa, tanda ora. Hovok os anjik lerawun landa ma lar a mba, �Lerawu kason la!� Karem a mbawa, lerawu oson landa ora. Mir malakama kwambu nga nawak a heyenda mir, men mashimbakop mi mba nahi, os mi mbawa hom avak nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Karem or mbarik Jisas or misihi or tormblehe ma ol or nga nakrem tari ondon ormu sawera, �Mberemhi tos ter nanduwa! Samba samba toto mashi anhin misindiyanda toria. Hako jir Judama jir lar mbeek or hom mashi anhin misindiyawak a heyenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Omendingak jirin amu sawenduwa, kumak Avui Wasilaka ma orhin or arangoshinak li likwa wolo samba samba yanga apsham apshamhik fehenda ma ondo li taha nir Judama misumu nihi Abraham nga Aisak nga Jekop nga hiyawu laka oson nakrem akwa ola, Avui Wasilaka yanga orhi orok. ");
INSERT INTO sim_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hako Judama ol mas orhi mak or kamahandari ma ondon or kria ermbeshinak nirtle nirndum nanda mishi orok ikwa lir. Uhu orok li lihi tlaha entlembale misihi fu lihin masham koho akwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Karem or mbaha kepten oton ormu sawera, �Mir ika. Os mi siliwa hom angop nawa sir.� Oro wolo mendek ma oto jivik nari ria. ");
INSERT INTO sim_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Urik Jisas Pitahi akak or layihi or heyerik Pita arjava orhi oso si kavamisihi maome sihi hikop si lawurik osmu kawuk wara. ");
INSERT INTO sim_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Urik Jisas tava sihin or tolorik jivik si naha si usaha akwan ornjik simu ura. ");
INSERT INTO sim_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Am si homirik wasimalengamba tolondari ma ondon Jisasik limu laharara. Urik wasimalengamba ondo mashikop or mbarik mbruhu tuluri lir. Uhu kavamisindari ma mushak er nga or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Os or uri oso profet Aisaia mas or mbahandari mashi osmu omek nara. Karem Aisaia kayeri sir, �Orhinjik os ni kavamisindari nihi ondon or laha ermberi ria.� ");
INSERT INTO sim_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Urik Jisas ma musha mendek li ralarik or heyehe ol orin tiyandari ma ondon ormu mbara, �Ka ni i fan mbuhu kauyok ni ika.� ");
INSERT INTO sim_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Urik mashi Moseshin sawendari ma lar Jisasik or taha ormu mbara, �Tisa, yanga yanga os mi yawa mirin a tiya ikwa nir.� ");
INSERT INTO sim_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Urik ormu mbara, �Asa tarmbe wa ngashi lir. Avi aviwusi ngashi lir. Hako Ma Jikisi Avui Wasilakahi aka os or wakwa mishi nga nanda ambu ri.� ");
INSERT INTO sim_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Urik orin tiyandari ma lar mu mbara, �Wasilaka, halanak mas yangak a ihi avui anhin a wakor eweshihi avai raha mirin a tiyaka.� ");
INSERT INTO sim_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Karem or mbarik ormu mbara, �Halashira! Ma ol hahanda ondo halanak lihi ambek li wakor eweka. Hako mir ta anin tiyaka!� ");
INSERT INTO sim_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Urik Jisas bot lasik or lawuhu ol orin tiyandari ma ondo er nga limu ira. ");
INSERT INTO sim_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Li irik suwa wasilaka mendek fa orok si tasarik uku bot akome orok si layihi si hojekurik simu nara. Hako Jisas bot akome orok ormu suknyara. ");
INSERT INTO sim_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Urik ma ondo orin li lembasihi limu mbara, �Wasilaka, avak ni uk aha ni hakwa nir te. Mir nirin jelyawa!� ");
INSERT INTO sim_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Karem li mbarik or usaha ormu mbara, �Jir mberema. Mberem ushiwak ji ajendu? Anin ji hishiowenda nombo mbeek si iw?� Karem huliyik or mbarik suwa nga fa nga mendek simu nara. ");
INSERT INTO sim_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Urik wavu musha mushak li hishihi limu mbara, �Ayo, ma roto lawe mende toria. Suwa nga fa nga mashi orhin fri misihi mendek fri nawan te.� ");
INSERT INTO sim_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Urik Jisas leuku Galilin or mbuhu kauyok yanga Gadarak ormu lawura. Urik ma frijip wasimalengamba tolondari orin frimu ra heyera. Ma ovro mawa mashik ermba ermbak er lindari vria. Uhu man fri jikmbaha urik li ajehe mbeek nombo orok indari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Urik wasimalengamba ma ovron tolondari ondo wasilakak limu mbara, �Mir jikisi Avui Wasilakahi mira. Ayo, mberem nirin mi ukmba unduwa. Nirin kavak mi ukwa wolo os akrik te!� ");
INSERT INTO sim_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fle musha mendek yanga orok pasir sihi ayari lir. ");
INSERT INTO sim_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Urik wasimalengamba ma ovron tolondari ondo limu mbara, �Os nirin mi mbru ermbe nahi, avak mi mbashinak ni ihi fle kandaik ni layika.� ");
INSERT INTO sim_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Karem li mbarik ormu mbara. �Wa, ji ika.� Karem or mbashirik ma ovron li halaha fle ondohik limu layira. Urik fle ondo lewas shirinyambar li ihi fatelembuk li sihi li sangla layihi li uk aha limu harakora. ");
INSERT INTO sim_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Urik ma ol flen washilindari ma ondo oson li heyehe li ajehe yanga pasir nandari orok li tulu ihi os orok talarik li heyerin limu sawera. ");
INSERT INTO sim_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Urik yanga orok fehendari ma amber Jisasik li raha yanga lihi oson or hala ikmbaha kwambuk limu mbara. ");
INSERT INTO sim_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Urik Jisas botik or lawuhu leukun indiyok or mbuhu yanga orhik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Urik ma lar kumba tava nashindarin teyek li ewehe orhik limu kisha laharaha limu hishira, �Avak or mbanak jivik nakwa ri.� Karem limu hishira. Jisas os li hishiri oson angop or heyeri sir. Uri osik ma oton ormu mbara. �Jikisi anhi, ajewa hala! Kavakava mihi angop a laha ermbewa sir.� ");
INSERT INTO sim_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Karem or mbarik mashi Moseshin sawendari ma lal orok li sihi mashi oson li misihi lihi ambek limu mbara, �Ayo, ma toto lawe toria! Wa Avui Wasilakahi farniyik or sikwak ormu mbandu?� ");
INSERT INTO sim_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hako Jisas os wavu wavu lihik li hishirin angop or heyeri osik ormu mbara, �Mberem ushiwak anin ji wapkava hishindu? ");
INSERT INTO sim_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mberem ji hishindu, kavakava ma roto undan a yoko ermbendahi os mo orin a mbanak jivik nandahi or? Hako mberem a undahik ji hishindu? ");
INSERT INTO sim_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Avak a mukunak ji heyekwa sir, Ma Jikisi Avui Wasilakahi oto kavakava ma undan or yoko ermbendahi sir.� Karem or mbaha ma oton ormu mbara, �Mir usasihi teye mihin laha aka mihik ika!� ");
INSERT INTO sim_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Karem or mbarik ma oto or usasihi aka orhik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Urik ma ol orok liri ondo oson li heyehe li ajehe limu mbara, �Ayo, mberemhi tos ter nanduwa! Avui Wasilaka kwambu orhin ma misambik fehendan or handuwa!� Karem li mbaha hi Avui Wasilakahin limu hausimbausira. ");
INSERT INTO sim_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Urik Jisas nombok or ihi takis yan landa ma lar, hi orhi Matyu, opis orhik lerawun or larik ormu heyera. Uhu ormu mbara, �Mir usaha anin tiya shi ika!� Urik Matyu or usaha Jisasin or tiyaha frimu ira. ");
INSERT INTO sim_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas aka Matyuhik or irik ol takis yan landari ma lal nga ol kavakavan undari ma lal nga li taha or nga ol orin tiyandari ma nga nakrem limu ara. ");
INSERT INTO sim_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Urik Farisi lal oson li heyehe ol orin tiyandari man limu mbahanjira, �Mberem ushiwak tisa jihi oto ol takis yan landa ma nga ol kavakavan unda ma nga nakrem or lihi andu? Os erem or uwa kava sir.� ");
INSERT INTO sim_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas mashi oson or misihi ormu mbara, �Ma ol jipmisinda mbeek doktak inda ambu lir. Ma ol kavamisinda nom doktak inda lira. ");
INSERT INTO sim_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","An ma ol kavakavan unda ondon jivinakurik a rari nir. An mbeek ma ol lihinjik hishihi mba, �An ma jivi. An mbeek mbele kava las a unda ambu nir,� karem mbanda ma ondon jivinakurik a rari ambu nir, wahau. Indik ji ihi mashi os Avui Wasilakahi jekambak li kayehendarin armek ji heyehe ji yarika. Karem li kayeri sir, �An mbeek ofa os anin ji hahandan a rupshinda ambu nir. Hako na rupshiwa karem, jir avak man sunguwavu jihi mende nga armek ji uka.� Karem li kayeri oson ji heyehe jivai yarika, an ma kava ondonjik a rari nir.� ");
INSERT INTO sim_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Urik Jonin tiyandari ma ondo Jisasin li heyekurik li taha limu silira, �Nir nga Farisi nga akwan ni halanda nir. Hako mberem ushiwak ol mirin tiyanda ma ondo akwan li halawan li halandu?� ");
INSERT INTO sim_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Karem li mbarik Jisas mu mbara, �Mberem ji hishindu, os ma lar or nokoplaha hiyawu wasilakan or uwa wolo, orhi ma ondo akwan nakrem or nga anda ol mo wahau? Akwan anda ol te! Akwan li aha or nga rupshinda lir. Hako kumak ma oton li tolo laha ishinakop akwan halakwa ola.� ");
INSERT INTO sim_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Uhu sauheima las nga normu sawera, �Os ma lar kowe orhi si frehe nahi, mbeek koutakri akri las or laha koushimbla orok or ewetlavandahi ambu sir. Mberem ushiwak? Os erem or u nahi, kowe oson or yokowa wolo koutakri akri oso avak si ramushihi awarikandak nakwa osa. Uhu koushimbla oson si unak wasilaka mendek frehekwa sir. ");
INSERT INTO sim_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uhunda hom ma lar mbeek wain uku akrin or laha memesishi masi orok ngorondahi ambu ri. Os erem or u nahi, wain uku oso avak si kishalarasanak memesishi masi oso avak numbufaakwa osa. Ushinak wain uku avak misambik ngorokwa osa. Karem unda osik wain uku akrin memesishi akrik li ngoroshinak wain uku nga memesishi nga avak jivik fri naka.� ");
INSERT INTO sim_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas mashin or sawerako namber Judama li lotu undari akan washilindari ma lar orhik or taha kumbambongon or huvuhu ormu tlara, �Jikisi anhi angop hawa sir! Hako mi raha tava mihin hauowehe mbanak si usahaka.� ");
INSERT INTO sim_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Urik Jisas or usaha orin or tiyaha frimu ira. Urik ol orin tiyandari ma er nga limu ira. ");
INSERT INTO sim_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Li irik kolok nokove las asama 12-pelak fi nom ermbendari oso Jisashi kumayok si taha kousamba orhin simu tolora. ");
INSERT INTO sim_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sihinjik karem hishiri sir, �Men kowe orhi nom a toloho avak jivik a nakwa nir.� Karem si hishihi simu tolora. ");
INSERT INTO sim_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Urik Jisas or tormblehe sirin or heyehe ormu mbara, �Apmanuwa, ajewa hala. Os anin nyi hishiowenda nombo orok os nyimu jivik nanduwa.� Oro wolo mendek jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Urik Jisas er or ihi Jairushi akak or taha nor heyeri ma musha orok li lihi holmba owehe matlahukwan li koroho limu tlara. ");
INSERT INTO sim_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Urik ormu mbara, �Mbermbar hikrik ji tala ika! Jikisi toso hawa ambu sir. Tos men wa suknyandu.� Karem or mbarik orin li okolehe limu hayira. ");
INSERT INTO sim_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Urik or mbashirik hikrik li tala irakorik akak or layihi jikisi osohi tavan or tolorik simu usahara. ");
INSERT INTO sim_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Urik jikisi oson or mbarik si usahari mashi oso simbalesik yanga yangak simu ira. ");
INSERT INTO sim_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Urik Jisas yanga oson or hala irik misokome tumundari ma frijip orin fri tiya ihi frimu ushaha tlara, �Jisas nirambara Devithi mirin, shirnjik mi hishiwa!� ");
INSERT INTO sim_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Karem fri mbarik Jisas er or ihi aka os or lindari mishi orok or layirik frir er nga fri lundiyaha akak frimu layira. Urik ormu silira, �Shi hishiwa, am an mbanak jivik shi naku, karem shimu hishindu?� Urik frimu mbara, �He shi hishiwa, mir erem undahi mira.� ");
INSERT INTO sim_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Karem fri mbarik tava orhin misokome frihik or hauowehe ormu mbara, �Os anin shi hishiowenda nombo orok avak jivik nakwa shira.� ");
INSERT INTO sim_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Karem or mbarik kolok misokome frihi huririk frimu heyera. Urik ormu mbara, �Ai ai, kas a uwa kason avak ma lal shi sawewa shi hala.� ");
INSERT INTO sim_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hako, wahau, os jivik fri nari mashi oson yanga yangak frimu saweyara. ");
INSERT INTO sim_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Am fri ishirik ma or mambla jihi maimbandari ambun Jisashik limu laharara. Ma oto wasimalengamba tolondari orik maimbandari ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Urik Jisas wasimalengamba oton or mbru ermbeshirik ormu maimbara. Urik ma amber oson li heyehe limu mbara, �Ayo, tos ter nawak ni heyewa oso himi kas mbeek mas yanga nihi Israel torok talarik ni heyeri ambu os te!� ");
INSERT INTO sim_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hako Farisi lal limu mbara, �Wasimalengamba ondo malakama lihi orin or oloshiwak wasimalengamba ondon ormu mbru ermbenduwa.� ");
INSERT INTO sim_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas yanga yangak amber hom ormu yara. Uhu aka os Judama li lotu undari mishik or layihi mashi os Avui Wasilaka lirin or arangoshinak jip li likuri mashi oson ormu sawera. Uhu ma ol kavamisindarin or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Uhu ma orhik tari ondonjik ormu holora. Mberem ushirik? Or heyeri lir nomorawun li kishaha mbeek ma lar lirin jelyakurik nari ambu ri. Lir sipsip ol ma ngashi ambu hom nandari lir. Karem uri osik lirnjik or holoho ");
INSERT INTO sim_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ol orin tiyandari man ormu mbara, �Akwa musha mende angop ukruwa lir. Hako mbeek sakwa ma lal mushak nawa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Uwosik noumashama Avui Wasilakan ji sawenak ma lal or mbashinak li ihi akwa orhin li saha aka orhik li oweka.� ");
INSERT INTO sim_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas ma ol orin tiyandari 12-pela ondon or usharik li tarik kwambu os or landarin lirin ormu hara. Ushinak wasimalengamba ol man tolondarin li mbru ermbehe ma kavamisindari ondon li mbanak jivik li nakmbaha ormu hara. ");
INSERT INTO sim_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel ondo hi lihi kalira. Ma maifu Saimon oria, hi yeje orhi Pita. Uhu maha orhi Andru. Uhu Jems fre Jon Sebedihi jikisi vria. ");
INSERT INTO sim_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Uhu Filip, Bartolomyu, Tomas, Matyu takis yan landa ma ria. Uhu Jems jikisi Alfiushi ria. Uhu Tadius. ");
INSERT INTO sim_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Uhu Saimon or kraha Selotik fehenda ria. Uhu Judas Iskariot or kumak Jisasin ma kavahi tavarenjek hakuri ma ria. ");
INSERT INTO sim_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas ma 12-pela ondon or usharik li tarik ormu sawera, �Ji ihi mashi anhin ji laha sawe ika. Hako Judama ambu ondo yanga lihik ji iwa hala. Samariak fehe ondohi yangak ji iwa hala. ");
INSERT INTO sim_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hako Israelik fehenda ma ondo yanga lihikop ji ika. Lir Avui Wasilakahi sipsip olira. Hako angop orin li halahanda osik orok ji ihi lirin indik ji laka. ");
INSERT INTO sim_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uhu mashin karem lirin ji saweka, Avui Wasilaka jirin or arangoshinak jip ji likwa wolo oso am si talakwak osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uhu ol kavamisinda ondo nga okmbale lepra tolonda nga ji mbanak jivik li naka. Uhu ma ol hahanda ondon mbanak indik li usahaka. Uhu wasimalengamba ol man tolondan ji mbru ermbenak li ika. Mbele mbele ol ji uwa ondo men ji uka, yakop nembes. Kwambu os lerawu oson ji lawa men a hahanda osik lerawun men ji laka. Jir mbeek kwambu oson yak ji frungawunda osik ma ondon ji mbanak yan li hakwa ambu jir, wahau. ");
INSERT INTO sim_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hako jir avak ya mbele mbele nga ji laha iwa hala. ");
INSERT INTO sim_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mbele mbelen wolonda kowe nga kowe lap er nga kumba ari nga kombe nga ji laha iwa hala, wahau. Men tapas ji ika. Lerawu os ji lawa avak akwan li hanak ji akwa sir. ");
INSERT INTO sim_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yanga lasik ji iwa wolo orok fehenda ma jivi mende lar ji heyeka. Uhu aka orhik ji liyaha jivai hala ika. ");
INSERT INTO sim_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Os aka lasik ji layi nahi, mashaman karem ji mbaka, �Waphimbiji Avui Wasilakahi angop mir nga nawa sir.� ");
INSERT INTO sim_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Os jirin or rupshi nahi, halanak mashi jihi oso orhik er si naka. Hako os jirin or turaha aka orhik jirin or tololayina ambu nahi, mashi jihi oso halanak jihikop si naka. ");
INSERT INTO sim_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Os yanga lasik ji inak mashi jihin li misina ambu nahi, yanga oson ji halaha kumba jeren ji narkanak li heyehe li mba, �Nir angop mbele las ni uwak kavak nawa sir.� ");
INSERT INTO sim_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hako jirin amu sawenduwa. Avui Wasilaka os hulaima nokopma mbele mbele li uhundan or heyehe or mbakwa wolo ma rondo musa lihi orok or heyembakwa ri. Unak nomorawu wasilaka avak lihik talakwa sir. Nomorawu oso wasilaka mendek si naha nomorawu os yanga Sodom nga Gomora nga lihik talahandan tikrikwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Uhu mashi las nga ormu mbara, �Ji misi, avak an mbashinak wutari nindik ikwa jir, os sipsip kala asa nindik li inda hom. Unak jirin kavak li nakmbaha ukwa lir. Karem uwosik mbele mbele os ji ukmbaha ji hishiwan yawur ji hishiyarika. Uhu mbele mbele jivi nom ji uka. ");
INSERT INTO sim_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jihinjik ji auheyeka. Avak jirin li kotim ukwa jir. Uhu jirin li laha os li tirsaha li lotu unda mishik li ewehe li wakorokwa jira. ");
INSERT INTO sim_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mberem ushiwak? Angop mashi anhin ji misihi anin tiyanda oja. Uwosik jirin li laha layi oweshinak malakama lihi misokomek jirin kotim ukwa lir. Erem jirin li una wolo ji sihi mashi anhin ma ol Avui Wasilakahi mashin misinda ambu ondon ji sawenak li misika. ");
INSERT INTO sim_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hako os jirin majistrethi tavak li ewewa wolo wavu jihik ji hishihi ji mba, �Ayo, mberemhi mashin avak ni saweku?� Karem ji hishihi ji ajewa hala. ");
INSERT INTO sim_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mberem ushiwak? Oro wolok Avui Wasilaka Masikome orhi jirin or jelyashinak mashi anhin sawekwa jir. ");
INSERT INTO sim_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kumak avak ma lar mahasanje orhin wutarihi tavak or halashinak li mandingormekwa ri. Avoko jikisi orhin erem ukwa ri. Jikisi erem, avoko nijava orhin erem ukwa ri. ");
INSERT INTO sim_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma amber avak jirin wutarik owekwa lir. Jir angop anhi mak ji nahanda osik jirin wutarik ewekwa lir. Hako os mashi anhin ji misihi kwambuk ji sitambanahanda nahi, kumak Avui Wasilaka indiyok or lakwa jir. ");
INSERT INTO sim_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yanga os ji liwa mishi orok os jirin kavakavak li u nahi, yanga anandik ji tulu ika. Omendingak jirin amu sawenduwa, yanga yanga Israelik fehenda orok lerawun ji larako namber Ma Jikisi Avui Wasilakahi takwa ria. ");
INSERT INTO sim_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Ji misi, os anin li uhunda hom jirin erem ukwa ola. Anin Belsebulik li ushanda hom jirin erem Belsebulik li ushakwa oja. Mberem ji hishindu, sumatin tisa lihin tikrinda ol? Wahau. Lerawun landa ma mashama orhin tikrinda or? Wahau. Mbele mbele os tisan li unda hom sumatin orhi ondon erem ukwa ola. Uhu os lerawu mashaman kavak li unda hom lerawun landa ma orhi ondon erem ukwa ola. Karem uwosik os anin li uhunda hom jirin erem ukwa ola.� ");
INSERT INTO sim_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Uhu mashi las nga ormu mbara, �Ma ol jirin kavak ukmbaha hishiwa ma ondon ji ajewa hala. Mberem ushiwak? Kumak mbele mbele ol li wanyihi li eweshiwak wahanda ondo avak kormbak talakwa lir. Uhu mbele mbele ol li wanyi unda ondo avak kormbak talakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hako mashi os jirin a wanyi sawendan kormbak ji saweka. Uhu mashi sukuk a sawendan nomtenje nomtenjek ji sihi ji sawenak li misika. ");
INSERT INTO sim_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma ol jirin mandingormekmbaha hishiwa ma ondon ji ajewa hala, wahau. Lir men maome jihi nom kavak li uhu li mandingormekwa jir. Hako masikome jihi nga kavak nakwa ambu lir, wahau. Hako jirin kormbak amu sawenduwa, Avui Wasilaka nom ji ajeka. Orto nom man mandingormehe masikome nga hik ermbekwa ria. ");
INSERT INTO sim_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Avi kanda ol fruhu yanda ondon ji heyeka. Ondo mbeek ya lakak li landa ambu lir, wahau. Ya awarikandak li landa lir. Hako Avui Wasilaka lirin armek or uhu mbeek lihi lar or hishandahi ambu lir. Mbele mbele os lihik talakwan angop or heyenda sir. ");
INSERT INTO sim_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Uhunda hom jir erema, mbele mbele os kumak jihik talakwan angop or heyenda sir. Masikukwa jihi nga angop or heyehe or tava kantirakonda lir. ");
INSERT INTO sim_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Uwa osik ji ajewa hala. Or heyewa jir avi kanda ondon tikrinda jir.� ");
INSERT INTO sim_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","�Jirin amu sawenduwa, os kormbak ji sawehe ji mba, �An Jisasin tiyanda ma nira.� Karem ji mba nahi, an ngana, Avui anhi or hevenik linda orhi misokomek karem a sawekwa nir, �Ma tondo anin tiyanda ma lira.� Karem a sawekwa jira. ");
INSERT INTO sim_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hako os kormbak ji sawehe ji mba, �An Jisasin a tiyanda ambu nir.� Karem ji mba nahi, angana, Avui anhi or hevenik linda or heyenak karem a sawekwa nir, �Ma tondon a heyenda ambu lir,� karem a sawekwa jira.� ");
INSERT INTO sim_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","�An mbeek awu os misambi torok talawan mishamaimbakmbaha na rari ambu nir, wahau. Jirin amu sawenduwa, os a rari man a mbanak kraha frijip li sikmbaha na rari nir. Lal kraha anhik, lal wutari anhi kraha orhik sikwa lir. ");
INSERT INTO sim_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jikishulayi avak avokon wutarik ewekwa ri. Jikisnokopji avak nijavan wutarik ewekwa sir. Nukmango avak ruwaihavan wutarik ewekwa sir. ");
INSERT INTO sim_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jikanoka mahasanje avokmundala lihi ambek wutarik ewekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Misi, os avoko nijava jihin wapnuku jihik ji ewehe anin wapmantlek ji ewe nahi, jir mbeek anhi mak nakwa ambu jir. Uhu os jikisi jihin wapnuku jihik ji ewehe anin wapmantlek ji ewe nahi, jir mbeek anhi mak nakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uhu os nomorawu ol jihik talakwan miando hom ji kishaha anin ji tiyana ambu nahi, jir mbeek anhi mak nakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Os mbele mbele jihi ondon ji toltambana nahi, avak mendek nakwa jira. Hako os anin ji hishihi anin ji tiyaha mbele mbele ondon ji hala nahi, kumak avak ermba ermbak linda oson lakwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","�Ma or jirin aka orhik tololayihi armek uwa ma oto os erem or uwa anin er nga armek or uwa sir. Hako antonom nembes, Avui anhi or mbashirik a rahanda er nga armek or uwa ri. ");
INSERT INTO sim_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Os profet larin ji heyehe ji mba, �Ma oto profet Avui Wasilakahi oria.� Karem ji mbaha orin armek ji u nahi, kumak profet oto lawahi hom lakwa jir. Uhu os ma worna man ji heyehe ji mba, �Ma oto ma worna ma ria.� Karem ji mbaha orin armek ji u nahi, kumak ma worna ma lawahi hom lakwa jira. ");
INSERT INTO sim_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Uhu os anin tiyanda man ji heyehe ji mba, �Toto Jisasin tiyanda orik orin armek a ukwa nir.� Karem ji mbaha uksembe kas orin ji ha nahi mo mbele jivi las orin ji u nahi, omendingak jirin amu sawenduwa, os ji uwa oso Avui Wasilaka mbeek hishakashakwa ambu ri, wahau. Kumakop wasan or hakwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas ma 12-pela ol orin tiyandari ondon mashin or sawe lafakaha yanga oson or halaha yanga os pasir nandari orok mashin sawekmbaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Oro wolok Jon krawuk or lihi mbele mbele Jisas or urin or misihi ol orin tiyandari man or usharik limu tara. ");
INSERT INTO sim_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Unak or mbashinak Jisasik li ihi karem li silikmbahan, �Mir ma or hulaima nokopman jivinakmbaha Avui Wasilaka kamahanda ma om? Mo anandi lar ni nikishikwa on?� ");
INSERT INTO sim_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Karem or mbashirik Jisasik li ihi orin li silirik ormu mbara, �Indiyok Jonik ji ihi os ji misiwa nga mbele mbele ol ji heyewa ondo nga orin ji sawenak or misika. ");
INSERT INTO sim_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Misokome tumunda li heyewak, kumbanashinda li ese yawak, okmbale lepra tolonda jivik li nawak, mamblanjihinda li misiwak, ma ol hahanda indiyok li usahawak, erndakava mashi jivi Avui Wasilakahin olmu misinduwa. ");
INSERT INTO sim_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Uhu kason er nga orin ji saweka, ma ol mbele mbele a uwan heyehe anin wapkava hishiwa ambu ondo li rupshika. Avui Wasilaka armek or ukwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jonhi ma ondo am li hala ishirik Jisas ma ol orok liri ondon ormu sawera, �Misamtelmbamba orok ji ihi Jon mberemhi mak or narik ji heyer? Apmbayise os suwa si rasa laha ermbewak ayai ayaranda hom or narik ji heyeri or? Wahau. ");
INSERT INTO sim_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mo ji ihi mbele menden ji heyer? Kowe jiviwavin or faleshirik ji heyeri or? Wahau. Ma ol kowe jiviwavin falenda ondo malakamahi akakop linda lir. ");
INSERT INTO sim_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hako ji ihi mberem or narik ji heyer? Ji ihi profet lar heyer oj? He, oto profet oria. Jirin amu sawenduwa, or profet ondon amber tikrinda ria. ");
INSERT INTO sim_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mberem ushirik? Jekamba Avui Wasilakahik mashi las karem li kayeri sir, �Misi, avak ma lar a halashinak masmas or ihi nombo mihin hundujekwa ria.� Karem li kayehendari ma oto Jon oria. ");
INSERT INTO sim_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Omendingak jirin amu sawenduwa, Jon ma misambik fehe amber ondon tikrihinda ria. Hako Avui Wasilaka hulaima nokopma orhin or arangoshinak kuyanga orhik li likwa wolo ma ol hi ngashi ambu ondo Jonin tikrikwa lir. ");
INSERT INTO sim_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon lerawu orhin or lari wolok sishi raha Avui Wasilaka jirin or arangoshinak jip ji likwa oso osmu kormbak talanduwa. Hako ma lal oso kormbak si tala, karem mbaha kwambu lihik lerawun ormu landuwa. ");
INSERT INTO sim_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jon os or talaha mashin or sawe namber profet ondo nga mashi os Moses sawendari oso nga mbele mbele os kumak kormbak talakundarin angop li saweri lir. ");
INSERT INTO sim_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Uhu profet ondo Elaija indik or takuri mashi nga saweri lir. Omendingak jirin amu sawenduwa, Elaija or indik takurik li mbari ma oto Jon oria. ");
INSERT INTO sim_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ma or mambla ngashi halanak mashi kason li misika. ");
INSERT INTO sim_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Wa, jir ter liwa ma jirin, mberem nanda ma jir? Jir jikisakri os ma li tirsanda mishik mainlaka lakak mbanda hom nanda jir. ");
INSERT INTO sim_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","�Wakun ni tokowa wolo jir mbeek rupshihi mblanda ambu jir. Matlahukwan ni korowa wolo jir mbeek tlanda ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Uhunda hom jir jikisakri ondo hom nanda jir. Jon akwan or halaha wain uku nga or ari ambu osik orin ji heyehe ji mbahanjira, �Toto wasimalengamba tolonda orik akwan anda ambu ri.� Karem jimu mbara. ");
INSERT INTO sim_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hako Ma Jikisi Avui Wasilakahi oto akwa nga wain uku nga or awak ji heyehe jimu mbanduwa, �Ayo, toto akwa nom or hishihi uku kavan or aha ambasinda re. Takis yan landa ma nga kavakavan unda ma nga ananaimble tolonda re.� Karem mbahajinda jir. Hako os erem ji heilakaila mbanda oso kas tolonda ambu sir. Hako ma or hishiyarinda nga nawa oto mbele mbele jivi nom or unak ni heyehe ni mba, or hishiyarinda ma ria.� ");
INSERT INTO sim_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas ma undahi ambun mushak or uri lir. Hako ma ol mbele mbele or uri ondon heyeri ondo mbeek sunguwavu lihin tormbleri ambu lir. Karem uri osik lirin ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","�Jir yanga Korasinik fehenda ma nga Betsaidak fehenda ma jirnjik amu holo mendenduwa. Mberem ushiwak? Avak kavak nakwa jir. Mbele mbele ol a uri angop ji heyeri lir. Hako mbeek sunguwavu jihin tormbleri ambu jir. Hako os Avui Wasilakahi mashin misinda ambu ondo ol yanga Tair nga Saidon nga li linda orok a ihi mbele las ma undahi ambun a urikop orok fehe ma ondo angop kavakava os li undarin li halaha sunguwavu lihin tormbleri lir. Hako jir wahau. ");
INSERT INTO sim_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Unda osik ji misi, Avui Wasilaka os hulaima nokopma mbele mbelen li uhundan or heyembakwa wolo nomorawu os jihik talakwa oso wasilaka mendek si naha nomorawu os yanga Tair nga Saidon nga lihik talakwan tikrikwa sir. ");
INSERT INTO sim_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jir yanga Kaperneamik fehe jirin, jir am Avui Wasilaka mbanak hevenik ji lawuku? Karem jimu hishindu? Wahau. Mende indinga. Jir avak hik ikwa jir. Mberem ushiwak? Os ma undahi ambu os jihi nindik a urik ji heyeri hom yanga Sodom orok a uhundarikop Sodom mbeek kavak nari ambu sir. Uhundak ter er nawak ni heyewa sir. ");
INSERT INTO sim_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jir yanga Kaperneamik fehe jirin amu sawenduwa, Avui Wasilaka os hulaima nokopma mbele mbele li uhundan or heyembakwa wolo nomorawu wasilaka mende avak jihik talakwa sir. Uhu oso Sodomik talahandan tikrikwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Uhu Jisas ormu mbara, �Avuya, heven nga misambi nga mihi tavakop nahanda vria. Mirin amu rupshinduwa. Mberem ushiwak? Mir mbeek mbele mbele ondon ma ol hi ngashi ondon mi mukushiwak heyenda ambu sir. Hako ma ol jikisakri hom nanda nom mi mukushiwak heyenda lir. ");
INSERT INTO sim_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ome sira, Avuya, os mi ukmbaha mi hishinda hom unda mira. ");
INSERT INTO sim_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mbele mbele ondo amber Avui anhi angop anhi tavak or hari lir. Ma lar mbeek Jikisi orhin armek heyekrahakoronda ambu ri. Hako Avui nom Jikisi orhin heyenda ri. Ma lar mbeek Avuin heyekrahakoronda ambu ri, wahau. Jikisi orhi orto nom Avui orhin heyenda ri. Unda osik ma ol or rupshinda ondo nom Avui orhin or mukunak li heyekwa ri. ");
INSERT INTO sim_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jir nomorawu wasilakan kisha avishawa ma jirin, anhik ji raha ji limasika. ");
INSERT INTO sim_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","An anhinjik a hafakaha man naman a sawenda nir. Karem uwosik halanak jirin a ewesaweka. Anhik ji raha anhi siyok ji sika, os bulmakau minimba tombon li ishishiwak li longonda hom miando anhin erem ji kishaka. Uhundanak anhik ji raha ji limasika. ");
INSERT INTO sim_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Minimba tombo os jirin a hawa oso mbeek nomoyikwa ambu sir. Uhu mbele mbele os ji kishakmbaha jirin a hawa oso nomoyikwa ambu sir. Larnashinak ji kishakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Urik am Sabat wolok si narik Jisas le wit nowe nindik limu ira. Uhu orin tiyandari ma ondo li erenghaha wit sijin li tolntlehe li sengashihi limu ara. ");
INSERT INTO sim_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Urik Farisi lal li heyehe limu mbara, �Mberem ushiwak mirin tiyanda ma ondo lo os si pantlehendan Sabat wolok li undu?� ");
INSERT INTO sim_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Karem li mbarik ormu mbara, �Os king Devit nga orhi ma nga li erenghari wolok or uhundari mashi os jekambak li kayehendarin heyenda ambu oj? ");
INSERT INTO sim_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aka Avui Wasilakahik or layihi ofan li handari bretin or laha ol orin tiyandari ma nga li arin. Bret ondo pris nom li andari lir, ma anandi wahau. ");
INSERT INTO sim_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Uhu mashi ome las os Moses or kayehendarin heyenda ambu oj? Pris ondo os Sabat wolok lerawu las tempel akak li lakuri wolok si narik lerawun landari ola. Hako mbeek musa nga nari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hako jirin amu sawenduwa, ma or tor torok siwak ji heyewa toto tempel akan tikrinda ma ria. ");
INSERT INTO sim_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hako mashi os jekamba Avui Wasilakahik li kayerin ji misika. Karem li kayeri sir, �An mbeek ofa os anin ji hahandan a rupshinda ambu nir. Os a rupshinda karem, jir avak man sunguwavu jihi mende nga ji holoho armek ji uka.� Os mashi oson armek ji heyekrahakoro nahi, jir mbeek ma ol musa ngashi ambu ondon kotim ukwak mbakwa ambu jir. Hako jir mbeek mashi oson heyekrahakorowa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ma Jikisi Avui Wasilakahi oto Sabatin er nga arangonda ri.� ");
INSERT INTO sim_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ushihi Jisas yanga oson or halaha Judama lotu undari akak ormu layira. ");
INSERT INTO sim_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Urik ma tava kavak nandari lar er nga orok liri ria. Urik ma lal Jisasik li taha limu silira, �Os ma lar Sabat wolok ni mbanak jivik or nakwa oso jivik nawa os mo wahau? Lo nihi mberem si mbandu?� Os erem li siliri men orin li mbanak or mbanak li heyekmbaha li mbari sir. Mbele las or unak kavak si nanak li heyehe orin li kotim ukmbahan. ");
INSERT INTO sim_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Urik ormu mbara, �Os sipsip jihi lar Sabat wolok faramblangok or layi nahi, mberem jivai uku? Sipsip jihin jelyakwa oj mo men misokomembak heyekwa oj? Wa, sipsip jihin jelyakwa oja. ");
INSERT INTO sim_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hako ma oton ji heyeka, or sipsipin tikrinda ria. Karem uwosik os Sabat wolok ma lar ni jelya nahi, oso jivi sira, mbeek kavak nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Karem or mbaha ma oton ormu mbara, �Tava mihin sanguananak a heye.� Urik tava orhin or sanguanarik jivik si naha tava jivi yeje orhi hom simu nara. ");
INSERT INTO sim_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Urik Farisi ondo tempel akan li halaha li ihi os Jisasin li mandingormekuri nombon limu anaoweheyera. ");
INSERT INTO sim_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas os Farisi orin kavak li ukmbaha li hishiri nombon angop or heyeri sir. Karem urik yanga oson or halaha yanga anandi lasik ormu ira. Urik ma mushak orin limu tiya ira. Urik or mbarik ma ol kavamisindari ondo jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Uhu hi orhin kormbak li sawekurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mbele mbele ol or uri ondo li urik mashi os profet Aisaia maskop or kayehendari osmu omek nara. Karem or kayeri osa. ");
INSERT INTO sim_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","�Ma roton ji heyeka, lerawu anhin lakwa ma ria. Anhinjik angop a kamari ria. Wapnuku anhik orin amu ewenduwa. Masikome anhin a halashinak orhik nakwa sir. Uhu nombo wornan Judama ambu ondon or saweshinak li misika. ");
INSERT INTO sim_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Or mbeek man ngriaha mainkwambuk mbakwa ambu ri. Mbeek nomtenje nomtenjek sihi mashin kwamburambuk mbakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fakri os tlendirnawan or mbeek toltarmbakwa ambu sir. Lam os usungua hakwak nawan or mbeek usungua hakwa ambu sir. Lerawu anhin or laha ihikop ma amber nombo worna orhin heyekrahakorokwa lir. ");
INSERT INTO sim_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ushinak ma amber, Judama ambu ondo er nga, orin wavu lihik li ewehe li mbaka, �Ortonom nirin jivinakwa ma ria.� � ");
INSERT INTO sim_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Urik ma lar wasimalengamba toloshirik misokomen tumuhu maimbandari ambu oton Jisasik limu laharara. Urik wasimalengamba ma oton tolondarin or mbru ermbeshirik ma oto jivik or naha or heyehe ormu maimbara. ");
INSERT INTO sim_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Urik ma ol orok liri ondo oson li heyehe limu mbara, �Ayo, ma roto kar ni nikishinda king Devithi nirambara or mo?� ");
INSERT INTO sim_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Urik Farisi ondo mashi oson li misihi limu mbara, �Wahau te! Wasimalengamba Belsebul oto orin or olonda osik orhi kwambuk ol ormu mbru ermbenduwa.� ");
INSERT INTO sim_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Erem li mbarik Jisas sunguwavu lihin angop or heyeri sir. Uhu ormu sawera, �Ji hishika, os yanga lasik linda ma lihi ambek li anaji nahi, yanga oso avak kavak nakwa sira. Uhu hovok, os mahasanje lihi ambek li anaji nahi, lihi ambek anakorokwa lir. ");
INSERT INTO sim_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Uhu os Laulaka wasimalengamba orhi ondo lihi ambek li anaji nahi, avak mbruhu ihi mendek nakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Os anin ji mba, an Belsebulhi kwambuk wasimalengamban amu mbru ermbenduwa, os erem anin ji mba nahi, jirin a silikwa karem, jihi ma ol wasimalengamban mbru ermbenda ondo lawehi kwambuk lerawu oson li landu? Lir er nga wasimalengamban li mbru ermbenda osik, lir avak mashi mashi os anin ji heyembawa hom jirin heyembakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hako an mbeek Belsebulhi kwambuk lerawun a lawa ambu nir, wahau. An Avui Wasilaka kwambu orhik lerawun amu landuwa. Erem si nawa osik ji heye ji yarika, Avui Wasilaka hulaima nokopma orhin or arangoshinak jip li likwa oso angop jihik talawa sir. ");
INSERT INTO sim_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ji hishika, ma or kwambu ngashi os aka orhik mbele mbele orhin ji lakwak ji hishi nahi, mberem jivai uku? Masmas kumba tava orhin kuvuk ji ishishinak or wanakop aka orhik ji layihi mbele mbele orhin lakwa jira. ");
INSERT INTO sim_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ji misi, ma or anhi mak nawa ambu ondo wutari anhi lira. Uhu ma ol an nga lerawun ni lawa ambu ondo olmu lerawu anhin kavak nakwak unduwa. ");
INSERT INTO sim_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jirin amu sawenduwa, mbele mbele kavakava ma li unda nga okolenda mashin li mbahanda nga Avui Wasilaka or laha ermbekwa lir. Hako os Masikome orhin li okole nahi, kavakava os li unda oson mbeek or laha ermbekwa ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ome sira, os ma lal li okolehe mashi kavan Ma Jikisi Avui Wasilakahin li mba nahi, Avui Wasilaka avak kavakava lihin or laha ermbekwa sir. Hako os Masikome orhin li okole nahi, kavakava os li unda oso mbeek or laha ermbekwa ambu sir, wahau. Mende indinga.� ");
INSERT INTO sim_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","�Mi jivi mbeek akwa kavan wanda ambu sir. Uwak mi kava mbeek akwa jivin wanda ambu sir. Mberem nivai heyeku jivi os mo kava os? Akwa ome frihin ni heyehe ni mba, �Mi toso jivi sira. Hako kasai kava sir.� � ");
INSERT INTO sim_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Karem or mbaha Farisi ol orok siri ondon or heyehe ormu mbara, �Jir ma kava hopmbale hom nanda jir. Mbele mbele kava os sunguwavu jihik nawa hom suwambushi jihik tasawak jimu mbanduwa. Uwosik jir mbeek mashi jivi las mbakwak nanda ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma jivi wavu orhi osmu ukwa jivi hom nanduwa. Mbele mbelen or uwak ukngrahambi hom osmu orhik tasawak nimu heyenduwa. Hako ma kava wavu orhi osmu ukwa kava hom nanduwa. Uwak mbele mbele kava os or uwa uku kava krupshinda hom osmu orhik tasawak nimu heyenduwa. ");
INSERT INTO sim_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Omek jirin amu sawenduwa, Avui Wasilaka hulaima nokopman or heyembakmbaha nor mbahanda wolo ma amber mashi os li mbahanda nombo orokop or heyembakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mashi os ter ji mbawa mashi orokop kumak jirin heyehe mbakwa ri. Os mashi jivin ji mba nahi, os ji mbawa nombo orokop or heyembakwa ri. Hako os mashi kavan ji mba nahi, os ji mbawa nombo orokop heyehe mbakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Urik Farisi lal nga mashi Moseshin sawendari ma lal nga Jisasik li taha limu silira, �Tisa, mbele las ma undahi ambu ondon mi unak ni heyewa. Os ni heyena ambu nahi, nir mbeek mirin tiyakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Urik ormu mbara, �Ma jir ter wolok liyawa ma jirin, jir ma kava indinga jir. Jir ma undahi ambu lal a unak ji heyekmbaha jimu mbanduwa. Hako an mbeek mbele las a unak ji heyekwa ambu sir, wahau. Hako mbele las os profet Jonahik narik ji misindari hom avak si nanak ji heyekwa sir. ");
INSERT INTO sim_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona niri frijip foome lakahi sunguk wari ri. Uhunda hom Ma Jikisi Avui Wasilakahi oto niri frijip mawak wakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ji misi, Avui Wasilaka os hulaima nokopma mbele mbele ol li uhundan or heyembakwa wolo yanga Ninivek fehe ma ondo mbele mbele kavakava os ji undan kormbak li sawehe jirin mbakwa ola. Jona mas Avui Wasilakahi mashin lirin or sawerik li misihi sunguwavu lihin tormbleri lir. Hako jir wahau. Jir mbeek sunguwavu jihin tormblekuri kas nga nanda ambu jir. Uwosik lir jirin mbakwa ola. Hako Jonan tikrinda ma ormu torok jir nga sinduwa. Hako jir mbeek mashi orhin misinda ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hovok hiusha nokove yanga Sebak fehe oso erem kavakava os ji undan kormbak si sawehe jirin mbakwa osa. Sir mas yanga sihi homek nandarin si halaha si taha King Solomon hishiyandari orhin si misikmbaha tari osa. Hako Solomonin tikrinda ma ormu torok jir nga sinduwa. Hako jir mbeek mashi orhin misindiyakwak hishinda ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Uhu sauheima las nga Jisas ormu mbara, �Ji misi, wasimalengamba lar ma or or tolondan or halashihi misamtelmbambak or ihi or likuri mishin lasakurik ormu ira. Or lasafuhu ormu mbara, �Halanak indik aka os a halashihi a rahanda mishik a i lika.� ");
INSERT INTO sim_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Karem or mbaha indik or ihi nor heyeri, ma oto aka orhin angop armek or hako ermbeshirik jivik nari sir. ");
INSERT INTO sim_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ushirik oson or heyehe wasimalengamba 7-pela ol orin tikrinda kava indingan or sawelaha li layihi aka orok limu lira. Ushirik ma oto kava indingak er ormu nara, mbeek kas jivik nari ambu ri, wahau. Uhunda hom jir ter liwa ma jirin, jir avak ma oto hom ji naha kavak er nakwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas mashin or sawerako namber, nijava orhi nga jimatama orhi nga orin li heyekmbaha li taha hikrik limu sira. ");
INSERT INTO sim_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Urik ma lar Jisasin ormu mbara, �Tisa, nijava mihi nga jimatama mihi nga mirin li heyekwak li taha kandai hikrik sindu.� ");
INSERT INTO sim_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Karem or mbarik ormu mbara, �Lawe nijava anhi sir? Lawe ol jimatama anhi lir?� ");
INSERT INTO sim_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Uhu tava orhik ol orin tiyandari ma ondon or mukuhu ormu mbara, �Nijava anhi jimatama anhi tolira. ");
INSERT INTO sim_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ma ol Avui anhi or hevenik linda mashi orhin misindiyawa ma ondo nijava anhi jimatama anhi lira.� Karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Urik Jisas aka os or lirin or halaha leuksumbuk or irik ");
INSERT INTO sim_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ma musha mendek orhik li rarik or usaha bot lasik or lawuhu orok ormu lira. Urik ma ondo fa mambuk limu sira. ");
INSERT INTO sim_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Urik mashin sauheimakop or sawehe ormu mbara, �Ji misi, ma lar wit sijin or laha ormu nowek faka ira. ");
INSERT INTO sim_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Or laha faka irik lal olmu nombok takara. Urik ma li esnerkoshirik avi mu nongo ara. ");
INSERT INTO sim_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hovok lal olmu sunja hongondari mishik takara. Uhu lewas tungua rasari ol te. Hako misambi mbeek misam jeromek nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sunja hongondari osik mbeek nene lakak layiri ambu sir. Uri osik ta jiri wolo olmu hatlayirakora. ");
INSERT INTO sim_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hako lal olmu minja lame nindik takara. Urik minja lame ondo er nga li tasaha mushi arangoshirik olmu hatlayihi mendek nara. ");
INSERT INTO sim_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hovok lal olmu misambi jivik takara. Uhu li tungua rasaha akwa ome musha mendek olmu nara, lal 30-pelak, lal 60-pelak lal 100-pelak.� ");
INSERT INTO sim_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Uhu ormu mbara, �Ma ol mambla ngashi halanak mashi kason li misika.� ");
INSERT INTO sim_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Urik ol orin tiyandari ma ondo orhik li taha limu mbara, �Ma rondon sauheimakop mi saweshiwak lir mbeek yarinda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Urik ormu mbara, �Avui Wasilaka nombo os hulaima nokopma orhin or arangokmbaha or mbandari nombo os mas wanyiwandari oson angop jirin a mukurik ji heyeri sir. Hako ma anandi ondo sauheimakop a sawewak misinda lir. ");
INSERT INTO sim_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mberem ushiwak? Ma or sunguwavu orhi nga mashi anhin misikwak hishiwa ma oto avak a unak mbele mbele ondon armek hishiyarikwa ri. Hako ma or mashi anhin men mamblakop misiwa ma oto avak a unak hishiyarinda orhi os orhik nawa oso mendek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Maintontlo os sauheimak a mbawa karem, misokome lihik li heyewa, hako mbeek mbele las heyewa ambu lir. Mambla lihik li misiwa, hako mbeek mbele las yariwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Os erem a uwa oso si unak mashi os profet Aisaia mas or mbahandari osmu omek nanduwa. Karem or kayeri sir, �Ma ondo hindi mushak mashin misikwa lir. Hako mbeek hishiyarikwa ambu lir. Hindi mushak heyekwa lir. Hako mbeek armek mbele las heyekrahakorokwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mberem ushiwak? Sunguwavu lihi angop fenjehe sunjakombe hom nanda sir. Uhu mambla lihi angop jihinda sir. Uhu misokome lihi angop tumunda sir. Uwosik lir mbeek mashi anhi maintontlo sihin heyekrahakorokwa ambu lir. Uhu lir mbeek sunguwavu lihin li tormblehe anhik li ranak a unak jivik nakwa ambu lir.� � ");
INSERT INTO sim_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Uhu Jisas mashi las nga ol orin tiyandari man ormu mbara, �Omek amu sawenduwa, profet mas nahandari nga Avui Wasilakahi mak nahandari nga mbele mbele tos ji misihi ji heyewan heyekurik hishiri ol te. Hako mbeek heyeri ambu lir. Hako jir os jimu misokome jihik heyehe mambla jihik misinduwa. Uwosik ji rupshika.� ");
INSERT INTO sim_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Uhu ormu mbara, �Sauheima ma or wit sijin fakari maintontlo sihi karem. Wit siji ondo mashi Avui Wasilakahin olmu heimanduwa. ");
INSERT INTO sim_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit siji ol li takawa nombo oso osmu ma ol mashi Avui Wasilakahin men mamblakop misinda ma ondon heimanduwa. Kolomalok Laulaka or raha mashi os sunguwavu lihik wawa oson ormu laha ermbenduwa. ");
INSERT INTO sim_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sunja hongonda mishi oso osmu ma ol mashin misihi rupshiwa ma ondon heimanduwa. ");
INSERT INTO sim_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hako nene mbeek kasalkop layinda ambu osik nambek sinda ambu lir. Os nomorawu lihik si lawuwa, olmu kolok mashin halawa. ");
INSERT INTO sim_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uwak minja lame ngashi mishi oso osmu ma ol mashin misindiyanda ondon heimanduwa. Hako mbele mbele misambik fehen mushak li lakwak hishinda ola. Uhu mbele mbele misambik fehenjik hishombashiowenda ola. Uwosik wit siji supmbalapmbak li nashiwak mbeek akwa ome nga nanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hako misambi jivi oso osmu ma ol mashin misihi kwambuk toltambananda ondon heimanduwa. Mashin li tiyaha kwambuk li sitambanaha olmu akwa ome nga mushak nanduwa, lal 30-pelak, lal 60-pelak, lal 100-pelak.� ");
INSERT INTO sim_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Uhu sauheima las nga ormu sawera, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso mberem sivai nandu? Wa oso ma or wit siji jivin nowe orhik laha fakayanda hom osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hako nirik li suknyashiwak ma oto wutari orhi or taha minjambale sijin or laha nowe orok er nga nor lahara fakashihi ormu iwa. ");
INSERT INTO sim_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ushiwak siji ondo li tungua rasaha ome nga li nawak minjambale er nga lihi nindik li tungua rasawak ma olmu heyewa. ");
INSERT INTO sim_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Uhu lerawun landa ma ondo li ihi noumashaman olmu sawera, �Awasayi, mir wit siji jivi nom mi fakari ola. Hako ter ni heyewak minjambale er nga rasaw te!� ");
INSERT INTO sim_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Urik ormu mbara, �Wutari anhi lar ormu erem uwa ri.� Urik limu silira, �Wa minjambale ondon mberem ni ukmbaha mi hishindu? Ni kwaha ermbekmbaha mi hishindu mo wahau?� ");
INSERT INTO sim_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Urik ormu mbara, �Wahau, las avak wit jivi ondo er nga ji kwanda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Halanak nakrem li rasaha akwa omen landa wolok si nanak a mbashinak akwan landa ma ondo li ihi minjambalen li kwaha tene tenek li tivihi hik li ermbeshinak hi ukwa ola. Hako wit jivi nom li laha safal aka anhik li eweshinak li waka.� � ");
INSERT INTO sim_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Uhu sauheima las nga ormu sawera, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso siji awarikanda kanda mastet hom nanda sir. ");
INSERT INTO sim_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet oso siji awari mende kanda sir. Hako li sishiwak lewas tungua rasaha wasilakak mi hom nanda sir. Ushiwak avi li raha aviwusin mi tava orok uhu linda lir.� ");
INSERT INTO sim_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Uhu ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso yis hom nanda sir. Nokove las os bretin si uwa wolo, yis kandakar si laha plaua laka nga simu farfasawa. Uwak yis oso si uwak plaua oso wasilaka mendek osmu nawa.� ");
INSERT INTO sim_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas mbele mbele os or saweri sauheimakop or saweri lir. Or mbeek ma ondon mashi las kormbak saweri ambu ri, wahau. Men sauheimakop saweri ri. ");
INSERT INTO sim_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Os erem or uri oso mashi os profet or mbahandari mashi osmu omek nara, �Avak sauheimakop jirin a ewesawekwa nir. Misambi mbele mbele na namber orok sishi raha wanyiwanda ondon sauheimakop a sawenak ji misikwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Urik Jisas ma ondon or halashihi akak or layirik ol orin tiyandari ma li raha limu silira, �Sauheima minjambale os mi sawewa oso maintontlo sihin sawenak ni misika.� ");
INSERT INTO sim_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Urik ormu mbara, �Ambehoma, wit siji jivin fakawa ma oto Ma Jikisi Avui Wasilakahi ria. ");
INSERT INTO sim_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nowe oso misambi toso osira. Wit siji jivi ondo ma ol Avui Wasilaka lirin or arangoshinak orhi yangak li likwan nikishiwa ma olira. Minjambale kava ondo Laulakahi ma olira. ");
INSERT INTO sim_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wutari or minjambalen fakawa oto Laulaka oria. Akwa omen landa wolo oso mbele mbele mendek li nakwa wolo osira. Akwan landa ma ondo ensel olira. ");
INSERT INTO sim_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Os minjambalen li kwaha li suwunda hom, erem mbele mbele am mendek si nakuna wolok Laulakahi man li ukwa lira. ");
INSERT INTO sim_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ma Jikisi Avui Wasilakahi oto ensel orhin or mbashinak li raha ma kava ondon li kria ermbeshinak Avui Wasilakahi yanga oson halakwa lir. Ma ol man mbaskashiwak kavakavan li unda ma nga kavakavan unda ma nga li kria ermbeshinak ");
INSERT INTO sim_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hik ikwa lir. Orok li layihi li tlaha entlembale misihi fu lihin masham koho akwa ola. ");
INSERT INTO sim_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hako Avui Wasilakahi misokomek wornak nanda ma ondo yanga orhik li lihi jivik li naha ukruharanda hom nakwa lir. Jir mambla ngashi jir, mashi kason ji misika.� ");
INSERT INTO sim_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Urik sauheima las nga ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso bokis ya hom nanda sir. Bokis ya oso wan li koroho li wanyishirik osmu misambi lasik wara. Hako ma lar os li wanyindari mishin angop or heyeri sir. Ushihi sunguwavu orhi nga bokis ya oson lakurik hishiri ri. Uhu indik bokis oson or wanyishihi or ihi mbele mbele orhin or mbashirik li frungawushirik ya oson or laha or ihi misambi mashaman ormu hara. Erem or uri nombo orok bokis ya os misambi orok wanyiwandarin ormu er nga lara.� ");
INSERT INTO sim_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Uhu sauheima las nga ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso mberem sivai nandu? Wa oso karem, bisnisman lar sunja arme ondon frungawukmbaha ormu lasayara. ");
INSERT INTO sim_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Or laslasa ihi jivi mende las or heyehe oso nom lakurik hishombashioweri ri. Ushirik mbele mbele os or hisindari orhi ondon or mbashirik ma li raha li frungawushirik ya oson or laha sunja arme oson ormu frungawura.� ");
INSERT INTO sim_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Uhu ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak orhi yangak li likwa nombo oso foom kowe hom osmu nanduwa. Foom kowe oson leukuk li ermbeshihi foome apsham apshamhin olmu kruwunduwa. ");
INSERT INTO sim_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Foom kowe oso foome am si hojewak mishiyok li longo lafasanda sir. Uhu foome ol li lowan limu toloyariwa, jivin apsham li ewehe kavan ol limu lai ermbewa. ");
INSERT INTO sim_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Uhunda hom mbele mbele am mendek si nakuna wolok erema, ensel ondo li taha ma kava ol ma jivi nindik liwa ondon li toloyarikwa lir. ");
INSERT INTO sim_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Uhu ma kavan hik li ermbekwa lira. Li ermbenak orok li layihi li tlaha entlembale misihi fu lihin masham koho akwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Karem or mbaha ol orin tiyandari man ormu silira, �Maintontlo os a sawewan am jimu yarindu?� Urik limu mbara, �He, am nimu yarinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Urik ormu mbara, �Os mashi Moseshin sawendari ma ondo mashi anhin tiyanda mak li na nahi, lir aka mashama hom nakwa lira. Aka mashama oto aka orhik or ihi mbele mbele akri nga masi nga or laharakwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas sauheima ondon or sawerakoho yanga oson or halaha ");
INSERT INTO sim_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kotontlo orhi Nasaretik or ihi aka os li lotu undari mishik or layihi mashin ormu sawera. Mashi os or sawerin li misihi wavu lihi musha mushak li hishihi limu mbara, �Ayo, ma toto hishiyarinda toso mbeyok or lar? Kwambu os ma undahi ambun or uwa mbeyok or lar? ");
INSERT INTO sim_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Toto angop ni heyenda or te! Ma or akan unda jikisi orhi ria. Nijava orhi Maria sira. Jimatama orhi Jems, Josep, Saimon, Judas, kalira. ");
INSERT INTO sim_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jikaha orhi tol er nga limu linduwa. Hako kwambu os erem or uwa mbeyok or lar?� ");
INSERT INTO sim_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Karem li mbaha orin limu kumaifara. Urik Jisas lirin ormu mbara, �Profet ondo yanga yanga amber hom hi lihin hauowenda lir. Hako kotontlo lihi nga sanjemunda jikanoka lihi nga wahau, mbeek hi lihin hauowenda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Karem or mbaha mbeek mbele las ma undahi ambun mushak orok uri ambu ri. Mberem ushirik? Lir mbeek orin li heyehe mbar, �Toto Avui Wasilakahi kwambu ngashi ria.� Karem mbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Oro wolok Herot provins Galilin arangondari ma oto mbele mbele ol Jisas urin or misihi ");
INSERT INTO sim_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ornjik lerawun landa man ormu sawera, �Ma oto Jon man fak tolofalendari ma or a mandingormeri oria. Indik mawak or usahanda osik kwambu orhi nga lerawun ormu landuwa.� ");
INSERT INTO sim_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mberem ushirik Herot wavu erem or hishir? Or maha orhi Filiphi nokoven or masnalari ora. Nokove oso hi sihi Herodias osira. Ushirik Jon or taha os erem or uri kava orhi oson kormbak saweri ria. ");
INSERT INTO sim_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ushirik Herot Jonin or mandingormekurik hishiri ri. Hako hulaima nokopma, Jon profet, karem li mbandari osik lirin or ajehe halari ri. ");
INSERT INTO sim_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Uhu kandakar nga li lihi ihi Herot nijava orhi os orin si wari wolo oson indiyok or hishihi hiyawu laka las ormu ura. Urik or nga ma orhi ondo nga li lihi li arik Herodias oso jikisnokopji sihi si taha si mblarik limu heyera. ");
INSERT INTO sim_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herot am si mblarin or heyehe nor rupshi mendehe mainkwambuk ormu mbara, �Os nyi lakmbaha nyi hishiwan nyi mbanak avak a hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jikisnokopji oso nijava sihi angop si saukaweshiri osik osmu mbara, �An a rupshiwa karem, Jon man fak tolofalenda ma oto jekapnashi orhin koroho masiji orhin hambiyak ewehe anin haka.� ");
INSERT INTO sim_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Karem si mbarik Herot sunguwavu orhi kavak simu nara. Hako os or mbari oson mbeek or halakurik nari ambu sir. Os erem or u nahi, ma ol or nga nakrem li lihi ari ma ondo avak li heyenak or humblaraku. Karem or hishihi os si mbari nombo hom ormu ura. ");
INSERT INTO sim_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Uhu orhi ma lar or mbashirik krawuk or layihi Jonhi jekapnashin or koroho masiji orhin hambiyak or ewehe ");
INSERT INTO sim_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","laharaha sirin ormu hara. Urik sir nga mu nijava sihin hara. ");
INSERT INTO sim_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Urik ol Jonin tiyandari ma ondo li taha maninimba orhin li laha limu wakor ewera. Uhu li ihi os Jonik talarin Jisasin limu sawera. ");
INSERT INTO sim_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas mbele mbele os Jonhik talarin or misihi yanga oson or halaha bot lasik or lawuhu nendekop ma ngashi ambu mishi orok ormu ira. Hako hulaima nokopma os or iri mashin li misihi os or ikuri mishi nombo yok li eskoroho limu ira. ");
INSERT INTO sim_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Orok li lihi orin limu nikishira. Urik or taha bot oson or halaha lirin ormu heyera. Uhu lirnjik or holoho nor mbarik ol kavamisindari ondo jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Am si homirik ol orin tiyandari ma li taha limu mbara, �Ayo, am homir te. Tos ni liwa mishi ma ngashi ambu re. Tondon mbashinak yanga pasir nanda mishi orok li layihi akwan li frungawuka.� ");
INSERT INTO sim_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Urik ormu mbara, �Mberem ushiwak li iku? Jir jihinjik akwan ji hanak li aka.� ");
INSERT INTO sim_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Urik limu mbara, �Wahau te, nir akwa mushak nawa ambu re. Bret tostava yeje nga foome frijip nom nga ni nawa re!� ");
INSERT INTO sim_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Urik ormu mbara, �Akwa ondon torok ji laharaka.� ");
INSERT INTO sim_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Uhu or mbashirik ma ol orok liri ondo misambik limu raka lira. Uhu bret tostava ondo nga foome ovro nga nor laha lersuwu yok or mawuhu Avui Wasilakan ormu sawera, ushinak akwa ondon armek or ushinak or hanak li akmbahan. Uhu bretin or toltavaha ol orin tiyandari man or harik li laha ma ondon limu hara. ");
INSERT INTO sim_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Urik akwa ondon li aha li krehe limu lira. Uhu akwa sumbuyambun li lahara tirsaha serkawu 12-pelak li wolorik hojeri lira. ");
INSERT INTO sim_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma ol orok liri 5,000-ik nari lira. Hako jikisnokopji nga li kantiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Urik Jisas ol orin tiyandari ondon ormu sawera, �Jir masmas bot lasik ji lawuhu kasauyok ji inak avai raka. An a lihi ma rondon a mbashinak li inak amu randu.� ");
INSERT INTO sim_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Karem or mbaha ma ondon or mbashirik li irik ortonom Avui orhin sawekurik telembak ormu lawura. Uhu am si krinyarik nendekop orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Urik bot os li iri oso am si ihi fa nindik simu nara. Urik suwa si rasaha botin simu jiermbera. ");
INSERT INTO sim_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Am si harakurik si narik Jisas fa heyek or ese ihi orin tiyandari ma ondohik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Fa heyek or ese irik li heyehe li aje mendehe limu mbara, �Ayo wasi lar ori te.� ");
INSERT INTO sim_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Urik ormu mbara, �Ajewa hala. An mu randu te.� ");
INSERT INTO sim_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Urik Pita mu mbara, �Wasilaka, os mirik na nahi, anin mbashinak fa heyek a esehe mir siwa mishik a raka.� ");
INSERT INTO sim_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Urik Jisas mu mbara, �Wa raka.� Urik Pita botin or halaha fa heyek or esehe Jisasik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hako suwa wasilakak si tasarik or heyehe or ajehe fak or layikurik ormu ura. Uhu normu ushambara, �Wasilaka, anin mi jelyawa!� ");
INSERT INTO sim_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Urik Jisas kolok Pitan or haitoloho ormu mbara, �Anin mi hishiowenda nombo mihi kwambuk nawa ambu sir. Wavu mihi frijip nawa sir.� ");
INSERT INTO sim_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Karem or mbaha botik fri lawurik suwa mendek simu nara. ");
INSERT INTO sim_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Urik ol orin tiyandari ma ondo orin li hausimbausihi limu mbara, �Omendinga sira, mir jikisi Avui Wasilakahi mira.� ");
INSERT INTO sim_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas nga ol orin tiyandari ma nga leukun li mbuhu yanga Genesaretik limu lawura. ");
INSERT INTO sim_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma ol orok fehe os or tarin li heyehe yanga yangak li mainharik ma ol kavamisindari ondon Jisasik limu laharara. Unak or mbanak jivik li nakmbahan. ");
INSERT INTO sim_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Uhu orin limu silira, �Mi halanak kowe mihi kas ni toloho jivik ni naka.� Erem li mbaha kowe orhi nom li toloho jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Urik Farisi lal nga Moseshi mashin sawendari ma lal nga Jerusalemin li halaha Jisasik li taha orin limu silira, ");
INSERT INTO sim_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","�Mberem ushiwak ol mirin tiyanda ma ondo tavan li yoko namber tavatle nga li andu? Os erem li uwa oso mashi os neloko avoko nihi mbahandari os limu halanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Urik ormu mbara, �Jir mberem ushiwak neloko jihi li mbahandari mashi yejen ji tiyaha Avui Wasilakahi mashin ji tiyakwan ji halandu? ");
INSERT INTO sim_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ji misi, mashi orhi karem mbanda osa, �Avoko nijava jihi mashi lihin ji misihi lirin armek ji uka.� Uhu, �Os lirin mashi kavakavan ji mba nahi, os Moseshi lo si mbahandari hom avak li mandingormeshinak hakwa jir.� Mashi Avui Wasilakahi karem mbanda osa. ");
INSERT INTO sim_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hako jir mashi oson ji mblarna ermbehe karem ewesawenda jir. Os avoko nijava jihin armek ji ukwan ji halashihi ya mbele mbele jihi ondo Avui Wasilakan ji ha nahi, oso jivi sira. Karem ewesawenda jir. ");
INSERT INTO sim_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hako os erem ji mbanda nombo orok mashi Avui Wasilakahi si mbahanda nombon ji laihalaha neloko jihi li mbahanda nombo yejen jimu tiyanduwa. ");
INSERT INTO sim_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jir men ma heyekmbaha mbanda jir. Profet Aisaia mas or mbahandari mashi oso jir ukundarin karem or mbari sir, ");
INSERT INTO sim_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","�Ma ondo men suwambushikop hi anhin hauowenda lir. Hako wavu lihi homek nanda sir. ");
INSERT INTO sim_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lir ma misambik fehehi mashin li sawehe karem mbanda lir, �Avui Wasilakahi mashi kasira.� Os erem li uwa oso men sembe mende anin lotu unda lira.� � ");
INSERT INTO sim_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas ma ondon or usharik li talarik ormu sawera, �Mashi kason armek ji misihi ji yarika. ");
INSERT INTO sim_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mbele mbele ol ma li anda ondo men sunguk layinda lir, mbeek man uwak Avui Wasilakahi misokomek kavak nanda ambu lir, wahau. Hako mbele mbele ol wavu yok li hishiwak hikriyok rasanda ondo li uwak ma kavak nanda lir. Akwa ol li anda wahau.� ");
INSERT INTO sim_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Urik ol orin tiyandari ma ondo raha orin limu mbara, �Mai, mashi os mi mbawa si uwak Farisi ondo olmu mirin wapkava hishinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Urik ormu mbara, �Avui anhi or hevenik linda mbele mbele ol nowe orhik orhinjik or lahanda ambu ondon avak or kwaha nor ermbekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Farisi ondo kavan ji hishiwa hala. Mberem ji hishindu? Misokome tumunda lar am misokome tumunda lar nombon mukundahi or? Wahau. Os erem or uwa avak evrembam wak ikwa vri.� ");
INSERT INTO sim_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Urik Pita mu mbara, �Tisa, sauheima os mi sawewa maintontlo sihin sawenak ni misika.� ");
INSERT INTO sim_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Urik ormu mbara, �Mir hishiyariwa ambu om? ");
INSERT INTO sim_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mbele mbele ol sunguk layiwa ondo men li siyi ermbenda lir. Ondo mbeek man uwak kavak nanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hako mbele mbele ol wavuk nahanda hikriyok tasanda ondo li uwak ma kavak nanda lir. ");
INSERT INTO sim_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mbele mbele ol wavu yok tasanda karem, wapkava hishinda, man mandingormenda, nokophirmbirihi hulatolhakanda, hirnyanda, haimba handambanda, mashi os ma anandihi hin uwak kavak si nanda ondo wavukop tasanda lir. ");
INSERT INTO sim_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ondo mu uwak ma misokome Avui Wasilakahik kavak nanda lir. Hako os tavatle nga tolo anda mbeek man uwak misokome orhik kavak nanda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ushihi Jisas yanga oson or halaha yanga Tair nga Saidon nga orok ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Urik nokove las yanga Kenanik fehendari si raha Jisasin simu ushaha tlara, �Wasilaka, Devithi nirambara mirin, anjik mi holowa. Jikisnokopji anhi wasimalengamba toloshiwak osmu kavak nanduwa!� ");
INSERT INTO sim_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hako Jisas mbeek mashi las sirin saweri ambu ri. Urik ol orin tiyandari ma limu mbara, �Nokove oso mashi oso nom si mbaha rawak am ni krehe mender te! Mi mbashinak si ika.� ");
INSERT INTO sim_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Urik ormu mbara, �Yanga Israelik fehenda ma ondo sipsip Avui Wasilakahi lir. Hako angop orin li halari lir. An lirin indiyok a lakurik a tari nir. An mbeek Judama ambu ondonjik a rari ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hako sir Jisashi kumbamuk si haka lihi indik simu tlara, �Wasilaka, anin mi jelyawa!� ");
INSERT INTO sim_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Urik ormu mbara, �Nir mbeek jikisihi akwan ni laha asan ni handa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Urik simu mbara, �Ome sira. Hako ma akwan li awak asa li taha akwa tlamun nongo anda ol te.� ");
INSERT INTO sim_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Urik ormu mbara, �Ome sira, apmanuwa, anin nyi hishiowenda nombo nyihi oso wasilakak si nawak amu heyenduwa. Os anin nyi siliwa hom avak nyihik nakwa sir.� Erem or mbari wolo mendek jikisi sihi jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas yanga oson or halaha leuku Galili fa mambukop or ihi telembak ormu lawu lira. ");
INSERT INTO sim_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Urik ma musha mendek ol kumba nashindari, misokome tumundari, kumba tava kavak nandari, maimbandari ambu nga mbele mbele jipmiskavamisindari nga orhik limu laharara. Urik or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hulaima nokopma li heyerik ol kumba nashindari li eserik, kumba tava kavak nandari jivik li narik, maimbandari ambu li maimbarik, misokome tumundari li heyerik, ondon li heyehe wavu mushak li hishihi Israelik fehenda ma ondo God lihin limu hauowera. ");
INSERT INTO sim_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Urik Jisas ma ol orin tiyandari ondon or usharik li tarik ormu mbara, �An ma ol torok liwa tondonjik amu holonduwa. Lir angop niri nalmingrip nir nga torok liwa lir. Akwa lihi am mendek si nashiwak mbele livai aku? Os sungu nga na mbashinak li i nahi, avak nombok kumba tava hahantlenak takatukuyikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Urik limu mbara, �Toso ma ngashi mishi ambu re! Mbeyok akwan ni laha ma tondon ni hanak li aku!� ");
INSERT INTO sim_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Urik ormu mbara, �Bret mbelmbel ji tolondu?� Urik limu mbara, �Nir bret 7-pela nga foome kanda frijip nga nimu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Urik ma ondon or mbarik misambik limu taka lira. ");
INSERT INTO sim_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Urik bret nga foome nga nor laha Avui Wasilakan armesarmek ormu mbara. Ushihi bretin or toltavaha foomen or tolkoroho ol orin tiyandari man or harik lir nga mu ma ondon hara. ");
INSERT INTO sim_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Urik li aha am li krehe akwa sumbuyambun serkawu 7-pelak limu wolora. ");
INSERT INTO sim_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma ol orok ari ondo 4,000-ik nari lir. Hako jikisnokopji nga li kantiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Urik or mbashirik yanga yanga lihik li irik bot lasik or lawuhu distrik Magadan yok ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Urik Farisi lal nga Sadyusi lal nga Jisasin li eweheyenak or mbanak li heyekmbaha li taha limu mbara, �Ma undahi ambu las unak ni heyehe nivai mba, mir Avui Wasilaka mbashirik tari ma mira.� ");
INSERT INTO sim_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Urik ormu mbara, �Ta nor layihi ta flakowak ji heyehe ji mba, �Ushok ta jikwa sir.� Uhu os nirsumbuk matle si rasawak ji heyehe ji mba, �Avak ma rakakwa sir.� Karem ji mbaha mbele mbele ondon ji heyehe yarinda jir. Hako mbele mbele os ter talawak ji heyewa kas ji yari nembes. ");
INSERT INTO sim_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jir ter wolok liwa ma jir kava indingo jir. Mbele las ma undahi ambun a unak ji heyekmbaha jimu sili yangonduwa. Hako an mbeek mbele las a unak ji heyekwa ambu sir, wahau. Mbele mbele os profet Jonahik narik ji misindari hom avak erem si nanak ji heyekwa sir.� Karem or mba lafakaha lirin or halaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Urik Jisas nga ma ol orin tiyandari ma nga fan li mbuhu kauyok limu ira. Hako ol orin tiyandari ma ondo bretin li laha ikurin hishari lir. ");
INSERT INTO sim_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Urik ormu mbara, �Farisi nga Sadyusi nga ji auheyeka, yis lihin.� ");
INSERT INTO sim_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Karem or mbarik lihi ambek limu mbara, �Wa bret nga ni laharawa ambu osik mbandar?� ");
INSERT INTO sim_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mashi os li mbari oson or misihi ormu mbara, �Jir mbeek mashi anhin misindiyanda ngashi ambu re. An bret indingan a mba, karem jimu hishindu? ");
INSERT INTO sim_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jir mbeek kas yariwa ambu jir. Bret tostava yoko hom a toltavaha ma 5,000 ondon a harik li arik akwa sumbuyambu serkawu mbelmbel ji wolor? ");
INSERT INTO sim_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bret 7-pelak a toltavaha ma 4,000 ondon a harik li arik akwa sumbuyambu serkawu mbelmbel ji wolor? ");
INSERT INTO sim_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ondon jimu hishakashandu? An mbeek bretin a mbawa ambu nir, os a mbawa Farisi nga Sadyusi nga yis lihin ji auheyekmbaha na mbawa nir.� ");
INSERT INTO sim_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Karem or mbarik livai yarira, or mbeek yis indinga bretin li undarin mbari ambu ri. Or mashi os Farisi nga Sadyusi nga man li ewesawendari mashi lihi oson li auheyekmbaha or mbari sir. ");
INSERT INTO sim_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Uhu Jisas yanga Filipai distrik Sisariak nanda orok or ihi ol orin tiyandari ma ondon ormu silira, �Ma Jikisi Avui Wasilakahi mberem li mbawak ji heyendu?� ");
INSERT INTO sim_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Karem or silirik limu sawera, �Lal mir Jon, man fak tolofalenda ma mir, karem mbanda lir. Hako lal mir Elaija, karem mbanda lir. Hako lal mir Jeremaia, karem mbanda lir. Hako lal mir profet hoje lar hahanda indik usahanda, karem mbanda lir.� ");
INSERT INTO sim_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Urik ormu silira, �Hako jir jihinjik an lawe, karem ji hishindu?� ");
INSERT INTO sim_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Urik Saimon Pita mu mbara, �Mir Avui Wasilaka or ermba ermbak linda jikisi indingo orhi mira. Mir hulaima nokopman jivinakmbaha nor kamashirik tahanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Urik Jisas mu mbara, �Saimon, jikisi Jonhi mirin, avak jip er sikwa mir. Mashi os mi mbawa ma misambik fehe lar mbeek saweshiwak mi mbawa ambu sir, wahau. Avui anhi or hevenik linda mu mirin saweshiwak mimu mbanduwa. ");
INSERT INTO sim_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Uwosik mirin Pitak amu ushanduwa. Pita maintontlo sihi sunja. Uhu avak sios anhin sunja heye orok a ukwa sir. Ushinak Laulaka kwambu orhi mbeek unak sios anhi tle rakakwa ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Uhu ki os heven akayanga sihin sutlanda oson mihi tavak a hakwa sir. Uwosik os hulaima nokopma kavakava ol li undan li sawenak ji mba, �Avui Wasilaka kavakava jihin laha ermbekwa ri,� karem ji mba nahi, erem ukwa ri. Hako os ji mba, wahau, karem ji mba nahi, or er nga erem mbakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Uhu ormu mbara, �Ai ai, avak ma lal ji sawewa hala, an Krais Avui Wasilaka kamahanda ma anira. Karem ji sawewa hala.� ");
INSERT INTO sim_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uhu Jisas ol orin tiyandari man os Jerusalemik or ikurin ormu sawera. Orok or inak Judama lida lihi nga bikpris nga mashi Moseshin sawendari ma nga orin li kumaifaha orin li mandingormeshinak niri frijip fri ishinak indiyok or usahakurin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Urik Pita mashi oson or misihi Jisasin or laha apsham fri sihi kwambuk ormu mbara, �Wasilaka wahau, oso mbeek mihik erem nakwa ambu sir te!� ");
INSERT INTO sim_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Urik Jisas or tormblehe Pitan or heyehe ormu mbara, �Laulaka mir haisi! Nombo anhin arangowa hala. Mashi os mi mbawa oso mbeek Avui Wasilakahi mashi ambu sir. Oso mashi tol ma misambik fehe lihi mashi sir.� ");
INSERT INTO sim_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Uhu lirin ormu sawera, �Os anin ji tiyakunak ji hishi nahi, mbele mbele jihi amber ondon ji halaka. Uhu nomorawu os jihik talakwan ji kishaha anin ji tiyaka. ");
INSERT INTO sim_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hako os mbele mbele jihi ondon ji toltambanana nahi, mendek nakwa jir. Hako os anin ji hishindiyaha mbele mbele ondon ji hala nahi, kumak avak ermba ermbak linda anhik nandan jivai laka. ");
INSERT INTO sim_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Os mbele mbele misambik fehe nga mushak ji na nahi, wa mberem ji hishindu, ondo am jirin jelyakundal? Wahau. Ondo mbeek jirin jelyaha ermba ermbak linda oson jirin hakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kumak Ma Jikisi Avui Wasilakahi oto ukruharanda orhi nga Avui Wasilaka ensel orhi nga or tawa wolo ma amber ol li unda undan or heyehe yombo yombo lihik or hakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Omendingak jirin amu sawenduwa, ma tol torok siwa lal li ha namber avak li heyenak Ma Jikisi Avui Wasilakahi malakamak or naha ranak li heyekwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Niri 6-pela am li ishirik Jisas Pita nga Jems nga Jems maha orhi Jon nga nor laha telemba lasik limu lawura. ");
INSERT INTO sim_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Orok li lihi li heyeri Jisas maome orhi si tormblehe apsham indingok simu nara. Urik fumunyava orhi ta jindari hom si narik kowe orhi nga avisha mendek er simu nara. ");
INSERT INTO sim_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Urik kolok li heyeri Moses nga Elaija nga orok fri talaha Jisas nga limu maimbara. ");
INSERT INTO sim_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Urik Pita mu mbara, �Wasilaka, torok ni liwa osmu jivi mendek nanduwa. Am mi mbashinak shikor aka nalmingrip a ukundan? Las mirnjik, las Elaijanjik, las Mosesnjik a ukundan?� ");
INSERT INTO sim_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Karem or mbari halanganga kolok kwandi avisha mende las lirin si aulafaleshirik mashi las kwanindi orok simu mbara, �Ma oto jikisi indingo anhi ria. Orin wapnuku anhik amu ewenduwa. Mashi orhin ji misika.� ");
INSERT INTO sim_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mashi oso si mbarik li misihi li aje mendehe misambik limu taka avermbuwara. ");
INSERT INTO sim_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Urik Jisas or taha lirin or toloho ormu mbara, �Ji ajewa hala, ji usaha!� ");
INSERT INTO sim_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Urik li larasa mawuhu li heyeri mbeek ma lar nga orok siri ambu ri, wahau, Jisas nom ormu orok sira. ");
INSERT INTO sim_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Urik telemban li halaha li rakaha Jisas ormu mbara, �Mai, tos torok nawak ji heyewan ma lal ji sawewa hala. Halashinak er si nanak Ma Jikisi Avui Wasilakahi oto mawan or halaha or usahashinak jivai saweka.� ");
INSERT INTO sim_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Urik limu silira, �Mberem ushiwak mashi Moseshin sawenda ma karem li mbandu, Elaija avak masmas takwa ri. Or tashinakop kuma Avui Wasilaka kamahanda ma orto takwa ria, karem li mbandu?� ");
INSERT INTO sim_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Urik ormu mbara, �Mashi oso ome sira. Elaija avak or taha mbele mbele ondon hundujekwa ri. ");
INSERT INTO sim_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hako omendingak jirin amu sawenduwa, Elaija angop tari ri. Hako ma misambik fehe mbeek orin heyekrahakorori ambu lir, wahau. Kavakavan orin uri lir. Os orin li uhunda hom Ma Jikisi Avui Wasilakahin erem ukwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Karem or mbarik livai yarira, Jisas Elaijak or mbari Jon hulaima nokopman fak tolofalendari man or mbari ri. ");
INSERT INTO sim_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Telemban am li halaha li rakaha ma mushak orok li lirik limu takaheyera. Urik ma lar Jisashik or taha kumbambongo orhin or huvuhu ");
INSERT INTO sim_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ormu tlara, �Wasilaka, jikishulayi anhin mi jelyawa! Ermba ermbak or haha kwarngarnanda re. Uhu hik or iw, fak or iw, uwak maome orhi nga kavak er nanda re. ");
INSERT INTO sim_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ol mirin tiyanda ma ondohik a laharari mbeek li mbru ermbendahik nari ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Karem or mbarik Jisas ormu mbara, �Jir anin hishiowenda ambu oj? Ermba ermbak jir nga na lihi mashin angop a sawewak ji misinda sir. Hako jir mbeek anin hishiowenda ambu jir. Wa, jikisi oton laharaka.� ");
INSERT INTO sim_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Karem or mbaha wasimalengamba or jikisi oton tolohondarin or ngriaha nor mbarik or tala tulu ishirik jikisi oto kolok jivik ormu nara. ");
INSERT INTO sim_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Urik ma ondo am li irakoshirik ol orin tiyandari ma nom orok li lihi limu silira, �Mberem ushirik wasimalengamba oton ni mbru ermbendahik ni nari ambu nir?� ");
INSERT INTO sim_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Urik ormu sawera, �Mashi anhin ji misindiyanda nombo kandakar mende jihik nawa ambu sir, wahau. Uwosik mberem ji mbawak jivik nandahi ambu ri. Hako omek amu sawenduwa, os anin ji hishiowenda nombo jihi awarikanda mastet siji hom si na nahi, ambehoma, telemba roson ji mba, �Telemba nyir usa ika!� karem ji mba nahi, si usa indahi sir. Uhu mbele mbele os ji ukwak si nawa avak er ji undahi sir.�  ");
INSERT INTO sim_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wasimalengamba jikisi oton tolohondari oso kwambu nga nari sir. Unda osik os akwan ji halaha Avui Wasilakan ji sawe nahi, ji mbruembendahi sir. Os erem ji una ambu nahi, wahau. ");
INSERT INTO sim_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas nga ol orin tiyandari ma nga Galilik indik li ihi ormu mbara, �Ma Jikisi Avui Wasilakahi avak ma kavahi tavarenjek li halashinak ");
INSERT INTO sim_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","li mandingormekwa ri. Hako niri frijip fri ishinak indiyok usahakwa ria.� Karem or mbari mashi oson li misihi sunguwavu mende nga limu holora. ");
INSERT INTO sim_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas nga ol orin tiyandari ma nga yanga Kaperneamik li layirik ma ol tempel akanjik takis yan landari ma ondo li taha Pitan limu silira, �Mai, tisa jihi am tempel akanjik takis yan handa or?� ");
INSERT INTO sim_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Urik Pita mu mbara, �He, takis yan handa ora.� Karem or mbaha akak or i layihi mashi las or mba namber Jisas mu orin silira, �Pita, mberem mi hishindu? Malakama misambik fehe ondo lawe lirin takis yan handu? Jikisi lihi takis yan handa ol mo ma anandi handa ol?� ");
INSERT INTO sim_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Urik Pita mu mbara, �Jikisi lihi nembes, ma anandi nom takis yan handa lir.� Urik ormu mbara, �Ome sira, malakama ondo jikisi lihi takis yan handa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hako las avak shi halashinak li ngrianda ngashi. Uwosik leukuk mi layihi hukin ermbeka. Uhu foome os maifuk mi lowa foomtajek heyehe ya las avak orok mi heyekwa sir. Ya oson laha ihi an nga mir nga takis ya shihin tempel aka orok haka.� ");
INSERT INTO sim_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oro wolok ol Jisasin tiyandari ma orhik li taha limu silira, �Lawe ol hiushamak naha Avui Wasilaka yanga orhi orok maifuk siku?� ");
INSERT INTO sim_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Urik Jisas jikisakri lar or mbarik or tarik lihi nindik or eweshirik ormu sira. ");
INSERT INTO sim_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Urik ormu mbara, �Omendingak jirin amu sawenduwa, os sunguwavu jihin ji tormblehe jikisakri roto hom ji nana ambu nahi, jir mbeek Avui Wasilakahi yanga orok ikwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hako os jihinjik ji hafakaha jikisakri toto hom ji na nahi, ambehoma, jir yanga orhi orok maifuk sikwa jira. ");
INSERT INTO sim_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Uhu os anin ji hishihi jikisakri toto hom nawan armek ji u nahi, wa anin jimu uwa sira.� ");
INSERT INTO sim_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","�Hako os ma lar jikisakri kanda ol mashi anhin misindiyanda ondon or mbaskashinak kavakavan li u nahi, ma or mbaskashiwa ma oto kumak avak kavak nakwa ri. Os sunja laka las jekapnashi orhik li ishitivihi fak li ermbeshinak or uk aha nor ha nahi, oso mbeek lakak nawa ambu sir. Mberem ushiwak? Kumak avak kava indingak nakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ma or ma anandin mbaskashiwa ma oto kumak avak kava indingak nakwa ria. Uhu mendek nakwa ria. Ome sira, ma misambik fehe ermba ermbak kavakavan unda lir. Hako ma or ma anandin mbaskashiwa ma oto kumak avak kava indingak nakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Os kumba tava jihi fri mbango nahi, wa yejen shikoro ermbenak si ika. Ushinak yeje nom ji naha avak ermba ermbak linda mishi orok jivai ika. Las avak kumba tava jihi evrembam fri nahandanak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Os misokome jihi si unak kavakavan ji u nahi, wa misokome yejen kwarko ermbenak si ika. Ushinak yeje nom ji naha ermba ermbak linda mishi orok jivai ika. Las avak misokome jihi evrembam fri nahandanak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ji auheyeka, las avak jikisakri tondon ji heyehe ji mba, �Tondo jikisakri kava lir,� karem ji mbanan, wahau. Jirin amu sawenduwa, lir ensel ngashi lir. Ensel lihi hevenik Avui Wasilaka linda mishik er linda lir.� ");
INSERT INTO sim_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma Jikisi Avui Wasilakahi misambi torok or tari karem, ma ol nombo jivin halaha apsham inda ma ondon or lasaha indik lakurik tari ria. ");
INSERT INTO sim_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","�Ma lar sipsip orhi 100-pelak nanda lir. Lihi lar ihi wanyishiwak mberem orvai uku? Sipsip 99 ondon os li sihi anda mishi orok or halashihi wanyinda oton lasakwa or mo wahau? Or lasakwa ora. ");
INSERT INTO sim_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Or laslasa ihi am or heyehe warje mende nga rupshikwa ri. Sipsip 99 ol orhi inyik siwa ondon rupshinda ora. Hako namtar or wanyihindan indik or heyewa wolo warje mende nga rupshinda ri. ");
INSERT INTO sim_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Unda hom Avui Wasilaka nihi or hevenik linda erema, or mbeek ma lar nombo wornan halaha apsham ikmbaha mbanda ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Uhu Jisas ormu mbara, �Os mir nga nakrem shi lotu unda ma lar mirin kavak or uwa, mir avak orin i heyehe mainalok os mirin or uwa kava oson shi anasaweka. Os mashi mihin or misi nahi, avak shi anafaha nakrem indik mahasanje hom shi sika. ");
INSERT INTO sim_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Hako os mashi mihin or misina ambu nahi, avak ma frijip mo nalmingrip laha inak mashi os shi mbawan li misihi mirin li jelyaka. ");
INSERT INTO sim_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hako os lir sawewan er nga or misina ambu nahi, wa avak mbele mbele kava os or uhundan kormbak siosik sawenak ma amber li misika. Hako os or misina ambu nahi, wa misokomekop ji heyeka. Uhu ji halashinak hikriyok er or sihi takis yan landa ma ol Avui Wasilakahi mashin mblarnanda mak or naka. ");
INSERT INTO sim_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jirin omek amu sawenduwa, os hulaima nokopma kavakava ol li undan li sawenak ji mba, �Avui Wasilaka kavakava jihin laha ermbekwa ri.� karem ji mba nahi, erem ukwa ri. Hako os ji mba, �Wahau,� karem ji mba nahi, or er nga erem mbakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Uhu jirin amu sawenduwa, os jihi lap mbele las wavu namtaskop fri hishihi fri mbaolsoloho Avui anhi or hevenik lindan fri sawe nahi, avak mashi frihin misikwa ri. ");
INSERT INTO sim_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mberem ushiwak? Os ma frijip mo nalmingrip hi anhik li tirsa nahi, an lihi nindik a sikwa nir.� ");
INSERT INTO sim_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Urik Pita or taha Jisasin ormu silira, �Wasilaka, os mahasanje anhi lar mbele kava las anin or u nahi, hindi mbelmbel orin a sawehe na mba, am nawa kava sir? Hindi 7-pelak mo hindi mbelmbel?� ");
INSERT INTO sim_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Karem or silirik ormu mbara, �Wahau, hindi 7-pelakop nembes. Hindi 77-pelak. Kantim uwa hala. ");
INSERT INTO sim_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ji misi, Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa oso karem nanda sir. Nindi las wolok king lar mbele mbele orhi os ornjik lerawun landari ma ondon or hahandarin indik or lakurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Uhu ma ol or hahandari wasa nga nandarin or usharik limu rara. Urik ma lar wasa orhi wasilaka mendek 10 milion kinak nari sir. ");
INSERT INTO sim_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hako ma oto mbeek ya erem nari kas nga nari ambu ri. Uri osik king mu mbara, �Avak mbele mbele mihi amber mi tirsaha mi eweshinak ma li frungawurakoshinak yan mi laha anin haka. Ushihi mir nga jikisnokopji mihi nga akishmakisha hom ji naha anjik men lerawun ji lanak os anin mi hakmbaha na mbawa ya wasa oso mendek si naka.� ");
INSERT INTO sim_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Karem or mbarik ma oto sunguwavu orhi nga nor holoho ormu tlara, �Awasayi, mir avak anjik holowa. Uhu nikishinak avak wasa mihin a hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Karem or mbarik king oto wavu mende nga ma otonjik or holoho ormu mbara, �Am nawa sir, men hishakasha ika.� ");
INSERT INTO sim_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ushirik ma oto hikrik or layihi ma or nakrem lerawun fri landari lar nombok or heyehe jekapnashi orhik or toloho ormu mbara, �Mir kolok 10 kina anhin mi lahandan indik haka.� ");
INSERT INTO sim_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Karem or mbarik ma oto ormu tlara, �Anjik mi holoho nikishinak avak wasa mihin indik a hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hako wahau. Or mbeek nikishikuri kas nga nari ambu ri. Ma oton or laha krawuk or eweshirik or lihi yawur wasa oson or harakonakop or halashinak talakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Urik ol or nga nakrem lerawun landari ma os erem or uri oson li heyehe sunguwavu lihi kavak si narik King oton li sawekurik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Urik King mashi oson or misihi ma oton or mbarik or tarik ormu mbara, �Mir mambale mira. Mir hongom mi tlarik a heyehe mirnjik a holoho am nawa sir, karem a mbari nira. ");
INSERT INTO sim_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Hako mir mberem ushirik ma or mir nga nakrem lerawun shi landari otonjik mi holori ambu? Uhu os mirin a uri hom erem orin mi ukurin mi halar?� ");
INSERT INTO sim_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Karem or mbaha or waplelenaha or mbashirik ma oton li wakoroho krawuk limu ewera. Ushinak yawur wasa orhi oson or harakohokop talakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas sauheima oson or sawerakoho ormu mbara, �Avui anhi or hevenik linda King oto hom nanda ri. Os ma jirin uwak kavak ji nawa ondon ji hishihi ji mba, �Am nawa kava sir.� Karem ji mba nahi, Avui Wasilaka er nga kavakava os ji undan laha ermbekwa ri. Hako os erem ji mbana ambu nahi, or erem mbeek kavakava ol ji undan laha ermbekwa ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas mashin or sawerakoho provins Galilin or halaha fa Jordanin or mbuhu provins Judia yok ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Urik ma musha mendek orin li tiya irik ol kavamisindarin or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Urik Farisi lal li taha men li eweheyenak or mbanak li heyekmbaha li taha orin limu silira, �Lo nihi mberem si mbandu? Os nokove nihin men semben ni turaha ni mbashinak si ika, karem ni mba nahi, jivik nakwa os mo wahau?� ");
INSERT INTO sim_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Urik ormu mbara, �Jir mashi os Avui Wasilakahi jekambak li kayehendarin heyenda ambu oj? Avui Wasilaka mbele mbele amber or uri wolo hulayi nga nokove nga or uri vria. ");
INSERT INTO sim_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Uhunda osik hulayi or nokoplawa wolo avoko nijava orhin or halaha nokove orhi nga nor lihi opmu maome namtaskop nawa vria. ");
INSERT INTO sim_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Angop namtaskop fri nawa osik mbeek anakorokwa ambu vria. Os erem nakuri nombo Avui Wasilaka or mbahanda oso mbeek ma misambik fehe lar tlendahi ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Karem or mbarik limu silira, �Mberemhi sir? Lo Moseshi karem mbanda osa, ma or nokove orhin halakmbaha hishiwa ma oto jekambak karem or kayeka, �Nokove anhi oson avak a halakwa nir.� Karem or kayeshinak si heyehe sivai ika. Mberem ushirik Moses erem nanda lo oson nirin or har?� ");
INSERT INTO sim_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Urik ormu mbara, �Jir ferfar naha Avui Wasilakahi mashin ji mblarnandari osik lo oson jirin hari ri. Hako mas araje wolo mbeek erem or mbari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jirin amu sawenduwa, os nokove las hula anandi lar nga si yana ambu nahi, hula sihi men orhinjik sirin or turaha nor mbashinak si inak or halashihi, ushihi nokove anandin or la nahi, os ormu nokophirmbirinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Karem or mbarik ol orin tiyandari ma mashi oson li misihi limu mbara, �Ayo, os erem si na nahi, wa halanak hulayi amber kuyap li waha yaka.� ");
INSERT INTO sim_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Urik ormu mbara, �Ma amber mbeek erem undahi ambu lir. Avui Wasilaka kamahanda ma ondo nom erem undahi lir. ");
INSERT INTO sim_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ji misi, ma lal nijava lihi wari wolokop maome lihi kavak si nari osik nokoplandahik nanda ambu lir. Lal fle hom li man lashihindak mbeek nokoplandahik nanda ambu lir. Hako lal lerawu Avui Wasilakahin li lakwak li hishihi lihinjik li pantlehe mbeek nokoplanda ambu lir. Ol erem ukwak hishiwa ma ondo erem unda ol te.� ");
INSERT INTO sim_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hulaima nokopma jikisi lihin Jisasik limu laharara. Unak lirin or toloho Avuin or sawenak lirin armek or ukmbahan. Hako orin tiyandari ma ondo oson li heyehe ma ondon limu ngriara. ");
INSERT INTO sim_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Urik ormu mbara, �Jikisi tondon halashinak anhik li raka. Jir avak lirin pantlewa hala. Ma ol jikisakri tondo hom nawa ma ondo Avui Wasilakahi krahak li sihi yanga orhik ikwa lira.� ");
INSERT INTO sim_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Karem or mbaha tava orhin jikisi ondohik or hauoweshihi lirnjik Avui Wasilakan ormu sawera. Ushihi yanga oson or halaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Urik ma lar Jisasik or taha ormu silira, �Tisa, mbele jivi menden a uhu os ermba ermbak linda oson a laku?� ");
INSERT INTO sim_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Urik ormu mbara, �Mbele jivi mende mi ukmbaha mi mbandu? Avui Wasilaka ortonom jivi ria. Hako os ermba ermbak linda oson mi lakmbaha mi hishi nahi, lo orhi ondon amber tiyaka.� ");
INSERT INTO sim_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Urik ormu silira, �Mberemhi lon mi mbandu?� Urik ormu mbara, �Man mandingormewa hala, nokophirmbirihi hulatolhakawa hala, hirnyawa hala, man semben mbaha haimba handambawa hala, ");
INSERT INTO sim_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","avoko nijava mihi mashin misihi frihi siyok sika. Uhu os mihinjik mi rupshinda hom ma anandin er nga rupshika.� ");
INSERT INTO sim_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Urik ermbasi oto mu mbara, �Lo ondo amber angop a tiyarakonda nira. Hako mbele las er nga na ukuwa on?� ");
INSERT INTO sim_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Urik Jisas mu mbara, �Os ma worna jivi mendek mi nakmbaha mi hishi nahi, mbele mbele mihi ondon mbashinak ma li frungawushinak yan laha erndakavan haka. Ushihi anin tiyaka. Os erem mi uwa avak mbele mbele kumak hevenik mi lakundan os mimu hundujenduwa.� ");
INSERT INTO sim_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Karem or mbarik ermbasi oto mashi oson or misihi sunguwavu orhi kavak si narik ormu halashi ira. Mberem ushirik? Or ya mbele mbele mushak nandari ora. ");
INSERT INTO sim_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Or ishirik Jisas ol orin tiyandari man ormu sawera, �Omendingak jirin amu sawenduwa, mbele mbele nga mushak nanda ma ondo Avui Wasilakahi siyok li sikmbaha li hishiwa anala mendekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kamel lar am kowen tlavanda nil washi orok layikundas? Wahau. Uhunda hom ma ol mbele mbele mushak nanda Avui Wasilakahi siyok li sikmbaha li hishiwa kava ukwa mende sir.� ");
INSERT INTO sim_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Karem or mbarik wavu musha mushak li hishihi limu mbara, �Ayo, os erem si na nahi, lawe avak ermba ermbak linda oson laku?� ");
INSERT INTO sim_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Urik Jisas lirin or heyehe ormu mbara, �Mbele mbele ma undahi ambu ondo Avui Wasilaka or undahi lir.� ");
INSERT INTO sim_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Urik Pita mu orin silira, �Wasilaka, nir angop mbele mbele nihin ni halaha mirin er ni tiyanda nira. Hako mbele menden ni laku?� ");
INSERT INTO sim_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Karem or silirik ormu mbara, �Omendingak jirin amu sawenduwa, Ma Jikisi Avui Wasilakahi oto mbele mbele indiyok or unak akrikop li nakwa wolo kwambu orhi kormbak talakwa sir. Uhu malakamak nakwa ri. Unak jir erem or nga nakrem os or liwa mishik likwa jir. Uhu Israelik fehenda kraha 12-pela ondo mbele mbelen li uhundan heyembakwa jira. ");
INSERT INTO sim_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Misi, ma ol anin tiyakwak hishiwa ma ondo os mbele mbele lihin, aka, mahasanje, avoko, nijava, jikisi, nowe lihin li hala nahi, Avui Wasilaka mbele mbele ol li halawa ondohi farniyik warje nga or hakwa lir. Uhundanak kumak ermba ermbak linda oson lakwa lira. ");
INSERT INTO sim_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Misi, ma ol ter wolok maifu iwa ondo kumak avak kumasi ikwa lira. Hako ma ol ter wolok hi nga nawa ambu ondo kumak avak maifu ikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Uhu mashi las nga Jisas ormu mbara, �Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa oso karem nakwa osa. Noumashama lar nirsumbu mendek ma lal wain nowe orhik lerawun li lakmbaha or ushakurik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uhu ormu mbara, �Os avak nurum sishihi hominak nowe anhik lerawun ji la nahi, jir namtarmba namtarmbak ya las jirin a hakwa nir.� Karem or mbaha nor mbashirik nowe orhik lerawun li lakmbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Urik am 9 kilok hom si narik indik ma li tirsanda mishik or ihi nor heyeri ma lal orok men limu sira. ");
INSERT INTO sim_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Urik ormu mbara, �Jir nga avak ji ihi nowe anhik lerawun ji lanak avak yan os ji lawa lawa hom a haka.� ");
INSERT INTO sim_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Karem or mbarik limu ira. Ushi 12 kilokik indik or ihi lal or mbashirik limu ira. Ushihi 3 kilokik indik or ihi ma lal os mas or mbari hom or mbashirik nowe orhik lerawun lakurik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Urik am si homirik indik or ihi nor heyeri ma lal men orok limu sira. Uhu lirin ormu silira, �Mberem ji mbaha ji sindu? Lerawu nga nanda ambu oj?� ");
INSERT INTO sim_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Urik limu mbara, �He, ma lar mbeek lerawu las mbawak ni lawa ambu nir.� Urik ormu mbara, �Wa, jir er nga nowe anhik ji ihi lerawun ji laka.� ");
INSERT INTO sim_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Urik am si krinyakurik noumashama oto ma ol ornjik lerawun landa man washisinda man ormu mbara, �Nowe anhik lerawun landa ma ondon ushanak li ralanak yan haka. Ol kumasi mendek tawa ondon masmas hashihi maifuk tawan mivai haka.� ");
INSERT INTO sim_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Karem or mbarik os or mbari nombo hom ormu ura. Uhu am si homirik talari ma ondon masmas ya las lirin namtarmba namtarmbak ormu hara. ");
INSERT INTO sim_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Erem or haha ihi maifuk tari ma ondo warje nga li laku, karem hishiri lir. Hako wahau, lir nakremkop lari lir. ");
INSERT INTO sim_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Uhu ya os li larin li heyehe noumashama oton li ngriaha limu mbahanjira, ");
INSERT INTO sim_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","�Wahau te. Mberem ushiwak ma ol kumasi mendek tawa ondo nga nir nga nakremkop ya namtaskop ni landuwa? Nir nirsumbukop tantlembantle koroho ni laha ihi homiwa sir. Hako lir, wahau.� ");
INSERT INTO sim_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Urik noumashama mashi os erem li mbari oson or misihi lirin ormu mbara, �Ji misi, ya os jirin a hajehe na mbawa hom amu hawa sira. An mbeek jirin a mbafirimbawa ambu nir. ");
INSERT INTO sim_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ya jihi oson laha ika. Mbele mbele os kumasik tawa ma ondon a hawa oso wavu anhi osa. ");
INSERT INTO sim_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ya anhin os a ukmbaha a hishiwa hom a ukwa nir. Hako jir mberem ushiwak anin ji wapkava hishihi mbandu?� Karem ormu mbara.� ");
INSERT INTO sim_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas sauheima oson or mbarakoho ormu mbara, �Kumak avak erem nakwa sir. Ma ol kumasi mendewa kumak avak maifu ikwa lir. Hako ma ol maifu iwa kumasi ikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalemik or ikurik or ihi ol orin tiyandari ma 12-pela ondon or laha limu ira. Li ihi nombo nindik li sihi ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","�Misi, avak Jerusalemik ni ikwa nir. Unak ma misambik fehe avak Ma Jikisi Avui Wasilakahi oton bikpris nga mashi Moseshin sawendari ma nga lihi tavak li halakwa ri. Unak orin li kotim uhu orin li mandingormekmbaha mbaolsolokwa lira. ");
INSERT INTO sim_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Uhu Avui Wasilakahi mashin misinda ambu ondohi tavak li halashinak orin li okolehe li wakoroho miandok li tirishinak hakwa ria. Unak niri frijip fri ishinak indik usahakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Urik Sebedi nokove orhi oso nga jikisi sihi frijip ovro nga Jisasin heyekurik limu tara. Uhu nijava oso Jisasin si silikmbaha kumbambongon si huvuhu misambik simu raka lira. ");
INSERT INTO sim_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Urik Jisas sirin ormu silira, �Mberem a ukmbaha nyi hishindu?� Urik simu mbara, �An a hishiwa os malakamak mi naha yanga mihik mi liwa wolo jikisi anhi tovron mi mbanak malakamak fri naha mir nga nakrem fri lika, lar tapmama yok lar tava ashi yok.� ");
INSERT INTO sim_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Karem si silirik ormu mbara, �Jir mbeek os ji siliwan hishiyariwa ambu jir. Shir am nomorawu os anhik talakwan kishandahi osh?� Urik frimu mbara, �He, shi kishandahi sir.� Urik ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","�Ome sira, nomorawu os anhik talakwa oso shihik er nga talakwa sir. Hako ma ol tapmama anhi yok tava ashi anhi yok likwa ma ondo an mbeek a kamakwa ambu nir. Avui anhi ma ol or kamanda ma ondo nom or mbashinak orok likwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Urik Jisasin tiyandari ma 10-pela ondo nokove oso os si siliri mashin li misihi fririn limu ngriara. ");
INSERT INTO sim_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Urik Jisas lirin or usharik li tarik ormu mbara, �Malakama tol misambik linda angop ji heyenda lir. Lir awu awuk li mbashiwak hulaima nokopma lihi siyok li sihi os li mbawa nombo hom unda lira. ");
INSERT INTO sim_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Hako Ma Jikisi Avui Wasilakahi oto mbeek lir hom nanda ambu ri. Or mbeek ma lal ornjik lerawun li lakmbaha rari ambu ri. Ma amber or jelyaha lihi farniyik or hakurik tari ri. Karem uri osik jir anin tiyanda ma jirin ji misi, avak malakama misambik fehe hom ji nawa hala. Os jir lar malakamak or nakwak or hishi nahi, wa orhinjik or hafakaha mahi siyok or sika. Os jir lar ma amber tikrihi hausikwak or hishi nahi, wa halanak akishmakisha mendek or naha ma amber lirnjik lerawun landa ma hom or naka.� ");
INSERT INTO sim_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas nga orin tiyandari ma nga kuyanga Jerikon li hala irik ma mushak lirin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Urik misokome tumundari ma lap nombo sumbuk frimu lira. Urik Jisas nombo orok or tarik fri misihi frimu ushambara, �Wasilaka, shir wavu mi hishiwa!� ");
INSERT INTO sim_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Erem fri mbarik ma ol Jisas nga rari limu mbara, �Shir mayam shi li!� Hako, wahau, wasilaka mendek fri ushaha frimu mbara, �Wasilaka, nirambara Devithi mirin, shir wavu mi hishiwa!� ");
INSERT INTO sim_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Urik Jisas or misihi orok ormu sira. Uhu nor mbarik fri tarik ormu silira, �Mberem a shiri ukmbaha shi mbandu?� ");
INSERT INTO sim_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Urik frimu mbara, �Wasilaka, shi heyekmbaha shimu hishinduwa.� ");
INSERT INTO sim_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Urik frirnjik or holoho misokome frihik or hautarik kolok er fri heyehe orin frimu tiyaha ira. ");
INSERT INTO sim_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas nga ol orin tiyandari ma nga Jerusalemik li ikurik yanga Betfage telemba Oliv sumbu orok limu talara. Uhu orin tiyandari ma frijip or mbashirik yanga pasir nanda orok fri ikurik ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","�Kuyanga kasai ni heyewa mishik shi ihi donki las anjik shi laharaka. Orok shi ihi shi heyenak donki oso kuvuk li ishishinak jikisi sihi nga sikwa sir. Ushinak kuvu oson shi sorngoho donki nijava oso nga jikisi sihi nga anhik shi laharaka. ");
INSERT INTO sim_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Os ma lar shirin or sili nahi, karem shi saweka, Wasilaka lerawu nga or nawa osik or mbashiwak shimu randuwa. Karem shi mbanak kolok or mbashinak shi laharaka.� ");
INSERT INTO sim_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Os erem fri uri oso mashi os maskop profet li kayendari osmu omek nara. Mashi oso karem, ");
INSERT INTO sim_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","�Hulaima nokopma ol yanga Saionik fehendan karem ji saweka, king jihi avak jihik takwa ria. Uhu donki akri lasik or lawu lihi ma katai hi ngashi ambu hom jirik takwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Urik os or mbari nombo hom fri ihi erem frimu ura. ");
INSERT INTO sim_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Uhu donki nijava nga jikisi nga fri laha kousamba frihin donki heyek frimu ewera. Ushirik Jisas orok ormu lawu lira. ");
INSERT INTO sim_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Urik ma musha kousamba lihin li tloloho nombok limu lere ira. ");
INSERT INTO sim_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Urik lal mi tavan li tontlehe er nga nombok limu lere ira. Uhu lal li maifu irik lal li kumasi irik Jisas nindik ormu ira. Uhu orin li flehava kwaha limu ewehe mblaha ira, �Devit nirambara orhi toton nimu rupshi mendenduwa. Avui Wasilaka ma or hi orhik tawa toton armek or ukwa ri. Karem uwosik hi Avui Wasilakahin ni hauoweka.� ");
INSERT INTO sim_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Urik Jerusalemik or layirik orok fehenda ma amber ondo li lishnyafaha limu silminyara, �Isha, ma oto lawe ria?� ");
INSERT INTO sim_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Urik ol er nga tari ma ondo limu sawera, �Oto Jisas oria. Kuyanga Nasaret provins Galilik fehenda profet lar oria.� ");
INSERT INTO sim_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Urik Jisas or ihi tempel akak or layihi ma ol orok ya lerawun landarin ormu jikria ermberik hikrik limu layira. Uhu teye os li ewehe yan li ananduwareri teye ondon ormu kruma ermbera. Uhu kawu ol avi lihin li eweshirik ma li taha ofan li hakurik li frungawuri nga simbalesik er ormu jikria ermbera. ");
INSERT INTO sim_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uhu ormu mbara, �Jekamba Avui Wasilakahik karem li kayeri osa. �Aka anhi oso anin li sawenda mishi sira.� Hako ter os jimu uwak hirnyanda ma lihi aka hom osmu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas tempel aka orok or lirik misokome tumundari nga kumba tava kavak nandari nga orhik li tarik or urik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma ondon or mbarik jivik li narik ma amber li heyehe jikisakri mende nga orin li rupshihi hi orhin li hauowehe limu mbara, �Devit nirambara orhi toton nimu rupshinduwa.� Karem li mbarik bikpris nga mashi Moseshin sawendari ma nga sungu lihi kavak si narik orin li ngriaha limu silira, �Ma rondo hi mihin li hauowewan am mimu misindu?� ");
INSERT INTO sim_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Urik ormu mbara, �He, am a misinduwa. Hako jir mashi os Avui Wasilakahi jekambak li kayehendarin heyenda ambu oj? Karem li kayeri sir, �Jikisakri nga hi orhin hauowekwa ola.� � ");
INSERT INTO sim_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Karem or mba lafakaha Jerusalemin or halaha yanga Betanik or wakmbaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nirsumbu mendek Jisas indik Jerusalemik or ihi nombo nindik or sihi ormu erenghara. ");
INSERT INTO sim_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Urik mi fik las nombo orok si sirik or heyehe pasir or i sihi ormu simaura. Uri mbeek akwa nga nari ambu sir, wahau, minjakukwa nom olmu nara. Urik mi oson ormu mbara, �Nyir mbeek indik akwa ome nga nakwa ambu nyir.� Karem or mbarik mi oso kolok er simu hatlayira. ");
INSERT INTO sim_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Urik orin tiyandari ma ondo oson li heyehe li lishnyafaha limu mbara, �Ayo, mberemhi tos ter nanduwa, mi toso lewas er hatlayiw te?� ");
INSERT INTO sim_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Urik ormu mbara, �Jirin amu sawenduwa, os mashi Avui Wasilakahin ji misindiyaha wavu frijip frijip ji hishina ambu nahi, tos a uwak ji heyewa hom ji undahi sir. Hako oso nom nembes. Os telemba las ji mbanak si mblihi solwarak si raka, karem ji mba nahi, os ji mbawa hom nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Uhu os mashi orhin ji misindiyanda nombo jihi kwambuk si na nahi, ambehoma, mbele las orin ji sawewa avak os ji sawewa hom nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas indik tempel akak or layihi mashin ormu sawera. Urik bikpris nga Judama lida lihi nga orok li raha orin limu silira, �Lawe mbashindak lerawun mi landu?� ");
INSERT INTO sim_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Urik ormu mbara, �Os mbele las jirin a siliwan armek ji sawenak a misi nahi, an nga vai a sawenak ji misikwa sir, lawe or anin mbashihindak lerawun a landu. ");
INSERT INTO sim_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon man or fak tolofalendari oto lawe mbashirik lerawun or lar? Avui Wasilaka mbashirik mo ma misambik fehe mbashirik lerawu oson lari or?� Karem or silirik lihi ambek limu mbara, �Mberem ni mbakwa ambu re. Os ni mba, Avui Wasilaka mbashirik lerawu oson ormu lara. Karem ni mba nahi, avak or mba, mberem ushirik orin ji tiyakurin ji halar? ");
INSERT INTO sim_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hako os ni mba, ma misambik fehenda mbashirik lerawu oson ormu lara. Karem ni mba nahi, ma rondo avak nirin kavak nakwa ola. Mberem ushiwak? Jon profet oria, karem hishinda ola.� ");
INSERT INTO sim_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Karem li mbaha limu mbara, �Nir ni hishiwa kom te!� Urik ormu mbara, �An ngana, an mbeek a sawekwa ambu nir, ma or anin mbashihindak a taha lerawu toson a lawan.� ");
INSERT INTO sim_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Uhu Jisas sauheimak bikpris nga Judama lida lihin ormu sawera, �Mashi kas a mbawan ji misi. Ma lar jikisi orhi frijip nandari vria. Undarik lakamenden ormu mbara, �Mir avak ihi wain nowe anhik laka.� ");
INSERT INTO sim_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Karem or mbarik ormu mbara, �Wahau, an turaw.� Hako or lihi hishifuhu nowek ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Urik avoko or ihi mahakandan or heyehe sanjelakan or mbari hom ormu mbara. Urik ormu mbara, �He avui, avak a ikwa nir.� Hako mbeek iri ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Jir mberem ji hishindu, mahasanje ovron a mbawan, lawe mende avokohi mashin misir? Sanjelakan mo mahakandan?� Karem or silirik limu mbara, �Sanjelaka na.� Urik ormu mbara, �Os jimu omek mbanduwa. Hako ji misi, takis yan landa ma nga hulatolhakanda nokove nga lir avak jirin li tikrihi maifuk Avui Wasilakahi kuyanga orok layikwa lir. Mberem ushiwak? Jon nombo os sunguwavun ji tormblehe Avui Wasilakahik ji rakuri nombon jirin mukuri ora. Hako jir mbeek mashi orhin misiri ambu jir. Hako kavakavan unda ma ondo mashi orhin misiri lir. Jir angop ji heyeri lir, mashi orhin li misirin. Hako jir mbeek wavu jihin tormblehe os lir uri hom uri ambu jir. Karem uhunda osik lir avak jirin li tikrihi masmas Avui Wasilakahi kuyanga orok layikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Uhu Jisas ormu mbara, �Sauheima kason ji misi. Ma lar wain nowe las or laha inyin or washi arangoho wain siji omen li jimbresekundari las nga nor uhu nowen li washilikuri aka las nga ormu ura. Uhu nowe oson ma lalhi tavak or halashihi yanga lasik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uhundarik wain siji am li nivikuri wolok si narik ornjik lerawun landari ma lal or mbashirik ornjik lal li nimba laharakmbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hako ma ol nowen washilindari ma ondo ma or mbashirik tari ma ondon li heyehe lal li jihi, lal li jimandingormehe, lal li sunjakom loho li jirik tulu iri lir. ");
INSERT INTO sim_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ushirik ma anandi lal nga mushak or mbashirik limu ira. Urik os mas li uri hom erem li uri lir. ");
INSERT INTO sim_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Erem li urik or ufuhu ormu mbara, �Halashinak jikisi indingo anhin a mbashinak or inak mashi orhin misikwa lir.� Karem or mbaha jikisi orhin or mbashirik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Or irik li heyehe limu mbara, �Noumashama jikisi orhi indingo ormu tanduwa. Hako ka ni i orin ni jimandingormehe mbele mbele orhi ondon hiniyin ni oka.� ");
INSERT INTO sim_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Karem li mbaha orin li hikriyok li tolo longo laha ihi orin limu mandingormera.� ");
INSERT INTO sim_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas sauheima oson or sawerakoho ol orok lirin or heyehe ormu silira, �Wa mberem ji hishindu, noumashama oto kumak avak or taha ma ondon mberem orvai mbaku?� ");
INSERT INTO sim_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Urik limu mbara, �Ma kava ondon avak kavak or nakwa lir. Ushihi nowe oson ma anandihi tavak or halashinak lakwa lir. Unak wain sijin ornjik li laha eweshihindak kumak or tanakop li hakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Karem li mbarik ormu mbara, �Mashi os jekamba Avui Wasilakahik li kayehendarin heyenda ambu oj? Karem li kayeri sir, �Sunja ma akan unda, kava, karem li hishihi li ermberi sir. Hako wahau, angop wormbonawa hom maifuk ormu sinduwa. Wasilaka vai oson or unak ni heyenak jivik nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Erem li kayeri osik jirin amu sawenduwa, Avui Wasilaka avak jirin or halashihi ma anandi yoko ol mashi orhin misindiyaha akwa ome nga nawa ma ondon jihi farniyik orhi mak or kamakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma ol sunja heye orok takatukuyiwa avak havan tlekwa lir. Unak os sunja oso ma lalhi heyek si raka nahi, si mandingormekwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Karem or mbarik bikpris nga Farisi nga sauheima oson li misiri osmu lirik er nara. ");
INSERT INTO sim_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ushirik orin li tolokurik hishiri lir. Hako hulaima nokopma, Jisas profet, karem li hishiri osik li ajehe limu halara. ");
INSERT INTO sim_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Uhu sauheima las nga Jisas ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","�Os Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa karem nakwa osa. King lar jikisi orhi nokoplakurik hiyawu las ormu hundujera. ");
INSERT INTO sim_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Or hundujeshihi ma ol ornjik lerawun landari man or mbashirik limu ira, ma ol masmas or mainhahandari ondon li saweshinak li rakmbahan. Or mbashirik li ihi limu sawera. Hako ma ondo mbeek takurik hishiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Urik ma lal nga ormu sawembara, �Ji ihi karem ji sawe, bulmakau ondon angop a jihi akwa angop a hundujerakowa sir, kolok hiyawu anhi orok ji ramaraka.� ");
INSERT INTO sim_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Karem or mbarik mashi oson li laha ihi ma ol masmas or mainhahandari ondon limu sawera. Hako li turaha lerawu lihi os li landa landarik limu ira. Lal nowek irik, lal ya newe lihin li landarik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hako lal ma ol or mbashirik iri ma ondon li toloho kavakavak li uhu lal limu mandingormera. ");
INSERT INTO sim_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ushirik os erem li uri oson or misihi or waplelenaha awun undari ma orhin or mbashirik li ihi ma ondon simbalesik li jila mandingorme laha yanga lihi nga hik limu suwura. ");
INSERT INTO sim_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ushihi ormu mbara, �Mbele mbele akwa ondon angop a hundujerakori lir. Hako ma ol masmas or mainhahandari ondo jivi, karem a mbaha na ushari lir. Hako wahau, ma ondo ma kava lir. ");
INSERT INTO sim_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Uwosik avak yanga yangak ji ihi ma ol ji heyewa ondo yejen ji sawehe hiyawu anhi torok ji laharaka.� ");
INSERT INTO sim_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Erem or mbashirik li ihi ma amber ol li heyeri ondo, ma jivi nga ma kava nga, li sawe lahararik aka orhi mu hojera. ");
INSERT INTO sim_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aka oso am si hojerik King ma ol aka orok lirin heyekmbaha ormu tara. Or ta heyeri lar mbeek kowe os hiyawu orok li falendari kowe nga nari ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ushirik ormu silira, �Awasayi, mir mberem ushiwak kowe os hiyawu torok li falenda kowe nga mi falewa ambu re?� Karem or silirik mayam ormu lira. ");
INSERT INTO sim_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Urik ma ol ornjik lerawun landari man ormu mbara, �Ma roton ji kumbatol tavatoloho os nirtle nirndum nashiwak li entlekoronda mishi orok ji ermbenak or layihi lika. Uhu orok or lihi entlembale misihi fu orhin masham koho akwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ji misi, Avui Wasilaka ma mushak or ushanda lir. Hako ma laptonom or mbashinak yanga orhi orok layikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Urik Farisi ondo lihi ambek li tirsaha nombo las li eweheyenak Jisas mbele kava las or mbanak li misihi nombo orok orin li kotim ukmbaha limu tirsara. ");
INSERT INTO sim_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Uhu li mbashirik lihi ma lal nga Herothi ma lal nga Jisasik li ihi limu mbara, �Tisa, mir mainome nom sawewak ni heyenda mir. Uhu os hulaima nokopma Avui Wasilakan li tiyakwa nombon omek ewesawenda mira. Mir mbeek man ajenda ambu mir. Ma amber, hi ngashi nga hi ngashi ambu nga nakremkop mbanda mira. ");
INSERT INTO sim_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Unda osik nirin sawenak ni misika, mberem mi hishindu, os takis yan malakama Romik fehe Sisarin ni hakwa oso jivik nakwa os mo wahau?� Hako Jisas orin li oweioweiheyehe orin li kotim ukurik li mbari oson angop or heyeri sir. ");
INSERT INTO sim_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Uri osik ormu mbara, �Jir hokophakovimbanda ma jirin, mberem ushiwak anin ji hokovimbakwak ji randu? ");
INSERT INTO sim_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wa, ya os ma oton ji hakmbaha ji mbandan mukunak a heyeka.� Karem or mbarik ya las orin limu hara. ");
INSERT INTO sim_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Urik ormu silira, �Ma fumunyava lawehi nga hi lawehi nga ya torok si wandu?� ");
INSERT INTO sim_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Urik limu mbara, �Sisarhi vria.� Urik ormu mbara, �Wa, mbele mbele ol Sisarhi ondo indiyok orin ji haka. Hako mbele mbele ol Avui Wasilakahi ondo orin ji haka.� ");
INSERT INTO sim_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Karem or mbarik lir mbeek mashi las nga orin li mbakurik nari ambu sir. Urik orin li halaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Judama lal Sadyusi lir. Lir karem hishinda lir, ma ol hahanda mbeek indik usahakwa ambu lir. Oro wolok Sadyusi lal Jisasik li taha limu mbara, ");
INSERT INTO sim_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","�Tisa, mashi Moseshi karem sawenda sir, os ma lar jikisi nga nor na namber or hashinak maha orhi lar mumbla oson or owehe jikisi nga fri nawa, tlavu ji oto sanjelaka or hahanda orhik nakwa ria. Moses karem or kayeri sir. ");
INSERT INTO sim_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hako mas mahasanje 7-pelak nahandari lir. Uhu sanjelaka or nokoplaha jikisi nga nor na namber hari ria. Ushirik maha orhi mu mumbla oson ewera. ");
INSERT INTO sim_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mumblan or ewehe jikisi nga fri na namber hari ri. Ushirik orhi hindiyashi lar erem hari ria. Orokop li nana ihi marika mende erem sirin or ewehe jikisi nga fri na namber hari ri. ");
INSERT INTO sim_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Am amber li harakoshirik nokove oso er nga hari sira. ");
INSERT INTO sim_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hako avak mbanak ni misika, ma ol hahanda kumak indik li usahana wolo nokove oso avak lawehik sivai naku? Mahasanje ondo amber sirin lari ola!� ");
INSERT INTO sim_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Karem li silirik Jisas mu mbara, �Jir mbeek mashi os Avui Wasilakahi jekambak li kayehendari nga kwambu orhi nga heyekrahakoronda ambu jir. Uwosik os jimu surunduwa. ");
INSERT INTO sim_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ma ol hahanda indik li usahawa wolo mbeek hulasihi nokoplakwa ambu lir, wahau. Lir men ensel hevenik linda hom nakwa lira. ");
INSERT INTO sim_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hako os ma hahanda indik li usahakwa ambu, karem ji hishi nahi, wa anin ji sawenak a misi, mashi las Avui Wasilakahi jekambak mas mberem li kayer? Karem li kayeri osa, ");
INSERT INTO sim_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","�Avui Wasilaka orhinjik mbari ora �An God Abraham, Aisak, Jekop lihi God anira.� Mashi os or mbari oso mu nirin kormbak mukunduwa Avui Wasilaka mbeek ma ol hahanda lihi God ambu ri, wahau. Or God ma ol linda lihi God oria.� � ");
INSERT INTO sim_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Karem or mbarik mashi oson li misihi limu funurira. ");
INSERT INTO sim_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Urik Farisi lal li misiri Sadyusi ondo Jisas nga li anasaweri mbeek mashi kas nga li mbakurik nari ambu sir. Ushirik orhik limu rara. ");
INSERT INTO sim_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Uhu lihi lar Moseshi lon armek heyendari ma oton li mbashirik Jisasin or oweioweiheyekurik ormu silira, ");
INSERT INTO sim_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","�Tisa, mberemhi lo os maifuk naha lo anandin tikrindu?� ");
INSERT INTO sim_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Urik ormu mbara, �Jir avak Avui Wasilakan wapnuku jihik ji eweka. Uhu sunguwavu jihi nga masikome jihi nga os ji hishiyarinda jihi nga orin ji haka. ");
INSERT INTO sim_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo oso maifu mendek naha wasilaka mende sira. ");
INSERT INTO sim_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Os nindik sinda lo oso karem, ma anandin ji rupshika os jihinjik ji rupshinda hom. Oso maifuk sinda lo nga nakrem nanda vria. ");
INSERT INTO sim_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo ovro indinga nom lo anandi ondo nga mashi ol profet mbahanda nga tikrihi kishanda vri. Uhu lo ovrohik lo anandi ondo talahanda lir.� ");
INSERT INTO sim_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi orok er li lirik Jisas lirin ormu silira, ");
INSERT INTO sim_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","�Jir mberem ji hishindu Krais lawe ri? Jikisi lawehi ri?� Karem or silirik limu mbara, �Ma orto nirambara Devithik nakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Urik Jisas mu mbara, �Os erem si na nahi, mberem ushirik Devit ma oton Wasilaka orhik or mbar? Masikome Avui Wasilakahi Devitin or sauharik karem kayeri ria, ");
INSERT INTO sim_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","�Avui Wasilaka ormu Wasilaka anhin karem sawera, �Mir tapmama anhik lika. Ushinak wutari mihin avak a halashinak mihi siyok sikwa lira.� � ");
INSERT INTO sim_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ji misi, os Devit orhinjik or mbar, �Krais Wasilaka anhi ria.� Karem or mbari sir. Os erem si na nahi, mberem ushiwak Krais nirambara Devithi, karem li mbandu?� ");
INSERT INTO sim_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas karem lirin or silirik lir mbeek mashi las nga orin li mbakurik nari ambu sir. Uhu mashi las orin li silikurin limu ajera. ");
INSERT INTO sim_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Urik Jisas ma ol orok liri nga ol orin tiyandari ma nga ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","�Farisi nga mashi Moseshin sawendari ma nga Moseshi farniyik li sihi mashi Avui Wasilakahin ewesawenda mak nanda lir. ");
INSERT INTO sim_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Unda osik mashi os li ewesawewan ji tiyaka. Hako nombo os li yawa yawan ji tiyawa hala, wahau. Mberem ushiwak? Lir mbeek mashi os li sawenda hom tiyanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lir men ma anandi nom mashi lihin li tiyakmbaha sawenda lir. Oso osmu nomorawu wasilaka ma ondon li hawak li kishawak lir mbeek kandakar mende li jelyanda ambu hom nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mbele mbele ol li unda men ma li heyejehe unda lir. Kowe os li falenda kowe osohi kousumbun li owehe tlahapsinda lir. Uhu paus os jekamba Avui Wasilakahin li wolonda oson wasilakak unda lir. Unak ma li heyehe li mba, �Ma tondo Avui Wasilakahi ma tolira.� ");
INSERT INTO sim_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Uhu li lotu unda wolo nga hiyawun li uhu li anda wolo nga kawu ol maifuk li lerenda kawu orokop li likwak hishinda lir. ");
INSERT INTO sim_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Uhu ma lirin nombok li heyehe li makshitakshihi �tisa� karem li mbakmbaha hishinda ola. ");
INSERT INTO sim_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Hako jirin amu sawenduwa, avak ma lar �tisa� karem ji ushawa hala, wahau. Tisa jihi namtar numbu ri. Jir amber hom mahasanje jir. ");
INSERT INTO sim_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jir avak misambi torok fehe ma lar �Avui jihi� karem ji ushawa hala, wahau. Avui jihi namtar numbu or hevenik lindu. ");
INSERT INTO sim_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jir avak misambi torok ma lar �Wasilaka� karem ji ushawa hala, wahau. Wasilaka jihi namtar numbu Krais oria. ");
INSERT INTO sim_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Misi, os jir lar malakamak or nakmbaha or hishi nahi, halanak orhinjik or hafakaha ma kandai men lerawun landa ma hom or naka. ");
INSERT INTO sim_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hako os jihinjik ji yerkujihi ji mba, �An malakama anira.� Karem ji mba nahi, kumak avak Avui Wasilaka or unak hi jihi si rakanak humblarakwa jir. Hako os jihinjik ji hafakaha ji li nahi, kumak avak or unak hi jihi wasilakak nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Uhu mashi las nga Jisas ormu mbara, �Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Jir ma ol Avui Wasilakahi yanga orok ikwak hishiwa ma ondohi nombon arangonda jir. Jir orok ji ikwak hishinda ambu jir. Hako ma ol orok li ikwak hishiwa ma ondohi nombon os jimu arangonduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Jir nombo homen ji ihi solwaran ji mbuhu lerawu havan ji lanak ma lar jirin tiyanda mak or naku. Karem hishinda jir. Am jirin tiyanda mak or na nahi, wa hik or ikwa nombo oso osmu orin nikishinduwa, os jir hik ji inda nombok ji sinda hom. ");
INSERT INTO sim_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jir misokome tumunda jirin, jir mbeek man nombon mukundahik nanda ambu jir! Jir karem ewesawenda jir, os ma lar tempelin or mba, �Tempel heyewak mashi kason omek amu mbanduwa.� Erem or mbashihi os or mbawa oson or jintlewak ji mba, �Wa am nawa sir, or mbeek kavak nakwa ambu ri.� Karem ewesawenda jir. Hako os gol os tempel akan li tlahapsindan or ushaha orok or mba, �Gol os tempel akan li tlahapsihinda heyewak mashi kason omek amu mbanduwa.� Karem or mbaha nor tle nahi, kavak nakwa ri. Karem ewesawenda jir. ");
INSERT INTO sim_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jir misokome tumuhu ambarambasinda ma jirin, jir mbeek mbele las heyenda ambu jir. Mbele kas wasilakak naha maifundu? Tempelin mo golin? Tempelina. Tempel aka oso si sihi si ushiwak gol oso osmu jivik nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Uhu hovok karem ewesawenda jir, os ma lar alta mbele mbele ofan li ewe suwunda oson or ushaha nor mba, �Alta heyewak mashi kason omek amu mbanduwa.� Erem or mbaha os or mbanda oson or jintlewak ji mba, �Wa, am nawa sir, or mbeek kavak nakwa ambu ri,� karem ewesawenda jir. Hako os ofa ol alta orok ewenda ondok or usha nor mba, �Ofa os altak li ewenda oso heyewak mashi kason omek amu mbanduwa,� karem or mbaha nor tle nahi, kavak nakwa ri. Karem ewesawenda jir. ");
INSERT INTO sim_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jir misokome tumunda jirin, jir mbeek mbele las heyenda ambu jir. Mbele kas wasilakak naha maifundu? Altan mo ofa ol alta orok li ewendan? Altana. Alta oso mu uwak ofa ol orok li ewenda jivik olmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Karem uwosik ma or altan or usha nor mba, �Alta heyewak mashi kason amu mbanduwa,� Karem mbawa ma oto alta nga mbele mbele ol alta orok ofak li ewenda nga ormu mbawa sira. ");
INSERT INTO sim_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Uhu ma or tempelin or ushaha nor mba, �Tempel heyewak omek amu mbanduwa.� Karem mbawa ma oto tempel aka nga Avui Wasilaka or orok linda nga ormu mbawa sira. ");
INSERT INTO sim_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Uhu ma or hevenin or usha nor mba, �Heven heyewak mashi kason omek amu mbanduwa.� Karem mbawa ma oto hi Avui Wasilakahi nga or linda mishi nga ormu mbawa sira. ");
INSERT INTO sim_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Jir lo awarikanda nom ji tiyaha mbeek lo wasilaka ondon tiyanda ambu jir. Jir men ishavaka mbele mbele ondon ji laha 10-pelak ji humasihi namtas Avui Wasilakan handa jir. Hako jir mbeek man nombo wornak kotim unda ambu jir, man armek unda ambu jir. Uhu Avui Wasilaka mbele mbele ol ji ukmbaha or mbahandan unda ambu jir, men mbele mbele lo awarikanda ondo nom tiyanda jir. Hako an mbeek lo awarikandan ji halaha wasilaka nom ji tiyakmbaha na mbawa ambu nir, wahau. Evrembam ji tiyaka. ");
INSERT INTO sim_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jir misokome tumunda ma jirin, jir mbeek man nombon mukundahik nanda ambu jir. Jir men mbele mbele awarikanda nom heilaha mbanda jir. Os ji unda oso karem nanda sir. Jir uksembe os ji awan armek ji heyehe owe kanda ol orok wawan laha ermbenda jir. Hako kamel wasilaka os orok wawan heyenda ambu jir, wahau. Oson arngunyanda jir. ");
INSERT INTO sim_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Jir men hambiya kumbiya hikri yejen armek li yokonda hom nanda jir. Hako sunguwavu yeje jihi osmu kavak nanduwa. Mbele mbele mahin ji laha hi jihin jihinjik hauowenda jir. ");
INSERT INTO sim_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jir misokome tumunda ma jirin ji misi, maifuk akome yejen ji yokoshinak avak hikri yeje nga jivik si naka. ");
INSERT INTO sim_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Jir mawa os hikri yejen armek li semenim uhu kolta avishak li ermbeshiwak jip si heyenda hom nanda jir. Hako mawa akome oso ma havarava mbundi olmu orok hojehe wandu. ");
INSERT INTO sim_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma jirin li heyehe li mba, �Ma rondo jivi mende.� Hako wahau, sunguwavu yeje jihi nombo os haimba handambaha kavakavan unda osmu wavu jihi orok hojenduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jir mashi Moseshin sawenda ma nga Farisi nga ji auheyeka, kumak avak kavak nakwa jir. Neloko jihi profet ondo nga ma worna mak nandari nga li mandingormeri lir. Hako jir mawa lihin armek ji lamunyaha ");
INSERT INTO sim_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ji mba, �Nir os oro wolok ni lirikop mbeek ma ondon ni mandingormeri ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jir jihinjik ji mba, �Ma ol profet ondon mandingormeri ma ondo neloko nihi lira.� Ome sira, neloko indinga jihi lira. Unda osik os jimu nombo lihin tiyanduwa. ");
INSERT INTO sim_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hako erem ji uka. Lerawu kava os li laharaha halanda sumbuyambun ji laka. ");
INSERT INTO sim_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jir ma kava, hovo hom nanda jirin, Avui Wasilaka kumak avak man or heyembakwa wolo oson ji tuluku, karem jimu hishindu? Wahau. Mende indingo, mbeek ji tulundahi ambu. ");
INSERT INTO sim_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ji misi, avak profet lal nga, hishiyarinda ma lal nga, tisa lal nga, a mbashinak jihi nindik ikwa lir. Unak lal ji mandingormehe lal miandok ji tirihi lal haus lotu jihik ji wormblashihi lal ji jihi ji laha lesuwunak tulukwa lir. ");
INSERT INTO sim_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Os lirin ji jinak li fi ngoro nahi, kumak avak Avui Wasilaka wasan or unak fi ngorokwa jir. Ol Avui Wasilakahi ma worna ma ondon li mandingormerik fi ngoronda wasa oso avak jihik nakwa sir. Abelik sishi raha Sekaraia jikisi Berekiahik nahandan. Orin tempel aka alta nindik li mandingormeri ri. ");
INSERT INTO sim_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Omendingak jirin amu sawenduwa, mbele mbele kava os neloko jihi uhundari hom ter os jimu unduwa. Karem uwosik Avui Wasilaka fi lihi ngorori wasan avak or jinak fi ngorokwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Uhu Jisas ormu mbara, �Jir Jerusalemik fehe ma jirin, jir profet ondo nga ma ol Avui Wasilaka mbashirik tari ma ondo nga ji sunjakom loho mandingormenda jir. Jirin armek a ukmbaha na hishiwa nir, os aptok nijava jikisi sihin shervle sihik si arangonda hom. Hako jir mbeek anin ji halashiwak erem a unda ambu nir. ");
INSERT INTO sim_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Misi, yanga jihi avak kavak nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jirin amu sawenduwa, jir avak anin indik heyekwa ambu jir. Er ji lihi nikishifuhu ji mba, �Halanak Avui Wasilaka ma or hi orhik tawan armek or uka.� Karem ji mbana wolokop anin indik heyekwa jir.� ");
INSERT INTO sim_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas tempel akan or halaha hikrik or layirik ol orin tiyandari ma ondo orok li raha tempel aka nga aka jivi ol orok nandarin orin li mukuhu limu mbara, �Ayo, aka jivi tondon mi heyewa!� ");
INSERT INTO sim_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Urik ormu mbara, �Aka tondo jivi lira. Hako omendingak jirin amu sawenduwa, aka mbele mbele tol ter ji heyewa ondo kumak avak wutari li taha jila tarvlalarakokwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hovok Jisas telemba Olivik or lirik ol orin tiyandari ma li raha limu silira, �Mbele mbele ol mi sawewa ondo mbele wolo mendek li talanak nivai heyeku? Mberem si nanak ni heyehe nivai mbaku, Wasilaka am or tanak misambi mbele mbele ondo am mendek li nakwa wolok osmu nanduwa?� ");
INSERT INTO sim_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Urik ormu mbara, �Ji auheyeka, las avak ma lal li taha jirin li haimba handambanak lirin ji tiyanda ngashi. ");
INSERT INTO sim_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ma musha kumak avak hi anhik li raha karem mbakwa ola, �An Krais anira.� Karem li mbaha ma mushak haimba handambakwa ola. ");
INSERT INTO sim_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uhu kumak avak ji misinak yanga yangak awun ukwa lir. Ushinak maintama nga auhukwa nga ji misikwa sir. Hako oso wolo ji ajewa hala. Mbele mbele ondo masmas talakwa lir. Hako misambi nga lersuwu nga mendek fri nakwa wolo os akrik. ");
INSERT INTO sim_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kraha las hovok kraha lasik fehe nga anajikwa lir. Malakama yanga lasik fehe hovok malakama lasik fehe nga anajikwa lir. Unak kuyanga lal erenghanak kuyanga lal nenawu jikwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nomorawu ondo os jikisin li wakwak kumanhava jinda hom nakwa lir. Hako mbele mbele os mendek si nakwa wolo os akrik. ");
INSERT INTO sim_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Oro wolok jir anin tiyanda man kavakavak li uhu li jila mandingormelakwa jir. Uhu ma amber jirin waplelenaha kavak ukwa jir. ");
INSERT INTO sim_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Unak ma mushak os anin li tiyanda nombon halakwa lir. Uhu ma ol mas nakrem li lotu undari ma ondon ma kavahi tavak halakwa lir. Uhu lihi ambek wutarik ewekwa lir. ");
INSERT INTO sim_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Unak haimba handambanda profet mushak li talaha li mbanak ma musha lirin tiyakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kavakava os ma li unda avak wasilaka mendek si nanak os man li rupshihi armek li unda nombo oso mendek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hako ma ol kwambuk sitambanawa ondo Avui Wasilaka indik or lakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mashi jivi os Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa mashi oson yanga yangak li sawenak li mistakonakop misambi nga lersuwu nga mendek nakwa vri.� ");
INSERT INTO sim_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","�Mbele kava indingo las profet Daniel jekamba Avui Wasilakahik or kayehendarin avak ji heyenak Avui Wasilakahi akak li eweshinak sikwa sir. Ma ol mashi kason misiwa halanak armek li hishiyarika. ");
INSERT INTO sim_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Oro wolok jir provins Judiak linda ma shirinyambar telembak ji tulu ika. ");
INSERT INTO sim_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma or hikrik liwa indik aka orhik or layihi mbele mbelen lawan or halaka. ");
INSERT INTO sim_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma or nowek liwa indik yangak or ihi kowe mbele mbele orhin lawan or halaka. ");
INSERT INTO sim_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kavasumba, nokove ol masam nomok nawa nga jikisakrin muk hawa nga. Mberem livai tuluku? ");
INSERT INTO sim_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Uwosik ji beten unak os ji tulu ikwa wolo Sabat wolok mo ma rakanda wolok si nawan si hala. ");
INSERT INTO sim_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nomorawu os talakwa oso wasilaka mendek nakwa sir. Misambi toso nari wolok sishi raha ter nawa nga mbeek oso himi kas talari ambu sir. Ihi kumak erem, mbeek oso himi kas indik talakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nomorawu oso wasilaka mendek nakwa sir. Os Avui Wasilaka nomorawu oson or halashinak nambe mendek er si na nahi, ma amber harakokwa lir. Hako ma ol orhinjik or kamahanda ondonjik or holoho or mbanak nindik mendek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Oro wolok os li sawehe li mba, �Ji heyeka, Krais tor torok lindu,� mo �Katai karok lindu,� erem li sawe nahi, mashi lihin ji misiwa hala. ");
INSERT INTO sim_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mberem ushiwak? Ma musha mendek li taha lal karem haimba handambakwa ola, �An Krais anira.� Hovok lal karem mbakwa ola, �An profet lar anira.� Karem li mbaha mbele mbele ma undahi ambu ondon li uhu man haimba handambakwa ola. Uhu Avui Wasilakahi krahak sinda ma ondon er nga li laha ikwak hishikwa lir. Hako mberem li laha indahi ambu. ");
INSERT INTO sim_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mbele mbele ondo tala namber, angop a sauhambarik ji misiri sir. ");
INSERT INTO sim_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Karem uri osik os li mba, �Krais ma ngashi mishi ambu orok or lindu.� Karem li mba nahi, orok ji iwa hala. Uhu os li mba, �Aka orok or lindu.� Karem li mba nahi, mashi lihin ji misiwa hala. ");
INSERT INTO sim_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mberem ushiwak? Ma Jikisi Avui Wasilakahi os or takwa wolo os si lervla saikanda hom or tanak ma amber li heyekwa ri. ");
INSERT INTO sim_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Os mbele las haha wawak apkumbono li tirsawak li heyenda hom nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","�Nomorawu oso mendek si nanak kolok ta or tormblenak si tangnanak niyaka mbeek ukwa ambu sir. Unak tashingra misambik kongo rakakwa lir. Unak lersuwu yok avak nenawu jinda hom lishirikwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Unak kolok mbele las lersuwu yok talakwa sir. Oso Ma Jikisi Avui Wasilakahi os indik or takwa wolon mukukwa sir. Unak lersuwu nindik or sihi kwambu orhi nga ukruharanda orhi nga rakakwa ri. Ushinak ma amber orin li heyehe tlaholokwa lira. ");
INSERT INTO sim_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Unak fiwan li ufunanak ensel orhin or mbashinak misamsumbu yok yok li ihi ma ol or kamahanda ondon li lahara tirsaha orhik laharakwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","�Mi fik oson heyenda oja. Am si shorngo hanyiwak ji heyehe karem mbanda jir, �Ta am or jikwa wolok osmu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Uhunda hom mbele mbele ondo li talanak ji heyehe karem ji hishika, Ma Jikisi Avui Wasilakahi or takwa wolo osmu pasir nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Omendingak jirin amu sawenduwa, ma tol ter liwa lihi lal li ha namber mbele mbele ondo talakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Misambi nga lersuwu nga mendek nakwa vri. Hako mashi anhi mbeek mendek nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","�Hako Ma Jikisi Avui Wasilakahi or takwa wolo mbeek ma lar heyenda ambu sir. Ensel heyenda ambu lir. Ma Jikisi er nga heyenda ambu ri. Avui orto nom tolonda sir. ");
INSERT INTO sim_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Os or takwa wolo ma misambik fehe os Noahi wolok li undari hom ukwa lir. ");
INSERT INTO sim_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Fa si jisiri namber akwan li u aha nokoplaha hulasiri lir. Erem li liyaha ihi Noa sipik or layikuri wolok nari sir. ");
INSERT INTO sim_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hako lir mbeek os talakuri kas heyeri ambu lir, wahau. Men er li liyarik fa si rasaha si jisiriri lir. Uhunda hom os Ma Jikisi Avui Wasilakahi or takwa wolo erem nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma frijip nowek fri lanak Avui Wasilaka lar or laha lar or halakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nokove frijip wit sijin fri jimbresenak las or laha las or halakwa sir. ");
INSERT INTO sim_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Uwosik ji auheyeka, jir mbeek os or takwa wolon heyenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ji hishika, os aka mashama hirnyanda ma li takuri wolon or misirikop aka orhin armek or washilishirik aka orhin li tlelayiri ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Uhunda hom jir erema, ermba ermbak ji auheyehe ji hundujehe ji lika. Os ji mba, �Ma Jikisi Avui Wasilakahi mbernda takwa ambu ri.� Karem ji mbana wolokop takwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","�Jir mberem ji hishindu, malakama lar yanga lasik or ikuna wolo mberem nanda man or mbashinak mbele mbele orhin or washiliku? Ma or hishiyarinda nga naha jip lerawun landa ma otona. Erem nanda ma lerawun landa ma anandi ondon armek or washilihi akwan lirin humasikwa ri. ");
INSERT INTO sim_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Os malakama indiyok or ta heyenak lerawu orhin er or la nahi, or rupshika. ");
INSERT INTO sim_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Omendingak jirin amu sawenduwa, malakama avak orin or mbashinak mbele mbele orhi ondon washilikwa ri. ");
INSERT INTO sim_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hako os lerawun landa ma oto mambalek or naha or hishihi or mba, �Malakama anhi mbernda kolok takwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Karem or hishihi ma ol nakrem lerawun landan or jihi uku kavan anda ma ondo nga or li aha ambarambasi yanak ");
INSERT INTO sim_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","malakama orhi tumsar takwa ria. Hako or mbeek os or takuri wolon heyeri ambu ri. Uhu mbeek hundujeri ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hako malakama oto or taha lerawu kavan landa ma oton kavakavan or jihi or halashinak ma kava wavu frijip frijip hishinda ondo nga yanga os entle koronda mishi orok li ermbeshinak likwa ri. Uhu orok or lihi entlembale misihi fu orhin masham koho akwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas mashi las nga ormu mbara, �Os Ma Jikisi Avui Wasilakahi or takuna wolo avak sauheima kas nokopminyongo 10-pelak nawa hom nakwa sir. Nokopminyongo ondo lam lihin li laharaha ma or nokoplakurik tarin li nikishikurik limu ira. ");
INSERT INTO sim_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tostava yoko hom am yarindari lir. Hako tostava yoko yarindari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yarindari ambu ondo lam lihi nom lari lir, mbeek uku nga laha iri ambu lir. ");
INSERT INTO sim_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hako yarindari ondo uku lihi kas botolik li ngoroho er nga laha iri lir. ");
INSERT INTO sim_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hako ma oto mbeek kolok tari ambu ri. Ushirik limu nikishira. Li nikishirik misokome lihi si tumtamurik limu suknyara. ");
INSERT INTO sim_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Urik am nirkundik si narik kolok limu ushasawera, �Ma or nokoplakwa ormu tanduwa. Kolok hikrik ji ihi orin ji heyeka!� ");
INSERT INTO sim_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Urik nokopminyongo ondo amber li usaha lam lihin kar nga li tolonak lakak si ukrukmbaha limu ura. ");
INSERT INTO sim_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hako yarindari ambu ondo limu mbara, �Ayo, lam nihi am usunguahakwak naw te! Uku kas nirin ji hawa.� ");
INSERT INTO sim_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Urik yarindari ondo limu mbara, �Wahau, uku toso mbeek lakak nawa ambu re. Mbeek kas nawa osik jirin ni hakwa ambu. Stuak ji ihi anandin ji laka.� ");
INSERT INTO sim_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Karem li mbashirik yarindari ambu ondo ukun li lakmbaha li ishirik ma oto am ormu tara. Or taha yarindari ondo ol armek hundujehe liri ondon or laha hiyawu laka os li akuri mishi aka orok limu layira. Ushirik akayangan limu koso arangora. ");
INSERT INTO sim_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Akayangan am li koso arangoshirik yarindari ambu ondo li taha hikrik li sihi limu ushambara, �Ayo, Wasilaka, akayangan mi sutlashinak ni talawa!� ");
INSERT INTO sim_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Karem li mbarik ormu mbara, �An mbeek jirin na heyenda ambu nir.� � ");
INSERT INTO sim_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas sauheima oson or sawerakoho ma ol orok lirin ormu mbara, �Uhunda hom jir erem yarihi ji lika. Mberem ushiwak? Wasilaka jihi os or takwa wolo mbeek ji heyenda ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas mashi las nga ormu mbara, �Avui Wasilaka hulaima nokopma orhin or arangoshinak orhi yangak li likwa karem nakwa sir. Malakama lar yanga lasik or ikuri wolo ornjik lerawun landa ma nalmingrip or mbarik li rarik mbele mbele orhin lihi tavak ormu hara. ");
INSERT INTO sim_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uhu kwambu lihi nga hishiyari os li nandari nandarik or heyehe ya orhin ormu hara. Or haunandarin 5,000 kinak ormu hara. Or hakandarin 2,000 kinak, or hakandari menden 1,000 kinak ormu hara. Erem or ha lafakaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Or ishirik ma or 5,000 kinak lari ma oto ya orok lerawun or larik 5,000 las er nga talari sir. ");
INSERT INTO sim_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma or 2,000 kinak lari erem. Ya orok lerawun or larik 2,000 kina las er nga talari sir. ");
INSERT INTO sim_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hako ma or 1,000 kinak lari ma oto malakamahi ya oson or laha layi wakor jiyiri sir. ");
INSERT INTO sim_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kandakar nga nambehik naha malakama oto indik or taha ya os or hashirik li larin or heyekmbaha normu mbara. ");
INSERT INTO sim_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Urik ma or 5,000 kinak lari ma oto 5,000 kina os or larik talarin er nga or laharaha ormu mbara, �5,000 kina mi harik lerawun a larik 5,000 kaso er nga talari sir.� ");
INSERT INTO sim_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Urik malakama oto mu mbara, �Mir ma jivi lerawun armek landa ma mira. Ya awarikandak mirin a hari sir. Hako armek lerawun mi lari osik avak lerawu wasilaka las mihi tavak a halakwa nir. Mir avak an nga nakrem shi rupshi mendekwa shira.� ");
INSERT INTO sim_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Urik ma or 2,000 kinak lari ma oto 2,000 os or larik talarin er nga or laharaha ormu mbara, �2,000 kina mi harik lerawun a larik 2,000 kaso er nga talari sir.� ");
INSERT INTO sim_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Urik malakama oto mu mbara, �Mir ma jivi lerawun armek landa ma mira. Ya awarikandak mirin a hari sir. Hako armek lerawun mi lari osik avak lerawu wasilaka las mihi tavak a halakwa nir. Mir avak an nga nakrem shi rupshi mendekwa shira.� ");
INSERT INTO sim_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Urik ma or 1,000 kinak lari ma oto or taha ormu mbara, �Wasilaka mir angop a heyenda mir, mambalek nanda mir. Akwa os ma anandi kumbandan sanda mir. Uhu sijin mi sihinda ambu orok akwa omen landa mir. ");
INSERT INTO sim_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Erem mi nanda osik mirin a ajehe ya mihin a wakor jiyiri nir. Hako ter os amu indik lahara mirin handuwa.� ");
INSERT INTO sim_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Urik malakama oto mu mbara, �Mir ma kava indingo mira. Uhu sauhombo yanda mir. Os akwa ma anandi li kumbandan a sanda nir. Uhu os sijin a sihinda ambu orok akwa omen a landa nir. ");
INSERT INTO sim_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Os karem mi heyendarikop mberem ushirik ya anhin bengik mi ewendarik ya lal er nga na lakurin mi halar?� ");
INSERT INTO sim_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Karem or mbaha ormu mbara, �1,000 kina os orin na harin ji laha ma or 10,000 kina nga nawa oton er nga ji haka. ");
INSERT INTO sim_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mberem ushiwak? Ma or lerawu jivin lawan warje lal er nga na hakwa nir. Ushinak jip likwa ria. Hako ma or sauhomboyanda oton avak a laha ermbeshinak mendek nakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma kava roton avak ji kumbatol tavatoloho nirtle nirndum nashiwak li entlekoronda mishi orok ji ermbenak or layihi lika. Uhu orok or lihi entlembale misihi fu orhin masham koho akwa ri.� � ");
INSERT INTO sim_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas mashi las nga ormu mbara, �Ma Jikisi Avui Wasilakahi indik or takwa wolo os malakamak or nakwa oso kormbak si nashinak ensel orhi ondo nga takakwa ri. ");
INSERT INTO sim_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ushinak yanga yangak fehenda ma amber os or liwa mishik talandirsakwa lir. Li ralandirsanak os sipsip mashama sipsip orhi nga meme orhi nga or toloyarinda hom or toloyarikwa lir. ");
INSERT INTO sim_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipsip ondon tapmama yok meme ondon tava ashi yok or halakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ushihi tapmama yok siwan or mba, �Jir Avui anhi armesarmek or ukwa ma jirin, ji raka. Misambi mbele mbele or u namber yanga os ji likwa oson angop jirnjik or hundujeri sir. Avak ji raha orok ji lika. ");
INSERT INTO sim_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mberem ushiwak? A erengharik akwan jimu ya hara. Uksembenjik a mbarik uksemben jimu ya hara. Samba samba mak a narik aka jihik anin jimu ya laha ira. ");
INSERT INTO sim_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A serembomba sirik kowen jimu ya hara. A kavamisirik anin jimu jelyara. Krawuk a lirik anin jimu ta heyera.� ");
INSERT INTO sim_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Karem or mbarik olmu silira, �Wasilaka, mbele wolo mendek mi erengharik akwan ni har? Uksembenjik mi mbarik uksemben ni har? ");
INSERT INTO sim_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Samba samba mak mi narik aka nihik ni laha ir? Serembomba mi sirik kowen ni har? ");
INSERT INTO sim_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mi kavamisirik ni jelyar? Krawuk mi lirik mirin ni ta heyer?� ");
INSERT INTO sim_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Urik ormu mbara, �Omendingak jirin amu sawenduwa, mbele mbele ol erndakava anhi ondon ji uri oso anin jimu uri sira.� ");
INSERT INTO sim_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ushihi ma ol tava ashi yok siri ondon ormu mbara, �Ji ika, jir mbeek an nga likwa ambu jir. Ji ihi hi os Laulaka nga ensel orhi ondo nga lirnjik li hundujehendari mishi orok ji layika. ");
INSERT INTO sim_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A erengharik mbeek akwa kas anin hari ambu jir. Uksembenjik a mbarik mbeek uksembe kas anin hari ambu jir. ");
INSERT INTO sim_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Samba samba mak a narik mbeek aka jihik anin laha iri ambu jir. Serembomba a sirik mbeek kowe las anin hari ambu jir. A kavamisirik mbeek anin jelyari ambu jir. Krawuk a lirik mbeek anin ta heyeri ambu jir.� ");
INSERT INTO sim_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Urik lir nga mu silira, �Wasilaka, mbele wolo mendek mi erengha uksembenjik mi mbaha samba samba mak mi naha serembombak mi sihi mi kavamisihi krawuk mi lirik mirin ni jelyari ambu, karem mimu mbandu?� ");
INSERT INTO sim_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Urik ormu mbara, �Omendingak jirin amu sawenduwa, mbele mbele ol erndakava anhi ondon ji ukurin ji halari anin ji ukurin jimu halari sira.� ");
INSERT INTO sim_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Malakama oto karem or mbarik ma kava ondo yanga os hi nga nanda mishi orok li ermbeshinak ermba ermbak orok likwa lira. Hako ma worna ma ondon or mbashinak ermba ermbak jip likwa lira.� ");
INSERT INTO sim_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas mashi oson am or sawerakoho ol orin tiyandari man ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","�Niri frijip fri inak hiyawu Pasovan ni ukwa wolok osmu nanduwa. Oro wolok Ma Jikisi Avui Wasilakahi oton ma kavahi tavak li halashinak orin li jimandingormehe miandok li tirikwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Os mashi oson or mbari wolo bikpris nga Judama lida lihi nga amber li ralaha hetpris Kaiafashi akak limu tirsara. ");
INSERT INTO sim_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Uhu nombo nombo os li haimba handambaha Jisasin li toloho orin li mandingormekurin limu oweioweiheyera. ");
INSERT INTO sim_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Uhu limu mbara, �Hako os hiyawu Pasovan ni unda wolok orin ni tolokwa ambu ri. Las avak orin ni tolonak ma ol orok talawa li heyehe awun li unda ngashi.� ");
INSERT INTO sim_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas yanga Betanik Saimon mas okmbale lepra tolondari ma otohi akak ormu lira. ");
INSERT INTO sim_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Orok or lihi li arik nokove las wel uku arme kuvasahandari ya lakak li frungawundari oson botolik si laharaha Jisashi masijik simu ngorora. ");
INSERT INTO sim_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Urik orin tiyandari ma ondo oson li heyehe sirin limu ngriara, �Ayo, mberem ushiwak wel uku oson nyi sambunduwa? ");
INSERT INTO sim_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Os nyi halashiwakop ni layiwak ma li frungawushiwak ya mushak ni laha erndakava ondon ni handahi os te!� ");
INSERT INTO sim_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Urik Jisas ormu mbara, �Mberem ushiwak toso kavan ji ngriandu? Sir anin armek uwa sir. ");
INSERT INTO sim_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Erndakava ondo ermbak jir nga likwa lir. Hako an mbeek nambek jir nga na likwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Os erem si uwa oso kumak maome anhin mawak li ewekundan hundujewa sir. ");
INSERT INTO sim_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Omek jirin amu sawenduwa, kumak mashi jivi anhin yanga yangak li laha sawehe mashi os si unda nga li sawenak ma amber misikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Urik Jisasin tiyandari ma 12-pela lihi lar, hi orhi Judas Iskariot, bikpris ondon or i heyehe ");
INSERT INTO sim_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ormu silira, �Os Jisasin tava jihik a ha nahi, mbele menden anin ji haku?� Karem or silirik ya silva 30-pelak orin limu hara. ");
INSERT INTO sim_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Urik nombo nombo os Jisasin tava lihik or hakurin ormu li hishira. ");
INSERT INTO sim_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hiyawu Pasova os sipsipin li jihi Bret Yis Ngashi Ambun li andari wolok simu nara. Urik Jisasin tiyandari ma orhik li raha limu silira, �Wa, mbeyok ni ihi akwan ni hundujeshihi nivai aku?� ");
INSERT INTO sim_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Urik ormu mbara, �Jerusalemik ji ihi ma lar ji i heye orin ji sawe ji mba, Tisa or mba, �Anin li jikmbaha li mbahanda wolo osmu pasir nanduwa. An nga ol anin tiyandari ma nga aka mihik hiyawu Pasovan ni akwak amu hishinduwa.� � ");
INSERT INTO sim_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Karem or mbarik os or mbari hom li uhu akwan limu hundujera. ");
INSERT INTO sim_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Am si homirik Jisas nga ma 12-pela ondo nga aka orok limu ira. ");
INSERT INTO sim_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Orok li lihi li aha ormu mbara, �Jihi lar avak anin tavarenje wutarihik hakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Karem or mbarik sunguwavu lihi nga li holoho limu silira, �Wasilaka anin mimu mbandu mo?� ");
INSERT INTO sim_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Karem li silirik ormu mbara, �Jihi lar an nga nakrem shi awa ma oto anin ma kavahi tavak hakwa ria. ");
INSERT INTO sim_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma Jikisi Avui Wasilakahi oto os or hakmbaha mas Avui Wasilakahi jekambak li kayendari nombo hom hakwa ri. Hako ma or orin wutarihi tavarenjek hakwa ma oto or holoka. Avak kavak nakwa ri. Mbele lakmbaha nijava orhi orin si war? Si wahanda ambukop jivik nawa sir.� ");
INSERT INTO sim_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Karem or mbarik Judas, Jisasin ma kavahi tavak hakuri ma oto mu silira, �Tisa, anin mimu mbandu mo?� Urik ormu mbara, �Os mihinjik mi mbawa homa.� ");
INSERT INTO sim_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Li lihi li aha Jisas bret las or laha Avui Wasilakan armek or mbaha bretin or toltavaha ol orin tiyandari man ormu hara. Uhu ormu mbara, �Kaso maome anhi kasira. Ji laha aka.� ");
INSERT INTO sim_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ushihi wain uku kas hambiyak or ngoroho Avui Wasilakan armek or mbaha lirin or haha normu mbara, �Kaso jihi ambek tenjer ji aka. ");
INSERT INTO sim_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Fi anhi kaso suma akrin jir nga Avui Wasilaka nga tivikwa sira. Fi anhi kaso hulaima nokopmanjik si ngoroshinak kavakava os li undan yokokwa sir. ");
INSERT INTO sim_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jirin amu sawenduwa, an mbeek wain uku kas indik a akwa ambu nir. Uhundanakop Avui Wasilaka hulaima nokopma orhin or laha or arangoshinak li likwa wolo kormbak si nanakop indik a akwa nir.� ");
INSERT INTO sim_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Karem or mbaha hukwa las li koroho aka oson li halaha telemba Oliv orok limu lawura. ");
INSERT INTO sim_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Urik Jisas mu mbara, �Mas karem li kayeri sir, �Avui Wasilaka avak sipsipin washilinda man or jishinak sipsip orhi amber tulu ikwa lir.� Karem li kayeri osik avak nirik jir amber anin ji halaha tulukwa jir. ");
INSERT INTO sim_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Avak a hakwa nira. Hako indik a usaha masmas Galilik a inak jivai raka.� ");
INSERT INTO sim_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Urik Pita mu mbara, �Os ma ondo amber mirin li hala nahi, an mbeek mirin a halakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Urik ormu mbara, �Pita, mirin amu sawenduwa, ter nirik aptoko mba namber mir avak hindi nalmingrip anin mi heyenda ambu, karem mbakwa mira.� ");
INSERT INTO sim_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Urik ormu mbara, �Wahau te! Erem a mbakwa ambu nir. Os mir nga shi ha, karem mbanda nahi, mir nga shi hakwa nir, an mbeek mirin a halakwa ambu nir.� Karem or mbarik ma amber or mbari hom limu mbara. ");
INSERT INTO sim_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Urik Jisas nga ol orin tiyandari ma nga yanga Getsemanik li lawuhu ormu mbara, �Jir torok ji linak orok a lawuhu Avuin a saweka.� ");
INSERT INTO sim_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Karem or mbaha Pita nga Sebedihi jikisi ovro nga nor laha limu lawura. Li lawuhu ihi sunguwavu orhi nga or hishiri kavak simu nara. ");
INSERT INTO sim_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Uhu ormu mbara, �Sunguwavu anhi am kavak si nawak a hakwa mendek amu misinduwa. Jir torok an nga nakrem ni lika.� ");
INSERT INTO sim_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Karem or mbashihi kandakar nga homek or ihi misambik or taka waha Avui orhin ormu sawera, �Avuya, os nombo kas na nahi, nomorawu anhik talakwa oson halanak anin si tikrika. Hako an mbawa hom uwa hala. Os mi hishiwa hom uka.� ");
INSERT INTO sim_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ushihi or raha ma nalmingrip ondon or ta heyeri li suknyarik Pitan ormu mbara, �Mir an nga kandakar shi likwa ambu om? ");
INSERT INTO sim_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ji lihi Avui Wasilakan ji saweka. Las avak jeikayenda jihik si talanak ji tukuyinda ngashi. Wavu yoko jihi jip ukwak hishinda sir. Hako maome jihi mbeek kwambu nga nanda ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Karem or mbaha indik Avui orhin sawekurik or ihi ormu mbara, �Os nomorawu oso anhik si talakwak si na nahi, wa halanak os mi mbawa hom si naka.� ");
INSERT INTO sim_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Karem or mbaha ma ondohik indik or raha or heyeri limu wa suknyara. Mberem ushirik? Am li kreheri osa. ");
INSERT INTO sim_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uhu lirin or halaha indik or ihi Avui orhin os mas or saweri hom indik ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Uhu indiyok or taha ormu sawera, �Jir armek er jimu waha suknyandu! Ambehoma, os a mbahanda osmu talanduwa. Ma Jikisi Avui Wasilakahi oton li laha ma kavahi tavak li hakwa wolok osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ji usaha ni ika. Ma or anin ma kavahi tavak hakwa ma oto ormu tanduwa.� ");
INSERT INTO sim_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas mashin or saweri halanganga, kolok Judas mu rara. Judas ma 12-pela orin tiyandari lihi lar oria. Or tarik ma mushak bainat nga kombe nga li laha er nga limu rara. Ol bikpris nga Judama lida lihi nga li mbashirik limu rara. ");
INSERT INTO sim_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas angop lirin karem saukaweri ri, �Os a ihi ma or a toloho na makshitakshiwa ma oto Jisas oria. Orin ji toloka.� ");
INSERT INTO sim_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Urik Judas nombok Jisasik or ihi ormu mbara, �Tisa,� karem or mbaha ormu makshitakshira. ");
INSERT INTO sim_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Urik Jisas mu mbara, �Anhi kup os mi ukmbaha mi rawa kolok uka.� Urik ma ondo li taha Jisasin limu tolora. ");
INSERT INTO sim_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Urik kolok Jisas nga nakrem liri ma lar, bainat orhin or longoho ma or hetprisnjik lerawun landari ma mambla orhin ormu shinjesera. ");
INSERT INTO sim_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Urik Jisas mu mbara, �Bainat mihin haiewe. Ma ol bainatik awun unda ma ondo bainatik li jimandingormenda lir. ");
INSERT INTO sim_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mir hishiwa ambu om? Os Avui anhin a silinak ensel musha mendek or halashinak anin jelyakunak li raka. Karem a mba nahi, or halashinak takakwa lir. ");
INSERT INTO sim_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hako os erem a sili nahi, mashi os jekamba Avui Wasilakahik li kayehendari mashi oso mbeek omek nakwa ambu sir. Karem uwosik erem a mbakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Karem or mbaha ol orin tolokurik tari ma ondon ormu mbara, �An hirnyanda ma, karem ji hishihi bainat nga kombe nga jimu laharandu? Ermba ermbak tempel aka orok mashi Avui Wasilakahin a ewesawenda nir. Oro wolok anin ji tolondari mberem ji mbar? ");
INSERT INTO sim_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ambehoma, mashi os profet ondo li kayehendari oso ter osmu omek nanduwa.� Karem or mbarik ol orin tiyandari ma amber orin li halaha limu tulu ira. ");
INSERT INTO sim_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma ol Jisasin tolori ma ondo orin li laha hetpris Kaiafashi akak limu laha layira, os mashi Moseshin sawendari ma nga Judama lida lihi nga li tirsari mishi orok. ");
INSERT INTO sim_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita Jisasin or lundiya ihi hetprishi akanivi orok or layihi tempel akan washilindari ma nga nor lihi or heyenak mbele os Jisasik talaku, karem mbaha ormu lira. ");
INSERT INTO sim_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bikpris nga Judama lida lihi nga aka orok li lihi nombo nombo os Jisasin li mandingormekuri nombon limu mbara. Ushihi ma lal li mbashinak li raha li haimba handambanak mashi orok orin li mandingormekurik limu mbara. ");
INSERT INTO sim_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Urik ma musha li taha limu haimba handambara. Hako mashi os li mbari orok mbeek orin li kotim undahik nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Erem li mba irik ma frijip mu rara. Uhu frimu mbafirimbara, �Ma roto mas karem mbari ri, �Tempel aka Avui Wasilakahi oson a jitarvlashihi niri frijipkop indik a undahik a nanda nir.� Karem or mbarik shi misiri shir.� ");
INSERT INTO sim_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Karem fri mbarik hetpris or usasihi Jisasin ormu silira, �Tos fri mbawa mashin am mimu misindu? U nahi, saweka.� ");
INSERT INTO sim_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Karem or silirik Jisas mashi las nga mbari ambu ri. Urik indik ormu silira, �Avui Wasilaka ermba ermbak linda or heyewak mirin amu silinduwa, unak mir omek saweka, mir hulaima nokopman jivinakmbaha or kamahanda ma om? Mir jikisi orhi om?� ");
INSERT INTO sim_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Karem or silirik Jisas mu mbara, �Os mi mbawa homa. Hako jirin amu sawenduwa, kumak ji heyenak Ma Jikisi Avui Wasilakahi oto tapmama orhi yok or sihi lersuwu yok or tanak ji heyekwa ri.� ");
INSERT INTO sim_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Karem or mbarik hetpris or waplelenaha kowe orhin or frehe ormu mbara, �Ambehoma, mbeek ma lal nga ni mbanak raha sawekwa ambu lir. Toto Avui Wasilakan okolembawa toria. Angop ni misiwa sir, tos ter or mbawan. ");
INSERT INTO sim_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mberem ji hishindu, mberem nivai ori uku?� Karem or mbarik lir amber limu ushambara, �Or musa nga nawa osik halanak or haka.� ");
INSERT INTO sim_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Urik orin li suntlayashihi tavakombek limu jira. Uhu lal orin limu jimblalanara. ");
INSERT INTO sim_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Uhu limu mbara, �Os mir Avui Wasilaka or kamashihindak hulaima nokopman jivinakunda mak mi na nahi, sawenak ni misika, lawe ol mirin jindu?� ");
INSERT INTO sim_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita akanivi orok or lirik hetprisnjik lerawun landari nokove las si taha simu mbara, �Mir ngana Jisas Galilik fehenda nga yanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Karem si mbarik ormu mbara, �Mashi os nyi mbawan amu hishandu.� ");
INSERT INTO sim_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Karem or mba lafakaha akayanga yok or ihi orok ormu sira. Urik nokove anandi las si raha orin si heyehe ma ol orok nakrem siri ondon simu sawera, �Toto Jisas Nasaretik fehenda nga yanda toria.� ");
INSERT INTO sim_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Urik ormu mbara, �Omendingak jirin amu sawenduwa, orin na heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Urik kandakar nga or lirik ma lal orhik li taha limu mbara, �Mir Galilik fehenda hom mbaw te! Ome sira mir or nga yanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Urik mainkwambuk ormu mbara, �Omendingak jirin amu sawenduwa, an mbeek orin na heyenda ambu nir. Os omek a mbana ambu nahi, halanak Avui Wasilaka anin kavak or uka.� ");
INSERT INTO sim_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Karem or mbarik kolok aptoko mu mbara. Urik mashi os Jisas mbarin ormu hishira, �Ter nirik aptoko nor mba namber hindi nalmingrip anin mi heyenda ambu, karem mbakwa mira,� mashi kason indiyok or hishihi hikriyok or layihi havahavan ormu tlara. ");
INSERT INTO sim_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nirsumbu mendek si narik bikpris nga Judama lida lihi amber nga li tirsaha nombo os Jisasin li mandingormekurin limu mbaolsolora. ");
INSERT INTO sim_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Uhu orin kuvuk li ishihi Romik fehenda malakama otohik orin limu laha ira. Ma oto hi orhi Pailat. ");
INSERT INTO sim_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ma or Jisasin wutarihi tavak hari ma oto os Jisasin li mandingormekurik li mbari mashin or misihi ormu mbara, �Os erem a uwa osmu kavak nawa sir.� Karem or mbaha ya 30-pela silva os hetpris nga Judama lida lihi nga orin li harin indiyok ormu lai hara. ");
INSERT INTO sim_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Uhu ormu mbara, �An kavakavan a uwa nir. Ma or tava jihik a hawak ji mandingormekwak ji mbawa oto mbeek musa las nga nawa ambu ri.� Urik limu mbara, �Mirvai mbakwa sir, mihinjik mi uwa os te!� ");
INSERT INTO sim_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Karem li mbarik ya ondon tempel akomek or ermbeshihi hikrik or i layihi ormu kupsira. ");
INSERT INTO sim_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Urik bikpris ondo ya ondon li laha limu mbara, �Ya kando man li mandingormekurik li landa ya kalira, mbeek tempelhi yanga ni tirsakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Karem uhu li mbaolsoloho limu mbara, �Ka ni i ma or pavin unda ma misambi orhin ya orok ni frungawuka. Uhu ni halashinak ma ol homek fehe tol torok liwa os li hawa wolo orok ni wakor eweka.� ");
INSERT INTO sim_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Erem li uri osik misambi oso ter nga, Fi ngoronda misambi, karem li ushanda sir. ");
INSERT INTO sim_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nombo os erem li uri oso si urik mashi os profet Jeremaia maskop or mbahandari osmu omek nari sira. Karem or kayeri sir, �Ya silva 30-pelak ol Israelik fehe ma oton li hanak li mandingormekurik li mbari. ");
INSERT INTO sim_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Uhundari ya oson li laha ma or pavin unda ma misambi orhin ya orok li frungawuri lir, os Avui Wasilaka mas anin or mbahandari hom.� ");
INSERT INTO sim_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Urik Jisasin Pailat liri mishik li halashirik ormu sira. Urik Pailat mu silira, �Mir King Judamahi om?� Karem or silirik Jisas mu mbara. �Os mi mbawa homa.� ");
INSERT INTO sim_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Urik bikpris nga Judama lida lihi nga mashi mushak Jisasin limu mbahanjira. Hako or mbeek mashi las nga mbari ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Urik Pailat mu silira, �Mir ma tondo mbawan am mi misindu? Tol mashi mushak mirin li mbawan?� ");
INSERT INTO sim_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hako Jisas mbeek mashi las nga mbari ambu ri. Urik Pailat wavu orhi musha mushak ormu hishira. ");
INSERT INTO sim_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Asama asama Judama ondo hiyawu Pasovan li undari wolo Pailat oto ma ol krawuk sindari lar or halashirik indari ora. Hulaima nokopma ma or li rupshindari oton li kamaha Pailatin li mbashirik or halashirik indari ora. ");
INSERT INTO sim_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oro wolok ma kava lar, hi orhi Barabas, krawuk liri ria. ");
INSERT INTO sim_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Hako Pailat angop or heyeri sir, Judama ondo Jisasin li wapkava hishiri osik orin kotik li eweri ri. Karem uri osik ma ol akasumbu orhik tirsari ma ondon ormu silira, �Lawen a halakwak ji hishindu? Barabasin mo Jisas or Krais karem li ushanda ma oton?� ");
INSERT INTO sim_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Urik Pailat kawu os or lihi kotin or misindari kawu orok or lirik nokove orhi simu mainhara, �Avak nirik ma oton a sukwaheyehe sunguwavu anhi nga osmu nomok nawa. Or worna ma mende ri. Mir avak orin mberem uwa hala.� ");
INSERT INTO sim_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hako bikpris nga Judama lida lihi nga hulaima nokopman li mbaskashirik Pailatin li mbanak Barabasin or halaha Jisasin or mandingormekmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Urik indik ormu silira, �Lawe menden a halashinak or iku, Barabasin mo Jisasin?� Urik limu mbara, �Barabasin halanak or ika.� ");
INSERT INTO sim_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Urik ormu silira, �Wa mberem avai uku, Jisas or Krais karem li ushanda ma oton?� Urik limu ushambara, �Oton miandok tirika.� ");
INSERT INTO sim_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Urik ormu silira, �Mberem ushiwak? Mbele mende os or uwak kavak nawak ji heyew?� Hako wasilaka mendek limu ushambara, �Oton miandok tirika.� ");
INSERT INTO sim_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Urik Pailat or heyeri mbeek orhi mashin li misikurik nari ambu lir. Uhu awun li ukmbaha limu ura. Erem li urik or heyehe ukun or tarmu ewehe tava orhin or yokoho ormu mbara, �Ma otohi fi kas mbeek anhik nakwa ambu sir. Oso jihikop nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Urik limu mbara, �Halanak musa oso nihikop si nanak kumak jikisi nihi lihikop si naka.� ");
INSERT INTO sim_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Urik Pailat Barabasin or halashirik ormu ira. Uhu or mbashirik Jisasin li wakoroho orin miandok li tirikmbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Awun undari ma ondo Jisasin li laha gavmanhi akak limu laha ira. Uhu li mbashirik ma ol lir nga nakrem awun li undari ma ondo orok limu layi tirsara. ");
INSERT INTO sim_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Uhu kowe orhin li tloloho kounalo las orin limu faleshira. ");
INSERT INTO sim_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Uhu kuvu lame ngashi las li laha malakama falendari hat hom li yantlehe masiji orhik limu haufalera. Uhu kombe las tapmama orhik li harik ormu tolora. Uhu kumbambongo lihin li huvuhu li okolehe limu mbara, �Awasayi, mir Judama King lihi mira.� ");
INSERT INTO sim_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Uhu orin li suntlayashihi kombe os li hari oson li laha orin masijik limu jira. ");
INSERT INTO sim_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Erem li mbaha ihi am li krehe kounalo oson li tloloho kowe orhin indiyok limu faleshira. Uhu miandok li tirikuri mishi orok orin limu laha ira. ");
INSERT INTO sim_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Am li ihi nombo nindik ma lar yanga Sairinik fehen limu heyera. Hi orhi Saimon. Orin li toltangrihi li mbashirik miando Jisashin ormu kishara. ");
INSERT INTO sim_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Or kishaha yanga Golgotak limu ira. Hi Golgota oso maintontlo sihi, Telemba masik havamba hom nanda, karem li ushandari sir. ");
INSERT INTO sim_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Urik wain uku kas marasin nga li tirsandarin Jisasin li harik or aheyehe mbeek uksem ari ambu ri. ");
INSERT INTO sim_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Urik orin miandok li tirishihi kowe orhin li lakmbaha lihi ambek satuk limu ewera. ");
INSERT INTO sim_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Uhu orok li lihi orin limu washilira. ");
INSERT INTO sim_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uhu maintontlo os orin li mandingormerin jekambak li kayehe jekamba oson masiknuku heyek li eweri sir. Mashi oso karem, �King Judamahi toria.� ");
INSERT INTO sim_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Os or wari mishik ma kava frijip er nga li tirishirik wari vria, lar tapmama yok, lar tava ashi yok. ");
INSERT INTO sim_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Urik ma musha orok li tere i tere raha masijikop li senjelenjehe orin li okolehe limu mbara, ");
INSERT INTO sim_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","�Mir tempel akan mi tarvlashihi niri frijipkop indik undahik mbari om te! Unda osik mir mihinjik jelyaka. Os Avui Wasilakahi jikisik mi na nahi, miando oson halaha rakaka.� ");
INSERT INTO sim_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Urik bikpris nga mashi Moseshin sawendari ma nga Judama lida lihi nga orin li okolehe limu mbara, ");
INSERT INTO sim_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","�Ma anandin jelyandari ri. Hako orhinjik wahau. Os nir Israelik fehenda King nihik or na nahi, wa miando oson or halaha or takanak ni heyehe orin wavu nihik ni eweka. ");
INSERT INTO sim_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Or orhinjik, �Jikisi Avui Wasilakahi� karem mbari ria. Or hishiwa Avui Wasilaka or nga siwa ri. Os erem si na nahi, halanak orin or jelyaka.� ");
INSERT INTO sim_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Urik ma op er nga li tirishiri ovro os lir mbari hom frimu mbara. ");
INSERT INTO sim_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ta am komek or sirik kolok si krinyaha simbalesik misambin er simu tangna arangorakora. Si naha ihi homi avi li mbari wolok indik simu harara. ");
INSERT INTO sim_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Urik Jisas wasilakak or ushaha ormu mbara, �Eli, Eli, lama sabaktani.� Maintontlo os or mbari karem, �Avui anhi, avui anhi mberem ushiwak anin mi halanduwa?� ");
INSERT INTO sim_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Urik ma ol pasir siri ondo mashi oson li misihi limu mbara, �Ji misi, or Elaijan ushandu.� ");
INSERT INTO sim_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Urik ma lar or shirinya ihi mbele las warsuvu hom nandarin wain ukuk or halfaleshihi kombek or ishihi Jisasin or hanak or uksem akmbaha ormu ura. ");
INSERT INTO sim_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Urik lal olmu mbara, �Awarsi ni siheyehen, las avak Elaija raha orin or jelyanda ngashi.� ");
INSERT INTO sim_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Urik Jisas indik wasilakak or ushaha masikome orhin or halaha ormu hara. ");
INSERT INTO sim_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Or harik kolok kouwarmba os tempel akak li fengfakashirik wahandari oso nindi nindi hom er simu frehe larakara. Urik nenawu si jirik misambi mu mblira. ");
INSERT INTO sim_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Urik mawa li sutlarik Avui Wasilakan hishiowehe mas hahandari ma lal olmu usahara. ");
INSERT INTO sim_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Li usahaha mawan li halaha Jisas indik or usahari wolok Jerusalemik limu ira. Urik ma musha olmu orok lirin heyera. ");
INSERT INTO sim_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Urik kepten nga awun undari ma ol Jisasin washiliri ma ondo nga nenawu si jirik mbele mbele ondo ralarik li heyehe li ajehe limu mbara, �Omendinga sira, ma oto jikisi indingo Avui Wasilakahi ria.� ");
INSERT INTO sim_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nokove mushak homek siri lir. Nokove ondo Galilin li halaha Jisasin li tiya ihi orin jelyandari lira. ");
INSERT INTO sim_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lihi nindik siri las Maria yanga Makdalak fehe sir, las Maria nijava Jems fre Josephi sir, las nijava Sebedihi jikisi ovrohi sir. ");
INSERT INTO sim_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Am si homirik yanga Arimateak fehe ma lar, hi orhi Josep, or mbele mbele musha ngashi ma ria, or er nga Jisasin tiyandari ma lar oria. ");
INSERT INTO sim_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Or ihi Pailatin or silinak maninimba Jisashin or mbashinak or laharakmbahan. Or silirik Pailat ol awun undari ma orhin or mbashirik Jisashi maninimban li laha Josephi tavak limu hara. ");
INSERT INTO sim_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Urik or laha kouavisha lasik ormu hevera. ");
INSERT INTO sim_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Uhu sunja aka akri las ornjik li tlohondari orok or ewekurik ormu laha ira. Or layi eweshihi sunja laka os mawan arangokurin or temberik simu ra arangora. Erem or ulafakaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Urik Maria yanga Makdalak fehenda nga Maria ome las nga mawa mashik fri sihi mbele mbele os or urin frimu sishi heyera. ");
INSERT INTO sim_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ushirik li wahandaha hiyawu oson li hundujeri wolo oso mendek si narik bikpris nga Farisi nga Pailatin limu i heyera. ");
INSERT INTO sim_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Uhu limu mbara, �Awasayi, ma oto karem mbari ri, �An niri frijip mawak a wakwa nira. Uhu indiyok a usahakwa nira.� ");
INSERT INTO sim_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Karem or mbahandari osik mir avak mbashinak mawa orhin armek niri frijip li washilika. Las avak orin tiyanda ma li ihi maninimba orhin mayam li laha ihi li mba, �Angop mawan or halaha indik usahawa ri.� Os erem si na nahi, haimba handambanda mashi akri lihi oso wasilakak si naha mashi os mas li mbahandan tikrikwa sir.� ");
INSERT INTO sim_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Karem li mbarik ormu mbara, �Ji ihi awun unda ma lal ji laha os ji ukmbaha hishiwa hom ji uka.� ");
INSERT INTO sim_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Karem or mbarik li ihi mawa oson limu seve watla ura. Uhu awun undari ma ondon li mbashirik mawan limu washilira. ");
INSERT INTO sim_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Am Sande nirsumbuk si narik Maria yanga Makdalak fehe nga Maria ome las nga mawan fri heyekurik frimu ira. ");
INSERT INTO sim_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Urik kolok nenawu wasilaka mendek si jirik ensel Avui Wasilakahi lar hevenin or halaha or takaha sunja laka os wan li arangondarin or tembe lafakaha sunja heye orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Fuma orhi lervlanda hom nari sir. Uhu kowe orhi avisha indingak nari sir. ");
INSERT INTO sim_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Awun undari ma ondo orin li heyehe li lishnyaha os ma haha li wandari hom misambik limu takawara. ");
INSERT INTO sim_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hako ensel oto nokove ovron ormu sawera, �Shi ajewa hala. Angop a heyewa shir, shir Jisas or miandok li tiriri oton heyekmbaha rawa shir. ");
INSERT INTO sim_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hako mbeek torok wawa ambu ri. Angop usahawa ri, os mas or sawehendari hom. Shihinjik torok shi ra heyeka, os li eweri mishin. ");
INSERT INTO sim_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Uhu kolok shi ihi os or usahawa mashi oson ol orin tiyanda man shi sawenak li misika. Or angop masmas Galilik iwa ri. Avak orok ji ihi orin ji heyekwa ri. Mashi kaso nom a sawekwak a rawa nir.� ");
INSERT INTO sim_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Karem or mbarik fri misihi frimu ajera. Hako sunguwavu frihi nga fri rupshihi kolok mawan fri halaha shirinymbar ol orin tiyandari man fri sawekurik frimu ira. ");
INSERT INTO sim_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Fri irik Jisas nombo nindik fririn or heyehe ormu mbara, �Apmanuwa.� Karem or mbarik kumbamu orhik fri taka lihi frimu rupshira. ");
INSERT INTO sim_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Urik ormu mbara, �Shi ajewa hala. Shi ihi anhi ma ondon shi sawenak avak Galilik li ihi anin orok li heyekwa nir.� ");
INSERT INTO sim_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Urik nokove ovro fri ishirik awun undari ma ol mawan washiliri ondo bikprisin heyekurik Jerusalemik limu ira. Uhu mbele mbele os orok talarin limu sawera. ");
INSERT INTO sim_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Urik li misihi Judama lida lihin li mbarik li talandirsaha limu anaoweheyera. Uhu ol awun undari ma ondon ya mushak li haha ");
INSERT INTO sim_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","limu mbara, �Karem ji haimba handambaka, �Nir ni suknyashiwa hom ol orin tiyanda ma nirik li taha mayam maninimba orhin laha iwa lir.� ");
INSERT INTO sim_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hako os Pailat jirin or ngria nahi, avak ni raha jir nga ni sihi ni sawenak mashi nihin misikwa ri. Karem uwosik ji ajewa hala, men os ni mbawa hom ji mbaka. ");
INSERT INTO sim_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Karem li mbarik awun undari ma ya oson li laha os li mbari nombo hom limu ura. Urik Judama ondo os li haimba handambari mashi oson limu misira. Uhunda mashi oso er si raha ter nga Judama karem mbanda lir, Jisas mbeek usahari ambu ri, maninimba orhi men li loho laha iri ri. ");
INSERT INTO sim_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisasin tiyandari ma 11-pela ondo Galilik li ihi telemba os or mbari mishi orok limu lawura. ");
INSERT INTO sim_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Li lawuhu orok orin li heyehe orin limu hausimbausira. Hako lal wavu frijip frijip hishiri lir. ");
INSERT INTO sim_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Urik or taha pasir or sihi ormu mbara, �Kwambu os misambi nga lersuwu nga toltangrinda Avui Wasilaka angop anin or hawa sir. ");
INSERT INTO sim_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Erem nawa osik jir avak yanga yangak ji ihi mashi anhin ji sawenak ma amber anin tiyanda mak li naka. Unak lirin fak ji tolofaleka, hi Avui anhik, hi Jikisi orhik, hi Masikome orhik, karem ji mbaha lirin fak ji tolofaleka. ");
INSERT INTO sim_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Uhu mashi os a sawewan armek ji ewesawenak li misihi li tiyarakoka. Omendingak jirin amu sawenduwa, an mbeek jirin a halakwa ambu nir. An jir nga nakrem er ni lihi ihi mbele mbele amber mendek nakwa sir.� Unda kasira. Ambehoma. ");
INSERT INTO sim_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais Avui Wasilakahi Jikisi indingo oria. Mashi jivi orhi os hulaima nokopman or jivinahanda oson os amu kayenduwa. ");
INSERT INTO sim_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mas wolokop profet Aisaia mashi os Avui Wasilaka mbahandarin karem or kayeri sir. �Avak a mbashinak ma lar mashi anhin maifuk laha sawe ikwa ria. Uhu nombo mihin hundujekwa ria.� ");
INSERT INTO sim_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","�Ma ngashi mishi ambu orok ma lar mu ushambara karem, �Wasilakahi nombon ji hundujeka. Uhu nombo oson ji unak wornak si naka.� � ");
INSERT INTO sim_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mashi os profet Aisaia or saweri oso omendingak nari sir. Urik Jon hulaima nokopman fak tolofalendari ma oto or taha misamtelmbamba orok ormu mashin sawera, �Ji misi, sunguwavu jihin ji tormblehehe kavakava os ji undan ji halaha ji mbanak jirin fak a tolofalekwa nir. Unak Avui Wasilaka avak kavakava jihin or laha ormbeka.� ");
INSERT INTO sim_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Urik ma amber provins Judiak fehenda nga Jerusalemik fehenda nga Jonik li raha kavakava os li undarin kormbak li sawerik fa Jordanik lirin ormu tolofalera. ");
INSERT INTO sim_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kowe os or falendari oso kamel kukwak li undari sir. Uhu kufulombok or ishitangrindari sir. Uhu akwa orhi os or andari oso intlavi nga hani nga andari ria. ");
INSERT INTO sim_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Uhu karem ormu mbara, �Ma lar avak anhi kumayok takwa ria. Hako kwambu orhi kwambu anhin tikrinda sir. An mbeek kumbambongon na huvuhu kuvu os kumba ari orhi orok nawan a sorngondahi ambu nir, wahau. Or kwambu orhi wasilaka mendek naha kwambu anhin tikrinda sira. ");
INSERT INTO sim_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An jirin men fambak a tolofalenda nir. Hako ma orto avak Masikome Avui Wasilakahin jirin hakwa ria.� ");
INSERT INTO sim_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oro wolok Jisas kuyanga Nasaret os provins Galilik nandarin or halaha fa Jordanik Jon man or fak tolofalendari mishi orok or tarik Jon mu orin fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas os fasik or layirin or halaha or usasihi or heyerik kolok lersuwu simu sutlara. Urik Masikome Avui Wasilakahi apmuma hom Jisasik ormu rakara. ");
INSERT INTO sim_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Urik mashi las lersuwu yok simu mbara, �Ma toto jikisi indingo anhi ria. Sunguwavu anhi mende nga orin a rupshihi mbele mbele ol or uwan amu rupshinduwa.� ");
INSERT INTO sim_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Urik Masikome Avui Wasilakahi Jisasin or laha irik or ihi misamtelmbamba orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Niri os orok or liri 40-pelak nari lira. Urik Laulaka or taha Jisas kavakavan or ukmbaha ormu oweioweiheyera. Hako or mbeek or mbari hom uri ambu ri. Uhu fle avi sembengalak fehenda ondo nga ormu lira. Urik ensel ondo li taha orin limu jelyara. ");
INSERT INTO sim_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","King Herot Jonin krawuk or eweshirik Jisas provins Galilik or taha mashi Avui Wasilakahin ormu karem sawera, ");
INSERT INTO sim_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","�Mas li mbahandari oso ter osmu omendingak nanduwa. Avui Wasilaka os jirin or arangoshinak jip ji likwa oso am si talakwak osmu nanduwa. Karem uwosik kavakava os ji undan ji halaha sunguwavu jihin ji tormblehe mashi orhin ji misihi toltambanaha ji sika.� ");
INSERT INTO sim_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Karem or mbashihi leuku Galilik or ihi ma frijip ormu heyera. Ma ovro mahasanje vria, hi frihi Saimon fre Andru. Frir foomen londari ma vria. Jisas or ihi or heyeri, frir foom kowen fri laha foomen kruwukurik frimu ormbera. ");
INSERT INTO sim_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Urik fririn ormu mbara, �Shi ra! Anin shi tiyanak nombo os hulaima nokopman landa nombon a mukunak shi heye.� ");
INSERT INTO sim_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Karem or mbarik kolok lerawu frihin fri halaha Jisasin frimu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hovok kandakar nga or ihi ma frijip ormu heyera. Ma ovro mahasanje vria, hi frihi Jems fre Jon, Sebedihi jikisi vria. Frir bot akomek fri lihi foom kowe os korori oson frimu indik nara. ");
INSERT INTO sim_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Urik Jisas orin fri tiyaha fri ikmbaha ormu ushara. Urik kolok avoko frihi nga ol avoko frihinjik lerawun landari ma ondo nga bot akomek fri halaha Jisasin frimu tiya ira. ");
INSERT INTO sim_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas nga ma ol orin tiyandari ondo nga yanga Kaperneamik li taha orok limu wara. Urik am Sabat wolok si narik Jisas Judama lotu undari akak or ihi mashi Avui Wasilakahin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mashin or sawerik li misihi wavu lihi musha mushak limu hishira. Or mbeek ma ol mashi Moseshin sawendari ondo hom saweri ambu ri, wahau. Or malakama hom kwambu nga saweri ria. ");
INSERT INTO sim_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Urik wasimalengamba tolondari ma lar lotu undari aka orok or taha Jisasin or heyehe ormu ushambara, ");
INSERT INTO sim_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","�Jisas, yanga Nasaretik fehenda mirin, mir mberem mi ukmbaha mi raw? Wa, nirin mi unak kavak ni nakmbaha tawa om? Mir ma jivi Avui Wasilakahik tahandak a heyewa mir te.� ");
INSERT INTO sim_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Karem or mbarik Jisas wasimalengamba orton mainkwambuk ormu mbara, �Mir maimbawa hala! Kolok ma oton halaha tala ika!� ");
INSERT INTO sim_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Karem or mbarik wasimalengamba orto ma oton or urik or kwarnguarnarik wasilaka mendek or tashihi ma oton or halaha ormu tala ira. ");
INSERT INTO sim_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Urik ma ol orok liri ondo oson li heyehe li lishnyafaha lihi ambek limu mbara, �Mberemhi tos ter nandua? Ma roto Avui Wasilakahi mashin kwambu nga or sawewak ni misiw te. Uhu wasimalengamba roton or mbawak ma roton or halaha or tulu iwa re.� ");
INSERT INTO sim_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Karem li mbaha mbele mbele Jisas urik li heyeri ondon limu haisau handasawe ira. Urik mashi oso simbalesik provins Galilik si irik ma amber limu mistakora. ");
INSERT INTO sim_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Urik Jisas nga ma ol orin tiyandari ma ondo nga Judama lotu undari aka oson li halaha Andru fre Saimonhi akak limu ira. Urik Jems fre Jon er nga frimu ira. ");
INSERT INTO sim_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Akak li irik ma lal Jisasin limu sawera, �Saimon arjava orhi kavamisihi maome sihi hikop lawuwak os akak wandua.� ");
INSERT INTO sim_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Karem li sawerik Jisas or ihi tava sihin or tolorik jivik si naha si usaha lirnjik akwan simu ura. ");
INSERT INTO sim_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Am si homirik ta nor layirik kuyanga orok fehendari ma amber hom akayanga sumbu Saimon fre Andruhi aka os Jisas liri mishi orok limu talandirsara. Uhu ma ol kavamisindari nga wasimalengamba tolondari nga Jisasik limu laharara. ");
INSERT INTO sim_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Urik or mbarik jivik limu nara. Uhu wasimalengamba ol ma ondon tolondari ondon or mbarik limu tulu ira. Wasimalengamba ondo angop li heyeri ri, Jisas Avui Wasilakahi jikisi indingo oria. Karem urik or mbashirik mbeek maimbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nirsumbu mendek Jisas aka os or wari oson or halaha Avui orhin or sawekurik ma ngashi mishi ambu orok ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Am si hararik Saimon nga ma lal nga Jisasin limu lasa ira. ");
INSERT INTO sim_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Am li lasa ihi li heyehe limu mbara, �Ma amber hom olmu mirin lasanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Urik ormu mbara, �Ka ni i yanga oson ni halaha yanga anandik ni ika. An mbeek torokop Avuihi mashin a sawekurik a rari ambu nir, wahau. Kuyanga ome lal nga Avuihi mashin a sawekurik a rari nira.� ");
INSERT INTO sim_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Karem or sawe lafakaha provins Galilik or ihi Judama lotu undari akak or layihi mashi os Avui Wasilaka lirin or arangoshinak jip li likuri mashi oson or sawehe wasimalengamba ol man tolondari ondon ormu mbru ermbera. ");
INSERT INTO sim_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Urik ma lar okmbale lepra tolondari orto Jisasik or taha kumbambongon or huvuhu ormu mbara, �Os mi rupshi nahi, mi mbanak jivik avai naka.� ");
INSERT INTO sim_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Urik Jisas ornjik or holoho tava orhin ma ortohik or hauowehe ormu mbara, �A hishiwa mir avak jivik nakwa mira.� ");
INSERT INTO sim_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Karem or mbarik okmbale lepra mendek si narik jivik ormu nara. ");
INSERT INTO sim_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Uhu Jisas ormu mbara, �Avak pris ondon i heyehe maome mihin mukunak li heyehe li mbaka, os mi kavamisindari mihi oso angop mendek nawa sir. Uhu avak mirnjik ofan li uka, os lo Moses si mbahandari hom. Unak ma amber li heyehe li mbaka, os mi kavamisindari mihi angop mendek nari sir.� Karem or mbaha mainkwambu las ormu mbara, �Ai ai, avak mashi las ma lal sawewa hala, os mirik talawa oson.� ");
INSERT INTO sim_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hako ma orto or ihi Jisas orin or urik jivik or nari mashi oson yanga yangak or laha saweyarik ma amber mistakori lir. Erem or saweri osik Jisas mbeek kolaka ol orok nandari orok kormbak layiri ambu ria. Or misamtelmbamba orok liyari ri. Hako yanga yangak fehenda ma amber orhik tari lir. ");
INSERT INTO sim_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Niri lal am li ishirik Jisas yanga Kaperneamik indik or ihi aka lasik ormu lira. Urik ma os orok or lirin li misihi orhik limu tara. ");
INSERT INTO sim_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma musha mendek li talandirsaha akayangan li arangoshirik mbeek akayanga kar fiala hambashirik li layikurik nari ambu sir. Indik er hoje menderi sir. Urik Jisas mashin aka orok ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mashin or sawerik ma tovro kavro ma lar kumba tava nashindari orton Jisasik limu kishaha laharara. ");
INSERT INTO sim_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hako akayanga angop ma ondo er li arangorakoshirik li tirndirifuhu ma orton li kishaha akamba heye yok limu lalawura. Akamba heyeyok li lalawuhu akamasu kas li lunduhu ma orto nga ma teye os or wari oso nga kuvuk li tihi li toloho naman li halarik akaome os Jisas siri mishi orok ormu layira. ");
INSERT INTO sim_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Urik Jisas ma tovro kavro wavu os li hishihi li mbar, �Jisas ma orton avak or unak jivik nakwa ri,� karem li hishiri angop or heyeri sir. Uri osik ma oton or heyehe ormu mbara, �Jikisi anhi misi, kavakava mihi angop a laha ormbewa sir.� ");
INSERT INTO sim_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Karem or mbarik mashi Moseshin sawendari ma ol aka orok liri ondo mashi oson li misihi limu hishira, ");
INSERT INTO sim_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","�Mberem ushiwak ma roto mashi toson or mbanduwa? Wa, Avui Wasilakahi farniyik or sikwak ormu mbandu? Wahau, ma lar mbeek kavakavan laha ermbendahi ambu ri. Oso lerawu Avui Wasilakahi sir.� Karem hishiri lir. ");
INSERT INTO sim_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hako Jisas wavu os erem li hishiri oso angop or heyeri osik ormu silira, �Jir mberem ushiwak wavu jihi erem ji hishindu? ");
INSERT INTO sim_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hako mberem a undahik ji hishindu? Wa, kavakava ma roto uwan a laha ermbendahik ji hishindu mo orin a mbanak jivik or nandahik jimu hishindu? ");
INSERT INTO sim_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wa, avak a mukunak ji heyekwa sir, Ma Jikisi Avui Wasilakahi kavakava ma undan yoko ermbendahi ri.� Karem or mbaha ma orton or heyehe ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","�Mir usasihi teye mihi oson laha aka mihik ika!� ");
INSERT INTO sim_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Karem or mbarik ma orto or usaha teye orhin or laha ormu ira. Urik ma amber li heyehe limu lishnyafara. Uhu li rupshihi hi Avui Wasilakahin li hausimbausihi limu mbara, �Mas mbeek tos ter nawak ni heyewa toso himi kas narik ni heyeri ambu sir, wahau.� ");
INSERT INTO sim_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Urik Jisas indik leuku Galilik or irik ma musha mendek orok li rarik mashi Avui Wasilakahin lirin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Karem uhu or ihi aka os gavmanhi yan li owendari mishi oson or tikrihi orok lerawun landari ma oton ormu heyera. Ma oto hi orhi Livai, jikisi Alfiushi oria. Livain or heyehe ormu mbara, �Mir kolok ta anin tiya shi ika.� Karem or mbarik or usaha Jisasin or tiyaha frimu ira. ");
INSERT INTO sim_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Urik Jisas Livaihi akak ormu ira. Orok or lihi ma ol orin tiyandari ma nga takis yan landari ma nga ma ol kavakavan undari ma nga nakrem li lihi limu ara. Ol erem nandari ma ondo ermba ermbak Jisasin tiyandari lir. ");
INSERT INTO sim_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Urik mashi Moseshin sawendari ma lal Farisi, karem li ushandari ma ondo, os Jisas ma ondo nga nor arin li heyehe ol orin tiyandari man limu silira, �Mberem ushiwak ma roto tol kavakavan unda ma tondo nga or awak ni heyendu?� ");
INSERT INTO sim_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Urik Jisas mashi oson or misihi ormu mbara, �Ma ol jipmisiwa mbeek doktak inda ambu lir. Hako ma ol kavamisiwa nom doktak inda lir. An mbeek ma ol lihinjik hishihi mba, nir ma jivi, karem mbawa ma ondonjik a rari ambu nir, wahau. An ma ol kavakavan unda ondonjik a rari nir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma ol Jonin tiyandari ma nga Farisi nga akwan halandari lir. Nindi wolo lasik ma lal Jisasik li taha limu silira, �Jonin tiyandari ma nga Farisi ondo nga akwan halanda lir. Hako mberem ushiwak mirin tiyanda ma ondo erem unda ambu lir?� ");
INSERT INTO sim_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Karem li silirik Jisas sauheima las ormu sawera, �Mberem ji hishindu? Os ma lar or nokoplaha hiyawu wasilakan or uwa wolo orhi ma ondo akwan anda ol mo wahau? Akwan anda ol te! Akwan li aha or nga nakrem rupshinda lir. ");
INSERT INTO sim_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kumak ma oton li tolo laha ishinakop akwan halakwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Uhu sauheima las nga ormu sawera, �Os ma lar kowe orhi si frehe nahi, mbeek koutakri akri las or laha koushimbla oson or ewetlavandahi ambu sir. Mberem ushiwak? Erem or u nahi, kowe oson or yokowa wolo koutakri akri oso avak si ramushihi awarikandak nakwa osa. Uhu koushimbla oson si unak wasilaka mendek frehekwa sir. ");
INSERT INTO sim_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Uhunda hom ma lar mbeek wain uku akrin or laha memesishi masi orok ngorondahi ambu ri. Os erem or u nahi, wain uku oso avak si kishalarasanak memesishi masi oso avak numbufaakwa osa. Ushinak wain uku avak misambik ngorokwa osa. Karem nanda osik wain uku akrin memesishi akrik li ngoroshinak wain uku nga memesishi nga avak jivikop fri naka.� ");
INSERT INTO sim_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Urik Sabat wolok si narik Jisas nga ol orin tiyandari ma nga nombo os wit nowe nindik limu ira. Li ihi ol orin tiyandari ma ondo wit sijin li tolntlehe li aha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Urik Farisi lal li heyehe limu mbara, �Ayo, mberem ushiwak mirin tiyanda ma ondo os lo si pantlehendan Sabat wolok li undu?� ");
INSERT INTO sim_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Karem li mbarik ormu mbara, �Os king Devit nga orhi ma nga li erenghari wolok or uhundari mashi jekambak li kayehendari oson hishinda ambu oj? Os Abiatar hetprisik or nari wolok Avui Wasilakahi akak or layihi bret ol ofan li undari bret ondon or laha ol orin tiyandari ma nga li arin. Bret ondo pris nom li andari lir, ma anandi wahau.� ");
INSERT INTO sim_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Uhu mashi las nga ormu mbara, �Mberem ushirik Avui Wasilaka Sabat wolo oson or har? Sabat oso mbeek man si mba, �Karem u, karem uwa hala.� Karem si mbakmbaha or hari ambu sir. Sabat oso men ma li limasihi li wandakmbaha or mbahandari sir. ");
INSERT INTO sim_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hako Ma Jikisi Avui Wasilakahi oto Sabatin er nga arangonda ri.� ");
INSERT INTO sim_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas Judama lotu undari akak or layihi ma lar tava kavak nandari oto orok or lirik ormu heyera. ");
INSERT INTO sim_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Urik ma ol aka orok liri ondo Jisasin olmu sishi heyera, os ma oton Sabat wolok or mbanak jivik or na nahi, orin li kotim ukmbahan. ");
INSERT INTO sim_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Urik Jisas ma tava kavak nandari oton ormu mbara, �Mir usasi.� Urik ormu usasira. ");
INSERT INTO sim_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Urik Jisas ma ol aka orok liri ondon or heyehe ormu silira, �Sabat wolok lerawu jivin ni landa on mo, lerawu kavan ni landa on? Mashi Moseshi mberem sivai mbandu? Man ni jelyawa os mo man ni mandingormewa os?� Karem or silirik lir mbeek mashi las nga mbari ambu lir, wahau, mayam siri lir. ");
INSERT INTO sim_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas or heyeri ma ondo mbeek ma otonjik holori ambu lir. Uri osik wavu orhi kavak si narik ma otonjik or holoho ormu mbara, �Tava mihin sanguananak a heye.� Karem or mbarik tava orhin or sanguanarik jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Urik Farisi ondo erem or uri oson li heyehe kolomalok os li lotu undari aka oson li halaha li ihi ma ol king Herot nga nakrem lerawun landari ma ondon heyekurik limu ira. Li ihi nombo nombo os Jisasin li mandingormekuri mashin limu anasawera. ");
INSERT INTO sim_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas nga ma ol orin tiyandari ondo nga kuyanga oson li halaha leuku Galilik limu ira. Orok li irik ma musha mendek orhik limu tara. ");
INSERT INTO sim_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ma ol provins Galilik fehenda nga, Judiak fehenda nga, Jerusalemik fehenda nga, Idumeak fehenda nga, fa Jordanin mbuhu kauyok nanda yanga Tairik fehenda nga, Saidonik fehenda nga, mashi os Jisas lerawun or landarin li misihi orhik limu tara. ");
INSERT INTO sim_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Li taha orin limu rurawura. Urik nindik or sihi ma ol orin tiyandari ma ondon ormu mbara, �Bot las avak ji halashinak fa mambuk si sihi anin si nikishika. Ma rondo musha mendek li nawa olik avak anin li kisha ermbeku. Os erem li kisha ermbe nahi, avak bot orok a lawuhu a likwa nir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas ma ol kavamisindarin mushak or mbarik jivik li nandari osik ol kavamisindari ondo orin li toloho jivik li naku, karem mbaha li hishihi olmu orhik tara. ");
INSERT INTO sim_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Urik wasimalengamba ondo orin li heyehe kumbambongok li raka lihi limu ushambara, �Mir Jikisi indingo Avui Wasilakahi mira.� ");
INSERT INTO sim_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Karem li mbarik Jisas mainkwambu mendek hi orhin kormbak li sawekurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas telembak or lawuhu ma ol or nga yakmbaha or hishiri ma ondon ormu ushara. Unak li raha or nga li yakmbahan. ");
INSERT INTO sim_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Uhu ma 12-pela ondon ormu kamara. Uhu mashi Avui Wasilakahin li sawekmbaha or mbashirik limu ira. ");
INSERT INTO sim_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uhu kwambu orhi os wasimalengamban li mbru ermbekurin ormu lirin hara. ");
INSERT INTO sim_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ma 12-pela ondo hi lihi kalira. Lar hi orhi Saimon oria, Jisas hi yeje orhin Pitak or ushari ria. ");
INSERT INTO sim_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Uhu Sebedihi jikisi Jems nga maha orhi Jon nga. Mashin fri mbari lersuwu krulatavalanda hom mbandari vri. Karem undari osik hi frihi Boanerges karem or ushari vri. ");
INSERT INTO sim_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Uhu Andru, Filip, Bartolomyu, Matyu, Tomas, Jems jikisi Alfiushi, Tadius, Saimon kraha Selotik fehendari ria. ");
INSERT INTO sim_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Uhu lar Judas Iskariot oria. Judas oto kumak Jisasin laha ma kavahi tavarenjek hakuri ma ria. ");
INSERT INTO sim_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas aka os or liri orok indiyok or irik ma musha mendek orhik limu rara. Urik or nga orin tiyandari ma ondo nga mbeek akwan li akuri wolo kas nga nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Urik jimatama orhi mashi oson li misihi orin yangak li laha ikurik limu rara. Li raha orin li heyehe limu mbara, �Ayo, ma roto angop ambasiwa tori te.� ");
INSERT INTO sim_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Urik mashi Moseshin sawendari ma ol Jerusalemin halarari ma ondo Jisasin li heyehe limu mbara, �Toto Belsebul tolowa toria. Kwambu Belsebulhik wasimalengamban mbru ermbenda ri. Laulaka mu jelyashiwak lerawu oson ormu landuwa.� ");
INSERT INTO sim_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas mashi oson or misihi lirin or usharik li raha pasir limu sira. Urik ormu silira, �Mberem ji hishindu, Belsebul am orhi ma ondon or mbru ermbendahi ol? Wahau.� ");
INSERT INTO sim_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uhu sauheima las nga ormu mbara, �Os kraha lal lihi ambek li anamandingorme nahi, kraha anandi las li taha avak misambi lihin lakwa lir. ");
INSERT INTO sim_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uhu os mahasanje lihi ambek li anaji nahi, lihi ambek anakorokwa lir. ");
INSERT INTO sim_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Belsebul oto erem, os lerawu orhin landa ma ondo nga or anaji nahi, avak li anakoroho mendek nakwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Karem uhu mashi las nga ormu mbara, �Ji hishika, ma or kwambu ngashi os mbele mbele orhin ji lakwak ji hishi nahi, mberem jivai uku? Wa masmas kumba tava orhin kuvuk ji ishishinak or wanakop mbele mbele orhin lakwa jira.� ");
INSERT INTO sim_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Uhu ormu mbara, �Jirin amu sawenduwa, mbele mbele kavakava ma li unda nga okolenda mashin li mbanda nga Avui Wasilaka or laha ermbekwa lir. ");
INSERT INTO sim_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Hako os Masikome orhin li okole nahi, kavakava os li unda oso mbeek or laha ermbekwa ambu sir, wahau. Kavakava oso er nakwa sir. Ter nga kumak nga ermba ermbak er nakwa sir. Mbeek mendek nakwa ambu sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma ondo li mbari, �Jisas oto mbele mbelen or unda kwambu Belsebulhi nga unda ria.� Karem orin li mbarik mainkwambu oson lirin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Urik Jisas nijava orhi nga jimatama orhi nga limu tara. Li taha hikrik li sihi Jisas or ta lirin heyekmbaha limu mainhara. ");
INSERT INTO sim_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jisas akomek or lirik ma musha mendek orin limu ralayantlera. Urik ma lar orin ormu sawera, �Mai, nijava mihi nga jimatama mihi nga hikrik li sihi mirin heyekwak mbanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Urik ormu mbara, �Lawe nijava anhi sir? Lawe jimatama anhi lir?� ");
INSERT INTO sim_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Uhu ma ol orok siri ondon or heyehe ormu mbara, �Nijava anhi nga jimatama anhi nga tolira. ");
INSERT INTO sim_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ma ol mashi Avui Wasilakahin misindiyawa ma ondo nijava anhi jimatama anhi lira.� ");
INSERT INTO sim_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas leuku Galilik or lihi indik mashin ormu sawera. Urik ma musha mende orhik li raha orin limu rurawura. Ushirik botik or lawu lihi mashin or sawerik ma ondo fa mambuk limu sira. ");
INSERT INTO sim_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Uhu mashi mushak sauheimakop ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Uhu ormu mbara, �Mashi kason ji misi. Ma lar ormu wit sijin nowek laha faka ira. ");
INSERT INTO sim_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Or laha faka irik lal nombok li rakarik avi olmu ra nongoho ara. ");
INSERT INTO sim_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hovok lal misambi os sunja hongondari mishi orok rakari lir. Uhu lewas tungua rasari ol te. Hako misambi mbeek misam jeromek nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sunja hongondari osik mbeek nene layiri ambu sir. Uri osik ta jiri wolo olmu hatlayirakora. ");
INSERT INTO sim_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Urik hovok lal olmu minja lame nindik rakara. Li rakaha tungua rasari ol te. Hako minja lame er nga li rasaha li mushi arangoshirik mbeek akwa ome nga wari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hovok lal olmu misambi jivindingak takara. Li tungua rasaha akwa ome musha mendek olmu wara, lal 30-k, lal 60-k lal 100-ik, karem nari lira.� ");
INSERT INTO sim_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uhu ormu mbara. �Ma ol mambla ngashi halanak mashi kason li misika!� ");
INSERT INTO sim_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Urik ma am li ishirik ol orin tiyandari 12-pela ondo nga ma lal er nga li lihi Jisasin limu silira, maintontlo os sauheimak or mbarin. ");
INSERT INTO sim_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Urik ormu mbara, �Avui Wasilaka nombo os hulaima nokopman or arangokmbaha nor mbahandari, os mas wanyiwandari oson angop or mukurik ji heyeri sir. Hako ma anandi ondo sauheimakop a sawewak misinda lir. ");
INSERT INTO sim_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Profet Aisaia mas wolokop karem or kayeri sir, �Ma ondo hindi mushak mashin misikwa lir. Hako mbeek li hishiyarikwa ambu lir. Hindi mushak heyekwa lir. Hako mbeek heyeyarikwa ambu lir. Karem uwosik lir mbeek sunguwavu lihin li tormblehe Avui Wasilakahik li ranak or unak jivik nakwa ambu lir.� � ");
INSERT INTO sim_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Urik Jisas ormu silira, �Jir mberem ushiwak mashi tos sauheimak a sawewan ji hishiyarinda ambu? Os mashi tos a sawewa toson ji hishiyarina ambu nahi, jir mbeek sauheima anandi ol jirin a sawekmbaha a hishiwa ondo er nga hishiyarikwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wa, mashi oso maintontlo sihi karem, wit siji ondo mashi Avui Wasilakahin olmu heimanduwa. ");
INSERT INTO sim_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma lal sunguwavu lihi misambi os li eseyashiwak kwambujinda hom nanda lir. Mashin misinda ol te. Hako Laulaka or taha kolomalok mashi os Avui Wasilaka sungu lihik or halashiwak nanda oson laha ormbenda ri. ");
INSERT INTO sim_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hovok ma lal sunguwavu lihi misambi sunja hongonda hom nanda lir. Mashin misikmbaha rupshinda ol te. ");
INSERT INTO sim_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hako mbeek nambek kwambuk sinda ambu lir. Os hulaima nokopma lirin li okolehe kavakavak li uwa wolo kolok mashi os li misindan halanda lir. ");
INSERT INTO sim_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hovok ma lal sunguwavu lihi misambi minja lame ngashi hom nanda lir. ");
INSERT INTO sim_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mashin misinda ol te. Hako wavu lihi musha mendek ya, akwa, mbele mbele misambi torok fehendanjik hishinda lir. Mbele mbele ol li hishinda ondo olmu mashi Avui Wasilakahi os lihik nawan mushi arangoshiwak mbeek akwa ome nga wanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hovok ma lal sunguwavu lihi misambi jerome ngashi hom nanda lir. Mashin li misihi toltangrihi akwa ome jivi nga wanda lir. Lal akwa ome 30-k, lal 60-k, lal 100-ik wanda lira,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas ol orin tiyandari ma ondon ormu silira, �Lamin ji ukruwa wolo mberem ji undu? Shovok tangri arangonda oj mo, kau siyok halowenda oj? Wahau, lamin ji ukruhu metenjek ji sinjishiwak si harawak ma heyenda lir. ");
INSERT INTO sim_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Uhunda hom mbele mbele tos ter wolok wanyiwanda ondo nga mbele mbele ma mayam li wanyi unda ondo nga kumak kormbak li talanak ni heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ma ol mambla ngashi halanak mashi kason li misika!� ");
INSERT INTO sim_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Karem or mbashihi mashi lal nga ormu sawera, �Mashi os ji misiwan armek ji misihi ji tiyaka. Mberem ushiwak? Mbele mbele ol ma uwak ji heyembanda hom Avui Wasilaka erem heyembakwa jira. Uhu or heyembaha kandakar nga or hakwa jira. ");
INSERT INTO sim_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma ol mashi orhin armek misindiyawa ma ondo avak or halashinak hishiyarinda lihi oso avak wasilakak nakwa sir. Hako ma ol mashi orhin men mamblakop misiwa ondo avak mashi os li misiwa oson or lashinak men likwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Uhu ormu mbara, �Avui Wasilaka jirin or arangoshinak ji likwa oso mberem si nandu? Wa, avak a sawenak ji misikwa sir.� Uhu sauheimakop karem ormu mbara, �Ma lar akwa sijin or laha fakayari ri. ");
INSERT INTO sim_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Am or fakarakoshihi or halaha yanga orhik ormu ira. Tandi wolo lerawun landa ri. Niri wolo men wa suknyanda ri. Ushiwak siji ondo lihinjik li tunguaha wasilakak nanda lir. ");
INSERT INTO sim_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Misambi sihinjik si urik akwa siji ondo li tungua rasaha li lawuhu se nga li naha olmu akwa ome nga nara. ");
INSERT INTO sim_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uhu akwa ome am li hisharik ma orto andule orhin or laharaha akwa ondon ormu lara.� ");
INSERT INTO sim_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Uhu sauheima las nga ormu sawera, �Avui Wasilaka jirin or arangoshinak jip ji likwa oso mberem si nandu? ");
INSERT INTO sim_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wa, oso mastet siji hom nanda sir. Mastet siji oso awarikandak nanda sir. ");
INSERT INTO sim_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hako li sishiwak lewas si tungua rasaha mi hom wasilakak nanda sira. Ushiwak avi li taha mi tava orok aviwusin li uhu linda lir.� ");
INSERT INTO sim_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas mashi mushak sauheimakop or saweri hulaima nokopma os li hishihi li yarikuri ambek or saweri sir. ");
INSERT INTO sim_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma ondo sauheimakop or saweri lir. Hako ol orin tiyandari ma ondo or nga li liri wolo mashi os or saweri oso maintontlo sihin kormbak or sawerik misindari lir. ");
INSERT INTO sim_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Am si homirik Jisas ol orin tiyandari ma ondon ormu mbara, �Ka ni i fan mbuhu kauyok ni ika!� ");
INSERT INTO sim_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Urik ma ondon orok li halaha botik li lawuhu limu ira. Hako bot ome anandi lal er nga iri lir. ");
INSERT INTO sim_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Li irik suwa lakak si rasarik uku si lawuhu andoho botik si layhi bot orok simu hojekurik ura. ");
INSERT INTO sim_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Urik Jisas bot sumbu yok kaumasikruva sihi ormu suknyara. Or suknyarik ma ol orin tiyandari ondo er li ajehe orin li lembasihi limu mbara, �Tisa, avak ni uk aha ni hakwa nir te!� ");
INSERT INTO sim_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Karem li mbarik Jisas or usaha suwa nga fa nga ormu huliyik mbara, �Ambe er hala mende!� Karem or mbarik suwa mendek si narik fa oso nga osmu haha wara. ");
INSERT INTO sim_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ushihi ol orin tiyandari ma ondon ormu silira, �Mberem ushiwak ji ajenduwa? Anin ji hishiowenda nombo mbeek si iw?� ");
INSERT INTO sim_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Karem or mbarik amba amba li ajehe lihi ambek limu mbara, �Ayo, ma roto lawe mende toria? Or mbawak suwa nga fa nga mashi orhin fri misihi mendek fri nawan te.� ");
INSERT INTO sim_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Urik Jisas nga ma ol orin tiyandari ondo nga leuku Galilin li layimbuhu yanga Gerasa yok limu ira. ");
INSERT INTO sim_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Li ihi botin li halaha misambik li rakarik ma lar wasimalengamba tolondari ma oto Jisasin ormu ta heyera. ");
INSERT INTO sim_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma oto ermba ermbak mawa mashikop wayandari ria. Ma lar mbeek orin tolondahi ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Orin li tolokmbaha li uri, lirin mblarna ormbendari ri. Urik kumba tava orhin li owehe li kup ishindari os te. ");
INSERT INTO sim_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hako kuvu oson or korkaroho or ihi niri tandi telemba mawa mashi orok jisungambasuwu liyandari ri. Uhu sunjan or laha maome orhin orhinjik jilakorolandari ri. ");
INSERT INTO sim_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma oto Jisasin or heyehe shirinyambar Jisasik or ihi pasir or haka kumbambongok ormu lira. ");
INSERT INTO sim_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Urik wasimalengamba or ma oton tolondari lar mu mbara, �Jisas, mir jikisi Avui Wasilaka metenjek fehehi mira. Ayo, mir mberem anin mi ukmba undua? Hi Avui Wasilakahik amu mbanduwa, anin kavak nawa hala!� Karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mberem ushirik wasimalengamba oto erem or mbar? Jisas wasimalengamba oton or heyehe orin mbru ermbekmbaha uri ri. ");
INSERT INTO sim_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Uhu Jisas ormu silira, �Hi mihi lawe?� Urik wasimalengamba oto ormu mbara, �Hi anhi, �Musha Mende� sir. Mberem ushiwak? Nir musha mendek ni nanda nir.� ");
INSERT INTO sim_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Uhu ormu mbara, �Mir nirin mbashinak kuyanga toson ni hala iwan ni hala!� ");
INSERT INTO sim_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Urik fle musha mendek telemba orok olmu pasir sihi aha yara. ");
INSERT INTO sim_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Urik wasimalengamba ondo olmu mbara, �Jisas, wa mi mbashinak ni ihi avak fle kandaik ni layika.� ");
INSERT INTO sim_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Karem li mbarik ormu mbara, �Wa, ji ika.� Karem or mbashirik li ihi fle ondok limu layira. Urik fle ondo lewas li shirinya ihi telemba orok li sanglaha li layihi fa laka os orok sindari orok li layihi uksem aha lewas olmu harakora. Fle ondo 2,000-ik nari lir. ");
INSERT INTO sim_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Er li harakoshirik ma ol fle ondon washilindari ma ondo os erem nari oson li heyehe li ajehe limu tulu ira. Li tuluhu yanga yangak li ihi mbele mbele os orok talarik li heyerin limu sawe ira. Urik yanga yanga orok fehendari ma ondo er li talandirsaha mbele mbele os orok talarin heyekurik limu ira. ");
INSERT INTO sim_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uhu Jisasik li raha li heyeri ma oto angop jivik or naha waskowen falehe mashi jivin ormu mbara. Wavu orhi angop jivik nari sir, mbeek ambasiri ambu ri. Orok or lihi maimbarik li raha orin li heyehe limu aje mendera. ");
INSERT INTO sim_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Urik ma ol mbele mbele os Jisas urik heyeri ma ondo os li heyeri oson limu sawera, fle ondo hari nga ma oto jivik or narik li heyeri mashi oso nga limu sawera. ");
INSERT INTO sim_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Urik ma ol orok tari ma ondo Jisas yanga lihi oson or hala ikmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Urik Jisas botik or lawurik ma or wasimalengamba tolondari ma oto or raha ormu silira, �Jisas, an nga shi i?� ");
INSERT INTO sim_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Urik ormu mbara, �Wahau, mir yanga mihik i! Mi ihi mir avak mbele mbele os Avui Wasilaka mirin or ushiwak jivik mi nawa mashi oson mahasanje jikanoka mihi ondon sawenak li misika.� ");
INSERT INTO sim_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Urik ma oto or ihi distrik Dekapolis orok or layihi mashi oson or sawerik ma ondo li misihi wavu lihi musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Urik Jisas indik botik or layimbuhu leuku Galili kauyok ormu ira. Am kauyok or lawurik ma musha mashi orhin li misikmbaha limu tara. ");
INSERT INTO sim_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Urik ma lar er nga Jisasin heyekurik ormu tara. Hi orhi Jairus, Judama lotu undari akan washilindari ma ria. Or taha Jisasin nor heyehe kumbambongo orhin Jisashi kumbamuk ormu huvura. ");
INSERT INTO sim_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Uhu ormu tlaha sawera, �Jikisnokopji kanda anhi am hakwa ambek nar. Away, mi raha tava mihin mi hauowenak jivik si nawa.� ");
INSERT INTO sim_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Karem or mbaha Jisas nga frimu ira. Urik ma musha mendek orin li rurawuhu limu tiyaha ira. ");
INSERT INTO sim_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Urik nokove las fi nom ermba ermbak ermbeyandari oso nga osmu Jisasin tiya ira. Os erem si nandari oso asama 12-pelak nari sira. ");
INSERT INTO sim_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Uhu yan si orkoho dokta ondon si hari, mbeek li urik jivik nandari ambu sir, wahau. Os fi nom si ermbendari oso wasilaka mendek nari sir. ");
INSERT INTO sim_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jisas mbele mbelen or uri mashi oson angop si misindari osik ma nindik Jisashi kumayok simu rara. ");
INSERT INTO sim_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Uhu sihinjik osmu karem hishira, �Os men kowe orhi nom a tolo nahi, avak jivik a nakwa nir.� Karem si hishihi Jisashi kumayok kowe orhin simu tolora. ");
INSERT INTO sim_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kowe oson si tolorik, os fi nom si ermbendari oso, kolok mendek nari sir. Uhu maome sihi os er si uyandari oso lewas mendek si narik simu misira. ");
INSERT INTO sim_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Urik Jisas kwambu orhi kas lasik si irik or misihi nor tormble heyehe ormu silira, �Lawe kowe anhin tolondua?� ");
INSERT INTO sim_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Urik ol orin tiyandari ondo olmu mbara, �Mir ma tos ter mirin rurawuwa toso mberem mi heyekmbaha mi mbandua, �Lawe kowe anhin tolondua,� karem mi mbawan te?� ");
INSERT INTO sim_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hako Jisas or tormblehe ormu silira, �Lawe kowe anhin tolondua?� Karem mbaha ormu haihanda heyera, or heyekmbahan. ");
INSERT INTO sim_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Urik nokove oso am jivik si naha si ajehe kwarngarnaha si taha kumbambongo sihin Jisas siri mishik si huvuhu mbele mbele os sirik nahandari oson simu sawera. ");
INSERT INTO sim_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Urik ormu mbara, �Apmanuwa, os anin nyi hishowenda osik os nyimu jivik nanduwa. Uwa osik wavu nyihi nga jiphishihi ika. Os erem nyi uhuyanda oso angop mendek nawa sir,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas or sihi maimbari halanganga Jairushi akak fehendari ma lal li raha orin limu sawera, �Jikisi mihi angop hawa sir. Hako Jisas avak semben mi mbaha laha shi inda ngashi.� ");
INSERT INTO sim_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Karem li sawerik Jisas mbeek os lir mbari mashin misihi halari ambu ri. Uhu Jairusin ormu sawera, �Ajewa hala. Mir antonom hishioweka.� ");
INSERT INTO sim_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Karem or mbaha ma ol orok liri ondo or nga li ikurin or pantleshihi Pita, Jems, maha orhi Jon, lirtonom or laha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Li ihi am Jairushi akak li layihi li heyeri ma musha mendek orok li talandirsaha wasilaka mendek jikisi osonjik limu owetlara. ");
INSERT INTO sim_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Urik Jisas akak or layihi ormu mbara, �Mberem ushiwak ji tlaha manyelendua? Jikisi toso hawa ambu sir. Tos men waha suknyandu te!� ");
INSERT INTO sim_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Karem or mbarik ma ondo kavakavan orin limu hukwakol tolora. Urik simbalesik amber er or mbashirik limu hikrik tala irakora. Uhu jikisi osohi avoko nijava nga, Pita, Jon, Jems, ondo nom or laha aka omek limu layira, os jikisi oso haha maninimba sihi wari mishi orok. ");
INSERT INTO sim_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Er or layihi jikisi osohi tavan or toloho lihi mashik ormu mbara, �Talita kum!� Mashi oso maintontlo sihi karem, jikisnokopji, an mu nyirin mbanduwa, nyir usaha! ");
INSERT INTO sim_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Karem or mbarik jikisi oso lewas er si usaha esehe yari sir. Asama sihi 12-pelak nari sir. ");
INSERT INTO sim_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Urik mbele mbele os orok talarin li haisau handasawekurin ormu pantlera. Uhu or mbashirik jikisi oson akwan li harik simu ara. ");
INSERT INTO sim_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Urik Jisas kuyanga oson or halaha ol orin tiyandari ma ondo nga kotontlo orhik limu ira. ");
INSERT INTO sim_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Am Sabat wolok si narik Judama lotu undari akak li layi mashi Wasilakahin ormu ewesawera. Mashin or sawerik ma musha mendek li misihi li lishnyafaha limu mbara, �Ma roto mashi toso mbeek or lar? Hishiyarinda orhi oson lawe orin har? Mberemhi nombok mbele mbele ma undahi ambu ondo er nga or undu?� Karem li mbaha orin limu wapkava hishira. ");
INSERT INTO sim_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uhu limu mbara, �Ma roto akan unda ma ri. Mariahi jikisi ria. Jimatama orhi tol lindu te, Jems, Josep, Judas, Saimon karem. Jikaha orhi tol nir nga lindu te. Hako mberemhi mashi tos ter or sawendua?� Karem li mbaha orin limu kumaifara. ");
INSERT INTO sim_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Karem li mbarik Jisas mu mbara, �Profet ondo yanga yanga amber hom hi lihin hauowenda lir. Hako kotontlo lihi nga mahasanje jikanoka lihi nga mbeek lirin rupshinda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Erem si nari osik Jisas mbeek kotontlo orhi orok mbele las ma undahi ambu ondon mushak uri ambu ri, wahau. Hako ma ol kavamisindari laptonom or mbarik jivik nari lir. ");
INSERT INTO sim_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mashi os or saweri oson li misindiyari ambu osik wavu musha mushak ormu hishira. Uhu yanga yangak or yaha mashi Avui Wasilakahin ormu laha saweyara. ");
INSERT INTO sim_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas ma 12-pela ondon or usharik li rarik frijipmba frijipmbak or mbashirik limu ira. Uhu kwambu orhin lirin or hashirik avak wasimalengamba os man tolondari ondon hi orhik li mbru ermbekurik or mbashirik limu ira. ");
INSERT INTO sim_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Uhu lirin normu saukawera, �Jir avak kombe nom ji toloho, kowe os ji falenda nom nga kumba ari er nga ji falehe tapas ji ika. Hako akwa, ya, kowe lal nga ji laha iwa hala. ");
INSERT INTO sim_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Os ji ihi kuyanga lasik ji talawa, aka os ji i liwa orokop ji liyaha jivai ika. ");
INSERT INTO sim_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hako os mashi os ji sawewan li turaha jirin armek li u nahi ambu, yanga oson ji halaha kumba jeren ji narka lafakaha ji ika. Ushinak lir avak li hishihi li mba, �Nir angop mbele kava las ni uwa nir,� karem li mbaka.� ");
INSERT INTO sim_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Karem or mbarik ma ol orin tiyandari ma ondo li ihi mashin limu sawera karem, �Avak kavakava os ji undan ji heyehe ji mba, �Kas karem a uri kavan a uri sir.� Karem ji mbaha sunguwavu jihin ji tormbleka!� ");
INSERT INTO sim_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Karem li mbaha wasimalengamba ol man tolondari ondon li mbru ermberik tulu iri lir. Uhu ma ol kavamisindarin wel ukuk li ngoroho li tarik jivik nari lir. ");
INSERT INTO sim_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ma amber mbele mbele ol Jisas uri ondo nom li mbarik king Herot oto mashi os li mbari oson er nga misiri ri. Ma lal Jisasin karem mbari lir, �Wa Jon man fak tolofalendari ma oto indiyok usahari or mo? Uhu kwambu nga nor naha mbele mbele lerawun landar?� ");
INSERT INTO sim_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hako lal olmu mbara, �Wahau, or profet Elaijak nakwa ri.� Hako lal olmu mbara, �Or profet mas lerawu Avui Wasilakahin landari ma ondo hom nandari lar oria,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hako Herot mashi os Jisasin li mbari mashi oson or misihi normu mbara, �Ma orto Jon hulaima nokopman fak tolofalendari ma ri. Jekapnashi orhin angop a koroshirik hari ri. Hako ter ormu indiyok usahakwak nakwa ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herot os mas Jonin or mandingormeri nombo karem, Herot maha orhi Filiphi nokove oson ormu masnalara. Nokove oso hi sihi Herodias osira. Ushirik Jon taha ormu mbara, �Mir maha mihi Filip or liwak mi heyeshihi nokove orhi oson mi masnalawa kas tolowa ambu sir.� Karem or mbarik Herodias oso wavu sihi kavak nari sir. Ushirik Herot heyehe sirin or hokovikmbaha ma lal or mbashirik li ihi Jonin li toloho kuvu kwambuk li ishi laha krawu akak li eweshirik ormu lira. ");
INSERT INTO sim_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hako nokove oso Jonin er si wapkava hishihi orin si mandingormekmbaha hishiri sir. Hako sir mbeek orin mandingormendahik nari ambu sir. Mberem ushirik? ");
INSERT INTO sim_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot Jonin ajendari ri. Angop or heyendari ri, Jon ma jivi misokome Avui Wasilakahik ma worna mak nandari ri. Uhu Herot mashi Jonhin misikurik nandari ri. Mashi orhin or misiri wolo wavu musha mendek hishindari ri. ");
INSERT INTO sim_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hako Herodias Jonin er si wapkava hishihi nombo las si eweri karem. Herot nijava orhi os orin si wari wolo oson indiyok or hishihi hiyawu laka las ormu ura. Uhu ma ol orin jelyandari ma nga ma ol maifuk mbarik awun li undari ma nga malakama ol provins Galilik fehendari nga or usharik limu talandirsara. ");
INSERT INTO sim_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Uhu li lihi arik Herodias jikisnokopji sihi oso si taha si mblarik Herot nga ma ol er nga li liri ondo nga er limu rupshi mendera. Urik Herot nokopminyongo oson or sawehe ormu mbara, �Nyi mblawa jivi mendek osmu nanduwa. Uwosik mbele las nyi lakmbaha nyi hishiwa avak nyirin a hakwa nira.� ");
INSERT INTO sim_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Uhu mainkwambu las or sawehe ormu mbara, �Omendingak amu sawenduwa, os mbele las nyi lakwak nyi siliwa avak a hakwa nira. Os nyi mba, misambi anhin nindik a tlehe yokon nyirin a ha, karem nyi mba nahi, avak erem a ukwa nira.� ");
INSERT INTO sim_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Karem or mbarik nokopminyongo oso si layihi nijava sihin simu silira, �Mamai, mbele menden avak a mbanak or haku?� Karem si mbarik simu sawera, �Indiyok layi sawenak Jon hulaima nokopman fak tolofalenda ma oto masiji orhin or haka.� ");
INSERT INTO sim_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Urik nokopminyongo oso si layi Herotin simu sawera, os nijava sihi si mbari hom. �Ana rupshiwa karem, Jon or man fak tolofalenda ma masiji orhin bainatik koroho hambiyak mi ewehe lahara anin haka.� ");
INSERT INTO sim_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Karem si mbarik Herot sunguwavu orhi kavak er nari sir. Hako or angop mainkwambu las or mbari osik os or mbari oson mbeek or halakurik nari ambu sir. Os erem or u nahi, ma ol or nga ari ondo avak li heyenak or humblaraku, karem or hishihi os si mbari hom uri ri. ");
INSERT INTO sim_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Uhu awun undari ma orhi lar or mbashirik krawu akak or layihi Jonhi jekapnashin or koroho ");
INSERT INTO sim_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma masiji oson hambiyak or ewehe nokopminyongo osonjik ormu laharara. Urik sir nga mu nijava sihin hara. ");
INSERT INTO sim_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Urik Jonin tiyandari ma ondo mbele mbele Herot Jonin or uri mashi oson li misihi li taha maninimba Jonhin li laha ihi limu wakor owera. ");
INSERT INTO sim_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Urik aposel ondo indiyok Jisasik li raha mbele mbele os li undarin orin limu sawera. ");
INSERT INTO sim_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Urik Jisas nga li lirik ma musha mendek limu terei tererara. Urik li akmbaha li uri, wahau. Ma mor tirsaha terei tererari kom. Urik Jisas mu mbara, �Wa, ka ni i yanga lasik ni i nivai limasika.� ");
INSERT INTO sim_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Karem or mbaha botik li lawuhu lirtonom yanga os ma ngashi ambu mishi orok limu ira. ");
INSERT INTO sim_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Li irik ma mushak li sishi heyerik olmu ira. Urik orok fehendari ma ondo masmas nombokop olmu shirinyambar ira, yanga os Jisas ikurik or iri yanga orok li ikmbahan. ");
INSERT INTO sim_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Urik Jisas yanga orok or taha botin or halaha misambik or takaha ma ondon or heyehe lirnjik ormu holo mendera. Mberem ushirik? Or heyeri lir sipsip ol ma ngashi ambu hom olmu naha sira. Urik orok or sihi mashin lirin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mashin or sawehe am si homirik ol orin tiyandari ma ondo li taha limu mbara, �Am homir te, yanga toso ma ngashi ambu re. ");
INSERT INTO sim_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tondon mbashinak yanga yangak li ihi akwa lal li frungawuhu li awa.� ");
INSERT INTO sim_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Karem li mbarik ormu mbara, �Wa, jihinjik akwan ji hanak li aka.� Urik olmu mbara, �Mberem ni ukwa ambu re. Ya mbele mendek akwan ni frungawuhu ni hanak li aku?� ");
INSERT INTO sim_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Karem li mbarik ormu silira, �Jir akwa lal nga nandaj? Kolok ji i heye!� Karem or mbarik li i heyeri, akwa mushak nari ambu lir. Lir bret tostava yeje hom nga foome frijip nom nga olmu wara. ");
INSERT INTO sim_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Urik ormu mbara, �Wa ambehoma, avak ma ondon mbashinak lihi lihik misambik li lika.� ");
INSERT INTO sim_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Urik ma ondo amber misambik limu raka lira. Lal 100-ik li lirik, lal 50-k karem limu lira. ");
INSERT INTO sim_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Urik Jisas bret ondo nga foome ovro nga nor tolo lalawuhu Avui orhin armesarmek ormu mbara. Ushihi bretin or toltavaha ma orin tiyandari ondon or harik olmu ma ondon hara. Ushihi foome nga li humasishirik ma ondo olmu ara. ");
INSERT INTO sim_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Urik ma ondo amber akwan er li aha limu krehera. ");
INSERT INTO sim_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Urik akwa sumbuyambun er li lahara tirsaha serkawu 12-pelak li wolorik hojeri lir. ");
INSERT INTO sim_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hako ma ol orok lihi ari ma ondo 5,000-ik nari lira. ");
INSERT INTO sim_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Urik Jisas ma ol orin tiyandari ma ondon ormu mbara, �Jir botik ji lawuhu masmas fa mambu kasauyok kuyanga Betsaidak ji maifuhu inak a ra. Ana lihi ma rondon a mbashinak li inak amu randu.� ");
INSERT INTO sim_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma ondon am or mbashirik li irik ortonom Avui orhin or sawekurik telembak ormu lawura. ");
INSERT INTO sim_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Telembak or lawurik am simu homira. Urik bot os li iri oso am si ihi fa nindik simu nara. Hako Jisas ortonom ormu fa mambuk sira. ");
INSERT INTO sim_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Uhu or heyerik suwa si rasarik bot oson li laha li ikmbaha li uri osmu kava ura. Urik olmu lerawu mendek ura. Uhu am harakurik nar te. Urik Jisas fa heyek or eseihi lirin or tikrikmbaha ormu ura. ");
INSERT INTO sim_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Urik orin tiyandari ma ondo orin li heyeri ormu fa heyek esehe ira. Li heyehe limu mbara, �Wasi lar ori te!� Karem li mbaha limu ajera. ");
INSERT INTO sim_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Li ajerik Jisas kolomalok ormu mbara, �Ji ajewa hala. An mu randu te!� ");
INSERT INTO sim_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Karem or mbaha botik or layi lir nga nakrem ormu lira. Urik kolok suwa mendek er simu nara. Urik limu lishnya mendera. ");
INSERT INTO sim_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisas akwan or harik li ari oso angop li heyeri sir. Hako lir mbeek os or urin yariri ambu lir. Wavu lihi angop fendele menderi lir. ");
INSERT INTO sim_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas nga ol orin tiyandari ondo nga leukun li mbuhu yanga Genesaretik limu lawura. ");
INSERT INTO sim_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Li lawuhu sirik kolok ma ol yanga orok fehendari Jisasin limu heilara. ");
INSERT INTO sim_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Uhu os or tarin kolomalok yanga yangak li mainharik ma mushak ma ol kavamisindarin Jisasik limu laharara, or mbanak jivik li nakmbahan. ");
INSERT INTO sim_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Uhu yanga os or iri mishik ol kavamisindarin nombo sumbuk li eweshirik limu wara. Urik Jisas irik limu silira, �Mi halanak kowe mihi kas ni toloho jivik ni naka.� Erem li mbaha kowe orhi nom li toloho jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi lal nga mashi Moseshin sawendari ma lal nga Jerusalemin li halaha Jisasin li heyekurik limu tara. ");
INSERT INTO sim_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Uhu li heyeri Jisasin tiyandari ma ondo tavan yoko namber olmu tavatle nga tolo ara. Urik lirin limu ngriara. ");
INSERT INTO sim_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mberem ushirik? Farisi ondo nga Judama amber nga neloko avoko lihi nombon li tiyaha mbeek tavatle nga tolo andari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Akwa li laharari ondon armek li yokohokop andari lir. Uhu os neloko lihi undari hom hambiya kumbiyan armek yokondari lir. ");
INSERT INTO sim_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Urik Jisasik li taha limu silira, �Mberem ushiwak mirin tiyanda ma tondo tavatle nga li tolo andu? Oso kava sira. Mbeek neloko avoko nihi mbari nombon li tiyanda ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Karem li silirik ormu sawera �Profet Aisaia mas or kayehe or mbahandari ma jira. Misi, karem or kayeri sir, �Ma ondo suwambushikop hi anhin hauowenda lir. Hako wavu lihi homek sinda sir. ");
INSERT INTO sim_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lir ma misambik fehehi mashin li sawehe karem mbanda lir, �Avui Wasilakahi mashi kasira.� Os erem li uwa oso men sembe menden anin lotu unda lira.� ");
INSERT INTO sim_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jir ma ol profet Aisaia or kayendari ondo hom nanda jir. Jir angop Avui Wasilakahi mashin er ji halaha neloko avoko jihi mashi nom ol jimu tolonduwa.� ");
INSERT INTO sim_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Uhu mashi las nga ormu sawera, �Jir arme mendek mbafirimbanda ma jira. Jir mbele mbele os Avui Wasilaka or mbari mashin ji mblarna ermbeshihi neloko jihi unda nombon os jimu tiyayanduwa. ");
INSERT INTO sim_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mashi Avui Wasilakahi karem mbanda sir, avoko nijava jihi mashi lihin ji misihi lirin armek ji uka. Hako os lirin mashi kavan ji mba nahi, os lo Moseshi oso si mbahanda hom avak li mandingormeshinak hakwa jir. Mashi Avui Wasilakahi karem mbanda osa. ");
INSERT INTO sim_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Hako jir mashi oson ji mblarna ermbehe karem ewesawenda jir. Os avoko nijava jihin armek ji ukwan ji halashihi ya mbele mbele jihi ondon Avui Wasilakan ji ha nahi, oso jivi sira. Karem ewesawenda jir. ");
INSERT INTO sim_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hako os erem ji mbanda nombo orok mashi Avui Wasilakahi si mbahanda nombon ji lai halaha neloko jihi li mbanda nombo yejen os jimu tiyanduwa. Uhu mbele mbele orokop ji uhu mashi Avui Wasilakahi os jimu tirna halanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Uhu Jisas ma ondon or usharik li talarik normu sawera, �Mashi anhi kason armek ji misihi ji yarika. ");
INSERT INTO sim_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mbele mbele ol hikri yok nahandak akomek layiwa ondo mbeek uwak ma kavak nanda ambu lir, wahau. Hako mbele mbele ol sunguwavu yok nahandak hikrik tasanda ondo li uwak ma kavak nanda lir.� ");
INSERT INTO sim_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Karem or mbaha lafakaha akak ormu ira. Urik ol orin tiyandari ma ondo maintontlo os or mbari oson or sawenak li misikmbaha limu silira. ");
INSERT INTO sim_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Urik ormu mbara, �Jir nga jimu hishandu? Mbele mbele ol hikri yok nahandak akomek layiwa ondo mbeek man uwak kavak nanda ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mberem ushiwak? Ondo siyahugri wavuk layinda ambu lir. Ondo men sunguk layiwak li siyiermbenda lir.� Karem or mbari mbele mbele akwa ol ni anda ondo jivi numbu lir, karem mbari ri. ");
INSERT INTO sim_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Uhu mashi las nga ormu sawera, �Mbele mbele ol wap akomek nahandak hikri yok talawa ondo man uwak kavak nanda lir. ");
INSERT INTO sim_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ondo karem, wapkava hishinda, hirnyanda, man mandingormenda, nokophirmbirihi hulatolhakanda, ");
INSERT INTO sim_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","misokomlaka heyenda, mbele mbele kavan unda, haimba handambaha mbafiriyanda, sisakasak unda, man wapkava hishinda, mashi os ma anandihi hin uwak kavak si nanda, yerkuji hi orhin orhinjik hauowenda, farausi ambarambasi yanda, ondo uwak ma kavak nanda lir. ");
INSERT INTO sim_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mbele mbele kando amber wap akomek nahandak hikrik talanda lir. Uhu man uwak kavak nanda lir.� ");
INSERT INTO sim_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Uhu Jisas yanga oson or halaha yanga Tair nga Saidon nga orok ormu ira. Uhu aka lasik or layihi nendekop or likmbaha ormu hishira. Hako ol orok fehenda ma ondo os orok or likurin angop li heyeri sir. ");
INSERT INTO sim_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Uri osik Juda nokove ambu, yanga Fonisia kolaka Siriak fehenda nokove las er nga orok or lirin si misihi kolomalok orin si heyekurik simu tara. Jikisnokopji sihi wasimalengamba tolondari sir. Undari osik orin si heyekurik simu tara. Si taha orin si heyehe kumbambongon si huvuhu misambik kumbamu orhik simu rakara. Uhu kwambu mendek simu tlara, �Mir avak mbanak wasimalengamba or jikisi anhin tolonda avak or tulu ika.� ");
INSERT INTO sim_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Karem si mbarik Jisas ormu mbara, �Nir mbeek jikisihi akwan ni laha asan ni handa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Urik simu mbara, �Wasilaka, mashi mihi oso ome sira. Hako asa ol tei siyok siwa ondo jikisihi akwatlamun nongo anda lir.� ");
INSERT INTO sim_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Karem si mbarik ormu mbara, �Am erem nyi mbawa osik indiyok aka nyihik ika. Wasimalengamba or jikisi nyihin tolowa oto angop hala iwa ri.� ");
INSERT INTO sim_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Karem or mbarik aka sihik si ihi si heyeri wasimalengamba or jikisi sihin tolondari oto angop or hala ishirik jikisi oso osmu kawuk wara. ");
INSERT INTO sim_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Urik Jisas yanga Tairin or halaha or ihi yanga Saidon nga distrik Dekapolis nga or tikrishihi leuku Galilik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Urik ma lal li taha ma or mambla jihi maimbandari ambu oton orik li laharaha limu mbara, �Jisas, tava mihin maome orhik mi hauowenak avak jivik or naka!� ");
INSERT INTO sim_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Urik Jisas ma ol orok liri ondon or halashihi ma ortonom or laha frimu ira. Uhu nendekop fri lihi tava orhin or laha mambla washi ma otohik ormu hongora. Ushihi tava orhin or suntlayashihi tarvle ma otohik ormu hautara. ");
INSERT INTO sim_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ushihi lersuwu yok or larasa mawuhu Avui orhin ormu sawera karem, �Efata!� Mashi oso �Mambla huvanak takhava larnaka,� karem mbahanda mashi sir. ");
INSERT INTO sim_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Urik kolok ma oto mambla orhi si huvarik tarvle si flarmarik or misihi normu maimbara. ");
INSERT INTO sim_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Urik Jisas ol orok liri ondon ormu mbara, �Avak tos ter a uwak ji heyewa toson man ji sawewa hala!� Hako lir mbeek os or mbari mashin misiri ambu lir, wahau. Os or urik li heyeri oson olmu haisau handasaweyara. ");
INSERT INTO sim_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Urik ma ol mashi oson misiri ma ondo li lishnyafaha limu mbara, �Mbele mbele ol or uwa ondo mbeek kavak nanda ambu lir, jivikop nanda re. Or uwak mambla jihinda li misiwak takhava nomok nahanda li maimbawak karem unda ri.� ");
INSERT INTO sim_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Oro wolok ma musha mendek Jisas mbari mashin li misikurik limu ralandirsara. Hako lir mbeek akwa nga nari ambu lir. Uri osik Jisas ma ol orin tiyandari ondon or usharik li rarik ormu mbara, ");
INSERT INTO sim_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","�An ma tol torok liwa tondonjik amu holonduwa. Lir angop niri frijip nir nga torok liwa lir. Uhu lir akwa nga nawa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lal lihi nombo homek ikwa lir. Os sungu nga na mbashinak yanga lihik indik li i nahi, avak nombok kumba tava hahantlenak takatukuyikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Urik limu mbara, �Toso ma ngashi mishi ambu re. Mbeyok ni ihi akwan ni laha ma tondon ni hanak li aku!� ");
INSERT INTO sim_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Urik ormu silira, �Jir akwa lal wandal?� Urik limu mbara, �Nir bret 7-pela nom tolira.� ");
INSERT INTO sim_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Urik Jisas ma ondon or mbashirik amber misambik limu raka lira. Urik bret ondon or laha Avui orhin armesarmek or sawehe ormu mbara. Ushihi bret ondon or toltavaha ma ol orin tiyandari ondon or harik lir nga mu ma ondon hara. ");
INSERT INTO sim_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Urik lir foome lal er nga limu laharara. Urik Jisas foome ondon or laha Avui orhin armesarmek or sawehe ormu mbara. Uhu foome ondon er nga ma ol orin tiyandari ondon or harik lir nga mu ma ondon hara. ");
INSERT INTO sim_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Urik akwa ondon li aha limu krehera. Uhu akwa sumbuyambun li lahara tirsaha serkawu 12-pelak li wolorik limu hojera. ");
INSERT INTO sim_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma ol orok ari ondo 4,000-ik nari lir. ");
INSERT INTO sim_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Urik Jisas or mbashirik li irik or yok botik or lawuhu ma ol orin tiyandari ondo nga distrik Dalmanuta yok limu ira. ");
INSERT INTO sim_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Urik Farisi lal Jisasin li mbanak or mbanak li heyekmbaha li taha limu mbara, �Mir kolok mbele las ma undahi ambun unak ni heyehe nivai mbaka, mir kwambu Avui Wasilakahi ngashi mira.� ");
INSERT INTO sim_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Karem li mbarik Jisas wavu orhi am kavak si narik ormu mbara, �Jir mberem ushiwak mbele las a unak si talanak ji heyekmbaha ji mbandu? Omendingak jirin amu sawenduwa, an mbeek mbele las a unak heyekwa ambu jir, wahau.� ");
INSERT INTO sim_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Karem or mba lafakaha botik or lawuhu orin tiyandari ma ondo nga leuku oson li mbuhu kauyok limu ira. ");
INSERT INTO sim_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hako ol orin tiyandari ma angop li hishakashaha mbeek akwa las nga laha iri ambu lir. Bret namtas nom li laha iri osmu botik wara. ");
INSERT INTO sim_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Urik Jisas mainkwambu las lirin ormu sawera, �Ji auheye, Farisi ondo nga Herothi ma ondo nga yis lihin.� ");
INSERT INTO sim_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Karem or mbarik lihi ambek limu mbara, �Mberem ushiwak mashi toson ter or mbanduwa? Nir bret ngashi ambu, karem or mbawa toson.� ");
INSERT INTO sim_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas mashi os li mbari oson angop or heyeri sir. Uhu normu mbara, �Mberem ushiwak jir bretnjik ji mbandu? An bretin na mbawa ambu nir. Mberem ushiwak ji hishakasha mendendu? Jir hishiyarinda ambu oj? ");
INSERT INTO sim_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jir misokome ngashi jir. Hako mberem ushiwak mbele mbele os a uwan ji heyenda ambu? Jir mambla ngashi jir. Hako mberem ushiwak ji mambla jindu? ");
INSERT INTO sim_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Uhu mberem ushiwak ji hishakasha mendendu? Os bret tostava yeje hom a toltavaha ma 5,000-ik a harik li ari oson jimu hishanduwa. Oro wolok akwa sumbuyambu serkawu mbelmbel ji wolor?� Karem or silirik limu mbara, �Serkawu 12-pelak ni wolori nira.� ");
INSERT INTO sim_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Urik ormu silira, �Os bret 7-pela a toltavaha ma 4,000-ik a harik li ari wolo akwa sumbuyambu serkawu mbelmbel ji wolor?� Karem or silirik limu mbara, �Serkawu 7-pelak ni wolori nira.� ");
INSERT INTO sim_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Urik ormu mbara, �Mbele mbele os a uri angop ji heyerakori sir. Hako mberem ushiwak ji hishiyarikwan ji hishandu?� ");
INSERT INTO sim_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas nga ma ol orin tiyandari ma ondo nga yanga Betsaidak limu ira. Urik ol yanga orok fehendari ma ondo misokome tumundari lar orhik li laharaha limu sawera, �Mir misokome tumunda toton mbanak jivik or naka!� ");
INSERT INTO sim_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Karem urik Jisas misokome tumundari oton mantle yok or lai ewehe tava orhin suntla ukuk or uhu ma otohi misokom mambuk or hautaha ormu silira, �Kas am mimu heyendu mo?� ");
INSERT INTO sim_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Karem or silirik or heyekurik or uhu ormu mbara, �Yawur a heye nembes. Hako ma lal mi ama hom li taltala iwak amu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Urik Jisas indiyok tava orhin ma otohi misokom mambuk ormu hauowera. Urik misokome orhi armek si huririk ormu heyera, mbele mbele ol mas or heyendari ambu ondon. ");
INSERT INTO sim_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Urik Jisas ormu mbara, �Mir avak yanga lasik iwa hala. Nombok yanga mihik ika!� Karem or mbashirik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Urik Jisas nga ma ol orin tiyandari ma ondo nga kuyanga os Sisaria Filipai nandari mishi orok limu ira. Li ihi nombok ormu lirin silira, �Hulaima nokopma rondo an lawe, karem li mbawak ji heyendu?� ");
INSERT INTO sim_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Karem or silirik limu mbara, �Lal mir Jon, hulaima nokopman fak tolofalenda ma mir, karem mbanda lir. Hako lal mir Elaija, karem mbanda lir. Hako lal mir profet ol mas lerawun landa lihi lar mira, karem mbanda lir.� ");
INSERT INTO sim_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Karem li mbarik ormu silira, �Hako jir jihinjik an lawe, karem ji hishindu?� Karem or mbarik Pita mu mbara, �Mir hulaima nokopman jivinakmbaha Avui Wasilaka or kamaha nor mbashirik tahanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Karem or mbarik Jisas mashi os Pita or mbari mashi oson man li sawekurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Urik Jisas ma ol orin tiyayandari ondon ormu mbara, �Ma Jikisi Avui Wasilakahi avak nomorawu wasilakan or kishakwa ri. Avak Judama lida lihi nga bikpris ondo nga mashi Moseshin sawendari ma ondo nga orin li kumaifaha li mbashinak yanga anandik fehe ma orin jimandingormekwa ri. Ushinak niri frijip fri ishinak indiyok or usahakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mashi oson or saweri kormba mendek si narik limu misira. Urik Pita Jisasin mantle yok or lai owehe mainkwambuk ormu mbara, �Erem mbawa hala!� ");
INSERT INTO sim_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Urik Jisas or tormblehe ma ol orin tiyandari ondon or heyehe ormu Pitan ngriara, �Laulaka mir haisi! Mashi os mi mbawa oso mbeek Avui Wasilakahi mashi ambu sir, wahau. Oso mashi tol misambik fehe lihi mashi sir.� ");
INSERT INTO sim_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Urik Jisas ma ol orok liri ondo nga ol orin tiyandari ma ondo nga or usharik li rarik ormu mbara, �Os anin ji tiyakunak ji hishi nahi, mbele mbele jihi amber ondon ji halaka. Uhu nomorawu os jihik talakwan miando hom ji kishaha anin ji tiyaka. ");
INSERT INTO sim_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hako os mbele mbele jihi ondon ji toltambana nahi, avak mendek nakwa jir. Hako os anin ji hishihi anin ji tiyaha mbele mbele ondon ji hala nahi, kumak ermba ermbak linda oson jivai laka. ");
INSERT INTO sim_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Os mbele mbele misambik fehe nga mushak ji na nahi, wa mberem ji hishindu? Mbele mbele jihi ondo am jirin jelyakundal? Wahau. ");
INSERT INTO sim_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mbele mbele jihi ondo mbeek jirin jelyaha ermba ermbak linda oson jirin hakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Os ma misambi fehe ol kavakavan uhu mashi Avui Wasilakahin mblarnanda ondon ji ajehe hi anhin kormbak ji sawena ambu nahi, an nga erem, os misambi torok indik a rakuna wolo ukruharanda Avui Wasilakahi nga ensel ondo nga na raha karem a mbakwa nir, �Ma tondo na heyenda ambu nir.� Karem jirin a mbakwa nir.� ");
INSERT INTO sim_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ushihi mashi las nga Jisas ormu mbara, �Omendingak jirin amu sawenduwa, torok siwa lal li ha namber avak Avui Wasilaka os lirin or arangoshinak li likwa oso kormbak si talanak heyekwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Urik niri 6-pela li ishirik Jisas, Pita, Jems, Jon lirtonom or laha telemba lasik limu lawura. Am li lawuhu li heyerik Jisas maome orhi si tormblehe apsham indingak simu nara. ");
INSERT INTO sim_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Urik kowe orhi os or faleri er nga si tormblehe avisha mendek simu nara. Mbeek ma misambik fehe lar kowe orhin or unak erem nandahi ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Urik li heyerik Elaija fre Moses fri raha Jisas nga limu maimbara. ");
INSERT INTO sim_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Urik Pita mu mbara, �Tisa, torok ni liwa osmu jivi mendek nanduwa. Halanak shikor aka nalmingrip torok ni uka. Las mihi, las Moseshi, las Elaijahi.� ");
INSERT INTO sim_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mberem ushirik Pita mashi oson erem or mbar? Mbeek masikome nga siri ambu ri. ");
INSERT INTO sim_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Urik kwandi las lirin si aulafaleshirik kwanindik limu sira. Urik kwanindik mashi las osmu mbara, �Ma orto jikisi indingo anhi ria. Orin wapnuku anhik amu ewenduwa. Mashi orhin ji misika.� ");
INSERT INTO sim_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mashi oso karem si mbarik li haihandaheyeri, mbeek ma lar nga li heyeri ambu ri. Jisas nom orok siri ria. ");
INSERT INTO sim_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Urik telemban li halaha li rakaha Jisas mu mbara, �Mbele mbele os ji heyewa oson ma lal sawewa ji hala! Undanak Ma Jikisi Avui Wasilakahi or haha mawan or halaha indiyok or usahashinak jivai saweka.� ");
INSERT INTO sim_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Urik mashi oson wavu lihikop li ewehe lihi ambek limu anasawera, �Mashi Ma Jikisi Avui Wasilakahi os mawan or halaha indiyok or usahakwa mashi oso mberemhi mashi sir?� ");
INSERT INTO sim_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Uhu Jisasin limu silira, �Mir sawenak ni misi. Mberem ushiwak mashi Moseshin sawenda ma karem li mbandu, �Elaija avak masmas takwa ri. Or tashinakop kuma Avui Wasilaka kamahanda ma orto takwa ria.� Karem li mbandu?� ");
INSERT INTO sim_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Urik ormu mbara, �Mashi oso ome sira. Elaija masmas or taha mbele mbelen armek or hundujerakoshinak Avui Wasilaka kamahanda ma oto kumasikop takwa ri. Mashi oso omendinga sir. Uhu mashi las nga karem li kayeri sir, �Ma Jikisi Avui Wasilakahi avak nomorawu wasilakan or kishanak hulaima nokopma avak orin kumaifakwa lir.� Karem li kayeri sir. ");
INSERT INTO sim_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hako jirin amu sawenduwa, Elaija angop tari ria. Urik mbele mbele kavakavan orin limu uri sira. Os maskop li kayehendari hom.� ");
INSERT INTO sim_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Urik Jisas nga ma nalmingrip ondo nga telemban li halaha limu takara. Li takaha li heyerik ma ol orin tiyandari ondo nga ma ol mashi Moseshin sawendari ma nga limu anambli anamblarnara. ");
INSERT INTO sim_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jisas tumsar or tarik li heyehe limu lishnyafara. Uhu orin heyekurik li ihi orin limu flehava kwara. ");
INSERT INTO sim_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Urik ormu silira, �Mbele ji mbandu, ma ondo nga?� ");
INSERT INTO sim_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Urik lar or lihi nindik siri lar oto Jisasin ormu mbara, �Tisa, jikishulayi anhi wasimalengamba toloshihindak mihik amu laharanduwa. Malengamba oto suwambushi orhin or arangoshindak mbeek maimbanda ambu ri. ");
INSERT INTO sim_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ermba ermbak orin or toloshihi or ermbewak misambik takatukuyinda ri. Uwak suntla hermbo suwambushi orhik talaha fu orhin or tangrimbaha wanda ri. Uhu maome orhi sanguanaha wanda ri. Hako ma ol mirin tiyandari ma tondon a silirik wasimalengamba oton mbeek li mbru ermbendahik nari ambu lir.� ");
INSERT INTO sim_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Karem or sawerik ormu mbara, �Jir anin hishiowenda ambu oj? Ermba ermbak jir nga na lihi mashin angop a sawewak ji misinda sir. Hako jir mbeek anin hishiowenda ambu jir. Wa, jikisi oton laharaka.� ");
INSERT INTO sim_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Karem or mbarik jikisi oton limu laharara. Urik wasimalengamba or jikisi oton tolonda oto Jisasin or heyehe jikisi oton or urik amba amban or kwarngarnaha misambik or takaha ormu torntarmblera. Karem urik suntla hermbo suwambushi orhik simu ngorora. ");
INSERT INTO sim_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Urik Jisas avoko ma oton ormu silira, �Mbele wolo mendek jikisi toto wasimalengamba toloshirik karem or ur?� Urik ormu mbara, �Angop jikisakrik or nari wolokop. ");
INSERT INTO sim_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ermba ermbak wasimalengamba oto uwak hik or takaihi fak or ihi karem uhu orin or mandingormeshinak or hakwak unda ri. Os nirin mi rupshihi am mi unda nahi, jikisi anhi toton mbashinak jivik or naka,� ");
INSERT INTO sim_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Karem or mbarik ormu mbara, �Mberem ushiwak os mi mba, mir am mi unda nahi, karem mi mbandu? Misi, os ma lar anin or hishiowena nahi, os or mbawa hom a ukwa nir.� ");
INSERT INTO sim_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Karem or mbarik kolomalok, avoko ma oto wasilakak ormu tlara, �An mirin a hishiowenda nir. Hako wavu anhi frijip frijip nanda osik anin jelyashinak kwambuk a sika.� ");
INSERT INTO sim_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Urik Jisas or sihi or heyerik ma musha mendek os or liri mishi orok olmu siralayantlera. Uhu wasimalengamba oton or ngriaha ormu mbara, �Malengamba mir suwambushi arangoho mambla jihinda mirin amu mbanduwa, mir jikisi toton halaha tala ika! Uhu avak indiyok orhik layiwa hala!� ");
INSERT INTO sim_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Karem or mbarik wasimalengamba oto wasilaka mendek or jisuwuhu jikisi oton or urik misambik or takaha handari hom ormu wara. Urik wasimalengamba oto or halaha ormu tala ira. Urik ma ondo li siheyehe limu mbara, �Ayo, jikisi toto karem haw te!� ");
INSERT INTO sim_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Karem li mbarik Jisas or taha jikisi otohi tavan or tolorik ormu usasira. ");
INSERT INTO sim_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Erem or u lafakaha Jisas aka lasik ormu ira. Uhu or nga ma ol orin tiyandari ma nom nga orok li lihi limu silira, �Ayo, nir mberem ushiwak wasimalengamba oton ni mbawak or tala indahi ambu?� ");
INSERT INTO sim_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Karem li silirik ormu mbara, �Os mashi anhin ji misindiyaha Avui Wasilakan ji sawe nahi, wasimalengamban ji mbanak tulu ikwa ri. Nombo anandi las ngashi ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas ol orin tiyandari ondo nga nom li likurik or hishiri osik yanga oson li halaha kuyanga Galilin li tikrihi limu ira. ");
INSERT INTO sim_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Am li ihi lirin karem normu sawera, �Ma Jikisi Avui Wasilakahin avak tavarenje ma kavahik li halashinak orin li jimandingormeshinak hakwa ri. Or haha niri frijip fri ishinak indiyok usahakwa ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hako lir mbeek maintontlo os or mbari oson yariri ambu lir. Uhu orin li silinak or sawenak li misikurin limu ajera. ");
INSERT INTO sim_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Urik Jisas nga ma ol orin tiyandari ondo nga yanga Kaperneamik li taha aka lasik limu layi lira. Akak li layihi Jisas ormu lirin silira, �Jir mbel mashin nombok ji mbaharawak a misiw?� ");
INSERT INTO sim_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Karem or silirik lir mbeek mashi las mbari ambu lir. Mberem ushirik? Nombok li rari wolo lihi ambek malakamak li nakurin anatariri ola. Karem uri osik lir mbeek mashi kas mbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Uhu Jisas or taka lihi ma 12-pela ol orin tiyandari ondon or usharik li rarik ormu sawera. �Os ma lar Avui Wasilakahi misokomek malakamak or nakwak or hishi nahi, wa orhinjik or hafakaha ma amber or jelyaka.� ");
INSERT INTO sim_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Karem or mbaha jikisakri kanda lar lihi nindik or tolo laharaha findumushirik or sirik ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","�Os jikisakri kanda roto hom nawan hi anhik armek ji u nahi, wa os jimu anin rupshinduwa. Wa antonom nembes, wahau. Avui anhi or mbashirik a rahanda orto er nga jimu rupshinduwa.� ");
INSERT INTO sim_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Urik Jon Jisasin ormu sawera, �Tisa, nir ni heyewak, ma lar wasimalengamba ondon hi mihik or mbru ermbewak li tulu iwa re. Hako ma oto or mbeek nir nga nakrem sinda ambu ri. Ushiwak orin ni pantlewa.� ");
INSERT INTO sim_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Urik ormu sawera, �Orin ji pantlewa hala! Misi, os ma lar hi anhik mbele las apsham nanda ma undahi ambu oson or u nahi, or mbeek kolomalok mashi kavan anin mbakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Os ma lar wutari nihik nana ambu nahi, nihi ma lar oria. ");
INSERT INTO sim_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Os ma lar jirin or heyehe mba, �Ma rondo Jisasin tiyanda ma tolira.� Karem or mbaha uksembe kas or hanak ji a nahi, omendingak amu jirin sawenduwa, os or uwa oso Avui Wasilaka mbeek or hishakwa ambu ri, wahau. Kumakop wasan or hakwa ri.� ");
INSERT INTO sim_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","�Os ma lar jikisakri kanda ol mashi anhin misindiyanda ondon or mbaskashinak kavakavan li u nahi, ma or mbaskashiwa oto kumak avak kavak nakwa ri. Os sunja lakan jekapnashi orhik li ishitivihi fak li ermbeshinak or uk aha or ha nahi, oso mbeek lakak nawa ambu sir. Mberem ushiwak? Kumak avak kava indingak er nakwa ri. ");
INSERT INTO sim_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Os tava jihi si mbango nahi, os erem uwa yokon andulek shikoro ermbenak si ika. Ushihi tava yeje nom ji nahandanak kumak avak os ermba ermbak linda oson jivai laka. Las avak tava evrembam ji nahandanak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Os kumba jihi mbango nahi, kumba os erem uwa yejen andulek shikoro ermbenak si ika. Ushinak kumba yeje nom ji nahandanak ermba ermbak linda oson kumak jivai laka. Las avak kumba evrembam ji nahandanak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Os misokome jihi haihanda heye nahi, las kwarko ermbenak si ika. Unak misokome yelndamkop ji naha avak yanga jivi Avui Wasilakahik ji ika. Las avak misokome evrembam ji nahandanak hik ji inda ngashi. ");
INSERT INTO sim_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hi oso mbeek usunguanda ambu sir, wahau. Ermba ermbak er unda sir. Unak yanga orok nindi hom nanda ondo maome jihin shikoro akwa lira. Uhu ondo mbeek mendek nakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ofan li undari wolo waswok li ermbeshirik Avui Wasilakahi misokomek jivik nandari sir. Uhunda hom Avui Wasilaka kavakava ol ji undan hik or suwushinak jivik nakwa jir. ");
INSERT INTO sim_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jir akwan waswok ji ermbeshiwak jip anda sir. Uhunda hom Avui Wasilaka ma orhin erem or ushiwak akwa jivi hom jivik nanda ola. Hako os waswo jivik si nana ambu nahi, mberem ni unak indik jivik si naku? Wahau. Uwosik jir waswo jivi hom ji naha ma misambik fehe lihi nindik armek ji lika,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas yanga oson or halaha ormu provins Judiak ikmbaha ira. Or ihi fa Jordanin or mbuhu kauyok ormu ira. Urik ma musha orhik li ralandirsarik mashin ormu sawera, os ermba ermbak or ewesawendari hom. ");
INSERT INTO sim_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Urik Farisi lal li taha men li mbanak or mbanak li heyekmbaha limu silira, �Lo nihi mberem si mbandu? Os nokove nihin men semben ni turaha ni mbashinak si ika, karem ni mba nahi, jivik nawa os?� ");
INSERT INTO sim_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Karem li silirik Jisas mu lirin silira, �Misumu nihi Moses mashi os or kayehendari mberem si mbandu?� ");
INSERT INTO sim_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Karem or silirik limu mbara, �Karem or kayeri sir, os ma lar nokove orhin or turaha sirin or halakmbaha or hishi nahi, wa jekamba las karem or kayeka, �Nokove anhi oson avak a halakwa nir.� Karem or kayeshinak li heyeshinak sivai hala ika.� ");
INSERT INTO sim_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Urik ormu sawera, �Mberem ushirik Moses mashi oson or kayer? Jir ferfar naha mashi Avui Wasilakahin ji mblarnandari osik Moses mashi oson or kayehe jirin hari ri. ");
INSERT INTO sim_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hako armek ji misi, mas araje wolok Avui Wasilaka mbele mbele ondon or uri wolo hulayi nga nokove nga or uri vri. ");
INSERT INTO sim_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Uhunda osik hulayi or nokoplawa wolo avoko nijava orhin or halaha nokove orhi nga linda vri. ");
INSERT INTO sim_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Uhu opmu maome namtaskop nanda vria, mbeek apshambak nanda ambu vria. ");
INSERT INTO sim_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uhunda osik mbele las os Avui Wasilaka or ananjahanda oso mbeek ma misambik fehe lar tlendahi ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Karem or mba lafakaha aka lasik ormu ira. Or nga ol orin tiyandari ma ondo nga nendekop akak li lihi limu silira, �Mashi os erem mi mbari mashi oso mberemhi mashi sir?� ");
INSERT INTO sim_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Urik ormu sawera, �Os ma lar nokove orhin or turaha or mbashinak si inak nokove anandin or la nahi, wa ma orto nokophirmbirinda ma ria. ");
INSERT INTO sim_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uhunda hom os nokove las hula sihin si halaha hula anandin si siwa, sir erem hulatolhakanda nokove sira.� ");
INSERT INTO sim_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hulaima nokopma jikisakri lihin Jisasik limu laharara. Unak lirin or toloho Avui Wasilakan or sawenak lirin armek or ukmbahan. Hako orin tiyandari ma ondo li heyehe ma ondon limu ngriara. ");
INSERT INTO sim_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Urik Jisas or heyehe wavu orhi osmu kavak nara. Uhu ormu mbara, �Jikisakri tondon halashinak anhik li raka. Jir avak lirin ji pantlewa hala. Ma ol jikisakri tondo hom nawa Avui Wasilakahi krahak li sihi orhik ikwa lira. ");
INSERT INTO sim_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Omendingak jirin amu sawenduwa, os ma lar Avui Wasilakahi krahak or sikwak or hishi nahi, jikisakri tondo hom or naka. Os lir hom or nana ambu nahi, or mbeek Avui Wasilakahi krahak sikwa ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Karem or mbaha jikisi ondon or laharaha tava orhik lirin or toloho Avui orhi lirin armesarmek or ukmbaha ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas yanga oson or halaha or ikmba urik ma lar orhik or shirinya raha Jisas siri mishik pasir or taha kumbambongon or huvuhu ormu silira, �Mir tisa jivi mira. Anin sawenak a misi, mberem a uhu os ermba ermbak linda oson avai laku?� ");
INSERT INTO sim_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Karem or silirik Jisas mu mbara, �Mberem ushiwak an jivi, karem mi mbandu? Avui Wasilaka namtar nom jivi mende ria. ");
INSERT INTO sim_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mashi os Moses karem or kayendari ondo angop mi heyendari lir, man mandingormewa hala, nokophirmbirihi hulatolhakawa hala, hirnyawa hala, man sembe mbawa hala, man haimba handambaha mbele mbele lihin lawa hala, avoko nijava mihin tiyaha mashi frihin misika.� ");
INSERT INTO sim_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Karem or mbarik ormu mbara, �Tisa, os jikisakrik a nari wolokop sishi raha mashi ondo amber angop a tiyarakonda nir.� ");
INSERT INTO sim_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Karem or mbarik Jisas orin or heyehe ormu mbara, �Mirin amu rupshinduwa. Hako mbele las os mendek mi nawak amu heyenduwa. Mir mbele mbele mihi ondon mi mbashinak li frungawushinak ya ondon mi laha erndakava ondon haka. Ushihi ra anin mi tiyaka. Os erem mi uwa kumak hevenik mi lakundan os mimu hundujenduwa.� ");
INSERT INTO sim_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Karem or mbarik ma oto fuma kava heyehe wavu orhi kavak si narik or halashihi ormu ira. Mberem ushirik? Or ya mbele mbele mushak nandari ora. ");
INSERT INTO sim_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Urik Jisas ol orin tiyandari ma ondon or heyehe ormu mbara, �Ma ol mbele mbele nga mushak nanda ma ondo Avui Wasilakahi siyok li sikmbaha li hishiwa anala mendekwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Karem or mbarik wavu lihi musha mushak li hishihi limu mbara, �Ayo, mashi toso mberemhi mashi sir?� Urik ormu mbara, �Ji misi, os Avui Wasilakahi siyok ji sikmbaha ji hishi nahi, anala mendekwa jir. ");
INSERT INTO sim_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel lar am kowen tlavanda nil washi orok layikundar? Wahau. Uhunda hom ma ol mbele mbele mushak nanda ondo os Avui Wasilakahi siyok li sikmbaha li hishiwa kava ukwa mende sir.� ");
INSERT INTO sim_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Karem or mbarik ol orin tiyandari ma ondo li lishnyafaha lihi ambek limu mbara, �Os erem si na nahi, wa lawe avak ermba ermbak linda oson laku?� ");
INSERT INTO sim_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Urik Jisas lirin or heilaha ormu mbara, �Mbele mbele ol ma undahi ambu ondo Avui Wasilaka or undahi lir.� ");
INSERT INTO sim_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Urik Pita mu orin silira, �Misi, mbele mbele nihi amber angop ni halarakoho mirin nimu tiyanduwa. Hako mbele menden ni laku?� ");
INSERT INTO sim_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Karem or silirik Jisas mu mbara, �Omendingak jirin amu sawenduwa, ma ol anin tiyakwak hishiwa ma ondo mbele mbele lihi, aka, mahasanje, jikanoka, avoko nijava, jikisi, nowe lihi nga li halaha anin li tiya nahi, ");
INSERT INTO sim_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","os misambi torok li liwa wolo Avui Wasilaka mbele mbele ol li halawan lihi farniyik warje nga or hakwa lir. Hako nomorawu er nga lirik talakwa lir. Uhundanak kumak ermba ermbak linda oson livai laka.� ");
INSERT INTO sim_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Uhu mashi las nga ormu mbara, �Ma ol misambi torok maifu iwa ma ondo kumak avak ta kumasikwa lir. Unak ma ol ter wolok kumasi iwa ondo kumak avak maifu ikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Urik Jisas nga ol orin tiyandari ma ondo nga yanga Jerusalemik li ikmba limu ura. Hako Jisas or maifu irik ol orin tiyandari ondo li kumasihi wavu apsham apsham limu hishira. Urik ma ol lir nga iri ondo er nga wavu musha mushak limu hishira. Urik Jisas ma 12-pela ondo nom apsham or lai ewehe mbele mbele os orhik talakurin lirin ormu sawera, ");
INSERT INTO sim_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","�Ji misi, avak Jerusalemik ni ikwa nir. Unak Ma Jikisi Avui Wasilakahi oton tavarenje bikpris nga mashi Moseshin sawenda ma ondo nga lihi tavak li hakwa ri. Unak orin li kotim uhu orin li mandingormekmbaha mbaolsolokwa lir. ");
INSERT INTO sim_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Uhu Judama ambu ondohi tavak li halashinak orin li okolehe suntlayashihi wakoroho li mandingormekwa ri. Unak niri frijip fri ishinak indik usahakwa ri,� karem ormu lirin sawera. ");
INSERT INTO sim_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Urik Jems fre Jon Sebedihi jikisi ovro Jisasik fri raha frimu silira, �Tisa, shir mbele las mirin shi silinak os shi siliwa hom am shiri ukundam?� ");
INSERT INTO sim_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Karem fri silirik ormu silira, �Wa, mberem a ukmbaha si hishindu?� ");
INSERT INTO sim_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Urik frimu mbara, �Kumak os kwambu mihi kormbak si nashinak malakamak mi naha yanga mihik mi liwa wolo shirin halashinak shir nga malakamak shi naka. Halanak shir lar tapmama yok or linak lar tava ashi yok or lika.� ");
INSERT INTO sim_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Karem fri sawerik ormu mbara, �Shir mbeek os shi siliwan hishiyariwa ambu shir. Shir nomorawu os anhik talakwa oson am kishandahi osh? Os jeseng anda uku os a akwa oso am erem andahi osh? Nomorawu os a kishakwa oso ma fak or siwak fa si rasa si sirinda hom nakwa sir. Shir am erem kishandahi osh?� ");
INSERT INTO sim_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Urik frimu mbara, �He, shi kishandahi shir.� Karem fri mbarik ormu mbara, �Ome sira. Nomorawu os anhik talakwa oso shihik er nga talawa sir. Os fa si rasaha si sirishinak a sikwa oso shir er nga shi sikwa sira. ");
INSERT INTO sim_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hako ma ol tapmama anhi yok linak tava ashi anhi yok likwa ma ondo an mbeek a kamakwa ambu nir. Ma ol Avui Wasilaka kamahanda ma ondo nom or mbashinak orok likwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Urik ma 10-pela ondo Jems fre Jon Jisasin fri siliri mashi oson li misihi limu fririn ngriara. ");
INSERT INTO sim_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Urik Jisas lir amber or usharik li ralandirsarik ormu sawera, �Malakama tol misambik linda angop ji heyenda lir. Lir awu awuk li mbashiwak hulaima nokopma lihi siyok li sihi os li mbawa hom unda lir. ");
INSERT INTO sim_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Hako jir erem ji uwa hala! Os jir lar malakamak or nakwak or hishi nahi, wa orhinjik or hafakaha mahi siyok or sika. ");
INSERT INTO sim_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma Jikisi Avui Wasilakahi oto mbeek misambi torok malakamak or nakurik tari ambu ri, wahau. Ma amber jelyaha lihi farniyik or hakurik tari ri. Os erem or unda osik jir erem ji uka.� ");
INSERT INTO sim_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas nga ma ol orin tiyandari ondo nga yanga Jerikok li talaha li irik ma musha mendek orin limu tiya ira. Li ihi misokome tumundari ma lar limu heyera. Ma oto nombo sumbuk or lihi ya mbele mbelenjik lishi silindari ma ria. Hi orhi Bartimeus oria, jikisi Timeushi ria. ");
INSERT INTO sim_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Or lihi nor misirik Jisas Nasaretik fehenda ormu rara. Urik wasilaka mendek ormu ushambara, �Jisas, jinirmbanira Devithi mirin, an wavu mi hishiwa.� ");
INSERT INTO sim_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Karem or mbarik ma ondo olmu orin ngriara, �Mir suwambushi mihin arangoho mayam lika!� Hako indik wasilaka mendek ormu ushambara, �Mir jinirmbanira Devithi mirin, an wavu mi hishiwa.� ");
INSERT INTO sim_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Urik Jisas ormu mbara, �Ma oton ji mbanak or ta.� Karem or mbarik orin limu ushara, �Wavu mihin halashinak kwambuk si na. Usaha i, or mirin ushandu.� ");
INSERT INTO sim_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Urik kolomalok kousamba orhin or tlolo lafakaha Jisasik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Urik Jisas ormu silira, �Mberem a miri ukmbaha mi mbandu?� Urik ormu mbara, �Wasilaka, a heyekmbaha amu hishinduwa.� ");
INSERT INTO sim_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Urik ormu mbara, �Anin mi hishiowenda nombo orok misokome mihi avak jivik nakwa sir. Avak usaha ika.� Karem or mbarik kolomalok misokome orhi si huririk or heyehe nor usaha ormu Jisasin tiya ira. ");
INSERT INTO sim_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas nga ol orin tiyandari ma ondo nga am Jerusalemik li layikurik kuyanga Betfage nga Betani nga op telemba Oliv sumbu orok nandari mishik limu talara. ");
INSERT INTO sim_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Urik orin tiyandari ma frijip ormu mbara, �Kuyanga kasai shi heyewa orok shi ihi shi heyenak donki akri sahanda las os orok kuvuk li ishinak sikwa sir. Donki oso mbeek ma lal mas li lihi yahanda ambu sir. Hako avak kuvun shi sorngoho anjik shi laharaka. ");
INSERT INTO sim_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Unak os ma lal shirin li silihi li mba, �Mberem ushiwak donki oson shi laha indua?� Karem li sili nahi, karem shi saweka, �Wasilaka lerawu nga nor nawa osik or mbashiwak shimu laha ikmba unduwa. Hako lerawu oson or larakoho avak or mbashinak donki oson indiyok shi laharakwa shir.� � Karem or saweshirik frimu ira. ");
INSERT INTO sim_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Fri ihi fri heyerik donki las nombo laka os fri iri yok li ishishirik simu sira. Urik kuvu oson fri sorngoho frimu tolo laha ikmbaha ura. ");
INSERT INTO sim_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Urik ma lal pasir li sihi li heyehe limu silira, �Mberem shi ukmbaha undu, donki oson shi kup sorngowan?� ");
INSERT INTO sim_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Karem li silirik os Jisas fririn or saweri nombo hom frimu sawera. Urik li halashirik frimu laha ira. ");
INSERT INTO sim_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Donki oson fri laha ihi Jisasin frimu hara. Uhu kousamba frihin fri tloloho donki heyek fri eweshirik Jisas mu lawu lira. ");
INSERT INTO sim_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Urik ma musha li talandirsaha kousamba lihin li tloloho nombok limu lere laha ira. Urik ma lal mi tavan li shitlehe olmu er nga nombok lere laha ira. ");
INSERT INTO sim_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Urik lal maifuhu irik lal kumasihi irik Jisas nindik ormu ira. Karem li ihi rupshihi limu mbara, �Hosana, ka ni rupkapshika. Avui Wasilaka avak ma or hi orhik tawa toton armek or ukwa ri. ");
INSERT INTO sim_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Or Avak misumu nihi Devit malakamak or nahanda hom or naha nirin arangoho washilikwa ri. Karem uwosik hi Avui Wasilakahin ni hauoweka.� ");
INSERT INTO sim_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Karem li mbaha Jerusalemik limu tara. Urik Jisas tempel akak or layihi mbele mbele ol aka orok nandan ormu heyera. Hako angop si homirik or halaha ma 12-pela ondon or laha indik yanga Betanik li ihi orok limu wara. ");
INSERT INTO sim_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Li wahandashihi am nirsumbuk si narik yanga Betanin li halaha limu ira. Li ihi Jisas nombok ormu erenghara. ");
INSERT INTO sim_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uhu nor heyerik mi las hi sihi fik, karem li ushandari oso osmu kandakar nga homek siri sir. Mikukwa sihi musha mendek nari sir. Urik mi siji lal si na nahi, nor a, karem mbaha pasir ormu ira. Or i heyeri mbeek mi siji las nga nari ambu sir. Mikukwa nom amba amba nari sir. Hako mbeek akwan si wakuri wolok nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Urik mi oson ormu mbara, �Nyir avak akwa ome nga mbeek nyi wanak ma li nimba akwa ambu nyir, wahau.� Urik ma ol orin tiyandari ondo mashi oson limu misira. ");
INSERT INTO sim_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas nga ma ol orin tiyandari ma ondo nga Jerusalemik li lawuhu tempel aka os inyin li washi arangondari mishi orok limu layira. Li layihi sihi Jisas ma ol orok ya lerawun landarin or heyehe teye os yan li ewehe ananduwarendari teye ondo nga kawu ol li lindari ondo nga or laha normu ermbera. Uhu ma ondo nga or kria ermberik tempel aka hikriyok limu ralara. ");
INSERT INTO sim_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ushihi mbele mbele lihin tempel aka os inyi nga li arangondari mishi orok li laharakurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uhu ormu mbara, �Jekamba Avui Wasilakahik karem li kayeri osa, �Aka anhi oso anin li sawenda mishi sira. Ma ol yanga yangak fehenda aka orok li raha anin li hishiowehe anin li sawenda mishi sira,� karem li kayeri sir. Hako ter os jimu uwak hirnyanda ma lihi aka hom osmu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Urik hetpris nga mashi Moseshin sawendari ma ondo nga mbele mbele os Jisas urin li misihi nombo nombo os orin li mandingormekurin limu mbara. Mberem ushirik? Ma musha angop Jisas saweri mashin misikurik hishiri lir. Uri osik las avak ma amber orin li tiyaku, karem mbaha limu ajera. ");
INSERT INTO sim_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Urik am si homirik Jisas nga ma ol orin tiyandari ondo nga Jerusalemin li halaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Li i wahandaha nirsumbuk indik li ihi mi fik os hinyer Jisas or mbari oson li tikrihi li heyeri mi oso angop hatlayiri sir. ");
INSERT INTO sim_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Urik Pita mashi os Jisas saweri oson or hishihi ormu mbara, �Tisa, mi toson heyewa. Hinyer mashi os mi toson mi mbahanda hom angop hatlayiwa sir.� ");
INSERT INTO sim_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Urik Jisas mu sawera, �Jir avak kwambu mendek Avui Wasilakan ji hishioweka. ");
INSERT INTO sim_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Omendingak jirin amu sawenduwa, os wavu frijip frijip ji hishina ambu nahi, os ji mba, �Telemba nyir usaha fa lakak layika.� Karem ji mba nahi, si usa indahi sir. ");
INSERT INTO sim_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Uhu mbele las Avui Wasilakan sawehe ji mba, �Avak os orin a sawewa hom nakwa sir.� Karem ji mba nahi, os ji hishiwa hom erem nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Uhu Avui Wasilakan ji sawewa wolo mbele kava las os ma lar jirin or uhundan indik ji hishi nahi, jivai mbaka, �Mberem uwana. Am nawa kava sir.� Os karem ji mba nahi, Avui Wasilaka er nga jirin or heyehe kavakava os ji undan avak or laha ermbekwa sir.� ");
INSERT INTO sim_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Urik Jisas nga ma ol orin tiyandari ondo nga indiyok Jerusalemik limu lawura. Uhu Jisas tempel aka os inyi li washi arangondari mishi orok ormu ira. Urik bikpris nga mashi Moseshin sawendari ma ondo nga orok limu tara. ");
INSERT INTO sim_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Li taha limu silira, �Lawe kwambu oson hashiwak lerawun mi landu? Lawe mbashihindak lerawun mi landu?� ");
INSERT INTO sim_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Karem li silirik Jisas mu mbara, �Os mbele las jirin a siliwan armek ji sawenak a misi nahi, an nga vai a sawenak ji misikwa sir, lawe or mbashihindak lerawun a landu. ");
INSERT INTO sim_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ji sawenak a misi, Jon hulaima nokopman fak tolofalendari ma oto lerawun os or lari Avui Wasilaka mbashirik, mo ma misambik fehe mbashirik lerawu oson lari or?� ");
INSERT INTO sim_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Karem or silirik lihi ambek limu mbara, �Mberem ni mbakwa ambu re. Os ni mba, Avui Wasilaka mbashirik lerawun or lari. Karem ni mba nahi, avak or mba, mberem ushirik orin ji misindiyakurin ji halar? ");
INSERT INTO sim_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hako os ni mba, ma misambik fehe mbashirik lerawun or lari. Karem ni mba nahi, ma rondo avak li waplelenaha nirin kavak nakwa ola. Mberem ushiwak? Jon oto profet oria, karem hishinda ola.� ");
INSERT INTO sim_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Karem li mbaha limu mbara, �Nir ni hishiwa kom te!� Urik ormu mbara, �An ngana, an mbeek a sawekwa ambu nir, ma or mbashihindak lerawu toson a lawan.� ");
INSERT INTO sim_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Urik Jisas sauheima las ormu sawera, �Ma lar wain nowe las or larakoho inyin or washi arangoho aka os nowe oson li washilikundari aka nga ormu ura. Uhu wain sijin li jimbresekundari mishin er nga ormu ura. Mbele mbele ondon or urakoho nowe oson ma lalhi tavak or halashihi yanga lasik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uhundarik wain siji ondo am li nivikuri wolok si narik ornjik lerawun landari ma lar or mbashirik ornjik lal or nimba laharakmbaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hako nowe oson washilindari ma ondo orin er li jihi li mbashirik indiyok tapas ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Urik hovok ma ome lar or mbashirik ormu ira. Or irik or er nga li jimartloho li mbashirik indiyok ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Urik hovok ma anandi lar nga or mbashirik ormu ira. Or irik orin li jihi er li mandingormeri ria. Karem urik hovok ma mushak or mbashirik limu ira. Urik erem li jiri lir. Ma lal men li jiri lir. Hako lal li jimandingormeri lir. ");
INSERT INTO sim_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Orokop noumashama lerawu orhin landari ma amber li mandingormeshirik or lihi ormu hishira, �Jikisi anhi namtar numbu tor a rupshindan avak a mbashinak or inak mashi orhin misikwa lir.� Karem or hishihi nor mbashirik ormu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Or irik nowe oson washilindari ma ondo li heyehe limu mbara, �Noumashama jikisi orhi indingo ormu tanduwa. Hako ka ni i orin ni mandingormehe mbele mbele orhi ondon hiniyin ni oka.� ");
INSERT INTO sim_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Karem li mbaha orin li jimandingormehe maninimba orhin li kishalayi hikriyok limu ermbera.� ");
INSERT INTO sim_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas sauheima oson or sawerakoho ma ol orok lirin or heyehe ormu mbara, �Mberem ji hishindu, noumashama oto kumak or taha ma ondon mberem orvai mbaku? Avak or taha ma kava tol nowe roson washilinda rondon or mandingormehe nowe oson avak ma anandi lalhi tavak or hakwa sir. ");
INSERT INTO sim_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mashi os jekamba Avui Wasilakahik li kayehendarin heyenda ambu oj? Karem li kayeri sir, ");
INSERT INTO sim_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","�Sunja ma akan unda, kava, karem li hishihi li ermberi sir. Hako wahau, angop wormbonawa hom maifuk ormu sinduwa. Wasilaka vai oson or unak ni heyenak jivik nakwa sir.� � ");
INSERT INTO sim_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas sauheima oson or sawerik Farisi ondo nga mashi Moseshin sawendari ma nga limu misira. Mashi oso sayi hom lirin jiri sir. Urik sunguwavu lihi kavak er nari sir. Urik Jisasin li tolokmbaha limu ura. Hako ma musha mendek orok li lishirik li ajehe er li halaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Urik Judama lida lihi li mbashirik Farisi ma lal nga Herothi ma lal nga Jisasik li taha li mbanak or mbanak li heyekmbaha limu rara, os mashi las or mbanak kavak si na nahi, mashi orok orin li toloho li kotim ukmbahan. ");
INSERT INTO sim_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Li raha Jisasin limu mbara, �Tisa, nir ni heyewa, mir mashin omendingak sawenda mira. Mir mbeek malakama ondon ajehe lirin hokovikmbaha mashin sawenda ambu mir. Malakama nga erndakava nga Avui Wasilakahi mashin nakrem er sawenda mira. Uwosik ni raha mirin nimu silinduwa, mir mberem mi hishindu, os takis yan Romik fehenda malakama lihi Sisar oton ni ha nahi, jivi os mo kava os?� karem limu silira. ");
INSERT INTO sim_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hako Jisas angop or heyeri sir, os orin li oweioweiheyekmbaha li rari oson. Uri osik ormu mbara, �Mberem ushiwak anin ji oweioweiheyekmbaha torok ji raw? Hako ya las ji laharanak a heye na sawenak ji misika.� ");
INSERT INTO sim_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Karem or mbarik ya las li harik ormu silira, �Ya roso lawehi fumunyava nga lawehi hi nga si nandu?� Urik limu mbara, �Sisarhi ambe vria.� ");
INSERT INTO sim_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Urik ormu mbara, �Mbele mbele ol Sisarhi ondo indiyok orin ji haka. Hako mbele mbele ol Avui Wasilakahi ondo indiyok orin ji haka.� Karem or mbarik mashi oson li misihi limu lishnya mendera. ");
INSERT INTO sim_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Judama lal Sadyusi, karem li ushandari ma karem hishindari lir, ma ol hahandari ondo mbeek indiyok usahakwa ambu lir. Karem uhu Jisasik li raha orin limu silira, ");
INSERT INTO sim_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","�Tisa, mashi os mas Moses nirin or kayehendari karem sawendari sir, �Os ma lar jikisi nga nor na namber or hashinak maha orhi lar mumbla oson or ewehe jikisi nga fri nawa, tlavu ji oto sanjelaka or hahanda orhik nakwa ri.� Moses karem or kayeri sir. ");
INSERT INTO sim_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hako misi, mas mahasanje 7-pelak lindari lir. Uhu sanjelaka nokove las or laha jikisi nga na namber hari ri. ");
INSERT INTO sim_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ushirik maha orhi mu mumbla oson or ewehe mbeek jikisi nga fri na namber or hashirik orhi hindiyashi mu nokove oson lara. Uhu or er nga hari ri, mbeek jikisi nga nari ambu vria. ");
INSERT INTO sim_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Orokop mahasanje 7-pela ondo nokove oson li laha mbeek jikisi nga nari ambu lir. Ushirik amber li hashirik nokove oso nga simu hara. Uhu mbeek jikisi nga nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hako avak mi mbanak ni misika, ma ol hahanda kumak indik li usahana wolo nokove oso avak lawehik sivai naku? Mahasanje ondo amber sirin lari ola.� ");
INSERT INTO sim_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Karem li silirik Jisas mu sawera, �Jir mbeek mashi os jekamba Avui Wasilakahik li kayendari nga kwambu orhi nga heyekrahakoronda ambu jir. Uwosik os jimu surunduwa. ");
INSERT INTO sim_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ma ol hahanda indiyok li usahakwa wolo mbeek hulasihi nokoplakwa ambu lir. Lir avak ensel ol yanga jivik fehenda ondo hom nakwa lir. ");
INSERT INTO sim_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hako os ma hahanda indiyok li usahakwa ambu, karem ji hishi nahi, wa anin ji sawenak a misi, mashi las Avui Wasilakahi jekambak mberem li kayer? Karem li kayeri osa, �Avui Wasilaka orhinjik ormu mbara, �An God Abrahamhi, Aisakhi, Jekophi, lihi God anira,� karem Wasilaka mu mbara.� ");
INSERT INTO sim_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Abraham, Aisak, Jekop lir angop maskop hari lira. Hako masikome lihi ol Avui Wasilaka nga lindu. Mashi os or mbari oso mu nirin kormbak mukunduwa, Avui Wasilaka mbeek ma ol hahanda lihi God ambu ri. Or God ma ol er linda lihi God oria. Uwosik os ma hahanda indik li usahakwa ambu, karem ji hishi nahi, os jimu mbele mendenduwa.� ");
INSERT INTO sim_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Urik mashi Moseshin sawendari ma lar or taha nor misirik Jisas nga Sadyusi ondo nga limu mbahanjira. Uhu or misirik Jisas saweri mashi oso jivi mendek si narik ormu misira. Uhu Jisasin ormu silira, �Mberemhi lo os maifuk naha lo anandin tikrindu?� ");
INSERT INTO sim_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Urik Jisas mu sawera, �Lo maifu mende kas amu sawenduwa. Jir yanga Israelik fehenda ma jirin, mashi kason yawur ji misika. God nihi namtar numbu, Avui Wasilaka mende ria. ");
INSERT INTO sim_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Avak orin wapnuku jihik ji eweka. Uhu avak sunguwavu jihi nga masikome jihi nga hishiyarinda jihi nga lerawu os ji lahanda kwambu jihi nga avak orin er ji haka. Lo maifu mende kasira. ");
INSERT INTO sim_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lo nindisik sinda oso karem, jir avak ma anandin ji rupshika, os jihinjik ji rupshinda hom. Lo ovro mende nom lo anandi amber ondon tikrihi wasilakak nanda vri.� ");
INSERT INTO sim_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Karem or mbarik ormu mbara, �Tisa, mashi os mi sawewa oso jivi mende sira. Omendinga sira, Avui Wasilaka namtar nom God nihi oria. ");
INSERT INTO sim_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uhunda osik nir avak orin wapnuku nihik ni eweka. Uhu sunguwavu nihi nga masikome nihi nga hishiyarinda nihi nga lerawu os ni lahanda kwambu nihi nga orin ni haka. Uhu ma anandin ni rupshika, os nihinjik ni rupshinda hom. Os mashi oson ni tiyaha erem ni u nahi, nombo oso jivi mende sira. Uhu nombo os mbele mbelen Avui Wasilakanjik li handa nga os li lai ofan li suwunda nga tikrinda sira,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas mashi oson or misihi ormu mbara, �Mashi os mi mbawa oso jivi sira. Mir angop pasir Avui Wasilakahi krahak sikwak nawa mira.� Urik ma amber mashi oson li misihi mbele las Jisasin li silikurin limu ajera. ");
INSERT INTO sim_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Urik Jisas tempel aka orok or lihi mashin or sawehe ormu silira, �Mberem ushiwak ma ol Moseshi mashin sawendari ma ondo karem li mbandu, Krais king Devithi nirambarak nakwa ri? ");
INSERT INTO sim_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hako Masikome Avui Wasilakahi Devitin or sauharik mashin karem or kayeri sir, �Avui Wasilaka Wasilaka anhin, karem saweri ri, �Mir tapmama anhik lika. Ushinak wutari mihi ondon avak a halashinak mihi siyok sikwa lira.� � ");
INSERT INTO sim_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ji misi, Devit orhinjik karem mbari ri, �Krais Wasilaka anhi ria.� Karem or mbari sir. Os erem si na nahi, mberem ushiwak Krais nirambara Devithi, karem li mbandu?� Jisas mashin or ewesawerik, ma musha mashi orhin li misikmbaha limu rupshira. ");
INSERT INTO sim_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Urik ormu lirin sawera, �Ma ol mashi Moseshin sawendari ma ondon ji auheyeka. Lir kowe hombelakan li falehe ma tirsanda mishik li inak ma li heyehe hi lihin li hauowekmbaha hishinda lir. ");
INSERT INTO sim_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lir men malakak li nakwak hishinda lir. Uhu os li lotu unda wolo nga hiyawu wasilakan li uanda wolo nga maifuk li sinak ma li heyekmbaha hishinda lir. ");
INSERT INTO sim_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Uhu nokove ol mumblak wahayanda ondon li haimba handambaha mbele mbele lihin landa lir. Uhu os Avui Wasilakan li sawewa wolo hombelaka mendek li sawenak ma li heyehe li mba, �Ma tondo Avui Wasilakahi ma indingo lira.� Karem li mbakmba hishinda lir. Erem li unda osik kumak Avui Wasilaka man or heyembakwa wolo lirin avak nomorawu wasilaka menden or hakwa lira. Hako jir nombo os li liyawa lihi oson ji tiyawan ji hala!� ");
INSERT INTO sim_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Urik Jisas tempel akak os yan li ewendari mishik ormu lira. Uhu or heyerik ma li raha yan Avui Wasilakanjik bokis orok limu ewera. Uhu ma ol ya mushak nandari ya musha mendek oweri lira. ");
INSERT INTO sim_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hako mumbla kava las si taha ya frijip nom osmu ewera. ");
INSERT INTO sim_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Urik Jisas oson or heyehe ma ol orin tiyandari ondon ormu sawera, �Omendingak jirin amu sawenduwa, mumbla toso ya wasilaka mendek hawa sira. Ya op si hawa ma anandi ondo hawan tikriwa sir. Mberem ushiwak? ");
INSERT INTO sim_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sir mbeek ya lal nga aka sihik wawa ambu lir. Ya kanda op wawa ambehoma, op simu ewewa. Hako ma ol ya mushak ewewa ondo laltonom li ewewa lir. Lal lihi olmu akak wanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas tempel akan or halakmbaha nor urik orin tiyandari ma lar ormu mbara, �Tisa, tempel aka toso jivik nawak amu heyenduwa. Sunja wasilakakop li uhunda sira.� ");
INSERT INTO sim_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Karem or mbarik Jisas mu mbara, �Mir tempel aka wasilaka toson mimu heyembandu mo? Misi, aka mbele mbele tol ji heyewa tondo kumak avak li jilatarvlarakokwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Karem or mba lafakaha telemba Oliv orok or lawu lihi tempel akan ormu limara. Urik Pita, Jems, Jon, Andru, lirtonom orhik li taha limu silira, ");
INSERT INTO sim_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","�Mbele mbele ol mi sawewa ondo mbele wolo mendek li talanak nivai heyeku? Mberem si nanak ni heyehe ni mbaku, mbele mbele ol Jisas mbahanda li ralakwa wolok osmu nanduwa?� ");
INSERT INTO sim_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Urik ormu sawera, �Jir avak ji auheyehe ji lika. Las avak ma lal li raha jirin li haimba handambanda ngashi. ");
INSERT INTO sim_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ma musha avak li raha hi anhik karem mbakwa ola, �An Krais anira.� Karem li mbaha ma mushak haimba handambakwa ola. ");
INSERT INTO sim_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uhu kumak avak ji misinak yanga yangak awun ukwa lir. Unak maintama nga awu hukwa nga mamblakop ji misikwa sir. Hako ji ajewa hala! Mbele mbele ondo masmas talakwa lir. Hako misambi nga lersuwu nga mendek fri nakwa wolo os akrik. ");
INSERT INTO sim_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kraha las hovok kraha anandi lasik fehe nga anajikwa lira. Unak kuyanga lal avak nenawu si jinak, kuyanga lal erenghambar likwa lir. Mbele mbele ondo li talawa wolo oso os nokove jikisin si wakwak si kumanhava jinda hom nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","�Oro wolok jihinjik ji auheyeka. Avak li kotim ukwa jir. Uhu jirin li laha li lotu unda mishik li owehe li jikwa jir. Mberem ushiwak? Jir angop mashi anhin ji misihi ji tiyanda osa. Hako os malakama lihi misokomek li eweshinak ji si nahi, mashi anhin lirin ji saweka. ");
INSERT INTO sim_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","11","Hako jirin li toloho majistrethi tavak li ewewa wolo wavu jihik ji hishihi ji mba, �Ayo, mberem mberemhi mashin avak ni saweku?� karem ji hishihi ji ajewa hala. Oro wolok Avui Wasilaka Masikome orhi jirin or jelyashinak mashi anhin sawekwa jir. Hako lersuwu nga misambi nga mendek fri nakwa os akrik. Unak mashi anhin yanga yangak ji laha sawe inak ma amber li mistakokwa sir. Li mistakonakop lersuwu nga misambi nga mendek nakwa vri. ");
INSERT INTO sim_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kumak avak ma lar mahasanje orhin wutarihi tavak or halashinak li mandingormekwa ri. Avoko jikisi orhin erem ukwa ri. Jikisi erem, avoko nijava orhin erem ukwa ri. ");
INSERT INTO sim_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jir angop anhi mak nahanda osik ma amber avak jirin wapkava hishikwa lir. Hako os mashi anhin ji misihi kwambuk ji sitambananda nahi, kumak avak Avui Wasilaka indik or lakwa jir.� ");
INSERT INTO sim_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Uhu mashi las nga ormu mbara, �Kumak avak ji heyenak, mbele mbele kava indingo las os li lotu unda mishi orok si sinak ji heyekwa sir. Oro wolok ma ol provins Judiak linda ondo kolok telembak li tuluhu ika. Ma jir ol mashi kason ritim uwa ma ondo jihinjik ji auheyeka. ");
INSERT INTO sim_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","Ma or aka hikriyok liwa akak or layihi mbele mbele orhin or lawan or halaka! Ma or nowek liwa erem, indik aka orhik or ihi kowe orhin or lawan or halaka! ");
INSERT INTO sim_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kavasumba, nokove ol masam nomok nawa nga ol jikisin mukhawa nga! Mberem livai tulu iku? ");
INSERT INTO sim_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Uwosik Avui Wasilakan ji sawenak nomorawu os si talanak ji tulu ikwa wolo ma rakanda wolok si nawan si halaka. ");
INSERT INTO sim_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nomorawu os talakwa oso wasilaka mendek nakwa sir. Misambi toso nari wolok sishi rara ter wolo nga mbeek oso himi kas talari ambu sir, wahau. Ihi kumak erem, mbeek oso himi kas indik talakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Os Wasilaka nomorawu oson or halashinak nambe mendek er si na nahi, ma amber harakokwa lir. Hako ma ol orhinjik or kamahandanjik or hishihi or mbanak nindik mendek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Oro wolok os li sawehe li mba, �Ji heyeka, Krais tor torok lindu. Hako ji heyeka, katai karok lindu!� Os erem li sawewa mashi lihin ji misiwa hala! ");
INSERT INTO sim_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mberem ushiwak? Oro wolok ma mushak li raha karem mbafirimbakwa ola, �An Krais anira,� lal karem mbakwa lira. Uhu lal nga avak karem mbakwa lira, �An profet lar anira.� Karem li mbaha ma undahi ambu ondon li uhu man haimba handambakwa ola. Uhu Avui Wasilakahi krahak sinda ma ondo er nga li laha ikwak hishikwa lir. Hako mberem li laha indahi ambu. ");
INSERT INTO sim_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Karem uwosik ji auheyeka! Mashi angop a sawewak ji misiwa sir, mbele mbele amber ol talakwa ondon.� ");
INSERT INTO sim_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Uhu mashi las nga ormu mbara, �Nomorawu oso am mendek si nanak ta avak or tormblehe nirtle sirinda hom nakwa ri. Unak niyaka avak ukwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Unak tashingra avak misambik ngongo rakakwa lir. Unak lersuwu avak nenawu jinda hom lishirikwa sir. ");
INSERT INTO sim_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Uhu oro wolok ma amber li heyenak, Ma Jikisi Avui Wasilakahi avak or taha kwambu orhi nga ukruharanda orhi nga lersuwu yok rakakwa ri. ");
INSERT INTO sim_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Uhu ensel orhi ondon or mbashinak misamsumbu lersuwusumbu yok yok li ihi orhi ma ol or kamahanda ondon lahara tirsakwa lira.� ");
INSERT INTO sim_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Uhu mashi las nga ormu mbara, �Mi fik oson angop ji heyenda osa. Am si shorngo hanyiwak ji heyehe karem mbanda jir, ta am or jikwa wolok osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Unda hom mbele mbele nomorawu ondo li talanak ji heyehe karem ji hishika, Ma Jikisi Avui Wasilakahi oto indiyok or rakwa wolo osmu pasir nanduwa. ");
INSERT INTO sim_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Omendingak jirin amu sawenduwa, ma ol ter liwa lihi lal li ha namber mbele mbele ondo ralakwa lir. ");
INSERT INTO sim_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Misambi nga lersuwu nga mendek nakwa vri. Hako mashi anhi kaso mbeek mendek nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","�Ma lar mbeek mbele mbele ondo os li ralakwa wolon heyenda ambu ri. Mbele wolo mendek ondo talakundal mbe? Ensel yanga jivik fehenda ondo mbeek heyenda ambu lir. Jikisi Avui Wasilakahi nga mbeek oson or heyenda ambu ri. Avui Wasilaka nom tolonda sir. ");
INSERT INTO sim_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ji auheye ji lika! Jir mbele mbele ondo ralakwa wolon ji heyenda ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Uhu sauheima las nga ormu mbara, �Aka mashama lar aka orhin or halaha yanga lasik or ikuna wolo ornjik lerawun landa ma ondon or saweshinak mbele mbele orhin washilikwa lira. Uhu lir namtarmba namtarmbak lerawun or humasishinak lakwa lir. Uhu ma or akayangan washilinda ma orton or mbashinak akayangan armek washilikwa ri. ");
INSERT INTO sim_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Uhunda hom jir erema. Yawur ji auheyeka! Mberem ushiwak? Jir mbeek os aka mashama orto indiyok or takwa wolon heyewa ambu jir. Hominak takundar mo, nirkundik takundar mo, nirsumbuk takundar? Wa jir mbeek oson heyewa ambu jir. ");
INSERT INTO sim_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Las avak kolok lewas or ta heyenak jir ji wa suknyanda ngashi. ");
INSERT INTO sim_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Uwosik ji auheyehe ji lika. Mashi tos ter jirin a sawewa mashi toso avak ma amber erem a sawekwa sir.� ");
INSERT INTO sim_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Bikpris ondo nga ma ol mashi Moseshin sawendari ma ondo nga Jisasin li jimandingomekuri nombon li hishihi limu mbara, �Wa mberem nivai uku? Humnyanak hiyawu Pasova nga hiyawu Bret Yis Ngashi Ambu oson ni unda wolok nakwa sir. Os oro wolok orin ni jimandingorme nahi, ma li heyehe awun li unda ngashi,� karem li mbaha limu halara. ");
INSERT INTO sim_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas kuyanga Betanik or ihi Saimon or mas okmbale lepra tolondari ma otohi akak ormu lira. Orok or lihi akwan li arik nokove las uku arme kuvasahandari ya lakak li lahandari oson botolik si toloho osmu laharara. Uhu uku oson si hervaha Jisashi masijik simu ngorora. ");
INSERT INTO sim_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Urik ma ol orok liri ondo li heyehe lihi lal wavu lihi kavak si narik lihi ambek limu mbara, �Ayo, mberem ushiwak uku arme kuvasahanda oson si ngorosambundua? ");
INSERT INTO sim_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Osokop am si halashiwak ni lai ewewak ma ya mushak li frungawushiwak ya oson ni laha erndakava ondon ni hawa os te!� karem limu sirin ngriambara. ");
INSERT INTO sim_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Urik Jisas ormu mbara, �Sirin ji ngriawa ji hala! Os anin erem si uwa oso jivi sira. ");
INSERT INTO sim_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Erndakava ondo ermba ermbak jir nga likwa lir. Os mbele lal lirin ji hakmbaha ji hishi nahi, kumak jivai haka. Hako an mbeek ermba ermbak jir nga na likwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nokove toso mbele mbele am si ukwak si hishihi si uwa sir. Os si uwa oso kumak an hakundan si hundujewa sir. ");
INSERT INTO sim_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Omendingak jirin amu sawenduwa, kumak yanga yangak mashi jivi anhin li laha sawehe os si unda nga li sawenak ma amber li misihi sirin hishikwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariot Jisasin tiyandari ma 12-pela lihi lar oria. Oro wolok or ihi bikpris ondon or i heyehe Jisasin lihi tavarenjek or hakurik ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Urik mashi orhin li misihi li rupshihi ya lal orin li hakurik limu mbara. Ushirik nombo nombo os Jisasin or hakurin ormu li hishira. ");
INSERT INTO sim_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Judama hiyawu Bret Yis Ngashi Ambun li andari wolok si naha sipsipin li jihi ofa hom li hakmbaha li hundujeri wolok si narik Jisasin tiyandari ma ondo li raha orin limu silira, �Wa aka mbeek hiyawu toson ni uhu aku?� ");
INSERT INTO sim_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Karem li silirik Jisas mu sawera, �Wa, jihi lap kolok taunik fri ika! Fri ihi ma lar avak fri heyekwa ri. Ma orto awu las uku nga or kisha inak orin fri tiya ika. ");
INSERT INTO sim_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Fri tiya ihi aka os or layiwa mishi aka orok er nga fri layihi aka mashama orton fri silika karem, �Tisa karem or mbawa, an nga ol anin tiyanda ma ondo nga hiyawu Pasovan ni akwa mishi mbeei?� ");
INSERT INTO sim_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Karem fri silinak aka mashama orto avak fririn or laha li lawuhu os ni akwa mishin or mukushinak fri heyekwa sir. Mbele mbele angop li hundujerakowa sir. Hako frir akwa nom hundujekwa vri.� ");
INSERT INTO sim_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ushirik fri ihi fri heyeri mbele mbele ondo os Jisas mbari hom er narakori lir. Ushirik akwa nom frimu hundujera. ");
INSERT INTO sim_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Am si homirik Jisas nga ma ol orin tiyandari ma ondo nga aka orok limu ira. ");
INSERT INTO sim_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Am li lihi aha Jisas mu mbara, �Jir lar avak anin tavarenje wutarihik hakwa ri. Ma oto an nga nakrem shimu anduwa.� ");
INSERT INTO sim_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Karem or mbarik sunguwavu lihi kavak si narik li holoho limu mbara, �Wa anin mi mbandu mo?� ");
INSERT INTO sim_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Urik ormu mbara, �Jir ma 12-pela jihi lar avak anin tavarenje wutarihik hakwa ria. Ma orto an nga nakrem hambiya namtaskop shimu anduwa. ");
INSERT INTO sim_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Omendinga sira, Ma Jikisi Avui Wasilakahi avak hakwa ri. Angop maskop mashi las erem li kayehendari osik avak hakwa ri. Hako ma or orin tavarenje wutarihik hakwa ma orto or holoka. Avak kavak nakwa ri. Mbele lakmbaha nijava orhi orin si war? Si wahanda ambukop jivik nawa sir.� ");
INSERT INTO sim_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Os li ari wolok Jisas bret las or laha Avui Wasilakan armek or mbaha ormu sawera. Uhu bretin or toltavaha ol orin tiyandari ma ondon ormu hara. Uhu ormu mbara, �Ji laha aka, kaso maome anhi kasira.� ");
INSERT INTO sim_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ushihi wain uku oson hambiyak or laha indik Avui Wasilakan armek or mbaha lirin or harik limu ara. ");
INSERT INTO sim_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Urik ormu sawera, �Kaso fi anhi kasira. Fi anhi kason na ngoroshinak hulaima nokopman si jelyakmbahan. Fi anhi kaso suma akrin jir nga Avui Wasilaka nga tivikwa sira. ");
INSERT INTO sim_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Omendingak jirin amu sawenduwa, an mbeek wain ukun indik a akwa ambu nir. Hako ihi nom kumak yanga Avui Wasilakahikop wain uku akrin a akwa nir.� ");
INSERT INTO sim_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Karem or mbaha hukwa las li koroho yanga oson li halaha telemba Oliv orok limu lawura. ");
INSERT INTO sim_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ma ol orin tiyandari ondon ormu sawera, �Mas karem li kayeri sir, �Avui Wasilaka avak sipsipin washilinda man or jishinak sipsip orhi amber tuluhu ikwa lira.� Karem li kayeri mashi oso ter osmu omendingak nanduwa. Jir amber avak anin halaha tulu ikwa jir. ");
INSERT INTO sim_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","An avak a hakwa nir. Hako indiyok a usaha masmas yanga Galilik a inak jivai raka.� ");
INSERT INTO sim_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Karem or mbarik Pita mu mbara, �Os ma ondo amber mirin li hala nahi, an mbeek mirin a halakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Urik Jisas mu orin sawera, �Omendingak mirin amu sawenduwa, ter nirik aptoko hindi frijip or mba namber, mir avak hindi nalmingrip anin mi heyenda ambu, karem mbakwa mira.� ");
INSERT INTO sim_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Karem or mbarik Pita kwambu mendek ormu mbara, �Wahau te. An mbeek erem a mbakwa ambu nir. An mir nga er shi hakwa shir te!� Urik Jisasin tiyandari ma amber mashi os Pita mbari hom olmu mbara. ");
INSERT INTO sim_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas nga orin tiyandari ondo nga yanga Getsemanik limu lawura. Uhu lirin ormu mbara, �Jir torok ji linak a lawuhu Avui anhin a saweka.� ");
INSERT INTO sim_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Karem or mbaha Jems, Pita, Jon ondo nom or laha limu ira. Li ihi sunguwavu orhi nga or hishiri kava mendek simu nara. ");
INSERT INTO sim_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Uhu ma ondon ormu mbara, �Sunguwavu anhi kavak si nawak am a hakwa mendek amu hishinduwa! Jir avak torok ji lihi an nga nakrem ni lika.� ");
INSERT INTO sim_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Karem or mbashihi kandakar nga or ihi misambik or taka waha Avui orhin ormu sawera. Unak nomorawu os orhik talakuri orin si wasisokmbahan. ");
INSERT INTO sim_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Uhu karem ormu mbara, �Avuya, os nombo kas na nahi, nomorawu anhik talakwa oson halanak anin si wasisoka. Hako os an mbawa hom uwa hala. Os mi hishiwa hom uka.� ");
INSERT INTO sim_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Karem or mbashihi indik or ihi ma nalmingrip ondon ormu i heyera. Or i heyeri olmu suknyara. Urik Pitan ormu silira, �Saimon, mimu suknyandu? Mir an nga kandakar shi likwa ambu om? ");
INSERT INTO sim_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mir avak lihi Avuin saweka. Las avak jeikayenda mihik si talanak mi tukuyinda ngashi. Wavu yoko jihi jip ukwak hishinda sir. Hako maome mbeek kwambu nga nanda ambu sir.� ");
INSERT INTO sim_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Karem or mbaha indiyok or ihi Avuin ormu sawera, os mas or saweri hom. ");
INSERT INTO sim_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ushihi indiyok ma nalmingrip ondon heyekurik ormu rara. Or ta heyerik olmu suknya ambasira. Misokome lihi tumtamuri sir. Lir men suknyakurik hishiri lir. Uri osik mberem li maimbakuri ambu. Urik indiyok or ihi Avui orhin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Or saweshihi indiyok ormu rara. Or i rari oso hindi nalmingrip nari lir. Uhu normu mbara, �Jir armek er jimu waha suknyanduwa? Ambehoma, os talakmbaha a mbahanda oso osmu talanduwa. Ma Jikisi Avui Wasilakahin avak li laha ma kavahi tavak li hakwa ri. ");
INSERT INTO sim_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ji usaha ni ika. Ma or anin tavarenje wutarihik hakwa oto ormu tanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas mashin or saweri halanganga kolok Judas mu rara. Judas ma 12-pela ol Jisasin tiyandari ma lihi lar oria. Or tarik ma mushak bainat nga kombe nga li kishaha olmu er nga tara. Bikpris nga mashi Moseshin sawendari ma nga Judama lida lihi nga li mbashirik limu tara. ");
INSERT INTO sim_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas mas lirin or sawehe karem mbari ora, �Ma or a i heyehe na makshitakshinak ji heyewa oto Jisas oria. Unak orin ji i toloho er ji laha ika.� ");
INSERT INTO sim_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Karem or mbahandari osik nombok Jisasik or ihi ormu mbara, �Tisa!� Karem or mbaha ormu makshitakshira. ");
INSERT INTO sim_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Erem or urik li heyehe Jisasin limu tolora. ");
INSERT INTO sim_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Urik ma lar or lir nga pasir siri oto oson or heyehe bainat orhin or longoho ma or hetprisnjik lerawun landari ma mambla orhin or shinjesera. ");
INSERT INTO sim_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Urik Jisas mu mbara, �Jir bainat nga korme nga ji laha anin tolokmbaha jimu randuwa? Wa, an awun unda ma lar on? Mo hirnyanda lar on? ");
INSERT INTO sim_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ermba ermbak tempel aka orok mashi Avui Wasilakahin a sawenda nir. Oro wolok anin ji tolondari mberem ji mbar? Ambehoma. Mashi Avui Wasilakahi mas li kayeri ter osmu omendingak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Karem or mbarik ol orin tiyandari ma ondo amber orin li halaha er limu tulu ira. ");
INSERT INTO sim_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Urik jikanda lar mu Jisasin tiya ira. Jikanda oto waskowarmba las faleri ri. Or tarik ma ondo orin li tolokmbaha limu ura. ");
INSERT INTO sim_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hako waskowarmba nom li toltloloshirik serembomban or kishaha ormu tulu ira. ");
INSERT INTO sim_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Urik Jisasin hetprishi akak limu laha ira, os bikpris nga mashi Moseshin sawendari ma nga Judama lida lihi nga li tirsaha li liri mishi orok. ");
INSERT INTO sim_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Urik Pita lirin lundiya iri ri. Hako kandakar nga homehik or raha hetprishi akanivik or raka lihi ormu hiwalora. Or hiwalorik ma ol hetprisin washilindari ma ondo er nga limu lira. ");
INSERT INTO sim_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Urik bikpris nga Judama lida lihi nga nombo os Jisasin li mandingormekurin limu lasara. Os mbele las or uhunda kavak si nanak li heye nahi, orin livai jimandingorme, karem limu mbara. Hako mbeek mbele kava las or urin li heyeri ambu. ");
INSERT INTO sim_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Urik ma musha mendek li raha Jisasin limu haimba handambara. Hako mashi os li mbari mbeek nakrem nari ambu sir, wahau, apsham apsham nari sir. ");
INSERT INTO sim_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Urik ma lal li sihi karem olmu haimba handambara, ");
INSERT INTO sim_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","�Jisas oto karem or mbarik ni misiri sir, �Tempel aka os ma uhunda oson avak a tarvlakwa sir. Oson a tarvlashihi niri frijip fri ishinak anandi las a ukwa sir. Tempel aka akri os a ukwa oso mbeek ma tavak a ukwa ambu sir.� Karem or mbarik angop ni misiri sir,� karem limu mbafirimbara. ");
INSERT INTO sim_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hako mashi oso er nga nakremkop li mbari ambu sir, apshamba apshambak li mbari sir. ");
INSERT INTO sim_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Urik hetpris oto malakama ondohi nindik or sihi Jisasin ormu silira, �Mir mashi las mbakwa ambu om? Mashi kason mirin li mbawan am mimu misindu?� ");
INSERT INTO sim_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Karem or silirik Jisas mbeek mashi las mbari ambu ri. Urik hetpris oto indiyok ormu silira, �Mir Avui Wasilaka hulaima nokopman jivinakmbaha nor kamahanda ma om? Mir jikisi orhi om?� ");
INSERT INTO sim_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Urik ormu mbara, �He antonom a. Kumak ji heyenak Ma Jikisi Avui Wasilakahi oto Avui Wasilakahi tapmama yok or lihi kwambu orhi nga lersuwu yok or rakanak ji heyekwa ri.� ");
INSERT INTO sim_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Karem or mbarik hetpris oto or lishnyafaha sunguwavu orhi kavak si narik kowe orhin ormu tolfrehera. Uhu normu mbara, �Ambehoma, mbeek ma lar ni mbanak ta mashi las sawekwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Angop ji misiwa sir. Toto Avui Wasilakan okolembawa ri. Hako mberem ji hishindu? Mberem ni orin uku?� Urik ma amber limu mbara, �Avui Wasilakan or okolewa osik halanak or haka.� ");
INSERT INTO sim_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Urik ma lal orin limu suntlayashira. Uhu koutakrik misokome orhin li tivi arangoho tava kombek orin limu jira. Uhu limu silira, �Mir kolok mbanak ni misi, lawe mirin jindu?� Urik tempel akan washilindari ma ondo er nga orin li jimblalanaha orin limu laha ira. ");
INSERT INTO sim_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pita hetprishi aka nivik ormu hiwaloho lira. Urik nokove las, hetprishi akak lerawun landari, si taha Pitan akanivi orok si heyehe simu mbara, �Mir Jisas Nasaretik fehenda oto nga yanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Karem si mbarik ormu mbara, �Mashi os nyi mbawa amu hishandu.� Karem or mbaha hikrik or tala irik aptoko maifuk ormu mbara. ");
INSERT INTO sim_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Urik nokove oso Pitan indiyok si heyehe ma ol er nga pasir siri ondon simu sawera, �Ma tor torok siwa toto Jisas nga liyanda ma lar oria.� ");
INSERT INTO sim_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Karem si sawerik indik ormu mbara, �Wahau, an nga nembes te!� Urik ma ol orok siri ondo limu mbara, �Mir Galilik fehenda ma lar mira. Mir lihi lar mira. Ome sira.� ");
INSERT INTO sim_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Karem li mbarik mainkwambuk ormu mbara, �Omendingak amu sawenduwa, ma or ji mbawa oton a heyenda ambu nir. Os omek a mbana ambu nahi, halanak Avui Wasilaka anin kavak or uka!� ");
INSERT INTO sim_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Karem or mbarik aptoko indik ormu mbara. Urik mashi os Jisas mbari mashi oson Pita indik ormu hishira. �Aptoko hindi frijip or mba namber, mir hindi nalmingrip karem mbakwa mir, An Jisas oton na heyenda ambu nir. Karem mbakwa mir.� Karem or mbari mashi oson indik or hishihi kavakavan ormu tlara. ");
INSERT INTO sim_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Urik nirsumbu mendek bikpris nga Judama lida lihi nga mashi Moseshin sawendari ma nga amber ol maifuk sindari ma ondo li tirsaha Jisasin li jimandingormekuri mashin limu mbara. Uhu Jisasin malakama Romik fehenda otohik li laha ikmbaha limu mbaolsolora. Karem ushihi kuvu las li laha Jisashi tavan li ishihi Pailatik limu laha ira. ");
INSERT INTO sim_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Urik Pailat Jisasin ormu silira, �Mir King Judamahi om?� Urik ormu mbara, �Os mi mbawa homa.� ");
INSERT INTO sim_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Urik bikpris ondo mashi kava musha mendek Jisasin limu mbahanjira. ");
INSERT INTO sim_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Urik Pailat Jisasin indiyok ormu silira, �Mashi kas nga mbakwa ambu om? Mir mashi kason li mbawa am mimu misindu?� ");
INSERT INTO sim_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Karem or silirik Jisas mbeek mashi las nga mbari ambu ri. Urik Pailat wavu orhi mushak ormu hishira. ");
INSERT INTO sim_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Asama asama Judama ondo hiyawu wasilakan li undari wolo Pailat ma ol krawuk sindari lar or halashirik indari ria. Judama lihinjik ma or li rupshindari oton li mbashirik or halashirik indari ora. ");
INSERT INTO sim_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oro wolok ma lal gavman lerawun li lari mashin li mbaha li anajihi ma lar li mandingormerik ma lal krawuk li eweri lir. Ma namtar lihi hi orhi Barabas. ");
INSERT INTO sim_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Urik hulaima nokopma li talaha Pailatin limu silira, �Ma lar avak mi halashinak or ika, os asama asama ermbak mi unda hom.� ");
INSERT INTO sim_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailat angop or heyeri sir, bikpris ondo Jisasin li wapkava hishiri osik orhi tavak orin limu laharara. Karem uri osik ormu silira, �Wa, mberem ji hishindu, king Judamahin na halashinak or ikmbaha jimu hishindu mo lawen a halashinak or iku?� ");
INSERT INTO sim_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hako bikpris ondo li mbashirik ma ondo li usha limu mbara, �Wahau, Jisasin halawa hala! Barabasin halashinak or ika!� ");
INSERT INTO sim_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Urik indik ormu silira, �Wa mberem avai uku, king Judamahi karem ji mbahanda toton?� ");
INSERT INTO sim_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Karem or silirik ma amber wasilakak li ushaha limu mbara, �Oton miandok tirika!� ");
INSERT INTO sim_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Urik indik ormu silira, �Mberem ushiwak? Mbele mende os or uwak kavak nawak ji heyew?� Hako warje mende nga li ushaha limu mbara, �Oton miandok tirinak or haka!� ");
INSERT INTO sim_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Karem li mbarik Pailat or ajehe lirin or hokovikmbaha Barabasin or halashirik ormu ira. Ushihi awun undari ma orhi ondon or mbashirik Jisasin li wakoroho miandok li tirikmbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Uhu awun undari ma ondo Jisasin li laha gavmanhi aka orok limu laha ira. Uhu li mbashirik ma ol lir nga nakrem awun undari ma ondo amber orok li usharik limu talandirsara. ");
INSERT INTO sim_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Uhu kounalo las Jisasik li falehe kuvu lame ngashi las li laha malakama falendari hat hom li yantlehe masiji orhik limu haufalera. ");
INSERT INTO sim_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Uhu kavakavan li okolehe limu mbara, �Mir king Judamahi mira.� ");
INSERT INTO sim_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Karem li mbaha kombe las li laha masiji orhin li jihi orin limu suntlayashira. Uhu kumbambongo lihin li huvuhu hi orhin wasilaka mendek limu hauowera, os malakamahi hin li hauowendari hom. ");
INSERT INTO sim_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Karem li okolehe kounalo oson li tloloshihi kowe orhin limu indiyok faleshira. Ushihi orin li laha miandok li tirikmbaha limu laha ira. ");
INSERT INTO sim_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Li irik ma lar mu nombok tara. Ma oto hi orhi Saimon. Yanga Sairinik fehenda ria, Aleksander fre Rufus avoko frihi ria. Jerusalemik or ikmbaha ormu tara. Urik awun undari ma ondo orin li heyehe li toloho orin li mbashirk miando Jisashi oson ormu kisha ira. ");
INSERT INTO sim_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Karem urik Jisasin li laha yanga Golgotak limu lalawura. Hi Golgota oso maintontlo sihi, �Telemba masik hava hom nanda,� karem li ushanda sir. ");
INSERT INTO sim_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Urik wain uku kas marasin nga li tirsaha Jisasin limu hara. Hako or mbeek oson ari ambu ri. ");
INSERT INTO sim_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Urik orin miandok li tirishihi kowe orhin satuk li lakmbaha limu ermbera. ");
INSERT INTO sim_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta am or tasarik Jisasin miandok limu tirira. ");
INSERT INTO sim_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ushihi maintontlo os orin li jimandingormerin jekamba lasik li kayehe masiknuku orhik li eweri sir. Mashi oso karem li kayeri sir, �King Judamahi toria.� ");
INSERT INTO sim_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Jisas wari mishi orok ma kava frijip er nga wari vri. Lar tap mama yok lar tava ashi yok li tirishirik wari vria. ");
INSERT INTO sim_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Urik ma li raha heyehe li okolehe masijikop li senjelenjehe li hukwakol toloho limu mbara, �Mir tempel akan mi tarvlashihi niri frijip fri ishinak indik undahik mbari om te. ");
INSERT INTO sim_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Unda osik ter mir mihinjik jelyaha miando oson halaha rakanak ni heyeka.� ");
INSERT INTO sim_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Urik bikpris ondo nga mashi Moseshin sawendari ma ondo nga orin li okolehe lihi ambek limu mbara, �Ma toto ma anandin jelyandari ri. Hako orhinjik wahau. ");
INSERT INTO sim_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Os nir Israelik fehenda King nihik or naha Avui Wasilaka orin or kamashihindanak hulaima nokopman or jivina, karem or mbahanda nahi, or avak miando toson or halaha or takanak ni heyeka. Os erem si na nahi, mashi orhin ni misihi nivai tiyaka.� Urik ma op Jisas nga miandok li eweri ovro er nga Jisasin okoleri vri. ");
INSERT INTO sim_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Urik ta komek or sirik simu tangna arangora. Er si krinya ihi homi avi si mbakuri wolok indik simu harara. ");
INSERT INTO sim_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Homi avi si mbakuri wolok Jisas wasilakak or ushaha ormu mbara, �Eloi, Eloi lama sabaktani.� Mashi oso maintontlo sihi karem, �Avui, Avui, mberem ushiwak anin mi halandua?� ");
INSERT INTO sim_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Karem or mbarik ma ol pasir siri ondo olmu mbara, �Misi, or Elaijan ushandu.� ");
INSERT INTO sim_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uhu ma lar or shirinya ihi mbele las warsuvu hom nandarin or laha wain ukuk or halfaleshihi kombek or ishihi Jisasin or hanak or uksem akmbaha ormu ura. Uhu ma oto mu mbara, �Hala ni siheyeshihin, las avak Elaija or taha miando orok orin or laha hakaowenda ngashi.� ");
INSERT INTO sim_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Urik Jisas wasilakak or tashihi ormu hara. ");
INSERT INTO sim_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas or harik kouwarmba tempel aka akomek li fengfakashirik wahandari oso nindi nindi hom er simu frehe laraka tarmbara. ");
INSERT INTO sim_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Urik ma or maifuk sihi mbarik awun li undari ma oto pasir or sihi Jisas harin ormu heyera. Uhu ormu mbara, �Omendinga sira. Ma oto Jikisi indingo Avui Wasilakahi ria.� ");
INSERT INTO sim_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nokove lal olmu homek simandara. Las Maria yanga Makdalak fehenda sir. Las Maria, Jems kanda fre Josep nijava frihi sir. Las Salome. Karem nandari lir. ");
INSERT INTO sim_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisas yanga Galilik or liri wolok orin li jelyaha tiyandari lir. Urik nokove anandi lal nga orok siri lir. Lir er nga Jisas yanga Jerusalemik or iri wolo orin tiyandari lira. ");
INSERT INTO sim_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Am si homihi Sabatik si nakuri wolok si narik ma lar Pailatik or taha Jisashi maninimban or lakmbaha normu mbara. Ma oto hi orhi Josep oria. Yanga Arimateak fehenda ria. Or lida lihi ma jivi lar oria. Or erem Wasilaka os or taha malakamak or naha nor likurin nikishindari ma ria. Undari osik Pailatik or ihi Jisashi maninimban or mbashinak or laha ikmbaha normu mbara. ");
INSERT INTO sim_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Karem or mbarik Pailat ormu wavu mushak hishira. �Am hawa or mo?� Karem or mbaha ma or maifuk sihi mbarik awun li undari ma oton ormu silira, �Jisas am haw or?� Karem or silirik ormu mbara, �Angop hawa ri.� ");
INSERT INTO sim_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Karem or mbarik Pailat mu mbara, �Wan te, layi laha ika.� ");
INSERT INTO sim_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Urik Josep waskowarmba las or frungawuhu maninimba Jisashin or lafakaha kowe orok or hevehe ormu laha ira, sunja akak or ewejehen. Or laha ihi maninimba orhin sunja aka orok ormu owera. Sunja aka oso telembak li tlondari sira. Ushihi sunja laka las or temberik osmu i wan arangora. ");
INSERT INTO sim_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Urik Maria Makdalak fehenda nga Maria Josephi nijava nga Jisasin or eweri mishin armek frimu siheyera. ");
INSERT INTO sim_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat wolo am mendek si narik Maria Makdalak fehenda nga Maria Jemshi nijava oso nga Salome nga mbele mbele arme kuvasahandari ondon limu frungawura. Ondon li laha ihi Jisashi maninimban li ngoroho li tajehe limu ira. ");
INSERT INTO sim_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Karem uhu am si hararik Sande nirsumbuk Jisashi mawak limu ira. ");
INSERT INTO sim_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Li ihi nombok limu mbara, �Sunja laka oson mberem nivai tembeku? Lawe avak nirin jelyaha sunja oson tembeku?� Karem li mbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Li i pasir li sihi li heyeri sunja wasilaka laka os wan li arangori oso mbeek orok wari ambu sir. Sunja oso angop li tembe haieweri sir. ");
INSERT INTO sim_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Uhu li ihi sunja akak li layihi li heyeri jikanda ermbasi lar kouavishan or falehe tapmama yok ormu lira. Orin li heyehe limu lishnyafara. ");
INSERT INTO sim_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Urik ormu mbara, �Ji ajewa hala! Jir Jisas Nasaretik fehenda or miandok li tiriri oton ji heyekmbaha rawa jir. Hako mbeek torok wawa ambu ri, wahau. Wa tos li ewenda mishi toson ji heyeka! Angop usaha iwa ri. ");
INSERT INTO sim_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hako ji ihi ma ol orin tiyandari ondo nga Pita nga karem ji sawe �Jisas angop masmas yanga Galilik iwa ri. Avak Galilik ji ihi heyekwa ri, os mas jirin or saweri hom.� � ");
INSERT INTO sim_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Karem or mbarik li ajehe li lishnyafaha mawan li halaha limu tulu ira. Li tulu ihi mbeek ma lal nga mashin mbari ambu lir. Mberem ushirik? Lir ajeri ola. ");
INSERT INTO sim_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande nirsumbu mendek Jisas ormu usahara. Uhu masmas Maria Makdalak fehendak talari ri. Maria mas wolo wasimalengamba 7-pela tolondari sira. Hako Jisas wasimalengamba ol sirin tolondari ondon or mbarik tulu iri lir. ");
INSERT INTO sim_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Jisasin si heyeshihi si ihi ma ol orin tiyandari ma ondon heyekmbaha simu ira. Si i heyeri li tlaholoho liri lir. ");
INSERT INTO sim_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Urik simu sawera, �Jisas angop usahawa ri.� Hako lir mbeek mashi sihin li misihi, ome sira, karem mbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Urik Jisasin tiyandari ma frijip Jerusalemin fri halaha frimu ira. Nombok fri irik Jisas fririk ormu rara. Maome orhi apsham apsham er nari sir. ");
INSERT INTO sim_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Fri heyendirnaha indiyok fri ihi ma ol orin tiyandari ondon frimu sawera, �Jisas angop usahawa ri.� Hako lir mbeek mashi frihin li misihi, ome sira, karem mbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma 11-pela ondo aka lasik li lihi li arik kolok Jisas mu talara. Or talaha lirin ormu mbara, �Jir mberem ushiwak os indiyok a usahawa mashi oson li sawewan ji misiwa ambu? Wavu jihi fenjeshiwak anin ji hishiowenda osmu mendek nandu?� ");
INSERT INTO sim_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Uhu lirin ormu sawera, �Avak yanga yangak ji ihi mashi jivi anhi toson ji sawenak ma amber li misika. ");
INSERT INTO sim_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Unak ma ol anin hishiewehe hi anhik fak li layiwa ma ondo avak Avui Wasilaka indiyok or lakwa lira. Hako ma ol anin hishindiyawa ambu ondo kumak yanga orhik layikwa ambu lir, avak krestakwa lir. ");
INSERT INTO sim_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma ol anin hishiewewa ondo mashi anhin li sawewa wolo avak Avui Wasilaka mbele las ma undahi ambun lihi tavak or unak ma amber heyekwa lir. Unak hi anhik avak wasimalengamba ondon li mbanak tulukwa lir. Unak apsham apshamhi mashik mbakwa lir. ");
INSERT INTO sim_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Unak os hovo ol man shiwak li handa ondon li tolowa mbeek lirin shinak hakwa ambu lir. Uhu mbele mbele kava ma aha li handa ondon li awa mbeek hakwa ambu lir. Uhu ma ol kavamisiwa ondon tava lihik li tolowa avak jivik nakwa lir.� ");
INSERT INTO sim_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisas mashi oson am or sawerakorik Avui Wasilaka mu orin laha kotontlo orhi hevenik ormu lalawura. Or lalawuhu orhi tapmama yok nakrem opmu linduwa. ");
INSERT INTO sim_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Urik ma ol orin tiyandari ondo yanga yangak li ihi mashi orhin limu saweyara. Urik Wasilaka lir nga lerawun or laha mbele las ma undahi ambu ondon tava lihik or urik mashi os li saweri oson er simu jelyara. Unda kasira. Ambehoma. ");
INSERT INTO sim_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Malakama Tiofilus, mirnjik mashi kason amu kayenduwa. Ma ol Jisas lahandari lerawu amber heitakoho mashi orhin sawenda mak nari ondo nirin li saweri hom, ma mushak mbele mbele ol Jisas nihi nindik or uhundarin li kayeri sir. Unda osik an ngana, mbele mbele ondo amber yawur a misikrahakorowa onik an nga mashi kason mirnjik armek amu kayenduwa. Ushinak mi heyehe mashi os angop mi misiri oso omendinga sira, karem mi mbakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot os provins Judiak kingik or nari wolo, pris lar orok lindari ri. Hi orhi Sekaraia. Or pris kraha Abiyahik fehendari ri. Nokove orhi oso kraha Aronhik fehendari sir. Hi sihi Elisabet osira. ");
INSERT INTO sim_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Frir misokome Avui Wasilakahik jivi indingok nandari vri. Nombo nombo os or mbahandarin tiyandari vri. ");
INSERT INTO sim_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hako Elisabet mbeek jikisi nga nakurik nari ambu sir. Uri osik frir mbeek jikisi nga nari ambu vri. Uhu frir angop nijava laka avoko lakak nari vria. ");
INSERT INTO sim_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nindi wolo lasik Sekaraiahi krahak fehe ondo lerawun li lakuri wolok si narik, Sekaraia er nga or ihi Avui Wasilakahi misokomek prishi lerawun landari ria. ");
INSERT INTO sim_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Undari osik lawe avak tempel aka orok ilayihi Avui Wasilakan ofa os arme kuvasahandan haku, karem mbaha pris ondo ermba ermbak li landari nombon li tiyaha satu oson li ormberik Sekaraiahik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Urik ofa os arme kuvasahandan li hakuri wolok si narik or layirik, ma amber hikriyok li lihi Avui Wasilakan saweri lira. ");
INSERT INTO sim_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Urik ensel Avui Wasilakahi lar Sekaraiahik or talaha teye os ofa arme kuvasahandan li handari teyesumbu tapmama yok ormu sira, os ofa arme kuvasahandan li handari teye orok. ");
INSERT INTO sim_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ensel oton or heyehe or lishnyafaha normu ajera. ");
INSERT INTO sim_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Urik ensel oto mu orin sawera, �Sekaraia, mir ajewa hala. Avui Wasilaka orin mi sawendan angop misiri ri. Nokove mihi Elisabet avak jikishulayi lar wakwa sir. Si wanak hi orhi Jonik ushaka. ");
INSERT INTO sim_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jikisi oton si washinak sunguwavu mihi avak si rupshinak ma mushak er nga rupshikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mberem ushiwak? Hi orhi avak misokome Avui Wasilakahik wasilakak nakwa osa. Or mbeek wain uku nga uku os li aha ambarambasinda nga akwa ambu ri. Nijavahi sunguk or wawa wolokop, Masikome Avui Wasilakahi orhik or siklayikwa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ushinak Israelik fehenda ma mushak or sawe laharanak sunguwavu lihin li tormblehe indik Avui Wasilaka or nirin arangonda otohik takwa lir. ");
INSERT INTO sim_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uhu or kwambu Elaijahik nahandari oso nga nakwa ri. Masmas or ihi nombo Wasilakahin hundujekwa ri. Uhu nor mbanak avoko jikisi lihin li sawenak hangisha likwa lir. Uhu or mbanak mashin mblarnanda ma avak hafaka likwa lir. Karem or uhu hulaima nokopmahi wavun hundujeshinak Wasilaka takwa ria.� ");
INSERT INTO sim_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Karem or mbarik Sekaraia mu mbara, �Shir angop avoko nijava lakak shi nawa shir te. Wa, mbele las nanak a heyehe mashi mihi ome sir, karem avai mbaka?� ");
INSERT INTO sim_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Urik ensel mu orin sawera, �An Gebriel anira. An Avui Wasilaka or linda mishik a sinda nir. Or mbashiwak mashi jivin mirin a sawekwak amu tanduwa. ");
INSERT INTO sim_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hako misika. Mir mbeek mashi os a mbawa ome, karem hishiwa ambu mir. Uwa osik mbeek maimbakwa ambu mir. Erem si naha ihi nokove mihi jikisi oton si wanak mi heyehekop maimbakwa mir. Mashi kas a mbawa kaso Avui Wasilaka mbahanda wolok si nanak omek talakwa sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekaraia tempel aka orok or layiri, nambe mendek or nashirik hulaima nokopma orin li nikishifuhu wavu mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Os hikriyok or talari wolo or maimbari ambu osik limu hishira, �Mbele las angop heyewa ri.� Mashi os or sawekuri, men tavakop ormu mukura. Suwambushi orhi er arangori sir. ");
INSERT INTO sim_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lerawu Sekaraiahi am mendek si narik indik yanga orhik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Urik Elisabet masamnomok simu nara. Uhu akakop si lihi mbeek niyaka tostava yeje hom hikriyok talari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Uhu simu mbara, �Avui Wasilaka anin rupshiwa ri. Os or uwak anhik nawa oso humbla kuvu anhin korowa sir.� ");
INSERT INTO sim_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Niyaka 6-pela am li ishirik Avui Wasilaka mbashirik ensel Gebriel yanga Nasaret os provins Galilik nanda orok nokopminyongo las or i heyekurik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nokove oso angop ma larnjik li tlasashirik wayandari sir. Ma orto kraha king Devithik fehendari ri. Hi orhi Josep oria. Nokopminyongo oso hi sihi Maria sir. ");
INSERT INTO sim_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebriel sirin or i heyehe ormu sawera, �Apmanuwa, Wasilaka angop nyir nga sihi nyirin armek uwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria mashi oson si misihi si lishnyafaha wavu musha mushak simu hishira, �Mberemhi mashi kasir?� ");
INSERT INTO sim_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Urik ensel mu sirin sawera, �Maria, nyir ajewa hala. Avui Wasilaka waprupshi orhi angop nyirin hawa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Misi. Nyir hulasi namber, hako avak masamnomok nyi naha jikishulayi lar wakwa nyir. Uhu hi orhi avak Jisasik ushaka. ");
INSERT INTO sim_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Or avak malakamak or nanak Avui Wasilaka metenjek fehe avak or mba, �Jikisi indingo anhi ria,� karem mbakwa ri. Uhu Avui Wasilaka or nirin arangonda oto or mbashinak misumu walanga orhi Devit nahandari hom kingik nakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Or avak kingik or nanak Israelik fehe ma avak orhi siyok sikwa lir. Lerawu kinghi os or lawa mbeek mendek nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Urik Maria mu enselin silira, �Wa, os erem a nakmbaha mi mbawa oso mberem sivai naku? An mbeek hula nga na nawa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Urik ensel mu sirin sawera, �Avui Wasilaka metenjek fehe Masikome orhi avak nyirik takwa ri. Uhu nyirin jelya arangokwa ri. Ushinak jikisi or nyi wakwa avak jivi worna mendek nakwa ria. Unak avak li ushakwa ri, �Avui Wasilakahi jikisi indingo toria.� ");
INSERT INTO sim_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Misi, mango nyihi Elisabet angop nijava lakak nahanda sir. Hako angop masamnomok osmu nanduwa. Uhunda osik jikishulayi lar avak wakwa sir. Sir mbeek jikisi nga nakwa ambu, karem mas li mbandari sir. Hako masamnomok si nawa niyaka 6-pelak olmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mberem ushiwak? Avui Wasilaka mbele mbele amber or undahi lir.� ");
INSERT INTO sim_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Urik Maria mu mbara, �An orhi siyok a sinda nira. Wa, os or mbawa hom orvai ya uka.� Urik ensel sirin or halaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oro wolok Maria si usaha yanga Judia os telemba nga nandari mishi orok simu ira. ");
INSERT INTO sim_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Si ihi aka Sekaraiahik si layihi Elisabetin simu mbara, �Apmanuwa.� ");
INSERT INTO sim_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet mashi sihin si misirik jikisi or sungu akome sihik wari oto ormu tormblera. Urik Masikome Avui Wasilakahi simbalek Elisabetik ormu siklayira. ");
INSERT INTO sim_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Urik wasilakak si ushaha simu mbara, �Avui Wasilaka angop nyirin armek uwa ria. Os nyirin armek or uwa oso himi kas mbeek nokove lal erem or ukwa ambu lir. Uwak jikisi or sungu akome nyihik wawa oto er nga armek or ukwa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","An mberem mende a nanda osik Wasilaka anhi nijava orhi anin nyi heyekmbaha nyi randu? ");
INSERT INTO sim_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Os nyi raha anin, apmanuwa, karem nyi mbawak a misiwak jikisi or sungu akome anhik wawa oto or rupshihi ormu tormblewa. ");
INSERT INTO sim_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyir mashi os Wasilaka os nyirin or ukmba nor mbahandan nyi misihi nyi mbar, �Avak omek nakwa sir,� karem nyi hishiowenda osik nyirin armek ormu unduwa,� karem simu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Urik Maria karem simu mbara, �Sunguwavu mende anhi nga hi Wasilakahin a hauowehe amu rupshi mendenduwa. ");
INSERT INTO sim_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Uhu masikome anhi nga Avui Wasilaka or anin jivinahanda oton amu rupshinduwa. ");
INSERT INTO sim_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","An orhi siyok a sinda nir. An hi ngashi ambu nir. Hako ormu anin armek ya unduwa. Ter nga kumak nga ma amber karem mbakwa lir, Avui Wasilaka anin armek uri ri, karem mbakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Or kwambu ngashi orik, mbele las apsham nandarin anin ormu ura. Hi orhi worna mendek er nanda sir. ");
INSERT INTO sim_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma ol orhi siyok siwan armek unda ri. Ma ol ter liwa nga kumak nakunda ondo nga erem armek or ukwa lir. ");
INSERT INTO sim_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tava orhik lerawu wasilakan landa ri. Ma misambik fehe ol lihinjik hishihi mba, �Nir malakama nir,� karem hishihi hi lihin hauowenda ma ondon avak or kria ermbekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Malakama ol kwambu nga nanda ondon or mbanak hi lihi avak mendek nakwa sir. Hako ma ol hi ngashi ambu ondo hi lihin hauewekwa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Uhu ma ol erenghawan mbele mbele jivin handa ri. Uwak sungu lihi osmu hopndiyawa. Hako ma ol mbele mbele nga mushak nawan or mbashiwak olmu men tapas iwa. ");
INSERT INTO sim_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Or Israelik fehe ma ondon jelyandari ria. Lirin armek ukurik or mbari mashin hishanda ambu ri, wahau. Mberem ushirik? Misumu nihi Abraham nga nirambara orhi ondon or jelyakmbaha nor mbahandari osa,� karem simu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Uhu Maria niyaka nalmingrip hom Elisabet nga fri lihi nom indik yanga sihik simu ira. ");
INSERT INTO sim_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet am si wakuri wolok si narik jikishulayin simu wara. ");
INSERT INTO sim_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ma ol yanga nakrem lindari nga sihi krahak fehe lal nga os Wasilaka sirin armek or urin li misihi lir nga limu rupshira. ");
INSERT INTO sim_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Uhu niri 7-pela am li ishirik ma lal jikisi otohi masamsishin li korokurik limu rara. Uhu avoko orhi Sekaraiahi hik orin li ushakmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hako nijava orhi, �Wahau, avak Jonik ni ushakwa ri,� karem simu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Karem si mbarik limu mbara, �Wa, kraha jihik fehe ma lal mbeek hi orok sinda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Uhu tavakop li uhu avoko orhin limu silira, �Jikisi roto hi lawehik mi ushaku?� ");
INSERT INTO sim_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Urik or mbarik os li owekayendari las li lahararik ormu kayera, �Hi orhi Jon.� Urik wavu musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Urik kolok Sekaraia os or maimbandari ambu mendek si narik indik ormu maimbara. Uhu nor maimbaha hi Avui Wasilakahin ormu hauewera. ");
INSERT INTO sim_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Urik yanga nakrem li lindari ma ondo erem nari oson li heyehe limu aje mendera. Uhu mashi oson Judiahi yanga ol telemba nga nandari mishi ondok limu haihanda sawe ira. ");
INSERT INTO sim_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Urik ma ol mashi oson misiri ondo wavu musha mushak limu hishira, �Kumak jikisi oto mberem mende hom nakundar mbe?� Karem li hishihi limu mbara, �Wasilakahi kwambu angop orhik nawa sir.� ");
INSERT INTO sim_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Urik Masikome Avui Wasilakahi jikisi otohi avoko Sekaraiahik ormu siklayia. Urik profet mashi las karem ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","�Avui Wasilaka or yanga Israelik fehenda man arangonda ma oto hi orhin nimu hauewekuwa. Or nirnjik or hishihi nirin or jelyaha nirin jivinari ri. ");
INSERT INTO sim_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uhu ma or nirin jivinakurin or mbashirik king Devithi krahak talari ri, ");
INSERT INTO sim_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","os maskop profet orhi ondon or sauharik li sawendari hom. ");
INSERT INTO sim_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Or avak nirin wutarihi tavak masnalakwa ri. Uhu ma ol nirin wapkava hishiwa ondohi tavak masnalakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Or neloko nihi ondon or rupshihi wapjivi orhik lirin jelyari ri. Uhu suma os mas or tivindari hom lirin uri ri, ");
INSERT INTO sim_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","os mas misumu nihi Abrahamik or mbahandarin. ");
INSERT INTO sim_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Or nirin wutarihi tavak or masnalashinak orin ni lotu ukwa nir. Uhu lerawu orhin ni laha mbeek ni ajekwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Uhu os misambi torok ni liwa wolo misokome orhik or heyewa orhi mak ni naha avak ma jip worna ma mendek er ni naka. ");
INSERT INTO sim_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Hako jikisi anhi mirin, kumak avak Avui Wasilaka or metenjek fehenda profet orhik li ushakwa mir. Uhu mir maifuhu Wasilakahi nombon hundujekwa mir. ");
INSERT INTO sim_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Avui Wasilakahi ma ondon mi sawenak kavakava lihin or yoko ermbehe lirin or jivinashinak waprupshi orhin heyekwa lir. Uhu ukruharanda os hevenik fehen or halashinak nihik takakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Uhu ma ol nirtle nirundum nawa mishik liwa ondon si ukruharashinak likwa lir. Uhu nirin or tolowornashinak waphimbiji linda nombon tiya ikwa nir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jikisi oto wasilakak or narik masikome orhi kwambuk er nari ri. Uhu misamtelmbamba mishik ormu i lira. Orok or lihi ihikop lerawun or lakuri wolok si narik kormbak or talaha ma Israelik fehe nindik lerawun ormu lara. ");
INSERT INTO sim_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sisar Ogastus yanga yanga amber hom mashi las or owehe ormu mbara, �Ma jir amber kotontlo jihik ji inak hi jihin sensus buk orok li kayeka.� ");
INSERT INTO sim_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Os erem hi lihin li owekurik or mbari nombo oso kas mbeek mas li uhundari ambu sir. Oro wolok Kwirinius malakama yanga Siriahik or nari wolo sira. ");
INSERT INTO sim_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ushiri osik ma amber hi lihin li kayekmbaha kotontlo lihik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep oto kraha king Devithik fehendari orik yanga Nasaretin or halaha Betlehemik ormu ira. Betlehem oso yanga Devithi, karem li ushandari sira. ");
INSERT INTO sim_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Oso wolo Josep nokove orhi Maria os masamnomok nahandari oson or laha hi frihin li kayekmbaha frimu ira. ");
INSERT INTO sim_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Am Betlehemik fri i lihi Maria jikisin si wakuri wolok simu nara. ");
INSERT INTO sim_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Uhu jikismaifu hulayi sihi oton simu wara. Uhu kowarmbak orin si hevehe bokis os bulmakau andari orok si oweshirik ormu wara. Mberem ushirik? Ma musha mendek orok li tirsari osik mbeek aka os fri likuri mishi kas nga nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oso wolo sipsipin washilindari ma lal yanga Betlehem hikriyok sipsip lihin nirik limu washilira. ");
INSERT INTO sim_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Urik ensel Avui Wasilakahi lar os li liri mishik or talarik ukruharandari Avui Wasilakahi lirin si ukruharashirik li lishnyaha limu aje mendera. ");
INSERT INTO sim_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hako ensel oto mu sawera, �Ji ajewa hala. Ji misi. An mashi jivin jirin a sawekmbaha a rawa nir. Mashi os a laharawa oso si unak ma amber rupshikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ter kolaka Devithi orok nokove las angop jikishulayi lar wawa sir. Jikisi oto jirin jivinakunda ma ri. Or Wasilaka jihi Krais, Avui Wasilaka kamahanda ma ri. ");
INSERT INTO sim_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Avak jikisi oto kowarmbak li hevehe bokis os bulmakau anda mishik li oweshinak or wanak ji heyekwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel oto erem or mbari halangak ensel hevenik fehe musha mendek li talandirsaha or nga hi Avui Wasilakahin limu hauowera, ");
INSERT INTO sim_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","�Avui Wasilaka metenjek fehe hi orhin ji haueweka. Unak ma misambik fehe ol or rupshinda ondo waphimbiji orhi lihik si naka,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Uhu ensel ondo indik hevenik li lawushirik ma ondo lihi ambek limu mbara, �Kolok ka ni Betlehemik ni ihi os talawak Wasilaka or mbawa oson ni heye.� ");
INSERT INTO sim_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Karem li mba tirnaha limu ira. Li ihi Maria fre Josepin nombok limu i heyera. Uhu jikisi or bulmakau andari bokis orok fri oweshirik wari oto er nga limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jikisi oton am li heyehe mbele mbele jikisi otohik nakundari os ensel lirin or saweri oson limu sawera. ");
INSERT INTO sim_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mashi oson li sawerik li misihi wavu musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hako Maria mashi oso sunguwavu sihik si owehe maintontlo sihin armek si hishikrahakorokmba simu ura. ");
INSERT INTO sim_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Urik sipsipin washilindari ma ondo mbele mbele os ensel sawerik li misiri hom si narik li heyehe hi Avui Wasilakahin li hauowehe indik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Niri 7-pela am li ishirik jikisi oto masamsishi orhi kas limu korora. Uhu hi orhin Jisasik limu ushara, os Maria masamnomok si na namber ensel sirin or sawendari hom. ");
INSERT INTO sim_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Jikisin si waha yangak men wandandari wolo mendek si nashirik jikisin fri laha Jerusalemik frimu lawura. Mberem ushirik? Mashi Avui Wasilakahi karem sawendari osa, �Jikishulayi maifu or si wawan ji laha Wasilakan ji haka.� Uhu �Apmuma lap mo uja avi lap er nga ji laha ihi Avui Wasilakan ji hanak misokome orhik jivik ji naka.� Karem mbandari osik mashi os si mbandari hom fri ukurik jikisi nga avi frijip nga frimu laha ira. ");
INSERT INTO sim_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oro wolok ma lar Jerusalemik lindari ria. Hi orhi Simeon. Or nombo wornakop Avui Wasilakan lotu undari ria. Uhu ma or Avui Wasilaka kamashirik Israelik fehenda man jivinakuri ma oto or takurin nikishindari ma ri. Masikome Avui Wasilakahi ormu Simeon nga sindari ri. ");
INSERT INTO sim_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hako maskop Masikome Avui Wasilakahi orin karem saweri ri, �Er mi lihi ihi ma or Avui Wasilaka orhi man jivinakmbaha nor kamahanda ma oto or tanak mi heyehekop hakwa mir.� ");
INSERT INTO sim_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oro wolok Masikome Avui Wasilakahi orin or sawerik tempel akak or layirik avoko nijava Jisashi orin fri laha lo os si mbandari hom fri ukurik fri layirik ormu heyera. ");
INSERT INTO sim_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Or heyehe Jisasin or tlolo simbihi hi Avui Wasilakahin or hauowehe ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","�Avui Wasilaka, ter am amu heyenduwa, ma or hulaima nokopman jivinakwak mi mbahandan. Uwa osik halashinak waphimbiji nga na haka, os mas mi mbahanda hom. Jikisi toto ma amber misambik fehenjik hevenik mi halashiwak tawa toria. ");
INSERT INTO sim_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ukruharandak or naha Judama ambu ondon er nga nombon mukukwa ri. Uhu or unak mihi ma ol Israelik fehenda ondo hi lihi wasilakak nakwa sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Avoko nijava Jisashi mashi os or mbari oson fri misihi frimu wavu musha mushak hishira. ");
INSERT INTO sim_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon Avui Wasilaka fririn armesarmek or ukmbaha Avui Wasilakan ormu sawera. Ushihi Marian ormu sawera, �Misi. Avui Wasilaka jikisi roton or kamari karem. Ma Israelik fehe mushak or halashinak lal mashi orhin li mblarnaha kavak li nanak lal mashi orhin misindiyakwa lir. Uhu jikisi roto mashi Avui Wasilakahi or saweshinak ma mushak orin wutarik owekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Unak mbele mbele os wavukop li wanyinda avak kormbak simu talakuwa. Unak nyir avak wavu nyihi kormek li jiwak li misinda hom misikwa nyir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Profet nokove las orok er nga lindari sir. Hi sihi Ana. Jikisi Fanuelhi, kraha Aserhik fehendari sira. Angop mas wolokop si hulasihi asama 7-pelakop hula sihi nga fri lihi hula sihi or hashirik mumblak wahayandari sir. Uhu angop nijava laka mendek nahandari sir. Asama sihi 84-pelak nari sira. Sir mbeek tempel akan halandari ambu sir. Akwan si halaha Avui Wasilakan si sawehe hi orhin niri tandi hauowendari sira. ");
INSERT INTO sim_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oro wolok sir er nga jikisi oton si heyehe hi Avui Wasilakahin simu hauowera. Uhu Jerusalemik fehe ma ol lirin jivinakuri man nikishindari ondon simu sawera, �Avui Wasilaka kar ji nikishikmbaha nor mbahanda ma toria,� karem simu sawera. ");
INSERT INTO sim_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep fre Maria am mbele mbele lo os Wasilaka mbahandari hom fri urakoshihi indiyok yanga frihi Nasaretik frimu ira. Nasaret oso provins Galilik nandari sira. ");
INSERT INTO sim_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jikisi frihi oto am or saha kwambu nga normu nara. Uhu wavu orhi krahak er si narik rupkapshi Avui Wasilakahi orhik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Asama ermba ermbak hiyawu wasilaka Pasovan li tolondari wolo, avoko nijava Jisashi Jerusalemik indari vri. ");
INSERT INTO sim_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas asama orhi am 12-pelak si narik avoko nijava orhi nga hiyawu wasilaka Pasovan os li tolondari hom li tolokurik Jerusalemik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Li ihi li lirik hiyawu oso am mendek si narik yanga lihik li ikurik limu ira. Hako Jisas Jerusalemik er or lishirik avoko nijava orhi fri hisha fri halashi iri vri. ");
INSERT INTO sim_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Frir karem hishiri vri, �Or angop mahasanje orhi lal nga iwa ri,� karem mbaha frimu ira. Urik niri namtas am si ishirik os li iri ambek frimu Jisasin lasai lasarara. ");
INSERT INTO sim_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Fri laslasafuhu indiyok Jerusalemik frimu ira. ");
INSERT INTO sim_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Niri nalmingrip orin fri lasayahakop fri heyerik, tempel aka orok tisa ondohi nindik or lihi mashi ol li sawerin or misihi ormu lishi silira. ");
INSERT INTO sim_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wavu orhi krahak er si nashirik mbele mbele ol li silirin krahak or saweshirik ma ondo amber limu lishnyafara. ");
INSERT INTO sim_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jikisi frihin fri heyeri malakamahi nindik or lishirik frimu lishnyafara. Uhu nijava orhi mu orin mbara, �Ayo, toto mende. Mberemhi tos ter mi ushiwak sunguwavu shihi nga kavak er si nawak mirin shi lasayandua?� ");
INSERT INTO sim_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Urik Jisas mu sawera, �Mberem ushiwak anin shi lasarandu? An Avui anhi akak a liwan shi hishiwa kom?� ");
INSERT INTO sim_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hako frir mbeek hishiyariri ambu vri, os fririn or mbari mashin. ");
INSERT INTO sim_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Urik tempelin or halaha avoko nijava orhi nga Nasaretik limu ira. Uhu yangak or lihi ermba ermbak os fri mbari mashin ormu misindiyara. Hako nijiva orhi mashi os or mbarin si misihi sunguwavu sihik er si owehe simu toltambanara. ");
INSERT INTO sim_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas am or saha wasilakak or narik os krahak or hishiyarinda nga wasilakak er nari sira. Urik Avui Wasilaka orin or rupshirik ma er nga orin limu rupshira. ");
INSERT INTO sim_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Sekaraiahi jikisi Jon oto ma ngashi mishi ambu orok or lirik Avui Wasilaka mashi orhin Jonin ormu hara. Urik Jon yanga yanga fa Jordan nandari mishi orok or ihi mashin ormu sawera. Unak hulaima nokopma sunguwavu lihin li tormblehe kavakava os li undan li halanak lirin fak or tolofaleshinak Avui Wasilaka kavakava lihin or yoko ermbekmbahan. Oso wolo Taiberius oto asama 15-pelak malakama Sisarik or nari sir. Urik Pontius Pailat oto provins Judiak malakamak or narik, Herot oto Galilik kingik or narik, maha orhi Filip oto provins Ituria nga Trakonitis nga orok malakamak or narik, Lisanias oto provins Abilenek malakamak or nari wolo sira. Urik Anas nga Kaiafas nga hetprisik nari vria. ");
INSERT INTO sim_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mashi os Jon saweri profet Aisaia mas or mbahandari hom nari sira. Kuyanga ma ngashi mishi ambuk ma lar karem ormu mbanduwa. �Wasilakahi nombon ji hundujeka. Uhu nombo oson ji unak wornak si naka. ");
INSERT INTO sim_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kolwa layiwa mishi ondon amber ji mbuhavika. Uhu telemba wasilaka ondon amber ji sanak li rakaha lewakuk li naka. Nombo ol mbango longohondan armek ji sanak wornak li naka. Uhu tuktas tuktasawa nombon ji sanak si taka layika. ");
INSERT INTO sim_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ushinak ma misambik fehe amber avak li heyeka, nombo os Avui Wasilaka lirin or jivinakwan.� ");
INSERT INTO sim_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Urik ma ol fak or tolofalekmbaha tari ondon ormu sawera, �Jir Laulakahi jikisi jir. Sunguwavu jihin ji tormble namber, men fak ji layihindanak waplelena Avui Wasilakahi os jihik nakwan ji wasisoku, karem ji hishihi jimu randu? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Masmas sunguwavu jihin ji tormblehe mbele mbele jivin ji unak ni heyehe ni mbaka, �Ma tondo angop wavu lihin tormblewa lira.� Hako jihinjik avak ji mba, �Misumu nihi Abraham oria. Uwa osik Avui Wasilaka mbeek nirin kavak nakwa ambu ri,� karem ji mbawa hala. Jirin amu sawenduwa. Avui Wasilaka os or hishi nahi, sunja tondon or mbanak jikisi nirambara Abrahamhik nakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hako kombefa osmu mi tontlok wanduwa. Mi ol akwa ome jivin wawa ambu, men li shihi hik li ermbeshinak hi ukwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Karem or mbarik ma ondo orin limu silira, �Wa, mberem nivai uku?� ");
INSERT INTO sim_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Urik ormu sawera, �Os kowe frijip ji na nahi, las ma or mendek nawan ji haka. Os akwa nga ji na nahi, erem ji uka,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Urik ma ol takis yan landari ma ondo er nga fak li layikurik li taha orin limu silira, �Tisa, mberem nivai uku?� ");
INSERT INTO sim_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Urik ormu sawera, �Jir takis ya os ji lawa, malakama jihi li mbawa nombo hom ji laka. Warje nga ji lawa hala.� ");
INSERT INTO sim_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Karem or mbarik awun undari ma er nga orin limu silira, �Mberem nivai uku?� Urik ormu sawera, �Jir avak man awu awuk mbaha ya lihin lawa hala. Uhu avak man semben kotim uwa hala. Hako fotnait os ji lawa oso nom ji heyehe ji mba, ambehoma, karem ji mbaka.� ");
INSERT INTO sim_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Karem or mbarik ma ondo wavu mushak li hishihi limu mbara, �Ma toto Avui Wasilaka hulaima nokopman jivinakmbaha nor kamahanda ma tori mo?� ");
INSERT INTO sim_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Urik Jon mu lirin sawera, �An jirin fambak a tolofalenda nir. Hako kumak ma lar avak takwa ri. Kwambu orhi kwambu anhin tikrinda sir. Or ma jivi indinga ri, hako an wahau. Unda osik an mbeek kuvu os kumba ari orhi orok nawan a sorngondahi ambu nir. Or avak jirin Masikome Avui Wasilakahi nga tolofalekwa ria. Ushinak Masikome oto os ma sembentlamban li suwushiwak si ufrumunda hom kavakava os ji undan ufrumukwa ri. ");
INSERT INTO sim_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Or avak ma or wit sijin suwak or tolonda hom takwa ria. Wit sijin or tolonak ome ol takawa ondo nom aka orhik or ewekwa lir. Uhu supmbalapmbak nawa ondon hi os usunguanda ambu orok or ormbekwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Karem or mbaha mashi anandi mushak wavu lihin si jikmbaha ormu sawera. Karem uhu mashi jivi Jisas Kraishin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Os Jon hulaima nokopman fak or tolofaleri wolo Jisasin er nga fak ormu tolofalera. Ushirik Jisas or sihi Avui Wasilakan ormu sawera. Or sawerik heven akayanga simu sutlara. Si sutlarik Masikome Avui Wasilakahi apmuma hom Jisashik simu takalira. Urik mashi las heven yok simu mbara, �Mir jikisi indingo anhi mira. An mirin amu rupshi mendenduwa. Sunguwavu anhi mende nga amu mirin rupshi mendenduwa,� karem simu mbara. Jon malakama Herot os maha orhi nokove Herodiasin or masnalari nga kavakava ol or undarin er nga kormbak or saweshirik or humblaraha Jonin krawuk ormu owera. Os Jonin erem or uri oso musa las osmu er nga orhik lawura. ");
INSERT INTO sim_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Os Jisas usasihi lerawun or lari wolo, asama orhi 30-pelak nari ria. Urik ma amber, Jisas oto jikisi Josephi ri, karem limu hishira. ");
INSERT INTO sim_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Josep oto jikisi Helihi ri. Heli oto jikisi Matathi ri. Matat oto jikisi Livaihi ri. Livai oto jikisi Melkihi ri. Melki oto jikisi Janaihi ri. Janai oto jikisi Josephi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep oto jikisi Matatiashi ri. Matatias oto jikisi Amoshi ri. Amos oto jikisi Nahumhi ri. Nahum oto jikisi Eslihi ri. Esli oto jikisi Nagaihi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai oto jikisi Mathi ri. Mat oto jikisi Matatiashi ri. Matatias oto jikisi Semenhi ri. Semen oto jikisi Josekhi ri. Josek oto jikisi Jodahi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda oto jikisi Joananhi ri. Joanan oto jikisi Resahi ri. Resa oto jikisi Serubabelhi ri. Serubabel oto jikisi Sealtielhi ri. Sealtiel oto jikisi Nerihi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri oto jikisi Melkihi ri. Melki oto jikisi Adihi ri. Adi oto jikisi Kosamhi ri. Kosam oto jikisi Elmadamhi ri. Elmadam oto jikisi Erhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er oto jikisi Josuahi ri. Josua oto jikisi Elieserhi ri. Elieser oto jikisi Jorimhi ri. Jorim oto jikisi Matathi ri. Matat oto jikisi Livaihi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai oto jikisi Simeonhi ri. Simeon oto jikisi Judahi ri. Juda oto jikisi Josephi ri. Josep oto jikisi Jonamhi ri. Jonam oto jikisi Eliakimhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim oto jikisi Meleahi ri. Melea oto jikisi Menahi ri. Mena oto jikisi Matatahi ri. Matata oto jikisi Natanhi ri. Natan oto jikisi Devithi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit oto jikisi Jesihi ri. Jesi oto jikisi Obethi ri. Obet oto jikisi Boashi ri. Boas oto jikisi Salmonhi ri. Salmon oto jikisi Nasonhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason oto jikisi Aminadaphi ri. Aminadap oto jikisi Atminhi ri. Atmin oto jikisi Arnihi ri. Arni oto jikisi Hesronhi ri. Hesron oto jikisi Pereshi ri. Peres oto jikisi Judahi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda oto jikisi Jekophi ri. Jekop oto jikisi Aisakhi ri. Aisak oto jikisi Abrahamhi ri. Abraham oto jikisi Terahi ri. Tera oto jikisi Nahorhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor oto jikisi Serukhi ri. Seruk oto jikisi Reuhi ri. Reu oto jikisi Pelekhi ri. Pelek oto jikisi Eberhi ri. Eber oto jikisi Selahi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela oto jikisi Kainanhi ri. Kainan oto jikisi Arpaksathi ri. Arpaksat oto jikisi Siemhi ri. Siem oto jikisi Noahi ri. Noa oto jikisi Lamekhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek oto jikisi Metuselahi ri. Metusela oto jikisi Enokhi ri. Enok oto jikisi Jarethi ri. Jaret oto jikisi Mahalalelhi ri. Mahalalel oto jikisi Kenanhi ri. ");
INSERT INTO sim_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan oto jikisi Enoshi ri. Enos oto jikisi Sethi ri. Set oto jikisi Adamhi ri. Adam oto Avui Wasilakahi jikisi ria. ");
INSERT INTO sim_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Masikome Avui Wasilakahi Jisashik or sihi or mbashirik fa Jordanin or halaha misamtelmbamba orok ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Or ihi orok or liri niri 40-pelak Laulaka orin ormu oweioweiheyera. Oso wolo Jisas mbeek akwa las ari ambu ri. Uhu normu erenghara. ");
INSERT INTO sim_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Urik Laulaka orin ormu mbara, �Os mir jikisi Avui Wasilakahi indinga nahi, mi mbanak sunja toso si tormblehe bretik si nanak aka.� ");
INSERT INTO sim_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Urik Jisas mu mbara, �Wahau, �Ma mbeek akwakop linda ambu lir.� Mashi Avui Wasilakahi karem mbahanda sir.� ");
INSERT INTO sim_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Urik Laulaka orin or laha frimu lawura. Fri lawu sihi kolok kolaka laka misambi torok nandari jivijivi ngashi amber hom ormu mukura. ");
INSERT INTO sim_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Uhu ormu mbara, �Mir avak kwambun a hanak mbele mbele yanga tos ter nawak mi heyewa tondon arango likwa mira. Unak hi mihi nga avak wasilaka mendek nakwa sir. Mbele mbele ondo angop anhik narakonda lir. Os ma lar a hakmbaha na hishiwa a handahi ri. ");
INSERT INTO sim_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Os kumbambongo mihin mi huvuhu hi anhin mi hauowe nahi, avak mbele mbele tondo amber mirin a hakwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Karem or mbarik ormu mbara, �Mashi Avui Wasilakahi karem mbanda sir, �Mir avak Avui Wasilaka or mirin arangonda ortonom mi lotu uhu hi orhi nom hauowehe ortonom tiyaka.� � ");
INSERT INTO sim_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Urik Laulaka Jisasin or laha Jerusalemik fri ihi akamasuwu tempel aka orok or lalawu oweshirik or sirik ormu mbara, �Os mir jikisi Avui Wasilakahi indinga nahi, mir avak kweinalayika. ");
INSERT INTO sim_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mberem ushiwak? Jekamba Avui Wasilakahi karem mbahanda sir, �Avak Avui Wasilaka or mbashinak ensel li ta sihindanak mirin jelyakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Avak tavarenje lihik mi layinak li toloshinak sunja las mbeek mirin jikwa ambu sir.� Karem mbahanda sir.� ");
INSERT INTO sim_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Urik Jisas mu mbara, �Mashi Avui Wasilakahi karem mbanda sir, �Mir avak Avui Wasilaka mihin oweioweiheyewa hala.� � ");
INSERT INTO sim_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Laulaka karem Jisasin or oweioweifuhu normu hala ira. Undanak indik orvai oweioweiheyekmbahan. ");
INSERT INTO sim_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Masikome Avui Wasilakahi Jisashik or sihi or jelyashirik indik Galilik ormu ira. Urik ol orok lindari ma amber olmu misira, os Jisas indik Galilik or tarin. ");
INSERT INTO sim_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Uhu ermba ermbak Judama lotu undari aka orok man ewesaweri ria. Urik ma amber hi orhin limu hauowera. ");
INSERT INTO sim_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas indiyok kotontlo orhi Nasaretik ormu ira. Os Sabat wolok si narik Judama lotu undari akak ormu layira, os ermba ermbak or undari hom. Uhu jekamba Avui Wasilakahin or ritim ukmbaha ormu usasira. ");
INSERT INTO sim_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Urik jekamba las profet Aisaia kayendari orin li harik or lunduhu mashi os karem mbandarin ormu ritim ura. ");
INSERT INTO sim_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","�Masikome Avui Wasilakahi anhik ormu sinduwa. Mberem ushiwak? Avui Wasilaka anin kamari ri, ushinak a ihi erndakava ondon mashi jivi orhin a sawekmbahan. Uhu ma ol krawuk sinda ma ondohik a ihi os Avui Wasilaka lirin or unak krawun li halaha ikwan a sawekmbahan. Uhu misokome tumunda ma ondohik a ihi os or unak li heyekwan a sawekmbahan. Uhu ma ol nomorawu wasilakan kishanda ondohik a ihi os or unak nomorawu lihi mendek si nakwan a sawekmbahan. ");
INSERT INTO sim_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Uhu Avui Wasilaka ma orhin armek or washilikwa pasir si nawa oson a sawekmbahan.� ");
INSERT INTO sim_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Karem or sawehe jekamban or hevehe ma or jekamban washilindari man indik ormu hara. Uhu ormu takalira. Urik ma ol orok liri ondo Jisas nom limu lishi flaflatara. ");
INSERT INTO sim_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Urik ormu sawera, �Mashi Avui Wasilakahi os ter ji misiwa osmu anhik omendingak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Karem or mbarik orok liri ma mashi jivi os or owesawerin li misihi limu lishnyafaha hi orhin limu hauowera. Hako limu mbara, �Ma toto men Josephi jikisi ri. Mberemhi nombok mashi jivi toson karem or sawendua?� ");
INSERT INTO sim_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Urik Jisas mu lirin sawera, �Anin ji hishiowenda ambu osik avak karem anin mbakwa jir. Mashi os �Dokta, mir avak maome mihi os kavamisiwan unak jivik si naka.� Karem li mbanda mashin anin ji mbaha mashi las nga ji mbakwa sir karem, �Mbele mbele ma undahi ambu ol yanga Kaperneamik mi urik ni misihinda ondo himi lal kotontlo mihi torok mi unak ni heyehe mirin nivai hishioweka.� Karem anin mbakwa jir. ");
INSERT INTO sim_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hako omendingak jirin amu sawenduwa, profet ondo yanga yanga amber hom hi lihin hauowenda lir. Hako kotontlo lihi nga mahasanje jikanoka lihi nga mbeek hi lihin hauowenda ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Omendinga sir. Os profet Elaija siri wolo asama nalmingrip niyaka 6-pelak ma rakari ambu sir. Ushirik yanga yanga amber erenghari lir. Oso wolo nokove mumbla musha mendek yanga Israelik lindari lir. ");
INSERT INTO sim_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hako Avui Wasilaka mbeek Elaijan or mbashirik Israelik fehenda mumbla ondon jelyakurik iri ambu ri, wahau. Or mbashirik yanga Sarefat Saidonik nahanda mishi orok Judama ambu mumbla oson or jelyakurik iri ri. ");
INSERT INTO sim_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Uhunda hom os profet Elisa siri wolo, okmbale lepra tolondari ma musha mendek yanga Israelik lindari lir. Hako lihi lar mbeek or urik jivik nari ambu ri. Yanga Siriak fehendari Naman or Judama ambu oto nom or urik jivik nari ri.� ");
INSERT INTO sim_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Karem or mbarik ma ol lotu undari aka orok liri ondo mashi oson li misihi limu waplelena mendera. ");
INSERT INTO sim_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uhu Jisasin yanga hikriyok li kisha ermberik or talayirik orin telek li kisha ermbenak or layikmbaha limu ura. ");
INSERT INTO sim_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hako or ma ondohi nindik or layishihi ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ushihi yanga Kaperneam provins Galilik nandari orok ormu ira. Uhu Sabat wolo ermba ermbak mashin owesawendari ri. ");
INSERT INTO sim_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mashin or saweri katai hukwalama hom or owesaweri osik ma li misihi limu lishnyafara. ");
INSERT INTO sim_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nindi wolo lasik wasimalengamba tolondari ma lar os li lotu undari aka orok liri ri. Uhu wasilaka mendek or ushaha ormu mbara, ");
INSERT INTO sim_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","�Ayo, Jisas Nasaretik fehenda mirin, mberem nirin mi ukmbaha mi tandu? Nirin kavak mi nakmba mimu randu? Hako angop a heyewa mir, mir ma worna ma indinga Avui Wasilakahi mira.� ");
INSERT INTO sim_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Karem mbarik orin huliyik ormu mbara, �Mayam si. Ma toton halaha ika.� Urik ma li heyerik wasimalengamba ma oton or farnaro ormbehe ormu halashi ira. Hako ma oto mbeek kavak nari ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Urik ma amber oson li heyehe li lishnyafaha lihi ambek limu mbara, �Ma jirin te. Mberemhi tos ter nandua, os ma toto hukwalama hom or mbaha or mbashiwak wasimalengamba mashi orhin li misihi li halaha iwan te,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Urik mbele mbele os or uri mashi yanga yangak si irik limu misira. ");
INSERT INTO sim_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas or usaha li lotu undari aka oson or halaha nor ihi aka Saimonhik ormu layira. Arjava Saimonhi si kavamisihi maome hikop warje mende nga lawurik orok wari sir. Urik Jisasin limu silira, sirin or mbanak jivik si nakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Li silirik si wari mishik pasir ormu tara. Uhu maome os hikop lawurin or ngriambarik kolomalok mendek si nashirik jivik simu nara. Uhu akwan lirnjik simu ura. ");
INSERT INTO sim_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ta am or layirik ma ol orok fehendari ondo ma lihi ol kavamisindari ondon Jisashik limu laharara. Urik Jisas ma ondon namtarmba namtarmbak tava orhin or hauowehe or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Uhu nor mbarik wasimalengamba ondo orin li heyehe limu mbara, �Mir Avui Wasilakahi jikisi mira.� Karem li mbaha jisuwuhu ma ol li tolondari ondon li halaha limu ira. Wasimalengamba ondo, Jisas Avui Wasilaka mbashirik taha hulaima nokopman jivinakunda ma ri, karem angop heyeri lir. Uri osik mashi oson li mbakurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Am nursumbuk si narik Jisas yanga oson or halaha misamtelmbamba orok ormu ira. Ushirik ma orin li lasa ihi orin li heyehe limu mbara, �Mir avak lasik iwa hala. Torok er lika.� Karem li mbarik ");
INSERT INTO sim_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ormu sawera, �Wahau. Yanga yanga amber a ihi mashi jivi Avui Wasilakahin a sawekmbaha or mbashirik a tari nir. �Sunguwavun ji tormbleshinak ter avak Avui Wasilaka jirin or arangoshinak jip ji lika.� Karem a sawejehen.� ");
INSERT INTO sim_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Karem or mba lafakaha provins Judiak or ihi mashi Avui Wasilakahin orok ormu saweyara. ");
INSERT INTO sim_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nindi las wolok Jisas leuksumbu Genesaretik or sihi mashi Avui Wasilakahin or owesawerik ma musha mendek mashi orhin li misikmbaha li talandirsaha limu anakisha ormbera. ");
INSERT INTO sim_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Urik or heyeri bot frijip fa mambuk frimu sira. Urik foomen kruwunda ma bot lihin li halatakaha foom kowe lihin limu oweyokora. ");
INSERT INTO sim_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Urik bot Saimonhik or lawuhu Saimonin ormu sawera, �Bot mihin tukrushinak kandakar nga si ihi si.� Uhu bot orok or lihi mashin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Or sawe lafakaha Saimonin ormu sawera, �Laha ni i fa nindik sihi foom kowe oson ormbenak si layinak foomen kruwuka.� Karem or mbarik ");
INSERT INTO sim_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon mu mbara, �Tisa, niri wolo lerawu hava menden ni laha ihi harawa re. Hako mbeek foome mende lal ni kruwuwa ambu re. Hako avak os mi mbawa nombo hom foom kowe oson ermbekwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Karem or mbaha li ermberik si layirik foome musha mendek limu kruwura. Urik foom kowe oso korona nom nari sir. ");
INSERT INTO sim_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Urik lihi ma ol bot anandik liri ondon limu ushara. Unak lirin li jelyaha foom kowe oson li tolonak si rasakmbahan. Urik li raha foome ondon bot frijip ovrok li wolorik fri hoje mendehe fasik layikuri ambek frimu nara. ");
INSERT INTO sim_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon oson or heyehe kumbambongon or huvuhu Jisashi kumbamuk or takaha ormu mbara, �Wasilaka, mir anin hala ika. An kavakavan unda ma nira.� ");
INSERT INTO sim_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Foome musha ol li kruwuri ondon or heyehe or aje menderi osik karem ormu mbara. Urik ma ol nakrem li liri ondo er nga limu ajera. ");
INSERT INTO sim_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jems fre Jon Sebedihi jikisi op Saimon nga anatambuyandari frir er nga lishnyafa ajeri vria. Urik Jisas Saimonin ormu sawera, �Mir ajewa hala. Ter foomen mimu kruwunduwa. Hako kumak hulaima nokopman anhik laharakwa mira.� ");
INSERT INTO sim_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Karem or mbarik bot lihi ovron li longo lahara fa mambuk li halaha mbele mbele amber er nga orok li halaha Jisasin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nindi las wolok Jisas yanga lasik ormu lira. Urik okmbale lepra yok afurandari ma lar or taha Jisasin or heyehe misambik taka avermbuwaha ormu sawera, �Wasilaka, os mi rupshi nahi, anin mbanak jivik a naka.� ");
INSERT INTO sim_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Karem or mbarik Jisas tava orhin ma otohik or hauowehe normu mbara, �An mbawa jivik nakwa mira.� Karem or mbarik kolomalok okmbale lepra mendek si narik jivik ormu nara. ");
INSERT INTO sim_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Urik Jisas kwambuk orin ormu sawera, �Ai ai, mir avak ma lar tos mirin a uwan sawewa hala, wahau. Hako mi ihi maome mihin prisin mukunak os jivik mi nawan or heyeka. Uhu ofa os Moses mas or mbahandari nombo hom uka. Ushinak ma amber os jivik mi nawan li heyeka.� ");
INSERT INTO sim_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hako mashi os mbele mbele Jisas or uri angop yanga yangak iri sir. Uri osik ma musha mendek mashi orhin misikmbaha rari lir. Uhu lal or mbanak os li kavamisinda lihi oso mendek si nakmbaha tari lir. ");
INSERT INTO sim_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hako hindi mushak man or halaha misamtelmbamba orok Avui Wasilakan or sawekmbaha indari ri. ");
INSERT INTO sim_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nindi las wolok Jisas mashin or owesaweri wolo Farisi nga mashi Moseshin sawendari ma er nga orok liri lira. Lir yanga Jerusalem nga yanga yanga ol provins Galilik nanda nga Judiak nanda nga li halaha tari lira. Kwambu Avui Wasilakahi Jisashik si nashirik ma ol kavamisindarin or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Urik ma lar kumba tava nashindarin teye os or wari nga Jisashik limu kasha laharara. Uhu pasir or liri mishik owekmba limu ura. ");
INSERT INTO sim_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hako ma musha mendek orok li liri osik mbeek fiala hambari ambu sir. Ushirik aka os Jisas liri akamba heyeyok limu lalawura. Uhu akamasuwu kas li lunduhu teye os or wari oson kuvuk li tihi li tolorik ma ondo liri mishik ormu layira. Uhu Jisas siri mishik li oweshirik ormu wara. ");
INSERT INTO sim_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas wavu lihin or heyeri lir angop orin li hishioweri osik ormu mbara, �Anhi kup. Kavakava mihi angop a laha ormbewa sir.� ");
INSERT INTO sim_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Karem or mbarik mashi Moseshin sawendari ma nga Farisi ondo nga mashi oson li misihi lihi ambek limu mbara, �Ma toto lawe toria? Toto Avui Wasilakahi farniyik sikwak mbandar? Ma lar mbeek kavakava ma undan laha ormbendahi ambu ri. Oso lerawu Avui Wasilakahi sir.� ");
INSERT INTO sim_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hako Jisas os wavu wavu lihik li hishiri angop or heyeri osik ormu mbara, �Mberem ushiwak wavu jihik erem ji hishindu? ");
INSERT INTO sim_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hako mberem a undahik ji hishindu? Kavakava ma roto uwan a laha ermbendahik ji hishindu mo orin a mbanak jivik or nandahik jimu hishindu? ");
INSERT INTO sim_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hako avak a mukunak ji heyekwa sir, Ma Jikisi Avui Wasilakahi oto kavakava ol ma undan laha ermbendahi ri.� Karem or mbaha ma or kavamisindari oton or heyehe ormu mbara, �Mir usaha teye mihin laha aka mihik ika.� ");
INSERT INTO sim_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Urik li heyerik kolomalok or usaha teye orhi os or wari oson or laha hi Avui Wasilakahin or hauowehe aka orhik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Urik ma amber os or urin li heyehe er li lishnyafaha li ajehe hi Avui Wasilakahin limu hauowera. Uhu limu mbara, �Ter mbele mbele mas ni heyenda ambu os nimu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Urik Jisas or ihi takis yan landari ma lar, hi orhi Livai, opis orhik lerawun or larik ormu heyera. Orin or heyehe ormu mbara, �Mir usaha anin tiya shi ika.� ");
INSERT INTO sim_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Karem or mbarik or usaha mbele mbele orhi amber or halaha normu Jisasin tiya ira. ");
INSERT INTO sim_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Uhu hiyawu las Jisasnjik aka orhik ormu ura. Urik takis yan landari ma lal nga hovok ma ome lal nga li taha limu ara. ");
INSERT INTO sim_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Urik Farisi nga lihi ma ol mashi Moseshin sawendari ondo nga oson li heyehe Jisasin tiyandari ma ondon limu mbahanjira, �Mberem ushiwak tol takis yan landa ma nga kavakavan unda ma nga nakrem ji andu?� ");
INSERT INTO sim_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Karem li mbarik Jisas mu mbara, �Ma ol jipmisinda mbeek doktak inda ambu lir. Ma ol kavamisinda nom doktak inda lir. ");
INSERT INTO sim_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","An mbeek, �Nir ma jivi,� karem hishinda ma ondo nga najer ni lijehe na tari ambu nir. An ma ol kavakavan unda ondonjik a tari nir. Ushinak sunguwavu lihin li tormblehe anhik li rakmbahan.� ");
INSERT INTO sim_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Urik limu mbara, �Jonin tiyanda ma hindi mushak akwan li halaha Avui Wasilakan sawenda lira. Hovok Farisi ondon tiyanda ma ondo nga erem unda lir. Hako mirin tiyanda ma mbeek erem unda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Karem li mbarik Jisas mu mbara, �Mberem ji hishindu? Os ma lar or nokoplaha hiyawu wasilakan or uwa wolo, orhi ma ondo akwan nakrem or nga anda ol mo wahau? Akwan anda ol te. Akwan li aha or nga rupshinda lir. ");
INSERT INTO sim_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hako kumak ma oton li tolo laha ishinakip akwan halakwa ola.� ");
INSERT INTO sim_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Karem mbaha sauheima las er nga normu sawera, �Os ma lar kowe shimbla orhi si frehe nahi, mbeek kowe akrin or frehe kowe shimbla orok or owetlavanda ambu sir. Os erem or uwa, kowe akrin or sambunak kavak er nakwa sir. Unak kowe shimbla frehenda oso nga kavak er nakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uhunda hom ma lar mbeek wain uku akrin or laha memesishi masi orok ngoronda ambu ri. Os erem or u nahi, wain uku akri oso avak si kisha larasanak memesishi masi oso avak numbufaakwa osa. Unak wain uku oso misambik ngororaka ikwa osa. Unak memesishi oso nga kavak nakwa osa. ");
INSERT INTO sim_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Erem si nanda osik wain uku akri oso avak memesishi akrik li ngorokwa sira. ");
INSERT INTO sim_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hako ma or wain uku masin or awak jivik nawak misinda ma oto mbeek wain uku akrin akwak hishinda ambu ri. �Wain uku masi jivi sira,� karem mbakwa ria.� ");
INSERT INTO sim_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Urik am Sabat wolok si narik Jisas le wit nowe nindik limu ira. Uhu orin tiyandari ma wit sijin li tolntlehe li sengashihi limu ara. ");
INSERT INTO sim_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Urik Farisi lal li heyehe limu mbara, �Mberem ushiwak os Sabatik ni lakwan lo si pantlendan ji landu?� ");
INSERT INTO sim_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Karem li mbarik Jisas mu mbara, �Os king Devit nga orin tiyandari ma nga li erenghari wolok or uhundari mashi os jekambak li kayehendarin heyenda ambu oj? ");
INSERT INTO sim_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aka Avui Wasilakahik or layihi ofan li undari bretin or laha nor aha ol orin tiyandari man or harik li arin. Bret ondo pris nom li andari lir, ma anandi wahau.� ");
INSERT INTO sim_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Karem mbaha ormu mbara, �Sabat oso Ma Jikisi Avui Wasilakahi orhi siyok nanda sir.� ");
INSERT INTO sim_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat ome las wolok Jisas Judama lotu undari akak or layihi ormu mashin sawera. Urik ma lar tapmama orhi nashindari orok er nga ormu lira. ");
INSERT INTO sim_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Urik mashi Moseshin sawendari ma nga Farisi nga orok li lihi Jisasin limu lishi heyera, os ma toton Sabat wolok or mbanak jivik or na nahi, orin li kotim ukmbahan. ");
INSERT INTO sim_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hako Jisas mbele mbele os wavu lihik li hishiri angop or heyeri sir. Uhu ma or tava kava oton ormu mbara, �Mir usaha ta, nindi torok sinak li heyeka.� Karem or mbarik ormu ta sira. ");
INSERT INTO sim_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Urik Jisas mu lirin sawera, �Jirin amu silikuwa. Mashi Moseshi mberem si mbandu? Sabat wolo lerawu jivin ni laha man ni jelyandahi os mo lerawu kavan ni laha man ni mandingormendahi os?� ");
INSERT INTO sim_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Karem or mbaha ma ol orok siri ondon or heyehe ma oton ormu sawera, �Tava mihin sanguananak a heye.� Karem or mbarik os or mbari hom or urik tava orhi indik jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Urik ma ol mashi Moseshin sawendari ondo nga Farisi ondo nga wavu lihi indik kavak er si narik lihi ambek olmu mbara, �Jisas toton mberem nivai uku?� ");
INSERT INTO sim_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Oro wolok Jisas Avuin or sawekurik telemba lasik ormu lawura. Uhu nor sawehe ihi er simu harara. ");
INSERT INTO sim_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Am si hararik orin tiyandari ma ondon or usharik li tarik lihi nindik ma 12-pela ondon ormu kamara. Uhu lirin aposel, karem ormu ushara. ");
INSERT INTO sim_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aposel ondo hi lihi kalira. Saimon or Jisas Pitak or ushari oto nga, maha orhi Andru nga, Jems fre Jon nga, Filip nga Bartolomyu nga, ");
INSERT INTO sim_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu nga Tomas nga, Jems jikisi Alfiushi nga, kraha Selotik fehendari Saimon oto nga. Kraha Selotik fehe ma ondo yanga Romik fehe gavmanin jihi tukru ermbekurik awun undari lir. ");
INSERT INTO sim_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Uhu Judas jikisi Jemshi oto nga Judas Iskariot or kumak Jisasin ma kavahi tavarenjek hakuri ma oto nga ormu kamara. ");
INSERT INTO sim_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lirin or kamalaha telemban li halarakaha lewakuk limu sira. Urik orin tiyandari ma nga ma ol provins Judiak tari nga Jerusalemik tari nga yanga op solwara sumbuk nanda Tair nga Saidon nga orok tari ondo nga musha mendek orok limu tirsara. ");
INSERT INTO sim_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lir mashi Jisashin li misikmbaha talandirsari lira. Unak or mbanak kavamisindari ma jivik li nakmbahan. Hako wasimalengamba tolondari man or mbarik er nga jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kwambu wasilaka Jisashik si narik kavamisindari man or mbarik amber jivik li nari osik ma amber jivik li nakmbaha Jisashi maomen limu tolokmba ura. ");
INSERT INTO sim_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas ma ol orin tiyandarin or heyehe ormu mbara, �Erndakava jirin, Avui Wasilaka kwambu orhi nga jirin or arangoshindak ji linda osik ter ji rupshika. ");
INSERT INTO sim_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jir erenghambar liwa ma jirin, kumak avak ji aha sungu tuvaha likwa osik ter ji rupshika. Jir tlaholowa ma jirin, kumak avak ji haimbayikwa osik ter ji rupshika. ");
INSERT INTO sim_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Os ma jirin li ngriaha mashi kavakavan jirin li mbaha hi jihin li unak kavak si na nahi, men ji rupshika. Mberem ushiwak? Jir Ma Jikisi Avui Wasilakahin ji tiyanda osik os orin kavak li uri hom jirin erem kavak li ukwa oja. ");
INSERT INTO sim_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Os jirin kavak li uwa wolo sunguwavu mende jihi nga ji rupshika. Mberem ushiwak? Mbele mbele ol Avui Wasilaka jirnjik or hundujenda ondo jirin hevenik olmu nikishinduwa. Uwa osik ji rupshika. Mas wolo neloko avoko lihi erem profet ondon kavakavak undari lir. ");
INSERT INTO sim_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Hako jir ter ya nga nawa ma jirin, ji auheyeka. Jir angop mbele mbele jivi nga ji naha ji rupshiwa osik kumak mbele las lakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jir ter aha sungu tuvawa ma jirin, ji auheyeka. Kumak avak erenghambar likwa jir. Ma jir ter rupshiwa ma jirin, ji auheyeka. Kumak avak tlakwa jir. ");
INSERT INTO sim_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ji misi. Ma misambik fehe ondo neloko avoko lihi mas wolo haimba handambanda profet ondo hi lihin li hauoweri lir. Uwa osik os ter wolo ma misambik fehe hi jihin li hauowe nahi, ji auheyeka.� ");
INSERT INTO sim_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas mashi lal nga ormu sawera, �An mashi kason ma jir mashi anhin misiwa jirin amu sawenduwa. Jir avak wutari jihin wapnuku jihik ji oweka. Uhu ma ol jirin kavakavak uwa ondon armesarmek ji uka. ");
INSERT INTO sim_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma ol jirin kavak ukmbaha hishiwa ma ondo Avui Wasilakan ji sawenak lirin armek or uka. Uhu ma ol jirin kavakavak mbawa ondo Avui Wasilakan ji sawenak avak armek lirin or uka. ");
INSERT INTO sim_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Os ma lal jirin li jimblalana nahi, tormbleshinak yoko nga li jika. Os kousamba jihin li lakunak li mba nahi, anandi las er nga ji haka. ");
INSERT INTO sim_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Uhu os ma lal jirin mbele mbelenjik li sili nahi, os li siliwa oson ji haka. Os ma lal mbele mbele jihi lal li flarna lawa indiyok ji lakwak mbawa hala. ");
INSERT INTO sim_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Os ma jirin armek li ukmbaha ji hishinda hom, jir nga ma anandin erem ji uka. ");
INSERT INTO sim_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jir avak ma ol jirin rupshinda ma ondo nom ji rupshiwa hala. Kavakavan unda ma ondo er nga ma ol lirin rupshinda man rupshinda lir. Os ma ol jirin rupshinda nom ji rupshi nahi, wa jir mbeek kavakavan unda ma ondon tikrinda ambu jir. ");
INSERT INTO sim_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Os jirin armek unda ma ondo nom armek ji u nahi, ol kavakavan unda ma ondo nga nakrem nanda jira. ");
INSERT INTO sim_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jir karem hishinda jir. Ma toto yan a handa wasan indik hakwa ria. Karem ji hishihi ji ha nahi, wa oso mbeek lakak nanda ambu sir. Mberem ushiwak? Ol kavakavan unda ma lir erem unda ola. Uwa osik jir nga lir nga nakrem nanda jir. ");
INSERT INTO sim_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hako wutari jihin wapnuku jihik ji owehe lirin armesarmek ji uka. Uhu avak mbele mbelen ji hashihi indiyok wasan li hakmbaha ji hishiwa hala. Men yelndam ji haka. Erem ji uhu Avui Wasilakahi jikisi indingok ji nanak kumak avak wasa jihin or hakwa jir. Ji misi. Avui Wasilaka ma ol kavakavan uhu orin armek mbanda ambu ondon er nga armek or unda lir. ");
INSERT INTO sim_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Or ma amber jipjip unda ri. Unda osik jir nga erem os or unda hom ji uka.� ");
INSERT INTO sim_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","�Jir avak ma uwa yokon ji oweioweiheyehe ji mba, �Avak hik ikwa lir,� karem ji mbawa hala. Os erem ji mba nahi, Avui Wasilaka kumak avak jirin erem mbakwa ri. Os ma anandin ji oweioweiheyehe lir kava, karem ji mba nahi, Avui Wasilaka erem jirin wasan ukwa ri. Hako jir ma ol jirin kavak uwa man karem ji mbaka, �Wa mberem uwana, am nawa kava sir.� Unak kavakava os jihik nandan Avui Wasilaka avak erem jirin or mbaka. ");
INSERT INTO sim_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jir avak man mbele mbelen ji haka. Unak Avui Wasilaka mbele mbelen jirin or haka. Os mbele mbelen jirin or hakwa, avak armek jirin er or heilakaila mende hakwa ri. Mbele mbele ol ji hahanda yombo yombokop jirin hakwa ora,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Uhu Jisas sauheima las nga lirin ormu sawera, �Mberem ji hishindu? Misokome tumunda lar am misokome tumunda lar nombon mukundahi or? Wahau. Os erem or uwa, evrembam wak tukuyikwa vri. ");
INSERT INTO sim_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sumatin lal mbeek tisa lihin tikrinda ambu lir. Vai yawur li misi ihikop, or nga nakrem nakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mberem ushiwak minimba wasilaka os misokome jihik nawan ji halashihi misupmbrunga os misokome mahasanje jihik nawan ji heyembandu? ");
INSERT INTO sim_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mberem ushiwak kavakava wasilaka os jihik nawan ji esngishashihi kavakava awarikanda os mahasanje jihik nawan ji heye ji laha ermbekwak ji mbandu? Os erem ji mbawa oso mbeek kas tolonda ambu sir. Masmas kavakava wasilaka jihin laha ermbeshihi mahasanje jihin ji heyembaha jivai laha ermbeka.� ");
INSERT INTO sim_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","�Mi jivi mbeek akwa kavan wanda ambu sir. Uwak mi kava mbeek akwa jivin wanda ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hako mi akwa omen si wawak li heyehe ol vai mbaw, �Mi osok amu heyenduwa.� Kupmbale mbeek wain sijin li wanak ji nimbakwa ambu sir. Uhu minjambale ondo mbeek fik sijin li wanak ji nimbakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma jivi wavu orhi ukwa jivi hom nanda sir. Mbele mbelen or uwak ukngrahambi hom osmu orhik tasawak nimu heyenduwa. Ma kava wavu orhi ukwa kava hom nanda sir. Uwak mbele mbele kava os or uwa uku kava krupshinda hom osmu orhik tasawak nimu heyenduwa. Mbele mbele os sunguwavuk si nawa hom tajek si tasawak ormu mbanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","�Mberem ushiwak anin, �Wasilaka, Wasilaka.� Karem ji mbashihi mbeek mashi anhin ji tiyanda ambu jir? ");
INSERT INTO sim_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma or anhik taha mashi anhin tiyawa ma oto karem nanda ri. ");
INSERT INTO sim_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ma oto akan or ukwak wormbowan or koroho wormbonawan or falehe sunja lakak or jishiwak si mborna sinda hom nanda ria. Ushihi akan or ushiwak osmu sinduwa. Ma rakaha fa si rasawa wolo, aka oso mbeek tarvlarakakwa ambu sir, wahau. Mberem ushiwak? Angop or tolmiskalmisihi nor uhunda osik osmu kwambuk sinduwa. ");
INSERT INTO sim_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hako ma or mashi anhin misindiyawa ambu ma oto aka orhin armek or unda ambu hom nanda ri. Wormbonawan armek or tolmiskalmisihi sunjak or jihinda ambu osik aka oso mbeek kwambuk sinda ambu sir. Uwak fa rasawa wolo os simu jitarvlawak takaha osmu kavak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas mashin am or sautakorik li misirik or halaha yanga Kaperneamik ormu layira. ");
INSERT INTO sim_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma or maifuk sihi awun undari ma, kepten, karem li ushandari lar orok lindari ri. Or Romik fehe lar oria. Ornjik lerawun landari ma lar armesarmek lerawun or landari osik kepten oto orin rupshi mendendari ri. Hako ma oto kavamisihi hakmba uri ri. ");
INSERT INTO sim_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","4","Urik kepten Jisas yanga orok or taha liri mashin li sawerik or misihi or mbashirik Judama lida lihi lal orin sawekurik limu ira. Unak or taha ma or ornjik lerawun landari ma oton or mbanak jivik or nakmbahan. Jisasin li ta sawe laha ikmbaha armesarmek limu mbara, �Kepten oto ma jivi mende orik orin jelyaka. ");
INSERT INTO sim_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Or nir Judaman rupshinda ri. Ni lotu unda aka las nirnjik uri ri.� ");
INSERT INTO sim_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Karem li mbarik or misihi lir nga normu ira. Li ihi am akayanga pasir li narik kepten oto orhi ma lal or mbashirik li ihi nombok Jisasin limu sawera, �Kepten mashi orhin mirin ni sawekmbaha or mbashiwak nimu randuwa. Mashi orhi karem. Wasilaka, an ma jivi ambu nir. Uwa osik aka anhik mi tawa hala. ");
INSERT INTO sim_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","An ma jivi ambu nir. Karem a hishihi a raha mirin a heyekwa os amu halawa. Hako, mir mashikop mbanak anjik lerawun landa ma oto avak jivik or naka. ");
INSERT INTO sim_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mir kwambu nga nawak a heyenda mir. Os mbele las mi mba nahi, mir mbawa hom avak nakwa sir. An malakamahi siyok a sihi os lir mbawa hom a unda nir. Uwak awun unda ma anhi ondo erem, anhi siyok li sihi os a mbawa hom unda lir. Os lihi lar a mba, �Mir i!� Karem a mbawa, inda ora. Hovok os lar a mba, �Mir ta!� Karem a mbawa, tanda ora. Hovok os anjik lerawun landa ma lar a mba, �Mir lerawu kason la!� Karem a mbawa, lerawu oson landa ora. Kepten karem mbawa ri.� ");
INSERT INTO sim_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Karem li mbarik Jisas or misihi ormu lishnyafara. Uhu nor tormblehe ma ol orin tiya iri ondon ormu sawera, �Mberemhi tos ter nanduwa! Samba samba oto mashi anhin misindiyanda oria. Hako jir Judama jir lar mbeek or hom mashi anhin misindiyawak a heyenda ambu jir.� ");
INSERT INTO sim_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Karem mbarik kepten mbashirik tari ma indik akak limu ira. Li ihi li heyeri ma oto angop jivik nari ri. ");
INSERT INTO sim_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kandakar nga nambek naha Jisas yanga Nainik ormu ira. Urik ma ol orin tiyandari nga ma musha mendek er nga limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Li ihi yanga inyin li washi arangondari akayanga orok am pasir li naha li heyerik ma nendekuvu lar or hashirik maninimba orhin li kishaha yanga hikriyok limu laharlara. Nijava orhi hula sihi angop maskop hashirik mumblak si naha wayandari sira. Urik yanga orok fehendari ma musha mendek olmu nokove oso nga tara. ");
INSERT INTO sim_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Urik Wasilaka nokove oson or heyehe sirnjik or holoho sirin ormu sawera, �Nyir tlawa hala.� ");
INSERT INTO sim_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Karem or mbaha teimambuk or i sihi ormu teyen tolora. Urik ol maninimba oson kisha iri ma ondo orok limu sira. Urik maninimba oson ormu mbara, �Jikanda ermbasi mirin, mirin amu mbanduwa. Mir usaha lika.� ");
INSERT INTO sim_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Karem or mbarik or usalihi normu maimbara. Urik Jisas orin or laha indiyok nijava orhik ormu halashira. ");
INSERT INTO sim_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Urik ma ondo os Jisas uri oson li heyehe limu aje mendera. Uhu hi Avui Wasilakahin metenje mendek li hauowehe limu mbara, �Profet malakama lar angop nihi nindik talawa ri.� Uhu limu mbara, �Avui Wasilaka hulaima nokopma orhin jelyakmbaha tawa ri,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Uhu mashi os Jisas uri oson provins Judia nga yanga anandi er nga limu haisau handasawe ira. ");
INSERT INTO sim_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Urik Jonin tiyandari ma ondo mbele mbele amber Jisas uri ondon li misihi Jonin limu sawera. ");
INSERT INTO sim_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Urik Jon ma ol orin tiyandari frijip or usharik frimu tara, unak or mbashinak Wasilakahik fri ihi karem fri silikmbahan, �Mir ma or hulaima nokopman jivinakmbaha Avui Wasilaka kamahanda ma om? Mo anandi lar ni nikishikwa on?� ");
INSERT INTO sim_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Karem or mbashirik ma ovro Jisasik fri taha frimu mbara, �Jon ma or man fak tolofalenda oto or mbashiwak mirin silikmbaha shimu tanduwa. �Mir ma or hulaima nokopman jivinakmbaha Avui Wasilaka kamahanda ma om? Mo anandi lar ni nikishikwa on?� Karem mirin silikmbaha or mbashiwak shi rawa shir.� ");
INSERT INTO sim_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Os fri tari wolo indingak Jisas ma musha ol kavamisindari ondo nga wasimalengamba tolondari nga nor mbarik jivik li nari wolo sira. Uhu misokome tumundari er nga nor mbarik indiyok limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Uri osik ma op orin silikmbaha tari ovron karem ormu sawera, �Indiyok Jonik shi ihi mbele mbele os shi misiwa nga shi heyewa nga orin shi sawenak or misika. Misokome tumunda li heyewak, kumba nashinda li eseyawak, okmbale lepra tolonda li jivik nawak, mamblajinda li misiwak, ma ol hahanda indiyok li usahawak, erndakava mashi jivi Avui Wasilakahin olmu misinduwa. ");
INSERT INTO sim_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Uhu kason er nga orin shi saweka, ma ol mbele mbele a uwan heyehe anin wapkava hishiwa ambu ondo li rupshika. Avui Wasilaka lirin armek or ukwa lira,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Am fri hala ishirik ma ol orok liri ondon ormu sawera, �Misamtelmbamba orok ji ihi Jon mberemhi mak or narik ji heyer? Apmbayise os suwa si rasa laha ermbewak ayai ayaranda hom or narik ji heyeri or? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mo, ji ihi mbele menden ji heyer? Kowe jiviwavin or faleshirik ji heyeri or? Wahau. Ma ol kowe jiviwavin falehe mbele mbele jivi nga nanda ondo malakamahi akakop linda lir. ");
INSERT INTO sim_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hako ji ihi mberem or narik ji heyer? Ji ihi profet lar heyeri oj? He, oto profet oria. Jirin amu sawenduwa. Or profet ondon amber tikrinda ria. ");
INSERT INTO sim_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon oto jekamba Avui Wasilakahik karem li kayendari ma ria. �Misi, avak ma lar a halashinak masmas or ihi nombo mihin hundujekwa ria.� ");
INSERT INTO sim_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Uwa osik jirin amu sawenduwa. Jon oto ma misambik fehe amber ondon tikrihi wasilakak nanda ri. Hako Avui Wasilaka hulaima nokopman or arangoshinak yanga orhik li likwa wolo ma ol hi ngashi ambu ondo Jonin tikrikwa lir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jisas Jon or nandarin or sawerik ma amber li misihi takis yan landari ma er nga karem limu hishira, �Mbele mbele Avui Wasilaka or uhunda ondo worna mende lir,� karem limu hishira. Mberem ushirik? Angop sunguwavu lihin li tormbleshirik Jon fak or tolofaleri ola. ");
INSERT INTO sim_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hako Farisi ondo nga mashi Moseshin sawendari ma nga, wahau. Mashi jivi Avui Wasilakahi os li misirin mblarnari lir. Mberem ushirik? Lir mbeek sunguwavu lihin li tormbleshinak Jon fak or tolofalekmbaha hishiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Uri osik Jisas lirin ormu sawera, �Wa ter liwa ma jirin, jir mberem nanda ma jir? ");
INSERT INTO sim_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jir jikisakri os ma li tirsanda mishik li sihi mainlaka lakak mbanda hom nanda jir. �Wakun ni tokowa wolo jir mbeek rupshihi nir nga mblanda ambu jir. Matlahukwan ni korowa wolo jir nir nga tlanda ambu jir.� Karem olmu mbanduwa. ");
INSERT INTO sim_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uhunda hom jir jikisakri ondo hom nanda jir. Jon akwan or halaha wain uku nga nor halarik ji heyehe jimu mbahanjira, �Toto wasimalengamba tolonda orik akwan anda ambu ri,� karem jimu mbara. ");
INSERT INTO sim_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hako Ma Jikisi Avui Wasilakahi oto akwa nga wain uku nga or awak ji heyehe jimu mbanduwa, �Ayo, toto akwa nom or hishihi uku kavan or aha ambasinda ri. Takis yan landa ma nga kavakavan unda ma nga ananaimble tolonda ri,� karem mbahanjinda jir. Hako os erem ji heilakaila mbanda oso kas tolonda ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hako ma or hishiyarinda nga nawa oto mbele mbele jivi nom or unak ni heyehe karem ni mbakwa nir, �Or hishiyarinda ma ria.� � ");
INSERT INTO sim_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nindi las wolok Farisi ma lar Jisas nga fri akmbaha normu mbara. Urik or ihi aka orhik frimu ara. ");
INSERT INTO sim_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kavakavan undari nokove las yanga orok lindari sira. Si misiri Jisas Farisi oto nga frimu ara. Urik nokove oso sunja botol os wel uku arme kuvasahandan li ngorohondari oson si laha simu tara. ");
INSERT INTO sim_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Si raha Jisashi kuma yok kumbamu orhik simu sira. Uhu si tlarik miuku sihi si ngoroho orhi kumbak simu takara. Si takarik masikukwa sihik simu fiyira. Uhu kumba orhin makaptakhavan tlendari hom simu ura. Uhu wel uku arme kuvasahanda oson kumba orhik si ngoro simu tara. ");
INSERT INTO sim_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Urik Farisi or Jisas nga fri akmbaha mbari oto erem si urin or heyehe ormu hishira, �Os ma toto profet indingak or nandakop, nokove tos orin tolowan armek or heyewa sir. Nokove toso kavakavan unda nokove sir.� ");
INSERT INTO sim_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Karem or hishirik Jisas wavu orhik or hishirin or heyehe orin ormu sawera, �Saimon, an mashi las mirin a sawekwak amu hishinduwa.� Karem mbarik ormu mbara, �Tisa, wa saweka.� Karem or mbarik ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","�Ma frijip ma larhik wasa nga nari vri. Lar 100 kinak, lar 10 kinakop nari vri. ");
INSERT INTO sim_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hako frir mbeek ya wasa orhin indik handahik nari ambu vri. Urik ma oto wasa orhi oson or sauntleshirik osmu mendek nara. Urik lawe mende orin warje nga rupshir?� ");
INSERT INTO sim_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Karem or mbarik Saimon mu mbara, �An a hishiwa, ma or wasa nga wasilakak nahanda ma otona.� Karem mbarik ormu mbara, �Wavu mihi osmu krahak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Karem mbaha or tormblehe nokove oson or heyehe Saimonin ormu sawera, �Nokove toson heyeka. An aka mihik a tawa, mbeek uku kas mi hawak kumba anhin a yokowa ambu nir. Hako nokove toso miuku sihik kumba anhin si yokoho masikukwa sihik kumba anhin simu fiyinduwa. ");
INSERT INTO sim_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mir mbeek anin makaptakhavan tlewa ambu mir. Hako nokove toso kumba anhin si makaptakhavan tlehe ihi osmu ter nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mir mbeek wel ukun mi laha masiji anhin tawa ambu mir. Hako toso wel uku arme kuvasahanda oson si laha kumba anhin osmu tanduwa. ");
INSERT INTO sim_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Uwa osik mirin amu sawenduwa. Kavakava musha ol si uhundan angop a yoko ermbeshiwak warje mende nga anin simu rupshi mendenduwa. Hako ma or mba, �An mbeek kavakavan warje nga a unda ambu nir.� Karem mbanda ma oto kavakava orhin a yoko ermbewa wolo kandakar nom anin ormu rupshinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Karem mbaha sirin ormu sawera, �Kavakava ol nyi unda ondo angop a yoko ermbewa lir.� ");
INSERT INTO sim_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Karem or mbarik ma ol orok liri ondo mashi os or mbarin li misihi wavu lihik limu hishira, �Ma toto lawe mende tori? Or mberem or nanda osik kavakava ma undan or yoko ermbekwak or mbandu?� ");
INSERT INTO sim_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Urik Jisas nokove oson ormu sawera, �Os anin wavu nyihik nyi owewa oso uwak kavakava nyihi osmu mendek nanduwa. Uwa osik rupshihi ika,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ushi naha Jisas yanga yangak or ihi mashi jivi Avui Wasilakahi os hulaima nokopman or arangoshinak yanga orhik li likwa oson ormu saweyara. Ma ol orin tiyandari 12-pela ondo er nga iri lir. ");
INSERT INTO sim_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Urik nokove ol wasimalengamba tolorik Jisas mbru ermbendari ondo nga nokove ol kavamisirik or mbarik jivik nahandari ondo nga orin tiya iri lir. Las Maria Makdalak fehendari sir. Wasimalengamba 7-pela ol sirin tolondarin Jisas or mbru ermbendari lir. ");
INSERT INTO sim_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Las Joana, Kusahi nokove sir. Kusa oto king Herothi mbele mbelen washilindari ma ria. Hovok las Susana, uhu nokove anandi lal nga mushak Jisas nga iri lira. Nokove ondo ya lihin li laha Jisas nga orin tiyandari ma ondo nga li jelyakmbaha limu hara. ");
INSERT INTO sim_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yanga yangak fehe ma musha mendek Jisasik li talandirsarik sauheima las ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","�Ma lar wit sijin or laha nowek ormu faka ira. Or laha faka irik lal olmu nombok takara. Urik ma esnerkoyarik avi mu nongo ara. ");
INSERT INTO sim_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hovok lal olmu sunja hongondari mishik takara. Uhu li tungua rasari ol te. Hako misambi mbeek uku nga nari ambu osik siji ondo olmu amber hatlayira. ");
INSERT INTO sim_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hovok lal olmu minja lame ngashi nindik takara. Urik minja lame ngashi ondo er nga li tasaha ol limu mushi arangora. ");
INSERT INTO sim_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hovok lal olmu misambi jivik takara. Uhu li tungua rasaha akwa ome musha mendek olmu wara.� Jisas sauheima kason or saweshihi normu wasilakak mbara, �Ma ol mambla ngashi halanak mashi kason li misika.� ");
INSERT INTO sim_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Urik orin tiyandari ma ondo mashi os sauheimak or saweri maintontlo sihin li yarikmbaha limu silira. ");
INSERT INTO sim_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Urik ormu sawera, �Avui Wasilaka nombo os hulaima nokopman or arangoshinak yanga orhik li likmbaha or mbahandari nombo os mas wanyi wandari oson angop jirin a mukurik ji heyeri sir. Hako ma ondon sauheimakop a sawewak misinda lir. Li heyehe mbeek yawur heyekrahakorokwa ambu lir. Uhu mamblakop li misihi mbeek maintontlo sihin yawur yarikwa ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Uhu Jisas ormu mbara, �Sauheima kaso maintontlo sihi karem. Wit siji kando Avui Wasilakahi mashin olmu heimanduwa. ");
INSERT INTO sim_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit siji li takawa nombo oso osmu ma ol mashi Avui Wasilakahin li misiwak kolomalok Laulaka or raha mashi os sunguwavu lihik wawa oson or laha ormbendan heimanduwa. Mberem ushiwak Laulaka erem or undu? Las avak or halashinak Avui Wasilakan li hishindiyanak lirin or jivinanda ngashi, karem or hishihin. ");
INSERT INTO sim_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sunja hongonda mishi osmu ma ol mashin misihi rupshiwa ma ondon heimanduwa. Hako lir nene mbeek kasalkop layinda ambu osik nambek sinda ambu lir. Os nomorawu lihik si lawuwa, olmu kolok mashi orhin halawa. ");
INSERT INTO sim_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Minja lame ngashi mishi osmu ma ol mashin misindiyanda ondon heimanduwa. Hako mbele mbele misambik fehe musha mushak li lakwak hishinda olik wit siji supmbalapmbak li nashiwak mbeek akwa ome nga nanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hako misambi jivi oso osmu ma ol mashin misihi kwambuk toltambananda ondon heimanduwa. Mashin li tiyaha kwambuk li sitambanaha olmu akwa ome jivi nga nawa.� ");
INSERT INTO sim_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ushihi Jisas mashi las nga ormu mbara, �Ma mbeek lamin li ukruhu awuk tangrinda ambu lir. Uhu kawu siyok halhongonda ambu lir, wahau. Li ukruhu metenjek li sinjishinak si haranak ma ol aka orok layiwa avak li heyeka. ");
INSERT INTO sim_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mbele mbele amber ol ma li wanyi unda ondo kumak kormbak talarakokwa lir. Unak ma avak li heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Uwa osik ji auheyehe mashin armek ji misika. Mberem ushiwak? Os ma lar mbele mbele lal nga nor nahanda nahi, Avui Wasilaka avak mbele mbele lal nga nor hakwa ria. Hako ma or mbele mbele nga nawa ambu, avak os or hishihi nor mba, �An mbele mbele kando angop a tolowa lir.� Karem or hishiwa Avui Wasilaka avak mbele mbele orhi ondon or laha ormbekwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oro wolok Jisas nijava orhi nga maha orhi nga orin li heyekmbaha limu tara. Hako ma musha mendek li tirsaha li sishirik mbeek li i pasir li sihi li heyekurik nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Urik ma lal Jisasin limu sawera, �Mamai mihi nga maha mihi nga mirin li heyekwak li taha kandai hikrik sindu.� ");
INSERT INTO sim_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Karem li mbarik ormu mbara, �Ma ol mashi Avui Wasilakahin misindiyawa ma ondo nijava anhi jimatama anhi lira.� ");
INSERT INTO sim_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nindi las wolok Jisas nga ol orin tiyandari ma ondo nga bot lasik li lawuhu Jisas mu mbara, �Ka ni i fan mbuhu kauyok ni ika.� Karem or mbaha li ikurik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bot am si irik ormu wasuknyara. Urik suwa wasilaka mendek fa orok si tasarik uku bot akome orok si ngoro layihi si hojekurik simu nara. Urik am kavak li nakurik limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Li heyehe Jisasin li lembasi limu mbara, �Wasilaka, Wasilaka. Avak ni uk aha ni hakwa nir te.� Karem li mbarik or usaha suwa nga fa oso nga normu huliyik mbara. Urik suwa nga fa nga mendek frimu nara. ");
INSERT INTO sim_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Urik lirin ormu silira, �Jir mberema? Mberem ushiwak ji ajendua? Anin ji hishiowenda nombo mbeek si iw?� Karem mbarik os erem or uri oson li heyehe limu ajera. Uhu wavu musha mushak li hishihi limu mbara, �Ma roto lawe mende toria? Or mbawak suwa nga fa nga mashi orhin fri misihi mendek fri nawan te.� ");
INSERT INTO sim_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ushihi Jisas nga ol orin tiyandari ma ondo nga yanga Gerasak limu ira. Kuyanga oso leuku Galilin mbuhu kauyok nandari sira. ");
INSERT INTO sim_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Uhu Jisas botin or halaha or rakarik kuyanga orok fehe ma lar Jisasik ormu tara. Ma oto wasimalengamba lal tolondari ria. Mas hoje mende mbeek waskowen falendari ambu ri. Uhu mbeek aka lasikop lindari ambu ri, wahau. Or mawa mashikop lihi yandari ria. Kumba tava orhin sen kuvuk li ishishihi orin washilindari lira. Hako kuvu ondon simbalesik or jilakorola ormberik wasimalengamba ondo urik or ihi misamtelmbamba orok lihi yandari ria. Urik Jisas wasimalengamba ondon ormu mbara, �Jir ma toton ji halaha ji ika.� Karem or mbarik ma oto Jisasin or heyehe nor tashihi orhi kumbamuk pasir ormu taka avermbuwara. Uhu wasilaka mendek or jisuwu ormu mbara, �Jisas, mir jikisi Avui Wasilakahi metenjek fehe mira. Anin mberem mi ukwak mi undua? Anin kavak uwa halawa.� ");
INSERT INTO sim_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Karem mbarik Jisas wasimalengamban ormu silira, �Hi mihi lawe?� Karem or mbarik limu mbara, �Hi anhi �Musha Mende� sir.� Mberem ushirik? Wasimalengamba musha mendek ma orton tolondari ola. ");
INSERT INTO sim_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Uhu wasimalengamba ondo wasilaka mendek Jisasin limu ushara, �Mir avak nirin mbashinak ni ihi wa kasalkop nandak ni layiwan ni hala.� ");
INSERT INTO sim_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hako fle musha mendek telemba orok pasir limu sihi ara. Urik wasimalengamba ondo Jisasin limu silira, �Wa, mi mbashinak ni ihi avak fle kandaik ni layika.� ");
INSERT INTO sim_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Urik Jisas mbashirik ma oton li halaha i fle ondok limu layira. Urik fle ondo lewas li shirinya ihi fa orok li layihi uk aha limu hara. ");
INSERT INTO sim_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Urik flen washilindari ma ondo erem si narik li heyehe limu tulu ira. Uhu mashi oson limu yanga yanga orok sawe ira. ");
INSERT INTO sim_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Urik ma mushak li raha os orok talari oson limu heyera. Li taha li heyeri wasimalengamba ma oton li hala ishirik wavu jivik or hishihi waskowen or falehe kumbamu Jisashik ormu lira. Oson li heyehe li lishnyaha limu ajera. ");
INSERT INTO sim_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Urik ma ol mbele mbele ol orok talarik heyeri ma ondo mbele mbele Jisas ma oton or urik li heyeri oson limu sawera, �Mas wasimalengamba musha orhik nandari lir. Hako ter angop jivik nawa ri.� ");
INSERT INTO sim_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Karem li mbarik ma amber yanga Gerasak fehe ondo li ajehe wavu musha mushak limu hishira, lerawu wasilaka Jisas uri oson. Uhu yanga lihin or hala ikmbaha limu mbara. Urik Jisas botik or lawuhu indiyok or ikurik or urik ");
INSERT INTO sim_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","ma or wasimalengamba hala ishirik jivik nari ma oto Jisasin ormu silira, �Am mi mbanak a raha a ngashi ikundan mo?� Hako Jisas ormu mbara, �Mir indiyok yanga mihik ihi mbele mbele amber Avui Wasilaka os mirin or jelyawa mashi oson saweka.� Karem or mbashirik indik yanga orhik ormu ira. Uhu mbele mbele os Jisas orin or urik jivik or nari mashi oson yanga orhi orok fehendan ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Urik Jisas leuku tasayok indik ormu tara. Ma amber orin li nikishiri osik or tarik li heyehe limu rupshira. ");
INSERT INTO sim_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Urik ma lar Jisasik ormu tara. Hi orhi Jairus. Or Judama lotu undari akan washilindari ma lar oria. Or taha Jisashi kumbamuk or taka avermbuwaha or nga aka orhik fri ikmbaha normu silira. ");
INSERT INTO sim_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Or jikisnokopji kanda namtas nom nahandari ri. Asama sihi 12-pelak nandari sir. Uhu am si hakuri ambek nari sir. Urik Jisas mu ira. Or irik ma musha mendek er nga li ihi limu orin rurawu mendera. ");
INSERT INTO sim_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Urik nokove las os fi nom ermbendari er nga iri sir. Os fi nom si ermbendari oso asama 12-pelak nari lir. Jivik si nakmbaha doktak si ihi ya sihin sembe sambuyandari sir. Hako ma lar mbeek os erem si nandarin or urik jivik nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uri osik nokove oso Jisashi kuma yok si ta sihi kowe orhin simu tolora. Erem si urik kolomalok os fi nom si ermbendari oso mendek si nashirik jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Urik Jisas mu silira, �Lawe anin tolondua?� Urik amber limu mbara, �An nembes.� �An nembes.� Urik Pita mu mbara, �Tisa, ma musha mendek tirsaha rurawu te.� ");
INSERT INTO sim_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Urik Jisas mu mbara, �Lar anin tolowa ri. Uwak a misiwa kwambu anhi kas angop anin halaha iwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Urik nokove oso mbeek si wanyikurik nari ambu, karem si hishihi si kwarnguar naha Jisasik si taha kumbambongon si huvuhu simu maruknyara. Uhu simu mbara, �Os a kavamisihi fi nom a ermbenda osik mirin a toloho jivik avai naku, karem a hishihi mirin amu tolowa. Uwak kolomalok jivik amu nawa.� ");
INSERT INTO sim_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Karem si mbarik Jisas mu sirin sawera, �Apmanuwa, os anin nyi hishiowenda nombo orok os nyimu jivik nanduwa. Uwa osik rupshihi ika.� ");
INSERT INTO sim_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mashin or mbari halanganga Jairusnjik lerawun landari ma lar or taha ormu sawera, �Jikisi mihi angop hawa sir. Las avak Jisas sembe mi mba laha shi inda ngashi.� ");
INSERT INTO sim_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hako Jisas mashi oson or misihi Jairusin ormu sawera, �Ajewa hala. Mir antonom hishioweka. Unak jikisi mihi avak jivik si naka.� Karem or mbaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Fri i heyeri ma amber jikisi osonjik li holoho limu ewetlara. Hako Jisas ormu sawera, �Ji tlawa hala. Jikisi toso hawa ambu sir. Tos men wa suknyandu.� Karem or mbarik orin kavakavan limu hukwakol tolora. Mberem ushirik? Jikisi oson li heyeri angop ha krindiri osa. Urik ma ondo akak li layikurin or pantleshihi Pita, Jon, Jems, jikisi oso avoko nijava sihi nom or laha akak limu layira. ");
INSERT INTO sim_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Uhu jikisnokopji oso tava sihin or toloho normu mbara, �Jikisi, nyir usahawa.� ");
INSERT INTO sim_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Urik masikome sihi indiyok sirik si talalayirik lewas simu usahara. Urik jikisi osonjik akwa lal li laharanak si akmbaha ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Urik avoko nijava sihi warje mende nga limu lishnyafara. Hako Jisas fririn ormu sauntlera, �Shir avak ma lar mbele mbele tos ter talawak shi heyewa toson shi sawewa hala,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas ma ol orin tiyandari 12-pela ondon or usharik li tarik kwambu orhin lirin ormu hara. Ushinak li ihi kavamisinda ondon li mbanak jivik li nanak wasimalengamba ol man tolohondan li mbru ormbeshinak jivik li nakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","5","Uhu ormu mbara, �Ji ihi Avui Wasilaka hulaima nokopman or arangoshinak yanga orhik li likwa mashin ji saweka. Uhu kavamisinda ondon ji mbanak jivik li naka. Hako jir avak mbele mbele jihi nga ji laha iwa hala. Kombe, mbele mbelen wolonda kowe nga akwa, ya, kowe lap er nga ji laha iwa hala. Am ji ihi yanga lasik ji layihi aka lasik ji layi nahi, aka orokop ji lika. Er ji lihi ihi ji ikuna wolo aka oson ji halaha yanga lasik jivai ika. Os yanga lasik ji layinak ma ol orok fehe jirin aka lasik li laha i nahi ambu, yanga oson ji halaha yanga anandik ji ika. Ji ikuna wolo, kumba jeren ji narkanak li heyehe li mbaka, �Nir angop mbele las ni uwak kavak nawa sir.� � Karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Urik ma ol orin tiyandari 12-pela ondo yanga yangak li ihi mashi Avui Wasilakahin li sawehe ma ol kavamisindarin li mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","King Herot mashi os mbele mbele Jisas lari oson or misihi wavu musha mushak ormu hishira. Mberem ushirik? Ma lal karem mbari ola, �Jon angop indik usahari ri.� ");
INSERT INTO sim_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hako lal olmu mbara, �Or Elaija ri.� Hako lal olmu mbara, �Or profet lar mas hahandari indiyok usahari ri.� Karem li mbarik or misihi wavu musha mushak hishiri ora. ");
INSERT INTO sim_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Uhu ormu mbara, �Ayo, Jon oto jekapnashi orhi angop a korori or te. Hako ma orto lawe mende ria? Lerawu os or lawa apsham apshamhin or lawak a misinda re.� Karem mbaha Jisasin heyekurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma ol orin tiyandari ondo am indik li raha mbele mbele amber os li urin Jisasin limu sawembara, mashi Avui Wasilakahin li sawehe kavamisindari ondon li mbarik jivik li nari mashin. Urik lirin or laha hulaima nokopman li halaha lirtonom yanga Betsaidak limu ira. ");
INSERT INTO sim_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hako hulaima nokopma os li iri mashin li misihi orin li heyekurik limu ira. Urik lirin or heyehe ormu rupshira. Uhu mashi os Avui Wasilaka kwambu orhik lirin or arangoshinak yanga orhik li likunda oson or sawehe kavamisindarin or mbarik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Am si homirik ma 12-pela ol orin tiyandari ondo orhik li raha limu sawera, �Ayo am homir te. Tos ni liwa mishi roso ma ngashi mishi ambu re. Tondon mi mbashinak yanga os pasir nanda mishik li layihi akwan li frungawuka.� ");
INSERT INTO sim_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Karem li mbarik ormu mbara, �Jihinjik akwan ji hanak li aka.� Urik limu mbara, �Nir akwa mushak nawa ambu re. Bret tostava yeje nom nga foome frijip nom nga ni nawa re. Wa, ni ihi akwa lal ni frungawu laharaha lirin ni ha, karem mimu hishindu? Wahau te.� ");
INSERT INTO sim_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Karem olmu mbara. Mberem ushirik? Ma ol orok liri hulaji nom li kantiri, 5,000 hom nari ola. Urik Jisas ol orin tiyandarin ormu sawera, �Ji mbanak ma tondo siji sijik li lika.� ");
INSERT INTO sim_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Urik os or mbari hom li mbashirik misambik limu takalira. ");
INSERT INTO sim_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Urik Jisas bret tostava yeje nga foome frijip nga nor laha lersuwu yok or mawuhu Avui Wasilakan ormu sawera, ushinak akwa ondon armek or ushinak or hanak li akmbahan. Uhu bretin or toltavaha foome nga ol orin tiyandarin ormu hara. Ushirik li laha ma ondon limu hara. ");
INSERT INTO sim_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Urik amber akwa ondon li aha am li krehe limu lira. Uhu akwa sumbuyambun lasikop li larandirsaha li woloshirik serkawu 12-pelak hojeri lira. ");
INSERT INTO sim_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nindi las wolok ol orin tiyandari ma nom li lirik Jisas ortonom Avui Wasilakan ormu sawera. Or saweshihi lirin ormu silira, �Ma tondo an lawe, karem li mbawak ji heyendu?� ");
INSERT INTO sim_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Karem or mbarik limu mbara, �Lal mir Jon, man fak tolofalenda ma mir, karem mbanda lir. Hako lal mir Elaija, karem mbanda lir. Hako lal mir profet mas hahandari indiyok usahanda mir, karem mbanda lir.� ");
INSERT INTO sim_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Karem li mbarik ormu silira, �Hako jir jihinjik an lawe, karem ji hishindu?� Karem or silirik Pita mu mbara, �Mir hulaima nokopman jivinakmbaha Avui Wasilaka or kamaha nor mbashirik tahanda ma mira,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hako mashi oson li laha ihi man li sawekurin ormu pantlera. ");
INSERT INTO sim_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Uhu normu mbara, �Ma Jikisi Avui Wasilakahi nomorawu mushak kishakwa ri. Malakama nga bikpris ondo nga mashi Moseshin sawenda ma ondo nga avak orin li kumaifaha li jimandingormekwa ri. Hako niri frijip fri ishinak indiyok usahakwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Karem or mbaha ma ol orok liri ondon ormu sawera, �Os anin ji tiyakunak ji hishi nahi, mbele mbele jihi amber ondon ji halaka. Uhu nomorawu os jihik talakwan miando hom ji kishaha anin ji tiyaka. ");
INSERT INTO sim_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hako os mbele mbele jihi ondon ji toltambana nahi, avak kavak nakwa jir. Hako os anin ji hishindiyaha mbele mbele ondon ji hala nahi, kumak ermba ermbak linda oson jivai laka. ");
INSERT INTO sim_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Os mbele mbele misambik fehe nga mushak ji naha mashi anhin ji tiya nahi ambu, avak kavak nakwa jir. Mberem ushiwak? Mbele mbele jihi ondo mbeek jirin jelyakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Os an nga mashi anhi nga kormbak ji sawena ambu nahi, kumak Ma Jikisi Avui Wasilakahi oto ukruharanda orhi nga ukruharanda Avui Wasilakahi nga ukruharanda enselhi nga or tana wolo, jirin or heyehe ji uhunda hom or ukwa jir. ");
INSERT INTO sim_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Omendingak jirin amu sawenduwa. Torok siwa ma lal li ha namber, avak Avui Wasilaka lirin or arangoshinak likwa oso kormbak si talanak heyekwa lir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas mashi oson or sawerakoho niri 8-pela li ishirik Pita, Jon, Jems, karem or laha Avui Wasilakan or sawekurik telembak limu lawura. ");
INSERT INTO sim_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Or lawuhu Avui Wasilakan or sawerik fumunyava orhi apsham er si narik kowe orhi nga avisha indingok er simu nara. Uhu er simu haruja mendera. ");
INSERT INTO sim_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Urik kolok ma frijip orok fri talasihi or nga maimbari lir. Ovro Moses fre Elaija vria. ");
INSERT INTO sim_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Frir Avui Wasilakahi ukruharanda nindik fri talasihi Jisas os Jerusalemik or hakundari mashin limu anasawera. ");
INSERT INTO sim_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Urik Pita le suknyarin li halaha ukruharanda Jisashi nga ma frijip orok er nga sirin limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma ovro am Jisasin fri halashi fri ikurik Pita mu Jisasin sawera, �Tisa, torok ni siwa osmu jivi mendek nanduwa. Halanak shikor aka nalmingrip torok ni uka, las mirnjik, las Mosesnjik, las Elaijanjik.� Pita mbele las or sawekurin or yariri ambu osik karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita saweri halanganga lersuwu avisha kwandi hom lirin aulafaleshirik limu aje mendera. ");
INSERT INTO sim_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Urik mashi las lersuwu nindik simu mbara, �Toto jikisi anhi ria. Orin wapnuku anhik amu owenduwa. Lerawu anhin or lakmbaha angop a kamahanda ri. Mashi orhin ji misika.� ");
INSERT INTO sim_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mashi oso am mendek si narik li heyeri Jisas ortonom orok ormu sira. Hako mbele mbele os orok li heyeri, lir mbeek ma lar kolok li saweri ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wahandashihi ma musha mendek Jisasin li nikishirik Jisas le telemban li halaha li rakarik li heyehe ");
INSERT INTO sim_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ma lar wasilaka mendek or ushaha ormu mbara, �Tisa, jikishulayi anhin mi jelyawa. An jikisi anhi namtar numbu oria. ");
INSERT INTO sim_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wasimalengamba orin or toloshiwak or ushandashi yanda ri. Uhu kwarnguarnaha suntla hermbo nom ngoronda ri. Uwak orin or mandingormekwak unda ri, mbeek kolok orin or hala ikwak hishinda ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hako mirin tiyanda man a siliri, mbeek wasimalengamba oton li mbru ermbendahik nari ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Karem or mbarik Jisas mu mbara, �Jir anin hishiowenda ambu oj? Ermba ermbak jir nga na lihi mashin angop a sawewak misinda jir. Hako jir mbeek anin hishiowenda ambu jir. Wa, jikisi oton laharaka.� ");
INSERT INTO sim_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jikisi oto Jisasik or takurik or tarik wasimalengamba orin or kisha ermberik ormu tukuyira. Uhu ormu kwarnguarna mendera. Urik Jisas wasimalengamban or ngriaha nor mbarik jikisi oto jivik ormu nara. Uhu nor halashirik indik avoko orhik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma amber kwambu Avui Wasilakahin li heyehe limu lishnyafara. Uhu wavu musha mushak mbele mbele amber os or urin limu hishira. Urik Jisas orin tiyandari man ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","�Jir mamblan armek ji owehe mashi kason ji misika. Ma Jikisi Avui Wasilakahi oto avak tavarenje ma kavahik li hakwa ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hako mashi os or mbari maintontlo sihi wanyishirik lir mbeek hishiyariri ambu lir. Uhu orin li silikurin limu ajera. ");
INSERT INTO sim_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nindi las wolok Jisasin tiyandari ma lihi nindik lawe ol malakamak naha maifu mendek siku, karem li mbaha olmu anamainkwambu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hako Jisas os sunguwavu lihik li hishirin angop or heyeri sir. Uri osik jikisakri lar or lahara oweshirik lihi nindik ormu sira. ");
INSERT INTO sim_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Uhu lirin ormu sawera, �Ma or anin hishiowehe jikisi roto hom nawan armek uwa oto anin er nga armek uwa ri. Ma or anin armek uwa, ormu Avui anhi or anin mbashirik a rahandan armek unduwa. Ma or jihi nindik erndakavak naha kombonihi hi nga nawa ambu oto Avui Wasilaka or heyewa, maifuk sinda ma ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Jisas mbari mashin or misihi Jisasin ormu sawera, �Tisa, nir ni heyeri ma lar hi mihik wasimalengamban mbru ermberi ria. Hako or mbeek nihi ma ambu orik orin nimu sauntlera.� ");
INSERT INTO sim_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Karem or mbarik Jisas mu mbara, �Orin pantlewa hala. Ma ol jirin wutarik owenda ambu ondo jihi ma lira.� ");
INSERT INTO sim_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Avui Wasilaka Jisasin or mbanak hevenik or lawukuri wolo am pasir si narik Jerusalemik or ikurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Uri osik ma lal or mbashirik masmas Samariak li ihi mbele mbelen li hundujekmba olmu ira. ");
INSERT INTO sim_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hako ma ol Samariak fehe mbeek Jisasin li laha inak yanga orok or layikmba hishiri ambu lir. Mberem ushirik? Jisas Jerusalemik or ikurik nari osa. ");
INSERT INTO sim_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Urik orin tiyandari Jems fre Jon os erem narin fri heyehe frimu mbara, �Wasilaka, mberem mi hishindu, shi mbanak hi laka las hevenik si rakaha ma ondon si ukmba mimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hako Jisas fririn or tormble heyehe ormu fririn ngriara. ");
INSERT INTO sim_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Uhu li halaha yanga anandik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nombok li irik ma lar Jisasin ormu sawera, �Yanga yanga os mi yawa, an mirin er a tiyayakwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Karem or mbarik ormu mbara, �Yawur mi hishishihin. Asa tarmbe wa ngashi lir. Avi aviwusi ngashi lir. Hako Ma Jikisi Avui Wasilakahi aka os or wakwa mishi nga nanda ambu ri.� ");
INSERT INTO sim_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ushihi Jisas ma ome lar nga ormu sawera, �Mir anin mi tiya.� Hako ma orto ormu mbara, �Halashinak a ihi avui anhin a wakor oweshihin.� ");
INSERT INTO sim_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Karem mbarik ormu mbara, �Halashi ra. Ma ol hahanda ondo halanak lihi ambek li wakor oweka. Hako mir taha mashi os Avui Wasilaka hulaima nokopman or arangoshinak yanga orhik li likwa mashin saweka.� ");
INSERT INTO sim_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Urik ma ome lar nga Jisasin ormu sawera, �Wasilaka, an mirin a tiyakwak amu hishinduwa. Hako avoko nijava, jimatama anhin a wesambasa oweshihin.� ");
INSERT INTO sim_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Karem or mbarik Jisas mu mbara, �Ma or mbele mbele ol angop or halandan indik tormble heyewa ma oto or mbeek Avui Wasilaka lerawu orhin landahik nanda ambu ri,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ushihi Wasilaka ma 72-pelak or kamaha frijipmba frijipmbak or mbashirik masmas limu ira, yanga yanga os or ikurik or hishiri mishik. ");
INSERT INTO sim_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Uhu karem lirin ormu sawera, �Akwa musha mendek angop ukruwa lir. Hako mbeek sakwa ma mushak nawa ambu lir. Uwa osik noumashama Avui Wasilakan ji silinak avak lerawun landa ma mushak or mbashinak li ihi akwa orhin li saha aka orhik li oweka. ");
INSERT INTO sim_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ji misi. Avak an mbashinak wutari nindik ikwa jir, os sipsip jikisi kala asa nindik li inda hom. ");
INSERT INTO sim_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jir avak ya nga mbele mbelen wolonda kowe nga kumba ari er nga ji laha iwa hala. Uhu jir avak ma ol nombok ji heyewa nga nambek ji anasawewa hala. ");
INSERT INTO sim_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hako os aka lasik ji i layiwa, mas karem ji mbaka, �Waphimbiji Avui Wasilakahi osmu jihik nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Unak ma or Avui Wasilaka waphimbiji orhi ma otohik nakwak or mbahanda ma aka orok or li nahi, waphimbiji Avui Wasilakahi orhik nakwa sira. Hako erem nanda ma lar aka orok or li nahi ambu, waphimbiji Avui Wasilakahi avak jihikop nakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hako aka os ji liwa orokop er ji lika. Uhu mbele mbele ol li hawa ondon ji aka. Mberem ushiwak? Lerawun ji lawa orok lerawu os ji lawa wasan hakwa ola. Uhu jir avak aka anandik ji ilai talaiwa hala. ");
INSERT INTO sim_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hako os yanga lasik ji inak aka lasik jirin li laha iwa, akwa ol jirin li hawan ji aka. ");
INSERT INTO sim_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Uhu ma ol yanga orok kavamisiwan ji mbanak jivik li naka. Uhu mashin karem ji saweka, �Avui Wasilaka jirin or arangoshinak yanga orhik ji likwa oso am si talakwak osmu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hako kuyanga lasik ji layinak os jirin aka lasik li laha i nahi ambu, men nombo orok ji sihi karem ji mbaka, ");
INSERT INTO sim_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","�Misam jere yanga jihi os kumba nihik lokowan os nimu narka lafakanduwa. Oso mashi jivi Avui Wasilakahin ji mblarnandan heimanduwa. Hako yawur ji hishi, Avui Wasilaka jirin or arangoshinak yanga orhik ji likwa oso am si talakwak osmu nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hako jirin amu sawenduwa. Avui Wasilaka os hulaima nokopma mbele mbele li uhundan or heyembakwa wolo mashi orhin mblarnanda ma ondo musa lihik nomorawu wasilakan kishakwa lir. Nomorawu oso wasilaka mendek si naha nomorawu os yanga Sodomik fehehik talahandan tikrikwa sira. ");
INSERT INTO sim_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jir yanga Korasinik fehenda ma nga Betsaidak fehenda ma nga jirnjik amu holo mendenduwa. Mberem ushiwak? Avak kavak nakwa jir. Mbele mbele ol a uri angop ji heyeri lir. Hako mbeek sunguwavu jihin tormbleri ambu jir. Hako os Judama ambu ondo linda mishi yanga Tair nga Saidon orok a ihi mbele las ma undahi ambu os jihi nindik a uhundan a uhundarikop, yanga orok fehe ma angop kavakava os li undarin li halaha sunguwavu lihin tormbleri lir. Hako jir wahau. ");
INSERT INTO sim_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Unda osik ji misi. Avui Wasilaka os hulaima nokopma mbele mbele li uhundan or heyembakwa wolo nomorawu os jihik talakwa oso wasilaka mendek si naha nomorawu os yanga Tair nga Saidon nga lihik talakwan tikrikwa sir. ");
INSERT INTO sim_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Uhu jir Kaperneamik fehe jirin. Jir am Avui Wasilaka mbanak hevenik ji lawuku, karem ji hishindu? Wahau mende indinga. Jir avak hik ikwa jir.� ");
INSERT INTO sim_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uhu Jisas ol orin tiyandari man karem ormu sawera, �Ma ol mashi jihin misiwa ondo mashi anhin misiwa lir. Ma ol mashi jihin mblarnawa ondo mashi anhin mblarnawa lir. Ma ol mashi anhin mblarnawa ondo Avui Wasilaka or anin mbashirik a rahanda mashi orhin er nga olmu mblarnanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Urik ma 72 ol Jisas mbashirik iri ondo am indik limu rara. Uhu li rupshi mendehe limu mbara, �Wasilaka, hi mihik ni mbarik wasimalengamba ondo nihi mashin li misihi hala iri lira.� ");
INSERT INTO sim_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Karem li mbarik ormu mbara, �Na heyerik Laulaka angop hevenin or halaha mawale hom taka shirinya iri ri. ");
INSERT INTO sim_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ji misi, kwambu angop jirin a hari sir. Uwa osik jir avak hovo nga listava nga ol man kavak nanda ondon esnorkokwa jir. Uhu wutari jihi Laulaka kwambu orhin avak ji tikrikwa sir. Unak mbele las avak jirin kavak nakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hako jir avak ji rupshihi karem ji mba, �Wasimalengamba ondo nihi mashin misihi hala iwa lir.� Karem ji mbanan, wahau. Avui Wasilaka hi jihin angop jekamba orhik or kayenda osik ji rupshika.� ");
INSERT INTO sim_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Urik Masikome Avui Wasilakahi or urik Jisas sunguwavu orhi nga or rupshihi ormu mbara, �Avuya, mir Wasilaka, heven nga misambi nga mihi tavakop uhunda mira. Hi mihin amu hauowenduwa. Mberem ushiwak? Mir mbeek mbele mbele ondon ma ol hi ngashi ondon mi mukushiwak heyenda ambu lir. Hako ma ol jikisakri hom nanda ondo nom mi mukushiwak heyenda lir. Ome sira, Avui, mir os mi ukwak mi hishiwa hom unda mir. ");
INSERT INTO sim_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mbele mbele ondo amber Avui anhi angop anhi tavak or halawa sir. Hako ma lar mbeek Avui Wasilaka Jikisi orhin armek heyekrahakoronda ambu ri. Avui nom Jikisi orhin heyenda ri. Ma lar mbeek Avuin heyekrahakoronda ambu ri. Hako Jikisi orhi orto nom nga ma ol Jikisi oto Avui orhin or mukushiwak heyewa ma ondo nom Avuin heyenda lira,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Os orin tiyandari ma nom or nga li liri wolo, Jisas or tormblehe lirin ormu sawera, �Ma ol mbele mbele os ji heyewa ondon heyewa ondo li rupshika. ");
INSERT INTO sim_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jirin amu sawenduwa. Mas wolo profet nga malakama mushak mbele mbele os ter ji heyewa oson heyekurik hishiri ol te. Hako mbeek heyeri ambu lir. Uhu mashi os ter ji misiwa oson misikurik hishiri ol te. Hako mbeek misiri ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Urik mashi Moseshin sawendari ma lar or usa sihi Jisasin men or mbanak or mbanak or heyekmbaha ormu silira, �Tisa, an mberem a uhu ermba ermbak linda oson avai laku?� Karem or mbarik Jisas orin ormu silira, ");
INSERT INTO sim_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","�Moses kayehendari mashi mberem si nandu? Uhu mberem si nawak mi heyendu?� ");
INSERT INTO sim_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Karem or mbarik ormu mbara, � �Mir avak wavu mihi nga masikome mihi nga kwambu mihi nga os mi hishiyarinda mihi nga Avui Wasilaka or mirin arangonda oton rupshika. Uhu mihi ma ondo er nga rupshika, os mihinjik mi rupshinda hom.� Moses kayehendari mashi oso karem nahanda sir.� ");
INSERT INTO sim_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Karem or mbarik ormu mbara, �Ome sira. Os mimu sawenduwa. Mashi oson mi tiyaha ermba ermbak linda oson mivai laka.� ");
INSERT INTO sim_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Karem or mbarik ma oto ormu hishira, �Mashi Moseshi amber a tiyarakonda nir.� Karem mbaha hi orhin or hauowekmbaha Jisasin ormu silira, �Anhi ma ol a rupshikmbaha mashi Moseshi erem si sawenda ondo lawe lir?� ");
INSERT INTO sim_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Karem mbarik ormu mbara, �Judama lar Jerusalemin or halaha yanga Jerikok or ikurik ormu ira. Or irik hirnyanda ma lal nombok li wanyi lindarik orin limu jira. Orin li jihi kowe mbele mbele orhin li laha limu hala ira. Ushirik or hakuri mendek or naha nombo orok ormu wara. ");
INSERT INTO sim_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Urik pris lar nombo orok or raha ma oto orok or warik or heyehe nombo sumbu yok orin or tikrihi ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Am or ishirik kraha Livaik fehe lar nombo orok or raha ma oton or heyehe or er nga nombo sumbu yok orin or tikrihi ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ushirik yanga Samariak fehe ma lar nombo orok or taha ma oton ormu heyera. Or heyehe wavu orhi nga ornjik ormu holora. ");
INSERT INTO sim_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uhu pasir or i sihi wel uku nga wain uku nga oje orhin or ngoroho normu ishira. Uhu orin or larasa kishaha donki heyek or hauowe laha tenje akak ormu laha ira. Uhu or layi ewehe orin armek ormu ura. ");
INSERT INTO sim_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wahandaha ya lakak aka mashama oton or haha ormu sawera, �Mir ma toton armek u. Os ya mihi lal er nga ma totonjik mi ermbe nahi, indik a rawa wolo avak ya wasa mihin a hakwa nir,� karem ormu mbara.� ");
INSERT INTO sim_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas sauheima oson or sawerakoho ma oton ormu silira, �Wa, mberem mi hishindu? Ma nalmingrip kando lihi nindik lawe mende ma or hirnyanda ma jishirik kavak nari oto orhi mak nari lir?� ");
INSERT INTO sim_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Karem or mbarik ormu mbara, �Ma or ornjik holoho laha ihi orin armek uri ma otona.� Karem or mbarik ormu sawera, �Mi ihi ma oto or undari hom mir nga erem uka,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas nga orin tiyandari ma ondo nga limu ira. Li ihi yanga lasik limu layira. Nokove las orok lindari sir. Hi sihi Marta sira. Jisasin si heyehe si rupshihi orin aka sihik simu la layira. ");
INSERT INTO sim_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta oso maha sihi Maria sira. Maria kumbamu Jisashik si ra lihi mashi orhin simu misira. ");
INSERT INTO sim_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hako Marta hiyawun si ukuri wasilakak si nashirik Jisasik si ihi simu mbara, �Wasilaka, maha anhi toso anin si halashiwak nendekop akwan amu unduwa. Wa, mi heyewa kom? Mi mbashinak si raha anin si jelyaka.� ");
INSERT INTO sim_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Karem si mbarik Wasilaka mu mbara, �Marta, Marta, nyir mbele mbele ondonjik hishombashiowew te. ");
INSERT INTO sim_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nyir os Maria lakwak si hishiwa oso nom lakwak hishika. Oso jivi mende sira. Uwa osik os si lakwak si liwan mbeek nyi pantlekwa ambu sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nindi las wolok Jisas yanga lasik Avui Wasilakan sawekurik ormu ira. Or sawerakorik orin tiyandari ma lar orin ormu silira, �Wasilaka, Jon ma ol orin tiyanda ondon nombo os Avui Wasilakan li sawekundarin or mukuri lir. Uhunda hom mir erem. Nombo os orin ni sawekundan mukunak ni heyeka.� ");
INSERT INTO sim_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Karem or silirik ormu mbara, �Os Avui Wasilakan ji sawekwa wolo karem ji saweka. Avui, halanak ma amber hi mihin li hauoweka. Kwambu mihik nirin mi arangoshinak yanga mihik ni likwa oso halanak si nama naka. ");
INSERT INTO sim_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akwa os ter ni akmbaha ni mbawa oson nirin hanak ni aka. ");
INSERT INTO sim_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mir avak kavakava os ni undan laha ermbeka. Os nir ma nirin kavakavan li uwak mirin ni sawewak kavakava lihin mi laha ermbenda hom, kavakava nihin laha ermbeka. Mir avak jeikayenda nihik si talakwan arangoka.� ");
INSERT INTO sim_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Karem mbaha lirin ormu mbara, �Os jir lar nirkundi mendek jihi kup larik or ihi or mba, �Anhi kup, bret nalmingrip anin mi hawa. ");
INSERT INTO sim_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Naimble anhi aka anhik or tashiwak an akwa mende re, na hanak or akwan.� ");
INSERT INTO sim_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Karem or silinak orhi kup akak or lihi karem mbakwa ora, �Mir mberem ushiwak anin mi suklembasindu? Aka angop a kosoho jikisi anhi nga kawuk nimu suknyanduwa. Uwa osik mbeek a usaha akwan mirin a hakwa ambu nir,� karem mbakwa ora. ");
INSERT INTO sim_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hako jirin amu sawenduwa. Or ukmis ukmisinakop or ufuhu hakwa ri. Ma oto mbeek, �Ma toto anhi kup ori te.� Karem or hishihi or usaha akwan hakwa ambu ri. Hako os or ukmis ukmisinakop, or usaha akwan hakwa ora. ");
INSERT INTO sim_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Uwa osik jirin amu sawenduwa. Ermba ermbak Avui Wasilakan ji silinak os ji siliwan orvai haka. Uhu ermba ermbak ji lasanak os ji lasawan or mukushinak jivai heyeka. Uhu ermba ermbak akayangan ji tirinak akayangan or sutlashinak jivai layika. ");
INSERT INTO sim_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mberem ushiwak? Ma ol mbele mbelenjik siliwan or hakwa lir. Ma ol mbele mbelenjik lasawan or mukushinak heyekwa lir. Ma ol akayangan tiriwa or sutlashinak layikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Os jikisi jihi foomenjik li siliwa wolo, foomen ji halashihi am hovo kava yejen hakundaj? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Os aptok lanjik li siliwa wolo, aptok lan ji halashihi lestava yejen hakundaj? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ambehoma. Angop ji heyewa sir. Jir kavakavan unda ma jir. Hako jikisi jihi li siliwa wolo mbele mbele jivi nom lirin handa jir. Uhunda hom os Avui Wasilaka hevenik fehe Masikome orhin jirin or hakmbaha ji sili nahi hakwa ri,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nindi wolo lasik Jisas ma lar wasimalengamba toloshirik maimbandari ambu oton or mbru ermbeshirik ormu maimbara. Urik ma li heyehe limu lishnyafara. ");
INSERT INTO sim_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hako ma lal olmu mbara, �Ma toto Belsebul or wasimalengamban arangonda orhi kwambuk wasimalengamban ormu mbru ermbenduwa.� ");
INSERT INTO sim_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hovok ma lal Jisasin li oweioweiheyekmbaha limu mbara, �Ma undahi ambu hevenik fehe las mi unak ni heyehe nivai mbaka, mir Avui Wasilaka mbashirik tahanda ma mir,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hako or sunguwavu lihi angop or heyeshihi lirin ormu sawera, �Ji hishika. Os yanga lasik fehe lihi ambek li anaji nahi, yanga oso avak kavak nakwa sira. Mahasanje lal os lihi ambek li anaji nahi, avak kavak nakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Uhunda hom os wasimalengamba Laulakahi lihi ambek li anaji nahi, avak kavak nakwa lira. Hako an Belsebul kwambu orhik wasimalengamban a mbru ormbew, karem jimu mbandu? ");
INSERT INTO sim_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Os anin ji mba, an Belsebulhi kwambuk wasimalengamba ondon a mbru ermbew, anin erem ji mba nahi, jirin a silikwa karem. Jihi ma ol wasimalengamban mbru ermbenda ondo lawehi kwambuk lerawu oson li landu? Lir er nga wasimalengamban li mbru ermbenda osik lir avak mashi mashi os anin ji heyembawa hom jirin heyembakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hako an mbeek Belsebulhi kwambuk lerawun a lawa ambu nir, wahau. An Avui Wasilaka kwambu orhik lerawun amu landuwa. Erem si nawa osik ji heye ji yarika, Avui Wasilaka hulaima nokopman or arangoshinak li likwa oso angop jihik talawa sir. ");
INSERT INTO sim_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ji misi. Os kwambu nga nawa ma lar korme sayi orhin or toloho aka orhin or washili nahi, ma lar mbeek layihi mbele mbele orhin lakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hako os ma lar kwambu orhi orin or tikrihi wasilakak nahanda ma or ta nahi, orin or jihi mbele mbele orhi ondon or laha ihi or humasi nor hanak lakwa lir. Korme sayi ol or tolowa ondo mbeek orin jelyandahik nanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ma ol anhi mak nawa ambu ondo wutari anhi lira. Ma ol an nga nakrem lerawun ni lawa ambu ondo lerawu anhi oson kavak nakwak unduwa. ");
INSERT INTO sim_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ji misi. Wasimalengamba lar ma or or tolondan or halashihi misamtelmbamba orok or ihi or likuri mishin ormu lasara. Or lasafuhu ormu mbara, �Halanak indik aka os a halashi rahanda mishik a i lika.� ");
INSERT INTO sim_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Karem mba nor ihi nor heyeri ma oto aka orhin angop armek or hako ermbeshirik jivik nari sir. ");
INSERT INTO sim_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ushirik oson or heyehe or ihi wasimalengamba 7-pela ol orin tikrihi kava indinga ondon or sawe laha li layihi aka orok limu lira. Ushirik ma oto kava indingak er ormu nara. Os erem or nari oso mas or nandari oson tikriri sir.� ");
INSERT INTO sim_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Karem or mbarik nokove las ma ol orok liri lihi nindik si sihi simu ushambara, �Nijava os mirin waha mukhanda oso Avui Wasilaka or unak rupshikwa sira.� ");
INSERT INTO sim_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Karem si mbarik ormu mbara, �Wahau, ma ol mashi Avui Wasilakahin misindiyawa ma ondo Avui Wasilaka or unak olmu rupkapshikuwa.� ");
INSERT INTO sim_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma musha mendek orok li tirsarik Jisas ormu sawera, �Ter wolok liyawa ma jirin, jir ma kava indinga jira. Jir an ma undahi ambu lal a unak ji heyekmbaha jimu mbanduwa. Hako an mbeek mbele las a unak heyekwa ambu jir, wahau. Mbele las os profet Jonahik narik ji misindari hom avak erem si nanak ji heyekwa sir. ");
INSERT INTO sim_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wa, mbele las os Jonahik nari oso si mukurik yanga Ninivek fehe ma li heyehe limu mbara, �Ma toto Avui Wasilaka mbashirik tari ma ri.� Os anhik nakwa oso erem si mukunak ji heyehe jimu mbakuwa, �Ma toto Avui Wasilaka mbashirik tari ma ria,� karem mbakwa jir. ");
INSERT INTO sim_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ji misi. Avui Wasilaka os hulaima nokopma mbele mbele ol li uhundan or heyembakwa wolo, hiusha nokove yanga Sebak fehe oso si taha kavakava ol ji undan kormbak si sawehe jirin mbakwa osa. Sir mas yanga sihi homek nandarin si halaha king Solomon hishiyarinda orhin si misikmbaha tari osa. Hako misi. Solomonin tikrinda ma ormu torok jir nga sinduwa. Hako jir mbeek mashi orhin misindiyawa ambu jir. ");
INSERT INTO sim_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Uhunda hom yanga Ninivek fehe ma ondo li taha kavakava ol ji undan kormbak sawehe jirin mbakwa ola. Jona mas Avui Wasilakahi mashin or sawerik li misihi sunguwavu lihin tormbleri ola. Hako jir wahau. Misi. Jonan tikrinda ma torok jir nga ormu sinduwa. Hako jir mbeek mashi orhin misindiyawa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","�Ma mbeek lamin li ukruhu wa akomek halowenda ambu lir. Uhu awuk tangrinda ambu lir, wahau. Or ukruhu metenjek or sinjishinak si haranak ma ol aka orok layiwa avak li heyeka. ");
INSERT INTO sim_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Misokome jihi lam hom nanda sir. Os misokome jihi jivik si na nahi, ma harkawu jihi nga harakwa sir. Hako os misokome jihi kavak si na nahi, ma harkawu jihi nga tangnakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Uwa osik ji auheyeka, ukruharanda os jihik nawa oso avak si tangnanan. ");
INSERT INTO sim_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Os ma harkawu jihi amber si ukruhara nahi, kas mbeek tangnakwa ambu sir. Maome jihi avak amber harakwa sir, os lamin li oweshiwak si ukruharanda hom.� ");
INSERT INTO sim_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Jisas mashin am or sawerakorik Farisi lar or taha or nga nakrem fri akmbaha ormu mbara. Urik Jisas or ihi ma otohi akak or layihi tavan or yoko namber ormu lihi ara. Urik Farisi oto or heyehe wavu musha mushak ormu lihishira. ");
INSERT INTO sim_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Urik Wasilaka mu orin sawera, �Wa, Farisi jirin, ji misi. Jir hambikumbiya hikri yeje nom armek li yokonda hom jimu nanduwa. Hako wavu akome jihi osmu kavak nanduwa. Jir mbele mbele mahin ji laha hi jihin jihinjik hauowenda jir. ");
INSERT INTO sim_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jir mbele las yarinda ambu jir. Os Avui Wasilaka hikri yejen or uri oso akome yeje nga erem or uri ambu, karem jimu hishindu? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hako os mbele mbele lal nga ji na nahi, ma ol mbele mbele nga nawa ambu ondon ji haha lirin ji jelyaka. Os erem ji uwa, nombo os hambikumbiya hikri yeje nga akome yeje nga ji yokoshiwak jivik nanda hom jimu nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hako Farisi jirin, ji auheyeka. Jir men ishavaka mbele mbele ol nowe jihik fehe ondon 10-pelak ji humasihi namtas Avui Wasilakan handa jir. Hako jir mbeek orin wavu jihik ji owehe nombo worna os ji tiyakmba nor mbahandan tiyanda ambu jir. Oso angop ji halawa sir. Hako evrembam ji tiyaka. Mbele mbele orin ji haha mashi orhin er nga ji tiyaka. ");
INSERT INTO sim_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi jirin, ji auheyeka. Jir aka os ji lotu unda mishi orok maifuk li lerenda kawu orok ji likwak rupshinda jir. Uhu os ma tirsanda mishik jirin li makshitakshikwak rupshinda jir. ");
INSERT INTO sim_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ji auheyeka. Jir mawa ol ma li hishashihi mbeek li heyenda ambu hom nanda jir. Jir hikri yeje nom ma li heyewak jivik nanda jir. Hako wavu akome jihi kavakava nga nanda jir.� ");
INSERT INTO sim_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Karem or mbarik mashi Moseshin sawendari ma lar mashi oson or misihi ormu mbara, �Tisa, mashi os Farisi ondon mi sawembawa osmu nirin er nga jinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Urik Jisas mu sawera, �Jir mashi Moseshin sawenda ma jirin. Jir er nga ji auheyeka. Jir mashin ji saweshihi mbele mbele lo jihin er nga hulaima nokopma ondohik ji hauoweshiwak mbeek li kishandahik nanda ambu sir. Hako jir mbeek lirin kas jelyanda ambu jir. ");
INSERT INTO sim_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ji auheyeka. Neloko avoko jihi profet ondon mandingormendari lir. Ushindak jir sunja armek mawa lihin tlahapsinda jir. ");
INSERT INTO sim_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Erem ji uwa oso jir avoko neloko jihi nga wavu namtaskop ji hishihi profet ondon ji mandingormenda hom os jimu nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Misi, mashi las Avui Wasilaka mas or mbahandari oso jirin karem mbahandari osa, �Avak a mbashinak profet anhi ondo nga aposel ondo nga ma ondohik ikwa lir. Li inak ma ondo lihi lal kavakavak li uhu, lal li mandingormekwa lir,� ");
INSERT INTO sim_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Jir ter liwa ma jirin. Os mas profetin li mandingormehenda wasa oso avak Avui Wasilaka jirin or ukwa sir. Os mbele mbelen or uri wolokop sishihi rara ter nga man li mandingormeri wasa oso avak jirin or ukwa sir. Ol li mandingormehenda profet amber, Abelik sishi raha Sekaraiak nari oson. Sekaraia oto Avui Wasilakan li lotu uhu orin li sawendari mishi orok li mandingormeri ri. Unda osik jirin amu sawenduwa. Profet ondon li mandingormenda wasan jirin or ukwa jir. ");
INSERT INTO sim_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mashi Moseshin sawenda ma jirin, ji auheyeka. Ki os akayangan li sutlaha li layihi hishiyarindan li landa oso angop ji laha wanyinda sir. Jir jihinjik mbeek orok layikwak hishinda ambu jir. Uhu os ma anandi lal orok li layihi hishiyarinda oson li lakwa nombo angop ji arangori sir.� ");
INSERT INTO sim_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas karem or mbaha or halashi irik mashi Moseshin sawendari ma nga Farisi ondo nga orin limu wapkava hishira. Uhu nombo nombo lal orin li oweioweiheyenak or mbanak li heyekmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mashi las or mbanak kavak si na nahi, orin li kotim ukmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma musha mendek li talandirsaha mbeek li anatikrikuri kas nga nari ambu sir. Urik Jisas ma ol orin tiyandari ma ondon ormu sawera, �Farisi li unda nombon ji auheyeka. Lir mbele mbele li unak ma hi lihin li hausikmbaha hishinda ola. ");
INSERT INTO sim_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hako mbele mbele ol ma li wanyihi li unda ondo kumak avak kormbak talakwa lir. Mashi os tlembak li mbaha wanyinda kumak avak kormbak talanak li misikwa sir. ");
INSERT INTO sim_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mashi os nirik ji mbahanda oso kumak avak tandik li sawenak li misikwa sir. Uhu mashi os akak mashisukuk ji mbawanyinda avak kormbak li sawenak li misikwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","�Uwa osik naimble anhi jirin, jirin amu sawenduwa. Ma ol jirin mandingormekmbaha hishinda ondon ji ajewa hala. Lir maome jihi nom mandingormekwa lir. Hako masikome jihi nga kavak nakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hako jirin kormbak amu sawenduwa, Avui Wasilaka nom ji ajeka. Ortonom man or mandingormehe masikome nga hik ormbekwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ji hishika, avi kanda ol maketik li owenda ondo ya awarikandak li frungawunda lir. Hako Avui Wasilaka mbeek lihi lar or hishakashanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Uhunda hom masikukwa jihi nga angop or heyehe nor kantirakonda lir. Uwa osik ji ajewa hala. Or heyewa, jir avi kanda ondon tikrinda jir.� ");
INSERT INTO sim_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","�Jirin amu sawenduwa, os kormbak ji sawe ji mba, �An Jisasin tiyanda ma nira.� Karem ji mba nahi, Ma Jikisi Avui Wasilakahi oto Avui Wasilaka ensel orhi li heyenak kormbak or sawekwa jir, �Ma tondo anin tiyanda ma lira,� karem mbakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hako os hi orhin kormbak ji sawe nahi ambu, or nga Avui Wasilaka ensel orhi ondo li heyenak karem or sawekwa jir, �An ma tondon a heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Os mashi kavakavan Ma Jikisi Avui Wasilakahin ji mba nahi, Avui Wasilaka kavakava jihin laha ermbekwa ri. Hako os Masikome Avui Wasilakahin ji okolehe mashi kavakavan ji mba nahi, Avui Wasilaka mbeek kavakava jihi oson or laha ermbekwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Os jirin li tolo longo laha ihi li lotu unda mishik mo, gavmanhi lerawun landa ma ondohik mo, ma ol hi nga nanda mahik li tolo laha ihi owehe li silinak avak ji mba, �Mberem ni sawenak li halashinak ni ika?� Karem ji hishinan. Uhu wavu musha mushak ji hishiwa hala. ");
INSERT INTO sim_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Oro wolo mendek Masikome Avui Wasilakahi mashi os ji sawekwa jirin or mukushinak ji sawekwa sir,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Urik ma ol orok tirsaha siri lihi nindik ma lar Jisasin ormu sawera, �Tisa, sanje anhin mi mbanak mbele mbele ol avui shihi owehenda ondon or humasihi anhi uwan or hanak a laka.� ");
INSERT INTO sim_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Karem or mbarik ormu sawera, �Wahau te. Lawe mende anin majistret hom a naha lerawu oson a lakurik kamar?� ");
INSERT INTO sim_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Karem or mbaha ormu sawera, �Ji auheyeka, mbele mbele mahik nanda ondon ji antlawa hala. Mbele mbele ondo mbeek jirin jelyakwa ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Karem or mbaha sauheima las ormu sawera, �Ya ngashi ma lar nowe orhi akwa musha mendek nari sir. ");
INSERT INTO sim_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Urik ma orto ormu lihishira, �Mberem avai uku? Akwa ondo musha mende re. Aka mbeyok avai oweku?� ");
INSERT INTO sim_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Karem or hishihi ormu mbara, �Wa, avak karem a ukwa nir. Aka ondo amber avak a tarvlaha aka anandi lal wasilaka mendek a ukwa lir. Ushihi avak akwa ondo nga mbele mbele anhi nga aka orok a owekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Uhu anhinjik karem a mbakwa nir, wahau te, kavakanda nira. Mbele mbele jiviwavi anhi rondo avak asama mushak nakwa lira. Uwa osik ter avak lerawu las a lakwa ambu nir. Uhu men a lihi hiyawu laka lakan a uhu wain ukun a aha a rupkapshihi na likwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hako Avui Wasilaka mu orin sawe mbara, �Mir ferfarnanda indingo mira. Ter nirik avak hakwa mir. Unak mbele mbele mihi ol mi haumbli haumbliwa ondo avak lawe laku?� � ");
INSERT INTO sim_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Uhu Jisas ormu mbara, �Ma ol mbele mbelen misambi torok haumbli haumbliwa ma ondo ma or ferfarnanda oto hom nanda lir. Lir mbele mbele misambi torok fehenda nom li hishihi Avui Wasilakan hishakashanda lir.� ");
INSERT INTO sim_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Uhu Jisas mu ma ol orin tiyandari man sawera, �Jirin amu sawenduwa. Mbele mbele ol maome jihin jelyakwanjik ji hishombashiowewa hala. Uhu ji mba, �Akwa mbelen ni akundan, kowe mbelen ni falekundan?� Karem ji mbaha ondo mendenjik ji hishombashiowehe ji holowa hala. Mberem ushiwak? ");
INSERT INTO sim_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tos ni hishihi liyanda mbeek men akwa nga kowe nga frihikop ni liyanda ambu nir, wahau. ");
INSERT INTO sim_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Avi ondon ji heyeka. Lir mbeek akwa sijin fakanda ambu lir. Uhu lir mbeek akwan li lahara aka lasikop tirsanda ambu lir, wahau. Hako Avui Wasilaka jihi lirin armek or uhu akwan lirin or hawak anda lir. Hako jir avi ondon tikrinda jir. Or jirin armek unda ri. ");
INSERT INTO sim_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Os mbele mbele misambik fehe tondonjik ji hishombashiowe nahi, ondo am jirin si jelyashinak nambe mendek ji liyakundas? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Os erem si na nahi, mberem ushiwak mbele mbele anandi ondonjik ji hishombashiowendu? Ondo mbeek jirin jelyakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mise amase ondon ji heyeka, armek nawak ji heyenda lir. Mise lihi os kowen falenda hom nanda lir. Hako lir mbeek lerawun laha kowen tlavanda ambu lir. King Solomon kowe jiviwavin falendari ri. Hako mise amase ondo arme mendek li naha kowe jiviwavi ol or falendari ondon tikrinda lir. ");
INSERT INTO sim_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mise amase ondo mbeek nambek nanda ambu lir. Avak ni heyewak sikwa lir, ushok lewas nenjehe mendek nakwa lir. Hako Avui Wasilaka armek or unda lir. Unda osik mberem ji hishindu, jirin armek or ukwa ambu, karem jimu hishindu? Wahau. Avak jirin armek ukwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Uwa osik avak mbele mbele akwanjik ji hishihi ji holowa hala. ");
INSERT INTO sim_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ma misambik fehenda mbele mbele ondonjik hishombashiowenda lir. Hako Avui Wasilaka angop or heyewa sir, mbele mbele ol ji hishiwan. ");
INSERT INTO sim_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Uwa osik ji halashinak malakama jihik or naha mbele mbele ol ji hishiwa avak or haka. ");
INSERT INTO sim_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jir sipsip kanda anhi jirin, ji ajewa hala. Mberem ushiwak? Avui Wasilaka jirin or rupshihi kwambu orhik jirin or arangoshinak orhi siyok sikwa oja. ");
INSERT INTO sim_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ji mbashinak ma lal mbele mbele jihi ondon li frungawuka. Ushinak ya ondon ji laha erndakava ondon ji haka. Erem ji uwa oso yan wolonda kowe os hevenik fehe orok mbele mbele jivi jihin os jimu haumbli haumblinduwa. Ushinak kowe os hevenik fehe oso mbeek frehekwa ambu sir. Mbele mbele orok ji owenda ondo mbeek mendek nakwa ambu lir. Ma kava mbeek li hirnyakwa ambu lir. Kosala mbeek korokwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Os mbele mbele jiviwavi jihin hevenik ji haumblihaumbli nahi, sunguwavu jihi nga orok ikwak hishikwa oja.� ");
INSERT INTO sim_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas mashin or sawehe normu mbara, �Ji hundujehe lamin ji ukruhu ji lika. ");
INSERT INTO sim_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jir avak ma ol malakama lihi or takwak li nikishihi linda hom ji lika. Malakama lihi oto angop hiyawu las os li hulasihi nokoplakwak li uwa mishi orok iri ri. Hako avak indik takwa ri. Os or taha akan or tiriwa wolo kolok akan ji sutlaka. ");
INSERT INTO sim_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Malakama oto mbele wolok or taku? Nirkundik or taku mo harakunak aptoko maifuk or mbanak or taku mo, os or taha or heyenak ol ornjik lerawun landa ma er li lihi li suknyana ambu nahi, avak lirin armek ukwa ri. Uwa osik li rupshika. Omendingak jirin amu sawenduwa, malakama oto avak lirnjik hiyawu laka las or uhu nor humasishinak akwa lir. ");
INSERT INTO sim_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yawur ji hishika, os aka mashama hirnyanda ma li takuri wolon or misirikop armek or washilishirik aka orhin tlelayiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Uwa osik jir nga ermba ermbak ji hundujehe ji lika. Os ji mba, �Ma Jikisi Avui Wasilakahi mbernda rakwa ambu ri.� Karem ji mbana wolokop takwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Karem mbarik Pita mu Jisasin silira, �Wasilaka, sauheima oso nirtonom mi sawewa os mo ma rondo amber?� ");
INSERT INTO sim_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Karem mbarik ormu mbara, �Jir mberem ji hishindu? Malakama lar yanga lasik or ikuna wolo mberem nanda man or mbashinak mbele mbele orhi ondon or washiliku? Ma or hishiyarinda nga naha jip lerawun landa otona. Erem nanda ma lerawun landa ma anandi ondon or washilihi akwan lirin humasikwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Os malakama indiyok or taheyenak lerawu orhin er or la nahi, or rupshika. ");
INSERT INTO sim_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Omendingak jirin amu sawenduwa. Malakama avak orin or ngamashinak mbele mbele orhi ondon washilikwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hako os lerawun landa ma oto or hishihi nor mba, �Malakama anhi mbernda kolok rakwa ambu ri.� Karem or hishihi ma ol or nga nakrem lerawun landa ondon or jihi akwan or aha uku kavan or aha ambarambasinak, ");
INSERT INTO sim_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","malakama orhi avak tumsar takwa ri. Hako or mbeek os or takuri wolon heyeri ambu ri. Uhu mbeek hundujeri ambu ri. Unda osik malakama oto or taha avak ma or mashi orhin mblarna ormbenda oton kavak or naha hik ermbekwa ri. Ushinak ma ol kavakavan unda ma ondo nga nakrem orok likwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jirin amu sawenduwa. Ma or malakama orhi mbari mashin angop or misishihi mblarna ermberwa ma oto avak malakama orhi or taha orin lakak or warmblashikwa ri. ");
INSERT INTO sim_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hako lerawun landa ma or malakama orhi mbari mashin misinda ambu oto, os mbele mbelen or hunduje nahi ambu, malakama orhi os or tawa wolo orin awar or warmblashikwa ri, mbeek lakak or warmblashikwa ambu ri. Os Avui Wasilaka lerawu orhin ji lakmbaha hishiyarinda lakak nandan jirin or hahanda nahi, avak lerawu os ji lahanda yombo yombok jirin heyembakwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas mashi las nga karem ormu sawera, �An misambi torok hin a ermbenak kolok si ukrukurik tari nir. Os hi oso si ukrurikop a rupshiri nir. Hako hi oso mbeek ukruri ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nomorawu laka las avak a kishakwa nir. Hako a kisha namber. Uwa osik sunguwavu anhi osmu kava mendek nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","An mbeek awu tos misambi torok talawan a mishamaimbakmbaha a rari ambu nir, wahau. Jirin amu sawenduwa. Os a rari man a mbanak kraha frijip li sikmbaha a rari nir. Lal kraha anhik, lal wutari anhi kraha orhik sikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ter sishi ihi kumak nga os ma lar jinokove orhi nga tostava yeje hom aka lasikop li li nahi, avak lihi ambek a yarishinak kraha frijip sikwa lira. Ma nalmingrip avak an nga ni sikwa nir. Hako frijip avak nalmingrip ondon li halaha apsham sikwa lira. ");
INSERT INTO sim_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apshambak li sihi avoko ma avak jikisi orhin wutarik or owenak jikisi ma avoko orhin wutarik owekwa ri. Unak nijava avak jikisnokopji sihin erem wutarik si owenak hovok jikisnokopji nijava sihin wutarik owekwa sir. Ruwaihava avak nukmango sihin wutarik si owenak nukmango ruwaihava sihin wutarik owekwa sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisas ma ondon ormu sawera, �Jir ta layinda yok matle si rasawak ji heyehe karem mbanda jir, �Ma avak rakakwa sir.� Uwak os ji mbawa hom ma takanda sir. ");
INSERT INTO sim_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uhu ji heyewak suwa wasilakak tombo yok si rasawak karem mbanda jir, �Ta avak jikwa ri.� Uwak os ji mbawa hom ta jinda ri. ");
INSERT INTO sim_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jir mbele mbele ol lersuwuk fehe nga misambik fehe nga armek yarinda jir. Hako mbele mbele tos ter talawan yarinda ambu jir,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Karem or mbaha mashi las nga ormu mbara, �Mberem ushiwak jihinjik yawur ji hishihi ji yarikwan ji halandu? ");
INSERT INTO sim_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ji misi. Ma or mirin kotim ukwak mbawa ma nga majistrethik shi i namber, orin sauntlehe shihi ambek shi mishamaimbaha shi waphimbijika. Las avak mirin or laha ihi majistrethi tavak or halashinak majistret nga avak polismanhi tavak or handa ngashi. Unak polisman nga avak krawu akak li owekwa mir. ");
INSERT INTO sim_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Omendingak jirin amu sawenduwa. Ya os mi hakmbaha li mbawa hom mi ha nahi ambu, mbeek krawun halaha indiyok hikriyok talakwa ambu mir.� ");
INSERT INTO sim_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jisas mashin or saweshirik ma lal orin li sawe limu mbara, �Pailat awun unda ma orhi ondon or mbashirik Galilik fehe ma lal tempel akak limu mandingormera, os Avui Wasilakan li nambundari wolok.� ");
INSERT INTO sim_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Karem li mbarik ormu mbara, �Wa, mberem ji hishindu? Ma ondo kavakava lihi wasilaka mendek si naha ma anandi Galilik fehe ondon tikriri osik nomorawu oso lihik talari sir, karem jimu hishindu? ");
INSERT INTO sim_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wahau. Jirin amu sawenduwa. Os kavakava ol ji undan ji halaha sunguwavu jihin ji tormble nahi ambu, jir avak er nga kavak nakwa jir. ");
INSERT INTO sim_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wa, mberem ji hishindu? Ma 18-pela kando mas aka hombelaka yanga Siloamik sindari oso tarvlaha si raka mandingormeshirik hari kando kavakava lihi os li undari oso wasilaka mendek si naha kavakava os ma ol Jerusalemik linda ondo li undan tikriri osik limu har, karem ji hishindu? ");
INSERT INTO sim_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wahau. Jirin amu sawenduwa. Os kavakava ol ji undan ji halaha sunguwavu jihin ji tormble nahi ambu, jir avak er nga kavak nakwa jir,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Uhu Jisas sauheima las ormu sawera, �Ma lar mi fik oson nowe orhik ormu owera. Undarik ormu ra mi oson heyera, mi nivi nga si wa nahi, or numbakmbahan. Hako or ta heyeri mi nivi namtas mende mbeek orok wari ambu. ");
INSERT INTO sim_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Uhu noumashama oto ma or nowe oson washilindari ma oton ormu sawera, �Misi. An mi roso akwa ome nga sivai waku, karem mbaha asama nalmingrip am a heyefur te. Hako mbeek namtas mende washiwak a numbawa kom te. Mi toso men sembe er siw. Shi ermbenak si ika. Men sembe er siw.� ");
INSERT INTO sim_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Karem or mbarik ma or nowe oson washilindari mu mbara, �Wa, halanak asama namtar nga si sinak shi heyeshihin, las avak ome nga si wanda ngashi. Halanak mi tontlon a jersa ormbehe shi heyeshihin. ");
INSERT INTO sim_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Las avak asama usaik akwa ome nga si wanda ngashi, u nahi jivina. Hako si wa nahi ambu, mivai shi ermbeka.� � ");
INSERT INTO sim_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat wolo Jisas Judama lotu undari akak mashin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Urik nokove las orok liri sira. Asama 18-pelak wasimalengamba toloshirik kumanhava nga ungruwu ayango yandari sir, mbeek wornak yandari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas sirin or heyehe normu mbara, �Nyir tanak.� Karem or mbarik si tarik ormu mbara, �Apmanuwa, nyir avak a mbanak jivik nakwa nyir.� ");
INSERT INTO sim_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Karem or mbaha tava orhin nokove osohi maomek or hauowerik lewas jip si usaha wornak si sihi hi Avui Wasilakahin simu hausimbausira. ");
INSERT INTO sim_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hako ma or Judama lotu undari aka oson washilindari ma oto Jisas nokove oson Sabat wolok or mbarik jivik si narik or heyehe ormu waplelenara. Uhu ma ol orok liri ondon ormu sawera, �Niri 6-pela lerawun ni landa wolo sira. Os ma toto kavamisinda jihin or mbanak jivik ji nakwak ji hishi nahi, wa, lerawun ni landa wolok ji raka. Hako Sabat wolok nembes.� ");
INSERT INTO sim_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Karem or mbarik Wasilaka mu orin sawera, �Jir mbafirimbanda ma jira. Mashi os ji sawenda nga lerawu os ji landa nga mbeek nakrem nanda ambu sir. Sabat wolok jir amber bulmakau jihi nga donki jihi nga ji tambuhu iwak li ihi uksem anda lira. ");
INSERT INTO sim_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hako nokove toso Abrahamhi nirambara las tosira. Asama 18-pelak Laulaka sirin kavak or nashirik lindari sira. Mberem ushiwak os Sabat wolok a uwak jivik si nawan ji pantlendu?� ");
INSERT INTO sim_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Karem or mbarik ma ol orin waplelenari ma limu humblarara. Hako ma amber mbele mbele jivi ol or urin li heyehe limu rupshira. ");
INSERT INTO sim_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Urik Jisas ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak li linda nombo oso mberem sivai nandu? ");
INSERT INTO sim_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wa, oso mastet siji hom nanda sir. Mastet siji oso awarikanda mende sir. Hako li sishiwak lewas si tungua rasaha wasilakak mi hom nanda sira. Ushiwak avi li raha aviwusin mi tava orok uhu linda lir.� ");
INSERT INTO sim_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Uhu ormu mbara, �Avui Wasilaka os hulaima nokopma orhin or arangoshinak li linda nombo oso mberem sivai nandu? ");
INSERT INTO sim_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wa, oso yis hom nanda sir. Os nokove las bretin si uwa wolo yis kandakar si laha plaua laka nga si farfarsashiwak si kishalaraha wasilaka mendek nanda hom nanda sir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas Jerusalemik or ikurik ormu ira. Or ihi yanga yangak mashin ormu saweyara. ");
INSERT INTO sim_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Urik ma lar ormu silira, �Wasilaka, ma lapndonom Avui Wasilakahi yangak layikwa op?� ");
INSERT INTO sim_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Karem or silirik ormu mbara, �Jir avak lerawu havan ji laha akayanga awarikanda orok ji layika. Jirin amu sawenduwa. Ma mushak orok layikmbaha hishinda lir. Hako wahau. Mbernda li layindahi ambu. ");
INSERT INTO sim_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kumak aka mashama akayangan avak or kosokwa sir. Unak jir avak akayangan ji tirihi karem mbakwa jir, �Wasilaka, akayangan mi sutlawa.� Hako or avak jirin karem mbakwa ri, �An mbeek jir kas a heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Unak jir avak karem mbakwa jir, �Nir mir nga ni lihi akwan ni aha nakrem mir nga wain ukun ni andari nir te. Uhu mir yanga nihik mi taha nirin mashin sawendari oma.� ");
INSERT INTO sim_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hako or avak jirin karem mbakwa ri, �An jirin a heyenda ambu nir. Jir mbeek fehe jir? Jir kavakavan unda ma jir. Jir amber hom indik ji hala ika.� ");
INSERT INTO sim_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Karem or mbanak yanga jivi hikriyok ji i sihi ji heyenak Abraham nga Aisak nga Jekop nga profet ondo amber Avui Wasilakahi yanga orok li linak ji heyehe ji tlangamayihi fu jihin masham koho akwa jir. ");
INSERT INTO sim_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Unak ma ol kuyanga ta rasandak fehe, ta layindak fehe, nuku yok fehe, tombo yok fehe, amber hom Avui Wasilakahi yangak li layihi akwan akwa ola. Hako jir wahau. ");
INSERT INTO sim_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Uwa osik ji misi. Ma ol ter kumasik siwa ondo avak maifuk sikwa lir. Ma ol ter maifuk siwa ondo avak kumasik sikwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Karem or sawerik Farisi lal li raha Jisasin limu sawera, �Herot Antipas mirin mandingormekwak ormu mbanduwa. Uwa osik yanga roson mi halaha yanga lasik ika.� ");
INSERT INTO sim_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Karem li mbarik ormu sawera, �Ji ihi Herot oton karem ji sawe. �Mir misi, avak nga ushok nga lerawun a laha wasimalengamba ol man tolondan a mbru ormbehe ma ol kavamisindan a unak jivik nakwa lir. Uhu humnyanak lerawu anhi oson a larakokwa nir. ");
INSERT INTO sim_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ome sira. Ushok nga humnyanak nga an lerawu oson er a lakwa nir. Mberem ushiwak? Profet mbeek yanga anandi lasik li jimandingormekwa ambu ri, wahau. Jerusalemkop orin li mandingormeshinak hakwa ri.� Mashi kas karem a mbawan orin ji sawe. ");
INSERT INTO sim_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jir Jerusalemik fehe ma jirin, jir profet ondo nga ma ol Avui Wasilaka mbashirik tari ma ondo er nga sunjakom loho mandingormenda jir. Hindi mushak jirin armek a ukmbaha na hishinda nir, os aptok nijava jikisi sihin shervle sihik si arangonda hom. Hako jir mbeek ji halashiwak jirin erem a unda ambu nir. ");
INSERT INTO sim_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ji misi. Yanga jihi avak kavak nakwa sir. Jirin amu sawenduwa. Jir avak anin indik heyekwa ambu jir. Er ji lihi ji nikishifuhu ji mba, �Halanak Avui Wasilaka ma or hi orhik tawan armek or uka.� Karem ji mbana wolokop anin indik heyekwa jir.� ");
INSERT INTO sim_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat wolok Jisas Farisi lida lihi larhi akak or akurik ormu layira. Urik ma ol orok liri ondo orin limu lishi flaflatara. ");
INSERT INTO sim_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mberem ushirik? Ma lar kumba tava tirindari orok liri ora. ");
INSERT INTO sim_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Urik ma oton or heyehe mashi Moseshin sawendari ma nga Farisi ondo nga ormu silira, �Mashi Moseshi mberem si sawendu? Ma ol kavamisindan Sabat wolok ni mbanak jivik li nakwa jivi os mo kava os?� ");
INSERT INTO sim_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Urik mayam er limu lira, mbeek mashi las mbari ambu lir. Urik ma oton or toloho or mbarik jivik or narik or mbashirik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Uhu ormu sawera, �Os jikishulayi jihi lar mo bulmakau jihi lar Sabat wolok ukwa wolnanda mishi lasik li layi nahi, kolomalok ji ihi tolonak tasakunda ol mo wahau? He, ji tolonak tasakwa ol te.� ");
INSERT INTO sim_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Karem or mbarik lir mbeek mashi las mbakurik nari ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas or sihi nor heyeri ma ol hiyawu laka orok tari ma ondo amber malakama linda mishik li likmbaha olmu ura. ");
INSERT INTO sim_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Urik sauheima las ormu sawera, �Os ma lar hiyawu laka las or uhu or ushanak mi i nahi, avak malakama linda mishik mi i liwa hala. Las avak orok mi ihi malakama ondo li likwa mishin mi arangonda ngashi. ");
INSERT INTO sim_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Unak hiyawu mashama oto avak or taha mirin karem mbakwa ora, �Mir os mi liwa mishi toson halashinak malakama katai tawa torok or lika.� Las avak karem or mbashinak mi humblaraha kuma yok mi i linda ngashi. ");
INSERT INTO sim_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hako mir kuma yoko mendek i lika. Os erem mi uwa oso hiyawu mashama oto avak or mbashinak mi ihi malakama linda mishik mi likwa sira. Erem or unak hi mihi avak ma ol er nga ji lihi awa misokome lihik lakak nakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Uwa osik ji misi. Ma or hi orhin orhinjik metenjek hauowewa, avak Avui Wasilaka hi orhin or hakaowekwa ora. Hako ma or orhinjik hafaka liwa, avak Avui Wasilaka hi orhin metenje mendek or hauowekwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Urik Jisas Farisi hiyawu mashama oton ormu sawera, �Os hiyawu laka las mi ukuna wolo avak mahasanje mihi nga mihi kuvu ondo nga ya ngashi ma ondo nom ushanak li ra awa hala. Mberem ushiwak? Lir avak akwa wasa mihin hakwa lir. Ushinak kumak mbele las lakwa ambu mir. ");
INSERT INTO sim_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hako os hiyawu wasilaka las mi uwa, avak erndakava nga ol maome kumba tava lihi nga misokome nga kavak nahanda ondon ushanak li ra aka. ");
INSERT INTO sim_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ol erem nahanda ma ondo mbeek akwa wasa mihin ukwa ambu lir. Unak mir er rupshi mendeka. Mberem ushiwak? Kumak ma Avui Wasilakahi ol hahanda indik li usahana wolo akwa wasa mihi oso or hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Urik orok liri ma lar mashi oson or misihi Jisasin ormu sawera, �Hulaima nokopma ol hiyawu wasilaka yanga jivi Avui Wasilakahi orok lihi akwa ma ondo li rupshi mendeka.� ");
INSERT INTO sim_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Urik Jisas ormu orin sawera, �Misi, ma lar hiyawu wasilaka las or ukurik or uhu ma musha mendek ormu ushara. ");
INSERT INTO sim_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Urik am or ukuri wolok si narik ornjik lerawun landari ma oton or mbashirik or ihi ma ol masmas or mainhandarin ormu sawera, �Ji taka. Mbele mbele amber angop or hundujerakowa sir.� ");
INSERT INTO sim_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hako ma ondo mbeek orok ikurik hishiri ambu lir. Lar ormu mbara, �An angop nowe las yak a frungawuri nir. Avak a ihi nowe oson a heyekwa nir. Uwa osik hiyawu orok a rakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hovok lar ormu mbara, �An angop bulmakau 10-pelak lerawun a lakurik yak a frungawuri nir. Avak a ihi bulmakau ondon a heyekwa nir. Uwa osik hiyawu orok a rakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hovok lar ormu mbara, �An akrin na nokoplawa osik hiyawu orok a rakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Urik lerawun landari ma oto indiyok or taha mashi os li mbarin hiyawu mashama oton ormu sawera. Urik mashi oson or misihi or waplelenaha orin ormu sawera, �Mir kolomalok ihi kolaka torok nombo laka nga nombo jintla kanda nga mi ilai talaihi erndakava ondo nga ma ol maome kavak nanda nga misokome tumunda nga kumba nashinda nga laharanak aka anhik li raka.� ");
INSERT INTO sim_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Karem or mbashirik or ihi indik ormu taha ormu mbara, �Malakama, os mi mbawa hom a lawa sir. Hako aka laka mihi oso hoje namber.� ");
INSERT INTO sim_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Urik hiyawu mashama oto ormu sawera, �Mir avak kolaka toson mi halaha yanga yangak mi ihi ma amber ol orok mi heyewa ondon ukmisi laharanak avak aka anhi si hojeka. ");
INSERT INTO sim_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hako omek amu sawenduwa. Ma ol mas a ushahanda ondo lir avak mbeek akwa kandakar akwa ambu lira, wahau.� � ");
INSERT INTO sim_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma musha mendek Jisas nga limu ira. Urik or tormblehe ormu lirin sawera, ");
INSERT INTO sim_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","�Os ma lar anin or tiyakunak or hishi nahi, wa halanak anin wapnuku orhik or oweka. Os avoko nijava, jinokopji, jikaha mahasanje orhin wapnuku orhik or oweshihi anin wapmantlek or owe nahi, or mbeek anhi mak nakwa ambu ri. Uhu os anin or rupshiwa oso orhinjik or rupshinda oson si tikri nahi ambu, or mbeek anhi mak nakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hovok os ma lar miando orhin or kisha nahi ambu, or mbeek anhi mak nakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Uwa osik ji misi. Os ma lar akan or ukwak or hishi nahi, wa yawur or lihi ya nga mbele mbele ol akan or ukwak or hishiwa ondon or li hishihi nor mba, �Ya toso am aka toson a urakokundas mo wahau?� ");
INSERT INTO sim_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Os erem or hishi nahi ambu, aka oso mbeek or urakokwa ambu sir. Unak ma avak li heyehe orin okole karem orin mbakwa lir, ");
INSERT INTO sim_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","�Ma toto aka toso or urakowa kom te,� karem mbakwa ola. ");
INSERT INTO sim_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Os king lar king anandi nga awun or ukwak or hishi nahi, wa yawur or lihi armek hishikwa ora. Awun unda ma orhi 10,000-ik li nanak king anandi oto awun unda ma orhi 20,000-ik li na nahi, or mba, �Am a jihi na tukrunak tulu ikundal mo wahau?� Karem hishikwa ora. ");
INSERT INTO sim_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hako os or hishiwa awu oson or jihi tukrundahi ambu, karem or hishi nahi, wa os homek si nana wolo ma lal or mbashinak li ihi li sauntleka. Ushinak awu oso li ukwan li halaka. ");
INSERT INTO sim_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Uhunda hom jir erema. Masmas jihinjik yawur ji heyeshihin. Os mbele mbele jihin ji hala nahi ambu, jir mbeek anin tiyanda mak nakwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","�Waswo jivi sira. Hako os si jip ana ambu nahi, mberem ni unak indiyok jivik sivai naku? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Erem nanda waswo oso mbeek mbele jivi las undahi ambu sir. Men li ormbewak inda sira. Misi, ma ol mambla ngashi halanak mashi anhin li misika.� ");
INSERT INTO sim_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma ol takis yan landari nga ol kavakavan undari ondo nga Jisas saweri mashin li misikmbaha limu tara. ");
INSERT INTO sim_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Urik Farisi nga ma ol mashi Moseshin sawendari nga lihi ambek limu mbara, �Ma toto mberem ushiwak ma tol kavakavan unda tondo nga nakrem or lihi aha yandua?� ");
INSERT INTO sim_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Karem li mbarik or misihi sauheimak or sawe normu mbara, ");
INSERT INTO sim_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","�Os jir lar sipsip 100 nga nor nahandanak namtar wanyishiwa, mberem orvai uku? Sipsip 99 ondon minja ngashi mishik or halashihi namtar oton lasa ikwa ora. ");
INSERT INTO sim_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Or ihi sipsip oton or heyehe or rupkapshihi indik yangak kisha laharakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Uhu orhi ma orhi man or ushanak li talandirsarakonak lirin ormu sawekuwa, �Sipsip anhi or wanyihinda angop a lasa ihi a heyehe indiyok a laharawa ri. Uwa osik jir nga an nga ka ni rupshika,� karem mbakwa ora. ");
INSERT INTO sim_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jirin amu sawenduwa. Ma 99 ondo angop ma worna mak li nahanda osik heven yok lirin rupshinda lir. Hako os ma kava lar mbele mbele kavakava os or undan or halaha sunguwavu orhin or tormble nahi, avak heven yok warje mende nga rupshikwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","�Os nokove las ya silva 10-pelak si nahandanak namtar wanyishiwa, mberem sivai uku? Sir avak tujakan si ukruhu aka suvun si hakoho ya sihin lasakwa osa. ");
INSERT INTO sim_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Si laslasa si heyehe sihi ma sihi man si ushanak li talandirsarakonak lirin simu sawekuwa, �Ya anhi or wanyihinda angop indiyok a heyewa ri. Uwa osik jir nga an nga ka ni rupshika,� karem sawekwa osa. ");
INSERT INTO sim_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jirin amu sawenduwa. Os ma kava lar mbele mbele kavakava or undan or halaha sunguwavu orhin or tormble nahi, ensel Avui Wasilakahi avak warje mende nga rupshikwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Uhu Jisas sauheima las nga ormu sawera, �Ma lar jikishulayi orhi frijip nahandari vri. ");
INSERT INTO sim_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Undarik maha kanda mu avoko orhin sawera, �Avui, mbele mbele mihi ondon avak mi humasihi anhi uwan avak ter anin haka.� Urik avoko orhi mbele mbele orhi ondo amber or humasihi fririn ormu hara. ");
INSERT INTO sim_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kandakar nga nambek naha maha kanda oto mbele mbele orhi ondon amber or tirsashirik ma mu frungawura. Ushirik yan or laha yanga home lasik ormu ira. Orok or i lihi yan or haihanda ermberakori lir. ");
INSERT INTO sim_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ya orhi mendek si narik erenghandari wolo yanga orok simu nara. Ushirik akwa nga nari ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ushirik or ihi yanga orok fehendari ma larnjik ormu lerawun lakurik ira. Urik ma oto mbashirik or layihi fle orhin ormu washilira. ");
INSERT INTO sim_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma lal mbeek akwan orin hari ambu lir. Uri osik or erenghaha fle ari akwa sumbun or akurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Uhu nor lihi indik avui orhin ormu hishira, �Avui anhinjik lerawun landa ma ondo olmu akwa nga mushak nanduwa, hako an torok a lihi namu erenghanduwa. ");
INSERT INTO sim_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wa, avak a usaha indik avui anhik a ikwa nir. Uhu orin karem a sawekwa nir te, �Avui, an angop kavakavan Avui Wasilaka nga mir nga na uhunda nir. ");
INSERT INTO sim_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Uwa osik an mbeek ma jivik a nawa onik anin jikisi mihik mbakwa ambu mir. Hako halashinak ma tol mirnjik lerawun landa tondo hom a naka,� karem a sawekwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Karem or hishihi or usaha indik avoko orhik ikurik ormu ira. Or irik avoko orhi mu orin homek heyera. Or heyehe sunguwavu orhi nga ornjik or holo mendehe shirinyambar or ihi jikisi orhi oton or wakrihi normu makaptakhavan tlera. ");
INSERT INTO sim_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Urik jikisi orhi mu mbara, �Avui, an angop kavakavan Avui Wasilaka nga mir nga na uhunda nir. Uwa osik anin jikisi mihik mbawa hala.� ");
INSERT INTO sim_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Karem or mbarik avoko ma oto ornjik lerawun landari ondon or usharik li tarik ormu sawera, �Jikisi anhi toto angop or haha wanyindari hom ni hishandari ri. Hako ter am indik or tashiwak a heyehe amu rupshi mendenduwa. Uwa osik kolomalok kowe jiviwavi las ji laharaha orin ji falehe tavafusha nga ji falehe kumba ari nga ji faleshika. Uhu ji ihi bulmakau jikisi laka lar ji jihi ni u aha avak ni rupshika.� Karem mbaha hiyawu wasilakan li uhu aha limu rupshira. ");
INSERT INTO sim_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Urik sanjelaka nowek or nahandarik ormu yangak tara. Or ta aka sumbuk or sihi nor misiri ma li rupkapshihi limu mblara. ");
INSERT INTO sim_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Urik avoko orhinjik lerawun landari ma lar or mbarik or tarik ormu silira, �Kando mbele li undu?� ");
INSERT INTO sim_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Karem mbarik ormu sawera, �Maha mihi angop indiyok or tashiwak avoko mihi or rupkapshihi or mbawak bulmakau jikisi laka lar nimu jiwa.� ");
INSERT INTO sim_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Karem sawerik or misihi or waplelenaha mbeek akak layiri ambu ri. Urik avoko orhi or talaha mashi jivik or mbaha orin ormu hokovira, unak waplelena orhi oso avak mendek si nakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hako sanjelaka oto ormu sawera, �Avui, asama mushak lerawu hava kavan a laha mbeek mashi mihin a mblarnanda ambu nir. Ermba ermbak mashi mihin a misindiyanda nir. Hako nindi wolo las mbeek meme jikisi lar mi mbashirik a jihi anhi ma nga ni aha ni rupkapshiri ambu nir, wahau mende indinga. ");
INSERT INTO sim_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hako jikisi mihi toto ya mbele mbele ol mi harik or laha iri ondo angop hulatolhakayanda nokove ondok or ormberakori lir. Ushihi indik or tawak orin mi rupkapshihi ornjik bulmakau jikisi lakan mi jihi hiyawun mi uhu andu?� ");
INSERT INTO sim_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Karem mbarik ormu mbara, �Jikisi, mir ermba ermbak an nga shi linda mir. Unda osik mbele mbele anhi tondo amber mihi lir. ");
INSERT INTO sim_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hako maha mihi toto angop or haha wanyindari hom ni hishandari ri. Hako ter am indik or tashiwak ni heyehe ni rupkapshihi nimu mblanduwa.� � ");
INSERT INTO sim_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas orin tiyandari ma ondon ormu sawera, �Ya ngashi ma lar lindari ri. Ushirik ma lar mbele mbele orhin washilindari ri. Urik ma lal li taha ya ngashi ma oton limu sawera, �Ya mihin washilinda ma oto mbeek ya mihin armek owenda ambu ri. Ya mihi ondon ormu laha sambuyanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Karem li mbarik or misihi ya orhin washilindari ma oton or usharik or tarik ormu sawera, �Mir li sawewak a misiwa mbele mbele anhin mbeek armek washilinda ambu mir. Unda osik mbele mbele anhin tava mihik a halakwa ambu lir. Mir kolomalok ihi mbele mbele anhi ol tava mihik nawa ondon amber jekambak kayerakoho laharanak a heyeka.� ");
INSERT INTO sim_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Karem or mbarik wavu orhik ormu lihishira, �Malakama anhi avak or mbashinak lerawu orhin a halakwa nira. Wa, mberem avai uku? An mbeek kwambu nga na naha lerawu havan landahik a nawa ambu nir. Uhu nombok a lihi yanjik a silikwan a humblaraw te. ");
INSERT INTO sim_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hako nombo las a hishiwa karem. Os karem a unda nahi, ma lal avak anin armek ukwa lir, os malakama anhi or mbashinak lerawu orhin a halawa wolon.� ");
INSERT INTO sim_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Karem or mbaha malakama orhi otohik wasa nga nandari ma ondon or usharik limu tara. Uhu maifuk tari man ormu silira, �Mir wasan mi hakwa mbelmbel si nandu?� ");
INSERT INTO sim_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Karem or mbarik, �100 dram wel.� Karem mbarik ormu mbara, �Wa, os 100-ik li kayenda oson mbroko ormbeshihi jekamba anandik 50-kop kayeka.� ");
INSERT INTO sim_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ushihi lar tarik ormu silira, �Mir wasan mi hakwa mbelmbel si nandu?� Karem mbarik ormu mbara, �100 bek wit.� Karem or mbarik ormu mbara, �Wa, 100-ik li kayenda oson mbroko ormbeshihi jekamba anandik 80-kop kayeka.� Karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ushirik malakama oto or taha nombo nombo os or hishiyarihi or uri oson or heyehe hi orhin metenjek ormu hauewera. Mberem ushiwak? Ma oto hishiyarinda nga nari ora. Ome sira. Ma misambik fehe mbele mbele li ukwak li hishiyarinda lir. Uhu Avui Wasilakahi ma ondon tikrinda lir. ");
INSERT INTO sim_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jirin amu sawenduwa. Ya jihin misambik fehenda ondon ji hanak ma ondo avak jihi naimblek li naka. Uhundanak kumak ya mendek si nawa wolo, avak jirin li laha aka akak li laha inak jipjip ji lika. ");
INSERT INTO sim_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ji misi. Os ma lar lerawu awarikanda ol orhi tavak li hahandan armek or la nahi, avak lerawu laka nga armek lakwa ri. Hako os lerawu awarikanda ol orhi tavak li hahandan armek or la nahi ambu, mbeek lerawu laka nga armek lakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hako os mbele mbele ol misambik fehendan armek or washili nahi ambu, lawe mende avak mbele mbele jivi menden ma otohi tavak or hanak or washiliku? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jir erem. Os mbele mbele mahin armek ji washili nahi ambu, lawe mende avak jirin mbele mbelen hanak ji washiliku? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ma lar mbeek ma frijipnjik lerawun landahi ambu ri. Os erem or u nahi, lar or rupshihi lar or turakwa ri. Uhu lar mbawa mashin or misihi lar mbawan halakwa ri. Unda hom jir erem. Os ya mbele mbelenjik ji hishombashiowe nahi, jir mbeek Avui Wasilakahi siyok sikwak hishikwa ambu jir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi ondo yanjik undari lira. Undari osik Jisas mbari mashin li misihi orin li wapkava hishihi limu mbara, �Oto men mbafirimbanda ri.� ");
INSERT INTO sim_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Urik Jisas mu lirin sawera, �Jir jivijivin unda ma, karem li hishikmbaha jimu unduwa. Hako Avui Wasilaka mbele mbele os sunguwavu jihik nawan angop or heyewa sir. Mbele mbele os ma misambik fehe hishihi li mba, �Toso jivi indinga sir,� karem li mbawa oso misokome Avui Wasilakahik or heyewa, kava indingak nanda sir. ");
INSERT INTO sim_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mashi Moseshi nga mashi profethi nga li sawe ra ra Jon talari ri. Ushihi Jonik sishi rawa wolo mashi jivi Avui Wasilakahi toso yanga yangak amber osmu induwa. Uwak ma amber Avui Wasilaka hulaima nokopman or arangoshinak li likwa mishik li layikwak olmu lerawu havan landuwa. ");
INSERT INTO sim_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lersuwu nga misambi nga avak mendek nakwa vri. Hako mashi Avui Wasilakahi mbeek mendek nakwa ambu sir. Ermba ermbak er nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisas mashi las nga karem ormu mbara, �Ma or nokove orhin halashihi nokove anandin lawa ma oto misokome Avui Wasilakahik or heyewa nokophirmbirinda ma hom nanda ria. Hako ma lar nokove las hula sihi sirin or halashindan lawa ma oto er nga nokophirmbirinda ma hom nanda ri.� ");
INSERT INTO sim_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas mashi las nga ormu sawera, �Mas ya mbele mbele nga nandari ma lar lindari ri. Ermba ermbak kowe jivi nom or falehe akwa jivi nom or aha lindari ri. ");
INSERT INTO sim_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hako akayanga orhik ojenaji nga afuranda erndakava lar lindari ri. Hi orhi Lasarus oria. ");
INSERT INTO sim_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Uhu ya ngashi ma ari akwatlamu li rakarik or akurik undari ora. Urik asa li raha ojeuku orhin olmu mblek andara. ");
INSERT INTO sim_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Undarik Lasarus kava oto mu hara. Urik ensel Avui Wasilakahi orin li laha ihi oweshirik ormu Abraham nga nakrem lira. Urik ya ngashi ma oto er nga or harik li wakor oweri ri. ");
INSERT INTO sim_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ushirik ma ol hahanda li lindari mishi orok or lihi nomorawu wasilakak er kishari ri. Uhu or simawuri Abraham ormu home mendek Lasarus nga lira. ");
INSERT INTO sim_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Uhu ormu ushara, �Misumu anhi Abraham, mir avak anjik mi holoho Lasarusin mi mbashinak avak uku kandakar tavambisha orhik or falehe nor laharaha tarvle anhik or mbunak kandakar si sernanak a misiwa. An hi torok a lihi maome anhi kava mendek si nawak amu misinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Karem mbarik Abraham mu mbara, �Nirambara anhi, mi misi. Mir os mas mi nahandan hishika. Os mi ha namber, mir mbele mbele jivi nga musha mendek nandari mir. Hako Lasarus wahau. Uwa osik ter or jip or likwa wolok osmu nanduwa. Hako mir nomorawun mi kishakwa wolok osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Misi, Avui Wasilaka ukfia las angop jir nga nir nga nihi nindik or shihinda sir. Unda osik ma tol torok liwa os oroyok li ikwak li u nahi, mbeek li haploroho ji liwa mishik li indahi ambu lir. Unak ma ol oroyok liwa nga mbeek li haploroho tos ni liwa mishi yok tandahi ambu lir.� ");
INSERT INTO sim_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Karem mbarik ma oto mu mbara, �Os erem si na nahi, wa misumu anhi Abraham, Lasarusin mi mbashinak avui anhi aka orhik or ika. ");
INSERT INTO sim_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","An mahasanje anhi tostavak ni nanda nir. Avak mi mbashinak or ihi mainkwambuk or sawe nor tolowornashinak mbele mbele kavakava ol li undan li halaha sunguwavu lihin li tormbleka. Las avak lir nga yanga kava torok li randa ngashi.� ");
INSERT INTO sim_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Karem mbarik Abraham mu mbara, �Lir mashi Moseshi nga mashi ol profet ondo li sawendari nga angop misinda lir. Unda osik avak mamblan li owehe mashi oson li misihi li tiyaka.� ");
INSERT INTO sim_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Karem mbarik ormu mbara, �Misumu anhi Abraham, oso erem nawa sira. Hako wahau te. Os hahanda ma lar or usaha nor sawe nahi, avak sunguwavu lihin tormblekwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Karem mbarik ormu mbara, �Os mashi Moseshi nga profethi nga li misi nahi ambu, hahanda ma lar or usaha nor sawewa, mbeek er nga li misindiyandahi ambu lir, wahau,� karem ormu mbara.� ");
INSERT INTO sim_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ol orin tiyandari man ormu sawera, �Misambi toso kavakavan unda mishi sir. Hako ma or man mbaskashiwak kavakavan li unda ma oto kava indinga ri. ");
INSERT INTO sim_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Os ma lar jikisakri kanda rondo lal or unak kavakavak li layi nahi, Avui Wasilaka or unak avak ma or erem mbaskashiwa ma oto kavak nakwa ri. Uwa osik os jikisakri kanda rondon erem or u namber, sunja laka jekapnashi orhik li ishitivihi fak li ormbeshinak or uk aha nor ha nahi, jivina. ");
INSERT INTO sim_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ji auheyeka. Os jihi lar kavakavak jirin or u nahi, ji saweshinak os erem or undan or halaha sunguwavu orhin or tormbleka. Ushinak or nga jivai anatavatoloho anafa anafa ji lika. ");
INSERT INTO sim_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Os ma lar mbele kava las hindi 7-pelak jirin or washi u nahi, os indiyok or ta nor mba, �Os karem karem mirin a uwa oso kavak nawa sir.� Karem or mba nahi, or nga shi anatavatoloho shi anafa anafa shi lika.� ");
INSERT INTO sim_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Urik ma ol orin tiyandari ma ondo Wasilakan limu silira, �Mir os mirin ni hishiowenda nombo oson mi unak kwambuk si naka.� ");
INSERT INTO sim_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Karem li mbarik Wasilaka mu lirin sawera, �Os anin ji hishiowenda nombo jihi awarikandak mastet siji hom si na nahi, wa ambehoma. Mi roson ji mba, �Nyir nyihinjik kwarasaha i solwarak sika.� Karem ji mbawa, wa os ji mbawa hom nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisas ormu mbara, �Os jirnjik lerawun landa man ji mba, �Mir i tawun la.� Mo �Mir i sipsipin washili.� Karem ji mbashinak or ihi lerawu oson or larakoho indik akak or tana wolo, am ji mbanak nombok akundar? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ji mbashinak jirnjik akwan or hundujeshinak jir anakop akwa ri. ");
INSERT INTO sim_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Os erem or uwa oso mbeek mbele laka ambu sir. Or men lerawun os ji mbawa hom lawa ri. ");
INSERT INTO sim_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jir erema. Os mbele mbele Avui Wasilaka ji ukmbaha jirin or mbahandan ji uhunda nahi, karem ji mbaka, �Nir mirnjik lerawun landa ma nir. Nir jivi ambu nir. Mbele mbele os ni uwa oso men lerawun os mi mbawa hom ni landa nir.� � ");
INSERT INTO sim_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalemik or ikurik ormu ira. Or ihi provins Samaria nga Galili nga frihi wolo ambek ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uhu kuyanga lasik or layirik ma lal 10-pela okmbale lepra tolondari mu nombok orin heyera. Li heyehe homek li sihi ");
INSERT INTO sim_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wasilakak limu ushara, �Jisas, malakama mirin. Nirnjik mi holowa.� ");
INSERT INTO sim_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Karem mbarik Jisas lirin or heyehe normu mbara, �Ji ihi maome jihin prisin ji mukuka.� Karem or mbashirik li irik kolok maome lihi jivik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Urik lihi lar maome orhi jivik si nashirik or heyehe nombok or yantlehe indiyok ormu tara. Or taha wasilaka mendek or ushasawehe hi Avui Wasilakahin ormu hauowera. Uhu or taha Jisashi kumbamuk or taka avermbuwaha orin armesarmek ormu mbara. Ma oto Samariak fehenda ma ria. ");
INSERT INTO sim_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Urik Jisas ma oton or heyehe ormu mbara, �An a hishiwa ma 10-pela angop jivik nawa lir. Hako lal mbeei? Mberem ushiwak indiyok li taha hi Avui Wasilakahin li hauowekwan li halandu? ");
INSERT INTO sim_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ji heyeka. Ma roto samba samba Samariak fehe toria. Ortonom indiyok tawa ria.� ");
INSERT INTO sim_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Uhu ma oton ormu sawera, �Mir usaha ika. Wavu mihik anin mi hishiowewa osik jivik mimu nanduwa,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi ondo lal Jisasin limu silira, �Avui Wasilaka ma orhin or arangoshinak li likwa oso mbele wolok si talaku?� Karem li silirik ormu mbara, �Avui Wasilaka os or arangoshinak ji likwa oso mbeek ji heilandahi nombok takwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma lal mbeek oson li heyehe mba, �Heye tos torok nandu.� Mo �Heye kasai karok nandu,� karem mbakwa ambu lir. Mberem ushiwak? Jir Avui Wasilakahi mashin misindiyanda ma os jimu orhi siyok sihi or mbawa hom os jimu unduwa. Uwa osik os or arangoshinak ji likwa oso angop jihik nawa sir.� ");
INSERT INTO sim_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Karem or mbaha orin tiyandari man ormu sawera, �Kumak Ma Jikisi Avui Wasilakahi oton ji heyekunak hishikwa oj te. Hako mbeek ji heyekwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Erem ji hishina wolo, avak jirin li sawe mbakwa lir, �Heye, katai karok lindu.� Mo �Heye tor torok lindu.� Karem li mbawa avak mashi lihin ji misihi tiya iwa hala, wahau. Os ji liwa mishik er ji lika. ");
INSERT INTO sim_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ma Jikisi Avui Wasilakahi indiyok or takwa wolo, kasai lervlanda hom nakwa sir. Os si lervlawa wolo, ma amber li heyenda sir. Unda hom or takwa wolo, erem ma amber li heyekwa ri. ");
INSERT INTO sim_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hako masmas nomorawu wasilakan or kishanak ma ol ter liwa ondo orin kumaifakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ma Jikisi Avui Wasilakahi indiyok or takwa wolo, mbele mbele os Noahi wolok li uhunda hom erem li ukwa sir. ");
INSERT INTO sim_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Oro wolok ma akwan li aha nokoven li laha jikisi lihin li mbashirik hulasi nokoplari lira. Karem li uhu yarik Noa sipik or layikuri wolok nari sir. Urik ma si rakarik fa si rasaha si jisiriri lir. ");
INSERT INTO sim_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Undari hom Lothi wolo erem nari sir. Ma akwan li aha mbele mbele li frungawuhu lal li oweshirik li lar, mbele mbele nowek li fakaha li sir, akan li ur, karem uyandari lir. ");
INSERT INTO sim_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hako Lot yanga Sodomin or halarik hi wasilaka lersuwu yok si rakaha Sodomik fehe man simu urakora. ");
INSERT INTO sim_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Unda hom os Ma Jikisi Avui Wasilakahi indiyok or rakwa wolo erem nakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Os erem si nawa wolo, ma or hikriyok liwa, aka orhik or layihi mbele mbele orhin or lawan or hala. Ma or nowek liwa erem. Indik yangak or ihi mbele mbele orhin or lawan or hala. ");
INSERT INTO sim_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mbele mbele os mas Lothi nokovek talandan ji hishika. ");
INSERT INTO sim_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Os mbele mbele jihi ondon ji toltambana nahi, avak kavak nakwa jir. Hako os anin ji hishindiyaha mbele mbele ondon ji hala nahi, kumak ermba ermbak linda oson jivai laka. ");
INSERT INTO sim_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jirin amu sawenduwa. Ma Jikisi Avui Wasilakahi avak tumsar takwa ri. Unak ma frijip kawu namtaskop fri wanak Avui Wasilaka lar or laha lar or halakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Nokove frijip plauan fri unak Avui Wasilaka las or laha las or halakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Karem or mbarik ol orin tiyandari ma mashi oson li misihi Jisasin limu silira, �Wasilaka, mbele mbele ondo mbeek li talaku?� Karem li silirik ormu mbara, �Os li takwa wolo os li talanak kormbak ma amber heyekwa lir, os mbele las haha kuvayiwa mishik apkumbono li tirsawak ni heyenda hom.� ");
INSERT INTO sim_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ma ol orin tiyandari man mashi las sauheimak or sawe normu mukura, unak Avui Wasilakan ermba ermbak li sawekwan li kremangrewan li halakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","�Yanga lasik majistret lar lindari ri. Majistret oto mbeek Avui Wasilakan or ajehe man jelyakurik hishindari ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hako mumbla las kuyanga orok lindari sir. Sir ermba ermbak majistret otohik si raha karem sawendari sir, �Ma lar anin kavakavak or ukwak undua. Mir anin jelyaha orin sauntleshinak or halaka,� karem sawendari sira. ");
INSERT INTO sim_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ermba ermbak si ifarafa si sawerik or misihi mbeek sirin jelyakurik hishindari ambu ri. Hako am or krehe ormu hishira, �An mbeek Avui Wasilakan a ajehe man jelyakwak a hishinda ambu nir. ");
INSERT INTO sim_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hako os a hala nahi, mumbla roso mashi roso nom si ifarafa sawenak am a kreher. Uwa osik os si mbawa hom a uka.� � ");
INSERT INTO sim_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Karem Wasilaka or mbaha ormu sawera, �Majistret kava kato mbahanda mashin ji misihi ji hishiyarika. ");
INSERT INTO sim_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Os Avui Wasilaka kamahanda ma ondo niri tandi ermba ermbak orin li sawe li tla nahi, wa am lirin kumaifakundar? Wahau. ");
INSERT INTO sim_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jirin amu sawenduwa. Kolomalok lirin jelyakwa ri. Hako os Ma Jikisi Avui Wasilakahi oto indik or takuna wolo ma lal am orin li hishindiyanak or heyekundal?� ");
INSERT INTO sim_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma lal karem hishinda ola. Lir jivik li nawak lal mbeek lir nanda hom nanda ambu lir. Undari osik Jisas ma ol erem hishindari man ormu sauheimak sawera, ");
INSERT INTO sim_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","�Ma frijip Avui Wasilakan fri sawekmbaha tempel akak frimu layira. Lar Farisi, lar takis yan landa ria. ");
INSERT INTO sim_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi oto orok or sihi wavu orhikop Avui Wasilakan karem ormu sawera, �Avui, an mbeek ma kava ondo hom a nanda ambu onik mirin armesarmek amu sawenduwa. Ma ondo hirnyaha kavakavan li uhu nokophirmbirinda lir. Hako an wahau. Tor torok liwa takis yan landa ma roton heyeka. An mbeek or hom a nanda ambu nir. ");
INSERT INTO sim_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wik namtarmba namtarmbak tandi frijip akwan a halaha mirin a sawenda ona. Uhu mbele mbele ol a lawan 10-pelak a humasi owehe namtas mirin a handa nir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hako ma or takis yan landa ma oto homek or sihi mbeek metenje yok larasa mawuri ambu ri. Or maruknyaha ormu mbara, �Avui, an ma kava nir. Hako mir anjik holoka,� karem ormu mbara.� ");
INSERT INTO sim_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Uhu Jisas mu mbara, �Jirin amu sawenduwa. Ma or takis yan landa ma oto Avui Wasilakahi misokomek jivik or naha indik aka orhik ormu ira. Hako Farisi oto, wahau. Mberem ushirik? Ma ol hi lihin hauowenda ondo Avui Wasilaka hi lihin or hakaowenda lir. Ma ol lihinjik hafakaha liwa, Avui Wasilaka hi lihin or hauowenda lir.� ");
INSERT INTO sim_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hulaima nokopma jikisakri lihin Jisasik limu laharara. Unak lirin or toloho Avuin or sawenak lirin armek or ukmbahan. Hako orin tiyandari ma ondo oson li heyehe ma ondon olmu ngriara. ");
INSERT INTO sim_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Urik Jisas usharik pasir os or siri mishik jikisi ondon limu laharara. Urik orin tiyandari man ormu sawera, �Jir jikisi tondon halashinak anhik li raka. Jir avak pantlewa hala. Ma ol jikisakri rondo hom nawa ma ondo Avui Wasilakahi krahak li sihi yanga jivik ikwa lira. ");
INSERT INTO sim_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Omendingak jirin amu sawenduwa. Os jikisakri kanda rondo hom ji naha kraha Avui Wasilakahik ji si nahi ambu, jir mbeek yanga jivik i layikwa ambu jir, wahau.� ");
INSERT INTO sim_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Urik malakama lar Jisasik or taha ormu silira, �Mir tisa jivi mira. Mberem a uhu os ermba ermbak linda oson avai laku?� ");
INSERT INTO sim_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Urik Jisas mu orin sawera, �Mberem ushiwak an jivi, karem mi mbandu? Avui Wasilaka ortonom jivi ria. ");
INSERT INTO sim_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Angop mi heyenda sir, lo ol Moses mas or kayehendari ondon. Nokophirmbiriwa hala. Man mandingormewa hala. Hirnyawa hala. Man sembe mbaha haimba handambawa hala. Avoko nijava mihin tiyaha mashi frihin misika.� ");
INSERT INTO sim_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Karem or mbarik ormu mbara, �An jikisakrik a nari wolokop sishihi raha ter nga mashi ondo amber angop a tiyarakonda nir.� ");
INSERT INTO sim_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Karem or mbarik ormu sawera, �Mbele las os mendek mi nawak amu heyenduwa. Mir mbele mbele mihi ondo amber mi mbashinak li frungawushinak ya oson mi laha erndakava ondon haka. Ushihi ra anin tiyaka. Os erem mi uwa mbele mbele kumak hevenik mi lakundan os mimu hundujenduwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Malakama oto mashi oson or misihi fumunyava orhi kava heyehe wavu orhi nga kavak er nari sir. Mberem ushirik? Or ya mbele mbele mushak nandari ora. ");
INSERT INTO sim_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Urik Jisas ma oton or heyehe ormu sawera, �Ma ol mbele mbele mushak nanda ondo Avui Wasilakahi siyok li sikmbaha li hishiwa, anala mendekwa sir. ");
INSERT INTO sim_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel lar am kowen tlavanda nil washi orok layikundar? Wahau. Unda hom ma ol mbele mbele ngashi ondo Avui Wasilakahi siyok li sikmbaha li hishiwa, kava ukwa mende sir.� ");
INSERT INTO sim_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Karem or mbarik li misihi limu silira, �Ayo, os erem si na nahi, lawe avak os ermba ermbak linda oson laku?� ");
INSERT INTO sim_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Urik ormu mbara, �Mbele mbele ol ma undahi ambu ondo Avui Wasilaka or undahi lir.� ");
INSERT INTO sim_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Urik Pita mu mbara, �Misi, nir mbele mbele nihin angop er ni halarakoho mirin nimu tiyanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Urik ormu mbara, �Omendingak jirin amu sawenduwa. Ma ol Avui Wasilaka ma orhin or arangoshinak li likunda mashin sawe ikmbaha anin tiyanda ma ondon Avui Wasilaka armek or ukwa lir. Mbele mbele aka, nokove, mahasanje, avoko nijava, jikisi lihin li halanda ondohi farniyik misambi torok li liwa wolo warje nga nor hakwa lir. Undanak kumak ermba ermbak linda oson lakwa lir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas ol orin tiyandari ma 12-pela ondon ormu sawera, �Ji misi. Avak Jerusalemik ni ikwa nir. Unak mbele mbele amber os Ma Jikisi Avui Wasilakahik talakmbaha profet mas li kayehendari oso avak omek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Avak orin Romik fehenda ma ondohi tavarenjek li hakwa ri. Uhu kavakavan li mbaha li okolehe li suntlayashikwa ri. ");
INSERT INTO sim_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Uhu li wakoroho li mandingormekwa ri. Hako niri frijip fri ishinak indiyok usahakwa ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hako ma ol orin tiyandari ondo mashi os or mbari oso maintontlo sihi si wanyishirik mbeek yariri ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas or ihi kuyanga Jerikok am pasir or narik misokome tumundari ma lar nombo sumbuyok or lihi yanjik ormu silira. ");
INSERT INTO sim_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Or lihi nor misirik ma musha mendek li taltala irik ormu silira, �Mberem ji undua?� ");
INSERT INTO sim_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Urik limu sawera, �Jisas Nasaretik fehenda ormu randuwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Karem li mbarik kolok wasilakak ormu ushambara, �Jisas, nirambara Devithi mirin, an wavu mi hishiwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hako ma ol maifuk tari ma ondo orin li ngriaha limu mbara, �Mir mayam li.� Hako, wahau. Indik wasilaka mendek or ushaha ormu mbara, �Nirambara Devithi mirin, An wavu mi hishiwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Urik Jisas or taha pasir or sihi nor mbashirik orin limu laharara, os or siri mishik. ");
INSERT INTO sim_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Urik Jisas mu orin silira, �Mberem a miri ukmbaha mi hishindu?� Urik ormu mbara, �Wasilaka, a heyekmbaha namu hishinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Urik Jisas mu sawera, �Misokome mihi avak mi heyekwa sir. Anin mi hishiowewa nombo orok misokome mihi avak jivik nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Urik kolok misokome orhi si huririk or heyehe hi Avui Wasilakahin or hauowehe Jisasin ormu tiya ira. Urik ma amber oson li heyehe lir nga nakrem hi Avui Wasilakahin limu hauowera. ");
INSERT INTO sim_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas yanga Jerikok or layishihi ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma lar orok lindari ri. Hi orhi Sakias oria. Oto takis yan landari ma ondo malakama lihi ria. Or ya nga musha mendek nandari ri. ");
INSERT INTO sim_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hako, �Jisas mberem nanda ma ri?� Karem or hishihi Jisasin heyekurik ormu ura. Hako or fanyitombo kandak or nandari osik ma musha mendek orin li tikri li arangoshirik mbeek Jisasin or heyekurik nari ambu. ");
INSERT INTO sim_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Uri osik masmas ormu shirinya ira. Or ihi Jisas ikuri nombo yok mitenje lasik ormu lawu lira, uhundanak Jisasin or heyekmbahan. ");
INSERT INTO sim_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Urik Jisas am or taha orok or sihi nor simawuhu ormu sawera, �Sakias, mbermbar taka. Ter an nga aka mihik shi likwa shir.� ");
INSERT INTO sim_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Karem or mbarik kolomalok or takaha sunguwavu orhi nga rupshi mendehe Jisasin or laha aka orhik frimu layira. ");
INSERT INTO sim_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Urik ma ondo oson li heyehe li wapkava hishihi limu mbara, �Jisas toto kavakavan unda ma otohi akak or layi liwa re,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hako Sakias or usasihi Wasilakan ormu sawera, �Wasilaka, misi. Ter mbele mbele anhin a humasihi yeje avak ma ol erndakava ondon a hakwa nir. Uhu mbele mbele a mbafirimbaha na lahandan avak warje nga na hovok hakwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Karem or mbarik, Jisas mu orin sawera, �Avui Wasilaka ter angop mir nga jikisnokopji mihi nga jivinawa ri. Mir er nga nirambara indingo Abrahamhi mira. ");
INSERT INTO sim_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma Jikisi Avui Wasilakahi oto kavakavan unda ma ondon or lasaha lirin jivinakmbaha rari ri.� ");
INSERT INTO sim_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas Jerusalemik or layikuri am pasir si nari osik ma ondo karem limu hishira, �Avui Wasilaka ma orhin or arangoshinak li likwa ter kormbak talanak ni heyekwa sir.� Karem li hishirik or heyehe lirin tolowornakmbaha sauheimak ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","�Hiushama lar yanga home mendek or inak li kamashinak malakamakk or nakmbaha ormu ira. Ushinak indik kotontlo orhik or taha orhi man or arangoshinak li likmbahan. ");
INSERT INTO sim_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Os or ikuri wolo ma 10-pela ol ornjik lerawun landari ma ondon or usharik li tarik ya gol namtasmba namtasmbak lirin or haha karem ormu sawera, �Ya kason ji toloho lerawun ji laka. Unak indik a raka.� Karem or mbashihi ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hako ma ol kotontlo orhik fehe orin li wapkava hishihi ma lal li mbashirik yanga os or iri mishik limu ira. Uhu karem limu sawera, �Nir ma toto malakama nihik or nakwan ni turaw,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hako angop li kamashirik malakamak or naha indik kotontlok ormu tara. Or taha karem ormu mbara, �Ma ol yan a hahandan ji sawenak li raka. Unak lirin a silheyeka. Am lerawun li laha ya lal er nga mushak lari ol?� ");
INSERT INTO sim_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Urik ma lar masmas or taha ormu mbara, �Malaka anhi mirin, ya gol namtas mi harin a toloho lerawun a larik 10-pela er nga talari lir.� ");
INSERT INTO sim_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Karem or mbarik malakama mu mbara, �Mir lerawun jip lari mira. Mbele mbele os awarikandak narin armek mi tolori osik avak kuyanga 10-pela mirin a halashinak arangoho washilikwa mir.� ");
INSERT INTO sim_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Urik lar taha ormu mbara, �Malaka anhi mirin, ya gol namtas mi harin a toloho lerawun a larik 5-pela er nga talari lir.� ");
INSERT INTO sim_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Urik malakama oto mu mbara, �Mir yanga 5-pela yoko hom washilikwa mir.� ");
INSERT INTO sim_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Urik lar taha ormu mbara, �Malaka anhi mirin, ya mihi kasira, mbeek lerawun a lari ambu sir. Ya mihin koutakrik a ishihi armek a oweshirik wari sir. ");
INSERT INTO sim_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mir mambalek mi naha mbele mbele ol ma anandi oweshirin landa mir. Uhu akwa ol nowek li lashirin er nga landa mir. Undari osik os amu ajera.� ");
INSERT INTO sim_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Urik malakama orin ormu sawera, �Mir ma kava indinga mbafirimbanda ma mir. An mambale, karem mi hishirikop, ");
INSERT INTO sim_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","mberem ushirik ya anhi oson bengik mi owekurin mi halar? Os bengik mi owendakop os indik a rawa wolo ya lal er nga na lawa nir.� ");
INSERT INTO sim_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Uhu ma ol pasir sirin ormu sawera, �Ya os or tolowan ji laha ma or warje nga lawan er nga ji haka.� ");
INSERT INTO sim_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Urik limu mbara, �Malaka, or angop warje nga lawa or te.� ");
INSERT INTO sim_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Urik ormu mbara, �Jirin amu sawenduwa. Ma ol mbele mbele a handan yawur toloho lerawun landa ondo mbele mbele lal er nga na hashinak warje nga lakwa lir. Hako ma ol mbele mbele a handan yawur toloho lerawun landa ambu ondo mbele os li tolondan avak a lashinak men likwa lir. ");
INSERT INTO sim_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hako ma ol malakamak a nakurin turari ondon torok ji laharanak a mbashinak li mandingormeka.� � ");
INSERT INTO sim_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas sauheima oson or saweshihi Jerusalemik li indari nombok indik ormu lawura. ");
INSERT INTO sim_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Am li ihi kuyanga Betfage nga Betani nga op telemba Oliv sumbu orok nandari mishik limu talara. Uhu orin tiyandari ma frijip or mbashinak yanga pasir nanda orok fri ikurik ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","�Kuyanga kasaik ni heyewa mishi orok shi ihi shi heyenak donki akri sahanda lar kuvuk li ishishihindak or sindu. Donki oto mbeek ma lal mas li lihi ihinda ambu ri. Avak kuvun shi sorngoho anjik shi laharaka. ");
INSERT INTO sim_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Os ma lar shirin or silihi nor mba, �Mberem ushiwak donki oton shi sorngo laha indua?� Karem or sili nahi, karem shi saweka, �Wasilaka lerawu nga nor nawa osik or mbashiwak shimu randuwa,� karem orin shi saweka.� ");
INSERT INTO sim_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisas karem or saweshihi or mbashirik fri ihi fri heyeri mbele mbele ondo os or saweri hom si narik frimu heyera. ");
INSERT INTO sim_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am fri i heyehe frimu sorngora, kuvu os donkin li ishishirik or siri oson. Urik mashama fririn limu silira, �Mberem shi ukwak donki oton shi sorngo laha ikwak shi undua?� ");
INSERT INTO sim_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Urik frimu mbara, �Wasilaka lerawu nga nor nawa osik or mbashiwak shimu laha ikmba unduwa.� ");
INSERT INTO sim_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Karem fri sawe lafakaha donki oton frimu laharara. Uhu kousamba frihin fri tloloho donki heyek fri oweshirik Jisas mu lawu lira. ");
INSERT INTO sim_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Am or lawu lihi ormu ira. Urik ma mushak kousamba lihin li tloloho nombok limu laha lere ira. ");
INSERT INTO sim_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am or ihi pasir telemba Oliv siyok ormu sira. Urik ma ol orin tiyandari ondo ma undahi ambu ol or urik li heyendari ondon li hishiowehe limu rupkapshira. Uhu wasilakak hi Avui Wasilakahin limu hauowera. ");
INSERT INTO sim_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Uhu limu mbara, �Halanak Avui Wasilaka ma or hi orhik tawa king oton armek or uka. Nir Avui Wasilaka or hevenik linda oton nimu hauowekuwa. Waprupshi orhi nga nor halashiwak nimu waphimbiji linduwa.� ");
INSERT INTO sim_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hako Farisi lal ma nindik li sihi Jisasin limu sawera, �Tisa, mirin tiyanda tondon kwambuk mbanak erem li mbawan li halaka.� ");
INSERT INTO sim_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hako Jisas ormu mbara, �Jirin amu sawenduwa. Os mayam li si nahi, sunja tondo nga avak hi Avui Wasilakahin hauowekwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas am or ihi Jerusalemik or layikuri ambek or sihi kuyanga laka oson ormu heyera. Or heyehe orok fehendanjik or tlaha ");
INSERT INTO sim_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","normu mbara, �Jerusalemik fehenda jirin, ji halashinak Avui Wasilaka waphimbiji orhi jirik si nakuri os jimu halara. Os ji lakurikop masa. Hako ter osmu wanyinduwa. Unak mbeek ji heyekwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kumak wutari jihi avak li raha awun li hongoho talayantlehe arangokwa lir. ");
INSERT INTO sim_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Uhu li raha jir nga jikisi jihi nga li jihi kava indingok li nakwa jir. Uhu yanga jihin er nga kavak li narakokwa sir. Mberem ushiwak? Jir mbeek ma or Avui Wasilaka jirin jelyakmbaha tahandan heyenda ambu jir.� ");
INSERT INTO sim_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Urik Jisas or ihi tempel aka os inyik li washi arangondari mishi orok ormu layira. Uhu ma ol orok lihi mbele mbelen ewerik li frungawuri ondon or jilakrialaha normu ermbera. ");
INSERT INTO sim_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Uhu normu mbara, �Jekamba Avui Wasilakahik karem li kayehendari sir, �Aka anhi anin li sawenda aka sir.� Hako ter jir os jimu uwak hirnyanda ma lihi aka hom osmu nanduwa,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Uhu ermba ermbak tempel aka orok mashi jivin ormu sawendara. Hako mashi Moseshin sawendari ma ondo nga bikpris ondo nga Judama lida lihi ondo nga Jisasin li mandingormekuri nombon limu oweioweiheyera. ");
INSERT INTO sim_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hako ma musha mendek Jisas sawendari mashin li misihi orin li rupshiri osik mbeek orin li mandingormekuri nombo las li heyekurik nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nindi las wolok Jisas tempel akak or layihi mashi jivi Avui Wasilakahin or owesawerik bikpris ondo nga mashi Moseshin sawendari ma lal nga Judama lida lihi lal nga limu tara. ");
INSERT INTO sim_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Uhu orin limu silira, �Mir sawenak ni misi. Lawe mbashihindak lerawu oson mi landu?� ");
INSERT INTO sim_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Urik ormu mbara, �Os mbele las jirin a siliwan armek ji sawenak a misi nahi, an nga vai sawenak ji misikwa sir, lawe or mbashihindak lerawun a landu. ");
INSERT INTO sim_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon man fak or tolofalendari oto lawe mbashirik lerawun or lar? Avui Wasilaka mbashirik mo ma misambik fehe mbashirik lerawu oson lari or?� ");
INSERT INTO sim_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Urik lihi ambek limu mbara, �Mberem ni mbakwa ambu re. Os ni mba, Avui Wasilaka mbashirik lerawu oson ormu lara, karem ni mba nahi, avak or mba, �Mberem ushirik orin ji tiyakurin ji halar?� karem mbakwa ora. ");
INSERT INTO sim_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hako os ni mba, ma misambik fehenda mbashirik lerawu oson ormu lara, karem ni mba nahi, ma rondo avak nirin li sunjakom loho ormbekwa ola. Mberem ushiwak? Jon oto profet oria, karem hishinda ola.� ");
INSERT INTO sim_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Karem li hishihi limu mbara, �Nir ni hishiwa kom.� ");
INSERT INTO sim_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Urik ormu sawera, �An ngana, mbeek jirin a sawekwa ambu nir, ma or anin mbashihindak lerawu toson a lawan.� ");
INSERT INTO sim_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas sauheimak ormu sawera, �Ji misi. Ma lar wain nowe las or laha ma lalhi tavak or halashihi yanga home lasik ormu i lira. ");
INSERT INTO sim_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Undarik wain siji ondo am li nivikuri wolok si narik noumashama oto ornjik lerawun landari ma lar or mbashirik wain nowen washilindari man or heyehe ornjik lal or nimba laharakmbaha ormu ira. Hako ma ol nowe orok landari ma ondo orin li jihi li mbashirik tapas ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Urik noumashama ornjik lerawun landari ma anandi lar nga nor mbashirik ormu ira. Urik or er nga li jihi kavak er li naha li mbashirik tapas indik ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Urik lar er nga nor mbashirik ormu ira. Urik or er nga li jihi li ermberik ormu tulura. ");
INSERT INTO sim_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Urik noumashama ormu mbara, �Ter mberem avai uku? Avak jikisi anhi tor a rupshindan a mbashinak or inak mashi orhin avak li misikwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hako ma ol nowe orok landari ma ondo jikisi orhi oto rarik li heyehe lihi ambek limu mbara, �Noumashama jikisi orhi indingo ormu tanduwa. Ka ni i orin jimandingormehe mbele mbele orhi ondon hiniyin ni oka.� ");
INSERT INTO sim_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Karem li mbaha orin hikriyok li tololongo lalayihi orin limu mandingormera. Wa, jir mberem ji hishindu? Noumashama oto ma ondon mberem orvai uku? ");
INSERT INTO sim_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Avak or taha ma kava ondon or mandingormehe nowe oson ma anandi lalhi tavak or hakwa sir.� Jisas karem or mbarik ma ondo mashi oso li misihi limu mbara, �Erem or uwan or hala.� ");
INSERT INTO sim_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Karem li mbarik Jisas lirin or heyehe ormu mbara, �Mberem ukurik jekamba Avui Wasilakahik karem li kayer? �Sunja ma ol akan unda ondo, kava, karem li hishihi li ormberi sir. Hako wahau, angop wormbonawa hom maifuk ormu sinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ji misi. Ma ol sunja heye orok takatukuyiwa avak havan tlekwa lir. Unak os sunja oso ma lalhi heyek si raka nahi, si mandingormekwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas karem or mbarik mashi Moseshin sawendari ondo nga bikpris ondo nga li misihi limu hishira, �Jisas sauheimak or sawewa nirin or sawewa sir. Wain nowe oson washilindari ma ondo nirin olmu heimanduwa.� Karem li mbaha orin li tolokmbaha limu hishira. Hako hulaima nokopman li ajeri osik os limu halara. ");
INSERT INTO sim_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Uhu bikpris nga mashi Moseshin sawendari ondo nga Jisasin mandingormekuri nombon limu li hishira. Uhu ma lal li mbashirik limu ira. Li ihi karem limu haimba handambara, �Nir Jisashi mashin misikwak ni rawa nir.� Erem li mbanak mashi las or mbanak li heyehe nombo orok malakama Romik fehe orhi tavak Jisasin li kotim ukmbahan. ");
INSERT INTO sim_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Li ihi Jisasin limu silira, �Tisa, nir angop ni heyenda mir. Mashi mihi wornak si nawak mainome nom sawenda mir. Ma amber hi ngashi nga hi ngashi ambu nga nakremkop sawenda mir. Mashi omendinga os Avui Wasilakahik nanda nom sawenda mir. ");
INSERT INTO sim_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hako mberem mi hishindu? Nir takis yan Sisarin ni hakwa oso jivik nakwa os mo wahau?� ");
INSERT INTO sim_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hako Jisas os orin li oweioweiheyehe orin li kotim ukurik li mbari oson angop or heyeri sir. ");
INSERT INTO sim_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Uri osik ormu mbara, �Ya las ji hanak a heye. Fumunyava lawehi nga hi lawehi nga ya torok si wandu?� Urik limu mbara, �Sisarhi vria.� ");
INSERT INTO sim_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Urik ormu mbara, �Wa, mbele mbele ol Sisarhi ondo indik orin ji haka. Hako mbele mbele ol Avui Wasilakahi ondo indik orin ji haka.� ");
INSERT INTO sim_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Karem mbarik li misihi li lishnyafaha mayam er limu sira. Uhu mbeek mashi las orin li haimba handambaha orin li kotim undahik nari ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Judama lal Sadyusi lira. Lir karem hishinda lir, ma ol hahanda ondo mbeek indik usahakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ma ondo Jisasik li taha orin limu silira, �Tisa, Moses mashi las karem nirin or kayeri osa, �Os ma lar nokoplaha jikisi nga nor na namber or hashinak maha orhi lar mumbla oson or owehe jikisi nga fri nawa tlavuji oto sanje laka or hahanda orhik nakwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hako mas mahasanje 7-pelak nahandari lir. Uhu sanje laka or nokoplaha jikisi nga nor na namber, er hari ri. ");
INSERT INTO sim_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ushirik maha orhi mu mumbla oson owera. Uhu or hashirik ");
INSERT INTO sim_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","orhi hindiyashi mu mumbla oson owera. Uhu or er nga ormu hara. Karem uhu mahasanje 7-pela ondo amber nokove oson li laha jikisi nga li na namber er limu harakora. ");
INSERT INTO sim_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Urik nokove oso nga er simu hara. ");
INSERT INTO sim_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hako avak mi mbanak ni misika. Kumak ma ol hahanda indik li usahana wolo nokove oso lawehik si naku? Mahasanje 7-pela amber nokove oson lari ola.� ");
INSERT INTO sim_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Karem mbarik Jisas mu sawera, �Ma ol ter liwa olmu nokoplaha hulasinduwa. ");
INSERT INTO sim_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hako ma ol Avui Wasilaka or mbanak indik usaha ermba ermbak or nga likwa ma ondo mbeek hulasihi nokoplakwa ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Lir mbeek indik hakwa ambu lir. Avui Wasilaka or mbanak indik li usaha avak jikisi orhik li naha ensel orhi hom nakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hako hi os mi awarikandak ukrurik Moses or heyehe nor kayeri oson ji hishika. Oso er nga nirin si mukunak ni heyekwa sir, ma ol hahanda indik usahakwa oson. Avui Wasilaka orhinjik karem or mbari osa, �An God Abraham, Aisak, Jekop lihi God anira.� ");
INSERT INTO sim_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mashi os or mbari oso mu nirin kormbak mukunduwa. Avui Wasilaka mbeek ma ol hahanda lihi God ambu ri, wahau. Or God ma ol linda lihi God oria. Misokome orhik or heyewa, ma amber olmu er linduwa.� ");
INSERT INTO sim_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas mashi oson or mbarik mashi Moseshin sawendari ma lal li misihi limu mbara, �Tisa, mashi mihi jivina.� ");
INSERT INTO sim_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Karem li mbarik Sadyusi ondo Jisasin mbele lal nga li silikurin olmu ajera. ");
INSERT INTO sim_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Urik Jisas lirin ormu silira, �Mberem ushiwak karem li mbandu, Krais Devithi nirambarak nakwa ri? ");
INSERT INTO sim_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ji misi. Devit orhinjik karem or mbari sir. �Avui Wasilaka ormu Wasilaka anhin karem sawera. ");
INSERT INTO sim_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","�Mir tapmama anhik lika. Ushinak wutari mihin avak a halashinak mihi siyok sikwa lira.� � ");
INSERT INTO sim_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ji misi, os Devit orhinjik or mbar, Krais Wasilaka anhi ria, karem or mbari sir. Os erem si na nahi, mberem ushiwak Krais nirambara Devithi, karem li mbandu?� ");
INSERT INTO sim_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Urik ma amber li misirik Jisas orin tiyandari man ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","�Ji auheyeka, ol mashi Moseshin sawenda ma ondon. Lir unda hom ji uwa hala. Lir kowe hombelakan li falehe li ikwan rupshinda ola. Uhu ma tirsanda mishik li inak ma lirin li heyehe li makshitakshikwan rupshinda ola. Uhu os li lotu unda mishik li layihi maifuk li lerenda kawu orok li likwan rupshinda ola. Uhu hiyawu wasilakan li unda mishik li ihi malakama linda mishik li lihi akwan li akwan rupshinda ola. ");
INSERT INTO sim_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Uhu nokove ol mumblak wahayandan li haimba handambaha mbele mbele lihin landa ola. Uhu os Avui Wasilakan li sawewa wolo mashi hombelakak li sawenak ma li misihi li mba, tondo ma jivi tolira, karem li mbakmbaha unda ola. Hako os Avui Wasilaka hulaima nokopman or heyembakmbaha or mbahanda wolo lir avak nomorawu wasilaka menden kishakwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas tempel akak or lihi nor heyerik ma ol ya nga nahandari ma ondo li raha ofa lihin olmu bokis orok ormbera. ");
INSERT INTO sim_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Or lihi nor heyerik mumbla kava las si raha ya frijip bokis orok simu ormbera. ");
INSERT INTO sim_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Urik Jisas mu mbara, �Omendingak jirin amu sawenduwa. Mumbla kava toso ya wasilaka mendek hawa sir. Ya op si hawa ovro ma anandi ondo hawan tikriwa sir. ");
INSERT INTO sim_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mberem ushiwak? Sir mbeek ya lal nga aka sihik wawa ambu sir. Ya kanda op wawa, ambehoma, op simu ormbewa. Hako ma ol ya mushak ormbewa ondo lalndonom li ormbewa lir. Lal lihi olmu akak wanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Urik orin tiyandari ma lal li taha tempel aka oson li heyehe limu mbara, �Sunja jiviwavi tondo nga mbele mbele tol li laha Avui Wasilakan li handa tondo nga li toloho aka toson armek li ushindak nimu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Urik Jisas mu mbara, �Ome sira. Hako jirin amu sawenduwa. Mbele mbele tol ter ji heyewa tondo avak li taha li jilatarvlalanak takakwa lir. Mbeek ji heyenak indik erem nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Urik Jisasin limu silira, �Tisa, mbele wolo mendek nomorawu oso si talanak ni heyeku? Mbele os masmas talanak ni heyehe ni mba, �Nomorawu osmu talakwak pasir nanduwa,� karem ni mbaku?� ");
INSERT INTO sim_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Urik Jisas mu mbara, �Ji auheyeka. Ma musha avak hi anhik li otle raha karem mbakwa ola, �An Krais anira.� Uhu karem mbakwa ola, �Mbele mbele os talakwa osmu talanduwa.� Hako lirin ji tiyawa hala. ");
INSERT INTO sim_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Uhu kumak avak ji misinak yanga yangak awun ukwa lir. Unak maintama nga auhukwa nga ji misikwa sir. Hako oso wolo ji ajewa hala. Mbele mbele ondo masmas talakwa lir. Hako misambi nga lersuwu nga mendek fri nakwa, os akrik.� ");
INSERT INTO sim_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Uhu mashi lal nga ormu sawera, �Kraha lasik fehe hovok kraha lasik fehe nga anajikwa lir. Malakama yanga lasik fehe hovok malakama lasik fehe nga anajikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Unak nenawu wasilaka yanga yangak er nga jikwa sir. Unak kuyanga lal erenghanak kuyanga lal kavamisikwa lir. Unak lersuwu yok mbele mbele apsham apshamhi li nanak ji heyehe ji ajekwa osa. ");
INSERT INTO sim_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hako mbele mbele nomorawu ondo li tala namber, avak jirin li tolo laha ihi os li lotu unda akak malakamahi misokomek jirin li kotim uhu krawuk li owekwa oja, anin ji tiyanda osik. Uhu kavakavak jirin ukwa ola. ");
INSERT INTO sim_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hako os erem li uwa wolo mashi anhin lirin ji saweka. ");
INSERT INTO sim_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hako jir wavu musha mushak ji hishiwa hala, mashi os lirin ji sawekwan. ");
INSERT INTO sim_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mberem ushiwak? Mashi os ji sawekwa avak a sauhakwa sir. Uhu hishiyarindan jirin a hakwa sir. Unak ma ol jirin kotim uwa ondo mbeek mashi las jirin mbakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Avoko nijava jihi nga mahasanje jihi nga kraha jihik fehe nga naimble jihi nga jirin wutarihi tavak li hanak jihi lal avak li mandingormekwa jir. ");
INSERT INTO sim_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jir anin ji tiyanda osik ma amber hom jirin wapkava hishikwa lir. ");
INSERT INTO sim_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hako masikukwa jihi lar mbeek kavak nakwa ambu ri. Avui Wasilaka angop or heyetakonda lir. ");
INSERT INTO sim_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uwa osik kwambuk ji sitambanandanak ermba ermbak linda oso avak jihik si naka.� ");
INSERT INTO sim_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Uhu Jisas mashi las nga ormu mbara, �Os awun unda ma Jerusalemin li talayantlenak ji heye nahi, karem ji hishika, �Yanga toso avak kavak nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Erem si nawa wolo provins Judiak linda ma telembak li tulu ika. Unak ma ol Jerusalemik linda ma yanga oson halaha yanga lasik li tulu ika. Ma ol Jerusalem hikriyok linda ondo Jerusalemik li layiwan li halaka. ");
INSERT INTO sim_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Oso wolo Avui Wasilaka kavakavan li unda wasan ormu hakwa wolo sira. Unak mashi os jekamba orhik li kayehendari osmu omek nakuwa. ");
INSERT INTO sim_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kavasumba, nokove ol masamnomok nawa nga jikisakrin mukhawa nga mberem livai tuluku? Nomorawu wasilaka mendek misambi torok si nanak waplelena Avui Wasilakahi Judamahik nakwa osa. ");
INSERT INTO sim_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Unak wutari li talaha lal li jimandingormehe lal yanga yangak li laha i oweshinak orok li lihi lerawu havakavan lakwa lira. Ushihi Judama ambu ondo olmu Jerusalemin hiniyinhongo likuwa. Uhu ihi nom os Avui Wasilaka mbahanda wolok si nanakop halakwa lir.� ");
INSERT INTO sim_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas ormu mbara, �Oso wolo mbele mbele apsham apshamhi ta niyaka tashingrahahik nakwa sir. Unak ma misambik fehe wavu lihi avak kavak nakwa sir. Uhu li misinak solwara er nga si mbunyanak wavu musha mushak li hishihi ajekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lersuwu yok nenawu si jinak mbele mbele wasilaka ondo avak li lishirinak ma misambik fehe mbele mbele ol misambik talakwan li hishihi aje mendekwa lir. ");
INSERT INTO sim_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Unak oro wolok ma amber li heyenak Ma Jikisi Avui Wasilakahi lersuwu avisha lasik or ese sihi kwambu orhi nga ukruharanda orhi nga rakakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mbele mbele kando li talanak ji heye nahi, ji rupshihi ji sitambanaka. Mberem ushiwak? Avui Wasilaka jirin armek or ukwa wolo osmu pasir nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Uhu Jisas sauheima las lirin ormu sawera, �Mi fik oso nga mi anandi ondo nga ji heyeka. ");
INSERT INTO sim_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Am li shorngo hanyiwak ji heyehe karem mbanda jir, ta am or jikwa wolok osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Uhunda hom erema. Mbele mbele ondo talanak ji heyehe karem ji hishika. Avui Wasilaka orhi man or arangoshinak li likwa wolo osmu pasir nanduwa. ");
INSERT INTO sim_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Omendingak jirin amu sawenduwa. Ma tol ter liwa lal li ha namber, mbele mbele ondo talakwa lir. ");
INSERT INTO sim_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Misambi nga lersuwu nga mendek nakwa vri. Hako mashi anhi mbeek mendek nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jisas mashi lal nga ormu sawera, �Jir auheyeka. Avak uku kavan ji aha ji ambarambasiwan ji hala. Uhu mbele mbele tol misambik fehendanjik ji hishombashiowewan ji hala. Las avak erem ji una nindik Wasilaka tumsar or tanda ngashi. ");
INSERT INTO sim_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Os or tawa wolo ma misambik fehe lar mbeek tulu ikwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ermba ermbak ji auheye ji lika. Uhu os mbele kava las jihik talawa wolo Avui Wasilakan ji sawenak kwambun or hashinak kwambuk ji sika. Unak Ma Jikisi Avui Wasilakahi indik or tawa wolo kwambuk er ji sika,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisas tempel aka orok mashin sawendari ri. Uhu niri wolo yanga os telemba Oliv orok nandari orok or ihi wandari ri. ");
INSERT INTO sim_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Urik nursumbu mendek ma amber tempel aka orok mashi orhin li misikurik tandari lir. ");
INSERT INTO sim_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hiyawu Pasovan li undari wolo am pasir simu nara. ");
INSERT INTO sim_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bikpris ondo nga mashi Moseshin sawendari ma ondo nga Jisasin li mandingormekuri nombon limu oweioweiheyera. Hako hulaima nokopman li ajeri osik mbeek kormbak mbari ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Urik Laulaka sunguwavu Judas Iskariothik ormu layira. Or ma 12-pela Jisasin tiyandari lar oria. ");
INSERT INTO sim_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ushirik nor ihi bikpris ondo nga ma ol maifuk sihi tempel akan washilindari nga limu anasawera, nombo nombo os Jisasin tavarenje lihik or hakurin. ");
INSERT INTO sim_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Urik ma ondo orin li rupshihi ya lal orin li hakurik limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Urik Judas kolok nombo las ormu lasara. Unak ma mendek li nanak tlembak Jisasin tavarenje lihik or hakurik ormu nikishira. ");
INSERT INTO sim_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hiyawu Pasovan li undari wolok am simu nara. Oso wolo sipsip jikisi lar li jihi bret yis ngashi ambun li andari wolo sira. ");
INSERT INTO sim_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Karem ukurik Jisas Pita fre Jonin normu mbara, �Shi ihi akwa mbele mbele ondon shi hundujeka.� ");
INSERT INTO sim_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Urik frimu silira, �Wa, mbeyok shi ihi akwan shi hundujekmbaha mi hishindu?� ");
INSERT INTO sim_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Urik ormu sawera, �Yanga Jerusalemik shi layika. Shi layinak ma lar ukun awuk or tarmu kisha inak shi heyekwa ri. Unak orin shi tiya ihi aka os or layiwa mishik er nga shi layika. Uhu aka mashaman karem shi saweka, tisa karem mbawa ri, ");
INSERT INTO sim_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","�An nga anin tiyanda ma nga hiyawu Pasovan ni akwa mishi mbei?� ");
INSERT INTO sim_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Karem shi silinak aka heyeyok shirin or lalawuhu os ni akwa mishi las wasilakak nandan or mukushinak shi heyekwa sir. Orok akwan shi hundujeka.� ");
INSERT INTO sim_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Karem mbashirik fri i fri heyeri mbele mbele os or sawerik fri misiri hom er nari sir. Urik akwan frimu hundujera. ");
INSERT INTO sim_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Am li akuri wolok si narik Jisas orin tiyandari ma nga limu lira. Uhu lirin ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","�Nomorawun a kisha namber, an jir nga hiyawu Pasova toson ni akwan amu rupshi mendenduwa. ");
INSERT INTO sim_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jirin amu sawenduwa. Akwa roso kas kumak indik a akwa ambu nir, wahau. Vai kumak yanga os Avui Wasilaka ma orhin or arangoshinak li likwa oso kormbak si talanakop a akwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Karem or mbaha wain uku kas hambiyak or ngoroho laha Avuin armek or sawehe lirin ormu mbara, �Kaso jihi ambek tenjer tenjer ji aka. ");
INSERT INTO sim_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","An jirin amu sawenduwa. Wain uku toson indik a akwa ambu nir. Vai Avui Wasilaka ma orhin or laha or arangoshinak li likwa wolok si nanakop a akwa nir.� ");
INSERT INTO sim_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Karem or mbaha bret las or laha Avui Wasilakan armek or sawehe or toltavaha orin tiyandari man ormu hara. Uhu normu mbara, �Kaso maome anhi kasira. Jirin si jelyakmbaha os amu handuwa. Os a uwak ji heyewa hom kumak erem ji uhu anin ji hishioweka.� ");
INSERT INTO sim_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Am li arakoshihi wain uku kas hambiyak or ngoro laha os mas Avui Wasilakan or saweri hom or uhu ormu mbara, �Wain uku kaso suma akri sira. Fi anhi jirnjik amu ngorokwa sira, ushinak jirin si jelyajehen. ");
INSERT INTO sim_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hako ji heyeka, ma or anin wutarihi tavarenjek hakwa ma oto or an nga nakrem shimu linduwa. ");
INSERT INTO sim_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ma Jikisi Avui Wasilakahi oto nombo os mas Avui Wasilaka mbahanda hom tiyaha hakwa ri. Hako ma or orin wutarihi tavarenjek hakwa oto avak kavak nakwa ria.� ");
INSERT INTO sim_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Karem or mbarik orin tiyandari ma ondo lihi ambek limu mbara, �Lawe mende or erem uku?� ");
INSERT INTO sim_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Uhu orin tiyandari ma mainkwambuk limu mbara, �Lawe wasilakak naha maifuk siku?� ");
INSERT INTO sim_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Urik Jisas ormu sawera, �Malakama misambik fehe ondo jinomkanom li mbashiwak ma lihi siyok sinda lir. Hako lir ma ol lihi siyok sinda ma lirin li heyehe lirin armek li mbakmbaha hishinda lir. ");
INSERT INTO sim_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hako jir erem ji nawa hala, wahau. Ma or jihi nindik malakamak sikwak hishiwa ma oto or halaha ma or ma anandihi siyok sinda hom or naka. Uhu ma or maifuk sikwak hishiwa ma oto or halaha ma or ma anandihi siyok sinda ma hom or naha ma anandin or jelyaka. ");
INSERT INTO sim_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Misambi torok malakama ondo men li lihi mbawak lerawun landa ma ondo akwan laharawak anda lir. Hako anin ji heyeka. An mbeek malakama ondo li unda hom a unda ambu nir. An men lerawun landa ma hom a naha jirin amu jelyanduwa. ");
INSERT INTO sim_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mbele mbele anin oweioweiheyekurik talari wolo jir an nga nakrem ni sindari jira. Jir mbeek anin halanda ambu jir. ");
INSERT INTO sim_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Uwa osik Avui anhi or mbashihindak malakamak a naha hulaima nokopman a arango washilikwa hom an nga jirin a mbashinak malakamak ji naha hulaima nokopman arango washilikwa jir. ");
INSERT INTO sim_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Uhu kuyanga os hulaima nokopman a arangoshinak li likwa mishi orok jir avak an nga nakrem ji lihi aha malakamak ji naha kraha 12-pela Israelik fehe ondon washilikwa jir.� ");
INSERT INTO sim_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","�Saimon, Saimon, mir misika. Avui Wasilaka avak or halashinak Laulaka jirin oweioweiheyekwa ri. Os wit sijin li narkashihi wit ome nom li landa hom. ");
INSERT INTO sim_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hako angop mirnjik Avuin a saweri mir, os anin mi hishiowenda mbeek mendek nakwa ambu sir. Ushinak indik anhik mi tawa wolo, anhi man mi saunjelyashinak kwambuk li sika.� ");
INSERT INTO sim_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Urik Saimon mu mbara, �Wasilaka, an mir nga nakrem krawuk shi ihi nakrem shi hakwa shir.� ");
INSERT INTO sim_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Urik Jisas mu mbara, �Pita, mirin amu sawenduwa. Ter nirik aptoko mba namber, mir avak hindi nalmingrip anin mi heyenda ambu, karem mbakwa mira.� ");
INSERT INTO sim_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Uhu Jisas orin tiyandari man ormu mbara, �Os a mbashirik lerawu anhin ji lakmba iri wolo jir mbeek ya nga mbele mbelen wolonda kowe nga kumba ari nga laha iri ambu jir. Hako oso wolo am mbele las frunguri oj?� Urik limu mbara, �Wahau.� ");
INSERT INTO sim_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Karem li mbarik ormu sawera, �Hako ter jirin a sawekwa karem. Ma ol ya nga nawa er nga li laha ika. Uhu ma ol mbele mbelen wolonda kowe nga nawa er li laha ika. Uhu ma ol bainat nga nawa ambu kousamba lihin li laha inak li frungawushinak bainatin li frungawuka. ");
INSERT INTO sim_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mberem ushiwak? Jekamba Avui Wasilakahik karem li kayehendari osa, �Ma li heyenak kavakavan unda ma hom nakwa ri.� Jirin amu sawenduwa. Jekamba Avui Wasilakahik li kayehendari oso avak omek anhik talakwa sir.� ");
INSERT INTO sim_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Urik limu mbara, �Wasilaka heyeka. Nir bainat frijip kavria.� Urik ormu mbara, �Ambehoma.� ");
INSERT INTO sim_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Uhu Jisas yanga oson or halaha telemba Olivik ormu lawura, os ermba ermbak or undari hom. Urik orin tiyandari ma er nga orin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Am telemba orok li lawuhu ormu sawera, �Jir Avuin ji saweka. Las avak jeikayenda jihik si talanak ji takatukuyinda ngashi.� ");
INSERT INTO sim_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ushihi lirin or halaha kandakar nga homek ormu ira, os ma sunjakombe li ermbenak si ihi kornaha si rakandari ambe hom. Uhu Avui orhin ormu sawera, ");
INSERT INTO sim_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","�Avui, wavu mihi sira. Nomorawu os anhik talakwan laha ormbekwa om? Hako an mbawa hom uwa hala. Os mi hishiwa hom uka.� ");
INSERT INTO sim_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Urik ensel lar hevenin or hala rakaha orin ormu jelyara. ");
INSERT INTO sim_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas wavu orhi kava mendek er si narik kwambuk Avuin ormu sawera. Urik tloravi fi hom maome orhik si rasaha misambik simu ngororakara. ");
INSERT INTO sim_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Avuin or saweshihi orin tiyandari mak or ta heyeri olmu suknyara. Mberem ushirik? Warje mende nga li holori osa. ");
INSERT INTO sim_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Urik lirin ormu sawera, �Mberem ushiwak ji suknyandu? Ji usaha Avuin ji saweka. Las avak jeikayenda jihik si talanak ji takatukuyinda ngashi.� ");
INSERT INTO sim_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas mashi oson or mbari halanganga ma musha mendek limu rara. Ma 12-pela ol Jisasin tiyandari lihi lar Judas karem li ushandari oto nombon or mukuhu limu rara. Or taha pasir or sihi Jisasin ormu makshitakshira. ");
INSERT INTO sim_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Hako Jisas ormu silira, �Judas, os mi makshitakshiwa nombo orok Ma Jikisi Avui Wasilakahin ma kavahi tavarenjek mimu handu?� ");
INSERT INTO sim_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Karem or mbarik orin tiyandari ma ol orok siri ondo mbele mbele os talakurik narin li heyehe limu mbara, �Wasilaka, tondo nga ni anajikwa on?� ");
INSERT INTO sim_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Urik lihi lar bainatin or laha ma or hetprisnjik lerawun landari ma lar mambla orhi mama yokon ormu shinjesera. ");
INSERT INTO sim_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hako Jisas ormu mbara, �Ambehom. Erem uwa hala.� Uhu ma otohi mamblan or haitolorik os si nandari hom indik simu nara. ");
INSERT INTO sim_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Uhu Jisas bikpris nga maifuk sihi tempel akan washilindari ma nga Judama lida lihi ol orin tolokmba rari ondon ormu mbara, �An hirnyanda ma, karem ji hishihi bainat nga kombe nga jimu laharandu? ");
INSERT INTO sim_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ermba ermbak jir nga nakrem tempel aka orok ni liri wolo mbeek anin ji tolokurik undari ambu jir. Hako ter erem ji ukwa wolok osmu nanduwa. Unak kwambu Laulakahi lerawu si lakmbahan.� ");
INSERT INTO sim_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Karem or mbarik orin li tolo laha li ihi hetprishi akak limu laha ira. Urik Pita lirin ormu lundiya ira. ");
INSERT INTO sim_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Urik akanivi kormba orok li lihi hindiya limu lira. Urik Pita er nga normu lira. ");
INSERT INTO sim_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Urik hetprisnjik lerawun landari nokove las Pita hi ukruri mishi orok or lirik si heilataleshihi simu mbara, �Ma roto Jisas nga yanda ma toria.� ");
INSERT INTO sim_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hako sirin or mblarnaha ormu mbara, �Wahau te. An orin a heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kandakar nga nambek li lihi ma lar orin or heyehe normu mbara, �Mir ngana. Mir or nga yanda ma mira.� Hako Pita ormu mbara, �Wahau te. An mbeek orin tiyanda ma ambu nir.� ");
INSERT INTO sim_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ushihi kandakar nga nambek li lihi ma lar mu kwambuk mbara, �Omendinga sira. Ma roto Jisas nga yanda ma toria. Or nga Galilik fehenda ri.� Urik Pita mu mbara, ");
INSERT INTO sim_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","�An mashi os mi mbawa oso amu hisha mendenduwa.� Karem or mbari halanganga aptoko mu mbara. ");
INSERT INTO sim_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Urik Wasilaka or tormblehe Pitan ormu heyera. Urik Pita indiyok ormu hishira, �Ter nirik aptoko nor mba namber, hindi nalmingrip mir avak anin mi heyenda ambu, karem mbakwa mira.� Karem Jisas or mbari mashi oson ormu hishira. ");
INSERT INTO sim_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Uhu hikriyok or layihi havahavan ormu tlara. ");
INSERT INTO sim_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Urik ma ol Jisasin tolori ma ondo orin li okolehe orin limu jira. ");
INSERT INTO sim_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Uhu koutakri lasik misokome orhin li ishi arangoshihi limu silira, �Os mir profet nahi, sawenak ni misi, lawe or mirin jindu?� ");
INSERT INTO sim_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Uhu mashi kavakava anandi lal nga limu orin mbara. ");
INSERT INTO sim_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta am or tasarik Judama lida lihi ondo nga mashi Moseshin sawendari ma ondo nga bikpris ondo nga limu talandirsara. Uhu li mbashirik Jisasin lihik li laha irik limu mbara, ");
INSERT INTO sim_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","�Kolok sawenak ni misika. Mir ma or Avui Wasilaka ngamashihindak hulaima nokopman jivinakmbaha nor mbahanda ma mir mo wahau?� Urik ormu mbara, �Os a sawewa, mbeek mashi anhin ji misindahi ambu. ");
INSERT INTO sim_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Uhu os a siliwa, mbeek anin ji sawendahi ambu. ");
INSERT INTO sim_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hako kumak avak ji heyenak Ma Jikisi Avui Wasilakahi oto Avui orhi or kwambu ngashi orhi tapmama yok likwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Urik lir amber limu silira, �Mir mihinjik Avui Wasilakahi jikisi, karem mimu mbandu?� Urik ormu mbara, �Os ji mbawa ome sira.� ");
INSERT INTO sim_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Urik limu mbara, �Ambehoma. Mbeek ma lal ni mbanak li taha ma roto mbele mbele os or undan sawekwa ambu lir. Os ormu orhinjik sawewak nimu misinduwa.� ");
INSERT INTO sim_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Uhu Judama lida lihi nga bikpris nga mashi Moseshin sawendari ma nga aka oson li halaha Jisasin li laha Pailathik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Uhu orin limu haimba handambaha jira, �Nir ni heyewa, Jisas toto nirin haihanda owehe mbafirimbanda ria. Or mbeek takis yan Sisarin ni hakwa ambu, karem mbanda ri. Uhu ortonom king Avui Wasilaka kamashihindak hulaima nokopman jivinakwa ma ri, karem mbanda ri.� ");
INSERT INTO sim_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Karem li mbarik Pailat mu Jisasin silira, �Mir king Judamahi om?� Urik ormu mbara, �Os mi mbawa homa.� ");
INSERT INTO sim_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Urik Pailat bikpris ondo nga ma ondo nga ormu sawera, �An a heyewa mbeek mbele las or uwak kavak nawak a heyewa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Karem or mbarik mainkwambuk limu mbara, �Wahau te. Or ermba ermbak yanga yangak or ihi mashin sawenda ri. Yanga Galilik sishi raha provins Judia nga Jerusalem nga or ihi Romik fehe gavmanin li jihi tukru ermbekmbaha mbanda ri,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Karem li mbarik Pailat ormu silira, �Ma toto Galilik fehenda or mo?� ");
INSERT INTO sim_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Karem or silirik limu mbara, �He, Herot arangonda mishi orok fehe ria.� Karem li mbarik or misihi or mbashirik Herothik orin limu laha ira. Oso wolo Herot Jerusalemik or taha liri wolo sira. ");
INSERT INTO sim_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot Jisasin or heyehe ormu rupshi mendera. Mberem ushirik? Mbele mbele ol or undari angop li mbarik or misindari osa. Hako or ome mbeek Jisasin heyendari ambu ri. Undari osik Jisasin am or heyehe mbele las ma undahi ambun or unak or heyekmbaha ormu hishira. ");
INSERT INTO sim_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Karem or hishihi mashi musha mushak Jisasin ormu silira. Hako Jisas mbeek mashi las orin saweri ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Urik bikpris nga mashi Moseshin sawendari ma ondo nga orok li sihi Jisasin mainkwambu mendek limu mbara. ");
INSERT INTO sim_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Urik Herot nga awun undari ma orhi nga Jisasin li okolehe malakama falendari kowe las orin limu faleshira. Uhu nor mbashirik indik Pailathik orin limu laha ira. ");
INSERT INTO sim_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herot fre Pailat mas wolo wutarik nandari vri. Hako Jisasin fri oweioweiheyeri wolo frimu ananaimbletolora. ");
INSERT INTO sim_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat bikpris nga Judama lida lihi nga hulaima nokopma ondo nga nor usharik li talandirsarik ");
INSERT INTO sim_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ormu mbara, �Mberem ushiwak ma roton indik anhik ji laharandu? Ma roto man mbaskashiwak awun li unda, karem mbawa jir. Hako an orin a heyewa mbeek erem nanda mak a heyewa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot er nga tos a hishiwa hom or hishihi nor mbashiwak orin indik anhik jimu laharanduwa. Ji misika. Ma roto mbeek mbele las or uwak kavak nawa ambu sir. Uwa osik mbeek a mbashinak hakwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Men a wokoroho na mbashinak ikwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Karem or mbarik ma amber mainlaka lakak jihi limu mbara, �Jisasin mandingormeka. Uhu Barabasin halashinak or talaka.� ");
INSERT INTO sim_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas oto gavman nga Jerusalemik li sihi anantlehe awun undari ma lar oria. Uhu man or jimandingormerik krawuk li oweri ri. ");
INSERT INTO sim_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Urik Pailat mu lirin indiyok sawera, �Jisas avak a halashinak ikwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hako mainlaka lakak li jihi limu mbara, �Oton miandok tirika. Uhu orin mandingormeka.� ");
INSERT INTO sim_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Urik Pailat indiyok ormu silira, �Mberem ushiwak? Mbele mende os or uwak kavak nawak ji heyew? An mbeek os or uwak kavak nawa las a heyewa ambu nir. Uwa osik a mbanak men sembe hakwa ambu ri. Men a wokoroho na halashinak ikwa ri.� ");
INSERT INTO sim_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hako ma ondo Pailat Jisasin miandok or tirikmbaha li ukmisihi Pailathi mashin li misikurik nari ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Urik Pailat os li mbari hom or ukurik ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Karem mbaha Barabas or awun uhu man mandingormerik krawuk li owendari oton or halashirik ormu ira. Ushihi os li mbari nombo hom Jisasin awun undari mahi tavak ormu hara. ");
INSERT INTO sim_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Awun undari ma ondo Jisasin li laha ihi ma lar nombok limu heyera. Ma oto Jerusalemik or ikmbaha tari ria. Hi orhi Saimon, yanga Sairinik fehe ri. Uhu orin li toloho miando oson tavanje orhik li hauoweshirik or kishaha Jisasin or tiyaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Urik ma musha mendek er nga li tiya irik nokove musha olmu ornjik tlaholo ira. ");
INSERT INTO sim_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hako Jisas or tormble heyehe lirin ormu sawera, �Jerusalemik fehe nokove jirin. Jir anjik tlawa hala. Jir nga jikisi jihi nga jihinjik ji hishi ji tlaholoka. ");
INSERT INTO sim_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nomorawu wasilaka avak jihik talakwa osa. Oro wolok jir karem mbakwa jir, �Nokove ol jikisi nga nanda ambu ondo li rupshika. Nokove ol jikisin mukhanda ambu ondo li rupshika.� ");
INSERT INTO sim_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Erem si nawa wolo ma amber avak telemba wasilaka nga awarikanda nga karem mbakwa lir, �Telemba jir, nirin mblikisha arangoshinak ni hawa.� ");
INSERT INTO sim_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","An mi semben heimawa anin os limu ya kavak nanduwa. Erem li uwa osik jir mi hatlan heimawa jirin avak kavak li nakwa jir,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oso wolo kavakavan undari ma lap er nga li mandingormekmbaha li laha iri vri. ");
INSERT INTO sim_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Uhu kuyanga lasik limu ira. Hi sihi telemba masikhavamba, karem li ushandari sira. Li ihi yanga orok lirin miandok limu tirira. Jisasin li tirishihi, lar tapmama orhi yok, lar tava ashi orhi yok, karem limu tirira. ");
INSERT INTO sim_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Urik Jisas mu mbara, �Avui, kavakava lihin laha ermbeka. Lir mbeek yawur hishiwa ambu lir, tos ter anin li uwa roson.� Urik ol awun undari ma ondo kowe orhin li laha satuk limu ormbera, kowe orhi oson li humasi lakmbahan. ");
INSERT INTO sim_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Urik ma amber li tirsa li si heyerik Judama lida lihi olmu Jisasin okole mbara, �Or ma anandin jelyanda ri. Hako os or Krais, Avui Wasilaka kamashindak taha hulaima nokopman jivinakunda mak or na nahi, orhinjik or jelyaka.� ");
INSERT INTO sim_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Awun undari ma ondo pasir li sihi lir er nga orin li okolehe wain uku jeseng andari kas orin hakurik limu ura. ");
INSERT INTO sim_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Uhu limu mbara, �Os mir king Judamahik mi nanda nahi, wa mihinjik jelyaka.� ");
INSERT INTO sim_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Urik miando orok mashi las masiknuku orhik li oweri karem, �King Judamahi toria.� ");
INSERT INTO sim_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Urik ma kava op er nga li tiriri lar Jisasin or okolehe normu mbara, �Mir ma or Avui Wasilaka kamahanda om te. Unda osik mihinjik jelyaha shir nga jelyaka.� ");
INSERT INTO sim_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hako lar mashi oson or misihi ormu orin ngriara, �Mir Avui Wasilakan ajewa ambu om? Mir nga an nga nomorawu os or kishawa hom shimu kishanduwa. ");
INSERT INTO sim_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hako nomorawu oson shi kishawa oso kavakava os shi undanjik os shimu kishanduwa. Os shirin li mandingormewa, lir jivin uwa lir. Hako ma roto, wahau. Or mbeek mbele las or uwak kavak nawa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Uhu normu mbara, �Jisas, os malakamak mi nawa wolo, mir anin hishika.� ");
INSERT INTO sim_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Urik Jisas mu orin sawera, �Omendingak mirin amu sawenduwa. Mir ter an nga hevenik shi likwa mir.� ");
INSERT INTO sim_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ta am komek or sirik kolok er si krinyaha simbalesik misambin er simu tangna arangora. Er si naha ihi homi avi li mbandari wolok si narik indik simu harara. ");
INSERT INTO sim_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Hako si hara namber, kowarmba os tempel akak li fengfakashirik wahandari oso nindi nindi hom er simu frehe larakara. ");
INSERT INTO sim_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Urik Jisas ormu Avui orhin ushara, �Avui, masikome anhi os mihi tavak amu halanduwa.� Karem or mbaha er ormu hara. ");
INSERT INTO sim_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Urik ma or maifuhu awun undari ma oto oson or heyehe hi Avui Wasilakahin or hauowehe normu mbara, �Omendinga sira. Ma roto ma worna ma toria. Or mbeek musa las nga nawa ambu ria.� ");
INSERT INTO sim_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Urik ma amber ol orok talandirsari ondo os Jisasik nari oson li heyehe limu tlaholoho indiyok yanga lihik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hako Jisas ma orhi ondo nga nokove ol orin tiyaha provins Galilin halaha rari ondo nga homek li sihi os orhik talarin limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Judama lar yanga orok lindari ri. Hi orhi Josep. Kuyanga Arimateak fehe ri. Or ma jivi ma worna ma ri. Uhu Judama lida lihi lar oria. Hako or mbeek lida ome lal Jisasin li mandingormekurik li mbari hom mbari ambu ri. Or Avui Wasilaka orhi man or arangoshinak li likwan nikishindari ria. ");
INSERT INTO sim_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Undari osik Jisashi maninimban or mbashinak or laha ikmbaha Pailathik ormu ira. Or i silirik ");
INSERT INTO sim_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailat or mbashirik Jisashi maninimba os miandok warin ormu lafakara. Uhu kouavisha lasik or hevehe mawak or ewekurik ormu laha ira. Sunja aka las li tlohondari mawa oso mbeek ma lar li ewe namber. ");
INSERT INTO sim_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Fraide homirik Jisasin ormu wakor owera. Oso wolo Sabatik si na namber, Judama mbele mbelen li hundujendari wolo sir. ");
INSERT INTO sim_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nokove ol Galilin halaha Jisas nga tari ondo Josepin li tiya ihi mawa os Jisasin or oweri mishin limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Uhu li heyeshihi indiyok aka lihik li ihi mbele mbele ol arme kuvasahandari nga wel uku ondo nga limu hundujera. Hako Sabat wolok si nashirik lo os si mbandari hom limu halashi wandara. ");
INSERT INTO sim_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Am Sande nursumbuk si narik nakove ondo mbele mbele arme kuvasahandari ol li hundujeri ondon li laha mawak limu ira. ");
INSERT INTO sim_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Uhu li i heyeri sunja os mawan li arangondari mbeek orok wari ambu sir, wahau. Angop li tembe haieweri sir. ");
INSERT INTO sim_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hako li layi li heyeri maninimba Jisashi mbeek orok wari ambu sir. ");
INSERT INTO sim_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ushirik wavu musha mushak limu hishira, �Maninimba orhi mbeek wandasa?� Uhu li heyeri ma frijip kouavisha kulurvlarin fri falehe opmu orok sira. ");
INSERT INTO sim_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Urik li aje mendehe li maruknyaha misambik limu rakara. Hako ma frijip ovro lirin frimu sawera, �Mberem ushiwak ma or liyawan ma ol hahandan li wakor owenda mishik ji lasakmba randu? ");
INSERT INTO sim_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Angop usahawa ri, mbeek torok wawa ambu ri. Jir avak mashi os mas Galilik or lihi nor sawehenda mashin indik ji hishika. ");
INSERT INTO sim_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jirin karem saweri ri, �Ma Jikisi Avui Wasilakahi oto ma kavahi tavak li hashinak miandok li tirikwa ri. Hako wak or waha niri frijip fri ishinak avak indik usahakwa ri,� karem mbari ora.� ");
INSERT INTO sim_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Karem fri mbarik mashi os Jisas sawendarin indik limu hishira. ");
INSERT INTO sim_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Uhu mawan li halaha indiyok limu ira. Li ihi ma 11-pela Jisasin tiyandari ondo nga ma anandi ondo nga mbele mbele os orok li heyerin limu sawerakora. ");
INSERT INTO sim_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nokove ondo Maria Makdalak fehenda nga Joana nga Maria Jemshi nijava nga nokove ome lal er nga, karem nari lir. Lir mbele mbele ol mawak li heyerin aposel ondon limu sawera. ");
INSERT INTO sim_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hako lir mbeek mashi lihin misiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hako Pita or usaha mawak ormu shirinya ihi mawan ormu wantloko malera. Uhu nor heyeri kowe ol orin li hevehe eweri nom olmu orok wara. Urik or lishnyafaha wavu musha mushak or hishihi indik akak ormu ira. ");
INSERT INTO sim_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Os nokove ondo mawak li iri wolo Jisasin tiyandari ma frijip yanga Emeus os Jerusalem nga kandakar nga homek nandari mishi orok ikurik frimu ira. ");
INSERT INTO sim_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Fri ihi mbele mbele ol orok talarin nombok frimu anasawe ira. ");
INSERT INTO sim_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Fri anasili anasawe irik Jisas frihi nindik or talaha frir nga nakrem limu ira. ");
INSERT INTO sim_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hako frir mbeek, or Jisas, karem hishiri ambu vri. ");
INSERT INTO sim_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Urik ormu fririn silira, �Mbele shi mba indu?� Karem or mbarik fumunyava frihi nga holondari mende hom frimu heye sira. ");
INSERT INTO sim_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hako frihi lar Kliopas ormu mbara, �Ayo, mir mbele mbele tos ter Jerusalemik talawan heyewa ambu om?� ");
INSERT INTO sim_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Karem mbarik Jisas fririn ormu silira, �Mbele kas orok talawan?� Urik frimu orin sawera, �Mbele mbele os Jisas Nasaretik fehehik talawan shimu mbanduwa. Or profet lar oria. Lerawu wasilakan or laha mashi Avui Wasilakahin kormbak misokome Avui Wasilakahi nga hulaima nokopmahi misokomek sawendari ri. ");
INSERT INTO sim_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Urik bikpris nga lida nihi nga Romik fehe malakamahi tavak orin li harik or mbashirik orin miandok li tirishirik ormu hara. ");
INSERT INTO sim_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mas karem ni hishiri ora. Jisas orto Avui Wasilaka kamashihindak ma Israelik fehen jivinakmbaha tari ma ri, karem ni hishiri ora. Hako angop li mandingormeshirik hari ri. Uhunda ter niri nalmingrip olmu induwa. ");
INSERT INTO sim_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hako nokove lal nursumbu mendek mawak li ihi mbele mbele os orok li heyewan li mbawak ni misihi wavu musha mushak nimu hishinduwa. ");
INSERT INTO sim_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Li ihi li heyewa maninimba orhi mbeek orok wawa ambu sir. Hako ensel ome frijip orok fri sihindak fri sawewak li misiraha li sawewa karem, �Or angop indik usahawa ri.� ");
INSERT INTO sim_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Uwak nihi ma lal mawak li ihi li heyewa mbele mbele os nokove ondo li mbawa hom er nawa sir. Hako orin li heye namber.� ");
INSERT INTO sim_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Urik Jisas fririn ormu sawera, �Shir yarinda ambu shir. Mashi os profet mas li sawendari oson hishanda osh? ");
INSERT INTO sim_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Avui Wasilaka kamashinak hulaima nokopman jivinakwa ma oto nomorawu lakan or kishanakop, Avui Wasilaka or mbashinak malakamak nakwa ria.� ");
INSERT INTO sim_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Karem or mbaha mashi Moseshi nga profet ondo li mbahandari mashi amber nga orok orin mbahandari mashi maintontlo sihin fririn ormu owesawera. ");
INSERT INTO sim_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Am li ihi kuyanga os fri ikurik fri iri mishik pasir limu nara. Hako Jisas kar nga nor ikmba uri ri. ");
INSERT INTO sim_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Urik fri mba toloho frimu mbara, �Mir avak shir nga lika. Ta am or layiwak krinyakwak naw.� Karem fri mbaha frir nga akak nakrem limu layira. ");
INSERT INTO sim_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Uhu am li akurik Jisas bret las or laha or toltavaha Avui Wasilakan armek or sawehe normu fririn hara. ");
INSERT INTO sim_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Erem or urik orin frimu heyekrahakorora. Urik kolok er or wanyishirik mbeek indiyok fri heyeri ambu ri. ");
INSERT INTO sim_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Urik frihi ambek frimu mbara, �Omendinga sira. Os nombok ni rawa wolo maintontlo os jekamba Avui Wasilakahik nandan or sawewak wavu shihi er usawa sir.� ");
INSERT INTO sim_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Karem fri mbaha kolomalok fri usaha indik Jerusalemik frimu ira. Fri ihi fri heyeri aposel 11-pela ondo nga Jisasin tiyandari ma anandi lal nga nakrem orokop limu tirsa lira. ");
INSERT INTO sim_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Uhu fririn limu sawera, �Omendinga sira. Wasilaka angop usahawa ri. Uwak Saimon angop or heyewa ri.� ");
INSERT INTO sim_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Urik frir nga mbele mbele ol nombok talari ondon fri sawe frimu mbara, �Os bretin or toltavawa wolokop, kormbak orin shimu heyekrahakorowa.� ");
INSERT INTO sim_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jisasin tiyandari ma ondo li lihi li maimbari nindik Jisas tumsar or talasihi ormu mbara, �Waphimbiji anhi osmu jihik nanduwa.� ");
INSERT INTO sim_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Karem or mbarik lir mangamba lar li heyer, karem mbaha li lishnyafaha limu ajera. ");
INSERT INTO sim_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Urik ormu sawera, �Mberem ushiwak ji lishnyafaha wavu musha mushak ji hishindu? ");
INSERT INTO sim_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kumba tava anhin ji heye. An mu talanduwa. Maome anhin ji tolo heyeka. Mangamba mbeek maome nga hava nga nanda ambu lir. Hako an maome nga os a naha siwak jimu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Karem or mbaha kumba tava orhin lirin ormu mukura. ");
INSERT INTO sim_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Urik limu rupshi mendera. Hako wavu lihi mbeek namtaskop hishiri ambu lir. Urik ormu mbara, �Jir akwa lal nga nawa oj?� ");
INSERT INTO sim_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Urik foome lar li suwurin limu hara. ");
INSERT INTO sim_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Urik or laha nor arik limu heyera. ");
INSERT INTO sim_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Uhu lirin ormu mbara, �Os jir nga na liri wolo angop karem a saweri jir. Mbele mbele os maskop jekamba Moseshi nga profethi nga Buk Songik anin li kayehendari ondo omek talakwa lira.� ");
INSERT INTO sim_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Uhu maintontlo os Avui Wasilakahi jekambak nandarin armek li hishikmbaha ");
INSERT INTO sim_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","lirin ormu sawera, �Mashi Avui Wasilakahi karem mbahandari osa. Ma or Avui Wasilaka kamashinak hulaima nokopman jivinakwa ma oto nomorawun kishakwa ri. Uhu niri frijip fri ishinak mawan or halaha indiyok usahakwa ri. ");
INSERT INTO sim_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mashi oson mas Jerusalemik sishihi yanga yanga amber hom li laha sawe ikwa lir. Unak hulaima nokopma kavakava ol li undan li halaha sunguwavu lihin li tormblenak Avui Wasilaka kavakava lihin or laha ermbekwa lir. Avui Wasilakahi mashi karem mbahandari sir. ");
INSERT INTO sim_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hako jir mbele mbele ol talarik ji heyenda ondon ji sawe ika. ");
INSERT INTO sim_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ji misi. Masikome Avui Wasilakahi jirin or hakmbaha nor mbahanda oton avak a halashinak jihik takwa ri. Avak torok er ji lihindanak Avui Wasilaka kwambu orhin ji laha jivai ika.� ");
INSERT INTO sim_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Karem or mbashihi orin tiyandari man or laha yanga Betanik limu ira. Am Betanik li ihi tavan or lalawuhu Avui Wasilaka lirin armek or ukmbaha ormu sawera. ");
INSERT INTO sim_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Karem or sawerakoshihi hevenik ormu lawura. ");
INSERT INTO sim_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Urik kumbambongon li huvuhu orin li lotu uhu li rupkapshihi indiyok Jerusalemik limu ira. ");
INSERT INTO sim_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Uhu ermba ermbak tempel akak li lihi hi Avui Wasilakahin limu hauowera. Unda kasira. Ambehoma. ");
INSERT INTO sim_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mas araje wolo mbele mbele li tala namber Mashi oso angop nari sir. Avui Wasilaka nga nari sir. Mashi oso God oria. ");
INSERT INTO sim_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mas araje wolo mendek Avui Wasilaka nga nakrem nari vri. ");
INSERT INTO sim_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mbele mbele ondo amber Avui Wasilaka Mashi orokop or mbarik talari lir. Mbele las mbeek nombo apshamhik talari ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Os ni li yanda nihi Mashi orokop talari sir. Uhu Mashi oso mu ukruharandan hashiwak nimu liyanduwa. ");
INSERT INTO sim_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ukruharanda oso nirtle nirndum nanda mishi orok ukruharanda sir. Hako nirtle nirndum nanda oso mbeek ukruharanda oson jiusunguandahi ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ukruharanda oso si tala namber Avui Wasilaka ma lar, hi orhi Jon, or mbashirik talari ri. ");
INSERT INTO sim_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ukruharanda mashi oson sawekurik talari ria. Ushinak ma misambik fehe mashi oson sunguwavu lihik li ewekmbahan. ");
INSERT INTO sim_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hako ukruharanda oso or nembes. Men ukruharanda mashi oson sauhambakurik tari ria. ");
INSERT INTO sim_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ukruharanda indinga os nombo Avui Wasilakahik indan mukunda oson laharakwa ma oto am or talakurik pasir si narik masmas mashi orhin sauhambakurik tari ria. ");
INSERT INTO sim_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ushirik ukruharanda indinga misambik tari ri. Orhik Avui Wasilaka mas araje wolo mbele mbele amber ondon or uri lir. Hako ma misambik fehe mbeek orin heyekrahakorori ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Or orhi kraha lihi nindik tari ri. Hako orhi ma ondo mbeek orin heyembaha mashi orhin misiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hako ma ol mashi orhin misindiyari ondo or mbarik Avui Wasilakahi jikisik nari lir. ");
INSERT INTO sim_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lir mbeek ma misambik fehe jikisin li lakwak li hishihi li landari nombo orok orhi jikisik nari ambu lir. Avoko nijavahi fik nembes. Avui Wasilaka orhinjik or yap mbashirik orhi jikisik nari lir. ");
INSERT INTO sim_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mashi oso mak nari sir. Uhu or taha nir ma misambik fehe nihi nindik liri ri. Or jikisi namtar numbu Avui Wasilakahi ria. Kwambu orhi os Avui Wasilaka orin or hari oson angop ni heyeri sir. Avui Wasilaka man or rupshihi wavu orhik or ewenda nga mainome orhi nga Jisashikop hojeri sir. ");
INSERT INTO sim_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon Jisasin or mukuhu ormu mbara, �Ma oto toria. Maskop karem a sawerik ji misiri sir, ma or an tashinak takwa ma oto Wasilaka anhi ria. An na namber or angop mas araje wolokop nahandari ria. Ma or karem a mbahandari ma oto toria.� Karem ormu sawehe mukura. ");
INSERT INTO sim_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Avui Wasilaka lo orhin Moseshi tavak or hashirik or nga nirin hari ria. Hako man or rupshihi wavu orhik or ewenda oso nga mainome orhi nga Jisas Kraishi tavak or hashirik or nga mu nirin hara. Man rupshinda nombo oso Jisashikop hojenda sir. Oso mbeek mendek naha kas sainakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma lar mbeek Avui Wasilakan heyenda ambu ri, wahau. Hako jikisi orhi namtar numbu orto nom Avui orhi nga nakrem lindari ri. Undari osik orvai Avui Wasilaka os or nandarin nirin mukuri ri. ");
INSERT INTO sim_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judama li mbashirik pris lal nga Livaihi krahak fehenda ma lal nga Jerusalemin li halaha Jonik li raha orin limu silira, �Mir lawe mir?� ");
INSERT INTO sim_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Urik Jon kormbak ormu sawera, �An mbeek ma or hulaima nokopman jivinakmbaha Avui Wasilaka kamahanda ma ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Karem or mbarik limu silira, �Wa, lawe mir? Mir Elaija om?� Urik ormu mbara, �Wahau.� Urik limu mbara, �Wa, mir profet or ni nikishinda om?� Urik ormu mbara, �Wahau.� ");
INSERT INTO sim_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Urik limu mbara, �Lawe mende mir? Mihinjik mi mbanak ni misika! Uhu indiyok ni ihi ma ol nirin mbashiwak ni rawa ondon avak ni sawenak li misika.� ");
INSERT INTO sim_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Urik Jon mashi os maskop profet Aisaia or sawendari hom ormu mbara, �Ma ngashi mishi ambu orok mashi las karem simu mbara, �Nombo Wasilakahin ji hundujeka.� Karem mbahanda mashi oso anira,� ");
INSERT INTO sim_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Urik Farisi ol er nga rari ondo ");
INSERT INTO sim_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jonin limu silira, �Os mir mba, mir Avui Wasilaka kamashinak hulaima nokopman jivinakwa ma ambu mir. Mir Elaija ambu mir. Mir profet or ni nikishinda ambu mir, os erem mi mba nahi, wa mberem ushiwak hulaima nokopman fak mi tolofalendu?� ");
INSERT INTO sim_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Karem li silirik ormu sawera, �An men uksembembak a tolofalenda nir. Hako ma lar angop jihi nindik tari ria. Hako jir mbeek orin heyekrahakorori ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","An mas a rashirikop or kuma tari ri. An ma jivi ambu nir. Unda osik an mbeek kuvu os kumba ari orhi orok nawan a sorgondahi ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon mashi kason or mbari wolo yanga Betanik fa Jordanin mbuhu kauyok nandari orok or lihi man ormu fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Li wahandashihi Jisas Jonik or tarik or heyehe ormu mbara, �Ji heyeka! Ma toto Avui Wasilaka sipsip jikisi orhi toria. Or ma misambik fehenda kavakava os li undan yoko ermbekwa ma ria. ");
INSERT INTO sim_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ma kar mas a sawerik ji misihinda ma toria. Mas karem a mbari nir, ma lar avak anhi kumayok rakwa ri. Or Wasilaka anhi ri. Or angop maskop nahandari ri. Hako an kuma na nari nir. ");
INSERT INTO sim_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","An ngana mas mbeek orin yawur a heyekrahakorori ambu nir. Hako yanga Israelik fehenda ma orin kormbak li heyekmbaha men fambak man a tolofalekurik a tari nir.� ");
INSERT INTO sim_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Uhu ormu mbara, �Avui Wasilaka man fak tolofalenda lerawu oson anin or haha karem anin saweri ria, �Kumak mi heyenak Masikome anhi ma larik or linak mi heyewa, ambehoma, ma oto Masikome anhin hulaima nokopman hakwa ma ria.� Karem anin saweri ri. Hako an ngana ma oton mas a heyeri ambu nir. Hako hinyer mendek a heyerik Masikome Avui Wasilakahi hevenin or halaha apmuma hom Jisasik ormu raka lira. ");
INSERT INTO sim_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ushirik am a heyehe os amu jirin kormbak sawenduwa. Ma roto Avui Wasilakahi jikisi indingo toria.� ");
INSERT INTO sim_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Li wahandashihi Jon nga orin tiyandari ma frijip ovro nga nakrem limu sira. ");
INSERT INTO sim_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Li sihi li heyerik Jisas ormu tara. Urik Jon ormu mbara, �Ji heyeka, Avui Wasilaka sipsip jikisi orhi toria.� ");
INSERT INTO sim_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Karem or mbarik ma ovro mashi oson fri misihi Jisasik fri ihi orin frimu tiya ira. ");
INSERT INTO sim_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Urik or tormblehe or heyerik fri rarik ormu silira, �Shir mberem shi hishihi shi randu?� Urik frimu mbara, �Tisa, mbeek mi lindu?� ");
INSERT INTO sim_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Urik ormu mbara, �Shi ra heyeka.� Urik fri ihi aka os or lindarin frimu heyera. Uhu or nga orok nakrem fri lirik simu krinyara. Os orok fri iri wolo homi avi li mbandari wolok nari sir. ");
INSERT INTO sim_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon or saweri mashin misihi Jisasin tiya iri ma ovro lar Andru, Saimon Pita maha orhi ria. ");
INSERT INTO sim_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Uhu Jisasin or halashihi sanje orhi Saimonin ormu lasaha ira. Am or i heyehe ormu mbara, �Shir angop ma or Avui Wasilaka kamashirik hulaima nokopman jivinakwa ma Mesaia oton shi heyewa shir.� ");
INSERT INTO sim_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Karem or mbaha Saimonin or laha Jisasik frimu ira. Urik Jisas orin or heyehe ormu mbara, �Mir Saimon jikisi Jonhi mira. Kumak hi yeje mihi Sifas karem li ushakwa mir.� Hi Pita nga Sifas nga mainome frihi sunja, karem namtaskop nanda sir. ");
INSERT INTO sim_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Niri las am si irik Jisas yanga Galilik or ikurik ormu ira. Or ihi ma lar, hi orhi Filip, orin or heyehe ormu mbara, �Mir anin tiyaka!� ");
INSERT INTO sim_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip yanga Betsaidak fehendari ma ria. Betsaida kotontlo Andru fre Pitahi sira. ");
INSERT INTO sim_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Urik Filip or ihi ma lar, hi orhi Nataniel, oton or heyehe ormu mbara, �Nir ma or mas Moses nga profet ondo nga li mbahandari ma oton ni heyewa nir. Hi orhi Jisas oria. Kuyanga Nasaretik fehenda ria, Josephi jikisi ria.� ");
INSERT INTO sim_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Karem or mbarik Nataniel ormu mbara, �Wahau te. Mbele jivi las mbeek yanga orok talandahi ambu sir.� Urik ormu mbara, �Ta shi ihi mihinjik mivai heyeka.� ");
INSERT INTO sim_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Uhu fri irik Jisas Natanielin or heyehe ormu mbara, �Ji heyeka, ma tor tawa toto Israelik fehenda ma indinga toria. Or mbeek haimba handambanda mashin mbanda ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Karem or mbarik ormu silira, �Mir anin mberem mi heyew?� Urik ormu mbara, �Os Filip mirin or sawe namber mir mi fik tontlok mi siwak amu heyewa.� ");
INSERT INTO sim_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Urik ormu mbara, �Tisa, mir jikisi Avui Wasilakahi mira. Mir yanga Israelik fehe ma malakama lihi mira.� ");
INSERT INTO sim_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Urik ormu mbara, �Os mir mi tontlo orok mi siwak a heyewan a saweshiwak os mi hishihi mimu mbanduwa, toto Avui Wasilakahi jikisi toria. Karem mimu mbanduwa. Hako oso mbeek lakak nawa ambu sir. Kumak mbele mbele wasilaka lal a unak tos ter mi heyewa toson tikrikwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Uhu mashi las nga ormu mbara, �Kumak ji heyenak lersuwu akayanga avak sutlakwa sir. Unak ji heyenak Avui Wasilakahi ensel ondo metenjek li laulawuhu takakwa lir, os Ma Jikisi Avui Wasilakahi oto or siwa mishi orok.� ");
INSERT INTO sim_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Niri lap am fri ishirik yanga Kanak ma lar nokoplarik hiyawu las limu ura. Urik Jisas nijava orhi Maria er nga orok simu ira. ");
INSERT INTO sim_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Urik Jisas nga ol orin tiyandari ma nga li mainhashirik limu ira. ");
INSERT INTO sim_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Am li lihi aha wain uku am mendek si narik Jisas nijava orhi si taha orin simu sawera, �Wain uku angop mendek nawa re.� ");
INSERT INTO sim_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Karem si mbarik ormu mbara, �Apmanuwa, anin sawewa hala. Lerawun a lakwa wolok nawa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Karem or mbarik ol aka orok lerawun landari ma ondon simu sawera, �Os mbele las ji ukmbaha nor mba nahi, os or mbawa hom ji uka.� ");
INSERT INTO sim_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Urik sunja awu wasilaka 6-pelak aka orok lindari lir. Uku os awu ondok li tarmuri oso Avui Wasilakahi misokomek jivik li nakmbaha kumba tava lihin li yokokmbaha li eweshirik lindari lir. Awu ondo namtarmba namtarmbak uku si hojeri 100 litak nari lira. ");
INSERT INTO sim_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Urik Jisas lerawun landari ma ondon ormu sawera, �Uksemben awu ondok ji tarmungoroka.� Karem or mbarik ukun li tarmuhu li laharaha li ngororik awu ondo er limu hojerakora. ");
INSERT INTO sim_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Urik ormu sawera, �Uku kas ji tarmu laha ihi ma or akwan humasiri ma oton ji haka.� Urik uku kas li tarmuhu limu laha ira. ");
INSERT INTO sim_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hako uku oso angop si tormblehe wain ukuk nari sir. Urik ma or akwan humasiri ma oto ormu aheyera. Or mbeek os li tarmuri mishin heyeri ambu ri. Lerawun landari ma ondo nom os li lari mishin heyeri lir. ");
INSERT INTO sim_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Urik akwan humasiri ma oto nokoplari ma oton or usharik or tarik ormu mbara, �Mberemhi tos ter mi uwa! Wain uku jivi menden mi nejereshihi terekare awan mas mi hawa. Nir mbeek erem ni unda ambu nir. Wain uku jivi menden masmas ni handa nir.� ");
INSERT INTO sim_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas mbele las ma undahi ambu maifu mendek yanga Kana provins Galilik or uri kasira. Maintontlo os or uri karem. Or hiushama kwambu nga nanda ria. Oson or urik ol orin tiyandari ma ondo li heyehe limu mbara, �Ma toto kwambu ngashi ria.� ");
INSERT INTO sim_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Urik Jisas yanga Kana oson or halaha nijava orhi nga maha orhi nga ol orin tiyayandari ma nga yanga Kaperneamik limu layira. Uhu niri lal orok limu lira. ");
INSERT INTO sim_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judama hiyawu wasilaka Pasovan li undari wolo am si nakurik si narik Jisas Jerusalemik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Or ihi tempel aka inyi li washi aragondari mishi orok or layihi nor heyerik, ol ya nowen landari ma ondo orok lerawun limu lara. Lal sipsip, bulmakau, avi ondon li eweshinak ma li frungawukmbahan. Urik lal samba sambahi yan li lai hashihi Judamahi yan li lakmbahan. Uhu orok limu lira. ");
INSERT INTO sim_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Urik Jisas lirin or heyehe kuvu lal or laha ma ol orok liri ondo nga bulmakau, avi ondo nga or wakororik tempel aka oson li halaha limu talandulu ira. Uhu ya ondon or kru ermbehe teye ondo er nga ormu jilaruma laha ermbera. ");
INSERT INTO sim_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Uhu ol avi ondon lai ewerik li frungawuri ma ondon ormu mbara, �Avi jihi ondon ji laha ika! Jir Avui anhi aka toson ji uwak maket hom osmu nanduwa!� ");
INSERT INTO sim_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Karem urik ol orin tiyandari ma mashi las os Avui Wasilakahi jekambak maskop li kayehendarin indik limu hishira. Mashi oso karem, �An Avui anhi aka orhin a rupshi mendehe osonjik a funtlehavantlehe lerawun a landa nira.� ");
INSERT INTO sim_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judama ondo os or urin li heyehe orin limu silira, �Mberem ushiwak mbele mbele ondon mi laha ermbendu? Os Avui Wasilaka lerawu oson mi lajehe or mbashirik mi rakahanda nahi, kolok mbele las ma undahi ambun mbanak si nanak ni heyehe nivai mba, Avui Wasilaka mbashirik tari ma toria.� ");
INSERT INTO sim_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Karem li mbarik ormu mbara, �Tempel aka toson ji tarvlashinak niri frijip fri ishinak indik a ukwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Urik limu mbara, �Isha, tempel aka toso mbeek lewas li uri ambu sir te! Asama sihi li uri 46-pelak nari ol te! Hako mberem niri frijip fri ishinak indik toson mi ukwak mi mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hako Jisas tempel aka os or mbari oso maome orhin or mbari sir. ");
INSERT INTO sim_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Undari osik Jisas indik or usahari wolo orok ol orin tiyandari ma ondo mashi os erem or mbarin indiyok li hishihi limu mbara, �Ome sira, mbele mbele ol profet ondo li mbari Jisasin li mbari sira.� Karem li mbaha orin wavu lihik limu ewera. Uhu mashi os Avui Wasilakahi jekambak li kayehendari oso er nga li hishihi limu tiyara. ");
INSERT INTO sim_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas Pasova wolok Jerusalemik or lihi mbele mbele ol ma undahi ambu ondon or urik ma li heyehe limu mbara, �Ma roto Avui Wasilaka kamahanda ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Hako Jisas mashi os li mbari oson angop or heyeri sir. Or mbele mbele os mahi sunguwavuk nandan angop or heitakonda lir. Karem uri osik os orin wavu lihik li ewehe li mbari oson misiri ambu ri. Angop or heyeri lir, lir men suwambushikop mbari lir. ");
INSERT INTO sim_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma lar Jisasin heyekurik ormu tara, hi orhi Nikodemus, or Farisi lar oria. Judama lida lihi lar oria. ");
INSERT INTO sim_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nirik or taha ormu sawera, �Tisa, nir angop ni heyenda sir, os Avui Wasilaka ma lar nga or lina ambu nahi, ma oto mbeek mbele mbele ma undahi ambu lal ukwa ambu ri. Hako nir angop ni heyenda mir, mbele mbele ma undahi ambu ondon unda mira. Karem uwosik nimu mbanduwa, mir tisa Avui Wasilaka mbashirik tari mira.� ");
INSERT INTO sim_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Karem or mbarik Jisas ormu mbara, �Omendingak mirin amu sawenduwa, os ma lar ma akrik or nana ambu nahi, or mbeek yanga os Avui Wasilaka hulaima nokopman or arangoshinak orhi siyok li sikwa yanga orok ikwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Urik ormu silira, �Mberemhi sir? Os nijava jikisin si washihindak wasilakak or nawa mbeek indiyok nijava orhi sunguk layinak indik si wakwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Karem or mbarik ormu mbara, �An mbeek nijavahi sunguk mi layinak indik si wakwa mashin a mbawa ambu nir. Mashi os a mbawa karem, os ma lar uku nga Masikome Avui Wasilakahi nga ma akrik or nana ambu nahi, or mbeek Avui Wasilaka yanga orhi orok ikwa ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ma misambik fehe jikisin li wawa ma jikisik nakwa lir. Hako ma ol Avui Wasilakahi jikisik nakwa ondo Masikome orhi unda nombo orok orhi jikisik nakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mashi kas mirin a sawewa, jir avak ma akrik ji naka, karem a mbawa mashin angop mi misindahik nanda mir. ");
INSERT INTO sim_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Suwa si rasaha sihik inda sir. Nir men mamblakop ni misinda sir. Hako nir mbeek os si rasawa yeje nga os si inda yeje nga ni heyenda ambu sir. Uhunda hom ma ol Masikome Avui Wasilakahi uwak akrik nawa ma ondo erem nanda lir.� ");
INSERT INTO sim_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Urik Nikodemus mu silira, �Os mi mbawa oso mberem sivai naku?� ");
INSERT INTO sim_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Urik ormu mbara, �Mir ma Israelik fehenda lihi tisa mira. Hako mberem ushiwak mashi ol a mbawan mi hishaha mi mbandu? ");
INSERT INTO sim_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Omendingak mirin amu sawenduwa, mbele mbele os ni heyenda nga os ni misinda nga nimu sawenduwa. Hako jir mbeek mashi os ni mbawan misinda ambu jir. Mashi oson ji kumasinda sir. ");
INSERT INTO sim_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mbele mbele misambik fehendan jirin na sawewa mbeek misinda ambu jir. Undosik erema, mbele mbele hevenik fehendan na sawewa mbeek misinda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma lar mbeek hevenik lawunda ambu ri, wahau. Ma Jikisi Avui Wasilakahi oto nom orok or rakahanda osik indik orok ikwa ri. ");
INSERT INTO sim_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mas wolok Moses kuyanga misamtelmbamba orok liri wolo hovo oson kombe lasik or hauowehe or faashirik orok simu sira. Uhunda hom Ma Jikisi Avui Wasilakahi oton avak erem li hauowekwa ria. ");
INSERT INTO sim_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Erem li unda osik ma ol mashi orhin misindiyawa ma ondo avak ermba ermbak linda oson lakwa lir.� ");
INSERT INTO sim_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","�Avui Wasilaka jikisi orhi namtar numbu ria. Hako ma misambik fehendan wapnuku orhik or ewendari osik jikisi orhi oton or mbashirik ma ondon jivinakurik takari ri. Uhunda osik ma ol orin wavu lihik ewewa ma lihi lar mbeek kavak nakwa ambu ri, wahau, ermba ermbak lindan lakwa ri. ");
INSERT INTO sim_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Avui Wasilaka jikisi orhin or mbashirik misambi torok tari ria. Hako or mbeek man kotim ukurik tari ambu ri, wahau. Or kavak li nakurin jivinakurik tari ri. ");
INSERT INTO sim_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Karem uwosik ma ol mashi orhin misindiyawa ma ondo kotik li siwa wolo mbeek kavak or nakwa ambu lir. Hako ma ol mashi orhin misindiyawa ambu ondo angop krestawa lir. Mberem ushiwak? Lir mbeek Avui Wasilaka jikisi orhi otohi mashin misindiyari ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mberem ushinak li krestaku? Ukruharanda angop misambik takari ri. Hako lir mbeek orin rupshiri ambu lir. Lir kavakava os li unda oso nom li rupshihi mbeek orhik tari ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ma ol kavakavan unda ondo ukruharandan rupshinda ambu lir. Os ukruharanda orok li ta nahi, mbele kava os li wanyi unda avak kormbak talakwa sir. Karem uri osik lir mbeek ukruharandan rupshinda ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hako ma ol nombo worna indingan tiyanda ma ondo ukruharanda orok takwa lir. Mberem ushiwak? Li heyewa, mbele mbele ol li unda ondo Avui Wasilaka or mbanda nombo hom unda lir.� ");
INSERT INTO sim_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Uhundarik Jisas ma ol orin tiyandari nga yanga oson li halaha provins Judiak limu ira. Uhu niri lal orok li lihi man ormu fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Oro wolok Jon er nga yanga Ainonik or lihi man tolofaleri ria. Ainon oso pasir yanga Salimik nanda sira. Fa musha orok nandari osik ma orok li tarik lirin fak ormu tolofalera. ");
INSERT INTO sim_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Oso wolo Herot mbeek Jonin krawuk or eweri wolok nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Urik Jonin tiyandari ma nga Judama lar nga ujanda nombo os Avui Wasilakahi misokomek jivik li nakurik nombo osonjik limu anamblarnara. ");
INSERT INTO sim_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Urik ol Jonin tiyandari ma ondo Jonik li raha limu sawera, �Tisa, ayo ma or mas mir nga fa mbuhu kauyok nakrem shi sihi ma or mi mbar, ma toto hulaima nokopman jivinakwa ma toria. Karem mi mbahanda ma oto or er nga hulaima nokopman fak or tolofalewak ma amber orhik li ihi olmu nirin halanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Karem li mbarik Jon mu mbara, �Os Avui Wasilaka or hevenik linda kwambun ma larin or hana ambu nahi, ma oto mbeek lerawu las landahi ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mashi os mas a saweri angop ji misiri sir. An mbeek Avui Wasilaka kamashirik hulaima nokopman jivinakwa ma ambu nir. An men nombo orhin hundujekmbaha a rari nir. ");
INSERT INTO sim_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Misi, an ma or orhi kuvu nokoplawak or misihi or rupshinda hom amu nanduwa. Mbele mbele Jisas or uwan a misihi amu rupshi mendenduwa. ");
INSERT INTO sim_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Halanak hi orhi si lawunak hi anhi si rakaka. ");
INSERT INTO sim_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Or hevenik fehe orik mbele mbele misambik fehen tikrihi hausinda ri. An misambik fehe onik mbele mbele misambik fehenda nom a heyenda nir. Hako or hevenik fehe orik anin or tikrihi hausinda ria. ");
INSERT INTO sim_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Or mashi os or sawewa mbele mbele ol or heyenda nga or misinda nga sawenda ria. Hako ma misambik fehe mbeek mashi orhin misihi toltambananda ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hako ma ol mashi orhin misihi toltambanawa ma ondo angop li heyenda sir, mashi Avui Wasilakahi ome sira. ");
INSERT INTO sim_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Avui Wasilaka Masikome orhin simbalesik orin or hashirik misambik tari ria, mashi orhin or sawekmbahan. Unda osik os nimu heyenduwa, mashi os or sawenda omendinga sira. ");
INSERT INTO sim_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Avui Wasilaka jikisi orhin wapnuku orhik or ewendari osik mbele mbele orhi ondon tavarenje jikisi orhik hari ri. ");
INSERT INTO sim_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Unda osik ma ol jikisi orhi otohi mashin misindiyawa ma ondo ermba ermbak linda oson lakwa lir. Hako ma ol jikisi orhin kumaifahanda ondo mbeek ermba ermbak linda oson lakwa ambu lir, wahau. Avui Wasilaka waplelena orhi ermba ermbak lihik nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi ondo li misiri Jisas man fak or tolofaleshirik ma musha orin tiyandari mak nari lir. Uhu ma musha mendek li naha Jonin tiyandari man tikriri lir. ");
INSERT INTO sim_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Hako Jisas mbeek man fak tolofaleri ambu ri, wahau. Ol orin tiyandari ma ondo nom man fak tolofaleri lira. ");
INSERT INTO sim_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Urik Jisas or misiri, Farisi ondo lerawu os or larin angop li mistakori sir. Karem uri osik provins Judian or halaha indik yanga Galilik or ikmbaha ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Or ihi Samariak fehe ondo misambi lihi nindik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Or ihi yanga Sikarik ormu talara. Sikar oso Samariak fehenda ma ondohi yanga las osira. Misambi os Jekop jikisi orhi Josepin or halahandari mishi oso nga pasir nandari sira. ");
INSERT INTO sim_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Ukwa las Jekop maskop or korondari oso yanga orok nandari sira. Am takondik si narik Jisas or taha nor krehe ukmashi orok ormu limasira. Ol orin tiyandari ma ondo angop akwan li frungawukmbaha li ishirik Jisas nendekop orok liri ria. Urik Samariak fehenda nokove las ukun si tarmukurik orok simu tara. Urik Jisas ormu silira, �Uksembe kas anin hanak a aka.� ");
INSERT INTO sim_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Urik simu mbara, �Mir Judama mir, an Samariak fehe nir. Mberem ushiwak uksemben a hanak mi akmbaha mi mbandu? Jir Judama mbeek nir Samariak fehenda nga nakrem ni anda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Urik ormu mbara, �Nyir mbeek yariwa ambu nyir, lawe or uksembenjik nyirin silindu. Uhu nyir mbeek mbele jivi las os Avui Wasilaka nyirin hakwak or mbawan hishiyariwa ambu nyir. Os nyi yariwakop am nyi mba, �Wa, uksembe ermba ermbak linda oso kas anin hanak a aka.� Karem mbawa nyir.� ");
INSERT INTO sim_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Urik simu mbara, �Wasilaka, uksembe oson mbeyok mi laku? Mir baket nga nawa ambu mir. Ukwa toso kasalkop nanda sir. ");
INSERT INTO sim_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Misumu nihi Jekop maskop or korondari ukwa tosira. Or nga jikisi orhi nga bulmakau, sipsip orhi nga li uksem andari mishi tosira. Hako mir am orin tikrindahik nanda om? Karem mimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Karem si mbarik ormu mbara, �Ma ol uksembe toson awa ondo jekapnashi lihi hatlayinak indik uksem akwak mbakwa ola. ");
INSERT INTO sim_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Hako ma ol uksembe os an hanak akwak a mbawa ma ondo mbeek indik uksem akunak mbakwa ambu lir, wahau. Uksembe os a hawa oso avak sungu lihik ukwa hom si nanak ermba ermbak linda oso avak lihik nakwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Urik simu mbara, �Wasilaka, uksembe oson anin hanak a aka. Uhundanak indik torok ukun a tarmukmbaha a rakwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Urik Jisas mu mbara, �I hula nyihin sawe laha torok shi raka.� ");
INSERT INTO sim_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Urik simu mbara, �An mbeek hula ngashi ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Urik ormu mbara, �Ome sira, nyir hula nyihi tostava hom nandari lir. Hako ma or ter nyi liwa oto mbeek hula nyihi ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Urik simu mbara, �Wasilaka, ter amu heyenduwa. Mir profet lar mira. ");
INSERT INTO sim_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hako anin sawenak a misi, mberem ushiwak jir Judama karem ji mbandu, os ma lal Avui Wasilakan li lotu uku nahi, wa Jerusalemkop li tirsaha li lotu uka, karem ji mbandu? Hako nir Samariak fehenda neloko walanga nihik sishi raha ter nga os Avui Wasilakan ni lotu ukwa wolo telemba Gerisim orokop ni tirsaha ni lotu unda nir. Hako mir mberem mi hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Urik ormu mbara, �Omendingak nyirin amu sawenduwa, kumak os Avui Wasilakan ji lotu ukmbaha ji hishi nahi, yanga yanga os ji liwa mishi orokop orin lotu ukwa jira, telemba orok nembes, Jerusalemik nembes. ");
INSERT INTO sim_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Avui Wasilaka or Masikome ria. Karem uwosik ma ol orin lotu ukmbaha hishiwa ma ondo Masikome orhi nga mbele mbele omekop nanda nga orin omendingak li lotu uka, yanga yanga os li liwa mishi orok. Ma ol or mbawa nombo orok orin lotu uwa ma ondon rupshinda ri. Hako jir Samariak fehenda mbeek ma or ji lotu undan heyenda ambu jir, wahau. Men lotu unda jir. Hako nir Judama God or ni lotu undan angop ni heyenda ri. Angop maskop Avui Wasilaka mashi las nir Judaman karem or mbari osa, �Kumak Judahi krahak fehe ma lar avak a kamashinak hulaima nokopman jivinakwa ria.� Erem or mbahanda mashi ter osmu omendingak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Urik simu mbara, �He, Mesaia, Krais karem li ushanda ma or hulaima nokopman jivinakwa ma oto or takuri mashi oson angop a misiri sir. Os or tawa wolo mbele mbele amber kormbak or sawenak ni mistakokwa lir.� ");
INSERT INTO sim_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Urik Jisas mu mbara, �Ma orto anira. An mu ter nyir nga shimu maimbanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas karem or mbarik ol orin tiyandari ma ondo indik limu rara. Li raha li heyeri Jisas nokove oso nga frimu maimbara. Urik wavu musha mushak limu hishira. Hako lir mbeek sirin siliri ambu lir, �Mbele nyi lakmbaha nyi taw?� Uhu Jisasin er nga siliri ambu lir, �Mberem ushiwak nokove toso nga mi maimbandu?� Karem siliri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Urik nokove oso baket sihin orok si hala tirnaha indik yanga sihik si ihi ma ondon simu sawera, ");
INSERT INTO sim_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","�Jir kolomalok ji raha ma lar ji heyeka! Ma oto mbele mbele maskop a undarin or heyehe kormbak sawewa ri. Ma oto Krais Avui Wasilaka kamahanda marmbe?� ");
INSERT INTO sim_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Karem si sawerik ma amber Jisasin li heyekmbaha limu tara. ");
INSERT INTO sim_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nokove oso si ishirik Jisasin tiyandari ma ondo limu mbara, �Tisa, mir kolok ta akwa lal aka!� ");
INSERT INTO sim_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Urik ormu mbara, �An akwa ngashi nir. Hako jir mbeek akwa anhin heyewa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Karem or mbarik lihi ambek limu mbara, �Mbel akwan or mbandu? Ma lal am akwan orin hawa ol?� ");
INSERT INTO sim_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Urik ormu mbara, �Avui anhi or mbashirik a raha lerawu orhin amu landuwa. Mbele mbele or mbawa hom a landa nir. Lerawu os a lawa oso akwa anhi hom nanda sir. ");
INSERT INTO sim_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jir karem mbanda jir, niyaka tovro kavro li iwak akwan sanda wolok nanda sir. Hako jirin amu sawenduwa, nowe ondon armek ji heyeka! Akwa amber olmu ukrunduwa. ");
INSERT INTO sim_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma or akwan sanda ma oto akwan or saha safal akak or ewehe avak os or lahanda wasa orhin lakwa ri. Akwa os or sanda oso hulaima nokopma wavu lihin tormblehe ermba ermbak linda oson li lakundan osmu heimanduwa. Uwosik ma or kumbanda nga ma or sanda nga fri rupshi mendekwa vria. ");
INSERT INTO sim_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lar or kumbawak, lar ormu sanduwa. Karem nanda sir. ");
INSERT INTO sim_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jir avak a mbashinak ikwa jir, ma anandi kumbanda mishi orok. Jir men sakwa jir. Akwa angop maskop li kumbari sir.� ");
INSERT INTO sim_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariak fehe nokove oso yanga sihik fehendan simu sawera, mbele mbele ol mas si undarin Jisas kormbak or sawerin. Ushirik mashi sihin li misihi limu mbara. �Ome sira, ma oto Avui Wasilaka kamahanda ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Uhu Jisasik li raha or lir nga orok li likmbaha limu mbara. Urik Jisas niri frijip kuyanga orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Urik ma mushak mashi orhin li misihi limu mbara, �Avui Wasilaka kamahanda ma toria.� ");
INSERT INTO sim_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uhu nokove oson limu sawera, �Nir mbeek mashi nyihi nom ni misiwa ambu nir, wahau. Nihinjik mashi os or mbawan am ni heyehe nimu hishinduwa, ma roto nom ma misambik fehendan jivinakwa ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas niri frijip Samariak or wahandarik or usaha kotontlo orhi Galilik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Maskop orhinjik karem or mbari sir, �Profet lar mbeek kotontlo orhik hi nga nanda ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hako yanga orhi Galilik indik or irik orok fehe ma ondo orin li rupshihi limu flehava kwara. Mberem ushirik? Hiyawu Pasovan li undari wolo Jerusalemik mbele lal ma undahi ambu ondon or urik angop li heyeri osik orin limu rupshira. ");
INSERT INTO sim_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Urik Jisas yanga Kanak ormu ira. Yanga oso mas uksemben or urik wain ukuk nari mishi sira. Urik malakamanjik lerawun landari ma lar Jisas yanga Kana orok or tarin or misihi orhik ormu tara. Ma oto jikisi orhi yanga Kaperneamik wasilaka mendek kavamisihi hakurik nari ri. Uri osik Jisashik or taha ormu tlara, �Wasilaka, jikisi anhi am hakwak naw te! Avak yanga Kaperneamik mi taha mi mbanak jivik or nawa.� ");
INSERT INTO sim_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Karem or mbarik ormu mbara, �Os mbele las ma undahi ambun a una ambu nahi, mbeek anin hishiowekwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Karem or mbarik ma oto indik ormu tlara, �Wasilaka, kolok tawa. Nambek mi na nahi, jikisi anhi avak hakwa ri!� ");
INSERT INTO sim_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Karem or mbarik ormu mbara, �Mir ika. Jikisi mihi mbeek hakwa ambu ri.� Karem or mbarik avoko ma oto Jisas mbari mashi oson or misihi ormu hishira, �Mashi os Jisas mbari oso avak omek nakwa sir.� Karem or mbaha indik yanga orhi Kaperneamik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Or ihi nombok or sirik ma ol ornjik lerawun landari ma lal li taha limu sawera, �Awasayi, jikisi mihi hari ambu, angop jivik nari ri.� ");
INSERT INTO sim_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Karem li mbarik ormu mbara, �Mbele wolo mendek jivik or nar?� Urik limu mbara, �Hinyer ta am or andorik jivik ormu nara.� ");
INSERT INTO sim_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Karem li mbarik avoko ma oto ormu hishira, Jisas hinyer oro wolo mendek ormu mbara, �Jikisi mihi hakwa ambu ri.� Karem or hishihi or nga jikisnokopji orhi nga ol ornjik lerawun landa ma ondo nga Jisasin wavu lihik li ewehe orin limu tiyara. ");
INSERT INTO sim_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas os provins Judian or halaha Galilik or tari wolo mbele las ma undahi ambu oson yanga Galilik nindisik or uri kasira. ");
INSERT INTO sim_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Judama hiyawu las li undari wolok si narik Jisas Jerusalemik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem oso inyi nga li washi arangondari sir. Inyi oso akayanga ngashi sir. Akayanga las hi sihi Sipsip akayanga. Leuku laka las pasir akayanga orok nandari sir, hi sihi Betesda. Betesda orok shikor aka tostava yoko hom sindari lir. ");
INSERT INTO sim_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ushirik ma ol kavamisindari, misokome tumundari, kumba havan tlehendari, kumbanashi tavanashindari ondo amber shikor aka orok lindari lir. ");
INSERT INTO sim_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Orok li lihi nikishinak ensel lar or taha leuku orok or layinak uku oso si suwurinak ma or maifuk leuku orok layiwa ma oto jivik or nakmbahan. Karem mbaha orok nikishindari lir. ");
INSERT INTO sim_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Urik ma lar asama 38-pelak kavamisindari lar orok liri ri. ");
INSERT INTO sim_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Urik Jisas or taha or heyerik ma oto ormu orok wara. Jisas angop or heyeri ri, os hoje menden or kavamisihi or wandarin. Uri osik orin ormu silira, �Mir jivik mi nakmbaha mimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Karem or silirik ormu mbara, �Awasayi, os leuku si suwuriwa wolo ma lar mbeek anin laha layi leuku orok ewenda ambu ri. Anhinjik a ikmbaha na uwa, ma ondo olmu anin tikrihi masmas uku orok layiwa.� ");
INSERT INTO sim_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Urik Jisas ormu mbara, �Usaha kawu mihin laha ika!� ");
INSERT INTO sim_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Karem or mbashirik ma oto jivik er or naha kawu orhin or laha ormu ira. Hako oso wolo Sabatik nari sir. ");
INSERT INTO sim_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Urik Judama lal ma oton li heyehe limu mbahanjira, �Ter osmu Sabatik nanduwa. Mberem ushiwak kawu mihi oso nga mi laha yanduwa? Os erem mi uwa kava sir. Lo os Moses nirin or hari oson os mimu haploronduwa!� ");
INSERT INTO sim_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Urik ormu mbara, �Ma or anin mbawak jivik a nawa ma oto mbashiwak kawu anhin amu laha yanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Urik limu silira, �Mbernda ma mende mbashiwak kawu mihin mi laha yandu!� ");
INSERT INTO sim_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hako Jisas ma os li tirsandari mishi nindik or ishirik ma or jivik nari oto mbeek os or irin heyeri ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Urik Jisas tempel akak or lihi ma oton indik or heyehe orin ormu mbara, �Ai ai, ter am jivik mi nawa osik kavakava las indik uwa hala! Las avak nomorawu wasilaka indik mihik si nanda ngashi.� ");
INSERT INTO sim_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Karem or mbarik ma oto or ihi Judama ondon ormu sawera, �Ma or anin mbarik jivik a nari ma oto Jisas oria.� ");
INSERT INTO sim_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Karem mbarik Judama ondo Jisasin limu wapkava hishira. Mberem ushirik? Ma oton Sabatik or mbarik jivik nari ora. ");
INSERT INTO sim_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hako Jisas ormu mbara, �Avui anhi ermba ermbak lerawun landa ri. Unda osik an erem lerawun amu sishi landuwa.� ");
INSERT INTO sim_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Karem or mbarik orin li mandingormekurik limu hishira. Mberem ushirik? Or mbeek Sabat wolo oso nom or mblarnari ambu ri, wahau. Avui Wasilaka avui orhi, karem or mbari mashi oso nga li misihi limu mbara, �Ma roto orhinjik Avui Wasilakahi farniyik or nakwak hishiwa tori te!� Karem li hishihi orin li mandingormekurik limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Urik Jisas lirin ormu sawera, �Omendingak jirin amu sawenduwa, an mbeek anhinjik mbele las a undahi ambu nir. Mbele mbele os Avui anhi uwak a heyewa ondo nom a unda nir. Mbele mbele ol or unda an erem, a undahi lir. ");
INSERT INTO sim_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Avui anhi anin wapnuku orhik or ewenda osik mbele mbele ol or undan anin mukunda ri. Hako kumak avak lerawu wasilaka lal nga or mukunak a unak avak ji heyehe lishnyafakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ma ol hahandan or mbanak usahakwa lir. Uhunda hom an erem, ma ol a rupshindan a mbanak indik usahakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Avui anhi mbeek ma ol kavakavan undan eweieweiheyekwa ambu ri. Man eweieweiheyekwa lerawu oso angop anin or hari sir. ");
INSERT INTO sim_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Lerawu oson anin or hahanda osik ma amber hi anin hauowekwa ola, os Avuihi hin li hauowenda hom. Hako os ma lal hi anhin li hauowena ambu nahi, Avui anhi or mbashirik a rari hi orhi nga mbeek li hauowekwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Omendingak jirin amu sawenduwa, ma ol mashi anhin misihi Avui Wasilaka or mbashirik a rahandan hishiowenda ma ondo ermba ermbak linda oso angop lihik nawa sir. Mbele mbele am mendek si nakuna wolo kot orok sikwa ol te. Hako kavakava ol li undan angop a yoko ermbenda olik mbeek kavak nakwa ambu lir. Mberem ushiwak? Ermba ermbak linda oso angop lihik nawa sir. ");
INSERT INTO sim_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Omendingak jirin amu sawenduwa, kumak avak Avui Wasilaka jikisi orhi oto or mbanak ma ol hahandari ondo amber mashi orhin misihi usahakwa lir. Uhu ma ol mashi orhin misindiyanda ondo nom ermba ermbak lindan lakwa lira. ");
INSERT INTO sim_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Os ermba ermbak linda oso tontlo sihi Avui Wasilakahik nanda sir. Oso angop Jikisi orhin or hahanda osik ma ol or mbawa mbeek handa ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma or hulaima nokopma mbele mbele ol li undan heyembakwa ma Ma Jikisi Avui Wasilakahi oria. ");
INSERT INTO sim_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jir avak os a mbawan wavu musha mushak hishiwa hala! Kumak avak ma ol mawak wawa amber mandarjinya anhin li misihi mawan li halaha usahakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ma ol jivin unda ma ondo li usaha avak jipjip likwa lir. Hako ol kavakavan unda ma ondo li usaha yanga kavak ikwa lir.� ");
INSERT INTO sim_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Uhu mashi las nga ormu mbara, �Os man a heyembakwa an mbeek wavu anhik a hishihi na mbakwa ambu nir. Avui anhi or mbashirik a rahanda or mbawa hom a heyembakwa nir. Uhu os a mbawa oso osmu wornak nanduwa. Mberem ushiwak? An mbeek mbele las wavu anhik a hishiwan a ukwa ambu nir. Avui anhi or mbashirik a rahanda or mbawa hom erem a ukwa nir. ");
INSERT INTO sim_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Os ma namtar nom or mba nahi, mashi orhi mbeek kot las tikrikwa ambu sir. Os antonom a sihi na mba nahi, mashi anhi mbeek omek nakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hako an mbeek nendekop a sihi na mbawa ambu nir. Ma lar anhi kumayok or sihi nor mba, �Mashi ma roto or mbawa ome sira,� karem anin mbanda ri. Uhundak mashi orhi omek nawak a heyenda sir. ");
INSERT INTO sim_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","Jir an lawe nir, karem ji mbaha ma lal ji mbashirik Jonik iri lir. Unak or sawenak ji misikmbahan. Urik mashi os or sawerik ji misiri oso omendinga sira. Hako an mbeek ma misambik fehe lar anin saunjelyakwak a hishiwa ambu nir. Hako os mashi os Jon anin or mbahanda mashi oson wavu jihik ji ewe nahi, ermba ermbak linda oson lakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon oto tujaka arme mendek ukruharandari hom nari ri. Hako jir mbeek ukruharanda orhi oson nambek rupshiri ambu jir. Kandakar nom orin rupshiri jir. ");
INSERT INTO sim_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mbele mbele ol Jon anin or mbari omendinga lira. Hako oso nom ji hishiwa hala. Lerawu os Avui anhi anin or hashihindak a lawa oso nga ji heyehe ji hishika, an Avui anhi mbashirik a rari nira. ");
INSERT INTO sim_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Avui or mbashirik a rari oto anin saunjelyanda ri. Hako jir mbeek mashi orhin misihi orhin heyenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uwosik mashi orhi mbeek sunguwavu jihik nawa ambu sir. Mberem ushiwak? Jir mbeek ma or Avui Wasilaka mbashirik rari oton hishiowenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jir mashi os Avui Wasilakahi jekambak li kayendari oson ji ritim uhu karem hishinda oja, �Os mashi toson ni tiya nahi, avak ermba ermbak linda oson ni lakwa nir.� Karem hishinda jir. Hako os erem ji heyenda mashi oso anira, kason mbeek heyekrahakoronda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Uhu jir mbeek anhik tanda ambu jir. Os ji rawakop ermba ermbak lindan jirin a hawa nir. Hako jir mbeek anhik tanda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","An mbeek ma misambik fehe hi anhin li hauowekmbaha na hishinda ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Angop a heyewa jir. Jir mbeek Avui Wasilakan rupshinda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Avui anhi or mbashirik hi orhik a rari nir. Hako jir mbeek mashi anhin misinda ambu jir. Hako os ma misambik fehe li taha mashin li mbawa, kolomalok mashi lihin misindiyanda jir. ");
INSERT INTO sim_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Uhu ma misambik fehenda hi jihin li hauowekmbaha hishinda jir. Hako jir mbeek os Avui Wasilaka nom hi jihin or hauowekwan hishinda ambu jir. Erem ji nanda osik mashi anhin mberem ji misihi ji tiyandahi ambu, wahau. ");
INSERT INTO sim_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jir avak ji mba, an jirin Avuihi misokomek a kotim ukwa jir. Karem ji hishinan, wahau. Ma or jirin kotim ukwa ma oto Moses oria. Ma or ji hishihi ji mba, or avak nirin jelyakwa ri. Karem ji hishiwa ma oto jirin kotim ukwa ri. ");
INSERT INTO sim_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mberem ushiwak? Mashi os or kayeri oso anin mbahandari sir. Hako jir mbeek mashi orhin misindiyanda ambu jir. Os mashi orhin sunguwavu jihik ji owe nahi, wa mashi anhin avak er nga ji tiyakwa sir. ");
INSERT INTO sim_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hako jir wahau, mashi orhi os or kayeri oson mbeek misindiyanda ambu jir. Uwosik mashi anhin mbernda er nga ji misindiyakwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ushihi Jisas leuku Galili kauyok ormu ira. Leuku oso hi yeje sihi Taiberias, karem li ushandari sira. ");
INSERT INTO sim_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Urik ma mushak orin limu tiya ira. Mbele las ma undahi ambu mushak or uhu ol kavamisindarin or mbarik jivik li nari osik orin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Urik Jisas telembak or lawuhu ma ol orin tiyandari ma nga orok limu lira. ");
INSERT INTO sim_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oso wolo Judama hiyawu wasilaka Pasovan li undari wolok si nakurik simu nara. ");
INSERT INTO sim_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas or limakandaha nor heyeri ma musha mendek orhik limu rara. Urik Filipin ormu silira, �Mbeek nivai akwan frungawuhu ma rondon ni hanak li aku?� ");
INSERT INTO sim_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mashi oso men Filipin or eweheyeri sir. Mbele mbele os or ukurik nari angop or hishiri sir. ");
INSERT INTO sim_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Urik Filip ormu mbara, �Ma rondo musha mende re! Os asama namtas lerawun ni la nahi, yan ni lawa oso mbeek akwan ni lashinak ma rondo andahik nawa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Urik Saimon Pita maha orhi Andru mu Jisasin sawera, ");
INSERT INTO sim_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","�Jikanda tor torok liwa roto bali bret tostava nga foome frijip nga tormu ewelinduwa. Hako ma rondo musha mende re. Akwa rondo nakrem nakwa ambu re.� ");
INSERT INTO sim_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Urik Jisas ormu mbara, �Ma rondon mbanak li taka lika.� Karem or mbarik ma amber misambik limu taka lira. Hulayi ondo 5,000-ik nari lir. ");
INSERT INTO sim_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Urik Jisas bret ondon or laha Avui orhin armesarmek ormu mbara. Uhu ma ondon ormu hara. Uhu foome ovro nga erem ormu hara. Akwa ondon or harik, os li akurik li hishiri hom limu ara. ");
INSERT INTO sim_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Am li aha li kreherik ol orin tiyandari man ormu mbara, �Akwa sumbuyambun lasikop ji lahara tirsaka, unak lal avak li sambuku.� ");
INSERT INTO sim_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Os bret tostava yeje hom or laha nor harik li aha li kreheshirik akwa sumbuyambu serkawu 12-pelak li wolorik hojeri lir. ");
INSERT INTO sim_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma ondo Jisas ma undahi ambu oson or urik, li heyehe limu mbara, �Omendinga sira. Ma toto profet oria. Ma or ni nikishinda ma toria.� ");
INSERT INTO sim_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hako Jisas mashi os orin li toloho orin li mbashinak malakamak or najehe li mbari angop or heyeri sir. Uri osik yanga oson or halaha ortonom indik telembak ormu lawura. ");
INSERT INTO sim_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Am si homirik ol Jisasin tiyandari ma ondo leuku sumbuk li layihi Jisasin limu nikishira. ");
INSERT INTO sim_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Am si krinyashirik or mbeek lirik tari ambu ri. Uri osik bot lasik li lawuhu nendekop Kaperneamik li ikurik limu ira. ");
INSERT INTO sim_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Urik suwa wasilaka mendek si rasaha leuku oson si urik simu laulau rakara. ");
INSERT INTO sim_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Os li iri 5-pela mo 6-pela kilomita hom li iri sir. Uhu li heyeri Jisas leuku heyek ormu ese ira. Or ihi am pasir bot oso siri mishi orok ormu nara. Urik limu ajera. ");
INSERT INTO sim_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Urik ormu mbara, �Ji ajewa hala! An mu randu te.� ");
INSERT INTO sim_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Karem or mbarik orin botik limu toloho laharara. Urik kolomalok bot oso kuyanga os li ikurik li iri mishi orok simu ira. ");
INSERT INTO sim_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hulaima nokopma leuku kauyok li wahandaha nirsumbuk li usaha Jisasin limu lasara. Hinyer bot namtas nom orok sirik li heyeri sir. Hako ol orin tiyandari ma ondo nom bot orok lawuhu irik li heyeri lir. Jisas nga nembes. ");
INSERT INTO sim_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hako ter li heyeri bot lal ol nirik yanga Taiberias yok tari nom orok sirik li heyeri lir, os Jisas akwan or harik li ari mishi orok. ");
INSERT INTO sim_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Urik Jisasin bot ondok li lasari mbeek orok liri ambu ri. Orin tiyandari ma ondo er nga orok liri ambu lir. Urik li halaha botik li lawuhu yanga Kaperneamik orin lasakurik limu ira. ");
INSERT INTO sim_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Am leukun li mbuhu kauyok li ihi Jisasin li heyehe limu silira, �Tisa, mbele wolok torok mi tar?� ");
INSERT INTO sim_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Urik ormu mbara, �An akwan jirin a harik ji aha sungu tuvahanda osik os jimu anhik tanduwa. Hako jir mbeek os a urin yariri ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jir akwa tos misambik fehe kavak nandanjik ji hishihi ji yawa hala, wahau. Hako os ermba ermbak linda oson ji lakundanjik ji hishihi ji yaka. Avui Wasilaka jikisi orhi oto nom oson jirin hakwa ri. Lerawu oson or lakmbaha Avui Wasilaka orin or mbashirik rari ri.� ");
INSERT INTO sim_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Urik limu silira, �Avui Wasilaka mberem ni ukmbaha or mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Urik ormu mbara, �Or mbashirik tahanda ma otohi mashin ji misihi os or mbahanda hom ji tiyaka. Os erem ji u nahi, ambehoma, Avui Wasilaka os or mbahanda hom os jimu unduwa.� ");
INSERT INTO sim_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Urik limu mbara, �Os mbele mbele ma undahi ambu ondon mi una ambu nahi, nir mbeek mashi mihin ni misihi ni tiyakwa ambu nir. Hako os lal nga mi unak ni heye nahi, ambehoma, ni tiyakwa mira. ");
INSERT INTO sim_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Misumu walanga nihi os misamtelmbamba orok li liri wolo Moses akwa manan or harik ari lira, os mashi Avui Wasilakahi jekambak li kayehendari hom. �Bret yanga jivik fehendarin or harik limu ara.� Karem li kayehendari sir. Uhunda hom mir erem mi unak ni heyehe mirin nivai tiyaka.� ");
INSERT INTO sim_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Urik Jisas mu mbara, �Omendingak jirin amu sawenduwa, Moses mbeek akwa oson misumu walanga jihin hari ambu ri, wahau. Ma or akwa omendingan handa ma oto Avui anhi ri. Or akwa yanga jivik fehendan jirin handa ria. ");
INSERT INTO sim_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret os or handa oso yanga jivin si halaha misambik si takaha ermba ermbak lindan handa sira.� ");
INSERT INTO sim_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Urik limu mbara, �Wasilaka, bret oson ermba ermbak nirin hanak ni aka.� ");
INSERT INTO sim_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Urik ormu mbara, �Bret oso anira. Ma or ermba ermbak linda oson handa ma oto anira. Ma ol anhik tawa ondo mbeek indik erenghakwa ambu lir. Uhu ma ol mashi anhin misihi mba, �Mashi oso ome sira.� Karem mbawa ma ondo mbeek indik uksem akwak mbakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jir angop ji heyeri nir. Hako mbeek mashi anhin misindiyanda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","An mbeek anhinjik mbele las a ukurik yanga jivin a halaha a tari ambu nir, wahau. An Avuihi lerawun a lakmbaha or mbashirik a rari nir. Karem unda osik ma ol anjik or kamashihinda ondo mbeek lal a halakwa ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Avui anhi mbeek ma ol anhik tawa lal a halashinak kavak li nakwak mbanda ambu ri. Kumak avak mbele mbele mendek si nakuna wolok a mbanak indiyok usahakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Avui anhi ma ol mashi anhin misindiyawa ma ondo ermba ermbak li likwak mbanda ri. Uwosik os li ha nahi, mbele mbele mendek si nakuna wolok a mbanak indiyok usakwa lir.� ");
INSERT INTO sim_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Urik Judama ol orok liri ondo li misirik Jisas ormu mbara, �Antonom yanga jivik tahanda bret anira.� Mashi oson li misihi orin limu mbahanjira, ");
INSERT INTO sim_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","�Toto Josephi jikisi ria! Avoko nijava orhi angop ni heyenda op te. Hako mberem ushiwak, an yanga jivik fehenda bret anira, karem or mbanduwa?� ");
INSERT INTO sim_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Karem li mbarik ormu mbara, �Jir main laka lakan jiwa hala! ");
INSERT INTO sim_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma lar mbeek orhinjik anhik takwa ambu ri, wahau. Hako os Avui anhi or anin mbashirik a rari oto sunguwavu ma larhin or jinak or misi nahi, ormu anhik takuwa. Unak mbele mbele mendek si nakuna wolok avak a mbashinak indik usahakwa ri. ");
INSERT INTO sim_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mashi os maskop profet li kayeri karem nanda sir, �Avui Wasilaka avak ma amber or ewesawekwa lira.� Karem li kayeri sir. Uwosik ma ol mashi Avui anhin misindiyawa ondo olmu anhik tanduwa. ");
INSERT INTO sim_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma lar mbeek Avuin heyenda ambu ri, wahau. Hako ma or Avui nga nakrem fri lihi tahanda oto nom orin heyenda ri. ");
INSERT INTO sim_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Omendingak jirin amu sawenduwa, ma or mashi anhin misindiyawa ma oto ermba ermbak lindan lakwa ria. ");
INSERT INTO sim_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bret os ermba ermbak lindan handa anira. ");
INSERT INTO sim_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Neloko walanga jihi ol misamtelmbamba orok akwa manan ari ondo angop hari lir. Mana os li ari oso mbeek ermba ermbak lindarin lirin hari ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hako ma or bret os yanga jivin halaha tahanda bret oson anda ma oto mbeek hakwa ambu ri, wahau. Ermba ermbak likwa ri. ");
INSERT INTO sim_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","An bret os yanga jivin halaha rakahanda bret anira. Os ma lar bret oson or a nahi, or avak ermba ermbak lindan lakwa ria. Bret os orin a hakwa oso maome anhi sira. Maome anhin a hashinak ma misambik fehe avak ermba ermbak lindan lakwa lira.� ");
INSERT INTO sim_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Karem or mbarik mashi oson li misihi lihi ambek mainkwambuk limu mbara, �Mberem ushiwak ma toto maome orhin or hanak ni akmbaha nor mbanduwa?� ");
INSERT INTO sim_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Urik Jisas mu lirin sawera, �Omendingak jirin amu sawenduwa. Os maome anhi nga fi anhi nga ji ana ambu nahi, jir mbeek ermba ermbak lindan lakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hako ma or maome anhi nga fi anhi nga awa oto avak ermba ermbak linda oson lakwa ri. Unak kumak mbele mbele mendek si nakuna wolok a mbanak indik usahakwa ri. ");
INSERT INTO sim_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maome anhi akwa indinga sir. Fi anhi uku indinga sira. ");
INSERT INTO sim_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma or maome anhi nga fi anhi nga awa oto or avak anhik or sinak an nga orhik a sikwa nir. ");
INSERT INTO sim_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Avui anhi or mbashirik a rari oto ermba ermbak linda oso tontlo oria. Or mbashiwak os amu sinduwa. Uhunda osik ma or maome anhi nga fi anhi nga awa ma oto a mbashinak ermba ermbak sikwa ria. ");
INSERT INTO sim_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret os yanga jivin halaha rahanda bret oso anira. Ma or bret oson awa ma avak ermba ermbak sikwa ri, or mbeek os neloko jihi mas akwa manan li aha li hahandari hom hakwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas yanga Kaperneamik or lihi Judama lotu undari akak mashi kason ormu owesawera. ");
INSERT INTO sim_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Karem or mbarik ol orin tiyandari ma ondo mashi oson li misihi limu mbahanjira, �Wahau te! Mashi oson ni hishiwa kom te! Sunguwavu nihi osmu kavak nanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas wavu lihin angop or heyeri osik ormu mbara, �Mashi oson a mbawa sunguwavu jihi osmu kavak nanduwa. ");
INSERT INTO sim_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hako os mashi oso si unak sunguwavu jihi kavak si na nahi, mberem jivai mbaku, os ji heyenak Ma Jikisi Avui Wasilakahi oto indiyok yanga os mas or rahanda mishik or i nahin? ");
INSERT INTO sim_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Masikome Avui Wasilakahi ermba ermbak linda oson handa ria. Ma misambik fehe lar mbeek oson handa ambu ri, wahau. Hako mashi os a sawewak ji misiwa oso Masikome nga ermba ermbak linda nga jirin handa sir. ");
INSERT INTO sim_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Angop a heyewa jir. Jir lal mbeek anin hishiowenda ambu jir. Karem uri osik angop jirin a saweri nir, ma lal mbeek lihinjik anhik tandahi ambu lir. Avui anhi nom sungu wavu lihin or jiwak anhik tanda lir.� Jisas ma ol mashi orhin tiyakurik nandari nga ma or orin wutarihi tavarenjek hakundari ma oto nga angop maskop or heyeri lir. ");
INSERT INTO sim_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Karem or mbarik ma mushak orin li kumaifaha limu ira. ");
INSERT INTO sim_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Urik Jisas ma 12-pela ondon or heyehe ormu silira, �Jir er nga anin ji kumaifakwak jimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Karem or silirik Saimon Pita mu mbara, �Wasilaka, mirin ni halaha ni kumaifa nahi, wa, lawehik nivai iku? Mashi mihi oso nom ermba ermbak lindan handa sira. ");
INSERT INTO sim_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Uhu angop ni hishihi armek ni heyewa nir, mir ma jivi worna Avui Wasilaka kamahanda ma mira.� ");
INSERT INTO sim_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Urik ormu mbara, �Anhinjik jir ma 12-pela na kamari nir. Hako jihi lar Laulaka ria.� ");
INSERT INTO sim_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ma or or mbari oto Judas, Saimon Iskariothi jikisi ria. Or kumak Jisasin tavarenje wutarihik hakundari ma ria. ");
INSERT INTO sim_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Provins Judiak fehenda Judama Jisasin mandingormekurik li mbari osik orok or ikurik hishiri ambu ri. Yanga Galilikop ormu yara. ");
INSERT INTO sim_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Urik Judama hiyawu wasilaka os shikor akak li lihi li andarin li undari wolok osmu nara. ");
INSERT INTO sim_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Urik Jisas maha orhi limu mbara, �Mir provins Judiak hiyawu oson li ukwa mishi orok ika. Uhu mbele mbele ma undahi ambu ondon orok unak mirin tiyanda ma ondo kwambu mihin li heyeka. ");
INSERT INTO sim_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Os ma lar hiushamak or nakwak or hishi nahi, mbele mbele ma undahi ambu ondon kormbak or unak ma amber li heyeka. Hako mir wahau, mbeek ondon kormbak unda ambu mir.� ");
INSERT INTO sim_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maha orhi ondo nga mbeek or Avui Wasilaka kamahanda ma ria, karem hishiri ambu lir, wahau. Uri osik erem limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Karem li mbarik ormu mbara, �Orok a ikwa wolok nawa ambu sir. Hako jir men orok ji ikwak nawa sir. ");
INSERT INTO sim_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma ondo mbeek jirin wapkava hishinda ambu lir. Hako an mbele mbele kavakava os li undan kormbak a saweri osik anin wapkava hishinda lir. ");
INSERT INTO sim_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hako jir ji ika, hiyawu laka os Jerusalemik li uwa mishi orok. Ana ikwa wolok nawa ambu sir. Os orok a ikwa wolok si nawakop amu iwa.� ");
INSERT INTO sim_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Karem or mbarik li irik yanga Galilik ormu lira. ");
INSERT INTO sim_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Maha orhi ondo masmas li ishirikop or kuma iri ri. Hako mbeek kormbak iri ambu ri, men wanyihi iri ria. ");
INSERT INTO sim_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hiyawu oson li uri wolo Judama lida lihi ondo Jisasin li lasaha limu mbara, �Ma oto mbeya?� ");
INSERT INTO sim_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hako ma musha mendek Jisasin limu mbara, �Ma oto ma jivi ria.� Hako lal limu mbara, �Wahau te! Haimba handambanda ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Karem lihi ambek maintukurkop limu mbara. Mberem ushirik? Las avak Judama lida lihi ondo lirin li jinda ngashi. Karem mbaha li ajehe olmu maintukurkop mbara. ");
INSERT INTO sim_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hiyawu oso am nindik si narik Jisas tempel akak or layihi mashin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Urik Judama li misihi wavu lihi mushak li hishihi limu mbara, �Ma roto skulik iri ambu ri. Hako katai angop skul unda hom sawenda re!� ");
INSERT INTO sim_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Urik Jisas ormu mbara, �Mashi kaso os jirin a sawewa mbeek anhi mashi ambu sir, wahau. Ma or mbashirik a rahanda orhi mashi sira. ");
INSERT INTO sim_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Os ma lar mashi Avui Wasilakahin or tiyakunak or hishi nahi, avak or yarikwa sir, mashi kas a mbawa kaso mbeek anhinjik a hishihi a sawewa ambu sir, wahau. Mashi ome Avui Wasilakahi nom os amu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma or wavu orhik tasawan sawenda ma oto or men hi orhi nom hauowenda ri. Hako ma lar os or mba, �Hi anhin ji hauowewa hala! Ma or mbashirik a rahanda hi orhi nom ji hauoweka!� Karem mbawa ma oto jivi mende ria. Mashi ome nom sawenda ria, mbeek mbafirimbanda ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Maskop Moses lo Avui Wasilakahin jirin hari ri. Hako jir mbeek lo oson tiyanda ambu jir. Unda osik anin ji mandingormekwak jimu mbanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Urik limu mbara, �Lawe mirin mandingormekwak mbandu? Mir wasimalengamba tolonda hom mbaw te!� ");
INSERT INTO sim_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Urik ormu mbara, �Sabat wolok ma roton a mbarik jivik or nari osik os jimu anin wapkava hishinduwa. ");
INSERT INTO sim_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Hako anin sawenak a misi, masamsishin ji koronda wolo os Sabat wolok si na nahi, mberem jivai undu? Masamsishin koronda oj mo koronda ambu oj? Jir koronda oja. Mberem ushiwak? Moseshi lon ji tiyakmbaha ji hishinda osik masamsishin Sabat wolok koronda oja. Hako lo oso mbeek Moses hari ambu sir, oso angop mas araje Abrahamhikop nahandari sir. Hako os erem ji uwa oso os jir nga mu Sabat wolok lerawun landuwa. Hako mberem ushiwak anin ji wapkava hishinduwa, ma oton a mbarik Sabat wolok jivik or nandarin? ");
INSERT INTO sim_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mbele mbele misokomekop ji heyeshihi ji mbawa hala! Yawur ji heyehe hishihi jivai mbaka.� ");
INSERT INTO sim_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Urik Jerusalemik fehe ma lal limu mbara, �Mberema, ma toto lida nihi li mandingormekurik li mbari or te. ");
INSERT INTO sim_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hako ji heyeka, tor mashin kormbak sihi sawendu te! Mberem ushiwak lida nihi orin li pantlekwan li halandu? Ma roto Krais, Avui Wasilaka kamashirik hulaima nokopman jivinakmbaha tari marmbe? Karem hishindal? Uhu orin li pantlekwan olmu halanduwa. ");
INSERT INTO sim_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hako ma toto kotontlo orhi angop ni heyenda sir. Hako Krais Avui Wasilaka kamahanda ma oto or tawakop kotontlo orhin mbeek ni heyekwa ambu sir,� karem wavu lihi musha mushak li hishihi limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Urik Jisas tempel aka orok or sihi mashin ormu sawera. Uhu ormu mbara, �Jir an lawe, karem ji hishindu? Uhu kotontlo anhi os a rahanda nga am jimu hishindu mo wahau? Hako an mbeek anhinjik a tari ambu nir. Avui anhi mbashirik a tari nir. Or mbele mbele omek nanda tontlo oria. Hako jir mbeek orin heyenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hako an angop or nga shi lihi angop a heyenda ri. Uhu or mbashirik a rari nir.� ");
INSERT INTO sim_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Karem or mbarik Judama lida lihi orin krawu akak li ewekmbaha limu mbara. Hako or hakuri wolok si nari ambu osik ma lal mbeek orin tolori ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hako ma musha mashi orhin li misihi limu mbara, �Ma toto mbele las ma undahi ambu mushak or uwak nimu heyenduwa. Avui Wasilaka kamahanda ma oto mbele mbele ma undahi ambun warje nga nor uhu ma roton tikrikundar?� Karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi li misiri ma amber Jisas nom limu mbara. Uhu bikpris ondo nga li tirsaha ma ol tempel akan washilinda ma ondon li mbashirik Jisasin li tolokurik limu ira. ");
INSERT INTO sim_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Urik Jisas ormu mbara, �An mbeek jir nga nambek torok a likwa ambu nir. Avui anhi or mbashirik a rahanda onik indik orhik a ikwa nir. ");
INSERT INTO sim_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Unak avak anin lasafukwa jir. Hako os a iwa mishi mbeek ji heyekwa ambu sir. Uhu kuyanga os a iwa mishi orok ikwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Karem or mbarik limu mbara, �Mbeek or ishinak orin ni heyekwa ambun or mbanduwa? Las avak or ihi nihi ma ol yanga Grikik linda ondo nga or linda ngashi. Uhu ol orok fehenda man mashin or sawenda ngashi. ");
INSERT INTO sim_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uhu mberemhi mashin or mba, �Anin avak lasafukwa jir. Uhu os a ihi na liwa mishin heyekwa ambu jir.� Mberemhi mashi kas karem or mbandu?� Karem lihi ambek limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hiyaw sumbu wasilaka oson li ukuri wolok Jisas tempel akak or ihi wasilakak ormu mbara, �Os ji uksem ha nahi, anhik ji taha ji uksem aka. ");
INSERT INTO sim_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Os mashi anhin ji misindiya nahi, uksembe ermba ermbak nanda oso sunguwavu jihik avak jeruku hom nakwa sir, os Avui Wasilakahi jekambak li kayendari hom.� ");
INSERT INTO sim_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Uksembe os or mbari oso Masikome Avui Wasilakahin or mbari sira. Orhi mashin misindiyanda man or hakurik nor mbari sira. Hako oso wolo Jisas mbeek or haha usaha hevenik indik or iri wolok nari ambu sir. Uri osik Masikome Avui Wasilakahi mbeek misambik or ta namber. ");
INSERT INTO sim_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Karem or mbarik ma lal limu mbara, �Omendinga sira. Ma oto profet oria.� ");
INSERT INTO sim_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Hako lal limu mbara, �Or Krais Avui Wasilaka kamashirik hulaima nokopman jivinakmbaha or mbashirik tahanda ma ria.� Hako lal limu mbara, �Wahau te. Avui Wasilaka jekamba orhi orok karem li kayeri sir, �Krais ma or hulaima nokopman jivinakwa ma oto King Devithi krahak or takaha Devithi kotontlo Betlehem orok talakwa ri. Os Avui Wasilaka ma oton or kamahandakop mbeek provins Galilik usahawa ambu ri, wahau.� � ");
INSERT INTO sim_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Karem li mbaha wavu apsaham apsham limu hishira. ");
INSERT INTO sim_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Uhu lal orin krawuk li ewekmbaha mbari lir. Hako ma lar mbeek orin tolori ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bikpris nga Farisi nga ma ol tempel akan washilindari ma ondon li mbashirik Jisasin li tolo laharakurik limu ira. Li ihi fuhu tapas indiyok limu tara. Urik limu silira, �Mberem ushiwak orin ji halashi randu?� ");
INSERT INTO sim_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Urik limu mbara, �Ma lar mbeek oto mbanda hom mbanda ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Urik olmu mbara, �Ma amber angop or haimba handambari lir. Jirin er nga haimba handambawa or? ");
INSERT INTO sim_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hako nir lida jihi nirin ji heyeka! Nir lar mbeek orin tiyanda ambu nir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma ol hishiyarinda ngashi ambu ferfar nanda ondo nom orin tiyanda lir. Erem li unda osik kumak Avui Wasilaka kavak or nakwa lir.� ");
INSERT INTO sim_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Karem li mbarik ma lar or usasihi ormu mbara. Ma oto Farisi lar oria. Hi orhi Nikodemus. Mas Jisasin nirik ta heyendari ma ria. Or sihi ormu mbara, ");
INSERT INTO sim_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","�Wa lo nihi mberem si mbandu? Ma lar semben ni mbaha krawuk ni ewekmbaha mbanda os? Wahau. Masmas armek ni misihi ni eweheyehe nivai mbaka, lo karem mbanda osa.� ");
INSERT INTO sim_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Karem or mbarik limu mbara, �Wa mir er nga Galilik fehenda om? Os mashi Avui Wasilakahin armek mi heye nahi, mir er nga karem mbakwa mira, profet lar mbeek Galili yok takwa ambu ri,� karem limu orin ngriambara. ");
INSERT INTO sim_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Urik ma amber yanga yanga lihik limu ira. ");
INSERT INTO sim_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hako Jisas ortonom telemba Oliv orok ormu lawura. ");
INSERT INTO sim_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Orok or lawuhu wahandaha nirsumbu mendek tempel akak indik ormu layira. Urik ma mushak orhik li ralandirsarik mashin ormu owesawera. ");
INSERT INTO sim_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Urik mashi Moseshin sawendari ma lal nga Farisi lal nga nokove las orhik limu laharara. Nokove oso hulatolhakarik li heyehe sirin li lahara halashirik ma ondohi nindik osmu sira. ");
INSERT INTO sim_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Uhu limu mbara, �Tisa, nokove roso hulatolhakawak ni heyewa tosira. ");
INSERT INTO sim_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo Moseshi karem mbanda sir, erem unda nokoven men sunjakom amakom loho mandingormeka. Lo oso karem mbanda sira. Wa, mir mberem mi mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Os erem li siliri oso men li silinak or una unak li heyekmbaha li siliri sir. Unak li heyehe mashi las or mbanak kavak si na nahi, mashi orok orin li kotim ukmbahan. Hako Jisas kumbamblurik or taka lihi misambik ormu kayera. ");
INSERT INTO sim_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Urik li sihi orin limu siliyangora. Urik Jisas or usaha ormu mbara, �Wa, ji mandingormeka. Hako halanak ma or kavakava las unda ambu oto masmas sunjakomben or laha sirin or jika.� ");
INSERT INTO sim_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Karem or mbaha or taka lihi indiyok misambik ormu kayera. ");
INSERT INTO sim_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Urik ma amber mashi oson li misihi avok avoko masmas namtarmba namtarmbak li longlongo rala irik jikanda er nga kumasihi irakori lir. Ma ondo amber li irakoshirik Jisas nga nokove oso nom nga orok frimu sira. ");
INSERT INTO sim_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Uhu or usasihi ormu silira, �Nyirin kotim ukwak siwa ma ondo mbeek li irakondu? Ma lar nyrin kotim ukwak sindar mo?� ");
INSERT INTO sim_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Karem or silirik simu mbara, �Awasayi, ma amber angop irakowa lir.� Karem si mbarik ormu mbara, �An ngana. An mbeek nyirin na kotim ukwa ambu nir. Nyi ihi indik kavakavan uwa hala!� ");
INSERT INTO sim_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ushihi Jisas indik mashin ormu ewesawera, �Ukruharanda misambi torok takahanda anira. Ma or mashi anhin misindiyawa ma oto mbeek nirtle nirndum yaha tukuyikwa ambu ri. Or ukruharanda anhi orokop or ihi nombo os ermba ermbak linda mishi orok inda nombon heyekwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Karem or mbarik Farisi ondo limu mbara, �Mir haimba handambanda ma mira. Ma lar mbeek mir sawewan er nga saunjelyawa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Urik ormu mbara, �Os an anhinjik a sawewa mashi anhi ome sir. Mberem ushiwak? Kuyanga os a rahanda mishi nga kuyanga os a ikwa mishi nga angop a heyeri sir. Karem uwosik mashi os a mbawa omendinga sira. Hako jir mbeek kuyanga os a rahanda mishi nga os a ikwa mishi nga heyenda ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jir ma misambik fehe li eweheyehe man li kotim unda nombo hom os jimu anin eweheyenduwa. Hako an mbeek ma lar a eweheyenda ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hako os ma lar mbele las or undan a eweheye nahi, os erem a uwa oso jivik nakwa sira. Mberem ushiwak? Mbeek nendekop man a eweheyekwa ambu nir. Avui anhi or mbashirik a rahanda nga nakrem shi mbakwa shir. ");
INSERT INTO sim_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo jihi karem mbanda sir, os ma frijip fri sihi mashi las nakrem fri mbawa mashi frihi ome sira. Hako ma namtar nom or mbawa, wahau. ");
INSERT INTO sim_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uhunda hom an mbeek antonom mashin a sawenda ambu nir. Avui anhi or mbashirik a rahanda er nga mashi os a sawendan saunjelyanda ri.� ");
INSERT INTO sim_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Urik limu silira, �Avui mihi or mi mbawa mbeek or lindu?� Urik ormu mbara, �Os anin ji heyewakop Avui anhin er nga jimu heyewa ri. Hako jir mbeek anin ji heyenda ambu osik Avui anhi nga or jimu hishanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas tempel akak yan li ewendari mishi orok or lihi mashin ormu owesawera. Hako orin li jikuri wolok si nari ambu osik ma lal mbeek orin tolori ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Urik Jisas indik ormu ewesawera, �An avak a ikwa nir. Na ishinak jir avak anin lasafukwa jir. Hako mbeek ji heyekwa ambu nir. Unak kavakava jihi er si nanak hakwa jir. Hako yanga os a ikwa mishi orok mbeek ikwa ambu jir.� ");
INSERT INTO sim_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Karem or mbarik Judama ondo limu mbara, �Mberemhi mashin or mbandu, �Jir yanga os a ikwa mishi orok ikwa ambu jir,� kas karem or mbawan? Wa orhinjik or mandingormehe hakwak mbandar?� ");
INSERT INTO sim_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Urik ormu mbara, �Jir torok fehe jir. An metenjek fehe nir. Jir misambik fehe jir. Hako an mbeek misambik fehe ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Angop a sawerik ji misiri sir, kavakava jihi er si nanak hakwa jir. Ma or a mbawa ma anira, karem ji hishina ambu nahi, kavakava jihi oso er si nanak hakwa jir.� ");
INSERT INTO sim_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Karem or mbarik limu silira, �Mir lawe mir?� Urik ormu mbara, �An lawe, karem ji mbandu? Angop a sawerik ji misiri os te! ");
INSERT INTO sim_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mashi musha jirin a sawekwak nanda os te! Mbele mbele os ji undan angop a heyewa nir. Hako avak mbele mbele os ji unda kava jihi orok jirin a heyembakwa ambu nir. Ma or mbashirik a rahanda orhi mashi nom a sawekwa nir. Mbele mbele omek nanda tontlo oria.� ");
INSERT INTO sim_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas karem or mbarik lir fendele menderi lir, os Avui orhin or mbarin. ");
INSERT INTO sim_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Uhu ormu mbara, �Kumak avak Ma Jikisi Wasilakahi oton miandok ji hauowehe nom avak ji heyekwa sir, ma or a mbawa ma anira. Uhu oro wolokop ji hishiyarikwa sir, an mbeek mbele las anhinjik a saweri ambu nir. Avui anhi or sauhari hom a saweri nir. ");
INSERT INTO sim_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Avui anhi or mbashirik a rari nir. Mbele mbele os or mbawa hom a unda osik or mbeek anin halanda ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Karem or mbarik ma mushak mashi os or mbari oson li misihi limu mbara, �Mashi os or mbawa ome sira.� ");
INSERT INTO sim_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Urik Jisas Judama ol mashi orhin misindiyakurik nari ma ondon ormu sawera, �Os mashi anhin ji misihi os si mbawa hom ji u nahi, anin tiyanda ma indingak nakwa jira. ");
INSERT INTO sim_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Uhu mashi omendingan avak ji heyeyarikwa sir. Unak mashi oso jirik si nanak mbele kava misambik fehe mbeek jirin kuvu hom si ishintleshinak sihi siyok sikwa ambu jir, wahau. Jipjip likwa jir.� ");
INSERT INTO sim_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Karem or mbarik limu mbara, �Misumu nihi Abraham oria. Nir nirambara orhi nira. Mas wolok sishi raha ter nga mbele las mbeek nirin kuvu hom si ishintleshiwak sihi siyok ni liwa ambu nir. Hako mberem ushiwak kuvu os nihik nawa si sorngoshinak jip ni liku, karem mi mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Urik ormu mbara, �Wahau, kavakava os ji unda oso kuvu hom jirin si ishintleshiwak sihi siyok sinda jir. ");
INSERT INTO sim_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ji misi, men lerawun landa ma oto mbeek mashamak nakwa ambu ri. Mashama oto jikisi orhi indingo vai mashamak nakwa ri. ");
INSERT INTO sim_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Os mashamahi jikisi oto kuvu os jirin ishintlehendan or sorngo nahi, jip likwa jir. ");
INSERT INTO sim_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","An angop a heyenda jir, misumu jihi Abraham oria. Hako mashi anhi kas mbeek sunguwavu jihik wanda ambu sir. Karem uwosik anin ji mandingormekwak jimu mbanduwa. ");
INSERT INTO sim_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","An Avui anhi sauhawa nombo nom a sawenda nir. Hako jir avoko jihi uhunda nombo hom unda jir.� ");
INSERT INTO sim_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","Urik limu mbara, �Misumu nihi Abraham oria.� Urik ormu mbara, �Jir Abrahamhi nirakop anin mandingormekwak mbawa ambu jir, os mainome Avui Wasilakahin jirin a sawewan. ");
INSERT INTO sim_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hako jir men avoko jihi unda hom unda jir.� Urik limu mbara, �Nir mbeek nombo laka jikisi ambu nir. Avoko nihi namtar numbu Avui Wasilaka oria.� ");
INSERT INTO sim_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Urik ormu mbara, �Os Avui Wasilaka avoko jihikop anin rupshiwa jir. Mberem ushiwak? An Avui nga shi lihi na rari nir. An mbeek anhinjik a rari ambu nir, wahau. Avui mbashirik a rari nir. ");
INSERT INTO sim_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hako mberem ushiwa mendek mashi kas a sawewa kason ji misikwan ji halandu? Jir mbeek mashi anhin misindahik nanda ambu ojik os jimu hishanduwa. ");
INSERT INTO sim_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Avoko jihi Laulaka orik mbele mbele os avoko jihi or uhunda hom os jimu unduwa. Mas araje wolokop sishi raha man mandingormenda ri. Mbele las omek nandan unda ambu ri. Mbele mbele os omek nanda mbeek orhik nanda ambu sir. Haimba handambanda mashi tontlo orhik nanda osik haimba handambanda mashi nom mbanda ri. ");
INSERT INTO sim_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hako an mashi omendinga nom a sawenda nir. Hako jir mbeek mashi anhin misinda ambu jir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jir kavakavan a u, karem jimu hishindu? Os mbele kava las a u nahi, os a uwa kava oson kormbak ji mukunak a heyeka. Hako os mashi omendingan a sawe nahi, wa mberem ushiwak oson ji misikwan ji halandu? ");
INSERT INTO sim_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Avui Wasilaka jikisi orhi ondo mashi orhin misinda ola. Hako jir mbeek orhi jikisi ambu jir. Uwa osik jir mbeek mashi orhin misindiyanda ambu jir, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judama ondo mashi oson li misihi Jisasin limu mbara, �Mir ma kava yanga Samariak fehenda mira. Wasimalengamba oloshiwak mimu mbanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Urik ormu mbara, �An mbeek wasimalengamba oloshiwak a mbawa ambu nir. Mbele mbele os a mbawa oso Avui anhi hi orhin a hauowenda sir. Hako jir hi anhin kavak nanda mashin os jimu mbanduwa. ");
INSERT INTO sim_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","An mbeek hi anhi lakak si nakwak a hishinda ambu nir. Hako Avui Wasilaka nom hi anhin hauowekwak hishinda ri. Orto nom kumak mbele mbele ol ma li uhundan heyembakwa ma ria. ");
INSERT INTO sim_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Omendingak jirin amu sawenduwa, ma or mashi anhin misindiyawa ma oto mbeek hakwa ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Karem or mbarik limu mbara, �Am nimu heyenduwa. Wasimalengamba olonda mira. Abraham nga profet ondo nga angop maskop hari ol te! Hako mberemhi mashi os ter mi mbanduwa, ma ol mashi mihin misindiyawa mbeek hakwa ambu lir, karem mi mbawan? ");
INSERT INTO sim_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham nga profet nga angop maskop hari ol te. Wa lawe mir? Mir Abrahamin mi tikrikwak mimu mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Urik ormu mbara, �Os anhinjik hi anhin na hauowe nahi, oso jivik nawa ambu sir. Hako Avui Wasilaka jihi, karem ji mbanda ma orto ormu hi anhin hauowenduwa. ");
INSERT INTO sim_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hako jir mbeek orin heyenda ambu jir. An angop a heyenda ri. Karem uwosik os a mba, orin na heyenda ambu, karem a mba nahi, an men jir hom haimba handambanda ma nira. Hako an angop a heyenda orik mashi orhin amu tiyanduwa. ");
INSERT INTO sim_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Misumu jihi Abraham os an takurin or hishihi rupshi mendendari ri. Hako am oson or heyehe sunguwavu orhi nga rupshiri ri.� ");
INSERT INTO sim_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Karem or mbarik limu mbara, �Mir asama mihi mbeek 50-n tikriwa ambu os te! Mberem ushiwak mir angop Abrahamin mi heyenda, karem mi mbandu!� ");
INSERT INTO sim_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Urik ormu sawera, �Omendingak jirin amu sawenduwa. Abraham or na namber, an angop maskop er a nahandari nir.� ");
INSERT INTO sim_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Karem or mbarik, li sunjakom loho orin li jikurik limu ura. Hako Jisas tempel akan or halaha mayam hikriyok ormu talara. ");
INSERT INTO sim_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas or ihi or heyeri misokome tumundari lar nombok ormu sira. Ma orto nijava orhi orin si wari wolokop misokome tumundari ria. ");
INSERT INTO sim_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Urik ol Jisasin tiyandari ma olmu silira, �Tisa, lawehi musak ma roto erem or nandu? Musa orhik mo avoko nijava frihi musak misokome orhi mu tumur?� ");
INSERT INTO sim_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Karem li silirik ormu mbara, �Orhi musak nembes, avoko nijava frihi musak nembes. Oso men erem si nashihindanak Avui Wasilaka kwambu orhi kormbak si nashinak ma li heyekmbahan. Os misambi torok a liwa wolo ukruharanda anira. Ter osmu tandik nanduwa. ");
INSERT INTO sim_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Uhu lerawun ni lakwa wolok osmu nanduwa. Nir avak Avui anhi or mbashirik a rahanda otohi lerawun ni laka. Hako nirik si nawa wolo ma lar mbeek lerawu las lakwa ambu ri, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas erem or mbashihi misambik or suntlayashihi suntla uku nga jere nga or toltloho ma otohi misokom mambuk ormu hautara. ");
INSERT INTO sim_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Uhu ormu mbara, �Mi ihi ukmashi Siloamik ujaka!� Siloam oso Hibru mashik maintontlo sihi karem, �Li mbashiwak li inda sir.� Karem or mbashirik or ihi nor ujarik misokome orhi jivik fri nashirik or heyehe ormu tara. ");
INSERT INTO sim_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Or tarik ma ol najer li lindari ma ondo nga ma anandi nga li heyeri or mbele mbelenjik lishi silindari ma ria. Orin li heyehe limu mbara, �Ayo, kar mbele mbelenjik lishi silindari ma or tori mo?� ");
INSERT INTO sim_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Urik lal mu mbara, �He, ma oto oria.� Hako lal mu mbara, �Wahau te! Ma lar ori te. Fumunyava orhi nakrem or nga nanda ri.� Urik ma orto mu mbara, �Ma or ji mbawa ma anira.� ");
INSERT INTO sim_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Urik limu silira, �Mberem mi uwak misokome mihi jivik fri naw?� ");
INSERT INTO sim_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Urik ormu mbara, �Ma or Jisas, karem li ushanda oto, suntla uku nga jere nga or toltloho jere oson or laha misokom mambu anhik or taha nor mbashiwak ukmashi Siloamik a ihi na ujawak misokome anhi opmu jivik nawa.� ");
INSERT INTO sim_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Karem or mbarik limu silira, �Ma orto mbeek or lindu?� Urik ormu mbara, �Ma am, or linda mishin a heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Urik orin li laha Farisi ondohik limu laha ira. ");
INSERT INTO sim_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas ma oton Sabat wolok or mbarik jivik nari ri. ");
INSERT INTO sim_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Urik Farisi ondo limu silira, �Mberem mi uwak misokome mihi jivik fri naw?� Urik ormu mbara, �Ma oto jere las misokom mambu anhik or taha nor mbashiwak a ujaha jip amu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Karem or sawerik Farisi lal olmu mbara, �Sabat wolok lerawun lawa ma oto mbeek Avui Wasilakahik tawa ambu ri.� Hako lal olmu mbara, �Wahau, or kavakavan unda ma ambu ri. Os kavakavan or undakop mbeek mbele las ma undahi ambun uwa ambu ri.� Karem li mbaha wavu lihi mbeek nakrem nari ambu sir, apshamba apshambak hishiri lir. ");
INSERT INTO sim_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Urik indik orin limu silira, �Mir mberem mi hishindu, ma or uwak misokome mihi jivik nawa ma oto mberemhi ma ri?� Karem li silirik ormu mbara, �Or profet oria.� ");
INSERT INTO sim_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Urik limu mbara, �Mir mbafirimbanda ma mira. Misokome mihi mbeek tumuri ambu vri.� Karem li mbaha ma otohi avoko nijavan li mbarik fri rarik limu silira, ");
INSERT INTO sim_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","�Toto jikisi shihi or? Nijava orhi nyirin, os orin nyi wari wolo misokome orhi er tumuri op? Os erem si nanda nahi, mberem ushiwak ter or heyendu?� ");
INSERT INTO sim_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Karem li silirik avoko nijava orhi ovro frimu mbara, �Jikisi shihi ria. Nijava orhi orin si wari wolokop misokome orhi angop tumuri vri. ");
INSERT INTO sim_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hako ter or heyewa oso shimu hishandu. Lawe mbawak misokome orhi jivik fri naw, oso shimu hishandu. Orin ji silika. Or angop wasilakak nawa ria. Mashin mbanda or te!� ");
INSERT INTO sim_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judama ondon fri ajehe mashi oson erem frimu sawera. Judama angop karem li anaowehe mbari lir, os ma lar or sawe nor mba, �Jisas Avui Wasilaka kamashirik hulaima nokopman jivinakurik tari ma ria,� karem mbawa ma oton avak ni kria ermbeshinak nir nga nakrem lotu ukwa ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Karem li mbari osik ma otohi avoko nijava frimu mbara, �Jikisi shihi oto angop wasilakak nahanda ria. Orin ji silika.� ");
INSERT INTO sim_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Urik indik ma oton li usharik or tarik limu mbara, �Misokome Avui Wasilakahik mashi ome nom mbaka. Ma or mi mbawa ma oton angop ni heyenda ri. Or kavakavan unda ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Urik ormu mbara, �An amu hishandu, kavakavan unda ma or mo wahau. Hako ana heyewa karem, mas misokome anhi tumundari sir. Hako ter amu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Urik orin indik limu silyangora, �Mberem mendem or uwak misokome mihi jivik fri nawa?� ");
INSERT INTO sim_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Urik ormu mbara, �Wahau te! Angop a sawewak ji misiwa os te! Misiwa ambu oj? Jir er nga orin tiyanda mak ji nakwak jimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Karem or mbarik orin li okolehe limu mbara, �Mir orin tiyanda ma mira. Hako nir Mosesin ni tiyanda nira. ");
INSERT INTO sim_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Avui Wasilaka mashi orhin Moseshi tavak or halari osik nir Moseshi mashin ni tiyanda nira. Hako ma or mi mbawa oton nir mbeek ni heyenda ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Urik ormu mbara, �Jir mberemhi mashin ji mbandu? Ma or misokome anhin uwak jivik a nawa ma oton jimu hishandu? ");
INSERT INTO sim_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Avui Wasilaka mbeek kavakavan unda ma sawewan misinda ambu ri, wahau. Hako ma or orhi mashin misindiyanda ma orto sawewan misinda ri. ");
INSERT INTO sim_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nir mbeek mas kaso kas ni heyendari ambu nir, os ma lar nijava orhi orin si wari wolokop misokome orhi tumundari lar li mbarik jivik or nari oson. ");
INSERT INTO sim_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Os Avui Wasilaka ma oto nga nor nawa ambukop or mbeek misokome anhin or uwak jivik nawa ambu vri.� ");
INSERT INTO sim_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Karem or mbarik Farisi ondo wavu lihi am kavak si narik limu mbara, �Mir nijava mihi jivikava nindik si wahanda mir. Erem nahanda ma mir mbeek Avui Wasilakahi mashin nirin ewesawendahi ambu mir.� Karem li mbaha orin limu kria ermbera. ");
INSERT INTO sim_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Urik Jisas os ma oton li kria ermberi mashi oson or misihi orin ormu lasa ira. Or lasa ihi am or heyehe ormu silira, �Mir, Ma Jikisi Avui Wasilakahi oton hishiowenda om?� ");
INSERT INTO sim_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Karem or silirik ormu mbara, �Awasayi, ma oto lawe ria? Anin sawenak avak orin a hishioweka.� ");
INSERT INTO sim_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Urik ormu mbara, �Angop mi heyeri or te! Anira, or mir nga shimu maimbanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Urik ormu mbara, �Wasilaka, ter mirin a hishiowenda nira.� Karem or mbaha hi Jisashin ormu hauowera. ");
INSERT INTO sim_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Urik Jisas mu mbara, �An misambi torok kavakava os ma li uhundan kormbak a mukukmbaha a rari nir. Uhu misokome tumundan a unak li heyekmbaha na rari nir. Hako ma ol mba, �An misokome anhi tumunda ambu sir,� karem mbawa ma ondo misokome lihi er a halashinak tumukwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Karem or mbarik Farisi lal orok li sihi mashi oson li misihi limu silira, �Mberem mi mbandu? Nir nga misokome tumunda nir, karem mimu mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Karem li silirik ormu mbara, �Os jihinjik ji mba, �Misokome nihi tumunda sir.� Os erem ji mba nahi, a unak jivik nakwa jir. Hako jir, �Nir misokome nihi jivi sira.� Karem ji mbanda osik kavakava jihi er nakwa sir, mbeek mendek nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Uhu Jisas mashi las nga ormu mbara, �Omendingak jirin amu sawenduwa, hirnyanda ma ondo os sipsip linda mishi orok li layiwa mbeek akayangak layinda ambu lir. Men inyin tarvlokoho layinda lir. ");
INSERT INTO sim_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hako sipsip mashama oto akayangakop inda ri. ");
INSERT INTO sim_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Or tawa wolo akayangan washilinda ma orto akayangan or sutlashiwak layinda ria. Or layihi nor ushawak sipsip ondo mandarjinya orhin misinda lir. Hi lihin namtarmba namtarmbak or ushaha or halashiwak hikriyok layinda lir. ");
INSERT INTO sim_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hikriyok li layiwak or maifu iwak sipsip orhi ondo mandarjinya orhin angop li misinda osik orin tiya inda lir. ");
INSERT INTO sim_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hako ma or li heyenda ambu oto or rawa wolo mbeek orin tiyanda ambu lir. Mberem ushiwak? Lir mbeek mandarjinya orhi kas misinda ambu lir.� ");
INSERT INTO sim_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas mashi oson sauheimakop or saweri sir. Hako ma mbeek mashi os or mbarin yariri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Urik ormu mbara, �Omendingak jirin amu sawenduwa, sipsip ondo akayanga lihi anira. ");
INSERT INTO sim_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ma ol masmas tahanda ma ondo hirnyanda ma lira. Hako sipsip ondo mbeek mandarjinya lihin misinda ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","An akayanga anira. Ma ol anhik rawa akayangan a sutlashinak ermba ermbak linda oso lihik si nanak li ilaitalaha akwan akwa ola. Unak armek a eweukwa ola. ");
INSERT INTO sim_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hirnyanda ma oto men or raha hirnyaha mbele mbelen jila mandingorme lakwak takwa ria. Hako an os a rawa karem, os ermba ermbak linda oson jirin a hakwak a rawa nir. Ushinak jipjip ji likmbahan. ");
INSERT INTO sim_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipsip anhi ondonjik a hishiwa osik a hakwa nir. Uhu antonom sipsip mashama jivi anira. ");
INSERT INTO sim_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Hako ma or sipsipin washilihi ya nowen landa oto mbeek sipsip ondonjik hakwa ambu ri, wahau. Mberem ushiwak? Or sipsipin washilinda ma indingo ambu ri. Or mashama ambu ri. Or mbeek sipsip ondonjik holonda ambu ri. Karem uwosik kala asa sipsipin li shiakmbaha li rawa wolo ma oto sipsip ondon or halaha tulu ikwa ora. Ushinak sipsip ondo nimbli namble li tulu inak kala asa shiakwa ola. ");
INSERT INTO sim_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","An Avui anhin a heyewak or anin heyenda ria. Uhunda hom sipsip anhi ondo erema. An lirin a heyewak lir anin heyenda lir. An sipsip mashama jivi anira. Lirnjik a hishiwa osik a hakwa nira. ");
INSERT INTO sim_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipsip anhi ol inyi anandik siwa ondo er nga mashi anhin li misikmbaha a rari nir. Uhu lirin a laharanak sipsip anhi amber inyi namtaskop li sinak antonom a washilikwa lira. ");
INSERT INTO sim_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Lirnjik a hishiwa osik anhinjik ma kavahi tavak a hanak li jimandingormeshinak a haha indik a usahakwa nira. Erem a uwa nombo orok Avui anhi anin rupshikwa ria. ");
INSERT INTO sim_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma lar mbeek anin jimandingormendahi ambu ri, wahau. An anhinjik ma kavahi tavak a hakwa nir. Os a hakwa nga os indik a usahakwa nga an anhi tavak a tolonda sir. Avui anhi anin or mbashirik lerawu oson a lakurik a rari ona.� ");
INSERT INTO sim_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Karem or mbarik Judama mashi oson li misihi lihi ambek kraha frijip limu sira. ");
INSERT INTO sim_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lal karem limu mbara, �Toto wasimalengamba tolonda osik ormu ambarambasinda hom mbanduwa. Mberem ushiwak mashi orhin ji misindu?� ");
INSERT INTO sim_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Urik lal olmu mbara, �Wahau, mashi os or mbawa mbeek wasimalengamba tolonda hom mbawa ambu ri. Wasimalengamba mbeek misokome tumundan li uwak jivik nanda ambu lir!� ");
INSERT INTO sim_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Urik hiyawu wasilakan Jerusalemik li undari wolok simu nara. Oro wolo ma nom ma nom si rakari wolok nari sira. ");
INSERT INTO sim_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Urik Jisas tempel akak or ihi akanivi Solomonhi, karem li ushandari akanivi orok ormu layishihi yara. ");
INSERT INTO sim_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Urik Judama lal li raha orin li rurawuhu limu silira, �Mberem jishi wolo mendek kormbak mi sawenak ni misiku, mir Krais Avui Wasilaka kamashirik hulaima nokopman jivinakwa ma mir mo wahau?� ");
INSERT INTO sim_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Urik ormu mbara, �Angop a sawewa ok te. Hako jir mbeek mashi anhin misinda ambu jir. Mbele mbele ol hi Avuihik a uwa ondo olmu jirin mukunduwa, an lawe mende anira. ");
INSERT INTO sim_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hako jir mbeek sipsip anhi ambu jir. Uwosik jir mbeek mashi anhin misinda ambu jir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hako sipsip anhi ondo mandarjinya anhin li misihi anin tiyanda lir. Uwak angop a heyenda lir. ");
INSERT INTO sim_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Unda osik ermba ermbak linda oso avak lirin a hakwa sir. Ushinak lihi lal mbeek haha mendek nakwa ambu lir, wahau. Ma lal mbeek lirin tavarenje anhik masna laha ikwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mberem ushiwak? Avui anhi angop anin or hahanda lir. Ma lar mbeek kwambu os orhik nahanda hom nanda ambu ri. Unda osik ma lar mbeek sipsip orhi ondon tavarenje orhik masna laha ikwa ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","An nga Avui anhi nga shir namtaskop shi nanda shira.� ");
INSERT INTO sim_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Karem or mbarik Judama sunjakomben indiyok li loho orin limu jikmbaha ura. ");
INSERT INTO sim_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Erem li urik ormu silira, �Avui anhi or mbashirik lerawu jivi ol a lari angop ji heyeri ol te. Wa mberemhi lerawu os a lawak kavak si nawak ji heyehe anin ji sunjakom loho ermbekwak ji undu?� ");
INSERT INTO sim_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Urik limu mbara, �Lerawu os mi lawa nombo yok nembes. Mir men ma mira. Hako mir mihinjik Avui Wasilakahi farniyik mi sikwak mi mbawak os nimu sunjakom loho ni jikmbaha nimu unduwa.� ");
INSERT INTO sim_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Karem li mbarik ormu mbara, �Mashi os jekamba Avui Wasilakahik li kayehendarin heyenda ambu oj? Karem li kayeri sir, Avui Wasilaka karem or mbari ora, �Ma jir jihinjik god jira.� ");
INSERT INTO sim_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jekamba orhik li kayeri mashi mbeek mendek nakwa ambu sir, wahau. Avui Wasilaka orhinjik ma ol mashi orhin misiwa ma ondon godik or mbari lir. ");
INSERT INTO sim_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Os erem orhinjik or mbahanda nahi, mberem ushiwak anin ji wapkava hishindua, os a mba, �An jikisi orhi anira.� Or orhinjik anin or kamaha nor mbashirik misambi torok a rari ona. ");
INSERT INTO sim_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Os lerawu orhin a lana ambu nahi, wa mashi anhin ji misiwan ji hala. ");
INSERT INTO sim_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hako lerawu os a lawa oso osmu jirin mukunduwa, an Avui kamashirik a rari nira. Karem uwosik os mashi anhin ji misihi ji tiyana ambu nahi, wa, lerawu os a lawa yejen ji heyehe ji hishika, or ormu anhik sinduwa.� ");
INSERT INTO sim_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Karem or mbarik orin li toltangrikmbaha li urik lirin or masna ermbehe ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uhu or layihi fa Jordanin or mbuhu kauyok or lawuhu os Jon hulaima nokopman fak or tolofalendari mishi orok ormu wara. ");
INSERT INTO sim_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Urik ma musha orhik li raha limu mbara, �Ayo, Jon mbeek mbele las ma undahi ambun uri ambu ri! Hako mashi ma orton or sawembari omendinga sira. Ter os nimu heyenduwa.� ");
INSERT INTO sim_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Karem li mbaha Jisasin wavu lihik li ewehe limu mbara, �Ome sira, ma oto Krais oria.� ");
INSERT INTO sim_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma lar kavamisiri ria. Hi orhi Lasarus oria. Or jikaha orhi Marta fre Maria nga yanga Betanik lindari lira. ");
INSERT INTO sim_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria mas wel uku os arme kuvasahandarin Jisashi kumbasantlek si ngoroho masikukwak fiyindari nokove sira. Lasarus oto mundala sihi ria. ");
INSERT INTO sim_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Urik Jisasin fri mainhaha frimu mbara, �Wasilaka, naimble mihi am or kavamisihi hakwak naw te!� ");
INSERT INTO sim_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Urik Jisas mashi oson or misihi ormu mbara, �Lasarus os or kavamisiwa oso mbeek or hakwak nawa ambu sir. Oso Avui Wasilaka kwambu orhin or mukunak ma amber li heyekwa sir. Unak or nga jikisi orhi nga hi frihin li hauowekwa vria.� ");
INSERT INTO sim_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas Lasarus nga jikaha orhi Marta fre Maria nga or rupshi mendendari lira. ");
INSERT INTO sim_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hako Lasarus or kavamisiri mashi oson or misihi niri frijip os or liri mishi orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Niri frijip am fri ishirik ol orin tiyandari man ormu mbara, �Ka ni provins Judiak indik ni ika.� ");
INSERT INTO sim_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Urik limu mbara, �Tisa, mberem ushiwak indik orok mi ikmbaha mi mbandu? Akri mende mirin li mandingormekurik li mbari os te!� ");
INSERT INTO sim_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Karem li mbarik ormu mbara, �Tandi wolo lerawun ni landa nir. Hako si krinyawa wolo mbeek lerawun ni landa ambu nir. Ma ol ta jiwa wolok yanda ondo mbeek takatukuyinda ambu lir. Harawak heye yanda ola! ");
INSERT INTO sim_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hako ma ol nirik yanda mbeek haranda nga nanda ambu olik takatukuyinda lir.� ");
INSERT INTO sim_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Uhu ormu mbara, �Naimble nihi Lasarus ormu wa suknyanduwa. Avak a ihi lembasinak usahakwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Urik olmu mbara, �Wasilaka, os or kavamisihi or suknya nahi, avak jivik nakwa ria.� ");
INSERT INTO sim_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasarus angop hari ri. Hako lir mbeek os or mbari mashin yariri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Urik kormbak ormu sawera, �Lasarus angop hari ria. ");
INSERT INTO sim_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hako amu rupshinduwa. Avak a ihi mbele las ma undahi ambun a unak ji heyehe os anin ji hishiowenda nombo jihi oso wasilakak nakwa sira. Os or hari wolo orok a lirikop, mbeek mbele las os ter a mukunak ji heyekwan a mukuri ambu nir. Hako ter avak a unak ji heyekwa sir. Ka ni ika yanga orok.� ");
INSERT INTO sim_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Karem or mbarik orin tiyandari ma lar hi orhi Tomas, hi yeje orhi Didimus, ormu mbara, �Wa, ka ni ihi or nga ni haka!� ");
INSERT INTO sim_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Urik Jisas yanga Betanik or taha or misiri Lasarus angop li wakor eweshirik niri tovro kavrok wak wari ri. ");
INSERT INTO sim_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani oso Jerusalem mavayok nanda sir. Betanik sishihi Jerusalemik inda oso 3 kilomita hom nanda sir. ");
INSERT INTO sim_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Karem uri osik Judama musha mendek li raha Marta fre Maria nga Lasarushi mangrahak limu lira. ");
INSERT INTO sim_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Urik Marta si misirik Jisas or tarik akan si hala tirnaha orin si heyekmbaha simu tala ira. ");
INSERT INTO sim_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Am si i heyehe simu mbara, �Wasilaka, os torok mi lirikop mundala anhi mbeek hari ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hako amu hishinduwa, os Avuin mi silinak mbele las or ha, karem mi mba nahi, avak or hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Karem si mbarik ormu mbara, �Mundala nyihi avak usahakwa ria.� ");
INSERT INTO sim_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Urik simu mbara, �He, kumak ma ol hahanda indiyok li usahakuna wolo er nga usahakwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Urik ormu mbara, �Ma ol mashi anhin misindiyawa ma ondo os li hawa masikome lihi mbeek hakwa ambu lir, ermba ermbak likwa lir. Antonom ol hahandan a mbanak indiyok usahakwa lir. Uhu ermba ermbak linda oson a hakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mashi anhin li misindiyawa osik ermba ermbak linda oso angop lihik nari sir. Hako os li hawa wolo maome lihi nom kuvayikwa lir. Hako masikome wahau.� Karem or mbaha ormu silira, �Nyir mashi kas a mbawa omek si nakwak nyimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Karem or silirik simu mbara, �He, Wasilaka, mir Krais Avui Wasilakahi jikisi indinga mira. Angop maskop hulaima nokopman mi jivinakurik or mbahandari ma mira. Karem amu hishinduwa.� ");
INSERT INTO sim_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Urik Marta indik akak si layihi mayam Maria nom simu sawera, �Jisas angop rawa ri. Uhu nyirin heyekwak ormu mbanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Karem si mbarik, kolok Maria si usaha Jisasin si heyekmbaha simu ira. ");
INSERT INTO sim_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hako Jisas mbeek yangak tari ambu ri. Men nombo os Marta orin si i heyeri mishi orok er siri ria. ");
INSERT INTO sim_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Urik ma ol Maria nga aka orok mangrahak liri ondo hikrik si layirik li heyehe sirin limu tiya ira. Sir mawak si i tla, karem li hishihi sirin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Urik Maria Jisasin si heyehe kumbamu orhik si raka lihi simu mbara, �Wasilaka, os torok mi lirikop mundala anhi mbeek hari ambu ri.� Karem si mbaha simu tlara. ");
INSERT INTO sim_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas or heyeri Maria osmu tlara. Urik ma ol sir nga nakrem tari ondo er nga limu tlara. Ushirik sunguwavu orhi nga nor holoho ormu tlakurik hishira. ");
INSERT INTO sim_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Uhu ormu silira, �Mbeek ji eweshihindak or wandu?� Urik limu mbara, �Wasilaka, ta heyeka, tor torok wandu.� ");
INSERT INTO sim_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Karem li mbarik ormu tlara. ");
INSERT INTO sim_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Urik limu mbara, �Ji heyeka, Lasarusin rupshi mendenda toria.� ");
INSERT INTO sim_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hako lal limu mbara, �Or misokome tumundarin mbarik jivik nari lir. Hako mberem ushirik ma roton or mbanak jivik or nakurin or halashirik or har?� ");
INSERT INTO sim_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Urik Jisas sunguwavu orhi nga nor holoho mawak ormu ira. Mawa oso telakak li tloho sunja wasilakak li aragohondari sir. ");
INSERT INTO sim_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Urik Jisas ormu mbara, �Sunja laka oson ji tembeka!� Urik Marta mu mbara, �Wasilaka, niri tovro kavrok angop wak wari or te. Kuva avak kavak nakwa re.� ");
INSERT INTO sim_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Karem si mbarik ormu mbara, �Angop a sawewak nyi misiwa os te! Os mashi anhin nyi hishiowe nahi, kwambu Avui Wasilakahin avak nyi heyekwa sir!� ");
INSERT INTO sim_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Urik sunja oson limu tembe haiewera. Urik Jisas lersuwu yok or larasa mawuhu Avui orhin ormu sawera, �Mir mashi os a sawendan mi misinda osik armesarmek mirin amu mbanduwa. ");
INSERT INTO sim_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mir mashi anhin ermba ermbak misinda mira. Hako mashi kas a mbawa kaso ma tol torok siwa li heyekmbaha amu mbanduwa. Unak li heyehe li mba, �Ome sira. Ma roto Avui Wasilaka mbashirik tari toria.� � ");
INSERT INTO sim_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Karem or mbaha ormu ushara, �Lasarus, mir hikrik tala!� ");
INSERT INTO sim_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Urik Lasarus hikrik ormu talara. Kumba tava fumunyava orhin angop waskowarmbak li ishi arangori ri. Urik ormu mbara, �Kowe ondon ji tloloshinak or ika.� ");
INSERT INTO sim_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Urik ma ol Maria nga mangrahak liri ondo os Jisas uri oson li heyehe limu mbara, �Ome sira, ma oto Avui Wasilaka kamahanda ma ria.� ");
INSERT INTO sim_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Hako lal li ihi Farisi ondon li i heyehe mbele mbele os Jisas urin limu sawera. ");
INSERT INTO sim_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ushirik bikpris nga Farisi nga mashi oson li misihi Judama lida lihin li usharik ma amber li talandirsaha limu mbara, �Wa, avak mberem ni uku? Ma roto mbele las ma undahi ambu musha mendek or unda re! ");
INSERT INTO sim_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hako os ni halashinak lerawu oson er or la nahi, ma amber avak orin li tiyaha orin malakama lihik li mbashinak Romik fehenda ma ondo avak li raha tempel aka nihin li jilatarvlalaha nir nga avak li jila mandingormelakwa nira.� ");
INSERT INTO sim_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Karem li mbarik lihi nindik ma lar ormu usasira. Ma oto Kaiafas oria. Asama oro wolok hetprisik nari ri. Or usasihi ormu mbara, �Jir hishiyarimbawa kom te! ");
INSERT INTO sim_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Halanak ma namtar nir ma Israelik fehenda nirnjik or haka! Las avak nir amber ni handa ngashi.� ");
INSERT INTO sim_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas asama oro wolo hetprisik or nari osik mashi oson mbeek orhik or hishihi mbari ambu ri. Profet hom or mbari sira, os Jisas Judamanjik or hakurin. ");
INSERT INTO sim_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hako Jisas mbeek Judamanjikop hari ambu ri, wahau. Ma amber lirnjik hari ri. Ushinak Avui Wasilaka ma amber or lahara tirsashinak kraha namtaskop li naha orhi jikisik li nakmbahan. ");
INSERT INTO sim_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oro wolok Judama lida lihi nombo nombo os Jisasin li mandingormekurin limu lasara. ");
INSERT INTO sim_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Erem nari osik Jisas mbeek kormbak provins Judia orok yari ambu ri. Judian or halaha misamtelmbamba mavayok or ihi yanga Efraimik ol orin tiyandari ma nga limu lira. ");
INSERT INTO sim_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hiyawu wasilaka Pasovan li ukuri wolo si na namber. Hako Judama yanga yangak fehe Jerusalemik masmas li taha misokome Avui Wasilakahik jivik li nakmbaha mbele mbele ujanda nombon li uhu limu hundujera. Uhu Pasova oso si talakuri wolon limu nikishira. ");
INSERT INTO sim_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Uhu Jisasin li heyekurik tempel akak li ihi lihi ambek limu mbara, �Jisas am takwak jimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hako Judama lida lihi nga Farisi nga angop karem li sauhambari ola, �Os Jisasin lasik ji heye nahi, ji ra sawenak ni i toloka.� ");
INSERT INTO sim_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Judama hiyawu wasilaka Pasovan li ukuri niri 6-pela li ishinakop li ukurik nari sir. Oro wolok Jisas yanga Betanik Lasarus, ma or harik or mbarik usahari oto nga, frimu lira. ");
INSERT INTO sim_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Urik hiyawu las Jisas nga li akmbaha limu ura. Akurin li urik Marta mu akwan lala lahara owera. Urik Lasarus er nga orok or lihi akwan nakrem limu ara. ");
INSERT INTO sim_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Am li arik Maria si raha wel uku arme kuvasahandarin lakak si laha Jisashi kumbak si ngoroho masikukwa sihik simu tara. Wel uku oso hi sihi nardus, ya lakak li frungawundari sir. Uku oso si ngororik aka oson simbalesik armek simu kuvasahara. ");
INSERT INTO sim_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Urik Jisasin tiyandari ma lar, hi orhi Judas Iskariot oria, or kumak Jisasin ma kavahi tavak hakundari ma ria, ormu mbara, �Ayo, mberem ushiwak wel uku arme kuvasahanda oson nyi ngoro sambundua. Oson nyi halashiwak ni lai ya 300 silvan ni laha ol erndakava ondon ni handahi os te!� ");
INSERT INTO sim_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hako or mbeek erndakava ondonjik holori ambu ri. Or hirnyanda ma ri. Or ma ol Jisasin tiyanda ma ondo ya lihin tolondari ma ri. Hako ya ondo mbeek armek or ewendari ambu ri. Ya ondon or laha orhinjik mbele mbele orhi nom landari ri. ");
INSERT INTO sim_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Urik Jisas ormu mbara, �Erem mbawa hala! Sirin halanak si lika. Os erem si uwa oso na hakunda nombon osmu hundujenduwa. ");
INSERT INTO sim_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Erndakava ondo jir nga ermba ermbak likwa lir. Hako an mbeek jir nga nambek a likwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judama musha Jisas Betanik or lirin li misihi orin heyekmbaha limu ira. Hako orto nom nembes. Lasarus or harik Jisas mbarik usahari oto nga li heyekmbaha limu ira. ");
INSERT INTO sim_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ma musha Jisas os orin or uri oson li misihi Judama lida lihin li halaha Jisasin limu tiya ira. Karem uri osik bikpris ondo Lasarusin er nga li jimandingormekurik limu mbara. ");
INSERT INTO sim_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Ma musha mendek Jerusalemik hiyawu Pasovan li ukmbaha limu tirsara. Urik Jisas orok or takuri mashin li misihi orin li heyekmbaha limu ira. Uhu siyando tavan li tlehe laha irik or tarik orin limu owehe mblara, �Hosana, ka ni rupkapshihi hi Avui Wasilakahin ni hauoweka! Ma or or kamashirik hi orhik tawa ma oton ni hauoweka. Ma oto nir ma Israelik fehenda king nihi ria.� ");
INSERT INTO sim_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Urik Jisas donki las or heyehe donki heyek ormu lawuhu lira, os mas wolok Avui Wasilakahi jekambak li kayendari hom. ");
INSERT INTO sim_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mashi oso karem li kayeri sir, �Hulaima nokopma ol yanga Saionik fehendan karem ji saweka, king jihi avak jihik takwa ria. Uhu donki akri lasik or lawu lihi jirik takwa ria.� ");
INSERT INTO sim_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hako oso wolo Jisasin tiyandari ma ondo mbeek mashi os erem Jisasin si mbarin yariri ambu lir. Hako or haha indiyok or usahari wolokop mashi os profet oto or kayeri oson indik li hishiyariri lir, profet oto or mbari Jisasin mbari ri. ");
INSERT INTO sim_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma ol Jisas Lasarusin or mbarik or usaharik heyeri ma ondo mashi oson li haisau handasawe irik, ");
INSERT INTO sim_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ma mushak li misihi Jisasin limu tiya ira. ");
INSERT INTO sim_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Urik Farisi ondo lihi ambek limu mbara, �Ayo, mberem ni ukuwa ambu re! Ma rondo amber hom am orin tiyarakor te!� ");
INSERT INTO sim_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hiyawu Pasovan li undari wolo yanga Grikik fehendari ma lal er nga Jerusalemik li lotu ukmbaha limu tara. ");
INSERT INTO sim_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Uhu Filip provins Galili yanga Betsaidak fehendan li i heyehe orin limu silira, �Awasayi, nir Jisasin ni heyewa kom te!� ");
INSERT INTO sim_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Karem li mbarik Filip or i Andrun or sawelaha Jisasin frimu i heyera. ");
INSERT INTO sim_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Urik Jisas mu mbara, �Ma Jikisi Avui Wasilakahi oto malakamak or nakwa wolo am pasir naw. ");
INSERT INTO sim_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Omendingak jirin amu sawenduwa, os wit siji las misambik si rakana ambu nahi, mbeek ome nga nakwa ambu sir. Avak siji oso nom er wakwa sir, mbeek ome nga nakwa ambu sir. Hako os siji oso si rakaha si tungua rasa nahi, akwa ome nga mushak nakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Uhunda hom misambi torok ji liwa wolo os jihikop ji hishi nahi, kumak mendek nakwa jir. Hako os jihikop ji hishiwan ji halaha Wasilakan ji hishiowe nahi, kumak avak ermba ermbak linda oson lakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Os lerawu anhin ji lakunak ji hishi nahi, wa anin ji tiyaka. Uhu yanga os a liwa mishi orok er nga ni lika. Ushinak kumak Avui anhi hi jihin metenjek or hauowekwa jira.� ");
INSERT INTO sim_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Uhu ormu mbara, �Sunguwavu anhi osmu kavak nanduwa. Hako mberem a mbaku? Avui, nomorawu anhik talakwa oson mi laha ermbenak si i. Karem a mbakwa on mo? Wahau. Erem a mbakwa ambu nir. Nomorawu oson halanak si talaka. Osonjik a rari ona. ");
INSERT INTO sim_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Avuya, mir avak kwambu mihin kormbak mukunak li heyeka. Unak hi mihi wasilakak si naka.� Karem or mbarik mashi las hevenik simu mbara, �Angop a mukuri sir. Uhunda osik ter avak indiyok a mukukwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Urik ma ol pasir siri ondo mashi oson li misihi lal limu mbara, �Ma kas krundu te.� Hako lal olmu mbara, �Wahau, ensel ome lar nga op maimbandu.� ");
INSERT INTO sim_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Karem li mbarik Jisas ormu sawera, �Mashi kas ji misiwa kaso mbeek anin jelyakmbaha mbawa ambu sir, wahau. Jirin jelyakmbaha sawewa sir. ");
INSERT INTO sim_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Avui Wasilaka ma misambik fehenda mbele mbele ol li uhundan or heyembakwa wolok osmu nanduwa. Uhu ma or misambi toson sifasahanda oton or jikria ermbekwa wolok osmu nanduwa. ");
INSERT INTO sim_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ter misambi torok amu linduwa. Hako avak anin miandok li hauowekwa nir. Ushinak ma musha anhik a laharakwa nir.� ");
INSERT INTO sim_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas or hakundari mashin karem ormu saweri sir. ");
INSERT INTO sim_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Karem or sawerik limu mbara, �Mashi os jekamba Moseshik li kayendari karem mbanda sir, Krais ma or Avui Wasilaka kamashirik hulaima nokopman jivinakwa ma oto mbeek hakwa ambu ri, ermba ermbak likwa ri. Karem li kayehendarin angop ni heyenda sir. Hako mir mberemhi mashi tos ter mi mbandu, Ma Jikisi or hakwan? Ma Jikisi Avui Wasilakahi oto lawe mende ria?� ");
INSERT INTO sim_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Karem li silirik ormu mbara, �An mbeek jir nga nambek a likwa ambu nir. Mashi anhi os jirin a sawewa oso ukruharanda hom nanda sir. Os jir nga a liwa wolo ukruharanda anhi orok ji yaka. Ma or nirtle nirndum yanda oto mbeek os or ikwa mishin heyenda ambu ri. Uhunda hom ma ol mashi anhin mblarnawa ondo mbeek os li ikwa mishin heyenda ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hako ter ukruharanda anhi osmu jir nga nanduwa. Uwosik jir avak ukruharanda oson kwambuk ji toloho ji tiyaka. Uhu ma ol ukruharandak yanda hom ji naka.� Karem or mba lafakaha yanga lasik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ma musha mbele mbele ma undahi ambu ol Jisas or uri ondon angop heyeri lir. Hako mbeek mashi orhin misindiyari ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Erem li uri osik mashi os profet Aisaia maskop or kayendari omendingak nari sir. Karem or kayeri sir, �Wasilaka, lawe mende mashi kas ni mbawa kason misindiyaku? Lawe mende mbele mbele ma undahi ambu ol mi uwan heyehe mba, �Omendinga sira, Wasilaka toria.� Karem mbaku?� ");
INSERT INTO sim_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Hovok Aisaia mashi las nga karem or kayeri sir, �Avui Wasilaka or mbanak ma ondo misokome lihi avak si tumushinak heyekwa ambu lir. Uhu or mbanak sunguwavu lihi avak sunjakombe hom nakwa sir. Karem uwosik lir mbeek sunguwavu lihin li tormblehe anhik li ranak a mbanak jivik nakwa ambu lir.� Profet Aisaia karem or kayehendari osik ma ondo mbeek Jisasin wavu lihik li owekurik nari ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mas wolokop profet Aisaia kwambu Jisashi os kumak kormbak talakundari oso angop or heyeri osik mashi kason or kayeri sir. ");
INSERT INTO sim_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judama lida lihi lal Jisasin wavu lihik eweri lir. Hako las avak Farisi ondo lirin li kria ermbeshinak nakrem li lotu unda oson li halaku, karem mbaha li ajehe mbeek oson kormbak saweri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lir mbeek Avui Wasilaka hi lihin or hauowekmbaha hishindari ambu lir, wahau. Lir men ma misambik fehe hi lihin li hauowekmbaha hishindari lir. ");
INSERT INTO sim_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Urik Jisas wasilakak ormu sawera, �Os mashi anhin ji misindiya nahi, jir mbeek antonom misindiyanda ambu jir, wahau. Avui anhi or mbashirik a rahanda mashi orhi nga os jimu misindiyanduwa. ");
INSERT INTO sim_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Uhu os anin ji heye nahi, mbeek antonom heyenda ambu jir, wahau. Avui anhi or jimu er nga heyenduwa. ");
INSERT INTO sim_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","An ukruharanda hom misambi torok a tari nir. Ushinak ma ol mashi anhin misindiyawa ma ondo mbeek nirtle nirndum yakwa ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hako an mbeek ma ol mashi anhin misindiyawa ambu ondon a kotim ukmbaha a rari ambu nir. Erem nanda ma ondon a jivinakurik a rari nir. ");
INSERT INTO sim_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hako ma ol anin kumasihi mashi anhin mblarna ermbewa ma ondo kumak mbele mbele mendek si nakuna wolok si nanak mashi anhi os li kumasinda oso vai lirin kotim ukwa sir. ");
INSERT INTO sim_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mashi kas a mbawa kaso mbeek wavu anhik a hishihi a mbawa ambu nir. Avui anhi or mbashirik a rahanda oto orhi mashi sira. Or sawewa nombo hom os amu jirin kormbak sawenduwa. ");
INSERT INTO sim_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mashi orhi oso nom ermba ermbak linda oson handa osa. Uwosik mashi amber ol a mbawa ondo os or sawenda hom os amu sawenduwa.� ");
INSERT INTO sim_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hiyawu Pasovan li ukuri wolo am pasir simu nara. Jisas angop or heyeri sir, os misambi toson or halaha indik Avui orhik or lawukurin. Or orhi ma ondon or rupshihi wapnuku orhik lirin or ewehe lirnjik or hakurin kormbak or mukuri lir. ");
INSERT INTO sim_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Am si krinyarik akwan li aha limu lira. Judas jikisi Saimon Iskariothi oto er nga orok liri ri. Laulaka mashi os Jisasin ma kavahi tavarenjek or hakuri oson angop wavu orhik or eweri sir. ");
INSERT INTO sim_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas angop or heyeri sir, Avui orhi kwambu angop orin or hari osik mbele mbele ondo amber orhi siyokop sirakori lir. Uhu misambik or liri am mendek si nanak indik Avui orhik or ikuri wolok si narik. ");
INSERT INTO sim_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Uri osik akwan li ashihi or usaha kousamba orhin or tlolo haiewehe kowe las or laha jinkupsumbu orhik ormu ishitivira. ");
INSERT INTO sim_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uhu uku kas hambiyak or ngoroho ma ol orin tiyandari ondohi kumban yokokurik ormu ura. Kumba lihin or yokoho kowe os jinkupsumbuk or tiviri orok ormu tara. ");
INSERT INTO sim_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kumba lihin or yoko ihi Saimon Pitahi kumban or yokokmbaha ormu ura. Urik Pita mu mbara, �Wasilaka, mberema kumba anhin mi yokokwak mimu hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Urik Jisas mu mbara, �Mbele mbele os ter a uwak mi heyewa oso ter mbeek mi yarikwa ambu sir. Hako kumakop mi hishiyarikwa sir.� ");
INSERT INTO sim_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Karem or mbarik ormu mbara, �Mir mbeek kumba anhin yokondahi ambu mir, wahau.� Urik ormu mbara, �Os mirin a yoko nahi ambu, mir mbeek an ngashi likwa ambu mir.� ");
INSERT INTO sim_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Karem or mbarik ormu mbara, �Wasilaka, os erem si naku nahi, wa kumba nom yokowa hala! Wa, simbalesik kumbatava masiji anhi nga yokoka!� ");
INSERT INTO sim_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Urik ormu mbara, �Ma or ujahanda mbeek indik ujakwa ambu ri. Hako kumba nom or yokoho jivik nakwa ri. Jir angop ji ujaha jivik nari jir. Hako an mbeek jir amber hom a mbawa ambu nir. Namtar jihi mbeek jivik nawa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas ma or orin tavarenje wutarihik hakuri ma orton angop or heyeri osik ormu mbara, �Namtar jihi mbeek jivik nawa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas am kumba lihin or yokorakoshihi kowe oson indiyok or falehe or taka lihi ormu silira, �Jir tos karem a uwa maintontlo sihin am jimu hishiyarindu? ");
INSERT INTO sim_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jir an Tisak mbanda jir. Uhu anin, Wasilaka jihi, karem anin mbanda jir. Wa, jivi sira, os erem ji mbanda oson. An Tisa jihi nira. An Wasilaka jihi nira. ");
INSERT INTO sim_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hako kumba jihin angop a yokowa sir. Uwosik kumak jir nga ji ihi ma anandi ondo kumba lihin erem ji yokoka. ");
INSERT INTO sim_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nombo os amu mukunduwa. Jir erem ji uka, os jirin a uwa hom. ");
INSERT INTO sim_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Omendingak jirin amu sawenduwa, ma or malakamanjik lerawun landa ma oto mbeek malakama orhin tikrihi hausinda ambu ri. Uhu mashin lahara sawenda ma oto mbeek mainhanda man tikrihi hausinda ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ter nombon a mukushiwak ji heyewa sir. Uwosik os jirin a uwa hom, jir erem ma anandin ji uka. Os erem ji u nahi, Avui Wasilaka armek or ukwa jir. ");
INSERT INTO sim_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Hako an mbeek jir amber a mbawa ambu nir. Ma ol a kamahanda angop a heyewa lir. Mashi os jekamba Avui Wasilakahik karem li kayeri oso osmu omek nakwak nanduwa. �Ma or an nga shi awa ma oto wutari anhik nakwa ria.� ");
INSERT INTO sim_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Oso mbeek tala namber. Hako avak a sawendanak kumak kormbak si talanak ji hishihi ji mba, �Ome sira, Jisas ma or or mbari oria.� ");
INSERT INTO sim_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Omendingak jirin amu sawenduwa, ma ol anjik lerawun landa ondon a mbashinak ikwa lir. Ol lirin armek uwa ma ondo os erem li uwa anin er nga armek li uwa sir. Hako antonom nembesa, Avui anhi or mbashirik a rahanda er nga armek li uwa sira.� ");
INSERT INTO sim_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas mashi oson or sawerakoho sunguwavu orhi nga nor holoho kormbak ormu mbara, �Omendingak jirin amu sawenduwa, jihi lar avak anin wutarihi tavarenjek hakwa ria.� ");
INSERT INTO sim_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Karem or mbarik orin tiyandari ma ondo lihi ambek li anaheyehe limu mbara, �Lawe menden or mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Urik Saimon Pita ma or Jisas rupshi mendendari or Jisas nga nakrem fri liri ma oton masijikop ormu jiermbera, Jisasin or silikmbahan. ");
INSERT INTO sim_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Urik ma oto kar nga nor hailihi Jisasin ormu silira, �Wasilaka, lawe menden mi mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Urik ormu mbara, �Ma or a mbawa oto avak bret kas a toltavaha ukuk a halfalehe na hanak akwa ri. Erem a uwa ma oto oria.� Uhu bretin or toltavaha ukuk or halfalehe Judas jikisi Saimon Iskariothin ormu hara. ");
INSERT INTO sim_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas akwan am or arakorik Laulaka, kolok, sunguwavu orhik ormu layira. Urik Jisas orin ormu mbara, �Mbele las mi ukwak mi hishi nahi, kolomalok uka.� ");
INSERT INTO sim_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma ol nakrem li lihi ari ondo mashi os Jisas Judasin or mbarin limu misira. Hako lir mbeek maintontlo os or mbarin yariri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ya lihin ewendari orik lal limu hishira, �Jisas Judasin or mbashinak or ihi mbele mbele lal or frungawuhu lahara hiyawu wasilakan ni ukmbaha mbandar mbe.� Hako lal olmu hishira, �Mbele mbele erndakava ondon or hajehe mbandar mbe.� Karem olmu hishira. ");
INSERT INTO sim_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Urik Judas bretin or a lafakaha hikrik or layirik er simu tangna arangora. ");
INSERT INTO sim_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas am hikrik or layishirik Jisas ormu mbara, �Ma Jikisi Avui Wasilakahi oton li hauowekwa wolo am pasir naw. Orin erem li uwa nombo orok Avui Wasilaka hi orhi wasilakak nakwa sira. ");
INSERT INTO sim_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Unak or nga avak hi jikisi orhin hauowekwa ri. Os erem or uwa oso lewas er nakwa sira. ");
INSERT INTO sim_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jikisi anhi ji misi, an mbeek jir nga nambek a likwa ambu nir. Jir avak anin lasafukwa jir. Uhu mbeek ji heyekwa ambu nir. Mashi kaso Judama ondon angop a saweri sir. Hako ter os amu jirin indik sawenduwa, jir mbeek yanga os a ikwa mishi orok ikwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Hako mashi akri las jirin a sawekwa karem, os an jirin a rupshinda hom, jihi ambek ji anarupshika. ");
INSERT INTO sim_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Os erem ji u nahi, ma amber avak li heye li mba, jir anin tiyanda ma indinga jira.� ");
INSERT INTO sim_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Urik Saimon Pita Jisasin ormu silira, �Wasilaka, mbeek mi iku?� Urik ormu mbara, �Yanga os a ikwa mishi oso mir mbeek ter anin mi tiya ikwa ambu mir. Hako kumak avak tiya ikwa mir.� ");
INSERT INTO sim_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Urik ormu silira, �Wasilaka, mberem ushiwak ter mirin a tiya ikwa ambu, karem mi mbandu? Mihi farniyik avak a hakwa nir.� ");
INSERT INTO sim_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Urik ormu mbara, �Mir anhi farniyik mi hakwak mimu mbandu? Omendingak mirin amu sawenduwa, avak nirik aptoko or mba namber, mir avak hindi nalmingrip, �An Jisasin a heyenda ambu nir,� karem mbakwa mir.� Karem ormu Pitan sawera. ");
INSERT INTO sim_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Urik Jisas mashi las nga ormu mbara, �Jir avak wavu mende jihi nga ji holowa hala. Hako Avui Wasilakan ji hishiowehe anin er nga ji hishioweka. ");
INSERT INTO sim_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Avui anhi aka orhi oso wasilaka mendek nanda sir. Uhu nindi nindik musha mendek or tlehenda sir. Avak a ihi os ji likwa mishin a hundujekwa nir. Erem si nanda ambukop an mbeek mashi kason jirin a sawewa ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ihi mbele mbelen a hundujerakoshihi indik a raha jirin a laha nivai ika. Uhu yanga os a likwa mishi orok nakrem nivai lika. ");
INSERT INTO sim_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yanga os a ikwa mishi oso angop ji heyenda sir. Uhu nombo os a ikwa nga angop ji heyenda sir.� ");
INSERT INTO sim_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Karem or mbarik Tomas mu silira, �Wasilaka, mbeek mi ikwan? Nir mbeek os mi ikwa mishin ni heyenda ambu nir. Nombo oson mberem nivai heyeku?� ");
INSERT INTO sim_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Karem or mbarik ormu mbara, �Antonom nombo os Avui Wasilakahik inda anira. Mashi omendinga tontlo anira. Uhu ermba ermbak linda oson handa anira. Nombo las ngashi ambu sir. Ma lar mbeek nombo anandik or ihi Avui Wasilakan heyekwa ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Os anin ji heyewakop Avui anhi er nga jimu heyewa ria. Hako ter os jimu orin heyenduwa. Uwosik kumak er ji heyekrahakorokwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Urik Filip mu silira, �Wasilaka, men Avui mihin mukunak ni heyeka. Unak mbele las nga indiyok ni silikwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Urik ormu mbara, �Mberem ushiwak mi mba, �Avui mihin mukunak ni heye,� karem mi mbandu? Angop ji heyewa on te! Os anin ji heye nahi, Avui anhi or jimu er nga heyenduwa. ");
INSERT INTO sim_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","An Avui nga na liwak or ormu an nga linduwa. Unda oson mi hishiwa kom? Mashi os jirin a sawewa mbeek wavu anhik a hishihi na sawewa ambu nir, wahau. Avui anhi an nga or lihi or sauhawa hom lerawu orhin amu landuwa. ");
INSERT INTO sim_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uwosik mashi kason ji misihi ji hishioweka, an Avuihik a siwak, or anhik ormu sinduwa. Hako os oson ji hishiowena ambu nahi, lerawu os a lawa yejen ji heyehe ji mba, mashi Jisashi ome sira. ");
INSERT INTO sim_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Omendingak jirin amu sawenduwa, ma or mashi anhin misindiyawa ma oto avak lerawu os a lawa himin lakwa ri. Uhu lerawu or lawa avak lerawu os a lahandan tikrikwa sir. Mberem ushiwak? An avak Avuihik a lawukwa nir. ");
INSERT INTO sim_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Uhu mbele mbele ol hi anhik ji siliwa avak a ukwa lir. Unak mbele mbele ol a uwa ondo li unak hi Avuihi avak wasilakak nakwa sira. ");
INSERT INTO sim_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ome sira, mbele mbele ol hi anhik ji siliwa avak a ukwa lira.� ");
INSERT INTO sim_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Uhu mashi las nga ormu mbara, �Os anin wavu jihik ji ewe nahi, os a mbawa hom ukwa jir. ");
INSERT INTO sim_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Unak Avui anhin a silinak Masikome or jirin jelyakwa oton or mbashinak anhi farniyik or taha ermbak jir nga likwa ri. ");
INSERT INTO sim_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Masikome or jirin jelyakwa oto Avui Wasilakahi Masikome ria. Uhu mashi omendinga orhin jirin saumukolokwa ri. Ma misambik fehenda mbeek orin li heyenda ambu osik orin lakwa ambu lir, wahau. Hako or avak jihik or nashinak avak ji heyekwa ri. ");
INSERT INTO sim_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","An mbeek jirin a halashinak jingoro hom likwa ambu jir, wahau. Avak indik a rakwa nir. ");
INSERT INTO sim_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Am a ikwa ambek osmu nanduwa. A ishinak ma misambik fehe mbeek anin heyekwa ambu lir. Hako jir anin heyekwa jir. Indik a usaha ermba ermbak a likwa onik jir er nga ermba ermbak likwa jir. ");
INSERT INTO sim_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Indik a usahakwa wolo avak ji heyekwa sir, an Avui anhi nga shi linak jir an nga likwa jir. Unak an jir nga na likwa nir. ");
INSERT INTO sim_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Os anin wavu jihik ji ewe nahi, mashi anhin ji misihi os a mbawa hom ukwa jir. Unak Avui jirin rupshikwa ri. Unak an er nga jirin na rupshihi jirik a ranak anin kormbak heyekrahakorokwa jir.� ");
INSERT INTO sim_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas karem or mbarik, Judas Iskariot nembes, Judas ome lar mu silira, �Wasilaka, mberem ushiwak nirtonom mirin ni heyekrahakoroku? Ma misambik fehe mbeek mirin li heyekrahakorokwa ambu lir, karem mi mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Karem or silirik ormu mbara, �Os anin wavu jihik ji ewe nahi, os a mbawa hom ukwa jir. Ushinak an nga Avui anhi nga jirin shi rupshihi jir nga nakrem ni sikwa nira. ");
INSERT INTO sim_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hako os anin wavu jihik ji ewena ambu nahi, jir mbeek os a mbawa hom ukwa ambu jir, wahau. Ji misi, mashi kas a sawewak ji misiwa mashi kaso anhi mashi ambu sir, wahau. Avui or mbashirik a rahanda orhi mashi sira. ");
INSERT INTO sim_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ter os torok jir nga a liwa wolo mashi kason amu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hako a ishinak Avui anhi Masikome or jirin jelyakwa oton or mbashinak anhi farniyik takakwa ri. Or takaha mbele mbele ol jirin a sawewan indik or saumukolonak armek hishiyarikwa jir. Uhu mbeek hishakashakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Am a ikwa wolok osmu nanduwa. Hako ji holoho ji ajewa hala. Sunguwavu jihin ji mbornaha ji lika. Antonom a ushinak sunguwavu jihi jivik si nashinak jip likwa jir. Karem uwosik ji holowa hala. ");
INSERT INTO sim_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mashi os a sawewa angop ji misiwa sir. Jirin a halaha na ihindanak indik a rakwa nir. Os anin wavu jihik ji ewe nahi, wa os jirin a halaha Avui anhik a ikwa oson er nga ji rupshika. Mberem ushiwak? Kwambu orhi kwambu anhin tikrinda sir. ");
INSERT INTO sim_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ter os jir nga na liwa wolo mbele mbele os kumak talakundan os amu sawenduwa. Ushinak os si talawa wolo avak ji heyehe ji hishihi ji mbaka, �Mashi kas Wasilaka mbahanda osmu omek nanduwa.� ");
INSERT INTO sim_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma tor misambi toson sifasahanda ma am or talakwa wolok si nawa osik mashi lal nga jirin a sawekwa ambu nir. Hako or mbeek kwambu anhin tikrihi mbele las anin undahi ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","An anhinjik tavarenje wutarihik a hakwa nira. Mberem ushiwak? An Avui anhin a rupshi mendenda osik os or mbahanda hom a unda nir. Unak ma misambik fehe li heyehe avak li mbaka, �Torto mbele mbele ol Avui orhi mbawa nom unda ri.� Mashi ol a sawewa ambehoma, ji usaha ni ika,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas mashi las nga ormu mbara, �Antonom mi wain indinga anira. Uwak Avui anhi noumashama ria. ");
INSERT INTO sim_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Os mi tava anhi lal akwa ome nga li wana ambu nahi, Avui anhi or taha nor shintle ormbekwa lir. Hako mi tava ol akwa ome nga wawa ondon or munyaha nor shintle ermbeshinak mi jintla jip li rasaha akwa ome musha mendek wakwa lira. ");
INSERT INTO sim_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mashi os a mbari oso angop jirin si urik jivik narakori jir, os mi tavan li munyandari hom. ");
INSERT INTO sim_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Karem uwosik jir avak an nga ji sinak, an jir nga na sika. Ji misi, os mi tava las mimba orok si tenglina ambu nahi, akwa ome nga wakwa ambu sir. Undo hom jir erem, os anin ji hala nahi, mbeek akwa ome nga wakwa ambu jir. ");
INSERT INTO sim_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Antonom mi wain indinga anira. Uwak jir tavayava anhi jira. Os an nga ji si nahi, avak akwa ome nga mushak wakwa jir. Hako os anin ji halaha apsham ji si nahi, mbeek mbele las ukwa ambu jir, wahau. ");
INSERT INTO sim_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Os an nga ji sina ambu nahi, avak mi tava hom li shintle ermbeshinak hatlayikwa jir. Ushihi li lahara lasikop li hapnduwuhu li suwukwa jira. ");
INSERT INTO sim_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hako os an nga ji sinak mashi anhi jihik si na nahi, ambehoma, mbele las os ji ukmbaha Avuin ji siliwa oso, os ji siliwa hom avak or ukwa sira. ");
INSERT INTO sim_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Os anin tiyanda ma indingak ji na nahi, akwa ome nga mushak wakwa jir. Erem ji nanda oso si unak Avui anhi hi orhi avak wasilakak nakwa sira. Unak ma amber os anin tiyanda ma indingak ji nawan heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","An jirin wavu anhik a ewenda nira, os Avui anhi anin wavu orhik or ewenda hom. Unda osik jir an nga ji sika. ");
INSERT INTO sim_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mashi mashi os Avui anhi anin or mbahandarin angop a tiyarakoshirik anin ormu rupshi mendenduwa. Uhunda hom jir erem, os mashi anhin ji misihi ji tiyarako nahi, avak a rupshikwa jira. ");
INSERT INTO sim_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Waprupshi anhi jirik si nakmbaha mashi kason jirin amu sawenduwa. Ushinak waprupshi anhi os jihik nanda mbeek mendek nakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lo anhi jirin a hawa karem, ma anandin wapnuku jihik ji ewehe armek ji uka. Os an jirin wapnuku anhik a ewenda hom, jir erem, ma anandin wapnuku jihik ji eweka. ");
INSERT INTO sim_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Os ma lar li mandingormekmbaha li unak jir yejen jihinjik ji mbanak orhi farniyik jirin li mandingormewa nombo oso man wapnukuk ewenda nombo mende sira. Uhu mbele mbele jivi ol ma li undan tikrinda sir. ");
INSERT INTO sim_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Os a mbawa hom ji u nahi, avak samunda anhi indingak nakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","An mbeek jirin men lerawun landa ma, karem a ushakwa ambu jir, wahau. Mberem ushiwak? Lerawun landa ma oto mbeek lerawu mashama orhi wavu orhin heyenda ambu ri. Hako Avui anhi mashi orhin angop a sawerik ji misiri sir. Unda osik ter avak samunda anhik a ushakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jir mbeek masmas anhi mak ji nakmbaha hishiri ambu jir. An mu jirin anhi mak ji nakmbaha amu kamara. Ushinak ji ihi lerawu anhin ji laha inak akwa ome nga si naka. Unak akwa ome oso mbeek mendek nakwa ambu sir, ermba ermbak er nakwa sir. Os erem ji u nahi, mbele mbele hi anhik Avuin ji siliwa avak or hakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hako lo anhi jirin a hawa karem, ma anandin wapnuku jihik ji eweka, os an jirin wapnuku anhik a ewenda hom.� ");
INSERT INTO sim_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Uhu mashi las nga Jisas ormu mbara, �Os ma misambik fehe jirin kavakavak li u nahi, wavu jihi musha mushak ji hishiwa hala. Anin li uhunda hom jirin erem ukwa lir. ");
INSERT INTO sim_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Os jir lir hom ji na nahi, jirin rupshikwa lir. Hako jir mbeek misambik fehenda ambu jir. Angop jirin a kamashihindak anhi mak ji nawa osik jirin li wapkava hishihi kavak li nakwa jir. ");
INSERT INTO sim_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hako mashi os mas jirin a sawehendarin indik a sawenak armek ji misika. Ma ol malakamanjik lerawun landa ma ondo malakama lihi siyok sinda lir. Jir nga erem, anhi siyok sinda jir. Karem uwosik ma misambik fehe anin kavak li unda hom jirin erem kavak li ukwa jir. Hako os mashi anhin li misihi li tiyandakop mashi jihin erem misindiyawa lir. ");
INSERT INTO sim_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jir angop anhi krahak nawa oja. Hako ma misambik fehe mbeek Avui anhi or mbashirik a rahandan heyenda ambu lir. Karem uwosik jirin kavakavak ukwa lir. ");
INSERT INTO sim_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Os a raha kavakava os li unda nombo lihin kormbak a saweri ambukop mbeek kavakava os li undarin kormbak heyeri ambu lir. Hako angop kormbak a sawerik li mistakori sir. Karem uri osik ma lar mbeek nambenandahi ambu ri, wahau. ");
INSERT INTO sim_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma ol anin wutarik ewenda ondo Avui anhin erem wutarik olmu ewenduwa. ");
INSERT INTO sim_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbele mbele ma undahi ambu ondon a mukurik angop heitakori lir. Hako mbeek mashi anhin misindiyari ambu lir. Os li heyeri ambukop lir mbeek kavakava nga nari ambu lir. Hako angop a urik li heyeri sir. Karem uri osik an nga Avui anhi nga shirin olmu wutarik ewenduwa. ");
INSERT INTO sim_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Os erem li unda oso angop maskop Avui Wasilakahi jekambak li kayehendari osik avak omek nakwa sira. Karem li kayeri sir, �Ma ondo sembe mende anin wapkava li hishihi wutarik owenduwa.� ");
INSERT INTO sim_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Masikome or jirin jelyakwa oto ormu Avui Wasilaka nga linduwa. Mainome nom mbanda ri. Avak a mbashinak jihik or taha anin kormbak jirin sawekwa ri. ");
INSERT INTO sim_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jir angop an nga ni lihi lerawu os a lawan ji heitakonda osik avak ji ihi ma amber mashi anhi kason ji sawenak li misika.� ");
INSERT INTO sim_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","�Las avak anin ji halanda ngashi. Karem mbaha mashi mashi ol amu masmas sauhambanduwa. ");
INSERT INTO sim_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kumak avak lir nga ji lotu ukuwa nombo oson pantlekwa ola. Uhu os jirin li mandingormekwa wolo karem hishikwa ola, �Lerawu Avui Wasilakahin os nimu landuwa.� ");
INSERT INTO sim_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Lir mbeek an nga Avuin nga shirin heyenda ambu lir. Karem uwosik kumak mbele mbele kavakava ondon jirin ukwa ola. ");
INSERT INTO sim_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hako ter os jir nga na liwa wolo mbele mbele os kumak talakwan os amu jirin sawenduwa. Uhundanak kumak os erem si nawa wolo mashi os ter a mbawan indik ji hishika.� �Mas os jir nga na liri wolo mashi kaso kas jirin a saweri ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Hako am jirin a halaha ma or mbashirik a rahandahik indik a ikwak si nashiwak mashi kason jirin amu sawenduwa. Hako jir lar mbeek anin silikwa ambu ri, �Mbeek mi iku?� ");
INSERT INTO sim_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mashi kason a saweshiwak sunguwavu jihi nga jimu holonduwa. ");
INSERT INTO sim_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hako omendingak jirin amu sawenduwa, os jirin a hala ikwa oso jivi sira. Mberem ushiwak? Os jirin a hala ina ambu nahi, Masikome Avui Wasilakahi mbeek taha jirin jelyakwa ambu ri, wahau. Hako halanak a ihi na mbashinak or taka. ");
INSERT INTO sim_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Or taha orvai mukuka, mbele mbele os ma uwak kavak nanda maintontlo sihi mberem si nandu. Uhu nombo os jip wornak er nanda maintontlo sihi mberem si nandu. Uhu Avui Wasilakahi kot orhi oso maintontlo sihi mberem si nandu. Erem nanda nombon orvai mukuka. ");
INSERT INTO sim_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kavakava os ma li unda maintontlo sihi karem, lir mbeek anin wavu lihik ewehe mashi anhin misindiyanda ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma worna mak nanda maintontlo sihi karem, an Avui anhik a ishinak mbeek li heyekwa ambu nir. Uwosik nombo orok ma misambik fehe ma worna mak nakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Avui Wasilaka kot orhi oso maintontlo sihi karem, malakama misambi toson sifasahanda ma oto angop kavak nari ri.� ");
INSERT INTO sim_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","�An mashi mushak jirin a sawekwak nawa lir. Hako ter a sawewa jir mbeek ondon misindahik nawa ambu jir. Karem uwosik a sawekwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hako Masikome or mainomen sawenda oto avak or taha mashi ondon jirin or saumukolonak jivai hishiyarika. Hako or mbeek wavu orhik or hishiwa mashin sawekwa ambu ri, wahau. Mashi os or misiwa nom sawekwa ora. Uhu mbele mbele os kumak talakwan sawekwa ri. ");
INSERT INTO sim_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mashi anhin or larakaha jirin sawekwa ri. Erem or unak hi anhi avak wasilakak nakwa sir. ");
INSERT INTO sim_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mbele mbele Avuihi ondo anhi lira. Karem uwosik jirin amu sawenduwa, Masikome Avui Wasilakahi mashi anhin or larakaha jirin sawekwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Uhu Jisas ormu mbara, �A ikwa wolo am pasir naw. A ishinak mbeek anin heyekwa ambu jir. Hako kandakar nga ji linak indik a ranak ji heyekwa nir.� ");
INSERT INTO sim_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Karem or mbarik ol orin tiyandari ma ondo lihi ambek limu mbara, �Mberemhi mashi kas or mba, �A ishinak mbeek anin heyekwa ambu jir. Uhu kandakar nga ji linak indik a ranak ji heyekwa nir.� Uhu nor mba, �Avuihik a ikwa nir.� Mberemhi mashi sir? ");
INSERT INTO sim_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","�Nambek or likwa ambu,� karem or mbawan. Maintontlo sihi mberem sivai nandu? Am ni mbeler te!� ");
INSERT INTO sim_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas am orin li silikmbaha li hishiri oson or heyehe ormu mbara, �Jir jihi ambek mashi os a mbawa, a inak mbeek anin heyekwa ambu jir. Uhu kandakar nga ji linak indik a ranak ji heyekwa nir, karem a mbawa maintontlo sihin jimu hishakashandu? ");
INSERT INTO sim_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Omendingak jirin amu sawenduwa, jir avak mbele mbele ol anhik talakwan ji heyehe ji tlaholokwa jir. Hako ma misambik fehe avak rupshikwa lir. Hako kumak os indik a tanak anin ji heyewa wolo os ji tlaholowa oso avak mendek nakwa sir. Unak oro wolok ji rupshikwa sir. ");
INSERT INTO sim_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nokove si wakwak si nawa wolo entlembale kavan misinda sir. Hako jikisi omen am si heyehe si rupshihi entlembale os sihik nawan er hishanda sir. ");
INSERT INTO sim_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jir erem, avak tlaholokwa jir. Hako os indik a raha jirin a heyewa wolo sunguwavu jihi nga rupshikwa jir. Unak ma misambik fehe lar mbeek os ji rupshiwan unak mendek nakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hako oro wolok mbeek mbele mashi las anin silikwa ambu jir. Omendingak amu sawenduwa, mbele las hi anhik Avuin ji siliwa avak or hakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hako mas mbeek hi anhik orin mbele las ji siliri ambu jir. Hako ter ji siliwa or hakwa jir. Unak avak warje mende nga rupshikwa jir.� ");
INSERT INTO sim_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Uhu mashi las nga Jisas ormu mbara, �Ter wolo mashin jirin sauheimak a sawenda nir. Hako kumak avak mashin kormbak a sawenak misikwa jir. Avui anhi mberem nanda ma ri? Oson kumak avak kormbak a sawenak orin heyekrahakorokwa jir. ");
INSERT INTO sim_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Oro wolok an mbeek mbele las jirnjik Avui anhin a silikwa ambu nir, wahau. Mberem ushiwak? Jihinjik hi anhik Avuin ji silinak or haka, os ji siliwa oson. ");
INSERT INTO sim_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Or jirin rupshinda ri. Mberem ushiwak? Jir anin ji rupshihi karem hishinda oja, an Avui mbashirik a rari nira. Karem ji hishinda osik jirin rupshinda ri. ");
INSERT INTO sim_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mas Avui nga nakrem shi lihi na halaha misambik a rari nir. Hako ter avak misambin na halaha indik orhik a ikwa nir.� ");
INSERT INTO sim_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Karem or mbarik limu mbara, �He ter am nimu heyenduwa. Mbeek sauheimak sawewa ambu mir. ");
INSERT INTO sim_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mir mbele mbele ondo amber mi heitakonda lir. Os ni silikwak ni hishiwa angop mi heitakowa lir. Uwosik am nimu heyenduwa, mir Avui mbashirik tari mira.� ");
INSERT INTO sim_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Urik ormu mbara, �Ambehoma. Ter am jimu heyendu? ");
INSERT INTO sim_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ji misi, os li unak anin ji halaha jihi jihik ji tulukwa wolo oso osmu pasir nanduwa. Ushinak nendekop a sikwa nir. Hako nendekop a sikwa ambu nir, Avui anhi an nga nakrem shi sikwa shir. ");
INSERT INTO sim_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Os misambi torok ji liwa wolo nomorawu lakan jirin hakwa ola. Hako kwambu anhik ji sihi ji ajewa hala. Mberem ushiwak? Misambi toson sifasahanda ma oto angop a estangriwa ria. Mashi kason a sawenak ji misihindanak mbele mbele ol jirik li talawa ji ajewa hala. Sunguwavu jihin ji mbornaha kwambu anhik ji sika.� ");
INSERT INTO sim_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas am mashin or sawerakoho lersuwu yok or larasa mawuhu Avui orhin ormu sawera, �Avuya, am a hakwa wolok osmu nanduwa. Avak mir hi anhin hauowenak wasilakak si naka. Unak an nga hi mihin a hauoweka. ");
INSERT INTO sim_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","An maifuk a sikmbaha mi mbari ona. Ushinak maifuk a sihi os ermba ermbak lindan ma ol anin mi hahanda ondon a hakwa nira. ");
INSERT INTO sim_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ermba ermbak linda oso mberem livai laku? Os mir God indingan li hishiowehe ma or mir mbashirik tari oton li heyehe li mba, �Ma oto Jisas Krais Avui Wasilaka kamahanda ma ria.� Karem li mba nahi, ambehoma avak ermba ermbak linda oson lakwa lir. ");
INSERT INTO sim_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Lerawu os anin mi hari oson angop a larakoshiwak hi mihi wasilakak nawa sir. ");
INSERT INTO sim_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Karem uwosik Avuya, hi anhin halashinak wasilakak si naka, os misambi si na namber mir nga shi liri wolok si nahandari hom. ");
INSERT INTO sim_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Avui, ma misambik fehe ol anin mi hahanda ondo mas mbeek mirin heyekrahakorori ambu lir. Hako a raha mbele mbele os mihik nahandan angop a mukurik li heyeri sir. Ma ondo mihi lira. Hako angop anin mi hahandari lir. Unda osik ter olmu mashi mihin misindiyanduwa. ");
INSERT INTO sim_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Uhu ter olmu heyenduwa, mbele mbele ol anin mi hahanda mihikop talanda lir. ");
INSERT INTO sim_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mashi ol anin mi hahandarin angop a sawerakorik li misihi karem hishinda lira, an mir nga shi lihi mi mbashirik a rari nira. ");
INSERT INTO sim_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","An mbeek ma misambik fehe amber lirnjik mirin a sawekwa ambu nir, wahau. Ma ol anin mi hahanda ondonjik mirin a sawekwa nir. Mberem ushiwak? Ma ondo mihi ola. ");
INSERT INTO sim_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Anhi ma ondo mihi lira. Mihi ma ondo anhi lira. Unak anin tiyanda ma ondo mbele mbele jivi li unak ma li heyehe hi anhin li hausimbausinak wasilakak nakwa sir. ");
INSERT INTO sim_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Misambi toson a halaha mirik a takwa wolo osmu pasir nanduwa. Hako anin tiyanda ma ondon a halashinak misambik likwa lir. Karem uwosik, Avuya, lirnjik mirin amu sawenduwa. Mir ma jivi mende mira. Lar mbeek mir hom nanda ambu ri. Karem uwosik kwambu os anin mi hahanda orok lirin arangoshinak li lika. Uhu halashinak wavu namtaskop li naka, os shir wavu namtaskop shi hishinda hom. ");
INSERT INTO sim_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Os lir nga nakrem a liwa wolo kwambu os anin mi hahanda orok lirin a arangoshiwak mbeek kavak nawa ambu lir. Hako mashi os maskop li kayehendari karem mbari osa. �Ma namtar nom kavak nakwa ri.� Uhunda osik ma oto nom kavak nakwa ri. ");
INSERT INTO sim_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ter am mihik a rakwa wolok osmu nanduwa. Misambi toson a hala namber, mashi mashi amber lirin a sawerik mistakori lir. Unak rupkapshi os anhik nanda lihik si nakmbahan. ");
INSERT INTO sim_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mashi mihin lirin a sawerik misiri lir. Uri osik ma misambik fehe lirin olmu wutarik ewenduwa. Mberem ushiwak? An misambi torok fehe ambu nir. Uwosik lir nga misambi torok fehe ambu lir. Karem nawa osik ma misambik fehe lirin wutarik olmu ewenduwa. ");
INSERT INTO sim_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","An mirin a sawekwa karem, mir avak lirin arangoshinak jip li lika, os Laulaka lirin kavak or nakwan. Hako halanak misambi torok li lika, mbeek mi laha lasik mi ewekwa nembes. ");
INSERT INTO sim_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","An misambi torok fehe ambu nir. Unda osik lir nga erem misambi torok fehe ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mashi omendinga mihin halashinak sunguwavu lihik si nashinak mashi mihin li toltambanaha avak ma worna ma mihi indingak li naka. ");
INSERT INTO sim_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Os anin mi mbashirik ma misambik fehe lihi nindik a rahanda hom avak lirin a mbashinak li ihi ma misambik fehe lihi nindik ikwa lir. ");
INSERT INTO sim_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma tol anin mi hahandanjik maome anhin fleya hom mirin a hakwa nira. Ushinak lir avak anhi ma indingak li naha os mi mbawa hom li naka. ");
INSERT INTO sim_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","An mbeek tol ter anin tiyanda ma ondonjikop mirin a sawewa ambu nir, wahau. An ma ol kumak tondohi mashin misihi anin tiyakwa ma ondonjik er nga mirin amu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mirin a saweshinak ma ondon mi jelyashinak lir amber wavu namtaskop li naka, os an nga mir nga wavu namtaskop shi nanda hom. Uhu halashinak lir nga shir nga wavu namtaskop ni hishika. Ushinak ma misambik fehe avak os mi mbashirik a rarin heyekrahakorokwa lir. ");
INSERT INTO sim_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mir kwambu mihin anin hari mir. Uri osik an nga kwambu os anin mi hari oson lirin amu hara. Ushinak lir avak wavu namtaskop li hishika, os shir nahanda hom. ");
INSERT INTO sim_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","An lihik a liwa osik mir anhik lika. Erem si nashinak lir avak wavu namtaskop er li hishika. Ushinak ma misambik fehe os mi mbashirik a rarin heyekrahakorokwa lir. Uhu os anin wapnuku mihik mi ewenda hom, ma anhi ondon wapnuku mihik mi ewenda oson avak li heyekrahakoroka. ");
INSERT INTO sim_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Avuya, a hishiwa karem, halashinak ma ol anin mi hahanda ondo an nga kuyanga os a likwa mishik nakrem ni lika. Ushinak kwambu os anin mi hahandan livai heyeka. Misambi na namber anin mi rupshihi kwambu oson anin hari mir. ");
INSERT INTO sim_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Avui, mir ma worna ma indinga mira. Ma misambi fehe mbeek mirin heyenda ambu lir. Antonom mirin a heyenda nir. Uwak ma ol anin tiyanda ondo, os mi mbashirik a rarin angop li heyenda sir. ");
INSERT INTO sim_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mbele mbele os mihik nandarin kormbak a sawerik heyeri lir. Unda osik er a sawenak misikwa lir. Ushinak os anin wapnuku mihik mi ewenda hom ma anandin wapnuku lihik ewekwa lir. Unak an lir nga na lika,� karem Jisas Avui orhin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas mashi oson or sawerakoshihi ma ol orin tiyandari ondo nga yanga oson li halaha farava Kidronin li mbuhu li lawuhu oliv nowe orok limu ira. ");
INSERT INTO sim_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jisas nga ol orin tiyandari ma ondo nga nowe orok ermbak li ifa rafa yandari osik Judas nowe oso angop or heyendari sir. ");
INSERT INTO sim_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Uri osik awun undari ma ol hetpris nga Farisi nga li mbashirik rari ondo er nga or laha Jisasin li tolokurik limu ira. Uhu lam nga tujaka nga li ukruhu korme sayi nga li kishaha limu ira. ");
INSERT INTO sim_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas mbele mbele os orhik talakurin angop or heyeri sir. Uri osik nor ihi ma ondon or heyehe ormu silira, �Lawe ji lasaranduwa?� ");
INSERT INTO sim_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Karem or silirik limu mbara, �Nir Jisas Nasaretik fehendan nimu lasaranduwa.� Urik ormu mbara. �Wa, anira.� Judas er nga lihi nindik siri ri. ");
INSERT INTO sim_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Karem or mbarik ma ondo li lishnyafaha kumayok li haisikmba uhu misambik limu takatukuyira. ");
INSERT INTO sim_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ushihi indik ormu silira, �Lawe ji lasaranduwa?� Urik limu mbara, �Nir Jisas Nasaretik fehendan nimu lasaranduwa.� ");
INSERT INTO sim_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Urik indik ormu mbara, �Angop a sawewa ok te! Ma or ji lasarawa ma anira. Os anin ji tolokwak ji ra nahi, wa antonom ji toloka. Uhu ma tol an nga ni liwan ji halashinak li ika.� ");
INSERT INTO sim_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Karem or mbarik mashi os mas or mbari oso osmu omek nara. Mashi oso karem, �Ma ol anin mi hahanda ma rondo mbeek lihi lar kavak nakwa ambu ri,� karem or mbahandari mashi osmu omek nara. ");
INSERT INTO sim_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Urik Saimon Pita bainat las or longo laha nor ihi ma lar hetprisnjik lerawun landari ma otohi mambla mama yejen ormu shinjesera. Or shinjeserik misambik simu rakara. Ma oto hi orhi Malkus oria. ");
INSERT INTO sim_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Urik Jisas mu mbara, �Bainat mihi oson laha indik haloweka. Mir mberem mi hishindu? Nomorawu os Avui anin or hahanda oson na kishandahi ambu? Karem mimu hishindu? Wahau, a kishandahi sir.� ");
INSERT INTO sim_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Urik ol awun undari ma komanda lihi nga, ma ol tempel akan washilindari ma nga li raha Jisasin li toloho tava orhin kuvuk limu ishira. ");
INSERT INTO sim_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Karem uhu masmas Anashi akak limu laha ira. Anas oto hetpris Kaiafas orhi arjava ria. Asama oro wolok Kaiafas hetprisik or nari wolo sira. ");
INSERT INTO sim_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Or mas karem mbahandari ri, �Halanak ma namtar nom ma Romik fehenda tava lihik ni haka. Las avak nir amber hom ni handa ngashi.� ");
INSERT INTO sim_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Urik Saimon Pita nga Jisasin tiyandari ma lar nga fri lundiya ihi hetprishi akak fri ihi ma or hetprisin heyendari ma oto akanivi orok ormu layira. ");
INSERT INTO sim_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Hako Pita akayangak ormu sira. Urik ma oto or layi ihi hetprisnjik lerawun landari nokove las ormu sawera. Unak Saimon Pitan si lalayinak akak or layikmbahan. Urik akak ormu layira. ");
INSERT INTO sim_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Akak or layirik nokove oso osmu orin silira, �Mir Jisas nga yanda ma om?� Urik ormu mbara, �Wahau, an nga nembes.� ");
INSERT INTO sim_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Urik hetprishi akak lerawun landari ma ondo nga tempel akan washilindari ma ondo nga li hindiyaha li hiwaloho Pita er nga orok or lihi normu hiwalora. ");
INSERT INTO sim_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Urik hetpris Jisasin ormu silira, �Sawenak a misi, ma ol mirin tiyanda ondo lawe lir? Mberemhi mashin lirin mi sawendu?� ");
INSERT INTO sim_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Karem or silirik ormu mbara, �An mbeek a wanyisawenda ambu nir, wahau. Mashi os a sawenda oso kormbak a sawenda nir. An ermba ermbak os li tirsanda mishik a ihi tempel aka nga li lotu unda aka nga orok a ihi mashin kormbak a sawenda nir. ");
INSERT INTO sim_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mberem ushiwak anin mi silindu? Ma ol a sawerik misinda ondon silika. Lir angop a sawewan misinda lir.� ");
INSERT INTO sim_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Karem or mbarik kolok tempel akan washilindari ma lar or usaha Jisasin or jimblalanaha ormu mbara, �Mberem ushiwa mendek hetprishi mashin mi siyasayanduwa?� ");
INSERT INTO sim_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Urik ormu mbara, �Os mashi las a mbanak kavak si na nahi, mir nga kormbak os a uwak kavak nawak mi heyewa oson saweka. Hako os mashi ome nom a sawe nahi, mberem ushiwak anin mi jindu?� ");
INSERT INTO sim_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Urik Anas mu mbara, �Toton hetpris Kaiafashi akak ji laha ika.� Urik Jisasin limu laha ira. Hako kuvu os tava orhik li ishiri oso mbeek li horngori ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita or sihi ormu hiwalora. Urik ma or er nga li siri lar ormu silira �Mir Jisasin tiyanda ma lar om?� Urik ormu mbara, �Wahau, an nga nembes!� ");
INSERT INTO sim_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hako hetprisnjik lerawun landari ma lar orok er nga siri ri. Ma oto ma or Pita nowek mamblan or shinjeseri jimatama orhi lar oria. Uhu ormu mbara, �Wahau, mir nowe orok a heyewa mir.� ");
INSERT INTO sim_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Urik Pita indik ormu mbara, �Wahau, an nembes te!� Karem or mbarik aptoko mu mbara. ");
INSERT INTO sim_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nirsumbuk si narik Judama ondo Kaiafashi akan li halaha malakama Romik fehenda Pailathi akak Jisasin limu laha ira. Li ihi nombok lihi ambek limu mbara, �Os Pailathi akak ni layi nahi, misokome Avui Wasilakahik kavak ni nakwa nir. Uhu hiyawu Pasova oson mbeek ni akwa ambu nir.� Karem uri osik lir mbeek aka akomek layiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Men hikrik li sihi nikishirik Pailat or taha ormu silira, �Ma roto mbele kas or uwak kavak nawak ji heyehe ji kotim ukwak ji laharandu?� ");
INSERT INTO sim_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Urik limu mbara, �Os jivi nom or undakop mbeek mihik ni laharawa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Urik ormu mbara, �Indiyok ji laha ika. Uhu lo jihi os si mbahanda hom orin jivai kotim uka!� Urik limu mbara, �Nir mbeek ma lar ni jimandingormekwa ambu nir, karem angop jir Romik fehenda nirin ji pantlehenda sir.� ");
INSERT INTO sim_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jisas angop mas or mbari sir, �Samba samba yanga anandik fehenda ma ondohi tavak anin li halashinak miandok li tirikwa nira.� Karem or mbahandari mashi oso osmu omek nara. ");
INSERT INTO sim_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Urik Pailat indiyok akomek or ihi Jisasin ormu silira, �Mir king Judamahi om?� ");
INSERT INTO sim_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Urik ormu mbara, �Mir mihinjik mi hishi mimu mbandu mo ma lal saweshihindak mimu mbandu?� ");
INSERT INTO sim_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Urik ormu mbara, �Mberem mi mbandu? An Judama lar on? Karem mimu mbandu, wahau te! Mberem ushiwak mihi ma nga bikpris ondo nga mirin anhik li laharandu?� ");
INSERT INTO sim_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Urik ormu mbara, �An mbeek misambi torok malakamak a nakwa ambu nir. Os misambi torok malakamak a nawakop anhi ma ondon a mbashiwak awun uwa lir, os Judama ondo li raha anin li tolowa wolon. Hako malakamak a nakwa oso mbeek misambi torok a nakwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Urik Pailat mu mbara, �Kormbak sawenak a misi, mir malakama lar om?� Urik ormu mbara, �Os mi mbawa homa. Misambi torok a rari maintontlo sihi karem, mashi omendinga tontlo sihin a sawekmbaha a rari nira. Unak ma ol mashi omendingan misinda ma ondo mashi anhin li misikmabahan.� ");
INSERT INTO sim_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Karem or mbarik ormu mbara, �Mashi omendinga os mi mbawa oso mberemhi mashi sir?� Pailat karem or mbashihi indik hikrik Judama ondon or heyekurik or layihi ormu mbara, �Or mbeek mbele kava las or uwak a heyewa ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hako ji heyewak asama asama hiyawu Pasovan ji unda wolo krawu akak linda ma lar a mbashiwak tala inda ri. Ter mberem ji hishindu, lawen a halashinak or tala ikmbaha ji hishindu? Malakama Judahin mo mberem ji hishindu?� ");
INSERT INTO sim_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Urik li ushaha limu mbara, �Or nembes, Barabasin halashinak or tala ika,� karem limu ushambara. Barabas oto hirnyandari ma lar oria. ");
INSERT INTO sim_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Urik Pailat mbashirik awun undari ma ondo Jisasin limu wakorora. ");
INSERT INTO sim_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Uhu kuvu lame ngashi las li yantlehe hat malakama falendari hom si narik masiji orhik limu falera. Uhu kounalo las orhik limu faleshira. ");
INSERT INTO sim_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Uhu orin li okolehe limu mbara, �Awasayi, mir malakama Judahi mira.� Karem li mbaha orin limu jimblalanara. ");
INSERT INTO sim_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Urik Pailat indik hikrik or layihi ormu mbara, �Ji misi, ma roto mbele kava las or uwak a heyewa ambu sir. Uwosik ter orin a laharlanak jihinjik ji heyekwa ri. Or mbeek musa las nga nawa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Karem or mbarik Jisas hikrik ormu talara. Kuvu lame ngashi os li faleri nga kowe oso er si narik hikrik or talarik Pailat mu mbara, �Ji heye, ma oto toria.� ");
INSERT INTO sim_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Urik bikpris nga tempel akan washilindari ma nga orin li heyehe limu mbara, �Toton miandok tirika! Toton miandok tirika!� Urik Pailat mu mbara, �Jihinijk ji laha ihi miandok ji tirika. An mbeek mbele las or uwak kavak nawak a heyewa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Urik limu mbara, �Wahau, halanak neloko nihi Moses lo os or kayendari si mbahanda hom ni uka. Ma or Avui Wasilakan okolewa halanak or haka. Ma oto angop or mbar, �An jikisi Avui Wasilakahi nira.� Karem or mbahanda osik halanak or haka!� ");
INSERT INTO sim_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Urik Pailat mashi oson or misihi ormu aje mendera. ");
INSERT INTO sim_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Uhu indik Jisasin akomek or lalaiewehe ormu silira, �Mir mbeek fehe mir?� Karem or silirik Jisas mbeek mashi las mbari ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Urik Pailat ormu mbara, �Mberem ushiwak a siliwan mayam mi sindu? An malakama kwambu nga na nanda nira. Os a mba, mir miandok a tirikwa mir, karem a mbawa erem a undahi mir. Os a mba, a halashinak ikwa mir, karem a mbawa erem a undahi mir.� ");
INSERT INTO sim_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Karem or mbarik Jisas ormu mbara, �Lawe mirin mbashihindak malakamak mi naha kwambu nga mi nandu? Oso Avui Wasilaka mirin or hari sira. Os kwambun mirin or hari ambukop, mir mbeek mbele las anin undahi ambu mir. Hako ma ol anin tavarenje mihik hawa ma ondo kavakava lihi wasilaka mendek si naha kavakava os mi undan tikrinda sira.� ");
INSERT INTO sim_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Karem or mbarik Pailat Jisasin or halashinak or ikmbaha ormu hishira. Hako Judama ondo li ushaha limu mbara, �Ma oto karem mbari ria, �An malakama nir.� Karem or mbari osik malakama Romik fehenda Sisar orhi wutarik nakwa ri. Os orin mi halashinak or i nahi, mir er nga Sisarhi wutarik nakwa mira.� ");
INSERT INTO sim_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Karem li mbarik Pailat Jisasin hikrik ormu laharlara. Uhu kawu os man or kotim undari mishi orok ormu lira. Os or liri mishi oso hi sihi Sunja yanga. Judama mashi lihik Gabata, karem li ushandari sir. ");
INSERT INTO sim_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oso wolo am takondik si narik Judama hiyawu Pasovan li ukurin li hundujekuri wolok simu nara. Urik Pailat Judama ondon ormu sawera, �Ji heyeka, king jihi toria.� ");
INSERT INTO sim_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Urik limu mbara, �Laha ihi orin miandok tirika!� Urik ormu mbara, �Mberem ji hishindu miandok a tirikwa or? King jihi or te!� Urik bikpris ondo olmu mbara, �King nihi namtar numbu Sisar oria. Nir mbeek king anandi lar ngashi ambu nir, wahau.� ");
INSERT INTO sim_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Karem li mbarik Pailat Jisasin tava lihik or halashirik miandok orin li tirikmbaha limu laha ira. ");
INSERT INTO sim_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Urik Jisasin miandok li tirikmbaha limu laha ira. Jisas orhinjik miando oson or kishaha yanga telemba masikhava hom nanda mishik limu ira. Yanga oso Judamahi mashik Golgota karem li ushandari sira. ");
INSERT INTO sim_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Telemba orok li lalawuhu Jisasin miandok limu tirira. Ma frijip er nga li tirishirik wari vria, lar tapmama yok lar tava ashi yok. ");
INSERT INTO sim_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Urik Pailat jekamba las or kayehe ma lar or mbashirik or ihi Jisashi masik nuku yok jekamba oson ormu ewera. Mashi oso karem or kayeri sir. �Jisas yanga Nasaretik fehe king Judamahi toria.� ");
INSERT INTO sim_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mashi os or kayeri oson Judamahi mashik or kayeri sir, Romik fehenda lihi mashik or kayeri sir, yanga Grikik fehenda lihi mashik er nga or kayeri sir. Yanga os Jisasin miandok li tiriri mishi oso yanga sumbu nombo takmak si nari osik ma mushak li terei tereraha mashi os or kayerin limu heyera. ");
INSERT INTO sim_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ushirik bikpris ondo Pailatik li raha limu sawera, �Mashi os mi kayewa oso jivik nawa ambu sir. Mberem ushiwak king Judamahi toria, karem mi kayew? Wa karem kayeka, ma roto orhinjik, �An king Judamahi anira,� karem mbandari ri. Karem kayeka.� ");
INSERT INTO sim_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Karem li mbarik Pailat mu mbara, �Os a kayewa oso am nawa sir.� ");
INSERT INTO sim_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Urik awun undari ma ondo Jisasin miandok li tirishihi kowe orhin li lai ewehe ma tovro kavrok li humasihi limu lara. Uhu kousamba orhin li laha li heyeri mbeek kousumbu nga nari ambu sir, namtaskop osmu nara. ");
INSERT INTO sim_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Erem si nashirik limu mbara, �Kowe oso jivik nawak nimu heyenduwa. Uwosik ni frehekwa ambu sir. Wa, ka ni lai ewehe satuk ni ermbehe nivai heyeka lawe oson laku.� Erem li uri nombo orok mashi os mas li kayehendari oso osmu omendingak nari sir. Mashi oso karem, �Mbele mbele anhin li humasihi li lai ewehe satuk ermbekwa lir.� Mas karem li kayeri sir. Undari osik ol awun undari ma ondo os limu erem ura. ");
INSERT INTO sim_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Urik Jisas nijava orhi nga sanje sihi nga Maria Klopashi nokove nga Maria Makdalak fehenda nga pasir miando Jisas wari mishi orok limu sira. ");
INSERT INTO sim_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Urik Jisas nijava orhi nga ma or or rupshindari oto nga pasir frimu sira. Urik or heyehe nijava orhin ormu sawera, �Mamai, ma oto jikisi indingo nyihi ria.� ");
INSERT INTO sim_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uhu ma orton ormu mbara, �Heye, nijava mihi sira.� Karem or mbashirik ma orto Marian or laha nijava orhi hom or lai ewehe limu lira. ");
INSERT INTO sim_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas or hishiri lerawu os or lakurik or tari osmu mendek nara. Urik mashi las mas jekambak li kayehendari oso omek si nakurik ormu mbara, �Jekapnashi anhi am hatlayiw te.� ");
INSERT INTO sim_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wain uku jeseng andari las awu lasik li eweshirik liri sir. Urik warsuvu hom nandari las li laha wain uku orok li halfaleshirik uku nga si narik hisop kombek li ishihi Jisasin li hauharik ormu uksem ara. ");
INSERT INTO sim_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wain uku oson or uksem aha ormu mbara, �Lerawu os a lakmbaha na rahanda angop a larakowa sir.� Karem or mbaha nor maruknyaha masikome orhin or halashirik or irik ormu hara. ");
INSERT INTO sim_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jisasin miandok li tiriri wolo Judama am hiyawun li ukurin li hundujekuri wolok simu nara. Urik Judama lida lihi Pailatin li i heyehe limu mbara, �Ushok Sabatik si nanak hiyawu wasilaka oson ni tolokwa sir. Hako ma ol miandok wawa ondo os orok er li wa nahi, kava indigok nakwa sir. Karem uwosik ma lal mbashinak li ihi ma ol miandok wawa ondo kumba hava lihin li jintlenak kolomalok li haka. Li hashinak maninimba lihin li tarmba lafakaka.� ");
INSERT INTO sim_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Karem li mbarik Pailat or mbashirik awun undari ma li ihi ma frijip ovron kumba havan limu jintlera. ");
INSERT INTO sim_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hako Jisasin li heyeri angop hari ri. Ushirik kumba hava orhin mbeek li jintleri ambu ri. ");
INSERT INTO sim_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Urik awun undari ma lar korme orhin or laha Jisashi aimak ormu jira. Or jirik fi nga uku nga simu ngoro rakara. ");
INSERT INTO sim_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mashi kaso ome sira. Ma or mbele mbele Jisasik li urin heyeri oto angop os or heyendarin kormbak or saweri sir. Unda osik jir er nga erem ji hishika, mashi kaso ome sira. ");
INSERT INTO sim_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mbele mbele os li uri nombo orok mashi os jekambak mas li kayendari osmu omek nara. Mashi oso karem, �Mbeek kumba hava orhi las li jintlekwa ambu sir.� ");
INSERT INTO sim_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Uhu mashi las er nga li kayeri karem, �Avak li heyekwa ri, ma or kormek li jihindan.� Karem li kayeri sir. ");
INSERT INTO sim_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jisas or hashirik yanga Arimateak fehenda ma lar Pailatin or heyekurik ormu ira. Ma oto hi orhi Josep. Or er nga Jisasin tiyandari ma lar oria. Hako Judaman or ajendari osik or mbeek kormbak Jisasin tiyandari ambu ri. Or ihi Pailatin ormu silira, �Mir maninimba Jisashin mbashinak a laha ihi sunja akak a ewewa.� Karem or silirik Pailat mu mbara. �Wa, laha ika.� ");
INSERT INTO sim_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Urik Nikodemus ma or mas Jisasin nirik ta heyendari ma oto or taha mbele mbele arme kuvasahandari ondon 30 kilo hom or laha ormu rara. Mbele mbele arme kuvasahandari ondo hi frihi mir fre aloe. ");
INSERT INTO sim_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Uhu or nga Josep nga maninimba Jisashin ol arme kuvasahandari ondok fri ngoroho taha kowek frimu hevera, os Judama li undari nombo hom. ");
INSERT INTO sim_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Os Jisasin miandok li eweri mishi pasir nowe flaua mi ama nom sindari mishi sir. Orok mawa akri las nandari sir. Mawa oso mbeek ma lar li ewendari ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sabat am pasir si nakurik si narik Jisashi maninimban li laha mawa pasir orok nandarik frimu lai owera. ");
INSERT INTO sim_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande nirsumbu mendek Maria Makdaladak fehenda Jisashi mawak simu ira. Si ihi si heyeri sunja laka mawan li arangohondari oso angop li tembe haieweri sir. ");
INSERT INTO sim_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ushirik mawan si halaha Saimon Pita nga ma or Jisas or rupshindari ma oto nga si sawekurik simu ira. Si ihi fririn si heyehe simu sawera, �Maninimba Wasilakahi angop li lawa re. Hako nir mbeek os li laha ihi ewewa mishin ni heyewa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Karem si sawerik Pita nga ma oto nga shirinyambar Jisashi mawak frimu ira. ");
INSERT INTO sim_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Fri ihi ma or Jisas rupsindari oto Pitan or tikrihi masmas mawa orok ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Or ihi sunja aka os Jisasin li ewendari mishi hikrik or wantlokoho ormu simalera. Or simaleri kowe ol Jisashi maninimban li hevendari ondo nom sunja aka orok olmu wara. ");
INSERT INTO sim_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Urik Saimon Pita or taha nombok sunja aka akomek or layihi or heyeri Jisashi kowe nom olmu wara. ");
INSERT INTO sim_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hako kowe os masiji orhik li ishiri oso mbeek kowe ol maome orhin li ishiheveri kowe ondo nga nakrem wari ambu sir. Angop li hevehe apsham li eweshirik wari sir. ");
INSERT INTO sim_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Urik ma or masmas shirnyarari oto er nga aka akomek or layihi kowe ondon or heyehe ormu mbara, �Omendinga sira. Jisas angop usahawa ri.� ");
INSERT INTO sim_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hako oro wolok lir mbeek mashi os jekamba Avui Wasilakahik li kayendarin hishiri ambu lir. Mashi oso karem li kayeri sir, Jisas or hanak li wakor eweshinak indiyok usahakwa ri. Karem li kayehendari mashin hishiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ushihi mawan li halaha yangak limu ira. ");
INSERT INTO sim_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hako Maria nom nendekop mawa mashik simu sihi tlara. Uhu si wantlokoho mawan simu malera. ");
INSERT INTO sim_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Si malehe si heyeri ensel frijip kowe avishan fri falehe Jisasin li ewendari mishi orok frimu lira. Lar kumbasantle yok lar masiji yok karem frimu lira. ");
INSERT INTO sim_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Uhu sirin frimu silira, �Apmanuwa, mberem ushiwak nyi tlanduwa?� Urik simu mbara, �Wasilaka anhi angop li laha iwa re. Hako an mbeek os li ewewa mishi oson a heyewa ambu nir!� ");
INSERT INTO sim_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Karem si mbashihi si tormblehe ma lar simu heyera. Ma oto Jisas oria. Hako sir mbeek orin yawur heyekrahakorori ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Urik Jisas ormu silira, �Apmanuwa, mberem ushiwak nyi tlandu? Lawen nyi lasa fuhu torok nyi sihi tlandu?� Hako Maria karem hishiri sir, ma roto noumashama ria. Uri osik simu silira, �Awasayi, os maninimba orhin mi laha i nahi, os mi ewewa mishi oson mi sawenak a misiwa. Uhu avak a ihi maninimba orhin a laka.� ");
INSERT INTO sim_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Karem si mbarik ormu mbara, �Maria.� Urik Maria si tormblehe Hibru mashik simu mbara, �Rabonai.� Mashi oso maintontlo sihi �Tisa.� ");
INSERT INTO sim_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Urik ormu mbara, �Anin tolowa hala! An mbeek Avui anhik a lawu namber. Hako nyir avak nyi ihi ol anin tiyanda man karem sawe, an avak Avui anhi yangak a ikwa nir. Avui anhi Avui jihi ria. Avui Wasilaka anhi Avui Wasilaka jihi ria.� ");
INSERT INTO sim_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Karem or mbarik si ihi Jisasin tiyandari ma ondon si i heyehe simu sawera, �An Jisas Wasilaka nihin angop a heyewa nir.� Uhu mashi os sirin or saweri oson lirin simu sawera. ");
INSERT INTO sim_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Am Sande nirik si narik Jisasin tiyandari ma ondo li tirsaha aka lasik limu lira. Judaman li aje mendehe akayangan arme mendek li koso arangoho aka orok mayam limu lira. Urik Jisas tumsar or taha os li liri nindi orok or sihi ormu mbara, �Ji ajewa ji hala. Ji waphimbijihi ji lika.� ");
INSERT INTO sim_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Karem or mbaha tava orhi nga maome orhi nga os li jihindari wa oso nga lirin ormu mukura. Urik orin li heyehe limu rupshi mendera. ");
INSERT INTO sim_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Urik indiyok ormu mbara, �Ji ajewa ji hala. Ji waphimbijihi ji lika. Avui anhi or mbashirik a rahanda hom jirin avak erem a mbashinak ikwa jir.� ");
INSERT INTO sim_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Uhu lirin or sumandama uhu ormu sawera, �Masikome Avui Wasilakahin jirin amu handuwa. ");
INSERT INTO sim_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Os kavakava ma li undan li sawenak ji mba, �Avui Wasilaka kavakava jihin laha ermbekwa ri.� Karem ji mba nahi, erem ukwa ri. Hako os ji mba, �Wahau.� Karem ji mba nahi, or er nga erem mbakwa ri.� ");
INSERT INTO sim_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas ma ol orin tiyandari ondon or ta heyeri wolo lihi lar mbeek orok nakrem liri ambu ri. Ma oto hi orhi Tomas oria, hi yeje orhi Didimus oria. ");
INSERT INTO sim_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Urik am or tarik limu sawera, �Nir Wasilakan angop ni heyewa ri.� Karem li sawerik ormu mbara, �Jir mbafirimbaw te! An os anhinjik tava orhin nilik li tirinda wa ovro nga aima orhik li jihinda wa oso nga na heyehe tava anhik a tolona ambu nahi, an mbeek mashi os ji sawewa oson a misikwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Urik wik las si irik indiyok aka lasik limu lira. Oso wolo Tomas er nga liri ri. Akayangan armek li koso arangoho akomek liri lir. Urik Jisas tumsar or taha lihi nindik or sihi ormu mbara, �Ji ajewa hala. Ji waphimbijihi ji lika.� ");
INSERT INTO sim_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Uhu Tomasin or heyehe ormu mbara, �Tomas, mir tava mihin laharaha tava anhi kavrok eweheyeka. Uhu anin li jinda wa karok eweheyeka. Wavu mihi frijip frijip hishiwa hala! Mir anin hishioweka!� ");
INSERT INTO sim_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Karem or mbarik Tomas mu mbara, �Mir Wasilaka anhi mira. Mir God anhi mira.� ");
INSERT INTO sim_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Karem or mbarik Jisas ormu mbara, �Anin li jihinda wa kandon mi heyehe os mimu mbanduwa, Jisas indik usahari toria. Omendingak mirin amu sawenduwa, ma ol anin heye namber men mashi anhin misihi mba, �Mashi kaso ome sira.� Karem mbanda ma ondo Avui anhi armek or ukwa lira.� ");
INSERT INTO sim_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas ma undahi ambu lal nga nor urik orin tiyandari ma ondo heyeri lir. Hako mbele mbele amber ol or uri ondo mbeek jekamba torok li kayeri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hako maintontlo os li kayehendari karem, ma ol mashi kason misiwa ondo avak li heyeyarikwa sir, Jisas Krais oria, Avui Wasilakahi jikisi oria. Hulaima nokopman jivinakurik or kamahanda ma ria. Os orin ji hishiowe nahi, jir avak ermba ermbak linda oson lakwa jira. ");
INSERT INTO sim_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Niri lal am li ishirik Jisas indik ol orin tiyandari ma ondohik leuku Galili orok talari ri. Leuku oso hi yeje sihi Taiberias, karem li ushandari sir. ");
INSERT INTO sim_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Os or talari wolo Saimon Pita nga, Tomas Didimus nga, Nataniel yanga Kana Galilik fehenda oto nga, Sebedihi jikisi ovro nga, maome frijip er nga, leuku orok limu lira. ");
INSERT INTO sim_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Orok li i lihi Saimon Pita mu mbara, �An am a foom kruwuk iku.� Urik ma ondo amber limu mbara, �Nir ngana.� Uhu bot oson li laha limu ira. Hako niri oso wolo mbeek foome lal kruwuri ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Am nirsumbuk si narik indik fa mambuk limu rara. Li raha li heyeri Jisas fa hapsishi yok ormu sira. Hako lir mbeek orin heyekrahakorori ambu lir. ");
INSERT INTO sim_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Urik ormu silira, �Awasayi, foome lal am jimu krundu mo?� Karem or silirik limu mbara, �Wahau te!� ");
INSERT INTO sim_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Urik ormu mbara, �Foom kowe oson bot tapmama yok ji ermbehe avak foomen ji kruka.� Karem or mbarik os or mbari nombo hom limu ura. Uhu foom kowen li longo larasakmbaha limu ura. Hako foome musha mendek li nari osik mbeek li longo larasa ewekurik nari ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Urik Jisasin tiyandari ma or Jisas rupshi mendendari oto Pitan ormu sawera, �Ayo, ma oto Wasilaka nihi toria.� Karem or mbarik Pita kowe orhin indik or falehe fak or kweina falayihi fa heyehe Jisasin heyekurik ormu ira. ");
INSERT INTO sim_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Urik ma 7-pela ondo nom botik li lihi foom kowe oson limu longoho laharara. Pasir fa mambuk li siri osik lewas foom kowen mishi yok limu longo larasaowera. ");
INSERT INTO sim_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Uhu fa mambuk li raha li heyeri Jisas hin or tiyaha foome lal or suwushirik bret lal nga olmu orok wara. ");
INSERT INTO sim_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Urik ormu mbara, �Foome ol ji kruwa lal ji laharanak er nga hik a suwuka.� ");
INSERT INTO sim_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Urik Saimon Pita botik or ihi foom kowe oson or longoho fa mambu yok ormu larasara. Foom kowe oso angop hoje menderi sir. Foome ol li kruwuri 153-k nari lir. Hako foom kowe oso mbeek korori ambu sir. ");
INSERT INTO sim_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Urik Jisas ormu mbara, �Kolok ji raha ji aka.� Hako ma ol orin tiyandari ondo mbeek orin siliri ambu lir, �Lawe mir?� Angop li heyehe li mba, �Jisas toria�, karem hishiri ola. ");
INSERT INTO sim_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Urik Jisas foome nga bret nga nor toltavaha lirin or harik limu ara. ");
INSERT INTO sim_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Oso hindi nalmingrip Jisas ol orin tiyandari mak or talari sir. Os or harik li wakor eweshirik indik or usaha misambik nor liri wolon. ");
INSERT INTO sim_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jisas nga ma ol orin tiyandari ondo nga am li arakoshihi Jisas Saimon Pitan ormu silira, �Saimon jikisi Jonhi mirin, ma rondo anin wavu lihik ewenda lir. Hako mir anin wapnuku mende mihik ewenda om?� Karem or silirik ormu mbara, �He, Wasilaka, mir angop mi heyewa sir, an mirin amu rupshinduwa.� Urik ormu mbara, �Mir avak sipsip anhi ondon armek washilihi akwan hanak li aka.� ");
INSERT INTO sim_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Karem or mbaha indik ormu silira, �Saimon jikisi Jonhi mirin, anin wapnuku mihik ewenda om mo wahau?� Urik ormu mbara, �He, Wasilaka, mir angop mi heyewa sir, an mirin wapnuku anhik a ewenda nir.� Urik ormu mbara, �Mir avak sipsip anhi ondon armek washilika.� ");
INSERT INTO sim_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Uhu indik Pitan ormu silira, �Saimon jikisi Jonhi mirin, anin wapnuku mende mihik ewenda om mo wahau?� Karem indik or silirik sunguwavu orhi kavak si narik or holoho ormu mbara, �Wasilaka, mbele mbele os wavu anhik nawan angop mi heitakowa sir. An mirin wapnuku anhik a ewenda nir.� Urik ormu mbara, �Mir avak sipsip anhi ondon armek washilihi akwan hanak li aka.� ");
INSERT INTO sim_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Uhu mashi las nga ormu mbara, �Saimon, omendingak mirin amu sawenduwa, os ermbasik mi nari wolo os mi ikurik mi hishiri nombo hom yandari mira. Hako os avoko lakak mi nawa wolo ma lal avak li taha tava mihin li tatoloho yanga os mi ikwak mi hishiwa mishi ambu orok li laha ikwa mira.� ");
INSERT INTO sim_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mashi os Pitan karem or mbari Pita or hakundari nombon or saweri sira. Ushinak os or hakwa nombok hi Avui Wasilakahi wasilakak nakwa sira. Uhu mashi las nga Pitan ormu mbara, �Mir ta anin tiyaka!� ");
INSERT INTO sim_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Urik Pita or tormblehe ma or Jisas rupshi mendendari oton ormu heyera. Ma oto mas os akwan li ari wolo Jisas nga nakrem fri lihi orhik or lafaendehe karem orin siliri ri, �Wasilaka, lawe avak mirin wutarihi tavak halaku?� ");
INSERT INTO sim_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Karem mbahandari ma oton Pita or heyehe Jisasin ormu silira, �Wasilaka, ma toto kumak avak mberem orvai naku?� ");
INSERT INTO sim_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Karem or silirik ormu mbara, �Oso lerawu mihi os? Os a mba, er or linak indik a rakwa nir. Os karem a mba nahi, oso mbeek lerawu mihi ambu sir. Hako mir men anin tiyaka!� ");
INSERT INTO sim_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Urik Jisas mbari mashi oson karem limu haisau handasawe ira, �Ma oto hakwa ambu ri.� Hako Jisas mbeek erem mbari ambu ri, wahau. Or karem mbari ri, �Os ma oton a mba, or linak indik a rakwa nir. Os erem a mbawa oso mbeek lerawu mihi ambu sir. Oso lerawu anhi sir,� men karem mbari ri. ");
INSERT INTO sim_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ma or Jisashi mashin misihi heyendari ma oto mu jekamba kason kayera. Unda osik nir nga erem nimu mbakuwa, mashi kaso omendinga sira. ");
INSERT INTO sim_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mbele mbele anandi lal nga mushak Jisas uri lir. Hako os lerawu or lari ondo amber li kayerakohondakop buk ondo musha mendek warje nga nawa lir. Uhundakop mbeyok livai eweku? Wahau. Misambi sainawa sir. Unda kasira. Ambehoma. ");
INSERT INTO sim_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofilus, jekamba maifu os mas mirnjik a kayeri oso karem, mbele mbele ol Jisas undari nga mashin or sawendari nga amber hom angop a kayerakori sira. Os or sishihi lerawun or lala raha Avui orhi orin or laha hevenik or lalawuri wolo nga oson amu kayeri sira. Or lalawu namber, Masikome Avui Wasilakahi orin or sauharik aposel ol or kamandari ondon ormu sawera, lerawu os kumak li lakuri oson. ");
INSERT INTO sim_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas nomorawun or kishaha miandok hari ri. Hako Avui Wasilaka mbarik indiyok or usaha niri 40-k aposel ondohik kormbak or talaha mbele mbelen or urik li heyekrahakoroho limu mbara, �Omendinga sira. Jisas or hari angop Avui Wasilaka mbarik usahari ria,� karem limu mbara. Os lihik or talari wolo, Avui Wasilaka arangoshinak jip li likuri oson ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Os lir nga nor lihi li ari wolo lirin ormu sawera, �Avak kolok kolaka Jerusalemin ji hala iwa hala. Yawur ji nikishika. Unak Avui anhi os jirin or hakmbaha nor mbarik a sawerik ji misiri oson avak or haka. Ushinak oson ji laka. ");
INSERT INTO sim_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon fambak man tolofalendari ria. Hako nambek nakwa ambu sir, avak Avui Wasilaka or mbashinak Masikome orhi or takaha jihik sikwa ri,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ushinaha nindi wolo lasik indik lirik ormu talara. Uhu telemba Oliv, karem li ushandari orok lir nga nor lirik limu silira, �Wasilaka, avak ter wolok wutari nihi Romik fehendan mi tukru ermbehe malakama nihik mi naha nirin arangoshinak jip ni likwa on? Mo wahau?� ");
INSERT INTO sim_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Karem li silirik ormu sawera, �Oso mbeek lerawu jihi ambu sir. Os erem si nakwa wolo oso Avui Wasilaka nom angop or heyehe nor mbahanda sir. ");
INSERT INTO sim_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hako os ji heyekwa karem. Avui Wasilaka avak Masikome orhin or halashinak or takaha jihik or sinak kwambu nga ji naha mashi anhin laha yanga yangak saweikwa jira. Jerusalemik ji sawehe provins Judiak ji sawehe provins Samariak saweyakwa jira. Er ji sawe ihi misam sumbu lersuwu sumbuk er ji sawerakokwa sira.� ");
INSERT INTO sim_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas mashi oson am or sawerakorik Avui Wasilaka mu orin lalawura. Orin or lalawurik li sishi mawurik lersuwu avisha kwandi hom orin si arangoshirik mbeek li heyeri ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Or lawurik li sishi mawurik kolok ma lap kouavishan fri falehe os li siri mishi orok frimu talasira. ");
INSERT INTO sim_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Uhu frimu mbara, �Hai, Galilik fehenda ma jirin. Mberem ushiwak torok ji sishihi lersuwu yok ji sishi mawundu? Jisas or ji heyewak Avui Wasilaka jihi nindik or laha hevenik or lalawuwa Jisas orto, avak os Avui Wasilaka orin or lalawuwak ji heyewa hom kumak erem indik rakanak ji heyekwa ria,� karem frimu mbara. ");
INSERT INTO sim_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Karem fri saweshirik li misihi telemba Oliv oson li halaha, indiyok Jerusalemik li ikmbaha li layi limu lawura. Telemba Oliv oso Jerusalem nga pasir nanda sira. ");
INSERT INTO sim_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Am Jerusalemik li layihi, aka os heyersiyer li undari aka heyeyok limu lawura, os li waha yandari mishi orok. Aposel ol orok liri ondo hi lihi karem, Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Alfiushi jikisi Jems, Saimon, Judas, karem nandari lira. Saimon oto ma ol Romik fehe gavmanin li jihi tukru ermbenak li ikmbaha undari ondo lar oria. Judas oto Jems ome larhi jikisi ria. ");
INSERT INTO sim_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma ondo amber orok li tirsaha wavu namtaskop li hishihi Avui Wasilakan sawendari lira. Nokove lal er nga liri lira. Jisas nijava orhi Maria nga jimatama orhi ondo nga li tirsaha Avui Wasilakan sawendari lira. ");
INSERT INTO sim_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Oro wolok Jisasin hishindiyandari ma 120 hom li tirsaha li lirik Pita lihi nindik or usasihi ormu mbara, ");
INSERT INTO sim_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","�Mahasanje anhi jirin, mas Masikome Avui Wasilakahi or sauharik mbele os Judashik nakurin Devit or mbahandari mashi oso osmu jekamba Avui Wasilakahik nanduwa, Judas oto nombon or mukushirik Jisasin li tolohondari ma ria. Devit mbari mashi oso osmu omendingak erem nari sira. ");
INSERT INTO sim_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mas wolo Judas nakrem nir nga nor sihi lerawun nakrem nir nga ni landari ria.� ( ");
INSERT INTO sim_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas Jisasin Judama lida lihi tavak or harik orin yan limu hara. Urik ya os li hari orok misambi las ormu frungawura. Uhu misambi orok masiji yok or takatukuyirik sungu orhi si tavarik simbalesik meryalangu misambik si orko takarik ormu hara. ");
INSERT INTO sim_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Urik ma ol Jerusalemik lindari ondo amber mashi os erem nari oson limu misira. Uhu misambi oso maintontlo orok fi ngoronda mishi, karem limu ushara. Mashi lihik Akeldama, karem li ushandari sir.) ");
INSERT INTO sim_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita mu mbara, �Os mas king Devit or mbahandari mashi oso Buk Songik li kayehendari karem, �Halanak aka orhi men er si sihi si tarvlarakaka. Avak ma lar aka orok or liwan or hala.� Hovok mashi ome las Devit or mbahandari karem li kayehendari sir. �Lerawu os or lahanda oso halanak ma lar orhi farniyik or sihi lerawu oson or laka.� ");
INSERT INTO sim_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Uwa osik ter ma lar nihi nindik nimu kamakuwa. Ma oto os mas Jon Jisasin fak or tolofaleri wolok sishi raha Jisas or haha indiyok or usaha hevenik or lawurik heyeri ma oton nimu kamakuwa. Or nir nga nakrem or liyaha os Jisas misambi torok lerawun or laha nor yandarin misokome orhik heyenda ma ri. Ushinak nir nga nor sihi mashi os Jisas mawak or usahari oson avak nir nga ni saweyaka.� ");
INSERT INTO sim_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita karem or mbashihi ma lap frijip limu kamara, Josep nga Matias nga. Josep oto Barsabas karem li ushandari ria. Hako hi yeje orhi Jastus oria. ");
INSERT INTO sim_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Uhu Avui Wasilakan li sawehe limu mbara, �Wasilaka, mirtonom sunguwavu nihin amber mi heyerakonda sira. Mir avak ma tovro lar or mi kamawa man mukunak ni heyeka. ");
INSERT INTO sim_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ushinak Judashi farniyik or sihi avak aposelik or naha lerawu os Judas landari oson avak or laka. Judas angop or haha yanga os or ikmbaha mi mbahandari mishi orok iri ria.� ");
INSERT INTO sim_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Karem li mbashihi kolok satu Matiashi nga satu Josephi nga li laha limu ormbera. Urik satu Matiashi mu talara. Urik orin li laha aposel 11-pela ondo nga li halashirik ormu sira. ");
INSERT INTO sim_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos, karem li ushandari wolok am si narik Jisashi mashin misindiyandari ma ondo lasikop limu talandirsa lira. ");
INSERT INTO sim_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lasikop li tirsaha li lirik, kolok heven yok suwa laka rasandari hom si hukwasihi aka os li liri oson simu hojera. ");
INSERT INTO sim_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Urik li heyeri kolok hi tarvle hom nari oso lir namtarmba namtarmba lihi lihik simu nara. ");
INSERT INTO sim_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Urik Masikome Avui Wasilakahi lir nga nor sishi nor sauhari hom yanga apsham apshamhik fehe mashi orok limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Judama ol Avui Wasilakahi mashin yawur tiyandari ondo lal yanga yanga lihi homek nandan li halaha, li taha Jerusalem orok er nga lindari lir. Mashi lihi apsham apsham nandari lira. ");
INSERT INTO sim_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma ondo hukwa oson li misihi amber limu talandirsara. Uhu mashi mashi lihi indingak li mbarik li misihi li lishnyafaha wavu musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Uhu limu mbara, �Ma tondo Galilik fehenda numbu ol te. ");
INSERT INTO sim_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Wa, mberem ushiwak mashi nihi nihik li mbawak ni misindu? ");
INSERT INTO sim_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nir Judama lal kuyanga Partiak linda nga Midiak linda nga Elamik linda nir. Hovok nir lal kuyanga Mesopotemiak linda nga Judiak linda nga, Kapadosiak linda nga Pontusik linda nga Esia, ");
INSERT INTO sim_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia nga, hovok Ijip nga Libia, os pasir Sairini nga nanda orok linda Judama nira. Hako nir lal Romik fehenda torok ni ta liwa nir. ");
INSERT INTO sim_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nir lal Judama nira. Lal Judama ambu ol nir nga nakrem ni lotu unda lir. Hovok nir lal ailan Kritik fehenda nga lal kuyanga Arebiak fehenda nir. Hako nir amber ni misiwa lerawu jivindinga Avui Wasilaka or lahandan mashi nihi nihik li sawewak nimu misinduwa.� ");
INSERT INTO sim_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Uhu amber er li lishnyafa wavu musha mushak limu hishira. Uhu lihi ambek limu anasilira, �Mberem si nawak tos ter li mbandua?� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hako lal olmu okolehe mbara, �Ma rondo angop wain uku akri kas amba amba li awa osik olmu ambarambasihi mbandu,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Urik Pita aposel 11-pela ondo nga nor sihi wasilaka mendek ormu sawe mbara, �Jir Judama nga jir Jerusalemik taha linda ma jir nga, mambla jihin ji owehe mashi anhin ji misi. Unak avak tos ter nawak ji heyewa toson a sawenak ji misikrahakoroka. ");
INSERT INTO sim_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jir ji hishiwa, nir ni uk aha ni ambarambasiw, karem jimu hishindu? Hako wahau. Ter nirsumbu 9 kilokik nawa sir. Mbeek wain ukun li aha ambarambasinda wolok nawa ambu sir. ");
INSERT INTO sim_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tos ter nawak ji heyewa toso angop mas wolok profet Joel or mbahandari hom osmu ter nanduwa. ");
INSERT INTO sim_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mas profet Joel karem or mbari osa, �Avui Wasilaka karem or mbari sir. Kumak mbele mbele am mendek si nakuna wolok si nanak avak Masikome anhin a halashinak or layi ma amber lihik sikwa ri. Ushinak jikishulayi jihi nga jikisnokopji jihi nga mashi anhin profet hom sawekwa lira. Unak jikanda ermbasi avak mbele las a mukunak sukwa heyenda hom heyekwa lir. Unak avoko laka avak mbele las a mukunak sukuwa heyekwa lir. ");
INSERT INTO sim_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oso wolo avak Masikome anhin a halashinak hulaima nokopma ol lerawu anhin landa ondohik or sishinak avak profet hom mashi anhin sawekwa lir. ");
INSERT INTO sim_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Avak a unak mbele mbele apsham apshamhi ondo lersuwu yok talakwa lir. Unak misambi yok mbele mbele ma undahi ambu ondon a ukwa lir. Ondo fi nga hi nga, hikrish nakrisha nga nakwa sir. Hikrisha avak wasilakak si mborje tasahavikwa sir. ");
INSERT INTO sim_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta avak or tormblehe nirtle sirinda hom nakwa ri. Niyaka avak si tormblehe fi hom heyekwa sir. Ushinak kuma Wasilaka takwa ria. Os or tawa wolo kwambu orhi nga or tanak ukru harujakwa sira. ");
INSERT INTO sim_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Erem si nana wolok ma ol Wasilaka lirin or jivinakmbaha orin ushawa ma ondo amber avak or lalawu oweshinak jipjip likwa lir.� Mashi kaso profet Joel mas or sawehendari mashi kasira. ");
INSERT INTO sim_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hai, yanga Israelik fehenda ma jirin, ji mambla arngalaha mashi anhin ji misi. An jirin Jisas Nasaretik fehendahi mashin a sawekwa nira. Avui Wasilaka lerawu wasilaka kwambu ngashi nga mbele mbele apsham apshamhi nga ma undahi ambu nga tava Jisashik jihi nindik or larin angop ji heyeri sir. Avui Wasilaka erem or ushinak ji heyehe ji mba, �Omendinga sira, Avui Wasilaka mbashiwak tawa ma toria,� karem ji hishikmbahan. ");
INSERT INTO sim_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Uhu os maskop Avui Wasilaka or hishihi nor ukmbaha nor mbahandari hom ma oton tavarenje jihik ormu halashira. Urik tavarenje ma kava ondohik orin miandok ji tirihi ji mandingormeshirik ormu hara. ");
INSERT INTO sim_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hako Avui Wasilaka or mbarik indiyok mawak usahari ria. Mbeek mawa oso orin toltangrindahik nari ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mas wolo Devit angop orin karem or mbahandari sir. �An Wasilakan a heyewa or ermba ermbak a ngashi sinda ri. Or anin or jelyashihinda osik wutari mbeek anin jihi tukru ermbendahi ambu lir. ");
INSERT INTO sim_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Erem si nawa osik sunguwavu anhi mende nga amu rupshinduwa. Uhu a hakwan a ajenda ambu nir. Mberem ushiwak? ");
INSERT INTO sim_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","An lerawu mihin a laha jivi mendek a nanda nir. Avak mi halashinak mbeek ma ol haha li linda mishi orok a likwa ambu nir. Unak maome anhi mbeek mawak kuvayikwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nombo os ermba ermbak linda oson angop anin mi mukuri sir. Avak mi halashinak an mir ngashi likwa shir. Uhu mi unak a rupshi mendekwa nir.� Mashi kaso Devit mu mbahandari sira. ");
INSERT INTO sim_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mahasanje anhi jirin, an kormbak a saweshinak ji misikwa karem, neloko nihi Devit, or harik angop li wakor oweri ria. Uhunda mawa orhi ter os er nandu. ");
INSERT INTO sim_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hako Devit oto profet orik angop or heyeri sir, Avui Wasilaka kuma kumak jinirmbanira orhi lar or kamashinak or lindari hom kingik or naha nor likurin. ");
INSERT INTO sim_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Uhu Devit mashin or sawe nor mbar, �An Avui Wasilaka halashinak mbeek ma ol haha ihi li linda mishi orok a likwa ambu nir. Uhu mbeek or halashinak maome anhi mawak kuvayikwa ambu sir, wahau.� Hako, mashi os Devit karem or mbari oso mbeek maome orhin or mbari ambu sir, wahau. Avui Wasilaka mbele mbele os kumak or ukundari oso Devit angop or heyeri sir. Devit mbari ma oto Krais, hulaima nokopman jivinakmbaha Avui Wasilaka kamahanda ma ria. Oto Jisas oria. Os or mbari oso Krais or haha indiyok or usahakurin ormu mbari sira. ");
INSERT INTO sim_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Avui Wasilaka or mbashirik Jisas oto mawan or halaha indiyok usahari ri. Nir amber angop ni heyeri osik mashi kason nimu saweyanduwa. ");
INSERT INTO sim_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jisas angop or lawuhu ormu tapmama Avui Wasilakahik linduwa. Urik Avui Wasilaka os mas orin or hakurik or mbahandari hom Masikome orhin ormu tava orhik hara. Ushiwak ter Jisas or nga halashiwak Masikome or takaha ormu nir nga sinduwa. Uhu Masikome ortonom or sauhawak ni sawewak jimu misinduwa. ");
INSERT INTO sim_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devit mbeek hevenik iri ambu ri, os Jisas iri hom. Hako Devit karem or mbahandari ri, �Avui Wasilaka, Wasilaka anhin ormu sawera, �Mir tapmama anhik lika. Unak wutari mihi ondo avak a halashinak mihi siyok sikwa lir.� � ");
INSERT INTO sim_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Erem nawa osik, Israelik fehenda ma jirin, jir amber karem krahak ji hishika. Avui Wasilaka Jisas or miandok ji tirihi ji mandingormeri oto angop or kamashihindak Wasilaka nihik or naha Kraisik nawa ri.� ");
INSERT INTO sim_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita mashi oson erem or sawerik li misihi wavu lihi si jirik Pita nga aposel anandi ondo nga limu silira, �Hai, mahasanje nihi jirin, wa mberem nivai uku?� Karem li silirik, ");
INSERT INTO sim_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita mu lirin sawera, �Jir amber sunguwavu jihin ji tormblehe kavakava ol ji undan ji halaha Jisas Krais nga nakrem ji sihi kwambu orhik fak ji layika. Ushinak Avui Wasilaka kavakava jihi ondon or yoko ermbeka. Erem ji unak Masikome orhin jirin or haka. ");
INSERT INTO sim_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Masikome orhin ma ol or kamahanda ondon or hakmbaha angop or mbahandari sir. Undari osik jir nga jikisi jihi nga ma ol homek liwa ondo nga nor hakwa sir.� ");
INSERT INTO sim_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita hovok mashi musha anandi lal nga nor sawehe mainkwambuk lirin ormu mbara, �Jir Avui Wasilakan ji sawenak jirin or jivinaka. Las avak jir er nga ma ol misambi torok fehe kavakavan unda ma ondo nga kavak ji nanda ngashi.� ");
INSERT INTO sim_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Karem or mbarik ma mushak mashi orhin li misindiyaha fak limu layira. Oso wolo ma ol fak layiri ondo 3,000 hom nari lir. Uhu lir nga nakrem limu tirsara. ");
INSERT INTO sim_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hulaima nokopma ondo aposel saweri mashin li misihi limu toltambanara. Uhu lasikop li talandirsaha nakrem Avui Wasilakan li sawehe komunionin andari lir. ");
INSERT INTO sim_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Urik Avui Wasilaka mbele mbele ma undahi ambu ondo musha mendek tava aposel ondohik ormu ura. Ushirik Jerusalemik lindari ma amber oson li heyehe limu ajera. ");
INSERT INTO sim_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma ol Jisashi mashin misindiyandari ma ondo ermba ermbak li talandirsaha mbele mbele lihi ondon li owendirsaha lihi ambek li haihandaha landari lir. ");
INSERT INTO sim_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Uhu li halashirik ma lal mbele mbele lihi nga misambi lihi nga yak li frungawundari lira. Ushirik ya ondon li humasihi erndakava ondon limu handara. ");
INSERT INTO sim_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ermba ermbak tempel aka orok li tirsaha lotu undari lir. Uhu aka akak li tirsaha komunionin li aha li anahaha lihi ambek li ananjelyaha rupshihi lindari lir. ");
INSERT INTO sim_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Uhu ermba ermbak hi Avui Wasilakahin hauowendari lir. Urik ma amber lirin li heyehe limu mbara, �Ma rondo jivi mende lira,� karem limu mbara. Urik Avui Wasilaka ermba ermbak man or larik Jisashi mashin misindiyari mak li naha musha mendek limu nara. ");
INSERT INTO sim_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nindi las wolok Pita nga Jon nga am 3 kilokik si naha si homikurik Judama Avui Wasilakan li sawendari wolok si narik tempel akak frimu layikmba ira. ");
INSERT INTO sim_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Uhu fri heyerik ma lal ma lar kumba nashindari oton li kisha laharaha tempel akayanga sumbu orok li oweshirik ormu lira. Kumba orhi ovro angop nijava orhi orin si wari wolokop er nashindari vri. Ermba ermbak li kisha lahara oweshirik lindari ma ria. Akayanga oso �Akayanga arme mende� karem li ushandari sira. Orok or lishihi ma ol tempel akak layikmba iri ondon ya mbele mbelenjik lishi silindari ma ria. ");
INSERT INTO sim_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma oto or lihi nor heyerik Pita fre Jon opmu tempel akak layikurik tara. Urik fririn ormu yanjik silira. ");
INSERT INTO sim_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Urik Pita nga Jon nga orin er frimu heilatalera. Uhu Pita mu mbara, �Hai, mir shirin heye.� ");
INSERT INTO sim_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Urik ma oto ya lal orin fri haku, karem mbaha normu fririn lishi heyera. ");
INSERT INTO sim_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hako Pita ormu mbara, �An ya ngashi ambu nir. Hako mbele las anhik nawan mirin a hakwa karem, kwambu Jisas Krais Nasaretik fehendahik amu mbanduwa. Mir usaha ese ika.� ");
INSERT INTO sim_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Karem or mbaha tapmama orhin or toloho nor jelyarik ormu usasira. Urik lewas kumba orhi jivik er frimu nara. ");
INSERT INTO sim_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Urik or kweina usaha normu ese ira. Uhu frir nga tempel akak limu layira. Li layihi er or rupshihi sanglai sanglaraha hi Avui Wasilakahin ormu hauowera. ");
INSERT INTO sim_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hi Avui Wasilakahin or hauowehe or ese sihi yarik orok siri ma amber limu heyera. ");
INSERT INTO sim_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Orin li heyehe limu hishira, �Ma roto kar ermba ermbak tempel akayanga, �Arme mende� torok or lishihi ya mbele mbelenjik silinda ma toria.� Karem mbaha li heyeri angop jivik or nashirik li heyehe li lishnyafaha wavu musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ma ondo mbele mbele os talarin li misihi warje mende nga er lishnyafari lira. Uhu ma oton li heyekurik limu shirinya rara. Uhu li heyerik Pita fre Jonin or toltambanaha tempel akanivi orok ormu sira. Oso �Solomon undari akanivi� karem li ushandari sira. ");
INSERT INTO sim_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ma ol shirinya tari ondon or heyehe lirin ormu sawera, �Jir Israelik fehenda ma jirin, mberem ushiwak tos talawan ji heyehe ji lishnyamashnyandu? Uhu mberem ushiwak shirin ji washiolondu? Shir shihinjik kwambu ngashi naha ma toton shi mbawak jivik or naw, karem jimu hishindu? Wahau. Mo shir misokome Avui Wasilakahik jivi mendek shi naha ma roton shi mbawak jivik or naha or usasiw, karem jimu hishindu? Wahau te. ");
INSERT INTO sim_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Avui Wasilaka misimu walanga nihi Abraham, Aisak, Jekop lihi Avui Wasilaka oria. Unda Avui Wasilaka oto mu lerawu orhin landa ma Jisas oto hi orhin wasilaka mendek ormu hauowera. Hako jir ji turaha orin li mandingormekmbaha wutarihi tavak jimu halara. Pailat or halashinak or i, karem or mbari. Hako jir orin ji turaha jimu kumaifara. Ushirik Pailat mbeek or halashirik or jip iri ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ma oto jivi mendek or naha jivi jivi nom undari ri. Hako jir orin jimu kumaifara. Uhu jir Pailatin ji ushasawe ji mbashirik man mandingormendari ma yejen or halashirik jip iri ri. ");
INSERT INTO sim_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Uhu ma or ermba ermbak linda oson handa ma oto or jimu mandingormera. Hako Avui Wasilaka or mbarik indik or usahari angop shi heyenda osik os shimu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwambu Jisashik shi mbawak ma roto jivik or nawak jimu heyenduwa. Ome sira. Mashi Jisashin shi misindiyanda nombo orok shi mbawak ma roto lewas jivi mendek or nawak os jimu heyenduwa. ");
INSERT INTO sim_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Omendinga sir, mahasanje. An angop a heyewa sir, jir nga lida jihi ondo nga jir Jisas or nirin jivinakmbaha Avui Wasilaka mbashirik tari oton ji heyekrahakorori ambu osik or jimu mandingormera. ");
INSERT INTO sim_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hako mas profet ondo amber Avui Wasilaka sauhari hom limu sawera, �Ma or Avui Wasilaka kamashinak hulaima nokopman jivinakwa ma oto nomorawun or kishaha hakwa ri,� karem limu sawera. Undari nombo hom, os jimu erem orin uri sira. ");
INSERT INTO sim_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Unda osik ter kavakava jihi os ji unda oson ji hala kumaifaha Avui Wasilakan ji hishindiyaka. Ushinak avak kavakava jihi oson or laha ermbeka. ");
INSERT INTO sim_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Os erem ji u nahi, Wasilaka avak kwambu akri orhin or hakwa jira. Uhu avak ma lar or kamaha nor mbashinak indik takwa ri. Ma oto Jisas oria, orhi man or jivinaha indik lakwa ma ria. ");
INSERT INTO sim_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ter ormu hevenik lihi nikishinduwa, mbele mbele amber Avui Wasilaka os or ushinak akrik li nakmbaha or mbahanda wolo oson. Erem li nakmbaha Avui Wasilaka profet orhi ondon or sauhashirik mas li sawendari sir. ");
INSERT INTO sim_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mas Moses karem or mbari osa, �Avui Wasilaka jihi or mbashinak ma lar jihi nindik avak an hom profetik nakwa ria. Unak jir mashi ol or mbawan amber ji tiyaka.� ");
INSERT INTO sim_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","�Os jir mashi orhin ji misi nahi ambu, avak Avui Wasilaka jirin or mandingormeshinak hakwa jir.� ");
INSERT INTO sim_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuelik sishihi kuma kuma talari profet ondo amber li sawendari mashi oso ter osmu omendingak talanduwa. ");
INSERT INTO sim_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jir jinirmbanira profet ondohi jira. Avui Wasilaka Abrahamin karem saweri ri. �Jinirmbanira mihi lar kumak a kamashinak ma misambik fehe amber or jivinashinak jip likwa lira.� Os suma oson neloko jihi ondo nga nor ishindari hom ma misambik fehe amber or unak jip likwa lir. ");
INSERT INTO sim_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Urik Avui Wasilaka lerawu orhin landa ma Jisas oton or mbashirik ormu tara. Masmas jir Judamanjik or mbashirik tari ria, or taha jirin armesarmek or ukmbahan. Uhu jir amber or jelyashinak mbele mbele kava os ji unda oson ji halakmbahan,� Pita karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita fre Jon ma ondon fri saweri hom, pris ondo nga Sadyusi ondo nga maifuk sihi tempel oson washilindari ma oto nga limu tara. ");
INSERT INTO sim_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Li taha fri saweri mashin limu misira karem, �Jisas angop indiyok usahari ri. Unda hom ma ol mas hahanda ondo kumak erem usahakwa lira.� Karem fri sawerik li misihi wasilaka mendek limu ngriara. ");
INSERT INTO sim_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Uhu kolok fririn li toloho krawuk limu owera. Am si krinyakurik si nari osik li wahandanakop fririn li kotim ukmbahan, karem hishiri ola. ");
INSERT INTO sim_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Hako ma ol mashi Jisashin misindiyari ondo angop musha mendek nari lir. Hulayi nom li kantiri 5,000 hom nari lira. ");
INSERT INTO sim_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Li wahandashihi Judama lida lihi ondo nga ma ol maifuk sindari ondo nga mashi Moseshin sawendari ondo nga Jerusalemik limu tirsara. ");
INSERT INTO sim_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hetpris Anas oto orok liri ri. Urik orhi krahak fehe Kaiafas, Jon, Aleksander nga ma anandi ol hetprishi krahak fehendari ondo nga orok tirsari lir. ");
INSERT INTO sim_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Uhu Pita fre Jonin li laharla owehe limu silira, �Shir mbel kwambu mende ngashi naha, lerawu oson shi landu? Uhu lawehi hik mbele mbele ondon shi uwak li talandu?� ");
INSERT INTO sim_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Karem mbarik Masikome Avui Wasilakahi Pitahik or sishirik lirin ormu sawera, �Jir lida Israelik fehenda nga maifuk sinda ma jirin, ji misika. ");
INSERT INTO sim_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ter ma or kumba nashindarin shi mbarik jivik or narin ji silikwak jimu hishindu? Uhu jir ma toto mberem or uhu jivik or nar, karem jimu mbandu? ");
INSERT INTO sim_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Os erem si na nahi, jir nga Israelik fehenda ma ondo nga amber ji heyeka. Kwambu Jisas Krais Nasaretik fehendahik kumba nashindari ma roto jivik nari ria. Uhu ter ormu jihi misokomek sinduwa. Hako jir mu Jisas oton miandok owe tirishirik ormu hara. Hako Avui Wasilaka or mbarik angop indiyok usahari ria. ");
INSERT INTO sim_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisas or wormbonawa indingan heimanda ri. Mashi Avui Wasilakahi karem mbahandari osa, �Jir akan unda ma ji heye ji mba, sunja toto kava, karem ji mbaha ji ermberi oto ter wormbonawa hom or naha ormu sinduwa.� ");
INSERT INTO sim_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jisas ortonom nirin jivinanda ma ri. Mbeek ma anandi lar hi orhik ni ushanak nirin jivinakwa ambu ri, wahau. Misambi torok Jisas hi orhikop ni ushanak nirin jivinakwa ri. Orto nom nirin jivinakmbaha Avui Wasilaka mu kamari ria.� ");
INSERT INTO sim_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Judama lida lihi ondo li heyeri, Pita fre Jon frir men ma kuyangak fehe vri. Hako mashi wasilakak fri mbaha kormbak fri sawehe mbeek ajeri ambu vri. Karem urik li heyehe wavu musha mushak limu hishira. Hako li hishihi limu mbara, �Ma tovro mas Jisas nga yandari vri.� ");
INSERT INTO sim_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Uhu ma oton li heyeri, angop jivik or naha ormu frir nga sira. Karem uri osik lir mbeek mashi las mbakurik nari ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Urik Judama lida lihi ondo fririn li mbashirik aka os li kot undari mishi oson fri halaha hikrik frimu layira. Am fri layishirik ma ondo mashi las limu mbara, ");
INSERT INTO sim_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","�Wa mberem nivai ma tovron uku? Ma tovro mbele las ma undahi ambu angop fri uri sir. Urik ma ol Jerusalemik linda ma amber angop li heyetakori sir. Wa, mbeek ni wanyindahi ambu. ");
INSERT INTO sim_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hako las avak mashi roson li haisau handasawe inda ngashi. Ka ni mainkwambuk fririn ni mbashinak mashi Jisashi oson fri sawewan fri halaka.� ");
INSERT INTO sim_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Karem mbaha li usharik indiyok fri layirik fririn li pantlehe limu mbara, �Avak mashi Jisashin shi owesawewa shi hala.� ");
INSERT INTO sim_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Urik Pita fre Jon lirin frimu sawera, �Wa, mashi Avui Wasilakahin shi tiyakwan shi halaha mashi jihin shi tiyakwa oso misokome Avui Wasilakahik or heyewa jivik nakwa os mo wahau? Jihinjik ji hishika. ");
INSERT INTO sim_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Hako shir mbeek mayam shi likwa ambu shir. Shir mashi oson er shi sawekwa shir. Uhu mbele mbele amber ol shi heyehe shi misinda mashi oson shi sawekwa shir.� ");
INSERT INTO sim_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Urik Judama lida lihi ondo hulaima nokopman li ajeri osik men mainkwambuk fririn li sawehe li mbashirik frimu ira. Ma amber Avui Wasilaka os or uri oson li heyehe hi orhin hausimbausiri lir. Erem nari osik malakama ondo mbeek fririn li kavak nakuri nombo kas nga nari ambu lir. ");
INSERT INTO sim_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ma or fri mbarik jivik nari ma oto asama orhi angop 40-n tikrindari sir. ");
INSERT INTO sim_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lida ondo Pita fre Jonin li halashirik indiyok fri ihi ol nakrem li yandari ma ondon frimu heyera. Uhu mashi mashi amber os bikpris ondo nga maifuk sindari ondo nga li mbari mashi oson lirin frimu sawera. ");
INSERT INTO sim_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Urik mashi oso li misihi amber nakrem wavu namtaskop li hishihi Avui Wasilakan limu sawera, �Wasilaka, mir mu lersuwu, misambi, fa, mbele mbele amber tol nawa rondo mirtonom mi uhundari lira. ");
INSERT INTO sim_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mas mi halashirik Masikome mihi neloko nihi Devitin ormu sauhara. Or lerawu mihin landari ma ri. Urik Devit karem ormu sawera, �Mberem ushiwak Judama ambu ondo li waplelenandu? Uhu nombo os Wasilakan kavak li nakmbaha li mbaolsolondu? Oso men sembe li mbanda sir. ");
INSERT INTO sim_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","King amber misambi torok fehe nga maifuk sinda ma nga olmu hundujenduwa, awun li uhu Wasilaka nga Krais nga kavak li nakmbahan. Krais oto hulaima nokopman jivinakmbaha Avui Wasilaka or kamahanda ma ria.� Devit karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Omendinga sira. Mashi oso ter osmu omendingak nanduwa. Herot nga Pontius Pailat nga Judama ambu ondo nga Israelik fehe ma ondo nga Jisasin kavak li nakmbaha yanga torokop tirsari lir. Or jivi mendek or naha mi kamashirik or sihi lerawu mihin lari ma ria. ");
INSERT INTO sim_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Os erem li uri oso mas mir mbahandari hom limu uri sir. Kwambu mihikop mas angop mi sawehendari sir, mbele mbele os talakurin. ");
INSERT INTO sim_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wasilaka, mir angop mi heyewa sir, mashi mashi os nir ajekmbaha li mbawa mashi oson. Hako mir avak nir lerawu mihin landa ma nirin jelyaka. Ushinak avak kwambu mendek ni sihi mashi mihin er ni saweka. Uhu avak ni ajewan ni halaka. ");
INSERT INTO sim_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uhu mir avak kwambu mihin nirin mi hashinak ni mbanak kavamisinda ma jivik li naka. Uhu nir avak mbele mbele apsham apshamhi nga mbele mbele ol ma undahi ambu ondo nga kwambu Jisashik ni uka. Jisas oto jivi mendek or naha angop lerawu mihin or lakmbaha mi kamahandari ma ria.� ");
INSERT INTO sim_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Am Avui Wasilakan li sawerakorik aka os li tirsaha li liri oso er simu nenawu jira. Urik Masikome Avui Wasilakahi lihik ormu sira. Ushirik mashi Avui Wasilakahin kormbak li sawehe mbeek ajeri ambu lira. ");
INSERT INTO sim_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ma ol Jisashi mashin misindiyandari ma ondo amber sunguwavu lihi nakremkop si nashirik wavu namtaskop hishiri lir. Uhu ma lar mbeek or mbar, �Mbele mbele anhi tondo anhi numbu lir,� karem mbari ambu ri, wahau. Mbele mbele lihi ondo amber hom lihik nari lir. ");
INSERT INTO sim_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel ondo mashi os Wasilaka Jisas indiyok or usahari oson kormbak kwambu mendek saweri lir. Urik Avui Wasilaka Jisasin hishindiyanda ma ondo amber armek ormu ura. ");
INSERT INTO sim_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mbeek ma lar lihi nindik akwa mbele mbelenjik frunguri ambu ri, wahau. Mberem ushirik? Lihi lal misambi nga nandari lir. Urik lihi lal aka nga nandari lir. Uhu li mbashirik ma anandi lal mu aka lihi nga misambi lihi nga limu frungawura. Ushirik yan limu lara. ");
INSERT INTO sim_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Uhu ya ondo aposel ondohik limu laharara. Ushirik aposel ondo li humasihi ma ol mbele mbele ngashi ambu ondon limu hara. ");
INSERT INTO sim_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma lar orok lindari ri. Hi orhi Josep oria. Ma oto man saumbornandari ma ri. Uri osik aposel orin Barnabashik limu ushara. Hi Barnabas oso mashi lihik man saumbornanda ma, karem li mbanda sir. Or kraha Livaik fehendari Judama ri. Uhu ailan Saiprusik fehendari ria. ");
INSERT INTO sim_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ma oto misambi orhi kas or mbashirik ma anandi lar mu frungawura. Ushirik ya os or lari oson or laha aposel ondon ormu hara. Ushinak erndakava ondon li jelyakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ma lar orok lindari ri. Hi orhi Ananaias oria. Nokove orhi Safaira sira. Ovro misambi frihi kas yan fri la, karem mbaha fri mbashirik ma lar mu frungawura. ");
INSERT INTO sim_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hako ya os misambi frihi orok fri lari oso kas frimu la wanyira. Ushihi or mbafirimbaha normu mbara, �Yan a lawa amber kalira.� Karem or mbaha ya ondon aposel ondon ormu hara. ");
INSERT INTO sim_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Urik Pita mu mbara, �Ananaias, mberem ushiwak mi halashiwak Laulaka sunguwavu mihik or sindu? Uhu Masikome Avui Wasilakahin mi mbafirimbandu? Uhu ya os misambi mihi orok mi lahanda oso kas mi laha mi wanyindu? ");
INSERT INTO sim_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ya os mi lawa oso mihi sira. Uwa oso mbele mbele mihin mi frungawukwa ya sira. Hako mberem ushiwak wavu kava oso mihik si nandu? Wa mir mbeek man haimba handambawa ambu mir, wahau. Oso Avui Wasilakan mimu haimba handambawa sira,� Karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias mashi oson or misihi lewas or takatukuyihi normu hara. Urik ma ol mashi oson misiri ma amber limu aje mendera. ");
INSERT INTO sim_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Urik hulayi ermbasi lal li raha maninimba orhin waskowarmbak li hevehe kolaka hikriyok li lai limu wakor owera. ");
INSERT INTO sim_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ushinaha Ananaias nokove orhi mu tara. Sir mbeek hula sihi hari mashin misiri ambu sir. ");
INSERT INTO sim_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Urik Pita mu sirin silira, �Nyir sawenak a misi. Ya amber hom kalir, os misambi shihi shi mbashirik li frungawurin?� Karem mbarik simu mbara, �Ome sira, amber hom olira.� ");
INSERT INTO sim_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Urik Pita mu sirin mbara, �Mberem ushiwak shi anasaweshihi Masikome Wasilakahin shi haimba handambakmba undu? Wa, heye, ma ol hula nyihin lai wakor owewa ma kandai ra akayangak sindu. Avak nyirin er nga kisha lai wakor owekwa lir.� ");
INSERT INTO sim_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Urik lewas Pitahi kumbamuk si rakatukuyihi simu hara. Urik hulayi ermbasi ondo li rala heyeri nokove oso angop hari sir. Ushirik maninimba oson li kisha ihi hula sihi li wakor oweri mishi orok er nga limu wakor owera. ");
INSERT INTO sim_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Urik ma ol Jisasin hishindiyandari ondo nga ma ol mashi oson misiri ondo nga limu aje mendera. ");
INSERT INTO sim_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel ondo mbele mbele ma undahi ambu ondo nga mbele mbele apsham apshamhi ondo nga hulaima nokopma lihi nindik uri lira. Jisasin hishindiyandari ma ondo amber wavu namtaskop li hishihi tempel akak li layihi Solomon undari akanivik tirsa lindari lir. ");
INSERT INTO sim_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hako ma ol Jisasin hishindiyandari ambu ondo lir nga nakrem li tirsakurin ajendari lir. Hako aposel ondo nga Jisasin hishindiyandari ma ondon li heyehe, �Lir ma jivi lira,� karem limu hishira. ");
INSERT INTO sim_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hako Wasilakan hishindiyandari ma ondo musha mendek er nari lir. ");
INSERT INTO sim_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Urik ma ol kavamisindari ondon li kisha laharaha nombo laka sumbu yok kawun li lerehe ma ondon li oweshirik olmu wara. Li hishiri karem. Erem li ushinak Pita nombo laka orok or inak ta orin or jinak ta masikome orhi avak lihik si inak jivik li na, karem mbahan. ");
INSERT INTO sim_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma ol yanga Jerusalem nga pasir nandari yangak lindari ondo nga musha mendek tari lir. Ma ol kavamisindari nga ma ol wasimalengamba toloshirik ambasihi liyandari ma er nga limu kisha laharara. Urik aposel li mbarik ma ondo amber jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Urik hetpris nga kraha orhi ol Sadyusik fehenda ma ondo er nga mbele mbele ol aposel ondo uri ondon li heyehe li antlaha wavu lihi kavak er simu nara. ");
INSERT INTO sim_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Urik li usaha aposel ondon li toloho krawuk limu owera. ");
INSERT INTO sim_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Hako nirik ensel Wasilakahi krawu akayangan or sutlaha ormu lirin hikrik laharlara. ");
INSERT INTO sim_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Uhu ormu sawera, �Ji ihi tempel aka orok ji layihi Jisas os ermba ermbak linda oson jirin or hakunda mashin simbalesik hulaima nokopman ji sawerakoka.� ");
INSERT INTO sim_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Urik aposel ondo ensel saweri mashi oson li misihi nirsumbu indingak tempel akak li layihi mashi oson limu sawera. Urik hetpris nga kraha orhi ondo nga indik li talandirsaha li usharik lida ol li kamahandari ondo nga maifuk sindari Israelik fehe ma ondo nga amber limu talandirsara. Uhu ma lal li mbashirik limu ira, aposel ondon li laharakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma ondo krawu akak limu layira. Hako li layi heyeri aposel ondo mbeek orok liri ambu lir. Ushirik indiyok li ihi ma ol lirin mbashirik li tari ondon limu sawera, ");
INSERT INTO sim_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","�Ni ihi ni heyewa, krawu akayanga angop li kosorakoshiwak ni heyewa sir. Ushiwak ma ol akayanga ondon washilinda ma olmu orok er washiliwa. Uwak ni sutla ni heyewa mbeek ma namtar mende orok liwa ambu ri.� ");
INSERT INTO sim_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Karem li mbarik maifuk sihi tempel akan washilindari ma nga bikpris nga mashi oson li misihi, �Mberem mberem nakundas mbe?� karem mbaha wavu mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Urik ma lar or taha ormu lirin sawera, �Misi. Ma ol krawuk ji oweri ondo ter tempel akak li sihi olmu mashin sawenduwa.� ");
INSERT INTO sim_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Karem or mbarik maifuk sihi tempel akan washilindari ma nga ma ol lidanjik lerawun landari ondo nga li ihi aposelin limu laharara. Hako lir mbeek aposel ondon kavak nari ambu lir, wahau. Mberem ushirik? Las avak hulaima nokopma sunjakomben li loho lirin li jinda ngashi, karem li hishihi ajeri ola. ");
INSERT INTO sim_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Judama lida lihinjik lerawun landari ma ondo aposel ondon li tolo laharaha misokome lida ondohik li halashirik limu sira. Urik hetpris oto mashi las or sawehe ormu mbara, ");
INSERT INTO sim_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","�Ma oto hi orhik ji sawewa hala, karem angop ni pantleri jir. Hako jir mashi nihi oso jimu mblarnanduwa. Ushihi mashi oso ji sawewak Jerusalemik linda ma amber angop li misirakowa sir. Uhu jir, ma oto musa nihik ni mandingormeri, karem mbanda jir.� ");
INSERT INTO sim_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Karem or mbarik Pita nga aposel ondo nga limu sawera, �Nir Avui Wasilaka nom ni tiyakwa nir. Hako nir mbeek man ni tiyakwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jir Jisas oto angop miandok ji owehe ji mandingormeshirik hari ri. Hako neloko nihi ondo Avui Wasilaka lihi oto angop or mbarik indiyok usahari ri. ");
INSERT INTO sim_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uhu angop or lalawushihindak ormu tapmama orhiyok linduwa. Uhu malakamak or naha nirin jivinakwa mak ormu nanduwa. Uhu nir Israelik fehendan or jelyashinak sunguwavun ni tormblenak kavakava nihi avak or yoko ermbekmbahan. ");
INSERT INTO sim_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Karem or urin ni heyehe nir nga Masikome Avui Wasilakahi nga nimu sawenduwa, Masikome oto Avui Wasilaka ma ol orin hishiowehe tiyawa ma ondon or hari ria.� ");
INSERT INTO sim_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Urik lida ondo mashi Pitahin li misihi wavu lihi indik er lelenari sira. Uhu aposel ondon li mandingormekmbaha limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hako lida lar orok siri ri. Hi orhi Gamaliel oria. Or Farisi, mashi Moseshin sawendari ma ri. Ma amber hi orhin hauowendari lir. Judama lida lihi li tirsandari mishik or sihi ma ondon ormu sawe mbara, �Aposel tondon ji lalainak hikrik kandakar nga nambek li sinak,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Am hikrik li layishirik Gamaliel mu lida ondon ormu sawera, �Jir ma tondon mbele las ji uku nahi, wa yawur ji hishishihi jivai uka. Ji misi. ");
INSERT INTO sim_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mas wolo Teudas or usaha ormu mbara, �An malakama nir.� Karem or mbarik ma ol orin tiyandari ma ondo 400-ik nari lira. Hako gavman orin li jimandingormeshirik ormu hara. Urik ma ol orin tiyandari ma ondo simbalesik er li hala tulu ishirik lerawu lihi os li landari oso mendek simu nara. ");
INSERT INTO sim_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teudas oto am or hashirik kandakar nga nambek naha, os gavman hulaima nokopma hi lihin li kayekuri wolok si narik Judas Galilik fehendari nga nor usasihi or mbarik hulaima nokopma orin limu tiyara. Uhu gavman nga awun li ukmba limu ura. Hako gavman orin li mandingormeri ri. Urik ma ol orin tiyandari ma ondo amber simbalesik er li tuluhu apshamba apshambak limu ira. ");
INSERT INTO sim_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Unda osik jirin amu sawenduwa. Jir avak mbele las ma tondon ji uwa hala, wahau. Ji halashinak li ika. Lerawu os li lawa oso, men wavu lihik li hishihi li landa nahi, avak mendek nakwa sir. ");
INSERT INTO sim_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Hako os Avui Wasilaka sunguwavu lihik or mbashinak li landa nahi, mbeek ji pantlendahi ambu sir. Os erem ji u nahi, Avui Wasilaka nga jimu anajikwa sira.� Karem or mbarik lida ondo Gamalielhi mashin limu misira. ");
INSERT INTO sim_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Uhu aposel ondon li usharik li tarik limu sawera, �Avak mashi Jisashin ji sawewa hala,� karem limu aposel ondon pantlera. Uhu lirin li warmblashihi li halashirik limu ira. ");
INSERT INTO sim_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel ondo Judama lida lihi li tirsanda mishin li halaha hikrik limu layira. Mashi Jisashin li sawendari osik os erem lirin li warmblashiri oso �Avui Wasilaka or mbashiwak nomorawu oson ni kishawa sir,� karem mbaha limu rupshira. ");
INSERT INTO sim_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Uhu ermba ermbak tempel aka nga mahi aka nga li ihi mashi jivi Avui Wasilakahin sawendari lir. Mashi os li saweri karem, �Jisas oto Avui Wasilaka angop mas or mbahandari hom or mbashirik hulaima nokopman jivinakmbaha tari ma ria,� karem limu sawera. ");
INSERT INTO sim_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Oso wolo Jisashi mashin misindiyandari ma ondo musha mendek nari lir. Hako Judama ol Grikhi mashin mbandari ondo Aramhi mashin mbandari Judama ondon olmu ngriara. Li ngriaha olmu mbara, �Jir erndakava ondonjik akwan humasinda jir. Hako jir mbeek nokove nihi ol mumblak wahayanda ondon yawur ji heyehe akwa mbele mbelen nakremba nakrembak humasinda ambu jir.� ");
INSERT INTO sim_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Karem li mbarik 12-pela aposel ondo li misihi lir nga Jisasin hishindiyandari ma ondon amber limu ushara. Li usharik li talandirsarik limu sawera, �Os mashi Avui Wasilakahin ni sawendan ni halashihi lerawu os akwa mbele mbelen ni humasindan ni la nahi, mbeek jivik nakwa ambu sir. ");
INSERT INTO sim_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Uwa osik mahasanje, misi. Jir avak ma 7-pela jihi nindik ji kamaka, hulaima nokopmahi misokomek li heyewak jivik li naha Masikome Avui Wasilakahi nga li naha hishiyarinda nga nanda ma ondon. Ushinak avak akwa mbele mbelen humasinda lerawu oson li laka. ");
INSERT INTO sim_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hako nir avak ermba ermbak Avui Wasilakan ni sawehe mashi orhi nom ni sishi sawehe hulaima nokopman ni jelyakwa nira.� ");
INSERT INTO sim_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Urik ma amber aposelhi mashi oson li misihi limu rupshira. Uhu Stivenin limu kamara. Stiven oto or kwambuk Jisashi mashin misindiyandari ma ria. Masikome Avui Wasilakahi nga nandari ria. Uhu Filip, Prokorus, Nikanor, Timon, Parmenas, Nikolas karem ondo nga limu kamara. Nikolas oto yanga Antiokik fehenda ma ria, or Judama ambu ri, hako or lir nga nakrem Avui Wasilakan tiyandari ma ria. ");
INSERT INTO sim_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma ol li kamari ondon li mbashirik lasikop os aposel siri mishi orok limu sira. Urik aposel ondo ma ondohi masijik tavan li hauowehe lirnjik Avui Wasilakan limu sawera, ushinak lerawu oson li lakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Urik hulaima nokopma mashi Avui Wasilakahin li laha yanga yanga amber limu haisau handasawe ira. Urik Jerusalemik lindari ma musha mendek mashi oson li misihi Jisasin wavu lihik limu owera. Pris musha mendek er nga Jisasin wavu lihik limu owera. ");
INSERT INTO sim_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Avui Wasilaka Stivenin or waprupshihi kwambu orhik orin ormu jelyara. Uri osik Stiven mbele mbele apsham apshamhi nga ma undahi ambu nga hulaima nokopma lihi nindik ormu ura. ");
INSERT INTO sim_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Hako ma lal li usaha Stiven nga limu mainkwambu mbara. Ma ondo aka lasik talandirsaha hi Avui Wasilakahin hauowendari Judama lira. Lir neloko walanga lihi mas akishmakishak nandari lir. Hako os erem li nandarin li halaha jip lindari lira. Ma ondo kuyanga Sairinik fehenda nga yanga Aleksandriak fehenda nga yanga Silisiak tari nga Esiak tari nga lira. ");
INSERT INTO sim_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Hako Masikome Avui Wasilakahi Stivenin or jelyaha wapjip hishiyarindarin orin or harik mashin or saweri osik ma ondo mbeek mashi orhin li mblarnakurik nari ambu lir, wahau. ");
INSERT INTO sim_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Uri osik ma ondo ma lal li mbashirik li taha limu haimba handambara, �Ni misiwa Stiven oto mashi kavan Moses nga Avui Wasilaka nga nor mbawak ni misinda ri.� ");
INSERT INTO sim_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Karem li mbarik mashi oso li misihi hulaima nokopma nga Judama lida lihi nga mashi Moseshin sawendari ma nga wavu lihi osmu kavak nara. Uri osik Stivenin li i tolo Judama lida lihi ondo li tirsandari mishik limu laha ira. ");
INSERT INTO sim_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Uhu ma lal Stivenin li haimba handambakmbaha li mbashirik orok li sihi limu mbara, �Ermba ermbak ma toto tempel aka toso nga mashi Avui Wasilakahi nga mashi kavakavan owehe mbanda toria. ");
INSERT INTO sim_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ni misiwa karem mbanda ri. �Jisas Nasaretik fehenda oto avak tempel aka toson or jila tarvlalaha anandin ukwa ri. Uhu mbele mbele ol Moses ni ukmbaha or mbahandari ondon avak or halaha nombo anandin ewekwa ri,� karem mbanda ria.� ");
INSERT INTO sim_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Urik ma amber ol orok tirsa liri ondo olmu Stivenin washiolora. Li washiolori fumunyava orhi enselhi fumunyava hom ormu nara. ");
INSERT INTO sim_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Urik hetpris Stivenin ormu silira, �Mashi kas ma tondo mirin li mbawa omendinga os mo wahau?� ");
INSERT INTO sim_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Urik Stiven mu mbara, �Mahasanje, avoko anhi jirin. Ji misi. Os neloko nihi Abraham yanga Haranik or i namber, os yanga Mesopotemiak or liri wolo, Avui Wasilaka hevenik fehe kwambu wasilaka ngashi ormu Abrahamik talara. ");
INSERT INTO sim_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uhu ormu orin sawera, �Mir yanga mihi nga mahasanje mihi nga halashihi misambi os mirin a lai halashinak mi likwa mishi orok ika.� ");
INSERT INTO sim_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Karem or mbashirik Abraham yanga Mesopotemia os Kaldia ma ondo li lindari mishin or halaha ormu yanga Haranik ira. Orok er or lihi avoko orhi hashirik Avui Wasilaka or mbashirik misambi tos ji liwa torok ta liri ria. ");
INSERT INTO sim_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Oro wolok Avui Wasilaka misambi toso mbeek orin or hari ambu sir, wahau. Hako or mbari karem, misambi toso avak orhik si nashindanak kumak jinirmbanira orhi lihik nakwa sira, karem mbari ria. Hako os mashi oson erem or mbari wolo, Abraham mbeek jikisi nga nor nari wolo ambu sir. ");
INSERT INTO sim_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Avui Wasilaka Abrahamin ormu sawera, �Jinirmbanira mihi avak mahi kuyanga lasik li ihi akishmakishak nakwa lira. Unak ma orok fehenda ondo avak asama 400-ik lirin kavakavak li ukwa lira. ");
INSERT INTO sim_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hako ma ol lirin kavakavak uwa ondo avak kavak a nakwa lir. Ushinak kumak jikisi lihi ondo avak misambi oson li halaha indik kuyanga torok li raha anin lotu ukwa lir.� ");
INSERT INTO sim_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Uhu Avui Wasilaka Abrahamin ormu sawera, �Mir avak masamsishi mihin koro. Oso suman mir nga na tivikwan heimakwa sira.� Urik Abraham mashi orhin or misindiyaha os or mbari hom ormu ura. Erem or ushirik Abraham nokove orhi Aisakin simu wara. Niri 7-pela am li ishirik Aisakhi masamsishin ormu korora. Ushirik Aisak nokove orhi Jekopin simu wara. Ushirik Jekop oto nokove orhi ondo neloko nihi 12-pela ondon limu wara. Lar Josep oria. ");
INSERT INTO sim_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Urik Josep sanje orhi ondo orin li heyehe olmu wapkava hishira. Uhu ma anandihi tavak Josepin li haha yan limu lara. Ushirik Josepin li laha yanga Ijipik limu ira. Hako Avui Wasilaka or nga nor sihi nomorawu orhik talarin kopshan or mbashirik ormu sira. ");
INSERT INTO sim_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Uhu orin or jelyaha armesarmek orin or ushirik hishiyari orhi wasilakak si nashirik, king Ijipik fehe or heyehe or rupshihi orin or mbashirik malakamak ormu nara. Malakamak or naha hulaima nokopman or arangoho kinghi aka nga ormu washilira. ");
INSERT INTO sim_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hako oro wolok yanga Ijip nga yanga Kenan nga akwa mendek si nashirik wasilaka mendek limu erenghara. Urik neloko nihi nga akwa mendek si narik olmu erenghara. ");
INSERT INTO sim_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hako Jekop or misiri yanga Ijip akwa nga nari sir. Uri osik jikisi orhi ondon or mbashirik yanga Ijipik li ihi akwan li frungawu laha indiyok limu tara. ");
INSERT INTO sim_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ushihi indiyok limu ira. Urik Josep lirin ormu sawe mbara, �An Josep anira,� karem or mbaha king Ijipik fehe oton er nga mashi oson ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ushihi Josep or mainharik Jekop jikisi jinirmbanira orhi 75 ondon or laha Josepin li heyekurik Ijipik limu ira. ");
INSERT INTO sim_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ijipik li i lihi Jekop orok ormu hara. Urik ol nakrem li iri ondo er nga limu hara. ");
INSERT INTO sim_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ushirik maninimba lihi ondon li laha indiyok yanga Kenan orok limu ira. Uhu yanga las Kenan orok nandari Sekem orok li laihi sunja aka orok limu wakor owera. Sunja aka oso Abraham angop maskop yan or laha Hamorhi jikisi ondohin or frungawuhundari sira. ");
INSERT INTO sim_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Avui Wasilaka os or ukmbaha mas Abrahamin or sawehendari oso am si talakuri wolok osmu nara. Oso wolo nirambara Jekophi ol Ijipik liri ondo musha mendek nari lira. ");
INSERT INTO sim_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Josep hashirik kandakar nga nambek li lihi Ijipik fehe ma lar kingik ormu nara. Or mbeek lerawu jivi os Josep orok or lahandarin heyendari ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King oto Judama ondon kavak or nakmbaha lirin ormu mbara, �Jikisakri ol akri li wawa ondon ji laha hikrik ji ormbeshinak li haka,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Oro wolok Moses nijava orhi orin simu wara. Si wari Avui Wasilakahi misokomek jivi mendek or nashirik niyaka nalmingrip fri wanyishirik akakop ormu wara. ");
INSERT INTO sim_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hako king mbari mashi oso kwambu mendek si nashirik fri misihi akakop fri oweshirik or wahandarin fri halaha orin fri laharla hikrik fri oweshirik ormu wara. Ushirik king jikisnokopji orhi osmu i laha jikisi sihi hom simu simbi lahayara. ");
INSERT INTO sim_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses am or saha mbele mbele hishiyarinda jivi Ijipik nandari ondon ormu heitakora. Erem or naha mashi os or mbari kwambu nga si narik lerawu kwambun ormu lara. ");
INSERT INTO sim_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses asama orhi am 40-k or naha orhi ma ol akishmakishak naha Ijipik fehe ondonjik lerawun men landari ondon or heyekurik ormu hishira. ");
INSERT INTO sim_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Or ihi nor heyeri Ijipik fehe ma lar ormu Israelik fehe ma larin kavakavak ura. Urik Moses mu Israelik fehe ma otonjik or sihi Ijipik fehe oton ormu mandingormera. ");
INSERT INTO sim_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses or hishiri karem, or avak Avui Wasilaka mbashinak Israelik fehe ondon or laha li ikwa ri, karem hishiri ora. Hako lir mbeek erem hishiri ambu lir. ");
INSERT INTO sim_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wahandaha nor i heyerik Israelik fehe ma ambe lap opmu anajira. Urik fririn or arangokmba uhu ormu mbara, �Shir Israelik fehenda ambe osh te. Mberem ushiwak shihi ambek shi anajikwak shi undua?� ");
INSERT INTO sim_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Karem or mbarik ma or ma anandin havahavan jiri ma oto Mosesin or tololafaa normu mbara, �Mayam si. Lawe mirin malakamak mbashiwak nirin mi heyembakwak mi undu? ");
INSERT INTO sim_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mir anin mi mandingormekwak mimu hishindu, os hinyer Ijipik fehe ma oton mi mandingormeri hom?� ");
INSERT INTO sim_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses mashi oson or misihi or ajehe ormu tulu ira. Or tulu ihi yanga Midianik or ihi orok ormu nokop laha lira. Uhu jikishulayi orhi frijip nari vri. ");
INSERT INTO sim_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Asama 40 am si irik ensel lar mu Moseshik talara, misamtelmbamba os pasir telemba Sainai nandari mishi orok ensel oto mi kanda las hi ukruri nindik ormu talasira. ");
INSERT INTO sim_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses or heyeri hi oso mbeek mi oson uri ambu sir. Uri osik wavu musha mushak ormu hishira. Uhu armek or heyekurik pasir ormu i sira. Urik Wasilaka mu orin sawera, ");
INSERT INTO sim_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","�An God neloko mihi lotu undari anira. An God Abraham nga Aisak nga Jekop nga God lihi anira.� Urik Moses or lishnyafaha kwarnguarnaha or heyekurin ormu ajera. ");
INSERT INTO sim_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Urik Wasilaka mu orin sawera, �Misambi os mi siwa oso anhi jivi mende sir. Uwa osik mir avak kumba ari mihin tloloka. ");
INSERT INTO sim_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","An os Ijipik fehe ma anhi ma ondon li uwak kavak li nawan angop a heyenda sir. An os li tlawan angop a misiwa sir. Uwa osik ter anhi ma ondon a jivinakwak amu rakanduwa. Uwa osik mir usanak a mbashinak Ijipik ika,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mas wolok Israelik fehenda ma ondo Mosesin li turaha karem mbari lir, �Lawe mirin malakamak mbashiwak nirin mi heyembakwak mi undu?� karem mbari lir. Hako Moses oto Avui Wasilaka mbashirik or ihi lida lihik or naha lirin jelyakurik nari ri, os or sihi nor misirik mi kanda las hi ukruri nindik Avui Wasilaka sauharik ensel or saweri hom. ");
INSERT INTO sim_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses oto nom maifuk or sihi Israelik fehe ondon or laha yanga Ijipin limu halara. Uhu mbele mbele ma undahi ambu nga apsham apshamhi ondon yanga Ijip orok or uhu Fa Nalo orok or uhu misamtelmbamba orok os asama 40-k li liri wolo er nga ormu ura. ");
INSERT INTO sim_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Uhu Moses oto Israelik fehenda ma ondon ormu sawera, �Avui Wasilaka avak ma lar jihi nindik or kamashinak profetik nakwa ria, tos an nawa hom.� ");
INSERT INTO sim_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Undarik misamtelmbamba orok Moses nga neloko nihi ondo nga orok li tirsaha lirik ensel lar telemba Sainaik mashi Avui Wasilakahi ermba ermbak lindan ormu Mosesin sawera. Urik or nga mu nirin sawera. ");
INSERT INTO sim_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Hako mashi os Avui Wasilaka Mosesin or sawerik or nga neloko nihi ondon or saweri mashi oso lir mbeek misindiyari ambu lir. Lir mashi orhin li mblarna ormbehe wavu lihi indiyok Ijipik li ikurik hishiri lir. ");
INSERT INTO sim_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Uhu Aronin limu silira, �Moses kar nirin Ijipik lahararik ni tahanda oto or mbele menden or landua. Nir ni nikishi nikishihi am ni krehew te. Uwa osik mir nirnjik god lal mi ushinak li maifu inak indiyok Ijipik ni ika.� ");
INSERT INTO sim_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Karem li mbaha mbele las bulmakau jikisi hom limu heimaha ura. Uhu haimba handambanda god lihi osonjik limu nambura. Uhu er limu rupkapshira, os tava lihik li toloho li uri god oson. ");
INSERT INTO sim_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Uri osik Avui Wasilaka lirin or kumaifa nor halashirik ta niyaka tashingraha ondo yejen limu lotu ura. Mashi oso jekamba profethik karem li kayehendari osa. �Jir Israelik fehe ma jirin, ji misi. Asama 40-k os misamtelmbamba orok ji liri wolo anin ji nambukuri lal am laharari oj? Wahau. ");
INSERT INTO sim_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sel aka os ji kishari oso aka anhi ambu sir. Oso haimba handambanda god Molekhi nga tashingraha Refanhi nga frihi aka sira. Ovron ji lotu ukmbaha tava jihik ji uri vri. Erem ji uri osik avak a mbashinak yanga home mende Babilonik li laha ikwa jir.� Mashi Avui Wasilakahi karem mbahandari osa. ");
INSERT INTO sim_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Neloko nihi os misamtelmbamba orok li liri wolo, lir Avui Wasilakahi sel aka nga nandari lira. Aka orok sunja frijip Avui Wasilakahi mashi nga nandari ovron li oweshirik wandari vri. Sel aka oso li uri Avui Wasilaka Mosesin or saumukushirik or heyeri hom, os or mbari nombo hom limu ura. ");
INSERT INTO sim_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ushindarik nirambara lihi sel aka oson li kishaha Josua nga nakrem li sihi awun li uhu ihi misambi os Judama ambu ondo liri mishin li hiniyin hongokurik olmu ira. Urik Avui Wasilaka mu Judama ambu ondon kria ormbera. Ma ondon or kria ormbeshirik sel aka oso li kisha ihi li oweshirik orok simu sira. Er si si ihi Devit mu kingik nara. ");
INSERT INTO sim_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit oto Avui Wasilaka rupshi mendendari ria. Undarik Devit Avui Wasilaka or Jekop lotu undari oton or sawehe normu silira, �Am mi mbashinak aka jivi las mirnjik a ukundan? Ushinak ma li ihi mirin orok li lotu ukwan.� ");
INSERT INTO sim_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hako Avui Wasilaka mbeek or mbashirik Devit akan uri ambu ri, wahau. Solomon mu aka oson ura. ");
INSERT INTO sim_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Hako Avui Wasilaka kwambu ngashi or mbeek ma tavak li tolo uhunda aka orok linda ambu ri. Oso mas profet karem or mbahandari sir, ");
INSERT INTO sim_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","�Wasilaka karem mbari ri. Antonom heven nga misambi nga a tolonda nira. Mberem nanda akan anjik ji ushinak avai limasikundas? Wahau. ");
INSERT INTO sim_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","An anhinjik mbele mbele amber hevenik fehe nga misambik fehe nga antonom a urakonda lira.� Profet karem mbahandari ri. ");
INSERT INTO sim_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Hako, jir mamblasamblan jinda jir. Sunguwavu jihi sunjakombe hom nanda jir. Jir Judama ambu ondo hom ji naha mbeek mashi Avui Wasilakahin misinda ambu jir. Uhu ermba ermbak Masikome orhin mblarnanda jir, os mas misumu walanga jihi undari hom. ");
INSERT INTO sim_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Misumu walanga jihi ondo profet ol Krais ma worna ma Avui Wasilakahi or takuri mashin sawendari ondon amber hom li mandingormendari lira. Uhunda osik jir erema. Ma worna ma Krais oton ji toloho wutari ondo lihi tavarenjek ji harik li jimandingormeshirik hari ria. ");
INSERT INTO sim_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jir mashi Avui Wasilakahi os ensel li sawerin angop ji misiri sir. Hako mbeek ji tiyari ambu sir,� Stiven karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Judama lida lihi ondo mashi os Stiven saweri oson li misihi er li waplelenaha fu nga limu tantlemantlembura. ");
INSERT INTO sim_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hako Masikome Avui Wasilakahi Stivenin kwambun hari ria. Urik heven yok or larasamawuhu ukruharanda Avui Wasilakahin or heyehe Jisas Avui Wasilakahi tapmama yok sirin ormu heyera. ");
INSERT INTO sim_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Uhu Stiven mu mbara, �Ji misi. An hevenin a heyewa angop sutlawa sir. Uwak Ma Jikisi Avui Wasilakahi ormu tapmama Avuihi yok sinduwa.� ");
INSERT INTO sim_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mashi oson li misihi li waplelena mendehe wasilakak limu ushandashira. Uhu or mbari mashi oson li misikurin li turaha mambla lihin limu arangora. Li usaha shirinyambar li ihi Stivenin limu toltambanara. ");
INSERT INTO sim_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Orin li toloho yanga hikriyok limu tololongo lalayira. Uhu sunjakomben li loho orin li jimandingormekmbaha limu ormbera. Ma ol Judama lida lihi li tirsandari mishik orin haimba handambari ma ondo kousamba lihin li tloloho lai jikanda ermbasi lar siri mishik limu owera. Hi orhi Sol oria. ");
INSERT INTO sim_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Erem li ushihi sunjakomben li loho Stivenin limu jira. Urik ormu beten ura, �Jisas Wasilaka mirin te. Masikome anhi tava mihik amu halanduwa.� ");
INSERT INTO sim_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Uhu kumbambongon or huvuhu wasilakak ormu mbara, �Wasilaka, mir avak kavakava os anin li uwan lirin wasan uwa hala.� Karem or mbaha normu hara. ");
INSERT INTO sim_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Sol Stivenin li mandingormekurin rupshiri ri. Stiven or hashirik Judama ol Avui Wasilakahi mashin yawur tiyandari ondo ornjik li owetlaha orin limu wakor owera. Os Stivenin li mandingormeri wolo, Jisasin hishindiyandari ma ol Jerusalemik lindari ondo er nga kavak li nakurik limu ura. Sol oto aka akak or layihi Jisasin hishindiyandari ma ondon or jihi or tolo longo laihi krawuk or oweshirik limu lira. Hako lal os erem or urin li heyehe li tulu ihi lal provins Judiak li irik lal provins Samariak limu ira. Hako aposel ondo nom Jerusalemik er liri lira. ");
INSERT INTO sim_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hako ma ol Jerusalemin halaha tulu iri ondo yanga yangak li ihi mashi Jisashin saweyari lira. ");
INSERT INTO sim_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Lar lihi Filip oria. Filip oto provins Samariak or ihi orok fehendari ma ondon mashin ormu sawera, �Jisas oto jirin jivinakmbaha Avui Wasilaka kamahanda ma ria.� ");
INSERT INTO sim_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Karem or sawehe mbele mbele ma undahi ambun or urik li heyehe ma musha mendek mashi orhin arme mendek limu misira. ");
INSERT INTO sim_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip wasimalengamba ol man tolondari ondon or mbarik li jisuwuhu ma ondon li halaha tulu iri lir. Uhu ma ol kumba nashi tava nashindari ondon or mbarik er nga jivik nari lir. ");
INSERT INTO sim_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ushirik ma orok fehendari warje mende nga limu rupshira. ");
INSERT INTO sim_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Hako ma lar yanga orok lindari ri. Hi orhi Saimon oria. Or entlembantlen sindari ma ria. Mbele mbele apsham apshamhi indingan or uhu, �An kwambu nga na nanda nira.� Karem or mbaha orhinjik yerkujindari ri. ");
INSERT INTO sim_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Samariak fehe ma amber malakama nga hi ngashi ambu ma ondo nga jikisi nga asama mushak mbele mbele ol or uri ondon li heyehe wavu musha mushak hishindari lira. Uhu karem mbandari lir, �Kwambu Avui Wasilakahi indinga osmu orhik nanduwa,� karem mbandari lira. ");
INSERT INTO sim_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Hako Filip os Avui Wasilaka arangoshinak jip li likuri mashi nga Jisas Krais or taha kavakava lihin or yoko ermbekmbaha nor hahandari mashi nga nor sawerik orok fehe ma li misindiyaha fak limu layira. ");
INSERT INTO sim_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon or er nga mashi Jisashin or misindiyaha fak ormu layira. Uhu Filip iri hom, or er nga nor tiya ihi mbele mbele apsham apshamhi nga ma undahi ambu ondo nga Filip urik or heyehe wavu mushak ormu hishira. ");
INSERT INTO sim_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel ol Jerusalemik liri ondo li misiri Samariak fehenda ma ondo angop mashi Avui Wasilakahin misindiyari lir. Uhu Pita fre Jonin li mbashirik yanga orok frimu ira. ");
INSERT INTO sim_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samariak fehe ma ondo Wasilaka Jisasin wavu lihik li hishiowehe fak limu layira. Hako mbeek Masikome Avui Wasilakahi lihik or taka namber. Uri osik Pita nga Jon nga opmu Avui Wasilakan sawera, unak or mbanak Masikome orhi lihik or takakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Avui Wasilakan fri saweshihi tavan masiji lihik fri hauoweshirik Masikome Avui Wasilakahi lihik ormu takara. ");
INSERT INTO sim_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon or sihi nor heyerik aposel ovro tava frihin fri hauowerik Masikome Avui Wasilakahi ma ondohik ormu takara. Urik yan or laha fririn or haha normu mbara, ");
INSERT INTO sim_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","�Shir kwambu oson anin shi hawa. Unak avak man erem a unak Masikome Avui Wasilakahi lihik or takaka.� ");
INSERT INTO sim_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hako Pita Saimonin ormu sawera, �Ya mihi toso nga mir nga avak kavak er nakwa shir. Mberem ushiwak? Mir karem mi hishiwa osa. Mbele mbele jivi os Avui Wasilaka men or handa oso yak mi frungawundahi sir, karem hishiwa oma. Hako wahau. ");
INSERT INTO sim_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sunguwavu mihi Avui Wasilaka or heyewa mbeek jivik nawa ambu sir. Uwa osik mir mbeek lerawu tos shi lawan mi landahi ambu sir, wahau. ");
INSERT INTO sim_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mir avak wavu mihin tormblehe kava kava mi unda oson kumasika. Uhu Avui Wasilakan silinak kavakava ol sunguwavu mihik nawan or yoko ermbeka. ");
INSERT INTO sim_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mirin a heyewa mbele mbele kava ol sunguwavu mihik hojehe mirin toltangrishiwak a heyendu.� ");
INSERT INTO sim_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Urik Saimon mu fririn sawera, �Shir avak anjik Avui Wasilakan shi sawenak mbele mbele oso avak anhik si talakwa si halaka,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposel ovro mashi os Wasilaka fririn or mukurik fri heyeri nga or sawerik fri misiri mashi nga orok fehendari man frimu sawembara. Uhu indiyok Jerusalemik ikurik frimu ira. Fri ihi Avui Wasilakahi mashin yanga yanga os provins Samariak nandari orok fri saweihi Jerusalemik frimu ira. ");
INSERT INTO sim_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ensel Wasilakahi lar Filipin ormu sawera, �Mir usaha Jerusalemik ika. Uhu Jerusalemin mi halaha nombo os yanga Gasak li inda nombo yok ika,� karem ormu mbara. (Nombo oso ma ngashi mishi ambu nindik inda sir.) ");
INSERT INTO sim_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Urik Filip or usaha ormu ira. Nombo orok or ihi yanga Itiopiak fehe ma lar or tarik ormu heyera. Ma oto hi nga nor naha hiushanokove Itiopiak fehendanjik ya sihi ondon washilindari ma ria. Avui Wasilakan or lotu ukmbaha Jerusalemik tari ria. ");
INSERT INTO sim_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ushihi indik yangak or ikmbaha karis, karem li ushanda orok or lawu lihi jekamba profet Aisaia kayehendari oson or ritim uhu ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Urik Masikome Avui Wasilakahi Filipin ormu sawera, �Mi ihi karis orok i pasir sika.� ");
INSERT INTO sim_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Karem or mbarik Filip shirinyambar or ihi karis iri mishik ormu i sira. Pasir or i sihi nor misirik Itiopiak fehenda ma oto profet Aisaia kayehendari mashin ormu ritim ura. Urik Filip mu silira, �Mir mashi os mi ritim uwa oso mainome sihi am mimu hishiyarindu?� ");
INSERT INTO sim_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Karem or mbarik ma oto mu mbara, �Wahau te, os ma lar mashi kaso mainome sihin or sawenak a misi nahi ambu, wa mberem a hishiyariku?� Karem mbaha Filipin or mbarik or lawuhu karisik nakrem frimu lira. ");
INSERT INTO sim_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mashi os jekamba orok narik or ritim uri karem, �Ma orto li jimandingormekurik li lairi ri. Hako or mbeek mashi las mbari ambu ri. Os sipsipin li jimandingormekwak li laiwak mayam li sinda hom siri ri. Uhu os sipsip jikisi kukwa lihin li korokwak li lai oweshiwak mayam li sinda hom ma oto or mbeek mashi las mbari ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mashi kavakavan li mbaha orin limu esnerkora. Or mbeek mashi omendingak li mbaha kotik li oweri ambu ri. Mashin li haimba handambaha orin limu kotik owera. Or jinirmbanira nga nor na namber li jimandingormeshirik hari ri. Unda osik hulaima nokopma mbeek nirambara orhi lal heyekwa ambu lir.� ");
INSERT INTO sim_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itiopiak fehe ma oto mashi oson or ritim uhu Filipin ormu silira, �Mirin amu silinduwa. Profet lawen or mbaha mashi kason or kayer? Orhinjik or mbari os mo, ma anandi lar or mbari os?� ");
INSERT INTO sim_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Karem or mbarik Filip Aisaia kayehendari mashi os or heyeri oso mainome sihin or saweshihi, hovok Jisashi mashi nga nor sawerik ormu misira. ");
INSERT INTO sim_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Uhu nombok fri ihi fa las fri heyehe Itiopiak fehe ma oto mu mbara, �Heye, fa las kasai karok nandu. Anin fak tolofaleka.� ");
INSERT INTO sim_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Karem or mbaha nor mbarik karis er simu sira. Urik Filip nga ma oto nga frimu fak layira. Uhu Filip orin ormu fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Uhu fan fri halaha frimu rasara. Urik Masikome Avui Wasilakahi Filipin or laha ishirik ma oto mbeek orin heyeri ambu ri. Hako ma oto er or rupshihi nombo orhin or tiyaha yanga orhik or ikurik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hako Filip or heyeri angop yanga Asdotik siri ri. Uhu mashi Jisashin yanga orok ormu saweyara. Uhu yanga ol Sisariak ikuri nombok nandari orok ormu saweira. Uhu nor ihikop kuma yanga Sisariak ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Oro wolok Sol er or waplelenaha Wasilakan hishindiyandari ma ondon or toloho or mandingormekmbaha ormu ura. Uhu hetprisik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Or ihi hetpris oton or heyehe jekamba lal or kayeshikmbaha ormu silira. Or kayehe nor hanak or laihi maifuk sihi Judama lotu undari akan washilindari ma ol Damaskusik fehe ondon or hakmbahan. Urik hetpris jekambak karem ormu kayera, �Os Sol ma lal or heyenak nombo Jisashin li tiyanda nahi, wa ma ondon avak or toloho Jerusalemik or laharaha krawu akak or oweshinak likwa lira.� Karem or kayehe Solin ormu hara. ");
INSERT INTO sim_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Urik Sol Jerusalemin or halaha yanga Damaskusik or ikurik ormu ira. Am or ihi Damaskusik or layikuri ambek si narik kolok tumsar kasai lervlandari hom lersuwu yok simu taka orin arangora. ");
INSERT INTO sim_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Urik misambik or takatukuyi waha or misirik mashi las ma lar karem ormu mbara, �Sol, Sol. Mberem ushiwak anin mi kavak nakwak undua?� ");
INSERT INTO sim_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Urik Sol mu mbara, �Wasilaka, mir lawe mir?� Urik ormu mbara, �An Jisasin mimu kavak nanduwa. ");
INSERT INTO sim_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Hako mi usaha mi ihi yanga Damaskusik layika. Unak ma lar avak lerawu os mi lakwa lakwa oson or sawenak mivai misika,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hako Sol nga iri ma ondo er li lishnyafaha li ajehe mayam er limu sira, mbeek mashi las mbari ambu lir. Mberem ushirik? Mashi oson misiri lir. Hako lir mbeek ma omen heyeri ambu lir. ");
INSERT INTO sim_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Urik Sol mu usasira. Misokome orhi huriri sir. Hako mbeek mbele las or heyekurik nari ambu. Erem or narik ma ol or nga iri ma ondo tava orhin li toloho Damaskusik limu la layira. ");
INSERT INTO sim_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Li lalayi oweshirik niri nalmingrip orok liri ria. Hako misokome orhi mbeek jip or heyeri ambu. Uhu akwa nga uksembe nga mbeek ari ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yanga Damaskus orok Jisasin hishindiyandari ma lar lindari ria. Hi orhi Ananaias oria. Or lihi suku hom or heyeri Wasilaka hi orhin ormu ushara, �Ananaias.� Karem or mbarik ormu mbara, �Wasilaka, mberem uwa?� ");
INSERT INTO sim_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Karem or mbarik Wasilaka orin ormu sawera, �Mir usaha nombo os Nombo Worna, karem li ushanda orok mi ika. Nombo orok mi ihi Judashi akak mi layihi ma lar yanga Tarsusik fehe oton mi silheyeka. Hi orhi Sol oria. Or ormu orok beten unduwa. ");
INSERT INTO sim_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol oto or lihi suku hom or heyewak or linda akak mi layihi tava mihin masiji orhik mi hauoweshiwak kolok misokome orhi indiyok jivik si nawak heyewa ora.� ");
INSERT INTO sim_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Urik Ananaias mu sawera, �Wasilaka, an a misiwa ma musha mende ma orton li mbanda re. Jerusalem orok ma ol mirin hishindiyanda ondon kavak or nawak li mbawak a misinda re. ");
INSERT INTO sim_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Or angop bikpris ondo kwambu lihin orin li haha li mbashirik torok tari ria, mirin hishiowehe lotu unda man or toloho krawuk or owekmbahan.� ");
INSERT INTO sim_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Hako Wasilaka mu orin sawera, �Mir i. Ma oto angop a kamawa ri. Or ihi Judama ambu ondo nga king ondo nga hulaima nokopma Israelik fehe ondo nga mashi anhin or sawenak li misikmbahan. ");
INSERT INTO sim_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Lerawu anhin or laha nombo orok nomorawu kava orhik talakwa oson avak a mukunak heyekwa ri,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Urik Ananaias or usa or ihi aka orok or layi tava orhin or hau Solhi masijik owehe normu mbara, �Awasayi anhi, Sol. Wasilaka Jisas or nombok mihik talarik mi heyeri oto or mbashiwak mirin a heyekwak amu randuwa. Ushinak misokome mihi indiyok jip mi heyekmbahan. Unak Masikome Avui Wasilakahi avak mir nga nor sikmbahan.� ");
INSERT INTO sim_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias karem or mbarik os foom armbu hom misokome orhik nari ovro kolok fri jakoho frimu rakara. Urik indiyok ormu heyera. Uhu nor usarik orin ormu fak tolofalera. ");
INSERT INTO sim_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Urik akwa lal li harik or amasihi indiyok kwambu nga normu nara. Uhu niri lal Sol Damaskus orok Jisasin hishindiyandari ma ondo nga limu lira. ");
INSERT INTO sim_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Uhu kolok Judama lotu undari aka orok or ihi mashin ormu sawera, �Jisas orto jikisi Avui Wasilakahi ria.� ");
INSERT INTO sim_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Urik ma amber Solhi mashin li misihi limu lishnyafara. Uhu limu mbara, �Ma roto Jerusalem orok ma ol Jisasin hishiowehe lotu unda ma ondon kavak nandari ma toria. Uhu ter torok or taha ma ol Jisasin hishindiyanda ma ondon or toloho bikprisik or laha ihi krawuk or owekmba tawa ri, karem ni hishiwa re.� ");
INSERT INTO sim_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Hako mashi os Sol or saweri oso kwambuk er si naha krahak nari sir. Uhu karem ormu mbara, �Jekamba Avui Wasilakahik li kayehendari hom Jisas oto hulaima nokopman jivinakmbaha Avui Wasilaka angop or kamahanda ma ri.� Karem or mbarik Judama ol Damaskusik lindari ondo li misihi wavu musha mushak limu hishira. ");
INSERT INTO sim_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Niri lal am li ishirik Judama lal lasikop li tirsaha Solin li mandingormekurik limu anasawera. ");
INSERT INTO sim_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Uhu sunja inyi os yangan arangondari akayanga amber ondon niri nga tandi nga er limu arangorakora. Unak or tanak li mandingormekmbahan. Hako Sol mashi os orin li jikurik li mbari mashi oso angop misiri ri. ");
INSERT INTO sim_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Uri osik orin tiyandari ma ondo niri wolo lasik orin li laha inyi os sunjak li undari orok limu lalawura. Uhu serkawu laka kwambu jindari lasik li mbashirik or layi lirik kuvuk li tihi naman er li tolori hom yanga hikriyok ormu layira. ");
INSERT INTO sim_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Undarik Sol indiyok Jerusalemik ormu ira. Uhu ma ol Jisasin hishindiyandari ma ondo nga nakrem li tirsakmba ormu ura. Hako wahau. Lir os Jisasin or hishindiyari oson angop misiri lir, hako mbeek mashi oso ome, karem hishiri ambu lir. Uri osik limu ajera. ");
INSERT INTO sim_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hako Barnabas mu Solin aposel ondohik halakmbaha laha ira. Or laihi mashi os Sol Damaskusik inda nombo orok Wasilakan or heyeri oso nga mashi os Wasilaka orin or saweri oso nga lirin ormu sawera. Uhu yanga Damaskusik Sol mashi Wasilakahin kormbak or sawehe mbeek or ajeri ambu oso nga ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aposel ondo Sol os Jisasin or hishindiyari oson kormbak limu heyera. Uhu Sol or nga Jerusalemik nakrem li lihi limu yara. Uhu kwambu Jisashik mashin kormbak ormu sawera. Or mbeek man ajeri ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Uhu Judama ol mashi Grikhik maimbanda ma ondo nga limu anamainkwambu mbara. Hako lir nombo nombo os orin li jimandingormekurin lasari lir. ");
INSERT INTO sim_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hako Jisasin hishindiyandari ma ondo mashi oson li misihi Solin li laha Sisariak limu lai halashirik yanga Tarsusik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Oro wolok Jisasin hishindiyandari ma ol provins Judia nga Galili nga Samaria orok lindari ondo jipjip er lindari lira, mbeek nomorawu nga nari ambu lir. Uhu Avui Wasilaka lirin or jelyashirik orin hishindiyanda nombo lihi kwambuk er nari sir. Avui Wasilakan li ajehe orhi siyok limu sira. Li sirik Masikome Avui Wasilakahi lirin or jelyashirik Jisasin hishindiyandari ma musha mendek er nari lira. ");
INSERT INTO sim_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita Avui Wasilakahi ma ondon or heyekmbaha yanga yangak ormu ira. Uhu yanga las Lida, karem li ushandari mishik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kuyanga orok or ihi ma lar ormu heyera. Ma oto hi orhi Ainias oria. Ma oto maome orhi angop turmusaharakondari ria. Jeyengawukop or wandari asama tostava tava yok nalmingrip nari sira. ");
INSERT INTO sim_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita orin or heyehe ormu sawera, �Ainias, ter Jisas Krais unak jivik nakwa mir. Uwa osik mi usaha jeyengawu mihin armek oweka.� Karem or mbarik kolok lewas ormu usara. ");
INSERT INTO sim_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Urik ma ol yanga Lida orok fehe nga kuyanga Saronik fehe nga Ainias oto jivik or narik li heyehe wavu lihin li tormblehe Wasilakan limu tiyara. ");
INSERT INTO sim_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kuyanga Jopak Jisasin hishindiyandari nokove las lindari sir. Hi sihi Tabita sir. Grikhi mashik Dorkas, karem li ushandari sir. Sir mbele mbele lerawu jivin si laha erndakava ondon si haha jelyandari sir. ");
INSERT INTO sim_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nindi las wolok si kavamisihi simu hara. Urik maninimba sihin li uktoloho waskowarmbak li hevehe aka metenje heyeyok li lalawu oweshirik simu wara. ");
INSERT INTO sim_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Oro wolok Pita yanga Lidak liri ri. Yanga Lida oso yanga Jopa nga pasir nandari sir. Uri osik Jisasin tiyandari ma ol Jopak lindari ondo Pita yanga Lidak or ta lirin li misihi ma frijip li mbashirik frimu ira. Fri ihi orin frimu sawera, �Hai, kolomalok mi ra ni iwa. Nambek mi nawa halawa.� ");
INSERT INTO sim_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Urik Pita or usaha frir nga limu ira. Li ihi orin li laha aka os heyersiyer li undari aka heyeyok limu lawura. Or lawu nor heyeri nokove mumbla ondo orok li sihi limu tlara. Urik Pitan li heyehe os Tabita lir nga si liri wolok kowe mbele mbele ol si tlavaha lirin si hahandari ondon orin limu mukura. ");
INSERT INTO sim_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Urik Pita mu hulaima nokopma amber ondon or mbarik hikrik limu layira. Urik kumban or huvuhu ormu Avui Wasilakan sawera. Uhu fumunyava orhin or tormblehe nokove oso maninimba sihi wari mishi oroyok ormu heyera. Uhu ormu mbara, �Tabita, nyir usawa.� Karem or mbarik kolok misokome sihi simu hurira. Uhu Pitan si heyehe si usaha simu lira. ");
INSERT INTO sim_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Urik Pita tava sihin or tolorik simu usasira. Urik Pita Avui Wasilakahi ma ondo nga nokove mumbla nga nor usharik li tarik normu mukura, �Tabita tos usa lindu,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Urik Pita lerawu os or lari mashi oso li haisau handasawe irik yanga Jopak fehe ma amber li mistakoho ma mushak Wasilakan limu hishindiyara. ");
INSERT INTO sim_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Urik Pita yanga Jopa orok nambek Saimon nga liri vri. Saimon oto bulmakau sishin or tloloho mbele mbelen bulmakau sishi ondok undari ma ri. ");
INSERT INTO sim_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma lar yanga Sisariak lindari ri. Hi orhi Kornilius oria. Or Romik fehe kepten oria. Awun undari ma 100 orhi siyok li sihi awun undari lira. Awun undari ma ondo, �Italik fehe awun unda ma� karem li ushandari ma lira. ");
INSERT INTO sim_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Or Judama ambu ri, hako Avui Wasilakan lotu undari ma ri. Or nga ma ol aka orhik lindari ma ondo er nga amber Avui Wasilakan li tiyaha orin ermba ermbak lotu undari lira. Uhu Judama erndakava ondon ya mbele mbelen handari ri. Uhu ermba ermbak Avui Wasilakan sawendari ri. ");
INSERT INTO sim_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nindi las wolok am si homikurik 3 kilok hom si narik or mbele las sukuk heyendari hom ormu heyera. Or lihi nor heyerik ensel Avui Wasilakahi lar orhik or talaha ormu mbara, �Kornilius.� ");
INSERT INTO sim_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Karem or mbarik ensel oton or heyehe nor aje normu mbara, �Wasilaka, mberem uwa?� Urik ensel mu orin sawera, �Avui Wasilaka os orin mi sawenda angop or misiwa sir. Uhu os erndakava ondon armek mi uhu ya mbele mbelen mi handa oso nga angop or heyewa sir. Uhu os erem mi undan ormu rupshinduwa. ");
INSERT INTO sim_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wa, mir kolok ma lal mbashinak yanga Jopak li ika. Uhu ma lar orok li heye li sawe laha li taka. Hi orhi Saimon, hi yoko orhi Pita oria. ");
INSERT INTO sim_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Or Saimon ome larhi akak lindu. Saimon oto bulmakau sishin or tloloho mbele mbelen bulmakau sishi ondok unda ma ria. Aka orhi os solwara mambuk sinda sir.� ");
INSERT INTO sim_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel karem or sawe lafakaha ormu ira. Urik Kornilius ma frijip ornjik lerawun landari ma nga awun undari ma lar nga nor usharik limu rara. Awun undari ma oto or Judama ambu ri. Hako or er nga Avui Wasilakan lotu undari ma ri. Or ermba ermbak Kornilius nga pasir or lihi lerawun landari ma ria. ");
INSERT INTO sim_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Uhu Kornilius os or heyerik talarin lirin or sawehe nor mbashirik Jopak limu ira. ");
INSERT INTO sim_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Li wahandaha ma ol Kornilius mbashirik iri ondo li ihi am takondik si narik Jopak li layikurik simu nara. Oso wolo mende Pita Avui Wasilakan or sawekmbaha aka heyeyok ormu lawura. ");
INSERT INTO sim_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Uhu Pita or erengha or akurik ormu misira. Akwan li hundujeri hom or lihi mbele las sukuk heyendari hom ormu heyera. ");
INSERT INTO sim_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Or heyerik heven akayanga simu sutlara. Urik mbele las osmu takara. Oso waskowarmba laka hom nari sir. Sumbu sumbu yok li toloho li halashirik misambik takari sira. ");
INSERT INTO sim_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hako mbele mbele ol waskowarmba orok wari ondo fle mbashi, wako hovo, avi apsham apsham nandari ondo er nga orok wari lira. ");
INSERT INTO sim_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Urik Pita or lihi mashi las mbarik ormu misira, �Pita mir usaha ondo lal jihi aka!� ");
INSERT INTO sim_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Urik Pita mu mbara, �Wasilaka, wahau te. An mbeek mbele mbele ol misokome mihik mi heyewa jivik nanda ambu, karem mi pantlenda ondo kal a ahaheyenda ambu osik a akwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Karem or mbaha nor misirik indik ormu mbara, �Mbele mbele ol Avui Wasilaka ushirik jivik nahanda ondon avak kava, karem mbawa hala,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mashi oso Pitan hindi nalmingrip saweri sir. Urik Pita hindi nalmingrip, wahau, karem mbari ri. Ushirik waskowarmba oso kolomalok indiyok simu lawura. ");
INSERT INTO sim_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Urik Pita wavu musha mushak or hishihi ormu mbara, �Wa, mberemhi suku tosir, tos ter a heyewa toson?� karem or lihi hishirik ma ol Kornilius mbashirik tari ondo Pita liri akan li lasaraha os or liri akayangak limu ta sira. ");
INSERT INTO sim_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Uhu limu silira, �Saimon, hi yoko orhi Pita torok lindar mo wahau?� ");
INSERT INTO sim_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita suku os or heyeri oson or lihi hishirik Masikome Avui Wasilakahi orin ormu sawera, �Misi. Ma nalmingrip ol mirin lasarandu. ");
INSERT INTO sim_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mir usaha layi. Layihi lir nga nakrem ji i. Lir Judama ambu lir. Hako mir avak wavu mushak hishiwa hala. An mbashihindak tawa ma lir.� ");
INSERT INTO sim_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Urik Pita or layihi ormu mbara, �An Pita anira, ma or ji lasarawan. Jir mbelenjik ji randu?� ");
INSERT INTO sim_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Urik limu mbara, �Nir Kornilius torok ni raha mirin ni heye, karem or mbashihindak nimu randuwa. Or kepten Romik fehe ri. Awun unda ma 100 ondo orhi siyok sinda lira. Or ma jivik or naha Avui Wasilakan or lotu uhu orin tiyanda ma ri. Or, �ma jivi mende� karem Judama amber li mbanda ri. Hako ensel Avui Wasilakahi lar or talaha orin ormu saweshirik or nga mu nirin mbashiwak nimu randuwa. Ushinak aka orhik mi ihi mashi lal mi sawenak or misikmbahan.� ");
INSERT INTO sim_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Urik Pita lirin akomek or lalayihi oweshirik li lihi orok or nga limu wara. Li wahandaha or nga najer limu ira. Ma ol Jisashi mashin misindiyandari Jopak fehe lal er nga limu ira. ");
INSERT INTO sim_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Li wahandashihi li ihi yanga Sisariak limu talara. Kornilius or usharik orhi ma nga naimble orhi ondo er nga angop li talandirsaha Pitan nikishi liri lira. ");
INSERT INTO sim_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Urik Pita mu tara. Or taha akak or layirik Kornilius pasir or taha kumbamu Pitahik or avermbuwaha orin ormu lotu ura. ");
INSERT INTO sim_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Hako Pita orin or toloho ormu mbara, �Mir usa. Erem uwa hala. An mir hom men ma nir.� ");
INSERT INTO sim_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Uhu fri maimbaha frimu akak layira. Uhu or heyeri Judama ambu ondo musha mendek orok tirsa liri lir. ");
INSERT INTO sim_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Urik Pita mu lirin sawera, �Angop ji heyenda sir. Lo nihi karem mbanda sir, nir Judama nga jir Judama ambu nga mbeek nakrem ni likwa ambu nir. Uhu mbeek nir ihi pasir jir nga ni sikmbaha mbanda ambu sir. Hako an angop Avui Wasilaka sukuk or mukushihindak a heyehenda sir. Uhunda osik mbeek ma lar a mba, �Mir kava mir, mir misokome Avui Wasilakahik jivik nanda ambu mir,� karem a mbakwa ambu nir. ");
INSERT INTO sim_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Uwa osik a rakmbaha ji mainhashihindak a misihi kolomalok amu randuwa, mbeek mashi jihin a mblarnari ambu nir. Wa, ji sawenak a misi. Mberem ushiwak anin ji mbashihindak a randu?� ");
INSERT INTO sim_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Urik Kornilius mu mbara, �Niri nalmingrip am iri lir, mbele las anhik talarin. Aka anhik a lihi ter si nawa hom 3 kilokik si narik Avui Wasilakan a saweri nira. Urik kowe ukruharandarin faleri ma lar tumsar or talaha anhi fumunyavak or sirik amu heyera. ");
INSERT INTO sim_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Urik ormu mbara, �Kornilius, Avui Wasilaka os orin mi sawendan angop misiwa ri. Uhu os erndakava ondon armek mi uhu ya mbele mbele ondon mi handan angop heyewa ri. Uwa osik Avui Wasilaka os erem mi undan ormu rupshinduwa. ");
INSERT INTO sim_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wa, kolok ma lal mbashinak yanga Jopak li ihi Saimonin li heyeka, hi yoko orhi Pita ria. Uhu oton li laharaka. Ma oto or Saimon ome larhi akak lindu. Saimon orto bulmakau sishin tloloho mbele mbelen bulmakau sishi ondok unda ma ria. Aka orhi solwara mambuk sinda sir.� ");
INSERT INTO sim_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Karem or mbarik a misihi kolomalok ma ondon a mbashirik limu ira, mirin li heye li laharakmbahan. Uwa osik mi rashiwak nimu rupshi mendenduwa. Mashi os Wasilaka mirin or hahanda oson mi sawenak ni misikmbaha nimu talandirsanduwa. Uwak Avui Wasilaka ormu nir nga linduwa.� ");
INSERT INTO sim_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Urik Pita mu sawera, �Ter am amu heyekrahakoronduwa. Avui Wasilaka Judama ambu ondon or kumasihi Judama nom rupshinda ambu ri. Ma amber hom nakrem rupshinda ri. ");
INSERT INTO sim_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Hako yanga yanga amber hom ma ol orin lotu uhu nombo wornan tiyanda ondo amber or rupshinda lir. ");
INSERT INTO sim_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Avui Wasilaka nir Israelik fehe nirin mashi jivin or hahanda karem. Or mbashirik Jisas Krais or taha nor hashihindak waplelena Avui Wasilakahi mendek si nashihindak os nimu or nga waphimbiji linduwa. Jisas Krais orto ma amber lihi Wasilaka ria. ");
INSERT INTO sim_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jon mashin or sawe nor mbar, �Jir sunguwavun ji tormblehe fak ji layika.� Karem or mbashirik mbele mbele ol provins Galilik sishihi rara yanga Israelik talandari ondon angop ji heyenda sir. ");
INSERT INTO sim_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jir angop ji heyeri sir. Avui Wasilaka Jisas yanga Nasaretik fehendan or kamashihi Masikome orhi nga kwambu orhi nga orin hari ria. Uhu or nga nor sishirik Jisas yanga yangak or ihi hulaima nokopman armek or uhu ma ol Laulaka oloshirik kavak nahandari ondon or urik jivik limu nara. ");
INSERT INTO sim_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mbele mbele ol or urik yanga Israel nga Jerusalem orok talari ondo misokome nihik ni heyehe nimu sawenduwa. Hako Jisasin miandok li tirihi limu mandingormera. ");
INSERT INTO sim_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Hako niri frijip am fri ishirik Avui Wasilaka or mbarik Jisas indiyok or usaha hulaima nokopma misokome lihik ormu talara. ");
INSERT INTO sim_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hako Judama amber nembes, wahau. Ma nir mas Avui Wasilaka mbashirik mashi orhin sawendari ma nirtonom nihik talari ri. Os indiyok or usahari wolo nakrem ni lihi nimu ara. ");
INSERT INTO sim_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Uhu ormu nirin sawera, �Yanga yangak ji ihi kormbak karem ji sawe, Avui Wasilaka Jisas orto nom or kamashihindak ma ol hahanda nga ma ol liwa nga lirin or heyembakwa ri,� karem ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Profet ondo amber Jisasin karem sawendari ola. Ma ol Jisasin wavu lihik owenda ondo amber os miandok or hari nombo orokop Avui Wasilaka kavakava lihin or laha ermbekwa ola, karem mbahandari lira.� ");
INSERT INTO sim_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita mashin or saweri halanganga Masikome Avui Wasilakahi ma amber ol orok lihi mashin misiri ondohik ormu rakara. ");
INSERT INTO sim_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Urik Jisasin hishindiyandari Judama ol Pita nga nakrem rari ondo li misiri Judama ambu ondo yanga apsham apshamhik fehe mashi lihik li mbaha hi Avui Wasilakahin limu hauowera. Oson li misihi li lishnyafaha limu mbara, �Ambehoma. Avui Wasilaka Masikome orhi angop Judama ambu tondon er nga nor hawa lir.� Karem li mbarik Pita mu mbara, ");
INSERT INTO sim_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","�Ma rondo angop Masikome Avui Wasilakahin lawa lir, os nir lahanda hom. Uwa osik ma lar avak lirin pantlekwa ambu lir, os ma rondo li mbanak li fak tolofalekwan.� ");
INSERT INTO sim_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Uhu Pita ma ondon ormu sawera, �Ji mbanak avak kwambu Jisas Kraishik jirin li fak tolofaleka.� Karem mbashirik fak li layishihi limu orin sawera, �Mir avak niri lap nir nga ni lika,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ushirik aposel ondo nga Jisasin hishindiyandari ma ol provins Judiak lindari ondo nga limu misira, Judama ambu ondo angop Avui Wasilakahi mashin li misindiyarin. ");
INSERT INTO sim_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hako os Pita Jerusalemik indik or iri wolo, Jisasin hishindiyandari Judama olmu Pitan ngriara. ");
INSERT INTO sim_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Uhu olmu mbara, �Mir mberem ushirik Judama ambu ondo aka lihik mi layihi lir nga nakrem ji ar?� ");
INSERT INTO sim_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Karem li mbarik Pita mbele mbele ol orhik talarin lirin armek ormu sawera, ");
INSERT INTO sim_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","�Os yanga Jopak a lihi Avui Wasilakan a saweri wolo mbele las sukuk a heyendari hom a heyerik lersuwu yok simu rakara. Oso waskowarmba laka hom nari sira. Mbele las sumbu sumbu yok li toloho li halashirik anhik takari sira. ");
INSERT INTO sim_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Urik mbele mbele ol waskowarmba orok nari ondon armek a lishi heyeri, fle mbashi ol ma owelinda ondo, fle mbashi ol sembengalak fehe ondo, wako hovo, avi ondo karem orok nari lir. ");
INSERT INTO sim_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Urik mashi las heven yok a misirik ormu mbara, �Pita, mir usaha ondon jihi aka.� ");
INSERT INTO sim_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Karem or mbarik amu mbara, �Wasilaka, wahau te. An mbeek mbele mbele ol misokome mihik mi heyewa jivik nawa ambu, karem mi pantlenda ondo kal a ahaheyenda ambu osik a akwa ambu nir.� ");
INSERT INTO sim_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Karem a mbarik ormu mbara, �Mbele mbele ol Avui Wasilaka ushirik jivik nahanda ondon avak kava, karem mbawa hala,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mashi oso anin hindi nalmingrip saweri sir. Urik an hindi nalmingrip, wahau, karem a mbari nir. Ushirik waskowarmba oso indiyok lersuwu yok simu lawura. ");
INSERT INTO sim_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Si lawuri halanganga ma nalmingrip aka os a liri mishik limu tara. Lir Sisariak linda ma lar mbashirik tari lira. ");
INSERT INTO sim_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Urik Masikome Avui Wasilakahi mu anin sawera, �Lir nga ji ika. Lir Judama ambu lir. Hako wavu mushak hishiwa hala.� Karem or mbarik a misihi ma 6-pela Jisashi mashin misindiyandari ma ondo er nga nimu ira. Ni ihi ma otohi akak nimu layira. ");
INSERT INTO sim_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aka orhik ni layirik ormu nirin sawera, os ensel aka akome orhik or tala sirik or heyeri mashi oson. Ensel oto karem orin saweri ri, �Mir ma lal mbashinak Jopak li ika. Uhu ma lar Saimon, hi yoko orhi Pita oton li heye li sawe laharaka. ");
INSERT INTO sim_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ma oto avak or taha mashi lal mirin sawekwa ri. Os Avui Wasilaka avak mir nga ma ol nakrem aka mihik linda ondo er nga amber kavakava ji undan or laha ermbeshinak ermba ermbak jip ji likwa mashin.� Ensel karem orin or mbari oson anin ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Urik mashin lirin a sawerik Masikome Avui Wasilakahi mu lirik takara, os mas nihik or takahandari hom. ");
INSERT INTO sim_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Urik amu hishira, mashi os Wasilaka mas or mbahandarin. Karem or mbari osa, �Jon men hulaima nokopman fambak tolofalendari ria. Hako jir avak Avui Wasilaka mbashinak Masikome orhi or takaha jihik sikwa ri,� karem mbari ora. ");
INSERT INTO sim_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Os nir Wasilaka nihi Jisas Krais or saweri mashin ni misindiyarik Avui Wasilaka Masikome orhin nirin men hari ri. Undari hom ormu lirin erem hara. Uwa osik an mbeek lerawu os lihik or lari oson mbele las a mbandahi ambu nir, wahau.� Karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ma ondo Pitahi mashi oson li misihi mbeek orin li ngriakurik hishiri ambu lir, wahau. Hi Avui Wasilakahin li hauowehe limu mbara, �Ter am nimu heyenduwa. Avui Wasilaka or halashiwak Judama ambu ondo er nga sunguwavu lihin li tormblehe ermba ermbak jip li linda oson limu landuwa.� ");
INSERT INTO sim_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Os Stivenin li mandingormerik or hari wolo Jisasin hishindiyandari ma ondon er nga kavak li nakmbaha limu ura. Erem li urik Jerusalemin li halaha li tuluhu yanga yangak limu ira. Lal kuyanga home ol Judama ambu ondo linda mishi orok limu ira. Lal kuyanga Fonisiak, lal ailan Saiprusik, lal yanga Antiokik, karem limu ira. Uhu yanga orok mashi Jisashin li saweri Judama ondo nom li sawerik misiri lir, mbeek Judama ambu ondo nga saweri ambu lir. ");
INSERT INTO sim_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hako lihi nindik ma lal Saiprusik fehe nga yanga Sairinik fehe nga yanga Antiokik li ihi mashi Wasilaka Jisashin yanga Grikik fehenda ondon er nga limu sawera. ");
INSERT INTO sim_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Urik kwambu Wasilakahi lihik si nashirik ma mushak sunguwavu lihin li tormblehe Wasilakahi mashin limu misindiyara. ");
INSERT INTO sim_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sios Jerusalemik fehe ma mashi oson li misihi Barnabasin li mbashirik Antiokik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Or ihi nor heyeri Avui Wasilaka orok fehe ma ondon armek or uhu nor jelyashirik or heyehe ormu rupshi mendera. Uhu ma ondon armek ormu owesawera. Unak wavu lihi mende nga Wasilakan ermba ermbak li tiyakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas oto ma jivi mendek or narik Masikome Avui Wasilakahi orhik or sishirik kwambu mendek Wasilakan hishindiyandari ri. Uri osik mashin or sawerik ma musha mendek Wasilakan limu wavu lihik owera. ");
INSERT INTO sim_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ushihi Barnabas yanga Tarsusik or ihi Solin ormu lasara. ");
INSERT INTO sim_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Or ihi orin or heyehe nor laha yanga Antiokik frimu rara. Uhu asama namtas orok fri lihi ma musha mende Jisasin hishindiyandari ondon mashin frimu owesawera. Yanga Antiok orok Antiokik fehe ondo ma ol Jisasin hishindiyandari ondon li heyehe �Lir Kraishi ma,� karem maifu mendek limu ushara. ");
INSERT INTO sim_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Oso wolo profet lal yanga Jerusalemin li halaha yanga Antiokik limu rakara. ");
INSERT INTO sim_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Profet ondo lihi lar hi orhi Agabus oria. Masikome Avui Wasilakahi or sauhashirik mashin ormu sawera, os yanga yanga misambi amber akwa mendek si nakuri mashin. Ushirik os Klodius or malakama Sisar Romik fehek or nari wolo akwa mendek simu nara. ");
INSERT INTO sim_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Urik Jisasin hishindiyandari Antiokik fehendari ma Agabus saweri mashi oson li misindari osik am akwa mendek si narik ya lal li laha Jisasin hishindiyandari ma ol provins Judiak lindari ondon li hashinak ya oso lirin si jelyakmba limu mbara. Ma ol ya lakak nari ondo lakak li hakmba limu mbara. Ma ol ya awar nari ondo awar li hakmba limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Uhu ya ondon li owe tirsashirik Barnabas fre Solin li mbashirik ya ondon fri laha provins Judiak frimu ira. Fri laha ihi orok sios lida ondon frimu hara. ");
INSERT INTO sim_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Oro wolok king Herot Agripa Jisasin hishindiyandari ondon kavak or nakurik ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Uhu nor mbarik bainatik Jemsin limu jimandingormera. Jems oto sanje Jonhi ria. ");
INSERT INTO sim_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot or heyeri os erem or uri oso Judama lida lihi limu rupshira. Uri osik Pita er nga nor mandingormeshinak or hakmbaha normu hishira. Oso wolo Judama hiyawu Bret Yis Ngashi Ambun li andari wolo sira. Uhu Pitan or mbashirik li toloho krawuk limu owera. ");
INSERT INTO sim_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Uhu or mbashirik awun undari ma 16-pela ondo tovro kavrombak orin limu washilira. Uhu Herot karem hishiri ora, �Hiyawu wasilaka Pasova oso mendek si nanakop a mbashinak Pitan li laharlanak hulaima nokopmahi misokomek yawur kormbak orin a kotim ukwa nir,� karem ormu hishira. ");
INSERT INTO sim_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Erem or mbashirik Pita krawu akak ormu lira. Hako Jisasin hishindiyandari ma ondo li tirsaha kwambu mendek olmu Avui Wasilakan saweri lira. Ushinak Pitan or jelyashinak krawu akan or hala talakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot Agripa mu os Pitan or kotim ukuri wolon kamara. Os or kamandari de oso si hara namber, Pita awun undari ma ovrohi nindik ormu suknyara. Tava orhi angop sen kuvuk awun undari ma ovrohi tava nga li anamblashi li ishishirik siri vri. Urik awun undari ma lal olmu akayanga hikrik arangoshi lira. ");
INSERT INTO sim_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Urik tumsar ensel Wasilakahi lar mu talara. Urik ukruharandari aka orok simu ukrura. Urik ensel Pitan aimak or jihi nor lembasihi ormu mbara, �Mir kolok usa.� Karem or mbarik kolok sen kuvu ovro mu tlolo farakara. Urik ensel mu mbara, ");
INSERT INTO sim_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","�Kufulombo mihin ishindangrihi kumba ari mihi nga faleka.� Karem or mbarik os or mbari hom Pita mu ura. Urik ensel mu mbara, �Kousamba mihi nga falehe anin tiyaka.� ");
INSERT INTO sim_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Urik Pita krawu akan or halaha ensel oton ormu tiya ira. Hako Pita sukuk or heyer, karem hishiri ri. ");
INSERT INTO sim_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Fri ihi akayanga maifuk sindarin fri tikrishihi akayanga nindin fri tikrishihi akayanga sambak frimu ira. Urik akayanga oso sihik simu sutlara. Ushirik frimu layishihi ira. Nombo lakak fri ihi kolok ensel mu Pitan halashi ira. ");
INSERT INTO sim_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ushirik Pita am or hishiyarihi ormu mbara, �Ter amu hishiyarinduwa, Avui Wasilaka mbashiwak ensel orhi anin jivinakwak tawa ri. Herot nga Judama ol mbele mbele kava anin ukwak li mbawa ondo lihi tavarenjek anin indik or lakmbahan.� ");
INSERT INTO sim_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Uhu aka Mariahik ormu ira. Sir nijava Jonhi sira. Jon hi yeje orhi Mak oria. Ma musha mendek aka orok li tirsaha Avui Wasilakan sawe liri lir. ");
INSERT INTO sim_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita am or ihi ormu akan tirira. Akan or tiririk orok lerawun landari nokopminyongo las mu akayangan sutlakurik tara. Hi sihi Roda sira. ");
INSERT INTO sim_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hako Pitahi mandarjinyak si misihi sunguwavu sihi er si rupshi mendehe akayangan si sutla namber indiyok simu shirinya ira. Si ihi orok tirsandari man simu sawera. �Pita or taha akayangak sindu.� ");
INSERT INTO sim_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Karem si mbarik limu mbara, �Wahau te. Nyir ferfar nyimu mbandu?� Hako si mblarna menderik li misihi limu mbara, �Nyir ensel or Pitan washilindan heyewa nyir,� karem limu mbara. ");
INSERT INTO sim_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hako Pita er sishi akan tiriri ri. Urik akayangan li sutlaha orin limu heyera. Uhu er limu lishnyafara. ");
INSERT INTO sim_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Urik Pita mayam li likmbaha ormu tavalounara. Uhu nombo os Wasilaka orin or jivinashirik krawun or hala talari mashi oson ormu sawera. Uhu ormu mbara, �Jir avak Jems nga ma anandi ol Jisasin hishindiyanda ma ondo nga ji sawenak li misika, mbele mbele os anhik talawa oson.� Ushihi Pita lirin or halaha yanga anandi yok ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Am si hararik, awun undari ma li heyeri Pita mbeek krawu aka orok liri ambu ri. Ushirik li mbelehe limu aje mendera. Uhu lihinjik limu anasili anasilira, �Pita mbeek or iwa?� ");
INSERT INTO sim_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot Agripa or heyeri mbeek Pita orok liri ambu. Urik ma ondon or mbashirik Pitan limu lasaira. Hako mbeek li heyeri ambu ri. Urik awun undari ma ol Pitan washiliri ondon li kotim uhu li mandingormeshinak li hakmbaha ormu mbara. Ushihi Herot provins Judian or halaha yanga Sisariak ormu layira. Uhu orok ormu lira. ");
INSERT INTO sim_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nindi las wolok King Herot Agripa yanga Tairik fehe ma nga Saidonik fehe ma nga ormu waplelena mendera. Uri osik yanga orok fehe ma li tirsaha orin li heyekurik limu ira. Unak waplelena orhi mendek si nakmbahan. Lir ermbak kuyanga os Herot arangondari mishi orok akwan li landari osik, las avak Herot lirin or waplelenaha akwan li landari nombon or pantlenda ngashi, karem mbaha li ajehe olmu ira. Li ihi masmas Blastus, or Herot wandari aka oson washilindari man li heyehe limu sawera. Ushinak mishamaimbanda mak or naha nor i Agripan or heyesaweshinak waplelena orhi mendek si nakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ushirik Herot os lirin or heyekuri wolon ormu kamara. Oso wolo king falendari kowen or falehe sia os king lindari orok ormu lira. Uhu mashi lal ormu sawera. ");
INSERT INTO sim_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Urik yanga Tairik fehe ma nga Saidonik fehe ma nga lirin or rupshikmbaha li hokophakovihi mainlakalakan jihi limu mbara, �King Herot mashin or mbawa kwambu nga nor naha Avui Wasilaka hom mbaw te. Mbeek ma mbanda hom mbawa kom te.� Karem limu er washimbara. ");
INSERT INTO sim_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Urik Herot mashi os li mbari oson or misihi or rupshihi mbeek hi Avui Wasilakahin hauoweri ambu ri. Erem or urik kolok ensel Avui Wasilakahi mu orin jira. Urik jipmiskavamisindari las orhik nari sir. Urik owe ol hovo hom nanda shishirik ormu hara. ");
INSERT INTO sim_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hako mashi Avui Wasilakahi yanga yangak li haisau handasawe irik ma mushak Jisasin limu hishindiyara. ");
INSERT INTO sim_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Urik Barnabas nga Sol nga lerawu frihin Jerusalemik fri larakoho indik Antiokik frimu ira. Uhu Jon Mak er nga fri laha limu ira. ");
INSERT INTO sim_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sios Antiok orok lindari ma lal hi lihi karem. Barnabas, Simeon, Simeon oto hi yoko orhi Niger, Lusius yanga Sairinik fehenda, Sol, Manain. Manain oto or king Herot Antipas nga nakrem sahandari ma ri. Lir profet mashik li mbaha mashi Avui Wasilakahin armek owesawendari ma lir. ");
INSERT INTO sim_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nindi las wolok hulaima nokopma sios orok fehe Avui Wasilakan li lotu uhu akwan li halaha limu lira. Urik Masikome Avui Wasilakahi lirin ormu sawera, �Jir avak Barnabas fre Solin ji kamashinak lerawu os fri lakmbaha na mbahandan fri laka.� ");
INSERT INTO sim_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Urik akwan er li hala lihi tava lihin masiji frihik li hauowehe Avui Wasilakan li sawehe li mbashirik frimu ira. ");
INSERT INTO sim_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Masikome Avui Wasilakahi fririn or mbashirik yanga Selusiak frimu ira. Orok sipik fri lawuhu ailan Saiprusik frimu ira. ");
INSERT INTO sim_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ailan Saiprus oso yanga lal nga nandari lira. Las Salamis sira. Yanga Salamis orok frimu layira. Salamisik fri layihi Judama lotu undari akak mashi Avui Wasilakahin frimu sawera. Jon Mak fririn or jelyakmbaha er nga normu ira. ");
INSERT INTO sim_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Li ihi ailan Saiprus amber hom li yaha mashin li sawe ihi yanga yervle Pafosik li sawekurik limu ira. Pafos orok Judama lar or mbele mbele entlembantlen sindari man limu heyera. Hi orhi Barjisas oria. Or haimba handambandari profet lar oria. ");
INSERT INTO sim_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Malakama Sergius Paulus nga lindari ria. Sergius Paulus oto wavu krahak hishiyarindari ma ria. Undari osik mashi Avui Wasilakahin fri sawenak or misikmbaha fririn ormu ushara. ");
INSERT INTO sim_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hako Barjisas oto hi orhi Grikhi mashik Elimas, karem li ushandari oto lerawu os fri lakmba urin ormu pantlera. Mberem ushirik? Or mbeek malakama oto Jisashi mashin or misindiyakmbaha or hishiri ambu. ");
INSERT INTO sim_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hako Sol, hi yeje orhi Pol, Masikome Avui Wasilakahi orhik or sishirik Elimas oton or heilatalehe normu mbara, ");
INSERT INTO sim_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","�Mir Laulakahi jikisi mira. Mir jipjip linda nombo oson uwak kavak li nanda ma mira. Mir ermbak mi haimba handambaha wapkava hishihi os jipjip linda nombo Wasilakahin uwak kavak nanda ma mira. Hako mir os er mi unda oson halakwa ambu om? ");
INSERT INTO sim_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Uwa osik misi. Wasilaka avak ter mirin jikwa ri. Unak misokome mihi avak si tumushinak mbeek mbele las heyekwa ambu mir. Uhu kandakar nga nambek erem er naha likwa mira.� Pol karem or mbarik kolomalok lersuwu tle nga kwandi nga si taha Elimashi misokomen simu arangora. Urik ma ol orin toloho nombon mukukurinjik ormu lasa ira. ");
INSERT INTO sim_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Urik malakama Sergius Paulus oto os Elimas erem or nari oson or heyehe nor lishnyaha wavu orhi si usarik Wasilakan wavu orhik ormu owera. ");
INSERT INTO sim_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Urik Pol le yanga Pafosin li halaha sipik li lawuhu limu yanga Pergak ira. Perga oso yanga Pamfiliak nandari sira. Hako Jon Mak fririn orok or halaha indiyok Jerusalemik ormu ira. ");
INSERT INTO sim_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Urik Pol fre Barnabas nom yanga Pergan fri halaha frimu yanga Antiokik ira. Antiok oso yanga Pisidia mavayok nandari sira. Am Sabat wolok si narik Judama lotu undari akak fri layihi frimu takalira. ");
INSERT INTO sim_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Urik mashi Avui Wasilakahi Moses kayehendari las nga profet kayehendari las er nga limu ritim ura. Ushirik ma ol li lotu undari akan washilindari ma ondo li mbashirik ma lar ihi Pol fre Barnabasin ormu silira, �Shirin, shir mashi las er nga ma tol torok liwa tondon shi saunjelyakwak shi hishi nahi, wa shi saweka.� ");
INSERT INTO sim_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Urik Pol or usasihi mayam li linak mashin or sawekmbaha normu tavalounara, �Jir Israelik fehenda ma nga jir Judama ambu ol Avui Wasilakan lotu unda jir nga, ji misi. ");
INSERT INTO sim_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Avui Wasilaka nir Israelhi nelokon or kamaha nor ushirik os Ijipik li liri wolo musha mendek limu nara. Uhu kwambu orhi mendek lirin indiyok Ijipik normu laharara. ");
INSERT INTO sim_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hako orin li kumasirik or halashirik asama 40-k misamtelmbamba orok yari lira. Hako mbeek lirin halari ambu ri. ");
INSERT INTO sim_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Urik Avui Wasilaka kuyanga Kenan orok fehendari kraha 7-pela ondon or mbarik kavak limu nara. Uhu misambi oson neloko nihi ondon ormu halashira. Unak misambi oso lihik er si nakmbahan. ");
INSERT INTO sim_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Os Ijipik li liri wolok sishi raha Kenanik li layi misambin li humasi laha li liri asama 450 hom nari sira. Urik Avui Wasilaka maifuk sindari ma ondon or kamashirik Israel orok limu sira. Er li li ihi profet Samuel mu talara. ");
INSERT INTO sim_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Urik Israel ondo king nga li nakmbaha limu mbara. Urik Avui Wasilaka Solin or kamashirik kingik or naha asama 40-k ormu sira. Sol oto jikisi Kishi ri. Benjaminhi krahak fehendari ri. ");
INSERT INTO sim_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hako Avui Wasilaka Solin or halashihi Devitin or kamashirik kingik ormu nara. Uhu ormu sawera, �A heyewa Devit jikisi Jesihi oto sunguwavu anhi osmu orin rupshi mendenduwa. Or avak mbele mbele os a mbawan tiyakwak a heyewa ma ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Uhu maskop or mbahandari hom kraha Devithik fehe ma lar or kamashirik Israelik talari ria, nirin or jivinakmbahan. Ma oto Jisas oria. ");
INSERT INTO sim_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisas lerawun or la namber, Jon masmas Israelik fehendari ma ondon amber mashin ormu sawera, sunguwavun li tormbleshinak lirin fak or tolofalekmbahan. ");
INSERT INTO sim_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon am or hakuri wolok si narik ormu sawera, �Ji hishiwa an lawe mende nir? An ma or jirin jivinakwa ma ambu nir. Hako ji misi, ma or jirin jivinakwa ma oto avak takwa ri. An ma jivi ambu nir. Unda osik an mbeek kuvu os kumba ari orhi orok nawan a sorngondahi ambu nir. Hako ma or jirin jivinakwa ma oto jivi mende indinga ria,� karem ormu mbara. ");
INSERT INTO sim_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mahasanje, jir Abrahamhi nirambara nga Judama ambu ol Avui Wasilakan lotu unda ma jirin. Mashi os Avui Wasilaka Jisas oton or kamashirik nirin or jivinahanda mashi oso nir amber nirnjik li sawehendari sir. ");
INSERT INTO sim_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ma ol Jerusalemik lindari nga lida lihi ondo nga mbeek orin li heyehe lirin jivinakmbaha Avui Wasilaka kamahanda ma ri, karem yawur hishiyariri ambu lir. Uhu mashi mashi os profet kayehendari ermba ermbak Sabat wolok li sawendari oso nga yawur hishiyariri ambu lir. Uri osik orin li mandingormekmbaha limu mbara. Mashi os karem li mbari oso er nga osmu profet mas li mbahandari hom nara. ");
INSERT INTO sim_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hako li heyeri mbele las or uri mbeek kavak nari ambu sir. Unak orin li kotim uhu li jimandingormekurin. Hako li ukmisi flarna mendehe malakama Pailatin li mbarik or mbashirik orin limu mandingormera. ");
INSERT INTO sim_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mbele mbele os orin li ukmbaha profet mas li kayehendari oso amber orin li urakoshihi maninimba orhin miandok li laha mawak limu halowera. ");
INSERT INTO sim_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Hako Avui Wasilaka or mbarik indiyok usahari ri. ");
INSERT INTO sim_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Uhu hindi mushak kormbak or talarik ma ol Galilin halaha or nga nakrem Jerusalemik iri ondo orin limu heyera. Ushihindak ma ondo os orin li heyendan Judama ondon ter nga olmu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Uwa osik Barnabas nga an nga mashi jivi os Avui Wasilaka maskop misumu walanga nihi ondon or ukmbaha nor mbahandari mashi oson ter os jirin shimu sawenduwa. ");
INSERT INTO sim_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33