﻿USE sofia;
DROP TABLE IF EXISTS sofia.sil_vpl;
CREATE TABLE sil_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sil_vpl WRITE;
INSERT INTO sil_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu doho niaa nɛ ŋla. U naabalimaba nɛ fa ŋaa Abiraham ari Devit. ");
INSERT INTO sil_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abiraham nɛ fa lul Aizik. Aizik ma sii lul Jekɔb. Jekɔb ma sii lul Juda ari u naaŋbiiriŋ. ");
INSERT INTO sil_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ma sii lul Pɛrɛs ari Zɛra. (Ba naaŋ yiriŋ nɛ fa Tama.) Pɛrɛs ma bira sii lul Hɛzurɔŋ. Hɛzurɔŋ ma sii lul Ram. ");
INSERT INTO sil_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ma sii lul Amiinadab. Amiinadab ma sii lul Naasuŋ. Naasuŋ ma sii lul Salimɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimɔŋ ma sii lul Buas. (Buas naaŋ yiriŋ nɛ fa Rehab.) Buas ma sii lul Obɛd. (Obɛd ma naaŋ yiriŋ nɛ fa Rut.) Obɛd ma sii lul Jɛsi. ");
INSERT INTO sil_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛsi ma bira sii lul kuoro Devit. Devit ma fa lul Solomɔŋ (Solomɔŋ ma naaŋ fa ŋaa Uraya haala nɛ. Uraya suu aŋ ka Devit joŋo jaa.) ");
INSERT INTO sil_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomɔŋ ma sii lul Rihabam, Rihabam ma sii lul Abaaja, Abaaja ma sii lul Asa. ");
INSERT INTO sil_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ma sii lul Jihosafat, Jihosafat ma sii lul Jɔram, Jɔram ma sii lul Uzaya. ");
INSERT INTO sil_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaya ma sii lul Jotam, Jotam ma sii lul Ehas, Ehas ma sii lul Hizikaya. ");
INSERT INTO sil_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizikaya ma sii lul Manaasi, Manaasi ma sii lul Emɔŋ, Emɔŋ ma sii lul Jusaya. ");
INSERT INTO sil_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jusaya ma sii lul Jekonaya ari u naaŋbiiriŋ. Bua-la lɛ nɛ ba kɛŋ Iziral tiŋŋaa mu Babilɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba fa si kɛŋ Iziral tiŋŋaa kaa mu Babilɔŋ ŋii, u ŋii hariŋ lɛ nɛ Jekonaya lul Sialitɛl, Sialitɛl ma sii lul Zerubabil. ");
INSERT INTO sil_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabil ma sii lul Abayat, Abayat ma sii lul Ɛlayakim, Ɛlayakim ma sii lul Azɔ. ");
INSERT INTO sil_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔ ma sii lul Zadɔk, Zadɔk ma sii lul Akim, Akim ma sii lul Ɛlayat. ");
INSERT INTO sil_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛlayat ma sii lul Eliyeza, Eliyeza ma sii lul Mataŋ, Mataŋ ma bira sii lul Jekɔb. ");
INSERT INTO sil_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekɔb ma sii lul Josɛf, Josɛf nɛ saa jaa Mɛɛri. U nɛ lul Yesu, nii-la ba sií yirɛ Kirisito. ");
INSERT INTO sil_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A suomi Abiraham si hɛ u miisiŋ lɛ a kaa kukɔ Devit si hɛ u miisiŋ lɛ, ba di u nihiliɛrɛba kala fa ŋaa fii ari banɛsɛ nɛ. Devit si hɛ u miisiŋ lɛ a kaa kukɔ bua-la lɛ ba fa si kɛsɛ Iziral tiŋŋaa kaa mu Babilɔŋ, Devit nihiliɛrɛba kala ma fa ŋaa fii ari banɛsɛ nɛ, a bira chiŋ bua-la lɛ ba si kɛsɛ Iziral tiŋŋaa kaa mu Babilɔŋ a kaa kukɔ bua-la lɛ ba si lul Kirisito, nialiŋ ba si kɛsɛ kaa mu Babilɔŋ nihiliɛrɛba ma fa ŋaa fii ari banɛsɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ŋla nɛ ba ŋaa a lul Yesu Kirisito. Josɛf nɛ fa sugɛ u naaŋ Mɛɛri duu jaa. Ka di ba-na jaa dɔŋɔ, Mɛɛri na duu kɛŋ luoruŋ nɛ. Wia Diŋ-zɔŋ-la nɛ hɛ pu. ");
INSERT INTO sil_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josɛf fa ŋaa ni-pula nɛ. U fa bi chɛ duu hiisɛ Mɛɛri niaa tuɔŋ. Ŋii nɛ u kɛŋ u tuɔŋ lɛ duu viau. ");
INSERT INTO sil_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","U fa síi biinɛ ŋii, Wia tiŋdaara dɔŋɔ kɔ u teeŋ ari duosoo tuɔŋ a bula pu a bul, “Josɛf, Devit doho nuu, sí leŋe di fawulluŋ kɛniŋ ŋ síi chɛ di ŋ jaa Mɛɛri, bɛɛ wiaa luoru-la u si kɛnɛ ŋaa Wia Diŋ-zɔŋ-la nɛ hɛ pu. ");
INSERT INTO sil_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U jaŋ lul baal, ŋ jaŋ hɛ u yiriŋ Yesu, bɛɛ wiaa u nɛ jaŋ laa u niaa haachɛba ta.” ");
INSERT INTO sil_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wiiŋ deeŋ kala ŋaa di wialiŋ la Tiina Wia fa si bula ku ŋaa wutitii. U fa to u nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ a bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wialiŋ u fa si bula nɛ ŋla: “Ha-tolo kubala ha si bi baal jiŋ jaŋ kɛŋ luoruŋ a lul bie. Ba jaŋ hɛ u yiriŋ Imanuɛl.” (U yiri-la bubuɔŋ nɛ Wia hɛ la teeŋ.) ");
INSERT INTO sil_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josɛf si sii doŋ lɛ, u ŋaa ŋii Wia tiŋdaari-la si bula pu a jaa Mɛɛri. ");
INSERT INTO sil_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","U si jaau ŋii, ba duu bi dɔŋɔ jiŋ, ka u lul u ha-toli-bie. Ŋii nɛ Josɛf hɛ u yiriŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Ba lul Yesu Bɛtilɛhɛm lɛ nɛ. Ta-bie-la fa hɛ Judiya tiŋteeŋ lɛ nɛ. Bua deeŋ lɛ baal kubala baa yirɛ Hɛrɔd nɛ fa ŋaa tiŋtee-la kuoro. Ba si lul Yesu, wu-jinnaa lii taŋ-bubuɔŋ a kɔ Jerusalɛm a piɛsɛ, “Ju̱u tiŋŋaa kuoru-la ba si lula hɛ nii nɛ? La na u chɛŋwuluŋ taŋ-bubuɔŋ nɛ a kɔ di la chuɔlu.” ");
INSERT INTO sil_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuoro Hɛrɔd fa si nii wiiŋ deeŋ, fawulluŋ kɛŋ ba di Jerusalɛm niaa kala kiŋkɛŋ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ŋii nɛ u yirɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba-la ba ku hilimi. U piɛsɛba a bul, “Nii nɛ ba jaŋ lul Kirisito, nii-la Wia si liisa?” ");
INSERT INTO sil_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ŋii nɛ ba bula pu a bul, “Ba jaŋ lulu Bɛtilɛhɛm, Judiya tiŋteeŋ lɛ. Ŋla nɛ nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ŋmuŋsɛ: ");
INSERT INTO sil_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Wia si, ‘Bɛtilɛhɛm ŋaa ta-bie nɛ Judiya tiŋteeŋ lɛ. Ama Judiya tiŋteeŋ kala lɛ, Bɛtilɛhɛm niaa nɛ ŋaa ni-balaa, bɛɛ wiaa ba tuɔŋ nɛ Iziral kuoro jaŋ lii, nii-la si jaŋ beŋ mi niaa, Iziral tiŋŋaa.’ ” ");
INSERT INTO sil_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ŋii nɛ Hɛrɔd luɔra yirɛ wu-jinna-la si lii taŋ-bubuɔŋ a kaa mu faa a piɛsɛba di ba dagu bua-la titia lɛ chɛŋwul-la si lia. Ba daga pu. ");
INSERT INTO sil_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ŋii nɛ Hɛrɔd taba di ba mu Bɛtilɛhɛm, aŋ bula piba a bul, “Má mu chɛ bile ari siifiɛsiŋ. ‘Di ma nɛ nau, má leŋ di mi ma jiŋ ŋii niiŋ lɛ, a ma mu chuɔlu.” ");
INSERT INTO sil_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba si nii ŋii, ba lii joŋ woŋbiiŋ aa mu. Chɛŋwul-la ba fa si na taŋ-bubuɔŋ bira laa ba sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba bira si na chɛŋwul-la, ba tuɔŋ kala tɔrɛ, ba jujuɔsɛ. ");
INSERT INTO sil_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba si mu yi lee-la bii-mulo-la si hɛ, chɛŋwul-la chiŋ dia-la nyuŋ. Ba mu juu dia-la a na bii-mulo-la ari Mɛɛri, u naaŋ. Ba tuu kpirimi u sipaaŋ a chuɔlu. Ŋii nɛ ba puri ba chugusuŋ a liisɛ kiaa pu: Sɛlimɛ, tii-keli-zɔŋ baa yirɛ firaŋkiŋsɛŋs ari tii-keli-zɔŋ dɔŋɔ baa yirɛ mɛɛ. ");
INSERT INTO sil_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ŋii nɛ titaŋiŋ Wia bula piba duosoo tuɔŋ ari ba sí miira mu Hɛrɔd teeŋ. Ŋii nɛ ba sii a to woŋbii-wogo a miira mu ba jaŋ. ");
INSERT INTO sil_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","14","Ba si miira joŋ ba woŋbiiŋ a viiri, Josɛf piŋ doŋ a duosi a na Wia tiŋdaara di u kɔ u teeŋ a bula pu, “Sii a joŋ bii-mulo-la ari u naaŋ a fá mu Ijipiti tiŋteeŋ a hɛ dimɛ see di mi bira bula piŋ di ŋ lii dimɛ, bɛɛ wiaa Hɛrɔd chɛ di u kpu bii-mulo-la nɛ.” Ŋii nɛ u sii a joŋ bii-mulo-la ari u naaŋ a mu Ijipiti tiŋteeŋ titaŋiŋ. U hɛ dimɛ nɛ deeŋ deeŋ Hɛrɔd ku suu. ");
INSERT INTO sil_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wiiŋ deeŋ ŋaa di wii-la Wia fa si to nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ku ŋaa wutitii. U fa bula ari u jaŋ yirɛ u bie duu lii Ijipiti tiŋteeŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛrɔd si na ari wu-jinna-la nyisu nɛ, u faasa na baaniŋ. Wu-jinna-la fa si dagu bua-la lɛ ba si lul Yesu, u jiŋ ŋii. Ŋii nɛ u ta u laali-yuoroo di ba mu Bɛtilɛhɛm ta-biisi-la kala si gollu chu a kpu haŋbolibiisi-la kala si ha bi jisiŋ balia kiele. ");
INSERT INTO sil_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A tiŋ ŋla wiaa wii-la Jɛrimaya fa si bula ku ŋaa wutitii nɛ. U fa ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Wialiŋ u fa si bula nɛ ŋla: U si, “Niaa níi yel Rama lɛ, niaa faasa yel nɛ. Haal kubala ba síi yirɛ Rechil yel u haŋbiisiŋ wiaa nɛ. U yele, u bi tɔrɔ, bɛɛ wiaa ba kala suba nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","21","Ŋii nɛ Hɛrɔd ku suu. U si suba ŋii, Josɛf bira duoso a na Wia tiŋdaara di u kɔ u teeŋ a bula pu, “Sii a kɛŋ bii-mulo-la ari u naaŋ a miira mu Iziral tiŋteeŋ. Nialaa fa síi chɛ di ba kpu bii-mulo-la, ba suba nɛ.” Ŋii nɛ u kɛŋ bile ari u naaŋ a kaa mu Iziral tiŋteeŋ a hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama Josɛf si nia ari Hɛrɔd suba, ka u bie Akiliyas dii kuoruŋ Judiya tiŋteeŋ lɛ, fawulluŋ fa kɛnu ari u si jaŋ hɔŋ dimɛ. Ŋii nɛ Wia bira bula pu duosoo tuɔŋ duu mu hɔŋ Galilii tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","U si mu Galilii tiŋteeŋ, u mu hɔŋ taŋ kubala lɛ baa yirɛ Nazarɛt. U ŋaa ŋii di wialiŋ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ŋaa wutitii nɛ. Ba fa bula a bul, “Ba jaŋ kɛnu yirɛ Nazarɛt tiina.” ");
INSERT INTO sil_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bua-la lɛ Jɔɔŋ Wia lii-foori-la sii kɔ Judiya tiŋteeŋ a juu giri-bine tuɔŋ a suomo bubul Wia wiaa pipi niaa. ");
INSERT INTO sil_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","U bula piba a bul, “Má birima lii ma haachɛba lɛ, bɛɛ wiaa Wia kuorii-la kpaga nɛ!” ");
INSERT INTO sil_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ ma fa bul Jɔɔŋ wiaa nɛ. U yiriŋ nɛ fa Azaaya. U fa si, “Nuu nɛ chiŋ giri-bine tuɔŋ aa heele bul, ‘Má kɔ a wasɛ woŋbiiŋ bil di la Tiina kɔ a tuto. Má ŋaa ŋii duu nɛ kɔ, u di-vɛniŋ jaŋ piŋ woruŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔɔŋ gɛnniŋ fa ŋaa buŋtaŋŋa punaa nɛ ba kaa sua, a kɛŋ teŋbiiŋ vɔɔ u tiŋa, u kudiilee ma nɛ fa nyaŋgirikɛba ari tuuŋ. ");
INSERT INTO sil_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Niaa lii Jerusalɛm ari Judiya tiŋteeŋ kala ari tasi-la kala si golli Jɔɔdaŋ fuo-la a kɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba dagɛ ba haachɛba aŋ tuu Jɔɔdaŋ fuo-la, u foba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jɔɔŋ na Farisii tiŋŋaa ari Sadusii tiŋŋaa di ba yuga a kukɔ u teeŋ duu foba Wii-chuɔlɛ liiŋ. U si naba, u bula piba a bul, “Ma niaa deeŋba wu-ŋaalaa nagɛ diŋŋaa nɛ. Ma biina ma jaŋ wuo fá lɛl chɛɛ-la Wia si jaŋ dii nuu-kala sariyaa? ");
INSERT INTO sil_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Máa ŋaa wialiŋ si jaŋ dagɛ ari ma birima lii ma haachɛba lɛ nɛ ");
INSERT INTO sil_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","aŋ sí biina a bul Abiraham si ŋaa ma naabalima ŋii, Wia bi jaŋ dɔgisɛma. Mi jaŋ bula pima ari Wia paala jaŋ wuo ŋaa di tabiaa deeŋba ma si na birimɛ Abiraham doho niaa. ");
INSERT INTO sil_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na ba kɛŋ saaŋ jee nɛ a ŋaa siri di ba keri tiisiŋ lo. Tia-la kala si bi nɛŋ-zɔŋŋɔɔ ka nɛŋ, ba jaŋ kere lo a hɛ nyiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi-na foma Wii-chuɔlɛ liiŋ a dagɛ ari ma birima lii ma haachɛba lɛ nɛ, ama nii-la si jaŋ to mi hariŋ kɔ, u nɛ jaŋ joŋ Wia Diŋ-zɔŋ-la a hɛ ma dɔŋsuŋ lɛ aŋ joŋ nyiniŋ hɛ dɔŋsuŋ ma lɛ. U nɛ yuga kiimi. U paala bi maga di mi kori u nɛŋtɛŋŋɛɛ maa. ");
INSERT INTO sil_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U jaŋ kori mii-chaari-gbaŋa duu ŋmoo u miaa kala dɛrɛ, u jaŋ kɛŋ gbaŋa-la a kaa chaarɛ a liisɛ mii-biiŋ a hɛ u vire lɛ aŋ joŋ jɔruŋ a hɛ nyiniŋ lɛ. Nyiŋ-la bi jaŋ disɛ.” ");
INSERT INTO sil_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bua-la lɛ Jɔɔŋ fa síi bul Wia wiaa aŋ fufo niaa Wii-chuɔlɛ liiŋ ŋii, Yesu sii lii Galilii tiŋteeŋ a kɔ Jɔɔŋ teeŋ duu fou Wii-chuɔlɛ liiŋ Jɔɔdaŋ fuo-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama Jɔɔŋ si nii ŋii, u wiwalimɛ di Yesu kɛŋ u tuɔbiinaa birimɛ. Ŋii nɛ Jɔɔŋ bula pu a bul, “Ŋ nɛ maga di ŋ fomi Wii-chuɔlɛ liiŋ, aŋ ka ŋ kɔ di mi nɛ foŋ Wii-chuɔlɛ liiŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ŋii nɛ Yesu bula pu a bul, “Ŋaa ŋii mi si bula piŋ. Ŋla nɛ la jaŋ wuo to a ŋaa wii-la kala Wia síi cho.” Ŋii nɛ Jɔɔŋ sɛi a fou Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jɔɔŋ si fo Yesu Wii-chuɔlɛ liiŋ dɛrɛ, u guu lii lii-la tuɔŋ ku lii di wia nyuŋ kpaa balia. U na Wia Diŋ-zɔŋ-la duu ku tuu a nagɛ kokomo a togiliu lɛ. ");
INSERT INTO sil_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka u nii nuu yiikoro wia nyuŋ a bul, “Mi Bii-chooluŋ nɛ ŋla, mi tuɔŋ tɔrɛ u nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wia Diŋ-zɔŋ-la si ku togili Yesu lɛ ŋii, u kɛnu kaa juu giri-bine tuɔŋ di Sitaani magisu. ");
INSERT INTO sil_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu fa si hɛ giri-bine tuɔŋ ŋii, u vɔɔ niiŋ titaŋiŋ ari wiihɛyɛ kala tapulaa mahiŋ balia, ŋii nɛ losuŋ kɛnu woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ŋii nɛ Sitaani kɔ u teeŋ a bula pu a bul, “Di ŋ nɛ ŋaa Wia Bie, ŋaa di tabiaa deeŋba birimɛ boroboro di ŋ dii.” ");
INSERT INTO sil_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ŋii nɛ Yesu bula pu a bul, “Ba ŋmuŋsɛ Wia teniŋ tuɔŋ a bul, ‘Kudiilee duŋduŋa dee bi nuhuobiine miisiŋ ka pa, ama Wia niiŋ wialiŋ u síi bul níi pi nuhuobiine miisiŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ŋii nɛ Sitaani kɛŋ Yesu a kaa mu Jerusalɛm a kaa mu jil Wia-dia nyu-gbaŋa ");
INSERT INTO sil_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aŋ bula pu a bul, “Di ŋ nɛ ŋaa Wia Bie, joŋ ŋ titia a yuo daha a tuu chigisi tiŋteeŋ. Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari ‘Wia jaŋ bul ŋ wiaa a pi u tiŋdaaraa di ba ku cheme kɛniŋ, di ŋ sí joŋ ŋ naaŋ ŋmoo tabiaa a keri.’ ” ");
INSERT INTO sil_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ŋii nɛ Yesu bula pu a bul, “Ba bira ŋmuŋsɛ Wia teniŋ sɛmɛ dɔŋɔ a bul, ‘U bi maga di ŋ mimagisɛ ŋ Tiina Wia.’ ” ");
INSERT INTO sil_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ŋii nɛ Sitaani bira kɛŋ Yesu a kaa jil peel-bal kubala nyuŋ a dagu dunia kuoruŋ fine ari u zɔmuŋ ");
INSERT INTO sil_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aŋ bula pu a bul, “Mi jaŋ joŋ kiaa deeŋba kala piŋ di ŋ nɛ jaŋ tuu kpirimi a chuɔlɛmi.” ");
INSERT INTO sil_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ŋii nɛ Yesu bula pu a bul, “Sitaani, mu dimɛ, Wia teniŋ tuɔŋ ba ŋmuŋsa di ba chuchuɔlɛ la Tiina Wia duŋduŋa nɛ a timaa pu.” ");
INSERT INTO sil_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ŋii nɛ Sitaani viiri aŋ ka Yesu. Ŋii nɛ Wia tiŋdaaraa ku tima pu. ");
INSERT INTO sil_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bua deeŋ lɛ ba kɛŋ Jɔɔŋ Wia lii-foori-la kaa mu tɔ dia. Yesu si nii ŋii, u sii Judiya lɛ a mu Galilii tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","U bira bi Nazarɛt lɛ hɔnɔ aŋ sii a mu hɔŋ taŋ kubala baa yirɛ Kapɛnam lɛ. Taŋ-la kpagɛ Galilii mugi-bal-la nɛ a hɛ Zɛbuluŋ ari Nafitali tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wiiŋ deeŋ ŋaa di wialiŋ Azaaya fa si bula ku ŋaa wutitiiba nɛ. ");
INSERT INTO sil_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. U fa bul wiaa a pi Zɛbuluŋ ari Nafitali doho niaa lɛ a chaasɛ mugi-baliŋ diiraa, Jɔɔdaŋ sɛmɛ, a hɛ Galilii tiŋteeŋ lɛ. Ba ŋaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","U bula piba a bul, “Nialiŋ si hɛ birimiŋ tuɔŋ, ba jaŋ na puluŋ-bal. Tiŋtee-la ma lɛ niaa si bi Wia chuɔlɛ, pulumuŋ jaŋ pɔsɛ piba.” ");
INSERT INTO sil_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesu si hɛ Kapɛnam lɛ, u suomi u tiŋtiŋŋaa a bul Wia wiaa pi niaa a bul, “Má birima lii ma haachɛba lɛ, bɛɛ wiaa, Wia kuorii-la kpaga nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu fa si joŋ Galilii mugi-bal-la niiŋ a vivɛŋ, u na naaŋbiiriŋ balia. Ba fa ŋaa cheŋfili-kpuuraa nɛ. Dɔŋɔ yiriŋ nɛ fa Saamɔŋ. U yiriŋ dɔŋɔ ma nɛ fa Piita. U naaŋbie ma yiriŋ nɛ Aŋduru. U naba di baa kpu cheŋfilee fuo-la lɛ ari ba joŋba. ");
INSERT INTO sil_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ŋii nɛ Yesu bula piba a bul, “Má kɔ mi teeŋ a to mi hariŋ. Mi jaŋ dagɛma ŋii ma si jaŋ kikɛsɛ niaa.” ");
INSERT INTO sil_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lima lima ba joŋ ba joŋba ta aŋ to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ŋii nɛ u bira vɛŋ a mu na naaŋbiiriŋ balia, ba yiraa nɛ Jeems ari Jɔɔŋ. Ba fa ŋaa Zɛbidii biiriŋ nɛ. U naba di ba di ba nyimma fa hɛ ba liiŋ daboro tuɔŋ nɛ. Ba kɛŋ ba joŋba ŋaa siri di ba yuo. ");
INSERT INTO sil_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ŋii nɛ Yesu yirɛba. Ba guu sii a leŋ ba liiŋ daboro ari ba nyimma aŋ to Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ŋii nɛ Yesu gɔllɛ Galilii tiŋteeŋ kala a didagɛ niaa ba Wii-chuɔlɛ diisiŋ lɛ a bubul Wia wu-zɔmɔ-la wiaa ari Wia kuorii-la wiaa a pi niaa aŋ pɛ vivaarɛ niaa nyanyal-yiriba kala. ");
INSERT INTO sil_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesu wiaa teeli Siiria tiŋteeŋ kala. Ŋii nɛ niaa kɛŋ ba nyanyal tiŋŋaa kala kɔ u teeŋ. Ba kɛŋ nyanyal-yiriba kala, jiŋ-bɔŋŋɔɔ fa kɛŋ dɔŋsuŋ, nialiŋ dɔŋsuŋ faa tel kuŋkuŋsuŋ, dɔŋsuŋ ma fa ŋaa gbɛrikɛɛ nɛ a kɔ. Yesu vaarɛba kala. ");
INSERT INTO sil_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ni-daŋ to Yesu hariŋ. Ba dɔŋsuŋ lii Galilii tiŋteeŋ ari ta-geŋtisiŋ fii tiŋteyee. Dɔŋsuŋ ma lii Jerusalɛm si hɛ Judiya tiŋteeŋ lɛ, dɔŋsuŋ ma lii Jɔɔdaŋ fuoŋ cholo sɛmɛ dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yesu si na di niaa yuga ŋii, u jil peeliŋ nyuŋ a hɔŋ dimɛ. U si hɔnɔ, u haritooroo kɔ u teeŋ. U suomo bul wiaa a didagɛba aa bul, ");
INSERT INTO sil_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wia jaŋ pɛ nialiŋ si bi Wia jiŋ woruŋ lɛ. Ba nɛ jaŋ dii Wia kuorii-la. ");
INSERT INTO sil_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wia jaŋ pɛ nialiŋ síi yel lɛ. U jaŋ leŋ di ba tuɔsaa piŋ di-bala. ");
INSERT INTO sil_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wia jaŋ pɛ nialiŋ si bi ba titia ka dagɛ. Ba jaŋ dii Wia kuorii-la tiŋtee-falii-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wia jaŋ pɛ nialiŋ si faasa chɛ tuɔ-pula a nagɛ losuŋ koo lii-nyuasuŋ si kɛŋ niaa ŋ chichɛ kudiilee koo liiŋ ŋii. Wia jaŋ ŋaa di ba kɛŋ tuɔ-pula. ");
INSERT INTO sil_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wia jaŋ pɛ nialiŋ síi fá niaa nennige lɛ. U ma jaŋ fába nennige. ");
INSERT INTO sil_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wia jaŋ pɛ nialiŋ si kɛŋ tuɔ-pula lɛ. Ba jaŋ na Wia. ");
INSERT INTO sil_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wia jaŋ pɛ naŋjejeeree lɛ. U jaŋ kɛŋba yirɛ u biiriŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wia jaŋ pɛ nialiŋ ba síi dɔgisu lɛ a tiŋ wutitii ari tuɔ-pula wiaa. Ba jaŋ hɛ Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Di niaa nɛ tuusɛma aŋ pɛ to ma naasiŋ dudɔgisɛma aŋ nyia wu-nyiariŋ pipima a tiŋ ma si ŋaa mi haritooroo wiaa, Wia ma jaŋ pɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Má leŋ di ma tuɔŋ tɔrɛ, di ma jujuɔsɛ, bɛɛ wiaa ma time jaŋ yugɛ Wia-jaŋ lɛ. Ba si to ma naasiŋ dudɔgisɛma ŋii, ŋii titia nɛ ba fa dɔgisɛ nialiŋ si laa sipaaŋ bubul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ma nagɛ yisiŋ nɛ nuu-kala teeŋ. Yisiŋ sima, ama di u nɛ sɛbisɛ, ŋ bira bi jaŋ wuo ŋaa duu siŋ. U ŋaa ku-tɔɔ nɛ. Ba joŋo ta niaa nunuɔsɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ma ma nagɛ chaaniŋ nɛ dunia niaa kala teeŋ. Taŋ kala si chiŋ peeliŋ nyuŋ, u bi wuo faa. ");
INSERT INTO sil_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nuu-kala síi chɛ pulumuŋ u dia lɛ, u bi jaŋ nyigɛ chaaniŋ bil u dia lɛ a kɛŋ gbaŋa a chu tɔ, koo u bi jaŋ joŋ chaaŋ-la hɛ godo bubuɔŋ maa. U yie joŋo bil kua nyuŋ nɛ, di nuu-kala si hɛ dia-la tuɔŋ nina pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ŋii titia nɛ ma ma maga di ma chaanɛ niaa teeŋ di ba wuo na wu-zɔmɔ-la ma síi ŋaa di ba wuo dɛnnɛ ma Nyimma si hɛ Wia-jaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ma biina mi kɔ di mi joŋ wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto ta nɛɛ? Koo ma biina mi kɔ di mi joŋ wialiŋ niaa si dagɛma Wia Diŋ-zɔŋ-la doluŋ lɛ ta nɛɛ? Ai, mi bi kɔ di mi joŋba ta, ama mi kɔ di mi dagɛ ba bubuɔŋ titia nɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wutitii nɛ mi bulaa pima, dunia ari wia nyuŋ si jaŋ hɛ dimɛ ŋii a dieni, wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, ba bi jaŋ keriba mua ma ta see di kuŋ-kala si hɛ dunia lɛ dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ŋii wiaa nii-la kala si keri wialiŋ mua ma ta aŋ dagɛ u dɔŋsuŋ tiŋŋaa di ba to ŋii, u tiina nɛ jaŋ ŋaa ni-bie Wia kuorii-la tuɔŋ. Nii-la ma kala síi to wialiŋ a dagɛ u dɔŋsuŋ tiŋŋaa di ba ma to ŋii titia, u tiina jaŋ yugɛ Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mi jaŋ bula pima, see di ma kɛŋ tuɔ-pula a kii Wia teniŋ kerichiba ari Farisii timma-la a ŋiŋaa wialiŋ Wia síi chɛ, di ŋii dee, ma bi jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ŋii nɛ Yesu bira dagɛ u haritooroo a bul, “Ma nia ari faafaa kala nɛ Moosis bula pi niaa a bul di ba sí niaa kpu. U fa bula di nii-la kala nɛ kpu nuu, ba jaŋ kɛnu kaa mu dii u sariya. ");
INSERT INTO sil_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama lɛɛlɛ mi jaŋ bula pima, nii-la kala si na baaniŋ u naaŋbie nyuŋ, ba jaŋ kɛnu kaa ku dii u sariya. Nii-la ma kala si yirɛ u naaŋbie a bul di u ŋaa ni-pɛipɛi, ba jaŋ kɛnu kaa mu nialiŋ si hilime vuurɛ wiaa teeŋ. Nii-la ma kala si yirɛ u naaŋbie a bul di u ŋaa ni-tɔɔ nɛ, u tiina jaŋ mu juu Wia nyiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Di ŋ nɛ kɛŋ puna mu Wia koruŋ di ŋ kpu a nyiga pu aŋ liise mu yi ari ŋ naaŋbie tuɔŋ cheye ŋ nyuŋ, ");
INSERT INTO sil_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","leŋ puna-la koru-la nyuŋ aŋ miira mu ma di ŋ naaŋbie siŋ, ka di ŋ-na miira mu di ba kpu puna-la a pi Wia. ");
INSERT INTO sil_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Di nuu nɛ samiŋ a kɛniŋ kaa mu sariya didiiliŋ, ŋ ŋaa kukeri a bul wii-la wasɛ woŋbiiŋ lɛ lima lima aŋ-na mu. Di ŋii dee, u jaŋ kɛniŋ kaa hɛ sariya didiire nisiŋ lɛ. Sariya didiire ma jaŋ kɛniŋ kaa hɛ porisiba nisiŋ lɛ. Ba nɛ jaŋ kɛniŋ mu tɔ dia. ");
INSERT INTO sil_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Di ba kɛniŋ mu tɔ dia, ŋ bi jaŋ wuo lii see ŋ ti̱ŋ chiŋ-la kala ba si kere piŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ma nia di ba dagɛma di ma sí niaa haalaa chɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama mi jaŋ bula pima, nuu-kala si na haala a cho duu kɛnu piŋ, u tiina juu Wia haachɛ lɛ nɛ u tuɔŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Di ŋ na-diiŋ siiŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, liisa ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari sii-togo, u nɛ kpia ba si joŋuŋ yuo hɛ Wia nyiniŋ lɛ ari siaa balia. ");
INSERT INTO sil_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Di ŋ na-diiŋ nisiŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, kere ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari na-kuuŋ, u nɛ kpia ŋ si kɛŋ ŋ yaraa kala aŋ juu Wia nyiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ba bira dagɛma a bul, ‘Di nuu níi chɛ duu via u haala, u maga duu ŋmuŋsɛ teniŋ pi haal-la ari u jaŋ viau.’ ");
INSERT INTO sil_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama lɛɛlɛ mi jaŋ bula pima a bul, baal-na kala si via u haala, u ŋaa haal-la juu Wia haachɛ lɛ nɛ, see di haal-la ka ŋaa ha-chɔruŋ wu-ŋaalaa, ka u bala-na viau. Di haal-la nɛ bira mu jaa baal dɔŋ, baal-la si jaau, u ma juu Wia haachɛ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ma bira nia di ba bula pi la naabalimaba a bul, ‘Di ŋ nɛ ŋmiɛsa ari ŋ jaŋ ŋaa wii pi Wia, sí leŋe di wii-la ta, ama ŋaa wii-la ŋ si si ŋ jaŋ ŋaa a pi Wia.’ ");
INSERT INTO sil_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama lɛɛlɛ mi jaŋ bula pima, di ma nɛ chɛ di ma ŋaa wii, ma sí ŋmiɛsu. Ma sí Wia ŋmiɛsu, bɛɛ wiaa u níi beŋ dunia kuŋ-kala. ");
INSERT INTO sil_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Koo ma sí tiŋteeŋ ma ŋmiɛsu, bɛɛ wiaa Wia naasiŋ di-wiesiŋ nɛ ŋii. Koo ma sí Jerusalɛm ma ŋmiɛsu, bɛɛ wiaa kuori-baliŋ jaŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma paala sí ma nyuŋ ma ŋmiɛsu, bɛɛ wiaa ma paala bi jaŋ wuo ŋaa di ma nyu-punaa biri koo ba pullɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ama ma-na yaa bul, ‘Oo’ koo ‘Ai’ duŋduŋa a lii ŋii hariŋ. Di ŋ nɛ sɛyɛ, leŋ u sɛnɛ ŋaa wutitii. Di ŋ bira bi sɛyɛ maa, leŋ duu ŋaa wutitii. Di ŋii duŋduŋa dee, u lii Sitaani nɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ma nia ari Moosis fa bula a bul, ‘Di nuu nɛ tɔɔ ŋ siiŋ purɛ, ŋ ma tɔɔ u siiŋ purɛ, di nuu nɛ ŋmoo ŋ nyiliŋ churi, ŋ ma ŋmoo u nyiliŋ churi.’ ");
INSERT INTO sil_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama lɛɛlɛ mi jaŋ bula pima a bul, di nuu nɛ ŋaa wu-bɔŋ ŋ lɛ, sí wu-bɔŋ-la joŋo ti̱mu. Di nuu nɛ fallɛ ŋ na-diiŋ chaŋkpaŋiŋ lɛ, kɛŋ ŋ na-gua chaŋkpaŋiŋ ma kaa birima pu duu fallɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Di nuu nɛ samiŋ kaa juu kɔɔti duu laa ŋ gɛri-baliŋ, wuri ŋ gɛri-bie ma pɛ pu. ");
INSERT INTO sil_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Di nuu nɛ fuguŋ di ma duu vɛŋ meel-daa, leŋ di ma vɛŋ meel-daasiŋ balia. ");
INSERT INTO sil_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Di ŋ nɛ kɛŋ kuŋ, di nuu piɛsɛ chichɛ, joŋo pu. Di nuu nɛ kɔ ŋ teeŋ a chichɛ kuŋ duu chiŋ, di ŋ nɛ kɛnɛ, joŋo chimu. ");
INSERT INTO sil_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ma nia ari Moosis fa si di ma cho ma dɔŋsuŋ tiŋŋaa aŋ bɛrɛ ma diŋdɔŋŋɔɔ. ");
INSERT INTO sil_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama lɛɛlɛ mi jaŋ bula pima, má cho ma diŋdɔŋŋɔɔ a chuɔlɛ Wia pipi nialiŋ si to naasiŋ dɔgisɛma. ");
INSERT INTO sil_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Di ma nɛ ŋaa ŋii, ma jaŋ wuo ŋaa ma Nyimma Wia si hɛ Wia-jaŋ biiriŋ. U leŋe Wia pɔsɛ hihɛ ni-bɔŋŋɔɔ ari ni-zɔŋŋɔɔ kala lɛ nɛ a leŋ duonuŋ nii pipi ni-zɔŋŋɔɔ ari ni-bɔŋŋɔɔ kala. ");
INSERT INTO sil_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Di ŋ nɛ cho nialiŋ si choŋ duŋduŋa, ŋ bi jaŋ kɛŋ time Wia-jaŋ lɛ. Laŋpoo lilaaraa ma paala ŋiŋaa ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Di ŋ nɛ tuɔsɛ ŋ naaŋbiiriŋ duŋduŋa chuchuɔlɛ, ŋ bi woruŋ ka ŋaa. Nialiŋ si bi Wia jiŋ ma paala ŋiŋaa ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","U maga di ma ŋaa tuɔ-pul timma nɛ a sí kuŋ-kala chɛ ka, ari ma Nyimma si hɛ Wia-jaŋ si ŋaa Tuɔ-pul Tiina ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu bira dagɛ u haritooroo a bul, “Di ŋ níi chɛ di ŋ ŋaa wu-zɔŋ a pɛ ŋ dɔŋɔ tiina lɛ, sí wu-zɔŋ-la joŋo ŋaau lɛ niaa tuɔŋ. Di ŋ nɛ ŋaa ŋii, ŋ bi time kɛnɛ ŋ Nyimma si hɛ Wia-jaŋ lɛ teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Di ŋ nɛ joŋ kuŋ pɛ nuu lɛ, sí leŋe di niaa jiŋ. Nialiŋ síi dagɛ ba titia yie ŋaa ŋii Wii-chuɔlɛ diisiŋ lɛ ari woŋbii-porunuŋ lɛ. Ba ŋaa ŋii di niaa bɛsɛba lɛ nɛ. Wutitii nɛ mi bulaa pima, ba laa ba time nɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Di ŋ níi joŋ kuŋ a pɛ nuu lɛ, sí leŋe di ŋ naŋdɔŋ-fiɛmiŋ paala jiŋ. ");
INSERT INTO sil_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Leŋ duu ŋaa wu-faali. Di ŋ nɛ ŋaa ŋii, ŋ Nyimma Wia jaŋ ti̱miŋ. U níi na wii-la ŋ si ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ŋii nɛ Yesu bira bul, “Di ma níi chuɔlɛ Wia, ma sí nialiŋ síi dagɛ ba titia nagu. Ba yie cho di ba chiŋ Wii-chuɔlɛ diisiŋ lɛ ari woŋbiee sɛmɛ a chuchuɔlɛ Wia di nuu-kala naba. Wutitii nɛ mi bulaa pima, ba paala laa ba time nɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama di ma níi chɛ di ma chuɔlɛ Wia, má juu ma diisiŋ a kɛŋ borusuŋ tɔ aŋ sul ma Nyimma-la ma si buu na. U-na na wii-la ma si faa ŋiŋaa nɛ, u jaŋ ti̱ŋma. ");
INSERT INTO sil_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Di ma níi chuɔlɛ Wia, ma sí faasa bul wiaa yugɛ, ari nialiŋ si bi Wia jiŋ síi ŋaa ŋii. Ba biina ari ba síi chuɔlɛ Wia deeŋ deeŋ ŋii, Wia jaŋ nii. ");
INSERT INTO sil_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma síba nagu. Ma Nyimma paala jiŋ kialiŋ ma síi chɛ nɛ, ka ma-na pipiɛsu ŋii. ");
INSERT INTO sil_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ŋla nɛ u maga di ma chuɔlɛ Wia: Má bul, ‘La Nyimma Wia si hɛ Wia-jaŋ, leŋ di ŋ yiriŋ yirɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Leŋ di ŋ kuorii-la kɔ. Leŋ di niaa sɛi ŋ niiŋ tiŋteeŋ deeŋ lɛ ari ba si sɛi Wia-jaŋ lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pila la jiniŋ niiŋ kudiiliŋ ");
INSERT INTO sil_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","aŋ joŋ la haachɛba chɛla, ari la ma si joŋ la dɔŋsuŋ tiŋŋaa haachɛba chɛba ŋii. ");
INSERT INTO sil_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Liisɛla wii-la si jaŋ kɛŋla hɛ haachɛ tuɔŋ lɛ, liisɛla wu-bɔŋŋɔɔ lɛ, bɛɛ wiaa kuorii-la ari doluŋ ari yiri-la ŋaa ŋ kiaa nɛ, lɛɛlɛ a kaa mu deeŋ deeŋ. Ami.’ ");
INSERT INTO sil_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Di ma dɔŋsuŋ tiŋŋaa nɛ ŋaa wiaa cheima lɛ aŋ ka ma joŋo chɛba, ma Nyimma Wia si hɛ Wia-jaŋ lɛ ma jaŋ joŋ wialiŋ ma si ŋaa chei a chɛma. ");
INSERT INTO sil_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama di ma nɛ bi wialiŋ ma dɔŋsuŋ tiŋŋaa si ŋaa cheima lɛ joŋo chɛba, ma Nyimma Wia ma bi jaŋ joŋ wialiŋ ma si ŋaa chei a chɛma.” ");
INSERT INTO sil_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ŋii nɛ Yesu si, “Di ma nɛ vɔɔ niiŋ, ma sí siaa kaa chei a nagɛ nialiŋ síi dagɛ ba titia. Ba yie gugɔllɛ ari losuŋ a kɛŋ siaa kala chei di nuu-kala na a jiŋ ari baa vɔɔ niiŋ nɛ. Wutitii nɛ, mi bulaa pima, ba-na paala laa ba time kala dɛrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Di ma nɛ vɔɔ niiŋ, má sɔŋ ma siaa a chaasɛ ma nyuŋ, ");
INSERT INTO sil_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","di niaa sí wuo jiŋ ari maa vɔɔ niiŋ nɛ see ma Nyimma Wia duŋduŋa, Nii-la ma si bi na. U-na na wii-la ma si faa ŋaa nɛ, u jaŋ ti̱ŋma.” ");
INSERT INTO sil_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu bira bula, “Ma sí kiaa chɛ bil ma titia lɛ dunia deeŋ lɛ. Dunia lɛ pugumaa jaŋ dii dɔŋsuŋ aŋ ka dɔŋsuŋ ma su, gaaraa ma jaŋ juu gaa dɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama má chɛ kiaa bil ma titia lɛ Wia-jaŋ lɛ, lee-la pugumaa si bi jaŋ wuo dii. Ba bi jaŋ su maa, gaaraa ma bi jaŋ wuo gaaba. ");
INSERT INTO sil_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma tuɔbiinaa yie hɛ lee-la ma kiaa si hɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ŋ siaa nɛ ŋaa ŋ yaraa pulumuŋ. Di ŋ siaa nɛ zɔmɔ, ŋ yaraa kala kɛŋ pulumuŋ nɛ, ");
INSERT INTO sil_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ama di ŋ siaa bi zɔŋ, ŋ yaraa kala hɛ birimiŋ tuɔŋ nɛ. Di puluŋ-la nɛ kɔ birimɛ birimiŋ, birimiŋ lim lɛ nɛ ŋ hɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nuu-kala bi jaŋ wuo tiŋ tiŋtiŋŋaa a pi kuhiasiŋ balia. U jaŋ cho dɔŋɔ aŋ bɛrɛ dɔŋɔ. U jaŋ tuto dɔŋɔ niiŋ wiaa woruŋ aŋ via dɔŋɔ niiŋ wiaa. Ŋ ma saa bi jaŋ wuo to Wia aŋ bira cho dunia kiaa maa. ");
INSERT INTO sil_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mi bulaa pima, ma sí ma titia walimu a tigɛ kudiile-la ma si jaŋ dii a kɛŋ doluŋ koo kialiŋ ma si jaŋ nyunyua. Ma sí ma titia ma walimu a tigɛ gɛnni-la lɛ ma síi chɛ di ma lilaalɛ. Ma miisiŋ nɛ kii kudiilee, ma yaraa ma kii gɛnniŋ. ");
INSERT INTO sil_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Má bee na diibiisiŋ si hɛ wia nyuŋ a fifi̱l. Ba bi pɛrɛ, ba bi kiaa kuŋ, ba ma bi kiaa ka tuɔlɛ virisiŋ lɛ, ka la Nyimma Wia si hɛ Wia-jaŋ lɛ pipiba kudiilee. Ma nɛ paala kɛŋ liiba a kii diibiisiŋ. ");
INSERT INTO sil_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Di ma níi walimɛ ma titia kiaa deeŋba wiaa, bua-la lɛ ma miisiŋ si jaŋ dɛrɛ, u bi jaŋ kɛŋ tapul-bala ma pɛ pima. ");
INSERT INTO sil_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Di ma nɛ saa bi tapul-bala ma wuo kaa pɛ ma miisiŋ lɛ tapulii-la ma si jaŋ suu, bɛɛ nɛ saa tii kiaa deeŋba wiaa wiwalimɛma? Má bee na tii-fiilaa si hɛ giriŋ lɛ. Ba bi tiŋ, ba bi gɛnniŋ ma yɛrɛ a lilaalɛ, ");
INSERT INTO sil_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ama ba zɔmɔ nɛ woruŋ. Kuoru kubala nɛ fa hɛ dimɛ. Baa yirɛ Solomɔŋ. U fa si hɛ u miisiŋ lɛ, u kɛŋ kiaa nɛ woruŋ. Ama u gɛnniŋ fa bi zɔmɔ magɛ tii-fiilaa deeŋba. ");
INSERT INTO sil_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wia nɛ yie ŋaa yaŋ nyu a waa a zɔŋ, ka u bi dieni aŋ hihil. Di u nɛ hila, ba yie nyigɛ nyiniŋ. Di Wia nɛ wuo ŋaa yaŋ zɔŋ ŋii, bɛɛ nɛ tii ma biinɛ ari u bi jaŋ wuo pima kudiilee ari gɛnniŋ? Ma yarida bi yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ma saa sí leŋe di ma walimɛ ma titia kudiile-la ma si jaŋ dii ari ku-la ma si jaŋ nyua ari ku-la ma si jaŋ laalɛ wiaa. ");
INSERT INTO sil_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nialiŋ si bi Wia jiŋ dunia deeŋ lɛ, ba nɛ yie walima chichɛ kiaa deeŋba. Ma Nyimma si hɛ Wia-jaŋ lɛ jima ari maa chɛ kiaa deeŋba kala nɛ. ");
INSERT INTO sil_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ŋii wiaa má laa sipaaŋ a chɛ kialiŋ si hɛ Wia kuorii-la tuɔŋ a chɛ ŋii ma si jaŋ ŋaa a kɛŋ tuɔ-pula u sipaaŋ. U jaŋ joŋ kuŋ-kala si ka a pɛ pima. ");
INSERT INTO sil_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ma saa sí ma titia walimu a tiŋ chiemiŋ wiaa. Chɛɛ kala kɛŋ u wiwalimia nɛ. Ma sí wii dɔŋ kala kaa pɛ chɛɛ kala wiwalimii lɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma sí ma dɔŋsuŋ tiŋŋaa wiaa laa jiŋ. Di ma nɛ ŋaa ŋii, Wia ma bi jaŋ joŋ cheeriŋ pima. ");
INSERT INTO sil_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wia jaŋ dii ma sariya ari ŋii titia ma síi ŋaa ma dɔŋsuŋ tiŋŋaa lɛ. Ŋii titia ma si joŋo to ma dɔŋsuŋ tiŋŋaa lɛ, ŋii titia nɛ Wia ma jaŋ joŋo toma lɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ɛɛ nɛ ŋ jaŋ wuo na daa-bie si tel ŋ naaŋbie siiŋ lɛ aŋ bi daa-bal-la si tel ŋ titia siiŋ lɛ ka na? ");
INSERT INTO sil_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ŋ bi jaŋ wuo bula pi ŋ naaŋbie a bul duu leŋ di ŋ liisɛ daa-bie-la si hɛ u siiŋ lɛ, aŋ ka daa-bal-la si hɛ ŋ titia siiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ŋ-na kaŋfugi tiina, laa sipaaŋ liisɛ daa-bal-la si hɛ ŋ titia siiŋ lɛ, ka ŋ siaa wuo na, ŋii nɛ ŋ ma jaŋ wuo pɛ ŋ naaŋbie lɛ a liisɛ daa-bie-la si hɛ u siiŋ lɛ a pu. ");
INSERT INTO sil_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ma sí ku-zɔŋŋɔɔ joŋo pi vahiŋ, ma ma sí ma ku-zɔŋŋɔɔ joŋo bil toonuŋ sipaaŋ. Di ma ŋaa ŋii, ba jaŋ nuɔsɛ ari ba naasiŋ aŋ toma hariŋ a diŋma. ");
INSERT INTO sil_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sul kiaa, ŋ jaŋ laa. ");
INSERT INTO sil_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chɛ kiaa, ŋ jaŋ na. Du̱ boro, ba jaŋ kaa suro piŋ. Nii-la kala si sul kiaa Wia teeŋ, u yie laa nɛ. Nii-la síi chɛ kiaa, u yie na nɛ. Nii-la ma si du̱ boro, ba yie kaa suro pu nɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Di ŋ bie nɛ piɛsɛ a chichɛ boroboro, ŋ jaŋ sii a joŋ tabiiŋ puu? ");
INSERT INTO sil_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Koo duu ka chɛ cheŋfiliŋ, ŋ jaŋ joŋ dimiŋ a puu? Ai, ma bi jaŋ ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Di la nɛ bɔmɔ aŋ joŋ ku-zɔŋŋɔɔ aa pi la biiriŋ, ɛɛ nɛ la Nyimma si hɛ Wia-jaŋ a kɛŋ wu-zɔŋŋɔɔ bi jaŋ joŋ ku-zɔŋŋɔɔ a pi nialaa si sula chichɛɛ? ");
INSERT INTO sil_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wii-la ŋ si cho di niaa joŋo ŋiŋaaŋ lɛ, ŋ ma ŋaa kukeri a joŋ ŋii titia a ŋiŋaaba lɛ. Wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto ari nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, wu-nyuŋ nɛ wiiŋ deeŋ.” ");
INSERT INTO sil_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesu bira bul, “Má to boi-bie a mu Wia-jaŋ. Boi-la ba si to aa mu Wia nyiniŋ, u jalia nɛ, woŋbii-la ma vɛniŋ bi hɛi. Niaa yuga nɛ a tuto woŋbii-la. ");
INSERT INTO sil_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama Wia-jaŋ boiŋniiŋ muuro nɛ, woŋbii-la ma síi mu lee-la, u vɛniŋ hɛyɛ. Niaa baŋmɛnɛ duŋduŋ nɛ yie wuo na woŋbii-la a to. ");
INSERT INTO sil_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Má pɔ ma titia lɛ ari nialiŋ si nyia wiaa a bul di ba ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Ba jaŋ kɔ ma teeŋ ari ni-zɔmɔ ba siaa lɛ, ama ba tuɔŋ lɛ, ba ŋaa ni-bɔmɔ nɛ a nagɛ guŋgurusuŋ si yie kɛsɛ kiaa chichaŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma jaŋ to ba wu-ŋaalaa lɛ nɛ a jiŋba. Sɔjaamiŋ bi chichuɛŋ ka nɛŋ, sɔguŋ-gbeŋe ma bi tutogo naŋbilaa ka nɛŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tia-la kala si kɛŋ yarifiɛlaa, uu nɛŋ nɛŋ-zɔŋŋɔɔ nɛ, ama tia-la si bi yarifiɛlaa kɛnɛ níi nɛŋ nɛŋ-lɔrunuŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tia-la si kɛŋ yarifiɛlaa bi nɛŋ-lɔrunuŋ wuo nɛŋ, tia-la si bi yarifiɛlaa kɛnɛ ma bi nɛŋ-zɔŋŋɔɔ wuo nɛŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tia-la kala si bi nɛŋ-zɔŋŋɔɔ ka nɛŋ, ba jaŋ kere ta a joŋo yuo hɛ nyiniŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ŋii lɛ nɛ ma jaŋ to a jiŋ nialiŋ síi nyia wiaa a bul di ba nɛ ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nuu-kala si yirɛmi, ‘mi Tiina, mi Tiina,’ dee bi jaŋ juu Wia kuorii-la tuɔŋ, see nialiŋ síi ŋaa wialiŋ mi Nyimma si hɛ Wia-jaŋ si daga. ");
INSERT INTO sil_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Di Wia sariya chɛ-diiliŋ nɛ yie, niaa jaŋ yugɛ a bul, ‘La Tiina, la Tiina, la bul Wia wiaa a pi niaa ŋ doluŋ lɛ aŋ kiri jiŋsiŋ niaa lɛ ŋ doluŋ lɛ, la ŋaa wu-magilaa ma a yugɛ ŋ doluŋ lɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ama mi jaŋ bula piba a bul, ‘Mi paala bima jiŋ. Ma wu-bɔŋ ŋiŋaaraa, má surisa lii mi teeŋ!’ ” ");
INSERT INTO sil_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu bira si, “Nii-la kala si kɔ mi teeŋ a jegile nii mi niiŋ wiaa deeŋba mi si bula pima a tutoba, mi jaŋ dagɛma ŋii u si naga. U nagɛ wu-jinna si saa u dia nɛ. U saau kpaginyiliŋ nyuŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ŋii nɛ duonuŋ nii. Liiŋ su̱ leriŋ kala, peliŋ ma lu a ŋmoo lii-la a yagɛ dia-la, ka dia-la bi tele, bɛɛ wiaa ba saau woruŋ nɛ kpaginyiliŋ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama nii-la ma kala si jegile nii mi niiŋ wiaa deeŋba mi si bula pima aŋ biba to, u nagɛ ni-yaariŋ si saa u dia nɛ. U saau hagili-buŋbugulo tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ŋii nɛ duonuŋ nii. Liiŋ su̱ leriŋ kala, peliŋ ma lu a ŋmoo lii-la yagɛ dia-la, dia-la kala tel wuru.” ");
INSERT INTO sil_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu si bul wiaa deeŋba dɛrɛ, ba ŋaa ni-daŋ-la kala wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","U biba daga a nagɛ ba Wia teniŋ kerichiba síi dagɛba ŋii. U si dagɛba ŋii, u kɛŋ wii-la doluŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu si bul wiaa deeŋba dɛrɛ, u lii peeliŋ nyuŋ a ku tuu. Ŋii nɛ ni-daŋ tuto u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Gbege kubala ma kɔ u teeŋ a tuu kpirimi u sipaaŋ aŋ sul Yesu a bul, “Kuhiaŋ, di ŋ nɛ cho, ŋ jaŋ wuo ŋaa di mi duori.” ");
INSERT INTO sil_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ŋii nɛ Yesu liisɛ u nisiŋ a digu aŋ bul, “Mi cho nɛ. Duori.” Ŋii nɛ yawiil-la guu leŋ baal-la. ");
INSERT INTO sil_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ŋii nɛ Yesu bula pu a bul, “Sí wiiŋ deeŋ bula pi nuu-kala. Ama kɛŋ ŋ titia mu dagɛ nii-la si kpu pusuŋ pipi Wia duu kpu pusuŋ a pi Wia a piŋ ari Moosis fa si dagɛma ŋii. Di ŋ nɛ ŋaa ŋii, niaa jaŋ na ari ŋ bira bi disinniŋ kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ŋii nɛ Yesu sii mu Kapɛnam di Rom laali-yuoroo kuhiaŋ ku chemu a sulu duu pɛu lɛ a bul, ");
INSERT INTO sil_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mi kuhiaŋ, mi dia tiŋtinnu níi wiilu a piŋ dia lɛ. U bi wuo vɛŋ a nina hɛɛŋ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ŋii nɛ Yesu bula pu a bul, “Mi jaŋ ku ŋaa duu duori.” ");
INSERT INTO sil_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ama baal-la bula pu a bul, “Mi Tiina, mi bi maga di ŋ ku juu mi dia. Ŋ-na yaa suri ŋ niiŋ duŋduŋa a bul di mi tiŋtinni-la duori, u jaŋ duori. ");
INSERT INTO sil_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mi ma paala to mi laali-yuoroo nihiasiŋ niiŋ nɛ. Laali-yuoroo dɔŋsuŋ ma tuto mi ma niiŋ. Di mi nɛ bul di nia deeŋ mu daha, u yie mu nɛ. Di mi ma nɛ si di nia deeŋ kɔ daha, u yie kɔ nɛ. Di mi nɛ bula pi mi yomo duu ŋaa deeŋ, u yie ŋaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu si nii wiaa deeŋba, u ŋaau wu-kpuŋkpere. Ŋii nɛ u bula pi ni-daŋ-la fa síi to u hariŋ a bul, “Wutitii nɛ mi bulaa pima, mi ha bi yarida deeŋ doho na Iziral tiŋteeŋ niaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi bulaa pima, niaa jaŋ yugɛ a lii taŋ-bubuɔŋ ari taŋ-sɛmɛ kala a kɔ a hɔŋ Wia kuorii-la tuɔŋ di ba di Abiraham ari Aizik ari Jekɔb dii kudiilee, ");
INSERT INTO sil_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ama nialiŋ fa si maga di ba hɛ Wia kuorii-la lɛ aŋ bi jua, ba jaŋ joŋba yuo ta jeeŋ hariŋ di ba hɛ birimiŋ tuɔŋ a pina yiyel aŋ didiŋ ba nyilaa.” ");
INSERT INTO sil_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ŋii nɛ Yesu bula pi laali-yuori-hiaŋ-la a bul, “Mu dia, ŋ si ŋaa yarida ari wii-la, u jaŋ ŋaa.” Bua-la titia lɛ laali-yuori-hiaŋ-la tiŋtinni-la duori. ");
INSERT INTO sil_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ŋii nɛ Yesu mu Piita dia. U si jua, u na di u hiili-haala pina a wiilɛ, u yaraa kala liŋ. ");
INSERT INTO sil_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ŋii nɛ Yesu digi u nisiŋ lɛ. U yaraa fa si lima ŋii, u fiɛlɛ. U sii ŋaa kudiilee piba ba dii. ");
INSERT INTO sil_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Didaaniŋ si yie, ba kɛŋ niaa yugɛ a kaa kɔ Yesu teeŋ. Jiŋsiŋ nɛ kɛŋ niaa dɔŋsuŋ. Yesu bul wiaa a kiri jiŋ-bɔmɔ-la ta aŋ vaarɛ nialiŋ kala fa síi wiilu. ");
INSERT INTO sil_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U ŋaa wiiŋ deeŋ di wialiŋ Azaaya fa si bula ku ŋaa wutitii. Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. U fa bula a bul, “U nɛ laa la nyanyalaa kala a chuŋ a kaa mu ta.” ");
INSERT INTO sil_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu si na di ni-daŋ-la ku gollu, u ŋaa ba di u haritooroo chol fuoŋ cholo dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ŋii nɛ Wia teniŋ kerichi kubala kɔ u teeŋ a bula pu a bul, “Mi kuhiaŋ, mi ŋaa siri di mi to ŋ hariŋ a mu lee-na kala ŋ síi mu nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ŋii nɛ Yesu bula pu a bul, “Jolluŋ kɛŋ buasuŋ nɛ a jujuu, diibiisiŋ ma kɛŋ dɛlliŋ a jujuu, ama mi-na Nuhuobiine Bie bi di-piniŋ kɛnɛ di mi pina wiesi.” ");
INSERT INTO sil_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Niaa dɔŋsuŋ ma fa síi to Yesu hariŋ, ba tuɔŋ kubala ma bula pu a bul, “Kuhiaŋ, leŋ mi laa sipaaŋ mu hugi mi nyimma.” ");
INSERT INTO sil_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ŋii nɛ Yesu bula pu a bul, “To mi hariŋ aŋ leŋ di suunuŋ huhugi ba titia suunuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ŋii nɛ Yesu juu liiŋ daboro. U haritooroo to u hariŋ a ma mu juu, ");
INSERT INTO sil_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","di pel-duo kubala suomo a lulu ŋii a ku ŋmoo liiŋ. Ŋii nɛ lii-peliŋ tɔ liiŋ daboro-la. Liiŋ daboro-la faa chɛ duu tuu liiŋ bubuɔŋ. Ama Yesu fa piŋ doŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ŋii nɛ u haritooroo mu chisu a bula pu a bul, “La Tiina, laala ta, laa chɛ di la suu nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ŋii nɛ Yesu piɛsɛba a bul, “Bɛɛ nɛ tii fawulluŋ kɛŋma? Ma yarida bi yugɛ.” Ŋii nɛ u sii kpia pel-la lɛ aŋ bula pi fuo-la maa duu fiɛla piŋ, leriŋ kala guu ŋaa fuii. ");
INSERT INTO sil_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","U ŋaa nuu-kala wu-kpuŋkpere. Ŋii nɛ ba pipiɛsɛ dɔŋɔ, “Ni-bɛɛ nɛ ŋla? Peliŋ ari lii-peliŋ kala tuto u niiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ŋii nɛ Yesu sii mu tiŋtee kubala baa yirɛ Gadara. Lee-la fa hɛ fuoŋ cholo nɛ. Di baalaa balia lii vaamaa tuɔŋ a ku chemu. Jiŋsiŋ nɛ fa kɛŋ baala-la. Ba nyinyaasɛ. Nuu-kala fa bi woŋbii-la wuo to. ");
INSERT INTO sil_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba si na Yesu, ba guu ŋmoo niiŋ a piɛsu, “Bɛɛ nɛ ŋ chichɛ di ŋ ŋaala lɛ Wia Bii? Ŋ kɔ di ŋ dɔgisɛla nɛɛ, ka bua-la ha bi yiee?” ");
INSERT INTO sil_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Di toonuŋ ma hɛ lee-la a yugɛ a gɔllɔ didii kiaa. ");
INSERT INTO sil_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ŋii nɛ jiŋsi-la sul Yesu a bul, “Di ŋ níi chɛ di ŋ kirila di la lii, leŋ di la mu juu toonuŋ deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ŋii nɛ Yesu bula piba a bul, “Má lii.” Ŋii nɛ ba lii baala-la lɛ a mu juu toonu-la. Ŋii nɛ toonu-la kala sii fá a lii peel-la nyuŋ a tuu tel muga tuɔŋ a suu. ");
INSERT INTO sil_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Too-daara-la fá a juu taŋ-la tuɔŋ a bul wii-la kala si ŋaa a pi niaa ari wii-la si ŋaa baala-la fa si kɛŋ jiŋsiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ŋii nɛ nuu-kala si hɛ taŋ-la lɛ lii a mu duu na Yesu. Ba si mu nau, ba sulu duu lii ba tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ŋii nɛ Yesu sii juu liiŋ daboro a miira chol a mu u jaŋ, ");
INSERT INTO sil_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","di niaa chuŋ gbɛriku kubala si piŋ u bɔsɔ nyuŋ a kaa kɔ Yesu teeŋ. Yesu si na ari ba ŋaau yarida woruŋ, u bula pi gbɛriku-la a bul, “Sí fawulluŋ fá mi bii, mi joŋ ŋ haachɛba chɛŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋii nɛ Wia teniŋ kerichiba-la dɔŋsuŋ pipiɛsɛ dɔŋɔ a bul, “Baala deeŋ tuusɛ Wia joŋŋoo nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ama Yesu jiŋ wii-la ba fa síi biinu a piɛsɛba a bul, “Bɛɛ nɛ tii maa biinɛ wu-bɔmuŋ deeŋ? ");
INSERT INTO sil_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mi si jaŋ bul di mi joŋ u haachɛba chɛu nɛ koo mi si jaŋ bul duu sii a chuoli u bɔsɔ a viiri, ba tuɔŋ kubɛɛ nɛ ŋaa mɔli? ");
INSERT INTO sil_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mi jaŋ dagɛma ari mi-na Nuhuobiine Bie kɛŋ doluŋ dunia lɛ di mi wuo joŋ haachɛba chɛ niaa.” Ŋii nɛ u bula pi gbɛriku-la a bul, “Sii a joŋ ŋ bɔsɔ a mu dia.” ");
INSERT INTO sil_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Baal-la guu duori a sii a mu dia. ");
INSERT INTO sil_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ni-daŋ-la si na ŋii, fawulluŋ kɛŋba. Ba dɛnnɛ Wia ari u si wuo joŋ doluŋ ŋii a pi nuhuobiinee. ");
INSERT INTO sil_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu si lii lee-la aa vɛŋ, u na laŋpoo lilaaru kubala baa yirɛ Matiu. U fa hɔŋ u tiŋtinni-dia lɛ nɛ. Ŋii nɛ Yesu yiru a bula pu duu sii to u hariŋ. U sii a to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ŋii nɛ Yesu juu Matiu dia, ba di u haritooroo kala, a hɔnɔ didii kiaa. Laŋpoo lilaaraa yuga ari haachɛ diiree ma a kɔ, ba kala didii kialiŋ. ");
INSERT INTO sil_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisii tiŋŋaa dɔŋsuŋ naba a piɛsɛ Yesu haritooroo a bul, “Bɛɛ nɛ tii ma kuhiaŋ ari laŋpoo lilaaraa ari haachɛ diiree kala hɔnɔ didii kiaa?” ");
INSERT INTO sil_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nii wii-la ba si bula a miira bula piba a bul, “Nialiŋ si kɛŋ yarifiɛlaa, ba bi daalusuŋ ŋiŋaara ka chɛ, see nialiŋ síi wiilu. ");
INSERT INTO sil_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Má mu a beŋ Wia teniŋ tuɔŋ a na wii-la ba si ŋmuŋsa bubuɔŋ. Ba ŋmuŋsa, ‘Wia si, mi cho di ma fifá niaa nennige nɛ a kii ma si kpu pusuŋ pipimi.’ Mi kɔ di mi yirɛ haachɛ diiree nɛ di ba leŋ ba haachɛba. Nialiŋ si kɛŋ tuɔ-pula mi sipaaŋ dee mi kɔ di mi yirɛ.” ");
INSERT INTO sil_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋii nɛ Jɔɔŋ Wia lii-foori-la haritooroo kɔ Yesu teeŋ a piɛsu a bul, “Bɛɛ nɛ tii la di Farisii tiŋŋaa vuvɔɔ niiŋ aŋ ka ŋ haritooroo-na bi niiŋ vɔɔ?” ");
INSERT INTO sil_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ŋii nɛ Yesu piɛsɛba a bul, “Di nuu nɛ mu jaa haal kaa kɔ, ka ba duu naŋdɔŋsuŋ hɔŋ, u naŋdɔŋsu-la tuɔŋ jaŋ chei? Ai. Ama chɛɛ dɔŋ nɛ hɛ dimɛ, ba jaŋ kɛŋ baal-la kaa mu lee, aŋ ka di u naŋdɔŋsu-la vɔɔ niiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ŋii nɛ u bira magɛ namaga a piba a bul, “Nuu-kala bi jaŋ joŋ gɛripɛ-faliŋ a kaa tɔ gɛri-biniŋ. Ŋ nɛ ŋaa ŋii, ŋ jaŋ chei gɛri-falii-la. ");
INSERT INTO sil_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ŋii titia nɛ nuu ma bi jaŋ joŋ si-huoŋ a hɛ pupoi-kpaaŋ lɛ. Ŋ nɛ ŋaa ŋii, pupoi-la jaŋ yɛrɛ, di siŋ-la kala bisa ta. Si-huoŋ maga di ŋ joŋu hɛ pupoi-zɔmuŋ lɛ nɛ, di siŋ-la ari pupoi-la kala zɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu fa síi bul wiaa ŋii, Ju̱u tiŋŋaa kuhiaŋ kubala kɔ u teeŋ a tuu kpirimi u sipaaŋ aŋ bula pu a bul, “Mi tolo nɛ yie suu lɛɛlɛ, ama ku joŋ ŋ nisiŋ daŋu lɛ duu duori.” ");
INSERT INTO sil_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ŋii nɛ Yesu to u hariŋ, ba di u haritooroo kala. ");
INSERT INTO sil_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ba síi mu ŋii, di haal kubala ma hɛ dimɛ. U fa kɛŋ tiŋa jisiŋ fii ari balia nɛ, ka u pɔ u bi dɛrɛ. Ŋii nɛ u kɔ a bal Yesu hariŋ a digi u gɛriŋ niipiniŋ lɛ ");
INSERT INTO sil_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","aŋ bul u titia lɛ, “Di mi nɛ digi u gɛriŋ maa, mi jaŋ duori.” ");
INSERT INTO sil_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ŋii nɛ Yesu miira daasɛ a nau a bula pu a bul, “Mi tolo, sí fawulluŋ fá, ŋ yarida nɛ ŋaa ŋ duori.” Haal-la guu duori bua-la titia lɛ. ");
INSERT INTO sil_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ŋii nɛ ka Yesu-na juu Ju̱u tiŋŋaa kuhiaŋ-la dia. U jua di yo-daaraa china aa yel. ");
INSERT INTO sil_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ŋii nɛ Yesu bula piba di nuu-kala lii, di tolo-la bi suba, di u ta piŋ doŋ nɛ. Ŋii nɛ ba kala mumɔmu. ");
INSERT INTO sil_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ama ba si kiri nialiŋ kala ba lii, Yesu mu juu tolo-la dia a kɛŋ u nisiŋ lɛ, u sii. ");
INSERT INTO sil_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wiiŋ deeŋ Yesu si ŋaa, u teeli tiŋtee-la kala. ");
INSERT INTO sil_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu si lii Ju̱u tiŋŋaa kuhiaŋ-la dia-la lɛ aa vɛŋ, ŋii nɛ nyulimaa balia sii a tuto u hariŋ aŋ faasa yirɛ a bula pu a bul, “Yesu, Devit nihiŋ, fála nennige.” ");
INSERT INTO sil_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu si mu dia, nyulima-la baliamiŋ ma to u hariŋ juu dia-la. Ŋii nɛ u piɛsɛba a bul, “Ma ŋaa yarida ari mi jaŋ wuo ŋaa di ma duorii?” Ŋii nɛ ba bul, “Oo, la Tiina, la ŋaa yarida.” ");
INSERT INTO sil_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ŋii nɛ Yesu digi ba siaa lɛ aŋ bul, “Ma si ŋaa yarida ari ŋii jaŋ ŋaa, mi jaŋ leŋ duu ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ŋii nɛ ba siaa suri, ka Yesu bula piba ari siifiɛsiŋ a bul, “Ma sí wiiŋ deeŋ bula pi nuu-kala.” ");
INSERT INTO sil_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama ba lii Yesu teeŋ a bul wii-la kala Yesu si ŋaa a teeli leriŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nyulima-la balia si lii dia-la lɛ Yesu fa si hɛ, niaa kɛŋ baal kubala si bi wiaa wuo bul a kaa kɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ŋii nɛ Yesu kiri jima-la baal-la lɛ, baal-la suomo bubul wiaa. U ŋaa nuu-kala wu-kpuŋkpere. Ŋii nɛ ba bul di ba ha bi wiiŋ deeŋ yiri na Iziral lɛ. ");
INSERT INTO sil_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama Farisii tiŋŋaa bul ari jiŋsiŋ kuoro nɛ pu doluŋ duu kikiri jiŋ-bɔŋŋɔɔ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ŋii nɛ Yesu sii gɔllɛ ta-balaa ari ta-biisiŋ kala a dagɛ niaa Wii-chuɔlɛ diisiŋ lɛ a bul Wia wu-zɔmɔ-la a tigɛ Wia kuorii-la lɛ aŋ pɛ vaarɛ niaa nyanyal-yiriba kala. ");
INSERT INTO sil_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","U fa si na ni-daŋ-la, nennige kala kɛnu. U na di wiaa nɛ faa walimɛba. Ba bi ba titia lɛ wuo pɛ, a nagɛ piesee si bi pie-daara kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ŋii nɛ u bula pi u haritooroo a bul, “Ku-kumaa yuga nɛ baga lɛ di ba kuŋ, ama tiŋtinnaa bi yugɛ di ba kuŋ kialiŋ. ");
INSERT INTO sil_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Má saa sul baga-la tiina duu hɛ tiŋtinnaa yugɛ di ba tiŋ tiŋtimii-la.” ");
INSERT INTO sil_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ŋii nɛ Yesu yirɛ u haritooroo fii ari balia a hɛ dɔŋɔ lɛ a piba doluŋ di ba wuo kikiri jiŋsiŋ aŋ pɛ vivaarɛ niaa nyanyal-yiriba kala. ");
INSERT INTO sil_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nialiŋ u si liisa yiraa nɛ ŋla: Saamɔŋ, ba fa kɛnu yiyirɛ Piita ma nɛ, ari u naaŋbie Aŋduru, ari Jeems, si ŋaa Zɛbidii bie, ari Jɔɔŋ. Jɔɔŋ fa ŋaa Jeems ŋaana nɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","U bira liisɛ Filip, ari Batolomi, ari Tɔmas, ari Matiu laŋpoo lilaari-la, ari Alifiyas bie Jeems, ari Tadiyas, ");
INSERT INTO sil_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ari Saamɔŋ Zɛlɔt, ari Judas Isikarɔt, nii-la si ku ŋaa zɛŋbɛ tiina a yallɛ Yesu. ");
INSERT INTO sil_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Niaa deeŋba fii ari balia, Yesu nɛ tiŋba ba lii. Ŋla nɛ u bula piba aŋ ka ba lii: “Ma sí nialiŋ si bi Ju̱u tiŋŋaa ŋaa tiŋteeŋ mu. Ma sí Samaria tiŋteeŋ ma mu. ");
INSERT INTO sil_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama má mu Iziral niaa teeŋ, niaa deeŋba lɛlɛ nagɛ piesee si lɛlɛ nɛ a bira bi dia wɛniŋ jiŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Má mu a bul Wia kuorii-la wiaa piba a bul duu kpaga nɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Má vaarɛ nyanyal tiŋŋaa a chisɛ suunuŋ a vaarɛ gbegisiŋ a kiri jiŋ-bɔŋŋɔɔ niaa lɛ. Ma nɛ ŋaa ŋii, ma sí time kala laa, bɛɛ wiaa ma ma bi kuŋ-kala time aŋ laa. ");
INSERT INTO sil_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma sí moribiee ma joŋo hɛ ma gɛri-fesiniŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma ma sí sulli-gbaŋsiŋ koru a kaa vɛŋ woŋbii-la a sí gɛnniŋ tuŋ-bulia koo nɛŋtɛŋŋɛɛ tuŋ-bulia laalu, ma sí daaŋtiga ma koru. Di tiŋtinna nɛ tima, u maga di ba ti̱mu nɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Di ma nɛ mu yi ta-bal koo ta-bie, má juu taŋ-la tuɔŋ a bee chɛ nii-la si jaŋ wuo laama bil a chuchua dii-bala-la lɛ halii di bua-la ma si jaŋ lii taŋ-la lɛ yi. ");
INSERT INTO sil_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Di ma nɛ mu juu dia kala, má laa sipaaŋ chuɔlɛ dia-la niaa a bul, ‘Dia deeŋ niaa jaŋ hɔŋ ari yarifiɛlaa.’ ");
INSERT INTO sil_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Di ba nɛ laama, ba jaŋ kɛŋ yarifiɛlaa. Di ba nɛ bima laa, yarifiɛla-la jaŋ miira kɔ ma teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Di ma mu nuu-kala teeŋ, duu pɔ di ma sí juu a bi ma wialiŋ ma jegilee nii, má lii dia-la lɛ koo taŋ-la lɛ a kpesi ma naasiŋ hagila ta. Ba jaŋ jiŋ ari ba ŋaa wii nɛ a cheima lɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mi bulaa pima ari sariya chɛ-diiliŋ, Wia jaŋ dɔgisɛ taŋ-la niaa a kii bua-la lɛ u si dɔgisɛ Sɔdɔm niaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ŋii nɛ Yesu bira bul, “Má jegile nii, ma nagɛ pie-biisiŋ nɛ. Mii tiŋma di ma guoli guŋgurusuŋ tuɔŋ. Má saa kɛŋ wu-jimiŋ a nagɛ diŋŋaa si kɛŋ wu-jimiŋ ŋii a leŋ di ma siaa fiɛlɛ a nagɛ kokosuŋ siaa si fiɛlɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Má kɛŋ ma titia woruŋ ni-bɔŋŋɔɔ deeŋba teeŋ. Ba jaŋ kɛŋma kaa mu nialiŋ si yie hilime vuvuurɛ wiaa teeŋ di ba dii ma sariya. Ba jaŋ viirima Wii-chuɔlɛ diisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A tiŋ mi wiaa, ba jaŋ kɛŋma kaa mu kuoroo ari taŋ kuhiasiŋ sipaaŋ di ma dii mi daŋsia, ba di nialiŋ si bi Ju̱u tiŋŋaa ŋaa kala teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Di ba nɛ kɛŋma kaa mu di ba dii ma sariya, ma sí leŋe di ma bɔisiŋ joŋ wialiŋ ma si jaŋ bul lɛ a laa ma titia. Bua-la lɛ Wia jaŋ joŋ wu-jimiŋ a hɛ ma nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wialiŋ ma si jaŋ bul, ma dee bi jaŋ bul. Ma Nyimma Wia jaŋ leŋ di u Diŋ-zɔŋ-la toma lɛ a bul wiaa pima. ");
INSERT INTO sil_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Naaŋbiiriŋ jaŋ kɛŋ dɔŋɔ a kaa mu tia di ba kpu. Nyimmaba ma jaŋ ŋaa ŋii ba biiriŋ lɛ. Biiriŋ ma jaŋ ŋaa ŋii a ma kɛsɛ ba nyimmaba ari ba naaŋba a kaa mu pa di ba kpu. ");
INSERT INTO sil_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nuu-kala jaŋ bɛrɛma a tiŋ mi wiaa. Ama nii-la kala si nyalimɛ a mu dɛrɛ, Wia jaŋ laau ta. ");
INSERT INTO sil_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Di ba níi dɔgisɛma taŋ-la lɛ, má lii a fá mu taŋ dɔŋɔ. Mi bulaa pima ari ma bi jaŋ wuo tiŋ tiŋtimii-la dɛrɛ Iziral tasiŋ kala lɛ, ka di mi-na Nuhuobiine Bie-na kɔ. ");
INSERT INTO sil_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sukuuri bie bi u kerichi ka kii, nii-la síi tiŋ tiŋtiŋŋaa nuu dɔŋ teeŋ ma bi yuga kii nii-la teeŋ u síi tiŋ tiŋtimii-la. Tiŋtinna bi u kuhiaŋ ka kii. ");
INSERT INTO sil_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ama di nii-la nɛ gunnɛ tiŋtimii-la dɛrɛ, u maga di ba di nii-la si dagu kala magɛ dɔŋɔ nɛ. Di ba nɛ saa kɛŋ dia tiina kaa yirɛ Bɛlizibul, ŋii-na ba jaŋ hɛ yiri-bɔŋŋɔɔ a pi u dia niaa kala. ");
INSERT INTO sil_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ŋii wiaa, ma sí nuhuobiinee fá. Wii-kala si faa jaŋ ku lii pulumuŋ, niaa ma jaŋ nii wii-la si ŋaa wu-faali. ");
INSERT INTO sil_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wii-kala mi si bula pima birimiŋ tuɔŋ, u maga di ma bulu pulumuŋ tuɔŋ. Wii-kala bira ba si muŋso bula pima birimiŋ tuɔŋ, má heele bulu lusuŋ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ŋii nɛ Yesu bira bul, “Ma sí nialiŋ si jaŋ wuo kpu ma yaaraa fá, niaa deeŋba bi ma dima wuo kpu. Ama má fá Wia. U nɛ kɛŋ doluŋ duu wuo joŋ ma yaraa ari ma diŋsiŋ kala a hɛ Wia nyiniŋ tuɔŋ. Mi bula pima, má fifáu. ");
INSERT INTO sil_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Zaarikokobiisiŋ balia dee ba yie joŋo yallɛ kɔbu koo? Ama ba tuɔŋ kubala ma bi jaŋ tel tiŋteeŋ, see ma Nyimma Wia sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wia paala jiŋ ma nyu-punaa kala ma niiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ŋii wiaa, ma sí leŋe di fawulluŋ kɛŋma. Ma nɛ paala kii zaarikokobiisiŋ a yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nii-la kala si jaŋ wuo bul niaa tuɔŋ ari u ŋaa mi nuu nɛ, mi ma jaŋ bul ŋii a tigɛu lɛ mi Nyimma Wia si hɛ Wia-jaŋ lɛ sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama nii-la kala si viami niaa tuɔŋ, mi ma jaŋ viau mi Nyimma Wia si hɛ Wia-jaŋ lɛ sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma fa biina di mi kɔ dunia di niaa siŋ nɛɛ? Ai, yuosuŋ nɛ mi kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi kɔ di niaa pɔrɛ dɔŋɔ lɛ nɛ. Bie jaŋ kɛŋ u nyimma di ba yuo dɔŋɔ. Tolo ma jaŋ kɛŋ u naaŋ di ba guraa yuo dɔŋɔ. Bii-haala ma jaŋ kɛŋ u bala naaŋ di ba guraa yuo dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nuu diŋdɔŋŋɔɔ paala jaŋ hɛ u dia-niaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nii-la kala si cho u nyimma ari u naaŋ a kiimi, u bi maga duu ŋaa mi haritooru. Nii-la kala ma si cho u bie koo u tolo a kiimi, u bi maga duu ŋaa mi haritooru. ");
INSERT INTO sil_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nii-la kala si bi u titia daa-gɛsɛɛ baasɛ a to mi hariŋ, u bi maga duu ŋaa mi haritooru. ");
INSERT INTO sil_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nii-la kala síi chɛ u titia miisiŋ, u jaŋ joŋ u miisiŋ ta. Ama nii-la kala si via u miisiŋ ta a tiŋ mi wiaa, u jaŋ kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nii-la kala si kɛŋma woruŋ, u tiina kɛŋmi ma woruŋ nɛ. Nii-la ma kala si kɛŋmi woruŋ, u kɛŋ Tiina ma si tiŋmi woruŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nii-la kala si laa Wia tiŋtinna dɔŋɔ a kɛnu woruŋ u dia lɛ a tiŋ u si ŋaa Wia tiŋtinnu wiaa, u jaŋ laa u time. Time-la Wia si jaŋ joŋo ti̱mu, u jaŋ magɛ time-la Wia si jaŋ ti̱ŋ u tiŋtinni-la. Nii-la kala ma si laa tuɔ-pul tiina bil a tiŋ u si ŋaa tuɔ-pul tiina wiaa, time-la Wia si jaŋ joŋo ti̱mu, u jaŋ magɛ time-la u si jaŋ joŋo ti̱ŋ tuɔ-pul tiina-la. ");
INSERT INTO sil_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nii-la ma kala si ŋaa lii-fiɛla pi mi haritooroo deeŋba tuɔŋ ku-bie a tiŋ u síi to mi hariŋ wiaa, u tiina ma jaŋ laa u time.” ");
INSERT INTO sil_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu si bul wiaa deeŋba a pi u haritooroo fii ari balia-la dɛrɛ, u lii lee-la a mu duu dagɛ niaa aŋ pɛ bul Wia wiaa tasi-la si kpagɛ lee-la. ");
INSERT INTO sil_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jɔɔŋ Wia lii-foori-la fa si hɛ sarika lɛ a nii wialiŋ Kirisito fa síi ŋaa, u tiŋ u haritooroo dɔŋsuŋ Yesu teeŋ ");
INSERT INTO sil_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","di ba mu piɛsɛ Yesu a bul, “Bula pila, ŋ nɛ nii-la Jɔɔŋ fa si si u jaŋ kɔ, koo la haa gbɛrɛ nuu ma dɔŋ nɛɛ?” Ŋii nɛ ba mu piɛsu. ");
INSERT INTO sil_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ba si piɛsɛ dɛrɛ, Yesu bula piba a bul, “Má miira mu Jɔɔŋ teeŋ a bula pu wialiŋ kala ma si na a nii maa. ");
INSERT INTO sil_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Má bula pu di nyulimaa siaa suri nɛ, gbɛrikɛɛ vivɛŋ, gbegisiŋ ma duduori. Taŋŋaa ninii wiaa, nialiŋ si suba sisii suuŋ lɛ. Summoo ma wuo ninii Wia wu-zɔŋŋɔɔ. ");
INSERT INTO sil_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nialiŋ si bi kaa lɛrɛ ari mi nɛ ŋaa nii-la Wia si tima, ba tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ŋii nɛ Jɔɔŋ haritooro-la viiri. Ŋii nɛ Yesu suomo bul Jɔɔŋ wiaa a pipi ni-daŋ-la. U piɛsɛba, “Ma si mu Jɔɔŋ teeŋ tiŋtee-hilii-la lɛ, bɛɛ nɛ ma fa gbɛrɛ di ma na? Ma mu di ma na yaŋ peliŋ si kaa viviisi nɛɛ? Ai. ");
INSERT INTO sil_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bɛɛ nɛ saa ma lii di ma na? Ma lia di ma na nuu si laalɛ gɛri-zɔŋŋɔɔ nɛɛ? Ai. Bee na nialiŋ si yie laalɛ gɛnniŋ deeŋba, ba yie juu kuori-diisiŋ nɛ aa nii sima. ");
INSERT INTO sil_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Má saa dagɛmi ku-la ma si mua di ma na. Ma mua di ma na nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛɛ? Oo, mi jaŋ bula pima ari ma na nuu duu kii nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","U-na Jɔɔŋ wiaa nɛ ba ŋmuŋsa bil Wia teniŋ tuɔŋ a bul di Wia si, ‘Má jegile nii mi teeŋ, mi jaŋ tiŋ mi tiŋdaara duu laa ŋ sipaaŋ a mu a wasɛ woŋbiiŋ biliŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ŋii nɛ Yesu bira bula pi niaa a bul, “Wutitii, mi bulaa pima, Jɔɔŋ, Wia lii-foori-la nɛ kii nuu-kala ba si lula. Ama nii-la si ŋaa ni-bie Wia kuorii-la tuɔŋ, u nɛ yuga kii Jɔɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A chiŋ bua-la lɛ Jɔɔŋ si suomo bubul Wia wiaa a kaa kukɔ tapuluŋ deeŋ, niaa kɛŋ Wia kuorii-la wiaa yuyuo dɔŋɔ nɛ, ŋii nɛ ni-duoruŋ wiwalimɛ di ba kaa loriko laa. ");
INSERT INTO sil_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ka di Jɔɔŋ-na kɔ, nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa bul Wia kuorii-la wiaa nɛ. Wialiŋ Wia si leŋe ba ŋmuŋsa bil di niaa tuto ma dagɛ ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Di ma nɛ ŋaa yarida, ma sɛi wialiŋ ba si bula. Jɔɔŋ nɛ ŋaa Ilaaja, nii-la wiaa ba fa si bula duu jaŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Digilaa tiŋŋaa, má wuoli ma digilaa a nii wiaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ŋii nɛ Yesu bira bul, “Bɛɛ nɛ mi jaŋ kɛŋ jiniŋ niaa kaa magisɛ? Ba nagɛ haŋbiisiŋ síi gbieli yɔbɔ tuɔŋ nɛ. Dɔŋsuŋ yie kpia dɔŋɔ lɛ a bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘La yii yiilaa nɛ pima, aŋ ka ma bi gua, la yel yoho pima, aŋ ka ma bi yel.’ ");
INSERT INTO sil_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bua-la lɛ Jɔɔŋ si kɔ ma teeŋ, uu vɔɔ niiŋ nɛ a bi siniŋ ma nyua. Ŋii nɛ ba si di jiŋ-bɔŋ nɛ kɛnu. ");
INSERT INTO sil_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aŋ ka mi-na Nuhuobiine Bie kɔ ma teeŋ a didii kiaa aŋ pɛ nyunyua siniŋ maa. Ŋii nɛ ba bula pi dɔŋɔ a bul, ‘Baala deeŋ ŋaa luobii tiina nɛ a ŋaa si-nyuaru maa aŋ pɛ kɛŋ laŋpoo lilaaraa ari haachɛ diiree kala ma kaa dii naŋdɔŋsuŋ.’ Nialiŋ si sɛi wu-jimii-la si lii Wia teeŋ, ba wu-ŋaalaa daga ari ba sɛnɛ sɛi nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tasi-la lɛ Yesu si ŋaa wu-magilaa yugɛ, ba niaa bi u wiaa laa dii, ŋii wiaa ba bi birima lii ba haachɛba lɛ. Ŋii nɛ u kpiaba lɛ a bul, ");
INSERT INTO sil_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ma Kɔraziŋ tiŋŋaa, ma jaŋ na hɛɛŋ. Bɛtisaada tiŋŋaa maa, ma ma jaŋ na hɛɛŋ. Wu-magila-la ba si ŋaa ma teeŋ, di ba nɛ fa ŋaaba Taya ari Saadɔŋ niaa teeŋ ŋla, ba fa bi jaŋ dieni aŋ hɔnɔ tɛllɛ naasiŋ a ŋaa tuɔruŋ bugɛ ba titia, a didagɛ ŋii ari ba birima lii ba haachɛba lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mi bulaa pima, sariya chɛ-diiliŋ, Wia jaŋ dɔgisɛ Kɔraziŋ ari Bɛtisaada tiŋŋaa a kii Taya ari Saadɔŋ tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma-na Kapɛnam tiŋŋaa, ma nɛ paala chichɛ di ma kɛŋ ma titia a kaa jil Wia-jaŋ. Wia jaŋ joŋma yuo ta nɛ di ma tuu juu u nyiniŋ. Wu-magilaa deeŋba kala mi si ŋaa ma teeŋ, di mi fa ŋaaba Sɔdɔm lɛ nɛ, ba fa jaŋ hɛ dimɛ a kaa kukɔ jiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mi bulaa pima, sariya chɛ-diiliŋ Wia jaŋ fá Sɔdɔm niaa nennige a kii Kapɛnam niaa.” ");
INSERT INTO sil_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bua-la titia lɛ Yesu guu yirɛ, “Mi Nyimma, ŋ nɛ ŋaa wia nyuŋ ari tiŋteeŋ kala Tiina. Mii lɔlluŋ ari ŋ si kɛŋ wialiŋ ŋ si joŋo faa a dagɛ nialiŋ si bi wiaa jiŋ, aŋ bi joŋo dagɛ nialiŋ si kɛŋ wu-jimiŋ. ");
INSERT INTO sil_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mi Nyimma, mii lɔlluŋ. Ŋ titia tuɔtɔruŋ lɛ nɛ ŋ ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ŋii nɛ u bira bul, “Mi Nyimma joŋ kuŋ-kala doluŋ nɛ pimi. Mi Nyimma duŋduŋa nɛ jiŋ ŋii mi si naga. Mi ma duŋduŋa nɛ jiŋ ŋii mi Nyimma ma si naga. Nuu-kala bira buu jiŋ, see nialiŋ duŋduŋa mi síi cho di mi daga.” ");
INSERT INTO sil_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ŋii nɛ Yesu bira bula pi niaa, “Má kɔ mi teeŋ, ma nialiŋ kala si lɔlɔ, aŋ ka wiaa nyagɛma bil. Mi jaŋ pima wiese. ");
INSERT INTO sil_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Má laa mi chuga a chuŋ aŋ gunnɛ mi teeŋ, bɛɛ wiaa mi kɛŋ mi titia muuri nɛ, mi siaa ma fiɛlɛ. Di ma ŋaa ŋii, ma jaŋ na wiese. ");
INSERT INTO sil_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chuga-la mi si jaŋ joŋo chuŋma jaŋ ŋaa chugi-mɔli, u bi yuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","U bi diene aŋ ka Yesu ari u haritooroo sii to nyoŋso baga tuɔŋ chɛ-wiesii-la chɛɛŋ. Losuŋ fa kɛŋ Yesu haritooroo. Ŋii nɛ ba suomo kiilɛ nyoŋso-la aa chaŋ. ");
INSERT INTO sil_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisii tiŋŋaa si na wiiŋ deeŋ ŋii, ba piɛsɛ Yesu a bul, “Ŋ bi naa? Chɛ-wiesii-la kisiŋ nɛ ba chichei ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ŋii nɛ Yesu piɛsɛba a bul, “Ma bi wii-la Devit fa si ŋaa karimaa? Losuŋ fa si kɛnu ba di u hariŋ niaa, ");
INSERT INTO sil_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","u mu juu Wia-dia a joŋ boroboro-la ba fa si kaa ku bil Wia sipaaŋ a chɔgɔ dii, aŋ joŋo pi u hariŋ niaa maa, ba ma dii. U fa ŋaa kisiŋ nɛ di ni-wogo dii boroboro-la, see nialiŋ si kpu pusuŋ pipi Wia duŋduŋa. Ŋii-na u fa bi maga di Devit ari u hariŋ niaa dii kudiile-la. ");
INSERT INTO sil_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Koo ma ha bi wialiŋ Moosis fa si ŋmuŋsa bil di la tuto karimaa? Chɛ-wiesii-la chɛɛŋ kala nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ fa yie chei la kisiŋ Wia-dia lɛ. Ama ba fa si ŋaa ŋii chɛ-wiesii-la chɛɛŋ, u bi haachɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mi bulaa pima ari kuŋ nɛ hɛ ma tuɔŋ lɛɛlɛ a yuga kii Wia-dia. ");
INSERT INTO sil_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wia teniŋ tuɔŋ, ba ŋmuŋsa di Wia si, ‘Mi cho di ma fifá niaa nennige nɛ a kii ma si kpu pusuŋ pipimi.’ Di ma nɛ fa sɛnɛ jiŋ wiiŋ deeŋ bubuɔŋ, ma fa bi jaŋ joŋ cheeriŋ pi nialiŋ si bi wii cheye. ");
INSERT INTO sil_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","bɛɛ wiaa mi-na Nuhuobiine Bie nɛ ŋaa chɛ-wiesii-la Tiina ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ŋii nɛ Yesu lii lee-la a mu juu Wii-chuɔlɛ dia, ");
INSERT INTO sil_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","di baal kubala nɛ ŋii. U nisiŋ suba nɛ. Niaa dɔŋsuŋ ma fa hɛ dimɛ a chichɛ di ba bul Yesu teeŋ ari u cheye nɛ. Ŋii nɛ ba piɛsu a bul, “U kɛŋ woŋbiiŋ nɛɛ di la vaarɛ nyanyal tiŋŋaa chɛ-wiesii-la chɛɛŋ koo?” ");
INSERT INTO sil_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ŋii nɛ Yesu piɛsɛba a bul, “Di ma kuŋ nɛ kɛŋ piesu duu tel viliŋ lɛ chɛ-wiesii-la chɛɛŋ, ŋ jaŋ liisu koo ŋ jaŋ leŋu dimɛ duu suu? Ma jaŋ liisɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nuhuobiine nɛ paala kii piese. Di la nɛ saa ŋaa wu-zɔŋŋɔɔ chɛ-wiesii-la chɛɛŋ, la bi chɛ-wiesii-la kisiŋ-la cheye.” ");
INSERT INTO sil_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ŋii nɛ u bula pi na-suu-la tiina a bul, “Kɛŋ ŋ nisiŋ tiɛnɛ.” U kaa tiɛnɛ. U fiɛla a nagɛ u nisi-la dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ŋii nɛ Farisii tiŋŋaa lii lee-la a mu vuurɛ ŋii ba si jaŋ ŋaa a kpu Yesu. ");
INSERT INTO sil_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu si nia di ba vuurɛ di ba kpuu ŋii, u lii lee-la. Ni-daŋ to u hariŋ. Ŋii nɛ u vaarɛ nialiŋ fa síi wiilu kala ");
INSERT INTO sil_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aŋ bula piba di ba sí leŋ di wiiŋ deeŋ teeli leriŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","U ŋaa wiiŋ deeŋ di wialiŋ Azaaya fa si bula ku ŋaa wutitii. Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","U fa si, “Mi Tiŋtinna nɛ ŋla, nii-la mi si liisa, nii-la mi si cho, mi tuɔŋ tɔrɛ u nyuŋ. Mi jaŋ joŋ mi Diŋ-zɔŋ-la hɛu lɛ. U jaŋ bul mi sariya diiniŋ wiaa a pi dunia niaa kala. ");
INSERT INTO sil_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","U bi jaŋ kaa lɛrɛ, u bi jaŋ kpia goŋ maa. U bi jaŋ ŋiŋaa goŋ woŋbiee lɛ di niaa ninii. ");
INSERT INTO sil_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","U siaa jaŋ fiɛlɛ nialiŋ si ŋaa puwuoloo teeŋ, a kɛŋ zile ni-pugunuŋ ma teeŋ. U jaŋ pɛsɛ halii, see wutitii-la Wia síi chɛ yuo dii leriŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","U lɛ nɛ dunia niaa kala jaŋ joŋ ba yiɛlaa hɛ.” ");
INSERT INTO sil_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ŋii nɛ niaa dɔŋsuŋ kɛŋ baal kubala kaa kɔ Yesu teeŋ. Jiŋsiŋ nɛ fa kɛŋ baal-la. U fa nyulima aŋ pɛ taŋ. Yesu vaarɛ baal-la. Ŋii nɛ u wuo wiaa bubul aŋ nina maa. ");
INSERT INTO sil_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yesu si ŋaa ŋii, u fa ŋaa ni-daŋ-la kala wu-kpuŋkpere. Ŋii nɛ ba pipiɛsɛ dɔŋɔ a bul, “Devit bie nɛ ŋlaa?” ");
INSERT INTO sil_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisii tiŋŋaa fa si nii ŋii, ba bul, di jiŋsiŋ kuoro Bɛlizibul nɛ pu doluŋ, ŋii nɛ tii u wuo kikiri jiŋsiŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu wuo jiŋ ba tuɔbiinaa a bula piba a bul, “Di taŋ niaa nɛ hɛ dimɛ a bi nii-bala kɛnɛ, ba taŋ-la jaŋ tel. Di jaŋ niaa koo naaŋbiiriŋ ma nɛ bi nii-bala kɛnɛ, ba dia jaŋ tel. ");
INSERT INTO sil_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ŋii nɛ di Sitaani kiri Sitaani, u ma taŋ bi jaŋ wuo chiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ŋii nɛ Yesu bira piɛsɛba a bul, “Di Bɛlizibul nɛ pimi doluŋ mi kaa kiri jiŋ-bɔŋŋɔɔ niaa lɛ, kubɛɛ nɛ saa joŋ doluŋ pi niaa deeŋba síi to ma hariŋ ba ma kikiri jiŋ-bɔŋŋɔɔ niaa lɛ? Niaa deeŋba titia daga ari maa nyia nɛ. Ba jima ari Sitaani bi u titia wuo guraa yuo. ");
INSERT INTO sil_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wia doluŋ nɛ mi kaa kiri jiŋ-bɔŋŋɔɔ niaa lɛ. Wiiŋ deeŋ nɛ daga ari Wia kuorii-la paala kɔ ma teeŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nuu tuo si jaŋ juu ni-duoŋ dia a gaa u kiaa, see duu kɛŋ ni-duo-la vɔɔ, aŋ-na juu paa u kiaa. ");
INSERT INTO sil_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nuu-kala si bi mi nuu ŋaa, u lii mi hariŋ nɛ. Nii-la kala si bi mi lɛ pɛ di la kiri kiaa hihɛ dɔŋɔ lɛ, u kaa pisa tita nɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mi bulaa pima ari Wia jaŋ joŋ niaa haachɛba ari wu-bɔmɔ-la ba síi bul a chɛba, ama nii-la kala si tuusɛ Wia Diŋ-zɔŋ-la joŋŋoo, Wia bi jaŋ joŋo chɛ u tiina. ");
INSERT INTO sil_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nii-la kala si bul wu-bɔŋŋɔɔ a mu tigɛ mi-na Nuhuobiine Bie lɛ, Wia jaŋ joŋo chɛu, ama nii-la kala si tuusɛ Wia Diŋ-zɔŋ-la joŋŋoo, Wia bi jaŋ joŋo chɛ u tiina lɛɛlɛ a kaa mu wuu.” ");
INSERT INTO sil_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ŋii nɛ Yesu bira bul, “Di ŋ níi chɛ tia nɛŋ nɛŋ-zɔŋŋɔɔ, see di ŋ kɛŋ tia-la si kɛŋ yarifiɛlaa. Di ŋ nɛ kɛŋ tia-la si bi yarifiɛlaa kɛnɛ, see duu ninɛŋ nɛŋ-lɔrunuŋ. Tia-la nɛnɛɛ nɛ yie dagɛ tia-la yiri u si ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma ni-bɔŋŋɔɔ deeŋba, di ma nɛ bɔmɔ, ɛɛ nɛ ma jaŋ wuo ŋaa a bubul wu-zɔŋŋɔɔ? Ŋ tuɔbiinaa si kɛŋ wii-la nɛ, u nɛ ŋ niiŋ bubul. ");
INSERT INTO sil_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni-zɔmuŋ kɛŋ tuɔbiiŋ-zɔŋŋɔɔ nɛ aa ŋaa wu-zɔmɔ-la u síi biinu. Ni-bɔmuŋ ma kɛŋ tuɔbiiŋ-bɔŋŋɔɔ a maa ŋaa wu-bɔmɔ-la u síi biinu u tuɔŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi bulaa pima ari sariya chɛ-diiliŋ nuu-kala paala jaŋ dagɛ wu-bɔmɔ-la u niiŋ si bula. ");
INSERT INTO sil_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wialiŋ titia ma si bula nɛ jaŋ dii ma sariya a dagɛ di ma kɛŋ tuɔ-pulaa koo ma bi tuɔ-pulaa kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ŋii nɛ Wia teniŋ kerichiba dɔŋsuŋ ari Farisii tiŋŋaa dɔŋsuŋ ma kɔ Yesu teeŋ a bula pu a bul, “La kuhiaŋ, laa chɛ di ŋ ŋaa wu-magil nɛ di la na.” ");
INSERT INTO sil_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ŋii nɛ Yesu bul, “Jiniŋ niaa ŋaa ni-bɔmɔ nɛ, ba bi Wia ka fá. Ma si di mi ŋaa wu-magiliŋ. Ai, mi bi ŋaa. Wu-magiliŋ ma síi chɛ, ma bi jaŋ wuo nau, see wu-magil-la Wia fa si ŋaa a tigɛ Jona lɛ. ");
INSERT INTO sil_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona fa si hɛ cheŋfili-bal-la tuɔŋ tapulaa batori wiihɛyɛ ari titaŋiŋ kala, ŋii titia nɛ mi-na Nuhuobiine Bie ma jaŋ hɛ vaamiŋ tuɔŋ tapulaa batori, wiihɛyɛ ari titaŋiŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sariya chɛ-diiliŋ, Ninivɛ niaa ma jaŋ sii a joŋ cheeriŋ pima woruŋ. Bua-la lɛ Jona ma fa si mu bul Wia wiaa pi Ninivɛ niaa, ba birima lii ba haachɛba lɛ nɛ a to Wia. Mi jaŋ bula pima ari nuu nɛ hɛ ma tuɔŋ a yuga kii Jona, ka ma bi sɛi di ma jegile nii u wiaa.” ");
INSERT INTO sil_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ŋii nɛ Yesu bira bul, “Haal kubala nɛ fa hɛ dimɛ. U dii kuoruŋ tiŋtee kubala lɛ baa yirɛ Siiba. U sii lii u jaŋ lɛ a mu di-bolii duu jegile nii kuoru kubala wu-jimiŋ. U yiriŋ nɛ fa Solomɔŋ. U fa kɛŋ wu-jimiŋ kiŋkɛŋ kiŋkɛŋ. Sariya chɛ-diiliŋ haal-la jaŋ sii a joŋ cheeriŋ a pi jiniŋ niaa woruŋ. Mi jaŋ bula pima ari nuu nɛ hɛ ma tuɔŋ, u yuga kii Solomɔŋ, ka ma bi sɛi di ma jegile nii u wiaa.” ");
INSERT INTO sil_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ŋii nɛ Yesu bira bula pi niaa a bul, “Di jiŋ-bɔŋ nɛ lii nuu lɛ, u yie gɔllɔ tiŋtee-hiliŋ lɛ nɛ a chichɛ di-wiesiŋ, aŋ bi na. ");
INSERT INTO sil_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","U si bi lee na ŋii, u yie bul u titia lɛ a bul, ‘Mi jaŋ miira mu lee-la mi si lia.’ U jaŋ miira mumu, di disinniŋ tuo dia-la lɛ, ba wasɛ u kala zɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ŋii nɛ u jaŋ miira lii a kɛŋ jiŋ-bɔŋŋɔɔ balipɛ, kialiŋ si bɔmɔ kiiu, ba ma ku juu a pɛu lɛ. Ŋii hariŋ lɛ nɛ baal-la yie kperi a kii buŋbuŋ-la. Ŋii titia nɛ u ma jaŋ ŋaa ma jiniŋ ni-bɔŋŋɔɔ deeŋba lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu fa si bul wiaa pipi nialiŋ ŋii, u naaŋ ari u ŋaanaa kɔ u teeŋ a ku chiŋ jeeŋ hariŋ a chichɛ di ba nau.  ");
INSERT INTO sil_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ŋii nɛ nuu bula pu a bul, “Bee na, ŋ naaŋ ari ŋ ŋaanaa nɛ chiŋ jeeŋ hariŋ a chichɛ di ba naŋ.” ");
INSERT INTO sil_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ŋii nɛ Yesu miira piɛsɛba a bul, “Kubɛɛ nɛ ŋaa mi naaŋ ari mi ŋaanaa?” ");
INSERT INTO sil_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ŋii nɛ u liisɛ u nisiŋ a dagɛ u haritooroo aŋ bul, “Mi naaŋ ari mi naaŋbiiriŋ nɛ ŋla: ");
INSERT INTO sil_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nii-la kala si ŋaa wii-la mi Nyimma Wia si hɛ Wia-jaŋ lɛ si cho, u nɛ ŋaa mi ŋaana ari mi dihaala ari mi naaŋ.” ");
INSERT INTO sil_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tapulii-la titia Yesu lii dia-la lɛ ba di u haritooroo fa si hɔnɔ, a sii mu mugi-baliŋ niiŋ a hɔŋ dimɛ duu dagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","Niaa yugɛ a ku gollu chu. Ba si yuga ŋii, u sii mu juu liiŋ daboro tuɔŋ a hɔŋ liiŋ tuɔŋ, ka ni-daŋ-la chiŋ muga niiŋ. Ŋii nɛ u magɛ namagaba a dagɛba wiaa yugɛ. U namagaba-la dɔŋɔ nɛ ŋla: Yesu si, “Baal kubala nɛ sie a kɛŋ u ku-doho kaa lii duu misɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","U síi misɛ ŋii, ku-doho-la dɔŋsuŋ tel woŋbiiŋ tuɔŋ. Diibiisiŋ ku tuɔsa dii. ");
INSERT INTO sil_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dɔŋsuŋ ma tuu tel kpaginyiliŋ nyuŋ. Hagila si bi yugɛ ŋii, ka ba guu nyu. ");
INSERT INTO sil_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba naapoloo bi tiŋteeŋ jua. Wia pɔsɛ a kpuba, ba suu, bɛɛ wiaa ba naapoloo bi tiŋteeŋ jua. ");
INSERT INTO sil_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ku-doho-la dɔŋsuŋ ma tel sɔsuŋ tuɔŋ. Ba nyu, sɔsu-la ma nyu a nyaga kpu. Ba bi wasa. ");
INSERT INTO sil_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ama ku-doho-la dɔŋsuŋ ma lii tel tiŋtee-zɔmuŋ lɛ a nyu a waa a wasɛ woruŋ. Dɔŋsuŋ hɛ biee zɔlɔ zɔlɔ, dɔŋsuŋ ma mahiŋ batori batori, dɔŋsuŋ ma mara ari fii fii.” ");
INSERT INTO sil_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu si magɛ namaga-la dɛrɛ, ŋii nɛ u bul, “Digilaa tiŋŋaa, má wuoli ma digilaa a nii wiaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ŋii nɛ Yesu haritooroo kɔ u teeŋ a piɛsu a bul, “Bɛɛ nɛ tii ŋ yie kɛŋ namagaba a didagɛ niaa?” ");
INSERT INTO sil_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ŋii nɛ Yesu bula piba a bul, “Ma niaa deeŋba nɛ Wia dagɛ u kuorii-la wiaa bubuɔŋ pa, wialiŋ fa si faa, ama ni-daŋ kala dee. ");
INSERT INTO sil_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nii-la kala si to Wia niiŋ wiaa, Wia jaŋ faasa pɛu lɛ woruŋ. Nii-la ma si bi Wia niiŋ wiaa ka to, Wia bi jaŋ pɛu lɛ. U si pɛu lɛ mua-la maa, u jaŋ laa u kua. ");
INSERT INTO sil_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wii-la si tii mi yie mimagɛ namagaba nɛ ŋla: Ba yie nyilimi nyilimi nɛ aŋ bi kuŋ-kala wuo na, a jijegili wiaa aŋ bi wii-kala ka nii aŋ bi wialiŋ bubuɔŋ ma wuo jiŋ. ");
INSERT INTO sil_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wia si to Azaaya lɛ a bul wialiŋ, ba wiaa nɛ u bul ŋii. Ba ku ŋaa wutitii. Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. U fa bula a bul, ‘Niaa deeŋba jaŋ jegili jegili wiaa aŋ bi wii-kala bubuɔŋ wuo jiŋ, ba jaŋ nyilimi nyilimi aŋ bi kuŋ-kala wuo na, ");
INSERT INTO sil_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","bɛɛ wiaa ba bi wu-jimiŋ kɛnɛ Wia teeŋ, ba via Wia niiŋ wiaa nɛ, ba tɔ ba digilaa ma nɛ di ba sí wii-kala nii a kɛŋ ba siaa ma tɔ di ba sí kuŋ-kala na. Wia si di ŋii dee, ba fa jaŋ nina, ba digilaa ma fa ninii wiaa. Ba fa jaŋ jiŋ wiaa bubuɔŋ a birima kɔ mi teeŋ di mi vaarɛba.’ ");
INSERT INTO sil_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma-na, ma tuɔŋ tɔrɔ ari ma wuo nina wialiŋ kala ma síi na a wuo nii wialiŋ maa. ");
INSERT INTO sil_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mi bulaa pima ari nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ari nialiŋ dɔŋsuŋ fa síi to Wia, ba yuga a cho di ba nina wialiŋ ma síi na aŋ bi wuo na, a ma fa cho di baa nii wialiŋ ma síi nii, aŋ ka ba bi wuo nii. ");
INSERT INTO sil_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Má jegili a nii ku-duuro namaga-la bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nialiŋ si yie nii Wia niiŋ wialiŋ a mu tigɛ Wia kuorii-la lɛ aŋ bi ba bubuɔŋ jiŋ, ba nagɛ ku-doho-la si tel woŋbiiŋ lɛ nɛ. Sitaani yie guu kɔ a kɛŋ wialiŋ a liiri ba tuɔsaa lɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kialiŋ ma si tel kpaginyiliŋ nyuŋ ma nɛ ŋaa nialiŋ si yie guu a laa Wia niiŋ wialiŋ dii ari tuɔtɔruŋ. ");
INSERT INTO sil_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama ba bi bɔyɛ kɛnɛ a nagɛ naapoloo si bi tiŋteeŋ jua. Ba jaŋ sɛi wii-la a tou mu magɛ ŋii. Di hɛɛŋ nɛ juuba, koo di ba to naasiŋ dudɔgisɛba a tiŋ wii-la wiaa, ba tuɔŋ guu lii wii-la lɛ. Ba joŋo ta. ");
INSERT INTO sil_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kialiŋ si tel sɔsuŋ tuɔŋ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ, ama dunia kiaa wiaa walimɛba, ba cho di ba jigi aa chɛ kuŋ-kala. A tiŋ wiaa deeŋba, ba bi sɛi di ba to wialiŋ. Wialiŋ bi doho kɛnɛ ba teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kialiŋ si tel tiŋtee-zɔmuŋ lɛ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ a jiŋ ba bubuɔŋ, wialiŋ kɛŋ doho kiŋkɛŋ kiŋkɛŋ ba teeŋ, dɔŋsuŋ nɛŋ zɔlɔ zɔlɔ, dɔŋsuŋ mahiŋ batori batori, dɔŋsuŋ ma mara ari fii fii.” ");
INSERT INTO sil_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ŋii nɛ Yesu bira magɛ namaga dɔŋɔ a piba a bul, “Wia kuorii-la nagɛ baala si sie nɛ a du̱u miiriŋ u baga lɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Titaŋ kubala niaa kala si piŋ doŋ, u diŋdɔmɔ kɛŋ yaŋ kaa mu du̱u hɛ baga-la lɛ aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Miiri-la si suomo nyu a ninɛŋ, yaŋ-la ma nyu. ");
INSERT INTO sil_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ŋii nɛ baal-la tiŋtinnaa mu a na baga-la a miira ku bula pi baal-la a bul, ‘La kuhiaŋ, ŋ du̱u ku-zɔŋŋɔɔ nɛ ŋ baga-la lɛ, ka nii nɛ yaŋ-la ma nyu baga-la lɛ?’ ");
INSERT INTO sil_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ŋii nɛ ba kuhiaŋ-la bula piba a bul, ‘U naga ari mi diŋdɔŋ nɛ ŋaa ŋii.’ Ŋii nɛ u tiŋtinna-la piɛsu a bul, ‘Ŋŋ chɛ di la mu a churi yaŋ-la ta nɛɛ?’ ");
INSERT INTO sil_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ŋii nɛ baal-la bul, ‘Ai, má leŋ di miiri-la bii. Di ma nɛ mua di ma churi yaŋ-la lɛɛlɛ, ma jaŋ pɛ churi miiri-la dɔŋsuŋ ma ta. ");
INSERT INTO sil_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Di miiri-la nɛ bia, mi jaŋ leŋ di nialiŋ sii mu baga di ba laa sipaaŋ churi yaŋ-la a vɔɔ a nyigɛ, aŋ-na kuŋ miiri-la kaa ku hɛ mi vire lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ŋii nɛ Yesu bira magɛ namaga dɔŋɔ a bul di Wia kuorii-la nagɛ baal kubala nɛ si joŋ ku-doho kubala baa yirɛ masitad a du̱u u baga lɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ku-doho-la bi wii maga. U nɛ muuro kii ku-doho-na kala si hɛ dimɛ. Ama duu nɛ nyua, u yie waa a birimɛ tia nɛ a yuga kii baga ku-duuloo kala kala. Ŋii nɛ diibiisiŋ yie sagɛu lɛ a sua ba dɛlliŋ u naakelee lɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu bira magɛ namaga dɔŋɔ a piba a bul, “Wia kuorii-la nagɛ si-buruŋ nɛ ba si kaa hihɛ munuŋ lɛ. Haala joŋ munuŋ a hɛ tasi-gbaŋa tuɔŋ a joŋ si-buruŋ a kaa kuosi. U dieni mua, ka muŋ-la sii puɔra su̱ tasi-gbaŋa-la kala.” ");
INSERT INTO sil_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Di Yesu nɛ fa bul wii-kala pipi ni-daŋ-la, namaga nɛ u yie magɛ. U bi jaŋ bul wii di u bi namaga maga. ");
INSERT INTO sil_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","U ŋaa ŋii di wialiŋ nuu fa si bula, Wia Diŋ-zɔŋ-la doluŋ lɛ, ku ŋaa wutitii nɛ. U fa si, “Di mi nɛ bul wiaa pipi niaa, mi jaŋ magɛ namagaba, mi jaŋ bul wialiŋ si ŋaa wu-faalaa a chiŋ dunia di-suomuŋ a piba.” ");
INSERT INTO sil_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu si ta ni-daŋ-la, ba viiri, ka u sii juu dia. Ŋii nɛ u haritooroo kɔ u teeŋ a piɛsu a bul, “Dagɛla namaga-la ŋ si maga a tigɛ baga yaŋ lɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ŋii nɛ Yesu bul, “Nii-la si du̱u miiri-la nɛ ŋaa mi-na Nuhuobiine Bie. ");
INSERT INTO sil_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Baga-la lɛ u si du̱u miiri-la, u nɛ ŋaa dunia. Miiri-la ma nɛ ŋaa nialiŋ si jaŋ juu Wia kuorii-la tuɔŋ. Yaŋ-la ma si nyu baga-la lɛ nɛ ŋaa Sitaani niaa. ");
INSERT INTO sil_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Diŋdɔŋ-la si du̱u yaŋ-la nɛ ŋaa Sitaani. Miiri-la ma kumuŋ nɛ ŋaa dunia didɛriŋ. Nialiŋ ma si kuŋ miiri-la nɛ ŋaa Wia tiŋdaaraa. ");
INSERT INTO sil_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ŋii ba si hiesi yaŋ-la a nyigɛ, ŋii titia nɛ jaŋ ŋaa dunia didɛriŋ. ");
INSERT INTO sil_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mi-na Nuhuobiine Bie, mi jaŋ tiŋ mi tiŋdaaraa di ba juu Wia kuorii-la tuɔŋ a tuɔsɛ nialiŋ si ŋaa haachɛ tiŋŋaa, ari nialiŋ kala si ŋaa wu-bɔŋŋɔɔ ");
INSERT INTO sil_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","a joŋo yuo a hɛ Wia nyiniŋ tuɔŋ. Lee-la nɛ ba jaŋ yel aŋ pɛ didiŋ ba nyilaa. ");
INSERT INTO sil_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka di tuɔpul tiŋŋaa tutul ari wii-pɔsuŋ síi tul ŋii la Nyimma Wia kuorii-la tuɔŋ. Digilaa tiŋŋaa, má wuoli ma digilaa a nii wiaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu bira bul, “Wia kuorii-la nagɛ ŋla nɛ: Baal kubala nɛ mu a pipɛrɛ baga a na di sɛlimɛ hɛ baga-la lɛ. U si na sɛlimɛ-la, u gbaa tɔ, u tuɔŋ kala faasa tɔrɛ kiŋkɛŋ. Ŋii nɛ u mu yallɛ u kiaa kala a kɛŋ moribie-la a kaa mu yɔɔ baga-la.” ");
INSERT INTO sil_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu bira si di Wia kuorii-la nagɛ bayala si mua di u yɔɔ busiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","U si na dɔŋɔ duu faasa zɔŋ kiŋkɛŋ, u miira mu joŋ u kiaa kala u si kɛnɛ a yallɛ a yɔɔ busii-la. ");
INSERT INTO sil_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu bira si di Wia kuorii-la nagɛ joŋ nɛ, ba si joŋo yuo hɛ mugi-baliŋ tuɔŋ. U kɛsɛ cheŋfili-yiriba kala. ");
INSERT INTO sil_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Di cheŋfilee nɛ suo, cheŋfili-kpuura-la yie kaa lɛrɛ lii mugi-baliŋ niiŋ nɛ a tuɔsɛ cheŋfilie-la. Ba yie tuɔsɛ ku-zɔŋŋɔɔ hɛ ba kiaa lɛ aŋ joŋ kialiŋ si bi zɔŋ a yuo ta. ");
INSERT INTO sil_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ŋla nɛ saa u jaŋ nagɛ dunia didɛriŋ. Wia tiŋdaaraa jaŋ lii a tuɔsɛ ni-bɔŋŋɔɔ ni-zɔŋŋɔɔ tuɔŋ ");
INSERT INTO sil_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a joŋba yuo hɛ Wia nyiniŋ lɛ. Dimɛ nɛ ba jaŋ yel aŋ didiŋ ba nyilaa. ");
INSERT INTO sil_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ŋii nɛ Yesu piɛsɛ u haritooroo a bul, “Ma jiŋ wiaa deeŋba kala bubuɔŋ nɛɛ?” Ŋii nɛ ba si, “Oo.” ");
INSERT INTO sil_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ŋii nɛ Yesu bula piba a bul, “Wiiŋ deeŋ daga ari nii-la kala si gunnɛ Wia teniŋ woruŋ a ku ŋaa Yesu haritooru a ŋaa siri duu juu Wia kuorii-la tuɔŋ, u tiina nagɛ dia tiina si yie chaarɛ mii-binaa ari mii-falaa nɛ u vire lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu si magɛ namaga deeŋba dɛrɛ, u sii Kapɛnam lɛ ");
INSERT INTO sil_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a miira mu Nazarɛt. Ŋii nɛ u mu dagɛ niaa Wii-chuɔlɛ dia lɛ. Nialiŋ kala si nii wialiŋ u si bula, ba hiriki. Ŋii nɛ ba pipiɛsɛ dɔŋɔ, “Nii nɛ baala deeŋ na wu-jimiŋ deeŋ ari wu-duoruŋ deeŋba kala ŋaaniŋ? ");
INSERT INTO sil_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Josɛf, kapiŋta-la bie dee ŋii? Mɛɛri dee bi u naaŋ ŋaa? Jeems ari Josɛf ari Saamɔŋ ari Judas u naaŋbiiriŋ dee ŋii? ");
INSERT INTO sil_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ba di u dihaalaa kala dee daha ŋii? Nii lɛ nɛ saa u na wiaa deeŋba kala?” ");
INSERT INTO sil_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ŋii nɛ ba na baaniŋ u nyuŋ. Ŋii nɛ Yesu bula piba a bul, “Nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, duu nɛ mu lee-kala, ba yie zizilu nɛ, aŋ ka u jaŋ-niaa siiŋ buu ka su̱.” ");
INSERT INTO sil_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A tiŋ ba si bi yarida kɛnɛ wiaa, u bi wu-duoruŋ wuo ŋaa yugɛ lee-la. ");
INSERT INTO sil_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bua-la lɛ nɛ Galilii kuoro Hɛrɔd nii Yesu wiaa. ");
INSERT INTO sil_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","U bula pi u naŋzɔɔba ari Jɔɔŋ Wia lii-foori-la nɛ ŋii. Wia nɛ chisu suuŋ lɛ, ŋii nɛ tii u kɛŋ doluŋ a wuo ŋiŋaa wu-magilaa deeŋba. ");
INSERT INTO sil_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hɛrɔd-la fa sie a mu jaa haal kubala. U yiriŋ nɛ Hɛrɔdias. U fa ŋaa u ŋaana Filip haala nɛ. U laa jaa. ");
INSERT INTO sil_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ŋii nɛ Jɔɔŋ bula pi Hɛrɔd a bul, “Ŋ si kɛŋ ŋ ŋaana haala laa jaa ŋii, u bi woŋbiiŋ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ŋii nɛ Hɛrɔd faa chɛ duu kpu Jɔɔŋ, ama u faa fá Ju̱u tiŋŋaa nɛ. Ŋii wiaa u ŋaa ba kɛnu tɔ dia. Ju̱u tiŋŋaa fa si di Jɔɔŋ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ŋii nɛ Hɛrɔd chɛ-lulluŋ tapuluŋ bira yi. U yirɛ u niaa di ba ku gbieli. Hɛrɔdias tolo ma kɔ a gua ba kala sipaaŋ, Hɛrɔd beŋ a chou. ");
INSERT INTO sil_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ŋii nɛ u bula pi tolo-la a bul, “Mi ŋmiɛsa, mi jaŋ piŋ kuŋ-kala ŋ síi chɛ.” ");
INSERT INTO sil_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ŋii nɛ tolo-la mu bul wiiŋ deeŋ a pi u naaŋ aŋ piɛsu, “Mi bul di mii chɛ bɛɛ kuŋ nɛ?” Ŋii nɛ u naaŋ bula pu duu bul duu chɛ duu keri Jɔɔŋ Wia lii-foori-la nyuŋ a hɛ pirata lɛ nɛ a pu. Tolo-la bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuoro si nii wii-la, u tuɔŋ kala chei. Ama u si ŋmiɛsa ŋii, niaa kala nii. Ŋii nɛ u bul di ba ŋaa ŋii tolo-la síi chɛ. ");
INSERT INTO sil_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","U ŋaa ba mu keri Jɔɔŋ nyuŋ sarika lɛ, ");
INSERT INTO sil_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","a hɛ pirata lɛ a kaa ku pi tolo-la. Ŋii nɛ u laa a kaa mu pi u naaŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jɔɔŋ haritooro-la si nii wii-la, ba sii ku laa u ku-suuŋ a kaa mu hugi. Ŋii nɛ ba mu bula pi Yesu wialiŋ si ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu si nii Jɔɔŋ wiaa, u sii lee-la u fa si hɛ a juu liiŋ daboro a mumu niaa si tuo lee-la, u duŋduŋa. Ama niaa nii Yesu wiaa a lii ba jaŋ lɛ a vɛŋ naasiŋ lɛ a kiri u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu si mu lii liiŋ daboro-la lɛ, u na ni-daŋ di ba hɔnɔ gbɛru. Nennige kala kɛnu. Ŋii nɛ u vaarɛ nialiŋ síi wiilu. ");
INSERT INTO sil_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Didaaniŋ ku yi, u haritooroo kɔ u teeŋ a bula pu a bul, “Taŋ bire nɛ. Leriŋ deeŋ ŋaa giriŋ nɛ. Ta nialiŋ di ba mu tasi-la si kpagɛ daha a yɔɔ kudiilee a dii.” ");
INSERT INTO sil_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ŋii nɛ Yesu bul, “Ma sí leŋe di ba viiri. Má-na mu chɛ kudiilee piba di ba dii.” ");
INSERT INTO sil_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ŋii nɛ u haritooro-la bul, “Ku-la kala la si kɛnɛ nɛ boroboroba banɔŋ ari cheŋfilee balia.” ");
INSERT INTO sil_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ŋii nɛ Yesu bul, “Má kaa kɔ pimi.” ");
INSERT INTO sil_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","U ŋaa nialiŋ tuu hɔŋ yaŋ nyuŋ. Ŋii nɛ u laa boroboroba banɔŋ-la ari cheŋfilie-la balia a wula beŋ wia nyuŋ aŋ lɔllɛ Wia aŋ kaa chɔgɛ chɔgɛ a pi u haritooroo. U haritooroo laa kpaa nialiŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nuu-kala dii a vɔgɛ. Ka u haritooro-la paa ku-kaaŋ-biisiŋ a su̱ siŋsiŋ fii ari balia. ");
INSERT INTO sil_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nialiŋ fa si dii boroboro-la, ba tuɔŋ baalaa fa ŋaa bui banɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ŋii nɛ Yesu leŋ u haritooroo laa sipaaŋ mu juu liiŋ daboro a duoro chol muga cholo, aŋ ka duu ta ni-daŋ-la di ba viiri. ");
INSERT INTO sil_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","U si ta ni-daŋ-la ba viiri, u mu jil peeliŋ nyuŋ duu chuɔlɛ Wia. Ŋii nɛ wia tuu juu, duu duŋduŋa nɛ ha hɛ peel-la nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bua-la lɛ di liiŋ daboro-la yi liiŋ tutuɔbaaniŋ. Lii-peliŋ kaa viviisi, ba fa chaasɛ pel-la nɛ. ");
INSERT INTO sil_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Siipuuraa, Yesu sii vɛŋ liiŋ nyuŋ a mumu u haritooro-la teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba si nau duu vɛŋ liiŋ nyuŋ, fawulluŋ kɛŋba. Ba bul di ni-dima nɛ. Fawulluŋ si kɛŋba ŋii, ba ŋmuŋmoo niiŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ŋii nɛ Yesu guu bula piba a bul, “Má nyirɛ ma bɔyɛ. Mi-na nɛ. Ma sí leŋe di fawulluŋ kɛŋma.” ");
INSERT INTO sil_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ŋii nɛ Piita bul, “Mi Tiina, di ŋ nɛ, bul di mi lii kɔ ŋ teeŋ lii-la nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ŋii nɛ Yesu bul duu kɔ. U si bul ŋii, Piita lii liiŋ daboro-la tuɔŋ a vɛŋ liiŋ nyuŋ aa mu Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama Piita si bee na lii-pel-la, fawulluŋ kɛnu. U suomo tutuu lii-la bubuɔŋ. Ŋii nɛ u faasa ŋmoo niiŋ a bul, “Mi Tiina, laami ta.” ");
INSERT INTO sil_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu guu liisɛ u nisiŋ a yia a kɛnu aŋ bula pu, “Ŋ yarida bi yugɛ. Bɛɛ nɛ tii ŋ bi mi wiaa laa dii?” ");
INSERT INTO sil_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba si mu juu liiŋ daboro-la dɛrɛ, pel-la kɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nialiŋ kala si hɛ liiŋ daboro-la tuɔŋ tuu kpirimi a chuɔlɛ Yesu aŋ bul, “Wutitii, ŋ nɛ ŋaa Wia Bie.” ");
INSERT INTO sil_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ŋii nɛ ba chol a ku yi taŋ kubala baa yirɛ Gɛnɛzarɛt. ");
INSERT INTO sil_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ŋii nɛ nialiŋ si hɛ lee-la yie jiŋ Yesu. Ŋii nɛ ba mu paa ba nyanyal tiŋŋaa kala si hɛ tasi-la si golli Gɛnɛzarɛt a kaa kɔ Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba sulu duu leŋ di nialiŋ síi wiilu digi u gɛriŋ niipiniŋ lɛ. Di ba nɛ dige, ba yie duori. ");
INSERT INTO sil_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ ari Wia teniŋ kerichiba lii Jerusalɛm a kɔ Yesu teeŋ a piɛsu a bul, ");
INSERT INTO sil_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bɛɛ nɛ tii ŋ haritooroo chichei la naabalimaba kisinniŋ lɛ? Bɛɛ nɛ tii ba bi ba nisaa ka sɔŋ ŋii la naabalimaba si dagɛla aŋ didii kudiilee?” ");
INSERT INTO sil_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ŋii nɛ Yesu ma piɛsɛba a bul, “Bɛɛ nɛ tii ma yie via Wia woŋbiiŋ aŋ tuto ma naabalimaba woŋbiiŋ? ");
INSERT INTO sil_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wia bula di ma fifá ma nyimmaba ari ma naaŋba, a bira bul di nuu nɛ sii a bul wu-bɔŋ a tigɛ u nyimma ari u naaŋ lɛ, di ba kpu tiina. ");
INSERT INTO sil_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama ma-na daga ari nuu nɛ kɛŋ kuŋ a magɛ duu joŋo pɛ u nyimma koo u naaŋ lɛ, tiina mu a bula piba duu jaŋ joŋ ku-la pi Wia. ");
INSERT INTO sil_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","U si ŋaa ŋii, u bira bi maga duu pɛ u nyimma ari u naaŋ lɛ. A tiŋ ŋii wiaa, ma via Wia niiŋ wiaa aŋ to ma naabalimaba woŋbiiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma ŋaa kaŋfugi timma nɛ. Azaaya kiaa sima nɛ, wialiŋ u si bula a tigɛma lɛ. Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","U fa si, ‘Wia si, niaa deeŋba kɛŋ niiŋ nɛ a pipimi zile, ka ba tuɔŋ liimi. ");
INSERT INTO sil_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba yie chuɔlɛmi pɛi nɛ aa dagɛ nuhuobiine wɛniŋ aŋ bul di Wia nɛ bula. Nuhuobiine wɛniŋ nɛ baa to aŋ via Wia niiŋ wiaa.’ ” ");
INSERT INTO sil_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ŋii nɛ Yesu yirɛ niaa ba kɔ. U bula piba a bul, “Má jegile nii woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","U bi naga ku-la si yie to nuhuobiine niiŋ tuu nɛ yie ŋaa u kɛŋ disinniŋ, ama ku-la si yie to u niiŋ lii nɛ kɛŋ disinniŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ŋii nɛ Yesu haritooroo kɔ u teeŋ a bula pu a bul, “Ŋ jima ari ŋ chei Farisii timma-la tuɔŋ nɛ ŋ si bul ŋii?” ");
INSERT INTO sil_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ŋii nɛ u bula piba a bul, “Tia-la kala mi Nyimma si hɛ Wia-jaŋ si yie bi chɔŋsɔ, ba jaŋ kaa churo ta. ");
INSERT INTO sil_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma sí leŋe di ba wiaa wiima, ba ŋaa nyulimaa nɛ a laa nyulimaa sipaaŋ. Di nyulima nɛ saa kɛŋ u nyuluŋ dɔŋɔ daaŋ lɛ, ba kala balia jaŋ tuu buɔtuoŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ŋii nɛ Piita bul, “Dagɛla namaga-la bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ŋii nɛ Yesu bul, “Ma ma ha bi wu-jimiŋ kɛnɛɛ? ");
INSERT INTO sil_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma bi wiiŋ deeŋ bubuɔŋ jiŋ? Kuŋ-na kala si juu nuhuobiine niiŋ, u yie juu u luoruŋ nɛ a bira to u yaraa lii. ");
INSERT INTO sil_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama wialiŋ si yie to ŋ niiŋ lii, ba yie lii ŋ tuɔŋ lɛ nɛ. Wiaa deeŋba nɛ yie ŋaa niaa kɛŋ disinniŋ. ");
INSERT INTO sil_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ŋ tuɔŋ lɛ nɛ ŋ yie biinɛ wu-bɔŋŋɔɔ ŋaaniŋ a mu kpu niaa, a mu chɛ niaa haalaa, a ŋaa ba-chɔruŋ ari ha-chɔruŋ wu-ŋaalaa, aa gaa, aa nyia wiaa a tigɛ niaa lɛ, a chichei niaa yiriŋ. ");
INSERT INTO sil_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wiaa deeŋba nɛ yie ŋaa niaa kɛŋ disinniŋ. Ama di nuu nɛ dii kiaa aŋ bi u nisiŋ sɔmɔ ari ma naabalimaba si dagɛ ŋii, ŋii bi jaŋ wuo ŋaa di tiina kɛŋ disinniŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ŋii nɛ Yesu sii lee-la a mu Taya ari Saadɔŋ tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Di haal kubala si hɛ lee-la kɔ u teeŋ. U fa ŋaa Keenaŋ tiina nɛ. U si kɔ u teeŋ, ŋii nɛ u bul, “Mi Tiina Devit bii, fámi nennige. Jiŋsiŋ nɛ kɛŋ mi tolo. U nina hɛɛŋ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama Yesu bi wii-kala bula u teeŋ. Ŋii nɛ u haritooroo kɔ u teeŋ a bula pu duu leŋ di haal-la viiri, di u to ba hariŋ a ŋiŋaa goŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ŋii nɛ Yesu bula piba a bul, “Wia tiŋmi di mi kɔ chɛ kɛsɛ piese-la si lɛlɛ nɛ Iziral tiŋŋaa duŋduŋ nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋii nɛ haal-la ku tel u naasiŋ lɛ aŋ bul, “Mi Tiina, pɛmi lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ŋii nɛ Yesu bula pu a bul, “Ŋ nɛ kɛŋ haŋbiisiŋ, ŋ bi jaŋ joŋ ba kudiilee a yuo pi vahiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋii nɛ haal-la bul, “Mi Tiina, u ŋaa wutitii nɛ, ama vahi-la tiŋŋaa síi dii kialiŋ, kialiŋ si tel tiŋteeŋ nɛ, ba ma jaŋ paa didii.” ");
INSERT INTO sil_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ŋii nɛ Yesu bula pu a bul, “Ŋ ŋaa haal-la si kɛŋ yarida kiŋkɛŋ nɛ. Wii-la ŋ síi chɛ, mi jaŋ ŋaa piŋ.” Bua-la titia lɛ u tolo-la duori. ");
INSERT INTO sil_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ŋii nɛ Yesu bira sii lee-la a to Galilii muga-la diiriŋ mu. U jil peeliŋ nyuŋ a hɔŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ŋii nɛ ni-daŋ kɔ u teeŋ a kɛŋ gbɛrikɛɛ ari nyulimaa ari taŋŋaa ari nyanyal tiŋŋaa dɔŋsuŋ a kaa kɔ bil Yesu naasiŋ lɛ. U vaarɛba. ");
INSERT INTO sil_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ni-daŋ-la si na taŋŋaa di ba bul wiaa ari gbɛrikɛɛ síi vɛŋ, ari nyulimaa siaa di ba bira suro, u ŋaaba wu-kpuŋkpere. Ŋii nɛ ba didɛnnɛ Iziral tiŋŋaa Wia. ");
INSERT INTO sil_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ŋii nɛ Yesu yirɛ u haritooroo a bula piba a bul, “Mi si beŋ niaa deeŋba, nennige kɛŋmi nɛ. Ba hɛ mi teeŋ tapulaa batori nɛ ŋla aŋ bi kudiilee na di ba dii. Mi bi sɛi di ba viiri di ba nɛ bi kuŋ-kala die. Di mi ŋaa ŋii, ba jaŋ mu yiegi woŋbiiŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ŋii nɛ u haritooroo piɛsu, “Ɛɛ nɛ la jaŋ ŋaa a na kudiilee di ni-daŋ-la kala dii giriŋ deeŋ tuɔŋ?” ");
INSERT INTO sil_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","U piɛsɛba, “Boroboro baŋmɛɛ nɛ hɛ dimɛ?” Ba si, “Kiaa balipɛ nɛ ari cheŋfili-biisiŋ ma mua.” ");
INSERT INTO sil_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ŋii nɛ u ŋaa nialiŋ tuu hɔŋ tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka u joŋ boroboroba-la balipɛ ari cheŋfilie-la a lɔllɛ Wia aŋ kaa chɔgɛ chɔgɛ a pi u haritooroo di ba laa kpaa ni-daŋ-la. Ba laa kpaaba. ");
INSERT INTO sil_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nuu-kala dii a vɔgɛ. Ka ba paa ku-kaaŋ-biisiŋ a su̱ siŋsiŋ balipɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nialiŋ fa si dii kialiŋ, ba yi baalaa bui banɛsɛ, ka haalaa ari haŋbiisiŋ ma hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ŋii nɛ u ta ni-daŋ-la aŋ mu juu liiŋ daboro aŋ mu Magadaŋ tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ŋii nɛ Farisii tiŋŋaa ari Sadusii tiŋŋaa dɔŋsuŋ kɔ Yesu teeŋ di ba magisu. Ba bula pu duu ŋaa wu-magiliŋ di ba na a jiŋ ari u dol-la lii Wia nɛ. ");
INSERT INTO sil_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ŋii nɛ u bula piba a bul, “Di wia níi juu, ka ma na wii-muluŋ siiŋ duu fiɛsa, ma yie bul di leriŋ jaŋ fiɛlɛ. ");
INSERT INTO sil_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chichuɔ-fiɛla maa, di leriŋ nɛ bire, ma yie bul ari duonuŋ jaŋ nii. Ma yie wuo beŋ wia nyuŋ a wuo jiŋ wii-la si jaŋ ŋaa, ama ma bi wuo jiŋ wialiŋ síi ŋaa dunia deeŋ lɛ lɛɛlɛ. ");
INSERT INTO sil_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jiniŋ niaa ŋaa ni-bɔmɔ nɛ, ba bi Wia ka fá. Ma si di mi ŋaa wu-magiliŋ. Ai, mi bi ŋaa. Wu-magil-la ma síi chɛ, ma bi jaŋ wuo nau, see Wia fa si ŋaa a tigɛ Jona lɛ.” Ŋii nɛ Yesu leŋba aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu haritooro-la si juu liiŋ daboro a duoro chol fuoŋ cholo ŋii, ba yua ba bi kudiilee koro mu. ");
INSERT INTO sil_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ŋii nɛ Yesu bula piba di ba pɔ ba titia lɛ woruŋ ari Farisii tiŋŋaa ari Sadusii tiŋŋaa, di ba nagɛ si-buruŋ ba si joŋo hɛ boroboro lɛ duu puɔrɛ. ");
INSERT INTO sil_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ŋii nɛ ba suomo bula pipi dɔŋɔ, “La bi kudiilee koro kɔ, ŋii nɛ tii u bul wiiŋ deeŋ.” ");
INSERT INTO sil_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ŋii nɛ Yesu jiŋ wii-la ba síi bul a bula piba, “Ma yarida bi yugɛ. Bɛɛ nɛ tii ma hɔnɔ vuurɛ ari ma bi kudiilee kɛnɛ? Ma ha bi wu-jimiŋ kɛnɛɛ? ");
INSERT INTO sil_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ma ha bi wiaa bubuɔŋ jiŋ? Ma bi biina yi bua-la lɛ mi si joŋ boroboroba banɔŋ kaa chɔgɛ a pi niaa bui banɔŋ ba dii? Ba si die a vɔgɛ, siŋsiŋ baŋmɛɛ nɛ ma paa ku-kaanaa su̱? ");
INSERT INTO sil_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aŋ ka boroboro balipɛ-la mi si kaa chɔgɛ a pi niaa bui banɛsɛ-laa? Ku-kaanaa siŋsiŋ baŋmɛɛ nɛ ma paa su̱? ");
INSERT INTO sil_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bɛɛ nɛ ma biinɛ ari ma teeŋ nɛ mii bul kudiilee wiaa? Má pɔ ma titia lɛ ari Farisii tiŋŋaa ari Sadusii tiŋŋaa lɛ. Ba nagɛ si-buruŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ŋii nɛ u haritooroo jiŋ ari u bi si di ba pɔ ba titia lɛ ari si-buru-la ba si kaa hihɛ boroboro lɛ nɛ, ama u si ba pɔ ba titia lɛ Farisii tiŋŋaa ari Sadusii tiŋŋaa wu-bulaa lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ŋii nɛ Yesu sii mu Sizariya, Filipa tiŋteeŋ. Ŋii nɛ u piɛsɛ u haritooro-la a bul, “Kubɛɛ nɛ niaa si di mi-na Nuhuobiine Bie ŋaa?” ");
INSERT INTO sil_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ŋii nɛ ba bul, “Dɔŋsuŋ si di ŋ nɛ ŋaa Jɔɔŋ, Wia lii-foori-la. Dɔŋsuŋ ma si ŋ nɛ ŋaa Ilaaja. Dɔŋsuŋ ma si ŋ ŋaa Jɛrimaya, koo nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ŋii nɛ Yesu bira piɛsɛ u haritooro-la maa, “Ka ma maa, ma si mi ŋaa kubɛɛ nɛ?” ");
INSERT INTO sil_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ŋii nɛ Saamɔŋ Piita bul, “Ŋ nɛ ŋaa Kirisito, Wia-la si weye Bie.” ");
INSERT INTO sil_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ŋii nɛ Yesu bul, “Saamɔŋ, Jɔɔŋ bie, Wia jaŋ pɛŋ lɛ, wu-jimiŋ deeŋ u bi naga nuhuobiine nɛ piŋ. Mi Nyimma si hɛ Wia-jaŋ nɛ piŋ. ");
INSERT INTO sil_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ŋii wiaa Piita, mi bulaa piŋ ari ŋ nagɛ buŋ nɛ. Buŋ-la nyuŋ nɛ mi jaŋ saa nialiŋ si laa mi wiaa dii dia. Suuŋ ma bi jaŋ wuo yigi dia-la lo. ");
INSERT INTO sil_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi jaŋ joŋ Wia kuorii-la boribiee piŋ. Wii-la ŋ si via dunia lɛ, ba jaŋ viau Wia-jaŋ maa. Wii-la ma ŋ si sɛyɛ dunia lɛ, ba ma jaŋ sɛyu Wia-jaŋ.” ");
INSERT INTO sil_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ŋii nɛ Yesu bula pi u haritooro-la ari siifiɛsiŋ di ba sí bula pi nuu-kala ari u nɛ ŋaa Kirisito, nii-la Wia si liisa. ");
INSERT INTO sil_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A suomi bua-la lɛ Yesu chaasa bula pi u haritooroo a bul, “U maga di mi mu Jerusalɛm a na hɛɛŋ woruŋ Ju̱u tiŋŋaa nihiasiŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba nisiŋ lɛ. Ba jaŋ kpumi, ama mi jaŋ sii suuŋ lɛ tapulaa batori chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ŋii nɛ Piita kɛnu kaa suusa lii a kpiau lɛ a bul, “Wia bi jaŋ sɛi, mi Tiina. Wii-la bi jaŋ kɔ duu ŋaaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ŋii nɛ Yesu miira chaasɛ Piita a bula pu a bul, “Sitaani, mu dimɛ! Ŋŋ chɛ ŋ nyisɛmi di mi juu haachɛ lɛ nɛ. Wialiŋ ŋ síi bul, nuhuobiine woŋbiiŋ nɛ. Wia woŋbiiŋ dee.” ");
INSERT INTO sil_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ŋii nɛ u bula pi u haritooroo a bul, “Di nuu-kala níi chɛ duu tomi, see duu via u titia woŋbiiŋ aŋ joŋ u daa-gɛsɛɛ baasɛ tapulii-na kala a to mi hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nii-la kala síi chɛ duu laa u titia miisiŋ, u jaŋ joŋ u miisiŋ ta, ama nii-la si via u miisiŋ ta a tiŋ mi wiaa, u jaŋ sɛnɛ laa u miisiŋ. ");
INSERT INTO sil_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Di ŋ nɛ dii dunia kala aŋ bi miisiŋ kɛnɛ, bɛɛ kuŋ nyuurii nɛ ŋ na? Dunia deeŋ lɛ, bɛɛ kuŋ nɛ saa ŋ jaŋ wuo kaa yɔɔ ŋ miisiŋ? ");
INSERT INTO sil_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mi-na Nuhuobiine Bie, mi jaŋ kɔ a chaanɛ ari mi Nyimma kuoruŋ. La di Wia tiŋdaaraa nɛ jaŋ kɔ. Di la nɛ kɔ, Wia jaŋ ti̱ŋ nuu-kala a magɛ ŋii u si tima. ");
INSERT INTO sil_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wutitii nɛ, mi bulaa pima ari niaa dɔŋsuŋ hɛ dimɛ, ba bi jaŋ suu see di ba na mi-na Nuhuobiine Bie di mi kɔ ari mi kuorii-la.” ");
INSERT INTO sil_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tapulaa balidu si ku bal, Yesu kɛŋ Piita ari Jeems ari u naaŋbie Jɔɔŋ, ba duŋduŋa a kaa mu peel-bal kubala nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba beŋ ba sipaaŋ a na Yesu duu birima. U siaa kala tutul a nagɛ wii-pɔsuŋ síi tul ŋii. U gɛnniŋ ma pullɛ a tutul. ");
INSERT INTO sil_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ŋii nɛ Moosis ari Ilaaja ku lii ba sipaaŋ. Ba china bubul wiaa Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ŋii nɛ Piita bula pi Yesu a bul, “La Tiina, u ŋaa wu-zɔŋ nɛ ari la si hɛ daha. Di ŋ níi chɛ la jaŋ hɛ lɛŋŋɛɛ batori daha, di ŋ kɛŋ dɔŋɔ, di Moosis ma kɛŋ dɔŋɔ, di Ilaaja ma kɛŋ dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piita ha fa síi bul wiaa ŋii di duoŋbiliŋbaaniŋ ku tɔba, ka yiikoro kubala lii duoŋbiliŋbaani-la tuɔŋ a bubul, “Mi Bii-chooluŋ nɛ ŋla. Mi tuɔŋ tɔrɛ u nyuŋ. Má jegile nii u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesu haritooro-la si nii nii-la yiikoro, fawulluŋ kɛŋba, ba tuu tel tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ŋii nɛ Yesu kɔ ba teeŋ a digiba aŋ bula piba di ba sii aŋ sí fawulluŋ fá. ");
INSERT INTO sil_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba si sie, ba beŋ, ba bi nuu-kala na see Yesu duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba si lii peel-la nyuŋ ku tuu, Yesu bula piba a bul, “Mi bi chɛ di ma bul wii-la ma si naa a pi nuu-kala, see tapulii-la mi-na Nuhuobiine Bie si sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋii nɛ Yesu haritooro-la piɛsu a bul, “Bɛɛ nɛ tii Wia teniŋ kerichiba bul di Ilaaja nɛ laa sipaaŋ, aŋ ka di Wia Bie-na kɔ?” ");
INSERT INTO sil_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ŋii nɛ Yesu bul, “Wutitii, Ilaaja jaŋ sɛnɛ laa sipaaŋ kɔ a kɛŋ kuŋ-kala wasa bil. ");
INSERT INTO sil_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama mi bulaa pima ari Ilaaja paala kɔ nɛ, ama niaa bi wuo jimu. Ba ŋaau ŋii kala ba síi chɛ. Ŋii titia nɛ ba ma jaŋ dɔgisɛ mi-na Nuhuobiine Bie.” ");
INSERT INTO sil_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋii nɛ u haritooro-la jiŋ ari Jɔɔŋ Wia lii-foori-la wiaa nɛ u bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ŋii nɛ Yesu ari u haritooroo batori-la sii lii peel-la nyuŋ a ku tuu ni-daŋ-la teeŋ. Di baal kubala kɔ Yesu teeŋ a kpirimi u sipaaŋ ");
INSERT INTO sil_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aŋ bula pu a bul, “Mi Tiina, fá mi bie nennige, uu tel kpuŋkpusuŋ nɛ. Nyanyalii-la kɛnu nɛ woruŋ, u yie titel nyiniŋ koo liiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi kɛnu kaa kɔ ŋ haritooroo teeŋ, ama ba bi wuo vaaru.” ");
INSERT INTO sil_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ŋii nɛ Yesu bul, “Ma lɛɛlɛ niaa deeŋba, ma bi yarida kɛnɛ, ma ŋaa ni-bɔmɔ nɛ. Ɛɛ nɛ mi jaŋ nyalimɛ a dieni ma teeŋ?” Ŋii nɛ u bula pi baal-la duu kɛŋ u bile kɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ŋii nɛ Yesu bul jiŋ-bɔŋ-la lɛ duu lii bile lɛ. Ŋii nɛ u lii. Bile guu duori. ");
INSERT INTO sil_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ŋii nɛ Yesu haritooro-la kɔ u teeŋ a luɔra piɛsu a bul, “Bɛɛ nɛ tii la-na bi jiŋ-bɔŋ-la wuo kiri?” ");
INSERT INTO sil_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ŋii nɛ Yesu bula piba a bul, “Ma yarida bi yugɛ, ŋii nɛ tii. Wutitii, mi bulaa pima, di ma yarida nɛ fa magɛ kuŋ biiŋ ba síi yirɛ masitad, ma fa jaŋ wuo bul peeliŋ lɛ duu sii daha a mu sɛmɛ dɔŋɔ. U jaŋ sii mu. Wii-kala tuo ma fa bi jaŋ wuo ŋaa.  ");
INSERT INTO sil_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama Wia bi jaŋ pima doluŋ di ma wuo kikiri jiŋ-yiri deeŋba, see ma vɔɔ niiŋ aŋ pɛ chuchuɔlɛ Wia.” ");
INSERT INTO sil_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ŋii nɛ Yesu ari u haritooroo kala ku hilimi Galilii lɛ. Ŋii nɛ u bula piba di ba jaŋ kɛŋ u-na Nuhuobiine Bie a hɛ niaa nisiŋ lɛ ");
INSERT INTO sil_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","di ba kpuu, ama u hariŋ lɛ u jaŋ sii suuŋ lɛ tapulaa batori chɛɛŋ a kɛŋ miisiŋ. Yesu si bul ŋii, u haritooroo tuɔŋ chei. ");
INSERT INTO sil_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ari u haritooroo si kɔ Kapɛnam, nialiŋ síi laa Wia-dia time kɔ Piita teeŋ a piɛsu a bul, “Ma kuhiaŋ ka ti̱ŋ Wia-dia time nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ŋii nɛ Piita bul duu ti̱ŋ nɛ. Piita si bul ŋii aŋ miira juu dia, Yesu laa sipaaŋ a piɛsu a bul, “Kubɛɛ nɛ ti̱ŋ moribiee koo laŋpoo a pipi dunia deeŋ kuoroo? U taŋ-la niaa koo nuhuɔraa nɛɛ? Bɛɛ nɛ ŋ biinɛ?” ");
INSERT INTO sil_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ŋii nɛ Piita bul di nuhuɔraa nɛ. Yesu bira bul, “Ŋii-na u taŋ-la niaa bi kuŋ-kala ti̱ŋ. ");
INSERT INTO sil_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama la-na bi chɛ di la maasɛ niaa deeŋba, ŋii wiaa kɛŋ gbiaŋ tuu hɛ fuoŋ lɛ a kɛsɛ cheŋfilee. Gbiaŋ-la si kɛŋ cheŋfili-buŋbuŋ-la, kɛŋ u niiŋ suri. Ŋ jaŋ na moribiiŋ u niiŋ lɛ. Joŋ moribie-la a ti̱ŋ ma ari mi nyuŋ time.” ");
INSERT INTO sil_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yesu si bul ŋii a pi Piita dɛrɛ, u haritooroo kɔ u teeŋ a ku piɛsu a bul, “La tuɔŋ kubɛɛ nɛ kii u dɔŋɔ tiina Wia kuorii-la tuɔŋ?” ");
INSERT INTO sil_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ŋii nɛ Yesu yirɛ bii-bie kubala a kii ba tutuɔbaaniŋ ");
INSERT INTO sil_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aŋ bula piba a bul, “Wutitii nɛ mi bulaa pima, see di ma kɛŋ ma titia muuri a nagɛ haŋbiisiŋ, di ŋii dee, ma bi jaŋ wuo juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nii-la si kɛŋ u titia muuri a nagɛ haŋbie, u nɛ ŋaa ma tuɔŋ kuhiaŋ Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Di nuu nɛ kɛŋ bii-bie dɔŋɔ woruŋ a tiŋ mi wiaa, mi nɛ u kɛŋ woruŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nii-la kala si na haŋbiisi-la síi tomi dɔŋɔ a nyisu duu ŋaa wu-bɔmuŋ, u maga di ba joŋ nɔmuŋ a vɔɔ laalɛ u baŋŋa lɛ a joŋu yuo hɛ muga tuɔŋ uu nyua liiŋ u suu. Di ba nɛ ŋaa ŋii, u nɛ jaŋ kpia u si weye. ");
INSERT INTO sil_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","U jaŋ lɔrɛ pi nialiŋ si jaŋ ŋaa di niaa juu haachɛ lɛ. U maga di wialiŋ ku bal. Ama nii-la si ŋaa ba juu haachɛ lɛ, u jaŋ na hɛɛŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Di ŋ nisiŋ koo ŋ naaŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, kere ta. Ŋ si juu Wia kuorii-la tuɔŋ ari naa-kuuŋ koo na-kuuŋ, u nɛ kpia ŋ si jaŋ kɛŋ na-pilimee koo naa-pilimee a juu Wia nyiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Di ŋ siiŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, liisa ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari sii-togo, u nɛ kpia ba si joŋuŋ yuo hɛ Wia nyiniŋ ari sii-pilimee.” ");
INSERT INTO sil_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ŋii nɛ Yesu bira si, “Má fiɛlɛ di ma sí haŋbiisiŋ deeŋba kuŋ-kala kaa gbesi. Mi bulaa pima di Wia ta u tiŋdaaraa nɛ di ba bibeŋba. Ba hɛ Wia-jaŋ bua-na kala lɛ, mi Nyimma si hɛ lee-la. ");
INSERT INTO sil_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mi-na Nuhuobiine Bie kɔ di mi chɛ a laa nialiŋ si lɛlɛ nɛ a ta.” ");
INSERT INTO sil_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ŋii nɛ Yesu magɛ namaga a bul, “Nuu nɛ fa hɛ dimɛ a kɛŋ piesee zɔlɔ, ŋii nɛ ba tuɔŋ dɔŋɔ lɛl.” Ŋii nɛ Yesu piɛsɛ, “Ɛɛ nɛ ma biinɛ ari u jaŋ ŋaa? U bi jaŋ leŋ piesee mahiŋ banɛsɛ ari fii ari nibi-la a ta peelee nyuŋ aŋ lii gɔllɔ chichɛ pie-lɛlii-laa? ");
INSERT INTO sil_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Duu nɛ nau, mi jaŋ bula pima ari u tuɔŋ jaŋ tɔrɛ u pie-bala-la nyuŋ a kii piesee mahiŋ banɛsɛ ari fii ari nibi-la si bi lɛlɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ŋii titia nɛ saa mi Nyimma si hɛ Wia-jaŋ bi chɛ di haŋbiisiŋ deeŋba kuŋ lɛl.” ");
INSERT INTO sil_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ŋii nɛ Yesu si, “Di ŋ naaŋbie nɛ ŋaa wii cheiŋ lɛ, mu a bula pu wii-la u si ŋaa chei, ama ŋaa ŋii ma duu duŋduŋa balia pɛgɛ. Di u nɛ jegile nii wii-la ŋ síi bul, ma di ŋ naaŋbie bira sima nɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama duu nɛ bi jegile nii ŋ teeŋ, kɛŋ nuu dɔŋ koo niaa balia pɛ ŋ titia lɛ di ma mu u teeŋ a bul wii-la u si ŋaa chei duu wasɛ. Ŋ si ŋaa ŋii, ŋ jaŋ kɛŋ niaa di ba ŋaa ŋ daŋsia. ");
INSERT INTO sil_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ama di u nɛ via duu jegile nii ma teeŋ, ŋ-na bul wii-la pi nialiŋ kala si laa Yesu wiaa dii aa hilimi. Duu nɛ via duu jegile nii ba teeŋ maa, dɔgisu ari ŋ buu jiŋ a nagɛ nii-la si bi Wia jiŋ koo a nagɛ laŋpoo lilaaru nɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Wutitii nɛ, mi bulaa pima ari wii-la ma si via dunia lɛ, ba jaŋ viau Wia-jaŋ maa. Wii-la ma ŋ si sɛi dunia lɛ, ba ma jaŋ sɛyu Wia-jaŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mi jaŋ wasa bula pima ari ma niaa balia nɛ hɛ dimɛ a kɛŋ nii-bala a chuchuɔlɛ Wia a chichɛ kuŋ, mi Nyimma si hɛ Wia-jaŋ, u jaŋ joŋo pima. ");
INSERT INTO sil_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lee-la niaa balia koo batori si hilime mi doluŋ lɛ, mi jaŋ hɛ ba teeŋ.” ");
INSERT INTO sil_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ŋii nɛ Piita kɔ Yesu teeŋ a piɛsu a bul, “Mi Tiina, di mi naaŋbie nɛ ŋaa wii a cheimi lɛ, naaŋsiiŋ buŋmɛɛ nɛ mi jaŋ joŋo chɛu? Mi joŋo chɛu naaŋsiiŋ bulipɛ koo?” ");
INSERT INTO sil_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ŋii nɛ Yesu bira bul, “Ai, naaŋsiiŋ bulipɛ duŋduŋa dee. Joŋo chɛu naaŋsiiŋ mahiŋ batori ari fii leree bulipɛ.” ");
INSERT INTO sil_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ŋii nɛ Yesu magɛ namaga a kɛŋ Wia kuorii-la a kaa mimagisɛ kuoro ari u tiŋtinnaa a bul, “Kuoru kubala nɛ sie a chichɛ duu piɛsɛ u tiŋtinnaa u chiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","U si suomo duu piɛsɛ, ba kɛŋ u tiŋtinna dɔŋɔ kɔ u teeŋ. U dii u chimiŋ siidi bui bui bui nɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","U bi wuo ti̱ŋ. Ŋii nɛ u kuhiaŋ-la bul di ba kɛnu ari u haala ari u biiriŋ ari kialiŋ kala u si kɛnɛ a kaa mu yallɛ a ti̱ŋ chiŋ-la bua lɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ŋii nɛ tiŋtinni-la tuu kpirimi u naadusuŋ nyuŋ a sulu, ‘Mi kuhiaŋ, ŋaa kenyiri. Mi jaŋ ti̱ŋ ŋ chimiŋ kala.’ ");
INSERT INTO sil_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","U kuhiaŋ-la fáu nisusuŋ woruŋ a joŋ chiŋ-la chɛu a ŋaa u mu. ");
INSERT INTO sil_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ŋii nɛ chiŋ tiina-la kuoru-la si joŋ chiŋ-la chɛu, u lii a ma na u tiŋtinni dɔŋɔ tiina si dii u chimiŋ siidi bui. U kɛŋ u gɛriŋ baŋŋa lɛ a bul duu ti̱ŋ u chimiŋ. ");
INSERT INTO sil_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","U tiŋtinni-dɔŋ-la ma tuu kpirimi u naadusuŋ nyuŋ a sulu a bul, ‘Ŋaa kenyiri, mi jaŋ ti̱miŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","U via aŋ kɛnu mu tɔ dia, aŋ bul see duu ti̱ŋ chiŋ-la. ");
INSERT INTO sil_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","U tiŋtinni-dɔŋsuŋ si na wii-la u si ŋaa, ba tuɔŋ kala chei. Ba mu bula pi ba kuhiaŋ wii-la kala si ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ŋii nɛ kuoru-la yiru a piɛsu a bul, ‘Ŋ-na tiŋtinna deeŋ, ŋ ŋaa ni-bɔŋ nɛ. Ŋ si sulmi, mi joŋ chiŋ-la kala ŋ si die a chɛŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bɛɛ nɛ tii ŋ-na bi wuo fá ŋ dɔŋɔ tiina-la nennige ari mi si fáŋ nennige ŋii?’ ");
INSERT INTO sil_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kuoru-la na baaniŋ woruŋ u nyuŋ a ŋaa ba kɛnu tɔ dia see duu ti̱ŋ chiŋ-la kala.” ");
INSERT INTO sil_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ŋii nɛ Yesu si, “Di ma bi sɛi di ma joŋ ma dɔŋsuŋ tiŋŋaa haachɛba chɛba ari ma tuɔŋ kala, mi Nyimma Wia si hɛ Wia-jaŋ lɛ ma jaŋ dɔgisɛma ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu si bul wiaa deeŋba dɛrɛ, u lii Galilii tiŋteeŋ a mu Judiya tiŋteeŋ a chol Jɔɔdaŋ fuo-la. ");
INSERT INTO sil_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ni-daŋ bira to u hariŋ. Ŋii nɛ u vaarɛ nialiŋ síi wiilu dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ ma sii kɔ u teeŋ a chichɛ di ba magisu a piɛsu a bul, “Di ŋ kɛŋ wii a tigɛ ŋ haala lɛ a chichɛ ŋ viau, u kɛŋ woŋbii nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu miira piɛsɛba, “Ma bi karima ari bua-la lɛ Wia si bugumo ŋaa dunia, nialiŋ u si ŋaa, ba fa ŋaa baal ari haal nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yesu bira si, “Ŋii nɛ tii baal-la jaŋ leŋ u nyimma ari u naaŋ dia aŋ ka ba di u haala mɛrɛ dɔŋɔ lɛ. Niaa deeŋba balia jaŋ kɛŋ chal-bala. ");
INSERT INTO sil_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ba bira bi jaŋ ŋaa niaa balia, see kubala. Nialiŋ saa Wia si kaa mɛrɛ dɔŋɔ lɛ, u bi maga di nuhuobiine kɛŋba pɔrɛ dɔŋɔ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ŋii nɛ u haritooro-la bira piɛsu wiiŋ deeŋ a bul, “Bɛɛ nɛ tii saa Moosis fa si di baala níi chɛ u via u haala, duu laa sipaaŋ a ŋmuŋsɛ teniŋ a pi haal-la aŋ-na viau?” ");
INSERT INTO sil_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ŋii nɛ Yesu bira bula piba a bul, “Ma tuɔŋ dolie. Ŋii nɛ tii Moosis fa sɛi di ma via ma haalaa. Ama dunia di-suomuŋ, ba fa bi ŋii ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mi bulaa pima, baala-na kala si via u haala aŋ bira jaa dɔŋɔ, u tiina juu haal-la haachɛ lɛ nɛ, see di haal-la ka ŋaa ha-chɔruŋ wu-ŋaalaa.” ");
INSERT INTO sil_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋii nɛ Yesu haritooro-la bula pu ari ŋii-na nɛ hɛ dimɛ, u bi maga di nuu jaa haal. ");
INSERT INTO sil_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ŋii nɛ Yesu miira bula piba a bul, “Wiiŋ deeŋ bi naga ari nuu-kala jaŋ wuo ŋaa. Nialiŋ Wia si joŋ doluŋ pa, ba duŋduŋa nɛ jaŋ wuo ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wii-la si tii baalaa bi haalaa ka jaa, ba yuga nɛ. Ba lul dɔŋsuŋ, ba paala bi haalaa wuo piŋ. Dɔŋsuŋ ma, nuhuobiinee nɛ ŋaaba ŋii, dɔŋsuŋ ma bi haalaa jaa a tiŋ Wia kuorii-la wiaa. Nii-la si jaŋ wuo laa wiiŋ deeŋ dii, u sɛi.” ");
INSERT INTO sil_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ŋii nɛ niaa sii kɔ Yesu teeŋ a kɛŋ ba haŋbiisiŋ kaa kɔ duu joŋ u nisiŋ daŋba lɛ a chuɔlɛ Wia piba. Ŋii nɛ u haritooro-la kpiaba lɛ. ");
INSERT INTO sil_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu si na ŋii, u bula piba a bul, “Má leŋ di haŋbiisi-la kɔ mi teeŋ. Ma síba kiru! Niaa deeŋba yiri nɛ hɛ Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ŋii nɛ u joŋ u nisiŋ daŋba lɛ aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baal kubala nɛ ma sie a kɔ Yesu teeŋ. Baal-la kɛŋ kiaa kiŋkɛŋ. Ŋii nɛ u piɛsɛ Yesu a bul, “Mi kuhiaŋ, wu-zɔŋ bɛɛ nɛ mi jaŋ ŋaa a kɛŋ miisi-la si bi dɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ŋii nɛ Yesu piɛsu a bul, “Bɛɛ nɛ tii ŋ piɛsɛmi wu-zɔmɔ-la ŋ si jaŋ ŋiŋaa wiaa? Ni-bala duŋduŋa nɛ zɔmɔ. Di ŋ níi chɛ di ŋ kɛŋ miisi-la si bi dɛrɛ, tuto wialiŋ Wia si leŋe ba ŋmuŋsa bil di maa to.” ");
INSERT INTO sil_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ŋii nɛ baal-la piɛsu, “Wu-bɛɛba nɛ?” Ŋii nɛ Yesu si, “Sí niaa kpu, sí ŋ dɔŋɔ tiina haala chɛ, sí gaa, di ŋ ŋaa daŋsia wii lɛ, sí wiaa nyia pɛ. ");
INSERT INTO sil_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Fifá ŋ nyimma ari ŋ naaŋ, a cho ŋ dɔŋɔ tiina ari ŋ si cho ŋ titia ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ŋii nɛ baal-la bula pi Yesu, “Mi kuhiaŋ, mi to wiaa deeŋba kala nɛ. Bɛɛ nɛ saa ka?” ");
INSERT INTO sil_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ŋii nɛ Yesu bula pu, “Di ŋ níi chɛ ŋ ŋaa ni-zɔŋ a sí wii-kala kɛŋ, joŋ ŋ kiaa kala yallɛ a joŋ moribie-la a pi summoo aŋ ku tomi. Ŋ nɛ ŋaa ŋii, ŋ jaŋ kɛŋ kiaa Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yesu si bul ŋii, baal-la tuɔŋ chei, u sii viiri, bɛɛ wiaa u kɛŋ kiaa nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ŋii nɛ Yesu bula pi u haritooro-la a bul, “Wutitii, mi bulaa pima, u ŋaa wu-duo nɛ ari nii-la si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi bira bulaa pima, u bi hɛi ari buŋtaŋŋa si jaŋ wuo to gɛri-hɛmiŋ buɔŋ lii ari u si hɛyɛ ŋii nii-la si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","U haritooro-la si nii wiaa deeŋba, ba faasa hiriki a piɛsɛ Yesu a bul, “U nɛ nagɛ ŋii, kubɛɛ nɛ saa Wia jaŋ laa ta?” ");
INSERT INTO sil_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu miira beŋba aŋ bul, “Wii-la si jaŋ kperi nuhuobiine, u bi Wia wuo kperi. Wia wuo wii-kala ŋaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ŋii nɛ Piita bula pu a bul, “Na, la-na leŋ la kuŋ-kala nɛ aŋ tuto ŋ hariŋ. Bɛɛ nɛ saa la jaŋ na?” ");
INSERT INTO sil_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ŋii nɛ Yesu bula pi u haritooro-la a bul, “Wutitii nɛ mi bulaa pima, di dunia falii-la nɛ yie, mi-na Nuhuobiine Bie jaŋ hɔŋ mi kuori-kpasa nyuŋ Wia pulumuŋ tuɔŋ. Bua-la lɛ, ma haritooro-la fii ari balia-la si to mi hariŋ, ma ma jaŋ hɔŋ kuori-kpasinniŋ fii ari balia nyuŋ a bibeŋ Iziral ta-geŋtisiŋ fii ari balia-la a dii ba sariya. ");
INSERT INTO sil_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bira nii-la kala si leŋ u diisiŋ koo u naaŋbiiriŋ koo u nyimma koo u naaŋ koo u biiriŋ koo u bagisiŋ a tiŋ mi wiaa, u tiina jaŋ bira na kiaa deeŋba naaŋsiiŋ zɔlɔ aŋ pɛ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama kuhiasiŋ yuga si jaŋ birimɛ haŋbiisiŋ. Haŋbiisiŋ ma yuga si jaŋ birimɛ kuhiasiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ŋii nɛ Yesu bira magɛ namaga a piba a bul di Wia kuorii-la nagɛ baal kubala si kɛŋ u baga nɛ chichuɔ-fiɛla. U lii chichɛ niaa di ba mu pɛrɛ u baga-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ba sɛi ari ba jaŋ mu pɛrɛ, ka u ti̱ŋba chɛ-bala time. Ŋii nɛ u leŋ ba mu u baga-la pipɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","U ku magɛ kerifi nibi, u bira lii a na niaa dɔŋsuŋ di ba chiŋ yɔbɔ tuɔŋ pɛi. Ba bi tiŋtimii kala ka tiŋ. ");
INSERT INTO sil_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ŋii nɛ u bula piba di ba ma mu a pɛrɛ u baga-la lɛ, ka di u ti̱ŋba, duu jaŋ piba ŋii kala si maga. Ŋii nɛ ba ma mu. ");
INSERT INTO sil_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kerifi fii ari balia yi, u bira lii a na niaa dɔŋsuŋ a ŋaa ba ma mu u baga-la. U bira lii kerifi batori bua-la lɛ a bira na niaa dɔŋsuŋ a ŋaa ba ma mu u baga-la. ");
INSERT INTO sil_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","U bira ku kpagɛ kerifi banɔŋ, u bira lii yɔbɔ tuɔŋ a na niaa dɔŋsuŋ ma di ba ha chiŋ dimɛ. Ŋii nɛ u piɛsɛba, “Bɛɛ nɛ tii ma chiŋ daha pɛi chichuɔŋ ari wiihɛyɛ kala, ma bi tiŋtimii kala ka tiŋ?” ");
INSERT INTO sil_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ŋii nɛ ba bula pu ari ba bi tiŋtiŋŋaa na di ba tiŋ. Ŋii nɛ u bula piba di ba ma mu a tiŋ u baga lɛ. Ba ma mu. ");
INSERT INTO sil_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Didaaniŋ si yie, ŋii nɛ baga-la tiina yirɛ nii-la síi beŋ u baga-la duu yirɛ nialiŋ si tiŋ u baga-la lɛ a ti̱ŋba, duu suomi nialiŋ si to hariŋ mu baga-la a ti̱ŋba aŋ-na mu yi nialiŋ si laa sipaaŋ mu baga-la. ");
INSERT INTO sil_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nialiŋ si to hariŋ mu baga-la, u ti̱ŋba chɛ-bala time. ");
INSERT INTO sil_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ŋii nɛ u si, ka nialiŋ si laa sipaaŋ mu baga-la, di ba ku laa ba time. Ba fa biina ari ba jaŋ laa kii haritooro-la, ama ba ti̱ŋba ma magɛ ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba ma laa moribie-la aŋ gugurimɛ wiaa nii-la baga-la lɛ ba si pɛrɛ teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ŋii nɛ ba bula pu a bul, “Niaa deeŋba si to hariŋ kɔ, ba tiŋ hawa kubala duŋduŋ nɛ, aŋ ka la-na tiŋ chichuɔŋ ari wiihɛyɛ kala, aŋ ka ŋ ti̱ŋla kala maga dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ŋii nɛ baga-la tiina bula pi ba dɔŋɔ a bul, “Jegile nii, mi bima gura. Ma sɛyɛ ari ma jaŋ tiŋ di wia juu nɛ aŋ laa chɛ-bala time. ");
INSERT INTO sil_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Má laa ma moribiee a viiri. Mii chɛ di mi ti̱ŋ baalaa deeŋba si to hariŋ kɔ ŋii titia mi si ti̱ŋma nɛ. ");
INSERT INTO sil_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mi bi woŋbiiŋ kɛnɛ di mi kɛŋ mi moribiee ti̱ŋ mi tuɔtɔrɛ wiaa? Koo ma yaraa bieru a tiŋ mi si kɛŋ zile wiaa nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ŋii nɛ Yesu bula dɛrɛ, “Kuhiasiŋ jaŋ birimɛ haŋbiisiŋ, haŋbiisiŋ ma jaŋ birimɛ kuhiasiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu si bul ŋii di ba hɛ woŋbiiŋ lɛ nɛ aa mu Jerusalɛm. Ŋii nɛ u kɛŋ u haritooroo fii ari balia duŋduŋa a suusa lii a bula piba woŋbiiŋ lɛ, ");
INSERT INTO sil_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Má jegili mi teeŋ. Laa mu Jerusalɛm nɛ. Di la nɛ yi dimɛ, ba jaŋ kɛŋ mi-na Nuhuobiine Bie a kaa mu pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba. Ba jaŋ dii mi sariya a ŋaa di ba kpumi ");
INSERT INTO sil_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aŋ kɛŋmi kaa mu hɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa nisiŋ lɛ. Ba jaŋ mɔŋmi. Ba jaŋ viirɛmi maa aŋ kpaasɛmi mɛrɛ daa-gɛsɛɛ nyuŋ, ka di mi sii suuŋ lɛ tapulaa batori chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ŋii nɛ Zɛbidii haala kɛŋ u biiriŋ balia kɔ Yesu teeŋ a kpirimi u sipaaŋ aŋ sulu duu pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ŋii nɛ Yesu piɛsu, “Wu-bɛɛ nɛ ŋŋ chɛ di mi ŋaa piŋ?” Ŋii nɛ u bul, “Ŋ si jaŋ dii Wia kuorii-la a hɔŋ ŋ kuori-kpasa nyuŋ, leŋ di mi biiriŋ balia ŋaa ŋ bubuɔŋ huhɔnnɔɔ, di dɔŋɔ hɔŋ ŋ na-diiŋ, di dɔŋɔ ma hɔŋ ŋ na-gua.” ");
INSERT INTO sil_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ŋii nɛ Yesu bula pi u biiriŋ a bul, “Ma bi jiŋ ku-la ma síi chɛ. Ma jaŋ wuo nyalima na hɛɛ-la mi si jaŋ na? Ma jaŋ wuo fo Wii-chuɔlɛ liiŋ ari ba si jaŋ fomi ŋii, koo?” Ba si, “Oo, la jaŋ wuo.” ");
INSERT INTO sil_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ ma bul. Hɛɛ-la mi si jaŋ na, u-na ma ma jaŋ na. Ama mi na-diiŋ ari mi na-gua huhɔnnɔ-la, mi dee bi jaŋ tuɔsɛba. Wia nɛ jaŋ liisɛba di ba hɔŋ dimɛ.” ");
INSERT INTO sil_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu haritooroo fii-la si nii Jeems ari Jɔɔŋ si bul wii-la, ba na baaniŋ ba nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ŋii nɛ Yesu yirɛ u haritooroo kala. Ba mu u teeŋ. U bula piba a bul, “Ma jiŋ nialiŋ si bi Ju̱u tiŋŋaa ŋaa, ba hɔŋ niaa nyuŋ nɛ. Ba kuhiasiŋ ma kɛŋba doluŋ. ");
INSERT INTO sil_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama u bi maga di ma ŋiŋaa ŋii. Ma tuɔŋ nii-la síi chɛ u ŋaa ma kuhiaŋ, u maga duu nɛ tiŋ tiŋtiŋŋaa pipima. ");
INSERT INTO sil_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma tuɔŋ nii-la ma síi chɛ u ŋaa ma tuɔŋ kuoro, u maga duu nɛ ŋaa ma tuɔŋ yomo. ");
INSERT INTO sil_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mi-na Nuhuobiine Bie, mi bi kɔ di mi chɛ niaa di ba tima pimi, mi kɔ di mi-na tima piba nɛ a suu a laa niaa miisaa yugɛ ta a piba.” ");
INSERT INTO sil_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ari u haritooroo si lii Jɛrikɔ lɛ, ni-daŋ nɛ to ba hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Di nyulimaa balia hɔŋ woŋbiiŋ niiŋ a nii di Yesu níi bal. Ŋii nɛ ba faasa yirɛ a bula pu a bul, “Yesu, Devit nihii, fála nennige.” ");
INSERT INTO sil_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ŋii nɛ ni-daŋ-la kpiaba lɛ di ba kɛŋ goŋ. Ama ba faasa yirɛ a kii ŋii a bul, “La Tiina, Devit nihii, fála nennige.” ");
INSERT INTO sil_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ŋii nɛ Yesu chiŋ aŋ yirɛba a piɛsɛba, “Bɛɛ kuŋ nɛ ma chɛ mi ŋaa pima?” ");
INSERT INTO sil_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ŋii nɛ ba bul, “La Tiina, laa chɛ di ŋ suri la siaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ŋii nɛ Yesu fába nennige a digi ba siaa lɛ. Ba siaa guu suri, ba tuto u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ŋii nɛ Yesu ari u haritooroo sii mu Jerusalɛm. Ba ku yi Bɛtifagi a ku yi peel kubala baa yirɛ Oliv. Ŋii nɛ Yesu liisɛ u haritooroo balia a tiŋba a bula piba a bul, “Má mu taŋ-la si hɛ ma sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Di ma nɛ mua, ma jaŋ na kakumo ari u bie di ba vɔbɔ a kii. Má puri a kaa kɔ pimi. ");
INSERT INTO sil_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Di nuu nɛ piɛsɛma, má bula pu ari ma Tiina níi chɛ. U jaŋ leŋ di ma kaa kɔ lima.” ");
INSERT INTO sil_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wiiŋ deeŋ ŋaa di wii-la nii-la fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ku ŋaa wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","U fa si, “Má bulaa pi Zaayɔŋ niaa di ba bee na, di ba kuoro níi kɔ ba teeŋ. U kɛŋ u titia muuri nɛ a jil kakumo a bira jil kakumo bie.” ");
INSERT INTO sil_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŋii nɛ Yesu haritooro-la mu a ŋaa wii-la Yesu si bula piba di ba ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba kɛŋ kakumo-la ari u bie kaa kɔ a joŋ ba gɛnniŋ daŋ kakumo-la ari u bie nyuŋ, Yesu jil. ");
INSERT INTO sil_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ni-daŋ-la jesiŋ joŋ ba gɛnniŋ a jɛrɛ woŋbiiŋ lɛ, ka dɔŋsuŋ ma keri pipaariŋ a ma kaa jɛrɛ woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ni-daŋ-la si laa Yesu sipaaŋ ari nialiŋ síi to u hariŋ suomo ŋiŋaa goŋ a bul, “Tabarikala Devit nihiŋ! Wia jaŋ pɛ nii-la síi kɔ la Tiina doluŋ lɛ. Má leŋ di la dɛnnɛ Wia!” ");
INSERT INTO sil_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu si muu juu Jerusalɛm, taŋ-la kala zigili. Ŋii nɛ niaa piɛsɛ a bul, “Kubɛɛ nɛ ŋla?” ");
INSERT INTO sil_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ŋii nɛ ni-daŋ-la bul, “Yesu si lii Nazarɛt si hɛ Galilii tiŋteeŋ lɛ, nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, u nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ŋii nɛ Yesu juu Wia-dia. Nialiŋ dɔŋsuŋ hɛ dimɛ a yiyallɛ kiaa, dɔŋsuŋ ma yuyɔɔ kiaa. Yesu kiriba kala ta ba lii. Baalaa ma hɛ dimɛ a yiyɛrɛ moribiee. Yesu ŋmoo ba teebulba lo. Baalaa dɔŋsuŋ ma yallɛ kokosuŋ. U ŋmoo ba ma kpasinniŋ a lo. ");
INSERT INTO sil_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ŋii nɛ Yesu bula piba a bul, “Ba ŋmuŋsa di Wia si, u dia jaŋ ŋaa lee-la niaa si jaŋ chuchuɔlɛ Wia, aŋ ka ma-na miira kaa birimɛ gaari-dia.” ");
INSERT INTO sil_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ŋii nɛ nyulimaa ari gbegisiŋ kɔ Yesu teeŋ Wia-dia lɛ. U vaarɛba. ");
INSERT INTO sil_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ama nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba si na wu-magila-la u síi ŋaa a bira na haŋbiisiŋ síi ŋaa goŋ ŋii Wia-dia lɛ, ba na baaniŋ. Haŋbiisi-la fa yirɛ, “Tabarikala Devit nihiŋ.” ");
INSERT INTO sil_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia ari Wia teniŋ kerichiba piɛsɛ Yesu a bul, “Ŋ nii wialiŋ ba síi bul nɛɛ?” Yesu bul, “Mi nia nɛ.” Ŋii nɛ Yesu ma piɛsɛba, “Ma bi Wia teniŋ karimaa? Ba ŋmuŋsɛ Wia teniŋ tuɔŋ a bul, ‘Wia jaŋ leŋ di bii-mulluŋ didɛnnɛ Wia.’ ” ");
INSERT INTO sil_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ŋii nɛ Yesu leŋba aŋ sii mu Bɛtani a chua dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Taŋ si pula, Yesu miira mu Jerusalɛm. U síi mu, losuŋ kɛnu woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U na tutogo duu chiŋ u sipaaŋ woŋbiiŋ niiŋ. U mu yi tutogo-la bubuɔŋ a wula beŋ di nɛnɛɛ tuo, see pipaariŋ. Ŋii nɛ u bul tia-la lɛ a bul, “A lii jiniŋ a kaa mumu, ŋ bira bi jaŋ nɛŋ.” Tia-la guu suu. ");
INSERT INTO sil_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","U haritooroo si na wiiŋ deeŋ, u ŋaaba wu-kpuŋkpere. Ba pipiɛsɛ dɔŋɔ a bul, “Ɛɛ nɛ tia-la guu suu lima ŋii?” ");
INSERT INTO sil_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, di ma nɛ kɛŋ yarida a bi tuɔsaa balia kɛnɛ, ma ma jaŋ wuo ŋaa wii-la si ŋaa tutogo-la lɛ. Ŋla ma duŋduŋa dee, ama ma jaŋ wuo paala bul peeliŋ deeŋ lɛ duu sii a mu tel muga tuɔŋ. U jaŋ ŋaa pima. ");
INSERT INTO sil_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kialiŋ-na kala ma si chuɔlɛ Wia a susul, di ma nɛ kɛŋ yarida, ma jaŋ naba.” ");
INSERT INTO sil_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ba si mu Jerusalɛm, Yesu mu juu Wia-dia. U si juu Wia-dia-la ŋii a didagɛ niaa, nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba ari Ju̱u tiŋŋaa kuhiasiŋ, ba kala sii kɔ u teeŋ a piɛsu a bul, “Dol bɛɛ nɛ ŋ kɛŋ a ŋiŋaa wiaa deeŋba? Kubɛɛ nɛ piŋ doluŋ ŋ kaa ŋiŋaa ŋii?” ");
INSERT INTO sil_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ŋii nɛ Yesu bula piba a bul, “Mi ma jaŋ piɛsɛma wu-bala. Di ma nɛ dagɛmi u bubuɔŋ, mi ma jaŋ dagɛma dol-la mi si kɛnɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ŋii nɛ u piɛsɛba a bul, “Jɔɔŋ, Wia lii-foori-la doluŋ, u lii nii nɛ? U lii Wia teeŋ nɛɛ koo u lii nuhuobiine teeŋ nɛɛ? Má dagɛmi.” Ba suomo kɛŋ wii-la lilɛrɛ dɔŋɔ lɛ aa bul, “Wu-bɛɛ nɛ laa chɛ di la bul? Di la nɛ bula pu a bul di Wia teeŋ nɛ u lii, u jaŋ piɛsɛla a bul, ‘Bɛɛ nɛ saa tii ma bi wialiŋ u si bula laa dii?’ ");
INSERT INTO sil_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Di la nɛ saa si u lii nuhuobiine teeŋ nɛ, fawulluŋ jaŋ kɛŋla a tiŋ ni-daŋ-la si chiŋ dimɛ wiaa. Niaa bula ari Jɔɔŋ fa sɛnɛ ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ŋii nɛ ba bula pi Yesu a bul, “La bi jiŋ.” Ŋii nɛ Yesu ma bula piba a bul, “Tɔɔ, mi ma bi jaŋ dagɛma dol-la mi si kɛnɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ŋii nɛ Yesu magɛ namaga a pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa a bul, “Baal kubala nɛ hɛ dimɛ a kɛŋ haŋbolibiisiŋ balia. U sii mu u bii-hiaŋ teeŋ a bula pu a bul, ‘Mi bii, mu baga jiniŋ a tiŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ŋii nɛ bile bul, ‘Mi bi jaŋ mu baga jiniŋ.’ U ŋii hariŋ lɛ, u tuɔŋ chei wii-la u si bula pi u nyimma lɛ aŋ sii mu baga-la. Ŋii nɛ ba nyimma bira mu a bul u bii-bie-la ma lɛ a bul duu mu baga. Ŋii nɛ bile bul duu jaŋ mu aŋ via. ");
INSERT INTO sil_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","31","Haŋbiisiŋ deeŋba balia tuɔŋ, kubɛɛ nɛ to ba nyimma niiŋ lɛ? Bɛɛ nɛ ma biinɛ?” Ŋii nɛ ba bula pu di u bii-hiaŋ-la nɛ. Ŋii nɛ Yesu bula piba a bul, “Wutitii, mi bulaa pima ari laŋpoo lilaaraa ari jagumuloba jaŋ laa sipaaŋ ma lɛ a juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bɛɛ wiaa Jɔɔŋ Wia lii-foori-la kɔ a dagɛma woŋbii-titii-la nɛ ma si jaŋ to, aŋ ka ma bi u wiaa laa dii, ama laŋpoo lilaaraa ari jagumuloba, ba laa u wiaa dii. Ma si paala na ba si laa u wiaa dii ŋii, aŋ ka ma ha bi birima di ma laa u wiaa dii.” ");
INSERT INTO sil_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ŋii nɛ Yesu bira magɛ namaga dɔŋɔ a bul, “Baal kubala nɛ bil baga a chɔŋsɛ kiaa si kɛŋ nɛnɛɛ yugɛ a nagɛ chichuɛŋ. Ba yiyirɛ gireps. U saa ligɛ baga-la golli nɛ. U lu bua baga-la tuɔŋ di ba chagɛ tii-nɛnɛ-la liiŋ hihɛ. U ma saa lusuŋ nyuŋ dia a hɔnɔ pɔ. Ŋii nɛ u paa niaa a hɛ u baga-la tuɔŋ di ba titiŋ. Ka u mu taŋ dɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tii-nɛnɛ-la biiniŋ si yie, u tiŋ u dia tiŋtinnaa di ba mu tiŋtinna-la teeŋ di ba mu laa tii-nɛnɛ-la kaa kɔ. Ba mu. ");
INSERT INTO sil_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ba kɛŋ dɔŋɔ a ŋmobu, a kpu dɔŋɔ, a yagɛ dɔŋɔ ari tabiaa a kpuu. ");
INSERT INTO sil_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ŋii nɛ u tiŋ niaa dɔŋsuŋ a wasa kii buŋbuŋ-la. Ba ŋaa ŋii titia nialiŋ ma lɛ. ");
INSERT INTO sil_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ŋii hariŋ lɛ nɛ u tiŋ u bie. U biina duu bie nɛ mua, ba jaŋ zilu. U ma bira mu. ");
INSERT INTO sil_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tiŋtinna-la si na bile, ba bula pi dɔŋɔ a bul, ‘Di baga-la tiina nɛ suba, bie deeŋ nɛ jaŋ dii u kiaa. Má kɔ di la kpuu. Di la nɛ kpuu, la nɛ jaŋ miira tii u kialiŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba kɛŋ bile a joŋu yuo ta baga-la hariŋ a kpuu.” ");
INSERT INTO sil_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ŋii nɛ Yesu piɛsɛba, “Di baga-la tiina nɛ kɔ, ɛɛ nɛ u jaŋ ŋaa baga tiŋtinna-la lɛ?” ");
INSERT INTO sil_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŋii nɛ ba bula pu a bul, “U jaŋ kɔ a kpu ni-bɔmɔ-la aŋ joŋ baga-la a pi ni-tania. Di tii-nɛnɛɛ-la biiniŋ nɛ yi, ba jaŋ kɛŋ tii-nɛnɛ-la kaa mu pu.” ");
INSERT INTO sil_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ŋii nɛ Yesu piɛsɛ nialiŋ si nii namaga-la, “Ma bi Wia teŋ-la karimaa? a mu yi lee-la ba si bul ŋla: ‘Tiebii-la dii-saaraa si via, u nɛ miira ku ŋaa tiebii-duoŋ ba si joŋo bil dia geŋtine. La Tiina Wia tiŋtiŋŋaa nɛ ŋii. U ŋaala wu-kpuŋkpere nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ŋii nɛ Yesu bula pi nialiŋ a bul, “Wia jaŋ kɛŋ u kuorii-la laa ma teeŋ, a joŋo pi nialiŋ si jaŋ to Wia niiŋ woruŋ a ŋiŋaa wialiŋ si jaŋ dagɛ ari ba birima lii ba haachɛba lɛ nɛ.  ");
INSERT INTO sil_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nii-la si tel tiebii-la nyuŋ, u tiina jaŋ yɛrɛ muno muno. Di tiebii-la ma nɛ tel nuu-kala nyuŋ, u jaŋ yɛrɛ u tiina muno muno.” ");
INSERT INTO sil_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Farisii tiŋŋaa nii Yesu si magɛ namaga-la a jiŋ ari ba wiaa nɛ u bubul ŋii. ");
INSERT INTO sil_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ŋii nɛ ba wiwalimɛ di ba kɛnu kaa mu tɔ dia. Ama ba faa fá ni-daŋ-la si hɛ dimɛ, bɛɛ wiaa ni-daŋ-la joŋ Yesu ari u ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ŋii nɛ Yesu bira magɛ namaga dɔŋɔ a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","U si, “Wia kuorii-la nagɛ kuoru kubala nɛ. U bie jaa haala. Ŋii nɛ u ŋaa ba gbigbieli ha-jaari gbiele a ŋaa ba yirɛ niaa di ba kɔ gbiele-la. ");
INSERT INTO sil_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ba si ŋaa kudiile-la dɛrɛ, u tiŋ u tiŋtinnaa di ba mu yirɛ nialiŋ u si yira, ari ba ŋaa siri di ba gbieli gbiele-la nɛ. Ba si mu yirɛba, ba via. ");
INSERT INTO sil_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ŋii nɛ u bira tiŋ u tiŋtinnaa dɔŋsuŋ di ba mu bula pi nialiŋ u si yira di ba kpu nɛ-belliŋ ari nɛ-niiniŋ kala nɛ a ŋaa kudiile-la dɛrɛ, di ba kɔ ha-jaari gbiele-la. ");
INSERT INTO sil_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ŋii nɛ nialiŋ u si yira bira via di ba mu aŋ titiŋ ba tiŋtiŋŋaa. Dɔŋɔ sii mu u baga, dɔŋɔ ma sii mu u kiaa di-yalliŋ. ");
INSERT INTO sil_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka dɔŋsuŋ ma kɛsɛ kuoro dia tiŋtinna-la a ŋmooba aŋ kpuba. ");
INSERT INTO sil_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ŋii nɛ kuoru-la na baaniŋ a ta u laali-yuoroo. Ba mu kpu nialiŋ si kpu u dia tiŋtinna-la aŋ nyigɛ ba taŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋii nɛ u yirɛ u tiŋtinnaa dɔŋsuŋ a bira bula piba, ‘Mi gbiele kudiile-la ŋaa siri nɛ, ama nialiŋ mi si yira bi maga di ba kɔ gbiele-la. ");
INSERT INTO sil_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Má saa lii mu woŋbii-porunuŋ a yirɛ nialiŋ kala ma si na dimɛ a bula piba di ba kɔ a dii kudiile-la.’ ");
INSERT INTO sil_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ŋii nɛ tiŋtinna-la lii woŋbii-porunu-la a yirɛ nialiŋ kala ba si na lee-la, ni-zɔŋŋɔɔ ari ni-bɔŋŋɔɔ kala. Ŋii nɛ ba kala ku juu su̱ dia-la lɛ ba fa síi gbieli gbiele-la. ");
INSERT INTO sil_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ŋii nɛ kuoru-la juu duu na nialiŋ si kɔ a na baal kubala duu bi ha-jaari gbiele gɛriŋ laala. ");
INSERT INTO sil_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","U piɛsu a bul, ‘Mi naŋdɔŋ, ɛɛ nɛ ŋ ŋaa ku juu daha aŋ bi ha-jaari gbiele gɛriŋ laala?’ Baal-la tɔrɛ u niiŋ. ");
INSERT INTO sil_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ŋii nɛ kuoru-la bula pi u tiŋtinnaa a bul, ‘Má kɛŋ baala deeŋ a vɔɔ u nisaa ari u naasiŋ a joŋu yuo ta jeeŋ hariŋ birimiŋ tuɔŋ duu pina yiyel aŋ didiŋ u nyilaa.’ ” ");
INSERT INTO sil_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ŋii nɛ Yesu bula dɛrɛ aŋ bul, “Ba yie yirɛ niaa yugɛ nɛ, ama ba tuɔŋ ba yie tuɔsɛ niaa baŋmɛnɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ŋii nɛ Farisii tiŋŋaa sii lii a vuurɛ ŋii ba si jaŋ magisɛ Yesu a bɛrɛ kɛnu ari wu-piɛsaa. Ŋii nɛ ba tiŋ ba haritooroo dɔŋsuŋ ari Hɛrɔd ma haritooroo dɔŋsuŋ di ba mu Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ŋii nɛ ba kɔ u teeŋ a piɛsu a bul, “La kuhiaŋ, la jima di ŋ kɛŋ wutitii nɛ a didagɛ Wia tonuŋ woŋbii-titii-la. Ŋ sipaaŋ tuo nuu lɛ. Ŋ bi ni-bal síi ka fá. ");
INSERT INTO sil_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Saa bula pila ari u ŋaa woŋbii nɛɛ di la ti̱ŋ laŋpoo a pi Rom tiŋteeŋ kuori-baliŋ ba síi yirɛ Siiza? Ɛɛ nɛ ŋ ma biinɛ?” ");
INSERT INTO sil_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu fa jiŋ ba tuɔbiiŋ-bɔmɔ-la nɛ a bula piba a bul, “Ma kaŋfugi timma! Bɛɛ nɛ tii maa magisɛmi? ");
INSERT INTO sil_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Má kɛŋ ma laŋpo-la moribiiŋ kaa kɔ di mi bee na.” ");
INSERT INTO sil_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ba kɛŋ dɔŋɔ kaa kɔ. Ŋii nɛ u piɛsɛba, “Kubɛɛ nyuŋ nɛ hɛ dimɛ? Kubɛɛ yiriŋ ma nɛ ba tuuro hɛ moribii-la lɛ?” ");
INSERT INTO sil_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ŋii nɛ ba bul di Siiza yiriŋ nɛ. U bula piba a bul, “Tɔɔ, má joŋ Rom tiŋteeŋ kuori-bal-la kiaa pu aŋ joŋ Wia ma kiaa pu.” ");
INSERT INTO sil_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu si bul ŋii, u ŋaaba wu-kpuŋkpere ba sii viiri. ");
INSERT INTO sil_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chɛɛ-la titia nialiŋ dɔŋsuŋ ba síi yirɛ Sadusii tiŋŋaa, ba kɔ u teeŋ. Sadusii tiŋŋaa yie si di nuu nɛ suba, u bira bi sii. Ba piɛsu wiaa a bul, ");
INSERT INTO sil_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“La kuhiaŋ, Moosis fa si di baala nɛ jaa haala, di haal-la ari baal-la nɛ bi bii lula, aŋ ka di baal-la suu, u maga di u ŋaana joŋ yo-haal-la jaa nɛ. Di u lul biiriŋ pi u maala-la si suba, biiri-la jaŋ chiŋ u nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naaŋbiiriŋ balipɛ nɛ fa hɛ dimɛ. Ba kala ŋaa baalaa. Ba naaŋ kubala, ba nyimma kubala. Ba kuhiaŋ jaa haala. Ba di haal-la bi bii lula, aŋ ka u suu. U si suba, u ka haal-la a pi u ŋaana dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Liamiŋ ma suu. Torimuŋ tiina ma joŋ haal-la jaa. U ma ŋii titia nɛ. Naaŋbiiri-la balipɛ kala nɛ jaa haal-la. U bi lula. ");
INSERT INTO sil_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ŋii hariŋ lɛ nɛ haal-la ma titia suu. ");
INSERT INTO sil_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tapulii-la niaa si jaŋ sii suuŋ lɛ, baalaa deeŋba balipɛ tuɔŋ, kubɛɛ nɛ jaŋ tii haal-la? Ba kala balipɛ nɛ jaau.” ");
INSERT INTO sil_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ŋii nɛ Yesu bula piba a bul, “Ma bi Wia teniŋ jiŋ. Ma ma bi Wia doluŋ jiŋ. Ŋii nɛ tii ma yeŋŋi. ");
INSERT INTO sil_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tapulii-la niaa si jaŋ sii suuŋ lɛ, baalaa bira bi jaŋ jaa haalaa, haalaa ma bira bi jaŋ jaa balaba. Ba kala jaŋ nagɛ Wia tiŋdaaraa si hɛ Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ŋii nɛ Yesu bula piba a bul, “Na ma piɛsɛmi nialiŋ si jaŋ sii suuŋ lɛ wiaa nɛ. Ma bi karimɛ wialiŋ Wia fa si bula pi niaa u teniŋ lɛɛ? ");
INSERT INTO sil_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","U fa si duu nɛ ŋaa Abiraham Wia ari Aizik Wia ari Jekɔb kala Wia. (Bua-la lɛ u si bul ŋii di Abiraham ari Aizik ari Jekɔb fa suba nɛ.) Wiaa deeŋba u si bula, ba bubuɔŋ nɛ di Abiraham ari Aizik ari Jekɔb bira sii suuŋ lɛ nɛ a hɛ Wia kuorii-la tuɔŋ. Wia bi jaŋ wuo ŋaa nialiŋ si suba Wia, u ŋaa ni-weyee Wia nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ni-daŋ-la si nii ŋii u síi dagɛ niaa, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisii tiŋŋaa si nia ari Yesu bul wiaa lo Sadusii tiŋŋaa ba ŋaa fuii, ba kala ku pɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋii nɛ Wia teniŋ kerichiba dɔŋɔ wiwalimɛ duu magisɛ Yesu a pipiɛsu wiaa. ");
INSERT INTO sil_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","U piɛsɛ Yesu a bul, “Kuhiaŋ, wialiŋ Wia si dagɛ niaa baa to, kubɛɛ nɛ ŋaa ba tuɔŋ siifiaŋ wiiŋ?” ");
INSERT INTO sil_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ŋii nɛ Yesu bul, “‘Kɛŋ ŋ tuɔŋ kala ari ŋ tuɔbiinaa kala ari ŋ wii-wii-kala a cho ŋ Tiina Wia.’ ");
INSERT INTO sil_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wialiŋ Wia si dagɛ niaa baa to, ba tuɔŋ wu-baliŋ ari ba tuɔŋ buŋbuŋ nɛ ŋii ari ba tuɔŋ siifiaŋ wiiŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wu-liamiŋ ma nɛ ŋla: ‘Cho ŋ dɔŋɔ tiina ari ŋ si cho ŋ titia ŋii.’ ");
INSERT INTO sil_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto ari wialiŋ kala nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba kala lii wiaa deeŋba baliamiŋ tuɔŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisii tiŋŋaa ha si hilimi ŋii, Yesu ma piɛsɛba a bul, ");
INSERT INTO sil_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Bɛɛ nɛ ma biinɛ Kirisito, nii-la Wia si liisa wiaa? Kubɛɛ doho nuu nɛ u ŋaa?” Ŋii nɛ ba bul duu ŋaa Devit doho nuu nɛ. ");
INSERT INTO sil_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ŋii nɛ Yesu bira piɛsɛba a bul, “Bɛɛ nɛ saa tii Wia Diŋ-zɔŋ-la fa dagɛ Devit duu kɛnu yirɛ u Tiina? ");
INSERT INTO sil_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ŋla nɛ u bul: ‘Mi Tiina Wia bula pi mi Tiina duu hɔŋ u sɛmɛ, ni-duoŋ di-hɔnuŋ, see duu yuo dii u diŋdɔŋŋɔɔ kala dɛrɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit titia si yirɛ nia deeŋ u Tiina, ɛɛ nɛ saa u jaŋ wuo ŋaa u nihiŋ duŋduŋa?” ");
INSERT INTO sil_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu si bul ŋii, nuu-kala bira bi wii wuo bul. A chiŋ tapulii-la kala a kaa mu, nuu-kala ma bira bi nyu-duoŋ kɛnɛ duu piɛsu wii-kala. ");
INSERT INTO sil_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ŋii nɛ Yesu bula pi ni-daŋ-la ari u haritooroo a bul, ");
INSERT INTO sil_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wia teniŋ kerichiba-la ari Farisii timma-la, ba nɛ ŋaa nialiŋ síi dagɛ wialiŋ Moosis fa si bile di niaa tuto. ");
INSERT INTO sil_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ŋii wiaa ma maga di ma to wialiŋ kala ba si bula pima di ma ŋaa, ama ma sí ba wu-ŋaalaa chesu, bɛɛ wiaa ba titia bi wialiŋ ba síi dagu ka to. ");
INSERT INTO sil_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba yie vɔɔ chugi-yuŋoo nɛ a kaa chuŋ niaa, ama ba titia bi chɛ di ba pɛba lɛ a laa chuga-la. ");
INSERT INTO sil_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba yie ŋaa wii-kala di niaa naba nɛ. Ba yie ŋmuŋsɛ Wia niiŋ wiaa a hɛ teŋ-jalaa lɛ a kaa vuvɔɔ ba gɛnniŋ nisaa lɛ ari ba nyuŋ-chuuluŋ lɛ aŋ leŋ ba gɛnniŋ juɔsaa ma duomi duomi. ");
INSERT INTO sil_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Di niaa nɛ yirɛba di ba ku dii kiaa, ba cho di ba hɔŋ ni-balaa di-hɔnɔɔ. Ba nɛ juu Wii-chuɔlɛ diisiŋ maa, ba cho di ba hɔŋ ni-balaa di-hɔnɔɔ. ");
INSERT INTO sil_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba yie chichɛ di niaa chuchuɔlɛba aŋ jujoŋba jirima niaa tuɔŋ aŋ yiyirɛba kerichiba. ");
INSERT INTO sil_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama ma-na sí leŋe di niaa kɛŋma kaa yirɛ kerichiba. Ma kala ŋaa naaŋbiiriŋ nɛ. Ma kala kerichi ŋaa kubala nɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","U saa bi maga di ma yirɛ nuu-kala ma nyimma dunia deeŋ lɛ, bɛɛ wiaa ma Nyimma ŋaa kubala nɛ a hɛ Wia-jaŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma bira sí nuu-kala yirɛ ma kuhiaŋ, bɛɛ wiaa ma kuhiaŋ nɛ ŋaa Kirisito, nii-la Wia si liisa. ");
INSERT INTO sil_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","U maga di ma tuɔŋ kuhiaŋ nɛ birimɛ haŋbie a tiŋ tiŋtiŋŋaa pipima. ");
INSERT INTO sil_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nii-la kala síi bigisi u titia lɛ, Wia jaŋ kɛnu muuri, ka nii-la ma si kɛŋ u titia muuri, Wia jaŋ ŋaa duu yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Ma kɛŋ Wia kuorii-la dia-boro yagɛ nɛ di niaa sí juu, bɛɛ wiaa ma titia bi chɛ di ma juu, aŋ bira pɔ di nialiŋ síi walimɛ di ba juu, di ba ma sí juu.  ");
INSERT INTO sil_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ma Wia teniŋ kerichiba-la ari ma Farisii timma-la, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Ma yie kɛŋ yo-haalaa kiaa laa didii a yie fugo chuɔlɛ Wia didieni. Bua-la lɛ Wia si jaŋ dii ma sariya, ma nɛ jaŋ na hɛɛŋ a kii nuu-kala. ");
INSERT INTO sil_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","16","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Ma yie sii a duori liiŋ a mu tiŋteyee dɔŋsuŋ a bul Wia wiaa dimɛ. Di ni-bala nɛ laa dii, ma yie leŋ u wasa bɔŋ a nagɛ ma si nagɛ ŋii nɛ. Wia ma jaŋ joŋu hɛ nyiniŋ lɛ ari u si jaŋ joŋma hɛ ŋii. Ma nyuluŋ sipaa-laaraa, ma jaŋ na hɛɛŋ. Ma yie bul, ‘Di nuu nɛ ŋmiɛsɛ Wia-dia, u bi ŋmiaŋ ŋaa, ama duu nɛ ŋmiɛsɛ sɛlimɛ kialiŋ si hɛ Wia-dia tuɔŋ, u chaasa ŋmiɛsɛ ŋmiaŋ nɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ma nyuluŋ-tɔɔ nɛ! Sɛlimɛ kialiŋ si hɛ Wia-dia tuɔŋ ari dia-la si ŋaa sɛlimɛ-la bi disinniŋ kɛnɛ, deeŋba balia tuɔŋ kubɛɛ nɛ yuga? ");
INSERT INTO sil_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma bira bula di nuu nɛ ŋmiɛsɛ koru-la lɛ ba si kpu pusuŋ pipi Wia, u bi chaasa ŋmiɛsɛ ŋmiaŋ, ama duu nɛ ŋmiɛsɛ ku-la ba si yie joŋo daŋ koru-la nyuŋ a pi Wia, u chaasa ŋmiɛsɛ ŋmiaŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ma nyulimaa, ku-la ba si yie joŋo daŋ koru-la nyuŋ ari koru-la si ŋaa di ku-la bi disinniŋ kɛnɛ, kiaa deeŋba balia tuɔŋ kubɛɛ nɛ yuga? ");
INSERT INTO sil_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ŋii wiaa di nuu nɛ ŋmiɛsɛ koru-la lɛ ba si yie kpu pusuŋ pipi Wia, u yie ŋmiɛsɛ ba di ku-la kala nɛ ba si yie joŋo daŋ u nyuŋ a pi Wia. ");
INSERT INTO sil_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Di nuu nɛ bira ŋmiɛsɛ Wia-dia, u ŋmiɛsɛ Wia dia-la ari Wia kala nɛ, bɛɛ wiaa Wia hɛ dia-la lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Di nuu nɛ bira ŋmiɛsɛ Wia-jaŋ, u ŋmiɛsɛ Wia kuori-kpasa-la ari nii-la si hɔŋ u lɛ ma nɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Di ma jaa pipaari-la suɔra si sima, ari pipaari-la si hɛyɛ, ari pipaa-diilee, ma yie kɛŋba kala kaa kpaa leree fii fii a joŋ ba kuŋ-kala leriŋ dɔŋɔ a pi Wia aŋ via di ma to siifiaŋ wialiŋ Moosis fa si bile pima di ma tuto. Ba nɛ ŋla: Má to wutitii woŋbiiŋ a fá niaa nennige a laa Wia dii. U maga di ma kpaa ma kialiŋ leree fii fii nɛ a joŋ kubala pi Wia, ama u bi maga di ma via wutitii woŋbiiŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ma nyuluŋ sipaa-laaraa! Ma yie chuori ma siniŋ a liisɛ naŋchuɔsuŋ kala ta aŋ bi buŋtaŋŋaba na aŋ liliŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Ma yie chɛsɛ ma nyunyualusuŋ ari ma gbaŋsiŋ hariŋ woruŋ di ba zɔŋ aŋ bi ba tuɔŋ ka tiisi, ka ba tuɔŋ kala birisi. Ma nagɛ nyunyualuŋ ari gbaŋsiŋ deeŋba nɛ. Ma yaraa nɛ zɔmɔ, ama ma tuɔŋ lɛ ma to ma tuɔtɔruŋ lɛ a gigaa niaa kiaa. ");
INSERT INTO sil_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ma nyuluŋ Farisii tiŋŋaa, má laa sipaaŋ tiisi ma nyunyualuŋ tuɔŋ aŋ-na tiisi hariŋ ma duu zɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma kaŋfugi timma-la, ma jaŋ na hɛɛŋ. Ma nagɛ vaamaa ba si kɛŋ tuɔruŋ bugɛ nɛ. Ba hariŋ zɔŋ, aŋ ka ba tuɔŋ kala su̱ ari haŋgbelee ari ni-suunuŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ŋii titia nɛ ma ma nagɛ niaa teeŋ. Di ba nama, ba yie biinɛ di ma ŋaa ni-zɔmɔ nɛ, ka ma tuɔŋ su̱ ari wu-bɔŋŋɔɔ ari kaŋfugi wu-ŋaalaa. ");
INSERT INTO sil_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ma Wia teniŋ kerichiba ari ma Farisii tiŋŋaa, ma jaŋ na hɛɛŋ. Ma kpu nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, aŋ ka ma saa ba vaamaa. ");
INSERT INTO sil_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma si, ‘Di la nɛ fa hɛ dimɛ bua-la lɛ la naabalimaba fa si hɛ ba miisiŋ lɛ, la fa bi jaŋ ŋaa ŋii ba si ŋaa a kpu nialiŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ama ma si yirɛba ma naabalimaba ŋii, ma sɛnɛ sɛi ari ma ŋaa nialiŋ si kpu nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba doho niaa nɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Má saa mu a dɛrɛ wialiŋ ma naabalimaba fa si suomo a ŋiŋaa. ");
INSERT INTO sil_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ma ni-bɔŋŋɔɔ ari ma ni-bɔŋŋɔɔ biiriŋ, ma biina ari ma jaŋ wuo fá kagɛ Wia nyiŋ-la lɛɛ? Ai. ");
INSERT INTO sil_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ŋii wiaa, mi jaŋ bira tiŋ nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ari wu-jinnaa ari kerichiba. Ma jaŋ kpu dɔŋsuŋ a kɛŋ dɔŋsuŋ kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ, a viirɛ dɔŋsuŋ maa, ma Wii-chuɔlɛ diisiŋ lɛ, a to naasiŋ dɔgisɛ dɔŋsuŋ maa tasiŋ dɔŋsuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wia jaŋ dɔgisɛ jiniŋ niaa a tiŋ ba si kpu niaa, a chiŋ bua-la lɛ ba si kpu nialiŋ si bi wii cheye, a suomi Ebil lɛ a kaa kɔ bua-la lɛ ba si kpu Zekaraya, Berakia bie. Ba kpuu Wia-dia tuɔŋ a kpagɛ koru-la nyuŋ ba si yie nyigɛ pusuŋ pipi Wia nɛ. Ba cheeriŋ jaŋ hɛ ba nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wutitii nɛ mi bulaa pima, dɔgisunu-la Wia si jaŋ dɔgisɛ ni-kpuuraa deeŋba, u jaŋ joŋo dɔgisɛ jiniŋ niaa. ");
INSERT INTO sil_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma Jerusalɛm niaa, ma kpu nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ a joŋ tabiaa a yagɛ tiŋdaara-la Wia si tima di ba kɔ ma teeŋ. Naaŋsiiŋ yuga nɛ mi fa cho di mi chu tɔ ma niaa kala ari ji̱miŋ si yie chu tɔ u biiriŋ ŋii, ka ma bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bee na, Wia jaŋ leŋ ma taŋ pima. ");
INSERT INTO sil_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma bira bi jaŋ nami see bua-la lɛ ma si jaŋ chuɔlɛmi a bul, ‘Wia jaŋ pɛ nii-la síi kɔ la Tiina Wia doluŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ŋii nɛ Yesu sii lii Wia-dia-la lɛ a viiri. Ŋii nɛ u haritooroo kɔ a bula pu duu bee na Wia-dia-la si zɔmɔ ŋii, u jáŋ kala ma saa zɔmɔ ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ŋii nɛ Yesu si, “Oo, ma bee na u si zɔmɔ ŋii nɛ. Wutitii, mi bulaa pima, ba jaŋ ŋmoo jaŋ-la kala lo. Ba bi jaŋ leŋ di tiebii-bala ma ka daŋ u dɔŋɔ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ŋii nɛ Yesu mu hɔŋ Oliv peel-la nyuŋ. U haritooroo luɔra kɔ u teeŋ a bira piɛsu a bul, “Bua bɛɛ lɛ nɛ wiaa deeŋba jaŋ ŋaa? Bɛɛ kiaa nɛ la jaŋ na a jiŋ bua-la lɛ ŋ si jaŋ kɔ, ari bua-la lɛ dunia si jaŋ dɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ŋii nɛ Yesu bula piba a bul, “Má kɛŋ ma titia woruŋ di nuu-kala síma nyisu. ");
INSERT INTO sil_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Niaa jaŋ yugɛ a kɔ a joŋ mi yiriŋ hɛ ari ba nɛ ŋaa Kirisito, a nyisɛ niaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma jaŋ nii ari laaliŋ hɛ daha a hɛ di-bolii. Di ma nɛ ku nii ŋii, ma sí leŋe di ma bɔyɛ joŋ. Wiaa deeŋba kala jaŋ ŋaa bal, ama dunia didɛriŋ ha dee ŋii. ");
INSERT INTO sil_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tiŋteeŋ dɔŋɔ niaa jaŋ sii a mu a yuo tiŋteeŋ dɔŋɔ niaa. Taŋ kuoro ari u niaa jaŋ sii giri a mu yuo kuoro dɔŋɔ ari u niaa. Losuŋ ma jaŋ juu. Tiŋteeŋ jaŋ zigili leree yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hɛɛŋ di-suomuŋ nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ba jaŋ kɛsɛma a joŋma hɛ niaa nisiŋ lɛ di ba dɔgisɛma aŋ kpu ma dɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tiŋtee dɔŋsuŋ niaa kala jaŋ bɛrɛma a tiŋ mi wiaa. Bua-la lɛ niaa jaŋ yugɛ a joŋ ba yarida ta, ba jaŋ joŋ dɔŋɔ yiyallɛ, a bɛrɛ dɔŋɔ maa. ");
INSERT INTO sil_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nialiŋ si nyia wiaa a bul di baa bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba jaŋ yugɛ a kɔ a nyisɛ niaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wu-bɔŋŋɔɔ jaŋ purikɛ. A tiŋ ŋii wiaa niaa fa si cho niaa ŋii, ba chonu-la jaŋ dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama nii-la kala si nyalimɛ a mu dɛrɛ, Wia jaŋ laau ta. ");
INSERT INTO sil_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ba jaŋ laa sipaaŋ bul Wia wu-zɔmɔ-la a tigɛ Wia kuorii-la lɛ lee-na kala di dunia nuu-kala nii, ka di dunia didɛriŋ-na yi. ");
INSERT INTO sil_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ma jaŋ na ku-lɔru-la, u wiaa Daniɛl fa si bula. Daniɛl fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Ba jaŋ joŋ ku-la bil Wia-dia lɛ, lee-la si bi disinniŋ kɛnɛ (lee-la nii-la si kɛŋ disinniŋ si bi maga duu mu). Ma nialiŋ si karimɛ wiaa deeŋba, ma jaŋ jiŋ ba bubuɔsaa. ");
INSERT INTO sil_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Di ma na ŋii, má leŋ di nialiŋ si hɛ Judiya lɛ, di ba fá jil peelee nyuŋ a faa. ");
INSERT INTO sil_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Di nuu nɛ hɛ u lusuŋ nyuŋ a nii wiaa deeŋba, di u nɛ ku tuu, duu sí u dia juu a chichɛ duu paa u kiaa dia lɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Di nuu-kala nɛ hɛ u baga lɛ a nii wiaa deeŋba, duu sí miira mu dia a chichɛ duu paa u gɛnniŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nialiŋ si kɛŋ luoroo ari nialiŋ si nɔgɛ biiriŋ, oi, ba jaŋ na hɛɛŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Má sul Wia di wiiŋ deeŋ sí yibiiniŋ koo chɛ-wiesiŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wia si ŋaa dunia a kuu lii jiniŋ, nuu-kala ha bi hɛɛ-yiri deeŋ na a nagɛ ŋii, ba bira bi jaŋ na hɛɛŋ ŋii a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Di Wia fa bi tapulia-la kere ta, ni-bala ma fa bi jaŋ ka. Ama nialiŋ Wia si liisa di baa tou, ba wiaa nɛ tii u keri tapulia-la ta. ");
INSERT INTO sil_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Di nuu-kala nɛ bula piŋ di ŋ beŋ daha a na Kirisito-la, koo di ŋ beŋ dimɛ a nau, síu yarida ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Niaa dɔŋsuŋ jaŋ sii fugo bul di ba nɛ ŋaa Kirisito, nii-la Wia si liisa. Dɔŋsuŋ ma jaŋ sii fugo bul di ba ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Ba jaŋ ŋaa wu-magilaa ari wu-kpuŋkperisiŋ kala a chichɛ di ba nyisɛ nialiŋ Wia si liisa di baa toba. ");
INSERT INTO sil_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wiaa deeŋba kala mi laa sipaaŋ bula pima nɛ, ka di bua-la-na yi. ");
INSERT INTO sil_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Má bee na, di niaa nɛ bula pima ari nii-la Wia si liisa nɛ hɛ giri-bine tuɔŋ, ma sí dimɛ mu, koo di ba nɛ bula pima ari u nɛ faa daha, ma sí laa dii, ");
INSERT INTO sil_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","bɛɛ wiaa bua-la lɛ mi-na Nuhuobiine Bie si jaŋ miira kɔ, u jaŋ nagɛ duonuŋ si ligisa, pulumuŋ chaanɛ wia nyuŋ ŋii a lii wii-pɔsuŋ a tuu wii-juuluŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lee-la kala ku-pua si pina, duunoo ma yie hihilimi nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ŋii nɛ Yesu bira bula piba a bul, “Tapulia-la hɛɛŋ deeŋ si jaŋ dɛrɛ, u bira bi jaŋ dieni, di taŋ nɛ pula maa, leriŋ jaŋ biri, chɛnɛ ma bira bi jaŋ pɔsɛ. Chɛŋwulaa jaŋ lii wia nyuŋ ku tuu titel. Ba jaŋ kiri wia nyuŋ kialiŋ kala si kɛŋ doluŋ di ba lii ba leree. ");
INSERT INTO sil_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ŋii nɛ ma jaŋ na mi-na Nuhuobiine Bie magiliŋ wia nyuŋ. Di dunia niaa nɛ nau, ba kala jaŋ yel. Ŋii lɛ nɛ ma jaŋ na mi-na Nuhuobiine Bie, di mi to duoŋbiliŋbaanaa tuɔŋ ku tuu. Mi jaŋ kɛŋ doluŋ yugɛ a chaanɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ŋii nɛ ba jaŋ ŋmuu nyil-baliŋ, a tiŋ Wia tiŋdaaraa di ba mu dunia sɛmɛ-na kala a kɛŋ nialiŋ kala Wia si liisa di baa tou a hilimi. ");
INSERT INTO sil_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Di ma na sɔjaamiŋ nɛ kuu tɔsɛ, ma jima ari liŋbaŋa yie nɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Namaga deeŋ dagɛma wu-jimiŋ nɛ. Di ma na wiaa deeŋba kala di baa ŋaa, ma jiŋ di mi-na Nuhuobiine Bie kpaga nɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wutitii mi bulaa pima, ma lɛɛlɛ niaa deeŋba si hɛ miisiŋ lɛ bi jaŋ suu, ka wiaa deeŋba ŋaa bal. ");
INSERT INTO sil_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wia nyuŋ ari tiŋteeŋ kala jaŋ dɛrɛ, ama wialiŋ mi si bula bi jaŋ lɛl. ");
INSERT INTO sil_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ama nuu-kala bi jaŋ jiŋ chɛɛ-la wiaa deeŋba si jaŋ ŋaa. Wia tiŋdaaraa si hɛ Wia-jaŋ ma paala bi jaŋ jiŋ, see mi Nyimma duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bua-la lɛ mi-na Nuhuobiine Bie si jaŋ miira kɔ, u jaŋ nagɛ bua-la lɛ Nowa fa si hɛ u miisiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ka di duonuŋ nii a su̱ dunia, nialiŋ dii kudiilee a nyunyua siniŋ. Baalaa ari haalaa ma jijaa dɔŋɔ a mu yi tapulii-la Nowa fa si juu liiŋ daboro-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba fa bi jiŋ wii-la kala si ŋaa see bua-la lɛ lii-la si ku pɛllɛ paa ba kala, ba suu. Ŋii titia nɛ jaŋ ŋaa bua-la lɛ mi-na Nuhuobiine Bie si jaŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bua-la lɛ baalaa balia jaŋ pipɛrɛ baga lɛ. Wia jaŋ joŋ dɔŋɔ aŋ leŋ dɔŋɔ ta. ");
INSERT INTO sil_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Haalaa balia ma jaŋ nunɔŋ munuŋ nɔmuŋ lɛ. Wia jaŋ joŋ dɔŋɔ aŋ leŋ dɔŋɔ ta. ");
INSERT INTO sil_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Má saa kɛŋ ma titia woruŋ, bɛɛ wiaa ma bi jiŋ tapulii-la ma Tiina si jaŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Di nuu nɛ fa jiŋ bua-la lɛ gaara si jaŋ ku gaa u kiaa u dia lɛ, u fa jaŋ hɔnɔ pɔ u dia. U fa bi jaŋ piŋ doŋ. U jaŋ wei a pɔ di gaaru-la sí ku juu a gaa u kiaa. ");
INSERT INTO sil_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Má ma saa ŋaa siri, bɛɛ wiaa mi-na Nuhuobiine Bie jaŋ kɔ bua-la lɛ ma si buu yiɛlɛ.” ");
INSERT INTO sil_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ŋii nɛ la Tiina Yesu miira piɛsɛba a bul, “Kubɛɛ nɛ saa ŋaa tiŋtinni-titii-la si jiŋ wiaa? U nɛ nii-la u kuhiaŋ si yie liisɛ duu bibeŋ u dia, aŋ pɛ pipi u tiŋtinni-dɔŋsuŋ ma kudiilee. ");
INSERT INTO sil_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Di tiŋtinni-la ŋaa wialiŋ u kuhiaŋ si dagu duu ŋaa, u tuɔŋ jaŋ tɔrɛ bua-la lɛ u kuhiaŋ-la si jaŋ miira kɔ. ");
INSERT INTO sil_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wutitii, mi bulaa pima, u kuhiaŋ-la jaŋ joŋ u kiaa kala hɛ tiŋtinna deeŋ nisiŋ lɛ duu bibeŋ. ");
INSERT INTO sil_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama di tiŋtinni-bɔmɔ-la nɛ bula pi u titia ari u kuhiaŋ-la jaŋ dieni ");
INSERT INTO sil_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aŋ suomo ŋmuŋmoo u tiŋtinni-dɔŋsu-la, baalaa ari haalaa, aŋ faasa didii kudiilee a nyua siniŋ bubugi, ");
INSERT INTO sil_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","duu ŋaa ŋii, u bi siri ŋaa gbɛrɛ u kuhiaŋ-la. U kuhiaŋ-la jaŋ kɔ tapulii-la lɛ u si bi yiɛla. ");
INSERT INTO sil_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U jaŋ dɔgisu woruŋ aŋ kɛnu kaa mu hɛ lee-la kaŋfugi timma-la si hɛ. Lee-la nɛ niaa jaŋ yel aŋ didiŋ ba nyilaa.” ");
INSERT INTO sil_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ŋii nɛ Yesu bira magɛ namaga. U si, “Bua kubala lɛ Wia kuorii-la jaŋ nagɛ ŋla: Haalaa fii nɛ fa hɛ dimɛ. Ba sii a paa ba chaanaa a mu di ba cheŋ ha-faliŋ bala, ha-jaari gbiele-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Haala-la deeŋba tuɔŋ banɔŋ yaarɛ, ka banɔŋ ma kɛŋ wu-jimiŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Banɔŋ-la si yaara, ba bi nuuŋ lɔgɔ kori, di ba chaanaa nɛ disa, di ba joŋo hɛ. ");
INSERT INTO sil_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama banɔŋ-la si kɛŋ wu-jimiŋ, ba lɔgɛ nuuŋ kori. ");
INSERT INTO sil_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ha-faliŋ bala-la bi lima kɔ. Ba gbɛrɛ gbɛrɛ lɔl aŋ joŋo piŋ doŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tita-siesee niaa yirɛ, ‘Má bee na baal-la níi kɔ, má ku lii chemu.’ ");
INSERT INTO sil_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ŋii nɛ haala-la kala sii a kɛŋ ba chaanaa milima ta di ba jil. ");
INSERT INTO sil_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ŋii nɛ ni-yaara-la bula pi wu-jinna-la a bul, ‘La chaanaa chɛ di ba disɛ nɛ, má pila nuuŋ mua.’ ");
INSERT INTO sil_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ŋii nɛ wu-jinna-la bula piba a bul, ‘Ai, ŋ bi pɔɔ nuu-la bi jaŋ yi la kala. Má mu yɔɔ ma titia nuuŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ŋii nɛ ba mu di ba yɔɔ. Ba si mua di ba yɔɔ nuu-la, ha-faliŋ bala-la kɔ. Haala-la banɔŋ fa si ŋaa siri, ba to u hariŋ a juu ha-jaari gbiele-la leriŋ, ka ba kɛŋ boiŋ tɔ. ");
INSERT INTO sil_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","U ŋii hariŋ lɛ haalaa banɔŋ-la ku-kaanaa ma kɔ a bul, ‘La Tiina, la Tiina, kɛŋ boro suro pila.’ ");
INSERT INTO sil_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ŋii nɛ u bul, ‘Wutitii, mi bulaa pima, mi bima jiŋ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ŋii wiaa má pɔ ma titia lɛ woruŋ. Ma bi jiŋ tapulii-la la Tiina Yesu si jaŋ kɔ.” ");
INSERT INTO sil_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ŋii nɛ Yesu bira magɛ namaga a tigɛ Wia kuorii-la lɛ. U si, “Bua kubala lɛ Wia kuorii-la jaŋ nagɛ baal kubala si kɛŋ u tiŋtinnaa nɛ. Tapulii kubala u sii duu vɛŋ woŋbiiŋ. Ŋii nɛ u yirɛ u tiŋtinna-la ba kɔ. U joŋ u kiaa hɛ ba nisiŋ lɛ di ba bibeŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U kɛŋ kialiŋ kaa kpaaba ŋii nuu-kala si wuo bibeŋ. U joŋ siidi bui zɔ-balia a pi dɔŋɔ duu bibeŋ, a joŋ siidi bui mahiŋ banɛsɛ a pi dɔŋɔ maa aŋ joŋ siidi bui mahiŋ balia a pi dɔŋɔ-la maa. Ŋii nɛ ka u vɛŋ u woŋbii-la. ");
INSERT INTO sil_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tiŋtinni-la si laa siidi bui zɔ-balia-la, u kaa mu a yɔɔ kiaa a yallɛ a na siidi bui zɔ-balia nyuuruŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tiŋtinni-la ma si laa siidi bui mahiŋ banɛsɛ-la, u ma kɛŋ u kiaa bibirimɛ, a ma na siidi bui mahiŋ banɛsɛ nyuuruŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama tiŋtinni-la si laa siidi bui mahiŋ balia-la, u-na kaa mu lu bua a joŋ moribie-la a hugi. ");
INSERT INTO sil_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","U diene woruŋ, ka tiŋtinna-la batori kuhiaŋ-la kɔ a yirɛba duu na ba kuŋ-kala si na nyuuruŋ magɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tiŋtinni-la si laa siidi bui zɔ-balia-la kɛŋ u kiaa ku juu aŋ bula pi u kuhiaŋ a bul, ‘Ŋ pimi siidi bui zɔ-balia nɛ, mi ma na siidi bui zɔ-balia nɛ pɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ŋii nɛ u kuhiaŋ-la bula pu a bul, ‘Ŋ ŋaa tiŋtinni-titii nɛ. Ŋ hɛ doluŋ nɛ a wuo beŋ kubii-bie-la nyuŋ woruŋ, mi jaŋ leŋ di ŋ bibeŋ ku-kɛnɛɛ. Ku juu di la di ŋ kala ninii sima.’ ");
INSERT INTO sil_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋii nɛ tiŋtinni-la ma si laa siidi bui mahiŋ banɛsɛ-la ma kɛŋ u kiaa kaa ku juu a bula pi u kuhiaŋ a bul, ‘Ŋ pimi siidi bui mahiŋ banɛsɛ nɛ. Mi ma na siidi bui mahiŋ banɛsɛ nɛ a pɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ŋii nɛ u bula pu maa, ‘Ŋ ma ŋaa tiŋtinni-titii nɛ, ŋ ma hɛ doluŋ nɛ a wuo beŋ kubii-bie-la nyuŋ woruŋ, mi ma jaŋ leŋ di ŋ bibeŋ ku-kɛnɛɛ. Ku juu di la di ŋ kala nii sima.’ ");
INSERT INTO sil_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ŋii nɛ tiŋtinni-la u si joŋ siidi bui mahiŋ balia pa, u ma ku juu a bul, ‘Mi kuhiaŋ, mi jima ari ŋ ŋaa ni-tɛrɛ nɛ, ŋ yie kukuŋ kialiŋ ŋ si bi duo nɛ aŋ pipaa kialiŋ lee-la ŋ si bi tima. ");
INSERT INTO sil_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ŋii nɛ tii mi fifáŋ a joŋ moribie-la a hugi tiŋteeŋ di ŋ kɔ. Laa ŋ moribiee.’ ");
INSERT INTO sil_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ŋii nɛ u kuhiaŋ-la bula pu a bul, ‘Ŋ ŋaa tiŋtinni-bɔŋ nɛ a kɛŋ yariwiiŋ. Ŋ jima ari mi yie kukuŋ kialiŋ mi si bi duo nɛ a paa kiaa lee-la mi si bi tima. ");
INSERT INTO sil_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ŋ si jiŋ ŋla lɛ, u fa maga di ŋ joŋ mi moribiee bil lee-la ba síi bil moribiee nɛ. Mi fa si miira kɔ ŋla, mi fa jaŋ laa moribie-la ari mi nyuuruŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ŋii-na má laa moribie-la u teeŋ a joŋo pi nii-la si kɛŋ siidi bui zɔ-banɛsɛ-la.’ ” ");
INSERT INTO sil_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ŋii nɛ Yesu bula piba a bul, “Nii-la si paala kɛŋ kiaa yugɛ nɛ, Wia jaŋ wasa chɛ a pɛ pu duu kaa yugɛ kiŋkɛŋ, ama nii-la si bi faasa kɛŋ kiaa yugɛ, muapilii-la ma u si kɛnɛ, Wia jaŋ kaa laa u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Má kɛŋ tiŋtinni-bɔmɔ-la a joŋu yuo ta birimiŋ tuɔŋ. Lee-la nɛ nialiŋ jaŋ yel aŋ didiŋ ba nyilaa. ");
INSERT INTO sil_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Di mi-na Nuhuobiine Bie nɛ dii mi kuoruŋ a kɔ, mi di Wia tiŋdaaraa kala jaŋ kɔ. Ŋii nɛ mi jaŋ hɔŋ mi kuori-kpasa nyuŋ a chaanɛ. ");
INSERT INTO sil_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dunia nuu-kala jaŋ ku hilimi mi sipaaŋ. Mi jaŋ kɛŋba kaa kpaa leree balia, ari pie-daara si yie kɛŋ u piesee pɔrɛ buunaa lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mi jaŋ leŋ di tuɔ-pul tiŋŋaa chiŋ mi na-diiŋ, ka di tuɔ-bɔŋ tiŋŋaa ma chiŋ mi na-gua. ");
INSERT INTO sil_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ŋii nɛ kuoro jaŋ bula pi nialiŋ si chiŋ u na-diiŋ a bul, ‘Má kɔ. Mi Nyimma Wia nɛ pɛma lɛ. Má ku dii Wia kuorii-la ba si wasa bilma lɛ dunia di-suomuŋ. ");
INSERT INTO sil_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bɛɛ wiaa, bua-la lɛ losuŋ fa si kɛŋmi, ma ŋaa kudiilee pimi mi dii, bua-la lɛ lii-nyuasuŋ ma fa si kɛŋmi, ma ŋaa liiŋ pimi mi nyua nɛ. Bua-la lɛ mi fa si ŋaa nuhuɔru, ma kɛŋmi woruŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bua-la lɛ mi fa kɛŋ yaribiree nɛ, ma joŋ gɛriŋ laalɛmi. Bua-la lɛ mi fa síi wiilu, ma beŋ mi nyuŋ nɛ, bua-la lɛ ba si kɛŋmi tɔ dia, ma ku nami nɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tuɔ-pul timma-la jaŋ piɛsɛmi a bul, ‘La Tiina, chɛ bɛɛ nɛ la naŋ di losuŋ kɛniŋ la joŋ kudiilee piŋ, chɛ bɛɛ nɛ lii-nyuasuŋ kɛniŋ la ŋaa liiŋ piŋ? ");
INSERT INTO sil_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Chɛ bɛɛ nɛ la naŋ di ŋ ŋaa nuhuɔru la kɛniŋ woruŋ, koo chɛ bɛɛ nɛ la ma naŋ di ŋ kɛŋ yaribiree la joŋ gɛriŋ laaliŋ? ");
INSERT INTO sil_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Chɛ bɛɛ ma nɛ la naŋ di ŋ wiilu, koo di ba kɛniŋ tɔ dia la ku naŋ?’ ");
INSERT INTO sil_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kuoru-la jaŋ bula piba a bul, ‘Wutitii nɛ mi bulaa pima, bua-la kala lɛ ma si ŋaa wu-zɔmuŋ a pi mi naaŋbiiriŋ deeŋba tuɔŋ nii-la si bi lee kɛnɛ, ma ŋaa ŋii pimi nɛ.’ ");
INSERT INTO sil_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ŋii nɛ u jaŋ bula pi nialiŋ si hɛ u na-gua a bul, ‘Má surisɛ mi sɛmɛ, Wia via ma wiaa nɛ. Má mu a juu nyiŋ-la si bi disɛ. Wia hɛ nyiŋ-la bil Sitaani ari u tiŋdaara-la nɛ di ba ku juu. ");
INSERT INTO sil_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bɛɛ wiaa bua-la lɛ losuŋ fa si kɛŋmi, ma bi kudiilee ŋaa pimi, bua-la lii-nyuasuŋ fa si kɛŋmi, ma bi liiŋ ŋaa pimi. ");
INSERT INTO sil_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bua-la lɛ mi fa si ŋaa nuhuɔru, ma bimi kɛnɛ woruŋ. Bua-la lɛ mi fa si kɛŋ yaribiree maa, ma bi gɛriŋ joŋo laalɛmi. Bua-la lɛ mi fa síi wiilu maa, ma bi ku nami. Bua-la lɛ ba si kɛŋmi tɔ dia maa, ma bi ku nami.’ ");
INSERT INTO sil_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ŋii nɛ ba jaŋ piɛsɛ kuoru-la a bul, ‘La Tiina, chɛ bɛɛ nɛ losuŋ kɛniŋ koo lii-nyuasuŋ kɛniŋ koo ŋ fa ŋaa nuhuɔru koo, ŋ fa kɛŋ yaribiree koo, ŋ fa wiilu koo, ba kɛniŋ tɔ dia aŋ ka la bi ŋ lɛ pɛ?’ ");
INSERT INTO sil_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kuoru-la jaŋ bul, ‘Wutitii nɛ, bua-la kala lɛ ma si via di ma pɛ nii-la si bi lee kɛnɛ mi niaa tuɔŋ, ma via di ma pɛmi ma lɛ nɛ ŋii.’ ");
INSERT INTO sil_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ŋii nɛ ba jaŋ juu lee-la hɛɛ-la si bi dɛrɛ, aŋ ka di tuɔ-pul tiŋŋaa ma juu lee-la miisi-la si bi dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu si dagɛ niaa dɛrɛ, u bula pi u haritooroo a bul, “Ma jima, ");
INSERT INTO sil_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","tapulaa balia nɛ ka, ka di diisiŋ kieliŋ gbiele-la yi. Bua-la lɛ ba jaŋ kɛŋ mi-na Nuhuobiine Bie a joŋmi hɛ niaa nisiŋ lɛ di ba kpaasɛmi daa-gɛsɛɛ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ, ba hilimi Kayafas dia lɛ. Bua-la lɛ u fa ŋaa nii-la si kpu pusuŋ pipi Wia kuhiaŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba hilimi a vuvuurɛ ba si jaŋ to woŋbii-la a luɔra kɛŋ Yesu a kpu. ");
INSERT INTO sil_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ama ba bul di ba síu kɛŋ ba chɛ-bal-la, di ba nɛ ŋaa ŋii, niaa jaŋ ŋaa taawɛi. ");
INSERT INTO sil_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu fa si hɛ Bɛtani lɛ ŋii, u mu hɔŋ baal kubala dia lɛ baa yirɛ Saamɔŋ. Saamɔŋ fa ŋaa gbege nɛ aŋ duori. ");
INSERT INTO sil_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu fa si dii kiaa Saamɔŋ dia lɛ, haal kubala kɔ u teeŋ a kɛŋ tulaali ari loŋ a joŋo bisɛ hɛ u nyuŋ lɛ. Tulaalii-la yalliŋ hɛyɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","U haritooro-la si na ŋii, ba baaniŋ sii. Ba gurima pipiɛsɛ dɔŋɔ a bul, “Bɛɛ nɛ tii haala deeŋ kɛŋ nuu-la kaa chei ŋla? ");
INSERT INTO sil_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ba fa jaŋ wuo joŋ tulaalii-la a yallɛ a na moribiee yugɛ a joŋo pi summoo.” ");
INSERT INTO sil_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ama Yesu fa jiŋ wii-la ba síi bul. Ŋii nɛ u piɛsɛba a bul, “Bɛɛ nɛ tii ma wiwalimɛ haala deeŋ? Wu-zɔŋ nɛ u ŋaami lɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma di summoo jaŋ hɛ dimɛ bua-na kala lɛ, ama la di ma bi jaŋ hɛ dimɛ deeŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","U bisɛ tulaalii-la hɛmi lɛ a ŋaa siri di mi nɛ suba, di ba joŋmi hugi. ");
INSERT INTO sil_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wutitii nɛ mi bulaa pima, dunia sɛmɛ-na kala ba si jaŋ wuo mu a bul Wia wu-zɔmɔ-la, ba jaŋ liisi haala deeŋ ma wiaa a bul.” ");
INSERT INTO sil_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ŋii nɛ Yesu haritooro-la fii ari balia dɔŋɔ mu nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ teeŋ. U yiriŋ nɛ fa Judas Isikarɔt. U piɛsɛba a bul, ");
INSERT INTO sil_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Di mi nɛ kɛŋ Yesu yallɛ a pima, bɛɛ nɛ ma jaŋ pimi?” Ŋii nɛ ba diisɛ moribii-biiŋ mara ari fii a joŋo pu. ");
INSERT INTO sil_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A chiŋ bua-la lɛ Judas suomo chichɛ woŋbii-la u si jaŋ to a kɛŋ Yesu yallɛ a piba. ");
INSERT INTO sil_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gbiele-la lɛ ba si yie dii boroboro-la si bi si-buruŋ kɛnɛ, ba chɛ-buŋbuŋ, Yesu haritooroo kɔ u teeŋ a piɛsu a bul, “Nii nɛ ŋ cho di la mu ŋaa diisiŋ kieliŋ gbiele-la kudiilee di ŋ ku dii?” ");
INSERT INTO sil_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ŋii nɛ Yesu bula piba a bul, “Má mu juu taŋ-la tuɔŋ. Má mu baal kubala teeŋ. Má mu bula pu a bul, ‘La kuhiaŋ si, bua-la lɛ u síi chɛ di ba di u haritooroo dii diisiŋ kieliŋ gbiele-la kudiilee yie nɛ, laa chɛ di la dii kia-la ŋ dia lɛ nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŋii nɛ Yesu haritooro-la ŋaa ŋii ari Yesu si dagɛba a ŋaa diisiŋ kieliŋ gbiele-la kudiilee ba dii. ");
INSERT INTO sil_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wia si jua, Yesu ari u haritooro-la fii ari balia-la ku juu hɔŋ a didii kudiile-la. ");
INSERT INTO sil_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba síi dii kiaa ŋii, ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, ma dɔŋɔ jaŋ joŋmi yallɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ŋii nɛ u haritooro-la tuɔŋ chei. Ba suomo pipiɛsu, kuŋ kuŋ. Dɔŋɔ yie piɛsɛ, “Mi Tiina, mi nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ŋii nɛ Yesu bula piba a bul, “La di nii-la si chala kɛŋ boroboro tuu yuu gbaŋa tuɔŋ nɛ jaŋ joŋmi yallɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mi-na Nuhuobiine Bie jaŋ suu ari ba si ŋmuŋsɛ ŋii a tigɛmi lɛ. Ama nii-la si jaŋ joŋ mi-na Nuhuobiine Bie yallɛ, aa, u jaŋ na hɛɛŋ yugɛ. Ba fa si buu lula nɛ kpia.” ");
INSERT INTO sil_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ŋii nɛ Judas zɛŋbɛ tiina-la piɛsɛ Yesu a bul, “Mi nɛ ŋ didagɛɛ?” Ŋii nɛ Yesu bula pu a bul, “Oo, ŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba si hɔnɔ didii kiaa, ŋii nɛ Yesu sii a joŋ boroboro a lɔllɛ Wia aŋ kaa chɔgɛ chɔgɛ a joŋo pi u haritooroo a bula piba a bul, “Má laa. Mi yaraa namia nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ŋii nɛ u bira joŋ nyunyuala maa ari siniŋ. U lɔllɛ Wia aŋ joŋo piba a bul, “Má kala nyua nyunyual-bala-la tuɔŋ, ");
INSERT INTO sil_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","bɛɛ wiaa mi chaliŋ nɛ ŋii. Chaliŋ deeŋ wiaa nɛ tii Wia ta niiŋ ma teeŋ. Mi chaliŋ jaŋ jaasɛ ni-kɛnɛ wiaa, di Wia joŋ ba haachɛba chɛba. ");
INSERT INTO sil_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi bulaa pima, mi bira bi jaŋ kɔ di mi nyua siniŋ deeŋ, see tapulii-la mi si jaŋ kɔ, ŋii nɛ mi jaŋ nyua si-faliŋ mi Nyimma Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ŋii nɛ ba yii Wii-chuɔlɛ yiiliŋ aŋ sii lii a mu peel kubala baa yirɛ Oliv. ");
INSERT INTO sil_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ŋii nɛ Yesu bula piba a bul, “Titaŋiŋ deeŋ titia ma kala jaŋ fá viiri a tiŋ mi wiaa. Ba ŋmuŋsɛ Wia teniŋ tuɔŋ di ba jaŋ kpu pie-daara aŋ ka piesee fá pisɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama Wia jaŋ chisɛmi suuŋ lɛ. U nɛ chisɛmi, mi jaŋ laa ma sipaaŋ a mu Galilii.” ");
INSERT INTO sil_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ŋii nɛ Piita bula pi Yesu a bul, “Di ba kala fá maa aŋ leŋiŋ, mi-na bi jaŋ miirɛ ŋ hariŋ da.” ");
INSERT INTO sil_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ŋii nɛ Yesu bula pu a bul, “Wutitii nɛ, jiniŋ titaŋiŋ deeŋ ŋ-na Piita, ŋ jaŋ bul naaŋsiiŋ butori ari ŋ bimi jiŋ, ka di ji-bele-na yel.” ");
INSERT INTO sil_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ŋii nɛ Piita bula pu a bul, “La diŋ paala susuu maa, mi bi jaŋ bul ari mi biŋ jiŋ.” Ku-kaana-la ma kala bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ŋii nɛ Yesu ari u haritooroo mu juu lee kubala baa yirɛ Gɛtisɛmani. Yesu bula pi u haritooroo di ba hɔŋ daha, ka u mu chuɔlɛ Wia aŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","U kɛŋ Piita ari Zɛbidii biiriŋ balia a kaa mu dimɛ. U tuɔŋ faasa chei woruŋ. U tuɔŋ bi pina. ");
INSERT INTO sil_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","U bula pi u haritooroo a bul, “Mi tuɔŋ kala nɛ cheye a magɛ di mi suu. Má hɔŋ di la kala pɔ na.” ");
INSERT INTO sil_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ba hɔŋ. Ka u surisa mu sipaaŋ mua a tuu pina chigi tiŋteeŋ a sul Wia a bul duu nɛ kɛŋ woŋbiiŋ, duu sí leŋe di wii-la juu-u lɛ a bira bul, “Mi Nyimma, di ŋ níi chɛ, liisɛ hɛɛ-la síi kɔ mi lɛ. Ama mi-na ŋla tuɔtɔruŋ lɛ dee, ŋ-na tuɔtɔruŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","U chuɔla dɛrɛ aŋ sii kɔ u haritooroo teeŋ di ba piŋ doŋ. Ŋii nɛ u piɛsɛ Piita a bul, “Ŋ pina nɛɛ? Ŋ bi doŋ muapilii ma wuo bɛrɛɛ a diene yi hawa kubalaa? ");
INSERT INTO sil_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Má chuɔlɛ Wia a pupɔ di Sitaani sí wuo nyisɛma. Ma tuɔŋ lɛ ma cho di ma ŋaa wu-zɔŋŋɔɔ, aŋ ka ma bi doluŋ kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","U bira mu a chuɔlɛ Wia liamiŋ lɛ a bira bul, ");
INSERT INTO sil_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","“Mi Nyimma, di ŋ nɛ bi sɛi di ŋ laa hɛɛŋ deeŋ mi nisiŋ lɛ, leŋ di wii-la ŋ síi chɛ, duu ŋaa.” U miira kɔ di ba bira piŋ doŋ, bɛɛ wiaa doŋ kɛŋba nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ŋii nɛ Yesu mu chuɔlɛ Wia torimuŋ lɛ a bira bul ŋii titia. ");
INSERT INTO sil_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ŋii nɛ u miira kɔ u haritooroo teeŋ a piɛsɛba, “Ma ha pinaa wiesi nɛɛ? Má bee na, bua-la yie nɛ. Ba jaŋ kɛŋ mi-na, Nuhuobiine Bie a pi haachɛ diiree. ");
INSERT INTO sil_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Má sii la mu. Nii-la si jaŋ joŋmi yallɛ ka kɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ha bi wiaa bula dɛrɛ, di Judas níi kɔ ŋii. U fa ŋaa Yesu haritooro-la fii ari balia dɔŋɔ nɛ. Niaa yugɛ a tuto u hariŋ. Dɔŋsuŋ kori tokobiee ari taŋguloo. Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ba taŋ kuhiasiŋ nɛ tiŋba, ba kɔ. ");
INSERT INTO sil_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zɛŋbɛ tiina-la fa pi nialiŋ magil nɛ a bul, “Nii-la mi si mu guori, u nɛ ŋii. Má kɛnu.” ");
INSERT INTO sil_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ŋii nɛ Judas vɛŋ tegi a mu Yesu teeŋ a bula pu, “Mi kuhiaŋ, mii chuɔluŋ”, aŋ guoru. ");
INSERT INTO sil_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ŋii nɛ Yesu bula pu a bul, “Mi naŋdɔŋɔ, bɛɛ nɛ tii ŋ hɛ daha?” Ŋii nɛ ba kala guriku a kɛnu. ");
INSERT INTO sil_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesu haritooro-la dɔŋɔ liisɛ u tokobii a ta nuu digiliŋ keri. Nii-la fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia-yomo nɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ŋii nɛ Yesu bula pu a bul, “Joŋ ŋ tokobii a hɛ u di-hɛɛliŋ. Nii-la si liisɛ tokobii, tokobii nɛ ba jaŋ kaa kpuu. ");
INSERT INTO sil_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ŋ bi jiŋ ari mi fa jaŋ wuo yirɛ mi Nyimma duu pɛmi lɛɛ? Di mi nɛ fa yiru, u fa jaŋ ta u tiŋdaaraa bui buiba di ba ku pɛmi lɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama duu nɛ fa saa ŋaa ŋii, ɛɛ nɛ wialiŋ ba fa si ŋmuŋsa Wia teniŋ tuɔŋ jaŋ ku ŋaa wutitiiba?” ");
INSERT INTO sil_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ŋii nɛ Yesu piɛsɛ ni-daŋ-la a bul, “Mi ŋaa gaaru nɛɛ? Ma si kɛŋ tokobiee ari taŋguloo a kukɔ di ma kɛŋmii? Ma na tapulii-na kala la di ma nɛ yie hɔŋ Wia-dia lɛ mi didagɛ wiaa a pipima. Aŋ ka ma bi walima di ma kɛŋmi dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama wiiŋ deeŋ kala ŋaa di wialiŋ nialiŋ fa si bula, Wia Diŋ-zɔŋ-la doluŋ lɛ ku ŋaa wutitii.” Ŋii nɛ Yesu haritooro-la kala viau aŋ fá. ");
INSERT INTO sil_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ŋii nɛ nialiŋ si kɛŋ Yesu, ba kɛnu kaa mu Kayafas dia. U nɛ fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ. Di Wia teniŋ kerichiba ari ba taŋ kuhiasiŋ kala hilimi dimɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piita daa tuto ba hariŋ a to juu nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ kaala. U juu kaala-la a mu hɔŋ nialiŋ síi pɔ kaala-la teeŋ duu na wii-la si jaŋ ŋaa Yesu lɛ. ");
INSERT INTO sil_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari nialiŋ kala si yie hilime vuvuurɛ wiaa chichɛ di ba nyia wiaa a tigɛ Yesu lɛ di ba kpuu. Ba chɛ chɛ wii ka. ");
INSERT INTO sil_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Niaa paala yugɛ nɛ a ku nyia wiaa pu, ama ba fa bi wuo na wii-kala u si ŋaa chei. ");
INSERT INTO sil_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ŋii nɛ niaa balia ku lii a bul, “Baala deeŋ, u si u jaŋ wuo ŋmoo Wia-dia-la lo aŋ bira saau tapulaa batori pɛgɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ sii chiŋ a piɛsɛ Yesu a bul, “Ŋ bi nia niaa deeŋba si bul wialiŋ a tigɛŋ lɛɛ? Ŋ-na bi wii kɛnɛ ŋ si jaŋ bul?” ");
INSERT INTO sil_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu tɔrɛ u niiŋ. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ bula pu a bul, “Wia-la si weye yiriŋ lɛ, bula pila, ŋ nɛ ŋaa Kirisito, nii-la Wia si liisaa? Ŋ nɛ Wia Biee?” ");
INSERT INTO sil_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ŋii nɛ Yesu bula pu a bul, “Mi-na nɛ, ama mi bulaa pima kala, a lii bua deeŋ lɛ a kaa mu, ma jaŋ na mi-na Nuhuobiine Bie di mi hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ a to duoŋbiliŋbaanaa tuɔŋ ku tuu.” ");
INSERT INTO sil_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu si bul ŋii, nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ kɛŋ u gɛnniŋ kiɛsɛ aŋ bul, “Ŋ chei Wia yiriŋ. U bi maga di la bira chɛ daŋsiaba. Ma kala bi nia u si chei Wia yiriŋ ŋii? ");
INSERT INTO sil_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bɛɛ nɛ ma biinɛ?” Ŋii nɛ ba bul, “U cheye nɛ. U maga di ba kpuu nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋii nɛ ba tu naŋtuɔruŋ hɛ u siaa lɛ a ŋmobu. Nialiŋ dɔŋsuŋ síi ŋmobu ŋla nɛ, ba bula pu a bul, ");
INSERT INTO sil_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ŋ-na Kirisito, nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, dagɛ nii-la si ŋmobuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piita si hɔŋ kaala-la lɛ, ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia tiŋtinni-tolo kubala ku lii a bul, “Ŋ ma faa to Yesu hariŋ nɛ, baal-la si lii Galilii.” ");
INSERT INTO sil_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ŋii nɛ Piita nyia wiaa a bul ba kala nii, “Mi bi Yesu jiŋ. Mi bi wii-la ŋ si paala bubul jiŋ,” aŋ sii lii chiŋ zawura tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piita si chiŋ dimɛ, ŋii nɛ tiŋtinni-tolo dɔŋɔ ma bira nau a bula pi nialiŋ si china kpagu a bul, “Baala deeŋ ma ŋaa Yesu si lii Nazarɛt haritooro-la dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piita bira nyia wiaa aŋ ŋmiɛsa bul duu dee. ");
INSERT INTO sil_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Muasuaa nialiŋ si chiŋ dimɛ ma bula pu a bul, “Wutitii nɛ, ŋ ma ŋaa ba dɔŋɔ nɛ, ŋ yiikoro nɛ dagɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ŋii nɛ Piita ŋmiɛsɛ a bul, “Mi bi baala deeŋ jiŋ.” U si bul ŋii dɛrɛ di ji-bele yele. ");
INSERT INTO sil_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ŋii nɛ Piita liisi wii-la Yesu si bula pu ari u jaŋ nyia wiaa a pu naaŋsiiŋ butori, ŋii nɛ u lii a faasa yel. ");
INSERT INTO sil_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Taŋ-pul nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ kala ari Ju̱u tiŋŋaa kuhiasiŋ hilimi a vuurɛ. Ba kala vuura di ba kpu Yesu. ");
INSERT INTO sil_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba kɛnu a vɔbu a kɛnu kaa mu Paalit teeŋ. U nɛ fa hɔŋ Rom kuori-baliŋ nyuŋ Judiya tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas zɛŋbɛ tiina-la si nia di baa chɛ di ba kpu Yesu nɛ, u tuɔŋ chei ari u si yallɛ Yesu ŋii. U miira kɛŋ moribii-biiŋ mara ari fii a kaa mu nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasi-la teeŋ a bul, ");
INSERT INTO sil_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Mi ŋaa haachɛ nɛ. Mi joŋ nii-la si bi wii cheye yallɛ di ba kpuu.” Ŋii nɛ nialiŋ bul di ba sipaa kala tuo dimɛ. Di u wii nɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ŋii nɛ Judas joŋ moribie-la a yuo ta Wia-dia tiŋteeŋ aŋ lii a mu yuo ŋmɛniŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ paa moribie-la aŋ bul, “Chaliŋ moribiee nɛ ŋla. La kisiŋ nɛ la joŋba hɛ Wia-dia moribiee lɛ.” ");
INSERT INTO sil_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ŋii nɛ ba vuurɛ di ba jiŋ wii-la ba si jaŋ joŋ moribie-la a ŋaa. Ba joŋ moribie-la yɔɔ tiŋteeŋ. Lee-la nɛ ba huhugi nuhuɔraa. Ba laa tiŋtee-la yɔɔ pupoi-mɛɛrɛ teeŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ŋii nɛ ba kɛŋ lee-la yiyirɛ chaliŋ tiŋteeŋ ari jiniŋ kala. ");
INSERT INTO sil_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ba si ŋaa ŋii, wialiŋ Jɛrimaya fa si bul, Wia Diŋ-zɔŋ-la doluŋ lɛ ku ŋaa wutitii. U fa si, “Iziral doho niaa dɔŋsuŋ sɛi di ba ti̱ŋ moribii-biiŋ mara ari fii aŋ kɛŋ Wia Tuɔ-pul Tiina-la. ");
INSERT INTO sil_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ba joŋ moribie-la ba si miira laa a yɔɔ tiŋteeŋ pupoi-mɛɛrɛ teeŋ. Mi Tiina Wia nɛ fa bula di mi ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu si chiŋ nii-la si hɔŋ kuori-baliŋ nyuŋ sipaaŋ Judiya tiŋteeŋ lɛ, ŋii nɛ kuoru-la piɛsu a bul, “Ŋ nɛ ŋaa Ju̱u tiŋŋaa kuoro koo?” Ŋii nɛ Yesu bula pu a bul, “Oo, mi nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama nialiŋ fa si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ si joŋ cheeriŋ pu ŋii, u bi wii bula. ");
INSERT INTO sil_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ŋii nɛ Paalit piɛsu, “Ŋ bi wiaa deeŋba kala nia ba si bula a tigɛŋ lɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama Yesu bi u niiŋ suro, u bi wu-bala ma bula. Wii-la kperi Paalit woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Di diisiŋ kieliŋ gbiele nɛ yie-na kala, Paalit fa yie leŋ ba liisɛ nialiŋ ba si kaa tɔ dia dɔŋɔ nɛ, nii-la niaa si cho. ");
INSERT INTO sil_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bua-la lɛ di ba kɛŋ baal kubala baa yirɛ Barabas a tɔ dia. ");
INSERT INTO sil_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ni-daŋ-la si hilime, ŋii nɛ Paalit piɛsɛba, “Ni-bɛɛ nɛ ma cho di mi liisa pima? Barabas koo Kirisito, nii-la Wia si liisaa?” ");
INSERT INTO sil_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paalit fa jima woruŋ ari Ju̱u tiŋŋaa kuhiasiŋ yaraa faa bieru nɛ, ŋii nɛ tii ba kɛŋ Yesu kaa kɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paalit fa si hɔŋ sariya didiiliŋ ŋii, u haala tiŋ tiŋdaariŋ a leŋ di ba bula pu a bul, “Sí baala deeŋ wii-kala ŋaa. U ŋaa tuɔ-pul tiina nɛ. Diamiŋ titaŋiŋ mi duosi wiaa a tigɛu lɛ nɛ. U wiaa wiimi woruŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasi-la nyisɛ ni-daŋ-la hɛ di ba bul di Paalit liisɛ Barabas ta aŋ ka di ba kpu Yesu. ");
INSERT INTO sil_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋii nɛ Paalit piɛsɛ ni-daŋ-la a bul, “Niaa deeŋba baliamiŋ tuɔŋ, kubɛɛ nɛ ma chɛ di mi liisa pima?” Ŋii nɛ ba bul, “Barabas!” ");
INSERT INTO sil_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ŋii nɛ Paalit piɛsɛ nialiŋ a bul, “Aŋ ka Yesu ba síi yiru Kirisito, bɛɛ nɛ ma si mi kɛnu kaa ŋaa?” Ŋii nɛ ba kala bul, “Leŋ di ba kɛnu kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ŋii nɛ Paalit piɛsɛba a bul, “Wu-bɔŋ bɛɛ nɛ u ŋaa?” Ŋii nɛ ba kpia a kii buŋbuŋ-la a bul, “Leŋ di ba kɛnu kpaasɛ daa-gɛsɛɛ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ŋii nɛ Paalit na ari goŋ-la yuga kiŋkɛŋ, ari yuosuŋ jaŋ juu. Ŋii wiaa u bi wii-kala wuo ŋaa. Di liiŋ chiŋ u sɛmɛ. U ŋaa a sɔŋ u nisaa nialiŋ sipaaŋ aŋ bul, “Mi sipaa tuo baala deeŋ suunuŋ lɛ. U hɛ ma teeŋ.” ");
INSERT INTO sil_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋii nɛ ni-daŋ-la kala bul, “Di la nɛ cheye wiiŋ deeŋ lɛ, leŋ di Wia dɔgisɛla ari la biiriŋ a tiŋ la si kpuu.” ");
INSERT INTO sil_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ŋii nɛ Paalit liisɛ Barabas ta a piba aŋ ŋaa ba viirɛ Yesu aŋ joŋu piba di ba kaa mu kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ŋii nɛ Paalit laali-yuoroo dɔŋsuŋ kɛŋ Yesu kaa juu Paalit dia kaala tuɔŋ. Laali-yuoro-la ku-kaanaa kala ma ku pɛba lɛ a hilimi. ");
INSERT INTO sil_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba wuri Yesu gɛnniŋ kala aŋ joŋ gɛri-fiaŋ laalu ");
INSERT INTO sil_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","a chɛ sɔsuŋ a kaa sua nyuŋ-chuulo a nagɛ kuoro nyuŋ-chuulo a joŋo chuu a joŋ daaŋtiga hɛ u na-diiŋ lɛ aŋ tuu kpirimi u sipaaŋ a mɔmu lɛ a bul, “Ju̱u tiŋŋaa kuoro, laa chuɔluŋ.” ");
INSERT INTO sil_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba tu naŋtuɔruŋ a hɛu lɛ a laa daa-la a ŋmoo u nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba si mɔmu lɛ dɛrɛ, ba wuri gɛri-fiaŋ-la aŋ paa u titia gɛnniŋ a laalu aŋ kɛnu kaa lii woŋbiiŋ di ba kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ba si kɛnu kaa lilii di ba kpaasu daa-gɛsɛɛ nyuŋ ŋii, ba cheŋ baal kubala baa yiru Saamɔŋ. U jáŋ yiriŋ nɛ Sariini. Ŋii nɛ laali-yuoro-la fugu u laa Yesu daa-gɛsɛ-la a baasɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ŋii nɛ ba ku yi lee kubala baa yirɛ Gɔligɔta. Yiri-la bubuɔŋ nɛ nyu-kuŋkogulo. ");
INSERT INTO sil_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba si yi dimɛ, ba joŋ siniŋ a guoli ku-haariŋ lɛ a joŋo pi Yesu duu nyua. U si lenne di u hɛyɛ, u via. ");
INSERT INTO sil_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ŋii nɛ ba kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ aŋ tɔŋsɛ Yesu gɛnniŋ wiaa, di ba paa kpaa dɔŋɔ a jiŋ gɛri bɛɛ nɛ nuu-kala jaŋ laa. ");
INSERT INTO sil_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŋii nɛ ba hɔŋ dimɛ a bibenu. ");
INSERT INTO sil_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba si si Yesu ŋaa wialiŋ chei, ba ŋmuŋsa hɛ daa-gɛsɛ-la lɛ a bul, “Ju̱u tiŋŋaa kuoro Yesu nɛ ŋla.” ");
INSERT INTO sil_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ŋii nɛ ba kpaasɛ gaaraa balia ma a pɛ Yesu lɛ. Dɔŋɔ hɛ u na-diiŋ, dɔŋɔ ma hɛ u na-gua. ");
INSERT INTO sil_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ba si kpaasu mɛrɛ daa-gɛsɛ-la nyuŋ ŋii, nialiŋ si to dimɛ bibal, ba tutuusu aŋ kɛŋ ba nyuŋ chuchugisi ");
INSERT INTO sil_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a bul, “Oi, ŋ nɛ ŋaa nii-la si si ŋ jaŋ ŋmoo la Wia-dia lo aŋ bira wuo saau tapulaa batori pɛgɛ. Ŋ si ŋaa Wia Bie, lii daa-gɛsɛ-la nyuŋ a laa ŋ titia ta.” ");
INSERT INTO sil_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nialiŋ si kpu pusuŋ pipi Wia kuhiasi-la ari Wia teniŋ kerichiba ari taŋ-la kuhiasiŋ ma sisieri Yesu lɛ a bula pipi dɔŋɔ, ");
INSERT INTO sil_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“U wuo niaa laa tita nɛ aŋ bi u titia wuo laa ta. U si si u nɛ ŋaa Kirisito, Ju̱u tiŋŋaa kuoro, leŋ duu lii daa-gɛsɛ-la nyuŋ ku tuu di la na a laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U laa Wia dii nɛ a bula duu ŋaa Wia Bie nɛ. Tɔɔ, má leŋ di la na di Wia nɛ jaŋ laau ta lɛɛlɛ.” ");
INSERT INTO sil_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gaara-la balia ma ba si kpaasa a pɛ Yesu lɛ, ba ma tuusu ŋii titia. ");
INSERT INTO sil_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wia ku magɛ nyu-gbaŋa, leriŋ kala biri lim a mu yi didaaniŋ, ka leriŋ bira pullɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ŋii nɛ Yesu faasa yirɛ u yiikoro lɛ a bul, “Eloi, Eloi, lama sabakitani.” U bubuɔŋ nɛ: “Mi Tiina Wia, bɛɛ nɛ tii ŋ joŋmi ta?” ");
INSERT INTO sil_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Di niaa dɔŋsuŋ chiŋ dimɛ a jegile nii wialiŋ u si bula. Ŋii nɛ ba bula pi dɔŋɔ a bul, “Ilaaja nɛ baal-la yiyirɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nialiŋ dɔŋɔ fa si chiŋ dimɛ fá mu joŋ suosuo a kaa mu yuu siniŋ si nyala a joŋo tuu sakeliŋ lɛ a kaa mu hɛ u niiŋ lɛ duu nyua. ");
INSERT INTO sil_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ŋii nɛ nialiŋ dɔŋsuŋ fa si hɛ dimɛ bul, “Má leŋ la gbɛrɛ a na ari Ilaaja jaŋ ku soru daa-gɛsɛ-la nyuŋ koo.” ");
INSERT INTO sil_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ŋii nɛ Yesu faasa yel aŋ wiesi u wiesi kati. ");
INSERT INTO sil_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Patiisa nɛ fa hɛ Wia-dia tuɔŋ. Ba kaa kɛrɛ. U kiɛsɛ balia a chiŋ nyu-gbaŋa a kiɛsa ku tuu. Ŋii nɛ tiŋteeŋ zigili, busuŋ ma yɛrɛ a kpaa kpaa. ");
INSERT INTO sil_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Vaamaa ma suri suri. Nialiŋ Wia si liisa, ba yuga a sii suuŋ lɛ a lii vaama-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu si sii suuŋ lɛ, ba mu Jerusalɛm. Niaa yuga a naba lee-la. ");
INSERT INTO sil_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Laali-yuoroo zɔlɔ kuhiaŋ ari laali-yuoro-la fa si chiŋ dimɛ a bibeŋ Yesu a na tiŋteeŋ si zigili ŋii ari wialiŋ kala si ŋaa, fawulluŋ kɛŋba. Ŋii nɛ ba bul, “Wutitii, baala deeŋ sɛnɛ ŋaa Wia Bii nɛ.” ");
INSERT INTO sil_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Haalaa yuga a ma fa chiŋ di-bolii a bibenu. Haala-la fa to Yesu hariŋ nɛ a lii Galilii tiŋteeŋ a pipɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ba tuɔŋ Mɛɛri Magidaliŋ ari Mɛɛri dɔŋɔ. U fa ŋaa Jeems ari Josɛf naaŋ nɛ. Zɛbidii haala ma pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Didaaniŋ si yie, baal kubala a lii taŋ kubala baa yirɛ Arimatiya ma kɔ. U fa ŋaa kiaa tiina nɛ. U yiriŋ nɛ fa Josɛf. U ma fa ŋaa Yesu haritooro-la dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U mu Paalit teeŋ a sul Yesu ku-suuŋ. Ŋii nɛ Paalit bul di ba mu joŋo pu. ");
INSERT INTO sil_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ŋii nɛ Josɛf laa a kɛŋ gɛripɛ-pul-faliŋ a bɛu ");
INSERT INTO sil_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a joŋo hugi u titia bua falii-la lɛ u fa si lɔsɔ buŋ nyuŋ. U bilimi tabii-baliŋ kaa kɔ tɔ bua-la niiŋ aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka Mɛɛri Magidaliŋ ari Mɛɛri dɔŋɔ-la faa hɔŋ a chaasɛ bua-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","U taŋ si pula, chɛ-wiesii-la chɛɛŋ, nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Farisii tiŋŋa-la, ba mu Paalit teeŋ a bula pu a bul, ");
INSERT INTO sil_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Kuhiaŋ, la liisi wii nɛ. Bua-la lɛ wu-nyiaru-la si hɛ u miisiŋ lɛ, u fa bula ari u nɛ suba, u jaŋ sii suuŋ lɛ tapulaa batori chɛɛŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ŋii wiaa leŋ di niaa mu a pɔ u vaaŋ-la woruŋ di tapulaa batori-la yi, di u haritooroo sí wuo mu a gaa kuusi aŋ bula pi niaa ari u sii suuŋ lɛ nɛ. Di ba nɛ ŋaa wiiŋ deeŋ, u nɛ jaŋ paala kii wialiŋ kala u si nyia.” ");
INSERT INTO sil_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ŋii nɛ Paalit bula piba di ba kɛŋ laali-yuoroo mu di ba pɔ vaaŋ-la niiŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ŋii nɛ ba laali-yuoro-la mu a joŋ buŋ a tɔ bua-la niiŋ aŋ leŋ niaa pɔ lee-la. ");
INSERT INTO sil_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba chɛ-wiesii-la chɛɛŋ si dɛrɛ, Lahadi chɛɛŋ siipuuraa, Mɛɛri Magidaliŋ ari Mɛɛri-la dɔŋɔ mu bua-la niiŋ di ba na lee-la ba si hugi Yesu. ");
INSERT INTO sil_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba si yi lee-la, muasuaa di leriŋ guu zigili. Di Wia tiŋdaara lii wia nyuŋ ku tuu a bilimi tabii-la ta aŋ hɔŋ u nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U siaa nagɛ duonuŋ si ligisa nɛ, aŋ ka u gɛnniŋ pullɛ kpul kpul. ");
INSERT INTO sil_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Laali-yuoro-la fa si pɔ bua-la, fawulluŋ kɛŋba. Ba chichel a nagɛ di ba suba. ");
INSERT INTO sil_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ŋii nɛ Wia tiŋdaari-la bula pi haala-la si hɛ dimɛ a bul, “Ma sí fawulluŋ fá. Mi jima ari Yesu nɛ maa chɛ, nii-la ba si kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","U tuo daha, u sie nɛ ari u fa si bul ŋii pima. Má ku na lee-la ba fa si joŋu hugi. ");
INSERT INTO sil_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Má mu lima lima a bula pi u haritooroo ari u sii suuŋ lɛ nɛ. Má bee na, u laa ma sipaaŋ a mu Galilii. Di ma nɛ mu dimɛ, ma jaŋ nau. Mi paala bula pima.” ");
INSERT INTO sil_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ŋii nɛ ba lii vaaŋ-la leriŋ aa tuosi. Fawulluŋ fa kɛŋba nɛ, ama ba tuɔŋ ma tɔrɛ. Ba fá mu di ba bula pi Yesu haritooroo wii-la si ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ŋii nɛ Yesu guu cheŋba a bula piba a bul, “Ma jaŋ hɔŋ ari yarifiɛlaa.” Ba mu u teeŋ a kɛŋ u naaŋ lɛ a chuɔlu. ");
INSERT INTO sil_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ŋii nɛ Yesu bula piba a bul, “Ma sí leŋe di fawulluŋ kɛŋma. Má mu bula pi mi haritooroo di ba mu Galilii. Ba jaŋ nami dimɛ.” ");
INSERT INTO sil_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Haala-la si miira viiri, laali-yuoro-la fa si pɔ bua-la, ba dɔŋsuŋ miira mu taŋ tuɔŋ a bula pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ wii-la si ŋaa. ");
INSERT INTO sil_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ hɔŋ a vuurɛ wii-la ba si jaŋ ŋaa. Ba vuura di ba jaŋ joŋ moribii-daŋ a kpal laali-yuoro-la fa si pɔ bua-la aŋ bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Má bula pi niaa ari ma piŋ doŋ nɛ, aŋ ka u haritooroo ku gaa a kuusi Yesu. ");
INSERT INTO sil_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Di nii-la si hɔŋ kuori-baliŋ nyuŋ nɛ nii wiiŋ deeŋ, la jaŋ bula pɛma lɛ ari ma bi wii cheye. Wii-kala bi jaŋ walimɛma.” ");
INSERT INTO sil_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ŋii nɛ laali-yuoro-la fa si pɔ vaaŋ-la laa moribie-la aŋ nyia wiaa ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ fa si bula piba di ba ŋaa. Wii-la Ju̱u tiŋŋaa fa si nyia teeli leriŋ kala a kaa kɔ ari jiniŋ. ");
INSERT INTO sil_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ŋii nɛ Yesu haritooro-la fii ari kubala-la mu Galilii tiŋteeŋ a jil peel-la nyuŋ, ari Yesu fa si bul ŋii piba. ");
INSERT INTO sil_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ŋii nɛ ba nau dimɛ a chuɔlu, ama dɔŋsuŋ bi laa dii. ");
INSERT INTO sil_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ŋii nɛ Yesu ku kpagɛba a bula piba a bul, “Wia joŋ doluŋ kala a pimi nɛ Wia-jaŋ ari dunia kala lɛ. ");
INSERT INTO sil_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Má saa mu dunia sɛmɛ-na kala a bul mi wiaa pi niaa a leŋ di ba ŋaa mi haritooroo a foba Wii-chuɔlɛ liiŋ mi Nyimma ari u Bie ari u Diŋ-zɔŋ-la doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Má dagɛba a leŋ di ba to wialiŋ kala mi si bula pima di ma to. Mi jaŋ hɛ ma teeŋ bua-na kala lɛ a kaa mumu dunia didɛriŋ.”");
INSERT INTO sil_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wia wu-zɔŋŋɔɔ di-suomuŋ nɛ ŋla. Wiaa deeŋba ŋaa Wia Bie Yesu Kirisito wu-zɔŋŋɔɔ wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ba síi yirɛ Azaaya fa ŋmuŋsa ari Wia si, “Bee na, mi jaŋ tiŋ mi tiŋdaara duu laa ŋ sipaaŋ mu a wasɛ woŋbiiŋ biliŋ lɛ di ŋ kɔ.” ");
INSERT INTO sil_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","U bira si, “Nuu nɛ chiŋ giri-bine tuɔŋ a heele bul, ‘Má kɔ a wasɛ woŋbiiŋ bil di ma Tiina kɔ a tuto. Ma ŋaa ŋii, duu nɛ kɔ, u di-vɛniŋ jaŋ piŋ woruŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ŋii nɛ baala deeŋ sii. Baa yiru Jɔɔŋ, Wia lii-fooro. U sii ku lii giri-bine tuɔŋ a heele bul, “Má birimɛ a lii ma haachɛba lɛ, ka di mi foma Wii-chuɔlɛ liiŋ. Di ma nɛ ŋaa ŋii, Wia jaŋ joŋ ma haachɛba a chɛma.” ");
INSERT INTO sil_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","U si bul ŋii, Judiya tiŋŋaa ari Jerusalɛm tiŋŋaa kala lii a mu u teeŋ a dagɛ ba haachɛba aŋ tuu Jɔɔdaŋ fuo-la u foba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Buŋtaŋŋa puna gɛnniŋ nɛ Jɔɔŋ fa laalɛ a kɛŋ teŋbiiŋ vɔɔ u tiŋa. Nyaŋgirikɛba ari tuuŋ nɛ fa ŋaa u kudiilee. ");
INSERT INTO sil_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U yie bul Wia wiaa pipi niaa a bul, “Nuu dɔŋ jaŋ to mi hariŋ kɔ. U nɛ jaŋ kiimi. Mi paala bi maga di mi kpagu a kɛŋ u nɛŋtɛŋŋɛɛ ŋmɛsiŋ ma kaa puri. ");
INSERT INTO sil_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Liiŋ duŋduŋa nɛ mi-na kaa fufoma, ama u-na jaŋ joŋ Wia Diŋ-zɔŋ-la hɛma lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bua-la lɛ Yesu sii a lii taŋ-la ba síi yirɛ Nazarɛt a hɛ Galilii tiŋteeŋ lɛ a kɔ lee-la Jɔɔŋ fa si hɛ. U ku juu fuo-la. Jɔɔŋ fou Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","U miira lii fuo-la tuɔŋ ku lii a wula beŋ, di wia nyuŋ guu kpaa balia. Ŋii nɛ ka Wia Diŋ-zɔŋ-la ku tuu hɛu lɛ a nagɛ kokomo. ");
INSERT INTO sil_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka u nii nuu yiikoro duu lii wia nyuŋ a bula pu a bul, “Mi Bii-chooluŋ nɛ ŋla. Mi tuɔŋ tɔrɛ ŋ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","U bi diene ka Wia Diŋ-zɔŋ-la kɛnu juu giriŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","U hɛ dimɛ ŋii halii tapulaa mahiŋ balia, ba di giriŋ tuɔŋ kiaa duŋduŋa. Sitaani yie kɔ a magisu. Yesu bi sɛyɛ. Ŋii nɛ Wia tiŋdaaraa ku tuu tima pu. ");
INSERT INTO sil_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","U bi diene, ka ba kɛŋ Jɔɔŋ tɔ dia. Ŋii nɛ Yesu sii a mu Galilii tiŋteeŋ a bubul Wia wu-zɔmɔ-la aa pi niaa ");
INSERT INTO sil_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a bul, “Bua-la yie nɛ. Wia kuorii-la kɔ nɛ. Má birima lii ma haachɛba lɛ a laa Wia wu-zɔmɔ-la dii.” ");
INSERT INTO sil_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ŋii nɛ u yi Galilii muga a mu to muga-la niiŋ a na Saamɔŋ ari u ŋaana Aŋduru. Ba ŋaa cheŋfili-kpuuraa nɛ. Uu mu, di ba kɛŋ ba joŋba a kaa kikɛsɛ cheŋfilee. ");
INSERT INTO sil_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","U yirɛba a bul, “Má sii to mi hariŋ. Mi jaŋ ŋaa di ma kɛsɛ niaa pɛ ma titia lɛ ari ma síi kɛsɛ cheŋfilee ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba sii a joŋ ba joŋba ta aŋ guu to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","U joŋ ŋii baa mu, di baalaa balia nɛ ŋii. Baa yirɛ Jeems ari Jɔɔŋ. Ba fa ŋaa Zɛbidii biiriŋ nɛ. Ba hɔŋ ba liiŋ daboro lɛ a tutɔ ba joŋba buasuŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","U si naba, u yirɛba. Ba leŋ ba nyimma ari nialiŋ kala ba fa si ŋaa ba tima pipiba aŋ lii liiŋ daboro-la tuɔŋ aŋ mu to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ba joŋ ŋii aa mu a ku yi Kapɛnam. Ŋii nɛ chɛ-wiesii-la chɛɛŋ, Yesu sii a mu juu Wii-chuɔlɛ dia a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","U síi dagɛba ŋii, u ŋaaba wu-kpuŋkpere. U bi baa daga ari Wia teniŋ kerichiba si yie didagɛba ŋii. U bul wiaa ari u nɛ kɛŋ wii-la doluŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ŋii nɛ di baal nɛ ŋii. Jiŋ-bɔmuŋ kɛnu. U ku juu aa chiirɛ, ");
INSERT INTO sil_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, ŋ si lii Nazarɛt, bɛɛ nɛ ŋ chichɛ ŋ ŋaala? Ŋ kɔ di ŋ kpula nɛɛ? Mi jimiŋ nɛ, ŋ nɛ ŋaa Wia Tuɔ-pul Tiina.” ");
INSERT INTO sil_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu si nii wialiŋ baal-la si bula, u kpia jiŋ-bɔŋ-la lɛ a bul, “Kɛŋ goŋ aŋ ku lii baal-la lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jiŋ-bɔŋ-la kɛŋ baal-la teriki aŋ faasa chiirɛ kiŋkɛŋ a lii baal-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nialiŋ kala miira hiriki a pipiɛsɛ dɔŋɔ, “Bɛɛ nɛ ŋlaa? Wu-falii nɛ uu dagɛ. U paala kɛŋ doluŋ a wuo jiŋ-bɔŋŋɔɔ a bul wiaa piba, ba tuto u niiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A lii ŋii lɛ nɛ, u yiriŋ guu teeli Galilii tiŋteeŋ kala. ");
INSERT INTO sil_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ŋii nɛ Yesu guu sii a lii Wii-chuɔlɛ dia-la lɛ, ba di Jeems ari Jɔɔŋ, a mu juu Saamɔŋ ari Aŋduru dia. ");
INSERT INTO sil_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ba mua di Saamɔŋ hiili-haala pina wiwiilɛ. U yaraa kala liŋ. Yesu si kɔ ŋii, ba bula pu. ");
INSERT INTO sil_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ŋii nɛ u ku juu a kɛŋ haal-la nisiŋ lɛ a kaa chuulɛ. U yaraa fa si lima ŋii, u fiɛlɛ. U sii ŋaa kudiilee piba ba dii. ");
INSERT INTO sil_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","U didaaniŋ si yie, ba kɛŋ nialiŋ kala síi wiilu ari jiŋsiŋ si kɛŋ nialiŋ kala a kaa kɔ Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taŋ tiŋŋaa kala gire kɔ a hilimi Saamɔŋ dia boiŋniiŋ. ");
INSERT INTO sil_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu vaarɛ nialiŋ yugɛ síi wiilu a kiri jiŋ-bɔmɔ-la ma a yugɛ a ta niaa lɛ. Jiŋsi-la jiŋ Yesu. Ŋii nɛ tii u biba woŋbiiŋ pa di ba bul wiaa. ");
INSERT INTO sil_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Siipuuraa Yesu sii lii dia-la lɛ a mu lee-la niaa si tuo a chuchuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ka Saamɔŋ ari u naŋdɔŋsuŋ ma sii kɔ a chichɛu. ");
INSERT INTO sil_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba si nau, ba bula pu ari nuu-kala nɛ kɔ a chichɛu. ");
INSERT INTO sil_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ŋii nɛ Yesu bula piba a bul, “Má leŋ la mu tasiŋ dɔŋsuŋ di mi bul Wia wiaa dimɛ maa. Ŋii wiaa nɛ mi kɔ.” ");
INSERT INTO sil_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","U saa sii a mu duurɛ Galilii tiŋteeŋ kala a juu Wii-chuɔlɛ diisiŋ aa bul Wia wiaa aŋ pɛ kiri jiŋsiŋ ma niaa lɛ a ta. ");
INSERT INTO sil_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ŋii nɛ gbege kubala ma sii kɔ Yesu teeŋ a tuu kpirimi a sulu a bul, “Di ŋ nɛ cho, ŋ jaŋ wuo ŋaa di mi duori.” ");
INSERT INTO sil_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nisusuŋ kɛŋ Yesu. U liisɛ u nisiŋ a digu aŋ bul, “Mi cho nɛ, duori.” ");
INSERT INTO sil_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ŋii nɛ yawiil-la guu leŋ baal-la. U duori. ");
INSERT INTO sil_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ŋii nɛ Yesu bula pu ari siifiɛsiŋ a bul, ");
INSERT INTO sil_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Viiri aŋ sí wii bula pi nuu-kala. Ama kɛŋ ŋ titia kaa mu dagɛ nii-la si kpu pusuŋ pipi Wia duu kpu pusuŋ pi Wia a piisɛ ŋ disinniŋ ta ari Moosis fa si dagɛma ŋii. Di ŋ nɛ ŋaa ŋii, niaa jaŋ na ari ŋ bira bi disinniŋ kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama baal-la kɛŋ wii-la kaa lii a bula gaarɛ leriŋ kala. Ŋii nɛ Yesu bira bi wuo chaasa juu taŋ kala tuɔŋ, ama u yie hɔŋ giriŋ tuɔŋ nɛ, ka niaa lii lee-na kala a kukɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tapulaa baŋmɛnɛ, Yesu miira mu Kapɛnam. Niaa nii duu miira kɔ a hɛ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ŋii nɛ ba yugɛ a gire kɔ a tɔ lee-la kala a tɔ boiŋniiŋ maa. Ka u bul Wia wiaa pipiba. ");
INSERT INTO sil_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ŋii nɛ di niaa dɔŋsuŋ nɛ ŋii. Ba banɛsɛ joŋ gbɛriku kubala kaa kɔ. U piŋ u bɔsɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Niaa si tɔ leriŋ kala ŋii, ba bi jiŋ lee-la ba si jaŋ to a juu. Ŋii nɛ ba jil lusuŋ nyuŋ a ta luri a joŋ bɔsɔ-la ari gbɛriku-la kala a to bua-la ta u tuu Yesu sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ŋii nɛ Yesu jiŋ ari ba ŋaau yarida nɛ woruŋ a bul gbɛriku-la lɛ a bul, “Mi bii, mi joŋ ŋ haachɛba a chɛŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Di Wia teniŋ kerichiba dɔŋsuŋ ma hɔŋ dimɛ a kɛŋ ba tuɔsaa pipiɛsɛ ba titia, ");
INSERT INTO sil_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bɛɛ nɛ tii baala deeŋ bubul ŋii? Uu tuusɛ Wia joŋŋoo ŋla. Kubɛɛ nɛ jaŋ wuo joŋ haachɛba chɛ nuu, di Wia duŋduŋa dee?” ");
INSERT INTO sil_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu wuo jiŋ ba tuɔbiinaa a pipiɛsɛba, “Bɛɛ nɛ tii ma bibiinɛ wiaa deeŋba? ");
INSERT INTO sil_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mi si jaŋ bul gbɛriku-la lɛ di mi joŋ u haachɛba chɛu nɛ, koo mi si jaŋ bul duu sii chuoli u bɔsɔ a viiri, ba tuɔŋ kubɛɛ nɛ ŋaa mɔli? ");
INSERT INTO sil_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mi jaŋ dagɛma ari mi-na, Nuhuobiine Bie, kɛŋ doluŋ dunia lɛ di mi joŋ haachɛba chɛ niaa.” ");
INSERT INTO sil_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ŋii nɛ u bula pi gbɛriku-la a bul, “Sii a joŋ ŋ bɔsɔ a mu dia.” ");
INSERT INTO sil_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baal-la guu sii a joŋ u bɔsɔ a vɛnɛ lii ba sipaaŋ. Ba kala hiriki a dɛnnɛ Wia yiriŋ a bul, “La ha bi wiiŋ deeŋ dɔŋɔ naa.” ");
INSERT INTO sil_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ŋii nɛ Yesu sii dimɛ a miira tuu muga niiŋ. Niaa yugɛ a ku hilimi, u didagɛba. ");
INSERT INTO sil_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","U si kiele mu sipaaŋ, u na baal kubala baa yirɛ Liivai. U nyimma yiriŋ nɛ Alifiyas. U fa ŋaa laŋpoo lilaaru nɛ a hɔŋ u tiŋtiŋŋaa dia lɛ. Ŋii nɛ u yiru a bula pu duu sii a tuto u hariŋ. U sii to. ");
INSERT INTO sil_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ŋii nɛ Yesu mu juu Liivai dia, ba di u haritooroo kala, a hɔnɔ didii kiaa. Laŋpoo laara-la dɔŋsuŋ ari haachɛ diiree ma kɔ, ba kala didii kialiŋ. Ba fa yuga woruŋ a tuto Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wia teniŋ kerichiba ari Farisii tiŋŋaa naba a ku piɛsɛ Yesu haritooroo a bul, “Bɛɛ nɛ tii Yesu ari haachɛ diiree ari laŋpoo laaraa, ba kala hɔnɔ didii kiaa?” ");
INSERT INTO sil_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu si nii wii-la ba síi bul, u bula piba a bul, “Nialiŋ si kɛŋ yarifiɛlaa, ba bi daaluŋ ŋiŋaaru ka chɛ, see nialiŋ síi wiilu. Mi kɔ di mi yirɛ haachɛ diiree nɛ di ba leŋ ba haachɛba. Nialiŋ si kɛŋ tuɔ-pula mi sipaaŋ dee mi kɔ di mi yirɛ.” ");
INSERT INTO sil_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Chɛɛ dɔŋ Jɔɔŋ, Wia lii-foori-la haritooroo ari Farisii tiŋŋaa haritooroo, baa vɔɔ niiŋ. Ŋii nɛ niaa sii ku piɛsɛ Yesu, “Bɛɛ nɛ tii Jɔɔŋ haritooroo ari Farisii tiŋŋaa haritooro-naa vɔɔ niiŋ, aŋ ka ŋ haritooro-na bi niiŋ vɔɔ?” ");
INSERT INTO sil_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ŋii nɛ Yesu piɛsɛba a bul, “Di nuu mu jaa haal kaa kɔ, ka ba duu naŋdɔŋsuŋ hɔŋ, u naŋdɔŋsu-la jaŋ vɔɔ niiŋ? Ai, di baal-la ari u naŋdɔŋsuŋ nɛ hɔnɔ, ba bi niiŋ ka vɔɔ. ");
INSERT INTO sil_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama chɛɛ dɔŋ nɛ hɛ dimɛ, ba jaŋ kɛŋ baal-la kaa mu lee, aŋ ka di u naŋdɔŋsu-la vɔɔ niiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ŋii nɛ u bira bula piba a bul, “Di ŋ nɛ kɛŋ gɛri-biniŋ duu luri, ŋ jaŋ joŋ gɛripɛ-faliŋ a tɔɔ? Ai, ŋ ŋaa ŋii, ku-falii-la jaŋ kuurɛ di gɛri-la wasa kiɛsɛ kii ŋii. ");
INSERT INTO sil_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Di ŋ nɛ kɛŋ pupoi-kpaaŋ, ŋ jaŋ ŋaa si-huoŋ a hɛ duu yel? Ai, ŋ nɛ ŋaa ŋii, pupoi-la jaŋ yɛrɛ, di siŋ-la kala ta. Ŋ yie joŋ si-huoŋ a hɛ pupoi-zɔmuŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chɛ-wiesiŋ chɛɛ kubala Yesu ari u haritooroo sii a mu nyoŋso tuɔŋ. Baa mu ŋii, u haritooro-la kiilɛ nyoŋso-la a chichaŋ. ");
INSERT INTO sil_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ŋii nɛ Farisii tiŋŋaa piɛsu a bul, “Ŋ bi naa? Chɛ-wiesii-la chɛɛŋ kisiŋ nɛ ba chichei ŋii. Bɛɛ nɛ tii?” ");
INSERT INTO sil_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ŋii nɛ Yesu miira piɛsɛba a bul, “Ma ha bi wii-la Devit fa si ŋaa karimaa? Losuŋ fa si kɛnu ba di u hariŋ niaa, u mu juu Wia-dia a joŋ boroboroba-la ba fa si kaa ku bil Wia sipaaŋ a chɔgɔ dii aŋ joŋo pi u niaa maa, ba ma dii. ");
INSERT INTO sil_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","U fa ŋaa kisiŋ nɛ ari ni-wogo si jaŋ joŋ boroboro-la dii, see nii-la si kpu pusuŋ pipi Wia duŋduŋa. Ka u joŋo dii ŋii. Bua-la lɛ Abiata nɛ fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ.” ");
INSERT INTO sil_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ŋii nɛ Yesu bira bula piba a bul, “Wia liisɛ chɛ-wiesii-la pi niaa nɛ di ba tiiu. U bi si di chɛ-wiesii-la nɛ tii niaa. ");
INSERT INTO sil_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mi-na Nuhuobiine Bie nɛ saa ŋaa chɛ-wiesii-la tiina ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu sii a miira mu juu Wii-chuɔlɛ dia, di baal kubala nɛ ŋii. U nisiŋ suu. ");
INSERT INTO sil_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ba si na Yesu duu jua, ba kala chaarɛ siaa bibenu di ba na ari u jaŋ vaarɛ baal-la chɛ-wiesii-la chɛɛŋ. Baa chɛ di ba na wii nɛ a to ŋii lɛ a kɛŋ Yesu a bul u teeŋ duu chei ba kisiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ŋii nɛ Yesu bul na-suu-la tiina lɛ duu sii kɔ ba tutuɔbaaniŋ. U sii mu. ");
INSERT INTO sil_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋii nɛ Yesu piɛsɛ nialiŋ a bul, “Ɛɛ nɛ la naabalimaba kisinniŋ bul di la ŋiŋaa chɛ-wiesii-la chɛɛŋ? Di la pipɛ niaa lɛ koo di la dudɔgisɛba? Di la laa niaa miisiŋ koo di la kpukpuba?” U si piɛsɛ ŋii, ba ŋaa fuii. ");
INSERT INTO sil_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ŋii nɛ Yesu na baaniŋ ba nyuŋ. U tuɔŋ chei a tiŋ ba digilaa si bi nii wiaa. Ŋii nɛ u bula pi na-suu-la tiina a bul, “Kɛŋ ŋ nisiŋ tiɛnɛ.” U kaa tiɛnɛ. U nisi-la fiɛlɛ a nagɛ u nagiŋ. ");
INSERT INTO sil_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ŋii nɛ Farisii tiŋŋaa sii lii. Ba di Hɛrɔd niaa mu vuurɛ ŋii ba si jaŋ wuo ŋaa a kɛŋ Yesu a kpu. ");
INSERT INTO sil_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ari u haritooroo sii a mu mugi-baliŋ niiŋ. Niaa yugɛ a lii Galilii tiŋteeŋ a tuto ba hariŋ. Dɔŋsuŋ ma lii Judiya tiŋteeŋ, ");
INSERT INTO sil_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","dɔŋsuŋ ma lii Jerusalɛm ari Idumiya tiŋteeŋ. Dɔŋsuŋ ma lii Jɔɔdaŋ fuo-la cholo. Dɔŋsuŋ ma lii Taya ari Saadɔŋ tiŋteeŋ. Niaa deeŋba kala fa nii Yesu wiaa a lii ba tasiŋ a kukɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ŋii nɛ u bula pi u haritooro-la di ba mu joŋ liiŋ daboro a kaa ku kii liiŋ niiŋ duu juu, di nialiŋ síu kaa yigi. ");
INSERT INTO sil_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu fa vaarɛ niaa a yugɛ. Ŋii wiaa nyanyal tiŋŋaa kala ku kɛŋ u baŋŋa lɛ aa chɛ di ba digu. ");
INSERT INTO sil_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Di jiŋ-bɔŋŋɔɔ kɛŋ niaa dɔŋsuŋ nialiŋ tuɔŋ. Di ba nɛ na Yesu kala, ba yie ku tel u naasiŋ lɛ nɛ a chichiirɛ ari u nɛ ŋaa Wia Bie. ");
INSERT INTO sil_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","U bula piba ari siifiɛsiŋ di ba sí leŋe di wiiŋ deeŋ teeli leriŋ kala. ");
INSERT INTO sil_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu sii a mu lee-la si kɛŋ peelee a yirɛ u si cho nialiŋ kala, ba mu u teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","U bira liisɛ ba tuɔŋ niaa fii ari balia di ba nɛ hɛ u teeŋ. U liisɛba ŋii di ba ma mu bul Wia wiaa. ");
INSERT INTO sil_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","U piba doluŋ maa di ba wuo kikiri jiŋsiŋ niaa lɛ. ");
INSERT INTO sil_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nialiŋ fii ari balia yiraa nɛ ŋla: Saamɔŋ, Yesu nɛ hɛ Piita pu, ");
INSERT INTO sil_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zɛbidii bie Jeems ari Jɔɔŋ. Jɔɔŋ fa ŋaa Jeems ŋaana nɛ. Yesu kɛŋba kaa yirɛ Buanaajis. Yiri-la bubuɔŋ nɛ baaniŋ tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ba ku-kaanaa ma nɛ ŋla: Aŋduru ari Filip ari Batolomi ari Matiu ari Tɔmas ari Jeems Alifiyas bie, ari Tadiyas ari Saamɔŋ Zɛlɔt ");
INSERT INTO sil_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ari Judas Isikarɔt, nii-la si ku ŋaa zɛŋbɛ tiina a yallɛ Yesu. U liisɛ nialiŋ dɛrɛ aŋ miira mu dia. ");
INSERT INTO sil_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ŋii nɛ niaa bira ku hilimi. U di u haritooroo paala bi chiniŋ na di ba dii kudiilee. ");
INSERT INTO sil_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ŋii nɛ u taŋ niaa nii a sii lii di ba kɛnu aŋ bul, “Uu chɛ u nyaasɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wia teniŋ kerichiba dɔŋsuŋ ma hɛ dimɛ. Ba lii Jerusalɛm nɛ a kɔ. Ba ma bul di jiŋ-bɔŋŋɔɔ kala kuoro ba síi yirɛ Bɛlizibul nɛ kɛnu. U nɛ pu doluŋ u kikiri jiŋsiŋ niaa lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ŋii nɛ Yesu yirɛba a magɛ namagaba a pipiba a bul, “Ɛɛ nɛ Sitaani jaŋ wuo ŋaa a kiri u titia? ");
INSERT INTO sil_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Di taŋ niaa nɛ hɛ dimɛ aŋ bi nii-bala kɛnɛ, ba taŋ jaŋ tel. ");
INSERT INTO sil_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Di niaa nɛ bira bi nii-bala kɛnɛ, ba dia jaŋ tel. ");
INSERT INTO sil_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Di Sitaani niaa saa bi nii-bala kɛnɛ, ba taŋ bi jaŋ chiŋ. U jaŋ tele dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nuu tuo si jaŋ juu ni-duoŋ dia a gaa u kiaa see duu kɛŋ ni-duo-la vɔɔ bil aŋ-na juu paa u kiaa.” ");
INSERT INTO sil_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ŋii nɛ Yesu bira bula pi niaa a bul, “Wutitii nɛ mi bulaa pima, di niaa nɛ ŋaa haachɛba kala aŋ pɛ tuusɛ Wia joŋŋoo maa, Wia jaŋ wuo joŋba kala chɛba. ");
INSERT INTO sil_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama di nuu nɛ tuusɛ Wia Diŋ-zɔŋ-la joŋŋoo, Wia bi jaŋ joŋo chɛu da. U tiina ŋaa haachɛ-la si maga di u suu nɛ. Wia jaŋ laa wii-la hɛ u tuɔŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nialiŋ dɔŋsuŋ fa bula ari jiŋ-bɔmuŋ nɛ kɛŋ Yesu. Ŋii nɛ tii u bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Muapilii Yesu naaŋ ari u ŋaanaa kɔ a chiŋ di-jaliŋ aŋ tiŋ niaa di ba yiru. ");
INSERT INTO sil_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Di ni-daŋ hɔnɔ gollu chu. Ŋii nɛ ba bula pu a bul, “Ŋ naaŋ ari ŋ ŋaanaa nɛ chiŋ jeeŋ hariŋ aa chɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ŋii nɛ Yesu miira piɛsɛba, “Kubɛɛ nɛ ŋaa mi naaŋ ari mi naaŋbiiriŋ?” ");
INSERT INTO sil_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","U miira beŋ nialiŋ si hɔnɔ gollu chu aŋ bula piba a bul, “Mi naaŋ ari mi naaŋbiiriŋ nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nii-la kala síi ŋaa wialiŋ Wia si cho, u nɛ ŋaa mi ŋaana ari mi dihaala ari mi naaŋ.” ");
INSERT INTO sil_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ŋii nɛ Yesu miira mu hɔŋ Galilii muga-la niiŋ a didagɛ niaa. Niaa yugɛ a ku gollu chu. Ba si yuga ŋii nɛ, u sii mu juu liiŋ daboro tuɔŋ a hɔŋ liiŋ tuɔŋ. Ka nialiŋ hɔŋ muga niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ŋii nɛ u magɛ namagaba a dagɛba wiaa yugɛ. U namagaba-la dɔŋɔ nɛ ŋla: U si, ");
INSERT INTO sil_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Má jegile nii mi teeŋ. Baal kubala nɛ sie a kɛŋ u ku-doho kaa lii duu misɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","U síi misɛ ŋii, ku-doho-la dɔŋsuŋ tel woŋbiiŋ tuɔŋ. Diibiisiŋ ku tuɔsa dii. ");
INSERT INTO sil_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Dɔŋsuŋ ma tuu tel kpaginyiliŋ nyuŋ. Hagila bi yuga, ka ba guu nyu. Ba naapoloo bi tiŋteeŋ jua. Wia pɔsɛ a ŋmooba ba suu, a tiŋ bɛɛ wiaa ba naapoloo bi tiŋteeŋ jua. ");
INSERT INTO sil_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ku-doho-la dɔŋsuŋ ma tuu tel sɔsuŋ tuɔŋ a nyu. Sɔsu-la ma nyu a nyagɛba kpu. Ba bi wasa. ");
INSERT INTO sil_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ku-doho-la dɔŋsuŋ ma lii tel tiŋtee-zɔmuŋ lɛ a nyu a waa a wasɛ woruŋ. Dɔŋsuŋ hɛ biee mara ari fii fii, dɔŋsuŋ ma mahiŋ batori batori, dɔŋsuŋ ma zɔlɔ zɔlɔ.” ");
INSERT INTO sil_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu magɛ namaga-la dɛrɛ, ŋii nɛ u bul, “Digilaa tiŋŋaa, má wuoli ma digilaa a nii wiaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ŋii nɛ nialiŋ viiri. Aŋ ka Yesu duŋduŋa hɔŋ. U haritooroo ari nialiŋ si kpagɛ dimɛ, ba ku piɛsɛ namagaba-la bubuɔsaa. ");
INSERT INTO sil_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ŋii nɛ u bula piba a bul, “Ma niaa deeŋba nɛ Wia dagɛ u kuorii-la bubuɔŋ pa. Ama ni-kaanaa-na kala, namagaba nɛ u yie kaa didagɛba. ");
INSERT INTO sil_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ŋii nɛ ba yie jegili jegili aŋ bi ba bubuɔsaa wuo jiŋ, a bira nyilimi nyilimi aŋ bi kuŋ-kala ma wuo na. Di ba nɛ fa jiŋ ba bubuɔsaa, ba fa jaŋ birima to Wia, di u joŋ ba haachɛba chɛba.” ");
INSERT INTO sil_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ŋii nɛ Yesu piɛsɛba a bul, “Ma bi namaga deeŋ bubuɔŋ jiŋ? Ɛɛ nɛ saa ma jaŋ ŋaa a jiŋ namagaba kala bubuɔsaa?” aŋ dagɛ namaga-la bubuɔŋ. U si, ");
INSERT INTO sil_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Baal-la síi du̱u kiaa, u nagɛ Wia niiŋ wiaa nɛ u kaa lii di u du̱u ŋii. ");
INSERT INTO sil_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kialiŋ si tel woŋbiiŋ lɛ nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ. Di ba nii wialiŋ dɛrɛ, Sitaani yie guu kɔ a kɛŋ wii-la a liiri ba tuɔsaa lɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kialiŋ ma si tel kpaginyiliŋ nyuŋ nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ a guu laa wialiŋ dii ari tuɔtɔruŋ. ");
INSERT INTO sil_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama ba bi bɔyɛ kɛnɛ a nagɛ kialiŋ naapoloo si bi tiŋteeŋ jua. Ba jaŋ sɛi wii-la a tou mu magɛ ŋii. Di hɛɛŋ nɛ juuba, koo di ba to naasiŋ dudɔgisɛba a tiŋ wii-la wiaa, ba tuɔŋ lii wii-la lɛ. Ba joŋo ta. ");
INSERT INTO sil_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Kialiŋ ma si tel sɔsuŋ tuɔŋ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ, ama dunia kiaa wiaa wiwalimɛba, ba cho di ba jigi aa chɛ kuŋ-kala. A tiŋ kiaa deeŋba wiaa ba bi sɛi di ba to wialiŋ. Wialiŋ bi doho kɛnɛ ba teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kialiŋ ma si tel tiŋtee-zɔmuŋ lɛ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ. Ba nii wialiŋ a laa hɛ ba tuɔsaa lɛ a kɛŋ doho, dɔŋsuŋ mara ari fii fii, dɔŋsuŋ mahiŋ batori batori, dɔŋsuŋ zɔlɔ zɔlɔ.” ");
INSERT INTO sil_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ŋii nɛ Yesu bira bul, “Ŋ níi chɛ pulumuŋ a chol chaaniŋ ku juu dia, ŋ jaŋ kɛŋ gbaŋa a chu tɔɔ? Koo ŋ jaŋ joŋo kii godo bubuɔŋ? Ai, ŋ jaŋ joŋo kii kua nyuŋ duu chaanɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wu-faali tuo, see duu ku lii di-jaliŋ. Wii-kala si hɛ birimiŋ tuɔŋ ma jaŋ ku lii pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Digilaa tiŋŋaa, má wuoli ma digilaa a nii.” ");
INSERT INTO sil_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","U bira bula piba a bul, “Má fiɛlɛ ma siaa woruŋ ari wialiŋ ma síi nii. Ŋii titia ma si to ma dɔŋsuŋ tiŋŋaa lɛ, ŋii titia nɛ Wia ma jaŋ joŋo toma lɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nii-la kala síi to Wia niiŋ wiaa, Wia jaŋ faasa pɛu lɛ duu to woruŋ. Nii-la ma si bi Wia niiŋ wiaa ka to, Wia bi jaŋ pɛu lɛ. U si pɛu lɛ mua-la maa, u jaŋ laa u kua.” ");
INSERT INTO sil_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","U bira bula piba a bul, “Wia kuorii-la nagɛ ari nia si sie a mu di u du̱u kiaa baga lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Taŋ biri u miira mu piŋ. Taŋ pul u bira sii. Tapulaa baŋmɛnɛ u sie di kialiŋ nyua a waa, ka u bi jiŋ ba si ŋaa ŋii a nyu. ");
INSERT INTO sil_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ba yie nyu ba titia lɛ a waa a hɛ nyuŋ a bii ba titia lɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ba bia, u ŋaa ba joŋ sia a kaa mu kuŋ.” ");
INSERT INTO sil_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ŋii nɛ Yesu bira piɛsɛba a bul, “Bɛɛ nɛ la jaŋ joŋ Wia kuorii-la a magisɛ? Wu-bɛɛ nɛ la jaŋ kaa dagɛ u bubuɔŋ? ");
INSERT INTO sil_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","U nagɛ ku-doho kubala ba síi yirɛ masitad nɛ, ba yie joŋ a du̱u. Baa du̱u, di u bi wii maga. U nɛ muuro kii ku-doho-na kala si hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ba nɛ du̱u dɛrɛ, u nyu. U yie sii waa a ŋaa tia a kii baga ku-duuloo kala kala. U naakelee yugɛ. Diibiisiŋ yie ku sagɛu lɛ a saa ba dɛlliŋ dimɛ.” ");
INSERT INTO sil_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu magɛ namagaba a yugɛ a didagɛ niaa. U yie didagɛba a magɛ ŋii ba si jaŋ wuo laa a hɛ ba nyuŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","U yie bi sɛi duu bul wii-kala polli see u magɛ namaga. Ama ba di u haritooroo duŋduŋa nɛ hɔnɔ, u yie dagɛ namagaba-la bubuɔŋ a piba nɛ. ");
INSERT INTO sil_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chɛɛ-la titia didaaniŋ u bula pi u haritooro-la a bul, “Má leŋ di la chol muga cholo.” ");
INSERT INTO sil_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba ta ni-daŋ-la kala ba viiri, aŋ ku juu liiŋ daboro-la u fa si hɔnɔ a kɛnu baa mu. Liiŋ daborusuŋ dɔŋsuŋ ma nɛ hɛ dimɛ a mumu. ");
INSERT INTO sil_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ŋii nɛ di pel-duo kubala suomo ŋiŋaa a ku ŋmoo liiŋ hɛ liiŋ daboro-la lɛ u chichɛ duu su̱. ");
INSERT INTO sil_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ama Yesu fa piŋ doŋ nɛ daboro-la hariŋ a yelli nyu-yelle. Ba ku chisu a bula pu a bul, “La kuhiaŋ, ŋ bi jiŋ di laa chɛ la suu nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ŋii nɛ u sii doŋ lɛ a kpia pel-la lɛ a bula pi muga-la maa duu fiɛla piŋ. Pel-la kɛrɛ, ka leriŋ kala ŋaa fuii. ");
INSERT INTO sil_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ŋii nɛ Yesu piɛsɛ u haritooro-la a bul, “Bɛɛ nɛ tii fawulluŋ kɛŋma? Ma ha bi yarida ŋaa?” ");
INSERT INTO sil_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ŋii nɛ fawulluŋ kɛŋba woruŋ, ba pipiɛsɛ dɔŋɔ, “Kubɛɛ nɛ saa paala ŋaa nia deeŋ? Peliŋ ari mugisuŋ kala tuto u niiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ŋii nɛ ba sii chol muga cholo a ku yi Gɛrasa tiŋŋaa tiŋteeŋ a lii liiŋ daboro lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ba lia di ba chiŋ, di baal nɛ ŋii, jiŋ-bɔmuŋ kɛnu. ");
INSERT INTO sil_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","U lii vaamaa tuɔŋ a kɔ. ");
INSERT INTO sil_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ba fa yie kɛŋ chɔrumɔɔ vɔbu a lɔl. Ba vɔbu u kaa kɛrɛ. Ba yie kɛnu hɛ kuruŋ maa, u ta kuru-la yɛrɛ aŋ sii mu hɔŋ vaamaa tuɔŋ. Nuu-kala bi doluŋ kɛnɛ duu wuo kɛnu. ");
INSERT INTO sil_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wiihɛyɛ ari titaŋiŋ kala u yie hɛ vaamaa tuɔŋ ari peelee nyuŋ a yie sii a duduurɛ. U duurɛ vaama-la tuɔŋ a chichiirɛ a kɛŋ tabiaa pipaasɛ u titia. ");
INSERT INTO sil_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","U si na Yesu duu hɛ di-bolii, u fá mu a chemu a kpirimi a chuɔlu. ");
INSERT INTO sil_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ŋii nɛ Yesu bula pi jiŋ-bɔŋ-la duu lii baal-la lɛ. Baal-la chiirɛ a bul, “Yesu, Wii-baliŋ Bie, bɛɛ nɛ ŋ chɛ di ŋ ŋaami lɛ? Mi joŋ Wia chuŋuŋ di ŋ sími dɔgisu!” ");
INSERT INTO sil_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ŋii nɛ Yesu piɛsu a bul, “Ŋ yiriŋ nɛ bɛɛ?” U si, “Mi yiriŋ nɛ ku-kɛnɛ, bɛɛ wiaa la yuga nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ŋii nɛ u sulu kiŋkɛŋ a bul duu sí leŋe di jiŋsi-la lii tiŋtee-la lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Di toonuŋ ma hɛ lee-la a yugɛ a didii kiaa peel-la nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jiŋsi-la sul Yesu duu leŋ di ba mu juu toonu-la. ");
INSERT INTO sil_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","U sɛi. Ŋii nɛ ba lii baal-la lɛ a mu juu toonu-la. Toonu-la kala sii a fá lii peel-la nyuŋ tuu. Ba tuu tel muga tuɔŋ a nyua liiŋ a suu. Toonu-la fa yi bui balia. ");
INSERT INTO sil_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ŋii nɛ too-daara-la fá mu a kɛŋ doworo mu bula pi bagi-daaraa ari taŋ-la niaa kala. Ba sii ku lii Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baa kɔ, di baal-la jiŋ-bɔmuŋ fa si kɛnɛ, duu hɔnɔ a laalɛ gɛriŋ a kɛŋ yarifiɛlaa. Ba si na ŋii, fawulluŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nialiŋ fa si hɛ dimɛ a na wii-la si ŋaa baal-la ari toonu-la lɛ, ba bul wii-la pi nialiŋ. ");
INSERT INTO sil_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba si nii ŋii, ba ku sul Yesu a bul duu lii ba tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ŋii nɛ Yesu mu duu juu liiŋ daboro. Baal-la jiŋsiŋ fa si kɛnɛ sulu a bul duu leŋ duu kɔ di ba mu. ");
INSERT INTO sil_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu bi sɛyɛ aŋ bula pu duu miira mu dia a bula pi u dia niaa wii-la kala la Tiina Wia si ŋaau lɛ, ari u si fáu nennige ŋii. ");
INSERT INTO sil_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baal-la miira mu Dɛkapɔlis tiŋteeŋ a bul wii-la kala Yesu si ŋaau lɛ. Niaa nii, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ŋii nɛ Yesu miira mu juu liiŋ daboro a chol muga cholo a mu hɔŋ muga niiŋ. Niaa gire ku chu. ");
INSERT INTO sil_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ŋii nɛ baal kubala hɛ dimɛ. Baa yirɛ Jaaris. U fa ŋaa Wii-chuɔlɛ dia kuhiaŋ nɛ. Ŋii nɛ u na Yesu a tuu tel u naasiŋ lɛ ");
INSERT INTO sil_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a sulu a bul, “Mi tolo níi wiilu a pina kikiiki duu suu. Mii chɛ di ŋ kɔ a joŋ ŋ nisiŋ daŋu lɛ, duu duori nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu sii to u hariŋ, ba mumu. Niaa ma sii tuto u hariŋ a gollu chu. ");
INSERT INTO sil_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baa mu di haal nɛ ŋii. Nyanyalii kubala nɛ kɛnu. U fa kɛŋ tiŋa nɛ deeŋ deeŋ jisiŋ fii ari balia. ");
INSERT INTO sil_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U fa gɔllɔ ŋaa daalusuŋ kiŋkɛŋ a na hɛɛŋ woruŋ a paala chei u moribiee kala pɛi. Ka u nyanyalii-la wasa juu-u lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","U si nii Yesu wiaa nɛ, u ku to niaa tuɔŋ a biina u tuɔŋ lɛ, “Di mi digi u gɛriŋ maa, mi jaŋ duori.” Ŋii nɛ u piɛgɛ nialiŋ a mu chiŋ Yesu hariŋ a kɛŋ nisiŋ a digi u gɛriŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","U si digi u gɛriŋ lɛ ŋii, u tiŋa-la guu dɛrɛ. Ŋii nɛ u titia jiŋ ari u tiŋa-la dɛrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka Yesu ma jiŋ u tuɔŋ lɛ ari dol kubala nɛ liiu lɛ. U birimɛ nialiŋ teeŋ a piɛsɛba a bul, “Kubɛɛ nɛ digi mi gɛriŋ lɛ ŋii?” ");
INSERT INTO sil_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŋii nɛ u haritooroo bul, “Ŋ bi na niaa si yuga ŋii a golluŋ chuu? Ka ŋ pipiɛsɛ di kubɛɛ nɛ digi ŋ gɛriŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","33","Aŋ ka Yesu ha bibeŋ duu na nii-la si digu. Ama haal-la jiŋ wii-la si ŋaau lɛ nɛ. Ŋii nɛ u kɔ a chichel a tuu tel Yesu naasiŋ lɛ a bul wii-la kala pu. ");
INSERT INTO sil_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ŋii nɛ Yesu miira bula pu a bul, “Mi tolo, ŋ yarida nɛ ŋaa ŋ duori. Mu ari yarifiɛlaa. Nyanyalii-la bira bi jaŋ kɛniŋ.” ");
INSERT INTO sil_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu haa bul wiaa ŋii haal-la teeŋ di tiŋdaaraa lii kuhiaŋ Jaaris dia kɔ a bula pi Jaaris a bul, “Ŋ tolo-la suba nɛ, bira sí la kuhiaŋ-la walimu.” ");
INSERT INTO sil_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu nii ba si bul ŋii a bula pi Wii-chuɔlɛ dia kuhiaŋ Jaaris a bul, “Sí leŋe di ŋ bɔyɛ joŋ. Ŋaa mi yarida.” ");
INSERT INTO sil_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ŋii nɛ Yesu sii a bi leŋe nuu-kala to u hariŋ see Piita ari Jeems ari u ŋaana Jɔɔŋ. Ba duŋduŋa nɛ to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ŋii nɛ ba ku yi Wii-chuɔlɛ dia kuhiaŋ-la dia. Baa kɔ di baa ŋaa goŋ aa ŋmoo niiŋ bagɛ bagɛ a yiyel. ");
INSERT INTO sil_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","U mu juu a piɛsɛba, “Bɛɛ nɛ tii maa ŋaa goŋ deeŋ kala? Bile bi suba. U piŋ doŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba kala miira china mumɔmu. Ŋii nɛ u kiriba ta ba lii, aŋ ka u kɛŋ bile nyimma ari u naaŋ ari u hariŋ niaa ba juu dia-la bile si pina. ");
INSERT INTO sil_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ba si juu dia-la ŋii, Yesu mu kɛŋ bile nisiŋ lɛ aŋ bul, “Talita kumi.” U bubuɔŋ nɛ: Haŋtolibie, mi si di ŋ sii! ");
INSERT INTO sil_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bile guu sii aa vɛŋ. Bile fa ŋaa jisiŋ fii ari balia nɛ. U ŋaa wu-kpuŋkpere ba lɛ. ");
INSERT INTO sil_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ŋii nɛ Yesu bul ari siifiɛsiŋ di ba sí leŋe di nuu-kala nii wii-la, aŋ bul di ba ŋaa kudiilee pi bile duu dii. ");
INSERT INTO sil_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ŋii nɛ u lii dimɛ a mu u tiŋteeŋ. U haritooroo ma to mu. ");
INSERT INTO sil_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chɛ-wiesii-la chɛɛŋ u mu juu Wii-chuɔlɛ dia a didagɛ niaa. Ba si nii, ba jesiŋ kala hiriki a bul, “Ɛɛ nɛ u ŋaa a jiŋ wiaa deeŋba? Kubɛɛ nɛ pu wu-jimiŋ deeŋ? Ɛɛ nɛ u wuo ŋiŋaa wu-duoruŋ deeŋba? ");
INSERT INTO sil_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","La jimu, kapiŋta dee ŋii? Mɛɛri nɛ u naaŋ. Jeems ari Joozis ari Judas ari Saamɔŋ, ba ŋaa u ŋaanaa nɛ. U dihaalaa ma nɛ hɛ daha ŋla.” Ŋii nɛ ba na baaniŋ u nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu bula piba a bul, “Nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, u yie mu lee-kala, ba zizilu nɛ, aŋ ka u jaŋ-niaa ari u dia-niaa siiŋ buu ka su̱.” ");
INSERT INTO sil_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A tiŋ ba sí bi yarida kɛnɛ wiaa, u bi wu-duo kala wuo ŋaa lee-la, u ta joŋ u nisiŋ nɛ daŋ nyanyal tiŋŋaa baŋmɛnɛ lɛ nɛ ba duori. ");
INSERT INTO sil_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","U kperi Yesu ari ba si buu yarida ŋaa. Ŋii nɛ u sii a mu gɔllɛ tasiŋ a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","U yirɛ u haritooroo fii ari balia a hilimi a tiŋba balia balia a piba doluŋ di ba wuo jiŋ-bɔŋŋɔɔ. Ŋii nɛ u bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Ma sí kuŋ-kala kaa pɛ vɛŋ woŋbii-la, see ma daaŋtigisiŋ duŋduŋa. Ma sí kudiilee kaa mu. Ma bira sí sulli-gbaŋa ma koru. Ma sí moribiee ma joŋo hɛ ma gɛri-fesiniŋ lɛ. Ma sí gɛnniŋ tuŋ bulia ma laalu. ");
INSERT INTO sil_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ama má paa ma nɛŋtɛŋŋɛɛ hɛ a laalɛ gɛri-bala-bala aa vɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","U bira bula piba a bul, “Di ma nɛ mua a juu taŋ kala, má juu dia-la niaa si cho ma wiaa a hɛ dii-bala lɛ halii di bua-la lɛ ma si jaŋ lii taŋ-la lɛ yi. ");
INSERT INTO sil_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Di ma mu taŋ kala, di ba pɔ di ma sí juu a bi ma wialiŋ jegile nii, má kiele mu. Di ma lia, má kpesi ma naasiŋ hagila ta. Ba jaŋ jiŋ ari ba ŋaa wii nɛ a cheima.” ");
INSERT INTO sil_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","U tiŋba ŋii, ba lii a mu bul niaa lɛ di ba birimɛ a lii ba haachɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba kiri jiŋsiŋ ma a yugɛ niaa lɛ, ba lii. Ba joŋ nuuŋ mua ma a bisa hɛ nyanyal tiŋŋaa lɛ ba duori. ");
INSERT INTO sil_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ŋii nɛ Yesu yiriŋ teeli lee-na kala. Kuoro Hɛrɔd ma nii u wiaa. Niaa dɔŋsuŋ si, “U nɛ ŋaa Jɔɔŋ, Wia lii-foori-la. Wia chisu suuŋ lɛ nɛ. Ŋii nɛ tii u kɛŋ doluŋ a ŋiŋaa wu-magilaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka dɔŋsuŋ ma si u nagɛ Ilaaja nɛ. Dɔŋsuŋ ma si, “U ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ ari faafaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kuoro Hɛrɔd si nii u wiaa u bul, “Jɔɔŋ nɛ ŋii. U nɛ nii-la mi si ŋaa ba keri u nyuŋ. U nɛ sii suuŋ lɛ ŋii.” Wii-la si tii u ŋaa ba keri u nyuŋ nɛ ŋla: ");
INSERT INTO sil_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hɛrɔd fa sie a mu jaa haal kubala. U yiriŋ nɛ Hɛrɔdias. U fa ŋaa u ŋaana Filip haala nɛ. U laa jaa. ");
INSERT INTO sil_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ŋii nɛ Jɔɔŋ fa bula pi Hɛrɔd, “Ŋ si kɛŋ ŋ ŋaana haala laa jaa ŋii, u bi woŋbiiŋ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","U si bul ŋii, Hɛrɔdias na baaniŋ u nyuŋ a chichɛ di ba kpu Jɔɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ŋii nɛ Hɛrɔd ŋaa ba kɛnu tɔ dia. Ama u na Jɔɔŋ duu ŋaa tuɔ-pul tiina a ŋiŋaa wialiŋ síi to woŋbiiŋ. Ŋii nɛ tii u fifáu a bibenu woruŋ a bi chɛ di ba kpuu. Wialiŋ kala Jɔɔŋ si bula kperu nɛ, ari ŋii kala u ha cho duu jegile nii wialiŋ u síi bul. ");
INSERT INTO sil_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kuoro Hɛrɔd chɛ-lulluŋ tapuluŋ nɛ bira yie. Ŋii nɛ u sii a ŋaa kudiilee yugɛ a kɛŋ u kuori-biisiŋ ari u laali-yuoro-hiasiŋ ari Galilii kuhiasiŋ kala, ba kala kɔ a hɔnɔ didii kiaa. ");
INSERT INTO sil_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba hɔnɔ di Hɛrɔdias tolo nɛ ŋii. U ku juu gugua. Hɛrɔd ari nialiŋ kala bibeŋ a chou. Ŋii nɛ Hɛrɔd bula pu di ku-la-na kala u síi chɛ, u jaŋ pu. ");
INSERT INTO sil_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U paala ŋmiɛsɛ a bul, “Ŋ síi chɛ ku-la-na kala, mi jaŋ piŋ. Ŋ níi chɛ mi tiŋteeŋ sɛŋpɛɛŋ dɔŋɔ a yi lebi maa, mi jaŋ pɔi a piŋ.” ");
INSERT INTO sil_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Haŋtolibie-la sii lii a piɛsɛ u naaŋ, “Mi bul mii chɛ bɛɛ kuŋ?” Ŋii nɛ Hɛrɔdias si, “Bula pu a bul ŋŋ chɛ Jɔɔŋ Wia lii-foori-la nyuŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tolo-la miirɛ lima lima a mu kuoru-la teeŋ a bula pu a bul, “Mii chɛ di ŋ keri Jɔɔŋ Wia lii-foori-la nyuŋ a hɛ pirata lɛ a kaa ku pimi.” ");
INSERT INTO sil_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuoro si nii wii-la, u tuɔŋ kala chei. Ama u si ŋmiɛsa ŋii, niaa kala nii. U bira bi u niiŋ wuo birimɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ŋii nɛ di laali-yuoroo china a pɔ ba kuoro. U yirɛ ba dɔŋɔ duu mu keri Jɔɔŋ nyuŋ kaa kɔ. Laali-yuori-la sii a mu lee-la ba si kɛnu mu tɔ a keri u nyuŋ a hɛ pirata lɛ a kaa kɔ pi tolo-la. U laa a kaa mu pi u naaŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jɔɔŋ haritooro-la si nii wii-la, ba sii kɔ a laa u ku-suuŋ a kaa mu hugi. ");
INSERT INTO sil_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu naŋzɔɔba saa sii a miira kɔ Yesu teeŋ a bula pu wialiŋ kala ba si ŋaa ari wialiŋ kala ba si daga. ");
INSERT INTO sil_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Niaa dɔŋsuŋ yie lilii, ka dɔŋsuŋ ku jujuu. Yesu ari u haritooroo paala bi chiniŋ na di ba dii kiaa. Ŋii nɛ u bula piba a bul, “Má leŋ di la mu lee-la niaa si tuo di ma wiesi mua.” ");
INSERT INTO sil_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba sii a juu liiŋ daboro a mumu niaa si tuo lee-la. ");
INSERT INTO sil_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Niaa yugɛ a naba a wuo jiŋ di ba nɛ. Ŋii nɛ niaa lii tasiŋ yugɛ a fá mu lee-la Yesu fa síi mu a laa sipaaŋ yi dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ba ma kɔ a lii liiŋ daboro lɛ. Yesu si mu lii liiŋ daboro-la lɛ, u na ni-daŋ di ba hɔnɔ gbɛru. Nennige kala kɛnu. Nialiŋ nagɛ piesee si bi pie-daara kɛnɛ nɛ. U sii a dagɛba wiaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Didaaniŋ ku yi, u haritooroo kɔ u teeŋ a bula pu a bul, “Leriŋ deeŋ ŋaa giriŋ nɛ. Ka wia fiɛla ŋla. Ta nialiŋ di ba mu tasiŋ ari bagisiŋ si kpagɛ daha a mu yɔɔ kudiilee a dii.” ");
INSERT INTO sil_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Di u si, “Má mu chɛ kudiilee piba ba dii.” Ba piɛsu a bul, “Ŋŋ chɛ di la kɛŋ siidi bui balia a kaa mu yɔɔ kudiilee a kaa kɔ piba di ba dii?” ");
INSERT INTO sil_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","U piɛsɛba a bul, “Boroboro baŋmɛɛ nɛ hɛ dimɛ? Má mu na.” Ba mu aŋ miira ku bul, “Banɔŋ nɛ ari cheŋfilee balia.” ");
INSERT INTO sil_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ŋii nɛ u bul di nialiŋ kala tuu gulimo hɔŋ hɔŋ ya-fiɛliŋ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dɔŋsuŋ hɔŋ zɔlɔ zɔlɔ, dɔŋsuŋ ma mahiŋ balia ari fii fii. ");
INSERT INTO sil_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ŋii nɛ u joŋ boroboro-la banɔŋ ari cheŋfilee balia-la a wula beŋ wia nyuŋ aŋ lɔllɛ Wia aŋ kaa chɔgɛ a pi u haritooroo. Ba laa a kaa mu kpaa nialiŋ. U saa joŋ cheŋfilee balia-la maa a kaa chɔgɛ ŋii, ba kala dii. ");
INSERT INTO sil_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Nuu-kala dii a vɔgɛ. Ka ba mu paa ku-kaanaa, boroboroba ari cheŋfilie-la si ka, a paa su̱ siŋsiŋ fii ari balia. ");
INSERT INTO sil_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nialiŋ si dii kialiŋ, ba tuɔŋ baalaa fa ŋaa bui banɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ŋii nɛ u leŋ u haritooroo mu juu daboro a laa sipaaŋ duoro chol muga cholo a mu Bɛtisaada. Ka u ta ni-daŋ-la ba viiri. ");
INSERT INTO sil_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","U haritooroo mua, u mu jil peel kubala nyuŋ duu chuɔlɛ Wia dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wia tuu juu di liiŋ daboro-la hɛ liiŋ tutuɔbaaniŋ. Aŋ ka u duŋduŋa ha hɛ muga niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ŋii nɛ Yesu bee na di peliŋ ka lu a pɔ di liiŋ daboro-la sí mu. Ba duori duori liiŋ daboro-la lɔl. Siipuuraa u sii a vɛŋ liiŋ nyuŋ a mumu a ku kpagɛba a chichɛ duu kieliba. ");
INSERT INTO sil_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba nau duu vɛŋ liiŋ nyuŋ. Ba si nau, ba biina di ni-dima nɛ. Fawulluŋ kɛŋba, ba ŋmoo niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ŋii nɛ u guu bula piba a bul, “Má nyirɛ ma bɔyɛ. Mi-na nɛ. Ma sí leŋe di fawulluŋ kɛŋma.” ");
INSERT INTO sil_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","U saa ku juu ba teeŋ liiŋ daboro-la lɛ. Pel-la kɛrɛ. U ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ba fa na Yesu duu kɛŋ boroboro banɔŋ a kpaa niaa bui banɔŋ, ka ba ha bi u doluŋ jiŋ. Ba siaa ha bi suro. ");
INSERT INTO sil_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ŋii nɛ ba chol a ku yi taŋ kubala baa yirɛ Gɛnɛzarɛt a lii liiŋ daboro-la lɛ aŋ kaa vɔɔ liiŋ niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba lii didɛrɛ, di niaa jima ari Yesu nɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba mu duurɛ ba tiŋteeŋ kala a paa nyanyal tiŋŋaa ari ba bɔsunuŋ a kaa mu lee-na kala ba si nia di Yesu hɛ. ");
INSERT INTO sil_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lee-na kala Yesu si mua, ta-balaa koo ta-biisiŋ koo bagisiŋ, niaa yie paa ba nyanyal tiŋŋaa kaa juu yɔsuŋ tuɔŋ a sulu duu leŋ ba digi u gɛriŋ niipiniŋ lɛ. Di ba nɛ dige, ba yie duori nɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ŋii nɛ chɛɛ kubala nialiŋ ba síi yirɛ Farisii tiŋŋaa ari Wia teniŋ kerichiba dɔŋsuŋ si lii Jerusalɛm kɔ, ba kala sii gire kɔ Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba kɔ di Yesu haritooroo dɔŋsuŋ hɔnɔ didii kiaa aŋ bi liiŋ sɔmɔ. Ba si u ŋii ŋaa disiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisii tiŋŋaa ari Ju̱u tiŋŋaa kala, ba bi kuŋ-kala ka dii, see di ba sɔŋ liiŋ, ari ba naabalimaba si dagɛba ŋii. ");
INSERT INTO sil_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Di ba nɛ yɔɔ kiaa lii yɔbɔ ma kaa kɔ, ba bi dii, see di ba sɔŋ liiŋ. Ba kisinniŋ yuga. Ba kɛŋ woŋbii dɔŋ nɛ ba síi tiisi ba nyunyualusuŋ ari ba gbaŋsiŋ ari ba hɔɔŋ pupoyee kala maa. ");
INSERT INTO sil_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ŋii nɛ ba ku piɛsɛ Yesu a bul, “Bɛɛ nɛ tii ŋ haritooroo chichei la naabalimaba kisinniŋ lɛ? Bɛɛ nɛ tii ba bi liiŋ sɔmɔ aŋ didii kiaa?” ");
INSERT INTO sil_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ŋii nɛ u miira bula piba a bul, “Ma ŋaa kaŋfugi timma nɛ. Wialiŋ kala Azaaya fa síi bul, Wia Diŋ-zɔŋ-la doluŋ lɛ a tigɛma lɛ ŋaa wutitii nɛ. Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari u bul di Wia si, ‘Niaa deeŋba kɛŋ niiŋ nɛ a pipimi zile, ka ba tuɔŋ liimi. ");
INSERT INTO sil_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba yie chuɔlɛmi pɛi nɛ aa dagɛ nuhuobiine wɛniŋ aŋ bul di Wia nɛ bula.’ ");
INSERT INTO sil_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nuhuobiine wɛniŋ nɛ maa to aŋ via Wia niiŋ wiaa.” ");
INSERT INTO sil_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","U bira si, “Ma kɛŋ wu-jimiŋ a via Wia wɛniŋ aŋ tuto ma naabalimaba woŋbiiŋ. Ma síi ŋaa ŋii, ma kiaa simaa? ");
INSERT INTO sil_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moosis fa ŋmuŋsa a bul ari Wia si di ŋ fá ŋ nyimma ari ŋ naaŋ, a bira ŋmuŋsɛ di nuu nɛ sii a bul wu-bɔmuŋ a tigɛ u nyimma koo u naaŋ lɛ, di ba kpu tiina. ");
INSERT INTO sil_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moosis fa ŋmuŋsɛ ŋii nɛ. Ama ma-na si di nuu nɛ kɛŋ kuŋ a magɛ duu joŋo pɛ u nyimma koo u naaŋ lɛ, tiina mu a bula piba, ku-la u fa si jaŋ joŋo pɛba lɛ ŋaa kuŋ nɛ baa yirɛ ‘Koobaŋ’. U bubuɔŋ nɛ: Wia nɛ tiiu. Ŋii wiaa u bi jaŋ joŋo piba.” ");
INSERT INTO sil_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ŋii nɛ Yesu bira bula piba a bul, “Ma bira bi sɛi di nuu ŋaa wii-kala pɛ u nyimma ari u naaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma yie ŋaa ŋii a via Wia niiŋ wiaa aŋ tuto ma naabalimaba woŋbiiŋ a bira joŋoo dagɛ ma haŋbiisiŋ maa. Wu-yiriba-la yuga nɛ ma síi ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ŋii nɛ Yesu bira yirɛ niaa ba kɔ. Ba si kɔ, u bula piba a bul, “Má kala jegili a nii woruŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kuŋ-kala síi tuu ŋ tuɔŋ bi disinniŋ kɛnɛ. Ama wialiŋ si hɛ ŋ tuɔŋ a kuu lii, ba nɛ kɛŋ disinniŋ.  ");
INSERT INTO sil_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Digilaa tiŋŋaa, má wuoli ma digilaa a nii.” ");
INSERT INTO sil_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","U si bul ŋii dɛrɛ, u mu juu dia aŋ leŋ nialiŋ. Ŋii nɛ u haritooroo ku piɛsu namaga-la bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ŋii nɛ u piɛsɛba, “Ma ha bi wu-jimiŋ kɛnɛɛ? Ma bi jiŋ ari nuu nɛ dii kuŋ, u bi jaŋ wuo ŋaa u kɛŋ disinniŋ? ");
INSERT INTO sil_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ŋ nɛ dii kuŋ ŋii, u bi ŋ tuɔŋ ka tuu see ŋ luoruŋ, a bira to ŋ yaraa lii.” (U dagɛba ŋii ari kudiilee kisiŋ bira tuo.) ");
INSERT INTO sil_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ŋii nɛ u bul, “Wialiŋ kala si hɛ ŋ tuɔŋ a kuu lii, ba nɛ kɛŋ disinniŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ŋ tuɔŋ lɛ nɛ ŋ yie biinɛ wu-bɔŋŋɔɔ ŋaaniŋ a ŋiŋaa ba-chɔruŋ ari ha-chɔruŋ wu-ŋaalaa, a gigaa niaa kiaa, a bira kpukpu niaa, a chichɛ niaa haalaa, ");
INSERT INTO sil_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a bira cho ŋ kɛŋ niaa kiaa lilaa, a ŋiŋaa wu-bɔŋ-na kala, a ŋmuŋmoo niaa puo, a ŋaa wialiŋ kala si bi maga di ŋ ŋaa. Ŋ yaraa ma bibieri niaa lɛ. Ŋ yie chichei niaa yiriŋ maa, a bibigisi ŋ titia lɛ, a ŋaa ni-yaari. ");
INSERT INTO sil_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wu-bɔŋŋɔɔ deeŋba kala yie lii ŋ tuɔŋ nɛ a kɛŋ disinniŋ.” ");
INSERT INTO sil_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ŋii nɛ Yesu sii a lii dimɛ a mu Taya ari Saadɔŋ tiŋteeŋ a mu juu faa dia kubala lɛ a bi chɛ di nuu-kala jiŋ u wiaa, ka ba via aŋ jiŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Haal kubala nɛ hɛ dimɛ. U ŋaa nuhuɔru nɛ a lii Fɔniisia taŋ-la si hɛ Siiria tiŋteeŋ lɛ. U yiikoro ŋaa Giriik. Jiŋ-bɔŋ nɛ fa kɛŋ u tolo. Ŋii nɛ u nii Yesu wiaa a sii kɔ a tuu tel u naasiŋ lɛ a sulu duu kiri jiŋ-bɔŋ-la u bie lɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu piɛsu, “Ŋ nɛ kɛŋ haŋbiisiŋ, ŋ jaŋ joŋ ba kudiilee a pi va-biisiŋ? Ai, ŋ laa sipaaŋ ŋaa kudiilee pi ŋ haŋbiisiŋ nɛ di ba dii. Ba nɛ die aŋ ka, ŋ saa joŋo pi vahiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Haal-la si, “Wutitii nɛ, mi Tiina. Ŋ bi jaŋ joŋ haŋbiisiŋ kudiilee a pi vahiŋ. Ama haŋbiisi-la síi dii kialiŋ, kialiŋ si tel tiŋteeŋ nɛ, vahi-la ma jaŋ paa dii.” ");
INSERT INTO sil_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ŋii nɛ Yesu bula pi haal-la a bul, “A tiŋ ŋ si bul wiiŋ deeŋ wiaa, jiŋ-bɔŋ-la lii ŋ tolo lɛ nɛ. Mu dia.” ");
INSERT INTO sil_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Haal-la viiri. U mua di u bile pina. Jiŋ-bɔŋ-la liiu lɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ŋii nɛ Yesu miira lii Taya tiŋteeŋ lɛ a mu to Saadɔŋ ari tasiŋ fii tiŋteeŋ a mu yi Galilii muga. ");
INSERT INTO sil_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ŋii nɛ di taŋiŋ hɛ dimɛ. Ba kɛnu kaa kɔ a sul Yesu duu joŋ u nisiŋ daŋu lɛ. ");
INSERT INTO sil_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kɛnu kaa lii niaa tuɔŋ. Ba duŋduŋa balia hɔŋ. Ŋii nɛ u joŋ u neniee a kaa mu tuu u digilaa lɛ a tu naŋtuɔruŋ hɛ u neŋdelimiŋ lɛ, ");
INSERT INTO sil_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","aŋ beŋ wia nyuŋ aŋ faasa wiesi fir aŋ bul baal-la lɛ, “Ɛfata.” Ɛfata bubuɔŋ nɛ: Kaa suri. ");
INSERT INTO sil_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Baal-la digilaa suri. U neŋdelimiŋ ma birimɛ. U bubul wiaa woruŋ. ");
INSERT INTO sil_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ŋii nɛ Yesu bula pi nialiŋ ari siifiɛsiŋ di ba sí wiiŋ deeŋ bula pi nuu-kala. Ŋii titia u sisi di ba sí wii-la bula pi niaa, ŋii titia nɛ ba ma fiɛsɛ sii a bul wii-la gaara bal. ");
INSERT INTO sil_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nialiŋ kala si nii wii-la, ba hiriki a bul, “Wii-na kala nɛ u ŋiŋaa woruŋ. U paala ŋaa taŋiŋ digilaa suri nɛ u ninii wiaa a bubul wiaa.” ");
INSERT INTO sil_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ni-daŋ bira ku hilimi bua kubala lɛ. Tapulii kubala, ba bira bi kudiilee kɛnɛ di ba dii. Ŋii nɛ Yesu yirɛ u haritooroo a bula piba, ");
INSERT INTO sil_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mi beŋ niaa deeŋba, nennige kɛŋmi nɛ. Ba hɛ mi teeŋ tapulaa batori nɛ ŋla, ba bi kudiilee na di ba dii. ");
INSERT INTO sil_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Di ba nɛ bi kuŋ-kala die, ka di mi bul di ba viiri, ba jaŋ mu yiegi woŋbiiŋ lɛ. Ba dɔŋsuŋ ma lii di-bolii nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ŋii nɛ u haritooroo piɛsu, “Ɛɛ nɛ ŋ jaŋ ŋaa a na kudiilee di niaa deeŋba kala dii giriŋ deeŋ tuɔŋ?” ");
INSERT INTO sil_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","U piɛsɛba, “Boroboroba baŋmɛɛ nɛ hɛ dimɛ?” Ba si, “Kiaa balipɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ŋii nɛ u ŋaa nialiŋ tuu hɔŋ tiŋteeŋ. Ka u joŋ boroboroba-la balipɛ a lɔllɛ Wia, aŋ kaa chɔgɛ chɔgɛ, a pi u haritooroo di ba laa kpaa nialiŋ. Ba laa kpaaba. ");
INSERT INTO sil_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Di ba kɛŋ cheŋfili-biisiŋ ma mua. U joŋba maa a chuɔlɛ Wia aŋ ŋaa u haritooroo laa kpaa nialiŋ. ");
INSERT INTO sil_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nuu-kala dii a vɔgɛ. Ka ba paa ku-kaaŋ-biisiŋ a su̱ siŋsiŋ balipɛ. ");
INSERT INTO sil_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nialiŋ fa si dii kialiŋ, ba yi bui banɛsɛ. ");
INSERT INTO sil_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ŋii nɛ u taba aŋ kɛŋ u haritooroo ba mu juu liiŋ daboro a mu Dalimanuuta tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ sii kɔ aa chɛ di ba magisɛ Yesu a ku kɛŋ wiaa lilɛrɛ a bul, “Ŋ si kɛŋ doluŋ, ŋaa wu-magil di la na a jiŋ ari ŋ dol-la lii Wia nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu tuɔŋ chei. U faasa wiesi. Ŋii nɛ u piɛsɛba, “Ma lɛɛlɛ niaa deeŋba, bɛɛ nɛ tii ma yie chichɛ di mi dagɛ mi doluŋ? Wutitii, mi bulaa pima, mi bi jaŋ ŋaa wu-magil kala di ma lɛɛlɛ niaa deeŋba na.” ");
INSERT INTO sil_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋii nɛ u leŋba aŋ miira juu liiŋ daboro a duoro chol muga cholo. ");
INSERT INTO sil_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu ari u haritooroo si duoro chol muga cholo ŋii, u haritooroo liisi ari ba yu ba kudiilee ta, aŋ ka boroboro kubala, u hɛ liiŋ daboro lɛ. ");
INSERT INTO sil_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ŋii nɛ Yesu bul ari siifiɛsiŋ di ba pɔ ba titia lɛ ari Farisii tiŋŋaa ari Hɛrɔd lɛ. U di ba nagɛ si-buruŋ nɛ. Di ŋ joŋo hɛ kuŋ-kala lɛ, u yie puɔrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","U si bul ŋii, ba hɔnɔ vuvuurɛ a bul, “La bi boroboro kɛnɛ, ŋii nɛ tii u bul ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu jiŋ ba síi vuurɛ wii-la a piɛsɛba, “Bɛɛ nɛ tii ma hɔnɔ vuurɛ a bul, ‘La bi boroboro kɛnɛ?’ Ma ha bi wu-jimiŋ kɛnɛɛ? Ɛɛ nɛ ma tuɔŋ dol ŋii? ");
INSERT INTO sil_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma kɛŋ siaa nɛ, ba bi naa? Ma kɛŋ digilaa nɛ, ba bi nii? Ma bi wii-la liisee? ");
INSERT INTO sil_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mi joŋ boroboroba banɔŋ a chɔgɔ kpaa baalaa bui banɔŋ. Ma si paa ku-kaanaa, siŋsiŋ baŋmɛɛ nɛ ma paa su̱?” Ba si, “Siŋsiŋ fii ari balia.” ");
INSERT INTO sil_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","U bira piɛsɛba, “Mi si joŋ boroboroba balipɛ a chɔgɔ kpaa niaa bui banɛsɛ, ma si paa ku-kaanaa, siŋsiŋ baŋmɛɛ nɛ ma paa su̱?” Ba si siŋsiŋ balipɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ŋii nɛ u piɛsɛba, “Ma saa ha bi wu-jimiŋ kɛnɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ari u haritooroo bira ku yi taŋ kubala baa yirɛ Bɛtisaada. Ŋii nɛ niaa dɔŋsuŋ sii a kɛŋ nyuluŋ kubala a kaa kɔ a sul Yesu duu joŋ u nisiŋ a digu. ");
INSERT INTO sil_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","U kɛŋ nyuluŋ-la nisiŋ lɛ a lɛru lii taŋ-la tuɔŋ a tu naŋtuɔruŋ hɛ u siaa lɛ a joŋ u nisaa daŋu lɛ aŋ piɛsu di uu na leriŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","U beŋ leriŋ aŋ bul, “Mii na niaa nɛ, ama ba nagɛ tiisiŋ nɛ aa gɔllɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ŋii nɛ Yesu miira kɛŋ u nisaa daŋ u siaa lɛ. Baal-la faasa chaarɛ siaa woruŋ a na kuŋ-kuŋ-kala woruŋ. U siaa bira nina. ");
INSERT INTO sil_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ŋii nɛ Yesu bula pu duu bira sí taŋ-la tuɔŋ juu, duu mu u jaŋ. ");
INSERT INTO sil_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ari u haritooroo bira sii lee-la a mumu Sizariya Filipa tiŋteeŋ. Ba síi mu ŋii, Yesu piɛsɛ u haritooroo a bul, “Kubɛɛ nɛ niaa si di mi ŋaa?” ");
INSERT INTO sil_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba si, “Dɔŋsuŋ si di ŋ ŋaa Jɔɔŋ nɛ, Wia lii-foori-la. Dɔŋsuŋ ma si di ŋ nɛ ŋaa Ilaaja, nii-la fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Dɔŋsuŋ ma si di ŋ nɛ ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ŋii nɛ Yesu bira piɛsɛ u haritooroo maa a bul, “Ka ma maa, ma si mi ŋaa kubɛɛ nɛ?” Piita si, “Ŋ nɛ ŋaa Kirisito, nii-la Wia si liisa.” ");
INSERT INTO sil_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Piita si bul ŋii, Yesu bula piba ari siifiɛsiŋ di ba pɔ di ba sí wii-la bula pi nuu-kala. ");
INSERT INTO sil_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ŋii nɛ Yesu didagɛ u haritooro-la a bul, “Mi-na, Nuhuobiine Bie, mi jaŋ na hɛɛŋ woruŋ. Kuhiasiŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba, ba kala jaŋ viami aŋ ŋaa di ba kpumi. Di ba nɛ kpumi, mi jaŋ ŋaa tapulaa batori aŋ bira sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","U chaasa bul wiiŋ deeŋ nɛ piba. Ŋii nɛ Piita kɛnu kaa suusa lii, a kpiau lɛ, a bul u teeŋ ari u sí ŋii bul, u bi woruŋ bula. ");
INSERT INTO sil_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ŋii nɛ Yesu birimɛ u haritooroo teeŋ aŋ kpia Piita lɛ a bul, “Sitaani, mu dimɛ. Wialiŋ ŋ síi bul, nuhuobiine woŋbiiŋ nɛ, Wia woŋbiiŋ dee.” ");
INSERT INTO sil_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋii nɛ u yirɛ u haritooroo ari nialiŋ kala di ba kɔ a bula piba a bul, “Di nuu-kala níi chɛ duu tomi, see duu via u titia woŋbiiŋ aŋ joŋ u daa-gɛsɛɛ baasɛ a tomi. ");
INSERT INTO sil_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nii-la kala síi chɛ duu laa u miisiŋ, u jaŋ via u miisiŋ ta. Ama nii-la si via u miisiŋ ta a tiŋ mi wiaa ari Wia wu-zɔmɔ-la wiaa, u jaŋ sɛnɛ laa u miisiŋ. ");
INSERT INTO sil_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Di ŋ nɛ dii dunia kala aŋ bi miisiŋ kɛnɛ, bɛɛ kuŋ nyuurii nɛ ŋ na? ");
INSERT INTO sil_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dunia deeŋ lɛ, bɛɛ kuŋ nɛ saa ŋ jaŋ wuo kaa yɔɔ laa ŋ miisiŋ? ");
INSERT INTO sil_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma lɛɛlɛ ni-bɔŋŋɔɔ deeŋba, ma yie fifá hiisiŋ a tiŋ mi wiaa ari mi wu-bulaa lɛ. Ama chɛɛ kubala mi-na Nuhuobiine Bie, mi jaŋ kɔ a chaanɛ, ari mi Nyimma si chaanɛ ŋii. Mi jaŋ kɛŋ Wia tiŋdaaraa di la kala kɔ. Bua-la lɛ nɛ, nii-la si fá mi hiisiŋ, mi ma jaŋ fáu hiisiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ŋii nɛ Yesu bira bula pi u haritooro-la a bul, “Wutitii nɛ mi bulaa pima, niaa dɔŋsuŋ hɛ dimɛ, ba bi jaŋ suu, see di ba na Wia kuorii-la china dɛrɛ ari doluŋ, ka di ba-na suu.” ");
INSERT INTO sil_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tapulaa balidu si ku bal, Yesu kɛŋ Piita ari Jeems ari Jɔɔŋ, ba duŋduŋa, a kaa mu jil peel-bal kubala nyuŋ. Ba beŋ ba sipaaŋ a na Yesu duu birima. ");
INSERT INTO sil_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","U gɛnniŋ kala pullɛ kiŋkɛŋ a tutul. Gɛri-chɛsɛru kala bi jaŋ wuo chɛsɛ gɛnniŋ di ba pulla nagɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ilaaja ari Moosis ku lii ba sipaaŋ a china bubul wiaa Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ŋii nɛ Piita bula pi Yesu a bul, “La kuhiaŋ, u ŋaa wu-zɔŋ nɛ ari la si hɛ daha. Leŋ di la hɛ lɛŋŋɛɛ batori, di ŋ kɛŋ dɔŋɔ, di Moosis ma kɛŋ dɔŋɔ, di Ilaaja ma kɛŋ dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fawulluŋ fa kɛŋba nɛ woruŋ. Ŋii nɛ tii u bul ŋii. U bi jiŋ wii-la kala u si jaŋ bul. ");
INSERT INTO sil_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ŋii nɛ duoŋbiliŋbaaniŋ ku tɔba. Ka yiikoro kubala lii duoŋbiliŋbaaŋ-la tuɔŋ a bubul, “Mi Bii-chooluŋ nɛ ŋla. Má jegile nii u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ba nii yiikoro deeŋ a miira daasɛ. Ba bi nuu-kala na see Yesu duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba si lii peel-la nyuŋ kuu tuu, ŋii nɛ Yesu bula piba a bul, “Mi bí chɛ di ma bul wii-la ma si na, see di mi-na, Nuhuobiine Bie sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ŋii nɛ ba sɛi a kɛŋ wii-la ba tuɔŋ aŋ pipiɛsɛ dɔŋɔ, “U si jaŋ sii suuŋ lɛ, u bubuɔŋ nɛ bɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ŋii nɛ ba piɛsɛ Yesu, “Bɛɛ nɛ tii Wia teniŋ kerichiba bul ari Ilaaja nɛ jaŋ laa sipaaŋ kɔ, aŋ ka di Wia Bie-na kɔ?” ");
INSERT INTO sil_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","U bula piba a bul, “Wutitii, Ilaaja jaŋ sɛnɛ laa sipaaŋ kɔ a kɛŋ kuŋ-kala wasa bil. Ba saa ŋmuŋsa bil Wia teniŋ tuɔŋ a mu tigɛ Nuhuobiine Bie lɛ duu jaŋ na hɛɛŋ kiŋkɛŋ, di ba jaŋ benu a nagɛ ni-pɛi. Bɛɛ nɛ tii ba ŋmuŋsɛ ŋii? ");
INSERT INTO sil_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lɛɛlɛ mi jaŋ bula pima ari Ilaaja paala kɔ nɛ. Ba ŋaau ŋii kala ba síi chɛ. Ba fa ŋmuŋsɛ ŋii nɛ a tigɛu lɛ Wia teniŋ tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba si ku yi haritooroo ku-kaana-la di niaa yuga a hilimi dimɛ. Ba di Wia teniŋ kerichiba kɛŋ wiaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nialiŋ si na Yesu duu kɔ, ba guu hiriki a sii fá a mu chemu a chuɔlu. ");
INSERT INTO sil_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ŋii nɛ u piɛsɛba, “Wu-bɛɛ nɛ ma hilimi ŋii a kaa lilɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nialiŋ dɔŋɔ bul, “La kuhiaŋ, mi bie nɛ mi kaa kɔ ŋ teeŋ. Jiŋ-bɔŋ nɛ kɛnu. U birimɛ taŋi. ");
INSERT INTO sil_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","U yie ku kɛnu u tuu tel tiŋteeŋ, naŋtuɔ-fuŋfuga tɔ u niiŋ, u chichaŋ u nyilaa a teriki. La saa sul ŋ haritooroo di ba kiri jiŋ-bɔŋ-la u lɛ, ama ba bi wuo kiri.” ");
INSERT INTO sil_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ŋii nɛ Yesu bula piba a bul, “Ma lɛɛlɛ niaa, ma bi yarida kɛnɛ. Ɛɛ nɛ mi jaŋ nyalimɛ a dieni ma teeŋ? Má kɛŋ bile kaa kɔ mi teeŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ŋii nɛ ba kɛŋ bile kaa kɔ u teeŋ. Jiŋ-bɔŋ-la si ku na Yesu, u kɛŋ bile teriki, u tuu tel tiŋteeŋ a bibilimi, naŋtuɔ-fuŋfuga-la ku tɔ u niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ŋii nɛ Yesu piɛsɛ u nyimma, “Chɛ bɛɛ nɛ u suomiu lɛ?” U si, “U haŋbiiriŋ kala lɛ nɛ u suomi. ");
INSERT INTO sil_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bua dɔŋɔ u yie joŋu a lulo nyiniŋ lɛ ari liiŋ lɛ a chichɛ duu kpuu. Ŋ-na si wuo wii-na kala ŋiŋaa, fála nennige aŋ pɛla lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ŋii nɛ Yesu si di nii-la kala si ŋaa yarida, u jaŋ wuo ŋaa wii-na kala. ");
INSERT INTO sil_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ŋii nɛ bile nyimma sii chiŋ a faasa bubuŋsi, “Mi ŋaa yarida, ama u bi yugɛ. Pɛmi lɛ di mi yarida yugɛ.” ");
INSERT INTO sil_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ba si china bubul ŋii, niaa yuga a fá ku hilimi. Yesu ku na a bula pi jiŋ-bɔŋ-la ari siifiɛsiŋ a bul, “Jiŋ-taŋi, mi nɛ bula di ŋ leŋ bile. Pupɔ di ŋ maachie bira suu kɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jiŋ-bɔŋ-la chiirɛ aŋ kɛnu teriki a ku leŋu, ka bile nagɛ duu suba. Nialiŋ jesiŋ kala bul di bile suba nɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yesu mu kɛŋ u nisiŋ lɛ u sii chiŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ŋii nɛ Yesu ari u haritooroo juu dia. Ba luɔra piɛsu, “Bɛɛ nɛ tii la-na bi jiŋ-bɔŋ-la wuo kiri?” ");
INSERT INTO sil_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","U bula piba, “Nuu-kala bi jiŋ-bɔŋ-la si nagɛ ŋii wuo kire tita, see u chuɔlɛ Wia woruŋ.” ");
INSERT INTO sil_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ŋii nɛ ba sii lii lee-la a mu to Galilii tiŋteeŋ. Yesu bi cho di nuu-kala jiŋ lee-la u si hɛ, ");
INSERT INTO sil_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bɛɛ wiaa uu dagɛ u haritooroo nɛ ari ba jaŋ kɛŋ u-na, Nuhuobiine Bie a hɛ niaa nisiŋ lɛ di ba kpuu, ka duu sii suuŋ lɛ tapulaa batori chɛɛŋ a kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama ba fa bi jiŋ wii-la u si bula bubuɔŋ aŋ fifá fawulluŋ di ba piɛsu. ");
INSERT INTO sil_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ŋii nɛ ba sii kɔ Kapɛnam. Ba si juu dia, Yesu piɛsɛ u haritooro-la a bul, “Bɛɛ kuŋ nɛ ma fa kaa lilɛrɛ woŋbiiŋ lɛ ŋii?” ");
INSERT INTO sil_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ŋii nɛ ba tɔrɛ ba niiŋ, bɛɛ wiaa ba fa kɛŋ ba tuɔŋ kuhiaŋ wiaa nɛ lilɛrɛ woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ŋii nɛ Yesu hɔŋ aŋ yirɛ u haritooro-la fii ari balia a bula piba, “Nii-la síi chɛ duu ŋaa ma tuɔŋ kuhiaŋ, see duu ku ŋaa ma tuɔŋ haŋbie a timaa pi ma kala!” ");
INSERT INTO sil_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ŋii nɛ u kɛŋ bii-bie a kaa ku bil ba tutuɔbaaniŋ a guoru aŋ bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Di nuu nɛ kɛŋ bii-bie deeŋ dɔŋɔ woruŋ a tiŋ mi wiaa, mi nɛ u kɛŋ woruŋ ŋii. Nii-la ma kala si kɛŋmi woruŋ, mi duŋduŋa dee u kɛŋ woruŋ ŋii. Nii-la si tiŋmi ma nɛ u kɛŋ woruŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ŋii nɛ Jɔɔŋ bula pi Yesu a bul, “La kuhiaŋ, la na baal kubala duu kiri jiŋ-bɔŋŋɔɔ niaa lɛ ŋ doluŋ lɛ. La kiru duu sí ŋii ŋaa, bɛɛ wiaa u bi la dɔŋɔ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ama Yesu bula piba a bul, “Duu níi ŋaa ŋii, má bira síu kiru. Di nuu nɛ ŋaa wu-kpuŋkpere kala mi doluŋ lɛ, u chie bira bi jaŋ chei mi yiriŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nii-la kala si bi la hariŋ lia, u ŋaa la dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wutitii mi bulaa pima, nii-la kala si joŋ gbaŋa ari liiŋ a pima a tiŋ ma síi tomi wiaa, u jaŋ laa u time. ");
INSERT INTO sil_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nii-la kala si na haŋbiisi-la síi tomi dɔŋɔ a nyisu duu ŋaa wu-bɔmuŋ, u maga di ba joŋ nɔmuŋ a vɔɔ laalɛ u baŋŋa lɛ a joŋu yuo hɛ muga tuɔŋ. Di ba nɛ ŋaa ŋii, u nɛ jaŋ kpia u si weye. ");
INSERT INTO sil_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Di ŋ nisiŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, kere ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari na-kuuŋ, u nɛ kpia ŋ si kɛŋ na-pilimee aŋ juu Wia nyiniŋ. Lee-la nyiŋ-la bi jaŋ disɛ.  ");
INSERT INTO sil_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lee-la naŋchuɔlaa jaŋ dii ŋ yaraa deeŋ deeŋ a bi jaŋ suu, ka nyiŋ-la ma bi jaŋ disɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Di ŋ naaŋ níi chɛ u kɛniŋ hɛ haachɛ lɛ, kere ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari naa-kuuŋ, u nɛ kpia ba si jaŋ joŋuŋ yuo hɛ Wia nyiniŋ lɛ ari naa-pilimee.  ");
INSERT INTO sil_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lee-la naŋchuɔlaa jaŋ dii ŋ yaraa deeŋ deeŋ a bi jaŋ suu, ka nyiŋ-la ma bi jaŋ disɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Di ŋ siiŋ níi chɛ duu kɛniŋ hɛ haachɛ lɛ, liisa ta. Ŋ si jaŋ juu Wia kuorii-la tuɔŋ ari sii-togo, u nɛ kpia ba si joŋuŋ yuo hɛ Wia nyiniŋ lɛ ari siaa balia. ");
INSERT INTO sil_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lee-la naŋchuɔlaa jaŋ dii ŋ yaraa deeŋ deeŋ a bi jaŋ suu, ka nyiŋ-la ma bi jaŋ disɛ. ");
INSERT INTO sil_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wia jaŋ leŋ di ŋ na hɛɛŋ aŋ-na na wu-zɔmuŋ. ");
INSERT INTO sil_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yisiŋ sima, ama di u nɛ sɛbisɛ, ŋ bira bi jaŋ wuo ŋaa duu siŋ. Má leŋ di ma tuɔsaa siŋ, ari yisiŋ si sima ŋii, aŋ leŋ di ma kala kɛŋ nii-bala.” ");
INSERT INTO sil_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ŋii nɛ Yesu sii a lii dimɛ a mu Judiya tiŋteeŋ a chol Jɔɔdaŋ fuo-la. Ni-daŋ bira hilimi u teeŋ. U bira dagɛba ari u si yie dagɛba ŋii. ");
INSERT INTO sil_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ ma sii kɔ u teeŋ a chichɛ di ba magisu a piɛsu a bul, “Ŋ si via ŋ haala, u kɛŋ woŋbiiŋ nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu miira piɛsɛba, “Ɛɛ nɛ Moosis dagɛma di ma tuto?” ");
INSERT INTO sil_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba bul, “Moosis si di baala níi chɛ u via u haala, duu laa sipaaŋ a ŋmuŋsɛ teniŋ a pi haal-la aŋ-na viau.” ");
INSERT INTO sil_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu bula piba a bul, “Ma tuɔŋ dolie, ŋii nɛ tii Moosis ŋmuŋsɛ ŋii pima. ");
INSERT INTO sil_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama Wia si bugumo ŋaa dunia, nialiŋ u si ŋaa, ba ŋaa baal ari haal nɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ŋii nɛ baal-la jaŋ leŋ u nyimma ari u naaŋ dia aŋ ka ba di u haala mɛrɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Niaa deeŋba balia jaŋ kɛŋ chal-bala. Ba bira bi jaŋ ŋaa niaa balia, see kubala. ");
INSERT INTO sil_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nialiŋ saa Wia si kaa mɛrɛ dɔŋɔ lɛ, u bi maga di nuhuobiine kaa pɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu ari u haritooroo miira sii juu dia. Ŋii nɛ ba bira piɛsu wiiŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","U bula piba, “Baal-la-na kala si via u haala aŋ bira jaa dɔŋɔ, u tiina ŋaa haal-la juu Wia haachɛ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Di haala ma nɛ via u bala aŋ ma bira mu jaa baal dɔŋ, u ma ŋaa baal-la juu Wia haachɛ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niaa sii kɔ Yesu teeŋ a kɛŋ ba haŋbiisiŋ kaa kɔ, duu joŋ u nisiŋ daŋba lɛ di Wia pɛba lɛ. Ŋii nɛ u haritooro-la kpiaba lɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu si na ŋii, u na baaniŋ u haritooro-la nyuŋ a bula piba a bul, “Má leŋ di haŋbiisi-la kɔ mi teeŋ. Ma síba kiru. Niaa deeŋba yiri nɛ hɛ Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wutitii nɛ, mi bulaa pima, di ŋ bi Wia to a nagɛ haŋbie si yie to u nyimma ari u naaŋ ŋii, ŋ bi jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋii nɛ u joŋ haŋbiisi-la a nɔgɛ, a joŋ u nisiŋ daŋba lɛ, a chuɔlɛ Wia pipiba di Wia pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu bira sie duu vɛŋ woŋbiiŋ. Baal kubala fá ku kpirimi u sipaaŋ a piɛsu, “Mi kuhia-zɔmuŋ, ɛɛ nɛ mi jaŋ ŋaa a kɛŋ miisi-la si bi dɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu piɛsu, “Bɛɛ nɛ tii ŋ yirɛmi kuhia-zɔmuŋ? Nuu-kala bi zɔŋ see Wia duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na ŋ jiŋ wialiŋ Wia si leŋe ba ŋmuŋsa bil di niaa tuto. Ba nɛ ŋla: Sí niaa kpu, sí ŋ dɔŋɔ tiina haala chɛ, sí gaa, di ŋ ŋaa daŋsia wii lɛ, sí wiaa nyia. Sí nuu-kala kuŋ girima laa. Fifá ŋ nyimma ari ŋ naaŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ŋii nɛ baal-la bula pi Yesu, “Mi kuhiaŋ, mi to wiaa deeŋba kala mi haŋbiiriŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ŋii nɛ Yesu nyilimi u siaa lɛ a chou aŋ bula pu, “Wu-bala nɛ ka, ŋ ha bi ŋaa. Joŋ ŋ kiaa kala yallɛ a joŋ moribie-la a pi summoo aŋ ku tomi. Ŋ nɛ ŋaa ŋii, ŋ jaŋ kɛŋ kiaa Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu si bul ŋii, u ŋaa baal-la siaa biri, bɛɛ wiaa u kɛŋ kiaa nɛ woruŋ. U tuɔŋ chei, u sii viiri. ");
INSERT INTO sil_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋii nɛ Yesu beŋ niaa aŋ miira bula pi u haritooro-la a bul, “U ŋaa wu-duo nɛ ari nialiŋ si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","U bul ŋii, u haritooro-la hiriki. U saa miira bula piba a bul, “Mi naŋdɔŋsuŋ, u ŋaa wu-duo nɛ ari nialiŋ si kɛŋ kiaa si jaŋ juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","U bi hɛi ari buŋtaŋŋa si jaŋ wuo to gɛri-hɛmiŋ buɔŋ lii ari u si hɛyɛ ŋii nii-la si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu si bul ŋii, u haritooro-la faasa hiriki a pipiɛsɛ dɔŋɔ, “U nɛ nagɛ ŋii, kubɛɛ nɛ saa Wia jaŋ laa ta?” ");
INSERT INTO sil_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu miira beŋba aŋ bul, “Wii-la si jaŋ kperi nuhuobiine, u bi Wia wuo kperi. Wia wuo wii-kala ŋaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ŋii nɛ Piita bula pu a bul, “Na, la-na leŋ la kuŋ-kala nɛ aŋ tuto ŋ hariŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu bula pu a bul, “Wutitii nɛ, ma leŋ ma kiaa kala nɛ aŋ tutomi. Mi saa jaŋ bula pima, nii-la kala si jaŋ wuo leŋ u dia koo u naaŋbiiriŋ koo u naaŋ koo u nyimma koo u biiriŋ koo u bagisiŋ mi wiaa ari Wia wu-zɔmɔ-la wiaa, ");
INSERT INTO sil_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u tiina jaŋ bira na diisiŋ ari naaŋbiiriŋ ari naaŋba ari biiriŋ ari bagisiŋ naaŋsiiŋ zɔlɔ dunia deeŋ lɛ. Ba ma jaŋ to u naasiŋ dudɔgisu. Di u nɛ ku suu, u ma jaŋ na miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama kuhiasiŋ yuga si jaŋ birimɛ haŋbiisiŋ. Haŋbiisiŋ ma yuga si jaŋ birimɛ kuhiasiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu si bul ŋii di ba hɛ woŋbiiŋ lɛ nɛ aa mu Jerusalɛm. Yesu laa ba sipaaŋ. U haritooroo hiriki, fawulluŋ ma kɛŋ nialiŋ dɔŋsuŋ síi to ba hariŋ. Ŋii nɛ Yesu kɛŋ u haritooroo duŋduŋa a suusa lii, a bula piba wii-la kala niaa si jaŋ ŋaau lɛ a bul, ");
INSERT INTO sil_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Má jegili mi teeŋ. Laa mu Jerusalɛm nɛ. Di la nɛ yi dimɛ, ba jaŋ kɛŋ mi-na Nuhuobiine Bie kaa mu pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba. Ba jaŋ dii mi sariya a bul di u maga di mi suu nɛ, aŋ kɛŋmi kaa mu hɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa nisiŋ lɛ di ba kpumi. ");
INSERT INTO sil_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba jaŋ mɔŋmi a jaŋ tu naŋtuɔruŋ ma hɛmi lɛ. Ba jaŋ viirɛmi aŋ kpumi maa, ka di mi sii suuŋ lɛ tapulaa batori chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ŋii nɛ Jeems ari Jɔɔŋ sii. Ba fa ŋaa Zɛbidii biiriŋ nɛ a mu Yesu teeŋ a bula pu a bul, “La kuhiaŋ, laa suluŋ di ŋ ŋaa wii nɛ a pila.” ");
INSERT INTO sil_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ŋii nɛ Yesu piɛsɛba a bul, “Wu-bɛɛ nɛ maa chɛ di mi ŋaa pima?” ");
INSERT INTO sil_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba bul, “Ŋ si jaŋ dii Wia kuorii-la a kɛŋ yiriŋ a hɔŋ ŋ kuori-kpasa nyuŋ, leŋ la ŋaa ŋ bubuɔŋ huhɔnnɔɔ, di dɔŋɔ hɔŋ ŋ na-diiŋ, di dɔŋɔ ma hɔŋ ŋ na-gua.” ");
INSERT INTO sil_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ŋii nɛ Yesu bula piba a bul, “Ma bi jiŋ ku-la ma síi chɛ. Ma jaŋ wuo nyalima na hɛɛ-la mi si jaŋ naa? Ma jaŋ wuo fo Wii-chuɔlɛ liiŋ ari ba si jaŋ fomi ŋii koo?” ");
INSERT INTO sil_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba si, “Oo, la jaŋ wuo.” Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ ma bul. Hɛɛ-la mi si jaŋ na, u-na ma ma jaŋ na. Ba si jaŋ fomi Wii-chuɔlɛ liiŋ ŋii, ba jaŋ foma ma ŋii. ");
INSERT INTO sil_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama mi na-diiŋ ari mi na-gua huhɔnnɔ-la, mi dee bi jaŋ tuɔsɛba. Wia nɛ jaŋ liisɛba di ba hɔŋ dimɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu haritooroo fii-la si ka nii Jeems ari Jɔɔŋ si bul wii-la, ba na baaniŋ ba nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ŋii nɛ Yesu yirɛ u haritooroo kala. Ba mu u teeŋ. U bula piba a bul, “Ma jiŋ nialiŋ si ŋaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa kuoroo, a fa magɛ di ba beŋ niaa woruŋ, aŋ ka ba via aŋ hɔŋ ba nyuŋ. Ba kuhiasiŋ ma kɛŋba doluŋ. ");
INSERT INTO sil_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama u bi maga di ma ŋiŋaa ŋii. Ma tuɔŋ nii-la síi chɛ u ŋaa ma kuhiaŋ, u maga duu nɛ tiŋ tiŋtiŋŋaa pipima. ");
INSERT INTO sil_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma tuɔŋ nii-la síi chɛ u ŋaa ma tuɔŋ kuoro, u maga duu nɛ ŋaa ma tuɔŋ yomo. ");
INSERT INTO sil_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mi-na Nuhuobiine Bie, mi bi kɔ di mi chɛ niaa di ba tima pimi, mi kɔ di mi-na tima piba, a suu, a laa niaa miisaa yugɛ ta a piba nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ŋii nɛ ba ku yi taŋ kubala baa yirɛ Jɛrikɔ. Ni-daŋ ku hilimi a toba. Ba kala kuu lii dimɛ di nyulima hɔŋ woŋbiiŋ niiŋ. U ŋaa sullu nɛ. U yiriŋ nɛ Batimeyas a ŋaa Timeyas bie. ");
INSERT INTO sil_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","U nia di Yesu si lii Nazarɛt níi kɔ. U si nii ŋii, u faasa yirɛ a bula pu a bul, “Yesu, Devit nihiŋ, fámi nennige.” ");
INSERT INTO sil_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Niaa yuga a kpiau lɛ duu kɛŋ goŋ, ama u faasa yirɛ a kii ŋii a bul, “Yesu, Devit nihiŋ, fámi nennige.” ");
INSERT INTO sil_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ŋii nɛ Yesu chiŋ aŋ bul di ba yiru duu kɔ. Ŋii nɛ ba yirɛ nyuluŋ-la a bula pu a bul, “Nyirɛ ŋ bɔyɛ aŋ sii kɔ. Uu yiriŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","U si nii ŋii, u wuri u gɛri-baliŋ ta aŋ sii fula mu yi Yesu. ");
INSERT INTO sil_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ŋii nɛ Yesu piɛsu, “Bɛɛ kuŋ nɛ ŋ chɛ mi ŋaa a piŋ?” Ŋii nɛ u bula pu, “Mi kuhiaŋ, leŋ di mi siaa suri di mi nina.” ");
INSERT INTO sil_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ŋii nɛ Yesu bula pu a bul, “Ŋ yarida nɛ ŋaa ŋ duori. Mumu.” Ŋii nɛ u siaa guu suri, u tuto Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ŋii nɛ Yesu ari u haritooro-la sii mumu Jerusalɛm. Ba ku yi Bɛtifagi ari Bɛtani diiriŋ, a ku yi peel kubala baa yirɛ Oliv. ");
INSERT INTO sil_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ŋii nɛ Yesu liisɛ u haritooroo balia a tiŋba a bula piba a bul, “Má mu taŋ-la si hɛ ma sipaaŋ. Di ma nɛ mua, ma jaŋ na kaku-bie di ba vɔɔ bil. Nuu-kala ha buu jila. Má puri a kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Di ma níi puru, di ba piɛsɛma a bul di bɛɛ nɛ tii maa puri, má bul di ‘la Tiina níi chɛ. U nɛ si la puro kaa kɔ. La jaŋ miira kɛnu kaa kɔ lɛɛlɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba to woŋbiiŋ bibal di ba vɔɔ kaku-bie a kii dia kubala boiŋniiŋ. Ba mu di ba puri. ");
INSERT INTO sil_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ba síi puri kaku-bie-la, di niaa dɔŋsuŋ chiŋ dimɛ a piɛsɛba, “Bɛɛ nɛ tii maa puri kaku-bie-la?” ");
INSERT INTO sil_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ŋii nɛ ba bul wialiŋ kala Yesu si si di ba bul. Ba si bul ŋii, ba leŋ ba puro mu. ");
INSERT INTO sil_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba kɛŋ kaku-bie-la kaa mu pi Yesu a wuri ba gɛnniŋ a daŋ kaku-bie-la nyuŋ. Yesu jila hɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dɔŋsuŋ ma joŋ ba gɛnniŋ a jɛrɛ woŋbiiŋ lɛ. Dɔŋsuŋ ma keri pipaariŋ a ma kaa lii jɛrɛ woŋbiiŋ lɛ duu vivɛŋ. ");
INSERT INTO sil_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Niaa dɔŋsuŋ hɛ u sipaaŋ. Dɔŋsuŋ maa to u hariŋ. Ba kala faasaa ŋaa goŋ a bubul, “Tabarikala! Wia jaŋ pɛ baala deeŋ síi kɔ la Tiina Wia doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","La naabalima Devit kuorii-la sii kɔ. Wia jaŋ pɛu lɛ duu kɔ. Má leŋ di la dɛnnɛ Wia.” ");
INSERT INTO sil_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ŋii nɛ Yesu mu Jerusalɛm a mu juu Wia-dia a beŋ kialiŋ kala si hɛ dimɛ. U bene dɛrɛ di taŋ bire. Ŋii nɛ ba di u haritooro-la fii ari balia miira mu Bɛtani a mu chua dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Taŋ si pula, ba sii lii Bɛtani a joŋ woŋbiiŋ mumu. Losuŋ kɛŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","U na tutogo duu mu chiŋ sipaaŋ a kɛŋ pipaariŋ. U mu yi u bubuɔŋ a biinɛ ari nɛnɛɛ hɛ dimɛ nɛ. U mu wula beŋ, di nɛnɛɛ tuo see pipaariŋ, bɛɛ wiaa ba nɛniŋ ha bi yie. ");
INSERT INTO sil_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ŋii nɛ Yesu bul tia-la lɛ a bul, “A lii jiniŋ a kaa mumu, nuu-kala bira bi jaŋ dii ŋ nɛnɛɛ.” U haritooroo nii Yesu si bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ŋii nɛ ba mu yi Jerusalɛm. Ba si yie, Yesu juu Wia-dia. Nialiŋ dɔŋsuŋ hɛ dimɛ a yiyallɛ kiaa, dɔŋsuŋ ma yuyɔɔ kiaa. Yesu kiriba kala ta ba lii. Baalaa ma hɛ dimɛ a yiyɛrɛ moribiee. Yesu ŋmoo ba teebulba lo. Baalaa dɔŋsuŋ ma yallɛ kokosuŋ. U ŋmoo ba ma kpasinniŋ a lo. ");
INSERT INTO sil_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","U bi sɛyɛ di nuu-kala kɛŋ kiaa kaa ku to Wia-dia-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ŋii nɛ Yesu dagɛba a bula piba a bul, “Ma bi liisɛ wialiŋ ba si ŋmuŋsa Wia teniŋ lɛɛ? Ba ŋmuŋsa di Wia si, u dia jaŋ ŋaa lee-la niaa si jaŋ chuchuɔlɛ Wia, aŋ ka ma-na miira kaa birimɛ gaari-dia.” ");
INSERT INTO sil_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba, ba kala nii wii-la u si bula. Ŋii nɛ baa chɛ woŋbiiŋ di ba to kpuu. Wialiŋ Yesu si daga, niaa yuga a jegile nii, u ŋaaba wu-kpuŋkpere. Ŋii nɛ tii fawulluŋ kɛŋ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba. Ba chichɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Didaaniŋ si yie, Yesu ari u haritooroo lii taŋ-la lɛ di ba mu piŋ. ");
INSERT INTO sil_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chichuɔ-fiɛla ba joŋ woŋbiiŋ aa vɛŋ, a bira na tutogo-la duu kala suba a tuu kɛŋ u naapoloo pɛ. ");
INSERT INTO sil_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ŋii nɛ Piita liisi wii-la Yesu si bul tia-la lɛ a bula pi Yesu a bul, “La kuhiaŋ, bee na tia-la lɛ ŋ si kaliba hɛ, u suba nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ŋii nɛ Yesu bula piba a bul, “Má ŋaa yarida ari Wia. ");
INSERT INTO sil_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wutitii nɛ mi bulaa pima, di ma nɛ ŋaa Wia yarida a bi tuɔsaa balia kɛnɛ, ma jaŋ bul di peeliŋ sii mu tel muga tuɔŋ. U jaŋ ŋaa a pima. ");
INSERT INTO sil_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ŋii wiaa kialiŋ-na kala ma si chuɔlɛ Wia a susul, di ma nɛ kɛŋ yarida, ma jaŋ naba. ");
INSERT INTO sil_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bua-na kala di ŋ nɛ sii chiŋ a chuchuɔlɛ Wia, biina na di ma di nuu kɛŋ wii. Di u cho duu nagɛ ŋii ma kala, ŋ́ joŋo chɛu. Ŋ nɛ ŋaa ŋii, Wia si hɛ Wia-jaŋ lɛ, u ma jaŋ joŋ ŋ haachɛba chɛŋ.  ");
INSERT INTO sil_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama di ŋ nɛ bi wiaa joŋo chɛ ŋ dɔŋsuŋ tiŋŋaa, ŋ Nyimma Wia si hɛ Wia-jaŋ lɛ, u ma bi jaŋ joŋ ŋ haachɛba chɛŋ.” ");
INSERT INTO sil_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba bira kɔ Jerusalɛm a mu juu Wia-dia. Yesu síi vɛŋ Wia-dia tuɔŋ ŋii, nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba ari Ju̱u tiŋŋaa kuhiasiŋ, ba kala sii kɔ u teeŋ ");
INSERT INTO sil_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a piɛsu a bul, “Dol bɛɛ nɛ ŋ kɛŋ a ŋiŋaa wiaa deeŋba? Kubɛɛ nɛ piŋ doluŋ ŋ ŋiŋaa ŋii?” ");
INSERT INTO sil_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ŋii nɛ Yesu bula piba a bul, “Mi ma jaŋ piɛsɛma wu-bala. Di ma nɛ dagɛmi u bubuɔŋ, mi ma jaŋ dagɛma dol-la mi si kɛnɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ŋii nɛ u piɛsɛba a bul, “Jɔɔŋ, Wia lii-foori-la doluŋ, u lii Wia teeŋ nɛɛ koo u lii nuhuobiine teeŋ nɛɛ? Má dagɛmi.” ");
INSERT INTO sil_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba suomo kɛŋ wii-la lilɛrɛ dɔŋɔ lɛ aa bul, “Wu-bɛɛ nɛ laa chɛ di la bul? Di la nɛ bula pu a bul di Wia teeŋ nɛ u lii, u jaŋ piɛsɛla a bul, ‘Bɛɛ nɛ saa tii ma bi wialiŋ u si bula laa dii?’ ");
INSERT INTO sil_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","La saa jaŋ wuo bul u lii nuhuobiinee teeŋ nɛɛ? Ai.” Fawulluŋ kɛŋba a tiŋ nialiŋ si chiŋ dimɛ wiaa. Niaa bula ari Jɔɔŋ fa sɛnɛ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ŋii nɛ ba bula pi Yesu a bul, “La bi jiŋ.” Yesu ma bula piba a bul, “Tɔɔ, mi ma bi jaŋ dagɛma dol-la mi si kɛnɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu bira magɛ namaga a piba a bul, “Baal kubala nɛ bil baga a chɔŋsɛ kiaa si kɛŋ nɛnɛɛ yugɛ a nagɛ chichuɛŋ. Ba yiyirɛ gireps. U saa ligɛ baga-la golli nɛ. U lu bua baga-la tuɔŋ di ba chagɛ tii-nɛnɛ-la liiŋ hihɛ, a saa lusuŋ nyuŋ dia ma a hɔnɔ pɔ. U paa niaa a hɛ u baga-la tuɔŋ di ba titiŋ. Ka u mu taŋ dɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tii-nɛnɛ-la bii, u tiŋ u dia tiŋtinnaa dɔŋɔ duu mu tiŋtinna-la teeŋ a laa tii-nɛnɛɛ kaa kɔ. U mu. ");
INSERT INTO sil_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ba kɛnu a ŋmobu aŋ leŋ u kɛŋ na-hilliŋ miira mu baga tiina teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","U bira miira tiŋ tiŋtinna-la dɔŋɔ. U ma bira mu. Ba kɛnu a ŋmobu a yagɛ u nyuŋ luri a jolimu. ");
INSERT INTO sil_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","U bira tiŋ tori, u bira mu. Ba kpuu. U tiŋ niaa yugɛ. Ba ŋaa ŋii titia nialiŋ ma lɛ. Ba ŋmoo dɔŋsuŋ aŋ kpu dɔŋsuŋ maa. ");
INSERT INTO sil_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nii-la si ka, u bii-chooluŋ nɛ ŋii. Ŋii hariŋ lɛ nɛ u timu. U biina u bie nɛ mua, ba jaŋ zilu. U ma bira mu. ");
INSERT INTO sil_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tiŋtinna-la si na bile, ba bula pi dɔŋɔ a bul, ‘Di baga-la tiina nɛ suba, bie deeŋ nɛ jaŋ dii u kiaa. Má kɔ di la kpuu. Di la nɛ kpuu, la nɛ jaŋ miira tii u kialiŋ.’ ");
INSERT INTO sil_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba kɛŋ bile a kpuu a joŋu yuo ta baga-la hariŋ.” ");
INSERT INTO sil_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ŋii nɛ Yesu piɛsɛba, “Ɛɛ nɛ baga-la tiina jaŋ ŋaa? U jaŋ kɔ a kpu tiŋtinna-la kala, aŋ joŋ baga-la a pi ni-tania.” ");
INSERT INTO sil_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ŋii nɛ Yesu piɛsɛ nialiŋ si nii namaga-la, “Ma bi Wia teŋ-la karimaa a mu yi lee-la ba si bul ŋlaa? ‘Tiebii-la dii-saaraa si via, u nɛ miira ku ŋaa tiebii-duoŋ ba si joŋo bil dia geŋtine. ");
INSERT INTO sil_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","La Tiina Wia tiŋtiŋŋaa nɛ ŋii. U ŋaala wu-kpuŋkpere nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu si bul ŋii, Ju̱u tiŋŋaa kuhiasiŋ chichɛ di ba kɛnu kaa mu tɔ dia, bɛɛ wiaa ba jima ari u magɛ namaga-la a tigɛba lɛ nɛ. Ama ba fá nialiŋ si hɛ dimɛ. Ŋii nɛ tii ba leŋu aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ba miira mu aŋ tiŋ Farisii tiŋŋaa dɔŋsuŋ ari Hɛrɔd haritooroo dɔŋsuŋ di ba bira mu Yesu teeŋ a magisu a bɛrɛ kɛnu. ");
INSERT INTO sil_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba kɔ u teeŋ a bula pu a bul, “La kuhiaŋ, la jima di ŋ kɛŋ wutitii nɛ. Ŋ sipaaŋ tuo nuu lɛ. Ŋ bi ni-bal síi ka fá. Ŋŋ dagɛ Wia woŋbii-titii nɛ. U ŋaa woŋbiiŋ nɛ di la tiŋ laŋpoo a pi Rom tiŋteeŋ kuori-baliŋ ba síi yirɛ Siiza koo? Dagɛla. ");
INSERT INTO sil_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","La time pu koo la sí pa?” Yesu jima nɛ di ba fugoo bul nɛ, ŋii nɛ u piɛsɛba a bul, “Bɛɛ nɛ tii maa magisɛmi? Má kɛŋ moribii-biiŋ kaa kɔ di mi bee na.” ");
INSERT INTO sil_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba kɛŋ dɔŋɔ kaa kɔ. Ŋii nɛ u piɛsɛba, “Kubɛɛ nyuŋ nɛ hɛ dimɛ? Kubɛɛ yiriŋ ma nɛ ba tuuro hɛ moribii-la lɛ?” Ŋii nɛ ba bul di Siiza yiriŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","U bula piba a bul, “Tɔɔ, má joŋ Rom tiŋteeŋ kuori-bal-la kiaa pu aŋ joŋ Wia ma kiaa pu.” Yesu si bul ŋii, ba niiriŋ kala maa. Ba leŋu aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ŋii nɛ nialiŋ dɔŋsuŋ ba síi yirɛ Sadusii tiŋŋaa, ba kɔ u teeŋ. Sadusii tiŋŋaa yie si di nuu nɛ suba, u bira bi sii. Ba piɛsu wiaa a bul, ");
INSERT INTO sil_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“La kuhiaŋ, Moosis dagɛla Wia teniŋ tuɔŋ ari baala nɛ jaa haala, di haal-la ari baal-la nɛ bi bii lula, aŋ ka di baal-la suu, u maga di u ŋaana joŋ haal-la jaa nɛ. Di u lul biiriŋ pi u maala-la si suba, biiri-la jaŋ chiŋ u nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naaŋbiiriŋ balipɛ nɛ fa hɛ dimɛ. Ba kala ŋaa baalaa nɛ. Ba naaŋ kubala, ba nyimma ma kubala. Ba kuhiaŋ jaa haala. Ba di haal-la bi bii lula, aŋ ka u suu. ");
INSERT INTO sil_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Liamiŋ tiina joŋ haal-la jaa. Ba duu ma bi bii lula. Ka u ma suu. Torimuŋ tiina ma joŋ haal-la jaa. U ma ŋii titia nɛ. ");
INSERT INTO sil_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naaŋbiiri-la balipɛ kala nɛ jaa haal-la. U bi lula. Ŋii hariŋ lɛ nɛ haal-la ma titia suu. ");
INSERT INTO sil_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tapulii-la niaa si jaŋ sii suuŋ lɛ, baalaa deeŋba balipɛ tuɔŋ, kubɛɛ nɛ jaŋ tii haal-la? Ba kala balipɛ nɛ jaau.” ");
INSERT INTO sil_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ŋii nɛ Yesu bula piba a bul, “Ma bi Wia teniŋ jiŋ. Ma ma bi Wia doluŋ jiŋ. Ŋii nɛ tii ma yeŋŋi. ");
INSERT INTO sil_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tapulii-la niaa si jaŋ sii suuŋ lɛ, baalaa bira bi jaŋ jaa haalaa, haalaa ma bira bi jaŋ jaa balaba. Ba kala jaŋ nagɛ Wia tiŋdaaraa si hɛ Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ŋii nɛ Yesu bula piba a bul, “Na ma piɛsɛmi nialiŋ si jaŋ sii suuŋ lɛ wiaa. Ma bi karimɛ wialiŋ Moosis si bula Wia teniŋ tuɔŋ, lee-la u fa si bul wiaa a tigɛ tii-bie síi dii nyiniŋ lɛɛ? Wia nɛ bula pu duu nɛ ŋaa Abiraham Wia ari Aizik Wia ari Jekɔb Wia. (Bua-la lɛ u si bul ŋii di Abiraham ari Aizik ari Jekɔb fa suba nɛ.) ");
INSERT INTO sil_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wiaa deeŋba u si bula, ba bubuɔsaa nɛ di Abiraham ari Aizik ari Jekɔb bira sii suuŋ lɛ nɛ a hɛ Wia kuorii-la tuɔŋ. Wia bi jaŋ wuo ŋaa nialiŋ si suba Wia. U ŋaa ni-weyee Wia nɛ. Ma bi wii-kala jiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wia teniŋ kerichiba dɔŋɔ nia ba si kɛŋ wii-la lilɛrɛ. U kɔ ba teeŋ. U si na di Yesu chaarɛ wiaa siaa woruŋ, u piɛsu a bul, “Wialiŋ Wia si dagɛ niaa baa to, kubɛɛ nɛ ŋaa ba tuɔŋ wu-baliŋ?” ");
INSERT INTO sil_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","U bula piba a bul, “Ba bula pi Iziral niaa a bul, ‘Iziral niaa, má jegile nii mi teeŋ. La Tiina Wia duŋduŋa nɛ hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋ́ kɛŋ ŋ tuɔŋ kala ari ŋ tuɔbiinaa kala ari ŋ wii-wii-kala a cho ŋ Tiina Wia.’ Ba tuɔŋ ku-baliŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wu-liamiŋ ma nɛ ŋla: ‘Cho ŋ dɔŋɔ tiina ari ŋ si cho ŋ titia ŋii.’ Wialiŋ Wia si bula, wii-kala tuo a kii wiaa deeŋba baliamiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋii nɛ Wia teniŋ kerichi-la bula pu a bul, “La kuhiaŋ, wutitii nɛ ŋ bul ŋii. Wia duŋduŋa nɛ hɛ dimɛ, kuŋ-kala bira tuo see Wia duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ŋ si jaŋ kɛŋ ŋ tuɔŋ kala ari ŋ tuɔbiinaa kala ari ŋ wii-wii-kala a cho Wia, a cho ŋ dɔŋɔ tiina ari ŋ si cho ŋ titia ŋii, u nɛ kpia ŋ si joŋ pusuŋ kpu a nyiga pi Wia, koo ŋ si joŋ kiaa dɔŋsuŋ a bile pi Wia.” ");
INSERT INTO sil_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu na di baal-la kɛŋ wu-jimiŋ. Ŋii nɛ u bula pu a bul, “Ma di Wia kuorii-la bi bol.” U si bul ŋii dɛrɛ, nuu-kala bira bi nyu-duoŋ kɛnɛ duu piɛsu wii-kala. ");
INSERT INTO sil_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu bira dagɛ niaa Wia-dia tuɔŋ a piɛsɛba, “Ɛɛ nɛ Wia teniŋ kerichiba jaŋ wuo bul ari Kirisito, nii-la Wia si liisa, jaŋ ŋaa Devit nihi duŋduŋ nɛ? ");
INSERT INTO sil_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wia Diŋ-zɔŋ-la nɛ fa dagɛ Devit duu bul wiaa a tigɛ Kirisito lɛ. Ŋla nɛ u bul, ‘La Tiina Wia bula pi mi Tiina duu hɔŋ u sɛmɛ, ni-duoŋ di-hɔnuŋ, see duu yuo dii u diŋdɔŋŋɔɔ kala dɛrɛ.’ ");
INSERT INTO sil_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit titia yirɛ nia deeŋ u Tiina. Ɛɛ nɛ saa u jaŋ wuo ŋaa u nihi duŋduŋ?” Yesu síi bul wiaa, niaa yuga a jegile nii u teeŋ ari tuɔtɔruŋ. ");
INSERT INTO sil_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu bira dagɛba a bul, “Má kɛŋ ma titia woruŋ Wia teniŋ kerichiba lɛ. Ba yie gugɔllɛ yɔbɔ lɛ ari ba gɛri-duduosuŋ aa chɛ di niaa jujoŋba jirima a chuchuɔlɛba. ");
INSERT INTO sil_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba yie chichɛ ni-balaa di-hɔnuŋ Wii-chuɔlɛ diisiŋ lɛ. Di ba nɛ yirɛba di ba ku dii kiaa, ba cho di ba hɔŋ ni-balaa di-hɔnɔɔ maa. ");
INSERT INTO sil_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba yie fugo chuɔlɛ Wia didieni a kɛŋ yo-haalaa kiaa laa didii. Bua-la lɛ Wia si jaŋ dii ba sariya, ba nɛ jaŋ na hɛɛŋ a kii ba dɔŋsuŋ tiŋŋaa kala.” ");
INSERT INTO sil_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu mu hɔŋ lee-la niaa si joŋ ba moribiee bil a pipi Wia a nina ŋii ba síi hɛ. Nialiŋ si kɛŋ kiaa, ba faasa hihɛ moribiee. ");
INSERT INTO sil_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ŋii nɛ yo-haal kubala ma kɔ. U ŋaa summu nɛ a mu joŋ amiisiŋba balia a ma hɛ. Kɔbu nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ŋii nɛ Yesu yirɛ u haritooroo a bula piba a bul, “Wutitii nɛ mi bulaa pima, yo-haala deeŋ moribii-bie-la u si joŋo hɛ, u nɛ kii nialiŋ moribie-la kala. ");
INSERT INTO sil_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nialiŋ kala si joŋ moribiee a pi Wia, ba liisa aŋ ka nɛ. Aŋ ka u-na joŋ u summu moribiiŋ kala a hɛ, ku-la kala u si kɛnɛ nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu si lii Wia-dia ku lii, ŋii nɛ u haritooroo dɔŋɔ bula pu a bul, “Mi kuhiaŋ, na tiebie-la ba si kaa saa dia-la, ba zɔmɔ kiŋkɛŋ, jaŋ-la ma kala zɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ŋii nɛ Yesu bula pu a bul, “Ŋ na ja-baliŋ deeŋ? Ba jaŋ ŋmoo jaŋ-la kala lo. Ba bi jaŋ leŋ di tiebii-bala ma ka daŋ u dɔŋɔ lɛ.” ");
INSERT INTO sil_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ba mu jil peel kubala baa yirɛ Oliv, a hɔŋ u nyuŋ, a bee nina ja-bal-la. Piita ari Jeems ari Jɔɔŋ ari Aŋduru luɔra piɛsu, ");
INSERT INTO sil_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bua bɛɛ lɛ nɛ wiaa deeŋba jaŋ ŋaa? Bɛɛ kiaa nɛ la jaŋ na, ka wiaa deeŋba-na ŋaa?” ");
INSERT INTO sil_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ŋii nɛ Yesu bula piba a bul, “Má kɛŋ ma titia woruŋ di nuu-kala sí ma nyisu. ");
INSERT INTO sil_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Niaa jaŋ yugɛ a kɔ a joŋ mi yiriŋ hɛ ari ba nɛ ŋaa Kirisito, a nyisɛ niaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma jaŋ nii ari laaliŋ hɛ daha a hɛ di-boluŋ maa. Di ma nɛ ku nii ŋii, ma sí leŋe di ma bɔyɛ joŋ. Wiaa deeŋba kala jaŋ ŋaa bal, ama dunia didɛriŋ ha dee ŋii. ");
INSERT INTO sil_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tiŋteeŋ dɔŋɔ niaa jaŋ sii a mu a yuo tiŋteeŋ dɔŋɔ niaa. Taŋ kuoro ari u niaa jaŋ sii giri a mu yuo kuoro dɔŋɔ ari u niaa. Tiŋteeŋ jaŋ zigili leree yugɛ. Losuŋ ma jaŋ juu. Hɛɛŋ di-suomuŋ nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ama má kɛŋ ma titia woruŋ. Ba jaŋ kɛŋma kaa mu nialiŋ si yie hilime vuvuurɛ wiaa teeŋ di ba dii ma sariya. Ba jaŋ ŋmooma Wii-chuɔlɛ diisiŋ lɛ. Ma ma jaŋ chiŋ kuoroo ari taŋ kuhiasiŋ sipaaŋ a tiŋ mi wiaa a dii mi daŋsia. ");
INSERT INTO sil_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ba jaŋ laa sipaaŋ bul Wia wu-zɔŋŋɔɔ a pi niaa leriŋ kala aŋ ka di wiaa deeŋba-na ŋaa. ");
INSERT INTO sil_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Di ba nɛ kɛŋma kaa mu di ba dii ma sariya, ma sí leŋe di ma bɔisiŋ joŋ wialiŋ ma si jaŋ bul lɛ a laa ma titia. Bua-la lɛ Wia jaŋ joŋ wu-jimiŋ a hɛ ma nyuŋ lɛ. Wii-la kala si kɔ ma nyuŋ, má bul. Ma dee bi jaŋ bul, Wia Diŋ-zɔŋ-la nɛ jaŋ joŋo hɛ ma nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naaŋbiiriŋ jaŋ kɛŋ dɔŋɔ a kaa mu pa di ba kpu. Nyimmaba ma jaŋ ŋaa ŋii ba biiriŋ lɛ. Biiriŋ ma jaŋ ŋaa ŋii a ma kɛsɛ ba nyimmaba ari ba naaŋba, a ma kaa mu pa di ba kpu. ");
INSERT INTO sil_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nuu-kala jaŋ bɛrɛma a tiŋ mi wiaa. Ama nuu-kala si nyalimɛ a mu dɛrɛ, Wia jaŋ laau ta. ");
INSERT INTO sil_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ma jaŋ na di ba joŋ ku-lɔruŋ a bil lee-la u si bi maga u hɛ. Kua deeŋ jaŋ ŋaa wu-bɔŋŋɔɔ. U jaŋ chei Wia yiriŋ. (Ma si jaŋ karimɛ wiaa deeŋba, ma jaŋ jiŋ ba bubuɔsaa.) Di ma na ŋii, má leŋ di nialiŋ si hɛ Judiya lɛ, di ba fá jil peelee nyuŋ a faa. ");
INSERT INTO sil_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Di nuu-kala hɛ lusuŋ nyuŋ a nii wiaa deeŋba, di u nɛ ku tuu, duu sí u dia juu a chichɛ u paa u kiaa. ");
INSERT INTO sil_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Di nuu nɛ hɛ baga lɛ a nii wiaa deeŋba, duu sí miira mu dia a chichɛ duu joŋ u gɛriŋ. ");
INSERT INTO sil_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nialiŋ si kɛŋ luoroo ari nialiŋ si nɔgɛ biiriŋ, oi, ba jaŋ na hɛɛŋ yugɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Máa sul Wia di wiiŋ deeŋ sí yibiiniŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wia si ŋaa dunia a ku lii jiniŋ, nuu-kala ha bi hɛɛŋ deeŋ na a nagɛ ŋii, nuu bira bi jaŋ na hɛɛŋ ŋii a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Di Wia fa bi tapulia-la kere ta, ni-bala ma fa bi jaŋ ka. Ama nialiŋ Wia si liisa di baa tou, ba wiaa nɛ tii u keri tapulia-la ta. ");
INSERT INTO sil_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Di nuu-kala nɛ bula piŋ di ŋ beŋ daha a na Kirisito-la, koo di ŋ beŋ dimɛ a nau, síu yarida ŋaa. ");
INSERT INTO sil_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Niaa dɔŋsuŋ jaŋ sii fugo bul di ba nɛ ŋaa Kirisito, nii-la Wia si liisa. Dɔŋsuŋ ma jaŋ sii fugo bul di ba ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Ba jaŋ ŋaa wu-magilaa ari wu-kpuŋkperisiŋ a chichɛ di ba nyisɛ nialiŋ Wia si liisa di baa tou. ");
INSERT INTO sil_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wiaa deeŋba kala mi laa sipaaŋ bula pima, ka di bua-la-na yi. Má kɛŋ ma titia woruŋ.” ");
INSERT INTO sil_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ŋii nɛ Yesu bira bula piba a bul, “Tapulia-la hɛɛŋ deeŋ si kiele, taŋ jaŋ biri di taŋ nɛ pula maa. Chɛnɛ ma bira bi jaŋ pɔsɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chɛŋwulaa jaŋ lii wia nyuŋ ku tuu a titel. Ba jaŋ kiri wia nyuŋ kialiŋ kala si kɛŋ doluŋ di ba lii ba leree. ");
INSERT INTO sil_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ŋii lɛ nɛ ma jaŋ na mi-na Nuhuobiine Bie, di mi to duoŋbiliŋbaanaa tuɔŋ ku tuu. Mi jaŋ kɛŋ doluŋ yugɛ a chaanɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ŋii lɛ nɛ mi jaŋ tiŋ Wia tiŋdaaraa di ba mu dunia sɛmɛ-na kala a kɛŋ nialiŋ kala Wia si liisa di baa tou a hilimi. ");
INSERT INTO sil_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Di ma na sɔjaamiŋ duu kuu tɔsɛ, ma jima ari liŋbaŋa yie nɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Namaga deeŋ lɛ ma jaŋ gunnɛ wiaa. Di ma na wiaa deeŋba kala di baa ŋaa, ma jiŋ di mi-na Nuhuobiine Bie kpaga nɛ. ");
INSERT INTO sil_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wutitii mi bulaa pima, ma lɛɛlɛ niaa deeŋba si hɛ ma miisiŋ deeŋ lɛ bi jaŋ suu, ka wiaa deeŋba ŋaa bal. ");
INSERT INTO sil_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wia nyuŋ ari tiŋteeŋ kala jaŋ dɛrɛ, ama wialiŋ mi si bula bi jaŋ lɛl. ");
INSERT INTO sil_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ama nuu-kala bi jaŋ jiŋ chɛɛ-la wiaa deeŋba si jaŋ ŋaa. Wia tiŋdaaraa si hɛ Wia-jaŋ ma paala bi jaŋ jiŋ. Mi-na Wia Bie ma bi jaŋ jiŋ, see mi Nyimma duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Má kɛŋ ma titia woruŋ a pɔ, bɛɛ wiaa ma bi wialiŋ si jaŋ ŋaa chɛɛ-la jiŋ. ");
INSERT INTO sil_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","U nagɛ baala si sie aa chɛ u vɛŋ woŋbiiŋ nɛ. Di u lii dia lɛ, u jaŋ dagɛ u tiŋtinnaa ba tiŋtiŋŋaa aŋ bula pi nii-la síi beŋ u dia maa duu pɔ woruŋ duu miira kɔ. ");
INSERT INTO sil_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Má saa pɔ woruŋ, bɛɛ wiaa ma bi jiŋ chɛɛ-la dia-la tiina si jaŋ kɔ, di didaaniŋ nɛɛ, di tita-siesee nɛɛ, di siipuuraa nɛɛ, koo chichuɔŋ nɛɛ, ma bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Má bibeŋ a pɔ woruŋ, di ŋii dee, u jaŋ guu kɔ di ma piŋ doŋ. ");
INSERT INTO sil_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wii-la mi si bulaa pima, u nɛ mi bulaa pi nuu-kala, má pɔ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tapulaa balia nɛ ka duu yi ba chɛ-bal-la: Diisiŋ kieliŋ gbiele-la. Tapulii-la nɛ ba yie dii boroboro si bi si-buruŋ kɛnɛ. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia ari Wia teniŋ kerichiba, baa chɛ woŋbiiŋ di ba luɔra kɛŋ Yesu a kpu. ");
INSERT INTO sil_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba bula di ba síu kɛŋ ba chɛ-bal-la chɛɛŋ, di ba nɛ ŋaa ŋii, niaa jaŋ ŋaa taawɛi. ");
INSERT INTO sil_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","U mu Bɛtani a hɔŋ Saamɔŋ dia lɛ a didii kiaa. Saamɔŋ fa ŋaa gbege nɛ aŋ ku duori. Uu dii kiaa di haal kubala ku juu a kɛŋ tulaali ari loŋ. U suɔra sima, u yalliŋ ma hɛyɛ. U kɛŋ loŋ-la suri a liisɛ nuu-la a bisa hɛ Yesu nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka nialiŋ dɔŋsuŋ hɔnɔ gugurimɛ a pipiɛsɛ dɔŋɔ a bul, “Bɛɛ nɛ tii haala deeŋ kɛŋ nuu-la a kaa chei ŋla? ");
INSERT INTO sil_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Di ba nɛ fa yaara joŋ nuu-la a yallɛ, u fa jaŋ kii siidi bui balia di ba fa joŋo pi summoo.” Ba sii tutuusɛ haal-la. ");
INSERT INTO sil_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ŋii nɛ Yesu bula piba a bul, “Má leŋ haal-la. Bɛɛ nɛ tii ma wiwalimu? Wu-zɔŋ nɛ u ŋaami lɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ma di summoo jaŋ hɛ dimɛ bua-na kala lɛ. Bua-na kala lɛ nɛ ma chichɛ ma ŋaa wu-zɔmuŋ a pi summo-la, ma jaŋ wuo ŋaa, ama la di ma bi jaŋ hɛ dimɛ deeŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Haal-la ŋaa kukeri nɛ. U ŋaa wii-la kala u si jaŋ wuo ŋaa nɛ. U tisɛ mi yaraa di ba hugi nɛ, ka mi ha bi suba. ");
INSERT INTO sil_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wutitii nɛ mi bulaa pima, dunia sɛmɛ-na kala ba si jaŋ wuo mu a bul Wia wu-zɔmɔ-la, ba jaŋ liisi haala deeŋ ma wiaa a bul.” ");
INSERT INTO sil_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ŋii nɛ Judas Isikarɔt sii. U ŋaa Yesu haritooro-la fii ari balia dɔŋɔ nɛ. U sii mumu nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ teeŋ duu kɛŋ Yesu yalla piba. ");
INSERT INTO sil_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba si nii ŋii, ba tuɔŋ tɔrɛ. Ba bul ba jaŋ joŋ moribiee pu. A chiŋ bua-la lɛ u suomo chichɛ woŋbii-la u si jaŋ to a kɛŋ Yesu yalla piba. ");
INSERT INTO sil_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ba chɛ-bal-la tapul-buŋbuŋ ba si yie dii boroboro-la si bi si-buruŋ kɛnɛ aŋ kpu piese-la ba si yie kaa ŋaa gbiele-la kudiilee, Yesu haritooro-la sii a piɛsu, “Nii nɛ ŋ cho di la mu ŋaa diisiŋ kieliŋ gbiele-la kudiilee di ŋ ku dii?” ");
INSERT INTO sil_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ŋii nɛ u tiŋ u haritooroo balia a bula piba a bul, “Má mu juu taŋ-la tuɔŋ. Di ma nɛ mua, ma jaŋ cheŋ baal kubala duu chuŋ nyuvie ari liiŋ. Má to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dia-na kala u si jua, má to juu bula pi dia-la tiina a bul, ‘La kuhiaŋ si, la piɛsiŋ di nii lɛ nɛ nuhuɔra dia hɛ di ba di u haritooroo juu a hɔnɔ dii diisiŋ kieliŋ gbiele kudiilee?’ ");
INSERT INTO sil_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U jaŋ dagɛma dii-bal kubala. U ŋaa lusuŋ nyuŋ dia nɛ. Ba wasu kala. Lee-la nɛ ma jaŋ ŋaa kudiile-la.” ");
INSERT INTO sil_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋii nɛ u haritooro-la sii lii a mu taŋ tuɔŋ a na wialiŋ kala Yesu si bula piba di ba ŋaa wutitii a ŋaa diisiŋ kieliŋ gbiele-la kudiilee ba dii. ");
INSERT INTO sil_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wia si jua, Yesu ari u haritooroo ku juu a hɔŋ a didii kialiŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba síi dii kiaa ŋii, ŋii nɛ Yesu bula piba a bul, “Wutitii, mi bulaa pima, ma niaa deeŋba síi dii kialiŋ, ma dɔŋɔ jaŋ joŋmi yallɛ. La duu nɛ pɛ dɔŋɔ a didii kiaa lɛɛlɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ba si nii wii-la, ba tuɔŋ chei. Ba kala pipiɛsɛ kuŋ kuŋ. Dɔŋɔ yie piɛsɛ, “Mi nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu bula piba a bul, “Ma fii ari balia deeŋba tuɔŋ kubala nɛ, la kala nɛ chala kɛŋ boroboro tutuu gbaŋa-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi-na, Nuhuobiine Bie, mi jaŋ suu ari ba si ŋmuŋsɛ ŋii a tigɛmi lɛ. Ama nii-la si joŋ mi-na Nuhuobiine Bie yallɛ, aa, u jaŋ na hɛɛŋ yugɛ. Ba fa si buu lula, u nɛ kpia.” ");
INSERT INTO sil_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba si hɔnɔ didii kiaa, ŋii nɛ Yesu sii a joŋ boroboro a lɔllɛ Wia aŋ kaa chɔgɛ chɔgɛ, a joŋo pi u haritooroo, a bula piba a bul, “Má laa. Mi yaraa namia nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ŋii nɛ u bira joŋ nyunyuala maa ari siniŋ a lɔllɛ Wia aŋ joŋo piba. Ba kala nyua nyunyual-bala-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ŋii nɛ Yesu bula piba, “Mi chaliŋ nɛ ŋii. Chaliŋ deeŋ wiaa nɛ tii Wia ta niiŋ ma teeŋ. Mi chaliŋ jaŋ jaasɛ ni-kɛnɛ wiaa, di Wia joŋ ba haachɛba chɛba. ");
INSERT INTO sil_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wutitii nɛ mi bulaa pima, mi bira bi jaŋ kɔ di mi nyua siniŋ deeŋ, see tapulii-la mi si jaŋ kɔ nɛ, mi jaŋ nyua si-faliŋ Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ŋii nɛ ba yii Wii-chuɔlɛ yiiliŋ a dɛrɛ aŋ sii lii a mu peel kubala baa yirɛ Oliv. ");
INSERT INTO sil_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ŋii nɛ Yesu bula piba a bul, “Ma kala jaŋ fá viiri. Ba ŋmuŋsɛ Wia teniŋ tuɔŋ di Wia jaŋ kpu pie-daara, aŋ ka piesee fá pisɛ. Ba si ŋmuŋsɛ ŋii Wia teŋ-la, wii-la jaŋ ŋaa. Ma kala jaŋ fá mi teeŋ aŋ leŋmi. ");
INSERT INTO sil_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wia jaŋ chisɛmi suuŋ lɛ. U nɛ chisɛmi, mi jaŋ laa ma sipaaŋ a mu Galilii.” ");
INSERT INTO sil_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ŋii nɛ Piita bula pi Yesu a bul, “Di ba kala fá maa aŋ leŋiŋ, mi-na bi jaŋ miirɛ ŋ hariŋ.” ");
INSERT INTO sil_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ŋii nɛ Yesu bula pu a bul, “Wutitii nɛ, jiniŋ titaŋiŋ deeŋ, ŋ-na Piita, ŋ jaŋ bul naaŋsiiŋ butori ari ŋ bimi jiŋ, ka di ji-bele-na yel naaŋsiiŋ bulia.” ");
INSERT INTO sil_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ŋii nɛ Piita bul ari siifiɛsiŋ a bul, “La diŋ paala susuu maa, mi bi jaŋ bul ari mi biŋ jiŋ.” Ku-kaanaa ma kala bul ŋii. ");
INSERT INTO sil_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ŋii nɛ ba mu juu lee kubala baa yirɛ Gɛtisɛmani. Yesu bula pi u haritooroo di ba hɔŋ daha, ka u mu chuɔlɛ Wia aŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","U kɛŋ Piita ari Jeems ari Jɔɔŋ a kaa mu dimɛ. Yesu tuɔŋ kala chei. U tuɔŋ bi pina. ");
INSERT INTO sil_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","U bula pi u haritooroo a bul, “Mi tuɔŋ kala nɛ cheye a magɛ di mi suu. Má hɔnɔ pɔ daha.” ");
INSERT INTO sil_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ba hɔŋ. Ka u suusa mu sipaaŋ mua a tuu kpirimi tiŋteeŋ a sul Wia a bul duu nɛ kɛŋ woŋbiiŋ, duu sí leŋe di wii-la juu-u lɛ ");
INSERT INTO sil_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","a bira bul, “Mi Nyimma, ŋ jaŋ wuo ŋaa wii-kala. Liisɛ hɛɛ-la síi kɔmi lɛ. Ama mi-na ŋla tuɔtɔruŋ lɛ dee, ŋ-na tuɔtɔruŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","U chuɔla dɛrɛ aŋ sii kɔ u haritooroo teeŋ di ba piŋ doŋ. Ŋii nɛ u piɛsɛ Piita a bul, “Ŋ pina nɛɛ? Ŋ bi doŋ muapilii ma wuo bɛrɛɛ a diene yi hawa kubalaa? ");
INSERT INTO sil_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Má chuɔlɛ Wia a pupɔ di Sitaani sí wuo nyisɛma. Ma tuɔŋ lɛ ma cho di ma ŋaa wu-zɔŋŋɔɔ, aŋ ka ma bi doluŋ kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","U bira mu a chuɔlɛ Wia a bira bul ŋii titia. ");
INSERT INTO sil_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","U miira kɔ di ba bira piŋ doŋ, bɛɛ wiaa doŋ kɛŋba nɛ woruŋ. Ba bi jiŋ ba si jaŋ bul wii-la kala a pu. ");
INSERT INTO sil_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","U miira mu torimuŋ aŋ ku piɛsɛba, “Ma ha pinaa wiesi nɛɛ? Má sii, bua-la yie nɛ. Ba jaŋ kɛŋ mi-na, Nuhuobiine Bie a pi haachɛ diiree. ");
INSERT INTO sil_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Má sii, la mu. Nii-la si jaŋ joŋmi yallɛ ka kɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ha bi wiaa bula dɛrɛ, di Judas níi kɔ ŋii. U fa ŋaa Yesu haritooro-la fii ari balia dɔŋɔ nɛ. Niaa yugɛ a tuto u hariŋ. Dɔŋsuŋ kori tokobiee ari taŋguloo. Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba ari ba taŋ kuhiasiŋ nɛ tiŋba, ba kɔ. ");
INSERT INTO sil_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zɛŋbɛ tiina-la fa pi nialiŋ magil nɛ a bul, “Nii-la mi si mu guori, u nɛ ŋii. Má kɛnu.” ");
INSERT INTO sil_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas si yi lee-la Yesu si hɛ, u mu u teeŋ tegi tegi aŋ bul, “La kuhiaŋ!” aŋ guoru. ");
INSERT INTO sil_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba kala guriku a kɛnu. ");
INSERT INTO sil_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka niaa china bibeŋ. Ba tuɔŋ dɔŋɔ liisɛ u tokobiiŋ, a ta nuu digiliŋ keri. Nii-la fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia-yoŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ŋii nɛ Yesu piɛsɛba a bul, “Mi ŋaa gaaru nɛɛ? Ma si kori tokobiee ari taŋguloo a kukɔ di ma kɛŋmii? ");
INSERT INTO sil_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na, tapulii-na kala la di ma nɛ yie hɛ Wia-dia lɛ, mi dagɛ Wia wiaa a pipima. Aŋ ka ma bi walima di ma kɛŋmi dimɛ. Ama wialiŋ kala ba si ŋmuŋsa Wia teniŋ tuɔŋ a tigɛmi lɛ, ba kala jaŋ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋii nɛ u haritooroo kala viau aŋ fá. ");
INSERT INTO sil_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka bapuɔsi kubala baagɛ gɛri-bɔsɔ a tuto Yesu hariŋ a mumu. Baa walimɛ di ba kɛnu. ");
INSERT INTO sil_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ama u wuri gɛri-bɔsɔ-la a ta aŋ kɛŋ yaribiree a fá viiri. ");
INSERT INTO sil_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba saa kɛŋ Yesu a kaa mu nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ teeŋ. Ba kɔ dimɛ di nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ba Wii-chuɔlɛ hiasiŋ ari Wia teniŋ kerichiba kala hilime. ");
INSERT INTO sil_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ba kɛnu mumu ŋii, ka Piita daa tuto ba hariŋ a mu juu nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ kaala. U jua di nialiŋ síi pɔ kaala-la hɔnɔ wiwieni nyiniŋ. U mu pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasi-la ari nialiŋ kala si yie hilime vuvuurɛ wiaa chichɛ di ba na Yesu si ŋaa wii-la chei di ba kpuu a chɛ chɛ wii ka. ");
INSERT INTO sil_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Niaa yuga a nyia wiaa pu. Ama ba bul nii-liɛriŋ nɛ, ba bi nii-bala bula. ");
INSERT INTO sil_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ŋii nɛ niaa dɔŋsuŋ sii chiŋ a nyia wiaa pupu a bul, ");
INSERT INTO sil_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“La nia ari Yesu si u jaŋ ŋmoo Wia-dia-la niaa si saa a lo aŋ bira wuo saa u dɔŋɔ tapulaa batori chɛɛŋ, di niaa dee bi jaŋ saa dia-la-na.” ");
INSERT INTO sil_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ama ba wialiŋ kala bi kubala ŋaa. ");
INSERT INTO sil_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ sii lii chiŋ nialiŋ tutuɔbaaniŋ a piɛsɛ Yesu a bul, “Ŋ bi nia niaa deeŋba si bul wialiŋ a tigɛŋ lɛɛ? Ŋ-na bi wii kɛnɛ ŋ jaŋ bul?” ");
INSERT INTO sil_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ŋii nɛ Yesu tɔrɛ u niiŋ. U bi wii-kala bula. Ŋii nɛ baal-la bira piɛsu, “Ŋ nɛ ŋaa Kirisito, nii-la Wia si liisa? Ŋ nɛ Wia Biee?” ");
INSERT INTO sil_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ŋii nɛ Yesu bul, “Mi-na nɛ. Ma jaŋ na mi-na Nuhuobiine Bie di mi hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ, a to duoŋbiliŋbaanaa tuɔŋ a kuu tuu.” ");
INSERT INTO sil_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","U bul ŋii, baal-la kɛŋ u gɛnniŋ kaa kiɛsɛ aŋ bul, “U bi maga di la bira chɛ daŋsiaba. ");
INSERT INTO sil_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma kala bi nia u si chei Wia yiriŋ ŋii? Bɛɛ nɛ ma biinɛ?” Ŋii nɛ nialiŋ kala bul di u cheye nɛ, u maga di ba kpuu nɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dɔŋsuŋ ma sii a tu naŋtuɔruŋ a hɛ u siaa lɛ aŋ vɔɔ u siaa tɔ a ŋmobu aŋ bula pu duu dagɛ nii-la si ŋmobu. Ŋii nɛ ka ba kɛnu kaa mu pi laali-yuoroo. Ba fallɛ u chaŋkpaŋŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piita si hɔŋ kaala-la lɛ, ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia tiŋtinni-tolo kubala ku lii ");
INSERT INTO sil_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a na Piita duu hɔnɔ wiwieni nyiniŋ. U benu woruŋ aŋ bula pu a bul, “Ŋ ma faa to Yesu hariŋ nɛ, baal-la si lii Nazarɛt.” ");
INSERT INTO sil_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ŋii nɛ Piita nyia wiaa a bul, “Mi bi Yesu jiŋ. Mi bi wii-la ŋ si paala bubul jiŋ,” aŋ sii lii chiŋ zawura tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Piita si chiŋ dimɛ, ŋii nɛ tiŋtinni-tolo dɔŋɔ bira nau a bula pi nialiŋ si china kpagu a bul, “Baala deeŋ ma ŋaa Yesu haritooro-la dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piita bira nyia wiaa a bul duu dee. Muasuaa nialiŋ si chiŋ dimɛ ma bula pu a bul, “Wutitii nɛ, ŋ ma ŋaa ba dɔŋɔ nɛ, ŋ lii Galilii nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ŋii nɛ Piita ŋmiɛsɛ a bul, “Mi bi baala deeŋ jiŋ.” ");
INSERT INTO sil_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","U si bul ŋii dɛrɛ di ji-bele yele liamiŋ lɛ. Piita liisi wii-la Yesu si bula pu ari u jaŋ nyia wiaa a pu naaŋsiiŋ butori, ka di ji-bele-na yel naaŋsiiŋ bulia. U saa kɛŋ nyuŋ gurɛ a yiyel. ");
INSERT INTO sil_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ŋii nɛ taŋ-pul. Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ba taŋ kuhiasiŋ ari Wia teniŋ kerichiba ari nialiŋ kala si yie hilimi aa vuurɛ wiaa, ba kala ku hilimi a vuurɛ. Ba kɛŋ Yesu a vɔbu a kɛnu kaa mu Paalit teeŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ŋii nɛ Paalit piɛsɛ Yesu a bul, “Ŋ nɛ ŋaa Ju̱u tiŋŋaa kuoro, koo?” Yesu bula pu a bul, “Oo, mi nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ bul wiaa yugɛ Yesu si ŋaa chei, ka u bi wii bula. ");
INSERT INTO sil_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ŋii nɛ Paalit bira piɛsɛ Yesu a bul, “Ŋ bi wii kɛnɛ ŋ si jaŋ bula pibaa? Bee na wiaa si magɛ ŋii ba bul di ŋ cheye.” ");
INSERT INTO sil_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu bira bi u niiŋ suro. Wii-la kperi Paalit. ");
INSERT INTO sil_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ba gbieli-bal-la nɛ yie-na kala Paalit yie liisɛ nialiŋ ba si kaa tɔ dia dɔŋɔ nɛ a ta, nii-la niaa si sula laa ta. ");
INSERT INTO sil_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Di nialiŋ dɔŋsuŋ ma fa hɛ sarika lɛ. Ba fa ŋaa taawɛi nɛ a kpu niaa. Ba kɛŋba kaa mu tɔ dia. Ba dɔŋɔ yiriŋ nɛ Barabas. ");
INSERT INTO sil_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ŋii nɛ niaa yugɛ a gire mu Paalit teeŋ a bul duu ŋaa ŋii u si vɛnɛɛ ŋaa piba. ");
INSERT INTO sil_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Paalit jima ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ yaraa bieri nɛ, ŋii nɛ tii ba kɛŋ Yesu a kɔ u teeŋ. Ŋii nɛ u piɛsɛ nialiŋ a bul, “Ma cho di mi liisɛ Ju̱u tiŋŋaa kuoru-la nɛ a pimaa?” ");
INSERT INTO sil_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ nyisɛ niaa hɛ di ba sɛi di ba liisɛ Barabas a ta aŋ leŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ŋii nɛ Paalit bira piɛsɛ nialiŋ a bul, “Aŋ ka baal-la ma síi yirɛ Ju̱u tiŋŋaa kuoro, bɛɛ nɛ ma si mi kɛnu kaa ŋaa?” ");
INSERT INTO sil_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ŋii nɛ ba kala faasa kpia a bul, “Leŋ di ba kɛnu kaa kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ŋii nɛ Paalit piɛsɛba a bul, “Wu-bɔŋ bɛɛ nɛ u ŋaa?” Ŋii nɛ ba faasa kpia a kii buŋbuŋ-la a bul, “Leŋ di ba kɛnu kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paalit chɛ duu ŋaa di nialiŋ tuɔŋ tɔrɛ. U liisɛ Barabas aŋ leŋ ba viirɛ Yesu aŋ bul ba kɛnu kaa mu kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ŋii nɛ laali-yuoroo kɛnu kaa lii ba kuori-baliŋ dia kaala tuɔŋ a yirɛ ba laali-yuoroo dɔŋsuŋ kala. Ba kala ku hilimi. ");
INSERT INTO sil_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ŋii nɛ ba joŋ gɛri-fiaŋ a laalu a chɛ sɔsuŋ a kaa sua nyuŋ-chuulo a nagɛ kuoro nyuŋ-chuulo a joŋo chuu. ");
INSERT INTO sil_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba saa tuu kpirimi u sipaaŋ a zilu a bul, “Ju̱u tiŋŋaa kuoro, laa chuɔluŋ.” ");
INSERT INTO sil_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba joŋ sekeliŋ a viirɛ u nyuŋ lɛ, a tu naŋtuɔruŋ ma a hɛu lɛ a tuu kpirimi a zilu. ");
INSERT INTO sil_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba si mɔmu lɛ a dɛrɛ, ba wuri gɛri-fiaŋ-la aŋ paa u titia gɛnniŋ a laalu, a kɛnu kaa lii woŋbiiŋ di ba kɛnu kaa mu kpaasɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba si ku lii ŋii di ba cheŋ baal kubala baa yirɛ Saamɔŋ. U jaŋ yiriŋ nɛ Siriini. U nɛ fa ŋaa Alɛkizaŋda ari Rufas nyimma. U lii baga a jujuu taŋ-la tuɔŋ. Uu kɔ ŋii, ba kɛnu a fugu u joŋ daa-gɛsɛ-la a baasɛ. ");
INSERT INTO sil_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba kɛŋ Yesu kaa mu lee kubala, baa yirɛ Gɔligɔta. Yiri-la bubuɔŋ nɛ nyu-kuŋkogulo. ");
INSERT INTO sil_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba si yi dimɛ, ba joŋ siniŋ a guoli tii-keliŋ kubala baa yirɛ mɛɛ lɛ a joŋo pu duu nyua. U via. ");
INSERT INTO sil_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Di wia magɛ ji-looluŋ, ba kɛnu kpaasɛ a mɛrɛ daa-la nyuŋ. Ŋii nɛ ba tɔŋsɛ Yesu gɛnniŋ wiaa di ba kpaa, a jiŋ gɛri bɛɛ nɛ nuu-kala jaŋ laa. ");
INSERT INTO sil_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba si si Yesu ŋaa wialiŋ chei, ba ŋmuŋsa mɛrɛ daa-gɛsɛ-la lɛ a bul, “Ju̱u tiŋŋaa kuoro nɛ ŋla.” ");
INSERT INTO sil_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Gaaraa balia ma nɛ ba kpaasɛ a pɛ Yesu lɛ. Dɔŋɔ hɛ Yesu na-diiŋ, dɔŋɔ ma hɛ u na-gua.  ");
INSERT INTO sil_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ba fa ŋmuŋsa bil Wia teniŋ tuɔŋ a bul di ba jaŋ kɛnu kaa pɛ haachɛ diiree lɛ. Lɛɛlɛ wiaa deeŋba kala sɛnɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ba si kpaasu mɛrɛ daa-gɛsɛ-la nyuŋ ŋii, nialiŋ si to dimɛ bibal, ba tutuusu aŋ kɛŋ ba nyuŋ chuchugisi a bul, “Oi, ŋ nɛ ŋaa nii-la si si ŋ jaŋ ŋmoo la Wia dia lo aŋ bira wuo saau tapulaa batori pɛgɛ. ");
INSERT INTO sil_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Lii daa-la nyuŋ a laa ŋ titia ta.” ");
INSERT INTO sil_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nialiŋ si kpu pusuŋ pipi Wia kuhiasi-la ari Wia teniŋ kerichiba, ba ma sisieri Yesu lɛ a bulaa pi dɔŋɔ, “U wuo niaa laa tita nɛ aŋ bi u titia wuo laa ta. ");
INSERT INTO sil_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","U si si u nɛ ŋaa Kirisito, Ju̱u tiŋŋaa kuoro, leŋ duu lii daa-la nyuŋ ku tuu di la na a laa u wiaa dii.” Nialiŋ balia ma ba si kpaasa a pɛ Kirisito lɛ, ba ma tuusu. ");
INSERT INTO sil_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wia ku magɛ nyu-gbaŋa, leriŋ kala biri lim a mu yi didaaniŋ, ka leriŋ bira pullɛ. ");
INSERT INTO sil_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ŋii nɛ Yesu faasa yirɛ u yiikoro lɛ a bul, “Eloi, Eloi, lama sabakitani.” U bubuɔŋ nɛ: “Mi Tiina Wia, bɛɛ nɛ tii ŋ joŋmi ta?” ");
INSERT INTO sil_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Di niaa dɔŋsuŋ chiŋ dimɛ a jegile nii wialiŋ u si bula. Ŋii nɛ ba bula pi dɔŋɔ a bul, “Na Ilaaja nɛ u yiyirɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nialiŋ dɔŋɔ fa si chiŋ dimɛ mu joŋ suosuo a kaa mu yuu siniŋ si nyala a joŋo tuu sekeliŋ lɛ, a kaa mu hɛ u niiŋ lɛ duu nyua. U si ŋaa ŋii, u bul, “Má leŋ la gbɛrɛ a na ari Ilaaja jaŋ ku soru daa-la nyuŋ koo.” ");
INSERT INTO sil_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ŋii nɛ Yesu faasa yirɛ aŋ wiesi u wiesi kati. ");
INSERT INTO sil_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Patiisa nɛ fa hɛ Wia-dia tuɔŋ. Ba kaa kɛrɛ. U kiɛsɛ balia a chiŋ nyu-gbaŋa a kiɛsa ku tuu. ");
INSERT INTO sil_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ŋii nɛ di laali-yuoroo zɔlɔ kuhiaŋ kubala fa chiŋ Yesu sipaaŋ a pɔu. U si na Yesu duu wiesi u wiesi kati ŋii, u bul, “Wutitii, baala deeŋ sɛnɛ ŋaa Wia Bii nɛ.” ");
INSERT INTO sil_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Haalaa dɔŋsuŋ ma fa chiŋ di-bolii a bibenu. Ba tuɔŋ Mɛɛri Magidaliŋ ari Saloomi ma fa hɛ dimɛ. Jeems ari Joozis naaŋ ma hɛ dimɛ. Ba fa kɛŋ Jeems kaa yirɛ bapuɔsuŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Haalaa deeŋba kala faa to Yesu hariŋ nɛ a pipɛu lɛ Galilii lɛ. Haala-la ma fa si to Yesu hariŋ a kɔ Jerusalɛm, ba jesiŋ ma fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Tapulii-la di ba ŋaa siri didaaniŋ a gbɛrɛ ba chɛ-wiesii-la, baal kubala ma fa hɛ dimɛ. U yiriŋ nɛ Josɛf. U lii Arimatiya nɛ. U fa ŋaa nialiŋ si yie hilimi a vuvuurɛ wiaa dɔŋɔ nɛ. Niaa jujoŋu jirima. U ma fa gbɛrɛ Wia kuorii-la nɛ duu kɔ. Ŋii nɛ didaaniŋ si yie, u kɛŋ nyu-duoŋ a mu Paalit teeŋ a sul Yesu ku-suuŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ŋii nɛ Paalit guu hiriki a pipiɛsɛ u titia, “Yesu daŋa suba nɛɛ?” Ŋii nɛ u yirɛ laali-yuoroo zɔlɔ kuhiaŋ-la a piɛsu, “Yesu daŋa suba nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","U bul, “Oo, u suba nɛ.” U si nii ŋii, u pi Josɛf woŋbiiŋ duu mu sori Yesu ku-suuŋ a kaa ku tuu tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ŋii nɛ Josɛf mu yɔɔ gɛripɛ-pula a kaa bɛu a joŋu hugi. U kɛnu kaa mu hugi buŋ ba si lɔsɔ lɛ. U bilimi tabii-baliŋ nɛ a tɔ bua-la niiŋ. ");
INSERT INTO sil_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɛɛri Magidaliŋ ari Joozis naaŋ Mɛɛri ma hɛ dimɛ a na lee-la ba si joŋu hugi. ");
INSERT INTO sil_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba chɛ-wiesii-la si dɛrɛ, Lahadi chɛɛŋ siipuuraa, Mɛɛri Magidaliŋ ari Jeems naaŋ Mɛɛri ari Saloomi mu yɔɔ tulaali di ba kaa mu a tisɛ Yesu ku-suuŋ. ");
INSERT INTO sil_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lahadi chɛɛŋ chichuɔŋ, wia si pɔsɔ, ba sii mu Yesu bua-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba síi mu ŋii, ba pipiɛsɛ dɔŋɔ, “Kubɛɛ nɛ jaŋ wuo bilimi tabii-la ta bua-la niiŋ?” ");
INSERT INTO sil_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ŋii nɛ ba mu kpagɛ bua-la leriŋ di ba kɛŋ tabii-la suri bua-la niiŋ a bilime ta. Tabii-la fa yuga nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ŋii nɛ ba mu juu bua-la a na bapuɔsi-bie duu hɔŋ bua-la tuɔŋ na-diiŋ a laalɛ gɛri-pula. Ba hiriki. ");
INSERT INTO sil_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ŋii nɛ u bula piba a bul, “Ma sí fawulluŋ fá. Mi jima ari Yesu si lii Nazarɛt nɛ maa chɛ, nii-la ba si kpaasa mɛrɛ daa-la lɛ. U tuo daha. U sie nɛ. Má ku na lee-la ba si joŋu hugi. ");
INSERT INTO sil_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Má mu a bula pi Piita ari Yesu haritooroo, ari Yesu jaŋ laa ma sipaaŋ a mu Galilii. Di ma nɛ mu dimɛ, ma jaŋ nau dimɛ ari u si bul ŋii pima.” ");
INSERT INTO sil_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ba hiriki a chichel a sii lii bua-la lɛ a fá. Fawulluŋ kɛŋba, ba bi wii wuo bula pipi nuu-kala.  ");
INSERT INTO sil_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu sii suuŋ lɛ Lahadi chɛɛŋ siipuuraa nɛ. U si sie, u leŋe Mɛɛri Magidaliŋ nɛ laa sipaaŋ nau, nii-la lɛ u si kiri jiŋ-bɔŋŋɔɔ balipɛ ta. ");
INSERT INTO sil_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ŋii nɛ Mɛɛri sii a mu bula pi Yesu haritooroo wii-la si ŋaa. U mua di ba hɔnɔ yiyel. ");
INSERT INTO sil_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ŋii nɛ u bula piba ari Yesu sii suuŋ lɛ a hɛ u miisiŋ lɛ, di u-na nau. Ba si nii wii-la, ba bi laa dii. ");
INSERT INTO sil_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ŋii hariŋ baalaa balia sii lii a joŋ woŋbiiŋ aa mu taŋ dɔŋɔ. Ba síi mu ŋii, Yesu bira to woŋbiiŋ dɔŋɔ a kɛŋ u titia ku dagɛba. ");
INSERT INTO sil_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ŋii nɛ ba miira ku bula pi Yesu haritooro-la ku-kaanaa wii-la si ŋaa. Ba bi laa dii. ");
INSERT INTO sil_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ŋii hariŋ nɛ Yesu haritooro-la fii ari kubala hɔnɔ didii kiaa. Baa dii di Yesu nɛ ŋii. U kpiaba lɛ a tiŋ ba tuɔŋ si dolie wiaa ari ba si bi laa dii ari nialiŋ si si ba nau duu sii suuŋ lɛ, di ba bul wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ŋii nɛ u bula piba a bul, “Má mu dunia sɛmɛ-na kala a bul Wia wu-zɔmɔ-la a pi nuu-na kala. ");
INSERT INTO sil_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nii-la kala si laa mi wiaa dii a leŋ ba fou Wii-chuɔlɛ liiŋ, Wia jaŋ laau ta, ama nii-la si bi mi wiaa laa dii, Wia jaŋ joŋ cheeriŋ pu chɛɛ-la u si jaŋ dii dunia niaa kala sariya. ");
INSERT INTO sil_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wu-magilaa deeŋba nɛ ma jaŋ wuo na a jiŋ nialiŋ si laa mi wiaa dii. Ba nɛ ŋla: Ba jaŋ wuo kikiri jiŋ-bɔŋŋɔɔ mi doluŋ lɛ. Ba jaŋ wuo bubul yiikori-yiriba. ");
INSERT INTO sil_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba jaŋ wuo kukori diŋŋaa, a nyua daalusuŋ síi kpu niaa, ka u bi jaŋ ŋaaba wii-kala. Ba jaŋ wuo joŋ ba nisaa a daŋ nyanyal tiŋŋaa lɛ di ba duori.” ");
INSERT INTO sil_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","La Tiina Yesu si bul wialiŋ dɛrɛ, Wia joŋu a kaa mu Wia-jaŋ, u hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ. ");
INSERT INTO sil_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ŋii nɛ u haritooroo sii lii a mu lee-na kala a bubul Wia wiaa. La Tiina Wia pɛba lɛ ba mu a ŋiŋaa wu-magilaa, di nialiŋ jiŋ wialiŋ ba síi bul ŋaa wutitii nɛ. Ami.");
INSERT INTO sil_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Mi-na Luuk nɛ ŋmuŋsɛ teniŋ deeŋ a pipi ŋ-na mi naŋdɔŋɔ Tiafilas. Niaa yuga a hɛ ba doluŋ a ŋmuŋsɛ wialiŋ kala si ŋaala lɛ. Ba ŋmuŋsɛ wialiŋ kala niaa si bula pila. Ba nɛ na wiaa deeŋba kala a suomi buŋbuŋ kala, a ma bul Wia niiŋ wiaa a pipi niaa. ");
INSERT INTO sil_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mi kuhiaŋ, mi jegile nii wiaa deeŋba woruŋ a gunnɛ ba kala ma woruŋ. U ŋaa wu-zɔŋ nɛ di mi ŋmuŋsɛ wialiŋ kala a piŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi ŋmuŋsaa piŋ di ŋ wuo jiŋ ari wialiŋ kala ba si dagiŋ ŋaa wutitiiba nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Baal kubala nɛ fa hɛ dimɛ. Baa yirɛ Zakaraya. U fa ŋaa nialiŋ si kpu pusuŋ pipi Wia dɔŋɔ nɛ. Bua-la lɛ di ba kɛŋ nialiŋ si kpu pusuŋ pipi Wia kala kaa kpaa leree mara ari banɛsɛ nɛ. Baal kubala ma fa hɛ dimɛ. U fa ŋaa kuhiaŋ lee-la Zakaraya fa si hɛ nɛ. U yiriŋ nɛ Abija. Zakaraya haala ma yiriŋ nɛ Ɛlizabɛt. U ma fa lii nialiŋ si kpu pusuŋ pipi Wia doho niaa tuɔŋ nɛ. Aarɔŋ fa ŋaa u nihiliɛrɛ. Bua-la lɛ di Hɛrɔd nɛ fa ŋaa Judiya tiŋteeŋ kuoro. ");
INSERT INTO sil_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakaraya ari u haala kala fa ŋaa tuɔ-pul timma nɛ. Ba kala balia fa to Wia niiŋ wialiŋ kala nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɛlizabɛt fa ŋaa ha-piri nɛ, ba bi bii kala lula, aŋ ka ba di u bala Zakaraya ma kala hiɛsɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ŋii nɛ Zakaraya ari u niaa tapuluŋ yi di ba tiŋ tiŋtiŋŋaa nialiŋ si kpu pusuŋ pipi Wia si vɛnɛɛ ŋaa. Ba síi tiŋ ba tiŋtiŋŋaa ŋii, ba yie tɔŋsɛ di ba jiŋ nii-la ba si jaŋ liisɛ duu juu Wia-dia. Ba si ŋaa ŋii, Zakaraya dii a juu Wia-dia. Ŋii nɛ u hɛ nyiniŋ a nyigɛ tii-keliŋ tulaali a pi Wia, Wia koruŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","U si jua ŋii, nialiŋ si ka, ba hɛ kaala lɛ a chuchuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zakaraya si nyigɛ nyiniŋ ŋii, di Wia tiŋdaara kubala kɔ u teeŋ a chiŋ koru-la sɛmɛ na-diiŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaraya nau a chichel. Fawulluŋ kɛnu. ");
INSERT INTO sil_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ŋii nɛ Wia tiŋdaari-la bula pu a bul, “Zakaraya, sí leŋe di fawulluŋ kɛniŋ. Wialiŋ ŋ si sul Wia teeŋ, u joŋo piŋ nɛ. Ŋ haala Ɛlizabɛt jaŋ lul baal. Ŋ jaŋ hɛ u yiriŋ Jɔɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ŋ tuɔŋ jaŋ faasa tɔrɛ. Ni-daŋ ma tuɔŋ jaŋ tɔrɛ u lulluŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","U jaŋ ŋaa ni-bal Wia teeŋ. U bi jaŋ nyunyua si-duoruŋ. Ba si lulu bua-la lɛ, Wia Diŋ-zɔŋ-la jaŋ hɛu lɛ woruŋ a kaa mu deeŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U jaŋ wuo ŋaa di Iziral tiŋŋaa yugɛ a birima to ba Tiina Wia. ");
INSERT INTO sil_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U jaŋ ŋaa Wia tiŋtinnu a kɛŋ doluŋ ari Ilaaja fa si kɛŋ doluŋ ŋii. (Ilaaja fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ.) U jaŋ wuo ŋaa di biiriŋ ari ba nyimmaba kala miira siŋ. U ma jaŋ wuo ŋaa di nialiŋ si bi Wia niiŋ wiaa ka to, di ba birimɛ a to tuɔ-pul tiŋŋaa woŋbiiŋ a leŋ di niaa ŋaa siri di ba Tiina kɔ di ba tou.” ");
INSERT INTO sil_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ŋii nɛ Zakaraya piɛsɛ Wia tiŋdaari-la a bul, “Ɛɛ nɛ mi jaŋ wuo ŋaa, a jiŋ di wialiŋ ŋ si bula ŋaa wutitii? Mi ŋaa ba-nihiaŋ nɛ, mi haala ma ŋaa ha-nihiaŋ.” ");
INSERT INTO sil_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ŋii nɛ Wia tiŋdaari-la bula pu a bul, “Mi yiriŋ nɛ Gebiral a hɔŋ Wia sɛmɛ. U nɛ tiŋmi di mi ku bul wu-zɔmuŋ deeŋ a piŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wialiŋ mi si bula piŋ jaŋ ku ŋaa, aŋ ka ŋ bi laa dii. Ŋii wiaa ŋ bira bi wiaa jaŋ wuo bul, see tapulii-la si yie di wiaa deeŋba mi si bula piŋ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wia tiŋdaari-la síi bul wiaa Zakaraya teeŋ ŋii, nialiŋ si gbɛrɛ Zakaraya kaala tuɔŋ bi jiŋ wii-la si tii u didieni ŋii Wia dia-la tuɔŋ. U kperiba. ");
INSERT INTO sil_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ŋii nɛ Wia tiŋdaari-la viiri, aŋ ka Zakaraya ku lii kaala nialiŋ teeŋ. U bi wiaa wuo bula piba. Ŋii nɛ u kɛŋ u nisaa a bul wiaa ba teeŋ. U si bi wiaa wuo bubul ŋii, ba jiŋ ari u na wiaa ari duosoo tuɔŋ Wia-dia-la tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ŋii nɛ Zakaraya tiŋtiŋŋaa tapulaa dɛrɛ Wia-dia-la lɛ. U miira mu u dia. ");
INSERT INTO sil_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","U bi diene, ka u haala Ɛlizabɛt kɛŋ luoruŋ. U si kɛŋ luoruŋ ŋii, u bi dia lɛ lia chɛŋsiŋ banɔŋ ");
INSERT INTO sil_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","a bul, “Wia diene aŋ lɛɛlɛ pɛmi lɛ ŋla. U tɔ mi hiisiŋ nɛ dunia lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɛlizabɛt si kɛŋ luoruŋ u chɛŋsiŋ balidu lɛ, Wia bira tiŋ u tiŋdaara Gebiral duu mu Galilii tiŋteeŋ taŋ kubala baa yirɛ Nazarɛt. ");
INSERT INTO sil_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U timu duu kɛŋ tiŋdaariŋ a kaa mu pi tolo kubala ha si bi baal jiŋ baa yirɛ Mɛɛri. U faa chɛ duu jaa baal kubala nɛ baa yirɛ Josɛf. Josɛf fa ŋaa kuoro Devit doho nuu nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ŋii nɛ Wia tiŋdaari-la kɔ u teeŋ a chuɔlu aŋ bula pu a bul, “Wia cho ŋ wiaa a pɛŋ lɛ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛɛri si nii wialiŋ Wia tiŋdaari-la si bula pu, fawulluŋ kɛnu. U kɛŋ wialiŋ u si bula bubuɔŋ bibiinɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ŋii nɛ Wia tiŋdaari-la bula pu a bul, “Mɛɛri, Wia cho ŋ wiaa, sí leŋe di fawulluŋ kɛniŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ŋ jaŋ kɛŋ luoruŋ a lul baal. Ŋ jaŋ hɛ u yiriŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U jaŋ ŋaa ni-bal. Ba jaŋ kɛnu yirɛ Wii-baliŋ Bie. Wia jaŋ ŋaa duu dii kuoruŋ ari u naabalima Devit fa si dii kuoruŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U jaŋ dii kuoruŋ Jekɔb doho niaa tuɔŋ a kaa mu wuu. U bi jaŋ dɛrɛ da.” ");
INSERT INTO sil_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ŋii nɛ Mɛɛri bula pi Wia tiŋdaari-la a bul, “Mi ha bi baal jiŋ. Ɛɛ nɛ saa wiiŋ deeŋ jaŋ wuo ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ŋii nɛ Wia tiŋdaari-la bula pu a bul, “Wia Diŋ-zɔŋ-la jaŋ hɛŋ lɛ. Ŋ jaŋ kɛŋ luoruŋ Wia doluŋ lɛ. Ŋii wiaa bile jaŋ ŋaa Tuɔ-pul Tiina. Ba kɛnu yiyirɛ Wia Bie. ");
INSERT INTO sil_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na ŋ naaŋbie Ɛlizabɛt si hiɛsa ŋii. Ba si u bi bii wuo lul, aŋ ka u kɛŋ luoruŋ u chɛŋsiŋ balidu nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wia kɛŋ doluŋ. U jaŋ wuo ŋaa wii-kala.” ");
INSERT INTO sil_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ŋii nɛ Mɛɛri bula pu a bul, “Mi ŋaa Wia tiŋtinnu nɛ. Leŋ di wialiŋ ŋ si bula pimi, di ba ŋaa.” Ŋii nɛ Wia tiŋdaari-la tau aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ŋii nɛ Mɛɛri sii lima lima a mu duu chuɔlɛ Ɛlizabɛt u jaŋ lɛ. U fa hɛ Judiya tiŋteeŋ lɛ nɛ. Peelee nɛ golli lee-la chu. ");
INSERT INTO sil_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","U si yi dimɛ, u mu juu Zakaraya dia a mu chuɔlɛ u haala Ɛlizabɛt. ");
INSERT INTO sil_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","U laa Mɛɛri chuɔlaa. U si laa ŋii, bile si hɛ u luoruŋ lɛ sii birimɛ. Ŋii nɛ Wia Diŋ-zɔŋ-la ku hɛ Ɛlizabɛt lɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","U faasa bula pi Mɛɛri a bul, “Wia pɛŋ lɛ a kii haalaa kala. Wia ma jaŋ pɛ bile ŋ si jaŋ lul lɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mi ma ŋaa kubɛɛ nɛ, Wia Bie naaŋ kɔ duu chuɔlɛmi? ");
INSERT INTO sil_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mi si laa ŋ chuɔlaa ŋii, bile si hɛ mi luoruŋ lɛ tuɔŋ ma tɔrɛ. U sii fuful. ");
INSERT INTO sil_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ŋ ma laa dii ari wialiŋ Wia si bula piŋ jaŋ ŋaa wutitiiba. Ŋii wiaa ŋ tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ŋii nɛ Mɛɛri bula pu a bul, “Mi tuɔŋ tɔrɔ nɛ. Mi didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wia nɛ ŋaa mi Laataara. Ŋii nɛ tii mi jujuɔsɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mi ŋaa u tiŋtinni-bii nɛ, u liisi mi wiaa. A lii lɛɛlɛ a kaa mu, nuu-kala jaŋ kɛŋmi yiyirɛ tuɔtɔrɛ tiina. ");
INSERT INTO sil_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wia ŋaa Wii-bal nɛ a ŋaa wu-kpuŋkperisiŋ mi lɛ. U ŋaa Tuɔ-pul Tiina nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Uu fá nialiŋ kala síi fáu, nennige, doho-na kala lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U kɛŋ u na-duo-la kaa tiɛnɛ a ŋmoo babii-balaa a ŋaa ba wu-ŋaala-la kala pugi. ");
INSERT INTO sil_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U kiri ni-balaa ba kuori-kpasinniŋ nyuŋ aŋ ka ni-biisiŋ hɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U joŋ ku-zɔŋŋɔɔ a pi summoo aŋ kiri nialiŋ si kɛŋ kiaa ba kɛŋ na-hilliŋ miirɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","U fa bil niiŋ nɛ a pi la naabalimaba duu jaŋ pɛ u tiŋtinnaa Iziral tiŋŋaa lɛ. Wii-la u fa si bula ku ŋaa wutitii. U pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","U fa fá Abiraham nennige. U saa jaŋ fá u doho niaa kala ma nennige a kaa mu wuu.” ");
INSERT INTO sil_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛɛri si bul wialiŋ dɛrɛ, u hɔŋ Ɛlizabɛt teeŋ a yi chɛŋsiŋ batori nɛ, aŋ-na miira mu dia. ");
INSERT INTO sil_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ŋii nɛ Ɛlizabɛt lulluŋ yi. U lul baal. ");
INSERT INTO sil_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","U si lul ŋii, u dɔŋsuŋ tiŋŋaa ari u naaŋbiiriŋ nii ŋii Wia si fáu nennige. Ba tuɔŋ kala tɔrɛ, ba jujuɔsɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bile si yi tapulaa chori di ba keri u peniŋ aŋ hɛ u yiriŋ. Ba faa chɛ di ba joŋ u nyimma Zakaraya yiriŋ nɛ hɛ pu. ");
INSERT INTO sil_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ŋii nɛ u naaŋ via aŋ bul di ba hɛ Jɔɔŋ pu. ");
INSERT INTO sil_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nihiasi-la bula pu ari ba bi naaŋbii kala kɛnɛ u yiriŋ dii Jɔɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ŋii nɛ ba kɛŋ nisaa bul wiaa pi u nyimma a piɛsu di yiri bɛɛ nɛ uu chɛ duu hɛ pu. ");
INSERT INTO sil_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaraya ŋaa ba kɛŋ daa-bori-bie kaa kɔ duu ŋmuŋsɛ bile yiriŋ a piba. Ba joŋo pu. U ŋmuŋsɛ daa-boro-la lɛ di bile yiriŋ nɛ Jɔɔŋ. Ba karimɛ. Ba si karimɛ a na bile yiriŋ, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zakaraya si ŋaa ŋii dɛrɛ, u bira suomi a bubul wiaa a didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nialiŋ fa si hɛ dimɛ a na wii-la si ŋaa, fawulluŋ kɛŋba. Ba kɛŋ wii-la lii a bula gaarɛ Judiya tiŋteeŋ sɛmɛ-na kala, lee-la peelee si gollo chu. ");
INSERT INTO sil_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nialiŋ kala si nii ŋii, ba kɛŋ wii-la bibiinɛ ba tuɔsaa lɛ aa bul, “Bie deeŋ saa jaŋ ŋaa kubɛɛ nɛ?” Ba na ari Wia doluŋ hɛu lɛ nɛ. Ŋii nɛ tii ba bul ŋii. ");
INSERT INTO sil_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ŋii nɛ Wia Diŋ-zɔŋ-la ku hɛ Zakaraya lɛ, u bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ a bul, ");
INSERT INTO sil_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Má leŋ di la dɛnnɛ Wia, Wia-la Iziral tiŋŋaa síi to. U kɔ duu pɛ u niaa lɛ nɛ a laaba ta. ");
INSERT INTO sil_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U liisɛ ni-duoŋ nɛ pila duu kɔ laala ta. U lii Devit doho niaa tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Faafaa kala nɛ Wia to u nialiŋ fa síi bul wiaa u Diŋ-zɔŋ-la doluŋ lɛ, a bula pila ");
INSERT INTO sil_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ari u jaŋ laala ta la diŋdɔŋŋɔɔ ari nialiŋ kala si bɛrɛla nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","U ma bula ari u jaŋ fá la doho niaa nennige, a liise yi wii-la u fa si bula pi la naabalimaba. ");
INSERT INTO sil_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","U fa bula pi la naabalima Abiraham a ŋmiɛsɛ ari u jaŋ laala ta la diŋdɔŋŋɔɔ nisiŋ lɛ a pila woŋbiiŋ di la kɛŋ nyu-duoŋ a tima pu. ");
INSERT INTO sil_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ŋii lɛ nɛ la jaŋ wuo to a kɛŋ tuɔ-pula u teeŋ, la miisiŋ kala lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakaraya si bul wiaa deeŋba dɛrɛ, u bul wiaa a pi u bie ma a bul, “Ŋ-na mi bii, ŋ jaŋ ŋaa nii-la síi bul wiaa, Wii-baliŋ Diŋ-zɔŋ-la doluŋ lɛ. Ŋ jaŋ laa la Tiina-la si jaŋ kɔ sipaaŋ a wasɛ woŋbiiŋ bilu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ŋ ma jaŋ bula pi nialiŋ si ŋaa siri di ba tou, di Wia joŋ ba haachɛba chɛba aŋ laaba ta. ");
INSERT INTO sil_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wia kɛŋ zile aŋ fifá niaa nennige. U jaŋ laala ta a leŋ di la hɔŋ pulumuŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Puluŋ-la jaŋ lii Wia-jaŋ a pɔsɛ hɛ nialiŋ kala si hɔŋ birimiŋ tuɔŋ a faa chɛ di ba suu. U jaŋ dagɛla woŋbii-la si kɛŋ yarifiɛlaa di la to.” ");
INSERT INTO sil_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ŋii nɛ bile sii waa a hɛ yaraa a kɛŋ doluŋ ari wu-jimiŋ. U mu hɛ giri-bine tuɔŋ a mu yi tapulii-la u si kɛŋ u titia kaa ku lii dagɛ Iziral tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Baal kubala nɛ fa hɛ dimɛ, baa yirɛ Ɔgasitas. U nɛ fa ŋaa Rom tiŋŋaa kuori-baliŋ. Bua-la lɛ u bul di ba diisɛ u tiŋteeŋ niaa. Ba ha bi ŋii ŋaa, see lɛɛlɛ nɛ ba ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ba si bugumo diisɛ niaa ŋii, baal kubala nɛ fa chiŋ kuori-baliŋ nyuŋ Siiria tiŋteeŋ lɛ. Baa yirɛ Kiriinias. ");
INSERT INTO sil_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ŋii nɛ nuu-kala mu u jaŋ di ba diisu dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josɛf ma sii Nazarɛt Galilii tiŋteeŋ lɛ a mu Judiya tiŋteeŋ, a mu juu taŋ kubala baa yirɛ Bɛtilɛhɛm. Lee-la nɛ ba fa lul kuoro Devit. Josɛf fa ŋaa kuoro Devit doho nuu nɛ. Ŋii nɛ tii u mu dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ba di Mɛɛri kala mu dimɛ. Mɛɛri fa ŋaa nii-la si si u jaŋ jaau nɛ, ka u kɛŋ luoruŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba si yi Bɛtilɛhɛm, ba hɔŋ dimɛ. Ŋii nɛ Mɛɛri lulluŋ yi, ");
INSERT INTO sil_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","aŋ ka ba bi leriŋ na nuhuɔraa dia-la lɛ di ba juu. Ŋii nɛ tii ba mu juu ja-dia. Dimɛ nɛ Mɛɛri lul u bii-buŋbuŋ, baal, a kɛŋ gɛriŋ a bɛu a joŋu bil yaŋ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bua-la lɛ pie-daaraa nɛ fa hɛ tiŋtee-la sɛmɛ dɔŋɔ a hɛ yaŋ tuɔŋ a chua dimɛ titaŋiŋ aa beŋ ba piesee. ");
INSERT INTO sil_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ŋii nɛ Wia tiŋdaara kubala kɔ ba teeŋ. U si kɔ ŋii, Wia pulumuŋ chaana hɛba lɛ. Fawulluŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ŋii nɛ Wia tiŋdaari-la bula piba a bul, “Ma sí leŋe di fawulluŋ kɛŋma. Mi kɛŋ wu-zɔŋŋɔɔ nɛ kɔ di mi bula pima. Nii-la kala si nii wu-zɔmɔ-la, u tuɔŋ jaŋ tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Titaŋiŋ deeŋ ba lul ma Laataara nɛ Devit jaŋ lɛ. Baa yiru la Tiina Kirisito, nii-la Wia si liisa. ");
INSERT INTO sil_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ŋla nɛ ma jaŋ wuo to jiŋ. Di ma mu dimɛ, ma jaŋ na bile di ba kɛŋ gɛnniŋ bɛu a joŋu bil yaŋ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ŋii nɛ Wia tiŋdaaraa yugɛ a guu lii a pɛ Wia tiŋdaari-la lɛ a yii yiilaa a dɛnnɛ Wia a bul, ");
INSERT INTO sil_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Má leŋ di la dɛnnɛ Wia si hɛ Wia-jaŋ lɛ. Wia ma tuɔŋ tɔrɛ nialiŋ si hɛ tiŋteeŋ lɛ nɛ. Ba ma jaŋ na yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ŋii nɛ Wia tiŋdaara-la miira mu Wia-jaŋ. Ka pie-daara-la bula pi dɔŋɔ a bul, “Má leŋ di la mu Bɛtilɛhɛm a na wii-la la Tiina Wia si to u tiŋdaaraa lɛ a bula pila.” ");
INSERT INTO sil_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba sii fá lima lima a mu na Mɛɛri ari Josɛf. Ba naba aŋ na bile maa di u piŋ yaŋ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ŋii nɛ pie-daara-la bula pi bile naaŋ ari u nyimma wialiŋ Wia tiŋdaara-la si bula piba a tigɛ bile lɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nialiŋ kala si nii ŋii, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mɛɛri laa wiaa deeŋba kala a hɛ u nyuŋ lɛ a kaa bibiinɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ŋii nɛ pie-daara-la miira mu ba pie-daaliŋ. Baa mu a yiyii yiilaa a didɛnnɛ Wia. Wialiŋ kala Wia tiŋdaara-la si bula piba, ba naba. ");
INSERT INTO sil_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bile si yi tapulaa chori, ba keri u peniŋ aŋ hɛ u yiriŋ. Ba hɛ Yesu pu, yiri-la Wia tiŋdaari-la fa si daga bua-la lɛ Mɛɛri fa ha si bi luoruŋ kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto dɔŋɔ nɛ ŋla: “Di baal ari u haal nɛ lul ba bii-buŋbuŋ, duu nɛ ŋaa baal, u maga di ba mu piisɛ ba disinniŋ ta nɛ.” Moosis fa bira ŋmuŋsa bil Wia teniŋ tuɔŋ di nuu-na kala nɛ lul u bii-buŋbuŋ, di bile nɛ ŋaa baal, duu joŋo pi Wia. Ŋii nɛ Josɛf ari Mɛɛri ŋaa ŋii. Ba sii joŋ bile a kaa mu Jerusalɛm a joŋu pi Wia. ");
INSERT INTO sil_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba bira ŋmuŋsa di ba kpu kokosuŋ balia maa a pi Wia. Ŋii nɛ Josɛf ari Mɛɛri sii mu Wia-dia di ba ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bua-la lɛ baal kubala nɛ fa hɛ Jerusalɛm lɛ, baa yirɛ Simiaŋ. U fa ŋaa ni-zɔŋ nɛ a fifá Wia a fa gbigbɛrɛ di Wia laa Iziral tiŋŋaa ta. Wia Diŋ-zɔŋ-la ma hɛu lɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wia Diŋ-zɔŋ-la fa bula pu ari u bi jaŋ suu see duu na Kirisito, nii-la Wia si jaŋ liisɛ duu kɔ. ");
INSERT INTO sil_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ŋii nɛ Yesu nyimma ari u naaŋ juu Wia-dia a joŋu pi Wia aŋ pɛ ŋaa ŋii Wia niiŋ wiaa si bula ŋii nɛ. Di Wia Diŋ-zɔŋ-la kɛŋ Simiaŋ ma ku juu Wia-dia. ");
INSERT INTO sil_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiaŋ na bile a laau a hɛ u nisaa lɛ aŋ dɛnnɛ Wia a bul, ");
INSERT INTO sil_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mi Tiina, ŋ leŋ di wialiŋ ŋ si bula pimi sɛnɛ ku ŋaa. Ŋ si ŋaa ŋii, leŋ di mi-na ŋ tiŋtinna na woŋbiiŋ a suu ari yarifiɛlaa. ");
INSERT INTO sil_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mi sɛnɛ na nii-la si kɔ duu laa dunia niaa ta nɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ŋ timu duu kɔ nuu-kala teeŋ nɛ, di nuu-kala nau. ");
INSERT INTO sil_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bie deeŋ jaŋ nagɛ pulumuŋ a dagɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa woŋbiiŋ, ka di ŋ niaa Iziral tiŋŋaa ma na.” ");
INSERT INTO sil_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiaŋ si bul ŋii dɛrɛ, wialiŋ u fa si bula a tigɛ bile lɛ ŋaa bile nyimma ari u naaŋ wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ŋii nɛ Simiaŋ chuɔlɛ Wia piba duu pɛba lɛ aŋ bula pi u naaŋ a bul, “Wia liisɛ ŋ bie deeŋ duu ku dɔgisɛ nialiŋ si bi u wiaa laa dii, aŋ ma laa nialiŋ si laa u wiaa dii ta Iziral tiŋŋaa tuɔŋ. Wia ta bie deeŋ duu ŋaa magil nɛ. Niaa yugɛ jaŋ joŋ ba hariŋ yiau. ");
INSERT INTO sil_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ka ba tuɔbiinaa jaŋ lii di-jaliŋ.” Ŋii nɛ u bira bula pi Mɛɛri a bul, “Ŋ titia tuɔŋ jaŋ chei woruŋ ŋ bile wiaa a nagɛ ba si joŋ sia tɔbuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Haal kubala ma nɛ fa hɛ dimɛ. U yiriŋ nɛ Ana. U fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. U nyimma ma yiriŋ nɛ fa Fanuwɛl a lii Asa doho niaa tuɔŋ. U fa ŋaa ha-nihiaŋ nɛ. U fa jaa bala jisiŋ balipɛ nɛ ka u suu. ");
INSERT INTO sil_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","U bala si suba, u hɔnɔ a ŋaa yo-haal nɛ jisiŋ mahiŋ banɛsɛ ari banɛsɛ. Bua-na kala lɛ u yie vɛnɛɛ mu Wia-dia wiihɛyɛ ari titaŋiŋ kala. U yie vɔɔ niiŋ dimɛ aŋ pɛ chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simiaŋ fa síi bul wiaa pipi Mɛɛri ŋii, di Ana ma ku juu. U na bile a dɛnnɛ Wia aŋ bul wiaa a tigɛ bile lɛ a pi nialiŋ kala fa si gbɛrɛ di Wia laa Jerusalɛm niaa ta. ");
INSERT INTO sil_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mɛɛri ari Josɛf si ŋaa wialiŋ kala Wia si si di ba ŋaa Jerusalɛm lɛ a dɛrɛ, ba miira mu Galilii tiŋteeŋ a mu ba jaŋ Nazarɛt. ");
INSERT INTO sil_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bile waa a kɛŋ doluŋ a kala ŋaa wu-jimii. Wia pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jina-na kala Yesu nyimma ari u naaŋ yie mu Jerusalɛm di ba gbieli diisiŋ kieliŋ gbiele. ");
INSERT INTO sil_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu si ŋaa jisiŋ fii ari balia, ba di u nyimma ari u naaŋ mu diisiŋ kieliŋ gbiele-la Jerusalɛm lɛ, ari ba si vɛnɛɛ ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gbiele-la si dɛrɛ, ba miiraa mu dia, ka Yesu ha hɛ hariŋ. U naaŋ ari u nyimma bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba fa biina ari u hɛ ba nialiŋ si miira mu ba jaŋ tuɔŋ nɛ. Ba suomo chichɛu ba naaŋbiiriŋ ari ba naŋdɔŋsuŋ tuɔŋ. Ba vɛŋ deeŋ deeŋ wia tuu juu a chɛu ka. ");
INSERT INTO sil_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba si chɛu ka, ba miira mu Jerusalɛm a bene chichɛu dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","U tapulaa batori chɛɛŋ nɛ ba nau Wia-dia lɛ, di ba di Ju̱u tiŋŋaa kerichiba hɔnɔ. Uu jegili wialiŋ ba síi bul aŋ pɛ pipiɛsɛba wiaa maa. ");
INSERT INTO sil_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nialiŋ kala si hɛ dimɛ a nii u síi chaarɛ wiaa siaa ari wu-jimiŋ ŋii, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","U nyimma ari u naaŋ si nau, u ŋaaba ma wu-kpuŋkpere. Ŋii nɛ u naaŋ piɛsu, “Mi bii, bɛɛ nɛ tii ŋ ŋaala ŋla? La di ŋ nyimma gɔllɔ chɛŋ ka nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ŋii nɛ u piɛsɛba a bul, “Bɛɛ nɛ tii ma gɔllɔɔ chɛmi? Ma bi jiŋ ari mi jaŋ hɛ mi Nyimma dia lɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama ba fa bi wii-la u si bula piba bubuɔŋ jiŋ. ");
INSERT INTO sil_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ŋii nɛ Yesu ari u nyimma ari u naaŋ miira mu Nazarɛt a hɛ dimɛ. Ba si hɛ dimɛ, u to ba niiŋ woruŋ. U naaŋ laa wialiŋ kala si ŋaa a hɛ u tuɔŋ lɛ aa biinɛ. ");
INSERT INTO sil_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ŋii nɛ Yesu waa, u wu-jimiŋ ma puŋa pɛ. Wia chou, niaa ma zizilu woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ŋii nɛ Wia ta Zakaraya bie Jɔɔŋ duu mu bul Wia wiaa pi niaa giri-bine tuɔŋ. U si suomo ŋii, Rom tiŋteeŋ kuori-baliŋ Tabiiras dii kuoruŋ u jisiŋ fii ari banɔŋ nɛ ŋii. Pɔŋsɔs Paalit ma fa chiŋ kuori-baliŋ nyuŋ Judiya tiŋteeŋ lɛ. Hɛrɔd ma fa bibeŋ Galilii tiŋteeŋ. U naaŋbie Filip ma fa bibeŋ Ituriya ari Takɔnaatis tiŋteeŋ. Baal-la ba síi yirɛ Lasiinias ma níi beŋ Abiliini tiŋteeŋ. Anas ari Kayafas ma nɛ fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ŋii nɛ Jɔɔŋ gɔllɛ Jɔɔdaŋ fuo-la kala nyuŋ a bubul Wia wiaa pi niaa a bul, “Má birima lii ma haachɛba lɛ aŋ leŋ di mi foma Wii-chuɔlɛ liiŋ, di Wia joŋ ma haachɛba chɛma.” ");
INSERT INTO sil_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Azaaya fa ŋmuŋsɛ ŋii Wia teniŋ sɛmɛ dɔŋɔ. U fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Wialiŋ u fa si ŋmuŋsa nɛ ŋla: “Nuu níi heeli giriŋ tuɔŋ a bul, ‘Má wasɛ Wia woŋbiiŋ bilu lɛ; má leŋ di woŋbii-la ŋaa tegi tegi duu to. ");
INSERT INTO sil_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Má tɔ buɔtuonuŋ kala. Má keri peelee ari duŋdolluŋ ari tiŋteeŋ a kaa jɛrɛ di ba magɛ dɔŋɔ, woŋbii-la si golibo, má kaa tuulɛ. Má tɔ woŋbii-la si kɛŋ buɔtuonuŋ di ba ŋaa mula mula. ");
INSERT INTO sil_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Di ma ŋaa ŋii, dunia niaa kala jaŋ na ŋii Wia si laa niaa tita.’ ” ");
INSERT INTO sil_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ŋii nɛ niaa yugɛ a kɔ Jɔɔŋ teeŋ duu foba Wii-chuɔlɛ liiŋ. U bula piba a bul, “Ma nialiŋ wu-ŋaalaa nagɛ diŋŋaa nɛ. Ma biina ma jaŋ wuo fá a lɛl chɛɛ-la Wia si jaŋ dii nuu-kala sariyaa? ");
INSERT INTO sil_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Má leŋ ma wu-ŋaalaa nagɛ ari ma birima lii ma haachɛba lɛ nɛ, aŋ sí bula bul di ma ŋaa Abiraham doho niaa nɛ. Mi jaŋ bula pima ari Wia paala jaŋ wuo ŋaa di tabiaa deeŋba ma si na birimɛ Abiraham doho niaa a pi Abiraham. ");
INSERT INTO sil_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na ba kɛŋ saaŋ jee nɛ a ŋaa siri di ba keri tiisiŋ lo. Tia-la kala si bi nɛŋ-zɔŋŋɔɔ kɛnɛ, ba jaŋ keru ta a joŋo yuo hɛ nyiniŋ tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nialiŋ dɔŋsuŋ si nii wialiŋ u si bula piɛsu a bul, “Bɛɛ nɛ la saa jaŋ ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","U bula piba a bul, “Di ŋ kɛŋ gɛnniŋ balia, u maga di ŋ joŋ dɔŋɔ a pi nii-la si bi kuŋ kɛnɛ. Nii-la si kɛŋ kudiilee maa, u maga duu ŋaa kpaa nialiŋ si bi kudiilee kɛnɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ŋii nɛ laŋpoo lilaaraa dɔŋsuŋ ma kɔ duu foba Wii-chuɔlɛ liiŋ a piɛsu a bul, “La kuhiaŋ, bɛɛ nɛ la ma jaŋ ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","U bula piba a bul, “Ma sí moribiee laa kii ŋii ba si daga di maa laa.” ");
INSERT INTO sil_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Laali-yuoroo dɔŋsuŋ ma piɛsu a bul, “Ka la maa, bɛɛ nɛ la ma jaŋ ŋaa?” U bula piba a bul, “Ma sí nuu-kala moribiee kaa laa ari doluŋ, ma ma sí wu-nyiariŋ nyia a laa moribiee. Má leŋ di ma tuɔŋ tɔrɛ ari time-la ma síi laa.” ");
INSERT INTO sil_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Niaa fa si gbɛrɛ Kirisito duu kɔ, ba biina ari u naga ari u nɛ ŋaa Kirisito. ");
INSERT INTO sil_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ŋii nɛ Jɔɔŋ bula piba a bul, “Mi dee. Liiŋ duŋduŋa nɛ mi-na kaa foma. Ama nii-la si jaŋ kɔ, u nɛ yuga kiimi. Mi paala bi maga di mi kpagu a kɛŋ u nɛŋtɛŋŋɛɛ ŋmɛniŋ ma kaa puri. U nɛ jaŋ joŋ Wia Diŋ-zɔŋ-la hɛ ma dɔŋsuŋ lɛ aŋ joŋ nyiniŋ ma hɛ dɔŋsuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U jaŋ kori u mii-chaari-gbaŋa. Duu ŋmoo u miaa kala dɛrɛ, u jaŋ kɛŋ gbaŋa-la a kaa chaarɛ a liisɛ mii-biiŋ a hɛ u vire lɛ aŋ joŋ jɔruŋ a hɛ nyiniŋ lɛ. Nyiŋ-la bi jaŋ disɛ.” ");
INSERT INTO sil_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jɔɔŋ to woŋbiee yugɛ a bul Wia wu-zɔmɔ-la a pi nialiŋ a didagɛba. ");
INSERT INTO sil_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama Jɔɔŋ bul wiaa juu kuori-baliŋ Hɛrɔd lɛ. U fa jaa u naaŋbie Filip haala baa yirɛ Hɛrɔdias. Jɔɔŋ bula pu duu bi maga duu jaa u naaŋbie haala. Wu-bɔŋŋɔɔ dɔŋsuŋ yuga Hɛrɔd fa ŋaa. ");
INSERT INTO sil_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ŋii nɛ u paala wasa ŋaa wu-bɔŋŋɔɔ a pɛ buŋbuŋ wu-bɔmɔ-la lɛ a kɛŋ Jɔɔŋ tɔ dia. ");
INSERT INTO sil_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bua-la Jɔɔŋ síi fo niaa kala Wii-chuɔlɛ liiŋ, u fo Yesu Wii-chuɔlɛ liiŋ maa. Ba si fou liiŋ dɛrɛ, u chuɔlɛ Wia, di wia nyuŋ kpaa balia. ");
INSERT INTO sil_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ŋii nɛ Wia Diŋ-zɔŋ-la ku tuu hɛu lɛ a nagɛ kokomo. U nii nuu yiikoro si lii wia nyuŋ a bula pu a bul, “Ŋ nɛ ŋaa mi Bii-chooluŋ. Mi tuɔŋ tɔrɛ ŋ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu fa si suomo a titiŋ u tiŋtiŋŋaa, u fa yi jisiŋ mara ari fii nɛ. U doho niaa nɛ ŋla: Josɛf fa ŋaa u nyimma. U nɛ niaa fa biinɛ ari u nɛ lul Yesu. Josɛf nyimma yiriŋ nɛ fa Hɛli. ");
INSERT INTO sil_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hɛli nyimma ma yiriŋ nɛ fa Matat. Matat ma nyimma yiriŋ nɛ fa Liivai. Liivai ma nyimma yiriŋ nɛ fa Mɛliki. Mɛliki nyimma ma yiriŋ nɛ fa Jana. Jana nyimma ma yiriŋ nɛ fa Josɛf. ");
INSERT INTO sil_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josɛf nyimma ma yiriŋ nɛ fa Matatayas. Matatayas nyimma ma yiriŋ nɛ fa Emɔs. Emɔs nyimma ma yiriŋ nɛ fa Neham. Neham nyimma ma yiriŋ nɛ fa Ɛzili. Ɛzili nyimma ma yiriŋ nɛ fa Nagai. ");
INSERT INTO sil_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nyimma ma yiriŋ nɛ fa Maat. Maat nyimma ma yiriŋ nɛ fa Matatayas. Matatayas nyimma ma yiriŋ nɛ fa Sɛmeeŋ. Sɛmeeŋ nyimma ma yiriŋ nɛ fa Josɛk. Josɛk nyimma ma yiriŋ nɛ fa Joda. ");
INSERT INTO sil_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nyimma ma yiriŋ nɛ fa Juanaŋ. Juanaŋ nyimma ma yiriŋ nɛ fa Riisa. Riisa nyimma ma yiriŋ nɛ fa Zerubabil. Zerubabil nyimma ma yiriŋ nɛ fa Sialitɛl. Sialitɛl nyimma ma yiriŋ nɛ fa Nɛɛri. ");
INSERT INTO sil_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛɛri nyimma ma yiriŋ nɛ fa Mɛliki. Mɛliki nyimma ma yiriŋ nɛ fa Adi. Adi nyimma ma yiriŋ nɛ fa Kosam. Kosam nyimma ma yiriŋ nɛ fa Ɛlimadam. Ɛlimadam nyimma ma yiriŋ nɛ fa Ɛri. ");
INSERT INTO sil_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛri nyimma ma yiriŋ nɛ fa Jɔsua. Jɔsua nyimma ma yiriŋ nɛ fa Ɛliyiiza. Ɛliyiiza nyimma ma yiriŋ nɛ fa Jɔrim. Jɔrim nyimma ma yiriŋ nɛ fa Matat. Matat nyimma ma yiriŋ nɛ fa Liivai. ");
INSERT INTO sil_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liivai nyimma ma yiriŋ nɛ fa Simiaŋ. Simiaŋ nyimma ma yiriŋ nɛ fa Juda. Juda nyimma ma yiriŋ nɛ fa Josɛf. Josɛf nyimma ma yiriŋ nɛ fa Jonam. Jonam nyimma ma yiriŋ nɛ fa Ɛlayakim. ");
INSERT INTO sil_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛlayakim nyimma ma yiriŋ nɛ fa Mɛliya. Mɛliya nyimma ma yiriŋ nɛ fa Mɛna. Mɛna nyimma ma yiriŋ nɛ fa Mataata. Mataata nyimma ma yiriŋ nɛ fa Neetiŋ. Neetiŋ nyimma ma yiriŋ nɛ fa Devit. ");
INSERT INTO sil_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit nyimma ma yiriŋ nɛ fa Jɛsi. Jɛsi nyimma ma yiriŋ nɛ fa Obɛd. Obɛd nyimma ma yiriŋ nɛ fa Buas. Buas nyimma ma yiriŋ nɛ fa Salimɔŋ. Salimɔŋ nyimma ma yiriŋ nɛ fa Naasuŋ. ");
INSERT INTO sil_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasuŋ nyimma ma yiriŋ nɛ fa Amiinadab. Amiinadab nyimma ma yiriŋ nɛ fa Adimiŋ. Adimiŋ nyimma ma yiriŋ nɛ fa Aani. Aani nyimma ma yiriŋ nɛ fa Hɛzurɔŋ. Hɛzurɔŋ nyimma ma yiriŋ nɛ fa Pɛrɛs. Pɛrɛs nyimma ma yiriŋ nɛ fa Juda. ");
INSERT INTO sil_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nyimma ma yiriŋ nɛ fa Jekɔb. Jekɔb nyimma ma yiriŋ nɛ fa Aizik. Aizik nyimma ma yiriŋ nɛ fa Abiraham. Abiraham nyimma ma yiriŋ nɛ fa Tɛɛra. Tɛɛra nyimma ma yiriŋ nɛ fa Nehɔ. ");
INSERT INTO sil_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehɔ nyimma ma yiriŋ nɛ fa Sɛrug. Sɛrug nyimma ma yiriŋ nɛ fa Riu. Riu nyimma ma yiriŋ nɛ fa Pɛlɛg. Pɛlɛg nyimma ma yiriŋ nɛ fa Iba. Iba nyimma ma yiriŋ nɛ fa Sɛla. ");
INSERT INTO sil_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sɛla nyimma ma yiriŋ nɛ fa Keenaŋ. Keenaŋ nyimma ma yiriŋ nɛ fa Afakizat. Afakizat nyimma ma yiriŋ nɛ fa Sɛm. Sɛm nyimma ma yiriŋ nɛ fa Nowa. Nowa nyimma ma yiriŋ nɛ fa Lamɛki. ");
INSERT INTO sil_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛki nyimma ma yiriŋ nɛ fa Mɛtuusila. Mɛtuusila nyimma ma yiriŋ nɛ fa Inɔk. Inɔk nyimma ma yiriŋ nɛ fa Jarid. Jarid nyimma ma yiriŋ nɛ fa Mahalalil. Mahalalil nyimma ma yiriŋ nɛ fa Keenaŋ. ");
INSERT INTO sil_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keenaŋ nyimma ma yiriŋ nɛ fa Inɔs. Inɔs nyimma ma yiriŋ nɛ fa Sɛt. Sɛt nyimma ma yiriŋ nɛ fa Adam. Wia nɛ ta Adam. ");
INSERT INTO sil_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ŋii nɛ Yesu miira lii Jɔɔdaŋ fuo-la lɛ ku lii di Wia Diŋ-zɔŋ-la hɛu lɛ woruŋ. Ŋii nɛ u kɛnu kaa juu giri-bine tuɔŋ tapulaa mahiŋ balia. Sitaani yie kɔ a mimagisu. (U bi sɛyɛ.) ");
INSERT INTO sil_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tapulaa mahiŋ balia deeŋba kala pɛgɛ u bi kuŋ-kala die. Ŋii nɛ losuŋ kpuu. ");
INSERT INTO sil_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ŋii nɛ Sitaani ku bula pu a bul, “Di ŋ nɛ ŋaa Wia Bie, leŋ di tabiiŋ deeŋ ŋ si na birimɛ boroboro.” ");
INSERT INTO sil_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ŋii nɛ Yesu miira bula pu a bul, “Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari ‘Kudiilee duŋduŋa dee bi nuhuobiine miisiŋ ka pa.’ ” ");
INSERT INTO sil_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ŋii hariŋ Sitaani bira kɛnu kaa jila dagɛ dunia kuoruŋ fine ");
INSERT INTO sil_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","aŋ bul, “Kuoruŋ deeŋ kala ŋaa mi kua nɛ. Mi jaŋ ŋaa di ŋ kɛŋ ba kala doluŋ a tii ba kala a nii ba sima. Mi-na jaŋ wuo joŋo pi nuu-kala mi síi chɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Di ŋ nɛ tuu kpirimi mi sipaaŋ a chuɔlɛmi, kiaa deeŋba kala jaŋ ŋaa ŋ kiaa.” ");
INSERT INTO sil_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ŋii nɛ Yesu bira bula pu a bul, “Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari, ‘U maga di laa chuɔlɛ la Tiina Wia duŋduŋa nɛ aŋ pɛ timaa pu.’ ” ");
INSERT INTO sil_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ŋii nɛ Sitaani bira kɛnu kaa mu Jerusalɛm a kɛnu kaa jil Wia-dia nyu-gbaŋa aŋ bula pu a bul, “Di ŋ nɛ ŋaa Wia Bie, joŋ ŋ titia yuo daha a tuu chigisi tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Na ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari Wia jaŋ leŋ di u tiŋdaaraa ku cheme kɛniŋ. ");
INSERT INTO sil_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ba bira ŋmuŋsa ari ‘Ba jaŋ kɛrɛ kɛniŋ di ŋ sí ŋ naaŋ joŋo ŋmoo tabiiŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ŋii nɛ Yesu bira bula pu a bul, “Ba ma bul Wia teniŋ tuɔŋ ari u bi maga di ŋ mimagisɛ ŋ Tiina Wia.” ");
INSERT INTO sil_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sitaani si magisɛ Yesu ŋii a dɛrɛ, u leŋu, ka di tapulii dɔŋ bira yi. ");
INSERT INTO sil_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ŋii nɛ Yesu lii giri-bine-la tuɔŋ Wia Diŋ-zɔŋ-la doluŋ lɛ a mu Galilii tiŋteeŋ. Yesu wiaa teeli Galilii tiŋteeŋ kala. ");
INSERT INTO sil_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ŋii nɛ u dagɛ niaa Wii-chuɔlɛ diisiŋ lɛ. Ba kala bibɛsɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Ŋii nɛ Yesu mu Nazarɛt, lee-la ba si lulu. Chɛ-wiesii-la chɛɛŋ u mu juu Wii-chuɔlɛ dia ari u si vɛnɛɛ ŋaa ŋii. Ŋii nɛ u sii duu karimɛ Wia teniŋ a pi niaa. Ba joŋ Wia teniŋ tuɔŋ sɛmɛ dɔŋɔ pu, teŋ-la Azaaya si ŋmuŋsa, nii-la fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. U suri a na lee-la ba si ŋmuŋsɛ ŋla a karimɛ a bul, ");
INSERT INTO sil_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wia Diŋ-zɔŋ-la hɛmi lɛ nɛ. U nɛ liisɛmi di mi bul Wia wu-zɔmɔ-la a pi summoo. U nɛ tiŋmi di mi bula pi yosuŋ ari Wia jaŋ joŋba ta, a bira bula pi nyulimaa di ba siaa jaŋ suri. U bira tiŋmi di mi laa niaa ba si nyaga bil a ta ");
INSERT INTO sil_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a bula piba di jina jaŋ yi di la Tiina Wia jaŋ laa u niaa ta.” ");
INSERT INTO sil_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu si karimɛ teŋ-la dɛrɛ, u kaa tɔ aŋ joŋo pi nii-la síi bil teŋ-la aŋ tuu hɔŋ. Nialiŋ kala si hɛ Wii-chuɔlɛ dia-la lɛ chaarɛ ba siaa a pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ŋii nɛ Yesu bula piba a bul, “Teŋ-la mi si karima pima, jiniŋ u sɛnɛ ku ŋaa wutitii nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ŋii nɛ niaa kala tuɔŋ tɔrɛ u nyuŋ. Wu-zɔŋŋɔɔ kala u si bula piba ŋaaba wu-kpuŋkpere. Ba pipiɛsɛ dɔŋɔ, “Josɛf bile dee ŋlaa?” ");
INSERT INTO sil_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ŋii nɛ Yesu bira bula piba a bul, “Mi laa dii ari ma jaŋ magɛ namaga a pimi. U nɛ ŋla: ‘Daalusuŋ tiina, mu vaarɛ ŋ titia.’ Ma jaŋ bira bula pimi a bul di wialiŋ kala mi si ŋaa Kapɛnam lɛ, di mi ŋaaba mi titia jaŋ lɛ maa.” ");
INSERT INTO sil_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ŋii nɛ Yesu bira bul, “Wutitii, mi bulaa pima ari nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ, duu nɛ kɔ u titia jaŋ, u niaa buu cho.” ");
INSERT INTO sil_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ŋii nɛ Yesu bira bul, “Má jegili, wutitii mi bulaa pima. Ilaaja fa si hɛ u miisiŋ lɛ, duonuŋ bi nia jisiŋ batori ari lebi. Ilaaja fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Losuŋ juu Iziral tiŋteeŋ woruŋ. Bua-la lɛ yo-haalaa yuga a fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama Wia bi leŋe Ilaaja mu pɛ Ju̱u tiŋŋaa yo-haalaa kuŋ-kala lɛ. U timu u mu pɛ yo-haal kubala duŋduŋa lɛ a lii Saadɔŋ tiŋteeŋ lɛ, taŋ kubala baa yirɛ Zarɛfat. ");
INSERT INTO sil_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bua-la lɛ Ilaasa ma fa si hɛ u miisiŋ lɛ, gbegisiŋ ma yuga nɛ a hɛ Iziral tiŋteeŋ lɛ, ama Wia bi leŋe Ilaasa vaarɛ ba kuŋ-kala see baal kubala baa yirɛ Neyemaŋ. U lii Siiria tiŋteeŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nialiŋ kala fa si hɛ Wii-chuɔlɛ dia-la lɛ a nii wiiŋ deeŋ, ba baaniŋ sii u nyuŋ. ");
INSERT INTO sil_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba sii a kɛŋ Yesu lɛrɛ lii ba taŋ tuɔŋ a kɛnu kaa jil duŋdolo-la nyuŋ ba fa si saa ba jaŋ. Ba kɛnu kaa jil duŋdolo-la nyuŋ di-bolii aa chɛ di ba joŋu yuo ta duu tuu tel tiŋteeŋ. Ba chɛu ka. ");
INSERT INTO sil_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka u to nialiŋ tuɔŋ a lii viiri. ");
INSERT INTO sil_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ŋii nɛ Yesu lii Nazarɛt lɛ a mu Kapɛnam si hɛ Galilii tiŋteeŋ. Chɛ-wiesii-la chɛɛŋ u mu juu Wii-chuɔlɛ dia a didagɛba. ");
INSERT INTO sil_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","U si dagɛba ŋii, u ŋaaba wu-kpuŋkpere, bɛɛ wiaa uu bul wiaa ari doluŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Di baal kubala nɛ fa hɛ Wii-chuɔlɛ dia-la lɛ. Jiŋ-bɔmuŋ nɛ fa kɛnu. Ŋii nɛ u faasa chiirɛ ");
INSERT INTO sil_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","a bul, “Yesu ŋ si lii Nazarɛt, bɛɛ kuŋ nɛ ŋ chɛ ŋ ŋaala lɛ? Ŋ kɔ di ŋ kpula nɛɛ? Mi jimiŋ nɛ. Ŋ ŋaa Wia Tuɔ-pul Tiina nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu si nii wialiŋ baal-la si bula, u kpia jiŋ-bɔŋ-la lɛ a bul, “Kɛŋ goŋ aŋ ku lii baal-la lɛ.” Jiŋ-bɔŋ-la ŋaa baal-la tel ba kala sipaaŋ aŋ lii baal-la lɛ. U bi wu-bɔŋ kala ŋaau lɛ. ");
INSERT INTO sil_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ba si na ŋii, u ŋaa nuu-kala wu-kpuŋkpere. Ŋii nɛ ba pipiɛsɛ dɔŋɔ a bul, “Ɛɛ nɛ u si wuo bul ŋla? Baal-la deeŋ kɛŋ doluŋ a wuo jiŋ-bɔŋŋɔɔ, a bul wiaa piba ba lii niaa lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋii nɛ Yesu wiaa teeli lee-la kala. ");
INSERT INTO sil_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ŋii nɛ Yesu lii Wii-chuɔlɛ dia-la lɛ a mu baal kubala dia baa yirɛ Saamɔŋ. U mua di Saamɔŋ hiili-haala pina aa wiilɛ. U yaraa kala liŋ. Ba si bul u wiaa pu, ");
INSERT INTO sil_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu mu chiŋ u sɛmɛ aŋ kpia nyanyalii-la lɛ duu leŋu. Nyanyalii-la leŋ haal-la, aŋ ka u guu sii a ŋaa kudiilee piba ba dii. ");
INSERT INTO sil_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Di niaa dɔŋsuŋ ma nɛ ŋii, ba naŋdɔŋsuŋ wiwiilɛ. Nyanyal-yiriba kala nɛ kɛŋba. Wia si jua, ba kɛŋba kaa kɔ Yesu teeŋ. U joŋ u nisaa a daŋ ba kuŋ-kala lɛ, ba duori. ");
INSERT INTO sil_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jiŋ-bɔŋŋɔɔ ma lii niaa lɛ a yugɛ aa chiirɛ, a bula pi Yesu a bul, “Ŋ nɛ ŋaa Wia Bie.” Ŋii nɛ Yesu kpiaba lɛ di ba sí u wiaa bul, bɛɛ wiaa ba jima ari u nɛ ŋaa Kirisito. ");
INSERT INTO sil_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Siipuuraa Yesu lii taŋ-la lɛ a mu lee-la niaa si tuo dimɛ. Ŋii nɛ nialiŋ suomo chichɛu. Ba si mu nau, ba wiwalimɛ di ba kɛnu bil duu sí viiru. ");
INSERT INTO sil_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ŋii nɛ Yesu bula piba a bul, “U maga di mi mu tasiŋ dɔŋsuŋ maa a bul Wia kuorii-la wiaa dimɛ. Ŋii nɛ Wia tiŋmi di mi ku ŋaa.” ");
INSERT INTO sil_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ŋii nɛ u bul Wia wiaa Judiya tiŋteeŋ, Wii-chuɔlɛ diisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bua kubala Yesu chiŋ muga kubala niiŋ baa yirɛ Gɛnɛzarɛt. Niaa yugɛ a yigi dɔŋɔ a kukɔ u teeŋ di ba nii Wia wiaa. ");
INSERT INTO sil_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ŋii nɛ Yesu na liiŋ daborusuŋ balia di ba chiŋ liiŋ niiŋ. Ba tiŋŋaa kaa ku bil nɛ aŋ mu di ba chɛsɛ ba joŋba. Saamɔŋ nɛ tii dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ŋii nɛ Yesu juu Saamɔŋ liiŋ daboro aŋ bul duu yigu duu juu liiŋ tuɔŋ mua. U mu yigu. Ŋii nɛ Yesu hɔŋ liiŋ daboro-la tuɔŋ aŋ didagɛ ni-daŋ-la kala. ");
INSERT INTO sil_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","U si bul wiaa pi nialiŋ dɛrɛ, u bula pi Saamɔŋ a bul, “Kuosi liiŋ daboro-la duu mu lee-la liiŋ si luŋie mua, di ma di ŋ naŋdɔŋsuŋ yuo ma joŋba a kɛsɛ cheŋfilee.” ");
INSERT INTO sil_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ŋii nɛ Saamɔŋ bula pu a bul, “Mi kuhiaŋ, la yuo joŋba titaŋiŋ kala kala nɛ aŋ bi kuŋ-kala kɛnɛ. Ama ŋ-na si bul ŋii pimi, mi jaŋ yuo.” ");
INSERT INTO sil_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ŋii nɛ ba ŋaa ŋii a kɛsɛ cheŋfilee yugɛ kiŋkɛŋ. Ba si kɛsɛ yugɛ ŋii, ba joŋba chichɛ di ba kiɛsɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Di ba naŋdɔŋsuŋ hɛ liiŋ daboro dɔŋɔ tuɔŋ. Ŋii nɛ ba yirɛba di ba ku pɛba lɛ. Ba kɔ a chaarɛ cheŋfilie-la a su̱ liiŋ daborusu-la baliamiŋ kala. Ba paala chichɛ di ba tuu liiŋ bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saamɔŋ yiriŋ dɔŋɔ ma nɛ fa ŋaa Piita. Saamɔŋ Piita si na wii-la si ŋaa, u tuu kpirimi u naadusuŋ nyuŋ Yesu sipaaŋ aŋ bul, “Mi Tiina, sii lii mi teeŋ. Mi ŋaa haachɛ tiina nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ba si kɛsɛ cheŋfilie-la yugɛ ŋii, u ŋaa Piita ari nialiŋ kala wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saamɔŋ naŋdɔŋsuŋ Jeems ari Jɔɔŋ ma fa hɛ dimɛ. Ba fa ŋaa Zɛbidii biiriŋ nɛ. Wialiŋ ba si na ma ŋaaba wu-kpuŋkpere. Ŋii nɛ Yesu bula pi Saamɔŋ a bul, “Sí fawulluŋ fá. A suomi jiniŋ, ŋ jaŋ chɛ kikɛsɛ niaa ari ŋ síi kɛsɛ cheŋfilee ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ŋii hariŋ ba sii a kɛŋ liiŋ dabori-biisi-la kaa ku lii liiŋ niiŋ. Ba leŋ kuŋ-kala ta dimɛ aŋ sii to Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ŋii nɛ Yesu mu taŋ kubala di baal kubala nɛ ŋii. U ŋaa gbege nɛ. U na Yesu a tuu kpirimi u sipaaŋ aŋ sulu a bul, “Mi kuhiaŋ, di ŋ nɛ cho, ŋ jaŋ wuo ŋaa di mi duori.” ");
INSERT INTO sil_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ŋii nɛ Yesu liisɛ u nisiŋ a digu aŋ bul, “Mi cho nɛ. Duori.” Yawiil-la guu leŋ baal-la. ");
INSERT INTO sil_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ŋii nɛ Yesu bula pu a bul, “Sí wiiŋ deeŋ bula pi nuu-kala. Ama kɛŋ ŋ titia mu dagɛ nii-la si kpu pusuŋ pipi Wia duu kpu pusuŋ pipi Wia, a piisɛ ŋ disinniŋ ta ari Moosis fa si dagɛma ŋii. Di ŋ nɛ ŋaa ŋii, niaa jaŋ na ari ŋ bira bi disinniŋ kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aŋ ka wii-la ha faasa teeli leriŋ kala a mu. Niaa yuga a kɔ u teeŋ di ba nii u wiaa, aŋ ka duu pɛ vaarɛ ba nyanyalaa maa. ");
INSERT INTO sil_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka Yesu yie sii mu giriŋ duu chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tapulii kubala Yesu didagɛ niaa, di Wia doluŋ hɛu lɛ u kaa vivaarɛ nyanyal tiŋŋaa. Farisii tiŋŋaa ari Wia teniŋ kerichiba si lii Galilii tiŋteeŋ ari Judiya tiŋteeŋ ari Jerusalɛm kala ma fa hɔŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ŋii nɛ niaa chuŋ gbɛriku kubala ari u bɔsɔ kala a kaa kɔ a wiwalimɛ di ba kɛnu kaa juu dia-la lɛ Yesu si hɛ a bil u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama niaa fa si yuga ŋii, ba bi woŋbiiŋ na di ba kɛnu juu. Ŋii nɛ ba kɛnu kaa jil lusuŋ nyuŋ a ta luri a joŋu ta. U to dimɛ a tuu nialiŋ tutuɔbaaniŋ Yesu sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu si na ari niaa deeŋba ŋaau yarida woruŋ, u bula pi gbɛriku-la a bul, “Mi naŋdɔŋ, mi joŋ ŋ haachɛba chɛŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ŋii nɛ Farisii tiŋŋaa ari Wia teniŋ kerichiba-la suomo pipiɛsɛ dɔŋɔ a bul, “Kubɛɛ nɛ nia deeŋ síi tuusɛ Wia joŋŋoo ŋla? Nuu-kala bi jaŋ wuo joŋ haachɛba chɛ nuu see Wia duŋduŋa.” ");
INSERT INTO sil_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ŋii nɛ Yesu wuo jiŋ ba tuɔbiinaa a piɛsɛba a bul, “Bɛɛ nɛ tii ma biinɛ wiaa deeŋba ma tuɔŋ lɛ? ");
INSERT INTO sil_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mi si jaŋ bul di mi joŋ u haachɛba chɛu nɛ koo mi si jaŋ bul duu sii a chuoli u bɔsɔ a viviiri, ba tuɔŋ kubɛɛ nɛ ŋaa mɔli? ");
INSERT INTO sil_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mi jaŋ dagɛma ari mi-na Nuhuobiine Bie kɛŋ doluŋ dunia lɛ di mi joŋ haachɛba chɛ niaa.” Ŋii nɛ u bula pi gbɛriku-la a bul, “Sii a joŋ ŋ bɔsɔ a mu dia.” ");
INSERT INTO sil_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","U guu duori a sii a joŋ u bɔsɔ-la u fa si piŋ u nyuŋ a mu dia aŋ didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","U ŋaa nialiŋ kala fa si hɛ dimɛ wu-kpuŋkpere. Fawulluŋ kɛŋba. Ba dɛnnɛ Wia a bul, “La na wu-kpuŋkpere jiniŋ.” ");
INSERT INTO sil_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ŋii hariŋ Yesu bira sii a lii a na laŋpoo lilaara kubala baa yirɛ Liivai duu hɔŋ u tiŋtinni dia lɛ. Ŋii nɛ Yesu yiru a bula pu duu sii a tuto u hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ŋii nɛ Liivai sii aŋ leŋ u kuŋ-kala ta aŋ to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ŋii nɛ Liivai ŋaa di ba gbieli gbiele u dia lɛ. Yesu ari u haritooroo ari laŋpoo lilaaraa dɔŋsuŋ yugɛ, ari niaa dɔŋsuŋ ma fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ ari Wia teniŋ kerichiba ari ba naŋdɔŋsuŋ sii a pipiɛsɛ Yesu haritooroo a bul, “Bɛɛ nɛ tii ma di laŋpoo lilaaraa ari haachɛ diiree kala hɔnɔ didii kudiilee?” ");
INSERT INTO sil_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu nii ba síi bul ŋii. Ŋii nɛ u bula piba a bul, “Nialiŋ si kɛŋ yarifiɛlaa bi daaluŋ ŋiŋaara ka chɛ, see nialiŋ síi wiilu. ");
INSERT INTO sil_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi kɔ di mi yirɛ haachɛ diiree nɛ di ba leŋ ba haachɛba. Nialiŋ si kɛŋ tuɔ-pula mi sipaaŋ dee mi kɔ mi yirɛ.” ");
INSERT INTO sil_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŋii nɛ niaa dɔŋsuŋ ku piɛsɛ Yesu a bul, “Jɔɔŋ Wia lii-foori-la haritooroo yie vuvɔɔ niiŋ nɛ aŋ pɛ chuchuɔlɛ Wia bua-na kala lɛ. Farisii tiŋŋaa haritooroo ma ŋiŋaa ŋii titia. Ama ŋ-na haritooroo bi niiŋ ka vɔɔ.” ");
INSERT INTO sil_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ŋii nɛ Yesu ma piɛsɛba a bul, “Di nuu nɛ mu jaa haala kaa kɔ, di ba duu naŋdɔŋsuŋ gbigbieli ha-jaari gbiele, u naŋdɔŋsuŋ jaŋ vɔɔ niiŋ koo? Ai, ba bi niiŋ ka vɔɔ. ");
INSERT INTO sil_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama chɛɛ dɔŋ nɛ hɛ dimɛ, ba jaŋ kɛŋ baal-la kaa mu lee, aŋ ka di u naŋdɔŋsu-la vɔɔ niiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ŋii nɛ u bira magɛ namaga a piba a bul, “Nuu-kala bi jaŋ keri gɛripɛ-faliŋ a kaa tɔ gɛri-biniŋ. Ŋ nɛ ŋaa ŋii, ŋ jaŋ chei gɛri-falii-la. Gɛripɛ-falii-la ma ŋ si kere tɔ gɛri-kɔsu-la ma bi jaŋ challɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ŋii titia nɛ nuu ma bi jaŋ joŋ si-huoŋ a hɛ pupoi-kpaaŋ lɛ. Ŋ nɛ ŋaa ŋii, pupoi-la jaŋ yɛrɛ, di siŋ-la kala bisa ta. ");
INSERT INTO sil_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Si-huoŋ maga di ŋ joŋu hɛ pupoi-zɔmuŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Di nuu nɛ nyua si-yele, u bira bi chɛ duu nyua si-huoŋ, bɛɛ wiaa nuu-kala jima ari si-yele nɛ zɔmɔ kii si-huoŋ.” ");
INSERT INTO sil_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bua kubala, chɛ-wiesii-la chɛɛŋ, Yesu ari u haritooroo to nyoŋso baga tuɔŋ bibal. Ŋii nɛ u haritooro-la bori nyoŋso-la a chichaŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Di Farisii tiŋŋaa dɔŋsuŋ ma hɛ dimɛ a naba. Ba si naba ŋii, ba piɛsɛba a bul, “Bɛɛ nɛ tii ma ŋaa ŋla? Maa chei la chɛ-wiesii-la chɛɛŋ kisiŋ nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ŋii nɛ Yesu piɛsɛba a bul, “Ma bi wii-la Devit fa si ŋaa karimaa? Losuŋ fa si kɛnu ba di u hariŋ niaa, ");
INSERT INTO sil_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","u mu juu Wia-dia a joŋ boroboroba-la ba fa si kaa ku bil Wia sipaaŋ a chɔgɔ dii aŋ joŋo pi u hariŋ niaa maa, ba ma laa dii. U fa ŋaa kisiŋ nɛ ari ni-wogo si jaŋ joŋo dii, see nii-la si kpu pusuŋ pipi Wia duŋduŋa, ka Devit ari u niaa dii.” ");
INSERT INTO sil_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ŋii nɛ Yesu bira bula piba a bul, “Mi-na Nuhuobiine Bie nɛ ŋaa chɛ-wiesii-la tiina ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chɛ-wiesii-la chɛɛŋ dɔŋɔ Yesu bira juu Wii-chuɔlɛ dia a didagɛ niaa, di baal kubala ma fa hɛ dimɛ. U na-diiŋ nisiŋ suba nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wia teniŋ kerichiba ari Farisii tiŋŋaa dɔŋsuŋ ma fa hɛ dimɛ. Baa chɛ di ba na wii nɛ a to ŋii lɛ a kɛŋ Yesu, a bul duu chei ba kisiŋ lɛ nɛ. Ba kala chaarɛ siaa bibenu di ba na ari u jaŋ vaarɛ baal-la chɛ-wiesii-la chɛɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama Yesu fa jiŋ ba tuɔbiinaa kala nɛ. Ŋii nɛ u bula pi na-suu-la tiina a bul duu sii a ku chiŋ ba tutuɔbaaniŋ. Ŋii nɛ baal-la sii a mu chiŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ŋii nɛ Yesu bira piɛsɛba a bul, “Ɛɛ nɛ la naabalimaba kisiŋ bul di la ŋiŋaa chɛ-wiesii-la chɛɛŋ? Di la pipɛ niaa lɛ koo di la dudɔgisɛba? Di la lilaa niaa miisiŋ koo di la kpukpuba?” ");
INSERT INTO sil_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu si bul ŋii, u beŋ nialiŋ kala fa si hɔŋ dimɛ golli aŋ bula pi na-suu-la tiina duu kɛŋ u nisiŋ tiɛnɛ. U kaa tiɛnɛ. U nisiŋ bira nagɛ u nagiŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yesu fa si ŋaa ŋii, baaniŋ faasa kɛŋ Farisii tiŋŋaa ari Wia teniŋ kerichiba-la. Ba vuvuurɛ ŋii ba si jaŋ ŋaau lɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tapulii kubala Yesu jil peeliŋ nyuŋ duu chuɔlɛ Wia. U chuɔlɛ Wia ŋii deeŋ deeŋ taŋ-pul. ");
INSERT INTO sil_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taŋ si pula, u yirɛ u haritooroo ba kɔ u teeŋ. Ŋii nɛ u liisɛ ba tuɔŋ niaa fii ari balia a kɛŋba kaa yirɛ u naŋzɔɔba maa. ");
INSERT INTO sil_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nialiŋ u si liisa nɛ ŋla: Saamɔŋ (Yesu fa kɛnu yiyirɛ Piita nɛ) ari u naaŋbie Aŋduru, ari Jeems ari Jɔɔŋ ari Filip ari Batolomi ");
INSERT INTO sil_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ari Matiu ari Tɔmas ari Alifiyas bie Jeems, ari Saamɔŋ Zɛlɔt, ");
INSERT INTO sil_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ari Jeems bie Judas, ari Judas Isikarɔt, nii-la si ku ŋaa zɛŋbɛ tiina. ");
INSERT INTO sil_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ŋii nɛ Yesu ari u naŋzɔɔba-la lii peel-la nyuŋ ku tuu a chiŋ tiŋteeŋ, di u haritooroo dɔŋsuŋ ma hɛ dimɛ a yugɛ. Niaa dɔŋsuŋ ma yuga a hɛ dimɛ a lii Judiya tiŋteeŋ, dɔŋsuŋ lii Jerusalɛm, dɔŋsuŋ ma lii Taya ari Saadɔŋ tiŋteeŋ a kpagɛ mugi-baliŋ niiŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Niaa deeŋba kala kɔ di ba jegile nii wialiŋ Yesu síi bul nɛ aŋ ka duu vaarɛba. Nialiŋ dɔŋsuŋ ma hɛ dimɛ, jiŋ-bɔŋŋɔɔ kɛŋba. Yesu ŋaa ba duori. ");
INSERT INTO sil_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wia doluŋ nɛ hɛu lɛ u vivaarɛ niaa. Ŋii wiaa nɛ nialiŋ kala ninɛrikɛ di ba digu. Di ba nɛ digu, dol-la liiu lɛ, u ŋaa ba duori. ");
INSERT INTO sil_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu si vaarɛ nialiŋ dɛrɛ, u miira beŋ u haritooroo aŋ bul, “Ma nialiŋ si ŋaa summoo, Wia jaŋ pɛma lɛ. Ma nɛ jaŋ dii Wia kuorii-la. ");
INSERT INTO sil_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ma ma nialiŋ losuŋ síi kpu lɛɛlɛ, Wia jaŋ pɛma lɛ. U jaŋ pima kudiilee di ma dii a vɔgɛ. Ma nialiŋ síi yel lɛɛlɛ, Wia ma jaŋ pɛma lɛ, bɛɛ wiaa Wia jaŋ ŋaa ma mɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Di niaa nɛ bɛrɛma a liisɛma ta ba tuɔŋ a tutuusɛma a chichei ma yiriŋ a bul di ma ŋaa ni-bɔmɔ nɛ, di ba nɛ bul ŋii a tiŋ ma síi to mi-na Nuhuobiine Bie hariŋ wiaa, Wia ma jaŋ pɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Di ŋii nɛ ku chiŋma lɛ, má leŋ di ma gugua ari tuɔtɔruŋ, bɛɛ wiaa ma time jaŋ yugɛ Wia-jaŋ lɛ. La naabalimaba ma dɔgisɛ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama ma nialiŋ si kɛŋ kiaa lɛɛlɛ, ma jaŋ na hɛɛŋ, bɛɛ wiaa ma laa sipaaŋ dii ma sima dɛrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ma nialiŋ si vɔgɔ lɛɛlɛ, ma ma jaŋ na hɛɛŋ. Losuŋ jaŋ kɛŋma. Ma nialiŋ síi mɔŋ lɛɛlɛ, ma jaŋ na hɛɛŋ. Ma tuɔŋ jaŋ chei, di ma yel. ");
INSERT INTO sil_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Di niaa kala yie bɛsɛma lɛ, ma ma jaŋ na hɛɛŋ, bɛɛ wiaa la naabalimaba Ju̱u tiŋŋaa ma bɛsɛ nialiŋ fa si nyia wiaa a bul di baa bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ŋii nɛ Yesu bira dagɛ niaa a bula piba a bul, “Ma nialiŋ síi jegili mi teeŋ, mi bulaa pima di ma cho ma diŋdɔŋŋɔɔ aa ŋaa wu-zɔŋŋɔɔ nialiŋ si bɛrɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","U maga di maa sul Wia duu pɛ nialiŋ síi bul wu-bɔŋŋɔɔ ma lɛ a chuɔlɛ Wia pi nialiŋ síi dɔgisɛma. ");
INSERT INTO sil_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Di nuu nɛ fallɛ ŋ na-gua chaŋkpaŋiŋ lɛ, kɛŋ ŋ na-diiŋ chaŋkpaŋiŋ ma birima pu duu fallɛ. Di nuu nɛ kɛŋ ŋ gɛri-baliŋ laa, wuri ŋ gɛri-bie ma pɛ pu. ");
INSERT INTO sil_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Di ŋ nɛ kɛŋ kuŋ, di nuu piɛsɛ chichɛ, joŋo pu. Di nuu nɛ joŋ ŋ kuŋ maa, bira sí piɛsa laa. ");
INSERT INTO sil_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma síi chɛ di niaa ŋiŋaa ŋii ma lɛ, má ma joŋ ŋii ŋiŋaaba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Di ma nɛ cho nialiŋ si choma duŋduŋ, u bi maga di ma kɛŋ time, bɛɛ wiaa haachɛ diiree ma cho dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Di maa ŋaa wu-zɔŋŋɔɔ nialiŋ síi ŋaa wu-zɔŋŋɔɔ ma lɛ, ma bi time kɛnɛ, bɛɛ wiaa haachɛ diiree ma ŋaa ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Di ma nɛ joŋ kiaa a chiŋ nialiŋ ma si biina ba jaŋ wuo time pima aŋ vɔŋ niaa dɔŋsuŋ, ma bira bi time kɛnɛ, bɛɛ wiaa haachɛ diiree ma joŋ kiaa chichiŋ haachɛ diiree dɔŋsuŋ nɛ aŋ gbɛrɛ di ba bira ti̱ŋba ŋii titia. ");
INSERT INTO sil_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama wialiŋ mi síi chɛ di ma ŋaa nɛ ŋla: Má cho ma diŋdɔŋŋɔɔ aa ŋaa wu-zɔŋŋɔɔ ba lɛ, a joŋ kiaa chiŋba aŋ sí gbɛrɛ di ba ti̱ŋma. Di ma nɛ ŋaa ŋii, Wia jaŋ leŋ di ma ŋaa u-na Wii-baliŋ biiriŋ, duu joŋ ku-bal-bal ti̱ŋma. Wia yie pɛ ni-bɔŋŋɔɔ ari nialiŋ ma kala si kɛŋ siiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Má fifá niaa nennige ari ma Nyimma Wia síi fá niaa nennige ŋii. ");
INSERT INTO sil_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma sí ma dɔŋsuŋ tiŋŋaa wiaa laa jijiŋ a ma sí cheeriŋ joŋo piba. Di ma nɛ ŋaa ŋii, Wia ma bi jaŋ joŋ cheeriŋ pima. Má joŋ wiaa chɛ ma dɔŋsuŋ tiŋŋaa. Di ma nɛ ŋaa ŋii, Wia ma jaŋ joŋ ma wiaa chɛma. ");
INSERT INTO sil_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Má ŋaa kiaa pipi ma dɔŋsuŋ tiŋŋaa. Di ma ŋaa ŋii, Wia ma jaŋ ŋaa kiaa a pima a ma jaŋ kɛŋ zile ma teeŋ. U jaŋ magisɛ kiaa chuɔrɛ a pima. Ku-la ŋ si kaa magisa pi ŋ dɔŋsuŋ tiŋŋaa, u titia nɛ Wia ma jaŋ kaa magisa piŋ.” ");
INSERT INTO sil_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ŋii nɛ Yesu bira magɛ namaga piba a bul, “Nyulima bi jaŋ wuo a kɛŋ nyulima dɔŋɔ daaŋ lɛ. Di u nɛ ŋaa ŋii, ba kala balia jaŋ tel buɔtuoŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukuuri-bie bi u kerichi ka kii, ama di kerichi-la dagɛ bile dɛrɛ, u jaŋ wuo magɛ u kerichi-la. ");
INSERT INTO sil_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ɛɛ nɛ ŋ jaŋ wuo na daa-bie si tel ŋ naaŋbie siiŋ lɛ aŋ bi daa-bal-la si tel ŋ titia siiŋ lɛ ka na? ");
INSERT INTO sil_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ŋ bi jaŋ wuo bula pi ŋ naaŋbie a bul duu leŋ di ŋ liisɛ daa-bie-la si hɛ u siiŋ lɛ, aŋ paala bi daa-bal-la si hɛ ŋ titia siiŋ lɛ ka na. Ŋ-na kaŋfugi tiina, laa sipaaŋ liisɛ daa-bal-la si hɛ ŋ titia siiŋ lɛ, ka ŋ siaa wuo na, ŋii nɛ ŋ ma jaŋ wuo pɛ ŋ naaŋbie lɛ a liisɛ daa-bie-la si hɛ u siiŋ lɛ a pu.” ");
INSERT INTO sil_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ŋii nɛ Yesu magɛ namaga a pi niaa a bul, “Tia-la si kɛŋ yarifiɛlaa bi jaŋ nɛŋ nɛŋ-lɔrunuŋ, aŋ ka tia-la si bi yarifiɛlaa kɛnɛ ma bi jaŋ nɛŋ nɛŋ-zɔŋŋɔɔ. ");
INSERT INTO sil_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tia-la nɛnɛɛ nɛ yie dagɛ tia-la yiri. Sɔjaamiŋ bi tutogo naŋbilaa ka nɛŋ, sɔguŋ-gbeŋe ma bi chichuɛŋ ka nɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ni-zɔmuŋ kɛŋ tuɔbiiŋ-zɔŋŋɔɔ nɛ u tuɔŋ lɛ aa ŋaa wu-zɔmɔ-la u síi biinu. Ni-bɔmuŋ ma kɛŋ tuɔbiiŋ-bɔŋŋɔɔ nɛ u tuɔŋ lɛ a maa ŋaa wu-bɔmɔ-la u síi biinu u tuɔŋ lɛ. Ŋ tuɔbiinaa si kɛŋ wii-la nɛ, u nɛ ŋ niiŋ bubul.” ");
INSERT INTO sil_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ŋii nɛ Yesu bira bul, “Bɛɛ nɛ tii ma kɛŋmi yiyirɛ ‘La Tiina, la Tiina,’ aŋ bi wialiŋ mi síi bula pima ka ŋaa? ");
INSERT INTO sil_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nii-la kala si kɔ mi teeŋ a jegile nii mi niiŋ wiaa a tutoba, mi jaŋ dagɛma ŋii u si naga. ");
INSERT INTO sil_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U nagɛ baala si saa dia nɛ a lu dia-la geŋtine, u faasa tuu kpaginyiliŋ nyuŋ. Ŋii nɛ duonuŋ nii, fuoŋ su̱ a pɛllɛ yagɛ dia-la, ka dia-la bi jigise maa, bɛɛ wiaa u saau woruŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama nii-la si jegile nii wialiŋ mi si bula aŋ biba to, u nagɛ baal-la si saa u dia tiŋteeŋ aŋ bi geŋtine luo u tuu nɛ. Ŋii nɛ duonuŋ nii, fuoŋ su̱, liiŋ pɛllɛ yagɛ dia-la, dia-la kala tel wuru.” ");
INSERT INTO sil_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu si bul wiaa deeŋba kala a pi nialiŋ dɛrɛ, u sii mu taŋ kubala baa yirɛ Kapɛnam. ");
INSERT INTO sil_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Baal kubala nɛ fa hɛ dimɛ. U fa ŋaa Rom laali-yuoroo kuhiaŋ nɛ a fa kɛŋ u yomo nɛ a chou woruŋ. Yomo-la wiwiilɛ a pina kikiiki. ");
INSERT INTO sil_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ŋii nɛ laali-yuoroo kuhiaŋ-la nii Yesu wiaa. U si nii ŋii, u liisɛ Ju̱u tiŋŋaa kuhiasiŋ di ba mu sulu duu ku vaarɛ u yomo-la. ");
INSERT INTO sil_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba sii a mu Yesu teeŋ a sulu kiŋkɛŋ kiŋkɛŋ a bul, “Baala deeŋ ŋaa ni-zɔŋ nɛ. U maga di ŋ pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","U cho la niaa woruŋ. U titia nɛ saa Wii-chuɔlɛ dia a pila.” ");
INSERT INTO sil_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ŋii nɛ Yesu to ba hariŋ mu. Ba si mu kpagɛ laali-yuoroo kuhiaŋ dia, baal-la tiŋ u naŋdɔŋsuŋ di ba ku lii bula pi Yesu a bul, “Mi Tiina, sí ŋ titia walimu a kɔ mi dia. Mi bi maga di ŋ ku juu mi dia. ");
INSERT INTO sil_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ŋii nɛ tii mi paala bi ŋ teeŋ kɔ. Ŋ-na yaa suri ŋ niiŋ a bul di mi yomo-la duori, u jaŋ duori. ");
INSERT INTO sil_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mi ma paala to mi laali-yuoroo nihiasiŋ niiŋ nɛ. Laali-yuoroo dɔŋsuŋ tuto mi niiŋ maa. Di mi nɛ bul di niaa deeŋba mu daha, ba yie mu nɛ. Di mi bira si di nia deeŋ kɔ daha, u yie kɔ nɛ. Di mi nɛ bula pi mi yomo duu ŋaa deeŋ, u yie ŋaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu si nii wiaa deeŋba, u ŋaau wu-kpuŋkpere. U miira daasɛ hariŋ a bula pi ni-daŋ-la fa síi to u hariŋ a bul, “Mi ha bi yarida deeŋ doho na Iziral tiŋteeŋ niaa tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ŋii nɛ nialiŋ laali-yuoroo kuhiaŋ-la fa si tima, ba miira mu u dia, di u yomo-la duoro. ");
INSERT INTO sil_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu si vaarɛ Rom laali-yuoroo kuhiaŋ yomo-la, u bi diene ka u mu taŋ kubala baa yirɛ Neeŋ. Ni-daŋ ari u haritooroo nɛ to u hariŋ mu. ");
INSERT INTO sil_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","U si mu kpagɛ taŋ-la niiŋ di baa yel yoho. Baal kubala nɛ suba. U nɛ fa ŋaa u naaŋ bie kala. U naaŋ ma fa ŋaa yo-haal nɛ. Niaa yuga a lii taŋ-la a ku chigi haal-la. ");
INSERT INTO sil_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesu si na haal-la, nennige kala kɛnu. U bula pu a bul duu sí yel. ");
INSERT INTO sil_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ŋii nɛ u mu a digi daga-la ba fa si joŋ suu-la hɛ. Nialiŋ fa si chuŋ daga-la a kaa mu di ba hugi, ba chiŋ. Ŋii nɛ Yesu bula pi suu-la a bul, “Bapuɔsi-bie, mi bula piŋ di ŋ sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Baal-la sii suuŋ lɛ a suomo bubul wiaa. Ŋii nɛ Yesu joŋu pi u naaŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fawulluŋ kɛŋ nuu-kala. Ba dɛnnɛ Wia a bul, “Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba tuɔŋ ku-bal nɛ ku tuu la tuɔŋ. Wia kɔ duu laa u niaa ta nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ŋii nɛ wiiŋ deeŋ Yesu si ŋaa, teeli Judiya tiŋteeŋ kala ari ta-biisi-la si golli Judiya tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jɔɔŋ haritooroo bul wiaa deeŋba kala Yesu si ŋaa a pu. ");
INSERT INTO sil_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ŋii nɛ Jɔɔŋ, Wia lii-foori-la yirɛ ba tuɔŋ niaa balia, a tiŋba di ba mu Yesu teeŋ a piɛsu a bul, “Ŋ nɛ nii-la Jɔɔŋ si si u jaŋ kɔ, koo la gbɛrɛ nuu ma dɔŋ nɛɛ?” Ŋii nɛ ba mu Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba si mu u teeŋ, ba piɛsu a bul, “Jɔɔŋ, Wia lii-foori-la nɛ tiŋla di la ku piɛsiŋ ari ŋ nɛ nii-la u si si u jaŋ kɔ koo la gbigbɛrɛ nuu dɔŋ nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bua-la titia lɛ Yesu vaarɛ nyanyal tiŋŋaa a yugɛ, a kiri jiŋ-bɔŋŋɔɔ niaa lɛ, aŋ suri nyulimaa ma siaa. ");
INSERT INTO sil_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ŋii nɛ u bula pi Jɔɔŋ haritooro-la a bul, “Má miira mu a bula pi Jɔɔŋ wialiŋ kala ma si nia aŋ na maa. Nyulimaa siaa susuri, gbɛrikɛɛ vivɛŋ, gbegisiŋ duduori. Taŋŋaa ninii wiaa. Nialiŋ si suba sisii suuŋ lɛ. Summoo ma wuo ninii Wia wu-zɔŋŋɔɔ. ");
INSERT INTO sil_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nialiŋ si bi kaa lɛrɛ ari mi nɛ ŋaa nii-la Wia si tima, ba tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ŋii nɛ Jɔɔŋ haritooro-la viiri. Ka Yesu suomo bul Jɔɔŋ wiaa a pipi ni-daŋ-la. U piɛsɛba, “Ma si mu Jɔɔŋ teeŋ giri-bine lɛ, bɛɛ nɛ ma fa gbɛrɛ di ma na? Ma mu di ma na yaŋ peliŋ si kaa viviisi nɛɛ? Ai. ");
INSERT INTO sil_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bɛɛ nɛ saa ma lii di ma na? Ma lia di ma na nuu si laalɛ gɛri-zɔŋŋɔɔ nɛɛ? Ai. Bee na nialiŋ si yie laalɛ gɛnniŋ deeŋba, ba yie juu kuori-diisiŋ nɛ aa nii sima. ");
INSERT INTO sil_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Má saa dagɛmi ku-la ma si mua di ma na. Ma mu di ma na nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛɛ? Oo, mi jaŋ bula pima ari ma na nuu duu kii nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","U-na Jɔɔŋ wiaa nɛ ba ŋmuŋsa bil Wia teniŋ tuɔŋ, a bul di Wia si, ‘Má jegile nii mi teeŋ, mi jaŋ tiŋ mi tiŋdaara duu laa ŋ sipaaŋ a mu a wasɛ woŋbiiŋ biliŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ŋii nɛ Yesu bira bula pi niaa a bul, “Jɔɔŋ nɛ kii nuu-kala ba si lula. Ama nii-la si ŋaa ni-bie Wia kuorii-la tuɔŋ, u nɛ yuga kii Jɔɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Nialiŋ ari ba tuɔŋ laŋpoo lilaaraa fa si nii wialiŋ Jɔɔŋ si bula, ba laa dii a to Wia. Ba nɛ ku ŋaa tuɔ-pul timma. Jɔɔŋ foba Wii-chuɔlɛ liiŋ maa. ");
INSERT INTO sil_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Farisii tiŋŋaa ari Wia teniŋ kerichiba via Wia niiŋ wialiŋ Jɔɔŋ si bula. Ba nɛ bi sɛyɛ di Jɔɔŋ foba Wii-chuɔlɛ liiŋ.) ");
INSERT INTO sil_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ŋii nɛ Yesu bira bul, “Bɛɛ nɛ mi jaŋ kɛŋ jiniŋ niaa kaa magisɛ? Ɛɛ nɛ ba nagɛ? ");
INSERT INTO sil_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba nagɛ haŋbiisiŋ síi gbieli yɔbɔ tuɔŋ nɛ. Dɔŋsuŋ yie kpia dɔŋɔ lɛ, a bula piba a bul, ‘La yii yiilaa nɛ pima, aŋ ka ma bi gua, la yel yoho pima, aŋ ka ma bi yel.’ ");
INSERT INTO sil_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bua-la lɛ Jɔɔŋ Wia lii-foori-la si kɔ ma teeŋ, uu vɔɔ niiŋ nɛ a bi siniŋ ma nyua. Ŋii nɛ ma si di jiŋ-bɔŋ nɛ kɛnu. ");
INSERT INTO sil_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aŋ ka mi-na Nuhuobiine Bie kɔ ma teeŋ a didii kiaa aŋ pɛ nyunyua siniŋ maa. Ŋii nɛ ma bula pi dɔŋɔ a bul baala deeŋ ŋaa luobii tiina nɛ a ŋaa si-nyuaru maa, aŋ pɛ kɛŋ laŋpoo lilaaraa ari haachɛ diiree kala kaa dii naŋdɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nialiŋ si sɛi wu-jimii-la si lii Wia teeŋ, ba wu-ŋaalaa daga ari ba sɛnɛ lii Wia teeŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tapulii kubala Farisii tiŋŋaa tuɔŋ dɔŋɔ yirɛ Yesu duu kɔ u dia di ba dii kudiilee. Yesu mu a hɔŋ di ba dii kiaa. ");
INSERT INTO sil_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Di haal kubala hɛ taŋ-la lɛ a ŋaa haachɛ diiru. Haal-la nii Yesu wiaa ari u hɛ Farisii tiina-la dia lɛ aa dii kiaa. Ŋii nɛ u sii joŋ tulaali loŋ a kaa mu juu dia-la. ");
INSERT INTO sil_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","U si juu dia-la, u chiŋ Yesu naasiŋ sɛmɛ a yiyel sii-liiriŋ a hihɛ Yesu naasiŋ lɛ. Sii-liiriŋ si hɛ Yesu naasiŋ lɛ ŋii, u kɛŋ u nyu-punaa kaa tiikɛ aŋ guori Yesu naasiŋ, a bisɛ tulaalii-la hɛ u naasiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisii tiina-la si yirɛ Yesu duu ku dii kiaa na wiiŋ deeŋ a bibiinɛ u tuɔŋ lɛ, “Di baala deeŋ sɛnɛ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ, u fa jaŋ jiŋ ari haala deeŋ si digu ŋaa haachɛ diiru nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ŋii nɛ Yesu bula pi Saamɔŋ a bul, “Saamɔŋ, mi kɛŋ wii nɛ di mi bula piŋ.” Ŋii nɛ Saamɔŋ bula pu a bul, “Mi kuhiaŋ, bula pimi.” Ŋii nɛ Yesu bula pu a bul, ");
INSERT INTO sil_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Baalaa balia nɛ hɛ dimɛ a sii mu chiŋ moribiee kiaa tiina teeŋ. Dɔŋɔ chiŋ siidi bui banɛsɛ, dɔŋɔ ma chiŋ siidi zɔ-banɛsɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Niaa deeŋba balia tuɔŋ, kuŋ-kala bi u chimiŋ wuo ti̱ŋ. Ŋii nɛ kiaa tiina-la joŋ chiŋ-la a chɛ ba kala. Niaa deeŋba baliamiŋ tuɔŋ, kubɛɛ nɛ jaŋ cho baal-la woruŋ?” ");
INSERT INTO sil_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ŋii nɛ Saamɔŋ bula pu duu biina ari nii-la chimiŋ si yuga nɛ. Ŋii nɛ Yesu bula pu di wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ŋii nɛ u miira beŋ haal-la aŋ piɛsɛ Saamɔŋ a bul, “Ŋ na haal-la deeŋ nɛɛ? Mi kɔ ŋ dia, aŋ ka ŋ bi liiŋ ŋaa pimi di mi sɔŋ mi naasiŋ, aŋ ka u-na kɛŋ u sii-liiriŋ kaa sɔŋ mi naasiŋ aŋ kɛŋ u nyu-punaa ma tiikɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mi síi kɔ ŋ dia, ŋ bimi guoro, ka u-na guori mi naasiŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ŋ bi nuuŋ ŋaa tisɛ mi nyuŋ, ka u-na ŋaa tulaali tisɛ mi naasiŋ. ");
INSERT INTO sil_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mi bula piŋ ari mi joŋ u haachɛba yugɛ nɛ a chɛu, ŋii nɛ tii u chomi woruŋ ŋii. Ama nii-la ma mi si joŋ u haachɛba muapilii chɛu, u tiina ma chomi muapilii nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ŋii nɛ Yesu bula pi haal-la niaa tuɔŋ ari u joŋ u haachɛba a chɛu nɛ. ");
INSERT INTO sil_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ŋii nɛ nialiŋ ku-kaanaa fa si hɔnɔ didii kudiile-la bibiinɛ ba tuɔŋ lɛ a bul, “Kubɛɛ nɛ nia deeŋ si paala joŋ haachɛba chɛ niaa?” ");
INSERT INTO sil_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ama Yesu bula pi haal-la a bul, “Ŋ yarida nɛ laaŋ ta. Mu ari yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ŋii hariŋ Yesu gɔllɔ to ta-balaa ari ta-biisiŋ a bubul Wia wu-zɔmɔ-la a tigɛ Wia kuorii-la lɛ. U haritooro-la fii ari balia to u hariŋ mu, ");
INSERT INTO sil_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ari haalaa dɔŋsuŋ maa. Ba tuɔŋ dɔŋsuŋ faa wiilɛ nɛ, jiŋ-bɔŋŋɔɔ ma fa kɛŋ dɔŋsuŋ. Yesu vaarɛ ba kala. Ba tuɔŋ dɔŋɔ yiriŋ nɛ Mɛɛri Magidaliŋ. Yesu fa kiri jiŋ-bɔŋŋɔɔ balipɛ nɛ u lɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Dɔŋɔ ma yiriŋ nɛ Juana. U bala ma yiriŋ nɛ Kusa. Kusa fa ŋaa nihiaŋ nɛ kuoro Hɛrɔd dia lɛ. Haal-la ba síi yirɛ Suzana ma hɛ dimɛ a pɛ haalaa dɔŋsuŋ yugɛ ma lɛ. Ba pɛba lɛ ari kialiŋ kala Yesu ari u haritooroo síi chɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ŋii nɛ niaa lii tasiŋ a kukɔ Yesu teeŋ. Ni-daŋ-la si ku hilime dɛrɛ, Yesu magɛ namaga a piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Baal kubala nɛ sie a mu u du̱u u kiaa. U joŋ u ku-doho aa misɛ nɛ. U síi misɛ ŋii, dɔŋsuŋ tel woŋbiiŋ tuɔŋ. Niaa vɛnɛ nuɔsɛ, ka diibiisiŋ tuɔsa dii. ");
INSERT INTO sil_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dɔŋsuŋ ma tel kpaginyiliŋ nyuŋ a nyu aŋ suu, bɛɛ wiaa liiŋ tuo dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dɔŋsuŋ ma tuu tel sɔsuŋ tuɔŋ a nyu, ba di sɔsuŋ kala waa hɛ dɔŋɔ lɛ. Sɔsu-la wulimiŋ kɛŋ kialiŋ, ba suu. ");
INSERT INTO sil_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ku-doho-la dɔŋsuŋ ma tel tiŋtee-zɔmuŋ lɛ. Ba nyu a waa a wasɛ kiŋkɛŋ a hɛ biee zɔlɔ zɔlɔ.” Ŋii nɛ Yesu magɛ namaga-la dɛrɛ aŋ bul, “Digilaa tiŋŋaa, má wuoli ma digilaa nii.” ");
INSERT INTO sil_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ŋii nɛ Yesu haritooroo piɛsɛ namaga-la bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu bula piba a bul, “Ma niaa deeŋba nɛ Wia dagɛ u kuorii-la bubuɔŋ pa. Ama ni-daŋ kala, namagaba nɛ u yie kaa didagɛba. Ba yie jegili jegili aŋ bi ba bubuɔŋ jiŋ a bira nyilimi nyilimi aŋ bi kuŋ-kala ma wuo na. ");
INSERT INTO sil_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Namaga-la bubuɔŋ nɛ ŋla: Wia niiŋ wiaa nɛ ŋaa ku-doho-la. ");
INSERT INTO sil_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kialiŋ si tel woŋbiiŋ tuɔŋ nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ, ka Sitaani ku liiri wialiŋ ba tuɔŋ, di ba sí wialiŋ laa dii di Wia laaba ta. ");
INSERT INTO sil_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kialiŋ si tel kpaginyiliŋ nyuŋ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ a sɛi ari tuɔtɔruŋ. Ama u bi ba tuɔŋ tibe. Ba yie sɛi wii-la a mu magɛ ŋii aŋ via. Di wiaa nɛ juuba, ba joŋo ta. ");
INSERT INTO sil_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kialiŋ si tel sɔsuŋ tuɔŋ ma nɛ ŋaa nialiŋ si yie nii Wia niiŋ wialiŋ, ama dunia kiaa wiaa wiwalimɛba, ba cho di ba jigi a chichɛ dunia tuɔtɔrɛ wu-ŋaalaa. A tiŋ kiaa deeŋba wiaa ba yie to mu magɛ ŋii aŋ bira via wialiŋ. Wialiŋ lɛl ba tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kialiŋ si tel tiŋtee-zɔmuŋ tuɔŋ ma nɛ ŋaa nialiŋ si nii Wia niiŋ wialiŋ a laaba hɛ ba tuɔsaa lɛ a tutoba, a pɛsɛ wialiŋ lɛ halii, ba kɛŋ doho.” ");
INSERT INTO sil_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ŋii nɛ Yesu bira dagɛ niaa a bul, “Nuu-kala síi chɛ pulumuŋ u dia lɛ, u bi jaŋ nyigɛ chaaniŋ bil u dia lɛ a kɛŋ gbaŋa a chu tɔ, u bira bi jaŋ joŋ chaaŋ-la hɛ godo bubuɔŋ maa. U yie joŋo bil kua nyuŋ nɛ di niaa nɛ kuu juu u dia, di ba na pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wu-faali tuo see duu ku lii di-jaliŋ. Wii-kala si hɛ birimiŋ tuɔŋ ma jaŋ ku lii pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Má fiɛlɛ ma siaa woruŋ ari wialiŋ ma síi nii lɛ. Nii-la kala síi to Wia niiŋ wiaa, Wia jaŋ faasa pɛu lɛ duu to woruŋ. Nii-la ma si bi Wia niiŋ wiaa ka to, Wia bi jaŋ pɛu lɛ. U si pɛu lɛ mua-la maa, u jaŋ laau kaa viiri.” ");
INSERT INTO sil_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ŋii nɛ Yesu naaŋ ari u ŋaanaa kɔ lee-la Yesu si hɛ di ba nau. Niaa si yuga ŋii, ba buu wuo na. ");
INSERT INTO sil_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ŋii nɛ nuu bula pi Yesu a bul, “Ŋ naaŋ ari ŋ ŋaanaa nɛ chiŋ jeeŋ hariŋ a chichɛ di ba naŋ.” ");
INSERT INTO sil_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ŋii nɛ Yesu bula pi ba kala a bul, “Nialiŋ si nii Wia niiŋ wiaa a tutoba, ba nɛ ŋaa mi naaŋ ari mi naaŋbiiriŋ.” ");
INSERT INTO sil_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tapulii kubala Yesu ari u haritooroo sii juu liiŋ daboro. Ŋii nɛ Yesu bul di ba chol muga cholo dɔŋɔ. Ŋii nɛ ba juu liiŋ daboro-la a duoro mu. ");
INSERT INTO sil_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba fa si duoro mu ŋii, Yesu piŋ doŋ. Ŋii nɛ pel-duo kubala suomo ŋiŋaa, a ku ŋmoo liiŋ a hɛ liiŋ daboro-la tuɔŋ u chichɛ u su̱. U fa ka mua di ba tuu liiŋ bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŋii nɛ Yesu haritooro-la mu lee-la u fa si pina, a chisu a bula pu a bul, “La kuhiaŋ, laa chɛ di la suu nɛ.” Ŋii nɛ Yesu sii doŋ lɛ a kpia pel-la lɛ aŋ bul lii-pel-la ma lɛ duu fiɛla piŋ. Pel-la kɛrɛ, ka leriŋ kala ŋaa fuii. ");
INSERT INTO sil_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ŋii nɛ Yesu piɛsɛ u haritooroo a bul, “Ma bi yarida ŋaa?” U ŋaa nuu-kala wu-kpuŋkpere. Fawulluŋ ma kɛŋba. Ŋii nɛ ba pipiɛsɛ dɔŋɔ a bul, “Kubɛɛ nɛ saa paala ŋaa nia deeŋ? U bul wiaa a pi peliŋ ari lii-peliŋ, ba kala to u niiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ŋii nɛ ba duoro kɔ Gɛrasiŋ tiŋteeŋ. Gɛrasiŋ ari Galilii tiŋteeŋ kpagɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ba si mu yi lee-la, Yesu lii liiŋ niiŋ. U si lia, di baal kubala ma lii taŋ-la a ku chemu. Jiŋ-bɔŋŋɔɔ kɛnu. U kɛŋ yaribiree nɛ aa gɔllɛ a dieni. U bi dia maa juu. Vaamaa leriŋ nɛ u yie hɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","U si na Yesu, u ŋmoo niiŋ aŋ tuu tel u sipaaŋ, aŋ bula pu a bul, “Yesu, Wii-baliŋ Bie, bɛɛ nɛ ŋ chɛ ŋ ŋaami lɛ? Mii suluŋ, sí mi dɔgisu.” ");
INSERT INTO sil_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu fa bula pi jiŋ-bɔŋ-la duu lii baal-la lɛ, ŋii nɛ tii u bul ŋii. Jiŋsi-la fa vɛnɛ kɛnu a yugɛ nɛ. Niaa kɛnu kaa tɔ dia a hɛu kuruŋ a kɛŋ chɔrumɔɔ vɔbu aŋ hɛ niaa ba bibenu. U yie kɛŋ chɔrumɔ-la kaa kɛrɛ, ka jiŋsi-la kɛnu kaa lii juu giriŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ŋii nɛ Yesu piɛsu a bul, “Ŋ yiriŋ nɛ bɛɛ?” Ŋii nɛ baal-la bul duu yiriŋ nɛ ku-kɛnɛ, bɛɛ wiaa jiŋsiŋ fa yuga nɛ a kɛnu. ");
INSERT INTO sil_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ŋii nɛ jiŋsi-la sul Yesu di ba nɛ leŋ baal-la, duu sí leŋe di ba tuu buɔtuo-luŋuŋ. ");
INSERT INTO sil_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Di toonuŋ ma hɛ lee-la a yugɛ a didii kiaa peeliŋ nyuŋ. Ŋii nɛ jiŋsi-la sul Yesu duu leŋ di ba mu juu toonu-la. U sɛi. ");
INSERT INTO sil_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba lii baal-la lɛ a mu juu toonu-la. Ŋii nɛ toonu-la kala sii a fá lii peel-la nyuŋ a tuu tel muga tuɔŋ a nyua liiŋ a suu. ");
INSERT INTO sil_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Too-daara-la si na wii-la si ŋaa, ba fá mu a kɛŋ doworo mu bula pi bagi-daaraa ari taŋ-la niaa kala. ");
INSERT INTO sil_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Niaa sii lii mu di ba na wii-la si ŋaa a kɔ Yesu teeŋ. Baa kɔ di baal-la Yesu si kiri jiŋsiŋ u lɛ, duu hɔŋ Yesu sɛmɛ a laalɛ gɛriŋ a kɛŋ yarifiɛlaa. Ba si na ŋii, fawulluŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nialiŋ si hɛ dimɛ aa beŋ, ka Yesu vaarɛ baal-la, ba bula pi ba dɔŋsuŋ tiŋŋaa ŋii u si ŋaa a vaarɛ baal-la. ");
INSERT INTO sil_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba si nii wialiŋ, fawulluŋ kɛŋba woruŋ. Ŋii nɛ taŋ-la niaa kala ku bula pi Yesu duu lii ba jaŋ lɛ. Ŋii nɛ Yesu sii juu liiŋ daboro. Ba di u haritooroo duoro viiri. ");
INSERT INTO sil_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋii nɛ baal-la Yesu si kiri jiŋ-bɔŋŋɔɔ u lɛ ma sulu duu leŋ duu kɔ di ba mu. U bi sɛyɛ aŋ bula pu a bul, ");
INSERT INTO sil_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mu dia a bula pi ŋ dia niaa, Wia si ŋaa wii-la ŋ lɛ.” Ŋii nɛ baal-la gɔllɛ jaŋ tuɔŋ kala a bul wii-la Yesu si ŋaau lɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ŋii nɛ Yesu miira mu juu liiŋ daboro a duoro chol muga. Ba cholo ŋii di ni-daŋ hilime a hɔnɔ gbɛru. ");
INSERT INTO sil_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Di baal kubala ma kɔ dimɛ. Baa yirɛ Jaaris. U fa ŋaa Wii-chuɔlɛ dia kuhiaŋ nɛ. U fa kɛŋ toli-bala nɛ. Tolo-la fa yi jisiŋ fii ari balia nɛ. Ŋii nɛ baal-la kɔ Yesu teeŋ a tuu tel u naasiŋ lɛ a sulu duu kɔ u dia. U bula pu ari u tolo nɛ pina kikiiki. Ŋii nɛ Yesu sii duu mu baal-la dia. U síi mu ŋii, di niaa gollu chu sɛmɛ-na kala. ");
INSERT INTO sil_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Haal kubala ma fa hɛ ba tuɔŋ. U fa kɛŋ tiŋa nɛ jisiŋ fii ari balia, u pɔ u bi dɛrɛ. U gɔllɔ ŋaa daalusuŋ kiŋkɛŋ a chei u moribiee kala, ka daalusu-la buu laa. ");
INSERT INTO sil_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ŋii nɛ u lugisi nialiŋ tuɔŋ a ku chiŋ Yesu hariŋ a digi u gɛriŋ niipiniŋ lɛ. U tiŋa-la guu dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ŋii nɛ Yesu piɛsɛ a bul di kubɛɛ nɛ digu. Nuu-kala bul duu-na dee. Ŋii nɛ Piita bula pi Yesu a bul, “Kuhiaŋ, ka ŋ na niaa si yuga ŋii nɛ a golluŋ chu a yiyigi dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama Yesu ha bul di nuu nɛ digu. U jima ari doluŋ nɛ liiu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Haal-la si na ari wii-la u si ŋaa bi wu-faali ŋaa, u ku kpirimi Yesu sipaaŋ a chichel, a bul nialiŋ tuɔŋ wii-la si tii u digu, a dagɛ ŋii u si digu a duori lima. ");
INSERT INTO sil_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ŋii nɛ Yesu bula pu a bul, “Mi tolo, ŋ yarida nɛ tii ŋ duori, mu ari yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu fa síi bul wiaa ŋii, di tiŋdaara kɔ. U lii Jaaris dia nɛ a kɔ. U si kɔ, u bula pi Jaaris a bul, “Ŋ tolo-la suba nɛ, bira sí la kuhiaŋ-la walimu.” ");
INSERT INTO sil_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu síi nii ŋii, u bula pi Jaaris a bul, “Sí leŋe di fawulluŋ kɛniŋ. Di ŋ ŋaa yarida, u jaŋ sii.” ");
INSERT INTO sil_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu si mu yi baal-la dia, u bi leŋe di nuu-kala to u hariŋ juu dia-la, see Piita ari Jɔɔŋ ari Jeems, a pɛ bile nyimma ari u naaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ba ku juu dia-la di nialiŋ kala si hɛ dimɛ china yel bile yoho. Ŋii nɛ Yesu bula piba a bul, “Ma sí yel, bile bi suba, doŋ nɛ u piŋ.” ");
INSERT INTO sil_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ŋii nɛ ba kala mɔmu, bɛɛ wiaa ba jima ari u suba nɛ. ");
INSERT INTO sil_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ŋii nɛ Yesu guu mu kɛŋ bile nisiŋ lɛ aŋ yiru a bul, “Sii mi bii.” ");
INSERT INTO sil_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ŋii nɛ u dima miira ku juu. U sii lima lima. Ŋii nɛ u bul di ba ŋaa kudiilee pu duu dii. ");
INSERT INTO sil_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wii-la ŋaa bile nyimma ari u naaŋ wu-kpuŋkpere. Ŋii nɛ Yesu bula piba di ba sí wiiŋ deeŋ si ŋaa bula pi nuu-kala. ");
INSERT INTO sil_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ŋii nɛ Yesu yirɛ u haritooroo fii ari balia a hɛ dɔŋɔ lɛ, a piba doluŋ di ba wuo jiŋ-bɔŋŋɔɔ aŋ vivaarɛ nyanyal tiŋŋaa maa. ");
INSERT INTO sil_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ŋii nɛ u tiŋba di ba lii a bul Wia kuorii-la wiaa aŋ pɛ vaarɛ nyanyal tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","U bula piba di ba sí kuŋ-kala kaa pɛ vɛŋ woŋbii-la, di ba sí daaŋtigisiŋ koru, di ba sí luɔgaba ma koru, di ba sí kudiilee ma koru, di ba sí moribiee ma koru, a sí gɛnniŋ balia ma paa. ");
INSERT INTO sil_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","U bira bula piba a bul, “Di ma nɛ mu a juu taŋ kala, má juu dia-la niaa si cho ma wiaa, a hɛ dii-bala lɛ halii a mu lii taŋ-la lɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Di ma mu taŋ kala, di ba pɔ di ma sí juu, má kiele mu. Di ma mua, má kpesi ma naasiŋ hagila ta. Ŋii jaŋ ŋaa di ba jiŋ ari ba ŋaa wii nɛ a cheima.” ");
INSERT INTO sil_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ŋii nɛ Yesu haritooro-la sii a gɔllɔ to tasiŋ aa bul Wia wu-zɔmɔ-la wiaa aŋ pɛ vaarɛ niaa lee-na kala ba si mua. ");
INSERT INTO sil_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilii tiŋŋaa kuoro Hɛrɔd si nii wialiŋ Yesu haritooro-la fa si gɔllɔ ŋaa, u tuɔŋ kala vugima, bɛɛ wiaa niaa dɔŋsuŋ bula ari Jɔɔŋ Wia lii-foori-la nɛ sii suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Niaa dɔŋsuŋ ma si Ilaaja nɛ sii suuŋ lɛ, dɔŋsuŋ ma si nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ faafaa dɔŋɔ nɛ sii suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ŋii nɛ Hɛrɔd bul, “Mi ŋaa ba kpu Jɔɔŋ a keri u nyuŋ nɛ, ka kubɛɛ wiaa nɛ saa mi biraa nii ŋla?” Ŋii nɛ u ninɛrikɛ duu na Yesu. ");
INSERT INTO sil_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ŋii nɛ Yesu naŋzɔɔba-la miira kɔ u teeŋ a bul wialiŋ kala ba si ŋaa pu. Ŋii nɛ u kɛŋ ba duŋduŋa mu taŋ kubala baa yirɛ Bɛtisaada. ");
INSERT INTO sil_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nialiŋ si nii Yesu wiaa duu mu Bɛtisaada, ba to u hariŋ mu. U kɛŋba woruŋ a bul Wia kuorii-la wiaa piba, aŋ vaarɛ nialiŋ síi wiilu. ");
INSERT INTO sil_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wia si suomo duu juu, u haritooro-la fii ari balia-la kɔ u teeŋ a bula pu a bul, “Leŋ di niaa deeŋba viiri a mu taŋ tuɔŋ ari bagisiŋ si kpaga daha a chɛ kudiilee ari di-piniŋ, bɛɛ wiaa kuŋ-kala tuo daha.” ");
INSERT INTO sil_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ŋii nɛ Yesu bula piba a bul, “Má mu chɛ kudiilee a piba di ba dii.” Ŋii nɛ ba bula pu a bul, “Ku-la la si kɛnɛ nɛ boroboroba banɔŋ ari cheŋfilee balia. Ŋŋ chɛ di la mu yɔɔ kudiilee kaa kɔ pi ni-daŋ deeŋ kala nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Baalaa fa si hɛ nialiŋ tuɔŋ yi bui banɔŋ nɛ. Ŋii nɛ Yesu bula pi u haritooroo a bul, “Má leŋ di nialiŋ gulimo hɔŋ hɔŋ mahiŋ balia ari fii fii leree.” ");
INSERT INTO sil_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ŋii nɛ u haritooro-la ŋaa nialiŋ kala tuu hɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu laa boroboroba banɔŋ-la ari cheŋfilee balia-la a wula beŋ wia nyuŋ aŋ chuɔlɛ Wia, aŋ kaa chɔgɛ chɔgɛ a pi u haritooroo. Ba laa kaa mu kpaa nialiŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba kala dii a vɔgɛ aŋ ka. U haritooro-la paa ku-kaaŋ-biisiŋ a su̱ siŋsiŋ fii ari balia. ");
INSERT INTO sil_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tapulii kubala Yesu duŋduŋa chuchuɔlɛ Wia. U haritooroo ma hɛ u teeŋ. Ŋii nɛ u piɛsɛba a bul, “Kubɛɛ nɛ niaa si mi ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ŋii nɛ u haritooro-la bul, “Dɔŋsuŋ si ŋ ŋaa Jɔɔŋ nɛ, Wia lii-foori-la. Dɔŋsuŋ ma si di ŋ ŋaa Ilaaja nɛ. Dɔŋsuŋ ma si ŋ ŋaa nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ faafaa dɔŋɔ nɛ si sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ŋii nɛ Yesu miira piɛsɛ u haritooroo maa a bul, “Ka ma maa, ma si mi ŋaa kubɛɛ nɛ?” Piita si, “Ŋ nɛ ŋaa Kirisito, nii-la Wia si liisa.” ");
INSERT INTO sil_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ŋii nɛ Yesu bula piba ari siifiɛsiŋ di ba pɔ di ba sí wii-la bula pi nuu-kala. ");
INSERT INTO sil_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","U bira bula piba a bul, “Mi-na Nuhuobiine Bie jaŋ na hɛɛŋ kiŋkɛŋ. Ju̱u tiŋŋaa nihiasiŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba kala jaŋ viami. Ba jaŋ kpumi, ka di mi sii suuŋ lɛ tapul-torimuŋ chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ŋii nɛ u bula pi nialiŋ kala a bul, “Di nuu-kala níi chɛ duu tomi, see duu via u titia woŋbiiŋ aŋ joŋ u daa-gɛsɛɛ baasɛ tapulii-na kala a to mi hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nii-la kala síi chɛ duu laa u miisiŋ, u jaŋ joŋ u miisiŋ ta, ama nii-la si via u miisiŋ ta a tiŋ mi wiaa, u jaŋ sɛnɛ laa u miisiŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Di ŋ nɛ tii dunia kala aŋ bi miisiŋ kɛnɛ, bɛɛ kuŋ nyuurii nɛ ŋ na? ");
INSERT INTO sil_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mi-na Nuhuobiine Bie jaŋ mu Wia-jaŋ aŋ miira kɔ, a chaanɛ ari mi Nyimma si chaanɛ ŋii. Wia tiŋdaaraa ma jaŋ to mi hariŋ kɔ a ma chaanɛ. Ba-na bi disiŋ kɛnɛ. Nialiŋ hiisiŋ si kɛnɛ a tiŋ mi wiaa ari wialiŋ mi si bula wiaa, mi ma jaŋ fába hiisiŋ bua-la lɛ mi si jaŋ miira kɔ. ");
INSERT INTO sil_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wutitii nɛ mi bulaa pima, niaa dɔŋsuŋ hɛ daha, ba bi jaŋ suu see di Wia kuorii-la kɔ.” ");
INSERT INTO sil_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu si bul wiaa deeŋba kala dɛrɛ, u tapulaa chori chɛɛŋ nɛ u sii jil peeliŋ nyuŋ duu chuɔlɛ Wia. U kɛŋ Piita ari Jɔɔŋ ari Jeems ba jil. ");
INSERT INTO sil_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","U fa síi chuɔlɛ Wia ŋii, u siaa birimɛ. U gɛriŋ ma pullɛ a tutul. ");
INSERT INTO sil_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Niaa balia guu kɔ u teeŋ a kalaa tul. Moosis ari Ilaaja nɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ba chiŋ aa bul wiaa. Baa bul ŋii Yesu si jaŋ suu Jerusalɛm lɛ. U tiŋtiŋŋaa didɛriŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piita ari u naŋdɔŋsuŋ fa piŋ doŋ nɛ, ama ba hirike sii a na Yesu síi tul ŋii, a na nialiŋ balia ma si chiŋ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ŋii nɛ nialiŋ ta Yesu aŋ viviiri. Ba si viire ŋii, Piita bula pu, “Kuhiaŋ, u ŋaa wu-zɔŋ nɛ la si hɛ daha. La jaŋ hɛ lɛŋŋɛɛ batori, di ŋ kɛŋ dɔŋɔ, di Moosis ma kɛŋ dɔŋɔ, di Ilaaja ma kɛŋ dɔŋɔ.” U síi bul wiaa deeŋba kala, u fa paala bi jiŋ wii-la kala u síi bul. ");
INSERT INTO sil_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piita ha síi bul wiaa ŋii, duoŋbiliŋbaaniŋ ku tuu tɔba. U si tɔba ŋii, fawulluŋ kɛŋ Yesu haritooro-la. ");
INSERT INTO sil_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka nuu yiikoro lii duoŋbiliŋbaaŋ-la tuɔŋ aa bul, “Mi Bie nɛ ŋla. U nɛ ŋaa nii-la mi si liisa. Má jegile nii u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yiikori-la si bul wiaa dɛrɛ, u-na Yesu duŋduŋa nɛ hɛ dimɛ. Ŋii nɛ u haritooro-la tɔrɛ ba niiŋ. Ba bi wii-la ba si na bula pi nuu-kala. ");
INSERT INTO sil_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","U taŋ si pula, ba lii peel-la nyuŋ tuu, ŋii nɛ ni-daŋ ku cheŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Di baal kubala lii ni-daŋ-la tuɔŋ a faasa yirɛ, “La kuhiaŋ, bee na mii suluŋ di ŋ pɛ mi bie lɛ. U nɛ mi bie kala. ");
INSERT INTO sil_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jiŋ-bɔmuŋ nɛ kɛnu, u chichiirɛ a teriki. Naŋtuɔ-fuŋfuga yie tɔ u niiŋ. Uu walimu a pɔ u buu ka leŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi mu sul ŋ haritooroo di ba kiri jiŋ-bɔŋ-la u lɛ, ama ba bi wuo kiri.” ");
INSERT INTO sil_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ŋii nɛ Yesu bula piba a bul, “Ma lɛɛlɛ niaa deeŋba, ma bi yarida kɛnɛ. Ma ŋaa ni-bɔmɔ nɛ. Ɛɛ nɛ mi jaŋ nyalimɛ a dieni ma teeŋ?” Ŋii nɛ u bula pi baal-la a bul, “Kɛŋ ŋ bile kaa kɔ mi teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ŋii nɛ bile sii mu. Bile síi mu ŋii, ŋii nɛ jiŋ-bɔŋ-la ŋmobu lo tiŋteeŋ u teriki. Ŋii nɛ Yesu bul jiŋ-bɔŋ-la lɛ duu lii bile lɛ. U lii, ka bile duori, aŋ ka Yesu joŋu pi u nyimma. ");
INSERT INTO sil_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","U ŋaa nialiŋ kala wu-kpuŋkpere. Ba si di Wia kɛŋ doluŋ woruŋ. Nialiŋ kala haa biinɛ wu-kpuŋkperisi-la Yesu si ŋaa lɛ. Ŋii nɛ u bula pi u haritooro-la a bul, ");
INSERT INTO sil_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ma sí wii-la mi si jaŋ bula pima yu. U nɛ ŋla: Ba jaŋ joŋ mi-na, Nuhuobiine Bie a hɛ niaa nisiŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama u haritooro-la bi wii-la u si bula bubuɔŋ jiŋ. U ŋaa wu-faali nɛ ba teeŋ. Ŋii nɛ tii ba bi u bubuɔŋ wuo jiŋ. Ama ba fifá fawulluŋ di ba piɛsɛ wii-la bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ŋii nɛ Yesu haritooroo kɛŋ ba tuɔŋ kuhiaŋ wiaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu fa jiŋ wii-la ba síi biinu a kɛŋ bii-bie kaa kɔ kii u sɛmɛ, ");
INSERT INTO sil_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aŋ bula piba a bul, “Di nuu-kala nɛ kɛŋ bii-bie dɔŋɔ woruŋ a tiŋ mi wiaa, mi nɛ u kɛŋ woruŋ ŋii. Nii-la ma kala si kɛŋmi woruŋ, mi duŋduŋa dee u kɛŋ woruŋ ŋii. Nii-la si tiŋmi ma nɛ u kɛŋ woruŋ ŋii. Nii-la si ŋaa ni-bie ma tuɔŋ, u nɛ ŋaa ma tuɔŋ kuhiaŋ.” ");
INSERT INTO sil_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ŋii nɛ Jɔɔŋ bula pi Yesu a bul, “Kuhiaŋ, la na baal kubala duu yirɛ ŋ yiriŋ aa kiri jiŋ-bɔŋŋɔɔ niaa lɛ. La kiru duu sí ŋii ŋaa, bɛɛ wiaa u bi la dɔŋɔ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ŋii nɛ Yesu bula pi Jɔɔŋ ari u haritooroo ku-kaanaa a bul, “Ma síu kiru, bɛɛ wiaa nii-la kala si bi ma hariŋ lia, u ŋaa ma dɔŋɔ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ŋii nɛ tapulii-la kpagɛ di ba joŋ Yesu a kaa jil Wia-jaŋ. U ŋaa siri a sii, a joŋ woŋbiiŋ a mumu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","U tiŋ tiŋdaaraa di ba laa u sipaaŋ a mu Samaria tiŋteeŋ ta-bie kubala, a chɛ leriŋ a bilu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka nialiŋ bi siri ŋaa di ba laau, bɛɛ wiaa ba jima duu mu Jerusalɛm nɛ. ");
INSERT INTO sil_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","U haritooroo Jeems ari Jɔɔŋ si na ŋii, ba piɛsɛ Yesu a bul, “La Tiina, ŋ jaŋ leŋ di la sul nyiniŋ duu lii wia nyuŋ ku tuu a diiba koo?” ");
INSERT INTO sil_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ŋii nɛ Yesu daasɛ hariŋ aŋ kpiaba lɛ a bul, “Ma bi jiŋ dima-la yiri Wia si joŋo pima. Mi-na Nuhuobiine Bie bi kɔ di mi kpu niaa, ama di mi laa niaa ta nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ŋii nɛ ka ba kiele mu taŋ dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba si lii joŋ ba woŋbiiŋ, baal kubala bula pi Yesu a bul, “Mi ŋaa siri di mi to ŋ hariŋ a mu lee-na kala ŋ síi mu.” ");
INSERT INTO sil_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ŋii nɛ Yesu bula pu a bul, “Jolluŋ kɛŋ buasuŋ nɛ a jujuu, diibiisiŋ ma kɛŋ dɛlliŋ nɛ a jujuu, ama mi-na Nuhuobiine Bie bi di-piniŋ kɛnɛ di mi pina wiesi.” ");
INSERT INTO sil_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ŋii nɛ u bula pi nuu dɔŋ maa a bul, “To mi hariŋ.” U bula pu a bul, “Mi Tiina, leŋ di mi laa sipaaŋ mu hugi mi nyimma.” ");
INSERT INTO sil_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ŋii nɛ Yesu bula pu a bul, “Leŋ di suunuŋ tiŋŋaa mu hugi ba suunuŋ, aŋ ka di ŋ ma mu bul Wia kuorii-la wiaa a pi niaa.” ");
INSERT INTO sil_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nuu ma dɔŋ bira bula pu a bul, “Mi Tiina, mi jaŋ to ŋ hariŋ, ama leŋ di mi mu ta mi dia niaa aŋ kɔ.” ");
INSERT INTO sil_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ŋii nɛ Yesu bula pu a bul, “Nuu-na kala si suomo duu pɛrɛ aŋ didaasɛ u hariŋ, u bi tiŋtimii kala kɛnɛ Wia kuorii-la lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yesu si bul wiaa deeŋba dɛrɛ, u liisɛ niaa mahiŋ batori ari fii a kɛŋba kaa kpaa balia balia, a tiŋba di ba laa sipaaŋ mu lee-kala u titia si jaŋ mu. ");
INSERT INTO sil_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","U bula piba a bul, “Kiaa yuga baga lɛ di ba ŋaa, ama tiŋtinnaa bi yugɛ di ba tiŋ. Má sul baga-la tiina duu hɛ niaa di ba tiŋ tiŋtimii-la. ");
INSERT INTO sil_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Má sii mu. Ma nagɛ pie-biisiŋ nɛ. Mii tiŋma di ma guoli guŋgurusuŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma sí moribiee koru, ma sí sulli-gbaŋsiŋ koru a sí nɛŋtɛŋŋɛɛ tuŋ bulia bulia ma koru a sí china chuɔlɛ niaa ma dieni woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Di ma nɛ mu juu dia kala, má laa sipaaŋ bula pi dia-la niaa a bul, ‘Dia deeŋ niaa jaŋ hɔŋ ari yarifiɛlaa.’ ");
INSERT INTO sil_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Di nuu nɛ hɛ dimɛ si cho yarifiɛla-la, má leŋ duu hɔŋ ari yarifiɛlaa ari ma si sul ŋii. Di nuu tuo dia-la lɛ a cho yarifiɛla-la, yarifiɛla-la ma si sula jaŋ miira kɔ ma teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Di ba nɛ pima di-piniŋ, má hɛ dii-bala lɛ halii aa dii kudiile-la ba si ŋaa pima aa nyua liiŋ ma dimɛ. Di tiŋtinna nɛ tima, u maga di ba ti̱mu nɛ. Ma sí gɔllɔ pipiŋ niaa diisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Di ma nɛ mu taŋ kala, di ba nɛ pima di-piniŋ, máa dii kialiŋ kala ba si ŋaa pima lee-la. ");
INSERT INTO sil_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Má vaarɛ nyanyal tiŋŋaa ma kala si hɛ taŋ-la lɛ aŋ bula piba a bul, ‘Wia kuorii-la ku kpagɛma nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama di ma nɛ mu taŋ kala, di ba nɛ bima di-piniŋ pa, má lii chiŋ woŋbiiŋ lɛ aŋ bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma taŋ-la hagila si mɛrɛ la naasiŋ lɛ, ba nɛ la kpesee hɛma lɛ ŋla. Ama u maga di ma jiŋ ari Wia kuorii-la ku kpagɛma nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi bulaa pima ari sariya chɛ-diiliŋ, Wia jaŋ dɔgisɛ taŋ-la niaa a kii bua-la lɛ u si dɔgisɛ Sɔdɔm niaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ŋii nɛ Yesu bula pi taŋ-la niaa si bi u wiaa laa dii a bul, “Ma Kɔraziŋ tiŋŋaa, ma jaŋ na hɛɛŋ. Bɛtisaada tiŋŋaa maa, ma ma jaŋ na hɛɛŋ. Wu-magila-la ba si ŋaa ma teeŋ, di ba nɛ fa ŋaaba Taya ari Saadɔŋ niaa teeŋ ŋla, ba fa bi jaŋ dieni aŋ hɔnɔ tɛllɛ tɛllɛ naasiŋ a ŋaa tuɔruŋ bubugɛ ba titia, a didagɛ ŋii ari ba birima lii ba haachɛba lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sariya chɛ-diiliŋ, Wia jaŋ dɔgisɛ Kɔraziŋ ari Bɛtisaada tiŋŋaa a kii Taya ari Saadɔŋ tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma-na Kapɛnam tiŋŋaa, ma nɛ paala chichɛ di ma kɛŋ ma titia a kaa jil Wia-jaŋ. Ama Wia jaŋ joŋma yuo ta di ma tuu juu Wia nyiniŋ.” ");
INSERT INTO sil_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ŋii nɛ aŋ ka u bira bula pi u haritooro-la a bul, “Nii-la kala si jegile nii ma teeŋ, u jegile nii mi ma teeŋ nɛ. Nuu-kala si viama, u viami ma nɛ. Nii-la kala ma si viami, u ma via nii-la si tiŋmi nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ŋii nɛ Yesu naŋzɔɔba-la mahiŋ batori ari fii-la miira kɔ Yesu teeŋ. Ba tuɔŋ tɔrɛ kiŋkɛŋ a bula pi Yesu a bul, “La Tiina, di la nɛ yirɛ ŋ yiriŋ, jiŋ-bɔŋŋɔɔ ma yie paala to la niiŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ŋii nɛ Yesu bula piba a bul, “Mi na Sitaani duu lii wia nyuŋ ku tuu tel a nagɛ duonuŋ síi ligisɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ŋii nɛ Yesu bira bula piba a bul, “Má jegile nii mi teeŋ. Mi pima doluŋ di ma wuo vivɛŋ diŋŋaa ari nuɔmaa tuɔŋ, ka ba bima wuo diŋ. Mi pima doluŋ di ma wuo Sitaani maa. U bi jaŋ wuo kɛŋma walimɛ. ");
INSERT INTO sil_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ama ma sí leŋe di ma tuɔŋ tɔrɛ ari jiŋ-bɔŋŋɔɔ síi to ma niiŋ lɛ, má miira leŋ di ma tuɔŋ tɔrɛ a tiŋ ba si ŋmuŋsɛ ma yiraa hɛ Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bua-la titia lɛ Yesu tuɔŋ tɔrɛ Wia Diŋ-zɔŋ-la doluŋ lɛ a bul, “Mi Nyimma, ŋ nɛ ŋaa wia nyuŋ ari tiŋteeŋ kala Tiina. Mii lɔlluŋ ari ŋ si kɛŋ wialiŋ ŋ si joŋo faa a dagɛ nialiŋ si bi wiaa jiŋ, aŋ bi joŋo dagɛ nialiŋ si kɛŋ wu-jimiŋ. Mi Nyimma, mii lɔlluŋ. Ŋ titia tuɔtɔruŋ lɛ nɛ ŋ ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ŋii nɛ u bira bul, “Mi Nyimma joŋ kuŋ-kala doluŋ nɛ pimi. Mi Nyimma duŋduŋa nɛ jiŋ ŋii mi si naga. Mi ma duŋduŋa nɛ jiŋ ŋii mi Nyimma ma si naga. Nuu-kala bira buu jiŋ, see nialiŋ duŋduŋa mi síi cho di mi dagɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋii nɛ Yesu miira daasɛ u haritooro-la aŋ bula piba ba duŋduŋa a bul, “Ma tuɔŋ tɔrɔ ari ma wuo nina wialiŋ kala ma síi na. ");
INSERT INTO sil_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mi jaŋ bula pima ari buŋbuŋ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ari faafaa kuoroo paala yuga a faa cho di ba na wialiŋ ma síi na aŋ bi wuo na, a ma faa cho di ba nii wialiŋ maa ma síi nii, aŋ ka ba bi wuo nii.” ");
INSERT INTO sil_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ŋii nɛ Wia teniŋ kerichi kubala kɔ a wiwalimɛ duu magisɛ Yesu a piɛsu a bul, “Kuhiaŋ, bɛɛ kuŋ nɛ mi jaŋ ŋaa a kɛŋ miisi-la si bi dɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ŋii nɛ Yesu piɛsu a bul, “Bɛɛ nɛ ba ŋmuŋsɛ Wia teniŋ tuɔŋ? Ɛɛ nɛ ŋ yie karimɛ?” ");
INSERT INTO sil_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŋii nɛ baal-la bula pu a bul, “Ba si di ŋ kɛŋ ŋ tuɔŋ kala ari ŋ kuŋ-kala ari ŋ tuɔbiinaa ma kala a cho ŋ Tiina Wia, a cho ŋ dɔŋɔ tiina maa ari ŋ si cho ŋ titia ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ŋii nɛ Yesu bula pu a bul, “Wialiŋ kala ŋ si bula ŋaa wutitii nɛ. Ŋ nɛ ŋaa ŋii, ŋ jaŋ kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋii nɛ Wia teniŋ kerichi-la chichɛ duu dagɛ ari u kɛŋ wutitii. Ŋii nɛ u piɛsɛ Yesu a bul, “Kubɛɛ nɛ ŋaa mi dɔŋɔ tiina?” ");
INSERT INTO sil_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ŋii nɛ Yesu magɛ namaga a bul, “Baal kubala nɛ sie a lii taŋ kubala baa yirɛ Jerusalɛm a mumu Jɛrikɔ. U fa ŋaa Ju̱u tiina nɛ. U si mu ŋii, u mu juu gaaraa tuɔŋ. Ba wuri u gɛnniŋ kala aŋ ŋmobu a bolimu aŋ fá lɛl, ka u piŋ dimɛ a chichɛ duu suu. ");
INSERT INTO sil_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ŋii nɛ di nialiŋ si kpu pusuŋ pipi Wia, ba tuɔŋ kubala ma joŋ woŋbii-la aa vɛŋ. U si ku a nau, u to sɛmɛ dɔŋ nɛ a kpɛrɛ bal. ");
INSERT INTO sil_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋii nɛ Wia-dia naŋzɔɔ kubala ma kɔ lee-la a ma kpɛrɛ bal. ");
INSERT INTO sil_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka Samaria tiŋŋaa baal kubala ma fa joŋ woŋbii-la a vɛnɛɛ kɔ. U si nau, nennige kɛnu. ");
INSERT INTO sil_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U mu u teeŋ a chɛsɛ u naawiilaa a vɔɔ, aŋ joŋu hɛ u titia kakumo lɛ a kɛnu kaa mu nuhuɔraa dia kubala aa benu. ");
INSERT INTO sil_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Taŋ-pul u joŋ siidi zɔlɔ a pi dia tiina aŋ bula pu duu bibeŋ u nyuŋ woruŋ. Duu nɛ miira kɔ, u jaŋ ti̱ŋ u si ŋmoo chimiŋ magɛ ŋii kala.” ");
INSERT INTO sil_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ŋii nɛ Yesu piɛsɛ Wia teniŋ kerichi-la a bul, “Niaa deeŋba batorimuŋ tuɔŋ, kubɛɛ nɛ ŋaa baal-la si juu gaaraa tuɔŋ dɔŋɔ tiina? Bɛɛ nɛ ŋ biinɛ ŋ tuɔŋ lɛ?” ");
INSERT INTO sil_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ŋii nɛ Wia teniŋ kerichi-la bul, “Baal-la si fáu nisusuŋ.” Ŋii nɛ Yesu bula pu, “Tɔɔ, ŋ ma mu ŋaa ŋii titia.” ");
INSERT INTO sil_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ari u haritooroo si joŋ woŋbiiŋ mumu ŋii, ba kɔ taŋ kubala, di haal kubala ma hɛ dimɛ. Baa yirɛ Maata. U kɛŋ Yesu kaa juu u dia. ");
INSERT INTO sil_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U ŋaana ma fa hɛ dimɛ. Baa yiru Mɛɛri. Yesu si hɔŋ dia-la tuɔŋ, u ku hɔŋ Yesu sɛmɛ a jegilee nii wialiŋ u síi bul, ");
INSERT INTO sil_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ka Maata fiɛsɛ sii a ŋiŋaa kudiilee duu pi Yesu a kala lɔl. Ŋii nɛ u na baaniŋ Mɛɛri nyuŋ a ku lii, a bula pi Yesu a bul, “Mi Tiina, ŋ biina u zɔmɔ nɛ mi ŋaana si leŋ tiŋtiŋŋaa kala pimi mi titiŋ? Leŋ duu ku pɛmi lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ŋii nɛ Yesu bula pu a bul, “Maata, wiaa yuga nɛ hɛ dimɛ a wiwalimiŋ. ");
INSERT INTO sil_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","U maga di ŋ chɛ wu-bala duŋduŋ nɛ. Wii-la titia nɛ Mɛɛri liisɛ ŋii. Wii-la ba bi jaŋ wuo kaa laa u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tapulii kubala Yesu sii a mu chuɔlɛ Wia lee kubala. U si chuɔlɛ Wia dɛrɛ, u haritooroo tuɔŋ kubala kɔ u teeŋ a bula pu a bul, “La Tiina, dagɛla ŋii la si jaŋ ŋaa a chuɔlɛ Wia, ari Jɔɔŋ fa si dagɛ u haritooroo ba si ŋaa ŋii aa chuɔlɛ Wia.” ");
INSERT INTO sil_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ŋii nɛ Yesu bula piba a bul, “Ŋla nɛ ma jaŋ chuchuɔlɛ Wia: Má bul, ‘La Nyimma Wia, leŋ di ŋ yiriŋ yirɛ, leŋ di ŋ kuorii-la kɔ. ");
INSERT INTO sil_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pila la niiŋ kudiiliŋ tapulii-na kala. ");
INSERT INTO sil_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Joŋ la haachɛba chɛla ari la ma si joŋ la dɔŋsuŋ tiŋŋaa haachɛba chɛba ŋii, a liisɛla wii-la si jaŋ kɛŋla hɛ haachɛ tuɔŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ŋii nɛ Yesu bula pi u haritooroo a bul, “Má leŋ di la joŋ ari ma kuŋ nɛ mu u naŋdɔŋɔ dia tita-siesee, a bula pu a bul, ‘Mi naŋdɔŋɔ, chiŋmi boroboro batori. ");
INSERT INTO sil_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mi naŋdɔŋɔ nɛ lii woŋbiiŋ a kɔ mi teeŋ titaŋiŋ deeŋ, ka mi bi kuŋ kɛnɛ di mi ŋaa pu duu dii.’ ");
INSERT INTO sil_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ŋ biina ari ŋ naŋdɔŋ-la nɛ hɛ dia tuɔŋ aŋ bula piŋ a bul, ‘Sí mi walimu, boiŋ yaga nɛ. Ka la di mi biiriŋ piŋ doŋ. Mi bi jaŋ wuo sii a piŋ kuŋ-kala.’ Ai, u bi jaŋ bul ŋii. ");
INSERT INTO sil_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bɛɛ nɛ u jaŋ ŋaa? Mi jaŋ bula pima, di ŋ nɛ china pɛsɛ, ma naŋdɔŋsuŋ wiaa dee u jaŋ sii doŋ lɛ a piŋ kudiile-la. Ama ŋ si pɛsɛ ŋii aŋ bi hiisiŋ fá nɛ tii u jaŋ sii a piŋ ku-la kala ŋ síi chɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ŋii wiaa mi jaŋ bula pima, Má sul kiaa, ma jaŋ laa, má chɛ kiaa, ma ma jaŋ na. Má du̱ boro, ba jaŋ kaa suro pima. ");
INSERT INTO sil_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nii-la kala si sul kiaa Wia teeŋ, u yie laa nɛ. Nii-la kala síi chɛ kiaa, u yie na nɛ. Nii-la ma kala si du̱ boro, ba yie kaa suro pu nɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nyiŋ bɛɛ nɛ ma tuɔŋ si jaŋ joŋ dimiŋ a pi u bie duu nɛ piɛsa chichɛ cheŋfiliŋ? ");
INSERT INTO sil_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Koo duu ka chɛ ji-haliŋ, ma tuɔŋ nyiŋ bɛɛ nɛ jaŋ joŋ nuɔmuŋ pi u bie? Ma tuɔŋ nuu-kala bi jaŋ ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ma nialiŋ ŋaa ni-bɔŋŋɔɔ nɛ, ka ma wuo joŋ ku-zɔŋŋɔɔ a pi ma biiriŋ. Ama mi Nyimma si hɛ Wia-jaŋ, u kɛŋ wu-zɔŋŋɔɔ a kiima, ŋii nɛ tii u bi jaŋ via duu joŋ u Diŋ-zɔŋ-la a pi nii-la si sulu chichɛ.” ");
INSERT INTO sil_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Baal kubala ma nɛ fa kɔ Yesu teeŋ. Jiŋ-bɔmuŋ kɛnu a ŋaa u taŋ. Ŋii nɛ Yesu ŋaa jiŋ-bɔŋ-la lii baal-la lɛ, ka baal-la wuo bubul wiaa. Ni-daŋ-la si hɛ dimɛ a na wii-la, u ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ŋii nɛ niaa dɔŋsuŋ ma si di jiŋ-bɔŋŋɔɔ kuoro ba síi yirɛ Bɛlizibul nɛ pu doluŋ duu kikiri jiŋ-bɔŋŋɔɔ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Niaa dɔŋsuŋ ma chichɛ di ba magisu. Ŋii nɛ ba si duu ŋaa wu-magiliŋ di ba na a jiŋ ari Wia doluŋ nɛ u kaa ŋiŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu wuo jiŋ ba tuɔbiinaa a bula piba a bul, “Di taŋ niaa nɛ hɛ dimɛ a bi nii-bala kɛnɛ, ba taŋ jaŋ tel. Di naaŋbiiriŋ ma nɛ bi nii-bala kɛnɛ, ba dia jaŋ tel. ");
INSERT INTO sil_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Di Sitaani niaa nɛ bi nii-bala kɛnɛ, ba taŋ bi jaŋ wuo chiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ŋii nɛ Yesu bira bula piba, “Ma bula ari Bɛlizibul nɛ pimi doluŋ mi kaa kiri jiŋ-bɔŋŋɔɔ niaa lɛ. Kubɛɛ nɛ saa joŋ doluŋ pi niaa deeŋba síi to ma hariŋ ba ma kikiri jiŋ-bɔŋŋɔɔ niaa lɛ? Niaa deeŋba titia daga ari maa nyia nɛ. Ba jima ari Sitaani bi u titia wuo guraa yuo. ");
INSERT INTO sil_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wia doluŋ nɛ mi kaa kiri jiŋ-bɔŋŋɔɔ niaa lɛ. Wiiŋ deeŋ nɛ daga ari Wia kuorii-la paala kɔ ma teeŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Di ni-duoŋ nɛ vɔɔ u tuɔnuŋ a hɔnɔ pɔ u dia, nuu-kala bi u dia kuŋ-kala wuo juu joŋ. ");
INSERT INTO sil_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama nii-la ma si kɛŋ doluŋ a kiiu duu wuo ku kɛŋ baal-la, aŋ kɛŋ u tuɔnuŋ kala u si kaa pɔ u kiaa a kaa laa u teeŋ, u jaŋ wuo paa u kialiŋ kala kaa viiri. ");
INSERT INTO sil_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nuu-kala si bi mi nuu ŋaa, u lii mi hariŋ nɛ. Nii-la ma kala si bi mi lɛ pɛ di la kiri kiaa hihɛ dɔŋɔ lɛ, u kaa pisa tita nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ŋii nɛ Yesu bira bula pi niaa a bul, “Di jiŋ-bɔŋ nɛ lii nuu lɛ, u yie gɔllɛ tiŋtee-hiliŋ lɛ a chichɛ di-wiesiŋ. Di u nɛ bi lee na, u yie bul u titia lɛ a bul, ‘Mi jaŋ miira mu lee-la mi si lia.’ ");
INSERT INTO sil_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","U jaŋ miira mumu, di disinniŋ tuo dia-la lɛ, ba wasa u kala zɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ŋii nɛ u jaŋ miira lii, a kɛŋ jiŋ-bɔŋŋɔɔ balipɛ, kialiŋ si bɔmɔ kiiu, ba ma ku juu a pɛu lɛ. Ŋii hariŋ lɛ nɛ baal-la yie kperi a kii buŋbuŋ-la.” ");
INSERT INTO sil_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu si bul ŋii dɛrɛ, di haal kubala hɛ ni-daŋ-la tuɔŋ a faasa bula pu a bul, “Wia jaŋ pɛ haal-la si luluŋ lɛ a diɛsiŋ ari yiliŋ. U jaŋ leŋ duu tuɔŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ŋii nɛ Yesu miira bula pu a bul, “Nii-la si nii Wia niiŋ wiaa a tutoba, u-na tiina tuɔŋ nɛ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nialiŋ si golli Yesu ŋii, u bula piba a bul, “Bee na, jiniŋ niaa deeŋba bɔmɔ nɛ. Ba si di mi ŋaa wu-magiliŋ di ba na a jiŋ ari mi dol-la lii Wia teeŋ nɛ. Ai, mi bi ŋaa. Wu-magiliŋ ma síi chɛ, ma bi jaŋ wuo na, see wu-magil-la Wia fa si ŋaa a tigɛ Jona lɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wia joŋ Jona a kɛnu ŋaa wu-magiliŋ Ninivɛ niaa teeŋ. Ŋii titia nɛ u jaŋ joŋ mi-na Nuhuobiine Bie ma a kɛŋmi ŋaa wu-magiliŋ jiniŋ niaa teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ŋii nɛ Yesu bira bul, “Haal kubala nɛ fa hɛ dimɛ. U dii kuoruŋ tiŋtee kubala lɛ baa yirɛ Siiba. U sii lii u jaŋ lɛ a mu di-bolii duu jegile nii kuoru kubala wu-jimiŋ. U yiriŋ nɛ fa Solomɔŋ. U fa kɛŋ wu-jimiŋ kiŋkɛŋ kiŋkɛŋ. Sariya chɛ-diiliŋ, haal-la jaŋ sii a joŋ cheeriŋ a pi jiniŋ niaa woruŋ. Mi jaŋ bula pima ari nuu nɛ hɛ dimɛ, u yuga a kii Solomɔŋ, ka ma bi sɛi di ma jegile nii u wiaa. ");
INSERT INTO sil_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sariya chɛ-diiliŋ, Ninivɛ niaa ma jaŋ sii a joŋ cheeriŋ a pima woruŋ. Bua-la lɛ Jona ma fa si mu bul Wia wiaa pi Ninivɛ niaa, ba birima lii ba haachɛba lɛ nɛ aŋ to Wia. Mi jaŋ bula pima ari nuu nɛ hɛ ma tuɔŋ a yuga kii Jona, ka ma bi sɛi di ma jegile nii u wiaa.” ");
INSERT INTO sil_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ŋii nɛ Yesu bira dagɛ niaa a bul, “Di ŋ nɛ nyigɛ chaaniŋ aa chɛ di pulumuŋ hɛ dia tuɔŋ, ŋ bi jaŋ kɛŋ kua kɛrɛ. Ŋ bira bi jaŋ joŋ gbaŋa ma a chu tɔ. Ŋ yie joŋo daŋ kuŋ nyuŋ nɛ, di nuu-kala nɛ ku juu ŋ dia, duu wuo na pulumuŋ a ku juu dia-la. ");
INSERT INTO sil_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ŋ siaa nɛ ŋaa ŋ yaraa pulumuŋ. Di ŋ siaa nɛ zɔmɔ, ŋ yaraa kala kɛŋ pulumuŋ nɛ, ama di ŋ siaa nɛ bi zɔŋ, ŋ yaraa kala hɛ birimiŋ tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Má pɔ di puluŋ-la ma si kɛnɛ sí birimiŋ birimu. ");
INSERT INTO sil_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Di ŋ yaraa kala nɛ kɛŋ pulumuŋ aŋ ka ŋ lee-kala bi birimiŋ kɛnɛ, u jaŋ chaanɛ lee-kala, ari chaaniŋ si yie chaanɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu si bul wiaa deeŋba dɛrɛ, Farisii tiina kubala yiru duu kɔ u dia a dii kudiilee. Ŋii nɛ Yesu mu hɔŋ duu dii kudiile-la. U bi liiŋ sɔmɔ aŋ didii kudiile-la. ");
INSERT INTO sil_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisii tiina-la si na ŋii, u ŋaau wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ŋii nɛ la Tiina Yesu bula pu a bul, “Ma-na Farisii tiŋŋaa, ma yie chɛsɛ ma gbaŋsiŋ ari ma nyunyualuŋ hariŋ woruŋ di ba zɔŋ aŋ bi ba tuɔŋ ka tiisi, ka ba tuɔŋ kala birisi. Ma nagɛ nyunyualuŋ ari gbaŋsiŋ deeŋba nɛ. Ma yaraa nɛ zɔmɔ, ama ma tuɔŋ lɛ ma kɛŋ yaribieriŋ ari tuɔ-bɔmuŋ. ");
INSERT INTO sil_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ma ŋaa ni-yaaraa nɛ. Wia-la si ŋaa ma hariŋ, u nɛ ŋaa ma tuɔŋ maa. ");
INSERT INTO sil_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Di ma níi chɛ di ma tuɔŋ pullɛ, má kɛŋ ma tuɔŋ a cho summoo a fifába nennige. ");
INSERT INTO sil_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ma Farisii tiŋŋaa, ma jaŋ na hɛɛŋ. Ku-biisiŋ, ma yie kaa kpaa leree fii fii, a joŋ leriŋ kubala a pi Wia. Di ma nɛ jaa pipaari-la suɔra si sima ari pipaari-la suɔra si bi siŋ ari pipaa-diilee maa, ma yie kɛŋba kaa kpaa leree fii fii, a joŋ ba kuŋ-kala leriŋ dɔŋɔ a pi Wia, ama ma via wutitii woŋbiiŋ a bi Wia cho. U maga di ma kpaa ma kialiŋ leree fii fii, a joŋ leriŋ kubala a pi Wia, ama u bi maga di ma via wutitii woŋbiiŋ. ");
INSERT INTO sil_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ma Farisii tiŋŋaa, ma jaŋ na hɛɛŋ. Di ma nɛ juu Wii-chuɔlɛ diisiŋ, ma yie cho ni-balaa di-hɔnuŋ nɛ. Di ma níi gɔllɛ yɔbɔ lɛ maa, ma yie cho di nuu-kala nɛ pima jirima a chuchuɔlɛma. ");
INSERT INTO sil_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ma jaŋ na hɛɛŋ kiŋkɛŋ kiŋkɛŋ. Ma nagɛ vaamaa ba si kaa jɛrɛ, di ba di tiŋteeŋ kala magɛ dɔŋɔ nɛ, ka niaa bi jiŋ aŋ vivɛŋ ba nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu si bul ŋii dɛrɛ, di Wia teniŋ kerichi dɔŋɔ bula pu a bul, “Kuhiaŋ, ŋ si bul ŋla, ŋ tuusɛla ma nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ŋii nɛ Yesu bira bul, “Ma-na Wia teniŋ kerichiba, ma jaŋ na hɛɛŋ. Ma yie joŋ chuga a daŋ niaa hariŋ lɛ, ka ba bi wuo chuŋ. Aŋ ka ma titia bi jaŋ pɛba lɛ a laa chuga-la. ");
INSERT INTO sil_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ma jaŋ na hɛɛŋ kiŋkɛŋ. Ma naabalimaba bi woruŋ ŋaa a kpu nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. Ma nɛ paala saa ba vaama-la. ");
INSERT INTO sil_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ma nɛ sɛi wialiŋ ma naabalimaba si ŋaa a bul di ba ŋaa wutitii nɛ. Ba kpu nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ma ma nɛ saa ba vaamaa. ");
INSERT INTO sil_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A tiŋ wiiŋ deeŋ wiaa, ba ŋmuŋsɛ Wia teniŋ sɛmɛ dɔŋɔ ba síi yirɛ Wia wu-jimiŋ a bul, ‘Mi jaŋ ta nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ari mi tiŋdaaraa di ba mu ba teeŋ. Ba jaŋ kpu dɔŋsuŋ aŋ to dɔŋsuŋ naasiŋ a dɔgisɛba.’ ");
INSERT INTO sil_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wia jaŋ dɔgisɛ jiniŋ niaa a tiŋ ba si kpu nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ a lii dunia di-suomuŋ, ");
INSERT INTO sil_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","a chiŋ bua-la lɛ ba si kpu Ebil a kaa mu yi bua-la lɛ ba si kpu Zakaraya. Ba kpuu Wia-dia tuɔŋ nɛ a kpagɛ koru-la nyuŋ ba si yie nyigɛ pusuŋ pipi Wia nɛ. Wutitii, mi jaŋ bula pima, Wia jaŋ dɔgisɛ jiniŋ niaa kala kiŋkɛŋ a tiŋ wiaa deeŋba kala lɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ma Wia teniŋ kerichiba, ma ma jaŋ na hɛɛŋ kiŋkɛŋ. Ma tɔ woŋbii-la nialiŋ síi to a yi lee-la ba si jaŋ na wu-jimiŋ nɛ. Ma titia bi chɛ di ma to woŋbiiŋ deeŋ, aŋ pɔ di nialiŋ ma síi walimɛ di ba to, di ba sí to.” ");
INSERT INTO sil_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu si lii lee-la, Wia teniŋ kerichiba-la ari Farisii tiŋŋa-la suomo bul wiaa a lilii u hariŋ a piɛsu wiaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Baa walimɛ di ba bɛrɛ kɛnu di u nɛ bul wii chei. ");
INSERT INTO sil_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nialiŋ fa si kɔ Yesu teeŋ, ba yi niaa bui bui bui a yiyigi dɔŋɔ. Ŋii nɛ Yesu laa sipaaŋ a bula pi u haritooroo a bul, “Má pɔ ma titia lɛ ari Farisii tiŋŋaa. Ba ŋaa kaŋfugi timma nɛ. Ba nagɛ si-buruŋ nɛ. Di ŋ nɛ joŋo hɛ kuŋ-kala lɛ, u yie puɔrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wii-kala si faa, u jaŋ ku lii pulumuŋ, niaa ma jaŋ nii wii-la si ŋaa wu-faali. ");
INSERT INTO sil_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wii-kala maa ŋ si bul birimiŋ tuɔŋ, ba jaŋ niiu pulumuŋ lɛ. Wii-kala bira ŋ si muŋso bul a hɛ nuu duŋduŋ digiliŋ lɛ dia tuɔŋ, ba jaŋ faasa heele bulu lusuŋ nyuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ŋii nɛ Yesu bira bul, “Mi naŋdɔŋsuŋ, mi jaŋ bula pima, ma sí nialiŋ si jaŋ wuo kpu ma yaraa lɛ fá. Ba bira bi jaŋ wuo ŋaa wu-bɔŋ kala ma lɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi jaŋ dagɛma nii-la si maga di ma fá. Má fá Wia. U nɛ jaŋ wuo kpuma aŋ bira kɛŋ doluŋ duu wuo joŋma hɛ Wia nyiniŋ tuɔŋ. Mi bulaa pima, ma fifáu. ");
INSERT INTO sil_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Zaarikokobiisiŋ banɔŋ dee ba yie joŋo yallɛ kɔbu balia koo? Ama Wia bi ba tuɔŋ kubala ma wiaa yua. ");
INSERT INTO sil_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wia paala jiŋ ma nyu-punaa kala ma niiŋ nɛ. Ŋii wiaa, ma sí leŋe di fawulluŋ kɛŋma. Ma nɛ paala kii zaarikokobiisiŋ a yugɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mi bulaa pima, nii-la kala si jaŋ wuo bul niaa tuɔŋ ari u ŋaa mi nuu nɛ, mi-na Nuhuobiine Bie ma jaŋ bul ŋii a tigɛu lɛ Wia tiŋdaaraa sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama nii-la kala si viami niaa tuɔŋ, mi-na Nuhuobiine Bie ma jaŋ viau Wia tiŋdaaraa sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nii-la kala si bul wu-bɔŋŋɔɔ a mu tigɛ mi-na Nuhuobiine Bie lɛ, Wia jaŋ joŋo chɛu, ama nii-la kala si tuusɛ Wia Diŋ-zɔŋ-la joŋŋoo, Wia bi jaŋ joŋo chɛ u tiina. ");
INSERT INTO sil_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Di ba nɛ kɛŋma kaa juu Wii-chuɔlɛ diisiŋ koo kuoroo ari kuhiasiŋ teeŋ di ba dii ma sariya, ma sí leŋe di ma bɔisiŋ joŋ ŋii ma si jaŋ ŋaa a laa ma titia, koo wii-na kala ma si jaŋ bul. ");
INSERT INTO sil_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bua-la titia lɛ Wia Diŋ-zɔŋ-la jaŋ dagɛma wii-la ma si jaŋ bul.” ");
INSERT INTO sil_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu fa si bul wiaa pipi ni-daŋ-la ŋii, baal kubala lii ba tuɔŋ a bula pu a bul, “Mi kuhiaŋ, la nyimma suba aŋ ka kiaa. Mii suluŋ di ŋ bula pi mi naaŋbie duu kaa kpaa pimi.” ");
INSERT INTO sil_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ŋii nɛ Yesu bula pu a bul, “Mi naŋdɔŋ, mi tiŋtimii dee di mi laa ma sariya dii pima koo di mi kɛŋ ma kiaa kaa kpaama.” ");
INSERT INTO sil_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ŋii nɛ u bira bula pi niaa a bul, “Má fiɛlɛ ma siaa a sí tuɔ-luŋuŋ kɛŋ. Di nuhuobiine nɛ kɛŋ kiaa kiŋkɛŋ, kialiŋ bi jaŋ wuo leŋ duu kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ŋii nɛ Yesu bira magɛ namaga a bul, “Baal kubala nɛ fa hɛ dimɛ a kɛŋ kiaa woruŋ a bil u baga. U baga-la kiaa wasɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ŋii nɛ u bibiinɛ u tuɔŋ lɛ a bul, ‘Ɛɛ nɛ mi jaŋ ŋaa? Mi bira bi leriŋ kɛnɛ di mi tuɔlɛ mi kiaa.’ ");
INSERT INTO sil_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ŋii nɛ u bul, ‘Mi jaŋ ŋmoo mi virisiŋ deeŋba mi si kɛnɛ a ta aŋ wasa saa ku-balaa. Mi jaŋ joŋ mi kuorimiaa ari mi kiaa kala a tuɔlɛ dimɛ ");
INSERT INTO sil_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aŋ bula pi mi titia a bul, Mi tuɔlɛ kiaa yugɛ nɛ. Mi jaŋ dii jisi ari jisi. Mi-na jaŋ ta jia a dii kiaa ari tuɔtɔruŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ŋii nɛ Wia bula pu, ‘Ni-yaari, titaŋiŋ deeŋ mi jaŋ leŋ di ŋ suu. Kialiŋ saa ŋ si chɛ bil, kubɛɛ nɛ jaŋ dii?’ ” ");
INSERT INTO sil_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ŋii nɛ Yesu bula pi niaa a bul, “Nii-la kala si yie chɛ kiaa bil u titia lɛ aŋ bi kuoru ŋaa Wia teeŋ, u nagɛ baala deeŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ŋii wiaa Yesu bula pi u haritooroo a bul, “Mi bulaa pima, ma sí ma titia walimu a tigɛ kudiile-la ma si jaŋ dii a kɛŋ doluŋ, koo ma sí ma titia ma walimu a tigɛ gɛnni-la lɛ ma síi chɛ di ma lilaalɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma miisiŋ nɛ kii kudiilee, ma yaraa ma kii gɛnniŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Má bee na diibiisiŋ, ba bi pɛrɛ, ba bi kiaa ka tuɔlɛ virisiŋ lɛ, ka Wia pipiba kudiilee. Ma nɛ paala kɛŋ nyuuruŋ a kii diibiisiŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Di ma níi walimɛ ma titia kiaa deeŋba wiaa, bua-la lɛ ma miisiŋ si jaŋ dɛrɛ, u bi jaŋ kɛŋ tapul-bala ma pɛ pima. ");
INSERT INTO sil_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Di ma nɛ saa bi tapul-bala ma wuo kaa pɛ ma miisiŋ lɛ tapulii-la ma ma si jaŋ suu, bɛɛ nɛ saa tii kiaa deeŋba wiaa wiwalimɛma? ");
INSERT INTO sil_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Má bee na tii-fiilaa. Ba bi tiŋ, ba bi gɛnniŋ ma yɛrɛ a lilaalɛ, ama ba zɔmɔ woruŋ. Kuoru kubala nɛ fa hɛ dimɛ. Baa yirɛ Solomɔŋ. U fa si hɛ u miisiŋ lɛ, u kɛŋ kiaa nɛ woruŋ. Ama u gɛnniŋ fa bi zɔmɔ magɛ tii-fiilaa deeŋba. ");
INSERT INTO sil_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wia nɛ yie ŋaa yaŋ nyu a waa a zɔŋ, ka u bi dieni aŋ hil. Di u nɛ hila, ba yie nyigɛ nyiniŋ. Di Wia nɛ wuo ŋaa yaŋ zɔŋ ŋii, bɛɛ nɛ tii ma bibiinɛ ari u bi jaŋ wuo pima kudiilee ari gɛnniŋ? Ma yarida bi yugɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma sí leŋe di ma walimɛ ma titia kudiile-la ma si jaŋ dii ari ku-la ma si jaŋ nyua wiaa. ");
INSERT INTO sil_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nialiŋ si bi Wia jiŋ dunia deeŋ lɛ, ba nɛ yie walima chichɛ kiaa deeŋba. Ma Nyimma jima ari ma chɛ kiaa deeŋba nɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ŋii wiaa, má laa sipaaŋ a chɛ kialiŋ si hɛ Wia kuorii-la tuɔŋ. U jaŋ joŋ kuŋ-kala si ka a pɛ pima.” ");
INSERT INTO sil_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ŋii nɛ Yesu bira bul, “Ma nialiŋ síi tomi, ma bi yugɛ. Ma sí leŋe di fawulluŋ kɛŋma. Ma Nyimma tuɔŋ tɔrɛ nɛ duu joŋ kuorii-la pima. ");
INSERT INTO sil_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Má joŋ ma kiaa kala yallɛ a joŋ moribie-la a pi summoo. Má chɛ kialiŋ si bi chei a bil ma titia lɛ, a joŋ ma kiaa bil Wia-jaŋ lɛ. Dimɛ ba bi jaŋ dɛrɛ, gaaru kala bi jaŋ wuo paaba dimɛ, pugumaa ma bi jaŋ diiba. ");
INSERT INTO sil_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma tuɔbiinaa jaŋ piŋ lee-la ma kiaa si hɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Má vɔɔ ma damɛrisiŋ woruŋ ma tiŋsiŋ lɛ a nyigɛ ma chaanaa di ba chaanɛ, di ma ŋaa siri ari wii-na kala si jaŋ ŋaama lɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Má leŋ di ma nagɛ dia tiŋtinni-zɔŋŋɔɔ. Di ba kuhiaŋ mu ha-jaari gbiele aŋ kɔ, ba hɔnɔ gbɛru. Ba ŋaa siri di bua-la lɛ u si miira kɔ a du̱ boro, ba jaŋ suro pu lima lima. ");
INSERT INTO sil_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Di ba kuhiaŋ nɛ miira kɔ a na di ba weye a ŋaa siri, ba tuɔŋ jaŋ tɔrɛ. Wutitii, mi jaŋ bula pima, u jaŋ vɔɔ u damɛrɛ woruŋ aŋ ŋaa di u tiŋtinna-la hɔŋ, a joŋ kudiilee piba di ba dii. ");
INSERT INTO sil_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Duu nɛ miira kɔ tita-siesee maa, koo duu nɛ paala kieli ŋii maa, ba tuɔŋ jaŋ tɔrɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Di nuu nɛ fa jima bua-la lɛ gaara si jaŋ ku gaa u kiaa u dia lɛ, u fa jaŋ hɔnɔ pɔ u dia. Di u nɛ weye, u bi jaŋ sɛi di gaara juu gaa u kiaa. Má liisi wiiŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Má ma saa ŋaa siri, bɛɛ wiaa, mi-na Nuhuobiine Bie jaŋ kɔ bua-la lɛ ma si buu yiɛlɛ.” ");
INSERT INTO sil_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ŋii nɛ Piita piɛsɛ Yesu a bul, “La Tiina, ŋ magɛ namaga deeŋ pipila nɛ koo ŋ bula pi nuu-kala nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ŋii nɛ la Tiina Yesu miira piɛsɛba a bul, “Kubɛɛ nɛ saa ŋaa tiŋtinni-titii-la si jiŋ wiaa? U nɛ nii-la u kuhiaŋ si yie liisɛ duu bibeŋ u dia, aŋ pɛ pipi u tiŋtinni-dɔŋsuŋ ma kudiilee. ");
INSERT INTO sil_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Di tiŋtinna-la ŋaa wialiŋ u kuhiaŋ si dagu duu ŋaa, u tuɔŋ jaŋ tɔrɛ bua-la lɛ u kuhiaŋ-la si jaŋ miira kɔ. ");
INSERT INTO sil_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wutitii mi bulaa pima, u kuhiaŋ-la jaŋ joŋ u kiaa kala hɛ tiŋtinna deeŋ nisiŋ lɛ duu bibeŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama di tiŋtinni-la nɛ bula pi u titia ari u kuhiaŋ-la jaŋ dieni nɛ aŋ suomo ŋmuŋmoo u tiŋtinni-dɔŋsu-la, baalaa ari haalaa kala, a hɛ dɔŋɔ lɛ, aŋ faasa didii kudiilee a nyunyua siniŋ bubugi, ");
INSERT INTO sil_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","duu ŋaa ŋii, u bi siri ŋaa gbɛrɛ u kuhiaŋ-la. U kuhiaŋ-la jaŋ kɔ tapulii-la lɛ u si bi yiɛla. U jaŋ dɔgisu woruŋ aŋ kɛnu kaa mu hɛ lee-la nialiŋ si bi u niiŋ wiaa nii si hɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tiŋtinni-la si jiŋ tiŋtimii-la u kuhiaŋ síi chɛ duu tiŋ aŋ bi siri ŋaa duu tiŋ tiŋtimii-la, u kuhiaŋ jaŋ chaasa viiru kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama tiŋtinni-la si bi tiŋtimii-la u kuhiaŋ síi chɛ duu tiŋ jiŋ aŋ ŋaa wii-la si maga di ba viiru, ba jaŋ viiru mua. Di ba joŋ kiaa yugɛ a pi nuu, u maga di ba piɛsɛ laa kiaa yugɛ nii-la teeŋ. Di ba joŋ kiaa yugɛ kiŋkɛŋ kiŋkɛŋ a pi nuu duu beŋ, u ma maga di ba piɛsɛ laa kiaa kiŋkɛŋ kiŋkɛŋ u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ŋii nɛ Yesu bira bul, “Mi kɔ di mi ŋaa di dunia dii nyiniŋ nɛ. Mi saa fa cho duu suomo a didii nɛ lɛɛlɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mi jaŋ juu hɛɛŋ lɛ ari niaa si yie juu liiŋ ŋii, bua-la lɛ ba síi foba Wii-chuɔlɛ liiŋ. Mi tuɔŋ bi jaŋ piŋ di-bala see di mi na hɛɛ-la dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma biina di mi kɛŋ yarifiɛlaa nɛ kaa kɔ di mi pi dunia? Ai. Mi paala kɔ di mi ŋaa di niaa pɔrɛ dɔŋɔ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A chiŋ lɛɛlɛ a kaa mu, dia niaa jaŋ pɔrɛ dɔŋɔ lɛ. Di ba nɛ ŋaa banɔŋ a jujuu dia, ba jaŋ pɔrɛ dɔŋɔ lɛ. Niaa batori jaŋ kɛŋ nii-bala, di niaa balia ma kɛŋ nii-bala. Niaa batori-la jaŋ pɛ dɔŋɔ lɛ a yuyuo niaa balia-la. Niaa balia-la ma jaŋ pɛ dɔŋɔ lɛ a yuo niaa batori-la. ");
INSERT INTO sil_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Biiriŋ nyimmaba ari ba biiriŋ jaŋ guraa yuo dɔŋɔ. Biiriŋ ma kɛŋ ba nyimmaba di ba yuyuo dɔŋɔ. Biiriŋ naaŋba ma jaŋ kɛŋ ba biiriŋ yuyuo dɔŋɔ, biiriŋ ma jaŋ kɛŋ ba naaŋba di ba yuyuo dɔŋɔ. Bala naaŋba ma jaŋ kɛŋ ba bii-haalaa yuyuo dɔŋɔ. Bii-haalaa ma jaŋ kɛŋ ba bala naaŋba yuyuo dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ŋii nɛ Yesu bula pi nialiŋ a bul, “Di ma nɛ na duoŋbiliŋbaanaa di ba nɛ lii wii-juuluŋ a kuu jil, ma yie bul di duonuŋ níi chɛ duu nii. Ŋii nɛ duonuŋ sɛnɛ yie nii. ");
INSERT INTO sil_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Di ma nɛ bira na peliŋ duu nɛ lu a lii taŋ-bubuɔŋ, ma yie bul di leriŋ jaŋ liŋ. U sɛnɛ liŋ. ");
INSERT INTO sil_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ma kaŋfugi tiŋŋaa deeŋba. Ma yie wuo beŋ tiŋteeŋ a beŋ wia nyuŋ maa a wuo dagɛ wii-la si jaŋ ŋaa. Bɛɛ nɛ saa tii ma bi jaŋ wuo jiŋ wialiŋ síi ŋaa dunia deeŋ lɛ ba bubuɔŋ?” ");
INSERT INTO sil_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ŋii nɛ Yesu bira bul, “Ma si jiŋ wii-la si maga di ma ŋaa, bɛɛ nɛ tii ma buu ŋaa? ");
INSERT INTO sil_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Di nuu nɛ samiŋ a kɛniŋ kaa mu sariya di-diiliŋ, ŋ ŋaa kukeri a bul wii-la wasɛ woŋbiiŋ lɛ aŋ-na mu. Di ŋii dee, u jaŋ kɛniŋ kaa lɛrɛ sariya didiire teeŋ. Sariya didiire bira jaŋ kɛniŋ kaa hɛ porisiba nisiŋ lɛ. Ba jaŋ kɛniŋ mu tɔ dia. ");
INSERT INTO sil_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Di ba nɛ kɛniŋ mu tɔ dia, ŋ bi jaŋ wuo lii, see di ŋ ti̱ŋ chiŋ-la kala ba si kere piŋ.” ");
INSERT INTO sil_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bua-la lɛ Yesu fa si bul wiaa pipi niaa, nialiŋ dɔŋsuŋ fa si hɛ dimɛ bul wiaa pu a mu tigɛ Paalit lɛ, u fa si kpu Galilii tiŋŋaa dɔŋsuŋ ŋii. U kpuba bua-la lɛ ba síi kpu pusuŋ pipi Wia nɛ. ");
INSERT INTO sil_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ŋii nɛ Yesu piɛsɛba a bul, “Ma biina ari Galilii tiŋŋaa deeŋba Paalit si kpua nɛ ŋaa haachɛ a kii Galilii tiŋŋaa dɔŋsuŋ kalaa? ");
INSERT INTO sil_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ai, ŋii dee. Di ma nɛ bi birima lii ma haachɛba lɛ, ma kala jaŋ suu ari niaa deeŋba si suu ŋii. ");
INSERT INTO sil_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nialiŋ fii ari chori ma fa si hɛ dimɛ, dii-duduoŋ tele ŋmooba kpu Siloom lɛ. Ma biina ari ba nɛ ŋaa haachɛ a kii nialiŋ dɔŋsuŋ kala fa si hɛ Jerusalɛm lɛ koo? ");
INSERT INTO sil_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ai, ŋii dee. Mi bulaa pima, di ma kala bi birima lii ma haachɛba lɛ, ma kala jaŋ suu niaa deeŋba fa si suu ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ŋii nɛ Yesu magɛ namaga a pi niaa a bul, “Baal kubala nɛ fa hɛ dimɛ. U fa kɛŋ tutogo nɛ u baga lɛ. Tutogo-la nɛniŋ yi, u mu a chichɛ nɛnɛɛ tutogo-la lɛ. U bi nɛŋ kala na. ");
INSERT INTO sil_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ŋii nɛ u bula pi u bagi-paara a bul, ‘Jisiŋ batori nɛ ŋla tia-la si bi nɛnɛ, u maga di ŋ kere ta nɛ. U china tɔ leriŋ nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ŋii nɛ bagi-paari-la bula pu a bul, ‘Mi kuhiaŋ, leŋ duu chiŋ jina deeŋ ma lɛ di la na. Mi jaŋ huro golli u bubuɔŋ a hɛ na-biniŋ. ");
INSERT INTO sil_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Di u nɛ nɛnɛ hariŋ jina-la lɛ, u jaŋ zɔŋ. Di u nɛ bi nɛnɛ, kere ta.’ ” ");
INSERT INTO sil_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chɛ-wiesii-la chɛɛŋ kubala Yesu juu Wii-chuɔlɛ dia a didagɛ niaa Wia wiaa. ");
INSERT INTO sil_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Di haal kubala hɛ dimɛ. Jiŋ-bɔŋ kubala nɛ kɛnu a ŋaa uu wiilɛ. U wiilɛ ŋii a yi jisiŋ fii ari chori. U fa kɛnu bori nɛ. U bi wuo tiɛnaa chiŋ. ");
INSERT INTO sil_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu si na haal-la, u yiru a bul, “Haal, ŋ duoro nɛ. Ŋ nyanyalii-la lii-ŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ŋii nɛ u joŋ u nisaa a daŋ haal-la lɛ. Haal-la guu tiɛnɛ u titia a dɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ŋii nɛ Wii-chuɔlɛ dia-la kuhiaŋ na baaniŋ ari Yesu si vaarɛ niaa chɛ-wiesii-la chɛɛŋ. U bula pi nialiŋ a bul, “Tapulaa balidu nɛ hɛ dimɛ. U maga di la tiŋ tiŋtiŋŋaa tapulaa deeŋba pɛgɛ di ba vaarɛma, ama chɛ-wiesii-la chɛɛŋ dee.” ");
INSERT INTO sil_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ŋii nɛ la Tiina Yesu bula piba a bul, “Ma kaŋfugi tiŋŋaa deeŋba, ma tuɔŋ kubɛɛ nɛ bi nɛɛŋ koo u kakumo puro kaa lii u nyunyua liiŋ chɛ-wiesii-la chɛɛŋ? ");
INSERT INTO sil_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haala deeŋ ŋaa Abiraham doho nuu nɛ. Sitaani kɛnu vɔɔ bil jisiŋ fii ari chori. U saa bi maga di la laau ta chɛ-wiesii-la chɛɛŋ koo?” ");
INSERT INTO sil_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","U si bul ŋii, hiisiŋ kɛŋ u diŋdɔmɔ-la kala, aŋ ka nialiŋ ku-kaanaa tuɔŋ tɔrɛ ari Yesu si ŋaa wu-kpuŋkpere-la. ");
INSERT INTO sil_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ŋii nɛ Yesu piɛsɛ nialiŋ a bul, “Bɛɛ kuŋ nɛ mi jaŋ kɛŋ Wia kuorii-la kaa magisɛ? Ɛɛ nɛ Wia kuorii-la nagɛ? ");
INSERT INTO sil_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","U nagɛ ku-doho kubala ba kaa yirɛ masitad nɛ. Baal kubala joŋo du̱u u baga lɛ. U nyu a waa a birimɛ tia. Ŋii nɛ diibiisiŋ ku sua ba dɛlliŋ u naakelee lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ŋii nɛ Yesu bira piɛsɛba a bul, “Bɛɛ kuŋ nɛ mi bira jaŋ kɛŋ Wia kuorii-la a kaa magisɛ? ");
INSERT INTO sil_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wia kuorii-la nagɛ si-buruŋ ba si kaa hɛ munuŋ lɛ, u sii a puɔrɛ nɛ. Haala joŋ munuŋ a hɛ tasi-gbaŋa tuɔŋ, a joŋ si-buruŋ a kaa kuosi. U dieni mua, ka muŋ-la sii su̱ tasi-gbaŋa-la kala.” ");
INSERT INTO sil_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ŋii nɛ Yesu mu Jerusalɛm diiriŋ. U síi mu ŋii, u gɔllɛ ta-balaa ari ta-biisiŋ a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ŋii nɛ nuu kubala ku piɛsu a bul, “La Tiina, nialiŋ Wia si laa ta, ba jaŋ ŋaa niaa muapilii duŋduŋ koo?” ");
INSERT INTO sil_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ŋii nɛ Yesu bula pi niaa a bul, “Di ma níi chɛ di ma juu Wia kuorii-la tuɔŋ, u maga ari ma to boi-la si bi jal nɛ. Má hɛ doluŋ a to boi-la a juu. Mi jaŋ bula pima, niaa jaŋ yugɛ a wiwalimɛ di ba to lee-la juu aŋ walima lɔl. ");
INSERT INTO sil_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tapulii kubala dia-la tiina jaŋ sii a kɛŋ u boiŋ tɔ. Ka ŋ-na jaŋ hɛ hariŋ a suomo du̱ boro-la a bul, ‘La Tiina, kɛŋ boi-la suri a pila.’ Ŋii nɛ u jaŋ bula pima a bul, ‘Mi bi lee-la ma si lia jiŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma ma jaŋ bula pu a bul, ‘La di ma kala nɛ fa hɔŋ di-bala a dii kiaa. Ŋ dagɛla ŋ wiaa la jaŋ ma lɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ŋii nɛ u jaŋ bira bula pima a bul, ‘Mi bi lee-la ma si lia jiŋ. Má suusa lii mi teeŋ. Ma kala ŋaa ni-bɔŋŋɔɔ nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tapulii kubala ma jaŋ na Abiraham ari Aizik ari Jekɔb, ari nialiŋ kala síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ di ba hɔŋ Wia kuorii-la tuɔŋ, ka ma-na jaŋ hɛ jeeŋ hariŋ a na baaniŋ a yiyel aŋ didiŋ ma nyilaa, aŋ bi wuo juu. ");
INSERT INTO sil_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Niaa jaŋ lii dunia sɛmɛ-na kala a hɔŋ Wia kuorii-la tuɔŋ aa gbieli. ");
INSERT INTO sil_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ama kuhiasiŋ yuga a jaŋ ku birimɛ haŋbiisiŋ. Haŋbiisiŋ yuga a ma jaŋ ku birimɛ kuhiasiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bua-la titia lɛ nɛ Farisii tiŋŋaa dɔŋsuŋ kɔ Yesu teeŋ a bula pu a bul, “Lii daha, bɛɛ wiaa Hɛrɔd ka chɛ duu kpuŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ŋii nɛ Yesu bula piba a bul, “Má mu bula pi nyinyisɛri-la, mi jaŋ kiri jiŋ-bɔŋŋɔɔ aŋ vaarɛ niaa jiniŋ ari chie. Chieto mi jaŋ tiŋ mi tiŋtiŋŋaa dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ari ŋii kala, u maga di mi ha hɛ mi woŋbiiŋ lɛ jiniŋ ari chie ari chieto kala. U bi woŋbii kɛnɛ di ba kpu nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ lee-kala see Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ma Jerusalɛm niaa, ma yie kpu nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, a joŋ tabiaa a yagɛ tiŋdaara-la Wia si tima di ba kɔ ma teeŋ. Naaŋsiiŋ yuga nɛ mi fa cho di mi chu tɔ ma niaa kala, ari ji̱miŋ si yie chu tɔ u biiriŋ ŋii, ka ma bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bee na, Wia jaŋ leŋ ma jáŋ pima. Ma bira bi jaŋ nami, see bua-la lɛ ma si jaŋ chuɔlɛmi a bul, ‘Wia jaŋ pɛ nii-la síi kɔ la Tiina Wia doluŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chɛ-wiesii-la chɛɛ kubala, Yesu mu duu dii kudiilee Farisii tiŋŋaa kuhiaŋ kubala dia lɛ. Ŋii nɛ niaa faasa bibenu woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Di baal kubala nɛ hɛ dimɛ a kɔ Yesu teeŋ. U yaraa kala fa ŋmɛrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ŋii nɛ Yesu piɛsɛ Wia teniŋ kerichiba ari Farisii tiŋŋaa a bul, “U kɛŋ woŋbiiŋ nɛɛ di la vaarɛ nyanyal tiŋŋaa chɛ-wiesii-la chɛɛŋ koo?” ");
INSERT INTO sil_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba bi wii-kala bula. Ŋii nɛ Yesu kɛŋ baal-la a vaaru aŋ tau u mu dia. ");
INSERT INTO sil_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ŋii nɛ u bira piɛsɛba a bul, “Di ŋ bie koo ŋ nɛɛŋ nɛ tel viliŋ lɛ chɛ-wiesii-la chɛɛŋ, ma tuɔŋ kubɛɛ nɛ bi jaŋ lɛrɛ liisu?” ");
INSERT INTO sil_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba bi wii-kala wuo bula pu. ");
INSERT INTO sil_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu si beŋ nialiŋ ba si yira baa juu dia ŋii, u na di ba juu chichɛ ba hɔŋ ni-balaa di-hɔnɔɔ. Ŋii nɛ u magɛ namaga a piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Di nuu nɛ yiriŋ di ŋ kɔ u ha-jaari gbiele a dii kudiilee, sí mu bagisa joŋ ni-balaa di-hɔnuŋ a hɔŋ. Dia tiina jaŋ wuo yirɛ nuu ma si kiiŋ bira duu hɔŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nii-la si yirɛma jaŋ wuo ku bula piŋ a bul, ‘Suusa mu, ka di ŋ dɔŋɔ tiina hɔŋ ŋ di-hɔnuŋ.’ Ŋii nɛ ŋ jaŋ sii a mu hɔŋ ni-biisiŋ di-hɔnuŋ. Hiisiŋ jaŋ kɛniŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ŋii nɛ saa di ba nɛ yiriŋ di ŋ ku dii kudiilee, di ŋ nɛ mua, hɔŋ ni-biisiŋ di-hɔnuŋ. Di nii-la si yiriŋ nɛ kɔ naŋ, u jaŋ bula piŋ a bul, ‘Mi naŋdɔŋ, sii hɔŋ di-hɔŋ-zɔmuŋ.’ U nɛ ŋaa ŋii, u jaŋ piŋ jirima nialiŋ kala si hɛ dimɛ teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nii-la kala síi bigisi u titia lɛ, Wia jaŋ kɛnu muuri. Ka nii-la ma si kɛŋ u titia muuri, Wia jaŋ ŋaa duu yugɛ.” ");
INSERT INTO sil_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ŋii nɛ Yesu bula pi nii-la si yiru duu ku dii kudiilee a bul, “Di ŋ nɛ ŋaa kudiilee, sí ŋ naŋdɔŋsuŋ koo ŋ naaŋbiiriŋ yiru, sí ŋ dia niaa koo ŋ dɔŋsuŋ tiŋŋaa si kɛŋ kiaa ma yiru. Ba ma jaŋ wuo yiriŋ maachie di ŋ ku dii kudiilee ba teeŋ a ti̱ŋ ŋ chimiŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Di ŋ níi yirɛ niaa di ba ku gbieli gbiele a dii kudiilee, yirɛ summoo ari nialiŋ naasiŋ koo nisaa si suba ari nyulimaa kala. ");
INSERT INTO sil_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Di ŋ nɛ ŋaa ŋii, Wia ma jaŋ pɛŋ lɛ, bɛɛ wiaa ba-na bi jaŋ wuo ti̱ŋ ŋ chimiŋ. Wia jaŋ ti̱ŋ ŋ chimiŋ tapulii-la tuɔ-pul tiŋŋaa si jaŋ sii suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu si bul wiiŋ deeŋ, ŋii nɛ nialiŋ si hɔnɔɔ dii kialiŋ dɔŋɔ bula pi Yesu a bul, “Nialiŋ si jaŋ dii kiaa Wia kuorii-la tuɔŋ, ba tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ŋii nɛ Yesu magɛ namaga a bul, “Baal kubala nɛ fa hɛ dimɛ. U ŋaa ba gbieli gbieli-bal. Ŋii nɛ u yirɛ niaa yugɛ di ba kɔ di ba gbieli. ");
INSERT INTO sil_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gbiele-la si ŋaa siri, u tiŋ u tiŋtinna duu mu bula pi nialiŋ u si yira ari ba ŋaa siri nɛ di ba gbieli gbiele-la. ");
INSERT INTO sil_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","U si mu yirɛba, ba kala via. Ni-buŋbuŋ si duu yɔɔ baga nɛ a chichɛ duu mu na, ŋii wiaa u bi jaŋ wuo kɔ. ");
INSERT INTO sil_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dɔŋɔ ma si duu ma yɔɔ nɛ-belliŋ fii nɛ a ma kaa lii duu kaa mu pɛrɛ na. Ŋii wiaa u ma bi jaŋ wuo kɔ. ");
INSERT INTO sil_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dɔŋɔ tiina ma si di lɛɛlɛ nɛ u jaa haala. A tiŋ ŋii wiaa u ma bi jaŋ wuo kɔ. ");
INSERT INTO sil_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ŋii nɛ tiŋtinni-la miira mu bula pi u kuhiaŋ-la. U si nii ŋii, u baaniŋ sii kiŋkɛŋ. Ŋii nɛ u bira bula pu a bul, ‘Lii mu woŋbiiŋ niiŋ lima ari jaŋ tuɔŋ woŋbii-biisiŋ a yirɛ summoo ari gbɛrikɛɛ ari nyulimaa, ari nialiŋ naasiŋ ari nisaa si suba.’ ");
INSERT INTO sil_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lima lima di baal-la u si tima lia a yirɛ nialiŋ ba ku juu, ka u juu bula pi u kuhiaŋ-la ari nialiŋ kɔ nɛ, ama ba ha bi yugɛ. ");
INSERT INTO sil_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ŋii nɛ baal-la bira bula pi u tiŋtinni-la a bul, ‘Bira lii bagisiŋ woŋbiee ari woŋbii-biisiŋ kala a yirɛ niaa di ba ku juu di mi dia su̱.’ ");
INSERT INTO sil_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mi jaŋ bula pima ari nialiŋ mi si yira, ba kuŋ-kala bi jaŋ dii kudiilee deeŋba.” ");
INSERT INTO sil_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu fa síi mu woŋbiiŋ ŋii, ni-daŋ to u hariŋ. Ŋii nɛ u daasɛ hariŋ a bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Di nuu-kala nɛ kɔ mi teeŋ, u bi jaŋ wuo ŋaa mi haritooro, see u bɛrɛ u nyimma ari u naaŋ ari u haala ari u biiriŋ ari u naaŋbiiriŋ ari u titia wu-ŋaalaa kala. ");
INSERT INTO sil_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nii-la kala si bi u titia daa-gɛsɛɛ baasɛ aŋ to mi hariŋ, u bi maga duu ŋaa mi haritooro. ");
INSERT INTO sil_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Di ma kuŋ níi chɛ di ŋ saa dii-duduoŋ, ŋ jaŋ laa sipaaŋ hɔŋ a biinɛ a na di moribiee maga di ŋ kaa saa dia-la dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Di ŋ nɛ bi ŋii ŋaa aŋ suomo bil dia-la geŋtine aŋ bira bi moribiee kɛnɛ di ŋ saa dia-la dɛrɛ, niaa jaŋ na wii-la ŋ si ŋaa. Ba jaŋ mumɔmuŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ba jaŋ bul, ‘Baala deeŋ suomo duu saa dia nɛ aŋ bi wuo saa dɛrɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ŋii nɛ Yesu bira magɛ namaga dɔŋɔ a bul, “Kuoro nɛ sie a kɛŋ niaa bui fii a kaa mu duu yuo u kuoru dɔŋɔ. Ka kuoru-la ma kɛŋ niaa bui mara nɛ. U jaŋ laa sipaaŋ hɔŋ a biina na duu nɛ jaŋ wuo yuo dii kuoru-la aŋ-na mu yuou. ");
INSERT INTO sil_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Di u nɛ bi jaŋ wuo dii kuoru-la, u jaŋ tiŋ tiŋdaaraa di ba mu cheŋ kuoru-la dɔŋɔ di ba hɛ di-bolii, a leŋ di ba sulu di ba siŋ.” ");
INSERT INTO sil_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ŋii nɛ Yesu bira bula piba a bul, “Ŋii titia nɛ ma kuŋ-kala bi jaŋ wuo ŋaa mi haritooro, see ŋ via kuŋ-kala ŋ si kɛnɛ ta. ");
INSERT INTO sil_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yisiŋ sima, ama di u nɛ sɛbisɛ, ŋ bira bi jaŋ wuo ŋaa duu siŋ. ");
INSERT INTO sil_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ŋ bira bi jaŋ wuo joŋo hɛ baga lɛ duu leŋ di kiaa wasɛ. U bira bi nyuuruŋ kala kɛnɛ. Ba yie joŋo yuo ta nɛ. Ma digilaa tiŋŋaa, má wuoli ma digilaa a nii wiaa deeŋba.” ");
INSERT INTO sil_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tapulii kubala laŋpoo lilaaraa ari haachɛ diiree yuga kɔ Yesu teeŋ di ba jegile nii u wiaa. ");
INSERT INTO sil_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ŋii nɛ Farisii tiŋŋaa ari Wia teniŋ kerichiba suomo gugurimɛ wiaa a bul, “Baala deeŋ leŋe haachɛ diiree kukɔ u teeŋ nɛ aŋ pɛ leŋ ba di ba kala didii kiaa.” ");
INSERT INTO sil_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu si nii ŋii, u magɛ namaga piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Baal kubala nɛ hɛ dimɛ a kɛŋ piesee zɔlɔ. Ŋii nɛ ba tuɔŋ dɔŋɔ lɛl. U leŋ piesee mahiŋ banɛsɛ ari fii ari nibi-la ta giriŋ tuɔŋ aŋ gɔllɔ chichɛ pie-lɛlii-la a bul di see duu chɛ nau. ");
INSERT INTO sil_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U si nau, u joŋo baasɛ a kaa mu dia. ");
INSERT INTO sil_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","U si kaa mu dia, u yirɛ u naŋdɔŋsuŋ ari u naaŋbiiriŋ a bula piba, ‘Má leŋ di la kala tuɔŋ tɔrɛ. Mi na mi piesi-la si lɛlɛ nɛ.’ Ma tuɔŋ kubɛɛ nɛ bi jaŋ ŋaa wii-la baal-la si ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu dagɛ namaga-la bubuɔŋ a bul, “Di haachɛ diire kubala ma nɛ birima lii u haachɛba lɛ, nialiŋ si hɛ Wia-jaŋ lɛ, ba tuɔŋ jaŋ tɔrɛ. Ba tuɔŋ jaŋ tɔrɛ nia deeŋ nyuŋ a kii niaa mahiŋ banɛsɛ ari fii ari nibi-la si kɛŋ tuɔ-pula a biinɛ u bi maga di ba birima lii ba haachɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Leŋ la joŋ ari haal kubala nɛ hɛ dimɛ a kɛŋ sɛlimɛ moribii-biiŋ fii. Di dɔŋɔ nɛ lɛlɛ, ɛɛ nɛ u jaŋ ŋaa? U jaŋ nyigɛ nyiniŋ a tii u dia kala a beŋ woruŋ see duu nau. ");
INSERT INTO sil_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","U si nau, u yirɛ u taŋlɔŋsuŋ ari u naaŋbiiriŋ kala a hɛ dɔŋɔ a bula piba a bul, ‘Má leŋ di la kala tuɔŋ tɔrɛ. Mi moribii-la si lɛlɛ, mi nau nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ŋii nɛ Yesu bul, “Mi jaŋ bula pima ari ŋii titia nɛ, di haachɛ diire kubala nɛ birima lii u haachɛba lɛ, Wia tiŋdaaraa tuɔŋ yie tɔrɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu bira magɛ namaga dɔŋɔ a bul, “Baal kubala nɛ hɛ dimɛ a kɛŋ u haŋbiisiŋ balia. Ba fa ŋaa baalaa nɛ. ");
INSERT INTO sil_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ŋii nɛ ba tuɔŋ ku-bie sii mu bula pi ba nyimma a bul, ‘Mi nyimma, kialiŋ ŋ si jaŋ suu aŋ ka pila, joŋ mi toruŋ pimi.’ Ŋii nɛ u kɛŋ kialiŋ kaa kpaa. ");
INSERT INTO sil_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","U bi diene, ka ba tuɔŋ ku-bie sii paa u toruŋ kala u si laa a hɛ dɔŋɔ lɛ, a sii mu ta-bolii kubala. Dimɛ u kɛŋ kialiŋ kala kaa mu ŋaa wu-tɔɔnuŋ, ba kala dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","U si dii kialiŋ kala dɛrɛ ŋii, di losuŋ juu taŋ-la woruŋ. U chɛ kudiilee ka. ");
INSERT INTO sil_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ŋii nɛ u mu chɛ tiŋtiŋŋaa. Taŋ-la nuu sɛi duu bibeŋ u toonuŋ. U kɛŋ u titia kaa mu mɛrɛ nii-la lɛ a didaa u toonu-la. ");
INSERT INTO sil_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","U síi daa toonu-la, nuu-kala buu kudiilee ka pa. U fa chichɛ duu dii toonu-la kudiilee. ");
INSERT INTO sil_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ŋii nɛ u biinɛ u tuɔŋ lɛ a mu yi u nyimma lɛ a bul, ‘Mi nyimma ma kɛŋ tiŋtinnaa yugɛ nɛ. Ba kala nina kudiilee didii aŋ kika, aŋ ka mi-na hɛ daha a susuu losuŋ. ");
INSERT INTO sil_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi jaŋ sii a miira mu mi nyimma teeŋ. Di mi nɛ mua, mi jaŋ bula pu, Mi nyimma, mi ŋaa haachɛ ari Wia ariŋ kala. ");
INSERT INTO sil_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","U bira bi maga di mi ŋaa ŋ bii. Joŋmi di mi pɛ ŋ tiŋtinnaa lɛ di la titiŋ.’ Ŋii nɛ u sii a kukɔ u nyimma teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","U si kɔ u nyimma teeŋ, u fa ha hɛ di-bolii nɛ, ka u nyimma nau. Nennige kɛnu woruŋ. U fá mu a guoru. ");
INSERT INTO sil_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ŋii nɛ bile bula pi u nyimma a bul, ‘Mi ŋaa haachɛ ari Wia ariŋ kala. U bira bi maga di mi ŋaa ŋ bii.’ ");
INSERT INTO sil_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama u nyimma ha bula pi u tiŋtinnaa a bul, ‘Má mu lima a joŋ gɛri-zɔmuŋ a kaa kɔ laalu. Má joŋ nenii-piriŋ maa a hɛ u nisiŋ aŋ joŋ nɛŋtɛŋŋɛɛ ma a hɛu. ");
INSERT INTO sil_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Má mu kɛŋ nɛɛŋ-la ma si nɛrɛ a kaa ku kpu di la kala dii, di la tuɔŋ tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","U naga mi bie deeŋ fa suba nɛ aŋ sisɛlɛ sii. U fa lɛlɛ nɛ, ka la lɛɛlɛ nau. Ŋii nɛ ba dii kiaa ari tuɔtɔruŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Bua-la lɛ di bile malima hɛ baga lɛ. Ŋii nɛ u kɔ dia. U si ku kpagɛ u dia, u nia di baa du̱ kiaa a gugua. ");
INSERT INTO sil_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ŋii nɛ u yirɛ u nyimma tiŋtinna-la dɔŋɔ a piɛsu a bul, ‘Bɛɛ nɛ baa ŋaa ŋii?’ ");
INSERT INTO sil_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ŋii nɛ u bula pu a bul, ‘Ŋ ŋaana nɛ miira kɔ. Ŋii nɛ ŋ nyimma kɛŋ nɛ-fere a kpu a pu, bɛɛ wiaa u miira kɔ dia ari yarifiɛlaa nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ŋii nɛ bile malima-la na baaniŋ kiŋkɛŋ. U bi dia jua. U nyimma ku lii a sulu duu ku juu dia. ");
INSERT INTO sil_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bile bula pi u nyimma a bul, ‘Jisiŋ deeŋba kala lɛ mi faasa tiŋ tiŋtiŋŋaa woruŋ a piŋ. Mi ha bi ŋ niiŋ wiaa via chɛ-bala maa. Bɛɛ kuŋ nɛ ŋ saa pimi? Ŋ ha bi buu-bie ma kaa pimi di mi kpu la di ma naŋdɔŋsuŋ gbieli gbiele aŋ chaŋ. ");
INSERT INTO sil_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka ŋ bie deeŋ-na kɛŋ ŋ kiaa kala chei ha-chɔrumuŋ lɛ. Ka u si miira kɔ dia ŋii, ŋ kpu nɛ-fere a pu.’ ");
INSERT INTO sil_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ŋii nɛ bile nyimma bula pu a bul, ‘Mi bii, ŋ yie hɛ dia lɛ bua-na kala lɛ nɛ. Kuŋ-kala mi si kɛnɛ, ŋ ma nɛ tiiu. ");
INSERT INTO sil_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama u maga di la gbieli gbiele a leŋ di la tuɔŋ tɔrɛ nɛ, bɛɛ wiaa u nagɛ ŋ ŋaana deeŋ fa suba nɛ aŋ sii. U fa lɛlɛ nɛ, ka la lɛɛlɛ nau.’ ” ");
INSERT INTO sil_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu magɛ namaga dɔŋɔ a pi u haritooroo a bul, “Baal kubala nɛ fa hɛ dimɛ. U fa ŋaa kiaa tiina nɛ. U fa kɛŋ tiŋtinnu. U nɛ faa beŋ u kialiŋ. Ŋii nɛ niaa ku bula pi kiaa tiina-la, ari u tiŋtinni-la kɛŋ u kialiŋ chichei nɛ. ");
INSERT INTO sil_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","U si nii ŋii, u mu yiru a piɛsu, ‘Bee na wialiŋ mi síi nii a tigɛŋ lɛ. Leŋ di mi jiŋ nialiŋ ŋ si yallɛ mi kialiŋ ba yɔɔ. Ŋ bira bi jaŋ wuo ŋaa mi tiŋtinnu.’ ");
INSERT INTO sil_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ŋii nɛ baal-la bul u titia lɛ a bul, ‘Mi kuhiaŋ ka chɛ duu kirimi nɛ mi tiŋtiŋŋaa lɛ. Bɛɛ nɛ mi jaŋ ŋaa? Mi bi doluŋ kɛnɛ di mi pɛrɛ. Mi bira bi jaŋ wuo gɔllɔ susul kiaa ma. Mi jaŋ fifá hiisiŋ. ");
INSERT INTO sil_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Di mi tiŋtiŋŋaa nɛ cheye, mi jiŋ ŋii mi si jaŋ ŋaa a wuo kɛŋ naŋdɔŋsuŋ, a ŋaa di ba kɛŋmi woruŋ ba diisiŋ lɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ŋii nɛ u yirɛ nialiŋ kala si dii u kuhiaŋ chimiŋ. U yirɛba kubala kubala nɛ. Ŋii nɛ u yirɛ buŋbuŋ nia a piɛsu, ‘Chimiŋ ŋ si dii mi kuhiaŋ teeŋ ŋaa baŋmɛɛ nɛ?’ ");
INSERT INTO sil_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ŋii nɛ u si di nuuŋ nɛ u chimu aŋkura zɔlɔ. Ŋii nɛ tiŋtinni-la joŋ teŋ-la si dagɛ chiŋ-la a pu aŋ bul, ‘Teŋ-la si dagɛ ŋ chimiŋ nɛ ŋla. Ŋ chimiŋ ŋaa aŋkuraba ari nuuŋ zɔlɔ nɛ. Birima ŋmuŋsɛ aŋkuraba mahiŋ balia ari fii.’ ");
INSERT INTO sil_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ŋii nɛ u yirɛ dɔŋɔ tiina ma a piɛsu, ‘Ka ŋ maa?’ U ma si di chimiŋ u si die ŋaa miaa bɔtɔba bui nɛ. Ŋii nɛ tiŋtinni-la bula pu a bul, ‘Teniŋ tuɔŋ ba ŋmuŋsa hɛ ari ŋ chimiŋ magɛ ŋla nɛ, ama birima ŋmuŋsɛ bɔtɔ zɔlɔ chori.’ ");
INSERT INTO sil_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ŋii nɛ kiaa tiina-la bɛsɛ siŋgiriŋ tiina-la lɛ a bul duu ŋaa kukeri aŋ kɛŋ wu-jimiŋ u si ŋaa wu-bɔŋŋɔɔ ŋii.” Ŋii nɛ Yesu bira bul, “Bee na nialiŋ si cho dunia kiaa kiŋkɛŋ kɛŋ wu-jimiŋ a pipɛ dɔŋɔ lɛ a kii nialiŋ síi to Wia.” ");
INSERT INTO sil_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ŋii nɛ Yesu bira bula pi u haritooro-la a bul, “Mi bulaa pima, má joŋ moribiee a kaa dii naŋdɔŋsuŋ. Di moribie-la dɛrɛ, Wia jaŋ kɛŋma kaa mu u jaŋ a joŋ miisi-la si bi dɛrɛ a pima. ");
INSERT INTO sil_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Di ŋ joŋ kiaa mua a pi nuu duu beŋ, ŋii nɛ u beŋ ba nyuŋ woruŋ, u tiina ma jaŋ wuo beŋ kiaa si yuga nyuŋ woruŋ. Di nuu ma nɛ kɛŋ kiaa mua aŋ bi ba nyuŋ woruŋ ka beŋ, duu nɛ kɛŋ kiaa woruŋ, u biba ma nyuŋ wuo beŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Di ŋ nɛ bi dunia kiaa wuo beŋ ari wutitii, nuu-kala bi jaŋ wuo joŋ kialiŋ si faasa kɛŋ nyuuruŋ a hɛ ŋ nisiŋ lɛ di ŋ bibeŋ. ");
INSERT INTO sil_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Di ŋ nɛ bi niaa kiaa wuo beŋ ari wutitii, ba jaŋ wuo joŋ ŋ titia kiaa piŋ di ŋ beŋŋ? Ai. ");
INSERT INTO sil_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yoŋ-bala bi jaŋ wuo tiŋ tiŋtiŋŋaa a pi kuhiasiŋ balia. U jaŋ cho dɔŋɔ aŋ bɛrɛ dɔŋɔ. U jaŋ tuto dɔŋɔ niiŋ wiaa woruŋ aŋ via dɔŋɔ niiŋ wiaa. Ŋ ma saa bi jaŋ wuo to Wia aŋ bira cho dunia kiaa maa.” ");
INSERT INTO sil_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisii tiŋŋaa nii wiiŋ deeŋ Yesu si bula. Ba fa cho dunia kiaa kiŋkɛŋ nɛ. Ŋii nɛ tii ba sisieru lɛ. ");
INSERT INTO sil_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ŋii nɛ Yesu bula piba a bul, “Ma nialiŋ, ma yie chɛ di niaa biinɛ ma kɛŋ wutitii, ama Wia jiŋ ma tuɔsaa. Kialiŋ si ŋaa ku-zɔŋŋɔɔ nuhuobiinee teeŋ, ba nɛ ŋaa ku-lɔrunuŋ Wia teeŋ.” ");
INSERT INTO sil_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ŋii nɛ Yesu bira bul, “Nialiŋ faa to wialiŋ Moosis fa si bile. Ba ma to tenni-la lɛ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, fa si ŋmuŋsa a kaa mu bua-la lɛ Jɔɔŋ si kɔ, nii-la fa síi fo niaa Wii-chuɔlɛ liiŋ. Jɔɔŋ si kɔ ŋii, ba suomo bubul Wia wu-zɔmɔ-la a tigɛ Wia kuorii-la lɛ aa pi niaa. Ŋii nɛ nuu-kala fiɛsɛ siiŋ a wiwalimɛ duu juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Di wia nyuŋ ari tiŋteeŋ kala nɛ fa dɛrɛ, u fa bi jaŋ hɛi. U fa bi jaŋ hɛi ari Moosis niiŋ wialiŋ tuɔŋ ku-bie bira si bi bubuɔŋ kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Baal-na kala si via u haala aŋ bira mu jaa dɔŋɔ, u tiina juu Wia haachɛ lɛ nɛ. Baal-la ma si jaa haala si via u bala, u ma juu Wia haachɛ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ŋii nɛ Yesu bira magɛ namaga a bul, “Kiaa tiina kubala nɛ fa hɛ dimɛ. U yie lilaalɛ gɛri-zɔmɔ-la yalliŋ si hɛyɛ, a piŋ sima nyuŋ woruŋ tapulii-na kala. ");
INSERT INTO sil_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka summu ma fa hɛ dimɛ. Baa yiru Lazɔrɔs. U yaraa kala ŋaa naawiilaa nɛ. ");
INSERT INTO sil_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Vahiŋ yie kɔ a lilenni u naawiila-la. U yie mu hɔŋ kiaa tiina-la boiŋniiŋ a chichɛ di kiaa tiina-la si dii kudiile-la aŋ ka, duu ma paa dii. ");
INSERT INTO sil_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ŋii nɛ summo-la sii suu. Wia tiŋdaara ku joŋu a kaa mu Abiraham teeŋ. U hɔŋ u sɛmɛ Wia-jaŋ lɛ aa nii sima. ");
INSERT INTO sil_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka kiaa tiina-la ma suu. Ba joŋu hugi. U mu juu Wia nyiniŋ a nina hɛɛŋ woruŋ. Ŋii nɛ u bee mu na Abiraham duu hɔŋ di-bolii, ka Lazɔrɔs ma hɔŋ u sɛmɛ. ");
INSERT INTO sil_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŋii nɛ u yiru a bul, ‘Mi nyimma Abiraham, fámi nennige aŋ tiŋ Lazɔrɔs duu kɛŋ u neniiŋ yuu liiŋ a kaa kɔ a fiɛlɛ mi neŋdelimiŋ. Mii na hɛɛŋ nɛ woruŋ nyiniŋ deeŋ tuɔŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ŋii nɛ Abiraham bula pu a bul, ‘Mi bii, liise mu yi ŋ fa si hɛ ŋ miisiŋ lɛ, ŋ faa nii sima nɛ woruŋ, aŋ ka Lazɔrɔs fa nina hɛɛŋ. Ama lɛɛlɛ Lazɔrɔs ma nii sima daha, aŋ ka ŋ ma hɛ hɛɛŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ŋii ma duŋduŋa dee, buɔtuo-luŋi nɛ piŋ la pɛgɛ. Di nialiŋ si hɛ la teeŋ níi chɛ di ba lii kiele mu ma teeŋ, ba bi jaŋ wuo. Nuu ma bi jaŋ wuo lii ma teeŋ a ku kieli a kɔ la teeŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋii nɛ kiaa tiina-la bira bula pu a bul, ‘Mi nyimma Abiraham, ŋii nɛ saa mii suluŋ di ŋ tiŋ Lazɔrɔs duu mu mi nyimma dia. ");
INSERT INTO sil_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mi kɛŋ naaŋbiiriŋ banɔŋ nɛ dimɛ. Leŋ duu kpurisɛ ba digilaa di ba ma sí hɛɛŋ deeŋ leriŋ kɔ bua-la lɛ ba si jaŋ suu.’ ");
INSERT INTO sil_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ŋii nɛ Abiraham bula pu a bul, ‘Wialiŋ Moosis ari nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa si ŋmuŋsa, ba hɛ ŋ naaŋbiiriŋ teeŋ. Leŋ di ba jegile nii wialiŋ ba síi bul.’ ");
INSERT INTO sil_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ŋii nɛ kiaa tiina-la bira bul, ‘Ŋii ha bi maga, mi nyimma. Ama di nuu nɛ fa sii suuŋ lɛ a mu ba teeŋ, ba fa jaŋ wuo birima lii ba haachɛba lɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ŋii nɛ Abiraham bira bula pu a bul, ‘Di ba nɛ bi jaŋ jegile nii wialiŋ Moosis ari nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa si ŋmuŋsa, ba ma fa bi jaŋ sɛi wialiŋ di nuu nɛ paala sii suuŋ lɛ a mu ba teeŋ a dagɛba.’ ” ");
INSERT INTO sil_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu bula pi u haritooroo a bul, “Wialiŋ si jaŋ ŋaa di niaa juu haachɛ lɛ jaŋ hɛ dimɛ. Ama nii-la si jaŋ ŋaa di ba juu haachɛ lɛ jaŋ na hɛɛŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","U maga di ba joŋ nɔmuŋ nɛ a vɔɔ laalɛ u baŋŋa lɛ, a joŋu yuo hɛ muga tuɔŋ duu suu. Di ba nɛ ŋaa ŋii, u nɛ jaŋ kpia u si jaŋ ŋaa di haŋbiisiŋ deeŋba tuɔŋ kubala ŋaa wu-bɔmuŋ. ");
INSERT INTO sil_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Má pɔ ma titia lɛ. Di ŋ naaŋbie nɛ ŋaa haachɛ, kpiau lɛ. Di u nɛ si duu cheye nɛ, joŋo chɛu. ");
INSERT INTO sil_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Di u nɛ ŋaa wii cheiŋ lɛ aŋ ku bula piŋ ari u cheye nɛ, a ŋaa ŋii a yi naaŋsiiŋ bulipɛ chɛ-bala, joŋo chɛu.” ");
INSERT INTO sil_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ŋii nɛ Yesu naŋzɔɔba-la bula pu a bul, “La Tiina, ŋaa di la yarida yugɛ kiŋkɛŋ.” ");
INSERT INTO sil_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ŋii nɛ la Tiina Yesu bula piba a bul, “Di ma yarida nɛ fa magɛ kuŋ biiŋ ba síi yirɛ masitad, ma fa jaŋ wuo bula pi tia duu kɛŋ u naakelee kala churi a jila chɔŋsɛ muga lɛ. U fa jaŋ to ma niiŋ lɛ a ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ŋii nɛ Yesu bira bul, “Di ma kuŋ nɛ kɛŋ tiŋtinnu u pipɛrɛ ŋ baga lɛ koo u didaa ŋ piesee, duu nɛ lii baga koo pie-daaliŋ kɔ, ŋ jaŋ bula pu a bul duu ŋaa lima a dii kudiilee koo? ");
INSERT INTO sil_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ai, ŋ ma jaŋ bula pu duu ŋaa siri a laalɛ u gɛnniŋ a ŋaa kudiilee piŋ di ŋ dii. Di ŋ nɛ dii dɛrɛ, u ma jaŋ wuo dii u kudiilee. ");
INSERT INTO sil_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ŋ jaŋ lɔllɛ ŋ tiŋtinni-la a tiŋ u si ŋaa wialiŋ ŋ si dagu wiaa? Ai. ");
INSERT INTO sil_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma ma saa nagɛ ŋii nɛ. Di ma nɛ ŋaa wialiŋ kala ba si si di ma ŋaa, u maga di ma bul, ‘La ŋaa tiŋtinnaa nɛ. U bi maga di ba lɔllɛla. Tiŋtimii-la si maga di la tiŋ duŋduŋa nɛ la titiŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ŋii nɛ Yesu bira sii mu Jerusalɛm diiriŋ. U to Samaria tiŋteeŋ ari Galilii tiŋteeŋ nɛ a mu. ");
INSERT INTO sil_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ŋii nɛ u mu juu taŋ kubala, di gbegisiŋ fii ku chemu. Ba fa chiŋ di-bolii nɛ ");
INSERT INTO sil_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aŋ faasa yirɛ a bul, “Yesu, la kuhiaŋ, fála nennige.” ");
INSERT INTO sil_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ŋii nɛ Yesu naba a bul, “Má kɛŋ ma titia mu a dagɛ nii-la si kpu pusuŋ pipi Wia.” Ŋii nɛ ba mu. Ba síi mu ŋii, ba duori. ");
INSERT INTO sil_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba tuɔŋ dɔŋɔ si na duu duoro, u miirɛ a faasa didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","U mu Yesu teeŋ a tuu kpirimi tiŋteeŋ u naasiŋ lɛ a lɔllu. Baal-la fa ŋaa Samaria tiina nɛ. ");
INSERT INTO sil_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ŋii nɛ Yesu piɛsu, “Niaa fii dee mi vaarɛɛ? Nii nɛ nibi-la hɛ? ");
INSERT INTO sil_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɛɛ nɛ tii nuhuɔra deeŋ duŋduŋa nɛ miira kɔ duu lɔllɛ Wia?” ");
INSERT INTO sil_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ŋii nɛ Yesu bula pi baal-la a bul, “Sii a viiri, ŋ yarida nɛ ŋaa ŋ duori.” ");
INSERT INTO sil_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ŋii nɛ Farisii tiŋŋaa piɛsɛ Yesu di bua bɛɛ lɛ nɛ Wia kuorii-la jaŋ kɔ? Ŋii nɛ u bula piba a bul, “Di Wia kuorii-la nɛ jaŋ kɔ, wu-magil dee bi jaŋ ŋaa di niaa jiŋ. ");
INSERT INTO sil_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nuu-kala ma bi jaŋ wuo bul, ‘Bee na, u hɛ daha koo u hɛ dimɛ.’ Má bee na, Wia kuorii-la hɛ ma tuɔŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ŋii nɛ u bula pi u haritooro-la a bul, “Tapulii jaŋ yi di ma cho di ma na mi-na Nuhuobiine Bie tapulaa tuɔŋ chɛ-bala duŋduŋa maa. Ama ma bi jaŋ wuo nami. ");
INSERT INTO sil_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Niaa dɔŋsuŋ jaŋ bula pima a bul, ‘Nau, u nɛ ŋla, koo, na u nɛ hɛ daha.’ Di ba nɛ bul ŋii, ma sí lii gɔllɔ chichɛu. ");
INSERT INTO sil_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mi-na Nuhuobiine Bie si jaŋ miira kɔ tapulii-la, u jaŋ nagɛ duonuŋ si ligisa a lii wia nyuŋ sɛmɛ dɔŋɔ a ku tuu sɛmɛ dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama mi jaŋ laa sipaaŋ na hɛɛŋ. Ma lɛɛlɛ niaa, ma jaŋ viami. ");
INSERT INTO sil_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bua-la lɛ mi-na Nuhuobiine Bie si jaŋ miira kɔ, u jaŋ nagɛ bua-la lɛ Nowa fa si hɛ u miisiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bua-la lɛ nialiŋ fa dii kudiilee, haalaa ari baalaa ma jijaa dɔŋɔ a mu yi tapulii-la Nowa fa si juu liiŋ daboro-la tuɔŋ. Liiŋ ku pɛllɛ paa nialiŋ dɔŋsuŋ kala, ba suu. ");
INSERT INTO sil_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","U ma jaŋ nagɛ bua-la lɛ Lɔt fa si hɛ u miisiŋ lɛ. Nuu-kala fa hɛ dimɛ a didii kudiilee a yiyallɛ kiaa a yuyɔɔ kiaa a dudu̱u kiaa a sisaa diisiŋ. ");
INSERT INTO sil_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ka tapulii-la Lɔt si lii taŋ kubala ba síi yirɛ Sɔdɔm lɛ, nyiniŋ ari jiribiiŋ lii wia nyuŋ, a ku tuu kpu nialiŋ dɔŋsuŋ kala. ");
INSERT INTO sil_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ŋii nɛ u jaŋ nagɛ tapulii-la mi-na Nuhuobiine Bie ma si jaŋ miira kɔ. ");
INSERT INTO sil_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Di nuu nɛ hɛ u lusuŋ nyuŋ tapulii-la lɛ aŋ kɛŋ kiaa u dia tuɔŋ, ma sí leŋe duu tuu a juu u dia a paa u kiaa. Nii-la ma si hɛ u baga lɛ, duu ma sí miira mu dia. ");
INSERT INTO sil_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Má liise yi wii-la si ŋaa Lɔt haala lɛ. ");
INSERT INTO sil_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nii-la kala síi walimɛ duu laa u miisiŋ, u jaŋ joŋo ta. Nii-la kala ma si joŋ u miisiŋ ta, u jaŋ laa u miisiŋ. ");
INSERT INTO sil_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi jaŋ bula pima, tapulii-la niaa balia jaŋ piŋ doŋ godo bala nyuŋ titaŋiŋ, Wia jaŋ joŋ dɔŋɔ aŋ leŋ dɔŋɔ ta. ");
INSERT INTO sil_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Haalaa balia ma jaŋ nunɔŋ munuŋ. Wia jaŋ joŋ dɔŋɔ aŋ leŋ dɔŋɔ ta. ");
INSERT INTO sil_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Baalaa balia ma jaŋ hɛ baga lɛ a pipɛrɛ, Wia jaŋ joŋ dɔŋɔ aŋ leŋ dɔŋɔ ta.” ");
INSERT INTO sil_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŋii nɛ Yesu haritooro-la piɛsu a bul, “Nii lɛ nɛ ŋii, la Tiina?” Ŋii nɛ Yesu bula piba a bul, “Lee-la ku-pua si pina nɛ, du̱unuŋ ma hihilimi.” ");
INSERT INTO sil_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ŋii nɛ Yesu bira magɛ namaga piba a dagɛba di ba chuchuɔlɛ Wia bua-na kala lɛ a sí leŋ. ");
INSERT INTO sil_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U si, di sariya diiru nɛ fa hɛ dimɛ taŋ kubala lɛ. U fa bi Wia ka fá. U bi nuhuobiinee ma jirima ka joŋ. ");
INSERT INTO sil_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yo-haal kubala ma nɛ fa hɛ taŋ-la lɛ. U yie vɛnɛɛ mu sariya diiri-la teeŋ a susulu duu pɛu lɛ di u wuo dii sariya a lo u diŋdɔmɔ. ");
INSERT INTO sil_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Buŋbuŋ kala baal-la via duu pɛu lɛ. Ama u si yie vɛnɛɛ kɔ u teeŋ ŋii, ŋii nɛ baal-la bula pi u titia a bul, “Mi paala bi Wia ka fá, mi bi nuhuobiinee ma jirima ka joŋ. ");
INSERT INTO sil_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ama yo-haala deeŋ si vɛnɛɛ walimɛmi ŋii, mi jaŋ pɛu lɛ duu dii u sariya. Ŋii dee u ha jaŋ vɛnɛ wiwalimɛmi di mi lɔl.” ");
INSERT INTO sil_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ŋii nɛ la Tiina Yesu bira bula pi niaa a bul, “Má jegile nii wialiŋ sariya diiri-la si bi wutitii kɛnɛ si bula. ");
INSERT INTO sil_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma saa biina Wia saa bi jaŋ wuo pɛ nialiŋ u si liisa lɛ di ba níi laa ku-siŋŋaa? Di ba níi yel u teeŋ wiihɛyɛ ari titaŋiŋ kala, u bi jaŋ dieni aŋ pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi jaŋ bula pima, u jaŋ pɛba lɛ di ba laa ku-siŋŋaa. U jaŋ ŋaa ŋii lima lima. Ama bua-la lɛ mi-na Nuhuobiine Bie si jaŋ miira kɔ, mi jaŋ na nialiŋ si ŋaa mi yarida, koo?” ");
INSERT INTO sil_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu bira magɛ namaga a pi nialiŋ si biina ba tuɔŋ lɛ di ba kɛŋ tuɔ-pula aŋ lilieni ba dɔŋsuŋ tiŋŋaa kala. U bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Baalaa balia nɛ sii mu Wia-dia di ba chuɔlɛ Wia. Dɔŋɔ lii nialiŋ ba síi yirɛ Farisii tiŋŋaa tuɔŋ nɛ. Dɔŋɔ-la ma ŋaa laŋpoo lilaaru nɛ. ");
INSERT INTO sil_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisii tiina-la sii chiŋ a chuɔlɛ Wia ŋla u tuɔŋ lɛ a bul, ‘La Tiina Wia, mii lɔlluŋ ari mi si bi niaa dɔŋsuŋ naga, nialiŋ si gɔllɔ kɛŋ niaa kiaa lilaa, koo nialiŋ si bi wutitii kɛnɛ, koo nialiŋ si gɔllɔ chɛ niaa haalaa. Mi bi laŋpoo lilaara deeŋ ma si hɛ daha naga. ");
INSERT INTO sil_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mi yie vɔɔ niiŋ bulia nɛ yɔbɔ-na kala lɛ. Ku-la kala mi si na, mi yie kaa kpaa leree fii nɛ a joŋ dɔŋɔ piŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ka laŋpoo lilaari-la chiŋ di-bolii. U paala bi u siaa ma kaa wul wia nyuŋ aŋ paa u nisaa chuŋ u nyuŋ lɛ aŋ bul, ‘Wia, fámi nisusuŋ. Mi ŋaa haachɛ diiru nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ŋii nɛ Yesu bira bul, “Mi jaŋ bula pima ari Wia joŋ laŋpoo lilaari-la haachɛba chɛu, u mu dia. Ama u bi ŋii ŋaa Farisii tiina-la lɛ. Nii-la kala síi bigisi u titia lɛ, Wia jaŋ kɛnu muuri. Ama nii-la si kɛŋ u titia muuri, Wia jaŋ ŋaa duu yugɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Niaa dɔŋsuŋ kɛŋ ba haŋbiisiŋ ma kɔ Yesu teeŋ duu joŋ u nisiŋ daŋba lɛ di Wia pɛba lɛ. Yesu haritooroo naba a kpiaba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ba si kɔ ŋii, u bula pi u haritooro-la a bul, “Má leŋ di haŋbiisi-la kɔ mi teeŋ. Ma síba kiru. Nialiŋ si jaŋ juu Wia kuorii-la tuɔŋ nagɛ haŋbiisiŋ deeŋba nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","U bira bula pi niaa a bul, “Wutitii, mi bulaa pima, nii-la kala si bi Wia to a nagɛ haŋbie si yie to u nyimma ari u naaŋ ŋii, u bi jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ŋii nɛ Ju̱u tiŋŋaa kuhiaŋ kubala kɔ Yesu teeŋ a piɛsu, “Mi kuhia-zɔmuŋ, ɛɛ nɛ mi jaŋ ŋaa a kɛŋ miisi-la si bi dɛrɛ?” ");
INSERT INTO sil_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ŋii nɛ Yesu piɛsu a bul, “Bɛɛ nɛ tii ŋ yirɛmi kuhia-zɔmuŋ? Nuu-kala bi zɔŋ see Wia. ");
INSERT INTO sil_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ŋ jiŋ wialiŋ ba si ŋmuŋsa bil di ma tuto nɛɛ? Ba nɛ ŋla: Sí ŋ dɔŋɔ tiina haala chɛ. Sí niaa kpu. Sí gaa. Di ŋ ŋaa daŋsia wii lɛ, sí wiaa nyia, fifá ŋ nyimma ari ŋ naaŋ.” ");
INSERT INTO sil_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ŋii nɛ baal-la bul, “Mi to wiaa deeŋba kala mi haŋbiiriŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","U si bul ŋii, Yesu bula pu a bul, “Wu-bala nɛ ka ŋ ha jaŋ ŋaa. Joŋ ŋ kiaa kala a yallɛ, a joŋ moribie-la a pi summoo, aŋ ku tomi. Ŋ nɛ ŋaa ŋii, ŋ jaŋ kɛŋ kiaa Wia-jaŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Baal-la si nii wiiŋ deeŋ, u tuɔŋ kala chei, bɛɛ wiaa u fa kɛŋ kiaa nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu si na di u tuɔŋ cheye, u bul, “U ŋaa wu-duo nɛ ari nialiŋ si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","U bi hɛi ari buŋtaŋŋa si jaŋ wuo to gɛri-hɛmiŋ buɔŋ lii ari u si hɛyɛ ŋii nii-la si kɛŋ kiaa si jaŋ wuo juu Wia kuorii-la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nialiŋ si nii Yesu si bul ŋii, ba piɛsu a bul, “Kubɛɛ nɛ saa Wia jaŋ laa ta?” ");
INSERT INTO sil_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ŋii nɛ Yesu bula piba a bul, “Wii-la si jaŋ kperi nuhuobiine, u bi Wia wuo kperi. Wia wuo wii-kala ŋaa nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ŋii nɛ Piita bula pu a bul, “Bee na, la leŋ la diisiŋ nɛ aŋ tuto ŋ hariŋ.” ");
INSERT INTO sil_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, nii-la kala si jaŋ wuo leŋ u dia ari u haala koo u naaŋbiiriŋ koo u nyimma ari u naaŋ koo u biiriŋ a tiŋ Wia kuorii-la wiaa, ");
INSERT INTO sil_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u jaŋ bira na kiaa yugɛ a kii kialiŋ u si leŋe ta. Di u nɛ ku suu, u ma jaŋ na miisi-la si bi dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ŋii nɛ Yesu kɛŋ u haritooroo fii ari balia-la a kaa suusa lii a bula piba, “Má jegile nii mi teeŋ. Laa mu Jerusalɛm nɛ. Dimɛ wialiŋ nialiŋ si bula, Wia Diŋ-zɔŋ-la doluŋ lɛ a tigɛ mi-na Nuhuobiine Bie lɛ a ŋmuŋsa bil, ba jaŋ ŋaa dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba jaŋ joŋmi hɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa nisiŋ lɛ di ba mɔŋmi. Ba jaŋ tuusɛmi aŋ pɛ tu naŋtuɔruŋ hɛmi lɛ. ");
INSERT INTO sil_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba jaŋ viirɛmi aŋ pɛ kpumi, ka di mi sii suuŋ lɛ tapulaa batori chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama Yesu haritooro-la bi wii-la u si bula bubuɔŋ jiŋ. (Wii-la u fa si bula bubuɔŋ fa faa nɛ.) ");
INSERT INTO sil_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ŋii nɛ Yesu ari u haritooroo sii di ba mu Jerusalɛm. Ba mu kpagɛ taŋ kubala baa yirɛ Jɛrikɔ, di nyuluŋ kubala fa hɔŋ woŋbiiŋ niiŋ a susul kiaa.  ");
INSERT INTO sil_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","U si nii ni-daŋ-la síi bal dɔmɔ, u piɛsɛ, “Bɛɛ kuŋ nɛ?” ");
INSERT INTO sil_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ŋii nɛ ba bula pu ari Yesu si lii Nazarɛt níi bal. ");
INSERT INTO sil_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ŋii nɛ u yirɛ Yesu a bul, “Yesu, Devit nihiliɛrɛ, fámi nennige.” ");
INSERT INTO sil_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nialiŋ si laa u sipaaŋ kpiau lɛ duu kɛŋ goŋ. Ama u faasa yirɛ a kii ŋii a bul, “Yesu, Devit nihiliɛrɛ, fámi nennige.” ");
INSERT INTO sil_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ŋii nɛ Yesu chiŋ aŋ bul di ba kɛŋ nyuluŋ-la kaa kɔ u teeŋ. Nyuluŋ-la kɔ. ");
INSERT INTO sil_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ŋii nɛ Yesu piɛsu a bul, “Bɛɛ kuŋ nɛ ŋŋ chɛ di mi ŋaa piŋ?” U bula pu a bul, “Mi kuhiaŋ, leŋ di mi siaa suri di mi nina.” ");
INSERT INTO sil_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ŋii nɛ Yesu bula pu, “Ŋ siaa jaŋ suri, ŋ yarida nɛ ŋaa ŋ duori.” ");
INSERT INTO sil_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","U siaa guu suri. Ŋii nɛ u to Yesu hariŋ a didɛnnɛ Wia. Ni-daŋ-la ma kala si na ŋii, ba ma kala dɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu mu to taŋ kubala baa yirɛ Jɛrikɔ. ");
INSERT INTO sil_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Di baal kubala nɛ fa hɛ dimɛ. U fa ŋaa laŋpoo lilaaraa kuhiaŋ nɛ. U yiriŋ nɛ fa Zakiyas. U fa kɛŋ kiaa nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U faa chɛ duu na Yesu, ama u fa ŋaa ni-kuu nɛ. A tiŋ ni-daŋ-la fa si hɛ dimɛ ŋii, u fa buu wuo na. ");
INSERT INTO sil_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ŋii nɛ u kieli ni-daŋ-la, a fá mu jil tia, duu wuo na Yesu. U jima duu jaŋ ku to tia-la bubuɔŋ bal. ");
INSERT INTO sil_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu si ku to tia-la bubuɔŋ bibal, u wula beŋ tia-la nyuŋ a nau a bula pi Zakiyas a bul, “Zakiyas, ku tuu lima. U maga di mi chua ŋ dia lɛ nɛ jiniŋ.” ");
INSERT INTO sil_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakiyas si nii ŋii, u tuɔŋ tɔrɛ. U tuu lima lima a kɛŋ Yesu mu u dia. ");
INSERT INTO sil_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nialiŋ kala si hɛ dimɛ a na ŋii, ba suomo gugurimɛ wiaa a bul, “Baala deeŋ mu duu chua haachɛ diiri-la dia lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yesu si hɛ Zakiyas dia lɛ ŋii, Zakiyas sii chiŋ a bula pi la Tiina Yesu a bul, “Mi kuhiaŋ, jegile nii mi teeŋ. Mi jaŋ joŋ mi kiaa lebi a pi summoo. Di mi nɛ girimɛ nuu maa, mi jaŋ ti̱ŋ u tiina ari moribiee naaŋsiiŋ bunɛsɛ.” ");
INSERT INTO sil_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ŋii nɛ Yesu bula pu a bul, “Wia laaŋ di ŋ dia niaa kala ta nɛ jiniŋ. Baala deeŋ ma ŋaa Abiraham doho nuu nɛ, ");
INSERT INTO sil_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","bɛɛ wiaa mi-na Nuhuobiine Bie kɔ di mi chɛ a laa nialiŋ si lɛlɛ nɛ a ta.” ");
INSERT INTO sil_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ŋii nɛ Yesu magɛ namaga a pi nialiŋ si nii wialiŋ u si bula. Bua deeŋ lɛ u ka mua ka duu yi Jerusalɛm. Ŋii nɛ tii nialiŋ biinɛ ari bua-la lɛ Wia kuorii-la si jaŋ kɔ kpaga nɛ. ");
INSERT INTO sil_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ŋii nɛ u bul, “Ni-bal kubala nɛ sie a mu ta-bolii kubala di ba bil u kuoruŋ, ka di u miira kɔ u jaŋ a ŋaa kuoro. ");
INSERT INTO sil_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka duu-na mu, u yirɛ u dia tiŋtinnaa fii, a joŋ siidi bui a pi kuŋ-kala, a bul di ba kaa bibirimɛ duu mu aŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ama u taŋ-la niaa bɛrɛ ni-bal-la nɛ. Ŋii nɛ ba tiŋ tiŋdaaraa ba kiri u hariŋ mu a bula pi taŋ-la dɔŋɔ kuoro ari ba bi cho duu ŋaa ba taŋ kuoro. ");
INSERT INTO sil_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ka baal-la mu dii kuoruŋ aŋ miira kɔ. U si miira kɔ, u yirɛ u tiŋtinna-la u fa si joŋ moribii-la pa duu na ba si na nyuuruŋ magɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ŋii nɛ tiŋtinni-buŋbuŋ kɔ u teeŋ a bula pi u kuhiaŋ a bul, ‘Mi kuhiaŋ, ŋ siidi bui-la ŋ si joŋo pimi birimɛ siidi bui fii nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ŋii nɛ u kuhiaŋ-la bula pu a bul, ‘Ŋ ŋaa woruŋ. Ŋ ŋaa tiŋtinni-titii nɛ. Ŋ si ŋaa ŋii a beŋ kubii-bie nyuŋ woruŋ, mi jaŋ leŋ di ŋ bibeŋ tasiŋ fii.’ ");
INSERT INTO sil_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ŋii nɛ tiŋtinni-liamiŋ ma kɔ u teeŋ a bul, ‘Mi kuhiaŋ, ŋ siidi bui-la ŋ si joŋo pimi, u birimɛ siidi bui banɔŋ nɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ŋii nɛ u kuhiaŋ-la bula pu duu jaŋ bibeŋ tasiŋ banɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ŋii nɛ tiŋtinni dɔŋ-la ma kɔ a bula pu a bul, ‘Mi kuhiaŋ, na ŋ siidi bui-la ŋ si joŋo pimi, mi joŋo gul gɛri-kɔsuŋ lɛ nɛ a joŋo faa. ");
INSERT INTO sil_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mii fáŋ nɛ. Ŋ ŋaa ni-tɛrɛ nɛ. Ŋ yie kɛŋ niaa kiaa lilaa nɛ aŋ yie kukuŋ kialiŋ ŋ si bi duo.’ ");
INSERT INTO sil_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ŋii nɛ u kuhiaŋ-la bula pu a bul, ‘Ŋ ŋaa tiŋtinni-bɔŋ nɛ. Wialiŋ titia ŋ si bula nɛ jaŋ dii ŋ sariya a joŋ cheeriŋ piŋ. Ŋ jima ari mi ŋaa ni-tɛrɛ nɛ a kɛŋ niaa kiaa lilaa aŋ pɛ kukuŋ kialiŋ mi si bi duo. ");
INSERT INTO sil_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɛɛ nɛ saa tii ŋ bi mi moribiiŋ joŋo bil lee-la ba síi bil moribiee? Mi fa si miira kɔ ŋla, mi fa jaŋ laa moribie-la ari mi nyuurii kala.’ ");
INSERT INTO sil_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋii nɛ u bula pi u tiŋtinni dɔŋsu-la fa si chiŋ dimɛ a bul, ‘Má laa siidi bui-la u teeŋ a joŋo pi nii-la si kɛŋ siidi bui fii-la.’ ");
INSERT INTO sil_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ŋii nɛ ba bula pu a bul, ‘La Tiina, bee na, u paala kɛŋ siidi bui fii nɛ, aŋ ka ŋ chɛ di ŋ joŋ siidi bui-la a pɛ pu ŋii.’ ");
INSERT INTO sil_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ŋii nɛ u bula piba a bul, ‘Nii-la si paala kɛŋ kiaa yugɛ nɛ, Wia jaŋ wasa chɛ a pɛ a pu, ama nii-la si bi faasa kɛŋ kiaa yugɛ, muapilii-la ma u si kɛnɛ, Wia jaŋ kaa laa u teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mi diŋdɔŋŋɔɔ deeŋba saa si bi cho di mi ŋaa ba kuoro, má kɛŋba kaa kɔ daha di mi ŋaa ba kpuba mi sipaaŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu si bul wiaa deeŋba dɛrɛ, u joŋ u woŋbiiŋ a laa u haritooroo sipaaŋ ba mumu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba ku yi Bɛtifagi ari Bɛtani diiriŋ a ku yi peel kubala baa yirɛ Oliv. Ŋii nɛ Yesu liisɛ u haritooroo balia a tiŋba a bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Má mu taŋ-la si hɛ sipaaŋ. Di ma nɛ mua, ma jaŋ na kaku-bie di ba vɔbɔ a kii. Nuu ha buu jila. Má mu puri a kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Di ma níi puru, di ba piɛsɛma a bul di bɛɛ nɛ tii maa puri, má bul di la Tiina Yesu níi chɛ, duu nɛ si di ma puro kaa kɔ.” ");
INSERT INTO sil_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ŋii nɛ ba mu a na wialiŋ kala Yesu fa si bula piba. ");
INSERT INTO sil_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba síi puri kaku-bie-la, u tiina piɛsɛba a bul, “Bɛɛ nɛ tii maa puri kaku-bie-la?” ");
INSERT INTO sil_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŋii nɛ ba bula pu a bul, “La Tiina níi chɛ.” ");
INSERT INTO sil_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋii nɛ ba kɛŋ kaku-bie-la a kaa mu pi Yesu, a wuri ba gɛnniŋ a daŋ kaku-bie-la nyuŋ, aŋ kɛŋ Yesu u jila hɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","U si jil kaku-bie-la aa vɛŋ ŋii, ba joŋ ba gɛnniŋ jɛrɛ woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","U si mu kpagɛ Jerusalɛm, lee-la woŋbiiŋ si lii Oliv peel-la nyuŋ tuu, ni-daŋ-la fa si to Yesu hariŋ suomo jujuɔsɛ a faasa didɛnnɛ Wia a tiŋ u wu-magila-la kala ba si na. ");
INSERT INTO sil_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba bula, “Wia jaŋ pɛ kuoru-la síi kɔ la Tiina Wia doluŋ lɛ. Ba jaŋ hɔŋ ari yarifiɛlaa Wia-jaŋ lɛ. Wia yiriŋ ma jaŋ yirɛ.” ");
INSERT INTO sil_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ŋii nɛ Farisii tiŋŋaa dɔŋsuŋ fa si hɛ ni-daŋ-la tuɔŋ bula pi Yesu a bul, “La kuhiaŋ, ŋaa di ŋ haritooro-la kɛŋ goŋ.” ");
INSERT INTO sil_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ŋii nɛ Yesu bula piba a bul, “Mi jaŋ bula pima, di ba nɛ fa bi goŋ maa ŋaa, tabiaa ma titia jaŋ ŋaa goŋ.” ");
INSERT INTO sil_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu síi mu ŋii, u ku kpagɛ Jerusalɛm a na taŋ-la. U yel a tiŋ taŋ-la niaa wiaa aŋ bul, ");
INSERT INTO sil_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Mi fa cho di ma taŋ niaa deeŋba jiŋ ŋii ma si jaŋ ŋaa a hɔŋ ari yarifiɛlaa nɛ jiniŋ, ama ma bi wuo na. ");
INSERT INTO sil_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tapulii jaŋ yi di ma diŋdɔŋŋɔɔ saa jebiiŋ gollima, di ma sí wuo lii. ");
INSERT INTO sil_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba jaŋ kpu ma nialiŋ kala si hɛ taŋ-la tuɔŋ, ma di ma biiriŋ kala. Tabii-bie ma bira bi jaŋ daŋ u dɔŋɔ lɛ lee-la. Ma bi sɛyɛ bua-la lɛ Wia si kɔ duu laama ta. Ŋii nɛ tii ba jaŋ ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu si mu juu Wia-dia, u suomo kikiri nialiŋ síi yallɛ kiaa dimɛ ");
INSERT INTO sil_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","aŋ bula piba a bul, “Ba ŋmuŋsɛ Wia teniŋ tuɔŋ a bul ari Wia si, u dia jaŋ ŋaa lee-la niaa si jaŋ chuchuɔlɛ Wia, aŋ ka ma miira kaa birimɛ gaari-dia.” ");
INSERT INTO sil_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tapulii-na kala Yesu yie dagɛ niaa Wia-dia-la tuɔŋ. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba ari Ju̱u tiŋŋaa kuhiasiŋ chichɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama ba bi jiŋ woŋbii-la ba si jaŋ to, bɛɛ wiaa nialiŋ kala fa si hɛ dimɛ jegile ninii wialiŋ u síi bul nɛ ari siifiɛsiŋ. ");
INSERT INTO sil_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tapulii kubala Yesu didagɛ niaa Wia-dia lɛ aŋ pɛ bubul Wia wu-zɔmɔ-la wiaa. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba ari Ju̱u tiŋŋaa kuhiasiŋ sii kɔ u teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ba piɛsu a bul, “Dol bɛɛ nɛ ŋ kɛŋ a ŋiŋaa wiaa deeŋba? Kubɛɛ nɛ piŋ doluŋ ŋ ŋiŋaa ŋii?” ");
INSERT INTO sil_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ŋii nɛ Yesu bula piba a bul, “Mi ma jaŋ piɛsɛma wii. Má dagɛmi. ");
INSERT INTO sil_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔɔŋ, nii-la fa síi fo niaa Wii-chuɔlɛ liiŋ, u doluŋ, u lii Wia teeŋ nɛɛ koo nuhuobiine teeŋ nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋii nɛ ba suomo kɛŋ wii-la lilɛrɛ dɔŋɔ lɛ aa bul, “Wu-bɛɛ nɛ laa chɛ di la bul? Di la nɛ bula pu a bul di Wia teeŋ nɛ u lii, u jaŋ piɛsɛla a bul, ‘Bɛɛ nɛ saa tii ma bi wialiŋ u si bula laa dii?’ ");
INSERT INTO sil_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Di la nɛ bira si nuhuobiine teeŋ nɛ, ni-daŋ-la kala si hilimi daha, ba jaŋ yagɛla ari tabiaa, bɛɛ wiaa ba sɛyɛ ari Jɔɔŋ fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ŋii nɛ ba bula pu a bul, “La bi jiŋ u dol-la si lii lee-la.” ");
INSERT INTO sil_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu ma bula piba a bul, “Tɔɔ, mi ma bi jaŋ dagɛma dol-la mi si kɛnɛ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ŋii nɛ Yesu magɛ namaga a pi nialiŋ si hɛ dimɛ a bul, “Baal kubala nɛ fa hɛ dimɛ a bil baga a chɔŋsɛ kiaa si kɛŋ nɛnɛɛ yugɛ a nagɛ chichuɛŋ. Ba yiriŋ nɛ gireps. Ŋii nɛ u paa niaa hɛ baga-la lɛ di ba bibeŋ, aŋ sii mu tiŋtee dɔŋ a dieni dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kialiŋ nɛniŋ si yie, u tiŋ u tiŋtinnaa dɔŋɔ duu mu tiŋtinna-la teeŋ a laa tii-nɛnɛ-la dɔŋsuŋ kaa kɔ. U mu ba kɛnu a ŋmobu aŋ kiru, u miira kɛŋ na-hilliŋ a kaa mu baga tiina teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ŋii nɛ u bira tiŋ u tiŋtinna-la dɔŋɔ maa. U ma bira mu. Nialiŋ ŋmobu maa aŋ hiisu aŋ bira kiru maa, u miirɛ ari na-hilliŋ. ");
INSERT INTO sil_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ŋii nɛ u bira tiŋ ni-tori. Nialiŋ piru maa aŋ kiru ta. ");
INSERT INTO sil_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ŋii nɛ baga-la tiina bul, ‘Wu-bɛɛ nɛ mi jaŋ ŋaa? Mi jaŋ tiŋ mi bii-chooluŋ. Ŋ bi pɔɔ, ba jaŋ zilu.’ Ŋii nɛ u tiŋ bile u mu. ");
INSERT INTO sil_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tiŋtinna-la si nau duu kɔ, ŋii nɛ ba bula pi dɔŋɔ a bul, ‘Baga-la tiina bie nɛ ŋii. Di baga-la tiina nɛ suba, bie deeŋ nɛ jaŋ dii u kiaa. Má leŋ di la kpuu, ka di baga-la ŋaa la kuŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba kɛnu kaa lii baga-la tuɔŋ a kpuu.” Ŋii nɛ Yesu piɛsɛ nialiŋ a bul, “Ɛɛ nɛ baga-la tiina jaŋ ŋaa? ");
INSERT INTO sil_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U jaŋ kɔ a kpu tiŋtinna-la kala aŋ joŋ baga-la a pi ni-tania.” Nialiŋ si nii wialiŋ Yesu si bula, ba si di Wia bi jaŋ sɛi di ba ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ŋii nɛ Yesu beŋba aŋ piɛsɛba a bul, “Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari tiebii-la dii-saaraa si via ta, u nɛ jaŋ ku ŋaa tiebii-duoŋ ba si joŋo bil dia geŋtine. Wiiŋ deeŋ bubuɔŋ nɛ saa ŋaa bɛɛ? ");
INSERT INTO sil_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nii-la kala si tel tiebii-la nyuŋ, u tiina jaŋ yɛrɛ muno muno. Di tiebii-la ma nɛ tel nuu-kala nyuŋ, u jaŋ yɛrɛ u tiina muno muno.” ");
INSERT INTO sil_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŋii nɛ Wia teniŋ kerichiba ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ walimɛ di ba kɛŋ Yesu naa-buasu-la lɛ, bɛɛ wiaa ba jima ari u magɛ namaga-la a tigɛba lɛ nɛ. Ama baa fá nialiŋ si hɛ dimɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ŋii nɛ ba bee chichɛ woŋbii-la ba si jaŋ to a kɛnu. Ba kpal niaa a ŋaa di ba fugi ari ba ŋaa ni-titiiba nɛ. Ba joŋ moribiee piba di ba mu a magisɛ Yesu a piɛsu wiaa a na duu nɛ bul wii chei, di ba wuo to ŋii lɛ a kɛnu a kaa mu hɛ ba kuori-baliŋ nisiŋ lɛ, duu ŋaau ŋii kala u si cho. ");
INSERT INTO sil_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ŋii nɛ nialiŋ ba si hɛ, ba mu Yesu teeŋ, a piɛsu a bul, “La kuhiaŋ, la jima wialiŋ kala ŋ síi bul aŋ didagɛ maa, ba ŋaa wutitiiba nɛ. La jima ari ŋ joŋ niaa kala ba ŋaa kubala nɛ, ŋŋ dagɛ Wia woŋbii-titii nɛ. ");
INSERT INTO sil_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","U ŋaa woŋbii nɛ di la ti̱ŋ laŋpoo a pi Rom tiŋteeŋ kuori-baliŋ ba síi yirɛ Siiza koo? Dagɛla.” ");
INSERT INTO sil_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama Yesu jiŋ ba bubuɔŋ. Ŋii nɛ u piɛsɛba a bul, ");
INSERT INTO sil_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Má kɛŋ moribii-biiŋ kaa kɔ mi bee na. Kubɛɛ nyuŋ nɛ hɛ dimɛ? Kubɛɛ yiriŋ ma nɛ ba tuuro hɛ moribie-la lɛ?” Ŋii nɛ ba si, “Siiza yiriŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ŋii nɛ Yesu bul, “Tɔɔ, má joŋ Rom tiŋteeŋ kuori-bal-la kiaa a pu, aŋ joŋ Wia ma kiaa pu.” ");
INSERT INTO sil_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","U si bul ŋii, ba bi wii-kala na ba si jaŋ wuo to ŋii lɛ kɛnu nialiŋ si hɛ dimɛ sipaaŋ. Wialiŋ u si bula ŋaaba wu-kpuŋkpere, ba niiŋ kala maa. ");
INSERT INTO sil_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ŋii nɛ Sadusii tiŋŋaa dɔŋsuŋ ma kɔ Yesu teeŋ. Niaa deeŋba laa dii ari nialiŋ si suba bira bi jaŋ sii suuŋ lɛ. Ŋii nɛ ba piɛsu a bul, ");
INSERT INTO sil_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“La kuhiaŋ, Moosis dagɛla Wia teniŋ tuɔŋ ari baal nɛ jaa haala, di haal-la ari baal-la nɛ bi bii lula, aŋ ka di baal-la suu, duu ŋaana jaa yo-haal-la a lul biiriŋ pi u malima si suba, di biiri-la chiŋ u nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Naaŋbiiriŋ balipɛ nɛ fa hɛ dimɛ bua kubala lɛ. Ba kuhiaŋ jaa haala. Ba di haal-la bi bii lula, aŋ ka u suu. ");
INSERT INTO sil_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Liamiŋ tiina joŋ haal-la jaa. Ba duu ma bi bii lula, aŋ ka u ma suu. ");
INSERT INTO sil_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Torimuŋ tiina ma joŋ haal-la jaa. U ma ŋii titia nɛ. Ŋii nɛ naaŋbiiri-la balipɛ kala jaa haal-la. Ba kala suu aŋ bi bii lula. ");
INSERT INTO sil_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","U ŋii hariŋ haal-la ma suu. ");
INSERT INTO sil_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tapulii-la niaa si jaŋ sii suuŋ lɛ, baalaa deeŋba balipɛ tuɔŋ kubɛɛ nɛ jaŋ tii haal-la? Ba kala balipɛ nɛ jaau.” ");
INSERT INTO sil_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ŋii nɛ Yesu bula piba a bul, “Baala-la ari haala-la si hɛ ba miisiŋ lɛ lɛɛlɛ, ba níi jaa dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama bua-la lɛ baala-la ari haala-la si jaŋ sii suuŋ lɛ a kɛŋ miisi-la si bi dɛrɛ, ba bira bi jaŋ jaa dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba jaŋ nagɛ Wia tiŋdaaraa a bira bi jaŋ suu. Wia si chisɛba suuŋ lɛ ŋii, ba jaŋ ŋaa Wia biiriŋ. ");
INSERT INTO sil_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moosis fa paala chaasa dagɛ ari ba jaŋ chisɛ nialiŋ si suba suuŋ lɛ di ba wei. U fa bul Wia teniŋ sɛmɛ dɔŋɔ ari la Tiina Wia nɛ ŋaa Abiraham Wia ari Aizik Wia ari Jekɔb ma Wia. Lee-la u fa si bul wiaa a tigɛ tii-bie-la síi dii nyiniŋ lɛ nɛ, u fa bul ŋii. ");
INSERT INTO sil_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","U si bul ŋii daga ari u ŋaa ni-weyee Wia nɛ. U bi jaŋ wuo ŋaa nialiŋ si suba Wia.” ");
INSERT INTO sil_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ŋii nɛ Wia teniŋ kerichiba dɔŋsuŋ bula pu a bul, “La kuhiaŋ, ŋ bul woruŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ba bira bi nyu-duoŋ kɛnɛ di ba piɛsɛ Yesu wii-kala. ");
INSERT INTO sil_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ŋii nɛ Yesu piɛsɛba, “Ɛɛ nɛ ba jaŋ wuo bul ari Kirisito, nii-la Wia si liisa, jaŋ ŋaa Devit nihiliɛrɛ duŋduŋa? ");
INSERT INTO sil_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit titia bula Wia teniŋ sɛmɛ dɔŋɔ ba síi yirɛ Saams a bul, ‘Mi Tiina Wia bula pi mi Tiina, duu hɔŋ u sɛmɛ, ni-duoŋ di-hɔnuŋ, ");
INSERT INTO sil_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","see duu yuo dii u diŋdɔŋŋɔɔ kala dɛrɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit titia yirɛ nia deeŋ u Tiina. Ɛɛ nɛ saa u jaŋ wuo ŋaa Devit nihiliɛrɛ duŋduŋa?” ");
INSERT INTO sil_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ŋii nɛ Yesu bula pi u haritooroo nialiŋ kala sipaaŋ a bul, ");
INSERT INTO sil_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Má kɛŋ ma titia woruŋ Wia teniŋ kerichiba lɛ. Ba yie gugɔllɛ yɔbɔ lɛ ari ba gɛri-duduosuŋ, a cho di niaa jujoŋba jirima a chuchuɔlɛba. Ba yie chichɛ di-hɔŋ-zɔŋŋɔɔ Wii-chuɔlɛ diisiŋ lɛ. Di ba nɛ yirɛba di ba ku dii kiaa, ba cho di ba hɔŋ ni-balaa di-hɔnɔɔ maa. ");
INSERT INTO sil_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba yie fugo chuɔlɛ Wia didieni a kɛŋ yo-haalaa kiaa kaa laa didii. Bua-la lɛ Wia si jaŋ dii ba sariya, ba nɛ jaŋ na hɛɛŋ a kii ba dɔŋsuŋ tiŋŋaa kala.” ");
INSERT INTO sil_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bua kubala Yesu hɛ Wia-dia lɛ a na nialiŋ si kɛŋ kiaa si joŋ ba moribiee bil a pipi Wia. ");
INSERT INTO sil_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ŋii nɛ u bira na yo-haal ma si joŋ amiisiŋba balia a ma hɛ. ");
INSERT INTO sil_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ŋii nɛ u bula pi nialiŋ a bul, “Wutitii nɛ mi bulaa pima, yo-haala deeŋ moribii-bie-la u si joŋo hɛ, u nɛ kii nialiŋ moribie-la kala. ");
INSERT INTO sil_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nialiŋ kala si joŋ moribiee a pi Wia, ba liisa aŋ ka nɛ. Aŋ ka u-na joŋ u summu moribiiŋ kala a hɛ, ku-la kala u si kɛnɛ nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ŋii nɛ Yesu haritooroo dɔŋsuŋ bul wiaa a tigɛ Wia-dia-la lɛ a bul duu zɔmɔ, di u tiebie-la ba si kaa saau ma zɔmɔ, a bira bul ŋii niaa si joŋ ku-zɔŋŋɔɔ a pi Wia ba kaa wasɛ dia-la, ba kala nɛ ŋaa dia-la zɔŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ŋii nɛ Yesu bul, “Bua kubala jaŋ yi, ba jaŋ ŋmoo kiaa deeŋba kala ma síi na a lo. Ba bi jaŋ leŋ di tiebii-bala ma daŋ u dɔŋɔ lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ŋii nɛ ba piɛsɛ Yesu a bul, “La kuhiaŋ, bua bɛɛ lɛ nɛ wiaa deeŋba jaŋ ŋaa? Bɛɛ kiaa nɛ la jaŋ na, ka di wiaa deeŋba-na ŋaa?” ");
INSERT INTO sil_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ŋii nɛ Yesu bula piba a bul, “Má kɛŋ ma titia woruŋ di nuu-kala síma nyisu,” a bira bul, “Niaa jaŋ yugɛ a kɔ a joŋ mi yiriŋ hɛ ari ba nɛ ŋaa Kirisito, a bul di bua-la dunia si jaŋ dɛrɛ kpaga nɛ. Ama ma sí ba hariŋ to. ");
INSERT INTO sil_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma jaŋ nii ari laaliŋ ari yuosuŋ hɛ daha a hɛ di-boloo maa. Di ma nɛ ku nii ŋii, ma sí leŋe di ma bɔisiŋ joŋ. Wiaa deeŋba kala jaŋ ŋaa bal, ama u ŋii saa bi naga ari dunia didɛriŋ yie nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ŋii nɛ Yesu bira bul, “Tiŋteeŋ dɔŋɔ niaa jaŋ sii a mu yuo tiŋteeŋ dɔŋɔ niaa. Taŋ kuoro ari u niaa jaŋ sii giri a mu yuo kuoro dɔŋɔ ari u niaa. ");
INSERT INTO sil_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tiŋteeŋ jaŋ zigili woruŋ, losuŋ ma jaŋ juu, nyanyalaa jaŋ juu niaa leree yugɛ, wu-bal-lɔrunuŋ ari wu-magilaa kala jaŋ ŋaa wia nyuŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ka di wiaa deeŋba kala-na ŋaa, ba jaŋ kɛsɛma a to naasiŋ dɔgisɛma. Ba jaŋ joŋma hɛ niaa nisiŋ lɛ di ba dii ma sariya Wii-chuɔlɛ diisiŋ lɛ a kɛŋma tɔ dia. Ba jaŋ kɛŋma kaa mu kuoroo ari ni-balaa sipaaŋ a tiŋ mi wiaa. ");
INSERT INTO sil_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bua deeŋ lɛ nɛ ma jaŋ wuo na woŋbiiŋ a bul Wia wu-zɔmɔ-la. ");
INSERT INTO sil_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Má kɛŋ ma titia hɛ dɔŋɔ lɛ a sí leŋe duu walimɛma ŋii ma si jaŋ bul wiaa a laa ma titia, ");
INSERT INTO sil_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bɛɛ wiaa mi jaŋ joŋ wu-jimiŋ a hɛ ma nyuŋ lɛ di ma bul wialiŋ ma diŋdɔŋŋɔɔ si bi jaŋ wuo kaa lɛrɛ ari wutitii dee. ");
INSERT INTO sil_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma nyimmaba ari ma naaŋbiiriŋ ari ma doho niaa ari ma naŋdɔŋsuŋ paala jaŋ joŋma hɛ ma diŋdɔŋŋɔɔ nisiŋ lɛ. Ba jaŋ kpu ma dɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nuu-kala jaŋ bɛrɛma a tiŋ mi wiaa. ");
INSERT INTO sil_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama ma kuŋ nyu-puŋ ma bi jaŋ lɛl. ");
INSERT INTO sil_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Di ma nɛ nyalima, ma jaŋ laa ma miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ŋii nɛ Yesu bira bul, “Di ma nɛ na di laali-yuoroo golli Jerusalɛm, ma jaŋ jiŋ ari taŋ-la jaŋ tel lɛɛlɛ. ");
INSERT INTO sil_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ŋii-na má leŋ di nialiŋ si hɛ Judiya lɛ fá mu jil peelee nyuŋ. Nialiŋ ma si hɛ taŋ-la tuɔŋ, u maga di ba lii taŋ-la tuɔŋ. Nialiŋ ma si hɛ ba bagisiŋ lɛ, ma sí miira juu taŋ-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tapulii-la Wia jaŋ dɔgisɛ Iziral niaa, a leŋ di wialiŋ kala ba si bula Wia teniŋ tuɔŋ sɛnɛ ku bal. ");
INSERT INTO sil_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Haala-la si kɛŋ luoroo ari haala-la si kɛŋ bii-mulluŋ baa wasɛ yiliŋ, tapulia-la lɛ ba jaŋ na hɛɛŋ. Tiŋtee-la kala jaŋ na hɛɛŋ woruŋ. Wia jaŋ na baaniŋ tiŋteeŋ deeŋ niaa nyuŋ a dɔgisɛba. ");
INSERT INTO sil_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba jaŋ kpu dɔŋsuŋ ari tokobiee, aŋ kɛsɛ dɔŋsuŋ di ba ma ŋaa yosuŋ tiŋtee-dɔŋsuŋ lɛ, ka nialiŋ si bi Ju̱u tiŋŋaa ŋaa yigi Jerusalɛm taŋ-la kala lo, see bua-la yie di Wia piba woŋbiiŋ di ba leŋ.” ");
INSERT INTO sil_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ŋii nɛ Yesu bira bul, “Niaa jaŋ na wu-magilaa wii-pɔsuŋ ari chɛnɛ ari chɛŋwulaa lɛ. Dunia kala lɛ, niaa bi jaŋ jiŋ wii-la kala lɛ ba si hɛ. Di mugi-balaa níi huuru, fawulluŋ jaŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Fawulluŋ jaŋ kɛŋ niaa di ba yeŋŋi a tiŋ ba síi yiɛlɛ wii-la si jaŋ ŋaa dunia kala lɛ. Ba jaŋ kiri wia nyuŋ kialiŋ kala si kɛŋ doluŋ di ba lii ba leree. ");
INSERT INTO sil_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ŋii lɛ nɛ ma jaŋ na mi-na Nuhuobiine Bie di mi to duoŋbiliŋbaaniŋ tuɔŋ kuu tuu. Mi jaŋ kɛŋ doluŋ a chaanɛ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Di wiaa deeŋba suomo a ŋiŋaa, má sii chiŋ a kɛŋ ma digilaa wuoli, bɛɛ wiaa bua-la lɛ Wia si jaŋ laama ta yie nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ŋii nɛ Yesu magɛ namaga piba a bul, “Má bee na tutogo ari tiisiŋ dɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Di ma nɛ na tiisiŋ di ba suomo tutɔsɛ, ma jima yibiiniŋ jua nɛ. ");
INSERT INTO sil_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ŋii titia nɛ, di ma nɛ na wiaa deeŋba kala mi síi dagɛma di baa ŋaa, ma jiŋ ari Wia kuorii-la kpaga nɛ. ");
INSERT INTO sil_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wutitii nɛ, mi bulaa pima, ma lɛɛlɛ niaa deeŋba si hɛ ma miisiŋ lɛ, ma bi jaŋ suu, ka wiaa deeŋba ŋaa bal. ");
INSERT INTO sil_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wia nyuŋ ari tiŋteeŋ kala jaŋ dɛrɛ, ama wialiŋ mi si bula bi jaŋ lɛl. ");
INSERT INTO sil_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Má kɛŋ ma titia, a sí wu-fuoloo ŋiŋaa, a sí siniŋ nyua bubugi. Ma sí leŋe di dunia kiaa wiaa walimɛma. Di wiaa deeŋba níi walimɛma, tapulii-la mi-na Nuhuobiine Bie si jaŋ kɔ, u jaŋ guu ku di-ma lɛ a nagɛ ba si hɛ bɛrɛ́, kiaa vɛnɛ mu juu-u lɛ aŋ bi jiŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tapulii-la jaŋ kɛŋ dunia nuu-kala lee-kala lɛ. ");
INSERT INTO sil_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Má pɔ a chuchuɔlɛ Wia bua-na kala lɛ. Di ma nɛ ŋaa ŋii, ma jaŋ kɛŋ doluŋ a lii wialiŋ kala si jaŋ ŋaa lɛ ari yarifiɛlaa a wuo chiŋ mi-na Nuhuobiine Bie sipaaŋ.” ");
INSERT INTO sil_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu fa yie hɛ Wia-dia lɛ wiihɛyɛ ari chichuɔŋ kala a didagɛ niaa. Di didaaniŋ nɛ yie-na kala, u yie mu Oliv pel-la nyuŋ nɛ a piŋ. ");
INSERT INTO sil_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Siipuuraa-na kala saa niaa yie mu Wia-dia di ba jegile nii wialiŋ u síi bul. ");
INSERT INTO sil_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tapulaa deeŋba, diisiŋ kieliŋ gbiele-la kpaga nɛ, gbiele-la lɛ ba si yie dii boroboro-la si bi si-buruŋ kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba wiwalimɛ di ba na woŋbii-la ba si jaŋ to a kpu Yesu di nialiŋ bi jiŋ, bɛɛ wiaa baa fá nialiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ŋii nɛ Sitaani ku juu baal kubala. U fa ŋaa Yesu haritooroo fii ari balia-la dɔŋɔ nɛ. U yiriŋ nɛ Judas. Baa yiru Isikarɔt ma nɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ŋii nɛ Judas sii mu bula pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia-dia kuhiasiŋ ŋii u si jaŋ to a kɛŋ Yesu yalla piba. ");
INSERT INTO sil_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba tuɔŋ tɔrɛ. Ba sɛi ari ba jaŋ pu moribiee. ");
INSERT INTO sil_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ŋii nɛ Judas sɛi, a suomo chichɛ woŋbii-la u si jaŋ to a kɛŋ Yesu yalla piba di nialiŋ bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ŋii nɛ gbiele-la lɛ ba si yie dii boroboro-la si bi si-buruŋ kɛnɛ yi, bua-la lɛ u si maga di ba kpu pie-bie-la ba si jaŋ kaa ŋaa gbiele-la kudiilee. ");
INSERT INTO sil_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ŋii nɛ Yesu tiŋ Piita ari Jɔɔŋ a bul di ba mu ŋaa ba diisiŋ kieliŋ gbiele kudiilee di ba dii. ");
INSERT INTO sil_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ŋii nɛ ba piɛsu a bul, “Nii nɛ ŋŋ chɛ di la ŋaa kudiile-la?” ");
INSERT INTO sil_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","U bula piba a bul, “Bee na, di ma nɛ juu taŋ tuɔŋ, ma jaŋ cheŋ baal kubala duu kori loŋ ari liiŋ. Má to u hariŋ juu dia-la u síi juu. ");
INSERT INTO sil_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Di ma nɛ mua, má bula pi dia-la tiina a bul, ‘La kuhiaŋ si la piɛsiŋ di nii lɛ nɛ nuhuɔraa dia hɛ, di ba di u haritooroo juu hɔnɔ dii diisiŋ kieliŋ gbiele-la kudiilee?’ ");
INSERT INTO sil_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U jaŋ dagɛma dii-bal kubala. U ŋaa lusuŋ nyuŋ dia nɛ. Ba wasu kala. Lee-la nɛ ma jaŋ ŋaa kudiile-la.” ");
INSERT INTO sil_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ŋii nɛ ba mu a na wialiŋ kala u si bula piba ari ba jaŋ na, a ŋaa diisiŋ kieliŋ gbiele kudiile-la ba dii. ");
INSERT INTO sil_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bua-la si yie di ba dii kudiile-la, Yesu ari u naŋzɔɔba kala hɔŋ di ba dii kiaa. ");
INSERT INTO sil_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ŋii nɛ Yesu bula piba a bul, “Mi fa paala cho di la di ma dii kiaa deeŋba, aŋ ka di mi-na na hɛɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mi jaŋ bula pima ari mi bira bi jaŋ kɔ di mi dii kudiilee deeŋba, see bua-la lɛ Wia kuorii-la si jaŋ kɔ. Ŋii lɛ nɛ la jaŋ jiŋ kudiile-la la si die bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ŋii nɛ u joŋ nyunyuala ari siniŋ a lɔllɛ Wia aŋ joŋo pi u naŋzɔɔba-la a bul, “Má laa nyunyuala deeŋ ari siniŋ a kaa kpaa ma titia. ");
INSERT INTO sil_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mi bulaa pima, mi bira bi jaŋ kɔ di mi nyua siniŋ deeŋ, see bua-la lɛ Wia kuorii-la si jaŋ kɔ.” ");
INSERT INTO sil_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ŋii nɛ Yesu bira joŋ boroboro a lɔllɛ Wia aŋ kaa chɔgɛ chɔgɛ, a joŋo piba aŋ bul, “Mi yaraa nɛ ŋii. Mi joŋo pi Wia a tiŋ ma wiaa, má laa dii. Má ŋaa ŋii a liliisi mi wiaa.” Ŋii nɛ ba dii. ");
INSERT INTO sil_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba si dii kialiŋ dɛrɛ, u bira joŋ nyunyuala ari siŋ-la a piba aŋ bul, “Nyunyuala ari siniŋ deeŋ ŋaa ni̱i-falii nɛ Wia ta. Mi chaliŋ si jaŋ jaasɛ ma wiaa nɛ tii Wia ta ni̱i-la. ");
INSERT INTO sil_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Má bee na, nii-la si jaŋ kɛŋmi yallɛ hɛ la tuɔŋ nɛ, la kala didii kiaa. ");
INSERT INTO sil_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mi-na Nuhuobiine Bie, mi jaŋ suu ari Wia si dagɛ ŋii, ama nii-la si jaŋ joŋmi yallɛ, u jaŋ na hɛɛŋ yugɛ.” ");
INSERT INTO sil_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ŋii nɛ Yesu naŋzɔɔba-la suomo pipiɛsɛ dɔŋɔ ari ba tuɔŋ kubɛɛ nɛ jaŋ ŋaa ŋii? ");
INSERT INTO sil_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ŋii nɛ Yesu haritooroo kɛŋ ba tuɔŋ kuhiaŋ wiaa kaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu bula piba a bul, “Nialiŋ si bi Ju̱u tiŋŋaa ŋaa kɛŋ ba doluŋ kaa hɔŋ ba niaa nyuŋ nɛ. Kuoroo dɔŋsuŋ síi beŋ niaa, ba cho di nialiŋ ba síi beŋ kɛŋba kaa yiyirɛ ni-zɔmɔ. ");
INSERT INTO sil_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama u bi maga di ma ŋiŋaa ŋii. U maga di ma tuɔŋ kuhiaŋ nɛ birimɛ haŋbie, di ma sipaa-laara ma tiŋ tiŋtiŋŋaa pipima. ");
INSERT INTO sil_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nuu nɛ hɔnɔ, aŋ ka u dɔŋɔ ŋaa kudiilee pupu u didii. Ba di nii-la si ŋaa kudiile-la pupu, ba tuɔŋ kubɛɛ nɛ yuga? Nii-la si hɔnɔ, ka ba ŋaa kudiilee pupu, u nɛ yuga. Ama mi-na hɛ ma tuɔŋ a tiŋ tiŋtiŋŋaa pipima. ");
INSERT INTO sil_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mi si hɛ ma teeŋ ŋii, mi na hɛɛŋ woruŋ. Aŋ ka ma chiŋ mi sɛmɛ aŋ bimi via ta. ");
INSERT INTO sil_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mi Nyimma pimi doluŋ nɛ di mi ŋaa kuori-baliŋ. Ŋii titia nɛ mi ma jaŋ pima doluŋ di ma ŋaa kuori-balaa. ");
INSERT INTO sil_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","La di ma kala jaŋ dii kudiilee Wia kuorii-la tuɔŋ. Ma jaŋ hɔŋ kuori-kpasinniŋ nyuŋ a dii Iziral tiŋŋaa ta-geŋtisi-la fii ari balia-la sariya.” ");
INSERT INTO sil_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ŋii nɛ Yesu bula pi Saamɔŋ Piita a bul, “Saamɔŋ, Sitaani laa woŋbiiŋ nɛ duu magisɛ ma kala, duu pɔrɛ ni-zɔŋŋɔɔ ni-bɔŋŋɔɔ lɛ, ari paara si yie chaarɛ mii-jɔruŋ ta, aŋ ka mii-biiŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama mi chuɔlɛ Wia pi ŋ-na Saamɔŋ nɛ di ŋ yarida sí lɛl. Di ŋ nɛ miira kɔ mi teeŋ, pɛ ŋ naaŋbiiriŋ ma lɛ di ba chiŋ ba yarida naaŋ lɛ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ŋii nɛ Piita bula pu a bul, “Mi Tiina, mi síi to ŋ hariŋ ŋii, di ba nɛ tɔŋ dia maa, mi paala ŋaa siri nɛ di ba kɛŋmi ma tɔ. Di ba kpuŋ maa, mi ma ŋaa siri nɛ di mi suu.” ");
INSERT INTO sil_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ŋii nɛ Yesu bula pi Piita a bul, “Piita, ji-bele bi jaŋ yel, aŋ ka di ŋ bul naaŋsiiŋ butori ari ŋ bimi jiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ŋii nɛ Yesu piɛsɛ u haritooroo a bul, “Bua-la lɛ mi si tiŋma, ma lii aŋ bi moribiee koo sulli-gbaŋsiŋ ma koro, a bi nɛŋtɛŋŋɛɛ tuŋ bulia bulia ma koro. Ma si mu ŋii, ma chɛ kuŋ nɛ kaa?” Ba bul di ba bi kuŋ-kala chɛ ka. ");
INSERT INTO sil_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ŋii nɛ Yesu bula piba a bul, “Ama lɛɛlɛ ma ku-la kala si kɛŋ moribiee koo sulli-gbaŋa, u maga duu joŋ. Ma ku-la ma kala si bi tokobii kɛnɛ, u maga duu joŋ u gɛri-baliŋ yallɛ nɛ a yɔɔ dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ŋii nɛ ba ŋmuŋsɛ Wia teniŋ tuɔŋ. Ba bula ari ba jaŋ kɛnu pɛ wu-bɔŋ ŋiŋaaraa lɛ. Wiaa deeŋba ba ŋmuŋsa a tigɛmi lɛ nɛ. Ba kala jaŋ ŋaami lɛ nɛ, bɛɛ wiaa wialiŋ kala ba si ŋmuŋsa a tigɛmi lɛ, ba kala jaŋ sɛnɛ ŋaa a dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŋii nɛ u haritooroo bula pu a bul, “La Tiina, bee na, tokobiee balia nɛ ŋla.” Ŋii nɛ Yesu bula piba a bul, “Má leŋ di wii-la kala bal.” ");
INSERT INTO sil_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ŋii nɛ Yesu lii Jerusalɛm lɛ a jil peel-la nyuŋ ba síi yirɛ Oliv, ari u si vɛnɛɛ ŋaa ŋii. Ŋii nɛ u haritooroo to u hariŋ mu. ");
INSERT INTO sil_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba si yi lee-la, u bula piba a bul, “Má chuɔlɛ Wia, di Sitaani sí wuo nyisɛma.” ");
INSERT INTO sil_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","U si bul ŋii dɛrɛ, u kieli u haritooro-la a mu sipaaŋ muapilii, a tuu kpirimi duu chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U chuɔlɛ Wia a bul, “Mi Nyimma, di ŋ tuɔtɔruŋ lɛ nɛ, liisɛ hɛɛ-la síi kɔmi lɛ. Ama mi-na tuɔtɔruŋ lɛ dee ŋ-na tuɔtɔruŋ lɛ nɛ.”  ");
INSERT INTO sil_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ŋii nɛ Wia tiŋdaara kubala lii wia nyuŋ a ku tuu u teeŋ a pu doluŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","U tuɔŋ faasa chei kiŋkɛŋ kiŋkɛŋ. Ŋii nɛ u faasa chuɔlɛ Wia ari siifiɛsiŋ. U suoluŋ paala nagɛ chaliŋ a tutuu tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","U si chuɔlɛ Wia dɛrɛ, u sii a miira mu u haritooroo teeŋ, di ba piŋ doŋ, bɛɛ wiaa ba tuɔŋ cheye nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ŋii nɛ u piɛsɛba, “Ma sɛnɛ piŋ nɛɛ? Má sii chuɔlɛ Wia, di Sitaani sí wuo nyisɛma.” ");
INSERT INTO sil_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ha síi bul wiaa ŋii, di ni-daŋ kɔ. Yesu haritooro-la fii ari balia-la dɔŋɔ nɛ kɛŋba kaa kɔ lee-la. U yiriŋ nɛ Judas. Ba si kɔ, Judas mu Yesu teeŋ a guoru. ");
INSERT INTO sil_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ŋii nɛ Yesu bul, “Judas, ŋ sɛnɛ guorimi ŋla nɛ di ŋ joŋ mi-na Nuhuobiine Bie yallɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu haritooro-la fa si hɛ dimɛ a na wii-la síi ŋaa, ŋii nɛ ba piɛsɛ Yesu a bul, “La Tiina, ŋŋ chɛ di la kɛŋ la tokobie-la taba nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ŋii nɛ Yesu haritooroo dɔŋɔ joŋ tokobii, a ta nialiŋ dɔŋɔ na-diiŋ digiliŋ kiɛsɛ. Baal-la fa ŋaa nii-la si kpu pusuŋ pipi Wia kuhiaŋ yomo nɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ŋii nɛ Yesu bul di u maga nɛ, di ba leŋ. U si bul ŋii, u digi baal-la digiliŋ lɛ a ŋaa u fiɛlɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ŋii nɛ Yesu piɛsɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia-dia kuhiasiŋ ari ba taŋ kuhiasi-la si kɔ di ba kɛnu, a bul, “Mi ŋaa gaaru nɛɛ? Ma síi kori tokobiee ari taŋguloo a kukɔ di ma kɛŋmii? ");
INSERT INTO sil_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","La di ma kala nɛ fa hɛ Wia-dia lɛ tapulii-na kala, aŋ ka ma bi walima di ma kɛŋmi dimɛ. Ama bua deeŋ lɛ nɛ birimiŋ tiina Sitaani pima doluŋ ma wuo kɔ di ma kɛŋmi.” ");
INSERT INTO sil_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ŋii nɛ ba kɛŋ Yesu. Ba kɛnu kaa mu nii-la si kpu pusuŋ pipi Wia kuhiaŋ dia, ka Piita daa tuto ba hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Di ba hɛ nyiniŋ kaala tuɔŋ. Ba si jua, Piita mu pɛ nialiŋ síi wieni nyiŋ-la lɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Toli-bie kubala ma hɛ dimɛ. U fa ŋaa dia-la tiŋtinnu nɛ. U na Piita duu hɔnɔ aa wieni nyiniŋ. U bul, “Baala deeŋ ma faa to Yesu hariŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ŋii nɛ Piita si, “Haal, mi paala buu jiŋ.” ");
INSERT INTO sil_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Muapilii di baal kubala ma nau a bul, “Ŋ ma ŋaa ba dɔŋɔ nɛ.” Ŋii nɛ Piita bira bul duu dee. ");
INSERT INTO sil_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","U bi diene bira di baal dɔŋ ma nɛ ŋii a pɛsɛ ari Piita ŋaa Yesu haritooroo dɔŋɔ nɛ, bɛɛ wiaa u ma ŋaa Galilii tiina nɛ. ");
INSERT INTO sil_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ŋii nɛ Piita bira bula pu a bul, “Baal, mi paala bi wii-la ŋ síi bul jiŋ.” Piita síi bul ŋii, u bi bula dɛrɛ di ji-bele yele. ");
INSERT INTO sil_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ŋii nɛ la Tiina Yesu daasɛ a beŋ Piita. U liisi wii-la Yesu fa si bula pu ari u jaŋ bul naaŋsiiŋ butori ari u bi u-na Yesu jiŋ, ka di ji-bele-na yel. ");
INSERT INTO sil_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ŋii nɛ Piita lii a faasa yel. ");
INSERT INTO sil_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ŋii nɛ nialiŋ si pɔ Yesu sieru lɛ aŋ ŋmobu. ");
INSERT INTO sil_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba vɔɔ u siaa tɔ a ŋmobu aŋ piɛsu duu dagɛ nii-la si ŋmobu. ");
INSERT INTO sil_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba bul wiaa ma yugɛ a tuusu. ");
INSERT INTO sil_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Taŋ si pula, Ju̱u tiŋŋaa taŋ kuhiasiŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba, ba hilimi a leŋ ba kɛŋ Yesu kɔ ba sipaaŋ, lee-la ba si yie hilime vuvuurɛ wiaa. ");
INSERT INTO sil_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ŋii nɛ ba piɛsu a bul, “Dagɛla, ŋ nɛ ŋaa nii-la Wia si liisaa?” Ŋii nɛ Yesu bula piba a bul, “Di mi nɛ bula pima maa, ma bi jaŋ laa dii. ");
INSERT INTO sil_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Di mi nɛ saa bira piɛsɛma wii maa, ma bi jaŋ bul wii-kala, ");
INSERT INTO sil_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ama a lii lɛɛlɛ a kaa mu mi-na Nuhuobiine Bie jaŋ hɔŋ Wii-baliŋ sɛmɛ, ni-duoŋ di-hɔnuŋ.” ");
INSERT INTO sil_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ŋii nɛ ba kala piɛsu a bul, “Ŋ nɛ saa ŋaa Wia Bie koo?” Ŋii nɛ Yesu bula piba a bul, “Ma bul woruŋ nɛ, mi nɛ sɛnɛ ŋaa Wia Bie.” ");
INSERT INTO sil_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ŋii nɛ nialiŋ bul, “La bira bi siada tiina kala ka chɛ. La titia nia wii-la u si bula nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ŋii nɛ niaa deeŋba kala sii, a kɛŋ Yesu a kaa mu Paalit teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dimɛ nɛ ba suomo a bul wialiŋ u si ŋaa chei a bul, “La kɛŋ baala deeŋ duu nyisɛ la niaa di ba via la woŋbii-la la síi to, aŋ bul di ba sí laŋpoo ma time pi Rom tiŋteeŋ kuori-baliŋ. U bira bula a tigɛ u titia lɛ di u nɛ ŋaa Kirisito, nii-la Wia si liisa, a bul duu ŋaa kuoro ma.” ");
INSERT INTO sil_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ŋii nɛ Paalit piɛsu a bul, “Ŋ nɛ ŋaa Ju̱u tiŋŋaa kuoro koo?” Yesu bula pu a bul, “Oo, mi nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ŋii nɛ Paalit bula pi nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ni-daŋ-la kala si hilime a bul, “Mi bi wii-la na baala deeŋ si ŋaa chei a magɛ di ba kpuu.” ");
INSERT INTO sil_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ŋii nɛ nialiŋ síi bul Yesu teeŋ ha pɛsɛ a bul, “U dagɛ niaa a ŋaa ba ŋiŋaa taawɛi nɛ. U suomi ŋii Galilii lɛ nɛ, a sii kɔ Judiya tiŋteeŋ, a gɔllɛ lee-la kala aa dagɛba, a ŋaa ba ŋiŋaa taawɛi aŋ lɛɛlɛ kɔ Jerusalɛm ma ŋla.” ");
INSERT INTO sil_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paalit si nii ari Yesu lii Galilii nɛ, u piɛsɛ nialiŋ síi bul Yesu teeŋ a bul, “Baala deeŋ ŋaa Galilii tiina nɛɛ?” Ŋii nɛ ba bula pu di kuoro Hɛrɔd nɛ faa beŋ tiŋtee-la Yesu si lia. ");
INSERT INTO sil_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paalit si nii ŋii, u ŋaa ba kɛnu kaa mu Hɛrɔd teeŋ. Bua-la lɛ di Hɛrɔd hɛ Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɛrɔd tuɔŋ kala tɔrɛ u si na Yesu, bɛɛ wiaa u nii u wiaa faafaa kala nɛ a yie chichɛ duu nau. U faa chɛ di Yesu ŋaa wu-kpuŋkpere nɛ duu na. ");
INSERT INTO sil_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ŋii nɛ Hɛrɔd piɛsɛ Yesu wiaa yugɛ, ama u bi wii bula. ");
INSERT INTO sil_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Wia teniŋ kerichiba-la sii tuɔra mu Yesu lɛ a faasa bul u teeŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛrɔd ari u laali-yuoroo sieri Yesu lɛ a dɔgisu, aŋ leŋ ba joŋ gɛri-baliŋ ku-zɔŋ kubala laalu, aŋ miira kɛnu mu Paalit teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hɛrɔd ari Paalit faa yuo dɔŋɔ nɛ. A lii tapulii-la nɛ, ba siŋ a dii naŋdɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ŋii nɛ Paalit yirɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ ari niaa dɔŋsuŋ a bula piba a bul, ");
INSERT INTO sil_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ma kɛŋ baala deeŋ kaa kɔ mi teeŋ a bula pimi ari u ŋaa di niaa via woŋbii-la la síi to nɛ. Mi saa piɛsu ma kala sipaaŋ. Wialiŋ ma síi bul u teeŋ a bul duu cheye, mi bi ba tuɔŋ kubala ma na duu ŋaa chei. ");
INSERT INTO sil_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛrɔd ma si bi na u si ŋaa wii-la chei, ŋii nɛ tii u leŋ ba bira kɛnu kaa kɔ daha. Má bee na, baala deeŋ bi wii-kala ŋaa chei a magɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mi jaŋ leŋ di ba viiru aŋ joŋo ta.”  ");
INSERT INTO sil_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ama diisiŋ kieliŋ gbiele-la nɛ yie-na kala, ba yie leŋ Paalit liisɛ daŋsarikaba tuɔŋ kubala nɛ a ta, nii-la Ju̱u tiŋŋaa si cho di ba liisa. ");
INSERT INTO sil_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ŋii nɛ nialiŋ kala kpia goŋ a bul di ba kpu Yesu aŋ liisɛ Barabas piba. ");
INSERT INTO sil_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bua kubala lɛ, niaa sii ŋaa taawɛi nɛ ba ta-baliŋ lɛ. Barabas kpu nuu, ŋii nɛ tii ba kɛnu mu tɔ dia. ");
INSERT INTO sil_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paalit si cho duu joŋ Yesu ta, ŋii nɛ u bira suomo bul wiaa pi ni-daŋ-la. ");
INSERT INTO sil_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama ba faasa kpia goŋ a bul, “Má kpaasu daa-gɛsɛɛ nyuŋ, má kpaasu daa-gɛsɛɛ nyuŋ!” ");
INSERT INTO sil_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ŋii nɛ Paalit piɛsɛba naaŋsiiŋ butorimuŋ a bul, “Bɛɛ nɛ tii? Bɛɛ kuŋ nɛ baala deeŋ ŋaa chei, ka mi-na bi na? Mi-na bi na u si ŋaa wii-la chei a magɛ di ba kpuu. Mi jaŋ leŋ di ba viiru aŋ joŋu ta.” ");
INSERT INTO sil_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka ba ha pɛsɛ, a faasa kpia goŋ a bul, “U maga di ba kɛŋ Yesu a kpaasɛ daa-gɛsɛɛ nyuŋ nɛ.” Ba síi ŋaa goŋ ŋii, Paalit ku sɛi ba kua ");
INSERT INTO sil_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","a bul di ba kɛŋ Yesu kpaasɛ daa-gɛsɛɛ nyuŋ, ari nialiŋ fa si sul ŋii. ");
INSERT INTO sil_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ŋii nɛ Paalit liisɛ nii-la ba fa si cho a ta, nii-la ba fa si kaa tɔ dia a tiŋ u si ŋaa taawɛi a kpu niaa lɛ. U joŋ Yesu a hɛ ba nisiŋ lɛ di ba ŋaa wii-la ba si cho. ");
INSERT INTO sil_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ŋii nɛ ba kɛŋ Yesu kaa lii di ba kaa mu kpaasɛ daa-gɛsɛɛ nyuŋ. Ba síi mu ŋii, ba cheŋ baal kubala baa yirɛ Saamɔŋ a lii Sariini, duu lii baga a jujuu Jerusalɛm. Ba kɛnu a joŋ daa-gɛsɛ-la baasu a ŋaa u kaa tuto Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ni-daŋ-la ma to u hariŋ. Ba tuɔŋ haalaa yuga a yiyel Yesu wiaa. ");
INSERT INTO sil_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ŋii nɛ Yesu miira daasɛba aŋ bula piba a bul, “Jerusalɛm haalaa, ma sí mi wiaa yel. Má yel ma titia ari ma biiriŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bee na tapulaa ka kɔ nɛ, niaa jaŋ bul, ‘Ha-piraa ari haala-la si bi biiriŋ lula di ba diɛsɛ, ba tuɔŋ jaŋ tɔrɛ.’ ");
INSERT INTO sil_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bua-la lɛ nɛ niaa jaŋ bul di peelee tele tɔba, di duŋdolluŋ ma jɛrɛ tɔba. ");
INSERT INTO sil_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mi si nagɛ tii-weyiŋ, aŋ ka ba dɔgisɛmi ŋla, ɛɛ nɛ ba jaŋ ŋaama ma lɛ, ma ma si nagɛ tii-hilia lɛ?” ");
INSERT INTO sil_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ba si kɛŋ Yesu mu ŋii, ba kɛŋ ni-bɔŋŋɔɔ balia ma kaa mu di ba kpuba a pɛ Yesu lɛ. ");
INSERT INTO sil_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋii nɛ ba mu yi lee kubala baa yirɛ nyu-kuŋkogulo. Ba si yi lee-la, ba joŋ Yesu ari ni-bɔmɔ-la balia a kpaasɛba daa-gɛsɛɛ nyuŋ. Dɔŋɔ hɛ daa-gɛsɛɛ nyuŋ si hɛ Yesu na-diiŋ, dɔŋɔ ma hɛ daa-gɛsɛɛ nyuŋ si hɛ u na-gua. ");
INSERT INTO sil_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ŋii nɛ Yesu chuɔlɛ Wia a bul, “Mi Nyimma, joŋ wii-la ba si ŋaa a chɛba, bɛɛ wiaa ba bi jiŋ wii-la kala ba síi ŋaa.” Ŋii nɛ ba tɔŋsɛ Yesu gɛnniŋ wiaa di ba kpaa, a jiŋ gɛri-la nuu-kala si jaŋ laa. ");
INSERT INTO sil_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Niaa dɔŋsuŋ ma chiŋ dimɛ a bibeŋ, aŋ ka Ju̱u tiŋŋaa kuhiasiŋ sisieru lɛ a bul, “Duu nɛ ŋaa Kirisito, nii-la Wia si liisa, má leŋ duu laa u titia ta yeii. U wuo laa niaa tita nɛ.” ");
INSERT INTO sil_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Laali-yuoroo ma sieru lɛ a ŋaa siniŋ si nyala kaa mu pu duu nyua ");
INSERT INTO sil_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aŋ bula pu duu nɛ ŋaa Ju̱u tiŋŋaa kuoro, duu laa u titia ta. ");
INSERT INTO sil_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba ma ŋmuŋsa mɛrɛ u daa-gɛsɛ-la lɛ a bul, “Ju̱u tiŋŋaa kuoro nɛ ŋla.” ");
INSERT INTO sil_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ŋii nɛ ni-bɔmɔ-la dɔŋɔ ma si sagɛ daa-gɛsɛɛ nyuŋ tuusɛ Yesu a bul, “Ŋ nɛ ŋaa nii-la Wia si liisa koo? Saa laa ŋ titia ta aŋ pɛ laala ma ta.” ");
INSERT INTO sil_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ŋii nɛ ni-bɔmɔ-la dɔŋ-la kpiau lɛ a bula pu a bul, “Ŋ bi Wia ka fáa? La duu kala nɛ juu wu-bala. ");
INSERT INTO sil_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","U maga di ba ŋaala-na ŋii nɛ, bɛɛ wiaa la ŋaa wu-bɔŋ nɛ, aŋ ka u-na bi wii-kala ŋaa chei.” ");
INSERT INTO sil_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ŋii nɛ aŋ ka u bula pi Yesu a bul, “Yesu, di ŋ nɛ dii kuoruŋ, liisi mi ma wiaa.” ");
INSERT INTO sil_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ŋii nɛ Yesu bula pu a bul, “Wutitii nɛ mi bulaa piŋ, la diŋ kala jaŋ hɛ Wia-jaŋ jiniŋ.” ");
INSERT INTO sil_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wia si ku magɛ nyu-gbaŋa, leriŋ kala biri lim a mu yi didaaniŋ, ka leriŋ bira pullɛ. ");
INSERT INTO sil_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Patiisa nɛ fa hɛ Wia-dia tuɔŋ. Ba kaa kɛrɛ. U kiɛsɛ balia. ");
INSERT INTO sil_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ŋii nɛ ka Yesu faasa yirɛ a bul, “Mi Nyimma, mi joŋ mi titia a hɛ ŋ nisiŋ lɛ.” U bul ŋii nɛ aŋ wiesi u wiesi kati aŋ suu. ");
INSERT INTO sil_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ŋii nɛ di laali-yuoroo zɔlɔ kuhiaŋ kubala fa chiŋ dimɛ. U na wii-la si ŋaa, a dɛnnɛ Wia a bul, “Wutitii, baala deeŋ fa ŋaa tuɔ-pul tiina nɛ, u bi wii-kala cheye.” ");
INSERT INTO sil_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nialiŋ kala fa si hilime dimɛ di ba na wii-la si jaŋ ŋaa aŋ lɛɛlɛ na wii-la si ŋaa, ba paa ba nisaa chuŋ ba nyuŋ lɛ a miira mu dia. ");
INSERT INTO sil_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nialiŋ kala fa si jiŋ Yesu, ari haala-la kala fa síi to u hariŋ a lii Galilii kɔ, ba chiŋ di-bolii a na wiaa deeŋba kala. ");
INSERT INTO sil_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Baal kubala ma nɛ fa hɛ dimɛ. U yiriŋ nɛ Josɛf. U fa ŋaa Ju̱u tiina nɛ a lii Arimatiya. U fa ŋaa nialiŋ si yie hilimi a vuvuurɛ wiaa dɔŋɔ nɛ. U fa ŋaa tuɔ-pul tiina nɛ. Niaa ma jujoŋu jirima. U ma fa gbɛrɛ Wia kuorii-la nɛ duu kɔ. Ba fa síi vuurɛ di ba kpu Yesu a sɛnɛ ŋaa ŋii a kpuu, u fa bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ŋii nɛ u sii mu Paalit teeŋ a sul Yesu ku-suuŋ. Paalit leŋ u mu sori. ");
INSERT INTO sil_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","U sori Yesu ŋii, a joŋ gɛri-pula a bɛu, a joŋu hugi. U kɛnu kaa mu hugi buŋ ba si lɔsɔ lɛ nɛ. Ba ha bi nuu-kala hugo dimɛ. ");
INSERT INTO sil_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tapulii-la di ba ŋaa siri didaaniŋ a gbɛrɛ ba chɛ-wiesii-la. ");
INSERT INTO sil_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Haala-la fa si to Yesu hariŋ a lii Galilii kɔ, ba to Josɛf hariŋ a mu na buŋ-la, a na ŋii u si hugi Yesu. ");
INSERT INTO sil_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋii nɛ ba miira mu dia a chɛ tulaali di ba kaa mu tisɛ Yesu. Chɛ-wiesii-la chɛɛŋ ba sii a wiesi. Wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto bul ŋii nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lahadi chɛɛŋ siipuuraa, haala-la sii a kɛŋ tulaalii-la a kaa mu bua-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba si yi lee-la, ba na di tabii-la ba fa si kaa tɔ bua-la niiŋ suro. ");
INSERT INTO sil_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ŋii nɛ ba juu bua-la tuɔŋ, ama ba bi la Tiina Yesu ku-suuŋ na. ");
INSERT INTO sil_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba chiŋ dimɛ a bi jiŋ wii-la kala ba si jaŋ ŋaa. Ba ŋaa di ba beŋ, di baalaa balia nɛ chiŋ ba sɛmɛ ŋii. Ba gɛnniŋ faasa tutul. ");
INSERT INTO sil_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Fawulluŋ kɛŋ haala-la. Ba kɛŋ ba nyusuŋ gurɛ. Ŋii nɛ baala-la piɛsɛba a bul, “Bɛɛ nɛ tii ma chichɛ nii-la si weye ni-suunuŋ tuɔŋ? ");
INSERT INTO sil_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","U tuo daha. U sie nɛ. Má liise mu yi wii-la u fa si bula pima lɛ, bua-la lɛ u fa si hɛ Galilii lɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U fa bula pima ari ba jaŋ joŋ u-na Nuhuobiine Bie a hɛ haachɛ diiree nisiŋ lɛ di ba kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ duu suu, aŋ ka duu sii suuŋ lɛ tapulaa batori chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ŋii nɛ haala-la liise yi wii-la u fa si bula piba. ");
INSERT INTO sil_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba miira lii bua-la leriŋ a mu bula pi Yesu haritooroo fii ari kubala-la, ari nialiŋ dɔŋsuŋ fa síi to u hariŋ wialiŋ kala si ŋaa. ");
INSERT INTO sil_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haala-la si mu bua-la leriŋ nɛ ŋla: Mɛɛri Magidaliŋ, Juana ari Jeems naaŋ Mɛɛri. Ba di haalaa dɔŋsuŋ nɛ bul wiaa deeŋba si ŋaa a pi Yesu naŋzɔɔba-la. ");
INSERT INTO sil_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama Yesu naŋzɔɔba-la fa biina ari wii-la haala-la si bula ŋaa wu-nyiariŋ nɛ. Ba bi laa dii.  ");
INSERT INTO sil_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama Piita sii a fá mu bua-la leriŋ, a mu juu bua-la, a beŋ a na gɛnni-la ba fa si joŋo bɛ Yesu di ba pina, aŋ ka u bi kuŋ-kala na. Ŋii nɛ u miira mu dia a kɛŋ wii-la si ŋaa a bibiinɛ. U kperu. ");
INSERT INTO sil_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tapulii-la titia nɛ niaa balia fa síi to Yesu hariŋ mumu taŋ kubala baa yirɛ Emeyas. Emeyas ari Jerusalɛm yi ari meel-daasiŋ balipɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba síi mu taŋ-la ŋii, ba bula pipi dɔŋɔ wialiŋ kala si ŋaa. ");
INSERT INTO sil_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba síi bul wialiŋ ŋii a vuvuurɛ, ŋii nɛ Yesu titia ku yiba ba kala vivɛŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba nau, ama ba bi wuo jiŋ ari u nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ŋii nɛ Yesu piɛsɛba a bul, “Wu-bɛɛ nɛ maa bul ŋii woŋbiiŋ lɛɛ?” Ŋii nɛ ba chiŋ, ba tuɔŋ kala chei. ");
INSERT INTO sil_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba tuɔŋ dɔŋɔ yiriŋ nɛ Kiliapas. Ŋii nɛ Kiliapas piɛsu a bul, “Ŋ duŋduŋa nɛ ŋaa nuhuɔru a hɛ Jerusalɛm lɛ a bi wii-la si ŋaa tapulaa deeŋba niaa?” ");
INSERT INTO sil_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ŋii nɛ u piɛsɛba a bul, “Wu-bɛɛ nɛ ŋii?” Ŋii nɛ ba bula pu a bul, “Wii-la si ŋaa Yesu si lii Nazarɛt lɛ. Baala deeŋ fa ŋaa nii-la fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Wialiŋ u síi ŋaa ari wialiŋ u síi bul fa kɛŋ doluŋ Wia ari nuhuobiinee kala teeŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ joŋu hɛ Paalit nisiŋ lɛ duu kpuu. Ŋii nɛ Paalit ŋaa ba kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ u suu. ");
INSERT INTO sil_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","La faa yiɛlɛ ari u nɛ ŋaa nii-la si kɔ duu laa Iziral tiŋŋaa ta. Ba si kpu Yesu ŋii, u tapulaa batori nɛ jiniŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","La di haala-la dɔŋsuŋ fa síi to Yesu hariŋ ku bul wii pila. U kperila. Ba sii mu bua-la leriŋ siipuuraa aŋ bi Yesu ku-suuŋ na. ");
INSERT INTO sil_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ba ku bul ŋii pila. Ba bula ari ba na Wia tiŋdaaraa ari duosoo tuɔŋ. Ba bula piba ari Yesu weye nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","La tuɔŋ dɔŋsuŋ ma mu bua-la leriŋ a na ari wii-la haala-la si bula ŋaa wutitii nɛ. Ba bi Yesu na.” ");
INSERT INTO sil_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ŋii nɛ Yesu bula piba a bul, “Ni-yaaraa, ma digilaa yuŋie, ma bi wialiŋ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ laa dii. ");
INSERT INTO sil_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma bi jiŋ ari u maga di nii-la Wia si liisa, na hɛɛŋ nɛ aŋ-na juu u kuorii-la tuɔŋ a laa yiriŋ?” ");
INSERT INTO sil_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ŋii nɛ Yesu bula piba wialiŋ kala ba si ŋmuŋsa Wia teniŋ tuɔŋ a tigɛu lɛ, a suomi teŋ-la Moosis si ŋmuŋsa a kaa mu tenni-la kala nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ si ŋmuŋsa lɛ. U dagɛba wialiŋ kala bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba síi mu ŋii, ba ku kpagɛ taŋ-la ba síi mu. Ŋii nɛ Yesu ŋaa a nagɛ duu ha kiele mu nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ŋii nɛ ba kɛnu lɛrɛ bil di taŋ bire, duu leŋ di ba chua. Ŋii nɛ u juu di ba piŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba si hɛ dia tuɔŋ, ba hɔŋ di ba dii kudiilee. Ŋii nɛ Yesu joŋ boroboro a chuɔlɛ Wia aŋ kaa chɔgɛ piba di ba dii. ");
INSERT INTO sil_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","U si ŋaa ŋii, ba siaa luɔmɛ ba jiŋ ari Yesu nɛ. Ka u lɛl ba sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ŋii nɛ ba bula pi dɔŋɔ a bul, “La yaraa fa fiɛla nɛ woruŋ u si bul wiaa pipila woŋbiiŋ lɛ, aŋ pɛ didagɛla Wia teniŋ wialiŋ bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ŋii nɛ ba sii lima lima a miira mu Jerusalɛm, a na Yesu haritooro-la fii ari kubala, ari nialiŋ dɔŋsuŋ ma fa síi to Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ŋii nɛ Yesu haritooro-la fii ari kubala-la bula piba a bul, “La Tiina Yesu sɛnɛ sii nɛ. U kɛŋ u titia kaa kɔ dagɛ Saamɔŋ nɛ!” ");
INSERT INTO sil_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ŋii nɛ nialiŋ baliamiŋ ma bul wii-la si ŋaa woŋbiiŋ lɛ, ari ŋii ba si ku jiŋ ari la Tiina Yesu nɛ. Ba si di bua-la lɛ u si kɛŋ boroboro chɔgɛ a piba lɛ nɛ ba jiŋ ari u nɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nialiŋ balia síi bul wialiŋ ŋii, di Yesu titia nɛ chiŋ ba tutuɔbaaniŋ ŋii a bula piba a bul, “Ma jaŋ hɔŋ ari yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ŋii nɛ fawulluŋ kɛŋba, ba biina ari ni-dima nɛ ba na ŋii. ");
INSERT INTO sil_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ŋii nɛ Yesu piɛsɛba a bul, “Bɛɛ nɛ tii fawulluŋ kɛŋma maa walimɛ ma titia? Bɛɛ nɛ tii ma tuɔbiinaa vugimɛ ŋii? ");
INSERT INTO sil_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Má beŋ a na mi nisaa ari mi naasiŋ a jiŋ di mi nɛ. Má dige na. Ma jima ari ni-dima bi yaraa kɛnɛ ari mi si kɛŋ ŋii.”  ");
INSERT INTO sil_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","U si bul ŋii, u kɛŋ u nisaa ari u naasiŋ kala a dagɛba di ba na. ");
INSERT INTO sil_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ba ha bi laa dii, ka wii-la sima piba kiŋkɛŋ. U ŋaaba wu-kpuŋkpere. Ŋii nɛ u piɛsɛba a bul, “Ma kɛŋ kudiilee nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ŋii nɛ ba joŋ cheŋfiliŋ ba si wasa a pu. ");
INSERT INTO sil_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U laa chaŋ ba sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ŋii nɛ u bula piba a bul, “Mi fa bula pima ari wii-na kala ba fa si ŋmuŋsa a tigɛmi lɛ jaŋ ŋaa wutitii. Ba ŋmuŋsɛ wiaa a tigɛmi lɛ wialiŋ tuɔŋ Moosis fa si ŋmuŋsa bil di niaa tuto ari wialiŋ tuɔŋ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa si ŋmuŋsa, ari wialiŋ tuɔŋ ba si ŋmuŋsɛ Wia teniŋ sɛmɛ dɔŋɔ ba síi yirɛ Saams. Ba kala ku ŋaa wutitii.” ");
INSERT INTO sil_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ŋii nɛ Yesu ŋaa ba kɛŋ wu-jimiŋ di ba wuo jiŋ Wia teniŋ wiaa bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ŋii nɛ u bula piba a bul, “Ŋla nɛ ba ŋmuŋsa bil: ‘U maga di Kirisito, nii-la Wia si liisa na hɛɛŋ a suu aŋ sii suuŋ lɛ tapulaa batori chɛɛŋ.’ ");
INSERT INTO sil_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ba bira ŋmuŋsa di niaa jaŋ bul Wia wiaa, nii-la Wia si liisa doluŋ lɛ, dunia lee-na kala, a bula piba di ba birima lii ba haachɛba lɛ di Wia joŋ ba haachɛba chɛba, di ba suomo ŋaa ŋii Jerusalɛm lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ŋii nɛ Yesu bira bula piba a bul, “Ma ŋaa wiaa deeŋba kala si ŋaa siada, di ma wuo bula pi niaa. ");
INSERT INTO sil_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Má bee na, mi jaŋ joŋ ku-la mi Nyimma si si u jaŋ joŋo pima a hɛma lɛ. Ama má gbɛrɛ Jerusalɛm lɛ, see bua-la yie di doluŋ lii Wia teeŋ a ku tuu hɛma lɛ.” ");
INSERT INTO sil_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ŋii nɛ u kɛŋ u haritooro-la ba lii ta-bal-la lɛ a joŋ woŋbiiŋ a mumu Bɛtani diiriŋ. Dimɛ nɛ u kɛŋ u nisaa kaa chu tɔba lɛ aŋ chuɔlɛ Wia piba di Wia pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","U ha si chuɔlɛ Wia pipiba ŋii a susulu duu pɛba lɛ, ŋii nɛ u sii ba teeŋ, ka Wia joŋu kaa jil Wia-jaŋ. ");
INSERT INTO sil_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ŋii nɛ ba chuɔlu aŋ miira mu Jerusalɛm. Ba tuɔŋ kala faasa tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba yie juu Wia-dia bua-na kala lɛ a chuchuɔlɛ Wia.");
INSERT INTO sil_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka di Wia nɛ ŋaa dunia, wii-la fa hɛ dimɛ nɛ, u fa hɛ Wia teeŋ nɛ. Ba di Wia kala fa ŋaa kubala nɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Buŋbuŋ kala nɛ u fa hɛ Wia teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","U lɛ nɛ Wia to a ta kuŋ-kala. Kuŋ-kala si hɛ dunia lɛ, u nɛ ta. ");
INSERT INTO sil_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wii-la fa weye nɛ a kɛŋ pulumuŋ kaa ku pi niaa. ");
INSERT INTO sil_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Puluŋ-la chaanɛ birimiŋ tuɔŋ, biriŋ-la bi puluŋ-la wuo tɔ. ");
INSERT INTO sil_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋii nɛ Wia tiŋ u tiŋdaara kubala baa yirɛ Jɔɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U nɛ kɔ duu bul puluŋ-la wiaa pi niaa. U ŋaa ŋii di nuu-kala wuo nii a tou lɛ a laa puluŋ-la wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jɔɔŋ fa dee bi puluŋ-la ŋaa, ama u ta kɔ duu bul puluŋ-la wiaa nɛ a pi niaa. ");
INSERT INTO sil_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋii nɛ puluŋ-la titia ku tuu dunia duu chaana hɛ nuu-kala lɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","U fa hɛ dunia-la lɛ Wia si tou lɛ ta nɛ, ama dunia niaa buu jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U kɔ u titia jáŋ, ama u jáŋ niaa buu laa. ");
INSERT INTO sil_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aŋ ka niaa dɔŋsuŋ-na laau a laa u wiaa dii. Ŋii nɛ u piba woŋbiiŋ di ba wuo ŋaa Wia biiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Niaa deeŋba bi naga baala si jiŋ u haala ba lul biiriŋ ŋii nɛ. Wia titia nɛ ŋaa ba Nyimma. ");
INSERT INTO sil_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ŋii nɛ wii-la birimɛ nuhuobiine a ku hɛ la tuɔŋ. U fa hɛ la teeŋ a fifála nennige woruŋ, a kɛŋ wutitii. La na u si kɛŋ yiriŋ. Yiriŋ deeŋ u Nyimma Wia nɛ joŋo pu, ari u nɛ ŋaa u Bie kala. ");
INSERT INTO sil_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔɔŋ bul u wiaa pila. Wialiŋ u si heele bul nɛ ŋla: “Nii-la si jaŋ to mi hariŋ kɔ, u nɛ kiimi, bɛɛ wiaa u hɛ dimɛ nɛ, ka ba-na lulmi.” ");
INSERT INTO sil_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ku-la kala u si kɛnɛ, la ma na kpaaliŋ u tuɔŋ nɛ. U yie fála nennige a pɛla lɛ bua-na kala lɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wia to Moosis lɛ nɛ a bil u niiŋ pila. Ama Yesu Kirisito lɛ nɛ Wia to a fála nennige a pɛla lɛ woruŋ, a dagɛla wutitii. ");
INSERT INTO sil_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nuu-kala ha bi Wia naa. U Bii-bala-la si hɔŋ u sɛmɛ nɛ dagɛla u wiaa. ");
INSERT INTO sil_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ju̱u tiŋŋaa fa si hɛ Jerusalɛm lɛ tiŋ nialiŋ si kpu pusuŋ pipi Wia ari nialiŋ ba síi yirɛ Liivai timma, ba kɔ Jɔɔŋ teeŋ a piɛsu a bul, “Kubɛɛ nɛ ŋ ŋaa?” ");
INSERT INTO sil_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ŋii nɛ Jɔɔŋ bi wiaa nyia aŋ chaasa bul ari u dee Kirisito, nii-la Wia si liisa. ");
INSERT INTO sil_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ŋii nɛ ba bira piɛsu a bul, “Kubɛɛ nɛ saa ŋ ŋaa? Ŋ nɛ ŋaa Ilaaja?” U bul duu dee. Ŋii nɛ ba bira piɛsu, “Ŋ nɛ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ la síi gbɛru?” U bira si duu dee. ");
INSERT INTO sil_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ŋii nɛ ba bira piɛsu, “Kubɛɛ nɛ saa ŋ ŋaa? U maga di ŋ dagɛla, di la mu bula pi nialiŋ si tiŋla. Wu-bɛɛ nɛ ŋ bul a tigɛ ŋ titia lɛ?” ");
INSERT INTO sil_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ŋii nɛ Jɔɔŋ bul, “Mi nɛ ŋaa yiikori-la si hɛ giri-bine tuɔŋ aa bul, ‘Má wasɛ woŋbiiŋ bil di la Tiina kɔ.’ Ŋla nɛ Azaaya fa bul di ma ŋaa.” Azaaya fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nialiŋ fa si ku piɛsɛ Jɔɔŋ wiaa deeŋba, Farisii tiŋŋaa nɛ fa tiŋba. ");
INSERT INTO sil_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ŋii nɛ ba bira piɛsɛ Jɔɔŋ a bul, “Ŋ dee bi Kirisito ŋaa, nii-la Wia si liisa, ŋ dee bi Ilaaja ma ŋaa, ŋ bira bi nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ma ŋaa. Bɛɛ nɛ saa tii ŋ fufo niaa Wii-chuɔlɛ liiŋ?” ");
INSERT INTO sil_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ŋii nɛ Jɔɔŋ bul, “Mi síi fo niaa Wii-chuɔlɛ liiŋ, liiŋ duŋduŋa nɛ mi kaa fufoba, ama nuu dɔŋ nɛ hɛ ma tuɔŋ ŋii, ka ma buu jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","U nɛ to mi hariŋ kɔ. Mi paala bi maga di mi kɛŋ u nɛŋtɛŋŋɛɛ ŋmɛniŋ ma kaa puri.” ");
INSERT INTO sil_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ba síi bul wiaa deeŋba kala ŋii, Bɛtani lɛ nɛ ba hɛ, Jɔɔdaŋ fuo-la sɛmɛ dɔŋɔ. Lee-la nɛ Jɔɔŋ faa fo niaa Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","U taŋ si pula, Jɔɔŋ na Yesu duu kɔ. U si nau, u bul, “Bee na, Wia Pie-bie-la nɛ ŋii. U nɛ laa dunia haachɛ ta. ");
INSERT INTO sil_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Baala deeŋ wiaa nɛ mi faa bul ŋii, mi si bula ari nuu nɛ jaŋ kɔ mi hariŋ. U nɛ kiimi, u hɛ dimɛ nɛ, ka ba-na lulmi. ");
INSERT INTO sil_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi fa bi jiŋ nii-la kala u si ŋaa. Ama mi ta ku fufo niaa Wii-chuɔlɛ liiŋ nɛ, di Iziral tiŋŋaa ku jimu.” ");
INSERT INTO sil_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wialiŋ Jɔɔŋ si bula pi niaa a tigɛu lɛ nɛ ŋla: U si, “Mi na Wia Diŋ-zɔŋ-la duu lii wia nyuŋ a nagɛ kokomo, a ku tuu togiliu lɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi ma titia fa buu jiŋ. Ama Wia si tiŋmi di mi fo niaa Wii-chuɔlɛ liiŋ, u nɛ bula pimi a bul, ‘Ŋ jaŋ na Wia Diŋ-zɔŋ-la duu ku tuu a hɛ nuu lɛ, tiina nɛ jaŋ joŋ Wia Diŋ-zɔŋ-la a hɛ niaa lɛ!’ ” ");
INSERT INTO sil_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ŋii nɛ Jɔɔŋ bira bul, “Mi sɛnɛ nau a bulaa pima ari u nɛ ŋaa Wia Bie.” ");
INSERT INTO sil_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","U taŋ si pula, Jɔɔŋ ari u haritooroo balia bira chiŋ lee-la a na Yesu. ");
INSERT INTO sil_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jɔɔŋ si nau duu bal, ŋii nɛ u bul, “Bee na, Wia Pie-bie-la nɛ ŋla.” ");
INSERT INTO sil_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","U haritooro-la balia nii u si bul wiiŋ deeŋ a to Yesu hariŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu miira daasɛ, di baa to u hariŋ. U piɛsɛba a bul, “Bɛɛ kuŋ nɛ maa chɛ?” Ŋii nɛ ba ma piɛsu a bul, “La kuhiaŋ, nii lɛ nɛ ŋ jujuu?” ");
INSERT INTO sil_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ŋii nɛ Yesu bula piba a bul, “Má kɔ na mi síi juu lee-la.” Ŋii nɛ ba to u hariŋ mu a na lee-la u síi juu. Bua-la lɛ ŋaa didaaniŋ nɛ. Ŋii nɛ ba hɛ u teeŋ wii-kaaniŋ tiire juu. ");
INSERT INTO sil_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nialiŋ balia fa si nii wii-la Jɔɔŋ si bula a to Yesu hariŋ, dɔŋɔ yiriŋ nɛ Aŋduru. U fa ŋaa Saamɔŋ Piita ŋaana nɛ. ");
INSERT INTO sil_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ŋii nɛ Aŋduru ma chɛ u malima Saamɔŋ leriŋ, a bula pu a bul, “La na Kirisito, nii-la Wia si liisa.” ");
INSERT INTO sil_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","U kɛŋ Saamɔŋ kaa kɔ Yesu teeŋ. Ŋii nɛ Yesu benu aŋ bula pu a bul, “Ŋ nɛ Jɔɔŋ bie Saamɔŋ. Ba jaŋ kɛniŋ kaa yirɛ Kiifas.” Kiifas ari Piita fa ŋaa yiri-bala nɛ. U bubuɔŋ nɛ buŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","U taŋ si pula Yesu sii duu mu Galilii tiŋteeŋ. Ŋii nɛ u na Filip a bula pu a bul, “To mi hariŋ.” Ŋii nɛ Filip to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip fa lii Bɛtisaada nɛ, taŋ-la Aŋduru ari Piita ma si lia. ");
INSERT INTO sil_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ŋii nɛ Filip na Natanial a bula pu, “La na nii-la, u wiaa nɛ Moosis fa ŋmuŋsa bil di niaa tuto ŋii. Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ma fa bul u wiaa nɛ, ba ŋmuŋsa bil. Ba fa ŋmuŋsa ari u nɛ Josɛf bie Yesu a lii Nazarɛt.” ");
INSERT INTO sil_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ŋii nɛ Natanial piɛsu a bul, “Ŋ ha na ku-zɔŋ duu lii taŋ-la ba síi yirɛ Nazarɛt?” Ŋii nɛ Filip bula pu a bul, “Ku nau.” ");
INSERT INTO sil_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu si na Natanial duu kɔ u teeŋ, u bubul u wiaa a bul, “Nia deeŋ ŋaa Iziral tiina titii nɛ. U kɛŋ wutitii.” ");
INSERT INTO sil_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ŋii nɛ Natanial piɛsu a bul, “Ɛɛ nɛ ŋ ŋaa jiŋmi?” Ŋii nɛ Yesu bula pu a bul, “Mi naŋ nɛ ŋ si hɔŋ tutogo bubuɔŋ, ka Filip-na yiriŋ.” ");
INSERT INTO sil_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ŋii nɛ Natanial bula pu a bul, “Kuhiaŋ, ŋ nɛ ŋaa Wia Bie. Ŋ nɛ ŋaa Iziral tiŋŋaa kuoro maa.” ");
INSERT INTO sil_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ŋii nɛ Yesu piɛsu, “Mi si bula bul di mi naŋ di ŋ hɔŋ tutogo bubuɔŋ nɛ tii, ŋ laa mi wiaa dii koo? Ŋ jaŋ na wu-kpuŋkperisiŋ a kii ŋla.” ");
INSERT INTO sil_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ŋii nɛ Yesu bula pu a bul, “Wutitii nɛ mi bulaa piŋ, ma jaŋ na wia nyuŋ duu suro, di Wia tiŋdaaraa lii dimɛ a ku tuu mi-na Nuhuobiine Bie teeŋ, aŋ miira jijil.” ");
INSERT INTO sil_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tapulaa balia si bala, baa chɛ di ba gbieli ha-jaari gbiele taŋ kubala lɛ baa yirɛ Keena. Keena hɛ Galilii tiŋteeŋ lɛ nɛ. Yesu naaŋ ma fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba fa yirɛ Yesu ari u haritooroo maa ha-jaari gbiele-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ba síi gbieli gbiele-la ŋii, ba nyunyua siniŋ. Ba si nyua siniŋ kala dɛrɛ, Yesu naaŋ bula pu di siŋ-la dɛrɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ŋii nɛ Yesu bula pu a bul, “U bi maga di ŋ dagɛmi ŋii mi si jaŋ ŋaa. Bua-la lɛ mi si jaŋ tiŋ tiŋtiŋŋaa ha bi yie.” ");
INSERT INTO sil_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesu naaŋ saa bula pi dia-la tiŋtinnaa a bul, “Má ŋaa wii-la kala u si bula pima.” ");
INSERT INTO sil_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ju̱u tiŋŋaa fa kɛŋ ba Wii-chuɔlɛ woŋbiiŋ nɛ aa sɔŋ liiŋ. Ŋii wiaa pupoi-balaa balidu ma fa hɛ dimɛ ari liiŋ. Kuŋ-kala tuɔŋ liiŋ yi galaŋ mara a kaa mu galaŋ mara ari fii. ");
INSERT INTO sil_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ŋii nɛ Yesu bula pi dia-la tiŋtinnaa a bul, “Má ŋaa liiŋ a su̱ pupoye-la.” Ba ŋaa liiŋ su̱ pupoye-la pilim pilim. ");
INSERT INTO sil_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ŋii nɛ Yesu bira bula piba di ba ŋaa lii-la pupoi-la tuɔŋ a kaa mu pi nii-la síi beŋ gbiele-la. Ba ŋaa mu pu. ");
INSERT INTO sil_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","U laa lii-la nyua a na lii-la, duu birimɛ siniŋ. U bi jiŋ lee-la ba si na siŋ-la. Ama dia-la tiŋtinnaa-na jiŋ. Ŋii nɛ u yirɛ haal-la tiina ");
INSERT INTO sil_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a bula pu a bul, “Gbiele-na kala, lee-na kala ba yie laa sipaaŋ nɛ a kɛŋ si-zɔmuŋ a lii ba nyua. Nuu-kala si nyua vɔgɛ, ŋ saa-na kɛŋ siŋ-la si bi siŋ a kaa to hariŋ kɔ. Ka ŋ-na joŋ si-zɔmuŋ bil hariŋ u ku yi bua deeŋ kala lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu si ŋaa liiŋ birimɛ siniŋ Keena lɛ Galilii tiŋteeŋ nɛ ŋaa u wu-magil-buŋbuŋ u si ŋaa. Dimɛ nɛ u dagɛ ŋii Wia doluŋ si hɛu lɛ. U haritooroo si na ŋii, ba laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A lii gbiele-la hariŋ Yesu ari u naaŋ ari u ŋaanaa ari u haritooroo sii mu Kapɛnam tiŋteeŋ a hɛ dimɛ tapulaa baŋmɛnɛ. ");
INSERT INTO sil_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","U ka mua, ka di Ju̱u tiŋŋaa diisiŋ kieliŋ gbiele-la yi. Ŋii nɛ Yesu sii mu Jerusalɛm a juu Wia-dia. ");
INSERT INTO sil_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","U si juu dimɛ, u na niaa di baa yallɛ nɛsiŋ, piesee ari kokosuŋ. Nialiŋ síi yɛrɛ moribiee ma hɔŋ ba teebulba nyuŋ. ");
INSERT INTO sil_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ŋii nɛ Yesu kɛŋ ŋmɛniŋ a birimɛ chiba a kiri nialiŋ ari ba piesee ari ba nɛsiŋ kala ta ba lii Wia-dia-la lɛ, aŋ kɛŋ moribii-yiyɛrilɛ-la ma teebulba-la kaa birima chu, aŋ kɛŋ ba moribii-biiŋ ma jaasɛ tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ŋii nɛ ka u bula pi nialiŋ ma síi yallɛ kokosuŋ a bul, “Má kaa lii dia-la tuɔŋ. Ma sí mi Nyimma dia kaa birimɛ yɔbɔ.” ");
INSERT INTO sil_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","U haritooroo liisi wii-la ba si ŋmuŋsɛ Wia teniŋ tuɔŋ a bul, “Wia-dia wiaa ka diimi nɛ woruŋ a nagɛ nyiniŋ.” ");
INSERT INTO sil_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ŋii nɛ Ju̱u tiŋŋaa miira kɔ u teeŋ a piɛsu, “Bɛɛ kuŋ wu-magil nɛ ŋ jaŋ wuo joŋo dagɛla ari ŋ kɛŋ doluŋ di ŋ wuo ŋaa wiiŋ deeŋ?” ");
INSERT INTO sil_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ŋii nɛ Yesu bula piba a bul, “Má ŋmoo Wia-dia deeŋ lo, mi jaŋ wuo joŋ tapulaa batori a bira saau.” ");
INSERT INTO sil_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ŋii nɛ ba bula pu a bul, “Jisiŋ mahiŋ balia ari balidu nɛ ba joŋo saa Wia-dia deeŋ, ka ŋ-na bul di ŋ jaŋ kɛŋ tapulaa batori saau koo?” ");
INSERT INTO sil_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama Yesu si bul Wia-dia-la wiaa ŋii, u titia yaraa wiaa nɛ u bubul ŋii. ");
INSERT INTO sil_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bua-la lɛ u si sii suuŋ lɛ nɛ u haritooroo liisi a yi wii-la u fa si bula lɛ. Ŋii nɛ ba laa wialiŋ ba fa si ŋmuŋsa Wia teniŋ tuɔŋ dii, a laa wialiŋ ma Yesu si bula dii. ");
INSERT INTO sil_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu fa si hɛ Jerusalɛm lɛ, diisiŋ kieliŋ gbiele-la lɛ, niaa yuga a laa u wiaa dii a tiŋ ba si na wu-magila-la u síi ŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Yesu bi u titia kaa pullɛ ba teeŋ, bɛɛ wiaa u jiŋ nuhuobiinee kala nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","U fa bi maga di nuu-kala bira bul nuhuobiinee wiaa pu, bɛɛ wiaa u fa jiŋ nuhuobiinee tuɔŋ wu-kɛniŋ kala nɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Baal kubala nɛ fa hɛ dimɛ. Baa yirɛ Nikodiimas. U fa ŋaa Ju̱u tiŋŋaa kuhiaŋ nɛ a hɛ Farisii tiŋŋaa paati tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Titaŋ kubala u sii kɔ Yesu teeŋ a bul, “Kuhiaŋ, la jima ari ŋ nɛ ŋaa nii-la Wia si ta di ŋ dagɛ niaa. Nuu-kala bi jaŋ wuo ŋaa wu-magila-la ŋ síi ŋaa, see di Wia pɛ tiina lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ŋii nɛ Yesu bula pu a bul, “Wutitii nɛ mi bulaa piŋ, nuu-kala bi jaŋ wuo juu Wia kuorii-la tuɔŋ, see di ba wasa lul tiina.” ");
INSERT INTO sil_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ŋii nɛ Nikodiimas piɛsu a bul, “Ɛɛ nɛ ba-nihiaŋ jaŋ wuo ŋaa di ba bira wasa lulu? U jaŋ bira wuo juu u naaŋ luoruŋ di u bira wasa luluu koo?” ");
INSERT INTO sil_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ŋii nɛ Yesu bul, “Wutitii nɛ mi bulaa piŋ, nuu-kala bi jaŋ wuo juu Wia kuorii-la tuɔŋ, see di Wia joŋ u Diŋ-zɔŋ-la hɛ tiina lɛ, di tiina ma pɛ fo Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nuhuobiine yie lul nuhuobiine u kɛŋ miisiŋ nɛ tiŋteeŋ deeŋ lɛ. Aŋ ka Wia ma yie joŋ u Diŋ-zɔŋ-la a hɛu lɛ duu kɛŋ miisiŋ Wia teeŋ. Nuhuobiine bi Wia Diŋ-zɔŋ-la jaŋ wuo joŋo hɛ nuu lɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sí leŋe duu ŋaa wu-kpuŋkpere ŋ lɛ mi si bula piŋ ari u maga di ba wasa luluŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Peliŋ yie lu lee-na kala u si cho nɛ. Ŋ ninii u dɔmɔ, ama ŋ bi jiŋ lee-la u si lii kɔ, koo ŋ bira bi jiŋ lee-la u síi mu. U saa nagɛ ŋii nɛ nuu-kala lɛ Wia si joŋ u Diŋ-zɔŋ-la hɛu lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ŋii nɛ Nikodiimas piɛsɛ, “Ɛɛ nɛ wiiŋ deeŋ jaŋ wuo ŋaa?” ");
INSERT INTO sil_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ŋii nɛ Yesu bula pu a bul, “Ŋ ŋaa kerichi-bal nɛ Iziral tiŋteeŋ lɛ, aŋ ka bɛɛ nɛ tii ŋ bi wiiŋ deeŋ bubuɔŋ jiŋ? ");
INSERT INTO sil_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wutitii nɛ mi bulaa piŋ, la yie bul wii-la la si jima nɛ, a ŋaa siada ari wii-la la si na. Ama ma kuŋ-kala bi chɛ di ma sɛi wii-la la si bula. ");
INSERT INTO sil_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi bul dunia wiaa nɛ pipiŋ, ka ŋ bi laa dii. Ɛɛ nɛ saa ŋ jaŋ wuo laa dii di mi nɛ bul Wia-jaŋ wiaa piŋ? ");
INSERT INTO sil_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuu-kala ha bi Wia-jaŋ jila, see mi-na Nuhuobiine Bie si lii dimɛ ku tuu. ");
INSERT INTO sil_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moosis fa si hɛ giri-bine tuɔŋ, u fa kɛŋ hɔɔŋ a libi dimiŋ, a joŋo mɛrɛ daaŋ lɛ a kaa jee. Ŋii titia nɛ ba jaŋ kpaasɛ mi-na Nuhuobiine Bie ma daaŋ lɛ a kaa jee, ");
INSERT INTO sil_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","di nuu-kala si laa mi wiaa dii, u jaŋ wuo kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wia cho dunia niaa a mu kieli, ŋii nɛ tii u joŋ u Bii-bala a pila, di nii-la kala si laa u wiaa dii, u bi jaŋ lɛl, ama u jaŋ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wia bi u Bie ta duu ku tuu laa dunia niaa wiaa jiŋ, ama duu laa dunia niaa ta. ");
INSERT INTO sil_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nuu-na kala si laa Yesu wiaa dii, u bi jaŋ dii u tiina sariya a joŋ cheeriŋ pu, ama nii-la kala si bi u wiaa laa dii, u paala dii u tiina sariya a joŋ cheeriŋ pu, bɛɛ wiaa u bi Wia Bii-bala-la wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wii-la si tii Wia dii dunia niaa sariya a joŋ cheeriŋ piba nɛ ŋla: Pulumuŋ ku tuu dunia nɛ, ama niaa cho birimiŋ nɛ a kii puluŋ-la, bɛɛ wiaa baa ŋaa wu-bɔŋŋɔɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nuu-na kala síi ŋaa wu-bɔŋŋɔɔ bi pulumuŋ cho, u bi pulumuŋ tuɔŋ lii, bɛɛ wiaa u bi chɛ di u wu-bɔmɔ-la lii pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama nuu-na kala síi ŋaa wu-zɔŋŋɔɔ cho pulumuŋ a yie lilii pulumuŋ tuɔŋ, di niaa wuo na ari uu ŋaa wu-zɔmɔ-la Wia doluŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ŋii hariŋ nɛ Yesu ari u haritooroo lii Jerusalɛm a mu Judiya tiŋteeŋ, a dieni mua dimɛ aa fo niaa Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔɔŋ ma fa hɛ lee kubala baa yirɛ Aanɔŋ lɛ a kpagɛ Seelim aa fo niaa Wii-chuɔlɛ liiŋ, bɛɛ wiaa liiŋ fa yuga kiŋkɛŋ dimɛ. Niaa faa mu u teeŋ u fufoba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Bua-la lɛ di ba ha bi Jɔɔŋ kaa tɔ dia.) ");
INSERT INTO sil_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ŋii nɛ Jɔɔŋ haritooroo dɔŋsuŋ ari Ju̱u tiina kubala kɛŋ liiŋ sɔmuŋ wiaa a kaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba mu Jɔɔŋ teeŋ a piɛsu a bul, “La kuhiaŋ, ŋ liisi baal-la fa si hɛ Jɔɔdaŋ fuo-la sɛmɛ dɔŋɔ wiaa nɛ, nii-la ŋ si bul u wiaa? Lɛɛlɛ u maa fo niaa Wii-chuɔlɛ liiŋ nɛ, niaa kala mumu u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ŋii nɛ Jɔɔŋ bul, “Nuu-kala bi jaŋ wuo kɛŋ kuŋ-kala, see di Wia joŋo pu. ");
INSERT INTO sil_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ma titia ŋaa mi daŋsia, ka mi bul ari mi dee bi Kirisito-la ŋaa, nii-la Wia si liisa, ama Wia ta tiŋmi nɛ di mi laa u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ha-faliŋ tiina nɛ tii haala, ama di ha-faliŋ tiina naŋdɔŋɔ nɛ chiŋ dimɛ a jijegili wialiŋ ba síi bul, u tuɔŋ yie tɔrɛ nɛ duu nɛ nii ha-faliŋ tiina-la yiikoro. Ŋii titia nɛ mi tuɔŋ ma tɔrɛ woruŋ Yesu nyuŋ. ");
INSERT INTO sil_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","U maga duu nɛ miira ku ŋaa ni-baliŋ mi teeŋ, ka di mi miira ŋaa ni-bie.” ");
INSERT INTO sil_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nii-la si lii Wia-jaŋ nɛ kii kuŋ-kala. Nii-la si lii tiŋteeŋ ŋaa tiŋteeŋ kuŋ nɛ aa bul tiŋteeŋ wiaa. Ama nii-la si lii Wia-jaŋ nɛ kii kuŋ-kala. ");
INSERT INTO sil_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Uu bul wialiŋ u si na aŋ nii ma nɛ, ama nuu-kala bi u niiŋ wiaa sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nii-la kala si sɛi u niiŋ wialiŋ jima ari Wia hɛ dimɛ nɛ a kɛŋ wutitii. ");
INSERT INTO sil_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mi-na nii-la Wia si tima, mii bul Wia niiŋ wiaa nɛ, bɛɛ wiaa Wia joŋ u Diŋ-zɔŋ-la doluŋ kala a pimi nɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mi Nyimma Wia cho mi-na u Bie, a joŋ u doluŋ kala a hɛ mi nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nii-la kala si laa mi-na Wia Bie wiaa dii, u jaŋ kɛŋ miisi-la si bi dɛrɛ; ama nii-la kala si bi mi-na Wia Bie wialiŋ ka to, u bi jaŋ kɔ duu kɛŋ miisi-la si bi dɛrɛ, ama Wia jaŋ na baaniŋ u tiina nyuŋ a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ŋii nɛ Farisii tiŋŋaa nii ari Yesu na niaa yugɛ a kii Jɔɔŋ, baa tou u foba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ama Yesu titia bi nuu-kala Wii-chuɔlɛ liiŋ fo, u haritooroo duŋduŋa nɛ.) ");
INSERT INTO sil_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu si nia di baa bul ŋii, u sii lii Judiya tiŋteeŋ lɛ a miiraa mu Galilii tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","U síi mu Galilii ŋii, u to Samaria tiŋteeŋ ");
INSERT INTO sil_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","a ku yi taŋ kubala Samaria tiŋteeŋ lɛ baa yirɛ Sika. Tiŋtee-la Jekɔb fa si joŋo pi u bie Josɛf fa kpagɛ dimɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekɔb fa si lu vil-la hɛ dimɛ. Yesu fa si vɛŋ woŋbiiŋ ŋii a lɔl, u mu hɔŋ vil-la sɛmɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Di wia jil nyu-gbaŋa, ŋii nɛ Samaria tiŋŋaa haal kubala kɔ vil-la duu ŋaa liiŋ. Ŋii nɛ Yesu bula pu a bul, “Ŋaa liiŋ pimi di mi nyua.” ");
INSERT INTO sil_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bua-la lɛ di u haritooroo-na mu taŋ-la tuɔŋ di ba yɔɔ kudiilee. ");
INSERT INTO sil_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋii nɛ Samaria tiŋŋaa haal-la piɛsɛ Yesu a bul, “Bɛɛ nɛ tii ŋ-na Ju̱u tiina chichɛ di mi-na Samaria tiina ŋaa liiŋ piŋ di ŋ nyua?” Ju̱u tiŋŋaa ari Samaria tiŋŋaa bi wii pɛ. Ŋii nɛ tii haal-la bul ŋii. ");
INSERT INTO sil_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ŋii nɛ Yesu bula pu a bul, “Di ŋ nɛ fa jiŋ ku-la Wia si joŋo pi niaa, a fa jiŋ nii-la si suluŋ di ŋ ŋaa liiŋ pu duu nyua, ŋ fa jaŋ sulu duu piŋ lii-la si kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋii nɛ haal-la piɛsu a bul, “Kuhiaŋ, ŋ bi guga kɛnɛ di ŋ kaa ŋaa liiŋ, ka vil-la ma luŋ. Nii lɛ nɛ saa ŋ jaŋ na lii-la si kɛŋ miisiŋ? ");
INSERT INTO sil_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","La naabalima Jekɔb nɛ joŋ viliŋ deeŋ pila. Ba di u biiriŋ ari u pusuŋ kala nyua viliŋ deeŋ liiŋ nɛ. Ŋ jaŋ bul di ŋ kii Jekɔb nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ŋii nɛ Yesu bula pu a bul, “Nuu-kala si nyua liiŋ deeŋ, lii-nyuasuŋ jaŋ bira kɛŋ tiina. ");
INSERT INTO sil_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama nii-la kala si jaŋ nyua lii-la mi si jaŋ pu, lii-nyuasuŋ bira bi jaŋ kɛnu da. Lii-la mi si jaŋ pu jaŋ birimɛ lii-bulo u tuɔŋ lɛ a bubu̱l, a pu miisiŋ si bi dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋii nɛ haal-la bula pu a bul, “Mi Tiina, pimi liiŋ deeŋ, di lii-nyuasuŋ bira sími kɛŋ, di mi bira sí kɔ di mi ŋaa liiŋ daha.” ");
INSERT INTO sil_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ŋii nɛ Yesu bula pu a bul, “Mu yirɛ ŋ bala aŋ miira kɔ daha.” ");
INSERT INTO sil_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Haal-la si duu bi bala kɛnɛ. Ŋii nɛ Yesu bira bul, “Ŋ kiaa sima ŋ si jaŋ bul di ŋ bi bala kɛnɛ, ");
INSERT INTO sil_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","bɛɛ wiaa ŋ fa jaa baalaa banɔŋ nɛ, ama ma di baal-la si hɛ dimɛ lɛɛlɛ sɛnɛ bi ŋ bal-titii ŋaa. Ŋ bul wutitii nɛ pimi.” ");
INSERT INTO sil_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋii nɛ haal-la bula pi Yesu a bul, “Mi Tiina, u naga ŋ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Haal-la bira bula pu a bul, “La-na Samaria tiŋŋaa naabalimaba, baa chuɔlɛ Wia peeliŋ deeŋ nyuŋ nɛ, aŋ ka ma Ju̱u tiŋŋaa si, di Jerusalɛm nɛ lee-la la si maga di laa chuɔlɛ Wia.” ");
INSERT INTO sil_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ŋii nɛ Yesu bula pu a bul, “Bua kubala jaŋ yi, niaa si bi jaŋ chuɔlɛ la Nyimma Wia peeliŋ deeŋ nyuŋ koo Jerusalɛm lɛ. Laa wiiŋ deeŋ dii. ");
INSERT INTO sil_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ma-na Samaria tiŋŋaa sɛnɛ bi jiŋ nii-la ma síi chuɔlu. La-na Ju̱u tiŋŋaa jiŋ Nii-la la síi chuɔlu nɛ. Nii-la lɛ Wia si jaŋ to a laa dunia niaa ta, u lii Ju̱u tiŋŋaa tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bua kubala jaŋ yi, u paala yi nɛ, nialiŋ si jaŋ sɛnɛ chuɔlɛ Wia, ba jaŋ chuɔlɛ la Nyimma Wia ari wutitii, Wia Diŋ-zɔŋ-la doluŋ lɛ. Ŋii nɛ Wia chɛ di niaa chuchuɔlu. ");
INSERT INTO sil_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wia ŋaa ni-dima nɛ, nialiŋ síi chɛ di ba chuɔlu, u maga di ba chuɔlu ari wutitii, u Diŋ-zɔŋ-la doluŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋii nɛ haal-la bula pu di u jima ari nii-la ba síi yirɛ Kirisito, nii-la Wia si liisa, u jaŋ kɔ. Di u nɛ kɔ, u jaŋ dagɛba wii-na kala. ");
INSERT INTO sil_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu miira bula pu a bul, “Mi nɛ ŋii, mi níi bul wiaa ŋ teeŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bua-la di Yesu haritooroo miira kɔ. U kperiba ba si ku nau, duu bul wiaa haal-la teeŋ. Ama ba kuŋ-kala bi niiŋ suro a piɛsu a bul, “Bɛɛ nɛ ŋŋ chɛ u teeŋ?” Koo ba bira bi piɛsa bul, “Bɛɛ nɛ tii ŋ bubul wiaa haal-la teeŋ?” ");
INSERT INTO sil_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ŋii nɛ haal-la leŋ u pupoiŋ dimɛ, aŋ miira mu jaŋ tuɔŋ, a yirɛ niaa a bula piba, ");
INSERT INTO sil_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Má kɔ na baal kubala si wuo dagɛ wialiŋ kala mi si ŋaa. Nia deeŋ nɛ saa ŋaa Kirisito, nii-la Wia si liisaa, koo?” ");
INSERT INTO sil_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Niaa si nii wiiŋ deeŋ, ba lii mu Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bua-la lɛ di Yesu haritooroo ka sulu a bul, “La kuhiaŋ, laa kiaa dii.” ");
INSERT INTO sil_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ŋii nɛ Yesu bula piba a bul, “Mi kɛŋ kudiilee nɛ mi dii, ama ma bi kialiŋ wiaa jiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŋii nɛ Yesu haritooro-la miira chinaa piɛsɛ dɔŋɔ a bul, “Nuu nɛ saa kɛŋ kudiilee ku pu koo?” ");
INSERT INTO sil_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu bula piba a bul, “Mi kudiilee nɛ di mi sɛi nii-la si tiŋmi niiŋ, a tiŋ tiŋtimii-la u si pimi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma si u ha ka chɛŋsiŋ banɛsɛ nɛ, ka di ma wasɛ baga kiaa hɛ dɔŋɔ lɛ. Mi jaŋ bula pima, má bee na, kiaa nɛ bia a gollima ŋii di ma wasa hɛ dɔŋɔ lɛ. Ba nɛ nialiŋ si ŋaa siri di ba laa mi wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nialiŋ kala si wasɛ kialiŋ hɛ dɔŋɔ lɛ, ba jaŋ laa ba time. Kialiŋ ma ma si wasa hɛ dɔŋɔ lɛ, ba ma nɛ ŋaa nialiŋ si laa mi wiaa dii. Ba nɛ jaŋ kɛŋ miisi-la si bi dɛrɛ. Ŋii wiaa nialiŋ si kɛsɛ nialiŋ si laa mi wiaa dii ari nialiŋ síi bul Wia wiaa pipi niaa, ba kala tuɔŋ jaŋ tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wii-la sɛnɛ ŋaa wutitii nɛ. Nuu dɔŋ nɛ bul Wia wiaa, nuu dɔŋ ma kɛsɛ nialiŋ si laa mi wiaa dii hɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi tiŋma nɛ di ma mu kɛsɛ nialiŋ si laa mi wiaa dii. Ma si ŋaa ŋii, ma nagɛ nialiŋ si mu wasɛ baga kiaa nɛ hɛ dɔŋɔ lɛ, baga-la lɛ ba si bi tima. Niaa dɔŋsuŋ nɛ tiŋ baga-la lɛ, ka ba pɛ nii baga-la sima ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ŋii nɛ niaa yuga Samaria tiŋteeŋ lɛ a laa Yesu wiaa dii. Haal-la si bul wialiŋ Yesu si bula a tigɛu lɛ nɛ tii ba laa Yesu wiaa dii ŋii. ");
INSERT INTO sil_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaria nialiŋ si kɔ Yesu teeŋ, ba sulu duu chua ba teeŋ. Yesu sɛi a chua dimɛ tapulaa balia. ");
INSERT INTO sil_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Niaa bira yuga a laa u wiaa dii a tiŋ wialiŋ u si dagɛba wiaa. ");
INSERT INTO sil_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ŋii nɛ nialiŋ bula pi haal-la a bul, “Lɛɛlɛ la laa u wiaa dii a tiŋ la titia si nii u niiŋ wiaa ŋii nɛ, u bi naga wii-la ŋ si bula pila nɛ tii. La titia wuo jiŋ ari u nɛ sɛnɛ ŋaa dunia Laataara.” ");
INSERT INTO sil_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu si chua dimɛ tapulaa balia-la, u sii a bira mu Galilii tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu titia fa bula pi niaa ari nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba buu jirima ka pa u titia jaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","U si mu Galilii tiŋteeŋ ŋii, ba kɛnu woruŋ a tiŋ wialiŋ kala u si ŋaa ba-na Ju̱u tiŋŋaa gbiele-la lɛ Jerusalɛm lɛ. Ba ma fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu bira miira mu lee-la ba síi yirɛ Keena a hɛ Galilii tiŋteeŋ lɛ, lee-la u fa si kɛŋ liiŋ birimɛ siniŋ. Di kerichi-bal kubala fa hɛ taŋ kubala lɛ baa yirɛ Kapɛnam lɛ. U bie fa wiwiilɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","U si nia di Yesu lii Judiya tiŋteeŋ a kɔ Galilii tiŋteeŋ, u mu Yesu teeŋ a sulu duu ku vaarɛ u bie pu, di u kpagɛ suuŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ŋii nɛ Yesu bula pu, “See di ma na wu-magilaa ari wu-kpuŋkperisiŋ, ma bi jaŋ ŋaa yarida.” ");
INSERT INTO sil_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ŋii nɛ kerichi-la bula pu, “Mi kuhiaŋ, kɔ lagi di mi bie sí suu.” ");
INSERT INTO sil_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ŋii nɛ Yesu bula pu, “Mu dia, ŋ bie duoro nɛ.” Baal-la laa wii-la Yesu si bula pu dii a joŋ u woŋbiiŋ aa vɛŋ. ");
INSERT INTO sil_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Uu mu ŋii, u tiŋtinna ku chemu a bula pu ari bile duoro nɛ. ");
INSERT INTO sil_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","U piɛsɛ duu na bua-la lɛ u si duoro. Ba bula pu ari diamiŋ wiihɛyɛ, kerifi kubala lɛ nɛ waari-la leŋu. ");
INSERT INTO sil_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ŋii nɛ bile nyimma jiŋ ari bua-la lɛ nɛ Yesu bula pu ari u bie kɛŋ miisiŋ nɛ. Ŋii nɛ ba di u dia niaa kala laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wu-liamiŋ nɛ ŋii Yesu si ŋaa, u si bira lii Judiya kɔ Galilii tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ŋii hariŋ lɛ nɛ Ju̱u tiŋŋaa gbiele kubala bira yi Jerusalɛm lɛ. Ŋii nɛ Yesu sii mu lee-la. ");
INSERT INTO sil_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalɛm lɛ, fuo kubala nɛ fa hɛ dimɛ. U fa kpagɛ boiŋniiri-la dɔŋɔ ba fa si to jujuu taŋ-la tuɔŋ nɛ. U yiriŋ nɛ fa piese boiŋniiŋ. Hiiburu yiikoro lɛ ba kɛŋ fuo-la kaa yirɛ Bɛtizata. Ba hɛ palaa banɔŋ nɛ a kɛrɛ fuo-la. ");
INSERT INTO sil_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nyanyal tiŋŋaa fa yuga a hɛ pala-la tuɔŋ. Dɔŋsuŋ nyulimɛ, dɔŋsuŋ fa ŋaa naa-suunuŋ ari na-suunuŋ tiŋŋaa. Dɔŋsuŋ ma gbɛrikɛ. Ba fa hɔnɔ gbɛrɛ fuo-la di lii-la fa vuugi. ");
INSERT INTO sil_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bua dɔŋɔ Wia tiŋdaaru nɛ fa yie ku tuu fuo-la a kɛŋ lii-la kaa vuugi. Di Wia tiŋdaari-la nɛ kɛŋ lii-la vuugi, nyanyal tiina-la si laa sipaaŋ tuu lii-la, u nyanyaliŋ cho duu nagɛ ŋii ma kala, u yie duori nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Baal kubala ma nɛ fa hɛ nyanyal timma-la tuɔŋ. U fa wiila nɛ a yi jisiŋ mara ari fii ari chori. ");
INSERT INTO sil_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu si na baal-la duu piŋ dimɛ, u jiŋ ari baal-la wiila dieni nɛ. Ŋii nɛ u piɛsu a bul, “Ŋŋ chɛ di ŋ duori nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ŋii nɛ baal-la bul, “Mi kuhiaŋ, mi bi nuu kɛnɛ daha u si jaŋ wuo joŋmi kaa tuu hɛ fuo-la lɛ di ba nɛ kɛŋ lii-la vuugi. Ba yie kɛŋ lii-la vuugi, mii nɛrikɛ di mi tuu, di nuu laa sipaaŋ tuumi lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ŋii nɛ Yesu bula pi baal-la a bul, “Sii a chuoli ŋ bɔsɔ a viiri.” ");
INSERT INTO sil_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Baal-la guu duori a sii chuoli u bɔsɔ a chuŋaa viiri. Tapuluŋ deeŋ ŋaa chɛ-wiesii-la chɛɛŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ŋii nɛ Ju̱u tiŋŋaa bula pi baal-la Yesu si vaara a bul, “Jiniŋ ŋaa chɛ-wiesii-la chɛɛŋ nɛ. Uu kisɛ nɛ di ŋ chuŋ bɔsɔ tapuluŋ deeŋ chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ŋii nɛ baal-la ma bul, “Nii-la si vaarɛmi nɛ bula pimi di mi chuoli mi bɔsɔ a viiri.” ");
INSERT INTO sil_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ŋii nɛ ba piɛsu, “Kubɛɛ nɛ baal-la si bula piŋ di ŋ chuoli ŋ bɔsɔ a viiri?” ");
INSERT INTO sil_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama baal-la bi nii-la si vaaru jiŋ. Bua-la lɛ di niaa si yuga ŋii, Yesu lɛl. ");
INSERT INTO sil_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","U ŋii hariŋ nɛ Yesu na baal-la Wia-dia lɛ a bula pu, “Na, lɛɛlɛ ŋ duoro nɛ, bira sí haachɛ ŋaa. Di ŋii dee, wiiŋ jaŋ wasa juuŋ lɛ a kii ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋii nɛ baal-la sii a mu bula pi Ju̱u timma-la ari Yesu nɛ fa vaaru ŋii. ");
INSERT INTO sil_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu si ŋaa ŋii chɛ-wiesii-la chɛɛŋ, ŋii nɛ tii Ju̱u tiŋŋaa suomo to Yesu naasiŋ di ba dɔgisu. ");
INSERT INTO sil_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ŋii nɛ Yesu bula piba a bul, “Mi Nyimma ka tiŋ nɛ, ŋii nɛ tii mi maa tiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu si bul ŋii ŋaa Ju̱u timma-la wasa chichɛ woŋbii-la ba si jaŋ to kpuu. Wiaa balia nɛ ba si duu cheye, u chei ba kisiŋ lɛ chɛ-wiesii-la chɛɛŋ, aŋ pɛ bul di Wia nɛ ŋaa u Nyimma, a bul ŋii di ba di Wia magɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ŋii nɛ Yesu bula pi niaa a bul, “Mi bul wutitii nɛ aa pima, mi-na Wia Bie bi wii-kala wuo ŋaa mi titia doluŋ lɛ. Mi yie ŋiŋaa wialiŋ mi si na di mi Nyimma ŋaa nɛ. Wii-na kala u síi ŋaa nɛ, mi ma u Bie ŋiŋaa, ");
INSERT INTO sil_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","bɛɛ wiaa mi Nyimma chomi, mi si ŋaa u Bie, aa dagɛmi wialiŋ kala u titia síi ŋaa. U jaŋ dagɛmi wiaa a kii ŋla di mi ŋaa, di ba ŋaama wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mi Nyimma si chisɛ nialiŋ si suba ba bira kɛŋ miisiŋ ŋii, ŋii titia nɛ mi ma u Bie joŋ miisiŋ a pipi nialiŋ mi síi chɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mi Nyimma-na bi nuu-kala sariya ka dii, ama u joŋba kala hɛ mi-na u Bie nisiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","U ŋaa ŋii di nuu-kala to ŋii lɛ a zizil mi-na u Bie nɛ, ari ba síi zil mi Nyimma ŋii. Nii-la-na kala si bi mi-na Wia Bie ka zil, u tiina ma bi mi Nyimma Wia si tiŋmi ka zil. ");
INSERT INTO sil_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Wutitii nɛ mi bula pipima, nii-la kala si jegile nii mi niiŋ wiaa a laa nii-la ma si tiŋmi wiaa dii, u jaŋ kɛŋ miisi-la si bi dɛrɛ. U tiina, ba bi u-na sariya ka dii, u saa lii suuŋ bua lɛ nɛ a kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wutitii nɛ mi bula pipima, bua-la jaŋ yi, u saa yie ma nɛ, di nialiŋ si suba jaŋ nii mi-na Wia Bie yiikoro. Nialiŋ saa si nii mi yiikoro, ba jaŋ kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mi Nyimma si kɛŋ doluŋ duu pi niaa miisiŋ ŋii, ŋii nɛ u ŋaa mi ma u Bie kɛŋ doluŋ di mi pi niaa miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","U saa pi mi-na u Bie doluŋ nɛ di mi dii niaa sariya, bɛɛ wiaa mi nɛ ŋaa Nuhuobiine Bie. ");
INSERT INTO sil_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma sí leŋe di wiiŋ deeŋ ŋaama wu-kpuŋkpere. Bua-la jaŋ kɔ di nialiŋ kala si suba a hɛ buasuŋ lɛ jaŋ nii mi yiikoro. ");
INSERT INTO sil_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ba saa jaŋ sii ba buasuŋ lɛ. Nialiŋ si ŋaa wu-zɔŋŋɔɔ jaŋ sii a kɛŋ miisiŋ, nialiŋ ma si ŋaa wu-bɔŋŋɔɔ, di ba ma sii di Wia dii ba sariya a joŋ cheeriŋ piba.” ");
INSERT INTO sil_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ŋii nɛ Yesu bira bul, “Mi-na bi wii-kala wuo ŋaa mi titia doluŋ lɛ. Mi yie dii sariya ari Wia si si mi dii ŋii nɛ. Ŋii wiaa mi si yie dii sariya-la ŋii, u ŋaa wutitii nɛ, bɛɛ wiaa mi bi chɛ di mi ŋaa wii-la mi síi chɛ, ama wii-la nii-la si tiŋmi síi chɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Di mi duŋduŋa nɛ bul mi wiaa, u bi yuŋuŋ jaŋ kɛŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama nuu ma nɛ hɛ dimɛ a bubul mi wiaa. Mi saa jima wialiŋ u síi bul a tigɛmi lɛ, ba ŋaa wutitiiba nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ma tiŋ ma tiŋdaaraa ba mu Jɔɔŋ teeŋ a piɛsɛ mi wiaa. Jɔɔŋ bul wutitii nɛ piba a tigɛmi lɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","U saa bi naga wialiŋ nuhuobiinee si bula a tigɛmi lɛ wiaa nɛ mi chil, ama mii bul wiiŋ deeŋ di ma ŋaa siri di Wia wuo laama ta nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔɔŋ fa nagɛ chaaniŋ nɛ a chaanɛ, ma fa cho di ma nii u chaaŋ-la sima muapilii. ");
INSERT INTO sil_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama wiiŋ dɔŋɔ hɛ dimɛ a laa mi nyuŋ a bubul wiaa. U nɛ kii Jɔɔŋ. Tiŋtimii-la mi síi tiŋ nɛ ŋii, tiŋtimii-la mi Nyimma si joŋo pimi di mi tiŋ. Ŋii daga ari mi Nyimma nɛ tiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mi Nyimma-la si tiŋmi, u maa bul mi wiaa nɛ. Ma ha bi u yiikoro nia, ma ha buu na ari ma siaa maa. ");
INSERT INTO sil_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","U niiŋ wiaa bima lɛ hɛ, bɛɛ wiaa ma bi mi-na nii-la u si tima wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ma yie fiɛsɛ siiŋ a kikarimɛ Wia teniŋ. Ma biina ari ma níi ŋaa ŋii, ma jaŋ wuo kɛŋ miisi-la si bi dɛrɛ. Wia teŋ-la ma síi karimu ma paala bul mi wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ka ma via di ma kɔ mi teeŋ a wuo kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi bí chɛ di nuhuobiinee bɛsɛmi lɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mi jima ari ma tuɔŋ lɛ ma bi Wia cho. ");
INSERT INTO sil_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi kɔ mi Nyimma doluŋ lɛ nɛ, ka ma bimi kɛnɛ woruŋ. Di nuu dɔŋ nɛ fa kɔ u titia doluŋ lɛ, u nɛ ma fa jaŋ kɛŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ma cho di niaa bɛsɛma lɛ nɛ, ama ma bi cho di Wia nɛ bɛsɛma lɛ. Ɛɛ nɛ saa ma jaŋ wuo laa mi wiaa dii? ");
INSERT INTO sil_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma sí biina bul ari mi jaŋ joŋ cheeriŋ pima mi Nyimma sipaaŋ. Moosis nɛ jaŋ joŋ cheeriŋ pima. Ma yiɛlaa kala hɛu lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Di ma nɛ sɛnɛ fa laa Moosis wiaa dii, ma fa jaŋ laa mi ma wiaa dii. Mi wiaa nɛ Moosis fa ŋmuŋsɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama di ma bi wialiŋ u si ŋmuŋsa laa dii, ɛɛ nɛ ma jaŋ wuo laa wialiŋ mi síi bul dii?” ");
INSERT INTO sil_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","U ŋii hariŋ nɛ Yesu miira chol mugi-baliŋ kubala baa yirɛ Galilii mugi-baliŋ. U yiriŋ dɔŋɔ ma nɛ Tabiiras. ");
INSERT INTO sil_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Niaa yuga a tuto u hariŋ, bɛɛ wiaa ba fa na u si ŋaa wu-magila-la a vaarɛ nyanyal tiŋŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ŋii nɛ Yesu ari u haritooroo mu jil peeliŋ nyuŋ a hɔŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Di Ju̱u tiŋŋaa diisiŋ kieliŋ gbiele-la ma kpaga. ");
INSERT INTO sil_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ba si hɔŋ dimɛ, Yesu bee na di ni-daŋ níi kɔ u teeŋ ŋii. U piɛsɛ Filip a bul, “Nii nɛ la jaŋ na kudiilee a yɔɔ a pi niaa deeŋba kala di ba dii vɔgɛ?” ");
INSERT INTO sil_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu titia fa jiŋ wii-la u si jaŋ ŋaa nɛ, ama u ta bul ŋii duu magisɛ Filip nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ŋii nɛ Filip bula pu a bul, “Di la nɛ yɔɔ boroboro a yi siidi bui balia maa, u bi niaa deeŋba wii-kala wuo ŋaa, ba dɔŋsuŋ paala bi mua mua maa na.” ");
INSERT INTO sil_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ŋii nɛ di u haritooro dɔŋɔ hɛ dimɛ, baa yirɛ Aŋduru. U fa ŋaa Saamɔŋ Piita naaŋbie nɛ. U bula pi Yesu a bul, ");
INSERT INTO sil_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bii-bie kubala nɛ hɛ la tuɔŋ a kɛŋ boroboroba banɔŋ ari cheŋfilee balia. Ɛɛ nɛ saa kiaa deeŋba jaŋ wuo ŋaa niaa deeŋba?” ");
INSERT INTO sil_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ŋii nɛ Yesu bul di ba leŋ di nialiŋ hɔŋ. Di yaŋ bumo tɔsɛ lee-la. Ŋii nɛ nialiŋ hɔŋ. Ba tuɔŋ baalaa fa ŋaa bui banɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ŋii nɛ Yesu laa boroboroba-la a chuɔlɛ Wia, aŋ kaa kpaa nialiŋ si hɔnɔ. Ŋii nɛ u kɛŋ cheŋfilie-la ma kpaaba. Ba kuŋ-kala dii a vɔgɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba si dii a vɔgɛ ŋii, u bula pi u haritooroo di ba mu paa boroboroba-la si ka, di kuŋ-kala sí lɛl. ");
INSERT INTO sil_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ŋii nɛ ba paa ku-kaana-la nialiŋ si die aŋ ka, a su̱ siŋsiŋ fii ari balia. ");
INSERT INTO sil_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nialiŋ si hɛ dimɛ a na Yesu si ŋaa wu-magiliŋ deeŋ, ba bul di wutitii, baala deeŋ sɛnɛ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ba si si u jaŋ kɔ dunia nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ŋii nɛ Yesu jiŋ ari ba ŋaa siri nɛ di ba ku fugu duu dii ba kuoruŋ. Ŋii nɛ u mu faa peeliŋ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Didaaniŋ, Yesu haritooroo tuu muga ");
INSERT INTO sil_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a juu liiŋ daboro, a bira duoroo chol muga aa mu Kapɛnam. Taŋ bire di Yesu ha bi ba teeŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bua-la lɛ di pel-duo kubala maa lu a kɛŋ liiŋ kala ŋaa u viviisi. ");
INSERT INTO sil_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Di u haritooro-la ma duoro a mu yi meel-daasiŋ batori koo banɛsɛ, aŋ na Yesu duu vɛŋ liiŋ nyuŋ a kukɔ daboro-la teeŋ. Ba si na ŋii, fawulluŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ŋii nɛ Yesu bula piba a bul, “Ma sí leŋe di fawulluŋ kɛŋma, mi-na nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ŋii nɛ ba tuɔŋ tɔrɛ, ba joŋu hɛ liiŋ daboro-la tuɔŋ. Di liiŋ daboro-la guu yi lee-la ba fa síi mu. ");
INSERT INTO sil_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Taŋ si pula, ni-daŋ-la bira chiŋ muga-la cholo sɛmɛ dɔŋɔ, lee-la ba si mua. Didaaŋ-la ba fa na liiŋ daboro kubala nɛ duu chiŋ dimɛ. Ba jima ari Yesu haritooroo duŋduŋa nɛ juu liiŋ daboro-la. Yesu tuo ba tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ba si chiŋ dimɛ ŋii, liiŋ daborusuŋ dɔŋsuŋ lii Tabiiras kɔ lee-la, a kpagɛ lee-la Yesu fa si chuɔlɛ Wia aŋ joŋ boroboro piba di ba dii. ");
INSERT INTO sil_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nialiŋ si na di Yesu tuo, u haritooroo ma tuo, ba sii juu liiŋ daborusu-la a mu Kapɛnam aa chɛu. ");
INSERT INTO sil_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nialiŋ si na Yesu muga-la cholo dɔŋɔ, ba piɛsu a bul, “La kuhiaŋ, bua bɛɛ lɛ nɛ ŋ kɔ daha?” ");
INSERT INTO sil_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, maa chɛmi a tiŋ boroboro-la ma si dii vɔgɛ wiaa nɛ, ama wu-magila-la ma si na di mi ŋaa wiaa dee. ");
INSERT INTO sil_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma sí ma doluŋ kala hɛ a chɛ kudiilee. Kudiile-la jaŋ chei, ama má tima chichɛ kudiile-la si jaŋ pima miisi-la si bi dɛrɛ. Kudiilee deeŋba mi-na Nuhuobiine Bie nɛ jaŋ pima, bɛɛ wiaa mi Nyimma Wia joŋ doluŋ hɛmi lɛ nɛ di mii ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ŋii nɛ ba piɛsu, “Ɛɛ nɛ la jaŋ wuo ŋaa a tiŋ Wia tiŋtiŋŋaa?” ");
INSERT INTO sil_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ŋii nɛ u bul, “Tiŋtimii-la Wia si cho di maa tiŋ nɛ ŋla: Má laa mi wiaa dii, mi nɛ nii-la Wia si tima.” ");
INSERT INTO sil_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ŋii nɛ ba piɛsu, “Wu-magili bɛɛ nɛ ŋ jaŋ ŋaa di la na a laa ŋ wiaa dii? Bɛɛ nɛ ŋ jaŋ ŋaa? ");
INSERT INTO sil_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na la naabalimaba dii kudiilee nɛ giriŋ tuɔŋ baa yirɛ Mana. Wialiŋ ba si ŋmuŋsɛ Wia teniŋ tuɔŋ nɛ ŋla: Ba si, ‘U joŋ boroboro-la si lii wia nyuŋ nɛ a piba di ba dii.’ ” ");
INSERT INTO sil_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ŋii nɛ Yesu bul, “Mi bul wutitii nɛ aa pima. Kialiŋ Moosis si pima, u dee bima pa, Wia nɛ pima. Kudiile-la bima miisi-la si bi dɛrɛ ka pa. Mi Nyimma níi pi niaa boroboro titii-la si lii Wia-jaŋ. Kudiile-la joŋ miisi-la si bi dɛrɛ a pi dunia niaa. ");
INSERT INTO sil_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Boroboro-la Wia si ta, u lii Wia-jaŋ nɛ a ku tuu. U nɛ pi dunia niaa miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ŋii nɛ ba bul, “La Tiina, ŋii-na vɛnɛ joŋ boroboro deeŋ pipila.” ");
INSERT INTO sil_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ŋii nɛ Yesu bula piba a bul, “Mi nɛ ŋaa kudiile-la síi pi niaa miisiŋ. Nii-la kala si kɔ mi teeŋ, losuŋ bira bi jaŋ kɛŋ u tiina. Nii-la ma si laa mi wiaa dii, lii-nyuasuŋ ma bira bi jaŋ kɛnu. ");
INSERT INTO sil_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi bula pipima ari ma nami nɛ, ama ma bi mi wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nuu-na kala mi Nyimma si joŋo pimi, u jaŋ kɔ mi teeŋ. Niaa deeŋba kala si kɔ mi teeŋ, mi bi jaŋ kɔ di mi kiriba ta, ");
INSERT INTO sil_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","bɛɛ wiaa mi lii Wia-jaŋ ku tuu di mi ŋaa wialiŋ nii-la si tiŋmi síi chɛ nɛ, mi titia tuɔtɔrɛ wiaa dee. ");
INSERT INTO sil_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ŋla nɛ nii-la si tiŋmi chichɛ di mii ŋaa: di mi sí leŋe di nialiŋ u si joŋo pimi kuŋ-kala lɛl, ama di mi chuulɛba kala dunia didɛriŋ di ba kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wialiŋ mi Nyimma síi chɛ nɛ ŋla: Di nuu-na kala si na mi-na u Bie a laa mi wiaa dii, duu jaŋ kɛŋ miisi-la si bi dɛrɛ. Dunia didɛriŋ maa, ba ma jaŋ chisu suuŋ lɛ duu kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ŋii nɛ Ju̱u timma-la suomo gugurimɛ wiaa. U si si u nɛ ŋaa kudiile-la si lii Wia-jaŋ ku tuu, ŋii nɛ tii ba gugurimɛ u wiaa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ŋii nɛ ba bul, “Baala deeŋ dee Josɛf bie Yesuu? La jiŋ u nyimma ari u naaŋ kala nɛ. Ɛɛ nɛ saa lɛɛlɛ u si duu lii Wia-jaŋ nɛ a ku tuu?” ");
INSERT INTO sil_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ŋii nɛ Yesu bira bula piba, “Má leŋ ma wialiŋ gurimuŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nuu-kala bi jaŋ wuo kɔ mi teeŋ, see di mi Nyimma-la si tiŋmi nɛ kɛŋ u tiina kaa kɔ mi teeŋ, di mi chisu suuŋ lɛ dunia didɛriŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba ŋmuŋsɛ ŋla nɛ Wia teniŋ tuɔŋ. Ba si, ‘Wia jaŋ dagɛ niaa kala.’ Nuu-kala si ŋaa siri duu jegile nii wialiŋ Wia síi dagu, a gunnɛ u teeŋ, u nɛ jaŋ kɔ mi teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","U ŋii ma saa bi nagɛ ari nuu-kala na mi Nyimma Wia nɛ, see nii-la si lii Wia teeŋ. U duŋduŋa nɛ nau. ");
INSERT INTO sil_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wutitii nɛ mi bulaa pima, nii-la kala si laa mi wiaa dii, u jaŋ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi nɛ ŋaa kudiile-la síi pi niaa miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ma naabalimaba dii kudiile-la ba síi yirɛ ‘Mana’ nɛ giriŋ tuɔŋ. Ari ŋii kala ba-na ha suba nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama kudiile-la si lii Wia-jaŋ ku tuu, di nuu nɛ diiba, u bi jaŋ suu. ");
INSERT INTO sil_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi-na nɛ ŋaa kudiile-la si kɛŋ miisiŋ a lii Wia-jaŋ ku tuu. Di nuu nɛ dii kudiilee deeŋba, u jaŋ kɛŋ miisi-la si bi dɛrɛ. Mi yaraa namia nɛ ŋaa kudiile-la mi si jaŋ joŋo pi dunia niaa di ba kɛŋ miisi-la si bi dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu si bul ŋii, Ju̱u tiŋŋaa suomo kɛŋ wii-la lilɛrɛ a bul, “Ɛɛ nɛ baala deeŋ jaŋ wuo ŋaa a joŋ u yaraa namia pila di la chaŋ?” ");
INSERT INTO sil_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, di ma nɛ bi mi-na Nuhuobiine Bie yaraa namia chaŋa, a nyua mi chaliŋ maa, ma bi jaŋ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nii-la kala si chaŋ mi yaraa namia, a nyua mi chaliŋ maa, u jaŋ kɛŋ miisi-la si bi dɛrɛ. Di dunia ma nɛ dɛrɛ, mi jaŋ chisɛ u tiina suuŋ lɛ duu kɛŋ miisiŋ, ");
INSERT INTO sil_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","bɛɛ wiaa mi yaraa namia sɛnɛ ŋaa kudiilee nɛ. Mi chaliŋ ma sɛnɛ ŋaa lii-nyualuŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nii-la kala si chaŋ mi yaraa namia-la a nyua mi chal-la, u jaŋ hɛ mi teeŋ a kaa mu wuu, mi ma jaŋ hɛ u teeŋ a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mi Nyimma-la si kɛŋ miisiŋ a tiŋmi ŋii, ŋii nɛ mi ma kɛŋ miisiŋ. Ŋii titia nɛ nii-la ma si chaŋ mi yaraa namia ma jaŋ kɛŋ miisiŋ a tiŋ mi wiaa. ");
INSERT INTO sil_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kudiile-la si lii Wia-jaŋ ku tuu nɛ ŋii. U bi naga kudiile-la ma naabalimaba si die aŋ ha suu nɛ. Nii-la kala si dii kudiilee deeŋba, u jaŋ kɛŋ miisi-la si bi dɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu bul wiaa deeŋba duu hɛ Kapɛnam tiŋteeŋ lɛ nɛ aa dagɛ niaa Wii-chuɔlɛ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Niaa yuga a faa to Yesu hariŋ, a nii wialiŋ u si bula a bul, “Wiaa deeŋba u síi dagɛ, ba hɛyɛ kiŋkɛŋ. Kubɛɛ nɛ jaŋ wuo jegili wiaa deeŋba?” ");
INSERT INTO sil_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ba bi wii-kala bula, ka Yesu jiŋ ari u haritooro-la ka gurimɛ wiaa nɛ a tiŋ wialiŋ u si bula lɛ. Ŋii nɛ u piɛsɛba a bul, “Wiiŋ deeŋ leŋe ma na baaniŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka di ma nɛ saa fa na mi-na Nuhuobiine Bie di mi miiraa mu lee-la mi si liaa? ");
INSERT INTO sil_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wia Diŋ-zɔŋ-la nɛ ku-la si pila miisi-la si bi dɛrɛ. Nuhuobiine yaraa doluŋ-na ŋaa pɛi nɛ. U bi miisi-la si bi dɛrɛ wuo pa. Wia Diŋ-zɔŋ-la wiaa nɛ mi bula pima. Ba jaŋ pima miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama ma dɔŋsuŋ bi mi wiaa laa dii.” Buŋbuŋ kala Yesu fa jiŋ nialiŋ si bi u wiaa laa dii nɛ ari nii-la si jaŋ joŋu yallɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ŋii nɛ Yesu bira bul, “Wiiŋ deeŋ wiaa nɛ tii mi bula pima ari nuu-kala bi jaŋ wuo kɔ mi teeŋ, see di mi Nyimma pi u tiina woŋbiiŋ duu wuo kɔ.” ");
INSERT INTO sil_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A tiŋ wiiŋ deeŋ wiaa ni-daŋ-la fa si to u hariŋ, ba miirɛ hariŋ. ");
INSERT INTO sil_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ŋii nɛ Yesu piɛsɛ u haritooroo fii ari balia-la a bul, “Ma ma cho di ma miirɛ mi hariŋ nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ŋii nɛ Saamɔŋ Piita piɛsu a bul, “La Tiina, kubɛɛ teeŋ nɛ saa la ma jaŋ mu? Wialiŋ ŋ síi bul níi pi niaa miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lɛɛlɛ la laa dii a jiŋ ari ŋ nɛ ŋaa Wia Tuɔ-pul Tiina.” ");
INSERT INTO sil_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ŋii nɛ Yesu piɛsɛba a bul, “Ma niaa fii ari balia dee mi liisɛɛ? Ama ma dɔŋɔ ŋaa diŋdɔŋ nɛ a ŋaa Sitaani tiina.” ");
INSERT INTO sil_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas, Saamɔŋ Isikarɔt bie wiaa nɛ u faa bul ŋii. U fa hɛ u haritooro-la fii ari baliamiŋ tuɔŋ nɛ, ama u nɛ fa jaŋ joŋ Yesu yallɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ŋii hariŋ Yesu gugɔllɛ Galilii tiŋteeŋ. U bi cho duu mu gɔllɛ Judiya tiŋteeŋ lɛ, bɛɛ wiaa Ju̱u tiŋŋaa fa si hɛ Judiya tiŋteeŋ lɛ ka chɛ di ba kpuu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Di Ju̱u tiŋŋaa gbieli-bal kubala yie. Gbiele-la lɛ ba yie leŋ ba diisiŋ aŋ hɛ lɛŋŋɛɛ nɛ a jujuu. Di gbiele-la nɛ dɛrɛ, ba bira miira mu a jujuu ba diisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ŋii nɛ Yesu ŋaanaa bula pi Yesu a bul, “Sii daha a mu Judiya tiŋteeŋ, di ŋ haritooroo ma wuo na wialiŋ ŋ síi ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nii-la síi chɛ di ba jimu, u bi faa ŋiŋaa wiaa. Ŋ síi ŋaa wiaa deeŋba, leŋ di dunia niaa kala na.” ");
INSERT INTO sil_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ba titia paala bi u wiaa laa dii, ŋii nɛ tii ba bul ŋii. ");
INSERT INTO sil_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ŋii nɛ Yesu bula piba a bul, “Bua-la si jaŋ yi di mi mu gbiele-la, u ha bi yie. Ma-na teeŋ bua-na kala maga nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dunia niaa bima bɛrɛ, ama ba bɛrɛ mi-na nɛ. Mi vɛnɛɛ bula piba ari baa ŋaa wu-bɔŋŋɔɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Má-na lii mu gbiele-la, mi-na ha bi mu, bɛɛ wiaa bua-la si jaŋ yi di mi mu ha bi yie.” ");
INSERT INTO sil_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","U bul ŋii aŋ hɔŋ Galilii tiŋteeŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu ŋaana-la si mu gbiele-la dɛrɛ, Yesu ma sii mu. Ama u bi niaa hariŋ to. U luɔra mu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ju̱u tiŋŋaa si hɛ gbiele-la lɛ, ba bee chichɛ Yesu gbiele-la lɛ, a pipiɛsɛ di nii lɛ nɛ u hɛ? ");
INSERT INTO sil_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ŋii nɛ nialiŋ si hɛ gbiele-la leriŋ, ba jesiŋ suomo a muŋsi a bubul Yesu wiaa. Dɔŋsuŋ si duu ŋaa ni-zɔŋ nɛ. Dɔŋsuŋ ma bi sɛyɛ aŋ bul duu nyisɛ niaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama ba kala faa fá Ju̱u timma-la nɛ, ŋii nɛ tii nuu-kala bi wuo faasa bul u wiaa. ");
INSERT INTO sil_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gbiele-la si ku kpaa maga dɔŋɔ, Yesu juu Wia-dia a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","U si dagɛ niaa ŋii ŋaa Ju̱u timma-la si jegile nii wialiŋ wu-kpuŋkpere. Ba si, “Ɛɛ nɛ baala deeŋ jiŋ wiaa ŋla kiŋkɛŋ aŋ bi lee yie?” ");
INSERT INTO sil_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ŋii nɛ Yesu bula piba a bul, “Wialiŋ mi síi dagu, mi titia doluŋ lɛ dee mii dagɛ. Nii-la si tiŋmi nɛ dagɛmi wialiŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nii-la kala síi chɛ duu ŋaa wii-la mi si cho, u jaŋ wuo jiŋ ari wialiŋ mi síi dagu lii Wia teeŋ nɛ, koo mi titia doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nii-la si yie bubul wiaa u titia doluŋ lɛ yie bula chichɛ u titia yiriŋ nɛ. Ama nii-la síi chɛ di nii-la si timu laa yiriŋ, u ŋaa ni-titii nɛ. U bi wiaa ka nyia. ");
INSERT INTO sil_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moosis bil niiŋ pima nɛ di maa to. Ama ma kuŋ-kala bi ni̱i-la to. Bɛɛ nɛ tii maa chɛ di ma kpumi?” ");
INSERT INTO sil_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ŋii nɛ nialiŋ bula pu a bul, “Ŋŋ nyaasɛ nɛ. Kubɛɛ níi chɛ di u kpuŋ?” ");
INSERT INTO sil_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ŋii nɛ Yesu bula piba a bul, “Mi ŋaa wu-bala nɛ ma chɛ-wiesii-la chɛɛŋ, u ŋaa ma wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Moosis fa bula pima di ma kikeri ma biiriŋ penee. U dee bi ŋii suomo. U naabalimaba nɛ suomo ŋaa ŋii. U si ŋaa ma kisiŋ ŋii, ma paala yie keri ma biiriŋ penee chɛ-wiesii-la chɛɛŋ, di ba lulluŋ nɛ tel ŋii lɛ. Di ma nɛ saa jaŋ wuo to Moosis niiŋ aa keri ma biiriŋ penee chɛ-wiesii-la chɛɛŋ, di ba lulluŋ nɛ tel chɛ-wiesii-la chɛɛŋ, bɛɛ nɛ saa tii maa na baaniŋ a tiŋ mi si ŋaa puwuoloo duori chɛ-wiesii-la chɛɛŋ? ");
INSERT INTO sil_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Di nuu nɛ ŋaa wii, ma sí guu joŋ taali pu a tiŋ ma si biina ari u bi woruŋ ŋaa wiaa. Má biinɛ wii-la tuɔŋ a jiŋ u wutitii, aŋ-na joŋ taali pu.” ");
INSERT INTO sil_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ŋii nɛ niaa dɔŋsuŋ si lii Jerusalɛm piɛsɛ a bul, “Baala deeŋ dee ba chichɛ di ba kpu ŋii? ");
INSERT INTO sil_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na, u nɛ chiŋ niaa tuɔŋ ŋii aa bul wiaa, ka nuu-kala bi wii wuo bul, koo nihiasi-la jima ari u nɛ ŋaa Kirisito, nii-la Wia si liisaa? ");
INSERT INTO sil_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nii-la Wia si jaŋ tiŋ, duu nɛ kɔ, nuu-kala bi jaŋ jiŋ u si lii lee-la, ama la kala nɛ jiŋ lee-la baala deeŋ si lia.” ");
INSERT INTO sil_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu síi dagɛ niaa Wia-dia-la tuɔŋ ŋii, ŋii nɛ u faasa piɛsɛ, “Ma sɛnɛ jiŋmi nɛɛ, a jiŋ lee-la mi si liaa? Ama mi saa bi mi titia doluŋ lɛ nɛ kɔ. Nuu nɛ tiŋmi. Nii-la ma saa si tiŋmi ŋaa Wutitii Tiina nɛ. Ma buu jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mi-na jimu nɛ, bɛɛ wiaa mi fa hɛ u teeŋ nɛ. Ŋii nɛ u tiŋmi.” ");
INSERT INTO sil_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ŋii nɛ ba chichɛ di ba kɛnu, ama bua-la lɛ u si jaŋ suu ha bi yie. Ŋii nɛ tii nuu-kala nisiŋ buu dige. ");
INSERT INTO sil_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama niaa yuga nialiŋ tuɔŋ a laa u wiaa dii a piɛsɛ a bul, “Ma biina di Kirisito, nii-la Wia si jaŋ liisɛ nɛ kɔ, u jaŋ ŋaa wu-magilaa kii nia deeŋ?” ");
INSERT INTO sil_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisii tiŋŋaa si nia di nialiŋ muŋso bubul Yesu wiaa ŋii, ŋii nɛ ba di nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ tiŋ ba tiŋtinni-biisiŋ di ba mu kɛŋ Yesu. Ba si mu lee-la Yesu fa si hɛ di ba kɛnu, ba nii wialiŋ u si bula pipi niaa. ");
INSERT INTO sil_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","U si, “Mi jaŋ hɛ ma teeŋ tapulaa baŋmɛnɛ, aŋ miira mu nii-la si tiŋmi teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma jaŋ chɛmi ka. Lee-la mi si jaŋ hɛ, ma bi jaŋ wuo mu dimɛ.” ");
INSERT INTO sil_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ŋii nɛ Ju̱u timma-la piɛsɛ di nii nɛ uu chɛ duu mu ba bi jaŋ nau? Duu chɛ duu mu Giriik tiŋteeŋ, lee-la Ju̱u tiŋŋaa si guoli ba tuɔŋ nɛ, a didagɛbaa? Ba bira si, ");
INSERT INTO sil_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“U si di la jaŋ chɛu ka, a bira bul di la bira bi jaŋ wuo mu lee-la u si jaŋ hɛ. U si bul ŋii, u bubuɔŋ nɛ bɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gbiele-la chɛ-dɛriŋ, tapulii-la nɛ fa ŋaa gbiele-la siifiaŋ chɛɛŋ. Ŋii nɛ Yesu sii chiŋ a faasa bul, “Nii-la kala lii-nyuasuŋ si kɛnɛ, má leŋ duu kɔ mi teeŋ a nyua liiŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nii-la kala si laa mi wiaa dii, u jaŋ nagɛ lii-bulo u tuɔŋ lɛ a bubu̱l. Ba bul ŋla nɛ Wia teniŋ tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu bul wiaa deeŋba a tigɛ Wia Diŋ-zɔŋ-la lɛ nɛ u si jaŋ joŋo hɛ nialiŋ si laa u wiaa dii lɛ. Bua-la lɛ di u ha bi Wia Diŋ-zɔŋ-la joŋo hɛba lɛ, bɛɛ wiaa u ha bi suuŋ lɛ sie duu laa yiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ni-daŋ-la fa si hɛ dimɛ a nii wialiŋ Yesu si bula, ŋii nɛ ba dɔŋsuŋ bul di nia deeŋ sɛnɛ ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dɔŋsuŋ ma si, duu nɛ ŋaa Kirisito, nii-la Wia si liisa. Ama dɔŋsuŋ ma si di nii-la Wia si liisa bi jaŋ lii Galilii tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wia teniŋ tuɔŋ ba bula ari Kirisito, nii-la Wia si liisa, ŋaa Devit doho nuu nɛ a lii Bɛtilɛhɛm. Devit jaŋ nɛ fa Bɛtilɛhɛm. ");
INSERT INTO sil_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ŋii nɛ nialiŋ kɛŋ wiiŋ deeŋ lilɛrɛ a pɔrɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ba dɔŋsuŋ chichɛ di ba kɛŋ Yesu, ama nuu-kala bi nisiŋ joŋo digu. ");
INSERT INTO sil_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ŋii nɛ tiŋtinni-biisi-la ba si tima di ba mu kɛŋ Yesu, ba miira mu Farisii tiŋŋaa ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ teeŋ, ari na-hilliŋ. Ŋii nɛ ba piɛsɛba a bul, “Bɛɛ nɛ tii ma buu kaa kɔ?” ");
INSERT INTO sil_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ŋii nɛ ba bul, “Nuu-kala ha bi wiaa bula ari baala deeŋ síi bul ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ŋii nɛ Farisii kuhiasi-la piɛsɛba a bul, “U nyisɛma ma nɛɛ? ");
INSERT INTO sil_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma nia ari ma kuhiasiŋ tuɔŋ koo la Farisii tiŋŋaa tuɔŋ kubala ma ha laa u wiaa dii? ");
INSERT INTO sil_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama ni-daŋ deeŋ kala si hilime, ba bi wialiŋ Moosis si ŋmuŋsa bil jiŋ. Wia jaŋ kpusɛ ba nyusuŋ.” ");
INSERT INTO sil_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Baal kubala baa yirɛ Nikodiimas, u ma fa ŋaa Farisii tiŋŋaa dɔŋɔ nɛ a hɛ ba tuɔŋ. U-na fa laa sipaaŋ mu Yesu teeŋ nɛ aŋ ka. ");
INSERT INTO sil_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ŋii nɛ u bula piba a bul, “La kisiŋ nɛ di la joŋ cheeriŋ a pi nuu duu nɛ ŋaa wii, see di la laa sipaaŋ nii tiina niiŋ, a jiŋ wii-la u si ŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ŋii nɛ Farisii timma-la piɛsu a bul, “Ŋ ma ŋaa Galilii tiina nɛɛ? Karimɛ Wia teniŋ. Di ŋ ŋaa ŋii, ŋ jaŋ na ari nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba kuŋ bi Galilii tiŋteeŋ lia.”  ");
INSERT INTO sil_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ŋii nɛ ba kala sii pisɛ a mu ba diisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ŋii nɛ ka Yesu ma lii dimɛ a jil peel kubala baa yirɛ Oliv nyuŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Taŋ si pula chichuɔ-fiɛla, u bira miira mu a juu Wia-dia. Niaa ku gbaaru, u hɔŋ a bira suomo didagɛba. ");
INSERT INTO sil_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ŋii nɛ Wia teniŋ kerichiba ari Farisii tiŋŋaa kɛŋ haal kubala ku juu. Ba kɛŋ haal-la duu piŋ nuu bala. Ba leŋ u chiŋ ba tutuɔbaaniŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ŋii nɛ ka ba bula pi Yesu a bul, “La kuhiaŋ, la kɛŋ haala deeŋ duu hiilɛ nuu bala nɛ. ");
INSERT INTO sil_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wialiŋ Moosis fa si bile di niaa tuto daga ari nuu-kala nɛ ŋaa ŋii, di la yaga kpuu nɛ ari tabiaa. Bɛɛ nɛ ŋ ma bul?” ");
INSERT INTO sil_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba bul ŋii di ba ŋmoo Yesu fehe lɛ nɛ, a wuo na woŋbiiŋ a bul u teeŋ. Ŋii nɛ Yesu kɛŋ u nyuŋ chugili tiŋteeŋ aŋ kɛŋ u neniiŋ tutuuri tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka ba ha chiŋ aa piɛsɛ wiaa. Ŋii nɛ Yesu kɛŋ u nyuŋ wul wia nyuŋ a bula piba a bul, “Ma ku-la kala ha si bi haachɛ wii ŋaa, má leŋ duu laa sipaaŋ joŋ tabiiŋ a yagɛ haal-la, di ku-kaanaa ma pɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ŋii nɛ u bira kɛŋ u nyuŋ chugili a bira kɛŋ u neniiŋ a tutuuri tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba si nii wialiŋ u si bula, ba kala lii kuŋ kuŋ. Ba tuɔŋ nihiasi-la nɛ laa sipaaŋ lii, ka ku-kaanaa tuto, aŋ ka Yesu ari haal-la duŋduŋa lee-la. ");
INSERT INTO sil_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ŋii nɛ Yesu kɛŋ u nyuŋ jee a piɛsɛ haal-la a bul, “Nii nɛ nialiŋ hɛ? Nuu-kala tuo duu yagiŋ kpuu?” ");
INSERT INTO sil_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Haal-la si di nuu-kala tuo. Ŋii nɛ Yesu bula pu a bul, “Tɔɔ, mi ma bi jaŋ ŋaaŋ wii-kala. Viiri aŋ bira sí haachɛ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ŋii nɛ Yesu bira suomi a didagɛ niaa. U bula piba a bul, “Mi nɛ ŋaa dunia niaa pulumuŋ. Nii-la kala si tomi bi jaŋ vɛŋ birimiŋ tuɔŋ. U jaŋ vɛŋ pulumuŋ tuɔŋ. Miisi-la mi si jaŋ pu jaŋ chaanɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ŋii nɛ Farisii timma-la bula pu a bul, “Ŋ titia wiaa nɛ ŋ bubul ŋii, wialiŋ saa ŋ si bula bi wutitii kɛnɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ŋii nɛ Yesu bula piba a bul, “Di mi nɛ bul mi titia wiaa maa, wii-la mi si bula ŋaa wutitii nɛ, bɛɛ wiaa mi jiŋ lee-la mi si lia nɛ, a jiŋ lee-la mi si jaŋ mu. Ama ma-na bi lee-la mi si lia jiŋ, a bira bi lee-la mi si jaŋ mu ma jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ma yie joŋ cheeriŋ pi nuu a tiŋ ma si biina ari u si bi woruŋ ŋaa wiaa. Mi-na bi nuu-kala cheeriŋ pa. ");
INSERT INTO sil_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Di mi nɛ faa joŋ cheeriŋ pi niaa maa, u fa jaŋ ŋaa wutitii, bɛɛ wiaa mi duŋduŋa dee bi cheeriŋ joŋo pi tiina, mi Nyimma-la si tiŋmi nɛ pɛmi lɛ la joŋ cheeriŋ a pi tiina. ");
INSERT INTO sil_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wialiŋ Moosis fa si bile di niaa tuto daga ari niaa balia nɛ na wiiŋ, a bul duu ŋaa wutitii nɛ, di wii-la sɛnɛ ŋaa wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mii bul mi titia wiaa nɛ, mi Nyimma-la ma si tiŋmi, u ma bubul mi wiaa.” ");
INSERT INTO sil_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ŋii nɛ ba piɛsu, “Nii nɛ ŋ Nyimma hɛ?” Ŋii nɛ Yesu bul, “Ma bimi jiŋ, ŋii wiaa ma bi mi Nyimma ma jiŋ. Di ma nɛ fa jiŋmi, ma fa jaŋ jiŋ mi Nyimma maa.” ");
INSERT INTO sil_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu bul wiaa deeŋba kala bua-la lɛ u síi dagɛ niaa Wia-dia lɛ nɛ, lee-la ba si yie joŋ kialiŋ bile pipi Wia. Ka nuu-kala buu kɛnɛ, bɛɛ wiaa bua-la lɛ ba si jaŋ kɛnu ha bi yie. ");
INSERT INTO sil_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ŋii nɛ Yesu bira bula pi nialiŋ a bul, “Mi jaŋ viiri, ma jaŋ chɛmi ka, ma saa jaŋ suu ari ma haachɛba. Lee-la mi síi mu, ma bi jaŋ wuo mu dimɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ŋii nɛ Ju̱u timma-la piɛsɛ dɔŋɔ a bul, “U si, la bi jaŋ wuo mu lee-la u síi mu. U saa bula magisɛ ari u jaŋ kpu u titia nɛ koo ɛɛ nɛ u bul ŋla?” ");
INSERT INTO sil_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ŋii nɛ Yesu bira bula piba a bul, “Ma lii dunia deeŋ nɛ, ka mi ma lii Wia-jaŋ. Ma lii dunia nɛ, aŋ ka mi ma bi dunia lia. ");
INSERT INTO sil_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mi laa sipaaŋ bula pima ari ma jaŋ suu ari ma haachɛba. Ma sɛnɛ jaŋ suu ari ma haachɛba, see di ma laa mi wiaa dii ari mi si si mi ŋaa nii-la.” ");
INSERT INTO sil_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ŋii nɛ ba piɛsu a bul, “Kubɛɛ nɛ ŋ ŋaa?” Ŋii nɛ Yesu bula piba a bul, “Mi si suomo dagɛ niaa, mi dagɛ nii-la mi si ŋaa nɛ a pima. ");
INSERT INTO sil_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi kɛŋ wiaa yugɛ nɛ di mi bul a tigɛma lɛ, a wuo to wialiŋ lɛ a joŋ cheeriŋ pima. Nii-la si tiŋmi, u sɛnɛ ŋaa Wutitii Tiina nɛ. Wialiŋ mi síi nii, u niiŋ lɛ nɛ mi saa bula pi dunia niaa.” ");
INSERT INTO sil_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","U síi bul ŋii, nialiŋ fa bi jiŋ ari u Nyimma Wia wiaa nɛ u bulaa piba ŋii. ");
INSERT INTO sil_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ŋii nɛ Yesu bula piba, “Di ma nɛ kɛŋ mi-na Nuhuobiine Bie kpaasɛ daa-gɛsɛɛ nyuŋ, ma jaŋ jiŋ ari mi nɛ ŋaa nii-la mi si si mi ŋaa. Ŋii ma lɛ nɛ ma jaŋ to jiŋ ari mi bi wii-kala ŋaa mi titia doluŋ lɛ, ama mi yie bul wialiŋ mi Nyimma si dagɛmi nɛ. ");
INSERT INTO sil_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nii-la ma saa si tiŋmi bimi duŋduŋa leŋe, u ma hɛ mi teeŋ nɛ, bɛɛ wiaa mi yie ŋaa wialiŋ síi tɔrɛ u tuɔŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","U si bul wiiŋ deeŋ, niaa yuga a laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ŋii nɛ Yesu bula pi Ju̱u timma-la si laa u wiaa dii a bul, “Di ma nɛ nii mi niiŋ wialiŋ, ma jaŋ sɛnɛ ŋaa mi haritooroo. ");
INSERT INTO sil_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma jaŋ jiŋ wutitii. Wutitii-la saa jaŋ leŋ di Wia laama ta di ma tii ma titia.” ");
INSERT INTO sil_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ju̱u timma-la si laa Yesu wiaa dii ma bul, “La paala ŋaa Abiraham doho niaa nɛ. La ha bi nuu-kala yosu ŋaa. Bɛɛ nɛ saa tii ŋ bul di Wia jaŋ laala ta di la tii la titia?” ");
INSERT INTO sil_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, nuu-na kala si ŋaa haachɛ, u tiina ŋaa haachɛ yoŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Di yomo nɛ hɛ nuu dia lɛ, u bi dia-la lɛ jaŋ hɛ deeŋ deeŋ. Ama di dia-la tiina nɛ kɛŋ bii, u-na jaŋ hɛ dia-la lɛ a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Di mi-na Wia Bie nɛ saa laama ta, mi sɛnɛ laama ta nɛ di ma tii ma titia. ");
INSERT INTO sil_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi jima ari ma ŋaa Abiraham doho niaa nɛ, aŋ ka ma chichɛ di ma kpumi, bɛɛ wiaa wialiŋ mi si dagɛma bi ma digilaa jua. ");
INSERT INTO sil_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi-na yie bul wialiŋ mi Nyimma si dagɛmi nɛ, ma ma ŋiŋaa wialiŋ ma nyimma si dagɛma di ma ŋiŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ŋii nɛ ba bula pu a bul, “Abiraham nɛ ŋaa la nyimma.” Ŋii nɛ Yesu ma bul, “Di ma nɛ sɛnɛ fa ŋaa Abiraham biiri, ma fa jaŋ ŋiŋaa wialiŋ Abiraham fa síi ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mi bul wutitii nɛ pima, wialiŋ Wia si dagɛmi. A tiŋ wiiŋ deeŋ wiaa nɛ maa chɛ di ma kpumi. Abiraham fa bi ŋii ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Maa ŋaa wialiŋ ma nyimma síi ŋaa nɛ.” Ŋii nɛ ba bul, “La bi maŋgaa-biiri ŋaa. La kala nyimma nɛ kubala. Wia nɛ ŋaa la Nyimma.” ");
INSERT INTO sil_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ŋii nɛ Yesu bula piba a bul, “Di Wia nɛ sɛnɛ fa ŋaa ma Nyimma, ma fa jaŋ chomi, bɛɛ wiaa, Wia teeŋ nɛ mi lii a kɔ daha. Mi titia doluŋ lɛ dee mi kɔ. U nɛ tiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɛɛ nɛ saa tii ma bi wialiŋ mi si bula bubuɔŋ jiŋ? Ma bi chɛ di ma jegile nii wialiŋ mi síi bul. Ŋii nɛ tii ma bi ba bubuɔŋ jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ma nyimma nɛ ŋaa Sitaani. Ma ma saa cho di maa ŋaa u tuɔtɔrɛ wiaa nɛ. Dunia di-suomuŋ kala lɛ nɛ u ŋaa ni-kpuuru. U titia bi wutitii kɛnɛ. Ŋii nɛ tii u bi wutitii ka to. Di u nɛ nyia wiaa maa, u nagisiŋ nɛ paala ŋii. U ŋaa wu-nyiaru nɛ, a paala ŋaa wu-nyiaraa kala nyimma maa. ");
INSERT INTO sil_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama a tiŋ mi síi bul wutitii wiaa nɛ ma bi mi wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ma kubɛɛ nɛ jaŋ wuo dagɛ ari mi kɛŋ haachɛ? Di mi níi bul wutitii, bɛɛ nɛ saa tii ma bi mi wiaa laa dii? ");
INSERT INTO sil_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nii-la kala si lii Wia teeŋ yie jegile nii wialiŋ Wia síi bul nɛ. Ma bi Wia teeŋ lia, ŋii nɛ tii ma bi wialiŋ u síi bul jegile nii.” ");
INSERT INTO sil_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ŋii nɛ Ju̱u timma-la bula pi Yesu a bul, “La bi wutitii bulaa, la si si ŋ ŋaa Samaria tiina nɛɛ, jiŋ-bɔmuŋ ma kɛniŋŋ?” ");
INSERT INTO sil_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ŋii nɛ Yesu bula piba a bul, “Jiŋ-bɔŋ bimi kɛnɛ, ama mii pi mi Nyimma jirima nɛ, aŋ ka ma-na bimi jirima ka pa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi bi yiriŋ chɛ pipi mi titia. Ama nuu nɛ hɛ dimɛ a chɛ yiri-la pipimi. U nɛ saa jaŋ dii nialiŋ si via mi wiaa sariya. ");
INSERT INTO sil_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wutitii nɛ mi bulaa pima, nii-la kala síi to mi niiŋ wiaa, u bi jaŋ suu.” ");
INSERT INTO sil_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ŋii nɛ Ju̱u timma-la bula pu a bul, “Lɛɛlɛ la jima ari ŋ kɛŋ jiŋ-bɔŋ nɛ. Abiraham suba nɛ. Nialiŋ ma síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba ma suu. Aŋ ka ŋ bul di nii-la kala síi to ŋ niiŋ wiaa bi jaŋ kɔ duu suba. ");
INSERT INTO sil_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","La nyimma Abiraham suba nɛ. Ŋ saa biina di ŋ kiiu nɛɛ? Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ma suu. Ŋ saa biina ŋ ŋaa kubɛɛ nɛ?” ");
INSERT INTO sil_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ŋii nɛ Yesu bira bula piba a bul, “Di mi níi pi mi titia yiriŋ, yiri-la ŋaa yiri-pɛi nɛ. Mi Nyimma nɛ nii-la síi pimi yiriŋ, nii-la ma si si u ŋaa ma Wia nɛ. ");
INSERT INTO sil_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma buu jiŋ, ama mi-na jimu nɛ. Di mi nɛ jaŋ bul ari mi buu jiŋ, mi jaŋ ŋaa wu-nyiaru, ari ma si ŋaa wu-nyiaraa ŋii. Mi saa jimu nɛ a tuto u niiŋ. ");
INSERT INTO sil_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma naabalima Abiraham nia ari mi jaŋ kɔ dunia duu nami. U si nii ŋii, u tuɔŋ fa tɔrɛ. U paala nami nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ŋii nɛ Ju̱u timma-la bula pu a bul, “Ŋ ha paala bi jisiŋ mahiŋ balia ari fii yie. Ɛɛ nɛ saa ŋ ŋaa a na Abiraham?” ");
INSERT INTO sil_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ŋii nɛ Yesu bula piba a bul, “Wutitii nɛ mi bulaa pima, ka di ba-na lul Abiraham, mi fa hɛ dimɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ŋii nɛ ba paa tabiaa di ba yagu. U kɛŋ u titia faa a luɔra lii Wia-dia-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu si joŋ woŋbiiŋ vivɛŋ, u na baal kubala, ba lulu duu nyulima nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ŋii nɛ Yesu haritooroo piɛsu a bul, “Kuhiaŋ, kubɛɛ haachɛ nɛ ŋaa baala deeŋ nyulimɛ? Baal-la haachɛ nɛ koo u nyimma ari u naaŋ haachɛ nɛ?” ");
INSERT INTO sil_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ŋii nɛ Yesu bula piba a bul, “Baal-la nyulimuŋ bi u haachɛba lɛ lia, u nyimma ari u naaŋ haachɛ ma dee bi tii u nyulimɛ. U nyulima di niaa wuo na ŋii Wia dol-la si wuo tiŋ tiŋtiŋŋaa u lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","La si na woŋbiiŋ, má leŋ di la tiŋ tiŋtimii-la nii-la si tiŋmi di mi tiŋ. Bua kubala jaŋ yi nuu-kala bira bi jaŋ wuo tiŋ tiŋtimii-la. ");
INSERT INTO sil_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mi ha si hɛ dunia lɛ ŋii, mi nɛ ŋaa dunia niaa pulumuŋ.” ");
INSERT INTO sil_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu si bul ŋii nɛ, u tu naŋtuɔruŋ bil tiŋteeŋ a kaa buu tiariŋ, a paa a taa baal-la siaa, aŋ bula pi baal-la a bul, ");
INSERT INTO sil_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Sii tuu fuo kubala baa yirɛ Siloom (yiriŋ deeŋ bubuɔŋ nɛ ŋaa ‘mi timu nɛ’) a sɔŋ ŋ siaa.” Ŋii nɛ baal-la sii tuu sɔŋ u siaa fuo-la lɛ. U siaa suri, u miira kɔ. ");
INSERT INTO sil_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ŋii nɛ nialiŋ si kpagu, ari nialiŋ kala fa si na baal-la duu faa sul kiaa, ba pipiɛsɛ dɔŋɔ, “Baala deeŋ dee fa bi hɔnɔ susul kiaa ŋii?” ");
INSERT INTO sil_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dɔŋsuŋ si u nɛ, dɔŋsuŋ ma si duu dee, ama u ta nagu nɛ. Ŋii nɛ baal-la titia bul duu nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ŋii nɛ ba piɛsu, “Ɛɛ nɛ ŋ ŋaa ŋ siaa suri?” ");
INSERT INTO sil_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ŋii nɛ baal-la bul di nii-la ba síi yirɛ Yesu nɛ buu tiariŋ, a paa taa u siaa lɛ, aŋ bula pu duu tuu Siloom fuo-la a sɔŋ. U tuu sɔŋ, u siaa suri. ");
INSERT INTO sil_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ŋii nɛ ba piɛsu, “Nia lɛ nɛ u hɛ?” Baal-la bul di u bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ŋii nɛ ba kɛŋ baal-la fa si nyulima a kaa mu Farisii tiŋŋaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tapulii-la Yesu si buu tiariŋ a taa baal-la siaa ba suri, u ŋaa chɛ-wiesii-la chɛɛŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ŋii nɛ Farisii timma-la piɛsɛ baal-la ŋii u si ŋaa u siaa suri. Baal-la bula piba a bul di Yesu ŋaa tiariŋ nɛ taa u siaa, u sɔŋ, u siaa suri. ");
INSERT INTO sil_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ŋii nɛ ba kɛŋ wii-la lilɛrɛ. Farisii tiŋŋaa dɔŋsuŋ bula ari Wia dee bi baala deeŋ tima, bɛɛ wiaa u bi ba chɛ-wiesii-la kisiŋ lɛ ka to. Ŋii nɛ dɔŋsuŋ ma si di “Ɛɛ nɛ nuu si ŋaa haachɛ tiina jaŋ wuo ŋaa wu-magilaa deeŋba?” ");
INSERT INTO sil_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ŋii nɛ Farisii timma-la bira piɛsɛ baal-la a bul, “U si suri ŋ siaa ŋii, ni-bɛɛ nɛ ŋ biina ari u ŋaa?” Ŋii nɛ baal-la si u-na biina ari nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ama Ju̱u tiŋŋaa kuhiasi-la si, ba-na bi laa dii ari baal-la fa nyulima nɛ aŋ lɛɛlɛ nina ŋii, see di ba yirɛ u nyimma ari u naaŋ. ");
INSERT INTO sil_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ŋii nɛ ba yirɛ baal-la nyimma ari u naaŋ a piɛsɛba, “Ma bie nɛ ŋlaa? Ma si, ma lulu duu nyulima nɛɛ? Ɛɛ nɛ u ŋaa a nina lɛɛlɛ?” ");
INSERT INTO sil_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ŋii nɛ baal-la nyimma ari u naaŋ bul, “La jima ari la bie nɛ ŋla. La jima la lulu maa duu nyulima nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama la bi jiŋ u si ŋaa ŋii u siaa suri, la bira bi jiŋ nii-la ma si ŋaa u siaa suri. Má piɛsu, u waa nɛ. U titia jaŋ wuo bula pima.” ");
INSERT INTO sil_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baal-la nyimma ari u naaŋ faa fá Ju̱u timma-la nɛ. Ŋii nɛ tii ba bul ŋii. Ju̱u timma-la fa si di nii-la kala si bula ari Yesu nɛ ŋaa Kirisito, nii-la Wia si liisa, ba jaŋ kiru ba Wii-chuɔlɛ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","U naaŋ ari u nyimma jiŋ ŋii nɛ a bul duu waa nɛ, di ba piɛsu. ");
INSERT INTO sil_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ŋii nɛ Farisii timma-la bira yirɛ baal-la ba si lulu duu nyulima a bul, “La jima ari baala deeŋ ŋaa haachɛ tiina nɛ. Wia sipaaŋ bul wutitii pila.” ");
INSERT INTO sil_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Baal-la si, “Mi-na bi jiŋ di baal-la ŋaa haachɛ tiina koo u bi haachɛ tiina ŋaa. Ama wii-la mi-na si jima nɛ ŋla: Mi fa nyulima nɛ, ama lɛɛlɛ mi siaa suro nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ŋii nɛ ba piɛsu a bul, “Ɛɛ nɛ u ŋaa a suri ŋ siaa?” ");
INSERT INTO sil_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ŋii nɛ baal-la bula piba a bul, “Mi laa sipaaŋ bula pima nɛ, ka ma bi jegile. Bɛɛ nɛ tii ma bira chichɛ di ma nii? Ma ma saa chɛ di ma mu ŋaa u haritooroo nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ŋii nɛ ba tuusu woruŋ aŋ bul, “Ŋ nɛ ŋaa u haritooro, ama la-na ŋaa Moosis haritooroo nɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","La jima ari Wia fa bul wiaa pi Moosis nɛ, ama baal-la deeŋ-na, la bi jiŋ u si lii lee-la kala.” ");
INSERT INTO sil_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋii nɛ baal-la bul, “Wu-kpuŋkpere nɛ ŋla. Ma bi jiŋ lee-la u si lia, ama u nɛ suri mi siaa. ");
INSERT INTO sil_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","La jima ari Wia bi haachɛ tiŋŋaa wu-buluŋ ka jegili. Uu jegili nialiŋ síi zilu nɛ aŋ pɛ ŋiŋaa wialiŋ u si cho. ");
INSERT INTO sil_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dunia si suomo, ma ha nia ari nuu ba si lula duu nyulima, di nuu suri u siaa? ");
INSERT INTO sil_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Di nii-la nɛ bi Wia teeŋ lia, u bi wiiŋ deeŋ wuo ŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŋii nɛ ba bula pi baal-la a bul, “Ba paala luluŋ di ŋ ŋaa haachɛ tiina nɛ, ka ŋ ma saa chɛ di ŋ dagɛla koo?” Ŋii nɛ ba kiru ta u lii Wii-chuɔlɛ dia-la lɛ. ");
INSERT INTO sil_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu si nia di ba kiri baal-la ta u lii Wii-chuɔlɛ dia-la tuɔŋ, u mu chɛu, a nau a piɛsu, “Ŋ laa Nuhuobiine Bie wiaa dii koo?” ");
INSERT INTO sil_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ŋii nɛ baal-la piɛsu, “Kubɛɛ nɛ ŋii? Dagɛmi tiina di mi laa u wiaa dii.” ");
INSERT INTO sil_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ŋii nɛ Yesu bula pu a bul, “Ŋ paala nau nɛ. U nɛ nii-la síi bul wiaa ŋ teeŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ŋii nɛ baal-la tuu kpirimi Yesu sipaaŋ a chuɔlu aŋ bul, “Mi Tiina, mi laa ŋ wiaa dii nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ŋii nɛ Yesu bul, “Mi kɔ dunia di mi ŋaa di nialiŋ si nyulima, di ba siaa suri nɛ, ka di mi ŋaa di nialiŋ si si di ba siaa suro nɛ, di ba nyulimɛ.” ");
INSERT INTO sil_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisii timma-la si chiŋ dimɛ a nii Yesu si bul ŋii, ba piɛsu a bul, “Ŋ biina la ma nyulima nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ŋii nɛ Yesu bula piba a bul, “Di ma nɛ fa nyulima a bi wutitii jiŋ, ma fa bi wii-kala cheye. Ama lɛɛlɛ ma si folo bul di maa na nɛ a jiŋ wutitii ŋla, ŋii-na ma cheeriŋ ha hɛma lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ŋii nɛ Yesu magɛ namaga a bul, “Wutitii nɛ mi bulaa pima, nii-la kala si bi boiŋniiŋ to juu pie-dia, aŋ wule to kɛrɛ juu, u tiina ŋaa gaaru nɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ama nii-la si to pie-dia boiŋniiŋ juu, u nɛ ŋaa piese-la pie-daara. ");
INSERT INTO sil_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pie-dia bibenne yie suri pie-dia boiŋniiŋ nɛ a pu. Piese-la ma jiŋ u yiikoro. U yie yiyirɛba kubala kubala, a laa ba sipaaŋ a kɛŋba lii. ");
INSERT INTO sil_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Di u nɛ kɛŋ u kiaa kala lii, u yie laa ba sipaaŋ nɛ, ka piesee tuto u hariŋ, bɛɛ wiaa ba jiŋ u yiikoro nɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ba bi nuhuɔru hariŋ ka to, ba jaŋ miira fá u hariŋ, bɛɛ wiaa ba bi nuhuɔru-la yiikoro jiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu magɛ namaga deeŋ piba, ka ba bi wii-la u si bula piba bubuɔŋ jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ŋii nɛ Yesu bira bula piba a bul, “Wutitii nɛ mi bulaa pima, mi nɛ ŋaa pie-dia-la boiŋniiŋ. ");
INSERT INTO sil_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nialiŋ kala si laa sipaaŋ kɔ mi lɛ a nyia wiaa bul di Wia nɛ tiŋba, ba kala ŋaa gaaraa nɛ, piese-la ma bi ba yiikoro lɛ ka to. ");
INSERT INTO sil_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi nɛ ŋaa boi-la, nii-la kala si tomi lɛ juu, mi jaŋ laau ta. Nialiŋ kala si jua, mi jaŋ beŋba ari niaa síi beŋ piesee ŋii, a leŋ ba lii didii yaŋ aŋ miira kuu juu. ");
INSERT INTO sil_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gaara-na yie kɔ duu gaa a kpu nɛ koo duu chei kiaa, ama mi-na kɔ di niaa wuo kɛŋ miisiŋ, di ba tuɔŋ tutɔrɛ woruŋ bua-na kala lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yesu bira bula, “Mi nɛ ŋaa pie-daari-zɔmuŋ. Pie-daari-zɔmuŋ yie joŋ u miisiŋ yɔɔ suuŋ nɛ u piesee wiaa. ");
INSERT INTO sil_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ama nii-la si bi piesee tii aŋ didaa, ka ba titi̱mu, u nɛ yie na guŋguro duu kɔ, u leŋ piese-la aŋ fá. Guŋguro-la ku kɛsɛ ba dɔŋsuŋ aŋ ŋaa dɔŋsuŋ pisɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","U yie fá, bɛɛ wiaa u daa piese-la, ka ba titi̱mu nɛ. U sipaa kala tuo piese-la lɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mi nɛ ŋaa pie-daari-zɔmuŋ. Mi jiŋ mi piesee, mi piesee ma jiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ŋii titia nɛ mi Nyimma jiŋmi, mi ma jimu. Mi joŋ mi miisiŋ yɔɔ suuŋ, mi piesee wiaa. ");
INSERT INTO sil_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi kɛŋ piesee dɔŋsuŋ maa, aŋ ka ba tuo piesee deeŋba tuɔŋ. Mi jaŋ kɛŋba kaa kɔ. Ba ma jaŋ jiŋ mi yiikoro a kala ŋaa ni-bala piesee, ba pie-daara ma ŋaa kubala. ");
INSERT INTO sil_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mi joŋ mi miisiŋ nɛ yɔɔ suuŋ mi piesee wiaa, ka di mi bira laa. Ŋii nɛ tii mi Nyimma cho mi wiaa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nuu-kala dee bi jaŋ wuo leŋ mi joŋ mi miisiŋ yɔɔ suuŋ, mi titia tuɔtɔruŋ lɛ nɛ. Mi kɛŋ doluŋ di mi joŋ mi miisiŋ a yɔɔ suuŋ, a bira kɛŋ doluŋ di mi laa mi miisiŋ maa. Mi Nyimma nɛ pimi doluŋ deeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu si bul wiaa deeŋba, Ju̱u timma-la bira kɛŋ wiaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba jesiŋ si di bɛɛ nɛ tii ba jijegili u wiaa, di jiŋsiŋ nɛ kɛnu u nyinyaasɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba dɔŋsuŋ ma bul di nii-la jisiŋ si kɛnɛ bi wiaa deeŋba wuo bul. U bira bi nyulimaa ma siaa wuo suri. ");
INSERT INTO sil_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ŋii nɛ Ju̱u tiŋŋaa gbiele kubala yi di ba gbieli Jerusalɛm lɛ. Bua deeŋ lɛ nɛ ba liliisi ba si saa ba Wia dia dɛrɛ a joŋo pi Wia. ");
INSERT INTO sil_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","U fa ŋaa waariŋ chɛnɛ tuɔŋ nɛ. Bua deeŋ lɛ nɛ Yesu vivɛŋ zawura-la tuɔŋ ba síi yirɛ Solomɔŋ zawura a hɛ Wia dia-la lɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ŋii nɛ Ju̱u tiŋŋaa gbaaru a piɛsu a bul, “Ɛɛ nɛ ŋ jaŋ kɛŋla dieni magɛ ŋla aŋ-na bula pila nii-la ŋ si ŋaa? Di ŋ nɛ ŋaa Kirisito, nii-la Wia si liisa, chaasa bula pila.” ");
INSERT INTO sil_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ŋii nɛ Yesu bula piba a bul, “Mi laa sipaaŋ bula pima nɛ, ka ma bi laa dii. Tiŋtimii-la mi síi tiŋ mi Nyimma doluŋ lɛ dagɛ nii-la mi si ŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama ma bi mi piesee ŋaa, ŋii nɛ tii ma bi mi wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mi piesee jiŋ mi yiikoro nɛ, mi ma jiŋba, ba tuto mi hariŋ. ");
INSERT INTO sil_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ŋii nɛ mi piba miisi-la si bi dɛrɛ, ba bi jaŋ kɔ di ba suba. Nuu ma saa bi jaŋ wuo kɛŋba kaa laa mi nisiŋ lɛ da. ");
INSERT INTO sil_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mi Nyimma-la si joŋba pimi, u nɛ kii kuŋ-kala. Nuu ma kala saa bi jaŋ wuo kɛŋba kaa laa u nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","La di mi Nyimma kala ŋaa kubala nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesu si bul ŋii, Ju̱u timma-la bira paa tabiaa di ba yagu. ");
INSERT INTO sil_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ŋii nɛ Yesu bula piba a bul, “Mi ŋaa wu-zɔŋŋɔɔ yugɛ nɛ ma sipaaŋ di ma na. Mi Nyimma nɛ pimi doluŋ mii ŋaa. Ba kubɛɛ wiaa nɛ tii maa chɛ di ma yagɛmi?” ");
INSERT INTO sil_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ju̱u timma-la ma miira bul, “La bi chɛ di la yagiŋ a tiŋ ŋ si ŋaa wu-zɔmɔ-la wiaa, ama ŋ ŋaa nuhuobiiŋ nɛ aŋ kɛŋ ŋ titia a kaa birimɛ Wia, a tutuusɛ Wia joŋŋoo. Ŋii nɛ tii.” ");
INSERT INTO sil_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ŋii nɛ Yesu bula piba a bul, “Wia teniŋ tuɔŋ sɛmɛ dɔŋɔ ba ŋmuŋsa a bul di la nagɛ Wia nɛ. Wia bul wiiŋ deeŋ pi nialiŋ ba si ŋmuŋsɛ Wia teniŋ pa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","U ŋaa wutitii nɛ, la bi jaŋ wuo via Wia teniŋ.” ");
INSERT INTO sil_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ŋii nɛ Yesu bul, “Wia si liisɛmi, a tiŋmi mi ku tuu dunia, ɛɛ nɛ saa ma jaŋ bul di mii tuusɛ Wia joŋŋoo nɛ di mi nɛ bula bul di mi ŋaa Wia Bii nɛ? ");
INSERT INTO sil_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Di mi nɛ bi mi Nyimma tiŋtiŋŋaa ka tiŋ, ma sí mi wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama di mi níi tiŋ mi Nyimma tiŋtiŋŋaa, má laa mi wiaa dii a tiŋ tiŋtimii-la mi síi tiŋ wiaa, ari ma sí bi wialiŋ mi si bula pima laa dii kala. Ŋii lɛ nɛ ma jaŋ wuo to jiŋ a laa dii ari mi Nyimma hɛmi lɛ nɛ. Mi ma hɛu lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","U si bul ŋii, ba bira chichɛ di ba kɛnu, u fori ba nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ŋii nɛ Yesu bira miira mu kieli Jɔɔdaŋ fuoŋ, a mu lee-la Jɔɔŋ fa síi fo niaa Wii-chuɔlɛ liiŋ a hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Niaa yuga a kɔ u teeŋ. Ba si di Jɔɔŋ fa bi wu-magil kala ŋaa, ama wialiŋ kala u fa si bula a tigɛ baala deeŋ lɛ ŋaa wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Niaa fa yuga a laa u wiaa dii lee-la. ");
INSERT INTO sil_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Baal kubala nɛ fa hɛ taŋ kubala lɛ, taŋ-la yiriŋ nɛ Bɛtani. Baal-la yiriŋ nɛ fa Lazɔrɔs. U dihaalaa Mɛɛri ari Maata ma fa hɛ lee-la nɛ. Mɛɛri deeŋ nɛ bua kubala lɛ joŋ tulaali a bisa hɛ la Tiina Yesu naasiŋ lɛ, aŋ kɛŋ u nyu-punaa a tiikɛ. Ŋii nɛ Lazɔrɔs fa wiwiilɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","U dihaalaa tiŋ ba mu bula pi Yesu a bul, “La Tiina, nii-la ŋ si cho ka wiilu nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu si nii wiiŋ deeŋ, u si, “Nyanyaliŋ deeŋ dee bi maga di Lazɔrɔs wiila suu, ama di Wia yiriŋ to ŋii lɛ nɛ a yirɛ, di mi ma Wia Bie yiriŋ to dimɛ yirɛ.” ");
INSERT INTO sil_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu fa cho Maata ari u ŋaana ari Lazɔrɔs nɛ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","U si nia di Lazɔrɔs ka wiilu lee-la u fa si hɛ, ŋii nɛ u bira chua dimɛ tapulaa balia. ");
INSERT INTO sil_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ŋii hariŋ nɛ u bula pi u haritooroo a bul, “Má leŋ di la miira mu Judiya tiŋteeŋ.” Bɛtani fa hɛ Judiya tiŋteeŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ŋii nɛ Yesu haritooroo bula pu a bul, “La kuhiaŋ, Ju̱u tiŋŋaa faa chɛ di ba paa tabiaa yagiŋ lee-la nɛ, u bi diene, aŋ ka ŋ biraa chɛ di ŋ mu dimɛ ŋii?” ");
INSERT INTO sil_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ŋii nɛ Yesu magɛ namaga a dagɛ ari u suuŋ bua ha bi yie. U si, “Tapuluŋ kɛŋ hawaba fii ari balia nɛ. Ŋii wiaa, di nuu níi vɛŋ wiihɛyɛ, u bi jaŋ gigɛrɛ kiaa, bɛɛ wiaa leriŋ pulla nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama di ŋ níi vɛŋ titaŋiŋ, ŋ yie gigɛrɛ kiaa nɛ, bɛɛ wiaa pulumuŋ tuo.” ");
INSERT INTO sil_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ŋii nɛ Yesu bira bula pi u haritooroo a bul, “La naŋdɔŋɔ Lazɔrɔs piŋ doŋ nɛ, ama mi saa jaŋ mu chisu doŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ŋii nɛ u haritooroo bula pu, “Di u nɛ piŋ doŋ, ŋii-na u jaŋ duori.” ");
INSERT INTO sil_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu si bul ŋii, u si ari Lazɔrɔs suba nɛ, aŋ ka u haritooroo biinɛ ari doŋ titia nɛ u sɛnɛ piŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ŋii nɛ Yesu chaasa bula piba ari Lazɔrɔs suba nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ŋii nɛ Yesu bul, “A tiŋ ma wiaa mi tuɔŋ tɔrɔ ari bua-la lɛ Lazɔrɔs si suba mi tuo lee-la. Ŋii lɛ nɛ ma jaŋ to a wuo laa mi wiaa dii. Má leŋ di la mu u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesu haritooroo tuɔŋ dɔŋɔ yiriŋ nɛ fa Tɔmas. Ba kɛnu yiyirɛ daaliɛriŋ ma nɛ, bɛɛ wiaa ba fa ŋaa daaliɛriŋ nɛ. Ŋii nɛ u bula pi u dɔŋsuŋ tiŋŋaa a bul, “Má leŋ di la kala to Yesu hariŋ, duu nɛ ŋaa suu maa, di la kala suu.” ");
INSERT INTO sil_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ŋii nɛ Yesu ari u haritooroo mu Bɛtani. Ba si mu yi lee-la, niaa bula pu ari ba si hugi Lazɔrɔs, u tapulaa banɛsɛ nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani ari Jerusalɛm fa ŋaa ari meel-daasiŋ balia nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ju̱u tiŋŋaa fa yuga a lii Jerusalɛm kɔ Bɛtani di ba lɔllɛ Maata ari Mɛɛri a tiŋ ba dibaala si suba wiaa. ");
INSERT INTO sil_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata si nia ari Yesu faa kɔ nɛ, u sii lii duu chemu wɛniŋ lɛ, aŋ ka Mɛɛri-na fa hɛ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ŋii nɛ Maata bula pi Yesu a bul, “Mi Tiina, di ŋ nɛ fa hɛ daha, mi dibaala fa bi jaŋ suu. ");
INSERT INTO sil_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ari ŋii ma ha, mi jima ari ŋ nɛ sul Wia chichɛ kuŋ-kala, u jaŋ piŋ.” ");
INSERT INTO sil_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ŋii nɛ Yesu bula pu ari u dibaala jaŋ bira sii a kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ŋii nɛ Maata bula pu, “Mi jima ari dunia chɛ-dɛriŋ u jaŋ sii suuŋ lɛ, bua-la lɛ nialiŋ kala si suba si jaŋ sii.” ");
INSERT INTO sil_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ŋii nɛ Yesu bula pu, “Mi nɛ ŋaa nii-la si jaŋ sii suuŋ lɛ, a chisɛ niaa suuŋ lɛ di ba kɛŋ miisiŋ. Nuu-kala si laa mi wiaa dii, di ŋ suba maa, ŋ jaŋ sii a kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nii-la ma kala si weye aŋ laa mi wiaa dii, u bi jaŋ kɔ duu suba. Ŋ laa wiiŋ deeŋ dii koo?” ");
INSERT INTO sil_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ŋii nɛ Maata bul, “Oo, mi Tiina. Mi laa dii ari ŋ nɛ ŋaa Kirisito, nii-la Wia si liisa, a ŋaa Wia Bie maa, nii-la si maga duu kɔ dunia deeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata si bul wiaa deeŋba dɛrɛ, u miira juu dia a luɔra yirɛ u ŋaana Mɛɛri, a muŋso a bula pu a bul, “Mɛɛri, la kuhiaŋ kɔ nɛ aa yiriŋ.” ");
INSERT INTO sil_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛɛri si nii ŋii, u sii lima a lii duu chemu. ");
INSERT INTO sil_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bua-la lɛ di Yesu ha bi taŋ-la tuɔŋ jua, u ha hɛ lee-la Maata si chemu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ju̱u timma-la ari Mɛɛri fa si hɛ dia lɛ baa nyagu, ba na Mɛɛri duu sii lima. Ba si na ŋii, ba sii to u hariŋ, bɛɛ wiaa ba fa biina duu chɛ duu mu yel nɛ lee-la ba fa si hugi u dibaala. ");
INSERT INTO sil_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛri si yi lee-la Yesu fa si hɛ a nau, u tuu tel u naasiŋ lɛ aŋ bul, “Mi Tiina, di ŋ nɛ fa hɛ daha, mi dibaala fa bi jaŋ suu.” ");
INSERT INTO sil_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu si na Mɛɛri ari Ju̱u timma-la síi to u hariŋ kɔ di baa yel, u tuɔŋ faasa chei. U yaraa ma faasa vɛŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ŋii nɛ u piɛsɛba a bul, “Nii lɛ nɛ ma hugu?” Ba bula pu, “La Tiina, ku na lee-la.” ");
INSERT INTO sil_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ba si bul ŋii, Yesu yel. ");
INSERT INTO sil_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ŋii nɛ Ju̱u timma-la bul, “Má bee na u si chou ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dɔŋsuŋ ma piɛsɛ a bul, “Ka u nɛ suri nyulimaa siaa ŋii, u saa fa bi jaŋ wuo ŋaa di Lazɔrɔs sí suu?” ");
INSERT INTO sil_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ba si bul ŋii, Yesu yaraa bira vɛŋ. Ŋii nɛ ba mu yi bua-la leriŋ. Bua-la fa hɛ buŋ lɛ nɛ. Ba joŋ tabiiŋ tɔ niiŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ŋii nɛ Yesu bul di ba suri tabii-la bua-la niiŋ. Ŋii nɛ Maata, baal-la si suba dihaala dɔŋɔ, bula pu, “Mi Tiina, u si suba, u tapulaa banɛsɛ nɛ jiniŋ. Ŋla uu suɔru.” ");
INSERT INTO sil_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ŋii nɛ Yesu bula pu a bul, “Mi bi bula piŋ ari ŋ nɛ laa mi wiaa dii, ŋ jaŋ na ŋii Wia si kɛŋ doluŋ?” ");
INSERT INTO sil_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ŋii nɛ ba kɛŋ tabii-la suri. Yesu wula beŋ wia nyuŋ aŋ bul, “Mi Nyimma, mii lɔlluŋ ari ŋ si jegile nii mi teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi jima ari ŋŋ jegili mi teeŋ nɛ bua-na kala lɛ. Ama mi bul wiiŋ deeŋ a tiŋ nialiŋ si hɛ daha wiaa nɛ, di ba wuo laa dii ari ŋ nɛ tiŋmi.” ");
INSERT INTO sil_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu si bul ŋii dɛrɛ, ŋii nɛ u faasa bul, “Lazɔrɔs, ku lii!” ");
INSERT INTO sil_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","U si bul ŋii, baal-la si suba sii ku lii. U si ku lii, gɛri-kɔsumɔɔ nɛ fa vɔɔ u naasiŋ ari u nisaa kala. Gɛriŋ dɔŋɔ ma tɔ u siaa. Ŋii nɛ Yesu bula pi nialiŋ a bul, “Má kɛnu puro ta duu viiri.” Ba kɛnu puri. ");
INSERT INTO sil_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ju̱u timma-la fa si kɔ di ba chuɔlɛ Mɛɛri, a to u hariŋ mu a na wii-la Yesu si ŋaa, ba tuɔŋ niaa yuga a laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka dɔŋsuŋ ma miira mu bula pi Farisii tiŋŋaa wii-la Yesu si ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ŋii nɛ Farisii timma-la ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari niaa dɔŋsuŋ hilimi a hɔnɔ vuurɛ a bul, “Bɛɛ nɛ la jaŋ ŋaa? Má na wu-magila-la kala baala deeŋ síi ŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Di la nɛ leŋe duu ŋiŋaa wiaa deeŋba, nuu-kala jaŋ laa u wiaa dii. Ŋii hariŋ Rom tiŋteeŋ niaa jaŋ kɔ a kɛŋ la Wia-dia ari la tiŋteeŋ kala kaa laa.” ");
INSERT INTO sil_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ju̱u nihiasi-la tuɔŋ dɔŋɔ nɛ ba faa yirɛ Kayafas. Jina-la lɛ u nɛ fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ. Ŋii nɛ u bul, “Ma bi wii jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma bi jiŋ di ni-bala nɛ laa tiŋteeŋ niaa kala nyuŋ suu, u nɛ kpia la tiŋteeŋ niaa kala si suba, koo ma bi wiiŋ deeŋ jiŋ?” ");
INSERT INTO sil_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","U si bul ŋii, u bi naga u titia doluŋ lɛ nɛ u bul ŋii, ama u si ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ jina-la, ŋii nɛ tii u wuo bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ari Yesu jaŋ laa tiŋteeŋ niaa kala nyuŋ suu, ");
INSERT INTO sil_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","tiŋteeŋ deeŋ niaa ma duŋduŋa wiaa dee, ama duu wuo pɛ kɛsɛ Wia biiri-la si pisa hɛ leree dɔŋsuŋ maa a hɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A chiŋ tapulii-la a kaa mu Ju̱u tiŋŋaa kuhiasi-la vuurɛ ŋii ba si jaŋ to kpu Yesu. ");
INSERT INTO sil_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ŋii wiaa Yesu bira bi chaasaa gɔllɛ kpilii Ju̱u tiŋŋaa tuɔŋ. U lii dimɛ a mu lee kubala baa yirɛ Ɛfirim a kpagɛ giri-bine tuɔŋ. Ba di u haritooroo hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bua-la lɛ di Ju̱u tiŋŋaa diisiŋ kieliŋ gbiele-la kpaga. Ŋii nɛ Ju̱u tiŋŋaa yuga a lii ba jasiŋ lɛ a mu Jerusalɛm, di ba piisɛ ba disinniŋ ta, aŋ ka di gbiele-la-na yi. ");
INSERT INTO sil_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ŋii nɛ ba bee chichɛ Yesu gbiele-la tuɔŋ. Ba si hɔŋ Wia-dia tuɔŋ, ŋii nɛ ba pipiɛsɛ dɔŋɔ, “Ma biina u jaŋ kɔ gbiele-la koo, u bi jaŋ kɔ?” ");
INSERT INTO sil_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bua-la lɛ, di nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Farisii tiŋŋaa pa niiŋ, di nuu-kala nɛ jiŋ Yesu si hɛ lee-la, duu dagɛ, di ba wuo kɛnu. ");
INSERT INTO sil_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Lɛɛlɛ u ka tapulaa balidu nɛ, ka di Ju̱u tiŋŋaa diisiŋ kieliŋ gbiele-la-na yi. Ŋii nɛ Yesu sii mu Bɛtani, lee-la Lazɔrɔs si hɛ, baal-la u fa si chisa suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ŋii nɛ u juu Lazɔrɔs dia. Ba ŋaa kudiilee di ba huɔru. Ŋii nɛ Lazɔrɔs ari niaa dɔŋsuŋ pɛ Yesu lɛ di ba dii kudiile-la. Maata nɛ fa kɛŋ kudiile-la gɔllɔɔ kpaa. ");
INSERT INTO sil_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ŋii nɛ Mɛɛri joŋ nuuŋ ari loŋ. U suɔra sima. U yalliŋ ma hɛyɛ. Ŋii nɛ u joŋo bisa hɛ Yesu naasiŋ lɛ, a kɛŋ u nyu-punaa kaa tiikɛ. Nuu-la suɔra su̱ dia-la kala. ");
INSERT INTO sil_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Di Yesu haritooroo dɔŋɔ baa yirɛ Judas Isikarɔt, duu fa hɛ dimɛ, nii-la fa si jaŋ joŋ Yesu yallɛ. Ŋii nɛ u bul, ");
INSERT INTO sil_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bɛɛ nɛ tii ba bi nuuŋ deeŋ joŋo yallɛ siidi bui balia, a joŋ moribie-la pi summoo?” ");
INSERT INTO sil_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","U si bul ŋii, u bi naga duu cho summo-la nɛ tii, ama u fa ŋaa gaaru nɛ. U nɛ faa kori ba moribiee a yie liliisɛ moribie-la si hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ŋii nɛ Yesu bula piba a bul, “Má leŋ haal-la. Má leŋ duu ŋaa ŋii a gbɛrɛ tapulii-la ba si jaŋ hugimi. ");
INSERT INTO sil_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma di summoo jaŋ hɛ dimɛ bua-na kala lɛ. Ama la di ma bi jaŋ hɛ dimɛ deeŋ deeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Niaa yuga Ju̱u timma-la tuɔŋ a nii di Yesu hɛ Bɛtani lɛ, a sii mu dimɛ. Yesu duŋduŋa wiaa dee ba mu dimɛ. Ba mua ka di ba pɛ na Lazɔrɔs, nii-la u fa si chisa suuŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ vuurɛ di ba kpu Lazɔrɔs maa. ");
INSERT INTO sil_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A tiŋ Yesu si chisɛ Lazɔrɔs suuŋ lɛ wiaa Ju̱u tiŋŋaa yuga a via ba nihiasiŋ niiŋ, aŋ laa Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Taŋ si pula, ni-daŋ-la si kɔ diisiŋ kieliŋ gbiele-la nii ari Yesu ka kɔ Jerusalɛm nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ŋii nɛ ba kala kaarɛ abɛɛ pipaariŋ a kaa mu di ba chemu, a faasa ŋaa goŋ a bubul, “Tabarikala. Wia jaŋ pɛ nii-la síi kɔ la Tiina Wia doluŋ lɛ. U nɛ ŋaa la Iziral tiŋŋaa kuoro.” ");
INSERT INTO sil_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ba síi ŋaa ŋii, ŋii nɛ Yesu na kaku-bie a hɔŋ u nyuŋ. Ba fa ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ a bul, ");
INSERT INTO sil_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ma nialiŋ sí hɛ Zaayɔŋ lɛ, ma sí fawulluŋ fá. Ma kuoro níi kɔ ma teeŋ a jil kaku-bie.” ");
INSERT INTO sil_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu haritooroo fa bi wii-la bubuɔŋ jiŋ, ama Yesu si suba aŋ sii suuŋ lɛ a laa yiriŋ ŋii, bua-la lɛ nɛ ba liisi ari wialiŋ ba si ŋmuŋsa a tigɛu lɛ nɛ, ba sɛnɛ ŋaau lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ni-daŋ-la fa si hɛ dimɛ a na Yesu duu yirɛ Lazɔrɔs u sii a lii suuŋ bua lɛ, ŋii nɛ baa bul wii-la. ");
INSERT INTO sil_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ni-daŋ-la si nia ari Yesu ŋaa wu-magiliŋ deeŋ, ba kala lii di ba chemu. ");
INSERT INTO sil_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ŋii nɛ Farisii timma-la bula pi dɔŋɔ a bul, “La bi wii-kala wuo ŋiŋaa. Má bee na, dunia niaa kala níi to u hariŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nialiŋ si lii Giriis tiŋteeŋ dɔŋsuŋ ma fa hɛ nialiŋ si mu Jerusalɛm di ba chuɔlɛ Wia gbiele-la lɛ tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ŋii nɛ niaa deeŋba mu Filip teeŋ. Filip fa lii Bɛtisaada nɛ, Galilii tiŋteeŋ. Ba bula pi Filip ari baa chɛ di ba na Yesu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ma mu bula pi Aŋduru. Ŋii nɛ ba balia-la mu bula pi Yesu. ");
INSERT INTO sil_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ŋii nɛ Yesu bula piba a bul, “Bua-la lɛɛlɛ kpaga nɛ di mi-na Nuhuobiine Bie laa yiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wutitii nɛ mi bulaa pima, di ŋ nɛ joŋ mii-biiŋ du̱u, u yie pua nɛ tiŋteeŋ, aŋ nyu, a hɛ mii-biee yugɛ. Di ŋ nɛ bi joŋo du̱u tiŋteeŋ duu pua, u bi jaŋ kɛŋ biee. ");
INSERT INTO sil_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","U si nagɛ ŋii mii-biiŋ ŋ si joŋo du̱u lɛ, ŋii titia nɛ u nagɛ nuhuobiine ma lɛ. Nii-la kala síi chɛ duu laa u miisiŋ, u jaŋ via u miisiŋ ta, ama nii-la kala si via u miisiŋ ta dunia deeŋ lɛ, u tiina jaŋ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nii-la kala si cho duu tima pipimi, see tiina to mi hariŋ. Lee-la kala mi si hɛ, u tiina ma jaŋ hɛ dimɛ. Di nuu-kala nɛ tima pipimi, mi Nyimma jaŋ zil u tiina. ");
INSERT INTO sil_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","28","Lɛɛlɛ mi tuɔŋ bi di-bala pina. Bɛɛ nɛ saa mi jaŋ bul? Mi saa bul di mi Nyimma sí leŋe di wialiŋ kala si jaŋ ŋaami lɛ ŋaa koo? Ai, mi bi jaŋ wuo bul ŋii. Wiaa deeŋba si jaŋ ŋaami lɛ wiaa nɛ tii mi kɔ dunia. Mi Nyimma, leŋ di niaa yirɛ ŋ yiriŋ.” Ŋii nɛ nuu yiikoro lii wia nyuŋ a bul, “Mi paala laa yiriŋ nɛ. Mi saa jaŋ bira leŋ di niaa yirɛ mi yiriŋ.” ");
INSERT INTO sil_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni-daŋ-la si chiŋ dimɛ a nii nii-la yiikoro, dɔŋsuŋ si di taŋ nɛ dɔmɔ. Dɔŋsuŋ ma si di Wia tiŋdaaru nɛ bul wiaa pu. ");
INSERT INTO sil_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ŋii nɛ Yesu bula piba, “Ma wiaa nɛ tii yiikoro deeŋ bul ŋii, mi wiaa dee. ");
INSERT INTO sil_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bua-la lɛ Wia si jaŋ dii dunia niaa sariya yie nɛ. Bua deeŋ lɛ nɛ u ma jaŋ kiri Sitaani ta, nii-la si ŋaa dunia niaa kuoro. ");
INSERT INTO sil_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama di ba nɛ kpaasɛmi daa-gɛsɛɛ nyuŋ, mi jaŋ ŋaa di niaa kala kɔ mi teeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","U si bul wiiŋ deeŋ, u bula dagɛ suu-la yiri u si jaŋ suu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ŋii nɛ nialiŋ bul, “Ba dagɛla ari ba ŋmuŋsɛ Wia teniŋ tuɔŋ a bul di Kirisito, nii-la Wia si liisa, bi jaŋ suu, duu jaŋ hɛ dimɛ deeŋ deeŋ. Ɛɛ nɛ saa ŋ bul di ba jaŋ kɛŋ Nuhuobiine Bie a kpaasɛ daa-gɛsɛɛ nyuŋ? Kubɛɛ nɛ saa Nuhuobiine Bie deeŋ wiaa ŋ síi bul?” ");
INSERT INTO sil_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ŋii nɛ Yesu bula pi nialiŋ a bul, “Puluŋ-la si hɛ ma teeŋ, u bi jaŋ dieni. Puluŋ-la ha si hɛ dimɛ ŋii, má vɛŋ puluŋ-la lɛ, di birimiŋ síma tɔ. Nii-la síi vɛŋ birimiŋ tuɔŋ bi jiŋ lee-la u síi mu. ");
INSERT INTO sil_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Puluŋ-la si hɛ ma teeŋ ŋii, má laa u wiaa dii. Di ma nɛ ŋaa ŋii, ma ma jaŋ kɛŋ pulumuŋ a ma chaanɛ.” Yesu si bul wiaa deeŋba dɛrɛ, u lii a kɛŋ u titia faa di ba síu na. ");
INSERT INTO sil_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","U si ŋaa wu-magila-la kala ba na, ari ŋii kala, ba ha bi u wiaa laa dii. ");
INSERT INTO sil_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ba si bi u wiaa laa dii ŋii, ŋii leŋe wialiŋ nii-la fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ baa yirɛ Azaaya si bula ŋaa wutitii nɛ. U fa bula, “Nuu-kala bi wialiŋ la si bula piba laa dii. Nuu-kala ma bi la Tiina Wia doluŋ na.” ");
INSERT INTO sil_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ba sɛnɛ bi Wia wiaa wuo laa dii. Ŋla nɛ Azaaya bira bul a tigɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","U si, “Wia tɔ ba siaa nɛ aŋ nyirɛ ba tuɔŋ, di ba siaa sí kuŋ-kala wuo na, di ba sí wiaa bubuɔsaa ma wuo jiŋ. Di ŋii dee, ba fa jaŋ kɔ Wia teeŋ duu pullɛ ba tuɔŋ, di ba birima tutou.” ");
INSERT INTO sil_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Azaaya fa na Kirisito fa si jaŋ kɛŋ doluŋ, ŋii nɛ tii u bul ŋii. ");
INSERT INTO sil_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ari ŋii ma kala Ju̱u tiŋŋaa kuhiasiŋ yuga a laa Yesu wiaa dii, ama a tiŋ Farisii tiŋŋaa wiaa fawulluŋ fa kɛŋba. Ba bi wuo chaasa bul ari ba laa u wiaa dii, di ŋii dee, ba fa jaŋ kiriba Wii-chuɔlɛ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba fa cho di niaa nɛ bibɛsɛba lɛ a kii Wia si bɛsɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ŋii nɛ Yesu faasa bul, “Nii-la kala si laa mi wiaa dii, u ma laa nii-la si tiŋmi wiaa dii nɛ. Mi duŋduŋa wiaa dee u laa dii. ");
INSERT INTO sil_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nii-la kala si nami, u ma na nii-la si tiŋmi nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi ku tuu dunia di mi ŋaa dunia pulumuŋ nɛ a chaanɛ. Nii-la kala si laa mi wiaa dii bira bi jaŋ hɛ birimiŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nii-la kala si nii mi wu-bulaa aŋ bi baa to, mi bi u tiina sariya ka dii, bɛɛ wiaa mi bi kɔ di mi dii dunia niaa sariya. Mi kɔ di mi laa dunia niaa ta nɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wialiŋ mi si bula pima nɛ jaŋ dii tiina si bi mi wiaa laa dii sariya chɛɛ-la dunia si jaŋ dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wialiŋ mi si bula, mi titia doluŋ lɛ dee mi bul. Mi Nyimma-la si tiŋmi, u titia nɛ dagɛmi wialiŋ mi síi bul. ");
INSERT INTO sil_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mi jima ari wialiŋ u síi dagu jaŋ pi nialiŋ síi toba miisi-la si bi dɛrɛ. Ŋii wiaa, wialiŋ kala mi síi bul ŋaa mi Nyimma nɛ dagɛmi.” ");
INSERT INTO sil_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lɛɛlɛ u ka tapulii kubala nɛ, ka di Ju̱u tiŋŋaa diisiŋ kieliŋ gbiele-la yi. Bua deeŋ lɛ Yesu jiŋ ari u jaŋ leŋ dunia deeŋ aŋ mu u Nyimma teeŋ. U cho nialiŋ síi to u hariŋ nɛ dunia deeŋ lɛ. Bua deeŋ lɛ saa dagɛ ari u cho u haritooroo nɛ a mu kieli. ");
INSERT INTO sil_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tapulii-la didaaniŋ Yesu ari u haritooroo hɔŋ di ba dii kudiilee. Bua deeŋ lɛ di Sitaani ku juu Saamɔŋ bie Judas Isikarɔt duu joŋ Yesu yallɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu fa jima ari u nɛ lii Wia teeŋ nɛ. U si lii Wia teeŋ ŋii, u jaŋ bira miira mu u teeŋ. U bira jima ari u Nyimma fa joŋ kuŋ-kala doluŋ nɛ a hɛ u nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ŋii nɛ Yesu sii kudiile-la nyuŋ, a wuri u gɛri-baliŋ bil, aŋ joŋ pɔpɔ vɔɔ u tiŋa, ");
INSERT INTO sil_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","a ŋaa liiŋ hɛ taasi-gbaŋa lɛ, a suomo susɔŋ u haritooro-la naasiŋ a kɛŋ pɔpɔ-la titiikɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","U si ku yi Saamɔŋ Piita lɛ, ŋii nɛ Piita piɛsu a bul, “Mi Tiina, ŋŋ chɛ di ŋ nɛ sɔŋ mi naasiŋ?” ");
INSERT INTO sil_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ŋii nɛ Yesu bula pu, “Bua deeŋ lɛ ŋ bi jiŋ wii-la mi síi ŋaa, ama u hariŋ lɛ ŋ jaŋ jiŋ u bubuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ŋii nɛ Piita bira bula pu a bul, “Ŋ bi jaŋ sɔŋ mi-na naasiŋ da.” Ŋii nɛ Yesu ma bul, “Di mi nɛ bi ŋ naasiŋ sɔmɔ, ŋ bira bi mi haritooru ŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ŋii nɛ Piita bira bul, “Mi Tiina, di ŋii-na nɛ, sí mi naasiŋ duŋduŋa sɔŋ, sɔŋ mi nyuŋ ari mi nisaa maa.” ");
INSERT INTO sil_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ŋii nɛ Yesu bul, “Nii-la kala si fo liiŋ, u yaraa kala zɔmɔ nɛ, u saa bira bi maga duu fo liiŋ, see duu sɔŋ u naasiŋ duŋduŋa. Ma kala saa bi disinniŋ kɛnɛ, ama ni-bala duŋduŋa nɛ kɛŋ disinniŋ ma tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu paala jiŋ nii-la síi chɛ duu joŋu yallɛ nɛ. Ŋii nɛ tii u bul di ba kala tuɔŋ dee bi pulla ŋii. ");
INSERT INTO sil_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu si sɔŋ u haritooro-la naasiŋ dɛrɛ, u bira joŋ u gɛriŋ laalɛ a bira mu hɔŋ u di-hɔnuŋ, ŋii nɛ aŋ piɛsɛba a bul, “Ma jiŋ wii-la mi si ŋaama lɛ bubuɔŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ma kɛŋmi kaa yirɛ ma kuhiaŋ ari ma Tiina. U saa kɛŋ woŋbiiŋ nɛ di ma yirɛmi ŋii, bɛɛ wiaa mi nɛ sɛnɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi si ŋaa ma Tiina ari ma kuhiaŋ aŋ sɔŋ ma naasiŋ, u maga di ma saa sɔŋ ma dɔŋsuŋ tiŋŋaa naasiŋ. ");
INSERT INTO sil_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mi laa sipaaŋ ŋaama-na nɛ, di ma saa wuo ŋiŋaa ŋii dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wutitii nɛ mi bulaa pima, tiŋtinnu kala bi u kuhiaŋ kii, nii-la ma ba si tima, u ma bi nii-la si timu kii. ");
INSERT INTO sil_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ma lɛɛlɛ si jiŋ wiaa deeŋba ŋii, di ma níi ŋaaba, ma tuɔŋ jaŋ tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma kala dee mi bul ari ma tuɔŋ jaŋ tɔrɛ. Mi jiŋ nialiŋ mi si liisa nɛ. Wii-la ba si ŋmuŋsa Wia teniŋ tuɔŋ sɛnɛ jaŋ ŋaa wutitii. Ba bula ari la di nii-la kala si pɛ dɔŋɔ lɛ dii kudiilee nɛ jaŋ miira gollimi lɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi bul wiiŋ deeŋ pipima nɛ, ka duu-na ŋaa, di ŋii nɛ sɛnɛ kɔ duu ŋaa, ma jaŋ laa mi wiaa dii ari mi nɛ ŋaa Kirisito, nii-la wiaa ba si ŋmuŋsa. ");
INSERT INTO sil_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wutitii nɛ mi bulaa pima, nii-la kala si kɛŋ nii-la mi si tima woruŋ, u tiina kɛŋ mi ma woruŋ nɛ. Nii-la ma kala si kɛŋmi woruŋ, u tiina ma kɛŋ nii-la si tiŋmi woruŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu si bul wiaa deeŋba dɛrɛ, u tuɔŋ bi di-bala pina. Ŋii nɛ u chaasa bul, “Wutitii nɛ mi bulaa pima, ma dɔŋɔ nɛ jaŋ joŋmi yallɛ.” ");
INSERT INTO sil_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ŋii nɛ u haritooro-la miira didaasɛ dɔŋɔ. Ba bi jiŋ tiina u síi dagu. ");
INSERT INTO sil_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu haritooro-la tuɔŋ nii-la u fa si cho nɛ fa hɔnɔ kpagu. ");
INSERT INTO sil_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ŋii nɛ Saamɔŋ Piita lɔgɛ u haritooro-la dɔŋɔ duu piɛsɛ Yesu-na di kubɛɛ nɛ u didagɛ? ");
INSERT INTO sil_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ŋii nɛ haritooro-la fa si kpagɛ Yesu wasa suusa mu yi Yesu a piɛsu a bul, “Mi Tiina, kubɛɛ nɛ?” ");
INSERT INTO sil_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ŋii nɛ Yesu bul, “Mi si jaŋ joŋ boroboro yuu disiŋ a pi nii-la, u nɛ ŋii.” Ŋii nɛ u joŋ boroboro-la a yuu disiŋ a joŋo pi Judas, nii-la si ŋaa Saamɔŋ Isikarɔt bie. ");
INSERT INTO sil_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas si yia laa boroboro-la dɛrɛ, Sitaani ku juu-u. Ŋii nɛ Yesu bula pu, “Wii-la ŋ síi chɛ di ŋ ŋaa, ŋaau lima lima.” ");
INSERT INTO sil_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nialiŋ dɔŋsuŋ kala fa síi dii kudiile-la, ba bi jiŋ wii-la kala u fa si bula bubuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas fa síi kori ba moribiee ŋii, Yesu haritooro-la dɔŋsuŋ fa biina ari Yesu faa chɛ duu mu yɔɔ kialiŋ ba síi chɛ di ba dii nɛ gbiele-la lɛ, koo duu joŋ kuŋ nɛ a pi summoo. ");
INSERT INTO sil_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas si laa boroboro-la dɛrɛ, u guu sii a lii lima lima. Bua-la lɛ titaŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas si lia, ŋii nɛ Yesu bul di niaa jaŋ na u-na Nuhuobiine Bie doluŋ si magɛ ŋii. Niaa ma jaŋ tou lɛ nɛ a na ŋii Wia si kɛŋ doluŋ. ");
INSERT INTO sil_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ŋii nɛ Yesu bira bul, “Mi si jaŋ dagɛ Wia doluŋ si magɛ ŋii, ŋii nɛ Wia ma jaŋ dagɛ mi-na Nuhuobiine Bie doluŋ si magɛ ŋii. U jaŋ ŋaa ŋii lima. ");
INSERT INTO sil_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mi biiriŋ, mi bira bi jaŋ hɛ ma teeŋ dieni. Ma jaŋ bee chɛmi. Ama mi si bul ŋii a pi Ju̱u tiŋŋaa, mi jaŋ bul ŋii a pima maa. Lee-la mi si jaŋ mu, ma bi jaŋ wuo mu dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ni̱i-falii nɛ mi bilee pima. U nɛ ŋla: Ma jima ari mi choma nɛ woruŋ. Má cho dɔŋɔ ari mi si choma ŋii. ");
INSERT INTO sil_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Di ma nɛ cho dɔŋɔ, ŋii lɛ nɛ niaa kala jaŋ to jiŋ ari ma sɛnɛ ŋaa mi haritooroo nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ŋii nɛ Saamɔŋ Piita piɛsɛ Yesu a bul, “Mi Tiina, nii nɛ ŋ mumu?” Ŋii nɛ Yesu ma bula pu a bul, “Lee-la mi si jaŋ mu, ŋ bi jaŋ wuo to mu, ama u hariŋ nɛ ŋ jaŋ wuo to.” ");
INSERT INTO sil_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ŋii nɛ Piita bira piɛsu a bul, “Mi Tiina, bɛɛ nɛ tii mi bi jaŋ wuo to ŋ hariŋ lɛɛlɛ? Mi paala ŋaa siri di mi joŋ mi miisiŋ yɔɔ suuŋ nɛ ŋ wiaa.” ");
INSERT INTO sil_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ŋii nɛ Yesu piɛsu a bul, “Ŋ sɛnɛ ŋaa siri di ŋ joŋ ŋ miisiŋ yɔɔ suuŋ nɛ mi wiaa? Wutitii nɛ mi bulaa piŋ, ka di ji-bele-na yel, ŋ jaŋ bul naaŋsiiŋ butori ari ŋ bimi jiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ŋii nɛ Yesu si, “Ma sí leŋe di ma tuɔŋ vugimɛ. Má laa Wia wiaa dii a laa mi ma wiaa dii. ");
INSERT INTO sil_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mi Nyimma jaŋ lɛ diisiŋ yuga hɛ dimɛ. Di ŋii fa dee, mi bi jaŋ bula pima ari mi jaŋ mu wasɛ leriŋ a bilma lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Di mi nɛ mua a wasɛ lee-la bilma lɛ dɛrɛ, mi jaŋ bira kɔ a kɛŋma kaa mu mi teeŋ Wia-jaŋ lɛ, di la kala hɛ di-bala. ");
INSERT INTO sil_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lee-la ma mi si jaŋ mu, ma jiŋ woŋbiiŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ŋii nɛ Tɔmas bula pu a bul, “La Tiina, la bi jiŋ lee-la ŋ síi mu, ɛɛ nɛ la jaŋ wuo ŋaa jiŋ u woŋbiiŋ?” ");
INSERT INTO sil_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ŋii nɛ Yesu bula pu a bul, “Mi nɛ ŋaa woŋbiiŋ aa mu Wia-jaŋ. Mi nɛ bira Wutitii Tiina maa, a biraa pi niaa ma miisiŋ. Nuu-kala bi mi Nyimma teeŋ wuo mu, see duu tomi lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Di ma nɛ jiŋmi, ma jiŋ mi Nyimma ma nɛ. A lii jiniŋ saa ma paala jimu nɛ a nau maa.” ");
INSERT INTO sil_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ŋii nɛ Filip bula pu a bul, “Mi Tiina, dagɛla la Nyimma, wii-la kala la síi chɛ nɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ŋii nɛ Yesu piɛsu a bul, “Filip, la di ŋ hɛ dimɛ a dieni ŋii, ka ŋ ha bimi jiŋŋ? Nii-la kala si nami, u na mi Nyimma ma nɛ. Bɛɛ nɛ saa tii ŋ bul di mi dagɛma mi Nyimma? ");
INSERT INTO sil_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ŋ bi laa dii ari mi hɛ mi Nyimma lɛ nɛ, mi Nyimma ma hɛmi lɛɛ? Wialiŋ kala mi si yie bulaa pima, mi titia doluŋ lɛ dee mii bul. Wialiŋ ma mi síi ŋaa, mi Nyimma hɛmi lɛ níi ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Má laa dii ari mi hɛ mi Nyimma lɛ nɛ, mi Nyimma ma hɛmi lɛ. Di ma nɛ bi ŋii wuo laa dii, má laa dii a tiŋ wialiŋ mi síi ŋaa wiaa. ");
INSERT INTO sil_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wutitii nɛ mi bulaa pima, nii-la kala si laa mi wiaa dii, u jaŋ wuo ŋiŋaa wialiŋ mi síi ŋaa. U jaŋ paala wuo ŋaa kii wialiŋ mi síi ŋaa, bɛɛ wiaa mi jaŋ miira mu mi Nyimma teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kuŋ-na kala ma si piɛsɛ chichɛ mi doluŋ lɛ, mi jaŋ joŋo pima. Mi jaŋ ŋaa ŋii di niaa wuo tomi lɛ a na mi Nyimma si kɛŋ doluŋ ŋii, a yirɛ u yiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Di ma níi chɛ kuŋ-kala mi doluŋ lɛ, mi jaŋ ŋaa pima.” ");
INSERT INTO sil_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ŋii nɛ Yesu bira bul, “Di ma nɛ chomi, ma jaŋ tuto mi niiŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Di ma níi ŋaa ŋii, mi jaŋ sul mi Nyimma duu joŋ u Diŋ-zɔŋ-la pima, duu pipɛma lɛ. U jaŋ hɛ ma teeŋ a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","U jaŋ didagɛma wutitii. Dunia niaa buu jiŋ. Ba bi jaŋ wuo nau, ŋii nɛ tii u bi jaŋ wuo hɛba lɛ. Ama ma-na jimu nɛ. U hɛ ma teeŋ nɛ. U saa jaŋ hɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi bi jaŋ leŋ ma duŋduŋa ta, mi jaŋ miira kɔ ma teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","U ka mua dunia niaa bira bi jaŋ nami, ama ma-na jaŋ nami. Mi si jaŋ kɛŋ miisiŋ ŋii, ma ma jaŋ kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tapulii-la Wia si jaŋ joŋ u Diŋ-zɔŋ-la hɛma lɛ nɛ, ma jaŋ jiŋ ari mi hɛ mi Nyimma lɛ nɛ, ma ma hɛmi lɛ, mi ma hɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nii-la kala si nii mi niiŋ wiaa aa toba, u tiina nɛ chomi. Mi Nyimma ma saa jaŋ cho nii-la si chomi. Mi ma jaŋ cho tiina a kɛŋ mi titia kaa dagu.” ");
INSERT INTO sil_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ŋii nɛ Judas bul (nii-la ba síi yirɛ Isikarɔt dee), “Mi Tiina, ɛɛ nɛ ŋ jaŋ ŋaa a kɛŋ ŋ titia dagɛla, aŋ bi ŋ titia kaa dagɛ dunia niaa?” ");
INSERT INTO sil_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ŋii nɛ Yesu bula pu a bul, “Nii-la kala si chomi, u jaŋ tuto mi niiŋ wiaa. U si ŋaa ŋii, mi Nyimma ma jaŋ chou. La di mi Nyimma kala ma jaŋ ku hɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nii-la si bimi cho, u bi mi niiŋ wiaa ka to. Wialiŋ ma si nii saa, mi titia dee bi bul. Ama mi Nyimma-la si tiŋmi nɛ dagɛmi mii bul. ");
INSERT INTO sil_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mi ha hɛ ma teeŋ nɛ, ŋii nɛ mi bul wiaa deeŋba pipima. ");
INSERT INTO sil_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama mi Nyimma jaŋ joŋ u Diŋ-zɔŋ-la duu ku tuu a hɛma lɛ mi doluŋ lɛ. U jaŋ pɛma lɛ a wuo dagɛma wii-kala, a leŋ di ma liisi wialiŋ kala mi si bula pima. ");
INSERT INTO sil_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi síi mu ŋii, mi jaŋ leŋ di ma hɔŋ ari yarifiɛlaa di ma tuɔŋ tɔrɛ. Yarifiɛla-la mi si pima, u bi naga yarifiɛla-la dunia niaa si kɛnɛ nɛ. Ma sí leŋe di ma tuɔbiinaa vugimɛ, a bira sí leŋe di fawulluŋ ma kɛŋma. ");
INSERT INTO sil_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma nia ari mi si bula pima ari mi jaŋ miira viiri aŋ bira miira kɔ ma teeŋ. Di ma nɛ fa chomi, ma tuɔŋ fa jaŋ tɔrɛ ari mi si mu mi Nyimma teeŋ, bɛɛ wiaa u nɛ kɛŋ doluŋ a kiimi. ");
INSERT INTO sil_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi laa sipaaŋ bul wiaa deeŋba pipima nɛ, ka di ba-na ŋaa, ma jaŋ laaba dii. ");
INSERT INTO sil_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi bi jaŋ wuo bul wiaa ma teeŋ a dieni, bɛɛ wiaa dunia kuoro ka kɔ nɛ. U bi dol kala kɛnɛ mi lɛ. ");
INSERT INTO sil_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama mii chɛ di dunia niaa jiŋ ari mi cho mi Nyimma nɛ. Ŋii nɛ tii mi ŋiŋaa wialiŋ kala u si si di mi ŋaa. Má leŋ di la lii. Má sii.” ");
INSERT INTO sil_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ŋii nɛ Yesu si, “Mi nagɛ tia-la titia ba síi yirɛ vaiŋ nɛ. Ama mi nɛ tii-titii-la. Mi Nyimma ma nagɛ nii-la síi beŋ tia-la nɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naakel-la kala si mɛrɛ tia-la lɛ aŋ bi nɛŋ, u yie kere ta nɛ, naakel-la kala síi nɛŋ, u yie buoro ta nɛ, ka di u wuo faasa nɛŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma tuɔŋ paala bira bi disinniŋ kɛnɛ a tiŋ wialiŋ mi si bula pima. ");
INSERT INTO sil_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Má mɛrɛmi lɛ di mi ma mɛrɛma lɛ. Tia naakelee duŋduŋa bi jaŋ wuo nɛŋ, see di ba mɛrɛ tia geŋtine lɛ. Ma ma bi jaŋ wuo tiŋ tiŋtiŋ-zɔŋŋɔɔ, see di ma mɛrɛmi lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ŋii nɛ Yesu bira bul, “Mi nagɛ tia nɛ, ma ma nagɛ tia-la naakelee. Nii-la kala si mɛrɛmi lɛ, mi ma mɛrɛ tiina lɛ. Ŋii nɛ jaŋ wuo ŋaa duu tiŋ tiŋtiŋ-zɔŋŋɔɔ woruŋ, a tiŋ bɛɛ wiaa di ma nɛ bimi lɛ mɛrɛ, ma bi jaŋ wuo ŋaa wii-kala. ");
INSERT INTO sil_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Di nuu nɛ bimi lɛ mɛrɛ, ba jaŋ joŋ tiina yuo ta, a nagɛ ba si yie keri tia naakelee ta, ba hil. Ba paaba a yuo hɛ nyiniŋ lɛ ba dii ŋii. ");
INSERT INTO sil_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Di ma mɛrɛmi lɛ, mi niiŋ wiaa mi si bula pima jaŋ hɛ ma tuɔŋ. Di ma nɛ ŋaa ŋii, kuŋ-kala ma si piɛsɛmi chichɛ, mi jaŋ wuo ŋaa pima. ");
INSERT INTO sil_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Di ma nɛ tiŋ tiŋtiŋ-zɔŋŋɔɔ woruŋ, ŋla nɛ mi Nyimma yiriŋ jaŋ yirɛ. Ma jaŋ wuo dagɛ ŋii ari ma ŋaa mi haritooroo nɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mi choma ari mi Nyimma si chomi ŋii nɛ. Ŋii wiaa, má mɛrɛmi lɛ di mi choma a kaa mu wuu. ");
INSERT INTO sil_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Di ma níi to mi niiŋ wiaa, mi jaŋ choma a kaa mu, ari mi síi to mi Nyimma niiŋ wiaa a mɛrɛu lɛ u chomi ŋii. ");
INSERT INTO sil_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi bul wiaa deeŋba pima di ma wuo na tuɔtɔru-la mi si joŋo pima. Ŋii nɛ ma tuɔŋ jaŋ faasa tɔrɛ woruŋ a mu dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mi choma nɛ woruŋ. Wii-la mi si bula pima di maa ŋaa nɛ ŋla: Má cho dɔŋɔ ari mi si choma ŋii. ");
INSERT INTO sil_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Di nuu nɛ ŋaa siri duu joŋ u miisiŋ yɔɔ suuŋ u naŋdɔŋɔ wiaa, u chou nɛ woruŋ. Nuu-kala bi nii-la cho magɛ nia deeŋ. ");
INSERT INTO sil_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Di ma níi ŋaa wialiŋ mi síi bula pima di maa ŋaa, ma jaŋ ŋaa mi naŋdɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi bira bi jaŋ kɛŋma kaa yirɛ mi tiŋtinnaa, bɛɛ wiaa tiŋtinna bi wii-la u kuhiaŋ síi ŋaa jiŋ. Ama mi-na bul wialiŋ kala mi Nyimma si bula pimi pima nɛ. Ŋii nɛ tii mi kɛŋmaa yirɛ mi naŋdɔŋsuŋ. ");
INSERT INTO sil_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma dee bimi liisa, mi nɛ liisɛma. Mi liisɛma di ma mu faasa ŋaa wu-zɔŋŋɔɔ nɛ, wu-zɔmɔ-la si bi jaŋ lɛl. Di ma níi ŋaa ŋii, mi Nyimma jaŋ pima kuŋ-kala ma si piɛsu chichɛ mi doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wii-la mi si bula pima di maa ŋaa nɛ ŋla: Má cho dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Di dunia niaa nɛ bɛrɛma, ma jiŋ ari ba laa sipaaŋ bɛrɛmi nɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Di ma nɛ fa ŋaa dunia niaa, dunia niaa fa jaŋ choma woruŋ, ari ba si cho dɔŋɔ ŋii. Ma di dunia niaa bi kubala ŋaa. Mi liisɛma dunia niaa tuɔŋ nɛ. Ŋii nɛ tii ba bɛrɛma. ");
INSERT INTO sil_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mi laa sipaaŋ bula pima ari tiŋtinnu bi u kuhiaŋ kii. Má liisi wiiŋ deeŋ. Ba si dɔgisɛmi ŋii, ba jaŋ dɔgisɛma ma ŋii. Di ba nɛ fa sɛi mi niiŋ wiaa, ba fa jaŋ sɛi ma ma niiŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba jaŋ ŋaa wiaa deeŋba kala a tiŋ ma síi to mi hariŋ wiaa. Ba si bi nii-la si tiŋmi jiŋ nɛ tii baa ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Di mi nɛ fa bi ku bul wiaa piba, ba si ŋaa wu-bɔmɔ-la kala, mi fa bi jaŋ wuo bul di ba chei wii-kala. Ama mi si folo ku bul wiaa piba, ba bira bi jaŋ wuo bul ari ba bi wii-kala cheye. ");
INSERT INTO sil_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nii-la si bɛrɛmi, tiina bɛrɛ mi Nyimma ma nɛ. ");
INSERT INTO sil_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wialiŋ kala mi si ŋaa, nuu-kala biba ŋaa. Di mi nɛ fa biba ŋaa di ba na, ba fa bi jaŋ chei wii-kala. Ama ba naba kala nɛ aŋ ha bɛrɛ la di mi Nyimma kala. ");
INSERT INTO sil_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba si bɛrɛmi ŋii, wialiŋ kala ba si ŋmuŋsa Wia teniŋ tuɔŋ sɛnɛ ŋaa. Ŋla nɛ ba ŋmuŋsɛ, ‘Mi bi wii-kala ŋaa chei, ka ba bɛrɛmi.’ ");
INSERT INTO sil_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ama mi jaŋ leŋ di Wia Diŋ-zɔŋ-la lii mi Nyimma teeŋ a ku tuu hɛma lɛ. U jaŋ pɛma lɛ a dagɛma wutitii. U nɛ jaŋ bul mi wiaa pima. ");
INSERT INTO sil_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma ma jaŋ bul mi wiaa pi niaa, bɛɛ wiaa mi si suomo didagɛ niaa, la di ma kala níi to dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mi bul wiaa deeŋba kala pipima di ma sí hariŋ miiru nɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bua-la jaŋ yi di Ju̱u tiŋŋaa kirima ta Wii-chuɔlɛ diisiŋ lɛ. Bua ma dɔŋ jaŋ yi di niaa kpuma aŋ biinɛ di baa to Wia woŋbiiŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba jaŋ ŋaa wiaa deeŋba kala a tiŋ ba sí bi mi Nyimma jiŋ, a bimi ma jiŋ. ");
INSERT INTO sil_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi bul wiaa deeŋba kala pipima di bua-la nɛ ku yi di wiaa deeŋba ŋiŋaa, ma jaŋ liisi ari mi bula pima. La di ma kala fa síi to dɔŋɔ, ŋii nɛ tii mi bi wiaa deeŋba bula pima faafaa. ");
INSERT INTO sil_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ama lɛɛlɛ mii mu nii-la si tiŋmi nɛ, aŋ ka ma kuŋ-kala ha bi mi piɛsa a bul di nii nɛ mii mu? ");
INSERT INTO sil_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mi si bul wiaa deeŋba pima lɛɛlɛ ŋla, ma tuɔŋ cheye nɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama wutitii nɛ mi bulaa pima ŋla. Mi síi mu ŋii, u jaŋ zɔmɔ pima. Di mi nɛ bi mua, Wia Diŋ-zɔŋ-la si jaŋ kɔ a pɛma lɛ bi jaŋ kɔ. Ama di mi nɛ mua, mi jaŋ leŋ duu kɔ. ");
INSERT INTO sil_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Duu nɛ saa kɔ, u jaŋ leŋ di dunia niaa jiŋ ari ba ŋaa haachɛba nɛ. U jaŋ bira dagɛba ŋii ba si jaŋ to a kɛŋ tuɔ-pula Wia sipaaŋ, a bira dagɛba ari Wia jaŋ dii ba sariya. ");
INSERT INTO sil_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ba jaŋ jiŋ ari ba si bi mi wiaa laa dii, u ŋii ŋaa haachɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mi si miira mu mi Nyimma teeŋ ŋii, ma bira bi jaŋ nami. U ŋii ma jaŋ dagɛ ari mi kɛŋ tuɔ-pula nɛ Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wia si folo dii dunia kuoro Sitaani sariya ŋii, ba ma jaŋ jiŋ ari Wia ma jaŋ dii ba sariya. ");
INSERT INTO sil_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Wiaa yuga nɛ mi ha kɛŋ di mi bula pima, ama ma biba wuo nyalimɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama di Wia Diŋ-zɔŋ-la nɛ kɔ, u jaŋ dagɛma wutitii kala. U bi jaŋ bubul wiaa u titia doluŋ lɛ, ama wialiŋ kala u si nii mi Nyimma niiŋ lɛ nɛ u jaŋ bul. U ma jaŋ dagɛma wialiŋ kala si jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","U jaŋ leŋ di niaa yirɛ mi yiriŋ, bɛɛ wiaa wialiŋ kala mi si kɛnɛ mi bul, u jaŋ kaa ku bula pima. ");
INSERT INTO sil_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ku-la kala mi Nyimma si kɛnɛ ŋaa mi kuŋ nɛ. Ŋii nɛ tii mi bula pima ari wialiŋ kala mi si kɛnɛ mi bul, Wia Diŋ-zɔŋ-la jaŋ kaa ku bula pima.” ");
INSERT INTO sil_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ŋii nɛ Yesu bira bula piba a bul, “Ma bira bi jaŋ nami. Tapulaa baŋmɛnɛ chɛɛŋ nɛ ma jaŋ bira nami.” ");
INSERT INTO sil_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ŋii nɛ u haritooroo dɔŋsuŋ pipiɛsɛ dɔŋɔ a bul, “Wiiŋ deeŋ bubuɔŋ nɛ bɛɛ? U bula pila ari tapulaa baŋmɛnɛ la bi jaŋ nau, di tapulaa baŋmɛnɛ chɛɛŋ nɛ la bira jaŋ nau. U bira bula ari u si jaŋ mu u Nyimma teeŋ nɛ tii la bira bi jaŋ nau. ");
INSERT INTO sil_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","U si yie bul di tapulaa baŋmɛnɛ deeŋ, u bubuɔŋ nɛ bɛɛ? La bi u bubuɔŋ jiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu jima ari baa chɛ di ba piɛsu nɛ. Ŋii nɛ u bula piba, “Mi si si tapulaa baŋmɛnɛ ma bi jaŋ nami, di tapulaa ma baŋmɛnɛ chɛɛŋ ma jaŋ bira nami, ŋii wiaa nɛ ma pipiɛsɛ dɔŋɔɔ? ");
INSERT INTO sil_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wutitii nɛ mi bulaa pima, ma jaŋ ŋmuŋmoo niiŋ kala, di dunia niaa tuɔŋ tɔrɛ, ma tuɔŋ jaŋ chei, ama ma tuɔ-chei-la jaŋ miira birimɛ tuɔtɔruŋ. ");
INSERT INTO sil_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Di haala luoruŋ níi wii duu chɛ u lul, u yie tuunɛ niiŋ nɛ. U hɛɛŋ yie nɛ. Duu nɛ saa ku lul bile dɛrɛ, u yu u hɛɛ-la kala lɛ. U si lul bie nɛ tii u tuɔŋ yie tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ŋii nɛ saa u jaŋ nagɛma ma lɛ. Lɛɛlɛ ma tuunɛ niiŋ nɛ, ama mi jaŋ bira nama di ma tuɔŋ kala tɔrɛ. Bua-la lɛ nuu-kala bi jaŋ wuo ŋaa di ma tuɔŋ bira chei. ");
INSERT INTO sil_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Di tapulii-la nɛ yie, ma bi jaŋ piɛsɛmi chichɛ kuŋ-kala. Wutitii nɛ mi bulaa pima, mi Nyimma jaŋ pima kuŋ-kala ma si piɛsu chichɛ mi doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lɛɛlɛ ŋla ma ha bi kuŋ-kala piɛsu chichɛ mi doluŋ lɛ. Ŋii wiaa má saa piɛsu, u jaŋ joŋo pima, di ma tuɔŋ faasa tɔrɛ a mu dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Wiaa deeŋba kala mi síi bul, namagaba nɛ mii magɛ. Ama bua kubala jaŋ yi, mi bira bi jaŋ magɛ namagaba, mi jaŋ chaasa bul wiaa pima a mu tigɛ mi Nyimma lɛ, di ma jiŋ ba bubuɔsaa woruŋ. ");
INSERT INTO sil_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Di tapulii-la nɛ yie, ma nɛ jaŋ piɛsu chichɛ kiaa mi doluŋ lɛ. Mi bi si mi nɛ jaŋ sula pima, ");
INSERT INTO sil_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bɛɛ wiaa mi Nyimma titia ma choma nɛ. Ma chomi nɛ a laa mi wiaa dii ari mi lii u teeŋ nɛ. Ŋii nɛ tii u ma choma. ");
INSERT INTO sil_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi lii mi Nyimma teeŋ nɛ a ku tuu dunia. Lɛɛlɛ mi saa jaŋ leŋ dunia aŋ miira mu mi Nyimma teeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ŋii nɛ u haritooro-la bula pu a bul, “Lɛɛlɛ ŋ chaasaa bul wiaa nɛ. Ŋ bira bi namagaba ka magɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lɛɛlɛ la jima di ŋ jiŋ wii-wii-kala nɛ, ŋ bí chɛ di nuu-kala piɛsiŋ wii-kala. Wiiŋ deeŋ nɛ ŋaa di la jiŋ ari ŋ lii Wia teeŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ŋii nɛ Yesu piɛsɛba, “Lɛɛlɛ saa ma laa mi wiaa dii nɛɛ? ");
INSERT INTO sil_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bua-la jaŋ yi, u saa paala yi ma nɛ, ma kala jaŋ pisɛ a mu ma diisiŋ, aŋ ka mi duŋduŋa. Ama saa, mi bi jaŋ ŋaa mi duŋduŋ. Mi Nyimma hɛmi lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi bul wiaa deeŋba pima di ma wuo hɔŋ ari yarifiɛlaa nɛ. Dunia deeŋ tuɔŋ ma jaŋ na hɛɛŋ. Ama má leŋ di ma nyuŋ nyaasɛ. Mi yuo dii dunia nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu si bul wiaa deeŋba dɛrɛ, u wula beŋ wia nyuŋ aŋ bul, “Mi Nyimma, bua-la yie nɛ. Leŋ di mi-na ŋ Bie laa yiriŋ, di mi ma leŋ di ŋ yiriŋ yirɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ŋ nɛ joŋ doluŋ pimi di mi bibeŋ nuhuobiinee kala, a joŋ miisi-la si bi dɛrɛ a pi nialiŋ kala ŋ si liisa pimi. ");
INSERT INTO sil_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nialiŋ si jima ari ŋ nɛ sɛnɛ ŋaa Wia, Wia bira tuo, aŋ pɛ jiŋ mi-na Yesu Kirisito, nii-la ma ŋ si tima, ba nɛ kɛŋ miisi-la si bi dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi leŋe ŋ laa yiriŋ nɛ tiŋteeŋ deeŋ lɛ. Mi tiŋ tiŋtimii-la dɛrɛ nɛ, tiŋtimii-la ŋ si joŋo pimi di mi tiŋ. ");
INSERT INTO sil_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Oo, mi Nyimma, leŋ di mi yiriŋ yirɛ ŋ sipaaŋ lɛɛlɛ, yiri-la la di ŋ kala fa si laa, aŋ ka ŋ-na suomo ŋaa dunia. ");
INSERT INTO sil_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi leŋe nialiŋ ŋ si liisa pimi dunia niaa tuɔŋ jimiŋ nɛ. Ba fa ŋaa ŋ kiaa nɛ, ŋ nɛ liisɛba pimi. Ba nɛ sɛi ŋ niiŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lɛɛlɛ ba jima ari wii-kala mi si ŋaa, mi ŋaa ŋ doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mi bul ŋ niiŋ wialiŋ ŋ si bula pimi piba nɛ. Ba laa dii a jiŋ ari wutitii nɛ, mi sɛnɛ lii ŋ teeŋ nɛ. Ba ma laa dii ari ŋ nɛ tiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi suluŋ pipiba nɛ. Mi biŋ sula pipi dunia niaa, see nialiŋ ŋ si liisa pimi duŋduŋa. Ba nɛ ŋaa ŋ kiaa. ");
INSERT INTO sil_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nialiŋ kala mi si kɛnɛ ŋaa ŋ niaa nɛ. Nialiŋ kala ŋ ma si kɛnɛ ŋaa mi ma niaa nɛ. Ba nɛ leŋe mi laa yiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lɛɛlɛ mii kɔ ŋ teeŋ nɛ, mi bira bi jaŋ hɛ dunia lɛ, ama ba-na jaŋ hɛ dunia lɛ. Mi Nyimma, ŋ nɛ ŋaa nii-la si bi disinniŋ kɛnɛ. Beŋ nialiŋ ŋ si liisa pimi woruŋ ŋ doluŋ lɛ, a leŋ di ba ŋaa kubala, ari la di ŋ kala si ŋaa kubala ŋii. ");
INSERT INTO sil_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mi fa si hɛ ba teeŋ, mi beŋ ba nyuŋ nɛ woruŋ ŋ doluŋ lɛ, dol-la ŋ si joŋo pimi nɛ mi kaa beŋba. Mi si ŋaa ŋii, ba kubala ma bi lɛlɛ, see nii-la si maga duu lɛl, di wialiŋ ba fa si ŋmuŋsa Wia teniŋ tuɔŋ sɛnɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lɛɛlɛ saa mii kɔ ŋ teeŋ nɛ. Mi ha si hɛ dunia lɛ ŋii, ŋii nɛ mi bul wiaa deeŋba piba di ba tuɔŋ faasa tɔrɛ, ari mi tuɔŋ si tɔrɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi bul ŋ niiŋ wiaa piba nɛ. Ba di dunia niaa bi kubala ŋaa, ari la di dunia niaa si bi kubala ŋaa ŋii. Ŋii nɛ tii dunia niaa bɛrɛba. ");
INSERT INTO sil_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi bi si di ŋ liisɛba dunia lɛ, ama mi si di ŋ pɔba nɛ a liisɛba Sitaani nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba di dunia niaa bi kubala ŋaa, ari la di dunia niaa si bi kubala ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ŋ niiŋ wiaa ŋaa wutitiiba nɛ. Dagɛba, di ba bira sí disinniŋ kɛŋ. ");
INSERT INTO sil_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ŋ nɛ tiŋmi dunia niaa teeŋ. Ŋ si tiŋmi ŋii, ŋii titia nɛ mi ma tiŋba dunia niaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi joŋ mi miisiŋ nɛ a yɔɔ suuŋ ba wiaa. Mi ŋaa ŋii di ba ma ŋaa siri di ba joŋ ba miisiŋ yɔɔ suuŋ wutitii wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mi biŋ sula pipiba duŋduŋ, mi pɛ sula pi nialiŋ si laa mi wiaa dii a tiŋ ba si bul mi wiaa piba lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mii suluŋ ŋii di ba kala wuo ŋaa kubala nɛ. Ŋ hɛmi lɛ nɛ. Mi ma hɛŋ lɛ. Leŋ di ba kala ma wuo hɛla lɛ. Di ŋ nɛ ŋaa ŋii, dunia niaa jaŋ wuo laa dii ari ŋ nɛ tiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ŋ si leŋ mi laa yiriŋ ŋii, ŋii nɛ mi ma leŋ ba laa yiriŋ. Mi ŋaa ŋii di ba kala wuo ŋaa kubala nɛ, ari la di ŋ kala si ŋaa kubala ŋii. ");
INSERT INTO sil_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi hɛba lɛ nɛ, ŋ ma hɛmi lɛ. La hɛ dɔŋɔ lɛ ŋii di ba wuo ŋaa kubala nɛ. Ŋii nɛ dunia niaa jaŋ jiŋ ari ŋ nɛ tiŋmi. Ba ma jaŋ jiŋ ari ŋ choba nɛ ari ŋ si chomi ŋii. ");
INSERT INTO sil_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mi Nyimma, ŋ paala chomi nɛ a leŋ mi laa yiriŋ, ka dunia-na suomi. Mi saa chɛ di ŋ leŋ di nialiŋ ŋ si liisa pimi, di ba hɛ mi teeŋ lee-na kala mi si jaŋ hɛ, di ba wuo na ŋii ŋ si leŋe mi laa yiriŋ. ");
INSERT INTO sil_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mi Nyimma, ŋ kɛŋ wutitii. Dunia niaa biŋ jiŋ, ama mi-na jimiŋ nɛ. Niaa deeŋba ma jiŋ ari ŋ nɛ tiŋmi. ");
INSERT INTO sil_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi saa ŋaa ba jimiŋ nɛ, mi saa ha jaŋ leŋ di ba jimiŋ. Mi ŋaa ŋii, di ŋii ŋ si chomi, di ba ma cho dɔŋɔ, di mi ma hɛba lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu si bul wiaa deeŋba dɛrɛ, ba duu haritooroo sii kieli fuo-naaŋ kubala ba kaa yirɛ Kidirɔŋ. Lee kubala nɛ fa hɛ dimɛ ba chɔŋsɛ tiisiŋ. Ŋii nɛ Yesu ari u haritooroo juu lee-la. ");
INSERT INTO sil_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ba vɛnɛɛ mu lee-la nɛ, ŋii nɛ tii Judas, nii-la si joŋu yallɛ, ma wuo jiŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ŋii nɛ Judas kɛŋ laali-yuoroo dɔŋsuŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ tiŋtinni-biisiŋ, ari Farisii tiŋŋaa tiŋtinni-biisiŋ, di ba mu kɛŋ Yesu. Ba mu lee-la Yesu si hɛ. Ba síi mu ŋii, ba kori chaanaa, ka-pilaa ari nyiniŋ ari ba ba-kiaa. ");
INSERT INTO sil_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu jiŋ wii-la kala fa si jaŋ ŋaau lɛ nɛ. Ŋii nɛ u mu cheŋba a piɛsɛba, “Kubɛɛ nɛ maa chɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ŋii nɛ ba si, “Yesu si lii Nazarɛt nɛ la chichɛ.” Ŋii nɛ u bula piba, “Mi nɛ ŋla.” Judas, nii-la fa si jaŋ joŋu yallɛ, u ma fa hɛ ba tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu si bul ŋii, ba miira yala mu hariŋ a tuu tel. ");
INSERT INTO sil_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ŋii nɛ Yesu bira piɛsɛba a bul, “Kubɛɛ nɛ maa chɛ?” Ba si, “Yesu si lii Nazarɛt.” ");
INSERT INTO sil_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ŋii nɛ Yesu bula piba, “Mi laa sipaaŋ bula pima ari mi nɛ ŋla. Di ma níi chɛmi, má leŋ di ni-kaanaa viiri.” ");
INSERT INTO sil_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(U bul ŋii di wii-la u fa si bula, duu wuo sɛnɛ ŋaa wutitii. U fa bula ari nialiŋ kala Wia si liisa pu, ba kuŋ-kala bi lɛlɛ.) ");
INSERT INTO sil_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saamɔŋ Piita fa kori tokobii nɛ. Ŋii nɛ u tuurɛ a ta nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia-yomo na-diiŋ digiliŋ a keri. Yomo-la yiriŋ nɛ fa Malikas. ");
INSERT INTO sil_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ŋii nɛ Yesu bula pi Piita a bul, “Joŋ ŋ tokobii-la hɛ u pɛɛŋ lɛ. U bi maga di mi na hɛɛ-la, mi Nyimma síi chɛ di mi na, koo?” ");
INSERT INTO sil_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ŋii nɛ laali-yuoroo ari ba kuhiaŋ ari Ju̱u tiŋŋaa titinni-biisi-la kɛŋ Yesu a vɔbu. ");
INSERT INTO sil_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba laa sipaaŋ kɛnu kaa mu Anas teeŋ nɛ. Anas nɛ fa ŋaa Kayafas hiili-baala. Jina-la Kayafas ma nɛ fa ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ. ");
INSERT INTO sil_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas nɛ fa laa sipaaŋ bula pi Ju̱u tiŋŋaa ari ni-bala nɛ laa tiŋteeŋ niaa kala nyuŋ suu, u nɛ kpia ni-daŋ si suba. ");
INSERT INTO sil_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saamɔŋ Piita ari Yesu haritooroo dɔŋɔ to Yesu hariŋ, a juu nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ kaala. Kuhiaŋ-la fa jiŋ Yesu haritooro deeŋ nɛ. Ŋii wiaa haritooru-la to Yesu hariŋ a juu kaala-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ka Piita chiŋ kaala-la jeeŋ hariŋ boiŋniiŋ. Ŋii nɛ Yesu haritooro-la dɔŋɔ, nii-la nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ si jima, u miira lii, a bula pi toli-bie kubala si pɔ boiŋ-la niiŋ duu leŋ di Piita ku juu, aŋ kɛŋ Piita ku juu. ");
INSERT INTO sil_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ŋii nɛ tolo-la si chiŋ boi-la niiŋ piɛsɛ Piita, “Ŋ ma bi baal-la haritooroo dɔŋɔ ŋaa?” Ŋii nɛ Piita si, “Ai, mi dee.” ");
INSERT INTO sil_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Di waariŋ fa hɛ dimɛ. Ŋii nɛ dia-la tiŋtinnaa ari nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ tiŋtinni-biisiŋ hɛ nyiniŋ a china golli aa wieni. Piita ma mu chiŋ ba teeŋ aa wieni nyiŋ-la. ");
INSERT INTO sil_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ piɛsɛ Yesu wiaa a tigɛ u haritooroo lɛ ari wialiŋ u fa síi dagu. ");
INSERT INTO sil_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ŋii nɛ Yesu bul, “Wialiŋ kala mi si bula, mi yie chiŋ ni-daŋ tuɔŋ nɛ a bul. Mi yie chaasa chiŋ Wii-chuɔlɛ diisiŋ tuɔŋ nɛ ari Wia-dia tuɔŋ, lee-la Ju̱u tiŋŋaa kala si yie ku hilimi nɛ a bul. Mi ha bi wii-kala luɔra bul. ");
INSERT INTO sil_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bɛɛ nɛ saa tii ŋ piɛsɛmi? Piɛsɛ nialiŋ si nii wialiŋ mi si bula, di ba dagiŋ. Ba jiŋ wialiŋ mi si bula nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu si bul ŋii, nialiŋ si kpu pusuŋ pipi Wia tiŋtinni-bie dɔŋɔ fallɛ Yesu chaŋkpaŋiŋ lɛ aŋ bul, “Ŋla nɛ u magɛ di ŋ bul wiaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ teeŋ koo?” ");
INSERT INTO sil_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ŋii nɛ Yesu bul, “Di mi nɛ bul wii chei, u maga di ŋ bul di nuu-kala nii nɛ. Ka di wii-la mi si bula nɛ ŋaa wutitii, bɛɛ nɛ tii ŋ fallɛmi?” ");
INSERT INTO sil_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ba si vɔɔ Yesu ŋii, ŋii nɛ Anas leŋ ba kɛnu ŋii kaa mu nii-la si kpu pusuŋ pipi Wia kuhiaŋ Kayafas teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ka Piita ha chiŋ kaala-la tuɔŋ aa wieni nyiŋ-la. Ŋii nɛ nialiŋ dɔŋsuŋ piɛsu a bul, “Ŋ ma bi baala deeŋ haritooroo dɔŋɔ ŋaa?” Piita kaa via aŋ bul, “Ai, mi dee.” ");
INSERT INTO sil_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dia tiŋtinnaa dɔŋɔ ma pɛu lɛ. U fa ŋaa nii-la Piita si ta u digiliŋ keri, u naaŋbii nɛ. U piɛsu a bul, “Mi fa bi ma di baal-la na, lee-la ba si chɔŋsɛ tiisiŋŋ?” ");
INSERT INTO sil_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ŋii nɛ Piita bira kaa via aŋ bul di ai, u dee. U bul ŋii dɛrɛ di ji-bele yele. ");
INSERT INTO sil_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chichuɔ-fiɛla fɛlɛlɛ ba kɛŋ Yesu lii Kayafas dia lɛ, a kɛnu kaa mu baal kubala dia baa yirɛ Paalit. Paalit nɛ fa hɔŋ Rom kuori-baliŋ nyuŋ lee-la. Ju̱u tiŋŋaa bi to juu. Ba bi chɛ di ba ŋaa disinniŋ a chei ba kisiŋ lɛ, aŋ wuo dii diisiŋ kieliŋ gbiele kudiilee. ");
INSERT INTO sil_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ŋii nɛ Paalit lii a piɛsɛba a bul, “Bɛɛ nɛ ma si baala deeŋ ŋaa chei?” ");
INSERT INTO sil_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ŋii nɛ ba bula pu a bul, “Di u nɛ fa bi wii ŋaa chei, la fa bi jaŋ kɛnu kaa kɔ ŋ teeŋ.” ");
INSERT INTO sil_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ŋii nɛ Paalit bula piba a bul, “Má kɛnu kaa mu to ma titia woŋbiiŋ lɛ a dii u sariya.” Ŋii nɛ ba bula pu a bul, “La bi woŋbiiŋ kɛnɛ di la kpu nuu-kala.” ");
INSERT INTO sil_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yesu fa si daga ari u jaŋ suu daa-gɛsɛɛ nyuŋ, u ŋii sɛnɛ ŋaa wutitii. ");
INSERT INTO sil_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ŋii nɛ Paalit miira juu dia a yirɛ Yesu a piɛsu, “Ŋ nɛ ŋaa Ju̱u tiŋŋaa kuoroo?” ");
INSERT INTO sil_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ŋii nɛ Yesu piɛsu, “Ŋ titia nɛ bul wiiŋ deeŋ koo nuu nɛ bul ŋii piŋ a tigɛmi lɛ?” ");
INSERT INTO sil_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ŋii nɛ Paalit bira bul, “Mi bi Ju̱u tiina ŋaa. Ŋ titia nia ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ nɛ joŋuŋ hɛ mi nisiŋ lɛ. Bɛɛ nɛ ŋ ŋaa chei?” ");
INSERT INTO sil_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ŋii nɛ Yesu bul, “Mi kuoruŋ tuo dunia deeŋ lɛ, di mi kuoruŋ nɛ fa hɛ dunia deeŋ lɛ, mi niaa fa jaŋ yuo laami, di Ju̱u tiŋŋaa sími wuo kɛŋ. Ama mi kuoruŋ tuo daha.” ");
INSERT INTO sil_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ŋii nɛ Paalit piɛsu a bul, “Ŋ saa ŋaa kuoru nɛ koo?” Ŋii nɛ Yesu bul, “Wii-la ŋ si bula ŋaa wutitii nɛ. Ba paala lulmi di mi ku ŋaa kuoru nɛ. Mi ku tuu dunia di mi dagɛ niaa, di ba jiŋ wutitii nɛ. Nii-la kala si cho duu jiŋ wutitii yie jegile nii mi teeŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ŋii nɛ Paalit piɛsu, “Wutitii nɛ bɛɛ?” Ŋii nɛ Paalit miira lii di-jaliŋ Ju̱u timma-la teeŋ a bula piba a bul, “Mi bi wii-la na baala deeŋ si cheye. ");
INSERT INTO sil_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama jina-na kala, di diisiŋ kieliŋ gbiele-la nɛ yie-na kala, mi yie vɛnɛ liisɛ nialiŋ ba si kaa tɔ dia dɔŋɔ nɛ pima. U ŋii nagɛ ari ma kisiŋ nɛ. Ma saa chɛ di mi liisɛ Ju̱u tiŋŋaa kuoru-la nɛ ta pimaa?” ");
INSERT INTO sil_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ŋii nɛ ba kpia goŋ a bul, “Ai, nia deeŋ dee! Liisɛ Barabas ta. (Barabas fa ŋaa gaaru nɛ.)” ");
INSERT INTO sil_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ŋii nɛ Paalit leŋ ba kɛŋ Yesu a viiru. ");
INSERT INTO sil_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ba si viiru dɛrɛ, laali-yuoroo kɛŋ sɔsuŋ sua nyuŋ-chuulo a nagɛ kuoro nyuŋ-chuulo a joŋo chuu, a joŋ gɛri-fiaŋ laalu ");
INSERT INTO sil_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","aŋ chuɔlu a bul, “Ju̱u tiŋŋaa kuoro, laa chuɔluŋ!” aŋ pɛ fallu. ");
INSERT INTO sil_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ŋii nɛ Paalit bira miira lii nialiŋ teeŋ a bula piba a bul, “Má bee na, mi kɛnu kaa kuu lii ma teeŋ nɛ di ma jiŋ ari mi-na bi wii-kala na u si cheye a magɛ di ba kpuu.” ");
INSERT INTO sil_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ŋii nɛ Yesu ku lii a ha chu sɔsuŋ nyuŋ-chuulo-la ari gɛri-fiaŋ-la ba si joŋo laalu. Ŋii nɛ Paalit bula piba, “Má na baal-la.” ");
INSERT INTO sil_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ba tiŋtinni-biisiŋ si nau, ba kpia goŋ a bul, “Leŋ di ba kpaasu daa-gɛsɛɛ nyuŋ.” Ŋii nɛ Paalit bula piba, “Má titia kɛnu kpaasɛ daa-gɛsɛɛ nyuŋ. Mi-na bi wii-la u si cheye na.” ");
INSERT INTO sil_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ŋii nɛ Ju̱u timma-la bira bul, “U kɛŋ u titia yirɛ Wia Bii nɛ. La kisiŋ lɛ nii-la kala si ŋaa ŋii, u maga di ba kpuu nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Fawulluŋ fa paala kɛŋ Paalit nɛ. U si nia ari ba bul ŋii, fawulluŋ wasa kɛnu. ");
INSERT INTO sil_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ŋii nɛ u bira miira juu dia-la a piɛsɛ Yesu a bul, “Nii nɛ ŋ lii?” Yesu bi wii-kala bula. ");
INSERT INTO sil_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ŋii nɛ Paalit piɛsu, “Ŋ tɔrɛ ŋ niiŋ nɛɛ? Ŋ bi jiŋ mi kɛŋ doluŋ di mi joŋuŋ taa, a bira kɛŋ doluŋ di mi leŋ di ba kpaasiŋ daa-gɛsɛɛ nyuŋ?” ");
INSERT INTO sil_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ŋii nɛ Yesu bula pu, “Ŋ fa bi dol kala kɛnɛ mi lɛ. Wia nɛ piŋ dol-la. Ama nii-la si joŋmi hɛ ŋ nisiŋ lɛ nɛ faasa kɛŋ haachɛba a kiiŋ.” ");
INSERT INTO sil_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paalit si nii ŋii, u fa cho duu joŋ Yesu ta. Ŋii nɛ Ju̱u tiŋŋaa faasa kpia goŋ a bul, “Di ŋ nɛ joŋu ta, ŋ bira bi la tiŋteeŋ kuori-baliŋ ba síi yirɛ Siiza naŋdɔŋ ŋaa. Nii-la kala si kɛŋ u titia yiyirɛ kuoru, u tiina ŋaa kuori-baliŋ diŋdɔŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paalit si nii ŋii, u kɛŋ Yesu kaa ku lii, aŋ mu hɔŋ u sariya diiri kpasa nyuŋ. Ba kɛŋ lee-la kaa yirɛ Gabata nɛ Hiiburu yiikoro lɛ. U bubuɔŋ nɛ: Lee-la tabiaa ŋaa mula mula nɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Di wia jil nyu-gbaŋa. Tapulii-la nɛ Ju̱u tiŋŋaa ŋaa siri di u taŋ nɛ pula di ba gbieli diisiŋ kieliŋ gbiele-la. Ŋii nɛ Paalit bula piba a bul, “Má na ma kuoro.” ");
INSERT INTO sil_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ŋii nɛ ba faasa kpia goŋ a bul, “Leŋ di ba kɛnu kaa mu kpaasu daa-gɛsɛɛ nyuŋ.” Ŋii nɛ Paalit piɛsɛba a bul, “Maa chɛ di mi kpaasɛ ma kuoro daa-gɛsɛɛ nyuŋ nɛɛ?” Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ bul, “La bi kuoru kala kɛnɛ a pɛ Siiza lɛ.” ");
INSERT INTO sil_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ŋii nɛ u joŋ Yesu piba di ba kaa mu kpaasɛ daa-gɛsɛɛ nyuŋ. ");
INSERT INTO sil_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ŋii nɛ ba kɛŋ Yesu lii. U lii a baasɛ u titia daa-gɛsɛɛ a mu lee-la ba síi chɛ di ba kpaasu. Lee-la yiriŋ nɛ nyu-kuŋkogulo. Hiiburu yiikoro lɛ baa yirɛ lee-la Gɔligɔta nɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lee-la nɛ ba kpaasu daa-gɛsɛɛ nyuŋ. Ba fa kpaasɛ niaa balia ma nɛ daa-gɛsɛɛ nyuŋ a pɛ Yesu lɛ. Dɔŋɔ hɛ u na-diiŋ, dɔŋɔ ma hɛ u na-gua. Ka Yesu hɛ tutuɔbaaniŋ. ");
INSERT INTO sil_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ŋii nɛ Paalit ŋmuŋsa mɛrɛ daa-gɛsɛ-la lɛ a bul, “Ju̱u tiŋŋaa kuoro Yesu a lii Nazarɛt.” ");
INSERT INTO sil_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lee-la kpagɛ Jerusalɛm nɛ. Ŋii nɛ Ju̱u tiŋŋaa yuga a karimɛ wii-la Paalit si ŋmuŋsa mɛrɛ daa-gɛsɛ-la lɛ. U ŋmuŋsɛ wii-la ari yiikorusuŋ batori nɛ. U kɛŋ Hiiburu tiŋŋaa yiikoro ŋmuŋsɛ, a kɛŋ Latiŋ yiikoro ma ŋmuŋsɛ, a kɛŋ Giriik tiŋŋaa yiikoro ma ŋmuŋsɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ŋii nɛ Ju̱u tiŋŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ bula pi Paalit ari u sí ŋmuŋsa bul di Ju̱u tiŋŋaa kuoro nɛ, ama duu bul di baala deeŋ nɛ si u nɛ ŋaa Ju̱u tiŋŋaa kuoro. ");
INSERT INTO sil_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ŋii nɛ Paalit bul, “Wii-la mi si folo ŋmuŋsɛ ŋii, mi bira bi kaa birimɛ.” ");
INSERT INTO sil_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Laali-yuoro-la si kpaasɛ Yesu daa-gɛsɛ-la nyuŋ dɛrɛ, ba paa u gɛnniŋ a kaa kpaa leree banɛsɛ. Laali-yuoru kala kɛŋ dɔŋɔ. Gɛri-bal kubala ma nɛ fa hɛ dimɛ. Ba yie yuo ŋii nɛ, ba bi gɛripɛɛ kala yɛrɛ mɛrɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ŋii nɛ laali-yuoro-la bula pi dɔŋɔ a bul, “Ma sí leŋe di la kɛŋ gɛri-la kiɛsɛ, má leŋ di la tɔŋsɛ, a na nii-la si jaŋ dii duu laa gɛri-la.” Wiiŋ deeŋ ba ŋaa di wialiŋ ba fa si ŋmuŋsa Wia teniŋ tuɔŋ, duu ŋaa wutitii nɛ. Ba fa si, “Ba paa mi gɛnniŋ kpaa dɔŋɔ nɛ aŋ tiŋ mi gɛriŋ dɔŋɔ wiaa a tɔŋsɛ.” ");
INSERT INTO sil_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nialiŋ fa si china kpagɛ Yesu daa-gɛsɛ-la nɛ ŋla: Yesu naaŋ, ari u naaŋ dihaala, ari Kilopas haala Mɛɛri, ari Mɛɛri Magidaliŋ. ");
INSERT INTO sil_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu si na u naaŋ ari u haritooru-la u fa si cho, di ba china, ŋii nɛ u bul u naaŋ lɛ a bul, “Haal, bee na ŋ bie nɛ ŋla,” ");
INSERT INTO sil_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","aŋ bira bula pi u haritooru-la ma a bul, “Na ŋ ma naaŋ nɛ ŋla.” A chiŋ bua-la lɛ u haritooru-la kɛŋ Yesu naaŋ-la a kaa mu u dia ba hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu jima ari lɛɛlɛ wii-wii-kala dɛrɛ nɛ, ka duu wuo leŋ di wialiŋ ba si ŋmuŋsa Wia teniŋ tuɔŋ, di ba ŋaa wutitii, ŋii nɛ u si lii-nyuasuŋ nɛ kɛnu. ");
INSERT INTO sil_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Di siniŋ si nyala su̱ gbaŋa chiŋ dimɛ. Ba joŋ suosuo a siŋ siŋ-la lɛ, a kɛŋ sakeliŋ liisɛ suosuo-la, a kaa jila hɛ Yesu niiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ŋii nɛ Yesu nyua siŋ-la. U si nyua siŋ-la dɛrɛ, ŋii nɛ u bul, “Wii-kala dɛrɛ nɛ”, aŋ kɛŋ u nyuŋ chugili a suu. ");
INSERT INTO sil_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tapulii-la nɛ Ju̱u tiŋŋaa ŋaa siri a gbɛrɛ ba diisiŋ kieliŋ gbiele-la. Tapulii-la ma ŋaa chɛ-wiesii-la chɛɛŋ nɛ. Ŋii nɛ tii ba bi chɛ di nialiŋ sagɛ daa-gɛsɛ-la nyuŋ chɛɛ-la. Ŋii nɛ ba mu sul Paalit duu leŋ di laali-yuoroo mu bori ba naasiŋ aŋ soriba daa-gɛsɛ-la nyuŋ. U sɛi. ");
INSERT INTO sil_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ŋii nɛ laali-yuoro-la mu kɛŋ baala-la ba si kpua a pɛ Yesu lɛ naasiŋ kaa bori. ");
INSERT INTO sil_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba kɔ Yesu leriŋ duu suba. Ŋii wiaa ba bi u naasiŋ boro. ");
INSERT INTO sil_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ama laali-yuoro-la dɔŋɔ joŋ u timiŋ a tɔɔ Yesu sɛmɛ lɛ u luri. Ŋii nɛ chaliŋ ari liiŋ lii. ");
INSERT INTO sil_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mi-na Jɔɔŋ nɛ na wiaa deeŋba ari mi siiŋ aa bulba. Wutitii nɛ mi bul. Mi bul wiaa deeŋba pipima di ma ma laa dii. ");
INSERT INTO sil_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wiaa deeŋba kala ŋaa di wialiŋ ba si ŋmuŋsa Wia teniŋ tuɔŋ ŋaa wutitii nɛ. Ba ŋmuŋsa a bul, “Ba bi jaŋ bori u haŋgbel-bala maa.” ");
INSERT INTO sil_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wia teniŋ sɛmɛ dɔŋɔ ba bira bula ari ba jaŋ beŋ nii-la ba si tɔbɔ. ");
INSERT INTO sil_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yesu si suba, baal kubala ma fa hɛ dimɛ. Baa yirɛ Josɛf. U fa lii Arimatiya tiŋteeŋ nɛ. U ma fa ŋaa Yesu haritooroo dɔŋɔ nɛ. Ama u-na faa luɔru nɛ a tiŋ Ju̱u tiŋŋaa wiaa. Uu fába nɛ. Ŋii nɛ u mu sul Paalit duu leŋ duu sori Yesu ku-suuŋ. Paalit pu woŋbiiŋ. Ŋii nɛ u mu sori. ");
INSERT INTO sil_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodiimas, nii-la fa si laa sipaaŋ mu Yesu teeŋ titaŋiŋ, u ma to Josɛf hariŋ mu, a pɛ kɛŋ tii-keli-zɔŋ kubala baa yirɛ mɛɛ ari dɔŋɔ maa baa yirɛ alɔis. Ba yuŋuŋ magɛ nuhuobiine yuŋuŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ba balia nɛ mu joŋ Yesu ku-suuŋ, a joŋ gɛripɛ-pula, a joŋ kialiŋ misɛ gɛripɛ-pula-la, a kaa bɛ Yesu. Ju̱u tiŋŋaa yie ŋaa ŋii nɛ a huhugi ba suunuŋ. ");
INSERT INTO sil_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lee kubala nɛ kpagɛ lee-la ba fa si kpaasɛ Yesu daa-gɛsɛ-la nyuŋ. Ba chɔŋsɛ tiisiŋ. Tiisi-la tuɔŋ buŋ kubala nɛ fa hɛ dimɛ ba lɔsɛ. Ama ba ha bi nuu-kala hugo dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U si ka tapul-bala ka di Ju̱u tiŋŋaa gbieli-baliŋ yi, ka bua-la ma kpagɛ lee-la, ŋii nɛ ba joŋ Yesu hugi dimɛ. ");
INSERT INTO sil_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lahadi chɛɛŋ siipuuraa di leriŋ kala ha bire, Mɛɛri Magidaliŋ mu bua-la leriŋ a na tabii-la ba si joŋo tɔ bua-la niiŋ duu suro. ");
INSERT INTO sil_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ŋii nɛ u fá mu Saamɔŋ Piita ari Yesu haritooro-la dɔŋɔ teeŋ, nii-la Yesu fa si cho woruŋ, a bula piba a bul, “Ba liisɛ la Tiina Yesu bua-la tuɔŋ nɛ. La bi jiŋ lee-la kala ba si joŋu bil.” ");
INSERT INTO sil_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ŋii nɛ Piita ari Yesu haritooro-la dɔŋɔ-la sii mu bua-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ba kala balia fá. Ŋii nɛ dɔŋɔ-la tiina kieli Piita, a laa sipaaŋ fá mu bua-la leriŋ. ");
INSERT INTO sil_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","U si yi bua-la leriŋ, u bi bua-la tuɔŋ jua. U tuu ti̱ŋ nɛ a nyilimi a na gɛnni-la ba fa si joŋo bɛ Yesu, di ba pina, ka u buu na. ");
INSERT INTO sil_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ka Piita to hariŋ kɔ a ku juu bua-la tuɔŋ, a na gɛnni-la ba fa si joŋo bɛ Yesu, di ba pina. ");
INSERT INTO sil_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ka gɛri-la ba fa si joŋo vɔɔ Yesu nyuŋ ma, duu chuolo piŋ u duŋduŋa. ");
INSERT INTO sil_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ŋii nɛ nii-la si laa sipaaŋ mu bua-la leriŋ ma juu bua-la tuɔŋ a na wii-la si ŋaa, a laa dii ari Yesu sii suuŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ama ba bi wii-la ba fa si ŋmuŋsa Wia teniŋ tuɔŋ bubuɔŋ jiŋ ari u maga di Yesu sii suuŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋii nɛ Yesu haritooro-la miira mu ba diisiŋ. ");
INSERT INTO sil_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bua-la lɛ di Mɛɛri miira mu bua-la teeŋ. Ŋii nɛ u chiŋ dimɛ aa yel. Uu yel ŋii nɛ aŋ pɛ nyinyilimi bua-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","U nyilimi bua-la tuɔŋ ŋii nɛ a na Wia tiŋdaaraa balia bua-la tuɔŋ a laalɛ gɛri-pulluŋ. Dɔŋɔ hɔŋ Yesu nyuŋ fa si mu lee-la. Dɔŋɔ ma hɔŋ u naasiŋ fa si mu lee-la. ");
INSERT INTO sil_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ŋii nɛ ba piɛsu a bul, “Haal, bɛɛ nɛ tii ŋ yiyel?” Ŋii nɛ u bul, “Ba joŋ mi Tiina Yesu kaa lɛl nɛ. Mi bi jiŋ ba si joŋu kaa mu bil lee-la.” ");
INSERT INTO sil_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","U si bul ŋii dɛrɛ aŋ ŋaa duu birimɛ, duu na baal duu chiŋ dimɛ. Yesu nɛ fa ŋii. Ama Mɛɛri fa bi jiŋ ari Yesu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ŋii nɛ Yesu ma piɛsɛ Mɛɛri, “Bɛɛ nɛ tii ŋ yiyel? Kubɛɛ nɛ ŋ chichɛ?” Mɛɛri fa biina baal-la síi beŋ tiisi-la nɛ. Ŋii nɛ u piɛsu, “Kuhiaŋ, di ŋ nɛ joŋo, dagɛmi lee-la ŋ si kaa mu bil, di mi mu joŋu kaa viiri.” ");
INSERT INTO sil_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ŋii nɛ Yesu yiru a bul, “Mɛɛri.” Ŋii nɛ u miira daasɛ aŋ bul ari Hiiburu yiikoro, “Rabboni, ŋ nɛɛ?” (Rabboni bubuɔŋ nɛ kuhiaŋ.) ");
INSERT INTO sil_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ŋii nɛ Yesu bula pu a bul, “Sími kɛŋ. Mi ha bi mi Nyimma teeŋ jila. Ama mu bula pi mi naaŋbiiriŋ ari mi jaŋ jil mi Nyimma teeŋ. U ŋaa ma ma Nyimma nɛ a ŋaa mi Wia, a ŋaa ma ma Wia.” ");
INSERT INTO sil_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ŋii nɛ Mɛɛri Magidaliŋ mu Yesu haritooro-la teeŋ, a bula piba a bul duu na u Tiina Yesu nɛ, a bul wialiŋ ma kala u si bula pu. ");
INSERT INTO sil_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lahadi chɛɛŋ titaŋiŋ u haritooroo hilimi dia tuɔŋ aŋ kɛŋ boiŋ yagɛ. Baa fá Ju̱u timma-la nɛ. Ŋii nɛ tii ba kɛŋ borusuŋ tɔ a yagɛ. Ŋii nɛ Yesu ku chiŋ ba tutuɔbaaniŋ aŋ bul, “Ma jaŋ hɔŋ ari yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","U si bul ŋii dɛrɛ, u kɛŋ u nisaa ari u sɛmɛ dagɛba. U haritooroo kala tuɔŋ tɔrɛ ba si na ba Tiina Yesu. ");
INSERT INTO sil_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ŋii nɛ Yesu bira bula piba, “Ma jaŋ hɔŋ ari yarifiɛlaa. Mi Nyimma si tiŋmi ŋii, ŋii titia nɛ mi maa tiŋma di ma tiŋ mi tiŋtiŋŋaa.” ");
INSERT INTO sil_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","U si bul ŋii dɛrɛ, u wiese hɛba lɛ aŋ bul, “Má laa Wia Diŋ-zɔŋ-la duu hɛma lɛ. ");
INSERT INTO sil_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Di ma nɛ joŋ nuu haachɛba a chɛu, u bira bi haachɛ kɛnɛ. Di ma nɛ bira bi nuu haachɛba joŋo chɛu, u ha kɛŋ u haachɛba nɛ.” ");
INSERT INTO sil_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Bua-la lɛ Yesu si kɛŋ u titia ku dagɛ u haritooro-la, u haritooro-la dɔŋɔ fa tuo. U yiriŋ nɛ Tɔmas. Ba fa ŋaa daaliɛri nɛ. Ŋii nɛ tii baa yiru daaliɛriŋ maa. ");
INSERT INTO sil_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ŋii nɛ u haritooro-la dɔŋsuŋ bula pu a bul di ba na Yesu. Ŋii nɛ Tɔmas bula piba a bul, see duu na hɛmɛ-la buasuŋ u nisaa lɛ, a joŋ u neniiŋ hɛ bua-la lɛ, a joŋ u neniiŋ hɛ u sɛmɛ bua-la ma lɛ, u bi jaŋ laa dii ari wialiŋ ŋaa wutitii. ");
INSERT INTO sil_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tapulaa chori pɛgɛ Yesu haritooro-la bira juu dia a kɛŋ boiŋ yagɛ. Bua-la-na lɛ di Tɔmas hɛ ba tuɔŋ. Di Yesu ku juu chiŋ ba tutuɔbaaniŋ aŋ bul, “Ma jaŋ hɔŋ ari yarifiɛlaa.” ");
INSERT INTO sil_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ŋii nɛ aŋ ka u bula pi Tɔmas, “Joŋ ŋ neniiŋ a hɛ mi nisiŋ bua-la lɛ aŋ beŋ mi nisaa, aŋ kɛŋ ŋ nisiŋ hɛ mi sɛmɛ bua-la ma lɛ a na, aŋ laa mi wiaa dii, aŋ sí kaa lɛrɛ.” ");
INSERT INTO sil_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ŋii nɛ Tɔmas yiru a bul, “Mi Tiina, ŋ nɛ mi Wia!” ");
INSERT INTO sil_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ŋii nɛ Yesu piɛsu, “Ŋ si nami nɛ tii ŋ laa mi wiaa dii koo? Nialiŋ si bimi na aŋ laa mi wiaa dii, ba tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ŋaa wu-magilaa yugɛ u haritooroo na a pɛ wialiŋ mi si ŋmuŋsa teniŋ deeŋ tuɔŋ. Aŋ ka mi bi ba-na ŋmuŋsa hɛ teniŋ deeŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama mi ŋmuŋsɛ wiaa deeŋba di ma wuo laa dii ari Yesu nɛ ŋaa Kirisito, nii-la Wia si liisa aŋ pɛ ŋaa Wia Bie maa. Di ma nɛ laa wiaa deeŋba dii, ma jaŋ kɛŋ miisiŋ u doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesu bira kɛŋ u titia dagɛ u haritooroo dɔŋsuŋ muga kubala niiŋ baa yirɛ Tabiiras. U haritooro-la nɛ ŋla: ");
INSERT INTO sil_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saamɔŋ Piita ari Tɔmas, nii-la ba fa si kaa yirɛ daaliɛriŋ maa, ari Natanial fa si lii taŋ kubala nɛ baa yirɛ Keena a hɛ Galilii tiŋteeŋ. Zɛbidii biiriŋ balia ma nɛ fa hɛ dimɛ, ari Yesu haritooroo balia maa. ");
INSERT INTO sil_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ŋla nɛ u to a kɛŋ u titia ku dagɛba: Ba fa chiŋ muga-la niiŋ nɛ. Ŋii nɛ Saamɔŋ Piita bula pi haritooro-la ku-kaanaa ari uu mu duu kɛsɛ cheŋfilee nɛ. Ŋii nɛ ba kala bul di ba jaŋ to mu. Ŋii nɛ ba mu joŋ liiŋ daboro a juu liiŋ tuɔŋ, ama titaŋ-la kala ba bi cheŋfilii kala kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Taŋ si pulaa kɔ di Yesu chiŋ lii-la niiŋ, ama u haritooro-la bi jiŋ ari u nɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ŋii nɛ Yesu piɛsɛba, “Mi naŋdɔŋsuŋ, ma kɛsɛ cheŋfilee nɛɛ?” Ŋii nɛ ba bul di ba bi kubala ma kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ŋii nɛ u bula piba di ba joŋ ba joŋba, a yuo hɛ liiŋ tuɔŋ liiŋ daboro-la na-diiŋ sɛmɛ, di ba nɛ ŋaa ŋii, ba jaŋ kɛsɛ cheŋfilee. Ŋii nɛ ba joŋ joŋ-la yuo kɛsɛ cheŋfilee su̱. U si suo ŋii, ba bi wuo lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ŋii nɛ haritooru-la Yesu si cho woruŋ bula pi Piita a bul, “La Tiina Yesu nɛ!” Bua-la lɛ di Piita fa wuri u gɛriŋ nɛ. U si nii ŋii, u joŋ u gɛriŋ a laalɛ, aŋ lii liiŋ daboro-la lɛ, a fula juu liiŋ duu duoro mu Yesu teeŋ. ");
INSERT INTO sil_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lee-la ari lii-la niiŋ fa bi bol. U fa yi naakieliŋ zɔlɔ nɛ. Ka Yesu haritooro-la ku-kaanaa lɛrɛ joŋ-la ari cheŋfilie-la ku lii lii-la niiŋ. ");
INSERT INTO sil_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba si ku lii lii-la niiŋ, ba na hɔlɔɔ nyiniŋ di cheŋfilee chɛbɛ, ka ba na boroboro maa. ");
INSERT INTO sil_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ŋii nɛ Yesu bula piba a bul, “Má liisɛ cheŋfilie-la dɔŋsuŋ ma si kɛsɛ lɛɛlɛ a kaa kɔ.” ");
INSERT INTO sil_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ŋii nɛ Saamɔŋ Piita mu lɛrɛ joŋ-la ku lii lii-la niiŋ, di cheŋfili-balaa suo. Cheŋfilie-la fa ŋaa zɔlɔ ari mahiŋ balia ari fii ari batori nɛ. Cheŋfilie-la yuga ŋii ma nɛ, aŋ ka joŋ-la bi kiɛsa. ");
INSERT INTO sil_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ŋii nɛ Yesu bula piba a bul, “Má ku lii billɛ ma niiŋ.” U si bul ŋii, u haritooroo kuŋ-kala bi piɛsɛ a bul di kubɛɛ nɛɛ? Ba kala jima ari ba Tiina Yesu nɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ŋii nɛ Yesu joŋ boroboro-la a piba, a joŋ cheŋfilie-la ma a piba di ba dii. ");
INSERT INTO sil_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","U si sii suuŋ lɛ u butori nɛ ŋii u si kɛŋ u titia kaa ku dagɛ u haritooroo. ");
INSERT INTO sil_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba si dii boroboro-la ari cheŋfilie-la dɛrɛ, ŋii nɛ Yesu piɛsɛ Saamɔŋ Piita a bul, “Jɔɔŋ bie Saamɔŋ, ŋ chomi a kii niaa deeŋba nɛɛ?” Ŋii nɛ Piita si, “Oo mi Tiina, ŋ titia jima ari mi choŋ nɛ.” Ŋii nɛ Yesu bula pu, “Beŋ mi niaa nyuŋ, ari pie-daara si yie beŋ u piesee nyuŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ŋii nɛ Yesu bira piɛsu, “Jɔɔŋ bie Saamɔŋ, ŋ chomi nɛɛ?” Ŋii nɛ u bira bul, “Oo mi Tiina, ŋ jima ari mi choŋ nɛ.” Ŋii nɛ Yesu bira bula pu, “Beŋ mi niaa nyuŋ, ari pie-daara si yie beŋ u piesee nyuŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ŋii nɛ Yesu bira piɛsu torimuŋ a bul, “Jɔɔŋ bie Saamɔŋ, ŋ chomi nɛɛ?” Yesu si piɛsu torimuŋ ŋii, u tuɔŋ chei. Ŋii nɛ Piita bula pu, “Mi Tiina, ŋ jiŋ wii-kala nɛ, ŋ jima ari mi choŋ nɛ.” Ŋii nɛ Yesu bira bula pu, “Beŋ mi niaa nyuŋ, ari pie-daara si yie beŋ u piesee nyuŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wutitii nɛ mi bulaa piŋ, ŋ fa si ŋaa haŋbie, ŋ yie kɛŋ ŋ damɛrɛ kaa vɔɔ ŋ tiŋa nɛ aa mu lee-la kala ŋ si cho. Ama di ŋ nɛ ku hiɛsɛ, ŋ jaŋ kɛŋ ŋ nisaa jee, aŋ ka di nuu dɔŋ nɛ joŋ damɛrɛ-la a vɔbuŋ aŋ kɛniŋ mu lee-la ŋ si bi cho di ŋ mua.” ");
INSERT INTO sil_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu si bul wiiŋ deeŋ, u dagɛ Piita si jaŋ suu ŋii a laa yiriŋ pi Wia. Ŋii hariŋ lɛ nɛ Yesu bula pu duu to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ŋii nɛ Piita daasɛ hariŋ a na Yesu haritooru-la Yesu fa si cho woruŋ, nii-la fa si suusa mu kpagɛ Yesu bua-la lɛ ba fa síi dii diisiŋ kieliŋ gbiele-la kudiilee, a fa piɛsu, “Mi Tiina, kubɛɛ nɛ chɛ duu joŋuŋ yallɛɛ?” ");
INSERT INTO sil_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piita si nau, ŋii nɛ u piɛsɛ Yesu a bul, “Mi Tiina, ka baala deeŋ, bɛɛ nɛ jaŋ ŋaau lɛ?” ");
INSERT INTO sil_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ŋii nɛ Yesu bula pu, “Di mi níi chɛ duu hɛ dimɛ ka di mi-na miira kɔ dunia, ŋ sipaa tuo dimɛ. To mi hariŋ.” ");
INSERT INTO sil_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ŋii nɛ ba ŋmoo doworo pi nialiŋ kala si laa Yesu wiaa dii ari Yesu haritooro deeŋ-na bi jaŋ suu. Ama Yesu bi ŋii bula. U si duu níi chɛ di haritooru-la hɛ dimɛ ka di u-na miira kɔ dunia, Piita sipaa tuo. ");
INSERT INTO sil_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mi-na Jɔɔŋ nɛ na wiaa deeŋba aa ŋmuŋsɛ teniŋ deeŋ. La saa jima ari wialiŋ kala mi si bula ŋaa wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ŋaa wiaa dɔŋsuŋ yugɛ a pɛ wialiŋ mi si ŋmuŋsa hɛ teniŋ deeŋ lɛ. Wialiŋ-na mi bi ŋmuŋsa. Di mi nɛ fa ŋmuŋsɛ wialiŋ kuŋ-kuŋ-kala, teŋ-la fa jaŋ yuga kii dunia kala.");
INSERT INTO sil_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mi naŋdɔŋɔ Tiafilas, mi-na Luuk laa sipaaŋ ŋmuŋsɛ teniŋ a piŋ. Teŋ-la lɛ mi dagɛ wialiŋ kala Yesu si ŋaa ari wialiŋ kala u si daga, a suomi bua-la lɛ u si suomo titiŋ u tiŋtiŋŋaa ");
INSERT INTO sil_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","a kaa mu tapulii-la Wia si joŋu a kaa jil Wia-jaŋ. Wia Diŋ-zɔŋ-la doluŋ lɛ u dagɛ u naŋzɔɔba-la u si tuɔsa tiŋtimii-la ba si jaŋ titiŋ, ka u-na jil Wia-jaŋ. ");
INSERT INTO sil_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","U si sii suuŋ lɛ, u kɛŋ u titia ku dagɛ u naŋzɔɔba-la a yugɛ nɛ tapulaa mahiŋ balia pɛgɛ. Woŋbiee yuga nɛ u kɛŋ u titia kaa dagɛ ari u weye, aŋ bul Wia kuorii-la wiaa a piba, ka u-na jil Wia-jaŋ. ");
INSERT INTO sil_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","U si hɛ ba teeŋ, u bula piba a bul, “Ma sí Jerusalɛm lɛ lii. Má gbɛrɛ ma Nyimma Wia zile ku-la u fa si si u jaŋ joŋo pima. Wii-la mi fa si bula pima nɛ ŋla: ");
INSERT INTO sil_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mi bula, ‘Jɔɔŋ síi fo niaa Wii-chuɔlɛ liiŋ, liiŋ duŋduŋa nɛ u kaa fo. Ama u bi dieni, ka mi joŋ mi Diŋ-zɔŋ-la hɛma lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu ari u naŋzɔɔba si hilimi ŋii, ba piɛsu, “La Tiina, tapulaa deeŋba lɛ, ŋ jaŋ bira leŋ di Iziral tiŋŋaa dii kuoruŋ?” ");
INSERT INTO sil_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ŋii nɛ Yesu bula piba, “Mi Nyimma bi chɛ di ma jiŋ tapuluŋ deeŋ. U nɛ kɛŋ doluŋ a hɛ tapulia-la wialiŋ si jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama di Wia joŋ u Diŋ-zɔŋ-la hɛma lɛ, ma jaŋ kɛŋ doluŋ. Ma jaŋ ŋaa mi siada tiŋŋaa a bul mi wiaa Jerusalɛm lɛ, Judiya tiŋteeŋ kala ari Samaria lɛ, a kaa mu dunia sɛmɛ-na kala.” ");
INSERT INTO sil_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu si bul ŋii dɛrɛ, Wia joŋu kaa jil Wia-jaŋ, ka ba china bibeŋ. Ŋii nɛ duoŋbiliŋbaaniŋ ku tɔu, ba bira buu na. ");
INSERT INTO sil_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ba ha si wula bibeŋ wia nyuŋ ŋii, di niaa balia nɛ ŋii a chiŋ ba sɛmɛ, a laalɛ gɛri-pulluŋ ");
INSERT INTO sil_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a piɛsɛba, “Galilii timma, bɛɛ nɛ tii ma chinaa beŋ wia nyuŋ ŋii? Yesu deeŋ Wia si joŋo ma sipaaŋ a kaa jil Wia-jaŋ, u jaŋ miira kɔ ari ma si nau duu jil Wia-jaŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ŋii nɛ Yesu haritooro-la lii peel-la ba síi yirɛ Olivɛt a miira mu Jerusalɛm. A chiŋ peel-la leriŋ a kaa mu Jerusalɛm u yi ari meel-daaŋ lebi nɛ. ");
INSERT INTO sil_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba si yi Jerusalɛm, ba mu juu dia-la ba síi juu Jerusalɛm lɛ, lusuŋ nyuŋ. Piita ari Jɔɔŋ ari Jeems ari Aŋduru ari Filip ari Tɔmas ari Batolomi ari Matiu, ari Alifiyas bie Jeems, ari Saamɔŋ Zɛlɔt, ari Jeems bie Judas, ba kala níi juu di-bala. ");
INSERT INTO sil_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ba di haalaa dɔŋsuŋ ari Yesu naaŋ Mɛɛri ari Yesu ŋaanaa, ba kala ŋaa nii-bala nɛ aa hilimi dimɛ, a fiɛsɛ siiŋ a chuchuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tapulii kubala ba ku hilimi dɔŋɔ lɛ. Ba fa yi ari niaa zɔlɔ ari mara. Ŋii nɛ Piita sii chiŋ duu bul wiaa a bul, ");
INSERT INTO sil_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mi naaŋbiiriŋ, Wia Diŋ-zɔŋ-la fa leŋe Devit dagɛ wialiŋ Judas si jaŋ ŋaa. Wia niiŋ wiaa deeŋba ku ŋaa wutitii. Judas nɛ kɛŋ niaa kɔ di ba kɛŋ Yesu. ");
INSERT INTO sil_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yesu fa liisu duu ŋaa la dɔŋɔ nɛ, a maa tiŋ la tiŋtimiŋ deeŋ. ");
INSERT INTO sil_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas si ŋaa wu-bɔŋ-la, u laa moribiee. U joŋ moribie-la a yɔɔ tiŋtee kubala nɛ. Dimɛ nɛ u tuu tele yɛrɛ. U tuɔŋ kiaa kala jaasɛ. ");
INSERT INTO sil_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","20","Niaa si hɛ Jerusalɛm lɛ kala nii. Ba yiikoro lɛ ba kɛŋ lee-la kaa yiyirɛ Akilidaama. U bubuɔŋ nɛ chaliŋ tiŋteeŋ. Devit ŋmuŋsa hɛ Wia teniŋ sɛmɛ dɔŋɔ baa yirɛ Saams a bul, ‘Wia jaŋ leŋ duu dia piŋ jikpeeŋ, di nuu-kala sí dimɛ juu.’ U bira ŋmuŋsa di nuu laa u nyuŋ a titiŋ u tiŋtiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ŋii wiaa nuu nɛ maga duu laa u nyuŋ a pɛla lɛ di la dii siada ari la Tiina Yesu sii suuŋ lɛ. Nia deeŋ maga duu lii nialiŋ fa síi to la hariŋ, bua-la lɛ Yesu si suomo kɛŋla gugɔllɛ, ");
INSERT INTO sil_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a lii bua-la Jɔɔŋ fa si fo Yesu Wii-chuɔlɛ liiŋ a kaa mu yi tapulii-la Wia si joŋu kaa jil Wia-jaŋ.” ");
INSERT INTO sil_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ŋii nɛ ba dagɛ niaa balia. Ba dɔŋɔ yiriŋ nɛ fa Josɛf Basabas. (U yiriŋ dɔŋɔ ma nɛ fa Jasitis.) Dɔŋɔ-la ma yiriŋ nɛ fa Matayas. ");
INSERT INTO sil_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba si dagɛ nialiŋ ŋii, ba suomo chuɔlɛ Wia a bul, “La Tiina Wia, ŋ nɛ jiŋ nuu-kala tuɔŋ wiaa. Ŋii wiaa dagɛla niaa deeŋba baliamiŋ tuɔŋ ku-la ŋ si liisa, ");
INSERT INTO sil_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","duu ŋaa ŋ naŋzɔɔ dɔŋɔ a laa Judas nyuŋ, a tiŋ u tiŋtiŋŋaa. Judas via nɛ aŋ suu aa mu Sitaani leriŋ.” ");
INSERT INTO sil_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ŋii nɛ ba tɔŋsɛ. Matayas kiaa dii. Ba diisu pɛ Yesu naŋzɔɔba-la fii ari kubala-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ba gbieli-bal kubala chɛɛ ku yi baa yirɛ Pɛŋtikɔs. (Tapulii-la nɛ ba yie ta ba bagi-buŋbuŋ kiaa a kaa mu pi Wia.) Chɛɛ-la ba ku hilimi di-bala. ");
INSERT INTO sil_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba bi yiɛla di ba nii goŋ. U lii wia nyuŋ a ku tuu ari peli-baliŋ síi ŋaa ŋii, a juu su̱ dia-la tuɔŋ ba fa si hɔnɔ. ");
INSERT INTO sil_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ŋii nɛ ba na kiaa a nagɛ nyiŋ-geli-biisiŋ. Ba nagisiŋ nagɛ neŋdelimee. Ba lii pisɛ. Nyiŋ-geli-bie kala togili nuu-kala si hɛ dia-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ba si togili nuu-kala lɛ ŋii, Wia Diŋ-zɔŋ-la hɛba kala lɛ, a piba doluŋ ba suomo bubul yiikori-yiri-yiriba ba si bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ju̱u tiŋŋaa dɔŋsuŋ ma fa hɛ Jerusalɛm lɛ aa fá Wia, a lii dunia sɛmɛ-na kala. ");
INSERT INTO sil_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ni-daŋ-la si nii goŋ deeŋ, ba kala ku hilimi. Ba si hilimi ŋii, ba nia di baa bul wiaa ba titia yiikorusuŋ lɛ. U ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ba faasa hiriki a bula pi dɔŋɔ, “Niaa deeŋba kala ŋaa Galilii tiŋŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɛɛ nɛ saa ba bubul wiaa la nyimma yiikoro lɛ la ninii? ");
INSERT INTO sil_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","La dɔŋsuŋ lii Paatia, dɔŋsuŋ lii Miidia, dɔŋsuŋ lii Ilam. La dɔŋsuŋ lii Mesopoteemia, dɔŋsuŋ lii Judiya, dɔŋsuŋ lii Kapadoosia, dɔŋsuŋ lii Pɔŋtɔs, dɔŋsuŋ ma lii Esia. ");
INSERT INTO sil_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","La dɔŋsuŋ lii Firijia, la dɔŋsuŋ lii Paŋfiilia, la dɔŋsuŋ lii Ijipiti, la dɔŋsuŋ ma lii Liibia sɛmɛ dɔŋɔ si kpagɛ taŋ-la ba síi yirɛ Sariini. La dɔŋsuŋ ma ŋaa nuhuɔraa a lii Rom. La dɔŋsuŋ ŋaa Ju̱u tiŋŋaa, la dɔŋsuŋ ŋaa niaa si bi Ju̱u tiŋŋaa ŋaa aŋ tuto Ju̱u tiŋŋaa hariŋ. ");
INSERT INTO sil_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","La dɔŋsuŋ lii Kiriiti, la dɔŋsuŋ lii Ariibia. La kalaa bul yiikoro dabaŋ dabaŋ nɛ, ka la nii di baa bul wiaa la yiikoro lɛ. Wia si tiŋ tiŋtiŋ-duori-la wiaa nɛ ba bubul ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ba kala hiriki, ba tuɔŋ vugimɛ, ba pipiɛsɛ dɔŋɔ, “Bɛɛ kuŋ nɛ ŋla?” ");
INSERT INTO sil_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dɔŋsuŋ ma sisieriba lɛ di ba bugo nɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piita ari Yesu naŋzɔɔba-la fii ari kubala fa si hɛ dimɛ ŋii, Piita sii chiŋ a faasa bul wiaa a bul, “Mi naaŋbiiriŋ Ju̱u tiŋŋaa ari ma nialiŋ kala si hɛ Jerusalɛm lɛ. Má wuoli ma digilaa di mi bul wii-la si ŋaa a pima. ");
INSERT INTO sil_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma biina niaa deeŋba bugo nɛɛ? Ba bi bugo. Chichuɔ-fiɛla deeŋ ba bi jaŋ wuo bugi. ");
INSERT INTO sil_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jowɛl ma fa bul wiiŋ deeŋ si ŋaa wiaa nɛ. U fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. U si, ");
INSERT INTO sil_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Wia si, ŋla nɛ u jaŋ ŋaa tapulaa didɛriŋ: Mi jaŋ joŋ mi Diŋ-zɔŋ-la hɛ nuu-kala lɛ. Ma biiriŋ ari ma toloo jaŋ bul wiaa mi Diŋ-zɔŋ-la doluŋ lɛ. Ma bapuɔsi-biisiŋ ma jaŋ nina wiaa ari duosoo tuɔŋ. Ma kuhiasiŋ ma jaŋ duduosi duosoo. ");
INSERT INTO sil_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chɛɛ-la mi jaŋ joŋ mi Diŋ-zɔŋ-la pi baala-la ari haala-la si ŋaa mi tiŋtinnaa di ba kaa bubul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi jaŋ ŋiŋaa wu-kpuŋkperisiŋ wia nyuŋ, aŋ ŋiŋaa wu-magilaa ma tiŋteeŋ lɛ. Chaliŋ, nyiniŋ ari nyuɔ-bine jaŋ hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Di taŋ nɛ pula maa, leriŋ jaŋ biri. Chɛnɛ ma jaŋ fiɛsɛ a nagɛ chaliŋ, ka di la Tiina tapul-bal-la-na yi. ");
INSERT INTO sil_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tapul-bii-la, nii-la kala si yirɛ la Tiina Wia, u jaŋ laau ta.’ ” ");
INSERT INTO sil_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ŋii nɛ Piita bira bul, “Iziral tiŋŋaa, má jegile nii wiaa deeŋba mi síi chɛ mi bula pima. Yesu si lii Nazarɛt, Wia nɛ timu. Wu-magilaa ari wu-kpuŋkperisiŋ Wia si leŋe u ŋaa ma siiŋ lɛ nɛ dagɛ ŋii. Ma ma jima nɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wia jima aŋ leŋ Yesu juu ma nisiŋ lɛ. Ma nɛ leŋe haachɛ tiŋŋaa kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ u suu. ");
INSERT INTO sil_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ba si kpaasu daa-gɛsɛɛ nyuŋ ŋii u suu, Wia chisu suuŋ lɛ, a liisɛ hɛɛ-la u si na bua-la lɛ u síi suu. Suuŋ fa buu wuo kaa bibil. ");
INSERT INTO sil_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devit fa tiŋ wiiŋ deeŋ wiaa nɛ a bul, ‘Mi yie na mi Tiina. U laa mi sipaaŋ a ŋaa mi hari-chinna, di wii sími juu. ");
INSERT INTO sil_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","U ŋii ŋaa mi tuɔtɔruŋ, mi bubul wiaa ma ari tuɔtɔruŋ. Mi jaŋ na wiese. Mii yiɛlɛ wialiŋ Wia si jaŋ ŋaa lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Di mi nɛ suba, ŋ-na Wia bi jaŋ leŋ di mi hɛ lɛliŋ lɛ. Ŋ bi cho di mi-na ŋ tiŋtinni-titii-la pua. ");
INSERT INTO sil_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ŋ dagɛmi woŋbie-la mi si jaŋ to a kɛŋ miisiŋ. Ŋ si hɛ mi teeŋ jaŋ ŋaa di mi kɛŋ tuɔtɔruŋ woruŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ŋii nɛ Piita bira bul, “Mi naaŋbiiriŋ, mi jaŋ chaasa bul la naabalima Devit wiaa pima. U suba nɛ, ba joŋu hugi, u vaamiŋ ha pina nɛ la jaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","U fa ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ a wuo jiŋ wialiŋ Wia si si u jaŋ ŋaa pu. Wia ŋmiɛsa nɛ a bul duu jaŋ leŋ di Devit doho niaa dɔŋɔ, duu dii kuoruŋ u nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit si na wii-la Wia fa síi chɛ duu ŋaa, u wuo bubul ari Kirisito jaŋ sii suuŋ lɛ, a ma bul di Wia bi jaŋ leŋ duu hɛ lɛliŋ lɛ duu yaraa pua. ");
INSERT INTO sil_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu deeŋ nɛ Wia chisɛ suuŋ lɛ. La kala na a ŋaa wiiŋ deeŋ siada. ");
INSERT INTO sil_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wia chisu u sii a jila hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ, a bira pu u Diŋ-zɔŋ-la ari u fa si bul ŋii. Diŋ-zɔmuŋ deeŋ Yesu si joŋo hɛla lɛ jiniŋ, u nɛ wialiŋ ma síi na a ninii maa. ");
INSERT INTO sil_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit titia fa bi Wia-jaŋ jila, ama u ta bula pa a tigɛ Yesu a bul, ‘La Tiina Wia bula pi mi Tiina duu ku hɔŋ u sɛmɛ, ni-duoŋ di-hɔnuŋ, ");
INSERT INTO sil_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","see duu yuo dii u diŋdɔŋŋɔɔ kala dɛrɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ma Iziral tiŋŋaa, ma jiŋ u sɛnɛ ŋaa wutitii ari Yesu deeŋ ma si kaa kpaasɛ daa-gɛsɛɛ nyuŋ, u nɛ Wia leŋ u ŋaa la Tiina. U nɛ bira leŋ u ŋaa Kirisito maa.” ");
INSERT INTO sil_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nialiŋ si nii wiiŋ deeŋ Piita si bula, u faasa wiwalimɛba kiŋkɛŋ. Ŋii nɛ ba piɛsɛ ba di Yesu naŋzɔɔba-la dɔŋsuŋ, “La naaŋbiiriŋ, bɛɛ kuŋ nɛ saa la jaŋ ŋaa?” ");
INSERT INTO sil_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ŋii nɛ Piita bula piba a bul, “Má birimɛ a lii ma haachɛba lɛ, aŋ leŋ di ba foma Wii-chuɔlɛ liiŋ Yesu Kirisito doluŋ lɛ, di Wia joŋ ma haachɛba chɛma, ka u joŋ u Diŋ-zɔŋ-la a dii zile ma lɛ. Wia fa si si u jaŋ joŋ u Diŋ-zɔŋ-la pi niaa, u tapuluŋ nɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wialiŋ Wia si bula, ma nɛ u bula pa, ma ari ma biiriŋ ari nialiŋ kala si lii di-boluŋ, nuu-na kala Wia si yira duu kɔ u teeŋ.” ");
INSERT INTO sil_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piita si bul ŋii, u sulba a paala chaasa bul wiaa dɔŋsuŋ yugɛ a bul, “Má liisɛ ma titia ni-bɔŋŋɔɔ deeŋba tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba tuɔŋ niaa yuga laa wialaa u si bula dii, ba foba Wii-chuɔlɛ liiŋ. Niaa ma si pɛ nialiŋ lɛ tapulii-la yi bui batori. ");
INSERT INTO sil_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba joŋ ba nyuŋ kala hɛ Yesu naŋzɔɔba-la wu-bulia-la lɛ siifiɛsiŋ a kɛŋ nii-bala. Ba kala hɔnɔ aa dii kudiile-la Yesu fa sí si di baa dii aa liisi u wiaa, aŋ pɛ gbaara chuchuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ŋii nɛ ba kuŋ-kala fifá Wia, Yesu naŋzɔɔba-la ma ŋaa wu-kpuŋkperisiŋ ari wu-magilaa yugɛ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nialiŋ kala si laa wialiŋ dii, ba kala ku hihilimi bua-na kala lɛ, ba kiaa kala ma ŋaa kubala. ");
INSERT INTO sil_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba yie joŋ ba kiaa ma yiyallɛ a kɛŋ moribie-la a kpikpaa dɔŋɔ magɛ ŋii kala nuu-kala síi chɛ. ");
INSERT INTO sil_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tapulii kala ba yie mu hilimi Wia-dia lɛ ari ba diisiŋ ma lɛ, a didii kudiile-la Kirisito fa sí si baa dii a liliisi u wiaa. Baa ŋaa ŋii ari zile ari tuɔtɔruŋ ");
INSERT INTO sil_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","a didɛnnɛ Wia. Niaa ma kala bibɛsɛba lɛ. Tapulii-na kala la Tiina Wia yie laa ni-falaa ta nɛ, ba kuu pɛ Yesu naŋzɔɔba-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tapulii kubala Piita ari Jɔɔŋ sii aa mu Wia-dia. Ba mu dimɛ kerifi batori wiihɛyɛ, bua-la lɛ ba si yie chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Di baal kubala nɛ hɛ dimɛ. U naaŋ lulu duu gbɛrikɛ nɛ. Ba yie chuŋu tapulii-na kala a kaa mu Wia-dia-la boiŋniiŋ kubala baa yirɛ boi-zɔmuŋ. Uu sul kiaa nialaa síi juu Wia-dia-la teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","U si na Piita ari Jɔɔŋ di ba ku juu Wia-dia-la, u sul kiaa ba teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ba beŋ u siaa lɛ. Ŋii nɛ Piita bula pu duu ma bibeŋba. ");
INSERT INTO sil_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ŋii nɛ u bibeŋba aŋ gbɛrɛ kialiŋ ba si jaŋ joŋo pu. ");
INSERT INTO sil_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ŋii nɛ Piita bula pu, “Mi bi moribii kala kɛnɛ mi si jaŋ joŋo piŋ, ama mi jaŋ joŋ ku-la mi si kɛnɛ a piŋ. Yesu Kirisito si lii Nazarɛt doluŋ lɛ mi si, ŋ́ sii a vivɛŋ.” ");
INSERT INTO sil_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","U si bul ŋii, u kɛŋ u na-diiŋ nisiŋ lɛ a kɛnu chuulɛ, u sii. U naasiŋ ari u naachigisiŋ kala guu polli. ");
INSERT INTO sil_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","U fula sii chiŋ u naasiŋ nyuŋ aa vɛŋ, ba juu Wia-dia-la. U vɛŋ aŋ pɛ fuful, a didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nialiŋ kala nau duu vɛŋ aŋ didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba wuo jiŋ u nɛ nii-la fa si yie hɔŋ Wia-dia-la boiŋniiŋ ba síi yirɛ boi-zɔmuŋ aa sul kiaa. Ba hiriki. Wii-la si ŋaa, ŋaaba wu-kpuŋkpere wii. ");
INSERT INTO sil_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ŋii nɛ Piita ari Jɔɔŋ ari gbɛriku-la juu zawura kubala baa yirɛ Solomɔŋ zawura. Gbɛriku-la kɛŋ Piita ari Jɔɔŋ nisaa lɛ, ka niaa kire to ba hariŋ juu. U ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piita si na nialiŋ di baa ŋaa ŋii, u bula piba a bul, “Mi naaŋbiiriŋ Iziral tiŋŋaa, ɛɛ nɛ wiiŋ deeŋ ŋaa wu-kpuŋkpere ma teeŋ, ma paala faasa chaarɛ siaa a bibeŋla ŋla? Ma biina ari la titia doluŋ lɛ nɛ koo la wu-zɔŋŋɔɔ ŋaaniŋ nɛ wuo ŋaa baala deeŋ sii vivɛŋ? Ai. ");
INSERT INTO sil_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wia-la si ŋaa la naabalimaba Abiraham ari Aizik ari Jekɔb Wia, u nɛ joŋ yiri-baliŋ a pi u Bie Yesu. U nɛ ma kaa pa di ba dii u sariya, aŋ bul ma buu jiŋ Paalit sariya diire-la sipaaŋ. U faa biinɛ duu joŋu ta, ka ma bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ma kaa via Wia Tuɔ-pul Tiina, nii-la si ŋaa wu-zɔŋ ŋiŋaara, aŋ susul di ba joŋ ni-kpuura ta, ");
INSERT INTO sil_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","aŋ leŋ ba kpu u-na nii-la síi pi niaa miisi-la si bi dɛrɛ. Ama Wia chisu suuŋ lɛ. La ŋaa wiiŋ deeŋ daŋsia. ");
INSERT INTO sil_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu doluŋ lɛ nɛ ŋaa baala deeŋ ma si na a jimu, u duori. La si ŋaa yarida u doluŋ lɛ nɛ wuo ŋaa ŋii. La si ŋaa u yarida-la nɛ ŋaa baala deeŋ na yarifiɛlaa woruŋ ma kala siiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mi naaŋbiiriŋ, mi jima ma di ma kuhiasiŋ si kpu Yesu ŋii, ma bi jiŋ tuɔŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wia leŋe u nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba bul faafaa kala ari Kirisito-la jaŋ na hɛɛŋ. U sɛnɛ ku ŋaa wutitii ŋla. ");
INSERT INTO sil_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Má birima lii ma haachɛba lɛ aŋ to Wia, duu joŋ ma haachɛba chɛma, ka di Wia leŋ di ma diŋsiŋ na wiese. ");
INSERT INTO sil_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ŋii nɛ ka Wia bira ta Yesu si ŋaa Kirisito, nii-la u si liisa, a pima. ");
INSERT INTO sil_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","U maga duu hɛ Wia-jaŋ, see bua-la yie, wii-kala si hɛ dunia lɛ jaŋ birimɛ wu-falii. Wia leŋe u nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ bul wiiŋ deeŋ faafaa kala nɛ. ");
INSERT INTO sil_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moosis fa hɛ ba tuɔŋ nɛ a ma bul, ‘La Tiina Wia jaŋ leŋ di nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, di ba dɔŋɔ kɔ ma teeŋ ari u si tiŋmi ŋii. U jaŋ ŋaa ma naaŋbii. Duu nɛ kɔ, má saa to u niiŋ wiaa lɛ wii-na kala u si jaŋ bul. ");
INSERT INTO sil_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nii-la kala si bi u niiŋ to, Wia jaŋ leŋ di ba liisu Wia niaa tuɔŋ a ta duu suu.’ ");
INSERT INTO sil_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nialiŋ kala síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, a chiŋ Samuɛl nisiŋ lɛ aa mu nialiŋ kala si to u hariŋ, ba kala fa bul wiaa deeŋba ma síi na ŋla. ");
INSERT INTO sil_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Wialiŋ Wia fa si to u nialiŋ síi bul wiaa u Diŋ-zɔŋ-la doluŋ lɛ a bula pi ma naabalimaba, ba kala ŋaa ma kiaa nɛ, maa naba ŋla. U fa bula pi ma naabalima Abiraham a bul, ‘Ŋ doho niaa dɔŋɔ lɛ nɛ mi jaŋ to a tima pɛ dunia niaa kala lɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ŋii nɛ Wia liisɛ u tiŋtinna Yesu, duu laa sipaaŋ kɔ ma teeŋ a pɛma lɛ, di ma kala birima lii ma wu-bɔŋŋɔɔ ŋaaniŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piita ari Jɔɔŋ fa si bul wiaa pipi nialiŋ ŋii, di nialiŋ si kpu pusuŋ pipi Wia ari Wia-dia kuhiasiŋ ari nialiŋ ba síi yirɛ Sadusii tiŋŋaa, ba kɔ ba teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba fa na baaniŋ a tiŋ wialiŋ ba síi dagɛ. Ba faa dagɛ nialiŋ ari Yesu sii suuŋ lɛ, a dagɛba ŋii ari nuu nɛ suba, u jaŋ bira sii suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ŋii nɛ ba kɛsɛba, a kɛŋba kaa mu tɔ dia, taŋ-pul. (Bua-la ma lɛ di wia ka chɛ duu juu, ŋii nɛ tii ba tɔba taŋ-pul.) ");
INSERT INTO sil_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ka nialiŋ si nii wialiŋ ba si bula, niaa yuga ba tuɔŋ a laa Yesu wiaa dii. Nialiŋ si laa wialiŋ dii, ba tuɔŋ baalaa lɛɛlɛ puŋa yi bui banɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Taŋ si pula, nialiŋ si kpu pusuŋ pipi Wia ari ba Ju̱u tiŋŋaa kuhiasiŋ ari Wia teniŋ kerichiba, ba kala ku hilimi Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ba di nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ Anas ari Kayafas ari Jɔɔŋ ari Alɛkizaŋda, ari nuu-kala si lii nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ doho niaa tuɔŋ nɛ ku hilimi ŋii. ");
INSERT INTO sil_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba si hilimi ŋii, ba yirɛ Yesu naŋzɔɔba-la balia a kaa lii bil ba tutuɔbaaniŋ a piɛsɛba, “Dol bɛɛ yiri nɛ ma kaa ŋaa baala deeŋ duori? Kubɛɛ yiriŋ lɛ nɛ ma yirɛ a ŋaa ŋla?” ");
INSERT INTO sil_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ŋii nɛ Wia Diŋ-zɔŋ-la ku hɛ Piita lɛ woruŋ, u si, “Ma nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ma Ju̱u tiŋŋaa kuhiasiŋ, ");
INSERT INTO sil_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma kɛŋla dii sariya jiniŋ a tiŋ wu-zɔŋ-la la si ŋaa gbɛriku-la lɛ u duori. ");
INSERT INTO sil_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","U maga di ma niaa deeŋba ari Iziral tiŋŋaa kala jiŋ ari Yesu Kirisito si lii Nazarɛt, u doluŋ lɛ nɛ ŋaa baala deeŋ duoro chiŋ ma sipaaŋ ŋii. U nɛ ma leŋ ba kpaasa mɛrɛ daa-gɛsɛɛ nyuŋ u suu, ka Wia chisu suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari tiebii-la dii-saaraa si via, duu nɛ ku ŋaa tiebii-duoŋ ba si joŋo bil dia geŋtine. Ba si ŋmuŋsɛ wiiŋ deeŋ, Yesu wiaa nɛ ba bul ŋii. ");
INSERT INTO sil_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nuu-kala bi jaŋ wuo laala ta, see Yesu duŋduŋa. U yiriŋ duŋduŋa nɛ Wia si la yirɛ duu laala ta. Wia bira bi nuu-kala liisa duu wuo laala ta, see Yesu duŋduŋa.” ");
INSERT INTO sil_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nialiŋ si hilime na Piita ari Jɔɔŋ di baa bul wiaa ari nyu-duoŋ ŋii, u ŋaaba wu-kpuŋkpere, bɛɛ wiaa ba jima ba ŋaa ba tuɔŋ ni-biisiŋ nɛ a bi wii-kala gunna. Ŋii nɛ ba wuo jiŋ ari ba faa to Yesu hariŋ nɛ a gunnɛ u wiaa. ");
INSERT INTO sil_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ka ba na gbɛriku-la Piita ari Jɔɔŋ si vaara, di ba kala china, ba niiŋ kala maa. ");
INSERT INTO sil_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ŋii nɛ ba bula piba di ba lii dia-la tuɔŋ ba fa si hɔnɔɔ vuurɛ wiaa. Ba lii, aŋ ka ba pipiɛsɛ dɔŋɔ, “Ɛɛ nɛ la jaŋ kɛŋ niaa deeŋba balia kaa ŋaa? ");
INSERT INTO sil_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nuu-kala si hɛ Jerusalɛm lɛ nɛ jima ari ba nɛ ŋaa wu-baliŋ deeŋ, la saa bi wuo kaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama má leŋ di la kpurisɛ ba digilaa di ba bira sí Yesu yiriŋ yiru, a bira sí u wiaa bula pi niaa, di wiiŋ deeŋ bira sí leriŋ deeŋ kala teelu.” ");
INSERT INTO sil_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ŋii nɛ ba bira yirɛba kaa juu, a bula piba ari siifiɛsiŋ di ba bira sí wii-kala bul, koo di ba sí wii-kala dagu a tigɛ Yesu lɛ, a bira sí u yiriŋ yiru. ");
INSERT INTO sil_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ŋii nɛ Piita ari Jɔɔŋ piɛsɛba, “La si to ma niiŋ koo la si to Wia niiŋ, kubɛɛ nɛ zɔmɔ Wia teeŋ? Má bul. ");
INSERT INTO sil_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","La bi jaŋ wuo tɔrɛ la niiŋ, see di la bul wialaa la si na a nii maa.” ");
INSERT INTO sil_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ŋii nɛ ba bira fugisiba woruŋ ari ba jaŋ dɔgisɛba woruŋ aŋ joŋba ta. Ba bi woŋbiiŋ na di ba dɔgisɛba, bɛɛ wiaa nialiŋ kala ka dɛnnɛ Wia a tigɛ wii-la si ŋaa lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Baala deeŋ ba fa si ŋaa wu-kpuŋkpere deeŋ u lɛ u duori, u fa kii jisiŋ mahiŋ balia nɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba si joŋba ta, Piita ari Jɔɔŋ miira mu ba naaŋbiiriŋ teeŋ, ba di ba fa si yie hilimi, a bula piba wialiŋ kala nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ fa si bula piba. ");
INSERT INTO sil_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba si nii ŋii, ba suomo chuchuɔlɛ Wia ari tuɔ-bala a bul, “La Tiina Wia, ŋ nɛ ta wia nyuŋ ari tiŋteeŋ ari mugi-balaa ari fuo-biisiŋ ari kuŋ-kala si hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ŋ Diŋ-zɔŋ-la doluŋ lɛ ŋ wuo leŋ la naabalima Devit, ŋ tiŋtinna, u bul, ‘Bɛɛ nɛ tii nialiŋ si bi Ju̱u tiŋŋaa ŋaa, ba faasa na baaniŋ? Bɛɛ nɛ tii nialiŋ vuurɛ di ba jaŋ chei Wia tiŋtiŋŋaa aŋ lɔl? ");
INSERT INTO sil_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tiŋteeŋ kuoroo kɛŋ ba titia hɛ dɔŋɔ lɛ a ŋaa siri, ba taŋ kuhiasiŋ, ba ma hilimi di ba yuo la Tiina Wia ari Kirisito, nii-la u si liisa.’ ");
INSERT INTO sil_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wiaa deeŋba sɛnɛ ku ŋaa wutitii. Hɛrɔd ari Pɔŋsɔs Paalit ari nialiŋ si bi Ju̱u tiŋŋaa ŋaa ari Iziral tiŋŋaa, ba kala hilime nɛ taŋ deeŋ lɛ di ba yuo Yesu, ŋ tiŋtinni-zɔŋ-la ŋ si liisa duu ŋaa Kirisito. ");
INSERT INTO sil_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba hilime di ba ŋaa wialiŋ kala ŋ si paala jiŋ ŋ doluŋ ari ŋ tuɔbiinaa lɛ ari ba jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","La Tiina Wia, bee na ba si kpurisɛ la digilaa ŋii ari ba jaŋ dɔgisɛla, aŋ pɛ ŋ tiŋtinnaa lɛ di la wuo bul ŋ niiŋ wiaa ari nyu-duoŋ. ");
INSERT INTO sil_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dagɛ ŋ doluŋ aŋ leŋ di puwuoloo duori, di la ma wuo ŋiŋaa wu-kpuŋkperisiŋ ari wu-magilaa ŋ tiŋtinni-zɔŋ-la Yesu doluŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba si chuɔlɛ Wia dɛrɛ, lee-la ba si hilime jigisi. Wia Diŋ-zɔŋ-la ku hɛba kala lɛ. Ba suomo bubul Wia niiŋ wiaa ari nyu-duoŋ. ");
INSERT INTO sil_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nialiŋ kala fa si laa Yesu wiaa dii, ba kala kɛŋ tuɔ-bala ari nii-bala. Di nuu nɛ kɛŋ kuŋ maa, u bi jaŋ bul, “Na mi kuŋ nɛ ŋla”, ba kala nɛ yie tiiu. ");
INSERT INTO sil_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wia lahɔrimɔ-bal-la nɛ tii Yesu naŋzɔɔba-la wuo na doluŋ a bulaa pi niaa di la Tiina Yesu sii suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wia pɛ nialiŋ kala si laa Yesu wiaa dii kala lɛ woruŋ. Nialiŋ kala fa si kɛŋ diisiŋ ari bagisiŋ, ba yie joŋo yallɛ, a kɛŋ moribie-la ba si na ");
INSERT INTO sil_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a kaa mu Yesu naŋzɔɔba-la teeŋ. Ba kpaa magɛ ŋii kala nuu-kala síi chɛ. Ŋii wiaa ba nialiŋ kuŋ-kala fa bi kuŋ chɛɛ ka. ");
INSERT INTO sil_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Baal kubala ma nɛ fa hɛ dimɛ, baa yirɛ Josɛf. Yesu naŋzɔɔba-la ma kɛnu kaa yiyirɛ Banabas. (U bubuɔŋ nɛ, u fa yie bul wiaa pi niaa ba nyusuŋ nyinyaasɛ.) U fa ŋaa Liivai doho nuu nɛ a lii Saapɔs tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","U nɛ joŋ u baga u fa si kɛnɛ a yallɛ, a kɛŋ moribie-la kaa mu Yesu naŋzɔɔba-la teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ama ba tuɔŋ baal kubala nɛ fa hɛ dimɛ. Baa yirɛ Ananaya. U haala ma yiriŋ nɛ fa Safaya. U joŋ u dua a yallɛ ");
INSERT INTO sil_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","a liisɛ moribie-la dɔŋsuŋ faa, u haala jiŋ, aŋ kɛŋ ku-kaana-la kaa mu Yesu naŋzɔɔba-la teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piita piɛsu, “Ananaya, bɛɛ nɛ tii ŋ leŋ Sitaani nyisiŋ, ŋ joŋ tiŋtee-la ŋ si yalla moribie-la dɔŋsuŋ faa, aŋ nyia wiaa pi Wia Diŋ-zɔŋ-la? ");
INSERT INTO sil_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ka ŋ-na joŋ ku-la yallɛ, ŋ dee buu tii? Moribie-la maa ŋ si yalla, ŋ dee biba tii? Bɛɛ nɛ saa tii ŋ biinɛ ŋ tuɔŋ lɛ aŋ ŋaa wiiŋ deeŋ? Nuhuobiinee duŋduŋa dee ŋ nyia wiaa pa, ŋ nyia wiaa pi Wia ma nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaya si nii wiiŋ deeŋ, u tuu tele suu. Fawulluŋ kɛŋ nialiŋ ma kala si hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bapuɔsaa joŋ gɛriŋ laalu a joŋu kaa lii a kaa mu hugi. ");
INSERT INTO sil_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","U yi hawa batori di u haala ku juu. U fa bi jiŋ wii-la kala si ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piita piɛsu, “Moribie-la ŋ bala si kaa kɔ, magɛ ŋii nɛ ma joŋ ma tiŋtee-la yallɛ koo?” Ŋii nɛ haal-la bul di ba niiŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ŋii nɛ Piita piɛsu, “Bɛɛ nɛ tii ma di ŋ bala vuurɛ di ma nyisɛ Wia Diŋ-zɔŋ-la, a biinɛ u bi jaŋ dɔgisɛmaa? Bee na, nialiŋ si joŋ ŋ bala mu hugi, ba nɛ chiŋ boiŋniiŋ ŋii. Ba saa jaŋ joŋuŋ ma lii.” ");
INSERT INTO sil_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","U guu tel u sipaaŋ a suu. Bapuɔsia-la si joŋ u bala kaa mu hugi, ba ku juu duu suba. Ŋii nɛ ba joŋu kaa lii, a hugu a kpɛrɛ u bala. ");
INSERT INTO sil_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nialiŋ kala si laa Yesu wiaa dii aa hilimi ari nialiŋ dɔŋsuŋ ma si nii wii-la, fawulluŋ kɛŋba woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu naŋzɔɔba-la ŋaa wu-magilaa ari wu-kpuŋkperisiŋ yugɛ niaa tuɔŋ. Nialiŋ kala si laa Yesu wialiŋ dii, ba kala hilimi dɔŋɔ lɛ ari nii-bala. Zawura-la ba si kaa yirɛ Solomɔŋ zawura, u lɛ nɛ ba hilimi. ");
INSERT INTO sil_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuu-kala si bi Yesu wialiŋ laa dii bi nyu-duoŋ kɛnɛ duu guoli ba tuɔŋ. Ari ŋii kala, ka ba ha bibɛsɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nialiŋ si laa Yesu wialaa dii a ku pɛ nialiŋ lɛ, ba kii nialiŋ kala Wia fa si vɛnɛ kaa kuu pɛ, baalaa ari haalaa. ");
INSERT INTO sil_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A tiŋ wialiŋ kala síi ŋaa lɛ, ba paala paa puwuoloo kaa lii woŋbiiŋ niiŋ, a bilba godoba lɛ ari bɔsunuŋ lɛ. Ba ŋaa ŋii di Piita nɛ kuu bal, duu daaliimiŋ wuo hɛ ba dɔŋsuŋ lɛ di ba duori. ");
INSERT INTO sil_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Niaa ma yuga a lii ta-biisi-la si kpagɛ Jerusalɛm, a kɛŋ puwuoloo ari nialiŋ jiŋ-bɔŋŋɔɔ si kɛnɛ a kaa kɔ u teeŋ, ba kala duori. ");
INSERT INTO sil_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ ari u haritooroo sii. U haritooro-la kala hɛ Sadusii tiŋŋaa paati-la tuɔŋ nɛ Jerusalɛm lɛ. Ba yaraa faasa bibieri. ");
INSERT INTO sil_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba kɛsɛ Yesu naŋzɔɔba-la kaa mu tɔ dia, lee-la ba síi tɔ ba niaa. ");
INSERT INTO sil_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama titaŋ-la titia Wia tiŋdaara kubala ku kɛŋ dia-la boiŋniiree suri, a leŋ Yesu naŋzɔɔba-la lii. Ka u bula piba, ");
INSERT INTO sil_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Má mu juu chiŋ Wia-dia lɛ a bula pi niaa woŋbii-faliŋ deeŋ wiaa.” ");
INSERT INTO sil_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesu naŋzɔɔba-la sɛi. Siipuuraa ba juu Wia-dia a suomo didagɛ niaa. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ ari u naŋdɔŋsuŋ, ba yirɛ Ju̱u tiŋŋaa kuhiasiŋ ari ba niaa kala di ba hilimi a vuurɛ, aŋ tiŋ di ba mu dia-la lɛ a kɛsɛ Yesu naŋzɔɔba-la kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nihiasi-la si mua, ba biba na sarika lɛ. Ba miira ku bul, ");
INSERT INTO sil_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“La si mu sarika-la, la na di ba yaga, nuu-kala bi suro, ka nialiŋ síi beŋ sarika-la, ba ma chiŋ boiŋniiŋ. Ama la mu suri, la bi Yesu naŋzɔɔba-la naa.” ");
INSERT INTO sil_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wia-dia nihiaŋ ari nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ si nii wiiŋ deeŋ, u kperiba kiŋkɛŋ, ba bi jiŋ wii-la kala ba si jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ŋii nɛ baal kubala ku juu a bula piba di ba bee na nialiŋ ba si kaa tɔ dia, ba nɛ chiŋ Wia-dia tuɔŋ a didagɛ niaa. ");
INSERT INTO sil_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ŋii nɛ Wia-dia nihiaŋ ari u niaa, ba mu kɛsɛba kaa kɔ. Fawulluŋ fa kɛŋba nɛ ari nialiŋ fa si hɛ Wia-dia-la tuɔŋ jaŋ paa tabiaa yagɛba, ŋii nɛ tii ba bi Yesu naŋzɔɔba-la fuga. ");
INSERT INTO sil_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ba kɛŋba kaa ku juu, a leŋ ba chiŋ nialiŋ si yie hilime vuvuurɛ wiaa sipaaŋ. Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ bula piba, ");
INSERT INTO sil_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“La bula pima ari siifiɛsiŋ ari ma bira sí wii-kala dagu Yesu doluŋ lɛ. Ama ma bee na, ma kɛŋ wii-la kaa gaara cheŋ Jerusalɛm kala aa chɛ ma joŋ taali chugɛla a tiŋ baala deeŋ suuŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piita ari Yesu naŋzɔɔba-la dɔŋsuŋ miira bula piba a bul, “U maga di la to Wia niiŋ nɛ a kii nuhuobiine niiŋ. ");
INSERT INTO sil_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","La naabalimaba faa to Wia nɛ, u nɛ chisɛ Yesu suuŋ lɛ, nii-la ma fa si kaa kpaasɛ daa-gɛsɛɛ nyuŋ u suu. ");
INSERT INTO sil_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wia chisu u sii jila hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ, duu ŋaa Sipaa-laara ari Laataara, a leŋ di Iziral tiŋŋaa birima lii ba haachɛba lɛ, ka duu joŋ ba haachɛba chɛba. ");
INSERT INTO sil_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","La ŋaa wiaa deeŋba kala daŋsia ari Wia Diŋ-zɔŋ-la maa, Wia si joŋo pi nialiŋ si to u niiŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nialiŋ si nii wiiŋ deeŋ, ba faasa na baaniŋ a chichɛ di ba kpuba. ");
INSERT INTO sil_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Baal kubala ma nɛ fa hɛ nialiŋ si yie hilime vuvuurɛ wiaa tuɔŋ. U lii Farisii tiŋŋaa tuɔŋ nɛ. Baa yirɛ Gamiilial. U nɛ faa dagɛ wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto. Nuu-kala pupu jirima. U sii chiŋ a bul di ba leŋ di Yesu naŋzɔɔba-la lii di-jaliŋ muapilii. ");
INSERT INTO sil_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ka u sii a bula piba, “Ma Iziral timma, má fiɛlɛ ma siaa ari ma síi ŋaa wii-la niaa deeŋba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jisiŋ deeŋba nɛ, baal kubala nɛ fa hɛ dimɛ. Baa yirɛ Tuudas. U bula ari u ŋaa ni-bal nɛ. Niaa yi ari zɔ-banɛsɛ a pɛu lɛ. Ba kpuu, ka u haritooro-la kala pisɛ dɔŋɔ lɛ, u yiri-la kala disɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","U hariŋ lɛ nɛ, baal kubala ma lii, bua-la lɛ ba síi diisɛ niaa, baa yirɛ Judas. U lii Galilii nɛ. U kɛsɛ ni-daŋ a kaa to u hariŋ. Ba kpuu maa, ni-daŋ-la ma síi to u hariŋ, ba ma pisɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ka lɛɛlɛ wiiŋ deeŋ, mi jaŋ bula pima di ma sí wii-kala ŋaa niaa deeŋba lɛ, aŋ leŋba ta. Di tiŋtimiŋ deeŋ lii nuhuobiine doluŋ lɛ nɛ, u jaŋ lɛl. ");
INSERT INTO sil_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama di Wia tiŋtimii nɛ, ma bi jaŋ wuo cheyu. Di ma nɛ chɛ di ma cheyu, ma jaŋ na di ma di Wia paala yuyuo dɔŋɔ.” ");
INSERT INTO sil_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ŋii nɛ ba jegile nii u niiŋ. Ba yirɛ Yesu naŋzɔɔba-la ba ku juu, a ŋaa ba viirɛba, aŋ bula piba di ba bira sí wiaa bul Yesu doluŋ lɛ, aŋ leŋ ba viiri. ");
INSERT INTO sil_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ŋii nɛ ba lii nialiŋ fa si hilime teeŋ. Ba tuɔŋ tɔrɛ ari ba si dɔgisɛba a tiŋ Yesu wiaa lɛ. ");
INSERT INTO sil_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tapulii-na kala ba yie juu Wia-dia a pɛɛ mu niaa diisiŋ, a ha bubul Wia wu-zɔmɔ-la a mu tigɛ Yesu Kirisito lɛ. ");
INSERT INTO sil_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tapulaa deeŋba Yesu haritooro-la ku puŋa yugɛ. Ŋii nɛ ba tuɔŋ Giriik tiŋŋaa suomo nyinyaŋ Hiiburu tiŋŋaa. Ba bula ari ba si yie joŋ moribie-la a pipi yo-haalaa tapulii kala, ba yie bee kikieli ba-na yo-haalaa nɛ. ");
INSERT INTO sil_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ŋii nɛ Yesu haritooro-la fii ari balia yirɛ nialiŋ kala si laa Yesu wiaa dii a hilimi, a bula piba a bul, “U bi maga di la bibeŋ moribiee aŋ ka Wia wiaa ta. ");
INSERT INTO sil_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mi naaŋbiiriŋ, má liisɛ ma tuɔŋ niaa balipɛ ma si jima di niaa ka zilba, ka Wia Diŋ-zɔŋ-la hɛba lɛ aŋ kɛŋ wu-jimiŋ maa. Má liisɛba di ba bibeŋ yo-haalaa deeŋba. ");
INSERT INTO sil_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ka la joŋ la nyuŋ kala hɛ aa chuɔlɛ Wia aŋ pɛɛ bul Wia niiŋ wiaa.” ");
INSERT INTO sil_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ŋii nɛ nialiŋ kala si hɛ dimɛ tuɔsaa kala tɔrɛ ari wialiŋ Yesu haritooro-la si bula. Ba liisɛ baal kubala baa yirɛ Sitiiviŋ. U fa ŋaa baal-la si kɛŋ yarida woruŋ nɛ. Wia Diŋ-zɔŋ-la ma hɛu lɛ. Ba bira liisɛ Filip ari Purɔkurɔs ari Nikeeno ari Taamɔŋ ari Paaminas ari Nikɔlas. Nikɔlas lii Aŋtiɔk nɛ. U fa bi Ju̱u tiina ŋaa aŋ tuto Ju̱u tiŋŋaa hariŋ. ");
INSERT INTO sil_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ŋii nɛ ba kɛŋ nialiŋ balipɛ-la ba si liisa a kaa mu Yesu naŋzɔɔba-la sipaaŋ. Ba chuɔlɛ Wia piba aŋ joŋ ba nisaa daŋba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wia niiŋ wiaa ha gaara su̱ lee-la kala. Nialiŋ si laa Yesu wiaa dii puŋ woruŋ Jerusalɛm lɛ. Nialiŋ ma si kpu pusuŋ pipi Wia yuga a ma sɛi Wia niiŋ wialiŋ. ");
INSERT INTO sil_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wia lahɔrimɔ lɛ Sitiiviŋ kɛŋ doluŋ woruŋ, a wuo ŋiŋaa wu-kpuŋkperisiŋ ari wu-magilaa niaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Niaa dɔŋsuŋ fa hɛ dimɛ. Ba fa ŋaa Ju̱u tiŋŋaa nɛ a lii Sariini, dɔŋsuŋ ma lii Alɛkizaŋdia. Ba fa lii Wii-chuɔlɛ dia-la ba fa síi yirɛ ‘yosuŋ ba si joŋo ta’. Dɔŋsuŋ ma fa ŋaa Ju̱u tiŋŋaa a ma lii Siliisia ari Esia. Ba lii Sitiiviŋ hariŋ a kɛŋ wiaa lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama ba fa bi u bubuɔŋ lɛ wuo kɛŋ a tiŋ u wu-jimiŋ ari Wia Diŋ-zɔŋ-la doluŋ lɛ u fa síi bul wiaa. ");
INSERT INTO sil_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ŋii nɛ ba luɔra hɛ niaa, ba bul, “La nia duu chei Moosis ari Wia yiriŋ.” ");
INSERT INTO sil_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba bul ŋii a nyisɛ nialiŋ ari nihiasi-la ari Wia teniŋ kerichiba hɛ. Ba baaniŋ sii Sitiiviŋ nyuŋ. Ba kɛnu kaa mu nihiasi-la si yie hilime vuvuurɛ wiaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba kɛŋ niaa kaa kɔ di ba ku nyia wiaa pu a bul, “Baala deeŋ yie ku bul wiaa aa chei Wia-dia-la ba si joŋo pi Wia, ari wialiŋ Moosis si ŋmuŋsa bil di la tuto. U yie bul ŋii, u bi tɔrɛ, ");
INSERT INTO sil_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","bɛɛ wiaa la nia duu si di Yesu deeŋ si lii Nazarɛt jaŋ yigi Wia-dia-la lo, a kɛŋ wialiŋ Moosis fa si dagɛ la naabalimaba di ba tuto a kaa birimɛ.” ");
INSERT INTO sil_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nialaa kala fa si hɔŋ lee-la, ba chaarɛ siaa a pɛ Sitiiviŋ lɛ. Ba na duu siaa nagɛ Wia tiŋdaara siaa. ");
INSERT INTO sil_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ piɛsɛ Sitiiviŋ di wiaa deeŋba ŋaa wutitii nɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiiviŋ bul, “Mi nyimmaba ari mi naaŋbiiriŋ, má jegile nii mi teeŋ. Wii-baliŋ si kɛŋ yiriŋ kɛŋ u titia ku dagɛ la naabalima Abiraham, bua-la lɛ u fa si hɔŋ Mesopoteemia tiŋteeŋ lɛ, di u ha bi taŋ-la ba síi yirɛ Haraŋ lɛ mu hɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ŋii nɛ Wia bula pu duu sii a leŋ u dia niaa, a lii u tiŋteeŋ ma lɛ, a mu tiŋtee-la u si jaŋ dagu. ");
INSERT INTO sil_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ŋii nɛ u sii lii Kalidiya tiŋteeŋ lɛ a mu hɔŋ taŋ kubala baa yirɛ Haraŋ lɛ. Dimɛ nɛ Abiraham nyimma suu. Ŋii nɛ Wia leŋ u sii lee-la a kɔ tiŋteeŋ deeŋ ma niaa deeŋba si hɔnɔ lɛɛlɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bua-la lɛ Wia bi lee-la kere pi Abiraham a yi naakieliŋ kubala maa, duu titia kɛŋ, ama u bula pu duu jaŋ joŋo pu, ba di u doho niaa. Bua-la lɛ Wia si bul ŋii Abiraham lɛ duu ha bi bii lula. ");
INSERT INTO sil_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ŋla nɛ Wia bula pu, ‘Ŋ doho niaa jaŋ ŋaa nuhuɔraa tiŋteeŋ dɔŋɔ lɛ, a birimɛ yosuŋ. Ba jaŋ dɔgisɛba woruŋ jisiŋ zɔ-banɛsɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mi saa jaŋ kɛŋ nialiŋ ba si jaŋ tima pipa dii sariya. Ŋii hariŋ lɛ ba jaŋ lii lee-la lɛ, a bira kɔ daha a chuchuɔlɛmi.’ ");
INSERT INTO sil_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ŋii nɛ Wia joŋ u niiŋ a pi Abiraham. U magiliŋ nɛ, ba di u doho niaa kikeri ba penee. Ŋii nɛ Abiraham lul Aizik. Tapul-chorimuŋ chɛɛŋ u keri u peniŋ. Aizik ma lul Jekɔb. Jekɔb nɛ lul biiriŋ fii ari balia-la si ku ŋaa la naabalimaba. ");
INSERT INTO sil_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ba tuɔŋ dɔŋɔ yiriŋ nɛ Josɛf. Ku-kaana-la yaraa bibieri u nyuŋ, ba kɛnu kaa yallɛ pi baalaa kubalaba. Ba kɛnu kaa mu Ijipiti tiŋteeŋ. Ama Wia fa pɛu lɛ woruŋ ");
INSERT INTO sil_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a liisu wahala kala lɛ u fa si jua. U fa si mu Feero Ijipiti kuoro sipaaŋ, Wia lahɔrimɔ lɛ u kɛŋ wu-jimiŋ. U leŋ u ŋaa u tiŋteeŋ kuhiaŋ a bibeŋ u tiŋteeŋ ari u dia kala. ");
INSERT INTO sil_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ŋii nɛ losuŋ ku juu Ijipiti tiŋteeŋ ari Keenaŋ tiŋteeŋ kala. Losuŋ kpu niaa kiŋkɛŋ, la naabalimaba bi kudiilee wuo na. ");
INSERT INTO sil_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekɔb nia ari kudiilee hɛ Ijipiti tiŋteeŋ lɛ. U tiŋ u biiriŋ, la naabalimaba-la, di ba mu yɔɔ kaa kɔ. Ba yɔɔ kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jekɔb biiriŋ miira mu Ijipiti liamiŋ lɛ di ba yɔɔ kudiilee. Ŋii nɛ Josɛf kɛŋ u titia dagɛba, aŋ kɛŋba ma dagɛ Feero. ");
INSERT INTO sil_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ŋii nɛ Josɛf tiŋ di ba mu bula pi u nyimma Jekɔb, duu kɛŋ u doho niaa kala kaa kɔ Ijipiti, ba kala fa ŋaa mahiŋ batori ari fii ari banɔŋ nɛ a mu Ijipiti. ");
INSERT INTO sil_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ŋii nɛ Jekɔb sii a mu Ijipiti. Ba di u biiriŋ suu dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba miira kɛŋba kaa mu Keenaŋ tiŋteeŋ a hugiba lee kubala baa yirɛ Sɛkɛm. Ba hugiba bua kubala lɛ Abiraham fa si yɔbɔ Hamɔ niaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","U ka mua, ka di wii-la-na ku bal, Wia fa si bula pi Abiraham ari u jaŋ ŋaa pu. Bua-la lɛ Jekɔb doho niaa fa puŋa woruŋ Ijipiti lɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kuoru-la fa si jiŋ Josɛf suba, aŋ ka ni-tanii dii kuoruŋ Ijipiti lɛ. U fa bi Josɛf wiaa jiŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","U nyisɛ niaa kiŋkɛŋ a dɔgisɛba, a fugɛ la naabalimaba di ba joŋ ba bii-mulluŋ kaa lii ta di ba suu. ");
INSERT INTO sil_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Bua-la lɛ nɛ ba fa lul Moosis. U fa ŋaa bii-zɔŋ-bie nɛ woruŋ. Ba benu u nyimma dia lɛ chɛŋsiŋ batori, aŋ ka ba joŋu kaa lii ta. ");
INSERT INTO sil_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba si joŋu kaa lii ta ŋii, Feero tolo ku joŋu, a diɛsu ari u bii-lulluŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba dagu Ijipiti tiŋŋaa wu-jimiŋ kala. U wu-ŋaalaa ari u wu-bulaa leŋ u ŋaa ni-bal. ");
INSERT INTO sil_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moosis fa si yi jisiŋ mahiŋ balia, u biinɛ ari u jaŋ mu na u naaŋbiiriŋ Iziral tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","U si mu dimɛ, u na Ijipiti tiina duu dɔgisɛ Iziral niaa dɔŋɔ. U mu lii paa Iziral tiina-la tuɔruŋ, a kpu Ijipiti tiina-la. ");
INSERT INTO sil_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U fa biina ari u naaŋbiiriŋ jaŋ jiŋ ari Wia chɛ duu nɛ laaba ta, ama ba fa bi wuo jiŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Taŋ si pula, u na di Iziral niaa balia, baa yuo dɔŋɔ. U mu duu kɛŋba hɛ dɔŋɔ lɛ a bul, ‘Ma ŋaa naaŋbiiriŋ nɛ, bɛɛ nɛ tii ma gura dudɔgisɛ dɔŋɔ?’ ");
INSERT INTO sil_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nii-la fa síi dɔgisɛ u dɔŋɔ tiina-la kɛŋ Moosis yige ta aŋ bul, di kubɛɛ nɛ si u bibeŋba a laa ba wiaa jijiŋ? ");
INSERT INTO sil_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Duu chɛ duu kpuu maa, ari u dia si kpu Ijipiti tiina-la ŋii nɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moosis si nii ŋii, u fá Ijipiti tiŋteeŋ lɛ a mu ŋaa nuhuɔru Midiaŋ tiŋteeŋ lɛ. U hɔŋ dimɛ nɛ a jaa haala, a lul biiriŋ balia. ");
INSERT INTO sil_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","U fa hɔŋ dimɛ jisiŋ mahiŋ balia. Ŋii nɛ Wia tiŋdaara kubala ku lii u teeŋ giri-bine tuɔŋ a kpagɛ peel kubala baa yirɛ Saana. U ku lii a nagɛ tii-bie síi dii nyiniŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moosis si na ŋii, u ŋaau wu-kpuŋkpere. U mu yi duu na tii-bie-la, a nii la Tiina Wia yiikoro. U bula pi Moosis a bul, ");
INSERT INTO sil_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mi nɛ ŋaa ŋ naabalimaba Abiraham ari Aizik ari Jekɔb Wia.’ U si bul ŋii, Moosis china chichel. U bira bi wuo bibeŋ.” ");
INSERT INTO sil_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sitiiviŋ bira bul, “Ŋii nɛ la Tiina Wia bula pi Moosis a bul, ‘Chaarɛ ŋ nɛŋtɛŋŋɛɛ ŋ naasiŋ lɛ. Wia hɛ lee-la ŋ si china nɛ. U wasɛ lee-la kala a ta. U bi disinniŋ kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi na ba síi dɔgisɛ mi niaa ŋii nɛ Ijipiti lɛ, a nii ba síi yel maa, a ku tuu di mi laaba ta. Sii lɛɛlɛ, mi timiŋ di ŋ miira mu Ijipiti.’ ” ");
INSERT INTO sil_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ŋii nɛ Sitiiviŋ bira suomi aa bul, “Moosis deeŋ nɛ ba via aŋ piɛsu, ‘Kubɛɛ nɛ ŋaa ŋ bibeŋla a laa la wiaa jijiŋ?’ U nɛ Wia tiŋ u ŋaa ma kuhiaŋ ari ma laataara. Wia nɛ to Wia tiŋdaari-la fa si ku lii Moosis teeŋ a nagɛ tii-bie-la si dii nyiniŋ tuɔŋ, a pɛu lɛ duu laa u niaa tita. ");
INSERT INTO sil_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moosis ŋaa wu-magilaa ari wu-kpuŋkperisiŋ Ijipiti lɛ, aŋ-na kɛsɛ u niaa lii Ijipiti tuɔŋ, a kɛŋba to mugi-bal kubala baa yirɛ Mugi-fiaŋ. Ba to giriŋ maa jisiŋ mahiŋ balia, a pɛɛ ŋaa wu-kpuŋkperisiŋ ari wu-magilaa woŋbiiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moosis deeŋ nɛ bula pi Iziral niaa a bul, ‘Wia jaŋ leŋ di nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, di ba dɔŋɔ kɔ ma teeŋ ari u si tiŋmi ŋii. U jaŋ ŋaa ma naaŋbii.’ ” ");
INSERT INTO sil_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ŋii nɛ Sitiiviŋ bira suomo bubul, “Moosis ari la naabalimaba nɛ fa hilimi giri-bine tuɔŋ. Dimɛ nɛ u na Wia tiŋdaara ma peel kubala nyuŋ baa yirɛ Saana. U joŋ Wia niiŋ wialaa si kɛŋ miisiŋ pu duu laa bula pila. ");
INSERT INTO sil_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","La naabalimaba via u niiŋ aŋ joŋ ba hariŋ yia, ba tuɔbiinaa kala fa cho di ba fa miira mu Ijipiti. ");
INSERT INTO sil_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ŋii nɛ ba bula pi Ɛrɔŋ a bul, ‘Mɛ vesiŋ pila di ba laa la sipaaŋ. Moosis deeŋ si kɛŋla lii Ijipiti tiŋteeŋ lɛ a kɛŋla kɔ daha, la bi jiŋ wii-la kala si ŋaau lɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ŋii nɛ ba mɛ vene a nagɛ nɛ-bie a kpaaru. Ba tuɔŋ tɔrɛ ku-la lɛ ba titia si mɛɛ. ");
INSERT INTO sil_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wia joŋ hariŋ yiaba a joŋba ta ba chuchuɔlɛ chɛŋwulaa ari chɛnɛ ari wii-pɔsuŋ. Ba ŋmuŋsɛ ŋii nɛ Wia teŋ-la sɛmɛ dɔŋɔ nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, si ŋmuŋsa. Ba dɔŋɔ ŋmuŋsa a bul, Wia si, ‘Ma Iziral timma, bua-la lɛ ma fa si hɛ giri-bine-la lɛ jisiŋ mahiŋ balia-la, mi-na dee ma fa kpu pusuŋ pa. ");
INSERT INTO sil_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma vesiŋ nɛ ma kpikpaarɛ. Ma vene ba síi yirɛ Mɔlɔk, u lɛbiŋ nɛ ma kaa chuŋaa vɛŋ, a chuŋ ma chɛŋwuluŋ vene maa, vene-la ba síi yirɛ Rɛfaŋ u magiliŋ nɛ. Kiaa deeŋba nɛ ma mɛ a chuchuɔlɛ. Ŋii nɛ tii mi jaŋ leŋ ba kɛŋma kaa mu di-bolii, a kieli Babilɔŋ a mu.’ ” ");
INSERT INTO sil_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ŋii nɛ Sitiiviŋ bira bul, “La naabalimaba fa si hɛ giri-bine tuɔŋ, ba kɛŋ lɛbi-la ba fa si hɛ pi Wia. Wia nɛ fa dagɛ Moosis duu ŋaa. U dagɛ u nagisiŋ kala u si jaŋ ŋaa duu nagɛ. Moosis ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Niaa deeŋba suba nɛ, ka la naabalimaba laa lɛbiŋ deeŋ ba nyuŋ lɛ a chuŋ. Ba di Jɔsua juu tiŋteeŋ dɔŋɔ. Nialiŋ fa si tii tiŋtee-la, ba fa bi Wia ka to. Wia pɛ la naabalimaba deeŋba lɛ ba yuo kiri nialiŋ, aŋ laa tiŋtee-la tii. Lɛbi-la fa hɛ ba teeŋ, ŋii nɛ deeŋ deeŋ, Devit, la naabalima, ku yiu. ");
INSERT INTO sil_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wia lahɔrimɔ-la lɛ u sul Wia duu leŋ duu saa dia pu, u-na Wia-la u naabalima Jekɔb fa síi to. ");
INSERT INTO sil_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Devit dee bi dia-la saa, Solomɔŋ nɛ miira saa a pi Wia. ");
INSERT INTO sil_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ka Wia si kii kuŋ-kala, u bi diisi-la nuhuobiinee si saa duŋduŋa nɛ ka juu. Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba dɔŋɔ nɛ fa bul ŋii. U si, ");
INSERT INTO sil_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Wia si, Wia-jaŋ lɛ nɛ mi kuori-kpasa hɛ, tiŋteeŋ nɛ ŋaa mi naasiŋ di-biliŋ. Dii bɛɛ nɛ saa ma jaŋ saa pimi? Mi di-wiesiŋ hɛ nii? ");
INSERT INTO sil_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kiaa deeŋba kala, mi dee bi ŋaa?’ ” ");
INSERT INTO sil_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ŋii nɛ Sitiiviŋ bul, “Ma nyuŋ dolie kiŋkɛŋ. Ma digilaa ma kparimɛ. Ma kɛŋ nyu-duoŋ ari nialiŋ si bi Wia ka to. Ma ma yie via ma to Wia Diŋ-zɔŋ-la lɛ, ari ma naabalimaba fa si ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba tuɔŋ kuŋ-kala tuo ma naabalimaba si bi naasiŋ to dɔgisɛ. Ba fa kpu nialaa si laa sipaaŋ paala bul di Wia Tuɔ-pul Tiina jaŋ kɔ. U nɛ ma joŋo yallɛ a kpu. ");
INSERT INTO sil_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wia tiŋdaaraa joŋ Wia niiŋ wiaa pima, ama ma buu to.” ");
INSERT INTO sil_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitiiviŋ si bul wialiŋ dɛrɛ, nialiŋ fa si hilime vuurɛ wiaa nii wialiŋ u si bula. Ba baaniŋ faasa sii, ba chichaŋ ba nyilaa. ");
INSERT INTO sil_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ŋii nɛ Wia Diŋ-zɔŋ-la faasa hɛ Sitiiviŋ lɛ yugɛ. U wula beŋ wia nyuŋ a na Wii-baliŋ tula, a na Yesu maa duu hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ŋii nɛ Sitiiviŋ bul, “Má bee na, mi na Wia-jaŋ boiŋniiŋ duu suro, ka Nuhuobiine Bie hɔŋ Wia sɛmɛ, ni-duoŋ di-hɔnuŋ.” ");
INSERT INTO sil_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ka ba faasa ŋaa goŋ a tɔ ba digilaa, ba kala guu mu-u lɛ ");
INSERT INTO sil_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a kɛnu yige ta u lii ba jaŋ tuɔŋ lɛ, a paa tabiaa yiyagu. Nialiŋ síi yagɛ Sitiiviŋ joŋ ba gɛnniŋ a pi bapuɔsi-bie kubala baa yirɛ Sɔɔl, u bibeŋ. ");
INSERT INTO sil_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Baa yagɛ Sitiiviŋ ŋii nɛ ari tabiaa, ka u yiyirɛ la Tiina Yesu a sulu, “Mi Tiina Yesu, laami kaa mu ŋ teeŋ.” ");
INSERT INTO sil_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","U tuu kpirimi a faasa ŋmoo niiŋ a bul, “Mi Tiina Yesu, mii suluŋ, sí ba haachɛ deeŋ chimiŋ ti̱ŋ.” U bul ŋii nɛ aŋ suu. ");
INSERT INTO sil_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔl ma sɛi ari ba kpu Sitiiviŋ nɛ. Chɛɛ-la ba suomo to nialiŋ si laa Yesu wiaa dii aa hilimi naasiŋ, a dudɔgisɛba kiŋkɛŋ Jerusalɛm lɛ. Ba kala pisɛ Judiya ari Samaria tiŋteeŋ kala lɛ, see Yesu naŋzɔɔba-la duŋduŋa nɛ ka. ");
INSERT INTO sil_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nialiŋ síi fá Wia joŋ Sitiiviŋ a hugi aŋ yel u yoho woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔɔl faa chɛ duu pugi nialiŋ si laa Yesu wiaa dii, a to ba naasiŋ dudɔgisɛba. U to dii-niiriŋ a kɛsɛ haalaa ari baala-la si laa Yesu wiaa dii, a lɛrɛba lii ba diisiŋ lɛ, aŋ leŋ ba kɛŋba kaa mu tɔ dia. ");
INSERT INTO sil_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nialaa fa si pisa, ba mu gɔllɛ lee kala a bubul Wia niiŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip sii mu taŋ kubala baa yirɛ Samaria, a bul Kirisito wiaa pi nialaa si hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ni-daŋ-la kala si nii wialaa u si bula a na u wu-magila-la u si ŋaa, ba kala kɛŋ nii-bala a joŋ ba nyuŋ hɛ wialiŋ u síi bul lɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip si bul wiaa ŋii, jiŋ-bɔŋŋɔɔ fa kɛŋ niaa a yugɛ, ba leŋba. Di ba nɛ leŋba, ba yie lii a faasa yiyel. Niaa ma yuga a gbɛrikɛ, dɔŋsuŋ kɛŋ naa-suunuŋ ari na-suunuŋ, ba ma kala duori. ");
INSERT INTO sil_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Samaria tiŋŋaa kala tuɔŋ faasa tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Taŋ-la lɛ baal kubala ma hɛ dimɛ, baa yirɛ Saamɔŋ. U kɛŋ daalusuŋ a ŋiŋaa wu-kpuŋkperisiŋ taŋ-la lɛ niaa nina, a didagɛ ari u nɛ kɛŋ doluŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ni-balaa ari haŋbiisiŋ kala joŋ ba nyuŋ hɛ u wu-ŋaalaa lɛ a bul, “Baala deeŋ nɛ ŋaa wia. U kɛŋ doluŋ, dol-la ba síi yirɛ Wia dol-baliŋ.” ");
INSERT INTO sil_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U si ŋaa wu-kpuŋkperisiŋ deeŋba niaa na u diene, ŋii nɛ tii niaa joŋ ba nyuŋ kala hɛ u wu-ŋaalaa lɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama Filip si bul Wia wu-zɔmɔ-la a tigɛ Wia kuorii-la, a bul Yesu Kirisito ma wiaa, ba laa wialaa dii, ba foba Wii-chuɔlɛ liiŋ, baalaa ari haalaa kala. ");
INSERT INTO sil_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saamɔŋ titia ku laa wialiŋ dii, ba fou ma Wii-chuɔlɛ liiŋ, ka u mɛrɛ Filip lɛ. U si na wu-kpuŋkperisi-la ari wu-magilaa Filip síi ŋaa, u ŋaau wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesu naŋzɔɔba-la si hɛ Jerusalɛm lɛ nii ari Samaria tiŋŋaa laa Wia wiaa dii. Ŋii nɛ ba ta Piita ari Jɔɔŋ di ba mu dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba mu a chuɔlɛ Wia piba di Wia joŋ u Diŋ-zɔŋ-la piba, ");
INSERT INTO sil_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","bɛɛ wiaa bua-la lɛ Wia Diŋ-zɔŋ-la ha biba kuŋ-kala lɛ hɛ. La Tiina Yesu doluŋ duŋduŋa lɛ nɛ ba fa foba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ba joŋ ba nisaa daŋba lɛ, ŋii nɛ Wia Diŋ-zɔŋ-la ku tuu hɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saamɔŋ si na di Yesu naŋzɔɔba-la joŋ ba nisaa daŋba lɛ Wia Diŋ-zɔŋ-la ku hɛba lɛ, u joŋ moribiee a sulba a bul, ");
INSERT INTO sil_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Má pimi ma doluŋ deeŋ di mi ma joŋ nisiŋ daŋ nuu-kala lɛ, di Wia Diŋ-zɔŋ-la hɛ tiina ma lɛ.” Ŋii nɛ Piita bula pu, ");
INSERT INTO sil_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","“Ŋ biina ŋ jaŋ wuo joŋ moribiee yɔɔ Wia si joŋ kua dii zile niaa lɛɛ? Ma di ŋ moribiee kala jaŋ juu nyiniŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ŋ bi wii-kala kɛnɛ wiaa deeŋba lɛ. Ŋ bi ŋ tuɔŋ pulla Wia teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Birimɛ a lii wu-bɔmuŋ deeŋ lɛ, aŋ sul Wia duu joŋ ŋ tuɔbiinaa deeŋba ŋ si biinu a chɛŋ. Duu jaŋ joŋo chɛŋ, u jaŋ joŋo chɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ŋ yaraa bieri kiŋkɛŋ, haachɛ ma kɛniŋ.” ");
INSERT INTO sil_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ŋii nɛ Saamɔŋ sulba di ba chuɔlɛ Wia pu di wiaa deeŋba kala ba si bula síu lɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ba si bul Wia wiaa dɛrɛ ari wialiŋ kala u si ŋaa piba, ba sii di ba miira mu Jerusalɛm. Ba si mu Jerusalɛm ŋii, ba bul Wia wu-zɔmɔ-la Samaria tiŋteeŋ tasiŋ lɛ a yugɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ŋii nɛ Wia tiŋdaara kubala ku bula pi Filip, “Sii mu taŋ-bubuɔŋ a mu woŋbii-binii-la si lii Jerusalɛm aa mu Gaza.” U mua. ");
INSERT INTO sil_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","U si mu dimɛ, u na baal kubala duu lii Itoopia tiŋteeŋ. U ŋaa boŋjoŋ nɛ a tima pipi Itoopia kuoro ba síi yirɛ Kaŋdaasi. U fa ŋaa haal nɛ. Baal-la faa beŋ u kiaa kala. U fa mu Jerusalɛm nɛ a chuɔlɛ Wia aŋ hɔŋ u toruko nyuŋ, ");
INSERT INTO sil_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","a miira mumu dia. U fa síi vɛŋ ŋii nɛ u kikarimɛ Wia teniŋ sɛmɛ dɔŋɔ, Azaaya si ŋmuŋsa. Azaaya fa ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ŋii nɛ Wia Diŋ-zɔŋ-la bula pi Filip duu mu kpagɛ toruku-la. ");
INSERT INTO sil_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip fá mu kpagu a nii duu karimɛ Wia teŋ-la sɛmɛ dɔŋɔ Azaaya si ŋmuŋsa. U piɛsu duu jiŋ wialiŋ u síi karimu bubuɔŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ŋii nɛ baal-la bul duu bi jaŋ wuo jiŋ ba bubuɔsaa, see di nuu dagu, aŋ yirɛ Filip duu jila hɔnɔ pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wia niiŋ wialiŋ u fa síi karimu nɛ ŋla: U si, “U tɔrɛ u niiŋ a nagɛ piese ba si kaa mu di ba kpu, ka u tɔrɛ ŋii. U bira nagɛ pie-bie ma si tɔrɛ u niiŋ, ka ba kikeri u punaa nɛ. Nii-la bi u niiŋ suro. ");
INSERT INTO sil_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","U si kɛŋ u titia muuri ŋii, ba girima laa u wu-siŋŋaa. Ba liisu ni-weyee tuɔŋ a kpuu. Ba si kpuu ŋii, kubɛɛ nɛ jaŋ wuo to u doho naasiŋ?” ");
INSERT INTO sil_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Baal-la si karimɛ Wia niiŋ wiaa dɛrɛ, u piɛsɛ Filip, “Kubɛɛ wiaa nɛ nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ bubul ŋii? U titia wiaa nɛ koo nuu ma dɔŋ wiaa nɛɛ?” ");
INSERT INTO sil_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ŋii nɛ Filip suomi Wia niiŋ wialaa lee-la titia nɛ a bul Wia wu-zɔŋŋɔɔ wiaa a kaa mu tigɛ Yesu lɛ. ");
INSERT INTO sil_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ba si joŋ woŋbii-la aa mu, ba mu yi lee kubala duu kɛŋ liiŋ. Ŋii nɛ baal-la bula pi Filip a bul, “Na liiŋ nɛ ŋla. Bɛɛ nɛ jaŋ tɔmi di ŋ sími Wii-chuɔlɛ liiŋ fo?” ");
INSERT INTO sil_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ŋii nɛ Filip bula pu, “Di ŋ nɛ laa Yesu wialiŋ dii ari ŋ tuɔŋ kala, mi jaŋ foŋ Wii-chuɔlɛ liiŋ.” Ŋii nɛ baal-la bul, “Mi laa dii ari Yesu Kirisito nɛ ŋaa Wia Bie.” ");
INSERT INTO sil_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ŋii nɛ baal-la ŋaa jani-la fa síi lɛrɛ toruku-la chiŋ. Ba di Filip kala tuu a juu lii-la. Filip fou Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba si ku lii lii-la tuɔŋ, Yesu Diŋ-zɔŋ-la ku joŋ Filip kaa lɛl. Baal-la bira bi Filip na aŋ joŋ u woŋbiiŋ vivɛŋ, a kala ŋaa tuɔtɔru. ");
INSERT INTO sil_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ŋaa duu chiŋ duu hɛ taŋ kubala baa yirɛ Asidɔd lɛ. U gɔllɛ ta-biisi-la kala si hɛ dimɛ a bubul Wia wu-zɔŋŋɔɔ wiaa. U ŋaa ŋii nɛ a mu yi taŋ kubala baa yirɛ Sizariya. ");
INSERT INTO sil_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sɔɔl ha fufugi la Tiina Yesu haritooro-la ari u jaŋ kpuba, a sii mu nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ teeŋ, ");
INSERT INTO sil_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a sulu duu ŋmuŋsɛ tenniŋ pu duu kaa mu taŋ kubala baa yirɛ Damaasikas a kpaa Wii-chuɔlɛ diisiŋ lɛ. U nɛ ŋaa ŋii duu na nuu-na kala síi to woŋbii-la dimɛ, baalaa koo haalaa kala, duu wuo kɛŋ doluŋ a wuo kɛsɛba vɔɔ kaa kɔ Jerusalɛm. U ŋmuŋsa pu. ");
INSERT INTO sil_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sɔɔl si lii joŋ woŋbiiŋ a mumu Damaasikas a ku kpagɛ taŋ-la, pulumuŋ guu lii wia nyuŋ a faasa chaana hɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","U tuu tel tiŋteeŋ. Ka u nii nuu yiikoro. Uu bul u teeŋ, “Sɔɔl, Sɔɔl, bɛɛ nɛ tii ŋ to mi naasiŋ a dudɔgisɛmi ŋla?” ");
INSERT INTO sil_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ŋii nɛ u piɛsɛ, “Kubɛɛ nɛ, tiina?” Yiikoro-la bul, “Mi nɛ ŋaa Yesu, nii-la ŋ si to u naasiŋ a dudɔgisɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sii juu taŋ-la tuɔŋ. Dimɛ ba jaŋ dagiŋ wii-la ŋ si jaŋ ŋaa.” ");
INSERT INTO sil_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sɔɔl ari nialiŋ fa síi vɛŋ, ba china tuɔbibeŋ, ba nii yiikori-la, ama ba bi nuu-kala naa. ");
INSERT INTO sil_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔl nyaga sii a suri u siaa. U bi kuŋ-kala wuo na. Ba kɛŋ u nisiŋ lɛ nɛ a lɛrɛ juu Damaasikas. ");
INSERT INTO sil_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U nyulimɛ a hɛ dimɛ u tapulaa batori. U bi kuŋ-kala die, u bi liiŋ ma nyua. ");
INSERT INTO sil_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesu haritooro-la kubala ma fa hɛ Damaasikas lɛ, baa yirɛ Ananayas. U na wiaa ari duosoo tuɔŋ. Ŋla nɛ u na: La Tiina Yesu yiru a bul, “Ananayas!” Ŋii nɛ u si, “Nami, mi Tiina.” ");
INSERT INTO sil_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ŋii nɛ la Tiina Yesu bula pu, “Sii mu woŋbii-la ba síi yirɛ woŋbii-tegi-tegi a mu baal kubala dia u yiriŋ nɛ Judas, a piɛsɛ chɛ baal-la si lii taŋ kubala baa yirɛ Taasis. Baal-la yiriŋ nɛ Sɔɔl. U níi chuɔlɛ Wia sisɛlɛ ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ŋii nɛ Yesu bira bula pi Ananayas a bul, “Sɔɔl níi chuɔlɛ Wia ŋii, u na ari duosoo tuɔŋ, ŋ-na Ananayas, di ŋ ku juu a joŋ ŋ nisiŋ daŋu lɛ di u siaa bira suri.” ");
INSERT INTO sil_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ŋii nɛ Ananayas bul, “Mi Tiina, niaa yuga kiŋkɛŋ a bula pimi ari baala deeŋ ŋaa wu-bɔŋŋɔɔ ŋ niaa lɛ si hɛ Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ pu doluŋ taŋ deeŋ lɛ duu kɛsɛ nialiŋ kala síi chuɔluŋ vɔɔ.” ");
INSERT INTO sil_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","La Tiina Yesu bula pi Ananayas a bul, “Sii mu, mi nɛ liisu duu tima pipimi. U jaŋ mu bul mi wiaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa teeŋ, ari kuoroo, ari Iziral niaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi nɛ jaŋ dagu hɛɛ-la ŋii u si jaŋ na a tiŋ mi wiaa.” ");
INSERT INTO sil_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ŋii nɛ Ananayas sii mu dia-la Sɔɔl si jua. U juu a joŋ u nisaa daŋ Sɔɔl lɛ aŋ bul, “Mi naaŋbie Sɔɔl, la Tiina Yesu-la ŋ si na woŋbiiŋ lɛ ŋ síi kɔ daha, u nɛ tiŋmi. U tiŋmi di mi kɔ di ŋ siaa wuo suri, ka di Wia Diŋ-zɔŋ-la ma hɛŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","U si bul ŋii, di kiaa nagɛ cheŋfiliŋ kerikee guu lii Sɔɔl siaa lɛ tel, ka u bira wuo nina. U sii, ba fou Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","U dii kiaa a bira dol. U hɛ Damaasikas lɛ a juu Yesu haritooro-la si hɛ Damaasikas tuɔŋ tapulaa baŋmɛnɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","U si hɛ dimɛ, u guu sii mu Wii-chuɔlɛ diisiŋ a suomo bubul Yesu wiaa a pipi niaa, a bul duu nɛ ŋaa Wia Bie. ");
INSERT INTO sil_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nialiŋ kala si nii wialiŋ u si bula, u ŋaaba wu-kpuŋkpere. Baa piɛsɛ dɔŋɔ, “Baala deeŋ dee fa bi Jerusalɛm lɛ hɛ aa kpu nialiŋ síi to Yesu deeŋ ŋii? Ŋla wiaa saa dee u bira kɔ daha, duu kɛsɛba vɔɔ kaa mu nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ teeŋ?” ");
INSERT INTO sil_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ka Sɔɔl síi bul wialaa, u wasa kɛŋ doluŋ a kii buŋbuŋ-la. U wuo dagɛ ari Yesu nɛ ŋaa Kirisito, Wia si liisa. U paala faasa bul ŋii, Ju̱u tiŋŋaa si hɛ Damaasikas lɛ, ba naŋdaasiŋ kala yuɔrɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","U hɛ dimɛ a dieni, ŋii nɛ chɛɛ kubala Ju̱u tiŋŋaa vuurɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sɔɔl ku nii. Ba yie pɔ taŋ-la boiŋnii-baaliŋ wiihɛyɛ ari titaŋiŋ kala nɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Titaŋ kubala Sɔɔl haritooroo joŋu hɛ sime tuɔŋ a kɛŋ ŋmɛniŋ vɔɔ, a lɛru u kieli jee-la a tuu jeeŋ hariŋ, a lii mu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔl si mu Jerusalɛm, u chichɛ duu juu Yesu haritooro-la tuɔŋ. Ba bi laa dii ari u ŋaa Yesu haritooro-la dɔŋɔ. Ba fifáu. ");
INSERT INTO sil_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yesu naŋzɔɔba-la dɔŋɔ ba síi yirɛ Banabas nɛ pɛu lɛ a kɛnu kaa mu Yesu naŋzɔɔba-la teeŋ. U nɛ bula piba ŋii Sɔɔl si na la Tiina Yesu woŋbiiŋ lɛ, u bul wiaa pu ŋii. Banabas nɛ saa bira bula piba ŋii Sɔɔl si kɛŋ nyu-duoŋ a bul Yesu wiaa pi niaa Damaasikas lɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ba sɛi u juu ba tuɔŋ a gugɔllɛ ari tuɔtɔruŋ Jerusalɛm lɛ, ");
INSERT INTO sil_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","a bubul Wia wiaa ari nyu-duoŋ la Tiina Yesu doluŋ lɛ. Ba di Ju̱u timma-la síi bul Giriik tiŋŋaa wu-buluŋ, ba kɛŋ wiaa lilɛrɛ. Ba wiwalimɛ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","U naaŋbiiri-la si nii wiiŋ deeŋ, ba kɛnu kaa mu Sizariya a ŋaa u mu Taasis. ");
INSERT INTO sil_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ŋii hariŋ lɛ nialiŋ si laa Yesu wiaa dii aa hilimi Judiya ari Galilii ari Samaria tiŋteeŋ lɛ kala na wiese, a wasa ŋaa Wia yarida, a to la Tiina Yesu a fifáu. Wia Diŋ-zɔŋ-la ma pɛba lɛ. Ba puŋa pɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piita fa gɔllɛ leree kala nɛ. Tapulii kubala u sii mu Lida duu na Wia niaa dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","U si mu dimɛ, u na baal kubala baa yirɛ Iniyas. U gbɛrikɛ piŋ dia lɛ jisiŋ chori. ");
INSERT INTO sil_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ŋii nɛ Piita bula pu a bul, “Iniyas, Yesu Kirisito vaariŋ nɛ, sii chuoli ŋ bɔsɔ.” U guu sii a duori. ");
INSERT INTO sil_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nialiŋ kala si lii Lida ari Sarɔŋ na ŋii, a birimɛ to la Tiina Yesu. ");
INSERT INTO sil_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Haal kubala nɛ fa hɛ Jɔpa lɛ. U faa to Yesu nɛ. U yiriŋ nɛ Tabita. (Giriik tiŋŋaa kaa yiru Dɔɔkas. U bubuɔŋ nɛ bagil.) U kɛŋ zile kiŋkɛŋ a pipɛ summoo lɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bua-la lɛ u wiwiilɛ a suu. Ba fou liiŋ a kaa jila bil lusuŋ nyuŋ dia lɛ. ");
INSERT INTO sil_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jɔpa ari Lida fa bi bol. Nialiŋ si laa Yesu wiaa dii a hɛ Jɔpa lɛ nii ari Piita hɛ Lida lɛ. Ba tiŋ niaa balia u teeŋ di ba sulu duu hɛ doluŋ aŋ kɔ ba teeŋ lima lima. Ba mu a bula pu. ");
INSERT INTO sil_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piita sii to ba hariŋ mu. U si mu dimɛ, ba kɛnu jil lusuŋ nyuŋ dia-la. Yo-haalaa kala chiŋ u sɛmɛ aa yel, a paa gɛri-laalaa ari gɛri-vɔbia-la Dɔɔkas fa si yɛrɛ u fa si hɛ u miisiŋ lɛ, a didagɛ Piita. ");
INSERT INTO sil_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piita ŋaa ba kala lii dia-la tuɔŋ. Ba si lia, u tuu kpirimi a chuɔlɛ Wia. U chuɔlɛ Wia dɛrɛ aŋ birimɛ suu-la teeŋ a bul, “Tabita, sii.” U suri u siaa. U si na Piita, u sii hɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piita mu yiu a kɛŋ u nisiŋ lɛ u sii. Ŋii nɛ u yirɛ Wia niaa ari yo-haala-la a joŋo piba. Ba kala nau duu bira weye. ");
INSERT INTO sil_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wiiŋ deeŋ teeli Jɔpa kala nɛ. Niaa yuga a ku laa la Tiina Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piita hɛ puri-tisɛru kubala dia lɛ nɛ Jɔpa lɛ a didieni. U yiriŋ nɛ fa Saamɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Baal kubala nɛ fa hɛ Sizariya lɛ. U yiriŋ nɛ fa Kɔniilias. U fa ŋaa laali-yuoro-la ba si kaa kpaa zɔlɔ zɔlɔ ba dɔŋɔ kuhiaŋ nɛ, laali-yuoro-la ba kaa yirɛ Itali laali-yuoroo. ");
INSERT INTO sil_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uu fá Wia, ba di u dia niaa kala ma tuto Wia. U yie pipɛ summoo lɛ, a chuchuɔlɛ Wia ma bua-na kala lɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wiihɛyɛ kubala ari kerifi batori bua lɛ, Kɔniilias paala chaasa na ari duosoo tuɔŋ di Wia tiŋdaara kubala ku juu a yiru, “Kɔniilias!” ");
INSERT INTO sil_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U chaarɛ siaa bibenu. Fawulluŋ kɛnu. U piɛsɛ, “Bɛɛ kuŋ nɛ mi Tiina?” Ŋii nɛ Wia tiŋdaari-la bula pu, “Wia nii ŋ si yie chuchuɔlu ŋii nɛ a na ŋ si yie pipɛ summo-la ma lɛ ŋii. A tiŋ wiaa deeŋba wiaa uu liisi ŋ wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tiŋ niaa lɛɛlɛ di ba mu Jɔpa a chɛ yirɛ baal kubala duu kɔ ŋ teeŋ. U yiriŋ nɛ Saamɔŋ Piita. ");
INSERT INTO sil_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Uu juu puri-tisɛru kubala dia nɛ, u ma yiriŋ nɛ Saamɔŋ. U dia kpagɛ mugi-baliŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wia tiŋdaari-la si bul wialiŋ dɛrɛ, u miira viiri. Ŋii nɛ aŋ ka Kɔniilias yirɛ u dia tiŋtinnaa balia a pɛ laali-yuoro kubala lɛ. Laali-yuori-la hɛ nialaa si yie hɔnɔ gbaaru tuɔŋ nɛ a fifá Wia. ");
INSERT INTO sil_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U bul wii-la kala u si na nɛ aŋ leŋ ba mu Jɔpa. ");
INSERT INTO sil_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Taŋ si pula, wia ma magɛ nyu-gbaŋa di ba mu kpagɛ Jɔpa. Ba síi mu ŋii, Piita ma jil lusuŋ duu chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Losuŋ fa kɛnu u chichɛ kudiilee duu dii. Ba sii ŋiŋaa kudiilee di ba pu. Ba síi ŋaa kudiile-la ŋii, u na ari duosoo tuɔŋ ");
INSERT INTO sil_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","di wia nyuŋ kpaa. Ka kuŋ a nagɛ gɛri-baliŋ a lii wia nyuŋ ku tuu tiŋteeŋ. Ba kɛŋ u niipine-la banɛsɛmiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ka puŋ-yiriba ari zaari-yiriba ari kialiŋ si kɛŋ bɔyɛ tutuuri tiŋteeŋ hɛ u tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ŋii nɛ u nii nuu yiikoro duu bul, “Piita, sii kpu a dii.” ");
INSERT INTO sil_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piita bul, “Ai, mi Tiina, mi ha bi ku-la kala si kɛŋ disinniŋ die.” ");
INSERT INTO sil_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yiikori-la bira miira bula pu, “Ku-la kala Wia si si u zɔmɔ, bira sí bul duu kɛŋ disinniŋ.” ");
INSERT INTO sil_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","U na kialiŋ deeŋba di ba ku tuu naaŋsiiŋ butori nɛ, ka ba miira jil wia nyuŋ. Ba bira bi tibe. ");
INSERT INTO sil_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wii-la kperi Piita. U hɔnɔ bibiinɛ wii-la u si na bubuɔŋ, di nialiŋ Kɔniilias fa si tima, di ba nɛ piɛsa ku chiŋ Saamɔŋ boiŋnii-baaliŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ŋii nɛ ba yirɛ a piɛsɛ di baal kubala hɛ dia deeŋ tuɔŋ baa yirɛ Saamɔŋ Piitaa? ");
INSERT INTO sil_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piita fa ha kɛŋ wii-la u fa si na a bibiinɛ u bubuɔŋ. Ŋii nɛ di Wia Diŋ-zɔŋ-la bula pu, “Bee na baalaa batori nɛ hɛ daha a chichɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sii tuu a sí logo logo ŋaa, aŋ kɛŋba mu. Mi nɛ tiŋba ŋ teeŋ.” ");
INSERT INTO sil_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ŋii nɛ Piita sii tuu ba teeŋ a bula piba, “Mi nɛ nii-la ma síi chɛ. Bɛɛ nɛ ma kaa chichɛmi?” ");
INSERT INTO sil_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ŋii nɛ ba bul, “Laali-yuoroo kuhiaŋ kubala, baa yirɛ Kɔniilias nɛ tiŋla. U ŋaa tuɔ-pul tiina nɛ a fifá Wia. Ju̱u tiŋŋaa ma kala bibɛsɛu lɛ. Wia tiŋdaara kubala nɛ ku bula pu duu yiriŋ di ŋ kɔ u dia, di ba nii wii-la ŋ si jaŋ bula piba.” ");
INSERT INTO sil_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ŋii nɛ Piita yirɛba di ba juu chua, taŋ-pul. Taŋ si pula u sii ba di ba mu. U naaŋbiiri-la ma dɔŋsuŋ si laa Yesu wiaa dii Jɔpa lɛ ma pɛ kɛnu mu. ");
INSERT INTO sil_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chɛ-liamiŋ chɛɛŋ ba mu yi Sizariya. Dimɛ Kɔniilias ari u naaŋbiiriŋ ari u naŋdɔŋsuŋ u si yira, ba kala hɔnɔ gbɛru. ");
INSERT INTO sil_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piita fa si ku juu, Kɔniilias sii chemu, a tuu kpirimi u sipaaŋ a chuɔlu. ");
INSERT INTO sil_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ŋii nɛ Piita kɛnu aŋ bul duu sii. Ka u bula pu, “Mi ma ŋaa nuhuobiiŋ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piita ari Kɔniilias fa haa bul wiaa nɛ aŋ to dɔŋɔ jujuu dia. Piita juu na di niaa yuga a hilimi dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ŋii nɛ u bula piba a bul, “Ma titia jima ari Ju̱u tiŋŋaa kisiŋ nɛ di ba guoli nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuɔŋ. Ba bi ba diisiŋ maa mu. Ama Wia dagɛmi di mi sí nuu-kala kaa yirɛ disinniŋ tiina. ");
INSERT INTO sil_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ŋii nɛ tii, ba si ku yirɛmi, mi bi wii-kala bula aŋ kɔ. Mi si kɔ ŋla, bul wii-la si tii ŋ yirɛmi.” ");
INSERT INTO sil_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ŋii nɛ Kɔniilias bula pu a bul, “Tapulaa batori nɛ ŋla ari bua deeŋ titia lɛ, mii chuɔlɛ Wia wiihɛyɛ mi dia lɛ. Di baal kubala nɛ ŋii a chiŋ mi sipaaŋ. U gɛnniŋ faasa tutul. ");
INSERT INTO sil_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","U bula pimi, ‘Kɔniilias, Wia nii ŋ si yie chuchuɔlɛ Wia ŋii nɛ, a na ŋ si yie pipɛ summo-la ma lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Saa tiŋ niaa di ba mu Jɔpa, a chɛ yirɛ baal kubala duu kɔ. U yiriŋ nɛ Saamɔŋ Piita. Uu juu puri-tisɛru kubala dia nɛ, baa yirɛ Saamɔŋ. U dia kpagɛ mugi-baliŋ nɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kɔniilias bira bul, “Ŋii nɛ tii mi tiŋ niaa lima lima, ba kɔ ŋ teeŋ di ba yiriŋ. Ŋ ma hɛ doluŋ ŋ si kɔ ŋla. Lɛɛlɛ la kala hilime nɛ Wia sipaaŋ, a gbigbɛrɛ di la nii wii-la kala Wia si dagiŋ di ŋ bula pila.” ");
INSERT INTO sil_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ŋii nɛ Piita suomo bubul, “Mi lɛɛlɛ jima ari wutitii nɛ, Wia joŋ niaa kala ba ŋaa kubala nɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nuu-kala síi fáu a ŋiŋaa wialiŋ síi to woŋbiiŋ, Wia laau nɛ. U sipaaŋ tuo yiri-la kala u si ŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ma ma nii Wia wu-zɔmɔ-la u si joŋo pi Iziral tiŋŋaa. U bula piba di ba to Yesu Kirisito lɛ a na wiese. (U nɛ ŋaa nuu-kala Tiina.) ");
INSERT INTO sil_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wialiŋ si tigɛ Yesu si lii Nazarɛt lɛ suomi Galilii tiŋteeŋ a teeli Judiya tiŋteeŋ kala. Jɔɔŋ laa sipaaŋ bubul Wia wiaa, a fo niaa Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma ma nii Yesu wiaa nɛ. Wia joŋ u Diŋ-zɔŋ-la hɛu lɛ a puu doluŋ. U sii mu lee kala, aa ŋaa wu-zɔŋŋɔɔ pipi niaa, aa vaarɛ nialiŋ kala Sitaani si kɛnɛ a nyaga bil. Wia fa chiŋ u hariŋ nɛ tii u wuo ŋiŋaa wiaa deeŋba kala. ");
INSERT INTO sil_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wialiŋ kala u si ŋaa Jerusalɛm lɛ ari Ju̱u tiŋŋaa tiŋteeŋ kala, la na a ŋaaba daŋsia. Ŋii nɛ ba kpaasu mɛrɛ daa-gɛsɛɛ nyuŋ u suu. ");
INSERT INTO sil_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama Wia chisu suuŋ lɛ tapul-torimuŋ chɛɛŋ a leŋ niaa bira nau. ");
INSERT INTO sil_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nuu-kala dee buu na, ama la nialiŋ Wia fa si liisa di la ŋaa u daŋsiaba, la nɛ nau. U si sii suuŋ lɛ, la kala hɔŋ di-bala a dii kiaa. ");
INSERT INTO sil_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U bula pila di la bul Wia wiaa a pi niaa, a dagɛba ari Wia liisu nɛ duu ŋaa ni-weyee ari ni-suunuŋ kala sariya diire. ");
INSERT INTO sil_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","U wiaa nɛ nialiŋ kala fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ faa bul ŋii. Ba si nuu-kala si laa u wiaa dii, Wia jaŋ joŋ u haachɛba chɛu u doluŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piita ha síi bul wiaa ŋii nɛ, Wia Diŋ-zɔŋ-la ku tuu hɛ nialiŋ kala fa síi jegili wialiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Ju̱u timma-la fa si laa Yesu wiaa dii a lii Jɔpa a to Piita hariŋ kɔ, ba nia ari baa bul wiaa yiikori-yiriba lɛ ba si bi jiŋ a didɛnnɛ Wia. U ŋaaba wu-kpuŋkpere. Ba fa bi biina ari Wia jaŋ joŋ u Diŋ-zɔŋ-la a dii zile nialiŋ ma si bi Ju̱u tiŋŋaa ŋaa lɛ. Ŋii nɛ Piita bul, ");
INSERT INTO sil_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wia si joŋ u Diŋ-zɔŋ-la pila ŋii, ŋii nɛ u joŋo pi niaa deeŋba maa. Bɛɛ nɛ jaŋ wuo tɔ niaa deeŋba di ba sí Wii-chuɔlɛ liiŋ fo?” ");
INSERT INTO sil_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","U ŋaa ba foba Wii-chuɔlɛ liiŋ Yesu Kirisito doluŋ lɛ. Ŋii nɛ ba sulu duu hɔŋ ba teeŋ tapulaa baŋmɛnɛ. ");
INSERT INTO sil_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu naŋzɔɔba-la ari nialiŋ dɔŋsuŋ si laa Yesu wiaa dii a lii Judiya nia ari nialiŋ dɔŋsuŋ si bi Ju̱u tiŋŋaa ŋaa ma nii Wia niiŋ wiaa a sɛi. ");
INSERT INTO sil_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ŋii nɛ Piita miira mu Jerusalɛm. Nialiŋ si cho di ba keri nialiŋ si bi Ju̱u tiŋŋaa ŋaa penee, ka ba-na to Yesu, ba bulu woruŋ aŋ piɛsu, ");
INSERT INTO sil_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bɛɛ nɛ tii ŋ mu nialiŋ si bi Ju̱u tiŋŋaa ŋaa teeŋ, ma di ba paala dii kiaa?” ");
INSERT INTO sil_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ŋii nɛ Piita suomo bubul wii-la kala si paala chaasa ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","U bula, “Mi fa hɛ Jɔpa lɛ nɛ a chuchuɔlɛ Wia, a na ari duosoo tuɔŋ di kuŋ a nagɛ gɛri-baliŋ lii wia nyuŋ ku tuu mi teeŋ. Ba kɛŋ gɛri-la niipine-la banɛsɛmiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi nyilimi u tuɔŋ a na pusuŋ ari bagilaa ari kialiŋ si kɛŋ bɔyɛ tutuuri tiŋteeŋ ari diibiisiŋ. ");
INSERT INTO sil_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ka mi nii nuu yiikoro duu bul, ‘Piita, sii kpu a dii.’ ");
INSERT INTO sil_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ŋii nɛ mi bul, ‘Ai, mi Tiina, mi ha bi ku-la kala si kɛŋ disinniŋ die.’ ");
INSERT INTO sil_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yiikori-la bira lii wia nyuŋ a bula pimi, ‘Ku-la kala Wia si si u zɔmɔ, bira sí bula bul duu kɛŋ disinniŋ.’ ");
INSERT INTO sil_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wiiŋ deeŋ ŋaa naaŋsiiŋ butori nɛ, ka kialiŋ miira jil wia nyuŋ. ");
INSERT INTO sil_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bua-la titia lɛ nɛ baalaa batori ba si tima mi teeŋ a lii Sizariya, ba ku juu dia-la mi fa síi juu. ");
INSERT INTO sil_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wia Diŋ-zɔŋ-la bula pimi di mi sí logo logo ŋaa aŋ to ba hariŋ mu, di mi joŋ niaa kala ba ŋaa kubala nɛ. La di mi naaŋbiiriŋ deeŋba balidu síi lii Jɔpa, la kala nɛ mu Sizariya, a juu Kɔniilias dia. ");
INSERT INTO sil_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ŋii nɛ u bula pila ari ŋii u si na Wia tiŋdaara duu chiŋ u dia tuɔŋ a bula pu, ‘Tiŋ niaa di ba mu Jɔpa a yirɛ baal kubala baa yirɛ Saamɔŋ Piita, a kɛnu kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","U jaŋ bul wiaa pima a dagɛma wialiŋ si jaŋ laa ma di ŋ dia niaa kala ta.’ ");
INSERT INTO sil_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mi si suomo bubul wiaa, Wia Diŋ-zɔŋ-la ku tuu hɛba lɛ, ari u fa si laa sipaaŋ hɛla lɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wiiŋ deeŋ si ŋaa, mi liisi wii-la la Tiina Yesu fa si bula. U fa si, ‘Jɔɔŋ síi fo niaa Wii-chuɔlɛ liiŋ, liiŋ duŋduŋa nɛ u kaa fo. Ama mi-na jaŋ joŋ mi Diŋ-zɔŋ-la a hɛma lɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wia si joŋ u Diŋ-zɔŋ-la pila ŋii bua-la lɛ la si ku laa Yesu Kirisito wiaa dii, ŋii nɛ u joŋo dii zile ba ma lɛ. Kubɛɛ nɛ saa kami di mi tɔ Wia duu síba lɛ pɛ?” ");
INSERT INTO sil_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ba si nii wialiŋ deeŋba, ba bira bi wii-kala wuo bul. Ba dɛnnɛ Wia a bul, “Wia paala pi nialiŋ ma si bi Ju̱u tiŋŋaa ŋaa woŋbiiŋ di ba wuo birima lii ba haachɛba lɛ aŋ kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bua-la lɛ ba fa si to naasiŋ dudɔgisɛ nialiŋ si laa Yesu wiaa dii a tiŋ Sitiiviŋ wiaa, ba pisɛ. Ba si pisɛ ŋii, ba mu yi Fɔniisia ari Saapɔs tiŋteeŋ ari taŋ-la ba síi yirɛ Aŋtiɔk, a bul Wia niiŋ wiaa pipi Ju̱u tiŋŋaa duŋduŋa dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama nialiŋ dɔŋsuŋ si laa Yesu wiaa dii a lii Saapɔs ari Sariini sii mu Aŋtiɔk, a bul la Tiina Yesu wiaa a pi nialiŋ si bul Giriik wu-buluŋ maa. ");
INSERT INTO sil_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wia pɛba lɛ a chiŋ ba hariŋ. Niaa yuga a laa Yesu wiaa dii a birima tutou. ");
INSERT INTO sil_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nialiŋ si laa Yesu wiaa dii aa hilimi Jerusalɛm lɛ nii wiiŋ deeŋ. Ba tiŋ Banabas duu mu Aŋtiɔk. ");
INSERT INTO sil_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","U si mua, u na ŋii Wia si pɛ nialiŋ lɛ. U tuɔŋ tɔrɛ. U chagilɛba woruŋ a bul di ba chiŋ la Tiina Yesu yarida lɛ ari ba tuɔŋ kala, a sí joŋo ta. ");
INSERT INTO sil_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas fa ŋaa ni-pula nɛ a kɛŋ yarida woruŋ. Wia Diŋ-zɔŋ-la ma hɛu lɛ woruŋ. Niaa yuga a laa la Tiina Yesu wiaa dii a ku tutou. ");
INSERT INTO sil_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ŋii nɛ Banabas sii mu Taasis duu chɛ Sɔɔl leriŋ. ");
INSERT INTO sil_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","U si nau, u kɛnu ba kɔ Aŋtiɔk. Ba di nialiŋ si laa Yesu wiaa dii, ba yie hilimi. Ba hɔŋ dimɛ ji-piliŋ a dagɛ Wia wiaa pi niaa yugɛ. Aŋtiɔk lɛ nɛ ba suomo kɛŋ Yesu haritooro-la kaa yiyirɛ Kirisitiaŋba. ");
INSERT INTO sil_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bua-la lɛ nɛ nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋsuŋ lii Jerusalɛm a kɔ Aŋtiɔk. ");
INSERT INTO sil_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba dɔŋɔ yiriŋ nɛ Agabɔs. U sii chiŋ a bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ a bul di losuŋ jaŋ juu dunia kala. Losu-la ku juu di Kulɔɔdiɔs nɛ fa ŋaa kuori-baliŋ. ");
INSERT INTO sil_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋii nɛ Yesu haritooro-la vuurɛ a sɛi di ba jaŋ joŋ moribiee tiŋ, di ba kaa mu pɛ ba naaŋbiiri-la si hɛ Judiya lɛ, di nuu-kala tia magɛ ŋii kala u si kɛnɛ. ");
INSERT INTO sil_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba kaa kɔ. Ba joŋo tiŋ Banabas ari Sɔɔl, di ba kaa mu pi nialiŋ si laa Yesu wiaa dii kuhiasiŋ Judiya lɛ. ");
INSERT INTO sil_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kuoro kubala nɛ hɛ dimɛ a bibeŋ Ju̱u tiŋŋaa tiŋteeŋ. U yiriŋ nɛ fa Hɛrɔd. Bua deeŋ lɛ u suomo to naasiŋ dudɔgisɛ nialiŋ dɔŋsuŋ si laa Yesu wiaa dii aa hilimi. ");
INSERT INTO sil_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U ŋaa ba joŋ tokobii a kpu Jɔɔŋ naaŋbie Jeems. ");
INSERT INTO sil_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","U si na di Ju̱u tiŋŋaa tuɔŋ tɔrɔ wii-la u si ŋaa lɛ, u ŋaa ba kɛŋ Piita ma tɔ dia. (Wiiŋ deeŋ ŋaa ba gbieli-bal-la lɛ nɛ ba si yie dii boroboro si bi si-buruŋ kɛnɛ.) ");
INSERT INTO sil_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ba si kɛŋ Piita, ba kɛnu kaa mu tɔ dia. Dimɛ nɛ ba ŋaa laali-yuoroo fii ari balidu bibenu. Banɛsɛ yie benu mua, banɛsɛ ma bira ku laaba lɛ. Hɛrɔd fa biina di diisiŋ kieliŋ gbiele-la nɛ bal, ka u kɛnu lii pi nialiŋ di ba dii u sariya. ");
INSERT INTO sil_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piita fa si hɛ sarika lɛ ŋii, nialiŋ si laa Yesu wiaa dii aa hilimi chuɔlɛ Wia pupu ari siifiɛsiŋ. ");
INSERT INTO sil_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Titaŋ kubala Piita fa piŋ doŋ laali-yuoro-la baliamiŋ síi benu pɛgɛ. Ba fa kɛŋ chɔrumɔɔ balia nɛ a kaa vɔɔ u nisaa lɛ, ka laali-yuoroo balia ma chiŋ sarika-la boiŋniiŋ a pɔ. U taŋ níi pul di Hɛrɔd fa kɛnu kaa lii nialiŋ tuɔŋ di ba dii u sariya. ");
INSERT INTO sil_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Piita hɛ dimɛ ŋii di Wia tiŋdaara kubala nɛ chiŋ dimɛ ŋii. Pulumuŋ chaanɛ sarika-la tuɔŋ. Wia tiŋdaari-la ku pɛɛsɛ Piita vaaŋ pɛ a chisu, a bula pu duu sii lima. Chɔrumɔ-la guu lii Piita nisaa lɛ tuu tel. ");
INSERT INTO sil_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ŋii nɛ Wia tiŋdaari-la bula pu duu paa u kiaa laalɛ a hɛ u nɛŋtɛŋŋɛɛ. Piita ŋaa ŋii Wia tiŋdaari-la si bula pu. U bira bula pu duu joŋ u gɛri-bɔsɔ baagɛ a to u hariŋ. ");
INSERT INTO sil_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","U to u hariŋ a lii sarika-la tuɔŋ. U síi to Wia tiŋdaari-la hariŋ ŋii, u fa ha bi jiŋ ari wii-la Wia tiŋdaari-la síi ŋaa, ŋaa wutitii. U biina u na ari duosoo tuɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba mu kieli laali-yuoro-la si chiŋ sipaaŋ a bibeŋ sarika-la, a bira mu kieli laali-yuoro-la dɔŋsuŋ ma si chiŋ hariŋ a ma ha bibeŋ sarika-la, a mu yi hɔɔŋ boro-la si tɔ boiŋnii-baaliŋ a jujuu taŋ-la. Boi-la suri u titia lɛ, ba lii. Ba lii joŋ woŋbii kubala aa vɛŋ. Ba si mu mua, Wia tiŋdaari-la joŋ Piita ta. ");
INSERT INTO sil_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ŋii nɛ Piita sisɛlɛ ku jiŋ ari wii-la si ŋaau lɛ ŋaa wutitii nɛ. U bul, “Mi lɛɛlɛ jima ari Wia nɛ tiŋ u tiŋdaara u ku laami ta Hɛrɔd nisiŋ lɛ ari wialiŋ kala Ju̱u tiŋŋaa fa si biina ba ŋaami lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Piita si jiŋ wiiŋ deeŋ lɛ, u mu Jɔɔŋ Maak naaŋ Mɛɛri dia. U mu dimɛ, di niaa fa yuga a hilimee chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piita ŋmoo boro. Toli-bie kubala baa yirɛ Roda, u fa ŋaa ketii nɛ dia-la lɛ. U kɔ duu na. ");
INSERT INTO sil_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","U ku nii Piita yiikoro a wuo jiŋ di Piita nɛ. U tuɔŋ tɔrɛ woruŋ. U bi boi-la suro aŋ miira fá juu bula pi niaa di Piita nɛ chiŋ di-jaliŋ. ");
INSERT INTO sil_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba si toli-bie-la nyuŋ tuo. Ka u-na ha bul di wutitii nɛ. Ŋii nɛ ba bira bul, u ni-dima nɛ u na. ");
INSERT INTO sil_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ka Piita ma ha chiŋ a ŋmuŋmoo boro. Ŋii nɛ ba ku kɛŋ boro-la suri a nau. U ŋaaba wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ŋii nɛ Piita kɛŋ u nisiŋ vigi di ba kɛŋ goŋ, aŋ bula piba ŋii Wia si kɛnu kaa lii sarika-la tuɔŋ. U si di ba bul wiiŋ deeŋ a pi Jeems ari u naaŋbiiri-la ma dɔŋsuŋ si laa Yesu wiaa dii. U si bul ŋii dɛrɛ, u lii to lee dɔŋ mu. ");
INSERT INTO sil_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Taŋ si pula, laali-yuoro-la si pɔ sarika-la bi Piita na. Ba tuɔbiinaa kala vugimɛ. Ba pipiɛsɛ dɔŋɔ di bɛɛ nɛ ŋaa Piita lɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ŋii nɛ Hɛrɔd bul di ba chɛ kɛnu kaa kɔ. Ba chɛu lɔl. Hɛrɔd piɛsɛ laali-yuoro-la duu na wii-la kala si ŋaa, aŋ ŋaa ba kpuba. Ŋii nɛ Hɛrɔd sii lii Judiya tiŋteeŋ, a mu Sizariya a hɔŋ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Bua deeŋ lɛ Hɛrɔd fa na baaniŋ woruŋ Taya ari Saadɔŋ niaa nyuŋ. Ba síi hilime mu di ba na Hɛrɔd, ba laa sipaaŋ a na Bilasitas, nii-la síi beŋ kuoro dia nɛ, duu pɛba lɛ. U pɛba lɛ. Ŋii nɛ ba mu Hɛrɔd teeŋ a sulu duu leŋ di ba siŋ. Ba taŋ niaa kudiilee lii kuoro tiŋteeŋ nɛ. Ŋii nɛ tii baa sulu ŋii. ");
INSERT INTO sil_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hɛrɔd hɛ tapulii nɛ di ba kɔ. Tapulii-la si yie, Hɛrɔd sii laalɛ u kuori-gɛnniŋ a hɔŋ u kuori-kpasa nyuŋ, a bul wiaa pipi nialiŋ. ");
INSERT INTO sil_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ŋii nɛ nialiŋ faasa ŋiŋaa goŋ a bul, “U bi naga nuhuobiine níi bul wiaa deeŋba, Wia nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ba si bul ŋii, Hɛrɔd bi Wia zile pa. Ŋii nɛ tii Wia tiŋdaara ku tuu ŋmoo Hɛrɔd lo lima lima u suu, naŋchuɔlaa diiu. ");
INSERT INTO sil_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ka Wia niiŋ wiaa ha teeli leriŋ. Niaa yuga a nii a laa dii. ");
INSERT INTO sil_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ari Sɔɔl si tiŋ tiŋtimii-la dɛrɛ, tiŋtimii-la ba si si di ba mu tiŋ Jerusalɛm lɛ, ba miira mu Aŋtiɔk, a pɛ kɛŋ Jɔɔŋ Maak ma pɛba lɛ mu. ");
INSERT INTO sil_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ari kerichiba dɔŋsuŋ fa hɛ Aŋtiɔk lɛ, nialiŋ si laa Yesu wiaa dii aa hilimi teeŋ. Ba yiriŋ nɛ Banabas, ari Simiaŋ ba síi yirɛ ni-bine, ari Lusias si lii Sariini, ari Sɔɔl ari Maneyaŋ. (Tiŋteeŋ kuoro Hɛrɔd nɛ diɛsɛ Maneyaŋ.) ");
INSERT INTO sil_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Niaa deeŋba tiŋ tiŋtiŋŋaa pipi Wia a vuvɔɔ niiŋ. Ŋii nɛ Wia Diŋ-zɔŋ-la bula piba a bul, “Má liisɛ Banabas ari Sɔɔl pimi di ba tiŋ tiŋtimii-la mi si joŋo piba di ba ŋaa.” ");
INSERT INTO sil_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ba chuɔlɛ Wia a vɔɔ niiŋ, a joŋ ba nisaa daŋba lɛ, aŋ taba. ");
INSERT INTO sil_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wia Diŋ-zɔŋ-la si tiŋba ŋii, ba sii mu Selusia, a lii dimɛ a juu liiŋ daboro, a mu tiŋtee kubala liiŋ si gollo chu baa yirɛ Saapɔs. ");
INSERT INTO sil_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba si yi dimɛ, ba mu Saapɔs taŋ dɔŋɔ baa yirɛ Salamis. Ba bul Wia niiŋ wiaa Ju̱u tiŋŋaa Wii-chuɔlɛ diisiŋ lɛ dimɛ. Ba kɛŋ Jɔɔŋ Maak ma pɛ kɔ duu pɛ tiŋ tiŋtimii-la. ");
INSERT INTO sil_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ba gɔllɛ tiŋtee-la kala liiŋ si gollo chu, a mu yi taŋ kubala baa yirɛ Paafɔs. Dimɛ nɛ ba na daalusuŋ tiina kubala baa yirɛ Baa-Yesu. U fa ŋaa Ju̱u tiina nɛ aŋ nyia wiaa bul duu-na bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","U fa hɛ ba taŋ kuoro dia lɛ nɛ, baa yirɛ Saajas Pɔɔlɔs. Kuoru-la fa ŋaa wu-jinnu nɛ. U yirɛ Banabas ari Sɔɔl u sipaaŋ. U faa chɛ di ba bul Wia niiŋ wiaa pu nɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Daalusuŋ tiina Ɛlimas lii ba hariŋ aa walimɛ di kuoru-la sí Yesu wialaa laa dii. (Giriik lɛ ba kɛŋ Baa-Yesu yiyirɛ Ɛlimas nɛ.) ");
INSERT INTO sil_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ŋii nɛ Wia Diŋ-zɔŋ-la ku hɛ Sɔɔl lɛ. (Ba fa kɛnu kaa yiyirɛ Pɔɔl ma nɛ.) U chaarɛ siaa pɛ daalusuŋ tiina-la lɛ ");
INSERT INTO sil_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a bula pu, “Ŋ-na Sitaani bie deeŋ, ŋ ŋaa ku-zɔŋ kala diŋdɔŋ nɛ. Ŋ ŋaa zɛŋbɛ tiina maa a ŋaa wu-bɔŋŋɔɔ kiŋkɛŋ. Wia woŋbii-titiiba-la ŋ kaa golibi nɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bee na, Wia jaŋ ku tuuŋ lɛ, ŋ jaŋ nyulimɛ, a magɛ magina kubala ŋ bi jaŋ na pulumuŋ.” U si bul ŋii, kuŋ guu tɔ u siaa, u bira bi na. U gɔllɔ chichɛ nuu duu kɛŋ u daaŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kuoru-la si na wii-la si ŋaa, u laa Yesu wiaa dii. Wialiŋ u si gunna a tigɛ la Tiina Yesu lɛ ŋaau wu-kpuŋkpere. ");
INSERT INTO sil_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔl ari u naŋdɔŋsuŋ sii juu liiŋ daboro a lii Paafɔs, a kiele mu taŋ kubala baa yirɛ Pɛɛga a hɛ Paŋfiilia tiŋteeŋ lɛ. Jɔɔŋ Maak taba dimɛ aŋ miira mu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba ma sii dimɛ a mu Aŋtiɔk, Pisiidia tiŋteeŋ lɛ. Chɛ-wiesii-la chɛɛŋ, ba mu juu Wii-chuɔlɛ dia a hɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ba si hɔŋ ŋii, nuu karimɛ wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, ari Wia tenni-la nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa si ŋmuŋsa. Ba si karima dɛrɛ, Wii-chuɔlɛ dia-la kuhiasiŋ tiŋ di ba bula piba a bul, “Mi naaŋbiiriŋ, di ma nɛ kɛŋ wii si jaŋ wuo pɛ niaa deeŋba lɛ di ba nyuŋ nyaasɛ, má bul.” ");
INSERT INTO sil_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ŋii nɛ Pɔɔl sii chiŋ a kɛŋ u nisiŋ vigi di ba kɛŋ goŋ, aŋ suomo bubul, “Mi naaŋbiiriŋ Iziral timma ari ma nialiŋ si bi Ju̱u tiŋŋaa ŋaa a hɛ daha a fifá Wia, má jegile nii mi teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wia-la ma Iziral tiŋŋaa deeŋba síi to, u nɛ tuɔsɛ la naabalimaba a ŋaa ba puŋ a yugɛ, bua-la lɛ ba fa si ŋaa nuhuɔraa Ijipiti tiŋteeŋ lɛ. U doluŋ lɛ nɛ u kɛŋba kaa lii Ijipiti lɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","U beŋba ari kenyiri jisiŋ mahiŋ balia giri-bine tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","U leŋe ba yuo ta-geŋtisiŋ balipɛ Keenaŋ tiŋteeŋ lɛ a laa tiŋtee-la a dii. Ba hɔŋ dimɛ jisiŋ zɔ-banɛsɛ ari mahiŋ balia ari fii. ");
INSERT INTO sil_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ba si hɔŋ lee-la, Wia liisɛ ba tuɔŋ nihiaŋ duu bibeŋ ba tiŋteeŋ. Ba vɛnɛɛ ŋaa ŋii nɛ, ka Samuɛl-na kɔ. U fa ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ŋii nɛ ba sul Wia duu piba kuoro. Wia sɛi a liisɛ Sɔɔl piba. Sɔɔl fa ŋaa Kis bie nɛ a lii Bɛŋjamiŋ doho niaa tuɔŋ. U dii kuoruŋ jisiŋ mahiŋ balia. ");
INSERT INTO sil_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ŋii nɛ Wia kiru kuoruŋ lɛ aŋ ŋaa Devit dii kuoruŋ. U bul wiaa a tigɛ Devit lɛ a bul, ‘Jɛsi bie Devit nɛ ŋaa mi tuɔtɔru nia. U jaŋ ŋaa wii-kala mi síi chɛ duu ŋaa.’ ");
INSERT INTO sil_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Devit doho niaa tuɔŋ nɛ Yesu lii. Wia ŋaa u ku ŋaa Iziral niaa Laataara, ari u fa si bul ŋii. ");
INSERT INTO sil_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka di Yesu-na kɔ, Jɔɔŋ bul Wia wiaa pi Iziral tiŋŋaa kala, a bul di ba birima lii ba haachɛ lɛ aŋ fo Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jɔɔŋ tiŋtiŋŋaa si kpagɛ dɛriŋ, u piɛsɛ niaa, ‘Kubɛɛ nɛ ma biinɛ di mi ŋaa? Mi dee nii-la ma síi gbɛru duu kɔ. U jaŋ kɔ mi hariŋ. Nii-la-na mi paala bi maga di mi kɛŋ u nɛŋtɛŋŋɛɛ ŋmɛniŋ a puri!’ ");
INSERT INTO sil_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mi naaŋbiiriŋ Abiraham doho niaa ari ma nialiŋ si bi Ju̱u tiŋŋaa ŋaa a hɛ daha a fifá Wia, la wiaa nɛ ba tiŋ di ba bul wialiŋ deeŋba si jaŋ wuo laala ta. ");
INSERT INTO sil_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yesu si kɔ, nialiŋ si hɛ Jerusalɛm lɛ ari ba kuhiasiŋ fa bi jiŋ ari u nɛ ŋaa la Laataara. Ba ma bi nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ wu-bulii-la bubuɔŋ jiŋ, wialiŋ ba si yie karimɛ chɛ-wiesii-la chɛɛŋ kala. Ama ba ha leŋ nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ niiŋ wialiŋ ku ŋaa wutitii, a kpu Yesu. ");
INSERT INTO sil_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba paala bi wii-kala na u si ŋaa chei a magɛ di ba kpuu, ka ba sul Paalit duu leŋ di ba kpuu. ");
INSERT INTO sil_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba si ŋaa wialiŋ kala dɛrɛ ba si laa sipaaŋ ŋmuŋsɛ Wia teniŋ tuɔŋ a mu tigɛ Yesu lɛ, ba soru daa-gɛsɛɛ nyuŋ a joŋu hugi. ");
INSERT INTO sil_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Wia chisu suuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","U si sii suuŋ lɛ, u kɛŋ u titia ku dagɛ ba di nialiŋ fa si lii Galilii a mu Jerusalɛm. Ba nau yugɛ. Ba nɛ lɛɛlɛ saa bul u wiaa pipi Iziral tiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","La ma saa kɔ di la bul Wia wu-zɔmɔ-la pima. Wii-la Wia fa si bula pi la naabalimaba duu jaŋ ŋaa, ");
INSERT INTO sil_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","lɛɛlɛ u ŋaa pila, la nialiŋ si ŋaa ba doho niaa. Wia chisɛ Yesu suuŋ lɛ u kɛŋ miisiŋ. Ba fa ŋmuŋsɛ ŋii nɛ Wia teniŋ sɛmɛ dɔŋɔ lɛ ba síi yirɛ Saams. Ba ŋmuŋsa a tigɛ Yesu lɛ a bul, ‘Ŋ ŋaa mi Bii nɛ. Mi nɛ luluŋ jiniŋ.’ ");
INSERT INTO sil_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ba ŋmuŋsɛ Wia teniŋ sɛmɛ dɔŋɔ ma a tigɛu lɛ ari Wia si, ‘Mi jaŋ sɛnɛ tou lɛ a pɛma lɛ woruŋ ari mi fa si bul ŋii a pi Devit.’ U bul ŋii nɛ aŋ chisɛ Yesu suuŋ lɛ, duu bira bi jaŋ suu a pua. ");
INSERT INTO sil_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wia teniŋ baa yirɛ Saams sɛmɛ dɔŋɔ maa ba bira ŋmuŋsa, ‘Ŋ bi jaŋ leŋ di ŋ Tuɔ-pul Tiina suu a pua.’ ");
INSERT INTO sil_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devit fa ŋaa wialiŋ Wia síi chɛ duu ŋaa. U ŋaa ŋii u miisiŋ lɛ aŋ suu. Ba joŋu hugi u naabalima sɛmɛ, u pua. ");
INSERT INTO sil_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama nii-la Wia si chisɛ suuŋ lɛ, u-na bi pua. ");
INSERT INTO sil_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mi naaŋbiiriŋ, u maga di ma kala jiŋ woruŋ di baala deeŋ wiaa nɛ ŋaa la wuo bubul di Wia jaŋ joŋ ma haachɛba chɛma. ");
INSERT INTO sil_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nuu-kala si laa u wiaa dii, u laa u haachɛba kala ta nɛ, haachɛba-la kala wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto fa si bi wuo laa ta. ");
INSERT INTO sil_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Má fiɛlɛ ma siaa di wialiŋ nialiŋ síi bul, Wia Diŋ-zɔŋ-la doluŋ lɛ, sí ma lɛ ŋaa. Ba si, ");
INSERT INTO sil_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ma nialiŋ síi mɔŋ Wia, má bee na tiŋtimii-la mi si jaŋ tiŋ ma miisiŋ tapuluŋ lɛ. Di nuu nɛ bula pima, ma bi jaŋ laa dii duu sɛnɛ ŋaa wutitii. U jaŋ ŋaama wu-kpuŋkpere a leŋ di ma suu.’ ” ");
INSERT INTO sil_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔɔl ari Banabas si bul wiaa deeŋba kala dɛrɛ, ba sii lii Wii-chuɔlɛ dia lɛ. Ba síi mu, nialiŋ sulba di ba miira kɔ hariŋ chɛ-wiesii-la chɛɛŋ, a bira bul wiaa deeŋba piba. ");
INSERT INTO sil_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ŋii nɛ nialiŋ kala lii Wii-chuɔlɛ dia lɛ. Ju̱u tiŋŋaa ari nialiŋ si bi Ju̱u tiŋŋaa ŋaa aŋ tuto Ju̱u tiŋŋaa, ba yuga a to Pɔɔl ari Banabas hariŋ. Pɔɔl ari Banabas bul wiaa piba a susulba di ba chiŋ Wia wu-zɔmɔ-la lɛ a sí joŋo ta. ");
INSERT INTO sil_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hariŋ chɛ-wiesii-la si yie, niaa jesiŋ kala si hɛ taŋ-la lɛ nɛ mu Wii-chuɔlɛ dia di ba jegile nii Wia niiŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ju̱u tiŋŋaa fa si na ni-daŋ-la si hilime ŋii, ba didii hadɔruŋ. Ba jujuu Pɔɔl lɛ ari wialiŋ u síi bul a tutuusu. ");
INSERT INTO sil_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ka Pɔɔl ari Banabas bul wiaa ari nyu-duoŋ a bul, “U fa maga di la laa sipaaŋ bul Wia niiŋ wiaa pi ma Ju̱u tiŋŋaa nɛ, ka ma viaba ta aŋ bibiinɛ ma bi maga di ma kɛŋ miisi-la si bi dɛrɛ. La jaŋ leŋma aŋ mu nialiŋ si bi Ju̱u tiŋŋaa ŋaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wia nɛ bula pila di la ŋaa ŋii. U bul wiiŋ deeŋ Wia teniŋ sɛmɛ dɔŋɔ. U si, ‘Mi nɛ liisiŋ di ŋ ŋaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa pulumuŋ. Ŋ jaŋ bul Wia niiŋ wiaa dunia sɛmɛ-na kala, di Wia laa nialaa ta.’ ” ");
INSERT INTO sil_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nialiŋ si bi Ju̱u tiŋŋaa ŋaa si nii wiiŋ deeŋ, ba tuɔŋ kala tɔrɛ, ba bul di Wia niiŋ wiaa sima kiŋkɛŋ. Nialiŋ Wia si liisa di ba kɛŋ miisi-la si bi dɛrɛ, ba laa wialiŋ dii. ");
INSERT INTO sil_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","La Tiina Yesu niiŋ wiaa teeli lee-la kala. ");
INSERT INTO sil_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama Ju̱u tiŋŋaa nyisɛ taŋ-la nihiasiŋ ari haala-la si ŋaa ni-balaa a fifá Wia a hɛ. Ba di Ju̱u tiŋŋaa suomo to naasiŋ dudɔgisɛ Pɔɔl ari Banabas, a ŋaa ba lii ba tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔɔl ari Banabas kpesi ba nɛŋtɛŋŋɛɛ hagila hɛba lɛ, a dagɛba ŋii di ba wii dee, aŋ lii mu Ikooniam. ");
INSERT INTO sil_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ka nialiŋ si laa Yesu wiaa dii Aŋtiɔk lɛ, ba tuɔŋ kala tɔrɛ. Wia Diŋ-zɔŋ-la ma hɛba lɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔl ari Banabas si hɛ Ikooniam lɛ, ba juu Ju̱u tiŋŋaa Wii-chuɔlɛ dia a bul Wia wiaa. Ba si chaasa bul Wia wiaa ŋii, ni-daŋ ku laa Yesu wiaa dii, Ju̱u tiŋŋaa ari Giriik tiŋŋaa kala. ");
INSERT INTO sil_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama Ju̱u tiŋŋaa si bi Yesu wiaa laa dii, ba nyisɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa hɛ. Ba tuɔbiinaa bira bi nialiŋ si laa Yesu wiaa dii teeŋ mua. ");
INSERT INTO sil_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔl ari Banabas hɔŋ lee-la a dieni. Ba bul la Tiina Yesu wiaa ari nyu-duoŋ. U ma pɛba lɛ a piba doluŋ ba ŋiŋaa wu-magilaa ari wu-kpuŋkperisiŋ. Niaa ku jiŋ ari la Tiina Yesu zile wiaa nɛ ba sɛnɛɛ bul. ");
INSERT INTO sil_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nialiŋ fa si hɛ taŋ-la lɛ kɛŋ ba titia kpaa balia. Dɔŋsuŋ tuto Ju̱u tiŋŋaa, dɔŋsuŋ ma tuto Yesu naŋzɔɔba-la. ");
INSERT INTO sil_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ŋii nɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa ari Ju̱u tiŋŋaa ari ba kuhiasiŋ wiwalimɛ di ba dɔgisɛ Pɔɔl ari Banabas aa chɛ di ba paa tabiaa yiyagɛba. ");
INSERT INTO sil_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ba ku jiŋ a sii fá mu Lisita, a lii dimɛ a mu Dɛɛbi. Ba kala ŋaa ta-biisiŋ nɛ Lakoonia tiŋteeŋ lɛ. Ba ma mu ta-biisi-la si golli Lakoonia tiŋteeŋ chu. ");
INSERT INTO sil_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dimɛ kala nɛ ba bul Yesu wu-zɔmɔ-la wiaa. ");
INSERT INTO sil_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ba fa si mu Lisita ŋii di baal kubala gbɛrikɛ hɔŋ dimɛ. Ba lulu duu gbɛrikɛ nɛ. U ha bi vɛnɛ na. ");
INSERT INTO sil_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","U hɔnɔ jegile nii Pɔɔl fa síi bul wialiŋ. Pɔɔl chaarɛ siaa benu, a na duu laa dii ari Yesu jaŋ wuo a vaaru. ");
INSERT INTO sil_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","U faasa bula pu, “Sii chiŋ ŋ naasiŋ nyuŋ.” U pura sii chiŋ u naasiŋ nyuŋ aa vɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nialiŋ fa si hilime a na wii-la Pɔɔl fa si ŋaa, ba suomo kpikpia goŋ aa bul ari ba yiikoro lɛ a bul, “Vesiŋ nɛ birimɛ nuhuobiine ku tuu la tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ŋii nɛ ba kɛŋ Banabas yiyirɛ Zuus. Zuus nɛ fa ŋaa ba veŋ-hiaŋ. Pɔɔl nɛ fa nii-la síi bul wiaa, ŋii nɛ tii ba yiru Hɛɛmis maa, ba veŋ-hiaŋ naŋzɔɔ yiriŋ nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ba vene Zuus dia ba fa si juu kpikpaarɛ, fa chiŋ ba taŋ sipaaŋ. Vene tiina kɛŋ nɛ-belliŋ ari tii-fiilaa ba si kaa guori kaa kɔ dia-la boiŋniiŋ. Ba di nialiŋ fa si hilime ka chɛ di ba kpaarɛ Yesu naŋzɔɔba-la nɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Banabas ari Pɔɔl si nii wii-la ba síi chɛ ba ŋaa, ba kɛŋ ba gɛnniŋ kiɛsɛ, a dagɛba ŋii ari ba bi sɛyɛ, aŋ fá juu nialiŋ tuɔŋ a faasa bul, ");
INSERT INTO sil_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“La naŋdɔŋsuŋ, bɛɛ nɛ tii maa ŋaa ŋla? La ma ŋaa nuhuobiinee nɛ. La kɔ di la bul la Tiina Yesu wu-zɔmɔ-la nɛ pima, di ma wuo leŋ ma vui-tɔɔnu-la aŋ birima to Wia-la si weye. U nɛ ŋaa wia nyuŋ, ari tiŋteeŋ, mugi-balaa ari fuonuŋ, ari kuŋ-kala si hɛ dunia lɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Buŋbuŋ Wia leŋe la naabalimaba tuto ba titia woŋbiiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","U fa ŋaa wu-zɔŋŋɔɔ pipi niaa, a didagɛba ŋii ari u hɛ dimɛ. U ŋaa duonuŋ ninii a ŋaa baga kiaa wiwasɛ, ma didii kiaa a vuvɔgɛ a kala kɛŋ tuɔtɔruŋ.” ");
INSERT INTO sil_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Banabas ari Pɔɔl bul wiaa deeŋba kala nɛ, ka nialiŋ ha bi sɛyɛ aŋ chichɛ di ba kpaarɛba. Ba na hɛɛŋ nɛ, ka nialiŋ-na leŋ. ");
INSERT INTO sil_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Di Ju̱u tiŋŋaa dɔŋsuŋ lii Aŋtiɔk, Pisiidia tiŋteeŋ lɛ, a ma kɔ. Dɔŋsuŋ ma lii Ikooniam a kɔ. Ba ku kɛsɛ nialiŋ pɛ ba titia lɛ a yagɛ Pɔɔl ari tabiaa, a kɛnu lɛrɛ lii ba taŋ tuɔŋ. Ba biina u fa suba nɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yesu haritooro-la mu a gollu. Ŋii nɛ u sii a miira juu taŋ tuɔŋ. U taŋ si pula, ba di Banabas sii mu Dɛɛbi. ");
INSERT INTO sil_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔɔl ari Banabas bul Yesu wu-zɔmɔ-la wiaa lee-la ma lɛ. Ba si bul ŋii, niaa yuga a laa Yesu wialiŋ dii a tuto ba hariŋ. Ŋii nɛ ba miira mu Lisita, a sii dimɛ a mu Ikooniam, a bira sii dimɛ a miira mu Aŋtiɔk Pisiidia tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Leree deeŋba kala ba yie bul wiaa pi nialiŋ si laa Yesu wiaa dii di ba wasa kɛŋ yarida aa ŋaa di ba nyuŋ nyaasɛ di ba chiŋ ba yarida lɛ, a sí joŋo ta. Ba ma bula piba di nialiŋ si laa Yesu wialiŋ dii, di ba jaŋ na hɛɛŋ kiŋkɛŋ, ka di ba-na juu Wia kuorii-la tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lee-na kala nialiŋ si laa Yesu wialiŋ dii aa hilimi, ba ma liisɛ niaa ba tuɔŋ di ba ŋaa ba kuhiasiŋ. Ba nɛ ŋaa ŋii, ba yie chuɔlɛ Wia piba aa vɔɔ niiŋ, aŋ joŋba hɛ la Tiina Yesu nisiŋ lɛ. U-na la Tiina Yesu wiaa nɛ ba laa dii. ");
INSERT INTO sil_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ŋii nɛ ba gɔllɛ Pisiidia tiŋteeŋ kala dɛrɛ aŋ lii mu Paŋfiilia tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dimɛ ba bul Wia niiŋ wiaa taŋ kubala baa yirɛ Pɛɛga, a bira lii dimɛ a mu taŋ kubala baa yirɛ Atalia. ");
INSERT INTO sil_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ba lii dimɛ a juu liiŋ daboro, a bira miira mu Aŋtiɔk. Dimɛ nɛ ba fa joŋba hɛ Wia nisiŋ ari u lahɔrimɔ lɛ di ba wuo tiŋ ba tiŋtiŋŋaa. Lɛɛlɛ ba tiŋ tiŋtimii-la dɛrɛ. ");
INSERT INTO sil_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba si miira ku yi Aŋtiɔk, ba yirɛ nialiŋ kala si laa Yesu wiaa dii aa hilimi, a bula piba wu-zɔmɔ-la kala Wia si toba lɛ a ŋaa, a dagɛba ŋii Wia si wuo suri woŋbiiŋ a pi nialiŋ si bi Ju̱u tiŋŋaa ŋaa, ba ma wuo laa Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ba hɔŋ dimɛ, ba di nialiŋ si laa Yesu wiaa dii teeŋ, a dieni. ");
INSERT INTO sil_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Baalaa dɔŋsuŋ ma lii Judiya a kɔ Aŋtiɔk, a suomo didagɛ ba naaŋbiiri-la si laa Yesu wiaa dii a bul, “Wia bi jaŋ wuo laama ta, see ma keri ma penee, ari Moosis fa si bil niiŋ pima ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ŋii nɛ Pɔɔl ari Banabas kɛŋ nii-doluŋ woruŋ. Ba di nialiŋ si lii Judiya kɛŋ wii-la lilɛrɛ. Ba vuurɛ di Pɔɔl ari Banabas ari nialiŋ dɔŋsuŋ si lii Aŋtiɔk, di ba mu Jerusalɛm a na Yesu naŋzɔɔba-la ari nialiŋ si laa Yesu wiaa dii aa hilimi kuhiasiŋ dimɛ, a mu tigɛ wiiŋ deeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nialiŋ si laa Yesu wiaa dii aa hilimi kɛŋba lii hɛ wɛniŋ lɛ. Ba síi mu ŋii, ba to Fɔniisia ari Samaria tiŋteeŋ a bula pi nialiŋ si laa Yesu wiaa dii dimɛ ŋii nialiŋ si bi Ju̱u tiŋŋaa ŋaa si birima tuto Wia. Ba si bul wu-zɔmuŋ deeŋ ŋii, nialiŋ tuɔŋ tɔrɛ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba si mu yi Jerusalɛm, Yesu naŋzɔɔba-la ari nialiŋ kala si laa Yesu wiaa dii aa hilimi ari ba kuhiasiŋ, ba kɛŋba woruŋ. Ba bula piba wialiŋ kala Wia si ŋaaba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama nialiŋ dɔŋsuŋ ma si laa Yesu wiaa dii aa to nialiŋ ba síi yirɛ Farisii tiŋŋaa, ba sii chiŋ a bula piba a bul, “U maga di ba keri ba penee aŋ tuto wialiŋ Moosis fa si bile di maa to.” ");
INSERT INTO sil_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yesu naŋzɔɔba-la ari nialiŋ si laa Yesu wiaa dii kuhiasiŋ bira hilimi di ba bira biinɛ wiiŋ deeŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba hɔnɔ kɛŋ wii-la a lɛrɛ dieni. Ŋii nɛ Piita sii chiŋ aŋ bul, “Mi naaŋbiiriŋ, ma jima ari faafaa kala nɛ Wia liisɛmi ma tuɔŋ di mi bul Wia wu-zɔmɔ-la wiaa a pi nialiŋ si bi Ju̱u tiŋŋaa ŋaa, di ba ma wuo laa Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mi mu bula piba. Wia joŋ u Diŋ-zɔŋ-la hɛba lɛ ari u fa si joŋo hɛla lɛ ŋii, a dagɛ ŋii ari u maga di ba ma laa Yesu wiaa dii. U saa jiŋ nuu-kala tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","U bi nialiŋ si ŋaa Ju̱u tiŋŋaa ari nialiŋ si bi Ju̱u tiŋŋaa ŋaa kaa pɔrɛ. Nialiŋ si bi Ju̱u tiŋŋaa ŋaa ma laa Yesu wiaa dii, ŋii nɛ tii u joŋ ba ma haachɛba chɛba. ");
INSERT INTO sil_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bɛɛ nɛ tii ma joŋ chugi-baliŋ aa chuŋ nialiŋ si bi Ju̱u tiŋŋaa ŋaa aŋ laa Yesu wiaa dii, aa magisɛ Wia ŋii? La di la naabalimaba kala, la fa bi chuga deeŋ wuo chuŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","La laa dii ari la Tiina Yesu duŋduŋa lahɔrimɔ lɛ nɛ Wia jaŋ laala kala ta ari u si laaba ta ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piita si bul wii-la dɛrɛ, nialiŋ kala fa si hilime ŋaa fuii, a jegile nii Banabas ari Pɔɔl teeŋ. Ba bul wu-magila-la ari wu-kpuŋkperisi-la Wia si toba lɛ ŋaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba si bul wialiŋ dɛrɛ, Jeems ma bul, “Mi naaŋbiiriŋ, má jegile nii mi teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saamɔŋ Piita bula pima Wia si laa sipaaŋ cho nialiŋ si bi Ju̱u tiŋŋaa ŋaa ŋii, a tuɔsɛ niaa ba tuɔŋ di ba ŋaa u niaa. ");
INSERT INTO sil_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ma fa bul wiiŋ deeŋ Wia teniŋ tuɔŋ. Ba si, Wia bula a bul, ");
INSERT INTO sil_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mi jaŋ miira kɔ a chuulɛ Devit dia-la si tele. Mi jaŋ wasa taasɛ je-kiɛri-la duu chiŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mi jaŋ ŋaa ŋii di dunia niaa ni-kaanaa ma ku chɛ Wia a tou. Nialiŋ mi si tuɔsa nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuɔŋ di ba ŋaa mi niaa, ba ma jaŋ ku chɛmi a tomi.’ ");
INSERT INTO sil_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wia bul ŋii faafaa kala nɛ di niaa jiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ŋii nɛ Jeems bul, “Mi biina u bi maga di la walimɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa aŋ birima tuto Wia. ");
INSERT INTO sil_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama má leŋ di la ŋmuŋsɛ teniŋ piba a bula piba di ba bira sí vuiŋ kaa tiŋ a birisi ba titia, di ba leŋ ba-chɔruŋ ari ha-chɔruŋ wu-ŋaalaa, a sí pusuŋ si suu pimee dii, a sí pusuŋ chaliŋ ma dii. ");
INSERT INTO sil_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bɛɛ wiaa ba yie dagɛ wialiŋ Moosis fa si bile di la tuto ta-biisi-la kala lɛ nɛ. Ba ŋaa ŋii faafaa kala nɛ a kaa kɔ jiniŋ. Ba ma yie karimɛ wialiŋ Wii-chuɔlɛ diisiŋ lɛ chɛ-wiesii-la-na kala chɛɛŋ.” ");
INSERT INTO sil_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yesu naŋzɔɔba-la ari kuhiasi-la ari nialiŋ si laa Yesu wiaa dii aa hilimi, ba vuurɛ a liisɛ ba tuɔŋ niaa, a tiŋba di ba di Pɔɔl ari Banabas mu Aŋtiɔk. Ba liisɛ Judas ba síi yirɛ Basabas ari Saalas. Niaa deeŋba balia nɛ fa ŋaa ba tuɔŋ sipaa-laaraa. ");
INSERT INTO sil_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba joŋ teniŋ piba a tiŋba. Teŋ-la lɛ ba fa ŋmuŋsɛ ŋla nɛ, “La nialiŋ si laa Yesu wiaa dii a ma ŋaa Yesu naŋzɔɔba, ari nialiŋ si ŋaa kuhiasiŋ la tuɔŋ, laa chuɔlɛma, ma nialiŋ si laa Yesu wiaa dii aŋ bi Ju̱u tiŋŋaa ŋaa a hɛ Aŋtiɔk ari Siiria ari Siliisia lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","La nia ari la niaa dɔŋsuŋ kɔ ma teeŋ a walimɛma, a kɛŋ ma tuɔbiinaa vugimɛ. La bi bula piba di ba ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ŋii wiaa la hilime nɛ a vuurɛ. U zɔmɔ pila di la liisɛ niaa a tiŋba ma teeŋ, di ba di la naŋdɔŋsuŋ Banabas ari Pɔɔl nɛ jaŋ kɔ. ");
INSERT INTO sil_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Niaa deeŋba joŋ ba miisiŋ a yɔɔ suuŋ ba fa síi tiŋ la Tiina Yesu Kirisito tiŋtiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","La saa tiŋ Judas ari Saalas. Ba ma jaŋ bula pima wialiŋ titia la si ŋmuŋsa pima. ");
INSERT INTO sil_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wia Diŋ-zɔŋ-la ari la kala kɛŋ nii-bala ari la bi jaŋ joŋ chugi-yuŋi kala chuŋma. Ama u maga di ma to kisinniŋ deeŋba la síi dagɛma nɛ. Ba nɛ ŋla: ");
INSERT INTO sil_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ma sí vuiŋ namia chaŋ, ma sí kuŋ-kala chaliŋ dii, ma sí puna-la kala si suu pimee chaŋ, a sí ba-chɔruŋ ari ha-chɔruŋ wu-ŋaalaa ŋiŋaa. Di ma nɛ wuo liisɛ ma titia wiaa deeŋba lɛ, ma hɛ doluŋ. Ma jaŋ hɔŋ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ŋii nɛ ba ta nialiŋ ba si liisa. Ba sii mu Aŋtiɔk. Ba si mu dimɛ, ba yirɛ nialiŋ kala si laa Yesu wiaa dii aa hilimi, a joŋ teŋ-la piba. ");
INSERT INTO sil_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba si karimɛ teŋ-la, wialiŋ ba si ŋmuŋsa ŋaa ba kɛŋ tuɔtɔruŋ. Ba nyuŋ kala nyaasɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ari Saalas fa ŋaa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. Ba bul wiaa yugɛ piba kiŋkɛŋ. Ba si ŋaa ŋii, ba nyuŋ nyaasɛ, ba wasa chiŋ ba yarida lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nialiŋ dieni mua Aŋtiɔk lɛ. Ŋii nɛ nialiŋ si laa Yesu wiaa dii Aŋtiɔk lɛ taba ari yarifiɛlaa, ba miira mu nialiŋ si tiŋba teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama u ŋaa wu-zɔŋ nɛ a pi Saalas duu dieni Aŋtiɔk lɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔl ari Banabas ma ka Aŋtiɔk lɛ. Niaa dɔŋsuŋ yuga a pɛba lɛ a bul la Tiina Yesu niiŋ wiaa a pi niaa. ");
INSERT INTO sil_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","U ŋii hariŋ nɛ Pɔɔl bula pi Banabas a bul, “Leŋ la miira mu, a na nialiŋ si laa Yesu wiaa dii taŋ kala lɛ la si bul la Tiina Yesu niiŋ wiaa, a na ba síi ŋaa ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas faa chɛ duu kɛŋ Jɔɔŋ ba síi yirɛ Maak kaa pɛ mu. ");
INSERT INTO sil_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ŋii nɛ Pɔɔl biinɛ duu woŋbiiŋ dee di ba kɛnu pɛ ba titia lɛ, bɛɛ wiaa u via duu pɛba lɛ a tiŋ tiŋtiŋŋaa Paŋfiilia lɛ, lee-la ba fa si laa sipaaŋ mu di ba tiŋ, ka u miirɛ. ");
INSERT INTO sil_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ba faasa kɛŋ wiiŋ deeŋ kaa lɛrɛ kiŋkɛŋ, ba pɔrɛ dɔŋɔ lɛ. Ŋii nɛ Banabas kɛŋ Jɔɔŋ Maak. Ba juu liiŋ daboro a duoro mu Saapɔs. ");
INSERT INTO sil_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ka Pɔɔl ma liisɛ Saalas. Nialiŋ si laa Yesu wiaa dii joŋba hɛ Wia nisiŋ lɛ duu bibeŋba. ");
INSERT INTO sil_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ŋii nɛ ba sii mumu a mu yi Siiria ari Siliisia tiŋteeŋ. Ba wasa bul wiaa pi nialiŋ si laa Yesu wiaa dii aa hilimi dimɛ, di ba wasa chiŋ ba yarida lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ŋii nɛ Pɔɔl sii mu Dɛɛbi, a lii dimɛ a mu Lisita. U mu dimɛ ŋii di Yesu haritooroo kubala hɛ dimɛ, baa yirɛ Timoti. U naaŋ fa ŋaa Ju̱u tiina nɛ a ma fa laa Yesu wiaa dii, aŋ ka u nyimma fa ŋaa Giriik tiina. ");
INSERT INTO sil_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nialiŋ si laa Yesu wiaa dii Lisita ari Ikooniam kala lɛ bibɛsɛ baal-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔl faa chɛ di Timoti to u hariŋ. A tiŋ Ju̱u tiŋŋaa si hɛ lere-la lɛ wiaa Pɔɔl kɛnu keri u peniŋ, bɛɛ wiaa ba kala jima ari u nyimma ŋaa Giriik tiina nɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ba síi mu tasi-la ŋii, ba bul wiaa a pi nialiŋ si laa Yesu wiaa dii dimɛ. Ba bula piba wialiŋ Yesu naŋzɔɔba-la ari nialiŋ si laa Yesu wiaa dii kuhiasiŋ Jerusalɛm lɛ si bile piba di ba tuto. ");
INSERT INTO sil_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ŋii nɛ nialiŋ si laa Yesu wiaa dii aa hilimi wasa kɛŋ yarida. Ba ku puŋaa pɛ tapulii kala. ");
INSERT INTO sil_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔɔl ari Saalas gɔllɛ ŋii halii a to Firijia ari Galiisia tiŋteeŋ, bɛɛ wiaa Wia Diŋ-zɔŋ-la biba woŋbiiŋ pa di ba bul Wia niiŋ wiaa Esia tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ka ba joŋ ba woŋbiiŋ a mu yi Maasiya. Dimɛ nɛ ba walimɛ di ba juu Bitiinia tiŋteeŋ, ama Yesu Diŋ-zɔŋ-la biba woŋbiiŋ pa. ");
INSERT INTO sil_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ŋii nɛ ba to Maasiya tiŋteeŋ a mu yi Turɔwas. ");
INSERT INTO sil_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Dimɛ, titaŋiŋ Pɔɔl na ari duosoo tuɔŋ di baal kubala a lii Masidoonia, duu china aa sulu duu kɔ Masidoonia tiŋteeŋ a pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔl si na ŋii dɛrɛ, la duu ŋaa siri di la mu Masidoonia, bɛɛ wiaa la jima ari Wia sɛnɛ dagɛla di la mu bul Wia wu-zɔmɔ-la a pi nialiŋ si hɛ lee-la nɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ba bira sii dimɛ a sii juu liiŋ daboro, a duoro chol tegi tegi a mu Saamɔtas. U taŋ si pula la bira sii a mu Niyapɔlis. ");
INSERT INTO sil_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","La bira lii dimɛ a vɛnɛ mu Filipa. U fa ŋaa ta-bal nɛ Masidoonia sɛmɛ dɔŋɔ a tuto Rom. La hɔŋ taŋ-la lɛ tapulaa baŋmɛnɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Chɛ-wiesii-la chɛɛŋ si yie, la lii taŋ-la tuɔŋ a mu fuoŋ niiŋ. La fa biina la jaŋ na Wia di-chuɔluŋ dimɛ. La si mu dimɛ, la tuu hɔŋ a bul wiaa pipi haala-la fa si hilime dimɛ di ba chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Haala-la si jegile nii la wialiŋ, ba tuɔŋ haal kubala nɛ fa hɛ dimɛ, baa yirɛ Lidia. U fa lii Taataya tiŋteeŋ nɛ. U fa biri gɛnniŋ nɛ a yiyallɛ. U faa chuɔlɛ Wia nɛ. U si jegile nii wialiŋ Pɔɔl fa síi bul, Wia pullɛ u tuɔŋ, u laa wialiŋ dii. ");
INSERT INTO sil_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ba fo ba di u dia niaa Wii-chuɔlɛ liiŋ. Ŋii nɛ haal-la sulla a bul, “Di ma nɛ biina di mi sɛnɛ laa Yesu wiaa dii nɛ, má ku juu chua mi dia lɛ.” U si sulla dieni ŋii, la mu chua. ");
INSERT INTO sil_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Chɛɛ kubala la bira mu Wia di-chuɔluŋ. Yomo toli-bie ku cheŋla. Jima nɛ kɛnu, u vuga pipi niaa. U vuga na moribiee yugɛ a pi nialiŋ si tiiu. ");
INSERT INTO sil_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","U to la di Pɔɔl hariŋ a yie faasaa bul, “Niaa deeŋba tiŋ tiŋtiŋŋaa a pi Wii-baliŋ si yuga a kii kuŋ-kuŋ-kala. Ba bulaa pima ŋii ma si jaŋ ŋaa di Wia laama ta.” ");
INSERT INTO sil_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","U yie ŋaa ŋii tapulii kala. Ŋii nɛ Pɔɔl baaniŋ sii. U miira birima chaasɛ tolo-la, aŋ bula pi jima-la a bul, “Yesu Kirisito doluŋ lɛ mi si, ŋŋ lii aŋ leŋ tolo-la.” Jima-la guu lii tolo-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tolo-la tiŋŋaa si na ari ba bira bi moribie-la ka na, ba kɛŋ Pɔɔl ari Saalas a lɛrɛ mu ba taŋ kuhiasiŋ teeŋ ba si yie hihilimi lee-la. ");
INSERT INTO sil_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba kɛŋba kaa mu ba Rom kuhiasiŋ teeŋ, a bula piba a bul, “Niaa deeŋba ŋaa Ju̱u tiŋŋaa nɛ aŋ wiwalimɛ niaa la taŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Baa dagɛla di laa ŋaa wialaa la Rom tiŋŋaa síi kisu.” ");
INSERT INTO sil_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ni-daŋ-la kala fa si hilime, ba sii pɛ ba nihiasi-la lɛ a kɛŋ Pɔɔl ari Saalas. Ŋii nɛ Rom tiŋŋaa kuhiasiŋ kɛŋ ba gɛnniŋ wuri aŋ bul di ba viirɛba. ");
INSERT INTO sil_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba faasa viirɛba aŋ kɛŋba tɔ dia, aŋ bula pi sarika bibenni-la duu tɔba woruŋ di ba sí wuo lii. ");
INSERT INTO sil_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","U nii ba niiŋ a kɛŋ Pɔɔl ari Saalas a kaa kiele juu sipaaŋ dia tuɔŋ, a kɛŋ ba naasiŋ baliamiŋ kala hɛ kuruŋ. ");
INSERT INTO sil_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ari tita-siesee Pɔɔl ari Saalas chuchuɔlɛ Wia a yii yiilaa a didɛnnɛ Wia. Nialiŋ ba si kaa tɔ dia ku-kaanaa ma jijegili aa nii. ");
INSERT INTO sil_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ŋii nɛ tiŋteeŋ guu zigili a kɛŋ sarika dia-la ma kala kaa zigili. Borusuŋ kala guu suri. Nuu-kala kuruŋ ma lii tel. ");
INSERT INTO sil_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Sarika bibenni-la hirike sii doŋ lɛ a na di sarika-la borusuŋ kala suro. U biina nialiŋ kala ba si kaa tɔ dia, ba lii fá viiri nɛ. U liisɛ u tokobii duu kpu u titia. ");
INSERT INTO sil_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ŋii nɛ Pɔɔl faasa kpia a bula pu a bul, “Sí ŋ titia kpu. La kala nɛ hɛ daha.” ");
INSERT INTO sil_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sarika bibenni-la ŋaa ba kɛŋ chaaniŋ kaa kɔ. U laa fá juu, a tuu tel Pɔɔl ari Saalas naasiŋ lɛ a chichel. ");
INSERT INTO sil_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","U kɛŋba kaa lii a piɛsɛba a bul, “Mi naŋdɔŋsuŋ, ɛɛ nɛ mi jaŋ ŋaa di Wia laami ta?” ");
INSERT INTO sil_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ŋii nɛ ba bula pu a bul, “Laa la Tiina Yesu wiaa dii, di Wia laa ma ari ŋ dia niaa kala ta.” ");
INSERT INTO sil_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ŋii nɛ ba bul la Tiina Yesu niiŋ wiaa pi ba di u dia niaa kala. ");
INSERT INTO sil_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Titaŋ-la titia nɛ sarika bibenni-la kɛŋba a chɛsɛ ba yaraa naawiilaa, ka ba fo ba di u dia niaa kala Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sarika bibenni-la kɛŋ Pɔɔl ari Saalas a kaa mu u dia, a piba kudiilee ba dii. Ba di u dia niaa kala ŋaa tuɔtɔru ari ba si laa Wia wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Taŋ si pula, Rom nihiasiŋ tiŋ di ba mu bula pi porisiba kuhiasiŋ di ba bula pi sarika bibenni-la duu liisɛ Pɔɔl ari Saalas. ");
INSERT INTO sil_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ŋii nɛ sarika bibenni-la bula pi Pɔɔl di Rom nihiasi-la tima di ba bula pu duu liisɛ ba di Saalas. Ŋii wiaa ba jaŋ wuo mu ari yarifiɛlaa. ");
INSERT INTO sil_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ŋii nɛ Pɔɔl bula pi porisi kuhiasi-la a bul, “Ba viirɛla niaa tuɔŋ, aŋ bi la sariya die a dagɛla wu-cheyiŋ, aŋ ka la ma ŋaa Rom tiŋŋaa. Ŋii nɛ ba kɛŋla tɔ dia. Ka lɛɛlɛ baa chɛ di la luɔra viiri. Ai, la bi sɛi. U maga di Rom nihiasi-la titia kɔ daha nɛ a ku liisɛla.” ");
INSERT INTO sil_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ŋii nɛ porisi kuhiasi-la mu bula pi Rom nihiasi-la ari Pɔɔl ari Saalas ma ŋaa Rom timma nɛ. Ba si nii ŋii, fawulluŋ kɛŋba. ");
INSERT INTO sil_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ŋii nɛ ba sii mu sulba ari ba cheye nɛ aŋ liisɛba sarika lɛ, aŋ bula piba di ba lii ba taŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ba lii sarika lɛ a mu Lidia dia. Dimɛ nɛ ba na nialiŋ dɔŋsuŋ si laa Yesu wiaa dii. Ba bul wiaa piba a ŋaa ba nyuŋ nyaasɛ, aŋ viiri. ");
INSERT INTO sil_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ba síi viiri ŋii, ba mu to taŋ kubala baa yirɛ Aŋfiipolis, a bira sii dimɛ a to taŋ dɔŋɔ maa baa yirɛ Apoloonia, a lii dimɛ a mu taŋ kubala baa yirɛ Tɛsalonaaka. Ju̱u tiŋŋaa Wii-chuɔlɛ dia fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔl mu juu Wii-chuɔlɛ dia ari u si vɛnɛɛ ŋaa ŋii lee-na kala. Chɛ-wiesii-la chɛɛŋ yɔsuŋ batori pɛgɛ, ba di niaa vuvuurɛ Wia wiaa. ");
INSERT INTO sil_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","U karimɛ Wia teniŋ piba a dagɛba ŋii ari u si maga di Yesu na hɛɛŋ a suu aŋ bira sii suuŋ lɛ, a bira bula piba ari Yesu deeŋ u si bul u wiaa piba nɛ ŋaa Kirisito. ");
INSERT INTO sil_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nialiŋ dɔŋsuŋ laa wialiŋ dii a pɛ Pɔɔl ari Saalas lɛ. Ba tuɔŋ Giriik tiŋŋaa ari haala-la si ŋaa ni-balaa ba taŋ lɛ ma yuga a laa wialiŋ dii a pɛba lɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ŋii nɛ Ju̱u tiŋŋaa yaraa bibieri. Ba chɛ kɛsɛ nyu-duo tiŋŋaa si yie bibaarɛ woŋbiee ari yɔsuŋ tuɔŋ a pɛ ba titia lɛ. Ba bira chɛ kɛsɛ niaa dɔŋsuŋ, ba kala hilimi di ba kɛŋ taŋ-la kala a vugimɛ. Ba mu juu Jeesiŋ dia di ba chɛ Pɔɔl ari Saalas di ba kɛŋba kaa ku lii niaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba biba naa aŋ kɛŋ Jeesiŋ ari nialiŋ dɔŋsuŋ si laa Yesu wiaa dii a lɛrɛba lii ba taŋ kuhiasiŋ teeŋ, aŋ ŋiŋaa goŋ a bul, “Niaa deeŋba chei lee kala nɛ aŋ lɛɛlɛ kɔ la jaŋ. ");
INSERT INTO sil_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ka Jeesiŋ laaba bil u dia lɛ. Ba kala chei wii-la la kuori-baliŋ si bile nɛ aŋ bul di kuori dɔŋ nɛ hɛ dimɛ, baa yirɛ Yesu.” ");
INSERT INTO sil_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wiaa deeŋba ba si bula ŋaa nialiŋ ari ba taŋ kuhiasiŋ kala bi jiŋ wii-la kala ba si jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ŋii nɛ taŋ kuhiasiŋ ŋaa Jeesiŋ ari u naŋdɔŋsuŋ liisɛ ta-time, aŋ ka ba leŋba. ");
INSERT INTO sil_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Taŋ si bire, nialiŋ si laa Yesu wiaa dii ŋaa Pɔɔl ari Saalas lii mu Biriya. Ba si yi Biriya, ba mu juu Ju̱u tiŋŋaa Wii-chuɔlɛ dia. ");
INSERT INTO sil_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lee-la Ju̱u timma-la kpia Ju̱u timma-la si hɛ Tɛsalonaaka lɛ. Ba chaga laa Wia niiŋ wialiŋ ari na-kpariŋ a kikarimɛ Wia teniŋ ari siifiɛsiŋ tapulii-na kala, di ba na di wialiŋ sɛnɛ ŋaa wutitiiba nɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ba tuɔŋ niaa yuga nɛ laa Yesu wiaa dii. Giriik tiŋŋaa haalaa si ŋaa ni-balaa ari ba baalaa kala laa Yesu wialiŋ dii. ");
INSERT INTO sil_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ju̱u timma-la si hɛ Tɛsalonaaka lɛ nia di Pɔɔl bira bul Wia wiaa Biriya ma lɛ. Ba sii mu dimɛ maa a nyisɛ ni-daŋ-la hɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ŋii nɛ nialiŋ si laa Yesu wiaa dii ŋaa Pɔɔl lii a mu mugi-baliŋ niiŋ, ka Saalas ari Timoti bi mua aŋ hɛ Biriya lɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Niaa dɔŋsuŋ lii Biriya a to Pɔɔl hariŋ, a kɛnu kaa mu Atɛŋ. Pɔɔl miira tiŋba di ba mu bula pi Saalas ari Timoti di ba ku chemu lima. ");
INSERT INTO sil_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔɔl si hɔŋ Atɛŋ lɛ a gbigbɛrɛ Saalas ari Timoti, u na di daalusuŋ su̱ taŋ-la kala lɛ. U tuɔŋ faasa viisi. ");
INSERT INTO sil_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ŋii nɛ Pɔɔl mu Ju̱u tiŋŋaa Wii-chuɔlɛ dia. U bul Wia wiaa pi Ju̱u tiŋŋaa ari nialiŋ síi fá Wia, ba kaa lɛrɛ. U yie juu yɔbɔ maa chɛɛ-na kala a bul Wia wiaa a pi nialiŋ si yie kɔ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kerichiba-la dɔŋsuŋ síi to Epikuuras woŋbiiŋ ari Sitɔik kerichiba dɔŋsuŋ ma ku nau. Niaa dɔŋsuŋ ma piɛsɛ, “Bɛɛ kiaa nɛ ni-yaariŋ deeŋ ma chinaa bul?” Dɔŋsuŋ ma si, “U naga veŋ-falii wiaa nɛ u bubul.” Pɔɔl si yie bul Yesu wiaa ari u si sii suuŋ lɛ nɛ tii ba bul ŋii. ");
INSERT INTO sil_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ŋii nɛ ba kɛnu kaa mu ba si yie hilimi dia-la lɛ baa yirɛ Ariyɔpagis a bul, “La cho di la nii wu-faliŋ deeŋ wiaa ŋ síi dagu nɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wialiŋ dɔŋsuŋ ŋ síi bul ŋaa wu-kpuŋkperisiŋ nɛ la teeŋ. La saa cho di la nii ba bubuɔŋ nɛ woruŋ.” ");
INSERT INTO sil_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛŋ niaa ari ba nuhuɔraa kala bi wii-kala kaa pɛ, see di ba bul wu-falia-la ba si nia a pi niaa, a ma cho di ba jegile nii wu-falaa niaa teeŋ. Ba wiiŋ kala nɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ŋii nɛ Pɔɔl sii chiŋ nialiŋ fa si hilime tutuɔbaaniŋ a bula piba a bul, “Mi si kɔ daha, mi na ari ma cho vuiaa kpaariŋ nɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mi síi gɔllɛ ma taŋ lɛ, mi na ma vesiŋ. Mi bira na koruŋ maa ma si saa. Ŋla nɛ ma tuuro hɛu lɛ, ‘Wia-la la si bi jiŋ di-kpaariŋ lɛ ŋla.’ ” Ŋii nɛ Pɔɔl bira bul, “Wia-la ma síi chuɔlɛ aŋ buu jiŋ, u wiaa nɛ mi bulaa pima ŋii. ");
INSERT INTO sil_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wia-la si ŋaa dunia ari kuŋ-kala si hɛ dimɛ, a ŋaa wia nyuŋ ari tiŋteeŋ kala Tiina, u bi lee-la nuhuobiine si saa aa kpaarɛ vuiaa ka juu. ");
INSERT INTO sil_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","U bi naga u si chɛ kuŋ ka nɛ tii uu chɛ nuhuobiinee tima pu. U nɛ pi nuhuobiinee miisiŋ ari wiese ari kuŋ-kuŋ-kala. ");
INSERT INTO sil_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wia fa ŋaa ni-bala nɛ buŋbuŋ-la. Ni-bala-la lɛ nɛ dunia niaa ta-geŋtisiŋ kala to kɔ. Ba hɔŋ dunia sɛmɛ kala. Ka di u ŋaaba, u nɛ dagɛ bua-la ba si jaŋ kɛŋ miisiŋ, ari lere-la kala ba si jaŋ hɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","U ŋaaba ŋii di ba wuo bee chɛu a lilaarɛ lee-kala di ba nau. Ama Wia saa bi di-bolii hɛ. U kpagɛla kuŋ-kala nɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nuu kubala nɛ bula ari u doluŋ lɛ nɛ la kɛŋ miisiŋ aa vɛŋ a hɛ dimɛ. U saa ŋaa wutitii. Ma gɔgɔ diŋdɛnnɛɛ dɔŋsuŋ ma fa bul ŋii a bul ari la ŋaa u biiriŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","La saa si ŋaa u biiriŋ, u bi maga di la biinɛ Wia nagɛ kialiŋ nuhuobiine si kɛŋ sɛlimɛ kaa mɛ, koo ku-la ba si kɛŋ hɔɔŋ koo tabiiŋ kaa ŋaa nɛ. U bi naga kiaa deeŋba nuhuobiine si kɛŋ u wu-jimiŋ kaa ŋaa nɛ. ");
INSERT INTO sil_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bua-la lɛ nuhuobiinee si buu jiŋ, u fa tɔrikɔ nɛ ba nyuŋ. Ama lɛɛlɛ u bula pipi nuu-kala lee-na kala di ba birima lii ba haachɛba lɛ, ");
INSERT INTO sil_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","bɛɛ wiaa u hɛ tapulii nɛ u si jaŋ dii dunia niaa kala sariya ari tuɔ-bala. U jaŋ to nuhuobiiŋ-la lɛ u si liisa nɛ a dii sariya-la. Nii-la si suba, u chisu suuŋ lɛ, di nuu-kala wuo jiŋ ari wutitii nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nialiŋ si nia ari Pɔɔl bul suuŋ siiniŋ lɛ wiaa, ba dɔŋsuŋ mumɔmu, ama dɔŋsuŋ ma si di ba cho duu maachie bira bul wii-la di ba nii. ");
INSERT INTO sil_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ŋii nɛ Pɔɔl sii a lii lee-la ba si hilime. ");
INSERT INTO sil_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Niaa dɔŋsuŋ laa wialiŋ dii a to u hariŋ. Ba tuɔŋ dɔŋɔ baa yirɛ Dayɔnaasias. U fa hɛ nialiŋ síi hilimi Ariyɔpagis dia-la tuɔŋ dɔŋɔ nɛ. Haal kubala maa baa yirɛ Damaris ari niaa ma dɔŋsuŋ laa wialiŋ dii. ");
INSERT INTO sil_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ŋii nɛ Pɔɔl sii Atɛŋ lɛ a mu taŋ dɔŋɔ baa yirɛ Kɔriŋti. ");
INSERT INTO sil_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","U na baal kubala a lii Pɔŋtɔs, Rom tiŋteeŋ taŋ nɛ, baa yirɛ Akuila. U fa ŋaa Ju̱u tiina nɛ. Ba di u haala Pirisila si lii Rom kɔ, u bi diene. Kuori-baliŋ ba síi yirɛ Kulɔɔdiɔs fa bula pi Ju̱u tiŋŋaa kala di ba lii Rom lɛ. Ŋii nɛ tii ba sii kɔ. Pɔɔl mu ba dia duu chuɔlɛba. ");
INSERT INTO sil_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","U mu juu ba dia a chuchua dimɛ, bɛɛ wiaa ba kala tiŋ tiŋtiŋ-bala nɛ. Ba fa kɛŋ tenniŋ yiyɛrɛ lɛŋŋɛɛ nɛ aa yallɛ moribiee. ");
INSERT INTO sil_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Chɛ-wiesii-la chɛɛŋ kala u yie mu ba Wii-chuɔlɛ dia. Ba di Ju̱u tiŋŋaa ari Giriik tiŋŋaa kɛŋ wiaa lilɛrɛ. U wiwalimɛ di ba sɛi wii-la. ");
INSERT INTO sil_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ŋii nɛ Saalas ari Timoti lii Masidoonia kɔ. Bua-la lɛ ba si kɔ, Pɔɔl joŋ u nyuŋ kala hɛ aa bul Wia wiaa, a dagɛ woruŋ a pi Ju̱u tiŋŋaa ari Yesu nɛ ŋaa Kirisito. ");
INSERT INTO sil_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ŋii nɛ ba lii u hariŋ aŋ tuusu. Ba si ŋaa ŋii, u kpesi u gɛnniŋ kuŋ-kɔlluŋ hɛba lɛ aŋ bula piba a bul, “Ma wu-bɔŋŋɔɔ jaŋ nyua ma nyuŋ lɛ. Mi wii dee. A lii jiniŋ mi jaŋ mu a bul Wia wiaa pi nialiŋ si bi Ju̱u tiŋŋaa ŋaa.” ");
INSERT INTO sil_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","U bul ŋii aŋ sii mu juu baal kubala dia, baa yirɛ Taatis Jasitis. U faa chuɔlɛ Wia nɛ. U dia kpagɛ Wii-chuɔlɛ dia. ");
INSERT INTO sil_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Baal kubala baa yirɛ Kirisipas nɛ fa ŋaa Wii-chuɔlɛ dia-la kuhiaŋ. Ba di u dia niaa kala laa la Tiina Yesu wiaa dii. Niaa ma yuga Kɔriŋti lɛ a nii Wia wialaa a laaba dii. Ba foba Wii-chuɔlɛ liiŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Titaŋ kubala Pɔɔl na ari duosoo tuɔŋ di Wia bula pu a bul, “Sí fawulluŋ fá. Haa bul wiaa pipi niaa a sí leŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mi chiŋ ŋ hariŋ. Nuu-kala bi jaŋ wuo kɛniŋ a ŋaaŋ wu-bɔŋ kala, bɛɛ wiaa mi niaa yuga taŋ deeŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔɔl hɔŋ dimɛ ŋii jina ari lebi a didagɛ Wia wiaa pipi niaa. ");
INSERT INTO sil_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bua-la lɛ baal kubala baa yirɛ Galiɔ nɛ fa ŋaa Giriik kuoro. U fa si dii kuoruŋ ŋii, Ju̱u tiŋŋaa sii hɛ dɔŋɔ lɛ a kɛŋ Pɔɔl, a kɛnu kaa mu ba sariya didiiliŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba bul, “Baala deeŋ walimɛ di niaa sɛi a chuchuɔlɛ Wia woŋbii-la si jaŋ chei la kisiŋ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔl si ŋaa duu bul wiaa, ŋii nɛ Galiɔ bula pi Ju̱u timma-la a bul, “Ju̱u timma, di baala deeŋ nɛ fa ŋaa wii chei, u fa jaŋ kɛŋ woŋbii di mi kɛŋ kenyiri a jegile nii ma teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama u si ŋaa wu-bulii nɛ ma kaa lɛrɛ ari yiraa wiaa, ari ma titia kisinniŋ wiaa, u maga di ma titia kaa mu bula wasɛ nɛ dia lɛ. Mi bi jaŋ wuo laa wiiŋ deeŋ jiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","U kiriba ta ba lii sariya didiiliŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ba kala lii gollo kɛŋ Sɔsitɛnis, nii-la fa si ŋaa Wii-chuɔlɛ dia kuhiaŋ dɔŋɔ, a ŋmobu sariya didilliŋ boiŋniiŋ. Ama Galiɔ sipaa kala fa tuo dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl hɛ Kɔriŋti lɛ a dieni. Ŋii nɛ u sii a chuɔlɛ nialiŋ si laa Yesu wiaa dii Kɔriŋti lɛ aŋ lii. Ba di Pirisila ari Akuila kala sii mu a juu liiŋ daboro di ba mu Siiria tiŋteeŋ. Ka di ba-na juu liiŋ daboro-la, Pɔɔl ta niiŋ Wia teeŋ taŋ kubala baa yirɛ Kɛŋkiriya lɛ aŋ fuŋ u nyuŋ, aŋ-na juu daboro-la. ");
INSERT INTO sil_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba mu yi taŋ kubala baa yirɛ Ɛfɛsis. Dimɛ Pɔɔl leŋ Pirisila ari Akuila aŋ mu juu Wii-chuɔlɛ dia. Ba di Ju̱u tiŋŋaa kɛŋ wialiŋ lilɛrɛ. ");
INSERT INTO sil_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nialiŋ dɔŋsuŋ bul duu hɔŋ ba teeŋ dieni, ka u bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","U si sii dimɛ, u bula piba a bul, “Di Wia nɛ pimi woŋbiiŋ, mi jaŋ miira kɔ ma teeŋ.” Ŋii nɛ u sii mu juu liiŋ daboro a lii Ɛfɛsis lɛ, ");
INSERT INTO sil_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","a mu yi taŋ kubala niiŋ baa yirɛ Sizariya. U sii dimɛ a mu Jerusalɛm, a mu chuɔlɛ nialiŋ si laa Yesu wiaa dii aa hilimi dimɛ. U bira sii dimɛ a mu Aŋtiɔk. ");
INSERT INTO sil_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","U hɔŋ dimɛ a dieni mua a bira sii, a to Galiisia ari Firijia tiŋteeŋ, a bul wiaa pipi nialiŋ si laa Yesu wiaa dii dimɛ di ba wasa kɛŋ yarida. ");
INSERT INTO sil_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ju̱u tiina ma nɛ fa hɛ dimɛ, baa yirɛ Apɔlɔs. U lii Alɛkizaŋdia nɛ. U ma sii kɔ Ɛfɛsis. U fa jiŋ wiaa buluŋ woruŋ a jiŋ Wia teniŋ ma woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba fa dagu la Tiina Yesu woŋbii-la tonuŋ woruŋ. Uu dagɛ Yesu wiaa woruŋ ari siifiaŋ. Wialiŋ kala u si bula aa tigɛ Yesu lɛ ŋaa wutitiiba nɛ. Ari ŋii kala, duu níi bul Wii-chuɔlɛ liiŋ fonuŋ wiaa, Jɔɔŋ Wia lii-foori-la síi fo niaa Wii-chuɔlɛ liiŋ duŋduŋa wiaa nɛ u jiŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U si hɛ Ɛfɛsis lɛ, u bul Wia wiaa ari nyu-duoŋ Wii-chuɔlɛ dia lɛ. Pirisila ari Akuila hɛ dimɛ a nii wialiŋ u síi bul. Ŋii nɛ ba kɛnu kaa mu ba dia a wasa dagu Wia woŋbii-la woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ŋii nɛ Apɔlɔs chichɛ duu mu Giriis tiŋteeŋ. Nialiŋ si laa Yesu wiaa dii Ɛfɛsis lɛ pɛu lɛ a ŋmuŋsɛ teniŋ a pi nialiŋ síi laa Yesu wiaa dii Giriis lɛ, a bula piba di u kɔ ba kɛnu woruŋ. U si mu dimɛ, u puu nialiŋ si laa Yesu wiaa dii, Wia lahɔrimɔ lɛ. U pɛba lɛ woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","U di Ju̱u tiŋŋaa faasa kɛŋ wiaa lilɛrɛ niaa tuɔŋ. U yie kɛŋ nii-doluŋ a joŋ Wia teniŋ dagɛba ari Yesu nɛ ŋaa Kirisito. U bul ŋii a wuo loba. ");
INSERT INTO sil_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apɔlɔs fa si hɛ Kɔriŋti lɛ ŋii, Pɔɔl bira golli ŋii a bira kɔ Ɛfɛsis. U si kɔ dimɛ, u na nialiŋ dɔŋsuŋ si laa Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ŋii nɛ Pɔɔl piɛsɛba, “Wia joŋ u Diŋ-zɔŋ-la hɛma lɛ nɛɛ bua-la lɛ ma si laa Yesu wiaa dii?” Ŋii nɛ ba si, “Ai, la ha bi Wia Diŋ-zɔŋ-la wiaa nia.” ");
INSERT INTO sil_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ŋii nɛ Pɔɔl bira piɛsɛba, “Ni-bɛɛ nɛ ma to ka ba foma Wii-chuɔlɛ liiŋ?” Ŋii nɛ ba bul, “La to wialiŋ Jɔɔŋ Wia lii-foori-la si dagɛla nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ŋii nɛ Pɔɔl bira si, “Nialiŋ si birima lii ba haachɛba lɛ nɛ, Jɔɔŋ fufo Wii-chuɔlɛ liiŋ. U fa bula piba ari nuu jaŋ kɔ u hariŋ, u yiriŋ nɛ Yesu, duu kɔ di ba laa u wiaa dii.” ");
INSERT INTO sil_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ba si nii wiiŋ deeŋ Pɔɔl si bula, ba ŋaa ba foba Wii-chuɔlɛ liiŋ la Tiina Yesu doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ŋii nɛ Pɔɔl joŋ u nisaa daŋba lɛ. U si ŋaa ŋii, Wia Diŋ-zɔŋ-la ku tuu hɛba lɛ. Ba suomo bubul yiikori-yiriba ba si bi jiŋ, a bul Wia wiaa Wia Diŋ-zɔŋ-la doluŋ lɛ maa. ");
INSERT INTO sil_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Niaa deeŋba kala fa ŋaa ari baalaa fii ari balia nɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔl si hɛ Ɛfɛsis lɛ, u vɛnɛɛ juu Wii-chuɔlɛ dia chɛŋsiŋ batori, a chaasa bubul Wia kuorii-la wiaa ari nyu-duoŋ. Ba di niaa kɛŋ wialiŋ lilɛrɛ, u wiwalimɛ di ba sɛi wii-la. ");
INSERT INTO sil_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama nialiŋ dɔŋsuŋ nyuŋ si dolie, ba bi wii-la laa dii, aŋ bubul wu-bɔŋŋɔɔ a tigɛ la Tiina Yesu woŋbii-la tonuŋ wiaa. Nialiŋ si laa Yesu wiaa dii aa hilimi tuɔŋ nɛ ba bul ŋii. Pɔɔl leŋba aŋ kɛŋ nialiŋ si laa Yesu wiaa dii kaa mu. Ba mu juu baal kubala dii-bal baa yirɛ Tiranis. Pɔɔl ari niaa yie kɛŋ wiaa lilɛrɛ dimɛ tapulii-na kala. ");
INSERT INTO sil_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U vɛnɛɛ ŋaa ŋii a yi jisiŋ balia nɛ. Ju̱u tiŋŋaa ari Giriik tiŋŋaa kala si hɛ Esia tiŋteeŋ lɛ wuo nii la Tiina Yesu wiaa. ");
INSERT INTO sil_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wia fa joŋ dol-bal kubala nɛ a pi Pɔɔl, u ŋiŋaa wu-kpuŋkperisiŋ. ");
INSERT INTO sil_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pɔɔl yaraa gɛri-kɔsumɔɔ ma paala ba yie paa kaa mu pi nyanyal tiŋŋaa ba duduori. Di jiŋ-bɔŋŋɔɔ nɛ kɛŋ nuu maa, ba lii tiina lɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ju̱u tiŋŋaa dɔŋsuŋ ma fa hɛ dimɛ a ma fa gɔllɛ aa kiri jiŋ-bɔŋŋɔɔ niaa lɛ. Ba wiwalimɛ di ba ŋaa ŋii la Tiina Yesu doluŋ lɛ nɛ. Ba bula pi jiŋ-bɔŋŋɔ-la a bul, “Mi si, má lii Yesu doluŋ lɛ, nii-la wiaa Pɔɔl síi bul.” ");
INSERT INTO sil_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baalaa balipɛ nɛ faa ŋaa ŋii. Ba nyimma yiriŋ nɛ Sikiiva. U fa ŋaa Ju̱u tiŋŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dɔŋɔ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ŋii nɛ jiŋ-bɔŋ-la bula piba a bul, “Mi jiŋ Yesu a jiŋ Pɔɔl maa, aŋ ka ma ma ŋaa kubɛɛba nɛ?” ");
INSERT INTO sil_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ŋii nɛ jiŋsiŋ si kɛŋ baal-la wuoba. U sii a kɛŋba a ŋmooba woruŋ a pirɛba. Ba gɛnniŋ kala kiɛsɛ. Ba kala fá lii dia-la tuɔŋ ari yaribiree. ");
INSERT INTO sil_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ju̱u timma-la ari Giriik timma-la ari nialiŋ kala si hɛ Ɛfɛsis lɛ nii wiiŋ deeŋ. Fawulluŋ kɛŋba kala. Ba dɛnnɛ la Tiina Yesu woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nialiŋ ma dɔŋsuŋ si laa Yesu wiaa dii yuga kɔ, a ku dagɛ ba wu-bɔmɔ-la ba si ŋaa a pi Pɔɔl, niaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ba tuɔŋ niaa yuga a faa ŋaa daalusuŋ. Ba kala paa tenni-la ba fa si karima aa ŋaa daalusu-la. Ba paa nyigɛ nuu-kala siaa lɛ. Ba si kɛŋ tenni-la kala yaliŋ pɛ dɔŋɔ lɛ, u ŋaa siidi bui bui bui nɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","La Tiina niiŋ wiaa teeli leriŋ kala a dol woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ŋii nɛ Pɔɔl biinɛ ari u jaŋ to Masidoonia tiŋteeŋ ari Giriis tiŋteeŋ a mu Jerusalɛm. Ŋii nɛ u bul, “Di mi nɛ mu dimɛ, u maga di mi mu Rom maa.” ");
INSERT INTO sil_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ŋii nɛ Pɔɔl tiŋ nialiŋ fa si pɛu lɛ ba tuɔŋ balia di ba mu Masidoonia. Timoti ari Irasitas nɛ u tiŋ. Aŋ ka u titia hɔŋ Ɛfɛsis lɛ Esia tiŋteeŋ a dieni mua. ");
INSERT INTO sil_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bua-la lɛ yuosuŋ fa juu Ɛfɛsis lɛ siifiɛsiŋ a tigɛ la Tiina Yesu woŋbii-la tonuŋ wiaa. ");
INSERT INTO sil_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Libiri kubala nɛ fa hɛ dimɛ. U yiriŋ nɛ fa Dɛmiitias. U fa kɛŋ sɛlimɛ nɛ a kaa lilibi kiaa, ba nagɛ ba taŋ veŋ-baliŋ Atɛmis. Tiŋtimiŋ deeŋ lɛ ba di u tiŋtinnaa na moribiee kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Chɛɛ kubala u yirɛ u tiŋtinnaa ari u tiŋtinni-dɔŋsuŋ a bula piba a bul, “Mi naŋdɔŋsuŋ, ma jima ari tiŋtimiŋ deeŋ nɛ ŋaa la kuori. ");
INSERT INTO sil_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma titia nia a nina maa wialiŋ Pɔɔl síi bul. U si, vuia-la nuhuobiinee síi libi, ba bi wia ŋaa. U saa wuo kɛŋ ni-daŋ nyusuŋ birimɛ ba sɛi wii-la. U ŋaa ŋii Ɛfɛsis deeŋ lɛ ari Esia tiŋteeŋ jesiŋ kala lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wii-la la síi fá nɛ ŋla: Niaa jaŋ chei la tiŋtimiŋ deeŋ yiriŋ. La biraa fá ari la veŋ-baliŋ Atɛmis jaŋ ku ŋaa ku-tɔɔ. Niaa bira bi jaŋ zizilu. Lɛɛlɛ Esia niaa ari dunia nuu-kala níi zilu.” ");
INSERT INTO sil_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nialiŋ si nii wii-la, ba baaniŋ sii. Ba ŋaa goŋ a bubul, “La veŋ-baliŋ Atɛmis si hɛ Ɛfɛsis lɛ nɛ kɛŋ doluŋ.” ");
INSERT INTO sil_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ŋii nɛ ba kɛŋ taŋ kala vugimɛ. Ni-daŋ-la kɛŋ Gayas ari Arisitaakis si lii Masidoonia a tuto Pɔɔl hariŋ. Ba lɛrɛba kaa mu lee-la taŋ-la niaa si yie hihilimi. ");
INSERT INTO sil_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ba si kɛŋba kaa mu dimɛ, Pɔɔl fa cho duu mu juu nialiŋ tuɔŋ, ama nialiŋ si laa Yesu wiaa dii bi sɛyɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Esia tiŋteeŋ kuhiasiŋ dɔŋsuŋ si dii Pɔɔl naŋdɔŋsuŋ tiŋ di ba sulu duu sí nialiŋ tuɔŋ juu. ");
INSERT INTO sil_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nialiŋ kala si hilime bi jiŋ wii-la síi ŋaa. Dɔŋsuŋ ŋaa goŋ a bul ŋla nɛ, dɔŋsuŋ ma si wiiŋ deeŋ nɛ. Ba kala jesiŋ paala fa bi jiŋ wii-la si tii ba ku hilimi dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ju̱u tiina kubala nɛ fa hɛ nialiŋ tuɔŋ. Baa yirɛ Alɛkizaŋda. Ju̱u tiŋŋaa leŋe u lii chiŋ ba sipaaŋ nɛ. Ŋii nɛ tii nialiŋ dɔŋsuŋ biinɛ duu ŋaa wii-la tuɔŋ ni-bal nɛ. Ŋii nɛ Alɛkizaŋda kɛŋ u nisiŋ vigi di ba kɛŋ goŋ, aŋ wiwalimɛ duu bula pi nialiŋ di ba di u naŋdɔŋsuŋ bi wii cheye. ");
INSERT INTO sil_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","U síi ŋaa ŋii, ba bene duu ŋaa Ju̱u tiina. Ŋii nɛ ba kala bira ŋaa goŋ a hɛ dɔŋɔ lɛ a yi hawaba balia aa bul, “La veŋ-baliŋ Atɛmis si hɛ Ɛfɛsis lɛ nɛ kɛŋ doluŋ.” ");
INSERT INTO sil_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ŋii nɛ ba taŋ kerichi-hiaŋ dɔŋɔ ku lii a wuo ŋaa ba kɛŋ goŋ. U bula piba a bul, “Ɛfɛsis niaa, nuu-kala nɛ jima ari la taŋ Ɛfɛsis nɛ tii la veŋ-baliŋ Atɛmis ari u di-kpaariŋ kala, a pɛ tabii-la sí lii wia nyuŋ ku tuu tel, la kpikpaarɛ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nuu-kala bi jaŋ wuo kɛŋ wiiŋ deeŋ kaa lɛrɛ. Ŋii wiaa, má leŋ goŋ aŋ sí wii-la si bi bubuɔ kɛnɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Niaa deeŋba bi kuŋ gaa joŋ la veŋ-baliŋ di-kpaariŋ, ba bira bi wii bula chei la veŋ-baliŋ yiriŋ maa, ka ma kɛŋba kaa kɔ daha. ");
INSERT INTO sil_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Di Dɛmiitias ari u tiŋtinnaa nɛ kɛŋ wii ari nuu, sariya kɛŋ u tapul-diilie nɛ, ma taŋ kuhiasiŋ ma hɛ dimɛ di ba dii sariya. Má leŋ di ba mu dimɛ a nyaŋ dɔŋɔ. ");
INSERT INTO sil_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ama di wii dɔŋ ma nɛ hɛ dimɛ maa chɛ di ma bul, má leŋ bua-la taŋ kuhiasi-la si yie kɔ a hilimi di ba bula wasɛ. ");
INSERT INTO sil_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Di ba nɛ piɛsɛla, la bi wii-kala jaŋ wuo bul a tigɛ taawɛi deeŋ wiaa si ŋaa jiniŋ. Wii-la mi síi fá nɛ ŋla, ba jaŋ bul di la nɛ hɛ taawɛi-la.” ");
INSERT INTO sil_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","U si bul ŋii dɛrɛ, u ŋaa nialiŋ fa si hilime sii a viiri. ");
INSERT INTO sil_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ŋii nɛ taawɛi-la dɛrɛ. Ka Pɔɔl yirɛ nialiŋ si laa Yesu wiaa dii Ɛfɛsis lɛ a bul wiaa piba di ba nyuŋ nyaasɛ. U si bul wialiŋ dɛrɛ, u taba aŋ sii mu Masidoonia tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","U gɔllɛ Masidoonia tiŋteeŋ kala a bul wiaa yugɛ piba di ba nyuŋ nyaasɛ. Ŋii nɛ ka u lii dimɛ a mu Giriis tiŋteeŋ. ");
INSERT INTO sil_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","U hɛ Giriis tiŋteeŋ lɛ chɛŋsiŋ batori. Ŋii nɛ u ŋaa siri duu juu liiŋ daboro a mu Siiria tiŋteeŋ. U si ŋaa siri ŋii, u nia ari Ju̱u tiŋŋaa vuurɛ u wiaa di ba kpuu. Ŋii nɛ u kɛŋ u tuɔbiinaa birimɛ a miira sii to Masidoonia. ");
INSERT INTO sil_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Baal kubala nɛ fa to u hariŋ. Baa yirɛ Sopata a lii Biriya. U fa ŋaa Piras bie nɛ. Ka niaa deeŋba: Arisitaakis ari Sɛkuŋdas a lii Tɛsalonaaka, baal kubala maa baa yirɛ Gayas a lii Dɛɛbi, ari Timoti. Niaa balia ma hɛ dimɛ a lii Esia. Baa yirɛ Tikikas ari Turɔfimɔs. ");
INSERT INTO sil_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ba nɛ laa sipaaŋ a mu gbɛrɛla Turɔwas lɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","La hɛ dimɛ bua-la lɛ ba si yie dii boroboro si bi si-buruŋ kɛnɛ. U kieli, ka la sii Filipa lɛ a juu liiŋ daboro, a vɛŋ tapulaa banɔŋ aŋ-na yi Turɔwas. La hɛ dimɛ tapulaa balipɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lahadi chɛɛŋ la kala hɛ dɔŋɔ lɛ a dii kudiile-la Kirisito fa si si di la didii a liliisi u wiaa. U taŋ níi pul di Pɔɔl sii viiri. Ŋii nɛ u bul wiaa deeŋ deeŋ taŋ siesi. ");
INSERT INTO sil_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","La hɔŋ lusuŋ nyuŋ dia lɛ nɛ a nyigɛ chaanaa yugɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bapuɔsi-bie kubala ma hɛ dimɛ. Baa yirɛ Yutikas. U fa hɔŋ tokoro niiŋ nɛ. Pɔɔl si bul wiaa didieni ŋii, u hɔnɔ didiɛgɛ doŋ a joŋo piŋ doŋ, a foro lii lusuŋ nyuŋ dia-la nyuŋ a tuu tel. Ba tuu joŋu duu suba. ");
INSERT INTO sil_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ŋii nɛ Pɔɔl ma sii tuu a ti̱ŋ a guoru, aŋ bula pi nialiŋ a bul, “Ma sí leŋe duu ŋaa wii, u weye nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ŋii nɛ ka Pɔɔl bira jil lusuŋ nyuŋ dia-la ba didii kudiile-la Kirisito fa si si ba didii a liliisi u wiaa. U si dii dɛrɛ, ba bira kɛŋ ba wu-buluŋ halii taŋ-pul. Ŋii nɛ u viiri. ");
INSERT INTO sil_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ba kɛŋ bapuɔsi-bie-la kaa mu dia duu weye. U ŋaaba tuɔtɔruŋ. ");
INSERT INTO sil_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ŋii nɛ la sii a mu juu liiŋ daboro a duoro mu Asɔs. Pɔɔl fa bula pila ari la juu liiŋ daboro a duoro mu Asɔs, ka duu vɛŋ naasiŋ lɛ kɔ a juu liiŋ daboro Asɔs lɛ. Ŋii nɛ la juu liiŋ daboro a mu Asɔs. Dimɛ nɛ la fá mu di la joŋ Pɔɔl. ");
INSERT INTO sil_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pɔɔl si ku puula Asɔs lɛ, la joŋu ari liiŋ daboro a mu to Mitilini. ");
INSERT INTO sil_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","La bira sii dimɛ. U taŋ si pula, la ku yi Kiyɔs. Taŋ dɔŋɔ bira si pula, la ku yi Samɔs. U taŋ si pula, la ku yi Miliitas. ");
INSERT INTO sil_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","La bira sii Miliitas lɛ. Pɔɔl si duu bi jaŋ chiŋ Ɛfɛsis lɛ. U si, u bi chɛ duu dieni Esia tiŋteeŋ, duu faa chɛ duu mu Jerusalɛm lima lima nɛ a puu Pɛŋtikɔs chɛ-gbielii-la dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ŋii nɛ la kiele kɔ Miliitas. Pɔɔl tima yirɛ nialiŋ si laa Yesu wiaa dii aa hilimi kuhiasiŋ Ɛfɛsis lɛ di ba kɔ. ");
INSERT INTO sil_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba si kɔ, u bula piba a bul, “Ma ma jiŋ ŋii mi si naga nɛ, a chiŋ bua-la lɛ mi si bumo kɔ Esia tiŋteeŋ nɛ a kukɔ jiniŋ. ");
INSERT INTO sil_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi si tiŋ tiŋtiŋŋaa pi la Tiina Wia ŋii, mi kɛŋ mi titia muuri nɛ kiŋkɛŋ. Mi ma yel sii-liiriŋ a tiŋ ma wiaa. Mi na hɛɛŋ maa Ju̱u tiŋŋaa teeŋ, ba si yie vuvuurɛ di ba kpumi. ");
INSERT INTO sil_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mi dagɛma wii-na kala si jaŋ pɛma lɛ, mi bi kaa faama. Mi dagɛma Wia wiaa, niaa tuɔŋ ari ma diisiŋ kala ma lɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi bula pi Ju̱u tiŋŋaa ari Giriik tiŋŋaa kala siifiɛsiŋ di ba birima lii ba haachɛba lɛ aŋ ku to Wia, a laa la Tiina Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Wia Diŋ-zɔŋ-la dagɛmi di mi mu Jerusalɛm. U niiŋ lɛ nɛ mi lɛɛlɛ to aa mu ŋla. Mi bi jiŋ wii-la kala si jaŋ ŋaami lɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mi ta jiŋ nɛ ari taŋ-na kala lɛ mi si mua, Wia Diŋ-zɔŋ-la yie bula pimi siifiɛsiŋ ari wiaa jaŋ juumi, di ba kɛŋmi tɔ dia maa. ");
INSERT INTO sil_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama mi si yie beŋ mi miisiŋ, u bi kuŋ-kala ŋaa mi teeŋ. Mi taa chɛ di mi tiŋ tiŋtimii-la dɛrɛ mi Tiina Yesu si si mi tiŋ nɛ. U nɛ si di mi bul Wia wu-zɔmɔ-la a pi niaa, a bula piba ŋii u si jaŋ fába nennige. ");
INSERT INTO sil_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Lɛɛlɛ mi jima ari ma niaa deeŋba mi si yie gɔllɛ ma tuɔŋ a bul Wia kuorii-la wiaa pima, ma bira bi jaŋ kɔ di ma nami. ");
INSERT INTO sil_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Mi si bul Wia wialiŋ pima ŋii, mi bi wialiŋ kala Wia si ŋaa kaa faama. Mi saa bulaa pima siifiɛsiŋ jiniŋ tapuluŋ deeŋ di ma nuu-kala kɔ duu lɛlɛ, mi bi wii cheye. Ma wu-bɔŋŋɔɔ jaŋ nyua ma nyuŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Má beŋ ma titia nyuŋ woruŋ, aŋ pɛ beŋ nialiŋ maa u Diŋ-zɔŋ-la si joŋo hɛ ma nisiŋ lɛ. Má beŋ nialiŋ si laa Yesu wiaa dii a hihilimi nyuŋ, ari pie-daara si yie beŋ u piesee nyuŋ ŋii. Wia nɛ joŋ u titia bie chaliŋ yɔɔba. ");
INSERT INTO sil_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mi jima, di mi nɛ leŋma, ni-bɔŋŋɔɔ jaŋ ku juu ma tuɔŋ, ari guŋgurusuŋ si yie juu pusuŋ tuɔŋ ŋii. Ni-bɔmɔ-la bi jaŋ leŋma, ba jaŋ walimɛma. ");
INSERT INTO sil_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Niaa jaŋ lii ma tuɔŋ maa a kɛŋ wialiŋ kaa birimɛ, a nyisɛ nialiŋ si laa Yesu wiaa dii di ba miirɛ hariŋ a toba. ");
INSERT INTO sil_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ŋii nɛ tii mi si, má beŋ ma titia nyuŋ ŋii. Máa liisi ari mi dagɛma nuu-kala jisiŋ batori nɛ ŋla wiihɛyɛ ari titaŋiŋ kala, a yel sii-liiriŋ ma woruŋ ma wiaa. ");
INSERT INTO sil_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mi lɛɛlɛ joŋma hɛ Wia nisiŋ lɛ nɛ. Wia wu-zɔmɔ-la lahɔrimɔ lɛ u jaŋ pɛma lɛ. U jaŋ wuo pɛma lɛ di ma kɛŋ doluŋ a chiŋ ma yarida lɛ. U jaŋ leŋ di ma wuo dii kialiŋ u si ŋaa bil ma sipaaŋ Wia kuorii-la lɛ a gbigbɛrɛ nialiŋ si laa u wiaa dii lɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mi ha bi ma kuŋ-kala moribiee koo gɛnniŋ biina di mi kaa laa. ");
INSERT INTO sil_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ma titia jima di mi tima woruŋ, a na kialiŋ kala la di mi naŋdɔŋsuŋ síi chɛ. ");
INSERT INTO sil_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi ŋaa ŋii di mi wuo dagɛma di ma faasa tiŋ tiŋtiŋŋaa ŋii, ma jaŋ wuo pɛ puwuoloo lɛ aa liisi ari la Tiina Yesu fa si bul ŋii. U si, ‘Ŋ si joŋ kua pi nia, u nɛ kɛŋ tuɔtɔruŋ a kii ŋ si laa kua nia teeŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔɔl si bul wiaa dɛrɛ, u tuu kpirimi a chuɔlɛ Wia a piba kala. ");
INSERT INTO sil_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ba guoru a yel sii-liiriŋ. ");
INSERT INTO sil_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ba tuɔŋ chei woruŋ, bɛɛ wiaa u fa bula piba ari ba bira bi jaŋ nau. Ŋii nɛ ba kɛnu kaa mu liiŋ daboro leriŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","La ta dɔŋɔ aŋ juu liiŋ daboro. La vɛŋ tegi tegi a mu lee kubala baa yirɛ Kɔs, a bira sii dimɛ. Taŋ si pula la mu lee kubala baa yirɛ Roodis, a bira lii dimɛ a mu Patara. ");
INSERT INTO sil_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dimɛ nɛ la na liiŋ daboro duu mu Fɔniisia. La juu mu. ");
INSERT INTO sil_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","La síi mu ŋii, la na lee kubala la na-gua, baa yirɛ Saapɔs. La kieli dimɛ a mu yi Siiria tiŋteeŋ. La mu chiŋ taŋ kubala lɛ baa yirɛ Taya. Dimɛ nɛ liiŋ daboro-la chɛ duu chiŋ di ba chaarɛ kiaa si hɛ liiŋ daboro-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","La chɛ mu na nialiŋ si laa Yesu wiaa dii dimɛ. La hɔŋ ba teeŋ tapulaa balipɛ. Ba bula pi Pɔɔl Wia Diŋ-zɔŋ-la doluŋ lɛ duu sí Jerusalɛm mu. ");
INSERT INTO sil_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","La si hɔŋ dimɛ tapulaa balipɛ ŋii, la bira lii dimɛ a joŋ la woŋbiiŋ. Baalaa ari ba haalaa ari ba biiriŋ kɛŋla kaa lii taŋ-la tuɔŋ. La kala tuu kpirimi liiŋ niiŋ a chuɔlɛ Wia. ");
INSERT INTO sil_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","La ta dɔŋɔ dimɛ aŋ juu liiŋ daboro, ka ba ma miira mu dia. ");
INSERT INTO sil_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","La lii Taya lɛ a joŋ la woŋbiiŋ a mu taŋ kubala baa yirɛ Pitolimiiyas. La mu chuɔlɛ nialiŋ si laa Yesu wiaa dii dimɛ aŋ chua. ");
INSERT INTO sil_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","U taŋ si pula, la sii a mu Sizariya, a mu juu baal kubala dia baa yirɛ Filip. U fa gɔllɔ bul Wia wiaa nɛ aa pi niaa. U fa ŋaa nialiŋ balipɛ dɔŋɔ nɛ ba fa si liisa Jerusalɛm lɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U fa kɛŋ toloo banɛsɛ nɛ. Ba fa bi balaba jaa aŋ fa bubul Wia wiaa Wia doluŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","La hɛ dimɛ ŋii tapulaa baŋmɛnɛ, di baal kubala lii Judiya tiŋteeŋ a ma kɔ, baa yirɛ Agabɔs. U fa ŋaa nii-la síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","U kɔ la teeŋ a laa Pɔɔl damɛrɛ a kaa vɔɔ u titia naasiŋ ari u nisaa aŋ bul, “Ŋla nɛ Wia Diŋ-zɔŋ-la bul, ‘Ju̱u tiŋŋaa jaŋ kɛŋ damɛrɛ deeŋ tiina a vɔbu ŋla Jerusalɛm lɛ, a joŋu hɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa nisiŋ lɛ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","La si nii wiiŋ deeŋ, la di nialiŋ fa si hɛ dimɛ sul Pɔɔl duu sí Jerusalɛm mu. ");
INSERT INTO sil_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ŋii nɛ Pɔɔl bula piba a bul, “Bɛɛ nɛ tii ma yiyel ŋla a ŋaa mi tuɔŋ chei ŋla? Di ba nɛ jaŋ kɛŋmi vɔɔ, koo di ba nɛ kpumi maa Jerusalɛm lɛ a tiŋ mi Tiina Yesu wiaa, mi sɛyɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","U si bul ŋii, la na ari la buu wuo nyagaa bil. Ŋii nɛ la leŋ aŋ bul, “Wia jaŋ leŋ di wii-kala u síi chɛ u ŋaa duu ŋaa.” ");
INSERT INTO sil_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ŋii nɛ aŋ ka la ŋaa siri a sii mu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nialiŋ dɔŋsuŋ si laa Yesu wiaa dii a lii Sizariya ma to la hariŋ a mu, a kɛŋla kaa mu juu baal kubala dia baa yirɛ Mineesiŋ. U lii Saapɔs nɛ. U laa Yesu wiaa dii bua-la lɛ ba fa si suomo bubul Yesu wiaa pipi niaa nɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","La si yi Jerusalɛm, nialiŋ si laa Yesu wiaa dii dimɛ kɛŋla woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Taŋ si pula, la di Pɔɔl mu di la na Jeems. La mua di nialiŋ kala si laa Yesu wiaa dii kuhiasiŋ kala hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ŋii nɛ Pɔɔl chuɔlɛba aŋ bula piba ŋii kala Wia si pɛu lɛ u tiŋ tiŋtiŋŋaa nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba si nii wiiŋ deeŋ, ba lɔllɛ Wia aŋ bula pi Pɔɔl a bul, “La naaŋbii, bee na Ju̱u tiŋŋaa yuga si laa Yesu wiaa dii. Ba yi niaa bui bui bui a kala tuto wialiŋ woruŋ Moosis fa si ŋmuŋsa bil di niaa tuto. ");
INSERT INTO sil_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba nii ŋ wiaa. Ba si ŋ dagɛ Ju̱u tiŋŋaa kala si hɛ nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuɔŋ di ba via wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, a bira bul di ŋ si di ba sí ba biiriŋ penee keru a sí Ju̱u tiŋŋaa naabalimaba wiaa to. ");
INSERT INTO sil_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ba jaŋ nii ari ŋ kɔ. Bɛɛ nɛ saa la jaŋ ŋaa? ");
INSERT INTO sil_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Saa to la niiŋ wii-la la si si ŋŋ ŋaa. Baalaa banɛsɛ nɛ hɛ daha. Ba ta niiŋ nɛ Wia teeŋ, baa chɛ di ba liisɛ niiŋ deeŋ Wia teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kɛŋ baalaa deeŋba a ma toba lɛ, a ma piisɛ ŋ disinniŋ ta, a ti̱ŋ moribiee di ba ma piisɛ ba disinniŋ ta aŋ fuŋ ba nyusuŋ maa. Ŋ ŋaa ŋii nuu-kala jaŋ wuo to ŋii lɛ jiŋ ari wialiŋ kala ba si bula a tigɛŋ lɛ bi wutitii ŋaa. Ba jaŋ na ari ŋ ma titia ka to wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto nɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama nialiŋ si laa Yesu wiaa dii aŋ bi Ju̱u tiŋŋaa ŋaa, la ŋmuŋsɛ teniŋ a bula piba di ba sɛyɛ di ba bira sí vuiŋ namia chaŋ, di ba bira sí pusuŋ chaliŋ ma dii, a sí pusuŋ si suu pimee dii, a liisɛ ba titia ba-chɔruŋ ari ha-chɔruŋ wu-ŋaalaa lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pɔɔl naŋdɔŋsuŋ si bul ŋii, u taŋ-pul, Pɔɔl kɛŋ baala-la banɛsɛmiŋ mu, ba kala piisɛ ba disinniŋ ta aŋ juu Wia-dia. U dagɛ nialiŋ si kpu pusuŋ pipi Wia tapulaa magɛ ŋii ba si jaŋ piisɛ ba disinniŋ ta, ka di ba kuŋ-kala-na kpu pusuŋ pi Wia. Tapulaa balipɛ nɛ u dagɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tapulaa balipɛ-la síi yi, Ju̱u tiŋŋaa dɔŋsuŋ si lii Esia na Pɔɔl duu hɛ Wia-dia lɛ. Ba nyisɛ ni-daŋ hɛ ba kɛŋ Pɔɔl. ");
INSERT INTO sil_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ba faasa kpia a bul, “Iziral timma, má ku pɛla lɛ. Baal-la si gɔllɛ lee kala a didagɛ wiaa lee-na kala a chichei la niaa síi to woŋbii-la, aa chei Moosis fa si ŋmuŋsɛ wialiŋ bil di niaa tuto maa, a bul wu-bɔŋŋɔɔ a tigɛ Wia-dia deeŋ ma lɛ, u níi kɔ daha ŋii. U paala kɛŋ Giriik tiŋŋaa kaa ku juu Wia-dia-la, a ŋaa leriŋ deeŋ kɛŋ disinniŋ.” Wii-la si tii ba bul ŋla: ");
INSERT INTO sil_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ba fa na baal kubala duu to Pɔɔl hariŋ taŋ-la lɛ. U yiriŋ nɛ Turɔfimɔs a lii Ɛfɛsis. Ba fa biina Pɔɔl kɛnu kaa juu Wia-dia-la nɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ŋii nɛ taawɛi sii taŋ-la kala lɛ, nialiŋ kala to dɔŋɔ a kɛŋ Pɔɔl a kɛnu kaa lɛrɛ lii Wia-dia-la lɛ. Ŋii nɛ aŋ ka ba guu kɛŋ Wia-dia-la boiŋniiree tɔ. ");
INSERT INTO sil_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ba síi walimɛ di ba kpuu, Rom laali-yuoroo kuhiaŋ nii ari taawɛi sii Jerusalɛm kala lɛ. ");
INSERT INTO sil_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","U si nii ŋii, u sii a guu liisɛ laali-yuoroo dɔŋsuŋ ari ba kuhiasiŋ, ba fá mu taawɛi-la leriŋ. Nialiŋ si nau ari laali-yuoro-la, ba bira bi Pɔɔl ŋmobo. ");
INSERT INTO sil_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Laali-yuoroo kuhiaŋ-la mu kɛŋ Pɔɔl, a ŋaa ba kɛŋ chɔrumɔɔ balia kaa vɔbu. Ŋii nɛ u piɛsɛ nialiŋ a bul, “Kubɛɛ nɛ nia deeŋ? Bɛɛ nɛ u ŋaa chei?” ");
INSERT INTO sil_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ba kala ŋaa goŋ. Dɔŋsuŋ bubul wiiŋ deeŋ, dɔŋsuŋ ma bul wiiŋ deeŋ. Niaa fa síi ŋaa goŋ ŋii, laali-yuoroo kuhiaŋ-la bi wii-la si paala ŋaa wuo jiŋ. Ŋii nɛ u ŋaa u niaa kɛŋ Pɔɔl kaa mu laali-yuoroo dii-duoŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ba si yi dia-la lusuŋ choluŋ, nialiŋ kɛŋ Pɔɔl lilɛrɛ a wiwalimɛ di ba kpuu, ŋii nɛ laali-yuoro-la joŋu chuŋ. ");
INSERT INTO sil_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nialiŋ kala to u hariŋ a ŋaa goŋ a bubul, “Má kpuu.” ");
INSERT INTO sil_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ba si jil lusuŋ chol-la a chichɛ di ba juu dia-la, ŋii nɛ Pɔɔl sul laali-yuoroo kuhiaŋ-la duu leŋ duu bul wii pu. Ŋii nɛ laali-yuoroo kuhiaŋ-la piɛsɛ Pɔɔl a bul, “Ŋii-na ŋ nii Giriik wu-buluŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ŋ dee bi Ijipiti tiŋŋaa baal-la ŋaa, baal-la si suomo ŋaa taawɛi aŋ kɛŋ niaa bui banɛsɛ-la si kpu niaa a kaa mu giri-bine tuɔŋ?” ");
INSERT INTO sil_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔl si, “Ai, mi ŋaa Ju̱u tiina nɛ a lii Taasis, Siliisia tiŋteeŋ ta-baliŋ. Mii suluŋ di ŋ leŋ di mi bul wiaa pi nialiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ŋii nɛ u pu woŋbiiŋ. Pɔɔl si chiŋ lusuŋ chol-la lɛ ŋii, u kɛŋ u nisiŋ vigi di nialiŋ kɛŋ goŋ. Ŋii nɛ ba kala ŋaa fuii. Pɔɔl suomo bubul wiaa Ju̱u tiŋŋaa yiikoro lɛ. ");
INSERT INTO sil_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ŋii nɛ u bula piba a bul, “Mi nyimmaba ari mi naaŋbiiriŋ, má jegile nii wii-la mi si kɛnɛ di mi bula laa mi titia.” ");
INSERT INTO sil_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ba si nia duu bul wiaa ari ba yiikoro, ba kala ŋaa fuii. Ŋii nɛ Pɔɔl bul, ");
INSERT INTO sil_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mi ŋaa Ju̱u tiina nɛ. Ba lulmi Taasis lɛ, Siliisia tiŋteeŋ. Mi haŋbiiriŋ lɛ nɛ ba kɛŋmi kaa kɔ daha a beŋmi. Gamiilial nɛ dagɛmi. U dagɛmi la naabalimaba woŋbii-la ba síi to ari siifiɛsiŋ. Mi tou woruŋ a joŋ mi titia pi Wia, ari ma ma si hɛ daha jiniŋ si ŋaa ŋii. ");
INSERT INTO sil_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi ma to a dɔgisɛ nialiŋ fa síi to Yesu woŋbii-la a chichɛ di mi kpuba. Mi ŋaa ba kɛsɛba vɔɔba a kɛŋba tɔ dia, baalaa ari haalaa kala. ");
INSERT INTO sil_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nialiŋ si kpu pusuŋ a pipi Wia kuhiaŋ, ari kuhiasi-la kala si yie hilime vuvuurɛ wiaa ma jaŋ wuo bula pima ari wiiŋ deeŋ mi si bula ŋaa wutitii nɛ. Ba ŋmuŋsɛ tenniŋ pimi di mi kaa mu Damaasikas a joŋo pi Ju̱u timma-la si hɛ dimɛ. Ba ŋaa ŋii di mi wuo kɛsɛ nialiŋ si laa Yesu wiaa dii dimɛ a vɔɔba, a kaa kɔ Jerusalɛm a dɔgisɛba daha.” ");
INSERT INTO sil_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ŋii nɛ Pɔɔl bira bul, “Mi si lii joŋ woŋbiiŋ aa mu Damaasikas a mu kpagɛ taŋ-la ari wiihɛi-siesee, pulumuŋ guu lii wia nyuŋ a faasa chaana hɛmi lɛ. ");
INSERT INTO sil_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi tuu tel tiŋteeŋ aŋ nii nii-la yiikoro duu bul mi teeŋ a bul, ‘Sɔɔl, Sɔɔl, bɛɛ nɛ tii ŋ to mi naasiŋ a dudɔgisɛmi ŋla?’ ");
INSERT INTO sil_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ŋii nɛ mi piɛsɛ, ‘Kubɛɛ nɛ, tiina?’ Yiikori-la bul, ‘Mi-na Yesu si lii Nazarɛt, nii-la ŋ síi to u naasiŋ a dudɔgisɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","La di nialiŋ fa síi vɛŋ, ba na puluŋ-la, aŋ bi nii-la fa síi bul wiaa mi teeŋ yiikoro nia. ");
INSERT INTO sil_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ŋii nɛ mi piɛsɛ, ‘Mi ŋii mi Tiina?’ Mi Tiina bira bul, ‘Sii juu Damaasikas. Dimɛ ba jaŋ dagiŋ wii-la kala mi si liisiŋ di ŋ ŋaa.’ ");
INSERT INTO sil_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Puluŋ-la chuulɛ mi siaa, mi bira bi naa, ŋii nɛ la di nialiŋ fa síi vɛŋ kɛŋ mi nisiŋ lɛ a lɛrɛ juu Damaasikas. ");
INSERT INTO sil_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Baal kubala fa hɛ dimɛ, baa yirɛ Ananayas. U faa fá Wia nɛ a tuto wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto. Ju̱u timma-la kala fa si hɛ Damaasikas lɛ zizilu. ");
INSERT INTO sil_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","U kɔ mi teeŋ a chiŋ mi sɛmɛ a bula pimi a bul, ‘Mi naaŋbii Sɔɔl, kɛŋ ŋ siaa suri.’ Bua-la titia lɛ mi siaa suri, mi bee nau. ");
INSERT INTO sil_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ŋii nɛ Ananayas bula pimi a bul, ‘Wia-la la di la naabalimaba síi to nɛ liisiŋ di ŋ jiŋ wii-la u síi chɛ di ŋ ŋaa. U leŋ ŋ na Wia Tuɔ-pul Tiina a nii u yiikoro maa u si bul wiaa piŋ. ");
INSERT INTO sil_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ŋ jaŋ ŋaa u siada tiina, a bula pi niaa wii-la ŋ si nia aŋ pɛ naa. ");
INSERT INTO sil_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bɛɛ nɛ saa tii ŋ hɔnɔ dieni? Sii mu a leŋ di ba foŋ Wii-chuɔlɛ liiŋ a fo ŋ haachɛba ta Yesu doluŋ lɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ŋii nɛ mi miira mu Jerusalɛm a juu Wia-dia a chuchuɔlɛ Wia. Mi síi chuɔlɛ Wia ŋii, ");
INSERT INTO sil_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mi na la Tiina Yesu ari duosoo tuɔŋ. U bula pimi a bul, ‘Sii lii Jerusalɛm lɛ lima, bɛɛ wiaa nialiŋ si hɛ daha bi jaŋ sɛi mi wialiŋ ŋ si jaŋ bula piba.’ ");
INSERT INTO sil_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ŋii nɛ mi bula pi Yesu a bul, ‘Mi Tiina, ba jima woruŋ di lee-na kala mi si mua, mi yie juu Wii-chuɔlɛ diisiŋ a kɛsɛ nialiŋ si laa ŋ wiaa dii dimɛ, a ŋmooba aŋ kɛŋba tɔ dia. ");
INSERT INTO sil_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Bua-la lɛ ba si kpu Sitiiviŋ, nii-la fa si ŋaa ŋ siada tiina a bul ŋ wiaa pipi niaa, mi-na Pɔɔl ma fa hɛ dimɛ a sɛi di ba kpuu. Ba síi kpuu, mi nɛ fa pɔ niaa deeŋba gɛnniŋ ba si wuro, aŋ ka ba kpuu.’ ");
INSERT INTO sil_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ŋii nɛ mi Tiina bula pimi a bul, ‘Sii daha, mi jaŋ timiŋ di ŋ mu di-bolii, nialiŋ si bi Ju̱u tiŋŋaa ŋaa leriŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pɔɔl fa síi bul wiaa ŋii, nialiŋ kala fa jegile nii. Ama u si bul wiiŋ deeŋ, ba bira suomo ŋaa goŋ a bul, “Má kpu ni-tɔɔŋ deeŋ, u bi maga duu hɛ dunia lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ba ŋiŋaa goŋ, aŋ kɛŋ ba gɛnniŋ kpikpesi a ŋaa hagila yuyuo. ");
INSERT INTO sil_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ŋii nɛ Rom laali-yuoroo kuhiaŋ-la bul di laali-yuoro-la kɛŋ Pɔɔl kaa juu laali-yuoroo dii-duo-la. U si di ba viiru aŋ piɛsa na wii-la si tii ba kala lii u hariŋ aŋ ŋiŋaa goŋ ŋla. ");
INSERT INTO sil_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ŋii nɛ ba vɔbu di ba viiru. Ba síi chɛ di ba viiru, Pɔɔl piɛsɛ laali-yuoroo kuhiaŋ-la fa si chiŋ dimɛ a bul, “U maga di ba viirɛ nuu si ŋaa Rom tiina aŋ bi u sariya die, a dagu u wu-cheeliŋ koo?” ");
INSERT INTO sil_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U si nii wii-la Pɔɔl si bula, u ma bira mu u kuhiaŋ teeŋ a bula pu a bul, “Bee na ŋ síi chɛ di ŋ ŋaa wii-la, baal-la ŋaa Rom tiina nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ŋii nɛ laali-yuoroo kuhiaŋ-la titia sii kɔ Pɔɔl teeŋ a piɛsu, “Ŋ ŋaa Rom tiina nɛɛ? Bula pimi.” Ŋii nɛ Pɔɔl si, “Oo.” ");
INSERT INTO sil_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Laali-yuoroo kuhiaŋ-la ma bul, “Mi ma ŋaa dɔŋɔ nɛ. Mi ta ti̱ŋ moribiee yugɛ nɛ aŋ-na ku ŋaa Rom tiina.” Ŋii nɛ Pɔɔl si, “Ba paala lulmi di mi ŋaa Rom tiina nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ŋii nɛ nialiŋ fa síi chɛ di ba viirɛ Pɔɔl aŋ piɛsu, ba suusa lii u teeŋ lima lima. Laali-yuoroo kuhiaŋ-la si ku jiŋ ari Pɔɔl ŋaa Rom tiina nɛ, ka u ŋaa ba kɛŋ chɔrumɔɔ kaa vɔbu, fawulluŋ kɛnu maa. ");
INSERT INTO sil_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ŋii nɛ laali-yuoroo kuhiaŋ-la chichɛ duu sɛnɛ jiŋ wii-la si tii Ju̱u tiŋŋaa bubul Pɔɔl teeŋ ŋii. U taŋ si pula u ŋaa ba kɛnu puri, a ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari kuhiasi-la si yie hilimi a vuvuurɛ wiaa ku hilimi. Ba si hilimi ŋii, u kɛŋ Pɔɔl kaa lii a ŋaa u chiŋ ba sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔl fa si chiŋ ŋii, u chaarɛ u siaa pɛ nialiŋ fa si yie hilime vuvuurɛ wiaa lɛ aŋ bula piba a bul, “Mi naaŋbiiriŋ, mi to Wia mi miisiŋ kala lɛ nɛ. Mi si tou, mi tuɔbiinaa kala yie chesi nɛ a kaa kɔ tapuluŋ deeŋ.” ");
INSERT INTO sil_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ŋii nɛ nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ dɔŋɔ, baa yirɛ Ananayas, bula pi nialiŋ si china kpagɛ Pɔɔl di ba ŋmoo u niiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ba si ŋmobu ŋii, Pɔɔl ma bula pu a bul, “Ŋ lɔrɔ nagɛ jeeŋ si yɛrɛ, ka ba ŋaa tuɔruŋ bugɛ nɛ di niaa sí na. Wia ma jaŋ ŋmobuŋ ŋii. Ŋ hɔnɔ di ŋ to wialiŋ ba si ŋmuŋsa bil di la tuto nɛ a didii mi sariya, aŋ ka ŋ bul di ba ŋmoomi a chei wialiŋ ŋii.” ");
INSERT INTO sil_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nialiŋ si china kpagɛ Pɔɔl piɛsu a bul, “Nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ nɛ ŋ tuusɛ ŋii?” ");
INSERT INTO sil_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ŋii nɛ Pɔɔl bira bul, “Mi naaŋbiiriŋ, ma kiaa sima. Ba ŋmuŋsɛ Wia teniŋ tuɔŋ ari u bi maga di la bul wu-bɔŋŋɔɔ a pi nii-la síi beŋ niaa. Mi bi jiŋ ari u nɛ ŋaa nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ.” ");
INSERT INTO sil_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔɔl si bene nialiŋ si yie hilime vuvuurɛ wiaa tuɔŋ, u na ari dɔŋsuŋ ŋaa nialiŋ ba síi yirɛ Sadusii tiŋŋaa, dɔŋsuŋ ma ŋaa Farisii tiŋŋaa. Ŋii nɛ u faasa bul nialiŋ si yie hilime vuvuurɛ wiaa teeŋ a bul, “Mi naaŋbiiriŋ, mi ma ŋaa Farisii tiina nɛ, nii-la si lulmi ma ŋaa Farisii tiina nɛ. Mi laa dii ari nialiŋ si suba jaŋ sii suuŋ lɛ a kɛŋ miisiŋ. Ŋii nɛ tii baa dii mi sariya.” ");
INSERT INTO sil_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","U si bul wiiŋ deeŋ, Farisii timma-la ari Sadusii timma-la bira bi nii-bala kɛnɛ. Ba pɔrɛ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusii tiŋŋaa si di nuu nɛ suba, u bira bi jaŋ sii suuŋ lɛ a kɛŋ miisiŋ, a bira bul di Wia tiŋdaaraa ma tuo, di ni-diŋsiŋ ma tuo, ka Farisii tiŋŋaa si di ba kala hɛ dimɛ, di nuu ma nɛ suba, u jaŋ sii suuŋ lɛ a kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ŋii nɛ nialiŋ sii a faasa ŋiŋaa goŋ. Wia teniŋ kerichiba-la dɔŋsuŋ si hɛ Farisii niaa paati-la tuɔŋ sii a faasa kɛŋ wialiŋ lilɛrɛ a bul, “La bi na baala deeŋ si ŋaa wii-la chei. U naga ari ni-dima nɛ koo Wia tiŋdaara nɛ sɛnɛ bul wiaa pupu, la bi u-na jiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ŋii nɛ ba kɛŋ wii-la faasa lɛrɛ, leriŋ kala hosi. Fawulluŋ kɛŋ laali-yuoroo kuhiaŋ-la ari ba jaŋ kɛŋ Pɔɔl lɛrɛ puɔsɛ. Ŋii nɛ u ŋaa u laali-yuoroo juu nialiŋ tuɔŋ a loriko laau nialiŋ teeŋ, a kɛnu kaa mu laali-yuoroo dii-duo-la. ");
INSERT INTO sil_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","U taŋ si bire, titaŋ-la titia la Tiina Yesu kɔ Pɔɔl teeŋ, a chiŋ u sɛmɛ, a bula pu a bul, “Nyirɛ ŋ bɔyɛ. U maga di ŋ dii mi siada a bul mi wiaa Rom lɛ ari ŋ si bul mi wiaa ŋii Jerusalɛm lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","U taŋ si pula, Ju̱u tiŋŋaa dɔŋsuŋ hilimi dɔŋɔ lɛ a vuurɛ di ba kpu Pɔɔl. Ba ta niiŋ nɛ ari ba nɛ buu kpua, ba bi jaŋ dii kiaa. Ba bi jaŋ nyua liiŋ maa. ");
INSERT INTO sil_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nialiŋ fa si vuurɛ wiiŋ deeŋ kii niaa mahiŋ balia. ");
INSERT INTO sil_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ŋii nɛ ba mu nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari nialiŋ kuhiasiŋ teeŋ a bula piba a bul, “La ta niiŋ nɛ di la nɛ bi Pɔɔl kpua, la bi jaŋ dii kiaa. ");
INSERT INTO sil_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ma di nialiŋ si yie hilime vuvuurɛ wiaa kuhiasiŋ saa tiŋ di ba bula pi Rom laali-yuoroo kuhiaŋ-la duu leŋ di Pɔɔl kɔ ma teeŋ. Ma fugi ari maa chɛ di ma wasa dii u sariya nɛ. La jaŋ ŋaa siri duu nɛ leŋe u kukɔ, u bi jaŋ yima, ka di la kpuu.” ");
INSERT INTO sil_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pɔɔl dihaala bie ma nii ba síi vuurɛ ŋii, a mu juu laali-yuoroo dii-duo-la a bul wii-la pi Pɔɔl. ");
INSERT INTO sil_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ŋii nɛ Pɔɔl yirɛ laali-yuoroo kuhiaŋ dɔŋɔ a bula pu a bul, “Kɛŋ bapuɔsi-bie deeŋ kaa mu ma kuhiaŋ teeŋ, u kɛŋ wii nɛ duu bula pu.” ");
INSERT INTO sil_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ŋii nɛ u kɛnu kaa mu ba kuhiaŋ teeŋ a bula pu a bul, “Pɔɔl, nii-la ba si kaa tɔ dia nɛ yirɛmi a bula pimi di mi kɛŋ bapuɔsi-bie deeŋ kaa kɔ ŋ teeŋ, duu kɛŋ wii nɛ duu bula piŋ.” ");
INSERT INTO sil_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ŋii nɛ kuhiaŋ-la kɛŋ bile nisiŋ lɛ a kɛnu lii mua, a fiɛla piɛsu di wu-bɛɛ nɛ u kɛŋ di u bula pu? ");
INSERT INTO sil_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ŋii nɛ u bul, “Ju̱u tiŋŋaa vuurɛ nɛ di ba bula piŋ di ŋ chie leŋ di Pɔɔl kɔ nialiŋ si yie hilime vuvuurɛ wiaa kuhiasiŋ teeŋ. Baa fugi ari baa chɛ di ba wasa dii u sariya nɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Saa sí sɛi, bɛɛ wiaa nialiŋ dɔŋsuŋ jaŋ faa woŋbiiŋ lɛ a gbɛru. Ba kii niaa mahiŋ balia. Ba ta niiŋ nɛ di ba bi Pɔɔl kpua, ba bira bi jaŋ dii kiaa, ba bi jaŋ nyua liiŋ maa. Ba ŋaa siri nɛ di ŋ nɛ pu woŋbiiŋ duu kukɔ.” ");
INSERT INTO sil_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","U si bul ŋii dɛrɛ, kuhiaŋ-la bula pi bapuɔsi-bie-la a bul, “Sí bula pi nuu-kala ari ŋ bul wiiŋ deeŋ pimi,” aŋ ŋaa u viiri. ");
INSERT INTO sil_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ŋii nɛ laali-yuoroo kuhiaŋ-la yirɛ u laali-yuoroo kuhiasiŋ balia a bula piba a bul, “Má liisɛ laali-yuoroo zɔ-balia di ba ŋaa siri di ba di Pɔɔl mu Sizariya, a pɛ ja-jillaa mahiŋ batori ari fii lɛ, ari nialaa ma si kɛŋ tiŋŋee zɔ-balia. Leŋ di ba ŋaa siri di ba lii titaŋiŋ deeŋ kerifi nibi lɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Má chɛ janiŋ a liisa pi Pɔɔl duu ma jil, a kɛnu woruŋ a kaa mu Sizariya, a kɛnu kaa mu hɛ tiŋtee-la kuoro Fiilis nisiŋ lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ŋii nɛ ka laali-yuoroo kuhiaŋ-la ŋmuŋsɛ teniŋ a piba di ba kaa mu pi kuoru-la a tiŋ wiiŋ deeŋ wiaa. Ŋla nɛ u bul teŋ-la lɛ: ");
INSERT INTO sil_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mi-na Kulɔɔdiɔs Lisias nɛ ŋmuŋsɛ teniŋ deeŋ a pipi mi nyimma kuoro Fiilis. Mii chuɔluŋ woruŋ. ");
INSERT INTO sil_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Baala deeŋ mi si ŋaa ba kaa kɔ ŋ leriŋ, Ju̱u tiŋŋaa nɛ fa kɛnu di ba kpuu. Ba síi chɛ di ba ŋaa ŋii, mi nii ari u ŋaa Rom tiina nɛ. Ŋii nɛ mi kɛŋ mi laali-yuoroo mu, la loriko laau ba nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mi faa chɛ di mi nii wii-la si tii ba bubul u teeŋ. Ŋii nɛ mi kɛnu kaa mu ba nihiasiŋ si yie hɔnɔ vuvuurɛ wiaa teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ba si piɛsu wiaa, mi na ari u bi wii-kala cheye a magɛ di ba kpuu koo di ba kɛnu tɔ dia. Wii-la si tii ba bubul u teeŋ tigɛ ba titia kisinniŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ba si bula pimi ari Ju̱u tiŋŋaa dɔŋsuŋ vuura nɛ di ba kpuu, ŋii nɛ mi si di ba kɛnu kaa ku piŋ lima lima. Mi saa bula pi nialiŋ síi bul u teeŋ nɛ di ba kɔ ŋ teeŋ, a ma dagɛ wii-la u si ŋaa chei a piŋ.” ");
INSERT INTO sil_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","U si ŋmuŋsɛ teŋ-la dɛrɛ, laali-yuoro-la ŋaa ŋii u si bula piba. Titaŋ-la ba kɛŋ Pɔɔl kaa mu yi taŋ kubala baa yirɛ Aŋtipatis. ");
INSERT INTO sil_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","U taŋ si pula, laali-yuoro-la síi vɛŋ naasiŋ lɛ nɛ miira kɔ ba dii-duo-la, aŋ ka janiŋ tiŋŋaa kɛnu mu Sizariya. ");
INSERT INTO sil_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ba si yi dimɛ, ba joŋ Pɔɔl pi ba tiŋteeŋ kuoro, a joŋ teŋ-la ma pɛ. ");
INSERT INTO sil_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ŋii nɛ kuoru-la karimɛ teŋ-la aŋ piɛsɛ Pɔɔl lee-la u si lia. U bul duu lii Siliisia nɛ. U si nii ŋii, ");
INSERT INTO sil_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","u bula pu a bul, “Bua-la lɛ nialiŋ síi bul ŋ teeŋ nɛ kɔ, mi jaŋ nii wii-la ŋ si kɛnɛ di ŋ bul, aŋ ka di mi-na dii ŋ sariya.” Ŋii nɛ u ŋaa ba kɛŋ Pɔɔl mu hɛ dii-bal-la Hɛrɔd si saa, a ŋaa laali-yuoroo pupɔu dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tapulaa banɔŋ si kiele, nialiŋ si kpu pusuŋ pipi Wia kuhiaŋ baa yirɛ Ananayas sii mu Sizariya, kuoro Fiilis teeŋ. Ba di nialiŋ kuhiasiŋ dɔŋsuŋ ari sariya didiire kubala baa yirɛ Tatulas, ba kala nɛ mua. Ba si mu u teeŋ, ba suomo bubul wii-la si tii ba bubul Pɔɔl teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tatulas nɛ ba laa sipaaŋ yirɛ duu dagɛ wii-la Pɔɔl si ŋaa chei. Ŋla nɛ u suomi, “Mi nyimma, ŋ nɛ wuo bibeŋla woruŋ a leŋ la hɔŋ ari yarifiɛlaa. Ŋ si wuo bibeŋla ŋii, ŋ wasɛ wiaa yugɛ a pila ba zɔmɔ la tiŋteeŋ deeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","La taŋ sɛmɛ-na kala la tuɔŋ tɔrɔ woruŋ wiiŋ deeŋ lɛ bua-na kala lɛ nɛ. La saa lɔlluŋ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi bi chɛ di mi bul wiaa dieni. Mi saa suluŋ di ŋ kɛŋ kenyiri aŋ jegile nii wii-la la si kɛnɛ di la bul. La jaŋ keri wii-la la si jaŋ bul kuii. ");
INSERT INTO sil_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","La na di baala deeŋ ŋaa wu-hɛɛru nɛ. Ju̱u tiŋŋaa si hɛ dunia sɛmɛ-na kala lɛ, u yie mu lee-la a ŋaa taawɛi. U nɛ ŋaa Nazarɛt niaa paati kuhiaŋ maa. ");
INSERT INTO sil_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","U faa chɛ duu ma ŋaa disinniŋ nɛ Wia-dia lɛ. Ŋii nɛ la kɛnu a faa chɛ di la dii u sariya la naabalima woŋbii-la lɛ la síi to ŋii. ");
INSERT INTO sil_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ŋii nɛ laali-yuoroo kuhiaŋ ba síi yirɛ Lisias ku hosi a kɛnu loriko laa la teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","U nɛ bula pi la nialiŋ kala síi bul Pɔɔl teeŋ di la kɔ ŋ teeŋ a bula piŋ wii-la si tii la bubul u teeŋ. Di ŋ nɛ piɛsɛ baala deeŋ, ŋ titia jaŋ jiŋ ari wialiŋ kala la si bula a tigɛu lɛ ŋaa wutitii nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ŋii nɛ Ju̱u tiŋŋaa ma sii pɛ a bul di wii-la kala u si bula ŋaa wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ŋii nɛ tiŋteeŋ kuoru-la liisi Pɔɔl duu bul wii-la u ma si kɛnɛ duu bul. Ŋii nɛ u bul, “Mi jima ari ŋ dii sariya tiŋteeŋ deeŋ lɛ u jisiŋ bolie. Mi tuɔŋ saa tɔrɔ mi si jaŋ bul wiaa a laa mi titia ŋ sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ŋ jaŋ wuo piɛsa nii ŋ titia lɛ ari bua-la lɛ mi si ku mu Jerusalɛm di mi chuɔlɛ Wia Wia-dia lɛ, u bi tapulaa fii ari balia kii. ");
INSERT INTO sil_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ju̱u tiŋŋaa bimi naa di la di nuu-kala kɛŋ wii lilɛrɛ Wia-dia lɛ, mi bi taawɛi ma ŋaa Wii-chuɔlɛ diisiŋ lɛ koo lee kala taŋ-la lɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ba bira bi jaŋ wuo dagɛ ari wialiŋ ba si si mi ŋaa chei ŋaa wutitiiba nɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wii-la mi si jaŋ bula piŋ ari u ŋaa wutitii nɛ ŋla: Ba wialiŋ kala tuɔŋ mii to woŋbii-la ba síi chei nɛ. Woŋbii-la mi síi to, mi maa to la naabalimaba Wia nɛ. Mi ma ŋaa wialiŋ kala Moosis si ŋmuŋsa bil di la to yarida, aa to tenni-la nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ si ŋmuŋsa kala maa. ");
INSERT INTO sil_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi ma laa dii ari Wia jaŋ chisɛ ni-zɔŋŋɔɔ ari ni-bɔŋŋɔɔ kala suuŋ lɛ. Niaa deeŋba kala si chiŋ ŋii, ma laa wiaa deeŋba kala dii nɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mi yie wiwalimɛ woruŋ di mi tuɔbiinaa kala chesi Wia ari nuhuobiinee kala sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mi si lii Jerusalɛm lɛ diene, a yi jisi ari jisi. Lɛɛlɛ nɛ mi kɔ a kɛŋ moribiiŋ kaa kɔ di mi pi mi tiŋteeŋ niaa aŋ pɛ kpu pusuŋ pi Wia. ");
INSERT INTO sil_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ŋii lɛ ba nami Wia-dia lɛ. Bua-la lɛ ba síi nami, di mi piisɛ mi disinniŋ dɛrɛ. Ni-daŋ kala tuo mi teeŋ. Mi bi taawɛi ma kala ŋaa. Ju̱u tiŋŋaa dɔŋsuŋ si lii Esia tiŋteeŋ ma nɛ fa hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Di ba nɛ fa kɛŋ wii-kala a tigɛmi lɛ, u fa maga di ba titia nɛ kɔ daha a ku bul. ");
INSERT INTO sil_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ŋii ma dee, leŋ di niaa deeŋba si hɛ daha bul wii-la ba si na di mi ŋaa chei bua-la lɛ mi si chiŋ nialiŋ si yie hɔnɔ vuvuurɛ wiaa sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Wii-la duŋduŋa mi si ŋaa nɛ ŋla: Mi fa chiŋ ba sipaaŋ a faasa bula piba a bul, ‘Jiniŋ maa dii mi sariya a tiŋ mi si laa dii ari ni-suunuŋ jaŋ sii suuŋ lɛ a kɛŋ miisiŋ.’ ” ");
INSERT INTO sil_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fiilis si nii ŋii, u jiŋ woŋbii-la Pɔɔl síi to wiaa woruŋ. Ŋii nɛ tii u bul di ba sii. Ka u bula piba a bul, “Má leŋ di laali-yuoroo kuhiaŋ Lisias nɛ kɔ. Ŋii-na mi jaŋ dii ma sariya.” ");
INSERT INTO sil_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","U ŋaa laali-yuoru kubala bibeŋ Pɔɔl, aŋ bula pu duu kɛnu tɔ aŋ leŋ duu nina wiese, duu pi u naŋdɔŋsuŋ woŋbiiŋ di ba ku ninau di ba bubul wiaa. Duu níi chɛ kuŋ maa, di ba pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","U bi diene di Fiilis kɛŋ u haala kaa kɔ. U yiriŋ nɛ Dusila. U fa ŋaa Ju̱u tiina nɛ. Ŋii nɛ Fiilis tima yirɛ Pɔɔl duu kɔ. U sí kɔ, u ŋaa u bul wiaa pu u jijegili. U bul Yesu Kirisito wiaa pu a bula pu duu laa u wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama Pɔɔl si mu bul wiaa a tigɛ wu-zɔŋŋɔɔ ŋaaniŋ lɛ ari ŋ si wuo kɛŋ ŋ titia lɛ, a bira bul tapulii-la Wia si jaŋ dii dunia niaa sariya wiaa maa, fawulluŋ kɛŋ Fiilis. Ŋii nɛ u bul duu mu, ka duu nina chiniŋ u jaŋ bira yiru. ");
INSERT INTO sil_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ŋii kala lɛ u faa biinɛ ari Pɔɔl jaŋ pu moribiiŋ. Ŋii wiaa nɛ tii u yie yiyiru tɛtɛ tɛtɛ ba yie bubul wiaa. ");
INSERT INTO sil_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Jisiŋ balia si kiele, baal kubala baa yirɛ Pɔɔkɔs Fɛsitis nɛ fa laa tiŋteeŋ kuoro Fiilis leriŋ. Fiilis faa chɛ di Ju̱u tiŋŋaa chou, ŋii nɛ tii u ŋaa ba ha kɛŋ Pɔɔl tɔ dia. ");
INSERT INTO sil_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛsitis si ku laa tiŋteeŋ, u hɔŋ Sizariya lɛ tapulaa batori aŋ sii mu Jerusalɛm. ");
INSERT INTO sil_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","U si mu Jerusalɛm ŋii, nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari Ju̱u tiŋŋaa kuhiasiŋ ku bul wii-la Pɔɔl si ŋaa cheiba pu, aŋ sulu ");
INSERT INTO sil_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","duu pɛba lɛ a ŋaa di Pɔɔl kɔ Jerusalɛm. Ba vuura nɛ di ba cheme kpuu woŋbiiŋ lɛ. Ŋii nɛ tii ba bul ŋii. ");
INSERT INTO sil_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ŋii nɛ Fɛsitis bul di ba kɛnu tɔ dia nɛ Sizariya tiŋteeŋ lɛ, duu sí lee-la lii, duu ma jaŋ miira mu dimɛ sisɛlɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ŋii nɛ u bul di ba leŋ di ba kuhiasiŋ to u hariŋ mu Sizariya, di u nɛ ŋaa wii cheiba lɛ, di ba bul u teeŋ dimɛ duu nii. ");
INSERT INTO sil_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛsitis chua Jerusalɛm lɛ ari tapulaa chori koo fii aŋ-na miira mu Sizariya. U taŋ si pula, u mu hɔŋ sariya didilliŋ aŋ ŋaa ba kɛŋ Pɔɔl kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔɔl si kɔ, Ju̱u timma-la si lii Jerusalɛm kɔ, ba ku gollu chu a bul di wialiŋ Pɔɔl si cheye yuga nɛ siifiɛsɛ, ama ba bi wuo dagɛ ari wialiŋ ba si bula a tigɛu lɛ ŋaa wutitiiba. ");
INSERT INTO sil_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ŋii nɛ Pɔɔl ma bul wiaa duu laa u titia a bul, “Mi bi Ju̱u tiŋŋaa naabalimaba woŋbii-la ba síi to wii-kala cheye, mi bira bi wii ma kala cheye a tigɛ Wia-dia lɛ koo Rom kuori-baliŋ ma lɛ.” ");
INSERT INTO sil_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛsitis ma faa chɛ di Ju̱u tiŋŋaa chou nɛ, ŋii nɛ u piɛsɛ Pɔɔl ari u jaŋ cho duu mu Jerusalɛm duu dii u sariya dimɛ a tiŋ wiaa deeŋba ba si bula a tigɛu lɛ koo? ");
INSERT INTO sil_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ŋii nɛ Pɔɔl si, “Ai, mi jaŋ cho di mi mu kuori-baliŋ teeŋ. U maga di u nɛ dii mi sariya. Ŋ titia jima woruŋ ari mi bi wii ŋaa chei Ju̱u tiŋŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Di mi nɛ fa ŋaa wii chei a magɛ di ba kpumi, mi faa sɛi nɛ, ama di wialiŋ kala ba síi bul ŋaa wu-nyiariŋ nɛ, nuu-kala tuo duu wuo joŋmi hɛ ba nisiŋ lɛ di ba kpumi. Mii suluŋ di ŋ leŋ di mi mu kuori-baliŋ teeŋ duu nɛ dii mi sariya.” ");
INSERT INTO sil_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ŋii nɛ Fɛsitis ari u nihiasiŋ vuurɛ wiaa. Ka u bula pi Pɔɔl a bul, “Na ŋ si ŋ jaŋ mu kuori-baliŋ teeŋ duu nɛ dii ŋ sariya. Ŋ saa jaŋ mu.” ");
INSERT INTO sil_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","U bi diene di kuoro kubala ba síi yirɛ Agiripa ari u dihaala ba síi yirɛ Bɛɛnis kɔ di ba chuɔlɛ Fɛsitis Sizariya lɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ba si mu dimɛ tapulaa baŋmɛnɛ, Fɛsitis bul Pɔɔl wiaa kala a piba a bul, “Baal kubala nɛ hɛ daha. Fiilis nɛ fa kɛnu kaa tɔ dia. U ha hɛ dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mi si mu Jerusalɛm, nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ ari ba nihiasiŋ Ju̱u tiŋŋaa tuɔŋ ku bul wialiŋ u si ŋaa cheiba lɛ, aŋ bul di mi dii u sariya a joŋ cheeriŋ pu. ");
INSERT INTO sil_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ŋii nɛ mi bula piba ari Rom tiŋŋaa bi sɛi di ba bul duu cheye nɛ aŋ joŋ tiina hɛ u diŋdɔŋŋɔɔ nisiŋ lɛ, see di ba kala hɔnɔ, di dɔŋɔ bul u wiaa, dɔŋɔ ma bul u wiaa. ");
INSERT INTO sil_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ŋii nɛ ba kɔ daha. Ba si kɔ, mi bi kaa dieni. U taŋ si pula, mi mu sariya didilliŋ aŋ ŋaa ba kɛŋ baal-la kaa kɔ. ");
INSERT INTO sil_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nialiŋ fa síi bul Pɔɔl teeŋ sii chiŋ a bul wialiŋ Pɔɔl si ŋaa chei. Mi fa biina di ba jaŋ dagɛ wu-bɔmɔ-la u si ŋaa. Ama ba bi wuo dagɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Wii-la ba si bula nɛ ŋaa wu-kaa-lɛrii nɛ ba kaa lɛrɛ a mu tigɛ ba Wii-chuɔluŋ lɛ ari baal kubala si suba, baa yirɛ Yesu. Pɔɔl yie bubul ari Yesu sii suuŋ lɛ a hɛ u miisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mi fa bi jiŋ ŋii mi si jaŋ to a jiŋ wiiŋ deeŋ tuɔŋ. Ŋii nɛ mi piɛsɛ Pɔɔl ari u jaŋ sɛi a mu Jerusalɛm di ba dii u sariya dimɛɛ? ");
INSERT INTO sil_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pɔɔl bi sɛyɛ. U sulmi di mi leŋ di ba benu a kɛnu kaa mu kuori-baliŋ teeŋ di u dii u sariya. Ŋii nɛ mi ŋaa ba bibenu. Mi nɛ ku na woŋbiiŋ, mi jaŋ leŋ di ba kɛnu mu kuori-baliŋ teeŋ di u dii u sariya.” ");
INSERT INTO sil_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ŋii nɛ Agiripa bula pi Fɛsitis ari u titia cho duu ma nii baal-la niiŋ nɛ. Ŋii nɛ Fɛsitis bula pu ari u chie jaŋ nii u wu-buluŋ. ");
INSERT INTO sil_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","U taŋ si pula, Agiripa ari Bɛɛnis mu sariya didiiliŋ. Ba kpiɛrɛ ba titia woruŋ a mu juu dii-bal-la. Niaa zilba kiŋkɛŋ. Ba di laali-yuoroo nihiasiŋ ari ni-balaa taŋ-la lɛ, ba kala ku juu a hɔŋ dɔŋɔ lɛ. Ba kala si hɔŋ ŋii, Fɛsitis ŋaa ba kɛŋ Pɔɔl ku juu. ");
INSERT INTO sil_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ŋii nɛ Fɛsitis bul, “Kuoro Agiripa, ma di nialiŋ kala si hɛ daha, ma na baala deeŋ. U wiaa nɛ tii Ju̱u timma-la si hɛ daha ari Ju̱u timma-la si lii Jerusalɛm kala ku wiwalimɛmi. Baa ŋaa goŋ a bul di u bi maga di u kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mi-na bi na ari u si ŋaa wii-la chei a magɛ di ba kpuu. Ama u titia nɛ sulmi ari u jaŋ mu kuori-baliŋ teeŋ duu dii u sariya. Mi saa jaŋ leŋ duu mu. ");
INSERT INTO sil_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama mi paala bi chaasa jiŋ wii-la kala mi si jaŋ ŋmuŋsa pi kuori-baliŋ a mu tigɛu lɛ. Ŋii nɛ tii mi kɛnu kaa kɔ ma teeŋ di ma nii u wiaa. Ŋ-na kuoro Agiripa teeŋ nɛ mi saa paala kɛnu kaa kɔ. Mi biina ari ŋ ma nɛ juu wii-la tuɔŋ, ŋ jaŋ wuo na wii di mi wuo ŋmuŋsɛ teniŋ pi kuori-baliŋ. ");
INSERT INTO sil_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","U bi woŋbii kɛnɛ mi teeŋ di mi nɛ leŋe di ba kɛŋ daŋsarika kaa mu kuori-baliŋ teeŋ, aŋ bi chaasa bul wii-la kala u si ŋaa chei.” ");
INSERT INTO sil_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ŋii nɛ Agiripa bula pi Pɔɔl a bul, “Woŋbiiŋ hɛ dimɛ di ŋ bul wiaa a laa ŋ titia.” Ŋii nɛ Pɔɔl suomo bul wiaa a jijaakɛ u nisaa a bul, ");
INSERT INTO sil_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kuoro, mi jaŋ bul di mi nyuŋ sima jiniŋ mi si jaŋ wuo bul wiaa a laa mi titia ŋ sipaaŋ wiaa deeŋba kala lɛ Ju̱u tiŋŋaa síi bul mi teeŋ, ");
INSERT INTO sil_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","bɛɛ wiaa ŋ-na paala chaasa jiŋ Ju̱u tiŋŋaa kisinniŋ kala nɛ ari ba wu-kaa-lɛriŋ. Mi saa suluŋ di ŋ kɛŋ kenyiri aŋ jegile nii mi teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ju̱u tiŋŋaa kala jiŋ mi fa si nagɛ ŋii nɛ a suomi mi haŋbiiriŋ kala lɛ. Mi fa yie hɛ mi tiŋteeŋ ari Jerusalɛm duŋduŋa lɛ nɛ a ku waa. ");
INSERT INTO sil_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","A lii buŋbuŋ kala a kaa kɔ mi faa to Farisii tiŋŋaa paati-la síi to woŋbii-duo-la nɛ la Wii-chuɔluŋ lɛ. Di ba nɛ sɛyɛ, ba jaŋ wuo bul ari ba jiŋ ŋii niiŋ lɛ faafaa kala nɛ. ");
INSERT INTO sil_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ka lɛɛlɛ ba leŋ mi chiŋ daha di ba dii mi sariya a tiŋ mi síi yiɛlɛ wii-la Wia si si u jaŋ ŋaa pi la naabalimaba. ");
INSERT INTO sil_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","La Iziral tiŋŋaa ta-geŋtisiŋ fii ari balia-la, la kala yiɛlɛ wiiŋ deeŋ nɛ, ŋii wiaa nɛ tii la fiɛsɛ siiŋ a chuchuɔlɛ Wia wiihɛyɛ ari titaŋiŋ kala ŋii. Mi síi yiɛlɛ wiaa deeŋba nɛ tii, Ju̱u tiŋŋaa bubul mi teeŋ ŋii, mi nyina. ");
INSERT INTO sil_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bɛɛ nɛ tii ma Ju̱u tiŋŋaa bi wuo laa dii ari Wia jaŋ wuo chisɛ nialiŋ si suba, di ba bira sii suuŋ lɛ? ");
INSERT INTO sil_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mi ma titia fa laa dii ari u maga di mi ŋaa wii-la kala mi si wuo ŋaa a chei Yesu si lii Nazarɛt yiriŋ. ");
INSERT INTO sil_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ŋii nɛ mi ŋaa Jerusalɛm lɛ. Mi laa doluŋ nialiŋ si kpu pusuŋ pipi Wia nihiasiŋ teeŋ, aŋ kɛŋ Wia niaa yugɛ a tɔ dia. Di ba nɛ si di ba kpuba maa, mi yie sɛi nɛ, ka ba kpuba. ");
INSERT INTO sil_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi vɛnɛ dɔgisɛba yugɛ Wii-chuɔlɛ diisiŋ kala lɛ, aa walimɛ di ba bul ari ba bi Yesu jiŋ aŋ via u woŋbii-la. Mi baaniŋ sii kiŋkɛŋ ba nyuŋ. Mi paala mu tasiŋ dɔŋsuŋ si tuo Ju̱u tiŋteeŋ lɛ, a to ba naasiŋ a dɔgisɛba dimɛ. ");
INSERT INTO sil_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Wiiŋ deeŋ wiaa nɛ tii mi sii mu Damaasikas. Nialiŋ si kpu pusuŋ pipi Wia kuhiasiŋ tiŋmi a pimi doluŋ. ");
INSERT INTO sil_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mi síi mu woŋbiiŋ lɛ mi nyina, ari wiihɛi-siesee mi na pulumuŋ duu lii wia nyuŋ a chaana hɛ la di nialiŋ fa síi vɛŋ lɛ. U pulla kii wii-pɔsuŋ. ");
INSERT INTO sil_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","La kala tuu tel tiŋteeŋ. Ka mi nii nuu yiikoro duu bula pimi Hiiburu yiikoro lɛ a bul, ‘Sɔɔl, Sɔɔl, bɛɛ nɛ tii ŋ to mi naasiŋ a dudɔgisɛmi ŋla? Ŋ nagɛ nɛɛŋ nɛ ba si vɔbɔ aŋ ŋmuŋmoo duu vɛŋ. U bi sɛi duu vɛŋ aŋ dudɔgisɛ u titia nɛ.’ ");
INSERT INTO sil_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ŋii nɛ mi piɛsɛ, ‘Kubɛɛ nɛ, Tiina?’ Ŋii nɛ Tiina bul, ‘Mi nɛ ŋaa Yesu, nii-la ŋ si to naasiŋ a dudɔgisɛ. ");
INSERT INTO sil_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ama sii chiŋ. Mi kɛŋ mi titia ku dagiŋ di mi liisiŋ di ŋ tiŋ tiŋtiŋŋaa pimi nɛ, a ŋaa mi siada tiina, a bula pi niaa ŋ si nami ŋii jiniŋ, ari ŋii ŋ si jaŋ bira nami maachie. ");
INSERT INTO sil_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi jaŋ timiŋ di ŋ mu Iziral tiŋŋaa teeŋ ari nialiŋ si bi Ju̱u timma ŋaa kala teeŋ. Di ba níi walimiŋ, mi jaŋ laaŋ ta ba nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mi jaŋ timiŋ di ŋ mu ŋaa di ba siaa suri, a kɛŋba di ba birima lii birimiŋ tuɔŋ a ku juu pulumuŋ tuɔŋ, a ŋaa di ba lii Sitaani nisiŋ lɛ a kɔ Wia teeŋ. Di ba nɛ ŋaa ŋii aŋ laa mi wiaa dii, Wia jaŋ joŋ ba haachɛba chɛba. Ba jaŋ wuo na leriŋ Wia si tuɔsa nialiŋ tuɔŋ.’ ");
INSERT INTO sil_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ŋii wiaa kuoro, mi bi yiikori-la si lii wia nyuŋ wiaa via. ");
INSERT INTO sil_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ŋii nɛ mi suomo bul Wia wiaa Damaasikas lɛ ari Jerusalɛm lɛ a kaa mu Judiya tiŋteeŋ kala, ari nialiŋ si bi Ju̱u timma ŋaa tuɔŋ. Mi bula piba di ba birima lii ba haachɛba lɛ aŋ birima to Wia, aŋ ŋiŋaa wialiŋ si jaŋ dagɛ ari ba birima lii ba haachɛba lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Wiiŋ deeŋ wiaa nɛ tii Ju̱u tiŋŋaa kɛŋmi Wia-dia lɛ aa chɛ di ba kpumi. ");
INSERT INTO sil_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama ari jiniŋ kala Wia haa pɛmi lɛ nɛ, ŋii nɛ tii mi chiŋ daha aa bul wiaa deeŋba kala mi si ŋaa siada a pima, ma ni-balaa ari ma ni-biisiŋ kala. Wiiŋ deeŋ mi síi bul, u titia nɛ nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ ari Moosis kala fa bul ari wii-la jaŋ ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ba fa bula ari Kirisito jaŋ na hɛɛŋ a suu, a laa sipaaŋ a sii suuŋ lɛ nialiŋ si suba kala tuɔŋ. Ba bira bula pi Ju̱u tiŋŋaa ari nialiŋ si bi Ju̱u tiŋŋaa ma ŋaa ba si jaŋ ŋaa ŋii a na pulumuŋ.” ");
INSERT INTO sil_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔl si bul wiaa duu laa u titia ŋii, Fɛsitis kpiau lɛ a bula pu a bul, “Pɔɔl, ŋŋ nyaasɛ nɛ. Ŋ wu-jiŋ kiŋkɛŋ kiŋkɛŋ kɛniŋ nyinyaasɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ŋii nɛ Pɔɔl bul, “Mi bi nyaasɛ mi nyina. Wutitii nɛ mii bul. Mi siaa kala nɛ fiɛla. ");
INSERT INTO sil_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kuoro Agiripa, ŋ jiŋ wiaa deeŋba kala nɛ. Ŋii nɛ tii mi wuo bubulba ari nyu-duoŋ. Mi jima ari wiaa deeŋba kuŋ-kala tuo ŋ si bi jiŋ. Wiaa deeŋba kala si ŋaa, ba bi wu-faalia ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kuoro, ŋ laa nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ wiaa dii nɛɛ? Mi jima ŋ laa dii nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ŋii nɛ kuoro Agiripa piɛsɛ Pɔɔl a bul, “Ŋ biina lɛɛlɛ-bie deeŋ ŋ jaŋ wuo leŋ di mi laa Yesu wiaa dii a tutou koo?” ");
INSERT INTO sil_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ŋii nɛ Pɔɔl bul, “U ŋaa lɛɛlɛ-bie koo u bi lɛɛlɛ-bie ŋaa, mii chuɔlɛ Wia nɛ di ma di ni-kaana-la kala síi jegile nii mi teeŋ jiniŋ deeŋ, di ma ku nagɛmi ari mi si laa Yesu wiaa dii ŋii. Ama mi bí chɛ di ma nagɛmi ari ba si kɛŋmi vɔɔ ari chɔrumɔɔ ŋla.” ");
INSERT INTO sil_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pɔɔl si bul wiaa deeŋba dɛrɛ, ŋii nɛ tiŋteeŋ kuoro ari nii-la si chiŋ kuori-baliŋ nyuŋ ari Bɛɛnis ari nialiŋ kala fa si hɔnɔ, ba sii di ba viiri. ");
INSERT INTO sil_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ba si lii di-jaliŋ ŋii, ba bula pipi dɔŋɔ a bul, “Baala deeŋ bi wii-kala cheye a magɛ di ba kpuu koo di ba kɛnu tɔ dia.” ");
INSERT INTO sil_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ŋii nɛ Agiripa bula pi Fɛsitis a bul, “Di baala deeŋ fa bi woŋbiiŋ sula ari u jaŋ mu kuori-baliŋ teeŋ duu dii u sariya, mi fa jaŋ bul di ŋ joŋu ta.” ");
INSERT INTO sil_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ŋii nɛ ba vuurɛ di la juu liiŋ daboro a mu Itali. Ba joŋ Pɔɔl hɛ laali-yuoroo kuhiaŋ kubala nisiŋ lɛ a pɛ daŋsarikaba dɔŋsuŋ lɛ. U lii Rom nɛ a fa ŋaa kuhiaŋ Rom kuori-baliŋ laali-yuoroo tuɔŋ. Baa yiru Julias. ");
INSERT INTO sil_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","La mu juu liiŋ daboro si lii taŋ kubala baa yirɛ Adamiitam a ŋaa siri duu mu tasi-la si hɛ mugi-baliŋ niiŋ Esia tiŋteeŋ lɛ. Baal kubala baa yirɛ Arisitaakis ma fa hɛ la tuɔŋ nɛ. U fa ŋaa Masidoonia tiina nɛ a lii Tɛsalonaaka. La si mu ŋii, ");
INSERT INTO sil_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","u taŋ si pula la mu yi taŋ kubala baa yirɛ Saadɔŋ. Julias fa kɛŋ zile Pɔɔl teeŋ a pu woŋbiiŋ duu mu na u naŋdɔŋsuŋ, di u níi chɛ kuŋ maa, di ba pɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","La bira sii dimɛ. La síi mu, di peliŋ lu lii lee-la la fa si chaasa. La miira mu to tiŋteeŋ kubala liiŋ si gollo chu, baa yirɛ Saapɔs. La to sɛmɛ-la si kɛrɛ peliŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","La kpɛrɛ to Siliisia ari Paŋfiilia tiŋteeŋ niiŋ, a mu yi lee kubala baa yirɛ Maara. U fa hɛ Laasa tiŋteeŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Dimɛ nɛ laali-yuoroo kuhiaŋ-la na liiŋ daboro dɔŋɔ duu lii Alɛkizaŋdia aa mu Itali. U ŋaa la juu. ");
INSERT INTO sil_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","La fiɛla duori ŋii deeŋ deeŋ tapulaa baŋmɛnɛ a na hɛɛŋ kiŋkɛŋ, aŋ sisɛlɛ ku kpagɛ taŋ kubala baa yirɛ Sinaadas. Pel-la bi sɛyɛ di la to dimɛ. Ŋii nɛ la bira kpɛrɛ to tiŋteeŋ kubala liiŋ si gollo chu, baa yirɛ Kiriiti, a ku yi lee kubala baa yirɛ Salimooni. La kpɛrɛ to tiŋtee-la sɛmɛ-la si kɛrɛ peliŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","La si kpɛrɛ to lii-la niiŋ ŋii, la na hɛɛŋ woruŋ aŋ-na ku yi lee kubala baa yirɛ Fɛɛ Heeviŋs. U fa kpagɛ taŋ kubala baa yirɛ Lasiya. ");
INSERT INTO sil_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","La hɔŋ dimɛ a dieni, Ju̱u tiŋŋaa tapul-bal-la ba si yie kpu pusuŋ pi Wia, duu joŋ ba haachɛba chɛba, ku kieli. Bua-la lɛ liiŋ duoruŋ yie hɛi nɛ. Ŋii nɛ Pɔɔl bul wiiŋ deeŋ chagilɛba a bul, ");
INSERT INTO sil_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mi naaŋbiiriŋ, mi na ari la woŋbii-la vɛniŋ jaŋ kperila. Má leŋ di la hɔŋ daha. Di la nɛ si la mu, la liiŋ daboro ari la chugusuŋ jaŋ chei, la dɔŋsuŋ ma jaŋ suu.” ");
INSERT INTO sil_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama laali-yuoroo kuhiaŋ-la fa bi Pɔɔl teeŋ jegile nii, aŋ jegilee nii liiŋ daboro-la kuhiaŋ ari liiŋ daboro-la tiina teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ba si lee-la bi zɔŋ ari ba si jaŋ hɛ dimɛ yibiiniŋ lɛ. Ba tuɔŋ jesiŋ kala fa cho di ba juu liiŋ daboro-la, a wiwalimɛ di ba nɛ wuolo, di ba mu yi taŋ kubala baa yirɛ Fiinis a hɛ dimɛ yibiiniŋ. Fiinis nɛ fa ŋaa lee-la liiŋ daborusuŋ si yie chiŋ a hɛ Kiriiti tiŋteeŋ. U fa hɛ taŋ sɛmɛ ari taŋ bubuɔŋ pɛgɛ, a bira piŋ taŋ sɛmɛ ari taŋ nyuŋ pɛgɛ maa a kɛrɛ peliŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ŋii nɛ peliŋ fiɛla lu a lii taŋ bubuɔŋ a kukɔ. Nialiŋ biina ari ba jaŋ na woŋbiiŋ a vɛŋ ari ba fa si biina ŋii ba tuɔŋ lɛ. Ŋii nɛ ba kɛŋ hɔɔ-bal-la ba si yie kaa chagɛ liiŋ daboro-la a kaa liisɛ a hɛ liiŋ daboro-la tuɔŋ, aŋ duoro kpɛrɛ to Kiriiti tiŋteeŋ niiŋ ŋii. ");
INSERT INTO sil_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","U bi diene di peli-duoŋ faasa lu a lii taŋ nyuŋ ari wii-pɔsuŋ pɛgɛ. U lii tiŋteeŋ liiŋ si gollo chu nɛ a kukɔ. ");
INSERT INTO sil_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","U ku ŋmoo liiŋ daboro-la, la bi pel-la wuo chaasɛ. La bi wii-kala wuo ŋaa. Ŋii wiaa la leŋ pel-la kɛŋ liiŋ daboro-la mu lee-la u si lu mumu. ");
INSERT INTO sil_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ŋii nɛ la to lee kubala liiŋ si gollo chu baa yirɛ Kaada, a to u taŋ sɛmɛ. U kɛrɛ pel-la mua. Dimɛ la na hɛɛŋ woruŋ aŋ-na wuo kɛŋ liiŋ dabori-bie-la la fa si joŋo vɔɔ liiŋ daboro-la hariŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ba lɛrɛ liiŋ dabori-bie-la ku juu liiŋ daboro-la tuɔŋ a kɛŋ ŋmɛsiŋ vɔbu, aŋ vɔɔ liiŋ daboro-la kala kpaŋ kpaŋ. Fawulluŋ fa kɛŋba ari ba jaŋ vɛnɛ mu juu hagili-buŋbugulo-la tuɔŋ si golli Liibia tiŋteeŋ a pɛ dimɛ. Ŋii nɛ ba kɛŋ gɛnni-la ba fa si joŋo vɔɔ liiŋ daboro-la nyuŋ di peliŋ kaa vɛŋ a kaa ta ba suusa tuu, aŋ leŋ pel-la kɛŋ liiŋ daboro-la aa vɛŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Pel-la faasa lu ŋii nɛ deeŋ deeŋ. Taŋ si pula ba suomo chaarɛ chugusu-la si hɛ liiŋ daboro-la tuɔŋ a yuo tita. ");
INSERT INTO sil_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Taŋ si pula, la titia chaarɛ liiŋ daboro-la kiaa ba si kaa wasɛ liiŋ daboro-la dɔŋsuŋ a yuo ta. ");
INSERT INTO sil_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","La tapulaa yuga wia si bi pɔsɔ, chɛŋwulaa ma bi lia. Ka pel-la ha faasa lu kiŋkɛŋ. Pel-la si faasa lu ŋii, la bira bi yiɛla ari la jaŋ kɛŋ miisiŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nialiŋ diene ba bi kiaa die. Ba si diene ba bi kiaa die ŋii, Pɔɔl sii chiŋ ba sipaaŋ a bula piba a bul, “Mi naaŋbiiriŋ, u fa maga di ma jegile nii mi teeŋ. Di ma nɛ fa jegile nii mi teeŋ, la nɛ fa bi Kiriiti lɛ lia, la kiaa deeŋba kala si cheye, ba fa bi chei. Kialiŋ kala si lɛlɛ ma fa bi lɛl. ");
INSERT INTO sil_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama mii sulma, má nyirɛ bɔyɛ. Liiŋ daboro duŋduŋa nɛ jaŋ lɛl, ama ma kuŋ-kala bi jaŋ suu. ");
INSERT INTO sil_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Wia-la si tiimi, mi maa chuɔlu. U tiŋdaara dia kɔ mi teeŋ titaŋiŋ ");
INSERT INTO sil_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a bula pimi a bul, ‘Pɔɔl, sí fawulluŋ fá. Ŋ jaŋ mu chiŋ kuori-baliŋ sipaaŋ. Wia tiŋ ŋ wiaa nɛ a leŋ ma di nialiŋ kala si hɛ liiŋ daboro tuɔŋ, ma kala jaŋ kɛŋ miisiŋ.’ ");
INSERT INTO sil_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ŋii wiaa, mi naaŋbiiriŋ, má nyirɛ bɔyɛ. Mi ŋaa Wia yarida ari wii-la kala u si bula, u jaŋ chaasa ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama la ta jaŋ mu chiŋ duŋdoli-bie kubala lɛ nɛ liiŋ si gollo chu.” ");
INSERT INTO sil_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pel-la kɛŋla kaa vɛŋ ŋii nɛ tapulaa fii ari banɛsɛ mugi-bal-la ba síi yirɛ Adira tuɔŋ. U titaŋ-la ari tita-siesee nialiŋ síi duori liiŋ daboro-la, ba biinɛ ari baa mu duŋdolo niiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ŋii nɛ ba joŋ kuŋ hɛ lii-la lɛ di ba magisɛ a na u luŋuŋ. Ba na duu luŋie a magɛ naakieliŋ mahiŋ balia. Muapilii ba bira magisɛ a na duu ŋaa naakieliŋ mara ari fii. ");
INSERT INTO sil_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Fawulluŋ fa kɛŋba ari ba jaŋ mu ŋmoo buŋ. Ŋii nɛ ba chaarɛ hɔɔnu-la ba si yie kaa chichagɛ liiŋ daboro-la a kikii. Ba banɛsɛ nɛ ba chaarɛ liiŋ daboro-la hariŋ a chagu kii, aŋ susul Wia di taŋ-pul di ba na pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ŋii nɛ nialiŋ fa síi duori liiŋ daboro-la lii a chichɛ di ba fá, aŋ ka liiŋ daboro-la ari ni-kaanaa. Ba liisɛ liiŋ dabori-bie-la a hɛ liiŋ tuɔŋ, a fufugi ari baa chɛ di ba lii liisɛ hɔɔ-la ba si kaa chichagɛ liiŋ daboro-la sipaaŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ŋii nɛ Pɔɔl jiŋ a bula pi laali-yuoroo kuhiaŋ-la ari laali-yuoro-la a bul, “Ma bi jaŋ kɛŋ miisiŋ, see nialiŋ síi duori liiŋ daboro-la hɛ liiŋ daboro tuɔŋ.” ");
INSERT INTO sil_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pɔɔl si bul ŋii, laali-yuoro-la keri ŋmɛsi-la ba fa si kaa vɔɔ liiŋ dabori-bie-la, a leŋ liiŋ joŋo viiri. ");
INSERT INTO sil_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Taŋ si kpagɛ puluŋ, Pɔɔl sul nialiŋ kala si hɛ liiŋ daboro-la tuɔŋ di ba dii kiaa a bul, “Tapulaa fii ari banɛsɛ nɛ ŋla ma síi gbɛrɛ wii-la si jaŋ ŋaama. Ma bi kuŋ-kala die. ");
INSERT INTO sil_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ŋii wiaa mii sulma di ma dii kiaa. Di ma nɛ dii kiaa, ma jaŋ kɛŋ doluŋ a wuo laa ma titia a kɛŋ miisiŋ. Ma kuŋ nyu-puŋ ma bi jaŋ wii.” ");
INSERT INTO sil_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔl si bul ŋii dɛrɛ, u joŋ boroboro, a chuɔlɛ Wia ba kala sipaaŋ, aŋ chɔgɛ didii. ");
INSERT INTO sil_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ba nyirɛ bɔyɛ, ba kuŋ-kala ma dii kudiilee. ");
INSERT INTO sil_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","La nialiŋ kala fa si hɛ liiŋ daboro-la tuɔŋ fa ŋaa zɔ-balia ari mahiŋ batori ari fii ari balidu nɛ. ");
INSERT INTO sil_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ba kala si dii kiaa vɔgɛ, ba chaarɛ mia-la fa si hɛ liiŋ daboro-la lɛ a ta, di liiŋ daboro-la sí faasa yuŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Taŋ si pula, nialiŋ síi duori liiŋ daboro-la bi wuo jiŋ di ba yi duŋdolo-la niiŋ nɛ, ka ba yi. Ba na di tiŋteeŋ nɛ golli lii-la chu, lii-la bi jal. Lee-la kala taalɛ. Ba biina ba jaŋ wuo kɛŋ liiŋ daboro-la a lii lii-la niiŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŋii nɛ ba keri hɔɔ-bala-la ba fa si yie kaa chichagɛ liiŋ daboro-la a lo hɛ liiŋ lɛ. Ba kɛŋ ŋmɛŋ-la ma puri ba si kaa vɔɔ danyine-la ba fa si kaa kukuosi liiŋ, a didagɛ liiŋ daboro-la woŋbiiŋ. Ba bira wasa kɛŋ gɛnni-la maa ba si kaa vɔɔ liiŋ daboro-la sipaaŋ, di peliŋ kɛŋ liiŋ daboro-la vivɛŋ. Ba wasa kaa ta ba jil a vɔɔ, di peliŋ kaa vɛnɛ mu lii-la niiŋ. ");
INSERT INTO sil_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama liiŋ daboro-la fá mu juu hagili-buŋbugulo tuɔŋ fuo-balaa balia si ku cheŋ dɔŋɔ a kuro bil. Daboro-la sipaaŋ muurɛ, u bi wuo vɛŋ, aŋ ka pel-bal-la ŋaa lii-peliŋ ku ŋmoo liiŋ daboro-la, a ŋaa u hariŋ kala bori. ");
INSERT INTO sil_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ŋii nɛ laali-yuoro-la vuurɛ di ba kpu daŋsarikaba-la kala, di ba kuŋ-kala sí wuo lii a duori lii-la a fá lɛl. ");
INSERT INTO sil_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ka laali-yuoroo kuhiaŋ-la faa chɛ duu laa Pɔɔl ta, ŋii nɛ u bula piba di ba sí ŋii ŋaa. U ta bula piba ari nialiŋ kala sí jiŋ liiŋ a hɛ liiŋ daboro-la tuɔŋ, di ba laa sipaaŋ fula tuu a duoro mu lii-la niiŋ, ");
INSERT INTO sil_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aŋ ka di ni-kaana-la ma tuu, di dɔŋsuŋ paa daa-borusuŋ, di dɔŋsuŋ ma paa liiŋ daboro-la dabori-yɛrie-la, a ma kaa duori liiŋ lii. Ŋla nɛ la kala ŋaa a lii lii-la niiŋ. ");
INSERT INTO sil_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","La si lii liiŋ niiŋ a laa la miisiŋ ŋii, la na ari tiŋteeŋ nɛ liiŋ gollo chu ŋii. Nialiŋ si hɛ lee-la bula pila ari tiŋtee-la yiriŋ nɛ Malita. ");
INSERT INTO sil_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nialiŋ kɛŋla woruŋ lee-la, a pɛla lɛ kiŋkɛŋ. La si hɛ dimɛ ŋii, duonuŋ suomo ninii. Leriŋ fiɛla woruŋ. Ba hɛ nyiniŋ pila la wiwieni. ");
INSERT INTO sil_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔɔl mu jaa daasiŋ a kaa ku hɛ nyiniŋ lɛ, di dimiŋ hɛ daasi-la lɛ. Wulimiŋ kɛŋ diŋ-la u ku lii a dima pɛ Pɔɔl nisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nialiŋ si hɛ lee-la na di diŋ-la dima pɛ Pɔɔl nisiŋ lɛ ŋii. Ba bula pipi dɔŋɔ a bul, “U naga baala deeŋ ka kpu niaa nɛ. U wuo lii liiŋ tuɔŋ a kɛŋ miisiŋ, ama Wia bi sɛyɛ duu kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ŋii nɛ Pɔɔl kɛŋ diŋ-la kpesi u tel nyiŋ-la tuɔŋ, ama diŋ-la si dimu ŋii, u buu wii-kala ŋaa. ");
INSERT INTO sil_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ba faa gbɛrɛ diŋ-la si diŋ Pɔɔl ŋii duu ŋmɛrɛ, koo duu guu tele suu, di ba na. Ba gbɛrɛ a dieni. Ba si gbɛrɛ a dieni ŋii, ba bi na ari wii-kala ŋaau lɛ. Ba kɛŋ ba tuɔbiinaa birimɛ a bul duu ŋaa vene nɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tiŋtee-la kuoro yiriŋ nɛ fa Pubilias. U bagisiŋ ma fa kpagɛ lee-la nɛ. U kɛŋla kaa mu u leriŋ, a kɛŋla woruŋ tapulaa batori. ");
INSERT INTO sil_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Kuoru-la nyimma faa wiilɛ nɛ a piŋ dia lɛ. U yaraa fa lima nɛ, aŋ ka u ninigilɛ. Ŋii nɛ Pɔɔl juu nau u dia lɛ a joŋ u nisiŋ daŋu lɛ a chuɔlɛ Wia pu, u duori. ");
INSERT INTO sil_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pɔɔl fa si ŋaa ŋii, puwuolo-la kala fa si hɛ lee-la kɔ Pɔɔl teeŋ. U ŋaa ba duori. ");
INSERT INTO sil_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ba pila chɔgitaba yugɛ. Bua-la lɛ la síi chɛ di la sii juu liiŋ daboro a duoro viiri, ba joŋ kialiŋ kala la síi chɛ a hɛ liiŋ daboro-la lɛ di la kaa joŋ woŋbiiŋ. ");
INSERT INTO sil_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","La hɛ dimɛ chɛŋsiŋ batori nɛ aŋ sii juu liiŋ daboro a lii Alɛkizaŋdia. Liiŋ daboro-la yiriŋ nɛ veŋ-daaliɛriŋ. Yibiiniŋ fa si suomo, ba fa vɔɔ liiŋ daboro-la a bil nɛ liiŋ niiŋ. ");
INSERT INTO sil_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","La síi mu ŋii, la mu yi taŋ kubala baa yirɛ Sirakas, a chua dimɛ tapulaa batori. ");
INSERT INTO sil_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","La bira lii dimɛ a juu liiŋ daboro, a duoro mu taŋ kubala baa yirɛ Riigiam. U taŋ si pula, peliŋ bira suomo lu a lii taŋ bubuɔŋ. U tapulaa balia chɛɛŋ nɛ la ku yi taŋ kubala baa yirɛ Putooli. ");
INSERT INTO sil_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","La na nialiŋ dɔŋsuŋ si laa Yesu wiaa dii dimɛ. Ba si, di la chua ba teeŋ tapulaa balipɛ. La chua. Ŋii nɛ la bira lii dimɛ a mumu Rom. ");
INSERT INTO sil_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","La naaŋbiiri-la si laa Yesu wiaa dii Rom lɛ nii la wiaa ari laa kɔ nɛ. Ba ku cheŋla di-bolii. Ba dɔŋsuŋ cheŋla lee kubala baa yirɛ Apias Yɔbɔ. Dɔŋsuŋ ma cheŋla lee-la ba síi yirɛ Diisiŋ batori Nuhuɔraa síi chua dimɛ. Pɔɔl si naba, u lɔllɛ Wia aŋ nyirɛ u bɔyɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","La si yi Rom, ba pi Pɔɔl woŋbiiŋ duu jujuu u duŋduŋa dia, ka ba ŋaa laali-yuoro kubala bibenu. ");
INSERT INTO sil_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","U tapulaa batori chɛɛŋ Pɔɔl yirɛ Ju̱u tiŋŋaa kuhiasiŋ taŋ-la lɛ ba ku hilimi. Ba si ku hilimi ŋii, u bula piba a bul, “Mi naaŋbiiriŋ, mi bi wii-kala ŋaa chei la niaa lɛ, mi bi la naabalimaba kisinniŋ ma cheye. Ama ba kɛŋmi a tɔ dia Jerusalɛm lɛ, aŋ bira joŋmi a hɛ Rom tiŋŋaa nisiŋ lɛ ŋla. ");
INSERT INTO sil_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ba piɛsɛmi a na ari mi bi wii-kala cheye a magɛ di ba kpumi. Ŋii nɛ tii ba chichɛ di ba joŋmi ta. ");
INSERT INTO sil_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama Ju̱u tiŋŋaa bi sɛyɛ di ba joŋmi ta, ŋii nɛ fugɛmi mi sul woŋbiiŋ di ba kɛŋmi kaa kɔ kuori-baliŋ teeŋ duu dii mi sariya. Ama mi-na bi wu-bɔŋ kala kɛnɛ di mi bul a mu tigɛ mi niaa Ju̱u tiŋŋaa lɛ. Ba nɛ fugɛmi mi kɔ kuori-baliŋ teeŋ. ");
INSERT INTO sil_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ŋla nɛ tii mi si mi jaŋ nama di la bul wiaa. Ba kɛŋ chɔrumɔɔ deeŋba vɔɔmi a tiŋ nii-la wiaa ma Iziral tiŋŋaa síi yiɛlɛ ari u jaŋ kɔ lɛ nɛ.” ");
INSERT INTO sil_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Pɔɔl si bul ŋii, ba bula pu a bul, “La bi teŋ kala laa a lii Judiya a mu tigɛ ŋ lɛ. La naaŋbiiriŋ kubala ma bi lee-la lii kɔ a ku bul wu-bɔŋ a tigɛ ŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama la jima ari lee-na kala niaa yie bubul wu-bɔŋŋɔɔ a mu tigɛ paati-la ŋ síi to nɛ. Ŋii nɛ tii la chichɛ di la nii wialiŋ ŋ si laa dii.” ");
INSERT INTO sil_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ŋii nɛ ba hɛ tapuluŋ pi Pɔɔl. Tapulii-la si yie, niaa yuga a kɔ lee-la Pɔɔl síi juu. Pɔɔl bul Wia kuorii-la wiaa a pipiba siifiɛsiŋ a lii chichuɔŋ kala a kaa mumu didaaniŋ. U karimɛ wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, ari nialiŋ fa síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ fa si ŋmuŋsa bil Wia teniŋ tuɔŋ. U dagɛba ŋii a bul Yesu wiaa piba, a wiwalimɛ di ba laa Yesu wiaa dii. ");
INSERT INTO sil_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nialiŋ si nii wialiŋ u si bula, ba dɔŋsuŋ laa dii, dɔŋsuŋ ma bi laa dii. ");
INSERT INTO sil_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Wiaa deeŋba nɛ Pɔɔl bul, ka ba kɛŋ wiaa lɛrɛ dɔŋɔ lɛ a sii viiri. U bula piba a bul, “Wialiŋ Wia Diŋ-zɔŋ-la si to Azaaya lɛ ŋii a ŋaa u bula pi ma naabalimaba, ba ŋaa wutitii. Azaaya fa ŋaa nii-la fa síi bul wiaa u doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","U fa bula a bul, ‘Mu niaa deeŋba teeŋ a bula piba a bul, Ma jaŋ jegile nii wiaa aŋ bi ba bubuɔŋ jiŋ. Ma jaŋ chaarɛ ma siaa kala aŋ bi kuŋ-kala jaŋ na, ");
INSERT INTO sil_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","bɛɛ wiaa niaa deeŋba nyuŋ dolie, ba tɔ ba digilaa di ba sí wii nii. Ba kɛŋ ba siaa ma tɔ di ba sí kuŋ-kala na. Wia si, di ŋii dee ba siaa fa jaŋ nina, ba digilaa ma fa jaŋ ninii wiaa. Ba nyusuŋ ma fa jaŋ jijiŋ wiaa bubuɔsaa. Ba fa jaŋ birima tomi di mi ŋaa di ba duori.’ ” ");
INSERT INTO sil_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ŋii nɛ Pɔɔl bira bula piba a bul, “U maga di ma jiŋ ari baa bul Wia wu-zɔmɔ-la si laa niaa tita a pi nialiŋ si bi Ju̱u tiŋŋaa ŋaa nɛ. Ba jaŋ jegile nii.” ");
INSERT INTO sil_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔɔl si bul wiaa deeŋba dɛrɛ, Ju̱u timma-la kɛŋ wialiŋ lilɛrɛ dɔŋɔ lɛ siifiɛsiŋ, a sii viiri. ");
INSERT INTO sil_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔl hɔŋ Rom lɛ jisiŋ balia, a yɔɔ u dia u titia lɛ a jujuu. Nuu-na kala si kɔ duu nau, u yie kɛnu woruŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","U bul Wia kuorii-la wiaa a pi niaa, a dagɛ la Tiina Yesu Kirisito ma wiaa ari nyu-duoŋ. Nuu-kala buu tɔ ari u sí ŋii ŋaa.");
INSERT INTO sil_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mi-na Pɔɔl, si ŋaa Yesu Kirisito tiŋtinna, mi níi ŋmuŋsɛ teniŋ deeŋ a pipi ma Rom tiŋŋaa. Wia nɛ yirɛmi mi ŋaa u naŋzɔɔ. U liisɛmi di mi bul u wu-zɔmɔ-la a pi niaa nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Wia to nialiŋ síi bul wiaa, Wia Diŋ-zɔŋ-la doluŋ lɛ nɛ faafaa kala a bula piba di u jaŋ leŋ di ba bul u wu-zɔmɔ-la a pi niaa. Ba ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Wu-zɔŋŋɔɔ deeŋba tigɛ la Tiina Yesu Kirisito lɛ nɛ. U ŋaa Wia Bii nɛ a ŋaa nuhuobiiŋ maa. U ŋaa la naabalima kuoro Devit nihii nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ama Wia si chisu suuŋ lɛ ŋii, u ŋii wuo dagɛ ari u ŋaa Wia Bii nɛ, a kɛŋ doluŋ a kɛŋ Wia Diŋ-zɔŋ-la si kɛŋ tuɔ-pula maa. ");
INSERT INTO sil_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","U lahɔrimɔ lɛ Wia leŋe mi ŋaa u naŋzɔɔ a bul u wu-zɔmɔ-la wiaa a pi dunia niaa kala, di ba laa dii a to Yesu niiŋ a wuo zil u yiriŋ. ");
INSERT INTO sil_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma ma Rom tiŋŋaa hɛ niaa deeŋba tuɔŋ nɛ. Wia liisɛma nɛ di Yesu Kirisito tiima. ");
INSERT INTO sil_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ŋii wiaa mi ŋmuŋsɛ teniŋ deeŋ pipi ma nialiŋ kala si hɛ Rom lɛ, ma nialiŋ Wia si cho a liisɛma di ma ŋaa tuɔ-pul tiŋŋaa. La Nyimma Wia ari la Tiina Yesu lahɔrimɔ lɛ, ba jaŋ pɛma lɛ di ma hɔŋ ari yarifiɛlaa. ");
INSERT INTO sil_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Wii-la mi si kɛnɛ di mi laa sipaaŋ bul nɛ ŋla: Mi to Yesu Kirisito lɛ aa lɔllɛ Wia ma kala wiaa, bɛɛ wiaa dunia nuu-kala nii ma yarida wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Wia-la mi si timaa pa ari mi tuɔ-bala aa bul u Bie wu-zɔmɔ-la wiaa, u nɛ ŋaa mi siada tiina ari bua-na kala lɛ di mi níi chuɔlu, mi yie liliisi ma wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mi yie sulu a chichɛ woŋbiiŋ di mi ku nama. Duu nɛ sɛyɛ, mi jaŋ ku nama lɛɛlɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mi cho di mi ku nama nɛ ari siifiɛsiŋ, a pɛma lɛ ari kialiŋ Wia Diŋ-zɔŋ-la síi chɛ duu joŋo pima di ma dol. ");
INSERT INTO sil_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Wii-la mi si bul nɛ ŋla: La jaŋ pipɛ dɔŋɔ lɛ. Mi si ŋaa yarida ŋii jaŋ leŋ di ma nyuŋ nyaasɛ. Ma ma si ŋaa yarida ŋii jaŋ leŋ di mi ma nyuŋ nyaasɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mi naaŋbiiriŋ, mi cho di ma jiŋ, ari mi walima walima di mi ku nama nɛ, ama wii nɛ yie tii mi bi kɔ. Mi cho di mi ŋaa di niaa lii ma tuɔŋ nɛ a ku to Wia, ari mi si ŋaa ŋii nialiŋ dɔŋsuŋ si bi Ju̱u tiŋŋaa ŋaa lɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","U maga di mi tiŋ Wia tiŋtiŋŋaa niaa tuɔŋ. Giriik tiŋŋaa ari nialiŋ kala si bi Giriik tiŋŋaa ŋaa, wu-jinnaa ari nialiŋ si bi wiaa jiŋ, ba kala tuɔŋ nɛ u maga di mi tiŋ Wia tiŋtiŋŋaa. ");
INSERT INTO sil_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ŋii nɛ tii mi cho di mi bul Wia wu-zɔmɔ-la a pi ma nialiŋ si hɛ Rom tiŋteeŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mi bi hiisiŋ ka fa di mi bul Wia wu-zɔmɔ-la, bɛɛ wiaa u nɛ ŋaa Wia doluŋ. Nialiŋ si ŋaaba yarida, Ju̱u tiŋŋaa ari nialiŋ si bi Ju̱u tiŋŋaa ŋaa kala, Wia jaŋ laaba ta. ");
INSERT INTO sil_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wia wu-zɔmɔ-la dagɛ ŋii Wia si ŋaa niaa wuo kɛŋ tuɔ-pula u sipaaŋ. U daga ari nialiŋ si kɛŋ yarida, ba kɛŋ tuɔ-pula u sipaaŋ, di ba wuo chiŋ ba yarida naaŋ lɛ a mu dɛrɛ. Ba ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ a bul, “Nii-la kala si ŋaa Wia yarida, u tiina ŋaa tuɔ-pul tiina nɛ Wia sipaaŋ, u jaŋ kɛŋ miisiŋ.” ");
INSERT INTO sil_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Wia baaniŋ sii ni-bɔŋŋɔɔ ari nialiŋ si bi u niiŋ wiaa ka to lɛ nɛ, bɛɛ wiaa ba wu-ŋaalaa nyagɛ wutitii-la bil nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Wialiŋ niaa si maga di ba jiŋ a tigɛ Wia lɛ, ba woŋbiiŋ chaasa piŋ nɛ. Wia nɛ dagɛba. ");
INSERT INTO sil_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","La bi Wia nagisiŋ wuo jiŋ. Ama la wuo chaasa na ŋii u si kɛŋ dol-la si bi dɛrɛ. U bi nuhuobiine naga. U dagɛla wiaa deeŋba, a suomi bua-la lɛ u si ŋaa dunia a kaa kukɔ jiniŋ. Kialiŋ kala u si ŋaa dagɛla ŋii. Ŋii wiaa ni-bɔŋŋɔɔ deeŋba bi jaŋ wuo bul ari ba bi jiŋ. ");
INSERT INTO sil_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ba jiŋ Wia nɛ, ama ba buu zil ari u ŋaa Wia. Ba buu ka lɔllɛ. Ba tuɔbiinaa kala birima nɛ ba ŋiŋaa wu-liiliŋ. Ba tuɔbiiŋ-lɔrunu-la kɛŋba kaa mu hɛ birimiŋ tuɔŋ. ");
INSERT INTO sil_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba to ba yaariŋ lɛ a bul ari ba kɛŋ wu-jimiŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","U fa maga di ba chuchuɔlɛ Wia-la si kɛŋ yiriŋ aŋ bi suu. Ka ba via aŋ miira mɛ kiaa si nagɛ nuhuobiinee a susuu, a bira mɛ kialiŋ si nagɛ diibiisiŋ ari pusuŋ ari kialiŋ síi tuuri tiŋteeŋ, a chuchuɔlɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ŋii wiaa Wia joŋba ta ba tuto ba titia tuɔbiiŋ-lɔrunu-la ba síi cho, a ŋiŋaa wu-liiliŋ dɔŋɔ lɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wutitii-la ba si jima a tigɛ Wia lɛ, ba joŋu lenni wu-nyiariŋ, a miira chuchuɔlɛ kialiŋ u si ŋaa, aŋ via di ba chuchuɔlɛ Nii-la si ŋaaba. U maga di la didɛnnu a kaa mu wuu. Ami. ");
INSERT INTO sil_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","A tiŋ ŋii wiaa, Wia joŋba ta nɛ di baa ŋaa wu-liiliŋ a hihiisɛ ba titia. Haalaa ma via di ba di ba balaba pipiŋ, aŋ pipiŋ ba ha-dɔŋsuŋ teeŋ. ");
INSERT INTO sil_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ŋii titia nɛ baalaa ma via di ba jaa haalaa ari Wia si si ba ŋaa ŋii, aŋ miira kɛŋ ba ba-dɔŋsuŋ pipiŋ a hihiɛnɛ dɔŋɔ, a ŋiŋaa hiisi wiaa dɔŋɔ lɛ. Ba síi ŋaa ŋii, baa dɔgisɛ ba titia nɛ ŋii. Dɔgisunu-la magɛ ba yaraa lɛ. ");
INSERT INTO sil_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Niaa deeŋba bi sɛi di ba jiŋ Wia. Ŋii nɛ tii Wia leŋba ta ba tuto ba tuɔbiiŋ-bɔŋŋɔ-la hariŋ a ŋiŋaa wialiŋ si bi maga di baa ŋaa. ");
INSERT INTO sil_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Baa ŋaa wu-bɔŋ yiri-yiri-na kala nɛ. Ba kɛŋ niaa kiaa lilaa, aa ŋaa wu-lɔrunuŋ, a kɛŋ yaribieriŋ, a kpukpu niaa, a yuyuo yuosuŋ, a gigirimɛ niaa, a ŋaa wiaa jujuu niaa lɛ, a bubul niaa wiaa. ");
INSERT INTO sil_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ba ŋaa yiri-cheeree ma nɛ, a bɛrɛ Wia, a ŋaa nii-jigi timma. Ba maa dagɛ ba titia a bibigisi ba titia lɛ. Ba yie chichɛ woŋbii-la ba si jaŋ to a ŋaa wu-bɔŋŋɔɔ. Ba bi ba nyimmaba ari ba naaŋba niiŋ ka to. ");
INSERT INTO sil_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ba bi wu-jimiŋ kɛnɛ, a bi wutitii ma kɛnɛ. Ba bi niaa cho, a bi dɔŋɔ ma nennige ka fá. ");
INSERT INTO sil_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ba jiŋ wialiŋ Wia si bula a tigɛ wu-ŋaalaa deeŋba lɛ nɛ. U bula ari nialiŋ síi ŋaa wiaa deeŋba, ba maga di ba suu nɛ, aŋ ka ba via aŋ ŋiŋaa. Ŋii ma duŋduŋa dee. Ba paala bibɛsɛ nialiŋ ma síi ŋaa wialiŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ma bi woruŋ ka ŋaa ma si joŋ cheeriŋ pipi ma dɔŋsuŋ tiŋŋaa, ka ma nialiŋ síi bul niaa teeŋ a bul di ba cheye nɛ, ma ŋiŋaa wu-bɔmɔ-la titia. Nii-la-na kala ma si ŋaa, di ma níi ŋaa wu-bɔmɔ-la, ma bira bi wii-kala kɛnɛ di ma bul. Ma síi ŋaa ŋii, ma titia laa cheeriŋ nɛ ŋii lɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wia si joŋ cheeriŋ pi ma nialiŋ síi ŋaa wu-bɔŋŋɔɔ deeŋba, la jima ari u kɛŋ wutitii nɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ama ma-na si joŋ cheeriŋ pi niaa aŋ ŋiŋaa wu-bɔŋŋɔɔ deeŋba ma titia lɛ, ma biina ari ma jaŋ wuo fá lɛl Wia nisiŋ lɛ duu sí ma sariya dii koo? ");
INSERT INTO sil_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Wia si kɛŋ zile kiŋkɛŋ a kɛŋ kenyiri ŋii, ma bene ari u bi kuŋ ŋaa? Ma bi jiŋ ari Wia si kɛŋ zile ŋii, duu chɛ di ma birima lii ma haachɛba lɛ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ma tuɔŋ dolie. Ma via di ma birima lii ma haachɛba lɛ. Ma wasa ŋaa Wia baaniŋ faasa sisii nɛ. Tapulii-la u si jaŋ dii dunia niaa sariya, u jaŋ dii sariya ari wutitii di niaa na. Bua-la lɛ u baaniŋ jaŋ sii ma nyuŋ kiŋkɛŋ kiŋkɛŋ. ");
INSERT INTO sil_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","U jaŋ ti̱ŋ nuu-kala u time a magɛ ŋii u si tiŋ u tiŋtiŋŋaa magɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nialiŋ si kɛŋ kenyiri aa ŋaa wu-zɔŋŋɔɔ, a ŋaa ŋii a chichɛ di ba na pulumuŋ a laa yiriŋ Wia sipaaŋ, a chichɛ miisi-la si bi dɛrɛ, Wia jaŋ joŋo piba. ");
INSERT INTO sil_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ama nialiŋ síi to ba titia tuɔtɔruŋ lɛ aŋ via wutitii-la, aŋ tuto wu-bɔŋŋɔɔ ŋaaniŋ lɛ, Wia jaŋ na baaniŋ ba nyuŋ kiŋkɛŋ di ba na hɛɛŋ. ");
INSERT INTO sil_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Nuu-na kala síi ŋaa wu-bɔŋŋɔɔ, hɛɛŋ jaŋ kɛnu. Hɛɛ-la jaŋ laa sipaaŋ kɛŋ Ju̱u tiŋŋaa nɛ, aŋ-na ku kɛŋ nialiŋ si bi Ju̱u tiŋŋaa ŋaa maa. ");
INSERT INTO sil_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ama nuu-na kala síi ŋaa wu-zɔŋŋɔɔ, u jaŋ na pulumuŋ Wia sipaaŋ, a laa yiriŋ, a hɔŋ ari yarifiɛlaa, Ju̱u tiŋŋaa nɛ jaŋ laa sipaaŋ, aŋ ka nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuto, ");
INSERT INTO sil_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","bɛɛ wiaa Wia bi niaa kaa pɔrɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wiaa nɛ Moosis fa ŋmuŋsa bil di niaa tuto. Nialiŋ si biba jiŋ aŋ ŋiŋaa wu-bɔŋŋɔɔ, ba jaŋ suu. Di ba nɛ suba, wialiŋ dee Wia jaŋ kaa dii ba sariya. Nialiŋ ma si jiŋ wialiŋ Moosis si ŋmuŋsa bil di niaa tuto aŋ ŋiŋaa wu-bɔŋŋɔɔ, di ba ma nɛ suba, Wia jaŋ to wialiŋ lɛ nɛ a dii ba sariya. ");
INSERT INTO sil_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nialiŋ si nii wialiŋ Moosis si ŋmuŋsa bil di niaa tuto, u ŋii bi jaŋ ŋaa di ba kɛŋ tuɔ-pula Wia teeŋ. Ama nialiŋ síi to wialiŋ Moosis si ŋmuŋsa bil di niaa tuto, ba nɛ jaŋ kɛŋ tuɔ-pula Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Nialiŋ si bi Ju̱u tiŋŋaa ŋaa, ba bi wialiŋ Moosis si ŋmuŋsa bil di niaa tuto jiŋ. Ama di ba tuɔbiinaa nɛ daga di ba ŋaa wialiŋ titia Moosis fa si daga di niaa tuto, ba bil niiŋ nɛ ŋii ba titia lɛ, ari ba si bi wialiŋ Moosis si ŋmuŋsa bil di niaa tuto jiŋ kala. ");
INSERT INTO sil_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ŋii daga ari wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, ba hɛ ba tuɔbiinaa tuɔŋ nɛ. Ba tuɔbiinaa nɛ dagɛ ŋii. Di ba nɛ cheye, ba tuɔbiinaa yie dagɛba nɛ. Di ba nɛ bira bi cheye maa, ba tuɔbiinaa bira yie dagɛba nɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","U jaŋ nagɛ ŋii tapulii-la Wia si jaŋ dii niaa sariya. Ba dagɛ ŋii nɛ Wia wu-zɔmɔ-la tuɔŋ mi si bula pima. Chɛɛ-la Wia jaŋ kɛŋ wialiŋ niaa si kaa faa a kaa ku lii pulumuŋ tuɔŋ, a to Yesu Kirisito lɛ a dii ba sariya. ");
INSERT INTO sil_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ka ŋ-na nii-la si kɛŋ ŋ titia yiyirɛ Ju̱u tiina a jijegili wialiŋ Moosis fa si ŋmuŋsa bil di niaa tuto, a bibigisi ŋ titia lɛ ari ŋ jiŋ Wia nɛ, ");
INSERT INTO sil_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ŋ jiŋ wii-la Wia si cho di ŋ ŋiŋaa nɛ. Ba dagiŋ wialiŋ Moosis si ŋmuŋsa bil nɛ, ŋii nɛ tii ŋ jaŋ wuo jiŋ wii-la si zɔmɔ. ");
INSERT INTO sil_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ŋ jima ari ŋ nɛ ŋaa nyulimaa daa-kɛnnɛ a wuo pipi nialiŋ ma si hɛ birimiŋ tuɔŋ pulumuŋ. ");
INSERT INTO sil_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ŋ nɛ ŋaa nii-la síi dagɛ nialiŋ si bi wiaa jiŋ, aa dagɛ haŋbiisiŋ maa. Wialiŋ Moosis si ŋmuŋsa bil di niaa tuto ŋaa ŋ kɛŋ wu-jimiŋ nɛ a jiŋ wutitii. ");
INSERT INTO sil_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ŋ-na nii-la síi dagɛ niaa, ŋ bi ŋ titia ka dagɛɛ? Ŋŋ dagɛ niaa di ba sí gaa, aŋ titia gigaa. ");
INSERT INTO sil_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ŋ-na nii-la si si di niaa sí ba dɔŋsuŋ haalaa chɛ, aŋ titia chichɛ niaa haalaa. Ŋ si ŋ bɛrɛ vuiaa nɛ, aŋ mu gigaa kiaa vuiaa diisiŋ lɛ. ");
INSERT INTO sil_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ŋ-na bigisi ŋ titia lɛ ari ŋ jiŋ wialiŋ Moosis si ŋmuŋsa bil di niaa tuto nɛ, aŋ chichei wialiŋ a hihiisɛ Wia. ");
INSERT INTO sil_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Wia teniŋ tuɔŋ ba ŋmuŋsɛ ŋii nɛ a bul, “A tiŋ ma Ju̱u tiŋŋaa wiaa, nialiŋ si bi Ju̱u tiŋŋaa ŋaa tuusɛ Wia joŋŋoo.” ");
INSERT INTO sil_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Di ma níi keri ma penee aŋ tuto wialiŋ kala Moosis si ŋmuŋsa bil di niaa tuto, ma penee keriŋ kɛŋ bubuɔŋ nɛ, ama di ma níi chei wialiŋ Moosis si bile, u naga ari ma bi ma penee kere. ");
INSERT INTO sil_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Di nii-la si bi u peniŋ kere níi to wialiŋ Moosis si ŋmuŋsa bil di niaa tuto, ma bi jiŋ ari Wia jaŋ benu ari u keri u peniŋ nɛɛ? ");
INSERT INTO sil_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ŋii wiaa nialiŋ si bi ba penee keri aŋ tuto wialiŋ Moosis si ŋmuŋsa bil di niaa tuto, ba jaŋ joŋ cheeriŋ pima. Ma niaa deeŋba jiŋ wialiŋ Moosis si ŋmuŋsa bil nɛ a kikeri ma penee maa, aŋ ka ma chichei wialiŋ. ");
INSERT INTO sil_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ŋ yaraa wu-ŋaalaa dee bi ŋaa ŋ ŋaa Ju̱u tiina. Ŋ si keri ŋ namia ma ta dee bi tii. ");
INSERT INTO sil_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ama nii-la si ŋaa Ju̱u-titii, u tuɔŋ wu-ŋaalaa lɛ nɛ tii u ŋaa Ju̱u tiina. Nii-la si kɛŋ tuɔ-pula, u nɛ nii-la si keri u peniŋ. Wia Diŋ-zɔŋ-la nɛ jaŋ wuo ŋaa ŋii piŋ, ŋ si keri ŋ yaraa namia ta dee. Wia nɛ jaŋ bɛsɛ u tiina lɛ, nuhuobiine dee bi jaŋ bɛsɛu lɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Bɛɛ nɛ saa Ju̱u tiŋŋaa kaa kii nialiŋ si bi Ju̱u tiŋŋaa ŋaa? Ba síi keri ba pene-la maa, u bubuɔŋ nɛ bɛɛ? ");
INSERT INTO sil_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Wiaa yuga nɛ Ju̱u tiŋŋaa kaa kii nialiŋ si bi Ju̱u tiŋŋaa ŋaa. Wialiŋ kala tuɔŋ wu-baliŋ nɛ ŋla: Ju̱u tiŋŋaa nɛ Wia joŋ u niiŋ wiaa pa. ");
INSERT INTO sil_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ka di Ju̱u tiŋŋaa dɔŋsuŋ nɛ bi Wia niiŋ wialiŋ yarida ŋaa, u jaŋ wuo leŋ di Wia sí wutitii kɛŋ koo? ");
INSERT INTO sil_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ai. Di niaa kala nɛ paala ŋaa wu-nyiaraa maa, Wia-na jaŋ kɛŋ wutitii. Ba ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ a tigɛ Wia lɛ. Ba si, “U maga di ba na di wialiŋ ŋ síi bul ŋaa wutitii nɛ, di ba nɛ joŋ cheeriŋ pipiŋ maa, di ŋ kiaa ha siŋ.” ");
INSERT INTO sil_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ka di la wu-bɔmɔ-la la síi ŋaa, di ba níi chɛ di ba dagɛ di Wia kɛŋ wutitii, bɛɛ nɛ laa chɛ di la bul? Mii chɛ di mi bul nuhuobiine tuɔbiinaa wiaa nɛ a piɛsɛ: Di Wia nɛ dɔgisɛla a tiŋ la wu-bɔŋŋɔɔ wiaa, u kiaa bi siŋ u si ŋaa ŋii, koo? ");
INSERT INTO sil_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ŋii dee. Di Wia nɛ fa bi wutitii kɛnɛ, ɛɛ nɛ u fa jaŋ wuo dii dunia niaa sariya? ");
INSERT INTO sil_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ama di mi wu-nyiari-la nɛ wuo leŋ di Wia wutitii-la chaasa chiŋ a laa yiriŋ puu, bɛɛ nɛ tii saa u jaŋ dii mi sariya a bul di mi ŋaa haachɛ tiina nɛ, a joŋ cheeriŋ pimi? ");
INSERT INTO sil_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Di ŋii nɛ fa, mi fa jaŋ bul di má leŋ di la ŋaa wu-bɔŋŋɔɔ a na wu-zɔŋŋɔɔ. Niaa dɔŋsuŋ paala tuusɛla nɛ aŋ bul di la dagɛ di nuu ŋaa wu-bɔŋŋɔɔ, u jaŋ na wu-zɔŋŋɔɔ. Wia jaŋ joŋ cheeriŋ pi niaa deeŋba. U nɛ ŋaa ŋii, u kiaa jaŋ siŋ. ");
INSERT INTO sil_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ɛɛ nɛ saa? Ma biina la Ju̱u tiŋŋaa kpia nialiŋ si bi Ju̱u tiŋŋaa ŋaa nɛɛ? Ai, la biba kpia. Mi laa sipaaŋ bul ari nialiŋ si ŋaa Ju̱u tiŋŋaa ari nialiŋ si bi Ju̱u tiŋŋaa ŋaa kala, ba ŋaa haachɛ timma nɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ba ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ a bul, “Nuu-kala bi tuɔ-pul tiina ŋaa Wia sipaaŋ, ni-bala ma bi tuɔ-pul tiina ŋaa. ");
INSERT INTO sil_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nuu-kala siaa bi suro duu jiŋ Wia wialiŋ bubuɔŋ, nuu-kala ma bi Wia bee chichɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Nuu-kala joŋ hariŋ yia Wia nɛ a kala ŋiŋaa wu-bɔŋŋɔɔ. Nuu-kala bi wu-zɔŋ ka ŋaa. Ni-bala ma tuo. ");
INSERT INTO sil_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ba niiŋ wu-bulaa nagɛ buɔ-suruŋ síi suɔrɛ ŋii nɛ. Ba bul wiaa nyinyisɛ niaa. Wii-kala ba si yie bul kɛŋ huoŋ nɛ a nagɛ dimiŋ huoŋ.” ");
INSERT INTO sil_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Ba yie ŋmiɛsa hihɛ niaa lɛ, a nina baaniŋ niaa nyuŋ kiŋkɛŋ.” ");
INSERT INTO sil_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ba baaniŋ bi diene aŋ sisii. Di ba baaniŋ nɛ sie, ba yie fá lima lima a mu kpukpu niaa. ");
INSERT INTO sil_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Di ba nɛ mu lee-na kala, ba yie chei lee-la nɛ a ŋaa niaa tuɔsaa chei. ");
INSERT INTO sil_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ba bi jiŋ ba si jaŋ ŋaa ŋii di ba di niaa siŋ.” ");
INSERT INTO sil_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Ba bi Wia ma ka fá.” ");
INSERT INTO sil_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","La jima ari wialiŋ Moosis si ŋmuŋsa bil di niaa tuto, duu nɛ dagɛ wii-kala, nialiŋ síi to wialiŋ nɛ u daga pipa. Ŋii wiaa nuu-kala bira bi jaŋ wuo bul wii-kala, dunia nuu-kala jaŋ laa cheeriŋ Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nuu-kala bi jaŋ wuo to wialiŋ Moosis si bile lɛ a wuo kɛŋ tuɔ-pula Wia sipaaŋ. Wialiŋ Moosis si bile di niaa tuto nɛ dagɛla la jiŋ ari nuu-kalaa ŋaa haachɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ama lɛɛlɛ Wia suri woŋbiiŋ nɛ di niaa to a kɛŋ tuɔ-pula u sipaaŋ. U woŋbii-la bi wialiŋ Moosis si bile lɛ lia. Ama wialiŋ Moosis si bile ari wialiŋ nialiŋ fa si bula, Wia Diŋ-zɔŋ-la doluŋ lɛ, ba kala fa bul woŋbii-la wiaa nɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nialiŋ si laa Yesu Kirisito wiaa dii, nialiŋ si ŋaa Ju̱u tiŋŋaa koo nialiŋ si bi Ju̱u tiŋŋaa ŋaa kala, ba nɛ jaŋ kɛŋ tuɔ-pula u sipaaŋ. U biba kaa pɔrɛ, ");
INSERT INTO sil_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","bɛɛ wiaa nuu-kala kɛŋ haachɛ nɛ a bi Wia wuo china kpikpagɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ama Wia lahɔrimɔ lɛ ba kɛŋ tuɔ-pula nɛ u sipaaŋ. Yesu Kirisito nɛ laaba ta a ŋaa ba ŋaa tuɔ-pul timma Wia sipaaŋ. U ŋaa ŋii chɔgita nɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Wia leŋe Yesu Kirisito suu a joŋ u chaliŋ jaasɛ, di Wia joŋ u baaniŋ ta, baaŋ-la u fa si na a tiŋ la haachɛba wiaa, aŋ joŋ la haachɛba a chɛla. Nii-la kala si laa Yesu Kirisito wiaa dii jaŋ laa chɔgita deeŋ. Wia kɛŋ wutitii a dagɛ ŋii ari u fa kɛŋ kenyiri nɛ, a bee kieli nuhuobiinee haachɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Lɛɛlɛ Wia bira bi ŋii ka ŋaa. U dagɛ niaa kala haachɛba a piba nɛ. Ama u dagɛ duu kɛŋ wutitii, bɛɛ wiaa di nuu-kala nɛ laa Yesu wiaa dii, u jaŋ kɛŋ tuɔ-pula Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Wu-bɛɛ nɛ saa la jaŋ kaa bigisi la titia lɛ? Wii-kala tuo. Bɛɛ nɛ tii? Wu-zɔmɔ-la la si ŋaa nɛ tii? Ai, ama la yarida nɛ tii la bira bi wii-kala kɛnɛ di la bigisi la titia lɛ. ");
INSERT INTO sil_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","La ŋaa yarida ari nuu jaŋ wuo na tuɔ-pula Wia sipaaŋ a tiŋ u si laa Yesu dii lɛ. Di la níi to wialiŋ Moosis si bile, la bi jaŋ wuo kɛŋ tuɔ-pula deeŋ Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ma biina ari nialiŋ si ŋaa Ju̱u tiŋŋaa duŋduŋa nɛ jaŋ wuo to Wia? Ai. Nialiŋ si bi Ju̱u tiŋŋaa ŋaa ma jaŋ wuo tou. ");
INSERT INTO sil_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Wia si ŋaa kubala, u jaŋ leŋ di nialiŋ síi keri ba penee kɛŋ tuɔ-pula a tiŋ ba si laa Yesu wiaa dii wiaa. Nialiŋ ma si bi Ju̱u tiŋŋaa ŋaa, u jaŋ leŋ di ba ma kɛŋ tuɔ-pula a tiŋ ba ma si laa Yesu wiaa dii wiaa. ");
INSERT INTO sil_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","La saa jaŋ wuo joŋ wialiŋ Moosis si bile a ta, a tiŋ la yarida wiaa koo? Ai, la yarida-la leŋe Moosis si bil wialiŋ wasa zɔŋ nɛ. ");
INSERT INTO sil_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Wu-bɛɛ nɛ saa la kɛŋ di la bul a tigɛ la naabalima Abiraham lɛ, nii-la lɛ la kala si to a ku ŋaa u nihee? ");
INSERT INTO sil_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Di Wia nɛ fa leŋe u kɛŋ tuɔ-pula u sipaaŋ a tiŋ u wu-zɔmɔ-la u si ŋaa lɛ, u fa jaŋ wuo bibigisi u titia lɛ, ama Wia teeŋ dee. ");
INSERT INTO sil_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Wia teniŋ tuɔŋ ba bula ari Abiraham laa Wia dii nɛ. U yarida-la nɛ tii Wia ŋaa u kɛŋ tuɔ-pula u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Di nuu nɛ tiŋ tiŋtiŋŋaa, u maga di ba ti̱mu nɛ. Ku-la ba si joŋo ti̱mu, u bi naga ari chɔgita nɛ ba joŋo pu. U tima nɛ a laa. ");
INSERT INTO sil_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ama nii-la si bi wu-zɔŋŋɔɔ ka ŋaa aŋ ŋaa Wia yarida, a laa dii ari Wia jaŋ wuo ŋaa di nii-la si ŋaa wu-bɔŋŋɔɔ na tuɔ-pula u sipaaŋ, u yarida-la jaŋ ŋaa duu kɛŋ tuɔ-pula Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","La naabalima Devit ma fa bul ŋii nɛ. U si di Wia nɛ leŋe di nuu kɛŋ tuɔ-pula u sipaaŋ, ka u bi ŋii ŋaa a tiŋ u tiina wu-zɔŋŋɔɔ ŋaaniŋ lɛ, u tiina tuɔŋ jaŋ tɔrɛ. Ŋla nɛ Devit bul: ");
INSERT INTO sil_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Nialiŋ wu-bɔŋŋɔɔ Wia si joŋo chɛba a kɛŋ ba haachɛba faa, nuu-kala bira bi na a kaa mu wuu, ba tuɔŋ jaŋ tɔrɛ. ");
INSERT INTO sil_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nii-la ma Wia si bi u haachɛbaa beŋ, u ma tiina tuɔŋ jaŋ tɔrɛ.” ");
INSERT INTO sil_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Tuɔtɔruŋ deeŋ wiaa saa Devit si bula, u ŋaa nialiŋ síi keri ba penee duŋduŋa kuŋ nɛɛ? Ai, nialiŋ ma si bi ba penee keri, ba ma tiiu nɛ. La laa sipaaŋ bul ari yarida nɛ tii Abiraham kɛŋ tuɔ-pula Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Bua bɛɛ lɛ nɛ Wia ŋaa wiiŋ deeŋ Abiraham lɛ? U ŋaa ŋii bua-la lɛ duu keri u peniŋ nɛ koo duu ha bi u peniŋ kere nɛɛ? U ŋaa ŋii duu ha bi u peniŋ kere. ");
INSERT INTO sil_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abiraham si keri u peniŋ ŋii ŋaa magil nɛ. Uu dagɛ ari u si ŋaa Wia yarida nɛ tii u kɛŋ tuɔ-pula u sipaaŋ, ka u ha bi u peniŋ kere. U ŋii ŋaa Abiraham ku ŋaa nialiŋ kala si bi ba penee kere naabalima. Nialiŋ si kɛŋ tuɔ-pula Wia sipaaŋ a tiŋ ba yarida wiaa, Wia leŋe ba ma ŋaa Abiraham nihee. ");
INSERT INTO sil_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","U nɛ ŋaa nialiŋ si keri ba penee ma nyimma. Ama u bi naga ba si keri ba penee duŋduŋa wiaa nɛ tii u ŋaa ba nyimma. Ba kɛŋ yarida a pɛ ba penee keriŋ lɛ nɛ, ari Abiraham ma fa si kɛŋ yarida ŋii, aŋ-na keri u peniŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abiraham ari u doho niaa nɛ Wia fa bula pa di ba jaŋ dii dunia. U bi naga Abiraham fa si to wialiŋ Moosis fa si bile di niaa tuto nɛ tii Wia bul ŋii. Ama Abiraham fa si ŋaa Wia yarida nɛ tii Wia leŋ u kɛŋ tuɔ-pula u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Di nialiŋ síi to wialiŋ Moosis fa si bile di niaa tuto, di ba duŋduŋa nɛ fa jaŋ dii dunia, ŋii-na niaa yarida fa ŋaa pɛi nɛ. Wialiŋ Wia si bula ma fa ŋaa pɛi. ");
INSERT INTO sil_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Wialiŋ Moosis fa si bile di niaa tuto ŋaa Wia baaniŋ sisii niaa nyuŋ nɛ, bɛɛ wiaa ba bi baa to. Di wialiŋ Moosis fa si bile nɛ fa tuo, niaa fa bi wialiŋ ka chei. ");
INSERT INTO sil_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Wii-la Wia fa si bula ari u jaŋ ŋaa a pi Abiraham ari u doho niaa, u jaŋ joŋo piba chɔgita a tiŋ u síi fába nennige ŋii. Ba yarida wiaa nɛ tii u jaŋ joŋo piba. U bi naga ari u joŋo pi nialiŋ síi to wialiŋ Moosis si bile duŋduŋa nɛ, ama ba di nialiŋ kala si ŋaa yarida ari Abiraham fa si ŋaa yarida ŋii, ba kala nɛ u joŋo pa, nialiŋ si keri ba penee ari nialiŋ si bi ba penee kere kala, bɛɛ wiaa Abiraham nɛ ŋaa la kala nyimma Wia sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ba fa ŋmuŋsɛ ŋii nɛ Wia teniŋ tuɔŋ. Wia bula a tigɛ Abiraham lɛ a bul, “Mi leŋe ŋ ŋaa ta-geŋtisiŋ yugɛ nyimma nɛ.” Wia-la si wuo leŋ kialiŋ kala si suba, di ba sii suuŋ lɛ a kɛŋ miisiŋ, aŋ bira wuo dagɛ wialiŋ si jaŋ ŋaa aŋ ha bi ŋaa, Wia deeŋ nɛ Abiraham laa dii. ");
INSERT INTO sil_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Wia fa bula pi Abiraham ari u jaŋ ku ŋaa ta-geŋtisiŋ yugɛ nyimma. U fa bi maga di Abiraham yiyiɛlɛ wiiŋ deeŋ, aŋ ka u via aŋ haa yiɛlɛ. Ŋii wiaa u sɛnɛ ku ŋaa ta-geŋtisiŋ yugɛ nyimma ari Wia fa si bul ŋii pu. Wia fa bula pu a bul di u doho niaa jaŋ yugɛ a magɛ chɛŋwulaa. ");
INSERT INTO sil_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Bua-la lɛ Wia fa si bul ŋii pi Abiraham, di Abiraham ka mua ka duu yi jisiŋ zɔlɔ. U jima ari u hiɛsa nɛ, u yaraa bira bi doluŋ kɛnɛ. U haala Saara ma ta ŋaa ha-piri nɛ a ma hiɛsɛ, a bi bii wuo lul. Ari u si hiɛsa ŋii kala, u ha kɛŋ yarida. ");
INSERT INTO sil_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Wia si bul ŋii pu, u bi u titia kaa bibegili a leŋ u yarida. U chiŋ u yarida-la lɛ nɛ a kɛŋ doluŋ, a didɛnnɛ Wia. ");
INSERT INTO sil_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","U paala chaasa kɛŋ yarida nɛ woruŋ ari Wia si si u jaŋ ŋaa wii-la, u jaŋ sɛnɛ ŋaa. ");
INSERT INTO sil_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A tiŋ u si kɛŋ yarida ŋii wiaa, Wia leŋ u kɛŋ tuɔ-pula u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ba fa si ŋmuŋsa a bul di Wia nɛ leŋ Abiraham kɛŋ tuɔ-pula u sipaaŋ, Abiraham duŋduŋa wiaa dee ba ŋmuŋsɛ ŋii. ");
INSERT INTO sil_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ba ŋmuŋsɛ ŋii la ma wiaa nɛ, la nialiŋ si laa dii ari Wia chisɛ la Tiina Yesu suuŋ lɛ. U jaŋ leŋ di la ma kɛŋ tuɔ-pula u sipaaŋ, ");
INSERT INTO sil_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","bɛɛ wiaa u leŋ Yesu suu a tiŋ la haachɛba wiaa nɛ, a bira leŋ u sii suuŋ lɛ di la kɛŋ tuɔ-pula u sipaaŋ. ");
INSERT INTO sil_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","La si kɛŋ tuɔ-pula Wia sipaaŋ a tiŋ la yarida wiaa, Wia to la Tiina Yesu Kirisito lɛ nɛ a leŋ la ŋaa sima. ");
INSERT INTO sil_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","A tiŋ u wiaa, la kɛŋ woŋbiiŋ di la mu Wia teeŋ, duu fála nennige a pɛla lɛ. Dimɛ nɛ la hɛ lɛɛlɛ aa juɔsɛ, a kɛŋ yiɛlaa ari la si jaŋ kpaa Wia yiri-la chɛɛ dɔŋ. ");
INSERT INTO sil_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ŋii ma duŋduŋa dee, la haa juɔsɛ nɛ ari hɛɛ-la kala la ha síi na a tiŋ Kirisito wiaa, bɛɛ wiaa hɛɛ-la jaŋ leŋ di la wuo kɛŋ kenyiri. ");
INSERT INTO sil_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Di la nɛ kɛŋ kenyiri, u jaŋ wuo leŋ di la wuo chiŋ la yarida naaŋ lɛ kpaŋ kpaŋ. Di la nɛ chiŋ la yarida naaŋ lɛ kpaŋ kpaŋ, la jaŋ kɛŋ yiɛlaa. ");
INSERT INTO sil_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","La si kɛŋ yiɛlaa ŋii, la bi jaŋ kɔ di la dii hiisiŋ, bɛɛ wiaa Wia chola nɛ kiŋkɛŋ. U joŋ chonu-la a hɛ la tuɔŋ lɛ nɛ. U ŋaa ŋii u Diŋ-zɔŋ-la u si joŋo pila doluŋ lɛ nɛ. ");
INSERT INTO sil_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Bua-la lɛ la fa si bi doluŋ kɛnɛ di la wuo pɛ la titia lɛ, Kirisito laa la haachɛ tiŋŋaa nyuŋ suu nɛ. ");
INSERT INTO sil_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","U ŋaa wu-haa nɛ ari nuu si jaŋ laa tuɔ-pul tiina nyuŋ suu. Ari ŋii kala, ŋ bi pɔɔ nuu jaŋ kɛŋ nyu-duoŋ a wuo laa ni-pula nyuŋ suu. ");
INSERT INTO sil_vpl VALUES ("RM5_8","075_5_8