﻿USE sofia;
DROP TABLE IF EXISTS sofia.sig_vpl;
CREATE TABLE sig_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sig_vpl WRITE;
INSERT INTO sig_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Krisita doho nala rɛ nyɛ. Ʋ naabaa rɛ gyɩ yaa Deviti, Deviti mɛ naabaa yaa Abɩraham. ");
INSERT INTO sig_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abɩraham nɛ gyɩ lʋl Azɩkɩ. Azɩkɩ mɛ sii lʋl Gyeekɔbɩ. Gyeekɔbɩ mɛ sii lʋl Gyuda abee ʋ naabiisi. ");
INSERT INTO sig_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gyuda mɛ sii lʋl Pɛrɛsɩ abee Zɛra. (Ba nɩɩna feŋ nɛ gyɩ yaa Tama.) Pɛrɛsɩ mɛ bɩl sii lʋl Hɛzʋrɔŋ. Hɛzʋrɔŋ mɛ sii lʋl Rami. ");
INSERT INTO sig_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami mɛ sii lʋl Amiinadabu. Amiinadabu mɛ sii lʋl Naasuŋ. Naasuŋ mɛ sii lʋl Salmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔŋ mɛ sii lʋl Buwasi. (Buwasi nɩɩna feŋ nɛ gyɩ yaa Reehabɩ.) Buwasi mɛ sii lʋl Obɛdɩ. (Obɛdɩ nɩɩna feŋ nɛ gyɩ yaa Rufu.) Obɛdɩ mɛ sii lʋl Gyesi. ");
INSERT INTO sig_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Gyesi mɛ sii lʋl kuwori Deviti. Deviti mɛ sii lʋl Solomɔn. (Solomɔn nɩɩna rɛ fa yaa Yuriya haaŋ hʋ ʋ aa sʋba ka Deviti laa kpa). ");
INSERT INTO sig_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomɔn mɛ sii lʋl Rehobʋwam. Rehobʋwam mɛ sii lʋl Abigya. Abigya mɛ sii lʋl Asa. ");
INSERT INTO sig_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mɛ sii lʋl Gyihosafati. Gyihosafati mɛ sii lʋl Gyɔram. Gyɔram mɛ sii lʋl Yuzaya. ");
INSERT INTO sig_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yuzaya mɛ sii lʋl Gyotam. Gyotam mɛ sii lʋl Ahazɩ. Ahazɩ mɛ sii lʋl Hezikaya. ");
INSERT INTO sig_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezikaya mɛ sii lʋl Manaasi. Manaasi mɛ sii lʋl Amɔn. Amɔn mɛ sii lʋl Gyosaya. ");
INSERT INTO sig_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gyosaya mɛ sii lʋl Gyekonaya abee ʋ naabiisi. Saŋa no tɩyaŋ nɛ ba kasɩ Iziral tɩmma mʋ Baabilɔŋ paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba gyɩ aa kasɩ Iziral tɩmma mʋ Baabilɔŋ paalʋʋ hal tɩyaŋ nɛ, Gyekonaya lʋl Siyatiil, Siyatiil mɛ sii lʋl Zerubabɛl. ");
INSERT INTO sig_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabɛl mɛ sii lʋl Abiyudi. Abiyudi mɛ sii lʋl Ɛliyakim. Ɛliyakim mɛ sii lʋl Azɔ. ");
INSERT INTO sig_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔ mɛ sii lʋl Zadɔkɩ. Zadɔkɩ mɛ sii lʋl Akimu. Akimu mɛ sii lʋl Ɛliyudu. ");
INSERT INTO sig_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliyudu mɛ sii lʋl Ɛliyeza. Ɛliyeza mɛ sii lʋl Maataŋ. Maataŋ mɛ bɩl sii lʋl Gyeekɔbɩ. ");
INSERT INTO sig_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Gyeekɔbɩ mɛ rɛ yaŋ sii lʋl Gyosɛfʋ. Gyosɛfʋ mɛ sii kpa Mɛɛrɩ, nal hʋ aa lʋl Yesu, ba kɩ yɩrɩ Krisita, laataal hʋ Wɩɩsɩ aa lɩya. ");
INSERT INTO sig_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A piili Abɩraham a mʋ pele kuwori Deviti, Yesu Krisita naaba-doho fa yaa fi abee banaa rɛ. A yaŋ bɩl piili bee kuwori Deviti a mʋ kɩ pele saŋa hʋ ba aa kasɩ Iziral tɩmma mʋ Baabilɔŋ paalʋʋ hʋ, Yesu naaba-doho gyɩ yaa fi abee banaa rɛ. A bɩl lɩɩ haŋ saŋa hʋ mɛ a mʋ pele saŋa hʋ ba aa lʋl Krisita, laataal hʋ Wɩɩsɩ aa lɩya, ʋ naaba-doho gyɩ yaa fi abee banaa rɛ. ");
INSERT INTO sig_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nyɛ rɛ Yesu Krisita lʋlɩɩ naasɩ tɩŋa: Ʋ naa Mɛɛrɩ abee Gyosɛfʋ gyɩ wee nyʋwa rɛ anɩɩ ba sɩ yal dɔmɔŋ. Amɛ ba ha gyɩ bɩ yal dɔmɔŋ, aŋka Wɩɩsɩ Wiyesi Welii hʋ dee leŋ Mɛɛrɩ kaŋ luwol. ");
INSERT INTO sig_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gyosɛfʋ gyɩ yaa tɩpʋlʋŋ tɩɩna rɛ. Ɛɛ wɩya ʋ gyɩ bee kyɛ dɩ ʋ we Mɛɛrɩ hɩɩsɩ gyamaa tɩyaŋ, aŋ gyɩ kɩ kyɛ dɩ ʋ lʋwɔlɩ vɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ʋ gyɩ aa bɩɩnɩ gɛɛ tɩyaŋ nɛ, malɩka ko ʋ lee duwoso tɩyaŋ a basɩ tɩya ʋ a baa, “Gyosɛfʋ, Kuwori Deviti doho nal, ta leŋ dɩ kambɩŋ kana ɩ, ɩ aa sɩ kpa Mɛɛrɩ a yaa ɩ haaŋ, beewɩya Wɩɩsɩ Wiyesi Welii hʋ dee rɛ tɩŋ ʋ kaŋ biye no luwol. ");
INSERT INTO sig_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʋ sɩ lʋl boyoŋbiye, dɩ ɩ we ʋ feŋ Yesu. Feŋ hʋ memii rɛ yaa Laataal, beewɩya ʋ rɛ sɩ laa ʋ nala ta ba wɩbɔmɔ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wɩya no buloŋ gyɩ yaa rɛ dɩ wɩya hʋ á Tɩɩna Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal kɩdɩgɩ tɩyaŋ basɩ ko su ba bʋʋsɩ. Ʋ gyɩ tɩŋ ʋ tɩŋdaal no tɩyaŋ nɛ a baa, ");
INSERT INTO sig_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hatoluu kɩdɩgɩ ha aa bɩ gyɩŋ baal sɩ kaŋ luwol a lʋl boyoŋbiye dɩ ba kana ʋ kɩ yɩrɩ Imanuwɛl.” (Feŋ hʋ memii rɛ yaa “Wɩɩsɩ we á lee.”) ");
INSERT INTO sig_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gyosɛfʋ aa sii doo sɩya tɩyaŋ, ʋ gyɩ yaa gɛɛ hʋ malɩka hʋ aa basɩ tɩya ʋ rɛ, a gyɩ kpa Mɛɛrɩ mʋ ʋ dɩya a yaa ʋ haaŋ. ");
INSERT INTO sig_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amɛ ʋ beel-ʋ ha gyɩ bɩ gyɩŋ dɔmɔŋ anɩɩ baal bee haaŋ aŋka Mɛɛrɩ lʋl boyoŋbiye. Nyɛ rɛ Gyosɛfʋ we biye hʋ feŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Bɛtɩlɛhɛm tɩyaŋ nɛ ba gyɩ lʋl Yesu. Bɛtɩlɛhɛm gyɩ yaa tɔbiye rɛ, a we Gyudɩya paalʋʋ tɩyaŋ. Haŋ saŋa hʋ Kuwori Hɛrɔtɩ rɛ gyɩ yaa doŋ paalʋʋ kuworibal. Ba gyɩ aa lʋl Yesu, ʋ bɩ pɩɩsa ka wɩgyʋnna badɔmɔŋ aa gʋnnɩ kyɩŋwʋlɩya wɩkanɩya sii lɩɩ tɩɩmemii dɩɩlaŋ, a ko Gyerusalɛm, a ko pɩyɛsɩ, a baa, “Lee tɩyaŋ nɛ ba lʋl biye hʋ aa sɩ yaa Gyuuma kuwori hʋ? Á na kyɩŋwʋlɩɩ rɛ tɩɩmemii tɩyaŋ, ʋ daga anɩɩ ba lʋla ʋ rɛ á ko dɩ á kyʋwalɩ ʋ a kpa ʋ gyɩrɩma tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuwori Hɛrɔtɩ gyɩ aa nɩɩ wɩɩ no, kambɩŋ gyɩ kaŋ ʋ bee Gyerusalɛm tɩmma buloŋ nɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ɛɛ rɛ ʋ gyɩ yɩrɩ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ a ko laŋŋɩ, a pɩyɛsɩ ba a baa, “Lee tɩyaŋ nɛ ba sɩ lʋl Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya?” ");
INSERT INTO sig_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Ba sɩ lʋla ʋ Bɛtɩlɛhɛm aa we Gyudɩya paalʋʋ tɩyaŋ. Ɛɛ rɛ Wɩɩsɩ tɩŋdaal hʋ gyɩ sabɩ. Ʋ gyɩ baa dɩ ");
INSERT INTO sig_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Wɩɩsɩ baa, “Bɛtɩlɛhɛm yaa tɔbiye rɛ Gyudɩya paalʋʋ tɩyaŋ. Amɛ Gyudɩya paalʋʋ buloŋ tɩyaŋ, Bɛtɩlɛhɛm nala rɛ yaa nɩbala, beewɩya ba tɩyaŋ nɛ Iziral kuwori sɩ lɩɩ, nal hʋ aa sɩ kɩ deŋ ŋ nala, Iziral tɩmma.” ");
INSERT INTO sig_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Doŋ nɛ Kuwori Hɛrɔtɩ lʋwɔlɩ yɩrɩ wɩgyʋnna hʋ aa lɩɩ tɩɩmemii ko, a kaŋ ba mʋ faŋa a pɩyɛsɩ ba dɩ ba daga ʋ saŋa hʋ tɩɩ kyɩŋwʋlɩɩ hʋ aa lɩya. Ba daga tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɛɛ rɛ Kuwori Hɛrɔtɩ ta ba dɩ ba mʋ Bɛtɩlɛhɛm, aŋ basɩ tɩya ba a baa, “Ma mʋ kyɛ biye hʋ abee sɩfɩyasɩ. Ma yaŋ ko na ʋ pɛ, ma leŋ dɩ ŋ mɛ kaŋ duwoso, dɩ ŋ mɛ mʋ kyʋwalɩ ʋ a kpa ʋ gyɩrɩma tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba aa nɩɩ gɛɛ, ba lɩɩ kpa ŋmanɩɩ a kɩ mʋ, kyɩŋwʋlɩɩ hʋ ba fa aa naa tɩɩmemii bɩl laa ba sɩya gɛɛɛ, a mʋ sɩŋ kyugili lee hʋ biye aa we. ");
INSERT INTO sig_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba aa naa kyɩŋwʋlɩɩ hʋ gɛɛ, ba tenni buloŋ fɩyɛlɩ, ba kɩ gyʋwɔsɩ. ");
INSERT INTO sig_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba aa mʋʋ pele lee hʋ biye hʋ aa we, ba mʋ gyʋʋ dɩya hʋ a na biye hʋ abee ʋ naa Mɛɛrɩ. Ɛɛ rɛ ba tuu gbinni biye hʋ sɩya tɩyaŋ a kyʋwalɩ ʋ a kpa ʋ gyɩrɩma tɩya ʋ, aŋ puri ba kyʋgɩsɩ a lɩɩ salma abee wɩsɩnaaŋ abee kɩŋ kɩdɩgɩ sʋwala aa sʋma ba kɩ yɩrɩ mɛɛ, a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ɛɛ rɛ Wɩɩsɩ basɩ tɩya ba, ba duwoso tɩyaŋ abee sɩfɩyasɩ anɩɩ ba ta ko mɩɩgɩ mʋ Kuwori Hɛrɔtɩ lee. Nyɛ rɛ ba sii a tɩŋ ŋmaŋdɩma a mɩɩgɩ mʋ ba paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wɩgyʋnna hʋ bee mʋyɩ hal tɩyaŋ nɛ Gyosɛfʋ duwosi na malɩka dɩ ʋ ko ʋ lee a basɩ tɩya ʋ a baa, “Sii kpa biye hʋ abee ʋ naa a fá mʋ Igyipiti. Ma we doŋ a kaŋ kɩ mʋ saŋa hʋ ŋ bɩl aa sɩ tɩya ma ŋmanɩɩ dɩ ma lɩɩ doŋ, beewɩya Kuwori Hɛrɔtɩ aa kyɛ dɩ ʋ kpʋ biye hʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɛɛ rɛ Gyosɛfʋ gyɩ sii kpa biye hʋ bee ʋ naa buloŋ a mʋ Igyipiti paalʋʋ tebine. Doŋ tɩyaŋ nɛ ba gyɩ we a mʋ pele saŋa hʋ Kuwori Hɛrɔtɩ gyɩ aa ko sʋba. ");
INSERT INTO sig_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wɩɩ no gyɩ yaa rɛ dɩ wɩɩ hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal tɩyaŋ basɩ ko yaa wɩtɩɩ. Wɩɩsɩ gyɩ baa, “Ŋ biye gyɩ we Igyipiti paalʋʋ tɩyaŋ nɛ ŋ lɩɩ ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kuwori Hɛrɔtɩ gyɩ aa ko gyɩma anɩɩ wɩgyʋnna hʋ mʋrɩ ʋ rɛ, ʋ na baaŋ kɩŋkaŋ. Wɩgyʋnna hʋ gyɩ aa daga ʋ saŋa hʋ ba aa lʋl Yesu wɩya, ʋ sii ta ʋ laalyuwolo dɩ ba mʋ Bɛtɩlɛhɛm abee tɔbiisi hʋ buloŋ aa kpaga doŋ, a kpʋ boyoŋbiisi hʋ buloŋ ha aa yaa bɩsɩ balɩya a kaŋ kɩ tuu. ");
INSERT INTO sig_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wɩɩ no leŋ wɩɩ hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Gyɛrimaya tɩyaŋ basɩ ko yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Wɩɩ hʋ Gyɛrimaya gyɩ aa basa rɛ nyɛ: “Nal lɛ aa wii Rama tɩyaŋ, a wii kɩ gʋwagɩ Rekyil lɛ aa wii ʋ balɩya aa sʋba wɩya, a pɔ dɩ ʋ bee tallɩ.” ");
INSERT INTO sig_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","21","Kuwori Hɛrɔtɩ sʋʋ hal tɩyaŋ, Gyosɛfʋ bɩl duwosi a na malɩka dɩ ʋ ko ʋ lee Igyipiti paalʋʋ tɩyaŋ a basɩ tɩya ʋ a baa, “Sii kpa biye hʋ abee ʋ naa a mɩɩgɩ mʋ Iziral paalʋʋ. Nala hʋ fa aa kyɛ dɩ ba kpʋ biye hʋ sʋba rɛ.” Ɛɛ rɛ ʋ sii kaŋ biye hʋ abee ʋ naa a mʋ we Iziral paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amɛ Gyosɛfʋ aa ko nɩɩ anɩɩ Kuwori Hɛrɔtɩ sʋba rɛ, ka ʋ biye Akɩlɔɔsɩ di koro Gyudɩya paalʋʋ tɩyaŋ, kambɩŋ gyɩ fa kana ʋ rɛ doŋ mʋyɩ wɩya. Ɛɛ rɛ Wɩɩsɩ bɩl basɩ tɩya ʋ duwoso tɩyaŋ abee sɩfɩyasɩ anɩɩ ʋ mʋ hɔŋ Galili paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ʋ aa mʋʋ Galili paalʋʋ, ʋ mʋʋ hɔŋ Nazarɛti tɩyaŋ nɛ. Nyɛ yaa rɛ dɩ wɩya hʋ Wɩɩsɩ aa tɩŋ ʋ tɩŋdaala hʋ tɩyaŋ basɩ ko yaa wɩtɩɩ. Ba gyɩ basa rɛ a baa, “Ba sɩ kana ʋ kɩ yɩrɩ Nazarɛti tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saŋa no tɩyaŋ nɛ baal kɩdɩgɩ ba aa yɩrɩ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ mɛ sii ko Gyudɩya paalʋʋ, a we pogo tɩyaŋ a piili kɩ basɩ Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ʋ gyɩ basɩ tɩya ba rɛ a baa, “Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ, beewɩya Wɩɩsɩbee koro hʋ kpaga rɛ!” ");
INSERT INTO sig_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gyɔɔŋ no wɩya rɛ Wɩɩsɩ gyɩ tɩŋ ʋ tɩŋdaal Azaaya tɩyaŋ a gyɩ basɩ gɛɛ. Ʋ gyɩ baa, dɩ Wɩɩsɩ baa, “Nal lɛ we pogo tɩyaŋ a heeli kɩ basɩ, “Ma marɩ ma tɩsɩ dɩ á Tɩɩna ko kɩ tɩŋa anɩɩ ma aa marɩ ŋmaŋ-deginii a pɔ nɩbal koyi gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nyɔgɩmaa pʋna gannɩ rɛ Gyɔɔŋ gyɩ fa kɩ laalɩ, aŋ aa kpa tɛpɩɩŋbii vʋwa ʋ tɩŋa. Nyɩŋgɩrɩgɩsɩ abee tʋʋ rɛ gyɩ yaa ʋ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nala gyɩ lɩɩ Gyerusalɛm abee Gyudɩya paalʋʋ abee tɔnɩ hʋ buloŋ aa kpaga Gyɔɔdaŋ fuwo hʋ buloŋ nɛ, a kɩ ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba aa ko lusi ba wɩbɔmɔ aŋ tuu Gyɔɔdaŋ fuwo hʋ, ʋ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amɛ Gyɔɔŋ aa ko na dɩ Farasiima abee Sadusiima yʋga aa kɩ ko ʋ lee dɩ ʋ fo ba wɩɩkyʋwalnɩɩ gɛɛ, ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ɛɛdɔŋ dʋma! Ma dawarɩ yʋga ma tɩyaŋ! Ma bɩɩna ma sɩ wuwo fá nyʋgɩsɩ kyɛɛ hʋ Wɩɩsɩ aa sɩ di nala sarɩya rɛ koo? ");
INSERT INTO sig_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ma kɩ yaa wɩya hʋ aa daga anɩɩ ma bɩrɩma lɩɩ ma wɩbɔmɔ tɩyaŋ nɛ, ");
INSERT INTO sig_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","aŋ ta bɩɩna anɩɩ Abɩraham aa yaa ma naabaa wɩya, Wɩɩsɩ bɩ sɩ dɔgɩsɩ ma. Ma leŋ dɩ ŋ basɩ tɩya ma anɩɩ Wɩɩsɩ sɩ wuwo leŋ dɩ bʋwa no ma aa naa nyɛ bɩrɩmɩ Abɩraham doho nala. ");
INSERT INTO sig_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ma na, Wɩɩsɩ yaa siri abee ʋ saa rɛ dɩ ʋ ŋmaŋ tɩɩsɩ lo. Tɩya hʋ buloŋ aa bee nɔŋ nɔŋweliye, ʋ sɩ ŋmana ʋ lo a paa we diŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nɩɩ dʋŋ nɛ ŋ kɛ kaŋ kɩ fo ma wɩɩkyʋwalnɩɩ, dɩ gɛɛ daga anɩɩ ma bɩrɩma lɩɩ ma wɩbɔmɔ tɩyaŋ nɛ, amɛ nal hʋ aa sɩ tɩŋa ŋ hal ko, ʋ kɛ sɩ kpa Wiyesi Welii hʋ abee diŋ a fo ma wɩɩkyʋwalnɩɩ. Ʋ rɛ te ŋ. Ŋ paalɩ bɩ maga dɩ ŋ kol ʋ naatɔbɔ mɛ gba. ");
INSERT INTO sig_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ʋ kol ʋ mɩkyaarɩgbaha rɛ, dɩ ʋ ko ŋmaa ʋ mɩya buloŋ teŋ, dɩ ʋ kpa gbaha hʋ a kyaarɩ lɩɩ miŋbii hʋ a we ʋ busol tɩyaŋ aŋ kpa mɩŋgyɔrʋ hʋ we diŋ tɩyaŋ. Diŋ hʋ aa bɩ sɩ maakyiye dɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saŋa hʋ Gyɔɔŋ gyɩ aa basɩ Wɩɩsɩ wɩya aŋ kɩ fo nala wɩɩkyʋwalnɩɩ hʋ tɩyaŋ nɛ, Yesu sii lɩɩ Galili paalʋʋ a ko Gyɔɔŋ lee Gyɔɔdaŋ fuwo hʋ tɩyaŋ dɩ ʋ fo ʋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amɛ Gyɔɔŋ aa naa gɛɛ, ʋ kɩ lʋga dɩ Yesu bɩrɩmɩ ʋ hakɩla. Ɛɛ rɛ Gyɔɔŋ basɩ tɩya ʋ a baa, “Ɩ rɛ maga dɩ ɩ fo ŋ wɩɩkyʋwalnɩɩ, aŋka ɩ mɩɩgɩ ko ŋ lee dɩ mɩyaŋ fo ɩ wɩɩkyʋwalnɩɩ?” ");
INSERT INTO sig_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ kɛ yaa gɛɛ ŋ aa baa ɩ yaa. Nyɛ rɛ sɩ leŋ dɩ á yaa wɩya hʋ buloŋ Wɩɩsɩ aa kyɛɛ.” Ɛɛ rɛ Gyɔɔŋ laa nyʋwa, a fo Yesu wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gyɔɔŋ aa yaŋ fo Yesu wɩɩkyʋwalnɩɩ hʋ ko teŋ, ɛɛ rɛ Yesu mɩɩgɩ lɩɩ nɩɩ hʋ tɩyaŋ a ko dɩ ʋ lɩɩ, dɩ ʋ naa wɩɩsɩnyuu lɔgɔ suri. Ka ʋ na Wɩɩsɩ Wiyesi Welii hʋ a kɩɩ gɛɛ anɩɩ kokomo, a ko tuu saga ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Doŋ tɩyaŋ nɛ, ʋ nɩɩ taal dɩ ʋ lɩɩ wɩɩsɩnyuu a baa, “Ŋ biikyoolii rɛ nyɛ. Ŋ teŋ fɩyɛla rɛ ʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ kpa Yesu gyʋʋ pogo. Doŋ tɩyaŋ nɛ Sɩtaanɩ magɩsɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nyɛ rɛ Yesu gyɩ we pogo hʋ tɩyaŋ kyɛyɛ mɔllɩ balɩya dɩ ʋ bɩ dii kɩŋ buloŋ tebine bee wɩɩhaa buloŋ. Ɛɛ rɛ losi gyɩ kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Doŋ nɛ Sɩtaanɩ ko basɩ tɩya ʋ a baa, “Na ɩ yaa Wɩɩsɩ Biye rɛ, ɛɛ kɛ leŋ dɩ bʋwa no bɩrɩmɩ kɩdiiliye.” ");
INSERT INTO sig_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, “Kɩdiiliye dʋŋ daa aa tɩya nihuwobiŋ mɩɩbol, amɛ wɩɩ buloŋ aa lɩɩ Wɩɩsɩ nyʋwa tɩyaŋ mɛ aa tɩya nihuwobiŋ mɩɩbol lɛ.” ");
INSERT INTO sig_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɛɛ rɛ Sɩtaanɩ kaŋ Yesu mʋ Gyerusalɛm, a kana ʋ mʋ gyɩŋ Wɩɩkyʋwaldɩɩbal hʋ nyugbaŋfara, ");
INSERT INTO sig_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aŋ basɩ tɩya ʋ a baa, “Na ɩ yaa Wɩɩsɩ Biye rɛ, ɛɛ kɛ sɩŋ daha aŋ gyaa tuu kyigisi taŋha tɩyaŋ. Beewɩya ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa dɩ Wɩɩsɩ baa, “Ŋ sɩ leŋ dɩ ŋ malɩkasɩ kɩ pɔ ɩ. Ba sɩ kyeŋ kana ɩ, dɩ ɩ naaŋ mɛ ta dige taŋha.” ");
INSERT INTO sig_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ba bɩl saba Wɩɩsɩ teŋ logiŋ kɩdɩgɩ tɩyaŋ nɛ a baa, “Ta kɩ magɩsɩ ɩ Tɩɩna Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɛɛ rɛ Sɩtaanɩ bɩl kaŋ Yesu mʋ gyɩŋ dogiŋbal kɩdɩgɩ nyuu a daga ʋ dʋnɩya koro abee ʋ weliŋ buloŋ fine, ");
INSERT INTO sig_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aŋ basɩ tɩya ʋ a baa, “Ŋ sɩ kpa kɩna no buloŋ tɩya ɩ, dɩ ɩ rɛ sɩ tuu gbinni a kyʋwalɩ ŋ abee gyɩrɩma.” ");
INSERT INTO sig_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Sɩtaanɩ, fasɩ mʋ ŋ sɩyaŋ! Wɩɩsɩ teŋ tɩyaŋ ba saba rɛ a baa, Kɩ kyʋwalɩ ŋ Tɩɩna Wɩɩsɩ dʋŋ abee gyɩrɩma aŋ kɩ tɩŋa ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Doŋ tɩyaŋ nɛ Sɩtaanɩ leŋ Yesu aŋ kpa mʋ. Doŋ nɛ ka malɩkasɩ ko tuu kyiyeli ʋ. ");
INSERT INTO sig_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu aa ko nɩɩ dɩ ba kaŋ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ tɔ dɩyaŋ, ɛɛ rɛ ʋ sii lɩɩ Gyudɩya paalʋʋ tɩyaŋ a kpa mʋ Galili paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nyɛ rɛ ʋ sii kpa mʋ Nazarɛti a bɩl lɩɩ doŋ a mɩɩgɩ kpa mʋ hɔŋ Kapɛɛnam tɩyaŋ. Tɔɔ no kpaga Galili fuwobal hʋ rɛ, a we Zebulɔŋ abee Nafitali paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wɩɩ no gyɩ yaa rɛ dɩ wɩɩ hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Azaaya tɩyaŋ basɩ ko yaa wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ʋ gyɩ baa, “Ma nala hʋ aa we Zebulɔŋ abee Nafitali paalʋʋ aa kyaasɩ Galili fuwobal hʋ, Gyɔɔdaŋ fuwobal hʋ kyolo, abee Galili paalʋʋ nala, lee hʋ tɩyaŋ nala hʋ aa bɩ yaa Gyuuma aa yʋga, ma nɩɩ daha, ");
INSERT INTO sig_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“Nala hʋ aa we bilhuu tɩyaŋ, ba na pʋlʋŋbal lɛ. Nala hʋ mɛ buloŋ aa bɩ gyɩŋ Wɩɩsɩ, Ba naa Wɩɩsɩ laatayɩ rɛ ʋ kɩɩ gɛɛ anɩɩ pʋlʋŋ nɛ kyaanɩ we ba tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saŋa no tɩyaŋ nɛ Yesu gyɩ piili kɩ basɩ Wɩɩsɩ wɩya a baa, “Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ, beewɩya, Wɩɩsɩbee koro hʋ kpaga rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu gyɩ kpaa Galili fuwobal hʋ nyʋwa a kpala kɩ baŋ dɩ ʋ naa fuwonaŋkasɩla balɩya dɩ ba aa kasɩ fuwonamɩɩsɩ abee ba keliŋsi. Ba gyɩ yaa nɩmmabalɩya rɛ. Kɩdɩgɩ feŋ nɛ yaa Siimɔŋ (ʋ feŋ kɩdɩgɩ mɛ rɛ yaa Piita.) Ʋ naabiye hʋ mɛ feŋ nɛ Aŋduru. ");
INSERT INTO sig_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ko kɩ tɩŋa ŋ hal. Ŋ sɩ daga ma gɛɛ ma aa sɩ kɩ kasɩ nihuwobisi.” ");
INSERT INTO sig_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Haŋ lagɩlagɩbiye hʋ ba kpa ba keliŋsi hʋ ta, aŋ sii tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu bɩl kpaa kɩ mʋ dɩ ʋ naa Gyemsi bee ʋ naabiye Gyɔɔŋ abee ba kuwo Zebedi, dɩ ba we nɩɩduworiboro tɩyaŋ a kɩ marɩ ba keliŋsi. ");
INSERT INTO sig_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɛɛ rɛ Yesu yɩrɩ ba, ba guu sii a leŋ ba nɩɩduworiboro hʋ abee ba kuwo buloŋ ta, aŋ tɩŋ Yesu hal. ");
INSERT INTO sig_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ɛɛ rɛ Yesu gɔllɩ Galili paalʋʋ buloŋ a kɩ daga nala Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ, a basɩ Wɩɩsɩ koro hʋ wɩweliye wɩya a kɩ tɩya nala aŋ pɛ kɩ tɩɩbɩ nala aa kaŋ wɩɩla iriŋ iriŋ buloŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɛɛ rɛ Yesu wɩya taalɩ Siiriya paalʋʋ buloŋ. Nala sii kaŋ ba wɩɩla tɩmma kɩ ko ʋ lee. Gbarɩga abee kpuŋkpuŋ-telle abee nala gyɩŋbɔmɔ aa kana abee wɩɩla iriŋ iriŋ buloŋ tɩmma rɛ ba kaŋ ko, Yesu tɩɩbɩ ba buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nyɛ rɛ nɩgyamaa sii giri lɩɩ Galili paalʋʋ abee tɔnɩ fi hʋ, abee Gyerusalɛm, abee Gyudɩya paalʋʋ a paa tɩŋ Yesu hal. Ba badɔmɔŋ mɛ gyɩ lɩɩ Gyɔɔdaŋ fuwo hʋ kyolo paalʋʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yesu aa naa nɩgyamaa hʋ gɛɛ, ʋ mʋ gyɩŋ hɔŋ dogimo nyuu tɩyaŋ, ka ʋ hatɩnna hʋ mɛ ko hɔŋ gol ʋ, ʋ piili kɩ daga ba abaa, ");
INSERT INTO sig_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nyusʋŋtɩmma rɛ yaa nala hʋ aa kpaa ba bayɩyɛla buloŋ we Wɩɩsɩ tɩyaŋ, ba aa rɛ sɩ di wɩɩsɩbee koro hʋ tɔnɔ. ");
INSERT INTO sig_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nyusʋŋtɩmma rɛ yaa nala hʋ aa wii, Wɩɩsɩ sɩ fɩyɛlɩ ba bembiye. ");
INSERT INTO sig_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nyusʋŋtɩmma rɛ yaa nala hʋ aa kaŋ ba tɩɩ kɩ hʋwɔlɩ, ba sɩ na kɩŋ hʋ wɩya Wɩɩsɩ aa wee nyʋwa baa ʋ sɩ kpa tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nyusʋŋtɩmma rɛ yaa nala hʋ aa kyo dɩ nal buloŋ yaa tɩpʋlʋŋ tɩɩna Wɩɩsɩ sɩya tɩyaŋ, Wɩɩsɩ sɩ tɩya ba ba wɩkyɛɛlɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nyusʋŋtɩmma rɛ yaa nala hʋ aa fá nala sikii, Wɩɩsɩ mɛ sɩ fá ba sikii. ");
INSERT INTO sig_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nyusʋŋtɩmma rɛ yaa nala hʋ aa kaŋ tɩpʋlʋŋ Wɩɩsɩ sɩya tɩyaŋ ba aa rɛ sɩ na Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nyusʋŋtɩmma rɛ yaa nala hʋ aa marɩ nala dɔmɔŋ. Wɩɩsɩ sɩ kaŋ ba yaa ʋ balɩya. ");
INSERT INTO sig_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nyusʋŋtɩmma rɛ yaa nala hʋ ba aa dɔgɩsɩ akuu ba aa yaa wɩya hʋ aa kpaa ŋmanɩɩ Wɩɩsɩ sɩya tɩyaŋ wɩya. ba aa rɛ sɩ na wɩɩsɩbee koro hʋ tɔnɔ. ");
INSERT INTO sig_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dɩ ba aa rɛ kuu ŋ wɩya a kɩ tʋʋsɩ ma, a nyɩya wɩya kɩ tɩya ma, ka wɩbɔŋ buloŋ aa bɩ maga dɩ ba kpa tɩya nihuwobiŋ ba kpa tɩya ma, aŋ pɛ kɩ dɔgɩsɩ ma, ma leŋ dɩ ma tenni fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ma leŋ dɩ ma tenni fɩyɛlɩ, dɩ ma kɩ gyʋwɔsɩ, beewɩya ma tuno yʋga rɛ wɩɩsɩbee tɩyaŋ. Ba aa dɔgɩsɩ ma nyɛ, ɛɛ tɩɩ rɛ ba fa dɔgɩsɩ Wɩɩsɩ tɩŋdaala hʋ aa laa sɩya ko ma tɩyaŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ma kɩɩ gɛɛ rɛ anɩɩ yɩsɩ dʋnɩya nala buloŋ lee. Yɩsɩ sʋma, amɛ dɩ ʋ sʋmɩŋ nɛ ko lɩɩ, ɩ bɩl bɩ sɩ wuwo yaa dɩ ʋ sʋma. Ʋ aa mɩɩgɩ bɩrɩmɩ kɩtɔɔ rɛ, ba kpa yuwo ta nala nʋwɔsɩ kɩ baŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ma kɩɩ gɛɛ rɛ anɩɩ pʋlʋŋ dʋnɩya nala buloŋ lee. Tɔɔ buloŋ aa sɩŋ dogimo nyuu tɩyaŋ, ʋ bɩ sɩ wuwo faŋa. ");
INSERT INTO sig_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nal buloŋ mɛ aa kyɛ pʋlʋŋ ʋ dɩya tɩyaŋ, ʋ bɩ sɩ nyɔgɔ fɩŋtɩna gyʋʋ biŋ aŋ kpa gbaha kyige tɔ. Ʋ aa kpa saga fɩŋtɩŋdaaŋ tɩyaŋ nɛ, dɩ ʋ kyaanɩ tɩya nal buloŋ aa we dɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɛɛ tɩɩ rɛ ma mɛ maga dɩ ma kyaanɩ nala lee dɩ ba na wɩweliye hʋ ma aa yaa, a dannɩ ma Kuwo aa we wɩɩsɩbee tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ma ta bɩɩna anɩɩ ŋ ko dɩ ŋ paa Mɩrɩsɩ hʋ Moosi fa aa saba biŋ koo Wɩɩsɩ tɩŋdaala wɩdagɩya hʋ kɩdɩgɩ buloŋ ta rɛ? Ŋ bɩ ko dɩ ŋ paa ba ta, amɛ ŋ ko rɛ dɩ ŋ leŋ wɩya no su ba bʋʋsɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dʋnɩya abee wɩɩsɩnyuu aa sɩ pɩɩsɩ mɔɔgɛɛ, Mɩrɩsɩ hʋ Moosi fa aa saba biŋ, ba bɩ sɩ lɩɩ ba kɩdɩgɩ, koo ba kɩdɩgɩ libiye mɛ gba ta, see dɩ mɩrɩsɩ no buloŋ su ba bʋʋsɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nal hʋ buloŋ aa sɩ vɩya mɩrɩsɩ no kɩdɩgɩ ta, aŋ baa dɩ ʋ bɩ kaŋ tɔnɔ, aŋ kɩ daga ʋ dɔŋtɩŋsɩ dɩ ba kɩ yaa gɛɛ tɩɩ, ʋ tɩɩna bɩ sɩ na lee wɩɩsɩbee koro hʋ tɩyaŋ. Amɛ nal hʋ mɛ buloŋ aa tɩŋ Mɩrɩsɩ no, aŋ kɩ daga ʋ dɔŋtɩŋsɩ dɩ ba mɛ kɩ yaa gɛɛ, ʋ tɩɩna rɛ sɩ yaa nɩbal wɩɩsɩbee koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ŋ basɩ kɩ tɩya ma rɛ, see dɩ ma kaŋ tɩpʋlʋŋ a te Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima hʋ, aŋ kɩ yaa wɩya hʋ Wɩɩsɩ aa kyɛ, dɩ gɛɛ daa, ma bɩ sɩ wuwo gyʋʋ wɩɩsɩbee koro hʋ. ");
INSERT INTO sig_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma nɩya anɩɩ faafaa hʋ tɩyaŋ Wɩɩsɩ gyɩ basɩ tɩya ma naabaala rɛ a baa, ‘Ma ta kɩ kpʋʋ nala. Dɩ nal buloŋ nɛ ko kpʋ nal, ŋ sɩ di ʋ tɩɩna sarɩya.”’ ");
INSERT INTO sig_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amɛ lagɩlagɩ no, ŋ basɩ kɩ tɩya ma rɛ, nal hʋ buloŋ aa naa baaŋ ʋ dɔŋtɩɩna nyuu tɩyaŋ, Wɩɩsɩ sɩ di ʋ tɩɩna sarɩya. Nal hʋ mɛ buloŋ aa baa dɩ ʋ dɔŋtɩɩna yaa nɩgyɔrɩ rɛ, ba sɩ kana ʋ mʋ di ʋ sarɩya. Nal hʋ mɛ buloŋ aa baa dɩ ʋ dɔŋtɩɩna yaa nɩtɔɔ rɛ, ʋ tɩɩna sɩ mʋ gyʋʋ diŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ɛɛwɩya, dɩ ɩ rɛ kaŋ wɩɩsʋllɩ kɩna kɩ mʋ wɩɩsʋllɩ-kogu hʋ nyuu dɩ ɩ sʋla Wɩɩsɩ, aŋ liisi mʋ na anɩɩ ɩ yaa wɩɩ kyogi ɩ dɔŋtɩɩna rɛ, ");
INSERT INTO sig_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ʋ maga dɩ ɩ leŋ wɩɩsʋllɩ kɩna hʋ kogu hʋ sɩya tɩyaŋ nɛ aŋ mɩɩgɩ mʋ, dɩ ɩ bee ɩ dɔŋtɩɩna hʋ marɩ dɔmɔŋ, ka dɩ ɩ na mɩɩgɩ mʋ kpa kɩna hʋ a sʋla Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dɩ nal lɛ sama ɩ, a kana ɩ kɩ mʋ sarɩya lidiilii, yaa kuwokeri aŋ leŋ dɩ ma basɩ wɩɩ hʋ marɩ dɔmɔŋ ŋmanɩɩ tɩyaŋ lagɩ lagɩ aŋ na mʋ. Dɩ gɛɛ daa, ʋ sɩ kana ɩ mʋ we sarɩdiile nosi tɩyaŋ. Sarɩdiile hʋ mɛ sɩ kpa ɩ we porisi nosi tɩyaŋ, dɩ ba mɛ kana ɩ mʋ tɔ dɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, doŋ tɩyaŋ nɛ ɩ sɩ we a mʋ pele saŋa hʋ ɩ aa sɩ tuŋ kyɩŋ hʋ ba aa kere tɩya ɩ buloŋ teŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ma nɩya dɩ ba baa dɩ ma ta kɩ sɔnnɔ ");
INSERT INTO sig_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amɛ ŋ basɩ kɩ tɩya ma rɛ, nal hʋ buloŋ aa naa haaŋ a yaa ʋ kaŋ-pɩnɩɩ wɩya kayalŋa, ɩ tɩɩna kana ʋ pɩŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dɩ ɩ sɩɩ rɛ kana ɩ we wɩbɔmɔ yayɩ tɩyaŋ, lɩɩ ta. Ɩ aa sɩ gyʋʋ wɩɩsɩbee koro hʋ abee sɩtogo, ʋ rɛ kpɩya ba aa kpaa ɩ yuwo we diŋ tɩyaŋ abee sɩya balɩya. ");
INSERT INTO sig_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dɩ ɩ noŋ nɛ kana ɩ we wɩbɔmɔ yayɩ tɩyaŋ, kere ta. Ɩ aa sɩ gyʋʋ wɩɩsɩbee koro hʋ tɩyaŋ abee nokuu, ʋ rɛ kpɩya ba aa kpaa ɩ yuwo we diŋ tɩyaŋ abee nosi balɩya. ");
INSERT INTO sig_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ba basa Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, “Dɩ nal hʋ buloŋ nɛ aa kyɛ dɩ ʋ vɩya ʋ haaŋ, ʋ maga dɩ ʋ tɩɩna sabɩ haaŋ vɩyayɩ teŋ tɩya haaŋ hʋ anɩɩ ɩ vɩya ʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amɛ lagɩlagɩ no, ŋ basɩ kɩ tɩya ma rɛ, dɩ baal buloŋ nɛ ko kuu wɩɩ kɩdɩgɩ buloŋ wɩya a vɩya ʋ haaŋ, dɩ haaŋ hʋ aa sɔnnɩ wɩya daa, ka dɩ haaŋ hʋ mɩɩgɩ mʋ yala badɩma, ʋ tɩɩna leŋ haaŋ hʋ yaa sɔŋsɔnnɩ rɛ. Nal hʋ mɛ buloŋ aa kpaa haaŋ ʋ bala aa vɩya, ʋ tɩɩna yaa sɔŋsɔnnɩ rɛ Wɩɩsɩ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ma bɩl nɩya dɩ Wɩɩsɩ gyɩ basɩ tɩya faafaa nala rɛ a baa, “Dɩ ɩ rɛ ŋmɩyɛsɩ Wɩɩsɩ anɩɩ ɩ sɩ yaa wɩɩ, ta ko vɩya wɩɩ hʋ yayɩ. Amɛ yaa wɩɩ hʋ ɩ aa ŋmɩyɛsa baa dɩ ɩ sɩ yaa hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amɛ ŋ basɩ kɩ tɩya ma rɛ, dɩ mamaa rɛ aa kyɛ dɩ ma yaa wɩɩ, ma ta ŋmɩyɛsa Wɩɩsɩ. Ma ta ŋmɩyɛsɩ wɩɩsɩbee mɛ, beewɩya doŋ nɛ Wɩɩsɩ hɔŋ a kɩ deŋ dʋnɩya buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma ta ko ŋmɩyɛsɩ taŋha nyuu mɛ, beewɩya Wɩɩsɩ naasɩ liwiyesii rɛ gɛɛ. Ma ta ŋmɩyɛsɩ Gyerusalɛm mɛ, beewɩya Wɩɩsɩ, á Kuworibal hʋ, bee rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma ta paalɩ ko kɩ ŋmɩyɛsɩ ma nyuni mɛ, beewɩya ma bɩ sɩ wuwo leŋ dɩ ma nyupʋŋdɩgɩ bɩl koo dɩ ʋ pʋllɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dɩ wɩɩ rɛ ko maga dɩ ma baa ‘Waa,’ ma baa ‘Waa.’ Dɩ wɩɩ mɛ rɛ ko maga dɩ ma baa ‘Aayɩ,’ ma baa ‘Aayɩ.’ A lɩɩ gɛɛ hal tɩyaŋ, dɩ mamaa rɛ bɩl ko basɩ wɩɩ buloŋ, Sɩtaanɩ lee rɛ ʋ lɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ma nɩya anɩɩ Wɩɩsɩ teŋ hʋ gyɩ bɩl daga rɛ abaa, “Dɩ nal lɛ tɔbɔ ɩ sɩɩ pʋrɩ, ɩ mɛ tɔbɔ tɩɩna sɩɩ pʋrɩ, dɩ nal lɛ ŋmaa ɩ nyɩŋ kyuri, ɩ mɛ ŋmaa ʋ nyɩŋ kyuri.” ");
INSERT INTO sig_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amɛ ŋ basɩ kɩ tɩya ma rɛ anɩɩ dɩ nal lɛ yaa ɩ wɩbɔŋ, ta yaa wɩbɔŋ tuŋ ʋ tɩɩna. Dɩ nal lɛ ŋmaa ɩ noduu kyaŋkpaŋ tɩyaŋ, kaŋ ɩ nogɔbɔ kyaŋkpaŋ mɛ bɩrɩmɩ tɩya ʋ dɩ ʋ ŋmaa. ");
INSERT INTO sig_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Dɩ nal lɛ sama ɩ, dɩ ʋ laa ɩ gabiye, wuri ɩ gabal mɛ pɛ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dɩ nal lɛ fɩla ɩ dɩ ɩ kyʋŋ ʋ kyʋgɩsɩ a vala meeldaaŋ, leŋ dɩ ma bɩl vala meeldaaŋ a pɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dɩ ɩ rɛ kaŋ kɩŋ, dɩ nal sʋla, kpa tɩya ʋ. Dɩ nal lɛ ko ɩ lee a kɩ kyɛ kɩŋ dɩ ʋ kyɩma, dɩ ɩ rɛ kana, kpa kyɩma ʋ. ");
INSERT INTO sig_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ma nɩya dɩ ba baa dɩ ma kyo ma dɔŋtɩŋsɩ aŋ haasɩ ma dɔmɔ. ");
INSERT INTO sig_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amɛ ŋ basɩ kɩ tɩya ma rɛ, ma kyo ma dɔmɔ aŋ kyʋwalɩ Wɩɩsɩ kɩ tɩya nala hʋ mɛ aa dɔgɩsɩ ma. ");
INSERT INTO sig_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɛɛ sɩ leŋ dɩ ma yaa ma Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ balɩya. Ʋ leŋ ʋ wɩɩsɩ pɔsɔ kɩ we nɩbɔmɔ abee niweliye buloŋ tɩyaŋ nɛ, a leŋ duwoŋ nɩɩ kɩ tɩya niweliye abee nɩbɔmɔ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dɩ ɩ rɛ kyo nala hʋ aa kyo ɩ dʋŋ, ɩ bɩ sɩ kaŋ tuno wɩɩsɩbee tɩyaŋ. Beewɩya nɩbɔmɔ mɛ gba aa daga kyori no iriŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dɩ ɩ rɛ tʋwasɩ ɩ kyaŋsɩ dʋŋ dɩ ba yaa ɩ nɩkyooliye, ɛɛ bɩ daga anɩɩ ɩ yaa wɩkyirikyi kɩdɩgɩ buloŋ beewɩya, nala hʋ aa bɩ gyɩŋ Wɩɩsɩ mɛ gba aa yaa gɛɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ɛɛ wɩya ʋ maga dɩ ma yaa tɩpʋlʋŋ tɩmma rɛ aŋ ta kaŋ wɩkyogii buloŋ anɩɩ ma kuwo aa we wɩɩsɩbee tɩyaŋ aa yaa tɩpʋlʋŋ Tɩɩna gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma pɔ dɩ ma ta kɩ yaa ma wɩyaaweliye nala sɩya tɩyaŋ dɩ ba na. Dɩ mamaa rɛ aa yaa gɛɛ ma bɩ sɩ kaŋ tuno buloŋ ma kuwo aa we wɩɩsɩbee tɩyaŋ lee. ");
INSERT INTO sig_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ɛɛwɩya dɩ ɩ rɛ kpaa kɩŋ tɩya nyaabʋ ta leŋ dɩ nal buloŋ gyɩma. Minaafigi tɩmma hʋ rɛ aa kɩ yaa gɛɛ nɩgyamaa tɩyaŋ, dɩ nala kɩ bigisi ba. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ba foŋ laa ba tuno buloŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amɛ dɩ ɩ rɛ kpaa kɩŋ tɩya nyaabʋ, ta leŋ dɩ ɩ kyaŋfɩyaŋ mɛ gba gyɩma. ");
INSERT INTO sig_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Leŋ dɩ ʋ yaa wɩfaŋɩɩ. Dɩ ɩ rɛ yaa gɛɛ, ɩ Kuwo Wɩɩsɩ sɩ tun-ɩ beewɩya ʋ kɛ naa wɩɩ hʋ ɩ aa yaa rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ɛɛ rɛ Yesu bɩl baa, “Dɩ ma ko kɩ kyʋwalɩ Wɩɩsɩ, ma ta kɩɩ minaafigi tɩmma hʋ, beewɩya ba aa kyo dɩ ba sɩŋ wɩɩkyʋwaldɩɩsɩ abee ŋmaŋsɩ logimo tɩyaŋ nɛ, a kɩ kyʋwalɩ Wɩɩsɩ dɩ nal buloŋ na ba. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ba kɛ laa ba tuno buloŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amɛ dɩ ma ko kɩ kyɛ dɩ ma kyʋwalɩ Wɩɩsɩ, ma gyʋʋ ma dɩɩsɩ a kaŋ borisi hʋ tɔ, aŋ sʋla ma Kuwo hʋ ma aa bee na. Ʋ kɛ aa na wɩɩ hʋ ma aa faŋa kɩ yaa rɛ, ʋ sɩ tuŋ ma. ");
INSERT INTO sig_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dɩ ma ko kɩ kyʋwalɩ Wɩɩsɩ, ma ta kɩ basɩ wɩgyamaa aa bɩ kaŋ memii, anɩɩ nala hʋ aa bɩ gyɩŋ Wɩɩsɩ aa kɩ yaa gɛɛ. Ba bɩɩna anɩɩ ba wɩbasɩgyamaa no rɛ sɩ leŋ dɩ Wɩɩsɩ nɩɩ ba kyʋwala. ");
INSERT INTO sig_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma ta kɩɩ ba. Beewɩya ma Kuwo kɛ gyɩŋ kɩŋ hʋ ma aa kyɛ rɛ, dɩ ma ha gba bɩ sʋla ʋ. ");
INSERT INTO sig_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dɩ ma ko kɩ kyɛ dɩ ma kyʋwalɩ Wɩɩsɩ, ma baa, “Á Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ, leŋ dɩ ɩ feŋ na bigisii. ");
INSERT INTO sig_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Leŋ dɩ ɩ koro ko. Leŋ dɩ nala kɩ tɩŋa ɩ nyʋwa taŋha no tɩyaŋ anɩɩ ba aa tɩŋ gɛɛ wɩɩsɩbee tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tɩya ma á gyɩnaŋ nyʋwa kɩdiiliye ");
INSERT INTO sig_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","aŋ kpa á wɩbɔmɔ kyɛ ma, anɩɩ á mɛ aa kpaa á dɔŋtɩŋsɩ wɩbɔmɔ kɩ kyɛ ba gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kyiyeli ma dɩ kɩŋ buloŋ ta ko mʋrɩ ma we wɩbɔmɔ yayɩ tɩyaŋ aŋ lɩɩ ma Sɩtaanɩ nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dɩ ɩ dɔŋtɩɩna rɛ yaa ɩ wɩbɔŋ, ka dɩ ɩ kpa kyɛ ʋ, ɩ Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ mɛ sɩ kpa ɩ wɩbɔmɔ kyɛ ɩ. ");
INSERT INTO sig_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amɛ dɩ ɩ rɛ bɩ kpaa wɩya kɩ kyɛ ɩ dɔŋtɩŋsɩ, ɩ Kuwo Wɩɩsɩ mɛ bɩ sɩ kpa ɩ wɩbɔmɔ kyɛ ɩ.” ");
INSERT INTO sig_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ɛɛ rɛ Yesu baa, “Dɩ mamaa rɛ ko vʋwa nyʋwa, ma ta kaŋ ma sɩya haasɩ anɩɩ minaafigi tɩmma hʋ aa kɩ yaa gɛɛ. Dɩ ba ko vʋwa nyʋwa ba aa haasɩ ba sɩya rɛ dɩ nal buloŋ na a gyɩma anɩɩ ba vʋwa nyʋwa rɛ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ba kɛ laa ba tuno buloŋ teŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amɛ dɩ mamaa rɛ ko vʋwa nyʋwa, ma sɔŋ ma sɩya a kyaasɩ ma nyuni ");
INSERT INTO sig_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","dɩ nala ta wuwo gyɩma anɩɩ ma vʋwa nyʋwa rɛ, see ma Kuwo Wɩɩsɩ, nal hʋ ma aa bee na dʋŋ. Ʋ kɛ na wɩɩ hʋ ma aa faŋa yaa rɛ, ɛɛ wɩya ʋ sɩ tuŋ ma.” ");
INSERT INTO sig_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nyɛ rɛ Yesu bɩl baa, “Ma ta kyɛɛ kɩna kɩ biŋ ma tɩɩ dʋnɩya no tɩyaŋ. Beewɩya, dʋnɩya tɩyaŋ, pʋgɩma sɩ di badɔmɔŋ ka badɔmɔŋ mɛ sʋ, ka dɩ gaala mɛ wuwo gyʋʋ gaa badɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amɛ ma kyɛ kɩna kɩ biŋ ma tɩɩ wɩɩsɩbee tɩyaŋ, lee hʋ pʋgɩma aa bɩ sɩ wuwo di ba, ba bɩ sɩ sʋ, ka gaala mɛ bɩ sɩ wuwo gaa ba. ");
INSERT INTO sig_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lee hʋ ɩ sɩfɩyaŋ kɩna aa we, doŋ nɛ ɩ hakɩla mɛ aa we.” ");
INSERT INTO sig_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ɛɛ rɛ Yesu bɩl baa, “Ɩ sɩya rɛ yaa ɩ teŋbii kyaanʋʋ. Dɩ ɩ sɩya rɛ weliye a kɩ na, ɩ teŋbii buloŋ kaŋ kyaanʋʋ rɛ, ");
INSERT INTO sig_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","amɛ dɩ ɩ sɩya bee na, ɩ teŋ buloŋ aa we bilhuu tɩyaŋ nɛ. Dɩ kyaanʋʋ hʋ aa we ɩ tɩyaŋ nɛ ko bɩrɩmɩ bilhuu, bilhuu kɩŋkaŋ tɩyaŋ nɛ ɩ paalɩ we gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ba bɩ sɩ wuwo kpa dʋŋdɔɔdɩgɩ a dɔbɔ dʋŋdɔɔ-nɩmma balɩya, beewɩya ʋ sɩ kyo kɩdɩgɩ aŋ haasɩ kɩdɩgɩ mɛ. Ʋ sɩ kɩ tɩŋ kɩdɩgɩ nyʋwa weliŋ aŋ kɩ vɩya kɩdɩgɩ hʋ mɛ nyʋwa. Ɛɛ tɩɩ rɛ nal buloŋ mɛ bɩ sɩ wuwo kyo dʋnɩya no kɩna aŋ bɩl tɩŋ Wɩɩsɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ɛɛwɩya, ŋ basɩ kɩ tɩya ma rɛ, ma ta leŋ dɩ ma mɩɩbol wɩya kyɩl ma. Ma ta leŋ dɩ kɩna hʋ ma aa sɩ di koo kɩna hʋ ma aa sɩ nyʋwa ma mɩɩbol tɩyaŋ wɩya kyɩl ma. Ma ta leŋ dɩ ma teŋbii kɩna wɩya mɛ kyɩla ma. Beewɩya, kɩdiiliye dʋŋ daa aa tɩya nihuwobiŋ mɩɩbol. Gannɩ mɛ dʋŋ daa yaa nihuwobiŋ teŋbii kɩkyɛɛlɩya. Kɩdiiliye abee gannɩ no buloŋ bɩ maga ma mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ma deŋ na digibiisi, ba bee pala, ba bɩ kaŋ busolo mɛ a kɩ we kɩdiiliye, amɛ á Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ nɛ aa tɩya ba kɩdiiliye. Ma yaŋ daa kaŋ tɔnɔ a te digibiisi no? ");
INSERT INTO sig_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma tɩyaŋ kɩbee rɛ sɩ wuwo kuu kɩna no aa kyɩla ʋ wɩya a kaŋ kyɛdɩgɩ mɛ pɛ ʋ tɩɩ mɩɩbol tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bee rɛ yaŋ tɩŋ gannɩ wɩya kyɩl ma? Ma deŋ na tɩɩfɩɩla aa we ɔhɔ tɩyaŋ. Ba bee tʋŋ tʋma, ba bɩ ala gannɩ mɛ kɩ laalɩ, ");
INSERT INTO sig_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","amɛ ba weliye rɛ kɩŋkaŋ. Kuwori Solomɔn gyɩ kaŋ kɩna rɛ weliŋ. Amɛ abee gɛɛ buloŋ ʋ gannɩ fa bɩ weliye a maga tɩɩfɩɩla no kɩdɩgɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dɩ Wɩɩsɩ rɛ aa sɩ wuwo leŋ ɔhɔ aa sɩ we doŋ gyɩnaŋ bee kyiye dʋŋ weliye gɛɛ, ma bɩɩna anɩɩ Wɩɩsɩ bɩ sɩ wuwo leŋ dɩ ma na gannɩ tɔ ma tɩɩ rɛ koo. Ma na gɛɛ ma Wɩɩsɩ laadii aa maga? ");
INSERT INTO sig_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ɛɛwɩya ma ta leŋ kɩdiiliye hʋ ma aa sɩ di, koo kɩŋ hʋ ma aa sɩ nyʋwa, koo kɩŋ hʋ mɛ ma aa sɩ laalɩ wɩya kyɩl ma. ");
INSERT INTO sig_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nala hʋ aa bɩ gyɩŋ Wɩɩsɩ dʋnɩya no tɩyaŋ, ba aa rɛ aa leŋ kɩna no wɩya kyɩl ba. Ma Kuwo aa we wɩɩsɩbee tɩyaŋ gyɩma anɩɩ ma maga dɩ ma kaŋ kɩna no buloŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amɛ, ma laa sɩya kyɛ kɩna hʋ aa we Wɩɩsɩ koro hʋ tɩyaŋ, a kyɛ gɛɛ hʋ ma aa sɩ yaa a kaŋ tɩpʋlʋŋ Wɩɩsɩ sɩya tɩyaŋ. Ʋ sɩ kpa kɩkaalɩya hʋ buloŋ mɛ a pɛ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ɛɛwɩya, ma ta leŋ dɩ kyiye wɩya kyɩl ma. Kyɛɛ buloŋ kaŋ ʋ wɩgyʋʋlɩya rɛ. Ma ta bɩl kpaa wɩdʋma buloŋ pɛ kyɛɛ kɩdɩgɩ buloŋ bee ʋ wɩgyʋʋlɩya tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ta dii ɩ dɔŋtɩɩna sarɩya, dɩ Wɩɩsɩ mɛ ta dii ɩ sarɩya. ");
INSERT INTO sig_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Beewɩya ɛɛ hʋ tɩɩ ɩ aa yaŋ di ɩ dɔŋtɩɩna sarɩya, ɛɛ tɩɩ rɛ Wɩɩsɩ mɛ sɩ di ɩ sarɩya. Ɩ aa yaŋ kpa gɛɛ tɩŋ ɩ dɔŋtɩɩna, ɛɛ tɩɩ rɛ Wɩɩsɩ mɛ sɩ kpa tɩŋa ɩ. ");
INSERT INTO sig_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ɛɛ rɛ ɩ yaa a wuwo na gyagɩŋ hʋ aa we ɩ dɔŋtɩɩna sɩɩ tɩyaŋ aŋ bee na daakuu hʋ kɛ aa we ɩ tɩɩ sɩɩ tɩyaŋ? ");
INSERT INTO sig_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɛɛ rɛ ɩ sɩ yaa basɩ tɩya ɩ dɔŋtɩɩna a baa dɩ ʋ leŋ dɩ ɩ lɩɩ gyagɩŋ hʋ aa we ʋ sɩɩ tɩyaŋ ta, aŋ bɩ sɩ wuwo lɩɩ daakuu hʋ aa we ɩ tɩɩ sɩɩ tɩyaŋ kɛ. ");
INSERT INTO sig_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɛɛdɔŋ minaafigi tɩɩna! Laa sɩya lɩɩ daakuu hʋ aa we ɩ tɩɩ sɩɩ tɩyaŋ dɩ ɩ sɩya wuwo kɩ na weliŋ, dɩ ɩ na wuwo lɩɩ gyagɩŋ hʋ aa we ɩ dɔŋtɩɩna sɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ma ta kpaa kɩweliye tɩya vasɩ, beewɩya ba aa vɩya ba rɛ ba ta aŋ kil tɩŋ ma hal a kɩ dɔgɩsɩ ma. Ma ta kpaa ma sɩfɩyaŋ kɩna mɛ a biŋ porikusi sɩya tɩyaŋ, beewɩya ba sɩ nʋwɔsɩ ba. ");
INSERT INTO sig_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dɩ ɩ rɛ sʋl kɩŋ Wɩɩsɩ lee, ɩ aa na ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dɩ ɩ rɛ aa kyɛ kɩŋ Wɩɩsɩ lee ɩ aa na ʋ rɛ. Dɩ ɩ rɛ ŋmaa Wɩɩsɩ boro, ʋ aa kaŋ ʋ suri tɩya ɩ rɛ. Beewɩya nal hʋ buloŋ aa sʋl kɩŋ Wɩɩsɩ lee, ʋ aa tɩya ʋ rɛ. Nal hʋ buloŋ aa kyɛ kɩŋ Wɩɩsɩ lee ʋ aa na ʋ rɛ. Nal hʋ buloŋ aa ŋmaa boro hʋ, Wɩɩsɩ aa kaŋ ʋ suri tɩya ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ma kɩbee rɛ sɩ laa nyʋwa kpa bʋyɩ tɩya ʋ biye dɩ ʋ rɛ baa ɩ tɩya ʋ kɩdiiliye? ");
INSERT INTO sig_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Koo dɩ ʋ baa ɩ tɩya ʋ fuwonamɩya, ɩ sɩ kpa dʋŋ tɩya ʋ? Aayɩ, ɩ bɩ sɩ yaa gɛɛ! ");
INSERT INTO sig_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ma nala no yaŋ aa bɔmɔ nyɛ, aŋ gyɩŋ dɩ ma kpa kɩweliye tɩya ma biisi, ɛɛ rɛ ma kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ sɩ yaa a bɩ sɩ kpa kɩweliye aa tee gɛɛ tɩya nal hʋ aa sʋla ʋ kɩ kyɛ? ");
INSERT INTO sig_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mɩrɩsɩ hʋ Moosi gyɩ aa bine dɩ nala kɩ tɩŋa abee Wɩɩsɩ tɩŋdaala wɩbasɩya hʋ buloŋ, ba wɩnyuu rɛ yaa wɩɩ no: Ɩ aa bee kyɛ wɩɩ ta kpaa ʋ yaa ɩ dɔŋtɩɩna. ");
INSERT INTO sig_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nyɛ rɛ Yesu bɩl baa, “Ma tɩŋ dimbeenyʋwa hʋ aa bɩ gyalɩya a gyʋʋ wɩɩsɩbee. Beewɩya dimbeenyʋwa hʋ ba aa tɩŋ kɩ mʋ diŋ, ʋ gyalɩya rɛ weliŋ, aŋ ka ʋ ŋmanɩɩ hʋ mɛ valɩɩ bɩ hayɛ. Nɩgyamaa rɛ aa tɩŋ ŋmanɩɩ no. ");
INSERT INTO sig_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amɛ wɩɩsɩbee dimbeenyʋwa hʋ kɛ muro rɛ, ka ŋmanɩɩ hʋ mɛ aa mʋ doŋ valɩɩ hayɛ. Nala baŋmana dʋŋ nɛ wuwo na ŋmanɩɩ no a kɩ tɩŋa.” ");
INSERT INTO sig_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ma pɔ ma tɩɩ ma weliŋ abee nala hʋ aa ko nyɩya wɩya a baa dɩ ba yaa Wɩɩsɩ tɩŋdaala rɛ. Ba sɩ ko ma lee a kɩɩ gɛɛ anɩɩ niweliye ma sɩya tɩyaŋ, amɛ ba tɩsɩ tɩyaŋ, ba kɩɩ gɛɛ rɛ anɩɩ gbopʋrɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ba wɩyaalɩya tɩyaŋ nɛ ma sɩ tɩŋa a gyɩŋ ba. Beewɩya sɔgyaŋ bee nɔŋ kyʋkyɔyɩ, sugulugu mɛ bee nɔŋ tutogi-naŋkpɩlɩya. ");
INSERT INTO sig_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ɛɛ tɩɩ rɛ yaŋ, tɩya hʋ buloŋ aa kaŋ laaŋfɩya aa nɔŋ nɔŋweliye rɛ, tɩya hʋ mɛ aa bɩ kaŋ laaŋfɩya ʋ aa nɔŋ nɔŋbɔŋlɔrɩnɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tɩya hʋ aa kaŋ laaŋfɩya bɩ sɩ wuwo nɔŋ nɔŋbɔŋlɔrɩnɩ, tɩya hʋ mɛ aa bɩ kaŋ laaŋfɩya bɩ sɩ wuwo nɔŋ nɔŋweliye. ");
INSERT INTO sig_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɩya hʋ buloŋ aa bee nɔŋ nɔŋweliye, ba aa ŋmaŋ lo rɛ, a paa we diŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ɛɛwɩya, nala no wɩyaalɩya rɛ ma sɩ kpa a gyɩŋ ba. ");
INSERT INTO sig_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nala hʋ buloŋ aa yɩrɩ ŋ, “Tɩɩna, Tɩɩna” daa sɩ gyʋʋ wɩɩsɩbee koro hʋ tɩyaŋ, see nala hʋ aa tɩŋ ŋ Kuwo aa we wɩɩsɩbee tɩyaŋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dɩ Wɩɩsɩ sarɩya kyɛdiilii hʋ rɛ ko pele, nala yʋga sɩ baa, “Á Tɩɩna, á Tɩɩna, á basɩ Wɩɩsɩ wɩya a tɩya nala rɛ ɩ feŋ tɩyaŋ, aŋ kpa ɩ feŋ a kile gyɩŋbɔmɔ mɛ nala tɩyaŋ, aŋ ha yaa wɩmagɩla mɛ yʋga ɩ feŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Doŋ tɩyaŋ nɛ ŋ yaŋ sɩ basɩ tɩya ba a baa, “Mamaa wɩbɔŋyaala, ma nyʋgɩsɩ ŋ sɩya tɩyaŋ. Ŋ bɩ gyɩŋ ma!” ");
INSERT INTO sig_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ɛɛ rɛ Yesu bɩl baa, “Nal hʋ buloŋ aa gyegile nɩɩ wɩya no ŋ aa basɩ kɩ tɩya ma, a kɩ tɩŋ ba, ʋ tɩɩna kɩɩ gɛɛ rɛ anɩɩ wɩgyʋnnɩ aa saa ʋ dɩya sɩgɩ bʋnyɩŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɛɛ rɛ duwoŋ ko nɩɩ. Fuwoni su a gbarɩ, puwobal mɛ gyigisi dɩya hʋ, ka ʋ bɩ tele, beewɩya bʋnyɩŋ tɩyaŋ nɛ ba saa ʋ. ");
INSERT INTO sig_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amɛ nal hʋ mɛ buloŋ aa gyegile nɩɩ wɩya no ŋ aa basɩ, aŋ bee tɩŋ ba, ʋ tɩɩna kɩɩ gɛɛ rɛ anɩɩ bambugi aa saa ʋ dɩya sɩgɩ bumbugulo tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɛɛ rɛ duwoŋ ko nɩɩ. Fuwoni su a gbarɩ, puwobal mɛ gyigisi dɩya hʋ, ʋ tele ʋ buloŋ muŋsi muno muno.” ");
INSERT INTO sig_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesu aa basɩ wɩya no ko teŋ, ʋ gyɩ yaa nyʋʋfɩyɛlɩ lɛ a tɩya gyamaa hʋ buloŋ aa we doŋ, beewɩya ʋ gyɩ bɩ daga ba anɩɩ ba Wɩɩsɩ Teŋ dɩdagɩla hʋ aa kɩ daga ba gɛɛ. Ʋ gyɩ daga ba rɛ anɩɩ ʋ rɛ kaŋ wɩɩ hʋ dee. ");
INSERT INTO sig_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu aa basɩ wɩya no teŋ, ʋ lɩɩ dogimo hʋ nyuu a ko tuu, nɩgyamaa kɩ tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ɛɛ rɛ gbege kɩdɩgɩ ko tuu gbinni Yesu sɩya aŋ sʋla ʋ a baa, “Ŋ nɩhɩyawʋ, dɩ ɩ rɛ kyo, ɩ sɩ wuwo leŋ dɩ ŋ deye.” ");
INSERT INTO sig_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɛɛ rɛ Yesu lɩɩ ʋ noŋ a dige ʋ aŋ baa, “Ŋ kyo rɛ. Deye!” Ɛɛ rɛ baal hʋ gbegisi hʋ pirigi teŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ta ko basɩ wɩɩ no tɩya nal buloŋ. Amɛ kaŋ ɩ tɩɩ mʋ daga wɩɩkyʋwal sɩlaal hʋ dɩ ʋ laa ɩ wɩɩsʋllɩ-kɩna a kpa sʋla Wɩɩsɩ a tɩya ɩ anɩɩ Moosi fa aa daga ma gɛɛ. Dɩ ɩ rɛ yaa gɛɛ, nal buloŋ sɩ gyɩma anɩɩ ɩ gbegisi hʋ tene rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ɛɛ rɛ Yesu sii kpa mʋ Kapɛɛnam. Doŋ tɩyaŋ nɛ Roma laalyuwolo nɩhɩyawʋ kɩdɩgɩ sii ko ʋ lee a sʋla ʋ dɩ ʋ ko pɛ ʋ bee wɩɩ kɩdɩgɩ, a baa, ");
INSERT INTO sig_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ŋ nɩhɩyawʋ, ŋ dɩya tʋŋtʋnnɩ rɛ aa wɩɩlɩ a pɩŋ dɩya tɩyaŋ a kɩ na tʋwara kɩŋkaŋ. Ʋ bɩ wuwo kɩ vala.” ");
INSERT INTO sig_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ sɩ ko leŋ dɩ ʋ deye.” ");
INSERT INTO sig_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amɛ baal hʋ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, ŋ bɩ maga dɩ ɩ ko gyʋʋ ŋ dɩya. Ɛɛwɩya ɩ kɛ haa suri ɩ nyʋwa dʋŋ a baa dɩ ŋ tʋŋtʋnnɩ hʋ deye, ʋ sɩ deye. ");
INSERT INTO sig_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Beewɩya ŋ mɛ paalɩ kɩ tɩŋ ŋ laalyuwolo nɩhɩyasɩ nyʋwa rɛ. Laalyuwolo badɔmɔŋ mɛ kɩ tɩŋa ŋ nyʋwa. Dɩ mɩyaŋ nɛ baa dɩ nal no mʋ daha, ʋ aa mʋʋ rɛ. Dɩ mɩyaŋ mɛ rɛ baa dɩ nal no ko daha, ʋ aa ko rɛ. Dɩ mɩyaŋ nɛ basɩ tɩya ŋ tʋŋtʋnnɩ dɩ ʋ yaa wɩɩ no, ʋ aa yaa rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu aa nɩɩ wɩya no, ʋ nyʋwa fɩyɛlɩ. Ɛɛ rɛ ʋ basɩ tɩya nɩgyamaa hʋ fa aa tɩŋa ʋ hal a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ŋ ha bɩ maakyiye na laadii no iriŋ Iziral paalʋʋ nal kɩdɩgɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ŋ basɩ kɩ tɩya ma rɛ, nala sɩ lɩɩ dʋnɩya logiŋ buloŋ a ko hɔŋ Wɩɩsɩ koro hʋ tɩyaŋ dɩ ba bee Abɩraham abee Azɩkɩ abee Gyeekɔbɩ kɩ di kɩna, ");
INSERT INTO sig_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","amɛ Iziral tɩmma hʋ fa aa maga dɩ ba we Wɩɩsɩ koro hʋ tɩyaŋ aŋ bɩ gyʋwa, Wɩɩsɩ sɩ kpa ba yuwo ta gyaŋhal tɩyaŋ dɩ ba we bilhuu tɩyaŋ a pɩŋ kɩ wii aŋ kɩ kyaŋ ba nyɩŋa.” ");
INSERT INTO sig_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɛɛ rɛ Yesu basɩ tɩya laalyuwolo nɩhɩyawʋ hʋ a baa, “Kɩ mʋ dɩya, wɩɩ hʋ buloŋ ɩ aa laa di baa ʋ sɩ yaa, ʋ rɛ sɩ yaa.” Saŋa no tɩɩ tɩyaŋ nɛ laalyuwolo nɩhɩyawʋ hʋ tʋŋtʋnnɩ hʋ na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɛɛ rɛ Yesu mʋ Piita dɩya. Ʋ aa gyʋwa dɩ Piita hɩɩlhaaŋ pɩna kɩ wɩɩlɩ, ʋ teŋ buloŋ nɩma. ");
INSERT INTO sig_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nyɛ rɛ Yesu mʋ dige ʋ noŋ tɩyaŋ. Ʋ teŋ fa aa nɩma gɛɛ, ʋ fɩyɛlɩ. Ʋ sii yaa kɩdiiliye tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ʋ dɩdaana aa ko pele, nala kaŋ nɩgyamaa a ko Yesu lee. Gyɩŋbɔmɔ rɛ gyɩ kaŋ badɔmɔŋ. Ɛɛ rɛ Yesu nɔsɩ gyɩŋbɔmɔ hʋ ta ba lɩɩ ka ʋ tɩɩbɩ nala hʋ buloŋ gyɩ fa aa wɩɩlɩ. ");
INSERT INTO sig_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ʋ yaa wɩɩ no dɩ wɩya hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Azaaya tɩyaŋ a basɩ ko yaa wɩtɩɩ rɛ. Ʋ gyɩ baa, “Ʋ rɛ laa ma ta á wɩɩla buloŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu aa naa dɩ nɩgyamaa hʋ ko gol-ʋ gɛɛ, ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ á kyol fuwo hʋ kyolo.” ");
INSERT INTO sig_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩl kɩdɩgɩ ko ʋ lee a basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, ŋ yaa siri rɛ dɩ ŋ tɩŋa ɩ hal a mʋ lee kɛ buloŋ ɩ aa mʋʋ.” ");
INSERT INTO sig_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋmanyɔnɩ kaŋ bʋʋsɩ rɛ a kɩ gyʋʋ, digibiisi mɛ kaŋ gyannɩ a kɩ gyʋʋ, amɛ mɩyaŋ Nihuwobiŋ Biye bɩ kaŋ lee ŋ aa sɩ pɩŋ a wiyesi.” ");
INSERT INTO sig_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nala hʋ fa aa tɩŋ Yesu hal, ba kɩdɩgɩ mɛ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, ŋ sɩ tɩŋa ɩ hal amɛ leŋ dɩ ŋ laa sɩya mʋ kpa ŋ kuwo hogo aŋ ko.” ");
INSERT INTO sig_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Kɩ tɩŋa ŋ hal aŋ leŋ dɩ sʋʋnɩ hʋ kɩ hogo ba tɩɩ sʋʋnɩ.” ");
INSERT INTO sig_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɛɛ rɛ Yesu mʋ gyʋʋ nɩɩduworiboro, ʋ hatɩnna mɛ tɩŋa ʋ hal a mʋ gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Saŋa hʋ ba aa mʋʋ tɩyaŋ nɛ puwoduwo kɩdɩgɩ pirigi kɩ dɔŋ. Ɛɛ rɛ nɩɩpuwo tɔ nɩɩduworiboro hʋ buloŋ. Nɩɩduworiboro hʋ fa kɩ kyɛ dɩ ʋ tuu nɩɩmemii. Saŋa no tɩyaŋ dɩ Yesu kɛ pɩŋ doo. ");
INSERT INTO sig_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɛɛ rɛ ʋ hatɩnna hʋ mʋ kyisi ʋ a basɩ tɩya ʋ a baa, “Á Tɩɩna, laa ma ta, dɩ ɛɛ daa á sɩ sʋba.” ");
INSERT INTO sig_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ kambɩŋ kaŋ ma? Ma laadii bɩ yʋga.” Ɛɛ rɛ ʋ sii a nɔsɩ puwo hʋ aŋ basɩ tɩya fuwo hʋ mɛ dɩ ʋ fɩyɛlɩ pɩŋ. Lee buloŋ pirigi yaa siyee. ");
INSERT INTO sig_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nyɛ rɛ ba buloŋ nyʋʋsɩ fɩyɛlɩ, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Nɩgɛɛ iriŋ nɛ nyɛ? Fuwoni abee puwoni buloŋ kɩ tɩŋa ʋ nyʋwa?” ");
INSERT INTO sig_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ɛɛ rɛ Yesu sii kpa mʋ Gadara paalʋʋ fuwo hʋ kyolo. Dɩ baala balɩya lɩɩ bilni tɩyaŋ a ko kyeme ʋ. Gyɩŋbɔmɔ rɛ gyɩ kaŋ baala no ba kɩ yaarɩ. Nal buloŋ gyɩ bɩ wuwo kɩ tɩŋ ŋmanɩɩ hʋ tɩyaŋ baala no balɩya aa we, beewɩya, ba gyɩ bɔmɔ rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba aa naa Yesu, ba pirigi kyiyesi a baa, “Wɩɩsɩ Biye, bee rɛ ɩ kɩ kyɛ dɩ ɩ yaa ma? Ɩ ko dɩ ɩ dɔgɩsɩ ma rɛ ka saŋa hʋ na pele koo?” ");
INSERT INTO sig_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dɩ poriku-gyamaa mɛ sɩŋ kpaga doŋ a kɩ di kɩna. ");
INSERT INTO sig_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ɛɛ rɛ gyɩŋbɔmɔ hʋ sʋla Yesu a baa, “Dɩ ɩ ko kil ma ta dɩ á lɩɩ nala no tɩyaŋ, leŋ dɩ á mʋ gyʋʋ porikusi no tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma lɩɩ kɩ mʋ.” Ɛɛ rɛ ba lɩɩ baala hʋ tɩyaŋ a mʋ gyʋʋ porikusi hʋ tɩyaŋ, porikusi hʋ buloŋ sii fá a lɩɩ fuwo hʋ nyʋwa a tuu gyʋʋ fuwo hʋ tɩyaŋ a sʋba. ");
INSERT INTO sig_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nyɛ rɛ porikudaala hʋ fá mʋ gyʋʋ bee hʋ tɩyaŋ a basɩ wɩɩ hʋ buloŋ aa yaa doŋ abee wɩɩ hʋ aa yaa baala hʋ gyɩ aa kaŋ gyɩŋbɔmɔ hʋ mɛ tɩyaŋ a tɩya bee hʋ nala. ");
INSERT INTO sig_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɛɛ rɛ bee hʋ nala buloŋ sii lɩɩ mʋ dɩ ba na Yesu. Ba aa mʋʋ na ʋ, ba sʋla ʋ dɩ ʋ lɩɩ ba paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ɛɛ rɛ Yesu sii gyʋʋ nɩɩduworiboro a kyol fuwo hʋ a mɩɩgɩ kpa mʋ ʋ bee. ");
INSERT INTO sig_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Doŋ nɛ nala badɔmɔŋ sii kyʋŋ baal kɩdɩgɩ logiŋdɩgɩ buloŋ aa sʋba abee ʋ wasɩpɩnɩɩ a ko Yesu sɩya. Yesu aa naa dɩ ba laadii yʋga gɛɛ, ʋ basɩ tɩya baal hʋ a baa, “Ŋ Biye, ta leŋ kambɩŋ kana ɩ! Ŋ kpaa ɩ wɩbɔmɔ kyɛ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yesu aa basɩ gɛɛ, Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ mɩɩgɩ hɔŋ kɩ gʋrɩmɩ wɩya a baa, “Baal no aa basɩ wɩya gɛɛ rɛ anɩɩ ʋ rɛ yaa Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amɛ Yesu kɛ gyɩŋ wɩɩ hʋ ba gyɩ aa bɩɩnɩ rɛ. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ bɩɩnɩ wɩbɔmɔ no. ");
INSERT INTO sig_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ŋ aa sɩ baa ‘Ŋ kpaa ɩ wɩbɔmɔ kyɛ ɩ rɛ,’ koo ŋ aa sɩ baa ‘Sii kɩ vala,’ ba tɩyaŋ kɩbee rɛ yaa mɔl? ");
INSERT INTO sig_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ŋ sɩ dagɩ ma dɩ ma gyɩma anɩɩ mɩyaŋ Nihuwobiŋ Biye kaŋ dee rɛ ŋ aa sɩ wuwo kpa dʋnɩya nala wɩbɔmɔ kyɛ ba.” Ɛɛ rɛ ka ʋ basɩ tɩya baal hʋ a baa, “Sii kpa ɩ wasa a kɩ mʋ dɩya.” ");
INSERT INTO sig_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Doŋ nɛ baal hʋ nyagɩ sii sɩŋ, a kɩ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nɩgyamaa hʋ buloŋ aa naa gɛɛ, kambɩŋ kaŋ ba, ba dannɩ Wɩɩsɩ anɩɩ ʋ aa kpaa dee no iriŋ a tɩya nihuwobisi. ");
INSERT INTO sig_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu aa lɩɩ doŋ kɩ mʋ, dɩ lampolaal kɩdɩgɩ ba aa yɩrɩ Matiwu rɛ hɔŋ ʋ tʋŋtʋnnɩ-dɩya tɩyaŋ gɛɛ. Ɛɛ rɛ Yesu yɩrɩ ʋ a baa, “Sii ko kɩ tɩŋa ŋ hal.” Ʋ sii a kɩ tɩŋ Yesu hal. ");
INSERT INTO sig_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nyɛ rɛ Yesu bee ʋ hatɩnna hʋ buloŋ kpa mʋ Matiwu dɩya, a hɔŋ kɩ di kɩna. Doŋ tɩyaŋ nɛ lampolaala bee wɩbɔŋyaala mɛ ko pɛ ba tɩyaŋ, ba buloŋ kɩ di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasiima badɔmɔŋ aa naa gɛɛ, ba pɩyɛsɩ Yesu hatɩnna hʋ a baa, “Bee rɛ tɩŋ ma nɩhɩyawʋ bee lampolaala abee wɩbɔŋyaala no buloŋ hɔŋ kɩ di kɩna?” ");
INSERT INTO sig_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu aa nɩɩ wɩɩ no, ʋ mɩɩgɩ basɩ tɩya ba a baa, “Nala hʋ aa kaŋ laaŋfɩya, ba bee kyɛ tɩɩba tɩɩna, see nala hʋ aa wɩɩlɩ.” ");
INSERT INTO sig_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma mʋ deŋ Wɩɩsɩ teŋ tɩyaŋ a na wɩɩ no ba aa saba memii. Ba saba rɛ anɩɩ Wɩɩsɩ baa, “Ma aa fá nala sikii, ʋ rɛ kpɩya ma aa lɩɩ wɩɩsʋllɩ kɩna a kpʋ tɩya ŋ.” Wɩbɔŋyaala wɩya rɛ ŋ ko, ŋ bɩ ko tɩpʋlʋŋ tɩmma wɩya. ");
INSERT INTO sig_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ɛɛ rɛ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ hatɩnna ko Yesu lee a pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ á bee Farasiima kɩ vʋwa nyʋwa aŋka ɩ hatɩnna hʋ kɛ bee vʋwa nyʋwa?” ");
INSERT INTO sig_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa “Dɩ nal lɛ kpaa hafalɩɩ ka dɩ ʋ bee ʋ kyaŋsɩ hɔŋ, ʋ kyaŋsɩ hʋ tɩya sɩ kyogi? Aayɩ, amɛ kyɛɛ kɩdɩgɩ we doŋ ba aa sɩ kaŋ baal hʋ mʋ lee kɩdɩgɩ ka dɩ ʋ kyaŋsɩ hʋ vʋwa nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ɛɛ rɛ ʋ bɩl maga namaga tɩya ba a baa, “Nal buloŋ bɩ sɩ kpa taŋfalɩɩ a ala tɔ gabɩnɩɩ bol. Dɩ ɩ rɛ yaa gɛɛ, taŋfalɩɩ hʋ sɩ kʋʋrɩ, dɩ gabɩnɩɩ hʋ marɩ kɩyasɩ pɛ. ");
INSERT INTO sig_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɛɛ tɩɩ rɛ nal buloŋ mɛ bɩ sɩ laa nyʋwa kpa sɩhuwo a we pulbɩnɩɩ tɩyaŋ, see dɩ ʋ kpa we pulfalɩɩ tɩyaŋ. Dɩ gɛɛ daa pulbɩnɩɩ hʋ sɩ pɔsɔ dɩ sɩŋ hʋ bɩsɩ ta. Sɩhuwo maga dɩ ɩ kpa we pulfalɩɩ tɩyaŋ nɛ dɩ sɩŋ hʋ bee pul hʋ buloŋ ta kyogo ta.” ");
INSERT INTO sig_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ha gyɩ aa basɩ wɩya hʋ gɛɛ rɛ, Gyuuma nɩhɩyawʋ kɩdɩgɩ ko ʋ lee, a tuu gbinni ʋ sɩya tɩyaŋ aŋ basɩ tɩya ʋ a baa, “Ŋ toluu rɛ sʋba lagɩlagɩ no, amɛ ko kpa ɩ nosi dɔbɔ ʋ tɩyaŋ dɩ ʋ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ buloŋ sii tɩŋ baal hʋ hal ba kpa kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ba aa mʋʋ hʋ tɩyaŋ nɛ, dɩ haaŋ kɩdɩgɩ aa yaa ʋ hawɩya ka ba bee teŋ ʋ bɩsɩ fi abee balɩya, ko baŋ Yesu hal aŋ liisi ʋ tɩya tɩyaŋ a baa, “Dɩ mɩyaŋ nɛ yaŋ dige ʋ gal dʋŋ mɛ, ŋ aa na laaŋfɩya rɛ,” aŋ dige gal hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ɛɛ rɛ Yesu mɩɩgɩ galdaasɩ a na ʋ, a basɩ tɩya ʋ a baa, “Ŋ toluu, ta leŋ kambɩŋ kana ɩ, ɩ aa laa ŋ di rɛ tɩŋ ɩ deye.” Haaŋ hʋ pirigi na laaŋfɩya haŋ lagɩlagɩbiye hʋ. ");
INSERT INTO sig_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ɛɛ rɛ ka Yesu kpa gyʋʋ Gyuuma nɩhɩyawʋ hʋ dɩya. Ʋ gyʋwa dɩ haŋye-taala abee lodaala hʋ sɩna a kɩ wii. ");
INSERT INTO sig_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma buloŋ mʋ lɩɩ, haŋtolibiye hʋ bɩ sʋba, ʋ ta pɩŋ doo rɛ.” Ɛɛ rɛ ba buloŋ mɩɩgɩ kɩ mʋma ʋ. ");
INSERT INTO sig_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amɛ ba aa kile nala hʋ buloŋ ba lɩɩ gɛɛ, Yesu mʋ gyʋʋ haŋtolibiye hʋ dɩya, a mʋ kaŋ ʋ noŋ tɩyaŋ, ʋ sii. ");
INSERT INTO sig_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wɩɩ no Yesu aa yaa taalɩ haŋ paalʋʋ hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu bɩl aa lɩɩ doŋ kɩ mʋ, nyʋlma balɩya mɛ sii kɩ tɩŋa ʋ hal aŋ huwori kɩ yɩrɩ ʋ a baa, “Yesu, Deviti Biye, fá á sikii.” ");
INSERT INTO sig_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu aa mʋʋ gyʋʋ dɩya hʋ, nyʋlma hʋ balɩya mɛ kpa ko ʋ lee. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Ma laa di anɩɩ ŋ sɩ wuwo tɩɩbɩ ma dɩ ma deye rɛ koo?” Ɛɛ rɛ ba baa, “Waa, á Tɩɩna, á laa di rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ɛɛ rɛ Yesu dige dige ba sɩya tɩyaŋ aŋ baa, “Ɛɛ hʋ ma aa laa di anɩɩ ʋ sɩ yaa, ŋ sɩ leŋ dɩ ɛɛ yaa.” ");
INSERT INTO sig_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ba sɩya suri, ka Yesu basɩ tɩya ba abee sɩfɩyasɩ a baa, “Ma ta ko basɩ wɩɩ no tɩya nal buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amɛ ba vɩya aŋ lɩɩ basɩ ʋ wɩya a taalɩ paalʋʋ hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nyʋlɩma hʋ balɩya aa yaŋ lɩɩ dɩya hʋ tɩyaŋ, dɩ nala badɔmɔŋ mɛ kaŋ baal kɩdɩgɩ gyɩŋbɔmɔ aa kana ʋ bɩ wuwo kɩ basɩ wɩya, a ko Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ɛɛ rɛ Yesu kile gyɩŋbɔmɔ hʋ baal hʋ tɩyaŋ, ka baal hʋ piili kɩ basɩ wɩya. Ʋ yaa nal buloŋ wɩkperii. Ɛɛ rɛ ba baa, “Á ha bɩ maakyiye na wɩɩ no iriŋ Iziral paalʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amɛ Farasiima hʋ kɩ basɩ anɩɩ gyɩŋbɔmɔ kuwori rɛ tɩya ʋ dee ʋ wuwo kile gyɩŋbɔmɔ kɩ ta gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ɛɛ rɛ Yesu sii gɔllɩ tɔbala abee tɔbiisi hʋ buloŋ a kɩ daga nala Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ, aŋ pɛ kɩ basɩ Wɩɩsɩ koro hʋ wɩweliye wɩya, aŋ kɩ tɩɩbɩ nala hʋ wɩɩla iriŋ iriŋ buloŋ aa kana. ");
INSERT INTO sig_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ʋ aa naa nɩgyamaa hʋ, sikii buloŋ kana ʋ, beewɩya ʋ naa nɩɩ wɩya yʋga aa dɔŋ ba rɛ, ka ba bɩ kaŋ nal aa sɩ kyiyeli ba. Ba kɩɩ gɛɛ anɩɩ piyese aa bɩ kaŋ pedaal. ");
INSERT INTO sig_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ɛɛ rɛ ʋ basɩ tɩya ʋ hatɩnna hʋ baa, “Kɩkʋmɩya hʋ yʋga rɛ baga hʋ tɩyaŋ, amɛ tʋŋtʋnna hʋ bɩ yʋga ba aa sɩ kʋŋ kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ma yaŋ sʋla baga hʋ tɩɩna dɩ ʋ kyɛ tʋŋtʋnna yʋga dɩ ba kʋŋ baga hʋ kɩna.” ");
INSERT INTO sig_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ɛɛ rɛ Yesu yɩrɩ ʋ kpambɩsɩ fi abee balɩya hʋ a laŋŋɩ dɔmɔŋ, a tɩya ba dee dɩ ba wuwo kɩ kile gyɩŋbɔmɔ aŋ pɛ kɩ tɩɩbɩ nala wɩɩla iriŋ iriŋ buloŋ aa kana. ");
INSERT INTO sig_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nala hʋ ʋ aa lɩya ba fene rɛ nyɛ: Siimɔŋ (ʋ feŋ kɩdɩgɩ mɛ rɛ yaa Piita), abee ʋ naabiye Aŋduru, abee Gyemsi bee ʋ naabiye Gyɔɔŋ mɛ. Gyemsi bee Gyɔɔŋ fa yaa Zebedi balɩya rɛ, ");
INSERT INTO sig_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","abee Fɩlɩpɩ, abee Batolomi, abee Tɔmaasɩ, abee Matiwu lampolaal hʋ, abee Alfiyasɩ biibaal Gyemsi, abee Tadiyo, ");
INSERT INTO sig_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","abee Siimɔŋ, nal hʋ aa kyɩl ʋ nala wɩya kɩŋkaŋ, abee Gyudasɩ Isɩkarɔtɩ nal hʋ a ko yaa minaafigi tɩɩna, a kpa Yesu yallɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tɩŋdarɩ hʋ Yesu gyɩ aa kpaa tɩya ʋ kpambɩsɩ fi abee balɩya hʋ ba lɩɩ rɛ nyɛ. Ʋ baa, “Ma ta ko mʋ nala aa bɩ yaa Gyuuma paalʋʋ koo Samaarɩya paalʋʋ tɔɔ kɩdɩgɩ kɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amɛ ma mʋ Iziral nala lee, nala no kɩɩ gɛɛ rɛ anɩɩ piyese aa nyʋgɩsa. ");
INSERT INTO sig_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma mʋ basɩ Wɩɩsɩ wɩya tɩya ba anɩɩ wɩɩsɩbee koro hʋ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma tɩɩbɩ wɩɩla tɩmma, a kyisi sʋʋnɩ, a tɩɩbɩ gbegisi, a kile gyɩŋbɔmɔ mɛ ta nala tɩyaŋ. Dɩ ma ko yaa wɩya no buloŋ, ma ta laa tuno buloŋ, beewɩya ma mɛ bɩ tuŋ kɩŋ buloŋ aŋ laa dee no. ");
INSERT INTO sig_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma ta kpaa molbii buloŋ we ma gyɩfasɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma ta kpaa diiku ma ŋmanɩɩ no valɩɩ tɩyaŋ, a ta paa gatʋŋnyʋwa bʋlɩya koo naatɔbɔ tʋŋnyʋwa bʋlɩya mɛ. Ma ta kol daatɩgɩya balɩya mɛ. Tʋŋtʋnnɩ buloŋ maga dɩ ba tɩya ʋ kɩna hʋ aa maga dɩ ʋ kana rɛ. ");
INSERT INTO sig_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dɩ mamaa rɛ ko mʋ pele tɔɔ buloŋ, ma kyɛ nal hʋ aa sɩ laa nyʋwa laa ma biŋ, dɩ ma we ʋ lee a mʋ pele saŋa hʋ ma aa sɩ lɩɩ tɔɔ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dɩ mamaa rɛ ko mʋ gyʋʋ dɩya buloŋ, ma laa sɩya kyʋwalɩ dɩya hʋ nala a baa, ‘Wɩɩsɩ sɩ leŋ dɩ dɩya no nala hɔŋ abee laaŋfɩya.’ ");
INSERT INTO sig_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dɩ ba aa rɛ ko laa ma, ma sʋl Wɩɩsɩ dɩ ʋ tɩya ba fɩyɛlʋʋ. Amɛ dɩ ba aa rɛ ko bɩ laa ma, ma leŋ dɩ fɩyɛlʋʋ hʋ ma aa sʋla tɩya ba mɩɩgɩ ko ma lee. ");
INSERT INTO sig_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dɩ tɔɔ koo dɩya kɩdɩgɩ nala rɛ ko pɔ dɩ ma ta gyʋwa, a bɩ yaa siri mɛ dɩ ba gyegili nɩɩ ma duwoso, ɛɛ kɛ, ma lɩɩ doŋ, aŋ piisi ma naasɩ taŋha ta. Ɛɛ sɩ daga nɩɩ ba aa vɩya ma nyɛ Wɩɩsɩ sɩ dɔgɩsɩ ba. ");
INSERT INTO sig_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dʋnɩya sarɩya hʋ kyɛdiilii, Wɩɩsɩ sɩ dɔgɩsɩ haŋ tɔɔ hʋ nala a te gɛɛ hʋ ʋ gyɩ aa dɔgɩsɩ Sodɔm bee Gomora tɩmma ba wɩbɔmɔ nyuniŋ.” ");
INSERT INTO sig_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ kpambɩsɩ hʋ a baa, “Ma gyegili nɩɩ daha! Ŋ aa tɩŋ ma rɛ dʋnɩya nala lee, ba sɩ kil tɩŋ ma hal anɩɩ ba aa kpaa piyese bee gboni a laŋŋɩ lɩdɩgɩ. Ɛɛwɩya, ma gyɩŋ tɩya ma tɩɩ weliŋ. Amɛ ma wɩyaalɩɩ buloŋ tɩyaŋ ma kaŋ ma tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma pɔ ma tɩɩ weliŋ abee nala no, beewɩya ba sɩ kaŋ ma mʋ nɩhɩyasɩ sɩya dɩ ba di ma sarɩya aŋ vɩɩrɩ ma ba wɩɩkyʋwaldɩɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba sɩ kuu ŋ wɩya, a kaŋ ma mʋ paalʋʋsɩ nɩbala abee kuworo sɩya dɩ ba di ma sarɩya ka dɩ ma di ŋ daŋsɩya a tɩya ba abee nala hʋ aa bɩ yaa Gyuuma buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dɩ ba ko kaŋ ma mʋ nala no sɩya, ma ta leŋ dɩ ma bembiye kɩ sii wɩya hʋ ma aa sɩ basɩ laa ma tɩɩ wɩya. Beewɩya, dɩ saŋa hʋ rɛ ko pele, Wɩɩsɩ sɩ daga ma wɩɩ hʋ ma aa sɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wɩya hʋ ma aa sɩ basɩ, ba bɩ sɩ yaa ma tɩɩ wɩbasɩya. Ma Kuwo Wɩɩsɩ rɛ sɩ leŋ dɩ ʋ Wiyesi Welii hʋ tɩŋ ma tɩyaŋ a basɩ wɩya no tɩya ma. ");
INSERT INTO sig_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nɩmmabalɩya sɩ kaŋ dɔmɔŋ a mʋ tɩya dɩ ba kpʋ. Dɩ kuwoma mɛ yaa ba biisi gɛɛ tɩɩ. Biisi mɛ sɩ vɩya ba kuwoma abee ba nɩmma nyʋʋsɩ tɩŋɩɩ aŋ kaŋ ba mʋ tɩya dɩ ba kpʋ. ");
INSERT INTO sig_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nal nal buloŋ sɩ kuu ŋ wɩya a haasɩ ma. Amɛ nal hʋ buloŋ aa kaŋ mala ʋ laadii tɩyaŋ a mʋ teŋ, Wɩɩsɩ sɩ laa ʋ ta. ");
INSERT INTO sig_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dɩ ba ko kɩ dɔgɩsɩ ma tɔɔ kɩdɩgɩ tɩyaŋ, ma lɩɩ a fá mʋ tɔdʋma. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma bɩ sɩ wuwo tʋŋ tʋma hʋ ŋ aa kpaa tɩya ma teŋ Iziral paalʋʋ buloŋ tɩyaŋ, ka dɩ mɩyaŋ Nihuwobiŋ Biye na mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sakuuribiye bee te ʋ dɩdagɩl. Ɛɛ rɛ yoŋ mɛ bee te ʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amɛ sakuuribiye maga dɩ ʋ mɛ kɩɩ dɩdagɩl hʋ aa daga ʋ rɛ. Yoŋ mɛ maga dɩ ʋ kɩɩ nal hʋ aa deŋe ʋ rɛ. Dɩ ba aa rɛ yaŋ kaŋ dɩya tɩɩna kɩ yɩrɩ Sɩtaanɩ, ɛɛ kɛ, ba sɩ tɩya dɩya hʋ nala fene aa lɔrɔ te Sɩtaanɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ɛɛwɩya, ma ta kɩ fá nala no, wɩɩ buloŋ tuwo a yaa wɩfaŋɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wɩɩ buloŋ ŋ aa faŋa basɩ tɩya ma, ʋ maga dɩ ma basɩ ʋ lɩgyalɩɩ tɩyaŋ nɛ. Wɩɩ buloŋ mɛ ŋ aa miŋse tɩya ma, ma basɩ ʋ dɩ nal buloŋ nɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma ta kɩ fáá nala hʋ aa sɩ wuwo kpʋ ma dʋŋ. Amɛ ma kɩ fá Wɩɩsɩ, beewɩya ʋ rɛ kaŋ dee ʋ aa sɩ wuwo leŋ dɩ ɩ sʋba, a kaŋ dee mɛ ʋ aa sɩ maakyiye kpa ɩ we diŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kokobiisi balɩya yalɩɩ yaa baŋmɛ rɛ? Amɛ dɩ ma kuwo Wɩɩsɩ mɛ yaŋ bɩ tɩya ŋmanɩɩ ba kɩdɩgɩ buloŋ bee sʋba. ");
INSERT INTO sig_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wɩɩsɩ paalɩ gyɩŋ ma kɩdɩgɩ buloŋ nyupʋna nyʋwa rɛ. ");
INSERT INTO sig_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɛɛwɩya, ma ta leŋ dɩ kambɩŋ kaŋ ma. Beewɩya Wɩɩsɩ sɩya kɛ tɩyaŋ ma kɩdɩgɩ buloŋ kaŋ tɔnɔ rɛ kɩŋkaŋ a te kokogyamaa. ");
INSERT INTO sig_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nal hʋ buloŋ aa sɩ wuwo sɩŋ gyamaa tɩyaŋ a baa dɩ ʋ yaa ŋ nal lɛ, ɛɛ tɩɩ rɛ ŋ mɛ sɩ basɩ ʋ tɩɩna wɩya ŋ Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amɛ nal hʋ buloŋ mɛ aa sɩ vɩya ŋ wɩya gyamaa tɩyaŋ, ɛɛ tɩɩ rɛ ŋ mɛ sɩ vɩya ʋ tɩɩna wɩya ŋ Kuwo Wɩɩsɩ aa we wɩɩsɩbee sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma ta bɩɩna anɩɩ ŋ ko dʋnɩya dɩ nala sʋma rɛ? Aayɩ, yuwo rɛ ŋ kaŋ ko. ");
INSERT INTO sig_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ŋ ko dɩ ŋ porigi nala dɔmɔŋ tɩyaŋ nɛ anɩɩ ba aa saba gɛɛ Wɩɩsɩ teŋ tɩyaŋ. Biye bee ʋ kuwo sɩ kaa dɔmɔŋ. Dɩ haŋtolibiye bee ʋ naa mɛ kaa dɔmɔŋ. Biihaaŋ bee ʋ bala nɩɩna sɩ kaa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nal dɩya nala tɩɩ rɛ sɩ yaa ʋ dɔmɔ, a haasɩ ʋ te nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nal hʋ buloŋ aa kyo ʋ kuwo abee ʋ naa a te ŋ, ʋ tɩɩna bɩ maga dɩ ʋ yaa ŋ hatɩnnɩ. Nal hʋ buloŋ mɛ aa kyo ʋ biibaal koo ʋ toluu a te ŋ, ʋ tɩɩna bɩ maga dɩ ʋ yaa ŋ hatɩnnɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nal hʋ buloŋ aa bɩ baasɩ ʋ tɩɩ daagarɩɩ, a kɩ tɩŋa ŋ hal, ʋ tɩɩna bɩ maga dɩ ʋ yaa ŋ hatɩnnɩ. ");
INSERT INTO sig_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nal hʋ buloŋ aa kyo ʋ tɩɩ mɩɩbol, ʋ tɩɩna sɩ kpa ʋ mɩɩbol ta. Amɛ nal hʋ mɛ buloŋ aa sɩ kuu ŋ wɩya a vɩya ʋ mɩɩbol ta ʋ tɩɩna sɩ kaŋ mɩɩbol aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nal hʋ buloŋ aa sɩ kaŋ ma weliŋ, mɩyaŋ nɛ ʋ tɩɩna kaŋ weliŋ gɛɛ. Nal hʋ buloŋ mɛ aa kana ŋ weliŋ, Tɩɩna hʋ aa tɩma ŋ mɛ rɛ ʋ kaŋ weliŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nal hʋ buloŋ aa kaŋ Wɩɩsɩ tɩŋdaal weliŋ akuu ʋ aa yaa Wɩɩsɩ tɩŋdaal wɩya, Wɩɩsɩ aa tɩya ʋ tɩɩna Wɩɩsɩ tɩŋdaal tuno rɛ. Nal hʋ mɛ buloŋ aa kaŋ tɩpʋlʋŋ tɩɩna weliŋ akuu ʋ aa yaa tɩpʋlʋŋ tɩɩna wɩya, Wɩɩsɩ aa tɩya ʋ tɩɩna mɛ tɩpʋlʋŋ tɩɩna tuno rɛ. ");
INSERT INTO sig_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nal hʋ mɛ buloŋ aa sɩ yaa nɩɩfɩyɛlɩɩ mɛ gba tɩya ŋ hatɩnna no tɩyaŋ nɩbiye akuu ʋ aa yaa ŋ hatɩnnɩ wɩya, wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma Wɩɩsɩ kɔnɩ sɩ tuŋ ʋ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu a basɩ wɩya no a tɩya ʋ hatɩnna hʋ fi abee balɩya ko teŋ, ʋ lɩɩ doŋ a mʋ dɩ ʋ daga nala aŋ pɛ basɩ Wɩɩsɩ wɩya Galili paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Saŋa no tɩyaŋ dɩ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ gyɩ we nɩtɔdɩya tɩyaŋ nɛ. Ʋ aa nɩɩ wɩya hʋ Krisita aa yaa, ɛɛ rɛ ʋ tɩŋ ʋ hatɩnna badɔmɔŋ, ");
INSERT INTO sig_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba mʋ pɩyɛsɩ ʋ a baa, “Basɩ tɩya ma, ɩ rɛ yaa nal hʋ Gyɔɔŋ fa aa baa dɩ ʋ sɩ ko laa ma ta hʋ, koo á ha kɩ gyegili nɩdɩma?” ");
INSERT INTO sig_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma mɩɩgɩ mʋ basɩ tɩya Gyɔɔŋ wɩya hʋ buloŋ ma aa naa, abee wɩya hʋ buloŋ ma aa nɩya. ");
INSERT INTO sig_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma mʋ basɩ tɩya ʋ dɩ nyʋlɩma sɩya suro rɛ, gbarɩga kɩ vala, gbegisi mɛ kɩ deye, wonni kɩ nɩɩ wɩya, nala hʋ a sʋba kɩ sii sʋʋ tɩyaŋ. Ka ba basɩ Wɩɩsɩ wɩweliye hʋ mɛ a kɩ tɩya nyaaba. ");
INSERT INTO sig_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Teŋfɩyɛl tɩmma rɛ yaa nala hʋ kɔnɩ aa laa ŋ wɩya di aŋ bɩ sɩ maakyiye yaa ŋ sige anɩɩ mɩyaŋ nɛ yaa nal hʋ Wɩɩsɩ aa tɩma.” ");
INSERT INTO sig_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Saŋa hʋ Gyɔɔŋ hatɩnna hʋ aa kpaa kɩ mʋ, ɛɛ rɛ Yesu piili basɩ Gyɔɔŋ wɩya a kɩ tɩya gyamaa hʋ. Ʋ pɩyɛsɩ ba rɛ a baa, “Ma gyɩ aa mʋʋ Gyɔɔŋ lee pogo hʋ tɩyaŋ nɩgɛɛ iriŋ nɛ ma gyɩ fa kɩ yɩyɛlɩ anɩɩ ma sɩ mʋ na. Ma gyɩ bɩɩna Gyɔɔŋ kɩɩ gɛɛ anɩɩ ɔhɔ puwo a kaŋ kɩ viisi rɛ ma mʋ ma na koo? ");
INSERT INTO sig_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dɩ ɛɛ yaŋ daa, nɩgɛɛ iriŋ nɛ ma lɩɩ dɩ ma na? Ma lɩɩ dɩ ma na nal a laalɩ gaweliye rɛ? Aayɩ. Deŋ na, nala hʋ aa laalɩ gannɩ no iriŋ, ba aa we kuworidɩɩsɩ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma yaŋ daga ŋ nal hʋ iriŋ ma aa lɩɩ doŋ dɩ ma na. Ma mʋwa dɩ ma na Wɩɩsɩ tɩŋdaal lɛ koo? Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ ma gyɩ aa naa, ʋ tee Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nal no wɩya rɛ ba gyɩ sabɩ biŋ Wɩɩsɩ teŋ tɩyaŋ a baa dɩ Wɩɩsɩ baa, ‘Ŋ sɩ tɩŋ ŋ tɩŋdaal dɩ ʋ laa ɩ sɩya a mʋ marɩ ŋmanɩɩ bin-ɩ.’ ");
INSERT INTO sig_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ba ha bɩ maakyiye lʋl nal buloŋ dʋnɩya no tɩyaŋ ʋ tee Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ. Amɛ nal hʋ yaŋ aa yaa nɩbiye Wɩɩsɩbee koro hʋ tɩyaŋ, ʋ tɩɩna mɛ rɛ tee Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A yaŋ lɩɩ saŋa hʋ Gyɔɔŋ Wɩɩsɩnɩɩfool aa piile basɩ Wɩɩsɩ wɩya a kaŋ kɩ ko gyɩnaŋ, nala kaŋ Wɩɩsɩbee koro hʋ wɩya kɩ kaa dɔmɔŋ nɛ, ɛɛ rɛ gaduwogo kɩ lʋga dɩ ba kaŋ fasɩ. ");
INSERT INTO sig_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amɛ ka dɩ Gyɔɔŋ na ko, dɩ Wɩɩsɩ tɩŋdaala hʋ abee mɩrɩsɩ hʋ Wɩɩsɩ gyɩ aa leŋ Moosi sabɩ biŋ hʋ laa sɩya basɩ Wɩɩsɩbee koro hʋ wɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dɩ mamaa rɛ laa di anɩɩ wɩya no yaa wɩtɩɩ rɛ, ɛɛ kɛ ʋ maga dɩ ma gyɩma anɩɩ Gyɔɔŋ nɛ yaa nal hʋ wɩya ba gyɩ aa basa Wɩɩsɩ teŋ tɩyaŋ anɩɩ Ilaagya sɩ mɩɩgɩ ko hʋ. ");
INSERT INTO sig_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma leŋ dɩ ŋ daga ma gɛɛ hʋ gyɩnaŋ nala aa kɩya. Ba kɩɩ gɛɛ rɛ anɩɩ haŋbiisi aa lɩɩ dɩ ba gbɩyalɩ. Badɔmɔŋ aa huwori ba dɔŋtɩŋsɩ a basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Á yɩɩ yɩɩla rɛ tɩya ma, ka ma vɩya gʋwayɩ. Á taa haŋyee mɛ tɩya ma ka ma vɩya wiyi.”’ ");
INSERT INTO sig_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɛɛ tɩɩ rɛ yaŋ, saŋa hʋ tɩyaŋ Gyɔɔŋ gyɩ aa ko ma lee, ʋ gyɩ aa vʋwa nyʋwa rɛ, aŋ bee nyʋwa sɩŋ mɛ. Ɛɛ rɛ nala baa dɩ gyɩŋbɔŋ nɛ kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aŋka mɩyaŋ Nihuwobiŋ Biye mɛ ko a kɩ di kɩna aŋ kɩ nyʋwa sɩŋ mɛ. Ɛɛ rɛ nala baa dɩ baal no kɛ yaa naboliŋ tɩɩna rɛ, a yaa sɩnyʋwal mɛ aŋ pɛ kaŋ lampolaala abee wɩbɔŋyaala buloŋ mɛ yaa ʋ kyaŋsɩ. Nala hʋ aa kaŋ Wɩɩsɩ wɩgyʋŋ hʋ, ba wɩyaalɩya rɛ aa daga.” ");
INSERT INTO sig_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tɔnɩ hʋ tɩyaŋ Yesu gyɩ aa yaa wɩmagɩla hʋ gyeniŋ buloŋ nala gyɩ bɩ bɩrɩma lɩɩ ba wɩbɔmɔ yayɩ tɩyaŋ. Ɛɛ rɛ ʋ basɩ ba sɩya wɩya tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mamaa Kɔrazɩŋ tɩmma abee Bɛsaada tɩmma, ma sɩ na tʋwara kɩŋkaŋ. Wɩmagɩla hʋ ŋ aa yaa ma lee, dɩ mɩyaŋ nɛ fa yaa wɩya no Taaya abee Siidɔŋ nala lee, ba fa bɩ sɩ yaa gyegye ka dɩ ba paa ba logannɩ laalɩ, aŋ yaa tʋwɔl bʋgɩ ba tɩɩ a daga anɩɩ ba tɩsɩ kyogo rɛ, ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, sarɩya hʋ kyɛdiilii, Wɩɩsɩ sɩ dɔgɩsɩ Kɔrazɩŋ abee Bɛsaada tɩmma a te Taaya abee Siidɔŋ tɩmma. ");
INSERT INTO sig_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mamaa Kapɛɛnam tɩmma, ma ta ko kɩ liisi anɩɩ Wɩɩsɩ sɩ bigisi ma. Ma gyɩŋ tɩya ma tɩɩ weliŋ, ʋ sɩ kpa ma we diŋ tɩyaŋ dɩ ma na tʋwara kɩŋkaŋ. Ma bɩɩna ma sɩ wuwo kaŋ ma tɩɩ gyɩŋ wɩɩsɩbee rɛ koo? Wɩɩsɩ sɩ kpa ma yuwo we diŋ tɩyaŋ dɩ ma na tʋwara kɩŋkaŋ. Wɩmagɩla no buloŋ ŋ aa yaa ma lee, dɩ Sodɔm tɩyaŋ nɛ ŋ fa yaa ba, Wɩɩsɩ fa bɩ sɩ kyogi doŋ buloŋ. Sodɔm ha fa sɩ we doŋ a kaŋ kɩ ko gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amɛ ŋ yaŋ basɩ kɩ tɩya ma rɛ, sarɩya hʋ kyɛdiilii Wɩɩsɩ sɩ dɔgɩsɩ Kapɛɛnam tɩmma a te sodɔm tɩmma.” ");
INSERT INTO sig_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saŋa no tɩɩ tɩyaŋ nɛ Yesu baa, “Ŋ Kuwo Wɩɩsɩ, ɩ rɛ yaa wɩɩsɩnyuu abee taŋha buloŋ Tɩɩna. Ŋ aa dannɩ ɩ rɛ akuu wɩya hʋ ɩ aa kpaa faŋa wɩgyʋnna, aŋ kpa ba daga nala hʋ aa bɩ kaŋ wɩgyʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ŋ Kuwo, ŋ aa kyʋwalɩ ɩ aŋgyʋwasʋ rɛ beewɩya wɩɩ hʋ ɩ aa kyɛɛ ʋ rɛ ɩ yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ŋ Kuwo kpaa kɩŋ buloŋ dee tɩya ŋ nɛ. Ŋ Kuwo dʋŋ nɛ gyɩŋ gɛɛ ŋ aa kɩya. Ŋ dʋŋ mɛ rɛ gyɩŋ gɛɛ ŋ Kuwo aa kɩya. Nal buloŋ bɩ gyɩma ʋ, see nala hʋ dʋŋ ŋ aa lɩya a daga ʋ tɩya ba.” ");
INSERT INTO sig_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma nala hʋ buloŋ aa lɔlɔ, aŋka wɩya vʋwa ma biŋ, ma ko ŋ lee, dɩ ŋ tɩya ma wiyese. ");
INSERT INTO sig_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma tɩŋ ŋ nyʋwa dɩ á yaa nyʋʋdɩgɩ, dɩ ma wuwo gyɩŋ tʋma hʋ ŋ aa kpaa tɩya ma dɩ ma tʋma weliŋ, beewɩya, ŋ sɩya fɩyɛla rɛ ka ŋ gyɩŋ ŋ tɩɩ kanɩɩ mɛ. Dɩ mamaa rɛ yaa gɛɛ, ŋ sɩ tɩya ma wiyese. ");
INSERT INTO sig_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wɩya hʋ ŋ aa baa dɩ ma yaa, ba bɩ yaa wɩduwoni ma aa sɩ yaa lɔlɔ. Tʋma hʋ mɛ ŋ aa sɩ kpa tɩya ma, ba bɩ sɩ leŋ dɩ ma buri.” ");
INSERT INTO sig_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ʋ gyɩ bɩ pɩɩsa ka Yesu bee ʋ hatɩnna sii kyɛwiyesii hʋ kyɛɛ a tɩŋ nyoŋso baga kɩdɩgɩ tɩyaŋ a kɩ mʋ. Ɛɛ rɛ losi gyɩ kaŋ ʋ hatɩnna hʋ ba bori nyoŋso hʋ a piisi kɩ kyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ɛɛ rɛ Farasiima badɔmɔŋ na ba a pɩyɛsɩ Yesu a baa, “Ɩ bɩ naa? Kyɛwiyesii hʋ kyɛɛ sɩna daa ɩ hatɩnna hʋ kɩ kyogi gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ma ha bɩ karɩmɩ wɩɩ hʋ Kuwori Deviti gyɩ aa yaa saŋa hʋ losi gyɩ aa kaŋ ʋ bee ʋ hatɩnna? ");
INSERT INTO sig_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ʋ gyɩ mʋʋ gyʋʋ Wɩɩsɩ dɩya hʋ rɛ, a kpa paanʋʋ hʋ ba gyɩ aa kaŋ ko biŋ Wɩɩsɩ sɩya, a lɩɩ ʋ bee ʋ hatɩnna kyaŋ. Ʋ fa yaa sɩna rɛ dɩ nɩwaasɩ buloŋ kyaŋ haŋ paanʋʋ hʋ, see wɩɩkyʋwal sɩlaala hʋ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma tɩɩ gyɩma rɛ anɩɩ tʋma hʋ wɩɩkyʋwal sɩlaala hʋ aa kɩ tʋma Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ Kyɛwiyesii hʋ kyɛɛ yaa kyɛɛ no sɩna rɛ. Amɛ ma tɩɩ naa rɛ mɩrɩsɩ hʋ Moosi aa saba tɩyaŋ anɩɩ Wɩɩsɩ bɩ sɩ kpa kyogisi tɩya ba ɛɛwɩya. ");
INSERT INTO sig_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, “Nal aa tee Wɩɩkyʋwaldɩɩbal hʋ rɛ we daha nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ba saba rɛ Wɩɩsɩ teŋ tɩyaŋ a baa, “Ma aa fá nala sikii, ʋ rɛ kpɩya ma aa lɩɩ wɩɩsʋllɩ kɩna a kpʋ tɩya ŋ.” Dɩ mamaa rɛ kɔnɩ fa gyɩŋ wɩɩ no memii, ma fa bɩ sɩ kpa kyogisi kɩ tɩya nala hʋ aa bɩ kaŋ wɩkyogii. ");
INSERT INTO sig_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mɩyaŋ Nihuwobiŋ Biye rɛ yaa Kyɛwiyesii hʋ kyɛɛ Tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ɛɛ rɛ Yesu lɩɩ doŋ, a mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya kɩdɩgɩ, ");
INSERT INTO sig_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","dɩ banosʋʋ kɩdɩgɩ tɩɩna mɛ we doŋ. Nala hʋ aa we wɩɩkyʋwaldɩya hʋ tɩyaŋ fa aa kyɛ ŋmanɩɩ rɛ dɩ ba basɩ tɩya Yesu anɩɩ ʋ kyogi ba mɩrɩsɩ rɛ. Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Ʋ yaa ŋmanɩɩ dɩ á tɩɩbɩ wɩɩla tɩmma kyɛwiyesii hʋ kyɛɛ koo ʋ bɩ yaa ŋmanɩɩ?” ");
INSERT INTO sig_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Dɩ ma kɩdɩgɩ rɛ kaŋ piyesi dɩ ʋ tele kɔlʋŋ tɩyaŋ Kyɛwiyesii hʋ kyɛɛ, na ɩ aa lɩɩ ʋ rɛ? ");
INSERT INTO sig_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nihuwobiŋ nɛ tee piyesi. Ɛɛwɩya, dɩ ámaa rɛ aa yaa wɩweliye kyɛwiyesii hʋ kyɛɛ, mɩra buloŋ bɩ daga anɩɩ á yaa wɩɩ kyogi rɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ɛɛ rɛ Yesu basɩ tɩya nosʋʋ hʋ tɩɩna a baa, ‘Kaŋ ɩ noŋ hʋ tannɩ.’ Nyɛ rɛ ʋ kaŋ ʋ noŋ tannɩ. Ʋ mɩɩgɩ kɩɩ noduwo hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɛɛ rɛ Farasiima hʋ mɛ sii lɩɩ doŋ a mʋ dɩ ba vʋʋlɩ gɛɛ hʋ ba aa sɩ yaa a kpʋ Yesu. ");
INSERT INTO sig_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu aa ko gyɩma anɩɩ nala hʋ aa vʋʋlɩ ʋ kpʋyɩ wɩya rɛ, ɛɛ rɛ ʋ sii lɩɩ doŋ. Amɛ nɩgyamaa ha gyɩ sii tɩŋa ʋ hal. Nyɛ rɛ ʋ tɩɩbɩ nala hʋ buloŋ fa aa wɩɩlɩ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aŋ basɩ tɩya ba abee sɩfɩyasɩ a baa, “Ma ta ko gɔllɩ basɩ ŋ wɩya a kɩ tɩya nala.” ");
INSERT INTO sig_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ʋ gyɩ aa basɩ wɩɩ no leŋ wɩɩ hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Azaaya tɩyaŋ basɩ kɔnɩ ko yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Wɩɩsɩ gyɩ baa, “Ma na, nal hʋ ŋ aa lɩya dɩ ʋ yaa ŋ tʋŋtʋnnɩ rɛ nyɛ, ʋ rɛ ŋ kyo, ŋ teŋ fɩyɛla rɛ ʋ tɩyaŋ kɩŋkaŋ. Ŋ sɩ kpa ŋ Wiyesi Welii hʋ dee we ʋ tɩyaŋ. Dɩ ʋ basɩ tɩya dʋnɩya nala buloŋ anɩɩ saŋa hʋ ŋ aa sɩ laa ba ta pele rɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ʋ bɩ sɩ gɔllɩ ŋmaa nyʋʋtaaduwo kɩ baŋ. Ʋ bɩ sɩ gɔllɩ lee buloŋ nɔsɩ wɩya kɩ baŋ gyamaa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ʋ sɩya sɩ fɩyɛlɩ sikii tɩmma lee aŋ kaŋ bɔnyɛ mɛ a beel-ba. Ʋ bɩ sɩ yaa wɩya hʋ aa sɩ leŋ dɩ ba kpa ba bayɩyɛla hʋ ba aa kana ta, a mʋ pele saŋa hʋ dʋnɩya nala aa sɩ na Wɩɩsɩ laatayɩ hʋ ʋ aa kpaa tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ʋ tɩyaŋ nɛ dʋnɩya nala buloŋ sɩ kpa ba bayɩyɛla we dɩ ʋ laa ba ta.” ");
INSERT INTO sig_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɛɛ hal tɩyaŋ nɛ nala badɔmɔŋ kaŋ baal kɩdɩgɩ gyɩŋbɔmɔ aa kana, ʋ nyʋlɩmɩ, aŋ bɩ wuwo kɩ basɩ wɩya mɛ, a ko Yesu lee. Nyɛ rɛ Yesu tɩɩbɩ baal hʋ, ʋ bɩl wuwo kɩ basɩ wɩya aŋ kɩ na mɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yesu aa yaa gɛɛ, nɩgyamaa hʋ buloŋ aa we doŋ nyʋʋsɩ gyɩ fɩyɛla rɛ. Ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Kuwori Deviti nihii hʋ á aa gyegili dɩ ʋ ko laa ma ta hʋ rɛ nyɛ dʋ?” ");
INSERT INTO sig_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amɛ Farasiima hʋ gyɩ aa nɩɩ gɛɛ Yesu aa tɩɩbɩ baal hʋ gyɩŋbɔmɔ hʋ gyɩ aa kana, ba baa dɩ gyɩŋbɔmɔ kuwori Bɛlizebul lɛ tɩya ʋ dee ɛɛ rɛ tɩŋ ʋ wuwo kɩ kile gyɩŋbɔmɔ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu gyɩ gyɩŋ wɩɩ hʋ ba aa bɩɩnɩ ba tɩɩsɩ tɩyaŋ, a basɩ tɩya ba a baa, “Dɩ paalʋʋdɩgɩ nala rɛ we doŋ a bɩ kaŋ nyʋʋdɩgɩ, ba paalʋʋ hʋ bɩ sɩ pɩɩsɩ aŋ tele. Dɩ bedɩgɩ nala koo gyaŋwuwodɩgɩ nala mɛ rɛ we doŋ a bɩ kaŋ nyʋʋdɩgɩ, ba bee hʋ koo ba gyaŋwuwo hʋ bɩ sɩ pɩɩsɩ aŋ tele. ");
INSERT INTO sig_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na ma baa dɩ Sɩtaanɩ dee rɛ ŋ kpaa kɩ kil gyɩŋbɔmɔ, ɛɛ daga anɩɩ Sɩtaanɩ gʋl kaŋ ʋ tɩɩ kɩ kaa kaasɩ rɛ gɛɛ. Dɩ gɛɛ rɛ we doŋ, ʋ koro hʋ bɩl bɩ sɩ pɩɩsɩ aŋ tele. ");
INSERT INTO sig_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dɩ ɛɛ hʋ ma aa basɩ kɔnɩ yaŋ yaa wɩtɩɩ anɩɩ gyɩŋbɔmɔ kuwori Bɛlizebul lɛ tɩya ŋ dee ŋ kɩ kil gyɩŋbɔmɔ, ɛɛ kɛ aŋnɛ rɛ tɩya ma tɩɩ hatɩnna hʋ mɛ dee ba kɩ kil gyɩŋbɔmɔ. Ma hatɩnna hʋ wɩyaalɩya yaŋ daga anɩɩ ma wɩbasɩɩ hʋ buloŋ yaa wɩnyɩyɛl lɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aayɩ Bɛlizebul daa tɩya ŋ dee hʋ, amɛ Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ nɛ ŋ wuwo kɩ kil gyɩŋbɔmɔ nala tɩyaŋ gɛɛ. Nyɛ rɛ yaŋ daga anɩɩ Wɩɩsɩ koro hʋ ko we ma lee rɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nal buloŋ tuwo ʋ aa sɩ wuwo bori gyʋʋ gaduwogi dɩya a gaa ʋ kɩna, dɩ ʋ bɩ laa sɩya kaŋ gaduwogi hʋ vʋwa. ");
INSERT INTO sig_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nal hʋ buloŋ aa bɩ yaa ŋ nal, ʋ tɩɩna lɩɩ ŋ hal lɛ. Nal hʋ buloŋ aa bɩ pɛ ŋ tɩyaŋ dɩ á gbaa nala kɩ we lɩdɩgɩ, ʋ tɩɩna leŋ nala kɩ vɩya Wɩɩsɩ ŋmanɩɩ rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ɛɛwɩya ma yaŋ leŋ dɩ ŋ basɩ tɩya ma, nal hʋ buloŋ aa yaa ʋ dɔŋtɩɩna wɩbɔŋ, koo a basɩ wɩya kyogi Wɩɩsɩ feŋ, Wɩɩsɩ sɩ wuwo kpa kyɛ ʋ. Amɛ nal hʋ buloŋ aa basɩ wɩya tʋʋsɩ Wɩɩsɩ Wiyesi Welii hʋ, Wɩɩsɩ bɩ sɩ maakyiye kpa kyɛ ʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nal hʋ buloŋ aa sɩ basɩ wɩbɔmɔ a tɩya mɩyaŋ Nihuwobiŋ Biye, Wɩɩsɩ aa wuwo ʋ kpa kyɛ ʋ rɛ, amɛ nal hʋ buloŋ aa basɩ wɩya tʋʋsɩ Wɩɩsɩ Wiyesi Welii hʋ kɛ, Wɩɩsɩ bɩ sɩ kpa kyɛ ʋ tɩɩna, gyɩnaŋ koo maakyiye kɩdɩgɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ɛɛ rɛ Yesu bɩl baa, “Dɩ ɩ rɛ deŋ tɩya nyuu tɩyaŋ dɩ ʋ waa weliŋ a kaŋ laaŋfɩya, ʋ aa nɔŋ nɔŋweliye rɛ. Dɩ ɩ rɛ bɩ deŋ tɩya hʋ nyuu tɩyaŋ weliŋ ka dɩ wɩɩla kana ʋ, ʋ aa nɔŋ nɔŋbɔŋlɔrɩnɩ rɛ. Tɩya nɔnɔ rɛ aa daga tɩya hʋ iriŋ ʋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɛɛ rɛ ma mɛ yaŋ kɩɩ anɩɩ dʋma, ma bɔmɔ rɛ weliŋ, ɛɛwɩya ma bɩ sɩ wuwo basɩ wɩwelii kɩdɩgɩ buloŋ. Beewɩya, nihuwobiŋ wɩbasɩɩ tɩyaŋ nɛ ɩ aa gyɩŋ nihuwobiŋ hʋ iriŋ ʋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nal hʋ aa kaŋ tɩbɩɩŋweliye ʋ tɩya tɩyaŋ, ʋ rɛ aa yaa wɩweliye. Nal hʋ mɛ aa kaŋ tɩbɩɩŋbɔmɔ ʋ tɩya tɩyaŋ ʋ tɩɩna mɛ rɛ aa yaa wɩbɔmɔ. ");
INSERT INTO sig_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ŋ basɩ kɩ tɩya ma rɛ, nal hʋ buloŋ aa bɩ gyɩŋ ʋ nyʋwa kanɩɩ aŋ basɩ wɩɩ hʋ fa aa bɩ maga dɩ ʋ basɩ, sarɩya hʋ kyɛdiilii ʋ sɩ daga wɩɩ hʋ aa tɩŋ ʋ tɩɩna yaa gɛɛ a tɩya Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma tɩɩ nyʋʋdaasɩ rɛ Wɩɩsɩ sɩ kpa di ma sarɩya, dɩ ma laa wɩsʋma koo ma laa kyogisi tɩya ma tɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima sii ko Yesu lee a basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, á aa kyɛ dɩ ɩ yaa wɩmagɩl lɛ dɩ á na a gyɩma anɩɩ Wɩɩsɩ kɔnɩ we ɩ lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɛɛ rɛ Yesu baa, “Ma gyɩnaŋ nala yaa nɩbɔmɔ rɛ, a bɩ gyɩŋ Wɩɩsɩ mɛ. Ma aa sɩ yaa gɛɛ gyɩŋ Wɩɩsɩ wɩya bɩ kyɩl ma see wɩmagɩla dʋŋ wɩya rɛ kyɩl ma. Wɩmagɩl hʋ buloŋ Wɩɩsɩ aa sɩ yaa dɩ ma na rɛ yaa wɩmagɩl hʋ ʋ gyɩ aa yaa ʋ tɩŋdaal Gyoona tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gyoona gyɩ aa yaŋ we fuwonaŋbal hʋ fuu tɩyaŋ kyɛyɛ kpaŋkpaŋ boto gɛɛ, ɛɛ tɩɩ rɛ mɩyaŋ Nihuwobiŋ Biye mɛ sɩ we bʋwa tɩyaŋ kyɛyɛ boto. ");
INSERT INTO sig_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sarɩya hʋ kyɛdiilii, Ninive nala sɩ kpa kyogisi tɩya ma gyɩnaŋ nala. Beewɩya saŋa hʋ tɩyaŋ Gyoona gyɩ aa mʋʋ basɩ Wɩɩsɩ wɩya tɩya ba, ba gyɩ bɩrɩma lɩɩ ba wɩbɔmɔ tɩyaŋ nɛ aŋ tɩŋ Wɩɩsɩ. Ma yaŋ leŋ dɩ ŋ basɩ tɩya ma anɩɩ lagɩlagɩ no nal lɛ we ma tɩyaŋ a te Gyoona.” ");
INSERT INTO sig_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma gyɩŋ haaŋ hʋ Siiba tɩmma gyɩ aa lɩya ʋ gyɩ yaa ba kuwori rɛ. Ʋ gyɩ sii mʋ lee bee ʋ dɔŋ nɛ dɩ ʋ mʋ nɩɩ wɩgyʋŋ hʋ kuwori Solomɔn gyɩ aa kpaa kɩ daga nala. Sarɩya hʋ kyɛdiilii, haaŋ no mɛ sɩ kpa kyogisi tɩya ma. Ma yaŋ gyɩma weliŋ anɩɩ lagɩlagɩ no nal lɛ we ma tɩyaŋ daha a te kuwori Solomɔn ka ma vɩya ʋ tɩŋɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ɛɛ rɛ Yesu bɩl baa, “Dɩ ba ko kile gyɩŋbɔŋ dɩ ʋ lɩɩ nal tɩyaŋ, ʋ aa gɔllɩ taŋhahɩlɩɩ tɩyaŋ nɛ a kɩ kyɛ lee dɩ ʋ wiyesi, amɛ dɩ ʋ ko kyɛ lee lɔlɔ, ");
INSERT INTO sig_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ʋ aa mɩɩgɩ basɩ tɩya ʋ tɩɩ rɛ a baa, ‘Ŋ sɩ mɩɩgɩ mʋ lee hʋ ŋ aa lɩya.’ Dɩ ʋ rɛ ko mɩɩgɩ ko dɩ ba marɩ dɩya hʋ buloŋ weliŋ, ka nal buloŋ tuwo ʋ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ʋ aa mɩɩgɩ mʋ kaŋ gyɩŋbɔmɔ bapɛ aa bɔmɔ te ʋ tɩɩ rɛ a pɛ dɩ ba ko kɩ gyʋʋ. Ɛɛ hal tɩyaŋ, ba sɩ lɔrɩ ʋ tɩɩna tɩyaŋ a te ʋ fa aa kɩɩ gɛɛ. Ɛɛ tɩɩ rɛ ba sɩ kɩɩ ma gyɩnaŋ nɩbɔmɔ no mɛ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ha gyɩ aa basɩ wɩya kɩ tɩya nɩgyamaa hʋ gɛɛ, dɩ ʋ naa abee ʋ naabalɩya ko sɩŋ gyaŋhal tɩyaŋ a kɩ kyɛ dɩ ba na ʋ. ");
INSERT INTO sig_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɛɛ rɛ nala hʋ kɩdɩgɩ basɩ tɩya Yesu a baa, “Ɩ naa bee ɩ naabalɩya rɛ sɩŋ gyaŋhal tɩyaŋ a kɩ kyɛ dɩ ba na ɩ.” ");
INSERT INTO sig_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ɛɛ rɛ Yesu mɩɩgɩ pɩyɛsɩ ʋ a baa, “Kɩbee rɛ yaa ŋ naa? Kɩbeema rɛ yaa ŋ naabalɩya?” ");
INSERT INTO sig_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nyɛ rɛ ka Yesu mɩɩgɩ lɩɩ ʋ noŋ a daga ʋ hatɩnna hʋ aŋ baa, “Ŋ naa abee ŋ naabalɩya rɛ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nal hʋ buloŋ aa yaa wɩya hʋ ŋ Kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ aa kyɛ, ʋ tɩɩna rɛ yaa ŋ naabiye abee ŋ naatoluu abee ŋ naa.” ");
INSERT INTO sig_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Haŋ kyɛɛ hʋ tɩɩ rɛ Yesu sii lɩɩ dɩya hʋ tɩyaŋ ʋ bee ʋ hatɩnna hʋ fa aa hɔnɔ, a tuu mʋ hɔŋ Galili fuwobal hʋ nyʋwa tɩyaŋ, a kɩ daga nala Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nyɛ rɛ nala ko gol ʋ kyige. Ʋ aa ko na dɩ nala hʋ yʋga gɛɛ, ʋ sii mʋ gyʋʋ hɔŋ nɩɩduworiboro tɩyaŋ, nɩɩ hʋ tɩyaŋ, ka nɩgyamaa hʋ buloŋ sɩŋ fuwo hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɛɛ rɛ ʋ kpa namagɩsɩ a basɩ wɩya yʋga tɩya ba. Ʋ gyɩ maga namaga tɩya ba rɛ a baa, “Baal kɩdɩgɩ rɛ gyɩ siye a kaŋ ʋ kɩdoho mʋ dɩ ʋ gyaasɩ. ");
INSERT INTO sig_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ʋ gyɩ aa gyaasɩ kɩna hʋ tɩyaŋ nɛ biye hʋ badɔmɔŋ tele nɩɩbʋʋsɩ tɩyaŋ. Digibiisi ko tuu tʋwasɩ di. ");
INSERT INTO sig_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Badɔmɔŋ mɛ gyɩ tele bʋnyɩŋ nyuu tɩyaŋ, a pesi nyʋ. ");
INSERT INTO sig_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amɛ akuu doŋ taŋha aa bɩ yʋga wɩya, ba naaliliye bɩ wuwo gyʋʋ taŋha. Ɛɛ rɛ wɩɩsɩ ko pɔsɔ kaŋ ba, ba sʋba. ");
INSERT INTO sig_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka kɩdoho hʋ badɔmɔŋ mɛ gyɩ tele sɔsɩ tɩyaŋ, a nyʋ amɛ sɔsɩ hʋ sii waa gɩrɩgɩ ba, ba pʋgɩmɩ. ");
INSERT INTO sig_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka badɔmɔŋ mɛ gyɩ tele taŋhawelii tɩyaŋ, a nyʋ, a waa, a marɩ weliŋ. Badɔmɔŋ we biye kɔɔ kɔɔ, badɔmɔŋ we mɔllɩboto boto, badɔmɔŋ mɛ mɔlɩya abee fi fi. ");
INSERT INTO sig_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu aa maga namaga hʋ teŋ, ʋ baa, ‘Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ɛɛ rɛ Yesu hatɩnna hʋ sii ko pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ ɩ aa kaŋ namagɩsɩ a basɩ wɩya kɩ tɩya nala hʋ?” ");
INSERT INTO sig_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩya hʋ aa yaa wɩfaŋɩya Wɩɩsɩbee koro hʋ tɩyaŋ, ma nala no rɛ Wɩɩsɩ daga ba memii tɩya, amɛ nal buloŋ daa. ");
INSERT INTO sig_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nal hʋ buloŋ aa gyɩŋ wɩya hʋ aa yaa wɩfaŋɩya wɩɩsɩbee koro hʋ tɩyaŋ, ʋ tɩɩna rɛ Wɩɩsɩ sɩ tɩya wɩgyʋŋ dɩ ʋ marɩ gyɩŋ wɩɩsɩbee koro hʋ memii weliŋ. Nal hʋ mɛ buloŋ aa bɩ gyɩŋ wɩya hʋ aa yaa wɩfaŋɩya wɩɩsɩbee koro hʋ tɩyaŋ kɩdɩgɩ buloŋ, mʋhʋ hʋ mɛ gba ʋ fa aa gyɩma Wɩɩsɩ sɩ kaŋ laa ʋ tɩɩna lee. ");
INSERT INTO sig_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wɩɩ hʋ aa tɩŋ ŋ aa kaŋ namagɩsɩ basɩ wɩya kɩ tɩya ba hʋ rɛ nyɛ: Ba aa deŋ deŋ nɛ aŋ bɩ wuwo kɩ na kɩŋ buloŋ, a kɩ gyegili wɩya mɛ aŋ bee nɩɩ wɩɩ buloŋ, aŋ bɩ wuwo kɩ gyɩŋ wɩya memii mɛ. ");
INSERT INTO sig_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wɩya no aa yaa nala no tɩyaŋ nyɛ leŋ wɩɩ hʋ Wɩɩsɩ tɩŋdaal Azaaya gyɩ aa basa kɔnɩ ko yaa wɩtɩɩ rɛ. Ʋ gyɩ baa, “Nala no sɩ gyegili gyegili wɩya aŋ bɩ sɩ wuwo gyɩŋ wɩɩ buloŋ memii, ba sɩ deŋ deŋ lee buloŋ, aŋ bɩ sɩ wuwo na kɩŋ buloŋ mɛ, ");
INSERT INTO sig_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","beewɩya ba bɩ kaŋ wɩgyʋŋ, ba tɔɔ ba dɩgɩna rɛ dɩ ba ta nɩɩ wɩɩ buloŋ a kaŋ ba sɩya mɛ tɔ dɩ ba ta na kɩŋ buloŋ. Wɩɩsɩ baa, dɩ gɛɛ fa daa, ba sɩya fa sɩ kɩ na, dɩ ba dɩgɩna mɛ fa kɩ nɩɩ wɩya. Ka dɩ ba fa gyɩŋ wɩya memiye mɛ, a fa mɩɩgɩ ko ŋ lee dɩ ŋ tɩɩbɩ ba.” ");
INSERT INTO sig_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amɛ, ma kɛ nyuu sʋma rɛ kɩŋkaŋ, beewɩya ma sɩya aa naa rɛ ma dɩgɩna mɛ kɩ nɩɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, Wɩɩsɩ tɩŋdaala abee tɩpʋlʋŋ tɩmma yʋga rɛ fa kyo dɩ ba na wɩya no ma aa naa nyɛ, aŋ bɩ wuwo na, a fa kyo dɩ ba nɩɩ wɩya no ma aa nɩɩ, aŋ bɩ wuwo nɩɩ ba. ");
INSERT INTO sig_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma gyegili nɩɩ kɩdohil namaga hʋ memii.” ");
INSERT INTO sig_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nala hʋ aa nɩɩ Wɩɩsɩ koro hʋ wɩya, aŋ bɩ gyɩŋ ba memii, ba kɩɩ gɛɛ rɛ anɩɩ kɩdoho hʋ aa tele nɩɩbʋʋsɩ hʋ tɩyaŋ. Sɩtaanɩ rɛ aa ko kaŋ wɩya hʋ Wɩɩsɩ aa kpaa we ba tɩsɩ tɩyaŋ a lɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kɩna hʋ mɛ aa tele bʋnyɩŋ tɩyaŋ mɛ rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩya a pesi laa di abee teŋfɩyɛlʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amɛ wɩɩ hʋ aa bee pɩŋ ba tɩsɩ tɩya a kɩ pɩɩsɩ, beewɩya ʋ tɩɩna laadii aa bɩ yʋga wɩya, dɩ tʋwara rɛ ko gyʋʋ ʋ koo dɩ ba ko kuu Wɩɩsɩ wɩbii hʋ wɩya a kɩ dɔgɩsɩ ʋ, ʋ aa kpaa ta rɛ. ");
INSERT INTO sig_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kɩna hʋ aa tele sɔsɩ hʋ tɩyaŋ mɛ rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩbii hʋ amɛ dʋnɩya no kɩna wɩya kyɩl ba, ba kyo dɩ ba kaŋ kɩna. Ɛɛ wɩya, ba aa bɩ laa nyʋwa dɩ ba tɩŋ Wɩɩsɩ wɩbii hʋ, ka wɩya hʋ mɛ aa bee kaŋ doho ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kɩna hʋ aa tele taŋhawelii tɩyaŋ nɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩbii hʋ, a gyɩŋ ba memii, ʋ kaŋ doho ba tɩyaŋ badɔmɔŋ we biye kɔɔ kɔɔ, badɔmɔŋ mɔllɩboto boto, badɔmɔŋ mɛ mɔlɩya abee fi fi.” ");
INSERT INTO sig_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ɛɛ rɛ Yesu bɩl maga namaga kɩdɩgɩ tɩya ba a baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ baal aa sii kpa kɩdoho weliye a mʋ doho ʋ baga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nyɛ rɛ kyɛɛ kɩdɩgɩ tebine, saŋa hʋ nala buloŋ aa ko pɩŋ doni gɛɛ, baal hʋ dɔŋ sii kaŋ ɔbii a mʋ mɩsɩ baga hʋ tɩyaŋ, aŋ mɩɩgɩ mʋ ʋ lɩmʋʋlɩya. ");
INSERT INTO sig_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kɩdoho hʋ aa nyʋwa, a ko kɩ lʋla a kɩ we biye gɛɛ tɩyaŋ nɛ ba gyɩma nɩɩ ɔhɔ mɛ pɛɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɛɛ rɛ baal hʋ baga-tʋŋtʋnna ko basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, kɩweliye rɛ ɩ doho ɩ baga hʋ tɩyaŋ, ka lee rɛ ɔhɔ mɛ lɩɩ a we baga hʋ tɩyaŋ?” ");
INSERT INTO sig_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ɛɛ rɛ ba nɩhɩyawʋ hʋ basɩ tɩya ba a baa, “Ŋ liise ŋ dɔŋ nɛ mʋʋ yaa gɛɛ.” Ɛɛ rɛ ʋ tʋŋtʋnna hʋ basɩ tɩya ʋ a baa, “Ɛɛ kɛ leŋ á mʋ kyuri ɔhɔ hʋ ta?” ");
INSERT INTO sig_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɛɛ rɛ baal hʋ baa, ‘Aayɩ, beewɩya dɩ mamaa rɛ mʋʋ dɩ ma kyuri ɔhɔ hʋ lagɩlagɩ no, ma sɩ pɛ kyuri kɩdoho hʋ badɔmɔŋ mɛ ta. ");
INSERT INTO sig_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ɛɛwɩya, ma leŋ dɩ kɩdoho hʋ bee ɔhɔ hʋ buloŋ laŋŋɩ waa a we dɔmɔŋ. Dɩ kɩdoho hʋ rɛ ko bɩɩ a yaa kʋmɩɩ, ŋ sɩ leŋ dɩ kʋkʋnna hʋ laa sɩya kyuri ɔhɔ hʋ a vʋwa pɩla a nyɔgɔ ta, aŋ na kʋŋ kɩdoho hʋ a ŋmaa kyaarɩ ko we ŋ busol tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ɛɛ rɛ Yesu bɩl kpa namaga kɩdɩgɩ lo a baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ baal kɩdɩgɩ aa sii kpa kɩdoho kɩdɩgɩ ba aa yɩrɩ masɩtadɩ a mʋ doho ʋ baga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kɩdoho no bii bɩ maga wɩɩ buloŋ. Ʋ muro rɛ weliŋ a te kɩdoho kɛ buloŋ aa we doŋ. Amɛ dɩ ʋ rɛ ko nyʋ, ʋ aa waa a yaa tɩɩbal lɛ, a yʋga te baga kɩdohii kɛ buloŋ. Digibiisi aa ko sʋwa ba gyannɩ ʋ naasɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nyɛ rɛ Yesu bɩl maga namaga kɩdɩgɩ tɩya ba a baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ haaŋ aa kpaa paanʋʋ muŋ kʋrʋba bʋto a we tahaŋbal tɩyaŋ a kpa sɩbʋl mɛ we, a kaŋ ŋmʋra. Mʋhʋ ko kɩ pɛ dɩ muŋ hʋ sii pʋʋsɩ su tahaŋbal hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Namagɩsɩ rɛ Yesu gyɩ aa kpa a basɩ wɩya no buloŋ kɩ tɩya gyamaa hʋ. Ʋ gyɩ bɩ sɩ basɩ wɩɩ buloŋ dɩ ʋ bɩ kaŋ namaga maga. ");
INSERT INTO sig_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ʋ yaa gɛɛ rɛ dɩ wɩya hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Azaaya tɩyaŋ a basɩ ko yaa wɩtɩɩ. Ʋ gyɩ baa, “Namagɩsɩ rɛ ŋ sɩ kpa basɩ wɩya kɩ tɩya ba. Ŋ sɩ basɩ wɩya hʋ ba fa aa bɩ gyɩma a lɩɩ dʋnɩya piilii tɩyaŋ buloŋ a tɩya ba.” ");
INSERT INTO sig_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nyɛ rɛ Yesu leŋ nɩgyamaa hʋ ta aŋ sii gyʋʋ dɩya. Ɛɛ rɛ ʋ hatɩnna hʋ ko pɩyɛsɩ ʋ a baa, “Daga ma ɔbii namaga hʋ ɩ aa maga memii.” ");
INSERT INTO sig_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ɛɛ rɛ Yesu baa, “Nal hʋ aa doho kɩdoho hʋ rɛ yaa mɩyaŋ Nihuwobiŋ Biye. ");
INSERT INTO sig_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Baga hʋ tɩyaŋ ʋ aa doho kɩdoho hʋ mɛ rɛ yaa dʋnɩya no tɩyaŋ ma aa wee. Kidohiweliye hʋ mɛ rɛ yaa nala hʋ aa tɩŋ Wɩɩsɩ nyʋwa a we Wɩɩsɩ koro hʋ tɩyaŋ. Ɔhɔ hʋ mɛ aa nyʋ baga hʋ tɩyaŋ nɛ yaa Sɩtaanɩ nala. ");
INSERT INTO sig_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ʋ dɔŋ hʋ mɛ aa doho ɔbii hʋ rɛ yaa Sɩtaanɩ. Kɩdoho hʋ kyɛkʋmɩɩ mɛ rɛ yaa dʋnɩya kyɛtenii. Nala hʋ mɛ aa sɩ kʋŋ kɩdoho hʋ mɛ rɛ yaa malɩkasɩ. ");
INSERT INTO sig_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ɛɛ hʋ ba aa yaŋ kyuri ɔhɔ hʋ laŋŋɩ a nyɔgɔ ta gɛɛ, ɛɛ tɩɩ rɛ ba sɩ laŋŋɩ Sɩtaanɩ noŋ nala mɛ a we diŋ dʋnɩya kyɛtenii. ");
INSERT INTO sig_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɩyaŋ Nihuwobiŋ Biye, ŋ sɩ tɩŋ ŋ malɩkasɩ dɩ ba gyʋʋ Wɩɩsɩ koro hʋ tɩyaŋ a tʋwasɩ nala hʋ aa leŋ nala yaa wɩbɔmɔ abee nala hʋ buloŋ aa yaa wɩbɔmɔ. ");
INSERT INTO sig_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A leŋ ba kpa ba yuwo we diŋbal hʋ aa bɩ kaŋ dɩsɩɩ tɩyaŋ. Doŋ tɩyaŋ nɛ ba sɩ wii aŋ kyaŋ ba nyɩŋa. ");
INSERT INTO sig_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka dɩ tɩpʋlʋŋ tɩmma kɩ tʋla anɩɩ wɩɩpɔsɩɩ ba Kuwo Wɩɩsɩ koro hʋ tɩyaŋ. Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ɛɛ rɛ Yesu bɩl baa, “Nyɛ rɛ Wɩɩsɩbee koro hʋ kɩɩ: Baal kɩdɩgɩ rɛ mʋʋ kɩ pala baga tɩyaŋ, a kuusi mʋ parɩ salma dɩ ba hogo baga hʋ tɩyaŋ. Ʋ aa naa salma hʋ gɛɛ, ʋ mɩɩgɩ gbaa taŋha tɔ, ka ʋ teŋ buloŋ fɩyɛlɩ. Ɛɛ rɛ ʋ mʋ kpa ʋ kɩna buloŋ a yallɩ, a kaŋ molbii hʋ mʋ yɔbɔ baga hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ɛɛ rɛ Yesu bɩl baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ bayalʋʋ aa gɔllɩ kɩ kyɛ sɩfɩyaŋbʋyɩ kɩdɩgɩ ba aa yɩrɩ pɛɛl. ");
INSERT INTO sig_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ʋ aa ko na sɩfɩyaŋbʋyɩ no kɩdɩgɩ dɩ ʋ weliye ʋ sɩɩ tɩyaŋ, ʋ mɩɩgɩ mʋ kpa ʋ kɩŋ kɩŋ buloŋ yallɩ a mʋ yɔbɔ bʋyɩ hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu bɩl baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ fuwonaŋkasɩla aa kpaa awule a yuwo we nɩɩ tɩyaŋ, a kasɩ fuwonamɩɩsɩ iriŋ iriŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Fuwonamɩɩsɩ hʋ aa ko su awule hʋ, fuwonaŋkasɩla hʋ kaŋ awule hʋ tarɩ lɩɩ nɩɩ hʋ nyʋwa, a tʋwasɩ fuwonaŋweliye hʋ buloŋ aŋ kpa kɩna hʋ aa bɩ yaa a yuwo ta. ");
INSERT INTO sig_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nyɛ rɛ ʋ yaŋ sɩ kɩɩ dʋnɩya kyɛtenii mɛ. Malɩkasɩ sɩ tʋwasɩ nɩbɔmɔ a lɩɩ niweliye tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a kpa ba yuwo we diŋbal aa bɩ sɩ dɩsɩ tɩyaŋ. Doŋ nɛ ba sɩ we a kɩ wii aŋ kɩ kyaŋ ba nyɩŋa.” ");
INSERT INTO sig_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Ma gyɩŋ wɩya no buloŋ memii rɛ?” Ɛɛ rɛ ba baa, “Waa.” ");
INSERT INTO sig_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩɩ no daga anɩɩ nal hʋ buloŋ aa gʋnnɩ Wɩɩsɩ teŋ weliŋ a ko yaa ŋ hatɩnnɩ aŋ yaa siri dɩ ʋ gyʋʋ Wɩɩsɩbee koro hʋ tɩyaŋ, ʋ tɩɩna kɩɩ gɛɛ rɛ anɩɩ dɩya tɩɩna aa kuwoni mɩbɩnɩya abee mɩfalɩya ʋ busol tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu aa maga namagɩsɩ no ko teŋ, ʋ sii lɩɩ doŋ ");
INSERT INTO sig_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a mɩɩgɩ kpa mʋ ʋ bee, a kɩ daga nala ba wɩɩkyʋwaldɩya tɩyaŋ. Nala hʋ buloŋ gyɩ aa nɩɩ wɩya hʋ ʋ aa basa, ba nyʋʋsɩ gyɩ fɩyɛla rɛ weliŋ. Ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Lee rɛ baal no na wɩgyʋŋ abee dee no buloŋ a kaŋ kɩ yaa wɩmagɩla no? ");
INSERT INTO sig_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gyosɛfʋ aa yaa kapiŋta biye hʋ daa gɛɛ? Ʋ naa daa yaa Mɛɛrɩ? Gyemsi abee Gyosɛfʋ abee Siimɔŋ abee Gyudasɩ daa yaa ʋ naabalɩya? ");
INSERT INTO sig_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Á bee ʋ naatoliye buloŋ daa we daha nyɛ? Lee tɩyaŋ nɛ ʋ yaŋ na wɩya no buloŋ?” ");
INSERT INTO sig_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɛɛ rɛ ba bɩ laa ʋ wɩya di. Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩɩsɩ tɩŋdaal kɛ buloŋ, ba aa kɩ tɩya ʋ gyɩrɩma rɛ weliŋ lee buloŋ tɩyaŋ, amɛ ʋ bee nala abee ʋ dɩya nala kɛ sɩɩ aa bee su ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Akuu ba aa bɩ laa ʋ di wɩya, ʋ gyɩ bɩ yaa wɩmagɩla yʋga doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saŋa no tɩyaŋ nɛ Hɛrɔtɩ, nal hʋ aa deŋ Galili paalʋʋ, gyɩ nɩɩ Yesu wɩya. ");
INSERT INTO sig_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ɛɛ rɛ ʋ basɩ tɩya ʋ tʋŋtʋnna a baa, “Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ rɛ mɩɩgɩ sii sʋʋ tɩyaŋ gɛɛ. Ɛɛ rɛ tɩŋ ʋ kaŋ dee a wuwo kɩ yaa wɩmagɩla no.” ");
INSERT INTO sig_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Wɩɩ hʋ aa tɩŋ Hɛrɔtɩ, paalʋʋ hʋ didenni hʋ gyɩ basɩ nyɛ rɛ yaa, ʋ gyɩ laa sɩya leŋ ba kaŋ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ we kyɔrʋmɔ rɛ, a kpa ʋ we nɩtɔdɩya tɩyaŋ, akuu Hɛrɔtɩ aa gʋl kaŋ ʋ maana Fɩlɩpɩ haaŋ Hɛrodiya fasɩ wɩya. Ɛɛ rɛ Gyɔɔŋ gyɩ aa basɩ tɩya ʋ a baa, “Ʋ bɩ yaa ŋmanɩɩ dɩ ɩ kaŋ ɩ naabiye haaŋ fasɩ.” ");
INSERT INTO sig_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nyɛ rɛ kuwori Hɛrɔtɩ gyɩ fa kɩ kyɛ dɩ ʋ kpʋ Gyɔɔŋ, amɛ ʋ gyɩ aa fá Gyuuma hʋ rɛ, beewɩya Gyuuma hʋ kɛ lee Gyɔɔŋ gyɩ yaa Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɛɛ rɛ kuwori Hɛrɔtɩ kyɛlʋlɩɩ kyɛɛ gyɩ ko pele. Nala yʋga gyɩ ko dɩ ba gbɩyalɩ tɩya ʋ. Doŋ nɛ Hɛrodiya toluu gyɩ ko gyʋʋ gʋwa ba buloŋ sɩya tɩyaŋ, kuwori Hɛrɔtɩ teŋ gyɩ fɩyɛlɩ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ɛɛ rɛ kuwori Hɛrɔtɩ gyɩ wee nyʋwa aŋ ŋmɩyɛsɩ dɔbɔ a tɩya haŋtolibiye hʋ a baa, “Wɩɩ hʋ kɛ buloŋ ɩ aa kyɛɛ, ŋ sɩ yaa tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɛɛ rɛ haŋtolibiye hʋ mʋ basɩ wɩɩ no tɩya ʋ naa aŋ pɩyɛsɩ ʋ a baa, “Wɩbee rɛ ŋ sɩ leŋ ʋ yaa tɩya ŋ?” Ɛɛ rɛ ʋ naa basɩ tɩya ʋ dɩ ʋ baa ʋ aa kyɛ dɩ ʋ kpa Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ nyuu rɛ a we parɩtɩ tɩyaŋ, a tɩya ʋ. Ɛɛ rɛ haŋtolibiye hʋ mʋ basɩ gɛɛ tɩɩ tɩya kuwori Hɛrɔtɩ. ");
INSERT INTO sig_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuwori Hɛrɔtɩ gyɩ aa nɩɩ wɩɩ no, ʋ tɩya gyɩ kyogo rɛ kɩŋkaŋ. Amɛ akuu ʋ aa ŋmɩyɛsa nala hʋ buloŋ sɩya tɩyaŋ wɩya, ʋ tɩya ŋmanɩɩ dɩ ba yaa haŋtolibiye hʋ wɩkyɛɛlɩɩ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Doŋ nɛ ʋ leŋ ba mʋ keri Gyɔɔŋ nyuu nɩtɔdɩya hʋ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","a we parɩtɩ tɩyaŋ a kaŋ ko tɩya haŋtolibiye hʋ. Ɛɛ rɛ ʋ laa a kaŋ mʋ tɩya ʋ naa. ");
INSERT INTO sig_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gyɔɔŋ hatɩnna hʋ gyɩ aa ko nɩɩ wɩɩ no, ba sii ko laa Gyɔɔŋ a kaŋ mʋ hogo, aŋ mʋ basɩ wɩɩ hʋ aa yaa a tɩya Yesu. ");
INSERT INTO sig_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu gyɩ aa nɩɩ Gyɔɔŋ wɩya, ɛɛ rɛ ʋ sii doŋ a kpa mʋ gyʋʋ nɩɩduworiboro a mʋ lee hʋ nala aa tuwo. Amɛ nala gyɩ aa nɩɩ ʋ wɩya, nɩgyamaa gyɩ sii lɩɩ ba beye, a kɩ kile ʋ lugo abee naasɩ. ");
INSERT INTO sig_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu aa ko lɩɩ nɩɩduworiboro hʋ tɩyaŋ, a na nɩgyamaa hʋ aa hɔŋ kɩ gyegili ʋ, ba sikii kana ʋ. Ɛɛ rɛ ʋ tɩɩbɩ nala hʋ aa wɩɩlɩ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ʋ dɩdaana aa ko pele, ʋ hatɩnna hʋ ko basɩ tɩya ʋ a baa, “Lee bile rɛ, ka lee no mɛ yaa pogo. Ɛɛ wɩya ta nala hʋ dɩ ba mʋ tɔnɩ hʋ aa kpaga daha a yɔbɔ kɩdiiliye di.” ");
INSERT INTO sig_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɛɛ rɛ Yesu baa, “Nala no bɩ maga dɩ ba mʋ lee buloŋ. Ma tɩɩ mʋ kyɛ kɩdiiliye tɩya ba dɩ ba di.” ");
INSERT INTO sig_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɛɛ rɛ ʋ hatɩnna hʋ baa, “Kɩŋ buloŋ á aa kana daha rɛ yaa paanʋʋ gama bɔnɔŋ abee fuwonamɩɩsɩ balɩya.” ");
INSERT INTO sig_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ɛɛ rɛ Yesu baa, “Ma kaŋ ko tɩya ŋ.” ");
INSERT INTO sig_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aŋ leŋ nala hʋ buloŋ tuu hɔŋ hɔŋ ɔhɔ hʋ tɩyaŋ. Ɛɛ rɛ ka ʋ laa paanʋʋ gama hʋ bɔnɔŋ abee fuwonamɩɩsɩ hʋ balɩya, a wil deŋ wɩɩsɩnyuu a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kaŋ lɔgɔ lɔgɔ, a kpa tɩya ʋ hatɩnna hʋ, ba laa kpaa nala hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nal nal buloŋ nɛ gyɩ kyaŋ vɔgɔ, ka ʋ hatɩnna hʋ ha gyɩ paa kɩkaalɩya hʋ a su simbiisi fi abee balɩya. ");
INSERT INTO sig_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nala hʋ gyɩ aa kyaŋ paanʋʋ no, ba tɩyaŋ baala dʋŋ gyɩ yaa tusi bɔnɔŋ nɛ, dɩ biibiisi abee haana noŋ tuwo. ");
INSERT INTO sig_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɛɛ rɛ ka Yesu leŋ ʋ hatɩnna hʋ laa sɩya mʋ gyʋʋ nɩɩduworiboro dɩ ba duwori kyol fuwo hʋ kyolo, aŋka ʋ mɛ ta nɩgyamaa hʋ ba mʋ. ");
INSERT INTO sig_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ʋ aa taa nɩgyamaa hʋ buloŋ ba mʋ ko teŋ, ɛɛ rɛ ʋ mʋ gyɩŋ dogimo kɩdɩgɩ nyuu dɩ ʋ kyʋwalɩ Wɩɩsɩ. Ʋ dɩdaana mʋ pele ka ʋ dʋŋ ha we dogimo hʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Saŋa no tɩyaŋ dɩ nɩɩduworiboro hʋ mɛ pele nɩɩ hʋ tʋtʋʋ. Nɩɩpuwo kaŋ boro hʋ kɩ viisi, beewɩya ba fa kyaasɩ puwo hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ʋ sɩgballɩnyʋwa, anɩɩ kerifi boto bee kerifi badʋ paga tɩyaŋ gɛɛ, Yesu sii vala nɩɩ hʋ nyuu a kɩ mʋ ʋ hatɩnna hʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba aa naa ʋ dɩ ʋ aa vala nɩɩ nyuu tɩyaŋ gɛɛ, ba kɛ bɩɩna anɩɩ nɩdʋma rɛ. Kambɩŋ kaŋ ba, ba ŋmaa kyiyesuu. ");
INSERT INTO sig_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɛɛ rɛ Yesu piliŋsi basɩ tɩya ba a baa, “Ma kaŋ ma tɩɩ! Mɩyaŋ nɛ. Ma ta leŋ dɩ kambɩŋ kaŋ ma.” ");
INSERT INTO sig_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ɛɛ rɛ Piita baa, “Ŋ Tɩɩna, dɩ ɩ rɛ kɔnɩ, leŋ dɩ ŋ sii val nɩɩ hʋ nyuu tɩyaŋ a ko ɩ lee.” ");
INSERT INTO sig_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ɛɛ rɛ Yesu baa, “Sii kɩ ko.” Ʋ aa basɩ gɛɛ, Piita sii lɩɩ nɩɩduworiboro hʋ tɩyaŋ a vala nɩɩ hʋ nyuu tɩyaŋ a kɩ mʋ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amɛ Piita aa naa nɩɩpuwo hʋ, kambɩŋ kana ʋ. Ʋ piili kɩ tuu nɩɩmemii. Ɛɛ rɛ ʋ kyiyesi baŋbaŋ a baa, “Ŋ Tɩɩna, laa ŋ.” ");
INSERT INTO sig_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɛɛ rɛ Yesu tarɩsɩ mʋ kana ʋ aŋ basɩ tɩya ʋ a baa, “Bee rɛ tɩŋ ɩ kɩ yaa ŋ sige, ɩ laadii bɩ yʋga?” ");
INSERT INTO sig_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nyɛ rɛ ba buloŋ mʋ gyʋʋ nɩɩduworiboro hʋ. Doŋ nɛ puwo hʋ mɛ sige. ");
INSERT INTO sig_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ʋ hatɩnna hʋ buloŋ aa we nɩɩduworiboro hʋ tɩyaŋ tuu gbinni a kyʋwalɩ ʋ a kpa ʋ gyɩrɩma tɩya ʋ aŋ baa, “Wɩtɩɩ, ɩ rɛ kɔnɩ yaa Wɩɩsɩ Biye hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɛɛ rɛ ba kyol fuwo hʋ a ko pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Gɛnɛsarɛti. ");
INSERT INTO sig_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɛɛ rɛ nala hʋ aa we doŋ wuwo gyɩŋ bee baa Yesu rɛ, a leŋ ʋ duwoso pel tɔnɩ hʋ buloŋ aa we doŋ. Nyɛ rɛ ba mʋ paa ba wɩɩla tɩmma buloŋ aa we tɔnɩ hʋ aa kpaga Gɛnɛsarɛti a kaŋ ko Yesu lee, ");
INSERT INTO sig_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aŋ sʋla ʋ dɩ ʋ kɛ haa leŋ dɩ nala hʋ buloŋ aa wɩɩlɩ dige ʋ gal nyʋwa. Nala hʋ buloŋ gyɩ aa dige ʋ gal nyʋwa, ba buloŋ nɛ gyɩ naa laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɛɛ rɛ Farasiima badɔmɔŋ abee Wɩɩsɩ Teŋ dɩdagɩla sii lɩɩ Gyerusalɛm a ko Yesu lee a pɩyɛsɩ ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bee rɛ tɩŋ ɩ hatɩnna kɩ kyogi á naabaala sɩŋsɩ? Ba aa bee sɔŋ ba nosi anɩɩ gɛɛ hʋ á naabaala aa daga ma aŋ kɩ di kɩdiiliye.” ");
INSERT INTO sig_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Doŋ nɛ Yesu pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɛ aa kuu ma lesiri wɩya a vɩya Wɩɩsɩ nyʋwa tɩŋɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wɩɩsɩ baa dɩ ma kɩ tɩya ma kuwoma abee ma nɩmma gyɩrɩma, a bɩl baa dɩ dɩ nal lɛ kaaba tɩya ʋ kuwo koo ʋ naa, ʋ maga dɩ ba kpʋ ʋ tɩɩna rɛ. ");
INSERT INTO sig_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amɛ ma kɛ aa daga nala anɩɩ dɩ nal lɛ kaŋ kɩŋ a maga dɩ ʋ kpa kyiyeli ʋ kuwo koo ʋ naa, ka dɩ ʋ tɩɩna basɩ tɩya ba anɩɩ kɩŋ hʋ ʋ fa a sɩ kpa kyiyeli ba hʋ yaa Wɩɩsɩ kɩŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dɩ ɛɛwɩya ʋ bɩl bɩ maga dɩ ʋ kpa kɩŋ hʋ tɩya ba. Ʋ tɩɩna bɩl bee tɩya ʋ naa bee ʋ kuwo gyɩrɩma rɛ gɛɛ. Ɛɛ yaŋ daga anɩɩ ma kuu ma naabaala sɩŋsɩ wɩya rɛ, a vɩya wɩɩ hʋ Wɩɩsɩ aa baa ma yaa ta. ");
INSERT INTO sig_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma yaa minaafigi tɩmma rɛ! Wɩɩsɩ tɩŋdaal Azaaya wɩya gyɩ sʋma rɛ ʋ gyɩ aa basɩ ma wɩya a baa, ");
INSERT INTO sig_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Wɩɩsɩ baa, nyʋwa dʋŋ nɛ nala no kaŋ kɩ tɩya ŋ gyɩrɩma, Amɛ ba tɩsɩ kɛ bɩ kpaga ŋ. ");
INSERT INTO sig_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba aa kyʋwalɩ ŋ waasʋ rɛ, beewɩya ba vɩya ŋ nyʋwa rɛ aŋ kɩ daga nala mɩrɩsɩ hʋ ba tɩɩ aa bine, aŋ aa fugo baa dɩ mɩyaŋ Wɩɩsɩ mɩrɩsɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ɛɛ rɛ Yesu yɩrɩ nɩgyamaa hʋ ba ko ʋ lee. Ʋ basɩ tɩya ba a baa, “Ma gyegili nɩɩ daha a wuwo gyɩŋ wɩya no memii weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nal kɩdiiliye bɩ sɩ wuwo leŋ dɩ ʋ yaa bisiŋ tɩɩna. Kɩŋ kɛ buloŋ aa tuu nal fuu, ʋ bɩ sɩ wuwo leŋ tɩɩna kaŋ bisiŋ. Amɛ wɩya hʋ aa lɩɩ ʋ tɩɩna nyʋwa tɩyaŋ nɛ sɩ wuwo leŋ ʋ yaa bisiŋ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɛɛ rɛ ʋ hatɩnna hʋ ko ʋ lee a basɩ tɩya ʋ a baa, “Ɩ gyɩma anɩɩ ɩ aa basɩ gɛɛ Farasiima hʋ tɩya kyogo rɛ?” ");
INSERT INTO sig_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Tɩya hʋ buloŋ ŋ Kuwo aa we wɩɩsɩbee tɩyaŋ aa bɩ pɔɔ, ba sɩ kyuri ʋ ta. ");
INSERT INTO sig_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma ta leŋ dɩ ba wɩya kɩ dɔŋ ma, beewɩya ba yaa nyʋlɩma rɛ aŋ kɩ kaŋ nyʋlɩma daatɩgɩya. Dɩ nyʋlʋŋ nɛ yaŋ kaŋ ʋ dɔŋtɩɩna nyʋlʋŋ daaŋ tɩyaŋ, ba buloŋ balɩya sɩ tele bootogi tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ɛɛ rɛ Piita baa, “Daga ma namaga no ɩ aa maga tɩya Farasiima hʋ memii.” ");
INSERT INTO sig_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɛɛ rɛ Yesu baa, “Ɛɛ kɛ ma mɛ buloŋ nɛ yaŋ gɛɛ? ");
INSERT INTO sig_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma bɩ gyɩŋ wɩɩ no memii? Kɩŋ kɛ buloŋ aa tɩŋ nal nyʋwa gyʋʋ, ʋ aa tuu ʋ fuu rɛ, a tɩŋ ʋ memii lɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amɛ wɩya hʋ aa tɩŋ ɩ nyʋwa lɩɩ, ba aa lɩɩ ɩ tɩya tɩyaŋ nɛ. Wɩya no rɛ aa leŋ nal kaŋ bisiŋ. ");
INSERT INTO sig_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ɩ tɩya tɩyaŋ nɛ ɩ aa bɩɩnɩ wɩbɔmɔ yayɩ, ɛɛ leŋ ɩ wuwo mʋ kpʋ nal, koo a mʋ kyɛ nal haaŋ, a kɩ gaa koo a kɩ sɔnnɩ, koo a nyɩya wɩya kɩ tɩya nala, koo a kɩ kyogi nala fene. ");
INSERT INTO sig_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wɩya no rɛ aa leŋ nal kaŋ bisiŋ. Amɛ dɩ nal bɩ sɔmɔ ʋ noŋ aŋ di kɩna anɩɩ ma naabaala a daga gɛɛ, ɛɛ bɩ sɩ wuwo leŋ dɩ ʋ tɩɩna kaŋ bisiŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɛɛ rɛ Yesu sii lɩɩ doŋ a mʋ Taaya abee Siidɔŋ paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nyɛ rɛ Keenaŋ tɩmma haaŋ kɩdɩgɩ fa aa we doŋ sii ko Yesu lee, a basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, Deviti nihii, fá ŋ sikii. Gyɩŋbɔŋ nɛ kaŋ ŋ toluu, ʋ kɩ na tʋwara kɩŋkaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amɛ Yesu gyɩ bɩ basɩ wɩɩ buloŋ tɩya ʋ. Ɛɛ rɛ ka ʋ hatɩnna hʋ ko sʋla ʋ a baa, “Leŋ dɩ haaŋ hʋ mʋ, beewɩya ʋ kaŋ kyagɩŋsɩ kɩ tɩŋ á hal lɛ.” ");
INSERT INTO sig_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩɩsɩ tɩma ŋ nɛ dɩ ŋ ko kyɛ kasɩ nala hʋ aa kɩɩ gɛɛ anɩɩ penyʋgɩsɩya Iziral tɩmma dʋŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nyɛ rɛ haaŋ hʋ ko tele Yesu naasɩ tɩyaŋ aŋ baa, “Ŋ Tɩɩna, pɛ ŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ʋ bɩ yaa ŋmanɩɩ dɩ ɩ kpa biisi kɩdiiliye a tɩya vasɩ.” ");
INSERT INTO sig_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nyɛ rɛ haaŋ hʋ baa, “Ŋ Tɩɩna, wɩtɩɩ rɛ ɩ basɩ, amɛ dɩ vasɩ hʋ tɩmma rɛ aa di kɩna, kɩna hʋ aa tele taŋha rɛ vasɩ hʋ mɛ aa paa kɩ di.” ");
INSERT INTO sig_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɛɛ rɛ Yesu basɩ tɩya haaŋ hʋ a baa, “Ɩ laadii kɔnɩ yʋga rɛ. Wɩɩ hʋ ɩ aa kyɛɛ, ŋ sɩ yaa tɩya ɩ.” Saŋa no tɩɩ tɩyaŋ nɛ haaŋ hʋ toluu hʋ na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɛɛ rɛ Yesu bɩl sii doŋ a kpa tɩŋ Galili fuwo hʋ dɩɩlaŋ kɩ mʋ, a mʋ gyɩŋ hɔŋ dogimo kɩdɩgɩ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɛɛ rɛ nɩgyamaa sii paa gbarɩga abee nyʋlɩma abee ganɩya abee nala aa kaŋ wɩɩla iriŋ buloŋ a ko biŋ Yesu sɩya tɩyaŋ. Ʋ tɩɩbɩ ba. ");
INSERT INTO sig_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɩgyamaa hʋ aa naa dɩ ganɩya hʋ aa basɩ wɩya, gbarɩga kɩ vala, ka nyʋlɩma sɩya mɛ suri gɛɛ, ʋ yaa ba wɩkperii, ba dannɩ Iziral tɩmma Wɩɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɛɛ rɛ Yesu yɩrɩ ʋ hatɩnna hʋ a basɩ tɩya ba a baa, “Ŋ aa naa nala no, sikii kana ŋ nɛ. Ba kyɛyɛ boto rɛ nyɛ ba aa we ŋ lee aŋ bɩ naa kɩdiiliye di. Ŋ bee kyɛ dɩ ŋ ta ba abee losi. Dɩ mɩyaŋ nɛ yaa gɛɛ, ba sɩ ko mʋ yiyegi ŋmanɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɛɛ rɛ ʋ hatɩnna hʋ pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ á sɩ yaa a na kɩdiiliye pogo no tɩyaŋ a tɩya nɩgyamaa no buloŋ dɩ ba di.” ");
INSERT INTO sig_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Paanʋʋ gama baŋmɛ rɛ ma kana?” Ba baa, “Kɩna bapɛ rɛ abee fuwonamɩɩsɩ baŋmana.” ");
INSERT INTO sig_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɛɛ rɛ Yesu leŋ nala hʋ buloŋ tuu hɔŋ taŋha. ");
INSERT INTO sig_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka ʋ kpa paanʋʋ gama hʋ bapɛ abee fuwonamɩɩsɩ hʋ a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kaŋ lɔgɔ lɔgɔ, a tɩya ʋ hatɩnna hʋ ba laa kpaa nɩgyamaa hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba buloŋ di a vɔgɔ, ka Yesu hatɩnna hʋ ha paa kɩkaalɩya hʋ a su simbiisi bapɛ. ");
INSERT INTO sig_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nala hʋ gyɩ aa dii kɩna hʋ, ba tɩyaŋ baala dʋŋ gyɩ yaa tusi banaa rɛ, dɩ haana bee biibiisi noŋ tuwo. ");
INSERT INTO sig_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɛɛ rɛ Yesu ta nɩgyamaa hʋ aŋ mʋ gyʋʋ nɩɩduworiboro, a kpa mʋ Magadaŋ paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɛɛ rɛ Farasiima abee Sadusiima badɔmɔŋ ko Yesu lee a kɩ kyɛ dɩ ba magɩsɩ ʋ. Nyɛ rɛ ba basɩ tɩya ʋ dɩ ʋ yaa wɩmagɩl dɩ ba na a gyɩma anɩɩ ʋ dee hʋ kɔnɩ lɩɩ Wɩɩsɩ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ Wɩɩsɩ ko kɩ gyʋʋ, dɩ wɩɩsɩnyuu fɩyɛsɩ, na ma aa baa dɩ nyɛ kɛ lee hʋ pollo rɛ? ");
INSERT INTO sig_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kyɩkyʋwala mɛ, dɩ wɩɩsɩnyuu rɛ ko kɩɩ gyununu, na ma aa baa dɩ duwoŋ sɩ nɩɩ gyɩnaŋ. Dɩ mamaa rɛ aa sɩ wuwo deŋ wɩɩsɩnyuu a gyɩŋ wɩɩ hʋ aa sɩ yaa, bee rɛ tɩŋ ma bɩ sɩ wuwo gyɩŋ wɩɩ hʋ aa yaa dʋnɩya no tɩyaŋ lagɩlagɩ no. ");
INSERT INTO sig_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ma gyɩnaŋ nala yaa nɩbɔmɔ rɛ, a bee fá Wɩɩsɩ mɛ, aŋ baa dɩ ŋ yaa wɩmagɩl. Aayɩ, ŋ bee yaa gɛɛ. Wɩmagɩl hʋ buloŋ ma aa sɩ na rɛ yaa wɩmagɩl hʋ Wɩɩsɩ aa yaa ʋ tɩŋdaal Gyoona tɩyaŋ.” Ɛɛ rɛ Yesu leŋ ba doŋ aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu hatɩnna hʋ gyɩ aa gyʋʋ nɩɩduworiboro hʋ, a duwori kyol fuwo hʋ kyolo gɛɛ, ba gyɩ yeŋŋi rɛ a bɩ kaŋ paanʋʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma pɔ ma tɩɩma weliŋ a kɩ gyɩŋ Farasiima bee Sadusiima sɩbʋl hʋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɛɛ rɛ ba piili basɩ kɩ tɩya dɔmɔŋ a baa, “Á aa bɩ kaŋ paanʋʋ ko hʋ nɛ tɩŋ ʋ basɩ wɩɩ no.” ");
INSERT INTO sig_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ɛɛ rɛ Yesu gyɩŋ wɩɩ hʋ ba aa basɩ, a basɩ tɩya ba a baa, “Ma Wɩɩsɩ laadii bɩ yʋga! Bee rɛ tɩŋ ma hɔŋ kɩ vʋʋlɩ anɩɩ ma bɩ kaŋ paanʋʋ? ");
INSERT INTO sig_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɛɛ kɛ ma ha bɩ gyɩŋ nal hʋ iriŋ ŋ aa yaa? Ma bɩ liise mʋ parɩ saŋa hʋ ŋ gyɩ aa kpaa paanʋʋ gama bɔnɔŋ a kaŋ lɔgɔ lɔgɔ a tɩya nala tusi bɔnɔŋ ba dɩ a vɔgɔ hʋ? Ba gyɩ aa dii vɔgɔ aŋ ka kɩna hʋ, simbiisi baŋmɛ rɛ ma gyɩ paa su? ");
INSERT INTO sig_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aŋka paanʋʋ gama bapɛ hʋ mɛ ŋ gyɩ aa kaŋ lɔgɔ lɔgɔ tɩya nala tusi banaa hʋ? Simbiisi baŋmɛ rɛ ma gyɩ paa ba kɩkaalɩya hʋ mɛ su? ");
INSERT INTO sig_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɛɛ kɛ ma bɩ gyɩma anɩɩ kɩdiiliye wɩya daa ŋ kɩ basɩ ma lee? Ma kɩ gyɩŋ Farasiima bee Sadusiima sɩbʋl hʋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɛɛ rɛ ʋ hatɩnna hʋ gyɩma anɩɩ ʋ bɩ baa dɩ ba pɔ ba tɩɩ abee sɩbʋl hʋ ba aa kpa we paanʋʋ tɩyaŋ, amɛ ʋ baa dɩ ba pɔ ba tɩɩma rɛ abee Farasiima bee Sadusiima wɩdagɩya tɩyaŋ. Beewɩya nala no wɩdagɩya kɩɩ gɛɛ rɛ anɩɩ sɩbʋl. ");
INSERT INTO sig_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɛɛ rɛ Yesu sii mʋ Sizaariya Filipi paalʋʋ. Doŋ nɛ ʋ pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Kɩbee rɛ nala baa dɩ mɩyaŋ Nihuwobiŋ Biye yaa?” ");
INSERT INTO sig_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɛɛ rɛ ba baa, “Badɔmɔŋ baa dɩ ɩ rɛ yaa Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ. Badɔmɔŋ mɛ baa dɩ ɩ rɛ yaa Ɛlaagya. Ka badɔmɔŋ mɛ baa dɩ ɩ rɛ yaa Gyɛrimaya, koo faafaa Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ʋ hatɩnna hʋ mɛ a baa, “Ka ma mɛ, aŋnɛ rɛ ma baa ŋ yaa?” ");
INSERT INTO sig_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ɛɛ rɛ Siimɔŋ Piita baa, “Ɩ rɛ yaa Krisita hʋ, Wɩɩsɩ hʋ aa weye biye.” ");
INSERT INTO sig_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɛɛ rɛ Yesu baa, “Siimɔŋ, Gyɔɔŋ biibaal, nyusʋŋtɩɩna rɛ yaa ɩ, beewɩya wɩgyʋŋ no ɩ aa kaŋ lɩɩ wɩɩ no sɩɩ, nihuwobiŋ daa tɩya ɩ. Ŋ Kuwo aa we wɩɩsɩbee tɩyaŋ nɛ tɩya ɩ. ");
INSERT INTO sig_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɛɛ wɩya Piita, ŋ basɩ tɩya ɩ rɛ anɩɩ ɩ feŋ hʋ memii rɛ yaa bʋyɩ, bʋyɩ no tɩyaŋ nɛ ŋ sɩ kaŋ nala hʋ buloŋ aa laa ŋ wɩya di ko laŋŋɩ. Sʋʋ mɛ gba bɩ sɩ wuwo yige nala no lo. ");
INSERT INTO sig_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ŋ sɩ kpa Wɩɩsɩbee koro hʋ saafɩɩbiye tɩya ɩ. Wɩɩ hʋ ɩ aa sɩŋ dʋnɩya no tɩyaŋ, ʋ rɛ Wɩɩsɩ mɛ kɩ sɩna, wɩɩ hʋ mɛ ɩ aa sɩ laa dʋnɩya no tɩyaŋ, ʋ rɛ Wɩɩsɩ mɛ sɩ laa” ");
INSERT INTO sig_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ abee sɩfɩyasɩ dɩ ba ta basɩ tɩya nal buloŋ anɩɩ ʋ rɛ yaa Krisita hʋ, Laataal hʋ Wɩɩsɩ aa lɩya. ");
INSERT INTO sig_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A piili haŋ saŋa hʋ tɩyaŋ Yesu aa basɩ wɩya polli kɩ tɩya ʋ hatɩnna hʋ rɛ a baa, “Ʋ maga dɩ ŋ mʋ Gyerusalɛm nɛ a na tʋwara weliŋ Gyuuma nɩhɩyasɩ abee ba wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla nosi tɩyaŋ. Ba sɩ kpʋ ŋ, amɛ Wɩɩsɩ sɩ kyisi ŋ sʋʋ tɩyaŋ kyɛyɛ boto kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɛɛ rɛ Piita kana ʋ fasɩ lɩɩ saŋkala, a basɩ tɩya ʋ a baa “Ta basɩ gɛɛ! Ŋ Tɩɩna Wɩɩsɩ ta laa nyʋwa dɩ wɩɩ no maakyiye yaa ɩ.” ");
INSERT INTO sig_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ɛɛ rɛ Yesu bɩrɩmɩ kyaasɩ Piita aŋ basɩ tɩya ʋ baa, “Fasɩ mʋ ŋ sɩya tɩyaŋ. Sɩtaanɩ wɩya rɛ ɩ kɩ basɩ gɛɛ. Ɩ aa kyɛ dɩ ɩ mʋrɩ ŋ dɩ ŋ vɩya ŋ kuwo nyʋwa rɛ. Beewɩya nihuwobiŋ tɩliise rɛ ɩ kana ɩ bɩ kaŋ Wɩɩsɩ tɩliise.” ");
INSERT INTO sig_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Dɩ nal buloŋ nɛ aa kyɛ dɩ ʋ tɩŋa ŋ, see dɩ ʋ vɩya ʋ tɩɩ ŋmanɩɩ ta aŋ kpa ʋ daagarɩɩ baasɩ a kɩ tɩŋa ŋ hal. ");
INSERT INTO sig_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nal hʋ buloŋ aa kyɛ dɩ ʋ laa ʋ tɩɩ mɩɩbol, ʋ tɩɩna bɩ sɩ na ʋ mɩɩbol. Amɛ nal hʋ mɛ aa kuu ŋ wɩya a vɩya ʋ mɩɩbol ta ʋ tɩɩna sɩ na mɩɩbol aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dɩ ɩ rɛ tɩŋ dʋnɩya no kɩŋ buloŋ, aŋ bɩ sɩ na mɩɩbol hʋ aa bɩ kaŋ tenii, bekiŋ tɔnɔ rɛ ɩ na? Dʋnɩya no tɩyaŋ, bekiŋ nɛ ɩ sɩ wuwo kpa lenni laa ɩ mɩɩbol? ");
INSERT INTO sig_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ŋ basɩ nyɛ kɩ tɩya ma rɛ beewɩya, mɩyaŋ Nihuwobiŋ Biye sɩ mɩɩgɩ ko abee ŋ kuwo gaŋdarɩ. Ŋ bee malɩkasɩ rɛ sɩ ko. Dɩ ámaa rɛ ko ko, ŋ sɩ tuŋ nal buloŋ a maga gɛɛ hʋ ʋ tɩɩna aa tʋma. ");
INSERT INTO sig_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nala badɔmɔŋ we ma tɩyaŋ daha, ba bɩ sɩ sʋba see dɩ ba na mɩyaŋ Nihuwobiŋ Biye ko di dʋnɩya buloŋ koro.” ");
INSERT INTO sig_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ʋ kyɛyɛ badʋ hal tɩyaŋ, Yesu kaŋ Piita abee Gyemsi bee ʋ naabiye Gyɔɔŋ, a mʋ gyɩŋ dogiŋbal kɩdɩgɩ nyuu ba dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba ko baa dɩ ba deŋ, dɩ ba naa Yesu bɩrɩma, ʋ sɩya buloŋ kɩ tʋla gɛɛ anɩɩ wɩɩpɔsɩɩ aŋka ʋ gannɩ mɛ pʋllɩ gɛɛ peretete a kɩ tʋla. ");
INSERT INTO sig_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Haŋ lagɩlagɩ hʋ dɩ ba naa Moosi abee Ɛlaagya dɩ ba bee Yesu sɩŋ kɩ basɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Á Tɩɩna, ʋ yaa wɩwelii rɛ anɩɩ á aa we daha. Dɩ ɩ rɛ aa kyɛ, ŋ sɩ we gyama boto daha, dɩ ɩ tɩŋ kɩdɩgɩ, dɩ Moosi mɛ tɩŋ kɩdɩgɩ, ka dɩ Ɛlaagya mɛ tɩŋ kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piita ha fa aa basɩ wɩya hʋ gɛɛ dɩ taal tʋlɩɩ kɩdɩgɩ ko tuu tɔ ba, ka taal lɩɩ taal tʋlɩɩ hʋ tɩyaŋ a baa, “Ŋ Biikyoolii rɛ nyɛ. Ŋ teŋ fɩyɛla rɛ ʋ tɩyaŋ. Ma gyegili kɩ nɩɩ ʋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesu hatɩnna hʋ aa nɩɩ taal hʋ gɛɛ, kambɩŋ kaŋ ba, ba tuu tele kyige taŋha. ");
INSERT INTO sig_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ɛɛ rɛ Yesu ko ba lee a dige ba aŋ basɩ tɩya ba a baa, “Ma sii, ma ta leŋ kambɩŋ kaŋ ma.” ");
INSERT INTO sig_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba aa siye, ba deŋ lee buloŋ, ka ba bɩ naa nal buloŋ, see Yesu dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba aa lɩɩ dogimo hʋ nyuu ko kɩ tuu, Yesu basɩ tɩya ba a baa, “Ma ta ko basɩ wɩɩ no ma aa naa gyɩnaŋ a kɩ tɩya nal buloŋ a mʋ pele kyɛɛ hʋ Wɩɩsɩ aa sɩ kyisi mɩyaŋ Nihuwobiŋ Biye sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɛɛ rɛ Yesu hatɩnna hʋ pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ Wɩɩsɩ Teŋ dɩdagɩla hʋ baa dɩ Ɛlaagya rɛ sɩ laa sɩya ko, ka dɩ Krisita, laataal hʋ Wɩɩsɩ aa lɩya na ko?” ");
INSERT INTO sig_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɛɛ rɛ Yesu baa, “Wɩtɩɩ rɛ, Ɛlaagya rɛ kɔnɩ sɩ laa sɩya ko, a kaŋ kɩŋ buloŋ marɩ biŋ. ");
INSERT INTO sig_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amɛ ŋ basɩ kɩ tɩya ma rɛ anɩɩ Ɛlaagya paalɩ ko rɛ, aŋka nala bɩ wuwo gyɩma ʋ, aŋ kana ʋ yaa gɛɛ ba aa kyɛ. Ɛɛ tɩɩ rɛ ba yaŋ sɩ dɔgɩsɩ mɩyaŋ Nihuwobiŋ Biye mɛ.” ");
INSERT INTO sig_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɛɛ rɛ ʋ hatɩnna hʋ gyɩma anɩɩ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ wɩya rɛ ʋ basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ boto sii mɩɩgɩ ko nɩgyamaa hʋ lee. Doŋ nɛ baal kɩdɩgɩ gyɩ ko Yesu lee a tuu gbinni ʋ sɩya tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","aŋ basɩ tɩya ʋ baa, “Ŋ nɩhɩyawʋ, fá ŋ biibaal sikii, ʋ aa tele kpuŋkpuŋsi rɛ. Wɩɩl hʋ gyʋʋ ʋ tɩyaŋ nɛ kɩŋkaŋ, ʋ aa kɩ tele diŋ koo nɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ŋ kana ʋ ko ɩ hatɩnna hʋ lee rɛ, amɛ ba bɩ wuwo tɩɩbɩ ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ɛɛ rɛ Yesu baa, “Ma gyɩnaŋ nala aa bɩ laa Wɩɩsɩ di, ma yaa nɩbɔmɔ rɛ. Abaa! Kyɛyɛ baŋmɛ rɛ ŋ tɩɩ baa ŋ we ma lee?” Doŋ nɛ ka ʋ basɩ tɩya baal hʋ a baa, “Kaŋ biye hʋ ko daha.” ");
INSERT INTO sig_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɛɛ rɛ Yesu nɔsɩ gyɩŋbɔŋ hʋ ʋ lɩɩ biye hʋ tɩyaŋ, ka biye hʋ teŋ pirigi deye. ");
INSERT INTO sig_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nyɛ rɛ Yesu hatɩnna hʋ ko ʋ lee a lʋwɔlɩ pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ á kɛ bɩ wuwo kile gyɩŋbɔŋ hʋ?” ");
INSERT INTO sig_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma Wɩɩsɩ laadii bɩ yʋga, ɛɛ rɛ tɩŋ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ma Wɩɩsɩ laadii rɛ fa yʋga mʋhʋ tɩɩ tʋlɩɩ mɛ gba, ma fa sɩ wuwo basɩ tɩya dogimo no dɩ ʋ sii daha a mʋ lee bee ʋ dɔŋ, dɩ ʋ kɔnɩ sii mʋ. Wɩɩ buloŋ tuwo ma fa aa sɩ yaa lɔlɔ. ");
INSERT INTO sig_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amɛ dɩ nal lɛ sɩ kile gyɩŋtesi no, see dɩ ʋ tɩɩna vʋwa nyʋwa, a kyʋwalɩ Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu hatɩnna hʋ buloŋ aa ko laŋŋɩ Galili tɩyaŋ gɛɛ, ʋ basɩ tɩya ba a baa, “Ba sɩ kpa Mɩyaŋ Nihuwobiŋ Biye a we nala nosi tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","dɩ ba kpʋ ŋ, amɛ ɛɛ hal tɩyaŋ Wɩɩsɩ sɩ kyisi ŋ sʋʋ tɩyaŋ kyɛyɛ boto kyɛɛ.” Yesu aa basɩ gɛɛ, ʋ hatɩnna hʋ tɩsɩ buloŋ kyogi. ");
INSERT INTO sig_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu bee ʋ hatɩnna hʋ aa ko pele Kapɛɛnam, nala hʋ aa laa Wɩɩkyʋwaldɩɩbal hʋ lampoo ko Piita lee a pɩyɛsɩ ʋ a baa, “Ma nɩhɩyawʋ hʋ aa tuŋ Wɩɩkyʋwaldɩɩbal hʋ lampoo rɛ?” ");
INSERT INTO sig_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ɛɛ rɛ Piita baa dɩ ʋ aa tuŋ nɛ. Piita aa basɩ gɛɛ aŋ mɩɩgɩ gyʋʋ dɩya, Yesu laa sɩya pɩyɛsɩ ʋ a baa, “Piita, ɛɛ rɛ ɩ bɩɩnɩ? Kɩbee rɛ aa tuŋ lampoo a kɩ tɩya dʋnɩya no kuworo, tɔɔ hʋ nala tɩɩ koo nɩhʋwala?” ");
INSERT INTO sig_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ɛɛ rɛ Piita baa dɩ nɩhʋwala rɛ. Yesu bɩl baa, “Ɛɛ daga anɩɩ tɔɔ hʋ nala tɩɩ kɛ bee tuŋ kɩŋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amɛ á kɛ bee kyɛ dɩ á yaa wɩɩ buloŋ kyogi ba, ɛɛ wɩya kpa bɩyaŋ a tuu fuwo a lo, laasɩya fuwonamɩya hʋ ɩ aa sɩ lɩɩ kaŋ ʋ nyʋwa suri a tʋʋ lɩɩ molbinʋʋ ʋ nyʋwa tɩyaŋ, a kaŋ molbii hʋ mʋ tuŋ ŋ beel-ɩ buloŋ nyuu lampoo. ");
INSERT INTO sig_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ʋ bɩ pɩɩsa ka Yesu hatɩnna hʋ ko ʋ lee a pɩyɛsɩ ʋ baa, “Kɩbee rɛ yaa nɩbal Wɩɩsɩbee koro hʋ tɩyaŋ?” ");
INSERT INTO sig_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɛɛ rɛ Yesu yɩrɩ biibiye kɩdɩgɩ a leŋ ʋ ko sɩŋ ba sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nyɛ rɛ ʋ basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ma bɩ kaŋ ma tɩɩ bɩrɩmɩ a kɩɩ gɛɛ anɩɩ biibiisi, ma bɩ sɩ maakyiye gyʋʋ wɩɩsɩbee koro hʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nal hʋ aa kaŋ ʋ tɩɩ hʋwɔlɩ anɩɩ biibiye no, ʋ tɩɩna rɛ yaa nɩbal wɩɩsɩbee koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dɩ nal lɛ kuu ŋ wɩya a kaŋ biibiye no dɔŋtɩɩna weliŋ, mɩyaŋ nɛ ʋ tɩɩna kaŋ weliŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dɩ nal lɛ ko leŋ dɩ nala no aa laa ŋ di, anɩɩ biibiisi no kɩdɩgɩ buloŋ ko vɩya ŋ nyʋwa, ba aa kpaa nɔŋ a vʋwa laalɩ ʋ tɩɩna bagɩna tɩyaŋ a kpa ʋ yuwo we nɩɩbɩŋ tɩyaŋ ʋ nyʋwa nɩɩ sʋba, ʋ rɛ sɩ kpɩya ʋ tɩɩna aa weye. ");
INSERT INTO sig_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Akuu wɩya hʋ aa we dʋnɩya no tɩyaŋ aa sɩ wuwo leŋ dɩ dʋnɩya nala yaa wɩbɔmɔ kyogi Wɩɩsɩ nyubaanɩŋ, dʋnɩya nala sɩ na tʋwara kɩŋkaŋ. Wɩya hʋ aa sɩ leŋ dɩ nihuwobiŋ yaa wɩbɔmɔ sɩ ko, amɛ tʋwara sɩ gyʋʋ nal hʋ aa sɩ leŋ dɩ ʋ dɔŋtɩɩna yaa wɩbɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dɩ ɩ noŋ koo ɩ naaŋ nɛ leŋ ɩ yaa wɩbɔŋ, keri ʋ ta. Ɩ aa gyʋʋ wɩɩsɩbee koro hʋ abee nokuu koo naakuu, ʋ rɛ kpɩya ɩ aa sɩ kaŋ nopilime abee naapilime ka dɩ ba kpa ɩ yuwo we diŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dɩ ɩ sɩɩ rɛ leŋ ɩ yaa wɩbɔŋ, lɩɩ ta. Ɩ aa gyʋʋ wɩɩsɩbee koro hʋ abee sɩtogo, ʋ rɛ kpɩya ɩ aa kaŋ sɩya balɩya ka ba kpa ɩ yuwo we diŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ŋ basɩ kɩ tɩya ma rɛ, ma kɩ pɔ dɩ ma ta ko maakyiye deŋ nala no aa tɩŋ Wɩɩsɩ aŋ kaŋ ba tɩɩ hʋwɔlɩ anɩɩ biibiisi no kɩdɩgɩ buloŋ waasʋ. Beewɩya ba malɩkasɩ hʋ aa we wɩɩsɩbee tɩyaŋ aa kaŋ ba wɩya mʋ kɩ biŋ ŋ kuwo sɩya rɛ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Mɩyaŋ Nihuwobiŋ Biye ko dɩ ŋ kyɛ a laa nala hʋ aa nyʋgɩsa rɛ a ta.” ");
INSERT INTO sig_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɛɛ rɛ Yesu maga namaga a baa, “Dɩ nal lɛ kaŋ piyese kɔɔ dɩ kɩdɩgɩ nyʋgɩsɩ, ɛɛ rɛ ma bɩɩnɩ anɩɩ ʋ sɩ yaa? Na ʋ aa leŋ piyese mɔllɩbanaa bee fi abee nibi hʋ rɛ dɩ ʋ ta pogo tɩyaŋ, ka dɩ ʋ gɔllɩ kɩ kyɛ penyʋgɩsɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ʋ rɛ ko mʋ na ʋ, ʋ teŋ sɩ fɩyɛlɩ rɛ weliŋ pedɩgɩ no wɩya a te pekaanɩya hʋ aa bɩ nyʋgɩsa. ");
INSERT INTO sig_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɛɛ tɩɩ rɛ ma kuwo aa we wɩɩsɩbee tɩyaŋ mɛ bee kyɛ dɩ ma nala no aa laa Wɩɩsɩ di aŋ kaŋ ma tɩɩ kɩ hʋwɔlɩ anɩɩ biibiisi kɩdɩgɩ buloŋ nyʋgɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ɛɛ rɛ Yesu baa, “Dɩ ɩ dɔŋtɩɩna krisitabiye rɛ yaa wɩɩ kyogi ɩ, mʋ basɩ wɩɩ hʋ ʋ aa yaa kyogi ɩ tɩya ʋ, amɛ leŋ dɩ ʋ yaa ɩ beel-ʋ dʋŋ wɩgyɩmɩɩ. Dɩ ʋ rɛ ko gyegili nɩɩ wɩɩ hʋ ɩ aa basɩ tɩya ʋ, ɛɛ kɛ ɩ beel-ʋ mɩɩgɩ marɩ dɔmɔŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amɛ dɩ ʋ rɛ ko bɩ gyegili nɩɩ ɩ nyʋwa, kaŋ nal koo nala balɩya a pɛ ɩ tɩɩ tɩyaŋ dɩ ma mʋ ʋ lee a basɩ wɩɩ hʋ ʋ aa yaa kyogi ɩ dɩ ba marɩ ma dɔmɔŋ. Ɩ aa yaa gɛɛ, ɩ sɩ kaŋ nala balɩya koo boto dɩ ba yaa ɩ daŋsɩya tɩmma anɩɩ Wɩɩsɩ teŋ aa daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amɛ dɩ ʋ rɛ ha ko bɩ gyegili nɩɩ ba mɛ nyʋwa, basɩ wɩɩ hʋ tɩya Krisitabiisi hʋ buloŋ. Dɩ ʋ rɛ ha ko bɩl bɩ gyegili nɩɩ ba mɛ nyʋwa, ɛɛ kɛ kpa ʋ tɩɩna anɩɩ nal aa bɩ gyɩŋ Wɩɩsɩ koo wɩbɔŋ yaal. ");
INSERT INTO sig_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, wɩɩ hʋ ma aa sɩŋ dʋnɩya no tɩyaŋ, ʋ rɛ Wɩɩsɩ kɩ sɩna. Amɛ wɩɩ hʋ ma aa laa dʋnɩya no tɩyaŋ, ʋ rɛ Wɩɩsɩ mɛ sɩ laa. ");
INSERT INTO sig_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ŋ marɩ basɩ kɩ tɩya ma rɛ, dɩ ma balɩya rɛ yaa nyʋʋdɩgɩ a kyʋwalɩ Wɩɩsɩ kɩ kyɛ kɩŋ, ŋ Kuwo aa we wɩɩsɩbee tɩyaŋ sɩ yaa ʋ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lee hʋ nala balɩya koo boto aa laŋŋa ŋ feŋ tɩyaŋ, ŋ we ba lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ɛɛ rɛ Piita ko Yesu lee a pɩyɛsɩ ʋ a baa, “Tɩɩna, dɩ ŋ dɔŋtɩɩna rɛ yaa wɩɩ kyogi ŋ, naaŋsɩɩnyʋwa bʋŋmɛ rɛ ŋ maga dɩ ŋ kpa kyɛ ʋ? Ŋ kpa kyɛ ʋ naaŋsɩɩnyʋwa bʋpɛ koo?” ");
INSERT INTO sig_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ɛɛ rɛ Yesu baa, “Aayɩ, naaŋsɩɩnyʋwa bʋpɛ dʋŋ daa. Amɛ kpa kyɛ ʋ a mʋ pele saŋa hʋ ɩ bɩl aa bɩ sɩ wuwo dɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ɛɛ rɛ Yesu kaŋ wɩɩ no maga namaga a baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ kuwori kɩdɩgɩ aa sii yɩrɩ ʋ tʋŋtʋnna dɩ ʋ gyɩŋ ba kɩdɩgɩ buloŋ aa dii ʋ kyɩŋ mɔɔgɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ʋ aa piile dɩ ʋ pɩyɛsɩ kyɩma hʋ gɛɛ, ʋ tʋŋtʋnnɩ kɩdɩgɩ aa di ʋ kyɩŋ molbiye tusi tusi ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɛɛ rɛ tʋŋtʋnnɩ hʋ bɩ kaŋ molbii ʋ aa sɩ tuŋ. Nyɛ rɛ ʋ nɩhɩyawʋ hʋ baa dɩ ba kaŋ ʋ bee ʋ haaŋ abee ʋ balɩya abee kɩŋ buloŋ ʋ aa kana, a kaŋ mʋ yallɩ a ko tuŋ kyɩŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɛɛ rɛ tʋŋtʋnnɩ hʋ tuu gbinni a sʋla ʋ, a baa, ‘Ŋ nɩhɩyawʋ, di kenyiri tɩya ŋ, ŋ sɩ tuŋ kyɩŋ hʋ buloŋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nyɛ rɛ ʋ nɩhɩyawʋ hʋ fá ʋ sikii a kpa kyɩŋ hʋ kyɛ ʋ aŋ leŋ ʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amɛ baal no aa lɩɩ, a kyeŋ ʋ tʋŋtʋnnɩ-dɔŋtɩɩna mɛ aa dii ʋ kyɩŋ molbiwarɩ tusi, ʋ kyɩɩrɩ gal we ʋ bagɩna tɩyaŋ a baa dɩ ʋ tuŋ kyɩŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nyɛ rɛ ʋ tʋŋtʋnnɩ-dɔŋtɩɩna hʋ mɛ tuu gbinni a sʋla ʋ a baa, ‘Di kenyiri tɩya ŋ, ŋ sɩ tuŋ kyɩŋ hʋ.’ ");
INSERT INTO sig_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amɛ ʋ vɩya aŋ leŋ ba kana ʋ mʋ tɔ dɩya tɩyaŋ a kaŋ kɩ mʋ saŋa hʋ ʋ aa sɩ tuŋ kyɩŋ hʋ teŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ʋ tʋŋtʋnnɩ-dɔŋtɩŋsɩ hʋ aa naa wɩɩ hʋ ʋ aa yaa, ʋ yaa ba tɩkyogi. Ba mʋ basɩ tɩya ba nɩhɩyawʋ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ɛɛ rɛ kuwori hʋ yɩrɩ ʋ, a basɩ tɩya ʋ a baa, “Ɛɛ dɔŋ tahaa tɩɩna! Ɩ aa sʋla ŋ nɛ tɩŋ, ŋ kpaa kyɩŋ hʋ ɩ aa diye buloŋ a kyɛ ɩ. ");
INSERT INTO sig_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bee rɛ yaŋ tɩŋ ɩ kɛ bɩ wuwo dɩ ɩ fá ɩ dɔŋtɩɩna hʋ sikii anɩɩ ŋ aa fáá ɩ sikii gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kuwori hʋ na baaŋ weliŋ ʋ nyuu tɩyaŋ aŋ leŋ ba kana ʋ mʋ tɩya nɩtɔdɩya nala dɩ ba dɔgɩsɩ ʋ a mʋ pele saŋa hʋ ʋ aa sɩ tuŋ kyɩŋ hʋ buloŋ teŋ. ");
INSERT INTO sig_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɛɛ rɛ Yesu baa, “Nyɛ tɩɩ rɛ ŋ kuwo aa we wɩɩsɩbee tɩyaŋ mɛ sɩ yaa ma kɩdɩgɩ buloŋ, dɩ mamaa rɛ ko bɩ kpaa wɩya kɩ kyɛ ma dɔŋtɩŋsɩ abee ma tɩsɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu aa basɩ wɩya no teŋ, ʋ lɩɩ Galili paalʋʋ a mʋ Gyudɩya paalʋʋ Gyɔɔdaŋ fuwo hʋ kyolo tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɩgyamaa sii tɩŋa ʋ hal. Ʋ tɩɩbɩ nala hʋ aa wɩɩlɩ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ɛɛ rɛ Farasiima badɔmɔŋ mɛ sii ko ʋ lee a kɩ kyɛ dɩ ba magɩsɩ ʋ, a pɩyɛsɩ ʋ a baa, “Ʋ yaa ŋmanɩɩ rɛ dɩ baal kuu wɩɩ kɛ buloŋ wɩya a vɩya ʋ haaŋ?” ");
INSERT INTO sig_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Ma bɩ karɩma Wɩɩsɩ teŋ hʋ tɩyaŋ anɩɩ saŋa hʋ Wɩɩsɩ gyɩ aa marɩ dʋnɩya, baal bee haaŋ nɛ ʋ gyɩ ta aŋ baa, ");
INSERT INTO sig_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nyɛ wɩya baal aa sɩ leŋ ʋ kuwo abee ʋ naa rɛ ka dɩ ʋ bee ʋ haaŋ yaa kɩdɩgɩ a kɩ gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ba bɩl bɩ yaa nala balɩya, ba bɩrɩma nɩdɩgɩ rɛ. Ɛɛwɩya, nala hʋ Wɩɩsɩ aa leŋ ba yaa nɩdɩgɩ ʋ bɩ maga dɩ nihuwobiŋ kaŋ ba porigi dɔmɔŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɛɛ rɛ Farasiima hʋ bɩl pɩyɛsɩ ʋ a baa, “Bee rɛ yaŋ tɩŋ Moosi fa baa dɩ dɩ baal lɛ aa kyɛ ʋ vɩya ʋ haaŋ, dɩ ʋ laa sɩya sabɩ haaŋ vɩyayɩ teŋ tɩya ʋ aŋ na vɩya ʋ?” ");
INSERT INTO sig_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma dagɩɩ aa hayɛ rɛ tɩŋ Moosi gyɩ tɩya ma ŋmanɩɩ dɩ ma kɩ vɩya ma haana gɛɛ. Amɛ nyɛ daa ʋ fa kɩɩ dʋnɩya piilii hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ŋ basɩ kɩ tɩya ma rɛ, a lɩɩ sɔŋsɔŋ hal, dɩ baal lɛ kuu wɩɩ buloŋ wɩya a vɩya ʋ haaŋ, aŋ bɩl mʋ kpa hadɩma, ɩ tɩɩna yaa basɔŋsɔnnɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɛɛ rɛ Yesu hatɩnna hʋ basɩ tɩya ʋ anɩɩ dɩ nyɛ rɛ baal bee haaŋ wɩya kɩɩ, ɛɛ kɛ nal aa leŋ haaŋ kpayɩ rɛ kyo kpɩya. ");
INSERT INTO sig_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ba a baa, “Wɩɩ no bɩ kɩɩ nɩɩ nal buloŋ nɛ sɩ wuwo yaa ʋ. Amɛ nala hʋ Wɩɩsɩ aa kpaa ɛɛ dee tɩya dʋŋ nɛ sɩ wuwo yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wɩɩ hʋ aa tɩŋ baala badɔmɔŋ bee paa haana, ba yaa wɩgyamaa rɛ. Ba aa lʋl badɔmɔŋ dɩ ba paalɩ bɩ kaŋ barɩ. Badɔmɔŋ mɛ nihuwobisi rɛ farɩ ba, ka badɔmɔŋ mɛ kuu Wɩɩsɩbee koro hʋ wɩya a vɩya haana paayɩ. Nal hʋ aa sɩ wuwo laa wɩɩ no di, ʋ tɩɩna laa di.” ");
INSERT INTO sig_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɛɛ rɛ nala badɔmɔŋ sii kaŋ biisi ko Yesu lee, dɩ ʋ kpa ʋ nosi dɔbɔ ba tɩyaŋ a sʋla Wɩɩsɩ tɩya ba. Ɛɛ rɛ ʋ hatɩnna hʋ kɩ kil ba. ");
INSERT INTO sig_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu aa naa gɛɛ, ʋ basɩ tɩya ba a baa, “Ma ta kil ba. Ma leŋ dɩ ba ko ŋ lee, beewɩya nala hʋ aa kaŋ ba tɩɩ kɩ hʋwɔlɩ anɩɩ biibiisi no aŋ kɩ tɩŋ ŋ hal, ba aa rɛ sɩ gyʋʋ wɩɩsɩbee koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɛɛ rɛ ʋ kpa ʋ nosi dɔbɔ ba tɩyaŋ aŋ kyʋwalɩ Wɩɩsɩ tɩya ba aŋ lɩɩ doŋ kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baal kɩdɩgɩ mɛ rɛ gyɩ siye a ko Yesu lee a pɩyɛsɩ ʋ a baa, “Ŋ nɩhɩyawʋ, wɩwelibee rɛ ŋ sɩ yaa a na mɩɩbol hʋ aa bɩ kaŋ tenii?” ");
INSERT INTO sig_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ ɩ kɩ pɩyɛsɩ ŋ wɩweliye wɩya? Wɩɩsɩ dʋŋ nɛ weliye. Dɩ ɩ rɛ aa kyɛ dɩ ɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii, kɩ tɩŋ Wɩɩsɩ mɩrɩsɩ hʋ ba aa saba biŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɛɛ rɛ baal hʋ pɩyɛsɩ ʋ abaa, “Mɩrɩbeema rɛ gɛɛ?” Ɛɛ rɛ Yesu baa, “Ba aa rɛ nyɛ: Ta kpʋʋ nal, ta kɩ sɔnnɔ, ta gaa, ta nyɩya wɩya tɩya nal, ");
INSERT INTO sig_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kɩ tɩya ɩ kuwo abee ɩ naa gyɩrɩma, kyo ɩ dɔŋtɩɩna anɩɩ ɩ aa kyo ɩ tɩɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɛɛ rɛ baal hʋ baa, “Wɩya no kɛ buloŋ nɛ ŋ kɩ tɩŋa. Wɩbee rɛ ha kaa?” ");
INSERT INTO sig_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ɛɛ rɛ Yesu basɩ tɩya ʋ abaa, “Dɩ ɩ rɛ aa kyɛ dɩ ɩ kɔnɩ yaa niwelii Wɩɩsɩ ŋmanɩɩ tɩyaŋ, a ta kaŋ gyoŋ wɩɩ buloŋ tɩyaŋ, mʋ kpa ɩ kɩna hʋ buloŋ yallɩ, a kpa molbiye hʋ tɩya nyaaba, aŋ ko kɩ tɩŋa ŋ. Dɩ ɩ rɛ yaa gɛɛ, ɩ sɩ kaŋ kɩna wɩɩsɩbee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yesu aa basɩ gɛɛ, baal hʋ tɩya buloŋ kyogi, ʋ sii mʋ, beewɩya ʋ gyɩ kaŋ kɩna rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ʋ yaa wɩduwo rɛ abee kɩna tɩɩna aa sɩ wuwo gyʋʋ wɩɩsɩbee koro hʋ. ");
INSERT INTO sig_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ŋ bɩl basɩ kɩ tɩya ma rɛ, nyɔgɩmaa aa sɩ tɩŋ gahaŋ sɩɩ a lɩɩ, ʋ rɛ yaa mɔl a te kɩna tɩɩna aa sɩ wuwo gyʋʋ wɩɩsɩ koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ʋ hatɩnna hʋ gyɩ aa nɩɩ wɩya no, ba nyʋʋsɩ gyɩ fɩyɛlɩ weliŋ ba pɩyɛsɩ Yesu a baa, “Dɩ ba aa rɛ kɩɩ nyɛ, kɩbee rɛ yaŋ sɩ na Wɩɩsɩ laatayɩ?” ");
INSERT INTO sig_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu mɩɩgɩ deŋ ba aŋ baa, “Wɩɩ no kperi nihuwobiŋ nɛ, amɛ wɩɩ buloŋ tuwo Wɩɩsɩ aa bɩ sɩ wuwo yaa.” ");
INSERT INTO sig_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ɛɛ rɛ Piita baa, “Na, á kɛ leŋ á kɩŋ buloŋ nɛ aŋ kɩ tɩŋa ɩ hal. Bekiŋ tɔnɔ rɛ á sɩ na?” ");
INSERT INTO sig_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, saŋa hʋ dʋnɩfalɩɩ hʋ aa sɩ ko tɩyaŋ, mɩyaŋ Nihuwobiŋ Biye sɩ hɔŋ ŋ gaŋdaa-kuworikpasa tɩyaŋ. Saŋa no tɩyaŋ, ma nala hʋ fi abee balɩya hʋ aa tɩŋa ŋ hal, ma mɛ sɩ hɔŋ kuworikpasɩnɩ fi abee balɩya tɩyaŋ a kɩ di Iziral bekyige fi abee balɩya hʋ sarɩya. ");
INSERT INTO sig_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nal hʋ buloŋ mɛ aa kuu ŋ wɩya, a leŋ ʋ dɩɩsɩ koo ʋ naabiisi koo ʋ kuwo koo ʋ naa, koo ʋ biisi koo ʋ bagɩsɩ a ta, ʋ tɩɩna sɩ bɩl na kɩna no naaŋsɩɩnyʋwa kɔɔ aŋ pɛ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii mɛ. ");
INSERT INTO sig_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amɛ nala hʋ aa yaa nɩbala dʋnɩya sɩya tɩyaŋ, ba sɩ maakyiye ko yaa nɩbiisi, ka nala hʋ mɛ aa yaa nɩbiisi dʋnɩya sɩya tɩyaŋ ba mɛ sɩ maakyiye ko yaa nɩbala.” ");
INSERT INTO sig_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ɛɛ rɛ Yesu bɩl maga namaga a tɩya ʋ hatɩnna hʋ a daga wɩɩ hʋ ʋ aa basɩ memii. Ʋ baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ baga tɩɩna kɩdɩgɩ aa sii kyɩkyʋwala, a lɩɩ kɩ kyɛ nala dɩ ʋ paa baadee dɩ ba mʋ pala ʋ baga. ");
INSERT INTO sig_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ʋ aa ko na nala hʋ aa sɩ mʋ baga hʋ, ʋ laa nyʋwa anɩɩ ʋ sɩ tuŋ ba kɩdɩgɩ buloŋ kyɛdɩgɩ tuno, aŋ leŋ ba mʋ baga hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wɩɩsɩ aa ko maga gyinyɛ, ʋ bɩl lɩɩ a na baala badɔmɔŋ dɩ ba sɩŋ bee tɩyaŋ waasʋ. ");
INSERT INTO sig_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ɛɛ rɛ ʋ basɩ tɩya ba a baa “Ma mɛ mʋ ŋ baga, ka dɩ ŋ tuŋ ma gɛɛ hʋ buloŋ aa maga.” Ɛɛ rɛ ba mɛ mʋ baga hʋ. ");
INSERT INTO sig_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wɩɩsɩ bɩl aa ko maga nyutʋtʋʋ, ʋ bɩl lɩɩ a na baala badɔmɔŋ a leŋ ba mɛ mʋ baga hʋ. Sɔnnɩ bɩl aa ko viisi saŋa hʋ, ʋ bɩl lɩɩ na nala badɔmɔŋ a leŋ ba mɛ mʋ baga hʋ. ");
INSERT INTO sig_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wɩɩsɩ aa ko tuu fɩyɛlɩ gɛɛ, ʋ bɩl lɩɩ bee a na nala badɔmɔŋ mɛ dɩ ba sɩŋ waasʋ. Ɛɛ rɛ ʋ pɩyɛsɩ ba abaa, “Bee rɛ tɩŋ ma sɩŋ daha waasʋ gyɩnaŋ buloŋ, ma bɩ kaŋ tʋŋ buloŋ?” ");
INSERT INTO sig_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba basɩ tɩya ʋ anɩɩ ba bɩ naa tʋma dɩ ba tʋma. Ɛɛ rɛ ʋ basɩ tɩya ba dɩ ba mɛ mʋ ʋ baga hʋ. Nyɛ rɛ ba mɛ kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dɩdaana aa ko pele, ɛɛ rɛ baga hʋ tɩɩna yɩrɩ nal hʋ aa deŋ ʋ baga hʋ a basɩ tɩya ʋ dɩ ʋ yɩrɩ nala hʋ aa ko tʋŋ tʋma baga hʋ tɩyaŋ a tuŋ ba. Ʋ baa dɩ ʋ laasɩya tuŋ nala hʋ aa laa hal ko a mʋ tuu pele nala hʋ a laa sɩya ko tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Baala hʋ aa laa hal mʋ baga hʋ, ʋ tuŋ ba kɩdɩgɩ buloŋ kyɛdɩgɩ tuno. ");
INSERT INTO sig_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ʋ aa tuŋ ba teŋ, nala hʋ aa laa sɩya mʋ baga hʋ mɛ ko dɩ ba laa ba tuno. Ba fa bɩɩna anɩɩ ba sɩ laa te hal nala hʋ rɛ, amɛ ba tuŋ ba mɛ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba laa molbiye hʋ aŋ gʋrɩmɩ baga hʋ tɩɩna wɩya kɩ basɩ, ");
INSERT INTO sig_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a baa, “Nala no aa laa hal ko, ba tʋŋ tʋma hawa dɩgɩ dʋŋ nɛ, aŋka á kɛ tʋma kyɩkyʋwala buloŋ gɛɛ wɩɩsɩ no mʋ gyʋʋ, aŋka ɩ tuŋ á buloŋ maga dɔmɔŋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ɛɛ rɛ baga hʋ tɩɩna basɩ tɩya ba kɩdɩgɩ a baa, “Ŋ bagyʋwa gyegile nɩɩ daha, ŋ bɩ firimi ma. Na ma laa nyʋwa rɛ anɩɩ ma sɩ tʋma dɩ wɩɩsɩ gyʋʋ, ka dɩ ma laa kyɛdɩgɩ tuno. ");
INSERT INTO sig_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma laa ma molbiye kɩ mʋ. Ŋ kyɛrɩ tɩyaŋ nɛ ŋ tuŋ baala no aa laa hal ko gɛɛ tɩɩ ŋ aa tuŋ ma mɛ. ");
INSERT INTO sig_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ŋ bɩ kaŋ ŋmanɩɩ dɩ ŋ kaŋ ŋ molbiye yaa gɛɛ hʋ ŋ aa kyɛɛ? Koo ma tɩsɩ aa hɔllɩ akuu ŋ aa kaŋ bɔnyɛ wɩya rɛ?” ");
INSERT INTO sig_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɛɛ rɛ Yesu basɩ teŋ aŋ baa, “Nala hʋ aa yaa nɩbala dʋnɩya nala sɩya tɩyaŋ ba aa rɛ sɩ ko maakyiye yaa nɩbiisi dʋnɩfalɩɩ hʋ aa sɩ ko tɩyaŋ, ka nala hʋ mɛ aa yaa nɩbiisi dʋnɩya nala sɩya tɩyaŋ ba mɛ rɛ sɩ maakyiye ko yaa nɩbala dʋnɩfalɩɩ hʋ aa sɩ ko tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Saŋa hʋ Yesu bee ʋ hatɩnna fi abee balɩya hʋ gyɩ aa we ŋmanɩɩ tɩyaŋ a kɩ mʋ Gyerusalɛm tɩyaŋ nɛ ʋ gyɩ kaŋ ba dʋŋ gɩɩgɩ lɩɩ a basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ma gyegili nɩɩ daha. Á aa mʋ Gyerusalɛm nɛ. Doŋ tɩyaŋ nɛ ba sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye a kaŋ mʋ tɩya Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla. Ba sɩ di ŋ sarɩya a kpa kyogisi tɩyaŋ aŋ baa ʋ maga dɩ ba kpʋ ŋ nɛ, ");
INSERT INTO sig_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aŋ kpa ŋ we nala hʋ aa bɩ yaa Gyuuma nosi tɩyaŋ. Ba sɩ yaa ŋ sɩya, a vɩɩrɩ ŋ, aŋ kpaasɩ ŋ mal daagarɩɩ tɩyaŋ. Amɛ ʋ kyɛtoo kyɛɛ Wɩɩsɩ sɩ kyisi ŋ sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedi haaŋ gyɩ sii kaŋ ʋ biisi balɩya ko Yesu lee rɛ a tuu gbinni ʋ sɩya tɩyaŋ, aŋ sʋla ʋ dɩ ʋ pɛ ʋ bee wɩɩ kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Wɩbee rɛ ɩ kɩ kyɛ dɩ ŋ yaa tɩya ɩ?” Nyɛ rɛ ʋ baa, “Dɩ ɩ ko di ɩ koro hʋ a hɔŋ ɩ gaŋdaa-kuworikpasa hʋ tɩyaŋ, leŋ dɩ ŋ biisi no balɩya kɩdɩgɩ hɔŋ ɩ noduu, dɩ kɩdɩgɩ mɛ hɔŋ ɩ nogɔbɔ.” ");
INSERT INTO sig_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ɛɛ rɛ Yesu basɩ tɩya biisi hʋ a baa, “Ma bɩ gyɩŋ wɩɩ hʋ ma aa kyɛ. Ma sɩ wuwo kaŋ kenyiri a na tʋwara hʋ ŋ aa sɩ na?” Ba baa “Waa á sɩ wuwo.” ");
INSERT INTO sig_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Doŋ nɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ma basɩ. Tʋwara hʋ ŋ aa sɩ na, ʋ tɩɩ rɛ ma mɛ sɩ na. Amɛ ŋ noduu abee ŋ nogɔbɔ hʋhɔnnɔ hʋ kɛ, ŋ daa sɩ lɩɩ ba. Ŋ kuwo Wɩɩsɩ marɩ doŋ nɛ a tɩya nala hʋ ʋ tɩɩ aa sɩ lɩɩ dɩ ba hɔŋ doŋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu hatɩnnɩ kaalɩya hʋ aa nɩɩ wɩɩ no ba kɩ na baaŋ Gyemsi bee Gyɔɔŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ɛɛ rɛ Yesu yɩrɩ ʋ hatɩnna hʋ buloŋ ko laŋŋɩ, a basɩ tɩya ba a baa, “Na ma gyɩma anɩɩ nala hʋ aa bɩ yaa Gyuuma, ba kuworo aa hɔŋ ba nyuu tɩyaŋ nɛ, ba sɩlaala mɛ kaŋ ba kɩ fɩla. ");
INSERT INTO sig_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amɛ ʋ bɩ maga dɩ ma kɛ kɩ yaa gɛɛ. Ma tɩyaŋ nal hʋ aa kyɛ dɩ ʋ yaa ma nɩbal, ʋ maga dɩ ʋ tɩɩna tʋma kɩ tɩya ma rɛ. ");
INSERT INTO sig_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma nal hʋ mɛ aa kyɛ dɩ ʋ yaa ma tɩyaŋ sɩlaal, ʋ maga dɩ ʋ tɩɩna kaŋ ʋ tɩɩ yaa yoŋ nɛ ma tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","anɩɩ mɩyaŋ Nihuwobiŋ Biye aa kɩɩ gɛɛ. Ŋ bɩ ko dɩ nala tʋma kɩ tɩya ŋ, amɛ nala rɛ ŋ ko dɩ ŋ tʋma tɩya, aŋ kpa ŋ mɩɩbol mɛ lenni sʋʋ a laa nala yʋga ta ba wɩbɔmɔ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ɛɛ hal lɛ ba mʋ lɩɩ tɩŋ Gyɛriko tɩyaŋ kɩ mʋ, nɩgyamaa mɛ sii paa tɩŋ ba hal. ");
INSERT INTO sig_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Doŋ nɛ dɩ banyʋlma balɩya mɛ hɔŋ ŋmanɩɩ hʋ nyʋwa aŋ nɩɩ dɩ Yesu rɛ aa baŋ. Ɛɛ rɛ ba huwori yɩrɩ ʋ a baa, “Á nɩhɩyawʋ, Deviti nihii, fá á sikii.” ");
INSERT INTO sig_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɛɛ rɛ nɩgyamaa hʋ nɔsɩ ba dɩ ba leŋ ba kyagɩŋsɩ hʋ. Amɛ ba marɩ yɩrɩ te gɛɛ a baa, “Á nɩhɩyawʋ, Deviti nihii, fá á sikii.” ");
INSERT INTO sig_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Doŋ nɛ Yesu sɩŋ aŋ yɩrɩ ba a pɩyɛsɩ ba, “Bekiŋ nɛ ma kɩ kyɛ dɩ ŋ yaa tɩya ma?” ");
INSERT INTO sig_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba baa, “Á nɩhɩyawʋ, á aa kyɛ dɩ ɩ suri á sɩya tɩya ma rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɛɛ rɛ Yesu fá ba sikii a dige dige ba sɩyasɩ ba pirigi suri, ba sii kɩ tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu bee ʋ hatɩnna hʋ gyɩ aa ko kɩ kpaga Gyerusalɛm, a ko pele Bɛtifage aa we Olivi dogimo nyuu tɩyaŋ, Yesu lɩɩ ʋ hatɩnna hʋ tɩyaŋ balɩya a tɩŋ ba a baa, “Ma mʋ tɔɔ hʋ aa we ma sɩya. ");
INSERT INTO sig_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Dɩ mamaa rɛ ko mʋ, ma sɩ na kokumo bee ʋ biye dɩ ba vʋwa sɩgɩ. Ma puri kaŋ ko tɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dɩ nal buloŋ nɛ ko pɩyɛsɩ ma, ma basɩ tɩya ʋ anɩɩ ma Tɩɩna rɛ aa kyɛ. Ʋ sɩ leŋ dɩ ma kaŋ ko lagɩ.” ");
INSERT INTO sig_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wɩɩ no yaa dɩ wɩɩ hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal kɩdɩgɩ tɩyaŋ basɩ ko yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ʋ gyɩ baa, “Basɩ tɩya Zaayɔŋ nala Ma na, ma kuwori rɛ aa ko ma lee. Ʋ kaŋ ʋ tɩɩ hʋwɔlɩ rɛ a gyɩŋ kokumo abee ʋ biye.” ");
INSERT INTO sig_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɛɛ rɛ Yesu hatɩnna hʋ mʋ a yaa wɩɩ hʋ Yesu aa basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba mʋ kaŋ kokumo hʋ bee ʋ biye a ko kpa ba gannɩ dɔbɔ kokumo hʋ abee ʋ biye nyuu tɩyaŋ, Yesu gyɩŋ. ");
INSERT INTO sig_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɩgyamaa mɛ gyɩ kpaa ba gannɩ a gyarɩ ŋmanɩɩ hʋ tɩyaŋ, ka ba badɔmɔŋ mɛ gyaa paaponni a mɛ kaŋ ko lɩɩ gyarɩ ŋmanɩɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɩgyamaa hʋ aa laa Yesu sɩya abee nala hʋ aa tɩŋa ʋ hal piili kɩ yaa kyagɩŋsɩ a kɩ dannɩ ʋ a baa, “Tabarikala! Deviti nihii! Wɩɩsɩ sɩ pɛ nal hʋ aa ko á Tɩɩna feŋ tɩyaŋ. Ma leŋ dɩ á dannɩ Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ!” ");
INSERT INTO sig_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu aa mʋʋ gyʋʋ Gyerusalɛm, bee hʋ buloŋ dɔŋ. Ɛɛ rɛ nala kɩ pɩyɛsɩ a baa, “Kɩbee rɛ nyɛ?” ");
INSERT INTO sig_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɛɛ rɛ nɩgyamaa hʋ baa, “Wɩɩsɩ tɩŋdaal Yesu aa lɩɩ Nazarɛti aa we Galili paalʋʋ tɩyaŋ nɛ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ɛɛ rɛ Yesu sii mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo, dɩ nala badɔmɔŋ gyɩ we doŋ a kɩ yallɩ kɩna, badɔmɔŋ mɛ kɩ yɔbɔ kɩna. Yesu kile ba buloŋ ta ba lɩɩ. Baala badɔmɔŋ mɛ gyɩ we doŋ a kɩ warɩ molbiye. Yesu ŋmaa ba teebʋlsɩ lo. Badɔmɔŋ mɛ gyɩ aa yallɩ kokosi, ʋ ŋmaa ba mɛ kpasɩnɩ kyige. ");
INSERT INTO sig_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa dɩ Wɩɩsɩ baa, ‘Ŋ dɩya sɩ yaa lee hʋ nala aa sɩ kɩ kyʋwalɩ Wɩɩsɩ rɛ’, aŋka ma kɛ mɩɩgɩ kaŋ bɩrɩmɩ gaala dɩya.” ");
INSERT INTO sig_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɛɛ rɛ nyʋlɩma abee gbarɩga ko Yesu lee Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ʋ tɩɩbɩ ba. ");
INSERT INTO sig_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ aa naa wɩmagɩla hʋ ʋ aa yaa, a bɩl na gɛɛ biibiisi aa yaa kyagɩŋsɩ a kɩ dannɩ ʋ a baa “Tabarikala! Deviti nihii!” Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo tɩyaŋ, ba baaŋ sii. ");
INSERT INTO sig_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ pɩyɛsɩ Yesu a baa, “Ɩ nɩɩ wɩya hʋ biisi hʋ aa basɩ rɛ?” Yesu baa, “Ŋ nɩya rɛ.” Ɛɛ rɛ Yesu mɛ pɩyɛsɩ ba abaa, “Ma bɩ karɩmɩ Wɩɩsɩ teŋ lee hʋ ba aa saba a baa “Wɩɩsɩ daga biibiisi abee biifɩllɩ rɛ dɩ ba kɩ dannɩ ʋ weliŋ?” ");
INSERT INTO sig_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Doŋ nɛ Yesu leŋ ba aŋ sii mʋ pɩŋ Bɛɛtani tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ʋ sɩya aa gballa kyɩkyʋwala, Yesu mɩɩgɩ sii kɩ mʋ Gyerusalɛm. Ŋmanɩɩ tɩyaŋ, losi kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ʋ naa tutogo dɩ ʋ sɩŋ ŋmanɩɩ hʋ nyʋwa tɩyaŋ. Ʋ mʋ gyʋʋ tutogo hʋ memii a wil nyuu deŋ dɩ nɔnɔ tuwo, see paaponni dʋŋ. Ɛɛ rɛ ʋ basɩ tɩya tutogo hʋ a baa, “A lɩɩ gyɩnaŋ kɩ mʋ, ɩ bɩl bɩ sɩ nɔnɔ.” Tutogo hʋ pirigi sʋba haŋ lagɩlagɩbiye hʋ. ");
INSERT INTO sig_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ʋ hatɩnna hʋ aa naa wɩɩ no, ʋ yaa ba wɩkperii. Ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Ɛɛ rɛ tɩya hʋ pirigi sʋba lagɩ gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ mamaa rɛ kɔnɩ laa Wɩɩsɩ di, a bee yaa sige, ma mɛ sɩ wuwo yaa wɩɩ no ŋ aa yaa tutogo hʋ. Nyɛ mɛ dʋŋ yaŋ daa, amɛ ma sɩ paalɩ wuwo basɩ tɩya dogimo no aa sɩna, a baa, ‘Sii a mʋ tele mpʋwɔnʋʋ tɩyaŋ dɩ ʋ kɔnɩ sii mʋ tele.’ ");
INSERT INTO sig_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kɩna hʋ buloŋ ma aa sʋla Wɩɩsɩ a kɩ kyɛ, dɩ mamaa rɛ laa Wɩɩsɩ di, ma sɩ na ba.” ");
INSERT INTO sig_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu aa mɩɩgɩ mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal gyaŋwuwo hʋ, a kɩ daga nala, doŋ nɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee-nɩhɩyasɩ buloŋ sii ko ʋ lee a pɩyɛsɩ ʋ a baa, “Aŋnɛ rɛ tɩya ɩ dee ɩ kɩ yaa wɩya no buloŋ?” ");
INSERT INTO sig_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ mɛ sɩ pɩyɛsɩ ma wɩdɩgɩ. Dɩ mamaa rɛ ko lɩɩ ʋ sɩɩ tɩya ŋ, ŋ mɛ sɩ daga ma nal hʋ aa tɩya ŋ dee ŋ kɩ yaa wɩya no buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Aŋnɛ rɛ tɩya Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ dee ʋ gyɩ kɩ fo nala wɩɩkyʋwalnɩɩ? Ʋ dee hʋ gyɩ lɩɩ Wɩɩsɩ lee rɛ koo ʋ lɩɩ nihuwobiŋ lee rɛ?” Ʋ aa basɩ gɛɛ, ba piili kaŋ wɩɩ hʋ kɩ kpa dɔmɔŋ a baa, “Wɩbee rɛ á sɩ basɩ tɩya ʋ? Dɩ ámaa rɛ basɩ tɩya ʋ a baa dɩ Wɩɩsɩ lee rɛ ʋ lɩɩ, ʋ sɩ pɩyɛsɩ ma a baa, ‘Bee rɛ yaŋ tɩŋ á bɩ laa wɩya hʋ Gyɔɔŋ aa basa di?’ ");
INSERT INTO sig_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dɩ ámaa rɛ bɩl baa dɩ ʋ lɩɩ nihuwobiŋ lee mɛ rɛ, nɩgyamaa no buloŋ bee leŋ ma. Beewɩya ba buloŋ gyɩ laa di anɩɩ Gyɔɔŋ gyɩ yaa Wɩɩsɩ tɩŋdaal lɛ.” ");
INSERT INTO sig_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛɛ rɛ ba basɩ tɩya Yesu a baa, “Á bɩ gyɩma.” Nyɛ rɛ Yesu mɛ basɩ tɩya ba a baa, “Ɛɛ kɛ, ŋ mɛ bɩ sɩ daga ma nal hʋ aa tɩya ŋ dee ŋ wuwo kɩ yaa wɩya no buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ɛɛ rɛ Yesu maga namaga a tɩya Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma a baa, “Baal kɩdɩgɩ rɛ gyɩ we doŋ a kaŋ ʋ biibaala balɩya. Ʋ sii mʋ ʋ biihɩyawʋ hʋ lee a basɩ tɩya ʋ a baa, ‘Ŋ biye, mʋ baga gyɩnaŋ a tʋŋ tʋma.’ ");
INSERT INTO sig_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɛɛ rɛ biye hʋ baa, “Ŋ bɩ sɩ wuwo mʋ.” Amɛ gɛɛ hal tɩyaŋ, ʋ bɩrɩmɩ ʋ hakɩla aŋ sii mʋ baga hʋ. ");
INSERT INTO sig_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ɛɛ rɛ ʋ mʋ a basɩ ɛɛ tɩɩ tɩya haŋbiye hʋ tɩɩna mɛ, ʋ laa nyʋwa weliŋ anɩɩ ʋ sɩ mʋ baga hʋ aŋ vɩya mʋyɩ. ");
INSERT INTO sig_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Biisi no balɩya tɩyaŋ, ba kɩbee rɛ tɩŋ ʋ kuwo hʋ nyʋwa?” Doŋ nɛ ba basɩ tɩya ʋ dɩ ʋ biihɩyawʋ rɛ tɩŋ ʋ kuwo nyʋwa. Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, lampolaala abee gyaŋtɩrɩsɩ laa sɩya kɩ gyʋʋ wɩɩsɩ koro hʋ rɛ ma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Beewɩya Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ ko daga ma wɩtɩɩ ŋmanɩɩ hʋ rɛ ma aa sɩ tɩŋa, aŋka ma bɩ laa ʋ wɩya di, amɛ lampolaala abee gyaŋtɩrɩsɩ kɛ laa ʋ wɩya di rɛ. Abee ma aa naa gɛɛ hʋ ba aa laa ʋ wɩya di buloŋ, amɛ ma kɛ bɩ bɩrɩma ma hakɩllɩ a laa ʋ wɩya di.” ");
INSERT INTO sig_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ɛɛ rɛ Yesu bɩl maga namaga kɩdɩgɩ a baa, “Baal kɩdɩgɩ rɛ gyɩ biŋ ʋ baga a pɔ kɩna badɔmɔŋ aa kaŋ nɔŋkyɩga a kɩɩ gɛɛ anɩɩ kyʋkyɔyɩ, ba kɩ yɩrɩ girepisi. Ʋ yaŋ lɩga baga hʋ gol baŋ, a hulo bʋwa baga hʋ tɩyaŋ dɩ ba kyaga tɩɩnɔnɔ hʋ nɩɩ kɩ we (beewɩya ba kpaa ba nɔnɔ kɩ kyɔ sɩŋ nɛ). Ʋ gyɩ saa salnyuu dɩɩbiye mɛ rɛ, dɩ ba hɔŋ ʋ salnyuu tɩyaŋ a kɩ pɔ baga hʋ. Ɛɛ hal tɩyaŋ nɛ ʋ paa nala a we baga hʋ tɩyaŋ dɩ ba kɩ tʋma. Ka ʋ sii kpa mʋ tɔɔ kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tɩɩnɔnɔ hʋ tɔrɩɩ saŋa aa ko pele, ʋ tɩŋ ʋ dɩya tʋŋtʋnna dɩ ba mʋ baga tʋŋtʋnna hʋ lee a laa ʋ tɩɩnɔnɔ tol ko tɩya ʋ. Nyɛ rɛ ba mʋ. ");
INSERT INTO sig_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ba kasɩ ba a ŋmaa kɩdɩgɩ, a kpʋ kɩdɩgɩ, aŋ yaga kɩdɩgɩ hʋ mɛ abee bʋwa. ");
INSERT INTO sig_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ɛɛ rɛ baal hʋ bɩl marɩ tɩŋ ʋ dɩya tʋŋtʋnna badɔmɔŋ aa tee laasɩya nala hʋ. Ba yaa ba mɛ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ba kateŋsi tɩyaŋ ʋ tɩŋ ʋ biye tɩɩ. Ʋ bɩɩna anɩɩ dɩ ʋ biye tɩɩ kɛ rɛ mʋwa, ba sɩ tɩya ʋ gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amɛ tʋŋtʋnna hʋ aa naa biye hʋ, ba basɩ tɩya dɔmɔŋ a baa, “Dɩ baga hʋ tɩɩna rɛ ko sʋba, biye no rɛ sɩ di ʋ kyaŋ. Ma leŋ dɩ á kpʋ ʋ. Dɩ ámaa rɛ kpʋ ʋ, ámaa rɛ sɩ mɩɩgɩ tɩŋ ʋ kɩna hʋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Doŋ nɛ ba kaŋ biye hʋ a kpʋ ʋ, aŋ kpa ʋ yuwo ta baga hʋ hal. ");
INSERT INTO sig_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ba aa maga nyɛ, dɩ baga hʋ tɩɩna rɛ ko, ɛɛ rɛ ʋ sɩ yaa baga tʋŋtʋnna no?” ");
INSERT INTO sig_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, ‘Ʋ sɩ ko a kpʋ nɩbɔmɔ no aŋ kpa baga hʋ a tɩya nɩdʋŋsɩ, nala hʋ aa sɩ kɩ tɩya ʋ ʋ tɩɩnɔnɔ tol, dɩ ba tɔrɩɩ saŋa rɛ ko pele.”’ ");
INSERT INTO sig_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɛɛ rɛ Yesu pɩyɛsɩ nala hʋ aa nɩɩ namaga hʋ abaa, “Ma bɩ karɩmɩ Wɩɩsɩ teŋ hʋ lee hʋ ba aa baa, ‘Bʋyɩ hʋ dɩɩsaala a vɩya ta, ʋ rɛ mɩɩgɩ ko yaa bʋduwo ba aa kpaa biŋ dɩya hʋ gyememii ʋ kaŋ dɩya hʋ sɩgɩ. Á Tɩɩna Wɩɩsɩ tʋma rɛ gɛɛ. Á naa nɩɩ ʋ yaa wɩkperii rɛ!”’ ");
INSERT INTO sig_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ɛɛ rɛ Yesu basɩ tɩya nala hʋ a baa, “Wɩɩsɩ sɩ kaŋ ʋ koro hʋ laa ma lee, a kpa tɩya nala hʋ aa sɩ tɩŋ Wɩɩsɩ nyʋwa weliŋ a kɩ yaa wɩya hʋ aa sɩ daga anɩɩ ba we wɩɩsɩ koro hʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nal hʋ aa tele bʋyɩ no nyuu, ʋ tɩɩna sɩ kyɔrɩsɩ kyɔrɔkyɔrɔ. Dɩ bʋyɩ no mɛ rɛ ko tele nal buloŋ nyuu, ʋ sɩ kyaŋɩsɩ ʋ tɩɩna kyaŋa kyaŋa.” ");
INSERT INTO sig_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gyuuma wɩɩkyʋwaldɩya sɩlaala nɩhɩyasɩ abee Farasiima aa nɩɩ Yesu aa maga namaga hʋ, ba gyɩma anɩɩ ba wɩya rɛ ʋ kɩ basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɛɛ rɛ ba kɩ lʋga dɩ ba kana ʋ tɔ dɩyaŋ. Amɛ ba fa aa fá nɩgyamaa hʋ aa we doŋ nɛ, beewɩya nɩgyamaa hʋ kpaa Yesu anɩɩ ʋ yaa Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ɛɛ rɛ Yesu bɩl maga namaga kɩdɩgɩ tɩya nala hʋ aa pɩyɛsɩ ʋ dee wɩya, ");
INSERT INTO sig_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","a baa, “Wɩɩsɩbee koro hʋ kɩɩ gɛɛ rɛ anɩɩ kuwori kɩdɩgɩ aa leŋ ba marɩ ʋ biye hafalɩɩ gbɩyala kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ba aa marɩ kɩdiiliye hʋ teŋ, ʋ tɩŋ ʋ tʋŋtʋnna dɩ ba mʋ yɩrɩ nala hʋ ʋ aa yɩra anɩɩ wɩɩ buloŋ yaa siri rɛ. Ba mʋ yɩrɩ ba, ba vɩya koyi. ");
INSERT INTO sig_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɛɛ rɛ ʋ bɩl tɩŋ ʋ tʋŋtʋnna badɔmɔŋ a baa, ‘Ma mʋ basɩ tɩya nala hʋ ŋ aa yɩra anɩɩ nɔbolli bee nɔfarɩsɩ buloŋ nɛ ŋ kpʋ a leŋ ba yaa kɩdiiliye hʋ. Wɩɩ buloŋ yaa siri rɛ. Ɛɛwɩya ba ko hafalɩɩ gbɩyala hʋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ɛɛ rɛ nala hʋ ʋ aa yɩra bɩl vɩya mʋyɩ aŋ kɩ tʋŋ ba tʋma. Ba badɔmɔŋ sii mʋ ba bagɩsɩ ka badɔmɔŋ mɛ sii mʋ ba kɩna lɩyallɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka badɔmɔŋ mɛ kasɩ ʋ dɩya tʋŋtʋnna hʋ ʋ aa tɩma a ŋmaa ba weliŋ aŋ kpʋ ba. ");
INSERT INTO sig_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ɛɛ rɛ kuwori hʋ na baaŋ kɩŋkaŋ a ta ʋ laalyuwolo ba mʋ kpʋ nala hʋ aa kpʋʋ ʋ dɩya tʋŋtʋnna hʋ, aŋ nyɔgɔ ba bee buloŋ ta. ");
INSERT INTO sig_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ɛɛ rɛ ʋ yɩrɩ ʋ tʋŋtʋnnɩkaalɩya hʋ a bɩl basɩ tɩya ba a baa, “Hafalɩɩ gbɩyala kɩdiiliye hʋ yaa siri rɛ, amɛ nala hʋ ŋ aa yɩra bɩ maga dɩ ba ko gbɩyala hʋ. ");
INSERT INTO sig_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ma lɩɩ gɔllɩ bee hʋ tɩyaŋ buloŋ a yɩrɩ nala hʋ buloŋ ma aa sɩ na a basɩ tɩya ba dɩ ba ko di kɩdiiliye hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɛɛ rɛ tʋŋtʋnna hʋ lɩɩ gbɛ bee hʋ tɩyaŋ buloŋ a yɩrɩ nala hʋ buloŋ ba aa naa doŋ, niweliye abee nɩbɔmɔ buloŋ. Ɛɛ rɛ ba buloŋ ko gyʋʋ su dɩya hʋ tɩyaŋ ba fa aa gbɩyalɩ gbɩyala hʋ. ");
INSERT INTO sig_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ɛɛ rɛ kuwori hʋ gyʋʋ dɩ ʋ na nala hʋ aa ko. Ʋ gyʋwa a na baal kɩdɩgɩ aa bɩ laalɩ hafalɩɩ gbɩyala gal. ");
INSERT INTO sig_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ɛɛ rɛ ʋ pɩyɛsɩ ʋ a baa, “Ŋ bagyʋwa, ɛɛ rɛ ɩ yaa ko gyʋʋ daha aŋ bɩ laalɩ hafalɩɩ gbɩyala gal?” Baal hʋ tallɩ ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɛɛ rɛ kuwori hʋ basɩ tɩya ʋ tʋŋtʋnna a baa, “Ma kaŋ baal no a vʋwa ʋ nosi abee ʋ naasɩ buloŋ a kpa ʋ yuwo ta gyee hal bilhuu hʋ tɩyaŋ dɩ ʋ pɩŋ doŋ kɩ wii aŋ kɩ kyaŋ ʋ nyɩŋa.” ");
INSERT INTO sig_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ɛɛ rɛ Yesu basɩ teŋ aŋ baa, “Nɩgyamaa rɛ ba yɩrɩ amɛ nala baŋmana dʋŋ nɛ ba lɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɛɛ rɛ Farasiima sii lɩɩ a vʋʋlɩ gɛɛ hʋ ba aa sɩ magɩsɩ Yesu a bara kana ʋ abee wɩpɩyɛsɩya. ");
INSERT INTO sig_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nyɛ rɛ ba tɩŋ ba hatɩnna badɔmɔŋ abee kuwori Hɛrɔtɩ hatɩnna badɔmɔŋ dɩ ba mʋ Yesu lee. Ɛɛ rɛ ba ko pɩyɛsɩ Yesu a baa, “Á nɩhɩyawʋ, á gyɩma anɩɩ ɩ kaŋ wɩtɩɩ rɛ a kɩ daga Wɩɩsɩ ŋmanɩɩ mɛ abee wɩtɩɩ. Ɩ sɩya tuwo nala wɩbasɩya tɩyaŋ. Ɩ bee fa nɩbal buloŋ sɩɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Á aa kyɛ dɩ á gyɩma rɛ anɩɩ dɩ ʋ yaa ŋmanɩɩ dɩ á tuŋ lampoo kɩ tɩya Roma paalʋʋ kuworibal hʋ koo ʋ bɩ yaa ŋmanɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amɛ Yesu fa gyɩŋ ba tɩbɩɩŋbɔmɔ hʋ rɛ, ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Mamaa minaafigi tɩmma! Bee rɛ tɩŋ ma ko dɩ ma magɩsɩ ŋ? ");
INSERT INTO sig_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ma kpa molbinʋʋ hʋ ma aa kaŋ kɩ tuŋ lampoo hʋ tɩya dɩ ŋ na.” ");
INSERT INTO sig_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ba kpaa kɩdɩgɩ tɩya ʋ, ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Kɩbee nyuu abee ʋ feŋ nɛ ba kpaa biŋ molbinʋʋ hʋ tɩyaŋ nyɛ?” ");
INSERT INTO sig_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɛɛ rɛ ba baa dɩ Roma paalʋʋ kuworibal hʋ feŋ abee ʋ nyuu rɛ. Ʋ basɩ tɩya ba a baa, “Ɛɛ kɛ, kɩŋ hʋ aa yaa Roma paalʋʋ kuworibal hʋ kɩŋ, ma kpa tɩya ʋ. Ka kɩŋ hʋ mɛ aa yaa Wɩɩsɩ kɩŋ, ma kpa tɩya Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu aa basɩ gɛɛ, ba buloŋ nyʋʋsɩ fɩyɛlɩ, ba lem-ʋ aŋ sii mʋ. ");
INSERT INTO sig_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Haŋ Kyɛɛ hʋ tɩɩ rɛ nala badɔmɔŋ ba aa yɩrɩ Sadusiima mɛ sii ko Yesu lee. Nala no kɛ gyɩ baa dɩ dɩ nal lɛ sʋba ʋ tɩɩna bɩl bɩ sɩ wuwo sii sʋʋ tɩyaŋ. Ɛɛ rɛ ba ko pɩyɛsɩ Yesu a baa, ");
INSERT INTO sig_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Á nɩhɩyawʋ, Moosi daga anɩɩ dɩ baal lɛ kpaa haaŋ, dɩ ʋ bee haaŋ hʋ bɩ lʋl biye ka dɩ baal hʋ sʋba, ʋ maga dɩ ʋ naabiye kpa lohaaŋ hʋ rɛ, dɩ ʋ beel-ʋ lʋl biisi tɩya ʋ maana hʋ. ");
INSERT INTO sig_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nɩmmabalɩya bapɛ rɛ gyɩ we daha a yaa baala. Nyɛ rɛ ba kɩhɩyawʋ tɩɩna kpaa haaŋ. Ʋ bee haaŋ hʋ bɩ lʋl biye, aŋka ʋ sʋba. Ʋ katɩyal mɛ mɩɩgɩ kpa haaŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ɛɛ rɛ ʋ katɩyal hʋ mɛ sʋba, ka too tɩɩna hʋ mɛ kpa haaŋ hʋ. Ʋ mɛ gɛɛ tɩɩ puu ʋ. Nɩmmabalɩya hʋ bapɛ buloŋ nɛ kpaa haaŋ hʋ, ka ʋ bee ba kɩdɩgɩ buloŋ bɩ lʋl biye. ");
INSERT INTO sig_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɛɛ hal tɩyaŋ haaŋ hʋ mɛ sii sʋba. ");
INSERT INTO sig_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kyɛɛ hʋ nala aa sɩ sii sʋʋ tɩyaŋ, baala no bapɛ tɩyaŋ, kɩbee rɛ sɩ tɩŋ haaŋ hʋ? Beewɩya ba buloŋ bapɛ rɛ kpaa ʋ ko baŋ kyeme.” ");
INSERT INTO sig_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma bɩ gyɩŋ Wɩɩsɩ teŋ, a bɩ gyɩŋ Wɩɩsɩ dee mɛ, ɛɛ rɛ tɩŋ ma ŋmaa naaŋ mɔɔnyɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kyɛɛ hʋ nala aa sɩ sii sʋʋ tɩyaŋ, baala bɩl bɩ sɩ paa haana, haana mɛ bɩl bɩ sɩ yal balama. Ba buloŋ sɩ kɩɩ gɛɛ anɩɩ malɩkasɩ aa we wɩɩsɩbee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Na ma pɩyɛsɩ ŋ nala aa sɩ sii sʋʋ tɩyaŋ wɩya rɛ. Ma bɩ karɩmɩ wɩya hʋ Wɩɩsɩ aa basa tɩya ma a mʋ kɩ tile sʋʋnɩ mɩɩgɩ sii tɩyaŋ ʋ teŋ tɩyaŋ? ");
INSERT INTO sig_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ʋ baa, ‘Mɩyaŋ nɛ yaa Wɩɩsɩ hʋ Abɩraham abee Azɩkɩ abee Gyeekɔbɩ buloŋ gyɩ aa tɩŋa. Wɩɩ no ʋ aa basa, ʋ daga anɩɩ Wɩɩsɩ yaa niweye Wɩɩsɩ rɛ, ʋ bɩ yaa sʋʋnɩ Wɩɩsɩ.”’ ");
INSERT INTO sig_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nɩgyamaa hʋ aa nɩɩ gɛɛ ʋ aa daga nala, ba nyʋʋsɩ fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farasiima hʋ aa nɩya anɩɩ Yesu basɩ wɩya lo Sadusiima ba nyʋʋsɩ gyʋʋ kpʋlɩya gɛɛ, ba ko yaa nyʋʋdɩgɩ a sii kpa mʋ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɛɛ rɛ ba kɩdɩgɩ aa yaa Wɩɩsɩ Teŋ dɩdagɩl kɩ lʋga dɩ ʋ magɩsɩ Yesu, a pɩyɛsɩ ʋ wɩya ");
INSERT INTO sig_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","a baa, “Nɩhɩyawʋ, Wɩɩsɩ mɩrɩsɩ hʋ tɩyaŋ, ba kɩbee rɛ yaa ba buloŋ tɩyaŋ sɩfɩyaŋ wɩɩ?” ");
INSERT INTO sig_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ɛɛ rɛ Yesu baa, “Kyo ɩ tɩɩna Wɩɩsɩ abee ɩ tɩya buloŋ, abee ɩ hakɩla buloŋ abee ɩ wɩkanɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wɩɩsɩ mɩrɩsɩ hʋ tɩyaŋ buloŋ wɩbal abee ba tɩyaŋ sɩfɩyaŋ wɩɩ rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wɩlɩya tɩɩna mɛ aa yaa sɩfɩyaŋ wɩɩ rɛ nyɛ: ‘Kyo ɩ dɔŋtɩɩna anɩɩ ɩ aa kyo ɩ tɩɩ gɛɛ.”’ ");
INSERT INTO sig_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wɩɩsɩ mɩrɩsɩ hʋ Moosi fa aa saba biŋ abee wɩya hʋ buloŋ Wɩɩsɩ tɩŋdaala hʋ aa basa, ba buloŋ lɩɩ wɩya no balɩya tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasiima hʋ ha aa laŋŋa gɛɛ, Yesu pɩyɛsɩ ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ɛɛ rɛ ma bɩɩnɩ Krisita, laataal hʋ Wɩɩsɩ aa lɩya wɩya? Kɩbee doho nal lɛ ʋ yaa?” Ɛɛ rɛ ba baa dɩ ʋ yaa Deviti nihii rɛ. ");
INSERT INTO sig_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Doŋ nɛ Yesu bɩl pɩyɛsɩ ba a baa, “Dɩ ʋ rɛ yaŋ yaa Deviti nihii, bee rɛ tɩŋ saŋa hʋ Wɩɩsɩ Wiyesi Welii hʋ fa aa ko gyʋʋ Deviti tɩyaŋ ʋ yɩrɩ Krisita hʋ ʋ Tɩɩna? ");
INSERT INTO sig_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Beewɩya Deviti fa baa: ‘Ŋ Tɩɩna Wɩɩsɩ basɩ tɩya ŋ Tɩɩna a baa, hɔŋ ŋ noduu logiŋ nɩhɔnɩɩ, a mʋ pele saŋa hʋ ŋ aa sɩ kpa ɩ dɔmɔ we ɩ nosi tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dɩ Deviti tɩɩ rɛ yaŋ yɩrɩ Krisita hʋ ʋ Tɩɩna, ɛɛ rɛ ʋ sɩ yaa a yaa ʋ nihii.” ");
INSERT INTO sig_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu aa basɩ gɛɛ, nal buloŋ bɩl bɩ wuwo laa wɩɩ basɩ. A lɩɩ haŋ kyɛɛ hʋ a kaŋ kɩ mʋ, nal buloŋ mɛ bɩl bɩ kaŋ nyuduwo ʋ aa sɩ wuwo lɩɩ sɩŋ a pɩyɛsɩ ʋ wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ɛɛ rɛ Yesu basɩ tɩya nɩgyamaa hʋ abee ʋ hatɩnna hʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wɩɩsɩ Teŋ dɩdagɩla hʋ abee Farasiima hʋ, ba aa rɛ kaŋ ŋmanɩɩ dɩ ba kɩ daga nala Wɩɩsɩ mɩrɩsɩ hʋ Moosi aa saba biŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɛɛwɩya, ma maga dɩ ma kɩ tɩŋ wɩya hʋ buloŋ ba aa baa dɩ ma kɩ yaa rɛ, amɛ ma ta kɩ kyese ba wɩyaalɩya, beewɩya ba tɩɩ bee tɩŋ wɩya hʋ ba aa daga ma. ");
INSERT INTO sig_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba aa vʋwa kyʋgɩ yoho rɛ a kpa kyʋgɩ nala, amɛ ba tɩɩ bɩ sɩ laa nyʋwa pɛ ba tɩyaŋ mʋhʋ mɛ dɩ ba wuwo kyʋŋ kyʋgɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba aa yaa wɩɩ buloŋ a kɩ kyɛ dɩ nala na ba rɛ. Ba aa sabɩ Wɩɩsɩ wɩya a we dagibiisi tɩyaŋ nɛ a kpa vʋwa ba gannɩ nosi tɩyaŋ abee ba nyupugini tɩyaŋ, aŋ leŋ ba gannɩ nyʋʋgyʋwasa mɛ doliye doliye a te ɛɛ hʋ nɩwaasɩma kɩna aa kɩya. ");
INSERT INTO sig_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dɩ ba aa rɛ yɩrɩ ba dɩ ba ko di kɩna, ba aa kyo dɩ ba hɔŋ nɩbala lɩhɔnɩya rɛ. Dɩ ba aa rɛ ko gyʋʋ wɩɩkyʋwaldɩɩsɩ mɛ, ba aa kyo dɩ ba hɔŋ nɩbala lɩhɔnɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba aa kɩ kyɛ dɩ nala kɩ kyʋwalɩ ba rɛ abee gyɩrɩma gyamaa tɩyaŋ aŋ kɩ yɩrɩ ba nɩhɩyasɩ. ");
INSERT INTO sig_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amɛ ma kɛ ta leŋ dɩ nala kaŋ ma kɩ yɩrɩ nɩhɩyasɩ, beewɩya ma buloŋ yaa nɩmmabalɩya rɛ, aŋka ma nɩhɩyawʋ mɛ yaa nɩdɩgɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ʋ bɩl bɩ maga dɩ ma yɩrɩ nal buloŋ ma kuwo dʋnɩya no tɩyaŋ, beewɩya ma Kuwo yaa nɩdɩgɩ dʋŋ nɛ a we wɩɩsɩbee tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma ta bɩl kaŋ nal buloŋ mɛ yɩrɩ ma sɩlaal, beewɩya ma sɩlaal yaa nɩdɩgɩ dʋŋ nɛ, ʋ rɛ yaa Krisita, laataal hʋ Wɩɩsɩ aa lɩya. ");
INSERT INTO sig_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ʋ maga dɩ ma tɩyaŋ sɩlaal bɩrɩmɩ haŋbiye rɛ a tʋŋ tʋma kɩ tɩya ma buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nal hʋ buloŋ aa kpa ʋ tɩɩ yohuŋ, Wɩɩsɩ sɩ kana ʋ hʋwɔlɩ, ka nal hʋ mɛ aa kaŋ ʋ tɩɩ hʋwɔlɩ, Wɩɩsɩ sɩ kpa ʋ yohuŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara yʋga! Ma kaŋ wɩɩsɩbee koro hʋ dimbeenyʋwa tɔ rɛ dɩ nala ta gyʋwa, beewɩya ma tɩɩ bee kyɛ dɩ ma gyʋʋ, aŋ pɔ dɩ nala hʋ aa lʋga dɩ ba gyʋʋ mɛ ta gyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara kɩŋkaŋ. Beewɩya ma aa kaŋ lohaana kɩna kɩ fasɩ rɛ, aŋ aa fugo kyʋwalɩ Wɩɩsɩ kɩ pɩɩsɩ. Ɛɛwɩya Wɩɩsɩ sɩ dɔgɩsɩ ma a te nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara kɩŋkaŋ. Ma aa sii duwori nɩɩ rɛ a mʋ paalʋʋ dʋŋsɩ a kɩ basɩ Wɩɩsɩ wɩya. Dɩ nɩdɩgɩ rɛ ko laa di, ma aa leŋ ʋ marɩ bɔmɔ rɛ, a maga dɩ ʋ tɩɩna gyʋʋ diŋ a na tʋwara kɩŋkaŋ anɩɩ ma mɛ aa sɩ na gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mamaa nyʋlʋŋ-sɩlaala, ma sɩ na tʋwara! Ma aa baa, “Dɩ nal lɛ ŋmɩyɛsɩ Wɩɩkyʋwaldɩɩbal hʋ, ʋ bɩ yaa ŋmɩyɛsʋʋ amɛ dɩ ʋ rɛ ko ŋmɩyɛsɩ salma kɩna hʋ aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ʋ yaa ŋmɩyɛsʋʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɛɛdɔŋ nyʋlʋŋbambugo! Salma kɩna hʋ aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ abee dɩya hʋ aa leŋ salma hʋ bɩ kaŋ bisiŋ Wɩɩsɩ sɩya tɩyaŋ, kɩna no balɩya, kɩbee rɛ yaa sɩfɩyaŋ kɩŋ? ");
INSERT INTO sig_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma bɩl basa anɩɩ dɩ nal lɛ ŋmɩyɛsɩ wɩɩsʋllɩ-kɩna kogu hʋ tɩyaŋ ba aa kpa kɩna kɩ sʋla Wɩɩsɩ, ʋ bɩ yaa ŋmɩyɛsʋʋ, amɛ dɩ ʋ rɛ ŋmɩyɛsɩ kɩŋ hʋ ba aa kpaa dɔbɔ wɩɩsʋllɩ-kɩna kogu hʋ nyuu a sʋla Wɩɩsɩ, ʋ yaa ŋmɩyɛsʋʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ma yaa nyʋlɩma rɛ, kɩŋ hʋ ba aa kpaa biŋ kogu hʋ nyuu abee wɩɩsʋllɩ-kɩna kogu hʋ aa leŋ dɩ kɩŋ hʋ bɩ kaŋ bisiŋ Wɩɩsɩ sɩya tɩyaŋ, kɩna no balɩya tɩyaŋ kɩbee rɛ yaa sɩfɩyaŋ kɩŋ? ");
INSERT INTO sig_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɛɛwɩya, dɩ nal lɛ ŋmɩyɛsɩ wɩɩsʋllɩ-kɩna kogu hʋ, ʋ ŋmɩyɛsɩ kogu hʋ bee kɩŋ hʋ buloŋ aa dɔbɔ ʋ a tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dɩ nal lɛ bɩl ŋmɩyɛsɩ Wɩɩkyʋwaldɩɩbal hʋ, ʋ ŋmɩyɛsɩ Wɩɩsɩ dɩya hʋ abee Wɩɩsɩ buloŋ nɛ, beewɩya Wɩɩsɩ we dɩya hʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dɩ nal lɛ bɩl ŋmɩyɛsɩ wɩɩsɩbee, ʋ ŋmɩyɛsɩ Wɩɩsɩ kuworikpasa hʋ abee nal hʋ aa hɔŋ ʋ tɩyaŋ buloŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara kɩŋkaŋ. Paaponni hʋ buloŋ ma aa kpa we kɩdiiliye tɩyaŋ ba sʋwala sʋma, ma aa kaŋ ba kpaa leye fi fi rɛ, a kpa lɩdɩgɩ tɩya Wɩɩsɩ. Ma aa yaa wɩmʋlla no buloŋ nɛ aŋ vɩya dɩ ma tɩŋ sɩfɩyaŋ wɩya hʋ Moosi fa aa biŋ tɩya ma anɩɩ ma kaŋ wɩtɩɩ wɩɩ buloŋ tɩyaŋ, a kɩ fá nala sikii, a kɩ tɩŋ Wɩɩsɩ abee wɩtɩɩ. Ma aa kaŋ ma kɩna kpaa leye fi fi, a kpa lɩdɩgɩ tɩya Wɩɩsɩ gɛɛ, ʋ yaa wɩwelii rɛ, amɛ ɛɛ bɩ daga dɩ ma vɩya wɩkaalɩya hʋ kɛ ta. ");
INSERT INTO sig_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mamaa nyʋlʋŋ sɩlaala! Ma aa kyuwori ma nɩɩ rɛ, a lɩɩ naŋkyʋwa ta, aŋ kpa kokumo lile. ");
INSERT INTO sig_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara kɩŋkaŋ. Beewɩya ma aa sasɩ ma nɩɩnyʋwagbaŋbiisi abee ma gbaŋsɩ hala weliŋ nɛ aŋ bee sasɩ ba tɩsɩ kɛ. Kɩdiiliye hʋ bee kɩnyʋwalɩya hʋ buloŋ aa we nɩɩnyʋwagbaŋbiisi no bee ma kɩdigbaŋsɩ hʋ buloŋ tɩyaŋ lɩɩ ma tɩbal hʋ ma aa kaŋ kɩ firimi nala lee rɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɛɛdɔŋ nyʋlɩma! Ma bɩ gyɩma anɩɩ dɩ mamaa rɛ laa sɩya sasɩ nɩɩnyʋwagbaŋbiisi no bee ma kɩdigbaŋsɩ no tɩsɩ ba hala mɛ sɩ kyaanɩ weliŋ? ");
INSERT INTO sig_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ɛɛdɔŋ minaafigi tɩmma! Ma sɩ na tʋwara kɩŋkaŋ. Beewɩya ma kɩɩ gɛɛ rɛ anɩɩ bilni ba aa kpaa tʋwɔl bʋgɩ. Ba hala aa weliye rɛ, aŋka ba tɩsɩ buloŋ su abee sʋʋnɩ hogo abee kɩpʋwanɩ iriŋ kɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɛɛ tɩɩ rɛ ma mɛ kɩɩ nala sɩya tɩyaŋ. Dɩ ba aa rɛ na ma, ba aa bɩɩnɩ nɩɩ ma yaa nɩtɩɩma rɛ, ka ma tɩsɩ su abee wɩbɔmɔ abee minaafigi wɩya. ");
INSERT INTO sig_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mamaa Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima, ma sɩ na tʋwara kɩŋkaŋ! Ma yaa minaafigi tɩmma rɛ, beewɩya ma aa saa Wɩɩsɩ tɩŋdaala abee wɩtɩɩ tɩmma bilni rɛ a marɩ ba mɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma aa baa, “Dɩ ámaa rɛ fa we doŋ saŋa hʋ tɩyaŋ á naabaala fa aa we ba mɩɩbolo tɩyaŋ, á fa bɩ sɩ laa nyʋwa pɛ ba tɩyaŋ dɩ ba kpʋ Wɩɩsɩ tɩŋdaala hʋ.” ");
INSERT INTO sig_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma wɩbasɩya kɔnɩ daga anɩɩ ma yaa nala hʋ aa kpʋʋ Wɩɩsɩ tɩŋdaala hʋ doho nala rɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wɩbɔmɔ hʋ ma naabaala aa piile, ma mɛ kaŋ teŋsi. ");
INSERT INTO sig_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Na ba aa bɔmɔ gɛɛ anɩɩ dʋma! Ma bɩɩna anɩɩ ma sɩ wuwo fá gɛ diŋ gyʋʋyɩ rɛ koo? ");
INSERT INTO sig_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ŋ basɩ kɩ tɩya ma rɛ anɩɩ, ŋ sɩ tɩŋ Wɩɩsɩ tɩŋdaala abee wɩgyʋnna abee dɩdagɩla dɩ ba ko ma lee. Ma sɩ kpʋ badɔmɔŋ, a kaŋ badɔmɔŋ kpaasɩ mal daagarɩɩ tɩyaŋ, a vɩɩrɩ badɔmɔŋ mɛ ma wɩɩkyʋwaldɩɩsɩ tɩyaŋ, aŋ gɔllɩ kil badɔmɔŋ mɛ kɩ baŋ tɔnɩ tɩyaŋ a kɩ kyɛ dɩ ma kpʋ ba. ");
INSERT INTO sig_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɛɛwɩya, Wɩɩsɩ sɩ dɔgɩsɩ ma akuu ba aa kpʋ nɩtɩɩma hʋ wɩya, a piili Abɛl tɩyaŋ a mʋ pele saŋa hʋ tɩyaŋ ba aa kpʋʋ Barakiya biibaal Zakarɩya. Ba gyɩ kpʋʋ Zakarɩya Wɩɩkyʋwaldɩɩbal hʋ abee wɩɩsʋllɩ-kɩna kogu hʋ nyuu ba aa nyɔgɔ pʋsɩ kɩ tɩya Wɩɩsɩ paga tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nala no ba aa kpʋwa, ba haakye buloŋ dɔbɔ ma gyɩnaŋ nala nyuu tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mamaa Gyerusalɛm nala, Wɩɩsɩ tɩŋ ʋ tɩŋdaala ma lee rɛ, ma kpʋ badɔmɔŋ a paa bʋwa yaga badɔmɔŋ mɛ. Saŋa buloŋ nɛ ŋ fa kyo dɩ ŋ puŋ tɔ ma buloŋ anɩɩ gyimii aa puŋ tɔ ʋ balɩya gɛɛ, ka ma bɩ laa nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɛɛwɩya, Wɩɩsɩ sɩ baanɩ ma bee tɩya ma dɩ ʋ pɩŋ gyikpiye. ");
INSERT INTO sig_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ŋ basɩ kɩ tɩya ma rɛ, ma bɩl bɩ sɩ na ŋ, see saŋa hʋ tɩyaŋ ma aa sɩ lɔllɩ ŋ a baa, ‘Nyusʋŋtɩɩna rɛ yaa nal hʋ aa ko Wɩɩsɩ feŋ tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu gyɩ aa sii lɩɩ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ a kɩ mʋ, ɛɛ rɛ ʋ hatɩnna hʋ ko ʋ lee a basɩ tɩya ʋ a baa, “Tɩɩna, deŋ na Wɩɩkyʋwaldɩɩbal no bee dɩɩsɩ no buloŋ aa sɩŋ doŋ aa weliye gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɛɛ rɛ Yesu baa, “Ma tɩɩ naa gɛɛ ba aa weliye rɛ, amɛ wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ba sɩ maakyiye ŋmaa dɩɩsɩ no buloŋ lo. Bʋdɩgɩ mɛ gba bɩl bɩ sɩ ka a dɔbɔ ʋ dɔŋtɩɩna tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɛɛ rɛ Yesu gyɩ mʋ hɔŋ Olivi dogimo hʋ nyuu tɩyaŋ, doŋ nɛ ʋ hatɩnna hʋ dʋŋ sii ko ʋ lee a pɩyɛsɩ ʋ a baa, “Saŋa bee tɩyaŋ nɛ wɩya no sɩ yaa? Bekiŋ wɩmagɩl lɛ á sɩ na a gyɩŋ saŋa hʋ tɩyaŋ ɩ aa sɩ mɩɩgɩ ko, abee saŋa hʋ dʋnɩya aa sɩ teŋ?” ");
INSERT INTO sig_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Doŋ nɛ Yesu basɩ tɩya ba a baa, “Ma gyɩŋ tɩya ma tɩɩ weliŋ dɩ nal buloŋ ta ko mʋrɩ ma. ");
INSERT INTO sig_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Beewɩya, nala yʋga aa sɩ ko kpa ŋ feŋ anɩɩ ba aa rɛ yaa Krisita hʋ, a mʋrɩ nɩgyamaa. ");
INSERT INTO sig_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma sɩ nɩɩ yuwo dɔmɔ lee buloŋ tɩyaŋ. Dɩ mamaa rɛ ko nɩɩ gɛɛ, ma ta leŋ dɩ ma bembiye kɩ sii. Beewɩya wɩya no buloŋ sɩ yaa, amɛ ɛɛ bɩ daga anɩɩ dʋnɩya tenii pele rɛ. ");
INSERT INTO sig_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yuwo sɩ we dʋnɩya logiŋ buloŋ tɩyaŋ. Losi mɛ sɩ gyʋʋ, ka dɩ taŋha mɛ gyigili lɩgyamaa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wɩya no buloŋ kɩɩ gɛɛ rɛ anɩɩ haluwokannɩ luwol aa piile kɩ wɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ɛɛ tɩyaŋ ba sɩ kasɩ ma a kpa ma we nala nosi tɩyaŋ dɩ ba dɔgɩsɩ ma aŋ kpʋ ma. Dʋnɩya nala buloŋ sɩ kuu ŋ wɩya a haasɩ ma. ");
INSERT INTO sig_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Haŋ saŋa hʋ tɩyaŋ nɩgyamaa sɩ kpa ba Wɩɩsɩ laadii ta. Ba sɩ kaŋ gyamba bee dɔmɔŋ a haasɩ dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nala hʋ aa nyɩya wɩya a baa ba yaa Wɩɩsɩ tɩŋdaala rɛ, ba sɩ yʋga a ko a mʋrɩ nɩgyamaa. ");
INSERT INTO sig_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wɩbɔmɔ yayɩ sɩ pʋrɩgɩ, dɩ ɛɛ leŋ nala kyori mɛ teŋ abee dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amɛ nal hʋ buloŋ aa sɩ wuwo di kenyiri a kaŋ mala a mʋ teŋ, Wɩɩsɩ sɩ laa ʋ ta. ");
INSERT INTO sig_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ba sɩ laa sɩya basɩ Wɩɩsɩbee koro hʋ wɩweliye lee buloŋ tɩyaŋ dɩ dʋnɩya nal buloŋ nɩɩ, ɛɛ hal tɩyaŋ nɛ dʋnɩya tenii sɩ pele. ");
INSERT INTO sig_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dɩ mamaa rɛ ko na kɩbɔŋlɔrɩ hʋ aa yaa sɩna hʋ wɩya Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Danɩyɛl tɩyaŋ a basɩ, dɩ ʋ sɩŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ʋ maga dɩ ma nala hʋ aa karɩmɩ wɩya no lʋga rɛ aŋ gyɩŋ ba memii. ");
INSERT INTO sig_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Dɩ mamaa rɛ ko na gɛɛ, ʋ maga dɩ nala hʋ aa we Gyudɩya paalʋʋ tɩyaŋ fá gyɩŋ dogiŋsi nyuni rɛ a faŋa. ");
INSERT INTO sig_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dɩ nal lɛ we salnyuu tɩyaŋ, ʋ ta bɩl baa ʋ tuu gyʋʋ dɩya a paa ʋ kɩna. ");
INSERT INTO sig_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dɩ nal buloŋ nɛ we ʋ baga tɩyaŋ, ʋ ta bɩl baa ʋ mɩɩgɩ mʋ dɩya a paa ʋ gannɩ. ");
INSERT INTO sig_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Haŋ saŋa hʋ tɩyaŋ, haluwokanna bee biifɩllɩ nɩmma sɩ na tʋwara kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ma kɩ sʋla Wɩɩsɩ dɩ kyɛ hʋ ma aa si fá ta ko yaa puwo saŋa koo Kyɛwiyesii hʋ kyɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Beewɩya Wɩɩsɩ aa mara dʋnɩya a kaŋ kɩ ko gyɩnaŋ, nal buloŋ ha bɩ naa tʋwara no iriŋ, nal mɛ bɩl bɩ sɩ na tʋwara no iriŋ a kaŋ kɩ mʋ maakyiye buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dɩ Wɩɩsɩ rɛ fa bɩ kere kyɛyɛ hʋ wɩya no aa sɩ yaa ta, nɩdɩgɩ mɛ fa bɩ sɩ ka beewɩya tʋwara hʋ aa sɩ ko sɩ lɔrɩ rɛ kɩŋkaŋ. Amɛ akuu nala hʋ ʋ aa lɩya wɩya, ʋ sɩ kere kyɛyɛ hʋ ta. ");
INSERT INTO sig_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Saŋa no tɩyaŋ dɩ nal buloŋ nɛ ko basɩ tɩya ɩ a baa, ‘Na Krisita hʋ we daha, koo ʋ we lee kɩdɩgɩ, ta laa ʋ tɩɩna di.’ ");
INSERT INTO sig_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Beewɩya nala badɔmɔŋ sɩ sii nyɩya wɩya dɩ ba aa rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya. Dɩ badɔmɔŋ mɛ sɩ sii fugo baa dɩ ba yaa Wɩɩsɩ tɩŋdaala rɛ. Ba sɩ yaa wɩmagɩla abee wɩkperiye buloŋ a kɩ kyɛ dɩ ba mʋrɩ nala hʋ Wɩɩsɩ aa lɩya mɛ gba. ");
INSERT INTO sig_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma gyegil daha! Ŋ basɩ wɩya no buloŋ kɩ tɩya ma rɛ, ka dɩ saŋa hʋ na pele. ");
INSERT INTO sig_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ɛɛwɩya, dɩ nal buloŋ nɛ ko basɩ tɩya ma anɩɩ laataal hʋ Wɩɩsɩ aa lɩya rɛ we pogo tɩyaŋ, ma ta mʋʋ doŋ, koo dɩ ba aa rɛ basɩ tɩya ma anɩɩ ʋ rɛ faŋa daha, ma ta laa di, ");
INSERT INTO sig_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","beewɩya saŋa hʋ tɩyaŋ mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, ʋ sɩ kɩɩ gɛɛ rɛ anɩɩ duwoŋ aa lɩgɩsa, a kyaanɩ wɩɩsɩnyuu buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lee hʋ buloŋ kɩpʋwa aa pɩna, doŋ nɛ duuno aa kɩ laŋŋɩ.” ");
INSERT INTO sig_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Tʋwara no tenii hal tɩyaŋ, ʋ bɩl bɩ sɩ pɩɩsɩ ka dɩ wɩɩsɩ bɩl bɩ sɩ kɩ pɔsɔ, pene mɛ bɩl bɩ sɩ kɩ pɔsɔ. Kyɩŋwʋlɩya sɩ lɩɩ wɩɩsɩnyuu a ko tuu kɩ tele. Wɩɩsɩnyuu kɩna buloŋ sɩ sii lɩɩ ba liweeliye tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɛɛ tɩyaŋ nɛ ma sɩ na mɩyaŋ Nihuwobiŋ Biye magɩl wɩɩsɩnyuu tɩyaŋ. Dɩ dʋnɩya nala rɛ ko na magɩl no ba buloŋ sɩ wii. Ɛɛ tɩyaŋ nɛ ma yaŋ sɩ na mɩyaŋ Nihuwobiŋ Biye, dɩ ŋ ko kɩ tuu abee gaŋdarɩ abee dee. ");
INSERT INTO sig_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɛɛ tɩyaŋ ba sɩ mʋʋ kabɩl dɩ ʋ kyɩyamɩ laa lee buloŋ, ka dɩ Wɩɩsɩ tɩŋ ʋ malɩkasɩ dɩ ba mʋ lee kɛ buloŋ a kaŋ nala hʋ buloŋ ʋ aa lɩya dɩ ba kɩ tɩŋa ʋ ko laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Dɩ ma ko na tɩɩsɩ aa tɔsɩ, ma aa gyɩma anɩɩ yʋʋ kpaga rɛ. Ʋ maga dɩ ma gʋnnɩ wɩgyʋŋ nɛ a lɩɩ wɩɩ no tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɛɛ tɩɩ rɛ dɩ mamaa rɛ ko na wɩya no buloŋ aa yaa, ma gyɩma anɩɩ mɩyaŋ nihuwobiŋ Biye koyi mɛ kɔnɩ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma gyɩnaŋ nala aa we ma mɩɩbol tɩyaŋ, ma buloŋ bɩ sɩ sʋba ka dɩ wɩya no yaa baŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wɩɩsɩnyuu abee taŋha buloŋ sɩ teŋ, amɛ wɩya hʋ ŋ aa basa kɛ sɩ we doŋ a kaŋ kɩ mʋ maakyiye buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nal buloŋ bɩ gyɩŋ kyɛɛ hʋ wɩya no aa sɩ yaa. Malɩkasɩ aa we wɩɩsɩbee tɩyaŋ mɛ gba paalɩ bɩ gyɩma, see ŋ Kuwo Wɩɩsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Saŋa hʋ tɩyaŋ mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, ʋ sɩ kɩɩ gɛɛ anɩɩ wɩya hʋ gyɩ aa yaa saŋa hʋ Nowa gyɩ aa we ʋ mɩɩbol tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ka dɩ duwoŋ hʋ gyɩ na nɩɩ a su dʋnɩya buloŋ, nala gyɩ aa di kɩdiiliye rɛ, a kɩ nyʋwa sɩŋ. Baala kɩ paa haana, haana mɛ kɩ yala balama, a mʋ pele kyɛɛ hʋ Nowa gyɩ aa gyʋʋ nɩɩduworiboro hʋ. ");
INSERT INTO sig_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba gyɩ bɩ gyɩŋ wɩɩ hʋ buloŋ aa yaa see saŋa hʋ tɩyaŋ nɩɩ hʋ aa ko paa ba buloŋ mʋ. Ɛɛ tɩɩ rɛ sɩ yaa saŋa hʋ mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Saŋa no tɩyaŋ baala balɩya sɩ kɩ pala baga tɩyaŋ dɩ Wɩɩsɩ ko kpa kɩdɩgɩ aŋ leŋ kɩdɩgɩ ta. ");
INSERT INTO sig_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Haana balɩya mɛ sɩ kɩ nɔŋ muŋ nɔŋ tɩyaŋ dɩ Wɩɩsɩ ko kpa kɩdɩgɩ aŋ leŋ kɩdɩgɩ ta. ");
INSERT INTO sig_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ɛɛwɩya ma yaŋ gyɩŋ tɩya ma tɩɩ weliŋ, beewɩya ma bɩ gyɩŋ kyɛɛ hʋ ma Tɩɩna aa sɩ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma tɩɩ gyɩma rɛ weliŋ anɩɩ dɩ nal lɛ gyɩŋ saŋa hʋ tɩyaŋ gaal aa sɩ ko bori ʋ dɩya gyʋʋ a gaa ʋ kɩna, ʋ sɩ bara doo, a hɔŋ pɔ dɩ gaal hʋ ta ko bori ʋ dɩya a gyʋʋ gaa ʋ kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ma mɛ yaŋ yaa siri pɔ, beewɩya mɩyaŋ Nihuwobiŋ Biye sɩ mɩɩgɩ ko saŋa hʋ tɩyaŋ ma aa bɩ yɩyɛla.” ");
INSERT INTO sig_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ɛɛ rɛ á Tɩɩna Yesu mɩɩgɩ basɩ tɩya ba a baa, “Ŋ aa kyɛ dɩ ma kɩɩ tʋŋtʋnnɩ hʋ aa gyɩŋ wɩya a kɩ tɩŋ ʋ nɩhɩyawʋ nyʋwa rɛ. Ʋ rɛ yaa tʋŋtʋnnɩ hʋ ʋ nɩhɩyawʋ hʋ aa sɩ lɩɩ dɩ ʋ kɩ deŋ ʋ dɩya, aŋ pɛ kɩ tɩya ʋ tʋŋtʋnnɩ-dɔŋtɩŋsɩ hʋ mɛ ba kɩdiiliye saŋa hʋ aa maga dɩ ʋ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dɩ tʋŋtʋnnɩ no rɛ yaa wɩya hʋ ʋ nɩhɩyawʋ hʋ aa daga ʋ dɩ ʋ yaa, ʋ teŋ sɩ fɩyɛlɩ weliŋ kyɛɛ hʋ ʋ nɩhɩyawʋ hʋ aa sɩ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ʋ nɩhɩyawʋ hʋ sɩ kpa ʋ kɩna buloŋ we tʋŋtʋnnɩ no nosi tɩyaŋ dɩ ʋ kɩ deŋ. ");
INSERT INTO sig_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amɛ dɩ ʋ rɛ yaa tʋŋtʋnnɩbɔŋ, ʋ aa basɩ tɩya ʋ tɩɩ rɛ a baa, ‘Ŋ nɩhɩyawʋ hʋ bɩ sɩ ko lagɩlagɩ no. Ʋ sɩ pɩɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ka dɩ ʋ yaŋ piili kɩ dɔgɩsɩ ʋ tʋŋtʋnnɩ-dɔŋtɩŋsɩ hʋ aŋ kɩ di kɩdiiliye hʋ yʋga yʋga, aŋ gɔllɩ tɩŋ sɩnyʋwala hal a nyʋwa sɩŋ bugo kɩ baŋ, ");
INSERT INTO sig_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","wɩya no tɩyaŋ nɛ ʋ sɩ we kɩ yaa dɩ ʋ nɩhɩyawʋ hʋ mɩɩgɩ ko pirigi ʋ tɩyaŋ dɩ ʋ bɩ yɩyɛla. ");
INSERT INTO sig_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ʋ sɩ dɔgɩsɩ ʋ weliŋ aŋ leŋ dɩ ʋ mɛ na tʋwara hʋ nala aa fugo baa ba aa tɩŋ Wɩɩsɩ aa naa. Haŋ tʋwara hʋ tɩyaŋ nɛ ba sɩ we a kɩ wii aŋ kɩ kyaŋ ba nyɩŋa.” ");
INSERT INTO sig_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ɛɛ rɛ Yesu bɩl maga namaga a baa, “Kyɛɛ hʋ wɩya no buloŋ aa sɩ yaa, wɩɩsɩbee koro hʋ sɩ kɩɩ gɛɛ anɩɩ hatoliye fi aa sii tebine kɩdɩgɩ a paa ba fɩŋtɩŋsɩ a mʋ dɩ ba kyeŋ hafalɩɩ bala. ");
INSERT INTO sig_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hatoliye no tɩyaŋ, bɔnɔŋ gyɩ yaa bambugo rɛ, ka bɔnɔŋ mɛ gyɩ yaa wɩgyʋnna. ");
INSERT INTO sig_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bambugo hʋ gyɩ bɩ lɔgɔ nʋʋ kolo, dɩ ba fɩŋtɩŋsɩ hʋ rɛ ko dɩsɩ dɩ ba fa kpa we. ");
INSERT INTO sig_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ka wɩgyʋnna hʋ kɛ gyɩ lɔgɔ nʋʋ we bumbuŋiye tɩyaŋ a kolo. ");
INSERT INTO sig_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hafalɩɩ hʋ bala hʋ gyɩ pɩɩsa rɛ weliŋ, ɛɛ rɛ hatoliye hʋ buloŋ mɛ gyɩ hɔŋ dɩyɛgɩ dɩyɛgɩ lɔlɔ aŋ kpa doo pɩŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ʋ tekere vɩʋ̃ʋ̃, nal kɩdɩgɩ heeli a baa, “Hafalɩɩ bala hʋ rɛ aa ko! Ma ko lɩɩ mʋ kyeme ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ɛɛ rɛ hatoliye hʋ buloŋ sii a kaŋ ba fɩŋtɩŋsɩ ŋmasɩ turo ta ba gyɩŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Doŋ nɛ bambugo hʋ basɩ tɩya wɩgyʋnna hʋ a baa, “Á fɩŋtɩŋsɩ hʋ aa kyɛ dɩ ba dɩsɩ rɛ, ma tɩya ma nʋʋ hʋ mʋhʋ mʋhʋ.” ");
INSERT INTO sig_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ɛɛ rɛ wɩgyʋnna hʋ basɩ tɩya ba a baa, “Aayɩ, nʋʋ hʋ bɩ sɩ pele á beel-ma buloŋ. Ma mʋ kyɛ yɔbɔ ma tɩɩ nʋʋ.” ");
INSERT INTO sig_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ɛɛ rɛ ba sii kpa mʋ dɩ ba yɔbɔ nʋʋ hʋ. Ba aa mʋʋ tɩyaŋ nɛ, ka hafalɩɩ bala hʋ mɛ ko. Hatoliye hʋ bɔnɔŋ gyɩ aa yaa siri hɔŋ hʋ sii tɩŋa ʋ hal gyʋʋ hafalɩɩ gbɩyala hʋ lee, ka ba kaŋ dimbee hʋ tɔ. ");
INSERT INTO sig_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ʋ hal tɩyaŋ nɛ hatoliye hʋ aa mʋʋ dɩ ba yɔbɔ nʋʋ hʋ mʋ kpa ko a ŋmaa dimbeenyʋwa aŋ baa, ‘Á nɩhɩyawʋ, á aa sʋla ɩ, ha kaŋ suri tɩya ma dɩ á gyʋʋ.”’ ");
INSERT INTO sig_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ɛɛ rɛ ʋ baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ŋ bɩ gyɩŋ ma.” ");
INSERT INTO sig_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu aa maga namaga no ko teŋ ʋ baa, “Ma yaŋ gyɩŋ tɩya ma tɩɩ weliŋ beewɩya ma bɩ gyɩŋ kyɛɛ hʋ koo saŋa hʋ mɩyaŋ nihuwobiŋ Biye aa sɩ mɩɩgɩ ko.” ");
INSERT INTO sig_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ɛɛ rɛ Yesu bɩl kaŋ namaga a daga wɩɩsɩbee koro hʋ wɩya a baa, “Saŋa no tɩyaŋ wɩɩsɩbee koro hʋ sɩ kɩɩ gɛɛ anɩɩ baal kɩdɩgɩ aa sii dɩ ʋ vala ŋmanɩɩ. Ɛɛ rɛ ʋ yɩrɩ ʋ tʋŋtʋnna a kpa ʋ kɩna we ba nosi tɩyaŋ dɩ ba kɩ deŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ʋ gyɩ kaŋ kɩna hʋ kpaa ba a maga gɛɛ hʋ nal buloŋ aa sɩ wuwo kɩ deŋ nɛ. Ʋ gyɩ kpaa molbiye tusi bɔnɔŋ nɛ a tɩya kɩdɩgɩ dɩ ʋ kɩ deŋ, a kpa tusi bʋlɩya tɩya kɩdɩgɩ mɛ, aŋ kpa tusi mɛ tɩya kɩdɩgɩ hʋ mɛ. Ɛɛ rɛ ka ʋ kpa mʋ ŋmanɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tʋŋtʋnnɩ hʋ aa laa molbiye tusi bɔnɔŋ hʋ kaŋ mʋ a tʋŋ tʋma a bɩl na tusi bʋnɔŋ tɔnɔ pɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tʋŋtʋnnɩ hʋ mɛ aa laa molbiye tusi balɩya hʋ, ʋ mɛ kaŋ ʋ kɩna kɩ bɩrɩmɩ, a mɛ na molbiye tusi bʋlɩya tɔnɔ a pɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amɛ tʋŋtʋnnɩ hʋ aa laa tusi hʋ, ʋ kɛ kaŋ ʋ kɩna mʋ hul bʋwa a kpa hogo. ");
INSERT INTO sig_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ʋ gyɩ pɩɩsa rɛ weliŋ ka ba nɩhɩyawʋ hʋ gyɩ na ko a yɩrɩ ba dɩ ʋ na ba kɩdɩgɩ buloŋ aa kpaa ʋ molbiye yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tʋŋtʋnnɩ hʋ aa laa tusi bʋnɔŋ hʋ kaŋ ʋ kɩna ko gyʋʋ a basɩ tɩya ʋ nɩhɩyawʋ a baa, ‘Molbiye tusi bʋnɔŋ nɛ ɩ tɩya ŋ, ŋ mɛ naa tusi bʋnɔŋ nɛ a pɛ.’ ");
INSERT INTO sig_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Doŋ nɛ ʋ nɩhɩyawʋ hʋ basɩ tɩya ʋ a baa, ‘Gyaaŋbiye, ɩ yaa tʋŋtʋnnɩtɩɩ rɛ. Ɩ kɔnɩ daga nɩɩ ɩ yaa wɩtɩɩ tɩɩna rɛ. Ɛɛwɩya ɩ aa wuwo deŋ kɩbiye nyuu weliŋ nyɛ ŋ sɩ leŋ dɩ ɩ kɩ deŋ kɩgyamaa. Ŋ teŋ fɩyɛla rɛ weliŋ abee wɩɩ hʋ ɩ aa yaa. Ɛɛwɩya ŋ aa kyɛ dɩ ɩ mɛ teŋ fɩyɛlɩ rɛ a beel ŋ.’ ");
INSERT INTO sig_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ɛɛ rɛ tʋŋtʋnnɩ hʋ mɛ aa laa molbiye tusi bʋlɩya hʋ mɛ kaŋ ʋ kɩna ko gyʋʋ a basɩ tɩya ʋ nɩhɩyawʋ hʋ a baa, ‘Ŋ nɩhɩyawʋ, ɩ aa tɩya ŋ molbiye tusi bʋlɩya hʋ, na, ŋ mɛ naa tusi bʋlɩya rɛ a pɛ.’ ");
INSERT INTO sig_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Doŋ nɛ ʋ basɩ tɩya ʋ mɛ a baa, ‘Gyaaŋbiye, ɩ yaa tʋŋtʋnnɩtɩɩ rɛ. Ɩ kɔnɩ daga nɩɩ ɩ yaa wɩtɩɩ tɩɩna rɛ. Ɩ aa wuwo deŋ kɩbiye nyuu weliŋ nyɛ ŋ sɩ leŋ dɩ ɩ kɩ deŋ kɩgyamaa. Ŋ teŋ fɩyɛla rɛ weliŋ abee wɩɩ hʋ ɩ aa yaa. Ɛɛwɩya ŋ aa kyɛ dɩ ɩ teŋ mɛ fɩyɛlɩ rɛ a beel-ŋ.’ ");
INSERT INTO sig_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nyɛ rɛ tʋŋtʋnnɩ hʋ ʋ aa kpaa molbiye tusi hʋ tɩya mɛ ko gyʋʋ a baa, ‘Ŋ nɩhɩyawʋ, ŋ gyɩma anɩɩ ɩ kaŋ tɩbal lɛ weliŋ, ɩ aa kɩ kʋŋ kɩna ɩ aa bɩ doho rɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ɛɛ rɛ tɩŋ kambɩŋ kana ŋ, ŋ hul bʋwa a kpa molbiye hʋ a hogo. Na ɩ molbiye. Laa ɩ kɩna.’ ");
INSERT INTO sig_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ɛɛ rɛ ʋ nɩhɩyawʋ hʋ basɩ tɩya ʋ a baa, ‘Ɩ yaa tʋŋtʋnnɩbɔŋ nɛ a kaŋ teŋwɩɩ mɛ. Ɩ aa gyɩma anɩɩ ŋ aa kɩ kʋŋ kɩna ŋ aa bɩ doho, ");
INSERT INTO sig_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ʋ fa maga dɩ ɩ kpa ŋ molbiye hʋ mʋ biŋ lee hʋ tɩyaŋ ba aa biŋ molbiye rɛ. Ŋ fa aa mɩɩgɩ ko nyɛ, ŋ fa sɩ laa molbiye hʋ abee ŋ tɔnɔ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ma kaŋ molbiye hʋ laa ʋ lee, a kpa tɩya nal hʋ aa kaŋ molbiye tusi fi hʋ. ");
INSERT INTO sig_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nal hʋ aa kaŋ kɩna yʋga, Wɩɩsɩ sɩ marɩ tɩya ʋ pɛ, amɛ nal hʋ aa bɩ kaŋ kɩna yʋga, mʋhʋ hʋ mɛ ʋ aa kana, Wɩɩsɩ sɩ kaŋ laa ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma kaŋ tʋŋtʋnnɩ tɔɔ no lɩɩ yuwo ta dɩ ʋ we bilhuu tɩyaŋ. Doŋ tɩyaŋ nɛ nala hʋ aa vɩya Wɩɩsɩ sɩ we a kɩ wii aŋ kɩ kyaŋ ba nyɩŋa.”’ ");
INSERT INTO sig_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Saŋa hʋ mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko abee gaŋdarɩ, ŋ bee malɩkasɩ buloŋ nɛ sɩ ko. Ɛɛ tɩyaŋ nɛ ŋ sɩ hɔŋ ŋ gaŋdaa-kuworikpasa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aŋka dɩ dʋnɩya nala buloŋ ko laŋŋɩ ŋ sɩya tɩyaŋ. Ŋ sɩ kaŋ ba porigi leye balɩya anɩɩ pedaal aa kaŋ ʋ piyese porigi bʋʋna tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ŋ sɩ leŋ dɩ tɩpʋlʋŋ tɩmma hʋ sɩŋ ŋ noduu, ka dɩ nɩbɔmɔ hʋ mɛ sɩŋ ŋ nogɔbɔ. ");
INSERT INTO sig_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Doŋ tɩyaŋ nɛ ŋ sɩ basɩ tɩya nala hʋ aa sɩŋ ŋ noduu a baa, “Ma ko, ma nala hʋ ŋ Kuwo Wɩɩsɩ aa yaa wɩwelii tɩya. Ma ko di wɩɩsɩ koro hʋ ʋ aa mara biŋ ma a lɩɩ dʋnɩya piili tɩyaŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Beewɩya, losi gyɩ aa kana ŋ nɛ, ma yaa kɩdiiliye tɩya ŋ, nɩɩnyʋwasɩ gyɩ kana ŋ ma yaa nɩɩ tɩya ŋ, ŋ nyʋwa. Ŋ gyɩ yaa nɩhʋwal lɛ, ma kana ŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ŋ gyɩ kaŋ teŋbil lɛ, ma kpa gal laalɩ ŋ. Ŋ gyɩ aa wɩɩlɩ lɛ, ma deŋ ŋ lee weliŋ. Ba gyɩ kana ŋ tɔ dɩyaŋ nɛ, ma ko na ŋ.” ");
INSERT INTO sig_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Doŋ tɩyaŋ nɛ tɩpʋlʋŋ tɩmma hʋ sɩ pɩyɛsɩ ʋ a baa, “Á Tɩɩna, kyɛbee rɛ á naa ɩ dɩ losi kana ɩ, á tɩya ɩ kɩdiiliye? Kyɛbee rɛ nɩɩnyʋwasɩ kana ɩ, á yaa nɩɩ tɩya ɩ? ");
INSERT INTO sig_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kyɛbee rɛ á naa ɩ dɩ ɩ yaa nɩhʋwal, á kana ɩ weliŋ, koo kyɛbee rɛ á naa ɩ dɩ ɩ kaŋ teŋbil á kpa gal laalɩ ɩ? ");
INSERT INTO sig_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kyɛbee rɛ á naa ɩ dɩ ɩ aa wɩɩlɩ, koo dɩ ba kana ɩ tɔ dɩyaŋ, á ko na ɩ?” ");
INSERT INTO sig_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Doŋ nɛ ŋ sɩ basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, saŋa hʋ buloŋ ma aa yaa wɩwelii a tɩya ŋ naabalɩya no tɩyaŋ nɩbiye, mɩyaŋ nɛ ma yaa tɩya gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Doŋ tɩyaŋ nɛ ŋ sɩ basɩ tɩya nala hʋ aa sɩŋ ŋ nogɔbɔ a baa, “Ma fasɩ lɩɩ ŋ sɩya tɩyaŋ! Wɩɩsɩ vɩya ma wɩya rɛ. Ma mʋ gyʋʋ diŋ hʋ aa bɩ sɩ maakyiye dɩsɩ, diŋ hʋ Wɩɩsɩ aa wee biŋ Sɩtaanɩ bee ʋ noŋ nala. ");
INSERT INTO sig_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Beewɩya saŋa hʋ tɩyaŋ losi gyɩ aa kana ŋ, ma bɩ yaa kɩdiiliye tɩya ŋ, nɩɩnyʋwasɩ gyɩ kana ŋ nɛ ma bɩ yaa nɩɩ tɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ŋ gyɩ yaa nɩhʋwal lɛ ma bɩ kana ŋ weliŋ. Ŋ gyɩ kaŋ teŋbil lɛ, ma bɩ kpaa gal laalɩ ŋ. Ŋ gyɩ aa wɩɩlɩ rɛ ma bɩ deŋ ŋ, ba gyɩ kana ŋ tɔ dɩyaŋ mɛ, ma bɩ ko na ŋ.” ");
INSERT INTO sig_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Doŋ nɛ ba sɩ pɩyɛsɩ ŋ a baa, “Á Tɩɩna, kyɛbee rɛ losi kana ɩ, koo nɩɩnyʋwasɩ kana ɩ, koo ɩ gyɩ yaa nɩhʋwal koo, ɩ gyɩ kaŋ teŋbil koo, ɩ gyɩ kɩ wɩɩlɩ koo, ba kana ɩ tɔ dɩyaŋ aŋ ka á bɩ kyiyeli ɩ?” ");
INSERT INTO sig_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ŋ yaŋ sɩ baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, saŋa hʋ buloŋ ma aa vɩya dɩ ma kyiyeli nala no tɩyaŋ nɩbiye, mɩyaŋ nɛ ma vɩya kyiyelii gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wɩɩsɩ sɩ leŋ dɩ nala no mʋ gyʋʋ lee hʋ ba aa sɩ na tʋwara a kaŋ kɩ mʋ deŋdeŋ, aŋka dɩ tɩpʋlʋŋ tɩmma hʋ mɛ kaŋ mɩɩbol hʋ aa bɩ tenii.” ");
INSERT INTO sig_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu aa daga nala hʋ wɩya no buloŋ ko teŋ, ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ma tɩɩ gyɩma anɩɩ kyɛyɛ balɩya rɛ kaa ka dɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ pele. Saŋa no tɩyaŋ nɛ ba sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye a kpa ŋ tɩya ŋ dɔmɔ dɩ ba kpaasɩ ŋ mal daagarɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee nɩhɩyasɩ, gyɩ ko laŋŋɩ Kayifasɩ dɩya tɩyaŋ nɛ. Saŋa no tɩyaŋ dɩ Kayifasɩ rɛ yaa Gyuuma wɩɩkyʋwal sɩlaala hʋ nɩhɩyawʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Doŋ tɩyaŋ nɛ ba vʋʋlɩ gɛɛ hʋ ba aa sɩ yaa a lʋwɔlɩ kaŋ Yesu kpʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba baa dɩ ʋ bɩ maga ba kana ʋ kyɛbal hʋ kyɛɛ, beewɩya dɩ ba aa rɛ yaa gɛɛ, gyamaa hʋ sɩ laa taawɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ɛɛ hal lɛ Yesu gyɩ sii kpa mʋ Bɛɛtani, a mʋ gyʋʋ gbegi-werisi kɩdɩgɩ ba aa yɩrɩ Siimɔŋ dɩya. ");
INSERT INTO sig_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Doŋ tɩyaŋ nɛ Yesu gyɩ hɔŋ kɩ di kɩna, haaŋ kɩdɩgɩ ko gyʋʋ a kaŋ pʋrʋŋtʋwa abee tʋranɩɩ ko bɩsɩ we Yesu nyuu tɩyaŋ. Tʋranɩɩ hʋ yalɩɩ gyɩ hayɛ rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ʋ hatɩnna hʋ aa naa gɛɛ, ba baaŋ sii. Ba gʋrɩmɩ wɩya kɩ pɩyɛsɩ dɔmɔŋ a baa, “Bee rɛ tɩŋ haaŋ no kaŋ tʋranɩɩ no kyogi ta nyɛ? ");
INSERT INTO sig_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Deŋ naa, dɩ ba aa rɛ fa kpaa tʋranɩɩ no yallɩ na ba aa na mogyamaa rɛ dɩ ba fa kyiyeli nyaaba.” ");
INSERT INTO sig_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amɛ Yesu fa gyɩŋ wɩɩ hʋ ba aa basɩ rɛ. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ dɔŋ haaŋ no nyɛ? Wɩwelii rɛ ʋ yaa tɩya ŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma bee nyaaba sɩ we doŋ saŋa buloŋ, amɛ ŋ beel-ma bɩ sɩ we doŋ a kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ʋ aa bɩsɩ tʋranɩɩ no we ŋ tɩyaŋ nyɛ daga anɩɩ ŋ teŋbii rɛ ʋ marɩ gɛɛ a pɔ kyɛɛ hʋ ba aa sɩ hogo ŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dʋnɩya logiŋ kɛ buloŋ ba aa sɩ mʋ a basɩ Wɩɩsɩ wɩweliye hʋ, ba sɩ basɩ wɩɩ no haaŋ no mɛ aa yaa a liisi ʋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɛɛ rɛ Yesu hatɩnna fi abee balɩya hʋ tɩyaŋ kɩdɩgɩ ba aa yɩrɩ Gyudasɩ Isɩkarɔtɩ sii mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ lee, a pɩyɛsɩ ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Dɩ mɩyaŋ nɛ kyɛɛ ŋmanɩɩ tɩya ma dɩ ma kaŋ Yesu, bekiŋ nɛ ma sɩ tɩya ŋ?” Ɛɛ rɛ ba dɩɩsɩ molbinʋʋ mɔlɩya abee fi a kpa tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A lɩɩ haŋ saŋa hʋ tɩyaŋ nɛ Gyudasɩ piili kɩ kyɛ ŋmanɩɩ hʋ ʋ aa sɩ tɩŋa a kpa Yesu we ba nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dɩɩsɩ-Parɩ-banɩɩ kyɛbal hʋ tɩyaŋ ba aa kyaŋ paanʋʋ hʋ ba aa bɩ wee sɩbʋl hʋ, ʋ kyɛbuŋbuŋ kyɛɛ Yesu hatɩnna hʋ ko pɩyɛsɩ ʋ a baa, “Lee rɛ ɩ kɩ kyɛ dɩ á mʋ yaa Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ kɩdiiliye dɩ ɩ ko di?” ");
INSERT INTO sig_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɛɛ rɛ Yesu daga ba baal kɩdɩgɩ lee tɔbal hʋ tɩyaŋ a baa, “Ma mʋ basɩ tɩya ʋ dɩ ma nɩhɩyawʋ baa dɩ ʋ saŋa pele rɛ. Ɛɛwɩya ʋ aa kyɛ dɩ ʋ bee ʋ hatɩnna hʋ ko di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ kɩdiiliye rɛ ʋ dɩya tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nyɛ rɛ Yesu hatɩnna hʋ mʋ a yaa gɛɛ Yesu aa daga ba, a marɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dɩdaana aa ko pele Yesu bee ʋ hatɩnna fi abee balɩya hʋ ko gyʋʋ hɔŋ a kɩ di kɩdiiliye hʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba aa di kɩna hʋ tɩyaŋ nɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma kɩdɩgɩ rɛ sɩ kpa ŋ yallɩ.” ");
INSERT INTO sig_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɛɛ rɛ ʋ hatɩnna hʋ tɩsɩ kyogi. Ba piili kɩ pɩyɛsɩ ʋ, kɩŋ kɩŋ. Kɩdɩgɩ aa pɩyɛsɩ, “Ŋ Tɩɩna, mɩyaŋ nɛ? ");
INSERT INTO sig_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu basɩ tɩya ba a baa, ŋ bee nal hʋ aa kyala kaŋ paanʋʋ tuu yuu gbaha hʋ tɩyaŋ nɛ sɩ kpa ŋ yallɩ. ");
INSERT INTO sig_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɩyaŋ Nihuwobiŋ Biye sɩ sʋba anɩɩ ba aa saba ŋ wɩya gɛɛ. Amɛ nal hʋ aa sɩ kpa mɩyaŋ Nihuwobiŋ Biye yallɩ, ʋ sɩ na tʋwara yʋga. Ba fa aa bɩ ʋ lʋla ʋ rɛ kpɩya.” ");
INSERT INTO sig_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Doŋ nɛ Gyudasɩ minaafigi tɩɩna hʋ aa sɩ kpa Yesu yallɩ pɩyɛsɩ ʋ a baa, “Ŋ nɩhɩyawʋ, mɩyaŋ nɛ ɩ kɩ daga?” Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Waa, ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba aa hɔnɔ kɩ di kɩna hʋ tɩyaŋ nɛ Yesu kpa paanʋʋ a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kaŋ lɔgɔ lɔgɔ a kpa tɩya ʋ hatɩnna hʋ aŋ baa, “Ma laa kyaŋ. Ŋ teŋbii rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ɛɛ rɛ ʋ bɩl kpa nɩɩnyʋwagbaŋbiye mɛ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kpa tɩya ba aŋ baa, “Ma buloŋ nyʋwa nɩɩnyʋwagbaŋbiye no tɩya kɩna, ");
INSERT INTO sig_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","beewɩya ŋ kyal lɛ gɛɛ. Kyal no rɛ Wɩɩsɩ kpa we nyʋwa hʋ tɩya ma. Ŋ kyal sɩ gyaasɩ nɩgyamaa wɩya, dɩ Wɩɩsɩ kpa ba wɩbɔmɔ kyɛ ba. ");
INSERT INTO sig_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ŋ basɩ kɩ tɩya ma rɛ, ŋ bɩl bɩ sɩ maakyiye nyʋwa sɩŋ no, see kyɛɛ hʋ ŋ beel-ma aa sɩ nyʋwa sɩfalɩɩ ŋ Kuwo koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɛɛ rɛ ba yɩɩ wɩɩkyʋwalyɩɩl aŋ sii lɩɩ a mʋ gyɩŋ Olivi dogimo hʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Doŋ tɩyaŋ Yesu basɩ tɩya ba a baa, “Tebine no tɩɩ ma buloŋ sɩ fá pɩsa aŋ vɩya ŋ ta akuu wɩɩ hʋ aa sɩ puu ŋ wɩya. Beewɩya ba sabɩ Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, Wɩɩsɩ baa, ‘Ŋ sɩ kpʋ pedaal hʋ aŋ ka dɩ piyese hʋ fá pɩsa.”’ ");
INSERT INTO sig_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amɛ ŋ sɩ sii sʋʋ tɩyaŋ. Dɩ mɩyaŋ nɛ ko sii, ŋ sɩ laa sɩya a mʋ Galili ma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Dɩ ba buloŋ sɩ kuu wɩɩ hʋ aa sɩ puu ɩ wɩya fá vɩya ɩ ta mɛ, amɛ ŋ kɛ bɩ sɩ mɩɩgɩ ɩ hal maakyiye kɩdɩgɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, gyɩnaŋ tebine no tɩɩ ɩ Piita sɩ tʋwa naaŋsɩɩnyʋwa bʋto a baa ɩ bɩ gyɩma ŋ, ka dɩ gyibal na wii.” ");
INSERT INTO sig_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ɛɛ rɛ Piita basɩ tɩya ʋ a baa, “Haalɩ dɩ ŋ beel-ɩ sɩ paalɩ sʋba mɛ, ka ŋ bɩ sɩ maakyiye baa ŋ bɩ gyɩma ɩ.” Nɩkaalɩya hʋ buloŋ mɛ basɩ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ sii mʋ gyʋʋ lee kɩdɩgɩ ba aa yɩrɩ Gesamani. Doŋ nɛ Yesu basɩ tɩya ba a baa, “Ma hɔŋ daha ka dɩ ŋ yɩya mʋ kyʋwalɩ Wɩɩsɩ aŋ ko.” ");
INSERT INTO sig_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɛɛ rɛ ka ʋ kaŋ Piita abee Zebedi biisi hʋ balɩya ba mʋ. Ʋ tɩya gyɩ kyogo rɛ kɩŋkaŋ, ka ʋ hakɩla buloŋ gyarɩ. ");
INSERT INTO sig_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nyɛ rɛ ʋ basɩ tɩya ba a baa, “Ŋ tɩya buloŋ nɛ kyogo ŋ bembii kɩ kyɛ dɩ ʋ bori. Ma hɔŋ daha kɩ gyegili ŋ?” ");
INSERT INTO sig_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ba hɔŋ ka ʋ fasɩ mʋ sɩya mʋhʋ a tuu pɩŋ kyige taŋha a sʋla Wɩɩsɩ a baa “Ŋ kuwo, dɩ ŋmanɩɩ we doŋ maga dɩ tʋwara no parɩ ŋ baŋ, leŋ dɩ ɛɛ yaa. Amɛ ŋ tɩɩ kyɛrɩ tɩyaŋ daa, ɩ kyɛrɩ tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ʋ kyʋwalɩ Wɩɩsɩ hʋ teŋ aŋ sii ko ʋ hatɩnna hʋ boto lee dɩ ba pɩŋ doo. Ɛɛ rɛ ʋ pɩyɛsɩ Piita a baa, “Ma aa pɩŋ doo rɛ? Ɛɛ kɛ ma bɩ sɩ wuwo bara doo a kyʋwalɩ Wɩɩsɩ hawadɩgɩ mɛ aŋ kɩ gyegili ŋ? ");
INSERT INTO sig_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ma kɩ bara doo a kɩ sʋla Wɩɩsɩ aŋ kɩ pɔ dɩ Sɩtaanɩ ta wuwo mʋrɩ ma. Ma tɩɩsɩ tɩyaŋ ma kyo dɩ ma tɩŋa ŋ nyʋwa rɛ, amɛ ma tɩɩ bɩ kaŋ ɛɛ dee.” ");
INSERT INTO sig_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ʋ bɩl mʋ a kyʋwalɩ Wɩɩsɩ lɩya tɩɩna a bɩl baa, “Ŋ kuwo, dɩ ŋmanɩɩ buloŋ tuwo a maga dɩ tʋwara no parɩ ŋ baŋ, leŋ dɩ ɩ kyɛrɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ʋ gyɩ bɩl mɩɩgɩ ko dɩ ʋ naa ba bɩl pɩŋ doo, beewɩya doo gyɩ kaŋ ba rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nyɛ rɛ Yesu leŋ ba aŋ bɩl mʋ kyʋwalɩ Wɩɩsɩ bʋto tɩɩna, a bɩl kyʋwalɩ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ɛɛ rɛ ʋ bɩl mɩɩgɩ ko ʋ hatɩnna hʋ lee a pɩyɛsɩ ba a baa, “Ma ha pɩŋ kɩ pɩŋ doo rɛ? Ma deŋ na, saŋa hʋ ba aa sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye a mʋ tɩya wɩbɔŋyaala pele rɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ma sii dɩ á mʋ. Na nal hʋ aa kpaa ŋ yallɩ rɛ aa ko.” ");
INSERT INTO sig_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ha gyɩ aa basɩ wɩya hʋ tɩyaŋ nɛ dɩ ʋ hatɩnna fi abee balɩya hʋ kɩdɩgɩ ba aa yɩrɩ Gyudasɩ rɛ mʋ kɩ ko gɛɛ, nɩgyamaa paa tɩŋa ʋ hal, badɔmɔŋ kolo takoobiye abee daŋgulo. Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee ba bee nɩhɩyasɩ rɛ gyɩ tɩŋ ba. ");
INSERT INTO sig_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Minaafigi tɩɩna hʋ gyɩ tɩya nala hʋ magɩl lɛ a baa, “Nal hʋ ŋ aa sɩ mʋ guwori, ʋ rɛ gɛɛ. Ma kana ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɛɛ rɛ Gyudasɩ vala degini Yesu a mʋ pele ʋ aŋ baa, “Ŋ nɩhɩyawʋ, ŋ aa kyʋwalɩ ɩ, aŋ guwori ʋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ bagyʋwa, kɩ yaa wɩɩ hʋ ɩ aa ko dɩ ɩ yaa.” Nyɛ rɛ ba mʋ pele Yesu a gurigi ʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Doŋ tɩyaŋ nɛ Yesu hatɩnna hʋ kɩdɩgɩ lɩɩ ʋ takoobii a ŋmaŋ baal kɩdɩgɩ dɩgɩŋ kyɔl. Baal no fa yaa Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ dɩya tʋŋtʋnnɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Mɩɩgɩ kpa ɩ takoobii hʋ we ʋ tʋʋl tɩyaŋ. Nal hʋ buloŋ aa kyuri takoobii kyɔgɔ nal, takoobii rɛ ba sɩ kpa kpʋ ʋ tɩɩna mɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɩ bɩ gyɩma anɩɩ ŋ fa sɩ wuwo yɩrɩ ŋ Kuwo dɩ ʋ pɛ ŋ tɩyaŋ? Dɩ mɩyaŋ nɛ fa yɩrɩ ʋ, lagɩlagɩ no buloŋ ʋ fa sɩ ta ʋ malɩkasɩ tusi tusi dɩ ba ko pɛ ŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amɛ dɩ ʋ rɛ fa yaa gɛɛ, ɛɛ rɛ wɩya hʋ ba fa aa saba Wɩɩsɩ teŋ tɩyaŋ sɩ yaa a ko yaa wɩtɩɩ, beewɩya ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ anɩɩ wɩya no maga ba yaa nyɛ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɛɛ rɛ Yesu pɩyɛsɩ nɩgyamaa hʋ a baa, “Ŋ yaa biibɔŋ nɛ, ma paa takoobiye abee daŋgulo a kɩ ko dɩ ma kana ŋ? Ka kyɛɛ buloŋ nɛ ŋ beel-ma aa hɔŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ ŋ kɩ daga ma wɩya, aŋka ma bɩ lʋga dɩ ma kana ŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amɛ wɩya no buloŋ yaa dɩ wɩya hʋ Wɩɩsɩ aa leŋ ʋ tɩŋdaala basɩ biŋ ko yaa wɩtɩɩ rɛ.” Doŋ nɛ Yesu hatɩnna hʋ buloŋ vɩya ʋ ta aŋ fá nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɛɛ rɛ nala hʋ aa kaŋ Yesu kana ʋ mʋ wɩɩkyʋwal sɩlaala nɩhɩyawʋ Kayifasɩ dɩya. Dɩ Wɩɩsɩ Teŋ dɩdagɩla abee ba bee nɩhɩyasɩ buloŋ laŋŋa doŋ. ");
INSERT INTO sig_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka Piita mɛ daasɩ kɩ tɩŋ ba hal a tɩŋa gyʋʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ gyaŋwuwo. Ʋ aa gyʋʋ gyaŋwuwo hʋ, ʋ mʋʋ hɔŋ nala hʋ aa pɔ gyaŋwuwo hʋ lee dɩ ʋ na wɩɩ hʋ ba aa sɩ yaa Yesu. ");
INSERT INTO sig_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee nala hʋ buloŋ aa laŋŋɩ kɩ vʋʋlɩ wɩya, kɩ kyɛ dɩ ba nyɩya wɩya a tɩya Yesu dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amɛ ba gyɩ bɩ naa wɩɩ buloŋ ba aa sɩ nyɩya tɩya ʋ. Haalɩ nala yʋga gyɩ ko nyɩya wɩya tɩya ʋ, amɛ ba bɩ naa wɩɩ buloŋ ʋ aa yaa kyogi a maga dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ɛɛ rɛ baala balɩya ko lɩɩ a baa, “Baal no baa dɩ ʋ sɩ wuwo ŋmaa Wɩɩkyʋwaldɩɩbal hʋ lo aŋ mɩɩgɩ saa ʋ kyɛyɛ boto paga tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ sii sɩŋ a pɩyɛsɩ ʋ a baa, “Wɩgyamaa no buloŋ ba tɩɩ aa baa ɩ yaa, ɛɛ kɛ ɩ kɛ tɩɩ bɩ kaŋ wɩɩ ɩ aa sɩ basɩ?” ");
INSERT INTO sig_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Yesu tallɩ ʋ nyʋwa. Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ basɩ tɩya ʋ a baa, “Ŋmɩyɛsɩ Wɩɩsɩ hʋ aa weye feŋ tɩyaŋ, a basɩ tɩya ma, ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya? Ɩ rɛ yaa Wɩɩsɩ Biye hʋ?” ");
INSERT INTO sig_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɛɛ rɛ ɩ basɩ. Amɛ ŋ basɩ kɩ tɩya ma buloŋ nɛ, a lɩɩ saŋa no tɩyaŋ a kaŋ kɩ mʋ, ma sɩ na mɩyaŋ Nihuwobiŋ Biye hʋ aa hɔŋ Wɩɩsɩ noduu logiŋ tɩyaŋ dɩ ŋ ko kɩ tuu taala tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu aa basɩ gɛɛ, Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ gʋl kaŋ ʋ tɩɩ gannɩ kɩyɛsɩ a daga nɩɩ ʋ tɩya kyogo rɛ aŋ baa, “Ʋ tʋʋsɩ Wɩɩsɩ rɛ gɛɛ. Ʋ bɩ maga dɩ á bɩl kɩ kyɛ daŋsɩya tɩmma. Na ma buloŋ naa baal no aa kpaa ʋ tɩɩ gɛɛ rɛ anɩɩ ʋ yaa Wɩɩsɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɛɛ rɛ ma na?” Ɛɛ rɛ ba baa, “Ʋ maga dɩ ba kpʋ ʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɛɛ rɛ ba tʋ naŋtʋwɔl we ʋ sɩya tɩyaŋ aŋ ŋmaa ʋ. Ba badɔmɔŋ aa ŋmaa ʋ rɛ, aŋ basɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ɩ Krisita, laataal hʋ Wɩɩsɩ aa lɩya, na ɩ yaa Wɩɩsɩ tɩŋdaal lɛ, daga nal hʋ aa ŋmaa ɩ.” ");
INSERT INTO sig_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Saŋa no tɩyaŋ dɩ Piita mɛ gyɩ hɔŋ gyaŋwuwo hʋ tɩyaŋ nɛ. Ɛɛ rɛ gyaŋwuwo hʋ tʋŋtʋnnɩ-toluu kɩdɩgɩ ko lɩɩ a baa, “Na ɩ mɛ fa aa tɩŋ Yesu aa lɩɩ Galili hal lɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Doŋ nɛ Piita tʋwa ba buloŋ sɩya tɩyaŋ a baa, “Ŋ kɛ bɩ gyɩŋ wɩɩ no ɩ aa basɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piita aa basɩ gɛɛ, ʋ sii lɩɩ sɩŋ gyaŋwuwo hʋ paga nyʋwa tɩyaŋ. Doŋ nɛ tʋŋtʋnnɩ-toluu kɩdɩgɩ mɛ bɩl na ʋ a basɩ tɩya nala hʋ aa sɩŋ kpaga doŋ a baa, “Baal no mɛ yaa Yesu aa lɩɩ Nazarɛti hatɩnna hʋ kɩdɩgɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piita bɩl tʋwa a baa, “Ŋ ŋmɩyɛsa, ŋ bɩ gyɩŋ baal no.” ");
INSERT INTO sig_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mʋhʋ sʋwa nala hʋ aa sɩŋ doŋ mɛ sii kpa mʋ Piita lee a basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ, ɩ mɛ yaa ba kɩdɩgɩ rɛ, beewɩya ɩ wɩbasɩɩ daga gɛɛ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ɛɛ rɛ Piita ŋmɩyɛsɩ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ mɩyaŋ nɛ kɔnɩ ko gyɩŋ baal no Wɩɩsɩ ta leŋ wɩɩ tɩyaŋ. Ŋ paal bɩ gyɩŋ baal no.” Ʋ aa basɩ gɛɛ ko teŋ dɩ gyibal wiye. ");
INSERT INTO sig_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Doŋ tɩyaŋ nɛ Piita liisi wɩɩ hʋ Yesu gyɩ aa basɩ tɩya ʋ anɩɩ ʋ sɩ tʋwa naaŋsɩɩnyʋwa bʋto a baa dɩ ʋ bɩ gyɩma ʋ, ka dɩ gyibal na wii. Ɛɛ rɛ ʋ sii lɩɩ a wii weliŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ʋ sɩgballɩya kyɩkyʋwala, Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ buloŋ abee Gyuuma bee-nɩhɩyasɩ ko laŋŋɩ a vʋʋlɩ yaa nyʋʋdɩgɩ anɩɩ Yesu maga dɩ ba kpʋ ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɛɛ rɛ ba kana ʋ a leŋ ba vʋwa ʋ, a kana ʋ mʋ Pilato sɩya. Pilato rɛ gyɩ yaa nal hʋ aa laa Roma paalʋʋ kuworibal hʋ naasɩ sɩŋ Gyudɩya paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gyudasɩ minaafigi tɩɩna hʋ aa nɩya anɩɩ ba aa kyɛ dɩ ba kpʋ Yesu gɛɛ rɛ, ʋ tɩya buloŋ kyogi ʋ aa kpaa Yesu yallɩ wɩya. Ɛɛ rɛ ʋ mɩɩgɩ kaŋ molbinʋʋ mɔlɩya abee fi hʋ a mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee-nɩhɩyasɩ hʋ lee a baa, ");
INSERT INTO sig_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ŋ yaa wɩbɔŋ nɛ, ŋ aa kpaa nal hʋ aa bɩ kaŋ wɩkyogii a yallɩ tɩya ma dɩ ma kpʋ ʋ.” Ɛɛ rɛ nala hʋ baa, “Á sɩya kɛ bɩl tuwo ɛɛ tɩyaŋ. Ɛɛ kɛ yaa ɩ mɛ dʋŋ wɩɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɛɛ rɛ Gyudasɩ kpa molbiye hʋ yuwo ta Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ aŋ lɩɩ mʋ yuwo ŋmaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ paa molbiye hʋ aŋ baa, “Kyal molbiye rɛ nyɛ. Ʋ yaa sɩna rɛ á lesiri tɩyaŋ anɩɩ á aa sɩ kpa ba pɛ Wɩɩkyʋwaldɩɩbal hʋ molbiye tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Doŋ nɛ ba vʋʋlɩ dɩ ba gyɩŋ wɩɩ hʋ ba aa sɩ kpa molbiye hʋ yaa. Nyɛ rɛ ba kpa molbiye hʋ yɔbɔ taŋha viimɔɔl kɩdɩgɩ lee, a kɩ hogo nɩhʋwala doŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛɛ rɛ tɩŋ ba kaŋ doŋ kɩ yɩrɩ Kyal Taŋha abee gyɩnaŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ba aa yaa gɛɛ, wɩya hʋ Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩŋdaal Gyɛrimaya tɩyaŋ a basɩ ko yaa wɩtɩɩ rɛ. Ʋ gyɩ baa, ");
INSERT INTO sig_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","“Iziral tɩmma gyɩ laa nyʋwa anɩɩ baal no yalɩɩ ba tɩɩ aa wee rɛ yaa molbinʋʋ mɔlɩya bee fi. Ɛɛ rɛ ba laa molbii no a kpa yɔbɔ taŋha viimɔɔl kɩdɩgɩ lee anɩɩ á Tɩɩna Wɩɩsɩ aa daga gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Saŋa no tɩyaŋ dɩ Yesu sɩŋ Gyudɩya paalʋʋ buloŋ nɩbal hʋ sɩya tɩyaŋ nɛ. Ɛɛ rɛ ʋ pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa Gyuuma kuwori hʋ koo?” Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Waa, ɛɛ rɛ ɩ tɩɩ basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee-nɩhɩyasɩ hʋ basɩ wɩya hʋ ba aa baa ʋ yaa kyogi, ka ʋ bɩ laa wɩɩ buloŋ basɩ. ");
INSERT INTO sig_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nyɛ rɛ ba paalʋʋ nɩbal hʋ pɩyɛsɩ ʋ abaa, “Ɩ bɩ nɩɩ wɩya hʋ buloŋ ba aa baa dɩ ɩ yaa kyogi?” ");
INSERT INTO sig_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amɛ Yesu bɩ suri ʋ nyʋwa. Ʋ bɩ laa wɩdɩgɩ mɛ basɩ. Ɛɛ rɛ wɩɩ hʋ kperi Pilato. ");
INSERT INTO sig_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ rɛ ko pele buloŋ, Pilato fa aa leŋ ba lɩɩ nal hʋ nala hʋ aa kyɛ rɛ nala hʋ ba aa kaŋ tɔ nɩtɔdɩya tɩyaŋ a ta. ");
INSERT INTO sig_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saŋa no tɩyaŋ ba gyɩ kaŋ baal kɩdɩgɩ ba aa yɩrɩ Barabaasɩ tɔ nɩtɔdɩyaŋ nɛ. Barabaasɩ gyɩ yaa biibɔŋ nɛ nal buloŋ gyɩma ʋ wɩya. ");
INSERT INTO sig_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nɩgyamaa hʋ aa laŋŋa gɛɛ, Pilato pɩyɛsɩ ba abaa, “Kɩbee rɛ mɛ kyo dɩ ŋ lɩɩ tɩya ma? Barabaasɩ koo Yesu, nal hʋ ma aa yɩrɩ Krisita hʋ?” ");
INSERT INTO sig_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato gyɩ gyɩma rɛ anɩɩ Gyuuma nɩhɩyasɩ hʋ tɩsɩ gyɩ aa hɔllɩ Yesu wɩyaalɩya rɛ, ɛɛ rɛ tɩŋ ba kana ʋ ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato gyɩ aa hɔŋ sarɩya hʋ lidiilii tɩyaŋ, ʋ haaŋ tɩya tɩŋdarɩ dɩ ba mʋ basɩ tɩya ʋ a baa, “Ta yaa baal no wɩɩ buloŋ. Ʋ bɩ kaŋ wɩkyogii buloŋ. Dɩya tebine ŋ dɩya naa tʋwara rɛ weliŋ ŋ duwoso tɩyaŋ a mʋ kɩ tile baal no tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee nɩhɩyasɩ hʋ mʋrɩ nɩgyamaa hʋ we dɩ ba leŋ dɩ Pilato lɩɩ Barabaasɩ ta aŋ leŋ dɩ ba kpʋ Yesu. ");
INSERT INTO sig_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ɛɛ rɛ Pilato pɩyɛsɩ nɩgyamaa hʋ a baa, “Nala no balɩya tɩyaŋ, kɩbee rɛ ma kɩ kyɛ dɩ ŋ lɩɩ tɩya ma?” Ɛɛ rɛ ba baa, “Barabaasɩ!” ");
INSERT INTO sig_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ɛɛ rɛ Pilato pɩyɛsɩ nala hʋ a baa, “Aŋka Yesu hʋ ma aa yɩrɩ Krisita, bee rɛ ma baa ŋ yaa ʋ?” Ɛɛ rɛ ba buloŋ baa, “Leŋ dɩ ba kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ɛɛ rɛ Pilato pɩyɛsɩ ba a baa, “Wɩbɔŋ bee rɛ ʋ yaa?” Ɛɛ rɛ ba nɔsɩ a te buŋbuŋ hʋ a baa, “Leŋ dɩ ba kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato aa ko na anɩɩ kyagɩŋsɩ hʋ marɩ yʋga gɛɛ, ʋ naa anɩɩ ʋ bɩl bɩ kaŋ wɩyaalɩɩ buloŋ, ka nala hʋ sɩŋ dɩ ba laa taawɛɛ. Ɛɛ rɛ ʋ kpa nɩɩ a sɔmɔ ʋ nosi nɩgyamaa hʋ sɩya tɩyaŋ aŋ baa, “Ŋ noŋ tuwo baal no kpʋyɩ tɩyaŋ. Ʋ haakye we ma lee.” ");
INSERT INTO sig_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɛɛ rɛ nɩgyamaa hʋ buloŋ baa, “Dɩ ámaa rɛ kyogo wɩɩ no tɩyaŋ, leŋ dɩ Wɩɩsɩ dɔgɩsɩ ma abee á biisi akuu á aa kpʋʋ ʋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɛɛ rɛ Pilato lɩɩ Barabaasɩ tɩya ba aŋ leŋ ba vɩɩrɩ Yesu aŋ kpa ʋ tɩya ba dɩ ba kaŋ mʋ kpaasɩ mal daagarɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ɛɛ rɛ Pilato laalyuwolo hʋ badɔmɔŋ kaŋ Yesu gyʋʋ Pilato gyaŋwuwo. Laalyuwolo hʋ nɩkaalɩya buloŋ mɛ ko pɛ ba tɩyaŋ a laŋŋɩ ka Yesu we ba tʋtʋʋ. ");
INSERT INTO sig_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nyɛ rɛ ba wuri Yesu gannɩ buloŋ aŋ kpa gafɩyaŋdolii kɩdɩgɩ laalɩ ʋ anɩɩ ba Kuwori aa kɩ laalɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aŋ kyɛ sɔsɩ a kaŋ sʋwa nyupugi anɩɩ kuwori nyupugi gɛɛ a kpa kyigi ʋ aŋ kpa daaŋ aa kɩɩ gɛɛ anɩɩ kuwori daatɩgɩɩ we ʋ noduu tɩyaŋ aŋ aa tuu gbinni ʋ sɩya a yaa ʋ sɩya a baa, “Gyuuma kuwori, Wɩɩsɩ sɩ tɩya ɩ mɩɩbol dolii!” ");
INSERT INTO sig_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ka ba tʋ naŋtʋwɔl a we ʋ tɩyaŋ aŋ laa daaŋ hʋ mɛ ŋmaa ŋmaa ʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba aa yaa ʋ sɩya hʋ ko teŋ, ba wuri gafɩyaŋ dolii hʋ aŋ paa ʋ tɩɩ gannɩ a laalɩ ʋ aŋ kana ʋ lɩɩ ŋmanɩɩ dɩ ba mʋ kpaasɩ ʋ mal daagarɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ba aa kana ʋ lɩɩ kɩ mʋ dɩ ba kpaasɩ mal daagarɩɩ hʋ nyuu gɛɛ rɛ, ba kyeŋ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ aa lɩɩ Sariini. Ɛɛ rɛ laalyuwolo hʋ fɩla ʋ, ʋ laa Yesu daagarɩɩ hʋ a baasɩ. ");
INSERT INTO sig_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɛɛ rɛ ba ko pele lee kɩdɩgɩ ba aa yɩrɩ Golgota. Feŋ hʋ memii rɛ yaa nyukuŋkogilo. ");
INSERT INTO sig_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba aa mʋʋ pele doŋ, ba kpa kɩhaanɩ badɔmɔŋ we sɩŋ tɩyaŋ a kpa tɩya Yesu dɩ ʋ nyʋwa. Ʋ aa kyumo mʋhʋ a na dɩ ʋ hayɛ gɛɛ, ʋ vɩya nyʋwayɩ. ");
INSERT INTO sig_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɛɛ rɛ ba kpaasɩ ʋ mal daagarɩɩ hʋ nyuu aŋ yuwo gbaŋŋa a kaŋ ʋ gannɩ kpaa dɔmɔŋ, ");
INSERT INTO sig_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","aŋ hɔŋ doŋ pɔ ʋ. ");
INSERT INTO sig_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wɩya hʋ ba aa baa dɩ ʋ yaa kyogi, ba gyɩ sabɩ ba rɛ a mal daagarɩɩ hʋ tɩyaŋ a baa, “Yesu, Gyuuma kuwori hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba gyɩ kpaasɩ gaala balɩya mɛ a pɛ Yesu tɩyaŋ, kɩdɩgɩ we ʋ noduu, kɩdɩgɩ mɛ we ʋ nogɔbɔ. ");
INSERT INTO sig_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ba aa kpaasɩ ʋ mal daagarɩɩ hʋ tɩyaŋ gɛɛ, nala hʋ aa tɩŋ doŋ kɩ baŋ kɩ tʋʋsɩ ʋ aŋ kaŋ ba nyuni kɩ kyugisi ");
INSERT INTO sig_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a baa, “Ɩ rɛ yaa nal hʋ aa baa dɩ ɩ sɩ ŋmaa á Wɩɩkyʋwaldɩɩbal hʋ lo aŋ bɩl wuwo saa ʋ kyɛyɛ boto paga tɩyaŋ. Ɩ aa yaa Wɩɩsɩ Biye kɩŋkaŋ, tuu daagarɩɩ hʋ nyuu a laa ɩ tɩɩ ta.” ");
INSERT INTO sig_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɛɛ tɩɩ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla abee tɔɔ hʋ nɩhɩyasɩ mɛ gyɩ kɩ yaa Yesu sɩya a kɩ basɩ, ");
INSERT INTO sig_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Na ʋ wuwo laa nala kɩ ta rɛ, bee rɛ yaŋ tɩŋ ʋ bɩ wuwo laa ʋ tɩɩ kɛ kɩ ta. Na ʋ baa ʋ rɛ yaa Iziral kuwori, ʋ lɩɩ daagarɩɩ hʋ nyuu ko tuu dɩ á na a laa ʋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ʋ yelli Wɩɩsɩ rɛ aŋ gba baa dɩ ʋ yaa Wɩɩsɩ Biye rɛ. Tɔɔ, ɛɛ kɛ dɩ Wɩɩsɩ sɩ laa ʋ, ʋ ko tuu laa ʋ lagɩlagɩ no dɩ á na.” ");
INSERT INTO sig_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gaala hʋ balɩya mɛ ba aa kpaasa a pɛ Yesu tɩyaŋ, ba mɛ tʋʋsɩ ʋ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wɩɩsɩ aa ko maga nyutʋtʋʋ, lee hʋ buloŋ bil gɛɛ timm a mʋ pele dɩdaana, ka lee bɩl na kyaanɩ. ");
INSERT INTO sig_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɛɛ rɛ Yesu faasɩ yɩrɩ ʋ taal tɩyaŋ a baa, “Eloyi, Eloyi, lama sabakitani.” Ʋ memii rɛ yaa: “Ŋ Tɩɩna Wɩɩsɩ, bee rɛ tɩŋ ɩ vɩya ŋ ta nyɛ?” ");
INSERT INTO sig_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dɩ nala badɔmɔŋ sɩŋ doŋ a nɩɩ wɩya hʋ ʋ aa basa. Ɛɛ rɛ ba basɩ tɩya dɔmɔŋ baa, “Wɩɩsɩ tɩŋdaal Ilaagya rɛ baal hʋ kɩ yɩrɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Haŋ lagɩlagɩ hʋ nala hʋ kɩdɩgɩ fa aa sɩŋ doŋ fá mʋ kpa sɩbʋl gbara a kaŋ mʋ yuu sɩkyaakyaa a kpa tʋʋ kaakelii tɩyaŋ a kaŋ mʋ we ʋ nyʋwa tɩyaŋ dɩ ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɛɛ rɛ nɩkaalɩya hʋ baa dɩ nyɛ kɛ ba lem-ʋ ka dɩ ba gyegili na dɩ Ilaagya sɩ ko kpa ʋ tuu daagarɩɩ hʋ nyuu koo. ");
INSERT INTO sig_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ɛɛ rɛ Yesu faasɩ wii aŋ wiyesi ʋ wiyesi-kateŋse. ");
INSERT INTO sig_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Haŋ lagɩlagɩ hʋ dɩ patɩɩsa hʋ fa aa bori Wɩɩkyʋwaldɩɩbal hʋ tɩya sɩŋ ʋ nyuu tɩyaŋ aŋ kɩyɛsɩ balɩya ko tuu. Ɛɛ rɛ ka taŋha buloŋ gyigili, bʋwa warɩ warɩ, ");
INSERT INTO sig_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bilni suri suri, Wɩɩsɩ nala yʋga mɛ sii sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu aa sii sʋʋ hal tɩyaŋ, nala hʋ aa sii sʋʋ tɩyaŋ mʋ Gyerusalɛm nɛ, a leŋ nɩgyamaa na ba. ");
INSERT INTO sig_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Laalyuwolo nɩhɩyawʋ abee laalyuwolo hʋ fa aa sɩŋ doŋ a kɩ pɔ Yesu aa naa taŋha aa gyigile gɛɛ abee wɩya hʋ buloŋ aa yaa, kambɩŋ kaŋ ba. Ɛɛ rɛ ba baa, “Wɩtɩɩ, baal no kɔnɩ yaa Wɩɩsɩ Biye rɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka haana yʋga mɛ fa sɩŋ libolii a kɩ deŋ. Haana no fa aa tɩŋ Yesu hal lɛ a lɩɩ Galili paalʋʋ a kɩ pɛ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Haana no badɔmɔŋ nɛ yaa Mɛɛrɩ Magidalina abee Gyemsi bee Gyosɛfʋ ma nɩɩna Mɛɛrɩ a yaŋ bee Zebedi haaŋ. ");
INSERT INTO sig_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dɩdaana aa ko pele, kɩna tɩɩna kɩdɩgɩ aa lɩɩ Arimatiya ba kɩ yɩrɩ Gyosɛfʋ mɛ sii ko Gyerusalɛm. Ʋ mɛ fa yaa Yesu hatɩnna hʋ kɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɛɛ rɛ ʋ sii mʋ Pilato lee a sʋla ʋ dɩ ʋ leŋ dɩ ʋ kpa Yesu mʋ hogo. Ɛɛ rɛ Pilato laa nyʋwa anɩɩ ba mʋ kpa tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɛɛ rɛ Gyosɛfʋ mʋ kpa Yesu a we ʋ liŋe, ");
INSERT INTO sig_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a kpa ʋ hogo ʋ tɩɩ bʋʋfalɩɩ kɩdɩgɩ ʋ fa aa lurigo bʋyɩ tɩyaŋ a biliŋsi bʋbal a ko tɔ bʋwa hʋ nyʋwa aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka Mɛɛrɩ Magidalina abee Mɛɛrɩ kɩdɩgɩ hʋ tɩɩna fa hɔŋ doŋ a kyaasɩ bʋwa hʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ʋ sɩya aa gballa, Kyɛwiyesii hʋ kyɛɛ, Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Farasiima sii mʋ Pilato lee a basɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Nɩhɩyawʋ, á liise wɩɩ rɛ. Saŋa hʋ tɩyaŋ wɩnyɩyɛl no gyɩ aa we ʋ mɩɩbol tɩyaŋ, ʋ gyɩ basa anɩɩ dɩ ʋ rɛ sʋba, ʋ sɩ mɩɩgɩ sii sʋʋ tɩyaŋ kyɛyɛ boto kyɛɛ. ");
INSERT INTO sig_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ɛɛ wɩya leŋ dɩ nala mʋ hɔŋ pɔ ʋ bil hʋ weliŋ dɩ kyɛyɛ boto hʋ pele, dɩ ʋ hatɩnna hʋ ta wuwo mʋ gaa lɩɩ ʋ aŋ basɩ tɩya nala anɩɩ Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ. Ɛɛ hʋ ʋ hatɩnna hʋ aa mʋrɩ nala hʋ, nyɛ kɛ rɛ ba yaŋ sɩ marɩ mʋrɩ nala te gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ɛɛ rɛ Pilato basɩ tɩya ba dɩ ba kaŋ laalyuwolo mʋ dɩ ba hɔŋ pɔ bil hʋ nyʋwa weliŋ anɩɩ ɛɛ ba tɩɩ aa gyɩma. ");
INSERT INTO sig_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɛɛ rɛ ba mʋ magɩlɩ bʋyɩ hʋ aa tɔ bʋwa hʋ nyʋwa aŋ leŋ laalyuwolo sɩŋ pɔ doŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba Kyɛwiyesii hʋ kyɛɛ a tene, Alahadi kyɛɛ sɩgballɩnyʋwa, Mɛɛrɩ Magidalina abee Mɛɛrɩ kɩdɩgɩ tɩɩna hʋ sii mʋ bil hʋ lee. ");
INSERT INTO sig_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba aa mʋʋ pele doŋ, mʋhʋ sʋwaa dɩ lee pirigi gyigili. Doŋ nɛ malɩka lɩɩ wɩɩsɩnyuu ko tuu a biliŋsi bʋyɩ hʋ ta aŋ hɔŋ bʋyɩ hʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ʋ sɩya gyɩ kɩɩ gɛɛ rɛ anɩɩ duwoŋ aa lɩgɩsa, aŋka ʋ gannɩ mɛ pʋrɩsɩ gɛɛ kpil kpil. ");
INSERT INTO sig_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɛɛ rɛ kambɩŋ kaŋ laalyuwolo hʋ gyɩ aa hɔŋ pɔ bʋwa hʋ. Ba kyele gɛɛ a mʋ kpaŋa anɩɩ ba aa sʋba. ");
INSERT INTO sig_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ɛɛ rɛ malɩka hʋ basɩ tɩya haana hʋ a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma. Ŋ gyɩma anɩɩ Yesu rɛ ma kɩ kyɛ, nal hʋ ba aa kaŋ kpaasɩ mal daagarɩɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amɛ ʋ tuwo daha! Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ anɩɩ gɛɛ hʋ ʋ aa basɩ tɩya ma. Ma ko na lee hʋ ʋ fa aa pɩna. ");
INSERT INTO sig_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aŋ mʋ lagɩ lagɩ a basɩ tɩya ʋ hatɩnna hʋ anɩɩ Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ. Ʋ laa sɩya kɩ mʋ Galili rɛ. Doŋ nɛ ma sɩ na ʋ. Wɩɩ hʋ ŋ aa kana dɩ ŋ basɩ tɩya ma rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɛɛ rɛ ba lɩɩ bil hʋ lee a yʋwasɩ kɩ mʋ dɩ ba mʋ basɩ tɩya Yesu hatɩnna hʋ wɩɩ hʋ aa yaa. Kambɩŋ gyɩ kaŋ ba rɛ, ka ba tenni mɛ fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Doŋ nɛ Yesu pirigi kyeŋ ba a basɩ tɩya ba a baa, “Fɩyɛlʋʋ we ma lee.” Ba mʋ kaŋ ʋ naasɩ tɩyaŋ a kyʋwalɩ ʋ abee gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma. Ma mʋ basɩ tɩya ŋ hatɩnna hʋ dɩ ba mʋ Galili, ba sɩ na ŋ doŋ.” ");
INSERT INTO sig_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Haana hʋ aa mɩɩgɩ kɩ mʋ hʋ tɩyaŋ nɛ, laalyuwolo hʋ fa aa sɩŋ pɔ bʋwa hʋ, badɔmɔŋ mɩɩgɩ mʋ bee hʋ a basɩ wɩya hʋ buloŋ aa yaa a tɩya Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma bee-nɩhɩyasɩ hɔŋ a vʋʋlɩ wɩɩ hʋ ba aa sɩ yaa. Ba gyɩ kpaa molbiye yʋga rɛ a kpala laalyuwolo hʋ fa aa sɩŋ pɔ bʋwa hʋ aŋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ma basɩ tɩya nala anɩɩ ma pɩŋ doo rɛ tebine aŋka Yesu hatɩnna ko gaa lɩɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dɩ paalʋʋ hʋ nɩbal hʋ rɛ ko nɩɩ wɩɩ no, á sɩ basɩ pɛ ma tɩyaŋ a laa ma ta aŋ leŋ dɩ ʋ gyɩma anɩɩ ma mɛ wɩɩ daa.” ");
INSERT INTO sig_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nyɛ rɛ laalyuwolo hʋ laa molbii hʋ aŋ basɩ gɛɛ hʋ ba aa baa dɩ ba basɩ. Wɩɩ no ba aa basa rɛ Gyuuma kɛ ha kaŋ gɔllɩ kɩ basɩ lee buloŋ abee gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɛɛ rɛ Yesu hatɩnna fi abee kɩdɩgɩ hʋ sii mʋ Galili paalʋʋ a gyɩŋ dogimo hʋ nyuu, lee hʋ Yesu fa aa daga ba. ");
INSERT INTO sig_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba aa na ʋ ba kyʋwalɩ ʋ abee gyɩrɩma, amɛ ba badɔmɔŋ kɛ ha fa aa yaa ʋ sige rɛ. ");
INSERT INTO sig_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Doŋ nɛ Yesu ko kpaga ba a basɩ tɩya ba baa, “Wɩɩsɩ kpaa wɩɩsɩbee abee dʋnɩya no buloŋ dee tɩya ŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɛɛwɩya ma mʋ dʋnɩya logiŋ kɛ buloŋ a leŋ dɩ nala buloŋ bɩrɩmɩ ŋ hatɩnna ka dɩ ma fo ba wɩɩkyʋwalnɩɩ, Kuwo abee Biye abee Wiyesi Welii hʋ feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma daga ba dɩ ba kɩ tɩŋ wɩya hʋ buloŋ ŋ aa daga ma. Aŋka ma gyɩma anɩɩ ŋ kɔnɩ we ma lee rɛ saŋa buloŋ a kaŋ kɩ mʋ dʋnɩya tenii.”");
INSERT INTO sig_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wɩɩsɩ Biye Yesu Krisita wɩweliye hʋ lipiilii rɛ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wɩɩsɩ tɩŋdaal Azaaya gyɩ saba nal hʋ aa sɩ laa Yesu Krisita sɩya ko wɩya rɛ, a baa dɩ Wɩɩsɩ baa, “Deŋ na, ŋ sɩ tɩŋ ŋ tɩŋdaal dɩ ʋ laa ɩ sɩya a mʋ a marɩ ŋmanɩɩ bin-ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A bɩl baa, “Nal lɛ sɩŋ pogo tɩyaŋ a heeli kɩ basɩ, ‘Ma ko a marɩ ma tɩsɩ anɩɩ ma aa marɩ ŋmanɩɩ a pɔ nɩbal koyi gɛɛ, dɩ ma Tɩɩna ko tɩŋa. Dɩ mamaa rɛ yaa gɛɛ dɩ ʋ ko ko, ʋ lɩvalɩɩ sɩ pɩŋ weliŋ.’” ");
INSERT INTO sig_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɛɛ rɛ baal no sii, ba kɩ yɩrɩ ʋ Gyɔɔŋ, Wɩɩsɩnɩɩfool. Ʋ sii gyʋʋ pogo hʋ a heeli a kɩ basɩ, “Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ, ka dɩ ŋ fo ma wɩɩkyʋwalnɩɩ, dɩ Wɩɩsɩ kpa ma wɩbɔmɔ kyɛ ma.” ");
INSERT INTO sig_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ʋ aa basɩ gɛɛ, Gyudɩya tɩmma abee Gyerusalɛm tɩmma buloŋ lɩɩ a mʋ ʋ lee, a lugisi ba wɩbɔmɔ, aŋ tuu Gyɔɔdaŋ fuwo hʋ, ʋ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nyɔgɩmaa pʋna gannɩ rɛ Gyɔɔŋ fa kɩ laalɩ, aŋ aa kpa tɛpɩɩŋbii vʋwa ʋ tɩŋa. Nyɩŋgɩrɩgɩsɩ abee tʋʋ rɛ fa yaa ʋ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ʋ gyɩ basɩ Wɩɩsɩ wɩya kɩ tɩya nala rɛ a baa, “Nal kɩdɩgɩ sɩ tɩŋa ŋ hal ko. Ʋ rɛ sɩ te ŋ. Ŋ paalɩ bɩ maga dɩ ŋ kpaga ʋ a kaŋ ʋ naatɔbɔ ŋmasɩ mɛ puri. ");
INSERT INTO sig_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nɩɩ dʋŋ nɛ ŋ kɛ kaŋ kɩ fo ma wɩɩkyʋwalnɩɩ, amɛ ʋ kɛ sɩ kpa Wiyesi Welii hʋ we ma tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Haŋ saŋa hʋ tɩyaŋ nɛ Yesu gyɩ sii lɩɩ Nazarɛti aa we Galili paalʋʋ tɩyaŋ, a ko lee hʋ Gyɔɔŋ fa aa wee, a ko tuu Gyɔɔdaŋ fuwo hʋ Gyɔɔŋ fo ʋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ʋ aa mɩɩgɩ lɩɩ nɩɩ hʋ tɩyaŋ ko dɩ ʋ lɩɩ, a wil dɩ ʋ deŋ, dɩ ʋ naa wɩɩsɩnyuu pirigi lɔgɔ suri. Doŋ tɩyaŋ nɛ Wɩɩsɩ Wiyesi Welii hʋ aa kɩɩ gɛɛ anɩɩ kokomo ko tuu saga ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɛɛ hal lɛ ʋ nɩɩ taal dɩ ʋ lɩɩ wɩɩsɩnyuu a basɩ tɩya ʋ baa, “Ŋ biikyoolii rɛ yaa ɩ. Ŋ teŋ fɩyɛla rɛ ɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ʋ bɩ pɩɩsa ka Wɩɩsɩ Wiyesi Welii hʋ kpa Yesu gyʋʋ pogo. ");
INSERT INTO sig_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ʋ we doŋ gɛɛ kyɛyɛ mɔllɩbalɩya. Ʋ bee pogo tɩyaŋ kɩna dʋŋ. Sɩtaanɩ ko magɩsɩ magɩsɩ ʋ lɔlɔ, aŋka malɩkasɩ ko tuu kɩ kyiyeli ʋ. ");
INSERT INTO sig_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ʋ bɩ pɩɩsa ka ba kaŋ Gyɔɔŋ tɔ dɩya tɩyaŋ. Ɛɛ rɛ Yesu sii kpa mʋ Galili paalʋʋ, a basɩ Wɩɩsɩ wɩweliye hʋ a kɩ tɩya nala, ");
INSERT INTO sig_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a baa, “Saŋa hʋ pele rɛ. Wɩɩsɩ koro hʋ pele rɛ. Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ aŋ laa Wɩɩsɩ wɩweliye hʋ di.” ");
INSERT INTO sig_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ɛɛ rɛ ʋ mʋ pele Galili fuwo hʋ, a tɩŋ fuwo hʋ nyʋwa kɩ baŋ, dɩ ʋ naa Siimɔŋ abee ʋ naabiye Aŋduru. Ba fa yaa fuwonaŋkasɩla rɛ. Ʋ aa mʋʋ dɩ ba aa yuwo ba gyoŋ a kɩ kasɩ fuwonamɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ʋ yɩrɩ ba, a basɩ tɩya ba a baa, “Ma sii ko kɩ tɩŋa ŋ hal. Ŋ sɩ daga ma dɩ ma kasɩ nala anɩɩ ma aa kasɩ fuwonamɩɩsɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba sii kpa ba gyoŋ hʋ ta aŋ kpa tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ʋ bɩl kpa mʋ sɩya mʋhʋ dɩ baala balɩya mɛ rɛ gɛɛ. Ba fene rɛ yaa Gyemsi abee Gyɔɔŋ, a yaa Zebedi balɩya. Ʋ aa mʋʋ dɩ ba hɔŋ ba nɩɩduworiboro tɩyaŋ a kɩ tɔ ba gyoŋsi bolo. ");
INSERT INTO sig_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ʋ aa ko na ba, ʋ yɩrɩ ba, ba leŋ ba kuwo hʋ abee nala hʋ buloŋ fa aa tʋma kɩ tɩya ba aŋ lɩɩ nɩɩduworiboro hʋ tɩyaŋ, a mʋ kɩ tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɛɛ rɛ ba kpa kɩ mʋ, a ko pele Kapɛɛnam. Kyɛwiyesii hʋ kyɛɛ Yesu sii mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya a kɩ daga nala. ");
INSERT INTO sig_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ʋ aa daga ba gɛɛ, ʋ yaa ba wɩkperii, beewɩya ʋ bee daga ba anɩɩ Wɩɩsɩ Teŋ dɩdagɩla hʋ aa kɩ daga ba gɛɛ, amɛ ʋ daga ba rɛ ba gyɩma anɩɩ ʋ kaŋ wɩɩ hʋ ʋ aa dagɩ dee rɛ. ");
INSERT INTO sig_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɛɛ rɛ dɩ baal kɩdɩgɩ gyɩŋbɔŋ aa kana rɛ gɛɛ, a ko gyʋʋ wɩɩkyʋwaldɩya hʋ a kɩ kyɩɩrɩ a baa, ");
INSERT INTO sig_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu aa lɩɩ Nazarɛti, bee rɛ ɩ kɩ kyɛ ɩ yaa ma? Ɩ ko dɩ ɩ kpʋ ma rɛ? Ŋ gyɩma ɩ rɛ. Ɩ rɛ yaa Wɩɩsɩ Tɩpʋlʋŋ Tɩɩna hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu aa nɩɩ wɩya no baal hʋ aa basa, ʋ nɔsɩ gyɩŋbɔŋ hʋ a baa, “Leŋ kyagɩŋsɩ aŋ ko lɩɩ baal hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gyɩŋbɔŋ hʋ kaŋ baal hʋ kɩ kyele aŋ kyɩɩrɩ yʋga aŋ lɩɩ baal hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nala hʋ buloŋ mɩɩgɩ hirigi a kɩ pɩyɛsɩ dɔmɔŋ a baa, “Bee wɩɩ rɛ nyɛ? Wɩfalɩɩ rɛ ʋ kɩ daga. Ʋ paalɩ kaŋ gyɩŋbɔmɔ dee rɛ, a basɩ wɩya tɩya ba, ba kɩ tɩŋa ʋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A lɩɩ gɛɛ tɩyaŋ nɛ ʋ feŋ taalɩ Galili paalʋʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ɛɛ rɛ Yesu sii lɩɩ wɩɩkyʋwaldɩya hʋ tɩyaŋ haŋ lagɩ lagɩ hʋ, ʋ bee Gyemsi abee Gyɔɔŋ, a kpa mʋ Siimɔŋ abee Aŋduru dɩya. ");
INSERT INTO sig_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ba aa mʋwa dɩ Siimɔŋ hɩɩlhaaŋ pɩna kɩ wɩɩlɩ, ʋ teŋ buloŋ nɩma. Yesu aa mʋʋ ko, ba basɩ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɛɛ rɛ ʋ ko gyʋʋ a kaŋ haaŋ hʋ noŋ tɩyaŋ a kaŋ tarɩ ʋ sii sɩŋ. Ʋ teŋnɩma hʋ pirigi nyʋgɩsɩ, ka ʋ sii yaa kɩdiiliye tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ʋ sɩdʋsɩya saŋa, ba kaŋ nala hʋ buloŋ aa wɩɩlɩ abee gyɩŋsɩ aa kaŋ nala hʋ buloŋ a ko Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bee hʋ tɩmma buloŋ giri a ko laŋŋɩ Siimɔŋ dɩya dimbee nyʋwa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu gyɩ tɩɩbɩ nala hʋ yʋga aa wɩɩlɩ, a kile gyɩŋbɔmɔ mɛ yʋga ta nala tɩyaŋ. Gyɩŋsɩ hʋ gyɩ gyɩŋ nal hʋ Yesu aa yaa rɛ. Ɛɛ rɛ tɩŋ ʋ gyɩ bɩ leŋ ba basɩ wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ʋ sɩgballɩnyʋwa, Yesu sii lɩɩ dɩya hʋ tɩyaŋ a mʋ lee hʋ nala aa tuwo dɩ ʋ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ɛɛ rɛ ka Siimɔŋ bee ʋ kyaŋsɩ hʋ mɛ sii ko a kɩ kyɛ ʋ. ");
INSERT INTO sig_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba aa ko na ʋ, ba basɩ tɩya ʋ a baa, “Nala buloŋ nɛ ko kɩ kyɛ ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma leŋ dɩ á mʋ tɔnɩ hʋ mɛ aa kpaga daha, dɩ ŋ basɩ Wɩɩsɩ wɩya doŋma mɛ, beewɩya ɛɛ wɩya rɛ ŋ ko.” ");
INSERT INTO sig_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ʋ yaŋ sii a mʋ gbɛ Galili paalʋʋ buloŋ, a gyʋʋ Gyuuma wɩɩkyʋwaldɩɩsɩ a kɩ basɩ Wɩɩsɩ wɩya aŋ pɛ kile gyɩŋsɩ mɛ nala tɩyaŋ a ta. ");
INSERT INTO sig_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɛɛ rɛ gbege kɩdɩgɩ mɛ sii ko Yesu lee a tuu gbinni a sʋla ʋ a baa, “Dɩ ɩ rɛ aa kyɛ, ɩ sɩ wuwo leŋ dɩ ŋ deye.” ");
INSERT INTO sig_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ʋ aa basɩ gɛɛ, sikii kaŋ Yesu. Ʋ lɩɩ ʋ noŋ a dige ʋ aŋ baa, “Ŋ aa kyɛ rɛ, deye!” ");
INSERT INTO sig_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɛɛ rɛ gbegisi hʋ pirigi leŋ baal hʋ, ʋ deye. ");
INSERT INTO sig_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ɛɛ rɛ Yesu basɩ tɩya ʋ abee sɩfɩyaŋ a baa, ");
INSERT INTO sig_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kɩ mʋ aŋ ta basɩ wɩɩ no tɩya nal buloŋ. Amɛ kaŋ ɩ tɩɩ mʋ daga wɩɩkywal sɩlaala nɩhɩyawʋ hʋ, dɩ ʋ lɩɩ wɩɩsʋlɩɩ tɩya Wɩɩsɩ, a pɩɩsɩ ɩ bisiŋ ta anɩɩ Moosi fa aa daga ma gɛɛ. Dɩ ɩ rɛ yaa gɛɛ, nal buloŋ sɩ na anɩɩ ɩ bɩl bɩ kaŋ bisiŋ.” ");
INSERT INTO sig_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aŋka baal hʋ vɩya aŋ kaŋ wɩɩ hʋ lɩɩ basɩ a taalɩ lee buloŋ. Ɛɛ rɛ tɩŋ Yesu bɩl bɩ wuwo dɩ ʋ gyʋʋ tɔɔ buloŋ tɩyaŋ. Amɛ ʋ aa hɔŋ beye samanɩ tɩyaŋ nɛ, ka nala lɩɩ lee kɛ buloŋ a kɩ ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kyɛyɛ baŋmana hal, Yesu mɩɩgɩ mʋ Kapɛɛnam. Nala nɩɩ dɩ ʋ mɩɩgɩ ko a we dɩya tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɛɛ rɛ nala yʋga giri ko su lee hʋ buloŋ, a tɔ dimbeenyʋwa hʋ, ka ʋ basɩ Wɩɩsɩ wɩya kɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɛɛ rɛ dɩ nala badɔmɔŋ mɛ rɛ gɛɛ. Ba banaa kpa gbarɩgɩ kɩdɩgɩ aa pɩŋ ʋ wasa tɩyaŋ a kaŋ ko. ");
INSERT INTO sig_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nala aa tɔɔ lee hʋ buloŋ gɛɛ, ba bɩ gyɩŋ lee hʋ ba aa sɩ tɩŋa a gyʋʋ. Ɛɛ rɛ ba gyɩŋ dɩya hʋ nyuu, a luri lee, a kpa gbarɩgɩ hʋ abee ʋ wasa buloŋ a tɩŋ doŋ ta, ʋ tuu pɩŋ Yesu sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ba aa yaa gɛɛ rɛ Yesu gyɩma anɩɩ ba kɔnɩ laa ʋ di rɛ weliŋ. Ɛɛ rɛ ʋ basɩ tɩya gbarɩgɩ hʋ a baa, “Ŋ biye, ŋ kpaa ɩ wɩbɔmɔ kyɛ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dɩ Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ mɛ hɔŋ doŋ. Ɛɛ rɛ ba kɩ bɩɩnɩ ba tɩsɩ tɩyaŋ a baa, ");
INSERT INTO sig_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bee rɛ tɩŋ baal no kɩ basɩ gɛɛ? Bee rɛ tɩŋ ʋ kɩ tʋʋsɩ Wɩɩsɩ nyɛ? Aŋnɛ rɛ sɩ wuwo kpa nal wɩbɔmɔ kyɛ ʋ, dɩ Wɩɩsɩ dʋŋ daa?” ");
INSERT INTO sig_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu wuwo gyɩŋ ba tɩbɩɩna, a pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ bɩɩnɩ wɩya no? ");
INSERT INTO sig_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ŋ aa sɩ basɩ tɩya gbarɩgɩ hʋ dɩ ŋ kpaa ʋ wɩbɔmɔ kyɛ ʋ rɛ, abee ŋ fa aa sɩ basɩ tɩya ʋ dɩ ʋ sii kpa ʋ wasa a kɩ mʋ, ba tɩyaŋ kɩbee rɛ yaa mɔl? ");
INSERT INTO sig_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ŋ sɩ daga ma anɩɩ mɩyaŋ, Nihuwobiŋ biye, kaŋ dee rɛ dʋnɩya tɩyaŋ dɩ ŋ kpa nala wɩbɔmɔ kyɛ ba.” ");
INSERT INTO sig_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ɛɛ rɛ ʋ basɩ tɩya gbarɩgɩ hʋ a baa, “Sii kpa ɩ wasa a kɩ mʋ dɩya.” ");
INSERT INTO sig_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baal hʋ nyagɩ sii sɩŋ, a kpa ʋ wasa a vala lɩɩ ba sɩya. Ba buloŋ hirigi, a dannɩ Wɩɩsɩ a baa, “Á ha bɩ maakyiye na wɩɩ no dɔŋtɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɛɛ rɛ Yesu sii doŋ a mɩɩgɩ tuu fuwo hʋ nyʋwa. Nɩgyamaa ko gol-ʋ, ʋ kɩ daga ba. ");
INSERT INTO sig_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ʋ kpaa kɩ mʋ sɩya dɩ ʋ naa lampolaal kɩdɩgɩ ba aa yɩrɩ Levi, a yaa Alfiyasɩ biibaal, dɩ ʋ hɔŋ ʋ tʋŋtʋnnɩ-dɩya tɩyaŋ. Ɛɛ rɛ Yesu yɩrɩ ʋ dɩ ʋ sii ko kɩ tɩŋa ʋ hal. Ʋ sii tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nyɛ rɛ Yesu mʋ gyʋʋ Levi dɩya, ʋ bee ʋ hatɩnna buloŋ, a hɔŋ kɩ di kɩna. Lampolaala badɔmɔŋ abee wɩbɔŋyaala mɛ ko, ba buloŋ laŋŋɩ kɩ di kɩna hʋ. Lampolaala abee wɩbɔŋyaala fa yʋga rɛ weliŋ a kɩ tɩŋa Yesu hal. ");
INSERT INTO sig_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ fa we doŋ a yaa Farasiima. Ɛɛ rɛ ba naa ba, a ko pɩyɛsɩ Yesu hatɩnna hʋ a baa, “Bee rɛ tɩŋ Yesu bee wɩbɔŋyaala abee lampolaala buloŋ laŋŋɩ hɔŋ kɩ di kɩna?” ");
INSERT INTO sig_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu nɩɩ wɩɩ hʋ ba aa basa, a mɩɩgɩ basɩ tɩya ba a baa, “Nala hʋ aa kaŋ laaŋfɩya bee kyɛ nal dɩ ʋ tɩɩbɩ ba, see nala hʋ aa wɩɩlɩ. Ŋ ko dɩ ŋ yɩrɩ wɩbɔŋyaala rɛ dɩ ba leŋ ba wɩbɔmɔ. Nala hʋ aa yaa tɩpʋlʋŋ tɩmma daa ŋ ko dɩ ŋ yɩrɩ.” ");
INSERT INTO sig_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saŋa kɩdɩgɩ, Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ hatɩnna abee Farasiima gyɩ aa vʋwa nyʋwa rɛ. Ɛɛ rɛ nala badɔmɔŋ sii ko pɩyɛsɩ Yesu a baa, “Bee rɛ tɩŋ Gyɔɔŋ hatɩnna abee Farasiima kɩ vʋwa nyʋwa, aŋka ɩ hatɩnna kɛ bee vʋwa nyʋwa?” ");
INSERT INTO sig_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Dɩ hafalɩɩ bala bee ʋ kyaŋsɩ rɛ aa gbɩyalɩ ʋ haaŋ hʋ gbɩyala, ʋ kyaŋsɩ hʋ sɩ wuwo vʋwa nyʋwa? Aayɩ, dɩ ba ha we gbɩyala hʋ tɩyaŋ, ʋ kyaŋsɩ hʋ bɩ sɩ vʋwa nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amɛ saŋa kɩdɩgɩ rɛ sɩ ko pele dɩ ba kaŋ baal hʋ mʋ lee kɩdɩgɩ. Ɛɛ tɩyaŋ nɛ ʋ kyaŋsɩ hʋ yaŋ sɩ vʋwa nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ɛɛ rɛ ʋ bɩl basɩ tɩya ba a baa, “Nal buloŋ bɩ sɩ kpa taŋfalɩɩ a ala tɔ gabɩnɩɩ bol? Dɩ ɩ rɛ yaa gɛɛ, taŋfalɩɩ hʋ sɩ kʋʋrɩ, dɩ gabɩnɩɩ hʋ marɩ kɩyasɩ pɛ. ");
INSERT INTO sig_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dɩ ɩ rɛ kaŋ pulbɩnɩɩ, ɩ sɩ yaa sɩhuwo a we dɩ ʋ wii? Aayɩ, dɩ ɩ rɛ yaa gɛɛ, pulbɩnɩɩ hʋ sɩ pɔsɔ dɩ sɩŋ hʋ buloŋ ta. Ba aa kpa sɩhuwo we pulfalɩɩ tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kyɛwiyesii hʋ kyɛɛ kɩdɩgɩ, Yesu bee ʋ hatɩnna hʋ sii a mʋ tɩŋ nyoŋso baga kɩdɩgɩ tɩyaŋ a kɩ mʋ. Ʋ hatɩnna hʋ bori nyoŋso hʋ a piisi kɩ kyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɛɛ rɛ Farasiima badɔmɔŋ pɩyɛsɩ Yesu a baa, “Ɩ bɩ naa? Kyɛwiyesii hʋ kyɛɛ sɩna daa ɩ hatɩnna hʋ kɩ kyogi gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɛɛ rɛ Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Ma ha bɩ maakyiye karɩmɩ wɩɩ hʋ Deviti gyɩ aa yaa? Losi gyɩ kaŋ ʋ bee ʋ hatɩnna rɛ, ");
INSERT INTO sig_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ʋ mʋ gyʋʋ Wɩɩsɩ dɩya hʋ a kpa paanʋʋ hʋ ba fa aa kaŋ ko biŋ Wɩɩsɩ sɩya tɩyaŋ, a lɔgɔ kyaŋ aŋ kpa tɩya ʋ hatɩnna hʋ mɛ, ba mɛ kyaŋ. Ʋ fa yaa sɩna rɛ anɩɩ nɩwaasɩ aa sɩ kpa haŋ paanʋʋ hʋ dige ʋ nyʋwa, see nala hʋ aa yaa wɩɩkyʋwal sɩlaala dʋŋ, ka Deviti bee ʋ nala gyɩ kpa kyaŋ gɛɛ. Haŋ saŋa hʋ tɩyaŋ Abiyata rɛ gyɩ yaa wɩɩkyʋwal sɩlaala buloŋ nɩhɩyawʋ.” ");
INSERT INTO sig_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Wɩɩsɩ lɩɩ Kyɛwiyesii hʋ kyɛɛ nihuwobisi wɩya rɛ, amɛ Kyɛwiyesii hʋ kyɛɛ wɩya daa ʋ marɩ nihuwobiŋ. ");
INSERT INTO sig_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mɩyaŋ, Nihuwobiŋ biye rɛ yaa Kyɛwiyesii hʋ kyɛɛ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nyɛ rɛ Yesu gyɩ sii a bɩl mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya kɩdɩgɩ, dɩ baal kɩdɩgɩ noŋ aa sʋba mɛ gyɩ we doŋ. ");
INSERT INTO sig_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nala hʋ aa naa Yesu dɩ ʋ gyʋwa, ba buloŋ lɩɩ sɩya pɔ ʋ tɩyaŋ, a kɩ deŋ dɩ ba na dɩ ʋ sɩ tɩɩbɩ baal hʋ Kyɛwiyesii hʋ kyɛɛ koo. Badɔmɔŋ fa aa kyɛ dɩ ba na wɩɩ rɛ, a tɩŋ doŋ a kaŋ Yesu, a basɩ tɩya ʋ anɩɩ ʋ kyogi ba sɩŋsɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ɛɛ rɛ Yesu basɩ tɩya nosʋʋ hʋ tɩɩna dɩ ʋ sii ko lɩɩ sɩŋ ba sɩya tɩyaŋ. Ʋ sii lɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɛɛ rɛ Yesu pɩyɛsɩ nala hʋ a baa, “Ɛɛ rɛ ma naabaala lesiri daga dɩ ma kɩ yaa Kyɛwiyesii hʋ kyɛɛ? Dɩ ma kɩ pɛ nala tɩyaŋ koo, dɩ ma kɩ dɔgɩsɩ ba? Dɩ ma kɩ laa nala mɩɩbolo koo, dɩ ma kɩ kpʋ ba?” Ʋ aa pɩyɛsɩ gɛɛ, ba yaa sɩrɩtɩtɩ. ");
INSERT INTO sig_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɛɛ rɛ Yesu na baaŋ ba nyuu tɩyaŋ. Ʋ tɩya buloŋ gyɩ kyogo rɛ akuu ba dɩgɩna aa bee nɩɩ wɩya nyuniŋ. Ɛɛ rɛ ʋ basɩ tɩya nosʋʋ hʋ tɩɩna a baa, “Kaŋ ɩ noŋ tannɩ.” Ʋ kaŋ tannɩ, ʋ bɩrɩmɩ noduwo. ");
INSERT INTO sig_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ɛɛ rɛ Farasiima hʋ sii lɩɩ, ba bee Hɛrɔtɩ hatɩnna mʋ vʋʋlɩ gɛɛ ba aa sɩ yaa a kaŋ Yesu kpʋ. ");
INSERT INTO sig_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ gyɩ sii tuu fuwobal hʋ nyʋwa. Nɩgyamaa aa lɩɩ Galili paalʋʋ sii giri tɩŋ ba hal. ");
INSERT INTO sig_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nala gyɩ aa nɩɩ wɩya hʋ buloŋ Yesu aa yaa, nɩgyamaa sii lɩɩ Gyudɩya paalʋʋ, abee Gyerusalɛm, abee Idumiya paalʋʋ, abee Gyɔɔdaŋ fuwo hʋ kyolo abee Taaya abee Siidɔŋ paalʋʋ, a kɩ ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gyamaa hʋ gyɩ aa ko yʋga gɛɛ, ʋ basɩ tɩya ʋ hatɩnna hʋ dɩ ba mʋ kpa nɩɩduworiboro ko sɩgɩ nɩɩ hʋ nyʋwa dɩ ʋ gyʋʋ, dɩ nala hʋ ta ko yige ʋ lo. ");
INSERT INTO sig_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu fa tɩɩbɩ nala rɛ yʋga. Ɛɛ wɩya nala hʋ fa aa wɩɩlɩ buloŋ fa ko kaŋ ʋ bagɩna tɩyaŋ nɛ a kɩ kyɛ dɩ ba dige ʋ. ");
INSERT INTO sig_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ba tɩyaŋ, nala gyɩŋbɔmɔ fa aa kana we doŋ. Dɩ gyɩŋbɔmɔ ko na Yesu buloŋ, ba aa tuu tele ʋ sɩya tɩyaŋ nɛ a kɩ kyɩɩrɩ aŋ kɩ basɩ, “Ɩ rɛ yaa Wɩɩsɩ biye hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɛɛ rɛ ʋ aa basɩ tɩya gyɩŋbɔmɔ hʋ abee sɩfɩyasɩ buloŋ dɩ ba ta ko daga kɩ tɩya nala, nal hʋ ʋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɛɛ rɛ Yesu sii lɩɩ doŋ, a mʋ gyɩŋ dogimo kɩdɩgɩ, a yɩrɩ nala hʋ buloŋ ʋ aa kyɛ, ba mʋ laŋŋɩ ʋ lee. ");
INSERT INTO sig_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ɛɛ rɛ ʋ bɩl lɩɩ ba tɩyaŋ nala fi abee balɩya, dɩ ba yaa ʋ kpambɩsɩ, a we ʋ lee, dɩ ʋ ko leŋ dɩ ba mɛ mʋ basɩ Wɩɩsɩ wɩya a kɩ tɩya nala. ");
INSERT INTO sig_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ka dɩ ʋ tɩya ba dee mɛ dɩ ba wuwo kaŋ kɩ kile gyɩŋsɩ nala tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nala hʋ fi abee balɩya ʋ gyɩ aa lɩya, ba fene rɛ nyɛ: Siimɔŋ, Yesu fa kana ʋ kɩ yɩrɩ Piita. ");
INSERT INTO sig_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi biisi hʋ balɩya, Gyemsi abee ʋ naabiibaal Gyɔɔŋ. Yesu fa kaŋ ba mɛ kɩ yɩrɩ Buwanagyisi. Feŋ no yaa namaga feŋ nɛ. Ʋ memii rɛ yaa gaduwo-kyagɩŋsɩyaala anɩɩ duwoŋ nɔsɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ba nɩkaalɩya hʋ mɛ rɛ nyɛ: Aŋduru abee Fɩlɩpɩ abee Batolomi abee Matiwu abee Tɔmaasɩ abee Gyemsi, Alfiyasɩ biibaal hʋ, abee Tadiyo abee Siimɔŋ, nal hʋ aa kyɩl ʋ nala wɩya kɩŋkaŋ, ");
INSERT INTO sig_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bee Gyudasɩ Isɩkarɔtɩ, nal hʋ aa ko kpa Yesu yallɩ. ");
INSERT INTO sig_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu aa ko lɩɩ nala no mʋ teŋ, ʋ mɩɩgɩ mʋ dɩya. Ɛɛ rɛ nala bɩl ko gol ʋ bee ʋ hatɩnna hʋ, ba paalɩ bɩ naa sɩnɩɩ dɩ ba di kɩdiiliye mɛ gba. ");
INSERT INTO sig_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ʋ dɩya nala aa ko nɩɩ ʋ wɩya, ba sii lɩɩ dɩ ba kana ʋ, beewɩya nala fa aa basɩ rɛ anɩɩ ʋ aa kyɛ ʋ yaarɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ mɛ gyɩ we doŋ. Ba gyɩ lɩɩ Gyerusalɛm nɛ a ko, a mɛ baa dɩ gyɩŋbɔmɔ buloŋ kuwori ba aa yɩrɩ “Bɛlizebul” lɛ kana ʋ. Dɩ ʋ rɛ tɩya ʋ dee hʋ ʋ kɩ kile gyɩŋsɩ nala tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ɛɛ rɛ Yesu yɩrɩ ba, a maga namaga no tɩya ba a baa, “Ɛɛ rɛ Sɩtaanɩ sɩ yaa a kile ʋ tɩɩtɩɩ noŋ nala? ");
INSERT INTO sig_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Dɩ bee nala rɛ we doŋ aŋ bɩ kaŋ nyʋʋdɩgɩ, ba bee hʋ sɩ sɩŋ? ");
INSERT INTO sig_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dɩ dɩɩdɩgɩ nala mɛ ko bɩ kaŋ nyʋʋdɩgɩ, ka dɩ ba kɩ kaa kaasɩ, ba dɩya hʋ mɛ bɩ sɩ sɩŋ. ");
INSERT INTO sig_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dɩ Sɩtaanɩ bee ʋ noŋ nala mɛ yaŋ ko bɩ kaŋ nyʋʋdɩgɩ, ba bee mɛ bɩ sɩ sɩŋ. Ʋ sɩ tele teŋ. ");
INSERT INTO sig_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nal tuwo ʋ aa sɩ wuwo gyʋʋ gaduwogi dɩya a gaa ʋ kɩna, see ʋ aa laa sɩya kaŋ gaduwogi hʋ vʋwa biŋ, aŋ na wuwo gyʋʋ paa ʋ kɩna.” ");
INSERT INTO sig_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ nal lɛ yaa wɩbɔmɔ mɔɔgɛɛ buloŋ, aŋ pɛ tʋʋsɩ Wɩɩsɩ mɛ gba, ka Wɩɩsɩ ha sɩ wuwo kpa ba buloŋ kyɛ ʋ. ");
INSERT INTO sig_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amɛ dɩ nal lɛ tʋʋsɩ Wɩɩsɩ Wiyesi Welii hʋ, Wɩɩsɩ bɩ sɩ maakyiye kpa kyɛ ʋ buloŋ. Sʋʋkpʋŋ wɩbɔŋ aa bɩ kaŋ marɩ layɩ rɛ ʋ tɩɩna yaa gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nala hʋ badɔmɔŋ aa basɩ baa dɩ gyɩŋbɔŋ nɛ kaŋ ʋ hʋ, ɛɛ rɛ tɩŋ ʋ basɩ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mʋhʋ ko pɛ dɩ Yesu nɩɩna abee ʋ naabalɩya ko a sɩŋ gyaŋhal tɩyaŋ aŋ tɩŋ nal dɩ ʋ gyʋʋ yɩrɩ ʋ. Tɩŋdaal hʋ aa gyʋʋ ");
INSERT INTO sig_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","dɩ nɩgyamaa hɔŋ gol-ʋ. Ɛɛ rɛ ba laa basɩ tɩya ʋ a baa, “Ɩ naa abee ɩ naabalɩya rɛ sɩŋ gyaŋhal tɩyaŋ a kɩ kyɛ ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ɛɛ rɛ Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Aŋnɛ rɛ yaa ŋ naa abee ŋ naabalɩya?” ");
INSERT INTO sig_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aŋ mɩɩgɩ deŋ nala hʋ aa hɔŋ gol-ʋ, aŋ basɩ tɩya ba a baa, “Ma na, ŋ naa abee ŋ naabalɩya rɛ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nal hʋ buloŋ aa yaa wɩya hʋ Wɩɩsɩ aa kyo, ʋ rɛ yaa ŋ naabiibaal, abee ŋ naatoluu, abee ŋ naa.” ");
INSERT INTO sig_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɛɛ rɛ Yesu bɩl mɩɩgɩ mʋ hɔŋ Galili fuwobal hʋ nyʋwa a kɩ daga nala. Nɩgyamaa sii giri ko kyige ʋ. Ʋ aa ko na gyamaa hʋ yʋga gɛɛ, ʋ sii mʋ gyʋʋ nɩɩduworiboro, a hɔŋ nɩɩ hʋ tɩyaŋ, ka nala hʋ sɩŋ fuwo hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Doŋ tɩyaŋ nɛ ʋ kpa namagɩsɩ a daga ba wɩya yʋga. Ʋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ma gyegili nɩɩ daha! Baal kɩdɩgɩ rɛ gyɩ sii a kaŋ ʋ kɩdoho mʋ dɩ ʋ gyaasɩ. ");
INSERT INTO sig_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ʋ aa gyaasɩ kɩna hʋ tɩyaŋ nɛ, biye hʋ badɔmɔŋ tele nɩɩbʋʋsɩ hʋ tɩyaŋ. Digibiisi ko tuu tʋwasɩ di. ");
INSERT INTO sig_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Badɔmɔŋ mɛ tele bʋnyɩŋ tɩyaŋ. Bʋnyɩŋ hʋ fa bɩ kaŋ taŋha yʋga. Ɛɛ wɩya, kɩna hʋ teŋ pesi nyʋ. Amɛ ba naaliliye bɩ wuwo gyʋʋ taŋha. ");
INSERT INTO sig_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɛɛ rɛ wɩɩsɩ nʋŋ kpʋ ba, beewɩya ba naaliliye bɩ gyʋʋ taŋha. ");
INSERT INTO sig_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Biye hʋ badɔmɔŋ mɛ tele sɔsɩ tɩyaŋ a nyʋ. Amɛ sɔsɩ hʋ sii gɩrɩgɩ ba, ba nʋŋ pʋgɩmɩ kɩna hʋ, ba bɩ wuwo we biye. ");
INSERT INTO sig_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Biye hʋ badɔmɔŋ mɛ tele taŋha welii tɩyaŋ a nyʋ, a waa, a marɩ weliŋ. Badɔmɔŋ we biye mɔlɩya bee fi fi, badɔmɔŋ mɛ mɔllɩboto boto, badɔmɔŋ mɛ kɔɔ kɔɔ.” ");
INSERT INTO sig_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu aa maga namaga hʋ ko teŋ, ʋ basɩ tɩya ba a baa, “Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saŋa hʋ gyamaa hʋ buloŋ aa mʋwa, aŋka Yesu bee ʋ kpambɩsɩ fi abee balɩya hʋ, abee ʋ hatɩnna badɔmɔŋ dʋŋ, ba pɩyɛsɩ ʋ namagɩsɩ hʋ memii. ");
INSERT INTO sig_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ma nala no kɛ, Wɩɩsɩ leŋ ma gyɩŋ wɩya hʋ aa yaa wɩfaŋɩya ʋ koro hʋ tɩyaŋ memii rɛ. Amɛ nɩkaalɩya hʋ kɛ buloŋ, namagɩsɩ rɛ ba kpa kɩ daga ba Wɩɩsɩ koro hʋ wɩya, ");
INSERT INTO sig_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","dɩ gɛɛ leŋ, ‘ba aa gyegili, gyegili aŋ bɩ wuwo kɩ gyɩŋ ba memii, a bɩl deŋ deŋ mɛ aŋ bɩ wuwo kɩ na kɩŋ buloŋ. Dɩ ba aa rɛ fa gyɩŋ ba memii, ba fa sɩ bɩrɩmɩ tɩŋ Wɩɩsɩ, dɩ ʋ kpa ba wɩbɔmɔ kyɛ ba.”’ ");
INSERT INTO sig_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ma bɩ gyɩŋ namaga no memii? Ɛɛ rɛ ma yaŋ sɩ yaa a gyɩŋ namagɩsɩ buloŋ memiye? Aŋ daga ba namaga hʋ memii a baa, ");
INSERT INTO sig_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wɩɩsɩ wɩweliye hʋ rɛ kɩdohil hʋ kaŋ lɩɩ dɩ ʋ basɩ tɩya nala. ");
INSERT INTO sig_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nala badɔmɔŋ kɩɩ gɛɛ rɛ anɩɩ kɩdoho hʋ aa tele nɩɩbʋʋsɩ hʋ tɩyaŋ. Nala no aa nɩɩ Wɩɩsɩ wɩweliye hʋ rɛ, ka haŋ lagɩlagɩbiye hʋ, Sɩtaanɩ teŋ ko kaŋ wɩɩ hʋ a lɩɩ ba tɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nala badɔmɔŋ mɛ kɩɩ gɛɛ rɛ anɩɩ kɩna hʋ aa tele bʋnyɩŋ hʋ tɩyaŋ. Nala no aa nɩɩ Wɩɩsɩ wɩweliye hʋ, a pesi laa di abee teŋfɩyɛlʋʋ. ");
INSERT INTO sig_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amɛ wɩɩ hʋ aa bee pɩŋ ba hakɩllɩ tɩyaŋ anɩɩ kɩna hʋ naaliliye a bɩ gyʋʋ taŋha gɛɛ. Ba aa laa wɩɩ hʋ rɛ a tɩŋa mʋ maga gɛɛ. Amɛ dɩ tʋwara rɛ ko gyʋʋ ba, koo dɩ ba tɩŋ naasɩ kɩ dɔgɩsɩ ba wɩɩ hʋ wɩya, ba lɔgʋ aa lɩɩ wɩɩ hʋ rɛ, ba kpa ta. ");
INSERT INTO sig_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nala badɔmɔŋ mɛ kɩɩ gɛɛ anɩɩ kɩna hʋ aa tele sɔsɩ hʋ tɩyaŋ. Ba aa nɩɩ Wɩɩsɩ wɩweliye hʋ, ");
INSERT INTO sig_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amɛ dʋnɩya kɩna wɩya kyɩl ba. Ba aa kyo dɩ ba yaa kɩna tɩmma dʋnɩya tɩyaŋ wɩya, ba kɩkyɛɛlɩya hʋ aa kɩ mʋrɩ ba rɛ, ba bɩ laa wɩya hʋ di. Ɛɛwɩya, wɩya hʋ aa bɩ kaŋ doho ba lee. ");
INSERT INTO sig_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nala badɔmɔŋ mɛ kɩɩ gɛɛ anɩɩ kɩna hʋ aa tele taŋha welii hʋ tɩyaŋ. Nala no rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩweliye hʋ, a laa di, ʋ we ba tɩsɩ tɩyaŋ, ʋ kaŋ doho, a we biye, badɔmɔŋ mɔlɩya bee fi fi, badɔmɔŋ mɔllɩboto boto, badɔmɔŋ kɔɔ kɔɔ.” ");
INSERT INTO sig_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ba a baa, “Dɩ ɩ rɛ aa kyɛ pʋlʋŋ a kyol fɩŋtɩna ko gyʋʋ dɩya, ɩ sɩ kpa gbaha a kyige tɔ? Koo, ɩ sɩ kpa sɩgɩ ɩ godo memii? Koo, ɩ aa kpa ɩ saga kɩŋ nyuu tɩyaŋ nɛ dɩ ʋ kyaanɩ? ");
INSERT INTO sig_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wɩfaŋɩɩ tuwo aa bɩ sɩ ko lɩɩ lɩgyalɩɩ. Wɩɩ mɛ buloŋ aa we bilhuu tɩyaŋ, ʋ sɩ ko lɩɩ pʋlʋŋ. ");
INSERT INTO sig_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nala hʋ aa kaŋ dɩgɩna, ma gyegili kɩ nɩɩ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ʋ bɩl basɩ tɩya ba a baa, “Ma fɩyɛlɩ ma sɩya weliŋ abee wɩya hʋ ma aa kɩ nɩɩ. Haŋ wɩɩ hʋ ma aa sɩ kpa yaa ma dɔŋtɩŋsɩ, ʋ tɩɩ rɛ Wɩɩsɩ mɛ sɩ kpa yaa ma. Ʋ gba sɩ yaa ma te gɛɛ hʋ ma aa kpaa kɩ yaa ma dɔŋtɩŋsɩ. ");
INSERT INTO sig_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nal hʋ aa kaŋ kɩna yʋga, Wɩɩsɩ sɩ marɩ tɩya ʋ pɛ. Amɛ nal hʋ mɛ aa bɩ kaŋ kɩna yʋga, mʋhʋ hʋ mɛ ʋ aa kana, Wɩɩsɩ sɩ kaŋ laa ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu bɩl basɩ tɩya ba a baa, “Wɩɩsɩ koro hʋ kɩɩ gɛɛ rɛ anɩɩ nal aa siye a mʋ gyaasɩ kɩdoho ʋ baga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lee bil ʋ mɩɩgɩ mʋ pɩŋ. Sɩya gballɩ ʋ bɩl sii mʋ. Kyɛyɛ baŋmana hal ʋ sii kɩ mʋ dɩ kɩdoho hʋ nyʋwa, a waa, ka ʋ bɩ gyɩŋ ba aa yaa gɛɛ nyʋ. ");
INSERT INTO sig_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ba nyʋwa rɛ ba tɩɩ, a waa, a we biye, a hɩla ba tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ba aa ko hɩla ko teŋ, ʋ leŋ ba mʋ kʋma.” ");
INSERT INTO sig_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ba a baa, “Bekiŋ nɛ á sɩ kpa Wɩɩsɩ koro hʋ magɩsɩ? Namaga bee rɛ á sɩ kpa daga ʋ memii? ");
INSERT INTO sig_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ʋ kɩɩ gɛɛ rɛ anɩɩ kɩdoho bii kɩdɩgɩ ba aa yɩrɩ masɩtadɩ. Masɩtadɩ bii rɛ muro te tɩya buloŋ bii. ");
INSERT INTO sig_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amɛ dɩ ʋ ko nyʋ ʋ aa waa tɩɩbal lɛ a te kɩdohii kɛ buloŋ. Ʋ aa lɩɩ naasɩ yʋga rɛ digibiisi aa ko saga ʋ tɩyaŋ a sʋwa ba gyannɩ doŋ.” ");
INSERT INTO sig_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu maga namagɩsɩ no iriŋ nɛ yʋga a kɩ daga nala Wɩɩsɩ wɩya. Ʋ aa kɩ daga ba a maga gɛɛ hʋ ba aa sɩ wuwo kpa a we ba nyuni tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ʋ aa bɩ laa nyʋwa basɩ wɩɩ buloŋ polli, see dɩ ʋ kaŋ maga namaga. Amɛ dɩ ʋ bee ʋ hatɩnna hʋ dʋŋ nɛ ko hɔŋ, ʋ aa daga namagɩsɩ hʋ memiye rɛ a tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Haŋ kyɛɛ hʋ tɩɩtɩɩ dɩdaana, ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ a kyol fuwo hʋ kyolo.” ");
INSERT INTO sig_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba ta haŋ nɩgyamaa hʋ buloŋ ba mʋ, aŋ ko gyʋʋ nɩɩduworiboro hʋ tɩyaŋ ʋ fa aa hɔnɔ hʋ a kpa kɩ mʋ. Nɩɩduworiborisi badɔmɔŋ mɛ fa we doŋ nɛ a kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɛɛ rɛ dɩ dopuwo kɩdɩgɩ piili kɩ yaa, a ko ŋmaa nɩɩ kɩ we nɩɩduworiboro hʋ tɩyaŋ, ʋ kɩ kyɛ dɩ ʋ su. ");
INSERT INTO sig_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Amɛ Yesu fa pɩŋ doo rɛ nɩɩduworiboro hʋ hal tɩyaŋ, a yelli nyuyellii. Ʋ hatɩnna hʋ ko kyisi ʋ a basɩ tɩya ʋ a baa, “Á Tɩɩna, ɩ sɩya tuwo koo? Ɩ bɩ gyɩma dɩ á aa kyɛ á sʋba rɛ?” ");
INSERT INTO sig_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ɛɛ rɛ ʋ sii doo hʋ tɩyaŋ a nɔsɩ puwo hʋ dɩ ʋ ta kɩ yaa, aŋ basɩ tɩya fuwo hʋ mɛ dɩ ʋ fɩyɛlɩ pɩŋ. Puwo hʋ sige, ka lee hʋ buloŋ yaa siyee. ");
INSERT INTO sig_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Bee rɛ tɩŋ kambɩŋ kaŋ ma? Ma ha bɩ laa ŋ di?” ");
INSERT INTO sig_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɛɛ rɛ kambɩŋ marɩ kaŋ ba weliŋ, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Nɩgɛɛ doho paalɩ yaa baal no? Puwoni abee fuwoni buloŋ kɩ tɩŋa ʋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ sii kyol Galili fuwobal hʋ kyolo a mʋ pele Gɛrasa tɩmma paalʋʋ a lɩɩ nɩɩduworiboro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu aa lɩɩ dɩ ʋ sɩŋ, dɩ baal kɩdɩgɩ gyɩŋbɔmɔ gyɩ aa kana rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ʋ gyɩ lɩɩ bilni tɩyaŋ nɛ a kɩ ko dɩ ʋ kyem-ʋ. Bilni hʋ nyuni tɩyaŋ nɛ ʋ gyɩ aa gɔllɩ we. ");
INSERT INTO sig_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ba gyɩ aa kaŋ kyɔrʋmɔ vʋwa ʋ rɛ, a mʋ lɔlɔ, beewɩya ba aa ko vʋwa ʋ buloŋ, ʋ aa kaŋ tɔrɩ rɛ. Ba aa kana ʋ we kpɩyasɩ mɛ, ʋ ŋmaa kpɩyasɩ hʋ bori. Nal buloŋ tuwo aa sɩ wuwo kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wɩɩhaa abee tebine buloŋ, ʋ gyɩ aa we bilni abee dogiŋsi nyuu tɩyaŋ nɛ a kɩ gbɛ, a kɩ kyɩɩrɩ aŋ paa bʋwa kɩ paasɩ ʋ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ʋ aa naa Yesu dɩ ʋ we libolii, ʋ fá mʋ kyem-ʋ, a tuu gbinni ʋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ɛɛ rɛ Yesu basɩ tɩya gyɩŋbɔŋ hʋ dɩ ʋ lɩɩ baal hʋ tɩyaŋ. Baal hʋ kyɩɩrɩ a baa, “Yesu, Wɩɩbal hʋ biye, bee rɛ ɩ kɩ kyɛ dɩ ɩ yaa ŋ? Ŋ kpaa Wɩɩsɩ kyʋgɩ ɩ! Ta dɔgɩsɩ ŋ.” ");
INSERT INTO sig_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ɩ feŋ nɛ bee?” Ʋ baa, “Ŋ feŋ nɛ kɩgyamaa, beewɩya á yʋga rɛ daha.” ");
INSERT INTO sig_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɛɛ rɛ ʋ sʋla Yesu kɩŋkaŋ dɩ ʋ ta leŋ dɩ gyɩŋsɩ hʋ lɩɩ doŋ paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dɩ porikulaal mɛ sɩŋ doŋ, a kɩ di kɩna dogimo hʋ nyuu. ");
INSERT INTO sig_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gyɩŋsɩ hʋ sʋla Yesu dɩ ʋ leŋ dɩ ba mʋ gyʋʋ porikusi hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ʋ laa nyʋwa. Ɛɛ rɛ ba lɩɩ baal hʋ tɩyaŋ a mʋ gyʋʋ porikusi hʋ tɩyaŋ. Porikusi hʋ buloŋ sii fá lɩɩ dogimo hʋ nyuu, a mʋ tuu gyʋʋ fuwo hʋ tɩyaŋ, a nyʋwa nɩɩ sʋba. Porikusi hʋ fa pele tusi bʋlɩya. ");
INSERT INTO sig_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ɛɛ rɛ porikudaala hʋ fá mʋ heeli tɩya bagɩdaala abee tɔɔ hʋ nala buloŋ. Ba buloŋ sii ko lɩɩ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba aa ko dɩ baal hʋ gyɩŋsɩ fa aa kana hʋ, dɩ ʋ hɔnɔ a laalɩ gal a kaŋ laaŋfɩya. Ba aa naa gɛɛ, kambɩŋ gyʋʋ ba. ");
INSERT INTO sig_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nala hʋ fa aa we doŋ a naa wɩɩ hʋ aa yaa baal hʋ abee porikusi hʋ, ba basɩ wɩɩ hʋ tɩya nala hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba aa nɩɩ gɛɛ rɛ, ba ko sʋla Yesu dɩ ʋ lɩɩ ba paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ɛɛ rɛ Yesu mʋ dɩ ʋ gyʋʋ nɩɩduworiboro hʋ. Baal hʋ gyɩŋsɩ hʋ fa aa kana hʋ sʋla ʋ a baa dɩ ʋ leŋ dɩ ʋ ko dɩ ba mʋ. ");
INSERT INTO sig_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu kaŋ vɩya, aŋ basɩ tɩya ʋ dɩ ʋ mɩɩgɩ mʋ dɩya a basɩ tɩya ʋ dɩya nala wɩɩ hʋ buloŋ á Tɩɩna Wɩɩsɩ aa yaa ʋ tɩyaŋ, abee ʋ aa fáá ʋ sikii maga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baal hʋ mɩɩgɩ mʋ tɔnɩ fi hʋ aa we doŋ paalʋʋ tɩyaŋ, a basɩ wɩɩ hʋ buloŋ Yesu a yaa tɩya ʋ. Nala nɩɩ, ʋ yaa ba wɩkperii. ");
INSERT INTO sig_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ɛɛ rɛ Yesu mɩɩgɩ mʋ gyʋʋ nɩɩduworiboro hʋ a kyol fuwo hʋ kyolo a mʋ hɔŋ fuwo hʋ nyʋwa. Nala giri ko kyige ʋ. ");
INSERT INTO sig_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɛɛ rɛ dɩ baal kɩdɩgɩ we doŋ, ba kɩ yɩrɩ Gyerusi. Ʋ fa yaa Gyuuma wɩɩkyʋwaldɩya nɩhɩyawʋ rɛ. Ʋ aa naa Yesu, ʋ tuu tele ʋ naasɩ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a sʋla ʋ a baa, “Ŋ toluu rɛ aa wɩɩlɩ, a pɩŋ kɩ kyɛ dɩ ʋ sʋba. Ŋ aa sʋla ɩ dɩ ɩ ko kpa ɩ nosi dɔbɔ ʋ tɩyaŋ, dɩ ʋ deye.” ");
INSERT INTO sig_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu sii tɩŋa ʋ hal ba kɩ mʋ. Nɩgyamaa mɛ sii kɩ tɩŋa ʋ hal a gol-ʋ kyige. ");
INSERT INTO sig_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Haaŋ kɩdɩgɩ gyɩ we gyamaa hʋ tɩyaŋ a kaŋ wɩɩl kɩdɩgɩ. Ʋ gyɩ aa yaa ʋ hawɩya ba bee teŋ ʋ bɩsɩ fi abee balɩya rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʋ gyɩ gɔllɩ yaa luliye kɩŋkaŋ, a na tʋwara weliŋ, a paalɩ kyogi ʋ molbiye buloŋ ta waasʋ, ka wɩɩl hʋ gba marɩ gyʋʋ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ʋ gyɩ nɩɩ Yesu wɩya rɛ, a mɛ ko kɩ tɩŋ nala hʋ tɩyaŋ, aŋ kɩ bɩɩnɩ ʋ tɩya tɩyaŋ a baa, ");
INSERT INTO sig_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Dɩ ŋ yaŋ wuwo dige ʋ gal mɛ, ŋ sɩ deye.” Ɛɛ rɛ ʋ pɩyɛgɩ nala hʋ a mʋ sɩŋ Yesu hal a kaŋ noŋ a dige ʋ gal. ");
INSERT INTO sig_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ʋ aa dige ʋ gal hʋ tɩyaŋ nɛ, ʋ wɩɩl hʋ pirigi teŋ. Ɛɛ rɛ ʋ tɩɩ gyɩma anɩɩ ʋ wɩɩl hʋ tene rɛ. ");
INSERT INTO sig_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka Yesu mɛ gyɩma ʋ tɩya tɩyaŋ anɩɩ dee kɩdɩgɩ lɩɩ ʋ tɩyaŋ nɛ. Ʋ bɩrɩmɩ nala hʋ lee a pɩyɛsɩ ba a baa, “Aŋnɛ rɛ dige ŋ gal gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɛɛ rɛ ʋ hatɩnna baa, “Ɩ bɩ naa nala aa yʋga gɛɛ a gol-ɩ kyige? Ka ɩ bɩl kɩ pɩyɛsɩ dɩ aŋnɛ rɛ dige ɩ gal?” ");
INSERT INTO sig_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aŋka Yesu ha vɩya aŋ kɩ deŋ dɩ ʋ na nal hʋ a dige ʋ. ");
INSERT INTO sig_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Amɛ haaŋ hʋ gyɩ aa gyɩŋ wɩɩ hʋ aa yaa ʋ tɩyaŋ wɩya, ʋ ko a kɩ kyele, a tuu tele Yesu naasɩ tɩyaŋ aŋ basɩ wɩɩ hʋ buloŋ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ʋ a baa, “Ŋ toluu, ɩ laadii rɛ leŋ ɩ deye. Kɩ mʋ abee laaŋfɩya. Wɩɩl hʋ bɩl bɩ sɩ kana ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ha aa basɩ wɩya haaŋ hʋ lee gɛɛ, dɩ tɩŋdaala lɩɩ Gyerusi dɩya, a ko basɩ tɩya Gyerusi a baa, “Ɩ toluu hʋ sʋba rɛ, ta bɩl kɩ dɔŋ Tɩɩna hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu aa nɩɩ ba aa basɩ gɛɛ, ka ʋ basɩ tɩya Gyerusi a baa, “Ta leŋ dɩ ɩ bembii kɩ sii, laa ŋ di.” ");
INSERT INTO sig_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ɛɛ rɛ Yesu sii, a bɩ leŋ nal buloŋ tɩŋa ʋ hal see Piita, abee Gyemsi, abee ʋ naabiye Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɛɛ rɛ ba ko pele Gyerusi dɩya. Ba aa ko dɩ ba kaŋ kyagɩŋsɩ a kɩ ŋmaa nyʋʋsɩ bagɩbagɩ, a kɩ wii lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ʋ mʋ gyʋʋ a pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ yaa kyagɩŋsɩ no buloŋ? Biye hʋ bɩ sʋba. Ʋ ta kɩ pɩŋ doo rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba buloŋ mɩɩgɩ sɩŋ kɩ mʋma ʋ. Ɛɛ rɛ ʋ kile ba ta ba lɩɩ, aŋka ʋ kaŋ biye hʋ kuwo, abee ʋ naa, abee ʋ hatɩnna hʋ boto, ba gyʋʋ dɩya hʋ tɩyaŋ biye hʋ aa pɩna. ");
INSERT INTO sig_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ba aa gyʋʋ dɩya hʋ, Yesu mʋ kaŋ biye hʋ noŋ tɩyaŋ aŋ baa, “Talita kumi.” Ʋ memii rɛ yaa “Haŋtolibiye, ŋ baa ɩ sii.” ");
INSERT INTO sig_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Biye hʋ nyagɩ sii a kɩ vala, nala hʋ buloŋ nyʋʋsɩ fɩyɛlɩ. Biye hʋ fa yaa bɩsɩ fi abee balɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ɛɛ rɛ Yesu basɩ tɩya ba abee sɩfɩyasɩ, dɩ ba ta leŋ dɩ nal buloŋ nɩɩ wɩɩ no, aŋ basɩ tɩya ba dɩ ba kyɛ kɩdiiliye tɩya biye hʋ dɩ ʋ di. ");
INSERT INTO sig_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ lɩɩ haŋ paalʋʋ hʋ tɩyaŋ a kpa mʋ ʋ bee tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kyɛwiyesii hʋ kyɛɛ, ʋ sii mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya a kɩ daga nala. Ba aa nɩɩ ʋ wɩbasɩɩ hʋ, ba gyeniŋ buloŋ hirige rɛ, a baa “Ɛɛ rɛ ʋ yaa a gyɩŋ wɩya no? Aŋnɛ rɛ tɩya ʋ wɩgyʋŋ no? ");
INSERT INTO sig_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɛɛ rɛ ʋ yaa a wuwo kɩ yaa wɩmagɩla no? Á gyɩma ʋ rɛ! Kapiŋta hʋ daa gɛɛ? Mɛɛrɩ biibaal daa gɛɛ. Gyemsi abee Gyoose abee Gyuda abee Siimɔŋ daa yaa ʋ naabalɩya? Ʋ naatoliye we daha.” Ɛɛ rɛ ba sii bee su ʋ. ");
INSERT INTO sig_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩɩsɩ tɩŋdaal kɛ buloŋ, ʋ aa kaŋ yohuŋ nɛ lee buloŋ tɩyaŋ, amɛ ʋ bee nala abee ʋ dɩya nala tɩɩ kɛ sɩɩ aa bee su ʋ.” ");
INSERT INTO sig_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Akuu ba aa bɩ laa ʋ di wɩya, ʋ bɩ wuwo yaa wɩduwoni buloŋ doŋ tɩyaŋ. Ʋ yaŋ ta kpa ʋ nosi a dɔbɔ wɩɩla tɩmma baŋmana tɩyaŋ nɛ ba deye. ");
INSERT INTO sig_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu nyʋwa gyɩ fɩyɛla rɛ abee ʋ tɩɩ bee nala aa bɩ laa ʋ di. ");
INSERT INTO sig_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɛɛ rɛ ʋ sii mʋ gɔllɩ tɔnɩ hʋ buloŋ aa kpaga doŋ a kɩ daga nala. Ʋ yɩrɩ ʋ hatɩnna fi abee balɩya hʋ a laŋŋɩ, a tɩŋ ba balɩya balɩya a tɩya ba dee gyɩŋbɔmɔ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “A lɩɩ ma daatɩgɩya hal, ma ta bɩl kpaa kɩŋ buloŋ pɛ a vala ŋmanɩɩ hʋ. Ma ta kaŋ kɩdiiliye mʋ, a ta kpaa diiku mɛ kolo, a ta kpaa molbii mɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Amɛ ma paa ma naatɔbɔ we, aŋ ta bɩl kpaa gal pɛ kɩna hʋ ma aa laala tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dɩ mamaa rɛ ko mʋ gyʋʋ tɔɔ buloŋ, ma gyʋʋ dɩya hʋ nala aa kyo ma wɩya, a we dɩɩdɩgɩ tɩyaŋ gɛɛɛ dɩ saŋa hʋ ma aa sɩ lɩɩ tɔɔ hʋ tɩyaŋ mʋ pele. ");
INSERT INTO sig_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dɩ ma ko mʋ tɔɔ buloŋ dɩ ba pɔ dɩ ma ta gyʋwa, a bɩ sɩ gyegili nɩɩ wɩya hʋ mɛ ma aa basɩ, ma gallɩ mʋ. Dɩ ma ko lɩɩ bee hʋ tɩyaŋ, ma piisi ma naasɩ taŋha ta. Ɛɛ rɛ sɩ leŋ dɩ ba gyɩma anɩɩ ba aa vɩya ma nyɛ Wɩɩsɩ sɩ dɔgɩsɩ ba.” ");
INSERT INTO sig_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ʋ aa tɩya ba ʋ nyʋʋdaasɩ ko mʋ teŋ, ba lɩɩ mʋ a basɩ kɩ tɩya nala dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba gyɩ kile gyɩŋbɔmɔ yʋga rɛ nala tɩyaŋ, ba lɩɩ. Ba kpaa nʋʋ mɛ a tɩsɩ wɩɩla tɩmma ba na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ɛɛ rɛ Yesu feŋ taalɩ lee hʋ buloŋ, Kuwori Hɛrɔtɩ mɛ nɩɩ ʋ wɩya. Nala badɔmɔŋ kɩ basɩ a baa, “Ʋ rɛ yaa Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ. Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ, ɛɛ rɛ tɩŋ ʋ kaŋ dee a kɩ yaa wɩmagɩla no buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka badɔmɔŋ mɛ baa dɩ Ilaagya rɛ, nal hʋ fa aa yaa Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ. Badɔmɔŋ mɛ baa dɩ ʋ yaŋ ta yaa Wɩɩsɩ tɩŋdaal lɛ anɩɩ faafaa nala hʋ kɩdɩgɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kuwori Hɛrɔtɩ aa nɩɩ ʋ wɩya, ʋ baa, “Gyɔɔŋ nɛ gɛɛ. Ʋ rɛ yaa nal hʋ ŋ gyɩ aa leŋ ba keri ʋ nyuu hʋ. Ʋ rɛ sii sʋʋ tɩyaŋ gɛɛ.” Wɩɩ hʋ aa tɩŋ Hɛrɔtɩ gyɩ leŋ ba keri Gyɔɔŋ nyuu rɛ nyɛ: ");
INSERT INTO sig_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hɛrɔtɩ tɩɩtɩɩ gyɩ leŋ ba kaŋ Gyɔɔŋ tɔ dɩyaŋ nɛ ʋ haaŋ Hɛrodiya wɩya. Beewɩya Hɛrodiya gyɩ yaa ʋ maana Fɩlɩpɩ haaŋ nɛ, ʋ kaŋ fasɩ. ");
INSERT INTO sig_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ɛɛ rɛ Gyɔɔŋ basɩ tɩya Hɛrɔtɩ a baa, “Ʋ bɩ yaa ŋmanɩɩ dɩ ɩ kaŋ ɩ maana haaŋ fasɩ.” ");
INSERT INTO sig_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ɛɛ rɛ tɩŋ Hɛrodiya laa wɩɩ hʋ we ʋ tɩya tɩyaŋ a kɩ kyɛ dɩ ba kpʋ Gyɔɔŋ. Amɛ ʋ gyɩ bɩ naa ŋmanɩɩ dɩ ʋ kpʋ ʋ, beewɩya Hɛrɔtɩ gyɩ aa pɔ Gyɔɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɛrɔtɩ gyɩ aa tɩya Gyɔɔŋ gyɩrɩma rɛ, beewɩya ʋ naa dɩ ʋ yaa tɩpʋlʋŋ tɩɩna rɛ a kɩ yaa wɩya hʋ aa kpaa ŋmanɩɩ. Gyɔɔŋ wɩbasɩɩ buloŋ gyɩ aa kperi Hɛrɔtɩ rɛ, ka abee gɛɛ buloŋ, ʋ ha kyo dɩ ʋ gyegili nɩɩ wɩya hʋ ʋ aa basɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amɛ kyɛɛ kɩdɩgɩ Hɛrodiya ha vɩya aŋ na ʋ ŋmanɩɩ rɛ. Kuwori Hɛrɔtɩ kyɛlʋlɩɩ kyɛɛ rɛ gyɩ ko baŋ pele. Ɛɛ rɛ ʋ sii yaa kɩdiiliye yʋga, a yɩrɩ ʋ kuworibiisi abee ʋ laalyuwolo nɩhɩyasɩ, abee Galili nɩhɩyasɩ, ba buloŋ ko laŋŋɩ a hɔŋ kɩ di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba hɔnɩɩ hʋ tɩyaŋ nɛ Hɛrodiya toluu ko gyʋʋ gʋwa. Hɛrɔtɩ bee nala hʋ buloŋ kɩ deŋ ʋ, ba tenni fɩyɛlɩ ʋ nyuu tɩyaŋ. Ɛɛ rɛ Hɛrɔtɩ basɩ tɩya haŋtolibiye hʋ dɩ ʋ kɛ daga kɩŋ hʋ buloŋ ʋ aa kyɛ, dɩ ʋ sɩ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ʋ paalɩ ŋmɩyɛsɩ rɛ a baa, “Ɩ aa kyɛ kɩŋ hʋ buloŋ ŋ sɩ tɩya ɩ. Dɩ ɩ rɛ aa kyɛ ŋ taŋha logiŋ kɩdɩgɩ, haalɩ a pele faŋ mɛ, ŋ sɩ kpa tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Haŋtolibiye hʋ sii lɩɩ, a mʋ pɩyɛsɩ ʋ naa a baa, “Ŋ basɩ baa bekiŋ nɛ ŋ kɩ kyɛ?” Ɛɛ rɛ Hɛrodiya baa, “Basɩ tɩya ʋ dɩ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ nyuu rɛ ɩ kɩ kyɛ.” ");
INSERT INTO sig_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Haŋtolibiye hʋ mɩɩgɩ lagɩlagɩ a mʋ kuwori hʋ lee a basɩ tɩya ʋ a baa, “Ŋ aa kyɛ dɩ ɩ keri Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ nyuu rɛ, a we parɩtɩ tɩyaŋ, a kaŋ ko tɩya ŋ.” ");
INSERT INTO sig_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuwori hʋ aa nɩɩ wɩɩ no, ʋ tɩya buloŋ kyogi. Amɛ ʋ aa ŋmɩyɛsa nala hʋ buloŋ sɩɩ tɩyaŋ gɛɛ, ʋ bɩl bɩ sɩ wuwo lugisi ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɛɛ rɛ ʋ yɩrɩ laalyuwol kɩdɩgɩ, a tɩma ʋ dɩ ʋ mʋ keri Gyɔɔŋ nyuu kaŋ ko. ");
INSERT INTO sig_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Laalyuwol hʋ sii a mʋ lee hʋ ba aa kaŋ Gyɔɔŋ mʋ tɔ hʋ, a keri ʋ nyuu a we parɩtɩ tɩyaŋ, a kaŋ ko tɩya haŋtolibiye hʋ. Ʋ laa a kaŋ mʋ tɩya ʋ naa. ");
INSERT INTO sig_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gyɔɔŋ hatɩnna hʋ aa nɩɩ wɩɩ no, ba sii ko a laa ʋ teŋbii a kaŋ mʋ hogo. ");
INSERT INTO sig_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu hatɩnna hʋ ʋ fa aa tɩma hʋ, ba mɩɩgɩ ko ʋ lee, a basɩ wɩya hʋ buloŋ ba aa yaa abee wɩya hʋ buloŋ ba aa daga, a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nala hʋ badɔmɔŋ gyɩ aa yaŋ kɩ lɩɩ rɛ ka badɔmɔŋ mɛ ko kɩ gyʋʋ. Yesu abee ʋ hatɩnna paalɩ bɩ naa sɩnɩɩ dɩ ba di kɩna mɛ gba. Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ma leŋ dɩ á mʋ lee hʋ nala aa tuwo dɩ ma wiyesi mʋhʋ.” ");
INSERT INTO sig_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɛɛ rɛ ba sii a gyʋʋ nɩɩduworiboro a kɩ mʋ lee hʋ nala aa tuwo. ");
INSERT INTO sig_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amɛ nala yʋga gyɩ naa ba a wuwo gyɩma anɩɩ ba aa rɛ. Ɛɛ rɛ ba lɩɩ tɔgyamaa a fa mʋ lee hʋ Yesu fa aa mʋʋ, a laa ʋ bee ʋ hatɩnna hʋ sɩya a pele doŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ba mɛ mʋ ko, a lɩɩ nɩɩduworiboro hʋ tɩyaŋ. Yesu aa ko lɩɩ nɩɩduworiboro hʋ tɩyaŋ, dɩ ʋ naa nɩgyamaa dɩ ba hɔŋ kɩ gyegili ʋ. Ba sikii buloŋ kana ʋ, beewɩya ba gyɩ kɩɩ gɛɛ rɛ anɩɩ piyese aa bɩ kaŋ pedaal. Ʋ sii piili kɩ daga ba wɩya yʋga. ");
INSERT INTO sig_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ʋ dɩdaana aa ko pele, ʋ hatɩnna hʋ ko basɩ tɩya ʋ a baa, “Lee no yaa ɔhɔ rɛ, ka wɩɩsɩ fɩyɛlɩ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ta nala hʋ dɩ ba mʋ tɔnɩ hʋ abee bagɩsɩ aa kpaga daha, a mʋ yɔbɔ kɩdiiliye a di.” ");
INSERT INTO sig_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu mɩɩgɩ basɩ tɩya a baa, “Ma mʋ kyɛ kɩdiiliye tɩya ba dɩ ba di.” Ba pɩyɛsɩ ʋ a baa, “Gbo! Dɩ ámaa sɩ kpa molbii yɔbɔ kɩdiiliye tɩya nala no dɩ ba wuwo di vɔgɔ, ʋ sɩ te nɩdɩgɩ bɩŋpiliŋ tuno.” ");
INSERT INTO sig_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nyɛ rɛ Yesu pɩyɛsɩ ba a baa, “Paanʋʋ baŋmɛ rɛ we doŋ? Ma mʋ na.” Ba mʋ, aŋ mɩɩgɩ ko basɩ tɩya ʋ abaa, “Kɩna bɔnɔŋ nɛ abee fuwonamɩɩsɩ balɩya.” ");
INSERT INTO sig_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ dɩ ba leŋ nala hʋ buloŋ tuu hɔŋ kyige gulo gulo ɔfɩyɛl hʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nyɛ rɛ badɔmɔŋ hɔŋ nala kɔɔ, kɔɔ, badɔmɔŋ mɛ mɔllɩbalɩya bee fi fi. ");
INSERT INTO sig_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ɛɛ rɛ ʋ kpa paanʋʋ hʋ bɔnɔŋ abee fuwonamɩɩsɩ hʋ balɩya, a wil deŋ wɩɩsɩnyuu, aŋ kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kaŋ paanʋʋ hʋ lɔgɔ a tɩya ʋ hatɩnna hʋ dɩ ba laa mʋ kpaa nala hʋ. Ʋ bɩl kaŋ fuwonamɩɩsɩ hʋ balɩya mɛ a kpaa ba. ");
INSERT INTO sig_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba buloŋ di a vɔgɔ. ");
INSERT INTO sig_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka ba mʋ paa paanʋʋ hʋ abee fuwonamɩɩsɩ hʋ kɩkaalɩya, a su simbiisi fi abee balɩya. ");
INSERT INTO sig_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nala hʋ gyɩ aa dii kɩdiiliye hʋ, ba tɩyaŋ baala dʋŋ gyɩ yaa tusi bʋnɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɛɛ rɛ ʋ leŋ ʋ hatɩnna hʋ mʋ gyʋʋ nɩɩduworiboro, a laa ʋ sɩya duwori kyol fuwo hʋ kyolo, a kɩ mʋ Bɛsaada. Ka ʋ ta nɩgyamaa hʋ buloŋ ba mʋ. ");
INSERT INTO sig_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ʋ aa taa nala hʋ ba mʋ teŋ, ʋ sii mʋ gyɩŋ dogimo kɩdɩgɩ nyuu dɩ ʋ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ʋ dɩdaana ko kɩ pele dɩ nɩɩduworiboro hʋ we nɩɩ hʋ tʋtʋʋ bee tʋtʋʋ, aŋka Yesu dʋŋ ha we dogimo tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɛɛ rɛ Yesu deŋ na dɩ puwo kaŋ ʋ hatɩnna hʋ kɩ lʋga, a pɔ dɩ nɩɩduworiboro hʋ ta mʋwa. Ʋ sɩgballɩnyʋwa, ʋ sii a vala nɩɩ hʋ nyuu a kɩ mʋ, a ko kpaga ba, a kɩ kyɛ dɩ ʋ parɩ ba baŋ. ");
INSERT INTO sig_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba aa na ʋ dɩ ʋ aa vala nɩɩ hʋ nyuu, ba bɩɩna anɩɩ nɩdɩma rɛ. Kambɩŋ kaŋ ba, ba yaga kyiyesuu. ");
INSERT INTO sig_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɛɛ rɛ ʋ piliŋsi basɩ tɩya ba a baa, “Ma kaŋ ma tɩɩ. Mɩyaŋ nɛ. Ma ta leŋ dɩ kambɩŋ kaŋ ma.” ");
INSERT INTO sig_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ka ʋ yaŋ mʋ gyʋʋ nɩɩduworiboro hʋ. Ʋ aa gyʋʋ ko teŋ, puwo hʋ sige. Ʋ yaa ʋ hatɩnna hʋ wɩkperii. ");
INSERT INTO sig_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ba gyɩ naa dɩ Yesu kaŋ paanʋʋ gama bɔnɔŋ a kpaa nala tusi bʋnɔŋ nɛ, ka ba ha gyɩ bɩ gyɩŋ wɩɩ hʋ memii, beewɩya ba ha bɩ gyɩŋ nal hʋ Yesu aa yaa. ");
INSERT INTO sig_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɛɛ rɛ ba kyol fuwo hʋ kyolo, a ko pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Gyɛnɛsarɛtɩ, a lɩɩ nɩɩduworiboro hʋ tɩyaŋ aŋ kaŋ vʋwa nɩɩ hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba aa lɩɩ ko teŋ, dɩ nala gyɩma anɩɩ Yesu rɛ. ");
INSERT INTO sig_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba fá mʋ gbɛ ba paalʋʋ buloŋ, a paa wɩɩlɩ tɩmma abee ba wasɩnɩ, a kaŋ mʋ lee kɛ buloŋ ba aa nɩya dɩ Yesu we. ");
INSERT INTO sig_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lee kɛ buloŋ Yesu a mʋwa, tɔbala koo tɔbiisi koo bagɩsɩ, nala aa paa ba wɩɩla tɩmma rɛ a kaŋ lɩɩ biŋ lɩgyalɩya tɩyaŋ, a sʋla ʋ dɩ ʋ leŋ dɩ ba dige ʋ gal nyʋwa mɛ gba. Ba nala hʋ buloŋ gyɩ aa wuwo dige ʋ, ba gyɩ naa laaŋfɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɛɛ rɛ kyɛɛ kɩdɩgɩ, Farasiima abee Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ sii lɩɩ Gyerusalɛm ko, ba buloŋ sii ko Yesu lee. ");
INSERT INTO sig_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba aa ko ba naa dɩ Yesu hatɩnna hʋ badɔmɔŋ bɩ sɔŋ nɩɩ aŋ kɩ di kɩna. Nyɛ yaa bisiŋ nɛ ba lesiri tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasiima abee Gyuuma buloŋ bɩ sɩ laa nyʋwa di kɩŋ buloŋ dɩ ba bɩ sɔŋ nɩɩ anɩɩ ba naabaala lesiri aa daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dɩ ba aa rɛ ko lɩɩ yɔbɔ ko mɛ, ba aa sɔŋ nɩɩ rɛ aŋ na di kɩna. Ba sɩŋsɩ yʋga. Ba kaŋ ŋmanɩɩ kɩdɩgɩ mɛ rɛ ba aa kɩ vaalɩ ba nɩɩnyʋwagbaŋbiisi abee ba kɩdigbaŋsɩ abee ba hɔgɩ viini buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ɛɛ rɛ ba ko pɩyɛsɩ Yesu a baa, “Bee rɛ tɩŋ ɩ hatɩnna hʋ kɩ kyogi a naabaala sɩŋsɩ nyɛ? Bee rɛ tɩŋ ba aa bɩ sɔŋ nɩɩ aŋ kɩ di kɩna?” ");
INSERT INTO sig_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ɛɛ rɛ ʋ mɩɩgɩ basɩ tɩya ba a baa, “Minaafigi tɩmma! Ma wɩya hʋ buloŋ Wɩɩsɩ tɩŋdaal Azaaya gyɩ aa basa faafaa buloŋ, ba yaa wɩtɩɩ rɛ. Ba saba Wɩɩsɩ teŋ tɩyaŋ anɩɩ ʋ baa dɩ Wɩɩsɩ baa, ‘Nyʋwa dʋŋ nɛ nala no kaŋ kɩ tɩya ŋ gyɩrɩma, amɛ ŋ wɩya tuwo ba tɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba aa kɩ kyʋwalɩ ŋ waasʋ rɛ, a kɩ daga nihuwobisi ŋmaŋsɩ aŋ baa dɩ Wɩɩsɩ rɛ basa.’ ");
INSERT INTO sig_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nihuwobisi ŋmaŋsɩ rɛ ma kɩ tɩŋa aŋ vɩya Wɩɩsɩ nyʋwa tɩŋɩɩ” ");
INSERT INTO sig_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu bɩl baa, “Ma kaŋ wɩgyʋŋ kɩdɩgɩ rɛ aa wuwo vɩya Wɩɩsɩ ŋmanɩɩ aŋ kɩ tɩŋ ma naabaala ŋmaŋsɩ. Ma aa yaa gɛɛ, ma tol sʋma rɛ? ");
INSERT INTO sig_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moosi fa saba rɛ a basɩ anɩɩ Wɩɩsɩ baa dɩ ɩ kɩ fá ɩ kuwo abee ɩ naa, a bɩl sabɩ a baa dɩ dɩ nal lɛ tʋʋsɩ ʋ kuwo abee ʋ naa, dɩ ba kpʋ ʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amɛ ma kɛ basɩ anɩɩ dɩ nal lɛ kaŋ kɩŋ, a maga dɩ ʋ kpa kyiyeli ʋ kuwo koo ʋ naa, ka dɩ tɩɩna basɩ tɩya ba abaa, “Kɩŋ hʋ ŋ fa aa sɩ kpa kyiyeli ma hʋ, ʋ yaa ‘Kɔribaŋ’ nɛ.” (Ʋ memii rɛ yaa, kɩŋ hʋ bɩrɩmɩ Wɩɩsɩ tol lɛ.) Ʋ bɩl bɩ maga dɩ ʋ kpa tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A kuu nyɛ wɩya, ma bɩ daga dɩ ʋ yaa wɩɩ buloŋ a kyiyeli ʋ kuwo abee ʋ naa. ");
INSERT INTO sig_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nyɛ rɛ ma yaa a vɩya Wɩɩsɩ nyʋwa tɩŋɩɩ aŋ kɩ tɩŋ ma naabaala ŋmaŋsɩ, a bɩl sii kpa daga ma biisi mɛ. Wɩtesi no yʋga rɛ ma kɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɛɛ rɛ Yesu bɩl yɩrɩ nala hʋ ba ko laŋŋɩ. Ba aa ko, ʋ basɩ tɩya ba a baa, “Ma buloŋ gyegili nɩɩ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nal kɩdiiliye bɩ sɩ wuwo leŋ dɩ ʋ yaa bisiŋ tɩɩna. Kɩŋ kɛ buloŋ aa tuu nal fuu ʋ bɩ kaŋ bisiŋ. Amɛ wɩya hʋ aa lɩɩ ʋ tɩya tɩyaŋ ko kɩ lɩɩ, ba aa rɛ sɩ wuwo leŋ dɩ ʋ yaa bisiŋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ʋ aa basɩ gɛɛ teŋ, ʋ leŋ nala hʋ aŋ mʋ gyʋʋ dɩya. Ɛɛ rɛ ʋ hatɩnna hʋ ko pɩyɛsɩ ʋ namaga hʋ memii. ");
INSERT INTO sig_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nyɛ rɛ ʋ pɩyɛsɩ ba a baa, “Ma ha bɩ kaŋ wɩgyʋŋ? Ma bɩ gyɩma anɩɩ dɩ nal lɛ di kɩŋ, ʋ bɩ sɩ wuwo leŋ dɩ ʋ kaŋ bisiŋ? ");
INSERT INTO sig_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dɩ ɩ rɛ dii kɩŋ, ʋ bee gyʋʋ ɩ tɩya. Ɩ fuu rɛ ʋ aa tuu, ɩ nyɛ ta.” Yesu aa basɩ nyɛ, ʋ daga anɩɩ kɩdiiliye sɩŋsɩ bɩl tuwo rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɛɛ rɛ ʋ bɩl baa, “Wɩya hʋ aa lɩɩ nal tɩya tɩyaŋ nɛ aa leŋ nal kaŋ bisiŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ɩ tɩya tɩyaŋ nɛ ɩ aa bɩɩnɩ wɩbɔmɔ yayɩ anɩɩ sɔŋsɔŋ, gaal, nala kpʋyɩ, nala haana kyɛyɩ, tɩbal, a kɩ yaa wɩbɔŋ kɛ buloŋ, a kɩ mʋrɩ nala, a kɩ yaa wɩya hʋ buloŋ aa bɩ maga dɩ ɩ yaa. ");
INSERT INTO sig_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ɩ tɩya kɩ hɔllɩ nala. Ɩ kɩ kyogi nala fene, a kɩ daga ɩ tɩɩ, a kɩ yaa bambugi wɩya. ");
INSERT INTO sig_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wɩbɔmɔ no buloŋ yaa bisiŋ wɩya rɛ, ka nihuwobiŋ tɩya tɩyaŋ nɛ ba buloŋ aa lɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ɛɛ rɛ Yesu sii lɩɩ doŋ, a mʋ Taaya paalʋʋ, a mʋ gyʋʋ faŋa dɩya kɩdɩgɩ tɩyaŋ, a bee kyɛ dɩ nal buloŋ gyɩma ʋ wɩya, ka ba vɩya aŋ gyɩma. ");
INSERT INTO sig_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Haaŋ kɩdɩgɩ rɛ gyɩ we doŋ a lɩɩ Fɔniisɩya aa we Siiriya paalʋʋ tɩyaŋ, a yaa Giriki tɩɩna. Gyɩŋbɔŋ gyɩ kaŋ ʋ toluu. ");
INSERT INTO sig_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɛɛ rɛ ʋ nɩɩ Yesu wɩya, a sii ko tuu tele ʋ naasɩ tɩyaŋ, a sʋla ʋ dɩ ʋ kile gyɩŋbɔŋ hʋ ta ʋ biye hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu pɩyɛsɩ ʋ a baa, “Dɩ ɩ rɛ kaŋ biisi, ɩ sɩ laa nyʋwa kpa ba kɩdiiliye tɩya vasɩ? Aayɩ, ɩ aa laa sɩya yaa kɩdiiliye hʋ tɩya ɩ biisi hʋ rɛ, dɩ ba aa rɛ yaŋ ko dɩ aŋ ka, ɩ kpa tɩya vasɩ.” ");
INSERT INTO sig_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nyɛ rɛ haaŋ hʋ baa, “Wɩtɩɩ rɛ, ŋ Tɩɩna, ɩ bɩ sɩ kpa ɩ biisi kɩdiiliye kɛ tɩya vasɩ. Amɛ biisi hʋ aa dii ka kɩna hʋ kɩ tele taŋha, ba aa rɛ vasɩ hʋ mɛ sɩ paa di.” ");
INSERT INTO sig_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ɛɛ rɛ Yesu basɩ tɩya haaŋ hʋ a baa, “Ɩ aa basɩ wɩɩ no wɩya, gyɩŋbɔŋ hʋ lɩya rɛ ɩ toluu hʋ tɩyaŋ. Kɩ mʋ dɩya.” ");
INSERT INTO sig_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nyɛ rɛ haaŋ hʋ kpa mʋ. Ʋ mʋwa dɩ ʋ biye hʋ pɩna, gyɩŋbɔŋ hʋ kɔnɩ lɩɩ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ɛɛ rɛ Yesu mɩɩgɩ lɩɩ Taaya paalʋʋ tɩyaŋ a mʋ tɩŋ Siidɔŋ abee tɔnɩ fi badɔmɔŋ paalʋʋ, a mʋ pele Galili fuwobal hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɛɛ rɛ dɩ ganɩɩ kɩdɩgɩ we doŋ. Ba kana ʋ ko, a sʋla Yesu dɩ ʋ kpa ʋ nosi dɔbɔ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kana ʋ kaŋ lɩɩ nala hʋ tɩyaŋ. Ba dʋŋ balɩya hɔŋ. Ɛɛ rɛ ʋ kpa ʋ noniye a tʋʋ baal hʋ dɩgɩna tɩyaŋ aŋ tʋ naŋtʋwɔl dige ʋ naŋdeliŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aŋ wil deŋ wɩɩsɩnyuu aŋ wiyesi yʋga fʋ̃ʋ̃, aŋ basɩ tɩya baal hʋ baa, “Ɛfata.” Ɛfata memii rɛ yaa kaŋ suri. ");
INSERT INTO sig_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɛɛ rɛ baal hʋ dɩgɩna suri. Ʋ naŋdeliŋ mɛ bɩrɩmɩ, ʋ kɩ basɩ wɩya weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ɛɛ rɛ Yesu basɩ tɩya nala hʋ abee sɩfɩyasɩ dɩ ba ta basɩ wɩɩ no tɩya nal buloŋ. Abee gɛɛ buloŋ, ka ba ha vɩya aŋ kpa wɩɩ hʋ wuwoli lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nala hʋ buloŋ a nɩɩ wɩɩ no, ba hirigi kɩŋkaŋ a baa, “Wɩɩ kɛ buloŋ nɛ ʋ wuwo kɩ yaa weliŋ. Ʋ paalɩ leŋ wonni kɩ nɩɩ wɩya rɛ, a leŋ ganɩya mɛ wuwo kɩ basɩ wɩya.” ");
INSERT INTO sig_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saŋa kɩdɩgɩ nɩgyamaa bɩl ko laŋŋɩ ʋ lee tɩyaŋ nɛ. Ʋ kyɛtoo kyɛɛ dɩ ba bɩl bɩ kaŋ kɩdiiliye dɩ ba di. Ɛɛ rɛ Yesu yɩrɩ ʋ hatɩnna hʋ a basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ŋ aa naa nala hʋ sikii kana ŋ nɛ. Ba aa we ŋ lee ʋ kyɛyɛ boto rɛ nyɛ, dɩ ba bɩ dii kɩŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dɩ ba aa rɛ bɩ dii kɩŋ buloŋ, ka dɩ ŋ baa dɩ ba mɩɩgɩ, ba sɩ mʋ yiyegi ŋmanɩɩ tɩyaŋ, beewɩya ba badɔmɔŋ lɩɩ liboliye rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɛɛ rɛ ʋ hatɩnna hʋ pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ɩ sɩ yaa a na kɩdiiliye dɩ nala no buloŋ di vɔgɔ ɔhɔ no tɩyaŋ?” ");
INSERT INTO sig_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ʋ pɩyɛsɩ ba abaa, “Paanʋʋ baŋmɛ rɛ we doŋ?” Ba baa, “Kɩna bapɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɛɛ rɛ ʋ leŋ nala hʋ tuu hɔŋ taŋha, ka ʋ mʋ paa paanʋʋ hʋ bapɛ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kaŋ lɔgɔ lɔgɔ a tɩya ʋ hatɩnna hʋ dɩ ba laa kpaa nala hʋ. Ba laa kpaa ba. ");
INSERT INTO sig_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dɩ ba kaŋ fuwonamɩɩsɩ mɛ baŋmana. Ʋ kpa ba mɛ a kyʋwalɩ Wɩɩsɩ, aŋ leŋ ʋ hatɩnna hʋ laa kpaa nala hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nal buloŋ di a vɔgɔ, ka ba paa kɩkaalɩya hʋ a su simbiisi bapɛ. ");
INSERT INTO sig_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nala hʋ fa aa dii kɩna hʋ pele nala tusi bʋnaa. ");
INSERT INTO sig_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɛɛ rɛ ʋ ta ba, aŋ kaŋ ʋ hatɩnna hʋ ba mʋ gyʋʋ nɩɩduworiboro hʋ a mʋ Dalmanuta paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɛɛ rɛ Farasiima badɔmɔŋ sii ko Yesu lee, a kɩ pɩyɛsɩ ʋ wɩya. Ba gyɩ aa kyɛ dɩ ba magɩsɩ ʋ na wɩya, ba baa dɩ ʋ yaa wɩmagɩl dɩ ba na a gyɩma anɩɩ ʋ dee hʋ lɩɩ Wɩɩsɩ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu tɩya buloŋ kyogi. Ʋ kyigi ʋ wiyesi aŋ pɩyɛsɩ ba a baa, “Ma lagɩlagɩ no nala, bee rɛ tɩŋ ma aa kɩ kyɛ dɩ ŋ yaa wɩmagɩl dɩ ma na? Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ŋ bɩ sɩ yaa wɩmagɩl buloŋ dɩ ma na anɩɩ ŋ dee hʋ lɩɩ Wɩɩsɩ lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɛɛ rɛ ʋ leŋ ba aŋ mɩɩgɩ mʋ gyʋʋ nɩɩduworiboro, a duwori kyol fuwo hʋ kyolo. ");
INSERT INTO sig_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu bee ʋ hatɩnna hʋ aa duwori kyol fuwo hʋ kyolo tɩyaŋ nɛ, ʋ hatɩnna hʋ liisi anɩɩ ba yeŋŋi ba kɩdiiliye ta rɛ, aŋ kpa paanʋʋ dɩgɩ dʋŋ we nɩɩduworiboro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ɛɛ rɛ Yesu basɩ abee sɩfɩyasɩ a baa, “Ma pɔ ma tɩɩ abee Farasiima abee Hɛrɔtɩ wɩya. Ba wɩyaalɩya kɩɩ gɛɛ rɛ anɩɩ sɩbʋl. Dɩ ɩ rɛ kpaa ʋ we kɩŋ buloŋ tɩyaŋ, ʋ aa sii pʋʋsɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ʋ aa basɩ gɛɛ rɛ, ba hɔŋ kɩ vʋʋlɩ a baa, “Á bɩ kaŋ paanʋʋ, ɛɛ rɛ tɩŋ ʋ basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu wuwo gyɩŋ wɩɩ hʋ ba aa vʋʋlɩ, a pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma hɔŋ kɩ vʋʋlɩ baa ma bɩ kaŋ paanʋʋ? Ma sɩya ha bɩ suro? Bee rɛ tɩŋ ma nyuni sʋba gɛɛ? ");
INSERT INTO sig_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma kaŋ sɩya rɛ, ma bee na? Ma kaŋ dɩgɩna rɛ, ma bee nɩɩ wɩya? Ma bɩ liisi wɩɩ hʋ? ");
INSERT INTO sig_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ŋ kpaa paanʋʋ bɔnɔŋ nɛ a lɔgɔ kpaa baala tusi bɔnɔŋ. Ma aa paa kɩkaalɩya hʋ, simbiisi baŋmɛ rɛ ma paa su?” Ba baa, “Simbiisi fi abee balɩya.” ");
INSERT INTO sig_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ʋ bɩl pɩyɛsɩ ba, “Ŋ bɩl aa kpaa paanʋʋ bapɛ a lɔgɔ kpaa nala tusi banaa, ma aa paa kɩkaalɩya hʋ, simbiisi baŋmɛ rɛ ma paa su?” Ba baa “Simbiisi bapɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Ma ha bɩ wuwo kɩ gyɩŋ wɩya memii?” ");
INSERT INTO sig_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu bee ʋ hatɩnna hʋ bɩl ko pele Bɛsaada. Ɛɛ rɛ nala badɔmɔŋ kaŋ nyʋlʋŋ kɩdɩgɩ, a ko sʋla Yesu dɩ ʋ kpa ʋ nosi a dige ʋ. ");
INSERT INTO sig_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kaŋ nyʋlʋŋ hʋ noŋ tɩyaŋ a kana ʋ lɩɩ tɔɔ hʋ tɩyaŋ a tʋ naŋtʋwɔl we ʋ sɩya tɩyaŋ, aŋ kpa ʋ noŋ dige bal hʋ sɩya aŋ pɩyɛsɩ ʋ dɩ ʋ aa na lee rɛ? ");
INSERT INTO sig_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Baal hʋ deŋ lee aŋ baa, “Ŋ aa na nala rɛ, amɛ ba kɩɩ gɛɛ rɛ anɩɩ tɩɩsɩ rɛ aa gɔllɩ.” ");
INSERT INTO sig_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɛɛ rɛ Yesu bɩl kpa ʋ nosi dige bal hʋ sɩya. Baal hʋ marɩ kyirigi sɩya weliŋ. Ʋ sɩya bɩl kɩ na, ʋ na kɩŋ kɩŋ buloŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɛɛ rɛ Yesu basɩ tɩya ʋ dɩ ʋ ta bɩl gyʋʋ tɔɔ hʋ tɩyaŋ, dɩ ʋ kɩ mʋ ʋ bee. ");
INSERT INTO sig_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu bee ʋ hatɩnna hʋ bɩl sii doŋ a kɩ mʋ Sizaariya Filipi paalʋʋ. Ba aa mʋʋ hʋ tɩyaŋ nɛ, Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Aŋnɛ rɛ nala baa dɩ ŋ yaa?” ");
INSERT INTO sig_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba baa, “Badɔmɔŋ baa dɩ ɩ rɛ yaa Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ. Badɔmɔŋ mɛ baa dɩ ɩ rɛ yaa Ilaagya, Wɩɩsɩ tɩŋdaal hʋ. Badɔmɔŋ mɛ baa dɩ ɩ yaŋ ta yaa Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ʋ hatɩnna hʋ mɛ a baa, “Ka ma mɛ, ma baa ŋ yaa aŋnɛ rɛ?” Piita baa “Ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ a lɩya.” ");
INSERT INTO sig_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Piita a basɩ gɛɛ rɛ, Yesu basɩ tɩya ba abee sɩfɩyasɩ dɩ ba pɔ dɩ ba ta ko basɩ wɩɩ no tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɛɛ rɛ Yesu piili kɩ daga ʋ hatɩnna hʋ a baa, “Mɩyaŋ Nihuwobiŋ biye, ŋ sɩ na tʋwara kɩŋkaŋ. Bee nɩhɩyasɩ abee wɩɩkyʋwal sɩlaala nɩhɩyasɩ, abee Wɩɩsɩ Teŋ dɩdagɩla, ba buloŋ sɩ vɩya ŋ aŋ leŋ dɩ ba kpʋ ŋ. Dɩ ba aa rɛ ko kpʋ ŋ, ŋ sɩ yaa kyɛyɛ boto aŋ mɩɩgɩ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ʋ kyaasɩ basɩ wɩɩ no rɛ tɩya ba. Ɛɛ rɛ Piita kana ʋ gɩɩgɩ lɩɩ, a nɔsɩ ʋ, aŋ basɩ tɩya ʋ anɩɩ ʋ ta basɩ gɛɛ, dɩ ʋ bɩ basɩ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ɛɛ rɛ Yesu bɩrɩmɩ kyaasɩ ʋ hatɩnna hʋ lee aŋ nɔsɩ Piita a baa, “Sɩtaanɩ, fasɩ lɩɩ ŋ sɩya tɩyaŋ. Wɩya hʋ ɩ aa basa, nihuwobiŋ tɩbɩɩna rɛ, Wɩɩsɩ tɩbɩɩna daa.” ");
INSERT INTO sig_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nyɛ rɛ Yesu yɩrɩ ʋ hatɩnna hʋ abee nala hʋ buloŋ ba ko, ʋ basɩ tɩya ba a baa, “Dɩ nal buloŋ nɛ aa kyɛ dɩ ʋ tɩŋa ŋ, see dɩ ʋ vɩya ʋ tɩɩ ŋmanɩɩ aŋ kpa ʋ daagarɩɩ baasɩ, a tɩŋa ŋ. ");
INSERT INTO sig_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nal hʋ buloŋ aa kyɛ dɩ ʋ laa ʋ mɩɩbol, ʋ bɩ sɩ na ʋ. Amɛ nal hʋ aa vɩya ʋ mɩɩbol ta ŋ wɩya, abee Wɩɩsɩ wɩweliye hʋ wɩya, ʋ sɩ kɔnɩ laa ʋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dɩ ɩ rɛ tɩŋ dʋnɩya no buloŋ aŋ bɩ sɩ na mɩɩbol hʋ aa bɩ kaŋ tenii, bekiŋ tɔnɔ rɛ ɩ sɩ na? ");
INSERT INTO sig_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dʋnɩya no tɩyaŋ, bekiŋ nɛ ɩ sɩ wuwo kpa lenni ɩ mɩɩbol? ");
INSERT INTO sig_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma lagɩlagɩ no wɩbɔŋyaala aa vɩya ŋ wɩya hʋ, na ŋ bee ŋ wɩbasɩya buloŋ aa yaa ma hɩɩsɩ rɛ. Amɛ kyɛɛ kɩdɩgɩ, mɩyaŋ Nihuwobiŋ biye, ŋ bee malɩkasɩ buloŋ sɩ ko abee ŋ Kuwo gaŋdarɩ. Haŋ saŋa hʋ tɩyaŋ, ŋ wɩya aa yaa nal hʋ buloŋ hɩɩsɩ, ʋ tɩɩna wɩya mɛ sɩ yaa ŋ hɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nala badɔmɔŋ we daha, ba bɩ sɩ sʋba, see dɩ ba na Wɩɩsɩ koro hʋ sɩna teŋ abee dee ka dɩ ba na sʋba.” ");
INSERT INTO sig_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kyɛyɛ badʋ hal, Yesu sii kaŋ Piita abee Gyemsi abee Gyɔɔŋ dʋŋ, ba mʋ gyɩŋ dogiŋbal kɩdɩgɩ nyuu. Ba yaa dɩ ba deŋ ba sɩya, dɩ Yesu bɩrɩma. ");
INSERT INTO sig_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ʋ gannɩ buloŋ pʋrɩsɩ gɛɛ pogipogi, a kɩ tʋla gɛɛ nyʋlɩɩnyʋlɩɩ. Gasasɩl buloŋ tuwo dʋnɩya no tɩyaŋ ʋ aa sɩ wuwo sasɩ gannɩ dɩ ba pʋrɩsɩ kɩɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ka Ilaagya abee Moosi ko lɩɩ ba sɩya tɩyaŋ, ba bee Yesu sɩŋ kɩ basɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Á nɩhɩyawʋ, ʋ yaa wɩwelii rɛ anɩɩ aa we daha. Leŋ dɩ á we gyama boto, dɩ ɩ tɩŋ kɩdɩgɩ, dɩ Moosi mɛ tɩŋ kɩdɩgɩ, dɩ Ilaagya mɛ tɩŋ kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kambɩŋ fa kaŋ ba rɛ weliŋ. Ɛɛ rɛ tɩŋ ʋ basɩ gɛɛ. Ʋ fa bɩ gyɩŋ wɩɩ hʋ buloŋ ʋ aa sɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɛɛ rɛ taalbal kɩdɩgɩ ko tɔ ba, ka taal kɩdɩgɩ lɩɩ taalbal hʋ tɩyaŋ a baa, “Ŋ biikyoolii rɛ nyɛ. Ma gyegile kɩ nɩɩ ʋ wɩbasɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ba aa nɩɩ taal hʋ a mɩɩgɩ galdaasɩ, ba gyɩ bɩl bɩ naa nal buloŋ, see Yesu dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba aa lɩɩ dogimo hʋ nyuu ko kɩ tuu tɩyaŋ, Yesu basɩ tɩya ba a baa, “Ŋ bee kyɛ dɩ ma ko basɩ wɩɩ hʋ ma aa naa kɩ tɩya nal buloŋ, see saŋa hʋ mɩyaŋ Nihuwobiŋ Biye aa sɩ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɛɛ rɛ ba laa wɩɩ hʋ we ba nyuni tɩyaŋ, aŋ kɩ pɩyɛsɩ dɔmɔŋ, “Ʋ aa sɩ sii sʋʋ tɩyaŋ, ʋ memii rɛ yaa bee?” ");
INSERT INTO sig_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, “Bee rɛ tɩŋ Wɩɩsɩ Teŋ dɩdagɩla hʋ basɩ anɩɩ Ilaagya rɛ sɩ laa sɩya ko, ka dɩ Krisita hʋ na ko?” ");
INSERT INTO sig_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ʋ basɩ tɩya ba a baa, “Wɩtɩɩ rɛ, Ilaagya sɩ kɔnɩ laa sɩya ko, a kaŋ kɩŋ buloŋ marɩ biŋ. Ba saba Nihuwobiŋ Biye hʋ wɩya rɛ a biŋ Wɩɩsɩ teŋ tɩyaŋ, a daga nɩɩ ʋ sɩ na tʋwara kɩŋkaŋ, ka dɩ nala ha deŋ ʋ sɩgyʋʋ, a kana ʋ kʋwasɩ. Bee rɛ tɩŋ ba sabɩ gɛɛ? ");
INSERT INTO sig_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lagɩlagɩ no, ŋ sɩ basɩ tɩya ma anɩɩ Ilaagya paalɩ ko rɛ. Ba kana ʋ yaa ʋ gɛɛ hʋ ba aa kyɛ anɩɩ ba aa saba gɛɛ Wɩɩsɩ Teŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba aa ko pele ʋ hatɩnna hʋ nɩkaalɩya hʋ lee, dɩ nɩgyamaa laŋŋa doŋ. Ba bee Wɩɩsɩ Teŋ dɩdagɩla sɩŋ kaŋ wɩya kɩ kpa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nala hʋ aa naa Yesu dɩ ʋ aa ko, ba hirigi a sii fá mʋ kyem-ʋ, a kyʋwalɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ɛɛ rɛ ʋ pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Wɩbee rɛ ma bee haŋ nala hʋ kaŋ kɩ kpa dɔmɔŋ?” ");
INSERT INTO sig_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nala hʋ kɩdɩgɩ baa, “Á Tɩɩna, ŋ biye rɛ ŋ kaŋ ko ɩ lee. Gyɩŋbɔŋ nɛ kana ʋ, ʋ bɩrɩmɩ ganɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ʋ yaŋ ko kana ʋ buloŋ, ʋ aa tele taŋha tɩyaŋ nɛ, naŋtʋwɔ-fʋŋfʋga tɔ ʋ nyʋwa, ʋ kɩ kyaŋ ʋ nyɩŋa aŋ tiŋŋi. Ŋ sʋla ɩ hatɩnna hʋ dɩ ba kile gyɩŋbɔŋ hʋ ta ʋ tɩyaŋ, amɛ ba bɩ wuwo kile.” ");
INSERT INTO sig_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma lagɩlagɩ no nala, ma bɩ laa Wɩɩsɩ di. Kyɛyɛ baŋmɛ rɛ ma tɩɩ kɩ kyɛ dɩ ŋ yaa ma lee ka ma na laa ŋ di? Ma kaŋ biye hʋ ko ŋ na.” ");
INSERT INTO sig_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɛɛ rɛ ba kaŋ biye hʋ ko ʋ lee. Gyɩŋbɔŋ hʋ aa naa Yesu, ʋ kaŋ biye hʋ kyele, ʋ tuu tele taŋha a kɩ biliŋsi, naŋtʋwɔ-fʋŋfʋga tɔ ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ kuwo hʋ, “Kyɛbee rɛ ʋ piili ʋ?” Ʋ baa “Ʋ biibiri tɩyaŋ buloŋ nɛ ʋ piili ʋ. ");
INSERT INTO sig_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saŋa kɩdɩgɩ ʋ aa wuwo kpa ʋ lo diŋ tɩyaŋ nɛ, koo nɩɩ tɩyaŋ, a kɩ kyɛ dɩ ʋ kpʋ ʋ. Ɩ aa sɩ wuwo yaa wɩɩ hʋ buloŋ, kɩ yaa. Fá ŋ sikii aŋ pɛ ŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ɛɛ rɛ Yesu baa, “Ɩ aa baa dɩ ŋ sɩ wuwo hʋ, ɩ tɩɩ mɛ fa sɩ wuwo yaa, dɩ ɩ fa laa ŋ di. Beewɩya nal hʋ buloŋ aa laa ŋ wɩya di, Wɩɩsɩ aa wuwo ʋ yaa wɩɩ kɛ buloŋ tɩya ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ɛɛ rɛ biye hʋ kuwo sii sɩŋ a heeli basɩ a baa, “Ŋ laa ɩ di rɛ, amɛ ʋ bɩ maga. Pɛ ŋ tɩyaŋ dɩ ŋ laa ɩ di yʋga.” ");
INSERT INTO sig_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ba aa sɩŋ kɩ basɩ wɩya hʋ gɛɛ, nala yʋga fá ko kɩ laŋŋɩ. Yesu aa ko na nɩgyamaa hʋ, ʋ basɩ tɩya gyɩŋbɔŋ hʋ abee sɩfɩyasɩ a baa, “Gyɩŋganɩɩ, mɩyaŋ nɛ baa dɩ ɩ lɩɩ biye hʋ tɩyaŋ. Kɩ pɔ dɩ ɩ ta bɩl maakyiye kana ʋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Gyɩŋbɔŋ hʋ kyɩɩrɩ aŋ kaŋ biye hʋ kyɩgɩsɩ aŋ ko lɩɩ, ka biye hʋ pɩŋ gɛɛ anɩɩ ʋ aa sʋba. Nala hʋ gyeniŋ buloŋ baa dɩ biye hʋ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amɛ Yesu mʋ kaŋ ʋ noŋ tɩyaŋ ʋ sii sɩŋ. ");
INSERT INTO sig_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ mʋ gyʋʋ dɩya. Ba lʋwɔlɩ pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ á kɛ bɩ wuwo kil gyɩŋbɔŋ hʋ?” ");
INSERT INTO sig_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ʋ basɩ tɩya ba a baa, “Nal buloŋ bɩ sɩ wuwo kile gyɩŋbɔŋ no iriŋ, see ʋ aa sʋla Wɩɩsɩ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɛɛ rɛ ba sii lɩɩ doŋ, a tuu tɩŋ Galili paalʋʋ mʋ. Yesu fa bee kyɛ dɩ nal buloŋ gyɩŋ lee hʋ ʋ aa we. ");
INSERT INTO sig_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Beewɩya ʋ gyɩ aa daga ʋ hatɩnna hʋ rɛ. Ʋ gyɩ basɩ tɩya ba rɛ a baa, “Ba sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye, a we nala nosi tɩyaŋ dɩ ba kpʋ ŋ. Amɛ ŋ sɩ sii sʋʋ tɩyaŋ ʋ kyɛyɛ boto kyɛɛ, a kaŋ mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amɛ ba fa bɩ gyɩŋ wɩɩ hʋ ʋ aa basa memii, aŋ kɩ fá kambɩŋ ba aa sɩ pɩyɛsɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɛɛ rɛ ba sii ko Kapɛɛnam. Ba aa gyʋʋ dɩya, Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Bekiŋ wɩɩ rɛ ma fa kaŋ kɩ kpa dɔmɔŋ ŋmanɩɩ hʋ tɩyaŋ gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɛɛ rɛ ba tallɩ ba nyʋʋsɩ, beewɩya ba tɩyaŋ nɩhɩyawʋ wɩya rɛ ba fa kaŋ kɩ kpa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɛɛ rɛ Yesu hɔŋ aŋ yɩrɩ ʋ hatɩnna fi abee balɩya hʋ, a basɩ tɩya ba a baa, “Nal hʋ aa kyɛ dɩ ʋ yaa ma tɩyaŋ nɩbal, see dɩ ʋ kaŋ ʋ tɩɩ bɩrɩmɩ ma tɩyaŋ haŋbiye a tʋma tɩya ma buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɛɛ rɛ ka ʋ kaŋ biibiye a ko sɩgɩ ba tʋtʋʋ, a guwori ʋ aŋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dɩ nal lɛ kuu ŋ wɩya a kaŋ biibiye no dɔŋtɩɩna weliŋ, mɩyaŋ nɛ ʋ kaŋ weliŋ gɛɛ. Nal hʋ mɛ buloŋ aa kana ŋ weliŋ, ŋ dʋŋ daa ʋ kaŋ weliŋ. Nal hʋ aa tɩma ŋ mɛ rɛ ʋ kaŋ weliŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ɛɛ rɛ Gyɔɔŋ basɩ tɩya Yesu a baa, “Á Tɩɩna, á naa baal kɩdɩgɩ rɛ dɩ ʋ kpaa ɩ feŋ a kɩ kile gyɩŋbɔmɔ nala tɩyaŋ. Ɛɛ rɛ á kile ʋ dɩ ʋ ta kɩ yaa gɛɛ, beewɩya ʋ bɩ yaa á kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amɛ Yesu basɩ tɩya ba a baa, “Dɩ ʋ rɛ aa yaa gɛɛ, ma ta kile ʋ. Dɩ nal lɛ yaa wɩmagɩl buloŋ ŋ feŋ tɩyaŋ, ʋ kyiye bɩl bɩ sɩ wuwo kyogi ŋ feŋ. ");
INSERT INTO sig_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nal hʋ buloŋ aa bɩ lɩɩ ŋ hal, ʋ yaa á kɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa kpaa nɩɩnyʋwagbaŋbiye bee nɩɩ a tɩya ma akuu ma aa yaa ŋ hatɩnna wɩya, ʋ kaŋ ʋ tuno rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nal hʋ buloŋ aa naa haŋbiisi no aa tɩŋa ŋ tɩyaŋ kɩdɩgɩ, a mʋrɩ ʋ dɩ ʋ yaa wɩbɔŋ, ʋ maga dɩ ba kpa nɔŋ a vʋwa laalɩ ʋ bagɩna tɩyaŋ nɛ, a kpa ʋ yuwo we mpʋwɔnʋʋ tɩyaŋ. Dɩ ba aa rɛ yaa ʋ gɛɛ, ʋ rɛ sɩ kpɩya ʋ aa weye. ");
INSERT INTO sig_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Dɩ ɩ noŋ nɛ aa kyɛ dɩ ʋ kana ɩ we wɩbɔmɔ yayɩ tɩyaŋ, keri ta. Ɩ aa sɩ mʋ wɩɩsɩbee abee nokuu, ʋ rɛ kpɩya ɩ aa kaŋ nopilime aŋ gyʋʋ diŋ, ‘Lee hʋ kyaaŋkyʋwana aa sɩ di ɩ teŋbii deŋdeŋ a bɩ sɩ sʋba, ka diŋ hʋ mɛ bɩ sɩ dɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Dɩ ɩ naaŋ nɛ aa kyɛ dɩ ʋ kana ɩ we wɩbɔmɔ yayɩ tɩyaŋ, keri ta. Ɩ aa sɩ mʋ wɩɩsɩbee abee naakuu, ʋ rɛ kpɩya ba aa sɩ kpa ɩ yuwo we diŋ tɩyaŋ abee naapilime. ‘Lee hʋ kyaaŋkyʋwana aa sɩ di ɩ teŋbii deŋdeŋ a bɩ sɩ sʋba, ka diŋ hʋ mɛ bɩ sɩ dɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dɩ ɩ sii rɛ aa kyɛ dɩ ʋ kana ɩ we wɩbɔmɔ yayɩ tɩyaŋ, kɔrɩgɩ lɩɩ ta. Ɩ aa sɩ mʋ wɩɩsɩbee abee sɩtogo, ʋ rɛ kpɩya ba aa sɩ kpa ɩ yuwo we diŋ tɩyaŋ abee sɩya balɩya, ");
INSERT INTO sig_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Lee hʋ kyaaŋkyʋwana aa sɩ di ɩ teŋbii deŋdeŋ a bɩ sɩ sʋba, ka diŋ hʋ mɛ bɩ sɩ dɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Diŋ nɛ ba sɩ kpa pɩɩsɩ nal buloŋ bisiŋ ta. ");
INSERT INTO sig_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yɩsɩ sʋma, amɛ dɩ ʋ sʋmɩŋ ko lɩɩ, ɩ bɩl bɩ sɩ wuwo yaa ʋ dɩ ʋ sʋma. Ma leŋ dɩ ma tɩsɩ sʋma anɩɩ yɩsɩ aa sʋma gɛɛ, aŋ leŋ dɩ ma buloŋ kaŋ nyʋʋdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ɛɛ rɛ Yesu sii lɩɩ doŋ, a mʋ Gyudɩya paalʋʋ abee Gyɔɔdaŋ fuwo hʋ kyolo. Nɩgyamaa bɩl ko laŋŋɩ ʋ lee. Ʋ bɩl kɩ daga ba anɩɩ ʋ aa kɩ daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɛɛ rɛ Farasiima badɔmɔŋ mɛ sii ko ʋ lee, a kɩ kyɛ dɩ ba magɩsɩ ʋ, a pɩyɛsɩ ʋ a baa, “Ʋ yaa ŋmanɩɩ rɛ dɩ baal vɩya ʋ haaŋ?” ");
INSERT INTO sig_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Ɛɛ rɛ Moosi daga ma dɩ ma kɩ tɩŋa?” ");
INSERT INTO sig_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba baa, “Moosi basa anɩɩ dɩ baal lɛ aa kyɛ dɩ ʋ vɩya ʋ haaŋ, dɩ ʋ laa sɩya sabɩ haaŋ-vɩyayɩ teŋ a tɩya haaŋ hʋ aŋ na vɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma dagɩɩ hayɛ, ɛɛ rɛ tɩŋ Moosi gyɩ sabɩ gɛɛ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amɛ Wɩɩsɩ aa piili dʋnɩya marɩɩ, baal abee haaŋ nɛ ʋ marɩ. ");
INSERT INTO sig_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛɛ wɩya baal aa sɩ leŋ ʋ kuwo abee ʋ naa rɛ, aŋ kpa haaŋ dɩ ʋ bee haaŋ hʋ yaa kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nala no balɩya sɩ kaŋ kyaldɩgɩ, ba bɩl bɩ yaa nala balɩya, ba bɩrɩmɩ nɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wɩɩsɩ yaŋ aa kaŋ nala hʋ pɛ dɔmɔŋ, ʋ bɩ maga dɩ nihuwobiŋ kaŋ ba porigi.” ");
INSERT INTO sig_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu bee ʋ hatɩnna hʋ mɩɩgɩ sii gyʋʋ dɩya. Ɛɛ rɛ ba bɩl pɩyɛsɩ ʋ wɩɩ no tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ʋ basɩ tɩya ba a baa, “Baal hʋ kɛ buloŋ aa vɩya ʋ haaŋ aŋ bɩl kpa hadɩma, ʋ tɩɩna gyʋʋ ʋ haaŋ hʋ haakye tɩyaŋ nɛ, aŋ pɛ yaa sɔŋsɔnnɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dɩ haaŋ mɛ rɛ vɩya ʋ bala, aŋ mɛ bɩl mʋ yal badɩma, ʋ mɛ gyʋʋ ʋ bala hʋ haakye tɩyaŋ nɛ, aŋ pɛ yaa sɔŋsɔnnɩ mɛ.” ");
INSERT INTO sig_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nala badɔmɔŋ gyɩ kaŋ ba biibiisi ko Yesu lee rɛ, dɩ ʋ kpa ʋ nosi dɔbɔ ba tɩyaŋ dɩ Wɩɩsɩ pɛ ba. Ɛɛ rɛ ʋ hatɩnna hʋ nɔsɩ ba. ");
INSERT INTO sig_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu aa naa gɛɛ, ʋ na baaŋ ʋ hatɩnna hʋ nyuu tɩyaŋ, aŋ basɩ tɩya ba a baa, “Ma leŋ dɩ haŋbiisi hʋ ko ŋ lee. Ma ta kil ba. Nala no iriŋ nɛ sɩ gyʋʋ Wɩɩsɩ koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ɩ bɩ yelli Wɩɩsɩ anɩɩ haŋbiye aa yelli ʋ kuwo abee ʋ naa gɛɛ, ɩ bɩ sɩ na Wɩɩsɩ koro hʋ gyʋʋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɛɛ rɛ ʋ paa haŋbiisi hʋ nɔgɔ, a kpa ʋ nosi dɔbɔ ba tɩyaŋ, a sʋla Wɩɩsɩ tɩya ba dɩ Wɩɩsɩ pɛ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu gyɩ bɩl sii dɩ ʋ vala ŋmanɩɩ, ɛɛ rɛ baal kɩdɩgɩ fá ko gbinni ʋ sɩya tɩyaŋ a pɩyɛsɩ ʋ, “Ŋ Tɩɩŋwelii, ɛɛ rɛ ŋ sɩ yaa a kaŋ mɩɩbol aa bɩ kaŋ tenii?” ");
INSERT INTO sig_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ ɩ yɩrɩ ŋ ɩ Tɩɩŋwelii? Nal buloŋ bɩ weliye, see Wɩɩsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na ɩ gyɩŋ Wɩɩsɩ mɩrɩsɩ hʋ rɛ. Ba aa rɛ nyɛ, ‘Ta kpʋʋ nal, ta kyɛ ɩ dɔŋtɩɩna haaŋ, ta gaa, dɩ ɩ rɛ yaa daŋsɩya wɩɩ tɩyaŋ, ta nyɩya wɩya. Ta firimi laa nal kɩŋ. Kɩ fá ɩ kuwo abee ɩ naa.”’ ");
INSERT INTO sig_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɛɛ rɛ baal hʋ basɩ tɩya Yesu a baa, “Ŋ Tɩɩna, ŋ tɩŋ wɩya no kɛ buloŋ nɛ a lɩɩ ŋ biibiri tɩyaŋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ɛɛ rɛ Yesu lurimi ʋ sɩya tɩyaŋ abee kyori aŋ basɩ tɩya ʋ a baa, “Wɩdɩgɩ rɛ kaa ɩ ha aa bɩ yaa. Mʋ kpa ɩ kɩna hʋ buloŋ yallɩ, a kpa molbiye hʋ tɩya nyaaba aŋ ko kɩ tɩŋa ŋ. Dɩ ɩ rɛ yaa gɛɛ, ɩ sɩ kaŋ kɩna wɩɩsɩbee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu aa basɩ gɛɛ, baal hʋ sɩya bil, beewɩya ʋ gyɩ kaŋ kɩna rɛ weliŋ. Ʋ tɩya buloŋ kyogi, ʋ sii mʋ. ");
INSERT INTO sig_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ɛɛ rɛ Yesu deŋ nala hʋ aŋ mɩɩgɩ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ʋ yaa wɩduwo rɛ abee kɩna tɩmma aa sɩ wuwo gyʋʋ Wɩɩsɩ koro hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ʋ aa basɩ gɛɛ ʋ hatɩnna hʋ nyʋʋsɩ fɩyɛlɩ. Ʋ bɩl mɩɩgɩ basɩ tɩya ba a baa, “Ŋ kyaŋsɩ, Wɩɩsɩ koro hʋ gyʋʋyɩ yaa wɩduwo rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyɔgɩmaa aa sɩ tɩŋ gahaŋ sɩɩ lɩɩ, ʋ rɛ yaa mɔl a te kɩna tɩɩna aa sɩ wuwo gyʋʋ Wɩɩsɩ koro hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu aa basɩ gɛɛ, ʋ hatɩnna hʋ nyʋʋsɩ marɩ fɩyɛlɩ, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Dɩ ba aa rɛ kɩɩ nyɛ, aŋnɛ rɛ yaŋ sɩ wuwo na Wɩɩsɩ laatayɩ?” ");
INSERT INTO sig_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu mɩɩgɩ deŋ ba aŋ baa, “Wɩɩ no kpere nihuwobiŋ nɛ, amɛ ʋ bɩ kpere Wɩɩsɩ kɛ. Beewɩya, wɩɩ buloŋ tuwo Wɩɩsɩ aa bɩ sɩ wuwo yaa.” ");
INSERT INTO sig_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ɛɛ rɛ Piita basɩ tɩya ʋ a baa, “Na, á kɛ leŋ kɩŋ buloŋ nɛ aŋ kɩ tɩŋa ɩ hal.” ");
INSERT INTO sig_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu basɩ tɩya ba a baa, “Waa, wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa sɩ kuu ŋ wɩya abee Wɩɩsɩ wɩweliye hʋ wɩya, a leŋ ʋ dɩya, koo ʋ naabalɩya, koo ʋ naa, koo ʋ kuwo, koo ʋ biisi, koo ʋ bagɩsɩ, ");
INSERT INTO sig_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ʋ tɩɩna sɩ bɩl na dɩɩsɩ, abee nɩmmabalɩya, abee nɩmma, abee biisi, abee bagɩsɩ naaŋsɩɩnyʋwa kɔɔ dʋnɩya no tɩyaŋ. Ba sɩ kuu ŋ wɩya a dɔgɩsɩ ʋ, amɛ dɩ ʋ rɛ ko sʋba, ʋ mɛ sɩ na mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amɛ nala yʋga aa laa sɩya gyɩnaŋ, ba sɩ ko laa hal, ka dɩ nala hʋ aa laa hal gyɩnaŋ mɛ ko laa sɩya.” ");
INSERT INTO sig_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu aa basɩ gɛɛ dɩ ba we ŋmanɩɩ tɩyaŋ nɛ a kɩ mʋ Gyerusalɛm. Yesu laa ba sɩya. Ʋ hatɩnna hʋ nyʋʋsɩ gyɩ fɩyɛla rɛ abee ʋ wɩbasɩya hʋ, kambɩŋ gyɩ gba kaŋ nala hʋ badɔmɔŋ aa tɩŋ ba hal. Ɛɛ rɛ Yesu kaŋ ʋ hatɩnna hʋ dʋŋ a gɩɩgɩ lɩɩ, a basɩ tɩya ba wɩya hʋ buloŋ nala aa sɩ yaa ʋ. Ʋ baa, ");
INSERT INTO sig_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ma gyegili daha! Á aa mʋ Gyerusalɛm nɛ. Dɩ ámaa rɛ ko pele doŋ, ba sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye, a kaŋ mʋ tɩya wɩɩkyʋwal sɩlaala nɩhɩyasɩ, abee Wɩɩsɩ Teŋ dɩdagɩla. Ba sɩ di ŋ sarɩya aŋ baa dɩ ʋ maga dɩ ba kpʋ ŋ nɛ, aŋ kana ŋ mʋ we nala hʋ aa bɩ yaa Gyuuma nosi tɩyaŋ dɩ ba kpʋ ŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba sɩ yaa ŋ sɩya, aŋ tʋ naŋtʋwɔl we ŋ tɩyaŋ. Ba sɩ vɩɩrɩ ŋ, aŋ kpʋ ŋ, amɛ ŋ sɩ sii sʋʋ tɩyaŋ ʋ kyɛyɛ boto kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ɛɛ rɛ Gyemsi abee Gyɔɔŋ, Zebedi balɩya hʋ, sii mʋ Yesu lee a basɩ tɩya ʋ a baa, “Á Tɩɩna, aa sʋla ɩ, wɩɩ kɩdɩgɩ rɛ we doŋ á kɩ kyɛ dɩ ɩ yaa tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Wɩbee rɛ ma kɩ kyɛ dɩ ŋ yaa tɩya ma?” ");
INSERT INTO sig_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba baa, “Ɩ aa sɩ di Wɩɩsɩ koro hʋ, a kaŋ feŋ, a hɔŋ ɩ kuwori kpasa hʋ nyuu, leŋ dɩ á yaa ɩ logiŋ hʋhɔnnɔ, dɩ kɩdɩgɩ hɔŋ ɩ noduu, dɩ kɩdɩgɩ mɛ hɔŋ ɩ nogɔbɔ.” ");
INSERT INTO sig_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma bɩ gyɩŋ kɩŋ hʋ ma aa kyɛ. Ma sɩ wuwo kaŋ bembii a na tʋwara hʋ ŋ aa sɩ na? Ma sɩ wuwo fo dɔgɩsɩɩ hʋ ŋ aa sɩ fo?” ");
INSERT INTO sig_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba baa, “Waa, á sɩ wuwo.” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ma basɩ. Tʋwara hʋ ŋ aa sɩ na, ʋ rɛ ma mɛ sɩ na. Dɔgɩsɩɩ hʋ ŋ aa sɩ fo, ʋ rɛ ma mɛ sɩ fo. ");
INSERT INTO sig_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amɛ ŋ noduu abee ŋ nogɔbɔ hʋhɔnnɔ hʋ kɛ, ŋ daa sɩ lɩɩ ba. Wɩɩsɩ rɛ gyɩŋ nala hʋ ʋ aa mara doŋ biŋ pɔ.” ");
INSERT INTO sig_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu hatɩnna fi hʋ aa nɩya dɩ Gyemsi bee Gyɔɔŋ basɩ gɛɛ, ba kaŋ ba kɩ di dɔŋdɔŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ɛɛ rɛ Yesu yɩrɩ ba buloŋ ko laŋŋɩ a basɩ tɩya ba a baa, “Nala hʋ aa bɩ yaa Gyuuma, ka ma gyɩŋ ba kuworo aa kɩɩ gɛɛ rɛ. Ba aa hɔŋ ba nala nyuu tɩyaŋ nɛ, a kaŋ ba kɩ fɩla. Ka nala hʋ sɩlaala mɛ ha kaŋ ba dee wɩɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amɛ ʋ bɩ maga dɩ ma kɛ kɩɩ gɛɛ, ma tɩyaŋ nal hʋ aa kyɛ dɩ ʋ yaa ma nɩbal, ʋ maga dɩ ʋ rɛ tʋma kɩ tɩya ma buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma nal hʋ aa kyɛ dɩ ʋ yaa ma tɩyaŋ kuwori, ʋ maga dɩ ʋ rɛ yaa ma tɩyaŋ yoŋ. ");
INSERT INTO sig_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mɩyaŋ Nihuwobiŋ Biye, ŋ bɩ ko dɩ ŋ kyɛ nala dɩ ba tʋma kɩ tɩya ŋ, ŋ ko dɩ ŋ tʋma tɩya ba rɛ aŋ sʋba, a kpa ŋ mɩɩbol tuŋ laa nɩgyamaa mɩɩbolo ta tɩya ba.” ");
INSERT INTO sig_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu bee ʋ hatɩnna hʋ gyɩ sii mʋ Gyɛriko rɛ. Saŋa hʋ ba aa sii lɩɩ bee hʋ tɩyaŋ a kɩ mʋ, nɩgyamaa sii paa tɩŋ ba hal. Ba buloŋ kpaa kɩ mʋ dɩ nyʋlʋŋ kɩdɩgɩ rɛ hɔŋ ŋmanɩɩ hʋ nyʋwa gɛɛ, a kɩ sʋla kɩna. Ʋ feŋ nɛ yaa Batimeyo, a yaa Timeyo biibaal. ");
INSERT INTO sig_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ʋ aa nɩɩ dɩ Yesu aa lɩɩ Nazarɛti rɛ aa ko, ʋ huwori yɩrɩ ʋ a baa, “Yesu, Deviti nihii, fá ŋ sikii.” ");
INSERT INTO sig_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nɩgyamaa nɔsɩ ʋ dɩ ʋ leŋ ʋ kyagɩŋsɩ hʋ. Ka ʋ vɩya aŋ marɩ yɩrɩ te gɛɛ a baa, “Yesu, Deviti nihii, fá ŋ sikii.” ");
INSERT INTO sig_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ɛɛ rɛ Yesu mɩɩgɩ sɩŋ, aŋ baa dɩ ba yɩrɩ ʋ dɩ ʋ ko. Ɛɛ rɛ ba yɩrɩ nyʋlʋŋ hʋ a basɩ tɩya ʋ a baa, “Kana ɩ tɩɩ aŋ sii ko. Ʋ aa yɩrɩ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ʋ aa nɩɩ gɛɛ, ʋ wuri ʋ wagyɛ ta, a sii gyaa kyigisi, aŋ kpa ko pele Yesu. ");
INSERT INTO sig_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Bekiŋ nɛ ɩ kɩ kyɛ dɩ ŋ yaa tɩya ɩ?” Ɛɛ rɛ ʋ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, leŋ dɩ ŋ sɩya suri dɩ ŋ bɩl kɩ na.” ");
INSERT INTO sig_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ laa ŋ di rɛ, ɛɛ rɛ leŋ ɩ deye. Kɩ mʋ.” Ɛɛ rɛ ʋ sɩya pirigi suri, ʋ kɩ tɩŋ Yesu hal ŋmanɩɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nyɛ rɛ Yesu bee ʋ hatɩnna hʋ gyɩ kpa kɩ mʋ Gyerusalɛm, a ko pele Bɛtifage abee Bɛɛtani aa sɩŋ Olivi dogimo hʋ naasɩ tɩyaŋ. Ɛɛ rɛ Yesu lɩɩ ʋ hatɩnna balɩya, a tɩŋ ba a basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ma mʋ tɔɔ hʋ aa we ma sɩya. Dɩ mamaa rɛ ko mʋ, ma sɩ na kokubiye dɩ ba vʋwa sɩgɩ. Nal buloŋ ha bɩ gyɩna ʋ. Ma puri a kaŋ ko. ");
INSERT INTO sig_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dɩ mamaa rɛ ko kɩ puri, dɩ ba pɩyɛsɩ ma baa bee rɛ tɩŋ ma kɩ puri, ma baa, ‘Tɩɩna hʋ rɛ aa kyɛ. Ʋ rɛ baa á puri kaŋ ko. Á sɩ mɩɩgɩ kana ʋ ko lagɩ.”’ ");
INSERT INTO sig_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba aa tɩŋ ŋmanɩɩ hʋ kɩ baŋ dɩ ba vʋwa kokubiye sɩgɩ dɩya kɩdɩgɩ dimbee nyʋwa tɩyaŋ. Ba mʋ dɩ ba puri. ");
INSERT INTO sig_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ba aa puri kokubiye hʋ tɩyaŋ nɛ, nala badɔmɔŋ aa sɩŋ doŋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ puri kokubiye hʋ?” ");
INSERT INTO sig_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɛɛ rɛ ba basɩ gɛɛ hʋ Yesu aa baa dɩ ba basɩ. Ba aa basɩ gɛɛ, ba leŋ ba puri mʋ. ");
INSERT INTO sig_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba kaŋ kokubiye hʋ ko tɩya Yesu, a wuri ba gannɩ a dɔbɔ kokubiye hʋ tɩyaŋ, Yesu gyɩŋ hɔŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Badɔmɔŋ mɛ kpa ba gannɩ gyarɩ ŋmanɩɩ hʋ tɩyaŋ. Badɔmɔŋ mɛ keri ŋmanɩɩnyʋwa paaponni, a mɛ kaŋ lɩɩ gyarɩ ŋmanɩɩ hʋ tɩyaŋ dɩ ʋ kɩ vala. ");
INSERT INTO sig_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nala hʋ badɔmɔŋ we ʋ sɩya, ba badɔmɔŋ mɛ kɩ tɩŋa ʋ hal. Ba buloŋ kɩ kyɩɩrɩ, a baa, “Ma dannɩ ʋ! Tabarikala! Wɩɩsɩ sɩ pɛ nal hʋ aa ko á Tɩɩna feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Á naabaa Deviti koro hʋ rɛ bɩl aa ko. Wɩɩsɩ sɩ leŋ dɩ ʋ ko. Ma leŋ dɩ á dannɩ Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ɛɛ rɛ Yesu mʋ Gyerusalɛm, a mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ, a deŋ kɩna hʋ buloŋ a we doŋ. Ʋ aa ko deŋ teŋ dɩ lee bile. Ɛɛ rɛ ʋ bee ʋ hatɩnna fi abee balɩya hʋ mɩɩgɩ mʋ Bɛɛtani a pɩŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ʋ sɩya aa gballa, ba sii lɩɩ Bɛɛtani a kpa ŋmanɩɩ hʋ kɩ mʋ. Losi kaŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɛɛ rɛ ʋ naa tutogo dɩ ʋ mʋ sɩŋ sɩya a kaŋ paaponni. Ʋ mʋ pele ʋ memii a kɩ liisi anɩɩ nɔnɔ we doŋ nɛ. Ʋ mʋ wil nyuu deŋ dɩ nɔnɔ tuwo, see paaponni dʋŋ, beewɩya ba nɔnɩɩ ha bɩ pele. ");
INSERT INTO sig_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ɛɛ rɛ Yesu basɩ tɩya tɩya hʋ a baa, “Á lɩɩ gyɩnaŋ a kaŋ kɩ mʋ, nal buloŋ bɩl bɩ sɩ na ɩ nɔŋ di.” Ʋ hatɩnna hʋ nɩɩ ʋ aa basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɛɛ rɛ ba mʋʋ pele Gyerusalɛm. Ba aa ko pele doŋ, Yesu mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ, dɩ nala badɔmɔŋ we doŋ a kɩ yallɩ kɩna, ka badɔmɔŋ mɛ kɩ yɔbɔ kɩna. Yesu kile ba buloŋ ta, ba lɩɩ. Baala badɔmɔŋ mɛ gyɩ we doŋ a kɩ kyeŋgi molbiye. Yesu ŋmaa ba teebʋlsɩ mɛ lo. Baala badɔmɔŋ mɛ gyɩ aa yallɩ kokosi, ʋ ŋmaa ba kpasɩnɩ mɛ lo. ");
INSERT INTO sig_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ʋ bɩ laa dɩ nal buloŋ kaŋ kɩyallɩya ko tɩŋ Wɩɩkyʋwaldɩya hʋ gyaŋwuwo tɩyaŋ baŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɛɛ rɛ Yesu piili kɩ daga ba, a baa, “Ma bɩ liisi wɩya hʋ ba aa saba Wɩɩsɩ teŋ hʋ tɩyaŋ? Ba saba dɩ Wɩɩsɩ baa ʋ dɩya sɩ yaa lee hʋ paalʋʋsɩ buloŋ nala aa sɩ kɩ kyʋwalɩ Wɩɩsɩ rɛ, aŋka ma kɛ mɩɩgɩ kaŋ doŋ bɩrɩmɩ gaala dɩya.” ");
INSERT INTO sig_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ aa ko nɩɩ wɩya hʋ ʋ aa yaa, ba piili kɩ kyɛ ŋmanɩɩ hʋ ba aa sɩ tɩŋa a lɩɩ ʋ mɩɩbol. Beewɩya ʋ wɩdagɩya hʋ gyɩ gyʋʋ gyamaa hʋ buloŋ dɩgɩŋ nɛ a yaa ba nyʋʋfɩyɛlɩ. Nyɛ rɛ tɩŋ kambɩŋ gyɩ kaŋ wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ, ba kɩ kyɛ ŋmanɩɩ dɩ ba lɩɩ ʋ mɩɩbol gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ʋ dɩdaana gyɩ aa ko pele, Yesu bee ʋ hatɩnna hʋ mɩɩgɩ lɩɩ tɔɔ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ʋ kyɩkyʋwala pipi ba bɩl sii kpa ŋmanɩɩ hʋ kɩ mʋ, a na tɩya hʋ dɩ ʋ buloŋ sʋba a tuu parɩ ʋ naaliliye tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ɛɛ rɛ Piita liisi wɩɩ hʋ Yesu aa basɩ tɩya tɩya hʋ, a basɩ tɩya Yesu a baa, “Á nɩhɩyawʋ, deŋ na, tɩya hʋ ɩ aa ŋmɩyɛsa we hʋ, ʋ rɛ sʋba gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma laa Wɩɩsɩ di. ");
INSERT INTO sig_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ mamaa rɛ laa Wɩɩsɩ di, a bee yaa ʋ sige, ma sɩ wuwo basɩ tɩya dogimo no dɩ ʋ sii mʋ tele mpʋwɔnʋʋ tɩyaŋ, dɩ gɛɛ kɔnɩ yaa. ");
INSERT INTO sig_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɛɛ wɩya kɩna hʋ kɛ buloŋ ma aa sʋla Wɩɩsɩ kɩ kyɛ, dɩ mamaa rɛ laa di anɩɩ ma sɩ na ba, ma aa na ba rɛ. ");
INSERT INTO sig_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Saŋa kɛ buloŋ dɩ ɩ rɛ aa kyʋwalɩ Wɩɩsɩ, liisi na dɩ ɩ bee nal kaŋ wɩɩ koo. Dɩ wɩɩ ko we doŋ, ʋ kyo dɩ ʋ kɩɩ gɛɛ buloŋ, ɩ kɛ kpa kyɛ ʋ tɩɩna ɩ Wɩɩsɩ hʋ kyʋwalɩɩ tɩyaŋ. Dɩ ɩ rɛ ko yaa gɛɛ, Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ, ʋ mɛ sɩ kpa ɩ wɩbɔmɔ kyɛ ɩ. ");
INSERT INTO sig_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amɛ dɩ ɩ rɛ bɩ kpaa wɩya kɩ kyɛ ɩ dɔŋtɩŋsɩ, ɩ kuwo Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ mɛ bɩ sɩ kpa ɩ wɩbɔmɔ kyɛ ɩ.” ");
INSERT INTO sig_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nyɛ rɛ ba bɩl ko Gyerusalɛm a mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. Yesu aa vala Wɩɩkyʋwaldɩya hʋ gyaŋwuwo tɩyaŋ gɛɛ rɛ, wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla, abee Gyuuma nɩhɩyasɩ hʋ buloŋ sii ko ʋ lee a pɩyɛsɩ ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Bekiŋ dee rɛ ɩ kana a kɩ yaa wɩya no buloŋ? Aŋnɛ rɛ tɩya ɩ ŋmanɩɩ ɩ kɩ yaa ba?” ");
INSERT INTO sig_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ mɛ sɩ pɩyɛsɩ ma wɩdɩgɩ. Dɩ mamaa rɛ ko lɩɩ ʋ sɩɩ tɩya ŋ, ŋ mɛ sɩ daga ma dee hʋ ŋ aa kana memii.” ");
INSERT INTO sig_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Kɩbee rɛ gyɩ tɩya Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ ŋmanɩɩ ʋ kɩ fo nala wɩɩkyʋwalnɩɩ? Wɩɩsɩ rɛ koo nihuwobiŋ nɛ? Ma daga ŋ.” ");
INSERT INTO sig_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ba piili kaŋ wɩɩ hʋ kɩ kpa dɔmɔŋ a baa, “Wɩbee rɛ á sɩ na tɩya ʋ? Dɩ ámaa rɛ baa Wɩɩsɩ lee rɛ ʋ lɩɩ, ʋ sɩ pɩyɛsɩ ma baa bee rɛ yaŋ tɩŋ á bɩ laa wɩya hʋ ʋ aa basɩ di? ");
INSERT INTO sig_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Á yaŋ sɩ wuwo baa ʋ lɩɩ nihuwobiŋ lee kɛ? Aayɩ.” Kambɩŋ gyɩ kaŋ ba rɛ nala hʋ aa we doŋ wɩya, beewɩya nala basa anɩɩ Gyɔɔŋ fa kɔnɩ yaa Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛɛ rɛ ba basɩ tɩya Yesu a baa, “Á bɩ gyɩma.” Yesu mɛ basɩ tɩya ba a baa, “Ɛɛ kɛ, ŋ mɛ bɩ sɩ daga ma nal hʋ aa tɩya ŋmanɩɩ ŋ kɩ yaa wɩya no.” ");
INSERT INTO sig_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu bɩl maga namaga a tɩya ba a baa, “Baal kɩdɩgɩ rɛ biŋ baga a pɔ kɩna aa kaŋ nɔŋkyɩga anɩɩ kyʋkyɔyɩ, ba kɩ yɩrɩ girepisi. Ʋ gyɩ lɩga baga hʋ buloŋ nɛ gol baŋ. A hul bʋwa baga hʋ tɩyaŋ dɩ ba kyaga tɩɩnɔnɔ hʋ nɩɩ kɩ we beewɩya ba kpaa tɩɩnɔnɔ no kɩ kyɔ sɩŋ nɛ, a saa dɩɩbiye mɛ ba aa sɩ wuwo hɔŋ ʋ sal nyuu tɩyaŋ kɩ pɔ baga hʋ. Ɛɛ hal tɩyaŋ nɛ ʋ paa nala a we baga hʋ tɩyaŋ dɩ ba kɩ tʋma, aŋka ʋ sii kpa mʋ tɔɔ kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tɩɩnɔnɔ hʋ tɔrɩɩ gyɩ aa ko pele, ʋ tɩŋ ʋ dɩya tʋŋtʋnna hʋ kɩdɩgɩ dɩ ʋ mʋ baga tʋŋtʋnna hʋ lee a laa ʋ tɩɩnɔnɔ tol ko. Ʋ sii kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baga tʋŋtʋnna hʋ sii kana ʋ a ŋmaa ʋ, aŋ leŋ ʋ kaŋ nohɩlɩya mɩɩgɩ mʋ baga hʋ tɩɩna lee. ");
INSERT INTO sig_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ʋ bɩl mɩɩgɩ tɩŋ dɩya tʋŋtʋnna hʋ kɩdɩgɩ. Ʋ mɛ bɩl kpa mʋ. Ba kana ʋ mɛ, a ŋmaa ʋ, a yaga ʋ nyuu luri, a yaa ʋ gyarɩgɩɩ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ʋ bɩl tɩŋ nitoo tɩɩna, ʋ mɛ bɩl mʋ. Ba paalɩ kpʋ ʋ kɛ. Nɩgyamaa hʋ buloŋ ʋ aa tɩma, gɛɛ tɩɩ rɛ ba yaa ba buloŋ. Ba ŋmaa badɔmɔŋ nɛ aŋ kpʋ badɔmɔŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ba kateŋse tɩyaŋ, ʋ biibaal dʋŋ nɛ ko mʋ ka. Ɛɛ rɛ ʋ sii tɩma ʋ aŋ baa, “Dɩ ŋ biye tɩɩ kɛ rɛ mʋwa, ba sɩ tɩya ʋ gyɩrɩma.” Ʋ mɛ bɩl kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tʋŋtʋnna hʋ aa naa biye hʋ, ba basɩ tɩya dɔmɔŋ a baa, “Dɩ baga hʋ tɩɩna rɛ ko sʋba, biye no rɛ sɩ di ʋ kyaŋ. Ma leŋ dɩ á kpʋ ʋ. Dɩ ámaa rɛ kpʋ ʋ, baga hʋ bee ʋ kɩna buloŋ aa bɩrɩmɩ á kɩna rɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba kaŋ biye hʋ, a ŋmaa ʋ kpʋ, a kpa ʋ yuwo ta ɔhɔ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ba aa maga nyɛ, ɛɛ rɛ baga hʋ tɩɩna sɩ yaa? Ʋ sɩ ko leŋ dɩ ba kpʋ haŋ tʋŋtʋnna hʋ buloŋ, aŋ ka dɩ ʋ kpa baga hʋ tɩya nɩdʋŋsɩ.” ");
INSERT INTO sig_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɛɛ rɛ Yesu pɩyɛsɩ nala hʋ aa nɩɩ namaga hʋ a baa, “Ma bɩ karɩmɩ Wɩɩsɩ teŋ lee hʋ ba aa basɩ nyɛ?” ‘Bʋyɩ hʋ dɩɩsaala hʋ a vɩya ta, ʋ rɛ mɩɩgɩ ko yaa bʋduwo baa aa kpaa biŋ dɩya hʋ gyememii ʋ kaŋ dɩya hʋ sɩgɩ. ");
INSERT INTO sig_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Á Tɩɩna Wɩɩsɩ tʋma rɛ gɛɛ. Ʋ yaa ma wɩkperii rɛ?”’ ");
INSERT INTO sig_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu aa basɩ gɛɛ, Gyuuma nɩhɩyasɩ hʋ gyɩ kɩ kyɛ dɩ ba kana ʋ tɔ dɩyaŋ, beewɩya ba gyɩma anɩɩ ba aa rɛ ʋ maga namaga hʋ kɩ daga. Amɛ ba gyɩ aa fá nala hʋ aa we doŋ nɛ. Ɛɛ rɛ tɩŋ ba lem-ʋ aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɛɛ hal tɩyaŋ nɛ ba mʋ tɩŋ Farasiima abee Hɛrɔtɩ hatɩnna badɔmɔŋ dɩ ba bɩl mʋ Yesu lee a magɩsɩ ʋ, a bara kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba kpa ko ʋ lee a basɩ tɩya ʋ a baa, “Á nɩhɩyawʋ, á gyɩma anɩɩ ɩ kaŋ wɩtɩɩ rɛ. Ɩ sɩya tuwo nal tɩyaŋ. Ɩ bee fá nɩbal buloŋ sɩɩ. Ɩ aa daga Wɩɩsɩ ŋmanɩɩ tɩɩ rɛ. Yaŋ daga tɩya ma, ʋ yaa ŋmanɩɩ rɛ dɩ á tuŋ lampoo kɩ tɩya Roma paalʋʋ kuworibal hʋ ba aa yɩrɩ Siiza? Ʋ maga dɩ á tuŋ kɩ tɩya ʋ rɛ koo á ta tuŋ kɩ tɩya ʋ?” ");
INSERT INTO sig_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amɛ Yesu gyɩ gyɩma anɩɩ ba paala rɛ a basɩ. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ magɩsɩ ŋ nyɛ? Ma kaŋ molbinʋʋ hʋ kɩdɩgɩ ko dɩ ŋ na.” ");
INSERT INTO sig_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba kpa kɩdɩgɩ tɩya ʋ. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Aŋnɛ nyuu bee ʋ feŋ nɛ ba kpaa biŋ molbii hʋ tɩyaŋ nyɛ?” Ɛɛ rɛ ba baa dɩ Roma paalʋʋ kuworibal hʋ nyuu abee ʋ feŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ʋ yaŋ basɩ tɩya ba baa, “Ɛɛ kɛ, kɩŋ hʋ aa yaa Roma paalʋʋ kuworibal hʋ kɩŋ, ma kpa tɩya ʋ, kɩŋ mɛ aa yaa Wɩɩsɩ kɩŋ, ma kpa tɩya Wɩɩsɩ.” Yesu aa basɩ nyɛ, ba yaa kyʋra. Doŋ nɛ ba lem-ʋ aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɛɛ rɛ nala hʋ badɔmɔŋ ba aa yɩrɩ Sadusiima mɛ ko Yesu lee. Sadusiima fa bɩ laa di anɩɩ dɩ nal lɛ sʋba, ʋ sɩ bɩl sii sʋʋ tɩyaŋ. Ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, ");
INSERT INTO sig_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Á Tɩɩna, Moosi saba Wɩɩsɩ Teŋ tɩyaŋ anɩɩ dɩ baal lɛ kpaa haaŋ, dɩ ʋ bee haaŋ hʋ bɩ lʋl biye ka dɩ baal hʋ sʋba, dɩ ʋ maga dɩ ʋ naabiye kpa haaŋ hʋ rɛ, a lʋl biisi tɩya ʋ maana hʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nɩmmabalɩya bapɛ rɛ gyɩ we doŋ. Ba buloŋ gyɩ yaa baala rɛ, a fa yaa hadɩgɩ bee badɩgɩ balɩya. Ba nɩhɩyawʋ tɩɩna kpaa haaŋ. Ʋ bee haaŋ hʋ bɩ lʋl biye ka ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ʋ katɩyal kpa haaŋ hʋ. Ʋ beel-ʋ mɛ bɩ lʋl biye, ka ʋ mɛ sʋba. Too hʋ tɩɩna mɛ kpa haaŋ hʋ. Ʋ mɛ gɛɛ tɩɩtɩɩ puu ʋ. ");
INSERT INTO sig_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɩmmabalɩya hʋ bapɛ buloŋ nɛ kpaa haaŋ hʋ, ka ʋ bee ba kɩdɩgɩ buloŋ bɩ lʋla. Ɛɛ hal tɩyaŋ nɛ haaŋ hʋ mɛ sʋba. ");
INSERT INTO sig_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tɔɔ, kyɛɛ hʋ nala aa sɩ sii sʋʋ tɩyaŋ, baala no bapɛ tɩyaŋ, ba kɩbee rɛ sɩ tɩŋ haaŋ hʋ? Beewɩya ba bapɛ hʋ buloŋ nɛ ʋ yala?” ");
INSERT INTO sig_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma bɩ gyɩŋ Wɩɩsɩ teŋ, a bɩl bɩ gyɩŋ Wɩɩsɩ dee mɛ. Ɛɛ rɛ tɩŋ ma nyʋgɩsɩ nyɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kyɛɛ hʋ nala aa sɩ sii sʋʋ tɩyaŋ, baala bɩl bɩ sɩ paa haana, haana mɛ bɩl bɩ sɩ yal balama. Ba buloŋ sɩ kɩɩ gɛɛ nɩɩ malɩkasɩ aa we wɩɩsɩbee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Na ma aa pɩyɛsɩ ŋ nala aa sɩ sii sʋʋ tɩyaŋ wɩya rɛ. Ma bɩ karɩma wɩya hʋ Moosi aa saba Wɩɩsɩ teŋ tɩyaŋ, lee hʋ ʋ fa aa basa tɩɩpuso hʋ aa di diŋ hʋ wɩya? Wɩɩsɩ basɩ tɩya ʋ rɛ a baa dɩ ʋ rɛ yaa Wɩɩsɩ hʋ Abɩraham abee Azɩkɩ abee Gyeekɔbɩ gyɩ aa tɩŋa. ");
INSERT INTO sig_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wɩɩ no ʋ aa basa, ʋ memii rɛ yaŋ yaa bee? Ʋ daga anɩɩ Abɩraham abee Azɩkɩ abee Gyeekɔbɩ ha we ba mɩɩbol tɩyaŋ nɛ Wɩɩsɩ kɛ lee. Wɩɩsɩ bɩ yaa sʋʋnɩ Wɩɩsɩ. Ʋ yaa niweye Wɩɩsɩ rɛ. Ma bɩ gyɩŋ wɩɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wɩɩsɩ Teŋ dɩdagɩl kɩdɩgɩ aa nɩɩ dɩ ba kaŋ wɩɩ hʋ kɩ ŋmaa nyʋʋtaaduwo gɛɛ, ʋ mɛ kpa ko ba lee. Ʋ aa naa dɩ Yesu lɩɩ wɩɩ hʋ sɩɩ weliŋ gɛɛ, ʋ pɩyɛsɩ ʋ a baa, “Wɩɩsɩ mɩrɩsɩ hʋ ʋ aa biŋ tɩya nala dɩ ba kɩ tɩŋa, ba tɩyaŋ kɩbee rɛ yaa wɩbal?” ");
INSERT INTO sig_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu basɩ tɩya ʋ a baa, “Ba basɩ tɩya Iziral nala rɛ a baa, ‘Iziral nala, ma gyegile nɩɩ ŋ taal. Á Tɩɩna Wɩɩsɩ dʋŋ nɛ we doŋ. ");
INSERT INTO sig_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kyo ɩ Tɩɩna Wɩɩsɩ abee ɩ bembii buloŋ, abee ɩ tɩya buloŋ, abee ɩ dee buloŋ, abee ɩ tɩbɩɩna buloŋ.’ Wɩɩ no rɛ yaa ba buloŋ tɩyaŋ wɩbal. ");
INSERT INTO sig_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wɩlɩya tɩɩna mɛ rɛ nyɛ, ‘Kyo ɩ dɔŋtɩɩna anɩɩ ɩ aa kyo ɩ tɩɩ gɛɛ.’ Wɩɩsɩ mɩrɩsɩ hʋ buloŋ lɩɩ wɩya no balɩya tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩl hʋ basɩ tɩya ʋ a baa, “Á Tɩɩna, wɩtɩɩ rɛ ɩ basɩ. Wɩɩsɩ dʋŋ nɛ we doŋ, kɩŋ buloŋ bɩl tuwo, see Wɩɩsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ɩ aa sɩ kaŋ ɩ bembii buloŋ, abee ɩ tɩbɩɩna buloŋ, abee ɩ wɩɩ wɩɩ buloŋ a kyo Wɩɩsɩ, a kyo ɩ dɔŋtɩɩna mɛ anɩɩ ɩ aa kyo ɩ tɩɩ gɛɛ, ʋ rɛ kpɩya ɩ aa sɩ kaŋ pʋsɩ kpʋ a fisi ba buloŋ tɩya Wɩɩsɩ, koo ɩ aa kpaa kɩna a lɩɩ wɩɩsʋlɩɩ tɩya Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu aa naa dɩ baal hʋ lɩɩ wɩɩ hʋ sii abee wɩgyʋŋ gɛɛ, ʋ basɩ tɩya ʋ a baa, “Ɩ bee Wɩɩsɩ koro hʋ bɩ boliye.” Ʋ aa basɩ gɛɛ ko teŋ, nal buloŋ bɩl bɩ kaŋ nyʋwa ʋ aa sɩ pɩyɛsɩ ʋ wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ɛɛ rɛ Yesu bɩl kɩ daga nala Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ a pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ Wɩɩsɩ Teŋ dɩdagɩla hʋ baa dɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, sɩ yaa Deviti nihii? ");
INSERT INTO sig_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wiyesi Welii hʋ rɛ fa daga Deviti dɩ ʋ basɩ Krisita hʋ wɩya a baa, “Ŋ Tɩɩna Wɩɩsɩ basɩ tɩya ŋ Tɩɩna rɛ, ‘hɔŋ ŋ noduu logiŋ, a mʋ pele saŋa hʋ ŋ aa sɩ kpa ɩ dɔmɔ we ɩ nosi tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deviti tɩɩ yɩrɩ nal no ʋ Tɩɩna rɛ. Ɛɛ rɛ ʋ yaŋ sɩ yaa a yaa ʋ nihii dʋŋ?” Nɩgyamaa rɛ gyɩ gyegile a nɩɩ Yesu wɩbasɩɩ hʋ, ba tenni fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu bɩl daga ba a baa, “Ma pɔ ma tɩɩ weliŋ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ. Ba aa gɔllɩ we gyamaa tɩyaŋ nɛ abee ba gadoliye, a kɩ kyɛ dɩ nala kɩ tɩya ba gyɩrɩma aŋ kɩ kyʋwalɩ ba. ");
INSERT INTO sig_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba aa kɩ kyɛ nɩbala lɩhɔnɩya rɛ wɩɩkyʋwaldɩɩsɩ tɩyaŋ. Dɩ ba aa rɛ yɩrɩ ba laŋŋʋʋ tɩyaŋ buloŋ, ba aa kyo dɩ ba hɔŋ nɩbala lɩhɔnɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba aa fugo kyʋwalɩ Wɩɩsɩ kɩ pɩɩsɩ rɛ, aŋ kaŋ lohaana kɩna kɩ fasɩ. Saŋa hʋ tɩyaŋ Wɩɩsɩ aa sɩ di dʋnɩya sarɩya, ba aa rɛ sɩ na dɔgɩsɩɩ a te ba dɔŋtɩŋsɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu gyɩ mʋʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ, a mʋ hɔŋ kpaga lee hʋ nala aa kpa ba wɩɩsʋlɩɩ molbiye kɩ we, a kɩ deŋ gɛɛ hʋ ba aa we. Kɩna tɩmma hʋ ko kɩ we molbiye yʋga yʋga. ");
INSERT INTO sig_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɛɛ rɛ lohanyaabʋ kɩdɩgɩ mɛ ko, a mʋ kpa aniiniima balɩya a we, kobo rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ɛɛ rɛ Yesu yɩrɩ ʋ hatɩnna hʋ a basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, lohaaŋ no rɛ we molbii a te nal kɩdɩgɩ buloŋ daha, beewɩya ");
INSERT INTO sig_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","nala hʋ buloŋ aa kpaa molbiye a sʋla Wɩɩsɩ, ba lɩya aŋ ka rɛ. Amɛ ʋ kɛ dɩya bee ʋ bee buloŋ nɛ ʋ kaŋ mʋ we gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu aa lɩɩ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ ko dɩ ʋ lɩɩ, ʋ hatɩnna hʋ kɩdɩgɩ basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, na haŋ bʋbala hʋ ba aa kaŋ saa dɩya hʋ, ba weliye rɛ kɩŋkaŋ, lee hʋ buloŋ mɛ weliye.” ");
INSERT INTO sig_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ naa dɩya no aa yʋga gɛɛ rɛ. Amɛ ba sɩ ŋmaa ʋ buloŋ lo. Ba bɩ sɩ leŋ dɩ bʋdɩgɩ mɛ ka dɔbɔ ʋ dɔŋtɩɩna tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɛɛ rɛ ba sii mʋ gyɩŋ Olivi dogimo hʋ nyuu, a hɔŋ kyaasɩ Wɩɩkyʋwaldɩɩbal hʋ. Doŋ nɛ Piita abee Gyemsi, abee Gyɔɔŋ, abee Aŋduru, lʋwɔlɩ ko pɩyɛsɩ Yesu a baa, ");
INSERT INTO sig_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Saŋa bee tɩyaŋ nɛ wɩya no buloŋ sɩ yaa? Bekiŋ wɩɩ rɛ á sɩ na a daga anɩɩ wɩya no aa kyɛ ba yaa rɛ?” ");
INSERT INTO sig_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma gyɩŋ tɩya ma tɩɩ weliŋ dɩ nal buloŋ ta ko mʋrɩ ma. ");
INSERT INTO sig_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nɩgyamaa sɩ ko kpa ŋ feŋ anɩɩ ba aa rɛ yaa Krisita hʋ, a mʋrɩ nala yʋga. ");
INSERT INTO sig_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma sɩ nɩɩ bayuwo dɔmɔ ma paalʋʋ tɩyaŋ, a nɩɩ ʋ dɔmɔ liboliye tɩyaŋ mɛ. Amɛ dɩ mamaa rɛ ko nɩɩ ba gɛɛ, ma ta leŋ dɩ ʋ yaa ma beŋkyekpa. Wɩya no buloŋ sɩ yaa baŋ, amɛ dʋnɩya hʋ tenii ha daa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Paalʋʋ kɩdɩgɩ nala aa sɩ sii a mʋ yuwo paalʋʋ kɩdɩgɩ nala. Tɔɔ kɩdɩgɩ kuwori abee ʋ nala aa sɩ sii a mʋ yuwo kuwori kɩdɩgɩ mɛ abee ʋ nala. Taŋha sɩ gyigili leye yʋga tɩyaŋ. Losi mɛ sɩ gyʋʋ. Tʋwara no buloŋ kɩɩ gɛɛ nɩɩ haaŋ halʋllɩ-luwol aa piili kɩ wɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amɛ ma kaŋ ma tɩɩ weliŋ. Ba sɩ kaŋ ma mʋ leye hʋ ma paalʋʋ nɩhɩyasɩ aa laŋŋɩ kɩ vʋʋlɩ wɩya, dɩ ba di ma sarɩya. Ba sɩ ŋmaa ma Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ. Ma sɩ sɩŋ kuworo abee bee-nɩhɩyasɩ sɩya akuu ŋ wɩya, a di ŋ daŋsɩya. ");
INSERT INTO sig_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amɛ see dɩ ba laa sɩya basɩ Wɩɩsɩ wɩweliye hʋ tɩya nala aa we dʋnɩya paalʋʋsɩ buloŋ tɩyaŋ, aŋka dɩ dʋnɩya no na teŋ. ");
INSERT INTO sig_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dɩ ba aa rɛ ko kaŋ ma mʋ dɩ ba di ma sarɩya, ma ta leŋ dɩ ma bembiye kɩ sii abee wɩya hʋ ma aa sɩ basɩ a laa ma tɩɩ. Ɛɛ saŋa, Wɩɩsɩ rɛ sɩ kpa wɩgyʋŋ we ma nyuni tɩyaŋ. Wɩɩ hʋ kɛ buloŋ aa ko ko ma nyuu, ma basɩ. Ma tɩɩ daa sɩ basɩ, Wiyesi Welii hʋ rɛ sɩ kpa we ma nyuni tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nɩmmabalɩya sɩ kaŋ dɔmɔŋ mʋ tɩya dɩ ba kpʋ. Kuwoma mɛ sɩ yaa ba biisi gɛɛ tɩɩ. Biisi mɛ sɩ vɩya ba kuwoma abee ba nɩmma nyʋʋsɩ aŋ kaŋ ba mʋ tɩya dɩ ba kpʋ. ");
INSERT INTO sig_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nal buloŋ nɛ sɩ haasɩ ma, akuu ŋ wɩya. Amɛ, nal hʋ buloŋ aa sɩ kaŋ mala a mʋ teŋ, Wɩɩsɩ sɩ laa ʋ tɩɩna ta.” ");
INSERT INTO sig_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Dɩ ma ko na kɩbɔŋlɔrɩ hʋ aa yaa sɩna dɩ ʋ sɩŋ lee hʋ aa bɩ maga dɩ ʋ we. (Nal hʋ aa karɩmɩ wɩya no lʋga aŋ gyɩŋ ba memii.) Dɩ mamaa rɛ ko na gɛɛ, ma leŋ dɩ nala hʋ aa we Gyudɩya paalʋʋ tɩyaŋ fá mʋ gyɩŋ dogiŋsi nyuni a faŋa. ");
INSERT INTO sig_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dɩ nal buloŋ nɛ we salnyuu tɩyaŋ, aŋ nɩɩ wɩya no, ʋ ta bɩl lɔlɔ ʋ tɩɩ kɩ kyɛ dɩ ʋ tuu gyʋʋ dɩya paa ʋ kɩna. ");
INSERT INTO sig_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dɩ nal lɛ we baga tɩyaŋ aŋ nɩɩ wɩya no, dɩ ʋ ta mɩɩgɩ mʋ dɩya a kɩ kyɛ dɩ ʋ kpa ʋ gal. ");
INSERT INTO sig_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Haluwokanna abee biifɩllɩ nɩmma sɩ na tʋwara yʋga. ");
INSERT INTO sig_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ma kɩ sʋla Wɩɩsɩ dɩ wɩɩ no ta yaa puwo saŋa. ");
INSERT INTO sig_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Beewɩya Wɩɩsɩ aa mara dʋnɩya aa ko pele gyɩnaŋ, nal buloŋ ha bɩ naa tʋwara no dɔŋtɩɩna, nal mɛ bɩl bɩ sɩ na tʋwara gɛɛ a kaŋ kɩ mʋ maakyiye buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dɩ Wɩɩsɩ fa bɩ keri kyɛyɛ hʋ ta, nɩdɩgɩ mɛ fa bɩ sɩ ka. Amɛ nala hʋ Wɩɩsɩ aa lɩya dɩ ba tɩŋa ʋ wɩya rɛ tɩŋ ʋ keri kyɛyɛ hʋ ta. ");
INSERT INTO sig_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Dɩ nal buloŋ nɛ basɩ tɩya ɩ dɩ ɩ deŋ daha a na Krisita hʋ, koo dɩ ɩ deŋ doŋ a na ʋ, ta laa ʋ di. ");
INSERT INTO sig_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nala badɔmɔŋ sɩ sii mʋrɩ nala anɩɩ ba aa rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya. Badɔmɔŋ mɛ sɩ sii a mʋrɩ nala dɩ ba yaa Wɩɩsɩ tɩŋdaala rɛ. Ba sɩ yaa wɩmagɩla abee wɩkperiye a kɩ kyɛ dɩ ba mʋrɩ nala hʋ Wɩɩsɩ aa lɩya mɛ gba, a kaŋ ba hakɩllɩ vʋgɩmɩ. ");
INSERT INTO sig_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wɩya no buloŋ nɛ ŋ laa sɩya basɩ dɩ ŋ tɩya ma, ka dɩ saŋa hʋ na pele. Ma yaŋ gyɩŋ tɩya ma tɩɩ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Tʋwara no aa sɩ ko baŋ hal tɩyaŋ, lee buloŋ sɩ bɩrɩmɩ tebiŋ-bɩnɩɩ, dɩ sɩya bɩl bee gballɩ. Wɩɩsɩ bɩl bɩ sɩ pɔsɔ, pene mɛ bɩl bɩ sɩ pɔsɔ. ");
INSERT INTO sig_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kyɩŋwʋlɩya sɩ lɩɩ wɩɩsɩnyuu ko tuu kɩ tele. Ba sɩ kile wɩɩsɩnyuu kɩna hʋ buloŋ aa kaŋ dee dɩ ba lɩɩ ba liweeliye tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɛɛ tɩyaŋ nɛ ma sɩ na mɩyaŋ Nihuwobiŋ Biye, dɩ ŋ tɩŋ taala tɩyaŋ ko kɩ tuu abee gaŋdarɩ abee dee. ");
INSERT INTO sig_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɛɛ tɩyaŋ nɛ ŋ sɩ tɩŋ malɩkasɩ dɩ ba mʋ dʋnɩya logiŋ kɛ buloŋ a kaŋ nala hʋ buloŋ Wɩɩsɩ aa lɩya, a ko laŋŋɩ.” ");
INSERT INTO sig_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ma kpa tɩɩsɩ a gʋnnɩ wɩgyʋŋ! Dɩ ma ko na tɩɩsɩ piile kɩ tɔsɔ, ma aa gyɩma anɩɩ yʋʋ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɛɛ tɩɩ rɛ dɩ mamaa rɛ ko na wɩya no buloŋ aa yaa, ma gyɩma anɩɩ mɩyaŋ Nihuwobiŋ Biye koyi kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma lagɩlagɩ no nala aa we ma mɩɩbol tɩyaŋ buloŋ bɩ sɩ sʋba teŋ, ka dɩ wɩya no yaa. ");
INSERT INTO sig_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wɩɩsɩnyuu abee taŋha nyuu buloŋ sɩ teŋ, amɛ wɩya hʋ ŋ aa basa kɛ bɩ sɩ nyʋgɩsɩ maakyiye buloŋ.” ");
INSERT INTO sig_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Amɛ nal buloŋ bɩ gyɩŋ kyɛɛ hʋ wɩya no aa sɩ yaa. Malɩkasɩ aa we wɩɩsɩbee tɩyaŋ mɛ paalɩ bɩ gyɩma. Mɩyaŋ, Wɩɩsɩ Biye tɩɩ mɛ bɩ gyɩma, see ŋ Kuwo dʋŋ. ");
INSERT INTO sig_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ma gyɩŋ tɩya ma tɩɩ weliŋ, a yaa siri kɩ pɔ, beewɩya ma bɩ gyɩŋ kyɛɛ hʋ wɩya no aa sɩ yaa. ");
INSERT INTO sig_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ʋ kɩɩ gɛɛ rɛ anɩɩ baal aa siye a kɩ kyɛ dɩ ʋ vala ŋmanɩɩ. Dɩ ʋ ko kɩ kyɛ ʋ lɩɩ dɩya tɩyaŋ, ʋ aa daga ʋ tʋŋtʋnna kɩdɩgɩ buloŋ ba tʋma rɛ, aŋ basɩ tɩya nal hʋ aa pɔ dimbee mɛ dɩ ʋ pɔ dɩya hʋ weliŋ, dɩ ʋ mʋ aŋ ko. ");
INSERT INTO sig_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ma yaŋ kɩ pɔ, beewɩya ma bɩ gyɩŋ kyɛɛ hʋ dɩya hʋ tɩɩna aa sɩ mɩɩgɩ ko, dɩ dɩdaana rɛɛ, dɩ tekere rɛɛ, dɩ sɩgballɩnyʋwa rɛɛ, koo dɩ kyɩkyʋwala rɛɛ, ma bɩ gyɩma. ");
INSERT INTO sig_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma gyɩŋ tɩya ma tɩɩ weliŋ aŋ kɩ pɔ dɩ ʋ ta ko pirigi ma tɩyaŋ dɩ ma aa pɩŋ doo. ");
INSERT INTO sig_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wɩɩ hʋ ŋ aa basɩ kɩ tɩya ma, ʋ rɛ ŋ basɩ kɩ tɩya nal buloŋ, ma pɔ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kyɛyɛ balɩya rɛ fa kaa ka dɩ Dɩɩsɩ parɩ-banɩɩ kyɛbal hʋ fa pele. Kyɛɛ no rɛ ba aa kyaŋ paanʋʋ hʋ ba aa bɩ wee sɩbʋl. Ɛɛ rɛ wɩɩkyʋwal sɩlaala hʋ abee Wɩɩsɩ Teŋ dɩdagɩla kɩ kyɛ ŋmanɩɩ dɩ ba lʋwɔlɩ kaŋ Yesu kpʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amɛ ba mɩɩgɩ vʋʋlɩ dɩ ba ta kana ʋ ba kyɛbal hʋ kyɛɛ, beewɩya dɩ ba aa rɛ yaa gɛɛ nala hʋ sɩ laa taawɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nyɛ rɛ Yesu sii mʋ Bɛɛtani a gyʋʋ hɔŋ Siimɔŋ dɩyaŋ a kɩ di kɩna. Siimɔŋ gyɩ yaa gbegi-werisi rɛ. Ʋ aa di kɩna hʋ tɩyaŋ nɛ dɩ haaŋ kɩdɩgɩ kaŋ tʋranɩɩ bee pʋrʋŋtʋwa ko gyʋʋ. Tʋranɩɩ hʋ sʋwala gyɩ sʋma rɛ weliŋ, ka ʋ yalɩɩ mɛ hayɛ. Nyɛ rɛ haaŋ hʋ kaŋ pʋrʋŋtʋwa hʋ nyʋwa suri, a bɩsɩ tʋranɩɩ hʋ we Yesu nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɛɛ rɛ nala hʋ badɔmɔŋ hɔŋ kɩ gʋrɩmɩ wɩya, aŋ kɩ pɩyɛsɩ dɔmɔŋ a baa, “Bee rɛ tɩŋ haaŋ no kaŋ tʋranɩɩ no kyogi ta nyɛ? ");
INSERT INTO sig_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dɩ ba aa rɛ fa ta kpa tʋranɩɩ no yallɩ, ʋ fa sɩ yaa mogyamaa, dɩ ba fa kpa tɩya nyaaba.” Nyɛ rɛ ba sii kɩ basɩ haaŋ hʋ wɩya abee baaŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma leŋ haaŋ hʋ bee laaŋfɩya. Bee rɛ tɩŋ ma kɩ dɔmɔ ʋ gɛɛ? Wɩwelii rɛ ʋ yaa tɩya ŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ma bee nyaaba sɩ we doŋ saŋa kɛ buloŋ. Saŋa hʋ buloŋ dɩ mamaa rɛ aa kyɛ ma yaa wɩwelii tɩya ba, ma sɩ wuwo yaa. Amɛ ŋ beel-ma kɛ bɩ sɩ we doŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Haaŋ hʋ yaa kuwokeri rɛ. Ʋ yaa wɩɩ hʋ ʋ aa sɩ wuwo yaa rɛ. Ʋ tɩsɩ ŋ teŋ a kɩ pɔ saŋa hʋ ba aa sɩ hogo ŋ nɛ, dɩ ŋ ha bɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dʋnɩya logiŋ kɛ buloŋ ba aa sɩ mʋ basɩ Wɩɩsɩ wɩweliye hʋ, ba sɩ lɩɩ wɩɩ no haaŋ no aa yaa a basɩ.” ");
INSERT INTO sig_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ɛɛ rɛ Gyudasɩ Isɩkarɔtɩ aa yaa Yesu hatɩnna fi abee balɩya hʋ kɩdɩgɩ sii mʋ wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ lee dɩ ʋ kpa Yesu yallɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba aa nɩɩ gɛɛ, ba tenni fɩyɛlɩ. Ba baa dɩ ba sɩ tɩya ʋ molbiye. Doŋ tɩyaŋ nɛ Gyudasɩ sii piili kɩ kyɛ ŋmanɩɩ hʋ ʋ aa sɩ wuwo tɩŋa a kpa Yesu yallɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ba kyɛbal hʋ kyɛbuŋbuŋ kyɛɛ, ba aa dɩ paanʋʋ ba aa bɩ we sɩbʋl aŋ kpʋ piyese hʋ ba aa sɩ kaŋ yaa kyɛbal hʋ kɩdiiliye, Yesu hatɩnna hʋ pɩyɛsɩ ʋ a baa, “Lee rɛ ɩ kyo dɩ á mʋ yaa Dɩɩsɩ parɩ-banɩɩ kyɛbal hʋ kɩdiiliye?” ");
INSERT INTO sig_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɛɛ rɛ ʋ tɩŋ ʋ hatɩnna hʋ balɩya a basɩ tɩya ba a baa, “Ma mʋ gyʋʋ tɔɔ hʋ tɩyaŋ. Dɩ mamaa rɛ ko kɩ mʋ, ma sɩ kyeŋ baal kɩdɩgɩ dɩ ʋ kyʋŋ nɩɩvii bee nɩɩ. Ma tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dɩya hʋ buloŋ ʋ aa sɩ mʋ gyʋʋ, ma tɩŋa ʋ gyʋʋ, a basɩ tɩya dɩya hʋ tɩɩna a baa, ‘Á Tɩɩna baa dɩ á pɩyɛsɩ ɩ dɩ lee rɛ ɩ nɩhʋwala dɩya we, dɩ ʋ bee ʋ hatɩnna ko gyʋʋ hɔŋ di Dɩɩsɩ-parɩ-banɩɩ kyɛbal hʋ kɩdiiliye?’ ");
INSERT INTO sig_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ʋ sɩ daga ma dɩɩbal kɩdɩgɩ. Ʋ yaa salnyuu dɩya rɛ. Ba marɩ ʋ buloŋ nɛ. Doŋ nɛ ma sɩ yaa kɩdiiliye hʋ.”’ ");
INSERT INTO sig_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɛɛ rɛ ʋ hatɩnna hʋ sii lɩɩ a mʋ tɔɔ hʋ, a na wɩya hʋ buloŋ Yesu aa basɩ tɩya ba, dɩ ba yaa gɛɛ tɩɩ, ka ba yaa Dɩɩsɩ-parɩ-banɩɩ kyɛbal hʋ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wɩɩsɩ aa ko gyʋʋ, Yesu bee ʋ hatɩnna hʋ gyʋʋ hɔŋ a kɩ di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba aa di kɩna hʋ tɩyaŋ nɛ, Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma nala no aa di kɩna hʋ, ma kɩdɩgɩ rɛ sɩ kpa ŋ yallɩ. Ŋ beel-ʋ buloŋ nɛ laŋŋɩ kɩ di kɩna hʋ lagɩlagɩ no nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ba aa nɩɩ wɩɩ hʋ, ba tɩsɩ kyogi. Ba buloŋ kɩ pɩyɛsɩ ʋ kɩŋ kɩŋ a baa, “Mɩyaŋ nɛ?” ");
INSERT INTO sig_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu basɩ tɩya ba a baa, “Ma fi abee balɩya no kɩdɩgɩ rɛ, ŋ bee nal hʋ aa kyala kaŋ paanʋʋ tuu yuu gbaha hʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mɩyaŋ Nihuwobiŋ Biye, ŋ sɩ sʋba anɩɩ ba aa saba ŋ wɩya gɛɛ. Amɛ nal hʋ aa kpaa mɩyaŋ Nihuwobiŋ Biye yallɩ, ʋ sɩ na tʋwara yʋga. Ba fa aa bɩ lʋla ʋ rɛ kpɩya.” ");
INSERT INTO sig_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba aa hɔŋ kɩ di kɩna hʋ tɩyaŋ nɛ, Yesu kpa paanʋʋ a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kaŋ lɔgɔ lɔgɔ, a kpa tɩya ʋ hatɩnna hʋ, aŋ basɩ tɩya ba a baa, “Ma laa. Ŋ teŋbii rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ɛɛ rɛ ʋ bɩl kpa nɩɩnyʋwagbaŋbiye bee sɩŋ mɛ a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kpa tɩya ba, ba buloŋ nyʋwa nɩɩnyʋwagbaŋbiidɩgɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ka Yesu basɩ tɩya ba a baa, “Ŋ kyal lɛ gɛɛ. Kyal no rɛ Wɩɩsɩ kpa we nyʋʋfalɩɩ hʋ. Ŋ kyal sɩ gyaasɩ nɩgyamaa wɩya, dɩ Wɩɩsɩ kpa ba wɩbɔmɔ kyɛ ba. ");
INSERT INTO sig_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ŋ bɩl bɩ sɩ maakyiye nyʋwa sɩŋ no iriŋ a kaŋ kɩ mʋ kyɛɛ hʋ ŋ aa sɩ nyʋwa sɩfalɩɩ Wɩɩsɩ koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɛɛ rɛ ba yɩɩ wɩɩkyʋwal yɩɩl aŋ sii lɩɩ a mʋ gyɩŋ Olivi dogimo hʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ɛɛ rɛ Yesu basɩ tɩya ba baa, “Ma buloŋ sɩ fá aŋ ka ŋ. Beewɩya ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa dɩ Wɩɩsɩ sɩ kpʋ pedaal hʋ ka dɩ piyese hʋ fá pɩsa. ");
INSERT INTO sig_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amɛ Wɩɩsɩ sɩ kyisi ŋ sʋʋ tɩyaŋ. Dɩ mɩyaŋ nɛ ko sii, ŋ sɩ laa ma sɩya a mʋ Galili.” ");
INSERT INTO sig_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Dɩ ba buloŋ sɩ fá vɩya ɩ ta mɛ, ŋ kɛ bɩ sɩ maakyiye mɩɩgɩ ɩ hal.” ");
INSERT INTO sig_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ, gyɩnaŋ tebine no, ɩ Piita, ɩ sɩ tʋwa naaŋsɩɩnyʋwa bʋto anɩɩ ɩ bɩ gyɩma ŋ, ka dɩ gyibal na wii naaŋsɩɩnyʋwa bʋlɩya.” ");
INSERT INTO sig_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɛɛ rɛ Piita basɩ abee sɩfɩyasɩ baa, “Dɩ ŋ beel-ɩ sɩ paalɩ sʋba mɛ, ŋ bɩ sɩ laa nyʋwa baa ŋ bɩ gyɩma ɩ.” Nɩkaalɩya hʋ buloŋ mɛ basɩ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɛɛ rɛ ba mʋ gyʋʋ lee kɩdɩgɩ ba aa yɩrɩ Gesamani. Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma hɔŋ daha ka dɩ ŋ mʋ kyʋwalɩ Wɩɩsɩ aŋ ko.” ");
INSERT INTO sig_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka ʋ kaŋ Piita abee Gyemsi abee Gyɔɔŋ a mʋ doŋ. Yesu tɩya gyɩ kyogo rɛ kɩŋkaŋ, haalɩ ʋ hakɩla buloŋ gyarɩ. ");
INSERT INTO sig_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ŋ tɩya buloŋ nɛ kyogo, ŋ bembii kɩ kyɛ dɩ ʋ bori. Ma hɔŋ daha pɔ.” ");
INSERT INTO sig_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ba hɔŋ ka ʋ fasɩ mʋ sɩya mʋhʋ a tuu gbinni taŋha a sʋla Wɩɩsɩ a baa, “Saŋa hʋ pele rɛ, amɛ ɩ dee tɩyaŋ, leŋ dɩ tʋwara no parɩ ŋ mʋ.” ");
INSERT INTO sig_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A bɩl baa, “Ŋ Kuwo, ɩ wuwo kɩ yaa wɩɩ buloŋ nɛ. Lɩɩ tʋwara no aa sɩ ko ŋ tɩyaŋ. Amɛ, ŋ kyɛrɩ tɩyaŋ daa, ɩ kyɛrɩ tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ʋ kyʋwalɩ Wɩɩsɩ hʋ teŋ aŋ sii ko ʋ hatɩnna hʋ lee, dɩ ba pɩŋ doo. Ɛɛ rɛ ʋ pɩyɛsɩ Piita a baa, “Ɩ pɩna rɛ? Ɩ bɩ sɩ wuwo bara doo mʋhʋ anɩɩ hawadɩgɩ mɛ? ");
INSERT INTO sig_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma kɩ kyʋwalɩ Wɩɩsɩ, a kɩ pɔ dɩ Sɩtaanɩ ta wuwo mʋrɩ ma. Ma tɩsɩ tɩyaŋ ma kyo dɩ ma aa yaa wɩweliye rɛ, amɛ ma bɩ kaŋ gɛɛ dee ma tɩɩ.” ");
INSERT INTO sig_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ʋ bɩl mʋ a kyʋwalɩ Wɩɩsɩ, a bɩl basɩ gɛɛ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ʋ mɩɩgɩ kɩ ko dɩ ba bɩl pɩŋ doo, beewɩya doo gyɩ kaŋ ba rɛ weliŋ. Ba bɩ gyɩŋ ba aa sɩ basɩ wɩɩ hʋ buloŋ a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ʋ mɩɩgɩ mʋ tootɩɩna aŋ ko pɩyɛsɩ ba a baa, “Ma ha pɩŋ kɩ wiyesi rɛ? Ʋ maga rɛ. Ma sii, saŋa hʋ pele rɛ. Ba sɩ kaŋ mɩyaŋ Nihuwobiŋ Biye a mʋ tɩya wɩbɔŋyaala. ");
INSERT INTO sig_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ma sii dɩ á mʋ. Ma na! Nal hʋ aa sɩ kpa ŋ yallɩ rɛ aa ko.” ");
INSERT INTO sig_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu aa basɩ gɛɛ ʋ nyʋwa ha bɩ tele taŋha dɩ Gyudasɩ rɛ mʋ kɩ ko gɛɛ. Ʋ fa yaa Yesu hatɩnna fi abee balɩya hʋ kɩdɩgɩ rɛ. Nɩgyamaa gyɩ giri kɩ tɩŋa ʋ hal. Badɔmɔŋ kolo takoobiye abee daŋgulo. Wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla abee ba bee-nɩhɩyasɩ rɛ gyɩ tɩŋ ba, ba ko. ");
INSERT INTO sig_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Minaafigi tɩɩna hʋ gyɩ tɩya nala hʋ magɩl lɛ a baa, “Nal hʋ ŋ aa sɩ mʋ guwori, ʋ rɛ gɛɛ. Ma gurigi ʋ kɩ mʋ.” ");
INSERT INTO sig_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gyudasɩ aa pele lee hʋ Yesu aa we, ʋ degini ʋ lee mʋ aŋ baa, “Ŋ nɩhɩyawʋ,” aŋ guwori ʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba buloŋ giri ko kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nala hʋ aa sɩŋ doŋ ba kɩdɩgɩ lɩɩ ʋ takoobii, a ŋmaŋ nal kɩdɩgɩ dɩgɩŋ kyɔl. Nal hʋ dɩgɩŋ ba gyɩ aa ŋmaŋ kyɔl hʋ fa yaa wɩɩkyʋwal sɩlaala nɩhɩyawʋ dɩya yoŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ŋ yaa biibɔŋ nɛ, ma kol takoobiye abee daŋgulo a kɩ ko dɩ ma kana ŋ? ");
INSERT INTO sig_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na kyɛɛ kɛ buloŋ nɛ ŋ beel-ma aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ŋ kɩ daga ma Wɩɩsɩ wɩya, aŋka ma bɩ lʋga dɩ ma kana ŋ doŋ. Amɛ ŋ wɩya hʋ buloŋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ, see ba buloŋ aa yaa.” ");
INSERT INTO sig_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɛɛ rɛ ʋ hatɩnna hʋ buloŋ vɩya ʋ ta aŋ fá. ");
INSERT INTO sig_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka bapʋwasɩɩ kɩdɩgɩ mɛ aa baasɩ ʋ wagyɛ a kɩ tɩŋa Yesu hal, ba kɩ lʋga dɩ ba kana ʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ɛɛ rɛ ʋ wuri ʋ wagyɛ hʋ ta aŋ kaŋ teŋbil a fá nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba gyɩ kaŋ Yesu mʋ wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ dɩya rɛ. Ba aa ko doŋ dɩ wɩɩkyʋwal sɩlaala nɩhɩyasɩ, abee ba wɩɩkyʋwaldɩya nɩhɩyasɩ, abee Wɩɩsɩ Teŋ dɩdagɩla buloŋ laŋŋa. ");
INSERT INTO sig_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ba aa kana ʋ kɩ mʋ gɛɛ, ka Piita lʋwɔlɩ kɩ tɩŋ ba hal a mʋ gyʋʋ wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ gyaŋwuwo. Ʋ gyʋwa dɩ nala hʋ aa pɔ gyaŋwuwo hʋ hɔnɔ a kɩ wiyeni diŋ. Ʋ mɛ mʋ pɛ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɛɛ rɛ dɩ wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ abee nɩkaalɩya hʋ buloŋ laŋŋa kɩ vʋʋlɩ wɩya, a kɩ kyɛ dɩ ba na wɩɩ hʋ Yesu aa yaa kyogi, a maga dɩ ba kpʋ ʋ. Aŋ kyɛ kyɛ wɩɩ lɔlɔ. ");
INSERT INTO sig_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɩgyamaa gyɩ nyɩya wɩya tɩya ʋ rɛ. Amɛ ba buloŋ gyɩ aa basɩ nyʋʋlɩyaba rɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɛɛ rɛ nala badɔmɔŋ sii sɩŋ a nyɩya wɩya kɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Á nɩɩ dɩ baal no baa dɩ ʋ sɩ ŋmaa Wɩɩkyʋwaldɩɩbal hʋ nala aa saa a lo, aŋ bɩl wuwo saa kɩdɩgɩ kyɛyɛ boto bʋwaŋ ʋ dʋŋ bee ʋ dʋŋ.” ");
INSERT INTO sig_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amɛ ba mɛ ha gyɩ basɩ wɩya kɩ bɩ dɔmɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɛɛ rɛ wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ sii lɩɩ sɩŋ nala hʋ tʋtʋʋ tɩyaŋ a pɩyɛsɩ Yesu a baa, “Ɩ bɩ nɩɩ nala no aa basɩ ɩ wɩya mɔɔ gɛɛ? Ɩ kɛ bɩ kaŋ wɩɩ ɩ aa sɩ basɩ?” ");
INSERT INTO sig_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ɛɛ rɛ Yesu tallɩ ʋ nyʋwa a bɩ laa wɩɩ buloŋ basɩ. Ɛɛ rɛ baal hʋ bɩl pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa Krisita, laataal hʋ Wɩɩsɩ aa lɩya? Ɩ rɛ yaa Wɩɩsɩ Biye hʋ?” ");
INSERT INTO sig_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ɛɛ rɛ Yesu baa, “Mɩyaŋ nɛ. Ma sɩ na mɩyaŋ Nihuwobiŋ Biye, dɩ ŋ hɔŋ Wɩɩsɩ noduu logiŋ lɩhɔnɩɩ, a tɩŋ taala tɩyaŋ a ko kɩ tuu.” ");
INSERT INTO sig_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ʋ aa basɩ gɛɛ, baal hʋ kaŋ ʋ tɩɩ gannɩ kɩyɛsɩ aŋ baa, “Ʋ bɩ maga dɩ a bɩl kɩ kyɛ daŋsɩya tɩmma. ");
INSERT INTO sig_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma buloŋ nɩɩ ʋ aa tʋʋsɩ Wɩɩsɩ gɛɛ rɛ? Ɛɛ rɛ ma na?” Ɛɛ rɛ nala hʋ buloŋ baa dɩ ʋ kyogo rɛ, a maga dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Badɔmɔŋ sii, a tʋ naŋtʋwɔl we ʋ sɩya tɩyaŋ, aŋ vʋwa ʋ sɩya tɔ, aa ŋmaa ʋ, aŋ pɩyɛsɩ ʋ dɩ ʋ daga nal hʋ aa ŋmaa ʋ. Ɛɛ hal tɩyaŋ nɛ ba kana ʋ mʋ tɩya laalyuwolo hʋ, ba mɛ ŋmaa ʋ kyaŋkpaŋa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piita aa hɔŋ gyaŋwuwo hʋ tɩyaŋ gɛɛ rɛ, wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ dɩya tʋŋtʋnnɩ-toluu kɩdɩgɩ ko lɩɩ ");
INSERT INTO sig_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a na Piita dɩ ʋ hɔŋ kɩ wiyeni diŋ hʋ. Ʋ deŋ ʋ weliŋ aŋ basɩ tɩya ʋ a baa, “Ɩ mɛ fa aa tɩŋ Yesu aa lɩɩ Nazarɛti hal lɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piita tʋwa a baa, “Ŋ bɩ gyɩŋ wɩɩ hʋ ɩ aa basɩ tɩyaŋ,” aŋ sii lɩɩ sɩŋ paganyʋwa hʋ tɩyaŋ dɩ gyibalbuŋ wiye. ");
INSERT INTO sig_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Piita aa sɩŋ doŋ ɛɛ rɛ tʋŋtʋnnɩ toluu hʋ bɩl na ʋ a basɩ tɩya nala hʋ aa sɩŋ kpaga ʋ a baa, “Baal no mɛ yaa Yesu hatɩnna hʋ kɩdɩgɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piita bɩl tʋwa a baa dɩ ʋ daa. Mʋhʋ sʋwaa, dɩ nala hʋ aa sɩŋ doŋ mɛ basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ, ɩ mɛ yaa ba kɩdɩgɩ rɛ, ɩ lɩɩ Galili rɛ.” ");
INSERT INTO sig_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɛɛ rɛ Piita kaabɩ tɩya ʋ tɩɩ, aŋ ŋmɩyɛsɩ a baa, “Ŋ bɩ gyɩŋ baal no ma aa dagɩ.” ");
INSERT INTO sig_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ʋ aa basɩ gɛɛ teŋ dɩ gyibal wiye ʋ lɩya tɩɩna. Piita liisi wɩɩ hʋ Yesu aa basɩ tɩya ʋ anɩɩ ʋ sɩ tʋwa ʋ naaŋsɩɩnyʋwa bʋto, ka dɩ gyibal na wii naaŋsɩɩnyʋwa bʋlɩya. Ɛɛ rɛ ʋ kaŋ ʋ nyuu gʋra a wii weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ʋ sɩgballɩya kyɩkyʋwala pipi, wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ, abee bee nɩhɩyasɩ, abee Wɩɩsɩ Teŋ dɩdagɩla, abee nala hʋ buloŋ aa laŋŋɩ kɩ vʋʋlɩ wɩya, ba buloŋ nɛ gyɩ ko laŋŋɩ a vʋʋlɩ gɛɛ hʋ ba aa sɩ yaa Yesu. Ɛɛ hal tɩyaŋ nɛ ba kana ʋ vʋwa, aŋ kana ʋ mʋ Pilato lee. ");
INSERT INTO sig_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ɛɛ rɛ Pilato pɩyɛsɩ Yesu a baa, “Ɩ rɛ yaa Gyuuma kuwori hʋ?” Yesu basɩ tɩya ʋ a baa, “Waa, ɛɛ rɛ ɩ tɩɩ basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɛɛ rɛ wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ daga wɩya yʋga ba aa baa dɩ Yesu yaa kyogi, ka ʋ bɩ laa wɩɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ɛɛ rɛ Pilato bɩl pɩyɛsɩ Yesu a baa, “Ɩ bɩ kaŋ wɩɩ buloŋ ɩ aa sɩ basɩ tɩya ba? Deŋ na wɩya mɔɔgɛɛ ba baa dɩ ɩ kyogo.” ");
INSERT INTO sig_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amɛ Yesu bɩl bɩ suri ʋ nyʋwa. Wɩɩ hʋ kperi Pilato. ");
INSERT INTO sig_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dɩ Dɩɩsɩ-parɩ-banɩɩ kyɛbal hʋ rɛ ko pele buloŋ, Pilato aa lɩɩ nala ba aa kaŋ tɔ dɩyaŋ kɩdɩgɩ rɛ a ta, nal hʋ nala hʋ aa kyɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nala badɔmɔŋ gyɩ kaa kasɩ rɛ a kpʋ nala, ba gyɩ kasɩ tɔ dɩyaŋ. Ba kɩdɩgɩ feŋ nɛ yaa Barabaasɩ. ");
INSERT INTO sig_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɛɛ rɛ nala hʋ yʋga sii giri mʋ Pilato lee a baa dɩ ʋ yaa gɛɛ hʋ ʋ aa yaa kɩ tɩya ba saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilato gyɩ gyɩma anɩɩ wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ tɩya aa hɔllɩ Yesu rɛ, ɛɛ rɛ tɩŋ ba kana ʋ ko ʋ lee. Ɛɛ rɛ ʋ pɩyɛsɩ nala hʋ baa, “Ma aa kyɛ dɩ ŋ lɩɩ Gyuuma kuwori hʋ rɛ tɩya ma?” ");
INSERT INTO sig_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɛɛ rɛ wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ mʋrɩ nala hʋ we anɩɩ ba leŋ ba lɩɩ Barabaasɩ ta, aŋ leŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɛɛ rɛ Pilato bɩl pɩyɛsɩ nala hʋ baa, “Aŋka baal hʋ ma aa yɩrɩ Gyuuma kuwori hʋ, bee rɛ ma baa ŋ yaa ʋ?” ");
INSERT INTO sig_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɛɛ rɛ ba buloŋ nɔsɩ yʋga a baa, “Kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ɛɛ rɛ Pilato pɩyɛsɩ ba a baa, “Bekiŋ wɩbɔŋ nɛ ʋ yaa?” Ɛɛ rɛ ba marɩ nɔsɩ yʋga a baa, “Kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato gyɩ aa kyɛ dɩ ʋ yaa nala hʋ wɩkyɛɛlɩɩ wɩya, ʋ lɩɩ Barabaasɩ ta aŋ leŋ ba vɩɩrɩ Yesu aŋ baa dɩ ba kana ʋ mʋ kpaasɩ mal daagarɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɛɛ rɛ laalyuwolo hʋ kana ʋ lɩɩ ba kuworibal hʋ gyaŋwuwo tɩyaŋ, a yɩrɩ ba laalyuwolo buloŋ ko laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɛɛ rɛ ka ba kpa gafɩyaŋ a laalɩ ʋ, a kyɛ sɔsɩ a kaŋ sʋwa nyupugi, ʋ kɩɩ kuwori nyupugi gɛɛ, ba kpa kyige ʋ. ");
INSERT INTO sig_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ka ba aa tuu gbinni ʋ sɩya, a yaa ʋ sɩya a baa, “Gyuuma kuwori, Wɩɩsɩ sɩ tɩya ɩ mɩɩbodolii!” ");
INSERT INTO sig_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba kpa kyapɩya a vɩɩrɩ ʋ nyuu tɩyaŋ, a tʋ naŋtʋwɔl we ʋ tɩyaŋ, a tuu gbinni, a tɩya ʋ gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba aa yaa ʋ sɩya hʋ ko teŋ, ba wuri gafɩyaŋ hʋ aŋ paa ʋ tɩɩ gannɩ laalɩ ʋ, a kana ʋ lɩɩ ŋmanɩɩ dɩ ba kana ʋ mʋ kpaasɩ daagarɩɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba aa ko kɩ lɩɩ hʋ tɩyaŋ nɛ ba kyeŋ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ, a lɩɩ Sariini. Ʋ rɛ fa yaa Alizaŋda abee Rufusi kuwo. Dɩ ʋ lɩɩ baga a kɩ ko bee. Ba kana ʋ, a fɩla ʋ, ʋ laa daagarɩɩ hʋ baasɩ. ");
INSERT INTO sig_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba gyɩ kaŋ Yesu mʋ lee kɩdɩgɩ rɛ, ba kɩ yɩrɩ doŋ Golgota. (Golgota memii rɛ yaa Nyukuŋkogilo.) ");
INSERT INTO sig_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba aa ko pele doŋ, ba kpa musa kɩdɩgɩ ba aa yɩrɩ “mɩɩra” a we sɩŋ tɩyaŋ a tɩya ʋ dɩ nyʋwa. Ɛɛ rɛ ʋ vɩya. ");
INSERT INTO sig_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Haŋ saŋa hʋ dɩ wɩɩsɩ maga gyinyɛ, ba kana ʋ kpaasɩ mal daagarɩɩ hʋ tɩyaŋ. Aŋka ba kaŋ Yesu gannɩ kpaal wɩya kɩ yuwo gbaŋŋa, a kɩ kyɛ dɩ ba gyɩŋ gal hʋ nal buloŋ aa maga dɩ ʋ laa. ");
INSERT INTO sig_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba aa baa Yesu yaa wɩya hʋ kyogi, ba aa rɛ ba gyɩ sabɩ mal daagarɩɩ hʋ tɩyaŋ a baa, “Gyuuma kuwori hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Gaala balɩya mɛ rɛ ba gyɩ kpaasɩ pɛ Yesu tɩyaŋ. Kɩdɩgɩ we ʋ noduu dɩɩlaŋ, kɩdɩgɩ mɛ we ʋ nogɔbɔ dɩɩlaŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nyɛ leŋ wɩɩ hʋ ba aa saba Wɩɩsɩ Teŋ tɩyaŋ a baa dɩ ʋ bee gaala sɩ sʋba sʋʋdɩgɩ hʋ ko yaa wɩtɩɩ rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ba aa kpaasɩ ʋ mal daagarɩɩ hʋ tɩyaŋ gɛɛ, nala hʋ aa tɩŋ doŋ kɩ baŋ, ba kɩ tʋʋsɩ ʋ aŋ kaŋ ba nyuni kɩ kyugisi a baa, “Oyi, ɩ rɛ yaa nal hʋ aa baa dɩ ɩ sɩ ŋmaa Wɩɩkyʋwaldɩɩbal hʋ lo aŋ bɩl wuwo saa ʋ kyɛyɛ boto pagaŋ. ");
INSERT INTO sig_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ko tuu daagarɩɩ hʋ tɩyaŋ, a laa ɩ tɩɩ ta.” ");
INSERT INTO sig_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ mɛ kɩ huuri Yesu aŋ basɩ kɩ tɩya dɔmɔŋ a baa, “Ʋ wuwo laa nala kɩ ta rɛ, aŋ bɩ wuwo laa ʋ tɩɩ kɛ kɩ ta.” ");
INSERT INTO sig_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Ma leŋ Krisita hʋ, Gyuuma kuwori hʋ ko tuu daaŋ hʋ nyuu tɩyaŋ, dɩ á na a laa ʋ wɩya di.” Nala hʋ balɩya mɛ ba aa kpaasɩ pɛ Yesu tɩyaŋ mɛ gyɩ tʋʋsɩ ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wɩɩsɩ gyɩ aa ko maga nyutʋtʋʋ, lee buloŋ gyɩ bile gɛɛ rɛ a mʋ pele ʋ dɩdaana, ka lee bɩl kyaanɩ. ");
INSERT INTO sig_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ɛɛ rɛ Yesu nɔsɩ yɩrɩ ʋ taal tɩyaŋ a baa, “Ɛloyi, Ɛloyi, lama sabakitani.” Ʋ memii rɛ yaa, “Ŋ Tɩɩna Wɩɩsɩ, bee rɛ tɩŋ ɩ vɩya ŋ ta?” ");
INSERT INTO sig_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dɩ nala badɔmɔŋ mɛ sɩŋ doŋ a nɩɩ wɩɩ hʋ ʋ aa basa. Ɛɛ rɛ ba basɩ tɩya dɔmɔŋ a baa, “Na, Ilaagya rɛ ʋ kɩ yɩrɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nala hʋ kɩdɩgɩ fa aa sɩŋ doŋ mʋ kpa gbara a kaŋ mʋ yuu sɩkyaakyaa, a kpa vʋwa kaakelii tɩyaŋ, a kaŋ mʋ we ʋ nyʋwa tɩyaŋ dɩ ʋ nyʋwa. Ʋ aa yaa gɛɛ, ʋ baa, “Ma leŋ dɩ á gyegili na dɩ Ilaagya sɩ ko kana ʋ tuu daaŋ hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ɛɛ rɛ Yesu kyiyesi yʋga aŋ wiyesi ʋ wiyesi kateŋse. ");
INSERT INTO sig_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Patɩɩsa hʋ fa aa bori Wɩɩkyʋwaldɩɩbal hʋ kɩyɛsɩ balɩya. Ʋ sɩŋ ʋ nyuu tɩyaŋ nɛ a kɩyɛsɩ ko tuu ta. ");
INSERT INTO sig_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Laalyuwolo nɩhɩyawʋ kɩdɩgɩ fa aa sɩŋ pɔ Yesu aa naa gɛɛ ʋ aa kyiyese abee gɛɛ ʋ aa sʋba, ʋ baa, “Wɩtɩɩ, baal no rɛ kɔnɩ yaa Wɩɩsɩ Biye hʋ.” ");
INSERT INTO sig_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Haana badɔmɔŋ mɛ fa sɩŋ libolii rɛ a kɩ deŋ ʋ. Mɛɛrɩ Magidalina abee Salome fa we ba tɩyaŋ. Gyemsi abee Gyoose nɩɩna Mɛɛrɩ mɛ fa we doŋ. Ba fa kaŋ Gyemsi kɩ yɩrɩ bapʋwasɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Haana no buloŋ fa aa tɩŋ Yesu hal lɛ, a kɩ kyiyeli ʋ Galili tɩyaŋ. Haana hʋ mɛ fa aa tɩŋ Yesu hal a ko Gyerusalɛm, ba gyeniŋ buloŋ mɛ fa we doŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Haŋ kyɛɛ hʋ ba aa yaa siri pɔ ba Kyɛwiyesii hʋ kyɛɛ dɩdaana, baal kɩdɩgɩ aa lɩɩ Arimatɩya ba kɩ yɩrɩ Gyosɛfʋ, sii mʋ Pilato lee abee bembiduwo a sʋla Yesu teŋbii. Ʋ fa yaa ba bee nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya kɩdɩgɩ rɛ, nala kɩ tɩya ʋ gyɩrɩma. Ʋ mɛ fa aa gyegili Wɩɩsɩ koro hʋ koyi rɛ. ");
INSERT INTO sig_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato nyʋwa gyɩ fɩyɛla rɛ Yesu teŋ aa sʋba? Ɛɛ rɛ ʋ yɩrɩ laalyuwolo hʋ nɩhɩyawʋ a pɩyɛsɩ ʋ a baa, “Yesu teŋ sʋba rɛ?” ");
INSERT INTO sig_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Laalyuwolo hʋ aa basɩ tɩya Pilato dɩ Yesu sʋba rɛ, ʋ tɩya Gyosɛfʋ ŋmanɩɩ dɩ ʋ mʋ kpa Yesu teŋbii ko tuu taŋha. ");
INSERT INTO sig_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ɛɛ rɛ Gyosɛfʋ mʋ yɔbɔ liŋe a kaŋ mʋ we ʋ, a kpa ʋ hogo. Ʋ kana ʋ mʋ hogo bʋwa ba aa lurigo dabʋyɩ tɩyaŋ nɛ aŋ biliŋsi dabʋbal a tɔ bʋwa hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɛɛrɩ Magidalina abee Gyoose nɩɩna Mɛɛrɩ gyɩ we doŋ a na lee hʋ ba aa kpaa ʋ hogo. ");
INSERT INTO sig_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba Kyɛwiyesii hʋ kyɛɛ aa tene, Asibiti kyɛɛ dɩdaana rɛ gɛɛ, Mɛɛrɩ Magidalina abee Gyemsi nɩɩna Mɛɛrɩ abee Salome mʋ yɔbɔ tʋranɩɩ dɩ ba kaŋ mʋ tɩsɩ Yesu teŋbii. ");
INSERT INTO sig_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Alahadi kyɛɛ kyɩkyʋwala, wɩɩsɩ aa pɔsɔ ko kɩ gyɩŋ gɛɛ, ba sii mʋ Yesu bʋwa hʋ lee. ");
INSERT INTO sig_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba aa mʋʋ hʋ tɩyaŋ nɛ, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Aŋnɛ rɛ sɩ wuwo biliŋsi dabʋyɩ hʋ ta bʋwa hʋ nyʋwa?” ");
INSERT INTO sig_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɛɛ rɛ ba mʋ kpaga bʋwa hʋ lee dɩ ba naa dabʋyɩ hʋ suro bʋwa hʋ nyʋwa, a biliŋsi mʋ pɩŋ. Dabʋyɩ hʋ fa yʋga rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɛɛ rɛ ba mʋ gyʋʋ bʋwa hʋ tɩyaŋ, a na bapʋwasɩbiye dɩ ʋ hɔŋ bʋwa hʋ noduu tɩyaŋ a laalɩ gapʋlʋŋ dolii. Ba hirigi. ");
INSERT INTO sig_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma. Ŋ gyɩma anɩɩ Yesu aa lɩɩ Nazarɛti rɛ ma kɩ kyɛ, nal hʋ ba aa kpaasɩ mal daaŋ hʋ tɩyaŋ. Ʋ tuwo daha. Ʋ siye rɛ. Ma ko na lee hʋ ba aa kpaa ʋ hogo. ");
INSERT INTO sig_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma mʋ basɩ tɩya Piita abee Yesu hatɩnna hʋ anɩɩ ʋ sɩ laa ma sɩya a mʋ Galili. Dɩ mamaa rɛ mʋʋ doŋ, ma sɩ na ʋ doŋ anɩɩ ʋ aa basɩ gɛɛ tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ba hirigi, a kɩ kyele, aŋ sii lɩɩ bʋwa hʋ tɩyaŋ a fá. Kambɩŋ gyɩ kaŋ ba rɛ weliŋ, ba bɩ wuwo basɩ wɩɩ tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu gyɩ sii sʋʋ tɩyaŋ Alahadi kyɛɛ sɩgballɩnyʋwa rɛ. Ʋ aa siye, ʋ leŋ Mɛɛrɩ Magidalina rɛ laa sɩya na ʋ, nal hʋ tɩyaŋ ʋ gyɩ aa kile gyɩŋbɔmɔ bapɛ hʋ ta. ");
INSERT INTO sig_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɛɛ rɛ Mɛɛrɩ sii a mʋ basɩ tɩya Yesu hatɩnna hʋ wɩɩ hʋ aa yaa. Ʋ mʋwa dɩ ba hɔnɔ a kɩ wii. ");
INSERT INTO sig_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ɛɛ rɛ ʋ basɩ tɩya ba anɩɩ Yesu sii sʋʋ tɩyaŋ nɛ a we ʋ mɩɩbol tɩyaŋ, dɩ ʋ kɛ na ʋ rɛ. Ba aa nɩɩ wɩɩ hʋ, ba bɩ laa di. ");
INSERT INTO sig_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɛɛ hal tɩyaŋ nɛ, baala balɩya sii lɩɩ kpa ŋmanɩɩ a kɩ mʋ tɔɔ kɩdɩgɩ. Ba aa mʋʋ dɩ Yesu bɩrɩma, a bɩl bɩ kɩɩ ʋ fa aa kɩɩ gɛɛ, a kaŋ ʋ tɩɩ ko daga ba. ");
INSERT INTO sig_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɛɛ rɛ ba mɩɩgɩ ko basɩ tɩya Yesu hatɩnna nɩkaalɩya hʋ wɩɩ hʋ aa yaa. Amɛ ba bɩ laa di. ");
INSERT INTO sig_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɛɛ hal tɩyaŋ nɛ Yesu hatɩnna fi abee kɩdɩgɩ hʋ hɔŋ kɩ di kɩna. Ba aa di kɩna hʋ tɩyaŋ nɛ, dɩ Yesu rɛ gɛɛ. Ʋ nɔsɩ ba akuu ba aa bɩ laa ʋ di wɩya, abee ba bembiye aa deye wɩya, beewɩya ba bɩ laa nala hʋ mɛ a baa ba na ʋ dɩ ʋ sii sʋʋ tɩyaŋ di. ");
INSERT INTO sig_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ma mʋ dʋnɩya logiŋ kɛ buloŋ a basɩ Wɩɩsɩ wɩweliye hʋ a tɩya nal kɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nal hʋ buloŋ aa ko laa ŋ wɩya di, aŋ leŋ ba fo ʋ wɩɩkyʋwalnɩɩ, Wɩɩsɩ sɩ laa ʋ ta. Amɛ nal hʋ aa ko bɩ laa ŋ wɩya di, Wɩɩsɩ sɩ kpa kyogisi tɩya ʋ kyɛɛ hʋ ʋ aa sɩ di dʋnɩya nala buloŋ sarɩya. ");
INSERT INTO sig_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wɩmagɩla no rɛ ma sɩ na a gyɩŋ nala hʋ aa laa ŋ wɩya di. Ba aa rɛ nyɛ. Ba sɩ wuwo kɩ kile gyɩŋbɔmɔ ŋ dee tɩyaŋ. Ba sɩ wuwo kɩ basɩ taadʋŋsɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba sɩ wuwo kɩ kol dʋma, a nyʋwa daaluliye aa kpʋ nala, ka ʋ bɩ sɩ yaa ba wɩɩ buloŋ. Ba sɩ wuwo kpa ba nosi a dɔbɔ wɩɩla tɩmma tɩyaŋ dɩ ba deye.” ");
INSERT INTO sig_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Á Tɩɩna Yesu a basɩ wɩya no teŋ, Wɩɩsɩ kpa ʋ a kaŋ mʋ wɩɩsɩbee, ʋ hɔŋ Wɩɩsɩ noduu logiŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɛɛ rɛ ʋ hatɩnna hʋ sii lɩɩ a mʋ lee kɛ buloŋ a kɩ basɩ Wɩɩsɩ wɩya. Á Tɩɩna Wɩɩsɩ pɛ ba tɩyaŋ ba mʋ a kɩ yaa wɩmagɩla, dɩ nala gyɩma anɩɩ wɩya hʋ ba aa basɩ hʋ yaa wɩtɩɩ rɛ. Amɩ.");
INSERT INTO sig_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ŋ nɩhɩyawʋ Tiyofilɔsɩ, mɩyaŋ Luka rɛ sabɩ teŋ no a kɩ tɩya ɩ. Nala yʋga rɛ a yaa sɩfɩyaŋ, a sabɩ wɩya hʋ buloŋ aa yaa á sɩɩ tɩyaŋ a biŋ tenni tɩyaŋ. Wɩya hʋ buloŋ nala aa basɩ tɩya ma rɛ ba sabɩ biŋ. Ba kɛ naa wɩya no lipiilii buloŋ nɛ, aŋ mɛ ha pɛ basɩ Wɩɩsɩ wɩya kɩ tɩya nala. ");
INSERT INTO sig_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ŋ nɩhɩyawʋ, ŋ gyegile nɩɩ wɩya no buloŋ weliŋ nɛ, a gʋnnɩ ba buloŋ mɛ weliŋ a lɩɩ ba piilii tɩyaŋ buloŋ. Ɛɛwɩya, ŋ naa anɩɩ ʋ yaa wɩwelii rɛ dɩ ŋ sabɩ wɩya no buloŋ aa vala gɛɛ a tɩya ɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ŋ sabɩ kɩ tɩya ɩ rɛ dɩ ɩ gyɩma anɩɩ wɩya hʋ buloŋ ba aa daga ɩ hʋ kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Baal kɩdɩgɩ rɛ gyɩ we doŋ, ba kɩ yɩrɩ Zakarɩya. Ʋ gyɩ yaa Gyuuma wɩɩkyʋwal sɩlaala kɩdɩgɩ rɛ. Saŋa hʋ tɩyaŋ dɩ ba kaŋ Gyuuma wɩɩkyʋwal sɩlaala buloŋ kpaa kpaa rɛ. Nala hʋ tɩyaŋ ba gyɩ aa kpaa Zakarɩya we, Abigya rɛ gyɩ yaa ba nɩhɩyawʋ. Zakarɩya haaŋ mɛ feŋ nɛ gyɩ yaa Ɛlizabɛtɩ. Ʋ mɛ gyɩ lɩɩ Gyuuma wɩɩkyʋwal sɩlaala doho tɩyaŋ nɛ. Aarɔŋ yaa ʋ naabatuugo rɛ. Saŋa hʋ tɩyaŋ dɩ Hɛrɔtɩ rɛ gyɩ yaa Gyudɩya paalʋʋ buloŋ kuwori. ");
INSERT INTO sig_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakarɩya bee ʋ haaŋ buloŋ gyɩ yaa tɩpʋlʋŋ tɩmma rɛ Wɩɩsɩ sɩya tɩyaŋ. Ba buloŋ balɩya gyɩ aa tɩŋ Wɩɩsɩ nyʋwa rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɛlizabɛtɩ gyɩ yaa hapɩrɩ rɛ, a bɩ lʋl biye buloŋ, aŋka ʋ bee ʋ bala Zakarɩya buloŋ gyɩ hɩyasɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ɛɛ rɛ Zakarɩya bee ʋ nala kyɛɛ ko baŋ pele dɩ ba tʋŋ tʋma hʋ Gyuuma wɩɩkyʋwal sɩlaala aa kɩ tʋma saŋa buloŋ. Ɛɛ rɛ ba yuwo gbaŋŋa a lɩɩ Zakarɩya anɩɩ ba aa kɩ yaa gɛɛ saŋa buloŋ, ʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. Doŋ nɛ ʋ we diŋ a nyɔgɔ wɩsɩnaaŋ a tɩya Wɩɩsɩ, wɩɩsʋllɩ-kɩna kogu hʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ʋ aa gyʋwa hʋ tɩyaŋ nɛ, ka nɩgyamaa hʋ buloŋ aa ko dɩ ba lɩɩ wɩɩsʋlɩɩ hʋ mɛ sɩŋ gyaŋwuwo hʋ tɩyaŋ, a kɩ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Saŋa hʋ Zakarɩya gyɩ aa nyɔgɔ wɩsɩnaaŋ hʋ tɩyaŋ nɛ dɩ malɩka ko sɩŋ kogu hʋ noduu logiŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ʋ aa naa malɩka hʋ kambɩŋ kana ʋ, ʋ kɩ kyele. ");
INSERT INTO sig_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɛɛ rɛ malɩka hʋ basɩ tɩya ʋ a baa, “Zakarɩya, ta leŋ dɩ kambɩŋ kana ɩ. Wɩɩ hʋ ɩ aa sʋla Wɩɩsɩ kɩ kyɛ, Wɩɩsɩ laa ɩ sʋlɩɩ rɛ. Ɩ haaŋ Ɛlizabɛtɩ sɩ lʋl boyoŋbiye. Ɩ sɩ we ʋ feŋ Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɩ teŋ sɩ fɩyɛlɩ rɛ kɩŋkaŋ, dɩ nɩgyamaa tenni mɛ fɩyɛlɩ, ʋ lʋlɩɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ʋ sɩ yaa nɩbal Wɩɩsɩ sɩya tɩyaŋ. Ʋ bɩ sɩ kɩ nyʋwa sɩduwo koo sɩŋ buloŋ aa wiye. Dɩ ba ko lʋla ʋ, Wɩɩsɩ Wiyesi Welii hʋ sɩ we ʋ tɩyaŋ nɛ weliŋ a kaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ʋ sɩ leŋ dɩ Iziral tɩmma yʋga bɩl mɩɩgɩ ko kɩ tɩŋ ba Tɩɩna Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Biye no sɩ laa á Tɩɩna Wɩɩsɩ sɩya ko, dɩ Wɩɩsɩ tɩya ʋ dee anɩɩ ʋ gyɩ aa tɩya ʋ tɩŋdaal Ɛlaagya dee gɛɛ. Ʋ sɩ leŋ dɩ biisi abee ba kuwoma mɩɩgɩ sʋma. Ʋ mɛ sɩ leŋ dɩ nala hʋ aa bee tɩŋ Wɩɩsɩ nyʋwa bɩrɩmɩ ba hakɩllɩ a kaŋ tɩpʋlʋŋ, a leŋ dɩ Wɩɩsɩ nala marɩ ba tɩsɩ a yaa siri pɔ ba Tɩɩna koyi.” ");
INSERT INTO sig_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ɛɛ rɛ Zakarɩya pɩyɛsɩ malɩka hʋ a baa, “Ɛɛ rɛ ŋ sɩ yaa a gyɩma anɩɩ wɩya hʋ ɩ aa basɩ kɔnɩ yaa wɩtɩɩ rɛ? Beewɩya ŋ hɩyasa rɛ, ŋ haaŋ mɛ hɩyasɩ.” ");
INSERT INTO sig_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛɛ rɛ malɩka hʋ bɩl basɩ tɩya ʋ a baa, “Ŋ feŋ nɛ yaa Geebiral. Ŋ yaa Wɩɩsɩ tɩŋdaal lɛ. Ʋ rɛ tɩma ŋ dɩ ŋ ko basɩ wɩweliye no a tɩya ɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wɩya no ŋ aa basɩ kɩ tɩya ɩ kɔnɩ sɩ ko yaa, amɛ ɩ aa bɩ laa di nyɛ, ɩ bɩl bɩ sɩ wuwo basɩ wɩya a lɩɩ gyɩnaŋ a kaŋ kɩ mʋ kyɛɛ hʋ wɩya no aa sɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Saŋa hʋ malɩka hʋ gyɩ aa basɩ wɩya kɩ tɩya Zakarɩya Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ gɛɛ, ʋ gyɩ yaa nala hʋ aa gyegili Zakarɩya gyaŋwuwo hʋ tɩyaŋ wɩkperii rɛ, beewɩya, ba gyɩ bɩ gyɩŋ wɩɩ hʋ aa tɩŋ ʋ kɩ pɩɩsɩ gɛɛ Wɩɩkyʋwaldɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ɛɛ rɛ malɩka hʋ kpa mʋ, aŋka Zakarɩya ko lɩɩ gyaŋwuwo nala hʋ lee. Ʋ gyɩ aa ko lɩɩ, ʋ bɩl bɩ wuwo kɩ basɩ wɩya. Nosi rɛ ʋ gyɩ kaŋ kɩ basɩ wɩya ba lee. Doŋ nɛ ba gyɩ gyɩma anɩɩ ʋ aa bɩ wuwo kɩ basɩ nyɛ, ʋ naa wɩɩ rɛ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ ʋ Wɩɩsɩ kyʋwalɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɛɛ rɛ Zakarɩya tʋma ko teŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ʋ mɩɩgɩ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ʋ gyɩ bɩ pɩɩsa, ka ʋ haaŋ Ɛlizabɛtɩ kaŋ luwol. Ʋ gyɩ aa kaŋ luwol hʋ gɛɛ, ʋ gyɩ kaŋ ʋ tɩɩ faŋa dɩya tɩyaŋ nɛ peŋsi bɔnɔŋ dɩ ʋ bɩ lɩɩ bee. ");
INSERT INTO sig_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ɛɛ rɛ ʋ baa, “Wɩɩsɩ pɩɩsa, ka lagɩlagɩ no ʋ kyiyeli ŋ nyɛ. Ʋ tɔɔ ŋ hɩɩsɩ rɛ dʋnɩya tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɛlizabɛtɩ aa kaŋ luwol hʋ, ʋ peŋsi badʋ tɩyaŋ nɛ Wɩɩsɩ tɩŋ ʋ malɩka Geebiral dɩ ʋ mʋ Nazarɛti aa we Galili paalʋʋ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","a kaŋ duwoso mʋ tɩya hatoluu kɩdɩgɩ ha aa bɩ gyɩŋ baal, ba kɩ yɩrɩ Mɛɛrɩ. Gyosɛfʋ aa yaa kuwori Deviti doho nal lɛ gyɩ kpa Mɛɛrɩ, amɛ ʋ beel-ʋ ha gyɩ bɩ gyɩŋ dɔmɔŋ anɩɩ haaŋ bee baal. ");
INSERT INTO sig_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ɛɛ rɛ malɩka hʋ ko ʋ lee a kyʋwalɩ ʋ, a baa, “Wɩɩsɩ fɩyɛlʋʋ we ɩ lee! Wɩɩsɩ we ɩ lee rɛ, aŋ pɛ ɩ tɩyaŋ mɛ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛɛrɩ aa nɩɩ wɩɩ no malɩka hʋ aa basa tɩya ʋ, wɩɩ hʋ kegimi ʋ. Ʋ kɩ bɩɩnɩ wɩɩ hʋ memii. ");
INSERT INTO sig_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛɛ rɛ malɩka hʋ basɩ tɩya ʋ a baa, “Mɛɛrɩ, Wɩɩsɩ kyo ɩ wɩya rɛ, ta leŋ dɩ kambɩŋ kana ɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɩ sɩ kaŋ luwol a lʋl boyoŋbiye, a we ʋ feŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ʋ sɩ sii yaa nɩbal, dɩ ba kana ʋ kɩ yɩrɩ Wɩɩbal hʋ Biye. Á Tɩɩna Wɩɩsɩ sɩ leŋ dɩ ʋ di koro anɩɩ ʋ naabaa Deviti gyɩ aa dii koro gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ʋ sɩ di koro Gyeekɔbɩ doho nala tɩyaŋ a kaŋ kɩ mʋ deŋdeŋ. Ʋ koro hʋ bɩ sɩ teŋ maakyiye kɩdɩgɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ɛɛ rɛ Mɛɛrɩ basɩ tɩya malɩka hʋ a baa, “Ŋ ha bɩ gyɩŋ baal, ɛɛ rɛ wɩɩ no sɩ yaa, a wuwo yaa?” ");
INSERT INTO sig_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɛɛ rɛ malɩka hʋ basɩ tɩya ʋ a baa, “Wɩɩsɩ Wiyesi Welii hʋ rɛ sɩ ko gyʋʋ ɩ tɩyaŋ, dɩ ɩ kaŋ luwol Wɩɩsɩ dee tɩyaŋ. Ɛɛwɩya, biye hʋ ɩ aa sɩ lʋla, ʋ sɩ yaa Tɩpʋlʋŋ Tɩɩna dɩ ba kana ʋ kɩ yɩrɩ Wɩɩsɩ Biye. ");
INSERT INTO sig_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na ɩ lʋllɩ Ɛlizabɛtɩ aa hɩyasa gɛɛ. Ba kɩ basɩ anɩɩ ʋ yaa hapɩrɩ rɛ, amɛ ʋ yaŋ aa kaŋ luwol, ʋ peŋsi badʋ rɛ nyɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Beewɩya wɩɩ buloŋ tuwo Wɩɩsɩ aa bɩ sɩ wuwo yaa.” ");
INSERT INTO sig_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛɛ rɛ Mɛɛrɩ basɩ tɩya ʋ a baa, “Ŋ yaa Wɩɩsɩ tʋŋtʋnnɩ rɛ. Wɩya hʋ buloŋ ɩ aa basɩ tɩya ŋ, Wɩɩsɩ sɩ leŋ dɩ ba yaa wɩtɩɩ.” Ɛɛ rɛ malɩka hʋ leme ʋ, aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ɛɛ rɛ Mɛɛrɩ sii lagɩ lagɩ, a kpa mʋ Ɛlizabɛtɩ bee aa we Gyudɩya paalʋʋ dogiŋsi hʋ nyuu tɩyaŋ dɩ ʋ na ʋ. ");
INSERT INTO sig_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mɛɛrɩ aa mʋʋ pele doŋ, ʋ mʋ gyʋʋ Zakarɩya dɩya a mʋ kyʋwalɩ ʋ haaŋ Ɛlizabɛtɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ɛlizabɛtɩ aa nɩɩ Mɛɛrɩ kyʋwala hʋ, biye hʋ aa we ʋ luwol tɩyaŋ sii lugisi. Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ ko gyʋʋ Ɛlizabɛtɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ʋ heeli basɩ tɩya Mɛɛrɩ a baa, “Wɩɩsɩ kyiyeli ɩ rɛ a te haana buloŋ, a kyiyeli biye hʋ mɛ ɩ aa sɩ lʋla. ");
INSERT INTO sig_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bee rɛ tɩŋ wɩbal no yaa ŋ tɩyaŋ, a mʋ kɩ maga dɩ ŋ Tɩɩna nɩɩna ko dɩ ʋ na ŋ mɛ nyɛ? ");
INSERT INTO sig_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ŋ aa laa ɩ kyʋwala hʋ gɛɛ, biye hʋ aa we ŋ luwol tɩyaŋ teŋ mɛ fɩyɛla rɛ, ʋ sii lugusi. ");
INSERT INTO sig_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ɩ yaa nyusʋŋtɩɩna rɛ ɩ aa laa di anɩɩ wɩɩ hʋ Wɩɩsɩ aa basɩ tɩya ɩ sɩ kɔnɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ɛɛ rɛ Mɛɛrɩ yɩɩ yɩɩl a baa, “Ŋ teŋ fɩyɛla rɛ yʋga, ŋ kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wɩɩsɩ rɛ yaa ŋ Laataal. Ɛɛ rɛ tɩŋ ŋ kɩ gyʋwɔsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ŋ yaa ʋ tʋŋtʋnnɩbiye rɛ, ka ʋ liisi ŋ wɩya. A lɩɩ gyɩnaŋ a kaŋ kɩ mʋ, nal buloŋ sɩ kana ŋ kɩ yɩrɩ nyusʋŋtɩɩna. ");
INSERT INTO sig_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Akuu wɩbal no Wɩɩbal hʋ aa yaa tɩya ŋ wɩya. Ʋ yaa Tɩpʋlʋŋ Tɩɩna rɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nala hʋ buloŋ aa fá Wɩɩsɩ, ʋ mɛ aa fá ba sikii rɛ, nihuwobiŋ doho kɛ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ʋ gaŋdaa-noŋ hʋ rɛ ʋ kaŋ tannɩ, a ŋmaa babiibala abee ba tɩbɩɩna buloŋ pɩsa. ");
INSERT INTO sig_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ʋ kile kuworibala rɛ ba kuworikpasɩnɩ nyuni tɩyaŋ, aŋ mɩɩgɩ leŋ nɩbiisi laa doŋma hɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ʋ kpa kɩweliye rɛ a tɩya nyaaba aŋ kile kɩna tɩmma ta abee nohɩllɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ʋ fa biŋ nyʋwa rɛ a tɩya á naabaala dɩ ʋ sɩ pɛ ʋ tʋŋtʋnna Iziral tɩmma tɩyaŋ. Wɩɩ hʋ ʋ fa aa basa ko yaa wɩtɩɩ rɛ, beewɩya ʋ pɛ ba tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ʋ gyɩ fá Abɩraham sikii rɛ. Ʋ yaŋ sɩ fá ʋ doho nala buloŋ mɛ sikii a kaŋ kɩ mʋ maakyiye buloŋ.” ");
INSERT INTO sig_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛɛrɩ gyɩ hɔŋ Ɛlizabɛtɩ lee rɛ peŋsi boto, aŋ na mɩɩgɩ mʋ bee. ");
INSERT INTO sig_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɛɛ rɛ Ɛlizabɛtɩ lʋl ko pele. Ʋ lʋla boyoŋbiye. ");
INSERT INTO sig_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ʋ aa lʋla gɛɛ, ʋ dɔŋtɩŋsɩ abee ʋ lʋlla buloŋ nɩɩ gɛɛ Wɩɩsɩ aa fáá ʋ sikii. Ba tenni buloŋ gyɩ fɩyɛlɩ, ba beel-ʋ buloŋ kɩ dɩyɛsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Biye hʋ gyɩ aa ko pele kyɛyɛ kyori, ba ko dɩ ba keri ʋ peŋ aŋ we ʋ feŋ. Ba gyɩ aa kyɛ dɩ ba kpa ʋ kuwo Zakarɩya feŋ nɛ a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ɛɛ rɛ ʋ naa bɩ laa nyʋwa aŋ baa dɩ ba we ʋ feŋ Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɛɛ rɛ ba basɩ tɩya ʋ anɩɩ ba doho nal buloŋ ha bɩ maakyiye di Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nyɛ rɛ ba kaŋ nosi pɩyɛsɩ ʋ kuwo dɩ feŋbee rɛ ʋ kɩ kyɛ dɩ ʋ we biye hʋ. ");
INSERT INTO sig_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Doŋ nɛ Zakarɩya leŋ ba kpa daaparɩ ko tɩya ʋ, ʋ sabɩ biye hʋ feŋ we a baa dɩ ʋ feŋ nɛ yaa Gyɔɔŋ. Ba na feŋ hʋ, ʋ yaa ba wɩkperii. ");
INSERT INTO sig_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Haŋ lagɩlagɩbiye hʋ, Zakarɩya bɩl piili a kɩ basɩ wɩya a kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nala hʋ fa aa we doŋ a naa wɩɩ hʋ aa yaa, ʋ yaa ba kambɩŋ. Ba kaŋ wɩɩ hʋ lɩɩ a basɩ taalɩ Gyudɩya paalʋʋ logiŋ hʋ aa kaŋ dogiŋsi hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nala hʋ buloŋ aa nɩɩ gɛɛ, ba kaŋ wɩɩ hʋ kɩ bɩɩnɩ ba tɩsɩ tɩyaŋ a kɩ basɩ, “Biye no yaŋ sɩ yaa nɩgɛɛ doho rɛ nyɛ?” Ba naa anɩɩ á Tɩɩna Wɩɩsɩ dee we ʋ tɩyaŋ nɛ, ɛɛ rɛ tɩŋ ba kɩ basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ ko gyʋʋ Gyɔɔŋ kuwo Zakarɩya tɩyaŋ, ʋ basɩ Wɩɩsɩ wɩya Wiyese Welii hʋ dee tɩyaŋ a baa, ");
INSERT INTO sig_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ma leŋ dɩ á dannɩ Wɩɩsɩ, Wɩɩsɩ hʋ Iziral tɩmma aa tɩŋ. Beewɩya, ʋ ko dɩ ʋ pɛ ʋ nala tɩyaŋ nɛ a laa ba ta. ");
INSERT INTO sig_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ʋ lɩɩ niduwo rɛ ʋ ko, dɩ ʋ laa ma ta. Nal no lɩɩ Wɩɩsɩ tʋŋtʋnnɩ Deviti doho nala tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Faafaa buloŋ nɛ Wɩɩsɩ tɩŋ ʋ tɩŋdaala tɩyaŋ, a basɩ tɩya ma ");
INSERT INTO sig_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","anɩɩ ʋ sɩ laa ma ta á dɔmɔ abee nala hʋ buloŋ aa haasɩ ma nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ʋ mɛ fa basa anɩɩ ʋ sɩ fá á naabaala sikii, ka dɩ wɩya hʋ buloŋ mɛ ʋ aa wee nyʋwa a baa dɩ ʋ sɩ yaa hʋ, dɩ ʋ kɔnɩ yaa ba mɛ. ");
INSERT INTO sig_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ʋ fa wee nyʋwa tɩya á naabaa Abɩraham nɛ abee sɩfɩyasɩ buloŋ anɩɩ ʋ sɩ laa ma ta á dɔmɔ nosi tɩyaŋ, a leŋ dɩ á kɩ tɩŋa ʋ, aŋ ta kɩ fá kambɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ɛɛ rɛ á sɩ wuwo yaa nɩtɩɩma, a kaŋ tɩpʋlʋŋ ʋ sɩya tɩyaŋ á mɩɩbol buloŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakarɩya gyɩ aa basɩ wɩya no ko teŋ, ʋ mɩɩgɩ basɩ tɩya ʋ biye hʋ mɛ a baa, “Ŋ biye, ɩ sɩ yaa Wɩɩbal hʋ tɩŋdaal Ɩ sɩ laa á Tɩɩna sɩya mʋ, a marɩ ʋ ŋmanɩɩ bin-ʋ. ");
INSERT INTO sig_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ɩ sɩ basɩ tɩya Wɩɩsɩ nala anɩɩ Wɩɩsɩ sɩ kpa ba wɩbɔmɔ kyɛ ba aŋ laa ba ta. ");
INSERT INTO sig_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wɩɩsɩ kaŋ bɔnyɛ rɛ, a kɩ fá nala sikii mɛ. Ʋ sɩ laa ma ta, a leŋ dɩ á hɔŋ pʋlʋŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Pʋlʋŋ no sɩ lɩɩ wɩɩsɩbee, a kyaanɩ we nala hʋ buloŋ aa we bilhuu tɩyaŋ, ka sʋʋ wɩya yaa ba beŋkyekpa. Ʋ sɩ daga ma ŋmanɩɩ hʋ aa kaŋ fɩyɛlʋʋ dɩ á kɩ tɩŋa.” ");
INSERT INTO sig_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ɛɛ rɛ biye hʋ sii waa abee dee, a kaŋ wɩgyʋŋ mɛ. Biye no gyɩ sii mʋ we pogo tɩyaŋ nɛ, a mʋ pele kyɛɛ hʋ ʋ aa piile kɩ basɩ Wɩɩsɩ wɩya Iziral nala buloŋ na ʋ. ");
INSERT INTO sig_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Saŋa no tɩyaŋ, baal kɩdɩgɩ rɛ gyɩ we doŋ, ba kɩ yɩrɩ Ɔgɛsitu Siiza. Ʋ rɛ fa yaa Roma paalʋʋ buloŋ kuworibal. Nyɛ rɛ ʋ sii baa dɩ ba dɩɩsɩ paalʋʋ hʋ nala buloŋ. Ba ha gyɩ bɩ maakyiye dɩɩsɩ nala paalʋʋ hʋ tɩyaŋ aŋka. Ba piilii rɛ ha gyɩ nyɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Saŋa hʋ ba aa dɩɩsɩ nala hʋ, dɩ baal kɩdɩgɩ ba aa yɩrɩ Kuriniyɔsɩ mɛ rɛ gyɩ laa kuworibal hʋ naasɩ sɩŋ Siiriya paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɛɛ rɛ nal buloŋ mʋ ʋ bee dɩ ba dɩɩsɩ ʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Gyosɛfʋ mɛ gyɩ sii lɩɩ Nazarɛti aa we Galili paalʋʋ tɩyaŋ, a mʋ Bɛtɩlɛhɛm aa we Gyudɩya paalʋʋ tɩyaŋ. Bɛtɩlɛhɛm nɛ Gyosɛfʋ naabaa Kuworo Deviti gyɩ lɩɩ, ɛɛ rɛ tɩŋ ʋ gyɩ mʋ doŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ʋ bee Mɛɛrɩ buloŋ nɛ gyɩ mʋwa dɩ ba dɩɩsɩ ba doŋ, beewɩya ba gyɩ wee nyʋwa tɩya dɔmɔŋ nɛ, nal buloŋ gyɩma, anɩɩ ba sɩ yal dɔmɔŋ. Saŋa no tɩyaŋ dɩ Mɛɛrɩ gyɩ kaŋ luwol hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba gyɩ aa mʋʋ pele Bɛtɩlɛhɛm dɩ Mɛɛrɩ lʋl mɛ pele, ");
INSERT INTO sig_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","amɛ ba gyɩ bɩ naa lee dɩ ba gyʋʋ. Ɛɛ rɛ tɩŋ ba gyɩ mʋ gyʋʋ gyadɩya kɩdɩgɩ. Doŋ nɛ Mɛɛrɩ gyɩ lʋl ʋ hatobiye, ʋ yaa boyoŋbiye. Ɛɛ rɛ ʋ kaŋ gakɔsʋŋsɩ bɔ tɔ ʋ, a kpa ʋ biŋ gya-ɔhɔ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Haŋ saŋa hʋ tɩyaŋ dɩ pedaala badɔmɔŋ mɛ gyɩ we paalʋʋ hʋ logiŋ kɩdɩgɩ tɩyaŋ, a kyʋwa ɔhɔ tɩyaŋ, a kɩ deŋ ba piyese. ");
INSERT INTO sig_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɛɛ rɛ malɩka kɩdɩgɩ ko ba lee. Ʋ aa ko gɛɛ, Wɩɩsɩ pʋlʋŋ kyaanɩ we ba tɩyaŋ. Kambɩŋ gyɩ kaŋ ba, ba nyuni gyɩ ŋmala ŋmala. ");
INSERT INTO sig_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ɛɛ rɛ malɩka hʋ basɩ tɩya ba a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma. Duwosi-welii rɛ ŋ kaŋ ko dɩ ŋ tɩya ma. Nal hʋ buloŋ aa sɩ nɩɩ duwosi-welii no, ʋ teŋ sɩ fɩyɛlɩ rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gyɩnaŋ ba lʋl ma Laataal lɛ Bɛtɩlɛhɛm tɩyaŋ, ba kɩ yɩrɩ ʋ á Tɩɩna Krisita, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa ʋ nala ta. ");
INSERT INTO sig_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dɩ ma ko mʋ, nyɛ rɛ ma sɩ kpa gyɩma ʋ. Ma sɩ na biye dɩ ba kaŋ gakɔsʋŋsɩ bɔ tɔ ʋ, a kpa ʋ biŋ gya-ɔhɔ nyuu tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɛɛ rɛ malɩkasɩ yʋga pirigi ko lɩɩ, a pɛ malɩka hʋ tɩyaŋ, ba yɩɩ yɩɩla a kɩ dannɩ Wɩɩsɩ a baa, ");
INSERT INTO sig_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ma leŋ dɩ á dannɩ Wɩɩsɩ aa we wɩɩsɩbee tɩyaŋ. Wɩɩsɩ nikyooliye mɛ aa we taŋha nyuu tɩyaŋ sɩ na fɩyɛlʋʋ.” ");
INSERT INTO sig_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malɩkasɩ hʋ aa mɩɩgɩ mʋ wɩɩsɩbee ko teŋ, pedaala hʋ basɩ tɩya dɔmɔŋ a baa, “Ma leŋ dɩ á mʋ Bɛtɩlɛhɛm, a na wɩɩ hʋ á Tɩɩna Wɩɩsɩ aa leŋ ʋ malɩkasɩ hʋ ko basɩ tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Doŋ nɛ ba sii fá lagɩ lagɩ, a mʋ na Mɛɛrɩ abee Gyosɛfʋ, aŋ na biye hʋ mɛ dɩ ʋ pɩŋ gya-ɔhɔ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ɛɛ rɛ pedaala hʋ basɩ tɩya biye hʋ nɩɩna abee ʋ kuwo wɩya hʋ malɩka hʋ aa basɩ tɩya ba a mʋ kɩ tile biye hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nala hʋ buloŋ aa nɩɩ wɩɩ no pedaala hʋ aa basa, ʋ gyɩ yaa ba wɩkperii rɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka Mɛɛrɩ kɛ laa wɩya hʋ buloŋ a we ʋ hakɩla tɩyaŋ a kaŋ kɩ bɩɩnɩ. ");
INSERT INTO sig_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ɛɛ rɛ pedaala hʋ mɩɩgɩ mʋ ba pedaa. Ba aa mʋʋ hʋ tɩyaŋ nɛ ba yɩɩ yɩɩla a kɩ dannɩ Wɩɩsɩ, beewɩya wɩya hʋ buloŋ malɩka hʋ aa basɩ tɩya ba, ba kɔnɩ naa ba rɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Biye hʋ gyɩ aa ko pele kyɛyɛ kyori, ba keri ʋ peŋ aŋ we ʋ feŋ Yesu. Feŋ no rɛ malɩka hʋ gyɩ daga tɩya Mɛɛrɩ ka ʋ na kaŋ luwol hʋ. ");
INSERT INTO sig_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Saŋa hʋ gyɩ aa ko pele dɩ Mɛɛrɩ bee Gyosɛfʋ pɩɩsɩ ba bisiŋ ta anɩɩ Wɩɩsɩ mɩrɩsɩ hʋ Moosi fa aa saba aa daga gɛɛ, ba sii kaŋ biye hʋ mɛ pɛ mʋ Gyerusalɛm dɩ ba kpa ʋ tɩya Wɩɩsɩ, beewɩya ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, ");
INSERT INTO sig_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“Dɩ baal bee ʋ haaŋ nɛ ko lʋl ba biibuŋbuŋ, dɩ ʋ rɛ ko yaa boyoŋbiye, ʋ maga dɩ ba kpa ʋ tɩya Wɩɩsɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba bɩl saba rɛ anɩɩ ʋ maga dɩ ba kpa kokosi balɩya mɛ rɛ a sʋla Wɩɩsɩ. Ɛɛ rɛ Gyosɛfʋ bee Mɛɛrɩ sii mʋ Wɩɩkyʋwaldɩɩbal hʋ dɩ ba yaa wɩya no. ");
INSERT INTO sig_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Saŋa hʋ tɩyaŋ baal kɩdɩgɩ rɛ gyɩ we Gyerusalɛm tɩyaŋ ba kɩ yɩrɩ Simiyɔŋ. Ʋ fa yaa nɩtɩɩ rɛ a kɩ fá Wɩɩsɩ, aŋ fa kɩ gyegili dɩ Wɩɩsɩ laa Iziral tɩmma ta. ");
INSERT INTO sig_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wɩɩsɩ Wiyesi Welii hʋ fa aa we ʋ tɩyaŋ basɩ tɩya ʋ rɛ anɩɩ ʋ bɩ sɩ sʋba see dɩ ʋ na Krisita hʋ, laataal hʋ Wɩɩsɩ aa wee nyʋwa baa dɩ ʋ sɩ ta dɩ ʋ ko. ");
INSERT INTO sig_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɛɛ rɛ Yesu kuwo abee ʋ naa mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ dɩ ba kpa Yesu tɩya Wɩɩsɩ aŋ pɛ yaa gɛɛ hʋ buloŋ Wɩɩsɩ mɩrɩsɩ hʋ aa daga. Haŋ saŋa hʋ dɩ Wɩɩsɩ Wiyesi Welii hʋ kaŋ Simiyɔŋ mɛ ko gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. ");
INSERT INTO sig_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyɔŋ na biye hʋ, a laa ʋ we ʋ nosi tɩyaŋ aŋ dannɩ Wɩɩsɩ a baa, ");
INSERT INTO sig_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ŋ Tɩɩna, ɩ aa wee nyʋwa a baa ɩ sɩ yaa wɩɩ hʋ, ɩ kɔnɩ yaa ʋ rɛ. Nyɛ kɛ, leŋ dɩ mɩyaŋ ɩ tʋŋtʋnnɩ sʋba a mʋ bee laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ŋ kɔnɩ naa nal hʋ aa ko dɩ ʋ laa dʋnɩya nala ta rɛ abee ŋ sɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ɩ tɩma ʋ rɛ ʋ ko dɩ nal buloŋ na ʋ. ");
INSERT INTO sig_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Biye no sɩ yaa pʋlʋŋ a daga nala hʋ aa bɩ yaa Gyuuma ɩ ŋmanɩɩ, ka dɩ ɩ nala Iziral tɩmma mɛ na feŋ.” ");
INSERT INTO sig_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyɔŋ aa basɩ gɛɛ ko teŋ, wɩya hʋ ʋ fa aa basa a mʋ kɩ tile biye hʋ tɩyaŋ fa yaa ʋ kuwo bee ʋ naa wɩkperii rɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ɛɛ rɛ Simiyɔŋ sʋla Wɩɩsɩ tɩya ba aŋ basɩ tɩya Mɛɛrɩ, biye hʋ nɩɩna a baa, “Wɩɩsɩ rɛ lɩɩ ɩ biye no. Nala hʋ aa bɩ sɩ laa ʋ wɩya di Iziral tɩmma tɩyaŋ, ba sɩ na tʋwara; amɛ nala hʋ aa sɩ laa ʋ wɩya di, ʋ sɩ laa ba ta. Wɩɩsɩ taa biye no rɛ dɩ ʋ yaa ʋ magɩl, ka nala yʋga bɩ sɩ tɩŋa ʋ nyʋwa. Amɛ ʋ sɩ kpa ba memii ta.” ");
INSERT INTO sig_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɛɛ rɛ ʋ bɩl basɩ tɩya Mɛɛrɩ a baa, “Ɩ tɩɩ tɩya mɛ sɩ kyogi rɛ weliŋ ɩ biye no wɩya, a kɩɩ gɛɛ anɩɩ ba aa kpaa takoobii kyɔgɔ ɩ.” ");
INSERT INTO sig_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hanɩhɩyawʋ kɩdɩgɩ mɛ rɛ gyɩ we doŋ, ba kɩ yɩrɩ Ana. Ʋ gyɩ yaa Wɩɩsɩ tɩŋdaal lɛ. Ʋ kuwo feŋ nɛ gyɩ yaa Fanuwɛl, a lɩɩ Asa doho tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Saŋa no tɩyaŋ, haaŋ no gyɩ yaa bɩsɩ mɔllɩ banaa abee banaa rɛ. Ʋ gyɩ aa yal bala, ʋ bɩŋpɛɛ tɩyaŋ nɛ bala hʋ sʋba. Kyɛɛ kɛ buloŋ, ʋ aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ nɛ wɩɩhaa abee tebine buloŋ. Ʋ aa kɩ vʋwa nyʋwa rɛ doŋ a kɩ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simiyɔŋ fa aa basɩ wɩya kɩ tɩya Mɛɛrɩ tɩyaŋ, dɩ Ana mɛ rɛ ko gyʋʋ gɛɛ. Ʋ aa naa biye hʋ, ʋ dannɩ Wɩɩsɩ aŋ basɩ ʋ wɩya tɩya nala hʋ buloŋ fa aa gyegili dɩ Wɩɩsɩ laa Iziral tɩmma ta. ");
INSERT INTO sig_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gyosɛfʋ bee Mɛɛrɩ aa yaa wɩya hʋ buloŋ Wɩɩsɩ mɩrɩsɩ hʋ aa daga dɩ ba yaa Gyerusalɛm tɩyaŋ ko teŋ, ba mɩɩgɩ mʋ ba bee Nazarɛti aa we Galili paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ɛɛ rɛ Biye hʋ sii waa weliŋ, a kaŋ dee abee wɩgyʋŋ, ka Wɩɩsɩ noŋ mɛ dɔbɔ ʋ tɩyaŋ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bɩna kɛ buloŋ Yesu kuwo abee ʋ naa aa mʋ Gyerusalɛm nɛ a di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ. ");
INSERT INTO sig_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu gyɩ aa ko yaa bɩsɩ fi abee balɩya, ʋ bee ʋ kuwo bee ʋ naa mʋ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ Gyerusalɛm tɩyaŋ, anɩɩ ba aa kɩ yaa gɛɛ bɩna bɩna buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kyɛbal hʋ wɩkanɩya aa ko teŋ, ba mɩɩgɩ kɩ mʋ bee aŋka Yesu kɛ mɩɩgɩ ka Gyerusalɛm tɩyaŋ dɩ ʋ naa bee ʋ kuwo bɩ gyɩma. ");
INSERT INTO sig_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba fa bɩɩna anɩɩ ʋ we ba bee nala hʋ aa we hal kɩ ko tɩyaŋ nɛ. Ɛɛ rɛ ba vala gɛɛ wɩɩsɩ mʋ gyʋʋ ka ba bɩ na ʋ. Doŋ tɩyaŋ nɛ ba yaŋ piili kɩ kyɛ ʋ ba lʋlla abee ba kyaŋsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nyɛ rɛ ba kyɛ ʋ lɔlɔ ba tɩyaŋ, aŋ mɩɩgɩ kile ʋ lugo mʋ Gyerusalɛm, a deŋ kɩ kyɛ ʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ʋ kyɛtoo kyɛɛ rɛ ba mʋ na ʋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, dɩ ʋ bee Wɩɩsɩ Teŋ dɩdagɩla hɔnɔ. Ʋ kɩ gyegili wɩya hʋ ba aa basɩ aŋ pɛ kɩ pɩyɛsɩ ba wɩya mɛ. ");
INSERT INTO sig_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nala hʋ buloŋ aa we doŋ a nɩɩ ʋ aa lɩɩ wɩya hʋ sɩya abee wɩgyʋŋ gɛɛ, ba nyʋʋsɩ fɩyɛlɩ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ʋ kuwo bee ʋ naa gyɩ aa ko na ʋ, ba nyʋʋsɩ mɛ gyɩ fɩyɛla rɛ. Doŋ nɛ ʋ naa pɩyɛsɩ ʋ a baa, “Ŋ biye, deŋ na ɩ aa yaa ma gɛɛ! Ŋ bee ɩ kuwo buloŋ gɔllɔ kyɛ ɩ gɛɛ rɛ a mʋ lɔlɔ á buloŋ, haalɩ ɩ wɩya mɩɩgɩ yaa ma beŋkyekpa.” ");
INSERT INTO sig_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma gɔllɩ kɩ kyɛ ŋ? Ma bɩ gyɩma anɩɩ ŋ maga dɩ ŋ we ŋ Kuwo dɩya tɩyaŋ nɛ?” ");
INSERT INTO sig_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amɛ ba fa bɩ gyɩŋ wɩɩ hʋ ʋ aa basɩ tɩya ba memii. ");
INSERT INTO sig_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɛɛ rɛ Yesu mɩɩgɩ tɩŋ ʋ naa bee ʋ kuwo hal, ba buloŋ kpa mʋ Nazarɛti. Ba aa we doŋ, ʋ gyɩ aa tɩŋ ba nyʋwa rɛ weliŋ, ka ʋ naa kpa wɩya hʋ buloŋ aa yaa a we ʋ hakɩla tɩyaŋ a kɩ bɩɩnɩ. ");
INSERT INTO sig_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ɛɛ rɛ Yesu sii waa weliŋ, a kaŋ wɩgyʋŋ mɛ. Wɩɩsɩ teŋ fɩyɛlɩ ʋ tɩyaŋ, nihuwobisi mɛ kyo ʋ wɩya weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zakarɩya biibaal Gyɔɔŋ ha gyɩ we pogo hʋ tɩyaŋ nɛ. Doŋ tɩyaŋ nɛ Wɩɩsɩ gyɩ basɩ tɩya ʋ dɩ ʋ mʋ basɩ Wɩɩsɩ wɩya a tɩya nala. Saŋa no tɩyaŋ, Roma paalʋʋ buloŋ kuworibal Tibeeriyo gyɩ aa dii koro, ʋ bɩsɩ fi abee bɔnɔŋ tɩyaŋ nɛ gyɩ gɛɛ. Ɛɛ saŋa dɩ Pɔŋtiyo Pilato mɛ rɛ fa laa Roma kuworibal hʋ naasɩ sɩŋ Gyudɩya paalʋʋ tɩyaŋ. Hɛrɔtɩ mɛ rɛ fa aa deŋ Galili paalʋʋ, ka ʋ naabiye Fɩlɩpɩ mɛ fa kɩ deŋ Ituriya abee Tirakonati paalʋʋ. Baal kɩdɩgɩ aa lɩɩ Lisaniya mɛ rɛ fa aa deŋ Abiliini paalʋʋ. Anaasɩ bee Kayifasɩ mɛ rɛ fa yaa Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɛɛ rɛ Gyɔɔŋ gɔllɩ Gyɔɔdaŋ fuwo hʋ nyʋwa buloŋ, a basɩ Wɩɩsɩ wɩya kɩ tɩya nala a baa, “Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ, aŋ leŋ dɩ ŋ fo ma wɩɩkyʋwalnɩɩ, dɩ Wɩɩsɩ kpa ma wɩbɔmɔ kyɛ ma.” ");
INSERT INTO sig_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wɩɩsɩ tɩŋdaal Azaaya fa saba wɩɩ no Wɩɩsɩ teŋ logiŋ kɩdɩgɩ tɩyaŋ nɛ, a baa: “Nal lɛ we pogo tɩyaŋ, a heeli kɩ basɩ, ‘Ma ko marɩ ma tɩsɩ anɩɩ ma aa marɩ ŋmanɩɩ a pɔ nɩbal koyi gɛɛ, dɩ ma tɩɩna ko tɩŋa. Dɩ mamaa rɛ yaa gɛɛ dɩ ʋ ko ko, ʋ lɩvalɩɩ sɩ pɩŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma giri dogiŋbala abee dogiŋbiisi hʋ buloŋ a tuu tɔ pallɩ hʋ buloŋ a kaŋ gyarɩ dɩ ba maga dɔmɔŋ, ŋmaŋsɩ hʋ buloŋ aa golo, ma kaŋ ba degini. Ŋmaŋsɩ hʋ buloŋ mɛ aa kaŋ bootigini, ma we ba buloŋ taŋha dɩ ba pɩŋ namama. ");
INSERT INTO sig_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dʋnɩya nala buloŋ sɩ na gɛɛ hʋ Wɩɩsɩ aa laa nala kɩ ta.”’ ");
INSERT INTO sig_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ɛɛ rɛ nɩgyamaa ko lɩɩ Gyɔɔŋ lee dɩ ʋ fo ba wɩɩkyʋwalnɩɩ. Ʋ basɩ tɩya ba a baa, “Ɛɛdɔŋ dʋma! Ma dawarɩ yʋga ma tɩyaŋ. Kɩbee rɛ mʋrɩ ma anɩɩ wɩɩkyʋwalnɩɩ no ŋ aa sɩ fo ma dʋŋ sɩ wuwo laa ma ta Wɩɩsɩ sarɩya hʋ kyɛdiilii? ");
INSERT INTO sig_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ma leŋ dɩ ma wɩyaalɩya daga anɩɩ ma bɩrɩma lɩɩ ma wɩbɔmɔ yayɩ tɩyaŋ nɛ, aŋ ta leŋ ma aa yaa Abɩraham doho nala wɩya dʋŋ yaa wɩɩ. Beewɩya Wɩɩsɩ aa wuwo ʋ leŋ bʋwa no ma aa naa nyɛ sii bɩrɩmɩ Abɩraham doho nala rɛ. ");
INSERT INTO sig_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ma gyɩma! Wɩɩsɩ yaa siri rɛ abee ʋ saa dɩ ʋ ŋmaŋ tɩya hʋ buloŋ aa bee nɔŋ nɔŋweliye a lo, a keri paa yuwo we diŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɛɛ rɛ nala hʋ pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ yaŋ maga dɩ á yaa?” ");
INSERT INTO sig_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ʋ basɩ tɩya ba a baa, “Nal hʋ aa kaŋ gannɩ balɩya, ʋ maga dɩ ɩ kpa kɩdɩgɩ tɩya nal hʋ aa bɩ kaŋ gal lɛ. Nal hʋ mɛ aa kaŋ kɩdiiliye, ʋ maga dɩ ʋ yaa kpaa nala hʋ aa bɩ naa ba di rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɛɛ rɛ lampolaala badɔmɔŋ mɛ ko dɩ ʋ fo ba wɩɩkyʋwalnɩɩ. Ba mɛ pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, ɛɛ rɛ á mɛ sɩ yaa?” ");
INSERT INTO sig_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ʋ basɩ tɩya ba a baa, “Ma ta laa molbiye te gɛɛ hʋ aa maga dɩ ma laa.” ");
INSERT INTO sig_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Laalyuwolo badɔmɔŋ mɛ pɩyɛsɩ ʋ a baa, “Aŋka á mɛ, ɛɛ rɛ á mɛ sɩ yaa?” Ʋ basɩ tɩya ba mɛ a baa, “Ma ta fugisi nal buloŋ a laa molbiye, a ta nyɩya wɩya a kɩ tɩya nala mɛ. Ma leŋ dɩ tuno hʋ ma aa laa maga ma.” ");
INSERT INTO sig_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɛɛ rɛ nala hʋ fa aa gyegili Krisita hʋ koyi fa piili kɩ bɩɩnɩ anɩɩ Gyɔɔŋ nɛ yaa Krisita hʋ. ");
INSERT INTO sig_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ɛɛ rɛ Gyɔɔŋ basɩ tɩya ba buloŋ a baa, “Nɩɩ dʋŋ nɛ ŋ kɛ kaŋ kɩ fo ma. Amɛ nal kɩdɩgɩ rɛ sɩ ko, ʋ rɛ yaa nɩbal a te ŋ. Ŋ paalɩ bɩ maga dɩ ŋ kpaga ʋ, a kaŋ ʋ naatɔbɔ ŋmasɩ mɛ puri. Ʋ kɛ sɩ kpa Wɩɩsɩ Wiyesi Welii hʋ abee diŋ a fo ma wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʋ kolo ʋ mɩkyaarɩgbaha rɛ. Dɩ ʋ rɛ ko ŋmaa ʋ mɩya hʋ teŋ, ʋ sɩ kyaarɩ lɩɩ miŋbii hʋ a we ʋ busol tɩyaŋ, aŋ kpa mɩŋgyɔrʋ hʋ a we diŋ aa bee dɩsɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ŋmaŋgyamaa rɛ Gyɔɔŋ gyɩ kpa a basɩ Wɩɩsɩ wɩweliye hʋ a tɩya nala, aŋ kpaanɩ ba weliŋ dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ yayɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wɩya badɔmɔŋ nɛ Hɛrɔtɩ gyɩ yaa, ɛɛ rɛ Gyɔɔŋ gyɩ basɩ ʋ sɩya wɩya tɩya ʋ. Hɛrɔtɩ rɛ gyɩ aa deŋ Galili paalʋʋ. Ʋ maana ha gyɩ hɔnɔ rɛ ka ʋ kaŋ ʋ haaŋ ba aa yɩrɩ Hɛrodiya a fasɩ. Ɛɛ rɛ Gyɔɔŋ gyɩ basɩ tɩya ʋ anɩɩ ʋ bɩ yaa ŋmanɩɩ dɩ ʋ kaŋ ʋ maana haaŋ fasɩ. Hɛrɔtɩ gyɩ yaa wɩbɔmɔ badɔmɔŋ mɛ rɛ yʋga a pɛ wɩɩ no tɩyaŋ. Ba buloŋ wɩya rɛ tɩŋ Gyɔɔŋ gyɩ basɩ ʋ sɩya wɩya tɩya ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛrɔtɩ gyɩ yaŋ aa sɩ marɩ yaa wɩbɔŋ hʋ rɛ yaa, ʋ gyɩ bɩl sii leŋ ba kaŋ Gyɔɔŋ tɔ nɩtɔdɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Gyɔɔŋ gyɩ aa foo nala hʋ buloŋ wɩɩkyʋwalnɩɩ ko teŋ, ɛɛ rɛ ʋ fo Yesu mɛ wɩɩkyʋwalnɩɩ. Doŋ tɩyaŋ nɛ Yesu kɩ kyʋwalɩ Wɩɩsɩ dɩ ʋ naa wɩɩsɩnyuu pirigi lɔgɔ suri. Nyɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ kɩɩ gɛɛ anɩɩ kokomo, a ko tuu saga ʋ tɩyaŋ. Ɛɛ hal lɛ ʋ nɩɩ taal kɩdɩgɩ dɩ ʋ lɩɩ wɩɩsɩnyuu a basɩ tɩya ʋ a baa, “Ɩ rɛ yaa ŋ Biikyoolii. Ŋ teŋ fɩyɛla rɛ ɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Saŋa hʋ Yesu gyɩ aa piili ʋ tʋma hʋ, dɩ ʋ gyɩ yaa bɩsɩ mɔlɩya abee fi rɛ. Nala gyɩ bɩɩna anɩɩ Gyosɛfʋ rɛ lʋl Yesu. Nyɛ rɛ Yesu doho tɩŋa: Gyosɛfʋ kuwo feŋ nɛ yaa Heli. ");
INSERT INTO sig_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mɛ kuwo feŋ nɛ yaa Mataati. Mataati mɛ kuwo feŋ nɛ yaa Levi. Levi mɛ kuwo feŋ nɛ yaa Mɛlki. Mɛlki mɛ kuwo feŋ nɛ yaa Gyanna. Gyanna mɛ kuwo feŋ nɛ yaa Gyosɛfʋ. ");
INSERT INTO sig_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Gyosɛfʋ mɛ kuwo feŋ nɛ yaa Matatiya. Matatiya mɛ kuwo feŋ nɛ yaa Emosi. Emosi mɛ kuwo feŋ nɛ yaa Nahum. Nahum mɛ kuwo feŋ nɛ yaa Ɛsili. Ɛsili mɛ kuwo feŋ nɛ yaa Nagayi. ");
INSERT INTO sig_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi mɛ kuwo feŋ nɛ yaa Maati. Maati mɛ kuwo feŋ nɛ yaa Matatiya. Matatiya mɛ kuwo feŋ nɛ yaa Simeeni. Simeeni mɛ kuwo feŋ nɛ yaa Gyosɛkɩ. Gyosɛkɩ mɛ kuwo feŋ nɛ yaa Gyoda. ");
INSERT INTO sig_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Gyoda mɛ kuwo feŋ nɛ yaa Gyuwanaŋ. Gyuwanaŋ mɛ kuwo feŋ nɛ yaa Risa. Risa mɛ kuwo feŋ nɛ yaa Zerubabɛl. Zerubabɛl mɛ kuwo feŋ nɛ yaa Siyatiil. Siyatiil mɛ kuwo feŋ nɛ yaa Neeri. ");
INSERT INTO sig_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri mɛ kuwo feŋ nɛ yaa Mɛlki. Mɛlki mɛ kuwo feŋ nɛ yaa Adi. Adi mɛ kuwo feŋ nɛ yaa Kosam. Kosam mɛ kuwo feŋ nɛ yaa Ɛlimadam. Ɛlimadam mɛ kuwo feŋ nɛ yaa Ɛri. ");
INSERT INTO sig_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛri mɛ kuwo feŋ nɛ yaa Gyoosʋwa. Gyoosʋwa mɛ kuwo feŋ nɛ yaa Ɛliyeza. Ɛliyeza mɛ kuwo feŋ nɛ yaa Gyorim. Gyorim mɛ kuwo feŋ nɛ yaa Mataati. Mataati mɛ kuwo feŋ nɛ yaa Levi. ");
INSERT INTO sig_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi mɛ kuwo feŋ nɛ yaa Simiyɔŋ. Simiyɔŋ mɛ kuwo feŋ nɛ yaa Gyuda. Gyuda mɛ kuwo feŋ nɛ yaa Gyosɛfʋ. Gyosɛfʋ mɛ kuwo feŋ nɛ yaa Gyonam. Gyonam mɛ kuwo feŋ nɛ yaa Ɛliyakim. ");
INSERT INTO sig_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliyakim mɛ kuwo feŋ nɛ yaa Mɛlɩya. Mɛlɩya mɛ kuwo feŋ nɛ yaa Mɛna. Mɛna mɛ kuwo feŋ nɛ yaa Mataata. Mataata mɛ kuwo feŋ nɛ yaa Neetaŋ. Neetaŋ mɛ kuwo feŋ nɛ yaa Deviti. ");
INSERT INTO sig_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deviti mɛ kuwo feŋ nɛ yaa Gyesi. Gyesi mɛ kuwo feŋ nɛ yaa Obɛdɩ. Obɛdɩ mɛ kuwo feŋ nɛ yaa Buwasi. Buwasi mɛ kuwo feŋ nɛ yaa Salmɔŋ. Salmɔŋ mɛ kuwo feŋ nɛ yaa Naasuŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasuŋ mɛ kuwo feŋ nɛ yaa Amiinadabu. Amiinadabu mɛ kuwo feŋ nɛ yaa Adimɩŋ. Adimɩŋ mɛ kuwo feŋ nɛ yaa Aani. Aani mɛ kuwo feŋ nɛ yaa Hɛzʋrɔŋ. Hɛzʋrɔŋ mɛ kuwo feŋ nɛ yaa Pɛrɛsɩ. Pɛrɛsɩ mɛ kuwo feŋ nɛ yaa Gyuda. ");
INSERT INTO sig_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Gyuda mɛ kuwo feŋ nɛ yaa Gyeekɔbɩ. Gyeekɔbɩ mɛ kuwo feŋ nɛ yaa Azɩkɩ. Azɩkɩ mɛ kuwo feŋ nɛ yaa Abɩraham. Abɩraham mɛ kuwo feŋ nɛ yaa Tɛɛra. Tɛɛra mɛ kuwo feŋ nɛ yaa Nahɔ. ");
INSERT INTO sig_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahɔ mɛ kuwo feŋ nɛ yaa Sɛrugu. Sɛrugu mɛ kuwo feŋ nɛ yaa Ruu. Ruu mɛ kuwo feŋ nɛ yaa Pɛlɛgɩ. Pɛlɛgɩ mɛ kuwo feŋ nɛ yaa Iiba. Iiba mɛ kuwo feŋ nɛ yaa Sɛla. ");
INSERT INTO sig_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sɛla mɛ kuwo feŋ nɛ yaa Kayinaŋ. Kayinaŋ mɛ kuwo feŋ nɛ yaa Afagisaadi. Afagisaadi mɛ kuwo feŋ nɛ yaa Sɛm. Sɛm mɛ kuwo feŋ nɛ yaa Nowa. Nowa mɛ kuwo feŋ nɛ yaa Lamɛkɩ. ");
INSERT INTO sig_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛkɩ mɛ kuwo feŋ nɛ yaa Matusela. Matusela mɛ kuwo feŋ nɛ yaa Inɔkɩ. Inɔkɩ mɛ kuwo feŋ nɛ yaa Gyarɛdɩ. Gyarɛdɩ mɛ kuwo feŋ nɛ yaa Mahalalɩ. Mahalalɩ mɛ kuwo feŋ nɛ yaa Kayinaŋ. ");
INSERT INTO sig_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinaŋ mɛ kuwo feŋ nɛ yaa Inɔsɩ. Inɔsɩ mɛ kuwo feŋ nɛ yaa Sɛɛtɩ. Sɛɛtɩ mɛ kuwo feŋ nɛ yaa Adama. Wɩɩsɩ rɛ ta Adama. ");
INSERT INTO sig_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ɛɛ rɛ Yesu gyɩ mɩɩgɩ lɩɩ Gyɔɔdaŋ fuwo hʋ tɩyaŋ ko lɩɩ, dɩ Wɩɩsɩ Wiyesi Welii hʋ we ʋ tɩyaŋ weliŋ, a kpa ʋ gyʋʋ pogo. ");
INSERT INTO sig_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ʋ we doŋ kyɛyɛ mɔllɩbalɩya. Sɩtaanɩ aa ko magɩsɩ magɩsɩ ʋ a mʋ lɔlɔ. Ʋ aa we doŋ kyɛyɛ mɔllɩ balɩya no buloŋ, ʋ bɩ kɩŋ buloŋ diye. Kyɛyɛ mɔllɩbalɩya hʋ ko mʋ kɩ teŋ dɩ losi yaŋ kana ʋ. ");
INSERT INTO sig_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɛɛ rɛ Sɩtaanɩ ko basɩ tɩya ʋ a baa, “Dɩ ɩ baa ɩ yaa Wɩɩsɩ Biye kɛ, leŋ dɩ bʋwa no aa pɩna sii bɩrɩmɩ paanʋʋ.” ");
INSERT INTO sig_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ʋ a baa, “Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, ‘Kɩdiiliye dʋŋ daa aa tɩya nihuwobiŋ mɩɩbol.”’ ");
INSERT INTO sig_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ɛɛ hal tɩyaŋ, Sɩtaanɩ bɩl kana ʋ kpa gyɩŋ wɩɩsɩnyuu, aŋ leŋ ʋ gul lurimi na dʋnɩya paalʋʋsɩ abee ba korisi buloŋ gɛɛ fine. ");
INSERT INTO sig_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Doŋ tɩyaŋ nɛ ʋ basɩ tɩya ʋ a baa, “Kɩna no buloŋ yaa ŋ kɩna rɛ. Ŋ sɩ leŋ dɩ ɩ kaŋ ba buloŋ dee, a tɩŋ ba buloŋ a kɩ nɩɩ ba sʋma. Ŋ aa wuwo dɩ ŋ kpa ba tɩya nal hʋ buloŋ ŋ aa kyɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ɛɛwɩya, dɩ ɩ rɛ tuu gbinni ŋ sɩya tɩyaŋ, a kyʋwalɩ ŋ, ŋ sɩ kpa kɩna no buloŋ tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ a baa, “Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, ‘Ʋ maga dɩ á kɩ tɩŋ á Tɩɩna Wɩɩsɩ dʋŋ nɛ aŋ kɩ kyʋwalɩ ʋ dʋŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ɛɛ rɛ Sɩtaanɩ bɩl kana ʋ mʋ Gyerusalɛm, a kana ʋ gyɩŋ Wɩɩkyʋwaldɩɩbal hʋ nyugbaŋfara, aŋ basɩ tɩya ʋ a baa, “Dɩ ɩ baa ɩ yaa Wɩɩsɩ Biye kɛ, sɩŋ daha aŋ gyaa kyigisi taŋha. ");
INSERT INTO sig_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Na ba sabɩ biŋ Wɩɩsɩ teŋ tɩyaŋ nɛ anɩɩ Wɩɩsɩ sɩ leŋ dɩ ʋ malɩkasɩ sɩŋ pɔ ɩ a kɩ deŋe ɩ. ");
INSERT INTO sig_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ba bɩl saba rɛ anɩɩ ‘Ba sɩ kyeŋ kana ɩ dɩ ɩ naaŋ mɛ ta paalɩ dige taŋha.”’ ");
INSERT INTO sig_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ a baa, “Ba bɩl saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa ‘Ta magɩsɩ á Tɩɩna Wɩɩsɩ.”’ ");
INSERT INTO sig_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sɩtaanɩ aa kpaa ŋmaŋsɩ no buloŋ a magɩsɩ Yesu mʋ lɔlɔ, ʋ leme ʋ, aŋ kpa biŋ pɔ kyɛɛ hʋ ʋ bɩl aa sɩ na ŋmanɩɩ kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ, Yesu gyɩ bɩl lɩɩ pogo hʋ tɩyaŋ nɛ, a mɩɩgɩ kpa mʋ Galili paalʋʋ. Ɛɛ rɛ ʋ wɩya taalɩ doŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Doŋ nɛ ʋ kɩ daga nala Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ, nal nal buloŋ kɩ bigisi ʋ. ");
INSERT INTO sig_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Ɛɛ rɛ Yesu sii mʋ Nazarɛti, lee hʋ tɩyaŋ ʋ aa waa. Kyɛwiyesii hʋ kyɛɛ ko pele, ʋ sii mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya anɩɩ ʋ aa kɩ yaa gɛɛ saŋa buloŋ. Ɛɛ rɛ ʋ sii sɩŋ dɩ ʋ karɩmɩ Wɩɩsɩ teŋ a tɩya nala hʋ. Ba kpa Wɩɩsɩ teŋ logiŋ hʋ Wɩɩsɩ tɩŋdaal Azaaya aa saba a tɩya ʋ. Nyɛ rɛ ʋ suri mʋ lee hʋ Azaaya aa saba a baa, ");
INSERT INTO sig_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wɩɩsɩ Wiyesi Welii hʋ we ŋ tɩyaŋ nɛ. Ʋ lɩɩ ŋ nɛ dɩ ŋ ko basɩ Wɩɩsɩ wɩweliye hʋ a tɩya nyaaba. Ʋ tɩma ŋ nɛ dɩ ŋ ko basɩ tɩya yosi anɩɩ Wɩɩsɩ sɩ laa ba ta, a bɩl basɩ tɩya nyʋlɩma mɛ dɩ ba sɩya sɩ suri. Ʋ tɩma ŋ nɛ dɩ ŋ laa nala hʋ buloŋ ba aa kaŋ kɩ tɩya sikii ta, ");
INSERT INTO sig_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aŋ basɩ tɩya ba anɩɩ saŋa hʋ á Tɩɩna Wɩɩsɩ aa sɩ laa ʋ nala ta pele rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu aa karɩmɩ teŋ hʋ teŋ, ʋ kaŋ tɔ aŋ kpa tɩya nal hʋ aa biŋ teŋ hʋ aŋ tuu hɔŋ. Nala hʋ buloŋ aa we wɩɩkyʋwaldɩya hʋ tɩyaŋ mɩɩgɩ kyirigi sɩya we ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩya hʋ ŋ aa karɩma teŋ hʋ tɩyaŋ ma nɩɩ nyɛ, gyɩnaŋ ba buloŋ sʋʋ ba bʋʋsɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yesu wɩbasɩɩ hʋ buloŋ gyɩ yaa nala hʋ teŋfɩyɛl lɛ, ba nyʋʋsɩ mɛ gyɩ fɩyɛlɩ abee wɩweliye hʋ ʋ aa basa wɩya. Ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Gyosɛfʋ biibaal hʋ daa nyɛ dʋ?” ");
INSERT INTO sig_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ŋ gyɩma anɩɩ ma sɩ maga namaga no tɩya ŋ a baa, ‘Tɩɩba tɩɩna, tɩɩbɩ ɩ tɩɩ.’ Ma bɩl sɩ basɩ tɩya ŋ a baa dɩ wɩya hʋ buloŋ ma aa nɩya dɩ ŋ aa yaa Kapɛɛnam tɩyaŋ, dɩ ŋ yaa ba ŋ tɩɩ bee tɩyaŋ mɛ.” ");
INSERT INTO sig_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɛɛ rɛ Yesu bɩl baa, “Wɩtɩɩ rɛ, Wɩɩsɩ tɩŋdaal kɛ buloŋ, ʋ bee tɩɩ nala aa bee tɩya ʋ gyɩrɩma.” ");
INSERT INTO sig_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɛɛ rɛ Yesu bɩl baa, “Ma gyegili nɩɩ daha. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma. Saŋa hʋ Wɩɩsɩ tɩŋdaal Ɛlaagya gyɩ aa we ʋ mɩɩbol tɩyaŋ, lohaana gyɩ yʋga rɛ a we Iziral paalʋʋ tɩyaŋ. Haŋ saŋa hʋ duwoŋ mɛ bɩ nɩya bɩsɩ boto abee kyalɩɩ. Nyɛ rɛ losiŋbɔŋ gyɩ gyʋʋ Iziral paalʋʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amɛ Wɩɩsɩ gyɩ bɩ tɩŋ Ɛlaagya ʋ mʋ Gyuuma lohaana no kɩdɩgɩ buloŋ lee. Amɛ ʋ gyɩ tɩma ʋ rɛ, ʋ mʋ lohaaŋ kɩdɩgɩ aa lɩɩ Siidɔŋ paalʋʋ dʋŋ lee, tɔɔ kɩdɩgɩ ba aa yɩrɩ Zarɛfatɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Saŋa hʋ tɩyaŋ Wɩɩsɩ tɩŋdaal Ilaasa mɛ gyɩ aa we ʋ mɩɩbol tɩyaŋ, gbegisi gyɩ yʋga rɛ a we Iziral paalʋʋ tɩyaŋ, amɛ Wɩɩsɩ gyɩ bɩ leŋ Ilaasa tɩɩbɩ ba kɩdɩgɩ buloŋ, see gbege kɩdɩgɩ aa lɩɩ Siiriya paalʋʋ ba kɩ yɩrɩ Naamaŋ dʋŋ.” ");
INSERT INTO sig_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nala hʋ buloŋ gyɩ aa we wɩɩkyʋwaldɩya hʋ tɩyaŋ aa nɩɩ wɩya no, ba baaŋ gyɩ sii ʋ nyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɛɛ rɛ ba sii kaŋ Yesu, a kana ʋ tarɩ lɩɩ bee hʋ samanɩ, a kana ʋ mʋ gyɩŋ dogimo hʋ nyuu tɩyaŋ bee hʋ fa aa sɩna. Ba gyɩ kana ʋ mʋ dogimo hʋ lee aa geese yʋga rɛ, a kɩ kyɛ dɩ ba kpa ʋ yuwo ta dɩ ʋ tuu tele taŋha. Doŋ tɩyaŋ nɛ ba sɩŋ, ");
INSERT INTO sig_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ka ʋ vala tɩŋ nala hʋ tɩyaŋ a lɩɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɛɛ rɛ Yesu lɩɩ Nazarɛti tɩyaŋ, a kpa mʋ Kapɛɛnam aa we Galili paalʋʋ tɩyaŋ. Kyɛwiyesii hʋ kyɛɛ, ʋ mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya a kɩ daga nala. ");
INSERT INTO sig_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ʋ aa daga ba gɛɛ, ba nyʋʋsɩ buloŋ fɩyɛlɩ, beewɩya gɛɛ hʋ ʋ aa basɩ wɩya hʋ daga anɩɩ ʋ kaŋ wɩya hʋ ʋ aa basɩ dee rɛ. ");
INSERT INTO sig_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dɩ baal kɩdɩgɩ gyɩŋbɔŋ aa kana mɛ gyɩ we wɩɩkyʋwaldɩya hʋ tɩyaŋ. Ɛɛ rɛ ʋ faasɩ kyɩɩrɩ ");
INSERT INTO sig_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","a baa, “Yesu aa lɩɩ Nazarɛti, bekiŋ nɛ ɩ kɩ kyɛ ɩ yaa ma? Ɩ ko dɩ ɩ kpʋ ma rɛ? Ŋ gyɩma ɩ rɛ. Ɩ rɛ yaa Wɩɩsɩ tɩŋdaal hʋ aa yaa tɩpʋlʋŋ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu aa nɩɩ wɩya hʋ baal hʋ aa basa, ʋ nɔsɩ gyɩŋbɔŋ hʋ a baa, “Leŋ kyagɩŋsɩ aŋ ko lɩɩ baal hʋ tɩyaŋ.” Gyɩŋbɔŋ hʋ lɩɩ baal hʋ lo ba buloŋ sɩya tɩyaŋ doŋ, aŋ lɩɩ ʋ tɩyaŋ. Amɛ ʋ gyɩ bɩ yaa ʋ wɩbɔŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ba aa naa gɛɛ, ʋ yaa nal buloŋ wɩkperii. Ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Bekine wɩduwoni rɛ ʋ kɩ basɩ nyɛ? Baal no paalɩ kaŋ dee rɛ, a wuwo gyɩŋbɔmɔ, a nɔsɩ ba ba kɩ lɩɩ nala tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɛɛ rɛ Yesu wɩya taalɩ lee hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ɛɛ rɛ Yesu lɩɩ wɩɩkyʋwaldɩya hʋ tɩyaŋ, a kpa mʋ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ dɩya. Ʋ mʋwa dɩ Siimɔŋ hɩɩla pɩna a kɩ wɩɩlɩ, ʋ teŋ buloŋ nɩma. Ɛɛ rɛ ba basɩ ʋ wɩya tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu sii mʋ sɩŋ haaŋ hʋ logiŋ, aŋ nɔsɩ wɩɩl hʋ dɩ ʋ lɩɩ ʋ tɩyaŋ. Wɩɩl hʋ leŋ haaŋ hʋ, aŋka ʋ teŋ sii yaa kɩdiiliye tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ʋ dɩdaana aa ko pele, nala hʋ buloŋ aa kaŋ kyaŋsɩ ba kaŋ wɩɩla iriŋ iriŋ buloŋ, ba mʋ kaŋ ba ko Yesu lee dɩ ʋ tɩɩbɩ ba. Yesu kpa ʋ nosi dɔbɔ ba kɩdɩgɩ kɩdɩgɩ buloŋ tɩyaŋ ba na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gyɩŋbɔmɔ mɛ gyɩ lɩɩ nala tɩyaŋ yʋga, aa kɩ kyɩɩrɩ, a basɩ tɩya Yesu a baa, “Ɩ rɛ yaa Wɩɩsɩ Biye hʋ.” Ɛɛ rɛ Yesu nɔsɩ ba dɩ ba ta basɩ ʋ wɩya, beewɩya ba gyɩma anɩɩ ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ ko laa dʋnɩya nala ta. ");
INSERT INTO sig_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ʋ sɩgballɩnyʋwa, Yesu sii lɩɩ bee hʋ tɩyaŋ, a mʋ lee hʋ nala aa tuwo. Ɛɛ rɛ ka bee hʋ nala piili kɩ kyɛ ʋ. Ba aa ko na ʋ, ba kɩ lʋga dɩ ba kana ʋ biŋ dɩ ʋ ta bɩl mʋʋ lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ʋ maga dɩ ŋ mʋ tɔnɩ badɔmɔŋ mɛ rɛ, a basɩ Wɩɩsɩ koro hʋ wɩya doŋma mɛ. Beewɩya, ɛɛ wɩya rɛ Wɩɩsɩ tɩma ŋ, ŋ ko.” ");
INSERT INTO sig_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɛɛ rɛ ʋ gɔllɩ kɩ basɩ Wɩɩsɩ wɩya Gyudɩya paalʋʋ Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kyɛɛ kɩdɩgɩ Yesu gyɩ sɩŋ fuwo hʋ ba aa yɩrɩ Gɛnɛsarɛti nyʋwa tɩyaŋ nɛ, ka nɩgyamaa mʋ yige dɔmɔŋ kɩ ko ʋ lee dɩ ba nɩɩ Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Doŋ nɛ Yesu na nɩɩduworiborisi balɩya dɩ ba vʋwa nɩɩ hʋ nyʋwa. Ba tɩmma gyɩ kaŋ ko vʋwa rɛ, aŋ mʋ dɩ ba sasɩ ba gyoŋsi. ");
INSERT INTO sig_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ɛɛ rɛ Yesu mʋ gyʋʋ nɩɩduworiborisi hʋ kɩdɩgɩ aa yaa Siimɔŋ kɩŋ, aŋ leŋ ʋ yige ʋ bee boro hʋ we nɩɩ hʋ tɩyaŋ. Nyɛ rɛ Yesu hɔŋ nɩɩduworiboro hʋ tɩyaŋ aŋ kɩ daga nɩgyamaa hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ʋ aa basɩ wɩya tɩya nala hʋ ko teŋ, ʋ basɩ tɩya Siimɔŋ a baa, “Kuwosi nɩɩduworiboro hʋ dɩ ʋ mʋ liluŋii mʋhʋ, dɩ ɩ bee ɩ dɔŋtɩŋsɩ hʋ yuwo ma gyoŋsi, a kasɩ fuwonamɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ɛɛ rɛ Siimɔŋ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, á yuwo gyoŋsi rɛ dɩya tebine buloŋ, aŋ bɩ kaŋ kɩŋ buloŋ. Amɛ ʋ aa yaa ɩ kɛ aa baa dɩ ŋ yuwo wɩya, ŋ sɩ yuwo.” ");
INSERT INTO sig_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nyɛ rɛ ba yuwo ba gyoŋsi, a kasɩ fuwonamɩɩsɩ kɩŋkaŋ, ba gyoŋsi gba kɩ kyɛ dɩ ba pʋʋrɩ. ");
INSERT INTO sig_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dɩ ba dɔŋtɩŋsɩ badɔmɔŋ mɛ we nɩɩduworiboro kɩdɩgɩ tɩyaŋ. Ɛɛ rɛ ba kolli yɩrɩ ba dɩ ba ko kyiyeli ba. Ba ko kuwoni fuwonamɩɩsɩ hʋ, a su nɩɩduworiborisi hʋ balɩya buloŋ. Borisi hʋ su, a paalɩ kɩ kyɛ dɩ ba tuu nɩɩmemii. ");
INSERT INTO sig_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Siimɔŋ Piita aa naa wɩya hʋ buloŋ aa yaa, ʋ tuu gbinni Yesu sɩya tɩyaŋ aŋ baa, “Ŋ Tɩɩna, kɩ mʋ aŋ leme ŋ. Ŋ yaa wɩbɔŋyaal lɛ.” ");
INSERT INTO sig_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ɛɛ hʋ Piita bee ʋ nala hʋ aa kasɩ fuwonamɩɩsɩ hʋ, ʋ gyɩ yaa ba mɛ tɩɩ wɩkperii rɛ. ");
INSERT INTO sig_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dɩ Siimɔŋ dɔŋtɩŋsɩ Gyemsi abee Gyɔɔŋ mɛ fa we doŋ. Ba fa yaa Zebedi biibaala rɛ. Ba nyʋʋsɩ mɛ gyɩ fɩyɛla rɛ abee wɩya hʋ ba aa naa. Ɛɛ rɛ Yesu basɩ tɩya Siimɔŋ a baa, “Ta leŋ dɩ kambɩŋ kana ɩ. A lɩɩ gyɩnaŋ kɩ mʋ, ɩ sɩ kɩ kasɩ nihuwobisi anɩɩ ɩ fa aa kasɩ fuwonamɩɩsɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɛɛ hal tɩyaŋ nɛ, ba sii a kaŋ nɩɩduworiborisi hʋ tarɩ ko lɩɩ nɩɩ hʋ nyʋwa, a leŋ ba kɩŋ kɩŋ buloŋ ta doŋ, aŋ sii tɩŋ Yesu hal. ");
INSERT INTO sig_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɛɛ rɛ Yesu bɩl sii mʋ tɔɔ kɩdɩgɩ dɩ gbege kɩdɩgɩ rɛ gɛɛ. Ʋ aa naa Yesu, ʋ tuu gbinni ʋ sɩya tɩyaŋ a sʋla ʋ, a baa, “Ŋ nɩhɩyawʋ, dɩ ɩ rɛ kyo, ɩ sɩ wuwo tɩɩbɩ ŋ.” ");
INSERT INTO sig_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɛɛ rɛ Yesu kpa ʋ noŋ a dige ʋ aŋ baa, “Ŋ kyo rɛ. Deye.” Gbegisi hʋ pirigi leŋ baal hʋ. ");
INSERT INTO sig_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Doŋ nɛ Yesu basɩ tɩya ʋ abee sɩfɩyaŋ a baa, “Ta ko basɩ wɩɩ no kɩ tɩya nal buloŋ. Amɛ degini wɩɩkyʋwal sɩlaal lee, a kaŋ ɩ tɩɩ mʋ daga ʋ, dɩ ʋ lɩɩ wɩɩsʋlɩɩ, a pɩɩsɩ ɩ bisiŋ ta anɩɩ Moosi aa daga gɛɛ. Dɩ ɩ rɛ yaa gɛɛ, nal buloŋ sɩ na anɩɩ ɩ bɩl bɩ kaŋ bisiŋ.” ");
INSERT INTO sig_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aŋka wɩɩ hʋ ha vɩya aŋ marɩ taalɩ lee buloŋ a gyʋʋ mʋ. Nala yʋga kɩ ko ʋ lee dɩ ba nɩɩ ʋ wɩbasɩɩ, aŋka dɩ ʋ pɛ tɩɩbɩ ba mɛ. ");
INSERT INTO sig_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka Yesu aa sii mʋ lee hʋ nala aa tuwo, a kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kyɛɛ kɩdɩgɩ rɛ Yesu kɩ daga nala dɩ Farasiima abee Wɩɩsɩ Teŋ dɩdagɩla aa lɩɩ Galili paalʋʋ abee Gyudɩya paalʋʋ abee Gyerusalɛm buloŋ mɛ fa hɔŋ doŋ. Wɩɩsɩ gyɩ tɩya Yesu dee rɛ, ʋ gyɩ kɩ tɩɩbɩ wɩɩla tɩmma. ");
INSERT INTO sig_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɛɛ rɛ nala badɔmɔŋ mʋ kyʋŋ gbarɩgɩ kɩdɩgɩ abee ʋ wasa a ko, a kɩ lʋga dɩ ba kana ʋ gyʋʋ biŋ Yesu sɩya tɩyaŋ, dɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amɛ, akuu nala fa aa yʋga lee hʋ tɩyaŋ wɩya, ba gyɩ bɩ wuwo na ŋmanɩɩ dɩ ba kana ʋ gyʋʋ dɩya hʋ. Ɛɛ rɛ ba kana ʋ kaŋ gyɩŋ dɩya hʋ nyuu a luri lee, a kpa ʋ ta ʋ tɩŋ doŋ a tuu pɩŋ Yesu sɩya tɩyaŋ nɩgyamaa hʋ tʋtʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ba aa yaa gɛɛ rɛ Yesu na anɩɩ ba laa ʋ di rɛ weliŋ. Ɛɛ rɛ ʋ basɩ tɩya gbarɩgɩ hʋ a baa, “Ŋ bagyʋwa, ŋ kpa ɩ wɩbɔmɔ kyɛ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɛɛ rɛ Farasiima abee Wɩɩsɩ Teŋ dɩdagɩla hʋ piili kɩ bɩɩnɩ ba tɩsɩ tɩyaŋ a baa, “Kɩbee rɛ yaa nal no aa tʋʋsɩ Wɩɩsɩ nyɛ? Nal buloŋ bɩ sɩ wuwo kpa wɩbɔmɔ kyɛ nal, see Wɩɩsɩ dʋŋ.” ");
INSERT INTO sig_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ɛɛ rɛ Yesu wuwo gyɩŋ ba tɩbɩɩna a pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ bɩɩnɩ wɩya no ma tɩsɩ tɩyaŋ? ");
INSERT INTO sig_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ŋ aa sɩ baa dɩ ŋ kpaa ʋ wɩbɔmɔ kyɛ ʋ rɛ, abee ŋ aa sɩ baa dɩ ʋ sii kɩ vala, ba tɩyaŋ kɩbee basɩɩ rɛ yaa mɔl? ");
INSERT INTO sig_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ŋ sɩ daga ma anɩɩ mɩyaŋ Nihuwobiŋ Biye kaŋ dee rɛ dʋnɩya tɩyaŋ ŋ aa sɩ wuwo kpa wɩbɔmɔ kyɛ nala.” Ɛɛ rɛ ka ʋ basɩ tɩya gbarɩgɩ hʋ a baa, “Sii, a kpa ɩ wasa kɩ mʋ dɩya.” ");
INSERT INTO sig_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Doŋ nɛ gbarɩgɩ hʋ nyagɩ sii sɩŋ ba sɩya tɩyaŋ, a kpa ʋ wasa hʋ tɩyaŋ ʋ fa aa pɩna, a vala kɩ mʋ dɩya aŋ kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wɩɩ hʋ yaa nala hʋ buloŋ fa aa we doŋ wɩkperii. Kambɩŋ gyʋʋ ba, ba dannɩ Wɩɩsɩ a baa, “Á naa wɩkperiye rɛ gyɩnaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɛɛ hal tɩyaŋ nɛ Yesu sii lɩɩ a na lampolaal kɩdɩgɩ ba aa yɩrɩ Levi dɩ ʋ hɔŋ ʋ tʋŋtʋnnɩ dɩya tɩyaŋ. Nyɛ rɛ Yesu basɩ tɩya ʋ a baa, “Sii ko kɩ tɩŋa ŋ hal.” ");
INSERT INTO sig_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɛɛ rɛ Levi sii, a leŋ ʋ kɩŋ kɩŋ buloŋ ta doŋ aŋ kɩ tɩŋa ʋ hal. ");
INSERT INTO sig_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɛɛ hal tɩyaŋ, Levi gyɩ leŋ ba marɩ kɩdiiliye yʋga ʋ dɩya tɩyaŋ a tɩya Yesu, a yɩrɩ nɩgyamaa mɛ. Nɩgyamaa hʋ ʋ gyɩ aa yɩra tɩyaŋ, lampolaala yʋga gyɩ we ba tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ɛɛ rɛ Farasiima badɔmɔŋ abee Wɩɩsɩ Teŋ dɩdagɩla mɛ aa yaa Farasiima sii ko, a pɩyɛsɩ Yesu hatɩnna hʋ a baa, “Bee rɛ tɩŋ ma bee lampolaala abee wɩbɔŋyaala buloŋ laŋŋɩ hɔŋ kɩ di kɩna?” ");
INSERT INTO sig_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu nɩɩ ba aa basɩ gɛɛ, a basɩ tɩya ba a baa, “Nala hʋ aa kaŋ laaŋfɩya, ba bee kyɛ tɩɩba tɩɩna, see nala hʋ aa wɩɩlɩ. ");
INSERT INTO sig_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ŋ ko dɩ ŋ yɩrɩ wɩbɔŋyaala rɛ dɩ ba leŋ ba wɩbɔmɔ. Ŋ bɩ ko dɩ ŋ yɩrɩ tɩpʋlʋŋ tɩmma.” ");
INSERT INTO sig_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɛɛ rɛ nala badɔmɔŋ ko pɩyɛsɩ Yesu a baa, “Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ hatɩnna aa kɩ vʋwa nyʋwa rɛ, a kɩ kyʋwalɩ Wɩɩsɩ mɛ saŋa buloŋ. Farasiima hatɩnna mɛ kɩ yaa gɛɛ tɩɩ. Amɛ ɩ hatɩnna kɛ bee vʋwa nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Dɩ nal lɛ kpaa haaŋ, dɩ ʋ bee ʋ kyaŋsɩ kɩ gbɩyalɩ hafalɩɩ hʋ gbɩyala, ʋ kyaŋsɩ hʋ sɩ wuwo vʋwa nyʋwa? Aayɩ, ba bɩ sɩ wuwo vʋwa nyʋwa. ");
INSERT INTO sig_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amɛ saŋa kɩdɩgɩ rɛ sɩ pele, dɩ ba kaŋ hafalɩɩ bala hʋ mʋ lee kɩdɩgɩ. Ɛɛ tɩyaŋ nɛ ʋ kyaŋsɩ hʋ yaŋ sɩ vʋwa nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɛɛ rɛ ʋ bɩl maga namaga no tɩya ba a baa, “Nal buloŋ bɩ sɩ lɔgɔ taŋfalɩɩ a kpa ala tɔ gabɩnɩɩ bol. Dɩ ɩ rɛ yaa gɛɛ, ɩ sɩ kyogi gafalɩɩ hʋ, ka dɩ taŋfalɩɩ hʋ bee gabɩnɩɩ hʋ mɛ bɩ sɩ kɩɩ dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɛɛ tɩɩ rɛ nal mɛ bɩ sɩ kpa sɩhuwo a we pulbɩnɩɩ tɩyaŋ. Dɩ ɩ rɛ yaa gɛɛ, pul hʋ sɩ pɔsɔ, dɩ sɩŋ hʋ buloŋ bɩsɩ ta. ");
INSERT INTO sig_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sɩhuwo maga dɩ ɩ kpa we viiweliye tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dɩ nal lɛ aa nyʋwa sɩwiilii, ʋ bɩl bɩ sɩ kɩ kyɛ dɩ ʋ nyʋwa sɩhuwo, beewɩya tɩɩna aa baa dɩ sɩwiilii rɛ weliye te sɩhuwo.” ");
INSERT INTO sig_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kyɛwiyesii hʋ kyɛɛ kɩdɩgɩ, Yesu bee ʋ hatɩnna hʋ gyɩ sii mʋ tɩŋ nyoŋso baga kɩdɩgɩ tɩyaŋ nɛ a kɩ mʋ. Ɛɛ rɛ ʋ hatɩnna hʋ bori nyoŋso hʋ, a piisi kɩ kyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dɩ Farasiima badɔmɔŋ mɛ gyɩ we doŋ a na ba. Doŋ nɛ ba pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ yaa nyɛ? Kyɛwiyesii hʋ kyɛɛ sɩna daa ma kɩ kyogi gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ma ha bɩ karɩma na wɩɩ hʋ Deviti gyɩ aa yaa? ");
INSERT INTO sig_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Losi gyɩ kaŋ ʋ bee ʋ hatɩnna rɛ, ʋ gyɩ mʋ gyʋʋ Wɩɩsɩ dɩya hʋ, a kpa paanʋʋ hʋ ba fa aa kaŋ ko sʋla Wɩɩsɩ, a lɔgɔ kyaŋ aŋ kpa tɩya ʋ hatɩnna hʋ mɛ, ba mɛ laa kyaŋ. Ʋ fa yaa sɩna rɛ anɩɩ nɩwaasɩ aa sɩ kpa haŋ paanʋʋ hʋ dige ʋ nyʋwa, see wɩɩkyʋwal sɩlaala dʋŋ, ka Deviti bee ʋ nala hʋ gyɩ kyaŋ ba gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ka Yesu yaŋ basɩ tɩya ba a baa, “Mɩyaŋ Nihuwobiŋ Biye rɛ yaa Kyɛwiyesii hʋ kyɛɛ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kyɛwiyesii hʋ kyɛɛ kɩdɩgɩ Yesu bɩl sii gyʋʋ Gyuuma wɩɩkyʋwaldɩya, a kɩ daga nala, dɩ baal kɩdɩgɩ mɛ gyɩ we doŋ, ʋ noduu noŋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima badɔmɔŋ mɛ gyɩ we doŋ. Ba gyɩ aa kyɛ wɩɩ rɛ dɩ ba tɩŋ gɛɛ tɩyaŋ a kaŋ Yesu, a baa dɩ ʋ kyogo ba sɩŋsɩ rɛ. Ɛɛwɩya, ba buloŋ gyɩ lɩɩ sɩya pɔ ʋ tɩyaŋ, dɩ ba na dɩ ʋ sɩ tɩɩbɩ baal hʋ Kyɛwiyesii hʋ kyɛɛ rɛ koo? ");
INSERT INTO sig_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amɛ Yesu fa gyɩŋ ba tɩbɩɩna buloŋ nɛ. Ɛɛ rɛ ʋ basɩ tɩya nosʋʋ hʋ tɩɩna a baa dɩ ʋ sii ko lɩɩ sɩŋ ba sɩya tɩyaŋ. Nyɛ rɛ baal hʋ sii mʋ lɩɩ sɩŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Doŋ nɛ Yesu pɩyɛsɩ ba a baa, “Ɛɛ rɛ Wɩɩsɩ mɩrɩsɩ hʋ daga dɩ á kɩ yaa Kyɛwiyesii hʋ kyɛɛ? Dɩ á kɩ kyiyeli nala koo dɩ á kɩ dɔgɩsɩ ba? Dɩ á kɩ laa nala mɩɩbolo koo dɩ á kɩ kpʋ ba?” ");
INSERT INTO sig_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu aa basɩ gɛɛ, ʋ mɩɩgɩ deŋ nala hʋ aa hɔŋ doŋ buloŋ aŋ basɩ tɩya nosʋʋ hʋ tɩɩna dɩ ʋ kaŋ ʋ noŋ tannɩ. Ʋ kaŋ tannɩ. Nosʋʋ hʋ mɩɩgɩ kɩɩ kɩduwo hʋ. ");
INSERT INTO sig_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yesu aa yaa gɛɛ, nala hʋ buloŋ baaŋ sii kɩŋkaŋ. Ba kɩ vʋʋlɩ wɩɩ hʋ ba aa sɩ yaa ʋ. ");
INSERT INTO sig_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kyɛɛ kɩdɩgɩ Yesu sii mʋ gyɩŋ dogimo kɩdɩgɩ nyuu dɩ ʋ kyʋwalɩ Wɩɩsɩ. Ʋ we doŋ, a kyʋwalɩ Wɩɩsɩ gɛɛ deŋdeŋ sɩya mʋ gballɩ. ");
INSERT INTO sig_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sɩya aa gballa, ʋ yɩrɩ ʋ hatɩnna buloŋ ba ko ʋ lee. Ɛɛ rɛ ʋ lɩɩ ba tɩyaŋ nala fi abee balɩya dɩ ba yaa ʋ kpambɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nala hʋ ʋ gyɩ aa lɩya rɛ nyɛ: Siimɔŋ (Yesu fa kana ʋ kɩ yɩrɩ Piita rɛ) abee ʋ naabiibaal Aŋduru, abee Gyemsi abee Gyɔɔŋ abee Fɩlɩpɩ abee Batolomi ");
INSERT INTO sig_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","abee Matiwu abee Tɔmaasɩ abee Alfiyasɩ biibaal Gyemsi, abee Siimɔŋ, nal hʋ aa kyɩl ʋ nala wɩya kɩŋkaŋ, ");
INSERT INTO sig_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","abee Gyemsi biibaal Gyudasɩ, abee Gyudasɩ Isɩkarɔtɩ, nal hʋ aa ko yaa minaafigi tɩɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɛɛ rɛ Yesu bee ʋ kpambɩsɩ hʋ sii lɩɩ dogimo hʋ nyuu ko tuu, dɩ ʋ hatɩnna badɔmɔŋ mɛ sɩŋ dogimo hʋ naasɩ tɩyaŋ. Nɩgyamaa mɛ gyɩ sɩŋ doŋ, ba badɔmɔŋ gyɩ lɩɩ Gyudɩya paalʋʋ rɛ, ba badɔmɔŋ mɛ gyɩ lɩɩ Gyerusalɛm, ba badɔmɔŋ mɛ gyɩ lɩɩ Taaya bee Siidɔŋ aa kpaga fuwobal hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nala no buloŋ gyɩ ko dɩ ba gyegili nɩɩ wɩya hʋ Yesu aa basɩ rɛ aŋ ka dɩ ʋ tɩɩbɩ ba. Nala badɔmɔŋ mɛ gyɩŋbɔmɔ aa kana mɛ gyɩ ko rɛ dɩ Yesu tɩɩbɩ ba. ");
INSERT INTO sig_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nala hʋ buloŋ gyɩ aa we doŋ kɩ lʋga dɩ ba dige ʋ, beewɩya ba gyɩ naa anɩɩ dee kɩdɩgɩ rɛ aa lɩɩ ʋ tɩyaŋ, a leŋ nala buloŋ kɩ na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nyɛ rɛ Yesu mɩɩgɩ deŋ ʋ hatɩnna hʋ aŋ baa, “Nyusʋŋtɩmma rɛ yaa ma nala hʋ a yaa nyaaba, mamaa rɛ sɩ gyʋʋ Wɩɩsɩ koro hʋ. ");
INSERT INTO sig_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nyusʋŋtɩmma rɛ yaa ma nala hʋ losi aa kpʋʋ gyɩnaŋ, Wɩɩsɩ sɩ leŋ dɩ ma vɔgɔ. Nyusʋŋtɩmma rɛ yaa ma nala hʋ aa wii gyɩnaŋ, Wɩɩsɩ sɩ leŋ dɩ ma mʋma. ");
INSERT INTO sig_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nyusʋŋtɩmma rɛ yaa ma nala hʋ ba aa haasa, a lɩɩ ma kɩ ta nala tɩyaŋ a kɩ tʋʋsɩ ma a kɩ kyogi ma feŋ aŋ baa dɩ ma yaa nɩbɔmɔ rɛ, akuu ma aa tɩŋ mɩyaŋ Nihuwobiŋ Biye hal wɩya. ");
INSERT INTO sig_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dɩ gɛɛ rɛ ko puu ma, ma leŋ dɩ ma tenni fɩyɛlɩ, dɩ ma kɩ gʋwa a kɩ gyʋwɔsɩ, beewɩya ma tuno yʋga rɛ a pɩŋ wɩɩsɩbee tɩyaŋ. Ɛɛ tɩɩ rɛ ba naabaala mɛ gyɩ dɔgɩsɩ Wɩɩsɩ tɩŋdaala hʋ gyɩ aa laa sɩya ko. ");
INSERT INTO sig_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amɛ ma nala hʋ aa yaa kɩna tɩmma gyɩnaŋ, ma sɩ na tʋwara beewɩya ma laa sɩya di ma sʋma buloŋ teŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ma nala hʋ mɛ aa vɔgɔ gyɩnaŋ, ma mɛ sɩ na tʋwara dɩ losi kpʋ ma. Ma nala hʋ mɛ aa mʋŋ gyɩnaŋ, ma sɩ na tʋwara. Ma tɩsɩ sɩ kyogi, dɩ ma wii sɩnɩɩl. ");
INSERT INTO sig_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dɩ dʋnɩya nala buloŋ nɛ ko kɩ bigisi ma, ma gyɩma anɩɩ tʋwara tɩyaŋ nɛ ma we gɛɛ, beewɩya, ɛɛ tɩɩ rɛ ba naabaala gyɩ kɩ bigisi nala hʋ gyɩ aa nyɩya wɩya baa dɩ ba yaa Wɩɩsɩ tɩŋdaala rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Amɛ ma nala no aa we daha, a gyegili kɩ nɩɩ ŋ wɩbasɩɩ no, ma leŋ dɩ ŋ basɩ tɩya ma, ma kyo ma dɔmɔ aŋ yaa wɩweliye kɩ tɩya nala hʋ aa haasɩ ma. ");
INSERT INTO sig_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma sʋl Wɩɩsɩ kɩ tɩya nal buloŋ aa basɩ wɩbɔmɔ kɩ tɩya ma, aŋ kyʋwalɩ Wɩɩsɩ kɩ tɩya nala hʋ buloŋ aa dɔgɩsɩ ma. ");
INSERT INTO sig_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dɩ nal lɛ ŋmaa ɩ nogɔbɔ kyaŋkpaŋ, kaŋ ɩ noduu kyaŋkpaŋ mɛ tɩya ʋ dɩ ʋ ŋmaa. Dɩ nal lɛ kaŋ ɩ gabal fasɩ, wuri ɩ gabiye mɛ pɛ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dɩ nal lɛ ko sʋla ɩ kɩŋ, kpa tɩya ʋ. Dɩ nal mɛ rɛ kyɩma ɩ kɩŋ, ta pɩyɛsɩ ʋ laa. ");
INSERT INTO sig_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wɩya hʋ ma aa kyɛ dɩ nala kpa kɩ yaa ma, ma mɛ kpa ba tɩɩ kɩ yaa nala. ");
INSERT INTO sig_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dɩ mamaa rɛ kyo nala hʋ aa kyo ma dʋŋ, ma bɩ kaŋ tuno buloŋ Wɩɩsɩ lee, beewɩya wɩbɔŋyaala mɛ gba kyo nala hʋ aa kyo ba rɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dɩ mamaa rɛ yaa wɩweliye kɩ tɩya nala hʋ aa yaa wɩweliye kɩ tɩya ma dʋŋ, ma bɩ kaŋ tuno buloŋ Wɩɩsɩ lee, beewɩya wɩbɔŋyaala mɛ gba aa yaa gɛɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dɩ mamaa rɛ kpaa kɩna kɩ kyɩŋ nala hʋ ma aa gyɩma anɩɩ ba sɩ wuwo tuŋ tɩya ma dʋŋ, ma bɩ kaŋ tuno buloŋ Wɩɩsɩ lee, beewɩya wɩbɔŋyaala mɛ gba aa kpa kɩna kyɩŋ ba dɔŋtɩŋsɩ rɛ aŋ kɩ yɩyɛlɩ dɩ ba mɩɩgɩ tuŋ gɛɛ tɩɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amɛ wɩya hʋ ŋ aa kyɛ dɩ ma kɛ kɩ yaa rɛ nyɛ: Ma kyo ma dɔmɔ, a yaa wɩweliye kɩ tɩya ba, a kɩ kyɩŋ ba kɩna aŋ ta kɩ yɩyɛla dɩ ba tuŋ ma. Dɩ mamaa rɛ ko kɩ yaa nyɛ, ma tuno bɩ sɩ kyallɩ Wɩɩsɩ lee, ka dɩ Wɩɩsɩ ha leŋ dɩ ma yaa ʋ Wɩɩbal hʋ tɩɩ balɩya. Beewɩya tahaa tɩmma abee nɩbɔmɔ buloŋ nɛ Wɩɩsɩ yaa wɩweliye kɩ tɩya. ");
INSERT INTO sig_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ma kɩ fá nala sikii anɩɩ ma Kuwo Wɩɩsɩ aa fá nala sikii gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ta dii ɩ dɔŋtɩɩna sarɩya, dɩ Wɩɩsɩ mɛ ta dii ɩ sarɩya. Ta kpaa kyogisi tɩya ɩ dɔŋtɩɩna dɩ Wɩɩsɩ mɛ ta kpaa kyogisi tɩya ɩ. Ma kpa wɩya kɩ kyɛ ma dɔŋtɩŋsɩ. Dɩ mamaa rɛ aa yaa gɛɛ, Wɩɩsɩ mɛ sɩ kpa wɩya kɩ kyɛ ma. ");
INSERT INTO sig_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma kpa kɩna kɩ tɩya nala. Dɩ mamaa rɛ aa yaa gɛɛ, Wɩɩsɩ mɛ sɩ kpa kɩna kɩ tɩya ma. Ʋ sɩ magɩsɩ kɩna a su kɩŋ yurutu, a nyagɩ we, ka dɩ ba ha yuwori kɩ tuu, dɩ ʋ kpa tɩya ma. Amɛ kɩŋ hʋ ɩ aa kaŋ magɩsɩ kɩna tɩya ɩ dɔŋtɩɩna, ʋ tɩɩ rɛ Wɩɩsɩ mɛ sɩ kaŋ magɩsɩ tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ɛɛ rɛ Yesu bɩl maga namaga tɩya ba a baa, “Nyʋlʋŋ bɩ sɩ wuwo kaŋ ʋ dɔŋtɩɩna nyʋlʋŋ daaŋ. Dɩ ʋ rɛ yaa gɛɛ, ba buloŋ balɩya sɩ tele bootogi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nal hʋ aa gʋnnɩ wɩɩ bɩ sɩ wuwo te nal hʋ aa daga ʋ, amɛ dɩ ʋ rɛ ko gʋnnɩ wɩɩ hʋ teŋ, ʋ mɛ aa kɩɩ nal hʋ aa daga ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ɛɛ rɛ ɩ sɩ yaa na gyagɩŋ hʋ aa we ɩ dɔŋtɩɩna sɩɩ tɩyaŋ, aŋ bɩ naa daakuu hʋ aa we ɩ tɩɩ sɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɛɛ rɛ ɩ sɩ yaa baa dɩ ɩ dɔŋtɩɩna leŋ dɩ ɩ lɩɩ gyagɩŋ hʋ aa we ʋ sɩɩ tɩyaŋ ta tɩya ʋ, aŋ bee na daakuu hʋ kɛ aa gɩrɩga ɩ tɩɩ sɩɩ tɩyaŋ. Ɛɛdɔŋ minaafigi tɩɩna kɩdɩgɩ! Laasɩya lɩɩ daakuu hʋ aa we ɩ tɩɩ sɩɩ tɩyaŋ, ka dɩ ɩ wuwo kɩ na weliŋ, a na lɩɩ gyagɩŋ hʋ aa we ɩ dɔŋtɩɩna sɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ɛɛ rɛ Yesu bɩl maga namaga tɩya ba a baa, “Tɩya hʋ aa bee wɩɩlɩ, ʋ bee nɔŋ nɔŋbɔŋlɔrɩnɩ. Ɛɛ rɛ tɩya hʋ mɛ aa kaŋ wɩɩla, ʋ mɛ bee nɔŋ nɔŋweliye. ");
INSERT INTO sig_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tɩya nɔnɔ rɛ aa daga tɩya hʋ doho ʋ aa yaa. Sɔgyaŋ bee nɔŋ tutogo nɔnɔ, kanɩɩ mɛ bee nɔŋ babɩlɩya. ");
INSERT INTO sig_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Niwelii aa kaŋ tɩbɩɩŋweliye rɛ ʋ tɩya tɩyaŋ, ɛɛ rɛ tɩŋ ʋ kɩ yaa wɩweliye. Nɩbɔŋ mɛ aa kaŋ tɩbɩɩŋbɔmɔ rɛ ʋ tɩya tɩyaŋ, ɛɛ rɛ tɩŋ ʋ mɛ kɩ yaa wɩbɔmɔ. Beewɩya, wɩɩ hʋ aa we ɩ tɩya tɩyaŋ, ʋ rɛ ɩ nyʋwa kɩ basɩ.” ");
INSERT INTO sig_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ɛɛ rɛ Yesu bɩl baa, “Bee rɛ tɩŋ ma kɩ yɩrɩ ŋ ma Tɩɩna, aŋ bee yaa wɩya hʋ ŋ aa basɩ kɩ tɩya ma? ");
INSERT INTO sig_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nal hʋ buloŋ aa ko ŋ lee a gyegile nɩɩ ŋ wɩbasɩya, a kɩ tɩŋ ba, ŋ sɩ daga ma gɛɛ ʋ tɩɩna aa kɩya. ");
INSERT INTO sig_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ʋ kɩɩ gɛɛ rɛ anɩɩ nal aa kyɛ dɩ ʋ saa dɩya, a hulo dɩya hʋ memii ʋ tuu yɩ bʋyɩ, ka ʋ na saa. Ɛɛ rɛ duwoŋ ko nɩɩ, fuwo su gbarɩ, nɩɩ ko gyɩŋ sɩna dɩya hʋ, ka ʋ bɩ gyigise mɛ gba, beewɩya, ba saa ʋ weliŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amɛ nal hʋ aa gyegile nɩɩ ŋ wɩbasɩya aŋ bee tɩŋ ba, ʋ tɩɩna kɩɩ gɛɛ rɛ anɩɩ nal hʋ aa saa ʋ dɩya, aŋ bɩ hulo dɩya hʋ memii ʋ tuu aŋ saa dɩya hʋ. Ɛɛ rɛ duwoŋ ko nɩɩ, fuwo su gbarɩ, nɩɩ ko gyɩŋ sɩna dɩya hʋ, ʋ tele wuroo, a muŋsi ʋ buloŋ muno muno.” ");
INSERT INTO sig_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu aa basɩ wɩya no buloŋ a tɩya nala hʋ ko teŋ, ʋ sii mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Kapɛɛnam. ");
INSERT INTO sig_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma tɩmma laalyuwolo nɩhɩyawʋ kɩdɩgɩ rɛ gyɩ we doŋ, a kaŋ ʋ dɩya tʋŋtʋnnɩ, a fa kyo ʋ wɩya weliŋ. Ɛɛ rɛ ʋ dɩya tʋŋtʋnnɩ hʋ sii kɩ wɩɩlɩ, a pɩŋ kɩ kyɛ dɩ ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Laalyuwolo nɩhɩyawʋ hʋ aa nɩɩ Yesu wɩya, ʋ sii lɩɩ Gyuuma nɩhɩyasɩ badɔmɔŋ dɩ ba mʋ sʋla ʋ dɩ ʋ ko tɩɩbɩ ʋ tʋŋtʋnnɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nyɛ rɛ ba sii mʋ Yesu lee a sʋla ʋ abee sɩfɩyasɩ buloŋ a baa, “Baal no yaa nɩtɩɩ rɛ. Ʋ maga dɩ ɩ pɛ ʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ʋ kyo á nala rɛ weliŋ, haalɩ a gba saa á wɩɩkyʋwaldɩya tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɛɛ rɛ Yesu kpa tɩŋ ba hal kɩ mʋ. Ba aa mʋ kpaga laalyuwolo nɩhɩyawʋ hʋ dɩya, ʋ tɩma ʋ kyaŋsɩ dɩ ba ko lɩɩ basɩ tɩya Yesu a baa, “Ŋ nɩhɩyawʋ, ta dɔgɩsɩ ɩ tɩɩ ko ŋ dɩya. Ŋ bɩ maga dɩ ɩ ko gyʋʋ ŋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ŋ tɩɩ mɛ gba bɩ maga dɩ ŋ ko ɩ lee. Amɛ dɩ ɩ yaŋ suri ɩ nyʋwa a baa dɩ ŋ tʋŋtʋnnɩ hʋ deye mɛ, ka ʋ sɩ deye. ");
INSERT INTO sig_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ŋ mɛ aa tɩŋ ŋ nɩhɩyasɩ nyʋwa rɛ, ka laalyuwolo badɔmɔŋ mɛ yaa ŋ noŋ nala, a mɛ kɩ tɩŋa ŋ nyʋwa. Dɩ mɩyaŋ nɛ baa dɩ kɩdɩgɩ mʋ daha, ʋ aa mʋʋ rɛ. Dɩ ŋ bɩl baa kɩdɩgɩ mɛ ko daha, ʋ aa ko rɛ. Dɩ mɩyaŋ nɛ basɩ tɩya ŋ tʋŋtʋnnɩ dɩ ʋ yaa wɩɩ no, ʋ aa yaa rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu aa nɩɩ wɩya no, ʋ nyʋwa fɩyɛlɩ kɩŋkaŋ. Doŋ nɛ ʋ mɩɩgɩ galdaasɩ ʋ hal a basɩ tɩya nɩgyamaa hʋ fa aa tɩŋa ʋ hal a baa, “Ŋ ha bɩ naa nal aa laa Wɩɩsɩ di nyɛ Iziral tɩmma tɩɩ mɛ gba tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nyɛ rɛ tɩŋdaala hʋ mɩɩgɩ kpa mʋ laalyuwolo nɩhɩyawʋ hʋ dɩya, dɩ ʋ tʋŋtʋnnɩ hʋ kɔnɩ deye. ");
INSERT INTO sig_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɛɛ hal tɩyaŋ nɛ Yesu kpa mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Neeŋ. Ʋ hatɩnna hʋ bee nɩgyamaa mɛ gyɩ sii tɩŋa ʋ hal mʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ʋ gyɩ aa mʋʋ kɩ pele bee hʋ, ʋ naa dɩ nɩgyamaa mʋʋ kɩ ko gɛɛ bilili, a kpa bapʋwasɩɩ kɩdɩgɩ aa sʋba, a kaŋ kɩ mʋ dɩ ba hogo. Bapʋwasɩɩ no dʋŋ nɛ ʋ naa gyɩ lʋla, ka ʋ naa hʋ mɛ yaa lohaaŋ. ");
INSERT INTO sig_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Á tɩɩna Yesu aa naa haaŋ hʋ, sikii buloŋ kana ʋ. Ʋ basɩ tɩya ʋ a baa “Ta kɩ wiye.” ");
INSERT INTO sig_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ɛɛ rɛ ka ʋ kpa mʋ, a dige sʋʋdaga hʋ. Nala hʋ fa aa kyʋŋ daga hʋ mɩɩgɩ sɩŋ. Ɛɛ rɛ Yesu basɩ tɩya sʋʋ hʋ a baa, “Bapʋwasɩbiye, sii.” ");
INSERT INTO sig_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Doŋ nɛ baal hʋ sii hɔŋ, a piili kɩ basɩ wɩya. Ɛɛ rɛ Yesu kpa ʋ tɩya ʋ naa. ");
INSERT INTO sig_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kambɩŋ kaŋ nala hʋ buloŋ, ba kɩ dannɩ Wɩɩsɩ a baa, “Wɩɩsɩ tɩŋdaalbal lɛ ko tuu á lee nyɛ. Wɩɩsɩ rɛ ko dɩ ʋ laa ma ta.” ");
INSERT INTO sig_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wɩɩ no Yesu aa yaa gyɩ taalɩ Gyudɩya paalʋʋ abee tɔbiisi hʋ aa gol doŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nyɛ rɛ Gyɔɔŋ hatɩnna basɩ wɩya no buloŋ Yesu aa yaa a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ɛɛ rɛ Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ yɩrɩ ba tɩyaŋ nala balɩya, a tɩŋ ba dɩ ba mʋ á Tɩɩna Yesu lee, a pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa nal hʋ Gyɔɔŋ aa baa dɩ ʋ sɩ ko hʋ, koo á ha kɩ gyegili nɩdɩma?” ");
INSERT INTO sig_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba aa ko Yesu lee, ba basɩ tɩya ʋ a baa, “Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ rɛ tɩŋ ma dɩ á ko pɩyɛsɩ ɩ anɩɩ ɩ rɛ yaa nal hʋ ʋ aa baa dɩ ʋ sɩ ko hʋ, koo á ha kɩ gyegili nɩdɩma?” ");
INSERT INTO sig_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Haŋ saŋa hʋ tɩɩ tɩyaŋ dɩ Yesu tɩɩbɩ wɩɩla tɩmma yʋga, a kile gyɩŋbɔmɔ mɛ ta nala tɩyaŋ, aŋ suri nyʋlɩma mɛ yʋga sɩya. ");
INSERT INTO sig_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɛɛ rɛ Yesu basɩ tɩya Gyɔɔŋ hatɩnna hʋ a baa, “Ma mɩɩgɩ mʋ a basɩ tɩya Gyɔɔŋ wɩya hʋ buloŋ ma aa nɩya abee wɩya hʋ buloŋ ma aa naa. Nyʋlɩma sɩya aa suri rɛ, gbarɩga kɩ vala, gbegisi kɩ deye. Wonni kɩ nɩɩ wɩya. Nala aa sʋba kɩ sii sʋʋ tɩyaŋ. Nyaaba mɛ kɩ nɩɩ Wɩɩsɩ wɩweliye hʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nyusʋŋtɩmma rɛ yaa nala hʋ aa bee yaa ŋ sige.” ");
INSERT INTO sig_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ɛɛ rɛ Gyɔɔŋ hatɩnna hʋ mɩɩgɩ kpa mʋ, ka Yesu piili basɩ Gyɔɔŋ wɩya kɩ tɩya nɩgyamaa hʋ. Ʋ gyɩ pɩyɛsɩ ba rɛ a baa, “Ma gyɩ aa lɩɩ mʋ Gyɔɔŋ lee pogo hʋ tɩyaŋ, bekiŋ nɛ ma fa liisi anɩɩ ma sɩ na? Ma gyɩ mʋʋ dɩ ma na ɔhɔ puwo aa kaŋ kɩ gyiyegi rɛ koo? ");
INSERT INTO sig_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bekiŋ nɛ ma gyɩ yaŋ lɩɩ mʋ dɩ ma na? Ma gyɩ lɩɩ mʋ dɩ ma na nal aa laalɩ gaweliye rɛ koo? Aayɩ, beewɩya nala hʋ aa laalɩ gaweliye, ba aa hɔŋ kuworidɩɩsɩ tɩyaŋ nɛ, a kɩ nɩɩ sʋma. ");
INSERT INTO sig_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma yaŋ daga ŋ kɩŋ hʋ ma gyɩ aa lɩɩ mʋ dɩ ma na. Ma gyɩ lɩɩ mʋ dɩ ma na Wɩɩsɩ tɩŋdaal lɛ koo? Ŋ basɩ kɩ tɩya ma rɛ anɩɩ nal hʋ ma gyɩ aa mʋʋ na hʋ, ʋ tee Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Haŋ Gyɔɔŋ hʋ wɩya rɛ ba sabɩ biŋ Wɩɩsɩ teŋ tɩyaŋ, a baa dɩ Wɩɩsɩ baa, ‘Ŋ sɩ tɩma ŋ tɩŋdaal dɩ ʋ laa ɩ sɩya a mʋ a marɩ ɩ ŋmanɩɩ bin-ɩ.”’ ");
INSERT INTO sig_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Gyɔɔŋ nɛ tee nihuwobiŋ buloŋ ba aa lʋla. Amɛ nal hʋ aa yaa nɩbiye Wɩɩsɩ koro hʋ tɩyaŋ, ʋ rɛ tee Gyɔɔŋ.” ");
INSERT INTO sig_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nala hʋ buloŋ gyɩ nɩɩ wɩya hʋ Yesu aa basa rɛ. Nala no buloŋ gyɩ tɩŋ Wɩɩsɩ nyʋwa hʋ Gyɔɔŋ gyɩ aa daga rɛ, haalɩ ba bee lampolaala buloŋ, beewɩya ba gyɩ leŋ Gyɔɔŋ fo ba wɩɩkyʋwalnɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amɛ Farasiima abee Wɩɩsɩ Teŋ dɩdagɩla hʋ kɛ gyɩ vɩya Wɩɩsɩ nyʋwa rɛ, beewɩya ba gyɩ bɩ leŋ Gyɔɔŋ gyɩ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ɛɛ rɛ Yesu bɩl baa, “Bekiŋ nɛ ŋ sɩ kpa gyɩnaŋ nala magɩsɩ? Ɛɛ rɛ ba kɩɩ? ");
INSERT INTO sig_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba kɩɩ gɛɛ rɛ anɩɩ biibiisi aa gbɩyalɩ bee tɩyaŋ, a nɔsɩ basɩ kɩ tɩya dɔmɔŋ a baa, ‘Á mʋʋ loŋbiye tɩya ma rɛ, ka ma vɩya gʋwayɩ, á yɩɩ haŋyee mɛ tɩya ma, ka ma vɩya wiyi’ ");
INSERT INTO sig_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Saŋa hʋ tɩyaŋ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ gyɩ aa ko ma lee, ʋ gyɩ aa vʋwa nyʋwa rɛ a bee nyʋwa sɩŋ mɛ. Ɛɛ rɛ ma baa dɩ gyɩŋbɔŋ nɛ kana ʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aŋka Mɩyaŋ Nihuwobiŋ Biye kɛ ko ma lee, a kɩ di kɩna aŋ kɩ nyʋwa sɩŋ mɛ. Ɛɛ rɛ ma basɩ tɩya dɔmɔŋ a baa dɩ baal no kɛ yaa laboriŋ tɩɩna rɛ, a yaa sɩnyʋwal mɛ, aŋ pɛ kaŋ lampolaala abee wɩbɔŋyaala buloŋ yaa ʋ kyaŋsɩ. ");
INSERT INTO sig_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nala hʋ aa kaŋ wɩgyʋŋ hʋ aa lɩɩ Wɩɩsɩ lee, ba wɩyaalɩya rɛ aa daga anɩɩ ba wɩgyʋŋ hʋ kɔnɩ lɩɩ Wɩɩsɩ lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kyɛɛ kɩdɩgɩ Farasii kɩdɩgɩ yɩrɩ Yesu dɩ ʋ ko ʋ dɩya di kɩna. Yesu mʋ a hɔŋ dɩ ʋ di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dɩ hasɔŋsɔnnɩ kɩdɩgɩ mɛ gyɩ we tɔɔ hʋ tɩyaŋ. Haaŋ no gyɩ aa nɩɩ Yesu wɩya anɩɩ ʋ we Farasii hʋ dɩya tɩyaŋ a kɩ di kɩna, ʋ sii kpa pʋrʋŋtʋwa bee tʋranɩɩ a kaŋ mʋ gyʋʋ dɩya hʋ. ");
INSERT INTO sig_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Haaŋ hʋ aa ko gyʋʋ dɩya hʋ, ʋ mʋ sɩŋ Yesu hal, aŋ wii sɩnɩɩl kɩ we ʋ naasɩ tɩyaŋ. Sɩnɩɩl hʋ aa tuu Yesu naasɩ tɩyaŋ gɛɛ, ʋ kaŋ ʋ nyupʋna tɩɩgɩ tɩɩgɩ, aŋ tuu gbinni, a kaŋ Yesu naaŋ tɩyaŋ, aŋ kpa tʋranɩɩ hʋ bɩsɩ we ʋ naasɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dɩya hʋ tɩɩna aa naa wɩɩ no haaŋ hʋ aa yaa, ʋ hɔŋ kɩ liisi ʋ tɩya tɩyaŋ a baa, “Dɩ baal no fa kɔnɩ yaa Wɩɩsɩ tɩŋdaal, ʋ fa sɩ gyɩma anɩɩ haaŋ no aa dige ʋ hʋ yaa wɩbɔŋyaal lɛ.” ");
INSERT INTO sig_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Siimɔŋ, ŋ kaŋ wɩɩ rɛ dɩ ŋ basɩ tɩya ɩ.” Siimɔŋ mɛ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, basɩ tɩya ŋ.” Nyɛ rɛ Yesu baa, ");
INSERT INTO sig_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Baala balɩya rɛ sii mʋ kyɩŋ molbiye kɩna tɩɩna kɩdɩgɩ lee. Kɩdɩgɩ kyɩŋ bʋwara tusi kɔɔ rɛ, kɩdɩgɩ mɛ kyɩŋ bʋwara tusi. ");
INSERT INTO sig_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Baala no balɩya tɩyaŋ, ba kɩdɩgɩ buloŋ bɩ wuwo tuŋ kyɩŋ hʋ. Ɛɛ rɛ kɩna tɩɩna hʋ kpa kyɩma hʋ a kyɛ ba buloŋ balɩya. Baala no balɩya tɩyaŋ, ba kɩbee rɛ sɩ kyo kɩna tɩɩna hʋ wɩya yʋga?” ");
INSERT INTO sig_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ɛɛ rɛ Siimɔŋ basɩ tɩya ʋ a baa, “Ŋ liise anɩɩ nal hʋ kyɩŋ aa yʋga hʋ rɛ sɩ kyo baal hʋ wɩya yʋga.” Doŋ nɛ Yesu basɩ tɩya ʋ “Wɩtɩɩ rɛ ɩ basɩ.” ");
INSERT INTO sig_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nyɛ rɛ Yesu yaŋ mɩɩgɩ deŋ haaŋ hʋ aŋ basɩ tɩya Siimɔŋ a baa, “Na ɩ naa haaŋ no rɛ? Ŋ ko ɩ dɩya rɛ, aŋka ɩ bɩ yaa nɩɩ tɩya ŋ dɩ ŋ sɔmɔ ŋ naasɩ, aŋka ʋ kɛ kpaa ʋ sɩnɩɩl sɔmɔ ŋ naasɩ aŋ kaŋ ʋ nyupʋna mɛ tɩɩgɩ ŋ naasɩ tɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ŋ aa ko ɩ dɩya, ɩ bɩ guwori ŋ, amɛ ŋ aa ko gyʋʋ daha buloŋ, haaŋ no ko tuu gbinni kana ŋ naaŋ tɩyaŋ nɛ, a ha bɩ siye bee nyɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɩ bɩ tɩsɩ ŋ nyuu bee nʋʋ, ka ʋ kɛ yaa tʋranɩɩ tɩsɩ ŋ naasɩ. ");
INSERT INTO sig_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ŋ basɩ kɩ tɩya ɩ rɛ anɩɩ ʋ wɩbɔŋgyamaa hʋ buloŋ nɛ Wɩɩsɩ kpa kyɛ ʋ. Ɛɛ rɛ tɩŋ ʋ kyo ŋ wɩya yʋga gɛɛ. Amɛ nal hʋ buloŋ ba aa kpaa ʋ wɩbɔmɔ mʋhʋ kyɛ ʋ, ʋ mɛ aa kyo tɩɩna mʋhʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɛɛ rɛ ka Yesu basɩ tɩya haaŋ hʋ a baa, “Ŋ kpaa ɩ wɩbɔmɔ kyɛ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɩkaalɩya hʋ fa aa hɔŋ kɩ di kɩdiiliye hʋ mɩɩgɩ kɩ bɩɩnɩ ba tɩsɩ tɩyaŋ anɩɩ kɩbee rɛ paalɩ yaa baal no, a kpa wɩbɔmɔ kɩ kyɛ nala? ");
INSERT INTO sig_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amɛ Yesu basɩ tɩya haaŋ hʋ a baa, “Ɩ laadii rɛ laa ɩ ta. Kɩ mʋ abee laaŋfɩya.” ");
INSERT INTO sig_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","3","Ɛɛ hal tɩyaŋ nɛ Yesu gɔllɩ mʋ tɔbala abee tɔbiisi buloŋ, a basɩ Wɩɩsɩ koro wɩweliye hʋ a kɩ tɩya nala. Ʋ hatɩnna hʋ fi abee balɩya abee haana badɔmɔŋ nɛ gyɩ aa tɩŋ ʋ hal. Gyɩŋbɔmɔ abee wɩɩla gyɩ kaŋ haana no badɔmɔŋ nɛ, Yesu gyɩ tɩɩbɩ ba. Yesu gyɩ kile gyɩŋbɔmɔ bapɛ rɛ Mɛɛrɩ Magidalina tɩyaŋ, a tɩɩbɩ Gyuwana abee Suzaana abee hagyamaa. Gyuwana bala fa yaa nɩhɩyawʋ rɛ kuwori Hɛrɔtɩ dɩya tɩyaŋ, ba kɩ yɩrɩ Kyuuza. Haana no buloŋ gyɩ aa tɩŋ Yesu hal lɛ, a kpa ba tɩɩ kɩna a kɩ kyiyeli ʋ bee ʋ hatɩnna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɛɛ rɛ nala gyɩ lɩɩ tɔnɩ yʋga, a kɩ ko Yesu lee. Ʋ gyɩ aa ko na dɩ nala laŋŋa yʋga gɛɛ, ʋ maga namaga no tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Baal kɩdɩgɩ rɛ gyɩ siye, a kaŋ ʋ kɩdoho mʋ dɩ ʋ gyaasɩ ʋ baga tɩyaŋ. Ʋ aa gyaasɩ kɩna hʋ tɩyaŋ nɛ, kɩdoho hʋ badɔmɔŋ tele nɩɩbʋʋsɩ tɩyaŋ. Nala vala kɩ nʋwɔsɩ, ka digibiisi mɛ ko tʋwasɩ di. ");
INSERT INTO sig_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Badɔmɔŋ mɛ tele bʋnyɩŋ tɩyaŋ, a nyʋ aŋ sʋba, beewɩya fɩyɛl gyɩ tuwo doŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Badɔmɔŋ mɛ gyɩ tele sɔsɩ tɩyaŋ a nyʋ, ba bee sɔsɩ buloŋ sii waa we dɔmɔŋ, ka sɔsɩ hʋ nʋŋ kaŋ ba, ba pʋgɩmɩ. ");
INSERT INTO sig_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kɩdoho hʋ badɔmɔŋ mɛ gyɩ tele taŋhawelii tɩyaŋ, a nyʋ, a waa, a marɩ weliŋ, a we biye kɔɔ kɔɔ.” Yesu aa maga namaga hʋ teŋ, ʋ baa, “Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.” ");
INSERT INTO sig_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɛɛ rɛ Yesu hatɩnna hʋ pɩyɛsɩ ʋ namaga hʋ memii. ");
INSERT INTO sig_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu basɩ tɩya ba a baa, “Ma nala no rɛ Wɩɩsɩ daga wɩya hʋ aa yaa wɩfaŋɩya ʋ koro hʋ tɩyaŋ memii tɩya. Amɛ nɩkaalɩya hʋ kɛ buloŋ, namagɩsɩ rɛ ʋ aa kaŋ kɩ daga ba. Ɛɛ rɛ tɩŋ ba aa gyegili gyegili, aŋ bee gyɩŋ ba memiye, a bɩl deŋ deŋ mɛ aŋ bee na kɩŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kɩdohil namaga hʋ memii rɛ nyɛ: Kɩdoho hʋ rɛ yaa Wɩɩsɩ wɩbii hʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kɩna hʋ aa tele nɩɩbʋʋsɩ hʋ tɩyaŋ nɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩya, ka Sɩtaanɩ ko kaŋ wɩɩ hʋ lɩɩ ba tɩsɩ tɩyaŋ, dɩ ba ta laa di, dɩ Wɩɩsɩ laa ba ta. ");
INSERT INTO sig_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kɩna hʋ mɛ aa tele bʋnyɩŋ hʋ tɩyaŋ mɛ rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩbii hʋ, a laa di abee teŋfɩyɛlʋʋ. Amɛ wɩɩ hʋ bɩ kaŋ lɩpɩnɩɩ ba tɩsɩ tɩyaŋ. Ba aa laa wɩɩ hʋ rɛ, a tɩŋa mʋ maga gɛɛ, amɛ dɩ wɩɩ rɛ ko gyʋʋ ba wɩɩ hʋ tɩŋɩɩ tɩyaŋ, ba aa kpaa ta rɛ. ");
INSERT INTO sig_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kɩna hʋ mɛ aa tele sɔsɩ hʋ tɩyaŋ mɛ rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩbii hʋ, ka dʋnɩya kɩna abee dʋnɩya wɩyaalɩya wɩya kyɩl ba. Dʋnɩya kɩna wɩya, ba aa bɩ wuwo dɩ ba tɩŋ Wɩɩsɩ wɩbii hʋ mʋ sɩya, aŋ kpa ta. ");
INSERT INTO sig_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kɩna hʋ aa tele taŋhawelii hʋ tɩyaŋ mɛ rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩbii hʋ, a laa we ba hakɩllɩ tɩyaŋ, aŋ kaŋ kenyiri abee mala wɩɩ hʋ tɩŋɩɩ tɩyaŋ, ʋ mʋ kaŋ doho.” ");
INSERT INTO sig_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ɛɛ rɛ Yesu bɩl basɩ baa, “Nal buloŋ bɩ sɩ nyɔgɔ fɩŋtɩna ʋ dɩya tɩyaŋ, aŋ bɩl kpa sɩgɩ godo memii tɩyaŋ, koo a kpa gbaha kyige tɔ. Ʋ aa kpaa dɩ ʋ saga fɩŋtɩŋdaaŋ tɩyaŋ nɛ dɩ ʋ kyaanɩ tɩya nala hʋ aa ko kɩ gyʋʋ dɩya hʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wɩfaŋɩɩ buloŋ tuwo dɩ ʋ bɩ sɩ ko lɩɩ lɩgyalɩɩ. Wɩɩ buloŋ mɛ aa we bilhuu tɩyaŋ, ʋ mɛ sɩ ko lɩɩ pʋlʋŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ma fɩyɛlɩ ma sɩya weliŋ abee wɩya hʋ ma aa nɩɩ tɩyaŋ. Nal hʋ buloŋ aa kaŋ yʋga, Wɩɩsɩ sɩ marɩ tɩya ʋ yʋga pɛ. Nal hʋ mɛ aa bɩ kaŋ kɩŋ, mʋhʋ hʋ mɛ gba ʋ aa bɩɩna anɩɩ ʋ kana, Wɩɩsɩ sɩ kaŋ laa ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ɛɛ rɛ Yesu nɩɩna abee ʋ naabalɩya sii ko ʋ lee, dɩ ba na ʋ. Amɛ nala gyɩ aa yʋga doŋ wɩya, ba gyɩ bɩ wuwo dɩ ba na ʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɛɛ rɛ nal kɩdɩgɩ basɩ tɩya Yesu a baa, “Ɩ naa abee ɩ naabalɩya rɛ sɩŋ gyaŋhal tɩyaŋ a kɩ kyɛ dɩ ba na ɩ.” ");
INSERT INTO sig_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Doŋ nɛ Yesu basɩ tɩya ba buloŋ a baa, “Nala hʋ aa nɩɩ Wɩɩsɩ wɩya a kɩ tɩŋ ba, ba aa rɛ yaa ŋ naama abee ŋ naabalɩya.” ");
INSERT INTO sig_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kyɛɛ kɩdɩgɩ Yesu basɩ tɩya ʋ hatɩnna hʋ dɩ ba leŋ dɩ ba kyol fuwo hʋ kyolo. Ɛɛ rɛ ba sii gyʋʋ nɩɩduworiboro, a duwori kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba aa duwori kɩ mʋ hʋ tɩyaŋ nɛ, Yesu kpa doo pɩŋ. Ka puwoduwo kɩdɩgɩ mɛ piili kɩ yaa, a ko ŋmaa nɩɩ kɩ we nɩɩduworiboro hʋ tɩyaŋ ʋ kɩ kyɛ dɩ ʋ su. Boro hʋ fa kaa mʋhʋ ka dɩ ʋ tuu nɩɩmemii. ");
INSERT INTO sig_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nyɛ rɛ Yesu hatɩnna hʋ mʋ lee hʋ ʋ fa aa pɩna, a kyisi ʋ a basɩ tɩya ʋ a baa, “Á nɩhɩyawʋ, ba aa nɩɩ ma rɛ! Boro hʋ aa kyɛ dɩ ʋ tuu nɩɩmemii rɛ.” Ɛɛ rɛ Yesu sii doo hʋ tɩyaŋ, a nɔsɩ puwo hʋ bee nɩɩ hʋ buloŋ dɩ ba fɩyɛlɩ pɩŋ. Doŋ nɛ puwo hʋ sige, ka lee buloŋ yaa siyee. ");
INSERT INTO sig_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Bee rɛ tɩŋ ma bɩ laa ŋ di?” Wɩɩ hʋ yaa ba buloŋ wɩkperii, haalɩ kambɩŋ kaŋ ba. Ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Nɩgɛɛ iriŋ nɛ paalɩ yaa baal no? Ʋ nɔsɩ puwo abee nɩɩgbaŋpumo, ba buloŋ tɩŋa ʋ nyʋwa?” ");
INSERT INTO sig_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ duwori ko pele Gɛrasa paalʋʋ aa we Galili fuwo hʋ kyolo tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ba aa mʋʋ pele doŋ, Yesu lɩɩ nɩɩ hʋ nyʋwa. Ʋ lɩɩ dɩ ʋ sɩŋ, dɩ baal kɩdɩgɩ gyɩŋbɔmɔ aa kana mɛ lɩɩ tɔɔ hʋ tɩyaŋ a ko kyeme ʋ. Ʋ gyɩ aa gɔllɩ we bilni nyuni tɩyaŋ nɛ a kɩ gbɛ abee ʋ teŋbil aŋ pɔ ʋ bee gyʋʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ʋ aa naa Yesu, ʋ kyiyesi, aŋ tuu tele ʋ sɩya tɩyaŋ, aŋ kyɩɩrɩ basɩ tɩya ʋ a baa, “Yesu, Wɩɩbal hʋ Biye, bee rɛ ɩ kɩ kyɛ ɩ yaa ŋ? Ŋ aa sʋla ɩ, ta dɔgɩsɩ ŋ.” ");
INSERT INTO sig_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu fa nɔsɩ gyɩŋbɔŋ hʋ rɛ dɩ ʋ lɩɩ baal hʋ tɩyaŋ, ɛɛ rɛ tɩŋ baal hʋ basɩ gɛɛ. Gyɩna hʋ gyɩ ville kɩ kana ʋ rɛ saŋa buloŋ. Ɛɛwɩya, ba gyɩ aa kana ʋ tɔ dɩya tɩyaŋ nɛ, a we ʋ nosi bee ʋ naasɩ buloŋ kpɩyasɩ aŋ ha lɩɩ nala we dɩ ba kɩ deŋ ʋ. Amɛ ʋ gyɩ aa kaŋ kpɩyasɩ hʋ tɔrɩ rɛ, ka gyɩŋbɔmɔ hʋ kpa ʋ gyʋʋ pogo. ");
INSERT INTO sig_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ɩ feŋ nɛ bee?” Baal hʋ baa “Ŋ feŋ nɛ yaa kɩgyamaa.” Gyɩŋgyamaa rɛ gyɩ we ʋ tɩyaŋ, ɛɛ rɛ tɩŋ ʋ baa dɩ ʋ feŋ nɛ kɩgyamaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɛɛ rɛ gyɩŋsɩ hʋ sʋla Yesu a baa dɩ dɩ ʋ ko kil ba ta baal hʋ tɩyaŋ, dɩ ʋ ta kil ba we bootogiluŋii hʋ aa bɩ kaŋ litenii tɩyaŋ dɩ ba kɩ na tʋwara. ");
INSERT INTO sig_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dɩ poriku-gyamaa badɔmɔŋ mɛ sɩŋ dogimo kɩdɩgɩ aa kpaga doŋ logiŋ tɩyaŋ, a kɩ di kɩna. Ɛɛ rɛ gyɩŋsɩ hʋ sʋla Yesu dɩ ʋ leŋ dɩ ba mʋ gyʋʋ porikusi hʋ tɩyaŋ. Ʋ tɩya ba ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɛɛ rɛ ba lɩɩ baal hʋ tɩyaŋ a mʋ gyʋʋ porikusi hʋ tɩyaŋ. Porikusi hʋ buloŋ sii fá a lɩɩ dogimo hʋ logiŋ aa geese yʋga a mʋ tuu tele fuwo hʋ tɩyaŋ, a nyʋwa nɩɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Porikudaala hʋ aa naa wɩɩ no aa yaa, ba fá mʋ heeli basɩ tɩya bee hʋ nala abee nala hʋ aa we bagɩsɩ tɩyaŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nyɛ rɛ nala sii lɩɩ mʋ lee hʋ Yesu aa we, dɩ ba na wɩɩ hʋ aa yaa. Ba aa ko dɩ baal hʋ tɩyaŋ Yesu aa kile gyɩŋbɔmɔ hʋ, dɩ ʋ deye, a hɔŋ Yesu logiŋ a laalɩ gawelii. Ba aa naa gɛɛ, ʋ yaa ba kambɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nala hʋ gyɩ aa we doŋ ka Yesu tɩɩbɩ baal hʋ, ba basɩ tɩya nɩkaalɩya hʋ gɛɛ Yesu aa yaa a tɩɩbɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba aa nɩɩ wɩya hʋ, kambɩŋ kaŋ ba weliŋ. Ɛɛ rɛ paalʋʋ hʋ nala buloŋ ko basɩ tɩya Yesu dɩ ʋ lɩɩ ba paalʋʋ tɩyaŋ. Nyɛ rɛ Yesu sii gyʋʋ nɩɩduworiboro, ʋ bee ʋ hatɩnna hʋ duwori mʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Baal hʋ tɩyaŋ Yesu gyɩ aa kile gyɩŋbɔmɔ hʋ mɛ sʋla ʋ, dɩ ʋ leŋ dɩ ʋ ko dɩ ba mʋ. Ɛɛ rɛ Yesu kaŋ vɩya, aŋ basɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mɩɩgɩ mʋ dɩya a basɩ tɩya nala wɩɩ hʋ Wɩɩsɩ aa yaa tɩya ɩ.” Doŋ nɛ baal hʋ mʋ gɔllɩ bee hʋ tɩyaŋ buloŋ a kɩ basɩ wɩɩ hʋ Yesu aa yaa tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ɛɛ rɛ Yesu bɩl gyʋʋ nɩɩduworiboro a duwori kyol fuwo hʋ. Ʋ aa ko kyolo hʋ dɩ nɩgyamaa laŋŋa doŋ. Ba aa naa dɩ ʋ aa ko, ba sii mʋ kyeme ʋ abee teŋfɩyɛlʋʋ, beewɩya ba buloŋ fa hɔŋ kɩ gyegili ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Doŋ nɛ baal kɩdɩgɩ ba aa yɩrɩ Gyeerusi mɛ mʋ kpa ko. Ʋ fa yaa Gyuuma wɩɩkyʋwaldɩya nɩhɩyawʋ rɛ. Ɛɛ rɛ ʋ ko tuu gbinni Yesu sɩya tɩyaŋ, aŋ baa, “Ŋ aa sʋla ɩ, ko ŋ dɩya, beewɩya ŋ toldɩgɩ dʋŋ ŋ aa lʋla rɛ pɩŋ kɩ kyɛ dɩ ʋ sʋba.” Haŋtolibiye hʋ fa yaa nɩɩ bɩsɩ fi abee balɩya rɛ. Ɛɛ rɛ Yesu sii kpa kɩ mʋ Gyeerusi dɩya. Ʋ aa mʋʋ hʋ tɩyaŋ nɛ, nala gol ʋ kyige lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Haaŋ kɩdɩgɩ mɛ gyɩ we nala hʋ tɩyaŋ, a gyɩ kɩ yaa ʋ hawɩya ka ba bee teŋ bɩsɩ fi abee balɩya, haalɩ ʋ gɔllɩ yaa luliye weliŋ, a kpa ʋ molbiye buloŋ kyogi ta waasʋ, ka nal buloŋ bɩ wuwo tɩɩbɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɛɛ rɛ ʋ lugisi nala hʋ tɩyaŋ a ko sɩŋ Yesu hal, aŋ dige ʋ galnyʋwa tɩyaŋ. Ʋ aa dige Yesu galnyʋwa hʋ tɩyaŋ nɛ, wɩɩl hʋ pirigi teŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɛɛ rɛ Yesu pɩyɛsɩ a baa dɩ kɩbee rɛ dige ʋ. Nal buloŋ baa dɩ ʋ kɛ daa. Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, ka ɩ naa nala aa yʋga gɛɛ rɛ a gol ɩ kyige, a kɩ yige dɔmɔŋ, ka ɩ ha kɩ pɩyɛsɩ baa dɩ kɩbee rɛ dige ɩ gal.” ");
INSERT INTO sig_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amɛ Yesu ha baa, “Nal kɩdɩgɩ dige ŋ nɛ, beewɩya ŋ gyɩma anɩɩ dee lɩɩ ŋ tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Haaŋ hʋ aa naa anɩɩ ʋ bɩ sɩ wuwo kaŋ wɩɩ hʋ faŋa, ʋ ko tuu gbinni Yesu sɩya tɩyaŋ, a kɩ kyele, a basɩ tɩya nala hʋ wɩɩ hʋ aa tɩŋ ʋ dige ʋ, a daga gɛɛ hʋ ʋ aa dige ʋ, a pirigi na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ toluu, ɩ aa laa ŋ di rɛ tɩŋ ɩ deye. Kɩ mʋ abee laaŋfɩya.” ");
INSERT INTO sig_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ha fa aa basɩ wɩya no gɛɛ, dɩ ba tɩŋ nal ʋ lɩɩ Gyeerusi dɩya ko, a ko basɩ tɩya Gyeerusi a baa, “Ɩ toluu hʋ sʋba rɛ, ta bɩl kɩ dɔŋ á nɩhɩyawʋ hʋ.” ");
INSERT INTO sig_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu aa nɩɩ gɛɛ, ʋ basɩ tɩya Gyeerusi a baa, “Ta leŋ dɩ kambɩŋ kana ɩ. Ɩ kɛ laa ŋ di, ʋ sɩ sii.” ");
INSERT INTO sig_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu aa mʋʋ pele baal hʋ dɩya, ʋ bɩ leŋ nal buloŋ tɩŋa ʋ hal gyʋʋ dɩya hʋ, see Piita abee Gyɔɔŋ abee Gyemsi, a pɛ biye hʋ kuwo abee ʋ naa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ba aa mʋʋ gyʋʋ dɩya hʋ dɩ nala hʋ buloŋ aa we doŋ sɩŋ kɩ wɩɩ biye hʋ loho. Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ta kɩ wiye, biye hʋ bɩ sʋba, doo rɛ ʋ pɩŋ.” ");
INSERT INTO sig_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɛɛ rɛ ba buloŋ kpa ʋ mʋma, beewɩya ba gyɩma anɩɩ biye hʋ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nyɛ rɛ Yesu tuu kaŋ biye hʋ noŋ tɩyaŋ aŋ yɩrɩ ʋ a baa, “Ŋ biye, sii.” ");
INSERT INTO sig_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Doŋ nɛ ʋ mɩɩgɩ sii sʋʋ tɩyaŋ haŋ lagɩlagɩbiye hʋ. Ɛɛ rɛ Yesu baa dɩ ba yaa kɩdiiliye tɩya biye hʋ dɩ ʋ di. ");
INSERT INTO sig_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wɩɩ no gyɩ yaa biye hʋ kuwo abee ʋ naa buloŋ wɩkperii rɛ, ka Yesu basɩ tɩya ba abee sɩfɩyaŋ dɩ ba ta ko basɩ wɩɩ hʋ tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ɛɛ rɛ Yesu yɩrɩ ʋ hatɩnna fi abee balɩya hʋ, a ko laŋŋɩ, a tɩya ba dee abee ŋmanɩɩ dɩ ba wuwo kɩ kile gyɩŋbɔmɔ, aŋ wuwo kɩ tɩɩbɩ wɩɩla tɩmma mɛ. ");
INSERT INTO sig_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɛɛ rɛ ʋ tɩŋ ba dɩ ba lɩɩ mʋ a basɩ Wɩɩsɩ koro hʋ wɩya aŋ pɛ tɩɩbɩ wɩɩla tɩmma mɛ. ");
INSERT INTO sig_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aŋ bɩl basɩ tɩya ba a baa, “Ŋmanɩɩ no valɩɩ tɩyaŋ, ma ta paa daatɩgɩya, koo ma diikusi, a ta kol kɩdiiliye koo molbiye. Ma ta paa gannɩ pɛ gannɩ hʋ ma aa sɩ laalɩ tɩyaŋ. Kɩŋ buloŋ paalɩ bɩ maga dɩ ʋ tɩŋ ma hal. ");
INSERT INTO sig_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dɩ mamaa rɛ ko mʋ tɔɔ buloŋ, dɩ tɔɔ hʋ nala ko kyaga laa ma abee nosi balɩya, lee hʋ ba aa sɩ kpa tɩya ma dɩ ma gyʋʋ, ʋ maga dɩ ma we doŋ nɛ a mʋ pele kyɛɛ hʋ ma aa sɩ lɩɩ tɔɔ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dɩ mamaa rɛ ko mʋ tɔɔ buloŋ, dɩ tɔɔ hʋ nala bɩ tɔgɩmɔ ma, ma piisi ma naasɩ taŋha ta doŋ, aŋ lɩɩ tɔɔ hʋ tɩyaŋ. Ɛɛ sɩ leŋ dɩ ba gyɩma anɩɩ ba aa vɩya ma nyɛ, Wɩɩsɩ sɩ dɔgɩsɩ ba.” ");
INSERT INTO sig_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nyɛ rɛ ba sii gɔllɩ mʋ tɔnɩ, a kɩ basɩ Wɩɩsɩ wɩweliye hʋ, aŋ pɛ kɩ tɩɩbɩ nala mɛ, lee hʋ kɛ buloŋ ba aa mʋwa. ");
INSERT INTO sig_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nal hʋ gyɩ aa deŋ Galili paalʋʋ ba kɩ yɩrɩ Hɛrɔtɩ gyɩ aa nɩɩ wɩya hʋ Yesu bee ʋ hatɩnna hʋ aa gɔllɔ kɩ yaa, ʋ hakɩla buloŋ gyɩ vʋgɩma rɛ, beewɩya nala badɔmɔŋ gyɩ aa basɩ rɛ anɩɩ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ rɛ mɩɩgɩ sii sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nala badɔmɔŋ mɛ gyɩ baa dɩ Ɛlaagya rɛ mɩɩgɩ ko, ka badɔmɔŋ mɛ baa dɩ faafaa Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ rɛ mɩɩgɩ sii sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nyɛ rɛ Hɛrɔtɩ baa, “Ŋ gyɩ leŋ ba keri Gyɔɔŋ nyuu rɛ, ka kɩbee wɩya rɛ ŋ yaŋ bɩl kɩ nɩɩ nyɛ?” Ɛɛ rɛ ʋ kɩ lʋga dɩ ʋ na Yesu. ");
INSERT INTO sig_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nyɛ rɛ Yesu kpambɩsɩ hʋ mɩɩgɩ ko ʋ lee, a yaa ba ŋmanɩɩ duwoso tɩya ʋ, ka ʋ beel-ba dʋŋ sii kpa tɩŋ Bɛsaada dɩɩlaŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nala aa nɩɩ Yesu wɩya anɩɩ ʋ mʋʋ Bɛsaada, ba sii kile ʋ lugo mʋ doŋ. Ba aa mʋʋ pele doŋ, ʋ lɔllɩ ba weliŋ, aŋ basɩ Wɩɩsɩ koro hʋ wɩya tɩya ba, aŋ tɩɩbɩ wɩɩla tɩmma mɛ. ");
INSERT INTO sig_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dɩdaana aa ko pele, Yesu kpambɩsɩ hʋ basɩ tɩya ʋ a baa, “Leŋ dɩ nala hʋ mʋ tɔnɩ hʋ abee bagɩsɩ hʋ aa kpaga daha, a kyɛ kɩdiiliye abee lɩpɩnɩya, beewɩya kɩŋ buloŋ tuwo daha ba aa sɩ di.” ");
INSERT INTO sig_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ba a baa, “Ma tɩɩ mʋ kyɛ kɩdiiliye tɩya ba dɩ ba di.” Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Kɩŋ hʋ á aa kana rɛ yaa paanʋʋ gama bɔnɔŋ abee fuwonaŋhɩlɩya balɩya. Ɛɛ rɛ á sɩ yaa a yɔbɔ kɩdiiliye tɩya nɩgyamaa no buloŋ?” ");
INSERT INTO sig_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Baala dʋŋ gyɩ aa we nala hʋ tɩyaŋ gyɩ pele tusi bʋnɔŋ nɛ. Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ nala hʋ laŋŋɩ hɔŋ gulo gulo, a leŋ dɩ gul buloŋ yaa nala mɔllɩbalɩya abee fi.” ");
INSERT INTO sig_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɛɛ rɛ ʋ hatɩnna hʋ leŋ nala hʋ buloŋ tuu hɔŋ gulo gulo. ");
INSERT INTO sig_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ka Yesu kpa paanʋʋ hʋ bɔnɔŋ abee fuwonamɩɩsɩ hʋ balɩya, a wil deŋ wɩɩsɩnyuu aŋ kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kaŋ lɔgɔ lɔgɔ, a kpa tɩya ʋ hatɩnna hʋ, ba mɛ laa kaŋ kpaa nala hʋ. ");
INSERT INTO sig_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nala hʋ buloŋ kyaŋ, a vɔgɔ aŋ ka. Ʋ hatɩnna hʋ paa kɩkaalɩya hʋ su simbiisi fi abee balɩya. ");
INSERT INTO sig_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kyɛɛ kɩdɩgɩ rɛ Yesu dʋŋ mʋ kɩ kyʋwalɩ Wɩɩsɩ. Ɛɛ rɛ ʋ hatɩnna hʋ sii mʋ ʋ lee. Doŋ nɛ ʋ pɩyɛsɩ ba a baa, “Aŋnɛ rɛ nala baa ŋ yaa?” ");
INSERT INTO sig_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɛɛ rɛ ʋ hatɩnna hʋ baa, “Badɔmɔŋ baa dɩ ɩ rɛ yaa Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ. Badɔmɔŋ mɛ baa dɩ ɩ rɛ yaa Ɛlaagya. Badɔmɔŋ mɛ ha baa dɩ ɩ yaa faafaa Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ rɛ, a mɩɩgɩ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nyɛ rɛ Yesu mɩɩgɩ pɩyɛsɩ ʋ hatɩnna hʋ mɛ a baa, “Aŋka ma mɛ, aŋnɛ rɛ ma baa ŋ yaa?” Ɛɛ rɛ Piita baa, “Ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta.” ");
INSERT INTO sig_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ɛɛ rɛ Yesu basɩ tɩya ba abee sɩfɩyasɩ dɩ ba ta ko basɩ wɩɩ no kɩ tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu bɩl basɩ tɩya ba a baa, “Mɩyaŋ Nihuwobiŋ Biye sɩ na tʋwara rɛ kɩŋkaŋ. Gyuuma nɩhɩyasɩ abee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla buloŋ sɩ vɩya ŋ. Ba sɩ kpʋ ŋ, amɛ ŋ sɩ sii sʋʋ tɩyaŋ ʋ kyɛtoo kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɛɛ rɛ ʋ basɩ tɩya nala hʋ buloŋ a baa, “Dɩ nal buloŋ nɛ aa kyɛ dɩ ʋ tɩŋa ŋ, see dɩ ʋ vɩya ʋ tɩɩ ŋmanɩɩ ta aŋ kpa ʋ daagarɩɩ baasɩ kyɛɛ kɛ buloŋ, a kɩ tɩŋa ŋ hal. ");
INSERT INTO sig_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nal hʋ buloŋ aa kyɛ dɩ ʋ laa ʋ tɩɩ mɩɩbol, ʋ bɩ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii, amɛ nal hʋ aa kuu ŋ wɩya a vɩya ʋ mɩɩbol ta, ʋ tɩɩna rɛ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dɩ ɩ rɛ tɩŋ dʋnɩya no buloŋ, aŋka dɩ ɩ bɩ sɩ na mɩɩbol hʋ aa bɩ kaŋ tenii, bekiŋ tɔnɔ rɛ ɩ na? ");
INSERT INTO sig_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dɩ nal buloŋ nɛ ko leŋ dɩ Mɩyaŋ Nihuwobiŋ Biye bee ŋ wɩbasɩya yaa ʋ hɩɩsɩ, ʋ tɩɩna wɩya mɛ sɩ yaa ŋ hɩɩsɩ kyɛɛ hʋ ŋ aa sɩ mɩɩgɩ ko dʋnɩya abee gaŋdarɩ abee ŋ kuwo Wɩɩsɩ gaŋdarɩ abee ʋ malɩkaweliye hʋ gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nala badɔmɔŋ we daha, ba bɩ sɩ sʋba ka dɩ Wɩɩsɩ koro hʋ ko.” ");
INSERT INTO sig_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu aa basɩ wɩya no hal tɩyaŋ, ʋ kyɛyɛ kyori kyɛɛ, ʋ sii kaŋ Piita bee Gyɔɔŋ abee Gyemsi, a mʋ gyɩŋ dogimo kɩdɩgɩ nyuu dɩ ʋ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ʋ fa aa kyʋwalɩ Wɩɩsɩ hʋ tɩyaŋ nɛ, ʋ sɩya pirigi bɩrɩmɩ, a bɩl bɩ kɩɩ ʋ kɩyɩ. Ʋ gannɩ buloŋ mɩɩgɩ pʋrɩsɩ gɛɛ pogipogi, a kɩ tʋla gɛɛ nyʋlɩɩnyʋlɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Doŋ tɩyaŋ nɛ Moosi bee Ɛlaagya pirigi lɩɩ wɩɩsɩbee, a ko pɛ Yesu tɩyaŋ, ba gannɩ mɛ kɩ tʋla gɛɛ tɩɩ. Ba beel-ʋ sɩŋ kɩ basɩ gɛɛ hʋ Yesu aa sɩ sʋba Gyerusalɛm tɩyaŋ, a leŋ dɩ wɩɩ hʋ wɩya Wɩɩsɩ aa tɩma ʋ ko su ʋ bʋwa. ");
INSERT INTO sig_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piita bee ʋ dɔŋtɩŋsɩ hʋ fa aa pɩŋ doo rɛ, amɛ ba aa hirige sii, ba naa Yesu dɩ ʋ aa tʋl, a na baala hʋ balɩya mɛ aa sɩŋ ʋ lee. ");
INSERT INTO sig_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nyɛ rɛ baala hʋ ta Yesu aŋ kpa dɩ ba mʋ. Ɛɛ rɛ Piita basɩ tɩya Yesu a baa, “Tɩɩna, ʋ yaa wɩwelii rɛ á aa we daha. Á sɩ we gyama boto, dɩ ɩ tɩŋ kɩdɩgɩ, dɩ Moosi mɛ tɩŋ kɩdɩgɩ, ka dɩ Ɛlaagya mɛ tɩŋ kɩdɩgɩ.” (Piita aa basɩ wɩya no buloŋ, ka ʋ tɩɩ fa paalɩ bɩ gyɩŋ wɩɩ hʋ ʋ aa basɩ.) ");
INSERT INTO sig_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piita ha fa aa basɩ wɩya hʋ tɩyaŋ nɛ, taalbal kɩdɩgɩ pirigi ko tuu tɔ ba. Ɛɛ rɛ kambɩŋ kaŋ Yesu hatɩnna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka taal kɩdɩgɩ lɩɩ taalbal hʋ tɩyaŋ a baa, “Ŋ Biye rɛ nyɛ. Ʋ rɛ yaa nal hʋ ŋ aa lɩya. Ma gyegili kɩ nɩɩ ʋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Taal hʋ aa basɩ wɩya no ko teŋ, dɩ Yesu dʋŋ nɛ kaa sɩŋ doŋ. Ɛɛ rɛ ʋ hatɩnna hʋ tallɩ ba nyʋwa. Ba bɩ laa nyʋwa basɩ wɩɩ no ba aa naa a tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ʋ sɩgballɩya, Yesu bee ʋ hatɩnna hʋ boto lɩɩ dogimo hʋ nyuu ko tuu dogimo hʋ naasɩ. Doŋ nɛ nɩgyamaa ko kyeŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dɩ baal kɩdɩgɩ lɩɩ nɩgyamaa hʋ tɩyaŋ a huwori Yesu a baa, “Nɩhɩyawʋ, ŋ aa sʋla ɩ, deŋ ŋ biye no aŋ ha kyiyeli ŋ, beewɩya ŋ biye buloŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gyɩŋbɔŋ nɛ kana ʋ, ʋ kɩ tele kpuŋkpuŋsi. Dɩ ʋ ko sii ʋ tɩyaŋ buloŋ, ʋ aa pirigi kyɩɩrɩ rɛ aŋ lɩɩ tele, a kɩ kyele, ka ʋ nyʋwa buloŋ tɔ naŋtʋwɔ-fʋŋfʋga. Ʋ aa villi kɩ sii ʋ tɩyaŋ nɛ saŋa buloŋ, a kɩ dɔgɩsɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ɛɛ rɛ ŋ ko sʋla ɩ hatɩnna hʋ dɩ ba kile gyɩŋbɔŋ hʋ ta ʋ tɩyaŋ, amɛ ba bɩ wuwo kile.” ");
INSERT INTO sig_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma gyɩnaŋ nala, ma yaa nɩnyʋgɩsɩya rɛ, a bɩ laa Wɩɩsɩ mɛ di. Abaa! Kyɛyɛ baŋmɛ rɛ ŋ baa ŋ yaa ma lee?” Aŋ mɩɩgɩ basɩ tɩya baal hʋ a baa, “Kaŋ ɩ biye hʋ ko daha.” ");
INSERT INTO sig_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ɛɛ rɛ biye hʋ sii kpa dɩ ʋ mʋ. Doŋ nɛ gyɩŋbɔŋ hʋ lɩɩ ʋ lo taŋha ʋ pɩŋ kɩ kyele. Ɛɛ rɛ Yesu nɔsɩ gyɩŋbɔŋ hʋ dɩ ʋ lɩɩ biye hʋ tɩyaŋ. Ʋ lɩɩ, ka biye hʋ deye. Yesu mɩɩgɩ kpa ʋ tɩya ʋ kuwo. ");
INSERT INTO sig_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nala hʋ buloŋ nyʋʋsɩ gyɩ fɩyɛla rɛ abee Wɩɩsɩ debal hʋ ba aa naa. Ɛɛ rɛ ba gyɩ sɩŋ kɩ bɩɩnɩ wɩkperiye hʋ buloŋ Yesu aa yaa. Ɛɛ tɩyaŋ nɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, ");
INSERT INTO sig_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ma ta ko yeŋŋi wɩɩ no ŋ aa kyɛ dɩ ŋ basɩ tɩya ma! Ba sɩ kpa mɩyaŋ, Nihuwobiŋ Biye a yallɩ tɩya dʋnɩya nala.” ");
INSERT INTO sig_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amɛ ʋ hatɩnna hʋ gyɩ bɩ gyɩŋ wɩɩ hʋ ʋ aa basa memii. Ʋ yaa wɩfaŋɩɩ rɛ ba lee. Ɛɛ rɛ tɩŋ ba gyɩ bɩ wuwo gyɩŋ ʋ memii. Amɛ ba kɩ fá kambɩŋ ba aa sɩ pɩyɛsɩ ʋ wɩɩ hʋ memii. ");
INSERT INTO sig_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɛɛ rɛ Yesu hatɩnna hʋ kaŋ ba tɩyaŋ nɩbal wɩya kɩ kpa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu fa gyɩŋ wɩɩ hʋ ba aa bɩɩnɩ rɛ, ɛɛ rɛ ʋ kaŋ biibiye ko sɩgɩ ʋ logiŋ, ");
INSERT INTO sig_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aŋ basɩ tɩya ba a baa, “Dɩ nal buloŋ nɛ kuu ŋ wɩya a kaŋ biibiye no weliŋ, mɩyaŋ nɛ ʋ tɩɩna kaŋ weliŋ gɛɛ. Nal hʋ mɛ buloŋ aa kana ŋ weliŋ, ŋ dʋŋ daa ʋ kaŋ weliŋ gɛɛ. Nal hʋ aa tɩma ŋ mɛ rɛ ʋ kaŋ weliŋ gɛɛ. Nal hʋ aa yaa nɩbiye ma tɩyaŋ, ʋ rɛ yaa ma tɩyaŋ nɩbal.” ");
INSERT INTO sig_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ɛɛ rɛ Gyɔɔŋ basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, á fa naa baal kɩdɩgɩ rɛ dɩ ʋ kpaa ɩ feŋ a kɩ kile gyɩŋbɔmɔ nala tɩyaŋ. Á kile ʋ dɩ ʋ ta kɩ yaa gɛɛ, beewɩya ʋ bɩ yaa á kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ɛɛ rɛ Yesu basɩ tɩya Gyɔɔŋ abee ʋ hatɩnna hʋ nɩkaalɩya a baa, “Ma ta kile ʋ, beewɩya nal hʋ buloŋ aa bɩ lɩɩ á hal tɩyaŋ, ʋ yaa á kɩdɩgɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kyɛɛ hʋ aa ko kpaga dɩ Wɩɩsɩ kpa Yesu gyɩŋ wɩɩsɩbee, Yesu sii yaa ʋ siri, a lɩɩ kpa ŋmanɩɩ kɩ mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ʋ gyɩ taa nala rɛ dɩ ba laa sɩya mʋ marɩ lee bine ʋ Samaarɩya paalʋʋ tɔbiye kɩdɩgɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amɛ doŋ nala gyɩ bɩ yaa siri dɩ ba laa ʋ, beewɩya ba gyɩ gyɩma anɩɩ Gyerusalɛm nɛ ʋ kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gyemsi abee Gyɔɔŋ aa naa wɩɩ no, ba pɩyɛsɩ Yesu a baa, “Á Tɩɩna, ɩ bɩ sɩ leŋ dɩ á sʋla Wɩɩsɩ dɩ ʋ leŋ diŋ lɩɩ wɩɩsɩnyuu ko tuu kpa ba di?” ");
INSERT INTO sig_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ɛɛ rɛ Yesu mɩɩgɩ bɩrɩmɩ kyaasɩ ba, aŋ nɔsɩ ba. ");
INSERT INTO sig_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɛɛ hal lɛ ka ba parɩ mʋ tɔdɩma. ");
INSERT INTO sig_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba aa kpaa ŋmanɩɩ hʋ kɩ mʋ tɩyaŋ nɛ, baal kɩdɩgɩ basɩ tɩya Yesu a baa, “Ŋ yaa siri rɛ dɩ ŋ tɩŋa ɩ hal a mʋ lee kɛ buloŋ ɩ aa sɩ mʋ.” ");
INSERT INTO sig_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋmanyɔnɩ kaŋ bʋʋsɩ rɛ a kɩ gyʋʋ, digibiisi mɛ kaŋ gyannɩ a kɩ pɩŋ, amɛ mɩyaŋ Nihuwobiŋ Biye kɛ bɩ kaŋ lee ŋ aa sɩ kpa ŋ nyuu biŋ a wiyesi.” ");
INSERT INTO sig_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya baal kɩdɩgɩ mɛ a baa, “Ko kɩ tɩŋa ŋ hal.” Ʋ basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, leŋ dɩ ŋ laa sɩya mʋ kpa ŋ kuwo hogo.” ");
INSERT INTO sig_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Leŋ dɩ sʋʋnɩ kɩ hogo ba tɩɩ sʋʋnɩ, aŋ ka dɩ ɩ mɛ mʋ basɩ Wɩɩsɩ koro hʋ wɩya kɩ tɩya nala.” ");
INSERT INTO sig_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nal kɩdɩgɩ mɛ bɩl basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, ŋ sɩ tɩŋa ɩ hal, amɛ leŋ dɩ ŋ mʋ ta ŋ dɩya nala aŋ ko.” ");
INSERT INTO sig_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Nal hʋ buloŋ aa tɩga nɔpalɩya pal kɩ pala, aŋ kpa ʋ sɩya ta gama, ʋ tɩɩna bɩ kaŋ tɔnɔ buloŋ Wɩɩsɩ koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɛɛ hal tɩyaŋ nɛ Yesu lɩɩ nala mɔllɩboto abee fi abee balɩya a kaŋ ba kpaa balɩya balɩya, a tɩŋ ba dɩ ba laa sɩya mʋ tɔnɩ hʋ abee leye hʋ buloŋ ʋ tɩɩ aa kyɛ dɩ ʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɛɛ rɛ ka ʋ basɩ tɩya ba a baa, “Baga hʋ kɩkʋmɩya yʋga, amɛ kɩkʋnna hʋ bɩ yʋga. Ɛɛ wɩya ma sʋla baga hʋ tɩɩna dɩ ʋ ta tʋŋtʋnna dɩ ba ko kʋŋ kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ma sii mʋ! Ma kɩɩ gɛɛ rɛ anɩɩ pebiisi, ŋ kɩ tɩŋ ma dɩ ma mʋ guwosi gboni tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma ta kol molbiye, a ta paa diikusi mɛ. Ma ta paa naatɔbɔ pɛ kɩna hʋ ma aa sɩ tʋʋ tɩyaŋ, a ta sɩŋ kyʋwalɩ nala mɛ kɩ pɩɩsɩ ŋmanɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dɩ mamaa rɛ ko mʋ gyʋʋ dɩya buloŋ, ma laa sɩya basɩ tɩya dɩya hʋ nala a baa, ‘Wɩɩsɩ sɩ leŋ dɩ ʋ fɩyɛlʋʋ we dɩya no tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dɩ nal lɛ ko we doŋ, a kyo fɩyɛlʋʋ hʋ ma aa sʋla tɩya ba, ma leŋ dɩ ʋ hɔŋ abee laaŋfɩya anɩɩ ma aa sʋla gɛɛ. Amɛ dɩ nal ko tuwo dɩya hʋ tɩyaŋ a kyo fɩyɛlʋʋ hʋ, ma leŋ dɩ fɩyɛlʋʋ hʋ ma aa sʋla mɩɩgɩ ko ma lee. ");
INSERT INTO sig_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dɩ ba aa rɛ ko tɩya ma lɩpɩnɩɩ, ma we doŋ, a di aŋ kɩ nyʋwa kɩŋ hʋ kɛ buloŋ ba aa sɩ tɩya ma. Beewɩya tʋŋtʋnnɩ buloŋ maga dɩ ba tun-ʋ rɛ. Ma ta gɔllɩ kɩ pɩŋ nala dɩɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dɩ mamaa rɛ ko mʋ tɔɔ buloŋ, dɩ ba laa ma weliŋ, kɩŋ kɛ buloŋ ba aa sɩ tɩya ma, ma di. ");
INSERT INTO sig_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma tɩɩbɩ wɩɩla tɩmma aa we tɔɔ hʋ tɩyaŋ aŋ basɩ tɩya bee hʋ nala a baa, ‘Wɩɩsɩ koro hʋ ko kpaga ma rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amɛ dɩ mamaa rɛ ko mʋ tɔɔ buloŋ, dɩ ba bɩ laa ma weliŋ, ma lɩɩ sɩŋ ŋmanɩɩ tɩyaŋ aŋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma bee hʋ taŋha aa mal á naasɩ tɩyaŋ, ba aa rɛ á piisi we ma tɩyaŋ nyɛ. Amɛ ʋ maga dɩ ma gyɩma rɛ anɩɩ Wɩɩsɩ koro hʋ ko kpaga ma rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ŋ basɩ kɩ tɩya ma rɛ, Sarɩya hʋ kyɛdiilii, Wɩɩsɩ sɩ dɔgɩsɩ haŋ tɔɔ hʋ nala a te Sodɔm nala.” ");
INSERT INTO sig_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ɛɛ rɛ Yesu bɩl basɩ baa, “Mamaa Kɔrazɩŋ tɩmma, ma tʋwara sɩ yʋga! Mamaa Bɛsaada tɩmma mɛ, ma tʋwara mɛ sɩ yʋga! Wɩmagɩla hʋ ba aa yaa ma tɩyaŋ, dɩ ba aa rɛ fa yaa ba Taaya abee Siidɔŋ nala tɩyaŋ, ba fa bɩ sɩ yaa gyegye ka dɩ ba paa ba logannɩ laalɩ, aŋ yaa tʋwɔl bʋgɩ ba tɩɩ a daga anɩɩ ba tɩsɩ kyogo rɛ, ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sarɩya hʋ kyɛdiilii, Wɩɩsɩ sɩ fá Taaya abee Siidɔŋ nala sikii a te ma. ");
INSERT INTO sig_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mamaa Kapɛɛnam tɩmma, ma aa kyɛ dɩ ma kaŋ ma tɩɩ gyɩŋ wɩɩsɩbee rɛ. Amɛ Wɩɩsɩ sɩ kpa ma yuwo ta dɩ ma tuu gyʋʋ diŋ.” ");
INSERT INTO sig_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ɛɛ rɛ ka Yesu bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, “Nal hʋ buloŋ aa gyegile nɩɩ ma nyʋwa, ŋ nyʋwa mɛ rɛ ʋ gyegile nɩɩ gɛɛ. Nal hʋ buloŋ mɛ aa vɩya ma nyʋwa, ŋ nyʋwa rɛ ʋ vɩya gɛɛ. Haŋ nal hʋ buloŋ mɛ aa vɩya ŋ nyʋwa, nal hʋ aa tɩma ŋ nyʋwa mɛ rɛ ʋ tɩɩna vɩya gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɛɛ rɛ Yesu hatɩnna mɔllɩboto abee fi abee balɩya hʋ mɩɩgɩ ko ʋ lee abee teŋfɩyɛlʋʋ, a basɩ tɩya ʋ a baa, “Á Tɩɩna, á aa mʋwa, dɩ ámaa rɛ ko nɔsɩ gyɩŋbɔmɔ ɩ feŋ tɩyaŋ, ba aa tɩŋ á nyʋwa rɛ, a yaa wɩɩ hʋ buloŋ á aa baa dɩ ba yaa.” ");
INSERT INTO sig_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ naa Sɩtaanɩ rɛ dɩ ʋ lɩɩ wɩɩsɩnyuu ko tuu tele gɛɛ anɩɩ duwoŋ aa lɩgɩsa.” ");
INSERT INTO sig_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma gyegile nɩɩ daha. Ŋ tɩya ma dee rɛ dɩ ma wuwo vala dʋma abee nʋʋŋsɩ nyuni tɩyaŋ, ka dɩ ba bɩ sɩ wuwo dʋŋ ma. A bɩl tɩya ma dee mɛ dɩ ma wuwo Sɩtaanɩ abee ʋ wɩɩ buloŋ. Ɛɛwɩya, wɩɩ buloŋ bɩ sɩ wuwo dɔŋ ma. ");
INSERT INTO sig_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amɛ ma ta leŋ dɩ ma tenni fɩyɛlɩ akuu gyɩŋbɔmɔ aa tɩŋ ma nyʋwa wɩya, ma leŋ dɩ ma tenni fɩyɛlɩ ba aa sabɩ ma fene biŋ wɩɩsɩbee tɩyaŋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saŋa no tɩyaŋ, dɩ Wɩɩsɩ Wiyesi Welii hʋ leŋ Yesu teŋ fɩyɛlɩ. Nyɛ rɛ ʋ baa, “Ŋ Kuwo, ɩ rɛ yaa wɩɩsɩnyuu abee taŋha buloŋ Tɩɩna. Ŋ aa kyʋwalɩ ɩ aŋgyʋwasʋ rɛ yʋga, beewɩya, wɩya hʋ ɩ aa kpaa faŋa wɩgyʋnna, ba aa rɛ ɩ kpaa daga nala hʋ aa bɩ yaa wɩgyʋnna. Wɩtɩɩ rɛ ŋ Kuwo, ɩ tɩɩ kyɛrɩ tɩyaŋ nɛ ɩ yaa wɩya no buloŋ.” ");
INSERT INTO sig_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ɛɛ rɛ ʋ bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, “Ŋ Kuwo kpaa kɩŋ buloŋ dee tɩya ŋ nɛ. Nal buloŋ tuwo a gyɩŋ gɛɛ hʋ mɩyaŋ biye hʋ aa kɩya, see ŋ kuwo dʋŋ. Ŋ dʋŋ mɛ rɛ gyɩŋ gɛɛ ŋ kuwo aa kɩya, abee nala hʋ ŋ aa daga ɛɛ ŋ Kuwo hʋ aa kɩya a tɩya ŋ kyɛrɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nyɛ rɛ Yesu mɩɩgɩ bɩrɩmɩ kyaasɩ ʋ hatɩnna hʋ dʋŋ aŋ basɩ tɩya ba a baa, “Ma nyuu sʋma rɛ abee ma aa na wɩya no. ");
INSERT INTO sig_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ŋ basɩ kɩ tɩya ma rɛ, Wɩɩsɩ tɩŋdaala abee kuworo buloŋ fa aa kyɛ dɩ ba na wɩya no ma aa naa rɛ, amɛ ba bɩ wuwo na ba; a fa lʋga mɛ dɩ ba nɩɩ wɩya no ma aa nɩɩ, aŋ bɩ wuwo nɩɩ ba.” ");
INSERT INTO sig_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩl kɩdɩgɩ ko kɩ kyɛ dɩ ʋ magɩsɩ Yesu, a pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, ɛɛ rɛ ŋ sɩ yaa a kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii?” ");
INSERT INTO sig_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nyɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ba sabɩ biŋ Wɩɩsɩ teŋ hʋ tɩyaŋ? Wɩya hʋ ba aa saba biŋ memii rɛ yaa bee ɩ lee?” ");
INSERT INTO sig_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Doŋ nɛ baal hʋ basɩ tɩya Yesu a baa, “Ba saba baa ‘Kyo ɩ tɩɩna Wɩɩsɩ abee ɩ tɩya buloŋ, abee ɩ dʋma buloŋ, abee ɩ dee buloŋ, abee ɩ hakɩla buloŋ, aŋ kyo ɩ dɔŋtɩɩna mɛ anɩɩ ɩ aa kyo ɩ tɩɩ gɛɛ.”’ ");
INSERT INTO sig_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Wɩya hʋ buloŋ ɩ aa basa yaa wɩtɩɩ rɛ. Dɩ ɩ rɛ aa tɩŋ ba, ɩ sɩ kaŋ mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nyɛ rɛ Wɩɩsɩ Teŋ dɩdagɩl hʋ ha kɩ kyɛ dɩ ʋ daga anɩɩ ʋ yaa nɩtɩɩ rɛ. Ɛɛ rɛ ʋ bɩl pɩyɛsɩ Yesu a baa, “Aŋnɛ rɛ yaa ŋ dɔŋtɩɩna?” ");
INSERT INTO sig_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Doŋ tɩyaŋ nɛ Yesu maga namaga no a baa, “Baal kɩdɩgɩ rɛ gyɩ siye, a lɩɩ Gyerusalɛm a kɩ mʋ Gyɛriko. Ʋ aa mʋʋ hʋ tɩyaŋ nɛ, gaala ko lɩɩ bori ʋ ŋmanɩɩ, a kaŋ ʋ kɩŋ kɩŋ buloŋ laa, aŋ ŋmaa ʋ a bɔŋsɩ, aŋ vɩya ʋ ta doŋ, ʋ pɩŋ kɩ kyɛ dɩ ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɛɛ rɛ dɩ Gyuuma wɩɩkyʋwal sɩlaal kɩdɩgɩ mɛ kpaa ŋmanɩɩ hʋ kɩ ko. Ʋ aa ko a na baal hʋ, ʋ tɩŋ gama, a kpala baŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ɛɛ rɛ Wɩɩkyʋwaldɩɩbal tʋŋtʋnnɩ kɩdɩgɩ mɛ bɩl kɩ ko, a na ʋ, a mɛ kpala tɩŋ gama baŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɛɛ rɛ dɩ Samaarɩya tɩmma baal kɩdɩgɩ mɛ fa kpaa ŋmanɩɩ hʋ kɩ ko. Ʋ aa ko na baal hʋ, sikii kana ʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ʋ kpa mʋ pele ʋ, a sasɩ ʋ dʋgʋlɩya hʋ, a we luliye aŋ vʋwa, aŋ kpa ʋ saga ʋ tɩɩ kokumo tɩyaŋ a kana ʋ mʋ nɩhʋwala dɩya kɩdɩgɩ, a leŋ ba kɩ deŋ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ʋ sɩgballɩya, ʋ sii kpa molbii tɩya dɩya hʋ tɩɩna aŋ basɩ tɩya ʋ a baa, ‘Kɩ deŋ ʋ nyuu tɩyaŋ weliŋ. Dɩ mɩyaŋ nɛ ko mɩɩgɩ ko, kyɩŋ mɔɔgɛɛ buloŋ ɩ aa ŋmaa pɛ baal hʋ nyuu tɩyaŋ, ŋ sɩ tuŋ tɩya ɩ.’ ");
INSERT INTO sig_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɛɛ rɛ Yesu pɩyɛsɩ Wɩɩsɩ Teŋ dɩdagɩl hʋ a baa, ‘Ɩ aa naa, nala no boto tɩyaŋ, kɩbee rɛ yaa baal hʋ gaala aa ŋmaa hʋ dɔŋtɩɩna?’ ");
INSERT INTO sig_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩl hʋ baa, ‘Baal hʋ aa fáá ʋ sikii hʋ.’ Yesu yaŋ basɩ tɩya ʋ, ‘Tɔɔ, ɩ mɛ mʋ a kɩ yaa gɛɛ tɩɩ.”’ ");
INSERT INTO sig_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu bee ʋ hatɩnna hʋ sii kpa ŋmanɩɩ kɩ mʋ, a ko pele tɔɔ kɩdɩgɩ. Haaŋ kɩdɩgɩ gyɩ we tɔɔ no tɩyaŋ, ba kɩ yɩrɩ Maata. Ɛɛ rɛ ʋ kaŋ Yesu gyʋʋ ʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maata nɩɩnatoluu mɛ fa we doŋ, ba kɩ yɩrɩ Mɛɛrɩ. Yesu aa hɔŋ dɩya hʋ tɩyaŋ, Mɛɛrɩ ko hɔŋ ʋ logiŋ a kɩ gyegile wɩya hʋ ʋ aa basɩ, ");
INSERT INTO sig_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ka Maata sii mɛ fɩyɛsɩ, ʋ kɩ tʋŋ tʋma dɩya hʋ tɩyaŋ. Ɛɛ rɛ ʋ na dɩ tʋma hʋ yʋga tɩya ʋ, ʋ ko basɩ tɩya Yesu a baa, “Ŋ Tɩɩna, ɩ bɩ naa ŋ naabiye aa leŋ tʋma hʋ buloŋ tɩya ŋ dʋŋ? Leŋ dɩ ʋ sii ko lɩɩ kyiyeli ŋ.” ");
INSERT INTO sig_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Maata, ɩ leŋ wɩgyamaa rɛ kɩ dɔm-ɩ. ");
INSERT INTO sig_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amɛ wɩdɩgɩ dʋŋ nɛ yaa sɩfɩyaŋ wɩɩ. Haŋ wɩɩ hʋ rɛ Mɛɛrɩ kɛ kpa gɛɛ. Nal buloŋ mɛ bɩ sɩ wuwo kaŋ wɩɩ no laa ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kyɛɛ kɩdɩgɩ Yesu sii mʋ dɩ ʋ kyʋwalɩ Wɩɩsɩ lee kɩdɩgɩ tɩyaŋ. Ʋ aa kyʋwalɩ Wɩɩsɩ hʋ teŋ, ʋ hatɩnna hʋ kɩdɩgɩ basɩ tɩya ʋ a baa, “Á Tɩɩna, daga ma gɛɛ á aa sɩ kɩ kyʋwalɩ Wɩɩsɩ, anɩɩ Gyɔɔŋ fa aa daga ʋ hatɩnna hʋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ ma ko kɩ kyɛ dɩ ma kyʋwalɩ Wɩɩsɩ buloŋ, ma baa, “Á Kuwo Wɩɩsɩ, leŋ dɩ ɩ feŋ gyɩŋ, leŋ dɩ ɩ koro hʋ ko. ");
INSERT INTO sig_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tɩya ma á nyʋwa kɩdiilii kyɛɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kpa á wɩbɔmɔ kɩ kyɛ ma anɩɩ á mɛ aa kpaa á dɔŋtɩŋsɩ wɩbɔmɔ kɩ kyɛ ba gɛɛ, aŋ lɩɩ ma wɩɩ buloŋ aa sɩ kaŋ ma we wɩbɔŋ yayɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ á kpa anɩɩ ma kɩdɩgɩ rɛ mʋʋ ʋ kyana dɩya tekere, a basɩ tɩya ʋ a baa, ‘Ŋ kyana, sii kyɩma ŋ paanʋʋ gama boto. ");
INSERT INTO sig_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ŋ kyana rɛ lɩɩ ŋmanɩɩ a ko ŋ lee tebine no, ka ŋ bɩ kaŋ kɩŋ buloŋ dɩ ŋ yaa tɩya ʋ dɩ ʋ di.’ ");
INSERT INTO sig_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɛɛ rɛ ɩ kyana hʋ we dɩya tɩyaŋ aŋ basɩ tɩya ɩ a baa, ‘Ta kɩ dɔmɩ-ŋ, ŋ dimbee lara rɛ. Ka ŋ bee ŋ balɩya buloŋ mɛ pɩŋ. Ŋ bɩ sɩ wuwo sii a yaa wɩɩ buloŋ tɩya ɩ.’ ");
INSERT INTO sig_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ŋ basɩ kɩ tɩya ma rɛ, kapuwo ʋ bɩ sɩ sii kpa paanʋʋ hʋ tɩya ɩ akuu ma aa yaa kyaŋsɩ wɩya. Amɛ ʋ sɩ sii tɩya kɩŋ hʋ buloŋ ɩ aa kyɛɛ, akuu ɩ aa bɩ fáá hɩɩsɩ aŋ sɩŋ kɩ sʋla deŋdeŋ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ɛɛwɩya, ŋ basɩ kɩ tɩya ma rɛ, dɩ ɩ rɛ aa sʋl kɩŋ Wɩɩsɩ lee deŋdeŋ, ʋ sɩ kpa tɩya ɩ. Dɩ ɩ rɛ aa kyɛ kɩŋ Wɩɩsɩ lee mɛ, ɩ sɩ na ʋ. Dɩ ɩ rɛ aa ŋmaa boro hʋ, Wɩɩsɩ sɩ kaŋ suri tɩya ɩ. ");
INSERT INTO sig_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Beewɩya, nal hʋ buloŋ aa sʋl kɩna Wɩɩsɩ lee, ʋ aa tɩya ʋ rɛ. Nal hʋ mɛ buloŋ aa kyɛ kɩŋ Wɩɩsɩ lee, ʋ aa na ʋ rɛ. Nal hʋ mɛ buloŋ aa ŋmaa boro hʋ, Wɩɩsɩ aa kaŋ suri tɩya ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kuwo bee rɛ we daha, aa sɩ kpa dʋŋ a tɩya ɩ biye dɩ ʋ rɛ sʋla fuwonamɩya ɩ lee? ");
INSERT INTO sig_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Koo ma kɩbee rɛ sɩ kpa nʋʋma tɩya ɩ biye, dɩ ʋ rɛ sʋla gyihal ɩ lee? ");
INSERT INTO sig_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dɩ mamaa yaŋ aa yaa nɩbɔmɔ rɛ gyɩŋ ma aa sɩ kpa kɩweliye tɩya ma biisi. Ɛɛ rɛ ma Kuwo Wɩɩsɩ aa yaa wɩweliye buloŋ tɩɩna, a we Wɩɩsɩbee tɩyaŋ, kɛ sɩ yaa ʋ bɩ kpaa Wiyesi Welii hʋ kɩ tɩya nala hʋ aa sʋla ʋ kɩ kyɛ.” ");
INSERT INTO sig_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu gyɩ kile gyɩŋbɔŋ kɩ ta baal kɩdɩgɩ tɩyaŋ nɛ. Gyɩna hʋ aa lɩɩ ko teŋ, baal hʋ wuwo kɩ basɩ wɩya, beewɩya gyɩna hʋ fa leŋ ʋ ganɩya rɛ. Wɩɩ no gyɩ yaa gyamaa hʋ buloŋ aa laŋŋa doŋ wɩkperii rɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amɛ nala hʋ badɔmɔŋ baa dɩ gyɩŋbɔmɔ kuwori hʋ ba aa yɩrɩ Bɛlizebul lɛ tɩya ʋ dee dɩ ʋ kɩ kile gyɩŋbɔmɔ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nala hʋ badɔmɔŋ mɛ kɩ kyɛ dɩ ba magɩsɩ Yesu. Ɛɛ rɛ ba baa dɩ ʋ yaa wɩmagɩl dɩ ba na, a gyɩma anɩɩ Wɩɩsɩ rɛ tɩya ʋ dee ʋ kɩ yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu wuwo gyɩŋ ba tɩbɩɩna a basɩ tɩya ba a baa, “Dɩ paalʋʋ nala rɛ we doŋ a bɩ kaŋ nyʋʋdɩgɩ, ba paalʋʋ hʋ sɩ tele. Dɩ nɩmmabalɩya mɛ rɛ we doŋ a bɩ kaŋ nyʋʋdɩgɩ, ba dɩya sɩ tele. ");
INSERT INTO sig_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ɛɛwɩya, dɩ Sɩtaanɩ nala rɛ we doŋ a gʋla kɩ kaa dɔmɔŋ, Sɩtaanɩ koro hʋ mɛ bɩ sɩ sɩŋ.” ");
INSERT INTO sig_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Na ma baa dɩ Bɛlizebul lɛ tɩya ŋ dee ŋ kaŋ kɩ kile gyɩŋbɔmɔ nala tɩyaŋ. Dɩ gɛɛ rɛ yaa wɩtɩɩ, kɩbee rɛ yaŋ tɩya ma hatɩnna mɛ dee ba kɩ kile gyɩŋbɔmɔ nala tɩyaŋ? Ma hatɩnna no tɩɩ daga anɩɩ ma yaa wɩnyɩyɛla rɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amɛ Wɩɩsɩ dee rɛ ŋ kɛ kaŋ kɩ kile gyɩŋbɔmɔ nala tɩyaŋ. Wɩɩ no rɛ yaŋ daga anɩɩ Wɩɩsɩ koro hʋ teŋ we ma tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Dɩ gaduwogi rɛ vʋwa ʋ tʋwanɩ, a hɔŋ pɔ ʋ dɩya, nal buloŋ bɩ sɩ wuwo gyʋʋ dɩya hʋ a kpa kɩŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amɛ dɩ nal mɛ aa deye te ʋ rɛ ko kyigi ʋ, ʋ aa kaŋ ʋ balaala hʋ buloŋ tɩyaŋ ʋ fa aa kpaa ʋ bayɩyɛla we rɛ ʋ laa, aŋ paa ʋ kɩna hʋ buloŋ mʋ dɩ ʋ bee ʋ kyaŋsɩ kaŋ kpaa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nal hʋ buloŋ aa bɩ yaa ŋ nal, ʋ tɩɩna lɩɩ ŋ hal lɛ. Nal hʋ mɛ buloŋ aa bɩ pɛɛ ŋ tɩyaŋ dɩ á kaŋ nala kɩ laŋŋɩ, ʋ tɩɩna ŋmaa pɩsa kɩ ta rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Dɩ gyɩŋbɔŋ nɛ ko lɩɩ nal tɩyaŋ, ʋ aa mʋ gɔllɩ taŋhahɩlɩɩ tɩyaŋ nɛ a kɩ kyɛ liwiyesii. Dɩ ʋ rɛ ko bɩ naa lee, ʋ aa basɩ tɩya ʋ tɩɩ rɛ a baa, ‘Ŋ sɩ mɩɩgɩ mʋ lee hʋ ŋ aa lɩya.’ ");
INSERT INTO sig_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dɩ ʋ rɛ ko mɩɩgɩ mʋ a na dɩ bisiŋ tuwo dɩya hʋ tɩyaŋ, ka ba marɩ ʋ buloŋ weliŋ, ");
INSERT INTO sig_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ʋ aa mɩɩgɩ lɩɩ rɛ, a kaŋ gyɩŋbɔmɔ bapɛ, kɩna mɛ aa bɔmɔ te ʋ tɩɩ, ba ko gyʋʋ a pɛ ʋ tɩyaŋ. Ɛɛ tɩyaŋ nɛ ba yaŋ sɩ lɔrɩ nal hʋ tɩyaŋ a te buŋbuŋ hʋ.” ");
INSERT INTO sig_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu aa basɩ gɛɛ teŋ, dɩ haaŋ kɩdɩgɩ mɛ we nɩgyamaa hʋ tɩyaŋ a faasɩ basɩ tɩya ʋ a baa, “Nyusʋŋtɩɩna rɛ yaa haaŋ hʋ aa lʋla ɩ, a dɩyɛsɩ ɩ.” ");
INSERT INTO sig_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ʋ a baa, “Ɛɛ daa! Amɛ nyusʋŋtɩmma rɛ yaa nala hʋ aa nɩɩ Wɩɩsɩ wɩya, a kɩ tɩŋ ba.” ");
INSERT INTO sig_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nala aa gol Yesu gɛɛ, ʋ basɩ tɩya ba a baa, “Ma gyɩnaŋ nala bɔmɔ rɛ kɩŋkaŋ. Ma baa dɩ ŋ yaa wɩmagɩl dɩ ma na a gyɩma anɩɩ ŋ dee hʋ lɩɩ Wɩɩsɩ lee rɛ. Ŋ bɩ sɩ yaa gɛɛ. Wɩmagɩl hʋ ma aa kyɛ, ma bɩ sɩ na ʋ, see wɩmagɩl hʋ Wɩɩsɩ gyɩ aa yaa ʋ tɩŋdaal Gyoona tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ɛɛ hʋ Wɩɩsɩ tɩŋdaal Gyoona gyɩ aa yaa magɩl a tɩya Ninive tɩmma, ɛɛ tɩɩ rɛ Mɩyaŋ Nihuwobiŋ Biye mɛ sɩ yaa magɩl a tɩya gyɩnaŋ nala. ");
INSERT INTO sig_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Haaŋ kɩdɩgɩ rɛ gyɩ dii paalʋʋ kɩdɩgɩ ba aa yɩrɩ Siiba koro. Dʋnɩya sarɩya hʋ kyɛdiilii, haaŋ no sɩ kpa kyogisi tɩya ma gyɩnaŋ nala. Beewɩya, ʋ paalʋʋ bee Iziral paalʋʋ gyɩ boliye rɛ weliŋ, ka ʋ gyɩ sii mʋ doŋ dɩ ʋ gyegili nɩɩ wɩgyʋŋ hʋ Iziral kuwori Solomɔn aa kana a kɩ daga nala. Ŋ basɩ kɩ tɩya ma rɛ anɩɩ nal lɛ we ma tɩyaŋ daha a te Solomɔn, ka ma bɩ yaa siri dɩ ma gyegili nɩɩ ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dʋnɩya sarɩya kyɛdiilii, Ninive nala mɛ sɩ sii a kpa kyogisi a tɩya ma weliŋ. Saŋa hʋ tɩyaŋ Gyoona gyɩ aa mʋ basɩ Wɩɩsɩ wɩya tɩya Ninive nala, ba gyɩ bɩrɩma lɩɩ ba wɩbɔmɔ tɩyaŋ nɛ aŋ tɩŋ Wɩɩsɩ. Ŋ basɩ kɩ tɩya ma rɛ anɩɩ nal lɛ we ma tɩyaŋ a te Gyoona, ka ma bɩ yaa siri dɩ ma gyegili nɩɩ ʋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ɛɛ rɛ Yesu bɩl daga ba a baa, “Nal buloŋ bɩ sɩ nyɔgɔ fɩŋtɩna ʋ dɩya tɩyaŋ, aŋ kpa faŋa, koo a kpa gbaha kyige tɔ. Ʋ aa kpa dɩ ʋ saga fɩŋtɩŋdaaŋ nyuu tɩyaŋ nɛ dɩ ʋ kyaanɩ dɩya hʋ tɩyaŋ a tɩya nala hʋ buloŋ aa ko kɩ gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɩ sɩya rɛ yaa ɩ teŋ kyaanʋʋ. Dɩ ɩ sɩya rɛ weliye, ɩ teŋ buloŋ aa kaŋ kyaanʋʋ rɛ, amɛ dɩ ɩ sɩya rɛ bɩ weliye, ɩ teŋ buloŋ we bilhuu tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ma pɔ dɩ kyaanʋʋ hʋ ma aa kana ta ko bɩrɩmɩ bilhuu. ");
INSERT INTO sig_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dɩ ɩ teŋ buloŋ nɛ kaŋ kyaanʋʋ, dɩ ɩ lee buloŋ mɛ tuwo bilhuu tɩyaŋ, ɩ teŋ lee buloŋ sɩ we kyaanʋʋ tɩyaŋ, anɩɩ fɩŋtɩna aa kyaanɩ we ɩ tɩyaŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu aa basɩ wɩya no ko teŋ, ɛɛ rɛ Farasii kɩdɩgɩ yɩrɩ ʋ dɩ ʋ ko ʋ dɩya a di kɩna. Ɛɛ rɛ Yesu mʋ hɔŋ dɩ ʋ di kɩdiiliye hʋ, aŋ bɩ sɔŋ nɩɩ anɩɩ ba lesiri aa daga gɛɛ, aŋ kɩ di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farasii hʋ aa naa gɛɛ, ʋ nyʋwa fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɛɛ rɛ á Tɩɩna Yesu basɩ tɩya ʋ a baa, “Mamaa Farasiima, ma aa sasɩ ma gbaŋsɩ abee ma nɩɩnyʋwagbaŋbiisi hala rɛ ba weliye, aŋ bee sasɩ ba tɩsɩ kɛ, ka ba tɩsɩ buloŋ birisi. Ma kɩɩ gɛɛ rɛ anɩɩ nɩɩnyʋwagbaŋbiisi abee gbaŋsɩ no. Ma tenni rɛ weliye, amɛ ma tɩsɩ kɛ tɩyaŋ, ma kaŋ tɩhɔllʋʋ rɛ abee tɩbɩɩŋbɔmɔ. ");
INSERT INTO sig_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɛɛ dɔŋ bambugo! Wɩɩsɩ hʋ aa marɩ ma teŋbiye, ʋ rɛ marɩ ma tɩsɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dɩ mamaa rɛ aa kyɛ dɩ ma tɩsɩ pʋllɩ, ma kpa gbaŋsɩ hʋ tɩya kɩna tɩya nyaaba. ");
INSERT INTO sig_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mamaa Farasiima, ma sɩ na tʋwara yʋga! Paaponni hʋ buloŋ ma aa kpa we kɩdiiliye tɩyaŋ ba sʋwala sʋma, ma aa kaŋ ba kpaa leye fi rɛ, a kpa lɩdɩgɩ sʋla Wɩɩsɩ. Ma aa yaa wɩmʋlla no buloŋ nɛ, aŋ aa vɩya wɩtɩɩ ŋmanɩɩ hʋ kɛ, a bɩ kyo Wɩɩsɩ mɛ. Ma aa kaŋ ma kɩna kpaa leye fi fi, a kpa lɩdɩgɩ tɩya Wɩɩsɩ gɛɛ, ʋ yaa wɩwelii rɛ, amɛ ɛɛ bɩ daga anɩɩ ma vɩya wɩkaalɩya hʋ kɛ ta. ");
INSERT INTO sig_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mamaa Farasiima, ma sɩ na tʋwara yʋga! Dɩ mamaa rɛ ko gyʋʋ wɩɩkyʋwaldɩɩsɩ, ma aa kɩ kyɛ nɩbala nɩhɔnɩya rɛ dɩ ma hɔŋ. Dɩ mamaa rɛ ko gyʋʋ gyamaa tɩyaŋ mɛ, ma aa kɩ kyɛ dɩ nal nal buloŋ yʋwɔgɩ kɩ kyʋwalɩ ma rɛ abee gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ma sɩ na tʋwara yʋga! Ma kɩɩ gɛɛ rɛ anɩɩ bilni bee taŋha aa pɩŋ maga dɔmɔŋ, nala bɩ gyɩma aŋ kɩ vala ba nyuu, a kyogi ba sɩna.” ");
INSERT INTO sig_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu aa basɩ gɛɛ teŋ, Wɩɩsɩ teŋ dɩdagɩl kɩdɩgɩ basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, ɩ aa ko kɩ basɩ wɩya no, ɩ aa kɩ tʋʋsɩ ma mɛ rɛ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ɛɛ rɛ Yesu bɩl baa, “Mamaa Wɩɩsɩ Teŋ dɩdagɩla mɛ, ma sɩ na tʋwara yʋga. Ma aa kpa kyʋgɩyoho rɛ a kyʋgɩ nala, ba bɩl lɔlɔ ba kyʋŋ. Aŋka ma tɩɩ mɛ bɩ sɩ laa nyʋwa pɛ ba tɩyaŋ mʋhʋ mɛ dɩ ba wuwo kyʋŋ kyʋgɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ma sɩ na tʋwara yʋga! Ma aa saa bilweliye rɛ a we Wɩɩsɩ tɩŋdaala hʋ tɩɩ ma naabaala aa kpʋwa. ");
INSERT INTO sig_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nyɛ daga anɩɩ ma laa di anɩɩ wɩɩ hʋ ma naabaala aa yaa kpaa ŋmanɩɩ rɛ. Beewɩya, ba kpʋʋ Wɩɩsɩ tɩŋdaala hʋ rɛ, ma mɛ saa bilni we ba. ");
INSERT INTO sig_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wɩɩ no wɩya, Wɩɩsɩ wɩgyʋŋ tɩyaŋ, ʋ basa rɛ a baa, ‘Ŋ sɩ ta ŋ tɩŋdaala abee ŋ kpambɩsɩ dɩ ba mʋ ba lee. Ba sɩ kpʋ ba badɔmɔŋ aŋ dɔgɩsɩ ba badɔmɔŋ mɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wɩɩsɩ sɩ dɔgɩsɩ gyɩnaŋ nala akuu Wɩɩsɩ tɩŋdaala hʋ ba aa kpʋwa a lɩɩ dʋnɩya piili tɩyaŋ buloŋ wɩya, ");
INSERT INTO sig_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","a lɩɩ saŋa hʋ ba aa kpʋʋ Abɛl a kaŋ mʋ pele saŋa hʋ ba aa kpʋʋ Zakarɩya Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo tɩyaŋ, kogu hʋ tɩyaŋ ba aa kpa kɩna a lɩɩ wɩɩsʋlɩɩ kɩ tɩya Wɩɩsɩ abee Wɩɩkyʋwaldɩɩbal hʋ tɩɩ paga tɩyaŋ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, Wɩɩsɩ sɩ dɔgɩsɩ gyɩnaŋ nala buloŋ kɩŋkaŋ akuu nala no buloŋ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mamaa Wɩɩsɩ Teŋ dɩdagɩla, ma mɛ sɩ na tʋwara yʋga! Ma kaŋ dɩya hʋ nala aa sɩ gyʋʋ a na wɩgyʋŋ lara rɛ, aŋ lɩɩ saafɩɩbiye hʋ faŋa. Ma tɩɩ bee kyɛ dɩ ma gyʋʋ dɩya hʋ aŋ pɔ dɩ nala hʋ aa kyɛ dɩ ba gyʋʋ mɛ ta gyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu aa basɩ wɩya no tɩya ba ko teŋ, aŋ kɩ lɩɩ, Wɩɩsɩ teŋ dɩdagɩla hʋ abee Farasiima hʋ piili kɩ basɩ ʋ wɩya abee baaŋ, a kɩ pɩyɛsɩ ʋ wɩgyamaa. ");
INSERT INTO sig_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Beewɩya ba fa aa kyɛ dɩ ʋ baaŋ sii rɛ dɩ ʋ basɩ wɩɩ kyogi Wɩɩsɩ mɩrɩsɩ hʋ, dɩ ba tɩŋ doŋ kana ʋ. ");
INSERT INTO sig_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gyamaa hʋ gyɩ aa ko laŋŋɩ Yesu lee gyɩ bɩ kyalla, lee hʋ buloŋ gyɩ su abee nala, haalɩ ba kɩ fɩrɩgɩ dɔmɔŋ lee buloŋ. Ɛɛ rɛ Yesu laa sɩya basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma gyɩŋ tɩya ma tɩɩ ma weliŋ abee Farasiima hʋ wɩya, beewɩya ba yaa minaafigi tɩmma rɛ. Ba wɩdagɩya kɩɩ gɛɛ rɛ anɩɩ sɩbʋl. (Dɩ ɩ rɛ kpaa ʋ mʋhʋ mɛ we kɩna tɩyaŋ, ka ba aa sii pʋʋsɩ rɛ). ");
INSERT INTO sig_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wɩɩ buloŋ aa faŋa, ʋ sɩ ko lɩɩ lɩgyalɩɩ dɩ nala nɩɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wɩɩ hʋ buloŋ mɛ ba aa basa bilhuu tɩyaŋ, ba sɩ nɩɩ ʋ pʋlʋŋ tɩyaŋ. Wɩɩ hʋ buloŋ mɛ ba aa miŋse basɩ dɩya tɩyaŋ, ba sɩ gyɩŋ heeli basɩ ʋ salnɩ nyuni tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ɛɛ rɛ Yesu bɩl baa, “Ŋ kyaŋsɩ, ŋ basɩ kɩ tɩya ma rɛ, ma ta kɩ fáá nal hʋ aa sɩ wuwo kpʋ ma teŋbiye dʋŋ, aŋ bɩ sɩ wuwo yaa ma wɩbɔŋ buloŋ pɛ. ");
INSERT INTO sig_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋ sɩ daga ma nal hʋ aa maga dɩ ma kɩ fá. Ma kɩ fá Wɩɩsɩ, beewɩya ʋ rɛ kaŋ dee ʋ aa sɩ wuwo kpʋ ma, aŋ bɩl kaŋ dee mɛ ʋ aa sɩ wuwo kpa ma we diŋ tɩyaŋ. Ŋ basɩ kɩ tɩya ma rɛ, ʋ rɛ maga dɩ ma kɩ fá ʋ. ");
INSERT INTO sig_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma aa kpa kokosi bɔnɔŋ nɛ a yallɩ kobo balɩya dʋŋ. Amɛ Wɩɩsɩ kɛ bee yeŋŋi ba tɩyaŋ kɩdɩgɩ mɛ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɛɛwɩya, ma ta leŋ dɩ wɩɩ buloŋ wɩya yaa ma kambɩŋ, beewɩya Wɩɩsɩ paalɩ gyɩŋ ma nyupʋna mɛ gba nyʋwa rɛ. Wɩɩsɩ lee tɩyaŋ, ma kɩdɩgɩ buloŋ kaŋ tɔnɔ te kokogyamaa rɛ. ");
INSERT INTO sig_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa sɩ suri ʋ nyʋwa gyamaa tɩyaŋ a baa dɩ ʋ yaa ŋ hatɩnna rɛ, Mɩyaŋ Nihuwobiŋ Biye mɛ sɩ basɩ gɛɛ tɩɩ tɩya ʋ Wɩɩsɩ malɩkasɩ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amɛ nal hʋ mɛ buloŋ aa vɩya ŋ wɩya gyamaa tɩyaŋ, Mɩyaŋ Nihuwobiŋ Biye mɛ sɩ vɩya ʋ wɩya Wɩɩsɩ malɩkasɩ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nal hʋ buloŋ aa basɩ wɩbɔŋ a tɩya mɩyaŋ Nihuwobiŋ Biye, Wɩɩsɩ sɩ kpa kyɛ ʋ, amɛ nal hʋ buloŋ aa tʋʋsɩ Wɩɩsɩ Wiyesi Welii hʋ, Wɩɩsɩ bɩ sɩ kpa kyɛ ʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dɩ ba aa rɛ kaŋ ma gyʋʋ Gyuuma wɩɩkyʋwaldɩɩsɩ, koo a kaŋ ma mʋ kuworo abee nɩhɩyasɩ sɩya dɩ ba di ma sarɩya, ma ta leŋ dɩ ma bembiye kɩ sii abee gɛɛ ma aa sɩ basɩ a laa ma tɩɩ, koo wɩɩ kɛ buloŋ ma aa sɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Saŋa hʋ tɩɩ tɩyaŋ, Wɩɩsɩ Wiyesi Welii hʋ rɛ sɩ daga ma wɩɩ hʋ ma aa sɩ basɩ.” ");
INSERT INTO sig_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu fa aa basɩ wɩya kɩ tɩya nɩgyamaa hʋ tɩyaŋ, baal kɩdɩgɩ sii basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, á kuwo sʋba rɛ aŋ ka ʋ kyaŋ. Ŋ aa sʋla ɩ dɩ ɩ basɩ tɩya ŋ maana dɩ ʋ kaŋ kyaŋ hʋ kpaa, a kpa ŋ tol tɩya ŋ.” ");
INSERT INTO sig_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ bagyʋwa, aŋnɛ rɛ lɩɩ ŋ dɩ ŋ di ma wɩɩ no sarɩya, koo dɩ ŋ kaŋ ma kuwo kyaŋ kpaa ma.” ");
INSERT INTO sig_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya nala hʋ a baa, “Ma gyɩŋ tɩya ma tɩɩma weliŋ, a pɔ dɩ ma ta kaŋ tɩbal ma kɩna kyɛyɩ tɩyaŋ. Dɩ nal lɛ kyo ʋ kaŋ kɩna mɔɔgɛɛ buloŋ mɛ, amɛ kɩna hʋ daa aa tɩya ʋ mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Doŋ nɛ Yesu yaŋ maga namaga no tɩya ba a baa, “Baal kɩdɩgɩ rɛ gyɩ we doŋ a kaŋ kɩna weliŋ a biŋ ʋ baga. Ʋ baga hʋ kɩna mɛ yaa weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛɛ rɛ ʋ gyɩ kɩ bɩɩnɩ ʋ tɩya tɩyaŋ a baa, ‘Ɛɛ rɛ ŋ sɩ yaa? Ŋ bɩ kaŋ lee ŋ aa sɩ we ŋ kɩna no buloŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Doŋ nɛ ʋ liisi ʋ tɩya tɩyaŋ a baa, ‘Nyɛ rɛ ŋ sɩ yaa! Ŋ sɩ kyeŋŋi ŋ busolo ŋ aa kana, aŋ marɩ saa kɩbala, a yaŋ kpa ŋ panyʋwa kɩna hʋ buloŋ a we doŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aŋka dɩ ŋ yaŋ basɩ tɩya ŋ tɩɩ a baa, ‘Ŋ yaa nyusʋŋtɩɩna rɛ! Ŋ biŋ kɩna rɛ yʋga. Ŋ sɩ yaa bɩŋgyamaa dɩ ŋ bɩ kyɛɛ kɩŋ buloŋ lɔlɔ. Ŋ sɩ ta gyɩya, a di kɩna aŋ nyʋwa vɔgɔ abee teŋfɩyɛlʋʋ.’ ");
INSERT INTO sig_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ɛɛ rɛ Wɩɩsɩ basɩ tɩya ʋ, ‘Ɛɛ dɔŋ bambugi! Tebine no buloŋ ŋ sɩ laa ɩ mɩɩbol ɩ lee. Ka dɩ á na nal hʋ aa sɩ tɩŋ kɩna hʋ ɩ aa kyɛɛ biŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu aa maga namaga hʋ teŋ, ʋ baa, ‘Nala hʋ buloŋ aa kyɛɛ kɩna biŋ ba tɩɩ wɩya, ba kɩɩ gɛɛ rɛ anɩɩ baal no, beewɩya ba bɩ yaa kɩna tɩmma Wɩɩsɩ sɩya tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɛɛ rɛ Yesu basɩ tɩya ʋ hatɩnna hʋ a baa, “Ɛɛwɩya, ŋ basɩ kɩ tɩya ma rɛ, ma ta leŋ kɩdiiliye hʋ ma aa sɩ di a kaŋ mɩɩbol wɩya kɩ dɔŋ ma, a ta leŋ dɩ gannɩ hʋ mɛ ma aa sɩ kpa we ma tenni wɩya mɛ kɩ dɔŋ ma. ");
INSERT INTO sig_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma mɩɩbol lɛ yaa sɩfɩyaŋ a te kɩdiiliye, ma tenni wɩya mɛ yaa sɩfɩyaŋ a te gannɩ. ");
INSERT INTO sig_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ma na digibiisi! Ba bee pala, ba bɩ kaŋ busolo mɛ a kɩ we kɩdiiliye, ka Wɩɩsɩ kɩ dɩyɛsɩ ba. Amɛ Wɩɩsɩ sɩya tɩyaŋ, mamaa rɛ kaŋ tɔnɔ kɩŋkaŋ buloŋ a te digibiisi. ");
INSERT INTO sig_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dɩ mamaa rɛ leŋ kɩna no wɩya kɩ dɔŋ ma kɛ, ma kɩbee rɛ sɩ wuwo kuu ɛɛ wɩya a kaŋ kyɛdɩgɩ mɛ gba pɛ ʋ mɩɩbol tɩyaŋ, dɩ ʋ kyɛsʋʋ rɛ pele. ");
INSERT INTO sig_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dɩ mamaa rɛ yaŋ bɩ sɩ wuwo kaŋ kyɛdɩgɩ mɛ pɛ ma mɩɩbol tɩyaŋ dɩ ma kyɛyɛ rɛ pele, bee rɛ tɩŋ ma leŋ kɩna no wɩya kɩ dɔŋ ma? ");
INSERT INTO sig_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ma na tɩɩfɩɩla! Ba bee tʋŋ tʋma, ba bɩ sʋwa gannɩ mɛ kɩ laalɩ, amɛ ba weliye rɛ kɩŋkaŋ. Saŋa hʋ Kuwori Solomɔn fa aa we ʋ mɩɩbol tɩyaŋ, ʋ fa kaŋ kɩna rɛ weliŋ. Amɛ ʋ gannɩ mɛ gba fa bɩ weliye maga tɩɩfɩɩla no. ");
INSERT INTO sig_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wɩɩsɩ rɛ aa leŋ ɔhɔ nyʋ, a waa, a weliye, ka ba aa bee pɩɩsɩ aŋ hɩla, ba kpa diŋ nyɔgɔ ta. Dɩ Wɩɩsɩ rɛ aa wuwo leŋ ɔhɔ weliye gɛɛ, bee rɛ tɩŋ ma kɩ bɩɩnɩ anɩɩ ʋ bɩ sɩ wuwo tɩya ma ma teŋbii kɩna? Ma bɩ laa Wɩɩsɩ di yʋga! ");
INSERT INTO sig_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ɛɛwɩya, ma ta leŋ dɩ kɩna hʋ ma aa sɩ di abee kɩna hʋ ma aa sɩ nyʋwa wɩya dʋŋ kyɩl ma. ");
INSERT INTO sig_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nala hʋ aa bɩ gyɩŋ Wɩɩsɩ dʋnɩya no tɩyaŋ, ba aa rɛ aa lʋga kɩ kyɛ kɩna no. Ma Kuwo Wɩɩsɩ gyɩma anɩɩ ma aa kyɛ kɩna no rɛ. ");
INSERT INTO sig_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɛɛwɩya, ma laa sɩya leŋ dɩ Wɩɩsɩ koro hʋ wɩya kyɩl ma. Ʋ sɩ kpa ma kɩkyɛɛlɩya buloŋ pɛ tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ɛɛ rɛ Yesu bɩl baa, “Ma nala hʋ aa tɩŋa ŋ, ma bɩ yʋga, amɛ ma ta leŋ dɩ kambɩŋ kaŋ ma. Ma Kuwo Wɩɩsɩ teŋ fɩyɛla rɛ ʋ aa sɩ leŋ ma di wɩɩsɩbee koro. ");
INSERT INTO sig_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ma kpa ma kɩna buloŋ yallɩ a kpa molbiye hʋ tɩya nyaaba. Ma kɩ kyɛ kɩna hʋ aa bee kyogi a biŋ ma tɩɩ Wɩɩsɩbee tɩyaŋ. Doŋ nɛ ba bɩ sɩ teŋ, beewɩya gaal tuwo doŋ aa sɩ gaa ba, tuyi mɛ tuwo doŋ aa sɩ di ba. ");
INSERT INTO sig_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lee hʋ ɩ sɩfɩyaŋ kɩna aa wee, doŋ nɛ ɩ hakɩla mɛ aa we. ");
INSERT INTO sig_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ma kɩrɩsɩ ma tɩɩ ma weliŋ, a yaa siri pɔ wɩɩ hʋ buloŋ aa sɩ ko ma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ma kɩɩ gɛɛ anɩɩ dɩya tʋŋtʋnnɩ weliye aa kyol ba fɩŋtɩŋsɩ a hɔŋ kɩ gyegili ba dɩya tɩɩna dɩ ʋ lɩɩ hafalɩɩ gbɩyala ko. Dɩ ʋ rɛ ko saŋa buloŋ mɛ, a ŋmaa boro hʋ, ba sɩ kaŋ suri tɩya ʋ lagɩ lagɩ. ");
INSERT INTO sig_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ʋ sɩ yaa wɩwelii rɛ a tɩya tʋŋtʋnna hʋ dɩ ba dɩya tɩɩna hʋ rɛ ko puu ba dɩ ba hɔŋ kɩ gyegili ʋ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ʋ sɩ wuri ʋ gabal, aŋ leŋ dɩ tʋŋtʋnna hʋ hɔŋ dɩ ʋ yaa kɩdiiliye tɩya ba dɩ ba di. ");
INSERT INTO sig_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dɩ ʋ rɛ mɩɩgɩ ko tekere koo saŋa kɛ buloŋ, aŋ ko puu ba dɩ ba hɔŋ kɩ gyegili ʋ, ʋ sɩ yaa wɩwelii rɛ kɩŋkaŋ a tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma bɩɩnɩ wɩɩ no na weliŋ! Dɩ nal lɛ gyɩŋ saŋa hʋ gaala aa sɩ ko gaa ʋ dɩya kɩna, ʋ sɩ bara doo a hɔŋ pɔ ʋ dɩya hʋ dɩ gaala hʋ ta ko gaa ʋ kɩna. ");
INSERT INTO sig_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ma mɛ yaŋ yaa siri, beewɩya, mɩyaŋ Nihuwobiŋ Biye sɩ ko saŋa hʋ tɩyaŋ ma aa bɩ yɩyɛla.” ");
INSERT INTO sig_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ɛɛ rɛ Piita pɩyɛsɩ Yesu a baa, “Tɩɩna, á dʋŋ nɛ ɩ maga namaga no kɩ tɩya koo, ɩ maga kɩ tɩya nal buloŋ nɛ?” ");
INSERT INTO sig_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ɛɛ rɛ á Tɩɩna Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Kɩbee rɛ yaŋ yaa tʋŋtʋnnɩ hʋ aa kaŋ wɩtɩɩ abee wɩgyʋŋ? Ʋ rɛ yaa nal hʋ ʋ nɩhɩyawʋ aa lɩya dɩ ʋ kɩ deŋ ʋ dɩya, aŋ pɛ kɩ tɩya ʋ tʋŋtʋnnɩ dɔŋtɩŋsɩ mɛ kɩdiiliye saŋa hʋ ʋ aa maga dɩ ʋ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dɩ tʋŋtʋnnɩ hʋ rɛ aa yaa wɩya hʋ ʋ nɩhɩyawʋ aa daga ʋ dɩ ʋ yaa, ʋ teŋ sɩ fɩyɛlɩ saŋa hʋ ʋ nɩhɩyawʋ hʋ aa sɩ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ʋ nɩhɩyawʋ hʋ sɩ kpa ʋ kɩna buloŋ we tʋŋtʋnnɩ no nosi tɩyaŋ dɩ ʋ kɩ deŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amɛ dɩ tʋŋtʋnnɩ hʋ rɛ ko liisi ʋ tɩya tɩyaŋ anɩɩ ʋ dɩya hʋ tɩɩna sɩ pɩɩsɩ, ka dɩ ʋ piili kɩ dɔgɩsɩ ʋ tʋŋtʋnnɩ dɔŋtɩŋsɩ hʋ, ba baala abee haana buloŋ, aŋ kɩ di kɩdigalma, a nyʋwa sɩŋ kɩ bugo, ");
INSERT INTO sig_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kyɛɛ hʋ tʋŋtʋnnɩ no aa bɩ yɩyɛla abee saŋa hʋ ʋ aa bɩ gyɩma, haŋ kyɛɛ hʋ rɛ ʋ nɩhɩyawʋ hʋ sɩ mɩɩgɩ ko. Doŋ tɩyaŋ nɛ ʋ sɩ kana ʋ, a dɔgɩsɩ ʋ weliŋ, aŋ kile ʋ ta, a leŋ dɩ ʋ na tʋwara hʋ nala hʋ aa bɩ laa Wɩɩsɩ di aa sɩ na. ");
INSERT INTO sig_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tʋŋtʋnnɩ hʋ aa gyɩŋ wɩɩ hʋ ʋ nɩhɩyawʋ aa kyɛ dɩ ʋ yaa aŋ bɩ yaa siri dɩ ʋ yaa haŋ wɩɩ hʋ, ʋ nɩhɩyawʋ hʋ sɩ vɩɩrɩ ʋ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amɛ tʋŋtʋnnɩ hʋ aa bɩ gyɩŋ wɩɩ hʋ ʋ nɩhɩyawʋ aa kyɛ dɩ ʋ yaa, aŋ yaa wɩɩ hʋ aa maga dɩ ba vɩɩrɩ ʋ mɛ, ba sɩ vɩɩrɩ ʋ mʋhʋ. Dɩ ba kpaa kɩna yʋga a tɩya nal dɩ ʋ kɩ deŋ, ba sɩ kɩ kyɛ kɩna yʋga rɛ a lɩɩ ʋ lee. Dɩ ba kpaa kɩna yʋga kɩŋkaŋ mɛ a tɩya nal dɩ ʋ kɩ deŋ, ba sɩ kɩ kyɛ kɩna yʋga kɩŋkaŋ a lɩɩ ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ɛɛ rɛ Yesu bɩl baa, “Ŋ ko dɩ ŋ we dʋnɩya diŋ nɛ. Ŋ kɛ wɩkyɛɛlɩɩ rɛ fa gba yaa dɩ diŋ hʋ fa piili kɩ di lagɩlagɩ no. ");
INSERT INTO sig_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nɩɩfori kɩdɩgɩ rɛ we doŋ ba aa sɩ fo ŋ. Dɩ ba aa rɛ bɩ foo ŋ teŋ, ŋ hakɩla bɩ sɩ pɩŋ lɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma bɩɩna anɩɩ fɩyɛlʋʋ rɛ ŋ kaŋ ko dʋnɩya? Fɩyɛlʋʋ daa! Ŋ ko rɛ dɩ nala kuu ŋ wɩya a porigi dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A lɩɩ gyɩnaŋ kaŋ kɩ mʋ, dɩ dɩɩdɩgɩ nala rɛ yaa bɔnɔŋ a we doŋ, ba sɩ porigi dɔmɔŋ, dɩ boto kɩŋ yaa kɩdɩgɩ, dɩ balɩya kɩŋ mɛ yaa kɩdɩgɩ. Nala boto hʋ sɩ yaa nyʋʋdɩgɩ, a kaŋ nala balɩya hʋ kɩ kaa kaasɩ. ");
INSERT INTO sig_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kuwoma bee ba biibaala sɩ gʋla kɩ kaa dɔmɔŋ, dɩ nɩmma bee ba toliye mɛ gʋla kɩ kaa dɔmɔŋ. Balama nɩmma bee ba biihaana sɩ gʋla kɩ kaa dɔmɔŋ.” ");
INSERT INTO sig_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Dɩ mamaa rɛ ko na taala sɩŋ ma dosɩɩ tɩyaŋ, ma aa baa dɩ duwoŋ aa kyɛ dɩ ʋ nɩɩ rɛ. Duwoŋ mɛ kɔnɩ aa nɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dɩ mamaa rɛ bɩl ko na puwo lɩɩ fuwomemii dɩɩlaŋ, ma aa baa dɩ lee sɩ nɩma. Lee mɛ kɔnɩ aa nɩma rɛ. ");
INSERT INTO sig_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Minaafigi tɩmma! Ma aa wuwo deŋ taŋha rɛ a deŋ wɩɩsɩnyuu mɛ a wuwo daga wɩɩ hʋ aa sɩ yaa. Bee rɛ yaŋ tɩŋ ma bɩ sɩ wuwo gyɩŋ wɩya hʋ aa yaa dʋnɩya tɩyaŋ lagɩlagɩ no memii?” ");
INSERT INTO sig_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ɛɛ rɛ Yesu bɩl baa, “Ma aa gyɩŋ wɩɩ hʋ aa maga dɩ ma yaa, bee rɛ tɩŋ ma aa bee yaa ʋ? ");
INSERT INTO sig_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dɩ nal lɛ sama ɩ, a kana ɩ kɩ mʋ sarɩya lidiilii, yaa kuwokeri dɩ ma basɩ wɩɩ hʋ we dɔmɔŋ ŋmanɩɩ tɩyaŋ aŋ na pele. Dɩ gɛɛ daa, ʋ sɩ kana ɩ tarɩ mʋ sarɩdiil lee, dɩ ʋ mɛ kpa ɩ we porisi noŋ tɩyaŋ dɩ ba kana ɩ mʋ tɔ dɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ŋ basɩ kɩ tɩya ma rɛ, ba bɩ sɩ lɩɩ ɩ dɩya no tɩyaŋ, see dɩ ɩ tuŋ kyɩŋ hʋ ba aa kere tɩya ɩ teŋ.” ");
INSERT INTO sig_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesu ha gyɩ aa basɩ wɩya kɩ tɩya nala hʋ gɛɛ rɛ, nala badɔmɔŋ basɩ tɩya ʋ gɛɛ hʋ Pilato gyɩ aa leŋ ba kpʋ Galili tɩmma badɔmɔŋ. Galili tɩmma no gyɩ aa kyʋwalɩ Wɩɩsɩ rɛ, a kpa kɩna kɩ sʋla Wɩɩsɩ, ka Pilato gyɩ kpʋ ba. ");
INSERT INTO sig_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ma bɩɩna anɩɩ gɛɛ hʋ Pilato gyɩ aa kpʋʋ Galili tɩmma no daga anɩɩ ba aa rɛ yaa wɩbɔmɔ a te Galili tɩmma buloŋ koo? ");
INSERT INTO sig_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aayɩ, ɛɛ daa. Dɩ mamaa rɛ bɩ bɩrɩma lɩɩ ma wɩbɔmɔ tɩyaŋ, ma buloŋ mɛ sɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ka dɩɩdolii hʋ gyɩ aa tele ŋmaa nala fi abee kyori hʋ kpʋ Silom tɩyaŋ, ma bɩɩna anɩɩ ba aa rɛ yaa wɩbɔmɔ a te nala hʋ buloŋ gyɩ aa we Gyerusalɛm tɩyaŋ koo? ");
INSERT INTO sig_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aayɩ, ɛɛ daa. Ma leŋ dɩ ŋ basɩ tɩya ma, dɩ ma bɩ bɩrɩma lɩɩ ma wɩbɔmɔ tɩyaŋ, ma buloŋ mɛ sɩ sʋba.” ");
INSERT INTO sig_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɛɛ rɛ Yesu maga namaga tɩya ba a baa, “Baal kɩdɩgɩ rɛ gyɩ pɔɔ tutogo ʋ baga tɩyaŋ. Nyɛ rɛ kyɛɛ kɩdɩgɩ ʋ mʋ dɩ ʋ tɔrɩ ʋ nɔnɔ dɩ tɩya hʋ bɩ nɔnɔ. ");
INSERT INTO sig_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ɛɛ rɛ ʋ basɩ tɩya ʋ bagɩdaal hʋ a baa, ‘Bɩsɩ boto rɛ nyɛ tɩya no aa bɩ nɔnɔ. Ʋ maga dɩ ɩ ŋmana ʋ ta rɛ, beewɩya ʋ sɩŋ tɔ lee waasʋ rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Doŋ nɛ bagɩdaal hʋ basɩ tɩya ʋ a baa, ‘Ŋ nɩhɩyawʋ, leŋ dɩ ʋ ha sɩŋ bɩndɩgɩ pɛ dɩ á na. Ŋ sɩ hulo baarɩ ʋ memii, a we nɔbɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bɩna dɩɩlaŋ dɩ ʋ rɛ ko nɔnɔ, ʋ yaa wɩwelii rɛ. Amɛ dɩ ʋ rɛ ko bɩ nɔnɔ, ɛɛ kɛ ɩ sɩ wuwo leŋ dɩ ŋ ŋmaŋ ta.”’ ");
INSERT INTO sig_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kyɛwiyesii hʋ kyɛɛ kɩdɩgɩ Yesu gyɩ aa daga nala Wɩɩsɩ wɩya gyuuma wɩɩkyʋwaldɩya tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dɩ haaŋ kɩdɩgɩ mɛ gyɩ we doŋ. Gyɩŋbɔŋ nɛ gyɩ kana ʋ, a kpa wɩɩla we ʋ, ʋ wɩɩlɩ gɛɛ bɩsɩ fi abee kyori. Wɩɩla hʋ gyɩ leŋ ʋ gʋla rɛ, a bɩ wuwo sii sɩŋ kɩ tannɩ. ");
INSERT INTO sig_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu aa naa haaŋ hʋ, ʋ yɩrɩ ʋ a baa, “Haŋtolibiye, ɩ wɩɩla hʋ lɩɩ ɩ tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ɛɛ rɛ ʋ kpa ʋ nosi a dɔbɔ haaŋ hʋ tɩyaŋ. Haaŋ hʋ tɩɩ sii tannɩ haŋ lagɩlagɩbiye hʋ, aŋ kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɛɛ rɛ wɩɩkyʋwaldɩya hʋ nɩhɩyawʋ na baaŋ Yesu nyuu tɩyaŋ akuu ʋ aa tɩɩbɩ nala Kyɛwiyesii hʋ kyɛɛ wɩya. Aŋ mɩɩgɩ basɩ tɩya nala hʋ a baa, “Kyɛyɛ badʋ rɛ we doŋ a maga dɩ á kpa kɩ tʋŋ tʋma. Kyɛyɛ no badʋ kɩdɩgɩ buloŋ tɩyaŋ, ma sɩ wuwo ko dɩ ba tɩɩbɩ ma, amɛ kyɛwiyesii hʋ kyɛɛ kɛ daa.” ");
INSERT INTO sig_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɛɛ rɛ á Tɩɩna Yesu basɩ tɩya ʋ a baa, “Ɛɛ dɔŋ minaafigi tɩmma! Ma kɩbee rɛ we doŋ aa bɩ sɩ puri ʋ nɔpalɩya koo ʋ kokumo a kaŋ mʋ dɩ ba nyʋwa nɩɩ Kyɛwiyesii hʋ kyɛɛ? ");
INSERT INTO sig_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haaŋ no yaa Abɩraham doho nal lɛ. Sɩtaanɩ kana ʋ vʋwa biŋ bɩsɩ fi abee kyori. Ʋ yaŋ bɩ maga dɩ á laa ʋ ta Kyɛwiyesii hʋ kyɛɛ koo?” ");
INSERT INTO sig_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu aa basɩ gɛɛ, hɩɩsɩ kaŋ ʋ dɔmɔ hʋ buloŋ, aŋka nɩkaalɩya hʋ kɛ tenni fɩyɛlɩ wɩmagɩla hʋ Yesu aa yaa wɩya. ");
INSERT INTO sig_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɛɛ rɛ Yesu pɩyɛsɩ nala hʋ a baa, “Ɛɛ rɛ Wɩɩsɩ koro hʋ kɩɩ? Bekiŋ nɛ ŋ sɩ kpa ʋ magɩsɩ? ");
INSERT INTO sig_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ʋ kɩɩ kɩdoho kɩdɩgɩ bii aa muro kɩŋkaŋ nɛ ba kɩ yɩrɩ masɩtadɩ. Baal kɩdɩgɩ kpa doho ʋ baga tɩyaŋ. Ʋ nyʋ, a waa, a bɩrɩmɩ tɩɩbal. Ɛɛ rɛ digibiisi ko sʋwa ba gyannɩ ʋ naasɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ba a baa, “Bekiŋ nɛ ŋ bɩl sɩ kpa Wɩɩsɩ koro hʋ magɩsɩ? ");
INSERT INTO sig_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wɩɩsɩ koro hʋ kɩɩ gɛɛ rɛ anɩɩ sɩbʋl haaŋ aa kpaa we paanʋʋ muŋ kʋrʋba bʋto tɩyaŋ. Mʋhʋ ko kɩ pɛ dɩ paanʋʋ muŋ hʋ sii pʋwarɩ su tahaŋbal.” ");
INSERT INTO sig_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu gyɩ sii kɩ mʋ Gyerusalɛm nɛ, a gɔllɩ tɩŋ tɔnɩ hʋ buloŋ aa we doŋ dɩɩlaŋ, a kɩ daga nala Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɛɛ rɛ nal kɩdɩgɩ ko pɩyɛsɩ ʋ a baa, “Á Tɩɩna, nala baŋmana dʋŋ nɛ Wɩɩsɩ sɩ laa ta koo nɩgyamaa rɛ ʋ sɩ laa ta?” ");
INSERT INTO sig_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nyɛ rɛ Yesu basɩ tɩya nala hʋ a baa, “Dɩ mamaa rɛ aa kyɛ dɩ ma gyʋʋ Wɩɩsɩ koro hʋ, ma yaa sɩfɩyaŋ a wuwo tɩŋ dimbeenyʋwa hʋ aa bɩ gyalɩya a gyʋʋ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nala yʋga sɩ lʋga dɩ ba tɩŋ doŋ gyʋʋ, amɛ ba bɩ sɩ wuwo. ");
INSERT INTO sig_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kyɛɛ kɩdɩgɩ dɩya hʋ tɩɩna sɩ kaŋ ʋ dimbee tɔ. Ka dɩ ma ko sɩŋ gyaŋhala tɩyaŋ, a kɩ ŋmaa boro hʋ a baa, ‘Á Tɩɩna, kaŋ dimbeenyʋwa hʋ suri tɩya ma.’ Doŋ tɩyaŋ nɛ ʋ sɩ basɩ tɩya ma a baa, ‘Ŋ kɛ bɩ gyɩŋ ma lee buloŋ tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɛɛ rɛ ma mɛ sɩ basɩ tɩya ʋ a baa, ‘Á beel-ɩ buloŋ nɛ fa we doŋ, a laŋŋɩ kɩ di kɩna. Ɩ gba daga ma wɩya yʋga á bee tɩyaŋ mɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɛɛ rɛ ʋ bɩl sɩ basɩ tɩya ma a baa, ‘Ŋ baa ŋ bɩ gyɩŋ lee hʋ ma aa lɩya. Ma fasɩ lɩɩ ŋ sɩya tɩyaŋ. Ɛɛ dɔŋ nɩbɔmɔ!’ ");
INSERT INTO sig_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kyɛɛ kɩdɩgɩ ma sɩ na Abɩraham abee Azɩkɩ abee Gyeekɔbɩ, abee Wɩɩsɩ tɩŋdaala buloŋ, dɩ ba hɔŋ Wɩɩsɩ koro hʋ tɩyaŋ, ka dɩ ma kɛ sɩŋ gyaŋhal tɩyaŋ. Ɛɛ tɩyaŋ nɛ ma sɩ wii sɩnɩɩl, a kyaŋ ma nyɩŋa, aŋ bɩ sɩ wuwo gyʋʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nala sɩ lɩɩ dʋnɩya logiŋ logiŋ buloŋ a gyʋʋ Wɩɩsɩ koro hʋ, a hɔŋ kɩ di kɩna aŋ kɩ gbɩyalɩ. ");
INSERT INTO sig_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wɩtɩɩ rɛ, nala aa yaa nɩbiisi gyɩnaŋ, ba sɩ mɩɩgɩ ko yaa nɩbala, ka dɩ nala mɛ aa yaa nɩbala gyɩnaŋ mɩɩgɩ ko yaa nɩbiisi.” ");
INSERT INTO sig_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saŋa no tɩɩ tɩyaŋ nɛ Farasiima badɔmɔŋ mʋ Yesu lee, a basɩ tɩya ʋ a baa, “Ʋ maga dɩ ɩ lɩɩ Galili paalʋʋ tɩyaŋ nɛ, beewɩya Kuwori Hɛrɔtɩ aa kyɛ dɩ ʋ kpʋ ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma mʋ basɩ tɩya haŋ badarɩ hʋ, dɩ ŋ aa kile gyɩŋbɔmɔ rɛ nala tɩyaŋ, aŋ kɩ tɩɩbɩ nala mɛ daha gyɩnaŋ abee kyiye, dɩ kyiyetuwo rɛ ŋ sɩ teŋ ŋ tʋma. ");
INSERT INTO sig_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Abee gɛɛ buloŋ, ʋ maga dɩ ŋ we ŋmanɩɩ tɩyaŋ nɛ gyɩnaŋ abee kyiye abee kyiyetuwo buloŋ, a kɩ mʋ Gyerusalɛm. Beewɩya, ka doŋ dʋŋ tɩyaŋ nɛ ba foŋ kɩ kpʋ Wɩɩsɩ tɩŋdaala buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O! Gyerusalɛm tɩmma! Mamaa rɛ aa kpʋ Wɩɩsɩ tɩŋdaala hʋ buloŋ, aŋ paa bʋwa kɩ yaga nala hʋ buloŋ Wɩɩsɩ aa tɩma dɩ ba ko ma lee. Ŋ lʋga rɛ dɩ ŋ fa kaŋ ma buloŋ ko laŋŋɩ dɔmɔŋ, a kyige tɔ ma anɩɩ gyimii aa kyige tɔ ʋ biisi gɛɛ, ka ma bɩ laa. ");
INSERT INTO sig_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɛɛwɩya, Wɩɩsɩ baanɩ ma bee tɩya ma rɛ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma bɩl bɩ sɩ na ŋ a kaŋ kɩ mʋ kyɛɛ hʋ ma aa sɩ na ŋ a baa, ‘Wɩɩsɩ sɩ kyiyeli nal hʋ aa ko á Tɩɩna Wɩɩsɩ feŋ tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kyɛwiyesii hʋ kyɛɛ kɩdɩgɩ, Yesu mʋ dɩ ʋ di kɩna Farasiima nɩhɩyawʋ kɩdɩgɩ dɩya tɩyaŋ. Ɛɛ rɛ nala hʋ buloŋ gyɩ aa we doŋ lɩɩ sɩya pɔ ʋ tɩyaŋ, a kɩ deŋ dɩ ba na wɩɩ hʋ ʋ aa sɩ yaa. ");
INSERT INTO sig_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dɩ baal kɩdɩgɩ naasɩ bee ʋ nosi buloŋ aa pʋʋsa mɛ gyɩ we doŋ. Ɛɛ rɛ ʋ sii kpa mʋ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Doŋ nɛ Yesu pɩyɛsɩ Wɩɩsɩ Teŋ dɩdagɩla abee Farasiima hʋ a baa, “Wɩɩsɩ mɩrɩsɩ hʋ tɩya ŋmanɩɩ dɩ á kɩ tɩɩbɩ nala Kyɛwiyesii hʋ kyɛɛ koo gɛɛ ŋmanɩɩ tuwo?” ");
INSERT INTO sig_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba buloŋ tallɩ ba nyʋʋsɩ. Ɛɛ rɛ Yesu kaŋ baal hʋ, a tɩɩbɩ ʋ aŋ leŋ ʋ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɛɛ rɛ ʋ bɩl pɩyɛsɩ ba a baa, “Ma kɩbee biye koo ʋ nʋhʋ rɛ sɩ tele kɔlʋŋ tɩyaŋ Kyɛwiyesii hʋ kyɛɛ, dɩ ʋ tɩɩna vɩya ʋ lɩyɩ?” ");
INSERT INTO sig_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ʋ aa basɩ nyɛ, ba kɩdɩgɩ buloŋ bɩ wuwo laa wɩɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Doŋ nɛ Yesu na dɩ nala hʋ ba aa yɩra ko gyʋʋ bagɩsɩ lɩɩ nɩbala lɩhɔnɩya a kɩ hɔŋ. Ɛɛ rɛ ʋ maga namaga no tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Dɩ ba yɩrɩ ɩ dɩ ɩ ko laŋŋɩbal, ta laa sɩya mʋ bagɩsɩ lɩɩ nɩbal lɩhɔnɩɩ a hɔŋ. Kapuwo ba yɩrɩ nal mɛ aa te ɩ rɛ dɩ ʋ ko laŋŋʋʋ hʋ. ");
INSERT INTO sig_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɛɛwɩya, nal hʋ aa yɩrɩ ma sɩ wuwo ko basɩ tɩya ɩ a baa, ‘Sii ka dɩ nal no hɔŋ ɩ lɩhɔnɩɩ hʋ.’ Dɩ gɛɛ rɛ yaa, ɩ sɩ na dɩ ʋ yaa ɩ hɩɩsɩ, beewɩya, ɩ aa mɩɩgɩ ɩ mʋ hɔŋ nɩbiisi lɩhɔnɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɛɛwɩya, dɩ ba aa rɛ ko yɩrɩ ɩ dɩ ɩ ko laŋŋɩbal, dɩ ɩ ko mʋ, laasɩya mʋ hɔŋ nɩbiisi lɩhɔnɩɩ. Dɩ nal hʋ aa yɩrɩ ɩ hʋ rɛ ko na ɩ, ʋ sɩ basɩ tɩya ɩ a baa, ‘Ŋ kyana, sii ko hɔŋ lɩhɔŋwelii no.’ Dɩ ʋ rɛ yaa gɛɛ, ʋ tɩya ɩ yohuŋ nɛ gɛɛ nala hʋ buloŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nal hʋ buloŋ aa gyigisi ʋ tɩɩ, Wɩɩsɩ sɩ kana ʋ hʋwɔlɩ. Nal hʋ mɛ aa kaŋ ʋ tɩɩ kɩ hʋwɔlɩ, Wɩɩsɩ sɩ kpa ʋ yohuŋ.” ");
INSERT INTO sig_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ɛɛ rɛ Yesu basɩ tɩya nal hʋ aa yɩrɩ ʋ dɩ ʋ ko di kɩdiiliye hʋ a baa, “Dɩ ɩ rɛ ko yaa kɩdiiliye, ta yɩrɩ ɩ kyaŋsɩ koo ɩ naabalɩya, koo ɩ lʋlla, koo ɩ dɔŋtɩŋsɩ kɩna tɩmma. Beewɩya ba mɛ sɩ wuwo maakyiye yɩrɩ ɩ dɩ ɩ ko di kɩdiiliye ba lee a tuŋ ɩ kyɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dɩ ɩ ko baa ɩ yɩrɩ nala dɩ ba ko gbɩyalɩ gbɩyala, a di kɩdiiliye, yɩrɩ nyaaba abee gbarɩga abee nala naasɩ koo nosi aa sʋba abee nyʋlɩma buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dɩ ɩ rɛ yaa gɛɛ, Wɩɩsɩ mɛ sɩ pɛ ɩ tɩyaŋ, beewɩya ba aa rɛ bɩ sɩ wuwo tuŋ ɩ kyɩŋ. Wɩɩsɩ sɩ tuŋ ɩ kyɩŋ kyɛɛ hʋ tɩpʋlʋŋ tɩmma aa sɩ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu aa basɩ wɩɩ no, ɛɛ rɛ nala hʋ aa hɔŋ kɩ di kɩna hʋ kɩdɩgɩ basɩ tɩya ʋ a baa, “Nyusʋŋtɩmma rɛ yaa nala hʋ aa sɩ di kɩna Wɩɩsɩ koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɛɛ rɛ Yesu maga namaga no a baa, “Baal kɩdɩgɩ rɛ gyɩ sii yɩrɩ laŋŋɩbal, a leŋ ba yaa kɩdiiliye su lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɩdiiliye hʋ gyɩ aa ko yaa siri, ʋ tɩŋ ʋ tʋŋtʋnna kɩdɩgɩ dɩ ʋ mʋ basɩ tɩya nala hʋ ʋ aa yɩra anɩɩ wɩɩ buloŋ yaa siri rɛ, dɩ ba kɩ ko. ");
INSERT INTO sig_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ʋ aa mʋʋ yɩrɩ ba, ba buloŋ vɩya, ka kɩdɩgɩ buloŋ kɩ daga wɩɩ hʋ aa tɩŋ ʋ bɩ sɩ wuwo mʋ. Laa sɩya nal hʋ baa, ‘Baga rɛ ŋ yɔbɔ a kɩ kyɛ dɩ ŋ mʋ na. Ɛɛwɩya, ŋ aa sʋla ɩ rɛ, ŋ bɩ sɩ wuwo ko.’ ");
INSERT INTO sig_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kɩdɩgɩ mɛ baa, ‘Nɔpalɩya tʋŋnyʋwa bʋnɔŋ nɛ ŋ yɔbɔ a kɩ kyɛ dɩ ŋ kaŋ mʋ pala na. Ɛɛwɩya, sʋlɩɩ rɛ, ŋ mɛ bɩ sɩ wuwo ko.’ ");
INSERT INTO sig_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kɩdɩgɩ tɩɩna mɛ baa, ‘Kyɛɛ no rɛ ŋ kpaa haaŋ. Ɛɛ wɩya ŋ mɛ bɩ sɩ wuwo ko.’ ");
INSERT INTO sig_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ɛɛ rɛ tʋŋtʋnnɩ hʋ mɩɩgɩ mʋ basɩ tɩya ʋ nɩhɩyawʋ hʋ. Ʋ aa nɩɩ gɛɛ, ʋ baaŋ sii kɩŋkaŋ. Ɛɛ rɛ ʋ bɩl basɩ tɩya ʋ a baa, ‘Lɩɩ lagɩlagɩ, a mʋ ŋmaŋbala hʋ nyʋʋsɩ abee bee hʋ tɩyaŋ ŋmaŋbiisi buloŋ, a yɩrɩ nyaaba abee gbarɩga abee nyʋlɩma, abee nala hʋ naasɩ abee ba nosi aa sʋba buloŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lagɩlagɩ dɩ tʋŋtʋnnɩ hʋ lɩya rɛ, a yɩrɩ nala hʋ buloŋ ba ko gyʋʋ. Ka ʋ gyʋʋ basɩ tɩya ʋ nɩhɩyawʋ hʋ anɩɩ nala hʋ ko rɛ, dɩ amɛ lee ha kaa rɛ. ");
INSERT INTO sig_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ɛɛ rɛ ʋ nɩhɩyawʋ hʋ bɩl basɩ tɩya ʋ a baa, ‘Bɩl lɩɩ mʋ bagɩsɩ ŋmaŋsɩ abee bagɩsɩ hʋ tɩɩ, a yɩrɩ nala dɩ ba ko gyʋʋ, dɩ dɩya hʋ su.’ ");
INSERT INTO sig_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ŋ basɩ kɩ tɩya ma rɛ, nala hʋ ŋ aa laa sɩya yɩrɩ hʋ, ba kɩdɩgɩ buloŋ nyʋwa paalɩ bɩ sɩ dige kɩdiiliye no.” ");
INSERT INTO sig_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu bɩl aa lɩɩ kpa ŋmanɩɩ kɩ mʋ, nɩgyamaa sii paa tɩŋa ʋ hal. Nyɛ rɛ ʋ mɩɩgɩ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Dɩ nal buloŋ nɛ sɩ ko ŋ lee, see dɩ ʋ tɩɩna kyo ŋ a te gɛɛ ʋ aa kyo ʋ kuwo abee ʋ naa, abee ʋ haaŋ bee ʋ balɩya, abee ʋ naabalɩya abee ʋ tɩɩ. Dɩ gɛɛ daa, ʋ bɩ sɩ wuwo yaa ŋ hatɩnnɩ. ");
INSERT INTO sig_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nal hʋ buloŋ aa bɩ kpaa ʋ tɩɩ daagarɩɩ baasɩ a kɩ tɩŋa ŋ hal, ʋ bɩ maga dɩ ʋ yaa ŋ hatɩnnɩ. ");
INSERT INTO sig_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dɩ nal lɛ aa kyɛ dɩ ʋ saa dɩya, ʋ aa laa sɩya hɔŋ nɛ, a bɩɩnɩ na dɩ molbiye hʋ ʋ aa kana sɩ wuwo saa dɩya hʋ teŋ koo ba bɩ sɩ wuwo. ");
INSERT INTO sig_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dɩ ʋ rɛ bɩ yaa gɛɛ, aŋ piili dɩya hʋ sayɩ, dɩ molbiye hʋ ko buwo dɩ ʋ bɩ saa dɩya hʋ teŋ, nala sɩ na wɩboriye hʋ ʋ aa yaa, a mʋma ʋ. ");
INSERT INTO sig_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ba sɩ baa, ‘Baal no piile dɩ ʋ saa dɩya rɛ aŋ bɩ wuwo saa teŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ɛɛ rɛ Yesu bɩl maga namaga kɩdɩgɩ a baa, ‘Dɩ kuwori rɛ sii kaŋ nala tusi fi, a kɩ mʋ dɩ ʋ yuwo ʋ kuwori dɔŋtɩɩna, ka dɩ ʋ kuwori dɔŋtɩɩna hʋ mɛ kaŋ nala tusi mɔlɩya, see dɩ ʋ ha laa sɩya hɔŋ a bɩɩnɩ na dɩ ʋ sɩ wuwo yuwo di ʋ dɔŋtɩɩna hʋ koo ʋ bɩ sɩ wuwo yuwo di ʋ, ka dɩ ʋ na mʋ yuwo hʋ. ");
INSERT INTO sig_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dɩ ʋ rɛ ko bɩɩnɩ na anɩɩ ʋ bɩ sɩ wuwo yuwo di ʋ kuwori dɔŋtɩɩna hʋ, see dɩ ʋ ta tɩŋdaala dɩ ba mʋ kyeŋ ʋ kuwori dɔŋtɩɩna hʋ libolii tɩyaŋ, a sʋla ʋ dɩ ʋ leŋ dɩ ba marɩ dɔmɔŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nyɛ rɛ Yesu yaŋ basɩ tɩya ba a baa, ‘Ɛɛ tɩɩ rɛ, ma kɩdɩgɩ buloŋ bɩ sɩ wuwo yaa ŋ hatɩnnɩ, see dɩ ɩ vɩya kɩŋ buloŋ ɩ aa kana a ta.”’ ");
INSERT INTO sig_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yɩsɩ sʋma, amɛ dɩ ʋ sʋmɩŋ nɛ ko lɩɩ, ɩ bɩl bɩ sɩ wuwo yaa dɩ ʋ sʋma. ");
INSERT INTO sig_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɩ bɩl bɩ sɩ wuwo kpa ʋ we baga tɩyaŋ mɛ gba dɩ ʋ leŋ dɩ kɩna marɩ. See ɩ aa kpaa yuwo ta, beewɩya ʋ bɩl bɩ kaŋ tɔnɔ buloŋ. Nala hʋ aa kaŋ dɩgɩna, ma gyegili nɩɩ wɩya no weliŋ.” ");
INSERT INTO sig_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kyɛɛ kɩdɩgɩ lampolaala abee wɩbɔŋyaala yʋga sii ko Yesu lee rɛ, dɩ ba gyegili nɩɩ ʋ wɩbasɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ɛɛ rɛ Farasiima abee Wɩɩsɩ Teŋ dɩdagɩla hʋ piili kɩ gʋrɩmɩ wɩya a baa, “Baal no leŋ wɩbɔŋyaala kɩ ko ʋ lee rɛ, haalɩ ʋ beel-ba laŋŋɩ kɩ di kɩna.” ");
INSERT INTO sig_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu aa nɩɩ gɛɛ, ʋ maga namaga no tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ma leŋ á kpa anɩɩ ma kɩdɩgɩ rɛ kaŋ piyese kɔɔ, dɩ kɩdɩgɩ nyʋgɩsɩ, ɛɛ rɛ ʋ sɩ yaa? Ʋ aa leŋ piyese mɔllɩbanaa bee fi abee nibi hʋ rɛ ʋ ta pogo tɩyaŋ, ka dɩ ʋ gɔllɩ kyɛ piyesi hʋ aa nyʋgɩsa hʋ. Dɩ ʋ rɛ ko bɩ na ʋ, ʋ bɩ sɩ laa nyʋwa mɩɩgɩ ko bee. ");
INSERT INTO sig_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dɩ ʋ rɛ ko na ʋ, ʋ aa kpa ʋ rɛ ʋ baasɩ mʋ dɩya abee teŋfɩyɛlʋʋ. ");
INSERT INTO sig_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dɩ ʋ ko pele dɩya, ʋ aa yɩrɩ ʋ kyaŋsɩ abee ʋ dɔŋtɩŋsɩ rɛ, ʋ basɩ tɩya ba a baa, ‘Ma leŋ dɩ á buloŋ tenni fɩyɛlɩ. Beewɩya, ŋ naa ŋ piyesi hʋ aa nyʋgɩsa hʋ rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ɛɛ tɩɩ rɛ, ‘Dɩ wɩbɔŋyaaldɩgɩ dʋŋ mɛ rɛ bɩrɩma lɩɩ ʋ wɩbɔmɔ tɩyaŋ, nala hʋ aa we Wɩɩsɩbee tɩyaŋ tenni sɩ fɩyɛlɩ ʋ wɩya, a te nala mɔllɩbanaa bee fi abee nibi aa bɩɩna anɩɩ ba kaŋ tɩpʋlʋŋ nɛ, a bɩ maga dɩ ba bɩrɩma lɩɩ ba wɩbɔmɔ tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Koo ma leŋ á kpa anɩɩ haaŋ kɩdɩgɩ rɛ kaŋ molbinʋʋ kɩna fi, dɩ kɩdɩgɩ nyʋgɩsɩ, ɛɛ rɛ ʋ sɩ yaa? Ʋ aa kyol diŋ nɛ, dɩ ʋ tige ʋ dɩya buloŋ, a deŋ weliŋ a ko mʋ na ʋ. ");
INSERT INTO sig_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dɩ ʋ rɛ ko na ʋ, ʋ aa yɩrɩ ʋ kyaŋsɩ abee ʋ dɔŋtɩŋsɩ buloŋ nɛ ʋ ko laŋŋɩ, a basɩ tɩya ba a baa, ‘Ma leŋ dɩ á buloŋ tenni fɩyɛlɩ. Ŋ molbii hʋ aa nyʋgɩsa hʋ, ŋ naa ʋ rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ɛɛ rɛ Yesu baa, ‘Ŋ basɩ kɩ tɩya ma rɛ, nyɛ tɩɩ rɛ Wɩɩsɩ malɩkasɩ mɛ tenni aa fɩyɛlɩ, dɩ wɩbɔŋyaaldɩgɩ rɛ ko bɩrɩma lɩɩ ʋ wɩbɔmɔ tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu bɩl maga namaga kɩdɩgɩ a baa, “Baal kɩdɩgɩ rɛ gyɩ we doŋ a kaŋ ʋ biibaala balɩya. ");
INSERT INTO sig_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɛɛ rɛ haŋbiye hʋ tɩɩna sii basɩ tɩya ʋ kuwo a baa, ‘Ŋ kuwo, kyaŋ hʋ ɩ aa sɩ sʋba aŋ ka tɩya ma, kpa ŋ tol tɩya ŋ.’ Ɛɛ rɛ ʋ kaŋ kɩna hʋ kpaa ba. ");
INSERT INTO sig_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ʋ bɩ pɩɩsa, ka haŋbiye hʋ tɩɩna sii kpa kɩna hʋ buloŋ ʋ aa laa, a yallɩ, a sii kpa mʋ we paalʋʋ bolii kɩdɩgɩ tɩyaŋ. Doŋ nɛ ʋ kaŋ molbiye hʋ mʋ, a kpa yaa wɩvɩyagyɩmɩya, ba buloŋ teŋ. ");
INSERT INTO sig_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saŋa hʋ ʋ kɩŋ kɩŋ buloŋ aa tene tɩyaŋ nɛ losi sii gyʋʋ doŋ paalʋʋ kɩŋkaŋ, ʋ kyɛ kɩdiilii buloŋ lɔlɔ dɩ ʋ di. ");
INSERT INTO sig_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nyɛ rɛ ʋ sii mʋ na tʋma tɔɔ hʋ tɩmma baal kɩdɩgɩ lee. Baal hʋ kana ʋ mʋ dɩ ʋ kɩ deŋ ʋ porikusi ʋ baga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ʋ aa deŋ porikusi hʋ mɛ, ka nal buloŋ bee tɩya ʋ kɩdiiliye. Ʋ aa hɔŋ deŋ anɩɩ dɩ ʋ rɛ fa naa porikusi hʋ kɩdiiliye badɔmɔŋ mɛ gba, ʋ aa dii rɛ. ");
INSERT INTO sig_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Doŋ tɩyaŋ nɛ ʋ hakɩla yaŋ ko wɩɩ hʋ ʋ aa yaa, abee tʋwara hʋ tɩyaŋ ʋ aa wee. Ɛɛ rɛ ʋ bɩɩnɩ ʋ tɩya tɩyaŋ a baa, ‘Ŋ kuwo mɛ kaŋ tʋŋtʋnna rɛ yʋga. Ba buloŋ nʋrɩgɩ kɩdiiliye tɩyaŋ, a di aŋ kɩ ka, aŋka ŋ ko we daha a kɩ sʋba losi. ");
INSERT INTO sig_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋ sɩ sii a mɩɩgɩ mʋ ŋ kuwo lee. Dɩ mɩyaŋ nɛ ko mʋ, ŋ sɩ basɩ tɩya ʋ a baa, Ŋ kuwo, wɩɩ hʋ ŋ aa yaa, ŋ yaa kyogi Wɩɩsɩ rɛ, a yaa kyogi ɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ŋ bɩl bɩ maga dɩ ɩ kana ŋ yaa ɩ biye. Kpa ŋ dɩ ŋ yaa ɩ tʋŋtʋnna hʋ kɩdɩgɩ á tʋma kɩ tɩya ɩ.’ Ɛɛ rɛ ka ʋ sii kpa kɩ mʋ ʋ kuwo lee. ");
INSERT INTO sig_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ʋ ha gyɩ mʋʋ we libolii rɛ a kɩ ko, ka ʋ kuwo hʋ na ʋ. Sikii buloŋ kana ʋ. Ʋ sii fá mʋ guwori ʋ. ");
INSERT INTO sig_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɛɛ rɛ biye hʋ basɩ tɩya ʋ kuwo a baa, ‘Ŋ yaa kyogi Wɩɩsɩ rɛ, a yaa kyogi ɩ mɛ. Ŋ bɩl bɩ maga dɩ ɩ kana ŋ yaa ɩ biye.’ ");
INSERT INTO sig_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amɛ ʋ kuwo basɩ tɩya ʋ dɩya tʋŋtʋnna a baa, ‘Ma mʋ lagɩlagɩ, a paa gaweliye kaŋ ko laalɩ ʋ. Ma kpa nonipiri a we ʋ noŋ aŋ paa naatɔbɔ mɛ a we ʋ. ");
INSERT INTO sig_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma lɩɩ kaŋ nɔfara ko gyʋʋ kpʋ, dɩ á buloŋ kyaŋ, dɩ á tenni fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ʋ kɩɩ gɛɛ anɩɩ ŋ biye no fa sʋba rɛ aŋ sii. Ʋ fa nyʋgɩsa rɛ, ka á bɩl na ʋ nyɛ. Ɛɛ rɛ ba kɩ di kɩna, a kɩ gbɩyalɩ abee teŋfɩyɛlʋʋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Saŋa no tɩyaŋ dɩ biye hʋ maana mɛ we baga tɩyaŋ. Ʋ bee koyi saŋa aa ko pele, ʋ sii kɩ ko bee. Ʋ ko kɩ kpaga dɩya, dɩ ʋ nɩɩ ba aa ŋmaa kɩna a kɩ gʋwa. ");
INSERT INTO sig_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɛɛ rɛ ʋ yɩrɩ ʋ kuwo dɩya tʋŋtʋnna kɩdɩgɩ a pɩyɛsɩ ʋ a baa, “Bekine wɩya rɛ ba kɩ yaa daha?” ");
INSERT INTO sig_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɛɛ rɛ ʋ basɩ tɩya ʋ a baa, “Ɩ naabiye hʋ rɛ mɩɩgɩ ko. Ɛɛ rɛ ɩ kuwo kaŋ nɔfara kpʋ a tɩya ʋ, beewɩya ʋ mɩɩgɩ ko dɩya abee laaŋfɩya rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nyɛ rɛ biye hʋ maana hʋ na baaŋ kɩŋkaŋ, aŋ vɩya dɩya gyʋʋyɩ. Ɛɛ rɛ ʋ kuwo ko lɩɩ, a sʋla ʋ dɩ ʋ ko gyʋʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Doŋ nɛ ʋ basɩ tɩya ʋ kuwo a baa, “Bɩsɩ no buloŋ tɩyaŋ ŋ tʋŋ tʋma rɛ weliŋ a tɩya ɩ anɩɩ yoŋ. Ŋ ha bɩ maakyiye vɩya ɩ nyʋwa kyɛdɩgɩ mɛ. Ba buloŋ tɩyaŋ, bekiŋ nɛ ɩ yaa tɩya ŋ? Ɩ ha bɩ kaŋ bʋʋŋ mɛ gba tɩya ŋ dɩ ŋ bee ŋ kyaŋsɩ mɛ kpʋ kyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka ɩ biye no kaŋ ɩ kɩna buloŋ mʋ kyogi ta gyaŋtɩrɩsɩ tɩyaŋ, aŋ mɩɩgɩ ko dɩya, ɩ ha bɩl sii kaŋ nɔfara kpʋ tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɛɛ rɛ biye hʋ kuwo basɩ tɩya ʋ a baa, “Ŋ biye, ɩ kɛ we dɩya tɩyaŋ nɛ saŋa buloŋ. Kɩŋ buloŋ ŋ aa kana, ɩ rɛ tɩŋa ʋ. ");
INSERT INTO sig_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amɛ ʋ maga dɩ á leŋ á tenni fɩyɛlɩ rɛ dɩ á gbɩyalɩ, beewɩya ʋ kɩɩ gɛɛ anɩɩ ɩ naabiye no fa sʋba rɛ aŋ sii. Ʋ fa nyʋgɩsa rɛ, ka á bɩl na ʋ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu gyɩ maga namaga no tɩya ʋ hatɩnna rɛ a baa, “Kɩna tɩɩna kɩdɩgɩ rɛ gyɩ we doŋ, a kaŋ tʋŋtʋnnɩ kɩdɩgɩ, a leŋ ʋ kɩ deŋ ʋ kɩna. Ɛɛ rɛ nala ko basɩ tɩya kɩna tɩɩna hʋ anɩɩ ʋ tʋŋtʋnnɩ hʋ kaŋ ʋ dʋwa buloŋ kyogi kɩ ta rɛ. ");
INSERT INTO sig_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ʋ aa nɩɩ gɛɛ, ʋ leŋ ba mʋ yɩrɩ ʋ ko, ʋ pɩyɛsɩ ʋ a baa, ‘Deŋ na ɩ wɩkanɩya hʋ ŋ aa nɩɩ. Ɩ bɩl bɩ maga dɩ ɩ yaa ŋ tʋŋtʋnnɩ-hɩyawʋ. Ɛɛwɩya, leŋ dɩ ŋ gyɩŋ ɛɛ bee ɛɛ buloŋ ɩ aa kpaa ŋ molbiye tʋma.’ ");
INSERT INTO sig_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ɛɛ rɛ baal hʋ bɩɩnɩ ʋ tɩya tɩyaŋ a baa, ‘Ŋ nɩhɩyawʋ aa kyɛ dɩ ʋ kile ŋ tʋma tɩyaŋ nyɛ, ɛɛ rɛ ŋ sɩ yaa? Ŋ bɩ kaŋ dee ŋ aa sɩ pala di. Ŋ bɩl bɩ sɩ wuwo gɔllɩ kɩ sʋla kɩna mɛ. Ŋ sɩ kɩ fá hɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ŋ gyɩŋ gɛɛ ŋ aa sɩ yaa a wuwo kaŋ kyaŋsɩ rɛ, dɩ ŋ tʋma no rɛ ko kyogi mɛ, dɩ ba kana ŋ weliŋ ba dɩɩsɩ tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ɛɛ rɛ ʋ yɩrɩ nala hʋ buloŋ aa di ʋ nɩhɩyawʋ hʋ kyɩma, ba kɩ ko kɩdɩgɩ kɩdɩgɩ. Ɛɛ rɛ ʋ yɩrɩ buŋbuŋ nal hʋ a pɩyɛsɩ ʋ, ‘Ŋ nɩhɩyawʋ kyɩŋ ɩ aa diye yaa baŋmɛ rɛ?’ ");
INSERT INTO sig_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɛɛ rɛ ʋ baa dɩ nʋʋ aŋkʋrɩsɩ kɔɔ rɛ ʋ kyɩma. Ɛɛ rɛ tʋŋtʋnnɩ-hɩyawʋ hʋ kpaa teŋ hʋ aa daga ʋ kyɩŋ a tɩya ʋ aŋ baa, ‘Teŋ no daga anɩɩ ɩ kyɩŋ yaa nʋʋ aŋkʋrɩsɩ kɔɔ rɛ. Amɛ mɩɩgɩ kaŋ sabɩ aŋkʋrɩsɩ mɔllɩbalɩya abee fi.’ ");
INSERT INTO sig_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɛɛ rɛ ʋ bɩl yɩrɩ kɩdɩgɩ tɩɩna mɛ a pɩyɛsɩ ʋ a baa, ‘Ka ɩ mɛ?’ Ʋ mɛ baa dɩ ʋ kyɩŋ yaa mɩbʋwara tusi rɛ. Ɛɛ rɛ tʋŋtʋnnɩ-hɩyawʋ hʋ basɩ tɩya ʋ a baa, ‘Teŋ hʋ aa daga ɩ kyɩŋ nɛ nyɛ. Amɛ mɩɩgɩ kaŋ sabɩ bʋwara kɔɔsɩ kyori. ");
INSERT INTO sig_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɛɛ hal tɩyaŋ nɛ kɩna tɩɩna hʋ bigisi sɩŋgɩrɩŋtɩɩna no aŋ baa dɩ ʋ yaa kuwokeri rɛ abee wɩgyʋŋ no ʋ aa kana a kaŋ kɩ yaa wɩbɔmɔ. Beewɩya nala hʋ aa kyo dʋnɩya kɩna kɩŋkaŋ, ba kaŋ kɩ kyɛ wɩgyʋŋ nɛ weliŋ, a kɩ pɛ dɔmɔŋ tɩyaŋ a te nala hʋ aa tɩŋ Wɩɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, ‘Ŋ basɩ kɩ tɩya ma rɛ, ma kpa ma dʋnɩya kɩna a kyɛ kyaŋsɩ. Dɩ kɩna hʋ rɛ ko teŋ, dɩ Wɩɩsɩ laa ma we ʋ lee, dɩ ma we doŋ a kaŋ kɩ mʋ deŋdeŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dɩ nal lɛ wuwo deŋ kɩna mʋhʋ nyuu abee wɩtɩɩ, ɛɛ daga anɩɩ ʋ aa wuwo ʋ deŋ kɩgyamaa mɛ rɛ abee wɩtɩɩ. Amɛ dɩ nal lɛ bɩ wuwo deŋ kɩna mʋhʋ nyuu abee wɩtɩɩ, ɛɛ daga anɩɩ ʋ bɩ sɩ wuwo deŋ kɩgyamaa nyuu mɛ abee wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dɩ ɩ rɛ bɩ wuwo kɩ deŋ dʋnɩya kɩna nyuu abee wɩtɩɩ, nal buloŋ bɩ sɩ kpa kɩna aa kaŋ tɔnɔ a we ɩ nosi tɩyaŋ dɩ ɩ kɩ deŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dɩ ɩ rɛ bɩ wuwo kɩ deŋ nala kɩna abee wɩtɩɩ, aŋnɛ rɛ sɩ laa nyʋwa kpa ɩ tɩɩ kɩna tɩya ɩ dɩ ɩ kɩ deŋ? ");
INSERT INTO sig_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yoŋdɩgɩ bɩ sɩ wuwo tʋma kɩ tɩya nɩhɩyasɩ balɩya. Ʋ sɩ kyo kɩdɩgɩ aŋ haasɩ kɩdɩgɩ. Ʋ sɩ kɩ tɩŋ kɩdɩgɩ abee wɩtɩɩ aŋ kɩ tɩŋ kɩdɩgɩ mɛ abee dawarɩ. Ɛɛ tɩɩ rɛ, nal bɩ sɩ wuwo tɩŋ molbiye tɩyaŋ aŋ bɩl tɩŋ Wɩɩsɩ mɛ.” ");
INSERT INTO sig_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farasiima hʋ aa nɩɩ wɩya hʋ Yesu aa basa, ba kɩ kyʋʋsɩ lee lee buloŋ, beewɩya ba fa kyo molbiye rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Doŋ nɛ Yesu bɩl basɩ tɩya ba a baa, “Na ma aa kyɛ dɩ nala bɩɩnɩ anɩɩ ma kaŋ wɩtɩɩ rɛ, amɛ Wɩɩsɩ kɛ gyɩŋ ma tɩsɩ rɛ. Kɩna hʋ aa yaa sɩfɩyaŋ kɩna nihuwobisi lee, ba aa rɛ yaa kɩtɔɔnɩ Wɩɩsɩ kɛ lee.” ");
INSERT INTO sig_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nyɛ rɛ Yesu bɩl baa, “Wɩɩsɩ mɩrɩsɩ hʋ Moosi gyɩ aa saba biŋ, abee wɩya hʋ Wɩɩsɩ tɩŋdaala gyɩ aa basa, ba buloŋ gyɩ pɩna rɛ, a kaŋ mʋ pele saŋa hʋ Gyɔɔŋ Wɩɩsɩnɩɩfool hʋ gyɩ aa ko. Ɛɛ hal tɩyaŋ, a yaŋ bɩl piili haŋ saŋa hʋ a kaŋ kɩ ko gyɩnaŋ, ba basɩ Wɩɩsɩ koro hʋ wɩweliye rɛ a kɩ tɩya nala. Ɛɛ rɛ nal buloŋ sii kɩ lʋga sɩfɩyaŋ dɩ ʋ gyʋʋ Wɩɩsɩ koro hʋ. ");
INSERT INTO sig_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wɩɩsɩnyuu abee taŋha buloŋ aa sɩ pirigi dɩɩgɩ, ʋ rɛ sɩ yaa mɔl a te wɩbiibiye mɛ aa sɩ dɩsɩ mɩrɩsɩ hʋ Moosi aa saba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Baal hʋ buloŋ aa vɩya ʋ haaŋ, aŋ bɩl mʋ kpa hadɩma, ʋ yaa sɔŋsɔnnɩ rɛ. Baal hʋ mɛ buloŋ aa kpaa haaŋ aa vɩya ʋ bala, ʋ mɛ yaa sɔŋsɔnnɩ.” ");
INSERT INTO sig_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ɛɛ rɛ Yesu bɩl maga namaga a baa, “Kɩna tɩɩna kɩdɩgɩ rɛ gyɩ we doŋ, a gyɩ kɩ laalɩ gabala dʋŋ, aŋ we sʋma dʋŋ tɩyaŋ kyɛɛ bee ʋ nyʋwa buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Nyaabʋ kɩdɩgɩ mɛ gyɩ we doŋ ba kɩ yɩrɩ Laazʋrɔsɩ, ʋ teŋ buloŋ gyɩ yaa dʋgʋlɩya. Ʋ gyɩ aa sii leŋ ba kana ʋ mʋ holli kɩna tɩɩna hʋ dimbeenyʋwa tɩyaŋ nɛ. Ʋ gyɩ aa kɩ yɩyɛlɩ anɩɩ kɩna tɩɩna hʋ ko kɩ di kɩna, kɩna hʋ aa sɩ tele taŋha dɩ ʋ mɛ paa ba di. Haalɩ, ka vasɩ mɛ gyɩ aa ko kɩ lenni nyaabʋ hʋ dʋgʋlɩya hʋ. ");
INSERT INTO sig_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ɛɛ rɛ nyaabʋ hʋ sii sʋba. Malɩkasɩ ko kpa ʋ a kaŋ mʋ holli Abɩraham logiŋ Wɩɩsɩbee tɩyaŋ, ʋ kɩ nɩɩ sʋma. ");
INSERT INTO sig_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka kɩna tɩɩna hʋ mɛ sii sʋba, ba kpa ʋ hogo. Ʋ mʋ gyʋʋ diŋ a we tʋwara tɩyaŋ. Ɛɛ rɛ ʋ deŋ mʋ na Abɩraham dɩ ʋ hɔŋ libolii, ka Laazʋrɔsɩ mɛ hɔŋ ʋ logiŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɛɛ rɛ ʋ yɩrɩ Abɩraham a baa, ‘Ŋ kuwo Abɩraham, fá ŋ sikii aŋ tɩŋ Laazʋrɔsɩ dɩ ʋ kaŋ ʋ nonii taga nɩɩ, a kaŋ ko lulo we ŋ naŋdeliŋ tɩyaŋ. Ŋ aa na tʋwara rɛ weliŋ diŋ no tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ɛɛ rɛ Abɩraham basɩ tɩya ʋ a baa, ‘Ŋ biye, liisi mʋ pele saŋa hʋ ɩ gyɩ aa we ɩ mɩɩbol tɩyaŋ, ɩ fa aa nɩɩ sʋma rɛ weliŋ, aŋka Laazʋrɔsɩ fa we tʋwara tɩyaŋ. Amɛ lagɩlagɩ no, Wɩɩsɩ leŋ Laazʋrɔsɩ bembii fɩyɛlɩ rɛ daha, aŋka ɩ mɛ we tʋwara tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɛɛ dʋŋ mɛ daa, bootogi luŋii rɛ pɩŋ á beel-ma paga tɩyaŋ. Dɩ nala hʋ aa we á lee rɛ aa kyɛ dɩ ba lɩɩ kyol a mʋ ma lee, ba bɩ sɩ wuwo. Nal mɛ bɩ sɩ wuwo lɩɩ ma lee a kyol ko á lee.’ ");
INSERT INTO sig_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ɛɛ rɛ kɩna tɩɩna hʋ bɩl basɩ tɩya ʋ a baa, ‘Ŋ kuwo Abɩraham, ɛɛ kɛ, ŋ aa sʋla ɩ dɩ ɩ tɩŋ Laazʋrɔsɩ dɩ ʋ mʋ ŋ kuwo dɩya. ");
INSERT INTO sig_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ŋ naabalɩya bɔnɔŋ ha we doŋ. Leŋ dɩ ʋ mʋ kʋrɩsɩ ba dɩgɩna dɩ ba mɛ ta maakyiye ko gyʋʋ tʋwara no tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ɛɛ rɛ Abɩraham basɩ tɩya ʋ a baa, ‘Wɩya hʋ Moosi abee Wɩɩsɩ tɩŋdaala hʋ aa saba biŋ, ɩ naabalɩya hʋ gyɩŋ ba rɛ. Leŋ dɩ ba gyegili nɩɩ ba aŋ kɩ tɩŋ ba.’ ");
INSERT INTO sig_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ɛɛ rɛ kɩna tɩɩna hʋ bɩl baa, ‘Ŋ kuwo, ɛɛ dʋŋ bɩ maga. Amɛ dɩ nal lɛ sii sʋʋ tɩyaŋ a mʋ ba lee, ɛɛ kɛ ba sɩ bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ɛɛ rɛ Abɩraham bɩl basɩ tɩya ʋ a baa, ‘Dɩ ba aa rɛ bɩ sɩ gyegili nɩɩ wɩya hʋ Moosi abee Wɩɩsɩ tɩŋdaala hʋ aa saba, ɛɛ daga anɩɩ dɩ nal lɛ sii sʋʋ tɩyaŋ a mʋ basɩ tɩya ba mɛ, ba ha bɩ sɩ laa di.”’ ");
INSERT INTO sig_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu gyɩ basɩ tɩya ʋ hatɩnna hʋ rɛ a baa, “Wɩya hʋ aa sɩ leŋ dɩ nala yaa wɩbɔmɔ, ba sɩ we doŋ. Amɛ nal hʋ aa sɩ leŋ dɩ nala yaa wɩbɔmɔ, ʋ tɩɩna sɩ na tʋwara kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dɩ ba aa rɛ kpaa nɔŋ vʋwa laalɩ ʋ bagɩna tɩyaŋ, a kpa ʋ yuwo we mpʋwɔnʋʋ tɩyaŋ dɩ ʋ nyʋwa nɩɩ sʋba, ɛɛ rɛ kpɩya ʋ aa we ʋ mɩɩbol tɩyaŋ a leŋ dɩ nala hʋ aa tɩŋa ŋ hal kɩdɩgɩ yaa wɩbɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ma pɔ ma tɩɩ ma weliŋ. Dɩ ɩ dɔŋtɩɩna ko yaa ɩ wɩbɔŋ, leŋ dɩ ʋ gyɩma. Dɩ ʋ rɛ ko baa ʋ kyogo rɛ, kpa kyɛ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dɩ ɩ dɔŋtɩɩna rɛ villi yaa wɩɩ kyogi ɩ kyɛdɩgɩ a maga gɛɛ buloŋ mɛ, ka dɩ ʋ ko yaa buloŋ, ʋ mɩɩgɩ ko a baa dɩ ʋ kyogo rɛ, kpa kyɛ ʋ.” ");
INSERT INTO sig_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɛɛ rɛ Yesu kpambɩsɩ hʋ basɩ tɩya ʋ a baa, “Á Tɩɩna, leŋ dɩ á marɩ laa Wɩɩsɩ di yʋga.” ");
INSERT INTO sig_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɛɛ rɛ á Tɩɩna Yesu basɩ tɩya ba a baa, “Dɩ mamaa rɛ fa laa Wɩɩsɩ di mʋhʋ tɩɩ mɛ, ma sɩ wuwo basɩ tɩya tɩya no dɩ ʋ bee ʋ naaliliye buloŋ sii kyuri mʋ pɔ mpʋwɔnʋʋ tɩyaŋ, dɩ ʋ kɔnɩ tɩŋ ma nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ɛɛ rɛ Yesu bɩl baa, “Dɩ ma kɩdɩgɩ rɛ kaŋ tʋŋtʋnnɩ dɩ ʋ kɩ pala ɩ baga, koo ʋ kɩ daa ɩ piyese, dɩ ʋ rɛ lɩɩ baga koo pedaa ko, ɩ sɩ basɩ tɩya ʋ a baa dɩ ʋ yaa lagɩ a di ʋ kɩdiiliye koo? ");
INSERT INTO sig_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aayɩ, ɩ sɩ basɩ tɩya ʋ dɩ ʋ sii yaa kɩdiiliye tɩya ɩ, aŋ yaa siri a ko tɩga tɩya ɩ, aŋ yaa wɩɩ hʋ buloŋ ɩ aa kyɛ a tɩya ɩ. Dɩ ɩ rɛ ko di teŋ, dɩ ʋ mɛ yaŋ na di. ");
INSERT INTO sig_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɩ sɩ laa nyʋwa kyʋwalɩ ɩ tʋŋtʋnnɩ akuu ʋ aa tʋŋ tʋma hʋ ɩ aa daga ʋ wɩya koo? ");
INSERT INTO sig_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɛɛ rɛ ma mɛ yaŋ kɩɩ! Dɩ mamaa rɛ ko tʋŋ tʋma hʋ ba aa tɩya ma dɩ ma tʋma, ʋ maga dɩ ma baa, ‘Á yaa tʋŋtʋnna rɛ, á bɩ maga dɩ ba lɔllɩ ma, beewɩya á tʋma rɛ á tʋma.”’ ");
INSERT INTO sig_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ɛɛ rɛ Yesu gyɩ bɩl sii kɩ mʋ Gyerusalɛm, a gyɩ mʋ tɩŋ Samaarɩya abee Galili paalʋʋ paga a kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ʋ mʋʋ dɩ ʋ gyʋʋ tɔɔ kɩdɩgɩ, dɩ gbegisi fi rɛ ko kɩ kyeme ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ɛɛ rɛ ba gyɩ mʋ sɩŋ libolii, aŋ huwori yɩrɩ ʋ a baa, “Yesu, á nɩhɩyawʋ, fá á sikii.” ");
INSERT INTO sig_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Doŋ nɛ Yesu na ba a basɩ tɩya ba a baa, “Ma kaŋ ma tɩɩ mʋ daga wɩɩkyʋwal sɩlaala hʋ dɩ ba sʋnnɩ ma na.” Nyɛ rɛ ba kpa kɩ mʋ. Ba aa mʋʋ hʋ tɩyaŋ nɛ, ba gbegisi hʋ pirigi nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba tɩyaŋ kɩdɩgɩ aa yaa Samaarɩya tɩɩna aa naa dɩ ʋ deye gɛɛ, ʋ mɩɩgɩ ko Yesu lee a kɩ dannɩ Wɩɩsɩ yʋga. ");
INSERT INTO sig_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A mʋ tuu gbinni Yesu sɩya tɩyaŋ aŋ kyʋwalɩ ʋ aŋgyʋwasʋ. ");
INSERT INTO sig_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ma nala fi hʋ buloŋ daa ŋ tɩɩbɩ? Lee rɛ nibi hʋ kɛ we? ");
INSERT INTO sig_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bee rɛ tɩŋ baal no aa bɩ yaa Gyuu dʋŋ mɩɩgɩ ko dɩ ʋ kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ?” ");
INSERT INTO sig_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɛɛ rɛ Yesu basɩ tɩya baal hʋ a baa, “Sii kɩ mʋ, ɩ aa laa Wɩɩsɩ di rɛ tɩŋ ɩ deye.” ");
INSERT INTO sig_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farasiima badɔmɔŋ gyɩ pɩyɛsɩ Yesu dɩ saŋa bee tɩyaŋ nɛ Wɩɩsɩ koro hʋ sɩ ko? Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Wɩɩsɩ koro hʋ koyi bɩ yaa wɩɩ ɩ aa sɩ wuwo na abee ɩ sɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wɩɩsɩ koro hʋ we ma tɩyaŋ nɛ. Ɛɛwɩya, nal buloŋ bɩ sɩ wuwo baa, ‘Ma deŋ na, ʋ we daha, koo ʋ we lee kɩdɩgɩ dɔŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Doŋ nɛ Yesu mɩɩgɩ basɩ tɩya ʋ hatɩnna hʋ a baa, “Saŋa kɩdɩgɩ sɩ pele dɩ ma kɩ kyɛ dɩ ma hɔŋ Mɩyaŋ Nihuwobiŋ Biye lee kyɛdɩgɩ dʋŋ mɛ gba, amɛ ma bɩ sɩ na gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nala badɔmɔŋ sɩ basɩ tɩya ma a baa, “Na, ʋ rɛ nyɛ, koo, na ʋ rɛ we daha.” Dɩ ba aa rɛ ko basɩ gɛɛ, ma ta lɩɩ gɔllɩ kɩ kyɛ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kyɛɛ hʋ Mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, nal buloŋ sɩ na ŋ anɩɩ duwoŋ aa lɩgɩsɩ a kyaanɩ wɩɩsɩnyuu nal nal buloŋ na ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amɛ ŋ sɩ laa sɩya na tʋwara, ka dɩ ma gyɩnaŋ nala ha vɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Saŋa hʋ mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, ʋ sɩ kɩɩ gɛɛ anɩɩ saŋa hʋ Nowa gyɩ aa we ʋ mɩɩbol tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa saŋa hʋ tɩyaŋ, nal nal buloŋ gyɩ we doŋ nɛ, a di aŋ kɩ nyʋwa, haana kɩ yala balama, baala mɛ kɩ paa haana, a mʋ pele kyɛɛ hʋ Nowa gyɩ aa gyʋʋ nɩɩduworiboro hʋ, ka nɩɩ ko kpʋ nɩkaalɩya hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɛɛ rɛ ba gyɩ kɩɩ saŋa hʋ tɩyaŋ Lɔɔtɩ mɛ gyɩ aa we ʋ mɩɩbol tɩyaŋ. Nala buloŋ gyɩ we doŋ nɛ, a di aŋ kɩ nyʋwa, badɔmɔŋ kɩ yallɩ kɩna, badɔmɔŋ mɛ kɩ yɔbɔ, badɔmɔŋ kɩ doho kɩna, badɔmɔŋ mɛ kɩ saa dɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ka kyɛɛ hʋ Lɔɔtɩ aa lɩɩ Sodɔm tɩyaŋ, diŋ abee gyɩrɩbʋyɩ gyɩ lɩɩ wɩɩsɩnyuu rɛ, a ko tuu kpa nɩkaalɩya hʋ buloŋ aa we doŋ di. ");
INSERT INTO sig_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ɛɛ tɩɩ rɛ ba sɩ kɩɩ kyɛɛ hʋ mɩyaŋ Nihuwobiŋ Biye mɛ aa sɩ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Haŋ kyɛɛ hʋ dɩ nal lɛ we salnyuu, ʋ ta bɩl kɩ lʋga dɩ ʋ tuu gyʋʋ ʋ dɩya a paa ʋ kɩna. Ɛɛ tɩɩ rɛ, dɩ nal mɛ rɛ we baga tɩyaŋ, ʋ ta bɩl kɩ lʋga dɩ ʋ mɩɩgɩ mʋ dɩya a kpa kɩŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ma liisi mʋ na wɩɩ hʋ gyɩ aa yaa Lɔɔtɩ haaŋ. ");
INSERT INTO sig_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nal hʋ buloŋ aa kyɛ dɩ ʋ laa ʋ tɩɩ mɩɩbol, ʋ bɩ sɩ kaŋ mɩɩbol aa bɩ kaŋ tenii, amɛ nal hʋ aa kuu ŋ wɩya a vɩya ʋ mɩɩbol ta, ʋ tɩɩna rɛ sɩ kaŋ mɩɩbol aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ŋ basɩ kɩ tɩya ma rɛ, haŋ kyɛɛ hʋ, nala balɩya sɩ pɩŋ doo gododɩgɩ tɩyaŋ tebine, dɩ ba kpa kɩdɩgɩ aŋ leŋ kɩdɩgɩ ta. ");
INSERT INTO sig_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Haana balɩya sɩ kɩ nɔŋ mʋŋ, dɩ ba kpa kɩdɩgɩ aŋ leŋ kɩdɩgɩ ta. ");
INSERT INTO sig_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Baala balɩya sɩ we baga tɩyaŋ, dɩ ba kpa kɩdɩgɩ aŋ leŋ kɩdɩgɩ ta.) ");
INSERT INTO sig_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɛɛ rɛ Yesu hatɩnna hʋ pɩyɛsɩ ʋ a baa, “Á Tɩɩna, lee tɩyaŋ nɛ wɩya no sɩ yaa?” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Lee hʋ kɩpʋwa aa pɩna, doŋ nɛ duuno kɩ laŋŋɩ.” ");
INSERT INTO sig_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ɛɛ rɛ Yesu bɩl maga namaga tɩya ʋ hatɩnna hʋ, a daga ba anɩɩ ba aa yaa ba kɩ kyʋwalɩ Wɩɩsɩ saŋa buloŋ, aŋ ta leŋ dɩ ba tenni kɩ yʋwɔrɩ. ");
INSERT INTO sig_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ʋ baa, “Sarɩdiil kɩdɩgɩ rɛ gyɩ we tɔɔ kɩdɩgɩ tɩyaŋ. Ʋ gyɩ bee fá Wɩɩsɩ, a bee tɩya nihuwobisi mɛ gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lohaaŋ kɩdɩgɩ mɛ rɛ gyɩ we tɔɔ hʋ tɩyaŋ. Saŋa buloŋ, ʋ gyɩ aa sii mʋ sarɩdiil no lee, a kɩ sʋla ʋ dɩ ʋ kyiyeli ʋ, a di sarɩya lo ʋ dɔŋtɩɩna kɩdɩgɩ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Piili hʋ tɩyaŋ, lohaaŋ no gyɩ ville sarɩdiil no lee rɛ yʋga, ka ʋ vɩya ʋ kyiyelii. Amɛ akuu lohaaŋ hʋ aa vala kɩ ko ʋ lee kyɛɛ bee ʋ nyʋwa buloŋ wɩya, sarɩdiil hʋ bɩɩnɩ ʋ tɩya tɩyaŋ a baa, ‘Ŋ paalɩ bee fá Wɩɩsɩ, ŋ bee tɩya nihuwobisi mɛ gyɩrɩma, ");
INSERT INTO sig_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Amɛ lohaaŋ no aa vala kɩ dɔmɔ ŋ nyɛ, ŋ sɩ pɛ ʋ tɩyaŋ, a di sarɩya no tɩya ʋ. Dɩ gɛɛ daa, ʋ ha sɩ vɩya aŋ vala kɩ dɔmɔ ŋ dɩ ŋ lɔgʋ mʋ lɩɩ.’ ");
INSERT INTO sig_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɛɛ rɛ á Tɩɩna Yesu mɩɩgɩ basɩ tɩya ʋ hatɩnna hʋ a baa, Sarɩdiil no aa ta bɩ kaŋ wɩtɩɩ, amɛ ma gyegili nɩɩ wɩɩ hʋ ʋ aa basa. ");
INSERT INTO sig_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma yaŋ bɩɩna anɩɩ Wɩɩsɩ kɛ rɛ bɩ sɩ wuwo pɛ ʋ nala tɩyaŋ dɩ ba laa wɩsʋma koo? Dɩ ba aa rɛ ŋmaa wulo kɩ tɩya ʋ wɩɩhaa abee tebine buloŋ, ʋ bɩ sɩ yaa gyegye, ka dɩ ʋ pɛ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ŋ basɩ kɩ tɩya ma rɛ, ʋ sɩ di ba sarɩya lagɩlagɩ, a kpa wɩsʋma tɩya ba. Amɛ kyɛɛ hʋ Mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, ŋ sɩ na nala aa laa Wɩɩsɩ di?” ");
INSERT INTO sig_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nyɛ rɛ Yesu bɩl maga namaga no a tɩya nala hʋ aa laa ba tɩɩ di anɩɩ ba aa rɛ kaŋ tɩpʋlʋŋ a te nal buloŋ, aŋ kaŋ ba dɔŋtɩŋsɩ kɩ kʋwasɩ. ");
INSERT INTO sig_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ʋ baa, “Baala balɩya rɛ gyɩ sii mʋ Wɩɩkyʋwaldɩɩbal hʋ dɩ ba kyʋwalɩ Wɩɩsɩ. Kɩdɩgɩ gyɩ yaa Farasii rɛ, ka kɩdɩgɩ hʋ mɛ yaa lampolaal. ");
INSERT INTO sig_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ɛɛ rɛ Farasii hʋ sii sɩŋ, a kyʋwalɩ Wɩɩsɩ ʋ tɩya tɩyaŋ a baa, ‘Ŋ Tɩɩna Wɩɩsɩ, ŋ aa kyʋwalɩ ɩ aŋgyʋwasʋ rɛ, beewɩya ŋ bɩ kɩɩ nala hʋ aa gɔllɩ kaŋ nala kɩna kɩ fasɩ, koo nala hʋ aa bɩ kaŋ wɩtɩɩ, koo nala hʋ aa gɔllɩ kyɛ nala haana kɩ baŋ. Ŋ bɩ kɩɩ lampolaal no mɛ aa we daha. ");
INSERT INTO sig_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ŋ aa vʋwa nyʋwa bʋlɩya rɛ yɔbɔ buloŋ tɩyaŋ. Kɩŋ hʋ buloŋ mɛ ŋ aa naa, ŋ aa kaŋ kpaa leye fi rɛ, a kpa lɩdɩgɩ tɩya ɩ.’ ");
INSERT INTO sig_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ka lampolaal hʋ mɛ mʋ sɩŋ libolii, a paalɩ bɩ kaŋ ʋ nyuu mɛ gye, aŋ paa ʋ nosi vʋwa ʋ nyuu aŋ baa, ‘Wɩɩsɩ, fá ŋ sikii. Ŋ yaa wɩbɔŋyaal lɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɛɛ rɛ Yesu bɩl baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, saŋa hʋ ba aa kyʋwalɩ Wɩɩsɩ hʋ teŋ, ba balɩya tɩyaŋ, lampolaal hʋ rɛ yaa tɩpʋlʋŋ tɩɩna Wɩɩsɩ sɩya tɩyaŋ. Nal hʋ buloŋ aa kpa ʋ tɩɩ yohuŋ, Wɩɩsɩ sɩ kana ʋ fʋŋɩsɩ. Amɛ nal hʋ buloŋ aa kaŋ ʋ tɩɩ kɩ hʋwɔlɩ, Wɩɩsɩ sɩ kpa ʋ yohuŋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nala badɔmɔŋ mɛ rɛ gyɩ sii kaŋ ba biibiisi ko Yesu lee dɩ ʋ kpa ʋ nosi dɔbɔ ba tɩyaŋ, a sʋla Wɩɩsɩ tɩya ba. Yesu hatɩnna hʋ na ba, a nɔsɩ ba. ");
INSERT INTO sig_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɛɛ rɛ Yesu yɩrɩ biibiisi hʋ, aŋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ biibiisi hʋ ko ŋ lee. Ma ta kil ba. Nala hʋ aa kɩɩ biibiisi no, ba aa rɛ we Wɩɩsɩ koro hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nyɛ rɛ ʋ bɩl basɩ tɩya nala hʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ɩ bɩ yelli Wɩɩsɩ anɩɩ biibiye aa yelli ʋ kuwo abee ʋ naa gɛɛ, ɩ bɩ sɩ wuwo na Wɩɩsɩ koro hʋ gyʋʋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɛɛ rɛ Gyuuma nɩhɩyawʋ kɩdɩgɩ ko Yesu lee a pɩyɛsɩ ʋ a baa, “Nɩhɩyawelii, ɛɛ rɛ ŋ sɩ yaa a kaŋ mɩɩbol aa bɩ kaŋ tenii?” ");
INSERT INTO sig_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ ɩ yɩrɩ ŋ nɩhɩyawelii? Nal buloŋ bɩ weliye, see Wɩɩsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na ɩ gyɩŋ wɩya hʋ Moosi aa saba biŋ dɩ ma kɩ tɩŋa hʋ rɛ? Ba aa rɛ nyɛ: Ta kyɛɛ nal haaŋ koo nal bala. Ta kpʋʋ nal. Ta gaa. Dɩ ɩ rɛ yaa daŋsɩya wɩɩ tɩyaŋ, ta nyɩya wɩya, kɩ fá ɩ kuwo abee ɩ naa.” ");
INSERT INTO sig_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɛɛ rɛ baal hʋ baa, “Ŋ aa tɩŋ wɩya no kɛ buloŋ nɛ a lɩɩ ŋ biibiri tɩyaŋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ʋ aa basɩ gɛɛ, Yesu bɩl basɩ tɩya ʋ a baa, “Wɩdɩgɩ rɛ kaa ɩ ha aa sɩ yaa. Mʋ kpa ɩ kɩŋ kɩŋ buloŋ yallɩ, a kpa molbiye hʋ tɩya nyaaba, aŋ ko kɩ tɩŋa ŋ. Dɩ ɩ rɛ yaa gɛɛ, ɩ sɩ kaŋ kɩna wɩɩsɩbee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Baal hʋ aa nɩɩ wɩɩ no, ʋ tɩya buloŋ kyogi, beewɩya ʋ gyɩ kaŋ kɩna rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu aa naa dɩ ʋ tɩya kyogo gɛɛ, ʋ baa, “Ʋ yaa wɩduwo rɛ anɩɩ kɩna tɩmma aa sɩ wuwo gyʋʋ Wɩɩsɩ koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nyɔgɩmaa aa sɩ tɩŋ gahaŋ sɩɩ lɩɩ, ʋ rɛ yaa mɔl a te gɛɛ kɩna tɩɩna aa sɩ yaa a gyʋʋ Wɩɩsɩ koro hʋ.” ");
INSERT INTO sig_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nala hʋ aa nɩɩ Yesu aa basɩ gɛɛ, ba pɩyɛsɩ ʋ a baa, “Kɩbee rɛ yaŋ Wɩɩsɩ sɩ laa ta?” ");
INSERT INTO sig_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩɩ hʋ aa kperi nihuwobiŋ, ʋ bɩ kpere Wɩɩsɩ kɛ.” ");
INSERT INTO sig_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ɛɛ rɛ Piita basɩ tɩya ʋ a baa, “Deŋ na, á kɛ leŋ á kɩŋ kɩŋ buloŋ ta rɛ aŋ kɩ tɩŋa ɩ hal.” ");
INSERT INTO sig_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa sɩ kuu Wɩɩsɩ koro hʋ wɩya a leŋ ʋ dɩya abee ʋ haaŋ koo ʋ naabalɩya koo ʋ kuwo abee ʋ naa koo ʋ biisi, ");
INSERT INTO sig_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Wɩɩsɩ sɩ tɩya ʋ tɩɩna kɩna yʋga a te kɩna hʋ ʋ aa leŋ ta. Dɩ ʋ rɛ ko sʋba mɛ, Wɩɩsɩ sɩ tɩya ʋ mɩɩbol hʋ aa bɩ kaŋ tenii.” ");
INSERT INTO sig_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ɛɛ rɛ Yesu kaŋ ʋ hatɩnna fi abee balɩya hʋ gɩɩgɩ lɩɩ, a basɩ tɩya ba a baa, “Ma gyegili nɩɩ daha. Á aa mʋ Gyerusalɛm nɛ. Doŋ tɩyaŋ, Mɩyaŋ Nihuwobiŋ Biye wɩya hʋ Wɩɩsɩ tɩŋdaala hʋ aa saba biŋ, ba buloŋ sɩ ko su ba bʋʋsɩ. ");
INSERT INTO sig_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba sɩ kpa ŋ we nala hʋ aa bɩ yaa Gyuuma nosi tɩyaŋ dɩ ba yaa ŋ sɩya. Ba sɩ tʋʋsɩ ŋ aŋ pɛ tʋ naŋtʋwɔl mɛ we ŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba sɩ vɩɩrɩ ŋ aŋ kpʋ ŋ, amɛ ŋ sɩ sii sʋʋ tɩyaŋ ʋ kyɛtoo kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amɛ Yesu hatɩnna hʋ gyɩ bɩ gyɩŋ wɩya no memii. Wɩya no buloŋ gyɩ yaa wɩfaŋɩya rɛ ba lee. Ba gyɩ bɩ gyɩŋ wɩɩ hʋ wɩya Yesu aa basɩ. ");
INSERT INTO sig_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu bee ʋ hatɩnna hʋ aa mʋʋ hʋ tɩyaŋ nɛ, ba mʋ kpaga tɔɔ kɩdɩgɩ ba aa yɩrɩ Gyɛriko. Dɩ banyʋlʋŋ kɩdɩgɩ mɛ hɔŋ ŋmanɩɩ hʋ nyʋwa a kɩ sʋla kɩna. ");
INSERT INTO sig_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nyʋlʋŋ hʋ aa nɩɩ nɩgyamaa hʋ aa baŋ dɔmɔ, ʋ pɩyɛsɩ a baa, “Bee rɛ aa yaa?” ");
INSERT INTO sig_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɛɛ rɛ ba basɩ tɩya ʋ anɩɩ Yesu aa lɩɩ Nazarɛti rɛ aa baŋ. ");
INSERT INTO sig_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɛɛ rɛ ʋ yɩrɩ Yesu a baa, “Yesu, Deviti nihii, fá ŋ sikii.” ");
INSERT INTO sig_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nala hʋ aa we ʋ sɩya nɔsɩ ʋ, dɩ ʋ leŋ ʋ kyagɩŋsɩ hʋ. Amɛ ʋ marɩ yɩrɩ yʋga a te gɛɛ a baa, “Yesu, Deviti nihii, fá ŋ sikii.” ");
INSERT INTO sig_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ɛɛ rɛ Yesu sɩŋ aŋ baa dɩ ba kaŋ nyʋlʋŋ hʋ ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ba aa kana ʋ ko pele, Yesu pɩyɛsɩ ʋ a baa, “Bekiŋ nɛ ɩ kɩ kyɛ dɩ ŋ yaa tɩya ɩ?” Ʋ basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, ŋ aa kyɛ dɩ ŋ bɩl kɩ na rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ɛɛ rɛ Yesu basɩ tɩya ʋ, “Ɩ sɩya suro rɛ. Ɩ aa laa Wɩɩsɩ dɩ rɛ rɛ tɩŋ ɩ deye.” ");
INSERT INTO sig_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Doŋ nɛ ʋ sɩya pirigi suri, ʋ sii kɩ tɩŋ Yesu hal a kɩ dannɩ Wɩɩsɩ. Nɩgyamaa hʋ buloŋ aa naa gɛɛ, ba buloŋ mɛ kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nyɛ rɛ Yesu gyɩ bɩl mʋ lɩɩ Gyɛriko, a vala tɩŋ bee hʋ tɩyaŋ kɩ mʋ, dɩ baal kɩdɩgɩ ba aa yɩrɩ Zakiyo rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ʋ fa yaa lampolaala nɩhɩyawʋ rɛ, a fa kaŋ kɩna mɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakiyo gyɩ aa kyɛ dɩ ʋ na haŋ nal hʋ iriŋ Yesu aa yaa rɛ, amɛ gyamaa gyɩ aa we doŋ wɩya, ʋ gyɩ bɩ wuwo dɩ ʋ na ʋ, beewɩya ʋ gyɩ yaa nɩkuu rɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛɛ rɛ ʋ parɩ nala hʋ buloŋ ta, aŋ fá mʋ sɩya, a gyɩŋ tɩya dɩ ʋ wuwo na Yesu. Ʋ gyɩ gyɩma anɩɩ Yesu sɩ ko tɩŋ tɩya hʋ memii baŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu aa ko tɩŋ tɩya hʋ memii kɩ baŋ, ʋ wil deŋ tɩya hʋ nyuu a na Zakiyo, a basɩ tɩya ʋ a baa, “Zakiyo, ko tuu lagɩ, beewɩya ɩ dɩyaŋ nɛ ŋ sɩ pɩŋ gyɩnaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakiyo aa nɩɩ gɛɛ, ʋ teŋ buloŋ fɩyɛlɩ. Ʋ gɩlɩŋsɩ ko tuu lagɩ lagɩ a kaŋ Yesu mʋ ʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nala hʋ buloŋ aa we doŋ aa naa gɛɛ, ba piili kɩ gʋrɩmɩ wɩya a baa, “A! Ma na baal no kɔnɩ aa mʋ dɩ ʋ pɩŋ wɩbɔŋyaal no dɩya tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saŋa hʋ á Tɩɩna Yesu aa we Zakiyo dɩya tɩyaŋ, Zakiyo sii sɩŋ a basɩ tɩya ʋ a baa, “Ŋ nɩhɩyawʋ, ŋ sɩnɩɩ no tɩyaŋ, ŋ sɩ kaŋ ŋ kɩna buloŋ kpaa leye balɩya, a kpa lɩdɩgɩ tɩya nyaaba. Ka dɩ mɩyaŋ nɛ fa firimi nal buloŋ mɛ, ŋ sɩ tuŋ ʋ tɩɩna maga gɛɛ ŋ aa firimi ʋ naaŋsɩɩnyʋwa bʋnaa.” ");
INSERT INTO sig_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Wɩɩsɩ laa ɩ bee ɩ dɩya nala buloŋ ta rɛ gyɩnaŋ. Beewɩya ɩ mɛ yaa Abɩraham doho nal lɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mɩyaŋ Nihuwobiŋ Biye ko dɩ ŋ kyɛ na nala hʋ aa nyʋgɩsa rɛ, a laa ba ta.” ");
INSERT INTO sig_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Saŋa hʋ Yesu gyɩ aa ko kpaga Gyerusalɛm, ɛɛ rɛ ʋ maga namaga no tɩya nala hʋ aa gyegile kɩ nɩɩ wɩya hʋ ʋ aa basɩ. Beewɩya nala hʋ gyɩ aa bɩɩnɩ anɩɩ ʋ aa kpaga Gyerusalɛm nyɛ, Wɩɩsɩ koro hʋ koyi mɛ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ʋ gyɩ baa, “Nɩbal kɩdɩgɩ rɛ gyɩ siye, a kɩ mʋ paalʋʋ bolii kɩdɩgɩ, dɩ ba holli ʋ ʋ bee koro, ka dɩ ʋ mɩɩgɩ ko. ");
INSERT INTO sig_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ʋ gyɩ aa sii dɩ ʋ mʋ, ʋ gyɩ yɩrɩ ʋ dɩya tʋŋtʋnna fi ko laŋŋɩ rɛ, a kpa salɩŋbidɩgɩ dɩgɩ tɩya ba kɩdɩgɩ buloŋ, aŋ baa dɩ ba kaŋ kɩ bɩrɩmɩ dɩ ʋ mʋ aŋ ko. ");
INSERT INTO sig_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amɛ nɩbal no bee nala gyɩ haasɩ ʋ rɛ weliŋ. Ʋ gyɩ aa mʋ ko teŋ, ba mɛ gyɩ sii tɩŋ tɩŋdaala dɩ ba kile ʋ lugo, a mʋ basɩ tɩya kuworibal hʋ lee ʋ aa mʋ dɩ ʋ holli ʋ koro hʋ, anɩɩ ba bɩ kyo dɩ baal hʋ yaa ba kuwori. ");
INSERT INTO sig_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Abee gɛɛ buloŋ, ka ba gyɩ holli baal hʋ koro hʋ, ka ʋ mɩɩgɩ ko. Ʋ gyɩ aa mɩɩgɩ ko, ʋ yɩrɩ ʋ tʋŋtʋnna hʋ ʋ fa aa kpaa molbiye hʋ tɩya, dɩ ʋ na ba kɩdɩgɩ buloŋ aa naa tɔnɔ maga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nyɛ rɛ buŋbuŋ tʋŋtʋnnɩ ko basɩ tɩya ʋ a baa, ‘Ŋ nɩhɩyawʋ, molbii hʋ ɩ aa kpaa tɩya ŋ hʋ, ŋ mɛ kaŋ tʋma rɛ a na maga gɛɛ fi a pɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ɛɛ rɛ ʋ nɩhɩyawʋ hʋ basɩ tɩya ʋ a baa, ‘Gyaaŋbiye, gasɩbɩnaa! Ɩ yaa tʋŋtʋnnɩtɩɩ rɛ. Ɩ aa yaa gɛɛ a deŋ kɩbiibiye no nyuu weliŋ abee wɩtɩɩ nyɛ, ŋ sɩ leŋ dɩ ɩ kɩ deŋ tɔbala fi.’ ");
INSERT INTO sig_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɛɛ rɛ tʋŋtʋnnɩlɩya hʋ tɩɩna mɛ ko ʋ lee a baa, ‘Ŋ nɩhɩyawʋ, molbii hʋ ɩ aa kpaa tɩya ŋ hʋ, ŋ mɛ kaŋ tʋma rɛ a na maga gɛɛ bʋnɔŋ a pɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ɛɛ rɛ ʋ nɩhɩyawʋ hʋ basɩ tɩya ʋ dɩ ʋ mɛ sɩ kɩ deŋ tɔbala bɔnɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ɛɛ rɛ tʋŋtʋnna hʋ kɩdɩgɩ mɛ ko a basɩ tɩya ʋ a baa, ‘Ŋ nɩhɩyawʋ, na ɩ molbii hʋ ɩ aa kpaa tɩya ŋ. Ŋ kaŋ mʋ gulo gakɔsʋŋ tɩyaŋ nɛ a kpa faŋa. ");
INSERT INTO sig_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ŋ aa fá ɩ rɛ, beewɩya ɩ wɩya hayɛ rɛ kɩŋkaŋ. Ɩ aa kaŋ nala kɩna kɩ fasɩ rɛ aŋ aa kɩ kʋŋ kɩna mɛ ɩ aa bɩ doho.’ ");
INSERT INTO sig_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ɛɛ rɛ ʋ nɩhɩyawʋ hʋ basɩ tɩya ʋ a baa, ‘Ɩ yaa tʋŋtʋnnɩbɔŋ nɛ. Wɩya hʋ ɩ aa basa tɩɩ rɛ ŋ sɩ kpa di ɩ sarɩya dɩ ɩ tele. Ɩ gyɩma anɩɩ ŋ wɩya hayɛ rɛ, ŋ kaŋ nala kɩna kɩ fasɩ, aŋ pɛ kɩ kʋŋ kɩna ŋ aa bɩ doho. ");
INSERT INTO sig_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bee rɛ yaŋ tɩŋ ɩ fa bɩ kaŋ ŋ molbii hʋ mʋ biŋ bangi tɩyaŋ? Ŋ fa aa mɩɩgɩ ko nyɛ, ŋ fa sɩ laa molbii hʋ abee ʋ tɔnɔ buloŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɛɛ rɛ ʋ basɩ tɩya ʋ tʋŋtʋnnɩ dɔŋtɩŋsɩ hʋ fa aa sɩŋ doŋ a baa, ‘Ma laa salɩŋbidɩgɩ hʋ ʋ lee, a kpa tɩya nal hʋ aa kaŋ kɩna fi hʋ.’ ");
INSERT INTO sig_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, ‘Nɩhɩyawʋ, na ʋ kɛ foŋ kaŋ molbiye fi rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, ‘Nal hʋ aa kaŋ kɩna yʋga, Wɩɩsɩ sɩ marɩ kpa kɩna yʋga a pɛ a tɩya ʋ, amɛ nal hʋ aa bɩ kaŋ kɩna yʋga, mʋhʋ hʋ mɛ ʋ aa kana, Wɩɩsɩ sɩ kaŋ ba laa ʋ lee. ");
INSERT INTO sig_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka nala hʋ mɛ aa haasɩ ŋ, a bɩ kyo dɩ ŋ yaa ba kuwori hʋ, ma kasɩ ba ko ŋ sɩya daha, a kpʋ ba ŋ sɩɩ tɩyaŋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu aa basɩ wɩya no ko teŋ, ʋ sii kpa ŋmanɩɩ, a laa ʋ hatɩnna hʋ sɩya, ba kɩ mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba aa ko kpaga Bɛtifage abee Bɛɛtani, a ko pele Olivi dogimo hʋ lee, ɛɛ rɛ Yesu lɩɩ ʋ hatɩnna hʋ tɩyaŋ nala balɩya a tɩŋ ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ma mʋ tɔɔ hʋ aa we ma sɩya. Dɩ mamaa rɛ ko mʋ, ma sɩ na kokubiye dɩ ba kaŋ vʋwa sɩgɩ. Nal buloŋ ha bɩ maakyiye gyɩna ʋ. Ma puri a kaŋ ko. ");
INSERT INTO sig_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dɩ nal buloŋ nɛ ko pɩyɛsɩ ma a baa dɩ bee rɛ tɩŋ ma kɩ puri, ma baa dɩ Tɩɩna hʋ rɛ baa dɩ ma puri kaŋ ko.” ");
INSERT INTO sig_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba aa mʋʋ doŋ, wɩya hʋ buloŋ kɔnɩ yaa rɛ anɩɩ gɛɛ Yesu aa basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba aa puri kokubiye hʋ tɩyaŋ nɛ, ʋ tɩmma pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma kɩ puri kokubiye hʋ?” ");
INSERT INTO sig_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɛɛ rɛ ba basɩ tɩya ba a baa, “Tɩɩna hʋ rɛ aa kyɛ ʋ.” ");
INSERT INTO sig_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɛɛ rɛ ba kaŋ kokubiye hʋ mʋ tɩya Yesu, a wuri ba gabala a dɔbɔ kokubiye hʋ tɩyaŋ, aŋ tɩga tɩya Yesu ʋ gyɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ʋ aa gyɩŋ kokubiye hʋ kɩ mʋ tɩyaŋ, nala kpa ba gabala a gyarɩ ŋmanɩɩ hʋ tɩyaŋ, ʋ kɩ vala ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu aa mʋʋ kpaga Gyerusalɛm, lee hʋ ŋmanɩɩ hʋ a lɩɩ Olivi dogimo hʋ nyuu tuu, nɩgyamaa hʋ fa aa tɩŋ ʋ hal piili kɩ gyʋwɔsɩ, a kɩ dannɩ Wɩɩsɩ yʋga akuu wɩmagɩla hʋ buloŋ ba aa naa wɩya. ");
INSERT INTO sig_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba baa, “Wɩɩsɩ sɩ pɛ kuwori hʋ aa ko á Tɩɩna Wɩɩsɩ feŋ tɩyaŋ. Fɩyɛlʋʋ sɩ we Wɩɩsɩbee tɩyaŋ, ka dɩ Wɩɩsɩ feŋ mɛ yɩrɩ.” ");
INSERT INTO sig_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ɛɛ rɛ Farasiima badɔmɔŋ fa aa we nɩgyamaa hʋ tɩyaŋ basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, basɩ tɩya ɩ hatɩnna hʋ dɩ ba leŋ kyagɩŋsɩ.” ");
INSERT INTO sig_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma leŋ dɩ ŋ basɩ tɩya ma, dɩ nala no rɛ tallɩ ba nyʋʋsɩ mɛ, bʋwa no tɩɩ sɩ sii dannɩ Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu aa ko kpaga Gyerusalɛm a na tɔɔ hʋ, ʋ tɩya buloŋ gyɩ kyogi, ʋ wii bee hʋ bee ʋ nala wɩya, aŋ baa, ");
INSERT INTO sig_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ŋ fa kyo dɩ ma bee no nala gyɩŋ wɩɩ hʋ ma aa sɩ yaa a hɔŋ abee laaŋfɩya rɛ gyɩnaŋ, amɛ lagɩlagɩ no ʋ yaa wɩfaŋɩɩ rɛ ma lee. ");
INSERT INTO sig_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kyɛɛ kɩdɩgɩ sɩ pele dɩ ma dɔmɔ ko kyige ma bee no, a tɔ ma we, dɩ ma kyɛ lee lɔlɔ dɩ ma lɩɩ fá. ");
INSERT INTO sig_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba sɩ kpʋ bee no nal nal buloŋ, aŋ kyeŋŋi bee hʋ mɛ buloŋ. Bʋdɩgɩ mɛ bɩ sɩ ka dɔbɔ ʋ dɔŋtɩɩna tɩyaŋ. Beewɩya, saŋa hʋ tɩyaŋ Wɩɩsɩ aa ko dɩ ʋ laa ma ta, ma vɩya ʋ nyʋwa rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nyɛ rɛ Yesu sii mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ, a na dɩ nala aa yallɩ kɩna doŋ. Ɛɛ rɛ ʋ piili kil ba kɩ ta ba kɩ lɩɩ, ");
INSERT INTO sig_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","aŋ basɩ tɩya ba a baa, “Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa dɩ Wɩɩsɩ baa: ‘Ŋ dɩya sɩ yaa lee hʋ nala aa sɩ kɩ kyʋwalɩ ŋ nɛ’. Aŋka ma kɛ mɩɩgɩ kaŋ bɩrɩmɩ gaala dɩya.” ");
INSERT INTO sig_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kyɛɛ kɛ buloŋ nɛ Yesu gyɩ aa kɩ daga nala Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ. Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla abee Gyuuma nɩhɩyasɩ kɩ kyɛ dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amɛ ba gyɩ bɩ gyɩŋ ŋmanɩɩ hʋ ba aa sɩ tɩŋa kpʋ ʋ, beewɩya nala hʋ buloŋ fa aa we doŋ gyegile kɩ nɩɩ wɩya hʋ ʋ aa basɩ rɛ abee sɩfɩyasɩ a bee kyɛ dɩ wɩdɩgɩ mɛ bɩ ba dɩgɩŋ. ");
INSERT INTO sig_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kyɛɛ kɩdɩgɩ, Yesu gyɩ sii mʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ a kɩ daga nala aŋ pɛ basɩ Wɩɩsɩ wɩweliye hʋ kɩ tɩya ba. Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla abee Gyuuma nɩhɩyasɩ sii kpa ko ʋ lee. ");
INSERT INTO sig_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A pɩyɛsɩ ʋ a baa, “Degɛɛ rɛ ɩ kana a wuwo kɩ yaa wɩya no? Kɩbee rɛ tɩya ɩ ŋmanɩɩ ɩ kɩ yaa wɩya no buloŋ?” ");
INSERT INTO sig_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ mɛ sɩ pɩyɛsɩ ma wɩɩ, dɩ ma lɩɩ ʋ sɩɩ tɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Aŋnɛ rɛ gyɩ tɩya Gyɔɔŋ ŋmanɩɩ ʋ kɩ fo nala wɩɩkyʋwalnɩɩ gɛɛ, Wɩɩsɩ rɛ koo nihuwobisi rɛ?” ");
INSERT INTO sig_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nyɛ rɛ ba sɩŋ kɩ vʋʋlɩ dɩ ba kyɛ wɩɩ hʋ ʋ aa pɩyɛsɩ ba sɩɩ, a kɩ pɩyɛsɩ dɔmɔŋ a baa, “Wɩbee rɛ á sɩ basɩ? Dɩ ámaa rɛ baa Wɩɩsɩ rɛ tɩya Gyɔɔŋ gɛɛ ŋmanɩɩ, ʋ sɩ pɩyɛsɩ ma a baa dɩ bee rɛ yaŋ tɩŋ á gyɩ bɩ laa wɩya hʋ ʋ gyɩ aa basɩ di? ");
INSERT INTO sig_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dɩ ámaa rɛ bɩl baa dɩ nihuwobisi rɛ tɩya ʋ gɛɛ ŋmanɩɩ, gyamaa no aa laŋŋa daha sɩ paa bʋwa yaga ma, beewɩya ba buloŋ laa di anɩɩ Gyɔɔŋ fa yaa Wɩɩsɩ tɩŋdaal lɛ.” ");
INSERT INTO sig_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Á bɩ gyɩŋ nal hʋ aa tɩya ʋ gɛɛ ŋmanɩɩ.” ");
INSERT INTO sig_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Doŋ nɛ Yesu mɛ basɩ tɩya ba a baa, “Tɔɔ, ŋ mɛ bɩ sɩ daga ma nal hʋ aa tɩya ŋ ŋmanɩɩ ŋ kɩ yaa wɩya no.” ");
INSERT INTO sig_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɛɛ rɛ Yesu gyɩ bɩl maga namaga a tɩya nala hʋ aa we doŋ a baa, “Baal kɩdɩgɩ rɛ gyɩ kpaa ʋ baga, a pɔ tɩsɩ badɔmɔŋ aa kaŋ nɔŋkyɩga a kɩɩ gɛɛ anɩɩ kyʋkyɔyɩ, ba kɩ yɩrɩ girepisi. Ɛɛ rɛ ʋ paa nala we dɩ ba kɩ deŋ baga hʋ, aŋ sii mʋ paalʋʋ kɩdɩgɩ, a pɩɩsɩ doŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nyɛ rɛ tɩɩsɩ hʋ ko nɔnɔ a yaa tɔrɩɩ. Baga hʋ tɩɩna sii tɩŋ ʋ dɩya tʋŋtʋnna kɩdɩgɩ dɩ ʋ mʋ baga tʋŋtʋnna hʋ lee a laa ʋ tɩɩnɔnɔ tol ko tɩya ʋ. Ʋ sii mʋ, ba kana ʋ a ŋmaa ʋ weliŋ, aŋ kile ʋ ta, ʋ mɩɩgɩ kaŋ nohɩllɩ mʋ baga hʋ tɩɩna lee. ");
INSERT INTO sig_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɛɛ rɛ ʋ bɩl tɩŋ ʋ tʋŋtʋnna hʋ kɩdɩgɩ mɛ. Ʋ mɛ bɩl mʋ. Baga tʋŋtʋnna hʋ ŋmaa ʋ mɛ, aŋ we ʋ hɩɩsɩ tɩyaŋ aŋ bɩl kile ʋ mɛ ta, ʋ mɛ mɩɩgɩ mʋ abee nohɩllɩ. ");
INSERT INTO sig_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɛɛ rɛ ʋ bɩl tɩŋ nitoo hʋ tɩɩna. Ba bɩl ŋmaa ʋ mɛ we wɩɩla, aŋ kile ʋ ta. ");
INSERT INTO sig_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ɛɛ rɛ baga hʋ tɩɩna baa, ‘Ɛɛ rɛ ŋ sɩ yaa? Ŋ sɩ tɩŋ ŋ biye tɩɩ. Kapuwo, ba sɩ tɩya ʋ kɛ gyɩrɩma.’ Ɛɛ rɛ ʋ sii tɩŋ ʋ biikyoolii ʋ mɛ kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tʋŋtʋnna hʋ aa naa biye hʋ dɩ ʋ aa ko, ɛɛ rɛ ba basɩ tɩya dɔmɔŋ a baa, ‘Baga hʋ tɩɩna biye tɩɩ rɛ nyɛ. Dɩ baga hʋ tɩɩna rɛ ko sʋba, biye no rɛ sɩ di ʋ kɩna hʋ buloŋ kyaŋ. Ma leŋ dɩ á kpʋ ʋ, aŋka dɩ baga hʋ bɩrɩmɩ á kɩŋ.’ ");
INSERT INTO sig_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɛɛ rɛ ba kana ʋ tarɩ lɩɩ baga hʋ tɩyaŋ a ŋmaa ʋ kpʋ. Doŋ nɛ Yesu pɩyɛsɩ nala hʋ a baa, ‘Ɛɛ rɛ ma bɩɩnɩ anɩɩ baga hʋ tɩɩna sɩ yaa nala no? ");
INSERT INTO sig_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ʋ sɩ ko kpʋ tʋŋtʋnna hʋ buloŋ, aŋ kpa baga hʋ a tɩya nɩdʋŋsɩ.’ Nala hʋ aa nɩɩ wɩya hʋ Yesu aa basa, ba baa dɩ Wɩɩsɩ ta laa nyʋwa dɩ gɛɛ yaa. ");
INSERT INTO sig_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ɛɛ rɛ Yesu deŋ ba, aŋ pɩyɛsɩ ba a baa, ‘Ba sabɩ Wɩɩsɩ teŋ tɩyaŋ nɛ anɩɩ bʋyɩ hʋ dɩɩsaala hʋ aa vɩya ta, ʋ rɛ ko yaa dɩya hʋ bʋwa buloŋ sɩfɩyaŋ bʋyɩ. Wɩɩ no memii rɛ yaa bee? ");
INSERT INTO sig_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nal hʋ buloŋ aa sɩ tele bʋyɩ no nyuu, ʋ tɩɩna sɩ kyɔrɩsɩ kyɔrɔkyɔrɔ. Dɩ bʋyɩ no mɛ rɛ ko tele nal buloŋ nyuu, ʋ sɩ nɔmɔ ʋ tɩɩna nʋgʋgʋ.”’ ");
INSERT INTO sig_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩla abee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ kɩ lʋga dɩ ba kaŋ Yesu doŋ tɩyaŋ, beewɩya ba gyɩma anɩɩ ba aa rɛ ʋ maga namaga hʋ kɩ daga. Amɛ ba gyɩ aa fá nala hʋ aa we doŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɛɛ rɛ ba kɩ kyɛ ŋmanɩɩ hʋ ba aa sɩ tɩŋa a kana ʋ. Nyɛ rɛ ba kaŋ molbiye mʋ kpala nala badɔmɔŋ, aŋ leŋ ba fugo mʋ Yesu lee gɛɛ anɩɩ ba aa yaa nɩtɩɩma. Ba baa dɩ ba mʋ magɩsɩ ʋ, a pɩyɛsɩ ʋ wɩya a na dɩ ʋ rɛ ko basɩ wɩɩ kyogi, dɩ ba tɩŋ gɛɛ tɩyaŋ kana ʋ mʋ we Roma nɩhɩyawʋ hʋ aa deŋ doŋ paalʋʋ nosi tɩyaŋ, dɩ ʋ yaa ʋ gɛɛ buloŋ ʋ aa kyɛ. ");
INSERT INTO sig_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɛɛ rɛ nala hʋ ba aa turo we hʋ sii mʋ Yesu lee, a pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, á gyɩma anɩɩ wɩya hʋ ɩ aa basɩ abee wɩya hʋ ɩ daga ma buloŋ yaa wɩtɩɩ rɛ. Á gyɩma anɩɩ ɩ aa daga Wɩɩsɩ ŋmanɩɩ tɩɩ rɛ, aŋ bee fá nal buloŋ mɛ sɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tɔɔ, á yaŋ aa kyɛ dɩ á gyɩma rɛ dɩ ʋ yaa ŋmanɩɩ rɛ dɩ á tuŋ lampoo a kɩ tɩya Roma paalʋʋ kuworibal hʋ koo ʋ bɩ yaa ŋmanɩɩ?” ");
INSERT INTO sig_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amɛ Yesu kɛ gyɩ gyɩŋ ba dawarɩ hʋ buloŋ, a basɩ tɩya a ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ma kaŋ molbinʋʋ hʋ ko dɩ ŋ na.” Ba aa kpaa molbinʋʋ hʋ tɩya ʋ, ʋ mɩɩgɩ pɩyɛsɩ ba a baa, “Kɩbee nyuu abee ʋ feŋ nɛ ba kpa biŋ molbii hʋ tɩyaŋ nyɛ?” Ɛɛ rɛ ba baa dɩ Roma paalʋʋ kuworibal hʋ feŋ abee ʋ nyuu rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ɛɛ rɛ Yesu baa, “Ɛɛ kɛ, kɩŋ hʋ aa yaa Roma paalʋʋ kuworibal hʋ kɩŋ, ma kpa tɩya ʋ, ka kɩŋ hʋ mɛ aa yaa Wɩɩsɩ kɩŋ, ma kpa tɩya Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ʋ aa basɩ gɛɛ, ba bɩl bɩ naa wɩɩ buloŋ ba aa sɩ wuwo tɩŋ gɛɛ tɩyaŋ kana ʋ nala aa we doŋ sɩya tɩyaŋ. Wɩya hʋ ʋ aa basa yaa ba wɩkperii rɛ, ba nyʋʋsɩ buloŋ mɛ fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɛɛ rɛ Sadusiima badɔmɔŋ mɛ sii ko Yesu lee. Nala no gyɩ laa di rɛ anɩɩ nala hʋ aa sʋba bɩl bɩ sɩ wuwo sii sʋʋ tɩyaŋ. Ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, ");
INSERT INTO sig_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Á nɩhɩyawʋ, Wɩɩsɩ teŋ tɩyaŋ, Moosi daga ma anɩɩ dɩ baal lɛ kpaa haaŋ, dɩ ʋ bee haaŋ hʋ bɩ kaŋ biye, aŋka dɩ baal hʋ sʋba, dɩ ʋ maga ʋ naabiye kpa lohaaŋ hʋ rɛ a lʋl biisi tɩya ʋ maana hʋ aa sʋba. ");
INSERT INTO sig_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tɔɔ, nɩmmabalɩya bapɛ rɛ gyɩ we doŋ, ba buloŋ yaa baala. Ba kɩhɩyawʋ tɩɩna kpa haaŋ. Ʋ bee haaŋ hʋ bɩ lʋl biye, ka ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɛɛ rɛ ʋ katɩyal kpa haaŋ hʋ. Ʋ beel-ʋ mɛ bɩ lʋl biye, aŋ ka ʋ mɛ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Too hʋ tɩɩna mɛ kpa haaŋ hʋ. Ɛɛ tɩɩ puu ʋ mɛ. Nyɛ rɛ nɩmmabalɩya no bapɛ buloŋ kpa haaŋ hʋ, a sʋba mʋ teŋ dɩ ba kɩdɩgɩ buloŋ bee haaŋ hʋ bɩ lʋl biye. ");
INSERT INTO sig_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɛɛ hal tɩyaŋ nɛ haaŋ hʋ mɛ sii sʋba. ");
INSERT INTO sig_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kyɛɛ hʋ nala aa sɩ mɩɩgɩ sii sʋʋ tɩyaŋ, baala no bapɛ tɩyaŋ kɩbee rɛ sɩ tɩŋ haaŋ hʋ? Beewɩya ba buloŋ bapɛ rɛ ʋ yala ko baŋ parɩ.” ");
INSERT INTO sig_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ɛɛ rɛ Yesu mɩɩgɩ basɩ tɩya ba a baa, “Gyɩnaŋ dʋnɩya no tɩyaŋ kɛ, baala aa paa haana rɛ, haana mɛ kɩ yala balama. ");
INSERT INTO sig_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amɛ saŋa hʋ nala hʋ aa sɩ sii sʋʋ tɩyaŋ a kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii hʋ tɩyaŋ kɛ, baala bɩl bɩ sɩ kɩ paa haana, haana mɛ bɩl bɩ sɩ kɩ yala balama. ");
INSERT INTO sig_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba buloŋ aa mɩɩgɩ ba kɩɩ gɛɛ rɛ anɩɩ malɩkasɩ. Ba bɩl bɩ sɩ kɩ sʋba. Wɩɩsɩ aa kyisi ba sʋʋ tɩyaŋ wɩya, ba yaa Wɩɩsɩ biisi rɛ. ");
INSERT INTO sig_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moosi daga anɩɩ nala hʋ aa sʋba sɩ mɩɩgɩ sii sʋʋ tɩyaŋ nɛ a kaŋ mɩɩbol. Wɩɩsɩ teŋ logiŋ kɩdɩgɩ tɩyaŋ ba fa saba rɛ anɩɩ Moosi naa dɩ diŋ we tɩɩbiye kɩdɩgɩ tɩyaŋ nɛ, aŋ bee di tɩya hʋ bee ɔhɔ hʋ aa we doŋ buloŋ, ka Moosi basɩ baa, ‘Á Tɩɩna Wɩɩsɩ yaa Abɩraham abee Azɩkɩ abee Gyeekɔbɩ Wɩɩsɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ʋ aa basɩ nyɛ daga anɩɩ Wɩɩsɩ yaa weye Wɩɩsɩ rɛ, ʋ bɩ yaa sʋʋnɩ Wɩɩsɩ, beewɩya Wɩɩsɩ kɛ lee nal buloŋ weye rɛ.”’ ");
INSERT INTO sig_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɛɛ rɛ Wɩɩsɩ Teŋ dɩdagɩla badɔmɔŋ basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, ɩ bee nyɩya! Ɩ basɩ ba bʋʋsɩŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Beewɩya ba gyɩ bɩl bɩ kaŋ nyʋwa ba aa sɩ pɩyɛsɩ ʋ wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ɛɛ rɛ ba sɩ wuwo baa dɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, sɩ yaa Deviti nihii rɛ? ");
INSERT INTO sig_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deviti tɩɩ basa Wɩɩsɩ teŋ logiŋ kɩdɩgɩ ba aa yɩrɩ Yɩɩla tɩyaŋ nɛ a baa, “Ŋ Tɩɩna Wɩɩsɩ basɩ tɩya ŋ Tɩɩna rɛ a baa, ‘hɔŋ ŋ noduu logiŋ, ");
INSERT INTO sig_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ka dɩ ŋ yuwo di ɩ dɔmɔ buloŋ teŋ’. ");
INSERT INTO sig_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deviti tɩɩ yɩrɩ nal no ʋ Tɩɩna rɛ. Ɛɛ rɛ ʋ yaŋ sɩ yaa a yaa Deviti nihii dʋŋ?” ");
INSERT INTO sig_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nala hʋ buloŋ gyɩ aa gyegile kɩ nɩɩ Yesu wɩbasɩɩ hʋ tɩyaŋ nɛ, ʋ mɩɩgɩ basɩ tɩya ʋ hatɩnna hʋ a baa, ");
INSERT INTO sig_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ma pɔ ma tɩɩ ma weliŋ abee Wɩɩsɩ Teŋ dɩdagɩla no wɩya. Ba aa gɔllɩ kɩ baŋ abee ba gadoliye rɛ gyiyegyiye, a kɩ kyɛ dɩ nala yʋwɔgɩ kɩ kyʋwalɩ ba. Dɩ ba aa rɛ ko mʋ wɩɩkyʋwaldɩya koo laŋŋɩbal buloŋ, ba aa kɩ kyɛ dɩ ba hɔŋ nɩbala lɩhɔnɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba aa fugo kyʋwalɩ Wɩɩsɩ kɩ pɩɩsɩ rɛ, a kaŋ lohaana kɩna kɩ fasɩ. Saŋa hʋ Wɩɩsɩ aa sɩ di dʋnɩya sarɩya, ba tʋwara bɩ sɩ kyallɩ.” ");
INSERT INTO sig_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Saŋa kɩdɩgɩ Yesu gyɩ we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ nɛ a na kɩna tɩmma dɩ ba lɩɩ molbiye kɩ sʋla Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Doŋ nɛ ʋ na lohaaŋ kɩdɩgɩ mɛ dɩ ʋ kpaa aniiniima balɩya a ko lo we wɩɩsʋllɩ-gbaha hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ɛɛ rɛ Yesu baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, lohaaŋ no rɛ wee a te nala hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Beewɩya, nala hʋ buloŋ aa kpaa molbiye a sʋla Wɩɩsɩ, ba lɩya rɛ aŋ ka. Amɛ haaŋ no kɛ, abee ʋ nyaabʋsɩ hʋ buloŋ, ʋ dɩya abee ʋ bee buloŋ nɛ ʋ kpa sʋla Wɩɩsɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu hatɩnna hʋ badɔmɔŋ gyɩ aa basɩ Wɩɩkyʋwaldɩɩbal hʋ wɩya rɛ, a baa dɩ ʋ weliye, dɩ bʋwa hʋ ba aa kpaa saa ʋ mɛ weliye, abee kɩweliye hʋ iriŋ nala aa kpaa sʋla Wɩɩsɩ ba kpa marɩ dɩya hʋ tɩya, dɩ ba buloŋ nɛ leŋ dɩya hʋ weliye gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nyɛ rɛ Yesu baa, “Dɩya no bee ʋ kɩweliye hʋ buloŋ ma aa naa nyɛ, saŋa kɩdɩgɩ sɩ pele dɩ ba ŋmaa ba buloŋ lo. Bʋdɩgɩ mɛ paalɩ bɩ sɩ ka a dɔbɔ ʋ dɔŋtɩɩna tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, “Nɩhɩyawʋ, saŋa bee tɩyaŋ nɛ wɩya no sɩ yaa? Bekiŋ wɩɩ rɛ sɩ yaa dɩ á na a gyɩma anɩɩ wɩya no kpaga yayɩ rɛ?” ");
INSERT INTO sig_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma kɩ gyɩma weliŋ dɩ nal buloŋ ta ko mʋrɩ ma. Nala yʋga sɩ ko a kpa ŋ feŋ anɩɩ ba aa rɛ yaa Krisita hʋ, a baa dɩ saŋa hʋ dʋnɩya aa sɩ teŋ kpaga rɛ. Amɛ ma ta ko kɩ tɩŋ ba hal. ");
INSERT INTO sig_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma sɩ nɩɩ yuwo abee kaasɩ dɔmɔ lɩkpagɩsɩ abee liboliye tɩyaŋ. Dɩ mamaa rɛ ko nɩɩ ba wɩya, ma ta leŋ dɩ ma bembiye kɩ sii. Wɩya no buloŋ sɩ laa sɩya yaa, amɛ gɛɛ bɩ daga nɩɩ dʋnɩya hʋ tenii pele rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Paalʋʋ kɩdɩgɩ nala sɩ sii a mʋ yuwo paalʋʋ kɩdɩgɩ nala. Tɔɔ kɩdɩgɩ kuwori abee ʋ nala sɩ sii giri a mʋ yuwo kuwori kɩdɩgɩ mɛ abee ʋ nala. ");
INSERT INTO sig_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Taŋha sɩ gyigili kɩŋkaŋ, dɩ losi mɛ gyʋʋ. Wɩɩla sɩ gyʋʋ nala lee buloŋ tɩyaŋ, wɩbɔŋlɔrɩnɩ abee wɩmagɩla buloŋ sɩ yaa wɩɩsɩnyuu tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aŋka dɩ wɩya no buloŋ na yaa, ba sɩ kasɩ ma, a dɔgɩsɩ ma. Ba sɩ kaŋ ma gyʋʋ wɩɩkyʋwaldɩɩsɩ, a di ma sarɩya aŋ kaŋ ma tɔ dɩɩsɩ tɩyaŋ. Ba sɩ kuu ŋ wɩya, a kaŋ ma mʋ kuworo abee nɩbala sɩya. ");
INSERT INTO sig_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wɩya no tɩyaŋ nɛ ma sɩ na ŋmanɩɩ a basɩ Wɩɩsɩ wɩweliye hʋ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amɛ ma kaŋ ma tɩɩ ma weliŋ, a sɩŋ wɩdɩgɩ tɩyaŋ, aŋ ta leŋ dɩ ɛɛ hʋ ma aa sɩ basɩ wɩya a laa ma tɩɩ kɩ dɔŋ ma. ");
INSERT INTO sig_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Beewɩya ŋ sɩ kpa wɩgyʋŋ tɩya ma, dɩ ma wuwo basɩ wɩya ma dɔmɔ sɩya tɩyaŋ, dɩ ba bɩ sɩ wuwo kaŋ wɩɩ buloŋ tarɩ anɩɩ wɩtɩɩ daa. ");
INSERT INTO sig_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma kuwoma abee ma nɩmmabalɩya abee ma lʋlla tɩɩ abee ma kyaŋsɩ sɩ kpa ma yallɩ tɩya ma dɔmɔ, dɩ ba kpʋ ma badɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nal nal buloŋ sɩ haasɩ ma ŋ wɩya. ");
INSERT INTO sig_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amɛ ma kɩdɩgɩ buloŋ nyupʋŋ mɛ bɩ sɩ nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dɩ mamaa rɛ sɩŋ ma wɩtɩɩ tɩyaŋ, a kaŋ kenyiri abee mala, ma sɩ laa ma tɩɩ ta.” ");
INSERT INTO sig_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ɛɛ rɛ Yesu bɩl baa, “Dɩ mamaa rɛ ko na dɩ laal tɔɔ Gyerusalɛm, ma gyɩma anɩɩ bee hʋ kyeŋŋii pele rɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ɛɛ tɩyaŋ, ma leŋ dɩ nala hʋ aa we Gyudɩya paalʋʋ tɩyaŋ fá mʋ gyɩŋ dogiŋsi nyuni. Nala hʋ mɛ aa we bee hʋ tɩyaŋ, ʋ maga dɩ ba lɩɩ bee hʋ tɩyaŋ nɛ. Nala hʋ mɛ aa we ba bagɩsɩ tɩyaŋ, ba mɛ ta mɩɩgɩ gyʋʋ bee hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Haŋ saŋa hʋ rɛ Wɩɩsɩ sɩ dɔgɩsɩ Iziral tɩmma, a leŋ dɩ wɩya hʋ buloŋ ba aa saba biŋ Wɩɩsɩ teŋ tɩyaŋ kɔnɩ yaa wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Saŋa no tɩyaŋ, haluwokanna abee biifɩllɩ nɩmma sɩ na tʋwara rɛ weliŋ. Wɩɩsɩ sɩ na baaŋ paalʋʋ no nala nyuu tɩyaŋ, a dɔgɩsɩ ba kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba sɩ kpʋ ba badɔmɔŋ abee takoobiye, aŋ kasɩ ba badɔmɔŋ mɛ mʋ yaa yosi paalʋʋ dʋŋsɩ tɩyaŋ, aŋka dɩ nala hʋ aa bɩ yaa Gyuuma laa Gyerusalɛm tɩŋa, a mʋ pele saŋa hʋ Wɩɩsɩ aa tɩya ba ŋmanɩɩ dɩ ba we doŋ.” ");
INSERT INTO sig_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ɛɛ rɛ Yesu bɩl baa, “Wɩmagɩla sɩ yaa wɩɩpɔsɩɩ abee pene abee kyɩŋwʋlɩya tɩyaŋ. Dʋnɩya buloŋ tɩyaŋ, nala tɩsɩ sɩ kyogi dɩ ba bɩ gyɩŋ wɩɩ hʋ buloŋ tɩyaŋ ba aa wee. Beewɩya mpʋwɔnʋʋ sɩ dɔŋ, dɩ kambɩŋ gyʋʋ nala. ");
INSERT INTO sig_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kambɩŋ sɩ gyʋʋ nala dɩ ba yiyegi, akuu ba aa lurimi na wɩɩ hʋ aa sɩ yaa dʋnɩya buloŋ tɩyaŋ wɩya. Beewɩya ba sɩ kile wɩɩsɩnyuu kɩna buloŋ aa kaŋ dee dɩ ba lɩɩ ba liweeliye tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ɛɛ tɩyaŋ nɛ ma sɩ na mɩyaŋ Nihuwobiŋ Biye dɩ ŋ we taala tɩyaŋ ko kɩ tuu, a kaŋ dee abee gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dɩ wɩya no rɛ ko piili kɩ yaa, ma sii sɩŋ a kaŋ ma nyuni kpa, beewɩya saŋa hʋ Wɩɩsɩ aa sɩ laa ma ta pele rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɛɛ rɛ Yesu maga namaga no tɩya ba a baa, “Ma deŋ na tutogo abee tɩɩsɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Dɩ mamaa rɛ ko na tɩɩsɩ piile kɩ tɔsɔ, ma aa gyɩma anɩɩ yʋʋ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɛɛ tɩɩ rɛ, dɩ mamaa rɛ ko na wɩya no buloŋ ŋ aa daga ma piile kɩ yaa, ma gyɩma anɩɩ Wɩɩsɩ koro hʋ kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma nala no aa we ma mɩɩbol tɩyaŋ gyɩnaŋ, ma buloŋ bɩ sɩ sʋba, aŋka dɩ wɩya no yaa. ");
INSERT INTO sig_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wɩɩsɩnyuu abee taŋha buloŋ sɩ teŋ, amɛ wɩya hʋ ŋ aa basa kɛ bɩ sɩ maakyiye nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ma gyɩŋ tɩya ma tɩɩ ma weliŋ, a ta kpaa ma hakɩllɩ bee ma nyuni buloŋ we kɩdiiliye abee sɩnyʋwabal dʋŋ tɩyaŋ, a ta leŋ dɩ dʋnɩya kɩna wɩya dʋŋ kyɩl ma. Dɩ ma ko leŋ dɩ wɩya no dʋŋ wɩya kyɩl ma, kyɛɛ hʋ Mɩyaŋ Nihuwobiŋ Biye aa sɩ mɩɩgɩ ko, ʋ sɩ pirigi ma tɩyaŋ gɛɛ anɩɩ barɩgɩ aa pirigi kaŋ bagɩl gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Beewɩya kyɛɛ hʋ aa puu nal buloŋ aa we dʋnɩya logiŋ buloŋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ma gyɩŋ tɩya ma tɩɩ, a kɩ kyʋwalɩ Wɩɩsɩ saŋa buloŋ dɩ ma wuwo gyʋʋ wɩya no buloŋ tɩyaŋ a lɩɩ bee laaŋfɩya, aŋ wuwo maakyiye sɩŋ Mɩyaŋ Nihuwobiŋ Biye sɩya tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu fa aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ nɛ kyɩkyʋwala abee wɩhaa buloŋ a kɩ daga nala. Dɩ dɩdaana rɛ ko pele buloŋ, ʋ aa mʋ Olivi dogimo hʋ nyuu rɛ a kyʋwa doŋ. ");
INSERT INTO sig_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sɩgballɩya buloŋ, nala aa mʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ dɩ ba gyegile nɩɩ wɩya hʋ ʋ aa basɩ. ");
INSERT INTO sig_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ tɩyaŋ ba aa kyaŋ paanʋʋ hʋ ba aa bɩ wee sɩbʋl gyɩ ko kpaga rɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ kɩ lʋga dɩ ba na ŋmanɩɩ hʋ ba aa sɩ tɩŋa a lʋwɔlɩ kpʋ Yesu, beewɩya ba gyɩ aa fá nala hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɛɛ rɛ Sɩtaanɩ ko gyʋʋ Yesu hatɩnna fi abee balɩya hʋ kɩdɩgɩ, ba kɩ yɩrɩ Gyudasɩ Isɩkarɔtɩ. ");
INSERT INTO sig_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nyɛ rɛ ʋ sii mʋ, ʋ bee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee nala hʋ aa pɔ Wɩɩkyʋwaldɩɩbal hʋ nɩhɩyasɩ vʋʋlɩ gɛɛ ʋ aa sɩ yaa a kpa Yesu yallɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba tenni gyɩ fɩyɛlɩ weliŋ, ba laa nyʋwa anɩɩ ba sɩ tɩya ʋ molbiye. ");
INSERT INTO sig_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ɛɛ rɛ Gyudasɩ mɛ laa nyʋwa, aŋ piili kɩ kyɛ ŋmanɩɩ hʋ ʋ aa sɩ tɩŋa a kpa Yesu yallɩ tɩya ba dɩ nala bɩ gyɩma. ");
INSERT INTO sig_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ tɩyaŋ, kyɛɛ kɩdɩgɩ rɛ we doŋ ba aa kyaŋ paanʋʋ ba aa bɩ wee sɩbʋl. Kyɛɛ no tɩɩ mɛ rɛ ba aa kpʋ pepɔrɔ hʋ ba aa sɩ kpa marɩ Kyɛbal hʋ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ɛɛ rɛ Yesu tɩŋ Piita abee Gyɔɔŋ, a baa dɩ ba mʋ marɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ kɩdiiliye dɩ ba di. ");
INSERT INTO sig_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nyɛ rɛ ba pɩyɛsɩ ʋ a baa, “Lee tɩyaŋ nɛ ɩ kɩ kyɛ dɩ á mʋ marɩ kɩdiiliye hʋ?” ");
INSERT INTO sig_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ʋ basɩ tɩya ba a baa, “Dɩ mamaa rɛ ko mʋ kɩ gyʋʋ bee hʋ, ma sɩ na baal kɩdɩgɩ dɩ ʋ baasɩ vii abee nɩɩ. Ma tɩŋa ʋ hal mʋ gyʋʋ dɩya hʋ ʋ aa sɩ gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dɩ mamaa rɛ ko gyʋʋ, ma basɩ tɩya dɩya hʋ tɩɩna dɩ ma nɩhɩyawʋ baa dɩ ma pɩyɛsɩ ʋ dɩ lee rɛ ʋ nɩhʋwala dɩya we, dɩ ʋ bee ʋ hatɩnna ko gyʋʋ hɔŋ di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ kɩdiiliye?” ");
INSERT INTO sig_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“Ʋ sɩ daga ma dɩɩbal kɩdɩgɩ. Ʋ yaa sal nyuu dɩya rɛ, ba marɩ ʋ buloŋ weliŋ. Doŋ nɛ ma sɩ marɩ kɩdiiliye hʋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nyɛ rɛ ba kpa mʋ a na wɩya hʋ buloŋ ʋ aa basɩ tɩya ba anɩɩ ba sɩ na. Ɛɛ rɛ ba marɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal kɩdiiliye hʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kɩdiiliye hʋ dii saŋa aa ko pele, Yesu abee ʋ hatɩnna hʋ buloŋ hɔŋ dɩ ba di kɩna hʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ fa paalɩ kyo dɩ ŋ beel-ma di kɩna no rɛ, aŋka dɩ ŋ na na tʋwara. ");
INSERT INTO sig_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Beewɩya, ŋ bɩl bɩ sɩ maakyiye di kɩdiiliye no iriŋ, see saŋa hʋ Wɩɩsɩ koro hʋ aa sɩ ko. Ɛɛ tɩyaŋ nɛ ma sɩ gyɩŋ kɩdiiliye no dii memii.” ");
INSERT INTO sig_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɛɛ rɛ Yesu kpa gbaŋbiye bee sɩŋ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ kpa tɩya ʋ hatɩnna hʋ aŋ baa, “Ma laa gbaŋbiye bee sɩŋ no a kaŋ kpaa dɔmɔŋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ŋ basɩ kɩ tɩya ma rɛ, ŋ bɩl bɩ sɩ maakyiye nyʋwa sɩŋ no, see saŋa hʋ Wɩɩsɩ koro hʋ aa sɩ ko.” ");
INSERT INTO sig_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɛɛ rɛ Yesu bɩl kpa paanʋʋ mɛ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kaŋ lɔgɔ lɔgɔ, a kpa tɩya ba aŋ baa, “Ŋ teŋbii rɛ nyɛ, ŋ kpa sʋla Wɩɩsɩ ma wɩya. Ma laa kyaŋ. Ma kɩ yaa nyɛ a kɩ liisi ŋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba aa dii kɩna hʋ teŋ, ʋ bɩl kpa gbaŋbiye hʋ abee sɩŋ a tɩya ba aŋ baa, “Gbaŋbiye no sɩŋ nɛ yaa nyʋʋfalɩɩ hʋ Wɩɩsɩ aa wee tɩya ma. Ŋ kyal hʋ aa gyaasa ma wɩya rɛ Wɩɩsɩ kpa we nyʋwa no. ");
INSERT INTO sig_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amɛ ma naa rɛ? Nal hʋ aa sɩ kpa ŋ yallɩ, ʋ we á tɩyaŋ daha. Ŋ beel-ʋ rɛ laŋŋa kɩ di kɩna hʋ nyɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɩyaŋ Nihuwobiŋ Biye, ŋ sɩ sʋba anɩɩ Wɩɩsɩ aa daga gɛɛ, amɛ nal hʋ aa sɩ kpa ŋ yallɩ, ʋ sɩ na tʋwara yʋga.” ");
INSERT INTO sig_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ɛɛ rɛ Yesu kpambɩsɩ hʋ piili kɩ pɩyɛsɩ dɔmɔŋ anɩɩ ba tɩyaŋ kɩbee rɛ sɩ yaa wɩɩ no? ");
INSERT INTO sig_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu hatɩnna hʋ gyɩ kaŋ ba tɩyaŋ nɩbal wɩya kɩ kpa dɔmɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dʋnɩya no kuworo aa hɔŋ ba nala nyuu tɩyaŋ nɛ, a kaŋ ba kɩ fɩla, ka kuworo hʋ badɔmɔŋ mɛ aa kɩ kyɛ dɩ nala hʋ kaŋ ba kɩ yɩrɩ bɔnyɛ tɩmma. ");
INSERT INTO sig_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amɛ ʋ bɩ maga dɩ ma kɛ kɩ yaa gɛɛ. Ʋ maga dɩ ma tɩyaŋ nɩbal lɛ bɩrɩmɩ biibiye, dɩ ma sɩlaala mɛ tʋma kɩ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nal aa hɔnɔ aŋka nal kɩdɩgɩ yaa kɩdiiliye kɩ tɩya ʋ, ʋ bee nal hʋ aa yaa kɩdiiliye hʋ kɩ tɩya ʋ hʋ, ba kɩbee rɛ yaa nɩbal? Nal hʋ aa hɔnɔ, aŋka ba yaa kɩdiiliye kɩ tɩya ʋ, ʋ rɛ yaa nɩbal. Amɛ ŋ kɛ we ma lee rɛ, a tʋma kɩ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ŋ tʋwara nayɩ tɩyaŋ, mamaa rɛ yaa nala hʋ aa sɩna ŋ hal, a bɩ vɩya ŋ ta. ");
INSERT INTO sig_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ŋ Kuwo tɩya ŋ ŋmanɩɩ rɛ dɩ ŋ yaa kuworibal. Ɛɛ tɩɩ rɛ ŋ mɛ sɩ tɩya ma ŋmanɩɩ dɩ ma yaa kuworibala. ");
INSERT INTO sig_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dɩ ŋ beel-ma buloŋ maakyiye wuwo di kɩdiiliye ŋ koro hʋ tɩyaŋ. Ma sɩ hɔŋ kuworikpasɩnɩ nyuni a kɩ deŋ Iziral tɩmma bekyige fi abee balɩya hʋ nyuu.” ");
INSERT INTO sig_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ɛɛ rɛ Yesu basɩ tɩya Siimɔŋ Piita a baa, “Siimɔŋ, gyegili nɩɩ daha! Sɩtaanɩ ko sʋla ŋmanɩɩ rɛ dɩ ʋ magɩsɩ ma, a tʋwasɩ ma niweliye a lɩɩ ma nɩbɔmɔ tɩyaŋ, anɩɩ ba aa kyaarɩ mɩya, a lɩɩ miŋbii aŋ ka mɩŋgyɔrʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amɛ ŋ kyʋwalɩ Wɩɩsɩ tɩya ɩ Siimɔŋ nɛ, dɩ ɩ Wɩɩsɩ laadii ta ko nyʋgɩsɩ. Dɩ ɩ rɛ ko mɩɩgɩ ko ŋ lee, pɛ ɩ dɔŋtɩŋsɩ hʋ mɛ tɩyaŋ dɩ ba sɩŋ ba Wɩɩsɩ laadii tɩyaŋ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ɛɛ rɛ Piita basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, dɩ ba aa rɛ sɩ kana ɩ tɔ dɩyaŋ, ŋ yaa siri rɛ dɩ ba kana ŋ mɛ tɔ. Dɩ ba sɩ kpʋ ɩ mɛ, ŋ yaa siri rɛ dɩ ŋ beel-ɩ buloŋ sʋba.” ");
INSERT INTO sig_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ɛɛ rɛ Yesu baa, “Piita, ŋ basɩ kɩ tɩya ɩ rɛ, gyibala ha bɩ sɩ wɩɩ gyɩnaŋ tebine no, aŋka dɩ ɩ tʋwa naaŋsɩɩnyʋwa bʋto anɩɩ ɩ bɩ gyɩma ŋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ hatɩnna hʋ a baa, “Saŋa hʋ ŋ gyɩ aa tɩŋ ma, ma gyɩ bɩ kolo molbiye, a bɩ paa diikusi, a bɩ paa naatɔbɔ tʋŋnyʋwa bʋlɩya bʋlɩya mɛ, aŋ mʋ. Ma gyɩ yaŋ aa mʋwa, bekiŋ nɛ ma gyɩ kyɛ lɔlɔ?” Ba baa dɩ ba gyɩ bɩ kyɛɛ kɩŋ buloŋ lɔlɔ. ");
INSERT INTO sig_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Doŋ nɛ Yesu basɩ tɩya ba a baa, “Amɛ nyɛ kɛ, ma nal hʋ buloŋ aa kaŋ molbiye koo diiku, ʋ maga dɩ ʋ kpa kolo rɛ. Ma nal hʋ mɛ buloŋ aa bɩ kaŋ takoobii, ʋ maga dɩ ʋ kpa ʋ gabal yallɩ rɛ a yɔbɔ kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ba saba Wɩɩsɩ teŋ tɩyaŋ nɛ a baa, ‘Ba kana ʋ pɛ wɩbɔŋyaala tɩyaŋ nɛ’. Wɩya no buloŋ, ŋ wɩya rɛ ba sabɩ gɛɛ. Ba buloŋ sɩ yaa ŋ tɩyaŋ nɛ, dɩ wɩya hʋ buloŋ ba aa saba ŋ wɩya kɔnɩ su ba bʋʋsɩ.” ");
INSERT INTO sig_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɛɛ rɛ ʋ hatɩnna hʋ basɩ tɩya ʋ a baa, “Á Tɩɩna, deŋ na, takoobiye balɩya rɛ nyɛ.” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Tɔɔ, ba maga rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ɛɛ rɛ Yesu sii lɩɩ Gyerusalɛm tɩyaŋ, a mʋ gyɩŋ Olivi dogimo hʋ nyuu, anɩɩ ʋ aa kɩ yaa gɛɛ saŋa buloŋ. Ɛɛ rɛ ʋ hatɩnna hʋ mɛ sii tɩŋa ʋ hal mʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba aa mʋʋ pele doŋ, ʋ basɩ tɩya ba a baa, “Ma kɩ sʋla Wɩɩsɩ, dɩ Sɩtaanɩ ta wuwo mʋrɩ ma.” ");
INSERT INTO sig_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ʋ aa basɩ gɛɛ teŋ, ʋ parɩ ʋ hatɩnna hʋ mʋ sɩya mʋhʋ, a tuu gbinni a kyʋwalɩ Wɩɩsɩ, a baa, ");
INSERT INTO sig_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ŋ Kuwo, dɩ ʋ ko yaa ɩ kyɛrɩ, lɩɩ ŋ tʋwara no aa ko tɩyaŋ. Amɛ mɩyaŋ kɛ kyɛrɩ daa, leŋ dɩ ɩ kyɛrɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Doŋ nɛ malɩka lɩɩ wɩɩsɩbee a ko tuu fɩyɛlɩ ʋ bembii. ");
INSERT INTO sig_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ʋ tɩya gyɩ kyogo rɛ kɩŋkaŋ buloŋ. Ɛɛ rɛ ʋ faasɩ kyʋwalɩ Wɩɩsɩ abee sɩfɩyasɩ. Ʋ suwolii paalɩ kɩ tuu taŋha gɛɛ anɩɩ kyal. ");
INSERT INTO sig_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ʋ aa kyʋwalɩ Wɩɩsɩ hʋ teŋ, ʋ sii a mɩɩgɩ mʋ ʋ hatɩnna hʋ lee, dɩ ba pɩŋ doo, beewɩya tɩkyogi hʋ gyɩ leŋ lɔl gyʋʋ ba rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ɛɛ rɛ Yesu ko pɩyɛsɩ ba a baa, “Ma kɔnɩ pɩŋ kɩ pɩŋ doo rɛ? Ma sii a kɩ sʋla Wɩɩsɩ, dɩ Sɩtaanɩ ta wuwo mʋrɩ ma.” ");
INSERT INTO sig_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ha gyɩ aa basɩ wɩya hʋ tɩyaŋ nɛ, dɩ Yesu hatɩnna fi abee balɩya hʋ kɩdɩgɩ ba aa yɩrɩ Gyudasɩ rɛ gyɩ mʋ laa nɩygamaa sɩya gɛɛ ba kɩ ko ʋ lee. Ba aa ko pele, Gyudasɩ vala a mʋ guwori Yesu. ");
INSERT INTO sig_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɛɛ rɛ Yesu baa, “Gyudasɩ, ɩ kɔnɩ ko guwori ŋ nɛ dɩ ɩ kpa Mɩyaŋ Nihuwobiŋ Biye yallɩ koo?” ");
INSERT INTO sig_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu hatɩnna hʋ fa aa we doŋ a na wɩɩ hʋ aa kyɛ dɩ ʋ yaa, ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, “Á Tɩɩna, á kyuri á takoobiye koo?” ");
INSERT INTO sig_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nyɛ rɛ Yesu hatɩnna hʋ kɩdɩgɩ teŋ kyuri takoobii, a ŋmaŋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ dɩya yoŋ noduu dɩgɩŋ kyɔl. ");
INSERT INTO sig_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ɛɛ rɛ Yesu baa, “Ʋ maga rɛ. Ma leŋ.” Ʋ basɩ gɛɛ rɛ, aŋ dige baal hʋ dɩgɩŋ, ʋ mɩɩgɩ taasɩ. ");
INSERT INTO sig_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ɛɛ rɛ Yesu pɩyɛsɩ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee nala hʋ aa pɔ Wɩɩkyʋwaldɩɩbal hʋ nɩhɩyasɩ abee ba bee nɩhɩyasɩ hʋ aa ko dɩ ba kana ʋ, a baa, “Ŋ yaa biibɔŋ nɛ, ma sii kol takoobiye abee daŋgulo a kɩ ko dɩ ma kana ŋ? ");
INSERT INTO sig_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ŋ beel-ma buloŋ nɛ fa aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ kyɛɛ bee ʋ nyʋwa buloŋ, aŋka ma bɩ lʋga dɩ ma kana ŋ doŋ. Amɛ saŋa no rɛ Wɩɩsɩ tɩya ma ŋmanɩɩ dɩ ma kana ŋ. Saŋa no tɩyaŋ mɛ rɛ wɩbɔmɔ kuwori, Sɩtaanɩ mɛ we ʋ tʋma tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɛɛ rɛ ba kaŋ Yesu, a kana ʋ kɩ mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ dɩya, ka Piita mɛ daasɩ kɩ tɩŋ ba hal. ");
INSERT INTO sig_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba mʋwa dɩ ba tuu diŋ gyaŋwuwo hʋ tɩyaŋ nala kɩ wiyeni. Nyɛ rɛ Piita mʋ pɛ nala hʋ aa wiyeni diŋ hʋ tɩyaŋ a hɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Haŋtolibiye kɩdɩgɩ mɛ gyɩ we ba tɩyaŋ, a yaa dɩya hʋ tʋŋtʋnnɩ. Ʋ aa naa Piita dɩ ʋ hɔŋ kɩ wiyeni diŋ hʋ, ɛɛ rɛ ʋ deŋ ʋ sɩya tɩyaŋ gɛɛ sɩrɩtɩtɩ, aŋ baa, “Baal no mɛ fa aa tɩŋ Yesu hal lɛ.” ");
INSERT INTO sig_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ɛɛ rɛ Piita baa, “Haŋtolibiye, ŋ paalɩ bɩ gyɩma ʋ mɛ gba.” ");
INSERT INTO sig_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mʋhʋ sʋwaa dɩ baal kɩdɩgɩ mɛ na ʋ a baa, “Ɩ mɛ yaa ba kɩdɩgɩ rɛ.” Ɛɛ rɛ Piita bɩl baa, “Ŋ bagyʋwa, ŋ kɛ daa.” ");
INSERT INTO sig_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ʋ bɩl bɩ pɩɩsa, dɩ baal kɩdɩgɩ mɛ rɛ gɛɛ, a hara pɔ anɩɩ Piita yaa Yesu hatɩnna hʋ kɩdɩgɩ rɛ, dɩ beewɩya ʋ yaa Galili tɩɩna rɛ. ");
INSERT INTO sig_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɛɛ rɛ Piita bɩl basɩ tɩya ʋ mɛ a baa, “Ŋ bagyʋwa, ŋ paalɩ bɩ gyɩŋ wɩɩ hʋ ɩ aa basɩ tɩyaŋ.” Piita aa yaŋ basɩ gɛɛ, ʋ nyʋwa ha bɩ tele taŋha, dɩ gyibal wiye. ");
INSERT INTO sig_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ɛɛ rɛ á Tɩɩna Yesu galdaasɩ, a deŋ Piita sɩya tɩyaŋ. Doŋ nɛ ʋ liisi wɩɩ hʋ Yesu fa aa basɩ tɩya ʋ anɩɩ ʋ sɩ tʋwa naaŋsɩɩnyʋwa bʋto a baa dɩ ʋ bɩ gyɩma ʋ, ka dɩ gyibal na wii. ");
INSERT INTO sig_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɛɛ rɛ Piita sii lɩɩ bee a wɩɩ weliŋ. ");
INSERT INTO sig_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɛɛ rɛ nala hʋ aa pɔ Yesu kɩ huuri ʋ, aŋ kɩ ŋmaa ʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba gyɩ vʋwa ʋ sɩya tɔ rɛ, aŋ aa ŋmaa ʋ, aŋ pɩyɛsɩ ʋ dɩ ʋ daga nal hʋ aa ŋmaa ʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba gyɩ basɩ wɩya mɛ rɛ yʋga a tʋʋsɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ʋ sɩgballɩya, Gyuuma bee nɩhɩyasɩ abee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla buloŋ laŋŋɩ, aŋ leŋ ba kaŋ Yesu ko ba sɩya. ");
INSERT INTO sig_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɛɛ rɛ ba pɩyɛsɩ Yesu a baa, “Daga ma, ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya?” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ mɩyaŋ nɛ basɩ tɩya ma mɛ, ma bɩ sɩ laa di. ");
INSERT INTO sig_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dɩ mɩyaŋ nɛ yaŋ bɩl pɩyɛsɩ ma wɩɩ mɛ, ma bɩ sɩ lɩɩ ʋ sɩɩ tɩya ŋ. ");
INSERT INTO sig_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amɛ a lɩɩ nyɛ a kaŋ kɩ mʋ, Mɩyaŋ Nihuwobiŋ Biye sɩ hɔŋ Wɩɩbal hʋ noduu logiŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɛɛ rɛ ba buloŋ pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaŋ yaa Wɩɩsɩ Biye hʋ koo?” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ma basɩ, ma aa baa dɩ mɩyaŋ nɛ yaa Wɩɩsɩ biye hʋ.” ");
INSERT INTO sig_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɛɛ rɛ nala hʋ baa, “Á bɩl bee kyɛ daŋsɩya tɩɩna buloŋ. Á tɩɩ mɛ nɩɩ wɩɩ hʋ ʋ tɩɩ nyʋwa tɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɛɛ rɛ nala no buloŋ sii, a kaŋ Yesu mʋ nal hʋ aa laa Roma paalʋʋ kuworibal hʋ naasɩ sɩŋ Gyudɩya paalʋʋ tɩyaŋ ba kɩ yɩrɩ Pilato sɩya. ");
INSERT INTO sig_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Doŋ nɛ ba piili a kɩ basɩ wɩya hʋ ba aa baa dɩ ʋ yaa kyogi, a baa, “Á kaŋ baal no rɛ dɩ ʋ aa mʋrɩ nala, aŋ baa dɩ ba ta tuŋ lampoo kɩ tɩya Roma paalʋʋ kuworibal hʋ. Aŋ bɩl kɩ daga anɩɩ ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta, aŋ ha bɩl baa dɩ ʋ yaa kuwori mɛ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ɛɛ rɛ Pilato pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa Gyuuma kuwori hʋ koo?” Yesu basɩ tɩya ʋ a baa, “Na ɛɛ rɛ ɩ basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ɛɛ rɛ Pilato basɩ tɩya Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee nɩgyamaa hʋ buloŋ aa laŋŋa doŋ a baa, “Ŋ bɩ naa wɩɩ hʋ baal no aa yaa kyogi, a maga dɩ ba kpʋ ʋ.” ");
INSERT INTO sig_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amɛ nala hʋ ha hara a baa, “Ʋ daga nala Gyudɩya paalʋʋ buloŋ tɩyaŋ nɛ a leŋ ba kɩ laa taawɛɛ. Galili paalʋʋ tɩyaŋ nɛ ʋ piili wɩɩ no, aŋ sii kpa ko daha mɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato aa nɩɩ wɩɩ no, ʋ pɩyɛsɩ nala hʋ a baa, “Baal no yaa Galili tɩɩna rɛ?” ");
INSERT INTO sig_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato aa ko gyɩma anɩɩ Galili paalʋʋ rɛ Yesu lɩɩ, ʋ leŋ ba kana ʋ mʋ Hɛrɔtɩ lee, beewɩya Hɛrɔtɩ rɛ gyɩ aa deŋ doŋ paalʋʋ. Saŋa no tɩyaŋ dɩ Hɛrɔtɩ gyɩ we Gyerusalɛm tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɛrɔtɩ teŋ buloŋ gyɩ fɩyɛla rɛ weliŋ ʋ aa naa Yesu, beewɩya ʋ gyɩ nɩɩ ʋ wɩya rɛ faafaa buloŋ, a kɩ kyɛ dɩ ʋ na ʋ. Ʋ fa aa kyɛ dɩ Yesu yaa wɩmagɩl lɛ dɩ ʋ na. ");
INSERT INTO sig_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɛɛ rɛ Hɛrɔtɩ pɩyɛsɩ Yesu wɩya yʋga, amɛ ʋ gyɩ bɩ laa wɩɩ buloŋ basɩ. ");
INSERT INTO sig_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ sii tarɩsɩ mʋ Yesu tɩyaŋ, a daga wɩya yʋga ba aa bɩɩna anɩɩ ʋ yaa kyogi. ");
INSERT INTO sig_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛrɔtɩ bee ʋ laalyuwolo mɛ yaa Yesu sɩya weliŋ, aŋ leŋ ba kpa gawil kɩdɩgɩ laalɩ ʋ, aŋ mɩɩgɩ kana ʋ mʋ Pilato lee. ");
INSERT INTO sig_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hɛrɔtɩ bee Pilato fa bee na dɔmɔŋ sɩɩ. Haŋ kyɛɛ hʋ rɛ ba mɩɩgɩ bɩrɩmɩ kyaŋsɩ. ");
INSERT INTO sig_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ɛɛ rɛ Pilato yɩrɩ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma nɩhɩyasɩ abee nala hʋ buloŋ aa laŋŋa doŋ, a basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ma kaŋ baal no ko ŋ lee rɛ, a basɩ tɩya ŋ anɩɩ ʋ aa mʋrɩ nala rɛ. Ŋ pɩyɛsɩ ʋ wɩya rɛ ma buloŋ sɩɩ tɩyaŋ. Wɩya hʋ buloŋ ma aa baa dɩ ʋ yaa kyogi, ŋ kɛ bɩ naa ʋ wɩkyogii ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛrɔtɩ mɛ bɩ naa ʋ wɩkyogii buloŋ, ɛɛ rɛ tɩŋ ʋ leŋ ba bɩl mɩɩgɩ kana ʋ ko daha. Ma na, baal no bɩ yaa wɩɩ buloŋ kyogi a maga dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ɛɛwɩya, ŋ sɩ leŋ dɩ ba vɩɩrɩ ʋ, aŋka dɩ ŋ kpa ʋ ta.” ");
INSERT INTO sig_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Amɛ dɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ rɛ ko pele buloŋ, ba aa leŋ Pilato lɩɩ nala hʋ ba aa kaŋ tɔ dɩya tɩyaŋ kɩdɩgɩ rɛ a ta, nal hʋ Gyuuma hʋ aa kyo dɩ ba lɩya. ");
INSERT INTO sig_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɛɛ rɛ nala hʋ buloŋ kyɩɩrɩ a baa, “Kpʋ Yesu aŋ lɩɩ Barabaasɩ tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Saŋa kɩdɩgɩ, nala gyɩ sii laa taawɛɛ rɛ Gyerusalɛm tɩyaŋ, a gyɩ kpʋ nala. Ɛɛ wɩya rɛ tɩŋ ba gyɩ kaŋ Barabaasɩ tɔ dɩyaŋ.) ");
INSERT INTO sig_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato fa aa kyɛ dɩ ʋ kpa Yesu ta rɛ, ɛɛ rɛ ʋ bɩl marɩ basɩ wɩya tɩya nɩgyamaa hʋ. ");
INSERT INTO sig_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amɛ ba marɩ kyɩɩrɩ yʋga a baa, “Kpaasɩ ʋ mal daagarɩɩ tɩyaŋ, kpaasɩ ʋ daagarɩɩ tɩyaŋ!” ");
INSERT INTO sig_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ɛɛ rɛ Pilato bɩl basɩ tɩya ba a baa, “Bekiŋ wɩɩ rɛ baal no yaa kyogi? Ŋ kɛ bɩ naa wɩɩ hʋ ʋ aa yaa kyogi a maga dɩ ba kpʋ ʋ. Ɛɛwɩya, ŋ sɩ leŋ dɩ ba vɩɩrɩ ʋ, aŋka dɩ ŋ kpa ʋ ta.” ");
INSERT INTO sig_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka nala hʋ ha vɩya aŋ hara, a marɩ kyɩɩrɩ yʋga a baa, “Ʋ maga dɩ ba kaŋ Yesu kpaasɩ daagarɩɩ tɩyaŋ nɛ.” Ba aa yaa kyagɩŋsɩ hʋ gɛɛ rɛ Pilato kyɛ wɩɩ lɔlɔ, aŋ laa ba nyʋwa hʋ, ");
INSERT INTO sig_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","a baa dɩ ba kaŋ Yesu mʋ kpaasɩ mal daagarɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɛɛ rɛ Pilato leŋ ba lɩɩ Barabaasɩ ta. Baal hʋ ba gyɩ aa kaŋ tɔ dɩya tɩyaŋ akuu taawɛɛ aa siye bee hʋ tɩyaŋ ba kpʋ nala wɩya. Aŋ kpa Yesu mɛ tɩya ba dɩ ba kaŋ mʋ yaa gɛɛ hʋ buloŋ ba aa sɩ yaa. ");
INSERT INTO sig_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ɛɛ rɛ laalyuwolo hʋ kaŋ Yesu lɩɩ dɩ ba kana ʋ mʋ kpaasɩ mal daagarɩɩ hʋ tɩyaŋ. Ba aa mʋʋ hʋ tɩyaŋ nɛ, ba kyeŋ baal kɩdɩgɩ aa lɩɩ Sariini ba kɩ yɩrɩ Siimɔŋ, dɩ ʋ lɩɩ baga a ko kɩ gyʋʋ Gyerusalɛm. Ɛɛ rɛ ba kana ʋ, a kpa daagarɩɩ hʋ tɩya ʋ ʋ baasɩ, a kɩ tɩŋ Yesu hal. ");
INSERT INTO sig_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ka gyamaa hʋ buloŋ mɛ gyɩ lɩɩ tɩŋa ʋ hal. Haana badɔmɔŋ nɛ gyɩ we ba tɩyaŋ, a kɩ wii Yesu wɩya kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ɛɛ rɛ Yesu mɩɩgɩ deŋ ba, aŋ basɩ tɩya ba a baa, “Gyerusalɛm haana, ma ta kɩ wii ŋ wɩya. Ma kɩ wii ma tɩɩ ma abee ma biisi wɩya. ");
INSERT INTO sig_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Saŋa kɩdɩgɩ sɩ pele dɩ nala baa, ‘Haana hʋ aa yaa hapɩra, haana hʋ aa bɩ lʋl biisi na, abee haana hʋ aa bɩ dɩyɛsɩ biisi na, ma yaa nyusʋŋtɩmma rɛ.’ ");
INSERT INTO sig_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saŋa no tɩɩ tɩyaŋ, nala sɩ kɩ kyɛ dɩ ba faŋa dogiŋsi hala, koo dɩ dogiŋsi tele tɔ ba. ");
INSERT INTO sig_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Dɩ daasɔnɔ rɛ ko kɩ di diŋ, aŋnɛ rɛ bɩl sɩ kɩ basɩ daahɩlɩya mɛ wɩya?” ");
INSERT INTO sig_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ba gyɩ aa kaŋ Yesu kɩ mʋ dɩ ba kpʋ gɛɛ, wɩbɔŋyaala balɩya mɛ rɛ ba gyɩ kaŋ pɛ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɛɛ rɛ ba mʋ pele lee hʋ ba aa yɩrɩ “Nyukuŋkogilo.” Doŋ tɩyaŋ nɛ ba kpaasɩ Yesu abee wɩbɔŋyaala hʋ balɩya daagarɩya nyuni tɩyaŋ. Kɩdɩgɩ we Yesu noduu dɩɩlaŋ, kɩdɩgɩ mɛ we ʋ nogɔbɔ dɩɩlaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ɛɛ rɛ Yesu kyʋwalɩ Wɩɩsɩ a baa, “Ŋ Kuwo, kpa wɩɩ no ba aa yaa kyɛ ba, beewɩya ba bɩ gyɩŋ wɩɩ hʋ buloŋ ba aa yaa.” Ɛɛ rɛ ka ba yuwo gbaŋŋa, a kaŋ Yesu gannɩ kpaa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nala badɔmɔŋ mɛ gyɩ sɩŋ doŋ a kɩ deŋ, aŋka Gyuuma nɩhɩyasɩ kɩ yaa ʋ sɩya, a baa, “Na ʋ baa ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, a laa nala kɩ ta, ma leŋ dɩ ʋ laa ʋ tɩɩ ta dɩ á na.” ");
INSERT INTO sig_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Laalyuwolo hʋ mɛ kɩ yaa ʋ sɩya, a yaa sɩkyaakyaa mʋ we ʋ nyʋwa tɩyaŋ dɩ ʋ nyʋwa, ");
INSERT INTO sig_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aŋ basɩ tɩya ʋ a baa, “Dɩ ɩ rɛ kɔnɩ yaa Gyuuma kuwori kɛ, laa ɩ tɩɩ ta dɩ á na.” ");
INSERT INTO sig_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba gyɩ saba mal ʋ daagarɩɩ hʋ tɩyaŋ nɛ a baa, “Gyuuma kuwori hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɛɛ rɛ wɩbɔŋyaala hʋ kɩdɩgɩ mɛ aa saga ʋ daagarɩɩ tɩyaŋ tʋʋsɩ Yesu a baa, “Na ɩ baa ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, koo ŋ nyɩya rɛ? Ɛɛ kɛ laa ɩ tɩɩ ta, aŋ laa ma mɛ ta dɩ á na.” ");
INSERT INTO sig_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɛɛ rɛ ʋ dɔŋtɩɩna wɩbɔŋyaal hʋ nɔsɩ ʋ a baa, “Ɩ bee fá Wɩɩsɩ koo? Á beel-ʋ buloŋ we tʋwarɩdɩgɩ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Á kɛ maga dɩ ba yaa ma nyɛ rɛ, beewɩya á yaa wɩbɔŋ nɛ. Amɛ baal no kɛ bɩ yaa wɩɩ buloŋ kyogi.” ");
INSERT INTO sig_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɛɛ rɛ ka ʋ basɩ tɩya Yesu a baa, “Yesu, dɩ ɩ rɛ ko di ɩ koro hʋ, ta ko yeŋŋi ŋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Doŋ nɛ Yesu basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, ŋ beel-ɩ sɩ we wɩɩsɩbee tɩyaŋ gyɩnaŋ.” ");
INSERT INTO sig_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wɩɩsɩ aa ko maga nyutʋtʋʋ saŋa gɛɛ, wɩɩsɩ pirigi nyʋgɩsɩ, ka lee buloŋ bɩl gɛɛ timm, a mʋ pele dɩdaana kerifi boto, ka lee bɩl na kyaanɩ. ");
INSERT INTO sig_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Patɩɩsa hʋ fa aa bori Wɩɩkyʋwaldɩɩbal hʋ kɩyɛsɩ balɩya. ");
INSERT INTO sig_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɛɛ rɛ ka Yesu kyiyesi yʋga a baa, “Ŋ Kuwo, ŋ kpaa ŋ tɩɩ a we ɩ nosi tɩyaŋ nɛ.” Nyɛ rɛ ʋ basɩ, aŋ wiyesi ʋ wiyesi-kateŋse aŋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Laalyuwolo nɩhɩyawʋ hʋ fa aa sɩŋ doŋ aa naa wɩɩ hʋ aa yaa, ʋ dannɩ Wɩɩsɩ a baa, “Wɩtɩɩ, baal no kɔnɩ fa yaa tɩpʋlʋŋ tɩɩna rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nala hʋ buloŋ fa aa laŋŋa doŋ aa naa wɩɩ hʋ aa yaa, ba mɩɩgɩ mʋ dɩɩsɩ abee tɩkyogi. ");
INSERT INTO sig_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nala hʋ buloŋ fa aa gyɩŋ Yesu abee haana hʋ buloŋ fa aa tɩŋ ʋ hal a lɩɩ Galili ko, ba sɩŋ libolii rɛ aŋ kɩ deŋ wɩya hʋ buloŋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Gyuuma baal kɩdɩgɩ rɛ gyɩ we doŋ ba kɩ yɩrɩ Gyosɛfʋ, a lɩɩ Arimatiya aa we Gyudɩya paalʋʋ tɩyaŋ. Ʋ fa yaa nɩtɩɩ rɛ weliŋ, ka nala fa kɩ tɩya ʋ gyɩrɩma weliŋ. Ʋ fa aa gyegili Wɩɩsɩ koro hʋ koyi rɛ, a fa yaa nala hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya kɩdɩgɩ. Amɛ saŋa hʋ ba fa aa vʋʋlɩ Yesu kpʋyɩ wɩya, ʋ kɛ fa bɩ sɩŋ ba kɩŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɛɛ rɛ ʋ sii mʋ Pilato lee, a sʋla ʋ dɩ ʋ tɩya ʋ ŋmanɩɩ dɩ ʋ kpa Yesu mʋ hogo. Pilato tɩya ʋ ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nyɛ rɛ ʋ mʋ lallɩ Yesu daagarɩɩ hʋ nyuu tɩyaŋ, a we ʋ liŋe, aŋ kpa ʋ mʋ hogo bʋbʋwa kɩdɩgɩ ba aa lurigo tɩyaŋ. Ba ha gyɩ bɩ maakyiye hogo nal buloŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wɩɩ no gyɩ yaa Alagyima kyɛɛ rɛ, dɩ ba gyɩ yaŋ kɩ yaa siri dɩ ba piili Kyɛwiyesii hʋ kyɛɛ wɩkanɩya. ");
INSERT INTO sig_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Haana hʋ gyɩ aa tɩŋ Yesu hal a lɩɩ Galili paalʋʋ ko sii tɩŋ Gyosɛfʋ hal a mʋ dɩ ba na ɛɛ ba aa hogo Yesu bʋbʋwa hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɛɛ rɛ ba mɩɩgɩ mʋ dɩya haŋ dɩdaana hʋ, a marɩ kɩna badɔmɔŋ sʋwala aa sʋma gɛɛ anɩɩ tʋranɩɩ dɩ ba kaŋ mʋ tɩsɩ ʋ dɩ ʋ ta pʋw. Amɛ haŋ dɩdaana hʋ tɩɩ mɛ rɛ ba Kyɛwiyesii hʋ kyɛɛ wɩkanɩya aa piili. Ɛɛ rɛ tɩŋ ba gyɩ bɩl bɩ wuwo mɩɩgɩ mʋ bɩl hʋ lee. Nyɛ rɛ ba wiyesi haŋ kyɛɛ hʋ anɩɩ Wɩɩsɩ mɩrɩsɩ hʋ aa daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Alahadi kyɛɛ sɩgballɩnyʋwa, haana hʋ sii, a kaŋ kɩna hʋ ba aa mara ba sʋwala sʋma gɛɛ anɩɩ tʋranɩɩ hʋ, a kaŋ mʋ bil hʋ lee. ");
INSERT INTO sig_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba mʋwa dɩ bʋyɩ hʋ ba fa aa kpaa tɔ bʋbʋwa hʋ nyʋwa suro. ");
INSERT INTO sig_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɛɛ rɛ ba mʋ gyʋʋ bʋbʋwa hʋ, amɛ ba bɩ naa á Tɩɩna Yesu teŋbii. ");
INSERT INTO sig_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ɛɛ rɛ ba sɩŋ doŋ, a bɩ gyɩŋ wɩɩ hʋ buloŋ ba aa sɩ yaa. Ba yaa dɩ ba deŋ, dɩ baala balɩya rɛ pirigi ko sɩŋ ba logiŋ gɛɛ, ka ba gannɩ buloŋ kɩ tʋla gɛɛ nyʋlɩɩnyʋlɩɩ. ");
INSERT INTO sig_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nyɛ rɛ kambɩŋ kaŋ haana hʋ, ba kaŋ ba nyuni gʋra gʋra. Ɛɛ rɛ baala hʋ pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma deŋ kɩ kyɛ nal hʋ aa weye nɩsʋʋnɩ tɩyaŋ? ");
INSERT INTO sig_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ʋ tuwo daha. Ʋ siye rɛ. Ma liisi wɩɩ hʋ ʋ gyɩ aa basɩ tɩya ma, saŋa hʋ tɩyaŋ ʋ gyɩ aa we Galili tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ʋ gyɩ basɩ tɩya ma rɛ anɩɩ ba sɩ kpa ʋ Nihuwobiŋ Biye we wɩbɔŋyaala nosi tɩyaŋ dɩ ba kpaasɩ ʋ mal daagarɩɩ tɩyaŋ, dɩ ʋ sʋba, dɩ amɛ dɩ ʋ sɩ sii sʋʋ tɩyaŋ ʋ kyɛtoo kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Doŋ nɛ haana hʋ liisi wɩɩ hʋ ʋ gyɩ aa basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɛɛ rɛ ba lɩɩ bʋbʋwa hʋ tɩyaŋ, a mʋ basɩ wɩya hʋ buloŋ aa yaa a tɩya Yesu kpambɩsɩ fi abee kɩdɩgɩ hʋ, abee nɩkaalɩya hʋ buloŋ fa aa tɩŋ ʋ hal. ");
INSERT INTO sig_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haana hʋ gyɩ aa mʋʋ bil hʋ lee rɛ nyɛ: Mɛɛrɩ Magidalina, Gyuwana abee Gyemsi nɩɩna Mɛɛrɩ. Ba bee ba hadɔŋtɩŋsɩ hʋ gyɩ aa mʋʋ na wɩya hʋ rɛ gyɩ ko basɩ wɩya no tɩya Yesu kpambɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amɛ Yesu kpambɩsɩ hʋ fa bɩɩna anɩɩ wɩɩ hʋ haana hʋ aa basa yaa wɩnyɩyɛl lɛ. Ɛɛwɩya, ba gyɩ bɩ laa di. ");
INSERT INTO sig_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amɛ Piita sii a fá mʋ bʋwa hʋ lee, a mʋ tuu lurimi bʋwa hʋ, a na liŋe hʋ ba fa aa kpaa we Yesu dɩ ʋ pɩna, aŋka ʋ bɩ naa kɩŋ buloŋ. Ɛɛ rɛ wɩɩ hʋ kpere ʋ, ʋ mɩɩgɩ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Haŋ kyɛɛ hʋ tɩɩ rɛ Yesu hatɩnna balɩya sii kɩ mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Imayosi. Imayosi bee Gyerusalɛm fa yaa anɩɩ meeldaasɩ bapɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba aa mʋʋ hʋ tɩyaŋ nɛ, ba vala a basɩ wɩya hʋ aa yaa a kɩ tɩya dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba aa basɩ wɩya hʋ a vala kɩ mʋ tɩyaŋ nɛ Yesu tɩɩ ko pɛ ba tɩyaŋ ba buloŋ kɩ vala. ");
INSERT INTO sig_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba gyɩ na ʋ rɛ, amɛ ba gyɩ bɩ wuwo gyɩma anɩɩ ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Bekine wɩya rɛ ma vala kɩ basɩ gɛɛ?” Ɛɛ rɛ ba mɩɩgɩ sɩŋ, ba tɩsɩ buloŋ kyogi. ");
INSERT INTO sig_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nyɛ rɛ ba kɩdɩgɩ tɩɩna ba aa yɩrɩ Kiliyopasi pɩyɛsɩ ʋ a baa, “Ɩ dʋŋ nɛ yaa nɩhʋwal Gyerusalɛm tɩyaŋ a bɩ gyɩŋ wɩɩ hʋ aa yaa doŋ kyɛbʋʋsɩ no koo?” ");
INSERT INTO sig_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Wɩbee rɛ gɛɛ?” Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Ka wɩɩ hʋ ba aa yaa Yesu aa lɩɩ Nazarɛti. Baal no fa yaa Wɩɩsɩ tɩŋdaal lɛ. Ʋ wɩbasɩya abee ʋ wɩyaalɩya buloŋ tɩyaŋ, ʋ fa yaa nal hʋ aa kaŋ dee rɛ Wɩɩsɩ abee nihuwobisi buloŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Á Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Gyuuma nɩhɩyasɩ kpa ʋ we Pilato nosi tɩyaŋ dɩ ʋ kpʋ ʋ. Ɛɛ rɛ Pilato leŋ ba kpaasɩ ʋ mal daagarɩɩ tɩyaŋ, ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amɛ á fa aa yɩyɛlɩ anɩɩ ʋ rɛ yaa nal hʋ aa ko dɩ ʋ laa Iziral tɩmma ta. Ka ba aa kpʋ ʋ, ʋ kyɛyɛ boto rɛ yaa gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wɩya no buloŋ hal tɩyaŋ mɛ, á bee haana hʋ fa aa tɩŋ Yesu hal badɔmɔŋ ko basɩ wɩɩ rɛ tɩya ma, wɩɩ hʋ kperi ma. Ba baa dɩ ba sii mʋ bʋwa hʋ lee rɛ sɩgballɩnyʋwa, aŋ bɩ naa Yesu teŋbii bʋwa hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ba baa dɩ ba naa malɩkasɩ rɛ ba basɩ tɩya ba anɩɩ Yesu weye rɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɛɛ rɛ á badɔmɔŋ mɛ sii mʋ bʋwa hʋ lee a na anɩɩ wɩɩ hʋ haana hʋ aa basa hʋ yaa wɩtɩɩ. Amɛ ba mɛ gyɩ bɩ naa Yesu.” ");
INSERT INTO sig_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma yaa bambugo rɛ kɩŋkaŋ, a bɩ wuwo dɩ ma laa wɩya hʋ Wɩɩsɩ tɩŋdaala aa basa mɛ di. ");
INSERT INTO sig_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma bɩ gyɩma anɩɩ ʋ maga dɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, na tʋwara rɛ aŋ na di ʋ gaŋdaa-feŋ Wɩɩsɩ lee tɩyaŋ koo?” ");
INSERT INTO sig_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɛɛ rɛ Yesu basɩ wɩya hʋ buloŋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ a mʋ kɩ tile ʋ tɩyaŋ, a tɩya ba. Ʋ gyɩ piile tenni hʋ Moosi aa saba tɩyaŋ nɛ a kaŋ mʋ pele tenni hʋ buloŋ Wɩɩsɩ tɩŋdaala mɛ aa saba, a daga wɩya no buloŋ memiye mɛ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba aa ko kpaga Imayosi, Yesu fugo yaa gɛɛ anɩɩ ʋ aa kyɛ dɩ ʋ parɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ɛɛ rɛ ba kana ʋ biŋ, aŋ baa dɩ lee bile rɛ, dɩ ʋ pɩŋ sɩya gballɩ. Ɛɛ rɛ ba beel-ʋ buloŋ kpa gyʋʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ɛɛ tɩyaŋ nɛ ba hɔŋ dɩ ba di kɩna. Nyɛ rɛ Yesu kpa paanʋʋ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ kaŋ lɔgɔ lɔgɔ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ʋ aa yaa gɛɛ tɩyaŋ nɛ, ba sɩya yaŋ polli ba gyɩma anɩɩ Yesu rɛ. Haŋ lagɩlagɩbiye hʋ, ʋ pirigi dɩɩgɩ ba sɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɛɛ rɛ ba basɩ tɩya dɔmɔŋ a baa, “Saŋa hʋ ʋ fa aa basɩ wɩya kɩ tɩya ma aŋ daga Wɩɩsɩ teŋ wɩya hʋ memiye kɩ tɩya ma ŋmanɩɩ hʋ tɩyaŋ, á tenni fa fɩyɛla rɛ kɩŋkaŋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɛɛ rɛ ba sii lagɩ lagɩ, a mɩɩgɩ mʋ Gyerusalɛm, a na Yesu kpambɩsɩ fi abee kɩdɩgɩ hʋ, abee nɩkaalɩya hʋ buloŋ fa aa tɩŋ Yesu hal dɩ ba laŋŋa lɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɛɛ rɛ Yesu hatɩnna hʋ fi abee kɩdɩgɩ hʋ basɩ tɩya ba a baa, “Á Tɩɩna Yesu kɔnɩ sii sʋʋ tɩyaŋ nɛ, beewɩya, ʋ kaŋ ʋ tɩɩ ko daga Siimɔŋ nɛ!” ");
INSERT INTO sig_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Doŋ nɛ baala hʋ balɩya mɛ basɩ wɩɩ hʋ aa yaa ŋmanɩɩ hʋ tɩyaŋ, abee gɛɛ ba aa ko gyɩma anɩɩ á Tɩɩna Yesu rɛ. Ba basɩ tɩya ba rɛ anɩɩ saŋa hʋ ʋ aa kaŋ paanʋʋ lɔgɔ a tɩya ba hʋ tɩyaŋ nɛ ba gyɩma anɩɩ ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Saŋa hʋ baala hʋ balɩya aa tɩya ba ŋmanɩɩ duwoso tɩyaŋ nɛ dɩ Yesu tɩɩ rɛ bɩl pirigi ko sɩŋ ba buloŋ sɩya tɩyaŋ gɛɛ, aŋ basɩ tɩya ba a baa, “Fɩyɛlʋʋ we ma lee.” ");
INSERT INTO sig_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɛɛ rɛ kambɩŋ kaŋ ba, beewɩya ba kɛ fa bɩɩna anɩɩ nɩdʋma rɛ ba na gɛɛ. ");
INSERT INTO sig_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nyɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma, a ta kaŋ wɩya mɛ kɩ kyɩɩsɩ ma hakɩllɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ma deŋ ŋ nosi bee ŋ naasɩ na, ma sɩ gyɩma anɩɩ ŋ tɩɩ rɛ. Ma dige ŋ na weliŋ, ma sɩ gyɩma anɩɩ ŋ tɩɩ rɛ kɔnɩ, beewɩya nɩdʋma bɩ kaŋ hogo bee naŋpʋna anɩɩ ma aa naa dɩ ŋ kana nyɛ.” ");
INSERT INTO sig_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ʋ aa basɩ gɛɛ ko teŋ, ʋ kaŋ ʋ nosi abee ʋ naasɩ buloŋ a daga ba. ");
INSERT INTO sig_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wɩɩ no fa yaa ba wɩkperii rɛ, a bɩl yaa ba teŋfɩyɛlʋʋ mɛ kɩŋkaŋ. Amɛ ba ha fa bɩ laa ʋ di. Ɛɛ rɛ Yesu mɩɩgɩ pɩyɛsɩ ba a baa, “Ma kaŋ kɩdiiliye daha rɛ?” ");
INSERT INTO sig_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɛɛ rɛ ba kpa fuwonaŋ-kyabɩɩ, a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ʋ laa kyaŋ ba sɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Saŋa hʋ tɩyaŋ ŋ beel-ma aa we doŋ, wɩya no buloŋ nɛ ŋ laa sɩya basɩ tɩya ma. Wɩya hʋ buloŋ Moosi aa saba a mʋ kɩ tile ŋ tɩyaŋ, abee wɩya hʋ buloŋ Wɩɩsɩ tɩŋdaala aa saba, abee wɩya hʋ ba aa saba Wɩɩsɩ teŋ logiŋ hʋ ba aa yɩrɩ Yɩɩla tɩyaŋ, ba buloŋ maga dɩ ba ko su ba bʋʋsɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Doŋ nɛ Yesu leŋ ba hakɩllɩ suri dɩ ba wuwo gyɩŋ wɩya hʋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ memiye. ");
INSERT INTO sig_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aŋ bɩl basɩ tɩya ba a baa, “Nyɛ rɛ ba sabɩ biŋ: Ʋ maga dɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya na tʋwara rɛ, a sʋba aŋ sii sʋʋ tɩyaŋ ʋ kyɛtoo kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Ba bɩl saba rɛ dɩ nala sɩ basɩ Wɩɩsɩ wɩya, nal hʋ Wɩɩsɩ aa lɩya feŋ tɩyaŋ, dʋnɩya logiŋ buloŋ tɩyaŋ. Ba sɩ piili Gyerusalɛm tɩyaŋ a basɩ tɩya nala dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ dɩ Wɩɩsɩ kpa ba wɩbɔmɔ kyɛ ba. ");
INSERT INTO sig_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mamaa rɛ yaa wɩya no buloŋ aa yaa daŋsɩya diile. ");
INSERT INTO sig_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wiyesi Welii hʋ ŋ Kuwo aa wee nyʋwa dɩ ʋ sɩ kpa tɩya ma hʋ, ŋ sɩ kpa ʋ we ma tɩyaŋ. Amɛ ʋ maga dɩ ma gyegili Gyerusalɛm tɩyaŋ, a mʋ pele saŋa hʋ Wiyesi Welii no aa sɩ lɩɩ Wɩɩsɩ lee a ko tuu gyʋʋ ma tɩyaŋ, a tɩya ma dee.” ");
INSERT INTO sig_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ɛɛ rɛ Yesu kaŋ ʋ hatɩnna hʋ ba lɩɩ tɔbal hʋ tɩyaŋ a kpa mʋ Bɛɛtani dɩɩlaŋ. Ba aa we doŋ tɩyaŋ nɛ ʋ kaŋ ʋ nosi gyarɩ tɔ ba, a sʋla Wɩɩsɩ tɩya ba dɩ ʋ pɛ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Saŋa hʋ ʋ gyɩ aa sʋla Wɩɩsɩ kɩ tɩya ba hʋ tɩyaŋ nɛ, ʋ leŋ ba ta, ka Wɩɩsɩ kpa ʋ kaŋ gyɩŋ Wɩɩsɩbee. ");
INSERT INTO sig_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nyɛ rɛ ba kyʋwalɩ ʋ doŋ aŋ mɩɩgɩ mʋ Gyerusalɛm abee teŋfɩyɛlʋʋ yʋga. ");
INSERT INTO sig_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba gyɩ aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ nɛ saŋa buloŋ, a kɩ dannɩ Wɩɩsɩ, aŋ kɩ kyʋwalɩ ʋ aŋgyʋwasʋ.");
INSERT INTO sig_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka dɩ Wɩɩsɩ na marɩ dʋnɩya, dɩ nal hʋ ba aa yɩrɩ wɩbii hʋ gyɩ we doŋ nɛ, ʋ bee Wɩɩsɩ rɛ gyɩ we doŋ. Wɩbii no yaa Wɩɩsɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Haŋ saŋa hʋ buloŋ dɩ ʋ bee Wɩɩsɩ we doŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ʋ tɩyaŋ nɛ Wɩɩsɩ tɩŋa a ta kɩŋ buloŋ. Kɩŋ buloŋ tuwo dɩ ʋ tɩyaŋ daa Wɩɩsɩ tɩŋa a ta ʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wɩbii no rɛ aa tɩya mɩɩbol. Mɩɩbol no rɛ kaŋ pʋlʋŋ ko kɩ tɩya nala, a leŋ ba gyɩŋ Wɩɩsɩ wɩtɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pʋlʋŋ hʋ aa kyaanɩ bilhuu tɩyaŋ nɛ, amɛ bilhuu hʋ mɛ bɩ maakyiye wuwo tɔ pʋlʋŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɛɛ rɛ Wɩɩsɩ tɩŋ ʋ tɩŋdaal kɩdɩgɩ ba kɩ yɩrɩ Gyɔɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ʋ ko a basɩ pʋlʋŋ hʋ wɩya tɩya dʋnɩya nala dɩ ba nɩɩ a laa di. ");
INSERT INTO sig_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gyɔɔŋ daa gyɩ yaa pʋlʋŋ hʋ, amɛ ʋ ta ko dɩ ʋ basɩ pʋlʋŋ hʋ wɩya rɛ a tɩya nala. ");
INSERT INTO sig_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nal hʋ aa yaa pʋlʋŋ hʋ tɩɩ sɩ ko tuu dʋnɩya a kyaanɩ we nal nal buloŋ tɩyaŋ dɩ ba na ʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nal no gyɩ we dʋnɩya tɩyaŋ. Abee Wɩɩsɩ gyɩ aa tɩŋ ʋ tɩyaŋ a marɩ dʋnɩya mɛ, ka dʋnɩya nala gyɩ bɩ gyɩma ʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ʋ ko ʋ tɩɩ nala lee rɛ, ka ba bɩ laa ʋ we. ");
INSERT INTO sig_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amɛ nala hʋ buloŋ aa laa ʋ we aŋ laa ʋ wɩya di aŋ yelli-ʋ, ʋ tɩya ba ŋmanɩɩ rɛ ba bɩrɩmɩ Wɩɩsɩ biisi. ");
INSERT INTO sig_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nala no bɩ yaa Wɩɩsɩ biisi anɩɩ haaŋ bee baal aa lʋl ba gɛɛ, ba kyɛrɩ tɩyaŋ. Amɛ Wɩɩsɩ tɩɩ rɛ lɩɩ ba, ba yaa ʋ balɩya. ");
INSERT INTO sig_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɛɛ rɛ wɩbii hʋ bɩrɩmɩ nihuwobiŋ a ko we á tɩyaŋ, á na ʋ gaŋdarɩ, a na ʋ bɔnyɛ abee ʋ kyori aa maga gɛɛ, a na ʋ wɩtɩɩ mɛ mɔgɩsɩ. Gaŋdaa-feŋ hʋ ʋ aa kana, ʋ Kuwo Wɩɩsɩ rɛ kpaa tɩya ʋ, a daga anɩɩ ʋ rɛ yaa ʋ Biidɩgɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Gyɔɔŋ gyɩ heeli basɩ ʋ wɩya rɛ a baa, “Nal no wɩya rɛ ŋ gyɩ basɩ a baa, ‘Nal hʋ aa sɩ tɩŋa ŋ hal ko rɛ tee ŋ, beewɩya ʋ we doŋ nɛ faafaa buloŋ ka ba na lʋla ŋ.”’ ");
INSERT INTO sig_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ʋ bɔnyɛ aa yʋga beel-ma rɛ tɩŋ ʋ kɩ kyiyeli á buloŋ kyɛɛ bee ʋ nyʋwa buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wɩɩsɩ tɩŋ Moosi tɩyaŋ nɛ a biŋ ʋ mɩrɩsɩ tɩya ma. Amɛ Yesu Krisita tɩyaŋ nɛ Wɩɩsɩ tɩŋa a daga ma ʋ bɔnyɛ abee ʋ wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nal buloŋ ha bɩ maakyiye na Wɩɩsɩ. Amɛ ʋ Biidɩgɩ hʋ dʋŋ ʋ beel-ʋ aa yaa kɩdɩgɩ ka ʋ hɔŋ ʋ logiŋ hʋ, ʋ rɛ ko daga ma gɛɛ hʋ Wɩɩsɩ aa kɩya. ");
INSERT INTO sig_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɛɛ rɛ Gyuuma nɩhɩyasɩ hʋ gyɩ aa we Gyerusalɛm tɩyaŋ sii tɩŋ ba wɩɩkyʋwal sɩlaala abee Levi doho nala hʋ aa kɩ kyiyeli wɩɩkyʋwal sɩlaala hʋ wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, dɩ ba ko Gyɔɔŋ lee a pɩyɛsɩ ʋ a baa, “Aŋnɛ rɛ yaa ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Gyɔɔŋ gyɩ bɩ yaa nɩɩ we ʋ nyʋwa tɩyaŋ, ʋ gyɩ basɩ wɩtɩɩ tɩya ba rɛ anɩɩ ʋ daa yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya. ");
INSERT INTO sig_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɛɛ rɛ ba bɩl pɩyɛsɩ ʋ a baa, “Aŋnɛ rɛ yaŋ yaa ɩ? Ɩ rɛ yaa Ɛlaagya koo?” Ʋ baa dɩ ʋ daa. Ɛɛ rɛ ba bɩl pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa Wɩɩsɩ tɩŋdaal hʋ á aa gyegili hʋ?” Ʋ bɩl baa dɩ ʋ daa. ");
INSERT INTO sig_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Ɛɛ kɛ, yaŋ daga ma nal hʋ ɩ aa yaa? Beewɩya, ʋ maga dɩ ɩ daga nal hʋ ɩ aa yaa tɩya ma rɛ, dɩ á mʋ basɩ tɩya nala hʋ aa tɩŋ ma. Aŋnɛ yaŋ paalɩ yaa ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ɛɛ rɛ Gyɔɔŋ basɩ wɩya hʋ Wɩɩsɩ tɩŋdaal Azaaya aa saba a baa, “Mɩyaŋ nɛ yaa taal hʋ aa we pogo tɩyaŋ a heeli kɩ basɩ a baa, ‘Ma marɩ ŋmaŋ-deginii biŋ dɩ á Tɩɩna ko tɩŋa.”’ ");
INSERT INTO sig_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nala hʋ ba aa tɩma Gyɔɔŋ lee ba ko pɩyɛsɩ wɩya no, ba badɔmɔŋ fa yaa Farasiima rɛ. ");
INSERT INTO sig_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɛɛ rɛ ba bɩl pɩyɛsɩ ʋ a baa, “Na ɩ baa dɩ ɩ daa yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, ɩ daa yaa Ɛlaagya mɛ, ɩ bɩl bɩ yaa Wɩɩsɩ tɩŋdaal hʋ aa gyegili mɛ. Bee rɛ yaŋ tɩŋ ɩ kɩ fo nala wɩɩkyʋwalnɩɩ?” ");
INSERT INTO sig_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ɛɛ rɛ Gyɔɔŋ baa, “Nɩɩ dʋŋ nɛ ŋ kɛ kaŋ kɩ fo nala wɩɩkyʋwalnɩɩ, amɛ nal kɩdɩgɩ rɛ we ma tɩyaŋ daha, ka ma bɩ gyɩma ʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ʋ rɛ sɩ tɩŋa ŋ hal ko. Ŋ paalɩ bɩ maga dɩ ŋ kaŋ ʋ naatɔbɔ ŋmasɩ mɛ kaŋ puri.” ");
INSERT INTO sig_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wɩya no buloŋ gyɩ yaa Bɛɛtani tɩyaŋ nɛ, Gyɔɔdaŋ fuwo hʋ kyolo, lee hʋ Gyɔɔŋ gyɩ aa fo nala wɩɩkyʋwalnɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ʋ sɩgballɩya, Gyɔɔŋ naa Yesu dɩ ʋ aa ko ʋ lee. Ɛɛ rɛ ʋ baa, “Ma deŋ na, Wɩɩsɩ Pebiye hʋ rɛ nyɛ. Ʋ rɛ laa dʋnɩya nala kɩ ta ba wɩbɔmɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Baal no wɩya rɛ ŋ gyɩ basɩ tɩya ma a baa, ‘Nal hʋ aa sɩ tɩŋa ŋ hal ko, ʋ rɛ tee ŋ beewɩya ʋ we doŋ nɛ faafaa buloŋ ka ba na lʋla ŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ŋ tɩɩ fa paalɩ bɩ gyɩŋ nal hʋ buloŋ ʋ aa yaa. Amɛ ŋ kɛ ta ko rɛ a kpa nɩɩ dʋŋ kɩ fo nala wɩɩkyʋwalnɩɩ, dɩ Iziral tɩmma (Wɩɩsɩ nala) ko gyɩŋ nal hʋ iriŋ ʋ aa yaa.”’ ");
INSERT INTO sig_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Gyɔɔŋ tɩɩ wɩya hʋ ʋ aa basa tɩya nala rɛ nyɛ: Ʋ baa, “Ŋ naa Wɩɩsɩ Wiyesi Welii hʋ rɛ dɩ ʋ lɩɩ wɩɩsɩnyuu anɩɩ kokomo, a ko tuu saga ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ŋ mɛ tɩɩ ha fa bɩ gyɩma ʋ. Amɛ Wɩɩsɩ aa tɩma ŋ dɩ ŋ fo nala wɩɩkyʋwalnɩɩ abee nɩɩ dʋŋ, ʋ rɛ basɩ tɩya ŋ a baa, ‘Ɩ sɩ na Wɩɩsɩ Wiyesi Welii hʋ dɩ ʋ ko tuu a we nal tɩyaŋ. Nal no tɩɩna rɛ sɩ kpa Wɩɩsɩ Wiyesi Welii hʋ a fo nala wɩɩkyʋwalnɩɩ!’ ");
INSERT INTO sig_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ɛɛ rɛ Gyɔɔŋ bɩl baa, ‘Ŋ kɔnɩ naa wɩya no yayɩ rɛ, a yaŋ basɩ kɩ tɩya ma anɩɩ ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya.”’ ");
INSERT INTO sig_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ʋ sɩgballɩya, Gyɔɔŋ bee ʋ hatɩnna balɩya bɩl sɩŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Gyɔɔŋ aa naa Yesu dɩ ʋ aa baŋ, ɛɛ rɛ ʋ baa, “Ma na, Wɩɩsɩ Pebiye hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ʋ hatɩnna hʋ balɩya aa nɩɩ ʋ aa basɩ wɩɩ no, ba sii tɩŋ Yesu hal mʋ. ");
INSERT INTO sig_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu mɩɩgɩ galdaasɩ, dɩ ʋ naa ba aa tɩŋa ʋ hal. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Bekiŋ nɛ ma kɩ kyɛ?” Ɛɛ rɛ ba mɛ pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, lee rɛ ɩ kɩ gyʋʋ?” ");
INSERT INTO sig_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ko na.” Ɛɛ rɛ ba tɩŋa ʋ hal mʋ a na lee hʋ ʋ aa gyʋʋ. Saŋa no, dɩ ʋ gyɩ yaa dɩdaana rɛ. Ɛɛ rɛ ba we ʋ lee sɩya gballɩ. ");
INSERT INTO sig_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nala no balɩya kɩdɩgɩ feŋ nɛ Aŋduru, a fa yaa Siimɔŋ Piita nɩɩnabiye. ");
INSERT INTO sig_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ɛɛ rɛ Aŋduru mɛ kyɛ ʋ maana Siimɔŋ lee haŋ lagɩlagɩbiye hʋ, a basɩ tɩya ʋ a baa, “Á naa Krisita, laataal hʋ Wɩɩsɩ aa lɩya hʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ʋ kaŋ Siimɔŋ ko Yesu lee. Nyɛ rɛ Yesu deŋ ʋ, aŋ basɩ tɩya ʋ a baa, “Ɩ Gyɔɔŋ biibaal Siimɔŋ, ba sɩ kana ɩ kɩ yɩrɩ Siifaasi.” Siifaasi bee Piita yaa feŋdɩgɩ rɛ. Ʋ memii rɛ yaa bʋtaal. ");
INSERT INTO sig_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ʋ sɩgballɩya Yesu sii dɩ ʋ mʋ Galili paalʋʋ. Ɛɛ rɛ ʋ na Fɩlɩpɩ a basɩ tɩya ʋ a baa, “Kɩ tɩŋa ŋ hal.” ");
INSERT INTO sig_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fɩlɩpɩ fa lɩɩ Bɛsaada rɛ, tɔɔ hʋ Aŋduru bee Piita mɛ aa lɩya. ");
INSERT INTO sig_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ɛɛ rɛ Fɩlɩpɩ na Nataniyɛl a basɩ tɩya ʋ a baa, “Á naa nal hʋ wɩya Moosi fa aa saba biŋ Wɩɩsɩ mɩrɩsɩ hʋ tɩyaŋ, ka Wɩɩsɩ tɩŋdaala hʋ mɛ fa basɩ ʋ wɩya hʋ rɛ. Ʋ rɛ yaa Gyosɛfʋ biibaal Yesu aa lɩɩ Nazarɛti.” ");
INSERT INTO sig_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ɛɛ rɛ Nataniyɛl pɩyɛsɩ ʋ a baa, “Ɩ ha maakyiye na wɩwelii lɩɩ Nazarɛti?” Ɛɛ rɛ Fɩlɩpɩ basɩ tɩya ʋ a baa, “Ko na.” ");
INSERT INTO sig_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu aa naa Nataniyɛl dɩ ʋ aa ko ʋ lee, ʋ basɩ ʋ wɩya a baa, “Nal no yaa Iziral tɩɩna tɩɩtɩɩ rɛ. Ʋ kaŋ wɩtɩɩ rɛ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ɛɛ rɛ Nataniyɛl pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ɩ yaa gyɩma ŋ?” Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ naa ɩ rɛ dɩ ɩ ha hɔŋ tutogo hʋ memii, ka Fɩlɩpɩ na yɩrɩ ɩ.” ");
INSERT INTO sig_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ɛɛ rɛ Nataniyɛl basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, ɩ rɛ yaa Wɩɩsɩ Biye hʋ. Ɩ rɛ yaa Iziral tɩmma kuwori hʋ.” ");
INSERT INTO sig_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ŋ aa baa dɩ ŋ naa ɩ dɩ ɩ hɔŋ tutogo hʋ memii rɛ tɩŋ, ɩ laa ŋ wɩya di nyɛ koo? Ɩ sɩ na wɩkperiye a te nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma sɩ na wɩɩsɩnyuu dɩ ʋ suro, dɩ malɩkasɩ lɩɩ doŋ a ko tuu mɩyaŋ Nihuwobiŋ Biye lee, aŋ mɩɩgɩ kɩ gyɩŋ.” ");
INSERT INTO sig_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ʋ kyɛtoo kyɛɛ, dɩ ba gyɩ aa gbɩyalɩ hafalɩɩ gbɩyala Galili paalʋʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Keena tɩyaŋ. Yesu nɩɩna gyɩ we doŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba gyɩ yɩrɩ Yesu bee ʋ hatɩnna hʋ mɛ rɛ, ba mɛ mʋ hafalɩɩ gbɩyala hʋ. ");
INSERT INTO sig_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ba ha fa we gbɩyala hʋ tɩyaŋ nɛ ka ba sɩŋ hʋ buloŋ teŋ. Ɛɛ rɛ Yesu nɩɩna basɩ tɩya ʋ a baa, “Nala hʋ sɩŋ hʋ tene rɛ”. ");
INSERT INTO sig_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ta leŋ dɩ wɩɩ no lɔl ma. Beewɩya, saŋa hʋ ha bɩ pele dɩ ŋ yaa wɩɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Doŋ nɛ Yesu nɩɩna mɩɩgɩ basɩ tɩya dɩya hʋ tʋŋtʋnna a baa, “Ma yaa wɩɩ hʋ buloŋ ʋ aa sɩ baa dɩ ma yaa.” ");
INSERT INTO sig_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gyuuma fa aa kɩ sɔŋ nɩɩ rɛ anɩɩ ba wɩɩkyʋwal lesiri aa daga gɛɛ. Ɛɛwɩya, viigyenni badʋ ba aa kaŋ bʋwa marɩ rɛ fa sɩŋ doŋ abee nɩɩ. Viini no kɩdɩgɩ buloŋ sɩ kɩ gyʋʋ anɩɩ nɩɩ-galaŋ mɔlɩya koo galaŋ mɔlɩya bee fi. ");
INSERT INTO sig_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ɛɛ rɛ Yesu basɩ tɩya dɩya tʋŋtʋnna hʋ a baa, “Ma yaa nɩɩ su viini hʋ.” Nyɛ rɛ ba yaa nɩɩ su viini hʋ buloŋ pɩlpɩl. ");
INSERT INTO sig_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma yaa nɩɩ hʋ vii hʋ tɩyaŋ a kaŋ mʋ tɩya nal hʋ aa deŋ gbɩyala hʋ. Ɛɛ rɛ ba yaa mʋ tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ʋ laa nɩɩ hʋ nyʋwa a na dɩ ʋ bɩrɩmɩ sɩŋ. Ʋ kɛ fa bɩ gyɩŋ lee hʋ ba aa naa sɩŋ hʋ. Amɛ dɩya hʋ tʋŋtʋnna hʋ kɛ fa gyɩma rɛ. Ɛɛ rɛ ʋ yɩrɩ hafalɩɩ hʋ bala, ");
INSERT INTO sig_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a basɩ tɩya ʋ a baa, “Gbɩyala buloŋ tɩyaŋ, ba aa laasɩya kaŋ sɩwelii rɛ ko lɩɩ ba nyʋwa. Dɩ nal buloŋ yaŋ ko nyʋwa vɔgɔ, ɩ yaŋ na kaŋ sɩŋ hʋ aa bɩ sʋma, a tɩŋ hal ko. Ka ɩ kɛ mɩɩgɩ kpa sɩwelii hʋ biŋ hal, a ko pele saŋa no buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu aa leŋ nɩɩ bɩrɩmɩ sɩŋ Keena aa we Galili paalʋʋ tɩyaŋ nɛ gyɩ yaa ʋ wɩmagɩlbuŋbuŋ ʋ aa yaa. Doŋ nɛ ʋ daga gɛɛ ʋ gaŋdarɩ aa maga. Ʋ hatɩnna hʋ aa naa gɛɛ, ba marɩ laa ʋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gbɩyala hʋ aa ko teŋ, ɛɛ rɛ Yesu bee ʋ naa abee ʋ naabalɩya abee ʋ hatɩnna hʋ sii mʋ Kapɛɛnam, a we doŋ kyɛyɛ baŋmana. ");
INSERT INTO sig_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ʋ gyɩ ko ka mʋhʋ rɛ ka dɩ Gyuuma Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ pele. Ɛɛ rɛ Yesu sii mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Doŋ nɛ ʋ mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo, a na dɩ nala aa yallɩ nʋsɩ, abee piyese abee kokosi, ka badɔmɔŋ mɛ hɔŋ teebʋlsɩ hal a kɩ lenni molbinʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ɛɛ rɛ Yesu kaŋ ŋmasɩ mɩna a marɩ kyapɩya, a kile piyese hʋ bee nʋsɩ hʋ buloŋ ta, ba lɩɩ Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo tɩyaŋ, aŋ kaŋ nala hʋ aa lenni molbiye teebʋlsɩ mɛ bɩrɩmɩ kyige kyige, ba molbinʋʋ hʋ buloŋ gyaasɩ taŋha. ");
INSERT INTO sig_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɛɛ rɛ ka ʋ nɔsɩ basɩ tɩya nala hʋ mɛ aa yallɩ kokosi hʋ a baa, “Ma kasɩ ma kokosi hʋ lɩɩ daha. Ma ta kaŋ ŋ kuwo dɩya bɩrɩmɩ yɔbɔ.” ");
INSERT INTO sig_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ɛɛ rɛ ʋ hatɩnna liisi wɩɩ hʋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ a baa, “Wɩɩsɩ, ɛɛ hʋ ɩ dɩya no wɩya aa kyɩla ŋ sɩ bori ŋ bembii.” ");
INSERT INTO sig_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Akuu wɩya hʋ Yesu aa yaa Wɩɩkyʋwaldɩɩbal hʋ gyaŋwuwo tɩyaŋ wɩya, Gyuuma nɩhɩyasɩ hʋ mɩɩgɩ ko pɩyɛsɩ ʋ a baa, “Bekiŋ wɩmagɩl lɛ ɩ sɩ wuwo yaa, a daga ma anɩɩ Wɩɩsɩ rɛ tɩya ɩ ŋmanɩɩ dɩ ɩ kɩ yaa wɩya no?” ");
INSERT INTO sig_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ mamaa rɛ ŋmaa Wɩɩkyʋwaldɩya no lo, ŋ sɩ wuwo kpa kyɛyɛ boto a bɩl saa ʋ”. ");
INSERT INTO sig_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Kaa! Aŋnɛ rɛ mʋrɩ ɩ gɛɛ? Bɩsɩ mɔllɩbalɩya abee badʋ rɛ ba kpa saa Wɩɩkyʋwaldɩɩbal no, ka ɩ kɛ baa dɩ ɩ sɩ kpa kyɛyɛ boto a saa ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amɛ Yesu aa basɩ Wɩɩkyʋwaldɩya hʋ wɩya gɛɛ, ʋ tɩɩ teŋbii rɛ ʋ kɩ daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Saŋa hʋ ʋ aa ko sii sʋʋ tɩyaŋ nɛ ʋ hatɩnna hʋ liisi mʋ parɩ anɩɩ ʋ gyɩ basɩ wɩɩ no rɛ. Ɛɛ rɛ ba marɩ laa wɩya hʋ ba aa saba we Wɩɩsɩ teŋ tɩyaŋ abee wɩya hʋ Yesu aa basa a di. ");
INSERT INTO sig_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu ha fa aa we Gyerusalɛm tɩyaŋ, Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ saŋa, nɩgyamaa gyɩ laa ʋ wɩya di rɛ, akuu ba aa naa wɩmagɩla hʋ ʋ aa yaa wɩya. ");
INSERT INTO sig_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amɛ Yesu ka gyɩ bɩ laa ba wɩya di, beewɩya ʋ gyɩŋ nihuwobiŋ buloŋ tɩya aa kɩɩ gɛɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ʋ bɩ maga dɩ nal buloŋ bɩl basɩ nihuwobisi wɩya tɩya ʋ, beewɩya ʋ kɛ gyɩŋ nihuwobisi tɩsɩ wɩkanɩya buloŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Gyuuma nɩhɩyawʋ kɩdɩgɩ rɛ gyɩ we doŋ ba kɩ yɩrɩ Nikodemu, a fa yaa Farasiima wɩɩkyʋwal noŋ nal. ");
INSERT INTO sig_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tebine kɩdɩgɩ, ʋ sii ko Yesu lee a baa, “Dɩdagɩl, á gyɩma anɩɩ ɩ yaa nal Wɩɩsɩ aa tɩma dɩ ɩ ko kɩ daga nala rɛ. Nal buloŋ bɩ sɩ wuwo yaa wɩmagɩla hʋ ɩ aa yaa, dɩ Wɩɩsɩ bɩ pɛɛ tɩɩna tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, nal buloŋ bɩ sɩ wuwo gyʋʋ Wɩɩsɩ koro hʋ tɩyaŋ, see dɩ ba bɩl mɩɩgɩ lʋl tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ɛɛ rɛ Nikodemu pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ba sɩ yaa a bɩl mɩɩgɩ lʋl nal aa hɩyasa. Beewɩya ʋ bɩl bɩ sɩ wuwo mɩɩgɩ gyʋʋ ʋ naa luwol dɩ ʋ bɩl lʋla ʋ?” ");
INSERT INTO sig_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ɛɛ rɛ Yesu baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, nal buloŋ bɩ sɩ wuwo gyʋʋ Wɩɩsɩbee koro hʋ tɩyaŋ, see dɩ ba fo ʋ tɩɩna wɩɩkyʋwalnɩɩ, ka dɩ Wɩɩsɩ kpa ʋ Wiyesi Welii hʋ we tɩɩna tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nihuwobiŋ aa lʋl nihuwobiŋ ʋ kaŋ mɩɩbol lɛ taŋha no tɩyaŋ. Aŋka Wɩɩsɩ mɛ rɛ aa kpa ʋ Wiyesi Welii hʋ a we ʋ tɩɩna tɩyaŋ, ʋ kaŋ mɩɩbol Wɩɩsɩ lee. ");
INSERT INTO sig_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta leŋ dɩ ʋ yaa ɩ wɩkperii abee ŋ aa basɩ tɩya ɩ anɩɩ ʋ maga dɩ ba bɩl mɩɩgɩ lʋl nal buloŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Puwo aa dɔŋ kɩ mʋ lee hʋ buloŋ ʋ aa kyo rɛ. Ɩ kɩ nɩɩ ʋ dɔmɔ, amɛ ɩ bɩ sɩ gyɩŋ lee hʋ ʋ aa lɩɩ kɩ ko, a bɩ gyɩŋ lee hʋ mɛ ʋ aa mʋʋ. Nyɛ rɛ yaŋ nal buloŋ Wɩɩsɩ aa kpa ʋ Wiyesi Welii hʋ we ʋ tɩyaŋ ʋ kaŋ mɩɩbofalɩɩ mɛ kɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ɛɛ rɛ Nikodemu mɩɩgɩ pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ wɩɩ no sɩ wuwo yaa.” ");
INSERT INTO sig_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ sɩ yaa kerikyibal Iziral paalʋʋ tɩyaŋ, aŋ bɩ gyɩŋ wɩɩ no memii? ");
INSERT INTO sig_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, wɩɩ hʋ á aa gyɩma rɛ á kɩ basɩ, a kɩ di wɩɩ hʋ mɛ á aa naa daŋsɩya. Amɛ ma kɩdɩgɩ buloŋ bee kyɛ dɩ ʋ laa wɩɩ hʋ á aa basɩ di. ");
INSERT INTO sig_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ŋ basɩ dʋnɩya wɩya rɛ kɩ tɩya ma, ka ma bɩ laa di. Dɩ mɩyaŋ nɛ yaŋ basɩ wɩɩsɩbee wɩya tɩya ma, ɛɛ rɛ ma sɩ yaa laa di? ");
INSERT INTO sig_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nal buloŋ ha bɩ maakyiye mʋ wɩɩsɩbee, see mɩyaŋ Nihuwobiŋ Biye aa lɩɩ doŋ ko tuu dʋŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moosi fa aa we pogo hʋ tɩyaŋ, ʋ fa kaŋ hɔgɩ a lugo dʋŋ nɛ, a kpa mal daaŋ tɩyaŋ a kaŋ gye. Nal hʋ buloŋ gyɩ aa deŋ na dʋŋ no aa gyee gɛɛ, ʋ bɩl bɩ sʋba aŋ kaŋ mɩɩbol. Ɛɛ tɩɩ rɛ ba sɩ kpaasɩ mɩyaŋ Nihuwobiŋ Biye mɛ daaŋ tɩyaŋ a kaŋ gye. ");
INSERT INTO sig_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nal hʋ buloŋ mɛ aa laa ŋ wɩya di, ʋ tɩɩna sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wɩɩsɩ kyo dʋnɩya nala rɛ a mʋ parɩ, ɛɛ rɛ tɩŋ ʋ kpa ʋ Biidɩgɩ hʋ ʋ aa kana a tɩya ma, dɩ nal hʋ buloŋ aa laa ʋ wɩya di, ʋ tɩɩna bɩ sɩ nyʋgɩsɩ, amɛ ʋ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Beewɩya Wɩɩsɩ bɩ taa ʋ Biye dɩ ʋ ko tuu di dʋnɩya nala sarɩya a kpa kyogisi tɩya ba, amɛ ʋ taa ʋ rɛ dɩ ʋ ko tuu laa dʋnɩya nala ta. ");
INSERT INTO sig_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nal kɛ buloŋ aa laa Yesu wɩya di, Wɩɩsɩ bɩ sɩ di ʋ tɩɩna sarɩya a kpa kyogisi tɩya ʋ, amɛ nal hʋ buloŋ aa bɩ laa ʋ wɩya di, Wɩɩsɩ teŋ dii ʋ tɩɩna sarɩya rɛ a kpa kyogisi tɩya ʋ, beewɩya ʋ tɩɩna bɩ laa Wɩɩsɩ Biidɩgɩ hʋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wɩɩ hʋ aa tɩŋ Wɩɩsɩ di dʋnɩya nala sarɩya a kpa kyogisi tɩya ba rɛ nyɛ: Ʋ taa pʋlʋŋ hʋ aa dagɩ ʋ wɩtɩɩ rɛ ʋ ko tuu dʋnɩya, amɛ dʋnɩya nala kyo bilhuu rɛ a te pʋlʋŋ, beewɩya ba wɩyaalɩya lɔrɔ rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nal hʋ buloŋ aa yaa wɩbɔmɔ, ʋ bɩ kyo pʋlʋŋ, ʋ bee lɩɩ pʋlʋŋ tɩyaŋ, beewɩya ʋ bee kyɛ dɩ ʋ wɩbɔmɔ hʋ lɩɩ pʋlʋŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amɛ nal hʋ buloŋ aa yaa wɩweliye, ʋ tɩɩna aa kyo pʋlʋŋ nɛ, a kɩ lɩɩ pʋlʋŋ tɩyaŋ mɛ, dɩ nala na anɩɩ Wɩɩsɩ nyʋwa rɛ ʋ tɩŋa, a kɩ yaa wɩya hʋ ʋ aa yaa.” ");
INSERT INTO sig_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɛɛ hal tɩyaŋ nɛ Yesu bee ʋ hatɩnna hʋ lɩɩ Gyerusalɛm, a kpa mʋ Gyudɩya paalʋʋ. Ba yaa kyɛyɛ baŋmana rɛ doŋ tɩyaŋ, aŋ fo nala wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Dɩ Gyɔɔŋ mɛ gyɩ we lee kɩdɩgɩ aa kpaga Saalim, ba kɩ yɩrɩ Eenɔŋ a kɩ fo nala wɩɩkyʋwalnɩɩ, beewɩya doŋ fa kaŋ nɩɩ rɛ weliŋ. Nala fa aa kɩ mʋ ʋ lee rɛ ʋ kɩ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Saŋa no tɩyaŋ dɩ ba ha gyɩ bɩ kaŋ Gyɔɔŋ tɔ dɩya tɩyaŋ). ");
INSERT INTO sig_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɛɛ rɛ Gyɔɔŋ hatɩnna badɔmɔŋ abee Gyuuma kɩdɩgɩ sii kaŋ ba lesiri nɩɩ sɔmɩɩ wɩya kɩ kpa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɛɛ rɛ ba mʋ pɩyɛsɩ Gyɔɔŋ a baa, “Á nɩhɩyawʋ, ɩ liisi ɩ bee baal hʋ gyɩ aa we Gyɔɔdaŋ fuwo hʋ kyolo wɩya ɩ gyɩ aa basɩ hʋ rɛ? Lagɩlagɩ no, ʋ mɛ aa fo nala wɩɩkyʋwalnɩɩ rɛ, nal nal buloŋ kɩ mʋ ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ɛɛ rɛ Gyɔɔŋ baa, “Nal buloŋ bɩ sɩ wuwo yaa nyɛ dɩ Wɩɩsɩ daa tɩya ʋ tɩɩna ŋmanɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ma tɩɩ yaa ŋ daŋsɩya rɛ, ka ŋ basɩ anɩɩ ŋ daa yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, amɛ Wɩɩsɩ ta tɩma ŋ nɛ, dɩ ŋ laa sɩya ko ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hafalɩɩ bala rɛ tɩŋ haaŋ, amɛ dɩ hafalɩɩ hʋ bala kyana rɛ ko sɩŋ doŋ a kɩ gyegili wɩya hʋ ba aa basɩ, ʋ teŋ aa fɩyɛlɩ rɛ dɩ ʋ rɛ nɩɩ hafalɩɩ hʋ bala taal. Ɛɛ tɩɩ rɛ ŋ teŋ mɛ fɩyɛlɩ weliŋ Yesu wɩya. ");
INSERT INTO sig_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ʋ rɛ maga dɩ ʋ yaa nɩbal, ka dɩ ŋ yaa nɩbiye. ");
INSERT INTO sig_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nal hʋ aa lɩɩ wɩɩsɩbee ko, ʋ rɛ tee nal buloŋ. Nal hʋ aa lɩɩ dʋnɩya no tɩyaŋ, ʋ tɩɩna yaa dʋnɩya no nyuu nal lɛ, a kɩ basɩ dʋnɩya wɩkanɩya mɛ. Amɛ nal hʋ aa lɩɩ wɩɩsɩbee ko, ʋ rɛ tee nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ʋ aa basɩ wɩya ʋ aa naa aŋ nɩɩ mɛ rɛ, amɛ nal buloŋ bɩ laa ʋ di. ");
INSERT INTO sig_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Amɛ nal hʋ mɛ buloŋ aa laa ʋ wɩya di aa daga rɛ anɩɩ Wɩɩsɩ kaŋ wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nal hʋ Wɩɩsɩ aa tɩma, ʋ aa basɩ Wɩɩsɩ nyʋwa wɩya rɛ, beewɩya Wɩɩsɩ kpaa ʋ Wiyesi Welii hʋ dee buloŋ nɛ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wɩɩsɩ kyo ʋ Biye rɛ, ɛɛ rɛ tɩŋ ʋ kpa kɩŋ buloŋ dee we ʋ nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nal hʋ buloŋ aa tɩŋ Wɩɩsɩ Biye hʋ nyʋwa, ʋ tɩɩna sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii, amɛ nal hʋ mɛ buloŋ aa bee tɩŋ Wɩɩsɩ Biye hʋ nyʋwa, ʋ tɩɩna bɩ sɩ maakyiye na mɩɩbol hʋ aa bɩ kaŋ tenii, amɛ Wɩɩsɩ sɩ na baaŋ ʋ tɩɩna nyuu tɩyaŋ, a kaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɛɛ rɛ Farasiima hʋ ko nɩɩ anɩɩ Yesu naa hatɩnna kɩ te Gyɔɔŋ nɛ, aa leŋ ba kɩ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Amɛ Yesu kɛ tɩɩ gyɩ bɩ foo nal buloŋ wɩɩkyʋwalnɩɩ, ʋ hatɩnna hʋ dʋŋ nɛ gyɩ aa kɩ fo nala wɩɩkyʋwalnɩɩ.) ");
INSERT INTO sig_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu aa nɩya dɩ ba aa basɩ ʋ wɩya gɛɛ, ɛɛ rɛ ʋ sii lɩɩ Gyudɩya paalʋʋ tɩyaŋ a mɩɩgɩ mʋ Galili paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ʋ aa mʋ Galili hʋ tɩyaŋ nɛ, Wɩɩsɩ leŋ ʋ tɩŋ Samaarɩya paalʋʋ, ");
INSERT INTO sig_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","a ko pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Siika. Doŋ bee taŋha hʋ Gyeekɔbɩ gyɩ aa kpaa tɩya ʋ biibaal Gyosɛfʋ fa bɩ boliye. ");
INSERT INTO sig_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Gyeekɔbɩ kɔlʋŋ gyɩ we doŋ tɩyaŋ nɛ. Yesu fa aa vala ŋmanɩɩ hʋ gɛɛ, lɔl gyʋʋ ʋ, ɛɛ rɛ ʋ mʋ hɔŋ kɔlʋŋ hʋ nyʋwa. Saŋa no tɩyaŋ dɩ Wɩɩsɩ gyɩ yaŋ maga nyutʋtʋʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɛɛ rɛ Samaarɩya tɩmma haaŋ kɩdɩgɩ ko kɔlʋŋ hʋ dɩ ʋ yaa nɩɩ. Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Yaa nɩɩ tɩya ŋ dɩ ŋ nyʋwa.” ");
INSERT INTO sig_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Saŋa no tɩyaŋ dɩ Yesu hatɩnna hʋ gyɩ mʋʋ bee hʋ tɩya rɛ dɩ ba yɔbɔ kɩdiiliye. ");
INSERT INTO sig_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɛɛ rɛ Samaarɩya tɩmma haaŋ hʋ pɩyɛsɩ Yesu a baa, “Bee rɛ tɩŋ ɩ Gyuu kɩ sʋla nɩɩ mɩyaŋ Samaarɩya tɩɩna lee?” (Gyuuma gyɩ bɩ sɩ laa nyʋwa dɩ ba bee Samaarɩya tɩɩna pɛ kɩdigbaha, koo nɩɩnyʋwagbaŋbiidɩgɩ. Ɛɛ rɛ tɩŋ haaŋ hʋ basɩ gɛɛ.) ");
INSERT INTO sig_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Dɩ ɩ rɛ fa gyɩŋ kɩŋ hʋ Wɩɩsɩ aa kpa tɩya nala, a fa gyɩŋ nal hʋ aa sʋla nɩɩ ɩ lee nyɛ, ɩ fa sɩ sʋla ʋ dɩ ʋ tɩya ɩ nɩɩ hʋ aa tɩya mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɛɛ rɛ haaŋ hʋ pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, ɩ bɩ kaŋ gʋʋga ɩ aa sɩ kaŋ yaa nɩɩ hʋ, ka kɔlʋŋ hʋ mɛ luŋiye. Lee tɩyaŋ nɛ ɩ sɩ na nɩɩ hʋ aa tɩya mɩɩbol? ");
INSERT INTO sig_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Á naabaa Gyeekɔbɩ rɛ kpaa kɔlʋŋ no tɩya ma. Ʋ bee ʋ biisi abee ʋ pʋsɩ buloŋ nyʋwa kɔlʋŋ no nɩɩ rɛ. Ɩ aa kyɛ ɩ baa ɩ tee Gyeekɔbɩ rɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Nal hʋ buloŋ aa sɩ nyʋwa nɩɩ no, nɩɩnyʋwasɩ ha bɩl sɩ kaŋ ʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amɛ nal hʋ buloŋ aa sɩ nyʋwa nɩɩ hʋ ŋ aa sɩ tɩya ʋ, nɩɩnyʋwasɩ bɩl bɩ sɩ maakyiye kana ʋ tɩɩna. Nɩɩ hʋ ŋ aa sɩ tɩya ʋ sɩ kɩɩ gɛɛ rɛ anɩɩ bulo ʋ tɩɩna tɩyaŋ, a bulo nɩɩ hʋ aa tɩya mɩɩbol aa bɩ kaŋ tenii a kɩ tɩya ʋ tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɛɛ rɛ haaŋ hʋ basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, tɩya ŋ nɩɩ no, dɩ nɩɩnyʋwasɩ ta bɩl maakyiye kana ŋ, dɩ ŋ ta bɩl ko kɩ yaa nɩɩ daha mɛ.” ");
INSERT INTO sig_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Mʋ yɩrɩ ɩ bala dɩ ma ko” ");
INSERT INTO sig_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nyɛ rɛ haaŋ hʋ baa dɩ ʋ bɩ kaŋ bala. Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ a baa, “Wɩtɩɩ rɛ ɩ basɩ ɩ aa baa ɩ bɩ kaŋ bala, ");
INSERT INTO sig_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","beewɩya ɩ laa sɩya yal balama bɔnɔŋ nɛ, ɩ bee baal hʋ aa we doŋ lagɩlagɩ no, ʋ kɔnɩ bɩ yaa ɩ bala.” ");
INSERT INTO sig_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɛɛ rɛ haaŋ hʋ basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, ŋ naa nɩɩ ɩ yaa Wɩɩsɩ tɩŋdaal lɛ.” ");
INSERT INTO sig_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɛɛ rɛ haaŋ hʋ bɩl basɩ tɩya ʋ a baa, “Á Samaarɩya tɩmma naabaala kyʋwalɩ Wɩɩsɩ dogimo no nyuu tɩyaŋ nɛ, aŋka ma Gyuuma mɛ baa dɩ Gyerusalɛm nɛ yaa lee hʋ á aa maga dɩ á kɩ kyʋwalɩ Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Haŋtolibiye, laa ŋ di anɩɩ saŋa kɩdɩgɩ sɩ pele dɩ nala bɩl bɩ sɩ kɩ kyʋwalɩ á Kuwo Wɩɩsɩ dogimo no nyuu koo Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ma Samaarɩya tɩmma paalɩ bɩ gyɩŋ nal hʋ ma aa kyʋwalɩ, amɛ á Gyuuma kɛ gyɩŋ nal hʋ á aa kyʋwalɩ rɛ. Beewɩya Gyuuma rɛ sɩ daga ma gɛɛ Wɩɩsɩ aa sɩ laa dʋnɩya nala ta. ");
INSERT INTO sig_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Saŋa kɩdɩgɩ sɩ pele, ʋ paalɩ pele rɛ gba, dɩ nala hʋ kɔnɩ aa kyʋwalɩ Wɩɩsɩ, kyʋwalɩ ʋ abee wɩtɩɩ, Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ. Wɩɩkyʋwalla no iriŋ nɛ Wɩɩsɩ kɩ kyɛ dɩ ba kɩ kyʋwalɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wɩɩsɩ kɩɩ gɛɛ rɛ anɩɩ wiyese, ɛɛ wɩya nala hʋ aa kyɛ dɩ ba kyʋwalɩ ʋ, ʋ maga dɩ ba kyʋwalɩ ʋ abee wɩtɩɩ rɛ, ʋ Wiyesi Welii hʋ dee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","26","Ɛɛ rɛ haaŋ hʋ basɩ tɩya ʋ a baa, “Ŋ gyɩma anɩɩ Krisita, laataal hʋ Wɩɩsɩ aa lɩya, sɩ ko. Dɩ ʋ rɛ ko ko, ʋ sɩ daga ma wɩɩ buloŋ sɩɩ.” Yesu mɩɩgɩ basɩ tɩya ʋ a baa, “Mɩyaŋ nɛ yaŋ gɛɛ. Mɩyaŋ nal no aa basɩ wɩya ɩ lee hʋ nɛ yaa Krisita hʋ.” ");
INSERT INTO sig_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Saŋa no tɩyaŋ dɩ Yesu hatɩnna hʋ mɛ mɩɩgɩ ko. Ba nyʋʋsɩ gyɩ fɩyɛla rɛ kɩŋkaŋ ba aa ko na dɩ ʋ bee haaŋ hʋ aa basɩ wɩya. Amɛ ba kɩdɩgɩ buloŋ gyɩ bɩ suri nyʋwa a pɩyɛsɩ haaŋ hʋ anɩɩ bee rɛ ʋ kɩ kyɛ Yesu lee, koo a pɩyɛsɩ Yesu baa bee rɛ tɩŋ ʋ kɩ basɩ wɩya haaŋ no lee. ");
INSERT INTO sig_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɛɛ rɛ haaŋ hʋ leŋ ʋ vii hʋ doŋ, aŋ mɩɩgɩ mʋ bee hʋ tɩya, a basɩ tɩya nala a baa, ");
INSERT INTO sig_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ma ko na baal kɩdɩgɩ aa wuwo daga wɩya hʋ buloŋ ŋ aa yaa ŋ mɩɩbol tɩyaŋ. Kapuwo ʋ rɛ yaa Krisita hʋ.” ");
INSERT INTO sig_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɛɛ rɛ ba lɩɩ bee hʋ tɩyaŋ a kpa kɩ mʋ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saŋa no tɩyaŋ dɩ Yesu hatɩnna hʋ aa sʋla ʋ rɛ a baa, “Á nɩhɩyawʋ, di kɩŋ mʋhʋ.” ");
INSERT INTO sig_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ kaŋ kɩdiiliye rɛ ma aa bɩ gyɩŋ ba wɩya.” ");
INSERT INTO sig_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ɛɛ rɛ Yesu hatɩnna hʋ mɩɩgɩ sɩŋ kɩ pɩyɛsɩ dɔmɔŋ “Nal lɛ yaŋ kaŋ kɩdiiliye ko tɩya ʋ ka á bɩ gyɩma koo?” ");
INSERT INTO sig_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Doŋ nɛ Yesu basɩ tɩya ba a baa, “Ŋ kɩdiiliye rɛ yaa dɩ ŋ yaa nal hʋ aa tɩma ŋ kyɛrɩ, a teŋ tʋma hʋ ʋ aa tɩya ŋ dɩ ŋ tʋma. ");
INSERT INTO sig_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma aa baa dɩ ʋ kaa peŋsi banaa rɛ, ka dɩ ma na kʋŋ ma bagɩsɩ kɩna pɛ dɔmɔŋ. Amɛ ŋ basɩ kɩ tɩya ma rɛ, ma deŋ bagɩsɩ hʋ na, kɩna hʋ buloŋ yaa kʋmɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nal hʋ buloŋ aa kʋŋ baga hʋ kɩna kɩ pɛ dɔmɔŋ ʋ tɩɩna kaŋ ʋ tuno rɛ. Ʋ kʋŋ kɩna no kɩ pɛ dɔmɔŋ nɛ dɩ ba na mɩɩbol aa bɩ kaŋ tenii. Ɛɛwɩya, nal hʋ aa doho abee nal hʋ aa kʋma, ba buloŋ tenni sɩ fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Namaga no ba aa basɩ kɔnɩ yaa wɩtɩɩ rɛ, nal aa doho rɛ, nal mɛ kʋma. ");
INSERT INTO sig_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ŋ tɩŋ ma rɛ dɩ ma mʋ kʋŋ kɩna baga hʋ tɩyaŋ ma aa bɩ tʋma. Nala badɔmɔŋ nɛ tʋma baga no tɩyaŋ, ka ma kɩ di ʋ tɔnɔ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaarɩya tɩmma gyɩ yʋga haŋ tɔɔ hʋ tɩyaŋ a ko laa Yesu wɩya di, akuu haaŋ hʋ aa baa dɩ Yesu basɩ ʋ mɩɩbol wɩkanɩya buloŋ wɩya tɩya ʋ wɩya. ");
INSERT INTO sig_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaarɩya tɩmma hʋ aa ko Yesu lee, ba gyɩ sʋla ʋ rɛ dɩ ʋ we ba lee. Yesu laa nyʋwa, a we doŋ kyɛyɛ balɩya. ");
INSERT INTO sig_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Doŋ tɩyaŋ nɛ nɩgyamaa bɩl marɩ laa ʋ wɩya di, akuu wɩya hʋ ʋ aa basɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɛɛ rɛ nala hʋ basɩ tɩya haaŋ hʋ a baa, “Lagɩlagɩ no kɛ, á laa ʋ wɩya di rɛ akuu á tɩɩ aa nɩɩ ʋ nyʋwa wɩya, ʋ bɩ kɩɩ nɩɩ wɩɩ hʋ ɩ aa basɩ tɩya ma rɛ tɩŋ. Nyɛ kɛ á tɩɩ gyɩma rɛ anɩɩ ʋ rɛ kɔnɩ yaa dʋnɩya nala Laataal.” ");
INSERT INTO sig_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu aa yaa kyɛyɛ balɩya doŋ, ʋ sii a bɩl mɩɩgɩ mʋ Galili paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu tɩɩ fa basɩ tɩya nala rɛ a baa, “Wɩɩsɩ tɩŋdaal buloŋ, ba aa bee tɩya ʋ gyɩrɩma ʋ tɩɩ bee tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu gyɩ aa ko pele Galili paalʋʋ, doŋ nala gyɩ kana ʋ weliŋ nɛ, beewɩya ba tɩɩ gyɩ naa wɩya hʋ buloŋ ʋ aa yaa rɛ saŋa hʋ ba gyɩ aa mʋʋ Gyerusalɛm dɩ ba di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ɛɛ rɛ Yesu bɩl mɩɩgɩ mʋ Keena aa we Galili paalʋʋ tɩyaŋ, lee hʋ ʋ gyɩ aa leŋ nɩɩ bɩrɩmɩ sɩŋ hʋ. Dɩ kerikyibal kɩdɩgɩ mɛ gyɩ we doŋ, ʋ biye gyɩ pɩŋ kɩ wɩɩlɩ tɔɔ kɩdɩgɩ ba aa yɩrɩ Kapɛɛnam tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ʋ aa nɩya anɩɩ Yesu lɩɩ Gyudɩya paalʋʋ a ko Galili paalʋʋ, ʋ mʋ sʋla ʋ dɩ ʋ mʋ Kapɛɛnam a tɩɩbɩ ʋ biye hʋ tɩya ʋ, dɩ biye hʋ aa kyɛ dɩ ʋ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ma kɩdɩgɩ buloŋ bɩ sɩ maakyiye laa ŋ di, see ma na dɩ ŋ yaa wɩmagɩla abee wɩkperiye.” ");
INSERT INTO sig_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɛɛ rɛ kerikyi hʋ basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, ko lagɩ dɩ gɛɛ daa, ŋ biye hʋ sɩ sʋba” ");
INSERT INTO sig_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Kɩ mʋ dɩya, ɩ biye hʋ deye rɛ.” Baal hʋ laa wɩɩ hʋ Yesu aa basɩ tɩya ʋ di, aŋ kpa kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ʋ aa mʋʋ hʋ tɩyaŋ nɛ, ʋ dɩya tʋŋtʋnnɩ ko kyeme ʋ, a basɩ tɩya ʋ anɩɩ biye hʋ deye rɛ. ");
INSERT INTO sig_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ʋ pɩyɛsɩ dɩ ʋ na saŋa hʋ tɩyaŋ biye hʋ aa deye. Ba basɩ tɩya ʋ anɩɩ dɩya wɩɩhaa, anɩɩ kerifi dɩgɩ saŋa rɛ wɩɩla hʋ leme ʋ. ");
INSERT INTO sig_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɛɛ rɛ biye hʋ kuwo liisi anɩɩ saŋa no tɩɩ tɩyaŋ nɛ Yesu dɩya basɩ tɩya ʋ anɩɩ ʋ biye sɩ deye. Ɛɛ rɛ ʋ bee ʋ dɩya nala buloŋ laa ʋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu aa lɩɩ Gyudɩya paalʋʋ ko Galili paalʋʋ, ʋ wɩmagɩl-lɩya tɩɩna rɛ nyɛ ʋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nyɛ hal tɩyaŋ nɛ Yesu bɩl sii mʋ Gyerusalɛm dɩ ʋ gbɩyalɩ Gyuuma wɩɩkyʋwal gbɩyala kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Gyerusalɛm tɩyaŋ, nɩɩbɩŋ kɩdɩgɩ rɛ fa we doŋ, a kpaga paga hʋ ba aa yɩrɩ Piyesi Paga. Hiiburu taal tɩyaŋ, ba fa kaŋ nɩɩbɩŋ no kɩ yɩrɩ Betizata rɛ. Ba gyɩ wee gyama bɔnɔŋ nɛ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wɩɩla tɩmma yʋga gyɩ aa mʋ kɩ pɩŋ gyama hʋ tɩyaŋ nɛ. Badɔmɔŋ gyɩ yaa nyʋlɩma rɛ, badɔmɔŋ mɛ yaa naasʋʋnɩ abee nosʋʋnɩ tɩmma, ka badɔmɔŋ mɛ yaa gbarɩga. (Ba fa aa hɔŋ kɩ gyegili nɩɩ hʋ rɛ dɩ ʋ dɔŋ.) ");
INSERT INTO sig_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Beewɩya saŋa kɩdɩgɩ malɩka fa aa ko tuu kaŋ nɩɩ hʋ vuugi rɛ. Dɩ ʋ ko kɩ vuugi nɩɩ hʋ, wɩɩla tɩɩna hʋ aa sɩ laa sɩya tuu nɩɩ hʋ tɩyaŋ, tɩɩna wɩɩla kyo dɩ ba kɩɩ gɛɛ buloŋ mɛ, ka ʋ aa deye rɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Baal kɩdɩgɩ mɛ rɛ fa we wɩɩla tɩmma hʋ tɩyaŋ, ʋ bɩsɩ mɔlɩya abee fi abee kyori rɛ nyɛ ʋ aa gbarɩga. ");
INSERT INTO sig_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu aa naa baal no dɩ ʋ pɩŋ doŋ, ʋ gyɩma anɩɩ ʋ wɩɩla hʋ pɩɩsa ʋ tɩyaŋ nɛ. Ɛɛ rɛ ʋ pɩyɛsɩ ʋ a baa, “Ɩ aa kyɛ dɩ ɩ deye rɛ?” ");
INSERT INTO sig_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɛɛ rɛ baal hʋ baa, “Nɩhɩyawʋ, ŋ bɩ kaŋ nal daha ʋ aa sɩ kpa ŋ tuu nɩɩ hʋ saŋa hʋ malɩka hʋ aa ko kaŋ nɩɩ hʋ kɩ vuugi. Ɛɛwɩya, ŋ aa kɩ lʋga dɩ ŋ tuu rɛ, dɩ nal teŋ laa sɩya tuu ŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ɛɛ rɛ Yesu basɩ tɩya baal hʋ a baa, “Sii, a kpa ɩ wasa kɩ mʋ.” ");
INSERT INTO sig_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nyɛ rɛ baal hʋ pirigi deye, a sii kpa ʋ wasa a kɩ mʋ. Kyɛwiyesii hʋ kyɛɛ rɛ wɩɩ no gyɩ yaa. ");
INSERT INTO sig_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɛɛ rɛ Gyuuma nɩhɩyasɩ hʋ basɩ tɩya baal hʋ Yesu aa tɩɩba a baa, “Gyɩnaŋ yaa Kyɛwiyesii hʋ kyɛɛ rɛ. Ʋ yaa sɩna rɛ dɩ ɩ kyʋŋ ɩ wasa gyɩnaŋ kyɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɛɛ rɛ baal hʋ mɛ baa, “Nal hʋ aa tɩɩbɩ ŋ nɛ basɩ tɩya ŋ dɩ ŋ sii kpa ŋ wasa a kɩ mʋ.” ");
INSERT INTO sig_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɛɛ rɛ ba pɩyɛsɩ ʋ abaa, “Aŋnɛ rɛ yaa baal no aa basɩ wɩɩ no tɩya ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amɛ baal hʋ gyɩ bɩ gyɩŋ nal hʋ aa tɩɩbɩ ʋ, beewɩya gyamaa hʋ gyɩ yʋga doŋ nɛ. Ɛɛ rɛ Yesu luuri tɩŋ nala hʋ tɩyaŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɛɛ hal tɩyaŋ nɛ, Yesu na baal hʋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ a basɩ tɩya ʋ a baa, “Nɩɩ daha, lagɩlagɩ no ɩ deye rɛ, ɛɛ wɩya, leŋ wɩbɔmɔ yayɩ. Dɩ gɛɛ daa, wɩɩ aa lɔrɔ te nyɛ sɩ puu ɩ.” ");
INSERT INTO sig_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɛɛ rɛ baal hʋ sii mʋ basɩ tɩya Gyuuma nɩhɩyasɩ hʋ anɩɩ Yesu rɛ fa tɩɩbɩ ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu aa tɩɩbɩ gbarɩgɩ hʋ Kyɛwiyesii hʋ kyɛɛ rɛ tɩŋ Gyuuma nɩhɩyasɩ kana ʋ yaa ba dɔŋ a kɩ kyɛ dɩ ba dɔgɩsɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Saŋa buloŋ nɛ ŋ kuwo aa kɩ tʋŋ tʋma. Ɛɛwɩya ʋ maga dɩ ŋ mɛ kɩ tʋŋ tʋma rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu aa basɩ gɛɛ hʋ rɛ marɩ leŋ Gyuuma nɩhɩyasɩ hʋ sɩɩ fɩyɛsɩ, ba kɩ kyɛ ŋmanɩɩ hʋ ba aa sɩ tɩŋa a kpʋ ʋ. Wɩya balɩya rɛ ba baa dɩ ʋ yaa kyogi: Ba baa dɩ ʋ kyogi ba Kyɛwiyesii hʋ kyɛɛ sɩna rɛ, aŋ ha bɩl baa dɩ Wɩɩsɩ rɛ yaa ʋ Kuwo. Ɛɛ daga anɩɩ ʋ bee Wɩɩsɩ maga dɔmɔŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ɛɛ rɛ Yesu basɩ tɩya nala hʋ aa baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, mɩyaŋ Wɩɩsɩ Biye bɩ wuwo kɩ yaa wɩɩ buloŋ ŋ tɩɩ dee tɩyaŋ. Wɩɩ hʋ ŋ aa naa ŋ kuwo aa yaa, ʋ rɛ ŋ mɛ kɩ yaa. Wɩɩ kɛ buloŋ ʋ aa yaa, ʋ rɛ mɩyaŋ Biye hʋ mɛ kɩ yaa, ");
INSERT INTO sig_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","beewɩya ŋ Kuwo kyo ŋ nɛ, a daga ŋ wɩya hʋ buloŋ ʋ tɩɩ aa yaa. Ʋ ha sɩ daga ŋ wɩya a te nyɛ dɩ ŋ yaa, dɩ ma buloŋ nyʋʋsɩ fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ŋ Kuwo aa kyisi nala hʋ aa sʋba ba bɩl kaŋ mɩɩbol gɛɛ, ɛɛ tɩɩ rɛ mɩyaŋ, ʋ Biye hʋ mɛ sɩ tɩya nala hʋ ŋ aa kyɛ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ŋ Kuwo kɛ bee di nal buloŋ sarɩya, amɛ ʋ tɩya ŋ ŋmanɩɩ rɛ dɩ ŋ di nal buloŋ sarɩya. ");
INSERT INTO sig_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ʋ yaa gɛɛ rɛ dɩ nal buloŋ kɩ kpa mɩyaŋ ʋ Biye hʋ yohuŋ, anɩɩ ba aa kpa ŋ Kuwo yohuŋ gɛɛ. Nal hʋ buloŋ aa bee kpa mɩyaŋ Wɩɩsɩ Biye hʋ yohuŋ, ʋ tɩɩna mɛ bee kpa ŋ Kuwo Wɩɩsɩ aa tɩma ŋ mɛ yohuŋ. ");
INSERT INTO sig_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa gyegile nɩɩ ŋ nyʋwa, a laa nal hʋ aa tɩma ŋ mɛ wɩya di, ʋ tɩɩna kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii rɛ. Ba bɩl bɩ sɩ di ʋ tɩɩna sarɩya, beewɩya ʋ tɩɩna foŋ lɩɩ sʋʋ tɩyaŋ nɛ a kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, saŋa hʋ sɩ pele, ʋ gba pele mɛ rɛ, dɩ nala hʋ aa bɩ gyɩŋ Wɩɩsɩ aŋ kɩɩ gɛɛ anɩɩ sʋʋnɩ nɩɩ mɩyaŋ Wɩɩsɩ Biye taal. Nala hʋ aa nɩɩ ŋ taal, a tɩŋ ŋ nyʋwa sɩ kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ŋ Kuwo aa kaŋ dee a kɩ tɩya nala mɩɩbol gɛɛ, ɛɛ tɩɩ rɛ ʋ leŋ mɩyaŋ ʋ Biye mɛ kaŋ dee a kɩ tɩya nala mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ʋ yaŋ tɩya mɩyaŋ ʋ Biye dee rɛ dɩ ŋ di nala sarɩya, beewɩya mɩyaŋ nɛ yaa Nihuwobiŋ Biye hʋ. ");
INSERT INTO sig_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma ta leŋ dɩ wɩɩ no yaa ma wɩkperii. Beewɩya saŋa hʋ sɩ ko dɩ nala hʋ buloŋ aa sʋba nɩɩ ŋ taal. ");
INSERT INTO sig_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ba yaŋ sɩ sii sʋʋ tɩyaŋ. Nala hʋ aa yaa wɩweliye sɩ sii a kaŋ mɩɩbol, dɩ nala hʋ aa yaa wɩbɔmɔ mɛ sii dɩ Wɩɩsɩ di ba sarɩya a kpa kyogisi tɩya ba.” ");
INSERT INTO sig_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ɛɛ rɛ Yesu bɩl baa, “Ŋ bɩ wuwo kɩ yaa wɩɩ buloŋ ŋ tɩɩ dee tɩyaŋ. Ŋ aa di nala sarɩya gɛɛ Wɩɩsɩ aa baa ŋ di rɛ. Ɛɛwɩya, ŋ aa di sarɩya hʋ rɛ abee wɩtɩɩ, beewɩya ŋ bee yaa ŋ tɩɩ wɩkyɛɛlɩɩ, amɛ nal hʋ aa tɩma ŋ, ʋ kyɛrɩ rɛ ŋ kɩ yaa. ");
INSERT INTO sig_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Dɩ ŋ dʋŋ nɛ basɩ ŋ tɩɩ wɩya, ʋ bɩ sɩ kaŋ yohuŋ. ");
INSERT INTO sig_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amɛ nal mɛ rɛ we doŋ a yaa ŋ daŋsɩya. Ŋ gyɩma anɩɩ ŋ wɩya hʋ ʋ aa basɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ma tɩŋ ma tɩŋdaala rɛ ba mʋ Gyɔɔŋ lee a pɩyɛsɩ ŋ wɩya, ʋ basɩ wɩtɩɩ hʋ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ʋ bɩ kɩɩ nɩɩ nal lɛ ŋ kɩ kyɛ dɩ ʋ ko basɩ wɩya a daga nal hʋ ŋ aa yaa, amɛ ŋ basɩ wɩɩ no rɛ, dɩ Wɩɩsɩ laa ma ta. ");
INSERT INTO sig_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wɩɩ hʋ Gyɔɔŋ gyɩ aa basa kɩɩ gɛɛ rɛ anɩɩ kyaanʋʋ a tɩya ma, ma fa kyo dɩ ma nɩɩ ʋ wɩbasɩɩ hʋ sʋma mʋ sɩya mʋhʋ, beewɩya wɩbasɩɩ no gyɩ fɩyɛlɩ ma teŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amɛ ŋ kaŋ daŋsɩya tɩɩna kɩdɩgɩ rɛ ʋ gba tee Gyɔɔŋ. Ʋ rɛ yaa wɩya hʋ ŋ aa yaa. Tʋma hʋ ŋ kuwo aa kpaa tɩya ŋ dɩ ŋ tʋma, ba aa rɛ daga anɩɩ ŋ kuwo rɛ tɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ŋ Kuwo hʋ aa tɩma ŋ, ʋ mɛ basɩ ŋ wɩya rɛ. Ma ha bɩ maakyiye nɩɩ ʋ taal, a ha bɩ maakyiye na ʋ abee ma sɩɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ʋ wɩya tuwo ma tɩsɩ tɩyaŋ, beewɩya ma bɩ laa mɩyaŋ nal hʋ ʋ aa tɩma wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ma aa fɩyɛsɩ sɩɩ rɛ a kɩ gʋnnɩ Wɩɩsɩ teŋ hʋ beewɩya ma liise anɩɩ ba tɩyaŋ nɛ ma sɩ na mɩɩbol hʋ aa bɩ kaŋ tenii. Ka Wɩɩsɩ teŋ no ma aa karɩmɩ, ŋ wɩya rɛ ʋ kɩ basɩ, ");
INSERT INTO sig_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ka ma vɩya ma aa sɩ ko ŋ lee a kaŋ mɩɩbol hʋ aa kaŋ tɔnɔ. ");
INSERT INTO sig_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nihuwobisi bigisii bɩ kaŋ tɔnɔ ŋ lee. ");
INSERT INTO sig_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ŋ gyɩŋ nala hʋ iriŋ ma aa yaa rɛ. Ŋ gyɩma anɩɩ ma tɩsɩ tɩyaŋ ma bɩ kyo Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ŋ Kuwo dee tɩyaŋ nɛ ŋ ko, ka ma vɩya ŋ. Amɛ dɩ nal kɩdɩgɩ rɛ ko ʋ tɩɩ dee tɩyaŋ, ʋ rɛ ma sɩ laa we. ");
INSERT INTO sig_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ma kyo dɔmɔŋ bigisii rɛ, amɛ ma bee kyɛ dɩ ma yaa wɩya hʋ aa sɩ leŋ dɩ Wɩɩsɩ dʋŋ bigisi ma. Ɛɛ rɛ ma yaŋ sɩ wuwo yaa a laa ŋ wɩya di? ");
INSERT INTO sig_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma yaŋ ta liise nɩɩ mɩyaŋ nɛ sɩ mʋ basɩ wɩya hʋ ma aa yaa kyogi a tɩya ŋ kuwo. Ma bayɩyɛla buloŋ we Moosi tɩyaŋ nɛ, amɛ ʋ rɛ yaŋ yaa nal hʋ aa sɩ mʋ basɩ wɩya hʋ ma aa kyogi tɩya ŋ kuwo. ");
INSERT INTO sig_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dɩ mamaa rɛ kɔnɩ fa laa Moosi wɩya di, ma fa sɩ laa ŋ wɩya mɛ di, beewɩya ŋ wɩya rɛ Moosi gyɩ sabɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amɛ dɩ mamaa rɛ bɩ laa wɩya hʋ ʋ aa saba biŋ a di, ɛɛ rɛ ma sɩ yaa a laa wɩya hʋ ŋ aa basɩ kɛ di?” ");
INSERT INTO sig_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɛɛ hal tɩyaŋ nɛ, Yesu bee ʋ hatɩnna hʋ gyɩ bɩl mɩɩgɩ kyol Galili fuwobal hʋ kyolo. (Fuwo no feŋ kɩdɩgɩ mɛ rɛ yaa Tibeeriya.) ");
INSERT INTO sig_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɩgyamaa gyɩ aa tɩŋa ʋ hal lɛ, beewɩya ba gyɩ naa gɛɛ hʋ ʋ aa yaa wɩmagɩla wɩɩla tɩmma tɩyaŋ nɛ ba deye. ");
INSERT INTO sig_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ mʋ gyɩŋ hɔŋ dogimo kɩdɩgɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saŋa no tɩyaŋ dɩ Gyuuma Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ mɛ gyɩ kpaga. ");
INSERT INTO sig_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ba aa hɔŋ doŋ hʋ tɩyaŋ nɛ, Yesu na dɩ nɩgyamaa aa ko ʋ lee. Ɛɛ rɛ ʋ pɩyɛsɩ Fɩlɩpɩ a baa, “Lee rɛ á sɩ na kɩdiiliye a yɔbɔ tɩya nala no buloŋ dɩ ba di vɔgɔ?” ");
INSERT INTO sig_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu tɩɩ fa gyɩŋ wɩɩ hʋ ʋ aa sɩ yaa rɛ, amɛ ʋ gyɩ ta basɩ gɛɛ rɛ dɩ ʋ gyɩŋ Fɩlɩpɩ hakɩla. ");
INSERT INTO sig_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ɛɛ rɛ Fɩlɩpɩ basɩ tɩya ʋ a baa, “Dɩ nal lɛ paalɩ kpa ʋ peŋsi kyori tuno yɔbɔ kɩdiiliye tɩya nala no mɛ, ka ba bee pel ba.” ");
INSERT INTO sig_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ɛɛ rɛ ʋ hatɩnna hʋ kɩdɩgɩ ba aa yɩrɩ Aŋduru, a yaa Siimɔŋ Piita nɩɩnabiye mɛ basɩ tɩya Yesu a baa, ");
INSERT INTO sig_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Boyoŋbiye kɩdɩgɩ rɛ we daha, a kaŋ paanʋʋ gama bɔnɔŋ abee fuwonaŋhɩlɩya balɩya. Amɛ kɩna no ka ta bɩ sɩ wuwo yaa nala no wɩɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ɛɛ rɛ Yesu baa, “Ma leŋ dɩ nala hʋ tuu hɔŋ”. (Na dɩ ɔhɔ mɛ tɔsɔ lee hʋ tɩyaŋ weliŋ.) Ɛɛ rɛ ba leŋ nala hʋ buloŋ tuu hɔŋ ɔfɩyɛl hʋ tɩyaŋ. Nala hʋ tɩyaŋ baala dʋŋ gyɩ yaa anɩɩ tusibɔnɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ɛɛ rɛ Yesu laa paanʋʋ hʋ, a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ, aŋ leŋ ba kaŋ kpaa nala hʋ. Ɛɛ rɛ ka ʋ bɩl laa fuwonaŋhɩlɩya hʋ balɩya mɛ a kyʋwalɩ Wɩɩsɩ aŋgyʋwasʋ aŋ leŋ ba kaŋ kpaa ba, ba kɩdɩgɩ buloŋ di a vɔgɔ. ");
INSERT INTO sig_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba aa dii a vɔgɔ gɛɛ, ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma mʋ paa kɩna hʋ buloŋ aa kaa, dɩ ba mʋhʋ mɛ ta taa.” ");
INSERT INTO sig_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɛɛ rɛ ba paa kɩkaalɩya hʋ a su simbiisi fi abee balɩya. ");
INSERT INTO sig_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nala hʋ aa we doŋ a na Yesu aa yaa wɩmagɩl no, ɛɛ rɛ ba baa, “Wɩtɩɩ rɛ, baal no rɛ kɔnɩ yaa Wɩɩsɩ Tɩŋdaal hʋ wɩya ba aa saba we Wɩɩsɩ Teŋ tɩyaŋ anɩɩ ʋ sɩ ko dʋnɩya hʋ.” ");
INSERT INTO sig_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu gyɩma anɩɩ ba aa kyɛ dɩ ba ko fɩla ʋ rɛ dɩ ʋ yaa ba kuwori, ɛɛ rɛ ʋ dʋŋ bɩl sii dogimo hʋ nyuu tɩyaŋ a fasɩ mʋ sɩya mʋhʋ. ");
INSERT INTO sig_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ʋ dɩdaana aa ko pele, Yesu hatɩnna hʋ tuu fuwo hʋ nyʋwa, ");
INSERT INTO sig_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a gyʋʋ nɩɩduworiboro, a bɩl duwori kɩ mʋ Kapɛɛnam aa we fuwo hʋ kyolo tɩyaŋ. Ɛɛ rɛ lee mʋ bɩl, ka Yesu ha bɩ ko ba lee. ");
INSERT INTO sig_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saŋa no tɩyaŋ dɩ puwoduwo kɩdɩgɩ mɛ luro, a kaŋ nɩɩ hʋ buloŋ kɩ yeŋŋi. ");
INSERT INTO sig_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ʋ hatɩnna hʋ gyɩ duwori mʋ anɩɩ meeldaasɩ boto koo banaa rɛ, dɩ ba naa Yesu dɩ ʋ mʋʋ vala nɩɩ hʋ nyuu tɩyaŋ a kɩ ko nɩɩduworiboro hʋ lee. Ba aa naa gɛɛ, kambɩŋ kaŋ ba. ");
INSERT INTO sig_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ta leŋ dɩ kambɩŋ kaŋ ma. Mɩyaŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɛɛ rɛ ba leŋ ʋ gyʋʋ nɩɩduworiboro hʋ. Haŋ lagɩlagɩbiye hʋ dɩ nɩɩduworiboro hʋ teŋ pele lee hʋ ba fa aa mʋʋ nɩɩnyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ʋ sɩgballɩya, gyamaa hʋ ha fa we fuwo hʋ kyolo, lee hʋ Yesu aa yaa wɩmagɩl hʋ tɩyaŋ. Ba gyɩ gyɩma anɩɩ nɩɩduworiboridɩgɩ dʋŋ nɛ fa we doŋ. Ba gyɩma anɩɩ Yesu hatɩnna hʋ dʋŋ nɛ gyʋʋ nɩɩduworiboridɩgɩ hʋ mʋ. Yesu gyɩ tuwo ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɩɩduworiborisi badɔmɔŋ mɛ rɛ gyɩ lɩɩ Tibeeriya ko sɩŋ fuwo hʋ kyolo a kpaga lee hʋ Yesu gyɩ aa kpaa paanʋʋ hʋ a kyʋwalɩ Wɩɩsɩ aŋ kpa tɩya ba ba di hʋ. ");
INSERT INTO sig_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gyamaa no aa kyɛɛ Yesu bee ʋ hatɩnna hʋ buloŋ lɔlɔ doŋ tɩyaŋ gɛɛ, ɛɛ rɛ ba gyʋʋ nɩɩduworiborisi hʋ a mʋ Kapɛɛnam, a kɩ kyɛ Yesu doŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nala hʋ aa naa Yesu Kapɛɛnam tɩyaŋ, ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, saŋa bee rɛ ɩ teŋ pel daha.” ");
INSERT INTO sig_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, paanʋʋ hʋ ma aa kyaŋ vɔgɔ wɩya rɛ ma gɔllɩ kɩ kyɛ ŋ, ʋ bɩ kɩɩ nɩɩ ma aa gyɩŋ wɩmagɩla hʋ ŋ aa yaa memii wɩya rɛ tɩŋ, ma kɩ kyɛ ŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma ta kɩ kyɛɛ kɩdiiliye hʋ aa sɩ kyogi dʋŋ, amɛ ma lʋga kɩ kyɛ kɩdiiliye hʋ aa sɩ tɩya ma mɩɩbol hʋ aa bɩ kaŋ tenii. Kɩdiiliye no rɛ mɩyaŋ Nihuwobiŋ Biye sɩ tɩya ma, beewɩya ŋ Kuwo Wɩɩsɩ kpaa ɛɛ dee tɩya ŋ nɛ. Ŋ kuwo Wɩɩsɩ we ŋ lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ á sɩ yaa a wuwo yaa wɩya hʋ Wɩɩsɩ aa kyɛ dɩ á yaa?” ");
INSERT INTO sig_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ɛɛ rɛ ʋ baa, “Wɩya hʋ Wɩɩsɩ aa kyɛ dɩ ma kɩ yaa rɛ nyɛ: Ma laa nal hʋ Wɩɩsɩ aa tɩma di.” ");
INSERT INTO sig_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɛɛ rɛ ba bɩl pɩyɛsɩ ʋ a baa, “Wɩmagɩl bee rɛ ɩ sɩ yaa dɩ á na a laa ɩ di? Bee rɛ ɩ sɩ yaa? ");
INSERT INTO sig_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na á naabaala dii kɩdiiliye hʋ ba aa yɩrɩ Mana rɛ pogo tɩyaŋ, anɩɩ ba aa saba gɛɛ Wɩɩsɩ teŋ tɩyaŋ a baa, ‘Ʋ kpaa kɩdiiliye hʋ aa lɩɩ wɩɩsɩbee rɛ a tɩya ba, ba di.”’ ");
INSERT INTO sig_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɛɛ rɛ Yesu baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, Moosi daa gyɩ tɩya ma kɩdiiliye hʋ aa lɩɩ wɩɩsɩbee ko tuu. Amɛ ŋ kuwo Wɩɩsɩ rɛ aa tɩya ma kɩditɩɩma hʋ aa lɩɩ wɩɩsɩbee. ");
INSERT INTO sig_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mɩyaŋ nal hʋ aa lɩɩ wɩɩsɩbee ko tuu a kɩ tɩya dʋnɩya nala mɩɩbol, mɩyaŋ nɛ yaa haŋ kɩdiiliye hʋ Wɩɩsɩ aa tɩya.” ");
INSERT INTO sig_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɛɛ rɛ ba baa, “Nɩhɩyawʋ, ɛɛ kɛ, kɩ tɩya ma kɩdiiliye no saŋa buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Mɩyaŋ nɛ yaa kɩdiiliye hʋ aa tɩya nala mɩɩbol. Nal hʋ buloŋ aa ko ŋ lee, losi bɩl bɩ sɩ kaŋ ʋ tɩɩna. Nal hʋ mɛ aa laa ŋ wɩya di, nɩɩnyʋwasɩ mɛ bɩl bɩ sɩ maakyiye kana ʋ. ");
INSERT INTO sig_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ŋ basɩ tɩya ma rɛ anɩɩ ma naa ŋ nɛ, amɛ ma bɩ laa ŋ di. ");
INSERT INTO sig_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nal hʋ buloŋ ŋ Kuwo aa kpaa we ŋ nosi tɩyaŋ, ʋ sɩ ko tɩŋa ŋ. Nal hʋ mɛ buloŋ aa ko ŋ lee, ŋ bɩ sɩ maakyiye kile ʋ ta, ");
INSERT INTO sig_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","beewɩya ŋ lɩɩ wɩɩsɩbee ko tuu dɩ ŋ tɩŋ nal hʋ aa tɩma ŋ kyɛrɩ rɛ, ŋ tɩɩ kyɛrɩ daa ŋ ko dɩ ŋ tɩŋa. ");
INSERT INTO sig_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nal hʋ aa tɩma ŋ kyɛrɩ rɛ yaa dɩ ŋ ta leŋ dɩ nala hʋ ʋ aa kpaa we ŋ nosi tɩyaŋ kɩdɩgɩ buloŋ ko nyʋgɩsɩ, amɛ dɩ ŋ kyisi ba buloŋ dʋnɩya kyɛtenii, dɩ ba kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wɩɩ hʋ ŋ Kuwo aa kyɛɛ rɛ nyɛ: Dɩ nal hʋ buloŋ aa gyɩma ŋ anɩɩ ŋ yaa Wɩɩsɩ biye rɛ, a laa ŋ wɩya di, dɩ ʋ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii, ka dɩ dʋnɩya kyɛtenii mɛ, dɩ ŋ kyisi ʋ sʋʋ tɩyaŋ dɩ ʋ kaŋ mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ɛɛ rɛ Gyuuma hʋ piili kɩ gʋrɩmɩ wɩya akuu ʋ aa baa, “Mɩyaŋ nɛ yaa kɩdiiliye hʋ aa lɩɩ wɩɩsɩbee ko tuu.” ");
INSERT INTO sig_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Doŋ nɛ ba baa, “Baal no daa yaa Gyosɛfʋ biye Yesu? Á gyɩŋ ʋ kuwo abee ʋ naa buloŋ nɛ. Ɛɛ rɛ yaŋ lagɩlagɩ no, ʋ baa dɩ ʋ lɩɩ wɩɩsɩbee rɛ a ko tuu?” ");
INSERT INTO sig_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Ma leŋ wɩya gʋrɩmɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nal buloŋ bɩ sɩ wuwo ko tɩŋa ŋ see dɩ ŋ Kuwo hʋ aa tɩma ŋ kaŋ ʋ tɩɩna kaŋ ko ŋ lee, ka dɩ ŋ kyisi ʋ tɩɩna sʋʋ tɩyaŋ dʋnɩya kyɛtenii dɩ ʋ kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ sabɩ nyɛ rɛ Wɩɩsɩ teŋ tɩyaŋ, a baa, “Wɩɩsɩ sɩ daga nala buloŋ”. Nal hʋ buloŋ aa gyegile nɩɩ wɩya hʋ Wɩɩsɩ aa daga ʋ, a gʋnnɩ wɩya ʋ lee, ʋ rɛ sɩ ko kɩ tɩŋa ŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nyɛ bɩ daga anɩɩ nal kɩdɩgɩ buloŋ naa ŋ Kuwo Wɩɩsɩ rɛ, dɩ mɩyaŋ aa lɩɩ Wɩɩsɩ lee dʋŋ daa. ");
INSERT INTO sig_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa laa ŋ wɩya di, ʋ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɩyaŋ nɛ yaa kɩdiiliye hʋ aa tɩya nala mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ma naabaala gyɩ dii kɩdiiliye hʋ ba aa yɩrɩ Mana rɛ pogo hʋ tɩyaŋ. Abee gɛɛ buloŋ, ba ha gyɩ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amɛ kɩdiiliye hʋ aa lɩɩ wɩɩsɩbee ko tuu, dɩ nal lɛ dii ba, ʋ bɩ sɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɩyaŋ nɛ yaa kɩdiiliye hʋ aa tɩya mɩɩbol, a lɩɩ wɩɩsɩbee ko tuu. Dɩ nal lɛ dii kɩdiiliye no, ʋ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. Ŋ teŋbii rɛ yaa kɩdiiliye hʋ ŋ aa sɩ kpa tɩya dʋnɩya nala dɩ ba kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu aa basɩ gɛɛ, Gyuuma hʋ piili kaŋ wɩɩ hʋ kɩ kpa dɔmɔŋ abee baaŋ a baa, “Ɛɛ rɛ baal no sɩ yaa kpa ʋ teŋ namɩya tɩya ma dɩ á kyaŋ?” ");
INSERT INTO sig_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ mamaa rɛ bɩ kyaŋ mɩyaŋ Nihuwobiŋ Biye teŋ namɩya, a nyʋwa ŋ kyal mɛ, ma bɩ sɩ kaŋ mɩɩbol hʋ aa kaŋ tɔnɔ. ");
INSERT INTO sig_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nal hʋ buloŋ aa kyaŋ ŋ teŋ namɩya, a nyʋwa ŋ kyal mɛ, ʋ tɩɩna sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. Dʋnɩya kyɛtenii hʋ mɛ, ŋ sɩ kyisi ʋ tɩɩna sʋʋ tɩyaŋ, dɩ ʋ kaŋ mɩɩbol, ");
INSERT INTO sig_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","beewɩya ŋ teŋ namɩya yaa kɩditɩɩma rɛ, ŋ kyal mɛ yaa kɩnyʋwatɩɩma. ");
INSERT INTO sig_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nal hʋ buloŋ aa kyaŋ ŋ teŋ namɩya, a nyʋwa ŋ kyal mɛ, ʋ tɩɩna sɩ we ŋ lee a kaŋ kɩ mʋ deŋdeŋ, dɩ ŋ mɛ we ʋ tɩɩna lee a kaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ŋ Kuwo aa yaa mɩɩbol buloŋ tɩɩna rɛ tɩma ŋ, ʋ nyubaanɩŋ nɛ ŋ kaŋ mɩɩbol. Ɛɛ wɩya dɩ nal buloŋ mɛ rɛ kyaŋ ŋ teŋ namɩya, ŋ mɛ sɩ leŋ dɩ ʋ tɩɩna kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kɩdiiliye hʋ aa lɩɩ wɩɩsɩbee ko tuu rɛ nyɛ, ʋ bɩ kɩɩ kɩdiiliye hʋ ma naabaala gyɩ aa dii aŋ ha sʋba hʋ. Nal hʋ buloŋ aa dii kɩdiiliye no, ʋ sɩ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii.” ");
INSERT INTO sig_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu gyɩ aa basɩ wɩya no dɩ ʋ we Kapɛɛnam tɩyaŋ nɛ a kɩ daga nala Gyuuma wɩɩkyʋwaldɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nala hʋ gyɩ aa tɩŋ Yesu hal aa nɩɩ wɩya no ʋ aa basa, ba gyeniŋ buloŋ baa, “Wɩya no ʋ aa dagɩ deye rɛ kɩŋkaŋ. Kɩbee rɛ sɩ wuwo tɩŋ ba?” ");
INSERT INTO sig_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nal buloŋ gyɩ bɩ basɩ wɩɩ tɩya Yesu ka ʋ gyɩma anɩɩ ʋ hatɩnna hʋ aa gʋrɩmɩ wɩya rɛ, akuu wɩya hʋ ʋ aa basɩ tɩya ba wɩya. Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Wɩya no leŋ ma kɩ kyɛ ma bɩla hal lɛ koo? ");
INSERT INTO sig_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka dɩ mamaa rɛ yaŋ fa naa mɩyaŋ Nihuwobiŋ Biye dɩ ŋ mɩɩgɩ gyɩŋ kɩ mʋ lee hʋ ŋ aa lɩya, ɛɛ rɛ ma sɩ yaa? ");
INSERT INTO sig_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wɩɩsɩ Wiyesi Welii hʋ rɛ aa tɩya ma mɩɩbol hʋ aa bɩ kaŋ tenii. Nihuwobiŋ dee bɩ kaŋ tɔnɔ buloŋ, beewɩya ʋ bɩ sɩ wuwo tɩya mɩɩbol. Wɩya no ŋ aa basɩ tɩya ma, ba aa rɛ aa leŋ Wɩɩsɩ Wiyesi Welii hʋ aa tɩya mɩɩbol ko gyʋʋ ma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Abee gɛɛ buloŋ ma badɔmɔŋ ha bɩ laa ŋ wɩya di.” A lɩɩ saŋa hʋ Yesu aa piile kɩ daga nala buloŋ ʋ gyɩ gyɩŋ nala hʋ aa bɩ laa ʋ wɩya di rɛ, abee nal hʋ aa sɩ kpa ʋ yallɩ. ");
INSERT INTO sig_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɛɛ rɛ Yesu bɩl baa, “Wɩɩ no wɩya rɛ tɩŋ ŋ basɩ tɩya ma anɩɩ nal buloŋ bɩ sɩ wuwo ko tɩŋa ŋ, dɩ ŋ Kuwo bɩ tɩya ʋ tɩɩna ŋmanɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Akuu wɩɩ no wɩya, nɩgyamaa hʋ gyɩ aa tɩŋa ʋ tɩyaŋ yʋga gyɩ bɩla hal lɛ. ");
INSERT INTO sig_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ hatɩnna fi abee balɩya hʋ a baa, “Aŋka ma mɛ, ma mɛ aa kyɛ dɩ ma mɩɩgɩ ŋ hal lɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ɛɛ rɛ Siimɔŋ Piita baa, “Á Tɩɩna, kɩbee lee rɛ á mɛ sɩ mɩɩgɩ mʋ? Ɩ dʋŋ nɛ kaŋ wɩya hʋ aa tɩya nala mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nyɛ kɛ á gyɩma rɛ, a laa di mɛ anɩɩ ɩ rɛ yaa Tɩpʋlʋŋ Tɩɩna hʋ aa lɩɩ Wɩɩsɩ lee.” ");
INSERT INTO sig_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Na Mɩyaŋ nɛ lɩɩ ma nala no fi abee balɩya, amɛ ma kɩdɩgɩ yaa Sɩtaanɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gyudasɩ, Siimɔŋ Isɩkarɔtɩ biibaal hʋ wɩya rɛ ʋ gyɩ basɩ gɛɛ. Gyudasɩ gyɩ yaa Yesu hatɩnna fi abee balɩya hʋ kɩdɩgɩ rɛ, amɛ ʋ rɛ gyɩ sɩ ko kpa Yesu yallɩ. ");
INSERT INTO sig_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu aa basɩ wɩya no buloŋ ko teŋ, ʋ gyɩ sii mʋ we Galili paalʋʋ tɩyaŋ nɛ a kɩ gɔllɩ. Ʋ gyɩ bee kyɛ dɩ ʋ mʋ kɩ gɔllɩ Gyudɩya paalʋʋ tɩyaŋ, beewɩya Gyuuma nɩhɩyasɩ hʋ aa we doŋ fa aa kyɛ ŋmanɩɩ hʋ ba aa sɩ tɩŋa rɛ a wuwo kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Saŋa no tɩyaŋ dɩ Gyuuma kyɛbal hʋ ba aa yɩrɩ Gyama Kyɛbal mɛ kpaga. ");
INSERT INTO sig_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɛɛ rɛ Yesu nɩmmabalɩya basɩ tɩya ʋ a baa, “Lɩɩ daha, a mʋ Gyudɩya paalʋʋ, dɩ ɩ hatɩnna na wɩmagɩla hʋ ɩ aa yaa.” ");
INSERT INTO sig_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Beewɩya nal hʋ buloŋ aa kyɛ dɩ ba gyɩma ʋ, ʋ bɩ faŋa kɩ yaa wɩya. Ɛɛwɩya, wɩya no ɩ aa yaa nyɛ, leŋ dɩ dʋnɩya nala buloŋ gyɩma ɩ. ");
INSERT INTO sig_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ʋ naabalɩya hʋ tɩɩ mɛ gyɩ bɩ laa ʋ wɩya di, ɛɛ rɛ tɩŋ ba basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Saŋa hʋ ŋ aa sɩ mʋ doŋ ha bɩ pele. Amɛ ma kɛ aa wuwo ma mʋ doŋ nɛ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dʋnɩya nala bɩ haasɩ ma, amɛ ba haasɩ ŋ kɛ rɛ, beewɩya, saŋa buloŋ nɛ ŋ basɩ kɩ tɩya ba anɩɩ ba wɩyaalɩya lɔrɔ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ma lɩɩ mʋ gbɩyala hʋ, amɛ ŋ kɛ ha bee mʋ, beewɩya saŋa hʋ aa sɩ pele dɩ ŋ mʋ gbɩyala hʋ ha bɩ pele.” ");
INSERT INTO sig_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ʋ basɩ gɛɛ rɛ aŋ ha hɔŋ Galili paalʋʋ tɩyaŋ kyɛyɛ baŋmana. ");
INSERT INTO sig_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu nɩmmabalɩya hʋ aa mʋʋ gbɩyala hʋ ko teŋ, ɛɛ rɛ ʋ dʋŋ mɛ sii mʋ, dɩ nal buloŋ bɩ gyɩma ʋ wɩya doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gyuuma nɩhɩyasɩ hʋ aa we gbɩyala hʋ tɩyaŋ gyɩ deŋ kɩ kyɛ Yesu rɛ doŋ tɩyaŋ, a kɩ pɩyɛsɩ nala a baa, “Lee rɛ ʋ we?” ");
INSERT INTO sig_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɛɛ rɛ nala hʋ aa we gbɩyala hʋ lee gyeniŋ piili a miŋsi a kɩ basɩ Yesu wɩya. Badɔmɔŋ baa, “Ʋ yaa niwelii rɛ.” Badɔmɔŋ mɛ baa, “Aayɩ, ʋ aa mʋrɩ nala rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amɛ ba buloŋ fa aa fá Gyuuma nɩhɩyasɩ hʋ rɛ, ɛɛ rɛ tɩŋ ba faŋa kɩ basɩ ʋ wɩya gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gbɩyala hʋ aa ko mʋ gyʋʋ tʋtʋʋ, ɛɛ rɛ Yesu mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ a piili kɩ daga nala. ");
INSERT INTO sig_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ʋ aa daga nala hʋ gɛɛ, ʋ yaa Gyuuma nɩhɩyasɩ hʋ aa gyegile kɩ nɩɩ wɩya hʋ nyʋʋfɩyɛlɩ. Doŋ nɛ ba baa, “Ɛɛ rɛ baal no yaa gyɩŋ Gyuuma mɩrɩsɩ kɩŋkaŋ nyɛ, aŋ bɩ gʋnna ba nal buloŋ lee?” ");
INSERT INTO sig_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩya no ŋ aa dagɩ lɩɩ Wɩɩsɩ lee rɛ, ŋ lee daa ba lɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nal hʋ buloŋ aa yaa siri dɩ ʋ yaa wɩɩ hʋ Wɩɩsɩ aa kyo, ʋ tɩɩna sɩ gyɩma dɩ wɩya hʋ ŋ aa dagɩ lɩɩ Wɩɩsɩ lee rɛ koo ŋ tɩɩ lee rɛ ba lɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nal hʋ aa basɩ wɩya ʋ tɩɩ dee tɩyaŋ, ʋ aa basɩ kɩ kyɛ ʋ tɩɩ feŋ nɛ. Amɛ nal hʋ aa kyɛ dɩ nal hʋ aa tɩma ʋ feŋ gyɩŋ, ʋ yaa nɩtɩɩ rɛ, a bee nyɩya wɩya mɛ. ");
INSERT INTO sig_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na Moosi biŋ mɩrɩsɩ tɩya ma rɛ dɩ ma kɩ tɩŋa. Amɛ ma kɩdɩgɩ buloŋ bee tɩŋ mɩrɩsɩ no. Bee rɛ yaŋ tɩŋ ma kɩ lʋga dɩ ma kpʋ ŋ?” ");
INSERT INTO sig_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɛɛ rɛ gyamaa hʋ aa we doŋ pɩyɛsɩ ʋ a baa, “Na ʋ kɩɩ gyɩŋbɔmɔ rɛ kana ɩ? Kɩbee rɛ aa kyɛ dɩ ʋ kpʋ ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ yaa wɩmagɩl kɩdɩgɩ rɛ ma Kyɛwiyesii hʋ kyɛɛ, ʋ yaa ma wɩkperii. ");
INSERT INTO sig_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Amɛ akuu Moosi aa basɩ tɩya ma a baa ma kɩ keri ma biisi pene wɩya, ma aa kɩ keri ma biisi pene rɛ kyɛwiyesii hʋ kyɛɛ. Moosi daa piili wɩɩ no, ma naabaala rɛ piili ʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dɩ mamaa rɛ yaŋ sɩ wuwo keri biye peŋ kyɛwiyesii hʋ kyɛɛ akuu ma aa bee kyɛ dɩ ma kyogi Moosi mɩrɩsɩ hʋ wɩya, bee rɛ yaŋ sɩ tɩŋ ma kɩ na baaŋ ŋ nyuu tɩyaŋ akuu ŋ aa tɩɩbɩ nal kyɛwiyesii hʋ kyɛɛ wɩya. ");
INSERT INTO sig_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dɩ nal lɛ yaa wɩɩ, ma ta pese kpa kyogisi tɩya ʋ. Ma bɩɩnɩ wɩɩ hʋ ʋ aa yaa weliŋ na a gyɩŋ ʋ wɩtɩɩ, aŋ na kpa kyogisi tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɛɛ rɛ nala badɔmɔŋ mɛ aa lɩɩ Gyerusalɛm pɩyɛsɩ a baa, “Baal no daa á bee nɩhɩyasɩ kɩ kyɛ dɩ ba kpʋ gɛɛ? ");
INSERT INTO sig_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na, ʋ rɛ yaŋ sɩŋ nala tɩyaŋ gɛɛ a kɩ basɩ wɩya, ka nal buloŋ bɩ wuwo basɩ wɩɩ buloŋ, koo nyɛ kɛ Gyuuma nɩhɩyasɩ hʋ laa di rɛ anɩɩ ʋ rɛ yaa Krisita hʋ? ");
INSERT INTO sig_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nal buloŋ bɩ sɩ gyɩŋ lee hʋ Krisita hʋ aa lɩya, amɛ á buloŋ nɛ gyɩŋ lee hʋ baal no aa lɩya.” ");
INSERT INTO sig_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu aa daga nala Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ gɛɛ, ɛɛ rɛ ʋ pɩyɛsɩ a baa, “Na ma kɔnɩ gyɩma ŋ nɛ, a gyɩŋ lee hʋ ŋ aa lɩya mɛ? Amɛ ŋ tɩɩ dee tɩyaŋ daa ŋ ko. Nal lɛ tɩma ŋ. Nal hʋ mɛ yaŋ aa tɩma ŋ, ʋ yaa Wɩtɩɩ Tɩɩna rɛ. Ma bɩ gyɩma ʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amɛ ŋ kɛ gyɩma ʋ rɛ, beewɩya ʋ lee rɛ ŋ lɩɩ, ʋ rɛ tɩma ŋ.” ");
INSERT INTO sig_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɛɛ rɛ ba kɩ kyɛ dɩ ba kana ʋ, amɛ saŋa hʋ ba aa sɩ kana ʋ ha gyɩ bɩ pele. Ɛɛwɩya nal buloŋ bɩ wuwo kpa noŋ dige ʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amɛ nɩgyamaa gyɩ laa ʋ wɩya di rɛ nala hʋ tɩyaŋ aŋ baa, “Ma bɩɩna anɩɩ dɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya rɛ ko, ʋ sɩ yaa wɩmagɩla te baal no?” ");
INSERT INTO sig_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasiima hʋ badɔmɔŋ aa nɩya dɩ nala miŋse kɩ basɩ Yesu wɩya gɛɛ, ɛɛ rɛ ba bee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ tɩŋ ba laalyuwolo hʋ aa sɩŋ kɩ pɔ Wɩɩkyʋwaldɩɩbal hʋ dimbee dɩ ba mʋ kaŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ɛɛ rɛ Yesu basɩ baa, “Ŋ sɩ we ma lee kyɛyɛ baŋmana, aŋ mɩɩgɩ mʋ nal hʋ aa tɩma ŋ lee. ");
INSERT INTO sig_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma sɩ kyɛ ŋ, amɛ ma bɩ sɩ na ŋ, beewɩya lee hʋ ŋ aa sɩ we, ma bɩ sɩ wuwo mʋ doŋ.” ");
INSERT INTO sig_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ɛɛ rɛ Gyuuma nɩhɩyasɩ hʋ mɩɩgɩ kɩ pɩyɛsɩ dɔmɔŋ a baa, “Lee rɛ baal no kɩ kyɛ dɩ ʋ mʋ, dɩ á bɩl bɩ sɩ na ʋ. Kapuwo, ʋ aa kyɛ dɩ ʋ mʋ Giriki paalʋʋ hʋ tɩyaŋ Gyuuma aa guwoso rɛ, a kɩ daga nala hʋ aa bɩ yaa Gyuuma. Ba bɩl baa, ");
INSERT INTO sig_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Ʋ baa dɩ á sɩ kyɛ ʋ aŋ bɩ sɩ na ʋ, a bɩl baa dɩ á bɩl bɩ sɩ wuwo mʋ lee hʋ mɛ ʋ aa sɩ we. Wɩya no buloŋ ʋ aa basɩ, ba memii rɛ yaa bee?”’ ");
INSERT INTO sig_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gbɩyala hʋ kyɛtenii kyɛɛ rɛ aa yaa gbɩyala hʋ sɩfɩyaŋ kyɛɛ. Ɛɛ rɛ Yesu sii sɩŋ a heeli baa, “Nal hʋ buloŋ nɩɩnyʋwasɩ aa kana, ʋ tɩɩna ko ŋ lee a nyʋwa nɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wɩɩsɩ teŋ tɩyaŋ ba basa rɛ a baa, “Nal hʋ buloŋ aa laa ŋ wɩya di, Wɩɩsɩ wɩbii hʋ aa tɩya mɩɩbol sɩ bulo kɩ lɩɩ ʋ tɩɩna tɩya tɩyaŋ anɩɩ nɩɩ aa lɩɩ bulo tɩyaŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wɩɩsɩ Wiyesi Welii hʋ Yesu aa sɩ kpa we nala hʋ aa laa ʋ di tɩyaŋ wɩya rɛ ʋ kɩ basɩ gɛɛ. Saŋa no tɩyaŋ dɩ ʋ ha gyɩ bɩ kpaa Wiyesi Welii hʋ we ba tɩyaŋ, beewɩya ba ha gyɩ bɩ kpaasɩ ʋ mal daagarɩɩ hʋ nyuu tɩyaŋ dɩ ʋ laa feŋ. ");
INSERT INTO sig_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nɩgyamaa hʋ aa nɩɩ wɩya hʋ Yesu aa basa, ba badɔmɔŋ baa, “Baal no rɛ kɔnɩ yaa Wɩɩsɩ Tɩŋdaal hʋ a aa gyegili dɩ ʋ lɩɩ Wɩɩsɩ lee ko.” ");
INSERT INTO sig_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Badɔmɔŋ mɛ baa dɩ ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya. Amɛ badɔmɔŋ mɛ baa dɩ Krisita hʋ bɩ sɩ lɩɩ Galili paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wɩɩsɩ teŋ tɩyaŋ ba basa anɩɩ Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, sɩ yaa Deviti doho nal lɛ, a lɩɩ Bɛtɩlɛhɛm, lee hʋ Deviti aa lɩya. ");
INSERT INTO sig_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɛɛ rɛ nala hʋ kaŋ wɩɩ no kɩ kpa dɔmɔŋ, akuu Yesu wɩya porigi dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ba badɔmɔŋ kɩ kyɛ dɩ ba kaŋ Yesu, amɛ nal buloŋ bɩ wuwo kpa noŋ dige ʋ. ");
INSERT INTO sig_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɛɛ rɛ laalyuwolo hʋ ba aa tʋma dɩ ba mʋ kaŋ Yesu hʋ mɩɩgɩ mʋ Farasiima abee wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ lee abee nohɩllɩ. Ɛɛ rɛ ba pɩyɛsɩ ba a baa, “Bee rɛ tɩŋ ma bɩ kana ʋ ko?” ");
INSERT INTO sig_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɛɛ rɛ ba baa, “Nal buloŋ ha bɩ maakyiye basɩ wɩya anɩɩ baal no aa basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nyɛ rɛ Farasiima nɩhɩyasɩ hʋ pɩyɛsɩ ba a baa, “Na ʋ kɩɩ ʋ mʋrɩ ma mɛ rɛ? ");
INSERT INTO sig_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma ha maakyiye nɩɩ dɩ Gyuuma nɩhɩyasɩ koo Farasiima kɩdɩgɩ mɛ ha laa ʋ wɩya di? ");
INSERT INTO sig_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amɛ nɩgyamaa no buloŋ aa laŋŋa, kɩdɩgɩ buloŋ bɩ gyɩŋ wɩya hʋ Moosi aa saba biŋ. Ɛɛwɩya Wɩɩsɩ sɩ kʋsɩ ba nyuni.” ");
INSERT INTO sig_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Baal kɩdɩgɩ mɛ rɛ gyɩ we ba tɩyaŋ, ba kɩ yɩrɩ Nikodemu. Ʋ mɛ fa yaa Farasiima kɩdɩgɩ rɛ. Ʋ kɛ fa laa sɩya mʋ Yesu lee rɛ aŋ ka. ");
INSERT INTO sig_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Á mɩra bɩ daga dɩ á kpa kyogisi tɩya nal dɩ ʋ rɛ yaa wɩɩ, see dɩ á laa sɩya nɩɩ tɩɩna nyʋwa, a gyɩŋ wɩɩ hʋ ʋ aa yaa.” ");
INSERT INTO sig_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɛɛ rɛ Farasiima hʋ pɩyɛsɩ ʋ a baa, “Ɩ mɛ yaa Galili tɩɩna rɛ koo? Dɩ ɩ rɛ deŋ Wɩɩsɩ teŋ hʋ tɩyaŋ, ɩ sɩ na anɩɩ Wɩɩsɩ tɩŋdaala hʋ kɩdɩgɩ buloŋ bɩ maakyiye lɩɩ Galili.” ");
INSERT INTO sig_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ɛɛ rɛ ka ba buloŋ sii pɩsa, a mʋ ba dɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nala hʋ buloŋ aa mʋʋ ko teŋ, Yesu mɛ kpa mʋ gyɩŋ Olivi dogimo hʋ. ");
INSERT INTO sig_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ʋ sɩgballɩya kyɩkyʋwala, ʋ bɩl mɩɩgɩ mʋ a gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. Nyɛ rɛ nala hʋ buloŋ aa we doŋ ko gol-ʋ, ʋ hɔŋ, a bɩl piili kɩ daga ba. ");
INSERT INTO sig_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɛɛ rɛ Wɩɩsɩ teŋ dɩdagɩla abee Farasiima kaŋ haaŋ kɩdɩgɩ ko gyʋʋ. Ba kaŋ haaŋ no sɔŋsɔŋ tɩyaŋ nɛ. Nyɛ rɛ ba leŋ haaŋ hʋ sii sɩŋ ba buloŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɛɛ rɛ ba basɩ tɩya Yesu a baa, “Nɩhɩyawʋ, haaŋ no kaŋ bala rɛ, ka á kana ʋ dɩ ʋ bee badɩma pɩna. ");
INSERT INTO sig_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moosi mɩrɩsɩ hʋ daga anɩɩ dɩ haaŋ buloŋ nɛ ko yaa gɛɛ, dɩ á yaga ʋ tɩɩna kpʋ abee bʋwa. Ɛɛ rɛ ɩ mɛ na?” ");
INSERT INTO sig_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba basɩ gɛɛ dɩ ba ŋmaa Yesu fuu na rɛ, a wuwo na ŋmanɩɩ a kana ʋ anɩɩ ʋ kyogo rɛ. Ɛɛ rɛ Yesu kaŋ nyuu kyugili, aŋ kaŋ ʋ nonii kɩ sabɩ kɩna taŋha tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nyɛ rɛ ka ba ha sɩŋ, a kɩ pɩyɛsɩ ʋ wɩya. Doŋ tɩyaŋ nɛ Yesu kaŋ ʋ nyuu gye, a basɩ tɩya ba a baa, “Dɩ nal lɛ we ma tɩyaŋ daha a ha bɩ maakyiye yaa wɩbɔŋ, ma leŋ dɩ ʋ tɩɩna laa sɩya kpa bʋyɩ a yaga haaŋ no.” ");
INSERT INTO sig_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ɛɛ rɛ ʋ bɩl kaŋ ʋ nyuu kyugili a bɩl kaŋ ʋ nonii a kɩ sabɩ kɩna taŋha tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba aa nɩɩ wɩɩ hʋ ʋ aa basa, ba buloŋ mɩɩgɩ fá kɩŋ kɩŋ. Ba tɩyaŋ nɩhɩyasɩ rɛ gyɩ laa sɩya fá aŋ leŋ Yesu bee haaŋ hʋ dʋŋ gyamaa hʋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ɛɛ rɛ Yesu kaŋ ʋ nyuu gye, a pɩyɛsɩ haaŋ hʋ a baa, “Lee rɛ nala hʋ we? Ɛɛ kɛ nal buloŋ bɩ kaa ʋ aa sɩ kpa kyogisi tɩya ɩ a maga dɩ ba kpʋ ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nyɛ rɛ haaŋ hʋ baa dɩ nal buloŋ bɩl bɩ kaa. Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Tɔɔ, ŋ mɛ bɩ sɩ kpa kyogisi aa maga ba kpʋ ɩ a tɩya ɩ. Amɛ kɩ mʋ aŋ ta bɩl kɩ yaa wɩbɔmɔ.” ");
INSERT INTO sig_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nyɛ rɛ Yesu bɩl basɩ tɩya Farasiima hʋ a baa, “Mɩyaŋ nɛ yaa dʋnɩya nala pʋlʋŋ. Nal hʋ buloŋ aa tɩŋa ŋ, ʋ tɩɩna bɩ sɩ maakyiye vala bilhuu tɩyaŋ. Ʋ tɩɩna sɩ kaŋ pʋlʋŋ hʋ aa tɩya nala mɩɩbol.” ");
INSERT INTO sig_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ɛɛ rɛ Farasiima hʋ basɩ tɩya ʋ a baa, “Ɩ tɩɩ rɛ yaa ɩ tɩɩ daŋsɩya tɩɩna gɛɛ. Wɩya hʋ ɩ aa basɩ bɩ kaŋ tɔnɔ kɩdɩgɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ mɩyaŋ nɛ yaa ŋ tɩɩ daŋsɩya tɩɩna mɛ, wɩɩ hʋ ŋ aa basɩ yaa wɩtɩɩ rɛ, beewɩya ŋ gyɩŋ lee hʋ ŋ aa lɩya rɛ, a gyɩŋ lee hʋ mɛ ŋ aa mʋʋ. Amɛ ma kɛ bɩ gyɩŋ lee hʋ ŋ aa lɩya, a bɩ gyɩŋ lee hʋ mɛ ŋ aa mʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dʋnɩya nala hakɩla rɛ ma aa kpa kɩ di nala sarɩya a kpa kyogisi tɩya ba. Amɛ ŋ kɛ bɩ kpaa kyogisi kɩ tɩya nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dɩ mɩyaŋ nɛ kpaa kyogisi tɩya nal mɛ, ʋ yaa wɩtɩɩ rɛ, beewɩya ŋ dʋŋ daa kpaa kyogisi kɩ tɩya ʋ tɩɩna, amɛ nal hʋ aa tɩma ŋ pɛɛ ŋ tɩyaŋ nɛ wɩɩ no tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mɩrɩsɩ hʋ Moosi fa aa bine daga anɩɩ dɩ nala balɩya rɛ yaa wɩɩ daŋsɩya anɩɩ ʋ yaa wɩtɩɩ rɛ, ɛɛ daga anɩɩ wɩɩ hʋ kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ŋ yaa ŋ tɩɩ daŋsɩya tɩɩna rɛ, ŋ Kuwo hʋ aa tɩma ŋ mɛ yaa ŋ daŋsɩya tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Lee rɛ ɩ Kuwo hʋ we?” Ɛɛ rɛ Yesu baa, “Ma kɔnɩ bɩ gyɩma ŋ, a bɩ gyɩŋ ŋ Kuwo mɛ. Dɩ mamaa rɛ fa gyɩma ŋ, ma fa sɩ gyɩŋ ŋ Kuwo mɛ.” ");
INSERT INTO sig_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Saŋa hʋ Yesu aa basɩ wɩya no buloŋ kɩ tɩya nala Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ gɛɛ dɩ ʋ gyɩ yaŋ kpaga lee hʋ ba aa kpa wɩɩsʋlɩɩ gbaŋsɩ hʋ kɩ biŋ nɛ. Amɛ nal buloŋ gyɩ bɩ kana ʋ, beewɩya saŋa hʋ ba aa sɩ kana ʋ ha gyɩ bɩ pele. ");
INSERT INTO sig_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɛɛ rɛ Yesu bɩl basɩ tɩya nala hʋ a baa, “Ŋ sɩ mʋ. Ma sɩ pɩya sɩya kyɛ ŋ, amɛ ma sɩ sʋba ma wɩbɔmɔ tɩyaŋ. Lee hʋ ŋ aa mʋʋ, ma bɩ sɩ wuwo mʋ doŋ.” ");
INSERT INTO sig_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ɛɛ rɛ Gyuuma nɩhɩyasɩ hʋ pɩyɛsɩ dɔmɔŋ a baa, “Ʋ baa dɩ á bɩ sɩ wuwo mʋ lee hʋ ʋ aa mʋʋ. Ʋ yaŋ basa magɩsɩ anɩɩ ʋ sɩ kpʋ ʋ tɩɩ rɛ koo ɛɛ rɛ ʋ basɩ nyɛ?” ");
INSERT INTO sig_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Taŋhanyuu daha rɛ ma lɩɩ, amɛ ŋ kɛ lɩɩ wɩɩsɩbee rɛ. Ma yaa dʋnɩya no nala rɛ, amɛ ŋ kɛ bɩ lɩɩ dʋnɩya no. ");
INSERT INTO sig_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɛɛ rɛ tɩŋ ŋ gyɩ laa sɩya basɩ tɩya ma anɩɩ ma sɩ sʋba ma wɩbɔmɔ tɩyaŋ. Ma kɔnɩ yaŋ sɩ sʋba ma wɩbɔmɔ tɩyaŋ, dɩ ma ko bɩ laa di anɩɩ mɩyaŋ nɛ yaa nal hʋ ŋ aa baa ŋ yaa.” ");
INSERT INTO sig_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Aŋnɛ nɛ rɛ yaa ɩ?” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Piili hʋ tɩyaŋ buloŋ nɛ ŋ daga ma nal hʋ ŋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ŋ kaŋ wɩya yʋga rɛ ŋ aa sɩ wuwo tɩŋ ba tɩyaŋ a kpa kyogisi tɩya ma. Amɛ nal hʋ aa tɩma ŋ, ʋ kɔnɩ yaa Wɩtɩɩ Tɩɩna rɛ. Wɩya hʋ ŋ aa nɩya ʋ nyʋwa tɩyaŋ, ba dʋŋ nɛ ŋ basɩ kɩ tɩya dʋnɩya nala.” ");
INSERT INTO sig_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ʋ aa basɩ gɛɛ, nala hʋ ha fa bɩ gyɩma anɩɩ ʋ Kuwo Wɩɩsɩ wɩya rɛ ʋ basɩ tɩya ba gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ mamaa rɛ kaŋ mɩyaŋ Nihuwobiŋ Biye kpaasɩ mal daagarɩɩ tɩyaŋ, ma sɩ gyɩma anɩɩ mɩyaŋ nɛ yaa nal hʋ ŋ aa baa ŋ yaa. Ɛɛ mɛ tɩyaŋ nɛ ma sɩ tɩŋ gyɩma anɩɩ ŋ bee yaa wɩɩ buloŋ ŋ tɩɩ dee tɩyaŋ, amɛ wɩya hʋ ŋ Kuwo aa daga ŋ nɛ ŋ kɩ basɩ. ");
INSERT INTO sig_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nal hʋ mɛ aa tɩma ŋ ʋ bɩ vɩya ŋ ta, ʋ we ŋ lee rɛ, beewɩya saŋa buloŋ ŋ aa kɩ yaa wɩya hʋ aa fɩyɛlɩ ʋ teŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ʋ wɩbasɩɩ no gyɩ leŋ nala yʋga laa ʋ wɩya di rɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ɛɛ rɛ Yesu basɩ tɩya nala hʋ aa laa ʋ wɩya di a baa, “Dɩ mamaa rɛ gyegile kɩ nɩɩ ŋ nyʋwa, ma kɔnɩ yaa ŋ hatɩnna rɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma sɩ gyɩŋ Wɩɩsɩ wɩtɩɩ hʋ, dɩ wɩtɩɩ no leŋ dɩ ma tɩŋ ma tɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɛɛ rɛ nala hʋ mɛ baa, “Á yaa Abɩraham doho nala rɛ. Á ha bɩ maakyiye yaa nal buloŋ yosi. Bee rɛ yaŋ tɩŋ ɩ baa dɩ á sɩ tɩŋ á tɩɩ?” ");
INSERT INTO sig_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ kɛ buloŋ aa yaa wɩbɔmɔ, ʋ tɩɩna yaa wɩbɔmɔ yoŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dɩ yoŋ nɛ we nal dɩya tɩyaŋ, ʋ bɩ sɩ wuwo yaa dɩya hʋ doho nal tɩɩ. Amɛ dɩ dɩya hʋ tɩɩna rɛ kaŋ biye, biye hʋ kɛ aa yaa dɩya hʋ doho nal lɛ a kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dɩ mɩyaŋ Wɩɩsɩ Biye rɛ laa ma ta dɩ ma tɩŋ ma tɩɩ, ma kɔnɩ aa tɩŋ ma tɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋ gyɩma anɩɩ ma yaa Abɩraham doho nala rɛ, aŋka ma kɩ kyɛ dɩ ma kpʋ ŋ, beewɩya wɩya hʋ ŋ aa daga ma bɩ gyʋʋ ma dɩgɩna. ");
INSERT INTO sig_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wɩya hʋ ŋ kuwo aa daga ŋ nɛ ŋ kɩ basɩ, ka ma mɛ kɩ yaa wɩya hʋ ma kuwo aa daga ma dɩ ma kɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Abɩraham nɛ yaa á kuwo.” Ɛɛ rɛ Yesu mɛ baa, “Dɩ mamaa rɛ kɔnɩ fa yaa Abɩraham biisi, ɛɛ kɛ ma fa sɩ kɩ yaa wɩya hʋ Abɩraham fa aa yaa. ");
INSERT INTO sig_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ŋ kɛ sɩfɩyaŋ buloŋ nɛ yaa dɩ ŋ basɩ Wɩɩsɩ wɩtɩɩ hʋ ʋ aa kpaa tɩya ŋ dɩ ŋ basɩ tɩya ma, ka ma ha kɩ kyɛ dɩ ma kpʋ ŋ. Amɛ Abɩraham kɛ bɩ yaa nyɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ma aa yaa wɩya hʋ ma kuwo aa yaa rɛ.” Ɛɛ rɛ ba baa, “Á yaa Wɩɩsɩ biisi tɩɩ rɛ. Wɩɩsɩ dʋŋ nɛ yaa á kuwo á aa kana.” ");
INSERT INTO sig_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ Wɩɩsɩ rɛ kɔnɩ fa yaa ma Kuwo, ma fa sɩ kyo ŋ wɩya, beewɩya, Wɩɩsɩ lee rɛ ŋ lɩɩ ko we daha. Ŋ tɩɩ dee tɩyaŋ daa ŋ ko. Ʋ rɛ tɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bee rɛ yaŋ tɩŋ ma bɩ gyɩŋ wɩya hʋ ŋ aa basa memii? Ma bee kyɛ dɩ ma gyegile nɩɩ wɩya hʋ ŋ aa basɩ. Ɛɛ rɛ tɩŋ ma bɩ gyɩŋ ba memii gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ma kuwo rɛ yaa Sɩtaanɩ. Ɛɛ rɛ tɩŋ ma aa kɩ kyɛ dɩ ma kɩ yaa ʋ teŋfɩyɛl wɩya. A lɩɩ dʋnɩya lipiilii buloŋ, ʋ yaa nɩkpʋʋl lɛ. Ʋ tɩɩ paalɩ bɩ kaŋ wɩtɩɩ, beewɩya wɩtɩɩ buloŋ tuwo ʋ tɩyaŋ. Dɩ ʋ rɛ aa nyɩya wɩya, ʋ kɩyɩ rɛ paalɩ gɛɛ. Beewɩya ʋ yaa wɩnyɩyɛl lɛ, a yaa wɩnyɩyɛla buloŋ kuwo mɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amɛ ŋ aa basɩ wɩtɩɩ hʋ wɩya rɛ tɩŋ ma bɩ laa ŋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ma kɩbee rɛ sɩ wuwo daga wɩbɔŋ hʋ ŋ ha aa maakyiye yaa? Dɩ mɩyaŋ nɛ aa basɩ wɩtɩɩ, bee rɛ yaŋ tɩŋ ma bɩ laa ŋ wɩya di? ");
INSERT INTO sig_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nal hʋ buloŋ aa lɩɩ Wɩɩsɩ lee aa gyegile kɩ nɩɩ wɩya hʋ Wɩɩsɩ aa basɩ rɛ. Ma kɛ bɩ lɩɩ Wɩɩsɩ lee, ɛɛ rɛ tɩŋ ma bɩ gyegile kɩ nɩɩ Wɩɩsɩ wɩya.” ");
INSERT INTO sig_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ɛɛ rɛ Gyuuma hʋ basɩ tɩya Yesu a baa, “Á kɔnɩ aa baa dɩ ɩ yaa Samaarɩya tɩɩna, ka gyɩŋbɔŋ mɛ kana ɩ hʋ, ʋ yaa wɩtɩɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Gyɩŋbɔŋ tuwo ŋ tɩyaŋ. Amɛ ŋ aa tɩya ŋ Kuwo gyɩrɩma rɛ, aŋka ma kɛ bee tɩya ŋ gyɩrɩma. ");
INSERT INTO sig_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ŋ bɩ kyɛɛ feŋ kɩ tɩya ŋ tɩɩ. Amɛ nal lɛ we doŋ a kyɛ feŋ kɩ tɩya ŋ. Ʋ rɛ yaŋ sɩ di nala hʋ aa vɩya ŋ wɩya sarɩya abee wɩtɩɩ a kpa kyogisi tɩya ba. ");
INSERT INTO sig_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa tɩŋa ŋ nyʋwa, ʋ bɩ sɩ maakyiye sʋba.” ");
INSERT INTO sig_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ɛɛ rɛ Gyuuma hʋ basɩ tɩya ʋ a baa, “Nyɛ kɛ, á yaŋ paalɩ gyɩma anɩɩ gyɩŋbɔŋ nɛ kɔnɩ kana ɩ. Abɩraham sʋba rɛ. Wɩɩsɩ tɩŋdaala hʋ mɛ sʋba. Aŋka ɩ baa dɩ nal hʋ buloŋ aa tɩŋa ɩ nyʋwa bɩ sɩ maakyiye sʋba. ");
INSERT INTO sig_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Á kuwo Abɩraham tɩɩ gba sʋba rɛ. Ɩ yaŋ bɩɩna nɩɩ ɩ rɛ tee ʋ koo? Wɩɩsɩ tɩŋdaala hʋ mɛ sʋba. Aŋnɛ rɛ yaŋ yaa ɩ kɛ?” ");
INSERT INTO sig_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Dɩ mɩyaŋ nɛ fa kyɛɛ feŋ kɩ tɩya ŋ tɩɩ, haŋ feŋ hʋ fa bɩ sɩ kaŋ tɔnɔ buloŋ. Ŋ Kuwo rɛ yaa nal hʋ aa tɩya ŋ feŋ, nal hʋ tɩɩ ma aa baa dɩ ʋ rɛ yaa ma Wɩɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma ha bɩ maakyiye gyɩma ʋ amɛ ŋ kɛ gyɩma ʋ rɛ. Dɩ mɩyaŋ nɛ baa ŋ bɩ gyɩma ʋ, ŋ yaa wɩnyɩyɛl lɛ anɩɩ ma mɛ aa yaa wɩnyɩyɛla gɛɛ. Ŋ gyɩma ʋ rɛ a kɩ tɩŋa ʋ nyʋwa mɛ. ");
INSERT INTO sig_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma naabaa Abɩraham gyɩ aa lurimi na a gyɩma anɩɩ ŋ sɩ ko dʋnɩya, ʋ teŋ gyɩ fɩyɛlɩ rɛ weliŋ ŋ koyi wɩya.” ");
INSERT INTO sig_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ɛɛ rɛ Gyuuma hʋ basɩ tɩya ʋ a baa, “Ɩ ha paalɩ bɩ pele bɩsɩ mɔllɩbalɩya bee fi. Ɛɛ rɛ ɩ yaŋ yaa a na Abɩraham?” ");
INSERT INTO sig_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ka dɩ ba na lʋl Abɩraham, dɩ ŋ kɛ foŋ we doŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɛɛ rɛ ba paa bʋwa dɩ ba yaga ʋ, ʋ faŋa a lʋwɔlɩ lɩɩ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu aa kpaa ŋmanɩɩ vala kɩ mʋ hʋ tɩyaŋ nɛ, ʋ na baal kɩdɩgɩ ba aa lʋla ʋ dɩ ʋ nyʋlɩma. ");
INSERT INTO sig_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɛɛ rɛ Yesu hatɩnna pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, bee rɛ tɩŋ ba lʋl baal no dɩ ʋ nyʋlɩma? Baal hʋ tɩɩ wɩbɔmɔ rɛ tɩŋ koo ʋ kuwo bee ʋ naa wɩbɔmɔ rɛ tɩŋ?” ");
INSERT INTO sig_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Baal no nyʋlʋŋsɩ hʋ bɩ lɩɩ ʋ tɩɩ wɩbɔmɔ tɩyaŋ koo ʋ kuwo bee ʋ naa wɩbɔmɔ tɩyaŋ. Ʋ nyʋlɩma rɛ dɩ Wɩɩsɩ wuwo tɩŋ gɛɛ tɩyaŋ a daga ʋ dee. ");
INSERT INTO sig_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Á aa we pʋlʋŋ tɩyaŋ nyɛ, ma leŋ dɩ á kɩ yaa wɩya hʋ nal hʋ aa tɩma ŋ aa baa dɩ á kɩ yaa. Bilhuu sɩ ko dɩ nal buloŋ bɩl bɩ sɩ wuwo yaa wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ŋ ha aa we dʋnɩya tɩyaŋ nyɛ, mɩyaŋ nɛ yaa dʋnɩya nala pʋlʋŋ.” ");
INSERT INTO sig_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu aa basɩ gɛɛ ko teŋ, ʋ tʋ naŋtʋwɔl biŋ taŋha, a kaŋ buu buu, a paa taa baal hʋ sɩya, aŋ basɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Sii tuu Silom fuwo hʋ a sɔmɔ ɩ sɩya.” (Silom memii rɛ yaa tɩmɩɩ). Ɛɛ rɛ baal hʋ sii tuu fuwo hʋ, a yaa nɩɩ sɔmɔ ʋ sɩya. Ʋ sɩya suri doŋ, ʋ mɩɩgɩ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɛɛ rɛ ʋ bee nala hʋ aa gyʋʋ kɩ kpaga dɔmɔŋ, abee nala hʋ buloŋ fa aa naa baal no dɩ ʋ fa aa kɩ sʋla kɩna, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Baal no daa fa aa hɔŋ kɩ sʋla kɩna gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Badɔmɔŋ baa dɩ ʋ rɛ, badɔmɔŋ mɛ baa dɩ ʋ daa, dɩ ba ta kɩɩ dɔmɔŋ nɛ. Ɛɛ rɛ baal hʋ tɩɩ baa “Mɩyaŋ nɛ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ɩ yaa a wuwo kɩ na nyɛ kɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɛɛ rɛ baal hʋ baa, “Baal hʋ ba aa yɩrɩ Yesu, ʋ rɛ buu taŋha a paa taa ŋ sɩya, aŋ baa dɩ ŋ tuu Silom fuwo hʋ a yaa nɩɩ sɔmɔ. Ɛɛ rɛ ŋ tuu sɔmɔ, ŋ sɩya pirigi suri.” ");
INSERT INTO sig_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Lee tɩyaŋ nɛ ʋ we?” Baal hʋ baa, “Ŋ bɩ gyɩma”. ");
INSERT INTO sig_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ɛɛ rɛ ba kaŋ baal hʋ fa aa nyʋlɩma a mʋ Farasiima hʋ lee. ");
INSERT INTO sig_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kyɛwiyesii hʋ kyɛɛ rɛ Yesu gyɩ buu taŋha a paa taa baal hʋ sɩya ba suri gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɛɛ rɛ Farasiima hʋ mɛ bɩl pɩyɛsɩ baal hʋ gɛɛ ʋ aa yaa ʋ sɩya suri. Baal hʋ basɩ tɩya ba a baa, “Taŋha rɛ ʋ buu a paa taa ŋ sɩya, ŋ mʋ sɔmɔ ta ŋ sɩya suri.” ");
INSERT INTO sig_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ɛɛ rɛ Farasiima hʋ badɔmɔŋ baa, “Baal hʋ aa yaa wɩɩ no, Wɩɩsɩ daa tɩma ʋ, beewɩya ʋ bee tɩŋ á Kyɛwiyesii hʋ kyɛɛ sɩŋsɩ.” Ɛɛ rɛ badɔmɔŋ mɛ baa, “Ɛɛ rɛ nal hʋ aa yaa wɩbɔŋyaal sɩ wuwo kɩ yaa wɩmagɩla no?” Doŋ nɛ nyʋʋtaaduwo gyʋʋ ba, ba porigi dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɛɛ rɛ Farasiima hʋ bɩl pɩyɛsɩ baal hʋ a baa, “Ka ɩ baa ʋ suri ɩ sɩya rɛ, aŋnɛ rɛ ɩ bɩɩnɩ anɩɩ ʋ yaa?” Nyɛ rɛ baal hʋ baa “Ʋ yaa Wɩɩsɩ tɩŋdaala lɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Amɛ Gyuuma nɩhɩyasɩ hʋ fa bee kyɛ dɩ ba laa di anɩɩ baal hʋ fa kɔnɩ nyʋlɩma rɛ, aŋ mɩɩgɩ ko kɩ na gɛɛ, see dɩ ba na ʋ kuwo bee ʋ naa. ");
INSERT INTO sig_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nyɛ rɛ ba tɩŋ yɩrɩ baal hʋ nɩɩna abee ʋ kuwo a pɩyɛsɩ ba a baa, “Ma biye rɛ nyɛ? Ma baa dɩ ma lʋla ʋ dɩ ʋ nyʋlɩma rɛ? Ɛɛ rɛ ʋ yaŋ yaa a kɩ na nyɛ kɛ?” ");
INSERT INTO sig_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ɛɛ rɛ ba baa, “Á gyɩma anɩɩ á biye rɛ nyɛ. Á gyɩma anɩɩ á lʋla ʋ dɩ ʋ nyʋlɩma rɛ. ");
INSERT INTO sig_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amɛ ɛɛ hʋ ʋ aa yaa ʋ sɩya suri kɛ, á bɩ gyɩma. Á bɩ gyɩŋ nal hʋ mɛ aa leŋ ʋ sɩya suri. Ma kɩ pɩyɛsɩ ʋ, ʋ hɩyasa rɛ. Ʋ aa wuwo ʋ basɩ wɩya rɛ ʋ tɩɩ.” ");
INSERT INTO sig_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baal hʋ kuwo abee ʋ naa fa aa fá Gyuuma nɩhɩyasɩ hʋ rɛ, ɛɛ rɛ tɩŋ ba basɩ gɛɛ. Beewɩya Gyuuma nɩhɩyasɩ hʋ fa baa dɩ nal hʋ buloŋ ko baa Yesu rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, dɩ ba sɩ kile ʋ tɩɩna ta ba wɩɩkyʋwaldɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Biye hʋ nɩɩna bee ʋ kuwo gyɩŋ gɛɛ tɩyaŋ nɛ, ɛɛ rɛ tɩŋ ba baa dɩ ʋ hɩyasa rɛ, dɩ ba pɩyɛsɩ ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ɛɛ rɛ Farasiima hʋ bɩl yɩrɩ baal hʋ fa aa nyʋlɩma hʋ a baa, “Á gyɩma anɩɩ baal no yaa wɩbɔŋyaal lɛ. Wɩɩsɩ sɩya tɩyaŋ, basɩ wɩtɩɩ tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Baal hʋ baa, “Ŋ kɛ bɩ gyɩma dɩ baal no yaa wɩbɔŋyaal koo ʋ bɩ yaa wɩbɔŋyaal. Amɛ wɩɩ hʋ ŋ kɛ aa gyɩma rɛ nyɛ: Ŋ fa nyʋlɩma rɛ, amɛ lagɩlagɩ no ŋ aa naa rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɛɛ rɛ ba pɩyɛsɩ ʋ a baa, “Ɛɛ rɛ ʋ yaa ɩ, ɩ sɩya suri?” ");
INSERT INTO sig_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɛɛ rɛ baal hʋ basɩ tɩya ba a baa, “Ŋ laa sɩya basɩ tɩya ma rɛ, ka ma bɩ gyegile nɩɩ. Bee rɛ tɩŋ ma bɩl kɩ kyɛ dɩ ma nɩɩ? Ma mɛ aa kyɛ dɩ ma yaa ʋ hatɩnna rɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɛɛ rɛ ba tʋʋsɩ ʋ weliŋ aŋ baa, “Ɩ rɛ yaa baal no hatɩnnɩ, amɛ á kɛ yaa Moosi hatɩnna rɛ. ");
INSERT INTO sig_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Á gyɩma anɩɩ Wɩɩsɩ fa basɩ wɩya tɩya Moosi rɛ, amɛ baal no kɛ, á gba bɩ gyɩŋ lee hʋ ʋ aa lɩya.” ");
INSERT INTO sig_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɛɛ rɛ baal hʋ baa, “Ma na wɩkperii ga! Ma bɩ gyɩŋ lee hʋ ʋ aa lɩya, amɛ ʋ rɛ suri ŋ sɩya. ");
INSERT INTO sig_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Á gyɩma anɩɩ Wɩɩsɩ bɩ gyegile kɩ nɩɩ wɩbɔŋyaala nyʋwa. Ʋ aa gyegili kɩ nɩɩ nala hʋ aa fá ʋ rɛ, aŋ pɛ kɩ yaa wɩya hʋ ʋ aa kyo. ");
INSERT INTO sig_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dʋnɩya aa piile buloŋ, ma ha nɩya ba baa dɩ nal suri nal ba aa lʋla dɩ ʋ nyʋlɩma sɩya? ");
INSERT INTO sig_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dɩ baal no fa bɩ lɩɩ Wɩɩsɩ lee, ʋ fa bɩ sɩ wuwo yaa wɩɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɛɛ rɛ ba basɩ tɩya baal hʋ a baa, “Ba paalɩ kɩ lʋla ɩ dɩ ɩ yaa wɩbɔŋyaal lɛ, ka ɩ mɛ yaŋ kɩ kyɛ dɩ ɩ daga ma koo?” Ɛɛ rɛ ba kile ʋ ta ʋ lɩɩ Wɩɩkyʋwaldɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu aa nɩya dɩ ba kile baal hʋ ta Wɩɩkyʋwaldɩya hʋ tɩyaŋ, ʋ mʋ kyɛ na ʋ a pɩyɛsɩ ʋ a baa, “Ɩ laa Nihuwobiŋ Biye hʋ wɩya di rɛ?” ");
INSERT INTO sig_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɛɛ rɛ baal hʋ pɩyɛsɩ ʋ a baa, “Aŋnɛ rɛ gɛɛ? Daga ŋ tɩɩna, ŋ nɩhɩyawʋ, dɩ ŋ laa ʋ wɩya di.” ");
INSERT INTO sig_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ foŋ na ʋ rɛ. Ʋ rɛ yaa nal hʋ aa basɩ wɩya ɩ lee nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɛɛ rɛ baal hʋ tuu gbinni Yesu sɩya tɩyaŋ, a kyʋwalɩ ʋ aŋ baa, “Ŋ Tɩɩna, ŋ laa ɩ di rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nyɛ rɛ Yesu baa, “Ŋ ko dʋnɩya rɛ dɩ dʋnɩya nala na ba wɩbɔmɔ, ka dɩ ŋ leŋ nala hʋ aa nyʋlɩma sɩyasɩ suri, ka nala hʋ mɛ aa baa dɩ ba sɩya suro dɩ ba mɛ nyʋlɩmɩ.” ");
INSERT INTO sig_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farasiima badɔmɔŋ mɛ fa aa sɩŋ doŋ, aŋ nɩɩ Yesu aa basɩ gɛɛ, ba pɩyɛsɩ ʋ a baa, “Ɩ bɩɩna anɩɩ á mɛ nyʋlɩma rɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Dɩ mamaa rɛ fa nyʋlɩma, ma fa bɩ sɩ kaŋ wɩkyogii buloŋ. Amɛ ma foŋ aa baa dɩ ma aa naa nyɛ, a gyɩŋ wɩtɩɩ hʋ, ɛɛ rɛ tɩŋ ma ha we ma kyogisi tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ɛɛ rɛ Yesu maga namaga a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa bɩ tɩŋ dimbeenyʋwa hʋ a gyʋʋ pedɩya hʋ, aŋ wile tɩŋ gyekariya gyʋʋ, ʋ tɩɩna yaa gaal lɛ, a kɩ fasɩ nala kɩna mɛ. ");
INSERT INTO sig_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amɛ nal hʋ aa tɩŋ pedɩya hʋ dimbeenyʋwa gyʋʋ, ʋ tɩɩna rɛ yaa piyese hʋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pedɩya didenni hʋ aa suri pedɩya hʋ dimbeenyʋwa rɛ a tɩya ʋ. Piyese hʋ mɛ gyɩŋ ʋ taal. Piyesi hʋ tɩɩna aa yɩrɩ ba kɩdɩgɩ buloŋ feŋ nɛ, a laa ba sɩya a kaŋ ba lɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dɩ ʋ rɛ ko kaŋ ba buloŋ lɩɩ teŋ, ʋ aa laa ba sɩya rɛ, ka piyese hʋ kɩ tɩŋa ʋ hal, beewɩya ba gyɩŋ ʋ taal lɛ. ");
INSERT INTO sig_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ba bɩ sɩ laa nyʋwa tɩŋ nɩdʋma hal, see dɩ ba mɩɩgɩ fá tɩɩna hal tɩyaŋ, beewɩya ba bɩ gyɩŋ ʋ taal.” ");
INSERT INTO sig_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu gyɩ maga namaga no tɩya ba rɛ, amɛ ba gyɩ bɩ gyɩŋ wɩɩ hʋ ʋ aa basɩ tɩya ba memii. ");
INSERT INTO sig_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, mɩyaŋ nɛ yaa pedɩya hʋ dimbeenyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nala hʋ buloŋ aa laa sɩya ko ŋ tɩyaŋ a nyɩya wɩya baa dɩ Wɩɩsɩ rɛ tɩŋ ba, ba buloŋ yaa gaala rɛ, a kɩ fasɩ nala kɩna mɛ, piyese hʋ mɛ bee tɩŋ ba nyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɩyaŋ nɛ yaa dimbeenyʋwa hʋ. Nal hʋ buloŋ aa tɩŋa ŋ tɩyaŋ a kɩ gyʋʋ, ŋ sɩ pɔ ʋ weliŋ. Ʋ sɩ lɩɩ aŋ mɩɩgɩ ko kɩ gyʋʋ abee laaŋfɩya, a na kɩdiweliye mɛ kɩ di. ");
INSERT INTO sig_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gaal hʋ kɛ ko dɩ ʋ gaa rɛ, a kpʋ, aŋ kyogi kyogisi, amɛ ŋ kɛ ko rɛ dɩ nala hʋ aa tɩŋa ŋ nyʋwa kaŋ mɩɩbol aa kaŋ tɔnɔ.” ");
INSERT INTO sig_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yesu bɩl baa, “Mɩyaŋ nɛ yaa pedaalwelii hʋ. Pedaalwelii aa kpa ʋ mɩɩbol lenni sʋʋ rɛ ʋ piyese wɩya. ");
INSERT INTO sig_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Amɛ nal hʋ ba aa kpaa ʋ kɩ daa piyese hʋ a kɩ laa tuno, ʋ tɩɩna daa tɩŋ piyese hʋ. Ɛɛwɩya dɩ ʋ rɛ ko na gboo dɩ ʋ aa ko, ʋ aa vɩya piyese hʋ ta rɛ aŋ fá. Gboo hʋ aa ko kaŋ kɩdɩgɩ rɛ aŋ ŋmaa kɩkaalɩya hʋ buloŋ pɩsa. ");
INSERT INTO sig_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ʋ aa fá rɛ, beewɩya ʋ tuno wɩya rɛ ʋ kɩ daa piyese hʋ. Ʋ sɩya tuwo piyese hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mɩyaŋ nɛ yaa pedaalwelii hʋ. Ŋ gyɩma ŋ piyese rɛ, ŋ piyese mɛ gyɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Anɩɩ ɛɛ hʋ ŋ Kuwo aa gyɩma ŋ, ɛɛ rɛ ŋ mɛ gyɩma ʋ. Ŋ yaa siri rɛ dɩ ŋ kpa ŋ mɩɩbol lenni sʋʋ ŋ piyese wɩya. ");
INSERT INTO sig_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ŋ kaŋ piyese badɔmɔŋ mɛ rɛ, aŋka ba tuwo pedɩya no tɩyaŋ. Ʋ maga dɩ ŋ kasɩ ba mɛ ko pɛ piyese no tɩyaŋ nɛ, dɩ ba buloŋ yaa nɩdɩgɩ piyese a gyɩŋ ŋ taal, ka dɩ ba pedaal mɛ yaa nɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ŋ kuwo kyo ŋ wɩya rɛ, beewɩya ŋ yaa siri rɛ dɩ ŋ sʋba ŋ tɩɩ kyɛrɩ tɩyaŋ. Ka dɩ ŋ ha bɩl sii sʋʋ tɩyaŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nal buloŋ bɩ sɩ wuwo kpʋ ŋ dɩ ŋ bɩ tɩya ʋ tɩɩna ŋmanɩɩ. Ŋ tɩɩ kyɛrɩ tɩyaŋ nɛ ŋ sɩ kpa ŋ mɩɩbol tɩya sʋʋ. Ŋ kaŋ dee rɛ ŋ aa sɩ kpa ŋ mɩɩbol tɩya sʋʋ, a bɩl kaŋ dee mɛ ŋ aa sɩ laa ʋ sʋʋ lee. Ŋ kuwo aa baa ŋ yaa wɩɩ rɛ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu aa basɩ wɩya no, Gyuuma hʋ kuu ɛɛ wɩya a porigi dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba gyeniŋ buloŋ baa, “Bee rɛ tɩŋ ma gyegili kɩ nɩɩ baal no wɩbasɩɩ? Gyɩŋbɔŋ nɛ kana ʋ! Ʋ aa yaarɩ rɛ!” ");
INSERT INTO sig_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba badɔmɔŋ mɛ baa, “Nal hʋ gyɩŋbɔŋ aa kana bɩ sɩ wuwo kɩ basɩ wɩya no. Gyɩŋbɔŋ wuwo kɩ suri nyʋlʋŋ sɩya rɛ?” ");
INSERT INTO sig_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɛɛ rɛ Gyuuma kyɛbal hʋ tɩyaŋ ba aa kɩ liisi saŋa hʋ ba gyɩ aa kpaa ba Wɩɩkyʋwaldɩɩbal hʋ we Wɩɩsɩ nosi tɩyaŋ bɩl ko pele. Kyɛbal no gyɩ aa ko puwo saŋa rɛ Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Saŋa no tɩyaŋ dɩ Yesu gyɩ we Wɩɩkyʋwaldɩɩbal hʋ gyambarɩŋ hʋ ba aa yɩrɩ Solomɔn Gyambarɩŋ tɩyaŋ nɛ a kɩ vala. ");
INSERT INTO sig_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɛɛ rɛ nala ko gol-ʋ, a pɩyɛsɩ ʋ a baa, “Mɔɔgɛɛ rɛ ɩ kɩ kyɛ dɩ á gyegili maga ka dɩ ɩ na daga nal hʋ ɩ aa yaa tɩya ma? Dɩ ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, basɩ polli tɩya ma dɩ á gyɩma.” ");
INSERT INTO sig_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ laa sɩya basɩ tɩya ma rɛ, ka ma bɩ laa di. Tʋma hʋ ŋ aa tʋŋ ŋ Kuwo dee tɩyaŋ, ba aa rɛ aa di ŋ daŋsɩya. ");
INSERT INTO sig_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amɛ ma bɩ yaa ŋ piyese, ɛɛ rɛ tɩŋ ma bɩ laa ŋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ŋ piyese gyɩma ŋ taal lɛ, ŋ mɛ gyɩŋ ba, ba kɩ tɩŋa ŋ hal. ");
INSERT INTO sig_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ŋ aa tɩya ba mɩɩbol hʋ aa bɩ kaŋ tenii rɛ, ba bɩ sɩ maakyiye sʋba. Nal buloŋ mɛ bɩ sɩ wuwo kaŋ ba laa ŋ nosi tɩyaŋ maakyiye kɩdɩgɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ŋ Kuwo aa kpaa ba tɩya ŋ, ʋ rɛ tee kɩŋ buloŋ. Nal buloŋ mɛ yaŋ bɩ sɩ wuwo kaŋ ba laa ʋ nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ŋ bee ŋ Kuwo buloŋ yaa kɩdɩgɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesu aa basɩ gɛɛ, Gyuuma hʋ bɩl paa bʋwa dɩ ba yaga ʋ. ");
INSERT INTO sig_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ Kuwo tɩya ŋ dee rɛ ŋ yaa wɩweliye yʋga ma sɩɩ tɩyaŋ. Ba kɩbee wɩya rɛ tɩŋ ma kɩ kyɛ dɩ ma yaga ŋ nyɛ?” ");
INSERT INTO sig_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Gyuuma hʋ mɛ mɩɩgɩ baa, “Á bee kyɛ dɩ á yaga ɩ akuu ɩ aa yaa wɩweliye no kɩdɩgɩ buloŋ wɩya, amɛ ɩ yaa nihuwobiŋ nɛ aŋ kpa ɩ tɩɩ anɩɩ ɩ rɛ yaa Wɩɩsɩ, ɛɛ rɛ tɩŋ.” ");
INSERT INTO sig_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma tɩɩ mɩrɩsɩ tɩyaŋ ba basa rɛ anɩɩ Wɩɩsɩ baa, ‘Ma yaa wɩɩbiisi rɛ.”’ ");
INSERT INTO sig_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Á gyɩma anɩɩ wɩya hʋ ba aa sabɩ biŋ Wɩɩsɩ teŋ tɩyaŋ yaa wɩtɩɩ rɛ, aa bɩ sɩ maakyiye dɩsɩ. Wɩɩsɩ kaŋ haŋ nala hʋ kɩ yɩrɩ wɩɩbiisi rɛ. Dɩ Wɩɩsɩ tɩɩ sɩ yɩrɩ nala no ʋ aa kpaa ʋ duwoso tɩya wɩɩbiisi, ");
INSERT INTO sig_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","bee rɛ yaŋ sɩ tɩŋ dɩ Wɩɩsɩ lɩɩ ŋ, a tɩma ŋ ŋ ko tuu dʋnɩya, dɩ ma baa ŋ kpaa ŋ tɩɩ kɩ magɩsɩ Wɩɩsɩ rɛ akuu ŋ aa baa dɩ ŋ yaa Wɩɩsɩ Biye wɩya? ");
INSERT INTO sig_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dɩ mɩyaŋ nɛ ko bee yaa wɩya hʋ ŋ Kuwo aa kyɛ dɩ ŋ yaa, ɛɛ kɛ ma ta laa ŋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amɛ dɩ mɩyaŋ nɛ aa yaa wɩya hʋ ŋ Kuwo aa baa ŋ kɩ yaa, abee ma aa bɩ laa ŋ di nyɛ buloŋ mɛ, ka ʋ maga dɩ ma laa wɩya no di rɛ a kɔnɩ wuwo gyɩma anɩɩ ŋ bee ŋ kuwo buloŋ yaa kɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ʋ aa basɩ gɛɛ, ba bɩl kɩ kyɛ dɩ ba kana ʋ, ɛɛ rɛ ʋ lʋwɔlɩ lɩɩ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɛɛ rɛ Yesu bɩl mɩɩgɩ mʋ kyol Gyɔɔdaŋ fuwo hʋ, a mʋ we lee hʋ tɩyaŋ Gyɔɔŋ fa aa fo nala wɩɩkyʋwalnɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nyɛ rɛ nɩgyamaa kɩ ko ʋ lee. Ba basɩ tɩya dɔmɔŋ a baa, “Gyɔɔŋ fa bɩ yaa wɩmagɩl buloŋ, amɛ wɩya hʋ buloŋ ʋ fa aa basa a mʋ kɩ tile baal no tɩyaŋ kɔnɩ yaa wɩtɩɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɛɛ rɛ nɩgyamaa hʋ gyɩ aa we doŋ laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Baal kɩdɩgɩ rɛ gyɩ we doŋ a lɩɩ Bɛɛtani ba kɩ yɩrɩ Laazʋrɔsɩ. Doŋ nɛ Mɛɛrɩ bee ʋ naatoluu Maata mɛ gyɩ lɩɩ. (Mɛɛrɩ no tɩɩ rɛ yaa nal hʋ gyɩ aa kpaa tʋranɩɩ bɩsɩ we á Tɩɩna Yesu naasɩ tɩyaŋ, aŋ kaŋ ʋ nyupʋna tɩɩgɩ gɛɛ). Ɛɛ rɛ ba nɩɩnabiibaal Laazʋrɔsɩ gyɩ sii kɩ wɩɩlɩ. ");
INSERT INTO sig_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nyɛ rɛ ʋ naatoliye hʋ tɩma ba mʋ basɩ tɩya Yesu a baa, “Á Tɩɩna, ɩ kyaŋkyoolii hʋ aa wɩɩlɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu aa nɩɩ wɩɩ no, ʋ baa, “Wɩɩla no litenii daa sɩ yaa Laazʋrɔsɩ sʋʋ, amɛ ʋ pɩŋ wɩɩla no rɛ dɩ nala na Wɩɩsɩ gaŋdarɩ, ka dɩ mɩyaŋ Wɩɩsɩ Biye mɛ tɩŋ gɛɛ tɩyaŋ a laa ŋ gaŋdarɩ.” ");
INSERT INTO sig_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu fa kyo Maata abee ʋ naatoluu Mɛɛrɩ abee Laazʋrɔsɩ wɩya rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Amɛ abee ʋ aa nɩya dɩ Laazʋrɔsɩ aa wɩɩlɩ buloŋ, ka ʋ ha gyɩ hɔŋ lee hʋ ʋ aa wee tɩyaŋ nɛ kyɛyɛ balɩya. ");
INSERT INTO sig_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɛɛ hal tɩyaŋ nɛ ʋ basɩ tɩya ʋ hatɩnna hʋ a baa, “Ma leŋ dɩ á mɩɩgɩ mʋ Gyudɩya paalʋʋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɛɛ rɛ Yesu hatɩnna hʋ basɩ tɩya ʋ a baa, “Á nɩhɩyawʋ, dɩyaraŋ biisi no ɩ daa Gyuuma paa bʋwa kɩ kyɛ ba yaga gɛɛ. Bee rɛ yaŋ tɩŋ ɩ bɩl kɩ kyɛ dɩ ɩ mʋ doŋ?” ");
INSERT INTO sig_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɛɛ rɛ Yesu baa, “Sɩgballɩya buloŋ kaŋ ʋ tebine bee ʋ wɩɩhaa rɛ. Ɛɛwɩya, nal hʋ aa vala wɩɩhaa, ʋ bee garɩ kɩna, beewɩya lee buloŋ aa kyaanɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amɛ nal hʋ aa vala tebine, ʋ aa kɩ garɩ kɩna rɛ, beewɩya pʋlʋŋ tuwo.” ");
INSERT INTO sig_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ hatɩnna hʋ a baa, “Á kyana Laazʋrɔsɩ pɩŋ doo rɛ, amɛ ŋ sɩ mʋ kyisi ʋ doo hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɛɛ rɛ ʋ hatɩnna hʋ basɩ tɩya ʋ a baa, “Dɩ ʋ rɛ pɩŋ doo, ɛɛ daga anɩɩ ʋ sɩ deye.” ");
INSERT INTO sig_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu aa basɩ gɛɛ, ʋ daga anɩɩ Laazʋrɔsɩ sʋba rɛ gɛɛ, amɛ ʋ hatɩnna hʋ kɛ fa bɩɩna anɩɩ doo tɩɩ rɛ ʋ kɔnɩ pɩŋ. ");
INSERT INTO sig_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nyɛ rɛ Yesu kaŋ basɩ polli tɩya ba anɩɩ Laazʋrɔsɩ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɛɛ rɛ Yesu baa, “Ma wɩya, ŋ teŋ fɩyɛla abee Laazʋrɔsɩ aa sʋba dɩ ŋ tuwo doŋ. Ma sɩ tɩŋ gɛɛ tɩyaŋ, a laa ŋ wɩya di. Ma leŋ dɩ á mʋ ʋ lee.” ");
INSERT INTO sig_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ɛɛ rɛ Tɔmaasɩ, Yesu hatɩnna hʋ kɩdɩgɩ ba aa yɩrɩ daalɩyanɩ, basɩ tɩya ʋ dɔŋtɩŋsɩ hʋ a baa, “Ma leŋ dɩ á buloŋ tɩŋ Yesu hal mʋ, dɩ ʋ rɛ sɩ sʋba mɛ, dɩ á buloŋ sʋba.” ");
INSERT INTO sig_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ɛɛ rɛ Yesu bee ʋ hatɩnna hʋ kpa mʋ Bɛɛtani. Ba aa mʋʋ pele doŋ, ɛɛ rɛ Yesu nɩɩ anɩɩ Laazʋrɔsɩ kyɛyɛ banaa rɛ gɛɛ ba aa hogo ʋ. ");
INSERT INTO sig_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛɛtani abee Gyerusalɛm gyɩ bɩ pele meeldaasɩ balɩya. ");
INSERT INTO sig_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Gyuuma fa yʋga a lɩɩ Gyerusalɛm ko Bɛɛtani dɩ ba lɔllɩ Maata abee Mɛɛrɩ, ba nɩɩnabiibaal hʋ aa sʋba wɩya. ");
INSERT INTO sig_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata aa nɩya anɩɩ Yesu we ŋmanɩɩ tɩyaŋ, ɛɛ rɛ ʋ sii lɩɩ mʋ dɩ ʋ kyeme ʋ, aŋka Mɛɛrɩ kɛ fa we dɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ɛɛ rɛ Maata basɩ tɩya Yesu a baa, “Ŋ Tɩɩna, dɩ ɩ rɛ fa we daha, ŋ naabiibaal hʋ fa bɩ sɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ka abee gɛɛ buloŋ, ŋ gyɩma anɩɩ dɩ ɩ rɛ sʋla Wɩɩsɩ kɩ kyɛ wɩɩ buloŋ, ʋ sɩ yaa tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ɛɛ rɛ Yesu basɩ tɩya ʋ, “Ɩ naabiibaal hʋ sɩ mɩɩgɩ sii sʋʋ tɩyaŋ a kaŋ mɩɩbol”. ");
INSERT INTO sig_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ɛɛ rɛ Maata basɩ tɩya ʋ a baa, “Ŋ gyɩma anɩɩ dʋnɩya kyɛtenii, ʋ sɩ sii sʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Mɩyaŋ nɛ yaa nal hʋ aa kyisi nala sʋʋ tɩyaŋ a tɩya ba mɩɩbol. Nala hʋ buloŋ aa laa ŋ wɩya di, dɩ ba aa rɛ sʋba mɛ, ba sɩ kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nala hʋ mɛ buloŋ aa weye aŋ laa ŋ wɩya di, bɩ sɩ maakyiye sʋba. Ɩ laa wɩɩ no di rɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɛɛ rɛ Maata baa, “Waa, ŋ Tɩɩna. Ŋ laa di anɩɩ ɩ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, a yaa Wɩɩsɩ Biye mɛ, nal hʋ Wɩɩsɩ aa baa ʋ sɩ ko tuu dʋnɩya no.” ");
INSERT INTO sig_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata aa basɩ wɩya no teŋ, ʋ mɩɩgɩ gyʋʋ dɩya a lʋwɔlɩ yɩrɩ ʋ naatoluu Mɛɛrɩ, a miŋsi basɩ tɩya ʋ a baa, “Mɛɛrɩ, á nɩhɩyawʋ hʋ ko rɛ, a pɩyɛsɩ kɩ kyɛ ɩ.” ");
INSERT INTO sig_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛɛrɩ aa nɩɩ gɛɛ, ʋ sii lagɩ lagɩ, a lɩɩ dɩ ʋ kyeme ʋ. ");
INSERT INTO sig_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Saŋa no tɩyaŋ dɩ Yesu ha bɩ gyʋʋ bee hʋ tɩyaŋ, dɩ ʋ ha gyɩ we lee hʋ Maata aa kyeme ʋ hʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nala hʋ fa aa we dɩya hʋ tɩyaŋ a kɩ fɩyɛlɩ Mɛɛrɩ bembii, aa naa dɩ ʋ sii tarɩsɩ kɩ lɩɩ gɛɛ, ba mɛ sii tɩŋa ʋ hal, beewɩya ba kɛ fa bɩɩna anɩɩ ʋ aa kyɛ dɩ ʋ mʋ wii Laazʋrɔsɩ bil hʋ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛrɩ aa mʋʋ pele lee hʋ Yesu fa aa wee a na ʋ, ʋ tuu tele ʋ naasɩ tɩyaŋ aŋ baa, “Ŋ Tɩɩna, dɩ ɩ rɛ fa we daha, ŋ naabiibaal no fa bɩ sɩ sʋba.” ");
INSERT INTO sig_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu aa naa Mɛɛrɩ abee nala hʋ aa tɩŋa ʋ hal aa wii gɛɛ, ʋ tɩya kyogi kɩŋkaŋ. Ʋ nyuu buloŋ nyiiri. ");
INSERT INTO sig_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ɛɛ rɛ ʋ pɩyɛsɩ ba a baa, “Lee tɩyaŋ nɛ ma hogo ʋ?” Ba basɩ tɩya ʋ a baa, “Á Tɩɩna, ko na doŋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu wii. ");
INSERT INTO sig_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɛɛ rɛ nala hʋ basɩ tɩya dɔmɔŋ a baa, “Ma na ʋ aa kyo ʋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Badɔmɔŋ mɛ pɩyɛsɩ a baa, “Ka ʋ rɛ gyɩ suri nyʋlʋŋ hʋ sɩya gɛɛ, ʋ fa bɩ sɩ wuwo leŋ dɩ Laazʋrɔsɩ ta sʋba?” ");
INSERT INTO sig_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ba aa basɩ gɛɛ, Yesu nyuu bɩl nyiiri. Ɛɛ rɛ ba mʋ pele bʋwa hʋ lee. Bʋwa hʋ fa yaa bʋbʋwa rɛ, ka ba kpa bʋyɩ tɔ ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ɛɛ rɛ Yesu baa dɩ ba kaŋ bʋyɩ hʋ suri bʋwa hʋ nyʋwa tɩyaŋ. Ɛɛ rɛ Maata, Laazʋrɔsɩ nɩɩnatoliye hʋ kɩdɩgɩ basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, ʋ aa sʋba ʋ kyɛyɛ banaa rɛ yaa gyɩnaŋ. Mɔɔnyɛ ʋ aa sʋwalɩ.” ");
INSERT INTO sig_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ŋ bɩ basɩ tɩya ɩ anɩɩ dɩ ɩ rɛ laa ŋ wɩya di, ɩ sɩ na Wɩɩsɩ dee aa maga gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɛɛ rɛ ba kaŋ bʋyɩ hʋ suri. Yesu wil deŋ wɩɩsɩnyuu aŋ baa, “Ŋ Kuwo, ŋ aa kyʋwalɩ ɩ aŋgyʋwasʋ abee ɩ aa gyegile kɩ nɩɩ ŋ wulo. ");
INSERT INTO sig_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋ gyɩma anɩɩ ɩ gyegili kɩ nɩɩ ŋ wulo rɛ saŋa buloŋ. Amɛ nala no aa we daha wɩya rɛ tɩŋ ŋ basɩ wɩɩ no, dɩ ba wuwo laa di anɩɩ ɩ rɛ tɩma ŋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu aa basɩ gɛɛ ko teŋ, ʋ nɔsɩ yɩrɩ a baa, “Laazʋrɔsɩ, ko lɩɩ!” ");
INSERT INTO sig_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ʋ aa basɩ gɛɛ baal hʋ aa sʋba hʋ sii ko lɩɩ. Ʋ aa ko lɩɩ dɩ liŋe hʋ ha fa vʋwa ʋ naasɩ abee ʋ nosi buloŋ, ka kɩdɩgɩ mɛ tɔ ʋ sɩya. Ɛɛ rɛ Yesu basɩ tɩya nala hʋ a baa, “Ma kaŋ kɩna hʋ puri ta ʋ tɩyaŋ dɩ ʋ mʋ.” ");
INSERT INTO sig_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nala hʋ gyɩ aa ko dɩ ba kyʋwalɩ Mɛɛrɩ, a na wɩɩ hʋ Yesu aa yaa, ba tɩyaŋ nala yʋga gyɩ laa ʋ wɩya di rɛ. ");
INSERT INTO sig_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka ba badɔmɔŋ mɛ mɩɩgɩ mʋ basɩ tɩya Farasiima badɔmɔŋ wɩɩ hʋ Yesu aa yaa. ");
INSERT INTO sig_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ɛɛ rɛ Farasiima hʋ abee wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ abee bee hʋ nɩhɩyasɩ na dɔmɔŋ a baa, “Wɩbee rɛ á sɩ yaa? Ma na wɩmagɩla no buloŋ baal no aa yaa. ");
INSERT INTO sig_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dɩ ámaa rɛ leŋ dɩ ʋ yaa wɩya no kɩ mʋ deŋdeŋ, nal nal buloŋ sɩ ko laa ʋ wɩya di. Dɩ gɛɛ rɛ ko yaa, Roma paalʋʋ nala sɩ ko kaŋ á taŋha abee á Wɩɩkyʋwaldɩɩbal hʋ buloŋ laa.” ");
INSERT INTO sig_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gyuuma nɩhɩyasɩ hʋ tɩyaŋ kɩdɩgɩ rɛ ba fa kɩ yɩrɩ Kayifasɩ. Haŋ bɩna hʋ tɩyaŋ, ʋ rɛ gyɩ yaa Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ. Ɛɛ rɛ ʋ baa, “Ma yaa bambugo kɩŋkaŋ! ");
INSERT INTO sig_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma bɩ gyɩma anɩɩ dɩ nɩdɩgɩ rɛ laa paalʋʋ no nala buloŋ nyuu sʋba, ʋ rɛ kpɩya á paalʋʋ no nala buloŋ aa sʋba, koo ma bɩ gyɩŋ gɛɛ tɩyaŋ?” ");
INSERT INTO sig_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ʋ aa basɩ gɛɛ, ʋ bɩ kɩɩ nɩɩ ʋ tɩɩ hakɩla tɩyaŋ nɛ ʋ basɩ gɛɛ, amɛ ʋ aa yaa wɩɩkyʋwal sɩlaala nɩhɩyawʋ haŋ bɩna hʋ, ɛɛ rɛ tɩŋ ʋ wuwo basɩ wɩya Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ, anɩɩ Yesu rɛ sɩ laa paalʋʋ hʋ nala buloŋ nyuu sʋba. ");
INSERT INTO sig_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ba paalʋʋ hʋ nala mɛ dʋŋ wɩya daa ʋ sɩ sʋba, amɛ dɩ ʋ wuwo pɛ kasɩ Wɩɩsɩ biisi hʋ aa pɩsa we lee buloŋ tɩyaŋ mɛ, a pɛ dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A yaŋ lɩɩ haŋ kyɛɛ hʋ kɩ mʋ, ɛɛ rɛ Gyuuma nɩhɩyasɩ hʋ piili kɩ kyɛ ŋmanɩɩ hʋ ba aa sɩ tɩŋa a kpʋ Yesu. ");
INSERT INTO sig_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɛɛwɩya, Yesu gyɩ bɩl bɩ gɔllɔ kɩ mʋ leye hʋ Gyuuma aa sɩ kɩ na ʋ. Ʋ gyɩ lɩɩ Gyudɩya paalʋʋ tɩyaŋ nɛ, ʋ bee ʋ hatɩnna hʋ mʋ we tɔɔ kɩdɩgɩ ba aa yɩrɩ Efirem aa kpaga pogibal hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Saŋa no tɩyaŋ dɩ Gyuuma Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ gyɩ kpaga. Ɛɛ rɛ Gyuuma yʋga lɩɩ ba beye, a mʋ Gyerusalɛm, dɩ ba pɩɩsɩ ba bisiŋ ta, aŋka dɩ kyɛbal hʋ na pele. ");
INSERT INTO sig_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɛɛ rɛ ba deŋ kɩ kyɛ Yesu. Ba aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, ɛɛ rɛ ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Ma bɩɩna ʋ sɩ ko gbɩyala hʋ koo, ʋ bɩ sɩ ko?” ");
INSERT INTO sig_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Saŋa hʋ tɩyaŋ, dɩ wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Farasiima hʋ tɩya nyʋwa anɩɩ dɩ nal buloŋ nɛ gyɩŋ lee hʋ Yesu aa wee, dɩ ʋ tɩɩna ko tɩya ba duwoso dɩ ba wuwo kana ʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ʋ gyɩ kaa kyɛyɛ badʋ rɛ ka dɩ Gyuuma Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ pele. Ɛɛ rɛ Yesu sii mʋ Bɛɛtani, lee hʋ Laazʋrɔsɩ aa wee, baal hʋ ʋ fa aa kyise sʋʋ tɩyaŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Doŋ tɩyaŋ nɛ ba marɩ kɩdiiliye dɩ ba hʋwɔlɩ ʋ. Laazʋrɔsɩ mɛ gyɩ pɛɛ nala hʋ bee Yesu aa hɔŋ kɩ di kɩna hʋ tɩyaŋ nɛ, ka Maata mɛ gyɩ pɛ kɩ kpaa kɩdiiliye hʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ɛɛ rɛ Mɛɛrɩ kpa tʋranɩɩ kɩdɩgɩ sʋwala aa sʋma weliŋ ka ʋ yalɩɩ mɛ hayɛ, ʋ kpa bɩsɩ mɩsɩ Yesu naasɩ, a kaŋ ʋ nyupʋna tɩɩgɩ. Ɛɛ rɛ tʋranɩɩ hʋ sʋwala sii tɔ dɩya hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dɩ Yesu hatɩnna hʋ kɩdɩgɩ ba aa yɩrɩ Gyudasɩ Isɩkarɔtɩ, nal hʋ fa aa ko kpa Yesu yallɩ hʋ, baa, ");
INSERT INTO sig_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bee rɛ tɩŋ ba bɩ kpaa tʋranɩɩ no yallɩ a kpa molbiye hʋ tɩya nyaaba. Tʋranɩɩ no yalɩɩ fa sɩ maga nal kɩdɩgɩ biŋ piliŋ tuno.” ");
INSERT INTO sig_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ʋ aa basɩ gɛɛ, ʋ bɩ kɩɩ nɩɩ ʋ aa kyo nyaaba rɛ tɩŋ, amɛ ʋ fa yaa gaal lɛ. Ʋ rɛ fa aa biŋ ba molbiye, aa gaa lɩɩ kɩ yaa ʋ tɩɩ wɩkanɩya. ");
INSERT INTO sig_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma leŋ haaŋ no bee laaŋfɩya, ʋ fa kpaa tʋranɩɩ no biŋ kɩ pɔ kyɛɛ hʋ ba aa sɩ hogo ŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma bee nyaaba sɩ we doŋ saŋa buloŋ, amɛ ŋ beel-ma kɛ bɩ sɩ we doŋ kɩ mʋ deŋdeŋ.” ");
INSERT INTO sig_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nɩgyamaa gyɩ nɩya anɩɩ Yesu we Bɛɛtani tɩyaŋ nɛ. Ɛɛ rɛ ba sii mʋ doŋ. Amɛ Yesu dʋŋ wɩya daa ba gyɩ mʋ doŋ. Ba gyɩ mʋwa ka dɩ ba pɛ na Laazʋrɔsɩ mɛ rɛ, nal hʋ Yesu aa kyise sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ vʋʋlɩ anɩɩ see dɩ ba kpʋ Laazʋrɔsɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Beewɩya, Yesu aa kyisi Laazʋrɔsɩ sʋʋ tɩyaŋ wɩya, Gyuuma yʋga vɩya ba nɩhɩyasɩ hʋ nyʋwa rɛ, aŋ laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ʋ sɩgballɩya, gyamaa hʋ aa ko Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ nɩya anɩɩ Yesu aa ko Gyerusalɛm nɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɛɛ rɛ ba buloŋ gyaa wɩɩwɩɩsɩ paaponni, a kaŋ mʋ dɩ ba kyeme ʋ, a kɩ yaa kyagɩŋsɩ yʋga a baa, “Ma dannɩ Wɩɩsɩ. Wɩɩsɩ sɩ kyiyeli nal hʋ aa ko á Tɩɩna Wɩɩsɩ feŋ tɩyaŋ. Wɩɩsɩ sɩ kyiyeli Iziral tɩmma kuwori hʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nyɛ rɛ Yesu na kokubiye a kaŋ gyɩŋ. Ba fa sabɩ gɛɛ rɛ Wɩɩsɩ teŋ tɩyaŋ a baa, ");
INSERT INTO sig_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zaayɔŋ nala, ma ta kɩ fáá kambɩŋ. Ma na, ma kuwori rɛ gyɩŋ kokubiye a kɩ ko.” ");
INSERT INTO sig_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu hatɩnna hʋ gyɩ bɩ gyɩŋ wɩya no buloŋ aa yaa, amɛ Wɩɩsɩ aa kyisi Yesu ʋ sii sʋʋ tɩyaŋ a laa feŋ hʋ gɛɛ hal tɩyaŋ nɛ ba liisi anɩɩ wɩya hʋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ a mʋ kɩ tile Yesu tɩyaŋ, ba aa rɛ kɔnɩ ko yaa ʋ tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nɩgyamaa hʋ gyɩ aa we doŋ a na Yesu dɩ ʋ yɩrɩ Laazʋrɔsɩ a kyisi ʋ sʋʋ tɩyaŋ ʋ lɩɩ bʋwa hʋ tɩyaŋ nɛ gyɩ basɩ wɩɩ no kɩ tɩya nala. ");
INSERT INTO sig_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɩgyamaa hʋ gyɩ aa nɩya anɩɩ Yesu rɛ yaa wɩmagɩl no, ɛɛ rɛ tɩŋ ba buloŋ gyɩ ko lɩɩ dɩ ba kyeme ʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ɛɛ rɛ Farasiima hʋ basɩ tɩya dɔmɔŋ a baa, “Á lʋga á wɩɩ hʋ kɩ lɔlɔ rɛ. Ma deŋ na, dʋnɩya nala buloŋ nɛ aa tɩŋa ʋ hal gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Giriisi tɩmma badɔmɔŋ mɛ rɛ fa we nala hʋ gyɩ aa mʋʋ Gyerusalɛm Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ saŋa dɩ ba kyʋwalɩ Wɩɩsɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɛɛ rɛ nala no sii mʋ Fɩlɩpɩ lee, (Fɩlɩpɩ fa lɩɩ Bɛsaada aa we Galili paalʋʋ tɩyaŋ nɛ) a basɩ tɩya ʋ a baa, “Nɩhɩyawʋ, á aa kyɛ á na Yesu rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fɩlɩpɩ mɛ sii mʋ basɩ tɩya Aŋduru. Ɛɛ rɛ ba buloŋ balɩya mʋ basɩ tɩya Yesu. ");
INSERT INTO sig_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Nyɛ kɛ, saŋa hʋ pele rɛ dɩ Wɩɩsɩ daga mɩyaŋ Nihuwobiŋ Biye gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, dɩ ɩ rɛ bɩ kpaa miŋbii doho, dɩ ʋ sʋba, ʋ aa yaa miŋbidɩgɩ dʋŋ nɛ. Amɛ dɩ ɩ rɛ ko kpa ʋ doho dɩ ʋ sʋba ʋ aa we miŋbigyamaa rɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nal hʋ buloŋ aa kyɩl ʋ tɩɩ wɩya, ʋ tɩɩna bɩ sɩ kaŋ kɩŋ buloŋ. Amɛ nal hʋ mɛ buloŋ aa bɩ kyɩl ʋ dʋŋ wɩya dʋnɩya no tɩyaŋ, ʋ tɩɩna yaa gɛɛ kɩ pɔ ʋ tɩɩ rɛ dɩ ʋ maakyiye na mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nal hʋ buloŋ aa kyɛ dɩ ʋ tʋma kɩ tɩya ŋ, see tɩɩna tɩŋa ŋ nyʋwa. Lee hʋ buloŋ ŋ aa wee, ʋ tɩɩna mɛ sɩ we doŋ. Nal hʋ buloŋ aa tʋma kɩ tɩya ŋ, ŋ Kuwo sɩ kpa ʋ tɩɩna yohuŋ.” ");
INSERT INTO sig_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","28","Ɛɛ rɛ Yesu baa, “Lagɩlagɩ no, ŋ tɩya buloŋ nɛ kyogo. Wɩbee rɛ ŋ sɩ basɩ? Ŋ baa dɩ ŋ Kuwo ta leŋ dɩ tʋwara hʋ ŋ aa gyɩma anɩɩ ŋ sɩ na ko ŋ tɩyaŋ koo? Aayɩ, ŋ bɩ sɩ wuwo basɩ gɛɛ. Beewɩya tʋwara no wɩya rɛ tɩŋ ŋ ko dʋnɩya. Ŋ kuwo, daga ɩ gaŋdarɩ.” Ɛɛ rɛ taal lɩɩ wɩɩsɩbee a baa, “Ŋ daga ŋ gaŋdarɩ aa maga gɛɛ rɛ. Ŋ bɩl sɩ daga ŋ gaŋdarɩ.” ");
INSERT INTO sig_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nɩgyamaa hʋ aa sɩŋ doŋ a nɩɩ taal hʋ, ba badɔmɔŋ baa dɩ duwoŋ nɛ nɔsɔ. Badɔmɔŋ mɛ baa dɩ malɩka rɛ basɩ wɩya tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma wɩya rɛ tɩŋ taal no basɩ gɛɛ, ŋ wɩya daa. ");
INSERT INTO sig_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Saŋa hʋ Wɩɩsɩ aa sɩ di dʋnɩya nala sarɩya pele rɛ. Saŋa no tɩyaŋ nɛ ʋ sɩ kile Sɩtaanɩ, nal hʋ aa yaa dʋnɩya nala kuwori a ta ʋ kuwori kpasa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amɛ dɩ ba aa rɛ ko kpaasɩ ŋ mal daagarɩɩ hʋ nyuu tɩyaŋ, ŋ sɩ kaŋ nala buloŋ ko ŋ lee.” ");
INSERT INTO sig_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ʋ aa basɩ wɩɩ no, sʋʋ hʋ iriŋ ʋ aa sɩ sʋba rɛ ʋ daga gɛɛ.) ");
INSERT INTO sig_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɛɛ rɛ nala hʋ baa, “Ba daga ma á mɩrɩsɩ hʋ tɩyaŋ a baa, ‘Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, ʋ bɩ sɩ sʋba, ʋ sɩ we doŋ deŋdeŋ kɩ mʋ. Ɛɛ rɛ ɩ yaŋ sɩ yaa baa dɩ ba sɩ kaŋ Nihuwobiŋ Biye a kpaasɩ mal daagarɩɩ tɩyaŋ? Aŋnɛ rɛ yaa Nihuwobiŋ Biye no wɩya ɩ aa basɩ?’ ");
INSERT INTO sig_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɛɛ rɛ Yesu basɩ tɩya ba aa baa, “Pʋlʋŋ hʋ bɩ sɩ we ma lee pɩɩsɩ. Pʋlʋŋ hʋ ha aa we doŋ nyɛ, ma kɩ vala pʋlʋŋ hʋ tɩyaŋ, dɩ bilhuu ta pirigi gyʋʋ ma, beewɩya nal hʋ aa vala bilhuu tɩyaŋ, ʋ bɩ gyɩŋ lee hʋ ʋ aa mʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nal hʋ aa tɩya pʋlʋŋ hʋ ha aa we ma lee nyɛ, ma laa ʋ wɩya di. Ɛɛ rɛ ma sɩ yaa nala hʋ aa we pʋlʋŋ tɩyaŋ.” Yesu aa basɩ wɩya no ko teŋ, ʋ sii lɩɩ a kana ʋ tɩɩ faŋa dɩ ba ta na ʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Abee wɩmagɩla hʋ buloŋ ʋ aa yaa ba sɩɩ tɩyaŋ, ka ba ha bɩ laa ʋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ba aa bɩ laa ʋ wɩya di gɛɛ, ɛɛ leŋ wɩya hʋ Wɩɩsɩ tɩŋdaal Azaaya fa aa basa ko yaa wɩtɩɩ rɛ. Ʋ gyɩ baa, “Tɩɩna, aŋnɛ rɛ laa wɩya hʋ ŋ aa basɩ di, aŋnɛ rɛ Wɩɩsɩ daga ʋ dee hʋ tɩya.” ");
INSERT INTO sig_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɛɛ rɛ tɩŋ ba kɔnɩ gyɩ bɩ laa Wɩɩsɩ wɩya di gɛɛ. Beewɩya Azaaya gyɩ bɩl basɩ ba wɩya rɛ abaa, ");
INSERT INTO sig_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wɩɩsɩ tɔɔ ba sɩya rɛ, dɩ ba ta wuwo na kɩŋ buloŋ. a kaŋ ba hakɩllɩ mɛ tɔ, dɩ ba ta wuwo gyɩŋ wɩya memiye. Dɩ gɛɛ fa daa, ba fa sɩ ko Wɩɩsɩ lee dɩ ʋ tɩɩbɩ ba.” ");
INSERT INTO sig_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Azaaya kɛ gyɩ laa sɩya na Yesu gaŋdarɩ aa sɩ kɩɩ gɛɛ rɛ, ɛɛ rɛ tɩŋ ʋ basɩ ʋ wɩya gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Abee gɛɛ buloŋ, Gyuuma nɩhɩyasɩ yʋga gyɩ laa Yesu wɩya di rɛ, ka kambɩŋ gyɩ kaŋ ba Farasiima hʋ wɩya. Ɛɛ rɛ tɩŋ ba bɩ wuwo kyaasɩ basɩ anɩɩ ba laa ʋ wɩya di rɛ. Dɩ ba aa rɛ basɩ gɛɛ, ba fa sɩ kile ba ta ba wɩɩkyʋwaldɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba fa kyo dɩ nala kɩ bigisi ba rɛ a te Wɩɩsɩ aa sɩ kɩ bigisi ba. Ɛɛ rɛ tɩŋ ba fa kaŋ ba laadii faŋa. ");
INSERT INTO sig_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ɛɛ rɛ Yesu heeli basɩ a baa, “Nal hʋ buloŋ aa laa ŋ wɩya di, nal hʋ aa tɩma ŋ wɩya mɛ rɛ ʋ tɩɩna laa di gɛɛ, ŋ dʋŋ wɩya daa. ");
INSERT INTO sig_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nal hʋ buloŋ aa naa ŋ, ʋ tɩɩna naa nal hʋ aa tɩma ŋ mɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ŋ ko tuu dʋnɩya rɛ dɩ ŋ yaa dʋnɩya nala pʋlʋŋ a kyaanɩ tɩya ba. Ɛɛwɩya, nal hʋ buloŋ aa laa ŋ wɩya di, ʋ tɩɩna bɩl bɩ sɩ we bilhuu tɩyaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nal hʋ buloŋ aa nɩɩ ŋ wɩbasɩya aŋ bee tɩŋ ba, ŋ bɩ sɩ di ʋ tɩɩna sarɩya, beewɩya ŋ bɩ ko dɩ ŋ di dʋnɩya nala sarɩya a kpa kyogisi tɩya ba. Amɛ ŋ ko dɩ ŋ laa dʋnɩya nala ta rɛ. ");
INSERT INTO sig_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sarɩdiil lɛ we doŋ ʋ aa sɩ di nal hʋ buloŋ aa vɩya ŋ wɩya sarɩya. Dʋnɩya kyɛtenii ŋ wɩbasɩya rɛ ba sɩ kpa di nal buloŋ aa bɩ laa ŋ wɩya di sarɩya a kpa kyogisi tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wɩtɩɩ rɛ ŋ kɩ basɩ, beewɩya wɩya hʋ ŋ aa basa, ŋ tɩɩ dee tɩyaŋ daa ŋ basɩ ba. Ŋ Kuwo hʋ aa tɩma ŋ, ʋ rɛ daga ŋ wɩya hʋ ŋ aa sɩ basɩ abee ɛɛ hʋ ŋ aa sɩ basɩ ba. ");
INSERT INTO sig_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ŋ gyɩma anɩɩ wɩya hʋ ʋ aa daga ŋ dɩ ŋ basɩ aa tɩya nala mɩɩbol hʋ aa bɩ kaŋ tenii rɛ. Ɛɛwɩya, wɩya hʋ buloŋ ŋ aa basɩ, ŋ Kuwo rɛ daga ŋ.” ");
INSERT INTO sig_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ʋ gyɩ ko ka kyɛdɩgɩ rɛ ka dɩ Gyuuma Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ pele. Yesu gyɩ gyɩma anɩɩ saŋa hʋ ʋ aa sɩ lɩɩ dʋnɩya no tɩyaŋ a mʋ ʋ Kuwo lee pele rɛ. Ʋ gyɩ kyo nala hʋ aa tɩŋa ʋ hal lɛ dʋnɩya no tɩyaŋ weliŋ, ʋ ha sɩ kyo ba a kaŋ kɩ mʋ dʋnɩya tenii. ");
INSERT INTO sig_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kyɛɛ no dɩdaana, Yesu bee ʋ hatɩnna hʋ hɔŋ kɩ di kɩdiiliye. Saŋa no tɩyaŋ dɩ Sɩtaanɩ kɛ foŋ gyʋʋ Siimɔŋ biibaal Gyudasɩ Isɩkarɔtɩ hakɩla tɩyaŋ nɛ dɩ ʋ kpa Yesu yallɩ. ");
INSERT INTO sig_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu gyɩ gyɩma anɩɩ ʋ Kuwo kpaa kɩŋ buloŋ dee rɛ tɩya ʋ. Ʋ tɩɩ fa gyɩma anɩɩ Wɩɩsɩ lee rɛ ʋ lɩɩ ko, ɛɛwɩya ʋ fa gyɩma anɩɩ ʋ bɩl aa mɩɩgɩ ʋ mʋ Wɩɩsɩ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɛɛ rɛ Yesu sii kɩdiiliye hʋ nyuu, a wuri ʋ gabal biŋ, aŋ kpa bɔridʋba vʋwa ʋ tɩŋa, ");
INSERT INTO sig_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","aŋ yaa nɩɩ we kɩŋ tɩyaŋ, a piili kɩ sɔmɔ ʋ hatɩnna hʋ naasɩ aŋ kaŋ bɔrɩdʋba hʋ ʋ aa kpaa vʋwa ʋ tɩŋa a kɩ bɩllɩ ba naasɩ. ");
INSERT INTO sig_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ʋ aa ko pele Siimɔŋ Piita, ɛɛ rɛ Piita pɩyɛsɩ ʋ a baa, “Ŋ Tɩɩna, ɩ aa kyɛ dɩ ɩ sɔmɔ ŋ naasɩ rɛ?” ");
INSERT INTO sig_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu basɩ tɩya ʋ a baa, “Gyɩnaŋ kɛ ɩ bɩ gyɩŋ wɩɩ no ŋ aa yaa memii, amɛ ʋ hal tɩyaŋ ɩ sɩ gyɩma ʋ memii.” ");
INSERT INTO sig_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piita bɩl basɩ tɩya ʋ a baa, “Ŋ bɩ sɩ laa nyʋwa dɩ ɩ sɔmɔ ŋ naasɩ maakyiye kɩdɩgɩ buloŋ.” Ɛɛ rɛ Yesu baa, “Dɩ mɩyaŋ nɛ bɩ sɔmɔ ɩ naasɩ, ŋ beel-ɩ bɩl bɩ sɩ pɛ wɩɩ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ɛɛ rɛ Piita bɩl baa, “Ŋ Tɩɩna, dɩ ɛɛ kɛ rɛ haa, ta sɔmɔ ŋ naasɩ dʋŋ, sɔmɔ ŋ nyuu abee ŋ nosi buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ɛɛ rɛ Yesu baa, “Nal hʋ buloŋ aa foo nɩɩ, ʋ teŋ lee buloŋ aa weliye rɛ, ʋ bɩl bɩ maga dɩ ʋ tɩɩna fo nɩɩ, see dɩ ʋ sɔmɔ ʋ naasɩ dʋŋ. Ma buloŋ yaŋ bɩ kaŋ bisiŋ, amɛ nɩdɩgɩ dʋŋ nɛ kaŋ bisiŋ ma tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu gyɩ gyɩŋ nal hʋ aa sɩ kpa ʋ yallɩ rɛ. Ɛɛ rɛ tɩŋ ʋ baa dɩ ba buloŋ daa kaŋ bisiŋ, dɩ see nɩdɩgɩ dʋŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu aa sɔmɔ ʋ hatɩnna hʋ naasɩ ko teŋ, ʋ bɩl kpa ʋ gabal hʋ laalɩ, a bɩl mʋ hɔŋ ʋ lɩhɔnɩɩ, aŋ pɩyɛsɩ ba a baa, “Ma gyɩŋ wɩɩ no ŋ aa yaa memii rɛ? ");
INSERT INTO sig_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ma kana ŋ kɩ yɩrɩ ma dɩdagɩl lɛ abee ma Tɩɩna. Ʋ yaa ŋmanɩɩ rɛ dɩ ma kɩ yɩrɩ ŋ gɛɛ, beewɩya ŋ kɔnɩ maga gɛɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ŋ aa yaa ma Tɩɩna abee ma dɩdagɩl aŋ sɔmɔ ma naasɩ nyɛ, ʋ maga dɩ ma mɛ kɩ sɔmɔ dɔmɔŋ naasɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ŋ laa sɩya yaa rɛ dɩ ma na, a mɛ wuwo yaa gɛɛ tɩɩ kɩ tɩya dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, yoŋ buloŋ bɩ tee ʋ tɩɩna. Nal ba aa tɩma mɛ bɩ tee nal hʋ aa tɩma ʋ. ");
INSERT INTO sig_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nyɛ kɛ, ma aa gyɩŋ wɩtɩɩ no nyɛ, dɩ mamaa rɛ aa tɩŋa ʋ, Wɩɩsɩ sɩ kyiyeli ma. ");
INSERT INTO sig_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma buloŋ daa ŋ kɩ daga. Ŋ gyɩŋ nala hʋ ŋ aa lɩya rɛ. Amɛ wɩɩ hʋ ba aa saba biŋ Wɩɩsɩ teŋ tɩyaŋ maga dɩ ʋ yaa rɛ. Ba basa anɩɩ ŋ bee nal hʋ aa pɛɛ dɔmɔŋ di kɩdiiliye rɛ sɩ mɩɩgɩ bɩrɩmɩ ŋ dɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ŋ basɩ wɩɩ no kɩ tɩya ma rɛ ka dɩ ʋ na yaa, dɩ gɛɛ rɛ kɔnɩ ko yaa, ma sɩ gyɩma anɩɩ mɩyaŋ nɛ yaa nal hʋ ŋ aa baa ŋ yaa. ");
INSERT INTO sig_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa kaŋ nal hʋ ŋ aa tɩma weliŋ, mɩyaŋ nɛ ʋ tɩɩna kaŋ weliŋ gɛɛ. Nal hʋ mɛ buloŋ aa kana ŋ weliŋ, nal hʋ aa tɩma ŋ mɛ rɛ ʋ tɩɩna kaŋ weliŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu aa basɩ wɩya no ko teŋ, ʋ tɩya buloŋ kyogi kɩŋkaŋ. Ɛɛ rɛ ʋ basɩ polli tɩya ba a baa, “Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma kɩdɩgɩ rɛ sɩ kpa ŋ yallɩ.” ");
INSERT INTO sig_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ɛɛ rɛ ʋ hatɩnna hʋ mɩɩgɩ gal kɩ daasɩ dɔmɔŋ, ka wɩɩ hʋ kperi ba, beewɩya ba gyɩ bɩ gyɩŋ ba nal hʋ ʋ aa dagɩ. ");
INSERT INTO sig_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu hatɩnna hʋ tɩyaŋ nal hʋ wɩya ʋ fa aa kyo kɩŋkaŋ nɛ fa hɔŋ ʋ logiŋ. ");
INSERT INTO sig_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ɛɛ rɛ Siimɔŋ Piita lɔgɩ ʋ anɩɩ ʋ pɩyɛsɩ Yesu na dɩ aŋnɛ rɛ ʋ kɩ daga gɛɛ? ");
INSERT INTO sig_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ɛɛ rɛ hatɩnnɩ hʋ fa aa hɔŋ Yesu logiŋ hʋ marɩ fasɩ mʋ kpaga Yesu a pɩyɛsɩ ʋ a baa, “Ŋ Tɩɩna, aŋnɛ rɛ?” ");
INSERT INTO sig_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ɛɛ rɛ Yesu baa, “Ŋ aa sɩ kpa paanʋʋ hʋ yuu dɩsɩ a tɩya nal hʋ, ʋ rɛ gɛɛ.” Ɛɛ rɛ ʋ kpaa paanʋʋ hʋ a yuu dɩsɩ a kpa tɩya Gyudasɩ, Siimɔŋ Isɩkarɔtɩ biibaal hʋ. ");
INSERT INTO sig_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gyudasɩ aa yɩya laa paanʋʋ hʋ teŋ, Sɩtaanɩ ko gyʋʋ ʋ. Ɛɛ rɛ Yesu basɩ tɩya ʋ, “Wɩɩ hʋ ɩ aa kyɛ dɩ ɩ yaa, kɩ yaa lagɩ lagɩ.” ");
INSERT INTO sig_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nɩkaalɩya hʋ buloŋ fa aa di kɩdiiliye hʋ gyɩ bɩ gyɩŋ wɩɩ hʋ aa tɩŋ ʋ fa basɩ gɛɛ tɩya Gyudasɩ. ");
INSERT INTO sig_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gyudasɩ rɛ fa aa biŋ ba molbiye. Ɛɛ wɩya Yesu hatɩnna hʋ badɔmɔŋ kɛ fa bɩɩna anɩɩ Yesu fa aa kyɛ dɩ Gyudasɩ mʋ yɔbɔ kɩna hʋ ba aa sɩ di rɛ gbɩyala hʋ tɩyaŋ, koo ʋ baa ʋ kaŋ kɩŋ nɛ a lɩɩ tɩya nyaaba. ");
INSERT INTO sig_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gyudasɩ aa laa paanʋʋ hʋ teŋ, ʋ nyagɩ sii lɩɩ lagɩ lagɩ. Saŋa no tɩyaŋ dɩ lee gyɩ bile rɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gyudasɩ aa lɩya ko teŋ, ɛɛ rɛ Yesu baa, “Nyɛ kɛ, Wɩɩsɩ daga mɩyaŋ Nihuwobiŋ Biye gaŋdarɩ rɛ a tɩya nala. Ʋ sɩ tɩŋa ŋ tɩyaŋ a leŋ dɩ nala na ʋ gaŋdarɩ.” ");
INSERT INTO sig_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɛɛ rɛ Yesu bɩl baa, “Dɩ Wɩɩsɩ rɛ si tɩŋa ŋ tɩyaŋ a daga ʋ gaŋdarɩ aa maga gɛɛ, ɛɛ tɩɩ rɛ Wɩɩsɩ sɩ tɩŋa ʋ tɩɩ mɛ tɩyaŋ a daga mɩyaŋ Nihuwobiŋ Biye gaŋdarɩ aa maga gɛɛ. Ʋ bɩ sɩ pɩɩsɩ ka dɩ ʋ yaa wɩya no buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ŋ nikyooliye, ŋ bɩl bɩ sɩ we ma lee pɩɩsɩ. Ma sɩ deŋ kyɛ ŋ. Amɛ, wɩɩ hʋ ŋ aa basɩ tɩya Gyuuma nɩhɩyasɩ hʋ, ʋ tɩɩ rɛ ŋ basɩ kɩ tɩya ma mɛ. Lee hʋ ŋ aa sɩ mʋ, ma bɩ sɩ wuwo mʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mɩrɩfalɩɩ rɛ ŋ biŋ kɩ tɩya ma. Ʋ rɛ nyɛ: Ma kyo dɔmɔŋ, anɩɩ ŋ aa kyo ma gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Dɩ mamaa rɛ kyo dɔmɔŋ, ɛɛ tɩyaŋ nɛ nala buloŋ sɩ tɩŋa a gyɩma anɩɩ ma kɔnɩ yaa ŋ hatɩnna rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ɛɛ rɛ Siimɔŋ Piita pɩyɛsɩ Yesu a baa, “Ŋ Tɩɩna, lee rɛ ɩ kɩ mʋ?” Ɛɛ rɛ Yesu mɛ basɩ tɩya ʋ a baa, “Lee hʋ ŋ aa mʋʋ lagɩlagɩ no, ɩ bɩ sɩ wuwo tɩŋa ŋ mʋ doŋ, amɛ ŋ mʋyɩ hal tɩyaŋ nɛ ɩ sɩ wuwo kile ŋ lugo.” ");
INSERT INTO sig_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ɛɛ rɛ Piita bɩl pɩyɛsɩ ʋ a baa, “Ŋ Tɩɩna, bee rɛ tɩŋ ŋ bɩ sɩ wuwo tɩŋa ɩ hal lagɩlagɩ no? Ŋ paalɩ yaa siri rɛ dɩ ŋ kpa ŋ mɩɩbol lenni sʋʋ ɩ wɩya.” ");
INSERT INTO sig_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ɩ kɔnɩ yaa siri dɩ ɩ kpa ɩ mɩɩbol lenni sʋʋ ŋ wɩya rɛ? Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, ka dɩ gyibal na wii gyɩnaŋ, ɩ sɩ tʋwa naaŋsɩɩnyʋwa bʋto anɩɩ ɩ bɩ gyɩma ŋ.” ");
INSERT INTO sig_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ɛɛ rɛ Yesu baa, “Ma ta leŋ dɩ ma tɩsɩ kyogi. Ma laa Wɩɩsɩ di, a laa ŋ mɛ di. ");
INSERT INTO sig_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ŋ Kuwo bee tɩyaŋ dɩɩgyamaa rɛ we doŋ. Dɩ gɛɛ fa daa, ŋ fa bɩ sɩ basɩ tɩya ma anɩɩ ŋ sɩ mʋ marɩ lee a biŋ ma. ");
INSERT INTO sig_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dɩ mɩyaŋ nɛ mʋwa a marɩ lee hʋ biŋ ma ko teŋ, ŋ sɩ mɩɩgɩ ko a kaŋ ma mʋ ŋ lee dɩ á buloŋ we lɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lee hʋ mɛ ŋ aa sɩ mʋ, ma gyɩŋ ŋmanɩɩ hʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ɛɛ rɛ Tɔmaasɩ basɩ tɩya ʋ a baa, “Á Tɩɩna, á bɩ gyɩŋ lee hʋ ɩ aa mʋʋ, ɛɛ rɛ á sɩ wuwo yaa gyɩŋ ʋ ŋmanɩɩ?” ");
INSERT INTO sig_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Mɩyaŋ nɛ yaa ŋmanɩɩ hʋ, abee Wɩɩsɩ wɩtɩɩ, a kɩ tɩya mɩɩbol mɛ. Nal buloŋ bɩ sɩ wuwo mʋ ŋ Kuwo lee, dɩ ʋ tɩɩna bɩ tɩŋa ŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dɩ mamaa rɛ kɔnɩ gyɩma ŋ, ma sɩ gyɩŋ ŋ Kuwo mɛ. A lɩɩ gyɩnaŋ kaŋ kɩ mʋ, ma paalɩ gyɩma ʋ rɛ, a na ʋ mɛ.” ");
INSERT INTO sig_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ɛɛ rɛ Fɩlɩpɩ basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, daga ma Kuwo hʋ, wɩɩ hʋ á aa kyɛɛ buloŋ nɛ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Fɩlɩpɩ, ŋ beel-ma buloŋ sɩ we doŋ a pɩɩsɩ maga nyɛ, ka ɩ ha bɩ gyɩma ŋ? Nal hʋ buloŋ aa naa ŋ, ʋ tɩɩna naa ŋ Kuwo mɛ rɛ. Bee rɛ yaŋ tɩŋ ɩ baa dɩ ŋ daga ma ŋ Kuwo? ");
INSERT INTO sig_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɩ bɩ laa di anɩɩ ŋ bee ŋ Kuwo buloŋ yaa kɩdɩgɩ rɛ koo? Wɩya hʋ buloŋ ŋ aa basɩ tɩya ma, ŋ tɩɩ dee tɩyaŋ daa ŋ basɩ ba. Wɩya hʋ mɛ ŋ aa yaa, ŋ Kuwo tɩɩ rɛ tɩŋa ŋ ŋ kɩ yaa ba gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ma laa di anɩɩ ŋ aa baa ŋ bee ŋ kuwo buloŋ yaa kɩdɩgɩ rɛ. Dɩ mamaa bɩ sɩ laa ŋ di akuu ŋ aa baa ŋ bee ŋ kuwo yaa kɩdɩgɩ wɩya, amɛ ma laa ŋ di akuu wɩya hʋ ŋ aa yaa nyubaanɩŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, nal hʋ buloŋ aa laa ŋ wɩya di, ʋ tɩɩna sɩ wuwo kɩ yaa wɩya hʋ ŋ aa yaa. Ʋ tɩɩna gba sɩ paalɩ wuwo yaa wɩya a te wɩya hʋ ŋ aa yaa, beewɩya ŋ aa mʋʋ ŋ Kuwo lee rɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wɩɩ kɛ buloŋ ma aa sʋla kɩ kyɛ ŋ feŋ tɩyaŋ, ŋ sɩ yaa tɩya ma. Ŋ sɩ yaa gɛɛ dɩ nala tɩŋa ŋ tɩyaŋ a na ŋ Kuwo gaŋdarɩ aa maga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dɩ mamaa rɛ sʋla kɩ kyɛ wɩɩ buloŋ ŋ feŋ tɩyaŋ, ŋ sɩ yaa tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ɛɛ rɛ Yesu bɩl baa, “Dɩ mamaa rɛ kyo ŋ, ma sɩ kɩ tɩŋa ŋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dɩ mamaa rɛ aa yaa gɛɛ, ŋ sɩ sʋla ŋ Kuwo dɩ ʋ kpa kyɩkyagɩl kɩdɩgɩ mɛ tɩya ma. Ʋ sɩ we ma lee a kaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ʋ rɛ yaa Wɩɩsɩ Wiyesi Welii hʋ aa daga ma Wɩɩsɩ aa kɩɩ gɛɛ. Dʋnɩya nala bɩ sɩ wuwo laa ʋ we ba tɩsɩ tɩyaŋ, beewɩya ba bee na ʋ, ba bɩ gyɩma ʋ mɛ. Amɛ ma kɛ gyɩma ʋ rɛ. Beewɩya ʋ we ma lee rɛ, a we ma tɩsɩ tɩyaŋ a kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Dɩ mɩyaŋ nɛ ko mʋ, ŋ bɩ sɩ vɩya ma ta dɩ ma kɩɩ gɛɛ anɩɩ busuluŋbiisi. Ŋ sɩ mɩɩgɩ ko ma lee. ");
INSERT INTO sig_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ʋ kaa mʋhʋ ka dʋnɩya nala bɩl bɩ sɩ na ŋ, amɛ ma kɛ sɩ na ŋ. Ŋ aa sɩ kaŋ mɩɩbol wɩya, ma mɛ sɩ kaŋ mɩɩbol. ");
INSERT INTO sig_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kyɛɛ hʋ ŋ aa sɩ sii sʋʋ tɩyaŋ a bɩl kaŋ mɩɩbol, haŋ kyɛɛ hʋ rɛ ma sɩ gyɩma nɩɩ ŋ beel-ma yaa kɩdɩgɩ rɛ anɩɩ ŋ bee ŋ kuwo aa yaa kɩdɩgɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nal hʋ buloŋ aa nɩɩ ŋ nyʋwa, a kɩ tɩŋa ŋ, ʋ tɩɩna rɛ kyo ŋ. Ŋ Kuwo mɛ yaŋ sɩ kyo nal hʋ aa kyo ŋ. Ŋ mɛ sɩ kyo tɩɩna a kaŋ ŋ tɩɩ daga ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ɛɛ rɛ Gyudasɩ baa “Ŋ Tɩɩna, ɛɛ rɛ ɩ sɩ yaa a kaŋ ɩ tɩɩ daga ma, aŋ bɩ sɩ kaŋ ɩ tɩɩ daga dʋnɩya nala.” (Gyudasɩ no daa yaa Isɩkarɔtɩ biibaal hʋ). ");
INSERT INTO sig_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nyɛ rɛ Yesu basɩ tɩya ʋ a baa, “Nal hʋ buloŋ aa kyo ŋ, ʋ sɩ kɩ tɩŋa ŋ nyʋwa. Ŋ Kuwo mɛ sɩ kyo ʋ. Ŋ bee ŋ Kuwo buloŋ sɩ ko we ʋ tɩɩna lee. ");
INSERT INTO sig_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nal hʋ buloŋ aa bɩ kyo ŋ, ʋ bee tɩŋa ŋ nyʋwa. Wɩya hʋ buloŋ ŋ aa daga ma bɩ yaa ŋ tɩɩ wɩdagɩya. Amɛ ba lɩɩ ŋ kuwo aa tɩma ŋ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ŋ ha aa we ma lee rɛ tɩŋ ŋ basɩ wɩya no kɩ tɩya ma nyɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amɛ kyɩkyagɩl hʋ ŋ Kuwo aa sɩ tɩma ŋ feŋ tɩyaŋ, ʋ rɛ yaa ʋ Wiyesi Welii hʋ. Ʋ sɩ kɩ pɛ ma tɩyaŋ a daga ma wɩɩ buloŋ, a leŋ dɩ ma kɩ liisi wɩya hʋ buloŋ ŋ aa basɩ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Fɩyɛlʋʋ we ma lee. Ŋ fɩyɛlʋʋ hʋ ŋ aa kana tɩɩ rɛ ŋ kpaa kɩ tɩya ma. Fɩyɛlʋʋ no ŋ aa kpaa kɩ tɩya ma, ʋ bee dʋnɩya nala fɩyɛlʋʋ bɩ kɩɩ dɔmɔŋ. Ma ta leŋ dɩ ma hakɩllɩ kɩ viisi, a ta leŋ dɩ kambɩŋ mɛ kaŋ ma akuu wɩɩ hʋ aa sɩ puu ma wɩya. ");
INSERT INTO sig_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ŋ basɩ tɩya ma rɛ a baa, ‘Ŋ aa mʋʋ rɛ ka dɩ ŋ bɩl mɩɩgɩ ko ma lee.’ Dɩ mamaa rɛ fa kyo ŋ, ma tenni fa sɩ fɩyɛlɩ, ŋ aa mʋʋ ŋ kuwo lee nyɛ wɩya, beewɩya ʋ rɛ tee ŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ŋ basɩ wɩya no buloŋ kɩ tɩya ma rɛ, ka dɩ ba na yaa. Dɩ ba aa rɛ ko kɩ yaa, ma sɩ laa di anɩɩ wɩya hʋ buloŋ ŋ aa basɩ kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ŋ bɩ sɩ wuwo basɩ wɩya ma lee pɩɩsɩ, beewɩya dʋnɩya kuwori hʋ aa ko rɛ. Amɛ ʋ bɩ kaŋ ŋ dee wɩɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amɛ ŋ aa kyɛ dɩ dʋnɩya nala gyɩma rɛ anɩɩ ŋ kyo ŋ Kuwo rɛ. Ɛɛ rɛ tɩŋ ŋ kɩ yaa wɩya hʋ buloŋ ʋ aa baa dɩ ŋ yaa. Ma sii dɩ á lɩɩ daha tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ɛɛ rɛ Yesu baa, “Mɩyaŋ nɛ yaa tɩya hʋ tɩɩ. Ŋ Kuwo mɛ rɛ aa deŋ tɩya hʋ. ");
INSERT INTO sig_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tɩya hʋ naaŋ buloŋ aa bee nɔnɔ, ʋ aa keri keri ta rɛ, a marɩ marɩ tɩya hʋ we, dɩ ʋ wuwo kɩ nɔnɔ yʋga. ");
INSERT INTO sig_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma tɩsɩ kɛ bɩl bɩ kaŋ bisiŋ buloŋ, akuu wɩya hʋ ŋ aa basɩ tɩya ma nyuniŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ma mal ŋ tɩyaŋ dɩ ŋ mɛ mal ma tɩyaŋ. Tɩya naasɩ dʋŋ bɩ sɩ wuwo nɔnɔ, see dɩ ba mal tɩya hʋ maŋkpaŋ tɩyaŋ. Ma mɛ bɩ sɩ wuwo yaa wɩɩ buloŋ, dɩ ma bɩ mal ŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ɛɛ rɛ Yesu bɩl baa, “Mɩyaŋ nɛ yaa tɩya hʋ, mamaa mɛ rɛ yaa tɩya hʋ naasɩ. Nal hʋ buloŋ aa mal ŋ tɩyaŋ, ŋ mɛ mal tɩɩna tɩyaŋ nɛ. Ɛɛ rɛ sɩ wuwo leŋ dɩ ʋ yaa wɩweliye weliŋ, beewɩya dɩ mamaa rɛ bɩ mal ŋ, ma bɩ sɩ wuwo yaa wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dɩ nal lɛ bɩ mal ŋ tɩyaŋ, ba sɩ kpa tɩɩna yuwo ta anɩɩ ba aa keri tɩya naasɩ ta, ba hɩla, ba paa yuwo we diŋ tɩyaŋ ba di gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dɩ ma mal ŋ tɩyaŋ, a leŋ dɩ wɩya hʋ ŋ aa basɩ tɩya ma we ma tɩsɩ tɩyaŋ, wɩɩ hʋ buloŋ ma aa sʋla ŋ kɩ kyɛ, ŋ sɩ yaa tɩya ma. ");
INSERT INTO sig_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dɩ mamaa rɛ aa yaa wɩweliye yʋga, ɛɛ rɛ ŋ Kuwo feŋ sɩ yɩrɩ. Ɛɛ mɛ rɛ sɩ daga anɩɩ ma yaa ŋ hatɩnna rɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ŋ kyo ma rɛ anɩɩ ŋ Kuwo aa kyo ŋ gɛɛ. Ɛɛwɩya, ma mal ŋ tɩyaŋ dɩ ŋ kyo ma a kaŋ kɩ mʋ deŋdeŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Dɩ mamaa rɛ aa tɩŋa ŋ nyʋwa, ŋ sɩ kyo ma a kaŋ kɩ mʋ deŋdeŋ, anɩɩ ŋ aa tɩŋ ŋ Kuwo nyʋwa, a mal ʋ tɩyaŋ ʋ kyo ŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ŋ basɩ wɩya no tɩya ma rɛ dɩ ma wuwo na teŋfɩyɛlʋʋ hʋ ŋ aa kpaa tɩya ma. Ɛɛ mɛ rɛ ma tenni sɩ marɩ fɩyɛlɩ weliŋ a mʋ teŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wɩɩ hʋ ŋ aa kpaa kɩ tɩya ma rɛ nyɛ: Ma kyo dɔmɔŋ anɩɩ ŋ aa kyo ma gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dɩ nal lɛ yaa siri dɩ ʋ kpa ʋ mɩɩbol yɔbɔ sʋʋ ʋ kyana wɩya, ɛɛ daga anɩɩ ʋ kyo ʋ rɛ a te wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dɩ mamaa rɛ aa yaa wɩya hʋ ŋ aa basɩ tɩya ma dɩ ma kɩ yaa, ma sɩ yaa ŋ kyaŋsɩ. ");
INSERT INTO sig_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ŋ bɩl bɩ kaŋ ma kɩ yɩrɩ ŋ tʋŋtʋnna, beewɩya tʋŋtʋnnɩ bɩ gyɩŋ wɩɩ hʋ ʋ nɩhɩyawʋ aa yaa. Amɛ ŋ kaŋ ma kɩ yɩrɩ ŋ kyaŋsɩ rɛ, beewɩya wɩya hʋ buloŋ ŋ kuwo aa basɩ tɩya ŋ, ŋ mɛ basɩ ba tɩya ma rɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma daa lɩɩ ŋ, mɩyaŋ nɛ lɩɩ ma. Ŋ lɩɩ ma rɛ dɩ ma mʋ a marɩ kɩ yaa wɩweliye, wɩweliye hʋ aa bɩ sɩ maakyiye nyʋgɩsɩ. Dɩ mamaa rɛ aa yaa gɛɛ, ŋ Kuwo sɩ tɩya ma kɩŋ buloŋ ma aa sʋla kɩ kyɛ ŋ feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wɩɩ hʋ ŋ aa basɩ tɩya ma dɩ ma kɩ yaa rɛ nyɛ: Ma kyo dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Dɩ dʋnɩya nala rɛ haasɩ ma, ma gyɩma anɩɩ ba laa sɩya haasɩ ŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dɩ mamaa rɛ fa yaa dʋnɩya nala, dʋnɩya nala fa sɩ kyo ma rɛ weliŋ anɩɩ ba aa kyo dɔmɔŋ gɛɛ. Amɛ ma bee dʋnɩya nala bɩ yaa kɩdɩgɩ. Ŋ lɩɩ ma dʋnɩya nala tɩyaŋ nɛ, ɛɛ rɛ tɩŋ ba haasɩ ma. ");
INSERT INTO sig_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ŋ laa sɩya basɩ tɩya ma rɛ anɩɩ yoŋ bɩ sɩ wuwo te ʋ tɩɩna. Ma liisi wɩɩ no na. Ba aa dɔgɩsɩ ŋ gɛɛ, gɛɛ tɩɩ rɛ ba sɩ dɔgɩsɩ ma mɛ. Dɩ ba aa rɛ fa laa ŋ nyʋwa, ba fa sɩ laa ma mɛ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba sɩ yaa wɩya no buloŋ akuu ma aa tɩŋa ŋ hal wɩya. Ba bɩ gyɩŋ nal hʋ aa tɩma ŋ, ɛɛ rɛ tɩŋ ba kɩ yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dɩ mɩyaŋ nɛ fa bɩ ko basɩ wɩya tɩya ba, ba aa yaa wɩbɔmɔ hʋ buloŋ, ŋ fa bɩ sɩ wuwo baa dɩ ba kyogi wɩɩ buloŋ. Amɛ ŋ foŋ aa ko basɩ wɩya tɩya ba wɩya, ba bɩl bɩ sɩ wuwo baa dɩ ba fa bɩ gyɩma. ");
INSERT INTO sig_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nal hʋ aa haasɩ ŋ, tɩɩna haasɩ ŋ Kuwo mɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wɩya hʋ buloŋ ŋ aa yaa, nal buloŋ bɩ yaa ba. Dɩ mɩyaŋ nɛ fa bɩ yaa ba dɩ ba na, ba fa bɩ sɩ kaŋ wɩkyogii buloŋ. Amɛ ba naa ba buloŋ nɛ aŋ ha haasɩ ŋ bee ŋ Kuwo buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba aa haasɩ ŋ gɛɛ, wɩya hʋ buloŋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ kɔnɩ yaa wɩtɩɩ rɛ. Nyɛ rɛ ba sabɩ, ‘Ŋ bɩ yaa wɩɩ buloŋ kyogi, ka ba haasɩ ŋ.’ ");
INSERT INTO sig_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Amɛ ŋ sɩ leŋ dɩ Wɩɩsɩ Wiyesi Welii hʋ lɩɩ ŋ Kuwo lee a ko tuu we ma tɩyaŋ. Ʋ sɩ pɛ ma tɩyaŋ a daga ma wɩtɩɩ hʋ. Ʋ rɛ sɩ marɩ basɩ ŋ wɩya tɩya ma. ");
INSERT INTO sig_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma mɛ sɩ basɩ ŋ wɩya tɩya nala, beewɩya ma we ŋ lee rɛ a lɩɩ saŋa hʋ ŋ aa piile kɩ daga nala buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ŋ basɩ wɩya no buloŋ tɩya ma rɛ dɩ ma ta ko mɩɩgɩ hal ma laadii tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba sɩ kile ma ta Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ. Saŋa kɩdɩgɩ sɩ pele, dɩ nal lɛ ko kpʋ ma kɩdɩgɩ buloŋ, ʋ tɩɩna aa bɩɩnɩ anɩɩ Wɩɩsɩ ŋmanɩɩ rɛ ʋ kɩ tɩŋa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba sɩ yaa ma wɩya no buloŋ, beewɩya ba bɩ gyɩma ŋ Kuwo, a bɩ gyɩma ŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ŋ laa sɩya basɩ wɩya no buloŋ nɛ a tɩya ma, dɩ saŋa hʋ rɛ ko pele dɩ wɩya no kɩ yaa, ma sɩ liisi anɩɩ ŋ gyɩ basɩ ba tɩya ma rɛ. Ŋ gyɩ aa we ma lee rɛ tɩŋ ŋ bɩ basɩ wɩya no tɩya ma piili hʋ tɩyaŋ buloŋ ma aa ko yaa ŋ hatɩnna. ");
INSERT INTO sig_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Amɛ nyɛ kɛ, ŋ aa mʋ nal hʋ aa tɩma ŋ lee rɛ, aŋka ma kɩdɩgɩ buloŋ ha bɩ pɩyɛsɩ ŋ anɩɩ lee rɛ ŋ kɩ mʋ? ");
INSERT INTO sig_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ŋ aa basɩ wɩya no tɩya ma nyɛ, lagɩlagɩ no ma tɩsɩ kyogo rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Amɛ wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma. Akuu ma wɩya, ŋ aa mʋwa rɛ kpɩya. Beewɩya dɩ mɩyaŋ nɛ bɩ mʋwa, kyɩkyagɩl hʋ bɩ sɩ ko ma lee. Amɛ dɩ ŋ ko mʋ ŋ sɩ ta ʋ dɩ ʋ ko ma lee. ");
INSERT INTO sig_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Dɩ ʋ rɛ yaŋ ko ko, ʋ sɩ leŋ dɩ dʋnɩya nala gyɩma anɩɩ ba nyɩya rɛ ba aa baa ba gyɩŋ wɩɩ hʋ aa yaa wɩbɔŋ, a gyɩŋ wɩɩ hʋ aa kpaa ŋmanɩɩ mɛ, abee ba aa baa ba gyɩŋ Wɩɩsɩ sarɩya kyɛdiilii hʋ mɛ wɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ba bɩ gyɩŋ wɩɩ hʋ aa yaa wɩbɔŋ, beewɩya ba bɩ laa ŋ wɩya di. ");
INSERT INTO sig_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ba bɩ gyɩŋ wɩɩ hʋ aa kpaa ŋmanɩɩ mɛ beewɩya ŋ mɩɩgɩ kɩ mʋ ŋ Kuwo lee rɛ, ma bɩl bɩ sɩ maakyiye na ŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ba bɩ gyɩŋ Wɩɩsɩ sarɩya hʋ kyɛdiilii mɛ wɩya beewɩya Wɩɩsɩ foŋ di dʋnɩya kuwori (Sɩtaanɩ) sarɩya rɛ ʋ tele. ");
INSERT INTO sig_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ŋ ha kaŋ wɩya yʋga rɛ ŋ aa sɩ basɩ tɩya ma, amɛ ma bɩ kaŋ bembii ma aa sɩ nɩɩ ba buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Amɛ dɩ Wɩɩsɩ Wiyesi Welii hʋ aa daga ma gɛɛ hʋ Wɩɩsɩ aa kɩya rɛ ko ko, ʋ sɩ leŋ dɩ ma gyɩŋ wɩtɩɩ hʋ buloŋ aa we Wɩɩsɩ lee. Ʋ bɩ sɩ kɩ basɩ wɩya ʋ tɩɩ dee tɩyaŋ, amɛ wɩya hʋ buloŋ ʋ aa sɩ nɩɩ, ba aa rɛ ʋ sɩ basɩ. Ʋ mɛ sɩ daga ma wɩya hʋ buloŋ aa sɩ maakyiye yaa. ");
INSERT INTO sig_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wɩya hʋ buloŋ ŋ aa kana dɩ ŋ basɩ tɩya ma, ʋ sɩ kaŋ ko basɩ tɩya ma dɩ gɛɛ wuwo leŋ dɩ nala na ŋ gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kɩŋ hʋ buloŋ ŋ Kuwo a kana yaa ŋ kɩŋ nɛ. Ɛɛ rɛ tɩŋ ŋ basɩ tɩya ma anɩɩ wɩya hʋ buloŋ ŋ aa kana dɩ ŋ basɩ, ŋ sɩ kpa tɩya Wiyesi Welii hʋ dɩ ʋ ko basɩ tɩya ma gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Mʋhʋ sʋwaa, ma bɩl bɩ sɩ na ŋ, amɛ ʋ kyɛyɛ baŋmana hal, ma bɩl sɩ na ŋ.” ");
INSERT INTO sig_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ɛɛ rɛ ʋ hatɩnna hʋ badɔmɔŋ kɩ pɩyɛsɩ dɔmɔŋ a baa, “Wɩɩ no memii rɛ yaa bee? Ʋ basɩ tɩya ma anɩɩ mʋhʋ sʋwaa á bɩ sɩ na ʋ amɛ dɩ ʋ kyɛyɛ baŋmana hal dɩ á bɩl sɩ na ʋ. Ʋ bɩl baa ʋ aa sɩ mʋ ʋ kuwo lee rɛ tɩŋ á bɩl bɩ sɩ na ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ʋ aa baa kyɛyɛ baŋmana no, ʋ memii rɛ yaa bee? Á bɩ gyɩŋ wɩɩ no ʋ aa basɩ memii.” ");
INSERT INTO sig_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu gyɩma anɩɩ ba aa kyɛ dɩ ba pɩyɛsɩ ʋ gyɩŋ wɩɩ no memii rɛ. Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ŋ aa baa dɩ mʋhʋ sʋwaa ma bɩ sɩ na ŋ, ka dɩ kyɛyɛ baŋmana hal dɩ ma bɩl na ŋ hʋ wɩya rɛ ma kɩ pɩyɛsɩ dɔmɔŋ nyɛ koo? ");
INSERT INTO sig_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ma sɩ wii gʋwagɩ sɩnɩɩl, amɛ dʋnɩya nala tenni kɛ sɩ fɩyɛlɩ. Ma tɩsɩ sɩ kyogi, amɛ ma tɩkyogi hʋ sɩ mɩɩgɩ bɩrɩmɩ teŋfɩyɛlʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Dɩ haaŋ halʋllɩ-luwol lɛ ko kɩ wɩɩ, ʋ tɩya aa kyogi rɛ, beewɩya ʋ gyɩma tʋwara puu ʋ rɛ. Amɛ dɩ ʋ rɛ ko lʋl biye hʋ teŋ, ʋ aa yeŋŋi ʋ tʋwara hʋ buloŋ nɛ, a kuu ʋ aa lʋla biifalɩɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɛɛ rɛ ʋ yaŋ kɩɩ ma tɩyaŋ mɛ. Nyɛ kɛ, ma tɩsɩ kyogo rɛ, amɛ ŋ bɩl sɩ na ma, a leŋ dɩ ma tenni fɩyɛlɩ fɩyɛlɩɩ hʋ iriŋ nal buloŋ aa bɩ sɩ wuwo leŋ dɩ ʋ lɩɩ ma kɩdɩgɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Dɩ kyɛɛ hʋ rɛ ko pele, ma bɩ sɩ pɩyɛsɩ ŋ kɩ kyɛ wɩɩ buloŋ. Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ma, ŋ Kuwo sɩ tɩya ma kɩŋ hʋ buloŋ ma aa sʋla ʋ kɩ kyɛ ŋ feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Abee gyɩnaŋ, ma ha bɩ sʋla ʋ a kyɛ kɩŋ buloŋ ŋ feŋ tɩyaŋ. Ɛɛwɩya, ma yaŋ sʋla ʋ, ʋ sɩ kpa kɩŋ hʋ ma aa sʋla ʋ kɩ kyɛ tɩya ma dɩ ma tenni fɩyɛlɩ a mʋ teŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Wɩya no buloŋ ŋ aa basɩ tɩya ma, namagɩsɩ rɛ ŋ kɩ maga. Amɛ saŋa kɩdɩgɩ sɩ pele, ŋ bɩl bɩ sɩ maga namagɩsɩ, ŋ sɩ basɩ ŋ kuwo wɩya polli tɩya ma. ");
INSERT INTO sig_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dɩ haŋ kyɛɛ hʋ rɛ ko pele, ma sɩ sʋla ʋ kɩ kyɛ kɩna ŋ feŋ tɩyaŋ. Ŋ bɩ baa mɩyaŋ nɛ sɩ sʋla ʋ tɩya ma, ");
INSERT INTO sig_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","beewɩya ŋ Kuwo tɩɩ mɛ kyo ma rɛ. Ma kyo ŋ nɛ, a laa ŋ wɩya di anɩɩ ŋ lɩɩ ʋ lee rɛ. Ɛɛ rɛ tɩŋ ʋ mɛ kyo ma gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ŋ lɩɩ ŋ Kuwo lee rɛ a ko tuu dʋnɩya. Nyɛ kɛ, ŋ yaŋ sɩ lɩɩ dʋnɩya no tɩyaŋ a mɩɩgɩ mʋ ŋ Kuwo lee.” ");
INSERT INTO sig_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ɛɛ rɛ ʋ hatɩnna hʋ basɩ tɩya ʋ a baa, “Nyɛ kɛ, ɩ kyaasɩ basɩ wɩya kɩ polli rɛ. Ɩ bɩl bee maga namagɩsɩ. ");
INSERT INTO sig_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nyɛ kɛ, á gyɩma anɩɩ ɩ gyɩŋ wɩɩ buloŋ aa we nihuwobiŋ hakɩla tɩyaŋ nɛ, ɛɛwɩya ɩ bɩl bɩ maga dɩ ɩ pɩyɛsɩ nal wɩɩ buloŋ. Nyɛ leŋ á gyɩma anɩɩ ɩ lɩɩ Wɩɩsɩ lee rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Nyɛ kɛ ma yaŋ laa ŋ wɩya di rɛ koo? ");
INSERT INTO sig_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saŋa kɩdɩgɩ sɩ pele, ʋ gba pele mɛ rɛ, dɩ ma buloŋ fá pɩsa mʋ ma dɩɩsɩ, aŋ ka ŋ dʋŋ. Amɛ ŋ bɩ sɩ yaa ŋ dʋŋ beewɩya ŋ Kuwo we ŋ lee rɛ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ŋ basɩ wɩya no kɩ tɩya ma rɛ, dɩ ŋ beel-ma yaa kɩdɩgɩ dɩ ma wuwo tɩŋ ŋ tɩyaŋ a na fɩyɛlʋʋ. Dʋnɩya no tɩyaŋ ma sɩ na tʋwara. Amɛ ma kaŋ ma tɩɩ, beewɩya ŋ yuwo di dʋnɩya rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu aa basɩ wɩya no ko teŋ, ʋ wil deŋ wɩɩsɩnyuu aŋ baa, “Ŋ Kuwo, saŋa hʋ pele rɛ. Leŋ dɩ dʋnɩya nala na mɩyaŋ ɩ biye hʋ gaŋdarɩ dɩ ŋ mɛ leŋ dɩ ba na ɩ gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ɩ rɛ kpaa dʋnɩya nala wɩɩ buloŋ dee a we ŋ nosi tɩyaŋ, dɩ ŋ kpa mɩɩbol hʋ aa bɩ kaŋ tenii a tɩya nala hʋ ɩ aa leŋ ba yaa ŋ hatɩnna. ");
INSERT INTO sig_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nala hʋ aa gyɩma anɩɩ ɩ dʋŋ nɛ kɔnɩ yaa Wɩɩsɩ, aŋ pɛ gyɩŋ mɩyaŋ Yesu Krisita, laataal hʋ mɛ ɩ aa tɩma, ba aa rɛ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ŋ daga ɩ gaŋdarɩ rɛ dʋnɩya tɩyaŋ daha, beewɩya tʋma hʋ ɩ aa kpaa tɩya ŋ, ŋ tʋŋ ba buloŋ teŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ŋ kuwo tɩya ŋ gaŋdarɩ ɩ sɩya tɩyaŋ lagɩlagɩ no. Gaŋdarɩ hʋ ŋ fa aa kana ɩ lee ka ɩ na marɩ dʋnɩya hʋ. ");
INSERT INTO sig_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nala hʋ ɩ aa lɩɩ tɩya ŋ dʋnɩya nala tɩyaŋ, ŋ leŋ ba gyɩma ɩ rɛ. Ba fa yaa ɩ nala rɛ, ka ɩ kpa ba tɩya ŋ. Ba laa ɩ wɩya di rɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ɛɛwɩya, lagɩlagɩ no, ba gyɩma anɩɩ kɩna hʋ buloŋ ŋ aa kana lɩɩ ɩ lee rɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Duwoso hʋ ɩ aa kpaa tɩya ŋ, ŋ basɩ tɩya ba rɛ. Ba laa di rɛ a gyɩma anɩɩ wɩtɩɩ rɛ, ŋ kɔnɩ lɩɩ ɩ lee rɛ. Ba laa di mɛ rɛ anɩɩ ɩ rɛ tɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nala hʋ ɩ aa lɩɩ tɩya ŋ dʋŋ wɩya rɛ ŋ kɩ sʋla ɩ, beewɩya ba aa rɛ yaa ɩ nala. Dʋnɩya nala buloŋ wɩya daa ŋ kɩ sʋla ɩ: ");
INSERT INTO sig_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɩ nala yaa ŋ nala rɛ, ŋ nala mɛ yaa ɩ nala. Ba tɩyaŋ nɛ ɩ tɩŋa a daga ŋ gaŋdarɩ. ");
INSERT INTO sig_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lagɩlagɩ no, ŋ aa ko ɩ lee rɛ, ŋ bɩl bɩ sɩ we dʋnɩya no tɩyaŋ, amɛ ba kɛ sɩ we dʋnɩya no tɩyaŋ. Ŋ Kuwo, ɩ rɛ maga dɩ á kyʋwalɩ ɩ abee gyɩrɩma. Kɩ deŋ nala hʋ ɩ aa lɩɩ tɩya ŋ nyuu weliŋ abee ɩ dee hʋ ɩ aa kpaa tɩya ŋ a leŋ dɩ ba yaa kɩdɩgɩ, anɩɩ ŋ beel-ɩ aa yaa kɩdɩgɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ŋ fa aa we ba lee, ŋ deŋ ba nyuu rɛ weliŋ abee dee hʋ ɩ aa kpaa tɩya ŋ. Ŋ fa sɩŋ pɔ ba rɛ a deŋ ba nyuu weliŋ. Ba kɩdɩgɩ buloŋ bɩ nyʋgɩsa ɩ ŋmanɩɩ tɩyaŋ, see nal hʋ aa maga dɩ ʋ nyʋgɩsɩ dʋŋ, dɩ gɛɛ leŋ wɩya hʋ ba fa aa saba ɩ teŋ tɩyaŋ kɔnɩ ko yaa wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lagɩlagɩ no, ŋ aa ko ɩ lee rɛ. Amɛ ŋ ha aa we dʋnɩya no tɩyaŋ nyɛ, ŋ basɩ wɩya no kɩ tɩya ba rɛ dɩ teŋfɩyɛlʋʋ hʋ buloŋ ŋ aa kana mɛ we ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ŋ basɩ ɩ nyʋwa wɩya tɩya ba rɛ. Amɛ dʋnɩya nala ha haasɩ ba rɛ beewɩya ba bee dʋnɩya nala bɩ yaa kɩdɩgɩ anɩɩ ŋ bee dʋnɩya nala mɛ aa bɩ yaa kɩdɩgɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ŋ bɩ baa dɩ ɩ lɩɩ ba dʋnɩya no tɩyaŋ, amɛ ŋ aa sʋla ɩ rɛ dɩ ɩ pɔ ba a lɩɩ ba Sɩtaanɩ nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ŋ bee dʋnɩya no nala bɩ yaa kɩdɩgɩ. Ɛɛ tɩɩ rɛ ba mɛ bee dʋnɩya no nala bɩ yaa kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tɩŋa ɩ wɩtɩɩ hʋ tɩyaŋ, a lɩɩ ba dɩ ba yaa ɩ tɩɩ nala, ɩ wɩbii hʋ rɛ yaa wɩtɩɩ. Tɩŋa ɩ wɩbii hʋ aa yaa wɩtɩɩ tɩyaŋ a lɩɩ ba dɩ ba yaa ɩ tɩɩ nala. ");
INSERT INTO sig_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ɛɛ hʋ ɩ aa yaŋ tɩma ŋ, ŋ ko dʋnɩya no, ɛɛ tɩɩ rɛ ŋ mɛ tɩŋ ba dʋnɩya no tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ba wɩya, ŋ kpaa ŋ tɩɩ tɩya ɩ rɛ a kɩ tɩŋa ɩ nyʋwa, dɩ gɛɛ wuwo leŋ dɩ ba mɛ kpa ba tɩɩ tɩya ɩ a kɩ tɩŋa ɩ nyʋwa abee wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ŋ bɩ sʋla ɩ kɩ tɩya ba dʋŋ, amɛ ŋ sʋla ɩ kɩ tɩya nala hʋ buloŋ aa sɩ laa ŋ wɩya hʋ ba aa sɩ basɩ di mɛ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ŋ bɩl aa sʋla ɩ rɛ dɩ ɩ leŋ ba buloŋ ko yaa kɩdɩgɩ. Ŋ kuwo, leŋ dɩ á beel-ba buloŋ yaa kɩdɩgɩ anɩɩ ŋ beel-ɩ aa yaa kɩdɩgɩ gɛɛ. Leŋ dɩ ba yaa kɩdɩgɩ dɩ dʋnɩya nala laa di anɩɩ ɩ rɛ kɔnɩ tɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gaŋdarɩ hʋ ɩ aa kpaa tɩya ŋ, ʋ tɩɩ rɛ ŋ mɛ kpa tɩya ba. Ŋ yaa gɛɛ rɛ dɩ ba buloŋ yaa kɩdɩgɩ anɩɩ ŋ beel-ɩ buloŋ aa yaa kɩdɩgɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ŋ we ba lee rɛ, ɩ mɛ we ŋ lee. Leŋ dɩ ba kɔnɩ yaa kɩdɩgɩ, dɩ gɛɛ leŋ dɩ dʋnɩya nala gyɩma anɩɩ ɩ rɛ kɔnɩ tɩma ŋ. Leŋ dɩ ba gyɩma anɩɩ ɛɛ hʋ ɩ aa kyo ŋ, ɛɛ tɩɩ rɛ ɩ kyo ba mɛ. ");
INSERT INTO sig_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ŋ Kuwo, nala hʋ ɩ aa kpaa tɩya ŋ, ŋ aa kyɛ dɩ ba mɛ we lee hʋ tɩyaŋ ŋ aa sɩ we rɛ, dɩ ba wuwo na ŋ gaŋdarɩ hʋ ɩ aa kpaa tɩya ŋ. Ɩ kpaa gaŋdarɩ no tɩya ŋ nɛ beewɩya ɩ kyo ŋ nɛ aŋ na marɩ dʋnɩya no. ");
INSERT INTO sig_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ŋ kuwo, tɩpʋlʋŋ tɩɩna, dʋnɩya nala bɩ gyɩma ɩ, amɛ ŋ kɛ gyɩma ɩ rɛ. Nala no mɛ gyɩma rɛ anɩɩ ɩ rɛ tɩma ŋ. ");
INSERT INTO sig_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ŋ leŋ ba gyɩma ɩ rɛ. Ŋ ha sɩ leŋ dɩ ba marɩ gyɩma ɩ dɩ gɛɛ leŋ ba kyo ba dɔŋtɩŋsɩ anɩɩ ɛɛ hʋ ɩ aa kyo ŋ, ka dɩ ŋ mɛ we ba lee.” ");
INSERT INTO sig_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu aa kyʋwalɩ Wɩɩsɩ hʋ ko teŋ, ʋ bee ʋ hatɩnna hʋ sii kyol fuwonaaŋ kɩdɩgɩ ba aa yɩrɩ Kidirɔŋ, a mʋ gyʋʋ baga kɩdɩgɩ tɩyaŋ ba aa pɔɔ olivi tɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Gyudasɩ, nal hʋ aa ko kpa Yesu yallɩ hʋ gyɩ gyɩŋ baga no lee rɛ, beewɩya ba bee Yesu gyɩ aa kɩ mʋ doŋ nɛ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Farasiima hʋ sii lɩɩ Roma laalyuwolo badɔmɔŋ abee Wɩɩkyʋwaldɩɩbal hʋ pʋpɔɔlɔ badɔmɔŋ, dɩ Gyudasɩ kaŋ ba mʋ dɩ ba kaŋ Yesu. Ba gyɩ nyʋgɩlɩ ba bakɩna rɛ, aŋ kolo fɩŋtɩŋsɩ abee kapɩla. ");
INSERT INTO sig_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu gyɩ gyɩŋ wɩɩ hʋ buloŋ ba aa sɩ yaa ʋ rɛ. Ɛɛ rɛ ʋ lɩɩ kyeŋ ba a pɩyɛsɩ ba a baa, “Aŋnɛ rɛ ma kɩ kyɛ?” ");
INSERT INTO sig_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɛɛ rɛ ba baa, “Yesu aa lɩɩ Nazarɛti rɛ á kɩ kyɛ.” Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Mɩyaŋ nɛ nyɛ.” Gyudasɩ, gyambatɩɩna hʋ mɛ fa pɛɛ ba tɩyaŋ nɛ a sɩŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu aa basɩ baa mɩyaŋ nɛ nyɛ, ba mɩɩgɩ mʋ hal, a lɩɩ tele. ");
INSERT INTO sig_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ba a baa, “Aŋnɛ rɛ ma kɩ kyɛ?” Ba baa, “Yesu aa lɩɩ Nazarɛti.” ");
INSERT INTO sig_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ŋ foŋ basɩ tɩya ma rɛ anɩɩ mɩyaŋ nɛ nyɛ. Dɩ mɩyaŋ kɛ rɛ ma kɩ kyɛ, ma leŋ dɩ ŋ hatɩnna no kɛ kɩ mʋ.” ");
INSERT INTO sig_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ʋ basɩ gɛɛ rɛ dɩ wɩɩ hʋ ʋ fa aa laa sɩya basɩ kɔnɩ ko yaa wɩtɩɩ. Ʋ fa baa “Ŋ kuwo, nala hʋ buloŋ ɩ aa lɩɩ tɩya ŋ, ba kɩdɩgɩ buloŋ bɩ nyʋgɩsa.” ");
INSERT INTO sig_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dɩ Siimɔŋ Piita fa kol takoobii doŋ. Ɛɛ rɛ ʋ tʋʋrɩ, a ŋmaŋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ kɩdɩgɩ yoŋ ba aa yɩrɩ Malku noduu dɩgɩŋ a kyɔl. ");
INSERT INTO sig_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ɛɛ rɛ Yesu basɩ tɩya Piita a baa, “Kpa ɩ takoobii hʋ tʋʋ ʋ tʋʋl tɩyaŋ. Ɩ bɩɩna anɩɩ ŋ bee kyɛ dɩ ŋ na tʋwara hʋ ŋ kuwo aa kpaa bine ŋ nɛ koo?” ");
INSERT INTO sig_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɛɛ rɛ Roma laalyuwolo hʋ abee ba nɩhɩyawʋ abee Wɩɩkyʋwaldɩɩbal hʋ pʋpɔɔlɔ kaŋ Yesu, a vʋwa ʋ, ");
INSERT INTO sig_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","a laa sɩya kana ʋ mʋ Anaasɩ lee. Anaasɩ fa yaa Kayifasɩ hɩɩla rɛ. Haŋ bɩna hʋ, Kayifasɩ rɛ fa yaa Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ buloŋ nɩhɩyawʋ. ");
INSERT INTO sig_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayifasɩ no rɛ gyɩ basɩ tɩya Gyuuma nɩhɩyasɩ anɩɩ dɩ nɩdɩgɩ rɛ laa paalʋʋ no nala buloŋ nyuu sʋba, ʋ rɛ sɩ kpɩya ba paalʋʋ hʋ nala buloŋ aa sɩ sʋba. ");
INSERT INTO sig_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siimɔŋ Piita bee Yesu hatɩnna hʋ kɩdɩgɩ gyɩ tɩŋ Yesu hal lɛ. Wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ gyɩ gyɩŋ haŋ hatɩnnɩ hʋ rɛ weliŋ. Ɛɛwɩya, ʋ kɛ gyɩ tɩŋ Yesu hal a gyʋʋ gyaŋwuwo hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ka Piita kɛ sɩŋ paga hʋ nyʋwa tɩyaŋ. Ɛɛ rɛ Yesu hatɩnnɩ no mɩɩgɩ lɩɩ, a basɩ wɩya tɩya haŋtolibiye hʋ aa pɔɔ paga hʋ nyʋwa, aŋ kaŋ Piita ko gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɛɛ rɛ haŋtolibiye hʋ aa sɩŋ pɔ paganyʋwa hʋ pɩyɛsɩ Piita a baa, “Ka ɩ yaa baal no hatɩnna hʋ kɩdɩgɩ rɛ?” Ɛɛ rɛ Piita baa, “Aayɩ, ŋ bɩ yaa ba kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Saŋa no tɩyaŋ waal gyɩ we doŋ nɛ weliŋ. Ɛɛ rɛ dɩya hʋ tʋŋtʋnna abee Wɩɩkyʋwaldɩɩbal hʋ pʋpɔɔlɔ we diŋ a sɩŋ gol a kɩ wiyeni. Nyɛ rɛ Piita mɛ mʋ sɩŋ ba lee a kɩ wiyeni diŋ hʋ. ");
INSERT INTO sig_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ pɩyɛsɩ Yesu ʋ hatɩnna hʋ wɩya abee wɩya hʋ ʋ fa aa dagɩ. ");
INSERT INTO sig_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ɛɛ rɛ Yesu baa, “Ŋ bɩ lʋwɔlɩ basɩ wɩɩ buloŋ a tɩya nal buloŋ. Ŋ aa sɩŋ lɩgyalɩɩ tɩyaŋ nɛ a basɩ wɩya kɩ tɩya nala. Ŋ aa kɩ daga nala Gyuuma wɩɩkyʋwaldɩɩsɩ tɩyaŋ nɛ abee Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ lee hʋ nala aa kɩ laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bee rɛ yaŋ tɩŋ ɩ kɩ pɩyɛsɩ ŋ nyɛ? Pɩyɛsɩ nala hʋ aa nɩɩ wɩya hʋ ŋ aa basa, dɩ ba daga ɩ. Beewɩya ba gyɩŋ wɩya hʋ ŋ aa basa rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu aa basɩ gɛɛ, Wɩɩkyʋwaldɩɩbal pʋpɔɔlɔ hʋ kɩdɩgɩ ŋmaa ʋ kyaŋkpaŋ tɩyaŋ aŋ baa, “Aŋnɛ rɛ yaa ɩ, ɩ basɩ wɩya nyɛ kɩ tɩya Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ?” ");
INSERT INTO sig_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ɛɛ rɛ Yesu baa, “Dɩ mɩyaŋ nɛ basɩ wɩɩ kyogi, ʋ maga dɩ ɩ basɩ dɩ nal buloŋ nɩɩ rɛ. Amɛ dɩ wɩɩ hʋ ŋ aa basa rɛ yaa wɩtɩɩ, bee rɛ tɩŋ ɩ leŋ ba ŋmaa ŋ kyaŋkpaŋ?” ");
INSERT INTO sig_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛɛ rɛ Anaasɩ ha leŋ Yesu vʋwa gɛɛ, ka ʋ leŋ ba kana ʋ mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ Kayifasɩ lee. ");
INSERT INTO sig_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piita ha gyɩ sɩŋ gyaŋwuwo hʋ tɩyaŋ nɛ a kɩ wiyeni diŋ hʋ. Ɛɛ rɛ nala hʋ badɔmɔŋ pɩyɛsɩ ʋ a baa, “Ka ɩ mɛ yaa baal no hatɩnna hʋ kɩdɩgɩ rɛ.” Piita tʋwa a baa, “Aayɩ, ŋ bɩ yaa ba kɩdɩgɩ.” ");
INSERT INTO sig_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dɩ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ yoŋ kɩdɩgɩ mɛ gyɩ we doŋ. Ʋ gyɩ yaa nal hʋ dɩgɩŋ Piita gyɩ aa ŋmaŋ kyɔl hʋ lʋllɩ rɛ. Ɛɛ rɛ ʋ pɩyɛsɩ Piita a baa, “Na ŋ gyɩ naa ɩ bee Yesu no rɛ olivi tɩɩsɩ baga hʋ tɩyaŋ?” ");
INSERT INTO sig_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ɛɛ rɛ Piita bɩl tʋwa a baa dɩ aayɩ. Piita aa basɩ gɛɛ ko teŋ dɩ gyibal wiye. ");
INSERT INTO sig_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ʋ kyɩkyʋwala pipi, ba sii kaŋ Yesu lɩɩ Kayifasɩ dɩya tɩyaŋ, a mʋ Pilato dɩya. Pilato rɛ fa laa Roma kuworibal hʋ naasɩ sɩŋ doŋ paalʋʋ tɩyaŋ. Gyuuma hʋ gyɩ bɩ gyʋʋ gyaŋwuwo hʋ. Beewɩya ba gyɩ bee kyɛ dɩ ba ko kyogi ba sɩna, ka dɩ ba wuwo di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal kɩdiiliye hʋ. ");
INSERT INTO sig_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ɛɛ rɛ Pilato ko lɩɩ pɩyɛsɩ ba a baa, “Wɩbee rɛ ma baa baal no yaa kyogi?” ");
INSERT INTO sig_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Dɩ ʋ rɛ fa bɩ yaa wɩɩ kyogi, á fa bɩ sɩ kana ʋ ko ɩ lee.” ");
INSERT INTO sig_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ɛɛ rɛ Pilato basɩ tɩya ba a baa, “Ɛɛ kɛ, ma kana ʋ mʋ di ʋ sarɩya ma tɩɩ lesiri tɩyaŋ.” Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Mamaa Roma nala bɩ tɩya ma ŋmanɩɩ dɩ á kpʋ nal buloŋ”. ");
INSERT INTO sig_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wɩya no buloŋ yaa rɛ dɩ wɩya hʋ buloŋ Yesu aa basa a mʋ tile ɛɛ hʋ ʋ aa sɩ sʋba kɔnɩ koo yaa wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɛɛ rɛ Pilato mɩɩgɩ gyʋʋ dɩya, aŋ leŋ ba kaŋ Yesu ko ʋ sɩya ʋ pɩyɛsɩ ʋ a baa, “Ɩ rɛ yaa Gyuuma kuwori hʋ?” ");
INSERT INTO sig_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ a baa, “Ɩ tɩɩ rɛ basɩ wɩɩ no koo nal lɛ basɩ ŋ wɩya tɩya ɩ?” ");
INSERT INTO sig_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ɛɛ rɛ Pilato bɩl baa, “Ŋ bɩ yaa Gyuu. Ɩ tɩɩ nala abee ma wɩɩkyʋwal sɩlaala nɩhɩyasɩ rɛ kana ɩ ko we ŋ nosi tɩyaŋ. Wɩbee rɛ ɩ yaa kyogi?” ");
INSERT INTO sig_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ɛɛ rɛ Yesu baa, “Ŋ koro tuwo dʋnɩya no tɩyaŋ. Dɩ ŋ koro rɛ fa we dʋnɩya no tɩyaŋ, ŋ nala fa sɩ yuwo laa ŋ, dɩ Gyuuma ta wuwo kana ŋ. Amɛ ŋ koro tuwo daha.” ");
INSERT INTO sig_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ɛɛ rɛ Pilato pɩyɛsɩ ʋ a baa, “Ɩ yaŋ yaa kuwori rɛ koo?” Ɛɛ rɛ Yesu baa, “Ɩ tɩɩ rɛ basa. Wɩdɩgɩ dʋŋ wɩya rɛ ŋ kuu ko, ba lʋla ŋ dʋnɩya no tɩyaŋ. Wɩɩsɩ wɩtɩɩ hʋ rɛ ŋ ko dɩ ŋ basɩ tɩya nala. Nal hʋ buloŋ aa kyɛ wɩtɩɩ no, ʋ tɩɩna aa gyegile nɩɩ ŋ nyʋwa rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ɛɛ rɛ Pilato pɩyɛsɩ ʋ a baa, “Wɩtɩɩ rɛ yaa bee?” Ɛɛ rɛ Pilato mɩɩgɩ lɩɩ Gyuuma hʋ lee a basɩ tɩya ba a baa, “Ŋ bɩ naa wɩɩ hʋ baal no aa yaa a maga dɩ ŋ kpa kyogisi tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amɛ bɩna kɛ buloŋ, dɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ rɛ ko pele, ŋ aa kuu ma wɩya rɛ aa lɩɩ nala hʋ ba aa kaŋ tɔ dɩya tɩyaŋ nɩdɩgɩ a ta, anɩɩ ma lesiri aa daga gɛɛ. Ma aa kyɛ dɩ ŋ kpa Gyuuma kuwori hʋ rɛ ta koo?” ");
INSERT INTO sig_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɛɛ rɛ ba nɔsɩ a baa, “Aayɩ, baal no kɛ daa! Lɩɩ Barabaasɩ ta tɩya ma. (Barabaasɩ gyɩ yaa nɩbɔŋ nɛ ba kaŋ tɔ dɩyaŋ.)” ");
INSERT INTO sig_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɛɛ rɛ Pilato leŋ ba kaŋ Yesu a vɩɩrɩ ʋ, ");
INSERT INTO sig_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ka laalyuwolo hʋ kpa sɔsɩ sʋwa nyupugi aa kɩɩ kuwori nyupugi, a kpa kyige ʋ, aŋ kpa gafɩyaŋdolii kɩdɩgɩ laalɩ ʋ, ");
INSERT INTO sig_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","aŋ aa villi mʋ kɩ kyʋwalɩ ʋ a baa, “Gyuuma kuwori, Wɩɩsɩ sɩ tɩya ɩ mɩɩbodolii!” Aŋ aa ŋmaa ʋ kyaŋkpaŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ɛɛ rɛ Pilato bɩl mɩɩgɩ lɩɩ gyamaa hʋ lee a basɩ tɩya ba a baa, “Ma deŋ na, ŋ sɩ kana ʋ ko lɩɩ ma lee dɩ ma gyɩma anɩɩ ŋ kɛ bɩ naa wɩɩ buloŋ baal no aa yaa a maga dɩ ŋ kpa kyogisi tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ɛɛ rɛ ba kaŋ Yesu ko lɩɩ dɩ ʋ ha kyige sɔsɩ nyupugi hʋ abee gafɩyaŋdolii hʋ ba aa kpaa laalɩ ʋ. Ɛɛ rɛ Pilato basɩ tɩya ba a baa, “Baal hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee Wɩɩkyʋwaldɩɩbal hʋ pʋpɔɔlɔ aa naa ʋ, ba kyɩɩrɩ yʋga a baa, “Ma kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” Ɛɛ rɛ Pilato basɩ tɩya ba a baa, “Ma tɩɩ kana ʋ mʋ kpaasɩ mal daagarɩɩ tɩyaŋ. Ŋ kɛ bɩ naa wɩɩ hʋ ʋ aa yaa a maga dɩ ŋ kpa kyogisi tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ɛɛ rɛ Gyuuma hʋ bɩl baa, “Ʋ kaŋ ʋ tɩɩ kɩ yɩrɩ Wɩɩsɩ Biye rɛ. Á mɩrɩsɩ daga anɩɩ nal hʋ buloŋ ko yaa gɛɛ, ʋ tɩɩna maga dɩ ba kpʋ ʋ rɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato aa nɩɩ ba aa basɩ gɛɛ, kambɩŋ marɩ kana ʋ anɩɩ ʋ aa sɩ kpa kyogisi tɩya Yesu. ");
INSERT INTO sig_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɛɛ rɛ ʋ bɩl mɩɩgɩ gyʋʋ dɩya hʋ a pɩyɛsɩ Yesu a baa, “Lee rɛ ɩ lɩɩ?” Amɛ Yesu bɩ laa wɩɩ buloŋ basɩ. ");
INSERT INTO sig_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɛɛ rɛ Pilato pɩyɛsɩ ʋ a baa, “Ɩ bee tɔgɩmɩ ŋ? Ɩ bɩ gyɩma anɩɩ ŋ kaŋ dee rɛ ŋ aa sɩ wuwo kpa ɩ ta, a bɩl kaŋ dee mɛ ŋ aa sɩ wuwo leŋ dɩ ba kpaasɩ ɩ mal daagarɩɩ tɩyaŋ koo?” ");
INSERT INTO sig_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ɩ fa bɩ sɩ kana ŋ dee dɩ Wɩɩsɩ fa bɩ tɩya ɩ gɛɛ dee. Amɛ nala hʋ aa kana ŋ ko we ɩ nosi tɩyaŋ wɩbɔŋ nɛ yʋga a te wɩbɔŋ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato aa nɩɩ gɛɛ, ʋ fa kɩ kyɛ dɩ ʋ kpa Yesu ta. Ɛɛ rɛ Gyuuma hʋ bɩl kyɩɩrɩ yʋga a baa, “Dɩ ɩ rɛ ko kpa ʋ ta, ɩ bɩl bɩ yaa á paalʋʋ kuworibal Siiza kyana. Beewɩya nal hʋ buloŋ aa kaŋ ʋ tɩɩ kɩ yɩrɩ kuwori, ʋ tɩɩna yaa kuworibal hʋ dɔŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato aa nɩɩ gɛɛ, ʋ kaŋ Yesu ko lɩɩ, aŋ mʋ hɔŋ ʋ sarɩdi-kpasa nyuu tɩyaŋ. Bʋwa rɛ ba fa kpa marɩ kuwori kpasa hʋ lɩsɩnɩɩ a kaŋ doŋ kɩ yɩrɩ Gabata Hiiburu taal tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Saŋa no tɩyaŋ dɩ wɩɩsɩ gyɩ maga nyutʋtʋʋ rɛ. Kyɛɛ no rɛ Gyuuma aa yaa siri, a sii ʋ sɩgballɩya, ba di Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ. Ɛɛ rɛ Pilato basɩ tɩya ba a baa, “Ma kuwori hʋ rɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɛɛ rɛ ba marɩ kyɩɩrɩ yʋga a baa, “Kpʋ ʋ! Kpʋ ʋ! Kpaasɩ ʋ mal daagarɩɩ tɩyaŋ.” Ɛɛ rɛ Pilato pɩyɛsɩ ba a baa, “Ma aa kyɛ dɩ ŋ kpaasɩ ma kuwori hʋ daagarɩɩ tɩyaŋ nɛ koo?” Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ baa, “Á bɩ kaŋ kuwori buloŋ a pɛ Siiza, á kuworibal hʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ɛɛ rɛ Pilato kpa Yesu tɩya ba dɩ ba kaŋ mʋ kpaasɩ mal daagarɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɛɛ rɛ laalyuwolo hʋ laa ʋ a kana ʋ kɩ mʋ. Ba kaŋ Yesu ko kɩ lɩɩ dɩ ʋ baasɩ ʋ tɩɩ daagarɩɩ rɛ, ɛɛ rɛ ba mʋ pele lee hʋ ba aa kyɛ dɩ ba kpaasɩ ʋ. Doŋ feŋ nɛ yaa Golgota, Hiiburu taal tɩyaŋ. Golgota memii rɛ yaa nyukuŋkogilo. ");
INSERT INTO sig_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Doŋ tɩyaŋ nɛ ba kpaasɩ Yesu mal daagarɩɩ hʋ tɩyaŋ. Ba fa kpaasɩ nala balɩya mɛ rɛ daagarɩya balɩya nyuni tɩyaŋ a pɛ Yesu tɩyaŋ. Kɩdɩgɩ we ʋ noduu dɩɩlaŋ, kɩdɩgɩ mɛ we ʋ nogɔbɔ dɩɩlaŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ɛɛ rɛ Pilato leŋ ba sabɩ mal Yesu daagarɩɩ hʋ nyuu tɩyaŋ a baa, “Yesu aa lɩɩ Nazarɛti, Gyuuma kuwori hʋ.” ");
INSERT INTO sig_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gyuuma gyɩ yʋga a karɩmɩ wɩɩ no beewɩya lee hʋ ba gyɩ aa kpaasɩ Yesu mal daagarɩɩ hʋ tɩyaŋ gyɩ kpaga Gyerusalɛm nɛ. Pilato gyɩ leŋ ba sabɩ wɩɩ no Hiiburu abee Laatɩn abee Giriki taanɩ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ basɩ tɩya Pilato anɩɩ ʋ ta saba a baa dɩ Gyuuma kuwori rɛ nyɛ, amɛ dɩ ʋ sabɩ a baa dɩ baal no rɛ baa dɩ ʋ rɛ yaa Gyuuma kuwori. ");
INSERT INTO sig_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ɛɛ rɛ Pilato baa, “Wɩɩ hʋ ŋ foŋ aa saba, ŋ bɩl bɩ kaŋ kɩ bɩrɩmɩ.” ");
INSERT INTO sig_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Laalyuwolo hʋ aa kpaasɩ Yesu mal daagarɩɩ hʋ tɩyaŋ ko teŋ, ba paa ʋ gannɩ a kaŋ kpaa leye banaa. Laalyuwol buloŋ di lɩdɩgɩ. Ɛɛ rɛ ka ba kpa ʋ gadolii hʋ mɛ. Gasɩdɩgɩ rɛ ba fa kpa sʋwa ʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ɛɛ rɛ laalyuwolo hʋ basɩ tɩya dɔmɔŋ a baa, “Ma ta leŋ dɩ á kaŋ gal hʋ kɩyɛsɩ, ma leŋ dɩ á yuwo gbaŋŋa, a na nal hʋ aa sɩ di ʋ.” Ba yaa wɩɩ no dɩ wɩya hʋ ba fa aa saba Wɩɩsɩ teŋ tɩyaŋ ko yaa wɩtɩɩ rɛ. Ba fa saba abaa, “Ba paa ŋ gannɩ kpaa dɔmɔŋ nɛ aŋ kuu ŋ gadolii hʋ wɩya a yuwo gbaŋŋa.” Ɛɛ tɩɩ rɛ laalyuwolo hʋ mɛ kɔnɩ yaa. ");
INSERT INTO sig_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu nɩɩna, abee Yesu ʋ naa nɩɩna toluu abee Kulopasi haaŋ Mɛɛrɩ, abee Mɛɛrɩ Magidalina fa sɩŋ kpaga Yesu daagarɩɩ hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu aa naa ʋ naa abee ʋ hatɩnnɩ hʋ wɩya ʋ fa aa kyo kɩŋkaŋ dɩ ba sɩna, ɛɛ rɛ ʋ basɩ tɩya ʋ naa a baa, “Ŋ naa, ɩ biibaal lɛ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aŋ bɩl basɩ tɩya ʋ hatɩnnɩ hʋ mɛ a baa, “ɩ naa rɛ nyɛ.” A lɩɩ haŋ saŋa hʋ tɩyaŋ, ʋ hatɩnnɩ hʋ kaŋ Yesu nɩɩna mʋ ʋ dɩya a kɩ deŋ ʋ. ");
INSERT INTO sig_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu gyɩ gyɩma anɩɩ nyɛ kɛ ʋ tʋŋ tʋma hʋ ʋ kuwo aa kpaa tɩya ʋ teŋ nɛ. Ɛɛ rɛ ʋ baa “Nɩɩnyʋwasɩ kana ŋ nɛ.” Nyɛ leŋ wɩya hʋ ba aa sabɩ biŋ Wɩɩsɩ teŋ tɩyaŋ ko yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dɩ sɩkyaakyaa mɛ gyɩ suu gbaha a sɩŋ doŋ. Ɛɛ rɛ ba kpa gbara a sɩna sɩŋ hʋ tɩyaŋ, a kpa kaakelii lɩɩ gbara hʋ a kaŋ gyɩŋ dige ʋ nyʋʋpine. ");
INSERT INTO sig_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu aa lamɩsɩ sɩŋ hʋ ko teŋ, ɛɛ rɛ ʋ baa, “Wɩɩ buloŋ tene rɛ!” Aŋ kaŋ ʋ nyuu kyugili a sʋba. ");
INSERT INTO sig_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kyɛɛ no dɩ Gyuuma hʋ mɛ aa yaa ba siri, beewɩya ʋ sɩgballɩya rɛ sɩ yaa Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ. Kyɛwiyesii hʋ mɛ kyɛɛ rɛ gɛɛ. Ɛɛ rɛ tɩŋ ba gyɩ bee kyɛ dɩ nala hʋ saga daagarɩya hʋ nyuu haŋ kyɛbal hʋ. Nyɛ rɛ ba mʋ sʋla Pilato dɩ ʋ leŋ dɩ laalyuwolo hʋ mʋ bori ba naasɩ aŋ lallɩ ba tuu daagarɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɛɛ rɛ laalyuwol hʋ mʋ ŋmaa baala hʋ ba aa kpaasa a pɛ Yesu tɩyaŋ naasɩ bori. ");
INSERT INTO sig_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba aa ko Yesu lee dɩ ʋ sʋba. Ɛɛ wɩya ba gyɩ bɩ bori ʋ naasɩ kɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amɛ laalyuwol hʋ kɩdɩgɩ kpa ʋ tiŋ a kyɔgɔ Yesu logiŋ luri. Ɛɛ rɛ kyal abee nɩɩ gyaa lɩɩ gyaasɩ. ");
INSERT INTO sig_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mɩyaŋ nal hʋ aa basɩ wɩya no buloŋ kɛ naa ba rɛ abee ŋ sɩɩ. Wɩya no buloŋ mɛ ŋ aa basɩ kɔnɩ yaa wɩtɩɩ rɛ. Ŋ tɩɩ gyɩma anɩɩ ŋ bee nyɩya wɩya. Daŋsɩya no rɛ ŋ di, dɩ ɛɛ leŋ dɩ ma mɛ wuwo laa di. ");
INSERT INTO sig_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wɩya no buloŋ yaa rɛ dɩ wɩya hʋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ ko yaa wɩtɩɩ. Ba saba a baa, “Ba bɩ sɩ bori ʋ hogidɩgɩ mɛ.” ");
INSERT INTO sig_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wɩɩsɩ teŋ logiŋ kɩdɩgɩ tɩyaŋ, ba bɩl basa rɛ anɩɩ nala sɩ deŋ nal hʋ logiŋ ba aa kyɔgɔ. ");
INSERT INTO sig_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baal kɩdɩgɩ rɛ gyɩ we doŋ ba kɩ yɩrɩ Gyosɛfʋ, a lɩɩ Arimatiya. Ʋ fa yaa Yesu hatɩnna kɩdɩgɩ rɛ. Amɛ ʋ fa kaŋ ʋ tɩɩ faŋa rɛ Gyuuma nɩhɩyasɩ hʋ wɩya. Yesu aa ko sʋba, ɛɛ rɛ ʋ mʋ sʋla Pilato dɩ ʋ leŋ dɩ ʋ mʋ kpa Yesu. Nyɛ rɛ Pilato tɩya ʋ ŋmanɩɩ ʋ mʋ kpa ʋ. ");
INSERT INTO sig_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ɛɛ rɛ Nikodemu nal hʋ gyɩ aa laa sɩya mʋ Yesu lee tebine hʋ mɛ sii tɩŋ Gyosɛfʋ hal ba mʋ. Nikodemu gyɩ kpaa tɩɩnaaluliye badɔmɔŋ ba aa yɩrɩ mɛɛ abee alɔɔsɩ rɛ a marɩ kɩna badɔmɔŋ dɩ ʋ kaŋ mʋ tɩsɩ Yesu teŋbii dɩ ʋ ta pʋw lagɩ. Kɩna no yohuŋ gyɩ maga nihuwobiŋ piliŋ yohuŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ba balɩya rɛ gyɩ mʋʋ kpa Yesu teŋbii, a kpa kɩna hʋ ʋ aa mara tɩsɩ ʋ aŋ kpa gapʋlʋŋ, a bɔ tɔ ʋ, anɩɩ Gyuuma sʋʋnɩ hogii lesiri aa daga gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dipolo kɩdɩgɩ rɛ fa we lee hʋ tɩyaŋ ba gyɩ aa kpaasɩ Yesu mal daagarɩɩ hʋ tɩyaŋ. Dipolo hʋ tɩyaŋ, bʋbʋwa kɩdɩgɩ rɛ fa we doŋ, ba ha bɩ maakyiye hogo nal buloŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Akuu ʋ sɩgballɩya aa sɩ yaa Gyuuma kyɛwiyesii hʋ kyɛɛ wɩya, ka bʋbʋwa no mɛ gyɩ aa kpaga doŋ wɩya, ba gyɩ kpa Yesu hogo ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Alahadi kyɛɛ sɩgballɩnyʋwa pipi, Mɛɛrɩ Magidalina sii foŋ mʋ bʋwa hʋ lee. Ʋ mʋwa dɩ dabʋyɩ hʋ ba aa kpaa tɔ bʋwa hʋ suro. ");
INSERT INTO sig_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nyɛ rɛ ʋ mɩɩgɩ fá mʋ Siimɔŋ Piita abee Yesu hatɩnnɩ hʋ Yesu fa aa kyo kɩŋkaŋ hʋ lee, a basɩ tɩya ba a baa, “Ba lɩɩ á Tɩɩna Yesu bʋwa hʋ tɩyaŋ nɛ. Ka á bɩ gyɩŋ lee hʋ ba aa kpaa ʋ biŋ.” ");
INSERT INTO sig_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ɛɛ rɛ Piita bee Yesu hatɩnnɩ-kyoolii hʋ gyɩ sii fá kɩ mʋ bʋwa hʋ lee. ");
INSERT INTO sig_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nyɛ rɛ kɩdɩgɩ hʋ tɩɩna fá kaŋ Piita ta, aŋ laa sɩya fá mʋ pele bʋwa hʋ lee. ");
INSERT INTO sig_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Amɛ ʋ gyɩ bɩ gyʋʋ bʋwa hʋ tɩyaŋ. Ʋ gyɩ tuu luŋ nɛ a deŋ na dɩ Yesu liŋe hʋ dʋŋ pɩŋ bʋwa hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Amɛ Piita kɛ aa tɩŋ hal ko, ʋ bɩl bɩ gyegile aŋ mʋ gyʋʋ bʋwa hʋ a na dɩ Yesu liŋe hʋ dʋŋ pɩna. ");
INSERT INTO sig_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ka gal hʋ ba fa aa kpaa vʋwa Yesu nyuu mɛ kulo pɩŋ ʋ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɛɛ rɛ nal hʋ aa laa sɩya mʋ bʋwa hʋ lee mɛ mʋ gyʋʋ bʋwa hʋ tɩyaŋ a na wɩɩ hʋ aa yaa, a laa di anɩɩ Yesu kɔnɩ sii sʋʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Amɛ ba ha gyɩ bɩ gyɩŋ wɩɩ hʋ ba fa aa saba Wɩɩsɩ teŋ tɩyaŋ memii anɩɩ ʋ maga dɩ Yesu sii sʋʋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ɛɛ rɛ Yesu hatɩnna hʋ mɩɩgɩ mʋ bee. ");
INSERT INTO sig_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ka Mɛɛrɩ Magidalina ha sɩŋ bʋwa hʋ logiŋ a kɩ wii. Ʋ aa wii gɛɛ rɛ aŋ tuu luŋ dɩ ʋ deŋ bʋwa hʋ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","dɩ ʋ naa malɩkasɩ balɩya bʋwa hʋ tɩyaŋ dɩ ba laalɩ gapʋllɩ a hɔŋ lee hʋ Yesu fa aa pɩna. Kɩdɩgɩ hɔŋ Yesu nyuu fa aa mʋʋ lee hʋ rɛ, ka kɩdɩgɩ mɛ hɔŋ ʋ naasɩ fa aa mʋʋ lee hʋ. ");
INSERT INTO sig_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nyɛ rɛ ba pɩyɛsɩ ʋ a baa, “Haŋtolibiye, bee rɛ tɩŋ ɩ kɩ wii?” Ɛɛ rɛ ʋ baa, “Ba kpaa ŋ Tɩɩna bʋwa hʋ tɩyaŋ nɛ, ka ŋ bɩ gyɩŋ lee hʋ ba aa kpaa ʋ mʋ biŋ.” ");
INSERT INTO sig_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɛɛ rɛ ʋ mɩɩgɩ dɩ ʋ bɩrɩmɩ, dɩ ʋ naa Yesu dɩ ʋ sɩŋ doŋ. Amɛ Mɛɛrɩ fa bɩ gyɩma anɩɩ Yesu rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ɛɛ rɛ Yesu mɛ pɩyɛsɩ Mɛɛrɩ a baa, “Haŋtolibiye, bee rɛ tɩŋ ɩ kɩ wii? Kɩbee rɛ ɩ kɩ kyɛ?” Mɛɛrɩ fa bɩɩna anɩɩ baal hʋ aa deŋ dipolo hʋ rɛ. Ɛɛ rɛ ʋ pɩyɛsɩ ʋ a baa, “Nɩhɩyawʋ, dɩ ɩ rɛ kpa ʋ, daga ŋ lee hʋ ɩ aa kana ʋ mʋ biŋ, dɩ ŋ mʋ kpa ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ɛɛ rɛ Yesu yɩrɩ ʋ feŋ a baa, “Mɛɛrɩ”. Nyɛ rɛ Mɛɛrɩ mɩɩgɩ galdaasɩ aŋ basɩ Hiiburu taal tɩyaŋ a baa, “Rabboni” (Rabboni memii rɛ yaa dɩdagɩl.) ");
INSERT INTO sig_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Ta dige ŋ, beewɩya ŋ ha bɩ mʋʋ ŋ Kuwo lee. Amɛ mʋ basɩ tɩya ŋ hatɩnna hʋ anɩɩ ŋ mɩɩgɩ kɩ gyɩŋ ŋ Kuwo lee rɛ. Ʋ rɛ yaa ŋ beel-ma buloŋ Kuwo a yaa ŋ beel-ma buloŋ Wɩɩsɩ mɛ.” ");
INSERT INTO sig_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ɛɛ rɛ Mɛɛrɩ Magidalina mʋ Yesu hatɩnna hʋ lee, a basɩ tɩya ba a baa dɩ ʋ naa Tɩɩna Yesu rɛ, a basɩ wɩya hʋ mɛ buloŋ ʋ aa basɩ tɩya ʋ a tɩya ba. ");
INSERT INTO sig_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Haŋ Alahadi hʋ kyɛɛ dɩdaana, ʋ hatɩnna hʋ gyɩ laŋŋa dɩya tɩyaŋ nɛ aŋ kaŋ dimbee hʋ lara, beewɩya ba gyɩ aa fá Gyuuma nɩhɩyasɩ hʋ rɛ. Ɛɛ rɛ Yesu ko sɩŋ ba tʋtʋʋ aŋ baa, “Fɩyɛlʋʋ we ma lee.” ");
INSERT INTO sig_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ʋ aa basɩ gɛɛ ko teŋ, ʋ kaŋ ʋ nosi abee ʋ logiŋ daga ba dɩ ba na fʋfʋʋnɩ hʋ. Ʋ hatɩnna hʋ buloŋ tenni gyɩ fɩyɛla rɛ weliŋ ba aa naa Tɩɩna hʋ nyuniŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɛɛ rɛ Yesu bɩl basɩ tɩya ba a baa, “Fɩyɛlʋʋ we ma lee.” Ŋ Kuwo aa tɩma ŋ gɛɛ, ɛɛ tɩɩ rɛ ŋ mɛ kɩ tɩŋ ma. ");
INSERT INTO sig_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ʋ aa basɩ gɛɛ teŋ, ʋ wiyesi we ba tɩyaŋ aŋ baa, “Ma laa Wɩɩsɩ Wiyesi Welii hʋ a leŋ dɩ ʋ we ma tɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dɩ mamaa rɛ ko kpa nal wɩbɔmɔ kyɛ ʋ, Wɩɩsɩ mɛ sɩ kpa ʋ tɩɩna wɩbɔmɔ kyɛ ʋ. Dɩ mamaa rɛ ko bɩ kpaa nal wɩbɔmɔ kyɛ ʋ, Wɩɩsɩ mɛ bɩ sɩ kpa ʋ tɩɩna wɩbɔmɔ kyɛ ʋ.” ");
INSERT INTO sig_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Saŋa hʋ tɩyaŋ Yesu aa kaŋ ʋ tɩɩ ko daga ʋ hatɩnna hʋ, dɩ ʋ hatɩnna hʋ kɩdɩgɩ ba aa yɩrɩ Tɔmaasɩ kɛ fa tuwo. Ʋ feŋ kɩdɩgɩ mɛ rɛ fa yaa Daalɩyanɩ. ");
INSERT INTO sig_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ɛɛ rɛ ʋ hatɩnnɩ-kaalɩya hʋ basɩ tɩya ʋ a baa, “Á naa á Tɩɩna rɛ.” Ɛɛ rɛ Tɔmaasɩ basɩ tɩya ba a baa, “See dɩ ŋ na habibʋʋsɩ hʋ ʋ nosi tɩyaŋ, a kpa ŋ nonii dige doŋ fʋfʋʋnɩ, a kpa ŋ nonii tʋʋ ʋ logiŋ bʋwa hʋ mɛ tɩyaŋ, ka dɩ ŋ na laa ma wɩɩ hʋ di.” ");
INSERT INTO sig_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ʋ kyɛyɛ kyori hal tɩyaŋ, Yesu hatɩnna hʋ bɩl gyʋʋ dɩya a kaŋ dimbee hʋ lara. Saŋa no tɩyaŋ kɛ dɩ Tɔmaasɩ mɛ we ba tɩyaŋ. Ba ko yaa dɩ ba deŋ dɩ Yesu sɩŋ ba tʋtʋʋ aŋ baa, “Fɩyɛlʋʋ we ma lee.” ");
INSERT INTO sig_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ɛɛ rɛ ka ʋ basɩ tɩya Tɔmaasɩ a baa, “Kpa ɩ nonii a tʋʋ ŋ noŋ bʋwa hʋ tɩyaŋ aŋ deŋ ŋ nosi na, aŋ kpa ɩ nonii tʋʋ ŋ logiŋ bʋwa hʋ mɛ tɩyaŋ a na. Laa di, ta kɩ yaa sige.” ");
INSERT INTO sig_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ɛɛ rɛ Tɔmaasɩ baa, “Ɩ rɛ yaa ŋ tɩɩna abee ŋ Wɩɩsɩ.” ");
INSERT INTO sig_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ɛɛ rɛ Yesu pɩyɛsɩ ʋ baa, “Ɩ aa naa ŋ nɛ tɩŋ ɩ laa di nyɛ koo? Nyusʋŋtɩmma rɛ yaa nala hʋ aa bɩ naa ŋ, aŋ laa ŋ wɩya di.” ");
INSERT INTO sig_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu gyɩ yaa wɩmagɩla yʋga rɛ ʋ hatɩnna hʋ sɩɩ tɩyaŋ. Amɛ wɩya no buloŋ daa ŋ sabɩ we teŋ no tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amɛ ŋ sabɩ wɩya no rɛ dɩ ma wuwo laa di anɩɩ Yesu rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya, a yaa Wɩɩsɩ Biye mɛ. Dɩ mamaa rɛ laa ʋ wɩya di, ma sɩ kaŋ mɩɩbol aa bɩ kaŋ tenii. ");
INSERT INTO sig_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɛɛ hal tɩyaŋ nɛ Yesu gyɩ bɩl kaŋ ʋ tɩɩ ko daga ʋ hatɩnna badɔmɔŋ fuwo kɩdɩgɩ ba aa yɩrɩ Tibeeriya nyʋwa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siimɔŋ Piita abee Tɔmaasɩ, nal hʋ ba fa aa yɩrɩ Daalɩyanɩ, abee Nataniyɛl fa aa lɩɩ Keena aa we Galili paalʋʋ tɩyaŋ, abee Zebedi biisi hʋ, abee Yesu hatɩnna hʋ balɩya buloŋ nɛ gyɩ laŋŋa ka wɩɩ no yaa. ");
INSERT INTO sig_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nyɛ rɛ Yesu gyɩ tɩŋa a kaŋ ʋ tɩɩ ko daga ba: Ba gyɩ sɩŋ fuwo hʋ nyʋwa rɛ. Ɛɛ rɛ Siimɔŋ Piita basɩ tɩya ʋ dɔŋtɩŋsɩ hʋ anɩɩ ʋ aa mʋ dɩ ʋ kasɩ fuwonamɩɩsɩ rɛ. Ɛɛ rɛ ba buloŋ baa dɩ ba sɩ tɩŋa ʋ mʋ. Ɛɛ rɛ ba mʋ kpa nɩɩduworiboro a gyʋʋ nɩɩ hʋ tɩyaŋ, amɛ haŋ tebine hʋ buloŋ ba gyɩ bɩ kaŋ fuwonaŋ-dɩgɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ʋ sɩgballɩnyʋwa, Yesu ko sɩŋ nɩɩ hʋ nyʋwa, amɛ ʋ hatɩnna hʋ gyɩ bɩ gyɩma anɩɩ ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɛɛ rɛ Yesu pɩyɛsɩ ba a baa, “Ŋ kyaŋsɩ, ma ha bɩ kaŋ fuwonamɩya buloŋ?” Ba baa dɩ aayɩ. ");
INSERT INTO sig_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ma yuwo ma gyoŋ hʋ we nɩɩduworiboro hʋ noduu logiŋ dɩɩlaŋ, ma sɩ kasɩ fuwonamɩɩsɩ.” Ɛɛ rɛ ba yuwo gyoŋ hʋ a kasɩ fuwonamɩɩsɩ su. Ʋ aa suwo gɛɛ, ba bɩ wuwo dɩ ba gba tarɩ gyoŋ hʋ gyɩŋ. ");
INSERT INTO sig_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ɛɛ rɛ Yesu hatɩnnɩ hʋ ʋ fa aa kyo kɩŋkaŋ hʋ basɩ tɩya Piita a baa, “Á Tɩɩna rɛ basɩ wɩya kɩ ma gɛɛ.” Saŋa no tɩyaŋ dɩ Piita fa wuri ʋ gal lɛ. Ʋ aa nɩɩ gɛɛ, ʋ kpa ʋ gal hʋ laalɩ, aŋ lɩɩ nɩɩduworiboro hʋ tɩyaŋ, a gyaa tuu nɩɩ hʋ dɩ ʋ duwori mʋ Yesu lee. ");
INSERT INTO sig_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Doŋ bee nɩɩ hʋ nyʋwa fa bɩ boliye. Ʋ fa pele naaŋsɩɩnyʋwa kɔɔsɩ boto rɛ. Ka Yesu hatɩnna nɩkaalɩya hʋ aa we nɩɩduworiboro hʋ tɩyaŋ tarɩ gyoŋ hʋ abee fuwonamɩɩsɩ hʋ ko lɩɩ nɩɩ hʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba aa ko lɩɩ nɩɩ hʋ nyʋwa, ba na diŋ dɩ fuwonamɩɩsɩ kyɛbɛ ka ba na paanʋʋ mɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma lɩɩ fuwonamɩɩsɩ hʋ badɔmɔŋ ma aa kasa lagɩlagɩ no hʋ a kaŋ ko.” ");
INSERT INTO sig_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ɛɛ rɛ Siimɔŋ Piita mɩɩgɩ mʋ pɛ ba tarɩ gyoŋ hʋ ko gyɩŋ dogimo, dɩ fuwonamɩɩbala suwo. Fuwonamɩɩsɩ hʋ fa yaa kɔɔ abee mɔllɩbalɩya abee fi abee boto rɛ. Abee fuwonamɩɩsɩ hʋ gyɩ aa yʋga gɛɛ buloŋ amɛ gyoŋ hʋ gyɩ bɩ kɩyɛsa. ");
INSERT INTO sig_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ɛɛ rɛ Yesu basɩ tɩya ba a baa, “Ma ko bɩllɩ nyʋwa.” Ʋ aa basɩ gɛɛ, ʋ hatɩnna hʋ kɩdɩgɩ buloŋ gyɩ bɩ wuwo dɩ ʋ pɩyɛsɩ baa “Aŋnɛ rɛ yaa ɩ.” Beewɩya ba buloŋ gyɩma anɩɩ Tɩɩna hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ɛɛ rɛ Yesu kaŋ paanʋʋ hʋ kpaa tɩya ba, a kpaa fuwonamɩɩsɩ hʋ mɛ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ʋ aa sii sʋʋ tɩyaŋ, ʋ bʋto rɛ yaŋ nyɛ ʋ aa kaŋ ʋ tɩɩ ko daga ʋ hatɩnna. ");
INSERT INTO sig_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba aa dii kɩna hʋ ko teŋ, ɛɛ rɛ Yesu pɩyɛsɩ Siimɔŋ Piita a baa, “Gyɔɔŋ biibaal Siimɔŋ, ɩ kyo ŋ a te gɛɛ ɩ dɔŋtɩŋsɩ no aa kyo ŋ nɛ?” Ɛɛ rɛ Piita baa, “Waa, ŋ Tɩɩna, ɩ tɩɩ gyɩma anɩɩ ŋ kyo ɩ rɛ.” Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Kɩ deŋ ŋ hatɩnna nyuu anɩɩ pedaal aa kɩ deŋ ʋ piyese nyuu gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ ʋ a baa, “Gyɔɔŋ biibaal Siimɔŋ, ɩ kɔnɩ kyo ŋ nɛ?” Ɛɛ rɛ Piita bɩl baa, “Waa, ŋ Tɩɩna, ɩ gyɩma anɩɩ ŋ kyo ɩ rɛ.” Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ a baa, “Kɩ deŋ ŋ hatɩnna nyuu anɩɩ pedaal aa kɩ deŋ ʋ piyese nyuu gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɛɛ rɛ Yesu bɩl pɩyɛsɩ Piita bʋto tɩɩna a baa, “Gyɔɔŋ biibaal Siimɔŋ, ɩ kyo ŋ nɛ?” Yesu aa pɩyɛsɩ ʋ bʋto gɛɛ, Piita tɩya buloŋ kyogi, ʋ basɩ tɩya Yesu a baa, “Ŋ Tɩɩna, ɩ gyɩŋ wɩɩ buloŋ nɛ. Ɩ gyɩma anɩɩ ŋ kyo ɩ rɛ.” Ɛɛ rɛ Yesu bɩl basɩ tɩya ʋ a baa, “Kɩ deŋ ŋ hatɩnna nyuu anɩɩ pedaal aa kɩ deŋ ʋ piyese nyuu gɛɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wɩtɩɩ rɛ ŋ basɩ kɩ tɩya ɩ, ɩ fa aa yaa bapʋwasɩɩ, ɩ aa sii nyʋgɩlɩ ɩ tɩɩ rɛ, a kɩ mʋ lee hʋ buloŋ ɩ aa kyɛ. Amɛ dɩ ɩ rɛ ko hɩyasɩ, ɩ sɩ kaŋ ɩ nosi gye, aŋka dɩ ba vʋwa ɩ, a kana ɩ mʋ lee hʋ ɩ aa bee kyɛ.” ");
INSERT INTO sig_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu aa basɩ wɩɩ no daga gɛɛ hʋ Piita aa sɩ sʋba rɛ, a leŋ dɩ nala tɩŋ gɛɛ tɩyaŋ a na Wɩɩsɩ gaŋdarɩ aa maga gɛɛ. Ɛɛ rɛ ka Yesu basɩ tɩya ʋ a baa, “Kɩ tɩŋa ŋ hal.” ");
INSERT INTO sig_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ɛɛ rɛ Piita galdaasɩ hal, a na dɩ Yesu hatɩnnɩ hʋ Yesu fa aa kyo kɩŋkaŋ hʋ dɩ ʋ aa tɩŋ ba hal. Ʋ rɛ yaa nal no tɩɩna gyɩ aa hɔŋ kpala Yesu saŋa hʋ ba gyɩ aa di kɩdiiliye hʋ, a gyɩ pɩyɛsɩ ʋ a baa, “Ŋ Tɩɩna, aŋnɛ rɛ sɩ kpa ɩ yallɩ?” ");
INSERT INTO sig_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piita aa naa ʋ, ɛɛ rɛ ʋ pɩyɛsɩ Yesu a baa, “Ŋ Tɩɩna, ka baal no mɛ, bee rɛ sɩ yaa ʋ mɛ?” ");
INSERT INTO sig_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ɛɛ rɛ Yesu basɩ tɩya ʋ a baa, “Dɩ mɩyaŋ nɛ aa kyɛ dɩ ʋ we doŋ a mʋ pele saŋa hʋ ŋ aa sɩ mɩɩgɩ ko dʋnɩya mɛ, ɩ wɩbee rɛ we doŋ? Ɩ kɛ kɩ tɩŋa ŋ hal.” ");
INSERT INTO sig_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesu aa basɩ nyɛ wɩya, ʋ hatɩnna buloŋ gyɩ aa basɩ rɛ anɩɩ ʋ hatɩnnɩ no kɛ bɩ sɩ sʋba. Amɛ Yesu gyɩ bɩ baa dɩ ʋ bɩ sɩ sʋba. Wɩɩ hʋ ʋ gyɩ aa basa rɛ nyɛ: “Dɩ mɩyaŋ nɛ aa kyɛ dɩ baal no we doŋ a mʋ pele saŋa hʋ ŋ aa sɩ mɩɩgɩ ko dʋnɩya mɛ, Piita, ɩ wɩɩ tuwo.” ");
INSERT INTO sig_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hatɩnnɩ no rɛ yaa nal hʋ aa basɩ wɩya no, a bɩl sabɩ ba biŋ teŋ tɩyaŋ mɛ. Á gyɩma anɩɩ wɩya hʋ buloŋ ʋ aa basa yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yaa wɩya badɔmɔŋ mɛ rɛ yʋga a pɛ wɩya hʋ ŋ aa saba we teŋ no tɩyaŋ. Dɩ mɩyaŋ nɛ fa sabɩ wɩya hʋ buloŋ kɩŋ kɩŋ a biŋ tenni tɩyaŋ, ŋ bɩ tama tenni hʋ fa sɩ na lee a pɩŋ dʋnɩya no tɩyaŋ.");
INSERT INTO sig_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ŋ nɩhɩyawʋ Tiyofilɔsɩ, mɩyaŋ Luka rɛ bɩl sabɩ teŋ no kɩ tɩya ɩ. Teŋ hʋ ŋ aa laa sɩya sabɩ tɩya ɩ tɩyaŋ, ŋ daga wɩya hʋ buloŋ Yesu aa yaa rɛ abee wɩya hʋ ʋ aa daga, a lɩɩ saŋa hʋ ʋ aa piile kɩ tuŋ ʋ tʋma, ");
INSERT INTO sig_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","a mʋ pele kyɛɛ hʋ Wɩɩsɩ aa kpaa ʋ gyɩŋ wɩɩsɩbee. Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ, ʋ gyɩ daga ʋ kpambɩsɩ hʋ ʋ aa lɩya tʋma hʋ ba aa sɩ kɩ tʋma rɛ, aŋ na mʋ wɩɩsɩbee. ");
INSERT INTO sig_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ʋ aa sii sʋʋ tɩyaŋ mɛ, ʋ kana ʋ tɩɩ ko daga ʋ kpambɩsɩ hʋ buloŋ nɛ ʋ sʋʋ kyɛyɛ mɔllɩbalɩya paga tɩyaŋ. Ŋmaŋgyamaa rɛ ʋ gyɩ kpa, a kana ʋ tɩɩ ko daga ba, ba na ʋ, dɩ nal buloŋ ta yaa sige anɩɩ ʋ mɩɩgɩ sii sʋʋ tɩyaŋ nɛ. Ɛɛ rɛ ka ʋ gyɩ basɩ Wɩɩsɩ koro hʋ wɩya tɩya ba, aŋ na mʋ wɩɩsɩbee. ");
INSERT INTO sig_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yesu ha gyɩ aa we ʋ hatɩnna hʋ lee, ʋ gyɩ basɩ tɩya ba rɛ abee sɩfɩyasɩ a baa, “Ma ta ko kɩ lɩɩ Gyerusalɛm tɩyaŋ. Ma gyegili bɔnyɛ kɩŋ hʋ ŋ Kuwo aa wee nyʋwa a baa dɩ ʋ sɩ tɩya ma. Ŋ laa sɩya basɩ ʋ wɩya tɩya ma rɛ. ");
INSERT INTO sig_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gyɔɔŋ, Wɩɩsɩnɩɩfool hʋ kɛ, nɩɩ rɛ ʋ gyɩ kaŋ kɩ fo nala wɩɩkyʋwalnɩɩ. Amɛ ʋ bɩ sɩ pɩɩsɩ, ka dɩ Wɩɩsɩ kpa ʋ Wiyesi Welii hʋ fo ma wɩɩkyʋwalnɩɩ.” ");
INSERT INTO sig_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu bee ʋ kpambɩsɩ hʋ aa laŋŋa gɛɛ rɛ, ba pɩyɛsɩ ʋ a baa, “Á Tɩɩna, lagɩlagɩ no kɛ, ɩ sɩ leŋ dɩ Iziral tɩmma bɩl di ba paalʋʋ koro koo?” ");
INSERT INTO sig_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Doŋ nɛ Yesu basɩ tɩya ba a baa, “Wɩya no abee kyɛɛ hʋ ba aa sɩ yaa, ba we Ŋ kuwo lee rɛ. Ʋ kyɛrɩ tɩyaŋ nɛ ʋ biŋ ba buloŋ. Ɛɛwɩya, ʋ bɩ maga dɩ ma gyɩŋ kyɛɛ hʋ. ");
INSERT INTO sig_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amɛ dɩ Wɩɩsɩ ko kpa ʋ Wiyesi Welii hʋ we ma tɩyaŋ, ma sɩ kaŋ dee a yaa ŋ daŋsɩya diile a basɩ ŋ wɩya Gyerusalɛm tɩyaŋ, abee Gyudɩya paalʋʋ buloŋ tɩyaŋ abee Samaarɩya paalʋʋ buloŋ tɩyaŋ, a kaŋ kɩ mʋ dʋnɩya logiŋ kɛ buloŋ.” ");
INSERT INTO sig_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu aa basɩ gɛɛ ko teŋ, Wɩɩsɩ kpa ʋ kaŋ gyɩŋ wɩɩsɩbee, ka ʋ kpambɩsɩ hʋ sɩŋ wil nyuni kɩ deŋ wɩɩsɩnyuu. Nyɛ rɛ taal ko tɔ ʋ, ba bɩl bɩ na ʋ. ");
INSERT INTO sig_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ba ha aa sɩŋ wil nyuni kɩ deŋ wɩɩsɩnyuu gɛɛ, dɩ baala balɩya rɛ ko sɩŋ ba logiŋ tɩyaŋ gɛɛ, a laalɩ gapʋllɩ ");
INSERT INTO sig_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a pɩyɛsɩ ba a baa, “Galili tɩmma, bee rɛ tɩŋ ma sɩŋ kɩ deŋ wɩɩsɩnyuu nyɛ? Ɛɛ hʋ ma aa yaŋ na Wɩɩsɩ kpaa Yesu a kaŋ kɩ gyɩŋ wɩɩsɩbee ma sɩɩ tɩyaŋ nyɛ, ɛɛ tɩɩ rɛ ʋ sɩ bɩl mɩɩgɩ lɩɩ wɩɩsɩbee ko tuu.” ");
INSERT INTO sig_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ɛɛ rɛ Yesu kpambɩsɩ hʋ lɩɩ Olivi dogimo hʋ nyuu a mɩɩgɩ mʋ Gyerusalɛm. A lɩɩ dogimo hʋ kɩ mʋ Gyerusalɛm sɩ yaa anɩɩ meeldaa-kyalɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba ko pele Gyerusalɛm, a kpa mʋ ba dɩɩgyʋʋlɩɩ gyirambisa nyuu dɩya kɩdɩgɩ tɩyaŋ. Ba nala hʋ gyɩ aa laŋŋa kɩ gyʋʋ doŋ nɛ nyɛ: Piita, Gyɔɔŋ, Gyemsi, Aŋduru, Fɩlɩpɩ, Tɔmaasɩ, Batolomi, Matiwu, Alfiyasɩ biibaal Gyemsi, Siimɔŋ, nal hʋ aa kyɩl ʋ nala wɩya, abee Gyemsi biibaal Gyudasɩ. ");
INSERT INTO sig_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ba bee haana badɔmɔŋ abee Yesu nɩɩna Mɛɛrɩ abee Yesu nɩmmabalɩya buloŋ nɛ gyɩ yaa nyʋʋdɩgɩ aa kɩ laŋŋɩ doŋ saŋa buloŋ, a kɩ kyʋwalɩ Wɩɩsɩ abee sɩfɩyasɩ. ");
INSERT INTO sig_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nyɛ rɛ kyɛɛ kɩdɩgɩ ba ko laŋŋɩ dɔmɔŋ. Ba fa pel nala kɔɔ abee mɔlɩya. Ɛɛ rɛ Piita sii sɩŋ a baa, ");
INSERT INTO sig_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ŋ naabalɩya, Wɩɩsɩ Wiyesi Welii hʋ fa leŋ Deviti daga wɩya hʋ Gyudasɩ aa sɩ yaa rɛ. Ʋ maga dɩ Wɩɩsɩ nyʋwa no Deviti aa basa kɔnɩ ko yaa wɩtɩɩ rɛ. Beewɩya Gyudasɩ rɛ yaa nal hʋ aa kaŋ nala mʋ ba kaŋ Yesu. ");
INSERT INTO sig_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yesu fa lɩɩ ʋ rɛ ʋ yaa á kɩdɩgɩ, a mɛ pɛ á tʋma no tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Gyudasɩ gyɩ yaa wɩbɔŋ nɛ, a na molbiye doŋ a kpa yɔbɔ taŋha kɩdɩgɩ. Haŋ taŋha hʋ tɩyaŋ nɛ ʋ tele pɔsɔ, ʋ nabolimo buloŋ lɩɩ gyaasɩ. ");
INSERT INTO sig_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nala hʋ aa we Gyerusalɛm tɩyaŋ buloŋ nɛ gyɩ nɩɩ ʋ wɩya. Ɛɛ rɛ tɩŋ ba kaŋ lee hʋ kɩ yɩrɩ Akɛldama, ba taal tɩyaŋ. Ʋ memii rɛ yaa taŋha hʋ tɩyaŋ kyal aa gyaasa.) ");
INSERT INTO sig_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Deviti saba we Wɩɩsɩ teŋ logiŋ hʋ ba aa yɩrɩ Yɩɩla tɩyaŋ nɛ a baa, ‘Wɩɩsɩ sɩ leŋ dɩ ʋ dɩya pɩŋ gyikpiye, dɩ nal buloŋ ta kɩ gyʋʋ.’ Aŋ bɩl sabɩ abaa, ‘Amɛ ʋ tʋma kɛ, see dɩ nal laa ʋ nyuu a kɩ tʋma.’ ");
INSERT INTO sig_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ɛɛ wɩya ʋ maga dɩ nal laa ʋ nyuu rɛ a pɛ á tɩyaŋ dɩ á di daŋsɩya anɩɩ á Tɩɩna Yesu sii sʋʋ tɩyaŋ nɛ. Nal no tɩɩna maga dɩ ʋ lɩɩ á nala hʋ gyɩ aa tɩŋ á Tɩɩna Yesu hal lɛ, á beel-ʋ we doŋ saŋa buloŋ, ");
INSERT INTO sig_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a lɩɩ saŋa hʋ Gyɔɔŋ gyɩ aa foo Yesu wɩɩkyʋwalnɩɩ a kaŋ ko pele kyɛɛ hʋ Wɩɩsɩ aa kpaa ʋ á sɩɩ tɩyaŋ, a gyɩŋ wɩɩsɩbee.” ");
INSERT INTO sig_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nyɛ rɛ ba daga nala balɩya. Ba kɩdɩgɩ feŋ nɛ yaa Gyosɛfʋ Basabaasɩ. (Ʋ feŋ kɩdɩgɩ mɛ rɛ fa yaa Gyusitu.) Kɩdɩgɩ hʋ mɛ feŋ nɛ fa yaa Matɩyasɩ. ");
INSERT INTO sig_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ba aa daga nala hʋ gɛɛ rɛ, ba kyʋwalɩ Wɩɩsɩ a baa, “Á Tɩɩna, ɩ rɛ gyɩŋ nihuwobiŋ buloŋ tɩya. Ɛɛwɩya, nala no balɩya tɩyaŋ, daga ma nal hʋ ɩ aa lɩya dɩ ʋ yaa ɩ kpambɩsɩ hʋ kɩdɩgɩ a laa Gyudasɩ nyuu, a kɩ tuŋ ʋ tʋma. Beewɩya Gyudasɩ leŋ ma rɛ aŋ mʋ ʋ bee lee hʋ aa maga.” ");
INSERT INTO sig_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nyɛ rɛ ba yuwo gbaŋŋa, Matɩyasɩ di, ba lɩɩ ʋ pɛ Yesu kpambɩsɩ fi abee kɩdɩgɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nyɛ rɛ ba kyɛbal hʋ ba aa yɩrɩ Pɛŋtikosi kyɛɛ ko pele. Kyɛɛ no dɩ nala hʋ buloŋ aa laa Yesu wɩya di doŋ tɩyaŋ ko laŋŋɩ dɩɩdɩgɩ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba ko baa dɩ ba deŋ, dɩ dɔmɔ kɩdɩgɩ lɩɩ wɩɩsɩnyuu, a kɩɩ gɛɛ anɩɩ puwobal lɛ aa dɔŋ. Dɔmɔ hʋ ko gyʋʋ tɔ dɩya hʋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ɛɛ rɛ ka ba na kɩna badɔmɔŋ aa kɩɩ gɛɛ anɩɩ diŋtʋlnɩ, a ko pɩsa saga ba kɩdɩgɩ kɩdɩgɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nala hʋ buloŋ tɩyaŋ diŋtʋlnɩ hʋ gyɩ aa saga, Wɩɩsɩ gyɩ kpaa ʋ Wiyesi Welii hʋ we ba tɩyaŋ nɛ, ʋ gyɩ leŋ ba piili kɩ basɩ wɩya abee taanɩ ba aa bɩ gyɩma. ");
INSERT INTO sig_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gyuuma badɔmɔŋ mɛ fa we Gyerusalɛm tɩyaŋ, a yaa wɩɩkyʋwalla aa lɩɩ dʋnɩya logiŋ kɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nɩgyamaa no buloŋ gyɩ aa nɩɩ kyagɩŋsɩ hʋ, ba buloŋ ko kyige doŋ. Ba aa kyige gɛɛ, ba kɩdɩgɩ buloŋ gyɩ nɩɩ Yesu Krisita hatɩnna wɩbasɩɩ hʋ rɛ ʋ tɩɩ taal tɩyaŋ. Ʋ gyɩ yaa ba wɩkperii. ");
INSERT INTO sig_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Nyɛ rɛ wɩɩ hʋ marɩ yaa ba wɩkperii, ba kɩ pɩyɛsɩ dɔmɔŋ, a baa, “Ka nala no buloŋ aa basɩ wɩya hʋ yaa Galili tɩmma rɛ, ɛɛ rɛ á kɩdɩgɩ buloŋ yaŋ yaa kɩ nɩɩ ba wɩbasɩɩ hʋ á tɩɩ taanɩ tɩyaŋ nyɛ? ");
INSERT INTO sig_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Á buloŋ lɩɩ paalʋʋ dʋŋsɩ rɛ. Á badɔmɔŋ lɩɩ Paatɩya rɛ, á badɔmɔŋ lɩɩ Midiisi, á badɔmɔŋ mɛ lɩɩ Ilam. Á badɔmɔŋ lɩɩ Mesopotemiya rɛ, á badɔmɔŋ lɩɩ Gyudɩya, á badɔmɔŋ mɛ lɩɩ Kapadoosɩya, á badɔmɔŋ mɛ lɩɩ Pɔŋtusi, á badɔmɔŋ mɛ lɩɩ Esɩya. ");
INSERT INTO sig_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Á badɔmɔŋ lɩɩ Firigyiya rɛ, á badɔmɔŋ mɛ lɩɩ Pamfilɩya, á badɔmɔŋ lɩɩ Igyipiti, ka á badɔmɔŋ mɛ lɩɩ Libiya logiŋ kɩdɩgɩ aa kpaga tɔɔ hʋ ba aa yɩrɩ Sariini. Á badɔmɔŋ mɛ yaa nɩhʋwala rɛ, a lɩɩ Roma. Á badɔmɔŋ yaa Gyuuma, á badɔmɔŋ mɛ bɩ yaa Gyuuma, aŋ ta kɩ kyʋwalɩ Gyuuma Wɩɩsɩ, a kɩ tɩŋ ba lesiri mɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Á badɔmɔŋ lɩɩ Kiriti rɛ, á badɔmɔŋ mɛ lɩɩ Areebɩya. Á kɩdɩgɩ buloŋ mɛ yaŋ bee ʋ taal lɛ, ka á nɩɩ dɩ ba aa basɩ Wɩɩsɩ wɩduwoni hʋ ʋ aa yaa á tɩɩ taanɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nyɛ rɛ wɩɩ hʋ ha kperi ba, ba hakɩllɩ buloŋ vʋgɩmɩ, ba kɩ pɩyɛsɩ dɔmɔŋ a baa, “Wɩya no buloŋ memii rɛ yaa bee?” ");
INSERT INTO sig_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ɛɛ rɛ ka nala hʋ badɔmɔŋ mɛ kɩ yaa Yesu hatɩnna hʋ sɩya a baa dɩ ba nyʋwa sɩŋ bugo rɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nyɛ rɛ Yesu kpambɩsɩ hʋ sii sɩŋ, ka Piita heeli basɩ tɩya gyamaa hʋ a baa, “Ŋ kuwobalɩya Gyuuma abee nala hʋ buloŋ aa we Gyerusalɛm tɩyaŋ, ma wuwoli ma dɩgɩna, dɩ ŋ basɩ wɩya no aa yaa memii tɩya ma. ");
INSERT INTO sig_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma aa bɩɩnɩ anɩɩ nala no bugo rɛ? Amɛ, ma yaŋ gyɩma anɩɩ ba bɩ bugo. Beewɩya, ʋ ha yaa kyɩkyʋwala kerifi nibi rɛ, ɛɛ rɛ nal sɩ yaa bugo? ");
INSERT INTO sig_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amɛ Wɩɩsɩ tɩŋdaal Gyowɛl gyɩ basa wɩya no aa yaa wɩya rɛ anɩɩ nyɛ sɩ maakyiye yaa. Ʋ basa anɩɩ, ");
INSERT INTO sig_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Wɩɩsɩ baa, ‘Dɩ dʋnɩya rɛ ko kpaga tenii, nyɛ rɛ ŋ sɩ yaa. Ŋ sɩ kpa ŋ Wiyesi Welii hʋ we nala iriŋ buloŋ tɩyaŋ. Ma biibaala abee ma toliye sɩ basɩ wɩya ŋ Wiyesi Welii hʋ dee tɩyaŋ. Ma bapʋwasɩya abee ma banɩhɩyasɩ buloŋ mɛ sɩ kɩ na Wɩɩsɩ wɩtɩɩ hʋ ba duwoso tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Haŋ saŋa hʋ, ŋ sɩ kpa ŋ Wiyesi Welii hʋ tɩya baala abee haana hʋ aa tɩŋa ŋ kyɛrɩ, dɩ ba buloŋ kɩ basɩ wɩya ŋ Wiyesi Welii hʋ dee tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ŋ sɩ kɩ yaa wɩkperiye Wɩɩsɩnyuu tɩyaŋ, aŋ kɩ yaa wɩmagɩla mɛ dʋnɩya abee taŋhanyuu tɩyaŋ daha. Kyal, diŋ, abee nyʋwɔsɩ sɩ we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sɩgballɩya sɩ kɩɩ gɛɛ anɩɩ tebine. Ka dɩ pene mɛ fɩyɛsɩ gɛɛ anɩɩ kyal. Wɩya no buloŋ sɩ yaa rɛ, ka dɩ á Tɩɩna Kyɛbal hʋ yaŋ na pele. ");
INSERT INTO sig_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Haŋ kyɛɛ hʋ, nal hʋ buloŋ aa yɩrɩ á Tɩɩna Wɩɩsɩ, ʋ sɩ laa ʋ ta.’ ");
INSERT INTO sig_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ɛɛ hal tɩyaŋ nɛ Piita bɩl baa, ‘Iziral tɩmma, ma ha marɩ wuwoli ma dɩgɩna weliŋ a nɩɩ wɩya no ŋ aa basɩ kɩ tɩya ma: Yesu aa lɩɩ Nazarɛti, Wɩɩsɩ rɛ kɔnɩ tɩma ʋ. Wɩmagɩla hʋ abee wɩkperiye hʋ buloŋ Wɩɩsɩ aa leŋ ʋ wuwo yaa, ba aa rɛ daga gɛɛ. Ma buloŋ mɛ gyɩŋ wɩya no tɩyaŋ nɛ, beewɩya ma sɩɩ tɩyaŋ nɛ ʋ yaa ba buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wɩɩsɩ kyɛrɩ tɩyaŋ nɛ, ʋ gyɩmaa mɛ we doŋ, ka ba kaŋ Yesu Krisita we ma nosi tɩyaŋ. Ɛɛ rɛ ma kpa ʋ tɩya wɩbɔŋyaala, ba kpaasɩ ʋ mal daagarɩɩ tɩyaŋ, ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amɛ Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ, a lɩɩ tʋwara hʋ buloŋ ʋ aa naa ʋ sʋʋ saŋa ta. Beewɩya sʋʋ bɩ kaŋ dee ʋ aa sɩ wuwo kana ʋ biŋ dɩ ʋ ta siye.’ ");
INSERT INTO sig_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deviti fa basɩ ʋ wɩya rɛ a baa, ‘Ŋ gyɩ naa ŋ Tɩɩna rɛ dɩ ʋ laa ŋ sɩya, aŋ we ŋ lee saŋa buloŋ, dɩ nal buloŋ ta wuwo yaa ŋ wɩbɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nyɛ aa leŋ ŋ bembii pɩŋ lɩdɩgɩ rɛ, ŋ kɩ basɩ wɩya abee teŋfɩyɛlʋʋ. Ŋ yaa nihuwobiŋ nɛ, a gyɩma anɩɩ ŋ sɩ maakyiye sʋba. Amɛ ŋ bayɩyɛla buloŋ mɛ we wɩya hʋ Wɩɩsɩ aa sɩ yaa tɩya ŋ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dɩ mɩyaŋ nɛ ko sʋba, ɩ Wɩɩsɩ bɩ sɩ laa nyʋwa vɩya ŋ ta lalɩyabee tɩyaŋ. Ɩ bɩ sɩ laa nyʋwa leŋ dɩ ɩ tʋŋtʋnnɩ hʋ aa kaŋ wɩtɩɩ pɩŋ bʋwa tɩyaŋ a pʋwa. ");
INSERT INTO sig_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɩ daga ŋ ŋmanɩɩ hʋ ŋ aa sɩ tɩŋa a kaŋ mɩɩbol lɛ. Ɩ aa we ŋ lee mɛ rɛ yaŋ sɩ leŋ dɩ ŋ kaŋ teŋfɩyɛlʋʋ.’ ");
INSERT INTO sig_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nyɛ rɛ Piita bɩl basɩ baa, Ŋ kuwobalɩya, ŋ sɩ basɩ á naabaa Deviti wɩya a kaŋ polli tɩya ma. Deviti sʋba rɛ, ba kpa ʋ hogo, ʋ bil ha pɩŋ á bee tɩyaŋ daha a kaŋ kɩ ko gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ʋ fa yaa Wɩɩsɩ tɩŋdaal lɛ, a gyɩŋ wɩya hʋ buloŋ Wɩɩsɩ aa wee nyʋwa dɩ ʋ sɩ yaa tɩya ʋ. Wɩɩsɩ wee nyʋwa rɛ anɩɩ ʋ sɩ leŋ dɩ Deviti doho nal dɩ koro a kɩɩ gɛɛ anɩɩ Deviti fa aa kɩya. ");
INSERT INTO sig_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deviti fa aa naa wɩɩ hʋ Wɩɩsɩ fa aa kyɛ dɩ ʋ yaa, ʋ wuwo basɩ Krisita sʋʋ tɩyaŋ mɩɩgɩ siiyi wɩya rɛ a baa, ‘Wɩɩsɩ bɩ laa nyʋwa vɩya ʋ ta lalɩyabee tɩyaŋ. Ʋ bɩ laa nyʋwa leŋ ʋ teŋbii pɩŋ bʋwa tɩyaŋ a pʋwa.’ ");
INSERT INTO sig_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu no tɩɩ rɛ yaŋ Wɩɩsɩ kyisi sʋʋ tɩyaŋ gɛɛ. Á buloŋ nɛ yaa wɩɩ no daŋsɩya beewɩya á naa wɩya no buloŋ aa yaa rɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ nɛ ʋ sii gyɩŋ hɔŋ ʋ kuwo Wɩɩsɩ noduu logiŋ tɩyaŋ, ka ʋ kpa Wiyesi Welii hʋ wɩya ʋ fa aa wee nyʋwa a tɩya ʋ. Wiyesi Welii no rɛ Yesu kpa we á tɩyaŋ gyɩnaŋ, ʋ rɛ yaa wɩya hʋ ma aa na abee wɩya hʋ ma aa nɩɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deviti tɩɩ fa bɩ gyɩŋ mʋ Wɩɩsɩbee anɩɩ Yesu aa mʋwa gɛɛ, amɛ Yesu wɩya rɛ ʋ fa basɩ a baa, ‘Á Tɩɩna basɩ tɩya ŋ Tɩɩna rɛ, a baa Ko hɔŋ ŋ noduu logiŋ tɩyaŋ,’ ");
INSERT INTO sig_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ka dɩ ŋ yuwo di ɩ dɔmɔ buloŋ teŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ɛɛwɩya, Iziral tɩmma, ma buloŋ yaŋ gyɩma anɩɩ ʋ yaa wɩtɩɩ rɛ anɩɩ Yesu no ma aa kaŋ kpaasɩ mal daagarɩɩ hʋ tɩyaŋ, ʋ tɩɩ rɛ Wɩɩsɩ leŋ ʋ yaa á Tɩɩna. Ʋ rɛ bɩl yaa nal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta.” ");
INSERT INTO sig_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nala no aa nɩɩ wɩya hʋ buloŋ Piita fa aa basa, ʋ fa yaa ba dɔgɩsɩɩ rɛ kɩŋkaŋ. Ɛɛ rɛ ba mɩɩgɩ pɩyɛsɩ Piita bee Yesu kpambɩsɩ hʋ nɩkaalɩya hʋ a baa, ‘Á nɩmmabalɩya, wɩya no yaŋ aa kɩɩ nyɛ, ɛɛ rɛ maga dɩ á yaa?’ ");
INSERT INTO sig_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nyɛ rɛ Piita basɩ tɩya ba a baa, ‘Ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ, aŋ leŋ dɩ ba fo ma wɩɩkyʋwalnɩɩ Yesu Krisita feŋ tɩyaŋ, dɩ Wɩɩsɩ kpa ma wɩbɔmɔ kyɛ ma, aŋ kpa ʋ Wiyesi Welii hʋ we ma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Beewɩya, Wiyesi Welii hʋ wɩya Wɩɩsɩ aa wee nyʋwa a baa dɩ ʋ sɩ tɩya ma bee ma doho nala, abee nala hʋ buloŋ aa lɩɩ liboliye, abee nal hʋ kɛ buloŋ Wɩɩsɩ aa yɩra dɩ ʋ ko ʋ lee, ma wɩya rɛ ʋ we haŋ nyʋwa hʋ.”’ ");
INSERT INTO sig_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ɛɛ hal tɩyaŋ, Piita bɩl basɩ wɩya rɛ kɩŋkaŋ a kpaanɩ ba abee sɩfɩyasɩ, aŋ ha sʋl ba a baa, “Ma lɩɩ ma tɩɩma nɩbɔmɔ no tɩyaŋ, dɩ tʋwara hʋ aa sɩ ko ba nyuu tɩyaŋ ta ko daagɩ ma.” ");
INSERT INTO sig_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Piita wɩbasɩɩ hʋ hal tɩyaŋ, nɩgyamaa gyɩ ko laa wɩya hʋ ʋ aa basa di rɛ, aŋ leŋ ba fo ba wɩɩkyʋwalnɩɩ. Nala hʋ gyɩ aa laa Yesu wɩya di haŋ kyɛɛ hʋ, ba gyɩ pele nala tusi bʋto rɛ, a pɛ nɩbɩnɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba gyɩ kaŋ nyʋʋdɩgɩ rɛ, a kaŋ sɩfɩyala mɛ, aŋ kpa ba nyuni we wɩya hʋ buloŋ Yesu kpambɩsɩ hʋ aa daga ba tɩyaŋ. Ba buloŋ nɛ gyɩ aa laŋŋɩ kɩ di kɩdiiliye hʋ Yesu fa aa baa dɩ ba di a kɩ liisi ʋ wɩya, aŋ pɛ dɔmɔŋ kɩ kyʋwalɩ Wɩɩsɩ, a kɩ gʋnnɩ Wɩɩsɩ Teŋ wɩya hʋ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesu kpambɩsɩ hʋ gyɩ aa yaa wɩmagɩla abee wɩkperiye rɛ yʋga, ʋ gyɩ yaa nal buloŋ nyʋʋfɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Saŋa kɛ buloŋ, nala hʋ aa laa Yesu wɩya di aa ko laŋŋɩ dɔmɔŋ nɛ, a kpa ba kɩna buloŋ mɛ we lɩdɩgɩ, a kpa kɩ kpaa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dɩ ba ko yallɩ ba kɩna mɛ, ba aa kaŋ molbiye hʋ kpaa dɔmɔŋ nɛ, a maga gɛɛ hʋ nal buloŋ aa kyɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Kyɛɛ buloŋ ba aa laŋŋɩ ba dɩɩsɩ tɩyaŋ nɛ, a kɩ di kɩdiiliye abee teŋfɩyɛlʋʋ, abee tɩdɩgɩ, aŋ kɩ dannɩ Wɩɩsɩ. Aŋ ha bɩl aa kɩ laŋŋɩ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, a kɩ kyʋwalɩ Wɩɩsɩ aŋ kɩ bigisi ʋ. Ka nala mɛ kɩ bigisi ba abee ba wɩyaalɩya buloŋ tɩyaŋ. Kyɛɛ buloŋ nɛ á Tɩɩna aa laa nɩfalɩya ta, ba ko kɩ pɛ nala hʋ aa laa Yesu wɩya di tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kyɛɛ kɩdɩgɩ, Piita bee Gyɔɔŋ gyɩ sii mʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ Wɩɩsɩ kyʋwalɩɩ saŋa. Saŋa no gyɩ yaa nɩɩ wɩɩhaa kerifi boto rɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ba aa mʋ dɩ baal kɩdɩgɩ mɛ we doŋ. Ʋ naa paalɩ kɩ lʋla ʋ dɩ ʋ gbarɩga rɛ. Kyɛɛ kɛ buloŋ ʋ nala aa kpa ʋ mʋ holli Wɩɩkyʋwaldɩɩbal hʋ paganyʋwa hʋ ba aa yɩrɩ Pagɩwelii hʋ tɩyaŋ nɛ. Doŋ tɩyaŋ nɛ ʋ gyɩ aa hɔŋ, a kɩ sʋla kɩna nala hʋ aa gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ lee. ");
INSERT INTO sig_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ʋ gyɩ aa naa Piita bee Gyɔɔŋ dɩ ba aa ko dɩ ba gyʋʋ wɩɩkyʋwaldɩya hʋ, ʋ sʋla kɩna ba lee. ");
INSERT INTO sig_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nyɛ rɛ ba kɩ deŋ ʋ sɩya tɩyaŋ, aŋka Piita basɩ tɩya ʋ dɩ ʋ mɛ kɩ deŋ ba. ");
INSERT INTO sig_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɛɛ rɛ ʋ kɩ deŋ ba aŋ kɩ yɩyɛlɩ anɩɩ ba sɩ tɩya ʋ kɩŋ. ");
INSERT INTO sig_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nyɛ rɛ Piita mɩɩgɩ basɩ tɩya ʋ, “Ŋ bɩ kaŋ molbii buloŋ ŋ aa sɩ tɩya ɩ, amɛ kɩŋ hʋ ŋ aa kana, ʋ rɛ ŋ sɩ kpa tɩya ɩ. Yesu Krisita aa lɩɩ Nazarɛti feŋ tɩyaŋ, ŋ baa ‘Sii kɩ vala.”’ ");
INSERT INTO sig_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ʋ aa basɩ gɛɛ rɛ, ʋ kana ʋ noduu noŋ tɩyaŋ, a kana ʋ tarɩ sii sɩŋ. Ʋ naasɩ buloŋ pirigi tannɩ, a deye deye. ");
INSERT INTO sig_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nyɛ rɛ ʋ sii gyaa kyigisi ʋ naasɩ tɩyaŋ, a kɩ vala. Ɛɛ rɛ ba buloŋ kpa gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. Ka baal hʋ vala aŋ sii kɩ gyaa, a kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nala hʋ buloŋ na ʋ, dɩ ʋ aa val aŋ kɩ dannɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba aa na ʋ, ba wuwo gyɩma rɛ anɩɩ ʋ rɛ fa aa hɔŋ Pagɩwelii hʋ nyʋwa tɩyaŋ kɩ sʋla kɩna gɛɛ. Nyɛ rɛ ba buloŋ hirigi, beewɩya ba kɛ lee, wɩkperii rɛ ba na gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nyɛ rɛ Piita bee Gyɔɔŋ abee baal hʋ buloŋ sii mʋ gyʋʋ gyambarɩŋ kɩdɩgɩ ba kɩ yɩrɩ Solomɔn Gyambarɩŋ. Nala hʋ aa naa baal hʋ dɩ ʋ aa tɩŋ Piita bee Gyɔɔŋ hal gɛɛ, ba sii giri fá mʋ dɩ ba na ʋ, beewɩya wɩkperii rɛ ba kɛ na gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piita aa naa nala hʋ aa yaa gɛɛ rɛ, ʋ pɩyɛsɩ ba a baa, “Ŋ kuwobalɩya Iziral tɩmma, bee rɛ tɩŋ wɩɩ no yaa wɩkperii ma lee, haalɩ, ma paalɩ kuwoni ma sɩyasɩ we á tɩyaŋ nyɛ? Ma ta ko liisi anɩɩ á tɩɩ dee koo á wɩweliye yayɩ rɛ tɩŋ baal no sii kɩ vala nyɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abɩraham abee Azɩkɩ abee Gyeekɔbɩ abee á naabaala Wɩɩsɩ hʋ rɛ kpaa feŋbal a tɩya ʋ tʋŋtʋnnɩ Yesu. Nal hʋ ma aa kaŋ tɩya ba di ʋ sarɩya. Ɛɛ rɛ ka ma bɩl tʋwa Pilato, sarɩdiil hʋ sɩya tɩyaŋ, anɩɩ ma bɩ gyɩma ʋ. Haalɩ, Pilato fa kɩ kyɛ dɩ ʋ kpa ʋ ta, ka ma bɩ laa nyʋwa dɩ ʋ ta ʋ. ");
INSERT INTO sig_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wɩɩsɩ Tɩpʋlʋŋ Tɩɩna, nal hʋ aa yaa wɩweliye hʋ, ʋ rɛ ma vɩya, aŋ sʋla dɩ ba kpa Barabaasɩ, nal hʋ aa kpʋ nala, a ta. ");
INSERT INTO sig_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Aŋ leŋ ba kpʋ nal hʋ aa tɩya mɩɩbol hʋ aa bɩ kaŋ tenii. Amɛ á dii daŋsɩya rɛ anɩɩ Wɩɩsɩ kyisi baal no rɛ sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Baal no ma aa naa dɩ ʋ deye nyɛ, haŋ Yesu hʋ dee tɩyaŋ nɛ. Á laa ʋ dee hʋ wɩya di rɛ, ɛɛ rɛ tɩŋ wɩɩ no wuwo yaa nyɛ. Á aa laa ʋ wɩya di hʋ rɛ tɩŋ baal no wuwo na laaŋfɩya ma buloŋ sɩɩ tɩyaŋ nyɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ŋ naabalɩya, ŋ gyɩma anɩɩ ma bee ma nɩhɩyasɩ gyɩ aa bɩ gyɩma rɛ tɩŋ ma kpʋ Yesu Krisita gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Faafaa buloŋ nɛ Wɩɩsɩ leŋ ʋ tɩŋdaala basɩ anɩɩ nal hʋ ʋ aa lɩya dɩ ʋ ko laa dʋnɩya nala ta sɩ na tʋwara. Ɛɛ mɛ kɔnɩ yaŋ ko yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ɛɛwɩya, ma bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ aŋ kɩ tɩŋ Wɩɩsɩ, dɩ ʋ kpa ma wɩbɔmɔ kyɛ ma, a leŋ dɩ ma bembiye fɩyɛlɩ. ");
INSERT INTO sig_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ka dɩ Wɩɩsɩ bɩl tɩŋ Krisita hʋ, nal hʋ ʋ aa lɩya dɩ ʋ ko ma lee. Ʋ rɛ yaa Yesu. ");
INSERT INTO sig_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ʋ maga dɩ ʋ we Wɩɩsɩbee tɩyaŋ nɛ, a kaŋ kɩ mʋ saŋa hʋ Wɩɩsɩ aa sɩ leŋ dɩ dʋnɩya wɩɩ buloŋ ko bɩrɩmɩ wɩfalɩɩ. Faafaa buloŋ nɛ Wɩɩsɩ leŋ ʋ tɩŋdaala basɩ wɩya no ʋ Wiyesi Welii hʋ dee tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moosi mɛ fa yaa Wɩɩsɩ tɩŋdaala no kɩdɩgɩ rɛ. Ʋ gyɩ basɩ baa, ‘Á Tɩɩna Wɩɩsɩ sɩ tɩŋ ʋ tɩŋdaal kɩdɩgɩ dɩ ʋ ko ma lee anɩɩ ʋ aa tɩma ŋ gɛɛ. Ʋ sɩ yaa ma nɩɩnabiye tɩɩ. Dɩ ʋ rɛ ko ko, ma laa ʋ nyʋwa wɩbasɩya buloŋ di, aŋ tɩŋa ʋ. ");
INSERT INTO sig_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nal hʋ buloŋ ko bɩ tɩŋ ʋ nyʋwa, Wɩɩsɩ sɩ lɩɩ ʋ tɩɩna ta ʋ nala tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wɩya no buloŋ á aa naa nyɛ gyɩnaŋ, Wɩɩsɩ tɩŋdaala hʋ ʋ aa taa dɩ ba ko basɩ ʋ wɩya hʋ laa sɩya basɩ wɩya no aa sɩ yaa wɩya rɛ. A piili Samuwɛl abee nala hʋ buloŋ aa tɩŋa ʋ hal ko, ba buloŋ mɛ basɩ wɩya no yayɩ wɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nyʋʋsɩ hʋ buloŋ Wɩɩsɩ aa bine ʋ tɩŋdaala hʋ ko basɩ gɛɛ, mamaa rɛ ʋ biŋ ba buloŋ tɩya. Ʋ biŋ tɩya á naabaala rɛ ka ba ha pɩŋ gbal ma mɛ gyɩnaŋ. Beewɩya ʋ gyɩ basɩ tɩya Abɩraham nɛ a baa, ‘I doho nala tɩyaŋ nɛ ŋ sɩ tɩŋa a leŋ dɩ dʋnɩya nala buloŋ na marɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɛɛ rɛ tɩŋ Wɩɩsɩ lɩɩ ʋ tʋŋtʋnnɩ Yesu á Tɩɩna, dɩ ʋ laa sɩya ko ma lee, a pɛ ma tɩyaŋ dɩ ma buloŋ bɩrɩmɩ lɩɩ ma wɩbɔmɔ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piita bee Gyɔɔŋ ha fa aa sɩŋ basɩ wɩya kɩ tɩya nala hʋ gɛɛ, dɩ Gyuuma wɩɩkyʋwal sɩlaala hʋ badɔmɔŋ abee nala hʋ aa sɩŋ kɩ pɔ Wɩɩkyʋwaldɩɩbal nɩhɩyawʋ abee nala hʋ ba aa yɩrɩ Sadusiima badɔmɔŋ nɛ mʋ kpa ko ba lee gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nyɛ rɛ ba ko na baaŋ Piita bee Gyɔɔŋ nyuu tɩyaŋ kɩŋkaŋ, beewɩya, ba fa aa daga nala hʋ rɛ anɩɩ Yesu sii sʋʋ tɩyaŋ nɛ. Ɛɛ daga anɩɩ dɩ nal lɛ sʋba, ʋ tɩɩna sɩ mɩɩgɩ sii sʋʋ tɩyaŋ nɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nyɛ rɛ ba kaŋ Piita bee Gyɔɔŋ mʋ tɔ dɩya tɩyaŋ sɩya gballɩ. (Ba gyɩ aa kasɩ ba saŋa hʋ dɩ wɩɩsɩ gyʋwa rɛ. Ɛɛ rɛ tɩŋ ba gyɩ kaŋ ba mʋ tɔ dɩya tɩyaŋ dɩ sɩya gballɩ). ");
INSERT INTO sig_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ka nala hʋ aa nɩɩ wɩya hʋ ba aa basa, ba yʋga gyɩ ko laa Yesu wɩya di rɛ. Nala hʋ gyɩ aa laa Yesu wɩya di tɩyaŋ, ba baala dʋŋ gyɩ pele nala tusi bɔnɔŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ʋ sɩgballɩya, Gyuuma sɩlaala abee ba nɩhɩyasɩ abee Wɩɩsɩ Tenni dɩdagɩla buloŋ nɛ gyɩ ko laŋŋɩ Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ba bee Anaasɩ, Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ, abee Kayifasɩ, abee Gyɔɔŋ abee Alizaŋda, abee nala hʋ kɛ buloŋ aa lɩɩ ba wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ doho nala tɩyaŋ nɛ gyɩ ko laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba aa ko laŋŋɩ teŋ, ba yɩrɩ Yesu kpambɩsɩ hʋ balɩya ba lɩɩ sɩŋ ba tʋtʋʋ tɩyaŋ, a pɩyɛsɩ ba a baa, “Degɛɛ rɛ ma kana, a wuwo leŋ baal no deye nyɛ, koo aŋnɛ feŋ nɛ ma yɩrɩ a leŋ baal no deye nyɛ?” ");
INSERT INTO sig_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ Piita basɩ tɩya ba a baa, “Mamaa aa yaa sɩlaala abee nɩhɩyasɩ, ");
INSERT INTO sig_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma kaŋ ma ko kɩ di á sarɩya rɛ gyɩnaŋ akuu á aa yaa wɩwelii a tɩɩbɩ gbarɩgɩ no wɩya. ");
INSERT INTO sig_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ʋ yaŋ maga dɩ ma nala no abee Iziral tɩmma buloŋ gyɩma rɛ anɩɩ Yesu Krisita aa lɩɩ Nazarɛti, ʋ feŋ tɩyaŋ nɛ baal no wuwo deye a sɩŋ ma sɩya tɩyaŋ nyɛ. Ʋ rɛ ma leŋ ba kaŋ kpaasɩ mal daagarɩɩ hʋ tɩyaŋ ʋ sʋba gɛɛ, ka Wɩɩsɩ kyisi ʋ sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu wɩya rɛ ba basɩ Wɩɩsɩ teŋ tɩyaŋ a baa, ‘Bʋyɩ hʋ dɩɩsaala hʋ aa vɩya ta, ʋ rɛ ko yaa wara hʋ buloŋ tɩyaŋ sɩfɩyaŋ bʋyɩ.’ ");
INSERT INTO sig_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nal buloŋ tuwo dʋnɩya no tɩyaŋ aa sɩ wuwo laa ma ta dɩ Yesu dʋŋ daa. Ʋ dʋŋ feŋ nɛ Wɩɩsɩ baa dɩ á yɩrɩ, dɩ ʋ laa ma ta.” ");
INSERT INTO sig_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nala hʋ buloŋ aa laŋŋa aa ko na anɩɩ Gyɔɔŋ bee Piita aa basɩ wɩya hʋ abee nyuduwo gɛɛ, ba nyʋʋsɩ gyɩ mɩɩgɩ fɩyɛlɩ rɛ, beewɩya ba gyɩma anɩɩ ba tuwo bol buloŋ tɩyaŋ, a yaa nyuguliŋ tɩmma mɛ, a bɩ mʋʋ sakuuri. Doŋ tɩyaŋ nɛ ba hakɩllɩ yaŋ ko anɩɩ ba gyɩ aa tɩŋ Yesu hal lɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nyɛ rɛ ba kyɛ wɩɩ lɔlɔ ba aa sɩ basɩ, beewɩya ba naa Piita bee Gyɔɔŋ abee gbarɩgɩ hʋ ba aa tɩɩba, dɩ ba buloŋ sɩŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nyɛ rɛ ba basɩ tɩya ba dɩ ba mʋ lɩɩ dɩya hʋ tɩyaŋ. Ɛɛ rɛ ba kpa lɩɩ, ka ba yaŋ hɔŋ kɩ pɩyɛsɩ dɔmɔŋ; “Ɛɛ rɛ á sɩ yaa baala no balɩya? ");
INSERT INTO sig_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Á bɩ sɩ wuwo baa dɩ wɩɩ no yaa wɩnyɩyɛl lɛ, beewɩya nal buloŋ aa we Gyerusalɛm tɩyaŋ gyɩma rɛ anɩɩ ba aa rɛ yaa wɩmagɩl no. ");
INSERT INTO sig_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amɛ dɩ ámaa rɛ aa kyɛ dɩ wɩɩ no ta marɩ taalɩ yʋga, ma leŋ dɩ á basɩ tɩya ba abee sɩfɩyasɩ anɩɩ ba ta bɩl ko maakyiye basɩ Yesu Krisita wɩya a tɩya nal buloŋ.” ");
INSERT INTO sig_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nyɛ rɛ ba bɩl yɩrɩ ba ko gyʋʋ, a basɩ tɩya ba abee sɩfɩyasɩ anɩɩ ba ta bɩl ko maakyiye basɩ Yesu wɩya koo a daga nala ʋ feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ɛɛ rɛ Piita bee Gyɔɔŋ pɩyɛsɩ ba a baa, “Á aa tɩŋ ma nyʋwa, abee á aa tɩŋ Wɩɩsɩ nyʋwa, kɩbee rɛ yaa ŋmanɩɩ Wɩɩsɩ sɩya tɩyaŋ? Ma basɩ wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Á yaŋ bɩ sɩ wuwo tallɩ á nyʋwa, see dɩ á basɩ wɩya hʋ á aa nɩya abee wɩya hʋ á aa naa.” ");
INSERT INTO sig_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nyɛ rɛ nala hʋ bɩl marɩ fugisi Piita bee Gyɔɔŋ kɩŋkaŋ, aŋ na kpa ba ta. Amɛ ba gyɩ naa anɩɩ ba bɩ sɩ wuwo yaa ba wɩɩ buloŋ, beewɩya nala hʋ buloŋ gyɩ aa dannɩ Wɩɩsɩ rɛ abee wɩɩ hʋ aa yaa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gbarɩgɩ no ba gyɩ aa tɩɩba, ʋ gyɩ tee bɩsɩ mɔllɩbalɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba aa yaŋ kpa Piita bee Gyɔɔŋ ta, ba mɩɩgɩ mʋ nɩkaalɩya hʋ aa laa Yesu wɩya di lee rɛ, ba beel-ba laŋŋɩ. Doŋ nɛ ba kpa wɩya hʋ buloŋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ abee bee nɩhɩyasɩ hʋ aa basa, a basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba aa basɩ wɩya no ko teŋ, ba buloŋ piili kɩ kyʋwalɩ Wɩɩsɩ abee tɩdɩgɩ a baa, “Á Tɩɩna Wɩɩsɩ, ɩ rɛ taa wɩɩsɩnyuu abee taŋha buloŋ, abee fuwoni abee kɩna hʋ buloŋ aa we ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɩ Wiyesi Welii hʋ dee tɩyaŋ nɛ ɩ leŋ á naabaa Deviti, Ɩ tʋŋtʋnnɩ hʋ basɩ a baa, ‘Bee rɛ tɩŋ nala hʋ aa bɩ yaa Gyuuma kɩ na baaŋ kɩŋkaŋ nyɛ? Bee rɛ tɩŋ nala no aa vʋʋlɩ dɩ ba sɩ kyogi Wɩɩsɩ tʋma aŋ lɔlɔ? ");
INSERT INTO sig_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dʋnɩya nyuu kuworo laŋŋɩ dɔmɔŋ nɛ, a yaa siri, ba tɩyaŋ nɩhɩyasɩ naa dɔmɔŋ nɛ, a yaa nyʋʋdɩgɩ dɩ ba yuwo á Tɩɩna abee ʋ Krisita hʋ, laataal hʋ ʋ aa lɩya dɩ ʋ ko laa dʋnɩya nala ta.’ ");
INSERT INTO sig_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wɩya no buloŋ yaŋ kɔnɩ ko yaa wɩtɩɩ rɛ, Beewɩya Hɛrɔtɩ bee Pɔŋtiyo Pilato abee nala hʋ aa bɩ yaa Gyuuma abee Iziral tɩmma, ba buloŋ gyɩ ko laŋŋɩ rɛ bee no tɩyaŋ dɩ ba yuwo Yesu, Ɩ tʋŋtʋnnɩ welii hʋ Ɩ aa lɩya dɩ ʋ yaa Krisita hʋ. ");
INSERT INTO sig_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba gyɩ laŋŋa yaa wɩya hʋ ɩ aa paalɩ gyɩma ɩ dee tɩyaŋ abee ɩ kyɛrɩ tɩyaŋ anɩɩ ba sɩ kɔnɩ yaa rɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Á Tɩɩna Wɩɩsɩ, yaŋ deŋ na, gyɩnaŋ kyɛɛ no ɛɛ hʋ ba aa fugisi ma anɩɩ ba sɩ dɔgɩsɩ ma. Ɛɛwɩya, pɛ ɩ tʋŋtʋnna tɩyaŋ dɩ á tenni polli, dɩ á wuwo kɩ basɩ ɩ wɩya abee nyuduwo. ");
INSERT INTO sig_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Daga ɩ dee, a leŋ dɩ wɩɩla tɩmma abee taaga buloŋ na laaŋfɩya. Ka dɩ á mɛ wuwo kɩ yaa wɩkperiye abee wɩmagɩla, Ɩ tʋŋtʋnnɩ welii Yesu feŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba aa kyʋwalɩ Wɩɩsɩ hʋ ko teŋ, dɩ lee hʋ ba aa laŋŋa buloŋ gyigise rɛ. Wɩɩsɩ Wiyesi Welii hʋ ko gyʋʋ ba kɩdɩgɩ buloŋ tɩyaŋ. Ba piili kɩ basɩ Wɩɩsɩ wɩya abee nyuduwo. ");
INSERT INTO sig_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nala hʋ buloŋ aa laa Yesu wɩya di fa kaŋ nyʋʋdɩgɩ rɛ, a kaŋ tɩdɩgɩ mɛ. Dɩ ba kɩdɩgɩ buloŋ nɛ kaŋ kɩŋ mɛ, ʋ aa bɩ kaŋ kɩ yɩrɩ ʋ dʋŋ kɩŋ. Ʋ aa kpa ʋ nɩɩ ʋ bɩrɩmɩ ba buloŋ kɩŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wɩɩsɩ dee tɩyaŋ, Yesu kpambɩsɩ hʋ gyɩ wuwo kaŋ dee abee nyuduwo rɛ, a basɩ kɩ tɩya nala anɩɩ á Tɩɩna Yesu sii sʋʋ tɩyaŋ nɛ, ka Wɩɩsɩ mɛ kɩ pɛ nala hʋ buloŋ aa laa Yesu wɩya di tɩyaŋ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nala hʋ buloŋ fa aa kaŋ dɩɩsɩ abee bagɩsɩ, ba aa kpa ba buloŋ yallɩ rɛ, a kaŋ molbiye hʋ ba aa naa, a mʋ Yesu kpambɩsɩ hʋ lee. ");
INSERT INTO sig_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ba gyɩ aa kaŋ molbiye hʋ kpaa dɔmɔŋ nɛ, nal buloŋ na a maga ɛɛ hʋ ʋ aa kyɛ. Ɛɛwɩya, ba nala hʋ kɩdɩgɩ buloŋ fa bɩ kyɛɛ kɩŋ kɩ lɔlɔ. ");
INSERT INTO sig_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Baal kɩdɩgɩ mɛ rɛ gyɩ we ba tɩyaŋ ba kɩ yɩrɩ Gyosɛfʋ. Yesu kpambɩsɩ hʋ fa kana ʋ kɩ yɩrɩ Banabaasɩ. (Banabaasɩ memii rɛ yaa nal hʋ aa basɩ wɩya kɩ polli nala tenni). Ʋ fa yaa Levi doho nal lɛ, a lɩɩ Saapʋrɔsɩ paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ʋ fa kaŋ baga kɩdɩgɩ rɛ. Nyɛ rɛ ʋ kpa yallɩ, a kaŋ molbiye hʋ mʋ Yesu kpambɩsɩ hʋ sɩya. ");
INSERT INTO sig_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amɛ ba tɩyaŋ baal kɩdɩgɩ mɛ rɛ gyɩ we doŋ ba kɩ yɩrɩ Ananiyasɩ. Ʋ haaŋ mɛ feŋ nɛ yaa Safiira. Nyɛ rɛ ʋ bee ʋ haaŋ hʋ sii kpa ba sɩfɩyaŋ kɩna badɔmɔŋ yallɩ. Ʋ bee ʋ haaŋ hʋ buloŋ yaa nyʋʋdɩgɩ, ");
INSERT INTO sig_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","a lɩɩ molbiye hʋ badɔmɔŋ faŋa, ka Ananiyasɩ sii kaŋ molbikaalɩya hʋ mʋ Yesu kpambɩsɩ hʋ lee. ");
INSERT INTO sig_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nyɛ rɛ Piita pɩyɛsɩ ʋ a baa, “Ananiyasɩ, bee rɛ tɩŋ ɩ leŋ Sɩtaanɩ mʋrɩ ɩ, ɩ lɩɩ kɩna hʋ ɩ aa yalla molbiye badɔmɔŋ faŋa, aŋ nyɩya wɩya Wɩɩsɩ Wiyesi Welii hʋ sɩya tɩyaŋ nyɛ? ");
INSERT INTO sig_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na kɩna hʋ yaa ɩ kɩna rɛ ka ɩ na kpa yallɩ? Ɩ bɩl aa yalla mɛ, molbiye hʋ yaa ɩ molbiye rɛ. Ɛɛ rɛ ɩ yaŋ liisi ɩ tɩya tɩyaŋ, aŋ yaa wɩɩ no nyɛ? Nihuwobisi sɩya tɩyaŋ daa ɩ nyɩya wɩya no, amɛ Wɩɩsɩ sɩya tɩyaŋ nɛ ɩ nyɩya wɩya no gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyasɩ aa nɩɩ wɩɩ no, ʋ lɩɩ tele doŋ nɛ, a sʋba haŋ lagɩlagɩbiye hʋ. Nyɛ rɛ kambɩŋ gyɩ gyʋʋ nala hʋ buloŋ aa nɩɩ wɩɩ no. ");
INSERT INTO sig_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nyɛ rɛ bapʋwasɩya ko gyʋʋ, a we ʋ liŋe, a kpa ʋ lɩɩ mʋ hogo. ");
INSERT INTO sig_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mʋhʋ sʋwaa, dɩ ʋ haaŋ hʋ mɛ ko gyʋʋ. Ʋ kɛ fa bɩ gyɩŋ wɩɩ hʋ aa yaa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nyɛ rɛ Piita pɩyɛsɩ ʋ a baa, “Ɩ bala kaŋ molbiye badɔmɔŋ ko daha rɛ. Ma aa yallɩ kɩna hʋ, molbii hʋ nyʋwa rɛ ʋ kaŋ ko gɛɛ?” Ɛɛ rɛ haaŋ hʋ baa dɩ molbii hʋ nyʋwa rɛ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɛɛ rɛ Piita bɩl pɩyɛsɩ ʋ a baa, “Bee rɛ tɩŋ ɩ bee ɩ bala buloŋ vʋʋlɩ dɩ ma nyɩya wɩya Wɩɩsɩ Wiyesi Welii hʋ sɩya tɩyaŋ nyɛ, aŋ liisi anɩɩ ʋ bɩ sɩ dɔgɩsɩ ma? Deŋ na, nala hʋ aa kpaa ɩ bala mʋ hogo, ba aa rɛ ha sɩŋ dimbee hʋ nyʋwa tɩyaŋ gɛɛ. Ba yaŋ sɩ kpa ɩ mɛ mʋ.” ");
INSERT INTO sig_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɛɛ rɛ ʋ mɛ pirigi lɩɩ tele ʋ sɩya tɩyaŋ doŋ, a sʋba. Bapʋwasɩya hʋ aa kpaa ʋ bala mʋ hogo ko kɩ gyʋʋ dɩ ʋ mɛ sʋba. Ɛɛ rɛ ba kpa ʋ mɛ a kaŋ lɩɩ hogo kpala ʋ bala hʋ. ");
INSERT INTO sig_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nala hʋ buloŋ aa laa Yesu wɩya di, aŋ aa ko kɩ laŋŋɩ, abee nala hʋ buloŋ mɛ gyɩ aa nɩɩ wɩɩ no, kambɩŋ gyɩ gyʋʋ ba rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu kpambɩsɩ hʋ gyɩ yaa wɩmagɩla abee wɩkperiye rɛ yʋga nala tɩyaŋ. Nala hʋ buloŋ aa laa Yesu wɩya di, ba buloŋ nɛ gyɩ aa kɩ laŋŋɩ dɔmɔŋ abee nyʋʋdɩgɩ. Wɩɩkyʋwaldɩɩbal hʋ gyambarɩŋ ba aa yɩrɩ Solomɔn Gyambarɩŋ, ʋ tɩyaŋ nɛ ba gyɩ aa kɩ laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nala hʋ buloŋ gyɩ aa bɩ laa Yesu wɩya di, ba kɩdɩgɩ buloŋ gyɩ bɩ kaŋ nyuduwo ʋ aa sɩ wuwo gyʋʋ pɛ ba tɩyaŋ. Abee gɛɛ buloŋ, ka nala ha gyɩ aa kɩ bigisi ba rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amɛ kyɛɛ bee ʋ nyʋwa buloŋ, nala aa laa Yesu wɩya di rɛ, baala abee haana buloŋ, a ko kɩ pɛ nɩbɩnɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Akuu wɩya no buloŋ Yesu kpambɩsɩ hʋ aa yaa wɩya, nala aa paa ba wɩɩla tɩmma bee ba kɩpɩnɩya rɛ, a ko lɩɩ biŋ ŋmaŋsɩ nyʋʋsɩ tɩyaŋ. Ba aa yaa gɛɛ rɛ dɩ Piita rɛ ko kɩ baŋ, dɩ ʋ daaliiŋ gyʋʋ ba tɩyaŋ. Beewɩya dɩ Piita daaliiŋ mɛ gba ko gyʋʋ ba tɩyaŋ, ba aa na laaŋfɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nɩgyamaa mɛ gyɩ lɩɩ tɔnɩ hʋ aa kpaga Gyerusalɛm nɛ, aa kaŋ wɩɩla tɩmma abee nala hʋ gyɩŋbɔmɔ aa kana, a kaŋ ko ba lee ba buloŋ na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ abee ʋ hatɩnna hʋ aa we Sadusiima paati hʋ tɩyaŋ, ba sii kpa baaŋ abee tɩhɔllɩ kyeŋ Yesu kpambɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɛɛ tɩyaŋ nɛ ba kasɩ Yesu kpambɩsɩ hʋ a mʋ tɔ dɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amɛ haŋ kyɛɛ hʋ tɩɩ tebine rɛ malɩka kɩdɩgɩ ko kaŋ nɩtɔdɩya hʋ dimbee suri, aŋ leŋ ba lɩɩ. Ka ʋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ma mʋ gyʋʋ sɩŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, a basɩ wɩɩkyʋwal-ŋmaŋfalɩɩ no wɩya a tɩya nala.” ");
INSERT INTO sig_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɛɛ rɛ Yesu kpambɩsɩ hʋ tɩŋa ʋ nyʋwa hʋ. Ʋ sɩgballɩnyʋwa, ba sii mʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ a piili kɩ daga nala. Nyɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ abee ʋ hatɩnna sii yɩrɩ Gyuuma nɩhɩyasɩ abee nala hʋ buloŋ dɩ ba ko laŋŋɩ vʋʋlɩ. Ka ba tɩma dɩ ba mʋ lɩɩ Yesu kpambɩsɩ hʋ nɩtɔdɩya hʋ tɩyaŋ a kaŋ ba ko. ");
INSERT INTO sig_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Laalyuwolo hʋ aa mʋwa ba bɩ naa Yesu kpambɩsɩ hʋ nɩtɔdɩya hʋ tɩyaŋ. Nyɛ rɛ ba mɩɩgɩ ko ba nɩhɩyasɩ hʋ lee a baa, ");
INSERT INTO sig_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Á aa mʋʋ nɩtɔdɩya hʋ, nal buloŋ bɩ suro boro hʋ, ka nala hʋ aa pɔ nɩtɔdɩya hʋ mɛ sɩŋ boro hʋ nyʋwa. Amɛ á aa mʋʋ suri, á bɩ naa Yesu kpambɩsɩ hʋ.” ");
INSERT INTO sig_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nala hʋ aa pɔ Wɩɩkyʋwaldɩɩbal hʋ nɩhɩyawʋ abee Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ aa nɩɩ wɩɩ no, ʋ yaa wɩkperii rɛ kɩŋkaŋ a tɩya ba. Ba bɩ gyɩŋ wɩɩ hʋ aa puu ba. ");
INSERT INTO sig_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Doŋ tɩyaŋ nɛ, dɩ baal kɩdɩgɩ rɛ ko gyʋʋ gɛɛ, a basɩ tɩya ba anɩɩ ba naa nala hʋ ba aa kasa tɔ dɩya hʋ tɩyaŋ nɛ, dɩ ba ko lɩɩ sɩŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ a kɩ daga nala. ");
INSERT INTO sig_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ɛɛ rɛ Wɩɩkyʋwaldɩɩbal laalyuwolo nɩhɩyawʋ hʋ abee ʋ noŋ nala sii lɩɩ a mʋ kasɩ ba a mɩɩgɩ kaŋ ko. Amɛ ba gyɩ bɩ kpaa dee a kasɩ ba, beewɩya kambɩŋ fa kaŋ ba rɛ anɩɩ nala hʋ aa we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ sɩ paa bʋwa yaga ba. ");
INSERT INTO sig_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ba aa kaŋ ba ko gyʋʋ, nyɛ rɛ ba leŋ ba sɩŋ nala hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ sɩya tɩyaŋ. Nyɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Á basɩ tɩya ma rɛ daha abee sɩfɩyasɩ anɩɩ ma ta bɩl ko maakyiye basɩ Yesu wɩya tɩya nal buloŋ, koo a yɩrɩ ʋ feŋ mɛ gba. Amɛ ma deŋ na, ma vɩya aŋ kaŋ wɩɩ hʋ gɔllɩ gyaasɩ Gyerusalɛm buloŋ nɛ, a kɩ kyɛ dɩ ma kpa baal no sʋʋ wɩya kyʋgɩ ma.” ");
INSERT INTO sig_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ɛɛ rɛ Piita abee Yesu kpambɩsɩ hʋ nɩkaalɩya mɩɩgɩ basɩ tɩya ba a baa, “Ʋ maga dɩ á tɩŋ Wɩɩsɩ nyʋwa rɛ, aŋ vɩya nihuwobiŋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Á naabaala Wɩɩsɩ hʋ rɛ kyisi Yesu sʋʋ tɩyaŋ. Nal hʋ ma aa kaŋ kpaasɩ mal daagarɩɩ hʋ nyuu tɩyaŋ ʋ sʋba hʋ. ");
INSERT INTO sig_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wɩɩsɩ kyisi ʋ rɛ, ʋ sii gyɩŋ hɔŋ ʋ noduu logiŋ, dɩ ʋ yaa sɩlaal abee laataal, a tɩya Iziral tɩmma ŋmanɩɩ dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ yayɩ tɩyaŋ, ka dɩ Wɩɩsɩ kpa ba wɩbɔmɔ kyɛ ba. ");
INSERT INTO sig_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wɩya no buloŋ á aa basɩ nyɛ, á bee Wɩɩsɩ Wiyesi Welii hʋ ʋ aa kpaa we nala hʋ aa tɩŋa ʋ nyʋwa, buloŋ yaa ba daŋsɩya rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nala no aa nɩɩ wɩɩ no, nyɛ rɛ ba na baaŋ kɩŋkaŋ aŋ kɩ kyɛ dɩ ba kpʋ ba. ");
INSERT INTO sig_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amɛ ba kɩdɩgɩ rɛ gyɩ we doŋ, a lɩɩ Farasiima paati hʋ tɩyaŋ, ba kɩ yɩrɩ Gamaliyɛl. Ʋ fa yaa Wɩɩsɩ teŋ dɩdagɩl lɛ, nala fa kɩ tɩya gyɩrɩma weliŋ. Nyɛ rɛ ʋ sii sɩŋ aŋ baa, “Ma leŋ dɩ Yesu kpambɩsɩ hʋ lɩɩ lɩgyalɩɩ mʋhʋ.” ");
INSERT INTO sig_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɛɛ rɛ ʋ yaŋ basɩ tɩya ba a baa, “Mamaa Iziral tɩmma, ma fɩyɛlɩ ma sɩya abee wɩya hʋ ma aa kyɛ dɩ ma yaa nala no. ");
INSERT INTO sig_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Saŋa hʋ, baal kɩdɩgɩ rɛ gyɩ we doŋ, ba kɩ yɩrɩ Tiyodasɩ. Ʋ gyɩ kpaa ʋ tɩɩ anɩɩ ʋ yaa nɩbal lɛ. Nala gyɩ pele kɔɔsɩbanaa, a kɩ tɩŋa ʋ hal. Amɛ ba gyɩ aa ko kpʋ ʋ, ʋ hatɩnna hʋ buloŋ gyɩ fáá pɩsa rɛ. Doŋ tɩyaŋ nɛ ʋ ŋmanɩɩ hʋ sɩŋ dɩsɩ, ka ʋ feŋ mɛ nyʋgɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ɛɛ hal tɩyaŋ nɛ, baal kɩdɩgɩ mɛ bɩl lɩɩ, saŋa hʋ tɩyaŋ dɩ ba gyɩ aa dɩɩsɩ á paalʋʋ nala rɛ. Ʋ mɛ feŋ nɛ gyɩ yaa Gyudasɩ, a lɩɩ Galili paalʋʋ. Ʋ mɛ gyɩ kasɩ nala yʋga rɛ ba kɩ tɩŋa ʋ hal. Ba gyɩ aa ko kpʋ ʋ mɛ, haŋ nɩgyamaa hʋ mɛ buloŋ fa aa tɩŋa ʋ hal fáá pɩsa rɛ. ");
INSERT INTO sig_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ɛɛwɩya, wɩɩ no tɩyaŋ, ŋ kɛ aa naa wɩɩ rɛ nyɛ, ma ta yaa nala no wɩɩ buloŋ. Ma kɛ kpa ba ta. Dɩ ba wɩyaalɩya no ko lɩɩ nihuwobiŋ dee tɩyaŋ, tʋma hʋ sɩ nyʋgɩsɩ ba tɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amɛ, dɩ ʋ ko yaa Wɩɩsɩ tʋma, ma bɩ sɩ wuwo kaŋ tʋma no kyogi. Dɩ mamaa rɛ paalɩ kɩ kyɛ ma kyogi ba mɛ, ma sɩ na anɩɩ ma bee Wɩɩsɩ sɩ mɩɩgɩ kaŋ wɩɩ.” ");
INSERT INTO sig_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɛɛ rɛ ba gyegili nɩɩ baal hʋ nyʋwa hʋ. Doŋ nɛ ba yɩrɩ Yesu kpambɩsɩ hʋ ba ko gyʋʋ, ba leŋ ba vɩɩrɩ ba, aŋ basɩ tɩya ba anɩɩ ba ta bɩl ko basɩ wɩya Yesu feŋ tɩyaŋ, aŋ kpa ba ta. ");
INSERT INTO sig_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nyɛ rɛ Yesu kpambɩsɩ hʋ kpa lɩɩ nala hʋ tɩyaŋ, ka ba tenni buloŋ gyɩ fɩyɛlɩ akuu ba aa dɔgɩsɩ ba Yesu wɩya nyuniŋ. Beewɩya ba kɛ lee, ʋ yaa nyusʋŋ nɛ anɩɩ Wɩɩsɩ aa naa dɩ ba mɛ maga dɩ ba di tʋwara Yesu wɩya. ");
INSERT INTO sig_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kyɛɛ buloŋ ba aa mʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ, abee nala dɩɩsɩ, a kɩ basɩ Wɩɩsɩ wɩya aŋ kɩ daga nala Wɩɩsɩ wɩweliye hʋ a mʋ kɩ tile á tɩɩna Yesu Krisita tɩyaŋ, nal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta. ");
INSERT INTO sig_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Saŋa no tɩyaŋ dɩ nala hʋ aa laa Yesu wɩya di gyɩ marɩ wala kɩ pɛ rɛ. Nyɛ rɛ ba tɩyaŋ Gyuuma hʋ aa basɩ Giriki taal abee Gyuuma hʋ aa basɩ Hiiburu taal piili kɩ kaa dɔmɔŋ. Beewɩya Gyuuma hʋ aa basɩ Giriki taal gyɩ baa dɩ Hiiburu tɩmma hʋ aa vɩya ba lohaana kɩ ta rɛ ba kɩna kpayɩ tɩyaŋ kyɛɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nyɛ rɛ Yesu Kpambɩsɩ hʋ fi abee balɩya yɩrɩ nala hʋ buloŋ aa laa Yesu wɩya di a ko laŋŋɩ, a basɩ tɩya ba a baa, “Ʋ bɩ maga dɩ á kɩ deŋ molbiye koo kɩdiiliye wɩkanɩya, aŋ yeŋŋi Wɩɩsɩ wɩya basɩɩ ta. ");
INSERT INTO sig_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ɛɛwɩya, ŋ naabalɩya, ma lɩɩ nala bapɛ ma tɩyaŋ. Ma lɩɩ nala hʋ aa kaŋ wɩgyʋŋ, nala kɩ tɩya ba gyɩrɩma, ka Wɩɩsɩ Wiyesi Welii hʋ mɛ we ba tɩyaŋ. Ma lɩɩ ba, dɩ á kpa á molbiye wɩkanɩya we ba nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ka dɩ á mɛ kpa á nyuu buloŋ we Wɩɩsɩ kyʋwalɩɩ abee Wɩɩsɩ wɩya basɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɛɛ rɛ nala hʋ buloŋ aa we doŋ tenni fɩyɛlɩ abee wɩya hʋ Yesu kpambɩsɩ hʋ aa basa. Nyɛ rɛ ba lɩɩ baal kɩdɩgɩ ba aa yɩrɩ Sɩtɩɩvɩŋ. Ʋ fa yaa nal hʋ aa laa Wɩɩsɩ di rɛ weliŋ, ka Wiyesi Welii hʋ mɛ we ʋ tɩyaŋ. Nyɛ rɛ ba bɩl lɩɩ Fɩlɩpɩ abee Purokurɔsi abee Nikaano abee Tiimɔŋ abee Paamina, a bɩl bee Nikolasɩ aa lɩɩ Aŋtiyɔki. Nikolasɩ fa bɩ yaa Gyuu, aŋ ta kɩ tɩŋ Gyuuma wɩɩkyʋwal ŋmaŋsɩ abee ba lesiri. ");
INSERT INTO sig_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɛɛ rɛ ba kaŋ nala no bapɛ ba aa lɩya a mʋ Yesu kpambɩsɩ hʋ sɩya. Ba kpa ba nosi dɔbɔ ba nyuni tɩyaŋ, aŋ kyʋwalɩ Wɩɩsɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nyɛ rɛ ka Wɩɩsɩ wɩbii hʋ marɩ pɩsa mʋ lee buloŋ. Nala hʋ aa laa Yesu wɩya di marɩ yʋga kɩ pɛ weliŋ Gyerusalɛm tɩyaŋ. Gyuuma wɩɩkyʋwal sɩlaala mɛ gyɩ yʋga rɛ weliŋ, a ko laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wɩɩsɩ noŋ gyɩ dɔbɔ Sɩtɩɩvɩŋ tɩyaŋ nɛ, ʋ dee mɛ we ʋ tɩyaŋ yʋga, ʋ wuwo kɩ yaa wɩkperiye abee wɩmagɩla nala tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nala badɔmɔŋ mɛ fa we doŋ, a fa yaa Gyuuma, aŋ lɩɩ Sariini, ka badɔmɔŋ mɛ lɩɩ Alizaŋdiriya. Ba fa yaa wɩɩkyʋwaldɩya hʋ ba aa yɩrɩ “Yosi ba aa kpaa ta wɩɩkyʋwaldɩya” nala rɛ. Ka badɔmɔŋ mɛ fa yaa Gyuuma, a mɛ lɩɩ Silisɩya abee Esɩya. Nala no buloŋ fa bɩ sɩŋ Sɩtɩɩvɩŋ kɩŋ tɩyaŋ. Ɛɛ rɛ ba beel-ʋ kaŋ nyʋʋtaaduwo abee wɩya hʋ ʋ aa basɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amɛ ba fa bɩ wuwo basɩ wɩya lo ʋ wɩɩ buloŋ tɩyaŋ, beewɩya Wɩɩsɩ Wiyesi Welii hʋ fa we ʋ lee rɛ, ka ʋ kaŋ wɩgyʋŋ mɛ ʋ wɩbasɩɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nyɛ rɛ ba lʋwɔlɩ we nala badɔmɔŋ nyuu dɩ ba basɩ baa ba nɩɩ Sɩtɩɩvɩŋ basɩ wɩya kɩ kyogi Moosi abee Wɩɩsɩ feŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nala no aa basɩ wɩya no, ɛɛ rɛ bee hʋ nala abee ba nɩhɩyasɩ abee Wɩɩsɩ Teŋ dɩdagɩla hʋ buloŋ baaŋ sii Sɩtɩɩvɩŋ nyuu tɩyaŋ kɩŋkaŋ. Nyɛ rɛ ba kana ʋ mʋ hɩyarɩ sɩya. ");
INSERT INTO sig_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aŋ kaŋ nala mɛ ko dɩ ba ko nyɩya wɩya tɩya ʋ. Ɛɛ rɛ nala nyɩya wɩya tɩya ʋ a baa, “Saŋa buloŋ, baal no aa basɩ wɩya rɛ a kɩ kyogi Wɩɩkyʋwaldɩɩwelii hʋ á aa saa, abee Wɩɩsɩ mɩrɩsɩ hʋ buloŋ ʋ aa leŋ Moosi sabɩ biŋ dɩ á kɩ tɩŋa. ");
INSERT INTO sig_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Á nɩya dɩ ʋ baa Yesu no aa lɩɩ Nazarɛti sɩ yige Wɩɩsɩ dɩya no lo, aŋ kaŋ wɩya hʋ Moosi fa aa daga a naabaala dɩ ba kɩ tɩŋa hʋ mɛ a bɩrɩmɩ kyige.” ");
INSERT INTO sig_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nala hʋ buloŋ fa aa hɔŋ doŋ kuwoni ba sɩya pɔ Sɩtɩɩvɩŋ tɩyaŋ. Doŋ tɩyaŋ nɛ ba na dɩ ʋ sɩya kɩɩ gɛɛ anɩɩ malɩka sɩya. ");
INSERT INTO sig_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nyɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ pɩyɛsɩ Sɩtɩɩvɩŋ a baa, “Wɩya no ba aa basa, ba yaa wɩtɩɩ rɛ koo ba nyɩya tɩya ɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ɛɛ rɛ Sɩtɩɩvɩŋ baa, “Ŋ kuwoma abee ŋ naabalɩya, ma gyegili nɩɩ daha. Wɩɩbal hʋ, feŋbal hʋ tɩɩna gyɩ kaŋ ʋ tɩɩ ko daga á naabaa Abɩraham nɛ dɩ ʋ ha gyɩ hɔŋ Mesopotemiya taŋha tɩyaŋ. Haŋ saŋa hʋ dɩ ʋ ha gyɩ bɩ mʋʋ Haraŋ paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ɛɛ rɛ Wɩɩsɩ basɩ tɩya ʋ dɩ ʋ sii leŋ ʋ dɩya nala buloŋ, aŋ lɩɩ ʋ paalʋʋ mɛ tɩyaŋ, a mʋ paalʋʋ hʋ ʋ aa sɩ daga ʋ. ");
INSERT INTO sig_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nyɛ rɛ ʋ sii lɩɩ Kaldɩya paalʋʋ tɩyaŋ, a mʋ hɔŋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Haraŋ tɩyaŋ. Doŋ tɩyaŋ nɛ ʋ kuwo sʋba. Ɛɛ rɛ Wɩɩsɩ bɩl leŋ ʋ sii doŋ, a ko hɔŋ paalʋʋ no tɩyaŋ ma aa hɔnɔ gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Saŋa hʋ tɩyaŋ, Wɩɩsɩ fa bɩ keri taŋha hʋ mʋhʋ mɛ a tɩya Abɩraham a pel naaŋsɩɩnyʋwa kɩdɩgɩ mɛ, dɩ ʋ tɩɩ kana. Amɛ ʋ gyɩ wee nyʋwa tɩya ʋ rɛ anɩɩ ʋ sɩ kpa paalʋʋ no tɩya ʋ bee ʋ doho nala. Saŋa hʋ tɩyaŋ Wɩɩsɩ aa basɩ gɛɛ dɩ Abɩraham ha bɩ lʋla. ");
INSERT INTO sig_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nyɛ rɛ Wɩɩsɩ basɩ tɩya ʋ, ‘Ɩ doho nala sɩ yaa nɩhʋwala paalʋʋ kɩdɩgɩ tɩyaŋ a yaa yosi. Ba sɩ dɔgɩsɩ ba kɩŋkaŋ bɩsɩ kɔɔsɩbanaa. ");
INSERT INTO sig_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amɛ ŋ sɩ dɔgɩsɩ haŋ paalʋʋ hʋ nala aa kaŋ ba bɩrɩmɩ yosi ba tʋma kɩ tɩya ba hʋ. Ɛɛ hal tɩyaŋ, ba sɩ lɩɩ doŋ tɩyaŋ, a bɩl ko daha, a kɩ kyʋwalɩ mɩyaŋ Wɩɩsɩ.’ ");
INSERT INTO sig_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ɛɛ rɛ Wɩɩsɩ kpa ʋ nyʋwa tɩya Abɩraham. Ʋ nyʋwa hʋ magɩl lɛ yaa Abɩraham bee ʋ doho nala aa keri ba pene. Nyɛ rɛ Abɩraham lʋl Azɩkɩ. Ʋ kyɛyɛ kyori kyɛɛ, Abɩraham keri ʋ peŋ. Azɩkɩ mɛ sii lʋl Gyeekɔbɩ. Gyeekɔbɩ mɛ lʋl biisi fi abee balɩya. Ba aa rɛ ko yaa á naabaala. ");
INSERT INTO sig_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ba tɩyaŋ kɩdɩgɩ feŋ nɛ fa yaa Gyosɛfʋ. Nyɛ rɛ nɩkaalɩya hʋ gyɩ haasɩ ʋ, ba tɩsɩ kɩ hɔllɩ ʋ. Ba kuu gɛɛ wɩya a kana ʋ mʋ yallɩ tɩya baala badɔmɔŋ. Ba mɛ kana ʋ mʋ Igyipiti, a mʋ yallɩ tɩya baal kɩdɩgɩ, ʋ yaa yoŋ. Amɛ Wɩɩsɩ ha gyɩ aa pɛ ʋ tɩyaŋ nɛ weliŋ, ");
INSERT INTO sig_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a lɩɩ ʋ tʋwara buloŋ tɩyaŋ ʋ gyɩ aa gyʋwa. Ʋ fa aa mʋʋ Igyipiti Kuwori Faaro sɩya, Wɩɩsɩ dee tɩyaŋ, ʋ wuwo kaŋ wɩgyʋŋ nɛ abee gyogiweliye. Ɛɛ rɛ Kuwori Faaro lɩɩ ʋ, ʋ yaa ʋ paalʋʋ nɩhɩyawʋ, a kɩ deŋ ʋ paalʋʋ abee ʋ dɩya buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɛɛ rɛ losiŋbɔŋ kɩdɩgɩ gyɩ ko gyʋʋ Igyipiti paalʋʋ abee Keenaŋ paalʋʋ buloŋ, nala kɩ na sikii kɩŋkaŋ, á naabaala hʋ gyɩ kyɛ kɩdiilii buloŋ lɔlɔ dɩ ba di. ");
INSERT INTO sig_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Doŋ tɩyaŋ nɛ Gyeekɔbɩ nɩɩ anɩɩ kɩdiiliye we Igyipiti paalʋʋ tɩyaŋ nɛ. Ʋ tɩma ʋ balɩya dɩ ba mʋ yɔbɔ ko. Ɛɛ rɛ ba mʋ yɔbɔ ko. ");
INSERT INTO sig_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nyɛ rɛ Gyeekɔbɩ balɩya hʋ bɩl mɩɩgɩ mʋ Igyipiti lɩya tɩɩna dɩ ba yɔbɔ kɩdiiliye. Doŋ tɩyaŋ nɛ Gyosɛfʋ kaŋ ʋ tɩɩ dagɩ ba, aŋ kaŋ ba mʋ daga Kuwori Faaro mɛ. Ɛɛ tɩyaŋ nɛ Kuwori Faaro yaŋ gyɩŋ Gyosɛfʋ doho aa lɩɩ lee hʋ. ");
INSERT INTO sig_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ɛɛ rɛ ka Gyosɛfʋ tɩma dɩ ba mʋ basɩ tɩya ʋ kuwo Gyeekɔbɩ, dɩ ʋ kaŋ ʋ dɩya nala buloŋ ko Igyipiti paalʋʋ. Gyeekɔbɩ dɩya nala hʋ ʋ aa paa mʋ Igyipiti paalʋʋ, ba buloŋ gyɩ yaa nala mɔllɩboto rɛ abee fi abee bɔnɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Doŋ tɩyaŋ nɛ ʋ bee ʋ balɩya buloŋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba mɩɩgɩ kaŋ ba mʋ Keenaŋ paalʋʋ, a hogi ba Sɛkɛm tɩyaŋ. Bʋbʋʋbal kɩdɩgɩ rɛ Abɩraham fa yɔbɔ Hamɔ nala lee. Doŋ tɩyaŋ nɛ ba hogi ba. ");
INSERT INTO sig_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Wɩɩsɩ gyɩ wee nyʋwa rɛ dɩ ʋ sɩ yaa wɩɩ kɩdɩgɩ tɩya Abɩraham. Ʋ gyɩ ko ka mʋhʋ rɛ ka dɩ Wɩɩsɩ yaa wɩɩ no. Haŋ saŋa hʋ dɩ Gyeekɔbɩ doho nala mɛ fa wala yʋga rɛ weliŋ Igyipiti paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ɛɛ rɛ kuwori hʋ fa aa gyɩŋ Gyosɛfʋ Igyipiti tɩyaŋ ko sʋba aŋka nɩdɩma mɩɩgɩ di Igyipiti paalʋʋ koro. Ʋ kɛ fa bɩ gyɩŋ Gyosɛfʋ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nyɛ rɛ ʋ kɩ mʋrɩ á naabaala hʋ, a kɩ dɔgɩsɩ ba kɩŋkaŋ, aŋ fɩla ba dɩ ba paa ba biifɩllɩ lɩɩ ta dɩ ba sʋba. ");
INSERT INTO sig_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Haŋ saŋa hʋ tɩyaŋ nɛ ba gyɩ lʋl Moosi. Ʋ fa yaa biiwelii nyɛ rɛ. Ɛɛ wɩya, ba kpa ʋ faŋa ʋ kuwo dɩya tɩyaŋ peŋsi boto, aŋ na kpa ʋ lɩɩ ta. ");
INSERT INTO sig_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba aa kpa ʋ lɩɩ ta gɛɛ, Kuwori Faaro tɩɩ toluu ko kpa ʋ a dɩyɛsɩ ʋ anɩɩ ʋ biilʋlɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba daga ʋ Igyipiti tɩmma wɩgyʋŋ buloŋ. Ʋ wɩyaalɩya abee ʋ wɩbasɩya buloŋ gyɩ daga anɩɩ ʋ yaa nɩbal lɛ. ");
INSERT INTO sig_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moosi gyɩ aa ko pele bɩsɩ mɔllɩbalɩya, ʋ na anɩɩ ʋ maga dɩ ʋ mʋ na ɛɛ hʋ ʋ nala Iziral tɩmma hɔnɩɩ aa kɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ʋ gyɩ aa mʋʋ dɩ ʋ naa Igyipiti tɩmma hʋ kɩdɩgɩ dɩ ʋ aa dɔgɩsɩ Iziral tɩmma hʋ kɩdɩgɩ. Ɛɛ rɛ ʋ mʋ laa pɛ Iziral tɩɩna hʋ tɩyaŋ, a ŋmaa Igyipiti tɩɩna hʋ kpa lo ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ʋ fa liise anɩɩ ʋ nala hʋ sɩ gyɩma anɩɩ Wɩɩsɩ aa kyɛ dɩ ʋ rɛ laa ba ta, amɛ ba bɩ wuwo gyɩma. ");
INSERT INTO sig_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ʋ sɩgballɩya, ʋ bɩl mʋwa dɩ Iziral tɩmma balɩya aa kaa dɔmɔŋ. Ʋ mʋ dɩ ʋ laa ba ta, aŋ marɩ ba dɔmɔŋ. Nyɛ rɛ ʋ basɩ tɩya ba a baa, ‘Ma yaa nɩmmabalɩya rɛ, bee rɛ tɩŋ ma mɩɩgɩ gul kɩ kaa dɔmɔŋ?’ ");
INSERT INTO sig_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ɛɛ rɛ nal hʋ fa aa di dee ʋ dɔŋtɩɩna hʋ nyuu tɩyaŋ kaŋ Moosi yige ta aŋ pɩyɛsɩ ʋ a baa, ‘Aŋnɛ rɛ lɩɩ ɩ dɩ ɩ kɩ deŋ á nyuu, a laa á wɩya kɩ basɩ? ");
INSERT INTO sig_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Koo ɩ aa kyɛ ɩ kpʋ ŋ mɛ rɛ anɩɩ ɩ dɩya aa kpʋʋ Igyipiti tɩɩna hʋ gɛɛ rɛ?’ ");
INSERT INTO sig_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moosi aa nɩɩ gɛɛ, ʋ lɩɩ fá Igyipiti paalʋʋ tɩyaŋ, a mʋ yaa nɩhʋwal Mɩdɩya paalʋʋ tɩyaŋ. Doŋ tɩyaŋ nɛ ʋ hɔŋ a kpa haaŋ, a lʋl boyoŋbiisi balɩya. ");
INSERT INTO sig_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ʋ fa hɔŋ doŋ bɩsɩ mɔllɩbalɩya rɛ. Ɛɛ rɛ kyɛɛ kɩdɩgɩ, malɩka kɩdɩgɩ ko ʋ lee ɔhɔ tʋtʋʋ tɩyaŋ, a kpaga dogimo kɩdɩgɩ ba aa yɩrɩ Saana. Ʋ ko lɩɩ a kɩɩ gɛɛ anɩɩ tɩɩbiye rɛ aa di diŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moosi aa naa gɛɛ, ʋ yaa ʋ wɩkperii. Ɛɛ rɛ ʋ mʋ pele dɩ ʋ marɩ na tɩɩbiye hʋ weliŋ. Doŋ tɩyaŋ nɛ ʋ nɩɩ á Tɩɩna Wɩɩsɩ taal, dɩ ʋ basɩ tɩya ʋ a baa, ");
INSERT INTO sig_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɩyaŋ nɛ yaa ɩ naabaala Abɩraham abee Azɩkɩ abee Gyeekɔbɩ Wɩɩsɩ’. Ʋ aa basɩ gɛɛ, Moosi sɩŋ kɩ kyele. Ʋ bɩl bɩ wuwo dɩ ʋ deŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sɩtɩɩvɩŋ bɩl basɩ baa, ‘Ɛɛ rɛ á Tɩɩna Wɩɩsɩ basɩ tɩya Moosi a baa, kuwoni ɩ naatɔbɔ ɩ naasɩ tɩyaŋ. Wɩɩsɩ we lee hʋ tɩyaŋ ɩ aa sɩna tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ŋ naa ɛɛ hʋ ba aa dɔgɩsɩ ŋ nala rɛ Igyipiti paalʋʋ tɩyaŋ, a nɩɩ ba wiile mɛ. Ŋ ko tuu dɩ ŋ laa ba ta rɛ. Sii dɩ ŋ tɩma ɩ dɩ ɩ mɩɩgɩ mʋ Igyipiti.’ ");
INSERT INTO sig_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ɛɛ rɛ Sɩtɩɩvɩŋ bɩl marɩ kpa, a baa, ‘Moosi no rɛ Iziral tɩmma hʋ gyɩ vɩya aŋ pɩyɛsɩ ʋ baa, Aŋnɛ rɛ baa dɩ ɩ kɩ deŋ ma a laa á wɩya kɩ basɩ?’ Ʋ rɛ Wɩɩsɩ yaŋ tɩma dɩ ʋ yaa ba nɩhɩyawʋ abee ba laataal. Wɩɩsɩ rɛ gyɩ tɩŋ ʋ malɩka, ʋ gyɩ ko Moosi lee a gyɩ kɩɩ gɛɛ anɩɩ tɩɩbiye rɛ aa di diŋ, a ko pɛ Moosi tɩyaŋ dɩ ʋ laa ʋ nala ta. ");
INSERT INTO sig_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moosi gyɩ yaa wɩmagɩla abee wɩkperiye rɛ Igyipiti paalʋʋ tɩyaŋ, aŋ na kasɩ ʋ nala hʋ lɩɩ doŋ tɩyaŋ. Ba gyɩ aa mʋʋ pele fuwo kɩdɩgɩ ba aa yɩrɩ Fuwofɩyaŋ, ʋ gyɩ bɩl yaa wɩmagɩla rɛ doŋ. Ba gyɩ vala pogo mɛ dʋŋ tɩyaŋ nɛ bɩsɩ mɔllɩ balɩya, ka Moosi ha kɩ yaa wɩmagɩla abee wɩkperiye ŋmanɩɩ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moosi no tɩɩ rɛ bɩl basɩ tɩya Iziral tɩmma a baa, ‘Wɩɩsɩ sɩ tɩŋ ʋ tɩŋdaal dɩ ʋ ko ma lee anɩɩ ʋ aa tɩma ŋ gɛɛ. Ʋ sɩ yaa ma nɩɩnabiye tɩɩ.’ ");
INSERT INTO sig_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moosi bee á naabaala gyɩ laŋŋa pogo tʋtʋʋ tɩyaŋ nɛ. Doŋ tɩyaŋ nɛ Moosi gyɩ na malɩka dogiŋbal kɩdɩgɩ ba aa yɩrɩ Saana nyuu tɩyaŋ. Ɛɛ rɛ malɩka hʋ kpa Wɩɩsɩ nyʋwa hʋ aa kaŋ mɩɩbol tɩya ʋ dɩ ʋ laa basɩ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ɛɛ rɛ ka á naabaala hʋ gyɩ vɩya ʋ nyʋwa, aŋ kpa ba hal yɩya ʋ, ka ba tɩliise buloŋ fa kɩ tɩya ba anɩɩ ba mɩɩgɩ mʋ Igyipiti paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nyɛ rɛ ba basɩ tɩya Aarɔŋ a baa, ‘Mɔ tɔdʋnnɩ tɩya ma dɩ ba kɩ deŋ ma. Moosi no aa kaŋ ma lɩɩ Igyipiti paalʋʋ ko daha, á bɩ gyɩŋ wɩɩ hʋ buloŋ aa kana ʋ.’ ");
INSERT INTO sig_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ɛɛ rɛ ba sii mɔ vʋgɩ kɩdɩgɩ ʋ kɩɩ gɛɛ anɩɩ nɔbiye. Nyɛ rɛ ba sii marɩ ʋ, ba tenni buloŋ fɩyɛlɩ kɩŋ hʋ ba tɩɩ aa mɔɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nyɛ rɛ tɩŋ Wɩɩsɩ gyɩ kpa ʋ hal yɩya ba, a vɩya ba ta ba kɩ kyʋwalɩ kyɩŋwʋlɩya abee pene abee wɩɩpɔsɩɩ. Ba saba gɛɛ rɛ Wɩɩsɩ Teŋ logiŋ hʋ Wɩɩsɩ tɩŋdaala aa saba tɩyaŋ. Ba kɩdɩgɩ saba rɛ anɩɩ dɩ Wɩɩsɩ baa, ‘Mamaa Iziral tɩmma, bɩsɩ mɔllɩbalɩya hʋ ma fa aa we pogo hʋ tɩyaŋ, ŋ daa ma fa kpa ma kɩna koo ma pʋsɩ kɩ sʋla. ");
INSERT INTO sig_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amɛ ma tɔdʋŋ hʋ ma aa yɩrɩ Mɔlɔkɩ, ʋ rɛ ma marɩ taŋtɩ-dɩya we gɛɛ, abee ma kyɩŋwʋlɩya tɔdʋŋ hʋ ma aa yɩrɩ Rɛfaŋ, ba aa rɛ ma gyɩ kyʋŋ kɩ vala gɛɛ. Ma tɩɩ rɛ mɔɔ ba, a kɩ marɩ ba. Ɛɛwɩya, ŋ sɩ leŋ dɩ ba kasɩ ma mʋ lee aa para Baabilɔŋ.’ ");
INSERT INTO sig_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ɛɛ rɛ Sɩtɩɩvɩŋ bɩl basɩ baa, Á naabaala gyɩ aa we pogo hʋ tɩyaŋ, ba gyɩ marɩ taŋtɩ-dɩya rɛ doŋ a tɩya Wɩɩsɩ. Taŋtɩ-dɩya no rɛ gyɩ daga anɩɩ Wɩɩsɩ kɔnɩ we ba lee rɛ. Wɩɩsɩ tɩɩ rɛ gyɩ daga Moosi ɛɛ ʋ aa sɩ marɩ dɩya no. Ɛɛ hʋ buloŋ Wɩɩsɩ gyɩ aa kyɛ rɛ ʋ daga Moosi, ʋ mɛ leŋ ba marɩ ʋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɛɛ hal tɩyaŋ nɛ á naabaala laa taŋtɩ-dɩya no ba kuwoma lee. Saŋa hʋ Wɩɩsɩ gyɩ aa leŋ ba bee Gyoosʋwa mʋ yuwo paalʋʋ kɩdɩgɩ nala, a kil ba ta aŋ laa ba taŋha hɔŋ hʋ, dɩ ba ha kyʋŋ taŋtɩ-dɩya no rɛ. Taŋtɩ-dɩya no gyɩ we ba lee rɛ, a ko pele á naabaa Deviti saŋa. ");
INSERT INTO sig_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wɩɩsɩ gyɩ sɩŋ pɔ Deviti rɛ weliŋ. Ɛɛ rɛ Deviti gyɩ sʋla Wɩɩsɩ dɩ ʋ pɛ ʋ tɩyaŋ dɩ ʋ wuwo saa dɩya tɩya ʋ Wɩɩsɩ hʋ á naabaa Gyeekɔbɩ fa aa kyʋwalɩ. ");
INSERT INTO sig_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amɛ Deviti gyɩ bɩ wuwo saa dɩya hʋ. Ʋ biibaal Solomɔn nɛ gyɩ mɩɩgɩ ko saa ʋ, a tɩya Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Amɛ Wɩɩsɩ aa tee kɩŋ buloŋ, ʋ bee gyʋʋ dɩɩsɩ hʋ nihuwobiŋ aa saa dʋŋ. Wɩɩsɩ tɩŋdaal kɩdɩgɩ gyɩ basɩ wɩɩ no wɩya rɛ, a baa dɩ ");
INSERT INTO sig_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Wɩɩsɩ baa, ‘Wɩɩsɩbee tɩyaŋ nɛ ŋ kuworikpasa we, taŋha daha rɛ yaa ŋ naasɩ libinii. Dɩɩgɛɛ rɛ ma sɩ wuwo saa tɩya ŋ? Lee rɛ ŋ liwiyesii we? ");
INSERT INTO sig_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ŋ daa marɩ kɩna no buloŋ?’ ");
INSERT INTO sig_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ɛɛ rɛ Sɩtɩɩvɩŋ bɩl basɩ baa, ‘Ma bembiye deye rɛ kɩŋkaŋ! Ma dɩgɩna mɛ bee nɩɩ wɩya. Ma kaŋ nyuduwo rɛ anɩɩ nala hʋ aa bee tɩŋ Wɩɩsɩ. Ɛɛ rɛ tɩŋ ma mɛ aa vɩya ma aa sɩ kɩ tɩŋ Wɩɩsɩ Wiyesi Welii hʋ anɩɩ ma naabaala fa aa yaa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wɩɩsɩ tɩŋdaal buloŋ tuwo dɩ ma naabaala gyɩ bɩ tɩŋ ŋmanɩɩ kɩdɩgɩ a dɔgɩsɩ ʋ. Ba gyɩ kpʋʋ nala hʋ buloŋ aa laa sɩya basɩ Wɩɩsɩ tɩpʋlʋŋ tʋŋtʋnnɩ hʋ koyi wɩya rɛ. Ɛɛ rɛ ʋ ko, ma mɛ kpa ʋ yallɩ tɩya nala, ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wɩɩsɩ leŋ ʋ malɩkasɩ dagɩ ma ʋ mɩrɩsɩ buloŋ nɛ, amɛ ma bɩ tɩŋa ʋ nyʋwa.”’ ");
INSERT INTO sig_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nala hʋ gyɩ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ aa gyegile nɩɩ Sɩtɩɩvɩŋ wɩbasɩɩ hʋ ko mʋ maga nyɛ, dɩ ba buloŋ baaŋ marɩ sii ʋ tɩyaŋ nɛ, ba kɩ kyaŋ ba nyɩŋa lee lee buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ marɩ gyʋʋ Sɩtɩɩvɩŋ yʋga. Ʋ wil deŋ wɩɩsɩnyuu a na Wɩɩbal hʋ gaŋdarɩ, a na Yesu mɛ dɩ ʋ sɩŋ Wɩɩsɩ noduu logiŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ɛɛ rɛ Sɩtɩɩvɩŋ basɩ baa, “Ma deŋ na, ŋ naa wɩɩsɩbee dimbeenyʋwa rɛ dɩ ʋ suro, ka Nihuwobiŋ Biye hʋ sɩŋ Wɩɩsɩ noduu logiŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Doŋ tɩyaŋ nɛ nala hʋ buloŋ kyɩɩrɩ yʋga, aŋ tɔ ba dɩgɩna, ka ba buloŋ teŋ sii giri mʋ kyige ʋ, ");
INSERT INTO sig_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a kana ʋ yige ta ʋ lɩɩ bee hʋ samanɩ. Doŋ tɩyaŋ nɛ ba yaŋ paa bʋwa tɔ kana ʋ, a kɩ yaga lee lee buloŋ. Nala hʋ aa yaga Sɩtɩɩvɩŋ buloŋ gyɩ wuri ba gannɩ rɛ a kpa tɩya bapʋwasɩbiye kɩdɩgɩ ba aa yɩrɩ Sɔɔl dɩ ʋ kɩ deŋ. ");
INSERT INTO sig_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ba aa yaga Sɩtɩɩvɩŋ gɛɛ rɛ, ka ʋ kɩ yɩrɩ á Tɩɩna Yesu a kɩ sʋla ʋ, “Ŋ Tɩɩna Yesu, laa ŋ dʋma mʋ ɩ lee.” ");
INSERT INTO sig_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ɛɛ tɩyaŋ nɛ ʋ tuu gbinni, a kyiyesi yʋga a baa, “Ŋ Tɩɩna Yesu, ŋ aa sʋla ɩ, ta tuŋ wɩbɔŋ no ba aa yaa kyɩŋ ba nyuu tɩyaŋ.” Nyɛ rɛ ʋ basɩ aŋ yaŋ keri ʋ wiyesi kateŋse. Sɔɔl mɛ gyɩ laa rɛ anɩɩ ba kpʋʋ Sɩtɩɩvɩŋ maga rɛ. ");
INSERT INTO sig_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Haŋ kyɛɛ hʋ buloŋ nɛ ba piili kɩ dɔgɩsɩ nala hʋ aa laa Yesu wɩya di aŋ kɩ laŋŋɩ Gyerusalɛm tɩyaŋ, a kaŋ ba kɩ tɩya sikii kɩŋkaŋ. Ɛɛ rɛ ba buloŋ sii pɩsa gyʋʋ Gyudɩya abee Samaarɩya paalʋʋ buloŋ. See Yesu kpambɩsɩ hʋ dʋŋ nɛ gyɩ kaa Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nala badɔmɔŋ aa fá Wɩɩsɩ mɛ rɛ gyɩ kpaa Sɩtɩɩvɩŋ hogo, aŋ wii ʋ loho weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amɛ Sɔɔl gyɩ yaa siri rɛ dɩ ʋ yalmɩ nala hʋ aa laa Yesu wɩya di. Ʋ gyɩ aa sii gɔllɩ ba dɩɩsɩ rɛ, a tarɩ ba baala abee ba haana buloŋ ko lɩɩ, a leŋ ba kasɩ ba mʋ tɔ dɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ka Yesu hatɩnna hʋ mɛ gyɩ aa lɩɩ fá Gyerusalɛm tɩyaŋ hʋ, ba mɛ gɔllɩ mʋ lee buloŋ, a kɩ basɩ Yesu Krisita wɩweliye hʋ. ");
INSERT INTO sig_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nyɛ rɛ Fɩlɩpɩ sii mʋ Samaarɩya paalʋʋ tɔbal kɩdɩgɩ, a basɩ Yesu Krisita, laataal hʋ Wɩɩsɩ aa tɩma wɩya, a kɩ tɩya doŋ nala. ");
INSERT INTO sig_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gyamaa hʋ buloŋ gyɩ wee dɩgɩŋgyegil lɛ a kɩ nɩɩ wɩya hʋ ʋ gyɩ aa basɩ. Ba buloŋ gyɩ gyegile nɩɩ wɩya hʋ ʋ aa basa rɛ, a na wɩmagɩla hʋ buloŋ mɛ ʋ aa yaa. ");
INSERT INTO sig_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fɩlɩpɩ gyɩ aa basɩ wɩya hʋ tɩyaŋ, gyɩŋbɔmɔ yʋga gyɩ lɩɩ nala ba aa kana tɩyaŋ nɛ. Dɩ gyɩŋbɔŋ buloŋ nɛ fa ko kɩ lɩɩ mɛ, ʋ aa kyɩɩrɩ rɛ yʋga aŋ na lɩɩ. Ka gbarɩga abee naasʋʋnɩ abee nosʋʋnɩ tɩmma yʋga mɛ gyɩ na laaŋfɩya, ba tenni leye buloŋ mɩɩgɩ sɩŋ ba bʋʋsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɛɛwɩya, haŋ tɔɔ hʋ tɩmma buloŋ tenni gyɩ fɩyɛla rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Haŋ tɔɔ hʋ tɩyaŋ, baal kɩdɩgɩ mɛ rɛ gyɩ we doŋ, ba kɩ yɩrɩ Siimɔŋ. Ʋ gyɩ kaŋ daaluliye rɛ weliŋ, a kɩ vʋga. Ʋ wɩyaalɩya buloŋ gyɩ yaa Samaarɩya paalʋʋ nala wɩkperii rɛ. Ɛɛ rɛ tɩŋ ʋ mɛ gyɩ aa kɩ daga ʋ tɩɩ anɩɩ ʋ bɩra rɛ. ");
INSERT INTO sig_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nɩhɩyasɩ bee biibiisi buloŋ gyɩ kpa ba nyuu we ʋ wɩyaalɩya tɩyaŋ nɛ a kɩ basɩ a baa, “Baal no rɛ yaa Wɩɩsɩ, ʋ kaŋ dee rɛ yʋga, dee hʋ ba aa yɩrɩ Wɩɩsɩ debal hʋ, ʋ rɛ ʋ kana.” ");
INSERT INTO sig_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ʋ aa yaa wɩkperiye no pɩɩsɩ rɛ, ɛɛ rɛ tɩŋ nala na anɩɩ ʋ bɩra rɛ. Ɛɛ rɛ tɩŋ ba kpa ba nyuni we ʋ wɩyaalɩya tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amɛ Fɩlɩpɩ gyɩ aa basɩ Wɩɩsɩ wɩweliye hʋ wɩya, a kɩ daga Wɩɩsɩ koro hʋ wɩya, a basɩ Yesu Krisita wɩya mɛ, nala hʋ gyɩ laa wɩya hʋ di rɛ, ba fo ba wɩɩkyʋwalnɩɩ, baala abee haana buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Siimɔŋ tɩɩ mɛ gyɩ ko laa Yesu wɩya hʋ di rɛ, ba fo ʋ mɛ wɩɩkyʋwalnɩɩ. Ɛɛ hal tɩyaŋ, ʋ kɩ mal Fɩlɩpɩ kɩŋkaŋ. Ʋ aa naa wɩkperiye hʋ bee wɩmagɩla hʋ Fɩlɩpɩ aa yaa, ʋ yaa ʋ wɩkperii rɛ. ");
INSERT INTO sig_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesu kpambɩsɩ hʋ aa we Gyerusalɛm tɩyaŋ nɩɩ anɩɩ Samaarɩya paalʋʋ nala laa Wɩɩsɩ wɩya di rɛ. Ɛɛ rɛ ba ta Piita bee Gyɔɔŋ dɩ ba mʋ doŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ɛɛ rɛ Piita bee Gyɔɔŋ mʋ kyʋwalɩ Wɩɩsɩ tɩya ba dɩ Wɩɩsɩ leŋ ʋ Wiyesi Welii hʋ ko tuu gyʋʋ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Beewɩya haŋ saŋa hʋ dɩ Wɩɩsɩ Wiyesi Welii hʋ ha gyɩ bɩ gyʋʋ Samaarɩya paalʋʋ nal kɩdɩgɩ buloŋ tɩyaŋ. Á Tɩɩna Yesu Krisita feŋ dʋŋ tɩyaŋ nɛ ba fa fo ba wɩɩkyʋwalnɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nyɛ rɛ Piita bee Gyɔɔŋ kpa ba nosi dɔbɔ ba nyuni tɩyaŋ, a kyʋwalɩ Wɩɩsɩ tɩya ba. Ɛɛ tɩyaŋ nɛ Wɩɩsɩ Wiyesi Welii hʋ ko tuu gyʋʋ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Siimɔŋ aa naa dɩ Yesu kpambɩsɩ hʋ kpa ba nosi dɔbɔ nala hʋ aa laa Yesu wɩya di tɩyaŋ, Wɩɩsɩ Wiyesi Welii hʋ gyʋʋ ba tɩyaŋ gɛɛ, ʋ sii kpa molbii a sʋl ba a baa, ");
INSERT INTO sig_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ma laa aŋ tɩya ŋ ma dee no dɩ ŋ mɛ ko kpa nosi dɔbɔ nal buloŋ tɩyaŋ, dɩ Wɩɩsɩ Wiyesi Welii hʋ gyʋʋ ʋ tɩɩna tɩyaŋ.” Ɛɛ rɛ Piita basɩ tɩya ʋ, a baa, ");
INSERT INTO sig_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","“Ɩ liise ɩ sɩ wuwo kpa molbiye yɔbɔ Wɩɩsɩ aa kpaa kɩŋ hʋ tɩya nala ʋ bɔnyɛ tɩyaŋ nɛ koo? Wɩɩsɩ sɩ leŋ ɩ bee ɩ molbiye no buloŋ gyʋʋ diŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɩ noŋ tuwo á tʋma no tɩyaŋ, beewɩya ɩ bɩ pʋllɩ ɩ tɩya tɩya Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mɩɩgɩ bɩrɩmɩ lɩɩ ɩ wɩbɔmɔ no tɩyaŋ aŋ sʋla Wɩɩsɩ dɩ ʋ kpa ɩ tɩliisibɔmɔ no kyɛ ɩ. ");
INSERT INTO sig_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ŋ naa anɩɩ ɩ tɩya bile rɛ kɩŋkaŋ, ka ɩ bɩl yaa wɩbɔmɔ yoŋ mɛ.” ");
INSERT INTO sig_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ɛɛ rɛ Siimɔŋ sʋla Piita bee Gyɔɔŋ dɩ ba kyʋwalɩ Wɩɩsɩ tɩya ʋ dɩ wɩya no buloŋ ba aa basa ta yaa ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ba aa basɩ Wɩɩsɩ wɩya hʋ ko teŋ, a daga wɩya hʋ buloŋ ba aa gyɩma Yesu lugo tɩyaŋ a tɩya ba, ba sii doŋ nɛ, a mɩɩgɩ mʋ Gyerusalɛm. Saŋa hʋ ba aa mʋ Gyerusalɛm hʋ tɩyaŋ, ba basɩ Yesu Krisita wɩweliye hʋ rɛ Samaarɩya paalʋʋ tɔnɩ yʋga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɛɛ rɛ ka malɩka kɩdɩgɩ ko basɩ tɩya Fɩlɩpɩ a baa, “Sii, a mʋ wɩɩpɔsɩɩ noduu dɩɩlaŋ, a mʋ ŋmaŋbɩnɩɩ hʋ aa lɩɩ Gyerusalɛm kɩ mʋ Gasa.” Nyɛ rɛ Fɩlɩpɩ sii kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ʋ aa mʋ pele ŋmanɩɩ hʋ, dɩ Itoopiya tɩmma baal kɩdɩgɩ rɛ gɛɛ. Ʋ fa yaa bafara rɛ, a tʋma kɩ tɩya Itoopiya Kuwori. Kuwori hʋ fa yaa haaŋ nɛ, ka ʋ kuwori feŋ yaa Kandesi. Baal no fa yaa ʋ tʋŋtʋnna tɩyaŋ nɩbal kɩdɩgɩ rɛ. Ʋ rɛ fa aa deŋ kuwori hʋ molbiye wɩkanɩya abee ʋ dʋwa buloŋ nyuu. Gyerusalɛm nɛ ʋ fa mʋ a kyʋwalɩ Wɩɩsɩ aŋ fa mɩɩgɩ kɩ mʋ bee abee gyaagʋ toriku. ");
INSERT INTO sig_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ʋ fa hɔŋ toriku hʋ tɩyaŋ gɛɛ rɛ, aŋ kɩ karɩmɩ Wɩɩsɩ Teŋ lee kɩdɩgɩ Wɩɩsɩ tɩŋdaal Azaaya aa saba. ");
INSERT INTO sig_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ basɩ tɩya Fɩlɩpɩ dɩ ʋ vala mʋ puu toriku hʋ. ");
INSERT INTO sig_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nyɛ rɛ Fɩlɩpɩ fá mʋ puu ʋ, dɩ ʋ nɩɩ baal hʋ aa karɩmɩ Wɩɩsɩ teŋ logiŋ hʋ Azaaya aa saba. Ɛɛ rɛ ʋ pɩyɛsɩ ʋ dɩ ʋ gyɩŋ wɩya hʋ ʋ aa karɩmɩ hʋ memii rɛ? ");
INSERT INTO sig_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nyɛ rɛ baal hʋ baa, “Ɛɛ rɛ ŋ sɩ yaa gyɩŋ ba memii dɩ nal bɩ daga tɩya ŋ.” Aŋ yɩrɩ Fɩlɩpɩ dɩ ʋ ko gyɩŋ hɔŋ pɛ ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wɩɩsɩ teŋ lee hʋ ʋ fa aa karɩmɩ hʋ, wɩɩ no rɛ ba sabɩ doŋ: “Anɩɩ ba aa kaŋ piyesi kɩ mʋ dɩ ba kpʋ ka ʋ tallɩ ʋ nyʋwa gɛɛ, anɩɩ ba aa kɩ kʋsɩ pebiye pʋna ka ʋ nyʋwa bee suri gɛɛ, ɛɛ tɩɩ rɛ ʋ mɛ bɩ suro ʋ nyʋwa. ");
INSERT INTO sig_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ba gyɩ yalmɩ ʋ rɛ weliŋ, ʋ kɩna gyɩ sʋma mɛ, ka ba vʋʋlɩ vɔmɔ ʋ, a kpa kyogisi tɩya ʋ. Ʋ mɩɩbol yaŋ aa tene taŋha no nyuu nyɛ, aŋnɛ rɛ sɩ wuwo tɩŋ ʋ doho nala naasɩ.” ");
INSERT INTO sig_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Baal hʋ aa karɩma Wɩɩsɩ wɩya hʋ teŋ, ʋ pɩyɛsɩ Fɩlɩpɩ, a baa “Aŋnɛ wɩya rɛ Wɩɩsɩ tɩŋdaal hʋ kɩ basɩ nyɛ? Ʋ tɩɩ wɩya rɛ koo, nɩdɩma kɩdɩgɩ wɩya rɛ?” ");
INSERT INTO sig_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ɛɛ rɛ Fɩlɩpɩ yaŋ piili wɩya no ʋ aa karɩma tɩyaŋ, a basɩ Yesu Wɩweliye hʋ buloŋ a tɩya baal hʋ. ");
INSERT INTO sig_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nyɛ rɛ ka ba kpa ŋmanɩɩ hʋ kɩ mʋ, a mʋ pele lee kɩdɩgɩ dɩ nɩɩ pɩŋ doŋ. Ɛɛ rɛ baal hʋ basɩ tɩya Fɩlɩpɩ a baa, “Na nɩɩ rɛ nyɛ. Bee rɛ sɩ tɔ ŋ wɩɩkyʋwalnɩɩ foyi daha?” ");
INSERT INTO sig_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ɛɛ rɛ Fɩlɩpɩ basɩ tɩya ʋ a baa, “Dɩ ɩ rɛ laa Yesu wɩya hʋ buloŋ di abee ɩ tɩya buloŋ, ŋ sɩ fo ɩ wɩɩkyʋwalnɩɩ.” Ɛɛ rɛ baal hʋ baa, “Ŋ laa di rɛ anɩɩ Yesu Krisita rɛ yaa Wɩɩsɩ biye.” ");
INSERT INTO sig_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɛɛ rɛ baal hʋ leŋ gyaagʋ hʋ fa aa tarɩ toriku hʋ sɩŋ, ka ʋ bee Fɩlɩpɩ buloŋ kpa tuu nɩɩ hʋ. Doŋ tɩyaŋ nɛ Fɩlɩpɩ fo ʋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba aa ko dɩ ba lɩɩ nɩɩ hʋ tɩyaŋ, Wɩɩsɩ Wiyesi Welii hʋ ko kpa Fɩlɩpɩ dɩɩgɩ. Baal hʋ bɩrɩma dɩ ʋ bɩl bɩ naa Fɩlɩpɩ, aŋka ʋ kpa ʋ ŋmanɩɩ kɩ vala, ʋ teŋ buloŋ fɩyɛlɩ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fɩlɩpɩ yaa dɩ ʋ sɩŋ dɩ ʋ we tɔ kɩdɩgɩ ba aa yɩrɩ Azotu tɩyaŋ. Ɛɛ rɛ ʋ gɔllɩ tɔbiisi hʋ buloŋ mɛ aa we doŋ a kɩ basɩ Wɩɩsɩ wɩya. Ɛɛ rɛ ʋ yaa a mʋ pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Sizaariya. ");
INSERT INTO sig_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ɛɛ rɛ ka Sɔɔl mɛ ha lɩɩ sɩɩ pɔ Yesu hatɩnna hʋ tɩyaŋ, a kɩ fugisi ba, a kɩ basɩ anɩɩ ʋ sɩ kpʋ ba. ");
INSERT INTO sig_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nyɛ rɛ ʋ sii mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ lee a sʋla ʋ, ʋ sabɩ tenni tɩya ʋ dɩ ʋ kaŋ mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Damaasiku. Tenni no fa daga anɩɩ dɩ Sɔɔl ko mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya buloŋ aa we Damaasiku tɩyaŋ, dɩ ba tɩya ʋ ŋmanɩɩ dɩ ʋ kasɩ nala hʋ aa tɩŋ Yesu Krisita ŋmanɩɩ hʋ, ba baala abee ba haana buloŋ, a kaŋ ba mɩɩgɩ mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ɛɛ rɛ Sɔɔl gyɩ sii lɩɩ kpa ŋmanɩɩ a kɩ mʋ Damaasiku. Ʋ gyɩ ko mʋ kpaga Damaasiku rɛ, dɩ kyaanʋʋ kɩdɩgɩ pirige lɩɩ wɩɩsɩnyuu, a kyaanɩ we ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ʋ lɩɩ tele, aŋka ʋ nɩɩ nal taal dɩ ʋ basɩ tɩya ʋ a baa, “Sɔɔl, Sɔɔl, bee rɛ tɩŋ ɩ kɩ dɔgɩsɩ ŋ nyɛ.” ");
INSERT INTO sig_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ɛɛ rɛ Sɔɔl pɩyɛsɩ, “Aŋnɛ rɛ yaa ɩ, ŋ Tɩɩna?” Ɛɛ rɛ taal hʋ baa, “Mɩyaŋ Yesu rɛ, nal hʋ ɩ aa dɔgɩsɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sii mʋ gyʋʋ tɔɔ hʋ. Doŋ tɩyaŋ nɛ ba sɩ daga ɩ wɩɩ hʋ ɩ aa sɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sɔɔl bee nala hʋ fa aa val hʋ buloŋ mɩɩgɩ sɩŋ tuwori kɩ deŋ. Beewɩya ba mɛ nɩɩ taal hʋ rɛ, amɛ ba bɩ naa nal buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ɛɛ rɛ Sɔɔl nyagɩ sii sɩŋ, a kaŋ ʋ sɩya suri. Ʋ sɩya gyɩ ta kyirigi waasʋ gɛɛ rɛ, ka ʋ bee na kɩŋ buloŋ. Ʋ noŋ tɩyaŋ nɛ ba gyɩ kana, a kana ʋ tarɩ mʋ pele Damaasiku. ");
INSERT INTO sig_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ʋ nyʋlɩma we doŋ gɛɛ rɛ ʋ kyɛyɛ boto, dɩ ʋ bɩ wuwo di kɩŋ buloŋ, a bɩ wuwo nyʋwa nɩɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesu hatɩnna hʋ kɩdɩgɩ mɛ gyɩ we Damaasiku tɩyaŋ, ba kɩ yɩrɩ Ananiyasɩ. Nyɛ rɛ ʋ duwosi dɩ á Tɩɩna Yesu yɩrɩ ʋ a basɩ tɩya ʋ a baa, “Ananiyasɩ!” Ɛɛ rɛ ʋ saŋa a baa, “Mɩyaŋ nɛ nyɛ, Tɩɩna.” ");
INSERT INTO sig_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ɛɛ rɛ á Tɩɩna Yesu basɩ tɩya ʋ a baa, “Sii kpa ŋmanɩɩ hʋ ba yɩrɩ ŋmaŋ-deginii hʋ, a mʋ baal kɩdɩgɩ ba aa yɩrɩ Gyudasɩ dɩya. Dɩ ɩ ko mʋ, pɩyɛsɩ ʋ dɩ baal kɩdɩgɩ aa lɩɩ Taasu rɛ ɩ kɩ kyɛ. Ʋ feŋ nɛ yaa Sɔɔl. Ʋ rɛ ha yaŋ kɩ kyʋwalɩ Wɩɩsɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wɩɩsɩ hʋ kyʋwalɩɩ tɩyaŋ, ʋ naa anɩɩ ɩ Ananiyasɩ rɛ ko gyʋʋ a kpa ɩ nosi dɔbɔ ʋ tɩyaŋ ʋ sɩya bɩl suri.” ");
INSERT INTO sig_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ɛɛ rɛ Ananiyasɩ basɩ baa, “Ŋ Tɩɩna, nala yʋga rɛ kɩŋkaŋ a basɩ tɩya ŋ anɩɩ baal no bɔmɔ rɛ weliŋ abee ɩ nala hʋ aa we Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ rɛ tɩya ʋ ŋmanɩɩ dɩ ʋ ko Damaasiku daha, a kasɩ nala hʋ buloŋ aa kyʋwalɩ ɩ.” ");
INSERT INTO sig_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Á Tɩɩna Yesu basɩ tɩya Ananiyasɩ a baa, “Sii mʋ. Mɩyaŋ nɛ lɩɩ ʋ dɩ ʋ tuŋ ŋ tʋma. Ʋ sɩ mʋ basɩ ŋ wɩya tɩya nala hʋ aa bɩ yaa Gyuuma abee kuworo abee Iziral tɩmma mɛ. ");
INSERT INTO sig_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɩyaŋ nɛ sɩ daga ʋ tʋwara maga gɛɛ ʋ aa sɩ na ŋ wɩya.” ");
INSERT INTO sig_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ɛɛ rɛ Ananiyasɩ sii kpa mʋ dɩya hʋ Sɔɔl aa gyʋwa. Nyɛ rɛ ʋ gyʋʋ a kpa ʋ nosi dɔbɔ Sɔɔl tɩyaŋ aŋ baa, “Ŋ naabiye Sɔɔl, á Tɩɩna Yesu hʋ ɩ aa naa ŋmanɩɩ hʋ tɩyaŋ dɩ ɩ aa ko daha, ʋ rɛ tɩma ŋ dɩ ŋ ko daha dɩ ɩ sɩya wuwo suri, ka dɩ Wɩɩsɩ Wiyesi Welii hʋ mɛ gyʋʋ ɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ʋ aa basɩ gɛɛ, dɩ kɩna badɔmɔŋ aa kɩɩ gɛɛ anɩɩ fuwonamɩya para pirige lɩɩ tele ʋ sɩya tɩyaŋ, ka ʋ bɩl wuwo kɩ na. Doŋ tɩyaŋ nɛ ʋ sii, ba fo ʋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ka ʋ di kɩna a bɩl kaŋ dee. Ʋ gyɩ we Damaasiku tɩyaŋ nɛ kyɛyɛ baŋmana, ʋ bee Yesu hatɩnna hʋ aa we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ʋ aa we doŋ gɛɛ rɛ, ʋ aa sii mʋ wɩɩkyʋwaldɩɩsɩ a piili kɩ basɩ Yesu wɩya a kɩ tɩya nala anɩɩ Yesu rɛ yaa Wɩɩsɩ biye hʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nala hʋ buloŋ gyɩ aa nɩɩ wɩya hʋ Sɔɔl aa basɩ, ʋ gyɩ yaa ba buloŋ wɩkperii rɛ. Ba kɩ pɩyɛsɩ dɔmɔŋ, a baa “Baal no daa fa we Gyerusalɛm tɩyaŋ a kɩ kpʋ nala hʋ aa laa Yesu wɩya di gɛɛ? Ka gɛɛ wɩya rɛ ʋ bɩl ko daha dɩ ʋ ko kasɩ ba mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ lee?” ");
INSERT INTO sig_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ɛɛ rɛ ka Sɔɔl marɩ kɩ basɩ wɩya hʋ abee nyuduwo, a te faafaa hʋ. Ʋ wuwo daga rɛ anɩɩ Yesu rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ ko laa dʋnɩya nala ta. Ʋ paalɩ basɩ gɛɛ rɛ Gyuuma hʋ buloŋ aa we Damaasiku tɩyaŋ polo buloŋ yʋwɔrɩ, ba bɩl bɩ wuwo laa wɩɩ buloŋ basɩ. ");
INSERT INTO sig_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ʋ gyɩ we doŋ pɩɩsɩ rɛ. Nyɛ rɛ kyɛɛ kɩdɩgɩ, Gyuuma hʋ sii vʋʋlɩ dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ɛɛ rɛ Sɔɔl ko nɩɩ ba aa kyɛ dɩ ba kpʋ ʋ hʋ wɩya. Wɩɩhaa bee tebine buloŋ, ba aa sɩŋ ba bee pagɩbal hʋ tɩyaŋ nɛ dɩ ba na ʋ a kpʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nyɛ rɛ kyɛɛ kɩdɩgɩ tebine, Sɔɔl noŋ nala hʋ kpa ʋ we simbiye tɩyaŋ, a kaŋ ŋmaŋ vʋwa, a kpa ʋ ta ʋ tuu gyee hʋ ba aa saa baarɩ bee hʋ hal sɔmmm, a sii mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔl aa mʋʋ Gyerusalɛm, ʋ gyɩ aa kyɛ dɩ ʋ gyʋʋ Yesu hatɩnna hʋ aa we doŋ tɩyaŋ nɛ. Amɛ ba gyɩ bɩ laa di anɩɩ ʋ mɛ laa Yesu wɩya di rɛ. Ɛɛ rɛ gyɩ tɩŋ ba gyɩ kɩ fá ʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yesu hatɩnna hʋ kɩdɩgɩ ba aa yɩrɩ Banabaasɩ rɛ gyɩ pɛɛ Sɔɔl tɩyaŋ, a kana ʋ mʋ Yesu kpambɩsɩ hʋ lee. Ʋ rɛ gyɩ basɩ tɩya ba ɛɛ hʋ Sɔɔl aa naa á tɩɩna Yesu ŋmanɩɩ hʋ tɩyaŋ, ʋ basɩ wɩya tɩya ʋ. Aŋ ha gyɩ bɩl basɩ tɩya ba ɛɛ hʋ Sɔɔl aa basɩ Yesu wɩya abee nyuduwo a tɩya nala Damaasiku tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nyɛ rɛ ba laa ʋ we ba tɩyaŋ, ba beel-ʋ buloŋ we doŋ, a kɩ gɔllɩ Gyerusalɛm tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","a kɩ basɩ Wɩɩsɩ wɩya abee nyuduwo á Tɩɩna Yesu feŋ tɩyaŋ. Ʋ bee Gyuuma hʋ aa basɩ Giriki taal gyɩ aa kaŋ wɩya kɩ kpa dɔmɔŋ nɛ. Ba kɩ lʋga dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ʋ dɔŋtɩŋsɩ hʋ aa ko nɩɩ anɩɩ dɩ ba aa lʋga dɩ ba kpʋ ʋ rɛ, ba sii kana ʋ a mʋ Sizaariya, ʋ sɩŋ doŋ kpa mʋ Taasu. ");
INSERT INTO sig_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ɛɛ hal tɩyaŋ nɛ, nala hʋ aa laa Yesu wɩya di Gyudɩya abee Galili abee Samaarɩya paalʋʋ tɩyaŋ, ba buloŋ yaŋ na wiyese, a marɩ laa Wɩɩsɩ wɩya di weliŋ, a kɩ tɩŋ Yesu á Tɩɩna, a kɩ fá ʋ mɛ. Wɩɩsɩ Wiyesi Welii hʋ mɛ pɛ ba tɩyaŋ, ba wala kɩ pɛ. ");
INSERT INTO sig_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lee buloŋ nɛ Piita fa kɩ gɔllɩ. Kyɛɛ kɩdɩgɩ, ʋ sii kpa mʋ Liida dɩ ʋ na Wɩɩsɩ nala hʋ aa we doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ʋ aa mʋ doŋ, ʋ na baal kɩdɩgɩ ba aa yɩrɩ Eniyasɩ. Ʋ fa gbarɩga rɛ, a pɩŋ dɩya tɩyaŋ bɩsɩ kyori, dɩ ʋ bɩ wuwo lɩɩ bee. ");
INSERT INTO sig_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ɛɛ rɛ Piita basɩ tɩya ʋ a baa, “Eniyasɩ, Yesu Krisita tɩya ɩ laaŋfɩya rɛ. Sii kpa ɩ wasa.” Doŋ tɩyaŋ nɛ Eniyasɩ pirigi nyagɩ sii sɩŋ abee dee. ");
INSERT INTO sig_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nala hʋ buloŋ aa lɩɩ Liida abee Saarɔŋ aa naa gɛɛ, ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ nɛ aŋ kɩ tɩŋ á Tɩɩna Yesu. ");
INSERT INTO sig_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Haaŋ kɩdɩgɩ mɛ rɛ fa we Gyoopa tɩyaŋ, a mɛ fa yaa Yesu hatɩnnɩ. Ʋ feŋ nɛ fa yaa Tabiita (Giriki tɩmma fa aa yɩrɩ ʋ Dɔɔkasɩ; Ʋ memii rɛ yaa wiyeme.) Ʋ fa kaŋ bɔnyɛ rɛ weliŋ a kɩ pɛ nyaaba abee nɩtaaga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Piita ha gyɩ aa we Liida tɩyaŋ gɛɛ rɛ ka haaŋ no sʋba Gyoopa tɩyaŋ. Nyɛ rɛ ba fo ʋ nɩɩ, a kana ʋ gyɩŋ biŋ salnyuu dɩya kɩdɩgɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gyoopa bee Liida fa bɩ boliye. Nala hʋ aa laa Yesu wɩya di Gyoopa tɩyaŋ nɩɩ anɩɩ Piita we Liida tɩyaŋ nɛ. Nyɛ rɛ ba tɩŋ nala balɩya ʋ lee dɩ ba mʋ sʋla ʋ dɩ ʋ fa ba wulo lagɩ. Ɛɛ rɛ ba mʋ basɩ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piita sii tɩŋ ba hal a mʋ ko. Ʋ aa ko pele doŋ, ɛɛ rɛ ba kana ʋ gyɩŋ salnyuu dɩya hʋ. Ka lohaana badɔmɔŋ aa we doŋ buloŋ sɩŋ ʋ hal a kɩ wii, a paa galaalɩya abee gavʋwalɩya Dɔɔkasɩ aa mara, a ko lɩɩ kɩ daga Piita. ");
INSERT INTO sig_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ɛɛ rɛ Piita leŋ ba buloŋ lɩɩ dɩya hʋ tɩyaŋ. Ba aa lɩɩ dɩya hʋ tɩyaŋ ko teŋ, ɛɛ rɛ ʋ tuu gbinni a kyʋwalɩ Wɩɩsɩ. Ʋ aa kyʋwalɩ Wɩɩsɩ hʋ mʋ teŋ, ʋ mɩɩgɩ bɩrɩmɩ sʋʋ hʋ lee, a basɩ baa, “Tabiita, sii!” Nyɛ rɛ ʋ kaŋ ʋ sɩya suri. Ʋ aa naa Piita, ʋ sii hɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nyɛ rɛ Piita mʋ pele ʋ, a kaŋ ʋ noŋ tɩyaŋ, ʋ sii sɩŋ. Ɛɛ rɛ ʋ yɩrɩ Wɩɩsɩ nala hʋ abee lohaana hʋ buloŋ ko laŋŋɩ, a kpa Tabiita tɩya ba. Ba buloŋ na ʋ dɩ ʋ bɩl weye. ");
INSERT INTO sig_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nyɛ rɛ wɩɩ no taalɩ Gyoopa buloŋ. Nala yʋga ko laa á Tɩɩna Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piita gyɩ we Gyoopa tɩyaŋ a pɩɩsɩ mʋhʋ rɛ. Baal kɩdɩgɩ gyɩ we doŋ a kɩ tɩgɩsɩ pulo, ba kɩ yɩrɩ Siimɔŋ. Ʋ dɩya rɛ Piita gyɩ gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Baal kɩdɩgɩ rɛ gyɩ we Sizaariya tɩyaŋ ba kɩ yɩrɩ Kɔniiliyo. Ʋ fa yaa laalyuwolo aa lɩɩ Itali paalʋʋ tɩyaŋ nɩhɩyawʋ rɛ, a fa kɩ laa ba kɔɔ sɩya. ");
INSERT INTO sig_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ʋ fa aa tɩŋ Wɩɩsɩ ŋmanɩɩ rɛ weliŋ, ʋ bee ʋ dɩya nala buloŋ fa kɩ kyʋwalɩ Wɩɩsɩ. Ʋ gyɩ aa kɩ pɛ Gyuuma nɩtaaga tɩyaŋ nɛ, aŋ kɩ kyʋwalɩ Wɩɩsɩ mɛ saŋa buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kyɛɛ kɩdɩgɩ wɩɩhaa anɩɩ kerifi boto saŋa, Kɔniiliyo na ʋ duwoso tɩyaŋ dɩ malɩka kɩdɩgɩ ko gyʋʋ yɩrɩ ʋ, “Kɔniiliyo.” ");
INSERT INTO sig_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nyɛ rɛ ʋ kaŋ ʋ sɩya suri dɩ ʋ deŋ malɩka hʋ. Kambɩŋ kana ʋ. Ɛɛ rɛ ʋ pɩyɛsɩ a baa, “Bekiŋ nɛ, ŋ Tɩɩna?” Nyɛ rɛ malɩka hʋ basɩ tɩya ʋ a baa, “Wɩɩsɩ nɩɩ ɛɛ hʋ ɩ aa kɩ kyʋwalɩ ʋ rɛ, a bɩl na ɛɛ hʋ ɩ aa yaa wɩweliye kɩ tɩya nɩtaaga mɛ. Nyɛ wɩya Wɩɩsɩ nɩɩ ɩ kyʋwala rɛ. ");
INSERT INTO sig_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Leŋ dɩ nala mʋ Gyoopa lagɩlagɩ no, a kyɛ yɩrɩ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ Piita dɩ ʋ ko ɩ lee. ");
INSERT INTO sig_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ʋ aa gyʋʋ pul-tɩgɩsɩl kɩdɩgɩ dɩya rɛ ba kɩ yɩrɩ ʋ mɛ Siimɔŋ. Ʋ dɩya sɩŋ kpaga mpʋwɔnʋʋ nyʋwa rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malɩka hʋ aa basɩ wɩya no teŋ, ʋ mɩɩgɩ mʋ. Ɛɛ hal tɩyaŋ nɛ ka Kɔniiliyo yɩrɩ ʋ dɩya tʋŋtʋnna balɩya a pɛ ʋ laalyuwolo kɩdɩgɩ tɩyaŋ. Laalyuwol no fa yaa nala hʋ aa sɩŋ kɩ pɔ Kɔniiliyo tɩyaŋ kɩdɩgɩ rɛ, a fa kɩ fá Wɩɩsɩ mɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nyɛ rɛ Kɔniiliyo basɩ wɩya hʋ buloŋ ʋ aa naa a tɩya ba, aŋ ta ba, ba kpa mʋ Gyoopa. ");
INSERT INTO sig_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ʋ sɩgballɩya, wɩɩsɩ ko kɩ maga nyutʋtʋʋ gɛɛ, dɩ ba kpaga Gyoopa rɛ. Saŋa no tɩɩ tɩyaŋ nɛ Piita mɛ sii gyɩŋ salnyuu dɩ ʋ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Doŋ tɩyaŋ nɛ losi fa kana ʋ kɩŋkaŋ, ʋ baa dɩ ba yaa kɩdiiliye tɩya ʋ dɩ ʋ di. Nyɛ rɛ ba sii kɩ yaa kɩdiiliye dɩ ba tɩya ʋ. Ba aa yaa kɩdiiliye hʋ tɩyaŋ nɛ, ka Piita na wɩɩ anɩɩ duwoso tɩyaŋ ");
INSERT INTO sig_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","dɩ Wɩɩsɩ nyuu lɔgɔ suri. Ka kɩŋ kɩdɩgɩ kɩɩ gɛɛ anɩɩ wagyɛbal a lɩɩ wɩɩsɩnyuu, a kɩɩ gɛɛ anɩɩ nala rɛ kaŋ ganyʋʋsɩ hʋ banaa tɩyaŋ, a kaŋ ko kɩ tuu taŋha. ");
INSERT INTO sig_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ka pʋsɩ bee bagɩla kɛ iriŋ buloŋ abee gyaala iriŋ buloŋ, abee kɩna aa tuuri taŋha buloŋ iriŋ iriŋ we ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɛɛ rɛ ʋ nɩɩ nal taal dɩ ʋ basɩ tɩya ʋ a baa, “Piita, sii kpʋ kɩ kyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ɛɛ rɛ Piita baa, “Aayɩ, ŋ Tɩɩna, ŋ ha bɩ maakyiye kyaŋ kɩŋ buloŋ aa yaa bisiŋ kɩŋ, koo á sɩna.” ");
INSERT INTO sig_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɛɛ rɛ taal hʋ bɩl mɩɩgɩ basɩ tɩya ʋ a baa, “Kɩŋ kɛ buloŋ Wɩɩsɩ aa baa ʋ weliye, ta basɩ baa ʋ yaa bisiŋ kɩŋ nɛ.” ");
INSERT INTO sig_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Wɩya no buloŋ yaa gɛɛ rɛ naaŋsɩɩnyʋwa bʋto, ka kɩna hʋ bɩl mɩɩgɩ gyɩŋ wɩɩsɩnyuu, aŋ bɩl bɩ ko tuu. ");
INSERT INTO sig_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wɩɩ hʋ yaa Piita wɩkperii. Ɛɛ rɛ ʋ hɔŋ kɩ kyɛ wɩɩ hʋ ʋ aa naa memii, dɩ nala hʋ Kɔniiliyo fa aa tɩma hʋ rɛ pɩyɛsa ko sɩŋ Siimɔŋ paganyʋwa tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nyɛ rɛ ba na nal kɩdɩgɩ gyaŋwuwo hʋ tɩyaŋ a pɩyɛsɩ a baa, “Nɩhʋwal kɩdɩgɩ we dɩya no tɩyaŋ ba kɩ yɩrɩ Siimɔŋ Piita rɛ?” ");
INSERT INTO sig_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piita ha fa hɔnɔ rɛ a kaŋ wɩɩ hʋ ʋ fa aa naa hʋ kɩ bɩɩnɩ dɩ ʋ na ʋ memii. Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ basɩ tɩya ʋ a baa, “Deŋ na, baala boto rɛ we daha a kɩ kyɛ ɩ. ");
INSERT INTO sig_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sii tuu, a ta yaa gyegye, ka dɩ ɩ tɩŋ ba tɩyaŋ mʋ. Mɩyaŋ nɛ tɩm-ba ɩ lee” ");
INSERT INTO sig_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nyɛ rɛ Piita sii ko tuu, a basɩ tɩya ba a baa, “Mɩyaŋ nɛ yaa nal hʋ ma aa kyɛ. Bekiŋ wɩɩ rɛ ma kaŋ kɩ kyɛ ŋ?” ");
INSERT INTO sig_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ƐƐ rɛ ba baa, “Laalyuwolo nɩhɩyawʋ kɩdɩgɩ ba aa yɩrɩ Kɔniiliyo, ʋ rɛ tɩm-ma. Ʋ yaa tɩpʋlʋŋ tɩɩna rɛ, a kɩ fá Wɩɩsɩ mɛ kɩŋkaŋ. Gyuuma mɛ buloŋ kɩ tɩya ʋ gyɩrɩma weliŋ. Malɩka kɩdɩgɩ rɛ ko basɩ tɩya ʋ dɩ ʋ yɩrɩ ɩ, dɩ dɩ ɩ rɛ ko ʋ dɩya, dɩ ʋ sɩ nɩɩ wɩɩ hʋ ɩ aa sɩ basɩ tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ɛɛ rɛ Piita sʋl ba dɩ ba gyʋʋ pɩŋ sɩya gballɩ. Ʋ sɩya aa gballa, ʋ sii ba buloŋ kpa mʋ. Nala hʋ aa laa Yesu wɩya di Gyoopa tɩyaŋ, ba badɔmɔŋ mɛ sii tɩŋa ʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ba aa lɩɩ ŋmanɩɩ, ʋ kyɛlɩya kyɛɛ rɛ ba gyʋʋ Sizaariya. Bee no tɩyaŋ nɛ Kɔniiliyo fa we. Ba aa mʋ dɩ ʋ bee ʋ lʋlla abee ʋ kyaŋsɩ badɔmɔŋ ʋ aa yɩra, dɩ ba buloŋ hɔŋ kɩ gyegili ʋ. ");
INSERT INTO sig_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piita aa ko dɩ ʋ gyʋʋ, Kɔniiliyo sii mʋ kyem-ʋ, a tuu gbinni ʋ sɩya tɩyaŋ, a kyʋwalɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Doŋ tɩyaŋ nɛ Piita leŋ ʋ sii sɩŋ, ka ʋ basɩ tɩya ʋ a baa, “Ta yaa gɛɛ, beewɩya, ŋ mɛ yaa nihuwobiŋ nɛ anɩɩ ɩ.” ");
INSERT INTO sig_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piita bee Kɔniiliyo basɩ wɩya kpa tɩŋ dɔmɔŋ kɩ gyʋʋ dɩya hʋ. Piita aa gyʋʋ dɩ nala bɩ kyalla a laŋŋɩ doŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nyɛ rɛ Piita basɩ tɩya ba a baa, “Ma tɩɩtɩɩ gyɩma rɛ anɩɩ Gyuuma wɩɩkyʋwal ŋmanɩɩ tɩyaŋ, ʋ yaa sɩna rɛ dɩ ba laŋŋɩ nala hʋ aa bɩ yaa Gyuuma tɩyaŋ. Ba paalɩ bee gyʋʋ ba dɩɩsɩ mɛ gba. Amɛ, ŋ kɛ, Wɩɩsɩ daga ŋ nɛ dɩ ŋ ta buloŋ kaŋ nal buloŋ kɩ yɩrɩ bisiŋ tɩɩna. ");
INSERT INTO sig_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɛɛ rɛ tɩŋ ba aa ko yɩrɩ ŋ, ŋ bɩ kaŋ vɩya. Ŋ aa ko nyɛ, yaŋ basɩ wɩɩ hʋ aa tɩŋ ɩ yɩrɩ ŋ?” ");
INSERT INTO sig_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nyɛ rɛ Kɔniiliyo basɩ tɩya ʋ a baa, “Ʋ kyɛyɛ banaa rɛ nyɛ, anɩɩ saŋa no tɩɩ tɩyaŋ nɛ, wɩɩhaa kerifi boto saŋa, ŋ kɩ kyʋwalɩ Wɩɩsɩ ŋ dɩya tɩyaŋ. Dɩ baal kɩdɩgɩ rɛ gɛɛ, a ko sɩŋ ŋ sɩya tɩyaŋ. Ka ʋ gannɩ buloŋ kɩ tʋla. ");
INSERT INTO sig_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nyɛ rɛ ʋ basɩ tɩya ŋ a baa, ‘Kɔniiliyo, Wɩɩsɩ nɩɩ ɩ aa kɩ kyʋwalɩ ʋ gɛɛ rɛ, a na ɩ aa kɩ pɛ nyaaba abee nɩtaaga mɛ tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Sii tɩŋ nala dɩ ba mʋ Gyoopa, a kyɛ yɩrɩ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ Piita dɩ ʋ ko. Ʋ aa gyʋʋ pul-tɩgɩsɩl kɩdɩgɩ dɩya rɛ, ba kɩ yɩrɩ ʋ mɛ Siimɔŋ. Ʋ dɩya sɩŋ kpaga mpʋwɔnʋʋ hʋ nyʋwa rɛ.’ ");
INSERT INTO sig_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kɔniiliyo bɩl basɩ baa, ‘Ɛɛ rɛ tɩŋ ŋ ta nala lagɩlagɩ dɩ ba ko yɩrɩ ɩ. Ɩ mɛ yaa kuwokeri rɛ, ɩ aa wuwo ko nyɛ. Lagɩlagɩ no, á buloŋ laŋŋa rɛ Wɩɩsɩ sɩya tɩyaŋ, a kɩ gyegili dɩ á nɩɩ wɩɩ hʋ buloŋ Wɩɩsɩ aa daga ɩ dɩ ɩ basɩ tɩya ma.”’ ");
INSERT INTO sig_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nyɛ rɛ Piita yaŋ kaŋ nyʋwa suri, a baa, “Wɩtɩɩ rɛ, nyɛ kɛ ŋ gyɩma anɩɩ Wɩɩsɩ kɛ sɩya tɩyaŋ, nihuwobiŋ buloŋ yaa kɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nal kɛ buloŋ aa fá Wɩɩsɩ, aŋ kɩ yaa wɩya hʋ aa tɩŋ ŋmanɩɩ, Wɩɩsɩ aa laa ʋ rɛ. Beewɩya, Wɩɩsɩ bee lugisi nala a kuu ba aa yaa haŋ nihuwobiŋ iriŋ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Na ma nɩɩ duwoso hʋ Wɩɩsɩ aa kpaa tɩya Iziral tɩmma rɛ. Ʋ basɩ tɩya ba rɛ dɩ ba tɩŋ Yesu Krisita dɩ ba bee Wɩɩsɩ mɩɩgɩ marɩ dɔmɔŋ, beewɩya, ʋ rɛ yaa nihuwobiŋ buloŋ Tɩɩna. ");
INSERT INTO sig_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","A piili saŋa hʋ Gyɔɔŋ gyɩ aa basɩ Wɩɩsɩ nɩɩfori hʋ wɩya Galili tɩyaŋ, ma buloŋ gyɩŋ wɩbal hʋ gyɩ aa yaa rɛ Iziral paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma mɛ nɩɩ Yesu aa lɩɩ Nazarɛti wɩya rɛ. Wɩɩsɩ tɩya ʋ dee rɛ, aŋ kpa ʋ Wiyesi Welii hʋ we ʋ tɩyaŋ. Ɛɛ rɛ ʋ sii mʋ lee buloŋ, a yaa wɩweliye kɩ tɩya nala, ka nala hʋ buloŋ mɛ Sɩtaanɩ aa vʋwa biŋ, ʋ puri ba mɛ ta, aŋ tɩɩbɩ ba buloŋ. Wɩɩsɩ fa sɩŋ ʋ hal lɛ, ɛɛ rɛ tɩŋ ʋ fa wuwo kɩ yaa wɩya no buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wɩya hʋ buloŋ ʋ aa yaa Gyerusalɛm tɩyaŋ abee Gyuuma paalʋʋ tɩyaŋ, ba buloŋ nɛ á na, a yaa ba daŋsɩya diile mɛ. Ba kana ʋ rɛ, a kpaasɩ ʋ mal daagarɩɩ hʋ nyuu tɩyaŋ, ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amɛ ʋ kyɛyɛ boto kyɛɛ, Wɩɩsɩ bɩl kyisi ʋ sʋʋ tɩyaŋ nɛ, a leŋ nala na ʋ. ");
INSERT INTO sig_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ka ʋ aa mɩɩgɩ sii hal tɩyaŋ, nal buloŋ daa bɩl na ʋ, see á nala hʋ Wɩɩsɩ aa lɩya dɩ á yaa ʋ daŋsɩya diile. Á dʋŋ nɛ na ʋ. Ʋ aa sii sʋʋ tɩyaŋ mɛ, á beel-ʋ buloŋ laŋŋa di kɩna rɛ. ");
INSERT INTO sig_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ɛɛ rɛ ka ʋ basɩ tɩya ma abee sɩfɩyasɩ dɩ á basɩ Wɩɩsɩ wɩweliye hʋ kɩ tɩya nala, a kɩ daga ba anɩɩ ʋ rɛ Wɩɩsɩ lɩɩ, dɩ ʋ yaa niweye abee sʋʋnɩ buloŋ sarɩdiil. ");
INSERT INTO sig_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wɩɩsɩ tɩŋdaala hʋ buloŋ mɛ fa basɩ ʋ wɩya rɛ, a baa dɩ nal buloŋ nɛ ko laa ʋ wɩya di, dɩ Wɩɩsɩ sɩ kpa ʋ wɩbɔmɔ buloŋ kyɛ ʋ Yesu Krisita feŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piita ha aa sɩŋ kɩ basɩ wɩya hʋ gɛɛ, dɩ Wɩɩsɩ Wiyesi Welii hʋ ko tuu gyʋʋ nala hʋ buloŋ fa aa gyegile kɩ nɩɩ wɩya hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Gyuuma hʋ fa aa laa Yesu wɩya di, a lɩɩ Gyoopa tɩŋ Piita hal ko, ba nɩya anɩɩ ba aa basɩ wɩya abee taanɩ ba aa bɩ gyɩma, a kɩ dannɩ Wɩɩsɩ. Ʋ yaa ba wɩkperii, beewɩya, ba fa bɩ liise anɩɩ Wɩɩsɩ sɩ kpa ʋ Wiyesi Welii hʋ we nala hʋ aa bɩ yaa Gyuuma mɛ tɩyaŋ. Ɛɛ rɛ Piita basɩ baa, ");
INSERT INTO sig_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ɛɛ hʋ Wɩɩsɩ aa yaŋ kpa ʋ Wiyesi Welii hʋ we á tɩyaŋ, ɛɛ tɩɩ rɛ ʋ kpa ʋ we nala no mɛ tɩyaŋ. Wɩbee rɛ yaŋ sɩ wuwo tɔ nala no dɩ ba ta foo ba wɩɩkyʋwalnɩɩ?” ");
INSERT INTO sig_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ɛɛ rɛ ka ʋ leŋ ba fo ba wɩɩkyʋwalnɩɩ Yesu Krisita feŋ tɩyaŋ. Ɛɛ hal tɩyaŋ nɛ ba sʋla Piita, dɩ ʋ hɔŋ ba lee kyɛyɛ baŋmana. ");
INSERT INTO sig_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu kpambɩsɩ hʋ abee nala hʋ buloŋ aa laa Yesu wɩya di Gyudɩya paalʋʋ buloŋ tɩyaŋ, ba buloŋ nɩya anɩɩ nala hʋ aa bɩ yaa Gyuuma mɛ laa Wɩɩsɩ wɩya di rɛ. ");
INSERT INTO sig_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ɛɛ rɛ ka Piita mɛ mɩɩgɩ ko Gyerusalɛm. Doŋ tɩyaŋ nɛ Gyuuma badɔmɔŋ sii kɩ basɩ ʋ wɩya akuu wɩya hʋ ʋ aa yaa nala hʋ aa bɩ yaa Gyuuma tɩyaŋ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ɛɛ rɛ ba pɩyɛsɩ Piita a baa, “Bee rɛ tɩŋ ɩ mʋ nala hʋ aa bee keri ba pene lee, haalɩ, ɩ beel-ba gba laŋŋɩ di kɩna?” ");
INSERT INTO sig_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ɛɛ rɛ Piita yaŋ piili a basɩ wɩya hʋ aa vala gɛɛ buloŋ a tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ʋ baa, “Ŋ gyɩ we Gyoopa tɩyaŋ nɛ. Ɛɛ rɛ kyɛɛ kɩdɩgɩ, ŋ hɔŋ kɩ kyʋwalɩ Wɩɩsɩ. Wɩɩsɩ hʋ kyʋwalɩɩ tɩyaŋ nɛ, ʋ kɩɩ gɛɛ anɩɩ ŋ aa duwosi, ka ŋ na kɩŋ kɩdɩgɩ dɩ ʋ kɩɩ gɛɛ anɩɩ wagyɛbal aa lɩɩ wɩɩsɩnyuu ko kɩ tuu, ka ba kaŋ ʋ nyʋʋsɩ hʋ banaa tɩyaŋ, a kaŋ ko tuu biŋ ŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ŋ yaa dɩ ŋ deŋ ʋ tɩyaŋ dɩ ŋ naa pʋsɩ abee bagɩla abee kɩna hʋ buloŋ aa tuuri taŋha abee gyaala iriŋ iriŋ buloŋ we ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ɛɛ rɛ ka ŋ nɩɩ nal basɩ tɩya ŋ a baa, ‘Piita, sii kpʋ kɩ kyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ɛɛ rɛ ŋ baa, ‘Aayɩ, ŋ Tɩɩna, ŋ ha bɩ maakyiye di bisiŋ kɩŋ buloŋ.”’ ");
INSERT INTO sig_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nyɛ rɛ taal hʋ bɩl lɩɩ wɩɩsɩnyuu, a basɩ tɩya ŋ a baa, “Kɩŋ kɛ buloŋ Wɩɩsɩ aa baa ʋ weliye, ta baa dɩ ʋ yaa bisiŋ kɩŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wɩɩ no yaa gɛɛ rɛ naaŋsɩɩnyʋwa bʋto, ka kɩna hʋ bɩl mɩɩgɩ gyɩŋ wɩɩsɩnyuu. ");
INSERT INTO sig_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Haŋ saŋa hʋ tɩɩ rɛ baala boto mɛ ba aa tɩma ŋ lee, ba lɩɩ Sizaariya, dɩ ba mɛ yaŋ ko kɩ pele dɩya hʋ tɩyaŋ ŋ fa aa gyʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ basɩ tɩya ŋ dɩ ŋ ta yaa gyegye, akuu ba aa bɩ yaa Gyuuma wɩya, ka dɩ ŋ tɩŋ ba hal mʋ. Nyɛ rɛ ŋ bee ŋ naabalɩya hʋ aa laa Yesu wɩya di Gyoopa tɩyaŋ nala badʋ sii kpa mʋ Sizaariya, a mʋ gyʋʋ Kɔniiliyo dɩya. ");
INSERT INTO sig_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɛɛ rɛ ʋ basɩ tɩya ma ɛɛ hʋ ʋ aa naa malɩka dɩ ʋ sɩŋ ʋ dɩya tɩyaŋ, a basɩ tɩya ʋ dɩ ʋ tɩŋ nala dɩ ba mʋ Gyoopa a yɩrɩ baal kɩdɩgɩ ba aa yɩrɩ Siimɔŋ Piita dɩ ʋ ko. ");
INSERT INTO sig_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dɩ ʋ sɩ basɩ wɩya tɩya ba, aŋ daga ba wɩya hʋ aa sɩ laa ʋ bee ʋ dɩya nala buloŋ ta. ");
INSERT INTO sig_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ɛɛwɩya, ŋ aa piili kɩ basɩ wɩya hʋ, Wɩɩsɩ Wiyesi Welii hʋ ko tuu gyʋʋ ba tɩyaŋ nɛ anɩɩ ʋ gyɩ aa laa sɩya ko gyʋʋ á tɩyaŋ piili hʋ tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wɩɩ no aa ko yaa tɩyaŋ nɛ, ŋ liisi wɩɩ hʋ á Tɩɩna Yesu fa aa basa. Ʋ fa baa, ‘Nɩɩ dʋŋ nɛ Gyɔɔŋ kaŋ kɩ fo nala wɩɩkyʋwalnɩɩ, amɛ ŋ kɛ sɩ kpa Wiyesi Welii hʋ fo ma wɩɩkyʋwalnɩɩ.’ ");
INSERT INTO sig_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɛɛ hʋ Wɩɩsɩ gyɩ aa yaŋ kpa ʋ Wiyesi Welii hʋ we á tɩyaŋ saŋa hʋ tɩyaŋ á aa laa á Tɩɩna Yesu Krisita wɩya di, ɛɛ tɩɩ rɛ ʋ kpa ʋ we ba tɩyaŋ mɛ. Mɩyaŋ nɛ yaŋ yaa aŋnɛ, ŋ aa sɩ tɔ Wɩɩsɩ ŋmanɩɩ dɩ ʋ ta yaa ʋ wɩkyɛɛlɩɩ.” ");
INSERT INTO sig_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ba aa nɩɩ wɩya no, ba bɩl bɩ wuwo basɩ wɩɩ buloŋ. Nyɛ rɛ ba dannɩ Wɩɩsɩ a baa, “Wɩɩsɩ tɩya nala mɛ aa bɩ yaa Gyuuma ŋmanɩɩ rɛ dɩ ba mɛ wuwo bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ, aŋ kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii.” ");
INSERT INTO sig_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ba aa kpʋʋ Sɩtɩɩvɩŋ hal tɩyaŋ, ɛɛ hʋ ba gyɩ aa dɔgɩsɩ nala hʋ aa laa Yesu wɩya di Gyerusalɛm tɩyaŋ gyɩ leŋ ba gyeniŋ buloŋ lɩɩ fá pɩsa mʋ leye rɛ. Ba tɩyaŋ, badɔmɔŋ gyɩ mʋʋ pele Fɔniisɩya abee Saapʋrɔsɩ paalʋʋ rɛ, abee tɔɔ hʋ ba aa yɩrɩ Aŋtiyɔki. Doŋ tɩyaŋ ba basɩ Wɩɩsɩ wɩya a kɩ tɩya Gyuuma hʋ dʋŋ aa we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amɛ nala hʋ badɔmɔŋ aa laa Yesu wɩya di Saapʋrɔsɩ abee Sariini tɩyaŋ sii mʋ Aŋtiyɔki, a basɩ á Tɩɩna Yesu wɩweliye hʋ a kɩ tɩya nala hʋ mɛ aa bɩ yaa Gyuuma. ");
INSERT INTO sig_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wɩɩsɩ gyɩ pɛɛ ba tɩyaŋ nɛ, a sɩŋ ba hal mɛ. Ɛɛ rɛ nala yʋga gyɩ laa Yesu wɩya di a bɩrɩmɩ kɩ tɩŋa ʋ. ");
INSERT INTO sig_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nyɛ rɛ wɩɩ no duwoso gyɩ pele Yesu hatɩnna hʋ aa we Gyerusalɛm tɩyaŋ. Ba sii tɩŋ Banabaasɩ dɩ ʋ mʋ Aŋtiyɔki na. ");
INSERT INTO sig_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ʋ gyɩ aa mʋwa, ʋ naa ɛɛ hʋ Wɩɩsɩ aa pɛɛ nala hʋ tɩyaŋ nɛ. Ʋ teŋ buloŋ gyɩ fɩyɛlɩ. Ʋ basɩ wɩya kyagɩlɩ ba weliŋ aŋ baa dɩ ba sɩŋ á Tɩɩna Yesu laadii tɩyaŋ abee ba tɩsɩ buloŋ aŋ ta ko kpa kɩ ta. ");
INSERT INTO sig_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabaasɩ fa yaa tɩpʋlʋŋ tɩɩna rɛ, a fa laa Wɩɩsɩ di weliŋ. Wɩɩsɩ Wiyesi Welii hʋ mɛ fa we ʋ tɩyaŋ weliŋ. Ɛɛ nyuniŋ, nala gyɩ yʋga rɛ a ko laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nyɛ rɛ Banabaasɩ sii mʋ Taasu, dɩ ʋ kyɛ Sɔɔl lee. ");
INSERT INTO sig_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ʋ aa mʋʋ na ʋ, ʋ kana ʋ, ba buloŋ mɩɩgɩ ko Aŋtiyɔki. Banabaasɩ bee Sɔɔl buloŋ gyɩ hɔŋ doŋ nɛ bɩŋpiliŋ. Ba bee nɩgyamaa hʋ aa laa Yesu wɩya di aa vala kɩ laŋŋɩ saŋa buloŋ, ba kɩ daga nala hʋ Wɩɩsɩ wɩya. Aŋtiyɔki tɩyaŋ nɛ ba gyɩ piili kaŋ Yesu hatɩnna kɩ yɩrɩ Krisitabiisi. ");
INSERT INTO sig_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Saŋa no tɩyaŋ nɛ Wɩɩsɩ tɩŋdaala badɔmɔŋ mɛ lɩɩ Gyerusalɛm a ko Aŋtiyɔki. ");
INSERT INTO sig_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba kɩdɩgɩ feŋ nɛ Agabu. Nyɛ rɛ ʋ sii sɩŋ a tɩya Wɩɩsɩ tɩŋdarɩ, a baa dɩ losiŋbɔŋ sɩ gyʋʋ dʋnɩya buloŋ. (Losi no gyɩ ko kɩ gyʋʋ dɩ Kilodiyasi rɛ fa yaa Roma paalʋʋ kuworibal.) ");
INSERT INTO sig_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nyɛ rɛ Yesu hatɩnna hʋ vʋʋlɩ anɩɩ ba sɩ kɩyɛsɩ molbiye, a tɩma dɩ ba kaŋ mʋ tɩya ba dɔŋtɩŋsɩ Krisitabiisi hʋ aa we Gyudɩya paalʋʋ tɩyaŋ. Ba baa dɩ nal buloŋ tɩya maga gɛɛ hʋ buloŋ ʋ aa kana. ");
INSERT INTO sig_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɛɛ rɛ ba kɩyɛsɩ molbiye no ko pɛ dɔmɔŋ, a kpa tɩya Banabaasɩ bee Sɔɔl dɩ ba kaŋ mʋ tɩya Krisitabiisi nɩhɩyasɩ hʋ aa we Gyerusalɛm tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Saŋa no tɩyaŋ, Gyuuma paalʋʋ kuworibal feŋ nɛ fa yaa Hɛrɔtɩ. Ɛɛ rɛ ʋ mɛ sii piili a kɩ dɔgɩsɩ Krisitabiisi hʋ badɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ʋ gyɩ leŋ ba kaŋ Gyɔɔŋ maana Gyemsi rɛ, a keri ʋ nyuu abee takoobii. ");
INSERT INTO sig_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ʋ gyɩ aa na dɩ Gyuuma hʋ teŋ fɩyɛla abee wɩɩ hʋ ʋ aa yaa tɩyaŋ, ʋ bɩl leŋ ba kaŋ Piita mɛ tɔ dɩyaŋ. (Ba kyɛbal hʋ tɩyaŋ ba aa kyaŋ paanʋʋ ba aa bɩ wee sɩbʋl hʋ, ʋ tɩyaŋ nɛ ba gyɩ kaŋ Piita gɛɛ). ");
INSERT INTO sig_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ba gyɩ aa kaŋ Piita, ba gyɩ kana ʋ mʋ tɔ dɩya tɩyaŋ nɛ. Ka Kuwori Hɛrɔtɩ leŋ laalyuwolo fi abee badʋ sɩŋ kɩ pɔ ʋ. Ba nala banaa gyɩ aa deŋ ʋ mʋ maga gɛɛ rɛ ka banaa mɛ bɩl ko laa ba. Kuwori Hɛrɔtɩ fa aa kyɛ dɩ Dɩɩsɩ-parɩ-banɩɩ Kyɛbal hʋ rɛ fa baŋ, ka dɩ ʋ yaŋ lɩɩ Piita nɩtɔdɩya hʋ tɩyaŋ, a tɩya nala hʋ dɩ ba di ʋ sarɩya. ");
INSERT INTO sig_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piita gyɩ we nɩtɔdɩya hʋ tɩyaŋ nɛ, ka Krisitabiisi hʋ aa laŋŋɩ saŋa buloŋ, a kyʋwalɩ Wɩɩsɩ kɩ tɩya ʋ sɩfɩyaŋ abee ba tɩsɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nyɛ rɛ kyɛɛ kɩdɩgɩ tebine, Piita gyɩ pɩŋ laalyuwol hʋ aa deŋ ʋ balɩya tʋtʋʋ, ka ba kaŋ kyɔrʋmɔ balɩya vʋwa ʋ a mʋ mal ba kɩdɩgɩ buloŋ tɩyaŋ. Ka laalyuwolo mɛ ha sɩŋ pɔ nɩtɔdɩya hʋ dimbeenyʋwa. Ʋ sɩya rɛ fa sɩ sii gballɩ dɩ Hɛrɔtɩ lɩɩ ʋ nɩtɔdɩya hʋ tɩyaŋ a tɩya bee hʋ nala dɩ ba di ʋ sarɩya. ");
INSERT INTO sig_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nyɛ rɛ malɩka kɩdɩgɩ pirigi ko sɩŋ Piita lee. Nɩtɔdɩya hʋ buloŋ kyaanɩ. Nyɛ rɛ malɩka hʋ ko pɩyɛsɩ Piita vaaŋ tɩyaŋ, a kyisi ʋ, a basɩ tɩya ʋ dɩ ʋ sii lagɩ. Nyɛ rɛ kyɔrʋmɔ hʋ pirigi yɔrɩmɩ lɩɩ Piita nosi tɩyaŋ a tuu tele. ");
INSERT INTO sig_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ɛɛ rɛ malɩka hʋ basɩ tɩya ʋ a baa, “Sii paa ɩ kɩna laalɩ aŋ paa ɩ naatɔbɔ mɛ we. Doŋ nɛ Piita yaa gɛɛ. Malɩka hʋ bɩl basɩ tɩya ʋ a baa, ‘Kpa ɩ wagyɛ tɔ, a kɩ tɩŋa ŋ hal.”’ ");
INSERT INTO sig_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nyɛ rɛ ʋ tɩŋa ʋ hal lɩɩ nɩtɔdɩya hʋ tɩyaŋ. Ʋ aa tɩŋ malɩka hʋ hal gɛɛ, ka ʋ ha fa bɩ gyɩma dɩ wɩɩ hʋ malɩka hʋ aa yaa yaa wɩtɩɩ rɛ, koo ʋ aa duwoso rɛ. ");
INSERT INTO sig_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba mʋ gallɩ laalyuwolo hʋ aa sɩŋ sɩya a kɩ deŋ nɩtɔdɩya hʋ a bɩl mʋ gallɩ laalyuwolo hʋ badɔmɔŋ mɛ aa sɩŋ hal a mɛ ha kɩ deŋ nɩtɔdɩya hʋ, a mʋ pele hɔgɩ boro hʋ aa tɔɔ pagɩbal hʋ aa gyʋʋ bee hʋ. Ɛɛ rɛ boro hʋ suri ʋ tɩɩ tɩyaŋ ba mʋ lɩɩ. Ba lɩɩ kpa ŋmanɩɩ kɩdɩgɩ a vala kɩ mʋ. Ba aa kpa vala mʋhʋ malɩka hʋ leŋ Piita ta doŋ, aŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Doŋ tɩyaŋ nɛ Piita hakɩla yaŋ ko, ʋ gyɩma anɩɩ wɩya hʋ aa yaa hʋ yaa wɩtɩɩ rɛ. Ɛɛ rɛ ʋ baa, “Nyɛ kɛ, ŋ gyɩma anɩɩ Wɩɩsɩ rɛ tɩŋ ʋ malɩka dɩ ʋ ko laa ŋ ta Kuwori Hɛrɔtɩ nosi tɩyaŋ abee wɩbɔmɔ hʋ buloŋ Gyuuma hʋ fa aa liisi dɩ ba yaa ŋ.” ");
INSERT INTO sig_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Piita aa ko gyɩŋ nyɛ tɩyaŋ, ʋ kpa mʋ Gyɔɔŋ Maakɩ nɩɩna Mɛɛrɩ dɩya. Ʋ mʋʋ doŋ dɩ nɩgyamaa laŋŋa a kɩ kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ɛɛ rɛ Piita mʋ ŋmaa pagɩbal hʋ boro. Haŋtolibiye kɩdɩgɩ aa yaa dʋŋdɔbɩɩ haŋ dɩya hʋ tɩyaŋ, ba kɩ yɩrɩ Roda, ko lɩɩ dɩ ʋ na nal hʋ aa ŋmaa boro hʋ. ");
INSERT INTO sig_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ʋ aa ko nɩɩ tɩɩna taal, ʋ gyɩma anɩɩ Piita rɛ. Ʋ teŋ buloŋ fɩyɛlɩ kɩŋkaŋ. Ɛɛ rɛ ʋ bɩl bɩ suro boro hʋ, aŋ mɩɩgɩ fá gyʋʋ basɩ tɩya nala hʋ aa we dɩya hʋ tɩyaŋ anɩɩ Piita rɛ sɩŋ gyaŋhala tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɛɛ rɛ ba mɩɩgɩ basɩ tɩya ʋ dɩ ʋ aa yaarɩ rɛ. Ka ʋ ha vɩya aŋ baa dɩ wɩtɩɩ rɛ ʋ kɩ basɩ. Ɛɛ rɛ ba baa dɩ gɛɛ kɛ Piita dʋma rɛ ʋ na gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ba aa basɩ wɩya no buloŋ gɛɛ, ka Piita mɛ ha sɩŋ kɩ ŋmaa boro hʋ. Ɛɛ rɛ ba ko kaŋ boro hʋ suri dɩ ʋ rɛ sɩna gɛɛ, ba buloŋ nyʋʋsɩ fɩyɛlɩ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ɛɛ rɛ Piita kaŋ ʋ noŋ viri ba dɩ ba leŋ kyagɩŋsɩ, aŋ basɩ tɩya ba ɛɛ hʋ Wɩɩsɩ aa lɩɩ ʋ nɩtɔdɩya hʋ tɩyaŋ. Ʋ baa dɩ ba basɩ wɩɩ no tɩya Gyemsi abee ba nɩkaalɩya hʋ mɛ aa laa Yesu wɩya di. Ʋ aa basɩ wɩya no buloŋ ko teŋ ʋ leŋ ba aŋ mʋ lee kɩdɩgɩ. ");
INSERT INTO sig_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ʋ sɩya aa gballa kyɩkyʋwala ba kyɛ Piita lɔlɔ. Ɛɛ rɛ nyʋʋtaaduwo gyʋʋ ba, ba hakɩllɩ buloŋ vʋgɩmɩ, ba kɩ pɩyɛsɩ dɔmɔŋ anɩɩ lee rɛ Piita we? ");
INSERT INTO sig_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ɛɛ rɛ Kuwori Hɛrɔtɩ baa dɩ ba kyɛ kaŋ Piita ko. Nyɛ rɛ ba kyɛ ʋ lɔlɔ. Kuwori Hɛrɔtɩ marɩ pɩyɛsɩ laalyuwolo hʋ dɩ ʋ gyɩŋ ɛɛ hʋ wɩya hʋ aa vala, aŋ baa dɩ ba kpʋ ba. Ɛɛ hal tɩyaŋ nɛ Kuwori Hɛrɔtɩ sii Gyudɩya paalʋʋ tɩyaŋ, a kpa mʋ Sizaariya, a hɔŋ doŋ. ");
INSERT INTO sig_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Saŋa no tɩyaŋ, Kuwori Hɛrɔtɩ gyɩ naa baaŋ nɛ kɩŋkaŋ Taaya bee Siidɔŋ tɩmma nyuu tɩyaŋ. Ɛɛ rɛ ba sii yaa nyʋʋdɩgɩ mʋ dɩ ba na Kuwori Hɛrɔtɩ. Nyɛ rɛ ba laa sɩya mʋ na Bilasitu, nal hʋ aa deŋ Kuwori hʋ dɩya, dɩ ʋ pɛ ba tɩyaŋ. Ɛɛ rɛ ʋ laa nyʋwa dɩ ʋ sɩ pɛ ba tɩyaŋ. Nyɛ rɛ ba kpa mʋ Hɛrɔtɩ lee, a sʋla ʋ dɩ ʋ leŋ dɩ ba beel-ʋ mɩɩgɩ marɩ dɔmɔŋ. Kuwori Hɛrɔtɩ paalʋʋ rɛ Taaya bee Siidɔŋ tɩmma kɩdiiliye fa aa lɩɩ kɩ ko. Ɛɛ rɛ tɩŋ ba gyɩ ko dɩ ba beel-ʋ mɩɩgɩ marɩ dɔmɔŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nyɛ rɛ Kuwori Hɛrɔtɩ tɩya ba kyɛɛ dɩ ba ko. Kyɛɛ hʋ aa ko pele, Kuwori Hɛrɔtɩ sii laalɩ ʋ kuwori gannɩ a lɩɩ hɔŋ ʋ kuworikpasa nyuu tɩyaŋ a basɩ wɩya kɩ tɩya nala hʋ. ");
INSERT INTO sig_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɛɛ rɛ nala hʋ buloŋ kyɩɩrɩ yʋga, a kɩ basɩ, “Nihuwobiŋ wɩbasɩɩ daa nyɛ, Wɩɩsɩ rɛ aa basɩ.” ");
INSERT INTO sig_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ba gyɩ aa basɩ gɛɛ, Kuwori Hɛrɔtɩ gyɩ bɩ basɩ tɩya ba anɩɩ ʋ bɩ yaa Wɩɩsɩ, aŋ mɩɩgɩ laa Wɩɩsɩ yohuŋ tɩya ʋ tɩɩ. Ɛɛ rɛ tɩŋ, haŋ lagɩlagɩbiye hʋ, malɩka ko tuu ŋmaa ʋ biŋ wɩɩla, kyaaŋkyʋwana gyʋʋ kpa ʋ tɩya buloŋ di ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ka Wɩɩsɩ wɩya hʋ kɛ ha marɩ taalɩ gyʋʋ kɩ mʋ lee buloŋ, nɩgyamaa nɩɩ a laa di. ");
INSERT INTO sig_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Saŋa no tɩyaŋ, dɩ Banabaasɩ bee Sɔɔl mɛ gyɩ teŋ wɩɩ hʋ ba aa ko Gyerusalɛm dɩ ba yaa rɛ. Ɛɛ rɛ ba kaŋ Gyɔɔŋ Maakɩ pɛ ba tɩyaŋ, a mɩɩgɩ mʋ Aŋtiyɔki. ");
INSERT INTO sig_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Krisitabiisi hʋ aa we Aŋtiyɔki tɩyaŋ, ba badɔmɔŋ fa yaa Wɩɩsɩ tɩŋdaala rɛ, badɔmɔŋ mɛ fa yaa nala hʋ aa daga Yesu hatɩnna hʋ. Ba fene rɛ nyɛ: Banabaasɩ abee Simiyɔŋ (Ba fa kaŋ Simiyɔŋ kɩ yɩrɩ nibiŋ nɛ), abee Lusɩya aa lɩɩ Sariini paalʋʋ, abee Sɔɔl, a yaŋ bee Meniyaŋ. (Ba paalʋʋ hʋ Kuworibal hʋ ba aa yɩrɩ Hɛrɔtɩ dɩya tɩyaŋ nɛ Meniyaŋ fa waa). ");
INSERT INTO sig_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nyɛ rɛ kyɛɛ kɩdɩgɩ, nala no sii vʋwa nyʋwa, a kɩ kyʋwalɩ Wɩɩsɩ. Ɛɛ tɩyaŋ nɛ Wɩɩsɩ Wiyesi Welii hʋ basɩ tɩya ba a baa, “Ma lɩɩ Banabaasɩ bee Sɔɔl tɩya ŋ. Ŋ lɩɩ ba rɛ dɩ ba tʋŋ ŋ tʋma tɩya ŋ.” ");
INSERT INTO sig_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nyɛ rɛ ba vʋwa nyʋwa, a kpa nosi dɔbɔ ba nyuni tɩyaŋ, a kyʋwalɩ Wɩɩsɩ tɩya ba, aŋ na ta ba ba lɩɩ ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wɩɩsɩ Wiyesi Welii hʋ aa tɩŋ Banabaasɩ bee Sɔɔl gɛɛ, ba sii kpa tuu mʋ tɔɔ kɩdɩgɩ aa sɩŋ mpʋwɔnʋʋ nyʋwa, ba kɩ yɩrɩ Selusɩya. Doŋ tɩyaŋ nɛ ba sɩŋ kpa nɩɩduworiboribal, a mʋ Saapʋrɔsɩ paalʋʋ. Nɩɩ fa gol Saapʋrɔsɩ paalʋʋ buloŋ nɛ ko baŋ kyeme. ");
INSERT INTO sig_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ɛɛ rɛ ba mʋ pele Saapʋrɔsɩ paalʋʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Salami. Doŋ tɩyaŋ, ba gyɩ gyʋʋ Gyuuma wɩɩkyʋwaldɩɩsɩ rɛ, a basɩ Wɩɩsɩ wɩya kɩ tɩya nala yʋga. Ba gyɩ kaŋ Gyɔɔŋ Maakɩ mɛ tɩŋ ba tɩyaŋ nɛ, dɩ ʋ kɩ kyiyeli ba tʋma hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nyɛ rɛ ba gɔllɩ Saapʋrɔsɩ paalʋʋ buloŋ, a mʋ pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Paafɔsɩ. Doŋ tɩyaŋ nɛ ba gyɩ na daaluliye tɩɩna kɩdɩgɩ ba aa yɩrɩ Baa-Yesu. (Ʋ feŋ hʋ memii rɛ yaa Gyoosʋwa biibaal). Ʋ fa yaa Gyuu rɛ, a gyɩ kɩ mʋrɩ nala anɩɩ ʋ yaa Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Roma nɩhɩyawʋ hʋ fa aa deŋ doŋ paalʋʋ ba kɩ yɩrɩ Sɛɛgyiyo Pawulo dɩya tɩyaŋ nɛ ʋ fa we. Sɛɛgyiyo Pawulo fa kaŋ wɩgyʋŋ nɛ weliŋ. Nyɛ rɛ ʋ yɩrɩ Banabaasɩ bee Sɔɔl dɩ ba ko ʋ dɩya. Beewɩya ʋ fa aa kyɛ dɩ ba ko basɩ Wɩɩsɩ wɩya tɩya ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ɛɛ rɛ Ɛlimasɩ, daaluliye hʋ tɩɩna, sii kpa nyʋʋtaaduwo gyʋʋ Sɔɔl ma wɩbasɩɩ hʋ tɩyaŋ, a kɩ lʋga dɩ ʋ mʋrɩ Sɛɛgyiyo Pawulo dɩ ʋ ta laa Yesu wɩya di. (Giriki taal tɩyaŋ nɛ ba fa kaŋ Baa-Yesu kɩ yɩrɩ Ɛlimasɩ). ");
INSERT INTO sig_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɛɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ ko gyʋʋ Sɔɔl tɩyaŋ. (Sɔɔl feŋdɩgɩ mɛ rɛ fa bɩl yaa Pɔɔl). Ɛɛ rɛ ʋ gɩyɛnɩ daaluliye hʋ tɩɩna, ");
INSERT INTO sig_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aŋ basɩ tɩya ʋ a baa, “Ɛɛ dɔŋ Sɩtaanɩ biye, Ɩ kɛ bɩ sɩŋ pɔ dɩ wɩwelii buloŋ yaa. Ɩ yaa gyambatɩɩna rɛ, a yaa nɩbɔmɔ buloŋ kuwori. Ɩ lʋgɩ buloŋ nɛ yaa dɩ ɩ kaŋ Wɩɩsɩ wɩtɩɩ hʋ bɩrɩmɩ kyige dɩ ʋ bɩrɩmɩ wɩnyɩyɛl. ");
INSERT INTO sig_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yaŋ kɩ gyɩma, Wɩɩsɩ sɩ ko ɩ tɩyaŋ, dɩ ɩ nyʋlɩmɩ, a maga magɩɩ kɩdɩgɩ aŋ na na pʋlʋŋ.” Pɔɔl aa basɩ nyɛ teŋ, Ɛlimasɩ pirige baa dɩ ʋ deŋ, dɩ bilhuu kɩdɩgɩ ko tɔ ʋ sɩya, ʋ nyʋlɩmɩ. Ʋ teŋ sii gɔllɩ lannɩ kɩ kyɛ nal dɩ ʋ kaŋ ʋ noŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Roma nɩhɩyawʋ hʋ aa naa wɩɩ hʋ aa yaa, ʋ sɩŋ doŋ laa Yesu wɩya di. Beewɩya, á Tɩɩna Yesu Krisita wɩya hʋ buloŋ ba aa basa fa yaa ʋ nyʋʋfɩyɛlɩ lɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nyɛ rɛ Pɔɔl bee ʋ hatɩnna hʋ sii gyʋʋ nɩɩduworiboribal, a lɩɩ Paafɔsɩ tɩyaŋ, a kpa mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Pɛɛga, a we Pamfilɩya paalʋʋ tɩyaŋ. Doŋ nɛ Gyɔɔŋ Maakɩ kɛ ta ba, aŋ mɩɩgɩ mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba mɛ sii doŋ, a kpa mʋ Aŋtiyɔki aa we Pisidɩya paalʋʋ tɩyaŋ. Kyɛwiyesii hʋ kyɛɛ ko baŋ pele, ba sii mʋ Gyuuma wɩɩkyʋwaldɩya. ");
INSERT INTO sig_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ɛɛ rɛ nal kɩdɩgɩ sii karɩmɩ Wɩɩsɩ Teŋ, a lɩɩ mɩrɩsɩ hʋ Moosi fa aa saba biŋ dɩ ba kɩ tɩŋa tɩyaŋ, abee Wɩɩsɩ tɩŋdaala fa aa saba tenni hʋ tɩyaŋ. Ʋ aa karɩmɩ wɩya no ko teŋ, wɩɩkyʋwaldɩya hʋ nɩhɩyasɩ tɩma dɩ ba mʋ basɩ tɩya Pɔɔl ma a baa, “Á nɩmmabalɩya, dɩ mamaa rɛ kaŋ wɩɩ ma aa kyɛ dɩ ma basɩ tɩya nala hʋ, dɩ ba tenni marɩ polli, ma sɩ wuwo sii basɩ.” ");
INSERT INTO sig_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ɛɛ rɛ Pɔɔl sii sɩŋ, a kaŋ ʋ nosi viri dɩ ba leŋ kyagɩŋsɩ, aŋ yaŋ piili kɩ basɩ, “Ŋ kuwobalɩya Iziral tɩmma, abee nala hʋ aa bɩ yaa Gyuuma, aŋ we daha a yaa wɩɩkyʋwalla, ma buloŋ gyegili nɩɩ daha. ");
INSERT INTO sig_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wɩɩsɩ hʋ ámaa Iziral tɩmma aa kyʋwalɩ, ʋ rɛ lɩɩ á naabaala, a leŋ ba wala, a yaa paalʋʋ piliŋ nala, saŋa hʋ ba gyɩ aa yaa nɩhʋwala Igyipiti paalʋʋ tɩyaŋ. Ʋ dee tɩyaŋ nɛ ʋ kaŋ ba lɩɩ Igyipiti paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ʋ gyɩ deŋ ba rɛ abee kenyiri bɩsɩ mɔllɩbalɩya pogo tʋtʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ʋ gyɩ leŋ ba yuwo laa paalʋʋbala bapɛ rɛ Keenaŋ paalʋʋ tɩyaŋ, ba bɩrɩmɩ ba kɩna. Wɩya no buloŋ gyɩ yaa rɛ bɩsɩ kɔɔsɩbanaa abee mɔllɩbalɩya bee fi paga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ba gyɩ aa hɔŋ doŋ tɩyaŋ, Wɩɩsɩ gyɩ aa lɩɩ sɩlaala rɛ, ba kɩ deŋ ba abee ba paalʋʋ hʋ. Ɛɛ rɛ ʋ yaa gɛɛ, a mʋ pele saŋa hʋ Wɩɩsɩ tɩŋdaal Samuwɛl aa ko we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ɛɛ rɛ ba sʋla Wɩɩsɩ dɩ ʋ lɩɩ kuworibal tɩya ba. Nyɛ rɛ Wɩɩsɩ laa nyʋwa, a lɩɩ Sɔɔl tɩya ba dɩ ʋ yaa ba kuworibal. Sɔɔl fa yaa Kisi biibaal lɛ, a lɩɩ Bɛngyamin bekyigi nala tɩyaŋ. Ʋ gyɩ dii koro hʋ rɛ bɩsɩ mɔllɩbalɩya. ");
INSERT INTO sig_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ɛɛ hal tɩyaŋ nɛ Wɩɩsɩ wuri koro hʋ, aŋ mɩɩgɩ leŋ Deviti di. Nyɛ rɛ Wɩɩsɩ gyɩ basɩ Deviti wɩya. Ʋ baa, ‘Gyesi biibaal Deviti rɛ yaa ŋ teŋfɩyɛl nal. Ʋ rɛ sɩ yaa wɩɩ hʋ kɛ buloŋ ŋ aa kyɛ dɩ ʋ yaa.’ ");
INSERT INTO sig_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Deviti doho nala tɩyaŋ nɛ Yesu mɛ lɩɩ. Wɩɩsɩ rɛ leŋ ʋ ko yaa Iziral tɩmma laataal, anɩɩ ʋ fa aa wee nyʋwa gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka dɩ Yesu mɛ na ko, Gyɔɔŋ fa basɩ Wɩɩsɩ wɩya tɩya Iziral tɩmma buloŋ nɛ. Ʋ basɩ tɩya ba rɛ dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ ka dɩ ʋ fo ba wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Gyɔɔŋ tʋma aa ko kpaga tenii, ʋ pɩyɛsɩ nala hʋ rɛ a baa, ‘Kɩbee rɛ ma bɩɩnɩ dɩ ŋ yaa? Ŋ daa yaa nal hʋ ma aa gyegili dɩ ʋ ko hʋ. Ʋ rɛ sɩ tɩŋ ŋ hal ko. Ŋ mɛ gba paalɩ bɩ maga dɩ ŋ kaŋ haŋ nal hʋ naatɔbɔ ŋmasɩ mɛ gba puri!’ ");
INSERT INTO sig_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ŋ naabalɩya, Abɩraham doho nala abee ma nala hʋ aa bɩ yaa Gyuuma aŋ kɩ kyʋwalɩ Wɩɩsɩ, ámaa rɛ ba basɩ wɩya hʋ aa daga ɛɛ hʋ Wɩɩsɩ aa sɩ laa ma ta, a tɩya gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yesu aa ko, nala hʋ aa we Gyerusalɛm tɩyaŋ abee ba nɩhɩyasɩ buloŋ fa bɩ gyɩma anɩɩ ʋ rɛ yaa á laataal hʋ. Ba mɛ fa bɩ gyɩŋ Wɩɩsɩ tɩŋdaala hʋ wɩbasɩɩ memii, abee wɩya hʋ ba fa aa kɩ karɩmɩ Kyɛwiyesii kyɛɛ buloŋ. Ɛɛ rɛ tɩŋ ba kpʋ Yesu, a leŋ Wɩɩsɩ tɩŋdaala wɩbasɩya hʋ ko yaa wɩtɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba paalɩ bɩ naa wɩɩ buloŋ ʋ aa yaa kyogi, a fa maga dɩ ba kpʋ ʋ, ka ba vɩya, aŋ sʋla Pilato dɩ ʋ leŋ dɩ ba kpʋ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wɩya hʋ buloŋ ba aa saba Wɩɩsɩ teŋ tɩyaŋ anɩɩ ba sɩ yaa Yesu, ba buloŋ nɛ ba yaa ʋ. Ɛɛ hal tɩyaŋ, ba yaŋ lallɩ ʋ daagarɩɩ hʋ tɩyaŋ, a kana ʋ mʋ hogo. ");
INSERT INTO sig_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amɛ Wɩɩsɩ gyɩ kyisi ʋ rɛ sʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ʋ aa sii sʋʋ tɩyaŋ mɛ, ʋ kana ʋ tɩɩ ko daga nala hʋ fa aa tɩŋa ʋ tɩyaŋ a lɩɩ Galili mʋ Gyerusalɛm nɛ kyɛgyamaa. Lagɩlagɩ no, ba aa rɛ yaa ʋ daŋsɩya tɩmma, a basɩ ʋ wɩya kɩ tɩya Iziral tɩmma. ");
INSERT INTO sig_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Á mɛ ko daha rɛ dɩ á basɩ Wɩɩsɩ wɩweliye hʋ tɩya ma. Wɩɩ hʋ Wɩɩsɩ aa wee nyʋwa tɩya á naabaala dɩ ʋ sɩ yaa, ");
INSERT INTO sig_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nyɛ kɛ, ʋ yaa tɩya ma rɛ, á nala hʋ aa yaa ba doho nala, akuu ʋ aa kyisi Yesu sʋʋ tɩyaŋ wɩya. Ba saba gɛɛ wɩya Wɩɩsɩ Teŋ logiŋ kɩdɩgɩ ba aa yɩrɩ Yɩɩla tɩyaŋ nɛ. Yɩɩla teŋ no tɩyaŋ, ba sabɩ Yesu wɩya rɛ a baa, ‘I yaa ŋ biibaal lɛ, Mɩyaŋ nɛ yaa ɩ kuwo gyɩnaŋ.’ ");
INSERT INTO sig_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wɩɩsɩ Teŋ lee kɩdɩgɩ tɩyaŋ, Wɩɩsɩ bɩl basɩ ɛɛ hʋ ʋ aa sɩ kyisi Yesu sʋʋ tɩyaŋ nɛ, a ta leŋ dɩ ʋ pʋw bʋwa tɩyaŋ, a baa, ‘Ŋ kɔnɩ sɩ pɛ ma weliŋ anɩɩ ŋ fa aa wee nyʋwa tɩya Deviti gɛɛ.’ ");
INSERT INTO sig_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Logiŋ dɩgɩ tɩyaŋ mɛ bɩla, ba bɩl saba rɛ, a baa, ‘I bɩ sɩ leŋ dɩ Ɩ Tɩpʋlʋŋ Tɩɩna sʋba a pʋw bʋwa tɩyaŋ.’ ");
INSERT INTO sig_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Deviti fa tɩŋ Wɩɩsɩ kyɛrɩ rɛ ʋ mɩɩbol buloŋ tɩyaŋ, aŋ ko sʋba. Ba kpa ʋ hogo pɛ ʋ naabaala tɩyaŋ, ʋ pʋwa. ");
INSERT INTO sig_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amɛ nal hʋ kɛ Wɩɩsɩ aa kyise sʋʋ tɩyaŋ, ʋ bɩ pʋw bʋwa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ŋ naabalɩya, á aa kyɛ dɩ ma gyɩma weliŋ nɛ anɩɩ baal no lahɔrʋmɔ tɩyaŋ nɛ á wuwo gyɩŋ ɛɛ hʋ Wɩɩsɩ aa kpa wɩbɔmɔ kɩ kyɛ nala, á mɛ wuwo basɩ kɩ tɩya ma nyɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nal hʋ buloŋ aa laa ʋ wɩya di, ʋ laa ʋ tɩɩna ta ʋ wɩbɔmɔ buloŋ tɩyaŋ nɛ, a leŋ ʋ yaa tɩpʋlʋŋ tɩɩna Wɩɩsɩ sɩya tɩyaŋ. Amɛ mɩrɩsɩ hʋ buloŋ Moosi fa aa saba biŋ dɩ nala kɩ tɩŋa kɛ fa bɩ wuwo laa ma kɩ ta ma wɩbɔmɔ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ma fɩyɛlɩ ma sɩya weliŋ, dɩ wɩya hʋ Wɩɩsɩ tɩŋdaala fa aa basa ta ko di ma. Ba baa, ");
INSERT INTO sig_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ma nala hʋ aa mʋŋ Wɩɩsɩ, ma kɩ gyɩma weliŋ. Wɩɩ hʋ ŋ aa sɩ yaa ma mɩɩbol tɩyaŋ, ma bɩ sɩ laa di, haalɩ dɩ nal mɛ rɛ fa basɩ tɩya ma mɛ, ka ma bee gyɩma ʋ sɩɩ. Amɛ ʋ sɩ yaa ma wɩkperii a leŋ dɩ ma sʋba.”’ ");
INSERT INTO sig_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔɔl bee Banabaasɩ aa basɩ wɩya no buloŋ teŋ, ba sii dɩ ba lɩɩ wɩɩkyʋwaldɩya hʋ tɩyaŋ. Ɛɛ rɛ nala hʋ sʋl ba dɩ ba bɩl mɩɩgɩ ko kyɛwiyesii no aa ko kyɛɛ, a bɩl marɩ basɩ wɩya no tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nala hʋ buloŋ aa ko lɩɩ wɩɩkyʋwaldɩya hʋ tɩyaŋ, ɛɛ rɛ Gyuuma abee nala hʋ buloŋ aa bɩ yaa Gyuuma, aŋ kɩ kyʋwalɩ Gyuuma Wɩɩsɩ sii giri tɩŋ Pɔɔl bee Banabaasɩ hal. Doŋ tɩyaŋ nɛ Pɔɔl bee Banabaasɩ basɩ wɩya yʋga a tɩya ba, aŋ kpaanɩ ba dɩ ba kpa ba wɩɩ buloŋ tɩya Wɩɩsɩ aŋ yelli Wɩɩsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ʋ hal kyɛwiyesii hʋ kyɛɛ bɩl aa pele, bee hʋ nala gyeniŋ buloŋ nɛ gyɩ sii mʋ wɩɩkyʋwaldɩya hʋ dɩ ba nɩɩ Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Amɛ Gyuuma hʋ fa aa naa nɩgyamaa hʋ laŋŋa yʋga gɛɛ, ba tɩsɩ kɩ hɔllɩ. Ɛɛ rɛ ba sii kpa nyʋʋtaaduwo kyeŋ Pɔɔl, aŋ kɩ tʋʋsɩ ʋ, a kɩ kyogi ʋ feŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ka Pɔɔl bee Banabaasɩ kɛ yeŋŋi ba wɩya, aŋ marɩ basɩ wɩya abee nyuduwo a baa, “Ʋ fa maga dɩ ba laa sɩya basɩ Wɩɩsɩ wɩya tɩya mamaa Gyuuma rɛ, amɛ ma bɩ laa di, aŋ baa dɩ ba yaa wɩnyɩyɛl lɛ. Nyɛ tɩyaŋ, ma daga anɩɩ ma bɩ maga dɩ ma kaŋ mɩɩbol aa bɩ kaŋ tenii rɛ gɛɛ. Ɛɛwɩya, á sɩ leŋ ma aŋ mʋ nala hʋ aa bɩ yaa Gyuuma lee. ");
INSERT INTO sig_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Beewɩya, Wɩɩsɩ basɩ tɩya ma Wɩɩsɩ Teŋ logiŋ kɩdɩgɩ tɩyaŋ nɛ anɩɩ gɛɛ rɛ á sɩ yaa. Ʋ baa, ‘Mɩyaŋ nɛ lɩɩ ma dɩ ma yaa nala hʋ aa bɩ yaa Gyuuma kyaanʋʋ, a daga ba ŋmanɩɩ hʋ ŋ aa sɩ tɩŋa a laa dʋnɩya nala buloŋ mɩɩbol ta.”’ ");
INSERT INTO sig_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nala hʋ aa bɩ yaa Gyuuma aa nɩɩ wɩɩ no, ba tenni buloŋ fɩyɛlɩ, ba kɩ dannɩ Wɩɩsɩ abee wɩya hʋ ba aa nɩya. Nala hʋ mɛ Wɩɩsɩ aa lɩya dɩ ba kaŋ mɩɩbol hʋ aa bɩ kaŋ tenii, ba mɛ laa wɩya no di rɛ. ");
INSERT INTO sig_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ɛɛ rɛ ka nɩgyamaa nɩɩ á Tɩɩna Yesu wɩya haŋ paalʋʋ hʋ tɩyaŋ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amɛ Gyuuma hʋ sii mʋrɩ bee hʋ nɩhɩyasɩ abee habiibala hʋ aa kyʋwalɩ Wɩɩsɩ doŋ tɩyaŋ. Ba bee Gyuuma hʋ piili kɩ dɔgɩsɩ Pɔɔl abee Banabaasɩ, aŋ leŋ ba kil ba ta ba paalʋʋ hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔɔl bee Banabaasɩ piisi ba naasɩ taŋha ta, aŋ lɩɩ kpa mʋ Ikoniya. Ba aa piisi ba naasɩ taŋha ta hʋ daga anɩɩ bee hʋ nala yaa wɩɩ kyogi ba rɛ, ɛɛ wɩya, ba beel-ba bɩl bɩ pɛɛ wɩɩ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ka Krisitabiisi aa we Aŋtiyɔki tɩyaŋ kɛ tenni buloŋ fɩyɛlɩ. Wɩɩsɩ Wiyesi Welii hʋ mɛ we ba tɩyaŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniya tɩyaŋ mɛ, Pɔɔl bee Banabaasɩ gyɩ bɩl sii mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya rɛ, a kɩ basɩ Wɩɩsɩ wɩya. Ɛɛ hʋ ba aa basɩ Wɩɩsɩ wɩya doŋ tɩyaŋ leŋ nɩgyamaa ko laa Yesu wɩya di, Gyuuma abee Giriisi tɩmma buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amɛ Gyuuma hʋ aa bɩ laa Yesu wɩya di sii turo nala hʋ aa bɩ yaa Gyuuma we, ba baaŋ kɩ sii Yesu hatɩnna hʋ buloŋ aa we doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔl bee Banabaasɩ gyɩ hɔŋ doŋ tɩyaŋ pɩɩsɩ rɛ weliŋ, a kɩ basɩ á Tɩɩna Yesu wɩya abee nyuduwo saŋa buloŋ. Ɛɛ rɛ Yesu mɛ pɛ ba tɩyaŋ, a tɩya ba dee ba wuwo kɩ yaa wɩmagɩla abee wɩkperiye. Wɩya no rɛ leŋ nala hʋ ko gyɩma anɩɩ á Tɩɩna bɔnyɛ hʋ wɩya ba aa basɩ kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Doŋ tɩyaŋ nɛ nyʋʋtaaduwo gyʋʋ bee hʋ nala, ba porigi leye balɩya. Badɔmɔŋ sɩŋ Gyuuma hʋ hal, ka badɔmɔŋ mɛ sɩŋ Yesu kpambɩsɩ hʋ hal. ");
INSERT INTO sig_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɛɛ rɛ nala hʋ aa bɩ yaa Gyuuma abee Gyuuma abee ba bee nɩhɩyasɩ sii yaa nyʋʋdɩgɩ dɩ ba dɔgɩsɩ Pɔɔl bee Banabaasɩ, aŋ yaga ba bee bʋwa. ");
INSERT INTO sig_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Amɛ Pɔɔl bee Banabaasɩ aa ko gyɩŋ wɩɩ no tɩyaŋ, ba sii lɩɩ fá a mʋ Liisira, a lɩɩ doŋ kpa mʋ Dɛɛbi. Liisira bee Dɛɛbi buloŋ fa yaa tɔbala rɛ a we Lakooniya paalʋʋ tɩyaŋ. Ɛɛ hal tɩyaŋ ba gɔllɩ mʋ tɔnɩ hʋ buloŋ aa golo doŋ paalʋʋ, ");
INSERT INTO sig_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","a basɩ á Tɩɩna Yesu Krisita wɩya doŋ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ba gyɩ aa mʋʋ Lisitira gɛɛ, dɩ gbarɩgɩ kɩdɩgɩ we doŋ. Ba gyɩ lʋla ʋ bee gbarɩgɩsɩ rɛ. Ɛɛ wɩya ʋ ha bɩ maakyiye vala na. ");
INSERT INTO sig_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ʋ mɛ gyɩ hɔŋ gyamaa hʋ tɩyaŋ nɛ, a kɩ gyegili wɩya hʋ Pɔɔl gyɩ aa basɩ. Ɛɛ rɛ Pɔɔl deŋ ʋ gɛɛ sɩrɩtɩtɩ, a na dɩ gbarɩgɩ hʋ laa di ʋ tɩya tɩyaŋ anɩɩ Yesu rɛ sɩ wuwo tɩɩbɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ɛɛ rɛ ʋ faasɩ basɩ tɩya ʋ a baa, “Sii sɩŋ ɩ naasɩ tɩyaŋ.” Ʋ teŋ nyagɩ sii sɩŋ ʋ naasɩ tɩyaŋ, a kɩ vala. ");
INSERT INTO sig_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gyamaa hʋ buloŋ fa aa laŋŋa aa na wɩɩ hʋ Pɔɔl aa yaa, ba piili kɩ yaa kyagɩŋsɩ a kɩ basɩ bee ba taal tɩyaŋ a baa, “Á tɔdʋnnɩ hʋ rɛ bɩrɩmɩ nihuwobisi a ko á lee.” ");
INSERT INTO sig_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɛɛ rɛ ba baa dɩ Banabaasɩ rɛ yaa Zeeyosi, ka Pɔɔl mɛ yaa Hɛɛmɩsɩ. (Zeeyosi rɛ fa yaa ba paalʋʋ buloŋ tɔdʋŋbal, ka Hɛɛmɩsɩ mɛ yaa tɔdʋŋbal no tɩŋdaal, aa laa ʋ wɩya buloŋ basɩ kɩ tɩya ʋ). Pɔɔl fa aa basɩ wɩya hʋ buloŋ nɛ tɩŋ ba baa dɩ ʋ rɛ yaa Hɛɛmɩsɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeeyosi toŋo fa sɩŋ bee hʋ samanɩ tɩyaŋ nɛ, ba aa mʋ kɩ marɩ. Nyɛ rɛ toŋo hʋ tɩɩna sii kaŋ nɔbolli abee tɩɩfɩɩla a kaŋ ko Zeeyosi vʋgɩmarɩ dɩya hʋ dimbeenyʋwa. Doŋ nɛ bee hʋ nala buloŋ laŋŋɩ, a kɩ kyɛ dɩ ba marɩ vʋga no tɩya Pɔɔl bee Banabaasɩ. ");
INSERT INTO sig_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Banabaasɩ bee Pɔɔl aa ko nɩɩ wɩɩ hʋ ba aa kyɛ dɩ ba yaa, ba kaŋ ba tɩɩ gannɩ kɩyɛsɩ, (Ba aa kaŋ ba gannɩ kɩyɛsɩ hʋ daga anɩɩ ba bɩ laa nyʋwa dɩ ba yaa wɩɩ hʋ ba aa kyɛ dɩ ba yaa), aŋ fá gyʋʋ nala hʋ tɩyaŋ a heeli kɩ basɩ, ");
INSERT INTO sig_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Á kyaŋsɩ, bee rɛ tɩŋ ma kɩ yaa nyɛ? Á mɛ yaa nihuwobisi rɛ anɩɩ ma kɩdɩgɩ buloŋ aa we daha, á bɩ yaa tɔdʋnnɩ. Á ko dɩ á basɩ á Tɩɩna Yesu wɩweliye hʋ rɛ tɩya ma, dɩ ma wuwo leŋ ma tɔdʋnnɩ abee ma vʋga no marɩɩ ta aŋ mɩɩgɩ tɩŋ Wɩɩsɩ hʋ aa weye, beewɩya vʋga marɩɩ bɩ kaŋ tɔnɔ buloŋ. Ʋ rɛ taa wɩɩsɩnyuu abee taŋha nyuu, fuwoni abee kɩŋ kɛ buloŋ aa we dʋnɩya tɩyaŋ daha. ");
INSERT INTO sig_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Faafaa hʋ tɩyaŋ, Wɩɩsɩ fa leŋ á naabaala ta rɛ ba kɩ tɩŋ ba tɩɩ ŋmaŋsɩ. ");
INSERT INTO sig_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Abee gɛɛ buloŋ, ʋ ha fa leŋ nala gyɩŋ haŋ Wɩɩsɩ hʋ iriŋ ʋ aa yaa rɛ, a kuu wɩweliye hʋ ʋ aa yaa kɩ tɩya ba tɩyaŋ. Ʋ aa leŋ duwoŋ kɩ nɩɩ rɛ, a leŋ baga kɩna marɩ ba saŋa tɩyaŋ, ma na kɩdiiliye a di kɩ vɔgɔ, aŋ leŋ ma buloŋ kaŋ teŋfɩyɛlʋʋ.” ");
INSERT INTO sig_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Banabaasɩ bee Pɔɔl gyɩ basɩ wɩya no buloŋ nɛ, ka nala hʋ ha vɩya aŋ kɩ kyɛ dɩ ba marɩ ba vʋga hʋ tɩya ba. Ɛɛ rɛ Pɔɔl bee Banabaasɩ sʋl ba abee sɩfɩyasɩ, ka ba na ko leŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nyɛ rɛ dɩ Gyuuma badɔmɔŋ mɛ lɩɩ Aŋtiyɔki aa we Pisidɩya paalʋʋ tɩyaŋ a ko Lisitira, badɔmɔŋ mɛ lɩɩ Ikoniya a ko. Nyɛ rɛ ba ko mʋrɩ nɩgyamaa we, ba sii pɛ ba tɩyaŋ, ba paa bʋwa yaga Pɔɔl ʋ yiyegi. Ɛɛ rɛ ba kana ʋ tuuri lɩɩ ta ba bee hʋ samanɩ tɩyaŋ, beewɩya, ba kɛ fa liise anɩɩ ʋ sʋba rɛ. ");
INSERT INTO sig_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ɛɛ tɩyaŋ nɛ Yesu hatɩnna hʋ aa we doŋ sii mʋ sɩŋ gol ʋ. Doŋ nɛ ʋ sii, ba mɩɩgɩ gyʋʋ dɩya. A sii ʋ sɩgballɩya, ʋ bee Banabaasɩ kpa mʋ Dɛɛbi. ");
INSERT INTO sig_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔɔl bee Banabaasɩ gyɩ basɩ Yesu wɩweliye hʋ Dɛɛbi tɩyaŋ mɛ rɛ. Ba wɩbasɩɩ hʋ tɩyaŋ nala yʋga gyɩ ko laa Yesu wɩya di rɛ, aŋ bɩrɩmɩ ʋ hatɩnna. Doŋ tɩyaŋ nɛ ba sɩŋ, a mɩɩgɩ paa ba naabʋʋsɩ, a mʋ Lisitira, a sii doŋ a bɩl kpa mʋ Ikoniya, a bɩl lɩɩ doŋ mɛ a mɩɩgɩ mʋ Aŋtiyɔki hʋ aa we Pisidɩya paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Leye no buloŋ nɛ ba pele, a basɩ Wɩɩsɩ wɩya tɩya nala hʋ aa laa Yesu wɩya di dɩ ba leŋ dɩ ba laadii yʋga, a leŋ dɩ ba tenni polli dɩ ba wuwo kaŋ kenyiri abee Yesu Krisita tɩŋɩɩ tɩyaŋ, aŋ ta ko kpa ta. Ba basɩ tɩya ba rɛ anɩɩ á nala hʋ aa laa Yesu wɩya di sɩ na tʋwara rɛ kɩŋkaŋ, ka dɩ á na gyʋʋ Wɩɩsɩ koro hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tɔɔ hʋ kɛ buloŋ tɩyaŋ nala aa laa Yesu wɩya di aŋ aa kɩ laŋŋɩ, ba gyɩ aa lɩɩ nala rɛ ba tɩyaŋ dɩ ba yaa ba sɩlaala. Dɩ ba gyɩ ko lɩɩ sɩlaala buloŋ, ba aa vʋwa nyʋwa rɛ, a kyʋwalɩ Wɩɩsɩ tɩya ba, aŋ kpa ba we á Tɩɩna Yesu nosi tɩyaŋ. Beewɩya, á Tɩɩna Yesu rɛ ba yelli wɩɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nyɛ rɛ ba gɔllɩ Pisidɩya paalʋʋ buloŋ teŋ aŋ bɩl kpa mʋ Pamfilɩya paalʋʋ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pamfilɩya paalʋʋ tɩyaŋ, Pɛɛga rɛ ba laa sɩya mʋ, a basɩ Wɩɩsɩ wɩya doŋ. A bɩl lɩɩ doŋ mɛ a kpa tuu mʋ Atalɩya. ");
INSERT INTO sig_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Doŋ tɩyaŋ nɛ ba sɩŋ kpa nɩɩduworiboribal, a mɩɩgɩ mʋ Aŋtiyɔki. Beewɩya Aŋtiyɔki tɩyaŋ nɛ ba fa kpa ba we Wɩɩsɩ nosi tɩyaŋ dɩ ʋ pɛ ba tɩyaŋ dɩ ba wuwo tʋŋ Wɩɩsɩ tʋma hʋ. Wɩɩsɩ dee tɩyaŋ mɛ yaŋ, tʋma hʋ ba aa lɩɩ ba dɩ ba tʋma, ba wuwo na ba sɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba aa mɩɩgɩ ko Aŋtiyɔki, ba yɩrɩ nala hʋ buloŋ aa laa Yesu wɩya di a ko laŋŋɩ, a kpa wɩweliye hʋ buloŋ Wɩɩsɩ aa leŋ ba wuwo yaa a basɩ tɩya ba, a bɩl basɩ tɩya ba ɛɛ Wɩɩsɩ aa suri ŋmanɩɩ tɩya nala hʋ aa bɩ yaa Gyuuma mɛ, ba mɛ laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɛɛ rɛ ka Pɔɔl bee Banabaasɩ hɔŋ Aŋtiyɔki tɩyaŋ, ba bee nala hʋ aa laa Yesu wɩya di we doŋ peŋgyamaa. ");
INSERT INTO sig_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Baala badɔmɔŋ mɛ rɛ gyɩ lɩɩ Gyudɩya paalʋʋ ko Aŋtiyɔki, a piili kɩ daga nala hʋ aa laa Yesu wɩya di a baa, “Wɩɩsɩ bɩ sɩ wuwo laa ma ta, see dɩ ma keri ma pene anɩɩ Moosi gyɩ aa biŋ mɩra hʋ tɩya ma gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nyɛ rɛ wɩɩ no kaŋ nyʋʋtaaduwo ko ba bee Pɔɔl abee Banabaasɩ paga. Ba buloŋ hɔŋ kaŋ wɩɩ hʋ kɩ kpa dɔmɔŋ. Nyɛ rɛ ba vʋʋlɩ lɩɩ Pɔɔl abee Banabaasɩ abee Krisitabiisi hʋ badɔmɔŋ aa we Aŋtiyɔki tɩyaŋ, dɩ ba kaŋ wɩɩ hʋ mʋ Gyerusalɛm, a na sɩlaala hʋ abee Yesu kpambɩsɩ hʋ aa we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɛɛ rɛ Krisitabiisi hʋ aa we Aŋtiyɔki tɩyaŋ sii ta ba, ba mʋ. Ba aa mʋʋ hʋ tɩyaŋ, ba gyɩ tɩŋ Fɔniisɩya abee Samaarɩya paalʋʋ rɛ, a basɩ tɩya Krisitabiisi hʋ aa we doŋ, ɛɛ hʋ nala hʋ aa bɩ yaa Gyuuma mɛ aa ko laa Wɩɩsɩ wɩya di, a kɩ tɩŋ Yesu Krisita. Nala hʋ gyɩ aa nɩɩ wɩya no, ba tenni buloŋ gyɩ fɩyɛla rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba aa mʋʋ pele Gyerusalɛm, Yesu kpambɩsɩ hʋ abee Krisitabiisi hʋ buloŋ aa we doŋ, abee ba sɩlaala buloŋ, lɔllɩ ba, aŋ kaŋ ba nɩhɔrɩ weliŋ. Ɛɛ tɩyaŋ nɛ, ka ba mɛ basɩ wɩya hʋ buloŋ Wɩɩsɩ aa leŋ ba wuwo yaa, a tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amɛ nala badɔmɔŋ fa we doŋ, a fa yaa Farasiima aŋ na ko laa Yesu wɩya di. Nyɛ rɛ nala no mɛ sii sɩŋ a basɩ tɩya ba a baa, “Nala hʋ buloŋ aa bɩ yaa Gyuuma, aŋ laa Yesu wɩya di, ʋ maga dɩ ba keri ba pene rɛ, aŋ kɩ tɩŋ wɩya hʋ Moosi fa aa bine dɩ á kɩ tɩŋa hʋ.” ");
INSERT INTO sig_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yesu kpambɩsɩ hʋ bee Krisitabiisi nɩhɩyasɩ bɩl laŋŋɩ dɩ ba vʋʋlɩ kyɛ wɩɩ no sii. ");
INSERT INTO sig_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba gyɩ hɔŋ kaŋ wɩɩ hʋ tarɩ pɩɩsɩ rɛ weliŋ. Ɛɛ rɛ Piita sii sɩŋ aŋ baa, “Ŋ naabalɩya, ma gyɩma anɩɩ faafaa buloŋ nɛ Wɩɩsɩ lɩɩ ŋ ma tɩyaŋ, dɩ ŋ mʋ basɩ Wɩɩsɩ wɩweliye hʋ a kɩ tɩya nala hʋ aa bɩ yaa Gyuuma dɩ ba mɛ wuwo nɩɩ, a ko laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wɩɩsɩ gyɩŋ nihuwobiŋ buloŋ tɩya rɛ. Ɛɛ rɛ Wɩɩsɩ kpa ʋ Wiyesi Welii hʋ we ba tɩyaŋ anɩɩ ʋ fa aa kpaa we á tɩyaŋ gɛɛ. Ɛɛ daga anɩɩ Wɩɩsɩ laa ba mɛ ta rɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ʋ bɩ kaŋ á nala hʋ aa yaa Gyuuma abee nala hʋ aa bɩ yaa Gyuuma kɩ porigi. Nala hʋ mɛ aa bɩ yaa Gyuuma mɛ laa Yesu wɩya di rɛ, ɛɛ rɛ tɩŋ Wɩɩsɩ kpa ba wɩbɔmɔ mɛ kyɛ ba gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bee rɛ tɩŋ ma kpa kyʋgɩbal no a kɩ kyʋgɩ nala hʋ aa bɩ yaa Gyuuma aŋ laa Yesu wɩya di. Wɩɩsɩ daa ma kɩ magɩsɩ gɛɛ? Beewɩya, á bee á naabaala buloŋ fa bɩ wuwo kyʋŋ kyʋga no. ");
INSERT INTO sig_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ŋmanɩɩ tuwo dɩ ma yaa gɛɛ! Á laa di rɛ anɩɩ á Tɩɩna Yesu dʋŋ lahɔrʋmɔ tɩyaŋ nɛ Wɩɩsɩ sɩ laa á buloŋ ta anɩɩ ʋ aa laa ba ta gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piita aa basɩ gɛɛ ko teŋ, nala hʋ buloŋ fa aa laŋŋa doŋ yaa sɩrɩtɩtɩ, aŋ kɩ gyegili wɩya hʋ Banabaasɩ bee Pɔɔl mɛ aa basɩ. Ɛɛ rɛ ba mɛ kpa wɩmagɩla hʋ bee wɩkperiye hʋ buloŋ Wɩɩsɩ aa leŋ ba wuwo yaa nala hʋ aa bɩ yaa Gyuuma tɩyaŋ, a basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba aa basɩ wɩya no buloŋ ko teŋ, Gyemsi mɛ sii sɩŋ a baa, “Ŋ naabalɩya, ma gyegili nɩɩ daha. ");
INSERT INTO sig_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siimɔŋ Piita ha yaŋ basɩ tɩya ma rɛ ɛɛ hʋ Wɩɩsɩ aa laa sɩya kyo nala hʋ aa bɩ yaa Gyuuma, a lɩɩ nala ba tɩyaŋ dɩ ba yaa ʋ nala. ");
INSERT INTO sig_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wɩɩsɩ tɩŋdaala mɛ fa laa sɩya basɩ wɩɩ no rɛ Wɩɩsɩ teŋ tɩyaŋ. Ba baa dɩ Wɩɩsɩ basɩ baa, ");
INSERT INTO sig_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nyɛ hal tɩyaŋ, ŋ sɩ mɩɩgɩ ko saa Deviti dɩya hʋ aa tele. Ŋ sɩ marɩ saa ʋ dɩ ʋ sɩŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ŋ sɩ yaa gɛɛ dɩ dʋnɩya nɩkaalɩya mɛ ko kyɛ Wɩɩsɩ a kɩ tɩŋa ʋ. Nala hʋ mɛ ŋ aa lɩya, nala hʋ aa bɩ yaa Gyuuma tɩyaŋ dɩ ba yaa ŋ nala ba mɛ sɩ ko kyɛ ŋ a tɩŋa ŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Faafaa buloŋ nɛ Wɩɩsɩ basɩ wɩɩ no dɩ nala gyɩma.’ ");
INSERT INTO sig_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ɛɛ rɛ Gyemsi bɩl basɩ baa, Ɛɛwɩya, ŋ kɛ aa naa wɩɩ rɛ nyɛ: Ʋ bɩ maga dɩ á kɩ dɔŋ nala hʋ aa bɩ yaa Gyuuma aŋ mɩɩgɩ ko kɩ tɩŋ Wɩɩsɩ ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amɛ ma leŋ dɩ á sabɩ teŋ tɩya ba, a basɩ tɩya ba dɩ ba ta bɩl kɩ dii vʋga kɩna, ka dɩ ba leŋ sɔŋsɔŋ, aŋ ta kɩ kyaŋ kɩŋ aa sʋba pimmiliŋ, a ta kɩ kyaŋ pʋsɩ kyal mɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Beewɩya wɩya hʋ buloŋ Moosi fa aa bine dɩ á kɩ tɩŋa a ta kaŋ bisiŋ, ba aa rɛ ba kpa daga ma faafaa buloŋ, a kaŋ kɩ ko gyɩnaŋ. Wɩya no mɛ buloŋ nɛ ba yaŋ aa karɩmɩ wɩɩkyʋwaldɩɩsɩ tɩyaŋ kyɛwiyesii hʋ kyɛɛ kɛ buloŋ tɔɔ tɔɔ buloŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nyɛ rɛ Yesu kpambɩsɩ hʋ abee nɩhɩyasɩ hʋ abee Krisitabiisi hʋ aa we Gyerusalɛm tɩyaŋ, ba buloŋ gyɩ vʋʋla rɛ a lɩɩ nala ba tɩyaŋ, a tɩŋ ba dɩ ba bee Pɔɔl abee Banabaasɩ mʋ Aŋtiyɔki. Ba gyɩ lɩɩ Gyudasɩ rɛ (ʋ feŋ dɩgɩ mɛ rɛ fa yaa Basabaasɩ) abee Silaasi. Baala no balɩya mɛ fa yaa sɩlaala rɛ Krisitabiisi hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba kpa teŋ hʋ tɩŋ ba. Nyɛ rɛ ba gyɩ sabɩ we teŋ hʋ tɩyaŋ, “Ma nɩmmabalɩya Yesu kpambɩsɩ abee Krisitabiisi nɩhɩyasɩ rɛ sabɩ teŋ no a kɩ tɩya Krisitabiisi hʋ buloŋ aa bɩ yaa Gyuuma, a we Aŋtiyɔki tɩyaŋ, abee Siiriya paalʋʋ tɩyaŋ, abee Silisɩya paalʋʋ tɩyaŋ. Á aa kyʋwalɩ ma buloŋ! ");
INSERT INTO sig_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Á nɩya anɩɩ á nala badɔmɔŋ ko ma lee rɛ, a kɩ dɔŋ ma, a kaŋ ma hakɩllɩ kɩ vʋgɩmɩ. Ka á mɛ daa tɩya ba ɛɛ ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɛɛwɩya, á mɛ laŋŋa rɛ, a vʋʋlɩ. Á naa dɩ ʋ yaa wɩwelii rɛ a tɩya ma, dɩ á lɩɩ nala a tɩŋ ba ma lee. Ba bee á kyaŋsɩ Banabaasɩ bee Pɔɔl lɛ sɩ ko. ");
INSERT INTO sig_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Baala no balɩya kpaa ba mɩɩbol yɔbɔ sʋʋ rɛ ba aa tuŋ á Tɩɩna Yesu Krisita tʋma wɩya. ");
INSERT INTO sig_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ɛɛwɩya, Gyudasɩ abee Silaasi rɛ á tɩma dɩ ba ko ma lee. Wɩya hʋ á aa saba kɩ tɩya ma, ba tɩɩ rɛ ba mɛ sɩ kaŋ nyʋwa basɩ tɩya ma. ");
INSERT INTO sig_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Á bee Wɩɩsɩ Wiyesi Welii hʋ buloŋ yaa nyʋʋdɩgɩ rɛ anɩɩ á bɩ sɩ kpa kyʋgɩ yohii buloŋ kyʋgɩ ma. Amɛ ʋ maga dɩ ma tɩŋa sɩŋsɩ no baŋmana á aa daga ma rɛ. Ba aa rɛ nyɛ: ");
INSERT INTO sig_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ma ta kɩ dii vʋga kɩna, ma ta kɩ kyaŋ kyal, ma ta kɩ kyaŋ kɩŋ buloŋ aa sʋba pimmiliŋ, a ta bɩl kɩ sɔnnɔ mɛ. Dɩ mamaa rɛ wuwo lɩɩ ma tɩɩ wɩya no tɩyaŋ, ma hɔnɩɩ sɩ weliye. Ma hɔŋ weliŋ.” ");
INSERT INTO sig_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nyɛ rɛ ba ta nala hʋ ba aa lɩya, ba sii kpa mʋ Aŋtiyɔki. Ba aa mʋʋ doŋ, ba yɩrɩ Krisitabiisi hʋ buloŋ aa we doŋ ko laŋŋɩ, a kpa teŋ hʋ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba aa karɩma teŋ hʋ, wɩya hʋ buloŋ ba aa saba yaa ba teŋfɩyɛlʋʋ rɛ. Ba tenni buloŋ polli. ");
INSERT INTO sig_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gyudasɩ bee Silaasi fa yaa Wɩɩsɩ tɩŋdaala rɛ. Ba gyɩ basɩ wɩya rɛ yʋga a tɩya nala hʋ. Ba wɩbasɩɩ hʋ leŋ nala hʋ tenni marɩ polli, ba marɩ kaŋ ba Wɩɩsɩ tɩŋɩɩ hʋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Gyudasɩ bee Silaasi gyɩ pɩɩsa mʋhʋ rɛ Aŋtiyɔki tɩyaŋ. Nyɛ rɛ Krisitabiisi hʋ aa we Aŋtiyɔki tɩyaŋ sii ta ba, ba mɩɩgɩ mʋ Gyerusalɛm abee laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amɛ Silaasi kɛ gyɩ mɩɩgɩ hɔŋ Aŋtiyɔki tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔl bee Banabaasɩ mɛ gyɩ mɩɩgɩ ka Aŋtiyɔki tɩyaŋ nɛ, a yaa peŋsi baŋmana. Nɩgyamaa gyɩ pɛɛ ba tɩyaŋ nɛ, ba gyɩ basɩ á Tɩɩna Yesu wɩya, aŋ pɛ kɩ daga ba mɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Saŋa kɩdɩgɩ aa ko pele, Pɔɔl basɩ tɩya Banabaasɩ a baa, “Leŋ dɩ á mɩɩgɩ mʋ tɔnɩ hʋ buloŋ á aa laa sɩya mʋ basɩ Wɩɩsɩ wɩya, a na Krisitabiisi hʋ aa we doŋ, ka dɩ á na ɛɛ hʋ ba hɔnɩɩ aa kɩya.” ");
INSERT INTO sig_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabaasɩ gyɩ aa kyɛ dɩ ʋ kaŋ Gyɔɔŋ Maakɩ tɩŋ ba hal mʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ɛɛ rɛ Pɔɔl baa dɩ ʋ bɩ maga dɩ ba bɩl kana ʋ pɛ ba tɩyaŋ, dɩ beewɩya ba beel-ʋ rɛ gyɩ laa sɩya lɩɩ dɩ ba gɔllɩ basɩ Wɩɩsɩ wɩya. Dɩ ɛɛ rɛ ba mʋ pele Pamfilɩya, ʋ vɩya ba ta doŋ aŋ mɩɩgɩ fá. ");
INSERT INTO sig_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɛɛ rɛ Pɔɔl bee Banabaasɩ gyɩ kaŋ wɩɩ hʋ kpa dɔmɔŋ kɩŋkaŋ, akuu gɛɛ wɩya porigi dɔmɔŋ. Nyɛ rɛ Banabaasɩ kaŋ Gyɔɔŋ Maakɩ, ba mʋ gyʋʋ nɩɩduworiboribal, a duwori mʋ Saapʋrɔsɩ. ");
INSERT INTO sig_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ka Pɔɔl mɛ lɩɩ Silaasi, ʋ beel-ʋ mɛ mʋ. Krisitabiisi hʋ gyɩ sʋla Wɩɩsɩ tɩya ba rɛ, a kpa ba we Wɩɩsɩ nosi tɩyaŋ dɩ ʋ kɩ deŋ ba. ");
INSERT INTO sig_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nyɛ rɛ ba mʋ tɩŋ Siiriya bee Silisɩya paalʋʋ, a marɩ basɩ Wɩɩsɩ wɩya tɩya Krisitabiisi hʋ aa we doŋ tɩyaŋ, dɩ ba marɩ sɩŋ ba laadii hʋ tɩyaŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nyɛ rɛ Pɔɔl sii mʋ Dɛɛbi, a lɩɩ doŋ a kpa mʋ Lisitira. Lisitira tɩyaŋ, ʋ na Yesu hatɩnnɩ kɩdɩgɩ aa we doŋ ba kɩ yɩrɩ Timoti. Timoti nɩɩna fa yaa Gyuu rɛ, a mɛ fa laa Yesu wɩya di, aŋka ʋ kuwo kɛ fa yaa Giriki tɩɩna. ");
INSERT INTO sig_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Krisitabiisi aa we Liisira abee Ikoniya buloŋ tɩyaŋ fa aa bigisi Timoti rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔl gyɩ aa kyɛ dɩ ʋ kaŋ Timoti tɩŋa ʋ hal lɛ. Ɛɛ rɛ tɩŋ ʋ gyɩ leŋ ba keri Timoti peŋ. Beewɩya Gyuuma hʋ buloŋ aa we doŋ paalʋʋ tɩyaŋ gyɩ gyɩma rɛ anɩɩ Timoti bɩ keri ʋ peŋ, beewɩya ʋ kuwo gyɩ yaa Giriki tɩɩna rɛ, ka Giriki tɩmma mɛ bee keri ba biisi pene. ");
INSERT INTO sig_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Saŋa hʋ ba aa mʋ tɔnɩ no buloŋ, ba gyɩ basɩ wɩya tɩya Krisitabiisi hʋ aa we doŋ ma tɩyaŋ nɛ. Wɩya hʋ Yesu kpambɩsɩ hʋ abee Krisitabiisi nɩhɩyasɩ aa we Gyerusalɛm tɩyaŋ aa biŋ tɩya ba dɩ ba kɩ tɩŋa, ba aa rɛ ba basɩ tɩya ba. ");
INSERT INTO sig_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nyɛ rɛ Krisitabiisi hʋ buloŋ aa we doŋ marɩ laa Yesu wɩya di weliŋ, aŋ marɩ wala kɩ pɛ kyɛɛ bee ʋ nyʋwa buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔɔl bee ʋ dɔŋtɩŋsɩ hʋ gyɩ gɔllɔ rɛ weliŋ, a tɩŋ Firigyiya bee Galetiya paalʋʋ, beewɩya Wɩɩsɩ Wiyesi Welii hʋ gyɩ bɩ tɩya ba ŋmanɩɩ dɩ ba basɩ Wɩɩsɩ wɩya Esɩya paalʋʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ɛɛ rɛ ba vala gɛɛ, a mʋ kpaga Maasɩya paalʋʋ. Doŋ tɩyaŋ nɛ ba lʋga dɩ ba fa tɩŋ Bitiiniya paalʋʋ mʋ, amɛ Yesu Wiyesi Welii hʋ gyɩ bɩ tɩya ba ŋmanɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nyɛ rɛ ba tɩŋ Maasɩya paalʋʋ a mʋ pele Turowasɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ʋ tebine, Pɔɔl na anɩɩ ʋ aa duwosi, a na dɩ baal kɩdɩgɩ lɩɩ Masidooniya paalʋʋ, a ko sɩŋ ʋ sɩya tɩyaŋ, a kɩ sʋla ʋ, a baa, “Ko kyiyeli ma Masidooniya paalʋʋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔl aa naa gɛɛ ko teŋ, á beel-ʋ yaa siri dɩ á mʋ Masidooniya paalʋʋ, beewɩya á naa anɩɩ Wɩɩsɩ rɛ kɔnɩ daga ma baa dɩ á mʋ basɩ Wɩɩsɩ wɩweliye hʋ a tɩya nala hʋ aa we doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nyɛ rɛ á bɩl sii doŋ a kpa mʋ gyʋʋ nɩɩduworiboribal, a duwori kyol a kpa mʋ Samotiresi. Ʋ sɩgballɩya á bɩl sii kpa mʋ Niyapoli. ");
INSERT INTO sig_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Á bɩl lɩɩ doŋ a vala mʋ Filipi. Doŋ fa yaa tɔbal lɛ a we Masidooniya paalʋʋ logiŋ kɩdɩgɩ tɩyaŋ. Roma kuwori rɛ fa ta tɩŋ doŋ taŋha buloŋ. Ɛɛ rɛ á gyɩ bɩl hɔŋ doŋ mɛ kyɛyɛ baŋmana. ");
INSERT INTO sig_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kyɛwiyesii hʋ kyɛɛ gyɩ pele ma doŋ nɛ. Ɛɛ rɛ á gyɩ lɩɩ bee hʋ tɩyaŋ, a tuu mʋ fuwo hʋ nyʋwa. Á fa bɩɩna á sɩ na Wɩɩsɩ lɩkyʋwalɩɩ rɛ doŋ. Nyɛ rɛ á mʋ hɔŋ doŋ, a basɩ Wɩɩsɩ wɩya kɩ tɩya haana hʋ fa aa laŋŋa doŋ dɩ ba kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Haana hʋ gyɩ aa gyegili nɩɩ wɩya hʋ á aa basɩ, ba kɩdɩgɩ feŋ nɛ gyɩ yaa Liidiya. Ʋ gyɩ lɩɩ Tiyatira rɛ. Ʋ fa aa yallɩ gannɩ rɛ, aŋ fa kɩ kyʋwalɩ Wɩɩsɩ mɛ. Ɛɛ rɛ Wɩɩsɩ gyɩ suri ʋ dɩgɩna abee ʋ hakɩla, ʋ gyegili nɩɩ wɩya hʋ buloŋ Pɔɔl fa aa basɩ, a laa ba buloŋ mɛ di. ");
INSERT INTO sig_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Doŋ tɩyaŋ nɛ ba fo ʋ bee ʋ dɩya nala buloŋ wɩɩkyʋwalnɩɩ. Ɛɛ rɛ ka haaŋ hʋ sʋl ma a baa, “Dɩ mamaa rɛ laa di anɩɩ ŋ kɔnɩ laa Yesu wɩya di rɛ, ma ko gyʋʋ ŋ dɩya.” Ʋ gyɩ sʋl ma rɛ weliŋ abee sɩfɩyasɩ ka á na mʋ gyʋʋ ʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nyɛ rɛ kyɛɛ kɩdɩgɩ, á bɩl kɩ mʋ Wɩɩsɩ lɩkyʋwalɩɩ. Ɛɛ rɛ haŋtolibiye kɩdɩgɩ aa yaa yoŋ ko kyem-ma. Gyɩŋsɩ rɛ gyɩ kana ʋ, ʋ vʋga kɩ tɩya nala. Ʋ vʋgʋ hʋ fa leŋ ʋ tɩmma kɩ na molbiye rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nyɛ rɛ ʋ kɩ tɩŋ á bee Pɔɔl hal, aŋ kyɩɩrɩ kɩ basɩ, “Nala no yaa Wɩɩbal hʋ aa tee kɩŋ buloŋ tʋŋtʋnna rɛ. Ɛɛ hʋ ma aa sɩ yaa dɩ Wɩɩsɩ laa ma ta rɛ ba kɩ basɩ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nyɛ rɛ haŋtolibiye no aa kɩ yaa kyɛɛ bee ʋ nyʋwa buloŋ. Ɛɛ rɛ Pɔɔl baaŋ ko sii, ʋ mɩɩgɩ bɩrɩmɩ kyaasɩ haŋtolibiye hʋ aŋ basɩ tɩya gyɩna hʋ a baa, “Yesu Krisita feŋ tɩyaŋ nɛ ŋ kɩ basɩ nyɛ, lɩɩ haŋtolibiye hʋ tɩyaŋ.” Ɛɛ rɛ gyɩna hʋ lɩɩ haŋtolibiye hʋ tɩyaŋ haŋ lagɩlagɩbiye hʋ. ");
INSERT INTO sig_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Haŋtolibiye hʋ tɩmma aa na dɩ ba bɩl bee na molbiye, ba sii kaŋ Pɔɔl bee Silaasi tarɩ mʋ ba bee hɩyarɩ sɩya. ");
INSERT INTO sig_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nyɛ rɛ ba kaŋ ba mʋ ba Roma nɩhɩyasɩ sɩya, a basɩ tɩya ba a baa, “Nala no yaa Gyuuma rɛ aŋ ko kaŋ á bee buloŋ kɩ dɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba aa daga ma rɛ dɩ á kɩ yaa wɩya hʋ á Roma tɩmma aa sɩŋ, ka á mɛ bɩ sɩ laa nyʋwa yaa ba, beewɩya á mɛ yaa Roma tɩmma rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Haŋ nɩgyamaa hʋ buloŋ fa aa laŋŋa sii pɛ ba nɩhɩyasɩ hʋ tɩyaŋ ba kaŋ Pɔɔl bee Silaasi. Nyɛ rɛ Roma tɩmma nɩhɩyasɩ hʋ leŋ ba kaŋ Pɔɔl bee Silaasi gannɩ wuri, aŋ leŋ ba vɩɩrɩ ba kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba fa aa vɩɩrɩ ba ko teŋ, ba kaŋ ba tɔ dɩya tɩyaŋ, aŋ basɩ tɩya nɩtɔdɩya didenni hʋ dɩ ʋ tɔ ba weliŋ dɩ ba ta ko wuwo lɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ʋ mɛ nɩɩ ba nyʋwa hʋ, a kaŋ Pɔɔl bee Silaasi gallɩ gyʋʋ sɩya dɩya hʋ, a kaŋ ba naasɩ balɩya balɩya buloŋ we kuliye. ");
INSERT INTO sig_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Anɩɩ ʋ tekere saŋa gɛɛ, Pɔɔl bee Silaasi sii kɩ kyʋwalɩ Wɩɩsɩ, a yɩɩ yɩɩla kɩ dannɩ Wɩɩsɩ. Nala hʋ aa we nɩtɔdɩya hʋ tɩyaŋ mɛ gyegili kɩ nɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ɛɛ rɛ taŋha buloŋ pirigi gyigili, aŋ kaŋ nɩtɔdɩya hʋ mɛ gyigisi. Borisi hʋ buloŋ suri suri. Nala buloŋ kuliye mɛ lɩɩ tele tele ba naasɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nal hʋ aa deŋ nɩtɔdɩya hʋ hirigi sii doo sɩya tɩyaŋ, a na dɩ nɩtɔdɩya hʋ borisi buloŋ suro. Ʋ kɛ fa liise anɩɩ nala hʋ buloŋ ba aa kaŋ tɔ dɩya hʋ tɩyaŋ lɩɩ fá mʋ rɛ gɛɛ. Ɛɛ rɛ ʋ lɩɩ ʋ takoobii dɩ ʋ kpʋ ʋ tɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ɛɛ rɛ Pɔɔl nɔsɩ ʋ a baa, “Ta kpʋ ɩ tɩɩ. Á buloŋ nɛ we doŋ.” ");
INSERT INTO sig_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nal hʋ aa deŋ nɩtɔdɩya hʋ leŋ ba kaŋ fɩŋtɩna ko. Ʋ laa fá gyʋʋ, a tuu tele Pɔɔl bee Silaasi naasɩ tɩyaŋ, a kɩ kyele. ");
INSERT INTO sig_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ʋ kaŋ ba lɩɩ pɩyɛsɩ ba a baa, “Ŋ kyaŋsɩ, ɛɛ rɛ ŋ sɩ yaa dɩ Wɩɩsɩ laa ŋ ta?” ");
INSERT INTO sig_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɛɛ rɛ ba basɩ tɩya ʋ a baa, “Laa á Tɩɩna Yesu wɩya di, dɩ Wɩɩsɩ mɛ laa ɩ bee ɩ dɩya nala buloŋ ta.” ");
INSERT INTO sig_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɛɛ rɛ ba basɩ á Tɩɩna Yesu wɩya tɩya ʋ bee ʋ dɩya nala buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Haŋ tebine hʋ tɩɩ rɛ nal hʋ aa deŋ nɩtɔdɩya hʋ kaŋ ba a sasɩ ba teŋ dʋgʋlɩya, ka ba fo ʋ bee ʋ dɩya nala buloŋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nal hʋ aa deŋ nɩtɔdɩya hʋ kaŋ Pɔɔl abee Silaasi, a mʋ ʋ dɩya, a tɩya ba kɩdiiliye ba di. Ka ʋ bee ʋ dɩya nala buloŋ tenni fɩyɛlɩ abee ba aa wuwo laa Wɩɩsɩ wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ʋ sɩya aa gballa, Roma nɩhɩyasɩ hʋ tɩŋ porisi nɩhɩyasɩ dɩ ba mʋ basɩ tɩya nal hʋ aa deŋ nɩtɔdɩya hʋ dɩ ʋ lɩɩ Pɔɔl bee Silaasi ta dɩ ba kɩ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nyɛ rɛ nal hʋ aa deŋ nɩtɔdɩya hʋ basɩ tɩya Pɔɔl baa dɩ Roma nɩhɩyasɩ hʋ tɩma rɛ dɩ ba basɩ tɩya ʋ dɩ ʋ lɩɩ ʋ bee Silaasi ta. Ɛɛ wɩya dɩ ba sii kɩ mʋ abee laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nyɛ rɛ Pɔɔl basɩ tɩya porisi nɩhɩyasɩ hʋ a baa, “Ba vɩɩrɩ ma rɛ nala sɩya tɩyaŋ, aŋ bɩ daga á wɩkyogii, aŋka á mɛ yaa Roma tɩmma, aŋka ba ha kaŋ ma tɔ dɩya tɩyaŋ. Ka nyɛ kɛ, ba kɩ kyɛ dɩ ba lʋwɔlɩ lɩɩ ma ta. Aayɩ, á bee laa! Ʋ maga dɩ Roma nɩhɩyasɩ hʋ tɩɩ rɛ ko daha, a lɩɩ ma.” ");
INSERT INTO sig_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ɛɛ rɛ porisi nɩhɩyasɩ hʋ mʋ basɩ tɩya Roma nɩhɩyasɩ hʋ anɩɩ Pɔɔl bee Silaasi mɛ yaa Roma tɩmma rɛ. Ba aa nɩɩ gɛɛ, kambɩŋ kaŋ ba. ");
INSERT INTO sig_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nyɛ rɛ ba sii mʋ sʋla ba anɩɩ ba kyogo rɛ, aŋ lɩɩ ba nɩtɔdɩya hʋ tɩyaŋ, aŋ basɩ tɩya ba dɩ ba lɩɩ ba bee hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ba aa lɩɩ nɩtɔdɩya hʋ tɩyaŋ nɛ, ba kpa mʋ Liidiya dɩya. Doŋ nɛ ba na Krisitabiisi badɔmɔŋ. Pɔɔl bee Silaasi basɩ wɩya tɩya nala hʋ. Ba wɩbasɩɩ gyɩ leŋ nala hʋ tenni polli rɛ weliŋ. Ɛɛ hal tɩyaŋ nɛ ba lɩɩ doŋ, a bɩl kpa kɩ mʋ ba lɩmʋʋlɩya. ");
INSERT INTO sig_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ba aa mʋʋ hʋ tɩyaŋ nɛ, ba mʋ tɩŋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Amfipolisi, a bɩl sii doŋ a kpa tɩŋ tɔɔ kɩdɩgɩ mɛ ba aa yɩrɩ Apolooniya, a bɩl lɩɩ doŋ a kpa mʋ tɔɔ kɩdɩgɩ mɛ ba aa yɩrɩ Tesaloniika. Gyuuma wɩɩkyʋwaldɩya gyɩ we tɔɔ no tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nyɛ rɛ Pɔɔl gyɩ mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya hʋ anɩɩ ʋ aa vala kɩ yaa gɛɛ lee buloŋ tɩyaŋ. Yɔbɩsɩ boto paga tɩyaŋ, ba bee nala hʋ kɩ vʋʋlɩ Wɩɩsɩ wɩya wɩɩkyʋwaldɩya hʋ tɩyaŋ Kyɛwiyesii hʋ kyɛɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ʋ karɩmɩ Wɩɩsɩ tenni hʋ kɩ tɩya ba, a daga ba sɩya mɛ kɩ tɩya ba, aŋ pɛ daga tɩya ba ɛɛ Krisita hʋ aa maga dɩ ʋ na tʋwara, a sʋba aŋ bɩl sii sʋʋ tɩyaŋ. Aŋ bɩl basɩ tɩya ba a baa, “Yesu no wɩya ŋ aa basɩ kɩ tɩya ma nyɛ, ʋ rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta.” ");
INSERT INTO sig_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Gyuuma hʋ badɔmɔŋ laa wɩya hʋ dɩ aŋ mɛ pɛ Pɔɔl bee Silaasi tɩyaŋ. Giriki tɩmma mɛ aa kyʋwalɩ Wɩɩsɩ, ba bee bee hʋ habiibala badɔmɔŋ mɛ yʋga laa wɩya hʋ di, aŋ mɛ pɛ ba tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nyɛ rɛ Gyuuma badɔmɔŋ gyɩ kɩ na baaŋ, akuu nala yʋga aa laa Pɔɔl wɩbasɩɩ hʋ dɩ wɩya. Ɛɛ rɛ ba mʋ kyɛ kasɩ nyuduwo tɩmma hʋ aa hɔŋ yɔbɩsɩ abee ŋmaŋsɩ tɩyaŋ a pɛ ba tɩɩ tɩyaŋ. Ba buloŋ ko laŋŋɩ a kaŋ bee hʋ buloŋ vʋgɩmɩ abee kyagɩŋsɩ dʋŋ. Doŋ tɩyaŋ nɛ ba mʋ gyʋʋ baal kɩdɩgɩ ba aa yɩrɩ Gyeesiŋ dɩya, a kɩ kyɛ Pɔɔl bee Silaasi dɩ ba kasɩ ko lɩɩ tɩya nala hʋ. ");
INSERT INTO sig_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amɛ ba gyɩ bɩ naa ba doŋ, aŋ mɩɩgɩ kaŋ Gyeesiŋ abee Krisitabiisi hʋ badɔmɔŋ, a tarɩ ba lɩɩ ba bee nɩhɩyasɩ sɩya, aŋ kaŋ kyagɩŋsɩ lee buloŋ a baa, “Nala no kyogi lee buloŋ nɛ aŋ yaŋ bɩl ko á bee mɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ka Gyeesiŋ laa ba biŋ ʋ dɩya tɩyaŋ. Ba aa kyogi mɩrɩsɩ hʋ á kuworibal hʋ aa bine rɛ. Beewɩya ba aa basɩ anɩɩ kuwori kɩdɩgɩ mɛ rɛ bɩl we doŋ ba kɩ yɩrɩ Yesu.” ");
INSERT INTO sig_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ba wɩbasɩɩ no ba aa basɩ hʋ nɛ gyɩ leŋ nala hʋ abee ba bee nɩhɩyasɩ buloŋ bɩ gyɩŋ wɩɩ hʋ buloŋ ba aa sɩ yaa, aŋ kɩ yaa kyagɩŋsɩ dʋŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nyɛ rɛ bee hʋ nɩhɩyasɩ leŋ Gyeesiŋ abee ʋ kyaŋsɩ hʋ kpa molbiye biŋ anɩɩ ba bɩl bɩ sɩ maakyiye yaa wɩɩ hʋ ba aa yaa, aŋka ba na leŋ ba, ba mʋ. ");
INSERT INTO sig_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ʋ lee aa ko bɩl, Krisitabiisi hʋ sii leŋ Pɔɔl bee Silaasi mʋ Bɛriya. Ba aa mʋʋ pele Bɛriya, ba mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya. ");
INSERT INTO sig_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bɛriya tɩmma rɛ gyɩ kpɩya Tesaloniika tɩmma. Beewɩya ba kɛ kyaga laa Wɩɩsɩ wɩya hʋ rɛ abee nosi balɩya, a kɩ karɩmɩ Wɩɩsɩ teŋ hʋ abee sɩfɩyasɩ kyɛɛ kɛ buloŋ dɩ ba na dɩ wɩya hʋ Pɔɔl aa basa kɔnɩ yaa wɩtɩɩ rɛ koo wɩtɩɩ daa. ");
INSERT INTO sig_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Gyuuma gyɩ yʋga ba tɩyaŋ nɛ a laa Yesu wɩya di. Giriki tɩmma haana aa yaa habiibala doŋ tɩyaŋ abee ba baala buloŋ mɛ gyɩ laa Yesu wɩya di rɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gyuuma hʋ aa we Tesaloniika tɩyaŋ aa nɩya dɩ Pɔɔl bɩl aa basɩ Wɩɩsɩ wɩya Bɛriya tɩyaŋ. Ba bɩl sii mʋ doŋ mɛ a mʋrɩ haŋ nɩgyamaa hʋ buloŋ we dɩ ba mɛ bɩl laa taawɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ɛɛ rɛ Krisitabiisi hʋ leŋ Pɔɔl lɩɩ a mʋ mpʋwɔnʋʋ nyʋwa. Ka Silaasi bee Timoti kɛ ha we Bɛriya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nala hʋ badɔmɔŋ aa lɩɩ Bɛriya kyiyeli Pɔɔl, a mʋ pele Atɛŋsi. Ka Pɔɔl mɩɩgɩ tɩŋ ba dɩ ba mʋ basɩ tɩya Silaasi bee Timoti dɩ ba ko puu ʋ lagɩ. ");
INSERT INTO sig_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saŋa hʋ Pɔɔl aa hɔŋ Atɛŋsi tɩyaŋ a kɩ gyegili Silaasi bee Timoti gɛɛ, ʋ na dɩ daaluliye suu bee hʋ buloŋ. Ʋ tɩya buloŋ kyogi kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɛɛ rɛ Pɔɔl aa sii mʋ gyʋʋ Gyuuma wɩɩkyʋwaldɩya, ʋ bee Gyuuma abee nala hʋ aa bɩ yaa Gyuuma aŋ kɩ kyʋwalɩ Wɩɩsɩ aa kɩ vʋʋlɩ wɩya, a kaŋ wɩya kɩ kpa dɔmɔŋ. Ka kyɛɛ buloŋ mɛ, ʋ aa sii gyʋʋ gbɛ gyamaa tɩyaŋ, a basɩ Yesu Krisita wɩya a kɩ tɩya nala hʋ buloŋ kɛ aa we doŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kerikyisi badɔmɔŋ aa tɩŋ Ɛpikuura abee Sitɔyiki ŋmanɩɩ ko doŋ, ʋ beel-ba mɛ kaŋ wɩya kɩ kpa dɔmɔŋ. Ɛɛ rɛ ba badɔmɔŋ baa, “Bekine wɩya rɛ bambugi no mɛ sɩŋ kɩ basɩ nyɛ?” Ba badɔmɔŋ mɛ baa, “Tɔdʋŋ falɩya badɔmɔŋ wɩya rɛ ʋ kɩ basɩ.” Pɔɔl gyɩ aa basɩ Yesu wɩweliye hʋ wɩya rɛ, anɩɩ ʋ sii sʋʋ tɩyaŋ nɛ, ɛɛ rɛ tɩŋ ba gyɩ kɩ basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nyɛ rɛ ba kana ʋ mʋ lee hʋ ba aa kɩ laŋŋɩ. Ba aa yɩrɩ doŋ Ariyopagusi. Doŋ tɩyaŋ nɛ ba basɩ tɩya ʋ a baa, “Á aa kyɛ dɩ á gyɩŋ wɩfalɩɩ no wɩya ɩ aa basɩ hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wɩya hʋ badɔmɔŋ ɩ aa basɩ yaa wɩfalɩya rɛ á kɛ lee. Ɛɛ wɩya á yaŋ kyo dɩ á gyɩŋ ba memii rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atɛŋsi tɩmma abee ʋ nɩhʋwala buloŋ gyɩ bɩ kaŋ wɩɩ buloŋ pɛ wɩfalɩya no ba aa nɩya basɩɩ tɩyaŋ, aŋ mɛ kyo dɩ ba gyegili nɩɩ wɩfalɩya nala lee tɩyaŋ. Ba mɛ wɩyaalɩɩ buloŋ nɛ gɛɛ.) ");
INSERT INTO sig_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ɛɛ rɛ Pɔɔl sii sɩŋ nala hʋ fa laŋŋa tʋtʋʋ tɩyaŋ, aŋ basɩ tɩya ba a baa, “Atɛŋsi tɩmma, ŋ aa ko daha, ŋ naa anɩɩ ma kyo vʋga marɩɩ rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ŋ aa gɔllɔ ma bee hʋ tɩyaŋ, ŋ naa ma tɔdʋnnɩ rɛ. Ŋ bɩl naa kogu kɩdɩgɩ mɛ ma aa saa rɛ. Nyɛ rɛ ma sabɩ we ʋ tɩyaŋ, ‘Wɩɩsɩ hʋ á aa bɩ gyɩma lɩmarɩɩ rɛ nyɛ.’ Ɛɛ rɛ Pɔɔl bɩl basɩ baa, Wɩɩsɩ hʋ ma aa kyʋwalɩ aŋ bɩ gyɩma ʋ hʋ, ʋ wɩya rɛ ŋ basɩ kɩ tɩya ma gɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wɩɩsɩ hʋ aa marɩ dʋnɩya abee kɩŋ kɩŋ buloŋ aa we dʋnɩya no tɩyaŋ, ʋ rɛ yaa wɩɩsɩnyuu abee taŋha buloŋ Tɩɩna, ʋ bee pɩŋ wɩɩkyʋwaldɩɩsɩ nihuwobisi aa saa tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ʋ bɩ kɩɩ nɩɩ ʋ aa kyɛ kɩŋ lɔlɔ rɛ tɩŋ ʋ kɩ kyɛ dɩ nihuwobisi tʋma tɩya ʋ. Ʋ rɛ tɩya nihuwobisi mɩɩbol abee wiyese abee kɩŋ kɛ buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Piili hʋ tɩyaŋ, nɩdɩgɩ rɛ Wɩɩsɩ fa marɩ. Haŋ nɩdɩgɩ hʋ tɩyaŋ nɛ dʋnɩya nala doho buloŋ tɩŋ ko a hɔŋ dʋnɩya logiŋ kɛ buloŋ tɩyaŋ. Ka dɩ Wɩɩsɩ na marɩ ba, ʋ tɩɩ rɛ daga saŋa hʋ abee leye hʋ ba aa sɩ we duniya no tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ʋ marɩ ba gɛɛ rɛ dɩ ba wuwo kyɛ ʋ lee, a kɩ lannɩ lee buloŋ dɩ ba na ʋ. Amɛ Wɩɩsɩ mɛ yaŋ bɩ boliye abee á kɩdɩgɩ buloŋ lee. ");
INSERT INTO sig_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nal kɩdɩgɩ rɛ basa a baa, ‘Ʋ dee tɩyaŋ nɛ á wuwo kaŋ mɩɩbol no a we doŋ aŋ wuwo kɩ vala mɛ.’ Ma haŋye-taala badɔmɔŋ mɛ fa basa gɛɛ tɩɩ rɛ dɩ á mɛ yaa ʋ biisi rɛ. ");
INSERT INTO sig_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Á yaŋ aa yaa ʋ balɩya nyɛ, ʋ bɩ maga dɩ á kɩ bɩɩnɩ anɩɩ Wɩɩsɩ kɩɩ kɩna hʋ nihuwobisi aa kpa salma marɩ rɛ, koo kɩŋ hʋ ba aa kpa hɔgɩ koo bʋyɩ marɩ. Ʋ bɩ kɩɩ kɩna no nihuwobisi aa kpa ba wɩgyʋŋ marɩ. ");
INSERT INTO sig_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Saŋa hʋ nihuwobisi fa aa bɩ gyɩma ʋ, Wɩɩsɩ fa yaa faasɩŋ nɛ ba nyuu tɩyaŋ. Amɛ nyɛ kɛ ʋ basɩ kɩ tɩya nala buloŋ nɛ lee kɛ buloŋ tɩyaŋ dɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","beewɩya ʋ biŋ kyɛɛ rɛ ʋ aa sɩ di dʋnɩya nala buloŋ sarɩya abee tɩdɩgɩ. Nal hʋ ʋ aa lɩya dɩ ʋ laa dʋnɩya nala ta tɩyaŋ nɛ ʋ sɩ tɩŋa a di sarɩya no. Nal no ʋ aa lɩya, ʋ kyisi ʋ rɛ sʋʋ tɩyaŋ, dɩ nal buloŋ gyɩma anɩɩ wɩtɩɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nala hʋ aa nɩya anɩɩ Pɔɔl aa basɩ sʋʋnɩ mɩɩgɩ sii wɩya gɛɛ, ba badɔmɔŋ mɛ baa, “Á aa kyɛ dɩ ɩ bɩl kyɛ kyɛɛ rɛ, a basɩ wɩɩ no tɩya ma dɩ á marɩ nɩɩ weliŋ.” Ka ba badɔmɔŋ mɛ kɩ yaa ʋ sɩya. ");
INSERT INTO sig_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ɛɛ rɛ Pɔɔl sii lɩɩ lee hʋ ba aa laŋŋa tɩyaŋ, a kpa mʋ. ");
INSERT INTO sig_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nala hʋ badɔmɔŋ mɛ gyɩ laa Wɩɩsɩ wɩya hʋ dɩ rɛ, aŋ kɩ tɩŋ Pɔɔl hal. Ba kɩdɩgɩ feŋ nɛ Dayonisiyo. Ʋ mɛ fa we nala hʋ aa kɩ laŋŋɩ Ariyopagusi hʋ tɩyaŋ nɛ. Haaŋ kɩdɩgɩ mɛ rɛ ba fa kɩ yɩrɩ Damaarɩsɩ, ʋ bee nala badɔmɔŋ mɛ gyɩ laa wɩya hʋ dɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɛɛ rɛ Pɔɔl sii Atɛŋsi tɩyaŋ, a kpa mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Koriŋti. ");
INSERT INTO sig_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Doŋ tɩyaŋ nɛ ʋ na Gyuu baal kɩdɩgɩ aa lɩɩ Pɔŋtusi, ba kɩ yɩrɩ Akula. Ʋ bee ʋ haaŋ Pirisila gyɩ aa lɩɩ Roma ko, ba ha gyɩ bɩ pɩɩsa. Roma tɩmma kuworibal hʋ ba aa yɩrɩ Kilodiyasi fa basɩ tɩya Gyuuma buloŋ nɛ dɩ ba lɩɩ Roma tɩyaŋ. Ɛɛ rɛ tɩŋ ba lɩɩ ko Koriŋti gɛɛ. Nyɛ rɛ Pɔɔl mʋ ba dɩya dɩ ʋ kyʋwalɩ ba. ");
INSERT INTO sig_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ʋ mʋ we ba dɩya tɩyaŋ, beewɩya ʋ beel-ba buloŋ tʋma fa yaa kɩdɩgɩ rɛ. Taŋtɩsɩ rɛ ba fa aa ala kɩ yallɩ. ");
INSERT INTO sig_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kyɛwiyesii hʋ kyɛɛ kɛ buloŋ, ʋ aa mʋ ba wɩɩkyʋwaldɩya rɛ. Ʋ bee Gyuuma abee Giriki tɩmma buloŋ kaŋ Wɩɩsɩ wɩya hʋ kɩ kpa dɔmɔŋ. Ʋ aa kɩ lʋga dɩ ba laa Wɩɩsɩ wɩya hʋ di. ");
INSERT INTO sig_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ɛɛ rɛ Silaasi bee Timoti lɩɩ Masidooniya paalʋʋ ko. Saŋa hʋ ba aa ko tɩyaŋ, Pɔɔl kpa ʋ nyuu buloŋ we Wɩɩsɩ wɩya basɩɩ tɩyaŋ nɛ, a daga Gyuuma weliŋ anɩɩ Yesu rɛ yaa Krisita hʋ, laataal hʋ Wɩɩsɩ aa lɩya dɩ ʋ laa dʋnɩya nala ta. ");
INSERT INTO sig_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nyɛ rɛ Gyuuma hʋ lɩɩ ʋ hal aŋ kɩ tʋʋsɩ ʋ. Ba aa yaa gɛɛ hʋ tɩyaŋ nɛ, Pɔɔl pigisi ʋ gannɩ kʋŋkɔyɩ we ba tɩyaŋ (Nyɛ daga anɩɩ ʋ noŋ bɩl tuwo ba wɩkanɩya tɩyaŋ), aŋ basɩ tɩya ba a baa, “Dɩ ma kɩdɩgɩ buloŋ nɛ ko nyʋgɩsɩ Wɩɩsɩ ŋmanɩɩ hʋ tɩyaŋ, ʋ tɩɩna haakye maga ʋ rɛ. Ŋ kɛ wɩɩ bɩl daa. A yaŋ lɩɩ gyɩnaŋ kɩ mʋ, ŋ sɩ mʋ basɩ Wɩɩsɩ wɩweliye hʋ a tɩya nala hʋ aa bɩ yaa Gyuuma.” ");
INSERT INTO sig_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ʋ aa basɩ wɩya no hal tɩyaŋ nɛ, ʋ sii mʋ gyʋʋ baal kɩdɩgɩ aa bɩ yaa Gyuu aŋ kɩ kyʋwalɩ Wɩɩsɩ dɩya, ba kɩ yɩrɩ Titiyo Gyusitu. Ʋ dɩya mɛ fa sɩŋ kpaga Gyuuma wɩɩkyʋwaldɩya hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Baal kɩdɩgɩ ba aa yɩrɩ Kirisipu rɛ fa yaa wɩɩkyʋwaldɩya no sɩlaal. Ʋ bee ʋ dɩya nala kɛ buloŋ nɛ fa laa á Tɩɩna Yesu wɩya di. Nala yʋga mɛ fa nɩɩ Wɩɩsɩ wɩya hʋ rɛ Koriŋti tɩyaŋ, a mɛ laa di. Ba fo ba buloŋ wɩɩkyʋwalnɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nyɛ rɛ kyɛɛ kɩdɩgɩ tebine, Pɔɔl duwoso tɩyaŋ, ʋ na dɩ Wɩɩsɩ basɩ tɩya ʋ baa, “Ta kɩ fá kambɩŋ. Ɩ kɛ ha basɩ wɩya kɩ tɩya nala hʋ, aŋ ta kpaa ta. ");
INSERT INTO sig_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Beewɩya, ŋ sɩŋ ɩ hal lɛ. Nal buloŋ bɩ sɩ wuwo kana ɩ yaa wɩbɔŋ buloŋ, beewɩya ŋ nala yʋga rɛ bee no tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔɔl hɔŋ doŋ nɛ bɩna abee kyalɩɩ, a kɩ daga nala Wɩɩsɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Haŋ saŋa hʋ tɩyaŋ Galiyo rɛ fa yaa Roma nɩhɩyawʋ hʋ aa deŋ Akaaya paalʋʋ. Ɛɛ rɛ Gyuuma hʋ sii laŋŋɩ dɔmɔŋ a kaŋ Pɔɔl mʋ ba sarɩya lidiilii. ");
INSERT INTO sig_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba baa, “Baal no aa lʋgɩ rɛ dɩ nala laa ʋ nyʋwa hʋ di, a kɩ tɩŋ Wɩɩsɩ abee ŋmanɩɩ hʋ aa sɩ kyogi á sɩŋsɩ.” ");
INSERT INTO sig_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔl aa yaa dɩ ʋ basɩ wɩya, ɛɛ rɛ Galiyo basɩ tɩya Gyuuma hʋ a baa, “Gyuuma, dɩ baal no rɛ fa yaa wɩɩ kyogi, ʋ fa kaŋ ŋmanɩɩ rɛ dɩ ŋ di kenyiri, aŋ gyegili nɩɩ ma wɩbasɩɩ. ");
INSERT INTO sig_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amɛ ʋ aa yaa wɩbasɩɩ abee ma fene yɩrɩɩ wɩya, abee ma tɩɩ sɩŋsɩ wɩya nyɛ, ʋ maga dɩ ma tɩɩ kaŋ mʋ dɩya rɛ a basɩ we dɔmɔŋ. Ŋ bɩ sɩ wuwo laa wɩɩ no gyɩma tɩya ma.” ");
INSERT INTO sig_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ɛɛ rɛ ʋ kil ba ta ba lɩɩ sarɩya hʋ lidiilii tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ba buloŋ lɩɩ gol kaŋ Sɔsɩtɩnɛɛsɩ, nal hʋ fa aa yaa Gyuuma wɩɩkyʋwaldɩya hʋ sɩlaal, a ŋmaa ʋ weliŋ sarɩya hʋ lidiilii dimbeenyʋwa tɩyaŋ. Abee gɛɛ buloŋ, ka Galiyo paalɩ bɩ tɔgɩmɔ ba. ");
INSERT INTO sig_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl fa pɩɩsa rɛ weliŋ Koriŋti tɩyaŋ. Ɛɛ rɛ ʋ sii a kyʋwalɩ Krisitabiisi hʋ aa we Koriŋti tɩyaŋ, aŋ lɩɩ doŋ. Ʋ bee Pirisila abee Akula buloŋ sii mʋ a gyʋʋ nɩɩduworiboribal dɩ ba mʋ Siiriya paalʋʋ. Ka dɩ ba na lɩɩ Keŋkiriya tɩyaŋ, Pɔɔl fa fʋma ʋ nyuu rɛ, beewɩya ʋ fa dii nyʋwa rɛ Wɩɩsɩ lee. ");
INSERT INTO sig_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba mʋ pele tɔɔ kɩdɩgɩ ba aa yɩrɩ Ɛfiso. Doŋ tɩyaŋ nɛ Pɔɔl leŋ Pirisila abee Akula, aŋ mʋ gyʋʋ wɩɩkyʋwaldɩya. Ʋ bee Gyuuma kaŋ wɩya kɩ kpa dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nala hʋ badɔmɔŋ basɩ baa, dɩ ʋ fa hɔŋ ba lee pɩɩsɩ mʋhʋ, ka ʋ mɛ bɩ laa nyʋwa dɩ ʋ hɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ʋ aa ko sii doŋ, ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Dɩ Wɩɩsɩ rɛ ko tɩya ŋ ŋmanɩɩ, ŋ sɩ mɩɩgɩ ko ma lee.” Ɛɛ rɛ ʋ sii mʋ gyʋʋ nɩɩduworiboribal a kpa lɩɩ Ɛfiso tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nyɛ rɛ ʋ mʋ pele tɔɔ kɩdɩgɩ nyʋwa ba kɩ yɩrɩ Sizaariya. Doŋ nɛ ʋ sɩŋ a kpa mʋ Gyerusalɛm, a mʋ kyʋwalɩ Krisitabiisi hʋ aa we doŋ. Ʋ bɩl sii doŋ a kpa mʋ Aŋtiyɔki. ");
INSERT INTO sig_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ʋ hɔŋ doŋ mɛ pɩɩsɩ mʋhʋ rɛ aŋ bɩl sii tɩŋ Galetiya bee Firigyiya paalʋʋ, a basɩ wɩya kɩ tɩya Krisitabiisi hʋ aa we doŋ, dɩ ba marɩ laa Yesu wɩya di weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Gyuu kɩdɩgɩ aa lɩɩ Alizaŋdiriya mɛ rɛ fa we doŋ, ba kɩ yɩrɩ Apolo. Ʋ mɛ sii ko Ɛfiso. Ʋ fa gyɩŋ wɩya basɩɩ rɛ weliŋ, a bɩl gyɩŋ Wɩɩsɩ teŋ hʋ mɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba fa daga ʋ á Tɩɩna Yesu ŋmanɩɩ hʋ tɩŋɩɩ rɛ weliŋ. Ʋ aa kɩ daga Yesu wɩya weliŋ abee sɩfɩyasɩ. Ka wɩya hʋ buloŋ ʋ aa basɩ a mʋ kɩ tile Yesu tɩyaŋ mɛ yaa wɩtɩɩ. Abee gɛɛ buloŋ, dɩ ʋ rɛ ko kɩ basɩ wɩɩkyʋwalnɩɩ foyi wɩya, Gyɔɔŋ Wɩɩsɩ nɩɩfool hʋ aa fo nala wɩɩkyʋwalnɩɩ hʋ dʋŋ wɩya rɛ ʋ gyɩma. ");
INSERT INTO sig_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ʋ aa we Ɛfiso tɩyaŋ, ʋ basɩ Wɩɩsɩ wɩya rɛ abee nyuduwo wɩɩkyʋwaldɩya hʋ tɩyaŋ. Pirisila bee Akula mɛ we doŋ a nɩɩ wɩya hʋ ʋ aa basɩ. Nyɛ rɛ ba kana ʋ mʋ ba dɩya a marɩ daga ʋ Wɩɩsɩ ŋmanɩɩ hʋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ɛɛ rɛ Apolo sii kɩ kyɛ dɩ ʋ mʋ Akaaya paalʋʋ. Krisitabiisi hʋ aa we Ɛfiso tɩyaŋ sabɩ teŋ tɩya Krisitabiisi hʋ aa we Giriisi tɩyaŋ, a kpaanɩ ba weliŋ dɩ Apolo kɩ ko doŋ, dɩ ba kana ʋ weliŋ. Ʋ aa mʋʋ doŋ, ʋ pɛɛ nala hʋ aa laa Yesu wɩya di rɛ Wɩɩsɩ lahɔrʋmɔ tɩyaŋ, ");
INSERT INTO sig_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","amarɩkpatɩya dɩ ʋ bee Gyuuma rɛ ko kaŋ wɩya kɩ kpa dɔmɔŋ nala tɩyaŋ, ʋ aa kpa Wɩɩsɩ teŋ wɩya rɛ a basɩ wɩya lo ba, a daga anɩɩ Yesu rɛ yaa Krisita hʋ. ");
INSERT INTO sig_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo fa aa we Koriŋti tɩyaŋ gɛɛ rɛ, Pɔɔl bɩl gɔllɩ gɛɛ a ko pele Ɛfiso. Doŋ tɩyaŋ nɛ ʋ na nala badɔmɔŋ aa laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ɛɛ rɛ Pɔɔl pɩyɛsɩ ba a baa, “Saŋa hʋ ma aa laa Yesu wɩya di, Wɩɩsɩ kpa ʋ Wiyesi Welii hʋ we ma tɩyaŋ nɛ?” Nyɛ rɛ ba baa, “Aayɩ, á kɛ ha bɩ maakyiye nɩɩ Wɩɩsɩ Wiyesi Welii no wɩya gba.” ");
INSERT INTO sig_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ɛɛ rɛ Pɔɔl bɩl pɩyɛsɩ ba, “Nyʋʋbee rɛ ma tɩŋa, ka ba na fo ma wɩɩkyʋwalnɩɩ hʋ?” Ɛɛ rɛ ba basɩ baa, “Á tɩŋ wɩya hʋ buloŋ Gyɔɔŋ Wɩɩsɩ nɩɩfool hʋ aa daga ma rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ɛɛ rɛ Pɔɔl bɩl baa, “Nala hʋ aa mɩɩgɩ lɩɩ ba wɩbɔmɔ tɩyaŋ nɛ Gyɔɔŋ gyɩ kɩ fo wɩɩkyʋwalnɩɩ. Amɛ ʋ fa basɩ tɩya Iziral tɩmma rɛ anɩɩ ʋ koyi no hal tɩyaŋ, nal sɩ ko dɩ ba kɩ yɩrɩ ʋ tɩɩna Yesu, aŋ bɩl baa dɩ ʋ rɛ ko ko, dɩ ba laa ʋ wɩya di.” ");
INSERT INTO sig_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ba aa nɩɩ wɩɩ no Pɔɔl aa basa, ba leŋ ʋ fo ba wɩɩkyʋwalnɩɩ á Tɩɩna Yesu feŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ɛɛ rɛ Pɔɔl kpa ʋ nosi dɔbɔ ba tɩyaŋ. Ʋ aa yaa gɛɛ rɛ, Wɩɩsɩ Wiyesi Welii hʋ ko tuu gyʋʋ ba tɩyaŋ. Ba piili kɩ basɩ taanɩ hʋ ba kɩdɩgɩ buloŋ aa bɩ gyɩma, aŋ bɩl basɩ wɩya hʋ mɛ Wɩɩsɩ aa kpaa tɩya ba a baa dɩ ba laa basɩ. ");
INSERT INTO sig_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nala no buloŋ gyɩ yaa anɩɩ baala fi abee balɩya rɛ. ");
INSERT INTO sig_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔl aa we Ɛfiso tɩyaŋ, ʋ vala kɩ gyʋʋ wɩɩkyʋwaldɩya gɛɛ rɛ deŋdeŋ ʋ peŋsi boto, aa paalɩ kɩ basɩ Wɩɩsɩ koro hʋ wɩya abee nyuduwo. Ʋ bee nala hʋ aa kaŋ wɩya no kɩ kpa dɔmɔŋ nɛ ʋ kɩ lʋga dɩ ba laa wɩɩ hʋ ʋ aa basɩ di. ");
INSERT INTO sig_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amɛ nala hʋ badɔmɔŋ gyɩ kaŋ nyuduwo rɛ kɩŋkaŋ. Akuu ba nyuduwo no wɩya, ba gyɩ bɩ laa Wɩɩsɩ wɩya hʋ di, aŋ ha hɔŋ gyamaa hʋ tɩyaŋ, a basɩ wɩbɔmɔ a mʋ kɩ tile á Tɩɩna Yesu ŋmanɩɩ hʋ tɩŋɩɩ tɩyaŋ. Ɛɛ rɛ Pɔɔl sii leŋ nyuduwo tɩmma hʋ ta doŋ, ka ʋ bee nala hʋ aa laa Yesu wɩya di sii kpa mʋ Tiraanusi dɩɩbal hʋ. Dɩya no tɩyaŋ nɛ Pɔɔl bee nala hʋ fa aa sɩŋ kaŋ wɩya kɩ kpa dɔmɔŋ kyɛɛ bee ʋ nyʋwa buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ʋ val yaa gɛɛ rɛ a mʋ pele bɩsɩ balɩya. Gyuuma abee Giriki tɩmma hʋ buloŋ aa we Esɩya paalʋʋ tɩyaŋ wuwo nɩɩ á Tɩɩna Yesu wɩya. ");
INSERT INTO sig_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wɩɩsɩ gyɩ leŋ Pɔɔl wuwo kɩ yaa wɩmagɩla rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Haalɩ, ba aa paa gannɩ bee gakɔsʋŋsɩ hʋ Pɔɔl aa dige rɛ a kaŋ mʋ tɩya wɩɩla tɩmma, ba dige, a na laaŋfɩya. Dɩ gyɩŋbɔmɔ rɛ fa kaŋ nal mɛ, ba aa lɩɩ ʋ tɩɩna tɩyaŋ nɛ ka ʋ na laaŋfɩya. ");
INSERT INTO sig_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Gyuuma badɔmɔŋ mɛ fa we doŋ a gɔllɩ kɩ kile gyɩŋbɔmɔ nala tɩyaŋ. Ba mɛ kɩ lʋga dɩ ba yaa gɛɛ á Tɩɩna Yesu feŋ tɩyaŋ. Dɩ ba ko kɩ kyɛ dɩ ba kile gyɩŋbɔmɔ, ba aa basɩ baa, “Ŋ baa ma lɩɩ Yesu feŋ tɩyaŋ, nal hʋ wɩya Pɔɔl aa basɩ.” ");
INSERT INTO sig_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baala bapɛ rɛ fa aa yaa gɛɛ. Ba kuwo feŋ nɛ Siiva. Ʋ fa yaa Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɛɛ rɛ kyɛɛ kɩdɩgɩ gyɩŋbɔŋ kɩdɩgɩ basɩ tɩya ba a baa, “Ŋ gyɩŋ Yesu rɛ, a gyɩŋ Pɔɔl mɛ, aŋka ma mɛ yaa kɩbeema rɛ?” ");
INSERT INTO sig_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nyɛ rɛ gyɩŋsɩ hʋ aa kaŋ baal hʋ sii kaŋ ba, a ŋmaa ba weliŋ, aŋ pɩrɩ ba pɛ. Ka ba gannɩ mɛ buloŋ kɩyɛsɩ, ba buloŋ lɩɩ fá dɩya hʋ tɩyaŋ abee teŋkpelli. ");
INSERT INTO sig_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gyuuma hʋ bee Giriki tɩmma hʋ abee nala hʋ buloŋ aa we Ɛfiso tɩyaŋ aa nɩɩ wɩɩ no, kambɩŋ gyɩ gyʋʋ ba buloŋ nɛ. Doŋ tɩyaŋ nɛ ba marɩ kɩ kpa á Tɩɩna Yesu yohuŋ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nala hʋ aa laa Yesu wɩya di yʋga ko, a basɩ ba wɩbɔmɔ hʋ buloŋ ba aa yaa a tɩya Pɔɔl, haŋ nɩgyamaa hʋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ba tɩyaŋ nala fa yʋga a yaa daaluliye tɩmma. Ɛɛ rɛ ba buloŋ paa tenni hʋ ba fa aa karɩmɩ a kɩ yaa daaluliye hʋ ko we diŋ nala hʋ sɩya tɩyaŋ. Dɩ ba kaŋ tenni hʋ buloŋ yalɩɩ ko pɛ dɔmɔŋ, ʋ sɩ yaa mogyamaa. ");
INSERT INTO sig_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Wɩmagɩla no buloŋ leŋ á Tɩɩna nyʋwa hʋ taalɩ lee buloŋ, aŋ kaŋ dee mɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wɩya no hal tɩyaŋ nɛ Pɔɔl na anɩɩ ʋ sɩ tɩŋ Masidooniya paalʋʋ abee Akaaya paalʋʋ a mʋ Gyerusalɛm. Ɛɛ rɛ ʋ baa, “Dɩ mɩyaŋ nɛ mʋ doŋ, ʋ maga dɩ ŋ mʋ Roma mɛ rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nyɛ rɛ Pɔɔl tɩŋ nala hʋ fa aa kɩ pɛ ʋ tɩyaŋ ba tɩyaŋ nala balɩya dɩ ba mʋ Masidooniya. Timoti bee Irasitu rɛ ʋ tɩma. Aŋka ʋ tɩɩ kɛ ha hɔŋ Ɛfiso tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Saŋa no tɩyaŋ nɛ nyʋʋtaaduwo gyɩ gyʋʋ Ɛfiso nala abee sɩfɩyasɩ a mʋ kɩ tile á Tɩɩna Yesu ŋmanɩɩ hʋ tɩŋɩɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Lugil kɩdɩgɩ rɛ fa we doŋ ba kɩ yɩrɩ Dɛmitiriyo. Salma rɛ ʋ fa aa kpa kɩ lugo kɩna aa kɩɩ Atɛmɩsɩ, ba vʋgɩbal hʋ dɩya. Tʋma no tɩyaŋ nɛ ʋ bee ʋ tʋŋtʋnna buloŋ ko yaa kɩna tɩmma. ");
INSERT INTO sig_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nyɛ rɛ kyɛɛ kɩdɩgɩ ʋ yɩrɩ ʋ tʋŋtʋnna abee ʋ tʋŋtʋnnɩ dɔŋtɩŋsɩ a ko laŋŋɩ, a basɩ tɩya ba a baa, “Ŋ kyaŋsɩ, ma gyɩma anɩɩ tʋma no tɩyaŋ nɛ á dʋwa buloŋ lɩɩ. Beewɩya tʋma no rɛ aa tɩya ma molbiye. ");
INSERT INTO sig_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma tɩɩ mɛ nɩya rɛ, a kɩ na mɛ wɩya hʋ Pɔɔl aa yaa. Ʋ baa dɩ vʋga hʋ nihuwobiŋ aa lugo bɩ yaa Wɩɩsɩ. Ɛfiso abee Esɩya paalʋʋ gyeniŋ buloŋ nɛ ʋ wuwo kaŋ nɩgyamaa hakɩllɩ bɩrɩmɩ ba ko laa wɩɩ no di. ");
INSERT INTO sig_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wɩɩ hʋ ŋ aa fá rɛ nyɛ: Nala sɩ kyogi á tʋma no feŋ, a bɩl kɩ fá mɛ anɩɩ á vʋgɩbal hʋ Atɛmɩsɩ sɩ ko yaa kɩtɔɔ. Nala bɩl bɩ sɩ kɩ tɩya ʋ gyɩrɩma, koo a kɩ bigisi ʋ. Beewɩya, lagɩlagɩ no, Esɩya nala abee dʋnɩya nal kɛ buloŋ nɛ nɩɩ ʋ wɩya a kɩ tɩya ʋ gyɩrɩma.” ");
INSERT INTO sig_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nala hʋ aa nɩɩ wɩɩ no, ba buloŋ baaŋ sii. Ba kɩ yaa kyagɩŋsɩ a baa, “Á vʋgɩbal hʋ Atɛmɩsɩ aa we Ɛfiso tɩyaŋ nɛ kaŋ dee.” ");
INSERT INTO sig_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ɛɛ rɛ ba kaŋ bee hʋ buloŋ vʋgɩmɩ. Haŋ nɩgyamaa hʋ buloŋ kaŋ Geyosi abee Arisitaakusi aa lɩɩ Masidooniya a kɩ tɩŋa Pɔɔl hal. Nyɛ rɛ ba tarɩ ba kaŋ mʋ lee hʋ bee hʋ nala aa kɩ laŋŋɩ. ");
INSERT INTO sig_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ba aa kaŋ ba mʋ doŋ gɛɛ, Pɔɔl tɩɩ fa aa kyɛ dɩ ʋ mʋ gyʋʋ nala hʋ tɩyaŋ nɛ, amɛ nala hʋ aa laa Yesu wɩya di hʋ bɩ laa nyʋwa. ");
INSERT INTO sig_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Esɩya paalʋʋ nɩhɩyasɩ badɔmɔŋ bee Pɔɔl aa yaa kyaŋsɩ, tɩma dɩ ba mʋ basɩ tɩya Pɔɔl dɩ ʋ ta ko gyʋʋ nala hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nala hʋ buloŋ aa laŋŋa doŋ fa bɩ gyɩŋ wɩɩ hʋ aa yaa. Ba badɔmɔŋ aa yaa kyagɩŋsɩ baa nyɛ rɛ, ka ba badɔmɔŋ mɛ baa dɩ ɛɛ daa, dɩ wɩɩ no rɛ. Ba gyeniŋ buloŋ fa paalɩ bɩ gyɩŋ wɩɩ hʋ aa tɩŋ ba ko laŋŋɩ doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Gyuu kɩdɩgɩ rɛ fa we nala hʋ tɩyaŋ ba kɩ yɩrɩ Alizaŋda. Ʋ rɛ Gyuuma hʋ gyɩ leŋ ʋ lɩɩ sɩŋ ba sɩya tɩyaŋ. Ɛɛ rɛ tɩŋ nala hʋ badɔmɔŋ gyɩ liisi anɩɩ ʋ rɛ yaa wɩɩ hʋ tɩyaŋ nɩbal. Ɛɛ rɛ Alizaŋda kaŋ nosi viri dɩ ba leŋ kyagɩŋsɩ, aŋ kɩ lʋga dɩ ʋ basɩ tɩya nala hʋ anɩɩ wɩɩ buloŋ tuwo ba beel-ʋ paga tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ʋ aa yaa gɛɛ, ba na nɩɩ ʋ yaa Gyuu rɛ. Ɛɛ rɛ ba buloŋ bɩl yaa kyagɩŋsɩ we dɔmɔŋ a mʋ maga gɛɛ aŋ kɩ basɩ, “Á vʋgɩbal hʋ Atɛmɩsɩ aa we Ɛfiso tɩyaŋ nɛ kaŋ dee.” ");
INSERT INTO sig_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nyɛ rɛ ba bee kerikyi-hɩyawʋ kɩdɩgɩ ko lɩɩ a wuwo leŋ ba leŋ kyagɩŋsɩ hʋ, ka ʋ basɩ tɩya ba a baa, “Ɛfiso nala, nal buloŋ gyɩma rɛ anɩɩ ámaa rɛ tɩŋ á Atɛmɩsɩ, á vʋgɩbal hʋ, abee ʋ toŋo hʋ aa yaa bʋyɩ a lɩɩ wɩɩsɩ nyuu ko tuu buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nal buloŋ bɩ sɩ wuwo kaŋ wɩɩ no kyɩɩsɩ. Ɛɛwɩya, ma leŋ kyagɩŋsɩ aŋ ta kɩ yaa wɩɩ hʋ aa bɩ kaŋ memii. ");
INSERT INTO sig_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nala no bɩ gaa kpa kɩŋ buloŋ á vʋgɩbal hʋ lɩmarɩɩ tɩyaŋ, ba bɩl bɩ basɩ wɩɩ mɛ kyogi á vʋgɩbal hʋ feŋ, ka ma kasɩ ba kaŋ ko daha nyɛ. ");
INSERT INTO sig_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dɩ Dɛmitiriyo bee ʋ tʋŋtʋnna rɛ kaŋ wɩɩ bee nal buloŋ mɛ, ka sarɩya mɛ kaŋ ʋ kyɛdiilii rɛ, ma bee hɩyarɩ mɛ we doŋ ba aa sɩ di sarɩya hʋ. Ma leŋ dɩ ba mʋ doŋ kɩ nyaŋ dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amɛ dɩ wɩɩ kɩdɩgɩ mɛ dɔŋ nɛ we doŋ ma kɩ kyɛ dɩ ma basɩ, ma kaŋ mʋ lee hʋ bee hʋ nala aa laŋŋɩ a kɩ vʋʋlɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Dɩ ba aa rɛ pɩyɛsɩ ma, á bɩ sɩ wuwo basɩ wɩɩ buloŋ a mʋ kɩ tile taawɛɛ no aa siye gyɩnaŋ. Wɩɩ hʋ ŋ aa faa rɛ nyɛ, ba sɩ baa dɩ ámaa rɛ we taawɛɛ hʋ.” ");
INSERT INTO sig_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ʋ aa basɩ gɛɛ ko teŋ, ʋ leŋ nala hʋ buloŋ fa aa laŋŋa sii mʋ ba dɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɛɛ rɛ taawɛɛ hʋ ko teŋ, ka Pɔɔl yɩrɩ Krisitabiisi hʋ aa we Ɛfiso tɩyaŋ a basɩ nyunyaasɩ wɩya tɩya ba. Ʋ aa basɩ wɩya hʋ ko teŋ, ɛɛ rɛ ʋ ta ba, aŋ sii kpa mʋ Masidooniya paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Masidooniya paalʋʋ buloŋ nɛ ʋ gɔllɩ a basɩ nyunyaasɩ wɩya yʋga a kɩ tɩya Krisitabiisi hʋ aa we doŋ. Ɛɛ rɛ ka ʋ bɩl lɩɩ doŋ a kpa mʋ Giriisi paalʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ʋ we Giriisi paalʋʋ tɩyaŋ nɛ ʋ peŋsi boto. Ɛɛ rɛ ʋ sii yaa ʋ siri dɩ ʋ gyʋʋ nɩɩduworiboro a mʋ Siiriya paalʋʋ. Ʋ aa yaa siri gɛɛ, ʋ nɩɩ anɩɩ Gyuuma aa vʋʋlɩ rɛ dɩ ba kpʋ ʋ. Nyɛ rɛ ʋ bɩrɩmɩ ʋ hakɩla, a mɩɩgɩ sii tɩŋ Masidooniya dɩɩlaŋ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nala no rɛ gyɩ aa tɩŋ Pɔɔl hal: Faarusi biibaal Sopata aa lɩɩ Bɛriya, abee Arisitaakusi bee Sɛkundu aa lɩɩ Tesaloniika; abee Geyosi aa lɩɩ Dɛɛbi, a yaŋ bee Takikusi bee Turofimɔsɩ mɛ aa lɩɩ Esɩya paalʋʋ. Nala no bee Timoti rɛ fa aa tɩŋ Pɔɔl hal. ");
INSERT INTO sig_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ba aa rɛ laa sɩya a mʋ gyegili ma Turowasɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gbɩyalbal hʋ tɩyaŋ ba aa dɩ paanʋʋ hʋ aa bɩ kaŋ sɩbʋl gyɩ ko parɩ rɛ, ka á na sii Filipi tɩyaŋ a gyʋʋ nɩɩduworiboro, a vala kyɛyɛ bɔnɔŋ, aŋ na mʋ puu ba Turowasɩ tɩyaŋ, a we doŋ kyɛyɛ bapɛ. ");
INSERT INTO sig_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Asibiti kyɛɛ dɩdaana, á buloŋ sii laŋŋɩ dɔmɔŋ dɩ a dɩ kɩdiiliye hʋ Krisita fa aa baa dɩ á kɩ di aŋ kɩ liisi ʋ wɩya hʋ. Ʋ sɩya rɛ sɩ gballɩ dɩ Pɔɔl sii mɩɩgɩ mʋ. Ɛɛ rɛ ʋ basɩ wɩya gɛɛ deŋdeŋ lee mʋ kerisi. ");
INSERT INTO sig_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Salnyuu dɩya tɩyaŋ nɛ á fa hɔŋ aŋ nyɔgɔ fɩŋtɩŋsɩ yʋga. ");
INSERT INTO sig_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bapʋwasɩbiye kɩdɩgɩ mɛ rɛ fa we doŋ ba kɩ yɩrɩ Yutikusi. Tokoro tɩyaŋ nɛ ʋ fa hɔŋ. Pɔɔl aa basɩ wɩya hʋ kɩ pɩɩsɩ gɛɛ, ʋ hɔŋ kɩ dɩyɛgɩ doo, a ko kpa doo pɩŋ. Doo hʋ pɩnɩɩ tɩyaŋ nɛ, ʋ fori lɩɩ salnyuu dɩya hʋ tɩyaŋ, a tuu tele taŋha. Ba tuu kɩ kpa ʋ dɩ ʋ sʋba. ");
INSERT INTO sig_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ɛɛ rɛ Pɔɔl mɛ sii tuu a luŋ guwori ʋ aŋ basɩ tɩya nala hʋ a baa, “Ma ta leŋ dɩ ʋ yaa wɩɩ buloŋ, ʋ ha weye rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ɛɛ rɛ ka Pɔɔl bɩl mɩɩgɩ gyɩŋ salnyuu dɩya hʋ, ba kɩ di kɩdiiliye hʋ Krisita fa aa baa dɩ ba kɩ di á kɩ liisi ʋ wɩya. Ʋ aa dii kɩna hʋ ko teŋ, ba bɩl kaŋ ba wɩbasɩɩ gɛɛ sɩya mʋ gballɩ. Ɛɛ rɛ ka Pɔɔl sii mʋ. ");
INSERT INTO sig_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bapʋwasɩbiye hʋ weye rɛ ba kana ʋ mʋ dɩya abee teŋfɩyɛlʋʋ. ");
INSERT INTO sig_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nyɛ rɛ á sii mʋ gyʋʋ nɩɩduworiboribal a duwori mʋ Asɔɔsɩ. Pɔɔl fa basɩ tɩya ma rɛ anɩɩ á gyʋʋ nɩɩduworiboribal hʋ duwori kɩ mʋ Asɔɔsɩ, ka dɩ ʋ kɛ vala naasɩ ko gyʋʋ nɩɩduworiboribal hʋ Asɔɔsɩ tɩyaŋ. Nyɛ rɛ á gyʋʋ nɩɩduworiboribal hʋ a mʋ Asɔɔsɩ dɩ á fa kpa Pɔɔl. ");
INSERT INTO sig_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pɔɔl aa ko puu ma Asɔɔsɩ tɩyaŋ, ɛɛ rɛ á kpa ʋ abee nɩɩduworiboribal hʋ a mʋ tɩŋ Mitilini. ");
INSERT INTO sig_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ʋ sɩgballɩya, á kpa ko Kiyɔsi. Ʋ sɩya bɩl gballɩ, á kpa mʋ Samɔsi. Doŋ nɛ á bɩl sii ʋ sɩgballɩya a kpa ko pele Miletu. ");
INSERT INTO sig_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Á bɩl aa sii Miletu mɛ tɩyaŋ, Pɔɔl baa dɩ ʋ bɩ sɩ sɩŋ Ɛfiso tɩyaŋ. Beewɩya dɩ ʋ bee kyɛ dɩ ʋ pɩɩsɩ Esɩya paalʋʋ tɩyaŋ. Ʋ fa aa kyɛ dɩ ʋ mʋ Gyerusalɛm lagɩ rɛ a puu Pɛŋtikosi kyɛbal hʋ doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ɛɛ rɛ á kpa gallɩ ko Miletu. Nyɛ rɛ Pɔɔl tɩma yɩrɩ Krisitabiisi nɩhɩyasɩ hʋ aa we Ɛfiso tɩyaŋ dɩ ba ko. ");
INSERT INTO sig_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba aa ko, ʋ basɩ tɩya ba a baa, “Ma tɩɩ gyɩŋ ɛɛ hʋ ŋ aa kɩya rɛ saŋa hʋ ŋ beel-ma fa aa we doŋ, a lɩɩ saŋa hʋ tɩyaŋ ŋ aa piile ko Esɩya paalʋʋ a kaŋ kɩ ko gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Akuu Gyuuma aa vʋʋlɩ dɩ ba kpʋ ŋ wɩya, ŋ naa tʋwara rɛ kɩŋkaŋ, a wɩɩ sɩnɩɩl mɛ weliŋ. Amɛ abee gɛɛ buloŋ, ŋ ha kaŋ ŋ tɩɩ bɩrɩmɩ biibiye rɛ, dɩ ŋ wuwo tuŋ á Tɩɩna Wɩɩsɩ tʋma hʋ anɩɩ Wɩɩsɩ tʋŋtʋnnɩ. ");
INSERT INTO sig_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ŋ daga ma Wɩɩsɩ wɩya rɛ nala tɩyaŋ abee ma dɩɩsɩ tɩyaŋ buloŋ. Wɩɩ kɛ buloŋ aa sɩ pɛ ma tɩyaŋ nɛ ŋ kpa daga ma. Ŋ bɩ laa nyʋwa kaŋ wɩɩ buloŋ faŋa ma. ");
INSERT INTO sig_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gyuuma abee Giriki tɩmma buloŋ nɛ ŋ basɩ tɩya abee sɩfɩyasɩ anɩɩ ba bɩrɩmɩ lɩɩ ba wɩbɔmɔ yayɩ tɩyaŋ aŋ ko kɩ tɩŋa Wɩɩsɩ aŋ laa á Tɩɩna Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Wɩɩsɩ Wiyesi Welii hʋ rɛ daga ŋ dɩ ŋ mʋ Gyerusalɛm. Ʋ nyʋwa hʋ rɛ ŋ tɩŋa a kɩ mʋ nyɛ. Ŋ bɩ gyɩŋ wɩɩ hʋ buloŋ aa sɩ puu ŋ doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ŋ ta gyɩma rɛ anɩɩ tɔɔ kɛ buloŋ ŋ aa mʋwa, Wɩɩsɩ Wiyesi Welii hʋ aa basɩ tɩya ŋ nɛ abee sɩfɩyasɩ anɩɩ wɩya sɩ gyʋʋ ŋ, ka dɩ ba ha kana ŋ tɔ dɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amɛ ŋ aa deŋ dɩ ŋ mɩɩbol bɩ yaa kɩŋ buloŋ ŋ kɛ lee. Ŋ kɛ sɩya tuwo dɩ ŋ sʋba koo dɩ ŋ weye. Ŋ Tɩɩna Yesu aa tɩya ŋ tʋma hʋ rɛ ŋ kɩ kyɛ dɩ ŋ tʋma teŋ. Tʋma hʋ ʋ aa kpaa tɩya ŋ nɛ yaa dɩ ŋ basɩ Wɩɩsɩ wɩweliye hʋ tɩya nala, a basɩ tɩya ba ɛɛ hʋ Wɩɩsɩ aa sɩ fa ba sikii. ");
INSERT INTO sig_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nyɛ kɛ, ŋ gyɩma rɛ anɩɩ ma nala no ŋ aa yaŋ gɔllɩ basɩ Wɩɩsɩbee koro hʋ wɩya kɩ tɩya nyɛ, ma bɩl bɩ sɩ maakyiye na ŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Wɩɩsɩ wɩya hʋ buloŋ ŋ aa basɩ tɩya ma, ŋ bɩ kaŋ wɩɩ buloŋ faŋa ma. Ŋ yaŋ basɩ kɩ tɩya ma rɛ abee sɩfɩyasɩ gyɩnaŋ sɩgballɩya no anɩɩ dɩ ma kɩŋ hʋ buloŋ nɛ ko yaa dɩ ʋ nyʋgɩsa, ŋ wɩɩ kɛ bɩl daa. Ʋ tɩɩna haakye maga ʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɛɛwɩya, ma kɩ deŋ ma tɩɩ nyuu weliŋ, aŋ pɛ kɩ deŋ nala hʋ mɛ ʋ Wiyesi Welii hʋ aa kpaa we ma nosi tɩyaŋ. Ma kɩ deŋ Krisitabiisi mɛ nyuu weliŋ anɩɩ pedaal aa kɩ deŋ ʋ piyese nyuu tɩyaŋ gɛɛ. Wɩɩsɩ rɛ kpaa ʋ tɩɩ biye kyal yɔbɔ ma. ");
INSERT INTO sig_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ŋ gyɩma rɛ anɩɩ dɩ mɩyaŋ nɛ leŋ ma, nɩbɔmɔ sɩ ko gyʋʋ ma tɩyaŋ anɩɩ gboni aa gyʋʋ pʋsɩ tɩyaŋ gɛɛ. Nɩbɔmɔ hʋ bɩ sɩ leŋ ma, ba sɩ kɩ dɔŋ ma kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Haalɩ, nala sɩ lɩɩ ma tɩɩ tɩyaŋ a yaa wɩnyɩyɛla a kaŋ wɩya hʋ ŋ aa daga ma bɩrɩmɩ kyige, aŋ mʋrɩ Krisitabiisi dɩ ba mɩɩgɩ hal a ko kɩ tɩŋ ba. ");
INSERT INTO sig_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɛɛ rɛ tɩŋ ŋ basɩ baa ma kɩ deŋ ma tɩɩ ma nyuu tɩyaŋ gɛɛ. Ma gyɩma anɩɩ ŋ bɩsɩ boto rɛ nyɛ ŋ aa daga ma kɩdɩgɩ kɩdɩgɩ buloŋ wɩɩhaa abee tebine buloŋ, a wɩɩ sɩnɩɩl mɛ weliŋ ma wɩya. ");
INSERT INTO sig_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nyɛ kɛ, ŋ kpaa ma we Wɩɩsɩ nosi tɩyaŋ nɛ. Duwoso hʋ aa daga bɔnyɛ hʋ Wɩɩsɩ aa kana abeel-ma, ʋ rɛ sɩ pɛ ma tɩyaŋ dɩ ma kaŋ dee a wuwo sɩŋ ma laadii tɩyaŋ. Ʋ sɩ leŋ dɩ ma na wɩweliye hʋ buloŋ Wɩɩsɩ aa yaa biŋ a gbala ʋ nala buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ŋ ha bɩ maakyiye laa ma kɩdɩgɩ buloŋ molbii koo gannɩ koo salma a yaa ŋ kɩna. ");
INSERT INTO sig_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ma tɩɩ gyɩma rɛ anɩɩ ŋ tʋma rɛ weliŋ abee ŋ nosi no, aŋ na na ŋ bee ŋ kyaŋsɩ kɩkyɛɛlɩya buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ŋ yaa gɛɛ rɛ dɩ ŋ daga ma dɩ ma mɛ kɩ tʋŋ tʋma gɛɛ. Dɩ ámaa rɛ aa tʋŋ tʋma abee sɩfɩyasɩ gɛɛ, ɛɛ rɛ á sɩ wuwo pɛ taaga tɩyaŋ, aŋ kɩ liisi wɩɩ hʋ á Tɩɩna Yesu fa aa basa. Ʋ baa, ‘Ɩ aa kpaa kɩŋ tɩya nal, ʋ rɛ kaŋ teŋfɩyɛlʋʋ a te ɩ aa laa kɩŋ nal lee.”’ ");
INSERT INTO sig_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔɔl aa basɩ wɩya no buloŋ ko teŋ, ʋ beel-ba buloŋ tuu gbinni, ʋ kyʋwalɩ Wɩɩsɩ tɩya ba buloŋ. ");
INSERT INTO sig_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɛɛ rɛ ba buloŋ ko guwori ʋ, aŋ kɩ wɩɩ sɩnɩɩl. ");
INSERT INTO sig_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ba tɩsɩ buloŋ gyɩ kyogo rɛ weliŋ, beewɩya ʋ fa basɩ tɩya ba rɛ anɩɩ ba bɩl bɩ sɩ maakyiye na ʋ. Nyɛ rɛ ka ba buloŋ kpa tɩŋa ʋ tɩyaŋ a mʋ nɩɩduworiboro hʋ lee. ");
INSERT INTO sig_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nyɛ rɛ á ta dɔmɔŋ aŋ gyʋʋ nɩɩduworiboribal hʋ, a vala sɩdeŋ a mʋ lɩɩ tɔɔ kɩdɩgɩ ba aa yɩrɩ Kɔsɩ. Ʋ sɩgballɩya á bɩl sii doŋ a kpa mʋ Rodisi, a bɩl lɩɩ doŋ mɛ a kpa mʋ Patara. ");
INSERT INTO sig_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Doŋ tɩyaŋ nɛ á na nɩɩduworiboribal dɩ ʋ aa mʋ Fɔniisɩya paalʋʋ. Ɛɛ rɛ á gyʋʋ ʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Á aa mʋʋ hʋ tɩyaŋ nɛ, a na tɔɔ kɩdɩgɩ ba kɩ yɩrɩ Saapʋrɔsɩ. Nyɛ rɛ á gallɩ doŋ a kpa tɩŋ wɩɩpɔsɩɩ noduu dɩɩlaŋ, a mʋ pele Siiriya paalʋʋ, a mʋ sɩŋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Taaya. Doŋ nɛ nɩɩduworiboribal hʋ gyɩ maga dɩ ʋ sɩŋ dɩ ba kuwoni kyʋgɩsɩ hʋ aa we ʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nyɛ rɛ á kyɛ mʋ na Krisitabiisi hʋ aa we doŋ tɩyaŋ, a gyɩ hɔŋ ba lee kyɛyɛ bapɛ. Wɩɩsɩ Wiyesi Welii hʋ dee tɩyaŋ, ba gyɩ basɩ tɩya Pɔɔl lɛ dɩ ʋ ta mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kyɛyɛ bapɛ no hal tɩyaŋ nɛ, á bɩl lɩɩ doŋ a kpa á ŋmanɩɩ. Baala abee ba haana abee ba biisi kaŋ ma ko lɩɩ dɩ ba we ŋmanɩɩ tɩyaŋ. Ɛɛ rɛ á buloŋ tuu gbinni nɩɩ hʋ nyʋwa tɩyaŋ a kyʋwalɩ Wɩɩsɩ. ");
INSERT INTO sig_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Doŋ nɛ á ta dɔmɔŋ aŋ gyʋʋ nɩɩduworiboribal hʋ ka ba mɛ mɩɩgɩ mʋ dɩya. ");
INSERT INTO sig_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Á bɩl lɩɩ Taaya tɩyaŋ mɛ a kpa á ŋmanɩɩ a mʋ tɔɔ kɩdɩgɩ ba aa yɩrɩ Pitolimiiyasɩ. Ɛɛ rɛ á mʋ kyʋwalɩ Krisitabiisi hʋ aa we doŋ aŋ pɩŋ ba lee. ");
INSERT INTO sig_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ʋ sɩya aa gballa, á sii kpa mʋ Sizaariya, a mʋ gyʋʋ baal kɩdɩgɩ ba aa yɩrɩ Fɩlɩpɩ dɩya. Ʋ mɛ fa gɔllɔ basɩ Wɩɩsɩ wɩya kɩ tɩya nala rɛ. Ʋ fa yaa nala hʋ bapɛ ba aa lɩya Gyerusalɛm tɩyaŋ dɩ ba kɩ kyiyeli Yesu kpambɩsɩ hʋ kɩdɩgɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ʋ fa kaŋ toliye banaa rɛ, ka ba kɩdɩgɩ buloŋ fa bɩ yal bala aŋ yaa Wɩɩsɩ tɩŋdaala. ");
INSERT INTO sig_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Doŋ nɛ á we kyɛyɛ baŋmana, dɩ baal kɩdɩgɩ ba aa yɩrɩ Agabu mɛ lɩɩ Gyudɩya paalʋʋ ko. Ʋ mɛ fa yaa Wɩɩsɩ tɩŋdaal lɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɛɛ rɛ ʋ ko á lee, a laa Pɔɔl tɛpɩɩŋbii a vʋwa ʋ tɩɩ naasɩ abee ʋ nosi buloŋ aŋ basɩ baa, Nyɛ rɛ Wɩɩsɩ Wiyesi Welii hʋ basɩ, “Gyuuma sɩ kaŋ tɛpɩɩŋbii no tɩɩna a vʋwa ʋ nyɛ Gyerusalɛm tɩyaŋ aŋ kpa ʋ we nala hʋ aa bɩ yaa Gyuuma nosi tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Á aa nɩɩ wɩɩ no, á bee nala hʋ buloŋ fa aa we doŋ sʋla Pɔɔl dɩ ʋ ta mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ɛɛ rɛ Pɔɔl basɩ tɩya ma a baa, “Bee rɛ tɩŋ ma kɩ wii, a leŋ ŋ tɩya buloŋ kyogi nyɛ? Dɩ ba aa rɛ sɩ kana ŋ vʋwa, koo dɩ ba aa rɛ kpʋ ŋ Gyerusalɛm tɩyaŋ mɛ, akuu ŋ Tɩɩna Yesu wɩya, ŋ kɛ laa rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ʋ aa basɩ gɛɛ ko teŋ, á na anɩɩ á bɩ sɩ wuwo tɔ ʋ ŋmanɩɩ. Ɛɛ rɛ á mɛ leŋ aŋ basɩ tɩya ʋ dɩ Wɩɩsɩ sɩ leŋ dɩ wɩɩ kɛ buloŋ ʋ aa kyɛ ʋ yaa, kɔnɩ yaa. ");
INSERT INTO sig_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɛɛ rɛ ka á mɛ yaa siri a sii mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nala hʋ badɔmɔŋ aa laa Yesu wɩya di a lɩɩ Sizaariya mɛ tɩŋ á hal mʋ, a kaŋ ma mʋ gyʋʋ baal kɩdɩgɩ ba aa yɩrɩ Mineesiŋ a lɩɩ Saapʋrɔsɩ dɩya. Saŋa hʋ ba fa aa piile kɩ basɩ Yesu wɩya kɩ tɩya nala hʋ tɩyaŋ nɛ ʋ gyɩ laa Yesu wɩya di. ");
INSERT INTO sig_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Á gyɩ aa ko pele Gyerusalɛm, Krisitabiisi hʋ gyɩ kaŋ ma weliŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ʋ sɩgballɩya, á bee Pɔɔl sii mʋ dɩ á na Gyemsi. Á mʋwa dɩ Krisitabiisi nɩhɩyasɩ hʋ buloŋ laŋŋa doŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nyɛ rɛ Pɔɔl kyʋwalɩ ba aŋ basɩ tɩya ba ɛɛ hʋ buloŋ Wɩɩsɩ aa pɛɛ ʋ tɩyaŋ ʋ wuwo tʋŋ tʋma nala hʋ aa bɩ yaa Gyuuma tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba aa nɩɩ wɩɩ no ko teŋ, ba dannɩ Wɩɩsɩ aŋ basɩ tɩya Pɔɔl a baa, “Á nihiyabiye Pɔɔl, ɩ kɛ deŋ na Gyuuma aa maga gɛɛ a laa Yesu wɩya di. Ba pele nala tusi tusi, ka ba buloŋ wuwo kɩ tɩŋ mɩrɩsɩ hʋ buloŋ Moosi fa aa saba biŋ dɩ nala kɩ tɩŋa. ");
INSERT INTO sig_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba nɩɩ ɩ wɩya rɛ. Ba baa dɩ ɩ aa kɩ daga Gyuuma hʋ buloŋ aa we nala hʋ aa bɩ yaa Gyuuma tɩyaŋ nɛ, aŋ baa dɩ ba vɩya mɩrɩsɩ hʋ buloŋ Moosi fa aa saba biŋ dɩ nala kɩ tɩŋa hʋ mɛ. Aŋ bɩl baa dɩ ɩ baa ba ta kɩ keri ba biisi pene, aŋ ta bɩl kɩ tɩŋ Gyuuma naabaala lesiri hʋ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ba sɩ nɩɩ anɩɩ ɩ ko daha rɛ. Wɩbee rɛ á yaŋ sɩ yaa? ");
INSERT INTO sig_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Wɩɩ kɛ buloŋ á aa sɩ baa ɩ yaa, tɩŋa á nyʋwa. Baala banaa rɛ we daha. Ba dii nyʋwa rɛ Wɩɩsɩ lee aŋ kɩ kyɛ dɩ ba lɩɩ nyʋwa hʋ. ");
INSERT INTO sig_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kaŋ ba dɩ ma buloŋ mʋ dɩ ɩ pɩɩsɩ ɩ bisiŋ ta, aŋ tuŋ molbiye dɩ ba mɛ pɩɩsɩ ba bisiŋ ta aŋ fʋŋ ba nyuni mɛ. Dɩ ɩ rɛ yaa gɛɛ, nal buloŋ sɩ tɩŋ gɛɛ tɩyaŋ a gyɩma anɩɩ wɩya hʋ buloŋ ba aa basɩ a mʋ kɩ tile ɩ tɩyaŋ bɩ yaa wɩtɩɩ. Ba sɩ na anɩɩ ɩ tɩɩ mɛ gba aa tɩŋ mɩrɩsɩ hʋ Moosi fa aa saba biŋ dɩ nala kɩ tɩŋa rɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Amɛ Krisitabiisi hʋ aa bɩ yaa Gyuuma, á laa sɩya sabɩ teŋ a basɩ tɩya ba rɛ, dɩ ba laa nyʋwa anɩɩ ba bɩl bɩ sɩ kɩ di vʋga kɩna, a ta bɩl kɩ kyaŋ pʋsɩ kyal mɛ, a ta kɩ kyaŋ kɩna aa sʋba pimmiliŋ mɛ, aŋ lɩɩ ba tɩɩ mɛ sɔŋsɔŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pɔɔl kyaŋsɩ hʋ aa basɩ gɛɛ, ʋ sɩya gballɩ, Pɔɔl kaŋ baala hʋ banaa mʋ, ba buloŋ pɩɩsɩ ba bisiŋ ta aŋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ. Ka ʋ daga Gyuuma wɩɩkyʋwal sɩlaala kyɛyɛ mɔɔgɛɛ ba aa sɩ pɩɩsɩ ba bisiŋ ta, ka dɩ ba kɩdɩgɩ buloŋ na kpa kɩna sʋla Wɩɩsɩ. Kyɛyɛ bapɛ rɛ ʋ daga ba. ");
INSERT INTO sig_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kyɛyɛ bapɛ hʋ aa ko dɩ ʋ pele, Gyuuma badɔmɔŋ aa lɩɩ Esɩya paalʋʋ na Pɔɔl dɩ ʋ we Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ. Ba mʋrɩ nɩgyamaa we ba mʋ kaŋ Pɔɔl. ");
INSERT INTO sig_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nyɛ rɛ ba kyiyesi yʋga a baa, “Iziral tɩmma, ma ko pɛ á tɩyaŋ. Baal no aa gɔllɩ kɩ kyogi Iziral tɩmma ŋmanɩɩ hʋ rɛ, abee mɩrɩsɩ hʋ Moosi aa saba biŋ dɩ á kɩ tɩŋa, aŋ ha bɩl basɩ wɩbɔmɔ mɛ a mʋ kɩ tile Wɩɩkyʋwaldɩɩbal no tɩyaŋ. Ʋ baa dɩ ba kɩdɩgɩ buloŋ bɩ kaŋ tɔnɔ. Ma na ʋ rɛ nyɛ. Giriki tɩmma hʋ aa bɩ maga dɩ ba gyʋʋ á Wɩɩkyʋwaldɩɩbal hʋ, ba aa rɛ ʋ kaŋ ko gyʋʋ gɛɛ. Nyɛ yaa bisiŋ nɛ á lesiri tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wɩɩ hʋ aa tɩŋ ba basɩ gɛɛ rɛ nyɛ: Ba fa naa Ɛfiso tɩmma baal kɩdɩgɩ ba aa yɩrɩ Turofimɔsɩ rɛ dɩ ʋ aa tɩŋ Pɔɔl hal bee hʋ tɩyaŋ. Ba kɛ fa liise anɩɩ Pɔɔl kana ʋ gyʋʋ Wɩɩkyʋwaldɩɩbal hʋ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɛɛ rɛ bee hʋ nala buloŋ laa taawɛɛ, nala hʋ buloŋ sii tɩŋ dɔmɔŋ a kaŋ Pɔɔl tarɩ lɩɩ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ, aŋ kaŋ dimbeye hʋ tɔ haŋ lagɩlagɩbiye hʋ. ");
INSERT INTO sig_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ba aa lʋga dɩ ba kpʋ ʋ gɛɛ rɛ, Roma laalyuwolo nɩhɩyawʋ hʋ nɩɩ anɩɩ taawɛɛ rɛ sii Gyerusalɛm buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɛɛ rɛ ʋ sii lɩɩ laalyuwolo hʋ badɔmɔŋ abee ba nɩhɩyasɩ haŋ lagɩlagɩbiye hʋ a pɛ ʋ tɩyaŋ, ba fá mʋ lee hʋ ba aa yaa taawɛɛ hʋ. Nala hʋ aa naa dɩ ʋ bee laalyuwolo hʋ aa ko gɛɛ, ba bɩl bɩ ŋmaa Pɔɔl. ");
INSERT INTO sig_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Laalyuwolo nɩhɩyawʋ hʋ mʋ kaŋ Pɔɔl, a leŋ ba kaŋ kyɔrʋmɔ balɩya vʋwa ʋ. Ɛɛ rɛ ʋ pɩyɛsɩ nala hʋ a baa, “Kɩbee rɛ yaa nal no tɩɩna? Bekiŋ wɩɩ rɛ ʋ yaa kyogi?” ");
INSERT INTO sig_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ɛɛ rɛ ba buloŋ kɩ yaa kyagɩŋsɩ, ba badɔmɔŋ baa nyɛ rɛ, badɔmɔŋ mɛ baa dɩ ɛɛ daa, dɩ nyɛ rɛ. Nala hʋ fa aa yaa kyagɩŋsɩ gɛɛ, laalyuwolo nɩhɩyawʋ hʋ bɩ gyɩŋ wɩɩ hʋ buloŋ aa paalɩ tɩŋ ba kɩ yaa gɛɛ. Ɛɛ rɛ ʋ leŋ ʋ nala hʋ kaŋ Pɔɔl mʋ we laalyuwolo dɩɩduwo hʋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ba aa mʋ pele dɩya hʋ lɩtɩŋgyɩnɩɩ, nala hʋ kaŋ Pɔɔl kɩ tarɩ a kɩ lʋga dɩ ba kpʋ ʋ. Ɛɛ rɛ laalyuwolo hʋ kpa ʋ kyʋŋ. ");
INSERT INTO sig_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nala hʋ buloŋ tɩŋa ʋ hal aŋ yaa kyagɩŋsɩ kɩ basɩ, “Ma kpʋ ʋ.” ");
INSERT INTO sig_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Saŋa hʋ ba aa gyɩŋ sal hʋ a kɩ kyɛ dɩ ba gyʋʋ dɩya hʋ, Pɔɔl sʋl laalyuwolo nɩhɩyawʋ hʋ a baa dɩ ʋ leŋ dɩ ʋ basɩ wɩɩ tɩya ʋ. Nyɛ rɛ laalyuwolo nɩhɩyawʋ hʋ pɩyɛsɩ Pɔɔl a baa, “Ɛɛ kɛ ɩ aa nɩɩ Giriki taal lɛ? ");
INSERT INTO sig_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ɩ daa yaa Igyipiti tɩmma baal hʋ gyɩ aa piile kɩ laa taawɛɛ aŋ kaŋ nala tusibʋnaa hʋ aa kpʋ nala a kaŋ mʋ pogo tʋtʋʋ tɩyaŋ gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔl baa, “Aayɩ, ŋ yaa gyuu rɛ a lɩɩ Taasu, Silisɩya paalʋʋ tɔbal hʋ. Ŋ aa sʋla ɩ rɛ dɩ ɩ leŋ dɩ ŋ basɩ wɩya tɩya nala no.” ");
INSERT INTO sig_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ɛɛ rɛ laalyuwolo nɩhɩyawʋ hʋ tɩya ʋ ŋmanɩɩ. Pɔɔl sɩŋ dɩya hʋ saŋgyɩŋ hʋ tɩyaŋ, aŋ kaŋ ʋ nosi viri dɩ nala hʋ buloŋ leŋ kyagɩŋsɩ. Ɛɛ rɛ ba buloŋ yaa fʋɩɩ, ka Pɔɔl piili kɩ basɩ wɩya Gyuuma taal tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Doŋ nɛ ʋ basɩ tɩya ba a baa, “Ŋ kuwoma abee ŋ naabalɩya, ma gyegili nɩɩ wɩɩ hʋ ŋ aa kana dɩ ŋ basɩ laa ŋ tɩɩ.” ");
INSERT INTO sig_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ba aa nɩɩ dɩ Pɔɔl basɩ wɩya ba tɩɩ taal tɩyaŋ gɛɛ, ba buloŋ yaa fʋɩɩ. Ɛɛ rɛ Pɔɔl basɩ tɩya ba a baa, ");
INSERT INTO sig_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ŋ yaa gyuu rɛ. Taasu aa we Silisɩya paalʋʋ tɩyaŋ nɛ ba lʋla ŋ. Ŋ gyɩ yaa haŋbiye rɛ ka ba kana ŋ ko Gyerusalɛm daha, ŋ waa daha tɩyaŋ. Gamaliyɛl rɛ dɩyɛsɩ ŋ. Ʋ gyɩ daga ŋ á naabaala lesiri abee ba ŋmaŋsɩ buloŋ nɛ abee sɩfɩyasɩ. Wɩya hʋ ʋ aa daga ŋ, ŋ mɛ gyɩ kpaa ba tɩŋ Wɩɩsɩ rɛ abee ŋ tɩya buloŋ, anɩɩ ma kɩdɩgɩ buloŋ aa we daha gyɩnaŋ. ");
INSERT INTO sig_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ŋ fa tɩŋ naasɩ dɔgɩsɩ nala hʋ aa tɩŋ Yesu ŋmanɩɩ hʋ rɛ kɩŋkaŋ, a gba kpʋ ba badɔmɔŋ. Ba baala abee haana buloŋ nɛ ŋ leŋ ba kasɩ vʋwa, aŋ kasɩ ba tɔ dɩɩsɩ tɩyaŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ abee nɩhɩyasɩ hʋ buloŋ aa laŋŋa daha sɩ wuwo basɩ tɩya ma anɩɩ wɩɩ no ŋ aa basɩ yaa wɩtɩɩ rɛ. Ba gyɩ sabɩ teŋ tɩya ŋ nɛ dɩ ŋ kaŋ mʋ Damaasiku a tɩya Gyuuma hʋ aa we doŋ. Ba gyɩ yaa gɛɛ rɛ dɩ ŋ wuwo kasɩ nala hʋ buloŋ aa laa Yesu wɩya di Damaasiku tɩyaŋ, a vʋwa ba a kaŋ ko Gyerusalɛm daha, dɩ ba dɔgɩsɩ ba.” ");
INSERT INTO sig_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ɛɛ rɛ Pɔɔl bɩl baa, “Ŋ aa lɩɩ kpa Damaasiku ŋmanɩɩ kɩ mʋ, a ko kpaga bee hʋ anɩɩ wɩɩhaa saŋa gɛɛ sek, pʋlʋŋbal kɩdɩgɩ pirigi lɩɩ wɩɩsɩnyuu a kyaanɩ we ŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ŋ tuu tele taŋha aŋ nɩɩ nal taal dɩ ʋ aa basɩ wɩya ŋ lee a baa, ‘Sɔɔl, Sɔɔl! Bee rɛ tɩŋ ɩ kɩ dɔgɩsɩ ŋ nyɛ?”’ ");
INSERT INTO sig_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ɛɛ rɛ ŋ mɛ pɩyɛsɩ, “Kɩbee rɛ yaa ɩ, ŋ Tɩɩna?” Taal hʋ basɩ baa, “Mɩyaŋ nɛ yaa Yesu aa lɩɩ Nazarɛti, nal hʋ ɩ aa dɔgɩsɩ hʋ.” ");
INSERT INTO sig_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ŋ bee nala hʋ fa aa val hʋ, ba gyɩ naa kyaanʋʋ hʋ rɛ aŋ fa bɩ nɩɩ nal hʋ aa basɩ wɩya ŋ lee taal. ");
INSERT INTO sig_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ɛɛ rɛ ŋ pɩyɛsɩ, “Ŋ Tɩɩna, ŋ yaa bee?” Ŋ Tɩɩna bɩl basɩ baa, “Sii mʋ Damaasiku. Doŋ tɩyaŋ nɛ ba sɩ daga ɩ wɩɩ hʋ Wɩɩsɩ aa lɩɩ ɩ dɩ ɩ yaa.” ");
INSERT INTO sig_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pʋlʋŋ hʋ aa kyʋʋlɩ ŋ sɩya gɛɛ, ŋ bɩl bɩ wuwo dɩ ŋ na. Ɛɛ rɛ ŋ bee nala hʋ fa aa val hʋ kaŋ ŋ noŋ tɩyaŋ a tarɩ ŋ mʋ Damaasiku. ");
INSERT INTO sig_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Baal kɩdɩgɩ rɛ fa we doŋ ba kɩ yɩrɩ Ananiyasɩ. Ʋ fa aa fá Wɩɩsɩ rɛ kɩŋkaŋ aŋ fa kɩ tɩŋ mɩrɩsɩ hʋ Moosi fa aa saba biŋ dɩ nala kɩ tɩŋa mɛ. Gyuuma hʋ buloŋ aa we Damaasiku tɩyaŋ fa aa tɩya ʋ gyɩrɩma rɛ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɛɛ rɛ ʋ ko sɩŋ ŋ logiŋ tɩyaŋ a basɩ tɩya ŋ a baa, “Ŋ naabiye Sɔɔl, kaŋ ɩ sɩya suri! Haŋ lagɩlagɩbiye hʋ ŋ sɩya pirigi suri, ŋ wuwo na ʋ.” ");
INSERT INTO sig_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ɛɛ rɛ Ananiyasɩ basɩ tɩya ŋ a baa, “Wɩɩsɩ hʋ á bee á naabaala aa tɩŋ, ʋ rɛ lɩɩ ɩ dɩ ɩ gyɩŋ wɩɩ hʋ ʋ aa kyɛ dɩ ɩ yaa. Ʋ leŋ ɩ na Wɩɩsɩ Tɩpʋlʋŋ tɩɩna hʋ rɛ a nɩɩ ʋ taal mɛ ʋ aa basɩ wɩya tɩya ɩ. ");
INSERT INTO sig_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ɩ sɩ yaa ʋ daŋsɩya tɩɩna, a basɩ tɩya nala wɩɩ hʋ ɩ aa nɩya aŋ pɛ na mɛ. ");
INSERT INTO sig_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bee rɛ yaŋ tɩŋ ɩ ha hɔŋ kɩ pɩɩsɩ? Sii mʋ leŋ dɩ ba fo ɩ wɩɩkyʋwalnɩɩ, a sasɩ ɩ wɩbɔmɔ buloŋ ta Yesu feŋ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ɛɛ rɛ ŋ mɩɩgɩ mʋ Gyerusalɛm a gyʋʋ wɩɩkyʋwaldɩya a kɩ kyʋwalɩ Wɩɩsɩ. Saŋa hʋ ŋ aa kyʋwalɩ Wɩɩsɩ hʋ tɩyaŋ nɛ, ");
INSERT INTO sig_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ŋ na á Tɩɩna Yesu anɩɩ duwoso tɩyaŋ gɛɛ. Ʋ basɩ tɩya ŋ a baa, “Sii lɩɩ Gyerusalɛm tɩyaŋ lagɩ, beewɩya nala hʋ aa we daha bɩ sɩ laa nyʋwa laa ŋ wɩya hʋ ɩ aa sɩ basɩ tɩya ba di.” ");
INSERT INTO sig_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nyɛ rɛ ŋ mɛ basɩ tɩya ʋ a baa, “Ŋ Tɩɩna, ba tɩɩ gyɩŋ bee baa lee hʋ kɛ buloŋ ŋ aa mʋwa, ŋ aa gyʋʋ wɩɩkyʋwaldɩɩsɩ rɛ a kasɩ nala hʋ aa laa ɩ wɩya dɩ doŋ tɩyaŋ, a ŋmaa ba aŋ kasɩ ba mʋ tɔ dɩɩsɩ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Saŋa hʋ tɩyaŋ ba aa kpʋ Sɩtɩɩvɩŋ, nal hʋ fa aa yaa ɩ daŋsɩya tɩɩna a basɩ ɩ wɩya kɩ tɩya nala, mɩyaŋ Pɔɔl tɩɩ mɛ fa we doŋ, a laa nyʋwa baa dɩ ba kpʋ ʋ. Ba gyɩ aa kpʋ ʋ hʋ tɩyaŋ mɛ, mɩyaŋ nɛ fa sɩŋ pɔ nala no gannɩ ba fa aa wire biŋ, aŋka ba kpʋ ʋ.” ");
INSERT INTO sig_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nyɛ rɛ ŋ Tɩɩna basɩ tɩyaŋ a baa, “Sii daha, ŋ sɩ tɩma ɩ dɩ ɩ mʋ libolii, nala hʋ aa bɩ yaa Gyuuma lee.” ");
INSERT INTO sig_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pɔɔl fa aa basɩ wɩya hʋ gɛɛ, nala hʋ buloŋ nɛ fa gyegile kɩ nɩɩ. Amɛ ʋ aa ko basɩ wɩɩ no, ba bɩl piili kɩ yaa kyagɩŋsɩ a baa, “Ma kpʋ nɩtɔɔ no, ʋ bɩ maga dɩ ʋ we dʋnɩya no tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ka ba kɩ yaa kyagɩŋsɩ, aŋ kaŋ ba gannɩ kɩ pigisi aŋ yaa taŋha kɩ yuwo. ");
INSERT INTO sig_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nyɛ rɛ Roma laalyuwolo nɩhɩyawʋ basɩ baa dɩ laalyuwolo hʋ kaŋ Pɔɔl gyʋʋ laalyuwolo dɩɩduwo hʋ. Ʋ baa dɩ ba vɩɩrɩ ʋ aŋ pɩyɛsɩ na wɩɩ hʋ aa tɩŋ nala no buloŋ lɩɩ ʋ hal aŋ kɩ yaa kyagɩŋsɩ nyɛ. ");
INSERT INTO sig_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nyɛ rɛ ba vʋwa ʋ dɩ ba vɩɩrɩ. Saŋa hʋ ba aa yaa siri dɩ ba vɩɩrɩ Pɔɔl hʋ rɛ ʋ pɩyɛsɩ laalyuwolo nɩhɩyawʋ hʋ fa aa sɩŋ doŋ a baa, “Ʋ yaa ŋmanɩɩ rɛ dɩ ba vɩɩrɩ nal hʋ aa yaa Roma tɩɩna rɛ, dɩ ba bɩ dii ʋ sarɩya a daga ʋ wɩkyogii koo?” ");
INSERT INTO sig_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ʋ aa nɩɩ wɩɩ hʋ Pɔɔl aa basa, ɛɛ rɛ ʋ mɛ mɩɩgɩ mʋ ʋ nɩhɩyawʋ hʋ lee a basɩ tɩya ʋ baa, “Deŋ na wɩɩ hʋ ɩ aa kyɛ dɩ ɩ yaa, baal hʋ yaa Roma tɩɩna rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nyɛ rɛ laalyuwolo nɩhɩyawʋ hʋ tɩɩ sii kpa mʋ Pɔɔl lee a pɩyɛsɩ ʋ, “Ɩ yaa Roma tɩɩna rɛ? Basɩ tɩya ŋ.” Ɛɛ rɛ Pɔɔl baa dɩ waa. ");
INSERT INTO sig_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Laalyuwolo nɩhɩyawʋ hʋ mɛ basɩ baa, “Ŋ mɛ yaa kɩdɩgɩ rɛ. Ŋ kɛ ta tuŋ molbiye rɛ yʋga aŋ na ko yaa Roma tɩɩna.” Ɛɛ rɛ Pɔɔl baa, “Ba paalɩ lʋla ŋ ŋ yaa Roma tɩɩna rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nyɛ rɛ nala hʋ fa aa kyɛ dɩ ba vɩɩrɩ Pɔɔl aŋ pɩyɛsɩ ʋ wɩya hʋ buloŋ mɩɩgɩ fasɩ kɩ lɩɩ hal mʋhʋ mʋhʋ. Laalyuwolo nɩhɩyawʋ hʋ aa ko gyɩma anɩɩ Pɔɔl yaa Roma tɩɩna rɛ, ka ʋ leŋ ba kaŋ kyɔrʋmɔ vʋwa ʋ gɛɛ, kambɩŋ mɩɩgɩ kana ʋ mɛ tɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ɛɛ rɛ laalyuwolo nɩhɩyawʋ hʋ kɩ kyɛ dɩ ʋ kɔnɩ gyɩŋ wɩɩ hʋ aa tɩŋ Gyuuma hʋ kɩ basɩ Pɔɔl wɩya. Ʋ sɩya aa gballa, ʋ leŋ ba kana ʋ puri, a leŋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ abee nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ buloŋ ko laŋŋɩ. Ba aa laŋŋa ko teŋ, ʋ kaŋ Pɔɔl lɩɩ sɩgɩ ba sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔl fa aa sɩŋ ba sɩya tɩyaŋ gɛɛ rɛ, ka ʋ sɩya buloŋ fa pɔ nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ tɩyaŋ. Ɛɛ rɛ ʋ basɩ tɩya ba a baa, “Ŋ kuwobalɩya, ŋ tɩŋ Wɩɩsɩ rɛ ŋ mɩɩbol buloŋ tɩyaŋ. Ɛɛwɩya, a kaŋ kɩ ko gyɩnaŋ sɩgballɩya no, ŋ hakɩla bɩ daga ŋ anɩɩ ŋ yaa wɩɩ kɩdɩgɩ buloŋ kyogi rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ɛɛ rɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ ba aa yɩrɩ Ananiyasɩ basɩ tɩya nala hʋ aa sɩŋ kpaga Pɔɔl, a baa dɩ ba ŋmaa ʋ kyaŋkpaŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ba aa ŋmaa ʋ gɛɛ, Pɔɔl mɛ tʋʋsɩ ʋ a baa, “Na ʋ aa kɩɩ gɛɛ anɩɩ gyee ba aa yaa tʋwɔl bʋgɩ! Ɩ aa yaŋ leŋ ba ŋmaa ŋ nyɛ, ɛɛ tɩɩ rɛ Wɩɩsɩ mɛ sɩ ŋmaa ɩ. Na ɩ hɔnɔ dɩ ɩ kpa mɩrɩsɩ hʋ Moosi aa saba biŋ dɩ á kɩ tɩŋa rɛ, a di ŋ sarɩya, aŋka ɩ baa dɩ ba ŋmaa ŋ. Wɩya no tɩɩ daa ɩ kɩ kyogi gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nala hʋ aa sɩŋ kpaga Pɔɔl pɩyɛsɩ ʋ a baa, “Wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ daa ɩ kɩ tʋʋsɩ gɛɛ?” ");
INSERT INTO sig_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nyɛ rɛ Pɔɔl bɩl baa, “Ŋ naabalɩya, ma kɩna sʋma rɛ. Ba saba Wɩɩsɩ tenni tɩyaŋ nɛ anɩɩ ʋ bɩ maga dɩ á basɩ wɩbɔmɔ a kɩ tɩya nal hʋ aa deŋ nala. Ŋ bɩ gyɩma anɩɩ ʋ rɛ yaa á wɩɩkyʋwal sɩlaala nɩhɩyawʋ hʋ.” ");
INSERT INTO sig_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔɔl aa deŋ nala hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ tɩyaŋ, ʋ na anɩɩ ba badɔmɔŋ yaa nala hʋ ba aa yɩrɩ Sadusiima rɛ. Ba badɔmɔŋ mɛ yaa Farasiima. Nyɛ rɛ ʋ faasɩ basɩ tɩya nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya hʋ a baa, “Ŋ naabalɩya, ŋ yaa Farasii rɛ, ŋ kuwo mɛ yaa Farasii. Ŋ laa di rɛ anɩɩ nala hʋ aa sʋba sɩ mɩɩgɩ sii sʋʋ tɩyaŋ a kaŋ mɩɩbol. Ɛɛ rɛ tɩŋ ba kɩ di ŋ sarɩya gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ʋ aa basɩ wɩɩ no, nyʋʋtaaduwo gyʋʋ Farasiima hʋ abee Sadusiima hʋ, ba porigi dɔmɔŋ. ");
INSERT INTO sig_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusiima baa dɩ dɩ nal lɛ sʋba, ʋ bɩl bɩ sɩ wuwo sii sʋʋ tɩyaŋ a kaŋ mɩɩbol, aŋ bɩl basɩ baa dɩ malɩkasɩ mɛ tuwo, dɩ nɩdʋŋsɩ mɛ tuwo. Amɛ Farasiima hʋ kɛ baa dɩ wɩya no buloŋ we doŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nyɛ rɛ nala hʋ buloŋ sii a faasɩ kɩ yaa kyagɩŋsɩ. Wɩɩsɩ Teŋ dɩdagɩla hʋ badɔmɔŋ aa we Farasiima paati hʋ tɩyaŋ sii a faasɩ kaŋ wɩya hʋ kɩ tarɩ a baa, “Á kɛ bɩ naa wɩɩ hʋ baal no aa yaa kyogi. Dɩ nɩdɩma koo malɩka rɛ kɔnɩ basɩ wɩya hʋ tɩya ʋ, á bɩ sɩ wuwo gyɩma.” ");
INSERT INTO sig_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nyɛ rɛ ba marɩ kaŋ wɩɩ hʋ kɩ kpa dɔmɔŋ, lee hʋ buloŋ nɩma. Kambɩŋ kaŋ laalyuwolo nɩhɩyawʋ hʋ anɩɩ ba sɩ kaŋ Pɔɔl tarɩ pʋ̃ʋ̃. Ɛɛ rɛ ʋ leŋ ʋ laalyuwolo hʋ gyʋʋ nala hʋ tɩyaŋ a lorigi laa Pɔɔl, a kana ʋ kaŋ mʋ laalyuwolo dɩɩduwo hʋ. ");
INSERT INTO sig_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lee aa ko bɩl, haŋ tebine hʋ tɩɩ á Tɩɩna Yesu ko Pɔɔl lee, a sɩŋ ʋ logiŋ, aŋ basɩ tɩya ʋ a baa, “Kana ɩ tɩɩ. Ʋ maga dɩ ɩ di ŋ daŋsɩya rɛ a basɩ ŋ wɩya Roma tɩyaŋ anɩɩ ɩ aa basɩ ŋ wɩya Gyerusalɛm tɩyaŋ gɛɛ.” ");
INSERT INTO sig_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ʋ sɩya aa gballa, Gyuuma badɔmɔŋ laŋŋɩ dɔmɔŋ a kɩ vʋʋlɩ dɩ ba kpʋ Pɔɔl. Ba ŋmɩyɛsa rɛ anɩɩ dɩ ba aa rɛ ko bɩ kpʋ ʋ, ba bɩ sɩ di kɩna, a bɩ sɩ nyʋwa nɩɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nala hʋ fa aa hɔŋ vʋʋlɩ wɩɩ no fa tee nala mɔllɩbalɩya. ");
INSERT INTO sig_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɛɛ rɛ ba sii mʋ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ abee bee hʋ nɩhɩyasɩ lee a basɩ tɩya ba a baa, “Á ŋmɩyɛsa rɛ anɩɩ dɩ ámaa rɛ ko bɩ kpʋʋ Pɔɔl, á bɩ sɩ di kɩna koo a nyʋwa nɩɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ɛɛwɩya, ma bee nala hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya nɩhɩyasɩ, ma tɩma dɩ ba mʋ basɩ tɩya Roma laalyuwolo nɩhɩyawʋ hʋ dɩ ʋ leŋ dɩ Pɔɔl ko ma lee. Ma fugo baa dɩ ma aa kyɛ dɩ ma marɩ pɩyɛsɩ ʋ weliŋ nɛ, a gyɩŋ wɩɩ hʋ ʋ kɔnɩ aa yaa. Á sɩ yaa siri, dɩ ʋ rɛ leŋ dɩ ʋ kɩ ko, ʋ bɩ sɩ pele ma lee, ka dɩ á kpʋ ʋ ŋmanɩɩ tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɛɛ rɛ Pɔɔl dɩya toluu biibaal mɛ nɩɩ ba aa vʋʋlɩ wɩɩ hʋ. Ɛɛ rɛ ʋ sii mʋ gyʋʋ laalyuwolo dɩɩduwo hʋ, a basɩ wɩɩ hʋ tɩya Pɔɔl. ");
INSERT INTO sig_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nyɛ rɛ Pɔɔl yɩrɩ laalyuwolo nɩhɩyasɩ hʋ kɩdɩgɩ a basɩ tɩya ʋ a baa, “Kaŋ bapʋwasɩbiye no mʋ ma nɩhɩyawʋ hʋ lee, ʋ kaŋ wɩɩ rɛ dɩ ʋ basɩ tɩya ʋ.” ");
INSERT INTO sig_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ɛɛ rɛ ʋ kana ʋ mʋ ba nɩhɩyawʋ hʋ lee a basɩ tɩya ʋ a baa, “Pɔɔl, nal hʋ ba aa kaŋ tɔ dɩya hʋ tɩyaŋ nɛ yɩrɩ ŋ a basɩ tɩya ŋ baa dɩ ŋ kaŋ bapʋwasɩbiye no ko ɩ lee, dɩ ʋ kaŋ wɩɩ rɛ dɩ ʋ basɩ tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ɛɛ rɛ nɩhɩyawʋ hʋ kaŋ biye hʋ noŋ tɩyaŋ, ba fasɩ lɩɩ mʋhʋ, ʋ fɩyɛlɩ pɩyɛsɩ ʋ dɩ wɩbee rɛ ʋ kana dɩ ʋ basɩ tɩya ʋ? ");
INSERT INTO sig_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ɛɛ rɛ ʋ baa, “Gyuuma nɩhɩyasɩ vʋʋla rɛ dɩ ba basɩ tɩya ɩ dɩ ɩ kyiye leŋ dɩ Pɔɔl ko nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya lee. Ba sɩ fugo baa dɩ ba aa kyɛ dɩ ba marɩ pɩyɛsɩ ʋ weliŋ nɛ a gyɩŋ wɩɩ hʋ ʋ kɔnɩ aa yaa. ");
INSERT INTO sig_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amɛ ta laa nyʋwa, beewɩya nala hʋ badɔmɔŋ sɩ faŋa ŋmanɩɩ tɩyaŋ a kɩ pɔ ʋ. Ba tee baala mɔllɩ balɩya. Ba ŋmɩyɛsa rɛ anɩɩ dɩ ba aa rɛ ko bɩ kpʋ Pɔɔl, ba bɩ sɩ di kɩna a bɩ sɩ nyʋwa nɩɩ mɛ. Ba kɛ yaa ba siri rɛ dɩ ɩ rɛ ko tɩya ʋ ŋmanɩɩ dɩ ʋ ko.” ");
INSERT INTO sig_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ʋ aa basɩ gɛɛ ko teŋ, nɩhɩyawʋ hʋ basɩ tɩya bapʋwasɩbiye hʋ baa, “Ta ko basɩ wɩɩ no ɩ aa basɩ tɩya ŋ, a tɩya nal buloŋ.” Ɛɛ rɛ ka ʋ ta biye hʋ, ʋ mʋ. ");
INSERT INTO sig_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nyɛ rɛ laalyuwolo nɩhɩyawʋ hʋ yɩrɩ ʋ laalyuwolo nɩhɩyasɩ balɩya a basɩ tɩya ba a baa, “Ma lɩɩ laalyuwolo kɔɔsɩbalɩya dɩ ba yaa siri dɩ ba bee Pɔɔl mʋ Sizaariya, a pɛ gyagyɩnna mɔllɩboto bee fi tɩyaŋ, abee tiŋ-yuwolo kɔɔsɩbalɩya. Ma leŋ dɩ ba yaa siri, a lɩɩ tebine no kerifi nibi saŋa. ");
INSERT INTO sig_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ma kyɛ gyaagʋ tɩya Pɔɔl dɩ ʋ mɛ gyɩŋ, a kana ʋ weliŋ a kaŋ mʋ Sizaariya, a kana ʋ mʋ we Roma nɩhɩyawʋ hʋ aa deŋ paalʋʋ hʋ ba kɩ yɩrɩ Fɛlisi nosi tɩyaŋ.” ");
INSERT INTO sig_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ɛɛ rɛ ka laalyuwolo nɩhɩyawʋ hʋ sabɩ teŋ a tɩya ba dɩ ba kaŋ mʋ tɩya Fɛlisi wɩɩ no wɩya. Nyɛ rɛ ʋ basɩ we teŋ hʋ tɩyaŋ: ");
INSERT INTO sig_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mɩyaŋ Kilodiyasi Lisiyasɩ rɛ sabɩ teŋ no kɩ tɩya ɩ, ŋ nɩhɩyawʋ kuwori Fɛlisi. Ŋ aa kyʋwalɩ ɩ weliŋ. ");
INSERT INTO sig_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Baal no ŋ aa leŋ ba kaŋ kɩ ko ɩ lee nyɛ, Gyuuma rɛ fa kana ʋ dɩ ba kpʋ. Ba aa kyɛ dɩ ba yaa ɛɛ hʋ tɩyaŋ nɛ, ŋ nɩɩ anɩɩ ʋ yaa Roma tɩɩna rɛ. Nyɛ rɛ ŋ kaŋ ŋ laalyuwolo mʋ, á lorigi laa ʋ ba nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ŋ fa aa kyɛ dɩ ŋ gyɩŋ wɩɩ hʋ ʋ aa yaa kyogi rɛ. Nyɛ rɛ ŋ kana ʋ mʋ ba nɩhɩyasɩ hʋ aa hɔŋ kɩ vʋʋlɩ wɩya lee. ");
INSERT INTO sig_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ba aa pɩyɛsɩ ʋ wɩya hʋ tɩyaŋ, ŋ na anɩɩ ʋ bɩ kyogo wɩɩ buloŋ a maga dɩ ba kpʋ ʋ, koo dɩ ba kana ʋ tɔ dɩya tɩyaŋ. Wɩɩ hʋ ba aa baa dɩ ʋ yaa kyogi mɩɩgɩ mʋ kɩ tile ba tɩɩ sɩŋsɩ tɩyaŋ nɛ. ");
INSERT INTO sig_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ba basɩ tɩya ŋ anɩɩ Gyuuma badɔmɔŋ vʋʋla rɛ dɩ ba kpʋ ʋ. Ɛɛ rɛ tɩŋ ŋ baa dɩ ba kana ʋ ko tɩya ɩ lagɩ. Ka ŋ yaŋ basɩ tɩya ba anɩɩ ba ko ɩ lee, a daga wɩɩ hʋ ʋ aa yaa kyogi ba, a tɩya ɩ.” ");
INSERT INTO sig_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ʋ aa sabɩ teŋ hʋ ko teŋ, laalyuwolo hʋ kɔnɩ yaa gɛɛ hʋ ʋ aa basɩ tɩya ba dɩ ba yaa rɛ. Haŋ tebine hʋ buloŋ, ba kaŋ Pɔɔl mʋ pele tɔɔ kɩdɩgɩ ba kɩ yɩrɩ Aŋtipaatirisi. ");
INSERT INTO sig_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ʋ sɩya aa gballa, laalyuwolo hʋ aa val naasɩ hʋ, mɩɩgɩ ko ba dɩɩduwo hʋ, aŋka gyagyɩnna hʋ kana ʋ mʋ Sizaariya. ");
INSERT INTO sig_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ba aa mʋʋ pele doŋ, ba kpa Pɔɔl tɩya ba paalʋʋ hʋ didenni hʋ aŋ kpa teŋ hʋ mɛ pɛ tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nyɛ rɛ Fɛlisi karɩmɩ teŋ hʋ ko teŋ, aŋ mɩɩgɩ pɩyɛsɩ Pɔɔl lee hʋ ʋ aa lɩya. Ɛɛ rɛ ʋ baa dɩ ʋ lɩɩ Silisɩya paalʋʋ rɛ. Ʋ aa nɩɩ gɛɛ, ");
INSERT INTO sig_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ʋ basɩ tɩya ʋ a baa, “Dɩ ɩ nala hʋ rɛ ko ko, ŋ sɩ nɩɩ wɩɩ hʋ ɩ aa kana dɩ ɩ basɩ, aŋka dɩ ŋ na di ɩ sarɩya.” Ɛɛ rɛ ka ʋ leŋ ba kaŋ Pɔɔl mʋ we kuwori Hɛrɔtɩ aa saa ʋ dɩya hʋ tɩyaŋ, a leŋ laalyuwolo kɩ pɔ ʋ doŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ʋ kyɛyɛ bɔnɔŋ hal tɩyaŋ nɛ Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyawʋ ba aa yɩrɩ Ananiyasɩ abee bee hʋ nɩhɩyasɩ badɔmɔŋ abee sarɩdiil kɩdɩgɩ ba aa yɩrɩ Tɛɛtulusi, sii kpa mʋ Sizaariya, dɩ ba na Roma nɩhɩyawʋ Fɛlisi. Ba mʋ kpa wɩya hʋ ba aa baa dɩ Pɔɔl kyogo, a biŋ Fɛlisi sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tɛɛtulusi rɛ ba gyɩ laa sɩya yɩrɩ dɩ ʋ ko lɩɩ daga wɩɩ hʋ Pɔɔl aa kyogo. Nyɛ rɛ ʋ piili a baa, “Ŋ nɩhɩyawʋ, ɩ wɩgyʋŋ nyuniŋ, ɩ wuwo kɩ deŋ á paalʋʋ no weliŋ nɛ, a leŋ á hɔŋ abee laaŋfɩya. Ɩ bɩl marɩ wɩya mɛ rɛ yʋga á paalʋʋ no tɩyaŋ, ba yaa wɩweliye tɩya ma. ");
INSERT INTO sig_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Wɩya no buloŋ nyuniŋ, nal nal buloŋ teŋ fɩyɛla rɛ weliŋ paalʋʋ no logiŋ buloŋ tɩyaŋ. Ɛɛwɩya, á aa kyʋwalɩ ɩ rɛ kɩŋkaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ŋ bee kyɛ dɩ ŋ basɩ wɩgyamaa. Ŋ yaŋ aa sʋla ɩ rɛ dɩ ɩ di kenyiri aŋ gyegili nɩɩ wɩɩ hʋ á aa kana dɩ á basɩ. Wɩɩ hʋ á aa kyɛ dɩ á basɩ hʋ mɛ, á sɩ kaŋ keri kɩkuu. ");
INSERT INTO sig_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Á naa dɩ baal no yaa wɩweel lɛ. Gyuuma aa we dʋnɩya logiŋ buloŋ tɩyaŋ, ʋ aa mʋ doŋ nɛ, a kaŋ ba we ba kɩ kaa kaasɩ. Ʋ mɛ rɛ yaa Nazarɛti tɩmma paati hʋ sɩlaal. ");
INSERT INTO sig_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ʋ fa aa kyɛ dɩ ʋ yaa bisiŋ wɩya rɛ Wɩɩkyʋwaldɩya hʋ tɩyaŋ. Ɛɛ rɛ á kana ʋ, a fa kɩ kyɛ dɩ á di ʋ sarɩya á naabaala lesiri tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ɛɛ rɛ laalyuwolo nɩhɩyawʋ hʋ ba aa yɩrɩ Lisiyasɩ ko nyasa, a kana ʋ lorigi laa á nosi tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ʋ rɛ basɩ tɩya á nala hʋ buloŋ aa basɩ Pɔɔl wɩya dɩ á ko ɩ lee a basɩ tɩya ɩ wɩɩ hʋ aa tɩŋ á kɩ basɩ ʋ wɩya. Dɩ ɩ rɛ pɩyɛsɩ baal no, ɩ tɩɩtɩɩ mɛ sɩ gyɩma anɩɩ wɩya hʋ buloŋ á aa basa a mʋ kɩ tile ʋ tɩyaŋ yaa wɩtɩɩ rɛ.” ");
INSERT INTO sig_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nyɛ rɛ Gyuuma hʋ buloŋ sii sɩŋ pɛ, a basɩ baa dɩ wɩya hʋ buloŋ Tɛɛtulusi aa basa kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ɛɛ rɛ paalʋʋ hʋ didenni hʋ tɩya Pɔɔl mɛ ŋmanɩɩ dɩ ʋ mɛ ko lɩɩ basɩ wɩɩ hʋ ʋ aa kana. Ɛɛ rɛ Pɔɔl baa, “Ŋ tɩɩ gyɩma rɛ anɩɩ ɩ aa di sarɩya taŋha no tɩyaŋ ʋ bɩsɩ bɩ kpaga daha. Ŋ teŋ yaŋ fɩyɛla rɛ abee ŋ aa sɩ basɩ wɩya a laa ŋ tɩɩ ɩ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɩ tɩɩ sɩ wuwo pɩyɛsɩ na, anɩɩ saŋa hʋ ŋ aa ko mʋ Gyerusalɛm dɩ ŋ kyʋwalɩ Wɩɩsɩ, ʋ ha bɩ para kyɛyɛ fi abee balɩya. ");
INSERT INTO sig_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Gyuuma bɩ naa dɩ ŋ bee ba bee nal buloŋ kaŋ wɩya kɩ kpa dɔmɔŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ. Ba mɛ bɩl bɩ naa dɩ ŋ we kaasɩ wɩɩkyʋwaldɩɩsɩ tɩyaŋ mɛ koo lee kɩdɩgɩ buloŋ tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wɩɩ buloŋ tuwo ba aa sɩ wuwo kpa daga anɩɩ wɩya hʋ ba aa baa dɩ ŋ yaa kyogi mɛ kɔnɩ yaa wɩtɩɩ rɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wɩɩ hʋ ŋ aa sɩ basɩ tɩya ɩ anɩɩ ʋ yaa wɩtɩɩ rɛ nyɛ: Ŋ kɛ gyɩma anɩɩ ŋmanɩɩ no ŋ aa tɩŋ nyɛ, á naabaala Wɩɩsɩ hʋ rɛ ŋ kɩ kyʋwalɩ gɛɛ. Beewɩya, mɩrɩsɩ hʋ buloŋ Moosi aa biŋ tɩya ma, abee wɩya hʋ buloŋ Wɩɩsɩ tɩŋdaala aa saba, ŋ mɛ laa ba buloŋ dɩ rɛ. Amɛ ba kɛ baa dɩ ŋmanɩɩ hʋ ŋ aa tɩŋ hʋ yaa wɩnyɩyɛl lɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ŋ mɛ laa di rɛ anɩɩ Wɩɩsɩ sɩ kyisi niweliye abee nɩbɔmɔ buloŋ sʋʋ tɩyaŋ anɩɩ nala no buloŋ aa sɩŋ daha mɛ aa laa di gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ŋ aa lʋgɩ rɛ saŋa buloŋ dɩ ŋ gyɩma ŋ hakɩla tɩyaŋ anɩɩ ŋ bɩ kaŋ wɩkyogii buloŋ Wɩɩsɩ abee nihuwobiŋ sɩya tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ŋ lɩɩ Gyerusalɛm tɩyaŋ pɩɩsɩ rɛ, a pel bɩŋgyamaa, aŋ na mɩɩgɩ mʋ doŋ, dɩ ŋ kaŋ kɩna mʋ tɩya ŋ nala ka dɩ ŋ pɛ kpʋ pʋsɩ tɩya Wɩɩsɩ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ɛɛ tɩyaŋ nɛ ba na ŋ Wɩɩkyʋwaldɩɩbal hʋ tɩyaŋ. Saŋa hʋ tɩyaŋ ba aa naa ŋ dɩ ŋ pɩɩsɩ ŋ bisiŋ teŋ nɛ. Nɩgyamaa mɛ daa ŋ kaŋ gyʋʋ doŋ. Ŋ bɩ wee kaasɩ buloŋ mɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Gyuuma badɔmɔŋ mɛ aa lɩɩ Esɩya paalʋʋ mɛ rɛ fa we doŋ. Dɩ ba aa rɛ fa kaŋ wɩɩ buloŋ abeel-ŋ, ʋ fa maga dɩ ba tɩɩ ko basɩ rɛ daha tɩyaŋ. ");
INSERT INTO sig_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Dɩ ɛɛ mɛ ko daa, leŋ dɩ nala no aa we daha basɩ wɩɩ hʋ ba mɛ aa naa dɩ ŋ yaa kyogi, saŋa hʋ ba aa kana ŋ mʋ nɩhɩyasɩ hʋ aa laŋŋɩ kɩ vʋʋlɩ wɩya sɩya. ");
INSERT INTO sig_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Wɩɩ hʋ buloŋ ŋ aa yaa rɛ nyɛ: Ba sɩya tɩyaŋ, ŋ fa nɔsɔ basɩ tɩya ba rɛ a baa, ‘Gyɩnaŋ ma aa di ŋ sarɩya rɛ, dɩ ma kpa kyogisi tɩya ŋ, akuu ŋ aa laa di anɩɩ sʋʋnɩ sɩ mɩɩgɩ sii sʋʋ tɩyaŋ a kaŋ mɩɩbol wɩya.”’ ");
INSERT INTO sig_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fɛlisi aa nɩɩ gɛɛ, ʋ basɩ tɩya ba a baa, “Ma sii. See dɩ ŋ leŋ dɩ Lisiyasɩ, laalyuwolo nɩhɩyawʋ hʋ ko, ka dɩ ŋ na dɩ wɩɩ no sarɩya.” Fɛlisi fa gyɩŋ ŋmanɩɩ hʋ Pɔɔl aa tɩŋ wɩya rɛ weliŋ, ɛɛ rɛ tɩŋ ʋ basɩ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ʋ leŋ laalyuwolo hʋ kɩdɩgɩ kɩ deŋ Pɔɔl, aŋ basɩ tɩya ʋ dɩ ʋ kana ʋ tɔ aŋ leŋ dɩ ʋ kɩ na wiyese, dɩ ʋ tɩya ʋ kyaŋsɩ ŋmanɩɩ dɩ ba ko kɩ na ʋ. Dɩ ʋ rɛ aa kyɛ kɩŋ mɛ, dɩ ba wuwo pɛ ʋ tɩyaŋ abee haŋ kɩbalɩɩ hʋ. ");
INSERT INTO sig_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ʋ gyɩ bɩ pɩɩsa ka Fɛlisi bee ʋ haaŋ Durusila mɛ ko doŋ. Durusila fa yaa Gyuu rɛ. Nyɛ rɛ Fɛlisi tɩma yɩrɩ Pɔɔl dɩ ʋ ko. Pɔɔl aa ko, ʋ leŋ ʋ basɩ Yesu Krisita laadii memii a tɩya ʋ. ");
INSERT INTO sig_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pɔɔl gyɩ basɩ wɩya mɛ rɛ a mʋ kɩ tile wɩweliye yayɩ tɩyaŋ, a bee ɛɛ ɩ aa sɩ wuwo kaŋ ɩ tɩɩ, a bɩl basɩ kyɛɛ hʋ Wɩɩsɩ aa sɩ di dʋnɩya nala sarɩya wɩya mɛ. Ʋ aa basɩ wɩya no, kambɩŋ buloŋ kaŋ Fɛlisi. Ɛɛ rɛ ʋ baa dɩ ʋ leŋ mɔɔgɛɛ aŋ kɩ mʋ, dɩ amɛ dɩ ʋ rɛ ko na sɩnɩɩ, dɩ ʋ sɩ bɩl yɩrɩ ʋ. ");
INSERT INTO sig_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ʋ kɛ fa bɩɩna anɩɩ Pɔɔl sɩ kaŋ molbiye ko kpala ʋ rɛ. Ɛɛwɩya, ʋ gyɩ aa kɩ yɩrɩ ʋ bʋlɩya bʋlɩya, dɩ ba kɩ basɩ wɩya. ");
INSERT INTO sig_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ʋ bɩsɩ balɩya hal tɩyaŋ, baal kɩdɩgɩ ba aa yɩrɩ Pɔɔkɩyɔsɩ Fɛsitusi rɛ fa mɩɩgɩ ko laa Fɛlisi nyuu, a kɩ deŋ paalʋʋ hʋ. Fɛlisi fa aa kyɛ dɩ Gyuuma hʋ kyo ʋ rɛ. Ɛɛ rɛ tɩŋ ʋ gyɩ leŋ ba ha leŋ Pɔɔl nɩtɔdɩya hʋ tɩyaŋ gɛɛ. ");
INSERT INTO sig_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛsitusi aa ko laa paalʋʋ hʋ, ʋ hɔŋ Sizaariya tɩyaŋ kyɛyɛ boto rɛ aŋ sii kpa mʋ Gyerusalɛm. ");
INSERT INTO sig_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ʋ aa mʋ Gyerusalɛm gɛɛ, Gyuuma wɩɩkyʋwal sɩlaala nɩhɩyasɩ hʋ abee Gyuuma nɩhɩyasɩ buloŋ ko basɩ wɩɩ hʋ Pɔɔl aa yaa kyogi ba, a tɩya ʋ, aŋ sʋla ʋ dɩ ʋ pɛ ba tɩyaŋ, a leŋ dɩ P