﻿USE sofia;
DROP TABLE IF EXISTS sofia.shr_vpl;
CREATE TABLE shr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES shr_vpl WRITE;
INSERT INTO shr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Aha murhondêro Nnâmahanga alema amalunga n’igulu. ");
INSERT INTO shr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Igulu lyàli cingiringiri, civange, cimpinage lirhaligwêrhe oku liyôsire lirhanalimwo bici ci Mûka gwa Nnâmahanga akagiyerêra oku mîshi. ");
INSERT INTO shr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nnâmahanga aderha, erhi: «Obulangashane bubè». Obulangashane bwanaciba. ");
INSERT INTO shr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nnâmahanga abona oku obulangashane buli bwinjà. Anaberûla obulangashane n’omwizimya. ");
INSERT INTO shr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ayîrika obulangashane mûshi n’omwizimya aguyîrika budufu. Bwayira bwanaca, lwo lusiku lurhanzi. ");
INSERT INTO shr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nnâmahanga aderha, erhi: «Ecirêre cibè aha karhî k’amîshi ciberûle amîshi n’amîshi». ");
INSERT INTO shr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nnâmahanga ajira ecirêre câbà lubibi lw’amîshi gali idako n’agali enyanya ly’ecirêre. Byanacibà ntyo ");
INSERT INTO shr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nnâmahanga ayîrika ecirêre malunga. Bwayira bwanaca, lwo lusiku lwa kabiri. ");
INSERT INTO shr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nnâmahanga aderha, erhi: «Amîshi gali idako ly’ecirêre gacigushe haguma n’ahakazire habonekane». Byanacibà ntyo. ");
INSERT INTO shr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nnâmahanga ayîrika ahakazire budaka n’ecirundo c’amîshi aciyîrika nyanja. Nnâmahanga abona oku kuli kwinjà. ");
INSERT INTO shr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nnâmahanga aderha, erhi: «Obudaka bumerekwo olubala lulimwo emburho, ngasi lubero n’emirhi y’amalehe, era emera oku idaho enaleheke n’obujuru bwâyo, ngasi lubero». Byanacibà ntyo. ");
INSERT INTO shr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Idaho lyamerakwo olubala lubamwo obujuru, ngasi lubero n’emirhi eleheka n’olugemu ngasi lubero. Nnâmahanga abona oku kuli kwinjà. ");
INSERT INTO shr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Bwayira bwanaca, lwo lusiku lwa kasharhu. ");
INSERT INTO shr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nnâmahanga aderha, erhi: «Ebimole bibè omu cirêre c’emalunga lyo biberûla omûshi n’obudufu; byâbà bimanyîso by’empondo n’ecanda, ensiku n’emyâka, ");
INSERT INTO shr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","binabè bimole bimanike emalunga bya kumolekera igulu». Byanacibà ntyo ");
INSERT INTO shr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nnâmahanga ajira bimole bibiri binene, ecimole cinênênè mpu cikamoleka mûshi, n’ecimole cinyinyi mpu cikamoleka budufu, boshi n’enyenyêzi. ");
INSERT INTO shr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nnâmahanga abimanika omu cirêre c’emalunga mpu bikamolekera igulu, ");
INSERT INTO shr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","mpu binamanyise omûshi n’obudufu n’okuberûla obulangashane n’omwizimya. Nnâmahanga abona oku kuli kwinjà. ");
INSERT INTO shr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Bwayira bwanaca, lwo lusiku lwa kani. ");
INSERT INTO shr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nnâmahanga aderha, erhi: «Amîshi gadudûsemwo ebizîne n’ebinyunyi bibalale enyanya ly’igulu, embere z’ecirêre c’amalunga». ");
INSERT INTO shr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nnâmahanga alema abasimba banênênè b’omu nyanja na ngasi bizîne biyandala n’ebidûdûsa omu mîshi, bya ngasi lubero na ngasi rhunyunyi rhujira ebyûbi kushimbana n’olubero lwarhwo. Nnâmahanga abona oku kuli kwinjà. ");
INSERT INTO shr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nnâmahanga abigisha erhi: «Muyôloloke, muluge, mubumbe enyîshi n’enyanja; n’ebinyunyi biluge okw’igulu». ");
INSERT INTO shr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Bwayira bwanaca, lwo lusiku lwa karhanu. ");
INSERT INTO shr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nnâmahanga aderha, erhi: «Obudaka buvûlule ebizîne bya ngasi lubero: ensimba, ebinyâgârha n’ensimba z’erubala za ngasi lubero». Byanacibà ntyo. ");
INSERT INTO shr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nnâmahanga anacilera eby’erubala bya ngasi lubero, ebintu bishwêkwa bya ngasi lubero n’orhusimba rhw’oku idaho rhwa ngasi lubero. Nnâmahanga abona oku kuli kwinjà. ");
INSERT INTO shr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nnâmahanga aderha, erhi: «Rhujire omuntu orhushusha, orhugwerhekwo ecikebo, yewârhambula enfî z’omu nyanja n’orhunyunyi rhw’emalunga, ebishwêkwa n’eby’erubala byoshi, n’ebinyâgârha byoshi binadûdûsa oku igulu.» ");
INSERT INTO shr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nnâmahanga alema omuntu omushusha: oku nshusho ya Nnâmahanga àmulemire, àmulema mulume n’omukazi. ");
INSERT INTO shr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nnâmahanga àbagisha anababwîra, erhi: «Muburhe muluge, mubumbe igulu, mulirhambule munarhegeke enfî z’omu nyanja n’orhunyunyi rhw’emalunga, na ngasi cizîne cigera oku idaho.» ");
INSERT INTO shr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nnâmahanga ashub’iderha, erhi: «Loli oku mmuhîre ngasi lubala lujira obujuru lunali oku idaho na ngasi murhi guleheka gunajira obujuru byo byâbà biryo binyu. ");
INSERT INTO shr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Olubala nkana byo biryo mpîre ngasi c’erubala, ngasi kanyunyi k’emalunga, ngasi cigera oku idaho cinayîsa omûka». Byanacibà ntyo. ");
INSERT INTO shr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nnâmahanga abona oku ebi anajiraga biri binjà bwenêne. Bwayira bwanaca, lwo lusiku lwa kali ndarhu. ");
INSERT INTO shr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ntyo kwo amalunga n’igulu bya shwinjagwa; haguma n’ebimubà byoshi. ");
INSERT INTO shr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Erhi abà amâyûsa omukolo akazâgikola, Nyamuzinda arhamûka oku lusiku lwa kali nda, ahûmûka omu mukolo akâgijira ");
INSERT INTO shr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nyamuzinda ahûmûka oku lusiku lwa kali nda, alujira lwimâna. ");
INSERT INTO shr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yo nkomoka y’amalunga n’igulu eyo erhi bilemwa. Erhi Nyakasane Nyamuzinda ajira igulu n’amalunga, ");
INSERT INTO shr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ntà ishaka lyaliciba en’igulu, ntà lubala lwalilucimera – bulya Nyakasane Nyamuzinda arhaliciniêsa enkuba en’igulu na ntâye walicihinga obudaka ");
INSERT INTO shr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","erhi okuhuluza amîshi omu mibunda y’okudômerera obudaka-; ");
INSERT INTO shr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nyakasane Nyamuzinda abumba omuntu n’akatulo k’oku idaho, amubûhira omûka gw’obuzîne omu mazûlu, ntyo nyamutu ahinduka ciremwa cizîne. ");
INSERT INTO shr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Obwo Nyakasane Nyamuzinda arhwêra ishwa ly’amalehe e Edeni, ebushoshôkero, ahiramwo omuntu àbumbaga ");
INSERT INTO shr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nyakasane Nyamuzinda ameza oku budaka emirhi ya ngasi bûko, yakusîmîsa isù na minjà okulîbwa, yalimwo omurhi gw’obuzîne aha karhî k’ishwa n’omurhi gw’okumanya aminjà n’amabî. ");
INSERT INTO shr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kurhenga omu Edeni (ishwa ly’amasîma) olwîshi lwakâg’ihulula lwaj’idômerera ishwa, lwakacigabamwo kani lushube nyîshi ini. ");
INSERT INTO shr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Olwîshi lurhanzi ye Pishone, luhulula luzunguluke ecihugo ca Havila, era munda ebà amasholo, ");
INSERT INTO shr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","n’amasholo g’eyo garhahimwa kuyinjiha, eyo ebà n’obukù bubaya bwinjà n’ibuye ly’onice. ");
INSERT INTO shr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Olwîshi lwa kabiri luderhwa Gihoni: luhulula luzunguluke ecihugo ca Etiopiya. ");
INSERT INTO shr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Olwîshi lwa kasharhu luderhwa Tigri: luhulula ebushohokero bwa Asûru. Olwîshi lwa kani luderhwa Eufrate. ");
INSERT INTO shr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nyakasane Nyamuzinda arhôla olya muntu amuhira omu ishwa lya Edeni, mpu akalihinga analilange. ");
INSERT INTO shr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nyakasane Nyamuzinda aha omuntu eri irhegeko: «Wanalya oku ngasi murhi guli omu ishwa, ");
INSERT INTO shr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ci omurhi gw’okumanya aminjà n’amabî orhahîraga okagulyâkwo, bulya amango wacîshomya wagulyakwo erhi onafire». ");
INSERT INTO shr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nyakasane Nyamuzinda aderha, erhi: «Kurhali kwinjà omuntu ayôrhe yêne, rhumujirire omurhabâzi omushushire». ");
INSERT INTO shr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nyakasane Nyamuzinda arhôla obudaka abumbamwo ngasi nsimba z’erubala n’ebinyunyi by’emalunga byoshi, abihêkera omuntu mpu alole kurhi abiyîrika: ngasi oku omuntu abiyîrikaga kwo byanayîrisirwe. ");
INSERT INTO shr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ntyo omuntu ayîrika ebishwêkwa byoshi, orhunyunyi rhw’emalunga rhwoshi n’ensimba z’erubala, ci omuntu arhabonagamwo murhabâzi omushushire. ");
INSERT INTO shr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nyakasane Nyamuzinda arhogezakwo omuntu îrò ly’enkwîra, nyamuntu ahunira; amushugula omurhibadu ashosha eminyafu aha omurhibadu gwarhengaga. ");
INSERT INTO shr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ogwo murhibadu, Nyakasane Nyamuzinda àshugulaga oku mulume, atulamwo omukazi anamulêrhera omulume. ");
INSERT INTO shr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nnamulume, erhi: «Lêro oyu ye munyafu gw’omunyafu gwâni na kavuha k’orhuvuha rhwâni. Ayish’ikaderhwa mukazi (isha) bulya omu mulume (ish) arhenzire» (Ayish’ikaderhwa mukà-mulume bulya omu mulume arhenzire). ");
INSERT INTO shr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Co cirhuma omulume akwânîne aleke îshe na nnina acîshwekerekwo mukâge n’oku bali babiri bahinduke mubiri muguma (bayish’ihinduka muguma) ");
INSERT INTO shr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","N’obwo bombi bàli bushugunu; omulume n’omukazi, ci barhakâg’iyumvanya nshonyi. ");
INSERT INTO shr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Enjoka yo yali nsimba nyengûza omu nsimba z’erubala zoshi Nyakasane Nyamuzinda ajiraga. Wanjoka abwîra omukazi, erhi: «Ka kwo kunali Nnâmahanga adesire: Murhahîraga mukalya oku murhi ciru n’omuguma gw’omu ishwa?» ");
INSERT INTO shr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nyamukazi ashuza wanjoka, erhi: «Rhwanalya amalehe g’emirhi eri omu ishwa, ");
INSERT INTO shr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ci amalehe g’omurhi guli aha kâgarhî k’ishwa gwoki, Nnâmahanga adesire: murhagalyagakwo, ciru murhaguhumagakwo bulya erhi kufà munafire» ");
INSERT INTO shr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ci wanjoka abwîra nnamukazi, erhi: «Nanga murhakafa mâshi! ");
INSERT INTO shr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kali ciru Nnâmahanga amanyire oku amango mwânagulyekwo amasù ginyu gânayiguke munahinduke nka banyamuzinda mukâmanya aminjà n’amabî». ");
INSERT INTO shr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lêro nyamukazi abona nk’omurhi guli mwinjà okulîbwa, gunali gwa kusîmîsa amasù gunali gwa kucîfinjwa n’okudômwamwo obwenge; arhôla irehe alyâko, anahà ibà wali bonaye, naye alyâkwo. ");
INSERT INTO shr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Erhi amasù gâbo bombi gayiguka, bàbona oku bali bashugunu; bazingazinga ebyâsi by’omulehe babiyambalira omu cibunu. ");
INSERT INTO shr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Banaciyumva Nyakasane Nyamuzinda ajà acîgezageza omu ishwa oku hihûsi hy’olusiku, omulume na mukâge bacîfulika Nyakasane Nyamuzinda, omu karhî k’emirhi y’omu ishwa. ");
INSERT INTO shr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ci Nyakasane Nyamuzinda ayâkûza omulume amubwîra, erhi: «Ngahi oli?» ");
INSERT INTO shr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ashuza, erhi: «Nayumvîrhe wadunda amashando omu ishwa, namayôboha, bulya ndi mushugunu co carhumire nacîfulika». ");
INSERT INTO shr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ashub’idôsa, erhi: «Ndi wakumanyisize oku oli mushugunu? Ci akabà walire kwa gulya murhi nakuhanzagya nti irhondo orhahîraga okalya?» ");
INSERT INTO shr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nyamulume ashuza, erhi: «Omukazi wampebaga aha burhambi anampîre kwa gulya murhi nâni namanalyâkwo». ");
INSERT INTO shr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nyakasane Nyamuzinda abwîra omukazi, erhi: «Bici ebyo wamajira wâni?». Nnamukazi ashuza, erhi: «Kali enjoka yamanteba lêro namalya». ");
INSERT INTO shr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Go mango Nyakasane Nyamuzinda abwîzirage enjoka, erhi: «Obwo wanajizire ntyo, ohehêrirwe kulusha ngasi cishwêkwa na kulusha ensimba z’erubala zoshi; oku nda okola wâkagendera na katulo okola wâkâlya ensiku zoshi z’akalamo kâwe. ");
INSERT INTO shr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nkola naheba enshombo ekarhî kâwe n’omukazi, ekarhî k’iburha lyâwe n’iburha lyâge: oyu âkusinaga irhwe nâwe omukomolere oku kansisira». ");
INSERT INTO shr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Abwîra nyamukazi, erhi: «Nkolanayûshûla amalumwa gâwe, n’amazîmi gâwe omu malumwa okola wakaburha abâna. Kulalikira okolaga wakalalikira balo, ci naye akola ayish’ikâkuzidohera.» ");
INSERT INTO shr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Abwîra nyamulume, erhi: «Obwo wayumvîrhe mukâwe, wanalya kuli gulya murhi, n’obwo nakurhegekaga, nti irhondo orhahîraga okagulyâkwo, idaho lihehêrîrwe erhi we rhuma. Omu malibuko okola wakâkulamwo eci walya, ensiku zoshi z’akalamo kâwe. ");
INSERT INTO shr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mahwa n’emishûgi likola lyakâkufulukiza, okâlya n’enshogo lubala. ");
INSERT INTO shr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kurhûbanukirwa emalanga okola wakâbonamwo omugati (biryo): kuhika oshubire omu budaka bulya mwo warhengaga. Oli katulo n’omu katulo wânashubire!». ");
INSERT INTO shr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Omuntu ayîrika mukâge erya Eva, «Hawa» bulya ye nnina wa abazîne boshi. ");
INSERT INTO shr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nyakasane Nyamuzinda àjirira omulume n’omukazi ebishûli by’empù àbayambika. ");
INSERT INTO shr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nyakasane Nyamuzinda aderha, erhi: «Alagi oku omuntu akola ali ak’îrhu erhi kumanya aminjà n’amabî kurhuma. Mumanyage, arhacihîraga alîka okuboko kwâge mpu ahumbûle oku murhi gw’obuzîne, agulye alame ensiku zoshi!». ");
INSERT INTO shr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nyakasane Nyamuzinda amuhimva omu ishwa lya Edeni (masîma), mpu ly’agend’ihinga obudaka arhengagamwo. ");
INSERT INTO shr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ahimva omuntu anahira bakerubini n’engulumira y’engôrho yalaza ebushoshôkero bw’ishwa ly’amasîma, lyo balanga enjira ejà ebwa murhi gw’obuzîne (lyo bahagalika omuntu arhahume oku murhi gw’obuzîne). ");
INSERT INTO shr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu ashamuka kuli mukâge Eva. Eva ayâlala anaburha Kayini. Aderha, erhi: «Namashobôla omuntu emwa Nyakasane». ");
INSERT INTO shr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ashub’iburha omulumuna Abeli. Abeli ali mushwesi wa bishwêkwa ci Kayini ali muhinzi wa budaka. ");
INSERT INTO shr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Erhi kugera mango, Kayini arhûla nterekêro emwa Nyakasane ebi akûlaga omu budaka, ");
INSERT INTO shr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli naye arhûla ebiburhwa birhanzi by’ebibuzi byâge n’amashushi gâbyo. Nyakasane ayankirira Abeli n’entûlo yâge, ");
INSERT INTO shr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ci arhayankiriraga Kayini n’eyâge ntûlo. Kayini akunirira okwo n’obusù bwâge bwazinzibala. ");
INSERT INTO shr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nyakasane abwîra Kayini, erhi: «Cirhumire wakunira, cirhumire obusù bwâwe bwazinzibala? ");
INSERT INTO shr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nkawal’ijizire bwinjà, karhinga orhayinamwiri amalanga? Ci akabà orhajiziri bwinjà, ecâha cishurhamire aha lusò lwâwe, ciri cakulalîra, ci ocîhangâne ocihime». ");
INSERT INTO shr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayini abwîra omulumuna Abeli, erhi: «Rhujè ebulambo!». Oku bali omu bulambo, Kayini ayînamula okuboko acîrhulirakwo Abeli anamuniga. ");
INSERT INTO shr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Go mango Nyakasane abwîzire Kayini, erhi: «Ngahi mulumuna wâwe Abeli ali?». Ashuza, erhi: «Ntamanyiri. Ka nie mmulanga mulumuna wâni?». ");
INSERT INTO shr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Amushuza, erhi: «Bici ebi wamajira? Izù ly’omukò gwa mulumuna wâwe lyamanyakûza kurhenga okw’idaho. ");
INSERT INTO shr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Buyôrhe buhehêrirwe obudaka bwamiraga omukò gwa mulumuna wâwe erhi werhuma. ");
INSERT INTO shr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Erhi okacihinga obudaka burhakacikuyerera bici, wâbà kahûkà, wajà wayêrûka omu igulu». ");
INSERT INTO shr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayini abwîra Nyakasane, erhi: «K’ecâha câni ciri cinene bwenêne cirhakababalirwa?» ");
INSERT INTO shr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","«Lolà oku wamampiva muli lîno ishwa nnangwâsirwe ncîfulike hali na nâwe, nkolaga nâbà karharhinda na karhebera muno igulu, owanambugâne hali amango akanyîrha.» ");
INSERT INTO shr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ci Nyakasane amubwîra, erhi: «Ci kwoki ngasi wayîrhe Kayini acîholwa kali nda!». Nyakasane ahirakwo Kayini ecimanyîso, mpu lyo ngasi wâmurhimâne arhamushûrhaga. ");
INSERT INTO shr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayini acîyêgûla kuli Nyakasane anayûbaka omu cihugo ca Nodu, ebushoshôkero bw’ishwa ly’amasîma. ");
INSERT INTO shr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayini ashamuka bona mukâge, mukâge ayâlala anaburha Enoku; ayûbaka ecishagala aciyîrika erya Enoku, cirhenzire oku izîno ly’omugala Enoku. ");
INSERT INTO shr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoku aburhirwa Iradi, Iradi aburha Mehuyael na Mekuyael aburha Metushael. Metushael aburha Lâmek, Lâmek arhôla bakazi babiri: muguma ye Ada n’owundi ye Zila. ");
INSERT INTO shr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lâmek arhôla bakazi babiri: muguma ye Ada n’owundi ye Zila. ");
INSERT INTO shr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada aburha Yabal: y’îshe w’abahanda omu bifumba bajabalusa ebishwêkwa. ");
INSERT INTO shr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Omulumuna yewali Yubal: yewali îshe w’abaziha olulanga n’akarhêra. ");
INSERT INTO shr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila naye aburha Tubal Kayini, mutuzi, y’îshe w’abakola amarhale n’ebyûma. Mwâli wâbo Tubalkayini yewali Nahama. ");
INSERT INTO shr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lâmek abwîra bakage, erhi: «Ada na Zila, yumvirhizi izù lyâni; bakà Lâmek, rhegi amarhwîri oku bino namubwîra: “nayîsire omuntu okwenge amanyâgaza nayîrha n’omushikira okwenge amampukula”». ");
INSERT INTO shr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","«Kayini anacîholerwe kali nda ci Lâmek yêhe kali makumi gali nda na nda». ");
INSERT INTO shr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu ashub’ishamuka bona mukâge, nyamukazi aburha Set, bulya aderha, erhi: «Nyamuzinda amanshobôza owundi mwâna ahâli ha Abeli, bulya Kayini amuyisire». ");
INSERT INTO shr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set naye aburhirwa omugala, amuyîrika erya Enosh. Go mango barhangiraga okucîkumba YHWH, Nyakasane. ");
INSERT INTO shr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Alaga ecitabu c’emîmo y’Adamu. Erhi Nnâmahanga alema omuntu, amujira oku nshusho ya Nnâmahanga; ");
INSERT INTO shr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","mulume n’omukazi abalemire, abagisha anabayîrika bantu erhi abalema. ");
INSERT INTO shr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu al’igwêrhe myâka igana na makumi asharhu, erhi aburha omugala oku nshusho yâge n’oku cikebo câge, anamuhà izîno lya Set. ");
INSERT INTO shr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Erhi ayûs’iburha Seti, Adamu ashub’ilama myâka magana munâni anaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Akalamo k’Adamu koshi kali ka myâka magana mwenda na makumi asharhu, agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set al’igwêrhe myâka igana n’irhanu erhi aburha Enosh. ");
INSERT INTO shr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Erhi abà amâburha Enoshi, Set ashub’ilama myâka magana munâni na nda anaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Akalamo ka Set koshi kali ka myâka magana mwenda n’ikumi n’ibiri: agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi al’igwêrhe myâka makumi gali mwenda erhi aburha Kenan; ");
INSERT INTO shr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","erhi abà amâburha Kenan, Enosh ashub’ilama myâka magana munâni n’ikumi n’irhanu, anashub’iburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Akalamo ka Enosh koshi kali ka myâka magana mwenda n’irhanu; agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan al’igwêrhe myâka makumi gali nda erhi aburha Mahalaleel. ");
INSERT INTO shr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Erhi abà amâburha Mahalaleel. Kenan ashu’ilama myâka magana munâni na makumi anni, anakaburha abagala n’abâli ");
INSERT INTO shr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Akalamo ka Kenan koshi kali ka myâka magana mwenda n’ikumi, agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel al’igwêrhe myâka makumi gali ndarhu n’irhanu erhi aburha Yêred: ");
INSERT INTO shr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Erhi abà amâburha Yêred, Mahalaleel ashub’ilama myâka magana munâni na makumi asharhu, anakaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Akalamo ka Mahalaleel koshi kali ka myâka magana munâni na makumi galimwenda n’irhanu, agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared aligwêrhe myâka makumi galindarhu n’ibiri erhi aburha Enokh; ");
INSERT INTO shr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Erhi abà amâburha Enokh, Yêred ashub’ilama myâka magana munâni anakaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Akalamo ka Yêred koshi kali ka myâka magana mwenda na makumi galindarhu n’ibiri: agali’ifà ");
INSERT INTO shr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enokh aligwêrhe myâka makumi galindarhu n’irhanu erhi aburha Metushaleme. ");
INSERT INTO shr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enokh alusibwa na Nnâmahanga. Erhi abà amâburha Metushaleme, Enokh ashub’ilama myâka magana asharhu anakaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Akalamo ka Enokh koshi kali ka myâka magana asharhu na makumi galindarhu n’irhanu. ");
INSERT INTO shr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Bulya Enokh alilusîbwe na Nyamuzinda, arhaciberaga eno igulu. Nyamuzinda amuhêka. ");
INSERT INTO shr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metushaleme aligwêrhe myâka igana na makumi galimunani na nda erhi aburha Lâmek. ");
INSERT INTO shr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Erhi abà amâburha Lâmek, Metushaleme ashub’ilama myâka magana nda na makumi galimunani n’ibiri, anakaburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Akalamo ka Metushaleme koshi kali ka myâka magana mwenda na makumi galimwenda na mwenda, agal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lâmek aligwêrhe myâka igana na makumi galimunani n’ibiri erhi aburha omugala. ");
INSERT INTO shr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Amuyîrika erya Nûhu, omu kuderha, erhi: «Oyu ayishirhurhûliliza oku mukolo n’omurhamo gw’amaboko gîrhu, bulya Nyakasane ahehêrire obudaka». ");
INSERT INTO shr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Erhi abà amâburha Nûhu, Lâmek ashub’ilama myâka magana mwenda na makumi galimwenda n’irhanu, anakâburha abagala n’abâli. ");
INSERT INTO shr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Akalamo ka Lâmek koshi kali ka myâka magana nda na makumi galinda na nda, anagal’ifà. ");
INSERT INTO shr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nûhu aligwêrhe myâka magana arhanu erhi aburha Sem, Ham na Yafet. ");
INSERT INTO shr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Erhi abantu barhangira baluga en’igulu, bàburha abanyere, ");
INSERT INTO shr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","bene Nyamuzinda bàbona oku abanyere b’abantu bali binjà. Babayankamwo abà banalilonzize. ");
INSERT INTO shr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Lêro Nyakasane aderha, erhi: «Omûka gwâni gurhacibêre ensiku zoshi omu muntu, n’obo ali mubiri n’akalamo kâge kakola kabà ka myâka igana na makumi abiri». ");
INSERT INTO shr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ago mango, en’igulu yali abanênênè-mikalarhu- ciru n’enyuma zâho, amango bene Nyamuzinda bakâg’iyanka abanyere b’abantu, abo banyere bakâburha abâna: zo zirya ntwâli za mîra, bantu b’irenge. ");
INSERT INTO shr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nyakasane abona oku amabî g’abantu gàluzire en’igulu na ngasi muhigo gwabali emurhima gwàli gwa mabî gwône. ");
INSERT INTO shr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nyamuzinda acîganya mpu eci alemeraga omuntu hano igulu, alumwa bwenêne omu murhima gwâge. ");
INSERT INTO shr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nyakasane aderha, erhi: «Omu igulu nkola naholola abantu nalemaga; bône ensimba n’ebinyâgârha n’ebinyunyi by’emalunga, bulya namaciganya ecarhumaga nabijira». ");
INSERT INTO shr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ci Nûhu yêhe arhona emwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Olwa Nûhu luno. Nûhu ali muntu mushinganyanya na mwîrhonzi omu bantu b’amango gâge analikulikîre Nyakasane. ");
INSERT INTO shr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nûhu aburha abagala: Sem, Ham na Yafet ");
INSERT INTO shr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Igulu lyashûbuka embere za Nyamuzinda, lyanayunjula ntambala. ");
INSERT INTO shr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nyamuzinda alola igulu abona oku nêci lishûbusire bulya ngasi muntu ali akola agwerhe olugendo lushûbusire. ");
INSERT INTO shr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Go mango Nyakasane abwîzirage Nûhu, erhi: «Kuli nie, amango g’obuzinda bw’omuntu gahisire, bulya igulu lyasherîre erhi bo bàrhuma, liyunjwîre bumînya. Niene nkolaga nabashâba haguma n’igulu. ");
INSERT INTO shr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ocîtulire obwârho bw’omurhi gw’enshebeyi gwadwa amagoba; ogabe obwârho mwo rhuyumpa rhuyumpa, higuma enyanya ly’ehindi, onabushîge enungulu omu ndalâlà n’emugongo. ");
INSERT INTO shr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Alaga oku wâjira: obwârho bubè na makano makumi asharhu ga bulî, makumi arhanu ga bugali, makumi asharhu ga kadubwî. ");
INSERT INTO shr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Omu bwârho ohiremw’oburhungiri n’ah’ikano liguma enyanya oshwinje. Lunda luguma ohireyo omuhango gw’obwârho. Olujire mishonezo: ah’idako, aha karhî n’aha nyanya. ");
INSERT INTO shr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nkolaga narhuma ecihonzi, kwo kuderha mîshi, en’igulu, ah’idako ly’amalunga, gashâbe ngasi ciremwa ciyîsa omûka; ebiri en’igulu biherêrekere. ");
INSERT INTO shr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Cikwône wêhe nâkuhà endagâno. Wayîsh’ijà omu bwârho mwen’abâna bâwe, mukâwe, na bali-kazi bâwe. ");
INSERT INTO shr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Omu bizîne byoshi, na ngasi mubiri, orhôle bibiri bibiri bya ngasi lubero, obihugire omu bwârho, lyo bibêrana obuzîne haguma nâwe: hakâba akalume n’akakazi. ");
INSERT INTO shr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ebinyunyi kushimbana n’obûko bwabyo, ebishwêkwa kushimbana n’obûko bwâbyo, n’ebiyandala kushimbana n’obûko bwâbyo, bibiri bya ngasi bûko bibêre nâwe, lyo bibêrana akalamo. ");
INSERT INTO shr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Wêhe orhôle ngasi bûko kalyo, olunde hôfi hâwe: byâyishibà biryo byâwe na biryo by’ebyo bintu». ");
INSERT INTO shr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nûhu ashimba byoshi, nk’oku Nyakasane alimurhegesire, kwo anajizire. ");
INSERT INTO shr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nyakasane ashub’ibwîra Nûhu, erhi: «Jaga omu bwârho mwene omulala gwâwe gwoshi, bulya nabwîne oku oli mushinganyanya embere zâni muli elira iburha. ");
INSERT INTO shr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Oku ngasi bûko bwa nsimba ecîre, orhôlemwo mahali nda, akalume n’akakazi kâko; omu bûko bw’ensimba zihumânya orhôle ihasha liguma, akalume n’akakazi kâko. ");
INSERT INTO shr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","N’omu ngasi bûko bwa binyunyi bicîre, orhôle mahasha nda, akalume n’akakazi kâko, lyo obûko burhag’ihera en’igulu. ");
INSERT INTO shr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bulya enyuma lya nsiku nda, naniêsa enkuba en’igulu nsiku makumi anni na madufu makumi anni; en’igulu naholola ngasi cizîne najiraga». ");
INSERT INTO shr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nûhu ajira ebi Nyakasane ali amurhegesire byoshi. ");
INSERT INTO shr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nûhu aligwêrhe myâka magana ndarhu erhi ecihonzi ciyisha, go mîshi okw’igulu. ");
INSERT INTO shr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nûhu ajà omu bwârho haguma n’abagala na mukâge n’abâli-kazi, lyo bayâka amîshi g’ecihonzi. ");
INSERT INTO shr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ensimba zicîre n’ezihumânya, ebinyunyi na ngasi binyafûka oku idaho byadaha omu bwârho bibiri bibiri, ");
INSERT INTO shr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","akalume n’akakazi byoshi na Nûhu, nk’oku Nyakasane analirhegesire Nûhu. ");
INSERT INTO shr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Erhi ensiku nda zihika, amîshi g’ecihonzi gacihira oku idaho; ");
INSERT INTO shr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","omu mwâka gwa magana ndarhu g’akalamo ka Nûhu, omu omwêzi gwa kabiri, omu nsiku ikumi na nda z’omwêzi, lwo n’olwo lusiku, amaliba g’ekuzimu gafunûnuka n’enshalalo z’emalunga zahulula. ");
INSERT INTO shr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Enkuba yania en’igulu nsiku makumi anni na madufu makumi anni. ");
INSERT INTO shr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lwo n’olwo lusiku lyo Nûhu, boshi n’abagala Sem, Ham na Yafet, mukà Nûhu, abâli-kazi basharhu, bakà abagala: ");
INSERT INTO shr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","boshi n’ebizîne byoshi kushimbana n’obûko bwâbyo, ensimba kushimbana n’obûko bwâzo, ebiyandala oku idaho kushimbana n’obûko bwâbyo, ebibalala kushimbana n’obûko bwâbyo, ebinyunyi byoshi na ngasi hibalala, bàjaga omu bwârho. ");
INSERT INTO shr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bajà emunda Nûhu ali omu bwârho, babiri babiri ba ngasi ciyìsa omûka. ");
INSERT INTO shr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Abo bayishaga ndume n’enkazi ba ngasi bûko, bobadahîre nk’oku Nyamuzinda anabarhegekaga. Nyakasane ayîgala obwârho abahà omugongo. ");
INSERT INTO shr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ecihonzi càba nsiku makumi anni, oku amîshi gayushûka n’obwârho bwasôkera enyanya z’igulu. ");
INSERT INTO shr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Oku amîshi galuga ganayushûka okw’igulu n’obwârho bwayerêra oku mîshi. ");
INSERT INTO shr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Amîshi gajà gayushûka kulusha oku nyanya z’igulu ganabwîka ngasi ntondo ndîrî zinaba ah’idako ly’amalunga. ");
INSERT INTO shr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Amîshi gabwîkaga entondo, garhaluka makoro ikumi n’arhanu. ");
INSERT INTO shr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ngasi kazîne kaherêrekera: ebigera okw’idaho, ebinyunyi, ebishwêkwa, ensimba z’erubala, na ngasi bidûdûsa en’igulu na abantu boshi. ");
INSERT INTO shr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kwo kuderha oku ngasi hyàli en’igulu hyàfa: ngasi biyîsa omûka emazûlu. ");
INSERT INTO shr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ntyo kwo ebyàli en’igulu byoshi byàholokaga: haguma n’abantu, ebishwêkwa, ebinyafûka n’ebinyunyi by’emalunga; byoshi byahirigirha en’igulu ci hasigala Nûhu yêne na ngasi kali omu bwârho bonaye. ");
INSERT INTO shr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amîshi gayôrha gabwîkîre igulu nsiku igana na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nyamuzinda akengêra Nûhu, ensimba n’ebishwêkwa byàli bo naye omu bwârho. Nyamuzinda ageza empûsi oku igulu, ntyo amîshi gajà gayonda. ");
INSERT INTO shr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Amaliba g’ekuzimu n’enshalalo z’emalunga byayigalwa; n’enkuba yayimanzibwa emalunga; ");
INSERT INTO shr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","amîshi gajà gayonda bunyi bunyi, gagana erhi kugera nsiku igana na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Omu mwêzi gwa kali nda omu nsiku ikumi na nda z’omwêzi, obwârho bwadekerera oku ntondo Ararat. ");
INSERT INTO shr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amîshi gajà gayonda gajà gayonda bunyi bunyi kuhika mwêzi gw’ikumi. Omu mwêzi gw’ikumi, olusiku lurhanzi lw’omwêzi orhurhwerhwe rhw’entondo rhwaboneka. ");
INSERT INTO shr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Erhi hagera nsiku makumi anni, Nûhu ayigula ilolero ly’obwârho alijizire omu bwârho anahulusa hungwe mpu aj’ilola erhi amîshi gakazire. ");
INSERT INTO shr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Hungwe ahuluka ci akâjà eyi n’eyi alinda oku amîshi gakala okw’igulu. ");
INSERT INTO shr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Lêro Nûhu ahulusa engûkù mpu alole erhi amîshi gakazire okw’idaho; ");
INSERT INTO shr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ci wangûkù erhi abona arhabwini aha ahira obulà bw’olushando, ashubira omu bwârho, bulya amîshi gaciri okw’igulu. Nûhu alambûla okuboko, ayigwârha anashub’iyidahya omu bwârho hôfi naye. ");
INSERT INTO shr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Alinda zindi nsiku nda, ashub’ihulusa engûkù omu bwârho, ");
INSERT INTO shr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","engûkù yamushubirakwo bijingo, abona ekola edwîrhe ehishami hy’omuzêtuni omu mulomo. Nûhu ayumva oku amîshi gaganyire okw’igulu. ");
INSERT INTO shr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ashub’ilinda zindi nsiku nda, ashub’ilika engûkù egende: erhacigalukaga aha ali. ");
INSERT INTO shr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Omu mwâka gwa magana ndarhu na muguma y’akalamo ka Nûhu, omu mwêzi gwa burhanzi, omu lusiku lurhanzi ly’omwêzi, amîshi gali gamagana okw’igulu; Nûhu akula omufûniko gw’obwârho, abona oku obululi b’igulu bwakazirekwo amîshi. ");
INSERT INTO shr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Omu mwêzi gwa kabiri, omu nsiku makumi abiri na nda igulu lyoshi lyakala. ");
INSERT INTO shr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nyamuzinda arhegeka Nûhu, erhi: ");
INSERT INTO shr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Huluka omu bwârho mwena mukâwe, bagala bâwe na bali-kazi bâwe haguma nâwe. ");
INSERT INTO shr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ensimba za ngasi lubero muli mweshi, orhunyunyi, ebishwêkwa na ngasi biyandala binadûdûsa okw’igulu, obihuluse haguma nâwe, lyo bihasha okulumîra igulu, biyololoke biluge hoshi». ");
INSERT INTO shr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nûhu ahuluka n’abagala, na mukâge, n’abâli-kazi. ");
INSERT INTO shr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ebizîne byoshi na ngasi bishwêkwa n’orhunyunyi rhwoshi n’ebiyandala binadûdûsa oku igulu kushimbana n’obûko bwabyo, byahuluka omu bwârho. ");
INSERT INTO shr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Go mango Nûhu ayubasirage oluhêrero lwa Nyakasane; arhôla ngasi bûko bwa nsimba ecîre na ngasi rhunyunyi rhucire, arhûla embâgwa z’okusingônola oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nyakasane abayiza hirya hibayo hinjà anacigerereza, erhi: «Ntakacihehêrera igulu bundi erhi muntu orhuma, bulya iralà lyâge libà liyêrekîre amabî kurhenga emuhimbo, ntakacishangula bundi ebizîne nk’oku nzind’ijira. ");
INSERT INTO shr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Oku igulu licihaba, okumîra/kurhwêra n’okusârûla, emboho n’idûrhu, ecanda n’empondo, obudufu n’omûshi, birhakacihusa kubaho». ");
INSERT INTO shr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nyamuzinda anacigisha Nûhu boshi n’abagala anacibabwîra, erhi: «Muburhe, muyôloloke, munabumbe igulu bantu. ");
INSERT INTO shr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mubè côbà na bacôbohwa b’ensimba zoshi z’oku igulu n’enyunyi zoshi z’emalunga, n’ebinyâgârha oku igulu lyoshi, n’enfî zoshi z’omu nyanja: byoshi mbihizire omu nfune zinyu. ");
INSERT INTO shr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ngasi bibà bizîne binafukunya byoshi byâbà biryo binyu, mmuhîre byo byoshi kuguma n’ebyâsi by’emburho. ");
INSERT INTO shr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Cikwône murhalyaga enyama mukanalya n’obuzîne bwâyo, kwo kuderha omukò. ");
INSERT INTO shr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ci kwônene namudôsa oku mukò gwa ngasi muguma muli mwe. Nanâdôse ebiryanyi byoshi ndôse n’omuntu, abantu bône na bône nanâdôse ogw’omukò gw’omuntu. ");
INSERT INTO shr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Owabulage omukò gw’omuntu, naye omukò gwâge gunabulagwe n’omuntu. Bulya oku nshusho ya Nyamuzinda omuntu alemagwa. ");
INSERT INTO shr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mwêhe muburhe, muyôloloke, mubumbe igulu bantu munalirhegeke». ");
INSERT INTO shr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nyamuzinda anacibwîra Nûhu n’abagala, erhi: «Loli oku nahira endagâno yâni ekarhî kinyu n’ekarhî k’iburha linyu enyuma zinyu. ");
INSERT INTO shr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Nanjizire eyi ndagâno haguma n’ebizîne biri haguma ninyu: enyunyi, ebintu bishwêkwa, ensimba muli mweshi, ");
INSERT INTO shr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","rhuderhe omu kutwa bwofi, birya byanarhengaga omu nkugè, ensimba z’igulu. ");
INSERT INTO shr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nfundisire endagâno yâni haguma ninyu: ntà mubiri gwacisherêre n’amîshi g’ecihonzi, harhakacibà cihonzi casherêza igulu». ");
INSERT INTO shr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nyamuzinda anaciderha, erhi: «Lolagi ecimanyîso c’endagâno nfundisire ekarhî kinyu na nâni, ekarhî k’ebindi biremwa munali mweshi nabyo, oku maburhwa gayisha. ");
INSERT INTO shr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Niono mpizire omuherho gwâni omu bitù, co cabà cimanyîso c’endagâno yâni n’igulu. ");
INSERT INTO shr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mango nkashûbûliza ebitù oku nyanya z’igulu n’omuherho gukaboneka omu citù, ");
INSERT INTO shr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","aho nanakengêra endagâno nafundikaga ninyu, amîshi garhacihinduke cihonzi c’okusherêza ngasi mubiri. ");
INSERT INTO shr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mango omuherho gukabà guli omu citù, nanagubona, nankengêre erya ndagâno y’ensiku n’amango eri ekarhî ka Nyamuzinda n’ebiyîsa omûka byoshi, rhuderhe ngasi mubiri gubà oku igulu». ");
INSERT INTO shr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nyamuzinda anacibwîra Nûhu, erhi: «Eco co cimanyîso c’endagâno mpizire ekarhî kâni na ngasi mubiri guli oku igulu». ");
INSERT INTO shr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Bagala ba Nûhu barhengaga omu nkugè bàli: Semu, Hamu na Yafeti. Hamu ye îshe wa Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Abo oku banali basharhu bàli bene Nûhu bo banarhenzirekwo abantu, bàlumira igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nûhu ebwa kubà àbâga muhinzi, arhondêra okukâhinga emizâbîbu. ");
INSERT INTO shr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Erhi acibà amanywa idivayi, àlaluka, àyôrha bushugunu omu ihêma lyâge. ");
INSERT INTO shr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham îshe wa Kanan abona îshe ali bushugunu, ajìbwîra bene wâbo oku bali babirhi embuga. ");
INSERT INTO shr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ci Sem na Yafet banacirhôla ecirondo, bacîhira bombi oku birhugo bayisha bagenda cinyumanyumà, babwîka îshe, barhahindulaga obusù, barhabonaga obushugunu bw’îshe. ");
INSERT INTO shr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Erhi Nûhu arhengamwo erya ndalwè, amanya kurhi omugala murhò anamujirîre. ");
INSERT INTO shr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Anacimubwîra, erhi: «Kanâni ahehêrirwe mâshi! Kuli bene wâbo abè ye wa buzinda omu bajà!». ");
INSERT INTO shr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Anaciderha kandi, erhi: «Ayâgirwe Nyakasane Nyamuzinda wa Semu, ci Kanâni abè mujà wâge. ");
INSERT INTO shr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nyamuzinda agalihye Yafet, ahande omu mahêma ga Sem; ci Kanâni abè mujà wâge». ");
INSERT INTO shr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Enyuma ly’ecihonzi, Nûhu acilamire yindi myâka magana asharhu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Akalamo ka Nûhu koshi kahisire omu myâka magana gali mwenda na makumi arhanu, buzinda bw’aho àfà. ");
INSERT INTO shr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Alaga iburha lya bene Nûhu, Sem, Khamu na Yafeti, n’abâna babusire enyuma ly’ecihonzi cinene. ");
INSERT INTO shr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafeti àburha Gomeri, Magogi, Madayi, Yavani, Tubali, Mesheki na Tirasi. ");
INSERT INTO shr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Bene Gomeri: Askenazi, Rifati, Togarma. ");
INSERT INTO shr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Bene Yavani: Elisha, Tarsisi, Abakitimi n’Abadodani. ");
INSERT INTO shr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kuli barhengaga abashandabanaga omu birhwa bibà omu nyanja emwa amashanja. Bene Yafeti bagendibà ntyo ngasi baguma n’ecihugo câbo, n’olulimi lwâbo, n’emilala yâbo, n’amashanja gâbo. ");
INSERT INTO shr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Bene Khamu bo: Kushi, Misrayimu, Puti na Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Bene Kushi bo: Seba, Havila, Sabata, Rama na Sabuteka. Bene Rama bo: Sheba na Dedani. ");
INSERT INTO shr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi àburha Nimrodi, ye warhangiraga oburhambo hano igulu. ");
INSERT INTO shr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ali muhivi mukulu embere za Nyamubâho, co cinarhuma baderha mpu: «Kwo oli aka Nimrodi muhivi mukulu embere za Nyamubâho». ");
INSERT INTO shr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ecihugo c’aga mashanja canacirhondêrera e Babeli, Ereki n’Akadi, bishagala biri byoshi omu cihugo ca Shineari. ");
INSERT INTO shr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Arhulukâna mw’eco cihugo ajà e Asûru, ayûbaka Ninive, Rehoboti-Iri, Kalaha, na ");
INSERT INTO shr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Reseni ekarhî ka Ninive na Kalaha, lugo lunene là. ");
INSERT INTO shr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misarayim àburha bene Ludimu, bene Anemu, Lehabimu na Nafutuhimu. ");
INSERT INTO shr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Aburha Patrosimu, ba Kasiluhimu, bo barhengakwo Abafilistini na Bakafutori. ");
INSERT INTO shr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanâni aburha Sidoni yo nfula yâge, kandi Heti. ");
INSERT INTO shr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ahirakwo Abayebuseni, Abamoriti, Abagirgashi, ");
INSERT INTO shr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ahirakwo Abahiviti, Abarkeni, Abasiniti, ");
INSERT INTO shr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ahirakwo Abarvadi, Abasemariti, Abahamatiti; enyuma z’aho emilala ya bene Kanâni yashadabâna yoshi. ");
INSERT INTO shr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ecihugo ca bene Kanâni càli kurhenga e Sidoni, kugera e Gerari kujà e Gaza, kandi kugera olunda lw’e Sodomo, Gomora, Adma na Seboyimi caj’ihwera e Lesha. ");
INSERT INTO shr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Byanacibà ntyo kuli bene Khamu, ngasi baguma n’emilala yâbo n’ebihugo byâbo, haguma n’amashanja gâbo. ");
INSERT INTO shr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semu naye agwêrhe eryâge iburha, ye îshe wa bene Eberi boshi ye na mukulu wa Yafeti. ");
INSERT INTO shr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semu ye burha Elami, Asuri, Aripakisadi, Ludi na Arami. ");
INSERT INTO shr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Bene Arami: Usi, Huli, Geteri na Mash. ");
INSERT INTO shr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripakisadi àburha Selahi, na Selahi àburha Eberi. ");
INSERT INTO shr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi àburha bâna babirhi: owa burhanzi aderhwa Pelegi, bulya omu mango gâge mwo igulu lyagabanyikanaga, omulumuna naye aderhwa Yokotani. ");
INSERT INTO shr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokotani aburha Almodadi, Shelefi, Hasarmaveti na Yera, ");
INSERT INTO shr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorami, Uzali, Dikala, ");
INSERT INTO shr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimayeli na Sheba. ");
INSERT INTO shr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila, Yobabu, abôla boshi bali bâna ba Yokotani. ");
INSERT INTO shr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ecihugo câbo càli kurhenga e Mesha kujà e Sefari, ntondo eri ebushoshôkero bw’izûba. ");
INSERT INTO shr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kwo bali ntyo bene Semu, omu kushimba emilala yâbo, olulimi lwâbo na kandi omu kushimba ecihugo câbo n’amashanja gâbo. ");
INSERT INTO shr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Kwo bene Nûhu bayôlolosire ntyo omu milala, omu bûko n’omu mashanja gâbo. Baligi cisiki c’agandi mashanja goshi gabumbire igulu kurhenga amango g’ecihonzi. ");
INSERT INTO shr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Igulu lyoshi lyagwêrhe iderha liguma na binwa biguma. ");
INSERT INTO shr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ebwa kubà abantu bajâga bagendagenda olunda lw’ebushoshôkero bw’izûba, lêro banacirhinda omu kabanda k’omu cihugo ca Shineyari: banaciyûbaka ahôla. ");
INSERT INTO shr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Banacibwîrana mpu: «Ewa yâgi, rhujire amatofali, rhugayôce n’omuliro». Amatofali gabà go mabuye g’okuyûbaka n’obulembo yâbà yo nsîma yagagwârha. ");
INSERT INTO shr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Banacibwîrana mpu: «Ewa yâgi: Rhuyûbake olugo, kandi rhuhirekwo enkingi yahika oku nkuba malunga. Ntyo nîrhu rhwanakâderha oku nîrhu rhuli balume là, na kandi okwôla kwanarhuma rhurhacishandabana omu igulu». ");
INSERT INTO shr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nyamuzinda anacihona oku nkuba mpu naye ayish’ilola olugo n’enkingi abantu bayûbasire. ");
INSERT INTO shr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Nyamuzinda anaciderha erhi: «Alà oku boshi bali lubaga luguma banagwêrhe iderha liguma, ogwôla gwo murhondêro gw’eyi mikolo yâbo. Na bunôla ntà muhigo gwâbo gwakabula buyunjula kuli bo. ");
INSERT INTO shr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kanya rhubunguluke, rhubashandire iderha, bahuzagure ntà baguma baciyumva abâbo.» ");
INSERT INTO shr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nyamubâho àbashandabanya omu igulu lyoshi, kurhenga aho, baleka okuyûbaka olwo lugo. ");
INSERT INTO shr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Aho bahayîrika Babeli, bulya ho Nyamubâho ashandiraga iderha ly’abantu oku igulu, ahôla ho anabashandabanyizagya, bashandâla omu igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Alaga iburha lya Semu. Erhi ajira myâka igana, àburha Aripakisadi, myâka ibirhi enyuma ly’ecihonzi. ");
INSERT INTO shr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Enyuma ly’okuburhwa kwa Aripakisadi, Semu ashub’ilama myâka magana arhanu, àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Erhi Aripakisadi àjira myâka makumi asharhu n’irhanu, àburha Selahi. ");
INSERT INTO shr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Aripakisadi abîre amâburha Selahi, ashub’ilama yindi myâka magana anni n’isharhu, àburha abarhabana n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Erhi Selahi àjira myâka makumi asharhu, àburha Eberi. ");
INSERT INTO shr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Selahi abîre amâburha Eberi, ashub’ilama yindi myâka magana anni n’irhanu, àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Erhi Eberi àjira myâka makumi asharhu n’ini, àburha Pelegi. ");
INSERT INTO shr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eberi abîre amâburha Pelegi, ashub’ilama yindi myâka magana anni na makumi asharhu àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Erhi Pelegi àjira myâka makumi asharhu, àburha Rewu, ");
INSERT INTO shr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi abîre amâburha Rewu, ashub’ilama yindi myâka magana anni na makumi asharhu àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Erhi Rewu àjira myâka makumi asharhu n’ibirhi, àburha Serugi. ");
INSERT INTO shr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rewu abîre amâburha Serugi, ashub’ilama yindi myâka magana abirhi na nda, àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Erhi Serugi àjira myâka makumi asharhu, àburha Nahori. ");
INSERT INTO shr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serugi abîre amâburha Nahori, ashub’ilama yindi myâka magana abirhi, àburha abarhabana àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Erhi Nahori àjira myâka makumi abirhi na mwenda, àburha Terahi. ");
INSERT INTO shr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahori abîre amâburha Terahi, ashub’ilama yindi myâka igana n’ikumi na mwenda, àburha abarhabana, àburha n’abanyere. ");
INSERT INTO shr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Erhi Terahi ajira myâka makumi galinda, àburha Abramu, Nahori na Harani. ");
INSERT INTO shr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Alaga iburha lya Terahi: Terahi àburha Abramu, Nahori na Harani. Harani àburha Loti. ");
INSERT INTO shr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani afîre embere z’îshe Terahi omu cihugo baburhiragwamwo, e Uru omu Kaldeya. ");
INSERT INTO shr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu na Nahori banacijà omu buhya: mukà Abramu izîno lyâge erhi ye Sarayi; mukà Nahori izîno lyâge erhi ye Milka, mwâli wa Harani, àligi îshe wa Milka na Yisika. ");
INSERT INTO shr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi anacigumba: arhabonaga mwâna. ");
INSERT INTO shr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terahi anacirhôla omugala Abramu, n’omwinjikulu Loti mwene Harani, n’omwâlikazi Sarayi mukà omugala Abramu, boshi barhenga e Uru omu Kaldeya bajà omu cihugo c’e Kanâni, ci erhi bahika e Harani bayûbaka yo. ");
INSERT INTO shr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ensiku z’akalamo ka Terahi: myâka magana abirhi n’irhanu, buzinda afîra aha Harani. ");
INSERT INTO shr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nyamubâho anacibwîra Abramu, erhi: «Orhenge omu cihugo cinyu, omulala gwâwe n’enyumpa ya sho, ojè omu cihugo nakuyêreka. ");
INSERT INTO shr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nakujira ishanja linene, nakugisha n’izîno lyâwe lije irenge, lyabà mugisho! ");
INSERT INTO shr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nagisha abakugisha, nahana n’abakakuhehêrera. N’amashanja g’igulu goshi gagishwa muli we». ");
INSERT INTO shr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abramu anacilikùla nk’oku Nyamubâho anamubwîraga, bagenda boshi na Loti. Abramu ali agwêrhe myâka makumi gali nda n’irhanu erhi arhenga e Harani. ");
INSERT INTO shr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu anacirhôla mukâge Sarayi na Loti, mugala w’omulumuna, ashana ebirugu byâge byoshi n’abambali ali akola agwêrhe aha Harani; balîkûla, bàjà omu cihugo c’e Kanâni. Banacihika obwo omu cihugo c’e Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramu anacirhulukàna mw’ecôla cihugo Kanâni, ahika ahantu hatagatîfu e Sikemi, aha murhi gwa More. Ago mango erhi Banyakanani bayûbasire ecihugo. ");
INSERT INTO shr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nyamubâho abonekera Abramu anacimubwîra, erhi: «Iburha lyâwe lyo nahà eci cihugo». Oku bundi Abramu ayûbakira Nyamubâho, wamubonekeraga, oluhêrero ahôla. ");
INSERT INTO shr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kurhenga aho anacisôkera oku ntondo olunda lw’e bushoshôkero bwa Beteli, agwikayo ecirâlo. Akâsinza Beteli e buzikiro na Ai e bushoshôkero. Ayubakaho oluhêrero lwa Nyamubâho, anaciyâkûza izîno lyâge. ");
INSERT INTO shr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ntyo Abramu ajà ahanda anahandûla, alinda ahika e Nêgebu. ");
INSERT INTO shr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ecizombo canacizùka omu cihugo, naye Abramu abungulukira e Mîsiri mpu aj’ibêrayo bulya ecizombo càli cidârhi bwenêne mw’eco cihugo. ");
INSERT INTO shr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Erhi bakola baling’ihika e Mîsiri, Abramu anacibwîra mukâge Sarayi, erhi: «Lolà, nyîshi oku ôbà mukazi w’iranga linjà. ");
INSERT INTO shr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Abanya-Mîsiri hano banarhubona ntya banaderha mpu mukâge oyu, n’abo bananyîrha, bakuleke. ");
INSERT INTO shr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kuziga okâderha oku oli mwâli wîrhu lyo nâni bandola bwinjà, bandeke nkulamirekwo». ");
INSERT INTO shr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Byanabà kulya, Abramu erhi ahika e Mîsiri, Abanyamisiri babona oku nyamukazi anali mwinjà bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Abarhambo ba Faraoni mwâmi w’e Mîsiri bamubona bakàmukunga bwenêne embere za Faraoni mwâmi w’e Mîsiri. Barhôla nyamukazi, Sara, bamuhêka omu bwâmi bwa Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Faraoni mwâmi w’e Mîsiri arhonya Abramu erhi nyamukazi orhuma: ashobôla enkafu n’ebibuzi, endogomi ndume, abajà, abajàkazi, endogomi nkazi n’engamiya. ");
INSERT INTO shr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ci kwône Nyamubâho arhogezakwo Faraoni mwâmi w’e Mîsiri obuhanya bunene ye n’omulala gwâge erhi Sarayi mukà Abramu orhuma. ");
INSERT INTO shr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraoni mwâmi w’e Mîsiri anacihamagala Abramu amubwîra, erhi: «Kwo kurhi oku wanjizire? “Carhumaga orhambwîra oku ali mukâwe?”» ");
INSERT INTO shr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Carhumaga oderha, erhi: «Ali mwâli wîrhu, n’aho nalinda mmuyanka? Buno buno alaga mukâwe, rhôla ye wenaye ontengere kuno». ");
INSERT INTO shr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraoni mwâmi w’e Mîsiri amuhà abantu bamulusa bamukûla omu cihugo ye na mukâge n’ebintu byâge byoshi. ");
INSERT INTO shr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramu arhenga e Mîsiri, ye, mukâge n’ebintu byâge byoshi, kuguma na Loti ashubisôkera e Nêgebu. ");
INSERT INTO shr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu ali muhirhi bwenêne oku masô g’ebintu bishwêkwa, oku nsaranga n’oku masholo. ");
INSERT INTO shr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kandi ashub’ijà ahanda anahandûla kurhenga e Nêgebu kuhika e Beteli, alinda ashubihika halya agwîkaga ecirâlo burhanzi ekarhî ka Beteli na Ai, ");
INSERT INTO shr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","halya ayubakiraga Nyamubâho oluhêrero burhangiriza, kandi ahôla Abramu ashubiyâkuza izîno lya Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti wajâga agenda boshi na Abramu ali agwêrhe naye amasò g’enkafu n’ag’ebibuzi, haguma n’amahêma. ");
INSERT INTO shr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ecihugo cafundera, okubà n’ebintu binji kurhacizigaga babêra haguma. ");
INSERT INTO shr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abangere ba Abramu n’abangere ba Loti barhondêra emirongwe. Mw’ago mango Abanya-Kanâni erhi Abaperiziti bo balibayubasire omu cihugo. ");
INSERT INTO shr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abramu abwîra Loti, erhi: «Yâga ntalonza hazûke emirongwe ekarhî kâni nâwe nîsi erhi ekarhî k’abangere bâni n’abangere bâwe bulya rhwamâbà baguma. ");
INSERT INTO shr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","K’ecihugo cirhali cigali embere zâwe. Ontengekwo. Okajà e kulembe najà ekulyo, okajà ekulyo, najà ekulembe». ");
INSERT INTO shr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti ayînamula amasù, abona olubanda lwa Yordani lwàli ludômerirwe bwinjà hoshi. Okwo kwabâga embere Nyamubâho ashâbe Sodomo na Gomora, olwo lubanda kwo lwàli nka busâni bwa Nyamubâho, nk’ecihugo c’e Mîsiri kujà elunda lw’e Sowari. ");
INSERT INTO shr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti acîshoga olwo lubanda lwa Yordani lwoshi, agandûla agend’iyûbaka olunda lw’e bushoshôkero, ntyo kwo barhenginekwo. ");
INSERT INTO shr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu ayûbaka omu cihugo ca bene Kanâni, naye Loti ayûbaka omu bishagala by’elubanda, agwîka ebirâlo byâge kuhika e Sodomo. ");
INSERT INTO shr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Abantu b’e Sodomo bali bantu babî bwenêne, na banyabyâha embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Nyamubâho anacibwîra Abramu, erhi Loti abà amamurhengakwo, erhi: «Yinamula amasù obone, kurhenga aho oli kujà e mwênè n’emukondwè, kujà e bushoshôkero n’ebuzikiro. ");
INSERT INTO shr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Eco cihugo coshi wabona nakuhà co we n’iburha lyâwe, cibè cinyu ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Iburha lyâwe najira hyôloloke liluge nka katulo k’okw’idaho: owakahash’iganja emogomogo z’akatulo k’okw’idaho ye wanahash’iganja iburha lyâwe. ");
INSERT INTO shr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yimuka! orhandagire eci cihugo omu buli n’omu bugali, bulya co nakuhà». ");
INSERT INTO shr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abramu yoyo n’amahêma gâge, akanya agend’igwîka ecirâlo aha murhi gwa Mambri, oguli aha Hebroni, n’ahôla ayûbakiraho Nyamubâho oluhêrero. ");
INSERT INTO shr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Omu mango ga Amrafeli mwâmi w’e Shineyari, Ariyoko mwâmi w’e Elasari na Kedori-Laomeri mwâmi w’e Elami na Tideali mwâmi w’e Goyimi, ");
INSERT INTO shr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","abôla bâmi banacitula entambala oku bâbo bâmi bo baligi: Bera mwâmi w’e Sodomo, Birsha mwâmi w’e Gomora, Shineabi mwâmi w’e Adma, Shemeberi mwâmi w’e Seboyimi n’omwâmi w’e Bela izîno lyâge ye Sowari. ");
INSERT INTO shr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Abâla bazinda bayankira omuhigo omu kabanda ka Sidimi yo enaligi nyanja y’omunyu. ");
INSERT INTO shr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bagezize myâka ikumi n’ibirhi erhi badwîrhe barhegekwa na Kedori-Laomeri, lêro omu mwâka gw’ikumi na kasharhu, bàgoma. ");
INSERT INTO shr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ci omu mwâka gw’ikumi na karhanu Kedori-Laomeri àyisha haguma n’omurhwe gw’abandi bâmi, balya bali bayumvinye boshi naye. Ahimira bene Refayimi aha Ashtaroti-Karnayimi, Abazuzimi abahimira aha Hama, Abaemimi omu kabanda ka Kiriyatayimi, ");
INSERT INTO shr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Abahoriti abahimira oku ntondo za Seyiri kuhika aha Eli-Parani lugo luli elubibi n’irungu. ");
INSERT INTO shr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bagonjolokera e Ayini Mishipati omu Kadesi. Bahima ab’omu cihugo c’abanya-Amaleki, kuguma n’Abamoreni, bo bàbâga e Hasasoni-Tamari. ");
INSERT INTO shr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Naye omwâmi w’e Sodomo, omwâmi w’e Gomora, omwâmi w’e Adma, omwâmi w’e Seboyimi n’omwâmi w’e Bela izîno lyâge ye Sowari nabo bàhiga okulwa; babalwikiza omu kabanda ka Sidimi. ");
INSERT INTO shr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Bakoza Kedori-Laomeri, mwâmi w’e Elami, Tideali mwâmi w’e Goyimi, Amrafeli mwâmi w’e Shineyari na Ariyoko mwâmi w’e Elasari, bâmi bâni oku barhanu! ");
INSERT INTO shr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Omu kabanda ka Sidimi mwâli muyunjwire bideka bya bulembo; omu kuyâka omwâmi w’e Sodomo n’omwâmi w’e Gomora bahirimamwo, abasigalaga bayâkira omu ntondo. ");
INSERT INTO shr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Abahimaga basâbunga ebyali omu Sodomo n’omu Gomora byoshi, n’ebiryo byamuli byoshi banacîgendera. ");
INSERT INTO shr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loti naye, mugala wa mulumuna wa Abramu, bamugwârha, banyaga n’ebirugu byâge byoshi banacîgendera. Yo ali ayûbasire e Sodomo. ");
INSERT INTO shr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Muguma omu bashugunukaga, akanya aj’ibwîra Abramu muhabraniya wali yûbasire aha murhi gwa Mambri Amoriti, mwene wâbo Esikoli na Aneri, bàli bîra b’Abramu. ");
INSERT INTO shr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramu erhi ayumva oku kwo mwene wâbo anahèsirwe mpira ntyo, asinga omurhwe gwa balume magana asharhu na bantu ikumi na munâni, balwî bakulu baburhagwa omu mwâge, abalibirhakwo kuhika aha Dani. ");
INSERT INTO shr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Erhi babà bamâcîgabamwo bikembe bibirhi, Abramu ye n’engabo yâge, bàbarhêra budufu, anabahima abaminika kuhika aha Hoba olunda lw’ebwa murhi gwa Damasko. ");
INSERT INTO shr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Alîkûza ebirugu byoshi, haguma na mwene wâbo Loti n’ebirugu byâge, kuguma n’abakazi n’abalume. ");
INSERT INTO shr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramu erhi akola arhabâluka emunda anahimiraga Kedori-Laomeri, ye n’abâmi bali boshi naye, omwâmi w’e Sodomo ayish’imuyankirira omu njira omu kabanda ka Sawe (lwo lubanda lwa mwâmi). ");
INSERT INTO shr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedeki mwâmi w’e Salemu ayisha adwîrhe omugati n’irivayi; ali mudâhwa wa Nyamuzinda w’enyanya bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Anacigisha Abramu ederha, erhi: «Abramu agishwe na Nyamuzinda w’enyanya bwenêne owalemaga amalunga n’igulu, ");
INSERT INTO shr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ayâgirwe Nyamuzinda w’enyanya bwenêne owahiraga abashombanyi bâwe omu nfune zâwe». Abramu anacimurhûla oku ngasi ebi anali adwîrhe byoshi. ");
INSERT INTO shr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Oyu mwâmi w’e Sodomo anacibwîra Abramu, erhi: «Ompè abantu oyôrhane ebirugu». ");
INSERT INTO shr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ci kwône Abramu ahûna oyo mwâmi w’e Sodomo, erhi: «Ndengezize okuboko kwâni emunda Nyamuzinda w’enyanya bwenêne ali ye walemaga amalunga n’igulu». ");
INSERT INTO shr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ciru n’ehigozi ciru n’ehishumi hy’enkwêrho zâwe ntâhyo narhôla omu birugu byâwe: orhag’iderha erhi: «Nie nagazize Abramu». ");
INSERT INTO shr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ntâhyo ntôzire ciru n’ehitya. «Byo ntaderha ebi abarhumisi bâni balyaga n’ecigabi nahàga abîra bantabalaga bo Aneri, Esikoli na Mambri; abôla barhôla ngasi muguma ecâge cigabi». ");
INSERT INTO shr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Enyuma ly’ebyo, akanwa ka Nyamubâho kanacirhindakwo Abramu omu cilôrho, kaderha ntya, erhi: «Orhayôbohaga Abramu, nie mpenzi yâwe, oluhembo lwâwe lwâbà lunene». ");
INSERT INTO shr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abramu ashuza, erhi: «Waliha Nyamubâho bicigi wanshobôza? Niono nafà buzira mwâna, niono omu njira rhwêne Eliezeri w’e Damasko, ye wayîma omu byâni». ");
INSERT INTO shr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramu aderha, erhi: «Lolà oku orhampâga iburha na muguma omu bene wîrhu ye wayîsh’iyîma omu byâni». ");
INSERT INTO shr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kandi aho, akanwa ka Nyamubâho kanacimurhindakwo, erhi: «Arhali wabene oyo wanayîme omu byâwe ci muguma warhenga omu mukò gwâwe». ");
INSERT INTO shr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Oku bundi amujâna embuga amubwîra, erhi: «Galamira emalunga, oganje enyenyêzi z’emalunga nk’oku onahashire», anacimubwîra, erhi: «Kwo iburha lyâwe lyabà ntyo». ");
INSERT INTO shr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramu ayêmêra Nyamubâho, naye Nyamubâho erhi abà amamuganjira birya, amuyêreka oku kwoshi kunali k’okuli. ");
INSERT INTO shr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ashub’ibwîra Abramu, erhi: «Nie Nyamubâho wakurhenzagya e Uru omu Kaldeya nti nkuhè eci cihugo cibè câwe». ");
INSERT INTO shr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abramu ashuza, erhi: «Yâgirwa Nyamubâho, bici namanyirakwo oku nêci canabà câni?» ");
INSERT INTO shr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Anacimushuza, erhi: «Kanyagya ondêrhere endaku ya myâka isharhu, empene ya myâka isharhu, engandabuzi ya myâka isharhu, orhôle n’empingà n’ecananyunyi c’engûkù». ");
INSERT INTO shr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ayisha amudwîrhîre ebyo bintu, abiberanga analambika ngasi luhande omu masù g’olwâbo, ebinyunyi byoki arhaberangaga. ");
INSERT INTO shr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bacigukuma mpu bacîrhunike kuli erya mirhumba, Abramu akazibahâhanya. ");
INSERT INTO shr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Erhi izûba libà likola lyazika, enjôli nnene yarhogerakwo Abramu, ecôbà cinene camugwârha. ");
INSERT INTO shr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Nyamubâho anacibwîra Abramu, erhi: «Omanye bwinjà oku abâna bâwe bâbà nka bigolo omu cihugo cirhali câbo. Babà bajà eyo munda banabalibuze myâka magana anni. ");
INSERT INTO shr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ci olubaga lwabarhindibuza ntyo niene nalutwira olubanja na buzinda bayagaluke erhi banadwîrhe birugu mwandu. ");
INSERT INTO shr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wêhe wakulikira basho n’omurhûla, wagishwa omu kushanja bwinjà. ");
INSERT INTO shr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Oku iburha lya kani go mango banashubire eno, bulya obubî bw’abanya-Amoriti burhacihika oku muhiro». ");
INSERT INTO shr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Izûba lyabîrage lyamazika n’obudufu erhi bwamarumbâna, lolà oku ecibêye c’omugî n’ecimole n’omuliro byàgera ekarhî ka zirya nyama mberange. ");
INSERT INTO shr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Olwo lusiku Nyamubâho àfundika endagâno boshi n’Abramu ederha, erhi: «Iburha lyâwe ndihîre eci cihugo, kurhenga oku lwîshi lw’e Mîsiri kuhika oku lwîshi lunene, lwo lwîshi lwa Efrata. ");
INSERT INTO shr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Cihugo c’Abakeniti, Abakeniziti, Abakadimoniti, ");
INSERT INTO shr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","abahititi, Abaperiziti, Abarefayimi, ");
INSERT INTO shr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Abamoriti, abanya-Kanâni, Abagirigashiti n’Abayebuseni». ");
INSERT INTO shr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi mukà Abramu arhâlisag’imuhâ mwâna. Cikwônene Sarayi ali agwêrhe omujà-kazi wâge w’e Mîsiri izîno lyâge ye Hagari. ");
INSERT INTO shr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi, anacibwîra Abramu, erhi: «Lolà, we kasinga obu Nyamubâho arhanyêmêreraga okuburha, j’emunda omujà-kazi wâni ali, nkaba hali amango ankacimbonera abâna». Abramu ayumva izù lya Sarayi. ");
INSERT INTO shr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ntyo, Abramu erhi ajira myâka ikumi ali omu cihugo c’e Kanâni, mukâge Sarayi amuhà Hagari, mujà-kazi wâge munyamisiri, amuhà ibà Abramu mpu amuyanke. ");
INSERT INTO shr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Naye, anacijà emunda Hagari ali, arhôla izîmi. Nyamukazi kurhenga amango abonaga akola ali izîmi arhacilolaga nn’omumwâbo nka muntu. ");
INSERT INTO shr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi anacibwîra Abramu, erhi: «We orhumire njakwo aka kagayo! Nayansire omujà-kazi wâni nakufumbikaye, na kurhenga amango abonaga akola ali izîmi, niono ntacibonwa nka muntu omu masù gâge. Nyamuzinda yêne arhufunge rhwembi!». ");
INSERT INTO shr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramu abwîra Sarayi, erhi: «Omujà-kazi wâwe omu maboko gâwe anali, wêne omujirire oku onasîmire». Obwo Sarayi akaz’ilibuza owâbo kuhika owâbo amuyâka. ");
INSERT INTO shr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malahika wa Nyamubâho anacishimâna Hagari hôfi n’iriba liguma omu irungu, lyo iriba libà oku burhambi bw’enjira y’e Shuru. ");
INSERT INTO shr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Amudôsa, erhi: «Hagari, mujà-kazi wa Sarayi, ngahi warhenga na ngahi wajà?». Hagari anacimushuza, erhi: «Najà nayâka nn’omumwîrhu Sarayi». ");
INSERT INTO shr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malahika wa Nyamubâho amubwîra, erhi: «Galuka, oshubire emwa nn’omumwinyu onakazimuyumva». ");
INSERT INTO shr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Malahika wa Nyamubâho amubwîra, èrhi: «Naluza bwenêne iburha lyâwe, lyaluga liyabirane okuganjwa». ");
INSERT INTO shr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malahika wa Nyamubâho anacimubwîra, erhi: «W’oyo oli izîmi, waburha omwânarhabana, wayîsh’imuyîrika izîno lya Ismaeli, bulya Nyamuzinda anayumvîrhe omulenge gwâwe. ");
INSERT INTO shr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Oyo mwâna abà ndogomi nkali ya muntu, okuboko kwâge kwakâlikirwa abandi boshi n’okuboko kw’abandi boshi ye kwalikirwa. Ayimanga yêne omu masù ga bene wâbo boshi». ");
INSERT INTO shr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagari ayîrika Nyamubâho wamubonekeraga eri izîno: erhi: «we El Royi», kwo kuderha «We Nyamuzinda Obona», bulya gwârhi yêne, «Ka ye nshubir’ibona aha olya odwîrhe ambona?» ");
INSERT INTO shr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Co cirhuma eryo iriba liderhwa mpu iriba lya Lahayi-Royi, libà ekarhî ka Kadesi na Beredi. ");
INSERT INTO shr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagari anaciburhira Abramu omwânarhabana, naye Abramu àyîrika mugala wa Hagari izîno lya Ismaeli. ");
INSERT INTO shr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu ali akola agwêrhe myâka makumi gali munâni na ndarhu erhi Hagari amujira Îshe wa Ismaeli. ");
INSERT INTO shr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramu erhi ajira myâka makumi gali mwenda, Nyamubâho amubonekera amubwîra, erhi: «Nie El-Shadayi, Nyamuzinda Ogala-byoshi, olambagire embere zâni onayôrhe mwimâna. ");
INSERT INTO shr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nafundika endagâno yâni na nâwe, nakuluza bwenêne». ");
INSERT INTO shr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu anacikumba bûbi, na Nyamuzinda amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Niono, endagâno yâni nâwe yeyi: Wabà îshe w’amashanja manji manji. ");
INSERT INTO shr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Barhakanacikuderha Abramu, ci we kola Abrahamu, bulya nakujira îshe wa mashanja manji manji. ");
INSERT INTO shr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nakuhà iburha lirhali linyi, wabà îshe wa mashanja manji na bâmi banji bakurhengamwo. ");
INSERT INTO shr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nafundika endagâno yâni rhwembi, ekarhî kâni n’iburha lyâwe enyuma zâwe, n’obûko bwâwe enyuma zâwe, kurhenga oku iburha kujà oku lidi, yabà ndagâno y’ensiku zoshi, kuderha nti mbè Nyamuzinda wâwe na Nyamuzinda w’iburha lyâwe enyuma zâwe. ");
INSERT INTO shr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nakuhà w’oyo n’iburha lyâwe ecîra cihugo oyubasiremwo, ecihugo ca Kanâni coshi, câbà câwe ensiku zoshi, nâni nâbà nie Nyamuzinda wâwe». ");
INSERT INTO shr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nyamuzinda abwîra Abrahamu, erhi: «Woyo olange bwinjà endagâno yâni, woyo n’iburha lyâwe enyuma kurhenga oku iburha kujà oku lindi. ");
INSERT INTO shr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Alaga endagâno yâni mukwânîne mulange, ndagâno ekarhî kâni na nâwe, kwo kuderha we n’iburha lyâwe enyuma zâwe: Ngasi mwânarhabana w’omu nyumpa yâwe yêshi akwânîne akembûlwe. ");
INSERT INTO shr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mujire bammukembûle, kwo kuderha batwe ehishisha hy’obulume bwinyu, co cabà cimanyîso c’endagâno yâni ekarhî kâni na ninyu. ");
INSERT INTO shr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ngasi mwânarhabana winyu, erhi akajira nsiku munâni abusirwe, anakembûlwe, kurhenga oku iburha kujà oku lindi. Oyo anabà mwânarhabana waburhwa omu nyumpa yâwe nîsi erhi omwânarhabana waguliragwa ecigolo cirhali c’omu bûko bwâwe. ");
INSERT INTO shr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Oyo obusirwe omu nyumpa yâwe, n’oyo wagulagwa nsaranga, kukwânîne bakembûlwe. Endagâno yâni yashâkwa omu mubiri gwinyu nka ndagâno y’ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Orhali mukembûle, omulume barhatwîri ehishisha hy’oku bulume bwâge, oyôla kukwânîne akagwe omu bûko bwinyu, bulya arhakenziri endagâno yâni». ");
INSERT INTO shr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nyamuzinda abwîra Abrahamu, erhi: «Mukâwe Sarayi irhondo orhacihîraga okamuderha mpu ye Sarayi, ci izîno lyâge ye kola wâbà Sara. ");
INSERT INTO shr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Namugisha nankuhè omwânarhabana wa kuli ye, namugisha abè nnina w’amashanja, anaburhe amashanja aburhe n’abâmi b’amashanja». ");
INSERT INTO shr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahamu akumba bûbi, arhondêra asheka, anacîdesa yêne, erhi: «K’omwâna akaciburhwa n’omushosi wa myâka igana, na Sara ogwêrhe myâka makumi gali mwenda, ka anaciburha?» ");
INSERT INTO shr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahamu, erhi: «Ciru Ismael arhanarhang’ilama embere zâwe!» ");
INSERT INTO shr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nyamuzinda ashuza, erhi: «Kwo binali, mukâwe Sara akuburhira omwânarhabana, wanamuyîrika izîno lya Izaki, nafundika endagâno yâni haguma naye, yabà ndagâno y’ensiku n’amango, kuderha nti mbè Nyamuzinda wâge n’ow’obûko bwâge bwayisha enyuma zâge. ");
INSERT INTO shr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Oku biyêrekîre Ismaeli nêci nkuyumvîrhe; naye mmugishire, namuhà iburha, namujire aluge bwenêne, aburha baluzi ikumi na babirhi, namujira ishanja linene. ");
INSERT INTO shr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ci kwônene endagâno yâni, Izaki ye rhwayifundika rhweshi, mugala wâwe waburhwa na Sara mwâka irhondo nka gano mango». ");
INSERT INTO shr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Erhi ayûsa ashambâla, Nyamuzinda asêzera Abrahamu. ");
INSERT INTO shr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Oku bundi Abrahamu anarhôla omugala Ismaeli, ngasi bandi banali ba maburhwa omu mwâge, n’abandi bambali agulaga n’enfaranga, rhuderhe ngasi banali balume b’aha mwa Abrahamu boshi abakembûla ehishisha hy’obulume bwâbo olwo lusiku lwonênè na kuhika ene nk’oku Nyamuzinda anamubwîraga. ");
INSERT INTO shr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Erhi Abrahamu akembùlwa erhi agwêrhe myâka makumi gali mwenda na mwenda, anacikembûlwa ehishisha hy’obulume bwâge. ");
INSERT INTO shr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Omugala Ismaeli naye ali agwêrhe myâka ikumi n’isharhu erhi akembûlwa ehishisha hy’obulume bwâge. ");
INSERT INTO shr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Olwo lusiku lwonênè, Abrahamu n’omugala Ismael, bakembûlwa. ");
INSERT INTO shr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abalume b’aha mwâge boshi, abâna b’omu mulala gwâge, na ngasi bandi agulaga nfaranga embuga, boshi bakembûlwa kuguma naye. ");
INSERT INTO shr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nyamubâho amubonekera aha murhi gwa Mambri erhi atamîre aha lusò lw’ecirâlo câge, amango g’idûrhu likali ly’omûshi. ");
INSERT INTO shr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Erhi alambûla amasù abona bantu basharhu bamuyimanzire aha burhambi. Erhi ababona arhenga aha lusò lw’ecirâlo ajà emunda bali, ahwera oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ababwîra, erhi: «Yâgirwa Nnâhamwîrhu nkusengîre, akabà ntonyire omu masù gâwe, orhageraga aha burhambi bwa mwambali wâwe buzira kuyimanga. ");
INSERT INTO shr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Baj’ilêrha mîshi masungunu mukalabe amagulu, munarhamûkire hali ogu murhi. ");
INSERT INTO shr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Naj’ilonza ecihimbi c’omugati murhûzemwo omurhima mubul’igenda, e kuli mwaja co canarhumaga mugera aha mwa mwambali winyu eco!». Banacishuza mpu: «Ojirage nk’okwo odesire». ");
INSERT INTO shr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahamu anacibadukira omu cirâlo emunda Sara ali amubwîra, erhi: «Orhôle mirengo isharhu ya nshâno, obumbe onabajiriremwo orhugati.» ");
INSERT INTO shr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abrahamu akanya ajà omu busô bwâge, arhôlamwo akanina k’omutwîrà kashushagîre bwinjà akahà omwambali, naye akanya aj’ikarheganya. ");
INSERT INTO shr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ayisha adwîrhe amashanza, empyuhyu na kalya kanina anabâgaga, adêkereza embere zâbo; naye ayimanga hôfi nabo aha idako ly’omurhi oku bakâlya. ");
INSERT INTO shr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Banacimudôsa, mpu: «Ngahi mukâwe Sara ali?» Abashuza, erhi: «Yoyo otamîre omu cirâlo». ");
INSERT INTO shr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Olya w’ecigolo ederha, erhi: «Mwâka irhondo nashub’igera hano mwâwe kandi, n’ago mango, erhi mukâwe Sara agwêrhe mugala». Sara akazâg’iyumviza aha lusò lw’ecirâlo càli enyuma zâge. ");
INSERT INTO shr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ci Abrahamu na Sara bali bakola bashosi ba myâka minji, na Sara ali amahwerwa arhacijâga omu mugongo. ");
INSERT INTO shr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Lêro Sara acîshesa, erhi: «K’aga mango nahwîre nakaciyumva amasîma! N’îbanie oyûla okola luvandagwa!». ");
INSERT INTO shr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ci kwône Nyamubâho abwîra Abrahamu, erhi: «Cirhumire Sara asheka anaderha erhi: Ka kuburha nâni nakaciburha nankola ncîbêrire ntâye?» ");
INSERT INTO shr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","«Ka hali ebirhangâzo byankayabira Nyakasane okujira? Mwâka irhondo nka gano mango, nashubira eno mwâwe na Sara aburha mugala». ");
INSERT INTO shr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara acìhakanula, erhi: «Mâshi ntashesire», ali amayôboha, ci kwône amubwîra, erhi: «Nêci washesire». ");
INSERT INTO shr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Balya balume banaciyimuka, bagenda, bàhika aha bàkalangîra Sodomo. Abrahamu àja alambagira boshi nabo mpu abaluse. ");
INSERT INTO shr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nyamubâho àcîdôsa erhi: «Kurhi nafulikaga Abrahamu akantu ndâlire okujira, ");
INSERT INTO shr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","n’obwo Abrahamu abà ishanja linene na lizibu n’agandi mashanja g’igulu goshi gagishwa muli ye? ");
INSERT INTO shr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bulya nacîmwishozire nti arhegeke abâna bâge n’enyumpa yâge enyuma zâge mpu balange enjira ya Nyamubâho omu kujira ebishingânîne n’ebilongîre»; na ntyo, Nyamubâho anajirira Abrahamu ebi amulaganyagya. ");
INSERT INTO shr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ntyo, Nyamubâho anaciderha, erhi: «Omulenge gushobesire Sodomo na Gomora gurhali munyi! Ecâha câbo carhalusire. ");
INSERT INTO shr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nkolaga nabunguluka ndole erhi nanga erhi nêci bajizire ebîra omulenge gubashobesire emunda ndi gumanyisize: nâni ntacihabè». ");
INSERT INTO shr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Balya bantu barhenga halya bàjà olunda lw’e Sodomo. Abrahamu erhi aciyimanzire embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahamu ayegêra, aderha, erhi: «Kàli onakolaga waherêrekeza omushinganyanya haguma n’enkola-maligo? ");
INSERT INTO shr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kwankabà habonekana bantu bashinganyanya makumi arhanu mw’olwo lugo. Kàli onakolaga wabaherêrekeza? K’orhankababalira olwo lugo erhi abo bashinganyanya makumi arhanu galulimwo garhuma? ");
INSERT INTO shr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nanga orhankajira ntyo! Okuherêrekeza omushinganyanya haguma n’enkola-maligo, okugeza omushinganyanya cikembe ciguma n’omunyabyâha. Nanga ntà mango. K’omutwî w’emmanja w’igulu lyoshi arhakacitwa mmanja?» ");
INSERT INTO shr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nyamubâho anacishuza, erhi: «Nkashigâna e Sodomo bantu makumi arhanu bashinganyanya omu lugo, nanababalira ecishagala coshi bo bàrhuma» ");
INSERT INTO shr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahamu ashub’iderha, erhi: «Ciru nkabâ katulo na luvû, nashub’icîshomya okushambâza Nnâhamwîrhu. ");
INSERT INTO shr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Hali amango omu bashinganya makumi arhanu hankabula barhanu: Ka wanahana ecishagala coshi erhi abo barhanu bo barhumire?» Nyamubâho amushuza, erhi: «Nanga, erhi hankabâ bashinganyanya makumi anni na barhanu, ntankaciluhana». ");
INSERT INTO shr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahamu ashubirira, erhi: «Nkaba hanayîsh’ibonekana makumi anni gône». Nyamubâho amushuza, erhi; «Ntakujire erhi ago makumi anni garhuma». ");
INSERT INTO shr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahamu, erhi: «Nnawîrhu arhabâga burhè, nshub’iderha; nkaba hanaciboneka makumi asharhu». Naye, erhi ntaluhane hakabonekana ago asharhu. ");
INSERT INTO shr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ayûshûla, erhi; «Nashub’icîshomya okushambâza Nnawîrhu: Nkaba hanaciboneka makumi abirhi». Nyamubâho amushuza, erhi; «Ntacishâbe erhi ago makumi abirhi go garhuma». ");
INSERT INTO shr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahamu, erhi: «Nnawîrhu arhabâga burhè, nderhe ecinwa cizinda: Nkaba hankaciboneka ikumi lyône»; Nyamubâho amushuza, erhi: «Ntacihane erhi eryo ikumi lyo lirhumire» ");
INSERT INTO shr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nyamubâho erhi ays’ishambâza Abrahamu, agenda, naye Abrahamu ashubira emwâge. ");
INSERT INTO shr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Erhi balya bamalahika babirhi bahika aha Sodomo câjîngwè, Loti ali abwârhîre aha muhango gw’olugo. Erhi Loti ababona ayimuka, akanya aj’ibayankirira, ahwera oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Aderha, erhi: «Mmuhûnyire mâshi banawîrhu muyishe muyandagalire emwa mwambali winyu muj’ihandayo, mugeze amîshi oku magulu, n’irhondo sêzi mwanahira njira», ci bôhe bashuza, mpu: «Nanga, rhwalâla muno ngo». ");
INSERT INTO shr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ci kwône abayinginga bwenêne kuhika bayêmêra okujà emwâge n’okujà omu nyumpa. Abarheganyiza ebiryo, abayokera omugati gurhalimwo lwango, banacilya. ");
INSERT INTO shr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Oku barhacigwîshira, enyumpa yoshi yagorhwa n’abalume b’omu lugo, bantu b’e Sodomo, kurhenga oku misole kuhika oku bashosi, olubaga lwoshi buzira kusiga ndi nyuma. ");
INSERT INTO shr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bayâkûza Loti banacimudôsa, mpu: «Ngahi bali balya bantu bajìire hanôla mwâwe buno budufu? Orhuhè bo rhubalâlane». ");
INSERT INTO shr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti ahuluka ajà emunda bali emuhanda, anayigal a olumvi enyuma zâge. ");
INSERT INTO shr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Anacibabwîra, erhi: «Bene wîrhu, mwe mukasinga, mumanye mwankakola amabî! ");
INSERT INTO shr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Yumvi mmubwîre, ngwêrhe banyere babirhi barhasâg’imanya balume, nnammulerherabo: mubajire oku mubwîne kwinjà, ci abôla bantu mumanye mwankaderha mpu mwabahumakwo, bulya mwo bàjîre omu cihôho c’enyumpa yâni». ");
INSERT INTO shr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ci bahuza, mpu: «Orhenge aho! Azind’iyisha ali mubunga, yoyo wamacijiraga mutwî wa manja! Wâbà we rhujira kubî kubalusha». Bacîrhunika kuli Loti bwenêne; bamuyishakwo bakola bapamula olumvi. ");
INSERT INTO shr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ci balya balume bombi, banacirîka okuboko, bakululira Loti aha burhambi bwâbo, omu nyumpa, banahamika olumvi. ");
INSERT INTO shr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bahunika balya bantu kw’olumbwibwi aha lusò, kurhenga oku murhò kuhika oku mukulu, bayabirwa ciru n’okubona omuhango. ");
INSERT INTO shr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Balya bantu babirhi banacibwîra Loti, mpu: «Ka hali bandi bene winyu ojira enôla munda? Bagala bâwe, ngasi bene winyu bali munôla lugo boshi obarhenze hanôla. ");
INSERT INTO shr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Rhukola rhwashâba luno lugo, bulya omulenge kuli abâla bantu emwa Nyamubâho gwarhalusire, na Nyamubâho anarhurhumire mpu rhubamalire». ");
INSERT INTO shr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Loti akanya aj’ibwîra abakwi bakazagisheba abâli, erhi: «Yimuki murhenge muli cino cihugo bulya Nyamuzinda alâlire okucishâba»; ci abakwi bamaya mpu kuhalîza. ");
INSERT INTO shr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Erhi kubà mucêracêra, bamalahika banacisêza Loti, mpu: «Yimuka orhôle mukâwe n’abà bâli bâwe bali ahâla bombi, ogende lyo orhag’igwa omu buhane Nyamubâho ahanamwo bino bishagala». ");
INSERT INTO shr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mpu acizindoloka, balya balume babirhi bamugwârhira oku kuboko ye na mukâge n’abâli oku banali babirhi, bulya Nyamuzinda ali alonzize okubacinga. Bamuhulusa banamulekera emuhanda gw’olugo. ");
INSERT INTO shr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Oku bamuhêka e muhanda, muguma muli balya bamalahika amubwîra, erhi: «Kanya oyâke duba duba, ocize omûka gwâwe, orhakabaganaga enyuma orhanayimangaga ngahi omu kabanda ci oyâkire oku ntondo lyo olek’ihêkwa omu nsanyâ». ");
INSERT INTO shr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti abashuza, erhi: «Nanga, Nnâhamwîrhu. ");
INSERT INTO shr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mwambali wâwe arhonyire omu masù gâwe, wananyêresire olukogo lwâwe ene ofungira omûka gwâni. Ci kwône, ntankayakira oku ntondo, mpike n’obwo buhanya burhantindakwo, obone namafâ». ");
INSERT INTO shr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","«Lolà lula lugo luli hôfi; omuntu anayakiramwo, lurhali lunganaci. Oleke nyakiremwo; luligi lunganaci? Lyoki nankalobôka». ");
INSERT INTO shr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Naye amushuza, erhi: «Nkubêrire kandi olwo lukogo, ntacishâbe olwo lugo odesire. ");
INSERT INTO shr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kanyagya oyâkiremwo bulya ntâco najira orhanacihikamwo». Co carhumire bayîrika olwo lugo izîno lya Sowari. ");
INSERT INTO shr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Erhi izûba likola lyashoshôka, Loti ahika omu Sowari. ");
INSERT INTO shr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Oku bundi Nyamubâho anacirhogeza enshâno y’ecibiriti n’omuliro kuli Sodomo na kuli Gomora. ");
INSERT INTO shr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Anacishâba ebyo bishagala n’olubanda lwoshi, haguma n’abantu balimwo na ngasi hyasi hy’oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mukà Loti mpu akabagana enyuma, ashuba cirundo ca munyu. ");
INSERT INTO shr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahamu azûka sêzisêzi ajà halya ayimangaga embere za Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Alâba Sodomo na Gomora n’akabanda koshi, alangîra omugî gwatumbûka omu cihugo nka mugî gw’omu cibêye. ");
INSERT INTO shr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ntyo ago mango, Nyamuzinda ashâbaga ebishagala by’omu kabanda, akengêra Abrahamu, akûla Loti muli obwo buhanya, erhi akola ashanda ebishagala Loti ayubakagamwo. Obûko bwa bene Mowabu n’obwa bene Amoni. ");
INSERT INTO shr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti arhenga e Sowari, agend’iyûbaka oku ntondo bône abâli bombi, bulya ali ayôbohire okubêra e Sowari. Banacigend’ibêra omu lukunda bon’abâli bombi. ");
INSERT INTO shr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Omwâli mukulu anacibwîra omurhò, erhi: «Larha oyûla okola mushosi na ntà mulume wankajà emunda rhuli nk’oku banajira omu igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Oyîshe rhunywese Larha idivayi rhunalâle rhwe naye; ntyo larha rhwanamukûlakwo iburha». ");
INSERT INTO shr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Banacinywesa îshe idivayi mw’obwo budufu, omunyere mukulu aj’igwîshira aha burhambi bw’îshe, arhamanyaga ciru amango azukaga. ");
INSERT INTO shr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Erhi buca, omunyere mukulu abwîra omulumuna, erhi: «Injo budufu nalâzire rhwe na larha; rhushub’imunywesa idivayi muli obu budufu, nâwe ogend’ilâla mwe naye, ntyo larha rhwamukulakwo iburha». ");
INSERT INTO shr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Banacinywesa îshe idivayi kandi obwo budufu, n’omunyere murhò agend’igwîshira aha burhambi bwâge. Arhamanyaga amango agwishiraga ciru n’amango azûkaga. ");
INSERT INTO shr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bâli ba Loti bombi banacibà izîmi, erhi n’izîmi liri ly’îshe. ");
INSERT INTO shr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Omukulu aburha murhabana, anacimuyîrika erya Mowabu, ye shakulûza wa bene Mowabu. ");
INSERT INTO shr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Omurhò naye aburha murhabana, amuyîrika erya Beni-Ami, ye shakulûza wa bene Amoni. ");
INSERT INTO shr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu arhenga eyo munda ajà omu cihugo ca Nêgebu, ayûbaka ekarhî ka Kadesi na Shuru. Abêra aha Gerari. ");
INSERT INTO shr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abrahamu, omu kuderha mukâge Sara, ayisha, erhi: «Mwâli wîrhu oyo», lêro Abimeleki mwâmi w’e Gerari arhumiza mpu bamugwârhire Sara. ");
INSERT INTO shr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ci kwône Nyamuzinda abonekera Abimeleki omu bilôrho budufu amubwîra, erhi: «Wafâ kuli oyu mukazi oyansire, bulya ali mukazi ogwêrhe îba». ");
INSERT INTO shr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki, arhâli acîmuyegêra, kwo kuderhaga, erhi: «Muhânyi, ka wayîrha n’abêru kwêru?. ");
INSERT INTO shr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kàli Abrahamu yêne wambwîraga, erhi mwâli wîrhu oyu, na nyamukazi naye yêne aderha erhi mushinja wîrhu oyu? Nakujizire n’obushinganyanya bw’omurhima n’obw'amaboko garhalikwo izâbyo». ");
INSERT INTO shr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nyamuzinda anacimubwîra kandi omu bilôrho, erhi: «Nâni mmanyire bwinjà oku wajiraga okwôla n’omurhima gw’obushinganyanya na kandi niene nakucîkaga nti olek’ingayisa n’ecâha; co carhumire ntaziga wamuhumakwo. ");
INSERT INTO shr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Na bunôla, ogalulage mukà oyu mulume: abà mulêbi akânakusengerera mpu lyo olama. Ci akabà orhamugalwiri, onamanye oku kufà wanafa, we n’abà aha mwâwe boshi». ");
INSERT INTO shr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki azûkiriza sêzisêzi ahamagala abambali boshi, abarhondêreza ebyôla byoshi anabwîragwa, nabo barhungwa n’obwôba bunene. ");
INSERT INTO shr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Oku bundi Abimeleki ahamagala Abrahamu amudôsa, erhi: «Kurhi oku warhujizire? Kubî kuci nakujirîre obûla walonza okumbarhuza ecâha cingan’aha nie n’ab’oku bwâmi bwâni? Wankolîre ebirhakolwa». ");
INSERT INTO shr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki ashub’idôsa Abrahamu, erhi: «Bici wali ogererîze ene ojira ntyôla?» ");
INSERT INTO shr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahamu ashuza, erhi: «Nakazâg’iderha omu murhima gwâni nti okurharhindira okurhînya Nyamuzinda kurhankaboneka mw’eci cihugo: banyîrha kw’oyu mukazi.» ");
INSERT INTO shr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ci kwône kandi anali mwâli wîrhu, aburhwa na larha ci arhaburhwa na nyâmà, ahindusirage mukânie. ");
INSERT INTO shr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na kandi, amango Nyamuzinda antegekaga mpu njè nazungula kuli n’enyumpa ya larha, nabwîra nyamukazi, nti: «Alaga oku wantabâlamwo: ngasi aha rhwakahika hoshi oderhe oku ndi mushinja winyu». ");
INSERT INTO shr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleki arhôla oku bintu bishwêkwa, ebinyinyî n’ebinênênè, oku bajà n’oku bajâkazi bâge aha Abrahamu anamugalulira mukâge Sara. ");
INSERT INTO shr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki anamubwîra, erhi: «Lolà ecihugo câni, eci cilambûle embere zâwe, oyubake aha onalonzize!» ");
INSERT INTO shr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abwîra Sara, erhi: «Obwîne oku mpîre mushinja winyu bikoroti cihumbi bya nfaranga. Okwôla kwakukûla enshonyi embere z’abà muli mweshi, na ntyo, ntà mwenda gwinyu nsigiremwo». ");
INSERT INTO shr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abrahamu asengerera Abimeleki emunda Nyamuzinda ali, naye Nyamuzinda afumya Abimeleki, mpu mukà Abimeleki n’abajà-kazi bâge lyo babona abâna. ");
INSERT INTO shr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Nyamuzinda aliamazanganya abakazi b’aha mwa Abimeleki boshi n’owal’irhumire, ali Sara, mukà Abrahamu. ");
INSERT INTO shr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nnâmahanga ayish’irhangula Sara, nk’oku anaderhaga; anamujirira nk’oku amulaganyagya. ");
INSERT INTO shr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara arhôla izîmi, aburhira Abrahamu omwânarhabana omu bushosi bwâge, omu mango Nyamuzinda anali atwîre. ");
INSERT INTO shr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahamu ayîrika omwâna Sara amuburhiraga izîno lya Izaki (Cishesa) nka kulya Nyamuzinda anarhegekaga. ");
INSERT INTO shr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahamu akembûla omugala Izaki enyuma lya nsiku munâni abusirwe, nk’oku Nyamuzinda anamurhegekaga. ");
INSERT INTO shr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu ali akola agwêrhe myâka igana erhi omugala Izaki aburhwa. ");
INSERT INTO shr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara anaciderha, erhi: «Nyamuzinda amanpa cishesa, ngasi boshi abayumva ogu mwanzi kushesa nabashesa». ");
INSERT INTO shr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ashub’iderha, erhi: «Ndi wankabwizire Abrahamu oku Sara ankaciyonsize abâna! bulya niono namaha obushosi bwâge omwâna». ");
INSERT INTO shr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Omwâna akula ananena amonka, Abrahamu ajirisa olusiku lukulu, olusiku banenesagya Izaki amonka. ");
INSERT INTO shr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lêro Sara alangira olya mwânarhabana omunya-Mîsiri Hagari aburhiraga Abrahamu adwîrhe ashârha boshi n’omugala Izaki. ");
INSERT INTO shr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Abwîra Abrahamu, erhi: «Ohuluse oyu mukazi boshi n’omugala, kurhakwânîni omwâna w’omujà-kazi ayîme bo na mugala wâni Izaki». ");
INSERT INTO shr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ako kanwa kababaza bwenêne Abrahamu kuli oyo mugala, ");
INSERT INTO shr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ci kwône Nyamuzinda abwîra Abrahamu, erhi: «Omanye orhabâga burhè erhi oyo mwâna w’omujà-kazi wâwe orhuma, ngasi oku Sara akanakuhûna onakuyêmêre bulyâla Izaki lyo iburha lyahêka izîno lyâwe ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ci oyu mwâna w’omujà-kazi naye namujiramwo ishanja, bulya naye ali mugala wâwe». ");
INSERT INTO shr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahamu azûka sêzisêzi, arhôla omugati n’ehibindi hy’amîshi ashanira Hagari, ahira omugala aha lurhugo, abahulusa. Nyamukazi ajà ahabuka omu irungu lya Bersheba. ");
INSERT INTO shr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Erhi amîshi gali omu hibindi gamuhwera akweba omwâna wâge omu hishaka ");
INSERT INTO shr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","aj’ibwârhala aha akalangira ishaka, nka aha omuntu ankalasha omwampi. Bulya kwo akazâg’iderha emurhima, erhi: «Ntalonza mbone oku oyu mwâna afâ». Atamala erya burhambi, arhondêra ayâma analaka. ");
INSERT INTO shr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nyamuzinda ayumva omulenge gw’omwâna erhi anali empingu, malahika wa Nyamuzinda ahamagala Hagari amubwîra, erhi: «Kurhi wabîre Hagari? Orhôbohaga bulya Nyamuzinda ayumvîrhe olujamu lw’omwâna aho ali. ");
INSERT INTO shr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yimuka, ogwârhe omwâna bwinjà bulya namujira lubaga lunene». ");
INSERT INTO shr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nyamuzinda arhenza olubwibwi omu masù ga Hagari, alangira iriba. Akanya aj’idôma abumba ehibindi, anaciywesa omugala. ");
INSERT INTO shr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nyamuzinda ayôrha ali boshi n’olya mwâna, akula, anabèra omu irungu, àbâ nfôla miherho. ");
INSERT INTO shr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ayûbaka omu irungu lya Parani, na nnina aj’imushebera omukazi Munya-Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Muli ago mango, Abimeleki ayisha boshi na Pikoli, murhambo w’abalwî bâge, abwîra Abrahamu, erhi: «Nyamuzinda ali haguma nâwe muli ebi odwîrhe wajira byoshi. ");
INSERT INTO shr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ocigashage buno oku izîno lya Nyamuzinda, oku orhakandenganya nie n’abâna bâni n’abinjikulu bâni; n’oku emunda ndi n’emunda ciri eci cihugo wayishagamwo nka cigolo, walanga obwîra buli nk’obûla nkujirakwo». ");
INSERT INTO shr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahamu ashuza, erhi: «Nêci ncîgashire kwo». ");
INSERT INTO shr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Naye Abrahamu atumuza Abimeleki iriba lyâge ly’amîshi bambali ba Abimeleki bamunyagaga. ");
INSERT INTO shr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki ashuza, erhi: «Ntamanyiri ndi wankajizire ntyo: nâwe wêne orhasâg’imbwîra akantu kuli ebyo, nâni niene ene bwo burhanzi nkumanya». ");
INSERT INTO shr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrahamu arhôla omu bintu byâge, ebinyinyî n’ebinene abiha Abimeleki na bombi oku bali babirhi bajira endagâno. ");
INSERT INTO shr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu arhôla bibuzi nda by’omu busô bwâge abihira hâgo hâgo. ");
INSERT INTO shr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki amudôsa, erhi: «Ebyo bibuzi nda ohizire hâgo hâgo, bici byajira aho?» ");
INSERT INTO shr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Amushuza, erhi: «Kuderha nti oyêmêre okurhôla ebîra bibuzi nda by’omu maboko gâni, bibè buhamîrizi oku nie nanahûmbaga eryo iriba». ");
INSERT INTO shr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Co cirhuma ahôla haderhwa Bersheba, kulya kubà ahôla ho bombi bacîgashiraga. ");
INSERT INTO shr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Erhi babà bamafundika endagâno aha Bersheba, Abimeleki ayimuka boshi na Pikoli, murhambo w’engabo n’abalwî bâge, ashubira omu cihugo c’Abafilistini. ");
INSERT INTO shr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamu agwîka omurhi gw’etamarisi ahôla Bersheba anashengeraho izîno lya Nyamubâho, Nyamuzinda w’ensiku n’amango. ");
INSERT INTO shr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahamu ashinga myâka erhali minyi omu cihugo c’Abafilistini. ");
INSERT INTO shr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Enyuma z’aho, Nyamuzinda arhangula Abrahamu, amubwîra, erhi: «Abrahamu! Abrahamu!» Naye ashuza, erhi: «Ho ndi hano.» ");
INSERT INTO shr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nyamuzinda anacimubwîra, erhi: «Oyanke mugala wâwe cûsha, oyôla orhonya, Izaki, omujâne omu cihugo c’e Moriya, n’eyo munda, omuhâne nterekêro ya kusingonoka». ");
INSERT INTO shr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamu azûka sêzisêzi arheganya endogomi yâge na bambali babirhi n’omugala Izaki. Abeza enshâli z’enterekêro, bàhira njira bàjà erya munda Nyamuzinda amubwîraga. ");
INSERT INTO shr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Oku lusiku lwa kasharhu, Abrahamu agalamira, alangîra erya ntondo ci erhi enaciri kuli. ");
INSERT INTO shr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahamu anacibwîra abambali, erhi: «Mubêrage aha mweshi n’eyi ndogomi, nâni rhwe n’oyu mwâna, rhwahika hala, rhwaharâmya rhunashub’iyandagalira emunda muli». ");
INSERT INTO shr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamu ayanka enshâli z’enterekêro azibarhuza omugala Izaki, naye yêne afumbarha omuliro n’akêre, banagenda bombi. ");
INSERT INTO shr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Izaki anacidôsa îshe Abrahamu, erhi: «Larha!» Naye ashuza erhi: «Kurhi mwâna wâni?» Izaki, erhi: «Omuliro ogu rhudwîrhe, n’enshâli z’enterekêro, ci ngahi omwâna-buzi rhwagend’irherekêra ali?» ");
INSERT INTO shr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamu ashuza, erhi: «Nyamuzinda yêne abona aha arhenza omwâna-buzi w’enterekêro, mwâna wâni». Banacigenda bombi oku bali babirhi. ");
INSERT INTO shr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Erhi bahika aho Nyamuzinda amulangûlaga, Abrahamu ayûbaka oluhêrero, arherekeza enshâli, aziriringa omugala Izaki, amulambika oku luhêrero oku nyanya ly’enshâli. ");
INSERT INTO shr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahamu alambûla okuboko arhôla akêre mpu akolaga abâga omugala. ");
INSERT INTO shr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ci kwône Malahika wa Nyakasane anacimuyakûza kurhenga empingu, erhi: «Abrahamu! Abrahamu!» Abrahamu, erhi: «Ho ndi hano!» ");
INSERT INTO shr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malahika amubwîra, erhi: «Leka, orhalambûlire omwâna kwo okuboko! Orhanamujiraga kubî kuci! Namamanyaga oku kurhînya orhînya Nyamuzinda: orhandahirîre mugala wâwe, mugala wâwe cûsha». ");
INSERT INTO shr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","13 Abrahamu, alangira engandabuzi ehangarhine amahembe omu ishaka; Abrahamu aj’irhôla erya ngandabuzi ayirherekêra nterekêro ya kusingonoka ahâli h’omugala. ");
INSERT INTO shr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrahamu ayîrika aho hantu izîno lya «Nyamuzinda yêne abona ebyo», ciru na kuhika ene kwo bacihaderha mpu «Oku ntondo Nyamuzinda yêne abona ebyo». ");
INSERT INTO shr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malahika wa Nyamubâho ashub’ihamagala Abrahamu obwa kabirhi kurhenga empingu, ");
INSERT INTO shr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","anaciderha, erhi: «Lyo ndahîre izîno lyâni, kanwa ka Nyamubâho nkudesire, kulya kubà orharhindirîre mugala wâwe, omuguma ojira, ");
INSERT INTO shr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","\"nkolaga nakuyunjuza migisho, iburha lyâwe naliluza nka nyenyêzi z’oku nkuba na nka mushenyi gw’omu nyanja n’eryo iburha lyâwe lyakâhima omuhango gw’abashombanyi bâlyo\". ");
INSERT INTO shr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","\"Amashanja goshi g’igulu gagishwa erhi iburha lyâwe lirhuma bulya wanyumvîrhîze\"». ");
INSERT INTO shr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abrahamu ashubira emunda abambali bali. Bayimuka, bashubira boshi emwâbo e Bersheba. Abrahamu agend’iyûbaka e Bersheba. ");
INSERT INTO shr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Enyuma z’aho, babwîra Abrahamu oku Milka naye aburhîre omulumuna Nahori abarhabana. ");
INSERT INTO shr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Olubere ye Uzi, na Buzi amulonda, ahebakwo na Kemweli, îshe wa Aramu. ");
INSERT INTO shr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kandi Kesedi, Hazo, Pilidashi, Yidilafu na Betweli. ");
INSERT INTO shr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betweli aburha Rebeka; bo bâna munâni Milka aburhîre Nahori, mulumuna wa Abrahamu. ");
INSERT INTO shr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ali agwêrhe omukazi w’omuherula, izîno lyâge ye Reuma, naye amuburhira abâna: Tebahi, Gahama, Tahasha na Mahaka. ");
INSERT INTO shr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Emyâka Sara alamire liri igana na makumi abirhi na nda, ");
INSERT INTO shr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","afîra aha Kiriyati-Arba, ho haligi aha Hebroni, omu cihugo c’e Kanâni. Abrahamu ayisha ali oku bufîre bwa Sara. ");
INSERT INTO shr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahamu ayimanga embere z’omugogo gwâge, abwîra bene Heti, erhi: ");
INSERT INTO shr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Eno mwinyu, ndi yo mubunga nanciri cigolo. Mumpe nâni oluvumbu ntenze oyu muntu wâni mmubishemwo.» ");
INSERT INTO shr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bene Heti bashuza Abrahamu, mpu: ");
INSERT INTO shr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Yâgirwa orhuyumve nîrhu! Woyo ekarhî kîrhu, oliyo muluzi wa Nyamuzinda, ocîshoge nguma omu nshinda zîrhu, obishemwo omuntu wâwe, ntâye wankakulahirira enshinda wabishamwo mukâwe». ");
INSERT INTO shr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abrahamu ayimanga ayunama embere z’olubaga lw’ecihugo ca bene Heti, ");
INSERT INTO shr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","abashambàlira ntya, erhi: «Akabà muyemire ogu mugogo gwâni guntengekwo ngubîshe, munyumve munansengerere emwa Efroni, mugala wa Sohari, ");
INSERT INTO shr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","andekere olukunda lwa Makipela, lubà lwâge lunali oku irhwêrhwè ly’ishwa lyâge. Alumpe namuguliralwo lwoshi embere zinyu, lubè luvumbu lwâni». ");
INSERT INTO shr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ago mango Efroni ali abwârhîre ekarhî ka bene Heti; Efroni, Muhititi ashuza Abrahamu embere za bene Héti boshi n’embere z’abakazâg’itwa ec’olusò n’okujà omu lugo, ");
INSERT INTO shr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","erhi: «Nanga, nnâhamwîrhu onyumve erhi kwo. Nkuhîre eryo ishwa, nkuhîre n’olwo lukunda lilimwo, nkugabirelyo omu masù g’abâna b’ekà. Obishemwo omuntu wâwe». ");
INSERT INTO shr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahamu ayunama embere z’olubaga lw’eco cihugo. ");
INSERT INTO shr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Abwîra Efroni embere z’olubaga lw’eco cihugo, erhi: «Orhang’iyumva erhi kwo! Mpânyire engulo y’eryo ishwa, oyiyêmêre nâni, na ntyo nanabishamwo omuntu wâni». ");
INSERT INTO shr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni ashuza Abrahamu, erhi: ");
INSERT INTO shr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Nnâhamwîrhu, onyumve erhi kwo: ishwa lya magana anni ga sikêli za nsaranga cirigi cici eco kuli rhwe rhwembi? Obishe omuntu wâwe». ");
INSERT INTO shr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamu ayêmêra Efroni, Abrahamu agerera Efroni zirya nfaranga anaderhaga embere za bene Heti, galya magana anni g’esikeli z’enfaranga; go magerha gali garhonyire emwa abarhunzi. ");
INSERT INTO shr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ntyo ishwa lya Efroni libà aha Makipela, ishiriza lya Mambri, ishwa n’olukunda lulirimwo, haguma n’emirhi yalirimwo kuhebakwo n’olubibi lwâlyo, ");
INSERT INTO shr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","byoshi byashuba bya Abrahamu omu masù ga bene Heti boshi n’embere za ngasi boshi banakazâg’itwa ec’olusò n’okujà omu lugo. ");
INSERT INTO shr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Oku bundi, Abrahamu abisha mukâge Sara omu lwâla lwa Makipela ishiriza lya Mambri omu Hebroni, cihugo ca Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ntyo kwo Abrahamu abonaga ishwa n’olukunda lwalibagamwo emwa bene Heti; lwashuba luvumbu lwâge. ");
INSERT INTO shr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamu ali akola mushosi wa myâka minji, Nyamubâho ali erhi amuhîre omugisho muli ngasi kantu. ");
INSERT INTO shr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahamu abwîra omwambali, mugula wâge omu bambali, ye wanakazâg’ilanga ebyâge byoshi, erhi: «Ohebe okuboko kwâwe idako ly’olurhungu lwâni, ");
INSERT INTO shr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","nakulahiriza oku izîno lya Nyamubâho Nyamuzinda w’empingu n’igulu, oku orhalongeze mugala wâni omukazi omu banyere b’Abanya-Kanâni nyûbasire ekarhî kâbo. ");
INSERT INTO shr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ci kwônene, yo wajà emwîrhu, omu mulala gwîrhu, mwo wacîshoga omukazi washebera mugala wâni Izaki». ");
INSERT INTO shr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Omwambali anacimubwîra, erhi: «Haligi amango nyamukazi ankalahira mpu arhankulikire mwo cino cihugo, k’ago mango nanagalula mugala wâwe emunda warhengaga?» ");
INSERT INTO shr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahamu amushuza, erhi: «Nanga, orhahîraga okashubiza mugala wâni eyo munda. ");
INSERT INTO shr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Nyamubâho, Nyamuzinda w’empingu, Nyamuzinda w’igulu yênene wantenzagya omu nyumpa ya larha, n’omu cihugo ca bene wîrhu, yêne ye wanshambâzagya anandaganya n’endahiro oku eci cihugo acîhà iburha lyâni. Yêne arhuma malahika wâge embere zâwe, lyo abonera mugala wâni omukazi eyo munda. ");
INSERT INTO shr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Akabà oyo mukazi arhalonzizi okukushimba, orhacife n’ecihango, ci orhahîraga okashubiza mugala wâni eyo munda». ");
INSERT INTO shr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Oku bundi omwambali ahira okuboko oku cibero ca nnawâbo Abrahamu, anacigashira olwo lubanja. ");
INSERT INTO shr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nyamushizi anacirhôla ngamiya ikumi omu ngamiya za nnawâbo, anagendana n’oku ngasi hinjà nnawâbo ali agwêrhe, anacirikûla ajà entambiz’e Aram-Naharayimu omu lugo lwa Nahoro. ");
INSERT INTO shr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Engamiya zâge azifukamya emuhanda gw’olugo, hôfi n’iriba, câjîngwè, gala mango abakazi banahuluka mpu bagend’idôma amîshi. ");
INSERT INTO shr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Anaciderha, erhi: «Nyakasane, Nyamuzinda wa nnawîrhu Abrahamu, ongashânire ene, onayêrekane oku kurhonya orhonya mwambali wâwe Abrahamu. ");
INSERT INTO shr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","“Niono nyimanzire hano iriba, na bali b’abantu ba mw’olu lugo, bakola bayish’idôma amîshi.”» ");
INSERT INTO shr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Omwânanyere nakabwîra, nti: «Hengeka akabindi kâwe ompè nâni nywe, akananshuza, erhi: Nêci, nywaga onaleke nywese n’engamiya zâwe, erhi ye mukazi wali obikîre mwambali wâwe Izaki, co cimanyîso namanyirakwo oku orhonyize nnawîrhu». ");
INSERT INTO shr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Oku arhaciyusa aderha, Rebeka, mwâli wa Betweli, mwene Milka, mukà Nahoro, mulumuna wa Abrahamu ayisha n’akabindi oku cirhugo. ");
INSERT INTO shr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Oyo munyere ali mwinjinjà, mwânanyere mushugi, ntà mulume walisag’imuyegêra, abungulukira aha iriba abumba akabindi kâge anarherema. ");
INSERT INTO shr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Olya mushizi akanya aj’imurhangîra, amubwîra, erhi: «Mâshi, oleke nywe rhwishi rhutya kw’ago gali omu kabindi kâwe». ");
INSERT INTO shr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Olya munyere anacishuza, erhi: «Nywaga, Yâgirwa». Anaciyandagaliza dubaduba akabindi omu nfune mpu amunywese. ");
INSERT INTO shr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Erhi ayûs’imunywesa, anaciderha, erhi: «Nkola naj’idômera n’engamiya zâwe, kuhika zihâge». ");
INSERT INTO shr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Anacidubulira galya mîshi duba duba omu ciranga ashubirira aha iriba mpu adôme, anadômera engamiya zoshi. ");
INSERT INTO shr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Olya mulume oku ahuluka, akaz’imusinza, erhi anadwîrhe acîdôsa erhi nanga erhi nêci Nyamubâho amuhisize. ");
INSERT INTO shr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Erhi engamiya ziyus’inywa, olya mulume arhôla ehigondo hy’amasholo hya buzirho bwa luhande luguma lw’esikeli, amuyambisahyo, anacirhôla na rhulinga rhubirhi rhwa masholo rhwa buzirho bwa sikêli ikumi amuyambisa rhwo ekuboko. ");
INSERT INTO shr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Anacimubwîra, erhi: «Oli mwâli wa ndi? K’aha mwinyu, sho ankabona aha abantu bahanda?» ");
INSERT INTO shr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ashuza, erhi: «Ndi mwâli wa Betweli, mugala wa Milka mwene Nahori». ");
INSERT INTO shr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ashub’iderha, erhi: «Nêci aha mwîrhu bali ebyâsi birhali binyi, hanaboneka n’ecirâlo». ");
INSERT INTO shr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Oku bundi olya mulume afukama aharâmya Nyamubâho, ");
INSERT INTO shr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ederha, erhi: «Oyâgirwe Nyakasane, Nyamuzinda wa nnawîrhu Abrahamu, ôrharhînyirîre okurhonya n’okulumehera nnâhamwîrhu. Nyamubâho yêne oyûla onnongolîne kuhika aha mwa mwene wâbo nnâhamwîrhu». ");
INSERT INTO shr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Olya mwânanyere alibirha aj’ibwîra nnina ebyabîre. ");
INSERT INTO shr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka àli agwêrhe mushinja wâbo, izîno lyâge ye Labani, Labani anacilibirhira embuga emunda olya mulume ali, ebw’iriba. ");
INSERT INTO shr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Erhi abà amâbona ehigondo n’orhulinga mwâli wâbo ali ayambîrhe, n’erhi abà amâyumva mwâli wâbo Rebeka ederha, erhi: «Kw’oyo mulume ambwîzire ntyo», ago mango alibirhira emunda nyamulume ali, amushimâna aciyimanzire aha burhambi bw’engamiya ah’iriba. ");
INSERT INTO shr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Anacimubwîra, erhi: «Yisha mugishwa wa Nyamubâho! Cici cirhumire obêra embuga n’obwo narheganyize enyumpa n’ahantu engamiya zâwe zabêra?». ");
INSERT INTO shr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Olya mulume akanya aj’ekà, Labani ashwekûla emizigo y’engamiya, anaziha ebyâsi, analêrha amîshi mpu oyo mulume boshi h’abâbo bashukemwo amagulu. ");
INSERT INTO shr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bamulêrhera ebiryo mpu alyè. Ci kwône ashuza, erhi: «Ntalya ntanaciderha akanwa kandwîrhe». Labani ashuza, erhi; «Derhaga!» ");
INSERT INTO shr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Naye, erhi: «Niono ndi mwambali wa Abrahamu.» ");
INSERT INTO shr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nyamuzinda agishire nnawîrhu; akola àbà mugale, àmuhîre ebintu bishwêkwa, ebinyinyî n’ebinênênè, enfaranga n’amasholo, abambali n’abambalikazi, engamiya n’endogomi. ");
INSERT INTO shr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mukà nnawîrhu, Abrahamu, omu bugikulu bwâge, amuburhira omwânarhabana, n’oyo mwânarhabana ye afumbisire ebyâge byoshi. ");
INSERT INTO shr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nnawîrhu andahirize, erhi: «Irhondo orhahîraga okarhôlera mugala wâni omukazi omu banyere ba-nya-Kanâni, muli cino cihugo rhuyûbasiremwo. ");
INSERT INTO shr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","“Akabà orhajiri omu nyumpa ya larha, omu bûko bwîrhu okugend’ilogezamwo omukazi wahà mugala wâni, erhi wamanahera!”» ");
INSERT INTO shr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nabwîzire nnawîrhu, nti: «Hall amango oyo mukazi ankalahira bwankulikira». ");
INSERT INTO shr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Naye anshuza, erhi: «Nyamuzinda nyôrha ngenda embere zâge, akurhumira malahika wâge akuluse akuhisakwo ehi walonza, ly’obonera mugala wâni omukazi w’omu bûko bwîrhu n’omu nyumpa ya larha. ");
INSERT INTO shr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wâfuma ecihango erhi wankahika omu bûko bwîrhu, bakanakuyima omukazi, ecihango cirhacikuyirhe». ");
INSERT INTO shr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ene mpika aha iriba naderha, nti: Nyamubâho Nyamuzinda wa nnawîrhu, we kasinga, oyerekane, akabà olonzize okuhisa eyi njira ndimo kw’ehi nshimbire. ");
INSERT INTO shr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Niono ndi hano iriba, omunyere wayîsh’al’idôma, nâni nkamubwîra, nti: Nkuhûnyire ompè nâni rhwishi rhusungunu rhw’omu kabindi kâwe, ");
INSERT INTO shr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","akanashuza, erhi: wêne onywage, nagend’idômera n’engamiya zâwe, erhi ye mukazi Nyamubâho abîkîre mwene nnawîrhu. ");
INSERT INTO shr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ntali nciyusa naderha ebyo binwa omu murhima gwâni, ene Rebeka ayisha n’akabindi kâge oku cirhugo. Abungulukira ebw’iriba, anadôma. Namubwîra nti mpà nâni nywe, we kasinga. ");
INSERT INTO shr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ho na halya, akûla akabindi kâge oku cirhugo, ederha, erhi: «Nywaga nagend’idômera n’engamiya zâwe». Nanywire, agal’inywêsa n’engamiya zâni. 4 ");
INSERT INTO shr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Namudôsize, nti: Oli mwâli wa ndi? Naye anshuza, erhi: «Ndi mwâli wa Betweli, mulume Milka aburhiraga Nahori». Oku bundi namuyambisa ehi higondo oku izûlu n’orhu rhulinga aha maboko. ");
INSERT INTO shr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Aho, nafukamiriza naharâmya Nyamubâho, Nyamuzinda wa nnanwîrhu Abrahamu, ye wali annongolîne omu njira nyinjà mpu ntôlere omugala mwâli wa muci wa nnâhamwîrhu. ");
INSERT INTO shr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Bunôla akabà mulonzize okuyêreka nnâhamwîrhu oku mumusîmire munamurhonyize, mumbwîre n’akabà nanga kandi mumbwîre, lyo nyerekera ebwa kulyo erhi ebwa kumosho. ");
INSERT INTO shr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani bo na Betweli bashuza baderha, mpu: «Okûla emwa Nyamuzinda kurhenzire, rhurhankahash’ikushuza nti nêci erhi nanga. ");
INSERT INTO shr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka oyo embere zâwe: rhôla ye omuhêke, aj’ibà mukà mwene nnawinyu nk’oku Nyamubâho anadesire». ");
INSERT INTO shr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Erhi mwambali w’Abrahamu ayumva ebyo binwa, aharâmya embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ayômola ebisikiyo by’ecûma n’eby’amasholo, ayômola n’emishangi, aha Rebeka. Aha na mushinja wâbo boshi na nnina ebindi bikulo. ");
INSERT INTO shr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Oku bundi bàlya bànanywa bo n’abâbo bàli boshi, banalâla halya. Sêzi erhi babà bamazûka, ederha, erhi: «Mundîke nshubire emwa nnawîrhu». ");
INSERT INTO shr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mushinja wa Rebeka na nnina baderha, mpu: «Oyu munyere arhang’ibêra hano zindi nsiku nk’ibirhi erhi ikumi n’enyuma z’aho anagenda». ");
INSERT INTO shr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Abashuza, erhi: «Murhacindegerezagya n’obwo Nyamubâho ampisizekwo ehi nalonzagya. Muleke ngende, nshubire emwa nnawîrhu». ");
INSERT INTO shr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Banaciderha, mpu: «Rhuhamagalage namunyere rhumudòse naye kurhi adesire». ");
INSERT INTO shr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Banacihamagala Rebeka bamudôsa, mpu: «K’olonzize okugenda mweshi n’oyu mulume?» Naye anacishuza, erhi: «Nêci, nnonzize ngende». ");
INSERT INTO shr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Okubundi, bahêka omunyere wâbo Rebeka mpu agende bo n’omulezi wâge n’oyo mwambali w’Abrahamu na balya balume àli boshi. ");
INSERT INTO shr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Banacihà Rebeka obwangà, mpu: «Woyo mwâli wîrhu oyôloloke ohinduke bihumbi n’ebihumbi n’iburha lyâwe lihime enyumpa z’abashombanyi bâlyo». ");
INSERT INTO shr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka ayimuka boshi n’abambali-kazi, bashonera oku ngamiya, bakulikira olya mulume. Mwambali w’Abrahamu arhôla Rebeka, bahira njira. ");
INSERT INTO shr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ago mango Izaki àli ayishire omu irungu ly’iriba lya Lahayi-Royi, bulya mwo ali ayûbasire omu cihugo ca Nêgebu. ");
INSERT INTO shr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Izaki ahuluka mpu ajè acîgezageza ebwa mashwa câjîngwè, erhi ayînamula amasù alangîra engamiya zayisha. ");
INSERT INTO shr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka naye mpu ayînamula amasù, alangîra Izaki, ashonôka oku ngamiya. ");
INSERT INTO shr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Adôsa olya murhumisi, erhi: «Ye ndi ola mulume wayisha alambagira omu ishwa anayêrekîre eno munda rhuli?» ");
INSERT INTO shr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Olya mushizi ashuza, erhi: «Ye nnâhamwîrhu oyo». Namunyere arhôla ecitambara acîhundikira co. Olya mushizi ashambâlira Izaki oku agendaga kwoshi. ");
INSERT INTO shr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Izaki ahêka Rebeka omu cirâlo càli ca nnina Sara, ayanka Rebeka, amujira mukâge, anamurhonya. Na ntyo Izaki arhûlûla, arhacilakaga olufù lwa nnina. ");
INSERT INTO shr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu ayanka owundi mukazi izîno lyâge ye Ketura. ");
INSERT INTO shr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nyamukazi anacimuburhira Zimurani, Yokisani, Medani, Midiyani, Yisibaki na Shuwahi. ");
INSERT INTO shr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani aburha Sheba, na Dedani. Nabo bene Dedani: Basurimi na Baletusimi na Baleumi. ");
INSERT INTO shr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Bene Midiyani bali: Eferi, Efa, Hanoki, Abida na Elda. Abo boshi bàli bagala ba Ketura. ");
INSERT INTO shr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamu àhâ Izaki ebyâge byoshi. ");
INSERT INTO shr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Abandi bagala akazâg’iburha oku baherula bâge, abahà eby’okucîrhabâla, na kandi, oku acizîne yêne, abarhuma kulî n’omugala Izaki, omu cihugo c’ebushoshôkero. ");
INSERT INTO shr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Alaga emyâka y’akalamo k’Abrahamu: Alamire myâka igana na makumi gali nda n’irhanu. ");
INSERT INTO shr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Buzinda bw’aho, Abrahamu arhengamwo omûka, afà akola ali omu bushosi bwinjà, afà akola mukulu, erhi amanayigurha ensiku, ajà kuli bene wâbo. ");
INSERT INTO shr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Abagala, Izaki na Ismaeli bamubisha omu lukunda lwa Makipela, omu ishwa lya Efroni, mwene Sohari, muhititi aha ishiriza ly’e Mambri. ");
INSERT INTO shr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Lyo ishwa Abrahamu aguliraga bene Heti. Mwo Abrahamu abishirwe bo na mukâge Sara. ");
INSERT INTO shr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Erhi Abrahamu abà amâfà, Nyamuzinda agisha omugala Izaki ayûbaka hôfi n’iriba lya Lahayi-Royi. ");
INSERT INTO shr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Alaga iburha lya Ismaeli, mugala wa Abrahamu, ye waburhagwa n’omunya-Mîsiri, Hagari, mujà-kazi wa Sara. ");
INSERT INTO shr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Alaga amazîno ga bene Ismaeli omu kushimba amazîno n’okuburhwa kwâbo: Enfula y’Ismaeli ye Nebayoti, alondwa na Kedari, Adubeli, Mibusamu, ");
INSERT INTO shr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO shr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yeturi, Nafishi na Kedma. ");
INSERT INTO shr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bo bene Ismaeli abo, n’amazîno gâbo nk’oku ebishagala n’ebihando byâbo binali, bo barhambo ikumi na babirhi b’emilala yâbo oku enali. ");
INSERT INTO shr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Alaga n’emyâka y’akalamo ka Ismaeli: igana na makumi asharhu na nda. Oku bundi arhengamwo omûka, afà, ajà kuli bene wâbo. ");
INSERT INTO shr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ayûbaka kurhenga e Hawila kujà e Shuru, olunda lw’ebushoshôkero bwa Mîsiri omu kujà e Asîriya. Ali ayûbasire ishiriza lya bene wâbo boshi. ");
INSERT INTO shr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Alaga emyanzi ya Izaki mwene Abrahamu. Abrahamu aburha Izaki. ");
INSERT INTO shr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izaki ali akola agwêrhe myâka makumi anni erhi ayanka Rebeka mwâli wa Betweli, Munyarameyo w’e Padani-Arami, mwâli wâbo Labani naye Muharameyo. ");
INSERT INTO shr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Izaki asengerera mukâge emwa Nyamubâho, erhi amâbà ngumba, Nyamubâho amuyumva, mukâge Rebeka arhôla izîmi. ");
INSERT INTO shr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abâna bakazihukulana omu nda, lêro aderha, erhi: «Akabà kwo biri ntya, bici omuntu alamakwo?» Akanya aj’idôsa Nyamubâho, ");
INSERT INTO shr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","naye amushuza, erhi: «Mashanja abirhi gali omu nda yâwe, mashanja abirhi g’omu nda yâwe gagabanyika; mulala muguma gwahima ogwâbo, omukulu ashiga omurhò». ");
INSERT INTO shr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Erhi amango gâge g’okuburha gahika, lâba oku lyâli izîmi lya mahasha. ");
INSERT INTO shr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Owaburhagwa wa burhanzi, ali mudukula wa bishamvu ayunjwîre byoyabyoya. Bamuyîrika izîno lya Ezau. ");
INSERT INTO shr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Oku bandi omulumuna ahuluka, erhi okuboko kwâge kugwârhire Ezau oku kansisira. Bamuyîrika izîno lya Yakôbo. Izaki ali akola agwêrhe myâka makumi gali ndarhu erhi baburhwa. ");
INSERT INTO shr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Abânarhabana bombi bakûla; Ezau àbà muhivi mukulu, wa kutwikanya omu malungu. Yakôbo ali muntu mutûdu, akàbèra omu cirâlo. ");
INSERT INTO shr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izaki arhonya Ezau bulya asimaga ensimba, Rebeka yêhe Yakôbo ye arhonyagya. ");
INSERT INTO shr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mango maguma, Yakôbo ayenda ibinda ly’enkôle, naye Ezau ashubûka ebwa kuhiva erhi anarhamire. ");
INSERT INTO shr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Lêro Ezau anacibwîra Yakôbo, erhi: «Leka nâni mpuhekwo eryol’ibanda lidukula lidukula, bulya namahwa». -Co carhumire bamuderha mpu Edomi. ");
INSERT INTO shr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakôbo amubwîra, erhi: «Orhang’inguliza ecikono câwe c’okubà nfula». ");
INSERT INTO shr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezau ashuza, erhi: «Lolà oku kufà kuno, ecikono c’okubà nfula, bici cacinkwânana?» ");
INSERT INTO shr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakôbo ashubiza ederha, erhi: «Orhang’icîgasha embere zâni»; acîgasha, anaguliza Yakôbo ecikono câge c’okubà nfula. ");
INSERT INTO shr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Oku bundi, Yakôbo amuhà oku mugati n’oku ibinda ly’enkôle, alya ananywa, ayimuka agenda. Ntyo kwo Ezau agayaguzagya ecikono c’okubà nfula. ");
INSERT INTO shr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ecizombo canacizûka omu cihugo, kuleka cirya cizombo cirhanzi cabâga amango ga Abrahamu. Izaki ajà e Gerari, emwa Abimeleki mwâmi w’Abafilistini. ");
INSERT INTO shr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nyamubâho amubonekera amubwîra, erhi: Orhajâga e Mîsiri ci ogend’ibêra omu cihugo nakubwîra. ");
INSERT INTO shr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Obêre muli eco cihugo, nakugisha nanyorhe ndi haguma nâwe. Bulya we n’iburha lyâwe mwe nahà ebi bihugo byoshi, nasêza n’erya ndagâno nafundikaga rhwe na sho Abrahamu. ");
INSERT INTO shr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Naluza iburha lyâwe nka nyenyêzi z’oku nkuba, naliha ebi bihugo byoshi n’amashanja goshi g’igulu gagishwa n’iburha lyâwe. ");
INSERT INTO shr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kulya kubà Abrahamu ayumvîrhe izù lyâni, akulikira ebi nalimurhegesire okukulikira, amarhegeko gâni, ebinwa byâni, obulonza bwâni. ");
INSERT INTO shr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ntyo kwo Izaki abêziremwo aha Gerari. ");
INSERT INTO shr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Abantu b’eyo munda bakamudôsa olwa mukâge, ashuza, erhi: «Mwâli wîrhu oyo». Ayôboha okuderha, erhi: «Mukânie oyo», bàli bamuyîrha erhi Rebeka orhuma bulya ali mwinjà. ");
INSERT INTO shr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Erhi kugera mango garhali manyi, kwanacibà lusiku luguma, Abimeleki mwâmi w’Abafilistini erhi adwîrhe alolera omu kabonezo, alangira Izaki adwîrhe ashâsa mukâge Rebeka. ");
INSERT INTO shr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki anacihamagala Izaki amubwîra, erhi: «Mâshi mukâwe oyu! Kurhi waciderhaga mpu mwâli winyu?» Izaki ashuza, erhi: «Nakâcîdôsa nti nankanafakwo oyu mukazi». ");
INSERT INTO shr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki ashubiza amudôsa, erhi: «Kurhi okwo warhujizirage obwo? Hindi hitya hajire omuntu w’omu lubaga lwîrhu walala na mukâwe obone wamarhubarhuza obwo bubî!» ");
INSERT INTO shr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Lêro Abimeleki ahâna eri irhegeko oku lubaga lwâge lwoshi, erhi: «Owahume kuli oyu mulume kandi erhi kuli mukâge, anafè». ");
INSERT INTO shr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izaki ahinga anarhwera muli ecôla cihugo n’ogwo mwâka ayeza kali igana, bulya Nyamubâho amamugisha. ");
INSERT INTO shr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Oyu muntu agâla, agal’ahirhira okurhalusire. ");
INSERT INTO shr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ali agwêrhe masô manji n’ebintu bishwêkwa binyinyi n’ebinênênè, na bashizi banji. Abafilistini bayâgalwa. ");
INSERT INTO shr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Amaliba goshi bambali b’îshe bàli bamâhumba amango îshe Abrahamu acihali, Abafilistini bagafuka bagabumba budaka. ");
INSERT INTO shr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki abwîra Izaki, erhi: «Orhenge eno mwîrhu, bulya wekola mugale kurhulusha». ");
INSERT INTO shr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Izaki arhenga aho aj’ihanda omu kabanda ka Gerari, anabà ho acîbêrera. ");
INSERT INTO shr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Izaki ashub’ijà ahumba galya maliba bambali b’îshe Abrahamu bàli bahumbire, galya Abafilistini bafukaga erhi Abrahamu abà afîre; agayîrika galya mazîno gonênè îshe ali agayirisire. ");
INSERT INTO shr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Bambali ba Izaki bahumba omu kabanda, bashangamwo iriba ly’amîshi gahulula. ");
INSERT INTO shr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lêro abangere b’e Gerari, barhondêra okulongôla n’abangere ba Izaki, ngasi baguma mpu: «Amîshi gali gîrhu!» Izaki ayîrika iriba izîno lya Sitina. ");
INSERT INTO shr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bahumba erindi iriba, ci kandi hashub’ibà akadali kuli lyo. ");
INSERT INTO shr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Lêro arhenga aho, agend’ihumba erindi iriba, lêro harhacibâga kadali kuliryo. Aliyîrika izîno lya Rehoboti, anaderha, erhi: «Nyamubâho amâjà arhuhà oluhyà, rhukolaga rhwayololokeramwo eci cihugo». ");
INSERT INTO shr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kurhenga aho asôkera e Bersheba. ");
INSERT INTO shr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nyamubâho amubonekera mw’obwo budufu amubwîra, erhi: «Nie Nyamuzinda wa sho Abrahamu, orhayôbohaga cici bulya ndi haguma nâwe. Nakugisha, nnanduze iburha lyâwe erhi mwambali wâni Abrahamu orhuma». ");
INSERT INTO shr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ayûbaka oluhêrero aho, anayakuza izîno lya Nyamubâho. Ayûbaka ho enyumpa yâge. Bambali ba Izaki bahumba ho iriba. ");
INSERT INTO shr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki arhenga e Gerari, ayish’imulamusa, ali boshi n’omwîra wâge Ahuzati na Pikoli, ye murhambo w’omurhwe gwâge. ");
INSERT INTO shr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izaki abadôsa, erhi: «Lêro cici cimudwîrhe eno munda, mwe bantu munshomba, mwe mwanampulusagya emwinyu». ");
INSERT INTO shr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Banacishuza, mpu: «Rhwajirage rhwabona oku nêci Nyamubâho ali haguma nâwe, rhwanaderha obwo nti habè omwîgasho aha karhî kâwe nîrhu, rhunafundike endagâno haguma nâwe. ");
INSERT INTO shr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ocîgashe oku orharhujire kubî kuci, bulya rhurhakujiraga kubî, minjà gône rhwakujirîre rhwanakuleka wagenda n’omurhûla. Woyu okola oli mugishwa wa Nyamubâho». ");
INSERT INTO shr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Abajirira olusiku lukulu, bâlya bànanywa. ");
INSERT INTO shr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Erhi bazûka sêzi sêzi, ngasi muguma acîgasha embere z’owâbo. Oku bundi, Izaki abasêzera, bagenda n’omurhûla. ");
INSERT INTO shr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Olwo lusiku lwonênè, bambali b’Izaki bayisha, bamubwîra omwanzi gw’iriba bakazagihûmba, baderha, mpu: «Rhwabwîne amîshi». ");
INSERT INTO shr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Eryo iriba aliyîrika izîno lya Sabe, co cinarhuma olwo lugo luderhwa Bersheba kuhika na buno. ");
INSERT INTO shr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Erhi Ezau ahika myâka makumi anni, ayanka omukazi izîno lyâge ye Yehudita, mwâli wa Behori, muhititi, arhôla na Basimata, mwâli wa Eloni naye muhititi. ");
INSERT INTO shr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Abo bakazi bajira Izaki bo na Rebeka mungo munji. ");
INSERT INTO shr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izaki ali amashosihala, n’amasù gâge gali gakola mazamba, azinda erhi arhacibona. Lêro ahamagala enfula yâge Ezau, erhi: «Mwâna wâni!» Naye, erhi: «Ho ndi hano». ");
INSERT INTO shr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ashubiza, ederha, erhi: «Lolà oku niono nkola mushosi n’amango g’okufà kwâni ntagamanyiri. ");
INSERT INTO shr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Okanyagye orhôle emirasano yâwe, emyampi yâwe n’omuherho gwâwe, okanye oj’ihiva, onyîrhire ensimba. ");
INSERT INTO shr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onteganyizemwo birya biryo nsîma, oyîshe ondêrhere ndye, lyo omurhima gwâni gukugisha embere nfè». ");
INSERT INTO shr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kuziga erhi Rebeka adwîrhe ayumva oku Izaki ashambâla bo n’omugala Ezau. Ezau acîtuma omu lubala mpu agend’ihiva ensimba ayilerhere îshe. ");
INSERT INTO shr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka abwîra omugala Yakôbo, erhi: «Namâyumva sho abwîra mukulu wâwe Ezau, erhi: ");
INSERT INTO shr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Ondêrhere ensimba, onteganyizemwo ebiryo binjà, mbirye nnankugishe omu masù ga Nyamubâho embere nfè”. ");
INSERT INTO shr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","“Yumvagya mwâna wâni, oyumve onajire nk’oku nakurhegeka”. ");
INSERT INTO shr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","“Okanye ojè omu busô, ondêrheremwo bânahene babirhi binjinjà, narheganyizamwo sho ebiryo binjà, nk’oku anasîma”. ");
INSERT INTO shr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","“Wayîsh’ibihêkera sho abirye, lyo akugisha embere afè”». ");
INSERT INTO shr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakôbo abwîra nnina Rebeka, erhi: «Lolà, mukulu wâni Ezau amâbà wa bishamvu niehe ntagwêrhi bôya. ");
INSERT INTO shr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Hali amango Larha akampumakwo, mbè nka kushekera namushekeraga, obone bukola buhanya namacîlerhera ahâli h’omugisho». ");
INSERT INTO shr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nnina ashuza, erhi: «Obuhanya bubè nie bujâkwo mwâna wâni! Oyumve kwônene, onagend’innongeza abo bânahene». ");
INSERT INTO shr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Akanya aj’ibalonza ayisha abadwîrhîre nnina, naye nnina arheganyamwo ebiryo nk’oku îshe anasîma. ");
INSERT INTO shr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka ayanka emyambalo minjinjà ya Ezau, ye mugala mukulu, erya akazâg’ibîkira omu nyumpa, ayiyambisa Yakôbo ye mugala murhò. ");
INSERT INTO shr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ayanka oluhù lw’abanahene amubwikiramwo amaboko n’igosi. ");
INSERT INTO shr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Oku bundi zirya nyama ali amarheganya n’omugati, abiheba omu nfune z’omugala Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ajà aha burhambi bw’îshe, aderha, erhi: «Larha!» Naye ashuza, erhi: «Niono. We ndi mwâna wâni?» ");
INSERT INTO shr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakôbo ashuza îshe, erhi: «Nie Ezau, nfula yâwe, najizirage nk’oku wanantegekaga. Zûka otamale olyekwo bino nal’ihiva lyo omurhima gwâwe gungisha». ");
INSERT INTO shr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izaki abwîra Yakôbo, erhi: «Mwâna wâni wamarhôla duba wâni!» Naye ashuza, erhi: «Nyamubâho, Nyamuzinda wâwe wangashanîre». ");
INSERT INTO shr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izaki abwîra Yakôbo, erhi: «Yegera hano nkuhumekwo mwâna wâni, nyumve erhi nêci erhi nanga we mugala wâni Ezau». ");
INSERT INTO shr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakôbo ayegêra îshe Izaki, naye amumamarhakwo aderha, erhi: «Izù liri lya Yakôbo, ci amaboko gali ga Ezau!» ");
INSERT INTO shr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Arhamumanyîriraga bulya amaboko gali ga bishamvu aka mukulu wâge Ezau, anacimugisha. ");
INSERT INTO shr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aderha, erhi: «Ka kwo binali we mugala wâni Ezau?» Naye ashuza, erhi: «Nêci». ");
INSERT INTO shr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izaki ederha, erhi: «Mpâga ndye oku nsimba mugala wâni ahivaga lyo omurhima gwâni gumugisha». Amuhêreza alya, amuhêreza n’idivayi anywa. ");
INSERT INTO shr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Îshe Izaki amubwîra, erhi: «Nyegêraga, onampôbere mwâna wâni!» ");
INSERT INTO shr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ayêgera, ahôbera îshe, îshe ayisa obwehe bw’emyambalo yâge. Amugisha ntyâla: «Nêci obwehe bwa mugala wâni, kwo buli nk’obwehe bw’ishwa liyêra, ishwa eri Nyamubâho agishire. ");
INSERT INTO shr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nyamuzinda akushobôze olumè lw’oku nkuba, n’amashwa gashushagîre, engano nyinji n’idivayi linji. ");
INSERT INTO shr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Amashanja gakushige n’abantu b’emahanga bafukame embere zâwe. Obè murhambo wa bene winyu na bagala ba nyoko bafukame embere zâwe. Owakuhehêrere ahehêrewe, n’owakugishe anagishwe». ");
INSERT INTO shr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Erhi Izaki ayûsa okugisha Yakôbo, naye Yakôbo erhi amanahuluka omu mw’îshe Izaki, mukulu wâge Ezau naye arhenga ebwa kuhiva. ");
INSERT INTO shr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Naye arheganya ebiryo binjà abihêkera îshe. Amubwîra, erhi: «Larha, zûkaga olye kw’ebi mugala wâwe anal’ihiva, lyo omûka gwâwe gungisha». ");
INSERT INTO shr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Îshe Izaki amudôsa, erhi: «We ndi?» Naye ashuza, erhi: «Nie nfula yâwe Ezau». ");
INSERT INTO shr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Oku bundi Izaki arhemuka, ederha, erhi: «Aligi ndi olya wal’ihiva ensimba anayindêrhera? Nacimwikubagira nanalya, embere oyîshe; namugishire, anakolaga ayôrha àli mugishe». ");
INSERT INTO shr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Erhi Ezau ayumva ebinwa by’îshe, ayâma bwenêne n’omungo munji, anacibwîra îshe, erhi: «Ongishe nâni mâshi, larha!» ");
INSERT INTO shr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Izaki ashuza, erhi: «Mulumuna wâwe anayishir’inteba, arhôla omugisho gwâwe». ");
INSERT INTO shr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezau ashubiriza, erhi: «Ka kwenge bamuderha Yakôbo, co cirhumire andenganya nieki kabirhi kabirhi? Arhanzir’inyanka ecikono c’okubà nfula, kandi yoyu wamantôla omugisho gwâni!» Ci ashubiza ederha, erhi: «Ci kwône mâshi ka nieki ntà mugisho wansigîze?» ");
INSERT INTO shr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaki ajà omu kanwa ashuza Ezau, erhi: «Namujizire murhambo wâwe, namuhîre bene wâbo nti babè bambali, namuhîre engano n’amamvu mwandu. Bicigi nankacikujirira mwâna wâni?» ");
INSERT INTO shr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezau anacidôsa îshe, erhi: «Ka mugisho muguma gwône ojira, mâshi larha? Mâshi ngisha nâni, larha!» Izaki ahwekêra na Ezau arhondêra alaka. ");
INSERT INTO shr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Oku bundi, îshe Izaki ashuza ederha, erhi: «Woyo ekulî n’ebihugo biyera yo wayûbaka, kuli n’olumè lurhoga oku nkuba. ");
INSERT INTO shr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Engôrho yâwe yo yakubîke, wakakolera mwene winyu. Ci kwône amango wacîrûkûza, kurhibula warhibula omuzigo gwâwe gukuli aha lurhugo». ");
INSERT INTO shr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezau ashombera Yakôbo ogwo mugisho ahâbagwa n’îshe, acîdôsa emurhima, erhi: «Amango g’emishîbo ya larha gali hôfi, go mango nayîrha mulumuna wâni Yakôbo». ");
INSERT INTO shr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Erhi bamanyîsa Rebeka ebyo binwa bya Ezau ye mugala mukulu, arhumiza Yakôbo ye mugala murhò, amubwîra, erhi: «Mukulu wâwe Ezau ahizire okucîhôla kuli we mpu akuyirhe. ");
INSERT INTO shr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yumvagya mwâna wâni, nkubwîre: Okanye, oyâkire emwa mwene wîrhu Labani e Harani. ");
INSERT INTO shr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Obêre eyo haguma naye nsiku inga, kuhika mukulu wâwe atwîke oburhè. ");
INSERT INTO shr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kuhika oburhè bwa mukulu wâwe bukurhengekwo, kuhika ayibagire oku wamujirîre; ago mango nanarhuma bagend’ikulonza eyo munda. Cici cankarhuma namuheza mwembi omu lusiku luguma?». ");
INSERT INTO shr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka anacibwîra Izaki, erhi: «Namayihikwa n’akalamo erhi bâli ba Heti bàrhuma. Erhi Yakôbo ankayanka munyere muguma muli bâli ba Heti, muguma nk’abo, muguma omu banyere b’eci cihugo, k’okulama kwankacinkwânana?» ");
INSERT INTO shr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Izaki ahamagala Yakôbo amugisha anamuhà eri irhegeko, erhi: «Orhahîraga okayanka omukazi omu banyere b’e Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yimuka ojè e Padani Aramu emwa Betweli, îshe wa nyoko, ocîshoge omukazi eyo munda omu banyere ba Labani, mushinja wâbo nyoko. ");
INSERT INTO shr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nyamuzinda akugishe, akuyololole, anakuluze obè ndêko y’amashanja. ");
INSERT INTO shr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Akuhè we n’iburha lyâwe, omugisho gwa Abrahamu lyo obona eci cihugo oyubasiremwo, cihugo Nyamuzinda ahâga Abrahamu». ");
INSERT INTO shr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Izaki asêzera Yakôbo. Yakôbo alîkûla, ajà e Padani Aramu, emwa Labani, mwene Betweli wa Muharamiya, mushinja wâbo Rebeka, nnina wa Yakôbo na Ezau. ");
INSERT INTO shr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezau abona oku Izaki agishire Yakôbo n’oku amurhumire e Padani Aramu mpu agend’iyankira yo omukazi, n’oku erhi akola amugisha, amuhà eri irhegeko, erhi: «Orhahîraga okayanka omukazi omu banyere b’e Kanâni». ");
INSERT INTO shr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Na Yakôbo àli ayumvîrhe îshe na nnina, ajà e Padani Aramu. ");
INSERT INTO shr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ezau ayumva oku abanyere b’e Kanâni barharhonyiri omu masù g’îshe Izaki, ");
INSERT INTO shr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ntyo Ezau ajà emwa Ismaeli, ayanka yo omukazi, wa kuhalika abà ali agwêrhe erhi anagwêrhe abandi: Mahalata, mwâli wa Ismaeli, mugala w’Abrahamu, na mwâli wâbo Nebayoti. ");
INSERT INTO shr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakôbo arhenga e Bersheba, ajà e Harani. ");
INSERT INTO shr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ahika hantu haguma, alâla ho bulya izûba lyàli lyamazika. Arhôla ibuye liguma aho, alishegema, analâla aho. ");
INSERT INTO shr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Alôrha, abona omushonezo mugwike oku idaho n’irhwêrhwè lyâgo lihisire oku nkuba; bamalahika ba Nyamuzinda erhi badwîrhe basôka banayandagala! ");
INSERT INTO shr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Lâba oku Nyamubâho ayimanga embere zâge amubwîra, erhi: «Nie Nyamubâho, Nyamuzinda wa shakulu wâwe Abrahamu na Nyamuzinda wa Izaki. Eryôla ishwa ogwishìremwo, nakuhalyo we n’iburha lyâwe. ");
INSERT INTO shr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Iburha lyâwe lyaluga nka katulo k’oku idaho, lyaluga lihike ebushoshôkero n’ebuzikiro, e mwênè n’e mukondwè, n’amashanja goshi g’igulu gagishwa muli eryo iburha lyâwe. ");
INSERT INTO shr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ndi haguma na nâwe, nakulusa ngasi hoshi wankanaja, nanashub’ikugalula muli eci cihugo, bulya ntakuleke kuhika nyujuze ebi nakulaganyagya». ");
INSERT INTO shr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakôbo atulûka omu îrò lyâge, aderha, erhi: «Okuli Nyamuzinda ali hano ntânali mmanyire». ");
INSERT INTO shr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ayôboha, ederha, erhi: Hano hamabà hantu ha kurhînywa! Yamabà nyumpa ya Nyamuzinda na muhango gw’empingu. ");
INSERT INTO shr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Azûka sêzi, ayanka liryala ibuye àli ajizire mushego aligwika luhêrero abulagira amavurha oku nyanya zâlyo. ");
INSERT INTO shr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Aho ahayîrika izîno lya Beteli, ci mîra olwo lugo lwakazâg’iderhwa Luzo. ");
INSERT INTO shr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakôbo arhôla omuhigo ederha, erhi: «Akabà Nyamuzinda ali haguma nâni, akanananga muli eyi njira najà, akakaz’impa omugati nalya n’emishangi nakayambala, ");
INSERT INTO shr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","erhi nankashubûka nshubire emunda larha ali ndi mugumagumà, ago mango Nyamubâho anabà ye Nyamuzinda wâni, ");
INSERT INTO shr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","n’eri ibuye namagwika luhêrero, lyabà ka-Nyamuzinda nakaz’imurhûla ecihimbi c’omu ikumi c’ebi ampà byoshi». ");
INSERT INTO shr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakôbo arhôla enjira yâge, ajà omu cihugo c’abâna b’e bushoshôkero. ");
INSERT INTO shr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Lolà oku abona iriba omu bulambo, hôfi n’eryo iriba, masô asharhu g’ebintu bishwêkwa binyinyi gali gagwîshîre aho iriba, ho bakazâg’inywekeza amasò, ci kwônene ibuye lyakazâg’ibwîkira omunwa gwàli munene. ");
INSERT INTO shr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Erhi amasò goshi gabâga gamashirama aho, banarhenza lirya ibuye oku munwa gw’iriba, bananywesa ebintu, kandi banalishubiza oku munwa gw’iriba. ");
INSERT INTO shr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakôbo anacidôsa abangere, erhi: «Bene wîrhu, muli ba ngahi?», Bashuza, mpu: «Rhuli b’e Harani». ");
INSERT INTO shr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ababwîra, erhi: «Ka muyishi Labani, mwene Nahori?» Bashuza, mpu: «Rhumuyîshi». ");
INSERT INTO shr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Abadôsa, erhi: «K’azibuhire?» Bashuza, mpu: «Azibuhire. N’omwâli Rasheli ola wayisha hala n’obusò». ");
INSERT INTO shr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakôbo aderha, erhi: «Loli oku guciri mûshi bwenêne guno, arhali go mango g’okudâhya ebintu gano. Mubinywese munabishubize ebulambo». ");
INSERT INTO shr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bashuza, mpu: «Rhurhankahasha okujira ntyo n’amasò garhacishubukîra haguma, barhanacirhenza ibuye oku munwa gw’iriba; go mango rhwakanywesa ebintu». ");
INSERT INTO shr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Oku acidwîrhe ashambâla boshi nabo, Rasheli ayisha n’obusò bw’îshe bulya ali mungere. ");
INSERT INTO shr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Erhi Yakôbo abona Rasheli, mwâli wa nalume Labani, n’erhi abona obusò bwa nalume Labani, ayegêra, arhenza lirya ibuye oku munwa gwa liryala iriba, anywêsa ebintu bya nalume Labani. ");
INSERT INTO shr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakôbo anunugurha Rasheli, alengeza izù, adubula omulenge. ");
INSERT INTO shr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakôbo amanyîsa Rasheli oku ali mwene wâbo îshe, anali mwene Rebeka; olya munyere akanya aj’ikumanyîsa îshe. ");
INSERT INTO shr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani erhi ayumva oku ogwo mwanzi gwa Yakôbo, mugala wa mwâli wâbo, gumuyêrekîre, akanya, alibirhira emunda ali, amuhôbera, anamununugurha, amuhêka omu nyumpa yâge. Yakôbo arhondêra amuganîrira ogwo mwanzi gwoshi. ");
INSERT INTO shr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Oku bundi Labani amubwîra, erhi: «Nêci, oli w’omu mavuha gâni, onali w’omu mubiri gwâni». Yakôbo abêra aho mwa Labani mwêzi mugumagumà. ");
INSERT INTO shr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani abwîra Yakôbo, erhi: «Ka kwenge oli mwene wîrhu, waderha mpu busha wakaz’inkolera? Mbwîra bici nakaz’ikuhà?» ");
INSERT INTO shr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Erhi na Labani agwêrhe banyere babirhi: omukulu izîno lyâge ye Lea n’omurhò ye wali Rasheli. ");
INSERT INTO shr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea àli agwêrhe amasù matûdu, ci Rasheli àli agwêrhe omubiri gucîgemire bwinjà n’iranga linjà. ");
INSERT INTO shr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Na Yakôbo ali arhonyize Rasheli. Anacishuza, erhi: «Nakukolera myâka nda lyo oyîsh’impa mwâli wâwe Rasheli, mwâli wâwe murhò». ");
INSERT INTO shr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani ashuza, erhi: «Kwo kukulu okukuhaye ahâli h’okumuhà ow’embuga; obêrage hanôla mwâni». ");
INSERT INTO shr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakôbo akaz’ikola mpu lyo bamuhà Rasheli; akola ntyo myâka nda, ci eyo myâka ayibona nka nsiku nsungunu bulya ali arhonyize Rasheli. ");
INSERT INTO shr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Buzinda bw’aho, Yakôbo anacibwîra Labani, erhi: «Amango gahisire, ompâge omukazi wâni njè emunda ali». ");
INSERT INTO shr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labani ashûbûza abantu b’eyo boshi ajirisa olusiku lukulu. ");
INSERT INTO shr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ci kwône, lâba oku bijingo, Labani arhôla omwâli Lea, abà ye ahêkera Yakôbo; Yakôbo àmuyanka. ");
INSERT INTO shr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani àhà omwâli Lea, mujà-kazi wâge muguma, izîno lyâge ye wali Zilifa, mpu aj’ikâmukolera. ");
INSERT INTO shr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Erhi buca sêzi, Yakôbo abona oku Lea ye bamudwîrhîre. Yakôbo abwîra Labani, erhi: «Bici wajizire? K’arhali Rasheli ye nakazâg’ikolera aha mwâwe nti omumpe? Carhumirage onteba?» ");
INSERT INTO shr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani ashuza, erhi: «Erhali nkômedu y’eno mwîrhu okuhâna omurhò na mukulu wâge arhaciheruka, ");
INSERT INTO shr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ci orhang’ileka guno mugobe eby’obuhya bitwikanuke, n’enyuma z’aho, kandi nashub’ikuhà owâbo n’engulo yâge yabâ yindi myâka nda washub’imukolera hano mwâni». ");
INSERT INTO shr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakôbo ajira kulya, ayûsa gulya mugobe gw’obuhya na Labani amuhà omwâli Rasheli mpu amuyanke. ");
INSERT INTO shr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani aha omwâli Rasheli omujà-kazi wâge Bilaha. ");
INSERT INTO shr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakôbo ayanka Rasheli, anamurhonya kulusha Lea; ashub’ikolera nalume yindi myâka nda. ");
INSERT INTO shr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nyamubâho abona oku Lea arhasimirwi, amuhà iburha, Rasheli ayôrha ali ngumba. ");
INSERT INTO shr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea arhôla izîmi, aburha murhabana, amuyîrika izîno lya Rubeni, bulya, gwârhi yêne: «Nyamubâho anabwîne amalibûko gâni, lêro ibanie ansîma». ");
INSERT INTO shr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ashub’irhôla izîmi, aburha kandi murhabana, ederha, erhi: «Nyamubâho ayumvîrhe oku ntabâ nsîmirwe, lêro amâshub’impa oyu wundi». Amuyîrika izîno lya Simoni. ");
INSERT INTO shr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ashubirhôla izîmi, aburha murhabana; aderha, erhi: «Lêro nâni ibanie akola antonya bulya barhabana basharhu abà namamuburhira», izîno lyâge ye Levi; ");
INSERT INTO shr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ashub’irhôla izîmi, aburha murhabana; aderha, erhi: «Lêro nakuza Nyamubâho». Co cirhumire amuyîrika izîno lya Yûda. Oku bundi, ahêka arhaciburhaga. ");
INSERT INTO shr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rasheli erhi abona oku ntà bâna adwîrhe aburhira Yakôbo, ayâgalwa na mukulu wâge, kwo kubwîra Yakôbo, erhi: «Ojire nâni mbone abâna, akabà nanga, erhi nnanfire». ");
INSERT INTO shr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakôbo akalihira Rasheli bwenêne, amubwîra, erhi: «Ka nie ndigi ahâli ha Nyamuzinda wakuyimaga iburha?» ");
INSERT INTO shr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Naye nyamukazi, erhi: «Lolà mwambalikazi wâni Bilaha. Ojè emunda ali, aburhire oku madwî gâni; ampisekwo abâna nâni». ");
INSERT INTO shr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Anacihà Yakôbo omujà-kazi wâge Bilaha mpu abè mukâge, naye Yakôbo àmuyanka. ");
INSERT INTO shr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilaha arhôla izîmi, aburhira Yakôbo omwânarhabana. ");
INSERT INTO shr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasheli ederha, erhi: «Nyamuzinda amampà olubanja, ciru anyumvîrhiza anampâ omwânarhabana». Co carhumaga amuyîrika izîno lya Dani. ");
INSERT INTO shr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilaha, mujà-kazi wa Rasheli ashub’irhôla izîmi, aburhira Yakôbo owundi murhabana. ");
INSERT INTO shr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasheli ederha, erhi: «Nazûsizekwo mukulu wâni entambala za Nyamuzinda, namanahimana». Ayîrika olya mwâna izîno lya Nefutali. ");
INSERT INTO shr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Naye Lea erhi arhaciburha, arhôla omujà-kazi wâge Zilifa amuhà Yakôbo mpu amujire mukâge. ");
INSERT INTO shr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilifa, mujà-kazi wa Lea aburhira Yakôbo omwânarhabana. ");
INSERT INTO shr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea ederha, erhi: «Iragi linjà eri!» Aha olya mwâna izîno lya Gadi. ");
INSERT INTO shr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilifa, mujà-kazi wa Lea, aburhira Yakôbo owundi mwânarhabana. ");
INSERT INTO shr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea aderha, erhi: «Oku irenge lyâni, bulya abirhu bakazi bankuza»; ayîrika olya mwâna izîno lya Asheri. ");
INSERT INTO shr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Rubeni, erhi ajà acîgezageza, gala mango g’okusârûla engano, ashimâna amalehe g’oluzigirwa, ayisha agadwirhîre nnina Lea. Rasheli abwîra Lea, erhi: «Mpâ nâni kuli ago malehe g’oluzigirwa mugala wâwe akudwîrhîre». ");
INSERT INTO shr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea amushuza, erhi: «K’okûla wantôzire omulume kunyihira kwakunyihîre, obu okola mpu wantôla n’amalehe g’oluzigirwa mugala wâni ampîre?» Rasheli ashuza, erhi: «Lêro agend’ilâla omu mwâwe hano budufu, rhuhingane ompè amalehe ga mugala wâwe g’oluzigirwa». ");
INSERT INTO shr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yakôbo erhi akola arhenga ebwa mashwa bijingo, Lea ajà emunda ali, amubwîra, erhi: «Kukwânîne oyîshe emunda ndi, bulya rhwakuhingîne amalehe g’oluzigirwa g’emwa mugala wâni»; alâla omu mwâge obwo budufu. ");
INSERT INTO shr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nyamuzinda ayumvîrhiza Lea, arhôla izîmi, ashub’iburhira Yakôbo omwânarhabana ye mwânarhabana wa karhanu. ");
INSERT INTO shr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea anaciderha, erhi: «Nyamuzinda amampà oluhembo, kulya kubà nahîre ibanie omujà-kazi wâni». Olya mwâna amuyîrika izîno lya Isakari. ");
INSERT INTO shr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea ashub’irhôla izîmi, aburhira Yakôbo omwânarhabana wa kali ndarhu. ");
INSERT INTO shr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea ederha, erhi: «Nyamuzinda ampîre oluhembo lwinjinja, lêro ibanie ankuza bulya y’oyu namaburhira barhabana ndarhu». Amuyîrika erya Zabuloni. ");
INSERT INTO shr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Oku bundi aburha omwânanyere, amuyîrika izîno lya Dina. ");
INSERT INTO shr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ago mango Nyamuzinda ayibuka Rasheli, ayumvîrhiza omusengero gwâge, amuhà iburha. ");
INSERT INTO shr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Arhôla izîmi, aburha murhabana; aderha, erhi: «Nyamuzinda amankûla enshonyi». ");
INSERT INTO shr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ayîrika olya mwâna izîno lya Yozefu, ederha, erhi: «Mâshi Nyamubâho ashub’impa nâni owundi mwânarhabana!» ");
INSERT INTO shr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Erhi Rasheli abà amâburha Yozefu, Yakôbo abwîra Labani, erhi: «Oleke ngende nshubire emwîrhu, omu cihugo cîrhu. ");
INSERT INTO shr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ompè abakazi bâni, abârhumaga nkukolera, ompè n’abâna bâni ngende. Wêne orhababiri omukolo nakukolire». ");
INSERT INTO shr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani amushuza, erhi: «Akabà ntonyire omu masù gâwe! Nadôsize nayumva oku Nyamubâho angishire erhi we rhuma». ");
INSERT INTO shr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ashub’imubwîra, erhi: «Ombwîre kurhi walonza nkaz’ikujuha, nakujirirakwo». ");
INSERT INTO shr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Anacimushuza, erhi: «Omanyire bwinjà kurhi nakukolire na kurhi ebintu byâwe byahindusire n’omukolo gwâni. ");
INSERT INTO shr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ehisungunu wali ogwêrhe embere nyîshe, hyayushùsire bwenêne na Nyamubâho akugishire oku nshando zâni. Mbwîraga nâni, mango gahi nakolerage omulala gwâni». ");
INSERT INTO shr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani, erhi: «Bici nakujuha?» Yakôbo ashuza, erhi: «Orhagwêrhi ebi wanjuha: erhi wakanjirira nk’oku nakubwîra, nanashubikaz’iyabula obusò bwâwe. ");
INSERT INTO shr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ene ogere omu busô bwâwe bwoshi, ojè wayungula ngasi cibuzi cîru omu bibuzi byâwe, na ngasi mpene za musengo n’ez’obutonè butonè. Lwo lwâbà luhembo lwâni. ");
INSERT INTO shr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Obudahemuka bwâni bwône bwampamiriza agandi mango: amango wayîsh’ilola kurhi rhuhembirwe, ngasi birhali bya musengo erhi bya butonè-butonè omu mpene erhi nîsi ngasi birhali bîru omu bibuzi, emwâni erhi buli bushambo». ");
INSERT INTO shr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani ederha, erhi: «Kwinjà okwo; binabâge nk’okwo odesire». ");
INSERT INTO shr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Olwo lusiku, ayungula ebihebe by’omusengu n’eby’obutonè-butonè, empene zoshi z’omusengu n’ez’obutonè-butonè, ");
INSERT INTO shr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ngasi hyanalikwo akêru na ngasi hyalikwo ecîru omu bibuzi, ahihereza abagala. Anacijira nsiku isharhu za lugendo ekarhî kâge na Yakôbo. Yakôbo akaziyabula ebindi bintu bya Labani. ");
INSERT INTO shr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakôbo anacirhôla ebirhi bibishi by’emirhi ederhwa mipepuli n’eya amandi n’eya patani, ayihala kuhika oku mula mwêru gw’ebyo birhi. ");
INSERT INTO shr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ebyo birhi ahalaga akaz’ibiyerekeza ebintu omu biranga n’omu mikenzi y’okunywekeza ebintu, amango birinywa, oku biri byanywa binadwîrhe byayima. ");
INSERT INTO shr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Byakâyima erhi binayêrekîre birya birhi, n’omu kuburha, byakaburha ebyâna bitâke, eby’omusengu n’eby’obutonè-butonè. ");
INSERT INTO shr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ebyâna, Yakôbo abihira hâgo hâgo, abiyerekeza olunda lwa birya bitâke na ngasi byanali bya mwîru, abihira omu busô bwa Labani. Anacijira ntyo agâge masô arhanagahiraga haguma n’amasò ga Labani. ");
INSERT INTO shr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Na kandi, erhi ankabwîne ebintu binjà byayima, Yakôbo anabiyerekeze birya birhi omu biranga mpu biyime binayêrekîre birya birhi. ");
INSERT INTO shr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ci amango ebintu bihosire byâbaga bikola byayima arhajiraga ntyo. Na ntyo ebyali bya mihorhâ byasigala bya Labani na ebyali binjà byàbà bya Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Oyo muntu anacigala ntyo bwenêne, àbâ n’ebintu mwandu, alugirwa n’abajà n’abajà-kazi n’engamiya n’endogomi mwandu. ");
INSERT INTO shr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakôbo ayumva oku bene Labani bakazâg’iderha, mpu: «Yakôbo ayansire ebintu byàli bya larha byoshi, bya larha ebi ajiziremwo obwâge bugale». ");
INSERT INTO shr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakôbo abonera ebusù bwa Labani oku arhacidwirhi amulola nk’oku amulolaga burhanzi. ");
INSERT INTO shr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nyamubâho abwîra Yakôbo, erhi: «Shubira omu cihugo ca basho, omu cihugo waburhiragwa, nâni nayôrha ndi haguma nâwe». ");
INSERT INTO shr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Lêro obwo, Yakôbo arhumiza Rasheli na Lea mpu bamushange ebulambo amasò gâge gali. ");
INSERT INTO shr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Anacibabwîra, erhi: «Ndwîrhe nabonera ebusù bwa sho, arhacidwirhi andola nk’oku andolaga burhanzi. Ci kwône Nyamuzinda wa larha anali haguma nâni. ");
INSERT INTO shr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mwêne mumanyire oku nakolîre sho n’emisî yâni yoshi. ");
INSERT INTO shr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","“Ci kwône, anînaguza omu kuhindula kali ikumi oluhembo lwâni, ci kwône Nyamuzinda arhamuzigiraga.”» ");
INSERT INTO shr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","«Ngasi mango erhi ankadesire, erhi: Ngasi biri bya butonè-butonè byo byabâ luhembo lwâwe, ebintu byoshi binaburhe eby’obutonè; na kandi erhi ankadesire, erhi: “Ngasi bya musengo byo byabà luhembo lwâwe, ebintu byoshi binaburhe ebyâna by’omusengu.”» ");
INSERT INTO shr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nyamuzinda arhôzire ebintu bya sho abimpa. ");
INSERT INTO shr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Omu mango ebibuzi biyima, nayinamula amasù, nabona omu bilôrho oku engandabuzi zihambasire ebibuzi ziri za musengo erhi za butonè-butonè. ");
INSERT INTO shr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","«Malahika wa Nyamuzinda ambwîra omu bilôrho, erhi: “Yakôbo”, nâni nashuza nti: “Ho ndi hano!”» ");
INSERT INTO shr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Anaciderha, erhi: «Yinamula amasù obone engandabuzi zihambasire ebibuzi ziri za musengo na za butonè-butonè, bulya nabwîne oku Labani akujizire kwoshi. ");
INSERT INTO shr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nie Nyamuzinda w’aha Beteli, halya washîgaga ibuye amavurha, wampêraho omulagi. Bunôla oyimukage orhenge mwa cino cihugo oshubire omu cihugo oburhwa». ");
INSERT INTO shr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasheli bo na Lea bashuza, mpu: «Ka hali mwanya gwîrhu, ka hali kashambala kîrhu omu nyumpa ya larha?» ");
INSERT INTO shr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mpu ka arhakola arhulola nka b’emwabêne, ebwa kubà arhuguzize analya n’enfaranga zîrhu? ");
INSERT INTO shr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nêci, ngasi bugale Nyamuzinda ayansire larha buli bwîrhu rhwe n’abâna bîrhu. «Ojirage oku Nyakasane akurhegesire». ");
INSERT INTO shr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakôbo ayimuka, abâna bâge na bakâge abashonesa oku ngamiya, ");
INSERT INTO shr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ahuga obusò bwâge, ashana na ngasi bindi birugu ali agwêrhe, obusò ali agwêrhe, bulya abonaga aha Padani Aramu, alîkûlira emw’îshe Izaki, omu cihugo ca Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani ali ajir’imôma ebibuzi byâge, Rasheli agend’izimba enshanga z’ahakâ, zàli z’îshe. ");
INSERT INTO shr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakôbo arheba Labani, Muharameya, amuyongoloka, arhamumanyisagya oku akola ayâka. ");
INSERT INTO shr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ayanka n’ebi ali agwêrhe byoshi, agenda, ayikira olwîshi, ayêrekera ebwa ntondo ya Galadi. ");
INSERT INTO shr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Erh i kugera nsiku isharhu, bamanyîsa Labani oku Yakôbo acîyakîre. ");
INSERT INTO shr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Arhôla bene wâbo, agenda boshi nabo amuyishakwo; erhi ashinga nsiku nda agenda, amurhindakwo, omu ntondo ya Galadi. ");
INSERT INTO shr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nyamuzinda ayâganira Labani, Muharameya, omu bilôrho budufu, amubwîra, erhi: «Omanye wankabwîra Yakôbo akantu». ");
INSERT INTO shr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani, ashenga. Yakôbo erhi agwîsire ihêma lyâge omu ntondo, naye Labani agwîka eryâge oku ntondo ya Galadi. ");
INSERT INTO shr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani anacibwîra Yakôbo, erhi: «Byo bici ebi wajizire? ");
INSERT INTO shr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Carhumaga ogenda bwifuhkwe, wanteba, wanyogoloka ahâli h’okundâliza, nkugalule omu busîme, rhuyimbe, rhurhimbe engoma rhuzihe n’ennanga? ");
INSERT INTO shr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Orhazizire nahôbera bagala bâni na bàli bâni. Kwo wakozire nka musirhe. ");
INSERT INTO shr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nanahasha okukubabaza, ci kwône Nyamuzinda wa sho anandesize ene budufu ambwîra, erhi: “Omanye wankabwîra Yakôbo akantu”. ");
INSERT INTO shr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nyumvirhage oku wagenzire erhi kudula enyumpa ya sho kurhuma! Ci kwône cici carhumire wazimba enshanga zâni?». ");
INSERT INTO shr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakôbo ashuza Labani, erhi: «Nali nyôbohire, namanya nti wanyaga bâli bâwe. ");
INSERT INTO shr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ci oyu wankashimanakwo ezo nshanga zâwe arhalame: omu masù ga bene wîrhu, lonza ngasi biri hyâwe omu byâni, wanahirhôla». Yakôbo arhâli amanyire oku Rasheli ye wazizimbire. ");
INSERT INTO shr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani aj’ifûkula omu cirâlo ca Yakôbo, afûkula omu cirâlo ca Lea, afûkula n’omu cirâlo ca balya bajà-kazi oku banali babirhi, arhabonaga cici. Arhenga omu cirâlo ca Lea ajà omu ca Rasheli. ");
INSERT INTO shr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rasheli ali arhôzire enshanga z’ahakà, azifulika omu ngurha batamalakwo oku ngamiya, anazitamalakwo. Labani afûkula ecirâlo coshi arhabonaga cici. ");
INSERT INTO shr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasheli abwîra Îshe, erhi: «Waliha, nnawîrhu amanye akanganya mpu ntahashir’iyimanga embere zâge, ndi omu mugongo». Labani afûkula, ci arhabonaga enshanga zâge. ");
INSERT INTO shr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Lêro Yakôbo anacibâ burhè, akalihira Labani. Yakôbo abwîra Labani ntya: «Bici ntumwire, kubî kuci najizire obu wanshimbulula ntya? ");
INSERT INTO shr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wamafûkula omu bikunga byâni byoshi, ka hali kantu obwîne k’omu birugu by’omu nyumpa yâwe? Kayerekanage embere z’abà bene wîrhu n’abà bene winyu, babè bo bahamîrizi ekarhî kîrhu oku rhuli babirhi! ");
INSERT INTO shr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Lolà, nashinzire myâka makumi abirhi emwâwe, ebibuzi byâwe n’empene zâwe birhalimwo ecamomire, ntanalyaga ciru n’engandabuzi nguma y’omu busô bwâwe. ");
INSERT INTO shr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ebintu byakazâg’ilibwa n’ensimba ntakulerheraga byo, nakàba nie mpeza omu byâni. Wakazâg’indyuza eci bazimbire mûshi erhi eci nazimbirwe budufu. ");
INSERT INTO shr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Izûba lyakaz’inkomanga mûshi, n’emboho enywengerere budufu n’irô libalale oku masù gâni. ");
INSERT INTO shr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Lolà, myâka makumi abirhi eno, ndi aha mwâwe: nakukolire myâka ikumi n’ini, yo yali ngulo ya bâli bâwe bombi na myâka ndarhu oku bintu byâwe, wanahindula kali ikumi oluhembo lwâni. ");
INSERT INTO shr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nka Nyamuzinda wa larha, Nyamuzinda w’Abrahamu, Îshe wa Izaki, arhali haguma nâni, wali wandeka maboko mûmu. Ci kwône Nyamuzinda abwîne amalibûko gâni n’omukolo gwâni, n’ene budufu, yêne atwa olubanja». ");
INSERT INTO shr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani ashuza Yakôbo, amubwîra, erhi: «Abà banyere bali bâli bâni, abà bâna, bali bâna bâni, ebi bintu, biri bintu byâni, ngasi ebi obwîne byoshi biri byâni. Bici obwîne nankajirira abà, bâli bâni n’abà bâna bàburhaga? ");
INSERT INTO shr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Rhujè aho, rhunywâne rhwembi, mw’okwo, bubè buhamîrizi ekarhî kâwe nâni». ");
INSERT INTO shr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakôbo arhôla ibuye aligwika bunya luhêrero. ");
INSERT INTO shr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakôbo abwîra bene wâbo, erhi: «Mulunde amabuye». Balonza amabuye bagalundika, bajira ensinga n’eyo nsinga balîrakwo. ");
INSERT INTO shr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani ayîrika erya nsinga izîno lya Yegari Shaduta, naye Yakôbo ayiyîrika erya Galedi. ");
INSERT INTO shr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani ederha, erhi: «Eyi nsinga ye muhamîrizi ekarhî kîrhu rhwembi». Co carhumire ayiyîrika izîno lya Galedi, ");
INSERT INTO shr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","n’erya Misipa kulya kubà amederha, erhi: «Nyamuzinda arhulange rhwembi, amango rhwanabè rhurhacibonana. ");
INSERT INTO shr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Erhi wankalibuza bâli bâni, nîsi erhi wankayanka abandi bakazi, ohalika bâli bâni, omanye oku ntà muntu warhuj’ekâgarhî: Nyamuzinda ye wâbà câliho wîrhu rhwembi». ");
INSERT INTO shr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani ashub’ibwîra Yakôbo, erhi: «Lolà eyi nsinga n’eri ibuye nagwikaga ekarhî kîrhu rhwembi. ");
INSERT INTO shr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Eyi nsinga ali câliho n’olu luhêrero nalwo câliho oku niono ncîgashire okutwa eyîra nsinga, mpu ntà mango wanâtwe eyîra nsinga n’olu luhêrero mpu ojè emunda ndi n’emihigo migalugalu. ");
INSERT INTO shr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nyamuzinda wa Abrahamu na Nyamuzinda wa Nahori bo barhutwîra olubanja». Yakôbo acîgasha oku izîno lya côbohwa w’îshe Izaki. ");
INSERT INTO shr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakôbo arherekêra kuli eyo ntondo, analâlika bene wâbo mpu bayîshe balye. Balya banalâla kw’eyo ntondo. ");
INSERT INTO shr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Labani azûka sêzi sêzi, ahôbera abâna bâge n’abâli anabagisha. Okubundi Labani agenda ashubira emwâge. ");
INSERT INTO shr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakôbo naye arhôla enjira yâge, lêro anacirhinda kuli bamalahika ba Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Erhi ababona, aderha, erhi: «Lwanabâ lugamba lwa Nyamuzinda luno»; n’aho ahayîrika izîno lya Mahanayini. ");
INSERT INTO shr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakôbo arhuma obusò emwa mukulu wâge Ezau omu cihugo ca Seyiri omu lugo lwa Edomu. ");
INSERT INTO shr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Abahà aka kanwa mpu bamubwîre, erhi: «Nal’injir’ibêra emwa Labani, yo nanacibâga kuhika buno». ");
INSERT INTO shr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","«Ebi nakoleraga nabibwîne! enkafu, endogomi, ebintu binyinyi, abâna n’abajà-kazi; ntanzir’irhuma entumwa emunda nnawîrhu ali nti lyo nâni andola bwinjà». ");
INSERT INTO shr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Entumwa zagaluka zashubira emunda Yakôbo ali zanacimubwîra, mpu: «Rhwahisire emwa mukulu wâwe Ezau. Yêne ayishire emunda oli n’abantu bâge magana anni». ");
INSERT INTO shr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakôbo ayôboha bwenêne, ayumva ebihamba oku murhima. Engabo yali bo naye ayigabamwo bigamba bibirhi, ebibuzi, enkafu n’engamiya, nabyo akaz’ibigabamwo kabirhi. ");
INSERT INTO shr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kwàli kuderha, erhi: «Ezau akaja ebwa cigamba ciguma akanacirhêra, ecindi canalobôka». ");
INSERT INTO shr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yakôbo ashenga ederha, erhi: «Yâgirwa Nyamuzinda w’Abrahamu, Nyamuzinda wa larha Izaki; Nyamubâho, wêne wambwîraga, erhi: \"Shubira omu cihugo cinyu; emunda oburhwa, nakujirira ebinja\". ");
INSERT INTO shr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","\"Ndi munyi bwenêne w’okukwanana oburhonyi n’obwinjà wayerekîne emunda mwambali wâwe ali. Karhî kâni kône nal’infumbasire erhi nyikira oyu Yordani wabona, lêro niono namakeresa bigamba bibirhi\". ");
INSERT INTO shr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","\"Ondîkûze oku kuboko kwa mukulu wâni Ezau, bulya nyumvîrhe mmuyobohire bwenêne nti ankanayishi’irhutumirha rhweshi, omukazi n’abâna haguma\"». ");
INSERT INTO shr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","\"N’obwo wêne wandaganyagya, erhi: \"Nakuyunjuza ngalo; n’iburha lyâwe nalikuza nka mushenyi gw’omu nyanja gwo gurhankaganjwa\". ");
INSERT INTO shr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yakôbo alâla aho obwo budufu. Anacirhôlamwo ebi agend’ihongera mukulu wâge Ezau oku bintu âl’idwîrhe. ");
INSERT INTO shr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Mpene magana abirhi na bihebe makumi abirhi, bibuzi magana abirhi na ngandabuzi makumi abirhi. ");
INSERT INTO shr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ngamiya nkazi makumi asharhu kuguma n’amanina gâzo, nkâfu makumi anni na mpanzi ikumi, ndogomi nkazi makumi abirhi n’amanina gâzo ikumi. ");
INSERT INTO shr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Azihêreza abambali, ngasi busô kwâgo kwâgo, anabwîra abambali, erhi: Shokoli, amasò garhahîraga gakahikanakwo. ");
INSERT INTO shr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ahâ owa burhanzi eri irhegeko, erhi: Mukulu wâni Ezau akakushimana akanakudôsa, erhi: Oli mwambali wa ndi? Ngahi wajà? Bya ndi ebi bintu bikushokolìre? ");
INSERT INTO shr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Wanashuza, erhi: «Biri bya mwambali wâwe Yakôbo, eri ntûlo arhumire nnawîrhu Ezau, naye yêne ayishire, ali nyuma zîrhu». ");
INSERT INTO shr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Lyo n’irhegeko ahîre owa kabirhi n’owa kasharhu, nabali oku nyuma z’amasò boshi, erhi: «Erhi kwo mwakâbwîra Ezau ntyo amango mwamushanga». ");
INSERT INTO shr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kandi mwanaderha, mpu: Kali ciru mwambali wâwe Yakôbo yo ali enyuma zîrhu. Akazâg’iderha emurhima, erhi: «Namurhûliriza n’ezi ntûlo zinshokolîre, buzinda lyo naciyerekaye, nkaba ambabalira». ");
INSERT INTO shr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Entûlo yâbà yagenda, naye yêne obwo budufu boshi abêra omu cihando. ");
INSERT INTO shr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Muli obwo budufu, anacizûka, arhôla bakâge bombi, n’abambalikazi bombi, n’abâna bâge oku banali ikumi na muguma, ayikira aha izìko lya Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Abarhôla abayikiza omugezi, ayikiza n’ebindi ali agwêrhe byoshi. ");
INSERT INTO shr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakôbo asigala yêne. Hajira owamulwîsa kuhika mucêracêra. ");
INSERT INTO shr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Erhi abona oku arhahashiri amugombya, amugwârhira omu cibunu n’olurhungu lwa Yakôbo lwarhanûka ago mango akazâg’ilwa bo naye. ");
INSERT INTO shr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Anacimubwîra, erhi: «Ndikaga ngende bulya gukola mucêracêra». Ci Yakôbo ashuza, erhi: «Nâni ntakuleke orhanarhanzir’ingisha». ");
INSERT INTO shr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Amudôsa, erhi: «Izîno lyâwe we ndi?» Naye ashuza, erhi: «Nie Yakôbo». ");
INSERT INTO shr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ashubiza, erhi: «Barhakacikuderha Yakôbo ci Israheli, bulya wamabà muzibu omu kulwîsa Nyamuzinda, wahimana n’omu kulwîsa abantu». ");
INSERT INTO shr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakôbo amuyinginga, erhi: «Ombwîre nâni izîno lyâwe». Ci yêhe amushuza, erhi: «Cici ondokîze izîno lyâni?» Ho na halya amugisha. ");
INSERT INTO shr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakôbo ayîrika aho izîno lya Penuweli bulya gwârhi yêne: «Nabwîne obusù bwa Nyamuzinda nanagal’ilama». ");
INSERT INTO shr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Erhi izûba lishoshôka erhi amarhaluka Penuweli ci kwônene erhi akola anayisha akwerera omu lurhungu. ");
INSERT INTO shr_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Co cirhuma ciru kuhika na buno, bene Israheli barhalya cikanyi c’oku lurhungu bulyâla ashurhîre Yakôbo oku lurhungu, oku musi gw’olurhungu. ");
INSERT INTO shr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakôbo mpu alîka amasù, abona Ezau ayishire n’omurhwe gwa bantu magana anni. Agaba abâna bâge; agabira Lea na Rasheli n’abajà-kazi bombi. ");
INSERT INTO shr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ashokoza abajàkazi n’abâna bâbo, akulikiza Lea n’abâna bâge, n’enyuma za boshi, Rasheli na Yozefu. ");
INSERT INTO shr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yêhe ajà oku mbêre afukamiriza kali nda embere ahikeho mukulu wâge. ");
INSERT INTO shr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezau naye amushâmambira, amugwârha omu maboko gâge, acîkweba omu igosi lyâge, amuhôbera anavugumula emirenge. ");
INSERT INTO shr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Erhi alîka amasù n’erhi abona abakazi n’abâna, adôsa, erhi: «Bantu baci ogwêrhe hala?» Yakôbo ashuza, erhi: «Bo bâna Nyamuzinda àshobôzize mwambali wâwe abo». ");
INSERT INTO shr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Abajà-kazi nabo bayegêra n’abâna bâbo, nabo bafukamiriza. ");
INSERT INTO shr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea naye ayegêra n’abâna bâge bafukamiriza; cazînda Rasheli na Yozefu nabo bayegêra bafukamiriza. ");
INSERT INTO shr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezau adôsa, erhi: «Bici wajira na cira cigabi coshi nshimanyire?» Naye, erhi: «Kwàli kuderha nti ntone omu masù ga nnawîrhu». ");
INSERT INTO shr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezau anacishuza, erhi: «Nâni bindi mwandu ngwêrhe, mwene wîrhu, yôrhana ebyo byâwe». ");
INSERT INTO shr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ci Yakôbo ashuza, erhi: «Nanga. Akabà nantonyire emunda oli, oyankirire nâni kano kantu k’omu maboko gâni. Bulya kwo nyishire omu masù gâwe kulya omuntu anajà omu masù ga Nyamuzinda. Woyu wamananyankirira bwinjà. ");
INSERT INTO shr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Onyankire mâshi eno ntûlo nkudwirhîre, bulya Nyamuzinda anshobôzize binji, ntabuziri cici». Okwo kuyingingwa kwarhuma Ezau ayêmêra. ");
INSERT INTO shr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ezau anaciderha, erhi: «Hiraga njira rhugende, nakushokolera». ");
INSERT INTO shr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakôbo amushuza, erhi: «Nnawîrhu arhahabiri oku abâna barhahasha njira nandwîrhe ebibuzi n’enkafu zagoza, owabikanyîsa olu lusiku luguma, obusò boshi bwanahwa. ");
INSERT INTO shr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nnawîrhu ashokolerage mwambali wâge: nâni nayisha bunyibunyi nacîtunda omu kushimba olugendo lw’obusò bunshokolire n’olugendo lw’abâna kuhika mpike emwa nnawîrhu aha Seyiri». ");
INSERT INTO shr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Oku bundi Ezau ederha, erhi: «Ciru olekage nsige bambali bâni baguma muli abà bandusize muyishe mweshi». Ci Yakôbo ashuza, erhi: «Carhuma?» «Caziga waliha nyôrhe ndi murhonyi omu masù ga nnawîrhu!» ");
INSERT INTO shr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Olwo lusiku Ezau arhôla enjira yâge ashubira e Seyiri. ");
INSERT INTO shr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakôbo yêhe arhôla enjira y’e Sukoti ayûbaka yo enyumpa yâge. Ayûbakira n’amasò gâge. Co cirhuma aho bantu haderhwa Sukoti. ");
INSERT INTO shr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakôbo ahika mugumagumà aha lugo lwa Sikemi omu cihugo ca Kanâni, erhi arhenga e Padani-Aramu, anacihanda embere z’olwo lugo. ");
INSERT INTO shr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Agula lirya ishwa ali agwisiremwo ecirâlo; aligulira abâna ba Hamori, îshe wa Sikemi, oku bihûmbi igana bya nsaranga. ");
INSERT INTO shr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Agwikaho oluhêrero anahayîrika izîno lya «El ye Nyamuzinda w’Israheli». ");
INSERT INTO shr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, munyere Lea aburhiraga Yakôbo, anacihuluka mpu ajè alamusa abanyere b’oku lugo. ");
INSERT INTO shr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sikemi, mwene Hamori, Muhiviti, muluzi w’eco cihugo erhi amubona amubakula, amuhima misî, alâla boshi naye. ");
INSERT INTO shr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Omurhima gwâge gwarhonya Dina mwâli wa Yakôbo, asîma oyo munyere bwenêne kuhika amurhûliriza. ");
INSERT INTO shr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikemi abwîra îshe Hamori, erhi: «Onshebere ola munyere mmuyanke». ");
INSERT INTO shr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakôbo ali amamanya oku kwo anasherezize omwâli Dina ntyo; ci ebwa kubà abagala bàli ebulambo oku busô bwâbo, alanga eryo ihwe kuhika abagala bagaluka. ");
INSERT INTO shr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori îshe wa Sikemi ajà emwa Yakôbo mpu bashambâle. ");
INSERT INTO shr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Bene Yakôbo erhi bamafuluka ebwa mashwa, bamanya ako kanwa; balya balume baluba, babà burhè bwenêne, okuyumva Sikemi ahemwire bene Israheli, omu kubakula mwâli wa Yakôbo: nanga arhali ntyo kwo abandi bajira. ");
INSERT INTO shr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori ababwîra, erhi: «Omurhima gwa mugala wâni Sikemi gurhonyize mwâli winyu bwenêne, mmuhûnyire, mumuhè ye amuyanke. ");
INSERT INTO shr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mujire rhuyumvanye ntyo, mukaz’irhuha bâli binyu na nîrhu rhwakaz’imuha bâli bîrhu. ");
INSERT INTO shr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Muyûbake haguma nîrhu, n’ecihugo ecîra cimuyigulirwe: mwanahashiciyubakamwo, mucigeregeremwo, munacidekereremwo». ");
INSERT INTO shr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikemi anacibwîra îshe na bashinja ba namunyere, erhi: «Mâshi, ntone nâni omu masù ginyu, namuhà ngasi ebi mwakampûna! ");
INSERT INTO shr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ciru mwankaluza engulo na ngasi birugu by’ishigi mwankanahûna nabijira, namuhà nk’oku munahûnyire casinga mumpe oyo munyere mmuyanke». ");
INSERT INTO shr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bene Yakôbo omu bwenge, bashuza Sikemi n’îshe Hamori, bamubwîra n’obwengehusi kulya kubà ye wabakulaga mwâli wâbo Dina. ");
INSERT INTO shr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Banacibashuza, mpu: «Rhurhankajira akantu ka bene ako, rhurhankaha mwâli wîrhu omulume orhali mukembûle, bulya kuli rhwe ciri cihemu. ");
INSERT INTO shr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ci kwône muli okwo rhwanayumvanya ninyu: erhi mwankayôrha akîrhu, mukanajira abarhabana binyu babè bakembûle. ");
INSERT INTO shr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ago mango mwanahash’ikârhuha bâli binyu na nîrhu rhwanahash’ikâmuha bâli bîrhu, na ntyo rhwanabà lubaga luguma. ");
INSERT INTO shr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ci kwône akabà murharhuyumvirhi mw’aka kanwa k’okukembûlwa, rhwanarhôla mwâli wîrhu rhunaje handi». ");
INSERT INTO shr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ebinwa byâbo byasîmîsa Hamori na Sikemi mwene Hamori. ");
INSERT INTO shr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nyamwâna arhacirhindiraga okujira ntyo bulya ali asîmire mwâli wa Yakôbo bwenêne, ye wanali muntu wa lukengwa lunene aha mw’îshe. ");
INSERT INTO shr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori n’omugala Sikemi banacijà ebwa muhango gw’olugo, banacibwîra abantu ba mwo olwo lugo lwâbo, mpu: ");
INSERT INTO shr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Bala bantu bali bantu ba bulonza bwinjà: babêre haguma nîrhu muno cihugo, banajè aha balonzize; sinza oku ecihugo coshi ciri cilambûle embere zâbo. Rhwakaz’ibayanka bâli bâbo babè bakirhwe, nabo rhwanabaha bâli bîrhu. ");
INSERT INTO shr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ci abo bantu barhankayemera okuyûbaka haguma na nîrhu n’okujira lubaga luguma nka abânarhabana barhabîri bakembûle nk’oku nabo bônene bayôsire. ");
INSERT INTO shr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Amasò gâbo, ebintu byâbo, ebirugu byâbo, ka byoshi birhabe bîrhu? Rhubayêmêrere okwo bàdesire, banayûbake eno mwîrhu». ");
INSERT INTO shr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ngasi boshi banakazâg’ihuluka, kugera muli ogwo muhango gw’olugo, bàyêmêra Hamori n’omugala Sikemi. Ngasi bûko mulume yêshi akembûlwa. ");
INSERT INTO shr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Olusiku lwa kasharhu, oku ebibande birhacifuma, bene Yakôbo babirhi: Simoni na Levi, bashinja bâbo Dina, barhôla ngasi muguma engôrho yâge. Buzira kuyôboha cici banacirhogera mulya lugo, bayîrha ngasi bûko mulume wanali mwo yêshi. ");
INSERT INTO shr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamori n’omugala Sikemi, nabo babashâyisamwo engôrho, n’erhi bàba bamarhenza Dina omu mwa Sikemi bahuluka. ");
INSERT INTO shr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Bene Yakôbo barhêra abayagalisire banahagula olwo lugo kulya kubà mwâli wâbo bamubonesize nshonyi. ");
INSERT INTO shr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Barhôla ebintu byâbo binyinyi n’ebinênênè, n’endogomi zâbo; ebyâli omu lugo kuguma na ngasi bindi byàli ebulambo byoshi basâbunga. ");
INSERT INTO shr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Banyaga ebirugu byoshi, abâna bâbo barhò boshi na bakâbo, basâbunga na ngasi byoshi byanali omu nyumpa. ");
INSERT INTO shr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Oku bundi Yakôbo anacibwîra Simoni na Levi, erhi: «Mwamampiraga omu maganya garhali go wâni! Mwamanshombanya n’abantu bayûbaka muli cino cihugo. Abanya Kanâni n’Abaperiziti: oku abantu ngwêrhe niono barhali banganaci, bakolaga bacîhira haguma bantabâlire, banyirhe, bamperêrekeze ntyo nie n’omulala gwâni». ");
INSERT INTO shr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bamushuza, mpu: «Ka kwaligi kukwânîne mwâli wîrhu bamurhabirekwo nka mukazi wa cishungu?» ");
INSERT INTO shr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nyamuzinda abwîra Yakôbo, erhi: «Yimuka! osôkere e Beteli onabêreyo, oj’iyubakayo oluhêrero; waluyubakira olya Nyamuzinda wakubonekeraga galya mango wajâga wayâka mukulu wâwe Ezau». ");
INSERT INTO shr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakôbo abwîra ab’aha mwâge boshi na ngasi bandi banali bo naye, erhi: «Murhenze banyamuzinda b’obwîhambi bali ekarhî kinyu, mucîcêse munayambale yindi yindi myambalo. ");
INSERT INTO shr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Muyimuke rhujè e Beteli, naj’iyubakira yo Nyamuzinda oluhêrero, ye wanyumvirhizagya amango nal’impanyagîre, ye wanal’indusize omu njira nâlimwo». ");
INSERT INTO shr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Banacihà Yakôbo banyamuzinda b’ihanga bàli bagwêrhe boshi, n’orhugondo rhw’amarhwîri bàli bagwêrhe rhwoshi, naye Yakôbo abikalira aha murhi gubâ hôfi n’e Sikemi. ");
INSERT INTO shr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Banacigandûla, n’ecôbà ca Nyamuzinda càgwa oku bishagala by’e marhambi byoshi: barhaderhaga mpu bayishakwo bene Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakôbo ahika aha Luzu, omu cihugo c’e Kanâni, ho Beteli, ye n’abantu bàli boshi. ");
INSERT INTO shr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ayûbaka oluhêrero n’aho ahayîrika izîno lya El Beteli, bulya aho ho Nyamuzinda amubonekeraga amango ajâga ayâka mukulu wâge. ");
INSERT INTO shr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Oku bundi, Debora, mulezi wa Rebeka, anacifà, abishwa idako lya Beteli aha murhi; n’aho kwo bahaderha mpu Murhi gw’Emirenge. ");
INSERT INTO shr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nyamuzinda abonekera kandi Yakôbo erhi arhenga e Padani Aramu, anamugisha. ");
INSERT INTO shr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Amubwîra, erhi: «Izîno lyâwe we Yakôbo, ci barhakacikuderha Yakôbo, izîno lyâwe wekola Israheli». Lyo banakola bamuderha eryo lya Israheli. ");
INSERT INTO shr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nyamuzinda amubwîra, erhi: «Nie El Shadayi. Oburhè onahâbwe, ishanja lyaburhwa nâwe, omwandu gw’amashanja gwaburhwa nâwe, n’abâmi barhenga omu nda yâwe. ");
INSERT INTO shr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ecihugo nahâga Abrahamu na Izaki nkuhîre co; n’obûko bwâwe enyuma zâwe nabo mbuhîre eci cihugo». ");
INSERT INTO shr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nyamuzinda asôka, amuleka aho amuganîrizagya. ");
INSERT INTO shr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakôbo agwîka oluhêrero aho amuganirizagya, lwàli luhêrero lw’ibuye, abulagirakwo idivayi n’amavurha. ");
INSERT INTO shr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakôbo ahayîrika izîno lya Beteli aho Nyamuzinda amuganîrizagya. Okuburhwa kwa Benyamini n’okufà kwa Rasheli ");
INSERT INTO shr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Banacirhenga e Beteli. Hali hacisigîre lugendo lwa kasanzi karhali kanyi bahike aha Efrata, lêro Rasheli anaciburha. Okuburha kwâge yàbà ntambala bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Oku izîmi lidwîrhe lyamubiribinga, omugikulu amubwîra, erhi: «Orhayôbohaga kandi murhabana waburha» ");
INSERT INTO shr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Amango g’okurhengamwo omûka, bulya kwàli kukola kufà, ayîrika olya mwâna izîno lya Benoni; ci îshe amuyîrika izîno lya Benyamini. ");
INSERT INTO shr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rasheli anacifà, abishwa oku njira y’e Efrata, ahaderhwa mpu ho Betelehemu. ");
INSERT INTO shr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakôbo agwîka ibuye ly’oluhêrero oku cûsho ca Rasheli, lwo luhêrero lw’oku cûsho ca Rasheli, ho linacibà kuhika ene. Omuziro gwa Rubeni ");
INSERT INTO shr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israheli agenda aj’igwîka ecirâlo câge aha ishiriza lya Midal-Ederi. ");
INSERT INTO shr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ago mango Israheli ali ayûbasire eyo munda, Rubeni akanya aj’ilâla boshi na Bilaha ciherula c’îshe, na Israleli akumanya. Bene Yakôbo ikumi na babirhi Bene Yakôbo bàli ikumi na babirhi. ");
INSERT INTO shr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bene Lea: Rubeni yo nfula ya Yakôbo, Simoni, Levi, Yûda, Isakari na Zabuloni. ");
INSERT INTO shr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Abâna ba Rasheli: Yozefu na Benyamini. ");
INSERT INTO shr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bene Bilaha, mujà-kazi wa Rasheli bàli: Dani na Nefutali. ");
INSERT INTO shr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Bene Zilafa, mujà-kazi wa Lea bâli: Gadi na Asheri. Bo bâna baburhiragwa Yakôbo omu Padani Aramu abo. ");
INSERT INTO shr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakôbo anacihika aha mw’îshe Izaki aha Mambri, aha Kiriyati-Arba, ho haderhwa Hebroni. ");
INSERT INTO shr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Emyâka y’akalamo ka Izaki yali myâka igana na makumi gali munâni. ");
INSERT INTO shr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Izaki arhengamwo omûka. Afà, bamuhira kuli bene wâbo, erhi anakola mushosi, ali akola mukulu anali amâyigurha ensiku. Abagala Ezau na Yakôbo bamubisha. ");
INSERT INTO shr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Alaga iburha lya Ezau oderhwa Edomu. ");
INSERT INTO shr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezau ayanka abakazi omu banyere b’e Kanâni: Ada mwâli wa Eloni, Muhititi, Oholibama, mwâli wa Ana, mwene Sibeoni, Muhoriri. ");
INSERT INTO shr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basmati mwâli wa Ismaeli na mwâli wâbo Nebayoti. ");
INSERT INTO shr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada aburhira Ezau Elifazi; Basmati, aburha Reweli, ");
INSERT INTO shr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama aburha Yewushi, Yalami na Korahi. Bo bâna ba Ezau abo, baburhiragwa omu cihugo c’e Kanâni. Ezau ajà e Seyiri ");
INSERT INTO shr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ezau arhôla bakâge, abagala n’abâli, na ngasi boshi b’aho mwâge, arhôla ebintu byâge n’ebihêsi byâge, rhuderhe ngasi kantu ali akola agwêrhe omu cihugo c’e Kanâni, akanya ajà e Seyiri, kuli n’omulumuna Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","N’ecarhumaga, kwàli kubà ebirugu byâbo byal’ikola byamaluga, barhankacihashire okubêra haguma, n’ecihugo balimwo càli camafundêra oku masô gâbo. ");
INSERT INTO shr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ntyo Ezau aj’iyûbaka omu ntondo ya Seyiri. Ezau yenaligi Edomu. Iburha lya Ezau e Seyiri ");
INSERT INTO shr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Alaga iburha lya Ezau îshe wa Edomu omu ntondo ya Seyiri. ");
INSERT INTO shr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Alaga amazîno ga bene Ezau: Elifazi, mugala wa Ada, mukà Ezau, na Reweli mugala wa Basmati, mukà Ezau. ");
INSERT INTO shr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Bene Elifazi babà: Temani, Omari, Sefo, Gatamu, Kenazi. ");
INSERT INTO shr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi, mugala wa Ezau ali agwêrhe eciherula mpu ye Timuna, anacimuburhira Amaleki. Bo bâna ba Ada, mukà Ezau abo. ");
INSERT INTO shr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Alaga bagala ba Reweli: Nahati, Zerahi, Shama, Miza, bo bâna ba Basmati mukà Ezau abo. ");
INSERT INTO shr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Alaga abagala ba Oholibama, mwâli wa Ana, mugala wa Sibeoni, mukà Ezau: amuburhira Yeushi, Yalamu na Koraha. Abarhambo ba Edomu ");
INSERT INTO shr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Alaga abarhambo ba bene Ezau: Bene Elifazi, nfula ya Ezau: Omurhambo Temani, omurhambo Omari, omurhambo Sefo, omurhambo Kenazi, ");
INSERT INTO shr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","omurhambo Gatamu, omurhambo Amaleki. Bo barhambo ba Elifazi abo, omu cihugo ca Edomu, bo bâna ba Ada abo. ");
INSERT INTO shr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Alaga na bene Reweli mugala wa Ezau: omurhambo Nahati, omurhambo Zeraha, omurhambo Shama, omurhambo Miza. Bo barhambo ba Reweli abo omu cihugo ca Edomu; bo bâna ba Basmati mukà Ezau abo. ");
INSERT INTO shr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Alaga n’abâna ba Oholibama mukà Ezau: omurhambo Yeushi, omurhambo Yalamu, omurhambo Koraha. Bo barhambo ba Oholibama mwâli wa Ana mukà Ezau abo. ");
INSERT INTO shr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bo bene Ezau abo n’abarhambo bâbo abo. Yêne ye Edomu. ");
INSERT INTO shr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Alaga bene Seyiri muhoriti, bo bene ecihugo: Lotani, Shobali, Sibeoni, Ana. ");
INSERT INTO shr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Eseri, Dishani, abo bo barhambo ba Abahoriti, bene Seyiri omu cihugo ca Edomu. ");
INSERT INTO shr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Bene Lotani bo: Hori, na Hemami, na mwâli wâbo Lotani ye Timuna. ");
INSERT INTO shr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Alaga abâna ba Shobali: Aluvani, Manahati, Ebali, Shefo, Onami. ");
INSERT INTO shr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Alaga bene Sibeoni: Aya, Ana, oyu Ana y’olya wabandanaga amishig’amahyuza omu irungu erhi ayâbwîre endogomi z’îshe Sibeoni. ");
INSERT INTO shr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Alaga abâna ba Ana: Dishoni, Oholibama, mwâli wa Ana. ");
INSERT INTO shr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Alaga bene Dishani: Hemudani, Eshebani, Yitrani, Kerani. ");
INSERT INTO shr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Alaga bene Eseri: Bilahani, Zavani, Akâni. ");
INSERT INTO shr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Alaga bene Dishani: Usi na Arani. ");
INSERT INTO shr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Alaga abarhambo b’Abahoriti: omurhambo Lotani, omurhambo Shobali, omurhambo Sibeoni, omurhambo Ana, omurhambo Dishoni, omurhambo Eseri, ");
INSERT INTO shr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","omurhambo Dishoni. Bo barhambo ba Abahoriti abo, nk’oku emilala yâbo enali omu cihugo ca Seyiri. Abâmi b’e Edomu ");
INSERT INTO shr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Alaga abâmi bàli bayimire omu cihugo ca Edomu embere z’okuyîma kw’omwâmi Muisraheli. ");
INSERT INTO shr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwene Beyori, ayîma omu Edomu n’olugo lwâge izîno lyalo ye wali Dinahaba. ");
INSERT INTO shr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela àfà, na Yobabi, mwene Zeraha w’e Bosara àyima omu byâge. ");
INSERT INTO shr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabi àfà na Hushami w’omu cihugo ca Abatemaniti àyima omu byâge. ");
INSERT INTO shr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushami àfà, Hadadi àyima omu byâge, ali mwene ola Bedadi wahimaga bene Midiani omu ntambala y’e Mowabu n’olugo lwâge lwaderhagwa Avita. ");
INSERT INTO shr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi àfà, na Samula w’e Masreka àyima omu byâge. ");
INSERT INTO shr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula àfà, na Shaulu w’e Rehoboti- ha-Nahari àyima omu byâge. ");
INSERT INTO shr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaulu àfà, na Baal Hanan mwene Akibori àyima omu byâge. ");
INSERT INTO shr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan mwene Akibori àfà, na Hadari àyima omu byâge, olugo lwâge ye wali Pawu, engoli yâge ye wali Mehetabeli, mwâli wa Matredi w’e Me-Zahabu. Abandi barhambo b’e Edomu ");
INSERT INTO shr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Alaga abarhambo b’Ezau omu kushimba emilala yâbo, aha bayûbakaga, n’amazîno gâbo: omurhambo Timuna, omurhambo Aluva, omurhambo Yeteti, ");
INSERT INTO shr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","omurhambo Oholibama, omurhambo Ela, omurhambo Pinoni, ");
INSERT INTO shr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","omurhambo Kenazi, omurhambo Temani, omurhambo Mibsari, ");
INSERT INTO shr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","omurhambo Magadiyeli, omurhambo Irami. Bo barhambo b’e Edomu abo omu kushimba aha bayûbakaga mwa cirya cihugo bàgwêrhe. Ezau ye Îshe w’e Edomu. ");
INSERT INTO shr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Cikwône Yakôbo abêra omu cihugo îshe abâga, omu cihugo ca Kanâni. Emyanzi ya Yozefu na bene wâbo. ");
INSERT INTO shr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Alaga emyanzi ya Yakôbo: Yozefu ali akola agwêrhe myâka ikumi na nda. Akazâg’iyabula ebibuzi bo na bakulu bâge b’omu mwa bak’îshe. Aciri murhò, akàyabula boshi na bagala ba Bilaha, na bagala ba Zilafa. Yozefu abwîra îshe emyanzi migalugalu bakazâg’ibaderhera. ");
INSERT INTO shr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israheli arhonyagya Yozefu kulusha abandi bâna bâge, bulya àli mwâna aburhiraga omu bushosi, amuhangîkiza akanzo k’amaboko maliri. ");
INSERT INTO shr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bakulu bâge erhi babona oku îshe amâmurhonya kulusha abandi bagala boshi, bamushomba, barhacimuderhezagya bwinjà. ");
INSERT INTO shr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lêro Yozefu alôrha ecilôrho, aciganîrira bakulu bâge, nabo bamushomba lêro kulusha. ");
INSERT INTO shr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ababwîra obwo erhi: «Yumvagi ecilôrho nalorhaga: ");
INSERT INTO shr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nalòsire rhudwîrhe rhwashana emîha y’engano omu mashwa, omwiha gwâni gwanacizûka gwayimanga n’emîha yinyu yagorha ogwâni yaguyunamira». ");
INSERT INTO shr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bakulu bâge bamushuza, mpu: «Kwo kuderha oku olonzize oyîme ekarhî kîrhu, obè mwâmi nîrhu rhukushige, nîsi erhi obè nnawîrhu orhurhegeke!» Lêro bamushomba okurhalusize erhi ebyo bilôrho n’eyo nshambâlo yâge birhuma. ");
INSERT INTO shr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ashub’ilôrha ecindi cilôrho, naco aciganîrira bakulu bâge. Ababwîra, erhi: «Kandi nalôsire ntya: Izûba, omwêzi na nyenyêzi ikumi na nguma byakazâg’ifukama embere zâni». ");
INSERT INTO shr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Eco cilôrho aciganîrira îshe na bakulu bâge. Cikwône îshe amukalihira amubwîra, erhi: «Bici ebyo walôsire? Ka rhwanaciyîshe niono na nyoko na bakulu bâwe mpu rhwakufukamira?» ");
INSERT INTO shr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bakulu bâge bamubà mitula, cikwône îshe yêhe abîkirira ako kanwa omu murhima gwâge. ");
INSERT INTO shr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bakulu bâge banaciyabulira amasò g’ebintu b’îshe e Sikemi. ");
INSERT INTO shr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israheli anacibwîra Yozefu, erhi: «Ka bakulu bâwe arhaliyo bayabulire e Sikemi? Yisha nkurume emunda bali» Naye ashuza, erhi: «Ntumaga niono». ");
INSERT INTO shr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ashub’imubwîra, erhi: «Kanyagya olole kurhi bene winyu bayôsire, n’ebintu, obul’igaluka ombwîre emyanzi». Anacimurhuma ntyo kurhenga omu kabanda ka Hebroni, naye ahika e Sikemi. ");
INSERT INTO shr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Muntu muguma amushanga ajà ahabuka, omu bulambo, oyo amudôsa, erhi: «Cici wajà walonza?». ");
INSERT INTO shr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Naye ashuza, erhi: «Najanalonza bakulu bâni, ombwîre nâni ngahi bayabulîre obusò bwâbo». ");
INSERT INTO shr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Olya mulume ashuza, erhi: «Barhaciri kuno, nayumvîrhe bacîderheza, mpu: “Rhujè e Dotani”». ");
INSERT INTO shr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Balangîra aciri kuli, n’embere abahikeho, barhôla omuhigo gw’okumuyîrha. ");
INSERT INTO shr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Babwirana bône na nene, mpu: «Lâba kalôsi ola wayisha! ");
INSERT INTO shr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Buno, muyishage rhumuyîrhe rhunamukwebe omu iriba rhwankanabona, rhuyîsh’iderha mpu ensimba nkali yamulire. Rhwalolaga kurhi ebilôrho byâge byayîsh’ibà». ");
INSERT INTO shr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeni ayumva ogwo mulâli, amuyôkola omu maboko gâbo. Aderha erhi: «Nanga rhurhayîrhaga omuntu». ");
INSERT INTO shr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubeni ashubiza, erhi: «Murhahiraga mukabulaga omukò! Mumukwêbe erhi kwo mwalira iriba lirîri liri omu irungu, ci kwône mumanye mwankamuhirakwo olûnu!» Kwàli kuderha mpu amulikûze omu maboko gâbo abul’imugalula emw’îshe. ");
INSERT INTO shr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Erhi Yozefu acihika hali bakulu bâge, bamuhogola akanzo kâge; kalya kanzo akazâg’iyambala k’amaboko maliri. ");
INSERT INTO shr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","N’erhi babà bamamugwârha, bamukwêba omu iriba. Eryôla iriba lirhâlimwo cici, murhâli na mîshi. ");
INSERT INTO shr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Oku bundi babwârhala mpu bayikule; oku bayinamula amasù, balangîra omuzinzi gw’Abaismaeliti barhengaga e Galadi. Engamiya zâbo zàli zidwîrhe ecizibwe, obukù n’amanukato, babihêkaga e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Lêro Yûda anacibwîra bene wâbo, erhi: «Bunguke buci rhwakûla omu kuyîrha mwene wîrhu n’okufulika omukò gwâge. ");
INSERT INTO shr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kanyi rhumugulize Abaismaeliti, rhurhamuhiragakwo olûnu, bulya amâbà mwene wîrhu wa mukò muguma na nîrhu». Bene wâbo banacimuyumva. ");
INSERT INTO shr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hanacigera abantu barhunzi b’e Madiani, barhenza Yozefu mulya iriba; bamuguza bihumbi makumi abirhi bya nfaranga, bamuguliza abo barhunzi Baismaeliti, nabo bamuhêka e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni, erhi ashubira ebwa iriba, abona oku Yozefu arhacirimwo. Abêra emyambalo yâge, ");
INSERT INTO shr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","n’erhi ashubira aha balumuna ababwîra, erhi: «Olya mwâna arhaciri mulya! Nâni ngahi nshubûkirage obu?» ");
INSERT INTO shr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Banacirhôla kalya kanzo ka Yozefu n’erhi babà bamaniga ecihebe, bavunvuza kalya kanzo omu mukò. ");
INSERT INTO shr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bàrhuma kalya kanzo k’amaboko malîri emw’îshe, bankahirakwo ebi binwa, mpu; «Lolà ebi rhwarhôzire. Lolà erhi karhankanaba kalya kanzo ka mugala wâwe aka». ");
INSERT INTO shr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakôbo alola aderha, erhi: «Kanzo ka mugala wâni kano, eciryanyi camulire. Yozefu kulibwa anallîbirwe». ");
INSERT INTO shr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakôbo anacibera omwambalo gwâge, akenyera sunzu ajà omu mishîbo y’omugala nsiku zirhali nyi. ");
INSERT INTO shr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bagala bâge na bâli bâge boshi bakaz’iyisha bal’imurhûliriza, ci kwône arhalonzagya okurhûlirizibwa, ederha, erhi: «Nayôrha ndi omu mishîbo kuhika nyandagalire ekuzimu, emunda mugala wâni ali». ");
INSERT INTO shr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Balya ba Madiyaniti bamuhêka e Mîsiri, bamuguliza Potifari, nkonè ya Faraoni mwâmi w’e Mîsiri na murhambo w’abaganda bâge. ");
INSERT INTO shr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mwago mango, Yûda arhenga oku bâbo, aj’ishiga mulume muguma w’e Adulami, izîno lyâge ye Hira. ");
INSERT INTO shr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Eyo munda, Yûda àbugâna mwâli wa mukanani muguma, mpu ye Shuwa, àsheba olya munyere. ");
INSERT INTO shr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nyamukazi arhôla izîmi, àburha murhabana, amuyîrika izîno lya Eri. ");
INSERT INTO shr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ashub’irhôla izîmi, àburha murhabana, amuyîrika izîno lya Onani. ");
INSERT INTO shr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ashubiriza àburha murhabana amuyîrika izîno lya Shela; ho àli aha Kezibu erhi àburha. ");
INSERT INTO shr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yûda aj’ishebera enfula yâge Eri: Omukazi ye wali Tamara. ");
INSERT INTO shr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ci kwône Eri, yo nfula ya Yûda, agayisa Nyamubâho, lêro amuyîrha. ");
INSERT INTO shr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yûda abwîra Onani, erhi: «J’omu mwa mukà mukulu wâwe, omujirire nk’oku irhegeko ly’obulamu linadesire, oburhire mukulu wâwe». ");
INSERT INTO shr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ci kwône Onani ali amanyire oku iburha lirhabe lyâge, na ntyo erhi abâga ali nyumpa bo na mukà mukulu wâge, anakaz’ibulagira oku idaho lyo arhag’ihà mwene wâbo iburha. ");
INSERT INTO shr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ikola liri ntyo lyagayisa Nyamubâho, amulambika naye. ");
INSERT INTO shr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Lêro Yûda anacibwîra omwâli-kazi Tamara, erhi: «Oj’ibêra aha mwinyu nka mukana, kuhika mugala wâni Shela akule». Bulya akazâg’iderha emurhima, erhi: «Kurhakwânîni oyu naye afè aka bakulu bâge». Tamara ashubira aha mw’îshe. ");
INSERT INTO shr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ensiku zàgera zirhali nyi, mwâli wa Shuwa, yerigi mukà Yûda, àfà. Erhi Yûda arhenga omu mishîbo, asôkera e Timuna mpu aj’imôma ebibuzi byâge, agenda bo n’omwîra wâge Hira w’e Adulami. ");
INSERT INTO shr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Banacibwîra Tamara, mpu: «Lolà oku shazâla oyo wamasôkera e Timuna, aj’imôma ebibuzi byâge». ");
INSERT INTO shr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ahogola emyambalo yâge y’obukana, ayambala ecitambara, yêshi acîhundikira bwinjà, aj’itamala aha muhango gw’Enayimi, oku njira ye Timuna. Ali amazânwa n’okubona Shela akola mukulu barhanamuhîri ye mpu amuyanke. ");
INSERT INTO shr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yûda erhi amubona, amanya mpu mukazi wa cirala, bulya ali acîhundikîre n’obusù n’obusù. ");
INSERT INTO shr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Amujaho kulya burhambi bw’enjira, amubwîra, erhi: «Oleke nkuyanke». Arhâli amanyire oku mwâlikazi oyo. Nyamukazi anacidôsa, erhi: «Bici wampà lyo nyemera wanyanka?» ");
INSERT INTO shr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Naye ashuza, erhi: «Nakuhà omwânahene w’omu busô bwâni». Nyamukazi, erhi: «Nyêmîre, ci kwône orhang’impa ecikinja oku walinda omuntumira». ");
INSERT INTO shr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Naye adôsa, erhi: «Bici nakuhà cikinja»? Nyamukazi, erhi: «Ompè akashè kâwe, omugozi gwâwe n’ako karhî ofumbasire». Amuhà byo, amuja yo, lyanabà izîmi lyâge. ");
INSERT INTO shr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nyamukazi kuyimuka, arhôla enjira yâge ahogola ecitambara câge, ashub’iyambala enyambalo yâge y’obukana. ");
INSERT INTO shr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yûda anacirhuma omwânahene, amufumbika olya mwîra wâge w’e Adulami, mpu agend’imurhôlera ebirugu byâge àhânaga cikinja, emwa olya mukazi. Ci kwône arhamushangaga. ");
INSERT INTO shr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Adôsa abantu bayûbaka halya, erhi: «Ngahi akola abà olya mukazi wali oku njira e Enayimi?» Bàmushuza, mpu: «Ntà mango eyo munda ekola ebîre omukazi w’ecishungu». ");
INSERT INTO shr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Agaluka emunda Yûda ali, amubwîra, erhi; «Ntamushimanyire, ciru n’abantu b’eyo munda bamambwîra oku aho harhasâg’ibà mukazi muherulwa. Mpu ntà mango eyo ekola ebìre omukazi w’ecishungu». ");
INSERT INTO shr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yûda ederha, erhi: «Abiyôrhanage, kurhakwânîni bajè barhushekera. Ci kwône nioyo nalintumire oyo omwânahene, woyo orhacishimanyire oyu nakurhumagakwo». ");
INSERT INTO shr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Erhi hagera nka myêzi isharhu, bàbwîra Yûda, mpu: «Mwâlikazi wâwe Tamara ahemusire. Ciru anarhôla izîmi ly’omu bulala». Yûda ederha, erhi: «Mumulêrhe embuga bamuyôce». ");
INSERT INTO shr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Erhi bakola bamudwîrhe embuga, arhumiza emw’ishazâla, erhi: «Omulume nn’ebi birugu ye wanjiraga eri izîmi». Erhi: «Olole bwinjà ka ndi aka kashe, ogu mugozi n’aka karhî». ");
INSERT INTO shr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yûda abilolêreza, aderha erhi: «Ali mushinganyanya kundusha, kulya kubà ntacimuhâga mugala wâni Shela». Arhanaciderhaga mpu amushâsa. ");
INSERT INTO shr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Erhi ensiku zâge z’okuburha zihika, babona oku mahasha gamuli omu nda. ");
INSERT INTO shr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Omu kuburha, muguma muli balya bâna alambûla okuboko; omugikulu akugwârha akuyambisa ehigozi hidukula, anaderha, erhi: «Oyu ye yishire wa burhanzi». ");
INSERT INTO shr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ci olya mwâna ashub’igalula okuboko, n’owâbo abà ye yisha wa burhanzi. Olya mugikulu aderha, erhi: «Oku wamacihâga enjira wâni! Geraga!» Banacimuyîrika izîno lya Peresi. ");
INSERT INTO shr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Owundi naye anacihuluka, ye wal’iyambîrhe ehigozi hidukula ekuboko; banacimuyîrika izîno lya Zerah. ");
INSERT INTO shr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yozefu àli erhi ahêsirwe e Mîsiri, Potifari murhonyi wa Faraoni mwâmi w’e Mîsiri na murhambo mukulu w’abaganda, Mumisiri, amuguliraga Abaismaeli bàlibamudwirheyo. ");
INSERT INTO shr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nyamubâho erhi anali boshi na Yozefu, akàbêrwa na byoshi, anacibêra omu nyumpa y’olya nnawâbo Mumîsiri. ");
INSERT INTO shr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nnawâbo abona oku ayimangîrwe na Nyamubâho, n’oku ngasi ebi adwîrhe ajira byoshi biri byamubêra. ");
INSERT INTO shr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yozefu arhona ntyo emwa nnawâbo, amuhira omu mikolo yâge, anamuhà oburhegesi bw’eby’omu nyumpa yâge byoshi. ");
INSERT INTO shr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kurhengera ago mango amujiraga murhambo w’enyumpa yâge na mulanzi w’ebyâge byoshi, Nyamubâho agisha enyumpa y’olya Mumîsiri, erhi Yozefu orhuma: omugisho gwa Nyamubâho gwagwârha ngasi ebi anajiraga byoshi, omu nyumpa n’omu mashwa. ");
INSERT INTO shr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Lêro ahira ngasi ebi anagwêrhe byoshi omu nfune za Yozefu, arhacishibiriraga mpu ankadôsa kantu kalebe, aha nyuma z’ebi alya. ");
INSERT INTO shr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lusiku luguma enyuma ly’aho, mukà nnawâbo alîkira Yozefu kw’isù, anacimubwîra, erhi: «Yisha nkubambire». ");
INSERT INTO shr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Cikwône yêhe alahira, abwîra mukà nnawâbo, erhi: «Lolà oku aga mango ndi hano nnawîrhu arhabà ayôbohire ebiri muno nyumpa yâge, ebyâge byoshi abinangisize. ");
INSERT INTO shr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yênene arhagwêrhi buhashe kundusha mw’eno nyumpa. Ntâco ampanzize kwo aha nyuma zâwe bulya oli mukâge. Kurhi nankajiraga obubî bungana aho n’okuhemukira Nyamuzinda?» ");
INSERT INTO shr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Akazâg’ishambâza Yozefu ngasi lusiku, ci kwône Yozefu arhayêmêraga okugwîshira aha burhambi bwâge n’okumuyanka. ");
INSERT INTO shr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lêro lusiku luguma Yozefu ayisha omu nyumpa mpu ajire emikolo yâge, n’omu bantu bakola muli eyo nyumpa, ntâye wahali. ");
INSERT INTO shr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Olya mukazi amugwârhira oku mushangi amubwîra, erhi: «Yisha nkubambire!» Ci yêhe amulekera cirya cishûli acîlibirhira embuga. ");
INSERT INTO shr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Erhi abona oku amamulekera ecishûli omu nfune n’oku amalibirhira embuga, ");
INSERT INTO shr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ahamagala abakozi b’omu mwâge anacibabwîra, erhi: «Loli oku! Arhudwirhirage Omuhebraniya mpu ayish’irhusharhirakwo! Oyu mulume amanyishakwo mpu mmubambire, lêro namahamagaza n’izù linene. ");
INSERT INTO shr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ene aciyumva nayâma nnampamagaza, àjandika omushangi gwâge aha burhambi bwâni alibirhira emuhanda». ");
INSERT INTO shr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Okuhandi anacibîka gulya mushangi aha burhambi bwâge kuhika nnanyumpa alinda afulukira omu nyumpa. ");
INSERT INTO shr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Anamubwîra birya binwa, erhi: «Olya murhumisi w’Omuhebraniya wali orhudwîrhîre, anal’ijîre emunda ndi mpu ali nsharhirakwo. ");
INSERT INTO shr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ci ene nciyâma nnampamagaza, àjahika omushangi gwâge aha burhambi bwâni analibirhira emuhanda». ");
INSERT INTO shr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Erhi nnanyumpa ayumva ebinwa bya mukâge, wamubwîraga, mpu: «Alà kwo mwambali wâwe anyishagawo ntyo», oburhè bwamugwârha. ");
INSERT INTO shr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nnawâbo Yozefu arhegeka mpu bamugwârhe banamuhebe omu mpamikwa; mulya bakazâg’ihira abashwêkwa ba mwâmi. Yozefu omu mpamikwa Anacibêra omwo mpamikwa. ");
INSERT INTO shr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nyamubâho erhi anali haguma na Yozefu, amuyêrekeza oburhonyi bwâge anarhuma arhona omu masù g’omurhambo w’abashwêke. ");
INSERT INTO shr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Olya murhambo w’empamikwa amulangîsa abandi bashwêke bàli omu mpamikwa boshi na ngasi byakazâg’ijamwo, byakazâg’ijirwa naye. ");
INSERT INTO shr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Oyo murhambo w’empamikwa arhankadesire mpu ayobohera ebiri omu maboko ga Yozefu, bulya Nyamubâho àli haguma naye, anakazâg’irhuma abêrwa n’emikolo yâge yoshi. ");
INSERT INTO shr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Enyuma z’aho omurhambo w’amamvu n’omurhambo w’ebiryo bya mwâmi w’e Mîsiri banacigayisa nnawâbo, mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraoni mwâmi w’e Mîsiri agwârhwa n’oburhè bw’abo barhonyi bâge bombi: omurhambo w’amamvu n’omurhambo w’ebiryo. ");
INSERT INTO shr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Abashwekêsa emw’omurhambo w’abalanzi, mw’erya mpamikwa Yozefu àli ashwekîrwemwo. ");
INSERT INTO shr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Naye omurhambo w’abalanzi abarhumira Yozefu mpu akaz’ibakolera, bageza nsiku zirhali nyi mw’eyo mpamikwa. ");
INSERT INTO shr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Omurhambo w’amamvu n’olya w’ebiryo ba mwâmi w’e Mîsiri, kulya banali omu mpamikwa bombi, banacilôrha budufu buguma, ngasi muguma ecilôrho câge cinamuyêrekîre. ");
INSERT INTO shr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sêzi erhi Yozefu ajà omu bali, ashanga bombi bali burhè. ");
INSERT INTO shr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Adôsa balya barhambo ba Faraoni mwâmi w’e Mîsiri bàli bashwêkere haguma naye omu mpamikwa ya nnawâbo, erhi: «Kurhi oku mugwêrhe obusù buzinzibire ene wâni?» ");
INSERT INTO shr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bamubwîra, mpu: «Rhwakazir’ilôrha na ntâye wankarhuhugûlira eco cilôrho». Yozefu ababwîra, erhi: «Nyamuzinda ye hugûla ebilôrho; ci nshambâliragi nâni okwo». ");
INSERT INTO shr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Omurhambo w’abarhânza aganîrira Yozefu ecilôrho câge, erhi: «Omu cilôrho câni, nanacibona emburho y’omuzâbîbu embere zâni, ");
INSERT INTO shr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ogwo muzâbîbu gwàli gugwêrhe mashami asharhu, gwashabuka, gwanayasa n’ebihadu by’ogwo muzâbîbu byakaz’ijakwo amalehe gayezire. ");
INSERT INTO shr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Akabêhe ka Faraoni mwâmi w’e Mîsiri kali omu nfune zâni, narhôla galya malehe, nagakandira omu kabebe ka Faraoni mwâmi w’e Mîsiri, nadêkereza akabêhe omu maboko ga Faraoni mwâmi w’e Mîsiri». ");
INSERT INTO shr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yozefu amubwîra, erhi: «Yumvagya okwo kwo kuderha kurhi: Ago mashami asharhu g’omuzâbîbu gayêrekîne nsiku isharhu. ");
INSERT INTO shr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Hacisigîre nsiku isharhu Faraoni mwâmi w’e Mîsiri akulîke, anakushubize omu mukolo gwâwe: washub’ikàdêkereza akabêhe ka Faraoni mwâmi w’e Mîsiri omu maboko gâge, nk’oku wanakazâg’ijira amango waciri murhambo w’amamvu. ");
INSERT INTO shr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Okaz’inkengêra amango wabona eryo iragi, onansengerere emwa Faraoni mwâmi w’e Mîsiri, antenze nâni muli eyi nyumpa. ");
INSERT INTO shr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bulya kushamula banshamulaga omu cihugo c’Abayahudi, ciru n’eno munda nayo, ntâco najizire cankarhuma nashwekwa». ");
INSERT INTO shr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Omurhambo w’ebiryo abona oku Yozefu anahûgwire bwinjà eco cilôrho, naye anacimubwîra, erhi: «Nâni kwo nalôsire ntya: nal’imbarhwire birhiri bisharhu bya migati oku irhwe. ");
INSERT INTO shr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Omu cirhiri c’enyanya mwâli erya migati Faraoni mwâmi w’e Mîsiri analya, cikwône ebinyunyi byakaz’ilya erya migati yali omu cirhiri oku irhwe lyâni». ");
INSERT INTO shr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yozefu anacimushuza, erhi: «Yumvagya nâwe, okwo kuderha oku ebirhiri bisharhu zo nsiku isharhu. ");
INSERT INTO shr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Hacisigîre nsiku isharhu Faraoni mwâmi w’e Mîsiri akulîke, anakumanike oku murhi n’enyunyi zanalya enyama za kuli we». ");
INSERT INTO shr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Oku lusiku lwa kasharhu lwo lwàli lusiku lw’okukengeza okuburhwa kwa Faraoni mwâmi w’e Mîsiri, ajirira abambali boshi olusiku lukulu. Alîka omurhambo w’amamvu n’omurhambo w’ebiryo omu karhî k’abarhambo b’abalwî. ");
INSERT INTO shr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Omurhambo w’amamvu amushubiza omu cikono câge, akaz’ikâfumbika Faraoni mwâmi w’e Mîsiri akabehe kâge. ");
INSERT INTO shr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Omurhambo mukulu w’ebiryo anacimanikwa nka kulya Yozefu anabahugûliraga. ");
INSERT INTO shr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ci olya murhambo w’amamvu arhacikengêraga Yozefu, amuyibagira. ");
INSERT INTO shr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Enyuma lya myâka ibirhi. Faraoni mwâmi w’e Mîsiri alôrha ayîmanzire hôfi n’olwîshi lwa Nili. ");
INSERT INTO shr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Abona mulya lwîshi mwanyonyôka nkâfu nda nyinjinjà na ntwedu, zarhondêra zakerera omu cibingu. ");
INSERT INTO shr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Lâba oku zindi nkâfu nda zamarhenga omu Nili, zikulikîre entanzi, zirhali nyinjà z’okulolwâkwo kabirhi, zinali mporhomporho, zàgend’ijà aha burhambi bw’ezâbo, aha lwîshi lwa Nili. ");
INSERT INTO shr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Zirya nkâfu mbimbi zirhankalolwakwo na mporho-mporho zanacirya zirya nkâfu ntwedu na nyinjinjà oku kubona. Aho Faraoni mwâmi w’e Mîsiri àsinsimuka, ");
INSERT INTO shr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ashub’ihunga, alôrha ecilôrho ca kabirhi: Alà oku mihuli nda eyimanzire oku karhî kaguma, mihuli minjinjà na minênênè. ");
INSERT INTO shr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Yindi mihuli nda mityangulinguli enababusire n’empûsi y’emwênè nayo yayisha. ");
INSERT INTO shr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Erya mihuli egokombire, yamirangusa erya yal’irhunzire enayunjulirine. Kandi Faraoni mwâmi w’e Mîsiri àsinsimuka. Alà oku càli cilôrho eco. ");
INSERT INTO shr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Erhi buca sêzi. Faraoni mwâmi w’e Mîsiri ayumva omurhima gurhadêkerîri. Ahamagala abashonga n’abagula bâge b’omu Mîsiri boshi. Abaganîrira ebyo bilôrho ci ntâye ciru n’omuguma wahashire okumuhugulira byo. ");
INSERT INTO shr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Oku bundi, omurhambo w’amamvu ajà aho, abwîra Faraoni mwâmi w’e Mîsiri, erhi: «Nkola nashub’ikengêza ene amabî gâni. ");
INSERT INTO shr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraoni mwâmi w’e Mîsiri ali akunirîre bambali bâge, anabahira, omu mpamikwa emwa omurhambo w’abaganda, niono n’omurhambo w’ebiryo ");
INSERT INTO shr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Rhwanacilôrhera budufu buguma, nie n’owîrhu. Ci ebyo bilôrho birhâli byo biguma. ");
INSERT INTO shr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Omwo rhwàli mwâli mwâna muguma muhebraniya, ali mwambali w’omurhambo w’abalâlizi. Rhwamushambâlira ebilôrho bîrhu, arhuhugûlirabyo. ");
INSERT INTO shr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Byanacibà nk’oku anarhubwîraga: niono Faraoni mwâmi w’e Mîsiri anshubiza omu mukolo gwâni, naye owîrhu amanikwa». ");
INSERT INTO shr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraoni mwâmi w’e Mîsiri arhumiza mpu balêrhe Yozefu. Banacimurhenza duba duba omu mpamikwa. Amômwa, arhôla yindi yindi myambalo, ajà emwa Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Nalôsire ecilôrho ci ntâye ohashir’icimpugûlira, ci nayumvîrhe bakuderha mpu erhi wankayumva ecilôrho erhi wanacihûgwire». ");
INSERT INTO shr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yozefu ashuza Faraoni mwâmi w’e Mîsiri amubwîra, erhi: «Ntali cici, cikwône Nyamuzinda yêne ye washuza Faraoni mwâmi w’e Mîsiri». ");
INSERT INTO shr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Omu cilôrho câni, nali nka nyimanzire oku burhambi bwa Nili. ");
INSERT INTO shr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Omu lwîshi mwanacinyonyôka nkâfu nda nyinjinjà na ntwedu, zarhondêra zakera omu cibingu. ");
INSERT INTO shr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Enyuma ly’aho, alà oku zindi nda zanyonyôka za mihorha, mbî-mbî zirhankalolwakwo kabirhi, zanali mporho-mporho; ntasâg’ibona enkafu mbî nka zirya omu cihugo c’e Mîsiri coshi. ");
INSERT INTO shr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Zirya nkâfu mporho-mporho zamirangusa zirya nda ntanzi, zirya ntwedu. ");
INSERT INTO shr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Zabîre zamazimirangusa na ntâye wankamariyire oku zazimizire, bulyâla obubî bwâzo burhanzi bwo zanayorhîne. Aho nasinsimuka. ");
INSERT INTO shr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nashub’ibona ecindi cilôrho: Mihuli nda yanaciyâna oku karhî kaguma, yali minjinjà enashomekîre. ");
INSERT INTO shr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kandi kwayâna yindi nda egokombire enababusire n’empûsi y’emwênè. ");
INSERT INTO shr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Erya mihuli egokombire yamirangusa erya yâbo mihuli nda yali minjà. Nashambâlira abashonga okwo ci ntâye wakumpugûlîre». ");
INSERT INTO shr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yozefu abwîra Faraoni mwâmi w’e Mîsiri, erhi: «Ecilòrho ca Faraoni mwâmi w’e Mîsiri cinali ciguma. Nyamuzinda anamanyisize Faraoni mwâmi w’e Mîsiri omuhigo alâlire okujira. ");
INSERT INTO shr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ezo nkâfu nda nyinjà ziyerekîne myâka nda; n’emihuii nda minjinjà nayo eyêrekîne myâka nda. Ciri cilôrho ciguma. ");
INSERT INTO shr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Enkafu nda mporho-mporho na mbî-mbî, zanyonyôkaga enyuma ly’ezâbo, ziyerekîne myâka nda kuguma n’eyo mihuli nda egokombire enababusire n’empûsi y’emwênè, kwo kuderha oku habâ myâka nda ya cizombo. ");
INSERT INTO shr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kwo nshuba nabwîra Faraoni mwâmi w’e Mîsiri; Nyamuzinda anamanyisize Faraoni mwâmi w’e Mîsiri bici alâlire okujira: ");
INSERT INTO shr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Alà oku hâyisha myâka nda y’okubêrwa n’okuluza ebiryo omu cihugo coshi c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kandi hanakulikira myâka nda ya cizombo, banayibagira obwo buhirhi bwoshi omu Mîsiri, ishali lyanamalîra ecihugo. ");
INSERT INTO shr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Barhacimanye ciru erhi obuhirhi bwàli omu cihugo; eco cizombo cinene cayisha omu cihugo cayiyibagiza, bulya cabâ cidârhi. ");
INSERT INTO shr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","N’akabà eco cilôrho cayishìîre Faraoni mwâmi w’e Mîsiri kabirhi kuli kuderha oku Nyamuzinda bwenêne anahizire ntyo, n’oku arharham’ikujire. ");
INSERT INTO shr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Kukwânîne Faraoni mwâmi w’e Mîsiri alonze omuntu ogwêrhe oburhimanya n’amakengu, amujire murhambo omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri ajire anayimanze abarhindisi omu cihugo, arhegeke entûlo y’ecihimbi ca kasharhu c’emburho zamasarûlwa omu cihugo ngasi mwâka muli eyo myâka y’obuhirhi. ");
INSERT INTO shr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Babîke ebirîbwa muli eyi myâka minjà y’obuhirhi yayisha. Faraoni mwâmi w’e Mîsiri arhegeke balundike engano, n’omu ngasi lugo kwo nakwo, balundike ebirîbwa banabilange bwinjà. ");
INSERT INTO shr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ebyo biryo guligi muhako gw’ecihugo oku kulinga eyo myâka nda y’ecizombo yayisha omu cihugo c’e Mîsiri, na ntyo ecihugo cirhacife n’ecizombo». ");
INSERT INTO shr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ako kanwa kàsîmîsa Faraoni mwâmi w’e Mîsiri bwenêne boshi n’abarhambo bâge. ");
INSERT INTO shr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraoni mwâmi w’e Mîsiri abwîra abambali, erhi: «Ka rhwankacibona owundi muntu olimwo omûka gwa Nyamuzinda aka oyu?» ");
INSERT INTO shr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Nk’oku Nyamuzinda anakumanyisize ebi byoshi, ntà wundi muntu ogwêrhe oburhimanya n’amakengu oli okâwe. ");
INSERT INTO shr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wekola warhegeka akarhwabwâmi n’olubaga lwâni lwoshi lwayumva irhegeko lyâwe, entebe y’obwâmi yône nkulushire». ");
INSERT INTO shr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Obwînage obwo oku namakuyimika murhambo omu cihugo ca Mîsiri coshi». ");
INSERT INTO shr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faraoni mwâmi w’e Mîsiri anacihogola olugondo lwàli e kuboko kwâge oluhira ekuboko kwa Yozefu. Amuyambisa emishangi y’ecitâni, anamuyambisa omugufu gw’amasholo omu igosi. ");
INSERT INTO shr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Anacimushonesa oku ngâlè yâge yali ya kabirhi omu ngâlè zâge banajà bayâma embere zâge, mpu: «Mucîlange». Ntyo kwo Yozefu ayimisirwe omu cihugo c’e Mîsiri coshi. ");
INSERT INTO shr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Obwo Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Niono nie Faraoni mwâmi w’e Mîsiri, orhali we ntà wundi waderhaga mpu afunyûla okuboko erhi okugulu omu cihugo coshi c’e Mîsiri». ");
INSERT INTO shr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraoni mwâmi w’e Mîsiri ayîrika Yozefu izîno lya Safunati-Panea, amuhà n’omukazi izîno lyâge ye Asinati mwâli wa Potifari, mudâhwa wa Oni. Yozefu akanya ajà arhangula ecihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yozefu ali agwêrhe myâka makumi asharhu ago mango ajâga embere za Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri. Anacirhenga omu masù ga Faraoni mwâmi w’e Mîsiri ajà agera omu cihugo c’e Mîsiri coshi. ");
INSERT INTO shr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ecihugo càyêra bwinjà bwenêne erya myâka nda y’obuhirhi. ");
INSERT INTO shr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yozefu akaz’ilunda ebiryo muli eyo myâka nda y’obuhirhi omu cihugo c’e Mîsiri. Ajà alunda omu ngasi lugo lwanakâbîka ebiryo by’omu mashwa galuli eburhambi. ");
INSERT INTO shr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yozefu alunda engano, yaluga nka mushenyi gw’omu nyaja, ciru baleka okuganja erhi yamarhaluka ngasi lugero. ");
INSERT INTO shr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Embere omwâka murhanzi gw’ecizombo guyîshe erhi Yozefu akola agwêrhe bagala babirhi baburhagwa na Asinati mwâli wa Potifari, mudâhwa wa Oni. ");
INSERT INTO shr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Enfula Yozefu ayiyîrika izîno lya Menashè, bulya, gwârhi yêne: «Nyamuzinda ampîre okuyibagira amalibûko gâni goshi n’omulala gwa larha gwoshi». ");
INSERT INTO shr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Owa kabirhi amuyîrika izîno lya Efrayimu, erhi: «Bulya Nyamuzinda ampêrîre iburha omu cihugo nali narhindìbukira». ");
INSERT INTO shr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Erhi erya myâka nda y’obuhirhi bwàli e Mîsiri egera, ");
INSERT INTO shr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","nayo erya myâka nda y’ecizombo yarhangira okuyisha nk’oku Yozefu anababwîraga. Ecizombo càzûka omu bihugo byoshi, ci kwône omu cihugo ca Mîsiri mwoshi, ebiryo mwo byàli. ");
INSERT INTO shr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Càzinda ecihugo c’e Mîsiri naco càrhangira okuyumva ishali n’olubaga lwalakira emunda Faraoni mwâmi w’e Mîsiri ali mpu aluhè eci lwalya. Obwo Faraoni mwâmi w’e Mîsiri anacibabwîra, erhi: «Mujè emunda Yozefu ali, mujire nk’oku akanababwîra». ");
INSERT INTO shr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ishali lyâli lidârhabîre omu igulu lyoshi. Yozefu ahamûla enguli zalimwo engano zoshi aguliza Abanyamisiri engano; ci ishali nalyo lyanahangaza omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Abantu bàkaz’irhenga omu bindi bihugo byoshi by’igulu bakâyisha e Mîsiri bal’igulira Yozefu engano bulya ishali lyàli likalihire bwenêne omu igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakôbo erhi abona oku e Mîsiri eri engano y’okugula, abwîra abanabâge, erhi: «Cirhumire muli aho mwakàlolanakwo kwônene?» ");
INSERT INTO shr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nayumvîrhe bambwîra oku e Mîsiri eri engano y’okukaguza. Bungulukiragi yo ninyu mujigula kuli eyo ngano y’eyo munda lyo rhulama rhulek’ifà. ");
INSERT INTO shr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bakulu ba Yozefu ikumi banacibunguluka bakola baj’igula engano e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ci kwônene Benyamini, mulumuna wa Yozefu, Yakôbo arhamurhumaga haguma n’abandi bulya akazâg’iderha, erhi: «Kurhakwânîni ajekwo obuhanya». ");
INSERT INTO shr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Bene Israheli banaciyisha omu kalundo k’abandi bakola bajag’igula nabo engano bulya ecizombo càli cidârhi bwenêne omu cihugo c’e Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yozefu erhi agwêrhe buhashe bunji omu cihugo, ye wakazâg’iguliza olubaga lwoshi engano. Bene wâbo Yozefu bayisha, bafukamiriza embere zâge, obusù bwahwêra oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yozefu erhi abona bakulu bâge, ayirukira abarhimanya, ci acîjira nka muntu orhayimbanwa nabo, abadôsa n’obukali. Abadôsa, erhi: «Ngahi mwarhenga?» Nabo banacishuza mpu: «Rhwarhenga omu cihugo c’e Kanâni rhul’igula ebiryo». ");
INSERT INTO shr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ntyo, Yozefu amanyirira bakulu bâge ci bôhe barhamumanyiriraga. ");
INSERT INTO shr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yozefu akengêra birya bilôrho alôrhaga kuli bo anacibabwîra, erhi: «Mw’oyu muli ndolêrezi, muyishir’ihengûza ngahi ecihugo cîrhu cankarhungânirwa». ");
INSERT INTO shr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Banacilahira, mpu: «Nanga, nnâhamwîrhu. Bambali bâwe bayishaga mpu bagule ebiryo. ");
INSERT INTO shr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Rhweshi rhuli bagala ba mushamuka muguma, rhurhabêsha, bambali bâwe zirhali ndolêrezi». ");
INSERT INTO shr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Naye abashuza, erhi: «Nanga mul’ilola ngahi mwankarhungânira ecihugo». ");
INSERT INTO shr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bamushuza, mpu: «Bambali bâwe bali ikumi na babirhi, boshi balondana, boshi baburhwa n’îshe muguma, ayûbaka omu cihugo c’e Kanâni: Omuziba gwîrhu gwo gwasigire bo na larha, hali na muguma orhacihabà». ");
INSERT INTO shr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yozefu ashubiza ababwîra, erhi: «Nk’oku nanamubwîraga, muli ndolêrezi». ");
INSERT INTO shr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Alagi eci mwanyerekamwo oku murhali zo: Ye ndahîre Faraoni mwâmi w’e Mîsiri, mukarhenga hano n’oyo mulumuna winyu arhaciyisha! ");
INSERT INTO shr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Murhume muguma muli mwe agend’ilonza oyo mulumuna winyu; n’abandi basigala bashwekwa. Rhwayeshûla ebinwa binyu n’okwo kwammanyisa erhi okwo mudesire kwo kunali. «N’akabà arhali ntyo, ye ndahîre Faraoni mwâmi w’e Mîsiri, ntabè munali ndolêrezi»! ");
INSERT INTO shr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Abahugira boshi omu mpamikwa nsiku isharhu. ");
INSERT INTO shr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Erhi kugera nsiku isharhu, Yozefu ababwîra, erhi: «Alagi oku mwajira lyo mulama, bulya niono ndi muntu orhînya Nyamuzinda: ");
INSERT INTO shr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Akabà murhabêsha, mwene winyu muguma asigale hano omu mpamikwa; n’abandi bagende, bahêkere emilala yinyu engano elagirîrekwo. ");
INSERT INTO shr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mugend’indêrhera oyo mulumuna winyu: na ntyo nanamanya erhi ebinwa binyu birahli bya bunywesi, na ntyo murhacife». Bajira kulya. ");
INSERT INTO shr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Babwîrana bône na bône, mpu: «Amabî rhwajiriraga mulumuna wîrhu go garhudwîrhîre obu buhane, akazâg’ilaka erhi arhuhûna obwonjo, rhurhanamuyumvagya. Co cirhumire buno buhanya burhujakwo». ");
INSERT INTO shr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni ababwîra, erhi: «Yâgi, ka ntamubwîraga nti murhahîraga mukajirira omwâna okubî? Murhananyumvagya, rhwono rhwadôsibwa omukò gwâge». ");
INSERT INTO shr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Barhamanyaga oku Yozefu adwîrhe abayumva, bulya aha karhî kâge nabo hàli omubwîriza. ");
INSERT INTO shr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Acîyêgûla kulibo, aj’ilaka. Oku bundi ashubira emunda bali, abaderheza; abarhôlamwo Simoni, amushwekêsa erhi banabona. ");
INSERT INTO shr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yozefu arhegeka mpu babumbe enshoho zâbo ngano, mpu banahîre enfaranga za ngasi muguma, omu nshoho yâge, banabashanire olwîko lw’enjira. Babajirira ntyo. ");
INSERT INTO shr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Baheba erya ngano oku ndogomi zâbo bagenda. ");
INSERT INTO shr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ci, erhi bahika aha bahandaga bwamayiraho, muguma muli bo ashanûla enshoho yâge mpu ahè endogomi yâge ebi yâlya, abona enfaranga zâge ziri omu munwa gw’enshoho yâge y’engano. ");
INSERT INTO shr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Anacibwîra bene wâbo, erhi: «Bàngalulîre enfaranga, z’ezi omu nshoho y’engano!» Boshi barhemuka omurhima. Balolanakwo banageramwo omusisi, mpu: «Kwo kurhi oku Nyamuzinda arhujizire?» ");
INSERT INTO shr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Erhi bahika aha mw’îshe Yakôbo omu cihugo c’e Kanâni, bamuganîrira oku byabîre kwoshi; baderha mpu: ");
INSERT INTO shr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Omulume oli murbegesi w’ecihugo arhushambâzize n’obukali anarhulola nka ndolêrezi omu cihugo câbo». ");
INSERT INTO shr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nîrhu rhwamushuza, nti: «Rhurhabêsha, arhali kwo rhuyishire nka ndolêrezi. ");
INSERT INTO shr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Rhuli ikumi na babirhi rhulondana, larha ali muguma, muguma muli rhwe arhacihabà, n’omurhò yesigire bo na larha, omu cihugo ca e Kanâni». ");
INSERT INTO shr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Oyo mulume orhegesire ecihugo arhubwîzire, erhi: «Eci namanyirakwo oku murhabêsha, ceci: Muleke mwene winyu muguma eno mwâni, murhôle engano emilala yinyu elagîrîrekwo munagende. ");
INSERT INTO shr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Muj’indêrhera oyo mulumuna winyu murhò, n’aho nanamanya oku murhabêsha. Obwo nanamugalulira mwene winyu na ntyo mwanahash’ikashundira mw’ecino cihugo». ");
INSERT INTO shr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Erhi bashanûla enshoho zâbo, alà oku omu nshoho ya ngasi muguma mwâli ehifuku byâge hy’enfaranga. ");
INSERT INTO shr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Îshe Yakôbo abashuza, erhi: «Mwamanyusagya abâna mushâna! Yozefu arhacihaba, Simoni arhàcihali, na Benyamini oyûla mukolaga mpu murhôle! N’okwo kwoshi nie kurhindibuzîze». ");
INSERT INTO shr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeni anacibwîra îshe, erhi: «Onayîrhe bagala bâni bombi akabà ntakugaluliriye. Omuhire omu maboko gâni, nakugalulira ye». ");
INSERT INTO shr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakôbo ashuza, erhi: «Nanga, omwâna wâni arhayandagale haguma ninyu, mukulu wâge afîre, akola asigîre yêne. Erhi ankajira oku abâ omwo njira yinyu, mwanarhuma emvi zâni zayandagalira ekuzimu n’omungo». ");
INSERT INTO shr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ishali lyaciri likali bwenêne omu cihugo, ");
INSERT INTO shr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","n’erhi bayûsa bâlya erya ngano barhenzagya e Mîsiri, îshe ababwîra, erhi: «Shubiragi yo mugend’irhugulira biryo bisungunu». ");
INSERT INTO shr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yûda amushuza, erhi: «Olya mulume ayôsire arhuhanirîze, erhi: “Murhahike omu masù gâni, akabà mulumuna winyu arhali na ninyu”». ");
INSERT INTO shr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kuziga erhi wankayemera mpu rhugende rhweshi na mulumuna wîrhu lyône rhwankayandagala rhuj’ikugulira ebiryo. ");
INSERT INTO shr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ci akabà orhayêmîri mpu ajeyo, nîrhu rhurhankayija; bulya oyo mulume arhurhonzire, erhi: «Murhahike omu masù gâni akabà mulumuna winyu arhayishiri haguma ninyu». ");
INSERT INTO shr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israheli aderha, erhi: «Kurhi oku mwandibuzize nieki, carhumaga mubwîra oyo mulume oku mucigwêrhe mulumuna winyu?». ");
INSERT INTO shr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Banacishuza, mpu: «Oyo muntu akazâg’irhudôsa binji binji kuli rhwe n’oku mulala gwîrhu, nk’omu kurhudôsa, erhi: “Ka ho sho acibà? Erhi ka mucigwêrhe mulumuna winyu?”» Rhwanakazimushuza kuli ago madôso goshi. Ka rhwankamanyire oku kwo arhubwîra, erhi: «Mulêrhe mulumuna winyu?». ");
INSERT INTO shr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Oku bundi Yûda abwîra îshe Israheli, erhi: «Leka omwâna ayîshe rhugende rhweshi. Leka rhugende, rhurhôle enjira yîrhu lyo rhucira rhulek’ifà, rhwe na nâwe n’engabo zîrhu. ");
INSERT INTO shr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Niono ncîbarhuzize ye, akajira oku abà nie wadôsa. Akabà ntakugaluliri ye, akabà ntamushubizizi omu malanga gâwe, onanjire mwîsi embere zâwe ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bulya nka rhurhalegereraga ntya rhinga rhwamagaluka kabirhi!» ");
INSERT INTO shr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Oku bundi îshe Israheli ababwîra, erhi: «Akabà ntyo, alagi oku mwajira: Mushane ecishêgo ca ngasi binjà binabà muno cihugo, muhêkere oyôla mulume lubè lwo luhembo mumudwîrhîre. Mugavu musungunu, bûci busungunu, nshangi nsungunu, nshisho nsungunu n’obukù. ");
INSERT INTO shr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mushub’irhôla ezindi nfaranga, muhêke n’enfaranga mwashangaga bahizire omu kanwa k’enshoho zinyu z’engano: nkaba kwàli kuyibagira. ");
INSERT INTO shr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Rhôlagi mulumuna winyu mugende, mushubire emunda oyo mulume ali. ");
INSERT INTO shr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nnâmahanga amujire murhone emw’oyo mulume, anamuleke mugalukane owinyu haguma na Benyamini. Niono, akabà kuherwa naherwa n’abâna, mulekage nnamperwe!» ");
INSERT INTO shr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Abalume banacirhôla lulya luhembo, n’ensaranga marhu abirhi abirhi haguma na Benyamini, balîkûla, bayandagalira e Mîsiri, bajà embere za Yozefu. ");
INSERT INTO shr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Erhi Yozefu ababona bali boshi na Benyamini, abwîra ecibwindi câge, erhi: «Ohêke abo bantu omu nyumpa, obâge cintu ciguma onacîrheganye bulya abà bantu balya haguma nâni hano mûshi aha izûba-karhî». ");
INSERT INTO shr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nyamulume ajira nk’oku Yozefu anamurhegekaga, anacihêka balya bantu omu nyumpa ya Yozefu. ");
INSERT INTO shr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bayumva obwôba bw’okubona babahêka emwa Yozefu, baderha, mpu: «Zirya nfaranga zàli zigalusire olundi lusiku omu nshoho zîrhu zo zamarhuma barhuhêka eyi. Balonza okuyîsh’irhugorha, barhugwarhe, banarhuhêke bujà rhwe na endogomi zîrhu». ");
INSERT INTO shr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bayegêra cirya cibwindi ca Yozefu, bamubwirira aha lusò lw’enyumpa, mpu: ");
INSERT INTO shr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Orhubabalire waliha, rhukola rhurhanzir’ijà eno bundi, erhi rhul’igula ebiryo, ");
INSERT INTO shr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","omu njira y’okushubira emwîrhu erhi rhuhika aha rhwàli rhwalâla, rhwashanûla enshoho zîrhu rhwabugana enfaranga za ngasi muguma ziri aha munwa gw’enshoho yâge, zàli zirya nfaranga zîrhu zonène omubalè n’obuzirhu bwâzo, zo zino rhukola rhugalukine. ");
INSERT INTO shr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Rhudwîrhe n’ezindi nfaranga z’okugula ebiryo. Rhurhamanyiri ndi wajâga ayômeka enfaranga zîrhu omu mizigo yîrhu». ");
INSERT INTO shr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Abashuza erhi: «Murhûle murhayôbohaga! Nyamuzinda winyu, Nyamuzinda wa sho ye wamuhiriraga obuhirhi omu nshoho z’engano. Ensaranga zinyu bazimpîre». Anaciyisha abadwîrhîre Simoni. ");
INSERT INTO shr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Olya murhumisi erhi abà amabahisa omu nyumpa ya Yozefu, abahêreza amîshi, nabo banacîkalaba amagulu; n’endogomi zâbo azihêreza obwasi. ");
INSERT INTO shr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Barheganya entûlo yâbo y’omunkwa erhi banadwîrhe balinga oku Yozefu ayisha muli ogwo mûshi. Bàli bamamanyisibwa oku ho bayikulira aho. ");
INSERT INTO shr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Erhi Yozefu ahika aha mwâge, bamuhêkera entûlo bàli badwîrhe. Bafukamiriza bahwera oku idaho embere zâge. ");
INSERT INTO shr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Abalamusa bwinjà, anabadôsa, erhi: «Olya sho w’omushosi mwambwîraga ka naye azibuhire? Ka ho acibà?» ");
INSERT INTO shr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bamushuza mpu: «Mwambali wâwe Larha azibuhire; ho acibà». Bayunama bafukamiriza. ");
INSERT INTO shr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yozefu ayînamula amasù, abona Benyamini, ye mulumuna oburhwa na nnina; aderha, erhi: «Ka ye mulumuna winyu mwambwîraga oyu?» Ashubiza ederha erhi: «Nyamuzinda akugishe mwâna wâni!». ");
INSERT INTO shr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Oku bundi Yozefu ahuluka duba-duba omu kubona omulumuna, ecifufu camugwârha, ayumva emirenge yamuyisha omu masù: ajà omu mwâge, aj’ilakiramwo. ");
INSERT INTO shr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Erhi abà amageza amîshi ebusù, ahuluka, acihangâna, ayôrha nka ntâko abîre, arhegeka, erhi: «Lerhagi ebiryo». ");
INSERT INTO shr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bamuhirira ebiryo hâgo hâgo, na bene wâbo nabo babahirira ebiryo hâgo hâgo n’Abanyamîsiri balîra haguma naye, nabo babahirira hâgo hâgo; bulya Abanyamisiri barhankalira haguma n’Abayahudi: kwanabà kuhemuka emw’Abanyamisiri. ");
INSERT INTO shr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Batamala embere zâge, kurhondêrera oku nfula nk’oku ecikono câge c’obunya-nfula cinahûnyire; n’omurhò kulusha abandi kulya amâburhwa gâbo ganali; boshi bakâlolanakwo banazânwa. ");
INSERT INTO shr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Aderha obwo mpu babahêkerekwo birya biryo byàli omu cisha câge, mpu banababegere olukengwa, Benyamini yêhe mpu bamubegere karhanu kalushire aka abâbo. Banywêra haguma banasîma bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yozefu aha ecibwindi câge eri irhegeko, erhi: «Enshoho z’abà bantu ogend’izibumba biryo nk’oku bankanahash’ibarhula, ogal’ihira enfaranga za ngasi muguma omu kanwa k’enshoho yâge. ");
INSERT INTO shr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Oyîsh’ihira kalya kabêhe kâni k’amarhale omu munwa gw’enshoho y’omurhò obalimwo, ohiremwo enfaranga z’engano yâge». Omurhindisi anacijira nk’oku Yozefu anamubwîraga. ");
INSERT INTO shr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sêzi erhi bucânûla balika balya bantu haguma n’endogomi zâbo. ");
INSERT INTO shr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Bâli bamârhenga omu lugo ci kwônene barhali bacihika kuli; Yozefu àrhuma omurhindisi wâge, erhi: «Yimuka oshimbûlire balya bantu, na hano obahikakwo, obabwîre, erhi: “Kurhi mwagalulaga amabî oku minjà mwajirîrwe?” ");
INSERT INTO shr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","“K’arhali ko kabêhe nnawîrhu anyweramwo, ko analagulirakwo? Kubî okwo mwajizire”». ");
INSERT INTO shr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Abahikakwo, ababwîra birya binwa. ");
INSERT INTO shr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bamushuza, mpu: «Cirhumire nnâhamwîrhu ederha ntyo? Ntanzi là erhi bambali bâwe bankajira ecijiro ca bene eco! ");
INSERT INTO shr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sinza enfaranga rhwashimanaga omu minwa y’enshoho zîrhu, rhwakugalulîrezo kurhenga emwîrhu Kanâni, kurhi rhwankazimbirage omu nyumpa ya nnâhamwinyu abè nfaranga erhi gabè masholo? ");
INSERT INTO shr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ekarhî ka bambali bâwe, oyu wankanashimâna kwo ako kabêhe anafè, na nîrhu rhwenene rhunabè bajâ ba nnawinyu». ");
INSERT INTO shr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Anacibashuza, erhi: «Nêci, binabâge nk’okwo mudesire! Oyu bankanashimana adwîrhe ako kabêhe, anabè mujà wâni; ci abandi bôhe banacîgendera». ");
INSERT INTO shr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngasi muguma ahonyeza enshoho yâge y’engano oku idaho, ngasi muguma anacishanûla enshoho yâge. ");
INSERT INTO shr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Afûkula kugwârhira oku nfula kuhika oku muziba gwâbo, n’akabêhe kayishibonekana omu nshoho ya Benyamini. ");
INSERT INTO shr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Banacisharhula enyambalo yâbo ngasi muguma ashub’ibarhuza endogomi yâge, bashubira omu lugo. ");
INSERT INTO shr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yûda na bene wâbo bajà aha mwa Yozefu, babandâna acihali, bafukamiriza embere zâge bahwera oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yozefu ababwîra, erhi: «Byo bici ebi mwankolîre? Ka murhamanyiri oku omuntu oli akâni ayishi oku balêba?» ");
INSERT INTO shr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yûda ashuza, erhi: «Bici rhwacibwîra nnawîrhu? Kurhi rhwaciderhaga? Kurhi rhwankaciyêra? Nyamuzinda ayêrekîne obubî bwa bambali bâwe. Lolà, rhukola bajâ ba nnawîrhu rhweshi oku rhunali n’oyu bashangaga akabêhe omu nfune». ");
INSERT INTO shr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Abashuza, erhi: «Ntanzi erhi nankajira ntyo! Olya muntu banashimanagakwo akabêhe, ye wanabâ mujà wâni, mwêhe mushubire n’omurhûla emunda sho ali». ");
INSERT INTO shr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Oku bundi Yûda amuyegêra, erhi: «Yâgirwa mâshi, oleke omurhumisi wâwe aderhere akanwa omu marhiwiri ga nnawîrhu, orhanabêraga omurhumisi wâwe burhè bulya kwo onali nka Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Nnawîrhu adôsize bambali bâge bulya, erhi: Ka mucijira sho? Ka mucigwêrhe ommulonzire?”» ");
INSERT INTO shr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nîrhu rhwashuza nnawîrhu, nti: «Rhucigwêrhe larha w’omushosi n’omuziba gwîrhu gwaburhiragwa e bushosi; oyu gwalondaga afîre, ye baburhagwa na nnina muguma, n’îshe arhahimwa kumurhonya». ");
INSERT INTO shr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«Wabwîra bambali bâwe obwo, erhi: “Mumundêrhere, amasù gâni gamulole kwo”». ");
INSERT INTO shr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Rhwashuza nnawîrhu, nti: «Omwâna ntâko arhenge kuli îshe, erhi ankamurhenga kwo, îshe anafà». ");
INSERT INTO shr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wanacibwîra bambali bâwe, erhi: «Akabà mulumuna winyu arhabungulusiri haguma ninyu, murhayimange omu masù gâni». ");
INSERT INTO shr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Erhi rhuyinamukira emwa mwambali wâwe yeligi larha, rhwamuganîrira ebinwa bya nnawîrhu. ");
INSERT INTO shr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kandi erhi larha arhubwîra, erhi: «Kanyi mushub’igend’igula biryo bisungunu;» ");
INSERT INTO shr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","rhwashuza, nti: «Rhurhankahash’iyandagala. Ci kwône akabà rhwagenda rhweshi na mulumuna wîrhu, lyoki rhwankabunguluka, bulya ntâko rhubone obusù bw’olya mulume rhurhanali rhweshi na mulumuna wîrhu». ");
INSERT INTO shr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mwambali wâwe, yerigi larha arhushuza, erhi: «Mumanyire oku mukânie amburhire bâna babirhi bône: ");
INSERT INTO shr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Muguma acîgendîre, naderha nti kulîbwa alîbirwe n’eciryanyi; kuhika buno ntasâg’îmushisha omu isù. ");
INSERT INTO shr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Erhi mwankashub’intôla oyu wundi, naye erhi ankajira oku abà, mwanarhuma ezi mvi zâni zajà ekuzimu n’omungo munji». ");
INSERT INTO shr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Bunôla nkashubiraga emwa mwambali wâwe, yerigi larha, ntanadwirhi omwâna, oyu omurhima gwâge gwacîshwekîrekwo, ");
INSERT INTO shr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","hano abona omwâna arhali haguma nîrhu, kufà anafà, n’ago mango erhi bambali bâwe bamarhuma emvi za mwambali wâwe, yerigi larha, zajà ekuzimu n’oburhè bunji. ");
INSERT INTO shr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na kandi, mwambali wâwe acîbarhuzize olw’oyu mwâna, omu masù ga larha, amango naderhaga nti akabà ntamugalwiri emunda oli onanjire mwîsi ensiku zoshi». ");
INSERT INTO shr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Olekage yâgirwa mwambali wâwe ayôrhe mujà wa nnawîrhu, oyu mwâna omuleke arhereme haguma na bakulu bâge». ");
INSERT INTO shr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","«Kurhi nankasôkera emunda larha ali wâni n’omwâna arhayishiri haguma nâni? Nanga ntalonza mbone obuhanya bwarhogera larha!» ");
INSERT INTO shr_vpl VALUES ("GN44_35","002_44_35","GEN","44","35","35","Ntabonaga mulongo gwa 35 aha, bulya WLC aguhesire omu cigabi cikulikire. ");
INSERT INTO shr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Lêro Yozefu ayabirwa n’okurhenza emirenge embere z’abà bàli halya boshi; anaciyâma, erhi: «Muhuluse abandiho boshi». Na ntyo ntâye wacimuliho erhi Yozefu acimanyisa emunda bakulu bâge bali. ");
INSERT INTO shr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ayâma n’izù linene erhi alaka, Abanyamisiri balinda bayumva, n’iburha lya Faraoni mwâmi w’e Mîsiri lyakuyumva. ");
INSERT INTO shr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yozefu abwîra bakulu bâge, erhi: «Nie Yozefu! Ka ho larha acibà?» Bene wâbo bayabirwa n’okumushuza bulya bamârhemuka embere zâge. ");
INSERT INTO shr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Obwo, Yozefu abwîra bene wâbo, erhi: «Nyegêri». Bamuyegêra. Ababwîra, erhi: «Nie Yozefu olya mulumuna winyu mwaguzagya mpu bamuhêke e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","“Ci kwônene mumanyage murhacibâga burhè murhanacikalihiranaga mpu okwenge mwangulizagya” ab’eno munda. Kulonza okufumya obuzîne bwinyu kwarhumaga Nyamuzinda antuma mpu mmushokolere. ");
INSERT INTO shr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","“Bulya, sinzi oku ekola myâka ibirhi eno kurhenga ishali lijîre omu cihugo, hacisigîre na yindi irhanu abantu barhahinga barhanasârûla”. ");
INSERT INTO shr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Nyamuzinda antumire mmunshokolere lyo obûko bwinyu bulemera muno cihugo n’okuyishiciza akalamo kinyu kulya kwankanaderhwa”. ");
INSERT INTO shr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ntyo arhacirigi mwe mwantumaga eno munda ci Nyamuzinda; anyimisire mpu mbè îshe wa Faraoni mwâmi w’e Mîsiri, mwimangizi w’enyumpa yâge yoshi na murhambo w’ecihugo c’e Mîsiri coshi”». ");
INSERT INTO shr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Mukanyagye musôkere emunda larha ali, mumubwîre, mpu: “Mugala wâwe Yosefu adesire”, erhi: “Nyamuzinda anyimisire murhambo w’e Mîsiri yoshi; obungulukire eno munda ndi buzira kulegerera”». ");
INSERT INTO shr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","«Wayûbaka omu cihugo ca Gosheni, wabêra aha burhambi bwâni mwe na bagala bâwe, na binjikulu bâwe, ebibuzi byâwe n’enkafu zâwe na ngasi ebi ogwêrhe byoshi.» ");
INSERT INTO shr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","«Eyo munda nakaz’ikushundira, bulya hacisigîre yindi myâka irhanu ya cizombo, na ntyo orhacilake buligo, oli we, oli enyumpa yâwe, na ngasi hyâwe hyoshi». ");
INSERT INTO shr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Mucîbwinîre n’amasù ginyu, mulumuna wâni Benyamini naye abwîne oku kanwa kâni kadwîrhe kamuderheza. ");
INSERT INTO shr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","«Muganîrire larha irenge ngwêrhe omu Mîsiri lyoshi, n’ebi mwabwîne byoshi munatwe duba, muyandagalane larha eno munda». ");
INSERT INTO shr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Oku bundi acîkwêba omu igosi lya mulumuna wâge Benyamini, alaka, naye Benyamini alakira oku igosi lyâge. ");
INSERT INTO shr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Anunugurha bene wâbo boshi, alaka anadwîrhe abahôbera; bene wâbo barhondêra bamushambâza. ");
INSERT INTO shr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Omwanzi gwahika omu bwâmi bwa Faraoni mwâmi w’e Mîsiri, mpu bene wâbo Yozefu bayishire: Faraoni mwâmi w’e Mîsiri n’abarhambo bâge basîma bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Obwîre bene winyu, erhi: Oku mwajira kw’oku: Mushanire ebihêsi binyu, mukanye mujè e Kanâni. ");
INSERT INTO shr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Murhôle sho n’emilala yinyu, muyishe eno munda ndi. Nammuyûbasa ahinja ha cino cihugo ca Mîsiri munalye oku mashushi g’ecihugo. ");
INSERT INTO shr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Woyo obahè eri irhegeko, erhi kwo mwajira ntya: Muyanke engâlè muno cihugo c’e Mîsiri, mulerhemwo abâna binyu na bakinywi, murhôle na sho, muyishe. ");
INSERT INTO shr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Murhabâga burhè bw’ebi mwasiga, bulya ngasi hinjà hinali omu cihugo c’e Mîsiri, hyâbà hinyu». ");
INSERT INTO shr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bene Israheli banajira kulya; Yozefu abahà engâlè nk’oku Faraoni mwâmi w’e Mîsiri anarhegekaga, abahà n’olwîko lw’enjira. ");
INSERT INTO shr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ajà abahà ngasi muguma omushangi gw’olusiku lukulu, Benyamini yêhe amuhà magana asharhu ga sikêli za nfaranga, bamuhà na mishangi irhanu ya lusiku lukulu. ");
INSERT INTO shr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kwo n’okwo, arhumira îshe ndogomi ikumi, bazihêsa oku ngasi hinjà hinabà e Mîsiri, na ndogomi nkazi ikumi zihesîbwe engano, omugati n’olwîko omushosi acîyikira omu njira. ");
INSERT INTO shr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Oku bundi asêzera bene wâbo, nabo balîkûla, erhi amânarhang’ibabwîra, erhi: «Murhalongôleraga omu njira». ");
INSERT INTO shr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Banacirhenga e Mîsiri obwo, bayinamukira omu cihugo c’e Kanâni emw’îshe Yakôbo. ");
INSERT INTO shr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Bamubwîra, mpu: «Yozefu ho acibà, ciru yeri warhambula ecihugo c’e Mîsiri coshi». Omurhima gwâge gwayôrha guhangalîre, bulya arhabayêmêraga. ");
INSERT INTO shr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ci kwoki erhi bayûs’imubwîra ebinwa Yozefu aderhaga byoshi, n’erhi abona zirya ngâlè Yozefu arhumaga mpu zij’imulêrha, omurhima gw’îshe wâbo Yakôbo gwarhwangûkwa. ");
INSERT INTO shr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israheli aderha, erhi: «Ntà kundi! Kwisi mugala wâni Yozefu ho acibà! Naj’imulolakwo embere nfè». ");
INSERT INTO shr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israheli agendana ngasi ebi anali agwêrhe byoshi. Erhi ahika e Bersheba arherekêra Nyamuzinda w’îshe Izaki. ");
INSERT INTO shr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nyamuzinda abwîra Israheli omu bilôrho by’obudufu, erhi: «Yakôbo! Yakôbo!» Naye, erhi: «Ho ndi hano». ");
INSERT INTO shr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nyamuzinda ashubiriza, erhi: «Nie Nyamuzinda, nie Nyamuzinda wa sho. Orhayôbohaga okuyandagalira e Mîsiri, bulya nakujira ishanja linene eyo munda. ");
INSERT INTO shr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Niehe nayandagalira e Mîsiri haguma nâwe. Na kandi, nie nanakurhenzayo nkuyinamukane, na Yozefu ye wakubisha». ");
INSERT INTO shr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakôbo arhenga e Bersheba obwo, bene Israheli bashonêsa îshe Yakôbo, bakâbo n’abâna bâbo muli zirya ngâlè Faraoni mwâmi w’e Mîsiri ali arhumire mpu zibarhôle. ");
INSERT INTO shr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bahêka n’amasò gâbo na ngasi byâbo bàli bakola bagwêrhe omu cihugo c’e Kanâni, bayisha e Mîsiri. Yakôbo haguma n’omulala gwâge gwoshi, ");
INSERT INTO shr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","abagala na bagala b’abagala, abâli na bâli b’abagala, iburha lyâge lyoshi aligendana e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Alaga amazîno g’abo bene Israheli bajàga e Mîsiri: Yakôbo boshi n’abagala: Enfula ya Yakôbo, Rubeni. ");
INSERT INTO shr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Bagala ba Rubeni: Henoki, Palu, Hezroni na Karmi. ");
INSERT INTO shr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Bene Simoni: Yemweli, Yamini, Ohadi, Yakini na Sohari, na Saulu waburhagwa n’omukazi mukanani. ");
INSERT INTO shr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Bene Levi: Gershoni, Kehati na Merari. ");
INSERT INTO shr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Bene Yûda: Eri, Onani, Shela, Feresi na Zera; ci kwônene Heri na Onani bali erhi bàfirire e Kanâni. Bene Peresi: bâli Hesroni na Hamuli. ");
INSERT INTO shr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Bene Isakari: Tola, Puwa, Yashubu na Shimuroni. ");
INSERT INTO shr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Bene Zabuloni: Sêredi, Eloni na Yahaleli. ");
INSERT INTO shr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bo bene Yakôbo abo, bo Lea amuburhiraga aha Padani Aramu kuhirakwo n’omwâli Dina. Boshi haguma, bagala n’abâli, bàli bantu makumi asharhu na basharhu. ");
INSERT INTO shr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Bene Gadi: Sifoni, Hagi, Shuni, Esiboni, Eri, Arodi na Areli. ");
INSERT INTO shr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Bene Asheri: Yimuna, Yishwa, Yishwi, Beria na mwâli wâbo Serah. Bene Beria bali: Heberi na Malkieli. ");
INSERT INTO shr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bo bene Zilfa abo; olya Labani ahàga omwâli Leya; aburhira Yakôbo abo bâna: bantu ikumi na ndarhu lyoshi. ");
INSERT INTO shr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Bene Rasheli mukà Yakôbo: Yozefu na Benyamini. ");
INSERT INTO shr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","E Mîsiri, Yozefu aburhirayo Menashè na Efrayimu kuli Asinati, mwâli wa Potifari, mudâhwa wa Oni. ");
INSERT INTO shr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bene Benyamini: Bela, Bekeri, Asibeli, Gera, Naamani, Ekî, Roshi, Mupimi, Hupimu na Aredi. ");
INSERT INTO shr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bo bâna Rasheli aburhîre Yakôbo abo; boshi haguma bali bantu ikumi na bâni. ");
INSERT INTO shr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Bene Dani: Hushimi. ");
INSERT INTO shr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Bene Nefutali: Yasieli, Guni, Yeseri, na Shilemi. ");
INSERT INTO shr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bo bene Bilaha abo, olya Labani ahàga omwâli Rasheli; bo bâna aburhîre Yakôbo, boshi haguma bali bantu nda. ");
INSERT INTO shr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abantu bàjîre e Mîsiri haguma na Yakôbo, balya barhenga omu nda yâge yêne, buzira kuganja bakà abagala, boshi haguma bali bantu makumi gali ndarhu na ndarhu. ");
INSERT INTO shr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Abâna ba Yozefu baburhiragwa e Mîsiri bàli babirhi. Abantu b’omulala gwa Yakôbo bayishire e Mîsiri boshi haguma bali bantu makumi gali nda. ");
INSERT INTO shr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Israheli arhuma Yûda mpu abè ashokola ajè emwa Yozefu, amubwîre amushange e Gosheni. Bahika omu cihugo c’e Gosheni. ");
INSERT INTO shr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yozefu ashwekera ebibêsi oku ngâlè yâge, ayishoneramwo, mpu ajè e Gosheni aj’iyankirira îshe Israheli. Erhi anajà omu masù gâge ntya, acîkwêba omu igosi lyâge, alaka kasanzi karhali kanyi erhi anamuhôbîre. ");
INSERT INTO shr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israheli abwîra Yozefu, erhi: «Lêro nankajâga nafà obu namâbona obusù bwâwe, namanashanga ocibamwo omûka». ");
INSERT INTO shr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yozefu anacibwîra bakulu bâge n’omulala gw’îshe, erhi: «Nkola nasôka mmanyise Faraoni mwâmi w’e Mîsiri oku nnamubwîre, nti: Balya bakulu bâni n’omulala gwa larha bàbâga omu cihugo c’e Kanâni bamantindakwo». ");
INSERT INTO shr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","«“Abo bantu babà bakafè, barhahimwa kushîbirira ebintu byâbo. Bayishire badwîrhe enkafu n’ebibuzi byâbo; na ngasi hyâbo hyoshi”. ");
INSERT INTO shr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Na ninyu, hano Faraoni mwâmi w’e Mîsiri amuhamagala n’okumudôsa”, erhi: “Mukolo muci mukola?”» ");
INSERT INTO shr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","«Mwanamushuza mpu: “Waliha, bambali bâwe barharhenga oku bintu byâbo, kurhenga eburhò bwâbo kuhika buno, rhwono kwo rhuyôrhera ntyo kurhengera kuli balarha”. “Ntyo, mwanahash’iyûbaka omu cihugo ca Gosheni, bulya Abanyamisiri barhabona oku bangere”». ");
INSERT INTO shr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yozefu akanyagya obwo aj’ilamukiza bene wâbo emwa Faraoni mwâmi w’e Mîsiri, erhi: «Larha na bene wîrhu bamayîsha, barhenga omu cihugo c’e Kanâni, badwîrhe enkafu n’ebibuzi byâbo, na ngasi byâbo bajira, bâbo bahanzire omu cihugo ca Gosheni». ");
INSERT INTO shr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ali amârhôla bantu barhanu ba muli bene wâbo, agend’ibalangûla Faraoni mwâmi w’e Mîsiri; ");
INSERT INTO shr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraoni mwâmi w’e Mîsiri abadôsa, erhi: «Mukolo muci mukola?» Bashuza Faraoni mwâmi w’e Mîsiri, mpu: «Yâgirwa, rhwono bambali bâwe, rhuyôrha rhubà bakafè, rhwono, n’ababusi bîrhu ko bàli». ");
INSERT INTO shr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Babwîra Faraoni mwâmi w’e Mîsiri obwo, mpu: «Rhuyishir’ibêra mwo cino cihugo bulya e Kanâni rhwàli, ebibuzi bya bambali bâwe birhacigwêrhe lwabûko: ecizombo cikalihireyo bwenêne». ");
INSERT INTO shr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraoni mwâmi w’e Mîsiri abwîra Yozefu, erhi: «Sho na bene winyu bayishirage emunda oli. ");
INSERT INTO shr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ecihugo ca Mîsiri eci embere zâwe: oyubase sho na bene winyu halya onabwîne hali hinjà omu cihugo. Bayûbake e Gosheni n’okabona balimwo abantu bankahasha, onabajire babè bangere b’amasò gâni nago». ");
INSERT INTO shr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yozefu ageza îshe Yakôbo, amulamukiza emwa Faraoni mwâmi w’e Mîsiri. Yakôbo ahâna omusingo emunda Faraoni mwâmi w’e Mîsiri ali. ");
INSERT INTO shr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraoni mwâmi w’e Mîsiri adôsa Yakôbo, erhi: «Emyâka y’amâburhwa gâwe yankabâga nk’inga obu?» ");
INSERT INTO shr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakôbo ashuza Faraoni mwâmi w’e Mîsiri, erhi: «Emyâka nashinzire ndwîrhe nagendagenda, eri igana na makumi asharhu. Eri myofi eri na buhanya. Erhacihika oku ya balarha amango bakazâg’igendagenda». ");
INSERT INTO shr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakôbo ashub’ilamusa Faraoni mwâmi w’e Mîsiri, anamusengeruka. ");
INSERT INTO shr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yozefu ayubasa îshe na bene wâbo, abayêreka ishwa omu cihugo c’e Mîsiri, lwo lwàli luhande lununu omu cihugo coshi, omu ca Ramusesi, kwo Faraoni mwâmi w’e Mîsiri anali arhegesire. ");
INSERT INTO shr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yozefu akaz’ihà îshe omugati, akaz’iguhà na bakulu bâge n’ab’omu nyumpa y’îshe, boshi nk’oku banali n’abâna bâbo. ");
INSERT INTO shr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Omugati gwàli gubulikîne omu cihugo coshi, erhi kudârhabala kw’ecizombo kurhuma. Ecihugo ca Mîsiri n’eca Kanâni, byàshalika byàrhalusa. ");
INSERT INTO shr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yozefu àyomeka ngasi lufaranga lwânali omu cihugo ca Mîsiri n’omu ca Kanâni, akaz’iguza engano, nabo banayîsh’imugulira. Ezo nsaranga akaziz’ilunda omu bwâmi bwa Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Erhi enfaranga zihwa omu cihugo ca Mîsiri n’omu ca Kanâni, Abanya Mîsiri boshi bajà emunda Yozefu ali mpu: «Orhuhè omugati, kurhi rhwankafîraga omu masù gâwe? Enfaranga zarhuhwerîre». ");
INSERT INTO shr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yozefu ababwîra, erhi: «Mulêrhe amasò ginyu, namuhînganira, mmuhè omugati ninyu mumpè amasò ginyu obwo murhacigwêrhi nsaranga». ");
INSERT INTO shr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Bakaz’ilêrha amasò gâbo emunda Yozefu ali, naye akaz’ibahà omugati, kukolaga kubahînganira amasò g’ebiterusi, ag’ebibuzi, ag’enkafu n’ag’endogomi. Mw’ogo mwâka abalîsa omugati akaz’iguhîngana amasò gâbo. ");
INSERT INTO shr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Omwâka gwacîkonya, ogwakulikiraga, bakanya bajà emunda Yozefu ali, mpu: «Rhurhankakufulika nnâhamwîrhu oku enfaranga zarhuhwerire, n’amasò gakola gali ga nnawîrhu. Harhacisigiri ecindi rhwankaha nnawîrhu aha nyuma z’eno mibiri yîrhu n’amashwa gîrhu. ");
INSERT INTO shr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Cankarhuma rhufîra omu masù gâwe rhwono n’amashwa gîrhu? Orhugule mugati rhwe n’amashwa gîrhu; rhucîbêre bajà ba Faraoni mwâmi w’e Mîsiri rhwe n’amashwa gîrhu. Orhuhè n’emburho rhwarhwêra lyo rhulama rhulek’ifà, lyo n’amashwa gîrhu garhag’ibà bwerûle». ");
INSERT INTO shr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ntyo kwo Yozefu afulukizagya Faraoni mwâmi w’e Mîsiri amashwa g’Abanyamisiri goshi, kulya kubà ngasi Munyamisiri àli amamuguliza ishwa lyâge erhi eco cizombo cirhuma, na ntyo ecihugo coshi càshuba ishwa lya Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Abantu nabo, abahindula bajà kurhenga oku cikwi ca Mîsiri kuhika oku cindi. ");
INSERT INTO shr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mashwa g’abadâhwa gône arhagulaga bulya abadâhwa bakazâg’ihâbwa na Faraoni mwâmi w’e Mîsiri omwanya gwâbo, banakaz’ilamira oku mwanya Faraoni mwâmi w’e Mîsiri akazâg’ibahà; co carhumire bôhe barhaguza amashwa gâbo. ");
INSERT INTO shr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yozefu abwîra olubaga, erhi: «Namuguzirage bulya mwoyo n’amashwa ginyu, mukola muli bantu ba Faraoni mwâmi w’e Mîsiri». Erhi: «Alagi, emburho eyi mujag’irhwêra ago mashwa. ");
INSERT INTO shr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Hano muyêza mwanakaz’ihà Faraoni mwâmi w’e Mîsiri cigabi ciguma ca karhanu na ninyu muyôrhane ebindi bigabi bini, byo byarhengakwo emburho yajà omu ishwa, kurhenge n’ebiryo mwalya na bene winyu n’abâna binyu». ");
INSERT INTO shr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Baderha, mpu: «Warhucizize, kufà rhwàli rhwafà: owabona rhubona obwonjo omu masù ga nnawîrhu, rhwanayemera rhubè bajà ba Faraoni mwâmi w’e Mîsiri». ");
INSERT INTO shr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Okwo, Yozefu akujira irhegeko n’eryo irhegeko liciba omu cihugo ca Mîsiri kuhika ene: ecigabi ca karhanu Faraoni mwâmi w’e Mîsiri cirhûlwa. ");
INSERT INTO shr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bene Israheli bàbêra e Mîsiri omu ishwa ly’e Gosheni, barhôlamwo agâbo mashwa, baburhana bayololoka bwenêne. ");
INSERT INTO shr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakôbo ashinga myâka ikumi na nda omu cihugo c’e Mîsiri, n’emyâka y’akalamo ka Yakôbo, liri igana na makumi anni na nda. ");
INSERT INTO shr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Erhi ensiku z’okufà kwa Israheli zibà zikola ziri hôfi, ahamagala omugala Yozefu, amubwîra erhi: «Akabà ntonyire emunda oli, nkuhûnyire ohire okuboko kwâwe oku cibunu câni, okândola bwinjà onakaz’inyumva: orhambishaga eno Mîsiri. ");
INSERT INTO shr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Amango nâbà nkola ngwîshîre na balarha, onantenze e Mîsiri oj’imbisha omu nshinda yâbo». Yozefu anacishuza, erhi: «Najira okwo onahûnyire». ");
INSERT INTO shr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakôbo ederha erhi: «Ocîgashe là». Acîgasha omu masù gâge. Oku bundi Israheli ayunamira oku mushego gw’encingo yâge. ");
INSERT INTO shr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Enyuma z’aho, bàbwîra Yozefu mpu: «Lolà oku sho alwazire!» Yozefu arhôla abagala bombi, Menashè na Efrayimu, bagenda boshi. ");
INSERT INTO shr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Banacimanyîsa Yakôbo, mpu: «Lolà, mugala wâwe Yozefu oyo ayishire emunda oli». Israheli acihangâna, abwârhala oku ncingo. ");
INSERT INTO shr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakôbo abwîra Yozefu, erhi: «Nyamuzinda-Ogala-Byoshi ambonekîre aha Luzu omu cihugo ca Kanâni angisha. ");
INSERT INTO shr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Anambwîra, erhi: Najira oyôloloke, nakuluza, nakujira ohinduke mwandu gwa mashanja, eci cihugo nacihà iburha lyâwe enyuma zâwe cibè câbo ensiku zoshi». ");
INSERT INTO shr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Abà bâna bâwe baburhiragwa e Mîsiri embere nyîshe aha burhambi bwâwe, bakola bâna bâni: Efrayimu na Menashè bakola b’omu bâna bâni aka Rubeni na Simoni. ");
INSERT INTO shr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ci abâna waburhaga enyuma z’abo, babà bâwe; bakaz’iderhwa amazîno ga bakulu bâbo bunya-kashambala. ");
INSERT INTO shr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Amango narhengaga e Padani, nalengana, nyoko Rasheli afîra omu cihugo c’e Kanâni, erhi rhunaciri omu njira, rhucisigazize lugendo lusungunu rhuhike aha Efrata; ho nanamubishire aho oku njira, yo erigi e Betelehemu eyo. ");
INSERT INTO shr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israheli abona abâna ba Yozefu bombi adôsa, erhi: «Bahi abà?» ");
INSERT INTO shr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Naye omugala, erhi: «Bo bâna Nyamuzinda ampîre eno munda abo». Îshe ashuza erhi: «Obanderhere mbagishe». ");
INSERT INTO shr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Amasù ga Israheli gàli gakola garhamire n’obushosi, arhacibonaga. Yozefu anacibashegeza hali ye, naye abanûnugurha anabahôbera. ");
INSERT INTO shr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israheli anacibwîra Yozefu, erhi: «Ntàli mmanyire oku nacibona obusù bwâwe, ci lolaga oku Nyamuzinda amanyêreka ciru n’iburha lyâwe». ");
INSERT INTO shr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yozefu abayegûla abarhenza aha madwî g’îshe, anafukama ayunama, amalanga gahuma oku idaho. ");
INSERT INTO shr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yozefu abagwârha bombi: Efrayimu omu kulyo kwâge, mpu lyo ajà ebwa kumosho kwa Israheli na Menashè omu kumosho kwâge, mpu lyo ajà ebwa kulyo kwa Israheli, anabashegeza hali ye. ");
INSERT INTO shr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israheli alambûla okuboko kwâge kulyo, akuhira oku irhwe lya Efrayimu ye wali murhò n’okuboko kwâge kumosho oku irhwe lya Menashè, omu kurhahêkanya amaboko, ebwa kubà Menashè ye wali nfula. ");
INSERT INTO shr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Erhi àkola agisha Yozefu amubwîra, erhi: «Nyamuzinda, ababusi bâni Abrahamu na Izaki bakazâg’ilambagira embere zâge, ye Nyamuzinda onyâbula kurhenga mbà ho kuhika ene, ");
INSERT INTO shr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malahika wandîkûzagya muli ngasi mabî, agishe abà bâna. Izîno lyâni n’izîno lya balarha Abrahamu na Izaki libalamiremwo, baluge banayololoke hano igulu». ");
INSERT INTO shr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yozefu abona oku îshe ahebire okuboko kwâge kulyo oku irhwe lya Efrayimu, agaya, agwârha okuboko kw’îshe akurhenza kuli Efrayimu akudekereza oku irhwe lya Menashè. ");
INSERT INTO shr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yozefu abwîra îshe, erhi: «Arhali ntyo, larha, bulya oyu ye mukulu, ohebe okuboko kwâwe kulyo oku irhwe lyâge». ");
INSERT INTO shr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Cikwône îshe alahira ederha, erhi: «Mmanyire mwâna wâni, mmanyire, naye àbà ishanja, naye aluga, cikwône mulumuna wâge ye wabà n’obuhashe bunene kumulusha, n’iburha lyâge lyabà mwandu gwa mashanja». ");
INSERT INTO shr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Olwo lusiku abagisha ntya: «Mwoyo mwe Bene Israheli bakaz’igisha omu kuderha izîno linyu, mpu: “Nyamuzinda akujire aka Efrayimu na Menashè”». Abà Efrayimu ye aheba embere za Menashè. ");
INSERT INTO shr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Oku bundi Israheli abwîra Yozefu, erhi: «Lolà oku nkola naling’icîfîra. Cikwône Nyamuzinda âyôrha ali haguma ninyu, anamushubize omu cihugo ca bashakulûza binyu. ");
INSERT INTO shr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","“Niono, nkuhîre Sikemi mwanya gurhalusire ebya bakulu bâwe, gwo nanyagaga Abamoriti n’engôrho zâbo haguma n’omuherho gwâni.”» ");
INSERT INTO shr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakôbo ahamagala abagala ababwîra, erhi: «Mujè haguma mmubwîre ebyamuyishira omu nsiku zàyisha. ");
INSERT INTO shr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Bene Yakôbo, mujè haguma, muyumvîrhize. ");
INSERT INTO shr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubeni w’e nfula yâni, we misî yâni we mburho ntanzi y’obugabo bwâni, we lunjwire-ifêka, we lunjwire-buhashe; ");
INSERT INTO shr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","lunjwire-luka w’amîshi, orharhîmukwe, bulya washonîre oku ncingo ya sho, wahemwire encingo yâni erhi oyishonera kwo! ");
INSERT INTO shr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simoni na Levi bali baguma balondana, emishîgi yâbo bayihisize oku bushwinjiro. ");
INSERT INTO shr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Omurhima gwâni gurhahîraga gukaja omu ihano lyâbo, bulya bàyisire abantu omu burho bwâbo n’omu bukunizi bwâbo, barhungula empanzi. ");
INSERT INTO shr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bukahera obukunizi bwâbo, bulya bwarhalusire olugero, bukahera obudârhi bwâbo, bulya bwabîre bwa bumînya. Nabagabanya muli Yakôbo, nabashandabanya muli Israheli. ");
INSERT INTO shr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Nâwe Yûda, bene winyu banakukuze; okuboko kwâwe kugwarhîre abanzi bâwe aha igosi, bagala ba sho banayuname embere zâwe. ");
INSERT INTO shr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yûda ali ntale nto, wamayinamuka warhenga oku nsimba, mwâna wâni! Ashurhamire, agwîshira nka ntale, nka ntale nkazi: ndi wankaciyizûsa? ");
INSERT INTO shr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ishungwè lirhakarhenga omu mwa Yûda, n’akarhi k’oburhegesi karhakarhenga omu magulu gâge, kuhika nnako ayîshe; ye amashanja goshi ganayumve. ");
INSERT INTO shr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ashwekîre endogomi yâge oku muzâbîbu, n’akanina k’endogomi yâge oku ishami ly’omuzâbîbu. ");
INSERT INTO shr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amasù gâge gadukwire n’idivayi, n’amîno gâge gayeruhire n’amarhà. ");
INSERT INTO shr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloni ayûbasire oku burhambi bw’enyanja, hala amârho gasîka; lubibi na Sidoni. ");
INSERT INTO shr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari, ye ndogomi ndârhi, egwîshîre omu karhî k’ecôgo. ");
INSERT INTO shr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Abwîne oku okuluhûka kubà kwinjà, n’oku ecihugo cibà cinunu; omugongo gwâge agurhezire omuzigo, ahindusire mujà wa kubarhula emicimba. ");
INSERT INTO shr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani ye katwa-manja k’olubaga lwâge, nka ngasi ishanja ly’Israheli. ");
INSERT INTO shr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani abè njoka elingira oku njira, abè mpiri eri omu njira, ekâlumira ebiterusi oku cisenyi, omulwî oyitamirekwo anakumbe lugali. ");
INSERT INTO shr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Bucire bwâwe ncîkubagîre yâgirwa Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi, ba-rhûla-rhugabe bamushokôla naye abashokôla anabarhulubire oku kansisira. ");
INSERT INTO shr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asheri, omugati gwâge kushushagira gushushagira, yeyikuza mwâmi. ");
INSERT INTO shr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nefutali, ye kashafu kabidu, ko kaburha banji na binjà. ");
INSERT INTO shr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yozefu, ye mulandirà gwa muzâbîbu guyâna bwenêne, mulandirà murhwêre aha iriba, amashami gâgwo garhalusire olukûta. ");
INSERT INTO shr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Emandabisonga zamulibuzize, zamulasha zanamuyishakwo. ");
INSERT INTO shr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ci omuherho gwâge, gurhahuligana, amaboko gâge, gabangaduke, oku buhashe bw’Ogala-byoshi wa Yakôbo, oku burhabâle bwa lungere, Kabuye k’Israheli. ");
INSERT INTO shr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Oku buhashe bwa Nyamuzinda wa sho, yêne akurhabâle, oku buhashe bw’Ogala byoshi, yêne akugishire. Emigisho y’emalunga enyanya, omugisho gw’omu nyenga y’ekuzimu, emigisho y’enda n’ey’ibêre, ");
INSERT INTO shr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","migisho ya sho elushire emigisho y’omu ntondo za mîra, kuhika aha bwinjà bw’entondo z’ensiku n’amango, esimikire oku irhwe lya Yozefu, oku malanga g’omuluzi wa bene wâbo. ");
INSERT INTO shr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamini ali cihazi oshamula, sêzi ashanshanyule omunyama gwâge, bijingo agabe omunyago». ");
INSERT INTO shr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yo milala ikumi n’ibirhi eyo; kwo îshe ababwizire ntyôla erhi akola abagisha. Aha ngasi muguma omugisho gumukwânîne. ");
INSERT INTO shr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Oku bundi àbahà eri irhegeko, erhi: «Nkola naj’ishanga bene wîrhu; mumbîshe aha burhambi bwa balarha omu lukunda luli omu ishwa lya Efroni-Muhititi, ");
INSERT INTO shr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","omu lukunda lw’ishwa lya Makipela abà ishiriza lya Mambri, omu cihugo ca Kanâni: liryala Abrahamu aguliraga Efroni Muhititi, mpu lubè luvumbu lwâge. ");
INSERT INTO shr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Mwo babishire Abrahamu bo na mukâge Sara; aho ho babishire Izaki bo na mukâge Rebeka, nâni mwo nabishire Leya. ");
INSERT INTO shr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ishwa haguma n’olukunda luli muli ryo, babiguliraga bene Heti». ");
INSERT INTO shr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Erhi Yakôbo ayûs’ihà abagala ago mahano, ashubiza amagulu gâge oku ncingo, arhenga mwo omûka, bamuhira kuli b’îshe. ");
INSERT INTO shr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yozefu acîkwêba oku mugogo gw’îshe, akaz’ilaka anamunûnugurha. ");
INSERT INTO shr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Oku bundi arhegeka abafumu bakazâg’imukolera mpu bashîge îshe omugavu. Abafumu bagwîra bashîga Israheli. ");
INSERT INTO shr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bajira ogwo mukolo nsiku makumi anni, bulya zo nsiku banakolêsa ezo nka bashîga omugavu. Abanyamisiri bàmulakira nsiku makumi gali nda. ");
INSERT INTO shr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Erhi ezo nsiku z’emishîbo zihwa, Yozefu àganîrira ntya omu bwâmi bwa Faraoni mwâmi w’e Mîsiri, erhi: «Akabà muli bîra bâni, mumpikize ebi binwa omu marhwiri ga Faraoni mwâmi w’e Mîsiri: ");
INSERT INTO shr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Larha andahirize ambwîra, erhi: Lolà oku nkola nafà; wambisha omu nshinda nahumbisagya omu cihugo ca Kanâni. Nalonza okujà eyo munda; ngend’ibisha yo larha nangaluke». ");
INSERT INTO shr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraoni mwâmi w’e Mîsiri ashuza, erhi: «Osôke ogend’ibisha sho nk’oku anakulahirizagya». ");
INSERT INTO shr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yozefu asôka agend’ibisha îshe. Bagenda haguma naye: abarhambo ba Faraoni mwâmi w’e Mîsiri boshi, abarhonyi b’omu bwâmi, n’abagula b’omu cihugo ca Mîsiri boshi ");
INSERT INTO shr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","n’ab’omu mulala gwa Yozefu boshi, bakulu bâge n’ab’omu mulala gw’îshe; barhasigaga e Gosheni abarhali abâna barhò, ebintu binyinyi n’ebinênênè. ");
INSERT INTO shr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Basôka haguma naye, engâlè n’abêrekeza bazihêka, gwàli muzinzi gurhali munyi. ");
INSERT INTO shr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Erhi bahika aha Goren-Ha-Atadi, ishiriza lya Yordani, babanda endûlù yashakanya, Yozefu ashub’ishîba îshe nsiku nda. ");
INSERT INTO shr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Abanyakanani erhi babona eyo mishîbo aha Goren-Ha-Atadi baderha, mpu: «Loli okushîba kunene kw’Abanyamisiri». Co cirhuma baderha aho mpu bo Abeli-Misirayimu, aho bantu babà aha ishiriza lya Yordani. ");
INSERT INTO shr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Abagala bamujirira nk’oku anali abarhegesire. ");
INSERT INTO shr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bamuhèka omu cihugo ca Kanâni, bagend’imubisha omu lukunda lw’ishwa lya Makipela, Abrahamu aguliraga Efroni-Muhititi, mpu lubè luvumbu lwâge, aha ishiriza lya Mambri. ");
INSERT INTO shr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Erhi bayûsa okubisha îshe, Yozefu anacishubira e Mîsiri, boshi na bakulu bâge, na ngasi bandi banalibabalusize ebwa kuj’ibisha îshe. ");
INSERT INTO shr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bene wâbo Yozefu, erhi babona îshe amâfà, baderha, mpu: «Erhi Yozefu akarhukolera nka bashombanyi bâge, akanarhugalulira amabî nk’oku rhwanmujiriraga kubî?» ");
INSERT INTO shr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Banacirhuma abagend’ibwîra Yozefu, erhi: «Sho asizire akanwa embere afè, aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Kwo mwabwîra Yozefu ntya, erhi: Mâshi, obabalire bene winyu obubî bwâbo, n’ecâha câbo, bulya kuligo bakukolîre. Bunôla nkolaga nkuhûnyire, obabalire obubî bwa bambali ba Nyamuzinda wa sho». Yozefu avugumula emirenge erhi ayumva ebinwa bamubwîraga. ");
INSERT INTO shr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bene wâbo bône bayisha, bacîrhimba aha magulu gâge, erhi: «Rhwono! Rhuli bajà bâwe». ");
INSERT INTO shr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yozefu abashuza, erhi: «Mâshi, murhayôbohaga, ka niono nankacîhira ahâli ha Nyamuzinda? ");
INSERT INTO shr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwâli mulonzize okunjirira amabî, Nyamuzinda yêhe alonza okurhenzamwo aminjà, mpu lyo oku kwamayisha ene kubà mpu anafungire omûka gw’olubaga lurhali lunyi. ");
INSERT INTO shr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kuziga murhaciyôbohaga cici, namulera bwinjà mweshi n’abâna binyu». Abarhûliriza anababwîra akanwa kabagwa oku murhima. ");
INSERT INTO shr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ntyo Yozefu abêra e Mîsiri obwo, ye n’omulala gw’îshe. Alama myâka igana n’ikumi. ");
INSERT INTO shr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yozefu abwîne abinjikulûza b’emwa Efrayimu n’abâna ba Makiri, mwene Menashè; oku madwî ga Yozefu bàburhirwe! ");
INSERT INTO shr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yozefu abwîra bene wâbo, erhi: «Niono nkola nafà, ci kwône Nyamuzinda amurhandûla, amusôsa murhenge muli cino cihugo, mujè muli cirya cihugo alaganyagya oku aha Abrahamu, Izaki na Yakôbo». ");
INSERT INTO shr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yozefu alahiriza bene Israheli, erhi: «Amango Nyamuzinda amurhandûla, munasokane amavuha gâni kurhenga eno». ");
INSERT INTO shr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yozefu afà erhi akola agwêrhe myâka igana n’ikumi. Bamushîga omugavu banamuhira omu isanduku e Mîsiri.");
INSERT INTO shr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Amazîno ga bene Israheli bajâga e Mîsiri bayijàga haguma na Yakôbo, ngasi muguma n’omulala gwâge: ");
INSERT INTO shr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simoni, Levi na Yûda, ");
INSERT INTO shr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zabuloni na Benyamini, ");
INSERT INTO shr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani na Nefutali, Gadi na Aseri. ");
INSERT INTO shr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abo bene Yakôbo bali bantu makumi gali nda, Yozefu yêhe erhi akola abà e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yozefu na bene wâbo boshi kwo n’okwo, n’eryôla iburha lyoshi. ");
INSERT INTO shr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bene-Israheli banaciyôloloka, baluga, babà mwandu, bagala, bagandâza, babumba ecihugo. ");
INSERT INTO shr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Lêro omwâmi muhyâhya, orhalimanyire Yozefu, anaciyîma omu Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Anacibwîra abantu bâge, erhi: «Ka murhabwîni oku bene-Israheli bajà baluga banazibuha kurhulusha? ");
INSERT INTO shr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Rhubasingire obwenge bushinganîne, lyo baleka okuyôloloka. Erhi ebîrha byankabà, hali amango bakacihira olunda lw’ababisha, na hano babà bamarhulwîsa, bacîrhengeremwo cino cihugo». ");
INSERT INTO shr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Okubundi banacibahirakwo abarhambo bakazibakolêsa obukûkuru, mpu lyo babagombya n’emikolo mizibu. Ntyo kwo bayûbakire Faraoni mwâmi w’e Mîsiri ebishagala by’embîko, Pitomu na Ramusesi. ");
INSERT INTO shr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ci oku babalibuza ntyo, erhi kwo nabo bayûshûka banazibuha kulusha: abanya-Mîsiri bakazilama omu côbà ca bene-Israheli. ");
INSERT INTO shr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Lêro abanya-Mîsiri bakolêsa bene-Israheli okurhalusire, ");
INSERT INTO shr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","babalibuza n’emikolo midârhi: okulabarha ebijondo, okujira amadofali, emikolo y’omu mashwa yoshi, na ngasi yindi mikolo y’okubalibuza. ");
INSERT INTO shr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Omwâmi w’e Mîsiri anacibwîra abakazi bâlikwa bakagibusa abakazi b’Abayahudi, muguma muli bo ye wali Shifra n’owundi ye Puwa, erhi: ");
INSERT INTO shr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Nka mwabusa abakazi b’Abayahudi, mukâlola bwinjà, aciri oku ncingo, mwâna muci obusirwe. Akabà mwâna-rhabana, munamuyîrhe; akabà mwâna-nyere, munamuleke alame.» ");
INSERT INTO shr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ci abo bakazi b’okubusa barhînya Nyamuzinda, barhajiraga oku mwâmi w’e Mîsiri ababwîraga, bakazileka abânarhabana balame. ");
INSERT INTO shr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Lêro mwâmi w’e Mîsiri anacibahamagala, ababwîra, erhi: «Càrhumire mujira ntyo munaleka abânarhabana balama?» ");
INSERT INTO shr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Balya bakazi b’okubusa banacibwîra mwâmi Faraoni mwâmi w’e Mîsiri, mpu: «Abakazi b’Abayahudi barhali ak’abakazi banya-Mîsiri; babà bakazi bazibu; embere omukazi w’okubusa abahikeho, erhi mîra baburhaga.» ");
INSERT INTO shr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nnâmahanga arhabâla abo bakazi bâlikwa, nalo olubaga lwajà lwayushûka lwanazibuha. ");
INSERT INTO shr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kulya kubà abo bakazi bâlikwa bakagirhînya Nyakasane, Nyakasane naye abahà iburha. ");
INSERT INTO shr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Faraoni mwâmi w’e Mîsiri kwo kurhegeka abantu bâge boshi, erhi: «Ngasi mwâna-rhabana waburhwe, munamulohe erwîshi, ci ngasi mwâna-nyere munaleke alame». ");
INSERT INTO shr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Muntu muguma w’omu bûko bwa Levi anacijà aho, ayanka omunyere w’omu bûko bwa Levi. ");
INSERT INTO shr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nyamukazi anacirhôla izîmi, aburha mugala. Erhi abona oku ali mwinjà, ajira myêzi isharhu erhi kufulika amufulika. ");
INSERT INTO shr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Lêro erhi acibula oku ankacishub’ikâmufulika, arhôla ecirhimbiri c’enfinjo, acîshîga ebizibwe n’obulembo, acihiramwo olya mwâna, acidekereza omu masheke eburhambi bw’olwîshi. ");
INSERT INTO shr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mwâli wâbo nyamwâna abêra kuli hitya mpu alole kurhi abà. ");
INSERT INTO shr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Lêro mwâli wa Faraoni mwâmi w’e Mîsiri anaciyandagalira ebwa lwîshi mpu aj’icîshuka, oku abajà-nyere bâge barhambika oku lwîshi. Anacilangîra ecirhimbiri omu masheke, àrhuma omujà-nyere wâge mpu ajicilêrha. ");
INSERT INTO shr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Anacicifunula, abona omwâna: ali mwâna-rhabana odwîrhe alaka. Obwonjo bwamugwârha, anaciderha, erhi: «Mwâna wa Bayahudi oyu». ");
INSERT INTO shr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Okubundi mwâliwâbo nyamwâna anacibwîra mwâli wa Faraoni mwâmi w’e Mîsiri, erhi: «Ka walonza njihamagala omulezi omu bakazi b’Abayahudi akazikuyonkekeza oyu mwâna?» ");
INSERT INTO shr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mwâli wa Faraoni mwâmi w’e Mîsiri amubwîra, erhi: «Gendaga omulonze.» Olya munyere agendihamagala nnina wa nyamwâna. ");
INSERT INTO shr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwâli wa Faraoni mwâmi w’e Mîsiri amubwîra, erhi: «Mpêkera oyu mwâna, ojikamuyonsa, niene nayishikuhêmba.» Olya mukazi anacirhôla omwâna, akamuyonsa. ");
INSERT INTO shr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Erhi omwâna akula, amuhêkera mwâli wa Faraoni mwâmi w’e Mîsiri. Naye amuyankirira nka mugala; amuyîrika izîno lya «Mûsa», erhi: «Namurhôlaga omu mîshi.» ");
INSERT INTO shr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Muli ezo nsiku, Mûsa erhi akolaga mukulu, àkanya mpu agendilamusa bene wâbo, abona kurhi barhindibusire n’emikolo y’obujà. Abona oku Omunya-Mîsiri ashûrha mwene wâbo w’Omuyahudi. ");
INSERT INTO shr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Alola eyi n’eyi, abona ntâye omubwîne, àniga olya Munya-Mîsiri anamufulika omu mushenyi. ");
INSERT INTO shr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Erhi buca, kandi ashubigenda: ashimâna Bayahudi babirhi badwîrhe balwa. Anacibwîra owalihalalîre owâbo, erhi: «Cici oshûrhire owinyu?» ");
INSERT INTO shr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Olya mulume amubwîra, erhi: «Ndi wakujiraga murhambo na mucîranuzi wîrhu? K’omanyire mpu nâni wanyîrha nka kulya wayîrhaga olya Munya-Mîsiri?» Mûsa àyôboha, erhi: «Kuziga kulya kwamanyîkîne!» ");
INSERT INTO shr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faraoni mwâmi w’e Mîsiri ayumva baderha ogwo mwanzi, ahiga okuyîrha Mûsa. Ci Mûsa abunga, ayâka Faraoni mwâmi w’e Mîsiri; acijîra omu cihugo c’e Madiyani, aburhamala hôfi n’iriba. ");
INSERT INTO shr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Omudâhwa w’e Madiyani ali agwêrhe banyere bâge nda. Banaciyisha balidôma n’okuyunjuza ebiranga mpu banywese amasò g’ebintu by’îshe. ");
INSERT INTO shr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Abangere banaciyisha, babalibirhakwo. Lêro Mûsa anaciyimuka, abarhabâla ananywêsa amasò gâbo. ");
INSERT INTO shr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Erhi bagaluka emw’îshe Reweli, abadôsa, erhi: «Lêro càrhumire mubiduha ntya ene?» ");
INSERT INTO shr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bamushuza, mpu: «Munya-Mîsiri muguma warhushugunwire omu maboko g’abangere, ciru ye wanarhudomire ananywêsa amasò!» ");
INSERT INTO shr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Anacibwîra abâli, erhi: «Ngahi ali? Carhumaga musiga oyo muntu? Hamagali ye, ayîshe alyè!» ");
INSERT INTO shr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mûsa ayêmêra okubêra aha mw’oyo mulume, naye anacimuhà omwâli Sipora. ");
INSERT INTO shr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nyamuhya anaciburha omwâna-rhabana. Mûsa amuyîrika izîno lya Gershomi, erhi: «Bulya ndi mubunga omu cihugo c’ihanga.» ");
INSERT INTO shr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Erhi nsiku nyinji zigera, omwâmi w’e Mîsiri afà. Mwo bulya bujà bwâbo, bene-Israheli balakira Nyamuzinda, babanda endûlù, na kurhenga omu bujà bwâbo, endûlù yâbo yasôkera emwa Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nyamuzinda ayumva endûlù yâbo; Nyamuzinda akengêra endagâno yâge bo n’Abrahamu, Izaki na Yakôbo. ");
INSERT INTO shr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nyamuzinda abona bene-Israheli oku balagîrîre; Nyamuzinda abamanyirira. ");
INSERT INTO shr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mûsa ali ayâbwîre obusò bw’ebibuzi by’ishazâla Yetro, mudâhwa w’e Mediyani. Alongôlana ebibuzi kulî-kulî omu irungu, àlinda ahika oku ntondo ya Nyamuzinda e Horebu. ");
INSERT INTO shr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malahika wa Nyakasane àmubonekera omu ngulumira y’omuliro yakagigulumira omu karhî k’ishaka. Mûsa alolêreza, abona ishaka lidwîrhe lyagulumira, ci lirhasingônoka. ");
INSERT INTO shr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mûsa aciderheza emurhima, erhi: «Nazunguluka ndole kw’oyu kabazâne: cici cirhumire eri ishaka lirhadwîrhi lyasingônoka?» ");
INSERT INTO shr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nyakasane abona oku ayisha azunguluka mpu alole; lêro Nyamuzinda anacimuhamagala omu kâgarhî ka lirya ishaka, erhi: «Mûsa, Mûsa!» Naye, erhi «Karame!» ");
INSERT INTO shr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Aderha, erhi: «Omanye wankayegêra hano! Hogola enkwêrho zâwe emagulu, bulya hano oyîmanzire hali hantu hatagatîfu.» ");
INSERT INTO shr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ashubiderha, erhi: «Nie Nyamuzinda wa sho, Nyamuzinda w’Abrahamu, Nyamuzinda w’Izaki, Nyamuzinda wa Yakôbo.» Mûsa acîhundikira obusù, bulya ali ayôbohire okulolakwo Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Nyakasane anaciderha, erhi: «Kwo binali, nabwîne amalibûko g’olubaga lwâni luli e Mîsiri, nayumvîrhe n’endûlù ludwîrhe lwabanda embere z’abadwîrhe balulibuza. Nêci, manyire malibuko maci lulimwo. ");
INSERT INTO shr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Co cirhumire nayandagala nti mbalikûze omu maboko g’Abanya-Mîsiri, mbarhenzemwo eci cihugo, mbaheke omu cihugo cinjà na cigali, omu cihugo cihululamwo amarhà n’obûci, omu cihugo cibâmwo Abakanani, Abahititi, Abamoriti, Abaperiziti, Abahiviti n’Abayebusi. ");
INSERT INTO shr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Na kulya kubà endûlù za bene-Israheli zampisirekwo, bulya nabwîne kurhi Abanya-Mîsiri badwîrhe babalibuza. ");
INSERT INTO shr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Yimukaga, ogende; nkurhumîre emwa Faraoni mwâmi w’e Mîsiri nti ogendirhenza olubaga lwâni lwa bene-Israheli e Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mûsa anacibwîra Nyamuzinda, erhi: «Ndigi muntu muci nâni obwo w’okurhungâna Faraoni mwâmi w’e Mîsiri, n’okurhenza olubaga lwa bene-Israheli e Mîsiri?» ");
INSERT INTO shr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Amubwîra, erhi: «Ndi haguma nâwe. Alaga n’ecimanyîso oku nie nkurhumire: hano ôbà wamarhenza olubaga e Mîsiri, mwayishibâgira Nyamuzinda enterekêro kuli eyi ntondo». ");
INSERT INTO shr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mûsa anacibwîra Nyamuzinda, erhi: «Nkolaga nacîbanda hali bene-Israheli, mbabwîre, nti: “Nyamuzinda wa basho ontumire emunda muli. Bakandosagya, mpu: Izîno lyâge ye ndi?, kurhigi nâbabwîra obwo?”» ");
INSERT INTO shr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nyamuzinda anacibwîra Mûsa, erhi: «Nie Nyamubâho.» Amubwîra, erhi: «Oyishibwîra bene-Israheli, erhi: “Nyamubâho ontumire emunda muli.”» ");
INSERT INTO shr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nyamuzinda àshubibwîra Mûsa, erhi: «Oyishibwîra bene-Israheli ntyâla, erhi: “Nyamubâho, Nyamuzinda wa basho, Nyamuzinda wa Abrahamu, Nyamuzinda wa Izaki, Nyamuzinda wa Yakôbo, antumire emunda muli. Eryo lyo izîno lyâni burhashuba, lyo izîno bakànkengêramwo kurhenga oku iburha kujà oku lindi.”» ");
INSERT INTO shr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Ogendishubûza abagula ba bene-Israheli boshi, obabwîre, erhi: “Nyamubâho, Nyamuzinda wa basho, Nyamuzinda wa Abrahamu, Nyamuzinda wa Izaki, Nyamuzinda wa Yakôbo anambonekire, ambwîra”, erhi: “Nahizire okummulîkûza, bulya nabwîne amabî goshi badwîrhe bammujirira e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","“Co cirhumire nderha, nti: Nammurhenza omu malibuko g’e Mîsiri, mmuyinamulire omu cihugo c’Abakanani, c’Abahititi, c’Abamoriti, c’Abaperiziti, c’Abahiviti, c’Abayebusi, omu cihugo cihululamwo amarhà n’obûci.”» ");
INSERT INTO shr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Bayishiyumva izù lyâwe, oyishigenda obwo, mwe n’abagula ba bene-Israheli, ojè emunda mwâmi w’e Mîsiri ali, mumubwîre, mpu: «Nyakasane, Nyamuzinda w’Abayahudi, anarhubonekire. Bunôla orhulekage, rhugende lugendo lwa nsiku isharhu omu irungu, rhujihêra Nyakasane, Nyamuzinda wîrhu. ");
INSERT INTO shr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Ci manyire oku mwâmi w’e Mîsiri arhamuyemerere mwagenda, akabà arhasezîbwi n’okuboko kuzibuzibu”. ");
INSERT INTO shr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","“Nkolaga nalambûla okuboko kwâni, nshûrhe Mîsiri n’ebirhangâzo najira muli ye. Enyuma ly’okwo anamulika mugende”». ");
INSERT INTO shr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«Narhabâla olu lubaga lurhone emwa Abanya-Mîsiri, lyo hano mugenda, mulekigenda maboko mûmu. ");
INSERT INTO shr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ngasi mbuguma ehûne omulungu wayo n’ecigolo ciri omu mwâge ebirugu by’amarhale, eby’amasholo n’emyambalo mubiyambike bagala binyu na bâli binyu. Mutungôle ntyo Abanya-Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mûsa ashuza, erhi: «Barhanyêmêre, barhayumve izù lyâni, ci bayishiderha, mpu: Nyakasane arhakubonekîre!» ");
INSERT INTO shr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nyakasane anacimubwîra, erhi: «Cici eco ofumbasire omu nfune?» Naye ashuza, erhi: «Karhi.» ");
INSERT INTO shr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Nyakasane amubwîra, erhi: «Kakwêbe oku idaho.» Akakwêba oku idaho: akarhi kahinduka njoka. Mûsa ayâka. ");
INSERT INTO shr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nyakasane abwîra Mûsa, erhi: «Lambûla okuboko, oyigwârhire oku mucira!» Alambûla okuboko, ayigwârha: erya njoka yashubihinduka karhi omu nfune zâge. ");
INSERT INTO shr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","«Lyo bayêmêra oku Nyakasane anakubonekîre, Nyamuzinda wa bîshe, Nyamuzinda wa Abrahamu, Nyamuzinda wa Izaki, Nyamuzinda wa Yakôbo.» ");
INSERT INTO shr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nyakasane ashubimubwîra, erhi: «Hira enfune oku nda yâwe» Ahira enfune oku nda anazigalula. Okuboko kwâge kwayunjula lushomyo, kwahinduka kwêru-kwêru nka lubula. ");
INSERT INTO shr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nyakasane amubwîra, erhi: «Shubiza okuboko kwâwe oku nda.» Ashubiza okuboko oku nda anakugalula; kwàli kwamashubibà nk’ebindi birumbu by’omubiri gwâge. ");
INSERT INTO shr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nyakasane, erhi: «Akabà barhakuyêmîri n’akabà barhayumvîrhîzi izù ly’ecimanyîso cirhanzi, bayêmêra izù ly’ecimanyîso ca kabirhi. ");
INSERT INTO shr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","N’akabà barhayêmîri ebyo bimanyîso bibirhi n’akabà barhayumvîrhîzi izù lyâwe, onarhôle amîshi g’omu Lwîshi, ogashandâze oku idaho; ago mîshi warhôlaga omu Lwîshi gahinduka mukò oku idaho.» ");
INSERT INTO shr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mûsa abwîra Nyakasane, erhi: «Onfè lukogo, Yâgirwa Nyakasane, ntishishongêza binwa nka naderha, oli kurhenga injo, oli kurhenga lishinjo, ciru na kurhenga aga mango goshi odwîrhe washambâza mwambali wâwe, bulya akanwa kâni kabà kazirho n’olulimi lwâni lurhahundûla.» ");
INSERT INTO shr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nyakasane amubwîra, erhi: «Ndi wahâga omuntu akanwa? Ndi odumya omuntu erhi okumujira cihuli, amujire wa kubona erhi muhûrha? K’arhali nie, Nyakasane? ");
INSERT INTO shr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","“Kanyagya, ogende, nâbà haguma n’akanwa kâwe, nnankakubwiriza ebi okwânîne okuderha.”» ");
INSERT INTO shr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mûsa ashuza, erhi: «Onfè lukogo, Yâgirwa Nyakasane, orhume owundi onalonzize!» ");
INSERT INTO shr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Oburhè bwa Nyakasane bwanacibiruka kuli Mûsa, amubwîra, erhi: «“Ka mukulu wâwe Aroni w’Omuleviti arhahali? Nyîshi oku yêhe ayishiderha. Ciru y’oyu oyishirikulamusa, na hano akubona, asîma omu murhima gwâge”. ");
INSERT INTO shr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","“Oyishimushambâlira, onahire ebyo binwa omu kanwa kâge. Nâni nâbà n’akanwa kâwe n’akâge nnammuyigirize ebi mukwânîne okujira”. ");
INSERT INTO shr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","“Ye wakazishambâza olubaga ahâli hâwe, ye wabà kanwa kâwe, nâwe obè nka Nyamuzinda wâge”. ");
INSERT INTO shr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","“N’aka karhî, okafumbarhe, ko wagendikajiramwo ebirhangâzo”» ");
INSERT INTO shr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mûsa anacigenda, ashubira emw’ishazâla Yetro, amubwîra, erhi: «Nkwânîne nshubire emwa bene wîrhu, njilola erhi bacibâmwo omûka.» Yetro ashuza Mûsa, erhi: «Ogende n’omurhûla!» ");
INSERT INTO shr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nyakasane abwîrira Mûsa e Madiyani, erhi: «Kanya, oshubire e Mîsiri, bulya balya boshi bakagilonza okukuyîrha bafîre.» ");
INSERT INTO shr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mûsa arhôla mukâge n’abagala, abashoneza oku cihêsi, ashubira omu cihugo c’e Mîsiri. Kalya karhi ka Nyamuzinda, Mûsa akafumbarha. ");
INSERT INTO shr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nyakasane abwîra Mûsa, erhi: «Obu washubira e Mîsiri, obuhashe bwa birya bisômerîne byoshi nakuhâga, obujirire embere za Faraoni mwâmi w’e Mîsiri, nâni namudundaguza omurhima, arhalike olubaga mpu lugende. ");
INSERT INTO shr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","“Ojibwîra Faraoni mwâmi w’e Mîsiri, erhi: Kwo Nyakasane adesire ntya: Israheli yo nfula yâni”; ");
INSERT INTO shr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","“Nkubwîzire, nti: Lîka mugala wâni ajinkolera, nâwe wamalahira bwamulika! Kwokwo, nâni nkolaga nayîrha enfula yâwe!”» ");
INSERT INTO shr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Erhi bahika omu njira aha bacumbika, Nyakasane amujaho analonza okumuyîrha. ");
INSERT INTO shr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sipora anacirhôla enshangabuye, akembûlamwo omugala, ayanka ecishisha, acigeza oku magulu ga Mûsa, ederha, erhi: «Mukò muguma rhwembi!» ");
INSERT INTO shr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nyakasane anacimuleka. Omu kuderha «mukò muguma rhwembi», bukembûle aderhaga. ");
INSERT INTO shr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nyakasane anacibwîra Aroni, erhi: «Kanya, obugane Mûsa omu irungu.» Agenda, amubugana oku ntondo ya Nyamuzinda, amuhôbera. ");
INSERT INTO shr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mûsa ashambâlira Aroni ebinwa byoshi Nyakasane amubwîraga mpu ajiderha n’ebirhangâzo byoshi amurhegekaga mpu ajijira. ");
INSERT INTO shr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mûsa n’Aroni banacigendishubûza abagula ba bene-Israheli boshi. ");
INSERT INTO shr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aroni ashubiderha birya binwa byoshi Nyakasane abwîraga Mûsa, anajirira ebirhangâzo omu masù g’olubaga. ");
INSERT INTO shr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Olubaga lwayêmêra. Lwayumva oku Nyakasane anagashanîre bene-Israheli n’oku anabwîne amalibûko gâbo; bafukama, baharâmya. ");
INSERT INTO shr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Okubundi Mûsa na Aroni bayishibwîra Faraoni mwâmi w’e Mîsiri, mpu: «Nyakasane Nyamuzinda w’Israheli adesire ntya: Leka olubaga lwâni lugende, lujinjirira olusiku lw’okunkuza omu irungu.» ");
INSERT INTO shr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraoni mwâmi w’e Mîsiri ashuza, erhi: «Ye ndi oyo Nyakasane, lyo nyumva izù lyâge, kurhume naleka Israheli agenda? Ntishi oyo Nyakasane, ntânaleke bene-Israheli nti bagende!» ");
INSERT INTO shr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Baderha, mpu: «Nyamuzinda w’Abayahudi arhubonekire: kukwânîne rhugende lugendo lwa nsiku isharhu omu irungu, rhujirherekêra Nyakasane, Nyamuzinda wîrhu, lyo alekicihonda kuli rhwe n’ecahira erhi n’engôrho.» ");
INSERT INTO shr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Omwâmi w’e Mîsiri ababwîra, erhi: «Wâni Mûsa mwe na Aroni, cirhumire mwalonza okushumika olubaga mpu luleke emikolo? Shubiri omu mikolo yinyu!» ");
INSERT INTO shr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraoni mwâmi w’e Mîsiri ederha, erhi: «Mwamabona oku olubaga lukola luluzire omu cihugo, b’obu mukolaga mwalonza mpu luleke emikolo!» ");
INSERT INTO shr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Olwo lusiku lwonênè, Faraoni mwâmi w’e Mîsiri arhegeka abarhambo n’abimangizi b’emikolo b’olubaga, erhi: ");
INSERT INTO shr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Murhacikâgihà olubaga ebyâsi by’okujira amadofali nk’oku mwakâgijira burhanzi. Bagendikalonza ebyâsi bône. ");
INSERT INTO shr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","“Mubasêze okujira amadofali gali nk’aga banayôrha bajira, murhanyihagya bici. Obwôlo bwabagazire, co cinarhumire badwîrhe bayâma, mpu: Rhugendirherekêra Nyamuzinda wîrhu!” ");
INSERT INTO shr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","“Abo bantu basezibwe okukola, lyo balek’ikâlakira ebinwa by’obunywesi!”» ");
INSERT INTO shr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Abarhambo n’abimangizi b’olubaga bahuluka, bajibwîra olubaga, mpu: «Ntya kwo Faraoni mwâmi w’e Mîsiri adesire: Ntakacimmuhà ebyâsi! ");
INSERT INTO shr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","“Mujikalonza ebyâsi mwene aha mwankanabibona! Ci ntâco ciru n’ehitya canyihibwa oku mukolo gwinyu.”» ");
INSERT INTO shr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Olubaga lwashandabana omu cihugo c’e Mîsiri mwoshi lwajà lwalonza ebyâsi by’empimbi. ");
INSERT INTO shr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Abarhambo bakazibarhunika, mpu: «Mukaziyusa emikolo yinyu! Mukâyunjuza ngasi lusiku olugero luhûnyirwe! Nk’oku mwanakâgijira amango mwagwêrhe ebyâsi!» ");
INSERT INTO shr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Abimangizi ba muli bene-Israheli, balya bàli barhumirwe n’abarhambo ba Faraoni mwâmi w’e Mîsiri, bakashurhwa, mpu: «Carhumaga murhayûsa, injo n’ene, ennundo yinyu y’amadofali nk’oku mwakâgijira burhanzi?» ");
INSERT INTO shr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Abimangizi ba muli bene-Israheli bagendilakira Faraoni mwâmi w’e Mîsiri, mpu: «Cirhumire wajirira bambali bâwe ntya?» ");
INSERT INTO shr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","«Bambali bâwe barhacihâbwa ebyâsi, bagalikarhubwîra, mpu: “Mujire amadofali! Bambali bâwe kukolaga kukâshurhwa kwône. Olubaga lwâwe lwo lubî!”» ");
INSERT INTO shr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Abashuza, erhi: «Muli bôlo, muli bôlo bwenêne! Co cirhumire mwakaziderha mpu: Rhujirherekêra Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","“Gendagi bwo na buno mujikola. Ebyâsi murhabihâbwe, ci amadofali munayora mujira go n’ago.”» ");
INSERT INTO shr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Abimangizi ba muli bene-Israheli bayumva bamagangânwa n’okwo babwîragwa, mpu: «Murhanyihyagya oku nnundo y’amadofali. Ngasi lusiku mukâjira erya nnundo enarhegesirwe.» ");
INSERT INTO shr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Oku banarhenga aha mwa Faraoni mwâmi w’e Mîsiri, bacibirindika kuli Mûsa na Aroni erhi badwîrhe babalinda. ");
INSERT INTO shr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Bababwîra, mpu: «Lêro Nyakasane yêne alolage analutwe: Faraoni mwâmi w’e Mîsiri na bambali bâge barhacikalonza barhulolekwo erhi mwe murhuma; yabirage ngôrho mwabafumbisire mpu barhunige.» ");
INSERT INTO shr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mûsa anacishubira emunda Nyakasane ali, aderha, erhi: «Mâshi, Yâgirwa, càrhumire warhindibuza olu lubaga? Bici wacintumiraga? ");
INSERT INTO shr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kurhenga amango najàga emwa Faraoni mwâmi w’e Mîsiri nti njimushambâza oku izîno lyâwe, arhangira okurhindibuza olu lubaga, orhanadesire mpu walîkûza olubaga lwâwe ciru n’ehitya!» ");
INSERT INTO shr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nyakasane abwîra Mûsa, erhi: «Lêro okolaga wabona oku najira Faraoni mwâmi w’e Mîsiri: abalîka bagende hano azidoherwa n’okuboko kudârhi, ciru abalibirhakwo yêne erhi kuboko kudârhi kurhuma!» ");
INSERT INTO shr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nyamuzinda ashubiderheza Mûsa, amubwîra, erhi: «Nie Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nabonekîre Abrahamu, Izaki na Yakôbo nka Nyamuzinda Ogala-byoshi, ci Izîno lyâni lya Nyamubâho ntalimayisagyâbo. ");
INSERT INTO shr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Kandi najira endagâno yâni rhwe nabo, oku nabahà ecihugo ca Kanâni, cihugo babungiragamwo banabêramwo nka babunga. ");
INSERT INTO shr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Lêro nayumvirhage omulenge gwa bene-Israheli, oku badwîrhe balibuzibwa n’Abanya-Mîsiri, nanakengire endagâno yâni. ");
INSERT INTO shr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Co cirhumire, obwîre bene-Israheli oku nie Nyamubâho. Nammukûla omu mikolo midârhi y’e Mîsiri, nammulikûza omu bujà bwâbo, nammulikûza n’obuhashe bw’okuboko kwâni n’omu buhane bunene. ");
INSERT INTO shr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nammuyankirira nka lubaga lwâni, nâni mbè Nyamuzinda winyu. Mwamanya oku nie Nyakasane, Nyamuzinda winyu, ommukûzire omu mikolo midârhi y’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nammuhisa omu cihugo nacigashaga nti nahà Abrahamu, Izaki na Yakôbo. Nammuhâco kashambala. Nie Nyamubâho!» ");
INSERT INTO shr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mûsa abwîra bene-Israheli ebyo binwa, ci barhayumvagya Mûsa erhi kutwîka omurhima n’obujà budârhi kurhuma. ");
INSERT INTO shr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Genda Obwîre Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri, aleke bene-Israheli barhenge omu cihugo câge!» ");
INSERT INTO shr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ci Mûsa aderha ntya embere za Nyakasane, erhi: «Obûla bene-Israheli barhanyumvagya, kurhigi Faraoni mwâmi w’e Mîsiri akabà ye nyumva nie w’akanwa karhakembûlagwa?» ");
INSERT INTO shr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nyakasane aganîza Mûsa na Aroni, abarhuma emwa bene-Israheli n’emwa Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri, mpu lyo alîka bene-Israheli barhenge omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Alaga abakulu b’emilala ya bashakulûza bâbo: Bagala ba Rubeni, nfula ya Israheli: Henoki na Palu, Hezroni na Karmi: obwo bwo bûko bwa Rubeni. ");
INSERT INTO shr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Nabo bagala ba Simoni, bo: Yemuweli, Yamini, Obadi, Yakini, Sohari na Saulu, mugala w’omukazi munya-Kanâni, bwo bûko bwa Simoni obwo. ");
INSERT INTO shr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Alaga amazîno ga bagala ba Levi, nk’oku amâburhwa gâbo ganali: Gershoni, Kehati na Merari. Levi alamire myâka igana na makumi asharhu na nda. ");
INSERT INTO shr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Bagala ba Gershoni bo: Livini na Shimeyi, nk’oku obûko bwâbo bunali. ");
INSERT INTO shr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Bagala ba Kehati bo: Amurami, Yisehari, Hebroni na Uziyeli. Kehati alamire myâka igana na makumi asharhu n’isharhu. ");
INSERT INTO shr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Na bagala ba Merari bo: Mahali na Mushi. Bwo bûko bwa Levi obwo omu kushimba amâburhwa gâbo. ");
INSERT INTO shr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amurami arhôla omukazi, ayanka nnashenge Yokevedi; amuburhakwo Aroni na Mûsa. Amurami alama myâka igana na makumi asharhu na nda. ");
INSERT INTO shr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Bagala ba Yisehari bo: Korè, Nefegi na Zikri. ");
INSERT INTO shr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Bagala ba Uziyeli bo: Mishaheli, Elisafani na Sitiri. ");
INSERT INTO shr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroni ayanka omukazi, ye Luzabeti, mwâli wa Aminadabu, mwâli wâbo Nashoni; amuburhakwo Nadabu, Abihu, Eleyazari na Itamara. ");
INSERT INTO shr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na bagala ba Korè bo: Asiri, Elikana na Abiyasafi. Obwo bwo bûko bwa bene-Korè. ");
INSERT INTO shr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyazari, mugala wa Aroni, ayanka omukazi, mwâli wa Putiyeli: omuburhakwo Pinasi. Abo bo bagula b’emilala y’Abaleviti, nk’oku obûko bwâbo bunali. ");
INSERT INTO shr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Bo baligi Aroni na Mûsa abo, balya Nyakasane abwîraga, erhi: «Murhenze bene-Israheli omu cihugo c’e Mîsiri, bacigabe nka mirhwe ya balwî.» ");
INSERT INTO shr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Bo bajagibwîra Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri, mpu arhenze bene-Israheli e Mîsiri. Bo Mûsa na Aroni abo. ");
INSERT INTO shr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Olusiku Nyakasane ashambâlaga na Mûsa omu cihugo c’e Mîsiri, ");
INSERT INTO shr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","amubwîra, erhi: «Nie Nyakasane. Obwîre Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri, ngasi byoshi nkubwîzire.» ");
INSERT INTO shr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mûsa ashuza Nyakasane, erhi: «Kurhi Faraoni mwâmi w’e Mîsiri akanyumva nie w’akanwa karhakembûlagwa?» ");
INSERT INTO shr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nyakasane anacibwîra Mûsa, erhi: «Kàli nkujizire nka Nyamuzinda wa Faraoni mwâmi w’e Mîsiri na mwene winyu Aroni ye wabà mulêbi wâwe. ");
INSERT INTO shr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","“We wakaziderha ngasi byoshi nakurhegeka, na mwene winyu Aroni abwîre Faraoni mwâmi w’e Mîsiri aleke Bene-Israheli barhenge omu cihugo câge”. ");
INSERT INTO shr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","“Ci kwône nadundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri. Naluza ebimanyîso n’ebirhangâzo omu cihugo c’e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","“Ci Faraoni mwâmi w’e Mîsiri arhammuyumve. Nalambûlira okuboko kwâni kuli Mîsiri, emirhwe yâni, lwo lubaga lwâni, bene-Israheli, nyirhenze n’obuhashe e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","“Abanya-Mîsiri bamanye obwo oku nie Nyakasane, hano ndambûlira okuboko kwâni oku Mîsiri, nnantenzamwo bene-Israheli”». ");
INSERT INTO shr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mûsa na Aroni bajira ntyo; bajira oku Nyakasane anali abarhegesire. ");
INSERT INTO shr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mûsa ali agwêrhe myâka makumi gali munâni, na Aroni makumi gali munâni n’isharhu, ago mango bajagiganiza Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nyakasane anacibwîra Mûsa na Aroni, erhi: ");
INSERT INTO shr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Faraoni mwâmi w’e Mîsiri akammubwîra, erhi: Jiragi ecirhangâzo, onabwîre Aroni, erhi: Rhôla akarhi kâwe, okakwêbe embere za Faraoni mwâmi w’e Mîsiri, kahinduke njoka!» ");
INSERT INTO shr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mûsa na Aroni bacibanda aha mwa Faraoni mwâmi w’e Mîsiri, bajira nk’oku Nyakasane ali abarhegesire. Aroni akweba akarhi kâge embere za Faraoni mwâmi w’e Mîsiri n’embere z’abambali, na kalya karhî kahinduka njoka. ");
INSERT INTO shr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ci oku bwâge, Faraoni mwâmi w’e Mîsiri naye ahamagala abagula n’abashonga bâge, abakurungu b’e Mîsiri bajira nabo okwo n’amakurungu gâbo. ");
INSERT INTO shr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ngasi muguma akazikweba akarhi kâge, kakazihinduka njoka. Ci akarhi ka Aroni kamirangusa rhulya rhurhi rhwâbo. ");
INSERT INTO shr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ci omurhima gwa Faraoni mwâmi w’e Mîsiri gwadundagula; arhayumvagya Mûsa na Aroni, nk’oku Nyakasane anaderhaga. Obuhanya burhanzi: ");
INSERT INTO shr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nyakasane anacibwîra Mûsa, erhi: «Faraoni mwâmi w’e Mîsiri azinzibîre; alâlîre mpu arhalika olubaga lugende. ");
INSERT INTO shr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","“Kanya emwa Faraoni mwâmi w’e Mîsiri irhondo bunacànûla, hano ahuluka mpu ajà ebwa lwîshi. Omulindire eburhambi bw’olwîshi. Na kalya karhî kahindukaga njoka, okafumbarhe omu nfune”. ");
INSERT INTO shr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","“Obwîre Faraoni mwâmi w’e Mîsiri, erhi: Nyakasane, Nyamuzinda w’Abayahudi, ambwiriga mpu nkubwîre, erhi: Leka olubaga lwâni lugende, lujinterekêra omu irungu”». Ci kuhika ene orhayumvagya. ");
INSERT INTO shr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ntya kwo Nyakasane adesire: «Eci co wamanyirakwo oku nie Nyakasane: Nkolaga nashurha amîshi g’olwîshi n’aka karhî nfumbasire omu nfune, gahinduke mukò. ");
INSERT INTO shr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","“Enfî z’omu lwîshi zafa, olwîshi lwakazibaya n’Abanyamîsiri bayabirwa okunywa amîshi g’omu lwîshi.”» ");
INSERT INTO shr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nyakasane abwîra Mûsa, erhi: «Bwîra Aroni, erhi: Rhôla akarhi kâwe, olambûlire okuboko oku mîshi g’omu Mîsiri, oku nyîshi zamwo, oku mibunda yamwo, oku biyanja byamwo, ngasi hoshi hanabà amîshi, gahinduke mukò! Omukò gubè omu cihugo coshi c’e Mîsiri, omu rhubehe rhwemirhi n’omu rhubehe rhw’amabuye!» ");
INSERT INTO shr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mûsa na Aroni banacijira nk’oku Nyakasane anabarhegekaga. Aroni alengeza akarhi, akarhimba oku mîshi g’omu lwîshi embere z’amasù ga Faraoni mwâmi w’e Mîsiri n’embere z’amasù g’abambali. Amîshi g’omu lwîshi goshi gahinduka mukò. ");
INSERT INTO shr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Enfî z’omu lwîshi zoshi zafà, olwîshi lwakazibaya kuhika Abanya- Mîsiri bayabirwa n’okunywa amîshi ga mw’olwo lwîshi. Ecihugo c’e Mîsiri coshi cayunjula mukò. ");
INSERT INTO shr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ci abakurungu b’e Mîsiri nabo bajira ntyo n’amakurungu gâbo. Omurhima gwa Faraoni mwâmi w’e Mîsiri gwadundagula, arhayumvagya Mûsa na Aroni, nka kulya Nyakasane anaderhaga. ");
INSERT INTO shr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraoni mwâmi w’e Mîsiri ahindamuka, acîshubirira emwâge buzira kutwa ihuzihuzi kw’ebyo byoshi. ");
INSERT INTO shr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Abanya-Mîsiri boshi bakazijà bahumba eburhambi bw’olwîshi mpu babone amîshi banywe, bulya barhankacihashirinywa amîshi g’omu lwîshi. ");
INSERT INTO shr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nsiku nda zoshi zagera kurhenga ago mango Nyakasane ahânaga olwîshi. ");
INSERT INTO shr_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Nyakasane anacibwîra Mûsa, erhi: «Ojè aha mwa Faraoni mwâmi w’e Mîsiri, omubwîre, erhi: Ntya kwo Nyakasane adesire: Leka olubaga lwâni lugende, luj’inkolera. ");
INSERT INTO shr_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","“Okalahira mpu lurhagenda, nahana ecihugo câwe coshi n’obuhanya bw’ebikere”. ");
INSERT INTO shr_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","“Olwîshi lwayunjulira bikere, byarherema, bishesherere omu mwâwe, bije omu nyumpa olala, oku ncingo yâwe, omu nyumpa za bambali bâwe, omu mw’olubaga lwâwe, omu matanuru gâwe, omu nyîna zâwe”. ");
INSERT INTO shr_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","“Ebyo bikere byakàkucanukirakwo wêne, oku lubaga lwâwe na kuli bambali bâwe.”» ");
INSERT INTO shr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nyakasane anacibwîra Mûsa, erhi: «Bwîra Aroni, erhi: Lambûlira okuboko na kalya karhî kâwe oku nyîshi, oku mibunda n’oku biyanja, oyinamulire ebikere omu cihugo c’e Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aroni àlambûlira okuboko oku mîshi goshi g’e Mîsiri: ebikere byayulubuka, byarherema, byàfûnika ecihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ci abakurungu nabo bajira ntyo n’amakurungu gâbo: bayûlubulira ebikere omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Faraoni mwâmi w’e Mîsiri anacihamagala Mûsa na Aroni, aderha, erhi: «Mushenge Nyakasane anyegûlekwo ebi bikere n’oku lubaga lwâni, lyo ndeka olubaga luj’ihêra Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mûsa abwîra Faraoni mwâmi w’e Mîsiri, erhi: «Ombwîre mangaci go na nênè nagend’ikusengerera, omu nyumpa zâwe, bisigale omu lwîshi mwône.» ");
INSERT INTO shr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aderha, erhi: «Irhondo.» Mûsa àmushubiza, erhi: «Najira nk’okwo onadesire: Lyo omanya oku ntà wundi oli aka Nyakasane, Nyamuzinda wîrhu, ");
INSERT INTO shr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ebikere byaciyegûla kuli we, oku nyumpa yâwe, kuli bambali bâwe n’oku lubaga lwâwe, birhasigale omurhali omu lwîshi mwône.» ");
INSERT INTO shr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mûsa na Aroni banacirhenga ahamwa Faraoni mwâmi w’e Mîsiri. Mûsa àj’isengera Nyakasane kuli ebyo bikere àlibuzagyamwo Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nyakasane ayumvîrhiza omusengero gwa Mûsa. Ebikere byàli omu nyumpa, ebyàli omu ngo n’omu mashwa byàfà, byahirigirha. ");
INSERT INTO shr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Bàbilundika birundo-birundo, ecihugo coshi cayunjula kabayo. ");
INSERT INTO shr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Faraoni mwâmi w’e Mîsiri erhi abona amàbà nk’aluhûka, ashub’izinzibala, àrhaciyumvagya Mûsa na Aroni, nk’oku Nyakasane anaderhaga. ");
INSERT INTO shr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Nyakasane anacibwîra Mûsa, erhi: «Obwîre Aroni, erhi: Lambûla akarhi kâwe, oshûrhe akatulo k’oku idaho, kahinduke mihusha omu cihugo c’e Mîsiri mwoshi.» ");
INSERT INTO shr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Bàkujira, Aroni alambûla akarhi kâge, akarhimba omu katulo k’oku idaho. Emihusha yalumîra oku bantu n’oku bîntu. Akatulo koshi k’oku idaho kahinduka mihusha omu cihugo coshi c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Abakurungu banacirhangula nabo n’amakurungu gâbo mpu bahiva eyo mihusha, ci bayabirwa. Emihusha yayunjula oku bantu n’oku bîntu. ");
INSERT INTO shr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Balya bakurungu bàbwîra Faraoni mwâmi w’e Mîsiri, mpu: «Gwamabà munwe gwa Nyamuzinda ogu». Ci omurhima gwa Faraoni mwâmi w’e Mîsiri gwadundaguza. Arhayumvagya Mûsa na Aroni nka kulya Nyakasane anaderhaga. ");
INSERT INTO shr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nyakasane abwîra Mûsa, erhi: «Ozûke sêzi sêzi, ocibande embere za Faraoni mwâmi w’e Mîsiri, hano akola mpu ajà ebwa lwîshi. Omubwîre, erhi: Ntya kwo Nyakasane adesire: Leka olubaga lwâni lugende, luj’inkolera.» ");
INSERT INTO shr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","«Akabà orhalesiri olubaga lwâni lugende, narhuma emihusha kuli we, kuli bambali bâwe, oku lubaga lwâwe n’omu nyumpa zâwe. Enyumpa z’Abanya-Mîsiri zoshi zàyunjula bibugu, ciru n’obudaka bayubakakwo. ");
INSERT INTO shr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","“Olwo lusiku najirira ecihugo ca Gosheni kundi kundi, era munda olubaga lwâni luyûbaka; eyo munda yône erhâbe mihusha, lyo omanya oku nie Nyakasane, mbà omu karhî k’ecihugo”. ");
INSERT INTO shr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","“Naberûla olubaga lwâni n’olwâwe. Eco cimanyîso irhondo càbà.”» ");
INSERT INTO shr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nyakasane anacijira ntyo. Ehitù hy’ebibungu hyanacija omu nyumpa ya Faraoni mwâmi w’e Mîsiri, n’omu nyumpa z’abambali n’omu cihugo coshi; ecihugo coshi cayunjula bibungu. ");
INSERT INTO shr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Faraoni mwâmi w’e Mîsiri ahamagala Mûsa na Aroni, ababwîra, erhi: «Gendi, muhêrere Nyamuzinda winyu muno cihugo.» ");
INSERT INTO shr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mûsa àmushuza, erhi: «Kurhakwânîni okujira ntyo, bulya ebi rhurherekêra Nyakasane, Nyamuzinda wîrhu, Abanya-Mîsiri barhabikwirirwa. Kurhigi rhwankabijirira omu masù gâbo babule kurhubanda amabuye? ");
INSERT INTO shr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","“Ha lugendo lwa nsiku isharhu omu irungu ho rhulonzize okuj’irherekêrera Nyakasane, Nyamuzinda wîrhu, nk’oku ankanarhubwîra.”» ");
INSERT INTO shr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Faraoni mwâmi w’e Mîsiri ashuza, erhi: «Nammuleka, mugende munarherekêrere Nyakasane, Nyamuzinda winyu omu irungu. Kwônene murhajaga kuli: Munsengerere nâni.» ");
INSERT INTO shr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mûsa aderha, erhi: «Kwokwo, nkolaga narhenga hano mwâwe, nj’ishenga Nyakasane, n’irhondo lyonêne ebibugu byarhenga kuli Faraoni mwâmi w’e Mîsiri, kuli bambali bâge n’oku lubaga lwâge. Ci kwône lêro Faraoni mwâmi w’e Mîsiri aleke okurhurheba mpu kandi arhâleka olubaga lugend’irherekêra Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mûsa àrhenga aha mwa Faraoni mwâmi w’e Mîsiri, àj’ishenga Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nyakasane ayumvîrhiza omusengero gwa Mûsa. Ebibugu byàrhengakwo Faraoni mwâmi w’e Mîsiri, oku bambali n’oku lubaga lwâge. Harhasigalaga ciru n’eciguma. ");
INSERT INTO shr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ci kwône kandi obwo, Faraoni mwâmi w’e Mîsiri azînzibala, arhalekaga olubaga mpu lugende. ");
INSERT INTO shr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nyakasane anacibwîra Mûsa, erhi: «Genda, ojè emwa Faraoni mwâmi w’e Mîsiri, omubwîre, erhi: Ntya kwo adesire Nyakasane, Nyamuzinda w’Abayahudi: Leka olubaga lwâni lugende, luj’inkolera. ");
INSERT INTO shr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","“Okashub’ilahira mpu orhalulîka, okashub’iluhanza”, ");
INSERT INTO shr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","“okuboko kwa Nyakasane kwarhinda oku masô gali omu mashwa gâwe, oku biterusi, oku bihêsi, oku ngamiya, oku nkâfu n’ebibuzi: àbà mulyamo mukali bwenêne”. ");
INSERT INTO shr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","“Nyakasane àhira olubibi omu masô ga bene-Israheli n’ag’Abanya-Mîsiri. Ntà cintu càfà omu masô ga bene-Israheli.”» ");
INSERT INTO shr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nyakasane anacitwa amango, erhi: «Irhondo Nyakasane akola ebyo omu cihugo.» ");
INSERT INTO shr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","N’erhi buca, Nyakasane, akola ako kanwa: amasò g’Abanya-Mîsiri goshi gafa, ci omu masô ga bene-Israheli, ntà cintu ciru n’eciguma càfire. ");
INSERT INTO shr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraoni mwâmi w’e Mîsiri arhuma abajidôsa: «Ntà cintu ciru n’eciguma cafire omu masô ga bene-Israheli.» Ci kurharhumaga omurhima gwa Faraoni mwâmi w’e Mîsiri gurhadundagula; arhalekaga olubaga mpu lugende. ");
INSERT INTO shr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Nyakasane abwîra Mûsa na Aroni, erhi: «Murhôle bifune bibiri bya muyeye gw’omu itanuru. Mûsa ayish’iguyehûlira e malunga omu masù ga Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Hano akatulo kagwo kashandâla omu Mîsiri mwoshi, kanaja kameza emibuha eri nka mahurhe oku bantu n’oku bintu by’omu Mîsiri mwoshi.» ");
INSERT INTO shr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Bàrhôla omuyeye gw’omu itanuru, bàguyimangana embere za Faraoni mwâmi w’e Mîsiri. Mûsa àgukwêba e malunga, gwâja gwameza emibuha y’amahurhe oku bantu n’oku bintu. ");
INSERT INTO shr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Abakurungu bayabirwa okubêra embere za Mûsa erhi ago mahurhe garhuma, bulya abakurungu n’Abanya-Mîsiri boshi bàli bayunjwîre mahurhe. ");
INSERT INTO shr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ci Nyakasane àdundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri, arhayumvagya Mûsa na Aroni nk’oku Nyakasane anali abwîzire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nyakasane anacibwîra Mûsa, erhi: «Ozûke mucêracêra, ocibande embere za Faraoni mwâmi w’e Mîsiri. Omubwîre, erhi: Ntya kwo Nyakasane, Nyamuzinda w’Abayahudi adesire: “Lîka olubaga lwâni lugende, luj’inkolera.”» ");
INSERT INTO shr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Bulya lêro nkola narhuma amahanya gâni goshi kuli we, kuli bambali bâwe n’oku lubaga lwâwe lyo omanya oku ntâye oli akâni omu igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ncilekêrerage okuboko kwâni, singa nakuyisire n’ecâhirà we n’olubaga lwâwe, wali wahirigirha omu igulu. ");
INSERT INTO shr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ci alaga ecàrhumire nakuleka: nti nkuyêreke obuhashe bwâni lyo bamanyîsa izîno lyâni omu igulu lyoshi. ");
INSERT INTO shr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Woyo ocidwîrhe wahanza olubaga lwâni mpu lurhagendaga. ");
INSERT INTO shr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Irhondo nka gano mango gonênè naniesa olubula, ludârhi bwenêne, lulya lurhasâg’ibonekana omu Mîsiri kurhenga olusiku àyûbakagwa kuhika buno. ");
INSERT INTO shr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Okanyagye, orhume abaj’iyegemya amasò gâwe na ngasi hyâwe byoshi hiri ebulambo. Ngasi muntu na ngasi cintu biri ebulambo barhayegamizi n’okubihira omu nyumpa, olubula lwabikomanga bife. ");
INSERT INTO shr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Muli bambali ba Faraoni mwâmi w’e Mîsiri, ngasi warhînyire akanwa ka Nyakasane, àyegamya bambali bâge n’amasò; ");
INSERT INTO shr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ci orhàshibiriraga akanwa ka Nyakasane, àlekera abambali n’amasò gâge ebulambo. ");
INSERT INTO shr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Nyakasane abwîra Mûsa, erhi: «Lambûlira okuboko kwâwe emalunga olubula lunie omu cihugo c’e Mîsiri mwoshi, oku bantu n’oku bintu, na kuli ngasi hyasi hyoshi hy’omu cihugo c’e Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mûsa àlambûlira akarhi kâge emalunga; Nyakasane alulumbikanyayo emikungulo n’olubula; emilazô yacibanda oku idaho, na Nyakasane aniesa olubula omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Olubula, emilazô eyunjwîre lubula: byàbà bidârhi bwenêne kulya ecihugo c’e Mîsiri cirhâlisag’ibona bundi kurhenga ciri ishanja. ");
INSERT INTO shr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Omwo cihugo c’e Mîsiri mwoshi, olubula lwajonjaga ngasi byânali embuga, abantu n’ebintu; olubula lwajonjaga ngasi hyasi hy’erubala, lwavunanga n’emirhi y’erubala yoshi. ");
INSERT INTO shr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Cihugo ca Gosheni cône olubula lurhahumagakwo, emunda bene-Israheli bâyubakaga. ");
INSERT INTO shr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraoni mwâmi w’e Mîsiri ahamagala Mûsa na Aroni, ababwîra, erhi: «Lêro, nabwinage oku nabîhire; Nyakasane ye mushinganyanya, nie mubî rhwe n’olubaga lwâni. ");
INSERT INTO shr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","“Mushenge Nyakasane ayimanze emilazô n’olubula: Nammulîka mugende, murhâcilegerere kasanzi kanene.”» ");
INSERT INTO shr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mûsa àmushuza, erhi: «Hano nantenga muno lugo, nagend’iyinamulira amaboko gâni emunda Nyakasane ali: emilazô yahuba, n’olubula lurhâcinie, lyo omanya oku igulu lyoshi liri lya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","“Ci wêhe mwe na bambali bâwe, mmumanyire oku murhacirhînya Nyakasane Nyamuzinda.”» ");
INSERT INTO shr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ecitâni n’engano byàtuntumalika, bulya engano yali ekola egwêrhe emihuli, n’ecitâni erhi cayâsa. ");
INSERT INTO shr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Engano ejira emigati n’amahemba, byôhe birhatuntumalikaga, bulya birhamera duba. ");
INSERT INTO shr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mûsa arhenga aha mwa Faraoni mwâmi w’e Mîsiri n’omu lugo, àyinamulira amaboko gâge emunda Nyakasane ali; emilazô n’olubula byahumba, enkuba erhàcidubukiraga oku idaho. ");
INSERT INTO shr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Erhi Faraoni mwâmi w’e Mîsiri abona oku enkuba, olubula n’emilazô byahumbire, ashub’ibîha, ye bo n’abambali bàzinzibala. ");
INSERT INTO shr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Omurhima gwa Faraoni mwâmi w’e Mîsiri gwazibuha nk’ibuye, arhàlikaga bene-Israheli, nk’oku Nyakasane anali abwîzire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nyakasane anacibwîra Mûsa, erhi: «Genda, ojè emwa Faraoni mwâmi w’e Mîsiri, bulya nie nazînzibazize omurhima gwâge n’ogwa bambali bâge, lyo nyukîriza ebirhangâzo byâni ekarhî kâbo, ");
INSERT INTO shr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","lyo oyîsh’ikuganîrira mugala wâwe na mwinjikulu wâwe na kurhi nalibuzagya Abanya-Mîsiri na kurhi najiraga ebirhangâzo byâni emwâbo. Ntyo mwanamanya oku niene nie Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mûsa na Aroni banacijà aha mwa Faraoni mwâmi w’e Mîsiri, bàmubwîra, mpu: «Ntya kwo Nyakasane, Nyamuzinda w’Abayahudi adesire: Kuhika mangaci walahira okucîrhohya embere zâni? Lîka olubaga lwâni lugende, luj’inkolera. ");
INSERT INTO shr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","“Okalahira mpu orhalika olubaga lwâni lugende, irhondo lyonêne narhuma enzige omu cihugo câwe”. ");
INSERT INTO shr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","“Zabwika ecihugo coshi ciru cirhâcibonekaga. Zâlya ngasi hyoshi hyàrhulubusire, ngasi ebi olubula lwakulekire, zâlya emirhi emera omu mashwa gâwe yoshi”. ");
INSERT INTO shr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","“Zabumba enyumpa zâwe, n’enyumpa za bambali bâwe boshi, n’enyumpa z’Abanya-Mîsiri boshi: okwo basho barhakubonaga ciru na bashakulûza binyu kurhenga bali hano igulu kuhika olw’ene.”» Mûsa ahindamuka, arhenga aha mwa Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Abarhumisi ba Faraoni mwâmi w’e Mîsiri bàmubwîra, mpu: «Kuhika mangaci oyu muntu ayôrha ali karhegè kuli rhwe? Lîka abà bantu, bagende, baj’ikolera Nyakasane, Nyamuzinda wâbo. K’orhacimanya oku Mîsiri akola ahwire?» ");
INSERT INTO shr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bashub’igalula Mûsa na Aroni emwa Faraoni mwâmi w’e Mîsiri, ababwîra, erhi: «Gendagi. Muj’ikolera Nyakasane, Nyamuzinda winyu. Ci kwône, ndi wagenda?» ");
INSERT INTO shr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mûsa ashuza, erhi: «Rhwagenda haguma n’abâna bîrhu n’abashosi bîrhu, rhwagenda haguma na bagala bîrhu na bali bîrhu, ebibuzi-bîrhu n’enkafu zîrhu. Bulya kuli rhwe luli lusiku lukulu lw’okukuza Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ababwîra, erhi: «Nyakasane abè haguma ninyu mukabona namuleka mwagenda n’abâna binyu: mubwîne oku bubî obu mwalonza. ");
INSERT INTO shr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Arhali ntyo kwo byabà: gendi, mwe balume, muj’ikolera Nyakasane, bulya ntyo kwo mwalonza.» Banacibalibirhakwo mpu barhenge aha mwa Faraoni mwâmi w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nyakasane abwîra Mûsa, erhi: «Lambûlira okuboko oku cihugo c’e Mîsiri, ohamagale enzige: ziyerêre enyanya ly’ecihugo ca Mîsiri: zirye ngasi hyasi hy’omu cihugo, ngasi hyoshi olubula lwasizire.» ");
INSERT INTO shr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mûsa ashonga ecihugo c’e Mîsiri akarhi kâge. Nyamuzinda azûsa empûsi ebuzûka-zûba oku cihugo c’e Mîsiri yalegerera yanalala yahûsa. Erhi buca sêzi bashanga empûsi y’ebuzûka-zûba yagwisize enzige. ");
INSERT INTO shr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Enzige zalumîra omu cihugo c’e Mîsiri coshi, zàgwa nyinjinyinji omu cihugo c’e Mîsiri coshi. Ntà mango enzige nyinganaho zalisagigwa bundi na ntà mango eziri nk’ezo zacigwîre. ");
INSERT INTO shr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Zashandâla ecihugo coshi, zayôna ecihugo coshi. Zalya ngasi hyasi hyàli omu cihugo na ngasi ilehe olubula lwasigaga: ntà hyasi hyasigîre oku mirhi erhi omu mashwa omu cihugo ca Mîsiri coshi. ");
INSERT INTO shr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraoni mwâmi w’e Mîsiri burharhindira, ahamagala Mûsa na Aroni ababwîra erhi: «Nabîhire Nyakasane Nyamuzinda winyu na ninyu mwene. ");
INSERT INTO shr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ombabalirage ecâha câni we kasinga buno lyône, munansengerere emwa Nyakasane Nyamuzinda winyu ankulekwo obûla buhanya budârhi». ");
INSERT INTO shr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mûsa arhenga emwa Faraoni mwâmi w’e Mîsiri anashenga Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nyamuzinda ahindula erya mpûsi yabà y’ebuzika-zûba, mpûsi nyinji-nyinji, yazurundukana enzige yanazihêka ebwa Nyanja Ndukula. Harhasigalaga ciru n’oluzige luguma omu cihugo ca Mîsiri coshi. ");
INSERT INTO shr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nyamuzinda àdundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri, arhalekaga bene-Israheli bagenda. ");
INSERT INTO shr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Nyakasane abwîra Mûsa, erhi: «Lambûlira okuboko kwâwe omu malunga na ntyo omwizimya gw’okunali guhundikire ecihugo ca Mîsiri». ");
INSERT INTO shr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mûsa anacilambûlira okuboko kwâge enyanya, hanacizûka endunduli y’omwizimya, yahundikira ecihugo ca Mîsiri nsiku isharhu zoshi. ");
INSERT INTO shr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ntà muntu wacikazâgibona owâbo na ntâye wacirhenzire ah’àli ezo nsiku isharhu zoshi. Cikwône Bene-Israheli bôhe erhi bagwêrhe obulangashane aha mwabâbwe. ");
INSERT INTO shr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Faraoni mwâmi w’e Mîsiri ahamagala Mûsa, amubwîra, erhi: «Mugendirherekêra Nyamubâho cikwône ebishwêkwa bisungunu n’ebinene byoshi birharhengaga hano. Cikwoki mwanagenda baguma na bakinywi n’abâna binyu.» ");
INSERT INTO shr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mûsa ashuza, erhi: «Wêne orhuhâge ebi rhwajijiriramwo Nyakasane Nyamuzinda wîrhu enterekêro nsingônola. ");
INSERT INTO shr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ciru rhwakahêka n’amasò gîrhu, ntà cishwêkwa ciru n’eciguma casigala, bulya byo rhwajirhôlamwo ebi rhwarherekêra Nyakasane Nyamuzinda wîrhu; hano rhuhika eyo munda rhwêne buzira byo, rhurhankayîsh’ihash’irherekêra Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Cikwône Nyamuzinda azinzibaza omurhima gwa Faraoni mwâmi w’e Mîsiri: arhabalîkuzagya mpu bagende. ");
INSERT INTO shr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faraoni mwâmi w’e Mîsiri anacibwîra Mûsa, erhi: «Rhenga aho jonacilange! Ntacikubonaga omu masù gâni n’olusiku washub’icîshomya mpu wacîyêrekana omu masù gâni, onafe.» ");
INSERT INTO shr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mûsa aderha, erhi: «Wakudesire, ntakacicîshomya nti nacîyêrekana omu masù gâwe.» ");
INSERT INTO shr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nyakasane anacibwîra Mûsa, erhi: «Nkolaga narhumira Faraoni mwâmi w’e Mîsiri na Mîsiri obuhanya buzinda. Enyuma ly’aho, ammuleka mugende na ciru kwâbà kulibirha ammulibirhakwo. ");
INSERT INTO shr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Obwirage olubaga luje lwahûna: ngasi mulume ahûne omulungu wâge na ngasi mukazi ahûne omulungu-kazi wâge, ebirugu by’amarhale n’ebya amasholo.» ");
INSERT INTO shr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Nyakasane arhabâla olubaga okurhona emwa Abanya-Mîsiri. Na kulusha, Mûsa yêne ali muntu mukulu bwenêne omu cihugo c’e Mîsiri, omu masù ga bambali ba Faraoni mwâmi w’e Mîsiri n’omu masù g’olubaga. ");
INSERT INTO shr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mûsa anaciderha, erhi: «Ntya kwo Nyakasane adesire: Aha karhî k’obudufu, natwikanya omu Mîsiri, ");
INSERT INTO shr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","“ngasi lubere lw’omu Mîsiri lwâfà, kurhangirira oku nfula ya Faraoni mwâmi w’e Mîsiri, olya wayîsh’iyîma oku ntebe yâge y’obwâmi, kuhika oku lubere lw’omujà-kazi ôbà enyuma z’olwanjikwa na kuhika oku lubere lwa ngasi cintu”. ");
INSERT INTO shr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","“Endûlù zâbà omu cihugo c’e Mîsiri mwoshi, zirya zirhasâg’iyumvikanamwo ciru n’eliguma, zirhakanac’iyumvikanamwo bundi”. ");
INSERT INTO shr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","“Ci emwa Bene-Israheli boshi, ciru n’akabwa ntâko kamokera abantu erhi ebintu, lyo mumanya oku Nyakasane abà aberwîre Mîsiri na Israheli”. ");
INSERT INTO shr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","“Okuhandi, abà bambali bâwe boshi bayandagalîre emunda ndi, bananfukamire, mpu: Gendaga mâshi, mwe n’olubaga lukukulikîre. Okuhandi nanagenda obwo.”» ");
INSERT INTO shr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Nyakasane abwîra Mûsa, erhi: «Faraoni mwâmi w’e Mîsiri arhakuyumve mpu lyo ebirhangâzo byâni biluga omu Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ebyo birhangâzo byoshi Mûsa na Aroni bàli bajirîre embere za Faraoni mwâmi w’e Mîsiri, ci Nyakasane àdundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri, àrhazigaga mpu bene-Israheli barhenge omu cihugo câge. ");
INSERT INTO shr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nyakasane anacibwîra Mûsa na Aroni omu cihugo c’e Mîsiri, erhi: ");
INSERT INTO shr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Kuli mwe, ogu mwêzi gwo gwabà murhanzi gw’emyêzi yoshi, gwo gwabà murhanzi gw’omwâka. ");
INSERT INTO shr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","“Muhamagale Bene-Israheli boshi, mubabwîre, mpu: Omu nsiku ikumi za guno mwêzi, ngasi baguma omu nyumpa barhôle omwâna-buzi”. ");
INSERT INTO shr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","“Abankabona bali banyi omu nyumpa b’okuyusa omwâna-buzi, bamulye haguma n’abalungu babali hôfi, nka kulya abantu banali. Mucîshoge oyo mwâna-buzi omu lugero lwa ngasi muguma lw’okulya”. ");
INSERT INTO shr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","“Abè mwâna-buzi orhalikwo izâbyo, ciganda-buzi ca mwâka muguma. Murhôle omu bâna-buzi erhi omu bâna-hene”. ");
INSERT INTO shr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Mumubike kuhika olusiku lwa kali ikumi na kani lwa guno mwêzi. Bene-Israheli boshi bayishimubâga aha karhî k’ebijingo byombi”. ");
INSERT INTO shr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","“Bayish’iyanka oku mukò gwâge: bahembe ebizimbêro byombi n’omulungulungu gw’enyumpa bâlîramwo”. ");
INSERT INTO shr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“Mw’obwo budufu balya enyama yâge. Bayirya nyôce, haguma n’emigati erhalimwo lwango n’enshogo ndulu”. ");
INSERT INTO shr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","“Ntâco mumulyagekwo cibishi erhi ciyende, ci biyôce byône, haguma n’irhwe n’amagulu n’eby’omu nda”. ");
INSERT INTO shr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","“Ntâco musizagyakwo kuhika sêzi; erhi hankabà ebisigîre sêzi munabidûlike muliro”. ");
INSERT INTO shr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Mumulye ntya: mushwêkere omukaba omu cibunu, muhire enkwêrho emagulu, munafumbarhe akarhi omu nfune. Mumulye bulibirhà. Oyo ye Basâka wa Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mw’obwo budufu nâgera omu cihugo c’e Mîsiri, njè nanigûza ngasi lubere lw’omu Mîsiri, lubè lwa muntu erhi lwa cintu. Nafendûla banyamuzinda b’obwîhambe b’omu Mîsiri boshi. Nie Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","“Omukò gwabà cimanyîso c’enyumpa mulimwo: nayîsh’ibona omukò, mmurhalukire, n’obuhanya burhâmujekwo hano nkola nâshûrha ecihugo c’e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Olwo lusiku mulujire lwa kukengêrwa, lubè lusiku lukulu lwa Nyakasane. Kurhenga oku iburha kuhika oku lindi, mulujire lubè luzira lw’ensiku n’amango.”» ");
INSERT INTO shr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«“Mushinge nsiku nda zoshi mwalya emigati erhalimwo lwango. Kurhangirira oku lusiku lurhanzi, murhenze ngasi lwango omu nyumpa zinyu. Ngasi yêshi wanalye omugati gulimwo olwango kurhenga oku lusiku lurhanzi kuhika oku lwa kali nda, oyo akagwe muli Bene-Israheli”. ");
INSERT INTO shr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","“Omu lusiku lurhanzi, mukâjira endêko ntagatîfu. Omu lusiku lwa kali nda, kwo na kuguma. Mw’ezo nsiku ntâye wahumaga akabishi, ci mukâkola ebi mwâlya byône”. ");
INSERT INTO shr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mukâjira bwinjà olusiku lukulu lw’emigati erhalimwo olwango, bulya mw’olwo lusiku, lwo narhenzagyamwo emirhwe yinyu omu cihugo c’e Mîsiri. Mukâjira olwo lusiku kurhenga oku iburha kuhika oku lindi, liri irhegeko ly’ensiku n’amango”. ");
INSERT INTO shr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","“Omu mwêzi murhanzi, bijingo, mukaz’irya emigati erhalimwo lwango kuhika bijingo by’olusiku lwa kali makumi abiri na luguma lw’omwêzi”. ");
INSERT INTO shr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","“Nsiku nda zoshi olwango lurhabonekanaga omu nyumpa zinyu. Na ngasi yêshi wankalya omugati gulimwo olwango, abè cigolo erhi muburhwa w’omu cihugo, oyo anakagwe omu mulungano gwa Bene-Israheli”. ");
INSERT INTO shr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","“Murhahîraga mukalya akantu kalimwo olwango.”» ");
INSERT INTO shr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mûsa anacihamagala abagula b’Israheli boshi, ababwîra, erhi: «“Mujè omu bintu binyu, murhôlere emilala yinyu omwâna-buzi, mubâgire Basâka”. ");
INSERT INTO shr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","“Muyîsh’irhôla ebikângûlo by’ebyâsi, mubivûmvuze omu mukò guli omu mbêhe, mushahulize oku mulungulungu n’oku bizimbêro byombi, na ntâye watwâga olusò lw’enyumpa yâge kuhika sêzi”. ");
INSERT INTO shr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","“Nyakasane àrhulukâna omu Mîsiri, àja anigûza, âyîsh’ibona omukò oku mulungulungu n’oku bizimbêro byombi. Obwo, Nyakasane âgera aha mwinyu arhanazige Kaheza ajà omu nyumpa zinyu mpu ayîrhe”. ");
INSERT INTO shr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Okwo kwoshi mukubîkirire: liri irhegeko kuli mwe n’oku bâna binyu ensiku zoshi”. ");
INSERT INTO shr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","“Amango mwâhike omu cihugo Nyakasane âmmuhà nk’oku anaderhaga, munakengêre eco cijiro”. ");
INSERT INTO shr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","“Amango abâna binyu bâmudôsa”, mpu: “Co cijiro cici eci mukâjira?” ");
INSERT INTO shr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","“Munabashuze”, erhi: “Eri nterekêro ya Basâka, ya Nyakasane, ye wacizagya enyumpa za bene-Israheli e Mîsiri, amango àmalîraga Mîsiri anafungira enyumpa zîrhu.”» Olubaga lwafukama, lwaharâmya. ");
INSERT INTO shr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Bene-Israheli bàgenda, bajira nk’oku Nyakasane àrhegekaga Mûsa na Aroni; ntyo kwo bajizire. ");
INSERT INTO shr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Aha karhî k’obudufu, Nyakasane ànigûza ngasi lubere omu cihugo c’e Mîsiri, kurhangirira oku nfula ya Faraoni mwâmi w’e Mîsiri yànkayîmire oku ntebe yâge, kuhika oku nfula y’omujà oli omu mpamikwa, ngasi lubere lw’ebintu. ");
INSERT INTO shr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faraoni mwâmi w’e Mîsiri àzûka mw’obwo budufu, n’abambali bâge n’Abanya-Mîsiri boshi; omu Mîsiri mwazûka ecihôgêro cinene, bulya ntà nyumpa erhàliwo mufù. ");
INSERT INTO shr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mw’obwo budufu, Faraoni mwâmi w’e Mîsiri ahamagala Mûsa na Aroni, ababwîra, erhi: «Zûki! Murhenge ekarhî k’olubaga lwâni, mwe na bene-Israheli. Mugende, muj’ikolera Nyakasane nk’oku mwanaderhaga. ");
INSERT INTO shr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","N’ebibuzi binyu n’enkafu zinyu, mubihêke nka kulya mwanaderhaga. Mugende, munansengerere omugisho nâni!» ");
INSERT INTO shr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Abanya-Mîsiri bàrhunika olubaga mpu lurhenge duba omu cihugo, bulya bakâg’iderha mpu: «Rhwahwa rhweshi!» ");
INSERT INTO shr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Olubaga lwajà lwahêka emigati erhàlicibumbugurha, bàshana enyungu yalimwo omu birondo byâbo, bàyibarhula oku birhugo. ");
INSERT INTO shr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Bene-Israheli bajira nk’oku Mûsa ababwîraga: bàli bahûnyire Abanya-Mîsiri ebirugu by’amarhale, ebirugu by’amasholo n’emyambalo. ");
INSERT INTO shr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nyakasane erhi abarhabîre okurhona emwa Abanya-Mîsiri, bayêmêra okubahà ngasi ebi bàbahûnaga. Ntyo banyaga Abanya-Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Bene-Israheli bàgenda kurhenga e Ramusesi kuhika e Sukoti, hôfi bihumbi magana gali ndarhu bya bagenzi b’amagulu, balume buzira kuganja abâna. ");
INSERT INTO shr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Engabo erhali nyi y’abantu ba ngasi lubero yagenzikanwa nabo, n’amasò manji g’enkafu n’ebibuzi. ");
INSERT INTO shr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Erya migati erhàlicibumbugurha bàkûlaga e Mîsiri, bàyikalanga, yàbà bitumbura birhalimwo olwango bulya enshâno erhàlicibumbugurha. Barhalindaga babona amango g’okuhêka olwîko, bulya kulibirhwa bàlibisirwekwo e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Emyâka yoshi Bene-Israheli bâgezize omu Mîsiri yali magana anni na makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","N’erhi eyo myâka magana anni na makumi asharhu egera, olwo lusiku lwonênè, engabo za Nyakasane zoshi zarhenga e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Obwo budufu, Nyakasane àyiza mpu lyo abarhenza e Mîsiri. Obwo budufu bubà bwa Nyakasane, buli bwa kuyiza-kuli Bene-Israheli, kurhenga iburha kuhika oku lindi. ");
INSERT INTO shr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nyakasane anacibwîra Mûsa na Aroni, erhi: «Alagi obulyo mwakâjiramwo Basâka: harhajiraga ecigolo camulyakwo. ");
INSERT INTO shr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ngasi mujà wagulagwa, onamukembûle abul’irya Basâka. ");
INSERT INTO shr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","N’oli omubunga erhi mulimya, barhamulyagakwo. ");
INSERT INTO shr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Omu nyumpa nguma mwonene bakaz’imulira, na ntà kuhêka enyama embuga. Murhahîra mukavuna orhuvuha. ");
INSERT INTO shr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Olubaga lwa Bene-Israheli lwoshi lukâjira Basâka. ");
INSERT INTO shr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Akabà hali omubunga w’oku mwinyu walonza okugashâniza Basâka wa Nyakasane, ngasi mulume w’aha mwâge anakembûlwe, lyoki ankayegera, amugashânize, bulya akola nka muburhwa w’omu cihugo. Ci barhajiraga entakembûlwa ciru n’enguma yamulyâkwo. ");
INSERT INTO shr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Irhegeko libè lyo na lirya oku muburhwa w’omu cihugo n’oku mubunga ôbà muli mwe.» ");
INSERT INTO shr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bene-Israheli bàjira ntyo. Bajira kulya kwo na nênè Nyakasane àrhegekaga Mûsa na Aroni. ");
INSERT INTO shr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mw’olwo lusiku lwonênè, Nyakasane àrhenza Bene-Israheli omu cihugo c’e Mîsiri, nk’oku emirhwe yâbo yanali. ");
INSERT INTO shr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nyakasane àganîza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Onterekêre ngasi lubere lwa muli bene-Israheli, lulya luzibûla omulà gwa nnina walwo, olw’omu bantu n’olw’omu bintu: luli lwâni.» ");
INSERT INTO shr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mûsa anacibwîra olubaga, erhi: «Mukâkengêra lulya lusiku mwarhengaga e Mîsiri, omu nyumpa y’obujà, bulya kuboko kuzibuzibu Nyakasane àmmukûlagamwo eyo munda. Murhakâg’irya omugati gulimwo olwango. ");
INSERT INTO shr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","“Ene lyo murhenzireyo, omu mwêzi gw’Emihuli”. ");
INSERT INTO shr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","“Okuhandi, hano Nyakasane amâkuhisa omu cihugo c’Abakanani, c’Abahititi, c’Abamoriti, c’Abahiviti, n’ec’Abayebusi, cirya àcîgashiraga basho oku àkuhâco, cihugo cihululamwo amarhà n’obûci, okaz’ijira eci cijiro mwa guno mwêzi”. ");
INSERT INTO shr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Nsiku nda zoshi okaz’irya omugati gurhalimwo olwango. Olusiku lwa kali nda lukaz’ibà lusiku lukulu lwa Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","“Bakâlya omugati gurhalimwo olwango mw’ezo nsiku nda. Omugati gubumbugusire gurhabonekanaga; olwango lurhabonekanaga omu cihugo câwe mwoshi”. ");
INSERT INTO shr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Olwo lusiku onahugûlire mugala wâwe”, erhi: “Cêrekane eci c’ebi Nyakasane ànjirîre amango narhenganga e Mîsiri.” ");
INSERT INTO shr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Ntyo câbà cimanyîso ekuboko kwâwe na mwîbûko ebusù bwâwe, lyo irhegeko lya Nyakasane libà omu kanwa kâwe, bulya kuboko kwâge kuzibu Nyakasane akurhenzagyamwo e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","“Okazilanga eryo irhegeko omu lusiku lwâlyo ngasi mwâka.”» ");
INSERT INTO shr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Okuhandi, amango Nyakasane amâkuhisa omu cihugo c’e Kanâni, nk’oku àcîkwigashiraga mweshi na basho, ânabà amàkuhâco, ");
INSERT INTO shr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","“okaz’iberûlira Nyakasane ngasi hyoshi hizibûla omulà gwa nnina wahyo, na ngasi coshi cizibûla omulà gwa ngasi cintu onashweka: ngasi lubere luli lwa Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","“Ngasi lubere lwa ndogomi, okazilulyûlira omwâna-buzi. Akabà orhalulyûliri, onaluniole igosi. Ngasi nfula ya muntu muli bagala bâwe, wakâyilyûlira”. ");
INSERT INTO shr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“N’irhondo mugala wâwe akakudôsa, erhi: Kwo kurhi okwo?, onamubwîre, erhi: kuboko kuzibu Nyakasane àrhurhenzagyamwo e Mîsiri, omu nyumpa y’obujà”. ");
INSERT INTO shr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","“Kulya kubà Faraoni mwâmi w’e Mîsiri àkâg’ilahira mpu arharhulîka rhugende, Nyakasane ànigûza ngasi lubere omu Mîsiri, kurhangirira oku lubere lw’omuntu kuhika oku lubere lw’ecintu. Co cirhuma nterekêra Nyakasane ngasi lubere lulume luzibûla omulà gwa nnina walwo, ci ngasi nfula ya muli bagala bâni, nanyilyûlire”. ");
INSERT INTO shr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","“Cayîsh’ibà kuli we cimanyîso oku kuboko kwâwe na cimanè oku busù bwâwe, bulya kuboko kuzibuzibu Nyakasane àrhurhenzagyamwo e Mîsiri.”» ");
INSERT INTO shr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Erhi Faraoni mwâmi w’e Mîsiri àlîka olubaga mpu lugende, Nyamuzinda àrhalugezagya omu njira y’ecihugo c’Abafilistini, n’obwo yo yali njira ya hôfi. Nyamuzinda aderha, erhi: «Kurhakwânîni hano olubaga lubugâna entambala, lurhînye, obone lwamâcîshubirira e Mîsiri:» ");
INSERT INTO shr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nyamuzinda ayêrekeza olubaga ebw’irungu ly’Enyanja y’Amasheke. Bene-Israheli bàyinamuka, bàrhenga e Mîsiri nka mirhwe ya barhabâzi bajà oku bîrha. ");
INSERT INTO shr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mûsa àhêka amavuha ga Yozefu, bulya ali erhi àlahirize bene-Israheli, erhi: «Nyamuzinda àrhakabula buyîsh’imurhandûla; ago mango mwânahêke amavuba gâni.» ");
INSERT INTO shr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bàrhenga e Sukoti, bàj’itwa icumbi aha Etami, elubibi lw’irungu. ");
INSERT INTO shr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Nyakasane yêne àjâga abashokolera: mûshi omu cilundo c’omugî, lyo abalangûla enjira, na budufu omu cilundo c’omuliro, lyo abamolekera; bâkaz’ihasha ntyo okugenda mûshi na budufu. ");
INSERT INTO shr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mûshi eco cilundo c’omugî cirhàbulaga bwashokolera olubaga, na budufu eco cilundo c’omuliro ntà mango càbulikîne. ");
INSERT INTO shr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nyakasane anaciganiza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Obwîre Israheli bagaluke, bàj’itwa icumbi embere za Pi-Habiroti, ekarhî ka Migadoli n’enyanya, ishiriza lya Bal-Sefoni: ho mwâcûmbika oku burhambi bw’enyanja. ");
INSERT INTO shr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","“Hano Faraoni mwâmi w’e Mîsiri abona ntyo, àyîsh’iderha”, erhi: “Bo bala bajà balungalunga omu cihugo n’obwôba: Irungu lyabazonzire”. ");
INSERT INTO shr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","“Nadundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri, abashimbûlire. Ci nayêreka Faraoni mwâmi w’e Mîsiri n’emirhwe yâge, irenge lyâni, lyo Abanya-Mîsiri bamanya oku nie Nyakasane.”» Banacijira ntyo. ");
INSERT INTO shr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Bagend’ibwîra mwâmi w’e Mîsiri oku olubaga lwayasire. Faraoni mwâmi w’e Mîsiri n’abambali banacihindukirwa erhi olwo lubaga lurhuma, baderha, mpu: «Bici ebi rhwajizire bulà ene rhulika Bene-Israheli barhiba emikolo yîrhu!» ");
INSERT INTO shr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Anacishumûla engâlè yâge, àgenzikanwa bo n’olubaga lwâge. ");
INSERT INTO shr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Arhôla ngâlè magana gali ndarhu ga ntwâli, na ngasi ngâlè z’omu Mîsiri zoshi, ngasi nguma n’abasirika bâyo. ");
INSERT INTO shr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Nyakasane àdundaguza omurhima gwa Faraoni mwâmi w’e Mîsiri, mwâmi w’e Mîsiri, àkulikira Bene-Israheli, abo Bene-Israheli bàgendaga babangalazize amaboko. ");
INSERT INTO shr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Abanya-Mîsiri bàbakulikira buhena, bashanga bacûmbisire eburhambi bw’enyanja: ebiterusi bya Faraoni mwâmi w’e Mîsiri byoshi n’abasirika bâbyo, engabo zâge zoshi, babahikakwo hôfi ha Pi-Habiroti, ishiriza lya Bal-Sefoni. ");
INSERT INTO shr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Faraoni mwâmi w’e Mîsiri àbayegêra. Bene-Israheli mpu bayinamule amasù, babona Abanya-Mîsiri bacîrhulîra omu njira enyuma zâbo. Bene-Israheli bàrhungwa n’obwôba bwenêne, bàyamira Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Banacibwîra Mûsa, mpu: «Ka nshinda zalibuzire e Mîsiri obuwayishir’irhuyirhira omu mpinga? Bici ebi warhukolîre erhi orhurhenza e Mîsiri? ");
INSERT INTO shr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ka rhurhâli rhwakubwirîre e Mîsiri, nti: Rhuleke rhukaz’ikolera Abanya-Mîsiri. Okurhumikira Abanya-Mîsiri kwo kukulu ahâli h’okufîra omu irungu.» ");
INSERT INTO shr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mûsa abwîra olubaga, erhi: «Murhayôbohe! Zibuhi! Mwabona ebi Nyakasane ammujirira ene; bulya abà Banya-Mîsiri mudwîrhe mwabona, murhakacibabona bundi. ");
INSERT INTO shr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nyakasane wammulwira; mw’oyo murhûlûle kwône!» ");
INSERT INTO shr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nyakasane anacibwîra Mûsa erhi: «Cirhumire odwîrhe wanyamira? Obwîre Bene-Israheli bahîre njira! ");
INSERT INTO shr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nâwe, okubûle akarhi kâwe, olambûlire okuboko oku ngasi nyanja oyiberemwo mpande ibiri: Bene-Israheli bàcîrhulire omu karhî k’enyanja buzira kujoma amagulu. ");
INSERT INTO shr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nâni nadundaguza omurhima gw’Abanya-Mîsiri, lyo nabo bacîrhuliramwo enyuma zâbo. Ntyo nayêreka Faraoni mwâmi w’e Mîsiri irenge lyâni, n’emirhwe yâge yoshi, engâlè zâge n’abasirika bâge bashona oku biterusi. ");
INSERT INTO shr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Abanya-Mîsiri bamanya oku nie Nyakasane, hano mbà namâyêreka Faraoni mwâmi w’e Mîsiri irenge lyâni kuli engâlè zâge n’abasirika bâge bashona oku biterusi.» ");
INSERT INTO shr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Malahika wa Nyamuzinda wajâga ashokolera omurhwe gw’Israheli, agenda, àja enyuma zâbo. Cirya cilundo c’omugî càrhenga embere, càj’ijà enyuma zâbo. ");
INSERT INTO shr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Càgend’icîhira ekarhî k’omurhwe gw’Abanya-Mîsiri n’omurhwe gw’Israheli. Càjira ecitù haguma n’omwizizi: lêro cakâmoleka budufu. Ntâbo babashire okuhika oku bâbo obudufu bwoshi. ");
INSERT INTO shr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mûsa àlambûlira okuboko oku nyanja. Nyakasane àtunda enyanja obudufu bwoshi n’empûsi ndârhi y’ebuzûka-zûba yàyumya enyanja. Amîshi gàcîberamwo mpande ibiri. ");
INSERT INTO shr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Na Bene-Israheli bàcîrhulira omu nyanja burhajoma, amîshi gâbà cikunguzo ekulyo n’ekumosho kwâbo. ");
INSERT INTO shr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Abanya-Mîsiri bàbakulikira luminomino, bacîrhuliramwo enyuma zâbo, ebiterusi bya Faraoni mwâmi w’e Mîsiri byoshi, engâlè zâge zoshi n’abasirika bashona oku biterusi boshi bacîrhuna omu karhî k’enyanja. ");
INSERT INTO shr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Lêro sêzisêzi lukula arhanda, Nyakasane alolera engabo y’ab’e Mîsiri mulya cilundo c’omuliro n’ec’omugî àlimwo, àhira akavulindi omu murhwe gw’Abanya-Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Avamya emizizi y’engâlè zâbo, zayabirwa okucishegûka. Abanya-Mîsiri bàcîjamwo, mpu: «Rhuyâkire Israheli kulî bulya Nyakasane odwîrhe abalwikiza Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nyakasane abwîra Mûsa, erhi: «Lambûlira okuboko oku nyanja: amîshi galûndukire Abanya-Mîsiri, n’engâlè zâbo, n’abasirika bâbo bashona oku biterusi.» ");
INSERT INTO shr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mûsa anacilambûlira okuboko oku nyanja. Erhi kubà mucêracêra, enyanja yashubira aha enayôrha ebà. Erhi Abanya-Mîsiri bacîderha mpu bayâka, bàj’iyibugâna. Nyakasane anacihenangulira Abanya-Mîsiri omu kâgarhî k’enyanja. ");
INSERT INTO shr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Amîshi gashub’icîgusha gàbwikira engâlè n’abasirika b’ebiterusi: omu ngabo ya Faraoni mwâmi w’e Mîsiri yoshi yacîrhuliraga omu nyanja enyuma za Bene-Israheli, harhasigalaga ciru n’omuguma. ");
INSERT INTO shr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ci Bene-Israheli bône bacîgerera omu kâgarhî k’enyanja n’amagulu burhajoma, amîshi gàjira ecikunguzo ekulyo n’ekumosho kwâbo. ");
INSERT INTO shr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Olwo lusiku Nyakasane alîkûza Israheli omu maboko g’Abanya-Mîsiri, na Israheli abona emirhumba y’Abanya-Mîsiri oku cikwi c’enyanja. ");
INSERT INTO shr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israheli abona kuboko kudârhi kunganaci Nyakasane ajiragamwo Mîsiri ntyo. Olubaga lwarhînya Nyakasane, lwayêmêra Nyakasane bo n’omwambali Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Okuhandi, Mûsa bona Bene-Israheli, banaciyimbira Nyakasane olu lwimbo, mpu: Nacîtakîra Nyakasane, bulya àyêrekîne irenge lyâge: àloha ebiterusi n’abashona oku biterusi omu nyanja. ");
INSERT INTO shr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nyakasane ye burhwâli, ye na lwimbo lwâni, ye muciza wâni, ye Nyamuzinda wâni: namuhà irenge; ye Nyamuzinda wa larha: namukuza. ");
INSERT INTO shr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Nyamuzinda abà mulwî: izîno lyâge ye Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Aloha engâlè za Faraoni mwâmi w’e Mîsiri n’engabo zâge, abarhambo b’entwâli zâge omu nyanja. Wanyanja Ndukula, abamirangusa. ");
INSERT INTO shr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bàbwikirwa n’obwinini, bàzika nk’ibàle. ");
INSERT INTO shr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Okulyo kwâwe, Nyakasane, kwacîkuza n’obuhashe bwâkwo, okulyo kwâwe, Yâgirwa, kwamalîra abashombanyi. ");
INSERT INTO shr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Omu bukulu bw’irenge lyâwe wahenangula abashombanyi bâwe; wayûsa oburhè bwâwe, bwabagulumiza nka bijangala. ");
INSERT INTO shr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Okufûha kwâwe kwacîka amîshi, emihûsi yago yashuba bikunguzo, empimbi zago zàgarhira omu bululi bw’enyanja. ");
INSERT INTO shr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Omushombanyi àli adesire, erhi: «Nammuminika, mmugwarhe, rhwagabâna eminyago, omumiro gwâni gwagogwa; nayômola engôrho yâni, okuboko kwâni kwabanigûza!» ");
INSERT INTO shr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Wanacihûsa empûsi yâwe, enyanja yabamirangusa, bàrhogera emûbi nk’ibâle, muli nyandumà w’amîshi. ");
INSERT INTO shr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wundi Nyamuzinda ohi oli nka We, Yâgirwa? Ndi oli akâwe, we cilangashane c’obwimâna, murhînywa omu bijiro byâwe, mujizi w’ebirhangâzo? ");
INSERT INTO shr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Walambûla okulyo kwâwe, okuzimu kwabamirangusa. ");
INSERT INTO shr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Omu lukogo lwâwe, walongôlana olubaga wayôkolaga, walushokolera n’obuhashe bwâwe, kuhika aha mûbako gwâwe Mutagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amashanja gàyumva, gàgeramwo ogwa nyegenye; omusisi gwadirhimanya abayûbaka omu Filistiya. ");
INSERT INTO shr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abarhambo b’omu Edomu bàjuguma; Abaluzi b’e Mowabu bàgeramwo ogwa nyegenye; abayûbaka omu Kanâni boshi bàdirhimana. ");
INSERT INTO shr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ecôbà n’omisisi byàbarhogera; oku buhashe bw’okuboko kwâwe bàguguma, bàrhungwa, kuhika olubaga lwâwe lugere, Yâgirwa, kuhika lugere olubaga wêne wayôkolaga. ");
INSERT INTO shr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wàbahêka, oj’ibasimika oku ntondo y’obwâmi ebè ndâro yâwe, ndâro yagwikagwa n’okuboko kwâwe, Yâgirwa! ");
INSERT INTO shr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Nyakasane aganze anagandaze ensiku n’amango. ");
INSERT INTO shr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ebiterusi bya Faraoni mwâmi w’e Mîsiri byàli byamàcîrhuna omu nyanja, haguma n’engâlè n’abasirika bâge b’oku biterusi, Nyakasane àbashunûlirakwo amîshi g’omu nyanja; ci Bene-Israheli, bôhe erhi bagezire omu nyanja n’amagulu burhajoma. ");
INSERT INTO shr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Omulêbi-kazi Miriyamu, mwâli wâbo Aroni, anacirhôla engoma; abakazi boshi banacirhôla ezindi ngoma, bàmuyisha omu nyuma, bàjà bayimba banasâma. ");
INSERT INTO shr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyamu àkàyimbiza, erhi: «Mucîtakirire Nyakasane, bulya àyêrekîne irenge lyâge: aloha omu nyanja ebiterusi n’abashona oku biterusi». ");
INSERT INTO shr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mûsa anacilongôlana Israheli kurhenga oku Nyanja Ndukula, bagendihulukira ebw’irungu lya Shuru. Bàgenda nsiku isharhu zoshi buzira kubona amîshi. ");
INSERT INTO shr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bàhika aha Mara, ci bàrhahashaga okunywa amîshi g’aha Mara, bulya gàli malulu, co cirhuma ganaderhwa izîno lya «Mara». ");
INSERT INTO shr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Olubaga lwacîdudumira Mûsa, lwaderha, mpu: «Bicigi rhwanywa obu?» ");
INSERT INTO shr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mûsa anacilakira Nyakasane, naye Nyakasane àmuyêreka murhi muguma. Akweba ecihimbi cagwo omu mîshi, n’amîshi gàshuba minjà. Aho ho àbahêraga amarhegeko n’engeso bakaz’isimba. Aho ho àbarhanguliraga. ");
INSERT INTO shr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Aderha, erhi: «Okàyumva bwinjà izù lya Nyakasane, Nyamuzinda wâwe, okâjira ebishingânîne omu masù gâge, okàyumva amarhegeko gâge, okâshimba amahano gâge goshi, ntakuyôhekwo ndwâla ciru n’enguma eri nk’ezi nayôhaga kuli Mîsiri, bulya nie Nyakasane wakufungira!» ");
INSERT INTO shr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Banacihika aha Elimu, aho habà maliba ikumi n’abiri ga mîshi, na mirhi makumi gali nda ya mabò. Bàhânda aho, hôfi n’amîshi. ");
INSERT INTO shr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Banacirhenga aha Elimu, bene-Israheli boshi, bàhika omu irungu lya Sini, ekarhî ka Elimu na Sînayi, omu lusiku lwa kali ikumi na karhanu lw’omwêzi gwa kabiri kurhenga barhenzire omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Bene-Israheli boshi bàcidudumira Mûsa na Aroni omu irungu. ");
INSERT INTO shr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Bene-Israheli bàkâbabwîra, mpu: «Rhucifìraga omu Mîsiri n’okuboko kwa Nyakasane kwo kwàli kukulu, lyoki rhwakâg’iburhamala aha burhambi bw’enyungu z’enyama, rhwâkaz’irya omugati, rhuyigurhe oku rhulonzize! Mwarhudwîrhe muno irungu mpu olu lubaga luhungumukiremwo lwoshi n’ishali!» ");
INSERT INTO shr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Nyakasane anacibwîra Mûsa, erhi: «Nkola nammuniekeza omugati gw’oku nkuba. Olubaga lwâkazihuluka, ngasi lusiku lurhôlogole ebiryo by’omulegerege, lyo ndurhangula, ndole erhi lwashimba amarhegeko gâni eri nanga. ");
INSERT INTO shr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Olwa kali ndarhu, nka barheganya ebi bàrhôzire, banarheganya mirengo ibiri kulusha eyi barhôla omu zindi nsiku.» ");
INSERT INTO shr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mûsa na Aroni bàbwîra bene-Israheli boshi, mpu: «Hano bijingo mwamanya oku Nyakasane wanammukûlaga omu cihugo c’e Mîsiri; ");
INSERT INTO shr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","irhondo sêzi, mwâbona irenge lya Nyakasane, bulya anayumvîrhe kurhi mudwîrhe mwacidudumira Nyakasane. Rhwono, rhuligi bantu baci mpu mwacîrhwidudumira?» ");
INSERT INTO shr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mûsa àlonzagya okubabwîra, erhi: «Mwâbona oku hano bijingo Nyakasane ammuhà enyama y’okulya, n’omugati sêzi nk’oku munalonzize, bulya Nyakasane anayumvîrhe kurhi mudwîrhe mwacîmwidudumira. Rhwono rhuligi bantu baci? Arhali rhwe mwacîdudumîre, ci Nyakasane mwacîdudumîre.» ");
INSERT INTO shr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mûsa anacibwîra Aroni, erhi: «Obwîre bene-Israheli boshi, erhi: Muyegere embere za Nyakasane, bulya anayumvîrhe emidudumo yinyu.» ");
INSERT INTO shr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Oku Aroni acidwîrhe aganîza Bene-Israheli boshi, banaciyerekera ebw’irungu: ho n’aho irenge lya Nyakasane lyanacibonekana omu citù. ");
INSERT INTO shr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Nayumvîrhe kurhi Bene-Israheli badwîrhe bacîduduma. Obabwîre ntya: Bijingo, mwakâlya enyama na sêzi, mwakâyigurha omugati, mugambwe, mumanye obwo oku nie Nyakasane, Nyamuzinda winyu.» ");
INSERT INTO shr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ebyo bijingo byo na nênè, enkwâle zayinamuka zàbwikira icumbi lyoshi; n’erhi kubà sêzi, ehitù hy’olumè hyazunguluka icumbi. ");
INSERT INTO shr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Hirya hitù hy’olumè hyàkala; lêro oku idaho, omu irungu, kwasigala ebiri nka mogomogo, nsungunu, nyêru nka munyù. ");
INSERT INTO shr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Erhi Bene-Israheli bàbona ebyo, bàdôsanya, mpu: «Mane hu?» (Byo bici ebi?). Bulya barhàli bamanyire biri bici. Mûsa ababwîra, erhi: «Gwo mugati gw’okulya Nyakasane ammuhîre ogwo». ");
INSERT INTO shr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yumvagi oku Nyakasane arhegesire: Mukârhôlogola birya ngasi muguma ankanahash’irya. Mukaz’irhôla nnamâha muguma kuli ngasi muntu, nk’oku abantu banali. Ngasi mushamuka arhôle nk’oku abantu banali aha mwâge. ");
INSERT INTO shr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bene-Israheli bajira ntyo: bàgend’ikârhôlogola, owa binji, owa bisungunu. ");
INSERT INTO shr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bàj’ikâlengera muli nnamâha: owali orhôlôgwire binji, ntâco càmulugîre, n’owali orhôlogwire bisungunu, ntâco càmunyihire. Ngasi muguma àkaziguka birya ankanayigurha. ");
INSERT INTO shr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mûsa anacibabwîra, erhi: «Ntâye okâg’iderha mpu abibika kuhika bucè.» ");
INSERT INTO shr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Baguma barhayumvagya, bàbibika kuhika sêzi, ci byàjâmwo emivunyu, byàbola. Obwo Mûsa àbakunirira. ");
INSERT INTO shr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Bàkâg’irhôlogola sêzi ngasi muguma ebyankamuyigusa. Erhi izûba lyâbashaga, binajonge. ");
INSERT INTO shr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Olwa kali ndarhu, bàkaz’irhôlogola kabiri kulusha, bannamâha babiri kuli ngasi muguma. Abagula boshi b’omu Israheli bàyîsh’ikubwîra Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ababwîra, erhi: «Kwo Nyakasane adesire ntya: Irhondo luli luzira lwa-Sabato, lusiku lwa kurhamûka, lurherêkirwe Nyakasane. Muyende ngasi biri bya kuyendwa, mudûrhubaze ngasi bya kudûrhubazibwa. Ebyankasigala, mubibîke kuhika irhondo.» ");
INSERT INTO shr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Banacikâbibika kuhika sêzi nka kulya Mûsa anali arhegesire. Harhajiraga byabaya erhi kujamwo emivunyu. ");
INSERT INTO shr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mûsa ababwîra, erhi: Mubirye ene. Ene ali Sabato wa Nyakasane. Ene murhabibugâne embuga. ");
INSERT INTO shr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mukaz’ibirhôlogola nsiku ndarhu, olwa kali nda, ali Sabato: «birhâkâbonekana:». ");
INSERT INTO shr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ci kwône, mw’olwo lusiku lwa kali nda, olubaga lwarhengamwo bantu baguma, bàhuluka mpu baj’irhôlogola, ci bàrhashimanaga kantu. ");
INSERT INTO shr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nyakasane anacibwîra Mûsa, erhi: «Kuhika mangaci mwayôrha mulahira okushimba amarhegeko n’amahano gâni? ");
INSERT INTO shr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mumanye oku Nyakasane àmmuhire olwa Sabato, co cirhuma olwa kali ndarhu, ammuhà biryo bya nsiku ibiri. Kaz’imubêre ngasi muguma aha mwa bînywe. Ntâye orhengâge aha mwâge olwa kali nda.» ");
INSERT INTO shr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Obwo, olubaga lwakaz’irhamûka olusiku lwa kali nda. ");
INSERT INTO shr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ebyo biryo, enyumpa y’Israheli yàbiyîrika izîno lya «Mâna.» Byàkâg’iyôrha nka mbeke, byàli byêru, byànagwêrhe obununu buli nka bwa bûci. ");
INSERT INTO shr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mûsa anaciderha, erhi: «Yumvagi oku Nyakasane arhegesire: Babumbe nnamâha muguma, bamubîkîre abâna binyu, lyo bàyîsh’ibona kalyo kaci nammulisagyamwo omu irungu, amango nammurhenzagya omu cihugo c’e Mîsiri» ");
INSERT INTO shr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mûsa abwîra Aroni, erhi: «Orhôle akalugu, ohiremwo nnamâha wa mâna, odêkereze embere za Nyakasane, abîkirwe abâna binyu.» ");
INSERT INTO shr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aroni akadêkereza ebè mbîko embere z’obuhamîrizi nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bene-Israheli bàlya amâna myâka makumi anni kuhika olusiku bàhikaga omu cihugo cibâmwo abantu; bàlya amâna kuhika olusiku bàhikaga omu lubibi lw’ecihugo c’e Kanâni. ");
INSERT INTO shr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Oyo nnamâha cibà cigabi ca kali ikumi ca Efa. ");
INSERT INTO shr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Olubaga lwa bene-Israheli lwoshi lwanacirhenga ebw’irungu lya Sini, lwaharhûla, lwashimba enjira nk’oku Nyakasane anali arhegesire, lwaj’ihanda aha Refidimi; ci aho harhali mîshi ga kunywa. ");
INSERT INTO shr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Olubaga lwalongôza Mûsa, mpu: «Orhuhè amîshi rhunywe!» Mûsa anacibabwîra, erhi: «Cirhumire mwannongôza? Cirhumire murhangula Nyakasane?» ");
INSERT INTO shr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Aho olubaga lwalibûka n’enyôrha; olubaga lwacîdudumira Mûsa, mpu: «Carhumaga orhurhenza e Mîsiri? Ka mpu orhuyirhe n’enyôrha, rhwe n’abâna n’ebintu bîrhu?» ");
INSERT INTO shr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mûsa àyamira Nyakasane, erhi: «Kurhigi najira olu lubaga? Hacisigîre hitya hyône lummande amabuye.» ");
INSERT INTO shr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nyakasane abwîra Mûsa, erhi: «Oshokole, ojè embere z’olubaga, ohêke na bagula baguma ba muli bene Israheli: kalya karhî washûrhagamwo olwîshi, okafumbarhe omu nfune, ogende. ");
INSERT INTO shr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Naj’iyimanga oku ibuye liri aha Horebu, embere zâwe eyo munda. Oyîsh’ishûrha ibuye, amîshi garhengemwo, olubaga lunywe.» Mûsa anacikujira, omu masù g’abagula b’Israheli. ");
INSERT INTO shr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Aho hantu àhayîrika izîno lya Masa na Meriba erhi erya nnongwè ya bene-Israheli, na kulya kubà barhangwire Nyakasane, baderha, mpu: «Ka Nyakasane anacibà ekâgarhî kîrhu erhi nanga?» ");
INSERT INTO shr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Okuhandi Amaleki anaciyîsh’ilwîsa Israheli aha Refidimi. ");
INSERT INTO shr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mûsa abwîra Yozwè, erhi: «Ocîshoge abantu, ogend’ilwîsa Amaleki; irhondo naj’iyimanga oku irhwèrhwè lya hira hirhondo n’akarhi ka Nyamuzinda omu nfune.» ");
INSERT INTO shr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yozwè anacikozakwo Amaleki entambala, nka kulya Mûsa anamubwîraga; naye Mûsa bo na Aroni na Huru bàsôkera oku irhwèrhwè ly’ehirhondo. ");
INSERT INTO shr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Erhi Mûsa ayinamuliraga amaboko emalunga, Israheli ànaje àhima, n’erhi aderhaga mpu arhamûsa amaboko, Amaleki ànaje àhima. ");
INSERT INTO shr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Erhi amaboko ga Mûsa gàrhama, bàrhôla ibuye, bàmutamazakwo. Aroni na Huru banacimugwârha amaboko, muguma lunda luguma n’owundi olundi lunda. Ntyo amaboko gâge gàyôrha gazibuhire kuhika izûba lyàzika. ");
INSERT INTO shr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yozwè àhima Amaleki, n’olubaga lwâge àlugeza oku bwôji bw’engôrho. ");
INSERT INTO shr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Nyakasane anacibwîra Mûsa, erhi: «Oyandike ebyo omu citabu c’okubiyibusa, onabwîre Yozwè oku nâzâza izîno ly’Amaleki lirhacifâga lyàkengîrwe n’igulu.» ");
INSERT INTO shr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mûsa anaciyûbaka oluhêrero, àluyîrika izîno lya Nyakasane -Nîsi, ");
INSERT INTO shr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","erhi: «Bulya okuboko kwalengezibwe mpu kwalwîsa Nyakasane, Nyakasane naye akolaga alwîsa Amaleki kurhenga oku iburha kuhika oku lindi.» ");
INSERT INTO shr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetro, mudâhwa w’e Madiyani, ishazâla wa Mûsa, anaciyumva bàshambâla ngasi byoshi Nyamuzinda àjirîre Mûsa n’olubaga lw’Israheli, na kurhi Nyakasane arhenzagya Israheli e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Yetro, ishazâla wa Mûsa, anacirhôla Sipora, mukà Mûsa, erhi àhulusîbwe, ");
INSERT INTO shr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","na bagala bâge bombi: muguma izîno lyâge ye wali Gershomi -Lubungo- bulya Mûsa àli adesire, erhi: «Ndi mubunga omu cihugo c’ihanga,» ");
INSERT INTO shr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","n’owundi ye wali Eliyezeri -Nyamuzinda ye burhabâle bwâni bulya «Nyamuzinda wa larha ye wayishir’intabâla, ànfulumula oku ngôrho ya Faraoni mwâmi w’e Mîsiri.» ");
INSERT INTO shr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetro, ishazâla wa Mûsa, bo nabagala ba Mûsa na mukà-Mûsa banacijà emunda àli ahanzire omu irungu oku ntondo ya Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Anacirhuma abaj’ibwîra Mûsa, erhi: «Nie Yetro ishazâla wâwe, nyishire emund’oli rhwe na mukâwe na bagala bâwe bombi.» ");
INSERT INTO shr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mûsa àhuluka, aj’ibugâna ishazâla, aharâmya anamuhôbera. Erhi babà bamadôsanya emyanzi, bàjà omu cihando. ");
INSERT INTO shr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mûsa àganîrira ishazâla ngasi byoshi Nyasakane àjirîre Faraoni mwâmi w’e Mîsiri na Mîsiri erhi Israheli orhuma, ngasi mbaka zoshi babuganyire omu njira n’oku Nyakasane àbalikûzize muli zo. ");
INSERT INTO shr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro àsîma ago minjà goshi Nyakasane àjirîre Israheli, omu kumulîkûza omu maboko g’Abanya-Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro anaciderha, erhi: «Ayâgirwe Nyakasane wammulîkûzagya omu maboko g’Abanya-Mîsiri n’aga Faraoni mwâmi w’e Mîsiri, owalikûzagya olubaga lwâge omu maboko g’Abanya-Mîsiri! ");
INSERT INTO shr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Lêro nkola mmanyire oku Nyakasane ye mukulu kulusha banyamuzinda b’obwîhambe boshi.» ");
INSERT INTO shr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetro, ishazâla wa Mûsa, àrhûla Nyamuzinda embâgwa n’enterekêro. Aroni bo n’abagula b’Israheli boshi bàyisha, balîra baguma n’ishazâla wa Mûsa embere za Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Erhi buca, Mûsa ajà e kagombe mpu atwîre olubaga emmanja. Lwalegerera luyimanzire embere zâge kurhenga sêzi kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Erhi ishazâla wa Mûsa abona ebyo byoshi àkâg’ijirira olubaga, amubwîra, erhi: «Bici ebyo odwîrhe wajirira olubaga? Cirhuma ojà e kagombe wêne n’obwo olubaga lushigalîre embere zâwe kurhenga sêzi kuhika bijingo?» ");
INSERT INTO shr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mûsa anacibwîra ishazâla, erhi: «Olubaga lunakâyisha emunda ndi lul’idôsa Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Nka hali lubanja lugwêrhe, banalunderhere nambazâbûlirelwo, mbamanyise n’amarhegeko ga Nyamuzinda n’amahano gâge.» ");
INSERT INTO shr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ishazâla wa Mûsa amubwîra, erhi: «Okwo ojira kurhali kwinjà. ");
INSERT INTO shr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Wafà n’omurhamo, we n’olu lubaga muli mweshi. Ogu mukolo guli muzirho bwenêne kuli we; orhankahasha okukâguyukiriza wêne. ");
INSERT INTO shr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Yumva, nkuhè ihano, na Nyamuzinda abè haguma nâwe! Oyimangire olubaga embere za Nyamuzinda, n’emmanja zâbo okazihêkera Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Okaz’ilangûla olubaga amahano n’amarhegeko, okaz’ibamanyisa enjira y’okushimba n’olugendo bakwânîne okubà nalwo. ");
INSERT INTO shr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kandi, omu lubaga lwoshi, ocîshogemwo abalume b’entwâli, abarhînya Nyamuzinda, ab’okucîkubagirwa, bantahemuka; obajire barhambo b’olubaga: barhambo ba bihumbi, barhambo ba magana, barhambo ba makumi arhanu-arhanu na barhambo b’ikumi ikumi. ");
INSERT INTO shr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Babè bo bakaz’iyôrha batwa emmanja. Nka hali olubanja lunene, bakâkulerheralwo, ci emmanja nsungunu, bakàz’izizâbûla bône. Oyanguhye ntyo omuzigo gwâwe, mugubarhule mwe nabo! ");
INSERT INTO shr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Okajira ntyo, Nyamuzinda anakulangula enjira, wanabona emisî, n’olu lubaga lwanakâshubira emwa bâbwè n’obuholo.» ");
INSERT INTO shr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mûsa ayumvîrhiza izù ly’ishazâla, ànajira nk’oku amubwîraga koshi. ");
INSERT INTO shr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Muli Bene-Israheli boshi, Mûsa àcîshogamwo abalume b’entwâli, abajira barhambo b’olubaga: barhambo ba bihumbi, barhambo ba magana, barhambo ba makumi arhanu-arhanu na barhambo b’ikumi-ikumi. ");
INSERT INTO shr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bakâz’iyôrha batwîra olubaga emmanja ngasi mango. Ngasi mmanja ndârhi, bakâz’ihêkera Mûsa, na ngasi binwa bisungunu, bakâb’izâbûla bônene. ");
INSERT INTO shr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mûsa anacisengaruka ishazâla, naye acîshubirira omu cihugo câge. ");
INSERT INTO shr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Omu mwêzi gwa kasharhu kurhenga barhenzire omu cihugo c’e Mîsiri, olwo lusiku lwonênè, bene-Israheli bàhika omu irungu lya Sînayi. ");
INSERT INTO shr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Bàrhenga e Refidimi, bàhika omu irungu lya Sînayi, banacitwa icumbi omu irungu. Israheli àhanda eburhambi bw’entondo. ");
INSERT INTO shr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mûsa anacisôkera aha Nyamuzinda ali. Nyakasane àmuhamagala kurhenga kulya ntondo, amubwîra, erhi: «Ogend’ibwîra enyumpa ya Yakôbo, omanyise bene Israheli ebi binwa, erhi: ");
INSERT INTO shr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Mwabwîne mwêne ebi najirîre Mîsiri, kurhi nayishaga mmudwîrhe oku byûbi by’enyunda, nammuhisa emunda ndi. ");
INSERT INTO shr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Lêro, mukâyumva izù lyâni n’okushimba endagâno yâni, mwâbà mwîmo gwâni omu mashanja goshi, bulya igulu lyoshi liri lyâni; ");
INSERT INTO shr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mwâbe bûko bw’abadâhwa b’obwâmi bwâni n’ishanja lyâni litagatîfu. Byo binwa wagend’ibwîra Bene-Israheli ebyo.» ");
INSERT INTO shr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mûsa anacigend’ihamagala abagula, àbarhondêreza ebyo binwa byoshi Nyakasane amurhegekaga. ");
INSERT INTO shr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Olubaga lwoshi lwanacishuza câligumiza, mpu: «Ebi Nyakasane anadesire byoshi, rhwabijira.» Mûsa anacishub’igend’ibwîra Nyakasane ebinwa olubaga lwashuzize. ");
INSERT INTO shr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nyakasane abwîra Mûsa, erhi: «Nkola nayisha emunda oli omu citù cizirho, lyo olubaga luyumva hano nkola nakushambâza lyo nâwe wêne lukaz’ikâkwikubagira ensiku zoshi.» Mûsa anacibwîra Nyakasane ebinwa by’olubaga. ");
INSERT INTO shr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nyamubâho anacibwîra Mûsa, erhi: «Genda emunda olubaga luli, oluyôbôle ene n’irhondo; luce, bashuke n’emyambalo yâbo, ");
INSERT INTO shr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","“bacîrheganye oku lusiku lwa kasharhu, bulya oku lusiku lwa kasharhu Nyakasane àyandagala oku ntondo ya Sînayi omu masù g’olubaga lwoshi”. ");
INSERT INTO shr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Otwîre olubaga olubibi eburhambi, obabwîre”, erhi: “Mumanye murhasôkeraga oku ntondo erhi okuhuma omu marhambi gâyo. Ngasi yêshi wankahuma oku ntondo anayirhwe”. ");
INSERT INTO shr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","“Arhâhumwakwo, ci abandwe amabuye erhi alashwe. Cibè cintu erhi muntu, birhalamaga. Hano empembe eshakânya, baguma banasokera oku ntondo.”» ");
INSERT INTO shr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mûsa anaciyandagala oku ntondo, àja emunda olubaga luli. Aluyôbôla lwacà, bàshuka emyambalo yâbo, ");
INSERT INTO shr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","anacibwîra olubaga, erhi: «Mucîrheganye mw’ezi nsiku isharhu, muleke okujà omu mwa bakînywe.» ");
INSERT INTO shr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Lêro, oku lusiku wa kasharhu, erhi kubà sêzi, habà emikungulo, emilazô, ecitù cizirho càbwikira entondo, n’izù ly’empembe lyàshakânya; omu icumbi olubaga lwoshi lwadirhimana. ");
INSERT INTO shr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mûsa anacihulusa olubaga omu irungu mpu luj’ibugânana na Nyamuzinda; boshi bàyimanga omu kabanda k’entondo. ");
INSERT INTO shr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Entondo ya Sînayi yakaz’itumbûka mugî, bulya Nyakasane ali ayandagalirekwo omu ngulumira y’omuliro; omugî gw’ogwo muliro gwakâtumbûka nka mugî gw’itanuru, n’entondo yoshi yadirhimana bwenêne bwenêne. ");
INSERT INTO shr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Izù ly’omushekera lyàshakânya bwenêne: Mûsa àkaz’ishambâla, na Nyamuzinda àkaz’imushuza n’izù ly’emikungulo. ");
INSERT INTO shr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nyakasane ayandagalira oku ntondo ya Sînayi, oku irhwèrhwè ly’entondo. Nyakasane ahamagala Mûsa kulya irhwèrhwè ly’entondo, naye Mûsa akusôkera. ");
INSERT INTO shr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nyakasane anacibwîra Mûsa, erhi: «Yandagala, orhonde olubaga, lwankanacirhulira emunda Nyamuzinda ali mpu lwalola obone bamafâmwo banji: ");
INSERT INTO shr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ciru n’abadâhwa bayegêra Nyakasane bacicêse, lyo Nyakasane arhag’ibamalîra!» ");
INSERT INTO shr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mûsa anacibwîra Nyakasane, erhi: «Olubaga lurhàsôkere oku ntondo ya Sînayi bulya wêne wârhurhonzire, ene oderha, erhi: “Otwe olubibi w’entondo lubè luhangizè!”» ");
INSERT INTO shr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nyakasane amubwîra, erhi: «Genda, oshub’iyandagala; oyîsh’irherema mwe na Aroni. Ci abadâhwa n’olubaga, bamanye bankacîrhulumbika mpu basôkera emunda Nyakasane ali, ankanabamalîra!» ");
INSERT INTO shr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mûsa ayandagalira ebwa lubaga, alubwîra okwo. ");
INSERT INTO shr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nyamuzinda anaciderha ebi binwa byoshi, erhi: ");
INSERT INTO shr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Nie Nyakasane, Nyamuzinda wâwe, owakurhenzagya omu cihugo c’e Mîsiri, omu nyumpa y’obujà: ");
INSERT INTO shr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Orhahîraga okabà n’abandi banyamuzinda kuleka nie. ");
INSERT INTO shr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Orhahîraga okajira enshushano, erhi olwiganyo lw’ebiremwa bibà enyanya emalunga, n’oli olw’ebiremwa bya hano igulu, n’oli eby’omu mîshi ekuzimu kw’igulu. ");
INSERT INTO shr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Orhahîraga okabaharâmya erhi kubakolera, bulya niene Nyakasane, Nyamuzinda wâwe, ndi wa mutula otulutumbya abâna oku mabî ga b’îshe, kuhika oku iburha lya kasharhu, n’erya kani, balya banshomba; ");
INSERT INTO shr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ci abanzigira, bakashimba n’amarhegeko gâni, nnambajirire aminjà kuhika oku iburha lya kali cihumbi. ");
INSERT INTO shr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Orhakâzâg’iderha busha izîno lya Nyakasane, Nyamuzinda wâwe, bulya Nyakasane arhaleka kuhana omuntu oderha busha izîno lyâge. ");
INSERT INTO shr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Okâkengêra olwa Sabato, onakâlujira lutagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nsiku ndarhu wakaz’ijiramwo emikolo yâwe yoshi, ");
INSERT INTO shr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ci olusiku lwa kali nda, luli Sabato wa Nyakasane, Nyamuzinda wâwe. ");
INSERT INTO shr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Bulya omu nsiku ndarhu Nyakasane àjira amalunga n’igulu, enyanja na ngasi bibâmwo, ci oku lusiku lwa kali nda àrhamûka. Co cârhumire Nyakasane agisha olwo Sabato, ànalujira lutagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Okazikenga sho na nyoko, ly’olama myâka minji omu cihugo ohîrwe na Nyakasane, Nyamuzinda wâwe. ");
INSERT INTO shr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Orhahîraga okaniga. ");
INSERT INTO shr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Orhahîraga okajira eby’enshonyi. ");
INSERT INTO shr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Orhahîraga okazimba. ");
INSERT INTO shr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Orhahîraga okahamiririza mulungu wâwe obunywesi. ");
INSERT INTO shr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Orhahîraga okacifìnja mukà mulungu wâwe, nîsi erhi mwambali wâge kandi erhi mwambalikazi wâge, erhi nkâfu yâge, erhi cihêsi câge, ngasi kalugu ka mulungu wâwe koshi orhacîfînjagako. ");
INSERT INTO shr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Olubaga lwoshi lwakâg’iyumva emilazô, emikungulo n’izù ly’omushekera, n’entondo yatumbûka mugî. Olubaga lwabona lwadirhimana, lwanaciyêgûlira kûli. ");
INSERT INTO shr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Bàbwîra Mûsa, mpu: «Orhubwîre wêne rhwayumwa; ci Nyamuzinda arharhubwîraga, rhwankanafà!» ");
INSERT INTO shr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mûsa abwîra olubaga, erhi: «Murhayôbohaga! Bulya Nyamuzinda ayishire mpu amurhangule, lyo ecôbà câge cimmubâmwo, mulek’ikâgoma.» ");
INSERT INTO shr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Olubaga lwacîyegûlira kulî, ci Mûsa yêhe ayegêra cirya citù Nyamuzinda àlimwo. ");
INSERT INTO shr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Nyakasane anacibwîra Mûsa, erhi: «Ojibwîra Bene Israheli, ntya: mwabwîne mwene oku kurhenga e malunga nakâg’imuganiza. ");
INSERT INTO shr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Murhahîraga mukampalikanya na banyamuzinda b’amarhale, mumanye irhondo mwankaderha mpu mwacîjirira banyamuzinda b’âmasholo. ");
INSERT INTO shr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Oyîsh’inyubakira oluhêrero lw’obudaka wakârherekêrakwo embâgwa n’enterekêro zâwe z’omurhûla, ebibuzi n’enkafu zâwe na ngasi bantu nânamanyise izîno lyâni, nâyisha ah’oli nkugishe. ");
INSERT INTO shr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ci erhi wankanyubakira oluhêrero lw’amabuye, orhayubakaga n’amabuye mabinje, bulya hano ogagezakwo enkolôlo yâwe, wanagaziza. Orhakâg’irheremera oku mashonezo nka wajà aha luhêrero lwâni, lyo olek’iyêrekana obushugunu bwâwe.» ");
INSERT INTO shr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Alaga irhegeko wabahà: ");
INSERT INTO shr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Amango okagula omujà Muyahudi, anakukolera myâka ndarhu, ogwa kali nda, analîkwe, buzira kujuha cici. ");
INSERT INTO shr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Akabà àyishaga yênene, anagenda yênene. Akabà àgwêrhe omukazi, mukâge anagenda bo naye. ");
INSERT INTO shr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Akabà nnawâbo wamuhâga omukazi, n’akabà nyamukazi àmuburhîre abânarhabana erhi abâna-nyere, omukazi n’abâna banabè ba nnawâbo, naye anagenda yênene. ");
INSERT INTO shr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ci erhi oyo mujà ankaderha, erhi: «Nsîmire nnawîrhu, mukânie n’abâna bâni ntalonzizi kulîkwa», ");
INSERT INTO shr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nnawâbo anamuhêka embere za Nyamuzinda, amuhise aha lumvi erhi oku mulirango: nnawâbo anamurhuliraho okurhwiri n’omugera: anabà mujà wâge ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Erhi omuntu ankaguza omwâli burhumisi-kazi, yêhe arhankalîkwa kula abajà balîkwa. ");
INSERT INTO shr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Erhi ankabà arhasimisizi nnâhamwâbo walicimwishozire, nnâhamwâbo anayêmêra agombôlwe. Ci arhankamuguliza ishanja ly’ihanga, bulya okwo kwanabà nka kulenganya. ");
INSERT INTO shr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Erhi omugala ankabà y’amuhà, anamujirire nk’oku banakômerera okujirira abandi banyere. ");
INSERT INTO shr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Erhi ankamuhirakwo owundi, amanye arhamunyihizagya ebiryo, erhi emyambalo, erhi eby’obuyumpa. ");
INSERT INTO shr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Akabà arhamuhiri ebyo oku binali bisharhu, anacîgendera busha, buzira kujuha igerha. ");
INSERT INTO shr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Owâshûrhe omuntu kuhika okufà, naye anayirhwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ci erhi akabà arhâli alâlîre okumuyîrha, bulya Nyamuzinda walilonzize okumuhira omu maboko gâge, nanamuyêreka aha akwânîne okuyâkira. ");
INSERT INTO shr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ci omuntu walâlira okuyîrha owâbo n’obwenge, onamurhenze ciru n’aha luhêrero lwâni, agendinigwa, afè! ");
INSERT INTO shr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Owashûrhe îshe erhi nnina, ananigwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Owâbakule omuntu, ajimuguza erhi amugwârhe omu mwâge, oyo naye ananigwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Owahehêrere îshe erhi nnina, ananigwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Abantu erhi bankalôngôla, muguma akashûrha owâbo, amuyagaze n’ibuye erhi n’ecifundo, olya wâbo akabà arhafîri, ci agend’ijà aha ncingo, ");
INSERT INTO shr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","akahash’ishubizûka n’okuhika embuga ajà agendera oku kakoma, nyakushûrha erhi amalufuma; ci analyula erya miregerege agezize aha ncingo n’okumubukîsa kuhika afume. ");
INSERT INTO shr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Erhi omuntu ankashûrha omujà erhi omujà-kazi wâge n’akarhi, bakanafira omu maboko gâge, nyakufà anacihôlerwa. ");
INSERT INTO shr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ci erhi bankahembûka, enyuma lya lusiku luguma, erhi ibirhi, barhankacicîholerwa, bulya bali birugu byâge. ");
INSERT INTO shr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Erhi bantu babirhi bankagwârhana balwa, bakahukula omukazi oli izîmi, nyamukazi akamoma, ciru akabà arhafîri, barhegesirwe balyûle nk’olu îba wa nyamukazi anahûnyire, n’oku batwirîrwe n’abacîranuzi. ");
INSERT INTO shr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ci erhi ankafà, bajuhe obuzîne oku buzîne, ");
INSERT INTO shr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","isù oku isù, lîno oku lîno, kuboko oku kuboko, kugulu oku kugulu, ");
INSERT INTO shr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","obuhye oku buhye, ecihulu oku cihulu. ");
INSERT INTO shr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Erhi omuntu ankashûrha isù ly’omujà erhi lya mujà-kazi wâge, akanalisherêza, anabalîke bacîgendere, kubè kubajuha lirya isù lyâbo. ");
INSERT INTO shr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","N’akabà lyàli lîno lya mujà wâge erhi lya mujà-kazi wâge, akûzire, anabalike bacîgendere, kubè kubajuha lirya lîno lyâbo. ");
INSERT INTO shr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Erhi empanzi yankatumirha omuntu, abè mulume erhi mukazi, enamuyîrha, eyo mpanzi enabândwe amabuye, n’enyama yayo erhalîbagwa, ci nn’enkâfu yêhe arhalikwo lubanja. ");
INSERT INTO shr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ci eyo mpanzi erhi yankaba yàkômereraga okutumirhana na nnayo bakazimurhonda, ci yêhe arhashibiriraga okuyilanga, n’erhi yankayîrha omuntu, abè mulume erhi mukazi, eyo mpanzi nayo enabandwe amabuye, na nnayo naye, anayirhwe. ");
INSERT INTO shr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Erhi bankamutwîr’okujuha, anahana birya banamutwirire byoshi omu kugombôla obuzîne bwâge. ");
INSERT INTO shr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Erhi ankabà mwâna-rhabana erhi mwâna-nyere, okwo eryo irhegeko lidesire ko yankanatwirwa. ");
INSERT INTO shr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Erhi empanzi yankatumirha omujà mulume erhi mukazi, nnawâbo empanzi analyule nnâhamwâbo balya bajà mafûndo asharhu ga magerha, n’erya mpanzi enabândwe amabuye. ");
INSERT INTO shr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Erhi omuntu ankaleka iriba buzira kulibwikira, nîsi erhi ahumbe iriba buzira kulibwikira, empanzi kandi erhi endogomi yankarhogeramwo, ");
INSERT INTO shr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","nnalirya iriba ahônge, alyûle nna-cirya cîntu ensaranga, n’ecîntu cifìre aciyôrhane. ");
INSERT INTO shr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Erhi empanzi y’omuntu yankatumirhana n’ey’omulungu, ekanafà, banaguze empanzi ecizîne, bagabâne ensaranga; n’erya efîre nayo banayigabâna. ");
INSERT INTO shr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Akabà kwàli kumanyikîne oku eyo mpanzi ekômerera okutumirhana, na nnayo arhashîbirira okuyilanga anahônge eyindi mpanzi ahâli h’empanzi, n’erya efîre yanabà yâge. ");
INSERT INTO shr_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Erhi omuntu ankazimba empanzi erhi cibuzi, abibâge erhi abiguze, anahônga nkâfu irhanu ahâli h’erya nguma, na bibuzi binni ahâli ha cirya ciguma. ");
INSERT INTO shr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Erhi ecishambo cankagwârhwa carhula enyumpa cikanigwa, ntà lwihôlo oku mukò gwâco. ");
INSERT INTO shr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Erhi ankabà gwàli mûshi, hânabè olwihôlo lw’omukò gwâco. Ecishambo cirhegesirwe cilyûle ebi cazimbaga. Akabà cirhagwêrhi ebi calyûla, canaguzibwa oku mpyûlo y’obushambo bwâco. ");
INSERT INTO shr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ecintu cazimbagwa, empanzi, endogomi erhi cibuzi, cikashângwa cicizîne omu maboko gâge, cirya cintu anahyûle kabirhi. ");
INSERT INTO shr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Erhi omuntu ankayonya ishwa nîsi erhi mizâbîbu, akanaleka ebintu byâge byakera omu ishwa lya bene, analyule eyindi myâka eri minjà kulusha y’omu ishwa lyâge erhi y’omu mizâbîbu yâge. ");
INSERT INTO shr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Erhi omuliro gwankagulumira guyandûkire oku byâsi by’emishûgi gulinde guhama guyokêre engano eri oku bishinga erhi eri hôfi n’okusârûlwa, nîsi erhi ishwa lyâyo, nyakulika gulya muliro anahyûle bulya bokêre anayokêraga. ");
INSERT INTO shr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Erhi omuntu ankagwasa n’okubîsa owâbo ensaranga kandi erhi birugu, bikanazimbirwa emw’olya nyakubîsibwa, erhi ecishambo cankabonekana, cinabihyûle kabirhi. ");
INSERT INTO shr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Akabà ecishambo cirhabonekini, nnanyumpa anajè embere lya Nyamuzinda, lyo bamanya oku arhali ye wazimbire ebirugu by’owâbo. ");
INSERT INTO shr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ehyanâjîrwe kadali, hyoshi, akabà nkâfu, ndogomi, cibuzi, mwambalo erhi ngasi kantu kanahezire koshi kalya bankanaderha mpu: «Nêci kâka», olubanja lunahêkwe embere za Nyamuzinda, n’oyu Nyamuzinda akayagiriza oku ye mubî anahyûle owâbo kabirhi. ");
INSERT INTO shr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Erhi omuntu ankayegeka owâbo endogomi, enkafu, ecibuzi, nîsi erhi cindi cîntu cishwekwa, na cirya cintu cife, civunike nîsi erhi cihêkwe n’abanyazi na ntâye obwîne, ");
INSERT INTO shr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","omwîgasho embere za Nyamuzinda gwanatwa olubanja. Erhi nyakuyêgekwa ankacîgasha oku arhazimbaga ecirugu c’owâbo, nnacirya cintu anayêmêra, naye owâbo arhankacilyûla bici. ");
INSERT INTO shr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ci erhi akabà cirya cîntu aha mwâge cazimbirwe, anacihyûla naco. ");
INSERT INTO shr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Akabà ecintu cayisirwe n’eciryanyi, anagend’icîyêrekana buhamîrizi; arhankahyûla bici kuli cirya cîntu ciyisirwe n’eciryanyi. ");
INSERT INTO shr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Erhi omuntu ankayegeka owâbo ecîntu câge, cikayagalika erhi kufà na nnaco arhahali, akwânîne acilyûle. ");
INSERT INTO shr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ci erhi nnaco ankabà ahâli, arhankacilyûla bici. Akabà càli cihozanyo, analyûle engulo ya kulya kuhôza. ");
INSERT INTO shr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Erhi omulume ankashumika omwâna-nyere mushugi orhasâg’ishebwa, akanagwîshira bombi naye, olya mulume anamugule abè mukâge. ");
INSERT INTO shr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Erhi îshe w’omunyere ankalahira bwâmuhâye, olya mulume analyule ensaranga bahâna ngulo y’abâna-nyere bashugi. ");
INSERT INTO shr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Omukazi w’omukurûngu, orhahîraga wamulekera akalamo mpu alame. ");
INSERT INTO shr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ngasi yêshi wâhushe oku cîntu anayirhwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Owarherekêre nyamuzinda w’obwîhambe, kuleka Nyakasane yênene, anakagwe. ");
INSERT INTO shr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Orhahîra okarhindibuza erhi kugonya-gonya ecigolo, bulya ninyu mwâli bigolo omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Orhahîra okalibuza omukana nîsi erhi enfûzi. ");
INSERT INTO shr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Erhi wankamulibuza, akandakira, namâyumva omulenge gwâge. ");
INSERT INTO shr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Oburhè bwâni bwanayâka mmuyirhe n’engôrho, bakînywe bahinduke bakana n’abâna binyu babè nfûzi. ");
INSERT INTO shr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Okahôza ow’omu lubaga lwâni ensaranga, mukenyi oli akâwe, orhamujiriraga ihanzè, orhamulongezagyakwo bunguke. ");
INSERT INTO shr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Erhi wankarhôla ecirondo c’owinyu cikînja, onamugalulireco câjîngwè, izûba lirhacizonga, ");
INSERT INTO shr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","bulya bwo bushiro bwâge obwo bônene, co cishûli cibwika omubiri gwâge. Bicigi yeki ankayîsh’ilalamwo? Erhi ankayîsh’indakira nanamuyumva, bulya niehe mbà wa lukogo. ");
INSERT INTO shr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Orhahîra okalogorhera Nyamuzinda, orhanahîra okahehêrera omuluzi w’ishanja lyâwe. ");
INSERT INTO shr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Emyâka yâwe n’omurhobo gw’omu mukenzi gwâwe, orhahîraga okaleka abandi babintangakwo. Okaz’interekêra enfula y’omu bagala bâwe. ");
INSERT INTO shr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Okaz’injirira ntyo oku bishwêkwa byâwe binene n’ebisungunu, orhabirhenzagyakwo nnina wabyo embere lya nsiku nda, oku lusiku lwa kali munâni, omunterekêre. ");
INSERT INTO shr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Muyôrhe bimâna embere zâni! Murhahîraga mukalya enyama yayirhagwa n’ec’erubala, munayikwêbe akabwa. ");
INSERT INTO shr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Orhakag’ilumîza emyanzi y’obunywesi. Orhakâg’irhabâla omubî omu kuhamîriza obunywesi. ");
INSERT INTO shr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Orhakâg’ishimba omwandu gw’abantu balonza amabî, orhanahîra okafûngira olubanja lw’obubî mpu ly’ojà olunda banji bali. ");
INSERT INTO shr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Orhakâg’irhabala omuntu omu lubanja mpu okwenge ali mukenyi. ");
INSERT INTO shr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Erhi wankashimâna enkafu y’omushombanyi wâwe, erhi ndogomi yâge ehabusire onamulerhereyo. ");
INSERT INTO shr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Erhi wankabona endogomi y’omushombanyi wâwe egogomîrwe n’omuzigo, ahâli h’okucîgerera, onayirhabale mwene nnayo. ");
INSERT INTO shr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Orhahîraga okalenganya owinyu oli mukenyi omu lubanja lwâge. ");
INSERT INTO shr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Okaz’iyakira kuli olubanja lw’obunywesi. Orhahîra okayîrha omwêru kwêru erhi omushinganyanya, bulya ntayêza omuntu mubî. ");
INSERT INTO shr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Orhahîra, okayemera ebituliro, bulya ebituliro binahûse amasù g’ababona, bihindule n’ebinwa by’abashinganyanya. ");
INSERT INTO shr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Orhahîraga okarhindibuza ecigolo, orhahabiri wênene oku ecigolo cirhindibuka, bulya nâwe wêne wali cigolo omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Okaziyûsa myâka ndarhu warhwêra ishwa n’okusârûla emyâka yâwe. ");
INSERT INTO shr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ci ogwa kali nda onalileke lilâle, abakenyi bw’omu ishwa lyâwe balye emburho zirimwo, n’ebyankasigala ensimba z’erubala zibirye. Ntyo kwo wakazijira olukoma lwâwe lw’emizêti yâwe. ");
INSERT INTO shr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Omu nsiku ndarhu wakazijira emikolo yâwe, ci olwa kali nda, wanarhamûka, ly’enkâfu yâwe n’endogomi yâwe birhamûka, lyo na mugala wa mwabali-kazi wâwe n’ecigolo bayîsa. ");
INSERT INTO shr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Obikirire ngasi byoshi nakubwizire. Orhahîraga okashênga izîno ly’abandi ba-nyamuzinda, irhondo lirhayumvikanaga omu kanwa kâwe. ");
INSERT INTO shr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Okaz’inkuza omu kujira olugendo lutagatîfu kasharhu omu mwâka. ");
INSERT INTO shr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Okaz’ijira olusiku lukulu lw’emigati erhalimwo lwango. Okâgeza nsiku nda erhi odwîrhe walya emigati erhalimwo lwango, nka kulya nakurhegekaga, omu mwêzi gw’emihuli, bulya gwo mwêzi warhengagamwo e Mîsiri. Ntâye wanayîshe embere zâni maboko mûmu. ");
INSERT INTO shr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Okâjira olusiku lukulu lw’emyâka mirhanzi-rhanzi y’omu maboko gâwe, lw’ebi warhwêraga omu mashwa. N’olusiku lukulu lw’okusârûla, aha buzinda bw’omwâka, amango wahûmbûle amalehe gw’omukolo gw’omu mashwa gâwe. ");
INSERT INTO shr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kasharhu omu mwâka, ngasi mulume ayish’ikâlola obusù bwa Nnâmahanga Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Orhahîraga okanterekêra emigati erimwo olwango n’embâgwa; n’amashushi g’embâgwa z’olusiku lukulu lwâni, garhagezagya obudufu kuhika sêzi. ");
INSERT INTO shr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Okaz’irhûla emyâka mirhanzi-rhanzi y’ishwa lwâwe omu ka-Nyamuzinda, Nnâmahanga wâwe. Orhahîraga okayendera omwâna-hene omu mahene-hene ga nnina. ");
INSERT INTO shr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Nârhuma malahika wâni embere zâwe aj’akulanga omu njira, anakuhise ahantu narheganyize. ");
INSERT INTO shr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","“Omukenge, onakaz’iyumvîrhiza izù lyâge; orhamugayaguzagya, bulya arhankalembera obugamba bwâwe, kulya kubà izîno lyâni liri muli ye”. ");
INSERT INTO shr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Okâyumvirhiza izù lyâge onakâjira ebi ndesire byoshi, nâbà mwânzi w’abanzi bâwe na mushombanyi w’abashombanyi bâwe”. ");
INSERT INTO shr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Hano malahika wâni abà amakushokolera, àbà amâkuhisa emw’Abamoriti, Abahititi, Abapereziti, Abakanani, emw’Abahiviti n’Abayebusi, hano mbà nabahungumwire”, ");
INSERT INTO shr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“orhacikâgihîra wafukamira ba nyamuzinda bâbo, ci oyishihenangula abo ba nyamuzinda bâbo n’okujonjaga empêro zâbo”. ");
INSERT INTO shr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Okarhumikira Nyakasane Nyamuzinda wâwe, anagisha ebiryo byâwe n’amîshi gâwe, nnankucînge kuli ngasi ndwâla;” ");
INSERT INTO shr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","“omu cihugo câwe murhakaboneka omukazi omomire erhi owabà ngumba: nayunjuza ensiku z’akalamo kâwe”. ");
INSERT INTO shr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Narhuma ecôbà câni embere zâwe, nshandabanye ngasi mashanja wanageremwo, abashombanyi bâwe boshi bakuyaka”. ");
INSERT INTO shr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","“Narhuma olwisîmbo embere zâwe, lulibirhekwo Abahiviti, Abakanani n’Abahititi embere zâwe”. ");
INSERT INTO shr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","“Ntâbalibirhekwo embere zâwe oku câligumiza omu mwâka muguma, lyo ecihugo cirhagisigala bwâmwa, lyo n’ebiryanyi bilekiluga, bikurhindibuze”. ");
INSERT INTO shr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","“Bunyi-bunyi nakazibalibirhakwo embere zâwe, kuhika amango wâyololoka ohashe okulya ecihugo coshi”. ");
INSERT INTO shr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Nâtwa olubibi lw’ecihugo câwe kurhenga oku Nyanja Ndukula kuhika oku Nyanja y’Abafilistini, na kurhenga oku irungu kuhika oku lwîshi. Nêci, nahira bene ecihugo omu maboko gâwe, nnambakungushe embere zâwe.” ");
INSERT INTO shr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Orhahîraga okanywâna mweshi nabo nîsi erhi mwe na banyamuzinda bâbo”. ");
INSERT INTO shr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","“Barhayûbake omu cihugo câwe, lyo barhagirhuma wangomera: wankanabona wamarhumikira banyamuzinda bâbo, n’okwo kukuhindukire murhego.”» ");
INSERT INTO shr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Anacibwîra Mûsa, erhi: «Sôkera emunda Nyakasane ali, nâwe Aroni mwene Nadabu n’owinyu Abihu, mweshi na bandi bagula makumi gali nda ga muli Bene Israheli, muyishifukama kûli. ");
INSERT INTO shr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mûsa yênene wayegêra hali Nyakasane; bôhe barhayegêraga, n’olubaga lurharheremaga haguma naye.» ");
INSERT INTO shr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mûsa anaciyisha, ashambâlira olubaga ebyo binwa bya Nyakasane byoshi n’amarhegeko gâge goshi. Olubaga lwoshi lwanacishuza n’izù liguma, mpu: «Ebinwa Nyakasane anadesire byoshi, rhwabishimba.» ");
INSERT INTO shr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mûsa anaciyandika ebinwa bya Nyakasane byoshi; àzûka sêzi mucêracêra, ayûbaka oluhêrero idako ly’entondo na mabuye ikumi n’abirhi g’erya milala ikumi n’ibirhi y’Israheli. ");
INSERT INTO shr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Okubundi, anacirhuma abâna b’emisole ba muli Bene Israheli baj’irhûla embâgwa banarherekêra emicûkà y’empanzi nka nterekêro y’okushangîra. ");
INSERT INTO shr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mûsa ayanka ecigabi c’omukò, aguhemba oku rhubehe n’ogwasigalaga agushahuliza oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Arhôla ecitabu c’Endagâno acisomera olubaga. Nalwo lwashuza, mpu: «Ebyo Nyakasane adesire byoshi rhwabishimba, rhunabikenge». ");
INSERT INTO shr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mûsa arhôla omukò agushahuliza olubaga, erhi: «Ogu mukò gwo mukò gw’Endagâno Nyakasane afundisire haguma n’ebyo binwa byoshi.» ");
INSERT INTO shr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mûsa anacisôka bône Aroni, Nadabu na Abihu, boshi na balya bashamuka makumi gali nda b’omu bagula b’Israheli. ");
INSERT INTO shr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Babona Nyamuzinda w’Israheli, n’aha magulu gâge erhi hali nka kuno harhîndwa ecirhindiro ciri nka njuma ya kâsi eshusha ecitù c’oku nkuba. ");
INSERT INTO shr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ntà kubî àjizire abo bîshogwa b’omu Israheli, basinza Nyakasane, balya bànanywa. ");
INSERT INTO shr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nyakasane anacibwîra Mûsa, erhi: «Osôkere e munda ndi kuno ntondo onabêrekwo, nkuhè embaho z’ibuye zirikwo amarhegeko n’amahano nyandisire, nti ogayigîrize.» ");
INSERT INTO shr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mûsa anaciyimuka, bo n’omurhabâzi wâge Yozwè. Mûsa anacisôkera oku ntondo ya Nyamuzinda, ");
INSERT INTO shr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","erhi amàsiga abwîzire abagula erhi: «Murhulindire hano, kuhika rhugaluke. Ci Aroni na Huri bâbà basigîre ninyu; owâbè agwêrhe olubanja, anabadôse.» ");
INSERT INTO shr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mûsa anacisôkera oku ntondo. Ecitù cabwika entondo. ");
INSERT INTO shr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Irenge lya Nyamubâho lyàbêra oku ntondo ya Sînayi, eco citù cayibwika nsiku ndarhu zoshi. Olusiku lwa kali nda, anacihamagala Mûsa omu kâgarhî ka cirya citù. ");
INSERT INTO shr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Irenge lya Nyakasane lyàkâg’ibonekera bene Israheli nka ngulumira ya muliro ah’irhwèrhwè ly’entondo. ");
INSERT INTO shr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mûsa ayongobera mulya citù, asôkera oku ntondo miregerege makumi anni na madufu makumi anni. ");
INSERT INTO shr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nyakasane anaciganiza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Obwîre bene Israheli basholôle entûlo, ngasi bantu b’omurhima mwinjà boshi, ojè warhôla ezo nsholôlo zâbo. ");
INSERT INTO shr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Alaga ensholôlo wabahûna: amasholo, amarhale, emiringa, ");
INSERT INTO shr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","emyenda y’akaduku, ey’omusengu, ecitàni calangashana, eswa, obwôya bw’empene, ");
INSERT INTO shr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","empù z’ebigandabuzi z’akalinga, empù z’ebigoho n’emirhi y’akasiya, ");
INSERT INTO shr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","amavurha gw’okuhira omu rhumole, omugavu gw’okuhira omu mavurha g’okucîshîga n’obukù bw’okuyôca. ");
INSERT INTO shr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Amabuye ga Onikisi n’amabuye g’okuj’omu efodi n’omu mwambalo g’oku cifuba. ");
INSERT INTO shr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Onjirire endâro lyo nkazibêra ekarhî kinyu. ");
INSERT INTO shr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nienene nakuyêreka olugero lw’ecihando n’olugero lw’ebirugu byamwo byoshi: okwo kwonênè kwo wânajira.» ");
INSERT INTO shr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Onjirire omucîmba gw’embaho za akasiya, gwa buli bwa makoro abirhi n’ecihimbi, bugali bw’ikoro liguma n’ecihimbi, na burherema bw’ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","“Ogushîge amasholo garhali mavange, ogushige omu ndalâlà n’emugongo, n’omuhiro gwâgwo oguzunguluse masholo”. ");
INSERT INTO shr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","“Ogutulire mpogo inni za masholo, ozihire omu magulu gâgwo oku ganali anni, mpogo ibirhi lunda luguma n’ibirhi olundi lunda”. ");
INSERT INTO shr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","“Ojire emirhamba y’emirhi ya akasiya, oyishîge amasholo”, ");
INSERT INTO shr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","“onayishesheze omu mpogo z’amarhambi g’omucîmba, gukazibarhulirwâkwo”. ");
INSERT INTO shr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","“Emirhamba ebêre omu mpogo z’omucîmba, erhakûlagwamwo”. ");
INSERT INTO shr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“Endagâno nakuhà oyibîke muli ogwo mucîmba.” ");
INSERT INTO shr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Okubundi ogujirire omufûniko gw’amasholo gône gône, buli bwa makoro abirhi n’ecihimbi na bugali bw’ikoro liguma n’ecihimbi”. ");
INSERT INTO shr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","“Ojire bakerubi babirhi ba masholo; obatulire oku marhambi gombi gw’ogwo mufuniko”. ");
INSERT INTO shr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","“Ohire kerubi muguma eburhambi buguma n’owundi ajè ebundi burhambi. Obahire oku muhiro gw’omufûniko, omu marhambi gombi”. ");
INSERT INTO shr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","“Ebyûbi by’abôla bakerubi bishanjûkire enyanya, bakaz’ibwîkira omufûniko n’ebyûbi byâbo bayerekerane bombi, bakazilola ebwa mufuniko”. ");
INSERT INTO shr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“Ohire omufûniko enyanya ly’omucîmba n’omwo mucîmba mwo wahira Endagâno nâkuhà”. ");
INSERT INTO shr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","“Aho, ho nakâbugânana nâwe, ho nakâkuganîriza, enyanya ly’omufûniko, ekarhî k’abo bakerubi babirhi bali oku mucîmba gw’Endagâno, nkâkubwîra byoshi ntegesire Bene Israheli.”» ");
INSERT INTO shr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kandi ojire ameza gw’omurhi gwa akasiya, gwa buli bwa makoro abirhi, bugali bw’ikoro liguma, na burhererema bw’ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ogashîge amasholo garhalimwo nvange, ogutâke n’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Okwo muhiro, obinjûlekwo emikororonzi ya bugali bwa cihimbi c’ikoro, onazunguluse emikororonzi y’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ogajirire mpogo inni za masholo, zije oku bikwi binni by’amagulu gâbo oku ganali anni. ");
INSERT INTO shr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ezo mpogo zije omu marhambi g’amagulu gâgo oku ganali anni, zikazijageramwo emirhamba y’okubarhula ameza. ");
INSERT INTO shr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Eyo mirhamba oyijire n’omurhi gwa akasiya, oyishîge amasholo, ekazikolesibwa oku kubarhula ameza. ");
INSERT INTO shr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ameza ogajirire embale, ennambi, orhubêhè, enzînzi n’ebyânzi, byo bakaz’idubuliramwo enterekêro z’ebinyôbwa. Byoshi obijire bya masholo garhali mavange. ");
INSERT INTO shr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Okaziyôrha ohizire ensiku zoshi omugati gw’enterekêro okwo mêza, embere zâni. ");
INSERT INTO shr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Kandi ojire akamole k’amasholo garhali mavange. Ako kamole, katulwe kalungire n’enteberhebe yako n’olusârhi lwâko, haguma n’amashami, ebigonyero n’obwâso bwâko. ");
INSERT INTO shr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Mahaji ndarhu garhenge omu marhambi gako: mahaji asharhu g’akamole eburhambi buguma na mahaji asharhu g’akamole ebundi burhambi. ");
INSERT INTO shr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Oku ngasi ihaji kuje mahaji asharhu galikwo amafufu n’obwâso. Ntyo kwo mahaji ndarhu garhenga omu kamole gajirwa gwoshi. ");
INSERT INTO shr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Nako akamole kône, kabè na mashami anni haguma n’amafufu n’obwâso bwâgo: ");
INSERT INTO shr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ifufu liguma omu mahaji abirhi marhanzi garhenga omu kamole, ifufu liguma omu gandi mahaji abirhi garhenga omu kamole, n’ifufu liguma omu mahaji abirhi mazinda garhenga omu kamole kwo n’okwo oku mahaji ndarhu goshi g’akamole. ");
INSERT INTO shr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Amafufu n’amahaji bilungîne n’akamole, byoshi bibè bitule muli cûma ciguma ca masholo garhali mavange. ");
INSERT INTO shr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ojire rhumole nda: bakaz’iyâsa orhwo rhumole, rhumolekere embere n’eburhambi. ");
INSERT INTO shr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ennâmbi zako n’amaganyi gakwo, byoshi bibè bya masholo gônene. ");
INSERT INTO shr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Bagajire na talenta nguma ya masholo gône gône, haguma n’ebigabi byako byoshi. ");
INSERT INTO shr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Olole bwinjà onajire nk’oku oyeresirwe oku ntondo. ");
INSERT INTO shr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Endâro oyijire ya birhebo ikumi, obijire bya citâni ciniole n’emyenda y’akaduku k’omukara, ey’akaduku k’akalinga, ey’akalinga kêru ohirekwo ba-kerubimi bakozirwe n’obulenga. ");
INSERT INTO shr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","“Obulî bwa ngasi cirhebo bubè bwa makoro makumi abirhi na munâni, n’obugali bubè bwa makoro anni. Olwo, lwo lugero lw’ebirhebo byoshi”. ");
INSERT INTO shr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","“Birhebo birhanu bilungwe ngasi ciguma oku câbo”. ");
INSERT INTO shr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","“Ohire emishumi oku muhiro gw’ecirhebo cirhanzi, oku kampwempwe k’obulungîro, onajire ntyo oku muhiro gw’ecirhebo cizinda c’obulungîro bwa kabirhi”. ");
INSERT INTO shr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","“Ohire mishumi makumi arhanu oku cirhebo cirhanzi, na mishumi makumi arhanu oku kampwe-mpwe k’ecirhebo c’obulungîro bwa kabirhi, eyo mishumi ekâyêrekerana ngasi muguma n’ogwâbo”. ");
INSERT INTO shr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","“Ojire mîno makumi arhanu ga masholo, go galunga ngasi cirhebo oku câbo, na ntyo Endâro ebè ya bûbake buguma bwône”. ");
INSERT INTO shr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Kandi ojire ebirhebo by’amôya g’empene, oyûbakemwo ecihando enyanya z’Endâro. Ojire ikumi na ciguma”. ");
INSERT INTO shr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","“Obulî bwa cirhebo ciguma: makoro makumi asharhu. Obugali bw’ecirhebo: makoro anni. Lwo na lugero lw’ebirhebo byoshi oku binali ikumi na ciguma”. ");
INSERT INTO shr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","“Ohangire birhebo birhanu haguma, na bindi ndarhu haguma. Ecirhebo ca kali ndarhu ocigonyere embere z’ecihando”. ");
INSERT INTO shr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","“Ohire mishumi makumi arhanu oku muhiro gw’ecirhebo cibwisire birya birhangiriza bigwârhîne na yindi mishumi makumi arhanu oku muhiro gw’ecirhebo cibwisire birya bindi bya kabirhi bigwârhîne”. ");
INSERT INTO shr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","“Ojire mîno makumi arhanu ga mulinga, ogageze omu mishumi, na ntyo gashwêke ecihando coshi cibè bûbake buguma”. ");
INSERT INTO shr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","“Ecihimbi c’ebirhebo by’ecihando cisigîre, cijêmbukire enyuma ly’endâro”. ");
INSERT INTO shr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","“N’ebwa buli bw’ebyo birhebo by’ecihimbi cisigîre cije lunda luguma n’olundi oku buli bw’ebirhebo, kandi bijêmbukire oku ntambi zombi z’endâro, bibwîkîre olunda n’olundi lw’endâro”. ");
INSERT INTO shr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Eco cihando ocijirire oburhungiri bw’empù z’enganda-buzi, zishîzirwe ibala lidukula, n’oburhungiri bw’empù mvunge zinozire bujè oku nyanya.”» ");
INSERT INTO shr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Ojire omutûngo gw’Endâro gubè gwa murhi gwa akasiya, mugwike burherema. ");
INSERT INTO shr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","“Obulî bwa ngasi mutûngo bubè bwa makoro ikumi, n’obugali bw’ikoro liguma n’ecihimbi”. ");
INSERT INTO shr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","“Ngasi mutûngo gubè na mahango abiri galungîne ngasi ihango omu lyâbo. Kwo onajirage ntyo oku yindi mitûngo y’Endâro yoshi”. ");
INSERT INTO shr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","“Ojire lukangà lw’okushwêka n’okusêza Endâro, mirhi makumi abirhi ya lukangà olunda lw’emukondwè”. ");
INSERT INTO shr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","“Eyo mitûngo oku eri makumi abirhi, oyihirekwo marhwêrhwè anni ga marhale: marhwêrhwè abirhi oku ngasi murhi”. ");
INSERT INTO shr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","“Olunda lwa kabirhi lw’Endâro, emwênè, ohire yo mitûngo makumi abirhi”; ");
INSERT INTO shr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","“nayo ejekwo marhwêrhwè makumi anni ga marhale, marhwêrhwè abirhi oku ngasi mutûngo gw’olukangà”. ");
INSERT INTO shr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","“Enyuma ly’Endâro, ebwa nyanja, ohireyo mitûngo ndarhu ya lukangà”, ");
INSERT INTO shr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","“ojire mitûngo ibirhi ebuzinda bw’Endâro, oku kafende-fende”. ");
INSERT INTO shr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","“Eyo mitûngo, eshwekane ibirhi-ibirhi kurhenga idako kuhika enyanya aha bushwinjiro omu mpâga ntanzi. Ntyo, kwo eyo mitûngo ibirhi y’oku kafende-fende yayôrha”. ");
INSERT INTO shr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","“Ntyo, habà mitûngo munâni n’amarhwèrhwè gâyo g’amarhale: marhwêrhwè ikumi na ndarhu, abirhi oku muntûngo muguma n’abirhi kuli ngasi gundi mutûngo”. ");
INSERT INTO shr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kandi ojire n’emirhamba y’omurhi gwa akasiya: irhanu oku mitûngo y’olundi lunda lw’Endâro”, ");
INSERT INTO shr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","“irhanu oku mitûngo eri oku kafende-fende k’Endâro, olunda lw’enyanja”. ");
INSERT INTO shr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","“Omurhamba gw’engusu gushwêkerwe aha kâgarhî k’emitûngo, gurhulukâne kurhenga ebuzinda kuhika obundi buzinda”. ");
INSERT INTO shr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“Emitûngo y’lukangà oyishîge amasholo, empagà z’okuhiramwo emirhamba, ozijire za masholo, n’emirhamba nayo oyishîge masholo”. ");
INSERT INTO shr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Oyûbake eyo Ndâro nka kulya wayêrekagwa oku ntondo.”» ");
INSERT INTO shr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Kandi ojire omwenda gw’akaduku k’omukara, n’akaduku k’akalinga, n’akalinga kêru, n’ecitâni ciniole; bahirekwo bakerubimi bakozirwe n’obulenga. ");
INSERT INTO shr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","“Ogumanike kuli mitûngo inni ya murhi gwa akasiya mishîge amasholo, egwêrhe ngondôzo z’amasholo zigwârhîne oku marhwêrhwè anni g’amarhale”. ");
INSERT INTO shr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","“Ogwo mwenda gugwarhwe n’amîno g’ebirhale, n’omu ndalâlà yago, mwo mwahira omucîmba gw’Endagâno. Ogwo mwenda lwo lwâbà lubibi lw’Abatagatîfu n’Ahatagatîfu h’Ebitagatîfu”. ");
INSERT INTO shr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Ohire omufûniko oku mucîmba gw’Endagâno omu Hatagatîfu h’Ebitagatîfu”. ");
INSERT INTO shr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“Amêza ogahire embere ly’ogo mwenda, n’akamole aha mbêre lya mêza, olunda lw’emukondwè lw’Endâro. Ohire amêza olunda lw’ebumosho”. ");
INSERT INTO shr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Kandi ohire omwenda aha muhango gw’ecihando, mwenda gwa kaduku k’omukara, kaduku k’akalinga, kaduku-kêru n’ecitâni ciniole: mukolo gwa muntu mulenga”. ");
INSERT INTO shr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","“Ogwo mwenda gugwârhire kuli mitûngo irhanu y’omurhi gwa akasiya, onayishîge amasholo. Engondôzo zâyo zibè za masholo, onazitulirekwo marhwêrhwè arhanu ga mulinga.”» ");
INSERT INTO shr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ojire oluhêrero lw’embaho za akasiya: buli bwa makoro arhanu na bugali bwa makoro arhanu; obulî n’obugali bw’oluhêrero binyumanane. Na makoro asharhu burherema. ");
INSERT INTO shr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Orhumpekwèmpekwè rhwâlwo oku rhunali rhunni, ohirekwo mahembe anni gashwekine narhwo, rhunabè rhwa mulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ojire embêhe z’okugukiramwo oluvù lw’oku luhêrero, empaho z’okuguka oluvù, amabakuli, orhukanya n’ebitumbûkizo. Ebyo byoshi obitule n’omulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Oyûbakire olushangi luli nka lusirha lwa mulinga oku luhêrero; olujirire mpogo inni za mulinga oku bikwi byâlwo oku biri binni. ");
INSERT INTO shr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ohire olwo lushângi omu ndalâlà y’oluhêrero idako, luhike omu karhî k’obulî bw’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ojire emirhamba y’oluhêrero, mirhamba ya murhi gwa akasiya, onayishîge omulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Eyo mirhamba bakâyishesheza omu mpogo, ekazigera enyunda zoshi oku zinali ibirhi z’oluhêrero nka balubarhula. ");
INSERT INTO shr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Olubinjûle nka mukenzi, onalujire nka lwa mbaho. Kukwânîne olujire nka kulya wanayêrekagwa oku ntondo. ");
INSERT INTO shr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kandi ojire obululi bw’Endâro, olunda lw’ebulyo, emukondwè, obululi bubwikwe n’emyanda y’ecitâni ciniole, ya buli bwa makoro igana ngasi lunda. ");
INSERT INTO shr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Emitungo yabwo oku enali makumi abirhi, n’amarhwèrhwè gâyo, bibè bya mulinga. Engondôzo z’eyo mitûngo n’amaganyi gâyo, bibè bya cirhale. ");
INSERT INTO shr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kwo n’okwo olunda lw’emwênè, nayo eje emyenda ya makoro igana oku bulî, emitûngo yayo oku enali makumi abirhi, n’amarhwèrhwè gâyo oku ganali makumi abirhi, bibè bya mulinga, engondôzo zâyo n’amaganyi gâyo, bibè bya cirhale. ");
INSERT INTO shr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Obugali bw’obululi, olunda lw’enyanja, bwâbà bwa makoro makumi arhanu ga myenda, n’emitungo yayo oku eri ikumi n’amarhwèrhwè gâyo oku ganali ikumi. ");
INSERT INTO shr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Obugali bw’obululi, olunda lw’ebushoshôkero bw’izûba (ebuzûka-zûba): makoro makumi arhanu; ");
INSERT INTO shr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","myenda ya makoro ikumi n’arhanu, na mitûngo isharhu na marhwêrhwè gâyo asharhu oku kahembe kaguma; ");
INSERT INTO shr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","oku kandi kahembe, myenda ya makoro ikumi n’arhanu, n’emitûngo yayo oku eri isharhu na marhwêrhwè gâyo asharhu. ");
INSERT INTO shr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Aha muhango gw’obululi, haje omwenda gwa makoro makumi abirhi, gwa kaduku k’omukara, kaduku k’akalinga, kalinga k’akêru, n’ecitâni ciniole; mukolo gwa bulenga, gugwârhire kuli mitûngo inni na marhwêrhwè anni. ");
INSERT INTO shr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Emitûngo eyûbasire obululi yoshi, ebè elungîne omu mpagà z’amarhale; engondôzo zâyo zibè za marhale; n’amarhwèrhwè gâyo gabè ga mulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Obulî bw’obululi: makoro igana, obugali: makumi arhanu kuli ngasi cikwi, oburherema: makoro makumi arhanu ga citâni ciniole; amarhwèrhwè gabè ga mulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ngasi bindi birugu by’omu Ndâro byoshi, birya byanakolesibwa oku mikolo yamwo yoshi, makondo gâyo n’amakondo g’obululi, bibè bya mulinga. ");
INSERT INTO shr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Woyo orhegeke bene Israheli bakazikulerhera amavurha g’emizêti mishwe g’okutwana akamole, garhalimwo nvange, lyo akamole kakaziyôrha kayâsire ensiku n’amango. ");
INSERT INTO shr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Omu Cihando c’Ihano, embere ly’omwenda gubwisire Endagâno, Aroni n’abagala bakaziyôrha baliyasize embere za Nyakasane kurhenga bijingo kuhika sêzi. Liri irhegeko ly’ensiku n’amango kuli bene Israheli kurhenga iburha kujà oku lindi. ");
INSERT INTO shr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ci w’oyo, muli bene Israheli, oyegeze aha burhambi bwâwe mwene winyu Aroni ye n’abagala, omujire mudâhwa wâni: Aroni, Nadabu, Eleyazari na Itamara, bagala ba Aroni. ");
INSERT INTO shr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mwene winyu Aroni omujirire omwambalo Mutagatîfu, cibè cimanyîso c’irenge na ca kukengwa. ");
INSERT INTO shr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Obwîre ngasi bantu balenga balya bayunjwîre omûka gw’oburhimanya nabahiziremwo, bajirire Aroni emyambalo yamujira Mutagatîfu na mudâhwa wâni. ");
INSERT INTO shr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Alaga emyambalo bajira: omwambalo gw’oku cifuba, efodi, ecishûli citâke, akanzo, ecitambara n’omukaba. Bajirire Aroni, mwene winyu, n’abagala emyambalo mitagatîfu, lyo akaz’injirira emikolo y’obudâhwa. ");
INSERT INTO shr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bakolêse amasholo, akaduku k’omukara, akaduku k’akalinga, akaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bajire efodi y’amasholo, ya kaduku ka mukara, kaduku ka mulinga, kaduku kêru n’ey’ecitâni ciniole: mukolo gwa bulenga. ");
INSERT INTO shr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kandi cibè na maganyi abirhi g’okugwâsa oku mihiro yombi. ");
INSERT INTO shr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Omusiho gw’efodi gugezire enyanya, gukolwe kuguma nayo gunalungane nayo: gubè gwa masholo, gwa kaduku k’omukara, gwa kaduku k’akalinga, gwa kaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Orhôle mabuye abirhi ga onikisi, oyandikekwo amazîno ga Bene Israheli: ");
INSERT INTO shr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","amazîno ndarhu oku ibuye lirhanzi, n’agandi ndarhu oku ibuye lya kabirhi, nk’oku banakulikirana omu maburhwa gâbo. ");
INSERT INTO shr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ago mabuye wahirakwo amazîno ga Bene Israheli, gakolwe n’omulenga oyishi okubinjûla amabuye, nka kula banabînjûla eciziriko, ogabohere omu mpogo z’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ago mabuye gombi, ogahire oku mishumi y’efodi, gabè mabuye ga kuyibusa amazîno ga Bene Israheli. Ntyo Aroni akaz’ihêka amazîno gâbo embere za Nyakasane oku birhugo byâge byombi, lyo akaz’ibayibuka. ");
INSERT INTO shr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ojire mburungusè ibirhi za masholo, ");
INSERT INTO shr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na migufu ibirhi ya masholo gône gône, oyijire mihûnge nsobekanyè, egere mw’ezo mburungusè. ");
INSERT INTO shr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ojire n’enshoho y’oku cifuba y’okutwa emmanja, mukolo gwa bulenga. Oyijire nka kulyâla wanajira efodi: ya masholo, ya kaduku ka mukara, ya kaduku ka kalinga, ya kaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Nka yamâgonywa, eyumânane enyunda zoshi, ya buli bwa cihimbi c’ikoro na bugali bwa cihimbi c’ikoro. ");
INSERT INTO shr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Oyilukirekwo emilongo y’orhubuye, milongo inni ya rhubuye. Oku mulongo murhanzi kulukirwe esadoniki, etopazi n’esumarado; ");
INSERT INTO shr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","oku mulongo gwa kabirhi, ohirekwo enofeki, esafira n’ealimasi; ");
INSERT INTO shr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","oku mulongo gwa kasharhu ohirekwo, enjwîjwî, eagata n’eamatusta; ");
INSERT INTO shr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","oku mulongo gwa kani kulukirwe ekrizoliti, ehyasinti n’eyaspiri. Orhwo rhubuye rhuhangirwe omu mpogo z’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ago mabuye gayandikwekwo amazîno ga Bene Israheli ikumi na babirhi, gabè matâke nka biziriko, ngasi ibuye n’izîno, kulya emilala enali ikumi n’ibirhi. ");
INSERT INTO shr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Enshoho y’oku cifuba oyijirire emigufu y’amasholo garhalimwo mvange miluke nka migozi. ");
INSERT INTO shr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Enshoho y’oku cifuba oyijirire rhugondo rhubirhi rhwa masholo garhaliwo mavange, n’orhwo rhugondo oku rhunali rhubirhi orhushwekere oku mihiro yarho yombi. ");
INSERT INTO shr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Orhwo rhugozi rhw’amasholo rhwombi orhugeze mw’orhwo rhugondo rhubirhi rhushwekirwe oku bushwinjiro bw’enshoho y’oku cifuba. ");
INSERT INTO shr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nabyo ebikwi by’orhwo rhugufu rhwombi, bishwêkerwe kuli zirya mburungusè zombi, oku mishumi y’efodi, embere zâyo. ");
INSERT INTO shr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ojire mpogo ibirhi za masholo ozihire oku bushwinjiro bw’enshoho y’oku cifuba, oku muhiro gw’endalâla, olunda lw’efodi. ");
INSERT INTO shr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ojire zindi mpogo ibirhi za masholo, ozihire idako ly’ebirhugo-rhugo by’efodi, olunda lw’embere, hôfi n’obugonyero bwâyo, enyanya ly’omushumi gw’efodi. ");
INSERT INTO shr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Bashwêkere empogo z’enshoho oku mpogo z’efodi n’ehigozi hy’akaduku k’omukara, ebêre enyanya ly’omushumi gw’efodi n’enshoho y’oku cifuba esêre oku efodi. ");
INSERT INTO shr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ntyo, amango Aroni akazija omu hatagatîfu, akazihêka amazîno ga Bene- Israheli aha murhima gwâge omu nshoho y’oku murhima y’okutwa emmanja, lyo bakâyôrha bayibuka ensiku zoshi embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Omu nshoho y’oku cifuba y’okutwa emmanja ohiremwo Urimi na Tumini, bikazibêra aha murhima gwa Aroni amango ajà embere za Nyakasane. Aroni akazihêka ntyo ensiku n’amango olubanja lwa Bene Israheli aha murhima gwâge, embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ojire ecishûli c’efodi ca mwenda gwa kaduku ka mukara coshi coshi. ");
INSERT INTO shr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Aha kâgarhî k’eco cishûli, haje omurhule gw’okukazigezamwo irhwe, n’eburhambi bw’ogwo murhule ebè bushwinjiro buli nka bwa lûba, lyo cirhagibereka. ");
INSERT INTO shr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Oku muhiro gw’omu ndalâlà, kuje emishemberere y’emishâbîro y’akaduku k’omukara, akaduku k’akalinga n’akaduku kêru, n’orhudende rhujè rhwahangirwa oku marhambi n’omu kâgarhî k’eyo mishâbîro. ");
INSERT INTO shr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hidende higuma hya masholo na mushâbîro muguma oku muhiro gw’ecishûli n’omu marhambi moshi. ");
INSERT INTO shr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aroni akaciyambala amango ali omu mikolo yâge, na ntyo bakaziyumva ajegereza omudende amango akola ajà omu hatagatîfu embere za Nyakasane, n’amango akola arhengamwo, lyo alek’ifà. ");
INSERT INTO shr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ojire ehy’olubambà hy’amasholo gône gône, onabinjekwo nka kula babinja akahamikizo, mpu: «Mutagatîfu wa Nyakasane». ");
INSERT INTO shr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ohishwêkere oku mugozi gw’akalinga k’omukara, hije oku nsirha: hikwânîne hibêre olunda lw’embere oku nsirha. ");
INSERT INTO shr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Hiyishija aha malanga ga Aroni, lyo akazihêka amabî Bene Israheli bajira omu bintu barherekêra Nyamubâho ngasi mango barherekîre. Aroni akazihiyambala ngasi mango emalanga lyo Nyakasane asimîsibwa n’ezo nterekêro. ");
INSERT INTO shr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Oluke akanzo k’ecitâni ciniole, ojire ensirha y’ecitâni ciniole, ojire n’omukaba gw’emikonzi: mukolo gwa bulenga. ");
INSERT INTO shr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Bagala ba Aroni obajirire orhwanzo, obajirire emikaba, obajirire n’ensirha z’ebidesi, zirya zankabakengêsa. ");
INSERT INTO shr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ebyo birugu obiyambike mwene winyu Aroni n’abagala, obashîge amavurha n’enfune zâbo ozibumbe mavurha, obanterekêre lyo bakazijira omukolo gwâni gw’obudâhwa. ");
INSERT INTO shr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Obajirire orhubutura rhw’ecitâni, rhw’okubwîkira obushugunu bwâbo, rhukazirhenga omu cibunu kuhika omu madwî. ");
INSERT INTO shr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aroni n’abagala bakaz’irhuyambala nka bajà omu Cihando c’Ihano, erhi nka bayegêra oluhêrero mpu barherekêre omu hatagatîfu, lyo balek’ihemuka banalek’ifà. Liri irhegeko ly’ensiku n’amango kuli ye n’oku iburha lyâge. ");
INSERT INTO shr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Alaga oku wakazibajira ly’obarherekêra omu budâhwa bwâni: orhôle empanzi ntôrhò na nganda-buzi ibirhi zirhalikwo izâbyo ");
INSERT INTO shr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","n’omugati gurhalimwo lwango, emigati y’olununîrizi erhalimwo lwango yavungiragwa omu mavurha, n’orhugati rhw’olununîrizi rhurhalimwo lwango, rhushîge amavurha, obijire n’enshâno y’omulà gw’engano. ");
INSERT INTO shr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Obihire byoshi omu cirhiri ciguma, onabirherekêre haguma n’erya mpanzi na zirya ngandabuzi oku zinali ibirhi. ");
INSERT INTO shr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oshegeze Aroni n’abagala aha lusò lw’Ecihando c’Ihano, onabashuke n’amîshi. ");
INSERT INTO shr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Orhôle emyambalo, oyambike Aroni akanzo, ecirondo c’efodi, efodi, enshoho y’oku cifuba, omukobekebyo n’omukaba gw’efodi. ");
INSERT INTO shr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Okuhandi omuyambike ensirha omu irhwe, n’oku nsirha ohirekwo ecimanè c’obutagatîfu; ");
INSERT INTO shr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","orhôle amavurha g’okushîga, omubulagirego oku irhwe, omushîgego. ");
INSERT INTO shr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hano ôbà wamâshegeza abagala, obayambike orhwanzo, ");
INSERT INTO shr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","obayambike omukaba, Aroni n’abagala, obayambike n’ensirha. Ntyo obudâhwa bubè bwâbo omu irhegeko ly’ensiku n’amango. Oyimike ntyo Aroni n’abagala. ");
INSERT INTO shr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Okuhandi, olêrhe empanzi ebwa Cihando c’Ihano, n’Aroni n’abagala, balambûlire amaboko oku irhwe ly’eyo mpanzi. ");
INSERT INTO shr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Obâgire eyo mpanzi embere za Nyakasane, aha lusò lw’Ecihando c’Ihano. ");
INSERT INTO shr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Orhôle oku mukò gw’eyo mpanzi, ojè wagushîga n’omunwe oku rhufende-fende rhw’oluhêrero, n’ogundi ogubulagire gwoshi aha magulu g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Orhôle olujimbi lwoshi luzônga amalà, n’agandi mashushi g’oku budiku, ensiko zombi n’amashushi gazizungulusire zombi, byoshi obiyokere aha luhêrero. ");
INSERT INTO shr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ci eminyafu y’eyo mpanzi, oluhù lwâyo n’ecihò câyo, obiyokere embuga ly’icumbi, bulya eri nterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Okuhandi, orhôle enganda-buzi ntanzi, Aroni n’abagala balambûlire amaboko oku irhwe ly’enganda-buzi. ");
INSERT INTO shr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Obâge eyo nganda-buzi, orhôle oku mukò gwâyo, ojè washahuliza omu marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Eyo nganda-buzi ojè wayitwa bihimbi-bihimbi, oshuke amalà gâyo n’ensenyi zâyo, obihire kuli birya bihimbi n’irwe. ");
INSERT INTO shr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Engandabuzi yoshi oyiyôkere oku luhêrero. Eri mbâgwa ya Nyakasane, nterekêro ya kisûnunu kinjà ka kurhûliriza, yasingônolerwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kandi orhôle erya ngandabuzi ya kabirhi, Aroni n’abagala balambûlire amaboko oku irhwe ly’eyo ngandabuzi. ");
INSERT INTO shr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Obâge eyo ngandabuzi, orhôle oku mukò gwâyo, ogushahulize oku bushongoshongo bw’okurhwiri kulyo kwa Aroni n’oku bushongoshongo bw’okurhwiri kulyo kwa ngasi mugala, oku cunkumwe c’okuboko kwâbo kulyo, n’omu marhambi g’oluhêrero, ogashahulizekwo ogwo mukò. ");
INSERT INTO shr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Orhôle kuli ogwo mukò guli oku luhêrero, n’amavurha gw’okucîshîga, oshahulize kuli Aroni n’oku myambalo yâge, oku bagala n’oku myambalo yâbo. Ajirwa ntyo Mutagatîfu yêne n’emyambalo yâge, n’abagala n’emyambalo yâbo. ");
INSERT INTO shr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Orhôle amashushi g’engandabuzi, omucira gwâyo, amashushi gali oku bulà n’oku budiku, ensiko zombi n’amashushi gazirikwo n’okugulu kwâyo kulyo, bulya eri ngandabuzi ya kuyîmika. ");
INSERT INTO shr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Na muli cirya cirhimbiri cirimwo emigati erhalimwo lwango ciri embere za Nyakasane, orhôlemwo omugati muburungusè, omugati gw’olununîrizi gulimwo amavurha, n’ehigati by’olununîrizi. ");
INSERT INTO shr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ebyo byoshi obihire omu maboko ga Aroni n’omu maboko g’abagala, obihâne nterekêro ya kulengezibwa n’okuzunguzibwa embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Oshub’ibirhenza omu maboko gâbo, obiyôkere oku luhêrero enyanya ly’embâgwa, nka kisûnunu ka kusîmîsa Nyakasane: eri nterekêro ya kusingônolwa n’omuliro, ya kurherekêrwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Orhôle omushaya gw’erya nganda-buzi y’okuyîmika Aroni, okâgulengeza n’okuguzunguza embere za Nyakasane: co câwe cigabi. ");
INSERT INTO shr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Kuli eyo ngandabuzi y’okuyîmika Aroni n’abagala, orherekêre omushaya gw’okulengezibwa n’okuzunguzibwa, n’obuhira. ");
INSERT INTO shr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Liri irhegeko ly’ensiku n’amango, eyo yo myanya Aroni n’abagala bakàhâbwa na Bene Israheli. Eri myanya Bene Israheli bakaz’iyôrha bajira oku nterekêro zâbo z’omurhûla, myanya ya kurhûla Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Emyambalo mitagatîfu ya Aroni eyishihabwa abagala enyuma zâge, bakaziy’iyambala amango bakola bashîgwa amavurha n’okuyîmikwa. ");
INSERT INTO shr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Oyu bâyimike mudâhwa ahâli hâge omu bagala, anayiyambale nsiku nda zoshi zoshi ye wakazija omu Cihando c’Ihano mpu agendijira emikolo omu hatagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Engandabuzi y’okuyîmika oyirhôle, n’enyama zâyo oziyendere omu hantu hatagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aroni n’abagala balire enyama z’eyo ngandabuzi aha lusò lw’Ecihando c’Ihano, bazilire omugati guli omu cirhimbiri. ");
INSERT INTO shr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Bo bakazilya ebyakolesibagwa oku nterekêro y’okubacêsa olusiku lw’okuyîmikwa n’okurherekêrwa kwâbo. Ntà w’embuga wankabiryako, bulya biri bitagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Akabà hali ebyasigîre kuhika sêzi kw’eyo nyama y’okuyîmika n’ogwo mugati, binayocibwe bisingônoke, barhacibiryaga, bulya biri bitagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ntyo kwo wajira kuli Aroni n’oku bagala, nk’oku nanakurhegekaga: okazijira nsiku nda wajira ebijiro by’okubayîmika. ");
INSERT INTO shr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ngasi lusiku, okazirherekêra empanzi ntôrhò, ebè nterekêro y’okucîrhenza ebyâha. Oyihâne nterekêro y’okurhenza ebyâha oku luhêrero, omu kujira ebijiro by’okulushukûla, onalushîge amavurha gw’okulujira lutagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Okazijira nsiku nda zoshi washukûla oluhêrero, wanalujira lutagatîfu. Ntyo, oluhêrero lwâbà lutagatîfu bwenêne, ngasi byoshi byânahike okwo luhêrero, binabè bitagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Alaga ebi wakazirhûla oku luhêrero: bâna-buzi babirhi ba mwâka muguma ngasi lusiku luja oku nkuba. ");
INSERT INTO shr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Omwâna-buzi wa burhanzi akazirherekerwa sêzi, n’omwâna-buzi wa kabirhi arherekêrwe câjîngwe. ");
INSERT INTO shr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Bakazirherekêra enshâno y’omulà haguma n’oyo mwâna-buzi murhanzi, ya cigabi ca kali ikumi ca nyamâha, mvanganye omu mavurha g’omuzêti lwa hîni nguma, byoshi bibè bigushe omu idivayi lya cigabi ca kani ca hîni nguma. ");
INSERT INTO shr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Omwâna-buzi wa kabirhi, okazimurherekêra câjîngwè, onamuhirekwo enterekêro y’enshâno n’ey’ecinyôbwa eri nk’erya y’esêzi; èbe nterekêro ya kisûnunu kinjà ka kurhûliriza, yasingônolerwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Eyo yo nterekêro bakazirherekêra ensiku zoshi embere za Nyakasane, aho ho nakazikubugâna, nkola nakuganîza. ");
INSERT INTO shr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Aho ho nakazishimânana na Bene Israheli, n’ahôla hantu irenge lyâni lyahajira hatagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ecihando c’Ihano n’oluhêrero, nabijira bitagatîfu: Aroni n’abagala nabajira batagatîfu, lyo bakola bwinjà obudâhwa bwâni. ");
INSERT INTO shr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nabêra ekarhî ka Bene-Israheli, na mbè Nyamuzinda wâbo. ");
INSERT INTO shr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bamanya oku nie Nyakasane, Nyamuzinda wâbo, oku nie nabarhenzagya omu cihugo c’e Mîsiri, nti lyo mbêra ekarhî kâbo, nie Nyakasane, Nyamuzinda wâbo. ");
INSERT INTO shr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Ojire oluhêrero wakazitumbûkizakwo enshangi, olujire n’omurhi gwa akasiya. ");
INSERT INTO shr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Obulî waluyubakamwo bubè bw’ikoro liguma n’obugali nabo bubè bw’ikoro liguma: lubè lwa nyunda ziyumânîne, oburherema nabo bubè bwa makoro abirhi, lwoshi lulungane n’orhuhembe rhwâkwo ko na kuguma. ");
INSERT INTO shr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Olushîge amasholo garhali mavange, oku nyanya, omu marhambi n’omu rhuhembe, omuhiro gwâlwo gubè gwa butâke bwa masholo. ");
INSERT INTO shr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Olujirire mpogo ibirhi z’amasholo idako ly’omuhiro, enyanya ly’amarhambi gombi, ozihire omu marhambi, zikazigeramwo emirhamba y’okululengeza. ");
INSERT INTO shr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Eyo mirhamba oyijire n’omurhi gwa akasiya, onayishîge amasholo. ");
INSERT INTO shr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Oluhire embere z’omwenda gubwikire omucîmba gw’Endagâno, embere z’omufûniko gubwikire Endagâno, halya nâkazikubugâna. ");
INSERT INTO shr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aroni akazitumbûkizakwo enshangi, ngasi sêzi, amango akola ayumanyanya orhumole, analutumbûkizekwo enshangi. ");
INSERT INTO shr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","N’amango Aroni akola ayâsa orhumole câjîngwè, analutumbûkizakwo enshangi, eri nshangi ya nsiku n’amango embere za Nyakasane, kurhenga oku iburha kujà oku lindi. ");
INSERT INTO shr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kuli olwo luhêrero irhondo murhahîraga mukârherekêrakwo enshangi y’obushâla-shâla nîsi erhi mbâgwa n’enterekêro zindi zindi, murhakanahîra mukabulagirakwo enterekêro z’ebinyôbwa. ");
INSERT INTO shr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Liguma omu mwâka, Aroni akazijira nterekêro y’okushukûla ebyâha, oku rhuhembe rhw’oluhêrero. Liguma omu mwâka, kurhenga iburha kujà oku lindi, akâshukûla oluhêrero n’omukò gw’embâgwa y’okulyûla ebyâha. Olwo luhêrero luli lutagatîfu bwenêne embere za Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nyakasane anacishambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Amango waganja bene Israheli mpu ly’omanya omubalè gwâbo, ngasi muguma anahane entûlo y’obuzîne bwâge emwa Nyamuzinda, lyo balekijakwo obuhanya bakola baganjwa. ");
INSERT INTO shr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","“Alaga ebi ngasi wanaganjwe akazihâna: cigabi ca kabirhi c’esikeli y’omu ka-Nyamuzinda, erya ya ngero makumi abirhi oku ngasi sikêli. Eco cigabi ca kabirhi c’esikeli ebè ntûlo ya Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","“Ngasi muntu yêshi wankanaganjwa, kurhangirira oku myâka makumi abirhi y’okuburhwa na kulusha, ahâne entûlo ya Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","“Mw’okwo kuhâna entûlo ya Nyakasane lyo muciza obuzîne bwinyu, omugale arhahânaga binji kulusha ecigabi c’esikeli, n’omukenyi arharhûlaga binyi kulusha ecigabi c’esikeli”. ");
INSERT INTO shr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","“Okazirhôla eyo ntûlo ya Bene Israheli y’okuciza obuzîne bwâbo, oyikolese oku mikolo y’omu Cihando c’Ihano, ebè cikengêzo erhi nkûmbu kuli Bene Israheli embere za Nyakasane omu kuciza obuzîne bwâbo.”» ");
INSERT INTO shr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nyamuzinda ashambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ojire omukenzi gw’omulinga n’amakondo gâgo gabè ga mulinga, bakazicîkalabiramwo, oguhire ekarhî k’Ecihando c’Ihano n’oluhêrero, ohiremwo n’amîshi. ");
INSERT INTO shr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","“Aroni n’abagala bakazikalabiramwo amaboko n’amagulu”. ");
INSERT INTO shr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","“Nka bajà omu Cihando c’Ihano, bakazikalaba n’amîshi, lyo balekifà. Kwo na kwo nka bayegêra oluhêrero bakola baliyokera Nyakasane enterekêro z’okusingônoka”, ");
INSERT INTO shr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","“bakazicîkalaba amaboko n’amagulu, lyo balekifà. Kuli obwo lyabà irhegeko lirhahuligana, kuli Aroni yêne n’oku bûko bwâge, kurhenga oku iburha kujà oku lindi.”» ");
INSERT INTO shr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nyakasane anacishambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Orhôle omu migavu minjinjà kulusha eyindi yoshi, obukù bwayaga bwa sikêli magana arhanu; ecigabi ca kabirhi, kwo kuderha sikêli magana abirhi na makumi arhanu y’omugavu gw’esinamomi, sikêli magana abirhi na makumi arhanu y’omugavu gw’olusheke lw’akîsûnunu; ");
INSERT INTO shr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","“sikêli magana arhanu g’omugavu gwa akasiya, lugero lw’esikeli y’omu ka-Nyamuzinda, na hîni nguma y’amavurha g’omuzêti”. ");
INSERT INTO shr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“Ojiremwo amavurha matagatîfu g’okucîshîga, mvange yahûmula bwinjà, mukolo gwa muvanganya mulenga, go gâbà mavurha matagatîfu g’okucîshîga”. ");
INSERT INTO shr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“Oshîgemwo Ecihando c’Ihano, omucîmba gw’Endagâno”, ");
INSERT INTO shr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","“amêza n’orhulugu rhwâgo rhwoshi, oluhêrero lw’enshangi”, ");
INSERT INTO shr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","“oluhêrero lw’enterekêro n’orhulugu rhwâlwo rhwoshi, omukenzi n’amakondo gâgwo”. ");
INSERT INTO shr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","“Obigishe bibè bitagatîfu lwoshi, na ngasi byânabihikekwo binabè bitagatîfu”. ");
INSERT INTO shr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Aroni n’abagala obashîge onabarherekêrere, lyo bakàjira omukolo gw’obudâhwa bwâni”. ");
INSERT INTO shr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","“Obwîre Bene Israheli”, erhi: “Aga mavurha matagatîfu g’okucîshinga, gali gâni, kurhenga oku iburha kuhika oku lindi”. ");
INSERT INTO shr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","“Irhondo murhahîraga mukashiga wundi wundi muntu, murhaderhaga mpu mwayiga okugavanganya, bulya gali matagatîfu, ganayôrhe gali matagatîfu kuli mwe n’oku iburha linyu”. ");
INSERT INTO shr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","“Owanayige okuvanganya ago mavurha erhi kugashîga omuntu kwône, oyo anakagwa omu bûko bwâge.”» ");
INSERT INTO shr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nyakasane anacibwîra Mûsa, erhi: «Olonze ebizibwe bihûmula bwinjinjà, akaradusi kahûmula bwinjinjà, ecizibwe ca torakasi, eca ambre, eca galabani, ebizibwe by’omugavu haguma n’obukù burhalimwo buvange, byoshi bya lugero luyumânîne. ");
INSERT INTO shr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","“Ojiremwo omugavu gw’enshangi, mukolo gwa muvânzi mulenga, ogwo mugavu gujemwo omunyu, gurhajagamwo bindi bici, gubè Mutagatîfu”. ");
INSERT INTO shr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","“Oguvungunyule, orhôlekwo obuvungunyukiza ohire embere ly’omucîmba gw’Endagâno, omu Cihando c’Ihano, mulya nakâshimânana nâwe. Kuli mwe ogwo mugavu gwabà Mutagatîfu bwenêne”. ");
INSERT INTO shr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","“N’ogwo mugavu wajira, irhondo murhahîra mwaderha mpu ninyu mwacîjiriragwo, mukazigulola nka mugavu gurherekîrwe Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","“Owanaderhe mpu aguyiga lyo naye ankayûmva akisûnunu kagwo, oyo muntu anakagwe omu bûko bwâge.”» ");
INSERT INTO shr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Alà! Niene nahamagalaga Besaleli, mwene Uri, mwene Huru w’omu bûko bwa Yûda. ");
INSERT INTO shr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Namuyunjuzize Mûka gwa Nyamuzinda, lyo abà n’oburhimanya, obukêngere n’obwenge bw’okumanyijira ngasi mukolo: ");
INSERT INTO shr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","obulenga omu mikolo y’amasholo, emiringa n’amarhale; ");
INSERT INTO shr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","omu kubinja amabuye gw’okubambira, okubinjûla emirhi n’okujira emikolo ya ngasi lubero. ");
INSERT INTO shr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nakulusha aho, namuhizirekwo Oholiyabu, mwene Ahisamaki, w’omu bûko bwa Dani, nahira oburhimanya omu murhima gwa ngasi mushinganyanya, nti bajire ngasi byoshi nanakurhegesire: ");
INSERT INTO shr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ecihando c’Ihano, omucîmba gw’Endagâno, omufûniko guli enyanya zâgwo na ngasi birugu by’omu cihando byoshi, ");
INSERT INTO shr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ameza n’ebirugu byâgo, akamole k’amasholo gônene n’ebirugu byako, ");
INSERT INTO shr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","oluhêrero lw’enshangi, oluhêrero lw’enterekêro n’ebirugu byâlwo byoshi, omukenzi n’amakondo gâgwo, ");
INSERT INTO shr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","emyambalo y’obugashânize, myambalo mitagatîfu y’omudâhwa Aroni, emyambalo abâna bâge bakaziyambala nka bajira omukolo gw’obudâhwa, ");
INSERT INTO shr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","amavurha g’okucîshîga n’enshangi y’omu hatagatîfu. Babijire byoshi byoshi nk’oku nanakurhegekaga.» ");
INSERT INTO shr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Nyamuzinda anacibwîra Mûsa erhi: ");
INSERT INTO shr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Obwîre Bene Israheli, erhi: Mukâkenga bwenêne ensiku zâni za Sabato, bulya ciri cimanyîso ekarhî kinyu na nâni, kurhenga oku iburha kujà oku lindi, lyo bakazimanyirira oku nie Nyakasane, nie mmucêsa. ");
INSERT INTO shr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Mukazikenga olwa Sabato, bulya luli lutagatîfu kuli mwe. Owâluzize ananigwe. Nêci, ngasi yêshi wânakole muli lwo, oyo muntu anakagwe ekarhî k’ishanja lyâge. ");
INSERT INTO shr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Bakazijira emikolo nsiku ndarhu zoshi, ci olusiku lwa kali nda, luli lusiku lwa kurhamûka lurherekîrwe Nyakasane. Ngasi yêshi wâjire omukolo olusiku lwa Sabato, oyo anayirhwe, afè. ");
INSERT INTO shr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Bene Israheli balange olwa Sabato, bakazijira olwa Sabato, kurhenga oku iburha kujà oku lindi, ebè ndagâno y’ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Sabato abè cimanyîso c’emyâka n’emyâka, ekarhî ka Bene Israheli na nâni, bulya nsiku ndarhu Nyakasane ajiragamwo amalunga n’igulu, ci olusiku lwa kali nda, arhahumaga kabishi, ahûmûka.» ");
INSERT INTO shr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Cazînda, erhi àyûsishambâza Mûsa oku ntondo y’e Sînayi, amuhà zirya mbale ibirhi z’Obuhamîrizi, mbale ibirhi za mabuye, zayandikagwa n’omunwe gwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Olubaga erhi lubona Mûsa amalegama buyandagala oku ntondo, lwashubûzanya eburhambi bwa Aroni, lwanacimubwîra, erhi: «Yimuka! Orhujirire Nyamuzinda warhushokolera, bulya oyo Mûsa, muntu warhurhenzagya omu cihugo c’e Mîsiri, rhurhacimanyiri oku abîre.» ");
INSERT INTO shr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aroni ababwîra, erhi: «Mukûlage orhugondo rhw’amasholo rhuli oku marhwiri ga bakinywi, aga bagala binyu, n’aga bâli binyu, murhunderhere.» ");
INSERT INTO shr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Olubaga lwoshi lwajà lwakûla orhugondo lwagwêrhe omu marhwiri, balêrhera Aroni. ");
INSERT INTO shr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Erhi abà amâyankirira galya masholo bàli mudwîrhîre, agatula n’ecûma, arhenzamwo enshusho y’akanina. Banaciderha, mpu: «Israheli, alà Nyamuzinda wâwe wakurhenzagya omu cihugo c’e Mîsiri!» ");
INSERT INTO shr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Erhi Aroni abona kulya, ayûbaka oluhêrero embere ly’erya nshusho, ayâlîza, erhi: «Irhondo luli lusiku lukulu lwa Nyakasane!» ");
INSERT INTO shr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Erhi buca, oku banazûka, barherekêra enterekêro z’embâgwa banalêrha enterekêro z’omurhûla, olubaga lwanaciburhamala, lwalya lwananywa, lwayimuka mpu lusâme. ");
INSERT INTO shr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nyakasane anacibwîra Mûsa, erhi: «Yandagala, bulya lulya lubaga lwagomire, lulya lubaga warhenzagya omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","“Barhalegamire okurhenga omu njira nabayerekaga, batuzire enshusho y’akanina bafukamire embere zâyo banaderha”, mpu: “Israheli alà Nyamuzinda wâwe, owakurhenzagya omu cihugo c’e Mîsiri.”» ");
INSERT INTO shr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nyakasane, anacibwîra Mûsa, erhi: «“Aye! Nasingirîze olu lubaga, nabona oku luli lwa bacikanyi-cirhagômba”. ");
INSERT INTO shr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","“Ci lêro, ondekage, nkolaga najira oburhè bwâni bubayâkirekwo, boshi mbahererekeze, wêne obè we njira ishanja linene.”» ");
INSERT INTO shr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mûsa arhûliriza Nyakasane, Nyamuzinda wâge, aderha, erhi: «Nyamwagirwa carhuma wakunirira olubaga lwâwe wêne washugulaga n’emisî y’okuboko kwâwe omu cihugo c’e Mîsiri? ");
INSERT INTO shr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","“Cankarhuma abanya-Mîsiri baderha, mpu: Buminya bwarhumaga abarhenza eno munda mpu ly’ajibayirhira omu mpinga, anabaherêrekeze hano igulu! Rhuliriza obukunizi bwâwe, onaleke obubî olonzize okujirira olubaga lwâwe”. ");
INSERT INTO shr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Kengêra bambali bâwe: Abrahamu, Izaki na Yakôbo walanganyagya n’omwîgasho, wababwîra”, erhi: “Obûko bwinyu nabuluza bubè nka nyenyêzi z’oku nkuba na cirya cihugo naderhaga, nacihà obûko bwinyu buciyimenwo ensiku n’amango!”» ");
INSERT INTO shr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nyakasane arhûlirira obwo, arhacikolaga akal’ibala àli amalâlira okukolera olubaga lwâge. ");
INSERT INTO shr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mûsa anacishubûka àyandagala, abungulukira emwa bene Israheli, erhi afumbîrhe galya mabuye g’ennambi abirhi, gàli mayandike enyunda zombi, emugongo n’emalanga. ");
INSERT INTO shr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ago mabuye-nnambi gwàli mukolo gwa Nyamuzinda yêne, emyandiko galikwo Nyamuzinda yêne wayisiribaga. ");
INSERT INTO shr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yozwè ayumva ecihôgêro c’olubaga cidwîrhe cabanda orhuhababo; abwîra Mûsa, erhi: «Namâyumva akahababo kali nka ka ntambala omu cihando.» ");
INSERT INTO shr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ci Mûsa àmushuza, erhi: «Karhali kahababo k’abahimine, karhanali kahababo k’abahimirwe, ci nyumvîrhe nka liri izù lya nyimbo za bantu badwîrhe badumizanya.» ");
INSERT INTO shr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Lêro erhi àhika hôfi n’ecirâlo, àlangîra akanina n’ebigâmba by’amasâmo. Mûsa agwârhwa n’oburhè, arhôla zirya nnambi z’amabuye g’Endagâno, azidedeka oku idaho, azijonjagira mulya ntambi-rhambi ly’entondo. ");
INSERT INTO shr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Arhôla kalya kanina bàjiraga akadûlika muliro; akavungunyula koshi, akalagaliza omu mîshi, aganywesa Bene Israheli. ");
INSERT INTO shr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mûsa adôsa Aroni, erhi: «Bici olu lubaga lwakuhizirekwo ene olinda obayêmêrera ecâha cingan’aha?» ");
INSERT INTO shr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroni àmushuza erhi: «Yâgirwa, orhakalihaga, bulya nâwe wêne orhahabiri oku olu lubaga luyôrha luhârhira amabî! ");
INSERT INTO shr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","“Bônene bambwîraga”, mpu: “Orhujirire nyamuzinda warhushokolera, bulya olya Mûsa, omulume warhurhenzagya e Mîsiri, rhurhamanyiri kurhi anabîre!”» ");
INSERT INTO shr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Lêro nababwîra, nti: «Ndi ogwêrhe amasholo! Bajà bagashugula oku marhwiri gâbo, bagampà. Nagahira ecîko, garhengamwo aka kanina.» ");
INSERT INTO shr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mûsa abona oku olubaga lwahabusire, oku Aroni analuhabwîre, analubonêsa nshonyi omu masù g’abashombanyi bâge. ");
INSERT INTO shr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Okuhandi, Mûsa agend’iyimanga aha muhango gw’icumbi, aderha, erhi: «Oli wa Nyakasane, anjeho!» Bene Levi boshi bashubulizanya eburhambi bwâge. ");
INSERT INTO shr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ànacibabwîra, erhi: «Ntya kwo Nyakasane w’Israheli adesire: “Ngasi muguma ahire engôrho yâge ebirhugo murhulukâne omu icumbi mwoshi, kurhenga kuli ngasi muhango kuj’oku gundi, mujè mwanigûza akabà mwene winyu, akabà mwîra wâwe, akabà mulungu wâwe!”» ");
INSERT INTO shr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Bene Levi banacijira nk’oku Mûsa anababwîraga, olwo lusiku olubaga lwafàmwo bihumbi bisharhu bya bantu. ");
INSERT INTO shr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mûsa ababwîra, erhi: «Ene mwarherekîre Nyakasane amaboko ginyu, kulya kubà ngasi muguma anayomolire omugala erhi mwene wâbo engôrho, ly’amugisha!» ");
INSERT INTO shr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Lêro erhi buca. Mûsa abwîra olubaga, erhi: «Mwajizire ecâha cinene, ci nkolaga narheremera emunda Nyakasane ali kwankanabà nashobôla obwonjo kw’eco câha cinyu!» ");
INSERT INTO shr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mûsa ashubira emunda Nyakasane ali amubwîra, erhi: «Aye! Lulya lubaga lwagomire bwenêne! Lwacîjirîre nyamuzinda w’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ci okalonza, olubabalire eco câha… N’akabà nanga, onzazagye omu citabu wanyandikaga!» ");
INSERT INTO shr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nyakasane anacibwîra Mûsa, erhi: «Owangomîre ye nanazaza omu citabu câni! ");
INSERT INTO shr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ci buno okanyagye! Olôngolane olubaga emunda nakubwîraga, malahika wâni akushokolera. Ci olusiku nabarhangula niene, nabahana kw’eco câha câbo.» ");
INSERT INTO shr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nyakasane anacihana olubaga bulya lwàli lujizire akanina, kalya Aroni àtulaga. ");
INSERT INTO shr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nyakasane anacibwîra Mûsa, erhi: «Orhenge hano, we n’olubaga warhenzagya omu cihugo c’e Mîsiri, orheremere ebwa cihugo nalaganyagya Abrahamu, Izaki na Yakôbo erhi mbabwîra, nti: “Iburha lyâwe lyo ncihîre”. ");
INSERT INTO shr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","“Narhuma malahika embere zâwe, nnandibirhekwo abà-Kanâni, Abamoriti, Abahititi, Abapereziti, Abahiviti n’Abayebusi”. ");
INSERT INTO shr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","“Osôkere ebwa cihugo cihululamwo amarhà n’obûci. Ci kwône omanye oku arhali rhweshi rhuli, bulya oli lubaga lwa bikanyi-birhagômba, nankanamuhungumulira omu njira!”» ");
INSERT INTO shr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Olubaga erhi luyumva eco cinwa c’obuhane, lwajà omu mishîbo na ntâye waciyâmbirhe emyambalo yâge y’olukulu. ");
INSERT INTO shr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nyakasane anacibwîra Mûsa, erhi: «Obwîre Bene Israheli, erhi: “Muli lubaga lwa bikanyi-birhagômba. Erhi nankaderha nti rhusôke haguma ninyu, erhi namanamurahiza. Na buno, ntâye warhenzagya emyambalo yâge y’olukulu, nienene ntâhabe kurhi namujira”». ");
INSERT INTO shr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bene Israheli banacihogola emyambalo yâbo y’olukulu, kurhengerera oku ntondo ya Horebu. ");
INSERT INTO shr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mûsa anacirhôla cirya Cihando, ajiciyubakira kuli, embuga ly’icumbi, aciyîrika Cihando c’Ihano. Na ngasi yêshi wakâgilonza Nyakasane àkâgija ebwa Cihando c’Ihano càliyûbasirwe embuga ly’icumbi. ");
INSERT INTO shr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","N’erhi Mûsa àbâga akola ajà ebwa Cihando c’Ihano, olubaga lwoshi lunayimange, ngasi muguma aha lusò lw’ecihando câge, ashimbulîze Mûsa amasù, kuhika alinde ajà omu Cihando. ");
INSERT INTO shr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Erhi Mûsa àbâga amâjà omu Cihando, ecilundo c’omugî cinayandagale, ciyimange aha lusò lw’Ecihando, Nyakasane arhondêre ashambâla bo na Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Olubaga lwoshi lwakâgibona eco cilundo c’omugî oku ciyimanzire aha lusò lw’Ecihando na ngasi muguma àkâfukama aha lusò lw’ecâge cihando ahwere oku idaho. ");
INSERT INTO shr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Nyakasane àkâgishambâla bo na Mûsa busù oku busù nka kula omuntu anashambâza owâbo muntu. Okuhandi Mûsa àkagishubira ebw’icumbi, ci omurhabâzi wâge Yozwè, mwâna wa busole mwene Nuni, yêhe arharhengaga omu Cihando. ");
INSERT INTO shr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mûsa abwîra Nyakasane, erhi: «Alaga oku wamambwîra, erhi: Yinamulaga olubaga, ci orhammanyisizi ndi orhumire wagenda rhwe naye, n’obwo wênene waderhaga, erhi: “Nkumanyîre oku izîno lyâwe”, na kandi, erhi: “Ôbà murhonyi omu masù gâni”. ");
INSERT INTO shr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","“Lêro akabà ntonyire omu masù gâwe okunali, ommanyisagye nâni amajira gâwe, lyo nâni nkumanya, nanderhe lyoki oku mbà murhonyi omu masù gâwe. Na kandi, omanye oku eri liri ishanja lwâwe!”» ");
INSERT INTO shr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nyakasane amubwîra, erhi: «Akabà orhayishiri wêne niene nayisha ngendikuha amarhamûko». ");
INSERT INTO shr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mûsa àmushuza, erhi: «Akabà orhayishiri Wêne orharhurhenzagya hano. ");
INSERT INTO shr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bicigi bankacimanyirakwo oku niono rhwe n’olubaga lwâwe, rhurhonyire omu masù gâwe? K’arhali kugenda haguma nîrhu oku kwarhuma, n’okubona niono n’olubaga lwâwe rhurhashushini n’agandi mashanja gabà hano igulu?» ");
INSERT INTO shr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nyakasane abwîra Mûsa, erhi: «Okwo odesire buno nakujira nako, bulya oli murhonyi omu masù gâni, nnambà nkumanyîre oku izîno lyâwe.» ");
INSERT INTO shr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mûsa amubwîra, erhi: «Onyêmêrerage nâni ndole oku irenge lyâwe!» ");
INSERT INTO shr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nyakasane àmushuza, erhi: «Nageza aminjà gâni goshi embere zâwe, nnanyakulize izîno lya Nyakasane embere zâwe. Mbabalira oyu nnonzize okubabalira, nnambêra lukogo oyu nnonzize okubêra lukogo!» ");
INSERT INTO shr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ashubiza erhi: «Orhankahashibona obusù bwâni, bulya omuntu arhankabona obusù bwâni akacilama!» ");
INSERT INTO shr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nyakasane ashubiderha, erhi: «Alà ahantu hôfi nâni! Oyimange oku lwâla! ");
INSERT INTO shr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Hano irenge likola lyagera, nakuhira omu mongobana gw’olwâla, nkubwikire n’obulà bw’enfune zâni, kuhika ngere. ");
INSERT INTO shr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Okubundi ntenze enfune zâni, ombone omugongo, ci amalanga gâni, ntâye wankahash’igalolakwo!» ");
INSERT INTO shr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nyakasane anacibwîra Mûsa, erhi: «Obînje nnambi ibiri za mabuye nka zirya ntanzi, nayandika kuli ezo nnambi birya binwa byonêne byàli kuli zirya ntanzi wajonjagaga. ");
INSERT INTO shr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","“Obè ocîrheganyize irhondo sêzi oyishisôkera sêzi-sêzi oku ntondo ya Sînayi, oyimange embere zâni oku busoso bw’entondo”. ");
INSERT INTO shr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","“Ntâye wasôkanaga mweshi ciru n’omuguma na ntâye wabonekaga oku ntondo kwoshi, ciru n’ebibuzi n’enkafu, birhakereraga ebw’eyôla ntondo.”» ");
INSERT INTO shr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mûsa abinja ennâmbi nka zirya ntanzi, anacizûka sêzi-sêzi, asôkera oku ntondo ya Sînayi nka kulya Nyakasane ànamurhegekaga erhi adwîrhe zirya nnambi ibirhi z’amabuye. ");
INSERT INTO shr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nyakasane anacibunguluka omu citù ayimanga halya bo naye. Mûsa erhi adwîrhe ayâkûza izîno lya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nyakasane anacigera embere zâge, ajà ayâkûza, erhi: «Nyakasane, Nyamubâho, Nyamuzinda w’obwonjo, ntabâcihûngo, ntakunira-duba, oyunjula bwinjà n’obwîkubagirwa, ");
INSERT INTO shr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","“oyôrha mwîkubagirwa w’iburha oku lindi, we lembera obubî, obuhalanjisi n’ecâha, ci orhaleka obubî bwagera kwônene, onashimbulule obubî bw’ababusi n’abâna oku binjikulu bâbo kuhika oku iburha lya kasharhu n’erya kani.”» ");
INSERT INTO shr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ho n’aho Mûsa anacifukama, ahwêra oku idaho. ");
INSERT INTO shr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Aderha, erhi: «Akabà ko binali Yâgirwa ntonyire omu masù gâwe, Waliha oyêmêre okugenda nîrhu, bulya olu lubaga luli lwa ba cikanyi-cirhagômba, ci orhubêre obwonjo oku mabî gîrhu, onarhujire mwîmo gwâwe!» ");
INSERT INTO shr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nyakasane aderha; erhi: «Nkola nafundika endagâno, najira ebirhangâzo embere ly’olubaga, birya birhasagiboneka ciru n’eliguma omu mashanja, n’olu lubaga lwoshi olimwo lwabona ebijiro bya Nyakasane, bulya biri bya kujugumya ebi nakola n’okuboko kwâwe! ");
INSERT INTO shr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Obikirire bwinjà ebi nakurhegekaga ene! Embere zâwe nkola nakûngusha Abamoriti, Abakanani, Abahititi, Abapereziti, Abahiviti n’Abayebusi”. ");
INSERT INTO shr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Omanye irhondo orhahîraga mpu wanywâna n’abantu babà omu cihugo wajamwo, balekibà murhego kuli we”. ");
INSERT INTO shr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Ci amahêro gâbo oyishigakûndula, emitûngo yâbo oyijonjage n’emirhi yâbo y’amahêro, ojè wayitwa”. ");
INSERT INTO shr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Wêhe orhahîra okaharâmya owundi nyamuzinda, bulya izîno lya Nyakasane ye Lûji, abà Nyamuzinda wa lûji”. ");
INSERT INTO shr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Orhahîra okanywâna mwene abantu ba muli eco cihugo: bulya amango bakola bacîhemula na banyamuzinda wâbo, bankanakuhamagala obone wamalya oku nterekêro zâbo”; ");
INSERT INTO shr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","“erhi bagala bâwe bankabashebera bâli bâbo, bâli bâbo banayishicihemulira emwa banyamuzinda bâbo, obone bamakululirayo na bagala bâwe, mpu nabo bacîhemulire emwa banyamuzinda bâbo”. ");
INSERT INTO shr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Orhahîraga okatula banyamuzinda b’ecûma”. ");
INSERT INTO shr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Okazilanga olusiku lw’emigati erhalimwo lwango. Okazijira nsiku nda zoshi walya emigati erhalimwo lwango, nka kulya nakurhegekaga, omu mango garhegesirwe n’omwêzi gw’Emihuli, bulya omwêzi gw’Emihuli, go mwêzi warhengagamwo e Mîsiri”. ");
INSERT INTO shr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ngasi coshi cizibûla omulà gwa nnina, ciri câni: ngasi lubere lw’omu masô gâwe, akabà lwa nkâfu, erhi lwa cibuzi”. ");
INSERT INTO shr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","“Ci olubere lw’endogomi, okaziluhânira engombôlo y’omwâna-buzi, akabà orhaluhanîri engombôlo, onaluniole igosi. Ngasi lubere lwa muli bagala bâwe, okaziluhânira engombôlo. Ngasi murhabana wâwe w’olubere, okaz’imugombôla, murhanakâgiyisha maboko mûmu embere zâni”. ");
INSERT INTO shr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Okazikola nsiku ndarhu, ci olusiku lwa kali nda wanarhamûka, ciru gankaba mango ga kubiba erhi kusârûla, onarhamûke”. ");
INSERT INTO shr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Okazijira olusiku lukulu lw’Emigobe, lwo lw’emyâka mirhanzi-rhanzi y’engano, n’olusiku lukulu lw’okusârûla aha buzinda bw’omwâka”. ");
INSERT INTO shr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Kasharhu omu mwâka, ngasi mulume ayishikazilola obusù bwa Nnâhamwâbo, Nyakasane, Nyamuzinda w’Israheli”. ");
INSERT INTO shr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“Bulya hano mbà namakungusha amashanja goshi embere zâwe, mbà namayûshûla ecihugo câwe, ntâye ciru n’omuguma waderhe mpu ayâgalwa n’ecihugo câwe amango warherema, ogendilola obusù bwa Nyakasane, Nyamuzinda wâwe, kasharhu omu mwâka”. ");
INSERT INTO shr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Orhahîra okanterekêra emigati erimwo olwango, n’enterekêro y’olusiku lukulu lwa Basâka erhakâgigeza budufu kuhika sêzi”. ");
INSERT INTO shr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Okazirhûla emyâka mirhanzi-rhanzi y’ishwa lyâwe omu ka-Nyamuzinda, Nyakasane wâwe. Orhahîraga okayendera omwânahene omu mahenehene ga nnina”» ");
INSERT INTO shr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nyakasane abwîra Mûsa, erhi: «Oyandike ebyo binwa, bulya ebyo binwa byo nfundisire mwo endagâno haguma nâwe na haguma n’Israheli.» ");
INSERT INTO shr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mûsa abêra okwo ntondo bo na Nyakasane, miregerege makumi anni na madufu makumi anni. Arhalyaga mugati, arhananywaga mîshi. Ayandika ebinwa by’endagâno kuli zirya nnambi ibirhi z’amabuye, birya binwa ikumi. ");
INSERT INTO shr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Erhi Mûsa àyandagala oku ntondo ya Sînayi, Mûsa ali adwîrhe zirya nnambi zombi z’Endagâno omu maboko, na Mûsa arhâli amanyire oku obusù bwâge bwakazâgilangashana kurhenga aho àshambazagya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aroni na Bene Israheli boshi babona Mûsa, obusù bwâge bwâlibudwîrhe bwalangashana, bayôboha okumuyegêra. ");
INSERT INTO shr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mûsa abahamagala, lêro Aroni n’abagula b’olubaga boshi bamujayo, naye Mûsa abashambâza. ");
INSERT INTO shr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Cazînda Bene Israheli boshi bamujayo, naye Mûsa abaganîza, anakomêreza ngasi byoshi Nyakasane amubwîraga oku ntondo ya Sînayi. ");
INSERT INTO shr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Erhi Mûsa àyûsa okubashambâza, anacibwikira obusù n’omwenda. ");
INSERT INTO shr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","N’erhi Mûsa àbâga ajà embere za Nyakasane mpu bashambâle bo naye, anakûle gulya mwenda, kuhika ahuluke. Erhi abâga amâhuluka, anabwîre Bene Israheli amarhegeko ahîrwe. ");
INSERT INTO shr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Bene Israheli bàkâgibona oku obusù bwa Mûsa budwîrhe bwalangashana. Lêro Mûsa ashubikaz’ibwîkira obusù bwâge n’omwenda, kuhika ashubigend’ishambâla bône Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mûsa anacihamagala olubaga lwoshi lwa Bene Israheli, ababwîra, erhi: «Alagi ebinwa Nyakasane arhegesire okujira: ");
INSERT INTO shr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mukazijira emikolo nsiku ndarhu, ci olusiku lwa kali nda, lubè kuli mwe, lusiku lutagatîfu, luzira lwa Nyakasane lwa kurhamûka. Ngasi wahume akabishi mw’olwo lusiku anayirhwe. ");
INSERT INTO shr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ngasi hoshi mwânabè muli, murhayâsagya ciru n’omuliro olusiku lwa Sabato.» ");
INSERT INTO shr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mûsa anacibwîra olubaga lwa Bene Israheli lwoshi, erhi: «“Yumvagi oku Nyakasane adesire”: ");
INSERT INTO shr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“oku birugu binyu, murhôlekwo ebi mwasholôlera Nyakasane. Ngasi muntu yêshi w’omurhima muhânyi asholôlere Nyakasane amasholo, amarhale, emiringa”; ");
INSERT INTO shr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","“akaduku k’omukara, akaduku k’akalinga, akalinga-kéru, ecitàni ciniole, amôya g’empene”, ");
INSERT INTO shr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","“empù z’enganda-buzi zirimwo ebitàke by’akaduku, empù z’ebigoho, emirhi y’akasiya”, ");
INSERT INTO shr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","“amavurha g’akamole, omugavu gw’amavurha g’okucîshîga, obukù bw’okuyôca”, ");
INSERT INTO shr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","“amabuye ga onikisi n’amabuye g’okujà omu efodi n’omu mwambalo gw’oku cifuba”. ");
INSERT INTO shr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Ngasi balenga ba muli mwe bayîshe barhangire ngasi byoshi Nyakasane arhegesire”: ");
INSERT INTO shr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Endâro, ecihando câyo n’oburhungiri bwâyo, amîno gâyo, empaho zâyo, emirhamba yayo, emitûngo y’amarhwèrhwè yayo”, ");
INSERT INTO shr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","“omucîmba n’emirhamba yago, omufûniko n’omwenda gw’okugufûnika n’okugubwîkira”; ");
INSERT INTO shr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","“ameza n’emirbamba yagwo, orhulugu rhwâgo rhwoshi n’omugati gw’enterekêro”; ");
INSERT INTO shr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","“ecinâra c’akamole n’orhulugu rhwâco rhwoshi, orhumole rhwâco n’amavurha g’okumoleka”, ");
INSERT INTO shr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","“oluhêrero lw’enshangi n’emirhamba yalwo, amavurha gw’okucîshîga n’omugavu gw’enshangi, emyenda y’ebirhebo by’aha muhango gw’endâro”, ");
INSERT INTO shr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","“oluhêrero lw’embâgwa n’olugurhu lwâlwo lw’omulinga, emirhamba yalwo n’orhulugu rhwoshi, omukenzi n’amakondo gâgwo”, ");
INSERT INTO shr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","“emyenda y’emihango y’omu côgo n’emitûngo yayo, amarhwèrhwè gâyo n’omwenda gw’olumvi lw’oku côgo”, ");
INSERT INTO shr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","“enkîngi z’Endâro n’ecôgo câyo n’emigozi yayo”; ");
INSERT INTO shr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","“emyenda y’obugashânize y’okuyambala omu hatagatîfu, emyenda mitagatîfu y’omudâhwa Aroni n’emyenda abagala bakaziyambala omu mukolo gw’obudâhwa”». ");
INSERT INTO shr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Erhi olubaga lwoshi lwa Bene Israheli lurhenga hali Mûsa, ");
INSERT INTO shr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ngasi boshi b’omurhima mwinjà bàyisha na ngasi bàgwêrhe obulonza bw’okuhâna bakazilêrha entûlo ya Nyakasane y’okuyûbaka Ecihando c’Ihano, okujira ngasi mikolo yamwo n’emyambalo mitagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Abalume n’abakazi bavangula. Ngasi ba murhima muhânyi balêrha orhugondo rhwâbo rhw’omu marhwiri, engondo, emiringa, orhulugu rhunji rhw’amasholo, rhulya bànalilonzize okurhûla Nyakasane. ");
INSERT INTO shr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ngasi bàli bagwêrhe akaduku k’omukara, akaduku k’akalinga, akalinga kêru, ecitâni ciniole, amôya g’empene, empù z’enganda-buzi zirimwo ebitâke by’akaduku n’empù z’ebigoho, bakazibilêrha. ");
INSERT INTO shr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Abakâgisholola entûlo z’amarhale, n’ez’emiringa, bakàbilerhera Nyakasane ntûlo. Ngasi bàgwêrhe emirhi y’akasiya yankakwanana kw’eyo mikolo, bakâyilêrha. ");
INSERT INTO shr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ngasi bakazi balenga, bakazihûnga emigozi, ey’akaduku k’omukara k’akalinga, n’ey’akalinga kêru n’ey’ecitâni ciniole, bàkazibijira n’amaboko gâbo bônene banabilêrha. ");
INSERT INTO shr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Abakazi balenga bàkâluka amôya g’empene. ");
INSERT INTO shr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Abagula b’olubaga bakazilêrha amabuye ga onikisi n’amabuye gw’okutâka efodi n’enshoho y’oku cifuba, ");
INSERT INTO shr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","migavu n’amavurha g’akamole gw’okushiga n’enshangi. ");
INSERT INTO shr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bene-Israheli boshi, abalume n’abakazi, ngasi ba murhima muhânyi, bâkazilêrha buzira kusêzibwa ebyâli bikwânîne oku mikolo yoshi Nyakasane ali rhegesire Mûsa okujira. ");
INSERT INTO shr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mûsa anacibwîra Bene Israheli, erhi: «Loli! Besaleli mwene Uri, mwene Huru w’omu bûko bwa Yûda, Nyakasane amuhamagîre omu izîno lyâge. ");
INSERT INTO shr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","“Amuyunjuzize omûka gwa Nyakasane, omûka gw’oburhimanya, obumanye n’obulenga omu mikolo ya ngasi lubero”, ");
INSERT INTO shr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","“mpu akageranya ngasi mukolo, ahashe okukazikola amasholo, amarhale n’emiringa”; ");
INSERT INTO shr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","“ahashe okukâgôya amabuye g’okubambira, okubinjûla emirhi n’okujira ngasi mikolo yoshi y’obulenga”. ");
INSERT INTO shr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","“Anahizire omu murhima gwâge n’omu gwa Oholiyabu mwene Ahisamaki, w’omu bûko bwa Dani, engalo y’okuyigîriza”. ");
INSERT INTO shr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","“Abayunjuzize oburhimanya bw’okujira ngasi mikolo y’okugôya, okutâka n’okuluka emyênda y’akaduku k’omukara, ey’akaduku k’akalinga, ey’akaduku kêru n’ecitâni ciniole, n’oburhimanya bw’okuhunga: abahîre obulenga bw’okujira emikolo ya ngasi lubero n’obukengêre bw’okuyigeranya.”» ");
INSERT INTO shr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besaleli, Oholiyabu na ngasi mushinganyanya Nyakasane àhiziremwo oburhimanya n’obukengêre bw’okumanyijira emikolo yoshi y’omu ka-Nyamuzinda, abo bayishijira ngasi byoshi Nyakasane arhegesrire. ");
INSERT INTO shr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mûsa anacibamagala Besaleli na Oholiyabu na ngasi bandi balenga Nyakasane ali ahizire omu murhima gwâbo oburhimanya, balya boshi omurhima gwâbo gwanali gusunisire omu kujira omukolo buzira kusêzibwa. ");
INSERT INTO shr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Banacigendirhôla emunda Mûsa ali, zirya ntûlo zoshi Bene Israheli bàkâgilêrha oku bajira omukolo gw’aka-Nyamuzinda mpu bagurhangire. Ci kwône kulya kubà ngasi sêzi, bâcikâg’ilêrha ezindi ntûlo, ");
INSERT INTO shr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","balya bashinganyanya bakâg’ijira emikolo ya ngasi lubero y’aka-Nyamuzinda, barhenga muguma muguma omu mukolo bàkâgijira, ");
INSERT INTO shr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","bajibwîra Mûsa, mpu: «Olubaga ludwîrhe ebirhalusire, ebikwânîne emikolo Nyakasane arhegesire.» ");
INSERT INTO shr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mûsa anacihâna irhegeko mpu bajè baderha omu icumbi lyoshi, mpu: «Abè mulume abè mukazi, ntâye wacîjiraga ensholôlo y’aka-Nyamuzinda!» Ntyo banacihanza okukâlêrha ezindi ntûlo, ");
INSERT INTO shr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","bulya ebi lwàli lwa masholôla byàli bikwânîne oku mikolo yoshi yankanajirwa, ciru byankanarhaluka. ");
INSERT INTO shr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abalenga kulusha omu bakozi bajira Endâro: birhebo ikumi bya citâni ciniole, bya kaduku k’omukara, bya kaduku k’akalinga n’akaduku kêru, bajira na ba-kerubimi bàkolagwa n’obulenga. ");
INSERT INTO shr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Obulî bwa ngasi cirhebo makoro makumi abirhi na munâni, obugali bwa ngasi cirhebo: makoro anni, lugero luguma oku birhebo byoshi. ");
INSERT INTO shr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bâkaz’ilungira birhebo birhanu haguma, na bindi birhanu haguma. 1 ");
INSERT INTO shr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Bahira emishumi y’akaduku k’omukara oku cirhebo cizinda mwo birya bishwêkîrwe haguma, bajira ntyo n’oku cindi cirhebo cishwinjire ebyâbo. ");
INSERT INTO shr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Bahira mishumi makumi arhanu oku cirhebo cirhanzi na yindi mishumi makumi arhanu omu muhiro gw’ecirhebo cishwinjire ebya kabirhi, eyo mishumi yakaziyêrekerana ngasi muguma olunda ogwâbo gunalozire. ");
INSERT INTO shr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Bajira mîno makumi arhanu ga masholo g’okuhanga ebirhebo bihashikîne, ngasi ciguma oku cindi, na ntyo Endâro yoshi yabà nyumpa nguma. ");
INSERT INTO shr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Cazinda bàluka ebirhebo by’amôya g’empene, ga kujira ecihando oku irhwèrhwè ly’Endâro. Babijira ikumi na ciguma. ");
INSERT INTO shr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Obulî bwa ngasi cirhebo, makoro asharhu, obugali bwa ngasi cirhebo, makoro anni, lugero luguma kw’ebyo birhebo ikumi na ciguma byoshi. ");
INSERT INTO shr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bashwekera birhebo birhanu haguma, na bindi ndarhu haguma. ");
INSERT INTO shr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Bahira mishumi makumi arhanu oku muhiro gw’ecirhebo cizinda cishwesire ebyâbo, na yindi makumi arhanu oku muhiro gwa birya bya kabirhi bishwêkîrwe haguma. ");
INSERT INTO shr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bajira mîno makumi arhanu ga mulinga gw’okuhangira ecihando haguma coshi cibè nnambulè nguma. ");
INSERT INTO shr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ecihando bacijirira oburhungiri bw’empù z’enganda-buzi z’akaduku, oku nyanya bahirakwo oburhungiri bw’empù z’ebigoho. ");
INSERT INTO shr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Babînja empaho z’Endâro, mpaho za murhi gw’akasiya, baziyimanza burherema. ");
INSERT INTO shr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Obulî bwa ngasi lupaho makoro ikumi, n’obugali bwa ngasi lupaho, ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Oku ngasi lupaho kwàli migukuma ibirhi milûnge ngasi muguma oku gwâbo. Bajira ntyo oku mpaho zoshi z’Endâro. ");
INSERT INTO shr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Nêci, banacijira empaho z’Endâro: makumi abirhi olunda lw’emukondwè, ebulyo. ");
INSERT INTO shr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ezo mpaho makumi abirhi, bahirakwo marhwêrhwè makumi abirhi ga marhale, marhwêrhwè abirhi kuli migukuma ibirhi ya lupaho luguma na marhwêrhwè abirhi oku migukuma ibirhi ya ngasi lundi lupaho. ");
INSERT INTO shr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Olundi lunda lw’Endâro lwo lunda lw’emwênè, bahirayo mpaho makumi abirhi, ");
INSERT INTO shr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","haguma n’amarhwèrhwè gâzo g’amarhale oku gali makumi anni: marhwêrhwè abirhi oku lupaho luguma, na marhwêrhwè abirhi oku ngasi lundi lupaho. ");
INSERT INTO shr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Babinja mpaho ndarhu z’omu bululi bw’Endâro, olunda lw’ebuzika-zûba. ");
INSERT INTO shr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Bajira na mpaho ibirhi z’omu mahembe g’endâro, omu ndalâlà. ");
INSERT INTO shr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Zàli mpangire ibirhi-ibirhi idako na zindi ibirhi ibirhi enyanya, kuhika oku mpogo ya burhanzi. Bajira ntyo oku mpaho zombi z’omu mahembe oku gali abirhi. ");
INSERT INTO shr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Zabà mpaho munâni n’amarhwèrhwè gâzo g’amarhale: marhwêrhwè ikumi na ndarhu, marhwêrhwè abiri oku ngasi lupaho. ");
INSERT INTO shr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Kandi bajira emirhamba y’omurhi gw’akasiya, mirhamba irhanu oku mpaho z’olunda lurhanzi lw’Endâro, ");
INSERT INTO shr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","yindi mirhamba irhanu oku mpaho z’olunda lwa kabirhi lw’Endâro, na yindi irhanu oku mpaho z’omu bululi bw’Endâro, lwo lunda lw’ebuzika-zûba. ");
INSERT INTO shr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Bajira omurhamba gw’aha karhî olunda n’olundi. ");
INSERT INTO shr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Empaho bazishîga amasholo, banazijirira empogo z’amasholo z’okugezamwo emirhamba, n’eyo mirhamba bàyishiga amasholo. ");
INSERT INTO shr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Kandi banaciluka omwenda gw’akaduku k’omukara, ogw’akalinga kêru n’ecitâni ciniole, bahirakwo ba-kerubimi bàjiragwa n’obulenga. ");
INSERT INTO shr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Bagujirira mitûngo inni ya murhi gw’akasiya, bàyishîga amasholo, n’empogo zâyo z’amasholo. Bayitulirakwo marhwêrhwè anni ga marhale. ");
INSERT INTO shr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Bajira omwenda gw’omu lusò lw’ecihando, gwa kaduku ka mukara, kaduku ka kalinga, kaduku kêru n’ecitâni ciniole, mukolo gwa muntu mulenga, ");
INSERT INTO shr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","bajirirakwo mitûngo irhanu n’empogo zâyo, amafufu gâyo n’empogo zâyo babishîga amasholo, amarhwèrhwè gâyo arhanu gali ga mulinga. ");
INSERT INTO shr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleli anacijira omucîmba n’omurhi gw’akasiya, gwa buli bwa makoro abirhi n’ecihimbi, bugali bw’ikoro liguma n’ecihimbi, na burherema bw’ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Agushîsha n’okugushîga amasholo garhalimwo mvange omu ndalâlà n’emugongo, ànazungulusa amarhambi goshi n’omuhiro gw’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Agutulira mpogo inni za masholo oku magulu anni, mpogo ibirhi lunda luguma na zindi ibirhi olundi lunda. ");
INSERT INTO shr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ajira emirhamba y’omurhi gw’akasiya anaciyishîga amasholo, ");
INSERT INTO shr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ànashesherêza eyo mirhamba mwa zirya mpogo ziri omu marhambi gw’omucîmba. ");
INSERT INTO shr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ajira omufûniko gw’amasholo gône gône, bulî bwa makoro abirhi n’ecihimbi na bugali bw’ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ajira ba-kerubi babirhi ba masholo, abatulira oku marhambi gombi g’omufûniko. ");
INSERT INTO shr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kerubi muguma burhambi buguma n’owundi obundi burhambi. ");
INSERT INTO shr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ba-kerubi bàli balambwîre ebyûbi byâbo enyanya n’okubwîkira omufûniko, bàli bayerekerine, banakazâg’ilola ebwa mufûniko. ");
INSERT INTO shr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kandi anacijira ameza g’omurhi gw’akasiya, ga bulî bwa makoro abirhi, bugali bw’ikoro liguma na burherema bw’ikoro liguma n’ecihimbi. ");
INSERT INTO shr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Agashîga amasholo garhali mavange, anagazungulusakwo omuhiro gw’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Agubinjûlakwo emikônzi y’amasholo anashîga emihiro yayo amasholo. ");
INSERT INTO shr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Agajirira mpogo inni za masholo, azihira oku bikwi binni by’amagulu gâgo oku ganali anni. ");
INSERT INTO shr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ezo mpogo zashwêkerwa hôfi hôfi n’omuhiro, mpu lyo zikaz’igeramwo emirhamba y’okubarhula ameza. ");
INSERT INTO shr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ajira emirhamba n’omurhi gw’akasiya, anayishîga amasholo, mpu ekaz’ikolesibwa oku kubarhula ameza. ");
INSERT INTO shr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ajira n’ebirugu by’okukâjà oku mêza, bya masholo garhalimwo mvange: embale, ennambi, orhuzinzi n’orhubêhè, bya kukâdubuliramwo enterekêro z’ebinyôbwa. ");
INSERT INTO shr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ajira akamole k’amasbolo garhalimwo mvange, akamole, enteberhebe yako, olusârhi lwâko, haguma n’amashami, ebigonyero n’obwâso bwâko, abitula n’amasholo gône gône, byânali bilungîne. ");
INSERT INTO shr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mahaji ndarhu garhenga omu marhambi gako; mahaji asharhu g’akamole garhenga eburhambi buguma na gandi mahaji asharhu g’akamole ebundi burhambi. ");
INSERT INTO shr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Oku ngasi ihaji kwajà mashami asharhu galikwo amafufu n’obwâso, n’oku lindi ihaji kwajà mashami asharhu galikwo amafufu n’obwâso. Amashami goshi oku ganali ndarhu kwo n’okwo. ");
INSERT INTO shr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","N’ako akamole kône kàli kagwêrhe mashami anni, haguma n’amafufu n’obwâso bwâgo: oku cinâra conênè, rhubêhe rhuni rhushusha obwâso bw’omuluhusi, ");
INSERT INTO shr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ifufu liguma omu mahaji abirhi marhanzi garhenzire omu kamole, ifufu liguma omu gandi mahaji abirhi mazinda garhenzire omu kamole. Kwo n’okwo omu mahaji ndarhu goshi g’akamole. ");
INSERT INTO shr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Amafufu n’amahaji byàli bilungîne n’akamole, byànali bitule byoshi muli cûma ciguma ca masholo garhali mavange. ");
INSERT INTO shr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Okuhandi anacijira matara nda g’akamole, n’ebitwanizo n’orhujo rhw’oluvù byâgo, byoshi bya masholo garhali mvange. ");
INSERT INTO shr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Akolêsa talenta nguma y’amasholo garhalimwo mvange omu kujira akamole n’orhulugu rhwâko rhwoshi. Amavurha matagatîfu n’omugavu gulimwo enshangi. ");
INSERT INTO shr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Enyuma z’aho, àjira oluhêrero lw’okutumbûkizakwo enshangi, àjira olw’omurhi gw’akasiya. Obulî bw’oluhêrero ikoro liguma, obugali nabwo ikoro liguma, luyumânîne enyunda zombi na zoshi, oburherema bubè bwa makoro abirhi, lwàli lulungine n’orhuhembe rhwâlwo. ");
INSERT INTO shr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Alushîga amasholo garhali mavange oku nyanya, omu marhambi n’omu rhuhembe, n’omuhiro gwâlwo agutâka n’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Alujirira mpogo ibirhi za masholo idako ly’omuhiro, oku nyanya ly’amarhambi gombi, lyo zikâgeramwo emirhamba y’okulengeza. ");
INSERT INTO shr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ajira eyo mirhamba n’omurhi gw’akasiya anayishîga amasholo. ");
INSERT INTO shr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ajira amavurha matagatîfu gw’okushîga abadâhwa, n’omugavu gulimwo enshangi gwahûmula bwinjà, mukolo gwa muvanganya mulenga. ");
INSERT INTO shr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ànacijira oluhêrero lw’embâgwa lw’omurhi gw’akasiya, lwa buli bwa makoro arhanu, bugali bwa makoro arhanu, lwali luyumânîne empande zoshi oku zinali inni, n’oburherema bwàli bwa makoro asharhu. ");
INSERT INTO shr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Orhumpekwè-mpekwè rhwâlwo oku rhuli rhunni, àhirakwo amahembe galungine nalo; alushîga omulinga. ");
INSERT INTO shr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ajira na ngasi rhulugu rhwoshi rhw’oku luhêrero: orhubêhè rhw’okubikiramwo oluvù n’orhupaho rhw’okukaz’iluyankamwo, amabakuli g’okubikiramwo amîshi g’okukangûla, amakanya n’ebitumbûkizo. Orhwo rhulugu rhwoshi arhujira n’omulinga. ");
INSERT INTO shr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Oluhêrero alulukira olusirha lw’omulinga, aluhira kurhondêrera oku nteberhebe y’oluhêrero, kuhika ekâgarhî k’oburherema. ");
INSERT INTO shr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Atulira mpogo inni za mulinga oku marhambi anni g’olusirha, za kukâgeramwo emirhamba. ");
INSERT INTO shr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ànacijira emirhamba y’omurhi gw’akasiya, àyishîga omulinga. ");
INSERT INTO shr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ashesheza emirhamba mulya mpogo z’omu marhambi g’oluhêrero, mpu ekazikolesibwa nka balubarhula; analubinjûla nka mukenzi. ");
INSERT INTO shr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ànacijira omukenzi gw’omulinga n’amakondo gâgo gajirwa n’omulinga, haguma n’ebilolero by’abakazi bàkâgikola aha muhango gw’Ecihando c’Ihano. ");
INSERT INTO shr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Okuhandi ajira obululi. Olunda lw’emukondwè, ebulyo, emyenda y’obululi yali ya citâni ciniole, ya makoro igana. ");
INSERT INTO shr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Emitûngo yayo makumi abirhi n’amarhwèrhwè gâyo makumi abirhi byàli bya mulinga, engondôzo n’empogo zâyo byàli bya marhale. ");
INSERT INTO shr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Olunda lw’emwênè: makoro igana, n’emitûngo yayo n’amarhwèrhwè gâyo byàli bya marhale. ");
INSERT INTO shr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Olunda lw’ebuzika-zûba, yali emyenda ya makoro makumi arhanu, emitûngo yayo ikumi n’amarhwèrhwè gâyo ikumi, engondôzo z’emitûngo n’amaganyi gâyo byàli bya marhale. ");
INSERT INTO shr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Olunda lw’ebuzûka-zûba, ebushoshôkero, makoro makumi arhanu, ");
INSERT INTO shr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","myenda ya makoro ikumi n’arhanu, n’emitûngo yayo isharhu, n’amarhwèrhwè gâyo asharhu oku kahembe kaguma. ");
INSERT INTO shr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Oku kandi kahembe ebwa muhango gw’obululi, olunda n’olundi, myenda ya makoro ikumi n’arhanu, n’emitûngo yayo oku eri isharhu n’amarhwèrhwè gâyo oku gali asharhu. ");
INSERT INTO shr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Emyenda yoshi y’obululi yali ya citâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Amarhwèrhwè g’emitûngo gali ga mulinga, engondôzo z’emitûngo n’empogo zâyo byàli bya marhale, amafufu gali gashîzirwe amarhale, emitûngo y’obululi yali egwêrhe empogo z’amarhale. ");
INSERT INTO shr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Omwenda gw’okubwîkira omuhango gw’obululi, mukolo gwa bulenga, gwàli gwa kaduku k’omukara, kaduku k’akalinga, kaduku kêru n’ecitâni ciniole, gwa buli bwa makoro makumi abirhi, burherema bwa makoro arhanu oku bugali, gwàli gujizirwe kuguma n’emyenda y’omu bululi yoshi. ");
INSERT INTO shr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Emitûngo oku enali inni n’amarhwèrhwè gâyo oku ganali anni, byàli bya mulinga, engondôzo zâyo zàli za mulinga, amafufu gâyo n’empogo zâyo byàli bishîzirwe amarhale. ");
INSERT INTO shr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Enkwîra zoshi z’Endâro n’ez’obululi zàli za mulinga. ");
INSERT INTO shr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Alaga olukalaba lw’ebyakolesibwe omu Ndâro, Ndâro y’Endagâno, banacijira omubalè oku irhegeko lya Mûsa, guli mukolo gwâjirwa n’Abaleviti oku buhanùzi bwa Itamara, mugala w’omudâhwa Aroni. ");
INSERT INTO shr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleli mwene Uri wa Huri, w’omu bûko bwa Yûda, anacijira ngasi ebi Nyakasane ali arhegesire Mûsa byoshi. ");
INSERT INTO shr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Omurhabâzi wâge àli Oholiyabu, mwene Ahisamaki w’omu bûko bwa Dani, mubînji, mulenga omu kuluka emyenda y’akaduku k’omukara, ey’akaduku k’akalinga, ey’akaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Omubalè gw’amasholo gakolesibwe oku mukolo, oku mikolo y’omu ka-Nyamuzinda yoshi, gali masholo gakàgilerhwa ntûlo, goshi haguma zàli talenta makumi abirhi na mwenda na sikêli magana gali nda na makumi asharhu, omu kugerera oku sikêli y’omu ka-Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Amarhale gàdwirhwe n’abantu bàganjagwa omu lubaga: talenta igana na sikêli cihumbi na magana gali nda na makumi gali nda n’irhanu, omu kugerera oku sikêli y’omu ka-Nyamuzinda, ");
INSERT INTO shr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","yo beka nguma erhi cihimbi c’esikeli kuli ngasi muntu, omu kugerera oku sikêli y’omu ka-Nyamuzinda oku ngasi muntu waganjirwe kurhangirira oku myâka makumi abirhi na kulusha: bo bantu bihumbi magana gali ndarhu na bisharhu na magana arhanu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Zirya talenta igana zàkolesibwa oku kujonza amarhwèrhwè g’aka-Nyamuzinda n’amarhwèrhwè g’omwenda: marhwêrhwè igana na talenta igana, ngasi irhwèrhwè talenta nguma. ");
INSERT INTO shr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na zirya sikêli cihumbi na magana nda na makumi gali nda n’irhanu, àjiramwo engondôzo z’emitûngo, ànashîgamwo empogo zâyo n’okubilungamwo byoshi haguma. ");
INSERT INTO shr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Omulinga gwarhengaga oku ntûlo: talenta makumi gali nda na sikêli bihumbi bibirhi na magana anni. ");
INSERT INTO shr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Gwo àtuziremwo amarhwèrhwè g’omuhango gw’Ecihando c’Ihano, oluhêrero lw’Ihano lw’omulinga n’akasirha kâlwo k’omulinga, orhulugu rhwoshi rhw’omu luhêrero, ");
INSERT INTO shr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","amarhwèrhwè g’omu ndalâlà y’obululi, amarhwèrhwè g’omuhango, enkwîra z’Endâro zoshi n’enkwîra z’omu ndalâlà y’obululi. ");
INSERT INTO shr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Banacirhôla emyenda y’akaduku k’omukara, ey’akaduku k’akalinga, ey’akaduku kêru, bàjiramwo emyambalo y’obugashânize y’okurhumikira omu ka-Nyamuzinda, banacijiramwo emyambalo mitagatîfu ya Aroni, nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Banacijira efodi y’amasholo, akaduku k’omukara, akaduku k’akalinga, akaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Batula amasholo gâbà nka hyasi bya lubambà, balukiramwo orhukwêgè, barhulukira omu myenda y’akaduku k’omukara, ey’akaduku k’akalinga, ey’akaduku kêru n’ecitâni ciniole, mukolo gwa muntu mulenga. ");
INSERT INTO shr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Omu kuyigwâsa, àyijirira mishumi ibirhi oku bikwi byâyo byombi. ");
INSERT INTO shr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Omusiho gw’efodi gwàli gugezire enyanya gunalungine nayo, nagwo gwàli gukozirwe kuguma nayo: gwàli gwa masholo, gwa kaduku kêru n’ecitâni ciniole, nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Barhendêza amabuye ga onikisi, bàgahira omu lûbarhi lw’amasholo bayandikakwo amazîno ga Bene Israheli nka kula babînja eciziriko. ");
INSERT INTO shr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Banacigahira oku mishumi y’eyo efodi, mpu gabè mabuye ga kukâyibusa Bene Israheli. ");
INSERT INTO shr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bajira enshoho y’oku cifuba, mukolo gwa bulenga, yali ekozirwe kuguma n’efodi, yali ya masholo, ya kaduku k’omukara, ya kaduku ka kalinga, ya kaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Yali eyumânîne enyunda zoshi, yanali ngoye, yali ya buli bwa cihimbi c’ikoro na bugali bwa cihimbi c’ikoro. ");
INSERT INTO shr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Bayilukirakwo milongo inni ya rhubuye: oku omulongo murhanzi, kwalukirwa esadoki, etopazi n’esumarado, ");
INSERT INTO shr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","oku mulongo gwa kabirhi kwajà enofeki, esafiri n’ealimasi. ");
INSERT INTO shr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Oku mulongo gwa kasharhu bahirakwo enjwijwi, eata n’eamatusta; ");
INSERT INTO shr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","oku mulongo gwa kani kwalukirwa ekrizoliti, ehyansinti n’eyaspiri. Orhwo rhubuye rhwàli rhuhangirwe omu mpogo z’amasholo. ");
INSERT INTO shr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Orhwo rhubuye rhwàli rhuyandikekwo amazîno ga Bene Israheli: ikumi n’abirhi gali matâke nka biziriko, ngasi ibuye n’izîno, nk’oku emilala yâbo ikumi n’ibiri yanali. ");
INSERT INTO shr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Enshoho y’oku cifuba bàyijirira emigufu y’amasholo gônene, miluke nka migozi. ");
INSERT INTO shr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Bajira mburungusè ibirhi za masholo na rhugondo rhwa masholo oku bikwi byoshi oku binali bibirhi; ");
INSERT INTO shr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","bàgeza erya migufu ibirhi y’amasholo muli rhulya rhogondo rhubirhi, oku bushwinjiro bw’enshoho y’oku cifuba. ");
INSERT INTO shr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Nabyo ebikwi by’orhwo rhwombi, babishwekera kuli zirya mburungusè zombi, oku mishumi y’efodi, embere zâyo. ");
INSERT INTO shr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Bajira rhugondo rhubirhi rhwa masholo, barhuhira omu bushwinjiro bw’enshoho y’oku cifuba oku muhiro gw’endalâla, olunda lw’efodi. ");
INSERT INTO shr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Bajira rhugondo rhubirhi rhwa masholo, baruhira oku bushwinjiro bw’enshoho y’oku cifuba, oku muhiro gw’endalâla, olunda lw’efodi, olunda lw’embere, hôfi n’obugonyero bwâyo, enyanya ly’omushumi gw’efodi! ");
INSERT INTO shr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Bashwêkera empogo z’enshoho y’oku cifuba oku mpogo z’efodi, n’ehigozi hy’akaduku k’omukara, lyo ebêra enyanya ly’omushumi gw’efodi, lyo n’enshoho y’oku cifuba esêra oku efodi, kwo Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Okuhandi banacijira ecishûli c’omwenda gw’akaduku k’omukara coshi coshi, bushanja bwa mulenga w’okuluka. ");
INSERT INTO shr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Aha kâgarhî k’eco cishûli, hàli omurhule gushwinjirwe nka murhule gwa lûba, lyo cirhagibereka. ");
INSERT INTO shr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Oku muhiro gw’omu ndalâlà kwajà emishemberere y’akaduku k’omukara, akaduku k’akalinga, akaduku kêru n’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Bajira orhudende rhw’amasholo garhalimwo mvange, barhuhangira muli erya mishemberere, oku muhiro gw’ecishûli, omu marhambi mwoshi, omu kâgarhî k’emishemberere: hidende higuma na mushemberere muguma, ");
INSERT INTO shr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","hidende higuma na mushemberere muguma oku muhiro gw’ecishûli n’omu marhambi mwoshi, lyo bikwanana obugashânize, nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Balukira Aroni n’abagala orhwanzo rhw’ecitâni, mukolo gwa mulenga wa kuluka. ");
INSERT INTO shr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Bajira n’ensirha z’ecitâni, ensirha z’ecidesi, n’orhubutura rhw’ecitâni ciniole. ");
INSERT INTO shr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bajira emikaba y’ecitâni ciniole, ya kaduku ka mukara, ya kaduku ka kalinga n’ey’akaduku kêru, mukolo gwa muntu mulenga, nk’oku Nyakasane àrhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Bàtula ehy’olubambà hy’amasholo gône gône, lyo ishungwè litagatîfu, banabînjakwo nka kula babinja akahamikizo, mpu: «Mutagatîfu wa Nyakasane!» ");
INSERT INTO shr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Bahishwekera emalanga g’ensirha n’ehigozi hy’akaduku k’omukara, nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Yanacihwa ntyo emikolo y’Endâro, y’Ecihando c’Ihano. Bene Israheli banacijira byoshi nka kulya Nyakasane anarhegekaga Mûsa. Ntyo ko bajizire! ");
INSERT INTO shr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bayêreka Mûsa Endâro n’Ecihando c’Ihano n’orhulugu rhwamwo rhwoshi, bàmuyêreka engondôzo z’okuyigwasa, empaho, emirhamba, emitungo n’amarhwèrhwè gâyo; ");
INSERT INTO shr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","bàmuyêreka omufûniko gw’empù z’enganda-buzi z’akaduku, omufûniko gw’empù z’ebigoho n’omwenda gw’omu ndalâlà, ");
INSERT INTO shr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","bàmuyêreka omucîmba gw’Endagâno, emirhamba yagwo n’omufûniko, ");
INSERT INTO shr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","bàmuyêreka ameza n’orhulugu rhwâgwo rhwoshi n’emigati y’oburherekêre. ");
INSERT INTO shr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Bàmuyêreka akamole k’amasholo garhalimwo mvange n’orhumole, n’orhulugu rhwâko rhwoshi haguma n’amavurha g’okutwana orhumole. ");
INSERT INTO shr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Bàmuyêreka oluhêrero lw’amasholo, amavurha gw’okucîshîga, enshangi y’omugavu n’omwenda gw’aha muhango gw’Ecihando. ");
INSERT INTO shr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Oluhêrero lw’omulinga n’akasirha kâlwo k’omulinga, emirhamba yakwo n’orhulugu rhwâlwo rhwoshi, omukenzi n’amakondo gâgwo; emyenda y’omu bululi, emitûngo yamwo n’emifûnikiro zâyo, ");
INSERT INTO shr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","emyenda y’aha muhango gw’obululi, emigozi yayo, enkwîra zamwo n’ebirugu byoshi by’omukolo gw’omu Cihando c’Ihano. ");
INSERT INTO shr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Bàmuyêreka emyambalo y’obugashânize y’okukolera omu ka-Nyamuzinda, emyambalo mitagatîfu y’omudâhwa Aròni n’emyambalo abagala bakaziyambala nka bajira omukolo gw’obudâhwa. ");
INSERT INTO shr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ogwo mukolo gwoshi Bene Israheli bagujira nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mûsa asîngiriza ogwo mukolo gwoshi, abona oku bajizire kulya Nyakasane anarhegekaga kwo na nênè. Okuhandi Mûsa anacibagisha! ");
INSERT INTO shr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Nyakasane anacibwîra Mûsa; erhi: ");
INSERT INTO shr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Omu mwêzi murhanzi, olusiku lurhanzi lw’omwêzi, oyimanze Endâro y’Ecihando c’Ihano. ");
INSERT INTO shr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ohiremwo omucîmba gw’Endagâno, n’ogwo mucîmba, ogubwîkire n’omwenda. ");
INSERT INTO shr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Olêrhe ameza, obambekwo ngasi binakwânîne; olêrhe akamole, ohirekwo orhumole rhwâko. ");
INSERT INTO shr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Oluhêrero lw’amasholo lw’omugavu olugwîke embere ly’omucîmba gw’Endagâno, onamanike omwenda aha muhango gw’Endâro. ");
INSERT INTO shr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Oluhêrero lw’embâgwa oluhire embere ly’omuhango gw’Endâro, embere ly’Ecihando c’Ihano. ");
INSERT INTO shr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Aha kâgarhî k’Ecihando c’Ihano, ohireho omukenzi, onaguhiremwo amîshi. ");
INSERT INTO shr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ohire obululi eyi n’eyi, onahire omwenda aha muhango gw’obululi. ");
INSERT INTO shr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Orhôle amavurha gw’okucîshîga, oshîgemwo Endâro na ngasi birimwo byoshi, oyishîge, n’ebirugu byamwo byoshi, ebè ntagatîfu. ");
INSERT INTO shr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Oshîge oluhêrero lw’embâgwa n’orhulugu rhwoshi, ogishe oluhêrero, onaluhêrere lubè lutagatîfu bwenêne. ");
INSERT INTO shr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Oshîge omukenzi n’amakondo gâgwo, onagugishe. ");
INSERT INTO shr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Olêrhe Aroni n’abagala aha muhango gw’Ecihando c’Ihano, obashuke n’amîshi. ");
INSERT INTO shr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Oyambike Aroni emyambalo mitagatîfu, omushîge onamugishe, lyo akazikola obudâhwa bwâni. ");
INSERT INTO shr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Abagala nabo obalerhe, obayambike orhwanzo, ");
INSERT INTO shr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","obashîge amavurha ak’îshe wâbo, lyo bakazikola obudâhwa bwâni. Obwo bushîge bwabaha obudâhwa bw’ensiku n’amango, kurhenga oku iburha kujà oku lindi.» Mûsa ayîmanika aka-Nyamuzinda ");
INSERT INTO shr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mûsa anacicîbanda omu mikolo, anacijira kulya Nyakasane amurhegekaga kwoshi. ");
INSERT INTO shr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Omu mwêzi murhanzi gw’omwâka gwa kabirhi, olusiku lurhanzi lw’omwêzi, aka-Nyamuzinda kayîmânikwa. ");
INSERT INTO shr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mûsa anaciyîmanza Endâro ashigika ensimikiro, àhirakwo empaho n’emirhamba, agwikakwo emitûngo. ");
INSERT INTO shr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Alambika ihêma oku nyanya ly’Endâro, alilâmbûlirakwo, anahira omufûniko oku nyanya ly’ihêma, nk’oku Nyakasane ànamurhegekaga. ");
INSERT INTO shr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Arhôla Endagâno, ayihira omu mucîmba, ahira emirhamba oku mucîmba anadêkereza omufûniko oku nyanya. ");
INSERT INTO shr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Alêrha omucîmba omu Ndâro, àhirakwo omwenda, abwîkira omucîmba gw’Endagâno, nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ahira ameza omu Cihando c’Ihano, olunda lw’emwênè lw’Endâro emuhanda ya gulya mwenda; ");
INSERT INTO shr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","àdêkerezakwo omulongo gw’emigati, embere za Nyakasane, nka kulya Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ahira akamole omu Cihando c’Ihano, embere z’ameza, olunda luyêrekîre Endâro, emukondwè; ");
INSERT INTO shr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","àyâsa orhumole embere za Nyakasane, nka kulya Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ahira oluhêrero lw’amasholo omu Cihando c’Ihano, embere za gulya mwenda, ");
INSERT INTO shr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","anatumbûkizakwo enshangi y’omugavu, nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ahira omwenda gw’ecisîka aha muhango gw’Endâro. ");
INSERT INTO shr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Erhi àbà amâhira oluhêrero lw’embâgwa aha muhango gw’Endâro y’Ecihando c’Ihano, àrhûlakwo embâgwa n’enterekêro, nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Adêkereza omukenzi ekarhî k’Ecihando c’Ihano n’oluhêrero, ànahiramwo amîshi gw’okukalaba. ");
INSERT INTO shr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mûsa, Aroni n’abagala bàkâgikalabiramwo amaboko n’amagulu. ");
INSERT INTO shr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Erhi bàbâga bajà omu Cihando c’Ihano n’erhi bayegêraga oluhêrero, banakalabe nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ànacijira obululi, entambirbambi z’Endâro, n’oluhêrero, àhirakwo omwenda aha muhango gw’obululi. Mûsa ayûkiriza ntyo emikolo. Irenge lya Nyamuzinda lyabûmba Endâro ");
INSERT INTO shr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ecitù canacibwikira Ecihando c’Ihano, bulya irenge lya Nyakasane lyamàbûmba Endâro. ");
INSERT INTO shr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mûsa àrhacihashaga okujà omu Cihando c’Ihano, bulya ecitù càli cibêziremwo n’irenge lya Nyakasane lyàli libumbire Endâro. Ecitù calusa Bene Israheli ");
INSERT INTO shr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Omu lugendo lwâbo, Bene Israheli bàkâgihandûla erhi ecitù càbâga camârhenga oku nyanya ly’Endâro. ");
INSERT INTO shr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ci erhi ankabîre ecitù cirharhenzirikwo, barhakâg’ihandûla, kuhika olusiku cashubirhenga oku Ndâro. ");
INSERT INTO shr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Bulya ecitù ca Nyakasane cakâgigwa oku Ndâro mûshi na budufu, càlimwo omuliro, omu masù g’iburha lya Bene Israheli lyoshi, omu lugendo lwâbo lwoshi.");
INSERT INTO shr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Nyakasane ahamagalira Mûsa omu kagombe k’endêko, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","oshambâze Ben’Israheli; obabwîre, erhi: Hakajira omuntu muli mwe warhûla Nyakasane enterekêro y’okusingônola, anahâna enterekêro y’ecintu cinene, nîsi erhi cisungunu. ");
INSERT INTO shr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Enterekêro yâge ekaba ya kusingônolwa, ya cintu cinene, anarhûle empanzi erhalikwo ishembo lici. Anayirherekêre aha lusò lw’akagombe k’endêko, lyo esîmîsa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kandi analambûlira okuboko kwâge oku irhwe ly’eyo mpanzi y’okusingônolwa, ebà yamayankirirwa agal’iyêmêrerwa okuyobôlwa. ");
INSERT INTO shr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Anabagira eyo mpanzi y’omucûkà embere za Nyakasane, nabo abadâhwa, bene-Aroni banarherekêra omukò gwâyo, bagende bakangûla nagwo empande zoshi z’oluhêrero luli aha lusò lw’Akagombe k’Endêko. ");
INSERT INTO shr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Bayikûlekwo oluhù, bagal’irhongôla emyanya, ");
INSERT INTO shr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","abadâhwa, bene-Aroni, banalêrha omuliro oku luhêrero, banaguhirakwo enshâli, ");
INSERT INTO shr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Abadâhwa bene-Aroni, banalambûlira erya myanya, ecirhwe haguma n’olujimbi kuli zirya nshâli ziri oku luhêrero, ");
INSERT INTO shr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Banashuka eby’omunda n’ebishugulu n’amîshi, Mudâhwa muguma anabiyôca, bisingônokere oku luhêrero n’omuliro, ebè nterekêro y’obuhumule bw’okurhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Erhi akabà enterekêro yâge eri ya bishwêkwa binyinyi, nsingônolwa ya mwâna-buzi kandi erhi ya omwânahene, anahêra endume erhalikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Anayibâgira lunda Iw’enyanya z’oluhêrero, embere za Nyakasane. Kandi Abadâhwa bene-Aroni banajà bashahuliza omukò omu marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Banayirhongôla myanya-myanya, babilunde haguma n’ecirhwe, n’olujimbi. Omudâhwa agal’ibilambûlira oku nshâli ntwanîre oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Banashuka eby’omu nda n’ebishugulu n’amîshi, Omudâhwa agal’ibirherekêra byoshi oku luhêrero, anabiyokerekwo, bisingônoke. Eri nterekêro nsingônola, nterekêro y’omuliro, buhumule burhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Akabà enterekêro yâge emwa Nyakasane kali kanyunyi, anarherekêre empinga nîsi erhi ngûkù. ");
INSERT INTO shr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Omudâhwa anahêka kalya kanyunyi oku luhêrero, anatwa irhwe n’olûnu, analiyokera oku luhêrero n’omukò gwâko banagushahuliza oku burhambi bwa oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Anakûla kandi oludahusha n’ebirimwo n’enshala, anabikabulira hôfi na oluhêrero olunda Lwa ebuzûka-zûba, halya bakwêba oluvù. ");
INSERT INTO shr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kandi anaberanga kalya kanyunyi mpande ibirhi, ngasi cûbi olwâco lunda buzira kukahumanula. Omudâhwa anakayoca kasingônoke, kasimbûkire oku luhêrero, oku nyanya ly’enshâli ziri oku muliro. Eri nterekêro nsingônola, ya buhumule burhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Erhi hankajira owahâna enterekêro erhali ya kudwa mukò, emwa Nyakasane, enterekêro yâge enabè ya mula gwa nshâno, abulagire amavurha oku nyanya ahirekwo n’enshangi. ");
INSERT INTO shr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Anayihêkera bene-Aroni bo badâhwa na omudâhwa anashamarha oluhi lugumagumà kuli erya nshâno y’omulà ebulagirwekwo amavurha, anarhôla n’erya nshangi yoshi, anayôca eyo ngushe yoshi etumbûkire oku luhêrero nka nterekêro y’okuyibusa. Eri nterekêro eyôcîbwe n’omuliro, ya kisununu kinjà karhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ebisigaliza b’erya ntûlo byanabà bya Aroni n’abagala. Ciri cigabi ca nterekêro ntagatîfu bwenêne c’e nterekêro embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Erhi wankahâna enterekêro y’omugati gw’okuyôkerwa omu ifuru, gunabè mugati gwa mula gwa nshâno erhalimwo lwango lugushemwo amavurha, kandi erhi gundi gurhalimwo lwango gunashîzirwe amavurha. ");
INSERT INTO shr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Erhi wankahêra omugati gwajiragwa aha lukalango, nagwo gubè gwa nshâno ya mula, mvange n’amavurha buzira lwango. ");
INSERT INTO shr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Wanaja wagutwa bihimbi bihimbi, onabulagire amavurha oku nyanya lyâgwo: ekola nterekêro eyo. ");
INSERT INTO shr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Erhi wankarherekêra omugati gwajiriragwa aha nyungu, gujirwe nagwo n’enshâno y’omulà haguma n’amavurha. ");
INSERT INTO shr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Oku bundi wanahêkera Nyakasane enterekêro yamarheganyibwa kwa bene okwo, yanahêkerwa omudâhwa, naye anayihêka oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Omudâhwa anarhôlakwo ebyajibà nterekêro y’okuyibusa, anayiyôkera oku luhêrero, eri nterekêro eyôcîbwe n’omuliro eyo, nterekêro ya buhumule burhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ecigabi cisigîre ciri ca Aroni n’abagala; ciri cigabi ca nterekêro ntagatîfu bwenêne c’enterekêro embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ngasi nterekêro ya nshâno mwankarherekêra Nyakasane, erhajâgamwo lwango, bulya kurhakwânîni muyôce alwango nîsi erhi obûci nka biryo byayôkerwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Wanahasha okurherekêra Nyakasane ebisârûlwa byâwe birhanzi ci birhankahêkwa oku luhêrero nka nterekêro ya kurhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Okaz’ilunga ngasi ntûlo warherekêra Nyamuzinda orhanalekaga okuhira omunyu gw’eciragâne câwe na Nyamuzinda wâwe kw’ebi wamurhûla. Okaz’ihira omunyu muli ngasi nterekêro yâwe yoshi emwa Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nka warhûla Nyamuzinda oku mwâka muhyâhya, wanamurherekêra emihuli mikalange n’omuliro erhi mugati muduge n’enshâno enozire, bibè nterekêro y’omwâka muhyâhya emwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Onadubulire amavurha oku nyanya, oyûshûlekwo enshangi. Yo nterekêro yâwe eyo. ");
INSERT INTO shr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Omudâhwa anasingônola ecihimbi ca gulya mugati gulikwo amavurha haguma n’enshangi yoshi, eri nterekêro ya buhumule bwinjà embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Akabà enterekêro yâge erhi ya kushenga omurhûla, n’akabà eri ya cintu cinene agoshwire okurherekêra, akabà mpanzi erhi ya marhà, erhahîraga ishembo embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Oyo muntu analambûlira okuboko oku irhwe ly’eyôla mbâgwa, agal’iyibâgira aha lusò lw’akagombe k’endêko. N’abadâhwa bene-Aroni, banashahuliza omukò gwâyo omu marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kuli eyo nterekêro banatwa ey’okuyôkerwa embere za Nyakasane, bahirekwo n’amashushi g’oku budiku, n’olujimbi lwoshi, ");
INSERT INTO shr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","anasingônola ensiko zombi n’olujimbi lw’eburhambi bwâzo, amashushi g’oku budiku n’agabwikira ensiko, n’amashushi g’oku mufâmo. ");
INSERT INTO shr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Bene-Aroni banasingônolera ebyo byoshi oku luhêrero. Eyo nterekêro banayibambika oku nshâli batwanira oku luhêrero, yanabà nterekêro y’obuhumule bwinjà burhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Akabà nterekêro ya kusingônolwa ya bishwêkwa bisungunu, ebè ndume erhi nkazi, erhalikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Akabà mwâna-buzi arhûla nterekêro, anamulêrha embere za Nyakasane ");
INSERT INTO shr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","n’eyo nterekêro, anayilambûlirakwo okuboko oku irhwe, agal’iyibâgira embere z’akagombe k’endêko. Na bene-Aroni banashahuliza omukò gwâyo omu marhambi g’oluhêrero goshi. ");
INSERT INTO shr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kuli eyo nterekêro y’okushenga omurhûla, banasingônolera Nyakasane: omucira gwoshi muberûle oku marhungu, olujimbi, amashushi goshi gabwîkira eby’omu nda, ");
INSERT INTO shr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ensiko zombi, amashushi g’oku mifâmo yombi, amashushi g’oku budiku n’ag’oku nsiko zombi. ");
INSERT INTO shr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Omudâhwa anayôkera ebyo byoshi oku luhêrero nka ishêga lisingônolirwe Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Enterekêro ekaba mpene, banayilêrha embere za Nyakasane, ");
INSERT INTO shr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","banalambûlira okuboko oku irhwe lyâyo, bagal’iyibâgira aha kagombe k’endêko. Na bene-Aroni, banashahuliza omukò gwâyo omu marhambi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Yumvagi ebi arhûla Nyakasane nka ishêga lisingônola: Olujimbi luyamvûlwa oku bulà; amashushi gabwîkira eby’omu nda byoshi. ");
INSERT INTO shr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Ensiko zombi, olujimbi luzibwîkira, olujimbi lw’oku mifâmo yombi, n’olubarhûla oku budiku, n’oku nsiko. ");
INSERT INTO shr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Omudâhwa anayôkera ebyo byoshi oku luhêrero, bibè ishêga ly’obuhumule bwinjà na bwa murhûla n’okusîmîsa Nyakasane. Rhumanye oku olujimbi lwoshi luyôsire luli lwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Eryo liyôsire irhegeko linyu ensiku zoshi, na ly’iburha linyu lyoshi, n’aha mwankayûbaka hoshi: murhakâg’ilya oli amashushi, oli omwamba. ");
INSERT INTO shr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nyakasane abwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Oj’ibwîra bene-Israheli oku: erhi omuntu ankavuna irhegeko liguma omu ga Nyakasane buzira luhinzo, kandi erhi ajire akantu kahanzîbwe. ");
INSERT INTO shr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Akabà mudâhwa washîzirwe amavurha ojizire ntyo, anarhuma olubaga lwoshi lwahemuka, eco câha câge canarhuma arherekêra Nyakasane empanzi y’omucûkà erhalikwo ishembo, ebè nterekêro y’okushukûlwa ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Anahâna eyo mpanzi omu lusò lw’akagombe k’endêko, embere za Nyakasane agal’ilambûlira okuboko oku irhwe lyâyo, agal’iyibâgira embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Omudâhwa washîzirwe amavurha, anarhôla oku mukò gw’eyo mpanzi, aguhêke omu kagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ahôla omudâhwa anadobeka omunwe gwâge muli gulya mukò, alabemwo orhufendefende rhw’oluhêrero embere za Nyakasane agal’ijira ecuhâgizo c’okukangûla kali nda koshi embere z’ecisîka c’omu cirhînyiro c’akagombe k’endêko embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Omudâhwa anadêkereza mukò musungunu oku bikwi by’oluhêrero lw’okuyûdukiza enshangi embere za Nyakasane omu kagombe k’endêko, n’omukò gw’empanzi gusigîre gwoshi anagudubulira aha ciriba c’oluhêrero lw’okusingônolera, luyûbake aha lusò lw’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Yumvagi mashushi gahi g’eyo mpanzi yahânwa nterekêro oku byâha gayamvûlwa: olujimbi lubwîkira obulà, amashushi g’oku nyanya ly’eby’omunda goshi. ");
INSERT INTO shr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Ensiko zombi n’olujimbi lwa kulizo, n’olw’oku mifâmo yombi, omubumbuli gw’amashushi ayamvûla oku budiku n’oku nsiko. ");
INSERT INTO shr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Byoshi bibè nterekêro y’okushenga omurhûla, omudâhwa anayôkera ebyo bihimbi oku luhêrero lw’enterekêro mbâgwa. ");
INSERT INTO shr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ci oluhù lw’eyôla mpanzi, n’eminyafu yayo, haguma n’ecirhwe câyo, amagulu, amalà, n’ecihò câyo, ");
INSERT INTO shr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","eyo mpanzi oku enali gumaguma yoshi, anayibarhuza bayihêke kuli n’olugo bulya hali hantu hacîre, hantu hinjà, bayihise halya bakabulira oluvù, bagal’iyisingônolera oku nshâli ndûlike muliro. Aho hantu hacîre bakabulira oluvù lwayagabira mavurha, ho bagwâsirwe okusingônolera eyo mpanzi. ");
INSERT INTO shr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Erhi ankabà olubaga lwa bene Israheli lwoshi lwo lwahemusire, omu kujira ecâha cibonera, omu kujira akantu kahanzîbwe n’amarhegeko ga Nyakasane ciru ankabà olubaga lurhakutwiri ihuzihuzi, ");
INSERT INTO shr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","olubaga lwanahâna enterekêro y’okushukûlwa eco câha, empanzi, cintu cinene c’omu bishwêkwa, cirhalikwo ishembo, lwayihâna erhi ankabà ecôla câha camamanyîkana; banayihugira embere z’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abashamuka b’olubaga, banalambûlira amaboko gâbo oku irhwe ly’erya mpanzi, kandi banayibâgira embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Omudâhwa washîzirwe amavurha anarhôla oku mukò gw’erya mpanzi, anaguhêke omu kagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Agal’idobeka omunwe gwâge muli gulya mukò gw’erya mpanzi, agushahugize n’ecuhâgizo oku lusîka kali nda embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Analaba mukò musungunu oku bikwi by’oluhêrero luli embere za Nyakasane omu kagombe k’endêko. N’omukò gusigîre anagudubulira aha bikondo by’oluhêrero luli aha lusò lw’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kandi anayamvûla amashushi goshi ga wampanzi, anagasingônolera oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Erya mpanzi banayirherekêra nka kulya barherekêra empanzi y’okucêsa omunyabyâha. Ntyo kwo bâkazijira. N’omudâhwa, hano abà amashenga, omu kuhûnira olubaga obwonjo, lwanababalirwa. ");
INSERT INTO shr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kandi anahêka erya mpanzi enyuma z’olugo, bagal’iyisingônola nka kulya kw’entanzi. Eyo yo nterekêro y’okushukûla ebyâha by’olubaga lwoshi. ");
INSERT INTO shr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Erhi ankabà omurhambo ye wajizire ecâha, omu kuhemukira Nyakasane buzira kumanya, bulya amavuna irhegeko lya Nyakasane, Nyamuzinda wâge, kwanarhuma ajira ecâha, ");
INSERT INTO shr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","nîsi erhi bankayish’imubwîra buzinda, oku kwo anahemusire ntyo, agwâsirwe okurherekêra ecihebe cirhalikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Analambûlira okuboko kwâge oku irhwe lya cirya cihebe, bagal’icibâgira halya barherekêrera embâgwa y’okurherekêrwa Nyamuzinda. Eri nterekêro y’okushukûla omunyabyâha. ");
INSERT INTO shr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Omudâhwa, anayanka n’omunwe kuli gulya mukò gw’enterekêro y’okushukûla omunyabyâha, agulabe oku bikwi by’oluhêrero lw’enterekêro, n’ogundi anagudubulira aha bikondo by’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Kandi anasingônolera olujimbi lw’eco cihebe oku luhêrero nk’oku bajira enterekêro y’okushenga omurhûla. Kwo omudâhwa akaz’ishengera ntyo omurhambo. Hano abà amamusengerera obwonjo oku câha câge, anababalirwa. ");
INSERT INTO shr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Erhi ankabà muganda kwônene omu lubaga ye wahemusire, omu kuvuna irhegeko lya Nyakasane, arhanali akutwire ihuzihuzi, anacîbihize bulya anajizire okuhanzîbwe n’irhegeko lya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nîsi bakamubwîra buzinda kulya kubî kwâge, agwâsirwe okushukûlwa ecâha câge anajizire, ahâne empene erhalikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Analambûlira okuboko kwâge oku irhwe ly’eyo nterekêro y’okushukûlwa ebyâha, kandi agend’iyibâgira halya babâgira ezindi nterekêro. ");
INSERT INTO shr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Omudâhwa anarhôla oku mukò gw’eyo nterekêro, anagulabe oku bikwi by’oluhêrero lw’enterekêro, ogundi agudubulire aha bikondo by’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Anayamvûla olujimbi lwoshi, nk’oku bayamvûla olujimbi lw’enterekêro y’okushenga omurhûla, n’omudâhwa alusingônolere oku luhêrero, luhebe obuhumule bwinjà bw’okurhûliriza Nyakasane oku luhêrero. Omudâhwa kwo ajirira omuntu wa bene oyo, cibè cijiro c’okumuhûnira obwonjo, na ntyo ababalirwe eco câha. ");
INSERT INTO shr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Akabà cibuzi arhûla nterekêro ya bene eyo, analêrha omushîbuzi gurhalikwo izâbyo. ");
INSERT INTO shr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Analambûlira okuboko kwâge oku irhwe ly’eyo nterekêro. Agal’ibâgira eyo nterekêro y’okushukûlwa aha babâgira ezindi nterekêro. ");
INSERT INTO shr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Omudâhwa anarhôla mukò musungunu n’omunwe gwâge kuli eyôla nterekêro, agulabe oku bikwi by’oluhêrero lw’enterekêro. ");
INSERT INTO shr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kandi anayamvûla amashushi goshi nk’oku banayamvûla ag’omwâna-buzi w’enterekêro y’okushenga omurhûla. N’omudâhwa anagasingônolera oku luhêrero lw’enterekêro y’ishêga lisingônolere Nyakasane, kwo omudâhwa ajirira omuntu wajizire ecâha ntyo, agal’ibabalirwa. ");
INSERT INTO shr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Erhi hankajira owahirima omu câha, omutwî w’emmanja akahamagala omuhamîrizi n’oyo muhamîrizi akabula okuderha eby’okuli anabibwîne kandi erhi abimanyire, oyôla anacibarhuza obubî bwâge yêne. ");
INSERT INTO shr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Kandi omuntu wahuma oku kantu kagalugalu, nk’omurhumba gw’ensimba ngalugalu, ogw’ecintu cishwêkwa cigalugalu, omurhumba gw’ebinyagâsi, oyo muntu amazira, amâjira ecâha. ");
INSERT INTO shr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kwo kuguma n’ohemuka omu kuhuma oku bihûmânya by’omuntu, erhi ankabà arhamanyiri, nîsi erhi ankayîsh’imanya buzinda ago magalugalu, amâjira ecâha. ");
INSERT INTO shr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Omuntu omu kujalira buzira kusêza, erhi ankajira endahiro omu lucâli, nka arhamayiriri, buzinda bw’aho akahugûkwa, oyo naye ajizire ecâha omu kantu kaguma muli ebyôla. ");
INSERT INTO shr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Owacîhemula omu kantu kaguma muli ebyôla, kukwânîne ahûne obwonjo oku câha câge. ");
INSERT INTO shr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Kuli ecôla câha câge, analêrhera Nyakasane enterekêro y’ecishwêkwa cisungunu (mpene erhi cibuzi) n’omudâhwa anamujirira enterekêro y’okuhûna obwonjo oku câha câge. ");
INSERT INTO shr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Erhi ankabula, oli ecibuzi, oli empene y’okushukûlwa ebyâha byâge, analêrha mahali abirhi ga mpinga, nîsi erhi ngûkù ibirhi. Nguma ebè ntûlo oku byâha byâge, eyindi ebè nterekêro y’okubâgwa. ");
INSERT INTO shr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Anabilêrhera omudâhwa, naye arhang’ihâna enterekêro ntanzi y’okushukûla ebyâha, agal’izîka kalya kanyunyi olûnu, kandi akaniole igosi, buzira kukatwa irhwe, arhakahumanulaga. ");
INSERT INTO shr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Anajira ecuhâgizo. N’omukò gw’erya nterekêro yanigagwa, anajà akangûlamwo omu marhambi g’oluhêrero, n’ogundi anagudwikiza oku bikondo by’oluhêrero. Eyo eri nterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Akandi kanyunyi, anajiramwo enterekêro nsingônola nk’oku binarhegesirwe. Ntyo kwo omudâhwa agwâsirwe okujirira omuntu wa mwene oyo, na ntyo ecâha câge canababalirwa. ");
INSERT INTO shr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Erhi ankabula ago mahali abirhi g’empinga nîsi erhi ezo ngûkù ibirhi, anarhûle ecigabi ca kali ikumi c’enshâno enozire y’omu kwâge ebè nterekêro oku byâha byâge, arhabulagiraga mavurha nîsi erhi nshangi oku nyanya, bulya eri nterekêro y’okushukûlwa ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Anahêkera omudâhwa eyo nshâno, n’omudâhwa anarhôlakwo ecifune, n’eyo nshâno anajiramwo enterekêro y’okusingônolwa oku byâha ajizire embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Eyo eri nterekêro y’oku byâha ajizire muli kantu kalebe na ntyo anabibabalirwa. Enshâno asigîre yanabà y’omudâhwa, nk’oku binayêrekîre enterekêro y’entûlo. ");
INSERT INTO shr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Omuntu erhi ankabà mugalugalu, omu kujira ecâha c’obuhalanjisi akanyomanya oku bintu biyêrekîre enterekêro yajirirwa Nyakasane oyôla muntu anahyule engandabuzi y’omu busô bwâge, erya erhalikwo ishembo, erya yankabà ya ngulo nyinjà, erhi yankagererwa oku ntûlo nyinjà y’omu ka-Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Birya ayankaga oku nterekêro ntagatîfu, okunayûshûlakwo empyûlo y’ecigabi ca karhanu, agal’iyisha abidwîrhîre omudâhwa. Na ntyo omudâhwa anamujirire enterekêro y’okushukûlwa ebyâha, n’erya ngandabuzi y’empyûlo, go mango ankababalirwa ecôla câha. ");
INSERT INTO shr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Omuntu akahemuka, n’omu kuhemuka kwâge, akajira akantu kahanzîbwe n’amarhegeko ga Nyakasane buzira kumanya, oyo muntu yêne dolo agwêrhe obubî, yêne abarhwîre omuzigo gw’obubî bwâge. ");
INSERT INTO shr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Oyo muntu analêrhera omudâhwa oku nterekêro y’obubî bwâge, engandabuzi erhalikwo ishembo, y’omu busô bwâge, erya nyîshogwa. Omudâhwa anamushukûla kulya kuhemuka kwâge arhatwâga ihuzihuzi, na ntyo anababalirwa. ");
INSERT INTO shr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Eyo eri nterekêro y’okuhyûlira obubî bwâge, bulya oyo muntu anali okunali omu bubî embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Nyakasane ashub’ishambâza Mûsa muli ebi binwa: ");
INSERT INTO shr_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Erhi omuntu ankahemuka, agomere Nyakasane omu kurheba owâbo oku kantu abîsibagwa, nîsi erhi oku cêgu, nîsi erhi ankarhebêba owâbo mpu bayongolokane akantu omu kushûma, ");
INSERT INTO shr_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","nîsi owarhôla akantu kàli kahezire, agal’ilahira oku arhakabwîne, kandi erhi alahire ebîra kuli bubî bulebe omuntu ahashire okujira. ");
INSERT INTO shr_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","Omuntu akajira ecâha, canamuhindula ntyo mubî. Agwâsirwe okugalula ebi anayansire, nîsi erhi ebi anasêzagya okuhâbwa busha: Ecêgu babîsagya, akantu kàli kahezire arhôlaga, ");
INSERT INTO shr_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","kandi erhi oku kantu alahiraga ebîra. Anakayushùlakwo ecigabi ca karhanu, abul’igalulira nna kalya kantu kâge, kurhenga amango anal’ikola akagwêrhe. ");
INSERT INTO shr_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Kandi analerhera Nyakasane enterekêro y’okuhyûla, ebè ya ngandabuzi erhalikwo ishembo, y’omu bishwêkwa byâge, erya yankabà ya ngulo nyinjà, agal’iyihà omudâhwa, ebè nterekêro y’okuhyûla. ");
INSERT INTO shr_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Go mango omudâhwa ankamujirira enterekêro y’okushukûlwa embere za Nyakasane. Kandi anababalirwa ecâha câge, ciru cankaneneha. ");
INSERT INTO shr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Nyakasane ashub’ishambâza Mûsa muli ebi binwa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Ohè Aroni n’abagala erîra irhegeko: Alagi irhegeko ly’enterekêro y’ensirîra. (Yo nterekêro ekâyôrha yadurha muliro ngasi lusiku, enakaz’isirizibwa n’omuliro oku luhêrero, obudufu bwoshi kuhika sêzi. N’omuliro gw’oku luhêrero gunakaz’iyôrha mutwâne). ");
INSERT INTO shr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ngasi sêzi omudâhwa, hano abà amayambala akanzo kâge k’enondwè, n’ehikenyerwa hy’enondwè anaguka oluvù lw’eyo nterekêro yasingônokeraga oku luhêrero, aludekereze eburhambi bw’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Aho anahogola erya myambalo yâge, ashub’iyambala ey’okugend’ikabulira lulya luvù lwayagabira ahantu hacîre, kuli n’olugo. ");
INSERT INTO shr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Omuliro gw’oku luhêrero lw’okusingônolera, gukâyôrha guyâsire buzira okuzima. Ngasi sêzi omudâhwa akaz’ilunda kwo enshâli, analambikekwo enterekêro, haguma n’amashushi g’enterekêro y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Omuliro gw’ensiku zoshi gukaz’iyôrha gwayâka oku luhêrero, gurhanazimaga ciru n’eriguma. ");
INSERT INTO shr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Lolaga irhegeko ly’enterekêro nkalangwa: Muguma muli bene-Aroni anayisha ayidwîrhîre Nyakasane embere z’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Anashamarha ecifune omu nshâno enozire badwîrhe, mvange n’amavurha n’enshangi yoshi y’enterekêro, agal’iyokera ebyo byoshi oku luhêrero, bibè nterekêro y’obuhumule bwinjà bw’okurhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ebyankasigala kuli erya nkalangwa, Aroni bône abagala banabirya, babirye nka mugati gurhalimwo lwango. Babirîre ahantu hatagatîfu, omu cirhînyiro c’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mw’ogwo mugati barhakâg’iyokeramwo olwango, ciri cigabi câbo mbahire kuli eyo nterekêro. Kali kantu katagatîfu ako bwenêne, kwo kunali kuguma n’enterekêro y’okuhûna obwonjo oku byâha, kwo na kuguma n’enterekêro y’okulyûla. ");
INSERT INTO shr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ngasi mulume omu bâna ba Aroni analyakwo. Lirigi irhegeko ly’ensiku zoshi oku iburha linyu na ngasi yêshi wankahumakwo anabà Mutagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Alaga enterekêro Aroni n’abagala bâkaz’ijirira Nyakasane olusiku lwâbo lw’okushîgwa amavurha matagatîfu: Ecigabi ca kali ikumi c’omulà gw’enshâno enozire, ebè nterekêro y’ensiku n’amango, barhûle ecihimbi sêzi, n’ecindi cihimbi bijingo. ");
INSERT INTO shr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Yakaz’irheganyibwa aha lukalango haguma n’amavurha, wanalêrha omugati, ojè waguvuna bihimbi bihimbi, n’okugurherekêra Nyakasane gubè gwa buhumule bwinjà burhûliriza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Omudâhwa washîgwa amavurha omu bâna ba Aroni kwo agwâsirwe okujira ntyo. Lyayôrha irhegeko ly’ensiku n’amango. Eyo nterekêro yajirirwa Nyakasane egwâsirwe ehwe yoshi yatumbûlira omugî enyanya. ");
INSERT INTO shr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Enterekêro erhûzirwe n’omudâhwa, egwâsirwe okusingônolwa yoshi, barhalyagakwo ciru n’ehitya. ");
INSERT INTO shr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Nyakasane abwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Obwîre Aroni n’abagala ntyâla: Alagi oku mwakâjira nka mwarhûla enterekêro y’okushukûla abanyabyâha. Enterekêro Nyakasane arhûlwa ekâbâgirwa embere zâge halya bajirira enterekêro nsingônola. Kali kantu katagatîfu bwenêne. ");
INSERT INTO shr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Omudâhwa wahânaga enterekêro y’okushukûla ebyâha, yeki wankalya eyo nyama, ayirire ahantu hatagatîfu omu cirhînyiro c’akagome k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ngasi yêshi wankahuma oku nyama yayo, anabè Mutagatîfu. Erhi omukò gwâyo gwankashahukira oku mwambalo, halya gwashahukiraga hanagend’ishukirwa ahantu hatagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Enyungu y’ibumba bayiyenderagamwo, kukwânîne eberwe, ci erhi ankabà nyungu ya mulinga yayenderagwamwo, kukwânîne bayicêse bwinjinjà omu kuyishuka n’amîshi. ");
INSERT INTO shr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ngasi mulume muli bene-Levi, anahasha okulya kw’eyo nyama bulya kali kantu katagatîfu bwenêne. ");
INSERT INTO shr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ci barhankalya enyama y’enterekêro yarhûlagwa oku kushukûla ebyâha, n’omukò gwâyo gwahêsirwe omu kagombe k’endêko bajiramwo olukangûlo, lw’okushukûla omu hantu hatagatîfu. Ci eyo nyama esingônolwe n’omuliro. ");
INSERT INTO shr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Alaga irhegeko liyêrekîre enterekêro y’okulyûla ebyâha: Kali kantu katagatîfu bwenêne. ");
INSERT INTO shr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ho banagwâsirwe okubâgira enterekêro y’okulyûla ebyâha aha banayôrha babâgira enterekêro y’okusingônolwa, n’omudâhwa anabulagira omukò gwâyo omu marhambi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Barherekêrerekwo olujimbi lwoshi, omucira, amashushi gabwîkira eby’omu nda, ");
INSERT INTO shr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","barherekêrerekwo n’ensiko zombi, n’olujimbi luzibwîkira, n’olwa oku mifâmo yombi, olujimbi lubà oku budiku haguma n’olw’oku nsiko. ");
INSERT INTO shr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Omudâhwa asingônolere ebyo bigabi oku luhêrero, nka nterekêro ya muliro, yarherekêrwa Nyakasane. Erigi nterekêro ya kulyûla. ");
INSERT INTO shr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ngasi bûko mulume muli bene-Levi, analya oku nyama zâyo, anayirîre ahantu hatagatîfu, bulya buli bwangà butagatîfu bwenêne. Ebigabi omudâhwa ayôrhana ");
INSERT INTO shr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Enterekêro y’okuhyûla kuguma ejirwa n’okushukûla ebyâha. Irhegeko linali liguma kuli zombi. Enyama yabâgagwa yabà y’olya mudâhwa warherekêraga eyo ntûlo y’okulyûla. ");
INSERT INTO shr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Embâgwa omuntu alêrheraga omudâhwa mpu amuhânire nterekêro, oluhù lwâyo lwayîsh’ibà lw’olya mudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ngasi nterekêro yakalangiragwa omu cibekenge c’omuliro, kandi erhi omu nyungu, nîsi erhi aha lukalango enali y’olya mudâhwa warherekêraga. ");
INSERT INTO shr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ngasi nkalange n’amavurha, nîsi erhi ntale, enali ya bene Aroni boshi, ngasi muguma nk’owâbo bakaz’ihâbwa ecihimbi ciyumânîne. ");
INSERT INTO shr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Alaga irhegeko ly’omurhûla bakaz’irherekêra Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Erhi ankabà eri nterekêro y’okukuza Nyakasane, banayûshûlako enterekêro y’okuvuga omunkwa, haguma n’orhugati rhwa ngasi lubero rhurhalimwo lwango, rhukalange n’amavurha, n’enshâno y’orhugati ebè ndobeke omu mavurha. ");
INSERT INTO shr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kuli rhulya rhugati rhwayûshûlagwa oku nterekêro y’omurhûla, banayûshûlakwo n’omugati gubumbugusire, nagwo gubè guyushwîre enterekêro y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Banarherekêra Nyakasane higati higuma higuma kuli ngasi lubero. Rhulya rhugati rhwanayîsh’ibà rhw’omudâhwa wagend’ijira olukangûlo lw’omukò gw’erya nterekêro y’omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Enyama z’erya nterekêro y’omurhûla zanalibwa olwo lusiku lwonênè yanarherekêragwamwo. Ntâco cahika kuca sêzi. ");
INSERT INTO shr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Erhi ankabà eri nterekêro y’okuyûkiriza eciragâne nîsi erhi omuhigo, banayiryakwo olusiku lwonênè yarherekêragwa, nîsi erhi ciru na kuca. ");
INSERT INTO shr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ebyankasigala kuli eyo nterekêro, olusiku lwa kasharhu, binasingônolwe n’omuliro. ");
INSERT INTO shr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Erhi omuntu ankalya oku nyama y’enterekêro yâge y’omurhûla olwo lusiku lwakasharhu, eyi nterekêro erhankaciyankirirwa, olya wayihânaga arhankaciyîbukwa. Bakola bayizizize na ngasi yêshi wankayiryakwo obubî bwanamuyahukira. ");
INSERT INTO shr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Enyama yahisire oku bintu bigalugalu, erhankacirîbwa, enasingônolwe n’omuliro. Ngasi muntu orhalikwo bubî buci anahasha okulya kw’eyo nyama y’omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Erhi omuntu ankabà ahumanyire agal’ilya kuli erya nyama y’enterekêro y’omurhûla barhûlaga Nyakasane, agwâsirwe okukagwa omu lubaga lwâbo. ");
INSERT INTO shr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Na ngasi yêshi ohumire oku bintu bigalugalu, bibè bya muntu bibè bya nsimba, erhi bya kandi kantu k’okuhumânya, agal’icîshomya okulya oku nterekêro y’okushenga Nyakasane omurhûla, oyôla anakagwe omu lubaga lwâbo. ");
INSERT INTO shr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Nyakasane abwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Obwîre bene Israheli, erhi: Irhondo murhahîraga mukalya olujimbi lw’enkafu, olw’ecibuzi nîsi erhi olw’empene. ");
INSERT INTO shr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Amashushi g’ecintu cacîhozagya, nîsi erhi g’ecamayîrhwa n’ensimba, mwanagakolêsa oku bindi, ci murhagalyagakwo. ");
INSERT INTO shr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Bulya ngasi wankalya oku mashushi g’ecintu barherekêraga Nyakasane anakagwe omu lubaga lwâbo. ");
INSERT INTO shr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Murhankalya omukò gw’oli orhunyunyi, oli ogw’ebintu n’ogw’ensimba ngasi aha mwankayûbaka hoshi. ");
INSERT INTO shr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Owankalya omukò mulebe, banamukage omu lubaga lwâbo. ");
INSERT INTO shr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Nyakasane ashambâza Mûsa, erhi: Obwîre bene Israheli ntyâla: ");
INSERT INTO shr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Ngasi yêshi wankanayisha al’irhûla Nyakasane enterekêro y’omurhûla, agwâsirwe okuyûshûla ecihimbi c’eyo nterekêro oku ntûlo y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Anayisha afumbasire omu maboko gâge birya byarhûlwa Nyakasane, kwo kuderha analêrha amashushi g’oku nkolo. Analêrha n’enkolo yo ayish’irhûla Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Omudâhwa anasingônolera galya mashushi oku luhêrero, n’Aroni bône abagala bahâbwe enkolo. ");
INSERT INTO shr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kuli eyo nterekêro, mwakaz’iyûshûlakwo okugulu kulyo, kubè kw’omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Olya warherekêraga omukò n’amashushi muli bene Aroni, anahâbwa okwo kugulu kulyo. Gwo mwanya gwâge. ");
INSERT INTO shr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Oku ntûlo ya bene Israheli, ncîhalîre eyi myanya: Okugulu n’enkolo, mbihîre omudâhwa Aroni n’abagala. Eryo liri irhegeko ly’ensiku zoshi kuli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Eco co cigabi ca Aroni oku nterekêro nsingônola, na kandi co c’abagala olusiku Aroni abayêrekana emwa Nyakasane mpu babè badâhwa bâge. ");
INSERT INTO shr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Co cigabi Nyakasane arhegesire abadâhwa okukâhâbwa na bene Israheli eco kurhenga olusiku lw’okuyimânikwa n’amavurha. N’okwo kwayôrha irhegeko ly’ensiku n’amango, oku iburha lyâbo lyoshi. ");
INSERT INTO shr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Lyo irhegeko mmuhîre eryo, oku nterekêro nsingônola, n’oku y’enkalangè, oku nterekêro y’okushukûlwa ebyâha, n’ey’okulyûla oku byâha, oku y’okuyîmikwa, n’oku y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ntyo kwo Nyakasane arhegesire Mûsa oku ntondo ya Sînayi, olusiku àhâga bene Israheli amarhegeko g’okuhâna entûlo zâbo, erhi bali omu irungu ly’e Sînayi. ");
INSERT INTO shr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nyakasane ashub’ibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Orhôle Aroni boshi n’abagala, orhôle emyambalo, amavurha matagatîfu, orhôle empanzi y’enterekêro y’okushukûla ebyâha, orhôle engandabuzi zombi, n’ecirhimbiri c’emigati erhalimwo lwango. ");
INSERT INTO shr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Oshubûze olubaga lwoshi, lushimânane aha kagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mûsa anacijira nk’oku Nyakasane amurhegekaga. Olubaga lwajà aha kagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mûsa anacibwîra olubaga, erhi: «Yumvagi ebi Nyakasane anarhegesire okujira.» ");
INSERT INTO shr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mûsa ashegereza Aroni n’abagala embere zâge, abashuka n’amîshi. ");
INSERT INTO shr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Anaciyambika Aroni akanzo, akasêza n’omushumi, ahirakwo n’ecishûli n’omwirhêro n’omushumi gwâgwo. ");
INSERT INTO shr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Amuzonza omushumi gw’omwirhêro, lyo gumusêrakwo, amuyambika omuroha gujagalîre «Urim na Tummim». ");
INSERT INTO shr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Amwambika ishungwè ly’obukulu, linaganyirekwo olugole lw’amasholo, co cimanyîso c’okuyimânika enterekêro ntagatîfu nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mûsa ayanka amavurha matagatîfu agalabamwo endâro ya Nyakasane na ngasi byoshi byalimwo. ");
INSERT INTO shr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Akangûla oluhêrero kali nda, analushîga amavurha matagatîfu kuguma n’orhulugu rhwalimwo rhwoshi, kandi n’olwôgero n’ensigiko zâlwo lyo abigisha. ");
INSERT INTO shr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mûsa adubulira amavurha matagatîfu oku irhwe lya Aroni, amushîgago omu kumugisha. ");
INSERT INTO shr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Mûsa ashegeza emunda ali, bagala ba Aroni, abayambika orhwanzo n’emishumi, anabayambika orhusirha nk’oku Nyakasane anal’imurhegesire. ");
INSERT INTO shr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Enyuma zâbo alêrha empanzi y’enterekêro y’okushukûla ebyâha. Aroni bona abagala banacilambulira amaboko gâbo okw’irhwe ly’erya mpanzi. ");
INSERT INTO shr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mûsa ayibâga, anarhôla omukò n’omunwe gwâge, agulaba oku mahembe g’oluhêrero, n’omu marhambi goshi, acêsa oluhêrero; adubulira ogundi mukò gwasigalaga aha bikondo by’oluhêrero, anacilugisha omu kujirirakwo enterekêro y’okushukûla ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Buzinda bw’aho arhôla amashushi gabwîkira eby’omu nda byoshi, olujimbi lwa oku budiku, n’ensiko zombi n’olujimbi lwâzo, Mûsa abiyokera oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ci eyo mpanzi, oluhù lwâyo, eminyafu, n’ecihò câyo aj’ibiyokera eburhambi bw’olugo, nk’oku Nyakasane anal’irhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Mûsa ashegeza engandabuzi y’enterekêro y’okusingônolwa, Aroni n’abagala, banaciyilambûlirakwo amaboko gâbo oku irhwe. ");
INSERT INTO shr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mûsa anaciyibâga, n’omukò gwâyo agudubulira omu marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Anacikobôla erya ngandabuzi myanya myanya. Mûsa asingônola ecirhwe n’erya myanya n’olujimbi. ");
INSERT INTO shr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Bashuka n’amîshi amalà n’ebishugulu; Mûsa ayokera ntyo erya ngandabuzi oku luhêrero yasingônoka, yabà nterekêro nsingônole, ya buhumule bwinjà, yo nterekêro eyôcîbwe n’omuliro, nterekêro ya Nyakasane nk’oku anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Anacishegeza erya yindi ngandabuzi, yo ngandabuzi y’enterekêro y’okuyîmika Aroni n’abagala. Aroni n’abagala banacilambulira amaboko oku irhwe lyâyo. ");
INSERT INTO shr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mûsa anaciyibâga, ayanka oku mukò gwâyo, agulaba oku kurhwiri kulyo kwa Aroni, n’oku cunkumwe câge c’ekulyo n’oku ino linene ly’ekulyo. ");
INSERT INTO shr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ashegeza bagala ba Aroni emunda ali, aj’alâba okurhwiri kwâbo kulyo, ecunkumwe câbo c’ekulyo n’ino lyâbo linene na gulya mukò. Okubundi Mûsa anacidubulira omukò gwasigalaga omu marhambi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Anaciyanka amashushi, omucira, olujimbi lubwîka eby’omu nda, olw’oku budiku, ensiko zombi n’amashushi gâzo, n’okugulu kulyo. ");
INSERT INTO shr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Na muli cirya cirhimbiri c’emigati erhalimwo lwango càli embere za Nyakasane, arhôlamwo ehigati hirhalimwo lwango, n’ehigati hikalange n’amavurha n’ehindi higati hy’olununîrizi; ebyôla byoshi abidêkereza oku mashushi na kuli kulya kugulu kulyo. ");
INSERT INTO shr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Anacibimoleka Nyakasane akabimogamoga nka nterekêro yamogwa embere za Nyakasane kandi abihira omu maboko ga Aroni n’aga abagala. ");
INSERT INTO shr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mûsa abirhenza omu maboko gâbo, abisingônolera oku luhêrero. Yali nterekêro y’okuyimânikwa na ya buhumule bwinjà y’okusîmîsa Nyakasane, bintu bya kusingônolera Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mûsa ayanka enkolo y’erya ngandabuzi, ayimoleka Nyakasane, nka nterekêro yamogamogwa embere za Nyakasane. Co càli cigabi ca Mûsa ca kuli erya ngandabuzi y’okuyimânika nk’oku Nyakasane amurhegekaga. ");
INSERT INTO shr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mûsa anacirhôla kuli galya mavurha matagatîfu na kuli gulya mukò gwàli oku luhêrero, abishahulizakwo Aroni n’abagala n’emyambalo yâbo. ");
INSERT INTO shr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mûsa anacibwîra Aroni bona abagala, erhi: «“Muyendere enyama aha muhango gw’akagombe k’endêko; ahôla ho mwanayilira n’omugati guli omu cirhimbiri c’okuyîmika nka oku narhegekaga erhi nderha”, nti: “Aroni bône abagala bakaz’iyirya”. ");
INSERT INTO shr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","“N’ebisigaliza by’erya nyama n’omugati, mubiyôce bisingônoke n’omuliro”. ");
INSERT INTO shr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","“Mujire nsiku nda buzira kuhuluka omu kagombe k’endêko kuhika ensiku z’okuyîmikwa kwinyu zihwe; bulya okuyîmikwa kwinyu kugwâsirwe okushinga nsiku nda”. ");
INSERT INTO shr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","“Ebi mujiriwe ene, Nyakasane arhegesire okumujirira byo nsiku nda, lyo mushukûlwa bwinjinjà”. ");
INSERT INTO shr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","“Mukâbêra nsiku nda, mûshi na budufu aha lusò lw’akagombe k’endêko; mushimbe amarhegeko ga Nyakasane goshi, lyo murhag’ifà. Ntyo kwo narhegesirwe.”» ");
INSERT INTO shr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aroni n’abagala bajira kulya Nyakasane arhegekaga Mûsa kwoshi. ");
INSERT INTO shr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Oku lusiku lwa kali munâni. Mûsa ahamagala Aroni, abagala n’abagula b’omu Israheli ");
INSERT INTO shr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","abwîra Aroni, erhi: «Oyanke akanina k’omudege kabè nterekêro y’okushukûla ebyâha, n’engandabuzi ebè nterekêro ya okusingônola, byombi birhabâga kwo ishembo lici, obirherekêre Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","“Obwîre bene Israheli ntyâla”, erhi: “Murhôle ecihebe c’okujira enterekêro y’okushukûla ebyâha, akanina n’omwâna-buzi wa mwâka muguma. Byombi birhabâgakwo ishembo, mubirhûle nterekêro y’okusingônolwa”. ");
INSERT INTO shr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","“Muyanke empanzi n’engandabuzi mubirhûle nterekêro y’okushenga omurhûla, kubibâgira Nyakasane munarherekêre enkalangè yarhobagwa n’amavurha, bulya ene Nyakasane amubonekera”». ");
INSERT INTO shr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Banaciyisha badwîrhe embere z’akagombe k’embugânano ebi Mûsa anarhegekaga; olubaga nalwo lwayegera lwadêka embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Okubundi Mûsa anacibabwîra, erhi: «Mujire oku Nyakasane amurhegeka, na ntyo mwabona irenge lyâge». ");
INSERT INTO shr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mûsa abwîra Aroni, erhi: «Yegera oluhêrero, orherekêre enterekêro yâwe y’okushukûlwa ebyâha, n’enterekêro yâwe nsingônola kuli we wênene na oku nyumpa yâwe, n’oku lubaga lwoshi. Yêrekanaga entûlo y’olubaga onalujirire enterekêro y’okushukûlwa ebyâha, nka kulya Nyakasane anarhegekaga». ");
INSERT INTO shr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aroni ayêgera oluhêrero, aniga akanina k’enterekêro y’okushukûlwa ebyâha. Yo nterekêro yâge yênene. ");
INSERT INTO shr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Bene Aroni erhi babà bamamuhêreza omukò, agudobekamwo omunwe alabamwo amahembe g’oluhêrero, n’ogundi agudubulira aha bikondo byâlwo. ");
INSERT INTO shr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Oku luhêrero asingônolera kwo olujimbi, ensiko, amashushi g’oku budiku bwa erya mbâgwa y’okushukûla ebyâha nka oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ci eminyafu n’oluhù byasingônolerwa enyuma ly’olugo. ");
INSERT INTO shr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aniga enterekêro y’okusingônola. Na bene Aroni erhi babà bamamuhêreza omukò, agushahuliza oku luhêrero, n’omu marhambi goshi. ");
INSERT INTO shr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Bamuhêreza enterekêro nsingônola, erhi babà bamayirhondôla myanya myanya bamuhêrezayo haguma n’ecirhwe, naye abisingônolera oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ashuka eby’omu nda n’ebishugulu n’amîshi, abisingônolera oku luhêrero haguma n’erya mbâgwa. ");
INSERT INTO shr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kandi ahâna enterekêro y’okushukûla olubaga, ayanka ecihebe cal’ihanyirwe n’olubaga c’okujira enterekêro y’okushukûla ebyâha byâlwo. Erhi abà amacibâga, ajiramwo enterekêro y’okuhyûlira ebyâha nka kulya anajiraga entanzi. ");
INSERT INTO shr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ayêgeza erya nterekêro nsingônola, ajira nka kulya birhegesirwe. ");
INSERT INTO shr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Erhi ayûs’iyegeza enterekêro y’okukalangwa, ashamarhakwo ecifune, acisingônolera oku luhêrero oku nyanya z’eyo mbâgwa y’esêzi. ");
INSERT INTO shr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Buzinda abâga empanzi n’engandabuzi nka nterekêro y’okushengera olubaga omurhûla, bene Aroni bamuhêreza omukò, agudubulira omu marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Arhôla olujimbi lwa erya mpanzi n’olwa erya ngandabuzi haguma, omucira, amashushi g’oku mucira, ensiko n’amashushi g’oku budiku. ");
INSERT INTO shr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Alambika byoshi oku rhumême, byoshi abilangika oku luhêrero anabisingônola. ");
INSERT INTO shr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kandi Aroni amoleka Nyakasane rhulya rhumême n’okugulu kulyo, akabimogamoga nka oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Obwo Aroni anacilambûlira amaboko gâge oku lubaga, alugisha, agal’ibunguluka erhi amâhâna enterekêro y’okushukûlwa ebyâha, kuguma n’enterekêro y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mûsa boshi n’Aroni, banacijà omu kagombe k’endêko, barhengamwo, bagisha olubaga, n’irenge lya Nyakasane lyabonekana omu lubaga lwoshi. ");
INSERT INTO shr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","N’omuliro gwayâkaga embere za Nyakasane, gwalya erya mbâgwa na galya mashushi, olubaga erhi lubona okwo, lwabanda orhuhababo rhw’omwîshingo, boshi bafukamiriza, bahisa akamalanga oku idaho. ");
INSERT INTO shr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Bene Aroni: Nadabu na Abihu, banacirhôla ngasi muguma ecitumbûkizo câge bahiramwo omuliro n’erhi babà bamâhira obukù kuli gulya muliro, oku gurhamanyikini gurhanarhegesirwi na Nyakasane bagal’iguhêka embere zâge. ");
INSERT INTO shr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lêro engulumira y’omuliro yanacimanuka emalunga embere za Nyakasane yabamirangusa, bafîra ntyo embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mûsa anacibwîra Aroni, erhi: «Byo Nyakasane aderhaga ebi galya mango arhurhôndaga, erhi: “Nnonza obutagatîfu bwâni bubonekane muli abanyegêra; nnonza n’irenge lyâni libonekane embere ly’olubaga lwoshi”». Aroni aguguma. ");
INSERT INTO shr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mûsa ahamagala Mishaheli na Elisafani mwene Uzieli mwishè wa Aroni, anacibabwîra, erhi: «Yêgeri muhêke benewinyu embuga, kulî kw’ahatagatîfu, na kulî kw’olugo». ");
INSERT INTO shr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Banaciyegera, bagenda babajagajagira omu rhwanzo rhwâbo kuhika emuhanda gw’ecihando nka kulya Mûsa anarhegekaga. ");
INSERT INTO shr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mûsa ashub’ibwîra Aroni n’abagala, Eleyazari na Itamari, erhi: «Mumanye mwankaderha mpu mwashambûla emviri zinyu, nîsi mpu mwabera emyambalo yinyu, murhafe, lubaga lwoshi Nyakasane abêrire burhè. Bene Israheli boshi balakira bene winyu bahyaga n’omuliro gwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","“Ci mwêhe murhahîraga mukarhenga aha kagombe k’endêko, lyo murhag’ifà, bulya mulikwo amavurha matagatîfu ga Nyakasane”». Banacishimba akanwa ka Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nyakasane ashambâza Aroni, aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Orhakazâg’inywa idivayi nîsi erhi cindi cinyôbwa cilalusa, we n’abâna bâwe boshi nka mwaja omu kagombe k’endêko, lyo murhag’ifà. Liri irhegeko oku bûko bwinyu boshi emyâka n’emyâka. ");
INSERT INTO shr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","“Kwo mwanakaz’ijira ntyôla amango muli mwaberûla ebitagatîfu n’ebirhali bitagatîfu ");
INSERT INTO shr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","N’amango muli mwayigîriza bene Israheli amarhegeko Nyamubâho ajiraga anagaha Mûsa mpu ammumanyise go”». ");
INSERT INTO shr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mûsa anacibwîra Aroni, Eliezari na Itamari, bo bâna Aroni alicisigaline, erhi: Muyanke ngasi bisigîre oku nterekêro yajiragwa n’omuliro embere za Nyakasane, mubirye birhanalimwo lwango. Mubilîre embere z’oluhêrero bulya buli bwangà butagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mwakaz’ibilîra ahantu hatagatîfu; co cikono câwe eco mwene bagala bâwe, oku ishêga lya Nyakasane. Ntyo kwo narhegesirwe. ");
INSERT INTO shr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Na kandi, mukâlira ahantu hinjà, we na bagala bâwe na bâli bâwe mweshi, e­nkolo mwamolekaga Nyakasane omu kuyimogamoga, n’okugulu bamukobôleraga, bulya eyo myanya emuberûlîrwe mwe na bagala na bâli bâwe, oku nterekêro z’omurhûla za bene Israheli. ");
INSERT INTO shr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Okugulu kukobôle n’enkolo, birya biyisha haguma n’olujimbi lw’okusingônolwa, byamayus’imolekwa Nyakasane omu kumogamogwa embere zâge, byakaz’ibà byâwe mwene bagala bâwe. N’o­kwola kwayôrha irhegeko lya Nyakasane ensiku n’amango nka oku anarhegekaga. ");
INSERT INTO shr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mûsa adôsa olwa cirya cihebe cabâgiragwa okushukûla ebyâha: Yajewe! Coshi càsingônosire! Aho anacikunirira Eliezari na Itamari, bene Aroni balici­sigire, ababwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Carhumire murhalira erya mbâgwa yarherekêragwa okushukûla ebyâha, ahantu hatagatîfu? Bulya buli bwangà butagatîfu. Na Nyakasane amuhirebwo lyo mukaz’irhenza ebyâha bya olubaga omu kukaz’ilujirira enterekêro y’okulyûla ebyâha embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Omu kubà omukò gw’eyi mbâgwa gurhahêsirwi ahantu hatagatîfu, mwâli mugwâsirwe okulya enyama zâyo nka kulya nanarhegekaga. ");
INSERT INTO shr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroni abwîra Mûsa, erhi: Lolà oku ene bahânyire enterekêro y’okushukûla ebyâha, kandi bajira enterekêro nsingônola embere za Nyakasane Niono nciryaga kuli eyo mbâgwa y’okushukûla ebyâha, ka kwankabire kwinjà embere za Nyakasane? ");
INSERT INTO shr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mûsa ayumvîrhiza e­byo binwa byanamusîmîsa. ");
INSERT INTO shr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nyakasane ashambâza Mûsa na Aroni, anacibabwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Mugend’i­bwîra bene Israheli, erhi: Alagi ebintu mwakaz’ilya omu bintu byoshiby’ahôla igulu. ");
INSERT INTO shr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ngasi nsimba egwêrhe ensenyi zigabanyikîne, nsenyi mberange zirya zigwêrhe nyûnu ibiri n’akabà enavuguse, mwanayilya. ");
INSERT INTO shr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ci kwônene lolagi zihi muli ezo zivûgusa erhi nîsi erhi ezigwêrhe ensenyi zigabikine zihi murhankalya, nka engamiya zivûgusa ci zirhajira nsenyi zigabikine, eyo rhuyilole nka ngalugalu kuli mwe. ");
INSERT INTO shr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Kuguma murhakâg’ilya wibari evûgusa ci erhajira lusenyi lugabikîne, eyôsire eri ngalugalu kuli mwe. ");
INSERT INTO shr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Kuguma ntà kulya enshe­nzi, evûgusa ci erhajira lusenyi lugabikîne, muyihanzîbwe. ");
INSERT INTO shr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Kwo na kuguma murhakâg’ilya engulube, egwêrhe olusenyi lugabanyikîne na nyûnu ibiri, ci kwônene erhavûgusa, muyihanzîbwe, bulya eyôsire eri ngalugalu kuli mwe. ");
INSERT INTO shr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Murhahîraga mwalya enyama z’ebyo, murhanahumaga oku murhumba gwa­ byo nka zifîre. Muzihanzîbwe, ziri ngalugalu. ");
INSERT INTO shr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Alagi ehi mwakaz’ilya, omu nsimba zoshi zilama omu mîshi: ngasi zigwêrhe olufuke, amagamba n’omugâra, zibè z’omu nyanja, zibè z’omu marhuli, ezôla mwanahasha okuzilya. ");
INSERT INTO shr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ci mumanye mwankanalya ebirhagwêrhi mase­mbè, kandi erhi magamba, bibè biyôga omu nyanja eri by’omu nyîshi, omu nsimba zoshi zinyagârha omu mîshi na omu ngasi by’obuzîne bibâmwo. ");
INSERT INTO shr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ezôla muzilole nka za kuhumânya, murhankalya enyama zâzo, murhankanahuma oku mirhumba yazo. Emirhumba yazo emujire enshishînye. ");
INSERT INTO shr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ngasi by’omu mîshi birhagwêrhi masembe n’amagamba bikamujira enshishînye. ");
INSERT INTO shr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Lolagi omu nyunyi, ezi mwakabà nshishinye z’okulya: ntâye wazilyaga bulya ziri za nshishinye: ikozi, cigukuma, n’akadûrha. ");
INSERT INTO shr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Lubaka, na ngasi bûko bwa kadûrha. ");
INSERT INTO shr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Ngasi bûko hungwe. ");
INSERT INTO shr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Kuguma enyunda, kahenè, enkongoro na ngasi bûko bwa lubakà. ");
INSERT INTO shr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Murhahîraga mukalya ecirifûfu, kadubamahiri, omwimâna, ");
INSERT INTO shr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","omuhangâli, enyange, cigukuma mwêru. ");
INSERT INTO shr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Murhakâlya hangâli, na ngasi bûko nyunyi z’emirundi mirîrî, hudihudi na kubukubu. ");
INSERT INTO shr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ngasi hinyagâsi hibalala, erhi hiyandalira oku magulu, mubè nshishinye yabyo. ");
INSERT INTO shr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Omu binyagâsi bigwêrhe amashala, bigenda n’amagulu, mwanalya birya bijira eminengene y’okucanuka oku idaho. ");
INSERT INTO shr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Lolagi mulibyo ebi mwanka­lya: ngasi bûko bwa mahanzi, ngasi bûko bwa nzige, ngasi bûko bwa minûnu, ngasi bûko bwa minshekè. ");
INSERT INTO shr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ngasi binyagâsi bijira amashala, binayandalira oku magulu anni, ebyo byoshi mubibè nshishinye. ");
INSERT INTO shr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Okuhuma oku bintu bigalu­galu byanarhuma mwahemuka. Ngasi wankahuma oku murhumba gwâbyo, oyôla anabà ahemusire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ngasi yêshi wabarhule omurhumba gwâbyo, agwâsirwe okushuka emyambalo yâge, erhi anaciyosire muhemule kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ci ensimba zijira ensenyi zirhali mberange, zirhanavugusa, ezôla zibè ngalugalu kuli mwe. Ngasi yêshi wankazihumakwo, erhi amâcîhemula. ");
INSERT INTO shr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Omu nsimba za magulu anni, zigal’ijà zajunjuka nka zagenda, ezo nazo ziri ngalugalu kuli mwe. Ngasi yêshi ohuma oku murhumba gwâzo, oyôla erhi amazira kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Na ngasi yêshi wankaheka omurhumba gwâzo, a­gwâsirwe okushuka emyambalo yâge, kandi anayôrha azizire kuhika bijingo. Ziri ngalugalu. ");
INSERT INTO shr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Lolagi omu nyandazi, ezimuzizire: enfuko, omulindye, na ngasi bûko bwa musherebera. ");
INSERT INTO shr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Namushushu, lumve, kadubankula, ecibulubulu. ");
INSERT INTO shr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ezo zoshi zimuzizire, na ngasi yêshi ozihumakwo erhi amacîhemula anayôrhe azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ngasi kantu kankarhogerakwo omurhumba gwa nguma mulizo, kanazira: ngasi cirugu ca murhi, omushangi, oluhù, enshoho, na ngasi kandi kalugu. Bigwâsirwe bishukwe omu mîshi bigal’iyôrha bihemusire kuhika bijingo na buzinda byanabà birugu binjà. ");
INSERT INTO shr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Erhi byankarhogera omu ndalâlà y’ecirugu c’ibumba, ngasi biri omu ndalâlà yaco, byanazira, kandi mwacinabera ");
INSERT INTO shr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ngasi biryo, byàli muli cirya cirugu ciru byankashukwa n’amîshi, na ngasi cinyôbwa calimwo, ebyo erhi bikola bizizire, ciru ankabà càli cirugu cinjà. ");
INSERT INTO shr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ngasi kalugu omurhumba gwâbyo gwankarhogerakwo, kanazire, amasiga, goshi gajonjagwe, bulya gakolagazizire lwoshi. ");
INSERT INTO shr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ci amaliba, ecirhûla c’amîshi, enyanja zoshi, byôhe byanayôrha bicîre; ci owahuma oku murhumba gwa nyandazi nguma mulizo, anazira. ");
INSERT INTO shr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Erhi murhumba muguma gwa mulizo gwa­ nkahika oku mburho, erhankahumâna. ");
INSERT INTO shr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ci erhi emburho yankabà ebombîre n’amîshi, murhumba gwa nyandazi nguma mulizo gukagal’ihika kuliyo, eyôla mburho enazire. ");
INSERT INTO shr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Erhi cintu cilebe muli birya mukomerera okulya cankafà, owankacihumakwo yêshi anayôrhe mugalugalu kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Owankalya oku murhumba gwâco, oyôla agwâsirwe okushuka emyambalo yâge, agal’iyôrha mugalugalu kuhika bijingo. Naye owankabarhula omurhumba gwâco, a­gwâsirwe okushuka emyambalo yâge anayôrhe mugalugalu kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Mukazibà n’enshishînye oku kantu kacîbulula n’enda oku idaho, bulya birhankalibwakwo. ");
INSERT INTO shr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Murhahîraga mukalya ebintu bibulula enda oku idaho, abè zirya zanyagârhira kuli magulu anni, nîsi erhi kuli magulu manji, bulya ezôla zoshi ziri za kulâbwa nka za nshishinye. ");
INSERT INTO shr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mumanye mwankacîhemula n’ebyo binyagâsi, mumanye mwankanahemuka erhi byo birhuma. ");
INSERT INTO shr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Bulya nie Nyakasane, Nyamuzinda winyu, mwacêsîbwe mwanahinduka bimâna bulya niono ndi mwimâna, mumanye mwankanacîhemula n’ebyo binyagâsi bija byacîbulula oku idaho. ");
INSERT INTO shr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nêci, nie Nyakasane, wammukûlaga e Mîsiri, nti mbè Nyamuzinda winyu, mubè bimâna bulya ndi mwimâna. ");
INSERT INTO shr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Eri ly’irhegeko lyêrekîre ebintu by’amagulu anni, orhunyunyi, ngasi hizîne hiyôga omu mîshi, ngasi nsimba zicîbulula n’enda oku idaho. ");
INSERT INTO shr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ntyo, mwanahasha okukaz’imanya ebiri bigalugalu n’ebiri binjà, ensimba yankalîbwa n’erhankalîbwa. ");
INSERT INTO shr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Oj’ibwîra Bene Israheli, erhi: Omukazi erhi ankaburha omwânarhabana anabêre aha kabazîre nsiku nda. Anacîlange nk’oku ali ayôsire amango ali omu mugongo. ");
INSERT INTO shr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Oku lusiku lwa kali munâni omwâna anaj’ikembûlwa. ");
INSERT INTO shr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Cikwônene anashub’iyôrha ebulinda zindi nsiku makumi asharhu n’isharhu; muli agôla mango, arhankahuma oku kantu kimâna, arhankanaja ahantu himâna, kuhika amango ensiku z’okushukûlwa kwâge zahika. ");
INSERT INTO shr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Erhi ankabà munyere abusire, abêre aha kabazîre migobe ibirhi, nka kulya anayôrhaga amango ali omu mugongo. Anayôrhe ebulinda nsiku makumi gali ndarhu na ndarhu. ");
INSERT INTO shr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Amango ensiku z’okushukûlwa kwâge zahika, akabà mwânarhabana nîsi erhi mwânanyere abusire agwâsirwe okujà emunda omudâhwa ali aha muhango gw’akagombe k’embugânano, anarhûla omwâna-buzi wa mwâka muguma nka nterekêro ya kusingônolwa, kandi anarhûla omwânagoko w’engûkù nîsi erhi wa mpinga: yo nterekêro y’okushukûla ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Omudâhwa anabirherekêra Nyakasane, zibè empyûlo oku mukò gw’oyo muzîre. Lyo irhegeko liyêrekîre omukazi obusire eryo, nka abusire mugala nîsi erhi mwâli. ");
INSERT INTO shr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nka arhankacîbonera omwâna-buzi, anarhûla mahali abirhi ga mpinga erhi ga ngûkù. Nguma eri nterekêro ya kusingônolwa, n’eyindi ebè ya kurherekêrerwa oku byâha. Kandi omudâhwa anamujirira enterekêro y’okuyûkiriza ecîru; kwo na kucêsibwa kwa nyamukazi okwo. ");
INSERT INTO shr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Nyakasane anacibwîra Mûsa n’Aroni, erhi: ");
INSERT INTO shr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Omuntu erhi ankamera­ kwo omubuha nîsi erhi cizimba, nîsi erhi cibungu, na muli oko omu mubiri gwâge mubè obushushubirizi kulya kwankarhuma bacîkebwa mpu lwankanabà lushomyo, oyo muntu banamuhêkera abadâhwa: Aroni erhi muguma omu bagala. ");
INSERT INTO shr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Omudâhwa analolêreza eryo ishembo limuli oku kakoba k’omu­biri: nka olwôya lw’omôla ishembo lwahindusire lwêru lwêru, n’erhi ankabà eryôla ishembo lyahindusire cihulu canajire cabumba omunyafu kurhaluka akakoba k’omubiri, ciyêrekîne oku ciri cihulu ca lushomyo. Nk’omudâhwa amâyûsa okulolêreza oyôla muntu, anamanyîsa oku akola ahumânyire. ");
INSERT INTO shr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Erhi oku kakoba k’omubiri gw’omuntu kwankabà ecibungu cêru cêru, cirhanabonekini oku ciri cirî kulusha akakoba k’omubiri, n’akabà olwôya lurhahindusiri lwêru lwêru, omudâhwa anayegûla oyôla oku bâbo, anamuhîre hâgo hâgo nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Olusiku lwa kali nda, omudâhwa anashub’ilolêreza oyôla muntu. Erhi ankabà ecihulu cibonekine oku cirhaja cayushûka, bulya cirhaja calandira oku mubiri, omudâhwa anashub’imuyegûla oku bandi nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Olusiku lwa kali nda, omudâhwa anashub’ilolêreza obwa kabirhi, erhi ankabona oku ecihulu caja canyiha, ci cirhayushûka oku mubiri, omudâhwa anaderha oku oyôla muntu arhalikwo bubî, bulya liri ishembo lya busha busha. Oyôla muntu ayûs’ishuka emyambalo yâge, anabà mwêru kwêru. ");
INSERT INTO shr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ci erhi ankabà eryo ishembo lyajîre lyalandira oku mubiri, kurhenga galya mango azindig’iciyêreka omudâhwa mpu amanyîse abandi oku arhali wa lushomyo, agwâsirwe ashubire emw’omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Erhi ayûs’imulolêreza, n’aka­bona oku lirya ishembo lyajà lyayushûka oku kakoba k’omubiri, omudâhwa anamanyîsa oku alikwo olushomyo. ");
INSERT INTO shr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Erhi omuntu ankabà alikwo ecihulu c’olushomyo, banamulêrhere omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Omudâhwa anamulolêreza, n’akabona oku kakoba k’omubiri kuli omububa mwêru gurhumire olwôya lumuli luyêruha, n’oku omunyafu muzibu muzibu gwajà gwahumba omubiri, ");
INSERT INTO shr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","luli lushomyo olwo lwajà lwalandira omu mubiri, kwanarhuma omudâhwa aderha oku oyôla muntu ahumânyire. Kukola kurhamira busha okuderha mpu bamuberwire oku bandi bantu, bulya olushomyo lwâge luyôsire lumanyîkîne. ");
INSERT INTO shr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ci erhi ankabà olushomyo lwayisha lwalandira lwanabwîkira omubiri g’olya muntu, olikwo ecihulu kurhenga oku irhwe kuhika oku kugulu, nka oku omudâhwa ankabona n’amasù gâge, ");
INSERT INTO shr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","oyo mudâhwa anashub’ilolêreza, n’akabona olushomyo lwajà lwabwîkira omubiri goshi, anaderha oku oyo muntu arhalikwo ishembo, ci akola mwêru yêshi, bulya byoshi byahindusire byêru, n’ago magamba mêru gahungumuka duba. ");
INSERT INTO shr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ci amango bankabona omubiri gwâge gurhunzire gwanajingûka nka kafinjo, banamanya oku ali mushomyo ");
INSERT INTO shr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nka omudâhwa amâbona oku omubiri gwâge gurhu­nzire, anamanyîsa oku oyo muntu alikwo ishembo, alikwo olushomyo. ");
INSERT INTO shr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Erhi ogwo mubiri gurhunzire gwankahinduka mwêru, oyo muntu anaj’icîyêreka omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Omudâhwa analolêreza oyo muntu, n’akabona omubiri gukola mwêru, anabonera ho oku oyo muntu ogwêrhe omubiri mwêru arhalikwo îshembo. Ali mugumagumà. ");
INSERT INTO shr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Erhi omu mubiri gw’omuntu mwankamera omubuha gw’akafinjo, n’erhi gwankabà gwamarhang’ifuma, kandi ahâli h’omubuha hazûke ow’ecibungu mwêru ");
INSERT INTO shr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","olimwo obudukulà, oyo agwâsirwe okucîyêreka omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Omudâhwa naye amulolereze. Erhi omudâhwa ankabona oyo w’ecibungu ajà alandira omu ndalâlà y’akakoba k’omubiri, n’olwôya lumuli lukola luhindusire lwêru, nyamudâhwa anamanyîsa oku oyo muntu akola azizire, bulya cikola cihulu ca lushomyo cizûsire omwôla mubuha. ");
INSERT INTO shr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ci erhi omudâhwa a­nkabona oku olwôya lurhali lwêru mulya cibungu, n’oku ntà kurhunda kurhalusire akakoba k’omubiri, n’oku cikola caja cayonda, anashub’imuhira hâge hâge nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Erhi omudâhwa ankabona oku ecôla cibungu caja calandira oku mubiri, anamanyîsa oku oyôla muntu ayôsire azizire, luli lushomyo. ");
INSERT INTO shr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ci erhi omudâhwa ankabona oku cirya cibungu cirhaja cayushûka, ci cinaciyôsire oku canali, anamanyîsa oku ekola nzigo ya lirya ihurhe, kugal’irhuma aderha oku oyôla muntu acîbêrîre mwêru kwêru. ");
INSERT INTO shr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Erhi oku mubiri gw’omuntu kwankaja ecibabo c’omuliro, n’erhi mulya cibabo mwankamera ecizimba cirimwo ebyêru nîsi erhi bidukula, ");
INSERT INTO shr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","omudâhwa analolêreza olya muntu, n’erhi ankabà olwôya lwamahinduka lwêru mulya cihulu, nîsi erhi ecibabo cankabonekana oku caja cahumba omubiri kulusha kurhaluka akakoba k’omubiri, luli lushomyo olwo lumezire mw’obwo buhye. Omudâhwa anaderha oku oyo muntu azizire, bulya alikwo ishembo ly’olushomyo. ");
INSERT INTO shr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ci erhi omudâhwa ankabona oku ntà lwôya lwêru luli omu cibabo, na kandi oku cirhaja cabumbugurha omubiri, ci caja canyiha, omudâhwa anashub’iyôrhana olya muntu, ci amuyegûle oku bandi nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Oku lusiku lwa kali nda, omudâhwa anashub’imulolêreza, n’akabà ecôla cibabo caja cayushûka oku mubiri, omudâhwa anamanyîsa oku oyôla muntu azizire, ashomire. ");
INSERT INTO shr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ci erhi cirya cibabo cankaba cirhaja calandira, cirhanaja cahumba, ci kunyiha, caja canyiha, ago mango erhi gunali mubuha gwa muliro kwône, eri nzigo kwône ya muliro. Omudâhwa anamayisa oku oyôla muntu ali muguma­ guma bulya kwàli kurhunda kwa nzigo kwônene. ");
INSERT INTO shr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Erhi omulume kandi erhi omukazi ankamera ennindi oku irhwe nîsi erhi oku ndedu, omudâhwa analolêreza mwa erya nnindi. ");
INSERT INTO shr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Erhi ankabà erya nnindi yajà yahumba akakoba k’omubiri, na kandi erhi ankabà muli olwôya lushusha amâle erhi lubula, omudâhwa anamanya oku oyôla muntu azizire, bulya guli murhondêro gwa lushomyo, lurhangirîre oku irhwe nîsi erhi oku ndedu. ");
INSERT INTO shr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ci erhi omudâhwa ankabona oku eyôla nnindi erhajà yayushûka omu mubiri murhanali lwôya lushusha amâle, omudâhwa anashub’iyegûla oyo muntu nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Olusiku lwa kali nda, anashub’ilolêreza erya nnindi. Erhi ankabà erya nnindi erhajà yayushûka, n’erhi ankabà ntà lwôya lushusha amâle lulimwo, n’eyo nnindi erhajà yahumba akakoba k’omubiri, ");
INSERT INTO shr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","olya ogwêrhwe n’ennindi anamômwe, ci arhamômagwa halya hali ennindi kandi omudâhwa anashub’imuyegûlira hâgo hâgo nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Olusiku lwa kali nda omudâhwa anashub’imulolêreza mulya nnindi, n’akabà erya nnindi erhayushûsiri oku mubiri, ci erhanaja yabumbugurha, omudâhwa anaderha oku oyo muntu ali mugumagumà. Anashuka emyambalo yâge kandi anaderhwe mushugi. ");
INSERT INTO shr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Erhi enyuma z’aho erya nnindi yankajà yayushûka, n’obwo omudâhwa ali erhi amulolerize (anaderha mpu biri binjà), ");
INSERT INTO shr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","omudâhwa anashub’imulolêreza, n’akabà erya nnindi yajà yayushûka oku mubiri, omudâhwa arhacîrhamagya alolêreza erhi muli olwôya lushusha amale, anamanyîse oku oyo muntu ahumânyire. ");
INSERT INTO shr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ci erhi ennindi yankabonekana oku erhajà yayushûka, ci kwônene yajà yameramwo enyôya nyîru, eyo nnindi, kufuma kwâyo okola, oyo muntu ali mwêru kwêru. N’omudâhwa anaderha oku ali mugumagumà. ");
INSERT INTO shr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Erhi omulume kandi erhi mukazi ankalwala olubenja lwêru-lwêru lwalangashana oku mubiri, omudâhwa anagend’imulolêreza, ");
INSERT INTO shr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","erhi olwo lubenja lumezire oku mubiri gwâge lwankabà lwa mwêru gurhanyomwiri, ciri cibungu ecôla camera, oyo muntu ali mwêru-kwêru, arhahumânyiri. ");
INSERT INTO shr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Erhi ankabà omuntu emviri zamuhonyire oku irhwe, lwamabà luhala o­lwo, ali mwêru kwêru, arhahumanyiri. ");
INSERT INTO shr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Erhi ankabà emalanga yo emviri zimuhwire, eri mishosho eyo, ayôsire ali mwêru-kwêru. ");
INSERT INTO shr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ci kwônene erhi omu luhala luli emalanga kandi erhi aha ntondo y’irhwe mwankamera ecihulu cêru cidukulîze, luli lushomyo olwo lwamera emalanga nîsi erhi aha ntondo y’irhwe. ");
INSERT INTO shr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Omudâhwa analolêreza, erhi ankabà ecihulu cirhunzire, cinali cêru ca muduku, cikamera omu luhala aha ntondo y’irhwe, nîsi erhi emalanga, cikana­shusha olushomyo lw’oku cikoba c’omubiri, ");
INSERT INTO shr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","oyo muntu ali mushomyo, azizire, omudâhwa agwâsirwe amanyîse oku azizire, olushomyo okw’irhwe lumurhangirîre. ");
INSERT INTO shr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Omushomyo, akaz’iyambala emishangi esharhangusire na buzira kukombêra emviri, zirhashokozibwi akanabwikira obwânwa bwâge na ngasi ah’agera anajè ayâkûza, erhi: «ndi mugalugalu mugalugalu!» ");
INSERT INTO shr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Oku olushomyo lwâge lucimubâkwo erhi anacizinzire. Arhankabêra haguma n’abandi bantu, ci ayûbake hâge hâge, ci nyumpa yâge ebè kuli kw’ecishagala. ");
INSERT INTO shr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Erhi oku mwambalo kwankabonekana ecibale, akabà mushangi gwaluka­gwa n’amôya erhi nondwè, ");
INSERT INTO shr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","gukabà gundi mwambalo erhi ciru bulingiti bwa môya erhi bwa nondwè, gubè gwa luhù, erhi kandi kantu kajiragwa n’oluhù, ");
INSERT INTO shr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","erhi ankabà ecôla cibale ciri kw’ogwôla mwambalo ciri ca kasi, nîsi erhi ca muduku, akabà oku mwambalo ciri nîsi erhi oku luhù, akabà oku mugozi gw’okuyambala ciri, nîsi erhi oku muhiro kandi erhi oku ifungiro lya akantu kajiragwa n’oluhù, cinali lushomyo. Akola kalugu kanali ka kuyêrekwa omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Omudâhwa hano abà amâlolêreza cirya cibale, kandi anajira aha abîkira kalya kalugu kuhika nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Olusiku lwa kali nda, omudâhwa anashub’ilolêreza cirya cibale, n’akabà caja cayushûka kuli gulya mwambalo, gulya mushangi, bulya bulingiti, gulya muhiro, erhi oku ifungiro ly’oluhù, luli lushomyo lwa kuyahukira. Akola kantu kakola kazizire. ");
INSERT INTO shr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Omudâhwa anayôca gulya mwambalo, erhi gulya mushangi gw’amôya erhi gwa nondwè, bulya bulingiti, lulya luhù erhi kalya kantu kajiragwa n’oluhù, bulya luli lushomyo, lwa kuyahukira, lugwâsirwe okusingônokera omu muliro. ");
INSERT INTO shr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ci erhi omudâhwa ankabona oku cirya cibale cirhajacayushûka mwa gulya mwambalo: gwo mushangi, bwo bulingiti, lwo lulya luhù, kandi erhi kalya kalugu kajiragwa n’oluhù. ");
INSERT INTO shr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Anarhegeka bashuke gulya mwambalo gulikwo obulema, kandi anashub’igulanga zindi nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Oku bundi omudâhwa anashub’ilolêreza gulya mwambalo gwàli gushusirwe. Akabà halya harhacihindusiri, na cirya cibale cirhajire cayushûka, gulya mwambalo guzizire, kukwânîne gudulikwe muliro, bulya olushomyo lwagujîre endalâlà n’emugongo. ");
INSERT INTO shr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ci erhi omudâhwa ankabona oku ecôla cibale, kurhenga amango cashuka­gwa cikola cigwêrhe yindi yindi nshusho, anacikembûla kwa gulya mwambalo, kw’olwo luhù, obwo bulingiti, kandi ehi kwo ako kantu kajiragwa n’oluhù. ");
INSERT INTO shr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Cikashub’ibonekana kuli gulya mwambalo, kuli gulya mushangi, bulya bulingiti, lulya luhù, erhi kalya kantu kajiragwa n’oluhù, kwo kuderha lugendekire. Aho banasingônola n’omuliro kalya kantu kagwâsirwe n’endwâla. ");
INSERT INTO shr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Gulya mwambalo, gwo mushangi, bwo bulingiti, erhi mwambalo gw’oluhù, gwarhenzirekwo obubî erhi kushukwa kurhuma, kukwânîne gushub’ishukwa bwa kabiri lyo bulya bulema burhenga lwoshi lwoshi. ");
INSERT INTO shr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Lyo irhegeko liyêrekîre olushomyo luja oku mwambalo gw’obwôya kandi erhi gw’enondwè: gwo mushangi, bwo bulingiti erhi kalugu kajiragwa n’oluhù akabà kagwâsirwe okude­rhwa kinjà nîsi erhi kazinzire. ");
INSERT INTO shr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Yumva irhegeko liyêrekîre okushukûla omushomyo ");
INSERT INTO shr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Banamuhêkera omudâhwa. N’omudâhwa abà amamurhenza omu cishagala, anamulolêreza. Akabà olya mushomyo anafumire olushomyo lwâge, ");
INSERT INTO shr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","omudâhwa anarhegeka, mpu barhôlere oyo washukûlwa, rhunyunyi rhubirhi rhuzîne na rhwinjà, barhôle n’enshâli z’omuvuye n’omugôla mudukula n’ecuhâgizo. ");
INSERT INTO shr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Omudâhwa anarhegeka okunigira kanyunyi kaguma oku nyanya ly’akabindi kali oku nyanya z’amîshi gahulula. ");
INSERT INTO shr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Na kandi hano abà amârhôla kalya kanyunyi kacizîne kuguma n’olushâli lw’omurhi gw’akarhonda, n’ibuye ly’omugôla, kuguma n’ecuhâgizo anabivumvuza omu mukò gwa kalya kanyunyi kanigiragwa oku kabindi kali oku nyanya ly’amîshi gahulula. ");
INSERT INTO shr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Anakangûla olya mushomyo kali nda na gulya mukò abul’imanyîsa oku akola ali mwêru kwêru, na kalya kanyunyi kali kacizîne banakaleka kabalalire elubala. ");
INSERT INTO shr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Naye olya washukûlagwa, ayôsire ali wa kushuka myambalo yâge, n’okucîmômêsa enyôya zâge zoshi zoshi z’oku mubiri, n’okucîshuka acè yêshi. Buzinda bw’aho naye akola wa kushubira omu cishagala, ci erhi anaciri wa kuyûsa nsiku nda arhaja nyumpa. ");
INSERT INTO shr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Olusiku lwa kali nda anashub’imôma amôya gâge goshi: Emviri, obwânwa, engohe, acimômêse enyôya zoshi anacîshuke yênene, omubiri goshi n’emishangi yâge na ntyo erhi amarhengakwo ecizira coshi. ");
INSERT INTO shr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Olusiku lwa kali munâni anarhôla bâna-buzi babirhi barhalikwo ishembo n’omushîbuzi gwa mwâka muguma gurhaliko ishembo, anarhôle omulà gw’enshâno enozire, mirengo isharhu ya kali ikumi, ebè evanzirwe n’amavurha ga mulengo muguma. ");
INSERT INTO shr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Omudâhwa walokôlaga oyo mushomyo, anamulêrha, anarhûla Nyamuzinda ebyo aha muhango gw’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Omudâhwa anarhôla cibuzi ciguma acihâne nterekêro y’okushukûla ebyâha, haguma na gulya mulengo gw’amavurha. Anabimogamogera embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Omudâhwa ananigira ecôla cibuzi halyâla bananigira enterekêro y’okushukûla ebyâha enali yâge bulya buli bwangà butagatîfu obwo. ");
INSERT INTO shr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Omudâhwa hano abà amaduba kuli gulya mukò gw’enterekêro y’okushukûla ebyâha anagulaba oku kurhwiri kulyo kwa nyakushukûlwa banagulabe oku cunkumwe câge c’ekulyo, n’oku ino linene lyâge ly’okugulu kulyo. ");
INSERT INTO shr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kandi omudâhwa anarhôla omulengo gw’amavurha agadubulirekwo omu bulà bw’enfune bw’o­kuboko kumosho. ");
INSERT INTO shr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Na mwa galya mavurha gali omu bulà bw’enfune y’ekumosho anadobezamwo omunwe gw’okuboko kulyo agushahulize kali nda embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Na kandi kuli galya mavurha gali omu bulà bw’enfune y’e kumosho, omudâhwa analabamwo okurhwiri kulyo kwa nyakulokôlwa, kwo kuyûshûla enterekêro y’okushukûla ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Agasigîre kwa galya mavurha gali omu bulà bw’enfune y’e kumosho, omudâhwa anagabulagira oku irhwe lya nyakushukûlwa. Kwo na kujira enterekêro y’okulyûla ebyâha embere za Nyakasane okwo. ");
INSERT INTO shr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kandi omudâhwa anarhùla enterekêro y’okushukûla omunya-byâha. Kandi buzinda bw’aho analokôla olya wal’izizire. ");
INSERT INTO shr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Enyuma z’aho, bano abà amaniga enterekêro y’okusingônolwa, anarhûla enterekêro nkalange, kwo kulokôla oyo muntu abè mwêru kwêru. ");
INSERT INTO shr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Akabà mukenyi n’ebirugu byâge biri binyi, anarhûla mwâna-buzi muguma w’okurherekêrwa, amurhûle enterekêro y’okumolekwa n’okuyinamulirwa Nyakasane. Anarhôla ecigabi ca kali ikumi n’enshâno enozire, anavanganye n’amavurha ajiremwo enterekêro y’okukalangwa, anayiyûshûlekwo n’omulengo gw’amavurha. ");
INSERT INTO shr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Anarhôla na mahali abirhi ga mpinga, erhi bânagoko babirhi ba ngûkù, akabà ankabibona. Mwânagoko muguma abè nterekêro y’okushukûlwa ebyâha, n’owundi nterekêro y’okusingônolwa. ");
INSERT INTO shr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Olusiku lwa kalimunani, anabihêkera omudâhwa aha kagombe k’endêko, embere za Nyakasane lyo bamuyobôla. ");
INSERT INTO shr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Omudâhwa anarhôla olya mwâna-buzi w’enterekêro y’okushukûla ebyâha na gulya mulengo gw’amavurha, anabimogamogera embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Anabâga olya mwâna-buzi w’okushukûla. Omudâhwa anarhôla omwamba gw’elya mbâgwa y’okushukûla. Anagushiga oku kurhwiri kulyo kw’owashukûlwa, oku cunkumwe c’okuboko kwâge kulyo n’oku ino linene ly’okugulu kwâge kulyo. ");
INSERT INTO shr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Omudâhwa adubulira mavurha masungunu omu bulà bw’enfune y’okulembe kwâge ");
INSERT INTO shr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Oyo mudâhwa anayanka kuli galya mavurha n’omunwe gw’e kulyo kwâge akangûlemwo kali nda embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Omudâhwa anayanka kuli galya mavurha gali omu kuboko kwâge kulembe, agalabe oku kurhwiri kulyo kwa nyakulokôlwa, n’oku cunkumwe c’ekulyo n’oku ino linene ly’ekulyo, halya anashîgaga omukò gw’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Amavurha gankasigala omu nfune z’omudâhwa, anagabulagira oku irhwe ly’owalokôlagwa, kwo nakumujirira enterekêro y’okulyûla embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Okubundi anarhûla mpinga nguma erhi mwânagoko muguma wa ngûkù nk’oku anahashire. ");
INSERT INTO shr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Anajira mwânagoko muguma nterekêro y’okulyûla ebyâha, owundi abè nterekêro nsingônola, haguma n’enterekêro nkalangwa. Kwo omudâhwa ajirira nyakulokôlwa ntyo, enterekêro y’okulyûla ebyâha embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Lyo irhegeko liyêrekîre omushomyo eryo, kuli olya ebirugu byâge birhayunjuzizi enterekêro elingânîne eya abandi. ");
INSERT INTO shr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Nyakasane ashub’ishambâza Mûsa na Aroni, erhi: ");
INSERT INTO shr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Amango mwahike omu cihugo c’e Kanâni, cirya nammuyîmikamwo, erhi nankahira ecinyolo c’olushomyo muli nyumpa nguma ya muli eco cihugo mwagabîrwe, ");
INSERT INTO shr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","nna erya nyumpa agwâsirwe okumanyîsa omudâhwa, muli ebîra binwa, erhi: Niehe namâbona emvulikaka y’olushomyo omu nyumpa yâni. ");
INSERT INTO shr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Omudâhwa embere agend’ilolêreza ezo nvulikaka, arhang’irhegeka okurhenza ebiri omu nyumpa byoshi, lyo birhag’ihumâna nabyo, lyoki omudâhwa ankajà omu nyumpa ayilolêreze. ");
INSERT INTO shr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Omudâhwa analolêreza zirya nvulikaka ziri oku lukûta, akabà ezo mvulikaka ziri oku lukûta zirimwo emisingenyere y’akasi erhi ndukula, enayêrekîne oku ekola yajà yajira emigâku oku lukuûta, ");
INSERT INTO shr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","omudâhwa anahuluka muli erya nyumpa kuhika aha c’olusò, anarhegeka bayigale eyôla nyumpa kuhika nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Omudâhwa anashubiramwo olusiku lwa kali nda. ");
INSERT INTO shr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Erhi ankabona oku ecôla cinyolo caja cayushûka oku birhebo by’eyo nyumpa, anarhegeka okurhenza amabuye galikwo ecinyolo, banagakwebe ahantu habî kuli h’ecishagala. ");
INSERT INTO shr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Anarhegeka bahalûle enyumpa yoshi omu ndalâlà, kandi bakabulire kuli kw’ecishagala kalya katulo bahalûlaga. ");
INSERT INTO shr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Banayanka agandi mabuye bayûbakemwo halya amarhanzi gàli, banashub’ishîga ebindi bidaka oku nyumpa. ");
INSERT INTO shr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Erhi ecôla cinyolo cankashub’ibonekana, n’obwo bali bamahomòla halya hali envulikaka z’ecinyolo, banasirîrha halyâla banahahoma ebindi bijondo, omudâhwa anashubirayo agend’ilaba eyo nyumpa. ");
INSERT INTO shr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Erhi ankabona zirya mvulikaka z’ecinyolo zajà zayushûka omu nyumpa, anaderha oku luli lushomyo lwa kuyahukira olwo luli muli eyo nyumpa. Eyo nyumpa yamazira. ");
INSERT INTO shr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Banahongole erya nyumpa, bagal’igend’ikabulira kulî kw’eco cishagala: amabuye, emirhi haguma n’ebidaka byàli oku nyumpa byoshi, bikabulirwe ahantu habî. ");
INSERT INTO shr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Owankayongoberera muli eyôla nyumpa kurhenga galya mango bayihamikaga mpu ezizire, oyo naye anayahukirwe na gulya muziro kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Owankalâla muliyo erhi kulîra muliyo kukwânîne ashuke emyambalo yâge. ");
INSERT INTO shr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ci erhi omudâhwa ankabà amashubira muli erya nyumpa akabona kuli cirya cibale ecimanyîso c’okurhaja cayushûka kurhenga banahembulula erya nyumpa, omudâhwa anaderha oku eyôla nyumpa ekola nyinjà, erhacigwêrhikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Oku nterekêro y’okushukûla eyôla nyumpa, omudâhwa anarhôla rhunyunyi rhubirhi, enshâli z’akarhonda, ecuhâgizo n’omugôla mudukula. ");
INSERT INTO shr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Anabâgira kanyunyi kaguma oku nyungu y’ibuye ndêkereze oku nyanya ly’amîshi gahulula. ");
INSERT INTO shr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kandi hano abà amârhôla enshâli z’akarhonda, gulya mugôla mudukula na kalya kanyunyi kazîne, anabidobeka omu mukò gwa kalya kanyunyi kanigagwa na muli galya mîshi gahulula, mwa galya mango anakangûlamwo erya nyumpa kali nda. ");
INSERT INTO shr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ayûsa okuhâna enterekêro y’okushukûla erya nyumpa omu kukolêsa gulya mukò gw’akanyunyi, amîshi gahulula, haguma na kalya kanyunyi kacizîne, na zirya nshâli z’akarhonda; cirya cuhâgizo na gulya mugôla, ");
INSERT INTO shr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","akanyunyi kacizîne anakalika, kacîbalalire kulî kw’ecishagala omu lubala. Kwo akaz’ishukûla ntyo enyumpa lyo ezirôka. ");
INSERT INTO shr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Eryo lyo irhegeko liyêrekîne ngasi cinyolo c’emvulikaka n’ebibungu, ");
INSERT INTO shr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","oku lushomyo lw’emyambalo n’olw’enyumpa. ");
INSERT INTO shr_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Emibuha, n’ebibenzi na ngasi bindi bibale, ");
INSERT INTO shr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","limanyisize mangaci akantu kankaba kazizire erhi karhalikwo ishembo liyêrekîre olushomyo. Lyo irhegeko liyêrekîre olushomyo elyo. ");
INSERT INTO shr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Nyakasane anacishambaza Mûsa n'Aroni, ababwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Mugend’i­bwîra bene Israheli ntyâla: Ngasi mulume wankageza emburho, erhi analikwo ishembo ly’omuziro. ");
INSERT INTO shr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Yumvagi ecankarhuma aderhwa munyîshembo ly’omuziro: Erhi omubiri gwâge gwankabulaga emburho, na ciru ankayumva ziri hôfi h’okubulajika, akazicìka kurhankarhuma arhayôrha azizire. ");
INSERT INTO shr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Encingo oyo muntu ozizire ankalalakwo, nayo enazire na ngasi kantu ankadahalakwo nakwo erhi kanakola kazizire. ");
INSERT INTO shr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Owankahuma oku ncingo yâge, ali wa kugend’ishuka emyambalo yâge, na yêne ali wakucîshuka n’amîshi, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Omuntu wankatamala oku kantu katamalwako n’omuntu ozizire, naye ali wa kugend’ishuka emyambalo yâge, naye yênene ali wa kucîshuka omubiri, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ngasi wankahuma oku mubiri gw’oyo muntu ozizire, ali wakugend’ishuka emyambalo yâge, n’okucîshuka yênene omubiri n’amîshi, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Oyo muntu ozizire, erhi ankakâyira oku muntu orhalikwo ishembo, oyo muntu akola wakushuka emyambalo yâge, n’okucîshuka yênene n’amîshi, agali nayôrhana omuziro gwâge kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ngasi citumbi oyôla ozizire ankatamalakwo omu kubalama, naco cikola cizizire. ");
INSERT INTO shr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Owankahuma oku kantu kali idako ly’aka atamirekwo, erhi aka ayimanzirekwo, erhi aka agwishîrekwo, oyôla anabà n’ishembo ly’omuziro kuhika bijingo, n’owankahêka kantu kaguma muli orhwo, akola wa kushuka emyambalo yâge, yênene anacîshuke n’amîshi agal’iyôrhana omuziro gwâge kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ngasi boshi, oyo muntu ankahumakwo, n’obwo arharhanzir’ikalaba enfune zâge n’amîshi, abôla bakola ba kushuka emyambalo yâbo na kandi bônene bali bakucîshuka n’amîshi bagal’inayôrha bazizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ngasi kalugu k’ibumba oyo muntu ozizire ankahumakwo, kakola ka kuberwa, na ngasi kalugu kabinjagwa omu murhi, kali ka kushukwa n’amîshi. ");
INSERT INTO shr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Amango oyo kashululu amahubamwo okushulula, anaganja nsiku nda embere z’okushukûlwa kwâge, kandi naye ali wa kushuka emyambalo yâge, na wa kucîshuka omubiri n’amîshi gahulula, lyoki ankalokôlwa. ");
INSERT INTO shr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Olusiku lwa kali munâni, hano abà amârhôla mahali abirhi ga mpinga, nîsi erhi bânagoko babirhi ba ngûkù, anabihêka aha muhango gwa akagombe nterekêro, anabihêreze omudâhwa embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Omudâhwa anahâna nguma nterekêro y’okushukûla ebyâha, n’eyindi ebè nterekêro y’okusingônolwa. Kandi omudâhwa anamujirira enterekêro y’okumuhânira ecîru emwa Nyakasane, kuli okwo kuzira kwâge. ");
INSERT INTO shr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Omulume ogeza emburho ali wakushuka omubiri gwâge gwoshi n’amîshi, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ngasi mwambalo kandi erhi ngasi luhù, eyôla mburho yankahikakwo, kukwânîne bishukwe n’amîshi bigal’iyôrha bizizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Erhi ankabà omukazi alazire n’omulume bakanayankana, bombi banacishuka n’amîshi, bagal’iyôrha bazizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Amango omukazi ali ebukuma, agwâsirwe okuyôrha nsiku nda muli ogôla muziro gwâge na ngasi yêshi wankamuhumakwo, anayahukirwe n’ishembo ly’ogwo muziro kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ngasi kantu ankalalakwo agôla mango gâge ali omu mugongo, nako kanazire, kwo na ngasi kandi kantu ankatamala­kwo kakola kazizire akâge. ");
INSERT INTO shr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Owankahuma oku ncingo yâge anazire, akola agwâsirwe okushuka emyambalo yâge n’amîshi, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Owankahuma oku kantu ashuba atamirekwo, agwâsirwe okushuka n’amîshi emyambalo yâge, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Akabà hali kantu kali oku ncingo erhi oku ntebe oyo muntu ozizire ashub’atamirekwo, owakahumakwo, anazire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Erhi omulume ankalâla bonaye, ecirhambo câge erhi cankamuhikakwo, nyamukazi erhi amuyahukize omuziro gwâge, kuhika nsiku nda, na ngasi ncingo ankalalakwo nayo ekola ehumânyire. ");
INSERT INTO shr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Erhi omukazi ankayôrha nsiku omu mugongo, kulusha ensiku akomerera, nîsi kandi erhi ankarhalusa ensiku ayôrha ajà omu mugongo, haguma n’okudwa omukò okurhalusire olugero, anayôrha azizire ensiku zoshi aciri ebukuma. ");
INSERT INTO shr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ngasi ncingo ankalâlakwo agôla mango adwîrhe adwa omukò, eyo ncingo anarhume yahinduka kantu kazizire: nka oku elya alâlakwo amango gâge g’okujà omu mugongo, na ngasi kalugu ankatamalakwo kakola kazizire, nka amango ali omu mugongo ngasi mwêzi. ");
INSERT INTO shr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Owankahuma kuli ebyôla birugu, anazizire anakola agwâsirwe okushuka emyambalo yâge, n’okucîshuka yênene n’amîshi, agal’iyôrha azizire kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Erhi ankabà eco cirhambo câge camahuba, anageza nsiku nda, n’enyuma lyâzo anayôrha bwinjà. ");
INSERT INTO shr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Olusiku lwa kalimunani anarhôla mpinga ibirhi ka­ ndi erhi ngûkù ibirhi ntôrhò, anazihêkere omudâhwa aha muhango gw’akago­mbè k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Omudâhwa anabirherekêra: nguma ebè nterekêro oku byâha, na eyindi gulya mukò gwarhumaga azira gurhuma. ");
INSERT INTO shr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Orhonde bene Israheli oku miziro yâbo, lyo bakaz’icisêza, lyo barhag’ifà, erhi eyo miziro erhuma, omu kuhemula endâro yâni eri ekarhî kâbo. ");
INSERT INTO shr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Eryo lyo irhegeko liyêrekîre okujà ebukuma, nîsi erhi kubulaga emburho, ");
INSERT INTO shr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","na ngasi yêshi wankadwa omukò, abè mulume nîsi erhi mukazi, ciru n’omulume wankalâla n’omukazi ozizire. ");
INSERT INTO shr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nyakasane ashambàza Mûsa enyuma ly’okufà bene Aroni bombi balya barhingamiragwa amango bayegeraga obusù bwa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Nyakasane abwîra Mûsa, erhi: Oj’ibwîra mwene winyu Aroni amanye arhakazâg’ijà ngasi mango omu hantu himâna, omu ndalâlà y’ecisîka, embere ly’entebe y’amonjo eri enyanya ly’ecirhimbiri c’amalaganyo, alek’ifà bulya mbonekana omu citù kuli eyo ntebe y’amonjo. ");
INSERT INTO shr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Yumvagya kurhi Aroni akaz’ijà ahantu himâna: Anakaz’iyisha adwîrhe empanzi y’omushikira, nterekêro y’okushukûla ebyâha n’engandabuzi oku nterekêro y’okusingônolwa. ");
INSERT INTO shr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Anacìhundikira ecishûli c’enondwè, erhi n’oku mubiri gwâge ayambîrhe ehikenyerwa hy’enondwè. Anakobeke n’omushumi gw’enondwè, anazonze irhwe lyâge ehisirha hy’enondwè. Yo myambalo mîshogwa akayambala eyo, abà amacîcêsa omubiri n’amîshi. ");
INSERT INTO shr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Bene Israheli banakâmulerhera bihebe bibirhi, bibè nterekêro y’okushukûla ebyâha na ngandabuzi nguma ebè nterekêro y’okusingônolwa. ");
INSERT INTO shr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aroni ayûs’irhûla empanzi y’okushukûla ebyâha byâge n’okujira enterekêro y’okucîhyûlira bône omulala gwâge goshi, ");
INSERT INTO shr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","amayimanza birya bihebe bibirhi embere za Nyakasane, aha muhango gw’akagombe k’endêko. ");
INSERT INTO shr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aroni anayesha ecigole kuli ebyôla bihebe byombi: ciguma acishige Nyakasane n’ecindi acishige omuzimu Azazeli. ");
INSERT INTO shr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aroni anaderha bashegeze hôfi ecihebe cagwâsirwe n’ecigole co ca Nyakasane, anacirherekêra ntûlo y’okushukûla ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","N’ecihebe cagwâsirwe n’ecigole c’omuzimu Azazeli anaciyimanza cizîne embere za Nyakasane, lyo acinywesa empyûlo oku byâha bagal’icihabulira omu irungu emw’omuzimu Azazeli. ");
INSERT INTO shr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aroni akaz’ihâna empanzi nterekêro oku byâha byâge, ly’acihalira yêne n’omulala gwâge. Hano abà amabâga empanzi y’enterekêro y’okushukûla e­byâha, ");
INSERT INTO shr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","anarhôla ecitumbûkizo ciyunjwîre masese gw’oku luhêrero embere za Nyakasane, anarhôle na bifune bibirhi bya nshangi ya nshâno yahumula kwinjà. Anabihêka omu ndalâlà ly’enshabiriro, ");
INSERT INTO shr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","anahira enshangi kwa gulya muliro guli embere za Nyakasane lyo omugî gwâyo guyunjula ahantu himâna, nka hitù enyanya ly’entebe y’amonjo, lyo erhag’ifà. ");
INSERT INTO shr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anarhôla oku mukò gw’erya mpanzi, ajiremwo ecuhâgizo n’omunwe gwâge anakangûla kali nda embere z’ahantu h’entebe y’amonjo. ");
INSERT INTO shr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Anabâga ecihebe c’entererekêro y’okushukûla ebyâha by’olubaga, agal’ihêka omwamba gwâco omu ndalâlà ly’enshabiriro, hano abà amakolêsa gulya mukò, nk’oku akolesagya ogw’empanzi, anakangûla nagwo entebe y’amonjo n’embere zâyo. ");
INSERT INTO shr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kwo akaz’ijirira enterekêro ahantu himâna ntyôla kuli bene Israheli erhi mabî gâbo garhuma, n’okuhanjalika kwâbo nka bamâjira ecâha, kandi anajirira ntyôla akagombe k’endêko kayôrha kali ekarhî kâbo, amango g’amabî gâbo. ");
INSERT INTO shr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Omu kagombe k’endêko murhaberaga ndi ago mango ayongobêramwo mpu arhûle enterekêro omu hantu himâna, kuhika alinde arhengamwo; ayûs’icîrherekêrera yênene enterekêro y’okucîhûnira obwonjo bône omulala gwâge na bene Israheli, ");
INSERT INTO shr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","akola ahuluka anakanya, aj’ebwa luhêrero luli embere za Nyakasane, anabâgira empyûlo oku luhêrero, abà amârhôla oku mwamba gw’empanzi, n’ogw’ecihebe, ajà alâba oku marhambi goshi g’oluhêrero. ");
INSERT INTO shr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kandi anashahuliza omukò kali nda n’omunwe gwâge kuli olwo luhêrero, analushukûle n’okulukulakwo amabî goshi ga Bene Israheli. ");
INSERT INTO shr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Hano amâyûs’ijirira entûlo ahantu himâna, oluhêrero n’akagombe k’endêko, anaderha bayêgeze cirya cihebe cicizîne emunda ali. ");
INSERT INTO shr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Kandi amâyûs’ilambûlira amaboko gâge gombi oku irhwe lya cirya cihebe cicizîne, Aroni anacîgashira kuli cirya cihebe, omu kuderha amabî ga bene Israheli goshi n’omu kuhalanjika kwâbo omu kujira ebyâha, ayûs’inywêsa eco cihebe galya mabî, banacihugira omu irungu erhi cayisha cahugwa n’omuntu murhonde, olya olalizîbwe. ");
INSERT INTO shr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Eco cihebe canahêka ntyo emiziro yâbo yoshi, omu irungu nyawera. Oyo muntu abà amacihugira omu irungu, ");
INSERT INTO shr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","okubundi Aroni anashubira omu kagombe g’endêko, ahogole emyambalo y’enondwè ali ayambîrhe erhi ajà ahantu himâna, amâyûs’ibibîkamwo, ");
INSERT INTO shr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","anacishukira halya hantu himâna yêshi n’amîshi. Kandi anashub’iyambala emyambalo yâge, abul’ihuluka n’okugend’ihâna enterekêro yâge nsingônola n’ey’olubaga lwoshi, ");
INSERT INTO shr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","amashushi g’enterekêro okushukûlwa ebyâha, anagasingonôlera oku luhêrero. ");
INSERT INTO shr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Owal’ihugira cirya cihebe emwa omuzimu Azazeli, anashuka emyambalo n’omubiri gwâge, lyoki akaja omu lugo. ");
INSERT INTO shr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Empanzi erhûlirwa kubà nterekêro y’okushukûla ebyâha, banayibarhulire kulî n’olugo, kuguma n’ecihebe c’enterekêro y’okushukûla ebyâha, byo bintu omwamba gwâbyo gwahêkwa ahantu himâna, mpu bibè ntûlo, basingônole: oluhù, enyama n’ecihò câbyo. ");
INSERT INTO shr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Olya wal’irhumirwe okubiyôca agwâsirwe okushuka emyambalo yâge n’omubiri gwâge, n’amîshi, abà amâjira ntyo, lyoki akaja omu cishagala. ");
INSERT INTO shr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Okola kwabà irhegeko linyu ensiku zoshi. Omu nsiku ikumi z’omwêzi gwa kali nda, lwakâbà lusiku lukulu lw’okucîbabaza, murhahîraga mwajira mukolo muci, oli mwe, oli ecigolo cinyu. ");
INSERT INTO shr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Bulyâla muli olwo lusiku, lyo bakaz’immurherekêrera enterekêro y’okumushukûla, lyo bamuzirôla lyo mucêsibwa ebyâha binyu embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Kuli mwe olwo lusiku lwakâbà lusiku luzira, lwa kurhamûka, lusiku lwa kucîshalisa. Linakola irhegeko ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Empyûlo oku byâha, yakurherekêrwa n’omudâhwa mukulu, washîzirwe amavurha, anayimikirwa okukâjira emikolo y’ohudâhwa ahâli h’îshe. Anakaz’iyambala emyambalo y’enondwè, myambalo mitagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Akaz’ihâna enterekêro y’okuhyûla eyêrekîre: ahantu hatagatîfu bwenêne, eyêrekîre akagombe k’endêko, n’eyêrekîre oluhêrero. Na enyuma z’aho anakazihânira abadâhwa n’olubaga enterekêro y’okushukûlwa ebyâha. ");
INSERT INTO shr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","N’eryo liri irhegeko linyu ly’ensiku zoshi: entûlo y’empyûlo yakaz’ijirirwa bene Israheli boshi liguma lyône omu mwâka, erhi byâha byâbo birhuma; banacikaz’ijira nka kulya Nyakasane arhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Oj’ibwîra Aroni, abagala na bene Israheli boshi, obabwîre, erhi: Lolagi ebi Nyakasane arhegesire. ");
INSERT INTO shr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ngasi muntu w’omu bûko bw’Israheli wayabâgire enterekêro, ebè mpanzi, cibè cibuzi erhi mpene omu cishagala erhi kulî kw’ecishagala, ");
INSERT INTO shr_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","buzira kuhêka eyo nterekêro aha muhango gw’akagombe k’endêko, lyo ayirherekêrera Nyakasane embere ly’Endâro yâge, oyo muntu ayasambe omukò anabulagaga. Anakagwe omu lubaga lwâni. ");
INSERT INTO shr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ntyo bene Israheli bakaz’ilêrhera omudâhwa enterekêro za Nyakasane aha muhango gw’akagombe k’endêko, ahâli h’okukaz’izijirira emwa bâbwè, banakaz’izirherekêra Nyakasane, zibè nterekêro z’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Omudâhwa anadubulira omwamba oku luhêrero lwa Nyakasane, aha muhango gw’akagombe k’endêko, kandi anasingônola olujimbi lubè nterekêro y’obuhumule bwinjà embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Irhondo barhacihiraga bakagashâniza abazimu bàrhuma bahemuka. Liri irhegeko lya kuyôrha ensiku n’amango kuli bo n’oku bûko bwâbo. ");
INSERT INTO shr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Oj’ibabwîra kandi oku: Ngasi w’omu bûko bw’Israheli, nîsi erhi mubunga erhi cigolo, erhi ankagend’ihâna enterekêro y’okusingônolwa, erhi yindi nterekêro, ");
INSERT INTO shr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","oyôla muntu nka arhadwîrhi enterekêro yâge aha muhango gw’akagombe k’endêko mpu ayirherekêra Nyakasane, anakagwe omu bûko bwâge. ");
INSERT INTO shr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ngasi muntu w’omu nyumpa y’Israheli kandi erhi mubunga, erhi ankalya omwamba gwa cintu cilebe, nanakunirira oyo muntu wacìshomagya alya ogwo mwamba kandi nanamukaga muli bene wâbo. ");
INSERT INTO shr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Bulya obuzîne bw’ecintu omu mukò gwâco bubà, nanamuhîregwo nti gukâbà nterekêro y’okushukûla obuzîne bwinyu, bulya omukò gwo gulyûlira obuzîne. ");
INSERT INTO shr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Co carhumire nabwîra bene Israheli, nti: Ntâye ciru n’omuguma muli mwe oyêmêrîrwe okulya omwamba. Na ntà cigolo ciri muli mwe ciyêmêrirwe okulya omwamba. ");
INSERT INTO shr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ngasi wa muli bene Israheli erhi mubunga obalimwo, erhi ankayîrha ensimba nîsi erhi kanyunyi kalîbwa, anasheshere omukò gw’erya nsimba kandi erhi gwa kalya kanyunyi omu idaho anadukire. ");
INSERT INTO shr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Bulya omukò bwo buzîne bwa ngasi cintu, nanabwizire bene Israheli, nti: Murhahîraga mukalya omwamba bulya obuzîne bwa ngasi cintu omu mwamba bubà, n’owankacîshomya mpu agulya, anayirhwe. ");
INSERT INTO shr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ngasi muntu wa muli mwe kandi erhi mubunga wankalya ecintu cacîhozagya erhi ecayîrhagwa n’ensimba, oyo muntu anashuke emyambalo yâge, acîshuke yênene n’amîshi, erhi anaciyosire azizire kuhika bijingo abul’izirôka. ");
INSERT INTO shr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Akabà arhashusiri emyambalo yâge kandi n’omubiri gwâge, yênene obubî bwâge bulikwo. ");
INSERT INTO shr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Oj’ibwîra bene Israheli erhi: Nie Nyakasane Nyamuzinda winyu; ");
INSERT INTO shr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","murhakazâg’ijira nk’oku ba­jira e Mîsiri mwâli muyûbasire, murhanakazâg’ijira nk’oku bajira omu cihugo c’e Kanâni, eci namuhêkamwo; murhahîraga mwashimba amarhegeko gâbo. ");
INSERT INTO shr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Engeso zâni zo mwakâshimba, n’amarhegeko gâni go mwakaz’ilamirakwo: mugakombêre kwinjà. Nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mushimbe amarhegeko n’engeso zâni: owankabishimba kwinjà alama. Nie Nyamubâho oku­desire. ");
INSERT INTO shr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ntâye ciru n’omuguma muli mwe oyêmêrîrwe okulâla n’omukazi w’omulala gwâge. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Orhahîraga okalolakwo sho erhi nyoko amango bali bushugunu, bulya ali nyoko arhayêmêrîrwi okumulolakwo analibushugunu. ");
INSERT INTO shr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Orhahîra okayambisa mukà sho obusha, bulya erhi akola sho oyo obuyambisire. ");
INSERT INTO shr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Orhahîra okayambisa mwâli winyu obusha, abè mwâli wa sho erhi mwâli wa nyoko waburhiragwa aha mwinyu, erhi embuga, orhankamuyambisa obusha. ");
INSERT INTO shr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Orhahîra okabwikûla mwâli wa mugala wâwe, ayôrhe buge­ngere, nîsi erhi mwâli wa mwâli wâwe, bulya obushugunu bwâbo buli bushugunu bwâwe wêne. ");
INSERT INTO shr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Orhahîra okabwikûla obushugunu bwa mwâli wa mukà sho, olya waburhagwa na sho, ayôsire ali mwâli winyu, co cirhumire orhankahasha okubwikûla obushugunu bwâge. ");
INSERT INTO shr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Orhahîra okabwikûla obushugunu bwa nyakashenge, bulya mubiri muguma barhengaga bona sho. ");
INSERT INTO shr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Orhahîra okubwikûla obushugunu bwa munyokò, bulya guyosire guli mubiri muguma n’ogwa nyoko. ");
INSERT INTO shr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Orhankabwikûla obushungunu bwa mûshò, kuziga orhanahîraga okayegera mukâge bulya ayôsire ali mukà mûshò, ali aka nyakashenge. ");
INSERT INTO shr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Orhankabwikûla obushugunu bwa mwâlikazi wâwe, ayôsire ali mukà mugala wâwe orhankanamubwikûla mpu ayôrhe bugengere. ");
INSERT INTO shr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Orhanka­ bwikûla obushugunu bwa mukà mwene winyu, bulya buli bushugunu bwa mwene winyu. ");
INSERT INTO shr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Orhahîra okabwikûla obushugunu bw’omukazi okanagal’i­bwikûla obushugunu bwa mwâli wâge, orhankayanka mwâli wa mugala wâge nîsi erhi mwâli wa mwâli wâge. Boshi bakola mubiri gwâge! Bulibugonyi bwa bantu ba nyumpa nguma. ");
INSERT INTO shr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Orhahîra okayanka omukazi okagal’imuhambalikanya kw’owundi w’omu nda yâbo, orhankabwikûla obushugunu bwâge onacigwêrhe olya wundi w’omu nda yâbo. ");
INSERT INTO shr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Orhahîra okayegera mpu wabwikûla obushugunu bw’omukazi ozizire, erhi kubà omu mugongo kurhuma. ");
INSERT INTO shr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Orhahîra okagona na mukà mulungu wâwe, bulya kuli kucîhemula mwenaye okwo. ");
INSERT INTO shr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Orhahîra wacîshomya mpu wahâna muguma omu bâna bâwe mpu bamugeze omu muliro lyo bakuza omuzimu Moleki, na kandi orhahemukiraga izîno lya Nyamuzinda wâwe. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Orhahîra okulâla n’omulume kula balâla n’omukazi. Buli buhanya obwo. ");
INSERT INTO shr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Orhahîra okalâla n’ecintu, bulya kwanarhuma wazira. N’omukazi arhankacîhà ecintu mpu cimuhambarhe. Buli buhanya obwo. ");
INSERT INTO shr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Murhahîra mukacîhemula na cijiro ciguma muli ebyo, bulya byo byahemulaga amashanja ndwîrhe nakaga mwanalola. ");
INSERT INTO shr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ecihugo cacîbindisire, co cirhumire ncihanîre obubî bwâco. Na ntyo abalimwo bakazirwe. ");
INSERT INTO shr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ci mwêhe mukombêre amarhegeko n’engeso zâni, munacîlange oku maligo ga mwene agôla, oli mwe, oli bambali binyu, oli ababunga muyûbasire haguma. ");
INSERT INTO shr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Bulyâla amaligo ga bene agôla, abantu barhangig’iyûbaka muli ecîra cihugo bakazir’i­gajira, na ntyo ecihugo cabindama. ");
INSERT INTO shr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Erhi mwankahemula ecihugo, k’ecôla cihugo cirhankamushala nk’oku cashalaga amashanja gali gaciyûbasiremwo embere zinyu. ");
INSERT INTO shr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Nêci, ngasi wankajira amaligo ga bene ago, anakagwa muli bene wâbo. ");
INSERT INTO shr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mukombêre amarhegeko gâni, lyo murhag’ihirima omu ngeso mbî, za benê ezo zakazâg’ijirwa embere zinyu, lyoki zirhankamuhumânya. Nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Ogend’ibwîra olubaga lwa bene Israheli ntyâla: Mubè bimâna bulya ndi mwimâna, nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ngasi muguma muli mwe agwâsirwe okukenga îshe na nnina, n’ensiku zâni za Sabato mukaz’izikenga. Nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Murhahîra mukaharâmya enshusho z’obunywesi erhi za ba-nyamuzinda mucijirira mwene omu byuma. Nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Amango mwarhûla Nyamubâho enterekêro y’omurhûla, mwanayirhûla kulya kwankarhuma Nyakasane amurhonya. ");
INSERT INTO shr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Enyama y’eyôla nterekêro, elîbwe olôla lusiku lwonênè, nîsi erhi buca, ebyankasigala kuhika oku lusiku lwa kasharhu binasingônolwe n’omuliro. ");
INSERT INTO shr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Erhi hankajira owalya kuli erya nyama oku lusiku lwa kasharhu, erhi bikola biryo bigazire, na eyo nterekêro erhaciri ya kuyankirirwa. ");
INSERT INTO shr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Owankalyakwo yêne ocîhesize obuhanya bwâge, ebwa kubà anahemwire ebyarherekîrwe Nyakasane. Oyôla muntu anakagwe omu lubaga lwâbo. ");
INSERT INTO shr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Amango mwasârûla emyâka y’omu cihugo cinyu, murhahîraga mpu mwahika oku lubibi lw’ishwa linyu, murhanaderhaga mpu mwarhôlogola ebyakakundezibwa aha mwasârûlaga. ");
INSERT INTO shr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Orhakazâg’ihumbûza emizâbîbu y’emisigala y’omu nkoma zinyu, orhanarhôlezagya amalehe garhogîre omu ishwa lyâwe; ebyôla biri bya kulekerwa omukenyi erhi cigolo. Nie Nyakasane Nyamuzinda winyu okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Murhahîra mukazimba erhi mukarhebana, erhi mukahambârana mwene na nnene. ");
INSERT INTO shr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Murhahîra mukalahira izîno lyâni ebîra, bulya kuli kuhemukira izîno lya Nyamuzinda winyu. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Orhahîra okarhindibuza omulungu, orhahîra wamunyaga ehyâge: oluhembo lw’omulimya lurhayôrhaga omu mwâwe kuhika olusiku lwakulikira. ");
INSERT INTO shr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Orhahîra okuhehêrera akaduma, orhahîraga wahira embere z’omuhûrha ecisârhazo, ci okaz’ikenga Nyakasane wâwe. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Orhahîra walenganya omu kutwa olubanja, orhanarhonyagya omukenyi, ciru orhanaderhaga mpu waluhà olengerîre; ci okaz’itwîra omulungu wâwe olubanja omu kushimba ebishingânîne. ");
INSERT INTO shr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Orhahîra okajà waderha bene winyu kubî. Orhahîraga wakâbà muhamîrizi w’obunywesi, lyo orhag’irhuma omukò gwa mulungu wâwe gubulajika. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Orhabîkiraga mwene winyu akarhinda, onamuhanûle erhi kwo, lyo orhag’icibarhuza ecâha. ");
INSERT INTO shr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Orhahîra okucîhôla nîsi erhi okabîkira abantu b’omu lubaga lwinyu akarhi­nda. Okâzigira omulungu wâwe nka oku ocîzigira wênene. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Oshimbe amarhegeko gâni. Orhahîra okuyêmêra ebintu birhali bya bûko buguma byâhambarhana. N’omu ishwa lyâwe orhahîra okamîra emburho zirhali za bûko buguma, orhanahîraga wayambala omwambalo gwajiragwa na nusi ibirhi zirhali za bûko buguma. ");
INSERT INTO shr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Erhi omulume ankagona n’omujà-kazi o­dwîrhe asoloma nka muherula wa owundi mulume, ci nyamukazi orhagulagwa nka kantu, nîsi erhi orhasâg’igombôlwa, oyo wa burhanzi ali wa kuhanwa, ci bombi barhali ba kuyîrhwa, bulya olya mujà-kazi arhal’isig’igombôlwa lyo arhenga omu bujà. ");
INSERT INTO shr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Oku câha câge, nyamulume anaheka engandabuzi y’e­ nterekêro y’okuhonga embere za Nyakasane aha muhango gw’akagombe k’e­ ndêko. ");
INSERT INTO shr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Omudâhwa anamurhûlira Nyakasane engandabuzi y’enterekêro y’okuhongera cirya câha câge, na lyoki oyôla muntu ankababalirwa ecôla câha. ");
INSERT INTO shr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Amango mwabà mwamâhika muli cirya cihugo, mukanarhweramwo omurhi guyâna amalehe, munakaz’ilola galya malehe nka kantu kazirwa myâka isharhu yoshi buzira kugalyakwo. ");
INSERT INTO shr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Omu mwâka gwa kani, mwanahà Nyakasane irenge lyâge, omu kumurherekêra amalehe goshi g’ogwo murhi. ");
INSERT INTO shr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Omu mwâka gwa karhanu, lyoki mwankahasha okulya amalehe gâgo, n’okucîsârûlira­ mwene. Nie Nyakasane Nyamuzinda winyu okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Murhahîra mukalya akantu haguma n’omwamba, murhahîra mukalangûza, nîsi erhi mukajira eby’obukurungu. ");
INSERT INTO shr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Murhahîra mukaburungusa emviri nka mwamômwa, nîsi erhi mukatwîsa winga omu bwânwa. ");
INSERT INTO shr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Murhahîra mukashâkirwa owafîre, nîsi erhi mukamushakirwa enzirogo. Nie Nyakasane okuhamîrize. ");
INSERT INTO shr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Orhahîra okaleka mwâli wâwe ajà ashenza, bulya buzinda wanabona ecihugo coshi camashimba eyo njira y’okuhushahusha, na ntyo obone camayunjulirana mabî. ");
INSERT INTO shr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mukaz’ikenga ensiku zoshi za Sabato n’aka-Nyamuzinda kwo na kuguma mukaz’ikakenga. Nie Nyakasane okurhegesire. ");
INSERT INTO shr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Murhahîra mukagend’idôsa ihano emwa abarherekêra abazimu, nîsi erhi e­mw’abashonga. Mumanye mwankanagend’ibadôsa ihano, bulya banarhuma mwahemuka. Nie Nyakasane okuhanzize. ");
INSERT INTO shr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Okâyimukira abantu bakulu oku ntebe, n’omushosi okaz’imukenga. Orhînye Nyamuzinda wâwe. Nie Nyakasane okurhegesire. ");
INSERT INTO shr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Erhi ecigolo ca­nkayûbaka emwinyu, omu cihugo cinyu, murhahîra mwakâcîlibuza. ");
INSERT INTO shr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ecigolo ciyûbasire emwinyu, mukâcilola nka mwene winyu mugal’icizigira nka oku mucîzigirana mwene na nene, bulya ninyu mwâli bigolo omu cihugo c’e Mîsiri. Nie Nyakasane Nyamuzinda winyu okudesire. ");
INSERT INTO shr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Murhahîra mukalenganya, abè omu kutwa olubanja, nîsi erhi omu kutwa olubibi, kandi erhi omu milengo ya kantu kalebe. ");
INSERT INTO shr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mubè n’emirengo na ngasi bindi bikolêsibwa bishingânîne. Nie Nyakasane, Nyamuzinda winyu wamukûlaga e Mîsiri okudesire ");
INSERT INTO shr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Mulange amarhegeko n’engeso zâni zoshi, mukaz’izishimba. Nie Nyakasane okurhegesire. ");
INSERT INTO shr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Obwîre bene Israheli erhi: Ngasi mwene Israheli erhi munyamahanga ob’omu Israheli wankahâna muguma omu bâna bâge emunda Moleki ali, oyo anafè: olubaga luli omu cihugo lunamubande amabuye; ");
INSERT INTO shr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","nâni namushomba nnamukage omu lubaga omu kubona ahânaga muguma omu bâna bâge emunda Moleki ali na kandi omu kubona ahemwire aka-Nyamuzinda kâni haguma n’izîno lyâni litagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Erhi olubaga lwakalonza okumufungira, lukaleka okuyîrha oyo muntu ohânyire muguma omu bâna bâge emunda Moleki ali, ");
INSERT INTO shr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","niene nahana oyo muntu, nahana n’omulala gwâge, nayîsh’imuberûla oku lubaga, mberûle na ngasi ba­ndi boshi bankacihemuka erhi Moleki orhuma. ");
INSERT INTO shr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ngasi yêshi wagashânize emyômoka n’abazimu lyo ahemuka bo barhumire, nanamukaga nnamurhenze omu lubaga. ");
INSERT INTO shr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Mucîsêze lyo mubà batagatîfu bulya niono nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mulange amareegeko gâni mukaz’igashimba. Nie mmucêsa. ");
INSERT INTO shr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ntyo, erhi omuntu ankagayaguza îshe erhi nnina, oyo muntu anafè; bulya ajacire îshe na nnina, anacibarhuze omukò gwâge yêne. ");
INSERT INTO shr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Erhi omulume ankagona na mukà mulungu wâge, oyo mulume n’oyo mukazi bombi bananigwe. ");
INSERT INTO shr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Erhi omuntu ankayanka muk’îshe, erhi amayambika îshe obusha; bombi banafè. Bacibarhuzize omukò gwâbo bône. ");
INSERT INTO shr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Erhi omuntu ankayanka omwâlikazi, bombi banafè; ebi bajizire biri bya kucîsherêza. Bacibarhuzize omukò gwâbo bône. ");
INSERT INTO shr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Erhi omuntu ankalâla n’omulume nka kula balâla n’omukazi, bulya ebi bajizire biri bibî bwenêne, bombi banafè. Bacibarhuzize omukò gwâbo bône. ");
INSERT INTO shr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Erhi omuntu ankarhôla omukazi akagal’irhôla na nnazâla, erhi kuli kuhemuka. Banabayôce ye bona balya bakazi ntyo ntà cihemu cankaciba ekarhî kinyu. ");
INSERT INTO shr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Erhi omuntu ankalâla n’ecintu, anafè n’eco cintu banacinige. ");
INSERT INTO shr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Erhi omu­kazi ankacîhà ecintu mpu cimuhamharhe, munanige oyo mukazi n’eco cintu. Byône bicîbarhuzize omukò gwâbyo byône. ");
INSERT INTO shr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Erhi omuntu ankayanka mwâli wâbo, mwâli w’îshe erhi mwâli wa nnina, erhi ankabona obushugunu bwâge naye erhi olya mwâli wâbo ankabona obushugunu bwâge, ziri nshonyi nnene ezo. Banabahise omu masù ga bene wâbo, bulya anabwîne obushugunu bwa mwâli wâbo, anabarhule omuzigo gw’obubî bwâge. ");
INSERT INTO shr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Erhi omuntu ankayanka omukazi oli omu mugongo, n’erhi akabona obushugunu bwâge, bulya anabwîkwire halya gulya mukò guli gwarhenga, banabakage bombi embere za bene wâbo. ");
INSERT INTO shr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Orhahîra okubwikûla obushugunu bwa munyokò, erhi obwa nyakashenge, erhi mubiri gwâwe oyambisize obusha; mweshi mwanahanirwa obubî bwinyu. ");
INSERT INTO shr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Erhi omuntu ankayanka mukà mwishè, bulya anabwikwire obushugunu bwa mukà mwishè, banabarhule omuzigo gw’ecâha câbo na ntyo banafè buzira kubona mwâna. ");
INSERT INTO shr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Erhi omuntu ankarhôla mukà mwene wâbo, kuli kuhemuka, erhi abwîkwîre obushugunu bwa mwene wâbo, barhakabona mwâna. ");
INSERT INTO shr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Mulange amarhegeko gâni n’engeso zâni zoshi: mukaz’igashimba lyo eco cihugo nammutulira cirhag’imushala. ");
INSERT INTO shr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Murhashimbaga amarhegeko g’ishanja nahîva embere zinyu; bulya bal’ijizire amabî gali nk’ago; co carhumire bangayîsa. ");
INSERT INTO shr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Co cirhumire mubwîzire oku mwe mukola mwayanka ecihugo câbo, nie nammuhaco cibè cinyu, ciri cihugo cihululamwo amarhà n’obûci! Nie Nyakasane, Nyamuzinda winyu wammuberûlaga ekarhî k’ago mashanja. ");
INSERT INTO shr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Muberûle ensimba zihumânya n’ezirhahumânya, orhunyunyi rhuhumânya n’orhurhahumânya lyomulek’icîhemula erhi ezo nsimba, orhwo rhunyunyi na ngasi byoshi binyagârha oku idaho birhuma. Ngasi byoshi nammuberûlire mubilole nka bihemule. ");
INSERT INTO shr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mubè bimâna embere zâni bulya ndi mwimâna, niono Nyakasane. Nâmmuberûla kuli ago mashanja lyo mubà bâni ");
INSERT INTO shr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Amango hali omulume erhi mukazi ekarhî kinyu orherekêra abazimu erhi mushonga, abo bantu banafè, banababande amabuye. Bacîbarhuzize omukò gwâbo bône. ");
INSERT INTO shr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Nyakasane anacibwîra Mûsa, erhi: Ogend’idesa abadâhwa bene Aroni, obabwîre oku ntà mudâhwa ciru n’omuguma mulibo wacîhemulaga erhi mufù gw’omu mulala gwâge gurhuma. ");
INSERT INTO shr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ntadesiri omufù gw’îshe, ogwa nnina, ogw’omugala, ogw’omwâli erhi ogw’omulumuna erhi gwa mukulu wâge. ");
INSERT INTO shr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Ciru ankabà mwâli wâbo, arhasag’iheruka, acibà haguma naye, kwanarhuma azira. ");
INSERT INTO shr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Bulya ali mukulu omu mulala gw’olubaga lwâge, amanye ankacîhemula ahemule n’ecikono câge. ");
INSERT INTO shr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Abadâhwa bacîlange bamanye barhakâg’ikungûlwa emviri oku irhwe, barhakâg’imômwa obwânwa bubè mishosho, bacîlange barhakâg’ishâkwa. ");
INSERT INTO shr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bali batagatîfu ba Nyamuzinda, kuziga bamanye bankalogorhera Izîno lya Nyamuzinda bulya bo balêrhera Nyamuzinda enterekêro z’abantu; biryo bya Nyamuzinda wâbo: kuziga bagwâsirwe okubà bimâna. ");
INSERT INTO shr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Barhahîra bakayanka omukazi mûmaguza, erhi orhankakengwa; barhahîra bakayanka omukazi ohulusîbwe n’ibà, bulya omudâhwa ayôsire ali murhererkêre Nyamuzinda wâge. ");
INSERT INTO shr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mugwâsirwe okumukenga, bulya ye wahirwe okurherekêra omugati gwa Nyamuzinda winyu, okâmulola nka mwimâna embere zâwe, bulya niene ndi mwimâna, niono Nyamuzinda, nie mbayimânika bimâna. ");
INSERT INTO shr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Erhi mwâli w’omudâhwa ankacîshûbula, omu kuj’ashenza, erhi anali îshe olya ashûbwîre; olya munyere akola wa kudûlikwa muliro afè. ");
INSERT INTO shr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Omudâhwa mukulu, ôbà akulire bene wâbo, ye wadubuliragwa amavurha oku irhwe, agal’inayîmikwa mpu akaz’iyambala emyambalo migishe, arhankashandâza emviri zâge, arhankanasharhangula emyambalo yâge. ");
INSERT INTO shr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Oyôla arhankashegera aha murhumba ciru n’omuguma, arhanacîhumânyagya omu kuyegera oli omurhumba gw’îshe n’oli ogwa nnina. ");
INSERT INTO shr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Arhankahasha okurhenga omu ka-Nyamuzinda, lyo arhag’ilogorhera aka-Nyamuzinda wâge. N’ecarhuma ahanzibwa ntyo, ganali galya mavurha ga Nyamuzinda ashîgagwa mpu libè ishungwè lyâge, nie Nyakasane nkudesire. ");
INSERT INTO shr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Amango akola ajà omu buhya, kukwânîne ayanke omunyere ocigwêrhe ibikira. ");
INSERT INTO shr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Arhankayanka omûka­na, arhankanayanka omukazi ohulusîbwe n’ibà, arhankanayanka omukazi w’olugendo lubî, kandi erhi ojà ashenza. Ci akola ayanka omukazi, anayanka omushugi-nyere w’omu bûko bwâge. ");
INSERT INTO shr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Arhabonesagya iburha lyâge nshonyi omu karhî k’olubaga lwâge, bulya nie Nyakasane wamuyîmanikaga nanammujira Mutagatîfu. ");
INSERT INTO shr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Nyakasane aganîza Mûsa, amubwîra erhi: ");
INSERT INTO shr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Obwîre Aroni ntyâla: ntà muntu ciru n’omuguma w’omu bûko bwâwe wankabà agwêrhe obulema oku mubiri gwâge, akagal’icîshomya mpu ayêgera arherekêre Nyakasane wâwe. ");
INSERT INTO shr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ntà muntu ciru n’omuguma wankabà agwêrhe obulema, akagal’icîshomya ayêgera omu luhya, abè muhûrha, erhi mukûnagizi, omuntu w’izulu lihombôsire, erhi cingiringiri. ");
INSERT INTO shr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Kandi erhi omuntu ovunisire okugulu erhi kuboko; ");
INSERT INTO shr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","omuntu w’enyonjo, engonyi, ow’isù ly’omurwege, ow’olukulubuju, omushomyo, enkonè. ");
INSERT INTO shr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ntà muntu ciru n’omuguma w’omu bûko bw’omudâhwa Aroni wankabà agwêrhe obulema oku mubiri, akacîshomya mpu ayêgera Nyakasane mpu amurhûle enterekêro; bulya agwêrhe obulema oku mubiri: kuziga arhankacicîshomya mpu arherekêra Nyamuzinda wâge. ");
INSERT INTO shr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Nêci acigwêrhe obuhashe bw’okulya oku biryo bya Nyamuzinda wâge, ciru n’oku bwangà bwimâna, n’oku bwangà bwimâna bwenêne. ");
INSERT INTO shr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ci arhankajà ebwa nshabâbiro ntagatîfu, arhankanayegêra oluhêrero, bulya agwêrhe obulema oku mubiri, amanyâge ankanaziza ahantu hâni himâna, bulya nie Nyakasane mpajira himâna. ");
INSERT INTO shr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mûsa anacibwîra Aroni ntyo boshi n’abagala na Bene-Israheli boshi. ");
INSERT INTO shr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Nyakasane anaciganîza Mûsa, amubwîra erhi: ");
INSERT INTO shr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Ogend’ibwîra Aroni n’abagala, bacîlange oku bwangà butagatîfu bw’ebi bene Israheli barherekêra, banamanye bankahemukira izîno lyâni, nie Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Onababwîre oku erhi ngasi muntu w’omu bûko bwinyu, yêshi ankabà azizire, agal’iciîshomya mpu ayêgera obwangà butagatîfu bw’ebi bene Israheli banterekêra, oyôla muntu akola ayôsire ali mukâge embere zâni. ");
INSERT INTO shr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ntà muntu w’omu bûko bwa Aroni wankabà mubenzi erhi mushomyo wankalya oku bwangà bwimâna arhanacicêsibwa. Kwo na kuguma n’owundi muntu wankahuma kuli ngasi kantu omufù gwahemwîre, nîsi erhi omuntu ogeza emburho. ");
INSERT INTO shr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ngasi yêshi ohuma oku mirhumba y’ebinyagâsi birya byankarhuma omuntu azira nîsi erhi omuntu ozizire ankamuhemba omuziro gwâge mulebe, ");
INSERT INTO shr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","kwo kuderha oku ngasi ocîshomya mpu ahuma kuli ebyôla, anayôrhe azizire kuhika bijingo, arhankalya bwangà bwimâna, ci arhang’igenda ashuke omubiri gwâge n’amîshi. ");
INSERT INTO shr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Hano izûba lihorha, anabà bwinjà, lêro anahashaga okulya oku bwangà bwimâna, bulya biri biryo byâge. ");
INSERT INTO shr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Arhankalya ecintu cacîhozagya, nîsi erhi cayirhagwa n’ensimba, bulya canarhuma azira. Nie Nyakasane okudesire. ");
INSERT INTO shr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bashimbe amarhegeko gâni lyo barhag’ijira ecâha, omu kugavuna, obone bamâfà bulya bamahemukira obwangà butagatîfu, nie Nyakasane obajira bimâna.» ");
INSERT INTO shr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ntà muntu orhali wa muli bene Levi wankalya oku bwangà bwimâna, omubunga orhali wa muli bene Levi, kandi erhi omulimya, barhankalya oku bwangà bwimâna. ");
INSERT INTO shr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ci omujà omudâhwa agombôlaga n’ensaranga, yêhe anahasha okubiryakwo, kuguma n’omujà obusirwe omu mwâge banahasha okulya oku bwangà bwâge. ");
INSERT INTO shr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Mwâli w’omudâhwa erhi ankaheruka omu mw’omuntu orhali wa muli bene-Levi, arhankacilya ebiryo byakûlagwa oku bwangà bwimâna. ");
INSERT INTO shr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ci oyôla mwâli w’omudâhwa, erhi ankabà mukana nîsi erhi ankahulusibwa nk’arhagwêrhi bâna akagaluka aha mwâbo, akanahabêra nka kulya al’iyôsire amango aciri munyere, anahasha okulya oku biryo by’o­ bwangà bw’îshe, ci ntà cigolo cankabiryakwo ");
INSERT INTO shr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Erhi omuntu ankahabuka, kurhume alya eby’obwangà buyerekera omudâhwa, anajuha omudâhwa kalya kantu kimâna, anayûshûlekwo ecigabi ca karhanu. ");
INSERT INTO shr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Abadâhwa bagwâsirwe okucîlanga oku kulogorhera obwangà bwimâna, bwa bene Israheli, bulya baberûliraga Nyakasane; ");
INSERT INTO shr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","bacîlange oku kubabarhuza omuzigo gw’ecâha, cirya bankajira omu kulya eby’obwangà bwimâna, canarhuma bahûna e­ nterekêro y’okulyûla, bulya nie Nyakasane, nie mbijira bimâna. ");
INSERT INTO shr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Oj’ibwîra Aroni n’abagala, kuguma na Bene Israheli boshi, erhi: “Ngasi muntu muli bene Israheli nîsi erhi omubunga obalimwo, amango g’okurhûla enterekêro, ebè ya kuyûkiriza eciragâne, erhi ya kushenga kwônene, erhi ankarhûla Nyakasane enterekêro y’okusingônolwa”, ");
INSERT INTO shr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","“lyo eyêmêrwa, embâgwa ekwânîne ebè ya ndume erhagwêrhi ishembo, mpanzi, ngandabuzi erhi cihebe”, ");
INSERT INTO shr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","“murhahîra mukarhûla enterekêro elikwo ishembo, bulya erhankayankirirwa”. ");
INSERT INTO shr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Erhi omuntu ankarhûla Nyakasane enterekêro y’omu bishwêkwa byâge, binene kandi erhi binyinyi mpu bibè nterekêro y’omurhûla, kandi erhi ya kuyûkiriza ciragâne cirebe, nîsi erhi ya bulonza kwônene, embâgwa, lyo eyêmêrerwa, egwâsirwe ebè elingânîne, erhalikwo ishembo”. ");
INSERT INTO shr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","“Ecintu c’omuhûrha, ecayisha cahegera, ecitwîrwe ecirumbu, ecigwêrhe ebihulu, olukulubuju n’olujavu, murhankacirhûla Nyakasane, ntà kantu ka kulico kankahêkwa oku luhêrero mpu kabè nterekêro nsingônola embere za Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“Wanahâna ecintu cigwêrhe obulema erhi ecigonyahîre, cibè c’omu bi­shwêkwa binene erhi c’omu byofôfi, wanacihâna nka nterekêro ya bulonza kwônene ci orhankacihâna nka nterekêro ya kuyûkiriza eciragâne bulya erhankayankirirwa”. ");
INSERT INTO shr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“Murhankahêra Nyakasane ecintu cigwêrhe amazà mahinage, amatuntume erhi matwe; murhahîra mukarhûla ntyôla omu cihugo cinyu”. ");
INSERT INTO shr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“Ciru yankarhenga omu maboko g’omubunga w’ekarhî kinyu, murhayêmêraga enterekêro yamwene eyôla, mpu yo yabâ biryo bya Nyamuzinda winyu, bulya yabihire erhi kubakwo ishembo kurhuma. Erhankayankirirwa”». ");
INSERT INTO shr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Akanina erhi omwâna-buzi erhi omwânahene ankaburhwa, anayôrha nsiku nda adwîrhe agoba nnina, kurhenga olusiku lwa kali munâni, n’ezindi nsiku zakulikira anahashag’iyankirirwa nka nterekêro y’okusingônolwa embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","“Enkafu n’akanina kâyo, ecibuzi n’omwâna waco, mumanye murhakâg’ibibâgira lusiku luguma”. ");
INSERT INTO shr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Amango mwarhûla Nyakasane enterekêro y’okuvuga omunkwa munayirherekêre kulya kwankarhuma yayêmêrwa”, ");
INSERT INTO shr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","“elîbwe olwo lusiku lwo nanênè, ntâco casigalaga kuhika kuca sêzi, nie Nyakasane okudesire”». ");
INSERT INTO shr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Mukaz’ilanga amarhegeko gâni, munagashimbe bwinjà, nie Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","“Murhahîra mukahemukira izîno lyâni limâna, kukwânîne nkuzibwe ekarhî ka bene Israheli, bulya nie Nyakasane, obajira bimâna.”. ");
INSERT INTO shr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","“Nie nammukûlaga omu cihugo c’e Mîsiri mpu lyo mbà Nyamuzinda winyu, nie Nyakasane.”» ");
INSERT INTO shr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Nyakasane ashambâza Mûsa ambwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Ogend’ibwîra bene Israheli, erhi: Lolagi amango mwakaz’icîsêza okushimânanamwo omu ndêko nyimâna, za Nyakasane, ago mango gakâbà mango makulu bwenêne. ");
INSERT INTO shr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Bakaz’ikola nsiku ndarhu, ci olusiku lwa kali nda luli luzira (Sabato), lusiku lwa kurhamûka lwoshi, olwo lusiku lubè lusiku lwa ndêko nyimâna. Mw’olwo lusiku murhahîraga mukajira mukolo muci, bulya gali mango ga kurhamûka, ganarherekirwe Nyakasane, ngasi hoshi mwankanayûbaka. ");
INSERT INTO shr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Lolagi ensiku nkulu za Nyakasane, endêko mugwâsirwe mukaz’ihamagala bene Israheli okurhimanana muli ezo nsiku z’endêko nyimâna ngasi luguma omu mango gâlwo. ");
INSERT INTO shr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ngasi mwêzi gwa burhanzi omu nsiku ikumi n’ini z’ogwo mwêzi, gala mango izûba lizika, ali Basâka wa Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Olusiku lwa kali ikumi na karhanu lw’ogwo mwêzi, lwakâbà lusiku lukulu lw’emigati erhalimwo lwango, lusiku lwakaz’ijirwa erhi irenge lya Nyakasane lirhumire. Mukaz’irya emigati erhalimwo lwango nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Olusiku lurhanzi mwakâjira endêko nyimâna, murhahîraga mukâjira omukolo mudârhi mwo. ");
INSERT INTO shr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mukaz’irherekêra Nyakasane muli ezo nsiku nda enterekêro nsingônola n’omuliro. Olusiku lwa kali nda habè endêko nyimâna, murhahîraga mukajira omukolo mudârhi. ");
INSERT INTO shr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Ogend’ibwîra bene Israheli ntyâla: Amango mwahika muli cirya cihugo nammuha, erhi mwankabà mwasârûla muli eco cihugo, mwanarhûla omudâhwa omuhuli murhanzirhanzi mwanasârûlaga. ");
INSERT INTO shr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Anarhûla Nyakasane gulya muhuli omu kugumogamoga lyo ammurhonya. Okwo kukwânîne kubè olusiku lukulikire oluzira. ");
INSERT INTO shr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Olwôla lusiku mwanarherekèrera Nyakasane enterekêro nsingônola y’omwâna-buzi wa mwâka muguma orhagwêrhi ishembo. ");
INSERT INTO shr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Enterekêro y’enkalangè yayilusa ebè ya bigabi bibirhi bya kali ikumi by’omulengo gw’enshâno enozire mvanganye n’amavurha, nka nterekêro nsingônola n’omuliro, nterekêro ya buhumule bwinjà embere za Nyakasane, irivayi ly’okusûza, canabâ cigabi ca kani c’omulengo. ");
INSERT INTO shr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Murhahîra mukalya emigati nîsi erhi emihuli myoce kandi erhi mibishi kuhika olwôla lusiku lwonênè mwâlerhe entûlo yinyu embere za Nyakasane. Eryo liri irhegeko linyu ly’ensiku n’amango, oku ngasi bûko bwinyu na ngasi hoshi mwanayûbake. ");
INSERT INTO shr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kurhenga olusiku lwakulikira Sabato, kuhika olusiku mwayisha mudwîrhemwo emihuli y’okuhêreza Nyakasane, mwanaganja migobe nda migumagumà. ");
INSERT INTO shr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Muganje nsiku makumi arhanu kuhika oku lusiku lwakulikira Sabato wa kali nda, na ntyo mwanahêra Nyakasane enterekêro y’enkalangè y’ebihyâhya mwasârûlaga. ");
INSERT INTO shr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Mwanakaz’ilêrha kurhenga emwa bînywè, migati ibirhi ya nterekêro y’okumolekwa Nyakasane yajiragwa na mirengo ibirhi ya kali ikumi ya nyamâha w’enshâno enozire, enabè eyenzirwe haguma n’olwango: ziri ntang’iyêra za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Eyôla migati mwarherekêra nterekêro y’ensirîra e­mwa Nyamuzinda, mwanahirakwo bâna-buzi nda ba mwâka muguma barhali­ kwo ishembo, mpanzi nguma ntôrhò na ngandabuzi ibirhi, banayûshûlakwo e­nterekêro y’enkalangè n’ecinyôbwa nka oku munakômerera: ebè nterekêro y’okusingônolwa n’omuliro, ya buhumule bwinjà embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mubâge n’ecihebe, cibè nterekêro oku byâha na bâna-buzi babirhi babè nterekêro y’okushenga omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Omudâhwa anabimoleka Nyakasane kuguma n’erya migati y’entang’iyêra. Kuguma n’ebyôla bibuzi byombi, byoshi byanarhûlwa Nyakasane, buzinda byanabà bya mudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mw’olwôla lusiku lwonênè mwanalâlikana oku lusiku lukulu, mugal’ijira endêko nyimâna: murhahîra mukajira mukolo guhi, liri irhegeko ly’ensiku zoshi kuli ngasi bûko bwinyu na ngasi hantu mwankanayûbaka. ");
INSERT INTO shr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Amango mwasârûla emburho z’omu cihugo, cinyu, murhahîra okuhika omu mihaliro y’amashwa ginyu, murhahîraga mpu mwaja mwarhôlogola ngasi bisigîre byankakundêzibwa; ebyôla mwanabilekera omukenyi n’ecigolo. Nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Nyakasane ashambâza Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Ogend’idesa Bene Israheli ôbà­ bwîre oku olusiku lurhanzi lw’omwêzi gwa nda lwâbe lusiku lwâni, lusiku lwa kurhamûka, lusiku lwa kubûha omushekera gw’okulâlika endêko nyimâna. ");
INSERT INTO shr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Murhakâg’ijira mukolo muci, ci mukaz’irherekêra Nyakasane enterekêro y’okusingônolwa n’omuliro. ");
INSERT INTO shr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Nyakasane ashambâza Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Olusiku lwa kali ikumi lw’ogwôla mwêzi gwa kali nda, lwo lwâbà lusiku lukulu lw’empyûlo: olwo lusiku mwâna­bà n’endêko nyimâna, mucîshalise munarhûle Nyakasane ishêga. ");
INSERT INTO shr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Murhahîra mukakola olwôla lusiku, bulya luli lusiku lwa kuhyûla, lwo lusiku mukwânîne okujirirwa enterekêro y’oku byâha binyu embere za Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ngasi muntu wankabula kucîshalisa mw’olwo lusiku ali wa kurhenzibwa omu lubaga lwâge. ");
INSERT INTO shr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ngasi yêshi wankacîshomya mpu akola mw’olwo lusiku, nanamurhîngamira. ");
INSERT INTO shr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Murhankakola ciru n’ehitya. Liri irhegeko ly’ensiku zoshi eryo, kuli ngasi bûko bwinyu na ngasi aha mwayûbake hoshi. ");
INSERT INTO shr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kuli mwe olwo lusiku lubè lwa Sabato, lubè lwa kurhamûka lwoshi, lubè lwa kucîbabaza. Omu nsiku mwenda z’omwêzi, kurhenga bijingo kuhika bindi bijingo, mulange olwa Sabato, murhahumaga kabishi. ");
INSERT INTO shr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Nyakasane ashub’ishambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Omu nsiku ikumi n’irhanu z’omwêzi gwa kali nda, lukâba lusiku lukulu lw’amarâro, lukâjirwa nsiku nda zoshi z’okukuza Nyakasane, kwo wabwîra bene Israheli ntyo. ");
INSERT INTO shr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Olusiku lurhanzi hakâbà endêko nyimâna, murhakâg’ihîra mpu mwajira mukolo muci. ");
INSERT INTO shr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mukâgeza nsiku nda erhi kurherekêra muli mwarherekêra Nyakasane enterekêro z’okusingônolwa n’omuliro. N’olusiku lwa kali munâni mwanabà n’endêko nyimana, lyo mwankarherekêra Nyakasane enterekêro y’okusingônolwa n’omuliro luli lusiku lukulu lw’okushwinja. Murhakâg’ihîra mpu mwajira mukolo muci. ");
INSERT INTO shr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Zo nsiku nkulu za Nyakasane ezo, zo mwakaz’ikombêra n’okujiramwo e­ndêko nyimâna, lyo murhûla Nyakasane enterekêro z’okusingônolwa n’omuliro, okurhûla ensirîra, enkalangè, embâgwa n’ecinyôbwa. Nka kulya birhegesirwe kuli ngasi lusiku. ");
INSERT INTO shr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Erhi zinaberûlukinwe n’olwa Sabato wa Nyakasane. N’erhi zinaberûlukinwe n’ez’okuyûkiriza ebiragâne binyu n’erhi zinaberûlukînwe n’enterekêro murhûla Nyakasane n’obulonza bwinyu. ");
INSERT INTO shr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Olusiku lwa kali ikumi na karhanu lw’omwêzi gwa kali nda, hano mubà mwamâsârûla emburho z’omu cihugo mwanajirira Nyakasane olukulu lwa nsiku nda, olusiku lurhanzi kwanabà kurhamûka kunene, oku lusiku lwa kali munâni, lwâbà lwa kurhamûka kandi kunene. ");
INSERT INTO shr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Oku lusiku lurhanzi mwanarhôla oku malehe g’emirhi yinyu minjà, mwanarhôla omu nfune amashami g’emishugushugu, amashami g’emirhi y’ecishakashaka n’ag’ecikanganyambwe c’oku lwîshi, mukâbihindana n’omwîshingo embere za Nyakasane winyu muli ezôla nsiku nda. ");
INSERT INTO shr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ngasi mwâka mwakaz’ijira olwo lusiku lukulu lwa nsiku nda z’okukuza Nyakasane. Eryo liri irhegeko oku iburha linyu lyoshi, mwakaz’ilu­jira ngasi mwêzi gwa kali nda. ");
INSERT INTO shr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mwakaz’igeza nsiku nda erhi mulâla omu birâlo by’ebyâsi. Ngasi muburhwa w’omu Israheli akaz’ilâla muli ebyo biràlo, ");
INSERT INTO shr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","lyoki iburha linyu lyankamanya oku nammuhandisize omu birâlo amango na­ mmukûlaga omu cihugo c’e Mîsiri; nie Nyakasane, Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mûsa anacimanyîsa ebyo byoshi kuli bene Israheli, ezo nsiku nkulu z’okukuza Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Orhegeke bene Israheli okukaz’ilerha amavurha g’emizêti misimârhe, gashongwîre na mahyâhya, ganali ga kutwânwa ensiku n’amango omu kamole k’aka-Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aroni akaz’ikalanga kayôrhe kayâsire ensiku zoshi omu kagombe k’endêko embere ly’enshabiriro; kurhenga bijingo kuhika sêzi, erhi kayâsire buzira kuhusa, embere za Nyakasane. Liri irhegeko ly’ensiku zoshi, oku iburha linyu lyoshi. ");
INSERT INTO shr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Akaz’iyimanza amatara gali oku ishami lyatulagwa n’amasholo, gakaz’iyôrha gayasire embere za Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Orhôle omulà gw’enshâno enozire, oyendesemwo rhugati ikumi na rhubirhi rhwa bununirizi, ngasi higuma hidugwe na bigabi bibirhii bya kali ikumi bya mulengo gw’eyo nshâno. ");
INSERT INTO shr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ogal’irhudekêreza oku karhalarhala k’amasholo gali embere za Nyakasane; ojire nkere ibirhi, ngasi lukere kuje rhugati ndarhu. ");
INSERT INTO shr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Wanahira enshangi nyinjà erhalimwo bindi bici oku ngasi lukere lw’orhwôla rhugati, yo wakolêsa oku mugati gwasingônolwa gubè biryo bya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ngasi lwa Sabato, eyôla migati ekâyôrha yadekêrezibwa embere za Nyakasane, ebè nterekêro ya bene Israheli, liri irhegeko ly’ensiku zoshi eryo. ");
INSERT INTO shr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Eyo migati yanabà ya Aroni n’abagala. Banakaz’iyilira ahantu himâna, bulya kuli bo buli bwangà bwimâna, bw’oku nterekêro nsingônola yajiriragwa Nyakasane. Eryôla liri irhegeko ly’ensiku n’amango. ");
INSERT INTO shr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Mugala w’omuyahudi-kazi muguma cikwônene erhi n’îshe ali munyamisiri, anacihuluka omu mwâge, ajà muli bene Israheli, omu lugo barhulubana na muny’Israheli muguma. ");
INSERT INTO shr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Muli eyo nongwè, olya mwâna w’omuyahudi-kazi, ahemukira Izîno lya Nyakasane, alijacira kubî, nnina ye wali Shelomiti, mwâli wa Debri, w’omu bûko bwa Dani. ");
INSERT INTO shr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Bamushwêka banamulindisa Mûsa mpu kuhika ababwîre kurhi Nyakasane alonzize bamujirire. ");
INSERT INTO shr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Nyakasane ashub’ibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Orhenze oyo wahemusire omu lugo n’abayumvagya oku alogorha bamuhirekwo amaboko oku irhwe, kandi e­ndêko yoshi y’abantu emubande amabuye. ");
INSERT INTO shr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Oj’ibwîra bene Israheli, oku ngasi muntu wankajacira Nyakasane, oyôla anayôrha abarhwîre ecâha câge, ");
INSERT INTO shr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","n’owankalogorhera Izîno lya Nyakasane anahâbwe obuhane bw’okuyîrhwa: endêko yoshi yanamubanda amabuye, akabà mwîkala, nîsi erhi mubunga, ngasi yêshi wankalogorhera Izîno lya Nyakasane limâna, ali wakuyîrhwa. ");
INSERT INTO shr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Owankashûrha owundi muntu kuhika okufà, olya wamushûrhaga kuhika naye ayîrhwe. ");
INSERT INTO shr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Owankashûrha ecintu cishwekwa ca bene kuhika okufà, oyôla agwâsirwe okugalula ecindi cizîne, buzîne oku buzîne. ");
INSERT INTO shr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Erhi muntu mulebe a­nkababaza owâbo muntu, oyôla naye banamujirire naye nk’oku anajiriraga owâbo. ");
INSERT INTO shr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Buvune oku buvune, isù oku isù, lîno oku lîno, banamubabaze nk’oku anababazagya mulungu wâge. ");
INSERT INTO shr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Owankayîrha ecintu cishwêkwa ca bene, anagule ecindi cintu cishwekwa cizîne. Ci owankayîrha omuntu, oyôla kukwânîne ayîrhwe. ");
INSERT INTO shr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Eryo liri irhegeko linyu mweshi, abè mubunga, abè muburhwa omu cihugo, bulya nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mûsa erhi ayûs’ibwîra bene Israheli okwôla, arhegeka mpu olya walogorheraga Nyakasane arhenzibwe omu lugo bamubande amabuye. Bene Israheli banacijira nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Nyakasane abwîrira Mûsa oku ntondo ya Sînayi, erhi: ");
INSERT INTO shr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Oj’idesa Bene Israheli obabwîre, erhi: Amango mwahika muli cirya cihugo nâmuhà, obudaka bwakaz’ihumûka: abè Sabato oku irenge lya Nyakasane ");
INSERT INTO shr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Wanakârhwêra amashwa gâwe myâka ndarhu, wanakashogolera ishwa lyâwe ly’emizêtuni myâka ndarhu, onakaz’isarûlamwo emburho zâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Omwâka gwa nda gwanakâbà mwâka guzira (gwa Sabato), mwâka gwa kurhamûsa obudaka lwoshi, mwâka guzira, irenge lya Nyakasane lirhumire: ogwôla mwâka orhahîra okamîra ishwa lyâwe, orhahîra okushogolera emizâbîbu yâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Orhahîra okuhumbûla ebicimezize byônene by’emburho zâwe zahungumukaga amango g’okusârûla, orhanaderhaga mpu wagend’ihumbûza amalehe g’emizâbîbu ya­we erhashogolîrwi. Guli mwâka gwa kuhumûsa obudaka. ");
INSERT INTO shr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ebyankayêra omu budaka agwola mango ga Sabato byanabà biryo byâwe mwena mwambali wâwe, mwambalikazi wâwe, omuntu olimya aha mwâwe, n’ecigolo ciri aha mwâwe, kwo kuderha oku we na ngasi boshi balama aha mwâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ebintu bi­shwekwa n’ensimba z’omu cihugo cinyu, nabyo byakaz’ilya ngasi byankayêra muli obwôla budaka agôla mango. ");
INSERT INTO shr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Wanaganja zizira nda, kwo kuderha Sabato nda za myâka nda kali nda, amango g’ezôla zizira nda z’emyâka, zakubêra mango ga myâka makumi anni na mwenda. Kwo kuderha mango ga migobe ya myâka nda migumaguma. ");
INSERT INTO shr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Omu nsiku ikumi z’omwêzi gwa kali nda, obûhe omushekera, gushekêreze, oku kulâlika olusiku lukulu lw’okuhyûlira ebyâha, mugere omu cihugo coshi mwayisha mwabûha omushekera. ");
INSERT INTO shr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Muderhe oku guli mwâka Mutagatîfu, o­mwâka gwa makumi arhanu, munaderhe oku abîkalà b’ecihugo boshi bamârhenga omu bujà, n’oku ngasi mwîkala arhacigwêrhi cihanzo c’okuyûbaka nka oku analonzize, ngasi muguma ashagaluke, ashubirane ehyâge, anashubire omu mulala gwâge. ");
INSERT INTO shr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Omwâka gwa makumi arhanu gubè mwâka gwinyu gw’okushagaluka, murhahîra mukarhwêra emburho nîsi erhi kuhumbûla orhwîmerêra murhanahîraga mukahumbûla amangakà oku mirhi yinyu erhali mishogolere. ");
INSERT INTO shr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Bulya guli mwâka gwa bushagaluke bwinyu; gubè mwâka gwinyu mugishe, munalye emburho z’omu mashwa. ");
INSERT INTO shr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Muli ogwôla mwâka gw’obushagaluke, ngasi muntu ashubirane ehyâge. ");
INSERT INTO shr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Erhi wankagula nîsi erhi kuguliza mulungu wâwe kantu kalebe, mumanye oku ntâye ogwêrhe obuhashe bw’okulenganya mwene wâbo. ");
INSERT INTO shr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wakaz’igulira mwene winyu, omu kushimba ecicîro c’amagerha cikwânîne kurhenga oku mwâka gw’okushagaluka gwazindig’igera, naye anakugulize kushimbana n’e­myâka ali asârûla. ");
INSERT INTO shr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Oku emyâka yajà yayushûka kwo nâwe wanaja wayûshûla engulo, n’oku emyâka yajà yanyiha, erhi na nâwe kwo wanaja wanyihya e­ngulo, bulya erhi cigabi cilebe c’ebi asârûlaga co akugulize. ");
INSERT INTO shr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ntâye olenganyagya mwene wâbo, orhînye Nyamuzinda, bulya nie Nyakasane, Nyamuzinda wâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Mushimbe amarhegeko gâni, munalange engeso zâni, na ntyo mwanabà n’omurhûla omu cihugo. ");
INSERT INTO shr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Idaho lyanayâna emburho zâlyo, mwanalya munayigurhe oku munalonzize, munabere n’omurhûla. ");
INSERT INTO shr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Erhi mwankacîdôsa mpu: Bici rhwayish’ikalya muli ogwôla mwâka gwa kali nda, ebwa kubà rhurhankarhwêra, rhurhakanasârûla emburho zîrhu? ");
INSERT INTO shr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mumanye oku nayîsh’imurhumira omugisho gwâni omu mwâka gwa kali ndarhu, muli gwo mwanayêza emburho mwalya myâka isharhu. ");
INSERT INTO shr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Omu mwâka gwa kali munâni mwanashub’irhwêra, mwanakaz’ilya oku muhako gwa mîra kuhika oku mwâka gwa kali mwenda, kuhika mushub’iyêza erhi munadwîrhe mwalya omuhako gwa mîra. ");
INSERT INTO shr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Obudaka burhankaguzibwa lwoshi, bulya ecihugo ciri câni, munayûbasire emwâni nka bigolo, na nka bantu ba kugera kwônene. ");
INSERT INTO shr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Aha mwayûbake hoshi omu cihugo, mwakaz’iyêmêra omuntu agombôle amashwa gâge. ");
INSERT INTO shr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Erhi mwene winyu ankabà mukenyi, n’okwôla kurhume akuguliza ecihimbi c’ishwa lyâge, olya oyîmire ahâli hâge, nîsi erhi olya mwene wâbo omuyegîre kulusha, anahasha okuyisha anagombôle cirya cihimbi mwene wâbo aguzagya. ");
INSERT INTO shr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ci erhi ankabà omuntu arhagwêrhi mwene wâbo wayîma omu byâge, ci erhi yêne ankalonza ebyankagombôlamwo eryo ishwa lyâge analigombôle buzira mbaka. ");
INSERT INTO shr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Anaganja emyâka yamâgera kurhenga bagulizinye, agal’igalulira nyakugula engulo y’emyâka arhal’icihingamwo, kandi anashubira omu ishwa lyâge lwoshi ");
INSERT INTO shr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Erhi ankabà arhankacibona engulo y’okugombôlamwo ishwa lyâge, lirya lyanayôrha omu maboko ga nyakugula kuhika oku gundi mwâka gw’okushagaluka. Muli ogwôla mwâka gw’okushagaluka, nyakugula arhacishwesirwi na cici, naye nyakuguza anashubirana ishwa lyâge olusiku lw’okushagaluka. ");
INSERT INTO shr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Erhi omuntu ankaguza enyumpa yâge y’okulâla eri omu lugo luzungulusirwe n’ecôgo cizibuzibu, oyo muntu agwêrhe obuhashe bw’okugombôla eyo nyumpa yâge kuhika oku buzinda bw’omwâka gukulikire ogu aguzagyamwo. ");
INSERT INTO shr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Erhi ankabà erya nyumpa eri omu lugo luzungulusirwe n’ecôgo cizibuzibu erhagombwîrwi enyuma lya mwâka mugumagumà, erya nyumpa yanayôrha y’o­lya wayigulaga bône abâna bâge. Ntâye wankacibarhenzamwo. Ciru n’amango gw’omwâka gw’okushagaluka erhankarhenga omu maboko gâbo. ");
INSERT INTO shr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ci enyumpa ziri omu bishagala birhanazungulusirwi n’ebyôgo, zanakaz’ilola kuguma n’amashwa ziyûbasirwemwo. Zanahash’igombôlwa n’okushubira omu maboko ga bênezo, n’abâli baziguzire banazirhengamwo n’okuzishubiza bênezo, amango g’omwâka gw’okushagaluka. ");
INSERT INTO shr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Oku biyêrekîre enyumpa na ngasi lugo lw’Abaleviti bagwêrhe obuhashe bw’okukaz’izigombôla. ");
INSERT INTO shr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Erhi omuntu ankagula enyumpa emwa Abaleviti, a­ gwâsirwe okuyirhengamwo n’okushubira omu lugo lulya ajiramwo aha mwâge, erya nyumpa yanagombôlwa oku mwâka gw’okushagaluka, bulya ezo nyumpa zibà omu bishagala by’Abaleviti, ziri birugu byâbo omu karhî ka bene Israheli. ");
INSERT INTO shr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Amashwa gali omu marhambi g’ebisbagala by’Abaleviti, garhankaguzibwa, bulya gali birugu byâbo ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Erhi omulungu wâwe ankakena akanakaz’ikuhûna, onakaz’imurhabâla, abè mubunga erhi cigolo; ntyo naye anahash’okulama bwinjà aha burhambi bwâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Orhamulongezagyakwo bunguke buci, ci okâkenga Nyamuzinda wâwe, orhakazâg’imuhugûga. ");
INSERT INTO shr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Orhamuhozagya amagerha gâwe mpu lyo ayishikuha obunguke, orhanamuhâga oku biryo byâwe mpu lyo oyîsh’imuyungukirakwo. ");
INSERT INTO shr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nie Nyakasane, Nyamuzinda wâwe, wammukûlaga omu cihugo c’e Mîsiri, nti mmuhè ecihugo c’e Kanâni, lyo nyôrha ndi Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Erhi mulungu wâwe ankakenera bwenêne aha burhambi bwâwe na muli okwo acîguze emunda oli, orhamukolêsagya nka mujà. ");
INSERT INTO shr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Anabêra aha mwâwe nka mulimya, nka cigolo, akaz’ikukolera nka mulimya kuhika oku mwâka gw’okushagaluka. ");
INSERT INTO shr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Enyuma z’aho anacîkubûla arhenge aha mwâwe, ye haguma n’abâna bâge aburha yênene, kandi anashubira omu mulala gwâge, n’omu by’ababusi bâge. ");
INSERT INTO shr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","N’ecarhuma okwo kubà, bulya bali bambali bâni nienene nabarhenzagya e Mîsiri barhankacîguza nka bajà ");
INSERT INTO shr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Orhamurhegekaga n’obu­kali ci okaz’irhînya Nyamuzinda wâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Abajà n’abajà-kazi, ogwâsirwe okujira mpu babè bambali bâwe, wakaz’ibagula omu mashanja gakuzungulusire. Muli agwola mashanja mwoki wakaz’ikula bambali na bambali kazi bâwe. ");
INSERT INTO shr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kandi mwanahasha okubagula omu bâna b’ebigolo biri haguma ninyu n’omu milala yâbo eri haguma ninyu, balya baburhiragwa emwinyu, abôla bâna bayôsire bali birugu binyu. ");
INSERT INTO shr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mwanabasigira abâna binyu enyuma zinyu, nka kashambala kâbo, banabayôrhane nka birugu byâbo, bagal’iyôrha ensiku zoshi bajà binyu, ci kuli bene winyu bene Israheli, ntâye muli mwe wabarhegekaga n’obukali. ");
INSERT INTO shr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Erhi ankabà omubunga kandi erhi mwambali wâwe agalire aha mwâwe, na mwene winyu muguma abâge mukenyi, agal’igend’icîguza emwa olya mubunga erhi emwa olya mwambali wâwe, nîsi erhi emwa omuburhwa w’omulala gw’embuga, ");
INSERT INTO shr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","oyôla muntu acigwêrhe obuhashe bw’okucîgombôla, bulya muguma wa muli bene wâbo anahasha okumugombôla. ");
INSERT INTO shr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mwishè kandi erhi mwene mwishè, anahasha okumugombôla, ciru na mwene wâbo kwônene anahasha okumugombôla. Kandi ciru yênene erhi ankalonza ebirugu anahasha okucîgombôla. ");
INSERT INTO shr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Boshi n’olya wamugulaga, banaganja emyâka ali kurhenga abîre mujà kuhika omu mwâka Mutagatîfu, n’ecijiro c’obuguzi canagererwa oku myâka yâge akozire, n’oku bunguke amudwîrhîre nka mukozi wâge. ");
INSERT INTO shr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Erhi ankabà hacisigîre myâka minji, yanaja omu busalizi kuguma n’ebi bamugulaga. ");
INSERT INTO shr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Erhi ankabà myâka misungunu yonene ecisigîre, embere z’omwâka gw’okushagaluka, anayiganja, agal’ilyûla ebyamucungula omu kuganja ngasi mwâka. ");
INSERT INTO shr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Anahasha okubêra aha mw’olya muntu nka mulimya akaz’imukolera omu mwâka, n’oyôla nnawâbo arhakâg’imukolêsa n’obukali munadwîrhe mwabona. ");
INSERT INTO shr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nka ntà kuguma agombwîre muli okola kwoshi, analîkwa bône abâna bâge omu mwâka gw’okushagaluka. ");
INSERT INTO shr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Bulya niene bene Israheli ba­gwâsirwe okushiga, bali bambali bâni, bulya niene nabakûlaga omu cihugo c’e Mîsiri, nie Nyakasane Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Murhahîra mukacîjirira abazimu mwakaz’iharâmya, murhahîra mukayimânika enshusho nîsi erhi mabuye mabinjûle, omu cihugo cinyu irhondo murhabonekanaga ibuye lirikwo enshusho mwakaz’ifukamira n’okuharâmya, bulya nie Nyakasane, Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mugendêrere ensiku zâni za Sabato, n’aka-Nyamuzinda kâni mukakenge, nie Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Mukakaz’ikulikira amarhegeko gâni n’okugalanga, mukakaz’ijira nk’oku mmuhûnyire, nanakaz’imuhà enkuba omu mango gakwânîne. ");
INSERT INTO shr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Amashwa ganayeramwo emburho zâgwo, n’emirhi eyânekwo amalehe gâyo. ");
INSERT INTO shr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Amango g’okuhûla engano ganahika omu nsiku z’okurhalika emizâbîbu n’amango g’okurhalika ganahika oku mango g’okumîra, mwakaz’ilya omugati gwinyu munayigurhe, munayûbake n’omurhûla omu cihugo cinyu. ");
INSERT INTO shr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nâhira omurhûla omu cihugo cinyu, mwâkaz’ihunga na ntâye wamufudusa, ensimba z’ebiryanyi, nazilibirhakwo omu cihugo cinyu, n’engôrho erhakacigera omu cihugo cinyu. ");
INSERT INTO shr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mwakaz’iminika abashombanyi binyu munabalambike n’engôrho. ");
INSERT INTO shr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Barhanu muli mwe bakaz’iminika igana, n’igana lyakaz’iminika bihumbi igana, abashombanyi binyu mwakâbalambika n’engôrho. ");
INSERT INTO shr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nayêrekera emunda muli, njire muburhe munayôloloke, nanywâna na ninyu. ");
INSERT INTO shr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mwakaz’ilya emihako yinyu, na nka byamakoya, mwanakabulira e­bya mîra, mulye ebihyâhya. ");
INSERT INTO shr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Natwa icumbi lyâni emwinyu na ntà mango na­nkaderha nti mwamanshologorha. ");
INSERT INTO shr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nakaz’igenda ekarhî kinyu, na mbè Nyamuzinda winyu, ninyu mubè lubaga lwâni. ");
INSERT INTO shr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nie Nyakasane, Nyamuzinda winyu wammukûlaga omu cihugo c’e Mîsiri, nti murhenge omu bujà bwâyo. Nammutwîre ekoba zàli zimushwesire, mwagenda mwanegena. ");
INSERT INTO shr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ci akabà murhanyumvirhi, murhanashimbiri ago marhegeko goshi, n’erhi mwankagayaguza amarhegeko gâni, ");
INSERT INTO shr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","n’erhi omurhima gwinyu gwankashologorhwa n’engeso zâni, kurhume mubula kwashimba amarhegeko gâni, mugal’ivuna endagâno yâni, ");
INSERT INTO shr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","alagi oku nammujira nâni: nammuhiramwo ecôbà, mwafà n’ishushira, lyo libongereza amasù n’okuborobonja amagala. Mwakaz’irhwêra kubè kurhamira busha, bulya abashombanyi binyu bammulyabyo. ");
INSERT INTO shr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nammuyâsa obusù bwâni, munakaz’ihimwa n’abashombanyi binyu n’abammushomba babà bo bakammurhegeka, mugal’ikaz’iyaka n’obwo ntâye omurhezire. ");
INSERT INTO shr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Erhi ankabà enyuma zâbo murhacinyumvirhi, nanammuhana kali nda kalushile okwo erhi byâha binyu birhumire. ");
INSERT INTO shr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nammutwamwo omumino, nanajira amalunga ginyu gammuzidohere nka cûma, n’idaho lizibuhe nka marhale. ");
INSERT INTO shr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Emisî yinyu yanakaz’irhamira busha, n’obudaka bwinyu burhakaciyera emburho zâbo, n’emirhi y’ecihugo erhakaciyana amalehe gâyo. ");
INSERT INTO shr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Erhi mwankacîhamba mpu mwacînyishingika, mpu murhalonza kuyumva, nanammuhimbaguliza kali nda kulusha oku ebyâha binyu binali. ");
INSERT INTO shr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nanammulikira ebiryanyi byakaz’immulya abâna, bimalîre ebishwêkwa binyu bimmujire bantu ba mahungà, binarhume enjira zinyu zahâmba. ");
INSERT INTO shr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Erhi enyuma z’aho mwankabà murhacîhanwiri n’agôla mahane nammuha, n’erhi mwankanasêza okushingalala embere zâni n’iganzi linene, ");
INSERT INTO shr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","buzinda nâni nanammugolonjoka, mmushûrhe kali nda kalushire erhi ebyôla byâha binyu birhuma. ");
INSERT INTO shr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nammurhogezakwo engôrho y’okucîhôlera endagâno yâni, mwacîlundika omu bishagala binyu, nangal’immurhumira ecihûsi ekarhî kinyu, mugali­hwera omu maboko g’abashombanyi. ");
INSERT INTO shr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Go mango nammunyaga omugati mulamirakwo, mwabona oku bakazi ikumi bakaz’idugira omugati masiga maguma, banakola bakâgera obuzirho bwâgwo, mukola mwakaz’ilya murhanaciyigurha. ");
INSERT INTO shr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","N’akabà kandi enyuma z’okola murhayumvîrhi, ci mushub’iyûshûla okugera yinyu njira ");
INSERT INTO shr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","oburhè bwâni bwanammuyâkira lêro bwenêne kulusha, nnangal’imuhana kali nda kalushire erhi ebyôla byâha binyu birhumire. ");
INSERT INTO shr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mwanacîlya akarhabana n’akanyere. ");
INSERT INTO shr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nâshâbûla empêrero zinyu nyimânike oku ntondo, n’emilunga yinyu mwayûbakiraga izûba, nayivongola, n’ebiru­ nda binyu mbigalike oku birunda by’abôla bazimu binyu b’obusha, n’omûka gwâni gummukabekwo. ");
INSERT INTO shr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Engo zinyu naziyôsa bwâmwa, n’empêrero zinyu nazishandâza, ntakanaciyudûkirwa n’obuhumule bw’enshangi zinyu. ");
INSERT INTO shr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nâsherêza ecihugo cinyu, kulya kwarhuma abashombanyi binyu bazânwa, amango baciyûbakamwo. ");
INSERT INTO shr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ninyu namushandabanya omu mashanja, ngal’immuyômolera engôrho omu nyuma zinyu; ecihugo cinyu câhagulwa, n’engo zinyu ziyôrhe nkunûnû y’irungu. ");
INSERT INTO shr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Aho lyoki ecihugo cankuza ensiku za Sabato zâge, ecihugo casiha buzira kuhingwa, ago mango goshi mujir’ibêra omu cihugo c’abashombanyi binyu. Aho ecihugo canarhang’ihumûka, cinayukirize ezizira zâco. ");
INSERT INTO shr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Amango goshi, ecihugo ciri omu malibuko erhi kuhumûka cinadwîrhe cahûmûka, n’okwôla murhankakubwine omu zizira zinyu, amango mwanal’imuciyûbasiremwo. ");
INSERT INTO shr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Amahungâ gankasigalamwo, nagahira goshi ecôbà emurhima, omu cihugo c’abashombanyi binyu: omusâgasa gw’ehyâsi gwône gurhume bakûla omulindi, balindimuke nka abayâka engôrho, bajè bakulumba n’obwo ntâye obashimbire. ");
INSERT INTO shr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Baguma bakâcìhunika oku bâbo nka abayaka engôrho n’obwo ntâye obashimbire! Murhakaciderha mpu mwahaza embere z’abashombanyi binyu. ");
INSERT INTO shr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mwahwêra omu gandi mashanja, n’ecihugo c’abashombanyi binyu cammumirangusa. ");
INSERT INTO shr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Emisigala ya muli mwe, yahungumukira omu bihugo by’abashombanyi binyu erhi bubî bwâyo burhuma; ciru bahungumuka erhi mabî ga b’îshe garhuma nka kulya bônene bahungumukaga. ");
INSERT INTO shr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Lyoki bayish’ikacîyunjuza obubî bwa b’îshe wâbo n’obwabo bônene, muli okwo kungomera, ciru n’okucîhindula kuli nie ");
INSERT INTO shr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","kwo kwanarhuma nâni nacîhindulirabo, n’okubahêka omu cihugo c’abashombanyi bâbo. Erhiankaba ogwo murhima gwâbo muzibu nk’ibuye gurhahanagwa lêro nagwo gwanacîrhôhya, nâni nanashub’ikengêra endagâno yâni na Yakôbo. ");
INSERT INTO shr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Nanashub’ikengêra oku nalaganyagya Izaki, n’okunalaganyagya Abrahamu, kunashub’inkengêza cirya cihugo nabalaganyagya. ");
INSERT INTO shr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ecihugo barhenzibagwamwo, lêro naco cabà n’ezizira za Sabato waco. Bulya cakaz’ihagulwa, banayêmêra obuhane bw’amabî gâbo, bulya bali bagayaguzize amarhegeko gâni, n’omurhima gwâbo gwàli gushologosirwe n’amarhegeko gâni. ");
INSERT INTO shr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Cikwône arhali hoshi aho: amango babà bakola bali omu cihugo c’abashombanyi bâbo, ntabakabulire lwoshi, barhananshologose mpu kuhika mbaherêrekeze, mpu kurhume nayîrha eciragâne najiraga nabo, bulya nie Nyakasane, Nyamuzinda wâbo. ");
INSERT INTO shr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nanashub’ikengêra amalaganyo najiraga haguma na bashakulûza bâbo erhi bo barhumire, balya narhenzagya omu cihugo c’e Mîsiri, erhi n’amashanja gadwîrhe gabona nti mbè nie Nyakasane wâbo. ");
INSERT INTO shr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yo mihigo eyo, go marhegeko ago, lwo lushika olwo Nyamuzinda ajiraga ekarhî kâge na bene Israheli oku ntondo ya Sînayi, arhuma Mûsa mpu aj’ibabwîrago. ");
INSERT INTO shr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Ogend’idôsa Bene Israheli obabwîre oku: Erhi hankabà owalonza okuyûkiriza eciragâne câge emwa Nyamuzinda omu kushiga ebyankafa omuntu, alagi oku agwâsirwe okujira: ");
INSERT INTO shr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ecitwîro c’omulume w’emyâka makumi abirhi kuhika oku gali ndarhu, ali wa kugererwa oku sikêli makumi arhanu, co citwîro c’esikeli (ntûlo) y’aka-Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Akabà ali mukazi, anagererwa oku sikêli makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Akabà murhabana: kurhenga oku myâka isharhu kuhika oku myâka makumi abirhi anagererwa oku sikêli makumi abirhi, omunyere anagererwa oku sikêli ikumi. ");
INSERT INTO shr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kurhenga mwêzi muguma kuhika myâka irhanu, engombôlo y’omwânarhabana, olugero lwanabà lwa sikêli irhanu, n’okugombôla o­mwânanyere, olugero sikêli isharhu. ");
INSERT INTO shr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kurhenga myâka makumi gali ndarhu kujà enyanya, olugero lwâwe lubè lwa sikêli ikumi n’irhanu oku mulume na sikêli ikumi oku mukazi. ");
INSERT INTO shr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Erhi olya wahânaga eciragâne ankabamukenyi, olya orhankahika oku lugero lw’okugombôla, kukwânîne alêrhere omudâhwa olya muntu ashîgaga ye wahûna olugero. Omudâhwa analujira kushimbana n’ebi o­lya wajiraga eciragâne ankabona. ");
INSERT INTO shr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Erhi nyakuhiga ankalagâna cintu cilebe mwa birya barherekêra Nyakasane, ngasi cîntu bankanarhûla Nyakasane cinahinduke cintu cimâna. ");
INSERT INTO shr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Barhankacihasha okucihingûla, barhankahingana ecibî oku cinjà erhi ecinjà oku cibî. Erhi bankahinganula ecintu oku cindi, byombi byombi erhi bikola bimâna. ");
INSERT INTO shr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Erhi ankabà cintu ciguma ca mwa birya bizira, birhankarherekêrwa Nyakasane, eco cintu banacimoleka omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Naye omudâhwa anahâna olugero lwâco, kushimbana n’oku ciri cinjà erhi cibî, kandi banakulikira olwo lugero luhânyirwe n’omudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ci erhi bankalonza okucigombôla, banayûshûla ecigabi ca karhanu oku lugero cikwânîne. ");
INSERT INTO shr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Erhi hankajira owalagâna enyumpa nterekêro emwa Nyakasane, omudâhwa anagend’ilola erhi eri nyinjà nîsi erhi mbî, kandi banashimba olugero lw’ecicîro omudâhwa asîmire. ");
INSERT INTO shr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ci erhi olya wahânaga enyumpa yâge ciragâne ankalonza okuyigombôla, anayûshûla ecigabi ca karhanu oku Lugero omudâhwa ahûnaga, lyoki yankayôrha yâge. ");
INSERT INTO shr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Erhi hankajira owarherekêra Nyakasane ecihimbi c’ishwa lyâge yêne, wanarhôla olugero lwâwe omu kulola mburho nyinganaci wankarhwera muli lirya ishwa: sikêli makumi arhanu z’amarhale kuli nyamâha muguma w’emburho y’engano. ");
INSERT INTO shr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Erhi ankabà muli omu mwâka gw’okushagaluka, mwo ahânyire i­shwa lyâge nterekêro, anakulikira olugero lwâwe. ");
INSERT INTO shr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ci kwônene erhi yankaba eri enyuma ly’omwâka gw’okushagaluka, lyo arherekîre ishwa lyâge, omudâhwa anatwa engulo omu kuganja emyâka ecisigîre, kuhika oku gundi mwâka gw’okucîshinga, na ntyo cirya citwîro canashubwakwo. ");
INSERT INTO shr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Erhi olya warherekêraga ishwa lyâge ankalonza okuligombôla, anayûshûla ecigabi ca karhanu oku citwîro, na ntyo ishwa lyanayôrha lyâge. ");
INSERT INTO shr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Erhi ankabà arhagômbwîri ishwa lyâge, abul’iliguliza owundi muntu, eryo ishwa lirhankacigombôlwa. ");
INSERT INTO shr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","N’amango lyabà lirhacishwesirwi na cici, oku mwâka gw’okushagaluka, eryo ishwa lyanayôrha lirherekêre emwa Nyakasane, likola ishwa lyahânagwa ciragâne, lyanabà lya mudâhwa. ");
INSERT INTO shr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Erhi hankajira owarherekêra Nyakasane ishwa ahâbagwa cikinja, ci lirhali lyâge lwoshi, ");
INSERT INTO shr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","omudâhwa anagend’ilola eryo ishwa, analijirire ecitwîro kushimbana n’amango gasigîre kuhika omu mwâka gw’okushagaluka. Oyo muntu anajuha olwo lusiku lwo na nnênè engulo batwa nka kantu karherekîrwe Nyakasane ");
INSERT INTO shr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Omu mwâka gw’okushagaluka eryo ishwa lyanashub’ibà ly’olya waliguzagya, ye olya wanali nnalyo lwoshi. ");
INSERT INTO shr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ecicîro câwe coshi wakaz’icigerera oku sikêli y’aka-Nyamuzinda: ebà sikêli yankagererwa oku makumi abirhi. ");
INSERT INTO shr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ci ntâye wankajira eciragâne c’ecintu mburhwa-lubere lw’omu bishwe­kwa byâge, bulya ebyo nka mburhwa-lubere, bikola biyôsire biri birherekêre Nyamuzinda, ebè nkâfu, cibè cibuzi byoshi biyôsire biri bya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Erhi cankaba cintu cizira, banacigombôla oku ngulo obatwîrîre, n’okuyûshûla kwo ecigabi ca karhanu, n’erhi cankaba cirhagombwirwi, banaciguze oku ngulo wacitwiraga. ");
INSERT INTO shr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ntâco omu bintu omuntu arhûzire Nyamuzinda lwoshi n’endahiro, abè muntu, cibè cintu, erhi ishwa by’omu buhiri bwâge ankahash’iderha mpu aguza erhi kugombôla, bulya ngasi kantu omuntu acìlahiriza oku akarhuzire Nyamuzinda n’endahiro bwenêne, kakola ka Nyakasane. ");
INSERT INTO shr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ntà muntu warherekîrwe Nyakasane wankacigombôlwa: Banamuyîrhe erhi kwo. ");
INSERT INTO shr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ngasi entûlo erhenga oku mburho y’okurhwêra ekuzimu, ebè y’oku malehe g’emirhi yoshi eri ya Nyakasane, buli buhirhi bwarherekîrwe Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Erhi hankajira owalonza okugombôla kantu kalebe k’oku ntûlo yâge, anayûshûlekwo ecigabi ca karhanu. ");
INSERT INTO shr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Oku biyêrekîre entûlo z’ebishwêkwa binene erhi binyinyi, ngasi hyoshi hihugwa n’akarhi k’omungere, ecigabi ca kali ikumi cakaz’irherekêrwa Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Barhalondôlaga mpu eci cintu co cinjà, nîsi erhi co cibî, barhanahîraga bacîshomya mpu bahinganula, n’erhi bakahinganula, byombi na byombi ebyahinganulagwa bikola bintu bimâna, birhankanahash’igombôlwa. ");
INSERT INTO shr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Gwo marhegeko Nyakasane ahâga Mûsa oku ntondo ya Sînayi Bene Israheli barhumire.");
INSERT INTO shr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nyakasane ashambâla na Mûsa omw’irungu lya Sînayi, omw’Ihêma ly’embugânano, omu lusiku lurhanzi lw’omwêzi gwa kabirhi, omu mwakagwa kabirhi kurhenga barhenzire e Mîsiri. Anacimubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Ojire omubalè gwa bene Israheli boshi, omu kukulikira emilala yâbo nk’oku bashakulûza bâbo banagenda; ojè waganja ngasi mulume, ");
INSERT INTO shr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","“kurhenga oku ogwêrhe myâka makumi abirhi ali muburhe, kuhêka enyanya, balya balume boshi bankajâga oku matabâro omu bene Israheli; obaganje omu kukulikira emirhwe yâbo we na Aroni”, ");
INSERT INTO shr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","“Warhabâlwa na mushamuka muguma w’omu ngasi mulala, Olya onali mukulu na cisiki ca bashakulûza wâbo”». ");
INSERT INTO shr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Alaga amazîno g’abakurhabâla: kuli bene Rubeni, ali Elisuri mwene Sedeuri, ­ ");
INSERT INTO shr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Kuli bene Simoni, ali Shelumieli, mwene Surishadayi, ");
INSERT INTO shr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Kuli bene Yûda, ali Nashoni, mwene Aminadabu, ");
INSERT INTO shr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Kuli bene Isakari, ali Natanaeli, mwene Suari, ");
INSERT INTO shr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Kuli bene Zabuloni, ali Eliabu, mwene Heloni. ");
INSERT INTO shr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Kuli bene Yozefu: kuli Efrayimu, ali Elishamaʿ, mwene Amihudi; kuli Menashè, ali Gamalieli, mwene Pedasuri. ");
INSERT INTO shr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Kuli bene Benyamini, ali Abidani, mwene Gedeoni. ");
INSERT INTO shr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Kuli bene Dani, ali Ahiyezeri, mwene Amishadayi. ");
INSERT INTO shr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Kuli bene Aseri, ali Pagieli, mwene Okrani. ");
INSERT INTO shr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Kuli bene Gadi, ali Eliasafu mwene Dueli. ");
INSERT INTO shr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Kuli bene Nefutali, ali Ahira, mwene Enani. ");
INSERT INTO shr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Bo bacîshozirwe omu ndêko abôla, bali barhambo b’emilala ya b’îshe wâbo; bali barhambo b’ebihumbi omu bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mûsa na Aroni erhi babà bamârhôla abôla balume, bamanyisibagwa ngasi muguma oku izîno lyâge, ");
INSERT INTO shr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","banacilâlika endêko yoshi omu mbugânano, omu lusiku lurhanzi lw’omwêzi gwa kabirhi, banaciyandikwa ngasi baguma omu kushimba emilala yâbo, omu kushimba enyumpa za bashakulûza wâbo, ajà abaganja amazîno, lyo n’irhwe lya ngasi muguma, kurhenga myâka makumi abirhi, kuhêka enyanya. ");
INSERT INTO shr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Nk’oku Nyakasane amurhegekega, Mûsa ajira omubalè gwâbo ntyo, oku ntondo ya Sînayi. ");
INSERT INTO shr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Bene Rubeni, kulya banalondana, n’oku emilala yâbo enakulikirîne, omu kushimba enyumpa za bashakulûza wâbo, kandi omu kuganja ngasi irhwe na ngasi izîno omu balume ba myâka makumi abirhi kuhêka enyanya, na ngasi boshi bankahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Abaganjirwe omu bûko bwa Rubeni, bayimanga bantu bihumbi makumi anni na ndarhu na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Bene Simoni kulya banalondana, na kulya emilala yâbo enakulikirana, omu kushimba enyumpa za bashakulûza wâbo; abaganjîrwe amazîno na ngasi irhwe, omu balume banalikola bagwêrhe myâka makumi abirhi na kuhêka enyanya, ngasi boshi bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Abaganjirwe omu bûko bwa Simoni, bayimanga bantu bihumbi makumi arhanu na mwenda na magana asharhu. ");
INSERT INTO shr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Bene Gadi, kulya banalondana na kulya emilala yâbo enakulikirana, omu kushimba enyumpa za bashakulûza bâbo, abaganjirwe amazîno na ngasi irhwe, omu balume banalikola bagwêrhe myâka makumi abirhi na kuhêka enyanya ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Abaganjirweomu bûko bwa Gadi, bayimanga bantu bihumbi makumi anni na birhanu na magana gali ndarhu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Bene Yûda, kulya banalondana na kulya emilala yâbo enakulikirana, omu kushimba enyumpa za bashakulûza bâbo, abaganjirwe amazîno na ngasi irhwe, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahekaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Abaganjirwe omu bûko bwa Yûda bahika omu bantu bihumbi makumi gali nda na bini na magana gali ndarhu. ");
INSERT INTO shr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Bene Isakari, oku balondana n’oku emilala yâbo enakulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Abaganjirwe omu bûko bwa Isakari bahika omu bantu bihumbi makumi arhanu na hîni na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Bene Zabuloni, oku balondana n’oku emilala yâbo ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Abaganjirwe omu bûko bwa Zabuloni, bahika omu bantu bihumbi makumi arhanu na nda na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Bene Yozefu, Bene Efrayimu, oku balondana n’oku emilala yâbo ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma kurhenga oku muntu wa myâka makumi abirhi kujà enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Abaganjirwe omu bûko bwa Efrayimu, bahika omu bantu bihumbi makumi anni na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Bene Menashè, oku balondana n’oku emilala yâbo ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Abaganjirwe omu bûko bwa Menashè, bahika omu hantu bihumbi makumi asharhu na bibirhi na magana abirhi. ");
INSERT INTO shr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Bene Benyamini oku balondana n’oku emilala yâbo ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Abaganjirwe omu bûko bwa Benyamini, bahika omu bantu bihumbi makumi asharhu na birhanu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Bene Dani, oku balondana n’oku emilala yaho ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Abaganjirwe omu bûko bwa Dani, bahika omu bantu bihumbi makumi gali ndarhu na bibirhi na magana nda. ");
INSERT INTO shr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Bene Aseri, oku balondana n’oku emilala yaho ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Abaganjirwe omu bûko bwa Aseri, bahika omu bantu bihumbi makumi anni na ciguma na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Bene Nefutali, oku balondana n’oku emilala yâbo ekulikirana, omu kushimba enyumpa za bashakulûza bâbo, omu kuganja amazîno n’irhwe lya ngasi muguma, kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume bankanahêkaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Abaganjirwe omu bûko bwa Nefutali, bahika omu bantu bihumbi makumi arhanu na bisharhu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Bo baganjirwe abôla, bo Mûsa n’Aroni baganjaga abôla, boshi na balya baluzi ikumi na babirhi ba bene Israheli: muntu muguma muguma oku emilala yâbo enali. ");
INSERT INTO shr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bene Israheli bàganjirwe boshi, omu kukulikira emilala ya bashakulûza bâbo na kurhenga oku muntu wa myâka makumi abirhi kuhêka enyanya, ngasi balume ba bene Israheli bankanahekaga emirasano. ");
INSERT INTO shr_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Abaganjirwe boshi, omubalè gwâbo gwahika omu bantu bihumbi magana gali ndarhu na bisharhu na magana arhanu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Bene Levi, oku milala yâbo ekulikirana, abôla barhaganjiragwa haguma n’abâbo. ");
INSERT INTO shr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Nyakasane anacishambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Orhajiraga omubalè gwa bene Levi, orhanabaganjiraga haguma n’abandi bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","“Ohè bene Levi ecikono c’okukazilanga omucîmba gw’amalaganyo, ebirugu byâgwo na ngasi bindi binabamwo byoshi. Bo bakazihêka ogwôla Mucimha n’ebirugu byamwo byoshi; bo bakazikola muligwo, banakazihanda eburhambi bw’ogwôla Mucimba”. ");
INSERT INTO shr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","“Amango omucîmba gukola gwagenda, bene Levi bo bakazigugwikûla, n’amango gwamahanda, kandi bene Levi bo bakazigugwika, na owundi muntu orhali mwene Levi erhi ankaderha mpu agulirâna, anafè”. ");
INSERT INTO shr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","“Bene Israheli bakazihanda ngasi baguma omu cihando câbo, hôfi n’ibendêra lyâbo, na nk’oku emirhwe yâbo y’abalwî enali”. ");
INSERT INTO shr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","“Ci bene Levi bakazihanda hôfi n’omucîmba gw’Amalaganyo, lyo oburhè bulekija oku lubaga lwa bene Israheli, bene Levi bo bakazilanga omucîmba gw’Amalaganyo”». ");
INSERT INTO shr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Bene Israheli banacijira nk’oku Nyakasane àli arhegesire Mûsa koshi. Bajira ntyo. ");
INSERT INTO shr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nyakasane anacishambâla na Mûsa na Aroni, ababwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Bene Israheli ngasi baguma oku cihando banakazija ah’ibendêra lyâbo liri, ngasi mulala gwanakaziba n’ecimanyîso câgwo n’abà gulya mulala banacikulikira. Omu kuhanda bakazilola ngasi baguma ebw’ihêma ly’embugânano, bakaziliyûbaka eburhambi, balizongoloke». ");
INSERT INTO shr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Bene Yûda bahanda ebuzûka-zûba boshi n’engabo yâbo y’abalwî. Omurhambo wa bene Yûda ye Nashoni, mwene Aminadabu. ");
INSERT INTO shr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Engabo y’abalwî bâge omu kulola balya bajiriragwa omubalè, bali bihumbi makumi gali nda na bini na magana gali ndarhu. ");
INSERT INTO shr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Omulala gwa Isakari gumukulikire, omurhambo wa bene Isakariye Natanaeli mwene Suari. ");
INSERT INTO shr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Engabo y’abalwî bâge omu kulola balya bajiriragwa omubalè, bali bihumbi makumi arhanu na bini na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Bakuhîre bene Zabuloni. Omurhambo wa bene Zabuloni ye Eliyabu mwene Heloni. ");
INSERT INTO shr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Engabo y’abalwî bâge omu kulola balya bajiriragwa omubalè, bali bihumbi makumi arhanu na nda na bantu magana gali nda. ");
INSERT INTO shr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Boshi abâli oku cihando ca Yûda, omubalè gwâbo bihumbi igana na makumi gali munâni na ndarhu na bantu magana anni. Abôla bakazigenda embere. ");
INSERT INTO shr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Bene Rubeni banahanda emukondwè, n’engabo yâbo y’abalwî; Omurhambo wa bene Rubeni ye Elisuri mwene Sedeuri. ");
INSERT INTO shr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Engabo y’abalwî bâge omu kulola balya bajiriragwa omubalè, bali bihumbi makumi anni na ndarhu na bantu magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Bene Simoni bahanda eburhambi bwâge. Omurhambo wa bene Simoni ye Shelumiyeli, mwene Surishadayi. ");
INSERT INTO shr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Engabo y’abalwî bâge, omu kulola balya bajiriragwa omubalè, bali bihumbi makumi arhanu na mwenda na bantu magana asharhu. ");
INSERT INTO shr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Bene Gadi bakulikîre. Omurhambo wa bene Gadi ye Eliasafi mwene Reweli. ");
INSERT INTO shr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Engabo y’abalwî bâge omu kulola balya bajiriragwa omubalè, bali bihumbi makumi anni na birhanu na bantu magana gali ndarhu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Boshi abâli oku cihando ca Rubeni, omubalè gwâbo: bihumbi igana na makumi arhanu na ciguma na bantu magana anni na makumi arhanu. Abôla bakazigenda bwa kabirhi. ");
INSERT INTO shr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kandi ihêma ly’e­ mbugânano lyanakulikira, na bene Levi banajà ekarhî k’ebindi bihando. Okwola bahanda kwo banakazikulikirana bakola bagenda, ngasi baguma oku mulongo gwâbo n’ibendêra lyâbo. ");
INSERT INTO shr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ebuzika-zûba eje ibendêra ly’Efrayimu n’engabo yâge. Omurhambo wa­ bo ye Elishamaʿ mwene Amiyudi. ");
INSERT INTO shr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Omurhwe gwâge nk’oku omubalè gwâbo gunali: bantu bihumbi makumi anni na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Omulala gwa Menashè gubaje eburhambi. Omurhambo wâbo ye Gamalieli mwene Pedasuri. ");
INSERT INTO shr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Omurhwe gwâge nk’oku omubalè gwâbo gunali: bantu bihumbi makumi asharhu na bihirhi na magana abirhi. ");
INSERT INTO shr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Bene Benyamini bakuhebe. Omurhambo wa bene Benyamini ye Abidani mugala wa Gedeoni. ");
INSERT INTO shr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Omurhwe gwâge nk’oku omubalè gwâbo gunali: bantu bihumbi makumi asharhu na birhanu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Boshi abâli oku cihando ca Efrayimu, omubalè gwâbo bihumbi igana na munâni na bantu igana, nk’oku emirhwe yâbo enali. Abôla bakazigenda ba kasharhu. ");
INSERT INTO shr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Emwênè eje ibendêra lya Dani n’engabo yâge. Omurhambo wâbo ye Ahiyezeri mugala wa Amishadayi. ");
INSERT INTO shr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","N’omurhwe gwâge nk’oku omubalè gunali: bantu bihumbi makumi gali ndarhu na bibirhi na magana gali nda. ");
INSERT INTO shr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Omulala gw’Aseri gumuje eburhambi, omurhambo wa bene Aseri ye Pagieli, mwene Okrani. ");
INSERT INTO shr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Omurhwe gwâge nk’oku omubalè gunali: bantu bihumbi makumi anni na ciguma na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kandi bene Nefutali bakulikîre. Omurhambo wa bene Nefutali ye Ahira mwene Enani. ");
INSERT INTO shr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Omurhwe gwâge nk’oku omubalè gwâbo gunali: bantu bihumbi makumi arhanu na bisharhu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Boshi abaganjirwe omu cihando ca Dani, omubalè gwâbo bali bihumbi igana na makumi arhanu na nda na magana gali ndarhu. Bakazigenda ba buzinda, banakulikire ibendêra lyâbo. ");
INSERT INTO shr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Gwo mubalè gwa bene Israheli ogwôla, omu kukulikira emilala ya bashakulûza bâbo. Omubalè gw’abaganjirwe boshi nk’oku emirhwe yâbo enali, bali bantu bihumbi magana gali ndarhu na bisharhu na magana arhanu na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Bene Levi barhaganjiragwa muli eyôla mirhwe ya bene Israheli, nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Bene Israheli banacijira nk’oku Nyakasane anali arhegesire Mûsa koshi. Kwo bakazâgihanda ntyo ngasi baguma n’ibendêra lyâbo, kwo banakazâgigenda ntyôla, ngasi baguma omu mulala gwâbo omu kukulikira emilala ya bashakulûza bâbo. ");
INSERT INTO shr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Alaga obûko bw’Aroni n’obwa Mûsa amango Nyakasane ashambâzagya Mûsa oku ntondo ya Sînayi. ");
INSERT INTO shr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Alaga amazîno ga bene Aroni: Nadabu lwo lubere lwâge, Abihu, Eleazari na Itamara. ");
INSERT INTO shr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Go mazîno ga bene Aroni agôla, bo babumbagwa amaboko mavurha lyo bahâbwa ecikono c’obudâhwa. ");
INSERT INTO shr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadabu n’Abihu bo bafiraga embere za Nyakasane, amango bacishomagya mpu barherekêra Nyakasane enshangi erhakwânîni oku ntondo ya Sînayi; barhàli baciburha bâna. Eleazari na Itamara bahâbwa obudâhwa embere z’Aroni, îshe wâbo. ");
INSERT INTO shr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nyakasane ashambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Yegeza bene Levi ahâla, obahire embere z’omudâhwa Aroni, bakazimukolera. ");
INSERT INTO shr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bo bakazijira emikolo Aroni n’olubaga bagwâsirwe okujira ah’ihêma ly’embugânano na ntyo banakazijira emikolo y’omu Mucîmba. ");
INSERT INTO shr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bakazikombêra ebirugu byoshi by’omu ihêma ly’embugânano na ngasi hindi hyoshi bene Israheli bagwâsirwe okujira omu Mucîmba. ");
INSERT INTO shr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Abaleviti obahè Aroni n’abagala. Babè bâge loshi omu bene Israheli boshi. ");
INSERT INTO shr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Wayîmika Aroni n’abagala omu mikolo y’obudâhwa; owundi w’embuga wankacîshomya mpu ayêgera ahantu himâna anahâbwe obuhane bw’okufà.» ");
INSERT INTO shr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Nyakasane anacishambâla bona Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Lolà oku bene Levi mbayansire omu karhî ka bene Israheli, ahâli h’abâna b’enfula, balya bâna b’olubere ba bene Israheli; abôla Baleviti babà ntyo bâni. ");
INSERT INTO shr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Bulya ngasi wa lubere yêshi erhi anali wâni: lulya lusiku nahungumulagamwo ngasi wa bûko lubere omu Mîsiri go mango nacîhâga ngasi wa bûko lubere omu Israheli: abè wa muntu, abè wa cintu, byoshi bikola bibà byâni. Nie Nyakasane.» ");
INSERT INTO shr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nyakasane ashambâla na Mûsa omu irungu ly’entondo ya Sînayi amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Ojire omubalè gwa bene Levi nk’oku emilala ya bashakulûza bâbo enagenzire na nk’oku emilala yâbo bône enali. Ojire omubalè gwa ngasi wa bûko mulume yêshi kurhenga oku mwâna wa mwêzi muguma kuhêka enyanya.» ");
INSERT INTO shr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mûsa ajira omubalè gwâbo oku irhegeko lya Nyakasane, nk’oku anamurhegekaga. ");
INSERT INTO shr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Alaga bene Levi nk’oku amazîno gâbo ganali: Gershoni, Kehati na Merari. ");
INSERT INTO shr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Alaga amazîno ga bene Gershoni nk’oku emilala yâbo enali: Libni na Shimeyi. ");
INSERT INTO shr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Bene Kehati nk’oku emilala yâbo enali: Amrami, Yisari, Hebroni na Uzieli. ");
INSERT INTO shr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Bene Merari, nk’oku emilala yâbo enali: Mahali na Mushi. Bwo bûko bwa Levi obwôla nk’oku emilala ya bashakulûza bâbo enagenzire. ");
INSERT INTO shr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershoni ye shakulu w’omulala gwa Libni Shimeyi. Baderha mpu milala ya Banya-Gershoni. ");
INSERT INTO shr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Omubalè gwâbo omu kuganja abalume boshi kurhenga owa mwêzi muguma kuhêka enyanya, bahika omu bantu bihumbi nda na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Emilala y’Abanya-Gershoni yakazâgihanda enyuma ly’Omucîmba olunda lw’ebuzika-zûba. ");
INSERT INTO shr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Omurhambo w’omulala gw’Abanya-Gershoni ye wali Eliyasafu, mwene Layeli. ");
INSERT INTO shr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Oku biyêrekîre ihêma ly’embugânano, bene Gershoni bàli bagwêrhe omukolo gw’Omucîmba n’ogw’ihêma, ogw’enshoho yalyo, akacikirizo kàli aha muhango gw’ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Bàlibagwêrhe omukolo gw’oku birhebo by’omu bululi, oku mushangi gw’aha muhango gw’obululi, oku burhambi bw’Omucîmba koshi n’oku luhêrero n’oku migozi yalo yoshi. ");
INSERT INTO shr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Bene Kehati bàli: omulala gw’Abanyamrami, omulala gw’Abayesehari, omulala gw’Abahebroni n’omulala gw’Abaaziyeli. Yo milala ya bene Kehati eyôla. ");
INSERT INTO shr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Omu kuganja abalume boshi kurhenga owa mwêzi muguma kujà enyanya, bahika omu bantu bihumbi munâni na magana gali ndarhu; omukolo gwâbo kulanga Ahatagatîfu. ");
INSERT INTO shr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Emilala ya bene Kehati yakazâgihanda olunda lw’emukondwè gw’Omucîmba. ");
INSERT INTO shr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Omurhambo w’emilala ya bene Kehati ye wali Elisafani, mwene Uzieli. ");
INSERT INTO shr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Bo balibagwâsirwe okukazikola oku Mucîmba gw’amalaganyo, oku luhêrero lw’enterekêro, okw’itara n’oku zindi mpêrero zoshi, oku rhundi rhulugu rhw’ahatagatîfu rhulya rhunakolamwo rhwoshi, omwenda na ngasi binaguyêrekera byoshi. ");
INSERT INTO shr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Omurhamho w’abarhambo b’abaleviti ye wali Eleazari mwene omudâhwa Aroni, ye wakazagiyimangira abàli bagwêrhe emikolo y’Ahimâma. ");
INSERT INTO shr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Bene Merari bàli: emilala y’abanya-Mahali, n’emilala ya bene Mushi: yo milala ya bene Merari eyôla. ");
INSERT INTO shr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Omubalè gwâbo kurhenga oku mwâna-rhabana wa mwêzi muguma kuhêka enyanya bali bihumbi ndarhu na magana abirhi. ");
INSERT INTO shr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Omurhambo w’emilala ya bene Merari ye wali Surieli, mwene Abihayili. Bakazâgihanda olunda lw’emwênè y’Omucîmba. ");
INSERT INTO shr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Abanyamerari bo bakazikola oku lukanga lw’Endâro, emirhamba n’emitungo yayo, kuguma n’emifûniko y’amarhwerhwe na ngasi rhulugu rhwa kuli eyôla ndâro, ");
INSERT INTO shr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","emitungo y’omu marhambi goshi goshi g’obululi, amarhwerhwe gâyo n’emigozi yago. ");
INSERT INTO shr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aha mbêre z’Endâro, olunda lw’ebuzûka-zûba, embere z’ihêma ly’embugânano, yo Mûsa n’Aroni n’abagala hahandaga; bali bagwêrhe omukolo gw’okulanga ahimâna, oku mikolo yanalieyêrekîre bene Israheli. Owundi w’embuga wankadesire mpu ayegere ahôla aliagwâsirwe ahâbwe obuhane bw’okufà. ");
INSERT INTO shr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Bene Levi baganjagwa na Mûsa haguma n’Aroni oku irhegeko lya Nyakasane, omu kukulikira emilala yâbo, n’omu kuganja abalume kurhenga oku mwânarhabana wa mwêzi muguma kuhêka enyanya, bali bihumbi makumi abirhi na bibirhi. ");
INSERT INTO shr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Nyakasane anacibwîra Mûsa, erhi: «Ojire omubalè gwa ngasi lubere lwa mwânarhabana omu Israheli, kurhenga oku wa mwêzi muguma kuhêka enyanya, obaganje ngasi muntu n’izîno lyâge. ");
INSERT INTO shr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Orhôle Abaleviti babè bâni, nie Nyakasane, ahâli h’abâna baburhwambere boshi ba bene Israheli; ebishwêkwa by’Abaleviti ahâli h’ebishwêkwa biburhwa-mbêre bya bene Israheli.» ");
INSERT INTO shr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mûsa ajira omubalè gw’abâna b’olubere boshi b’omu Israheli, nk’oku Nyakasane anamurhegekaga. ");
INSERT INTO shr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Abânarhabana b’olubere baganjirwe ngasi maguma n’izîno lyâge kurhenga oku mwâna wa mwêzi muguma kuhêka enyanya, bahika omu bihumbi makumi abirhi na bibirhi na magana abirhi na makumi gali nda na basharhu. ");
INSERT INTO shr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Orhôle bene Levi ahâli h’abâna b’olubere ba bene Israheli, n’ebishwêkwa bya bene Levi ahâli h’ebishwêkwa byâbo. Bene Levi babà bâni niene. Nie Nyakasane. ");
INSERT INTO shr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Omu kugombôlabalya magana abirhi na makumi gali nda na basharhu balushire omubalè gwa bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Orhôle sikêli irhanu oku ngasi irhwe lya muntu, wakaziyigerera oku sikêli omu ka-Nyamuzinda, eri ya gêra makumi abirhi. ");
INSERT INTO shr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ezôla nfaranga ozihe Aroni n’abagala, ziri za kugombôla balya barhalusire omubalè gwa bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mûsa arhôla zirya nfaranga zagombôlaga balya b’olubere bagombôlagwa na bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Arhôla enfaranga z’oku bâna b’olubere ba bene Israheli, zàli cihumbi na magana asharhu na sikêli makumi galindarhu n’irhanu, omu kukulikira erya sikêli y’omu ka-Nyamuzinda. ");
INSERT INTO shr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mûsa anacihà Aroni n’abagala zirya nfaranga z’okugombôla, okw’irhegeko lya Nyakasane nk’oku Nyakasane anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nyakasane anacishambâza Mûsa n’Aroni ederha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Oganje bene Kehati omu bene Levi, obaganje nk’oku emilala yâbo n’obûko bwâbo bikulikirine, oku bashakulûza bâbo banali, ");
INSERT INTO shr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kurhenga owa myâka makumi asharhu kuhêke enyanya oku myâka makumi arhanu, ngasi boshi banajira omukolo omw’ihêma ly’embugânano omu kujiramwo bushanja bulebe, omwôla ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Alaga omukolo gwa bene Kehati omw’ihêma ly’embugânano: kwabà kukola oku bintu bimâna bwenêne. ");
INSERT INTO shr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Nka bakola barhenga oku cihando, Aroni haguma n’abagala banayisha bayandagaze omwenda, banafunikamwo omucîmba gw’amalaganyo. ");
INSERT INTO shr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Oku nyanya, banabwikira kwo n’omufûniko gw’oluhù lw’ecigoho, kandi banalambûlirakwo omushangi mugumagumà gwa kaduku ka mukara, kandi banashesheza emirhamba y’Omucîmba. ");
INSERT INTO shr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Banalambûlira omushangi gw’akaduku oku mêza g’emigati y’enterekêro. Oku nyanya banahirakwo enambi, orhubêhè, engombo, ebikombe by’okukalabira; n’omugati gwa ngasi mango gwanaja oku nyanya lyâgo. ");
INSERT INTO shr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Oku nyanya banalambûlirakwo omushangi gw’akalinga konene, kandi banafunikira n’ecifûniko c’oluhù lw’ecigoho, na buzinda bw’ahôla banashesheza emirhamba y’ameza. ");
INSERT INTO shr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Banarhôla omushangi gw’akaduku k’omukara banabwîkiramwo ecinâra, kuguma n’amatara gâco, orhusahani rhwâco, orhulugu rhw’okugukira oluvù, enjebe zâco, birya by’obulagîrire oku mukolo gwâco, ");
INSERT INTO shr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Hano babà bamaboha ecôla cinâra, kuguma n’orhumole rhwâco, banacihira oku luhù luvunge lulukire oku mirhamba y’okubarhulira. ");
INSERT INTO shr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Banalambûlira omushangi gw’akaduku k’omukara oku luhêrero lw’amasholo, kandi banabwikira n’ecifûniko c’oluhù lw’ecigoho, banashesheza n’emirhamba. ");
INSERT INTO shr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Banarhôla ebirugu byoshi bikolêsibwa oku mikolo y’ahantu himâna, hano babà bamabiboha omu mushangi gw’akaduku k’omukara, banabibwîkira n’omufûniko gw’oluhù lw’ecigoho, kandi banabihira oku cibarhuliro. ");
INSERT INTO shr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Banarhenza oluvù oku luhêrero, kandi banalambûlirakwo omushangi gw’akalinga. ");
INSERT INTO shr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Banahira oku nyanya birya birugu binakola kuli lwo byoshi, ebitumbûkizo amakala, amakanya, empaho, enyôgero, ebirugu byoshi by’oku luhêrero na hano babà bamalambûlira kuli byo byoshi omufûniko gw’oluhù lw’ecigoho, banahirakwo emirhamba. ");
INSERT INTO shr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Hano Aroni n’abagala bayûsa okubwîkira ahimâna n’ebirugu byamwo byoshi, na hano babà bamayimuka bakola bagenda, bene Kehati banayisha okubibarhula, ci barhahumaga oku bintu bimâna lyo balekifià. Byo bene Kehati bakazihêka ebyo omw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazari, mwene Aroni, omudâhwa, âbà n’omukolo gw’okukazilanga amavurha g’ecinâra, obukù bw’akisûnunu kinjà, eby’enterekêro ya ngasi mango, n’amavurha g’okushîga. Abà n’omukolo gw’okukazilanga Endâro yoshi, n’ebibâmwo byoshi, omu bimâna n’ebirugu byamwo.» ");
INSERT INTO shr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Nyakasane ashambâla na Mûsa n’Aroni, aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Oshîbirire okuhira ishanja ly’emilala ya bene Kehati hagohago omu bandi bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Mubajirire ntyo lyo balama balekifa amango bankayegêra ebirugu bimâna bwenêne. ");
INSERT INTO shr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Aroni n’abagala banakaziyisha, banayêreka ngasi muguma mulibo omukolo gwâge n’ebi agwâsirwe okubarhula.» ");
INSERT INTO shr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Nyakasane abwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Oganje na bene Gershoni omu kushimba enyumpa za bashakulûza bâbo, oku emilala yâbo egenda. ");
INSERT INTO shr_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ojire omubalè gwâbo, kurhenga oku muntu wa myâka makumi asharhu kuhêka enyanya, muli balya banagwâsirwe okujira mukolo mulebe omw’ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Alaga emikolo y’emilala ya bene Gershoni, ebi bakazijira n’ebi bakazibarhula. ");
INSERT INTO shr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Bakazihêka emikango y’Endâro n’ey’ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Bakazihêka emikango y’obululi n’omushangi gubwîkira omuhango gw’obululi omu marhambi g’Endâro mwoshi, ey’oluhêrero n’emigozi yayo, kuguma n’ebirugu bikola eyôla, na kandi bo bakazijira emikolo enayêrekîre ebyôla byoshi. ");
INSERT INTO shr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Emikolo bene Gershoni bakajira yoshi Aroni n’abagala bo bakaziyilola, ebi bagwâsirwe okubarhula n’ebi bagwâsirwe okujira. Mukabalangisa ngasi birugu banagwâsirwe okubarhula. ");
INSERT INTO shr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gwo mukolo gwa bene Gershoni ogwôla omu ihêma ly’embugânano muli ogôla mukolo. Itamara mwene omudâhwa Aroni ye wakazibalola.» ");
INSERT INTO shr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Oganje bene Merari, oku obûko bwâbo n’emilala ya bashakulûza bâbo enali. ");
INSERT INTO shr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Obaganje kurhenga oku mulume wa myâka makumi asharhu, kuhêka enyanya, oku myâka makumi arhanu, abankahashiyûkiriza omukolo bahîrwe omw’ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Yumvagya emikolo wakazibahà: ebi bakazibarhula banakazibikolakwo omw’ihêma ly’embugânano: Oburhungiri bw’Endâro, emirhamba, emitungo n’amarhwerhwe gâyo. ");
INSERT INTO shr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Bakazihêka n’emitungo ezungulusire obululi, amarhwerhwe gâyo, emigozi, ebirugu byamwo n’emikolo ebiyêrekîre. Mukaziganja bwinjà ebyôla birugu bagwâsirwe okubarhula ngasi ciguma cimanyirirwe n’izîno lyâco muli ebyôla birugu babahîre okubarhula. ");
INSERT INTO shr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Go mukolo gwa bene Merari ogwôla, go mukolo gwâbo omu ihêma ly’embugânano, omurhambo wakazibalola ye Itamara mwene Aroni, omudâhwa.» ");
INSERT INTO shr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mûsa, Aroni n’abarhambo baganja bene Kehati nk’oku obûko n’emilala ya bashakulûza bâbo enali. ");
INSERT INTO shr_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Muganje kurhenga owa makumi asharhu kuhêka enyanya oku wa myâka makumi arhanu, balya bankahashiyûkiriza omukolo bahîrwe omu Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Abaganjirwe omu milala yâbo bahika oku balume bihumbi bibirhi na magana gali nda na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Bo baganjirwe b’omu bûko bwa Kehati abôla, bo bakazikola omu Ihêma ly’embugânano, Mûsa n’Aroni babajirira omubalè nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Abaganjirwe b’omu bûko bwa Gershoni, nk’oku emilala yâbo n’enyumpa za bashakulûza bâbo zinali; ");
INSERT INTO shr_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","kurhenga oku wa myâka makumi asharhu kuhêka enyanya oku wa myâka makumi arhanu, balya boshi bankanahashiyûkiriza omukolo bahîrwe omw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Abaganjirwe boshi omu kukulikira obûko na nk’oku emilala ya bashakulûza bâbo enagenda bahika omu balume bihumbi bibirhi na magana gali ndarhu na makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Bo bajirirwe omubalè abôla omu milala ya bene Gershoni, balya boshi banakazâgijira mukolo mulebe omw’Ihêma ly’embugânano. Mûsa na Aroni babajirira omubalè oku irhegeko lya Nyakasane. ");
INSERT INTO shr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Abaganjirwe b’omu milala ya bene Merari, omu kushimba obûko na nk’oku emilala ya bashakulûza bâbo ekulikirîne. ");
INSERT INTO shr_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Kurhenga oku wa myâka makumi asharhu kuhêka enyanya oku wa myâka makumi arhanu, balya bankanahashiyûkiriza omukolo bahîrwe omw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Abaganjirwe boshi omu kukulikira emilala yâbo, bahika oku balume bihumbi bisharhu na bantu magana abirhi. ");
INSERT INTO shr_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Bo baganjirwe abôla omu milala ya bene Merari bo Mûsa n’Aroni baganjaga abôla oku irhegeko Nyakasane ahâga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Bene Levi, abaganjirwe na Mûsa bo n’Aroni haguma n’abarhambo ba bene Israheli; oku obûko n’emilala ya bashakulûza bâbo ekulikirîne, ");
INSERT INTO shr_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","kurhenga oku wa myâka makumi asharhu kuhêka oku myâka makumi arhanu, boshi abakazagikola n’okubarhula omw’lhêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Abaganjirwe boshi bahika omu bihumbi munâni na magana arhanu na makumi gali munâni. ");
INSERT INTO shr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Babajirira omubalè nk’oku Nyakasane anarhegekaga Mûsa, omu kukazihà ngasi muguma omukolo ali agwâsirwe ajire n’ebi ali agwâsirwe okubarhula. Kwo bajirirwe omubalè ntyo nk’oku Nyakasane anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Orhegeke bene Israheli omu cihando câbo bakazihulusa ngasi wa lushomyo, ngasi wa bibenzi na ngasi yêshi oli mugalugalu erhi mufù gurhuma. ");
INSERT INTO shr_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Abè mulume abè mukazi, boshi kukwânîne obalibirhekwo omu cihando, balekihemula ecihando câbo, ecôla cihando ndimo ekarhî kâbo. ");
INSERT INTO shr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Bene Israheli banacijira kulya bakazihulusa omu cihando balya Nyakasane anarhegekaga Mûsa boshi, banacijira ntyo bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Obwîre bene Israheli. Erhi hankajira muguma, abè mulume abè mukazi wajira câha cirebe muli birya bibabaza omulungu, omu kugomera Nyakasane, na ntyo yêne acîjire mubî. ");
INSERT INTO shr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Oyo muntu anahungame ecâha câge, abulinagalulira mwene wâbo hirya anamubabazagyakwo, anayûshûlekwo ecigabi ca karhanu, anacihà olya anajiriraga kubî. ");
INSERT INTO shr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Akabà olya nyakunyagwa arhagwêrhi owayîmire omu byâge, olya bankahashigalulira kalya kantu kanyagagwa, kalya kantu banakagalulira Nyakasane, bakahe omudâhwa, ci kwônene buzira kuleka cirya cibuzi c’engandabuzi c’okuhyûla cirya bahyûlira olya nna obubî. ");
INSERT INTO shr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bulya kuli ngasi kantu koshi k’enterekêro Bene Israheli balerheraga omudâhwa, oyo mudâhwa ayêmêrîrwe okurhôlakwo ecâge cigabi. ");
INSERT INTO shr_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ebi omuntu ankanarhûla byoshi erhi n’omu maboko g’omudâhwa binali, na ngasi ebi muntu lebè ankahà omudâhwa erhi binali by’olya mudâhwa. ");
INSERT INTO shr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Nyakasane anacibwîra Mûsa, erhi: «Ogendidesa bene Israheli, obabwîre, erhi: ");
INSERT INTO shr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Omukazi ogwêrhe ibà erhi ankabà mubamba na ntyo amuhemukire”, ");
INSERT INTO shr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","“bulya amagenda boshi n’owundi mulume, n’okwôla kurhamanyikini emunda ibà ali, oyo mukazi ocîhemwîre ntyôla bufundafunda, buzira kubà na owankahashimushobeka na erhi akabà ntâye wamugwasire masi masi”. ");
INSERT INTO shr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","“Erhi nya­mulume akabà n’omujina kuli mukâge, nka na nyamukazi amuhemukire, kandi erhi ankabona omujina kuli mukâge ci kwônene nyamukazi arhamuhemukiraga”, ");
INSERT INTO shr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","“oyo anahêka mukâge emw’omudâhwa, ayîshe adwîrhe enterekêro kuli ye, cigabi ca kali ikumi c’omulengo gw’enshâno y’engano. Arhabulagiragakwo mavurha nîsi erhi nshangi, bulya eri nterekêro nkalange y’omujina, nterekêro ya bwikebwe eyakengêze obubî”. ");
INSERT INTO shr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Omudâhwa anabwîra olya mukazi ayegere oluhêrero, ayimange embere za Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","“Omudâhwa anayanka amîshi omu kabindi, na hano abà amayanka ehy’akatulo oku budaka bw’Endâro, anahihira mulya mîshi”, ");
INSERT INTO shr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","“Omudâhwa, anayimanza nyamukazi embere za Nyakasane, analukûla emviri z’okw’irhwe lya nyamukazi; kandi anamufumbasa enterekêro y’obwikebwe, nterekêro ya mujina. Omudâhwa anafumbarha omu maboko gâge amîshi malulu, go galêrha okuhehêrerwa”. ");
INSERT INTO shr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“Omudâhwa analahiriza nyamukazi amubwîre, erhi: Akabà ntà mulume walâzire mweshi naye, n’akabà orhahindamukaga okola wacîhemula, n’obwôla ociri omu mwa balo, onayêre muli agâla mîshi g’okuhehêrerwa”. ");
INSERT INTO shr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","“Ci erhi akabà wabîre mubamba, n’obwôla ogwêrhe balo, wagenda n’owundi mulume”. ");
INSERT INTO shr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","“Omudâhwa anamugasha n’ebinwa by’ecihango, anamubwîra”, erhi: “Nyamubâho akujire buhanya na wa busha omu karhî k’olubaga lwâge, oyume emirhibadu, orhunde n’enda”, ");
INSERT INTO shr_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","“n’agâla mîshi galêrha obuhanya gakuje omu nda gayirhunze ganakuyumye emirhibadu. Nyamukazi anashuza, erhi: Amen! Amen!” ");
INSERT INTO shr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Omudâhwa anayandika birya binwa by’okucigasha oku muzingè, kandi anabizagiza muli galya mîshi malulu”. ");
INSERT INTO shr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","“Ananywêsa nyamukazi galya mîshi malulu na ga kuhehêrerwa, n’agôla mîshi g’okuhehêrerwa ganashandabana muli ye n’obululu bwâgo”. ");
INSERT INTO shr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“Omudâhwa erhi abà amâyankirira omu maboko ga nyamukazi erya nterekêro y’omujina, anayimogamoga embere za Nyakasane, anayiyegeza oku luhêrero”. ");
INSERT INTO shr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","“Anashamarha nshâno ya lihî luguma lw’eyôla nterekêro y’okuyibusa, anayisingônokesa oku luhêrero, enyuma ly’ahôla anaywêsa nyamukazi galya mîshi”. ");
INSERT INTO shr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","“Hano abà amamunywesa galya mîshi oku bikolaga byayishibà: akabà nyamukazi ahemukîre îba, galya mîshi ganalêrha okuhehêrerwa hano ganamujamwo, ganamululire: enda yâge yanarhunda, emirhibadu yâge yanayuma na oyôla mukazi anabà muhanya omu bene wâbo”. ");
INSERT INTO shr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","“Ci erhi ankabà nyamukazi ali mwêru kwêru, arhahemukaga, arhankajà kwo iga, anacira, akazinaburha”. ");
INSERT INTO shr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Lyo irhegeko ly’omujina eryo, amango omukazi ankahemukira îba omu kuhusha”, ");
INSERT INTO shr_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","“nîsi erhi akabà omulume amajamwo omujina kuli mukâge: oyôla mulume anagendiyimanza mukâge embere za Nyakasane n’omudâhwa anamujirirakwo eryo irhegeko nk’oku linali lyoshi”. ");
INSERT INTO shr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","“Omulume arhajiziri câha, nyamukazi anabarhula obubî bwâge yêne”». ");
INSERT INTO shr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nyakasane anacibwîra Mûsa, erhi: «Ogendibwîra bene Israheli ntya: ");
INSERT INTO shr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Mango hânabè omulume erhi mukazi wajira eciragâne c’okucîhâna emwa Nyamubâho”, ");
INSERT INTO shr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","“oyôla muntu analekage okunywa idivayi na ngasi gandi mamvu galalusà goshi; arhanywaga ciru n’enkalishi erhenga omu idivayi erhi omu gandi mamvu galalusà. Arhanywaga ciru n’omurhobo gw’omu mizâbîbu, arhanalyaga ciru emizâbîbu mibishi nîsi eyumire”. ");
INSERT INTO shr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","“Amango gâge goshi g’oku­cihâna oyôla muntu munyaciragâne arhalyaga ciru n’ehitya birhenga oku mizâbîbu, kurhenga oku mogomogo z’emizâbîbu kuhika oku byûla byâyo”. ");
INSERT INTO shr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Amango g’okucîhâna kwâge oyôla munyaciragâne, olugembe lurhankamugera okw’irhwe, kuhika ensiku zâge z’eciragâne c’okucîhâna emwa Nyamubâho zihwe, ayôrha mwimâna, aleke emviri zâge zikule ntyo oku zinalonzize”. ");
INSERT INTO shr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Muli agôla mango g’okucîhâna kwâge, arhankayegêra omuntu ofîre ciru n’omuguma”, ");
INSERT INTO shr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","“arhankacîhemula ciru n’oli îshe, ciru n’oli nnina, ciru n’oli mwene wâbo, erhi mwâli wâbo ofîre, bulya okw’irhwe lyâge kwayandagalire omugisho gw’okumurherekêra Nyamuzinda”. ");
INSERT INTO shr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","“Agôla mango g’eciragâne câge goshi ali muntu orherekîrwe Nyakasane”. ");
INSERT INTO shr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Erhi omuntu ankafira buno buno aha burhambi bwâge, n’okwôla kubè­ muli lirya irhwe lyarherekîrwe Nyamubâho, anamôme irhwe lyâge oku lusiku lw’okucîcêsa; analimôma oku lusiku lwa kali nda”. ");
INSERT INTO shr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","“Oku lusiku lwa munâni anayisha adwîrhe emunda omudâhwa ali, mahali abirhi ga mpingà erhi bânagoko babirhi ba ngûkù, aha muhango gw’lhêma ly’embugânano”. ");
INSERT INTO shr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","“Omudâhwa anarherekêra ngûkù nguma oku nterekêro y’oku byâbà, n’eyindi oku nterekêro y’ensirîra, kandi anamujirira empyûlo kuli ecôla câha câge c’agôla mango g’omuntu ofîre. Olwôla lusiku olya muntu wajiraga eciragâne anashubirherekêra irhwe lyâge”. ");
INSERT INTO shr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","“Kandi anashubirherekêra Nyamubâho ensiku z’eciragâne câge, anarherekêra omwâna-buzi wa mwâka muguma oku nterekêro y’obubî. Ensiku zagezire zirhankaciganjwa bulya eciragâne câge cahemwîrwe”». ");
INSERT INTO shr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Alaga irhegeko ly’omuntu wacihânyire; oku lusiku luzinda lw’eciragâne câge banayisha bamudwîrhe ah’ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","“Anahà Nyamubâho entûlo yâge ntyâla: mwâna-buzi wa mwâka muguma orhalikwo ishembo, oku nterekêro y’ensirîra, omushîbuzi gwa mwâka muguma oku nterekêro y’oku byâha, nayo erhabâga n’ishembo, engandabuzi erhalikwo ishembo, oku nterekêro y’omurhûla”. ");
INSERT INTO shr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","“Ahirekwo ecirhiri c’emigati erhalimwo lwango, migati ya nshâno ya mula mvange n’amavurha n’orhundi rhugati rhutya rhutya rhurhalimwo lwango, rhushîge amavurha, kandi banajiramwo enterekêro y’enkalangè, n’eya okushêsha ecinyôbwa, erya banakômerera okujira”. ");
INSERT INTO shr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ebyôla omudâhwa anabirherekêra Nyamubâho, anabulihâna enterekêro yâge oku byâha kuguma n’enterekêro yâge y’ensirîra”. ");
INSERT INTO shr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","“Kandi anarherekêra erya ngandabuzi oku nterekêro y’omurhûla emwa Nyamubâho, kuguma na cirya cirhiri c’emigati erhalimwo lwango. Kandi omudâhwa anajira enterekêro yâge y’enkalangè n’ey’okushêsha ecinyôbwa”. ");
INSERT INTO shr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Olya wajiraga eciragâne anamômera irhwe lyâge ah’Ihêma ly’embugânano, hano abà amârhôla zirya mvîri z’okw’irhwe lyâge lyarherekêragwa, anazihira omu muliro gw’enterekêro y’omurhûla”. ");
INSERT INTO shr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Omudâhwa anayanka ecirhugo c’erya ngandabuzi nka camahya, anayanka na mugati muguma gurhalimwo lwango muli erya eri omu cirhiri, kuguma na higati higuma nahyo hirhalimwo lwango; na hanôla abà amabihira omu maboko­ g’olya nyakujira eciragâne, nka naye amanamômaga lirya irhwe lyâge lyarherekêragwa”. ");
INSERT INTO shr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","“Omudâhwa anabimogamoga embere za Nyamubâho: kali kantu kimâna k’omudâhwa kuguma na omushaya gubà gwamamogamogwa, na okugulu kubà kwamakobôlwa. Enyuma z’ahôla, olya wajiraga eciragâne anahashiginywa idivayi”. ");
INSERT INTO shr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Lyo irhegeko ly’owahânaga eciragâne elyo, lyo n’irhegeko lyâge oku nterekêro ankahà Nyamubâho nk’oku ankanahashibona. Eryo irhegeko aliyûkiriza nka kulya anahânaga eciragâne câge”». ");
INSERT INTO shr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nyakasane anacishambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Odese Aroni n’abagala, erhi: “Mukola mwagisha bene Israheli mwanababwîra”, erhi: ");
INSERT INTO shr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Nyakasane akugishe anakulange!” ");
INSERT INTO shr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","“Nyamubâho akumolekere n’obusù bwâge, anakushobôze engalo zâge!” ");
INSERT INTO shr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","“Nyamubâho akuyinamulire amalanga, anakuhè omurhûla!” ");
INSERT INTO shr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ntyo kwo bâkazihira izîno lyâni kuli bene Israheli, nâni nanabagisha.”» ");
INSERT INTO shr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Olusiku Mûsa ayûsagyamwo okuyûbaka Endâro, okugisha, okuyishîga amavurha n’okugisha ebirugu byamwo byoshi, kuguma n’oluhêrero n’ebirugu byâlwo byoshi, erhi abà amanashîga olwo luhêrero amanalugisha, ");
INSERT INTO shr_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","abaluzi b’Israheli bo baligi barhambo b’emilala ya bashakulûza bâbo, bayisha badwîrhe enterekêro zâbo: bo bàli barhambo b’emilala, balya bàli bayimangîre olubaga olusiku lw’omubalè. ");
INSERT INTO shr_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Bayisha badwîrhe enterekêro zâbo embere za Nyamubâho: Ngâlè ndarhu nfûnikire na mpanzi ikumi n’ibirhi, kwo kuderha: ngâlè nguma oku barhambo babirhi na mpanzi nguma oku ngasi mulala, banaciyisha babidwîrhe ntyôla embere z’Endâro. ");
INSERT INTO shr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Nyamubâho ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Oyankirire ebyôla bintu by’enterekêro, bikazikolêsibwa oku mikolo omw’Ihêma ly’embugânano; obihe bene Levi, ngasi muguma nk’oku amalagîrire g’omukolo gwâge ganali». ");
INSERT INTO shr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mûsa erhi abà amârhôla zirya ngâlè na zirya mpanzi, abigabira bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ahâna ngâlè ibirhi na mpanzi ini kuli bene Gershoni, nk’oku amalagîrire g’omukolo gwâbo ganali. ");
INSERT INTO shr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ahâna ngâlè ini na mpanzi munâni kuli bene Merari nk’oku amalagîrire g’omukolo gwâbo ganali oku bulanzi bw’Itamara mwene omudâhwa Aroni. ");
INSERT INTO shr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ci bene Kehati barhahâbagwa cici, bulya bo bàli bagwêrhe omukolo gw’ebintu bigishe, bàli bagwêrhe okujà kwabihêka aha birhugo byâbo. ");
INSERT INTO shr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Enyuma abarhambo bahâna enterekêro yâbo oku lusiku lw’okugishwa kw’oluhêrero, lwo lusiku balushîgaga amavurha. ");
INSERT INTO shr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Banacihêka enterekêro yâbo embere z’oluhêrero. Nyamubâho anacibwîra Mûsa, erhi: «Ngasi lusiku, murhambo muguma akaziyisha adwîrhe enterekêro yâge y’olusiku lukulu lw’okugishwa kw’oluhêrero.» ");
INSERT INTO shr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Omurhangiriza wahânaga enterekêro yâge àli Nashoni, mwene Aminadabu w’oku bûko bwa Yûda. ");
INSERT INTO shr_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, akabêhè k’e cûma c’olunyerere ca sikêli makumi galinda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà, mvange n’amavurha oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwa­ka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Ahirakwo ecihebe c’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","N’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi ndarhu ba mwâka muguma. Eyo yo nterekêro ya Nashoni mwene Aminadabu. ");
INSERT INTO shr_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Oku lusiku lwa kabirhi, Natanaeli mwene Suari, murhambo w’obûko bwa bene Isakari naye ahâna enterekêro yâge. ");
INSERT INTO shr_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, akabêhè k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Ahirakwo ecihebe c’enterekêro oku byâha, ");
INSERT INTO shr_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","n’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Natanaeli mwene Suari. ");
INSERT INTO shr_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Oku lusiku lwa kasharhu ayisha omurhambo wa bene Zabuloni, Eliabu mwene Heloni. ");
INSERT INTO shr_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, akabêhè k’ecûma c’olunyerere ca sikêli makumi gali nda omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Ahirakwo ecihebe c’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","N’oku nterekêro y’omurhûla, ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu, na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Eliabu mwene Heloni. ");
INSERT INTO shr_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oku lusiku lwa kani, ayisha omurhambo wa bene Rubeni, Elisuri mwene Sedeuri. ");
INSERT INTO shr_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabêhè k’ecûma c’olunyerere ca sikêli makumi gali nda omu kugerera oku sikêli y’ahantu himâna; ngasi cirugu càli ciyunjwîre nshâno ya mulà, mvange n’amavurha oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Ahirakwo engombo y’amasholo ga sikêli ikumi eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Ahirakwo ecihebe c’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","N’oku nterekêro y’omurhûla, ahâna mpanzi ibirhi, ngandabuzi ibirhi, bihehe birhanu na bânabuzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Elisuri mwene Sedeuri. ");
INSERT INTO shr_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Oku lusiku lwa karhanu ayisha omurhambo wa bene Simoni, Shelumieli mwene Surishadayi. ");
INSERT INTO shr_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabêhè k’ecûma c’olunyerere ca sikêli makumi gali nda omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà, mvange n’amavurha oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Ahirekwo engombo y’amasholo ga sikêli ikumi eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwa­ka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Ahirakwo ecihebe c’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","N’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Shelumieli mwene Surishadayi. ");
INSERT INTO shr_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Oku lusiku lwa kali ndarhu, ayisha omurhambo wa bene Gadi, Eliasafu mwene Dueli. ");
INSERT INTO shr_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabêhe k’ecûma c’olunyerere, ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha oku nterekêro y’e­ nkalange. ");
INSERT INTO shr_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Ahirakwo ecihebe c’enterekêro oku byâha, ");
INSERT INTO shr_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","n’oku nterekêro y’omurhûla, ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Eliasafu mwene Dueli. ");
INSERT INTO shr_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Oku lusiku lwa kali nda ayisha omurhambo wa bene Efrayimu, Elishamaʿ mwene Amihudi, ");
INSERT INTO shr_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabêhè k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma, oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Ahirakwo ecihebe c’enterekêro oku byâha, ");
INSERT INTO shr_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","n’oku nterekêro y’omurhûla, ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Elishamaʿ mwene Amihudi. ");
INSERT INTO shr_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Oku lusiku lwa kali munâni ayisha omurhambo wa bene Menashè, Gamalieli mwene Pedasuri. ");
INSERT INTO shr_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabêhe k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Ahirakwo n’engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwa­ka muguma, oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Ahirakwo ecihebe c’enterekêro oku byâha, ");
INSERT INTO shr_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","n’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Gamalieli mwene Pedasuri. ");
INSERT INTO shr_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Oku lusiku lwa kali mwenda ayisha omurhambo wa bene Benyamini, Abidani mwene Gedeoni. ");
INSERT INTO shr_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, n’akabehe k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna. Ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Ahirakwo n’engombo y’amasholo ga sikêli ikumi eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma, oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Ahirakwo ecihebe c’e­ nterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","N’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro y’Abidani mwene Gedeoni. ");
INSERT INTO shr_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Oku lusiku lwa kali ikumi, ayisha omurhambo wa bene Dani, Ahiyezeri mwene Amishadayi. ");
INSERT INTO shr_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikli igana na makumi asharhu, akabêhe k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Ahirakwo n’engombo y’amasholo ga sikêli ikumi eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwa­ka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Ahirakwo n’ecihebe c’enterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","N’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihehe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo, yo nterekêro y’Ahiyezeri mwene Amishadayi. ");
INSERT INTO shr_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Oku lusiku lwa kali ikumi na luguma, ayisha omurhambo wa bene Aseri, Pagieli mwene Okrani. ");
INSERT INTO shr_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, akabehe k’ecûma c’olunyerere ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Ahirakwo engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Ahirakwo empanzi y’omucûkà, engandabuzi n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra, ");
INSERT INTO shr_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","oku nterekêro y’okuhyûla oku byâha, ahâna cihebe ciguma. ");
INSERT INTO shr_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","N’oku nterekêro y’omurhûla, ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna-buzi barhanu ba mwâka muguma. Eyo yo nterekêro ya Pagieli mwene Okrani. ");
INSERT INTO shr_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Oku lusiku lwa kali ikumi na kabirhi, ayisha omurhambo wa bene Nefutali, Ahira mwene Enani. ");
INSERT INTO shr_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Arherekêra enambi y’ecûma c’olunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, akabehe k’ecûma c’olunyerere, ca sikêli makumi gali nda, omu kugerera oku sikêli y’ahantu himâna, ngasi cirugu càli ciyunjwîre nshâno ya mulà mvange n’amavurha, oku nterekêro y’enkalangè. ");
INSERT INTO shr_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Ahirakwo n’engombo y’amasholo ga sikêli ikumi, eyunjwîre bukù. ");
INSERT INTO shr_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Ahirakwo empanzi y’omucûkà, engandabuzi, n’omwâna-buzi wa mwâka muguma oku nterekêro y’ensirîra. ");
INSERT INTO shr_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Ahirakwo ecihebe c’enterekêro oku byâha, ");
INSERT INTO shr_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","n’oku nterekêro y’omurhûla ahâna mpanzi ibirhi, ngandabuzi irhanu, bihebe birhanu na bâna­ buzi barhanu ba mwâka muguma. Eyo, yo nterekêro ya Ahira mwene Enani. ");
INSERT INTO shr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ezôla, zo ntûlo z’abarhambo ba bene Israheli oku lusiku lukulu lw’okugishwa kwa oluhêrero, lwo lusiku balushigaga amavurha. Ezôla ntûlo zàli: nambi ikumi n’ibirhi z’ecûma c’olunyerere, rhubehe ikumi na rhubirhi rhw’ecûma c’olunyerere na ngombo ikumi n’ibirhi za masholo. ");
INSERT INTO shr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ngasi nambi ya cûma ca lunyerere, obuzirho bwâyo bwàli bwa sikêli igana na makumi asharhu, na ngasi kabehe, ka sikêli makumi gali nda. Obuzirho bw’ebyôla birugu by’olunyerere byoshi, zàli sikêli bihumbi bibirhi na magana anni, omu kugerera oku sikêli y’ahantu himâna. ");
INSERT INTO shr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Engombo z’amasholo zàli ziyunjwîre bukù, ngasi nguma yali ya sikêli ikumi omu kugerera oku sikêli y’ahantu himâna. Obuzirho bw’amasholo g’ezôla ngombo bwàli bw’igana na makumi abirhi ga sikêli. ");
INSERT INTO shr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Enyama z’enterekêro y’ensirîra: Mpanzi za mucûka ikumi n’ibirhi, ngandabuzi ikumi n’ibirhi na bâna-buzi ikumi na babirhi ba mwâka muguma, haguma n’enterekêro zâbo z’enkalangè. Hàli bihebe ikumi na bibirhi by’e­ nterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Enyama zahanyirwe nterekêro y’omurhûla: Mpanzi makumi abirhi n’ini, ngandabuzi makumi gali ndarhu, bihebe makumi gali ndarhu na bâna-buzi makumi gali ndarhu ba mwâka muguma. Byo byahânyirwe nterekêro ebyôla oku lusiku lw’okugisha oluhêrero, erhi babà bamalushîga amavurha. Oku Nyamuzinda akâgishambâla na Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Erhi Mûsa ajàga omw’lhêma ly’embugânano mpu ashambâle na Nyamubâho, akazâgiyumva izù lidwîrhe lyamudesa kurhenga oku nyanya ly’idubiro, elyali lihizirwe oku mucîmba gw’amalaganyo, ekarhî ka balya ba-kerubi babirhi. Anarhondêra okumushabâza. ");
INSERT INTO shr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nyakasane ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Oshambâle n’Aroni omubwîre, erhi: “Amango wahira amatara oku cinara, embere ly’ecôla cinara yo agôla matara nda gagwâsirwe gakazimolekera.”» ");
INSERT INTO shr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aroni anacijira kulya; ahira amatara embere z’ecinâra, nka kulya Nyamubâho anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ecôla cinara càli cijizirwe n’amasholo gône kuhika oku magulu, kuhika oku bwâso bwâco, càli cituzirwe n’amasholo gônene, Mûsa acîjirisagya omu kushimba ec’olwiganyo Nyamubâho amuyêrekaga. ");
INSERT INTO shr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Nyakasane ashambâza Mûsa amubwîra; erhi: ");
INSERT INTO shr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Orhôle bene Levi ekarhî ka bene Israheli, onabacêse. ");
INSERT INTO shr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","“Alaga oku wabacêsa: Obakangûle n’amîshi g’olukangûlo; bageze olugembe oku mubiri gwâbo goshi, bashuke n’emyambalo yâbo bacîcese ntyôla”. ");
INSERT INTO shr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“Enyuma z’ahôla, banarhôla empanzi y’omucûkà oku nterekêro y’ensirîra, kuguma n’enterekêro yâge y’enkalangè yajirwa n’e­ nshâno y’omulà mvange n’amavurha. Wanarhôla n’eyindi mpanzi y’omucûkà, ebè nterekêro oku câha”. ");
INSERT INTO shr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","“Wanashegeza bene Levi embere za ihêma ly’embugânano, kandi wanashubûza endêko ya bene Israheli boshi”. ");
INSERT INTO shr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","“Wanashegeza bene Levi embere za Nyamubâho, na bene Israheli banahira amaboko gâbo kuli bene Levi”. ");
INSERT INTO shr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","“Aroni anarherekêra bene Levi nka nterekêro ya kumogamogwa embere za Nyamubâho, nterekêro ehûnyirwe na bene Israheli, mpu babè bantu bakukazijira omukolo gwa Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Bene Levi, banahira amaboko oku irhwe ly’empanzi ibirhi, nguma wa­ nayihâna nka nterekêro oku byâha, n’eyindi nka nterekêro ya nsirîra ya Nyamubâho, lyo bahashijira empyûlo kuli bene Levi”. ");
INSERT INTO shr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Wanayimanza bene Levi embere z’Aroni n’embere z’abagala, wanabarherekêra nka nterekêro ya kumogamogwa embere za Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“Wanayêgûla bene Levi ekarhî k’abandi bene Israheli, na bene Levi banabà bantu bâni niene”. ");
INSERT INTO shr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Enyuma z’ahôla bene Levi banayisha balijira omukolo omu Ihêma ly’embugânano. Ntyo kwo wabacêsa onabarherekêre nka nterekêro ya kumogamogwa”. ");
INSERT INTO shr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Bulya bakola bîmi loshi omu bene Israheli; nabarhôzire nti babè bâni niene ahâli h’omwâna w’olubere, olya wayigula burhangiriza enda ya nina, nacîshozire bo kuli ngasi mwâna wa lubere wa bene Israheli”. ");
INSERT INTO shr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","“Bulya ngasi mwâna wa lubere wa bene Israheli ali wâni, abè mwâna wa lubere wa muntu, abè wa cintu. Lulya lusiku nayîrhagamwo ngasi lubere omu Mîsiri go mango nacîrherekêraga bo”. ");
INSERT INTO shr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","“Narhôzire Abaleviti ahâli h’abâna b’olubere ba bene Israheli”. ");
INSERT INTO shr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","“Nahânyire loshi bene Levi emwa Aroni n’abagala, nka ‘ngalo’, omu karhî ka bene Israheli; bakazijira omukolo gwa bene Israheli omu Ihêma ly’embugânano, bakazijira empyûlo ya bene Israheli, lyo bene Israheli balekijakwo cibande cici, amango bayegêra ahantu himâna”». ");
INSERT INTO shr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mûsa, Aroni na bene Israheli boshi bajirira bene Levi nk’okwôla Nyamubâho anarhegekaga Mûsa, oku hiyêrekîre bene Levi. Kwo bajizire ntyo bene Israheli kuli bo. ");
INSERT INTO shr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Abaleviti bacìcêsa, bashuka emyambalo yâbo. Naye Aroni abarherekêra nka nterekêro ya kumogamoga embere za Nyamubâho, abajirira n’empyûlo lyo babà bwinjà. ");
INSERT INTO shr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Enyuma z’ahôla, bene Levi bakaziyîsha balijira omukolo gwâbo omu Ihêma embere z’Aroni n’abagala. Bajira nk’oku Nyamubâho anarhegekaga Mûsa oku biyêrekîre bene Levi, okwôla kwo banabajirire. ");
INSERT INTO shr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Nyakasane ashambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Genda obwîre Bene­ Levi, erhi: “Kurhenga oku myâka makumi abirhi n’irhanu, ngasi Mwene-Levi arhegesirwe okuhâna enterekêro, ajire mukolo muguma omu Ihêma ly’Embugânano.” ");
INSERT INTO shr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","“Kurhenga oku myâka makumi arhanu, arhacisezibwi okuhâna enterekêro; ntà mukolo acisêzibwe okujira.” ");
INSERT INTO shr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","“Cikwône anarhabâla bene wâbo okushimba ebirhegesirwe omu Ihêma ly’Embugânano, erhi na ntà mukolo asêzibwe. Ntyo kwo wakazijira omu kushimba ebirhegesirwe Bene-Levi.”» ");
INSERT INTO shr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nyakasane ashambâla na Mûsa oku ntondo ya Sînayi omu mwêzi murhanzi gw’omwâka gwa kabirhi kurhenga barhenzire omu cihugo c’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Aderha, erhi: «Bene Israheli boshi bakazijira olusiku lukulu lwa Basâka amango ganakwânîne. ");
INSERT INTO shr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","“Mukazilujira amango ganakwânîne, oku lusiku lw’ikumi na kani lw’ogu mwêzi, ekarhî ka bijingo bibirhi: go mango gakwânîne agôla, mwakazilukuza omu kushimba amarhegeko na ngasi bijiro biluyêrekîre byoshi”». ");
INSERT INTO shr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mûsa agendishambâla na bene Israheli mpu bajire olusiku lukulu lwa Basâka. ");
INSERT INTO shr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Banacijira olusiku lukulu lwa Basâka, omu nsiku ikumi n’ini z’omwêzi gwa burhanzi ekarhî ka bijingo bibiri, omu ntondo ya Sînayi. Nk’oku Nyamubâho anarhegekaga Mûsa koshi, kwo bene Israheli banajizire. ");
INSERT INTO shr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Omu bantu mwabonekana abarhahashigijira Basâka, bàli bagalugalu erhi cirunda ca muntu cirhuma, ntyo okwôla kwarhuma barhacijira Basâka olwôla lusiku. Erhi babà bamâjà emunda Mûsa n’Aroni bali, ");
INSERT INTO shr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","babwîra Mûsa, mpu: «Rhwono rhuli bagalugalu erhi cirunda cirhuma, cirhumirage rhwêki rhuhanzibwa okurherekêra Nyamubâho amango gakwânîne, omu karhî ka bene Israheli» ");
INSERT INTO shr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mûsa abashuza, erhi: «Murhangilinda ngendidôsa bici Nyamubâho amurhegesire.» ");
INSERT INTO shr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nyamubâho ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Ojishambâla mwe na bene Israheli, obabwîre, erhi: Nka muntu muguma muli mwe nîsi erhi muntu muguma w’omu baburhwa binyu, akabà mugalugalu erhi cirunda cirhumire nîsi erhi abè abalamîre kuli, agwâsirwe naye ajire Basâka w’okukuza Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","“Omu mwêzi gwa kabirhi mwo bankamujira, omu nsiku ikumi n’ini, ekarhî ka bijingo bibirhi. Banamulye n’emigati erhalimwo lwango, n’enshogo ndulu”. ");
INSERT INTO shr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","“Barhasizagya cici kuhika oku sêzi, barhanamuvunaga kavuha”. ");
INSERT INTO shr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Erhi kwankabà hali omuntu oyôsire bwinjà, arhanali omu mabalamo, oyo muntu erhi ankabula kwajira olusiku lukulu lwa Basâka, oyo muntu banamukage omu lubaga lwâge; bulya arhahâga Nyamubâho enterekêro amango gakwânîne, yêne anabarhule ecâha câge”. ");
INSERT INTO shr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Erhi omuntu w’ecigolo ohanzire emwinyu ankajira naye Basâka, kukwânîne ashimbe amarhegeko n’ebijiro binayêrekîre Basâka byoshi. Hâbà irhegeko liguma kuli mwe n’oku cigolo n’oku wundi muntu obashizire”». ");
INSERT INTO shr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Olusiku bayimazagya Endâro, ecitù cabwîkira eyôla Ndâro: lyo Ihêma ly’amalaganyo. Kurhenga bijingo kujika sêzi, oku Ndâro kwajà oguli nka muliro. ");
INSERT INTO shr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Byanakaziyôrha byâbà ntyôla: ecitù canabwîkira Endâro, na budufu canayôrha nka muliro. ");
INSERT INTO shr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Erhi ecôla citù carhengaga oku Ihêma, nabo bene Israheli banahandûla, n’aha ecitù cayimangaga ho nabo banakazigwîka ecihando. ");
INSERT INTO shr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Bene Israheli bakazihandûla oku irhegeko lya Nyamubâho, kandi oku irhegeko lyâge banashubigwîka ecihando. Bakaziyôrha bali oku cihando, amango goshi naco ecôla citù canakazâgiyôrha ciri oku Ndâro. ");
INSERT INTO shr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Erhi ecôla citù cankalegamire nsiku nyinji oku Ndâro, bene Israheli banashimbe lirya irhegeko lya Nyamubâho, barhankaciderha mpu babandûla. ");
INSERT INTO shr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kwo na kuguma, erhi ecôla citù cankagezize nsiku nsungunu zône oku Ndâro: oku irhegeko lya Nyamubâho banagwîka ecihando, kandi oku irhegeko lya Nyamubâho bahandûle. ");
INSERT INTO shr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Erhi ecitù cankayimanzire kurhenga bijingo byône kuhika sêzi, cikanasjubiyimuka sêzi, nabo banahandûle, Kandi erhi ecitù cankayimusire kugere lusiku luguma na budufu buguma nabo banahandùle. ");
INSERT INTO shr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Erhi ecôla citù cankayôsire oku Ndâro nsiku nyinji, mwêzi erhi mwâka, bene Israheli banayôrha bali oku cihando, arhankadesire mpu bakola bahandûla: erhi canayimukaga ntyâla nabo banajandûle. ");
INSERT INTO shr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Oku irhegeko lya Nyamubâho banagwîka ecihando, n’oku irhegeko lya Nyamubâho banahandûla. Bakazâgishimba irhegeko lya Nyamubâho nk’oku Nyamubâho anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nyakasane ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Otule mishekera ibirhi ya cûma ca lunyerere; ebè cûma ca lunyerere cônene. Wakaziyikolêsa amango g’okushubûza olubaga n’amango g’okuhandûla bakola barhenga omu cihando. ");
INSERT INTO shr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","“Nka gwamâbûhwa olubaga lwoshi lwanalundumukira emunda oli, aha Ihêma ly’embugânano”. ");
INSERT INTO shr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","“Erhi bankabûha mushekera muguma gône, abaluzi, bo baligi barhambo b’ebihumbi bya bene Israheli, banayisha badêke eburhambi bwâwe”. ");
INSERT INTO shr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“Erhi bankabûha eyôla mishekera eshakanya omu cihando, balya bahanda olunda lwa ebuzûka-zûba banarhangira okugenda”. ");
INSERT INTO shr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","“Erhi bankashubibûha eyôla mishekera eshakanya obwa kabirhi, balya bahanda olunda lw’emukondwè, banalikûla nabo. Kandi banashubiyibûha eshakanye amango g’okugenda loshi”. ");
INSERT INTO shr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","“Wanakaziyibûha amango okola wahamagala olubaga omu ndêko, ci agôla mango erhashakanyagya”. ");
INSERT INTO shr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Abadâhwa bene Aroni bo bakazibûha eyôla mishekera, okwo kwâbà irhegeko ly’ensiku zoshi, omu ngasi bûko bwinyu”. ");
INSERT INTO shr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Amango mukabà mwaja oku matabâro omu cihugo cinyu, mukola mwajilwîsa omushombanyi olibatulakwo entambala, mwanabûha emishekera eshakanye, na Nyamubâho, Nyamuzinda winyu, anamuyumvirhiza, na ntyo anabayôkola kuli abôla bashombanyi binyu”. ");
INSERT INTO shr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Omu nsiku z’obusîme, omu nsiku nkulu zinyu, n’amango mukuzamwo omwêzi nka gwamabaluka, mwanakazibûha emishekera, nka mukola mwarherekêra enterekêro y’ensirîra n’e­ nterekêro y’omurhûla, mwanabûha eyôla mishekera ebè kakengêzo embere za Nyamuzinda winyu. Nie Nyamubâho, Nyamuzinda winyu”». ");
INSERT INTO shr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Oku mwâka gwa kabirhi, omu nsiku makumi abirhi z’omwêzi gwa kabirhi ecitù carhenga oku Ndâro y’obuhamîrizi. ");
INSERT INTO shr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Bene Israheli bashubihira njira, barhenga omw’irungu lya Sînayi, cirya citù cagendiyimanga omw’irungu lya Parani. ");
INSERT INTO shr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Erhi bakola bagenda obwôla bwa burhanzi, bashimba kulya Nyamubâho arhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ibendêra ly’ecihando ca bene Yûda lyagenda lya burhanzi, nk’oku emirhwe yâbo yanali, n’omurhwe gwa bene Yûda gwàli gurhegesirwe n’omurhambo Nashoni, mwene Aminadabu; ");
INSERT INTO shr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Omurhwe g’obûko bwa bene Isakari gwàli gurhegesirwe n’omurhambo Natanaeli, mwene Suari; ");
INSERT INTO shr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Omurhwe g’obûko bwa bene Zabuloni gwàli gurhegesirwe n’omurhambo Eliabu, mwene Heloni. ");
INSERT INTO shr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Endâro yanacigwikûlwa, bene Gershoni na bene Merari bagendana eyôla Ndâro. ");
INSERT INTO shr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ibendêra ly’ecihando ca bene Rubeni nalyo lyagenda, nk’oku emirhwe yâbo yanali, n’omurhwe gwa bene Rubeni gwàli gurhegesirwe n’omurhambo Elisuri, mwene Sedeuri. ");
INSERT INTO shr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Omurhwe gw’obûko bwa bene Simoni gwàli gurhegesirwe n’omurhambo Shelumieli, mwene Surishadayi; ");
INSERT INTO shr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","n’omurhwe gw’obûko bwa bene Gadi gwàli gurhegesirwe n’omurhambo Eliasafu, mwene Dueli. ");
INSERT INTO shr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Bene Kehati nabo bagenda erhi babarhwîre ebirugu bimâna, abandi bakazigwika Endâro oku balinda bayisha. ");
INSERT INTO shr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ibendêra ly’ecihando ca bene Efrayimu nalyo lyagenda, nk’oku emirhwe yâbo yanali, n’omurhwe gwa bene Efrayimu gwàli gurhegesirwe n’omurhambo Elishamaʿ, mwene Amiyudi. ");
INSERT INTO shr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Omurhwe gw’obûko bwa bene Menashè, gwàli gurhegesirwe n’omurhamho Gamalieli, mwene Pedasuri, ");
INSERT INTO shr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","n’omurhwe gw’obûko bwa bene Benyamini, gwàli gurhegesirwe n’omurhambo Abidani, mwene Gedeoni. ");
INSERT INTO shr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ibendêra ly’ecihando ca bene Dani nalyo lyagenda, nk’oku emirhwe yanali: gwo gwàli murhwe muzinda omu bihando byoshi. Omurhwe gwa Dani gwàli gurhegesirwe n’omurhambo Ahiyezeri, mwene Amishadayi; ");
INSERT INTO shr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","omurhwe gw’obûko bwa bene Aseri gwàli gurhegesirwe n’omurhambo Pagieli, mwene Okrani, ");
INSERT INTO shr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","n’omurhwe gwa bene Nefutali gwàli gurhegesirwe n’omurhambo Ahira, mwene Enani. ");
INSERT INTO shr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Kwo bakazâgikulikirana ntyo bene Israheli, nk’oku emirhwe yâbo yanali. Banacihira njira. ");
INSERT INTO shr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mûsa anacibwîra ishazâla Hobabu, mwene Reweli, w’e Madiani erhi: «Rhukolaga rhwajà erya munda Nyamubâho aderhaga, erhi: Namuhà eyôla. Kanya rhugende rhweshi, rhwakujirira aminjà, bulya Nyamubâho alaganîne oku ajirira bene Israheli aminjà.» ");
INSERT INTO shr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu amushuza, erhi: «Ntayîshe, ci nacîshubirira omu cihugo câni n’omu mulala gwâni.» ");
INSERT INTO shr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mûsa aderha, erhi: Nkuhûnyire, orharhurhengagakwo, bulya we omanyire ahantu rhwajà mwahanda omw’irungu, wajâ wâbà nk’izù lîrhu. ");
INSERT INTO shr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Okayisha haguma nîrhu, rhwanayishigabâna birya binjà Nyamubâho ânarhuhe. ");
INSERT INTO shr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Amango barhengaga oku ntondo ya Nyamubâho, bajira nsiku isharhu, bagenda, na muli olwôla lugendo lw’ensiku isharhu, omucîmba gw’amalaganyo ga Nyamubâho gwajà gwabashokolera, gwajà gwabalongeza aha barhamukira. ");
INSERT INTO shr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ecitù ca Nyamubâho cakâgija cayêrêra enyanya zâbo mûshi, nka bamârhenga omu cihando. ");
INSERT INTO shr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Erhi omucîmba gw’amalaganyo gwagendaga, Mûsa anaderha, erhi: «Yimuka, Nyamubâho, abanzi bâwe bashandabane! Abakushomba bahirigirhe embere zâwe!» ");
INSERT INTO shr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na erhi gwayimanga, Mûsa anaderhe, erhi: «Hindamuka, Yâgirwa Nyamubâho, oyêrekere ogûla mwandu gw’ebihumbi bya bene Israheli.» ");
INSERT INTO shr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Olubaga lwarhondêra okucîdudumira kubî omu kurhwiri kwa Nyamubâho. Nyamubâho ayumva okwôla, n’oburhè bwâge bwayâka bwenêne, omuliro gwa Nyamubâho gwayâka kuli bo, gwarhondêra okuyôca eburhambi bw’ecihando. ");
INSERT INTO shr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Olubaga lwalakira emunda Mûsa ali, naye Mûsa ajishenga Nyamubâho, gulya muliro gwanacizima. ");
INSERT INTO shr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Abôla hantu bahayîrika izîno lya Tabera, bulya omuliro gwa Nyamubâho gwayâsire kuli bo. ");
INSERT INTO shr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Cirundo ca bantu baguma muli bene Israheli carhondêra okuyumva akagegene, ciru na bene Israheli banji bashubirhondêra okucîlasa, mpu: «Ndi wankarhuha enyama rhwalya? ");
INSERT INTO shr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Rhwamadula zirya nfî rhwakagilya busha busha konene e Mîsiri, rhwamadula gulya mundagwè, galya malehe, birya bitumbura na balya bapwaro bîrhu. ");
INSERT INTO shr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Rhwono rhukola rhwayumira enôla munda oku busha! Amasù gîrhu garhabona agarhali agâla mâna». ");
INSERT INTO shr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Agôla mâna gàli nka mogomogo za mahemba, n’oku nshusho gàli gashushire obulo. ");
INSERT INTO shr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Olubaga lwakazishandabana lukola lwajigarhôla; kandi lwanagashwera oku lwanjikwa nîsi erhi okugashakulira omu cishakulo; lwakazigayendera aha nyungu nîsi erhi okujiramwo emigati. Gali gagwêrhe obununu bw’omugati gwajiragwa n’amavurha. ");
INSERT INTO shr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Erhi olumè lwarhogeraga omu mashwa budufu, lyo n’agôla mâna gakazâgiyandagala nago. ");
INSERT INTO shr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mûsa ayumva oku olubaga ludwîrhe lwacîduduma omu ngasi mulala, ngasi muguma aha c’olusò lw’enyumpa yâge. Oburhè bwa Nyamubâho bwayâka bwenêne. Mûsa akunira, ");
INSERT INTO shr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","anacibwîra Nyamubâho, erhi: «Carhumaga ojirira mwambali wâwe mabî ga bene agâla, carhumaga nka nalintonyire omu masù gâwe, ombarhuza omuzigo gw’olubaga lwa bene olu? ");
INSERT INTO shr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","“Ka nie nasingaga olûla lubaga? Ka nie naluburhaga, okwôla nkaba kwanarhuma wambwîra, erhi: Ohugirage oku nda yâwe, nka kula omuzîre ahêka omwâna akola amuyonsa, kuhika muli cirya cihugo wahigaga mpu wahà ababusi bâbo”. ");
INSERT INTO shr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","“Ngahigi nakûla enyama nahà olu lubaga lôshi? Bulya lwandibuzize n’okulaka omu kuderha”, erhi: “Rhubè nîrhu enyama rhwalya”. ");
INSERT INTO shr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","“Ntankahasha niene niene okuhêka olûla lubaga; luli luzirho bwenêne kuli nie”. ");
INSERT INTO shr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","“Ahâli h’okunjira ntyâla, nkusengîre onyîrhe erhi kwo, akabà obwîne ntonyire omu masù gâwe, n’akabà orhalonza mbone obuhanya!”» ");
INSERT INTO shr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Nyamubâho abwîra Mûsa, erhi: «Nshubûlizagya balume makumi gali nda omu bashamuka bene Israheli, balya bakola bantu bakulu banagwêrhe obuhashe oku bandi: obalêrhe aha Ihêma ly’embugânano, babere ahôla mweshi nabo. ");
INSERT INTO shr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","“Nayishibunguluka nshambâle nâwe ahôla; narhôla kuli gulya mûka gukulikwo, nguhire kuli bo, lyo babarhula mweshi nabo ogwôla muzigo g’olubaga, na ntyôla orhacikazigubarhule wênewêne”. ");
INSERT INTO shr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ojibwîra olubaga”, erhi: “Mucîcêse oku lusiku lw’irhondo, lyo mwahâbwa enyama mwalya kulya mwakazâgilakira omu marhwiri ga Nyamubâho muderha” mpu: “Ndi wankacirhulisa nîrhu oku nyama? Bulya rhwàli rhucibêrîre bwinjà e Mîsiri! Na Nyamubâho âmuhà e­nyama mwanalya”. ");
INSERT INTO shr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","“Arhali lusiku luguma lônene mwayirya, arhali nsiku ibirhi zonène, arhali nsiku irhanu zonène, arhali nsiku ikumi zonène nîsi erhi makumi abirhi gônene”. ");
INSERT INTO shr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","“Ci mwêzi mugumagumà goshi kuhika zimuyîshe emazulu, zimuyihike ebwa kubà mwahakanyire Nyamubâho oli ekarhî kinyu, mwanalakire embere zâge ene mukaziderha”, mpu: “Carhumaga rhurhenga e Mîsiri”». ");
INSERT INTO shr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mûsa ederha, erhi: «Olûla lubaga ndi ekarhî kâlwo, luli lwa bantu bihumbi magana gali ndarhu bagenda n’amagulu, wanabuliderha, erhi: “Nabahà enyama balya omwêzi goshi!” ");
INSERT INTO shr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","“Ka rhukolaga rhwababâgira ebibuzi n’enkafu lyo babona ngasi muguma hirya hinakwânîne?”» ");
INSERT INTO shr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nyamubâho ashuza Mûsa, erhi: «K’okuboko kwa Nyamubâho kwayofiha bwenêne nici? Okolaga wabona erhi okwôla nakubwîraga kwabà erhi nanga». ");
INSERT INTO shr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mûsa ahuluka ajibwîra olubaga ebyôla binwa bya Nyamubâho, anacishûbûza bagula makumi gali nda omu bashamuka bakulu b’olubaga, abahira eburhambi bw’Ihêma. ");
INSERT INTO shr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nyamubâho ayandagala omu citù, anacishambâla na Mûsa, ayanka kuli gulya mûka gwamulikwo, aguhirakwo balya bagula makumi gali nda; n’oku ogwôla mûka gwanabajakwo ntya, barhondêra okulêba; ci barhaciyûshûlaga. ");
INSERT INTO shr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Bantu babirhi, muguma izîno lyâge ye wali Eldadi, n’owundi Medadi, bàli basigîre oku cihando, nabo mûka abajakwo; bàli omu bayandisirwe, ci barhahashagija ebw’Ihêma; nabo barhondêra okulêbera omu cihando. ");
INSERT INTO shr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mwâna muguma wa musole akanya agendibwîra Mûsa, erhi: «Eldadi na Medadi badwîrhe balêbera omu cihando.» ");
INSERT INTO shr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ho na halya, Yozwè, mwene Nuni, abâga murhumisi wa Mûsa kurhenga eburhò bwâge, ajà omu kanwa aderha, erhi: «Mâshi yâgirwa Nnawîrhu Mûsa, obahanze.» ");
INSERT INTO shr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mûsa amushuza, erhi: «Ka wamambonera obumvu? Owabona Nyamuzinda ahindula olubaga lwa Nyamubâho lwoshi lukola lwakazilêba, na Nyamubâho ahire omûka gwâge kulibo!» ");
INSERT INTO shr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mûsa acîshubirira omu cihando n’abagula b’Israheli. ");
INSERT INTO shr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Oku irhegeko lya Nyamubâho, empûsi yanacihûsa; eyo mpûsi yarhenga e­bwa nyanja, yayisha edwîrhe empirahira, yazihunika oku cihando, n’ahôla zàgwâga, obulî bwaho bwàli bwa igenda lya mulegerege muguma lunda luguma n’olundi lunda lindi igenda lya mulegerege muguma, eburhambi bw’ecihando n’oku zàli zilundumine kwo kuhêka enyanya, bwàli burherema bwa makoro abirhi kurhenga okw’idaho. ");
INSERT INTO shr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Olwôla lusiku loshi, n’obudufu bwoshi, n’erhi buca, olubaga lwarhondêra lwagwârha ezôla mpirahira; owali gwâsire nsungunu àli ahisire omu homori ikumi; bayanika ebyôla byâbo eburhambi bw’ecihando coshi. ");
INSERT INTO shr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ci oku enyama zicibali ekanwa omu mîno barhacimira, oburhè bwa Nyamubâho bwanaciyâkira oku lubaga; Nyamubâho abalambika­ mwo banji bwenêne là. ");
INSERT INTO shr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ahôla hantu bahayîrika izîno lya Kibroti-Hatava, e­bwa kubà ahôla ho babishaga lulya lubaga lwagomaga erhi kagegene karhuma. ");
INSERT INTO shr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kurhenga aha Kibroti-Hatava, olubaga lwajà e Heseroti, lwanahanda ahôla Haseroti. ");
INSERT INTO shr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu n’Aroni, barhondêra okuderhaderha kubî Mûsa erhi omukazi w’omukûshi ayankaga orhuma. Ebwa kubà amayanka omukazi w’omukûshi. ");
INSERT INTO shr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Banacirhondêra okuderha, mpu: «Ka Nyamubâho kuli Mûsa yênene aderhera? K’arhaderheraga kuli rhwe rhwêki?» Nyamubâho anaciyumva okwôla. ");
INSERT INTO shr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ci Mûsa acibêraga muntu mutûdu bwenêne, kulusha abandi bantu boshi ba hanôla igulu. ");
INSERT INTO shr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Mw’akola kanya konênè, Nyamubâho abwîra Mûsa, Aroni na Miriamu, erhi: «Muhuluke oku muli basharhu, mujè e­ bw’Ihêma ly’embugânano.» Banacihuluka oku bali basharhu. ");
INSERT INTO shr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nyamubâho ayandagala omu nkingi y’ecitù, agendibêra aha lusò lw’Ihêma. Ahamagala Aroni na Miriamu, nabo oku bali babirhi bayegêra. ");
INSERT INTO shr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Anacibabwîra, erhi: «Yumvi bwinjà ebinwa byâni: “Akabà hali mulêbi wa Nyamubâho mugwêrhe, omu bilôrho mwo ncîmanyisa emwâge, omu bilôrho mmuderhegeza”. ");
INSERT INTO shr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","“Ci mwambali wâni Mûsa arhali ntyôla; amanyîkîne bwinjà oku ali muntu nkana munôla nyumpa yâni yoshi”. ");
INSERT INTO shr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","“Nankazimushambâza rhuyerekezanye akanwa, nciyêreke ye ci ntamushambaliza omu migani, yêne anahashilolêreza obusù bwa Nyamubâho. Carhumirage murharhînya okujà kwaderhaderha kubî mwambali wâni Mûsa?”» ");
INSERT INTO shr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Oburhè bwa Nyamubâho bwanaciyâka bwenêne kuli bo; anacicîgendera; ecitù canacicîyêgûla kulya nyanya ly’Ihêma. ");
INSERT INTO shr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Na, k’orhabona! Miriamu amahinduka wa lushomyo, akola mwêru nka lubula. Aroni ayêrekera emunda Miriamu ali, alola oku akola mushomyo. ");
INSERT INTO shr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aroni anacibwîra Mûsa, erhi: «Mâshi Yâgirwa, nnawîrhu, omanye wankarhubarhuza ecîra câha rhwâjiraga omu kuhalanjika, rhunakwânîne n’obuhane bwâco. ");
INSERT INTO shr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mâshi arhabâga nka mwâna wa cifù, ye rhenga omu nda ya nina erhi n’omubiri gumonyôsire!» ");
INSERT INTO shr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mûsa anacishenga Nyamubâho aderha, erhi: «Mâshi, Nyamuzinda nkusengîre, omufumye!» ");
INSERT INTO shr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nyamubâho anacibwîra Mûsa, erhi: «Îshe acimukayiraga ebusù arhankageza nsiku nda erhi ayunjwîre nshonyi? Ayôrhe nsiku nda muyungule embuga ly’ecihando; enyuma z’ahôla banashubimuyankirira omwôla cihando.» ");
INSERT INTO shr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriamu nsiku nda ali muyungule embuga ly’ecihando, n’olubaga lurhahashigigenda, kuhika Miriamu ashubiyankirirwa. ");
INSERT INTO shr_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Enyuma z’aho, olubaga lwarhenga ahôla Haseroti, bâge­ndihânda omu irungu lya Parani. ");
INSERT INTO shr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Nyamubâho anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Orhume abantu bagendiyênja ecihugo ca Kanâni, co cihugo nâhà bene Israheli. Ojè warhuma muguma muguma omu ngasi bûko; n’abôla warhuma kukwânîne babè b’omu barhambo bâbo.» ");
INSERT INTO shr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mûsa abarhuma kurhenga omwôla irungu lya Parani nk’okwôla Nyamubâho anarhegekaga; abôla barhambo barhumagwa bàli barhambo ba muli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Alaga amazîno gâbo: omu bûko bwa Rubeni, Shamuwa, mwene Zakuru. ");
INSERT INTO shr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Omu bûko bwa Simoni, Shafati, mwene Hori, ");
INSERT INTO shr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","omu bûko bwa Yûda, Kalebu mwene Yefunè, ");
INSERT INTO shr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","omu bûko bwa Isakari, lgali, mwene Yozefu. ");
INSERT INTO shr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Omu bûko bwa Efrayimu, Oseyi, mwene Nuni, ");
INSERT INTO shr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","omu bûko bwa Benyamini, Palti, mwene Rafu, ");
INSERT INTO shr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","omu bûko bwa Zabuloni, Gadieli, mwene Sodi, ");
INSERT INTO shr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Omu bûko bwa Yozefu, bwa Menashè, Gadi, mwene Susi, ");
INSERT INTO shr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","omu bûko bwa Dani, Amieli, mwene Gemali, ");
INSERT INTO shr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","omu bûko bwa Aseri, Seturi, mwene Mikaeli. ");
INSERT INTO shr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Omu bûko bwa Nefutali, Nahabi, mwene Vafusi, ");
INSERT INTO shr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","omu bûko bwa Gadi, Geweli, mwene Maki. ");
INSERT INTO shr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Agôla go mazîno g’abantu barhumagwa mpu bâge­ndiyênja ecihugo. Mûsa ayîrika Oseyi mwene Nuni izîno lya Yozwè. ");
INSERT INTO shr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mûsa abarhuma mpu hagendiyênja ecihugo ca Kanâni; ababwîra, erhi: «Musôkere eyôla munda omu kugerera e Nêgebu; musôke oku ntondo. ");
INSERT INTO shr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mulolêreze bwinjà kurhi ecihugo ciyôsire, abantu bayûbakamwo, akabà bali bazibu erhi nanga, akabà bali banyi erhi mwandu. ");
INSERT INTO shr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mulolêreze ecôla cihugo, bantu bayûbakamwo, kurhi ciri, akabà ciri cinjà erhi cibî; mulole ebishagala bayûbakamwo kurhi biri, akabà biri bizibuzibu nîsi erhi biri biyîgule hoshi. ");
INSERT INTO shr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mulole kurhi obudaka buyôsire, erhi buli bwinjà erhi nanga burhali bo, mulole erhi ciri mwo n’emirhi nîsi erhi nanga. Mubè n’oburhwâli, murhôle oku malehe g’ecôla cihugo». Gàli mango g’okutwa emizâbîbu mirhanzi. ");
INSERT INTO shr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Basôka, bajà bayenjayenja ecihugo, kurhenga okw’irungu lya Sini kuhika e Rehobu, oku njira yajà e Hamati. ");
INSERT INTO shr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Basôka omu Nêgebu, bahika cingana e Hebroni, emunda Akimani, Sheshayi na Talmayi, bene Anaki bayûbakaga. Hebroni ayûbakagwa myâka nda embere lya Sowani w’e Mîsiri. ");
INSERT INTO shr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Erhi bahika omu kabanda ka Eskoli batwa ishami ly’omuzâbîbu n’olusisi lw’ogôla muzâbîbu, bayisha balibarhwire bantu babirhi oku murhamba, barhôla n’agandi malehe g’amakomamanga n’emitini. ");
INSERT INTO shr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ahôla bahayîrika izîno ly’akabanda ka Eskoli, erhi olwôla lusisi lw’omuzâbîbu bene Israheli batwâga lwo lurhuma. ");
INSERT INTO shr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Enyuma lya nsiku makumi anni kurhenga eyôla munda balijiriyênja ecihugo, ");
INSERT INTO shr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","bayisha bayishire bajà emunda Mûsa ali n’Aroni, n’endêko ya bene Israheli boshi aha Kadesi, omw’irungu lya Parani. Bababwîra emyanzi nka kulya banarhumagwa; bashambalira n’olubaga loshi, banabayêreka amelehe ga ecôla cihugo. ");
INSERT INTO shr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Yumvagya oku bashambaliraga Mûsa: «Nêci rhwanajîrage mwa cirya cihugo wanarhurhumagamwo. Okunali ciri cihugo cihululamwo amarhà n’obûci, agâla malehe gône gakumanyise. ");
INSERT INTO shr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","“Ci olubaga luyûbaka ecôla cihugo luli ludârhi, n’ebishagala byâbo biri bizibuzibu na binene bwenêne; ciru rhwanashimanyiremwo bene Anaki”. ");
INSERT INTO shr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","“Amaleki ayûbaka ecihugo ca Nêgebu, omu­nya-Hiti, omunya-Yebusi n’omunya-Mori bayûbaka omu ntondo, n’omu­nya-Kanâni ayûbaka oku burhambi bw’enyanja n’oku burhambi bwa Yordani.”» ");
INSERT INTO shr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebu ayimuka abwîra olubaga lwàli luzonzire Mûsa, erhi: «Yumvi mmubwîre. Kanyi rhusôkere eyôla munda rhurhôle ecôla cihugo bulya rhwanakuhasha.» ");
INSERT INTO shr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ci abandi bantu bàli barheremire naye baderha, mpu: «Rhurhankahasha okusôka mpu rhujilwîsa olwôla lubaga, luli ludârhi kurhulusha». ");
INSERT INTO shr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Barhondêra okushambâla kubî kubî oku biyêrekîre ecôla cihugo balijiriyênja, bakaziderha, mpu: «Ecihugo rhwalijiriyênja, ciri cihugo cirya bene co, abantu rhwabwîne muli ecôla cihugo bali bantu balî-balî. ");
INSERT INTO shr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","“Ciru rhwabwinemwo balya bantu banene-banene, bene Anaki, bulya bûko bw’abantu bahamu bwenêne: rhwàli embere zâbo n’omu masù gâbo, nka mahanzi.”» ");
INSERT INTO shr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Olubaga lwoshi lwalogôshera, lwabanda orhuhababo, lwalakûla obwôla budufu boshi. ");
INSERT INTO shr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bene Israheli boshi bakazicîdudumira Mûsa n’Aroni, n’endêko yoshi yababwîra, erhi: «Ka rhurhankafirire omu cihugo c’e Mîsiri nîsi erhi munôla irungu erhimwo.» ");
INSERT INTO shr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Carhuma Nyamubâho arhuhêka muli ecôla cihugo, omu engôrho yagendirhumalirira? Bak’irhwe n’abâna bîrhu bakolaga bagendiba mpira zâbo. Ka kurhali kwinjà kuli rhwe rhucîshubirire e Mîsiri erhi kwo? ");
INSERT INTO shr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Banacibwîrana bône nannene, mpu: «Rhucishoge owîrhu murhambo, rhucîshubirire e Mîsiri» ");
INSERT INTO shr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mûsa n’Aroni banacikumba bûbi embere za bene Israheli boshi. ");
INSERT INTO shr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yozwè, mwene Nuni na Kalebu, mwene Yefunè, bantu babirhi omu bagendigiyenja ecihugo, basharhula emyambalo yâbo. ");
INSERT INTO shr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Banacibwîra endêko ya bene Israheli yoshi, mpu: «Ecihugo rhwageziremwo coshi nti rhucilorereze, ciri cihugo cinjà bwenê. ");
INSERT INTO shr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nka Nyamuzinda arhurhonyize yêne anarhuhêka muli ecôla cihugo, anarhuheco, ciri cihugo cadubukamwo amarhà n’obûci. ");
INSERT INTO shr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ci kwônene murhahîra mukagomera Nyamubâho, murhanayôbohaga abantu abantu bali muli ecôla cihugo, bulya rhwabahungumula, owakazâgibalanga acîyegwîre kuli bo, na Nyamubâho ali haguma nîrhu, murhabayobôhe.» ");
INSERT INTO shr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Olubaga lwoshi lwahiga mpu lukola lwababanda amabuye, ci agôla mango irenge lya Nyamubâho lyanacîyêrekana oku Ihêma ly’embugânano embere za Bene Israheli boshi. ");
INSERT INTO shr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nyamubâho anacibwîra Mûsa, erhi: «Kuhika mangaci erhi lwanabula okunyêmêra n’obwôla ludwîrhe lwabona ebisômerîne ndwîrhe najira ekarhî kâbo. ");
INSERT INTO shr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nkolaga naluhunikakwo ecihûsi, mmbamalîre, wêne mbè we njira ishanja linene kulusha na lizibu kulusha eri.» ");
INSERT INTO shr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mûsa anacibwîra Nyamubâho, erhi: «Abantu b’e Mîsiri bayishi oku okuboko kwâwe kudârhi warheremagyamwo abâla bantu kurhenga emwâbo, n’okwôla bakumanyisize abantu b’ecôla cihugo. ");
INSERT INTO shr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Boshi bayishi oku w’oyu Nyamubâho, ôbà ekarhî k’olu lubaga; oku onakazicîyêrekana emwâbo busù oku busù, w’oyu Nyamubâho; bayishi oku ecitù câwe cibà enyanya zâbo, bayishi oku onakazigenda embere zâbo mûshi omu nkingi y’omuliro. ");
INSERT INTO shr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Erhi wankayîrha olu lubaga luhungumuka nka muntu muguma, amashanja gayumvagya ebyadesirwe kuli we gakolaga gayishiderha erhi: ");
INSERT INTO shr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Nyamuzinda arhali agwêrhe obuhashe b’okuhêka olubaga muli cirya cihugo alagânanaga mpu abahà co; banaderha mpu co cirhumire abayirhira muno irungu.» ");
INSERT INTO shr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Obuhashe bwa Nyakasane buyêrekanage bunôla oku bunabà bunene, nka kulya wanamanyisagya erhi oderha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«Nyamubâho akêreza omu kukunira, abà na mugale omu bwinjà, anababalire amabî n’ecâha; ci arhankalola omuntu oli n’ecâha nka muntu mwêru kwêru, anahanire obubî bw’ababusi oku bâna bâbo, ciru n’oku bâna b’iburha lya kasharhu n’iburha lya kani. ");
INSERT INTO shr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","“Yâgirwa, obabalire olûla lubaga kuli obûla bubî lujizire erhi bwonjo bwâwe bunji burhuma, obabalire nk’oku onayôrha obabalira olûla lubaga kurhenga e Mîsiri kuhika hanôla”». ");
INSERT INTO shr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Nyamubâho anacishuza, erhi: «Nababaliraga nk’okwôla onasengire; ");
INSERT INTO shr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“Ci, mbà nzîne! N’irenge lya Nyamubâho lyabumba igulu lyoshi!” ");
INSERT INTO shr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","“Abantu boshi babwîne irenge lyâni n’ebisômerîne najiraga e Mîsiri na omw’irungu, abantu bamantangula kali ikumi, barhanyumva izù lyâni”, ");
INSERT INTO shr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","“abôla boshi barhabone kwo cirya cihugo nalaganyagya n’endahiro ababusi bâbo. Ntâye ciru n’omuguma muli balya bangayaguzagya wacilolakwo”. ");
INSERT INTO shr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","“Ci mwambali wâni Kalebu yeki, waligwêrhe gundi gundi mûka, anayôsire acîshwêkire kuli nie, namuhisa muli ecôla cihugo alijîre, n’iburha lyâge lyaciyimamwo”. ");
INSERT INTO shr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","“Omu­nya-Maleki, n’omunya-Kanâni bayûbasire omu kabanda: irhondo, moyo muhindamuke, mujè omw’irungu, omu njira y’ebwa nyanja ndukula”». ");
INSERT INTO shr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nyamubâho ashambâza Mûsa n’Aroni, ababwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Kuhika mangaci erhi nanayôrha nalembera olûla lubaga luli ntyâla, olwakaziyôrha lwacîduduma kuli nie. Nayumvîrhe eyôla midudumo ya bene Israheli kuli nie. ");
INSERT INTO shr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ogendibabwîra oku mbà nzîne! Nyamubâho okudesire: namujirira nk’okwôla mwanaderheraga omu marhwiri gâni. ");
INSERT INTO shr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ebirunda binyu munôla irungu byahungumukira. Mweshi mwe mwajiriragwa omubalè erhi muganjwa kurhenga oku wa myâka makumi abirhi kuhêka enyanya, mwe mwanacîdudumiraga kuli nie. ");
INSERT INTO shr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Murhahike muli cirya cihugo nalagânanaga nti najimuhiramwo, okuleka Kalebu mwene Yefunè na Yozwè, mwene Nuni. ");
INSERT INTO shr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","N’abâna binyu barhôrho balya mwaderhaga mpu bakola bajibà nsimha za kuyîrhwa! Niehe nabahêka muli ecôla cihugo, bamanya ecôla cihugo mwagayaguzagya. ");
INSERT INTO shr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ebirunda binyu mw’oyo, munôla irungu byahungumukira; ");
INSERT INTO shr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","n’abâna hinyu bayabukana amasò gâbo munôla irungu, myâka makumi anni, bo bahêka ntyo obuhane bw’okubula obuyêmêre kwinyu, kuhika ebirunda binyu bihwêre munôla irungu. ");
INSERT INTO shr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kulya mwagezagya nsiku makumi anni mwaja mwalolêreza ecihugo, ntyo kwo ensiku zàli, kwo n’emyâka yâbà: mwabarhula amabî ginyu myâka makumi anni. Mwanayumviza ahôla okucîberûla kuli nie bunguke buci kulêrha. ");
INSERT INTO shr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Niono nie Nyamubâho, nkudesire! Alaga oku najirira eyi ndêko mbî yacîhindulaga kuli nie: boshi bahwêra munôla irungu, mwo bafîra.» ");
INSERT INTO shr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Balya bantu Mûsa arhumaga mpu bajè balolêreza ecihugo na erhi bagaluka bàrhuma olubaga loshi lucidudumira Nyamubâho, ");
INSERT INTO shr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","abôla bantu bàjaga baderha kubî kuli ecôla cihugo, abôla bantu bàbandwa n’olufù ho na halya, e­ mbêre za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Yozwè, mwene Nuni na Kalebu mwene Yefunè bône bafumire olufù muli balya bajagiyenja ecihugo. ");
INSERT INTO shr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mûsa anacihêkera bene Israheli boshi ebyôla binwa; olubaga lwoshi lwanaciluha bwenêne. ");
INSERT INTO shr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Erhi babà bamazukiriza sêzi sêzi, bakanya, basôkera ebw’irhwêrhwè ly’entondo, banaciderha, mpu: «Rhwonôla! rhukolaga rhwasôkera eyôla munda Nyamubâho anaderhaga ebwa kubà rhwajizire ecâha.» ");
INSERT INTO shr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mûsa ababwîra, erhi: «Carhuma mugendivuna irhegeko lya Nyamubâho? Okwôla kurhamubêre. ");
INSERT INTO shr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Murhasôkeraga eyôla bulya Nyamubâho arhali ekarhî kinyu! Mumanye mwene mwarhuma mugendihimwa n’abashombanyi binyu. ");
INSERT INTO shr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bulya omunya-Maleki na omunya-Kanâni bali embere zinyu, mwahungumukira eyôla n’engôrho ebwa kubà mwacîberwîre kuli Nyamubâho; Nyamubâho arhâbè haguma ninyu.» ");
INSERT INTO shr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Baharha mpu bônene n’emisî yâbo basôkera oku ntondo; ci omucîmba gw’amalaganyo ga Nyamubâho na Mûsa, gurhafukunyagya omu karhî k’ecihando. ");
INSERT INTO shr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Oku bundi, balya banya-Maleki n’Abanya-Kanâni bayûbakaga omwôla ntondo babunguluka, babahima, babarhema bihimbi bihimbi kuhika aha Horma. ");
INSERT INTO shr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Nyakasane anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Ogendidesa bene Israheli, obabwîre, erhi: Amango mwahika muli cirya cihugo mwagendibêra, ciryala cihugo namuhà, ");
INSERT INTO shr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","“na nka mukola mwarherekêra Nyamubâho enterekêro yajirwa n’omuliro, ebè ya nsirîra, ebè yindi nterekêro y’okuyunjuliza muhigo mulebe, nîsi erhi nterekêro y’obulonza bw’omuntu konene, kandi erhi ebè nterekêro y’amango g’ensiku nkulu zinyu, mpu lyo, omu kurherekêra enkafu zinyu kandi erhi bibuzi binyu, muhasha okuhêra Nyamubâho enterekêro y’akisûnunu kinjà”. ");
INSERT INTO shr_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“Omuntu oyishire okuhâna enterekêro yâge emunda Nyamubâho ali, anahira enterekêro y’enkalangè, cihimbi ciguma ca kali ikumi c’enshâno y’omulà n’ecigabi ca kani ca ehîni y’amavurha”. ");
INSERT INTO shr_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","“Wanajira enterekêro y’embulaga na cigabi ciguma ca kani c’ehîni ya idivayi, haguma n’enterekêro y’e­ nsirîra n’enterekêro y’omurhûla oku ngasi mwâna-buzi”. ");
INSERT INTO shr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Oku nterekêro y’engandabuzi, wanahâna bihimbi bibirhi bya kali ikumi by’enshâno y’omulà oku nterekêro y’enkalangè, ci eyôla nshâno ebè mvange n’amavurha”. ");
INSERT INTO shr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","“Oku nterekêro y’e mbulaga, wanahâna cihimbi ciguma ca kasharhu c’ehîni y’idivayi, ebè nterekêro y’akisûnunu kinjà embere za Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Erhi wankarherekêra empanzi, akabà eri ya nterekêro y’ensirîra, kandi erhi ya kuyûkiriza muhigo mulebe, nîsi erhi ebè nterekêro yâwe ya murhûla wahà Nyamubâho”, ");
INSERT INTO shr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","“haguma n’eyôla mpanzi wanarherekêra, nka nterekêro ya nkalange, bihimbi bibirhi bya kali ikumi by’enshâno y’omulà mvange n’ecihimbi ca kabirhi c’ehîni y’amavurha”. ");
INSERT INTO shr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","“Wanahâna n’ecihimbi cakabirhi c’ehîni y’idivayi, nka nterekêro y’embulaga: erhi nterekêro ejizirwe n’omuliro, nterekêro ya kisununu kinjà e­mwa Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Kwo bakazijira ntyôla oku ngasi mpanzi, oku ngasi ngandabuzi, n’oku ngasi mwâna-buzi erhi omwânahene”. ");
INSERT INTO shr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","“Oku mubalè gw’ebintu warherekêra gunali kwo nâwe wankanajira ngasi ciguma omu kushimba kulya omubalè gwâbo gunali”. ");
INSERT INTO shr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Ngasi mwambali winyu naye kwo akazijira ntyôla, amango abâna e­nterekêro yasirizibwa, nka nterekêro ya kisununu kinjà emwa Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","“Erhi akabà hali ecigolo mwayêmêrîre okuyûbaka haguma ninyu, kandi erhi abè mubunga mukola mubà naye hamagera emyâka n’emyâka, erhi oyôla akâlonza okuhâna enterekêro, kulya mujira kwo naye agwâsirwe okujira”. ");
INSERT INTO shr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","“Irhegeko lyabà liguma oku lubaga loshi, kuli mwe mweshi, kuguma n’ecigolo ciyûbasire emwinyu, lyabà irhegeko, oku ngasi iburha linyu lyoshi: oku cigolo na kuli mwe mwene, mweshi mwanakazijirirwa kuguma embere za Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","“Irhegeko lyabà liguma lyonene, n’engeso yâbà nguma yonene, oli kuli mwe, oli oku cigolo ciyûbasire emwinyu.”» ");
INSERT INTO shr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Nyamubâho anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Ogendidesa bene Israheli obabwîre, erhi: ");
INSERT INTO shr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","“Amango mwahika muli cirya cihugo nagendimuhira, na nka mukola mwakazilya omugati gw’ecôla cihugo, mwanaberûlakwo enterekêro ya Nyamubâho” ");
INSERT INTO shr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","“Nka nterekêro ntangiriza, mwanaberûla oku buntu bw’omugati gwinyu, buntu bwa mugati muguma, mwanagurherekêra nka nterekêro ntangiriza y’oku câno cinyu”. ");
INSERT INTO shr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","“Kwo mwanakaziyôrha mwajira ntyôla oku buntu burhangiriza bw’omugati gwinyu, mwanaberûlakwo enterekêro ya Nyamubâho, mukaziyôrha mwajira ntyôla mwoyo na iburha linyu”». ");
INSERT INTO shr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Erhi mwankajira ecâha omu kuhabuka bulya murhashimbaga galya marhegeko gâni namuhâga kuli Mûsa, ");
INSERT INTO shr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","“ngasi oku Nyamubâho anamurhegesire koshi erhi arhuma Mûsa kurhenga kwa lulya lusiku Nyamubâho amuhâga amarhegeko gâge na ngasi ganakulikire omu maburhwa ginyu goshi”, ");
INSERT INTO shr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","“ntya kwo byâbà: akabà mwajizire ecâha buzira kumanya, olubaga loshi lwanarherekêra empanzi ntôrhò nka nterekêro ya nsirîra ya kisununu kinjà embere za Nyamubâho, kuguma n’enkalangè yâge, na embulagwa yâge, mwanajira nka kulya muyôrha murhegesirwe okujira, kandi mwanayûshûlakwo enterekêro y’ecihebe oku câha”. ");
INSERT INTO shr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“Omudâhwa anajira enterekêro y’okuhyûla oku lubaga loshi lwa bene Israheli, na ntyôla ecôla câha canababalirwa kuli bo, bulya ciri câha cajiragwa omu kuhabuka. Kandi nka bamahâna enterekêro yâbo, enterekêro yajiragwa n’omuliro embere za Nyamubâho, barherekîre Nyamubâho oku byâha, erhi ecôla câha câbo cirhuma, eci bajiraga omu kuhabuka”, ");
INSERT INTO shr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","“ecôla câha canababalirwa kuli bene Israheli boshi, n’oku cigolo cibayûbasire ekarhî, bulya kwàli kubabuka”. ");
INSERT INTO shr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Erhi akabà muguma yênene wajizire ecôla câha c’okuhabuka, oyôla muntu anarherekêre empene ya mwâka muguma oku nterekêro y’ecâha”. ");
INSERT INTO shr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","“Omudâhwa anajira enterekêro y’okuhyûla embere za Nyamubâho, kuli olya muntu wababukaga erhi ajira ecâha; nka bamamujirira eyôla nterekêro y’oku­ hyûla, ecôla câha canamubabalirwa”, ");
INSERT INTO shr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","“abè mwene Israheli erhi cigolo. Mwâbà n’irhegeko liguma erhi hankajira owajira ecâha omu kuhabuka”. ");
INSERT INTO shr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Cikwônene erhi hankabà owundi, mwene Israheli nîsi erhi cigolo, oyôla akagayisa Nyamubâho n’oluhinzo, akagwe omu lubaga lwâge”. ");
INSERT INTO shr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","“Bulya anagayagusize akanwa ka Nyamubâho, anabula bwashimba irhegeko lyâge: oyôla muntu akagwe, obubî bwâge kuli ye yêne.”» ");
INSERT INTO shr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Mw’agôla mango bene Israheli banali omw’irungu, bashimâna muntu muguma adwîrhe arhôla enshâli olwa Sabato. ");
INSERT INTO shr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Abôla bashimânaga adwîrhe arhôla enshâli, bamuhêka emunda Mûsa ali, emunda Aroni ali n’olubaga. ");
INSERT INTO shr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Banacijira abamulanga, bulya oku ankajirwa ntâye ocikumanya. ");
INSERT INTO shr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Nyamubâho anacibwîra Mûsa, erhi: «Oyôla muntu afè! Olubaga lwa bene Israheli loshi lumubande amabuye embuga ly’ecihando». ");
INSERT INTO shr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Erhi olubaga loshi lubà lwamamurhenza omu cihando, lwamubanda amabuye, anacifà nka kulya Nyamubâho anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Nyakasane abwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Ogendidesa bene Israheli, obabwîre bakazihira obushemberêre oku mihiro y’ebishûli byâbo, kurhenga okw’iburha kujà oku lindi, n’oku bushemberêre bwa ngasi muhiro bahirekwo ehigozi y’akaduku k’omukara. ");
INSERT INTO shr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mwabà ntyo n’obushemberêre; omu kubulolakwo, mwanakengêra galya marhegeko ga Nyamubâho goshi lyo mugashimba; mumanye mwankakulikira enyifinjo z’emirhima yinyu erhi ez’amasù ginyu gakazimukululira ebwa kujira kubî. ");
INSERT INTO shr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ntyôla mwakazikengêra amarhegeko gâni goshi, munagashimbe, na ntyo mwanabà bimâna emwa Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nie Nyamubâho, Nyamuzinda winyu, owamakûlaga omu cihugo c’e Mîsiri, lyo nyôrha niene Nyamuzinda winyu. Nie Nyamubâho, Nyamuzinda winyu. ");
INSERT INTO shr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korè, mwene Yishari, ya Kehati, ka Levi bona Datani n’Abirami bene Eliyabu, na Honi mwene Peleti, Eliyabu na Peleti bàli bene Rubeni, bajamo obucîbone; ");
INSERT INTO shr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","bacîhindulira Mûsa; bashimânwa na bandi bantu magana abirhi na makumi arhanu b’omu bene Israheli, barhambo b’olubaga, bantu b’irenge na bakengwa. ");
INSERT INTO shr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Bashûbûzanya oku kulongôza Mûsa n’Aroni, banacibabwîra, mpu: «Rhwamarhama ninyu, bulya olubaga lwoshi, abantu boshi bali bimâna, na Nyamubâho ali ekarhî kâbo. Cankarhuma mweki mucikuza enyanya ly’olubaga lwa Nyamubâho?» ");
INSERT INTO shr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Erhi Mûsa ayumva okwôla, akumba bûbi. ");
INSERT INTO shr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Abwîra Korè n’omurhwe gwâge, erhi: Irhondo, Nyamubâho amanyîsa oli wâge n’oli mwimâna, yêne anamuyegeza hôfi naye, oyu acîshozire yêne anamushegeza hôfi naye. ");
INSERT INTO shr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Mujirage ntyâla: Murhôle ebitumbûkizo, Korè n’omurhwe gwâwe goshi. ");
INSERT INTO shr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Irhondo, muhiremwo omuliro, munahire enshangi oku nyanya embere za Nyamubâho, oyu Nyamubâho akanacîshoga, oyôla yenali mwimâna. Namarhama ninyu bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mûsa anacibwîra Korè, erhi: «Yumvagi bene Levi. ");
INSERT INTO shr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ka emwinyu, kuli kunyi okûla Nyamubâho amwishogaga omu karhî ka bene Israheli boshi, amuhira hâgo hâgo mpu mukazimuyegêra munakazikola omu ndâro ya Nyamubâho, n’okuyimangira olubaga omu mukolo gwâlo? ");
INSERT INTO shr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Akushegezize hôfi naye, woyo na bene winyu boshi, bene Levi, haguma nâwe, lêro bukolaga budâhwa mwalonza. ");
INSERT INTO shr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Okwôla kwo kurhumire we n’omurhwe gwâwe muyishijira ihano y’okucîhindula kuli Nyamubâho! Aroni aligi muntu muci obûla mwacîduduma kuli ye?» ");
INSERT INTO shr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mûsa arhuma mpu bahamagale Datani n’Abirami mwene Eliabu; banacishuza mpu: «Rhurhasôkera eyo». ");
INSERT INTO shr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ka kuli kunyi erhi orhurhenza omu cihugo cahululaga amarhà n’obûci n’okuyishirhuyîrhira munôla irungu; kandi wacikûnga mpu we nnawîrhu? ");
INSERT INTO shr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","«Mâshi arhali omu cihugo cihulula amarhà n’obûci warhuhesire, arhali mashwa ga mizâbîbu warhuhîre mpu rhugayîmemwo! Ka omanyire mpu olûla lubaga walujira mihûrha? Rhurhasôkere eyôla munda!» ");
INSERT INTO shr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Omu bukunizi bunene, Mûsa anacibwîra Nyamubâho, erhi: «Orhalolaga e­nterekêro yâbo y’enkalangè. Ntasagibanyaga ciru na oli endogomi yâbo, ciru na ntâye nkola njirire amabî muli bo.» ");
INSERT INTO shr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mûsa anacibwîra Korè, erhi: «We n’omurhwe gwâwe, irhondo mubonekane embere za Nyamubâho, we nabo na Aroni. Murhôle ngasi muguma ecitumbûkizo cinyu ");
INSERT INTO shr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Muhiremwo enshangi, munagendihêka ngasi muguma ecitumbûkizo câge emunda Nyamubâho ali: biri bitumbûkizo magana abirhi na makumi arhanu; nâwe wêne kuguma n’Aroni, murhôle ngasi muguma ecitumbûkizo câge.» ");
INSERT INTO shr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Banacirhôla ngasi muguma ecitumbûkizo câge, banacihira­ mwo omuliro, banahira enshangi oku nyanya, bagendiyimanga aha muhango gw’ihêma ly’embugânano, boshi na Mûsa n’Aroni. ");
INSERT INTO shr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korè ali erhi anahamagîre olubaga loshi oku kucîhindulira Mûsa n’Aroni aha Ihêma ly’embugânano. Okubundi irenge lya Nyamubâho lyabonekera olubaga loshi. ");
INSERT INTO shr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","«Nyamubâho adesa Mûsa n’Aroni, ababwîra erhi: ");
INSERT INTO shr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Muciyegûle kuli olu lubaga, nkola naluherêrekeza buno buno.» ");
INSERT INTO shr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Banacikumbira akamalanga, baderha mpu: «Mâshi yâgirwa Nyamuzinda, we Nyamuzinda wa ngasi mûka gwa muntu, muntu muguma oyûla wadwîrhe oku kubî, na bunôla mpu okolaga wakunirira olubaga loshi» ");
INSERT INTO shr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nyamubâho ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Ogendibwîra olubaga, erhi: “Murhenge eburhambi bw’aha mwa Korè, Datani na Abirami.”» ");
INSERT INTO shr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mûsa ayimuka anacijà emunda Datani n’Abirami bali; n’abagula b’Israheli bayisha bamukulikire. ");
INSERT INTO shr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Adesa olubaga loshi aderha, erhi: «Mujè kuli n’enyumpa za bala bantu babî, mumanye murhanahumaga oku ngasi kalugu kâbo, lyo ninyu mulekiherêrekera nka mwamazingazingwa n’ebyâha byâbo». ");
INSERT INTO shr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Barhenga eburhambi bw’aha mwa Korè. Datani n’Abirami erhi bali embuga, bayimanzire aha muhango gw’amahêma gâbo, na bakâbo, n’abâna bâbo bakulu n’abarho boshi. ");
INSERT INTO shr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mûsa anaciderha, erhi: «Mukolaga mwamanya oku Nyamubâho wanantumaga okukazijira eyîra mikolo yoshi n’oku ntayijira oku i­rhwe lyâni niene. ");
INSERT INTO shr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","“Abâla bantu bakafà nk’oku abandi bantu banayôrha bafà, n’akalamo kâbo kakayûrha nk’oku akalamo k’abandi bantu kanayûrha, erhi arhanali Nyamubâho wantumaga”. ");
INSERT INTO shr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","“Ci erhi Nyamubâho akajira akantu karhuma abandi bantu bazânwa, erhi idaho lyankayashamya akanwa kalyo, likanabamirangusa boshi kuguma n’ebintu byâbo byoshi, erhi bankayandagalira ekuzimu banazîne, aho nêci mwanamayira ho oku abâla bantu banajacire Nyamubâho”». ");
INSERT INTO shr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Oku anayûsiderha ebyôla binwa byoshi, obudaka bàli bayimanzirekwo bwanacihahanyuka, ");
INSERT INTO shr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","idaho lyayashamya akanwa kalyo, lyanacibamirangusa n’emilala yâbo, kuguma na bene Korè boshi n’ebintu byâbo byoshi. ");
INSERT INTO shr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Bayandagalira ekuzimu banacizîne, bo na ngasi hyanali hyâbo hyoshi: idaho lyanacibafûnika, bahirigirha embere z’olubaga ");
INSERT INTO shr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Bene Israheli bàli eburhambi boshi, bakumbiranya, bakola bayâka, banajà bayâma, banaderha mpu: «Rhuyàke, lyo nîrhu idaho lilekirhumirangusa!» ");
INSERT INTO shr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Omuliro gwanacimanuka emwa Nyamubâho gwamirangusa balya bantu magana abirhi na makumi arhanu bajagitumula enshangi. ");
INSERT INTO shr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Nyamubâho ashambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Obwîre omudâhwa Eleazari, mwene Aroni, arhenze ebitumbûkizo omu bwihîrà, onakabulire kulî omuliro gulimwo, ");
INSERT INTO shr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","“bulya ebi bitumbûkizo oku byâha biri bigishe. Ebitumbûkizo by’abôla bantu, abahemukiraga obuzîne bwâbo bônene, bajiremwo enambûle ndîrî, zikazibwikira oluhêrero lw’enterekêro y’ensirîra; bulya byarherekîrwe Nyamubâho, binakolabigishe, byayôrha ntyôla cimanyîso kuli bene Israheli.”» ");
INSERT INTO shr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Omudâhwa Eleazari arhôla birya bitumbûkizo by’omulinga byakolêsiba­gwa na balya bantu bamirangusibagwa n’omuliro, ajiramwo enambûle z’okukazibwîkira oluhêrero. ");
INSERT INTO shr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Bene Israheli bayôrha bamanyire oku ntà muntu w’embuga orhali w’omu bûko bwa Aroni, wakacîshomya mpu ayegêra arherekêre Nyamubâho enshangi, anabule okubà aka Korè n’omurhwe gwâge nk’oku Nyamubâho anamumanyisagya omu kanwa ka Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Erhi buca, olubaga loshi lwa bene Israheli lwarhondêra lwacîdudumira Mûsa na Aroni, lwakaziderha mpu: «Mwayisize olubaga lwa Nyamubâho.» ");
INSERT INTO shr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ebwa kubà olubaga lwàli lwamagôrha Mûsa n’Aroni, bombi bayêrekera e­ bw’Ihêma ly’embugânano, ecitù calibwîka n’irenge lya Nyamubâho lyaboneka. ");
INSERT INTO shr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mûsa na Aroni bakanya bajà ebw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nyamubâho anacishambâza Mûsa aderha erhi: ");
INSERT INTO shr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Orhenge muli olu lubà­ga, nkola naluhirigisa buno buno.» Bombi banacikumba bûbi. ");
INSERT INTO shr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mûsa anacibwîra Aroni, erhi: «Rhôla ecitumbûkizo, ohiremwo omuliro gw’oku luhêrero, ohirekwo n’enshangi, okanye duba emunda olubaga luli, ogendilujirira empyûlo; bulya oburhè bwa Nyamubâho bwamayâka. Ecibande camarhangira.» ");
INSERT INTO shr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aroni arhôla ecitumbûkizo, nk’oku Mûsa anaderhaga, alibirhira omu karhî k’olubaga. Ecibande càli camarhondera ekarhî k’olubaga. Ahira enshangi omu citumbûkizo, ajira enterekêro y’empyûlo oku lubaga. ");
INSERT INTO shr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ajiyimanga ekarhî k’abamafà n’abazîne; aho Ecibande cacîkwa. ");
INSERT INTO shr_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Bantu bihumbi ikumi na bini na magana gali nda bafà n’ecôla cibande, buzira kuganja abafàga erhi Korè orhuma. ");
INSERT INTO shr_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Aroni ashubira emunda Mûsa ali ah’Ihêma ly’embugânano, n’Ecibande erhi camacîkwa. ");
INSERT INTO shr_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Nyamubâho ashambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Ogendibwîra bene Israheli bakuhè orhurhi, ngasi bûko karhikaguma, rhwo rhuligi rhurhi ikumi na rhubirhi rhwalerhwa n’abarhambo bâbo boshi kulya emilala yâbo enali ikumi n’ibirhi. Oyandike izîno lya ngasi muguma oku karhî kâge. ");
INSERT INTO shr_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","“Oyandike izîno ly’Aroni oku karhî ka Levi, bulya ngasi murhambo akazibà na karhî kaguma kulya emilala yâbo enali”. ");
INSERT INTO shr_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","“Oyishidekereza orhôla rhurhi omw’Ihêma ly’embugânano embere z’omucîmba gw’amalaganyo, halya nkazishimânana nâwe”. ");
INSERT INTO shr_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","“Omuntu ncîshozire, ayishiba olya akarhi kâge kajirekw’obwâso, na ntyo, nanayûsa embere zâni erya midudumo bene Israheli bakazimujirakwo”». ");
INSERT INTO shr_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Mûsa agendishambâla na bene Israheli, n’abarhambo bâbo boshi bakazimulerhera karhî kaguma, nk’oku emilala yâbo enali, kwo kuderha rhurhi ikumi na rhubirhi, n’akarhi ka Aroni karhulimwo. ");
INSERT INTO shr_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Mûsa adêkereza orhôla rhurhi embere za Nyamubâho, omw’lhêma ly’obubamîrizi. ");
INSERT INTO shr_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Erhi buca Mûsa ashubira ebw’Ihêma ly’obubamîrizi, akarhi k’Aroni kajirekwo obwâso, kaligi k’obûko bwa Levi: ako karhî kàli kamajakwo amafufu, kàli kamayâsa, erhi kamanajakwo amalehe. ");
INSERT INTO shr_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Mûsa ayisha ahulukîne rhulya rhurhi rhwoshi rhwàli embere za Nyamubâho, arhuhira embere za bene Israheli boshi, babona na ngasi muguma arhôla akarhi kâge. ");
INSERT INTO shr_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Nyamubâho abwîra Mûsa erhi: «Oshubize akarhi ka Aroni aha Mucîmba gw’amalaganyo, kakazilangwa nka buhamîrizi emwa ngasi boshi bankalonza okucîhindula, na ntyôla okucîduduma kwâbo kwanahwa emunda ndi, banalekifa». ");
INSERT INTO shr_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Mûsa anacijira kulya, anacijira nk’oku Nyamubâho àlimurhegesire. ");
INSERT INTO shr_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Bene Israheli banacibwîra Mûsa mpu: «Lolà oku rhwamafa, rhwamahwa rhweshi. ");
INSERT INTO shr_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Ngasi yêshi wakaziyegêra Endâro, adwîrhe afà. Ka kukwaninage rhweshi rhufè obwo?» ");
INSERT INTO shr_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Nyamubâho anacibwîra Aroni, erhi: «W’oyu na bagala bâwe, haguma n’enyumpa ya sho, mwe mwatumula obubî bwankajirwa ahantu himâna; we na bagala bâwe, mwakazidôsibwa oku bubî bwankajirwa omu mukolo gwinyu gw’obudâhwa. ");
INSERT INTO shr_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","“Ci na bene winyu kuguma, ab’omu bûko bwa Levi, ab’omu mulala gwa sho, obayegeze hôfi nâwe bakazikukolera banakazikurhabâla amango we na bagala bâwe muli omu mirimo yinyu y’omw’Ihêma ly’obuhamîrizi”. ");
INSERT INTO shr_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","“Bakazikurhabâla oku mikolo yâwe yoshi nk’oku mikolo y’Ihêma ly’embugânano. Ci bamanye bankanayegêra ebintu bimâna, erhi oluhêrero, mulekifa oli we oli bo”. ");
INSERT INTO shr_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","“Bakazikugwâsa, bakazikola omu mikolo y’Ihêma ly’embugânano, oku ngasi mikolo enayêrekîre Ihêma. Ci ntà w’embuga wankayegêra”. ");
INSERT INTO shr_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Mukazikola omu hantu himâna n’oku luhêrero, lyo oburhè bw’okushimbulira bene Israheli buhwa”. ");
INSERT INTO shr_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","“Nie narhôzire bene winyu Baleviti ekarhî ka bene Israheli; abahâbagwa Nyamubâho we okola obahâbirwe mpu bakazijira omukolo gw’omw’lhêma ly’embugânano”. ");
INSERT INTO shr_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","“We na bagala bâwe, omukolo gwinyu gw’obudâhwa gwabà oku ngasi biyêrekîre oluhêrero n’ebiri enyuma ly’ecisîka, mwakazijira ogwôla mukolo. Mwakazijira omukolo gw’oburherekêre, bulya muli badâhwa. Ow’embuga wankacîshomya mpu ayegêra, anafè”». ");
INSERT INTO shr_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Nyamubâho anacibwîra Aroni, erhi: «nakuhîre omukolo gw’oku ngasi binamberûlîrwe. Ebintu birherekêre bya bene Israheli, nkuhîre byo we n’abâna bâwe nka ngalo ya ngasi mango. ");
INSERT INTO shr_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","“Alaga ebyakaziba byâwe omu bintu bimâna bwenêne, omu biryo birherekêre: entûlo zoshi za bene Israheli bakazizingalulira, enterekêro z’enkalangè zoshi, enterekêro zâbo zoshi oku byâha n’enterekêro zâbo zoshi z’empongano bakanayîshikampa zoshi: ebyôla byoshi nka bintu bimâna bwenêne, byâbà byâwe kuli we n’oku bagala bâwe”. ");
INSERT INTO shr_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","“Wakalya ebimâna bwenêne; ngasi mulume akazibiryako. Obikenge bwenêne”. ");
INSERT INTO shr_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“N’ebîra nabyo byakaziba byâwe: ngasi ebi banaberwîre oku ntûlo zâbo, oku ngasi nterekêro z’okumogamoga za bene Israheli; nkuhîre byo we na bagala bâwe na bâli bâwe, n’eryôla liri irhegeko ly’ensiku n’amango; ngasi ocîre w’omu mwâwe, anahasha okubiryako”. ");
INSERT INTO shr_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ngasi mavurha minjà bwenêne bahâna, ngasi idivayi linjà bwenêne bahâna, lihyâhya, erhi ngano, ebirhangiriza by’emyâka yâbo balibirherekêra Nyamubâho, ebyôla nkuhîre byo”. ");
INSERT INTO shr_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","“Ngasi bya mburho yâbo mpyâhya bankanahumbûla omu cihugo câbo mpu babirherekêre Nyamubâho, ebyôla byoshi nabyo nkuhîre byo. Ngasi yêshi onali acîre omu mwâwe anabiryakwo”. ");
INSERT INTO shr_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Ngasi byoshi birikwo obuhane omu Israheli, ebyôla biri byâwe nabyo”. ");
INSERT INTO shr_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Ngasi wa bûko lubere abè wa bantu, abè wa cintu, birya banahà Nyamubâho, ebyôla byâbà byâwe. Ci kwônene wanakazigombôla olubere lw’omuntu, n’olubere lw’ecintu cigalugalu”. ");
INSERT INTO shr_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","“Wanabigombôlera oku mwêzi muguma biri biburhe, wêne wankaderha ecitwîro, sikêli irhanu z’ecûma c’olunyerere omu kuzigerera oku sikêli y’ahantu himâna, erya ya gêra makumi abirhi”. ");
INSERT INTO shr_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ebirhagombôlwa by’ebi: olubere lw’e­ nkâfu, olubere lw’ebibuzi, olubere lw’empene ebyôla biri bimâna. Okazibulagira omukò gwâbyo oku luhêrero n’amashushi gâbyo wanagayôca gatumbûke mugî: eri nterekêro yajirwa n’omuliro ya kisununu kinjà embere za Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","“N’enyama zâbyo ziri zâwe, gulya mushaya bamogamoga n’okugulu kulyo”. ");
INSERT INTO shr_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Ebi bene Israheli baberûlira Nyamubâho oku bintu bimâna nkuhirebyo we na bagala bâwe na bâli bâwe. N’eryo liri irhegeko ly’ensiku n’amango, eri ndagâno nnunge y’ensiku zoshi, embere za Nyamubâho kuli we n’okw’iburha lyâwe mweshi.”» ");
INSERT INTO shr_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Nyamubâho anacibwîra Aroni, erhi: orhâbè n’akashambala omu cihugo câbo, na ntà cigabi ciru n’eciguma cankaderhwa mpu câwe ekarhî kâbo. Niehe nie cigabi câwe nie na kashambala kâwe ekarhî ka bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Alà oku bene Levi mbahire nka kashambala entûlo yoshi y’omu Israheli, kuli erya mikolo yâbo banajira omw’lhêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Bene Israheli barhankaciyegêra Ihêma ly’embugânano, kwanabà kucîbarhuza ecâha cankarhuma bafà. ");
INSERT INTO shr_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Bene Levi bo bakazijira emikolo y’omw’Ihêma ly’embugânano na bône bankabarhula obubî bwâbo. Irhegeko ly’ensiku n’amango libahanzize okubà (libasêzize okurhâbà) n’akashambala ekarhî ka bene Israheli ");
INSERT INTO shr_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Bulya bene Levi, akashambala kâbo, mbahire era ntûlo bene Israheli baberûlira Nyamubâho. Co carhumaga nababwîra nti barhabè n’akashambala ekarhî ka bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Nyamubâho ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Ogendishambâza bene Levi obabwîre, erhi: Amango mwahâbwa na bene Israheli entûlo mmuhîre nka kashambala kinyu, mwanaberûlakwo enterekêro ya Nyamubâho, eri ntûlo oku ntûlo. ");
INSERT INTO shr_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","“N’ebyôla mwaberûla, olugero lwâbyo lubè nk’olugero lw’engano baberûla oku câno, erhi nk’olugero lw’idivayi lihyâhya baberûla oku mukenzi”. ");
INSERT INTO shr_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","“Kwo mwakaziberûla ntyôla ninyu enterekêro ya Nyamubâho kuli zirya ntûlo zoshi mwakazihâbwa na bene Israheli. Eyôla nterekêro mwaberûlira Nyamubâho, mwanayiha omudâhwa Aroni”. ");
INSERT INTO shr_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","“Kuli ebi mwankanahàbwa byoshi, mwanakazirhôlakwo erya nterekêro ya Nyamubâho. Ebiri binjà bwenêne byo mwakazikûlakwo ecigabi cimâna”. ");
INSERT INTO shr_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Obabwîre erhi: nka mwamaberûla birya biri binjà bwenêne, entûlo oku bene Levi yanagererwa oku mburho y’oku câno n’oku mburho y’omu mukenzi”. ");
INSERT INTO shr_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","“Mwanabirîra ngasi hantu munalonzize hoshi mwe n’omulala gwinyu bulya lwo luhembo lwinyu olwo oku mukolo goshi mujira omw’Ihêma ly’embugânano”. ");
INSERT INTO shr_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","“Ntà câha mwankajira muli okwôla nka mwamaberûla cirya cigabi cinjà bwenêne, murhankahemula enterekêro nyinjà za bene Israheli, murhankanacifa.”» ");
INSERT INTO shr_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Nyamubâho ashambâla na Mûsa n’Aroni, aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Alaga ebinwa b’irhegeko Nyamubâho arhegesire, ene aderha erhi: Ojibwîra bene Israheli bayîshe bandwîrhîre enkâfu y’omukara, erya erhagwêrhi ishembo lici oku mubiri, erhanasagihêka omuzigo. ");
INSERT INTO shr_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Muyihekere omudâhwa Eleazari, naye anayirhenza omu cihando bagendiyibâgira embere zâge. ");
INSERT INTO shr_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Omudâhwa Eleazari anarhôla oku mukò gw’eyôla nkâfu n’omunwe gwâge, anajira nago olukangûlo kali nda olunda lw’omuhango gw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Banayôca eyôla nkâfu erhi anadwîrhe abona! banayôca oluhù lwâyo, enyama zâyo n’omukò gwâyo kuguma n’ecihò câyo. ");
INSERT INTO shr_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Omudâhwa anarhôla enshâli z’omurhi gw’omwêrezi, ez’olwifûyè n’ebindi by’akaduku; anabikwêba mulyamuliro gudwîrhe gwasingônola erya nkâfu. ");
INSERT INTO shr_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kandi anashuka emyambalo yâge, ashukire n’omubiri gwâge omu mîshi, anashubira omu cihando, ayôrhe mugalugalu kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Naye olya wayôcagya erya nkâfu, anashuka emyambalo yâge, ashukire n’omubiri gwâge omu mîshi, anayôrha mugalugalu kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Omuntu oli bwinjà anaguka lulya luvù lw’erya nkâfu, anagendilubulagira emuhanda gw’ecihando, omu hantu hinjà; bakazilubikira endêko ya bene Israheli, bakaziluhira omu mîshi g’okubayôbôla; eri nterekêro oku byâha. ");
INSERT INTO shr_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Oyu wagukaga oluvù lw’erya nkâfu anashuka emyambalo yâge, anayôrha mugalugalu kuhika bijingo. Okwôla, lyâbà irhegeko ly’ensiku zoshi oku bene Israheli n’oku muntu w’ecigolo onayûbasire ekarhî kâbo. ");
INSERT INTO shr_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Owankahuma oku mufù mulebe erhi mulebe, oyôla anabè mugalugalu nsiku nda. ");
INSERT INTO shr_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Anayishicîcêsa n’agôla mîshi olusiku lwa kasharhu n’olwa kali nda, anabà bwinjà. Ci erhi akabà arhacîcêsizi oku lusiku lwa kasharhu n’olwa kali nda, arhankabà bwinjà. ");
INSERT INTO shr_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Owankahuma oku mufù, oku mubiri gw’omuntu wamafa, akabà arhacîcêsizi, oyôla anahemula endâro ya Nyamubâho; kukwânîne akagwe omu bene Israheli. Bulya galya mîshi gakûla ebizinzire garhabulajikire kuli ye; ali mugalugalu, n’agôla mazinga gâge anagayôrhana. ");
INSERT INTO shr_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Alaga irhegeko erhi omuntu ankafira omw’lhêma. Ngasi yêshi wankajà muli eryo ihêma, na ngasi kalugu kali muli ryo, ebyôla byoshi byanabà bigalugalu kuhika nsiku nda. ");
INSERT INTO shr_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ngasi kalugu kafûnule, kalya karhagwêrhi cifûniko cisheke n’ehigozi, kânaba kagalugalu. ");
INSERT INTO shr_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ngasi yêshi wankahuma oku muntu wanigiragwa omu mashwa, erhi wundi ofîre kwônene erhi mavuha ga muntu, erhi oku cûsho, oyôla ânabà mugalugalu kuhika nsiku nda. ");
INSERT INTO shr_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Kuli oyu muntu mugalugalu, banarhôla oku luvù lw’embâgwa yasingônolagwa nka nterekêro ya mpyûlo oku byâha, banabulagirakwo n’amîshi minjà gali omu kalugu. ");
INSERT INTO shr_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Omuntu oyôsire bwinjà anayanka ebyâsi by’olwifûyè, na hano abà amabidobeza omu mîshi, anajiramwo olukangûlo oku nyumpa, oku ngasi kalugu n’oku bantu boshi banali halya, kuli omuntu wahumaga oku mavuha, erhi olya muntu bayîrhaga, erhi wundi ofîre kwônene erhi ohumire oku cûsho, ");
INSERT INTO shr_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","omuntu oli bwinjà anajira olukangûlo kuli olya oli mugalugalu, oku lusiku lwa kasharhu na olwa kali nda; anamukulira ecâha câge oku lusiku lwa kali nda. Oyôla muntu mugalugalu anashuka emyambalo yâge, naye yêne anacîshuka omu mîshi, na bijingo ânabà bwinjà. ");
INSERT INTO shr_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Omuntu wankabà mugalugalu nka arhanacîcêsizi, anakagwe omu lubaga, bulya adwîrhe ahemula ahantu himâna ha Nyamubâho; bulya galya mîshi gakûla ebizinzire garhabulajikire kuli ye: ali mugalugalu. ");
INSERT INTO shr_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kuli bo lyabà irhegeko ly’ensiku zoshi. Olya muntu wajiraga olukangûlo lwa galya mîshi gakûla ebizinzire anashuka emyambalo yâge, owankahuma oku mîshi gakûla ebizinzire, anayôrha mugalugalu kuhika bijingo. ");
INSERT INTO shr_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ehi akahumwakwo oli mugalugalu, nahyo hinabè higalugalu, n’omuntu wankahihumakwo naye anabè mugalugalu kuhika bijingo ");
INSERT INTO shr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Bene Israheli, olubaga loshi bahika omw’irungu lya Sini, omu mwêzi murhanzi. Olubaga lwanacihanda aha Kadesi. Ho Miriyamu afiraga ahôla, ho banamubishire. ");
INSERT INTO shr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Bulyâla ahôla harhàli mîshi oku lubaga, boshi banacilundûkira emunda Mûsa na Aroni bali. ");
INSERT INTO shr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Olubaga lwalongôla na Mûsa, baderha mpu: Nîrhu rhucifaga galya mango bene wîrhu bafiraga embere za Nyamubâho ka kurhàli kwabà kwo kukulu? ");
INSERT INTO shr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Carhumaga olêrha olubaga lwa Nyamubâho munôla irungu, ka mpu lyo rhugûkumukiramwo rhwe n’ebintu bîrhu? ");
INSERT INTO shr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Carhumaga orhukûla e Mîsiri, oyisha orhudwîrhe hanôla hantu habî ntyâla? Harhali hantu hankahingwa cici, harhali mutini, harhali muzâbîbu, harhali makomamanga, ciru harhali na mîshi ga kunywa? ");
INSERT INTO shr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mûsa na Aroni barhenga aha ndêko, bakanya baj’ebw’lhêma ly’e­mbugânano. Bakumba bûbi, n’irenge lya Nyamubâho lyanacibabonekera. ");
INSERT INTO shr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Nyamubâho ashambâza Mûsa aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Oyanke kalya karhî, onakanye ogendishubûza olubaga we na mwene winyu Aroni; muderheze ibuye e­ mbêre zâbo, libahè amîshi gâlyo. Wanabarhengeza amîshi omwôla ibuye; wanaha olubaga lunywe n’ebintu byâbo. ");
INSERT INTO shr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mûsa arhôla kalya karhî kali embere za Nyamubâho, nka kulya Nyamubâho anamurhegekaga. ");
INSERT INTO shr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mûsa na Aroni bashûbûza olubaga halyâla ibuye; Mûsa anacibabwîra erhi: «Yumvagi wâni bagoma! Ka rhwamurhengeza amîshi omûla ibuye?» ");
INSERT INTO shr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mûsa anacilambûla okuboko, ashûrha kabirhi kulya ibuye n’akarhi kâge: mwanacivongoboka mîshi manji, olubaga lwanywa kuguma n’ebintu byâlo. ");
INSERT INTO shr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nyamubâho anacibwîra Mûsa na Aroni erhi: «Bulya murhanyêmîre n’okunkuza embere za bene Israheli, murhahise olu lubaga mwa cirya cihugo nâluhà.» ");
INSERT INTO shr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Co cirhuma agôla mîshi gaderhwa mîshi ga Meriba, halya bene Israheli balongôlezagya Nyamubâho, naye anaciyêrekana obuhashe bwâge kuli bo. ");
INSERT INTO shr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kurhenga e Kadesi, Mûsa anacirhuma entumwa emw’omwâmi w’e Edomu mpu bagendimubwîra erhi: «Kwo adesire ntyâla mwene winyu Israheli: Omanyire amalibûko goshi rhwamashimâna.» ");
INSERT INTO shr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Balarha banacibungulukira e Mîsiri; rhwanacibêra yo nsiku mwandu. Ci bene e Mîsiri harhulibuza oli rhwe oli balarha. ");
INSERT INTO shr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Rhwanacilakira Nyamubâho. Naye anaciyumva omulenge gwîrhu; arhuma malahika mpu arhukûle eyo Mîsiri. Lolà oku rhuli buno aha Kadesi, Lugo elubibi lw’ecihugo câwe. ");
INSERT INTO shr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","«Oyêmêre rhutwikanye omu cihugo câwe; rhurhagere oli omw’ishwa, oli omu mizâbîbu; rhurhanywe ciru n’amîshi g’omu maliba gâwe; ci rhwashimbulira omulimbwa gw’ebwâmi, buzira kudungukira oli ebwa kulyo, oli ebwa kumosho, kuhika rhurhenge omu cihugo câwe coshi.» ");
INSERT INTO shr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edomu anacimushuza, erhi: «Orhâgere emwâni, akabà onakuhizire, rhwagenzikanwa n’amatumu omu nfune.» ");
INSERT INTO shr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Bene Israheli banacimubwîra, mpu: «Mâshi, omu milimbwa rhwacisôkera, erhi rhwankanywa amîshi gâwe, nie n’amasò gâni nanakujuha. Ntà cindi nkuhûnyire, okurhali kugera n’amagulu kwônene.» ");
INSERT INTO shr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edomu anacishuza, erhi: «Orhâgere.» Edomu anaciyisha arhabîre n’engabo yâge, ecibambizize bwenêne. ");
INSERT INTO shr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ntyo kwo Edomu alahiriraga Israheli okugera omu cihugo câge, naye Israheli agendicizongolokera eburhambi bwâge. ");
INSERT INTO shr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Bene Israheli, olubaga loshi, barhenga e Kadesi, bahika oku ntondo ya Hori. ");
INSERT INTO shr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Nyamubâho anacibwirira Mûsa na Aroni okwo ntondo ya Hori, e lubibi lw’ecihugo ca Edomu, erhi: ");
INSERT INTO shr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aroni akola ajiluhûkira emw’olubaga lwâge; arhaje muli cirya cihugo nahà bene Israheli, bulya murhayumvagya oku namurhegekaga aha mîshi ga Meriba. ");
INSERT INTO shr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“Orhôle Aroni n’omugala Eleazari, obasôkane oku ntondo ya Hori”. ");
INSERT INTO shr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","“Wahogola Aroni emyambalo yâge, oyiyambike omugala Eleazari. Naye Aroni ashubire omu mulala gwâge, mwo agendifira”». ");
INSERT INTO shr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mûsa anacijira nk’okwôla Nyamubâho anamurhegekaga. Banacisôkera oku ntondo ya Hori, erhi n’olubaga loshi ludwîrhe lwasinza. ");
INSERT INTO shr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mûsa ahogola Aroni emyambalo yâge, ayiyambika omugala Eleazari. Aroni afîra ntyo oku irhwêrhwè ly’entondo. Mûsa na Eleazari banaciyandagala kulya ntondo. ");
INSERT INTO shr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Olubaga loshi lwabona oku Aroni anafîre, n’enyumpa y’Israheli yoshi yanacishiba Aroni nsiku makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Omwâmi w’omunya-Kanâni, ye mwâmi w’e Aradi, ayûbakaga omu Nêgebu, ayumva oku Israheli ayiruka, anali omu njira y’e Atarimi. Oyo mwâmi atula bene Israheli kwo entambala, anacibagwarhamwo mpira nyinji. ");
INSERT INTO shr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Lêro Israheli arhôla omuhigo embere za Nyamubâho, aderha, erhi: «Yâgirwa, erhi wakampà olu lubaga, nanaluherêrhera n’ebishagala byâlo byoshi.» ");
INSERT INTO shr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Nyamubâho ayumva izù ly’Israheli, amuhà abo banya-Kanâni. Babageza oku boji bw’engôrho, babaherêrekeza n’ebishagala byâbo hyoshi. Aho bahayîrika izîno lya Horma. ");
INSERT INTO shr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Banacirhenga oku ntondo ya Hori, bakulikira enjira ejîre ebwa nyanja ya Sufu, lyo bahashizunguluka ecihugo c’Edomu. Olubaga lwabula oburhwâli muli eyôla njira. ");
INSERT INTO shr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Lwanacirhondêra okucîdudumira Nyamuzinda na Mûsa, lwakaziderha, erhi: «Carhumaga warhukûla e Mîsiri mpu rhuyishifira muno irungu? Ntà mugati, ntà mîshi, rhwanayihisirwe n’ebi biryo b’ishali». ");
INSERT INTO shr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Oku bundi Nyamubâho anabarhumira enjoka nkali, zaluma olubaga, na bantu banji bafà muli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Olubaga lwajà emunda Mûsa ali, lwaderha, erhi: «Rhwajizire ecâha, bulya rhwacidudumire Nyamubâho nâwe. Oshenge Nyamubâho arhukûle kw’ezi njoka». Mûsa agendisengerera olubaga. ");
INSERT INTO shr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Na Nyamubâho anacibwîra Mûsa, erhi: «Otule enjoka y’omulinga, oyimanike oku murhi wagwîka; ngasi yêshi wankabà analumirwe, erhi ankayilolakwo, anabà na akalamo». ");
INSERT INTO shr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mûsa anacitula enjoka y’omulinga, anaciyimanika oku murhi, n’erhi hankabîre olumirwe n’enjoka, akalola kuli erya njoka y’omulinga, analame. ");
INSERT INTO shr_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Bene Israheli bagenda, bajihanda aha Oboti. ");
INSERT INTO shr_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Barhenga aha Oboti bagendihanda aha Yabarimi, omw’irungu aha ishiriza lya bene Mowabu, olu­nda lw’ebuzûka-zûba. ");
INSERT INTO shr_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Barhenga ahôla, bagendihanda omu kabanda ka Zaredi. ");
INSERT INTO shr_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Barhenga aho, bagendihanda ah’ishiriza ly’Arnoni, lwîshi lurhenga omu bihugo by’Abanyamoreni, lukazihulula omw’irungu. Olwo lwîshi Arnoni, lwo lunaligi lubibi lw’ecihugo ca Mowabu n’eca Abanyamoreni. ");
INSERT INTO shr_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Co carhumaga baderha ntyâla omu citabu c’amatabâro ga Nyamubâho, erhi: «Nyamubâho arhôzire Vahebi, n’obwo arhahimwa muhûsi, ahirakwo emigezi ya Arnoni, ");
INSERT INTO shr_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kuguma n’amarhambi g’emigezi eri kurhenga oku karhondo ka Ari kuhika oku lubibi lwa Mowabu.» ");
INSERT INTO shr_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Erhi barhenga aho bajà e Beri. Lyo lirya iriba Nyamubâho abwiriragaho Mûsa, erhi: «Oshûbûze olubaga, nkola naluhà amîshi.» ");
INSERT INTO shr_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Lêro obwo, Israheli anacirhôla olwimbo aderha, erhi: «Cûka wâni maliba! Mumukomere akagasha! ");
INSERT INTO shr_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Mwe maliba gahumbagwa n’abaluzi, n’abagula b’olubaga bagayigula n’akarhi k’obukulu, n’ebikoma byâbo omu irungu kujà e Matana!» ");
INSERT INTO shr_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Kurhenga omw’irungu bajà e Matana; kurhenga e Matana bajà e Nahalieli; kurhenga e Nahalieli bajà e Bamoti. ");
INSERT INTO shr_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Kurhenga e Bamoti bajà ebw’akabanda kali omw’ishwa lya bene Mowabu, okw’irhwêrhwè lya Pisga, ntondo ndîrî ebonekana omw’irungu lyoshi. ");
INSERT INTO shr_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israheli anacilika entumwa emwa Sihoni, mwâmi w’Abanyamoriti mpu bagendimubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Ondeke nâni ngere omu cihugo câwe; rhurhadungukire oli omu mashwa, oli ebwa mizâbîbu; rhurhanywe n’amîshi g’amaliba; rhwakulikira omulimbwa gw’ebwâmi kuhika rhurhenge omu cihugo câwe.» ");
INSERT INTO shr_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ci Sihoni arhazigaga mpu Israheli atwikanye omu cihugo câge. Sihoni anacishûbûza olubaga lwâge loshi; anacikanya akola agendilwîsa bene Israheli omw’irungu; anacihika aha Yahasi, anacikoza entambala kuli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israheli amugeza oku bwôji bw’engôrho; amuhima, ananyaga ecihugo câge kurhenga kuli Arnoni kujà e Yaboki, kandi kuhika kuli bene Amoni, bulya Yazeri àli lubibi naye. ");
INSERT INTO shr_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israheli anacinyaga ezo ngo zoshi. Ayûbaka omu ngo zoshi za bene Amoriti, Heseboni n’ez’abashizi bâge. ");
INSERT INTO shr_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heseboni lwo lwàli lugo lunênênè lwa Sihoni, mwâmi w’Abanyamoriti. Sihoni ye wajagilwîsa omwâmi w’embere wa bene Mowabu, anamunyaga ecihugo câge coshi kuhika kuli Arnoni. ");
INSERT INTO shr_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Co cirhuma abazihi baderha ntya: «Mukanye e Heseboni we! Olugo lwa Sihoni lushubiyûbakwa, banaluzibuhye! ");
INSERT INTO shr_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Omuliro gwazûsire e Heseboni, engulumira omu lugo lwa Sihoni yamalîre Ari-Mowabu, yamirangusa entondo z’Arnoni! ");
INSERT INTO shr_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Buhanya bwâwe, wâni Mowabu! Wamâhera weki lubaga lwa Kemoshi! Bagala bâge bayishaga bayâka, na bâli bâge bagwârhagwa; bajà ba Sihoni, mwâmi w’Abamoriti. ");
INSERT INTO shr_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Iburha lyâbo lyashandâla kurhenga Heseboni kuhika aha Diboni. Rhwadulika omuliro kurhenga Nofahi kuhika Mediba.» ");
INSERT INTO shr_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israheli ayûbaka omw’ishwa ly’Abanyamoriti. ");
INSERT INTO shr_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mûsa arhuma abâge­ndilolêreza Yazeri, banacinyaga engo zâge zoshi; bashandabanya Abanyamoriti bazibâgamwo. ");
INSERT INTO shr_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Banacigolonjoka, basôka omu njira y’e Bashani. Naye Og, mwâmi w’e Bashani, arhabâla n’engabo yâge yoshi mpu akola ajibalwikiza aha Edreyi. ");
INSERT INTO shr_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Nyamubâho anacibwîra Mûsa, erhi: «Orhamurhînyaga, bulya mmuhizire omu maboko gâwe, ye olubaga lwâwe lwoshi, n’ecihugo câge coshi. Omukolere amabî nka kulya wagakoleraga Sihoni, mwâmi w’Abanyamoriti, wayûbaka­ga aha Heseboni». ");
INSERT INTO shr_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Banacimuhima, n’abagala n’olubaga lwâge lwoshi. Harhasigalaga ciru n’omuguma ozîne n’ecihugo câge bacirhôla. ");
INSERT INTO shr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Bene Israheli banacilîkûla bagendihanda omu rhubanda rhwa Mowabu, ab’ishiriza lya Yordani, hôfi na Yeriko ");
INSERT INTO shr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaka, mwene Sipori, abona ebi bene Israheli bajirire Abanyamoriti byoshi. ");
INSERT INTO shr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mowabu arhemuka embere z’olwo lubaga erhi bunji bwâlò burhuma; yêshi ageramwo omusisi erhi bene Israheli bàrhuma. ");
INSERT INTO shr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Anacibwîra abashamuka ba Madiani, erhi: «Ka murhabwîni oku eyi nkûmo y’abantu yayisha yafôrha ngasi binarhuli eburhambi byoshi, nka kula enkafu enafôrha obuhasi omu mashwa». Balaka mwene Sipori ye wali mwâmi wa bene Mowabu muli ago mango. ");
INSERT INTO shr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Anacirhuma entumwa emwa Balâmu, mwene Beyori, aha Petori, oku burhambi bw’Olwîshi, omu cihugo ca bene Amafu. Amubwîra, erhi: «Lolà oku engabo erhenzire e Mîsiri ebumbire ecihugo, enayûbasire aha ishiriza ly’aha mwâni. ");
INSERT INTO shr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","“Nkusengîre mâshi obiduhe ohehêrere olu lubaga, bulya lwamandusha misî. Lyoki nankaciluhima nandulibirhekwo lurhenge muno cihugo câni: bulya mmanyire oku oyu ogishire, anagishwe, n’oyu ohehêrerîre anahehêrerwe”». ");
INSERT INTO shr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Abashamuka ba Mowabu n’abashamuka ba Madiani banacihira njira, banadwîrhe oluhembo bayishiha omushonga. Oku barhinda aha mwa Balâmu, banacimurhondêreza ebinwa bya Balaka. ");
INSERT INTO shr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Anacibashuza, erhi: «Mulâle hano, nyishibaha ishuzo nk’oku Nyamubâho akanambwîra.» Abo baluzi b’e Mowabu banacihanda aha mwa Balâmu. ");
INSERT INTO shr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nyamubâho anaciyagâna Balâmu, amubwîra, erhi: «Bantu baci bala bali aha mwâwe»? ");
INSERT INTO shr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balâmu ashuza Nyamuzinda, erhi: «Balaka mwene Sipori, mwâmi w’e Mowabu ye wabarhumaga mpu bayishimbwîra erhi: ");
INSERT INTO shr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Lolà olubaga lwarhenga e Mîsiri, lubumbire ecihugo coshi. Oyîshe, mâshi obahehêrere, lyoki nankahashilulwîsa, nandulibirhekwo.» ");
INSERT INTO shr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nya­muzinda anacibwîra Balâmu, erhi: «Orhagendaga nabo, orhanahehêreraga olwo lubaga, bulya luli lugishe.» ");
INSERT INTO shr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Sêzi, Balâmu erhi azûka abwîra balya baluzi ba Balaka, erhi: «Shubiri emwinyu, bulya Nyamubâho andahirire okugenda haguma ninyu.» ");
INSERT INTO shr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Balya baluzi b’e Mowabu bahuma enjira yâbo, bashubira emwa Balaka, bamubwîra mpu: Balâmu alahire mpu arhankarhukulikira. ");
INSERT INTO shr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaka ashubirhumayo abandi baluzi, banji na ba cikono kulusha abarhanzi. ");
INSERT INTO shr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Erhi bahika aha mwa Balâmu banacimubwîra mpu: «Kwo adesire ntya Balaka mwene Sipori: “Mâshi, nkuhûnyire, ntâco cakuhanzagya okuyisha eno mwâni”; ");
INSERT INTO shr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","“Bulya nakuhemba kulya kunakukwânîne, nankuhè ngasi ebi wankanampûna byoshi. Ci oyîshe, nkusengîre, ohehêrere olu lubaga”». ");
INSERT INTO shr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balâmu anacishuza balya bambali ba Balaka erhi: «Ciru Balaka akampa enyumpa yâge eyunjwîre nfaranga na masholo, ntà mango nvune irhegeko lya Nyamubâho, Nyamuzinda wâni, omu cijiro cisungunu erhi cinene. ");
INSERT INTO shr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Bunôla mbahunyirage, ninyu mubêrage hano buno budufu, nâni mpashimanya oku Nyamubâho ashubibwîra.» ");
INSERT INTO shr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Nyamubâho anacijà emunda Balâmu ali muli obwôla budufu, anacimubwîra, erhi: «K’abà bantu barhajikuhamagala? Genda mwe nabo, ci orhajiraga oku ntakubwiziri.» ");
INSERT INTO shr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balâmu anacizûka sêzi, n’erhi abà amashanira ecihêsi câge, bagenzikanwa na balya baluzi b’e Mowabu. ");
INSERT INTO shr_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Oburhè bwa Nyamuzinda bwanaciyâka bulya Balâmu akola ajà eyo munda; na Malahika wa Nyamubâho acîhira muli erya njira mpu amucîke. Balamu àli àshonîre oku ndogomi yâge analusibwe na abambali bahirhi. ");
INSERT INTO shr_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Erya ndogomi yanacibona Malahika wa Nyamubâho waliyimanzire omu njira anafumbasire engôrho nyômole; endogomi yaleka erya njira yacîjìra omu mashwa. Balâmu arhondêra ashûrha erya ndogomi yâge mpu ayishubiza omu njira. ");
INSERT INTO shr_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Okubundi, Malahika wa Nyamubâho agendiyimanga omu njira ahâli omongobana, ekarhî k’emizâbîbu eyûbakirwe olugurhu olunda n’olundi lw’e­njira. ");
INSERT INTO shr_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Endogomi yabona malahika wa Nyamubâho; yacîsinda oku lugurhu, yahirizakwo okugulu kwa Balâmu. Balâmu ashubiyishûrha. ");
INSERT INTO shr_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Malahika wa Nyamubâho ajà embere kulusha, ayimanga ahafunda kulusha halya harhankahindamukwa ekulyo erhi ekumosho. ");
INSERT INTO shr_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Erhi endogomi ebona Malahika wa Nyamubâho, yagwîshira idako lya Balâmu. Lêro Balâmu abà burhè, arhondêra ayishûrha akarhi kâge. ");
INSERT INTO shr_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nyamubâho ayigula akanwa k’erya ndogomi, yanacibwîra Balâmu, erhi: «Kurhi nieki nakujirîre obu wanshûrha kasharhu?» ");
INSERT INTO shr_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balâmu ashuza endogomi, erhi: «Bulya wamancinirakwo; nka nali nfumbasire engôrho, nali nakuyîrha ho n’aha.» ");
INSERT INTO shr_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Erya ndogomi yashuza Balâmu, erhi: «Ka ntali ndogomi yâwe, eyi okaziyôrha wagendakwo kuhika ene? Ka okola obwîne nakujirira ntya bundi?» Anacishuza, erhi: «Nanga.» ");
INSERT INTO shr_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Nyamubâho anacibwîkûla amasù ga Balâmu. Abona olya Malahika wa Nyamubâho, ali afumbasire engôrho nyômole. Afukamiriza akumba bûbi. ");
INSERT INTO shr_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malahika wa Nyamubâho anacimubwîra, erhi: «Carhumaga Oshûrha endogomi yâwe kasharhu koshi? Nie nyishire nti nkucîke, bulya orhankagera nka ndi mw’eyi njira. ");
INSERT INTO shr_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Endogomi yambwîne, yanakacîhindamukira ngasi kumbona, kasharhu kakulikirîne. N’erhahindamukaga ecîyegûla embere zâni, nali nakuyîrha, nayo nyireke egende ezîne.» ");
INSERT INTO shr_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balâmu anacibwîra olya Malahika wa Nyamubâho, erhi: «Najizire ecâha. Ntalimanyire oku oli omu njira embere zâni. Na bunôla akabà kugaya ogayire, niono nagaluka.» ");
INSERT INTO shr_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malahika wa Nyamubâho anacishuza Balâmu, erhi: «Ogende n’abà balume. Ci orhayishiderhe akandi kanwa okuleka aka nayishikubwîra. Balâmu anacigenzikanwa na balya baluzi ba Balaka». ");
INSERT INTO shr_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaka erhi ayumva oku Balâmu ayishire, ajimuyankirira olunda lw’e Mowabu elubibi lw’Arnoni, aha buzinda bw’ecihugo. ");
INSERT INTO shr_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaka anacibwîra Balâmu, erhi: «Ka ntalinkurhumire abajà bugo ntibajikuhamagala? Carhumaga orhayisha emunda ndi? Ka ntankahasha okukujirira kulya kunakukwânîne?» ");
INSERT INTO shr_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balâmu anacishuza Balaka, erhi: «Sinza, niono nyishire emunda oli, ka nankaderhaga akanwa? Oluderho Nyamubâho ahira omu kanwa kâni lwo nanaderha.» ");
INSERT INTO shr_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balâmu analikula na Balaka, banacihika aha Kiriyati-Huzoti. ");
INSERT INTO shr_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaka aniga enkafu n’ebibuzi; abihêkerakwo Balâmu na balya baluzi banali naye. ");
INSERT INTO shr_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Erhi buca, Balaka ajirhôla Balâmu, basôkera bombi e Bamoti-Baala, ho akahashire okuhonera emirongo mizinda y’olubaga. ");
INSERT INTO shr_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balâmu abwîra Balaka, erhi: «Onyûbakirage hano mpêrero nda, onanteganyize mpanzi nda hano na ngandabuzi nda.» ");
INSERT INTO shr_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaka anacijira nk’okwo Balâmu anamuhûnaga. Anacirherekêra empanzi n’engandabuzi oku ngasi luhêrero. ");
INSERT INTO shr_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balâmu anacibwîra Balaka, erhi: «Yimanga hôfi n’eyi nterekêro yâwe okunacîyegûla hitya; hali amango Nyamubâho akambugâna. Ebi akanyêreka byo nâni nakanakumanyisa.» Anacikanya ajà oku hirhondo hirhalikwo cici. ");
INSERT INTO shr_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nyamuzinda anacishimânana na Balâmu; naye anacimubwîra, erhi: «Nayûbasirage mpêrero nda, na kuli ngasi luhêrero najirîrekwo enterekêro y’empanzi n’engandabuzi». ");
INSERT INTO shr_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nyamubâho anacihira ecinwa omu kanwa ka Balâmu, anacimubwîra, erhi: «Oshubirage emunda Balaka ali, ntyo kwo waderha.» ");
INSERT INTO shr_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balâmu anacishubira emunda ali ashimâna anaciyimanzire aha nterekêro yâge, yo n’abaluzi ba Mowabu boshi. ");
INSERT INTO shr_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Anaciderha binôla binwa, erhi: «Balaka anacintenza e Arami, Omwâmi w’e Mowabu anantenzize omu birhondo by’e Buzûka-zûba, ampûna erhi: Oyîshe ompehêrerere Yakôbo! Oyîshe ofûhire Israheli!» ");
INSERT INTO shr_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","«Kurhigi nankahehêrera, amango Nyamuzinda arhahehêriri?» Kurhigi nankafûha, amango Nyamuzinda arhafûha? ");
INSERT INTO shr_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Bulya, kurhenga okw’irhwêrhwè ly’aga mabuye namamubona. Kurhenga okw’irhwêrhwè ly’orhurhondo, namamulolêreza. Luli lubaga luyûbasire hâgo hâgo, lurhankanaja oku mubalè gw’agandi mashanja. ");
INSERT INTO shr_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ndi wankaganja entuliri ya Yakôbo, ndi wankaberûla enkûmo y’Israheli? Mbofa nk’abashinganyanya, n’akalamo kâni kaboyûrha aka akâbo! ");
INSERT INTO shr_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaka anacibwîra Balâmu, erhi: «Kwo kurhi oku wamanjirira? Nakurhôlaga nti ohehêrere abashombanyi bâni, lêro wêhe kwamaba kubagisha». ");
INSERT INTO shr_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balâmu ashuza, erhi: «Ka ntagwâsirwi nderhe kulya Nyamubâho anahizire omu kanwa kâni?» ");
INSERT INTO shr_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaka anacimubwîra, erhi: «Nkulikiraga ahandi hantu. Olu lubaga wabona ntya, olubwîne lunda luguma, ci orhalubwini lwoshi. Olu­mpehehêrere lêro aho». ");
INSERT INTO shr_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Amujâna ebw’Ishamba ly’Abalâlîzi, okw’irhwêrhwè ly’entondo ya Pisga; ayûbakakwo mpêrero nda, kuli ngasi luguma arherekerêrakwo mpanzi nguma na ngandabuzi nguma. ");
INSERT INTO shr_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balâmu anacibwîra Balaka, erhi: « Obêre hôfi n’eyîra nterekêro yâwe nâni nkola nagendirinda.» ");
INSERT INTO shr_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nyamubâho anacishimâna Balâmu, anacimuhira ecinwa omu kanwa kâge, anacimubwîra, erhi: «Oshubire emunda Balaka ali, ogendimubwîra ebi binwa.» ");
INSERT INTO shr_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Anacishubira emunda Balaka ali ayîmanzire hôfi n’enterekêro yâge n’abaluzi b’e Mowabu banali boshi naye. Balaka anacimudôsa erhi: «Kurhi Nyamubâho anadesirage?» ");
INSERT INTO shr_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kandi Balâmu anaciderha ebi binwa, erhi: «Yimuka Balaka, onayumve, ntega okurhwiri, mwene Sipori». ");
INSERT INTO shr_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nyamuzinda arhabà muntu okazinywerha arhali mwene Adamu okazicîyunjuza. Ka ye oderha kône arhanajire cici? Ka ye oderha akanwa karhanabè kulya anaderhaga? ");
INSERT INTO shr_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nahâbirwe irhegeko ly’okugisha; nagisha, ntanaciyunjuze. ");
INSERT INTO shr_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ntabwîni bubî buci muli Yakôbo. Ntabwîni ntanya nci muli Israheli. Nyamubâho Nyamuzinda wâge ali naye, aha mwâge wanayumva ecihôgêro c’aha bwâmi. ");
INSERT INTO shr_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nyamuzinda wamukulaga e Mîsiri, emisî yâge eri ya mbogo. ");
INSERT INTO shr_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Bulya ntà bulozi bwankadunda Yakôbo na ntà bulaguzi bwankahasha Israheli. Ciru akabà Yakôbo na Israheli banabwirwe mpu: «Kurhi oku Nyamuzinda ajira?» ");
INSERT INTO shr_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Lolà olubaga lwacinânûla nka ntale nkazi, lwamacûka nka ntale ndume; erhahunga erhanacishanshanyula nsimba yayo, n’okunywa omukò gw’ebi yanigaga. ");
INSERT INTO shr_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaka abwîra Balâmu, erhi: «Olekage okubahehêrera, ci kwône orhabagishaga.» ");
INSERT INTO shr_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balâmu ashuza Balaka, erhi: «Ka ntakubwizire oku najira oku Nyamuzinda anadesire kwoshi?» ");
INSERT INTO shr_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaka anacibwîra Balâmu, erhi: «Kanyagya nkuheke ahandi hantu. Nkaba aho hanasîmîsa Nyamuzinda, akuyêmêrere obampehêrerere». ");
INSERT INTO shr_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaka anacijâna Balâmu oku ntondo ya Peyori, ebonekîne omw’irungu lyoshi. ");
INSERT INTO shr_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balâmu anacibwîra Balaka, erhi: «Onyûbakire aha mpêrero nda, onanteganyize aha mpanzi nda na ngandabuzi nda.» ");
INSERT INTO shr_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaka anacijira nk’oku Balâmu anamubwîraga, arherekêra empanzi n’engandabuzi oku ngasi luhêrero. ");
INSERT INTO shr_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balâmu abona oku Nyamubâho arhonyize okugisha Israheli, lêro arhacijaga nk’agandi mango ebwa kugendidôsa embuko, ci ayêrekeza obusù bwâge ebwa irungu. ");
INSERT INTO shr_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Erhi Balâmu abà amâyinamula amasù, abona oku bene Israheli bahanzire ishanja oku lindi, anaciyagânwa na Mûka gwa Nyamuzinda, ");
INSERT INTO shr_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","aderha ecinwa câge, erhi: Obugeremwa bwa Balâmu mwene Beori, Obugeremwa bwa omuntu onizire isù, ");
INSERT INTO shr_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Obugeramwa bwa olya muntu oyumva ebinwa bya Nyamuzinda, Kubona abona ebi Ogala-byoshi ayêrekana, anahâbwe n’ishuzo limâna n’amasù gâge gabungûke. ");
INSERT INTO shr_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Alà oku gayinjiha amahêma gâwe Yakôbo! n’enyumpa zâwe, Israheli! ");
INSERT INTO shr_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Nka kula orhubanda rhulanduka, nka kula amashwa mahinge oku lwîshi, nka binûsi Nyamubâho arhwêraga, nka kula emiyerezi elandira oku burhambi bw’amîshi. ");
INSERT INTO shr_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Amîshi ganasheshe ebi bindi byâge, n’emburho yâge egundumuke enyanya ly’ago mîshi manji, omwâmi wâge ayisha ayêrêra enyanya ly’Agagi, n’obwâmi bwâge bwajire irenge! ");
INSERT INTO shr_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Nyamuzinda amurhenza e Mîsiri: amuhà emisî eri nka ya mbogo. Yamalîra amashanja gashingalala embere zâge. Yabavunangula orhuvuha, anabatyabule n’emyampi yâge. ");
INSERT INTO shr_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Anagonye amadwî, acîbundike nka ntale ndume, nk’amacîbundika nka nsimba, ndi wankacimuzûsa? Agishwe, owâkugishe n’owakuhinde, akahindwa! ");
INSERT INTO shr_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Oburhè bwa Balaka bwayâka bwenêne kuli Balâmu, ashûrha omu nfune, amubwîra erhi: «Nalikuhamagala nti ohehêrere abashombanyi bâni, wêhe kwamabà kubagisha kasharhu. ");
INSERT INTO shr_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Na buno yimukaga duba olibirhire emwâwe! Nali ndesire nti nakujira oj’irenge; lêro lolà oku Nyamubâho amakuyegûla kuli lyo.» ");
INSERT INTO shr_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balâmu anacishuza Balaka erhi: «Ka ntali erhi nabwîzire entumwa wali orhumire, oku: ");
INSERT INTO shr_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ciru Balaka akampa enyumpa yâge eyunjwîre nfaranga na masholo, ntakavuna irhegeko lya Nyamubâho, omu kujira niene nk’oku nnonzize okujira ehinja erhi ehibî; n’oku ngasi oku Nyamubâho anadesire kwo naderha? ");
INSERT INTO shr_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Alaga oku bunôla nkola nacîshubirira emw’olubaga lwâni; yishaga nkubwîre ehi olu lubaga lwanajirîre olubaga lwâwe omu nsiku zàyisha». ");
INSERT INTO shr_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Okuhandi anaciderha ebi binwa, erhi: Bugeramwa bwa Balâmu mwene Beori, bugeramwa bw’omuntu wanizire isù, ");
INSERT INTO shr_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","bugeramwa bw’olya muntu oyumva ebinwa bya Nyamuzinda ye oyishi eby’Ow’Enyanya ye olya obona ebyanacibonwe by’Ogala-byoshi olya okûmba bûbi anagalirhondêra abona. ");
INSERT INTO shr_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Namamubona, ci kwône arhacibà wa buno; namamulâba ci kwône arhacibà nk’oli hôfi. Enyenyêzi yamârhenga muli Yakôbo, akarhi k’obwâmi kamayimanga omu Israheli; kamavunanga emyanganga ya Mowabu, Kamamalîra bene Seti. ");
INSERT INTO shr_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ecihugo c’Edomu camagwârhwa busâsa, na Seyiri kwo n’okwo; Israheli amâlambûla obuhashe bwâge. ");
INSERT INTO shr_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Emwa Yakôbo yamârhenga omurhegesi ye wamalîra ngasi bicisigîre omu ngo na Edomu. ");
INSERT INTO shr_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balâmu abona Amaleki, anacimubwîra ebi binwa, erhi: «Amaleki lyo ishanja likulu omu mashanja, n’obuzinda bwâge kwabà kushâbûka». ");
INSERT INTO shr_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balâmu anacibona bene Keneti, anaciderha, erhi: Aha mwinyu bahazibuhize, ewe Kayini, n’enyumpa zinyu ziri nyûbake oku ibuye. ");
INSERT INTO shr_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ci kwônene olugo lwinyu lubà lwa Beori; amango gahi mwanarhenge omu bujà bwa Asûru? ");
INSERT INTO shr_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balâmu ashubirira aderha ebi binwa, erhi: Aye, amashanja g’emashinji gabugânana emwênè, ");
INSERT INTO shr_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","n’enkugè olunda lw’e Kitimi. Gamalibûsa Asûru, gamabengeza Eberi; naye obuzinda bwâge kuli kuherêrekera lwoshi. ");
INSERT INTO shr_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balâmu erhi abà amayimuka, ahuma njira, acîshubirira emwâge; naye Balaka ajà lwâge lunda. ");
INSERT INTO shr_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israheli anacijà e Shitimu. Olubaga lwarhondêra olugendo lubî n’abanyere b’e Mowabu. ");
INSERT INTO shr_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Balinda baluhengulira ebwa kuharâmya abazimu bâbo. Olubaga lwalya lwanafukamira abo bazimu. ");
INSERT INTO shr_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Erhi Israheli acîshwêkera oku muzimu Bal-Peori, oburhè bwa Nyamubâho bwanaciyâka kuli Israheli. ");
INSERT INTO shr_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Nyamubâho anacibwîra Mûsa, erhi: «Oshubûze abarhambo b’olubaga boshi. Obamanikire Nyamubâho embere ly’izûba, lyo oburhè bunji bwa Nyamuzinda buzima kuli bene Israheli.» ");
INSERT INTO shr_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mûsa anacibwîra abatwî b’emmanja omu Israheli, erhi: «Ngasi muguma muli mwe ayîrhe balya ba muli bene wâbo bàjîre emwa Bal-Peori». ");
INSERT INTO shr_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Lolà oku ago mango, muntu muguma wa muli bene Israheli anaciyisha adwîrhe embere za bene wâbo omukazi w’omunya-Madiani, erhi na Mûsa adwîrhe asinza, n’omu masù g’olubaga lwa bene Israheli boshi, ludwîrhe lwalakira aha Muhango gw’Ihêma ly’embugânano. ");
INSERT INTO shr_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Erhi abona kulya, Pinehasi mwene Eleazari, mugala w’omudâhwa Aroni, anacibaduka omu karhî k’olubaga, ayanka itumu, ");
INSERT INTO shr_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","akulikira olya mulume munya-Israheli enyuma l’Ihêma ly’embugânano, abatumirha bombi: olya mulume munya-Israheli n’olya mukazi abafubula enda. Obuhanya bwàli budwîrhe bwayîrha bene Israheli bwayimanga. ");
INSERT INTO shr_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Bantu bihumbi makumi abirhi na bâni bàfîre n’obwo buhanya. ");
INSERT INTO shr_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nyamubâho ashambâza Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehasi, mwene Eleazari, mugala w’omudâhwa Aroni ye orhumire oburhè bwâni burhûlirira kuli bene Israheli, bulya analigwêrhwe n’omutula gwâni ekarhî ka bene Israheli; ye warhumire muli ogwo mutula gwâni ntamalìra bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Co cirhumire ndesire oku: mbahire endagâno yâni y’omurhûla. ");
INSERT INTO shr_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Yâbà kuli ye n’oku iburha lyâge enyuma zâge; yâbà ndagâno y’obudâhwa bw’ensiku zoshi. Na bulya anabwîne omutula erhi Nyamuzinda wâge orhuma, anahasha okujira enterekêro y’empyûlo kuli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Olya mulume w’omunya Israheli wayîrhagwa bône olya mukazi w’omu­nya-Madiani, izîno lyâge ye Zimri, mwene Salu, àli murhambo w’omulala gwa bene Simoni. ");
INSERT INTO shr_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Naye olya mukazi w’omunya-Madiani wayîrhagwa, izîno lyâge ye Kozbi, mwâli wa Suru, murhambo muguma w’omu milala y’e Madiani. ");
INSERT INTO shr_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Nyamubâho anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Abanya-Madiani, obafarhirize onabayabûse, ");
INSERT INTO shr_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","bulya bo bâli barhangiriza okummuyabûsa, omu bwengehusi bwâbo mwa birya bya Peori na mwa birya bya Kozbi, mwâli w’omurhambo w’e Madiani, olya wayîrhagwa olusiku lw’obuhanya Peori alêrhaga. ");
INSERT INTO shr_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Erhi bayûsihanwa ntyo, Nyamubâho anacibwîra Mûsa n’Eleazari, mwene omudâhwa Aroni, erhi: ");
INSERT INTO shr_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Ojire omubalè gwa bene Israheli boshi, kurhenga oku wa myâka makumi abirhi kujà enyanya, nk’oku emilala ya bashakulûza bâbo enakulikirîne muli bene Israheli boshi ojire omubalè gwa balya boshi bakanahashaga okuhêka emirasano. ");
INSERT INTO shr_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mûsa n’omudâhwa Eleazari banacibwîra bene Israheli ntyo omu kabanda ka Mowabu, hôfi na Yordani, aha ishiriza lya Yeriko. ");
INSERT INTO shr_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Mujire omubalè gwa bene Israheli, kurhenga oku wa myâka makumi abirhi kujà enyanya (nka kulya Nyamubâho anarhegekaga Mûsa na bene Israheli, galya mango barhengaga omu cihugo c’e Mîsiri). ");
INSERT INTO shr_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubeni yo nfula y’Israheli, Bene Rubeni bali: Kuli Henoki, omulala gwa Abahenoki; kuli Palu, omulala gwa Abapalu. ");
INSERT INTO shr_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Kuli Hezroni, omulala gwa Abahezroni; kuli Karmi, omulala gwa Abakarmi. ");
INSERT INTO shr_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Yo milala ya bene Rubeni eyo, Abaganjirwe muli bo boshi bâli balume bihumbi makumi anni na bisharhu na bantu magana galinda na makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Bene Palu ali Eliabu, ");
INSERT INTO shr_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Bene Eliabu bâli: Namueli, Datani n’oyôla wâbo Abirami, balya bâli bashamuka bw’omw’ihano, balya bacîhindulaga kuli Mûsa n’Aroni, omu murhwe gwa Korè, galya mango acîhinduliraga Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Obudaka bwanaciyashama bwabamirangusa (na Korè, galya mango omurhwe gwâge gwafaga, go mango omuliro gwamiragusagya bantu magana abirhi na makumi arhanu. Babà lwîganyo oku bandi. ");
INSERT INTO shr_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ci kwône bene Korè barhafaga). ");
INSERT INTO shr_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Bene Simoni, kulya emilala yâbo enagenzire: Kuli Namueli omulala gw’Abayanamueli; kuli Yakini, omulala gw’Abayakini; kuli Yakini, omulala gw’Abayamini; ");
INSERT INTO shr_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Kuli Zera, omulala gw’Abazera; kuli Shaulu, Abashauli. ");
INSERT INTO shr_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Yo milala ya bene Simoni eyo: boshi haguma bihumbi makumi abirhi na bibirhi na bantu magana abirhi. ");
INSERT INTO shr_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Bene Gadi, kulya emilala yâbo enagenzire: Kuli Sefoni, omulala gw’Abaasefoni; Kuli Hagi, omulala gw’Abahagi; kuli Suni, omulala gw'Abashuni; ");
INSERT INTO shr_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Kuli Ozni, omulala gwa Abanya-Ozni, kuli Eri, omulala gw’Abaeri; ");
INSERT INTO shr_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Kuli Arodi, omulala gw’Abarodi; kuli Areli, omulala gw’Abareli. ");
INSERT INTO shr_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Yo milala ya bene Gadi eyo. Abajirîrwe omubalè bali: bantu bihumbi makumi anni na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Bene Yûda: Eri na Onani; Ci Eri na Onani bafirîre omu cihugo c’e Kanâni. ");
INSERT INTO shr_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Alaga bene Yûda, kulya emilala yâbo enali: kuli Shela, omulala gw’Abashela; kuli Peresi, omulala gwa Abaperesi; kuli Zera, omulala gw’Abazera. ");
INSERT INTO shr_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Bene Peresi bâli: Kuli Hesroni, omulala gw’Abahesroni; kuli Hamuli, omulala gw’Abahamuli. ");
INSERT INTO shr_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yo milala ya bene Yûda eyo nk’oku bajirirwe omubalè: bantu bihumbi makumi gali nda na ndarhu na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Bene Isakari nk’oku emilala yâbo enali: kuli Tola, omulala gw’Abatolati; kuli Puva, omulala gw’Abapuva. ");
INSERT INTO shr_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Kuli Yashubu, omulala gw’Abanyashubu; kuli Shimroni omulala gw’Abashimroni. ");
INSERT INTO shr_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Yo milala ya bene Isakari, nk’oku banajirirwe omubalè: bihumbi magana gali ndarhu na bini na magana asharhu. ");
INSERT INTO shr_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Bene Zabuloni, kulya emilala yâbo enali: kuli Sêredi, omulala gw’Abasêredi, kuli Eloni, omulala gw’Abaloni; kuli Yaleli, omulala gw’Abayaleli. ");
INSERT INTO shr_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Eyo yo milala erhenga kuli Zabuloni, nka kulya banajirirwe omubalè: bantu bihumbi magana gali ndarhu na magana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Bene Yozefu, kulya emilala yâbo enali: Menashè na Efrayim ");
INSERT INTO shr_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Bene Menashè: Kuli Makiri, omulala gw’Abamakiri. Makiri aburha Galadi; kuli Galadi, omulala gw’Abagaladi. ");
INSERT INTO shr_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Alaga bene Galadi: Yezeri kwo kurhenga omulala gw’Abayezeri, kuli Heleki, omulala gw’Abaheleki; ");
INSERT INTO shr_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asrieli, ye warhengagakwo omulala gw’Abasrieli, Shekemi, ye warhengagakwo omulala gw’Abashikemi; ");
INSERT INTO shr_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida, ye warhengagakwo omulala gw’Abashemida; Heferi, ye orhengagakwo omulala gw’Abaheferi. ");
INSERT INTO shr_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi, mwene Heferi, arhaburhaga barhabana, ci banyere bône. Alaga amazîno ga bâli ba Selofehadi: Mahla, Noa, Hogla, Milka na Tirsa. ");
INSERT INTO shr_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Yo milala ya Menashè eyo; abajirîrwe omubalè bali bihumbi magana arhanu na bibirhi na magana gali nda. ");
INSERT INTO shr_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Alaga bene Efrayimu nk’oku emilala yâbo enali: kuli Shutela, omulala gwa Abashutela; kuli Bekeri, omulala gw’Ababekeri: kuli Tahani, omulala gw’Abatahani. ");
INSERT INTO shr_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Alaga bene Shutela: kuli Erani, omulala gw’Abaherani; ");
INSERT INTO shr_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Yo milala ya bene Efrayimu eyo, nk’oku banajirirwe omubalè: bâli bihumbi makumi asharhu na bibirhi na magana arhanu. Abo bo bene Yozefu, nk’oku emilala yâbo enali. ");
INSERT INTO shr_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Bene Benyamini, nk’oku emilala yâbo enali: kuli Bela, omulala gw’Ababela; kuli Ashbeli, omulala gw’Abashibeli; kuli Ahirami, omulala gw’Abahirami: ");
INSERT INTO shr_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Kuli Shufami, omulala gw’Abashufami; kuli Hufami, omulala gw’Abahufami. ");
INSERT INTO shr_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Alaga bagala ba Bela: Aredi na Naamani. Kuli Aredi, omulala gw’Abaaredi; kuli Naamani, omulala gw’Abanaamani. ");
INSERT INTO shr_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Abo bo bene Benyamini nk’oku emilala yâbo enali, n’abajirîrwe omubalè muli bo bali bihumbi makumi anni na birhanu na magana galindarhu. ");
INSERT INTO shr_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Alaga bene Dani, nk’oku emilala yâbo enali: kuli Shuhami kwarhenga omulala gw’Abasuhami. Eyo yo milala ya Dani, oku emilala yâbo enagenzire. ");
INSERT INTO shr_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Emilala y’Abashuhami yoshi nk’oku abajirîrwe omubalè banali: bihumbi makumi gali ndarhu na bini na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Bene Aseri nk’oku emilala yâbo enali: kuli Yimna, omulala gw’Abayimna; kuli Yishwi, omulala gw’Abayishwi; kuli Beria, omulala gw’Ababeria. ");
INSERT INTO shr_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Kuli bene Beria: kuli Heberi, omulala gw’Abaheberi; kuli Malkieli, omulala gw’Abamalkieli. ");
INSERT INTO shr_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Izîno lya mwâli wa Aseri ye wali Serah. ");
INSERT INTO shr_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Yo milala ya bene Aseri eyo. Abajirîrwe omubalè bali: bihumbi makumi arhanu na bisharhu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Bene Nefutali, nk’oku emilala yâbo enali: kuli Yasieli, omulala gw’Abayezieli; kuli Guni, omulala gw’Abaguni; ");
INSERT INTO shr_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Kuli Yeseri, omulala gw’Abayeseri; kuli Shilemi, omulala gw’Abashilemi. ");
INSERT INTO shr_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Eyo yo milala ya Nefutali, nk’oku emilala yâbo enali, abajirîrwe omubalè muli bo bali bihumbi makumi anni na birhanu na magana anni. ");
INSERT INTO shr_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Abo bo bene Israheli bajirirwe omubalè: boshi bahika oku bantu bihumbi magana gali ndarhu na magana gali nda na makumi asharhu. ");
INSERT INTO shr_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Nyamubâho anacishambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Abà bo ecihugo câgabirwa, cibè kashambala kâbo, nk’oku amazîno gâbo ganali. ");
INSERT INTO shr_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Abali banji, bo wanaha akashambala kanji, n’abali banyi, wanabaha akashambala kasungunu; bakaziha ngasi muguma akashambala kâge, kulya omubalè gwâbo gunali. ");
INSERT INTO shr_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ci kwône okwo kugabâna ecihugo kuyesherwe ecigole. Bacigabâna nk’oku emilala ya bashakulûza bâbo enali. ");
INSERT INTO shr_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ako kashambala kagabwa omu kuyesha ecigole oku bali banji nk’oku abâli basungunu. ");
INSERT INTO shr_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Alaga nk’oku emilala ekulikirîne, bene Levi bajirirwe omubalè: Kuli Gershoni, omulala gwa Abagershoni, kuli Kehati, omulala gw’Abakehati; kuli Merari, omulala gw’Abamerari. ");
INSERT INTO shr_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Alaga emilala ya bene Levi: omulala gw’Abalobuni, omulala gw’Abahebroni, omulala gwa bene Mahali, omulala gwa Bene Mushi (Abashi) n’omulala gw’Abanyakorè. Kehati aburha Amrami. ");
INSERT INTO shr_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Izîno ly’omugoli wa Amrami ye wali Yokebedi, mwâli wa Levi, oyu nina aburhiraga Levi erhi baciri e Mîsiri; aburhira Amrami: Aroni, Mûsa na Miriyamu, mwâli wâbo. ");
INSERT INTO shr_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aroni aburha Nadabu na Abiu, Eleazari na Itamara. ");
INSERT INTO shr_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabu na Abiu bo balya bafàga amango bajagidudumulira Nyamubâho omuliro gurhali gwo. ");
INSERT INTO shr_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Abajirîrwe omubalè boshi, kurhenga balume ba mwêzi muguma kujà enyanya, bali bihumbi makumi abirhi na bisharhu. Bulya barhajiriragwa omubalè haguma n’abandi bene Israheli, barhagwêrhi kashambala kaguma nabo. ");
INSERT INTO shr_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Abo bo bantu baganjirwe na Mûsa n’omudâhwa Eleazari, bo bajiraga omubalè gwa bene Israheli omu rhubanda rhwa Mowabu, hôfi na Yordani aha ishiriza lya Yeriko. ");
INSERT INTO shr_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Muli bo murhaciri ciru n’omuguma mwa balya bene Israheli Mûsa na Aroni bajiriraga omubalè omu ntondo ya Sînayi. ");
INSERT INTO shr_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Bulya Nyamubâho àli erhi adesire kuli bo, erhi: «Bafîra omw’irungu; harhasigalaga ciru n’omuguma aha nyuma lya Kalebu mwene Yefunè na Yozwè mwene Nuni». ");
INSERT INTO shr_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Oku bundi bâli ba Selofehadi banaciyegera. Selofehadi àli mwene Heferi, ya Galadi, ga Makiri, ga Menashè; w’omu bûko bwa bene Menashè ga Yozefu. Amazîno gâbo banyere: Mahla, Noa, Hogla, Milka na Tirsa. ");
INSERT INTO shr_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Banacijà emunda Mûsa ali, embere z’omudâhwa Eleazari, embere z’abarhambo b’olubaga loshi aha ihêma ly’embugânano; banaciderha, mpu: ");
INSERT INTO shr_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Larha àfirire omw’irungu; arhâli wa muli balya bacihinduliraga Nyamubâho, b’omu murhwe gwa Korè; ci muntu wafàga n’ecâge câha, arhanasigaga mwânarhabana. ");
INSERT INTO shr_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","“Cici cankarhumaga izîno lya larha lihirigirha omu mulala gwâge? Obu arhasigaga mwânarhabana nîrhu murhuhè ecirhu cigabi omu karhî ka bene wâbo larha.”» ");
INSERT INTO shr_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mûsa anacihêka olwo lubanja lwâbo embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Nyamubâho anacibwîra Mûsa, erhi: ");
INSERT INTO shr_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Abo bâli ha Selofehadi bàdesire akantu kashingânîne. Obahè nabo, oku kashambala kâbo, cigabi ciguma ekarhî ka bene wâbo îshe; obahè n’akashambala k’îshe wâbo. ");
INSERT INTO shr_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ogendishambâla na bene Israheli, obabwîre ntya”: ");
INSERT INTO shr_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","“Omulume erhi ankafà arhasiziri mugala, akashambala kâge wanakaha omwâli, na erhi akabà arhagwêrhi munyere, akashambala kâge wanakaha bene wâbo”. ");
INSERT INTO shr_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","“Erhi akabà arhagwêrhi bene wâbo; kalya kashambala kâge wanakahà bene wâbo îshe”. ");
INSERT INTO shr_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","“Na erhi akabà bene wâbo îshe barhahabà, kalya kashambala wanakahà mwene wâbo muguma oyegerîne naye omu mulala gwâge, oyo ye wakayôrhana. Kuli bene Israheli okwo kwabà ngeso ya bushinganyanya, nk’oku Nyamubâho anarhegekaga Mûsa”». ");
INSERT INTO shr_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Nyamubâho abwîra Mûsa, erhi: «Osôkere kuli eyi ntondo y’Abarim onalâbe ecihugo nahà bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","“Wacibona, obuligendiluhûkira emunda bene winyu bajire, nka kulya mwene winyu Aroni àjagayo”. ");
INSERT INTO shr_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","“Bulya, muli galya mango g’ishababè ly’olubaga omw’irungu lya Sini, mwembi murhashimbaga irhegeko nali mbahire ly’okumpeka irenge emunda bali, oku lwa galya mîshi”». (Go mîshi g’aha Meriba, e Kadesi, omw’irungu lya Sini.) ");
INSERT INTO shr_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mûsa ashambâla na Nyamubâho amubwîra erhi: ");
INSERT INTO shr_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Nyamubâho, Nyamuzinda wa ngasi myûka ya bantu, ahirage kuli olûla lubaga omuntu ");
INSERT INTO shr_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","“wakazigenda anagaluke nalo, omuntu wakaziluhulukana analugalule, na ntyo olubaga lwa Nyamubâho lurhaciyôrhe nka bibuzi birhagwêrhi mungere.”» ");
INSERT INTO shr_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Nyamubâho abwîra Mûsa, erhi: «Rhôla Yozwè, mwene Nuni, ali muntu oyunjwîre Mûka. Ogendihira okuboko kwâwe kuli ye. ");
INSERT INTO shr_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Omuhêke embere z’omudâhwa Eleazari n’embere z’olubaga loshi, kandi wanamuyîmika erhi na boshi badwîrhe babona. ");
INSERT INTO shr_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Omuhirekwo ecigabi c’obuhashe bwâwe, lyo olubaga lwa bene Israheli loshi lukazimuyumva. ");
INSERT INTO shr_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Anajà embere z’omudâhwa Eleazari, naye anagendidosa ihano ebwa Urimi embere za Nyamubâho. Oku buhashe bwâge, oyu Yozwè, kwo bakazigendera, n’oku buhashe bwâge bakazifulukira bene Israheli boshi, kandi kuguma naye olubaga lwoshi.» ");
INSERT INTO shr_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mûsa anacijira nk’okwo Nyamubâho anamurhegekaga. Arhôla Yozwè, amuhêka embere z’omudâhwa Eleazari n’embere z’olubaga loshi. ");
INSERT INTO shr_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mûsa, erhi ayûsimulambûlirakwo amaboko, amuyîmika nk’oku Nyamubâho anarhe­gekaga. ");
INSERT INTO shr_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Nyamubâho anacishambâza Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Ohè bene Israheli eri irhegeko, obabwîre, erhi: Mukazikombêra okumpà, omu mango gakwânîne enterekêro yâni n’ebiryo byâni, zo nterekêro zijizirwe n’omuliro, ziri za kisununu kinjà embere zâni. ");
INSERT INTO shr_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ojibabwîra, erhi: Alagi enterekêro mwakazihà Nyamubâho: Ngasi lusiku: bâna-buzi babirhi ba mwâka muguma; babè barhagwêrhi ishembo, bakazihânwa ngasi mango. ");
INSERT INTO shr_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Wanarherekêra mwâna-buzi muguma sêzi, n’owa kabirhi bijingo izûba lihorha. ");
INSERT INTO shr_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","N’ecihimbi ciguma ca kali ikumi c’efa y’enshâno y’omulà mvange n’amavurha g’ecigabi ca kani c’ehîni y’amavurha g’omuzêti magishe. ");
INSERT INTO shr_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Eyo yo nterekêro y’ensiku n’amango, eyahûnagwa oku ntondo ya Sînayi, ya kisununu kinjà, nterekêro ejizirwe n’omuliro embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Enterekêro y’embulagwa yabà ya mulengo gwa cigabi ca kani c’ehîni n’amavurha g’omuzêti magishe oku ngasi mwâna-buzi; omu hantu hatagatîfu mwo wakazihânira eyo enterekêro y’embulagwa y’idivayi embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Wanarherekêra omwâna-buzi wa kabirhi bijingo izûba lihorha; wanajira nk’oku wajiraga oku nterekêro y’esêzi, eri nterekêro ya kisununu kinjà embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Oku lwa Sabato, mwanarherekêra bâna-buzi babirhi ba mwâka muguma, barhabâgakwo ishembo lici; mwanahâna bigabi bibirhi bya enshâno y’omulà, mvange n’amavurha, kuguma n’embulagwa y’okunywa. ");
INSERT INTO shr_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Enterekêro y’olwa ngasi Sabato, yakazihirwa oku nterekêro ya ngasi mango n’embulagwa y’okunywa. ");
INSERT INTO shr_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Oku nsiku ntangiriza n’emyêzi yinyu, mwanakazihâna nka nterekêro ya nsirîra mwahà Nyamubâho, mpanzi ibirhi ntôrhò, ngandabuzi nguma na bâna-buzi babirhi ba mwâka muguma barhagwêrhi ishembo; ");
INSERT INTO shr_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","n’enterekêro y’enkalangè yajà oku ngasi mpanzi, ebè ya bigabi bisharhu bya kali ikumi by’enshâno y’omulà mvange n’amavurha. Enterekêro y’enkalangè yajà oku ngandabuzi, ebè ya bigabi bibirhi bya kali ikumi by’enshâno y’omulà mvange n’amavurha. ");
INSERT INTO shr_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Enterekêro y’enkalangè yajà oku ngasi mwâna-buzi, ebè ya cigabi ciguma ca kali ikumi c’enshâno y’omulà mvange n’amavurha. Eri nterekêro ya nsirîra ya kisununu kinjà, nterekêro yajirwa n’omuliro embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Enterekêro z’embulagwa zajà kuli ezo nterekêro, cibè cigabi ca kabirhi c’ehîni y’idivayi oku ngasi mpanzi, cigabi ciguma ca kasharhu c’ehîni oku ngandabuzi na cigabi ciguma ca kani c’ehîni oku mwâna-buzi. Yo nterekêro y’ensirîra yakâjirwa eyo ngasi kuhalûka kw’omwêzi, oku ngasi mwêzi, oku myêzi ya ngasi mwâka. ");
INSERT INTO shr_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Banarherekêra na Nyamubâho ecihebe nka nterekêro oku byâha, erhi hanaciri enterekêro y’ensirîra ya ngasi mango n’embulagwa y’okunywa. ");
INSERT INTO shr_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Oku mwêzi gwa burhanzi, omu nsiku ikumi n’ini z’omwêzi, lwâbà lusiku lukulu lwa Basâka wa Nyamubâho; ");
INSERT INTO shr_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","n’olusiku lwa kali ikumi na karhanu lw’ogwo mwêzi, lwâbà nalo lukulu. Bâgeza nsiku nda erhi balya emigati erhalimwo lwango. ");
INSERT INTO shr_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Omu lusiku lurhanzi, hanabà embugânano nyimâna: Murhahîra mukajira emikolo midârhi. ");
INSERT INTO shr_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mwanahâna enterekêro yajirwa n’omuliro, nterekêro ya nsirîra ya Nyamubâho: mpanzi ibirhi ntôrhò, ngandabuzi nguma na bâna-buzi nda ba mwâka muguma barhanagwêrhi ishembo lici. ");
INSERT INTO shr_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","N’oku nterekêro y’enkalangè yâbo, banajira enshâno y’omulà mvange n’amavurha: bigabi bisharhu bya kali ikumi oku mpanzi nguma, bigabi bibirhi bya kali ikumi, ");
INSERT INTO shr_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","oku ngandabuzi nguma na cihimbi ca kali ikumi oku ngasi mwâna-buzi wa mwa balya bâna-buzi nda. ");
INSERT INTO shr_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Mwanarherekêra n’ecihebe nka nterekêro oku byâha, lyo muhashijira empyûlo kuli mwe. ");
INSERT INTO shr_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mwajira ntyo buzira kuleka erya nterekêro y’ensirîra y’esêzi, bulya eri nterekêro y’ensiku zoshi. ");
INSERT INTO shr_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Mwâkazijira ntyo ngasi lusiku kuhika oku nsiku nda; byâbà biryo by’enterekêro ejizirwe n’omuliro, nterekêro ya kisununu kinjà embere za Nyamubâho. Eyo nterekêro kwo yakazijirwa ntyo, buzira kuleka erya y’ensiku zoshi, n’enterekêro y’embulagwa yakuja. ");
INSERT INTO shr_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Oku lusiku lwa kali nda, mwanabà n’embugânano nyimâna: murhahîra mukajira omukolo mudârhi. ");
INSERT INTO shr_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Oku lusiku lw’emburho mpyâhya, eyêzire burhangiriza, amango mukola mwarherekêra Nyamubâho enkalangè y’ebisârûlwa binyu birhangiriza oku lusiku lukulu lwinyu lw’emigobe, mwanabà n’embugânano nyimâna: murhahîra mukajira omukolo mudârhi. ");
INSERT INTO shr_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mwanarherekêra, nka nterekêro ya nsirîra ya kisununu kinjà embere za Nyamubâho, mpanzi ibirhi ntôrhò, engandabuzi na bâna-buzi nda ba mwâka muguma; ");
INSERT INTO shr_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","n’oku nterekêro y’enkalangè, enshâno y’omulà mvange n’amavurha: bigabi bisharhu bya kali ikumi oku ngasi mpanzi, bigabi bibirhi bya kali ikumi oku ngandabuzi, ");
INSERT INTO shr_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","n’ecigabi ca kali ikumi oku ngasi mwâna-buzi wa muli balya bâna-buzi nda. ");
INSERT INTO shr_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Mwanarherekêra n’ecihebe oku nterekêro n’okuhyûla kuli mwe. ");
INSERT INTO shr_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Mujire ntyo buzira kuleka erya nterekêro y’ensirîra ya ngasi mango, kuguma n’enkalangè yayo. Ezo nyama, zirhabâgakwo ishembo; kandi mwanakazihirakwo enterekêro z’embulagwa. ");
INSERT INTO shr_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Omu mwêzi gwa kali nda, oku lusiku lurhanzi lw’omwêzi, mwanabà n’embugânano nyimâna; murhahîra mukajira emikolo midârhi. Lwâbà kuli mwe lusiku lukulu lw’okubûha emishekera. ");
INSERT INTO shr_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mwarherekêra, nka nterekêro ya nsirîra, ya kisununu kinjà embere za Nyamubâho, mpanzi nguma ntôrhò, ngandabuzi nguma na bâna-buzi nda ba mwâka muguma barhanalikwo ishembo. ");
INSERT INTO shr_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","N’enterekêro y’enkalangè yajakwo, yabà ya nshâno ya mulà mvange n’amavurha: bigabi bisharhu bya kali ikumi oku mpanzi, bigabi bibirhi bya kali ikumi oku ngandabuzi, ");
INSERT INTO shr_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na cigabi ciguma ca kali ikumi oku mwâna-buzi wa muli balya bâna-buzi nda ");
INSERT INTO shr_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, ebè ya kujira empyûlo kuli mwe. ");
INSERT INTO shr_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mwajira ntyo buzira kuyibagira enterekêro y’ensirîra ya ngasi mwêzi, kuguma n’enkalangè yakuja; na buzira kuleka enterekêro y’ensirîra ya ngasi mango n’enterekêro y’enkalangè yakuja, kuguma n’enterekêro z’embulagwa zigwâsirwe okuyushûkakwo nka kulya binarhegesirwe. Ziri nterekêro zakazisingônolwa n’omuliro za kisununu kinjà embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Omu nsiku ikumi za ogwo mwêzi gwa kali nda, mwanabà n’embugânano nyimâna na kandi lwâbà lusiku lwa kucîbabaza: murhahîra mukajira omukolo mudârhi. ");
INSERT INTO shr_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mwarherekêra enterekêro y’akisûnunu kinjà embere za Nyamubâho: mpanzi nguma, ngandabuzi nguma na bâna-buzi nda ba mwâka muguma barhagwêrhi ishembo. ");
INSERT INTO shr_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Enterekêro y’enkalangè yajakwo, ebè ya nshâno ya mulà mvange n’amavurha: bigabi bisharhu bya kali ikumi oku mpanzi, bibirhi bya kali ikumi oku ngandabuzi. ");
INSERT INTO shr_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Ciguma ca kali ikumi oku ngasi muguma mwa balya bâna-buzi nda. ");
INSERT INTO shr_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mwanayûshûlakwo n’ecihebe c’enterekêro y’e­nsirîra y’empyûlo ya ngasi mango, n’enterekêro y’enkalangè yakuja, n’enterekêro z’embulagwa zigwâsirwe okuyushûkakwo. ");
INSERT INTO shr_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Omu nsiku ikumi n’irhanu z’omwêzi gwa kali nda, mwanabà n’embugânano nyimâna: Murhahîra mukajira omukolo mudârhi. Olukulu lw’okukuza Nyamubâho lwajirwa nsiku nda. ");
INSERT INTO shr_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Olwo lusiku mwanakazihâna enterekêro y’ensirîra, nterekêro yajirwa n’omuliro, ya kisununu kinjà embere za Nyamubâho: mpanzi ntôrhò ikumi n’isharhu, ngandabuzi ibirhi na bâna-buzi ikumi na bâni ba mwâka muguma barhanagwêrhi ishembo. ");
INSERT INTO shr_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","N’enterekêro y’enkalangè zayushûkakwo, zajirwa n’enshâno y’omulà mvange n’amavurha: bigabi bisharhu bya kali ikumi kuli ngasi mpanzi ya mwa zirya ikumi n’isharhu, bigabi bya kali ikumi kuli ngasi ngandabuzi nguma ya mwa zirya ibirhi ");
INSERT INTO shr_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na cigabi ciguma ca kali ikumi oku ngasi mwâna-buzi muguma wa mwa balya ikumi na bâni. ");
INSERT INTO shr_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha; buzira kuleka enterekêro y’ensirîra ya ngasi mango n’enterekêro y’enkalangè yakuja kuguma n’enterekêro z’embulagwa zakuja. ");
INSERT INTO shr_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Oku lusiku lwa kabirhi, mwanarherekêra mpanzi ntôrhò ikumi n’ibirhi, ngandabuzi ibirhi, na bâna-buzi ikumi na bâni ba mwâka muguma barhagwêrhi ishembo. ");
INSERT INTO shr_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Enterekêro y’enkalangè n’ezindi nterekêro z’embulagwa zayushûka kuli zirya mpanzi, kuli zirya ngandabuzi na kuli balya bâna-buzi, nk’oku omubalè gwâbo gunali na nk’oku binarhegesirwe. ");
INSERT INTO shr_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mwanayûshûlakwo ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, n’enterekêro y’enkalangè yakuja, kuguma n’enterekêro z’embulagwa zakuja. ");
INSERT INTO shr_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Oku lusiku lwa kasharhu, mwarherekêra mpanzi ntôrhò ikumi na nguma, ngandabuzi ibirhi, na bâna-buzi ikumi na bâni ba mwâka muguma, barhagwêrhi ishembo. ");
INSERT INTO shr_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Kuguma n’enterekêro y’enkalangè yajakwo, n’ezindi nterekêro z’embulagwa oku mpanzi, oku ngandabuzi n’oku bâna-buzi nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, enkalangè ekuja na ey’embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Oku lusiku lwa kani, mwanarherekêra mpanzi ntôrhò ikumi, bihebe bibirhi na bâna-buzi ikumi na bâni ba mwâka muguma barhanagwêrhi ishembo, ");
INSERT INTO shr_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","kuguma n’enterekêro y’enkalangè yakuja, n’ezindi nterekêro z’embulagwa oku mpanzi, oku ngandabuzi n’oku bâna-buzi nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâbà, buzira kuleka enterekêro y’ensirîra ya ngasi mango, ey’enkalangè ekuja na eya embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Oku lusiku lwa karhanu, mwanarherekêra mpanzi ntôrhò mwenda, ngandabuzi ibirhi na bâna-buzi ikumi na bâni ba mwâka muguma barhanagwêrhi ishembo; ");
INSERT INTO shr_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","kuguma n’enterekêro y’enkalangè yakuja, n’ezindi nterekêro z’embulagwa, oku mpanzi, oku ngandabuzi n’oku bâna-buzi, nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, ey’enkalangè ekuja n’ey’embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Oku lusiku lwa kali ndarhu, mwanarherekêra mpanzi ntôrhò munâni, ngandabuzi ibirhi na bâna-buzi ikumi na bâni ba mwâka muguma barhanagwêrhi ishembo; ");
INSERT INTO shr_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","kuguma n’enterekêro y’enkalangè yakuja n’ezindi nterekêro z’embulagwa, oku mpanzi, oku ngandabuzi n’oku bâna-buzi, nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, ey’enkalangè ekuja n’ey’embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Oku lusiku lwa kali nda, mwanarherekêra mpanzi ntôrhò nda, ngandabuzi ibirhi na bâna-buzi ikumi na bâni ba mwâka muguma, barhagwêrhi ishembo, ");
INSERT INTO shr_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","kuguma n’enterekêro y’enkalangè yakuja, n’ezindi nterekêro z’embulagwa, oku mpanzi, oku ngandabuzi n’oku bâna-buzi, nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, ey’enkalangè ekuja n’ey’embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Oku lusiku lwa kali munâni, mwanabà n’embugânano nkulu: murhahîra mukajira omukolo mudârhi. ");
INSERT INTO shr_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mwanarherekêra enterekêro y’ensirîra, nterekêro yajirwa n’omuliro, ya kisununu kinjà embere za Nyamubâho: mwanarherekêra mpanzi nguma, ngandabuzi nguma na bâna-buzi nda ba mwâka muguma barhanagwêrhi ishembo; ");
INSERT INTO shr_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","kuguma n’enterekêro y’enkalangè yakuja n’ezindi nterekêro z’embulagwa, oku mpanzi, oku ngandabuzi n’oku bâna-buzi, nk’oku omubalè gwâbo gunali na nk’oku irhegeko linadesire. ");
INSERT INTO shr_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mwanayûshûlakwo n’ecihebe c’enterekêro oku byâha, buzira kuleka enterekêro y’ensirîra ya ngasi mango, ey’enkalangè ekuja n’ey’embulagwa nayo ekuja. ");
INSERT INTO shr_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Zo nterekêro mwakazirherekêra Nyamubâho ezo oku nsiku nkulu zinyu, buzira kuleka enterekêro z’okuyûkiriza emihigo yinyu n’enterekêro zinyu z’obulonza bwinjà: zo nterekêro z’ensirîra zinyu, enterekêro z’enkalangè zinyu, embulagwa zinyu n’enterekêro z’omurhûla. ");
INSERT INTO shr_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mûsa anacibwîra bene Israheli nk’oku Nyamubâho anali amurhegesire koshi (cfr 29, 40). ");
INSERT INTO shr_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mûsa ashambâla n’abarhambo b’emilala ya bene Israheli aderha, erhi: «Alagi oku Nyamubâho arhegesire: ");
INSERT INTO shr_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Erhi omulume ankarhôla omuhigo embere za Nyamubâho, nîsi erhi ankajira endahiro y’okuyûkiriza mulâli mulebe, oyo mulume arhacishubaga omu kanwa kâge; ngasi ebi adesire omu kanwa kâge byoshi, anabiyûkirizagye”. ");
INSERT INTO shr_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","“Erhi omukazi, amango aciri munyere omu nyumpa y’îshe, akabà ahânyire omuhigo embere za Nyamuzinda, na ntyo acîshwêke na mulâli mulebe”, ");
INSERT INTO shr_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","“erhi îshe ankamanya ogwôla muhigo gwâge n’eco ciragâne câge acîshwekagamwo yêne, erhi îshe ankahulika kwônene, arhamubwîre akantu, emihigo olya munyere ankarhôla, na ngasi milâli anajizire yoshi enali y’okuli”. ");
INSERT INTO shr_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ci erhi îshe ankamanya okw’erya mihigo, akanalahira mpu okwo kurhabè, emihigo y’emilâli nyamunyere acîshwekagamwo erhacigwêrhi buhashe buci; na Nyamubâho anamubabalira, ebwa kubà anamulahirire”. ");
INSERT INTO shr_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","“Erhi ankabà aherusire, n’emihigo yâge ecimubako, nîsi erhi akabà acibà ashwesirwe n’emilâli yarhengaga omu kanwa kâge omu kuhalabuka”, ");
INSERT INTO shr_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","“ibà erhi ankamanya kulya akanahulika ago mango amamanya, olya mukazi anayôrha ashwesirwe n’erya mihigo yâge, kuguma n’erya milâli yâge acîshwekagamwo”. ");
INSERT INTO shr_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ci erhi ibà, olusiku amanya kulya akalahirira nyamukazi, omuhigo olya mukazi ajizire, n’omulâli arhôlaga omu kuhalabuka birhacimushwêsiri, na Nyamubâho anamubabalira”». ");
INSERT INTO shr_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Omuhigo gw’omukazi, omukana, erhi ogw’omukazi wahulusîbwe n’ibà, ngasi muhigo na ngasi mulâli mukazi wa bêne oyo ankanajira gunali gw’okuli kuli ye. ");
INSERT INTO shr_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Erhi akabà omu mw’ibà mw’omukazi arhôleraga omuhigo, erhi abè omwôla mwo ahâniraga ogwo muhigo gw’okucîshweka, ");
INSERT INTO shr_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","erhi îba ankamanya akanacîhulikira, arhamuhakanîre, emihigo yâge yoshi enali y’okunali, kuguma n’emilâli anacishwêkagamwo yoshi yêne. ");
INSERT INTO shr_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ci erhi îba ankamanya, n’erya mihigo ayilahîre, ebyarhenzire ekanwa kâge byoshi birhaciri by’okuli: ibà anabirhenzize, na Nyamubâho anamubabalira kuli byo. ");
INSERT INTO shr_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ngasi muhigo na ngasi ndahiro omukazi ankahigamwo okucîbabaza, ibà anahasha okuyêmêra erhi okuhakana eyo mihigo. ");
INSERT INTO shr_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Erhi îba ankahulika kwônene mango malebe, erhi amâyêmêra erya mihigo ya mukâge, ekola y’okunali. Ekola y’okuli ebwa kubà îba anahulisire, arhamubwîzire cici n’obwo ali amanyire. ");
INSERT INTO shr_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Erhi ankayirhenza buzinda, n’obwo ali amanyire agalinahulika, yêne anabarhule obubî bwanagwârhe mukâge. ");
INSERT INTO shr_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ago go marhegeko Nyamubâho ahâga Mûsa oku biyêrekîre omukazi n’ibà, oku biyêrekîre îshe w’omunyere n’omunyere yêne, akabà aciri murhò, aciri omu nyumpa y’îshe. ");
INSERT INTO shr_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Nyamubâho ashambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Ogendicîhôlera bene Israheli kuli bene Madiani; n’enyuma z’aho wanahêkwa emunda olubaga lwâwe lwajire.» ");
INSERT INTO shr_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mûsa akanya agendishambâla n’olubaga, alubwîra, erhi: Mujire abalume ba muli mwe barhôle emirasano, bagende matabâro, bagendilwîsa Madiani, lyo bajira olwihôlo lwa Nyamubâho kuli Madiani. ");
INSERT INTO shr_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Okwôla matabâro, murhumekwo balume cihumbi b’omu ngasi mulala ba muli erya milala ya bene-Israheli. ");
INSERT INTO shr_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Omu bihumbi bya bene Israheli, bajà bacishogamwo balume cihumbi oku ngasi mulala, kwo kuderha oku baligi balume bihumbi ikumi na bibirhi bàjîre oku matabâro. ");
INSERT INTO shr_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mûsa abarhuma ebwa kulwa, balume cihumbi oku mulala, bagenda na Pinasi, mwene omudâhwa Eleazari, ye wali odwîrhe ebirugu bimâna n’erya mishekera y’okushekereza. ");
INSERT INTO shr_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Barhabâlira Madiani nka kulya Nyamubâho anarhegekaga Mûsa, banaciyîrha abalume boshi. ");
INSERT INTO shr_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Bayîrha n’abâmi b’e Madiani; bo: Evi, Rekemi, Suri, Huru na Reba, bâmi barhanu b’e Madiani. Balâmu mwene Beori naye bamufu­nda engôrho. ");
INSERT INTO shr_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Bene Israheli bayisha badwîrhe mpira abakazi b’e Madiani n’abâna bâbo barhò; bahagula, banyaga na ngasi bishwêkwa byâbo bya okukazikola na ngasi gandi masô gâbo n’ebindi birugu byâbo byoshi. ");
INSERT INTO shr_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ngasi lugo bàbagamwo lwoshi baludûlika muliro na ngasi aha banahandaga hoshi. ");
INSERT INTO shr_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Erhi babà bamashana eminyago yâbo na ngasi bindi banahagwire byoshi, abantu n’ebintu, ");
INSERT INTO shr_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","bahêka balya bagwârhagwa mpira n’erya minyago emunda Mûsa ali na Eleazari, ye mudâhwa, n’olubaga loshi lwa bene Israheli oku cihando, omu rhubanda rhwa bene Mowabu, hôfi na Yordani aha ishiriza lya Yeriko. ");
INSERT INTO shr_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mûsa, omudâhwa Eleazari, n’abarhambo boshi b’olubaga bayisha bali bayankirira emuhanda gw’ecihando. ");
INSERT INTO shr_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mûsa akunirira abarhambo b’eyo ngabo yali oku matabâro, bo balya barhambo b’ebihumbi n’ab’amagana, barhengaga ebwa matabâro. ");
INSERT INTO shr_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Abadosa, erhi: «Carhumaga murhayîrha abakazi boki? ");
INSERT INTO shr_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“Bo balya, oku kanwa ka Balâmu, bakululiraga bene Israheli ebwa kugomera Nyamubâho, mwa kulya kwabaga e Peori; na okwo kwarhuma obuhanya bujà omu lubaga lwa Nyamubâho”. ");
INSERT INTO shr_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","“Buno muyîrhage ngasi wa bûko mulume, omu bâna bâbo, na ngasi mukazi okola olâzire n’omulume”. ");
INSERT INTO shr_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","“Ci abânanyere boshi barhacimanya mulume murhabayîrhaga; bâli binyu abo”. ");
INSERT INTO shr_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ninyu mwene mugendihanda e mbuga ly’ecihando nsiku nda; ngasi yêshi wayîsire omuntu na ngasi yêshi wahumire oku mufù, anagendicîcêsa oku lusiku lwa kasharhu n’olusiku lwa kali nda, mwe n’abashwêkwa binyu”. ");
INSERT INTO shr_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","“Mucêse na ngasi mwambalo, ngasi kalugu kajiragwa n’oluhù, ngasi kalugu kajiragwa n’amôya g’empene na ngasi kalugu kajiragwa n’omurhi”». ");
INSERT INTO shr_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Omudâhwa Eleazari abwîra balya bantu bâli oku matabâro, erhi: «Alagi ebirhegesirwe na lirya irhegeko Nyamubâho ahâga Mûsa: ");
INSERT INTO shr_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","“Amasholo, ebyûma by’olunyerere, eby’omulinga, ebyûma by’akasiteriti na ebya amasasi, ngasi cirugu cankanahashihirwa ecîko, rnunacihire omu muliro; canabà cinjà. Cikwônene cicigwâsirwe naco okucêsibwa n’amîshi g’okucêsa. Ngasi hyoshi hirhankaja ecîko, munahicêse n’amîshi”. ");
INSERT INTO shr_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","“Ngasi cirugu cankahashihirwa ecîko, munacihire omu muliro; canaba cinjà. Ci kwônene cicigwâsirwe naco okucêsibwa n’amîshi g’okucêsa. Ngasi hyoshi hirhankaja ecîko, munahicêse n’amîshi”. ");
INSERT INTO shr_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","“Mwanashuka emyarmbalo yinyu oku lusiku lwa kali nda; rnwanacêsibwa n’enyuma z’aho mwanahashijà omu cihando”». ");
INSERT INTO shr_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Nyamubâho ashambâla na Mûsa amubwîra; erhi: ");
INSERT INTO shr_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Woyo n’omudâhwa Eleazari n’abarhambo b’emilala y’olubaga, mujire omubalè gw’ebi banyagaga byoshi bibè bya bantu, bibè bya bintu. ");
INSERT INTO shr_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Kandi wanagaba eyo minyago, cihimbi ciguma kuli balya bâli oku matabâro n’ecindi oku lubaga lwoshi. ");
INSERT INTO shr_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Oku cigabi c’abalwî bâli oku rnatabâro wanayankakwo ecigabi ca Nyamubâho, kwo kuderha cigabi ciguma oku magana arhanu ga bantu, ga nkâfu, ga ndogomi, erhi ga bibuzi. ");
INSERT INTO shr_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Wanarhôla kuli cirya cigabi câbo, wanaha omudâhwa Eleazari nka rnpongano ya Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kuli cirya cindi cigabi cahâbwa bene Israheli, wanaberûla ciguma oku bishwêkwa; wanaha bene Levi, balya bajira omukolo gw’okulanga Endâro ya Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mûsa n’omudâhwa Eleazari banacijira nka kulyâla Nyamubâho anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ebyanyagagwa na balya bâli bajire oku matabâro, bibuzi bihumbi magana gali ndarhu na makumi gali nda na birhanu. ");
INSERT INTO shr_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Nkâfu bihumbi makumi gali nda n’ibirhi, ");
INSERT INTO shr_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ndogorni bihumbi makumi gali ndarhu na ciguma. ");
INSERT INTO shr_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Oku biyêrekîre abantu, owa bûko mukazi olya orhalisâgiyankwa na mulume bâli bantu bihumbi makumi asharhu na bibirhi boshi haguma. ");
INSERT INTO shr_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Cigabi ciguma cahâbwa balya bâli oku rnatabâro; bibuzi bihumbi magana asharhu na makumi asharhu na nda, na rnagana arhanu. ");
INSERT INTO shr_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Muli byo, rnagana gali ndarhu na rnakumi gali nda na birhanu byaberûlirwa Nyamubâho; ");
INSERT INTO shr_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","nkâfu bihumbi makumi asharhu na ndarhu, na muli zo mwarhenga nkâfu makumi gali nda n’ibirhi ziberûlirwe Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ndogorni bihumbi rnakumi asharhu na magana arhanu na muli zo mwarhenga ndogorni makumi gali ndarhu na nguma ziberûlirwe Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Na bantu bihumbi ikumi na ndarhu, na makumi asharhu na babirhi baberûlirwa Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mûsa aha omudâhwa Eleazari eyo mpongano yaberûliragwa Nyamubâho nka kulya Nyamubâho anali arhegesire Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ebiyêrekîre cirya cigabi cahâbagwa bene Israheli, co cirya Mûsa aberûlaga kuli cirya cahâbagwa abalwî. ");
INSERT INTO shr_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Eco cigabi cahâbagwa olubaga càli ntya: Bibuzi bihumbi magana asharhu na makumi asharhu na nda na rnagana arhanu, ");
INSERT INTO shr_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nkâfu bihumbi rnakumi asharhu na ndarhu, ");
INSERT INTO shr_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ndogorni bihumbi makumi asharhu na magana arhanu, ");
INSERT INTO shr_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","na bantu bihumbi ikumi na ndarhu. ");
INSERT INTO shr_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kuli eco cigabi cahâbagwa bene Israheli, Mûsa oku ngasi makumi arhanu arhôlakwo cintu ciguma, n’ebyo abiha bene Levi, bo bajira omukolo gw’okulanga Endâro ya Nyamubâho, nka kulya Nyamubâho anarhegekaga Mûsa. ");
INSERT INTO shr_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Abarhambo b’ebihumbi n’abarhambo b’amagana, banayisha bajà emunda Mûsa ali, ");
INSERT INTO shr_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","banacimubwîra, mpu: «Abarhumisi bâwe baganjire abasirika rhwàli rhulongolîne, harhabulisiri ciru n’omuguma. ");
INSERT INTO shr_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Co cirhumire rhulihâna enterekêro emwa Nyamubâho: amasholo ngasi muguma arhôzire, engolo, emigufu, orhugondo, ebisikiyo n’amagerha; rhulijiramwo enterekêro y’okuhyûla embere za Nyamubâho». ");
INSERT INTO shr_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mûsa n’omudâhwa Eleazari banacirhôla ebyo birugu, ago masholo n’ebyôla bindi birugu byàli erhi byakozirwekwo. ");
INSERT INTO shr_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Amasholo baberûlaga bagaha Nyamubâho, balya barhambo b’ebihumbi n’ab’amagana gahika omu buzirho bwa sikêli bihumbi ikumi na ndarhu na magana gali nda na makumi arhanu. ");
INSERT INTO shr_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Balya bantu bàlilwa bakazihêka ngasi muguma ecâge cihimbi c’omunyago. ");
INSERT INTO shr_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mûsa n’omudâhwa Eleazari erhi babà bamârhôla ngasi masholo bahâbagwa n’abarhambo b’ecihumbi n’ab’amagana, bagahêka omw’Ihêma ly’Embugânano, nka kakengêzo ka bene Israheli embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Bene Rubeni na bene Gadi bali bagwêrhe masô manji bwenêne ga bishwêkwa. Erhi babona oku ecihugo ca Yazeri n’ecihugo ca Galadi biri bihugo binjà kuli ago masô gâbo, ");
INSERT INTO shr_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","bene Rubeni na bene Gadi bakanya bajà emunda Mûsa àli n’omudâhwa Eleazari n’abarhambo b’olubaga, banacibabwîra, mpu: ");
INSERT INTO shr_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Ataroti, Diboni, Nimra, Hesboni, Eleale, Sebami, Nebo na Beoni, eci ");
INSERT INTO shr_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","cihugo Nyamubâho anyagaga embere z’olubaga lwa bene Israheli, ciri cihugo cikwânîne olwabûko, na bambali bâwe bagwêrhe amasò.» ");
INSERT INTO shr_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Bayûshûla, mpu: «Akabà nîrhu rhurhonyire emunda oli, eci cihugo cihâbwe bambali bâwe, kabè ko kashambala kâbo, orhanacirhuyikizagya Yordani». ");
INSERT INTO shr_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mûsa ashuza bene Gadi na bene Rubeni, erhi: «Kàli bene winyu bakolaga oku matabâro ninyu moyo musigale ahâla? ");
INSERT INTO shr_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Carhuma mubulisa bene Israheli oburhwâli bw’okujà muli cirya cihugo Nyamubâho ajibaha? ");
INSERT INTO shr_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Kwa bene oko basho bajiraga erhi mbarhuma nti bagendiyênja ecihugo kurhenga e Kadesi-Barnea. ");
INSERT INTO shr_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Basôka kuhika ebwa kabanda ka Eskoli, banacibona ecihugo, banaciyisha balibulîsa bene Israheli oburhwâli bw’okujà muli cirya cihugo Nyamubâho àli abahire. ");
INSERT INTO shr_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","N’oburhè bwa Nyamubâho bwanaciyâka bwenêne olwo lusiku; anacihiga erhi: ");
INSERT INTO shr_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Abâla bantu barhengaga e Mîsiri banakola bagwêrhe myâka makumi abirhi babusirwe na kujà enyanya, barhabone kuli cirya cihugo nalaganyagya n’endahiro nti nacihà Abrahamu, Izaki na Yakôbo, ebwa kubà barhankulikiraga n’obwêmêre. ");
INSERT INTO shr_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Aha nyuma lya Kalebu mwene Yefunè w’omunya-Kenezeni na Yozwè mwene Nuni, abo bashimbulîre Nyamubâho n’obwêmêre. ");
INSERT INTO shr_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Lêro oburhè bwa Nyamubâho bwanaciyâka kuli bene Israheli, kwarhuma abaheka omw’irungu myâka makumi anni, kuhika lirya iburha lyajiriraga Nyamubâho amabî lihungumuke. ");
INSERT INTO shr_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Loli oku mwamaja ahâli ha basho, nka milandûkiza y’ababusi banyabyâha, mukola mwayûshûla oburhè bwa Nyamubâho kuli bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mukalahira bwamushimba, ashubiyûshûla okuleka bene Israheli muno irungu, munarhume olu lubaga loshi luhwa.» ");
INSERT INTO shr_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Bayegera emunda Mûsa ali, banacimubwîra, mpu: «Rhwayûbaka aha engurhu oku masô gîrhu, rhuyûbake n’ebishagala oku bâna bîrhu barhò. ");
INSERT INTO shr_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","“Kuli rhwe, buzira kulegama, rhwarhôla emirasano yîrhu, rhugenzikanwe na bene Israheli, kuhika rhubahise muli cirya cihugo bagwâsirwe okuyûbakamwo, n’abâna bîrhu banayôrha muli ebyo bishagala rhwayûbaka buzibuzibu, omu kuyôboha abantu ba muli eco cihugo”. ");
INSERT INTO shr_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","“Rhurhagaluke emwa bîrhwe kuhika bene Israheli bajè bayûbaka ngasi muguma muli cirya cihugo c’akashambala kâge”. ");
INSERT INTO shr_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","“Bulya rhurhacibe na kashambala kaci haguma nabo olwo lundi lunda lwa Yordani, ciru na oli kuli kulusha, ebwa kubà akashambala kîrhu rhwakahirwe ebwa lîno ishiriza lya Yordani e Buzûka-zûba”». ");
INSERT INTO shr_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mûsa abashuza, erhi: Akabà yo na njira mwakulikira eyo, mukanarhôla emirasano yinyu mugenzikanwa mweshi na Nyamubâho, ");
INSERT INTO shr_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","akabà abalume badwîrhe emirasano yâbo bayikira Yordani embere za Nyamubâho bagenzikanwe n’abâbo kuhika Nyamubâho abè amarhenza abanzi bâge embere zâge, ");
INSERT INTO shr_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","n’akabà murhagaluke nk’ecihugo cirhacija coshi omu maboko ga Nyamubâho, aho mwanabà buzira bubî embere za Nyamubâho n’embere za bene Israheli, n’ecihugo canabà ko kashambala kinyu embere za Nyamubâho. ");
INSERT INTO shr_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ci akabà murhajiziri ntyo, loli oku mwamajira ecâha emunda Nyamubâho ali; munamanye oku ecâha cinyu camukulikira. ");
INSERT INTO shr_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Muyûbakage ebishagala oku bâna binyu, muyûbakage n’engurhu oku masô ginyu, munayûkirize ebyo binwa birhenzire ekanwa kinyu. ");
INSERT INTO shr_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Bene Gadi na bene Rubeni banashambâza Mûsa, bamubwîra, mpu: Abarhumisi bâwe bajira nk’okwo nnawîrhu adesire. ");
INSERT INTO shr_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Abâna bîrhu, bakirhwe, amasò gîrhu n’ebishwêkwa bîrhu byoshi byasigala aha omu bishagala bya Galadi. ");
INSERT INTO shr_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Nabo abarhumisi bâwe, ngasi yêshi onahêka emirasano y’okulwa, bayikira bagere embere za Nyamubâho bajilwa nk’okwo nnawîrhu adesire. ");
INSERT INTO shr_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Lêro aho, kuli bo, Mûsa abâna aga marhegeko emunda omudâhwa Eleazari ali, na Yozwè, mwene Nuni, n’abarhambo b’emilala yoshi ya bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mûsa ababwîra, erhi: «nka bene Gadi na bene Rubeni bamâyikira Yordani, bo balya balume boshi banagwâsirwe okuyanka emirasano yâbo bajilwa embere za Nyamubâho, na nka ecihugo coshi cikola cinyu, mwanayishibaha, nka kashambala kâbo, ecihugo ca Galadi. ");
INSERT INTO shr_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ci erhi akabà barhayikirini emirasano yaho bagenzikanwa mweshi nabo, mwanayîshibayûbasa ekarhî kinyu omu cihugo ca Kanâni.» ");
INSERT INTO shr_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Bene Gadi na bene Rubeni bashuza, baderha, mpu: «Oku Nyamubâho abwîzire bambali bâwe rhwakujira. ");
INSERT INTO shr_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Rhwayikira n’emirasano yîrhu, rhugenzikanwe na Nyamubâho e Kanâni; n’akashambala k’omwîmo gwîrhu kanayôrha luno lundi lunda lwa Yordani.» ");
INSERT INTO shr_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mûsa aha bene Gadi na bene Rubeni na cihimbi ciguma ca bene Menashè ga Yozefu obwâmi bwa Sihoni, mwâmi w’Abanyamoreni, abahà n’obwâmi bwa Og mwâmi w’e Bashani, abahà ecihugo coshi, n’ebishagala bya muli co byoshi, emirhundu ya muli co yoshi n’ebindi bishagala biri elubibi lw’eco cihugo. ");
INSERT INTO shr_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Bene Gadi banaciyûbaka Diboni, Ataroti, na Aroweri, ");
INSERT INTO shr_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ataroti-Sofani, Yazeri, Yogboha, ");
INSERT INTO shr_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beti-Nimra, Beti-Harani, byoshi byàli bishagala bizibuzibu; banaciyûbaka n’engurhu oku masô gâbo. ");
INSERT INTO shr_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Bene Rubeni bayûbaka Heseboni, Eleale, Kiriyatayimi. ");
INSERT INTO shr_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo na Baal Meoni; ci amazîno gâbo gayîsh’ihinduka buzinda; bayûbaka na Sibma, banajà bayîrika ebyo bishagala bajaga banyaga amazîno. ");
INSERT INTO shr_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Bene Makiri, mwene Menashè, barhabâlira Galadi, n’erhi babà bamamunyaga, bakungusha Abanyamoreni bayûbakagamwo. ");
INSERT INTO shr_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mûsa, ecihugo ca Galadi acîhà Makiri, mwene Menashè; naye anaciyûbaka mulico. ");
INSERT INTO shr_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yayiri, mwene Menashè, arhabâla, arhôla ebishagala byâbo, abiyîrika izîno mpu byo: Bishagala bya Yakiri. ");
INSERT INTO shr_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobahu, arhabâla, arhôla ecihugo ca Kenati n’ebishagala byâco; acîhà izîno lyâge. ");
INSERT INTO shr_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Alaga ebihando bya bene Israheli erhi barhenga omu cihugo c’e Mîsiri, omu kushimba oku emirhwe yâbo yali, oku burhegesi bwa Mûsa na Aroni. ");
INSERT INTO shr_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mûsa akazâg’iyandika ahantu bahanzire, n’aha barhenga nk’oku ebihando byâbo byanali; akazishimba irhegeko ahirwe na Nyamubâho. Alaga ebihando byâbo omu kushimba aha banarhengaga hoshi. ");
INSERT INTO shr_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Barhenga e Ramsesi omu mwêzi gwa burhanzi, omu nsiku ikumi n’irhanu za ogwôla mwêzi gwa burhanzi. Mwâli omu lusiku lurhanzi lukulikira Basâka erhi bene Israheli barhenga e Mîsiri bagenda bacîshinga, bagera embere z’Abanya-Mîsiri boshi. ");
INSERT INTO shr_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Ago mango erhi Abanya-Mîsiri badwîrhe babisha bene wâbo balya bayîrhagwa na Nyamubâho, balya bâli b’enfula boshi; Nyamubâho ayêrekana obushinganyanya bwâge oku bandi banyamuzinda. ");
INSERT INTO shr_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Erhi barhenga e Ramsesi, bene Israheli bagendihanda e Sukoti. ");
INSERT INTO shr_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Barhenga e Sukoti, bagendihanda aha Etami, cihugo ciri oku burhambi bw’irungu. ");
INSERT INTO shr_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Barhenga aha Etami, na erhi babà bamagolonjokera ebwa Pihahiroti, ôbà ah’ishiriza lya Balsefoni, bagend’ihanda embere za Migdoli. ");
INSERT INTO shr_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Barhenga aho mbêre za Pihahiroti, bayikira omu karhî k’enyanja, bajà ebw’irungu. Erhi bayûsa nsiku isharhu, bagenda omw’irungu ly’Etami, bagendihanda aha Mara. ");
INSERT INTO shr_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Barhenga aha Mara, bagend’ihanda aha Elimi, abo hàli maliba ikumi n’abirhi na mirhanda makumi gali nda; banacihanda aho. ");
INSERT INTO shr_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Barhenga aha Elimi bagendihanda hôfi n’enyanja Ndukula. ");
INSERT INTO shr_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Barhenga ebwa nyanja Ndukula, bagendihanda omw’irungu lya Sini. ");
INSERT INTO shr_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Barhenga omw’irungu lya Sini, bagendihanda aha Dofka. ");
INSERT INTO shr_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Barhenga aha Dofka, bagendihanda aha Alusi. ");
INSERT INTO shr_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Barhenga aha Alusi, bagendihanda aha Refidimi n’aho harhàli mîshi ga kunywa oku lubaga. ");
INSERT INTO shr_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Barhenga e Refidimi, bagendihanda omw’irungu lya Sînayi. ");
INSERT INTO shr_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Barhenga omw’irungu lya Sînayi, bagendihanda aha Kabroti Hatava. ");
INSERT INTO shr_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Barhenga aha Kibroti-Hatava, bagendihanda abà Haseroti. ");
INSERT INTO shr_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Barhenga aha Haseroti, bagend’ihanda aha Ritima. ");
INSERT INTO shr_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Barhenga aha Ritima, bagendihanda aha Rimôni-Pêres. ");
INSERT INTO shr_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Barhenga aha Rimôni-Pêres bagendibanda aha Libna. ");
INSERT INTO shr_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Barhenga aha Libna, bagendihanda aha Risa. ");
INSERT INTO shr_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Barhenga aha Risa, bagendihanda aha Kehelata. ");
INSERT INTO shr_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Barhenga aha Kehelata, bagendihanda oku ntondo ya Seferi. ");
INSERT INTO shr_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Barhenga oku ntondo ya Seferi, bagendibanda aha Harada. ");
INSERT INTO shr_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Barhenga aha Harada, bagendihanda aha Makeloti. ");
INSERT INTO shr_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Barhenga aha Makeloti, bagendihanda aha Tahata. ");
INSERT INTO shr_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Barhenga aha Tahata, bagendihanda aha Terahi. ");
INSERT INTO shr_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Barhenga aha Terahi, bagendihanda aha Mitika. ");
INSERT INTO shr_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Barhenga aha Mitika, bagendihanda aha Hasmona. ");
INSERT INTO shr_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Barhenga aha Hasmona, bagendihanda aha Moseroti. ");
INSERT INTO shr_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Barhenga aha Moseroti, bagendihanda aha Bene-Yakani. ");
INSERT INTO shr_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Barhenga aha Bene-Yakani, bagendihanda aha Hori-Gidgadi. ");
INSERT INTO shr_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Barhenga aha Hori-Gidgadi, bagendihanda aha Yotebata. ");
INSERT INTO shr_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Barhenga aha Yotebata, bagendihanda aha Abrona. ");
INSERT INTO shr_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Barhenga aha Abrona, bagendihanda aha Esiongeberi. ");
INSERT INTO shr_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Barhenga aha Esiongeberi, bagndihanda omw’irungu lya Sini, kwo kuderha aha Kadesi. ");
INSERT INTO shr_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Barhenga aha Kadesi, bagendihanda oku ntondo ya Hori, aha buzinda bw’ecihugo c’Edomu. ");
INSERT INTO shr_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Omudâhwa Aroni, asôkera oku ntondo ya Hori, oku irhegeko lya Nyamubâho ajifîrakwo; mwâli omu mwâka gwa makumi anni kurhenga bene Israheli barhenzire e Mîsiri, omu mwêzi gwa karhanu, omu lusiku lurhanzi lw’omwêzi. ");
INSERT INTO shr_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aroni àli akola mukulu wa myâka iganana makumi abirhi n’isharhu, erhi afîra oku ntondo ya Hori. ");
INSERT INTO shr_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Omunya-Kanâni, mwâmi Aradi, owayûbakaga e Nêgebu omu cihugo ca Kanâni, amanya oku bene Israheli bayishire. ");
INSERT INTO shr_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Barhenga oku ntondo ya Hori, bagendihanda aha Salmona. ");
INSERT INTO shr_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Barhenga aha Salmona, bagendihanda aha Punoni. ");
INSERT INTO shr_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Barhenga aha Punoni, bagendihanda aha Oboti. ");
INSERT INTO shr_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Barhenga aha Oboti, bagendihanda aha Iye-Abarimi, oku lubibi lwa Mowabu. ");
INSERT INTO shr_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Barhenga aha Iyim-Abarimi, bagendihanda aha Diboni-Gadi. ");
INSERT INTO shr_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Barhenga aha Diboni-Gadi, bagendihanda aha Almoni-Diblatayima. ");
INSERT INTO shr_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Barhenga aha Almoni-Diblatayima, bagendihanda omu birhondo bya Abarimu, ishiriza lya Nebo. ");
INSERT INTO shr_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Barhenga omu birhondo bya Abarimu, bagendihanda omu rhubanda rhwa Mowabu, hôfi na Yordani, aha ishiriza lya Yeriko. ");
INSERT INTO shr_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Bahanda hôfi na Yordani, kurhenga kuli Beti-ha-Yesimoti kuhika aha Abeli-ha-Shitimi, omu rhubanda rhwa Mowabu. ");
INSERT INTO shr_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Nyamubâho ashambâla na Mûsa omu rhubanda rhwa Mowabu; anacimubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Ogendibwîra bene Israheli ntya, erhi: Amango mwanayikire Yordani, na nka mwamaja omu cihugo ca Kanâni, ");
INSERT INTO shr_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","munakungushe embere zinyu, abayûbaka muli eco cihugo boshi. Muhongole amabuye gâbo matâke goshi, muvungunyule n’ensanamu zâbo z’omulinga bàtulaga, munagendihagula ebwa mpêro zâbo omu birhwa. ");
INSERT INTO shr_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mwayîma muli eco cihugo, munaciyûbake; bulya nammuhîre eco cihugo nti muciyîmemwo. ");
INSERT INTO shr_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mugabâne eco cihugo omu kuciyeshera ecigole, oku emilala yinyu enali. Abà mwahà akashambala kanene babè erhi bo banali banji, n’abà mwahà akashambala kasungunu babè erhi bo banali basungunu. Ecihimbi ecigole cankanahà omuntu erhi co na câge. Mwanacirhôla cibè cinyu nk’oku emilala ya bashakulûza binyu enali. ");
INSERT INTO shr_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ci erhi akabà murhakungushire embere zinyu abo bayûbaka omu cihugo, abà mwakanaleka muli bo ekarhî kinyu bakaziyôrha nka mishûgi emuli omu masù, na nka marhadu omu nkanga. Banakaziyôrha bamulola nka bashombanyi bâbo muli eco cihugo mwajiyubakamwo. ");
INSERT INTO shr_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ninyu mwene, nanamulibûsa nk’oku nali ndâlîre okubalibûsa. ");
INSERT INTO shr_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Nyamubâho anacishambâla na Mûsa, amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Ojirhegeka bene Israheli obabwîre ntya: “Amango mwaja omu cihugo c’e Kanâni, alagi ecihugo mwagendigabânana: Co cihugo ca Kanâni, nk’oku embibi zâge zinali”. ");
INSERT INTO shr_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“Olunda lw’emukondwè, kuli mwe lwâbà irungu lya Sini, kuhika aha Edomu, n’olubibi lwinyu lw’ebuzûka-zûba lwarhenga oku cikwi c’eyo buzûka-zûba bw’enyanja y’omunyu”, ");
INSERT INTO shr_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","“n’olwo lubibi lwinyu lwanayandagalira emukondwè, lugere oku murhezi gw’Akrabimi, lugere e Sini, lugendihika emukondwè aha Kadesi-Barnea. Lwanashubigenda, lugere e Hasari-Adari, kandi lugere olunda lw’e Asemoni”. ");
INSERT INTO shr_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","“Kurhenga e Asemoni, olwo lubibi lwahika oku mugezi gw’e Mîsiri, lugendihwêra oku Nyanja”. ");
INSERT INTO shr_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Nalo olubibi lw’e Mashinji lwâbà Enyanja Nene: lwo lubibi lwinyu olunda lw’e buzika-zûba”. ");
INSERT INTO shr_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Lolagi olwabà lubibi lwinyu olunda lw’emwênè: kurhenga oku Nyanja nnene”, ");
INSERT INTO shr_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","“mwanatwa olubibi lwinyu kuhika oku ntondo ya Hori: kurhenga oku ntondo ya Hori, mwalukanyanya aha Muhango gwa Hamati, olubibi lwanahika aha Sedadi”. ");
INSERT INTO shr_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","“Lwagenda kuhika aha Zifroni, lugendihwêra aha Hasari-Enani: lwo lwâbà lubibi lwinyu olwo lw’emwênè”». ");
INSERT INTO shr_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","«Mwanatwa olubibi lwinyu lw’ebuzûka-zûba bwa Hasari-Enani aha Sefami. ");
INSERT INTO shr_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","“Olwo lubibi lwanabunguluka kurhenga e Sefami kujà e Harbela ebuzûka-zûba bwa Ayini, lwanayandagala lugere burhambirhambi omu rhurhondo rhuli eburhambi bw’enyanja ya Kinereti olunda lw’ebuzûka-zûba”. ");
INSERT INTO shr_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","“Lwanayandagala kuli Yordani, lugendihwêra oku nyanja y’omunyu. Co cihugo cinyu ecôla n’oku embibi zâco zinacizungolosire.”» ");
INSERT INTO shr_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mûsa aha bene Israheli eri irhegeko aderha, erhi: «Eco co cihugo Nyamubâho arhegesire mpu cihâbwe erya milala mwenda haguma na cirya cihimbi c’omulala. ");
INSERT INTO shr_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","“Bulya omulala gwa bene Rubeni nka kulya enyumpa za bashakulûza bâbo zinakulikirana, n’omulala gwa bene Gadi, nabo nk’oku enyumpa za bashakulûza wâbo zinakulikirana, bôhe mîra bahâbagwa akabo kashambala: n’ecihimbi c’omulala gwa Menashè naco cahabirwe akâco kashambala”. ");
INSERT INTO shr_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","“Eyo milala ibirhi n’eco cihimbi c’omulala, bahâbirwe akashambala kâbo ebwa lindi ishiriza lya Yordani, aha ishiriza lya Yeriko, olunda lw’ebuzûka-zûba”». ");
INSERT INTO shr_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Nyamubâho anacishambâla na Mûsa amubwîra, erhi: ");
INSERT INTO shr_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Alaga amazîno g’abantu bagendimugabira eryo ishwa: omudâhwa Eleazari na Yozwè, mwene Nuni. ");
INSERT INTO shr_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","“Kandi wanaja warhôla murhambo muguma muguma omu ngasi mulala, omu kugaba eryo ishwa”. ");
INSERT INTO shr_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Alaga amazîno g’abo bantu: Oku mulala gwa Yûda, Kalebu, mwene Yefunè”; ");
INSERT INTO shr_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","“Oku mulala gwa bene Simoni, Shemweli mwene Amihudi”; ");
INSERT INTO shr_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","“Oku mulala gwa Benyamini, Elidadi, mwene Kisloni”; ");
INSERT INTO shr_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","“Oku mulala gwa bene Dani, omurhambo Buki, mwene Yogli”; ");
INSERT INTO shr_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","“Kuli bene Yozefu: oku mulala gwa bene Menashè, omurhambo Hanieli mwene Efodi”; ");
INSERT INTO shr_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","“Kuli bene Efrayimu, omurhambo Kemueli, mwene Shiftani”; ");
INSERT INTO shr_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","“Oku mulala gwa bene Zabuloni, omurhambo Elisafani, mwene Parnaki”; ");
INSERT INTO shr_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","“Oku mulala gwa bene Isakari, omurhambo Paltieli, mwene Azani”; ");
INSERT INTO shr_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","“Oku mulala gw’Aseri; omurhambo Ahihudi, mwene Shelomi”; ");
INSERT INTO shr_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","“Oku mulala gwa Nefutali, omurhambo Pedaheli, mwene Amihudi.”» ");
INSERT INTO shr_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Abo bo Nyamubâho arhegekaga mpu ecihugo ca Kanâni bacigabire bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Nyamubâho ashambâla na Mûsa omu rhubanda rhwa Mowabu, hôfi na Yordani, aha ishiriza lya Yeriko aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Orhegeke bene Israheli, oku kashambala ayishihâbwa, bajè bahakwo bene Levi ebishagala bayûbakamwo. Mubahè n’amalambo bakaziyabuliramwo eburhambi bwa ebyo bishagala. ");
INSERT INTO shr_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Obahè aha bayûbaka, n’amalambo bankahasha okukaziyabulira­mwo ebishwêkwa byâbo, ebinene n’ebisungunu na ngasi bindi bishwêkwa byoshi. ");
INSERT INTO shr_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Amalambo g’ebyo bishagala bene Levi bayûbakamwo bakazirhangirira oku lukûta lw’olugo, omuhanda, makoro cihumbi, omu marhambi mwoshi. ");
INSERT INTO shr_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Mwanagera embuga ya ngasi lugo, makoro bihumbi bibirhi olunda lw’ebuzûka-zûba, makoro bihumbi bibirhi olunda lw’emukondwè, makoro bihumbi bibirhi olunda lw’ebuzika-zûba na makoro bihumbi bibirhi olunda lw’emwênè. Olugo lwanaja ekâgarhî. Go malambo g’ebyo bishagala ");
INSERT INTO shr_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Ebishagala mwahà bene Levi biri birya ndarhu mwaleka bakaziyâkiramwo, mwanakazileka ngasi wayîsire omuntu akaziyakiramwo; kandi mwanabayushulira bindi bishagala makumi anni na bibirhi. ");
INSERT INTO shr_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ebishagala mwahà bene Levi byoshi haguma byâbà makumi anni na munâni, kuguma n’amalambo g’okuyabulira. ");
INSERT INTO shr_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Ebyo bishagala mwaja mwarhôla bihimbi by’ecihugo muhire bene Israheli, mukajira ntya: abagwêrhe oluhande lunene bo mwanakazirhôlakwo ebinene, n’abagwêrhe ebisungunu, mwanarhôla na bisungunu. Ngasi baguma bakaziha bene Levi ebishagala bayûbakamwo, omu kulola luhande lunganaci bahâbirwe. ");
INSERT INTO shr_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Nyamubâho ashambâla na Mûsa, amubwîra, erhi: «Ogendidesa bene Israheli obabwîre ntya: ");
INSERT INTO shr_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Amango mwâbà mwamayikira e Yordani, munakola mudekerire, omu cihugo ca Kanâni”, ");
INSERT INTO shr_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","“mwanacîshoga ebishagala byâbà kuli mwe, bishagala by’okuyâkiramwo, mulya ankahashiyakira omuntu wayîsire owâbo buzira luhinzo”. ");
INSERT INTO shr_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","“Ebyo bishagala byo mwakaziyâkiramwo omwihôzi w’omukò, ly’omwîsi alekiyîrhwa arhanacigendisamba embere z’olubaga”. ");
INSERT INTO shr_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","“Ebishagala mwahâna byâbà ndarhu by’okukaziyâkiramwo”. ");
INSERT INTO shr_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","“Muhâne ngo isharhu ishiriza lya Yordani na zindi isharhu omu cihugo ca Kanâni, zibè ngo za kuyâkirwamwo”. ");
INSERT INTO shr_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","“Ezo ngo ndarhu zaba hantu ha kuyâkirwamwo kuli bene Israheli, oku muntu w’ecigolo n’oku ngasi wundi oyûbasire ekarhî kinyu, lyo ngasi muntu wanayisire owundi muntu buzira luhinzo ahashibona aha ayâkira”. ");
INSERT INTO shr_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Erhi akabà ashûsire owundi muntu n’ecirugu c’ecûma, n’olya nyakushûrhwa erhi ankafà, owashûrhaga ali mwîsi, na ngasi mwîsi agwâsirwe ahâbwe obuhane bw’okufà”. ");
INSERT INTO shr_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","“Erhi ankabanda ibuye, lirya lyankahashiyîrha, na olya wabandagwa afè, nyakubanda ali mwîsi: n’omwîsi kukwânîne ahâbwe obuhane bw’okufà”. ");
INSERT INTO shr_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","“Erhi ankashûrha n’akarhi kankahashiyîrha, n’erhi olya washûrhagwa ankafà, nyakushûrha ali mwîsi; n’omwîsi kukwânîne ahâbwe obuhane bw’okufà”. ");
INSERT INTO shr_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","“Omwihôzi w’omukò yêne wankayîrha oyo mwîsi; erhi ankajira ah’amushimâna, anamuyîrha”». Obuhane oku muntu obulazire omukò ");
INSERT INTO shr_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Erhi omuntu ankahirimya owâbo n’omujina erhi amubande kantu kalebe kalya kankamuhirimya, na ntyo olya muntu afè, ");
INSERT INTO shr_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","nîsi erhi akamushûrha n’okuboko kwâge ebwa kumushomba, n’erhi olya muntu ankafà, olya washûrhaga kukwânîne ahâbwe obuhane bw’okufà, bulya ali mwîsi: omwihôzi w’omukò anayîrha olya mwîsi erhi ankajira aha amushimâna. ");
INSERT INTO shr_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ci, erhi ankahirimya owundi muntu buzira luhinzo, erhi amubande akantu buzira bulonza bubî, ");
INSERT INTO shr_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","nîsi erhi ankarhogezakwo owâbo ibuye lyankayîrha, na olya muntu afè, buzira kuderha mpu anali mushombanyi wamulongezagya olufù, ");
INSERT INTO shr_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","olubaga lwanatwa olubanja ekarhî ka nyakuyîrha na olya mwihôzi w’omukò, nk’oku amarhegeko gadesire, ");
INSERT INTO shr_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","lwanafumya olya mwîsi kuli olya mwihôzi w’omukò, lwanamushubiza muli lulya lugo ashuba ayâkire; anabêra eyo kuhika aha kufà kw’omudâhwa mukulu, olya washîgagwa amavurha mimâna. ");
INSERT INTO shr_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Erhi oyo mwîsi akarhenga, embere z’amango, muli lulya lugo ali ayâkire, ");
INSERT INTO shr_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","n’erhi olya mwihôzi w’omukò akamushimâna omu lundi lugo, kuleka lulya lw’okuyâkirwamwo, erhi olya mwihôzi w’omukò akayîrha olya wayîrhaga owâbo, arhajiziri câha ca kuyîrha omuntu, ");
INSERT INTO shr_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","bulya omwîsi kukwânîne abêre omu lugo lw’okuyâkirwamwo, kuhik’aha kufà kw’omudâhwa mukulu. N’enyuma ly’okufà kw’omudâhwa mukulu, anahasha okushubira erya munda akashambala kâge kali. ");
INSERT INTO shr_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Aga marhegeko gamanyîsa obuhashe bwinyu n’obuhashe bw’amâburhwa ginyu, ngasi hantu mwankanayûbaka hoshi. ");
INSERT INTO shr_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Aha ngasi kuyîrha omuntu, kukwânîne habè abahamirizi, lyône oyo mwîsi ankafà; ci kwône omuhamîrizi muguma arhankarhuma baderha mpu oku buhamîrizi bwâge bakolaga batwîra omuntu okufà. ");
INSERT INTO shr_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Murhahîra mukayêmêra empongano y’omuntu wayîrhaga owâbo, mpu lyo acira, n’obo akwânîne okufà, bulya agwâsirwe afè. ");
INSERT INTO shr_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Murhahîra mukayêmêra empongano yarhuma olya muntu wayakiraga omu cihugo ca okuyâkirwamwo, ahashigaluka embere z’okufà kw’omudâhwa mukulu. ");
INSERT INTO shr_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Murhahîra mukahemula ecihugo mulimwo, bulya omukò gwo guhemula ecihugo, na ntà mpyûlo oku cihugo, oku mukò gwabulagagwa, okurhali kubulaga omukò gw’olya wagubulagaga. ");
INSERT INTO shr_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Orhahîra okahemula ecihugo muyûbasiremwo, n’ecihugo niono na mbà nyûbasire ekarhî, bulya nie Nyamubâho mbêra ekarhî ka bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Abarhambo b’e milala ya bene Galadi, mwene Makiri, mwene Menashè, w’omu bûko bwa Yozefu, bayisha bajà embere za Mûsa n’embere z’abandi barhambo b’emilala ya bene Israheli. ");
INSERT INTO shr_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Banaciderha, mpu: «Nyamubâho arhegesire Nnawîrhu ahè bene Israheli ecihugo, omu kubayeshera ecigole; kandi nnawîrhu ahâbirwe na Nyamubâho irhegeko ly’okuhà bâli ba mwene wîrhu Selofehadi ecâbo cigabi c’akashambala. ");
INSERT INTO shr_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Erhi bakajaga bayankwa n’omulume w’omu bundi bûko bwa bene Israheli, akashambala kâbo kanaba kashambala ka cihimbi citwisire oku kashambala ka balarha, cigendiyûshûla akashambala k’abà erya munda bajiheruka, ntyo kubè kutwa oku kîrhu kashambala. ");
INSERT INTO shr_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","N’amango gayisha, galya mango g’okucîshinga kwa bene Israheli, ako kashambala kâbo kanagendiyushuka oku kashambala k’ab’erya munda baherusire; ntyo akashambala kâbo cibè cihimbi citwisire oku kashambala ka balarha.» ");
INSERT INTO shr_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mûsa, oku irhegeko lya Nyamubâho, aha bene Israheli irhegeko, aderha, erhi: Omulala gwa bene Yozefu gudesire okushingânîne. ");
INSERT INTO shr_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Lolagi eci Nyamubâho arhegesire oku biyêrekîre bâli ba Selofehadi: banayankwa n’omulume basimire, casinga abè w’omu bûko bwa b’îshe. ");
INSERT INTO shr_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ntyo akashambala ka bene Israheli karhacikazirhenge oku mulala mulebe kajè oku gundi mulala; okwo kwarhuma bene Israheli bakaziyôrhana ngasi baguma akashambala k’omulala gwa b’îshe wâbo. ");
INSERT INTO shr_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Ngasi mwânanyere yêshi wankabà n’akashambala omu bûko bulebe bwa bene Israheli, kukwânîne ayankwe n’omulume w’omu mulala gw’îshe. Ntyo bene Israheli banakazilanga ngasi baguma akashambala ka b’îshe wâbo. ");
INSERT INTO shr_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ntà kashambala karhenga oku mulala kajè oku gundi mulala, ci emilala ya bene Israheli yayôrhana ngasi baguma akashambala kâbo. ");
INSERT INTO shr_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Okwo Nyamubâho arhegekaga Mûsa, kwo na bâli ba Selofehadi bajizire. ");
INSERT INTO shr_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahla, Tirsa, Hogla, Milka na Noa, bâli ba Selofehadi, bayankwa na bene ba mwishè. ");
INSERT INTO shr_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Bayankwa omu milala ya bene Menashè, mwene Yozefu, na ntyo akashambala kayôrha omu mulala gwa bene îshe wâbo. ");
INSERT INTO shr_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Ezo zo ngeso n’amarhegeko Nyamubâho ahâga Mûsa kuli bene Israheli omu rhubanda rhwa Mowabu, hôfi na Yordani, aha ishiriza lya Yeriko.");
INSERT INTO shr_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Alaga ebinwa Mûsa abwîraga Bene Israheli boshi, amango bâli ishiriza lya Yordani. Omu irungu, omu Araba, kulola Sufu ntya, aha karhî ka Parani na Tofeli, Labani, Haseroti na Di-Zahabu. ");
INSERT INTO shr_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Hali lugendo lwa nsiku ikumi na luguma, kurhenga e Horebu, kugera oku ntondo ya Seyiri kuhika e Kadesi-Barnea. ");
INSERT INTO shr_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Omu mwâka gwa makumi anni, omu lusiku lurhanzi lw’omwêzi gwa kali ikumi na muguma, Mûsa arhondêra ashambâlira Bene Israheli ngasi ebi Nyamuzinda anali amurhegesire mpu ababwîre, ");
INSERT INTO shr_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","n’ago mango erhi anaciyûsihima Sihoni, mwâmi w’Abamoriti, àyûbakaga aha Hesiboni, na Og mwâmi w’e Bashani, àyûbakaga e Ashtaroti n’e Edereyi, ");
INSERT INTO shr_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ishiriza lya Yordani, omu cihugo ca Mowabu: Mûsa arhondêra amanyîsa olu lushika. Aderha, erhi: ");
INSERT INTO shr_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Nyamubâho, Nyamuzinda wîrhu àrhushambâlîze muli Horebu, arhubwîra erhi: «Akasanzi mwamashinga mw’eno ntondo karhali kanyi. ");
INSERT INTO shr_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Rhengi aha, mugende mujè ebwa ntondo y’Abamoriti n’emwa abalungu bâbo: omu Araba, oku Ntondo, omu Shefela, omu Nêgebu, n’oku burhambi bw’enyanja, omu cihugo ca Abakanani na kurhenga e Libano kuhika oku lwîshi lunênênè, lwo lwîshi lwa Efrata. ");
INSERT INTO shr_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Loli ecihugo mpizire omu nfune zinyu; kanyagi muyanke ecihugo Nyamubâho alaganyagya basho, Abrahamu, Izaki, na Yakôbo, oku abahaco cibè câbo bona obûko bwâbo enyuma zâbo.» ");
INSERT INTO shr_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Namubwîra ntyâla obwo: «Nti niene ntakamugala mweshi. ");
INSERT INTO shr_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Nyamubâho, Nyamuzinda winyu amuluzize, mulolage oku mukola banji nka nyenyêzi z’e malunga. ");
INSERT INTO shr_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Nyamubâho, Nyamuzinda wa basho, àmuluza muyushûke mubè bangana aha kali cihumbi, anamugishe nka kulya amubwîraga. ");
INSERT INTO shr_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kurhi nakabarhula niene obuzirho bwinyu n’omuzigo gwinyu n’emmanja zinyu? ");
INSERT INTO shr_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Mucîshoge omu ngasi ishanja linyu abashamuka barhimanya, balya ba makengu banamanyîkîne, abôla bo najira barhambo binyu». ");
INSERT INTO shr_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Mwanshuza obwo mwaderha, mpu: «Nêci kwinjà okwo odesire, rhwakujira.» ");
INSERT INTO shr_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Oku bundi narhôla abo barhambo n’emilala yinyu, bashamuka barhimanya banamanyîkîne nabayimanza nti bamukulire: abarhambula ebihumbi, abandi amagana, n’abà arnakumi arhanu, n’ab’ikumi-ikumi, nayimanza n’ababà bandisi b’amashanja ginyu. ");
INSERT INTO shr_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Mw’ago mango gonênè, narhegeka abatwî b’emmanja zinyu, nti: Mukaziyumva bene winyu, munatwe bw