﻿USE sofia;
DROP TABLE IF EXISTS sofia.shpNTpo_vpl;
CREATE TABLE shpNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES shpNTpo_vpl WRITE;
INSERT INTO shpNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Jatíbi peokoonontianra, Diossen nai itan mai jonia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Maira, ja anontian jaskara iti jisámabobi iká iki; jatíbi aniparo nemín kikinbires yamekan mapoara iká iki, jatianra Diossen shinan jene besenen koshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Jatianra Diossen yoia iki: “¡Joé iwé, akin. Jatianra joé iká iki!” ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Diossen oinna joé jakon iketianra, yamé betan imayamakin janbiribi aká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","jatianra joé janea iki “nete”, akin, ja kikin jishtimara janea iki, “yamé”, akin. Jaskatax moa reken nete senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Japekáora Diossen yoia iki: “Jene janbiribi inon xabá ibanon, jaskáketianra janbiribi ibékonti iki”. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Diossen xabáaketianra jene janbiribi iká iki, wetsa tsama xabá, namanbi baneta iki, itan wetsa tsamára bochiki baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ja xabára Diossen janea iki, “nai”, akin. Jaskataxa moa jawen rabé nete iti senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Jatianra Diossen yoia iki: “Ja nai naman iká jenebo ja itinkobiribi jainbicho tsinkíkanwe, ibanon mai pikotax manxani”, akin. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ja manxanara Diossen janea iki “mai”, akin, itan ja jene tsinkitara janea iki “aniparo”, akin. Jatianra Diossen oinna jatíbi jakon iketian, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","neskata iki: “Ibanon nato main meskó keská jiwiabi xobibo xoxoi: Xobibo ibanon jawen xoxoti beroyabo, jainoaxibi jiwibo jawen xoxoti bimi beroyabo”, iki. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ja mainra xoxoa iki, jiwiabi xobibo: Xobibo jawen beroyabo itan bimiai jiwibo, jaskarabiribi itiakin akábora iká iki. Jatianra Diossen oinna jatíbi jakon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Jaskataxa moa jawen kimisha nete iti senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Jatianra Diossen yoia iki: “Jabánon nai xabakan joébo, jan tenaketian netea onanti, yameta onanti, jan netebo onanti, baritiataibo onanti, itan jenetiaiboribi onanti, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","jaskáakin abánon ja joébaon nai xabakanxon mai tenakin”, iki. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Diossenra rabé joé aká iki: Bari aká iki jan neten tenati itan oxe aká iki, jan yamé tenati. Wishtínboribi aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Diossenra ja nai xabakan mai tenati joébo aká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Neten itan yamé mai tenati, jaskáaxonra nete janbiribi iti imaxon, yamé janbiribi iti imaa iki. Jatianra jaskarabo axon oinna jatíbi jakon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Jaskataxa moa jawen chosko nete iti senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Jainxonra Diossen yoia iki: “Jene meran jatíbi meskó yoinabo ichabires kaibanon, jainoaxibi jabánon mai manaon noyai yoinabo”, akin. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bakeai kaixon, aniparo bochoakanwe, jainoax nato neten jabánon ichabires noyai yoinabo. Diossenra jonia iki, aniparomea anibires yoinabo jainoax jene meranoax kaitai jatíbi yoinabo, itan jain jaabo, jainxonra jatíbi noyai yoinabo aká iki. Jaskáakin axon Diossen oinna jakon iketianra, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ja aká yoinabo jakon ikantiakin shinanxonkin neskáakin yoia iki: “Ichabires bake kaiabakanon jaskáaxon aniparo bochoabakanon itan nato neten jabanon icha noyai yoinabo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Jaskataxa moa jawen pichika nete iti senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Jatianra Diossen yoia iki: “Nato main kaibanon jatíbi meskó yoinabo: Ináatibo itan ináatimaboribi, jainoax jatíbi main norex iki niaibo”. Jatianra jaskara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ja yoinabo axon Diossen oinnara jatíbi jakon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Jatianra yoia iki: “Ramapari joni anon akanwe. Noa keskábiakin, jara jatíbinin koshi iti iki: Aniparomea yapabaona, noyai yoinabaona, ináati yoinabaona, ináatima yoinabaona, itan main norex iki niaibaonaribi”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Diossen joniakinra, ja Dios keskábiakin aká iki; benbo itan ainbora aká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","jatianra jakon ikantiakin shinanxonkin jato yoia iki: “Icha, ichabires bakeai nato neten kaikanwe; jaton koshi ixon jato ikinkanwe; yapabo, noyai yoinabo, jainoax jatíbi ja main norex iki niaibo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Japekáora jato yoia iki: “Ninkákanwe, matora en meniai jatíbi nato mainmea niibo, bimiai yoábo, itan jatíbi yobín jiwibo. Jatíbi jabora maton jawékiatibo iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ikaxbira ináatima yoinabo, main norex iki niai yoinabo itan noyai yoinabo jabobiribira en xobi meniai, ja jawékiakanon ixon”, akin. Jatianra jaskara iká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Jatianra Diossen oinna jatíbi akábo jakonshamanbires iká iki. Jaskataxa jawen sokota nete senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nai itan maira, jatíbi jain ikáboyabi moa akin senenhaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ja kanchis nete kaman, jatíbi ja akábo akín senenhaxa Dios tantia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Jatian ja kanchis iti netera jakon iki ixon yoia iki, ja netera meketi iti iki ixonra, onantiakin yoia iki, ja netera jatíbi jawéki joniai teetax tantia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Natora nai itan mai jaskatax jonia yoia joi iki. Ibo Diossen nai, itan mai anontianra ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","jiwi keyámashokobobi itan xobibobi xoxoamapari iká iki, ja Ibo Diossenra nato maiki oi bemaamapari iká iki, ja main teetira tsoabi yama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Jaskara ikenbira, mai chichokeax jene jokonxon, jatíbi mai mechaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Jatianra Ibo Diossen ja mai potobi bixon joni itiakin aká iki, jaskáaxonra jawen rekinhain xoon aka iki, jatianra moa jiria baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ja aká pekáora, Ibo Diossen jain jakon jati bari pikotaiori, westíora wai Edén mainko aká iki, jatianra jan aká joni jain imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Jatíbi meskó jiwi metsáshamanbo jawen bimi jakon kokotibora xoxomaa iki. Ja wai naponbekonra jiwé jiwi aká iki, jan jakon ati onanti itan jakonma onanti jiwiribira aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ja Edénhainoaxa westíora paroribi pikota iki, janra ja jakonhira jatinko mai mechai iká iki. Jaki mepiara iká iki chosko paro, ja iká iki jawen paxkobo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ja rekena paron janera iká iki Pisón, janra Havila mai shitabaina iká iki. Jainra oro jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ja mainmea orora jakonhira iki, jainra jake bedelio janeya jiwi bepon inin, jainoaxa jake ónice janeya makan. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ja wetsa paron janera iká iki, Guihón. Ja parora, Cus janeya mai shitabaina iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ja kimisha itin iká parora Tigris iká iki. Ja parora Asiria mai shitabaina bari pikotaio iká iki. Jainoax ja chosko itin iká paron janera Éufrates iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jatianra ja Edén main iká jakon jati wainko, koirani teenon ixon Ibo Diossen ja joni imaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","jain imakinra yoia iki: “Nato jakon jati wainkonia jatíbi yobín jiwi bimibora min kokoresti iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ikaxbira ja jakon itan jakonma onanti jiwi bimi, min kokotima iki. Ja jiwi bimi kokoatianbira mia mawáti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Jainxonra Ibo Diossen yoia iki: “Joni jabicho iitira jakonma iki. Jaskara iketianra en wetsa axonai, janshamanbiribi akinti”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Jatianra Ibo Diossen mai bixon jatíbi yoinabo aká iki, jainxonra jatíbi noyai yoinaboribi aká iki. Jaskáxonra Adánhiba jato boá iki, ja janeyabo ikantiakin jato janepakenon ixon. Jaskáxonra yoinabo Adánman janepakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Jatianra Adánman jatíbi ináati itan ináatima yoinabo, itan noyai yoinabo janepakea iki. Jaskara janeyabo itiakinbiribi jane pakea iki. Ikaxbira jawe yoinabi janshamanbiribi já akinti yama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Jaskara iketian, Ibo Diossen Adán akonbireskin oxamaa iki, ja oxaketian westíora jawen pishi tsekaxon, jakiribi namín xepoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ja pishi tsekaxonra, Ibo Diossen ainbo aká iki, jaskáaxonra ja aká ainbo Adán menia iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ja oinnaxa Adán neskata iki: “¡Natora nokon namibi iki, itan nokon xaobi iki! Jonimea tsekaxon Diossen aká ikaxa, jawen jane ‘ainbo’, iki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Jaskara iketianra jonin jawen papa betan jawen tita jenetaanan, jawen awin betanbiribi jati iki, jaskataxa ja rabé westíora yorabicho keská iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ja Adán betan jawen awinra, chopaoma iká iki, jaskara ikaxbira jawebi rabinyamabekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ronora jatíbi ináatima yoinabo xewina paramisti onan Ibo Diossen jonia iká iki, jatianra ainbo yokata iki: —¿Jaskara ikenki, Diossen mato yoia iki, nato jakon jati wainkonia, jawerato yobín jiwi bimibi kokotima? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Jatianra ainbaon yoia iki: —Wetsa jiwi bimi inonbiresa nato jakon jati wainkonia non kokoti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ikaxbira, jakon jati wai napo iká westíora jiwi bimibichores, noa Diossen kokotima yoia iki, jainxon tii atimaribi yoia iki. Ja kokoaxbira noa mawáti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Jaskáabira ronon ainbo yoia iki: —Ja mato jaskáakin yoiara ikonma iki. Matora mawáyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Diossenra akonbireskin onanke, ja jiwi bimi kokoxon maton jakon, itan jakonma onanti, jaskara onanaxa mato Dios keskaribi iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ja ainbaon jiwi bimi oinnara iká iki, iorai metsá jan keentishaman, jatianra ja bimi kokotinin keenshamana iki, jaskáaxon jawéki ati onan shinan biti iketian. Jaskara iketian westíora bimi tesaxon kokoa iki. Jan aká pekáo jawen bene menia iki, janribi kokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ja akátianbi jaton shinan chopeta iki, jatian ja rabéxonbi onanna iki moa chopaoma. Jaskara ixon, higuera janeya jiwi pei kexexon ja sawebekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ja joninra jawen awin betanbi ninkata iki, moa yantani niweshaman iitaitian, ja jakon jati wainko Ibo Dios joáx kawanaitian, jan oinnaketianra ishto kaax jiwibo nia naman jonébekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Jaskákenbira Ibo Diossen, Adán kenaxon yokata iki: —¿Miaki jawerano iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Joninra yoia iki: —Nato jakon jati wainko joax, mia kawanaitian ninkataxa chopaoma ikax; miki raketi ea joneke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Jatianra Diossen yokata iki: —¿Tson yoiaki min onanna, mia chopaoma? ¿Ja jiwi bimi kokotima en yoia ikenbiki, min kokoa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Joninra yoia iki: —Jabé janon ixon min ea menia ainbaon bimi meniara en kokoke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Jatianra Ibo Diossen ja ainbo yokata iki: —¿Jaweati min jaskáamarin? —akin. Jatianra jan yoia iki: —Ronon ea parana kopí, ja bimi en kokoa riki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Jatianra Ibo Diossen ja rono yoia iki: —Jaskara min aká kopíra, jatíbi yoinabo xaran bebonbires jakonma mia ikai. Rama nenoax peokotaxa jatíbitian mia main norex iki, mai poto meranbires ninoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mia itan ainbora en mato rawikananmai, min chiní bakebo betanra jawen chiní bakeboribi rawikanankanti jake. Ainbaon chiní bakenra mabitaxti iki, jatianra minbiribi jawen tae chiponhai natéxti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ja ainbora yoia iki: —En imaara bakeai ikonbiresi mia chexakaati iki, jatianra bakenaitiibi mia chexati iki. Ikaxbira min benen keeni mia jenétima iki, jatianra já min joni koshi iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ja jonira yoia iki: —Min awinin yoia keská axonkinra, en atima yoia jiwi bimi min kokoa iki, ramara min jakonma kopí, nato mai jakonma meranbires en imai; ikonbiresi teexonra ja jawékiati min kaimati jake, mia mawatai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mainra moxayabi jakonma xobibaon mia xoxoxonti iki, jatianra nii meranoa yoabo min jawékiati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ikonbiresi teeti niskánxonparira min jawékiati iki, mawatax jakiribi ja aká maibi mia banetai kaman, miara mai aká iki, jakopíra jakiribi mia mai banéti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ja jonin jawen awin janea iká iki, Eva, jara jatíbi joni jiriabaon tita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ibo Diossenra yoina bichibo sawetiaxon, ja joni itan jawen awin sawemaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","jatianra yoia iki: “Ramara joni noa keskáribi banéke, jakon itan jakomara onanke. Jawekeska ixonra, jiwé jiwi bimiribi bixon kokoax jatíbitian janake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Jaskara iketianra, Ibo Diossen Edén mainko iká, jakon jati wainkonia ja joni pikoa iki. Jaskáaxonra, ja main teenon ixon ja joni imaa iki, ja maibi aká ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ja joni pikoa pekáora, bari pikotaiori iká jakon jati wainko, querubín janeya peiabo imaa iki, itan chiibires espada jatíbiori mayatairibira imaa iki, ja jiwé jiwinko tsoabi nokótima kopíra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adánman jawen awin Eva yorana tootax ja bake pikota iki, jawen jane iká iki Caín. Jaskáketian, Adán neskata iki: “Moara ea westíora benbo bakeya iki, Ibon ea menia riki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Japekáo Abel pikota iki, ja Caínman wetsa. Ja Abel iká iki, carnero kaiai; jatian Caínbiribi iká iki, waín teetai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Jaskata pekáo basi iikin, wetsa nete Caínman aká iki, jawen waimea bia yoábo boxon Ibo menikin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abelninbiribi Ibo boxona iki, carnero bake reken pikota jakonshamanbo. Jatianra Ibon oinna ja Abel itan ja Ibo meninoxon boá jawekibo, jawen keenshaman iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ixonbi Caín jaskáakin oinyamaa iki, ja meninoxon boá oinna jakonmaribi iká iki. Jaskáketian Caín, ikonbiresi sinatax jawen beísa jakónmabires iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Jatianra Ibon yoia iki: “¿Jawekopí, iorai sinataxki, min beísa ikonbires jakonma iki? ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Jakon akáxa mia rarokeanke, ikaxbi min ayamai kopíra ochan miaaresai. Ikaxbira ja ocha minharesti atipanke”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wetsa netera, Caínman jawen wetsa Abel, chankakin ioa iki, jatian kachio jato rabébicho ixonra, Caínman jawen wetsa Abel retea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Jatianra Caín Ibon yokata iki: —¿Min wetsa Abelki jawerano iki? —akin. Jatianra Caínman yoia iki: —Enra onanyamake. ¿Eaki já koirannai iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jatianra Ibon yoia iki: —¿Minki jawea? Ja min wetsan jimi main min chikoara, ja min aká atikeskabiakin en benxoanon ixon ea yokati, saí ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Jakopíra, mia jakónmabires banetai, min wetsa min reteketian jawen jimi xea mainkoniaxa mia wetsanko kaai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ikonbiresi teexon, waiaxon min banaabira jakonmai xoxoax bimitima iki. Nato netenra mia kawanhatanti iki, jawetianbira mia tantitima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Jatianra Caínman Ibo yoia iki: —Ja akonbireskin masá tenetira en atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ramara nato mainmea min ea pikoke, jatianra nato neten mia ochóbires, jawetianbi tantiamai ea kawantaresti jake. Jaskataitianra wetsabaonbires inonbi, nokoxon ea retekanti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ikaxbira Ibonbiribi yoia iki: —Jaskara iken jan mia reteatonra, bebonbires kanchisakin masá teneti iki. Jatianra Ibon, ja nokoabaon Caín reteyamakanon ixon, ja oinxon onanti jawen yoranko axona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Caínra jainoax Ibo betan yoyo ikainoax moa kaa iki, jatianra kaax Nod janeya mainko jaa iki; jara Edénhainoax bari pikotaiori iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caínmanra jawen awin yorana iki, jatianra tóota iki, jaskatax bakenara Enoc iká iki. Jaskáa pekáo jemaaxon Caínman, jawen baken janenbi janeara Enoc iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ja Enoc-ra, Iradnin papa iká iki, Irad iká iki, Mehujaelnin papa, Mehujael iká iki, Metusaelnin papa, jainoax Metusael iká iki, Lámecnin papa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ja Lámec-ra rabé awinya iká iki: Adá betan Silá. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adakan bakeara Jabal iká iki, ja Jabalnin chiní bakebora carpa xobon jaabo iká iki, jainoaxa yoina kaiaibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalnin wetsara iká, jawen jane Jubal, jaibakeaxa arpa ten akaibo itan quena xoon akaibo peokoota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silákan bakera Tubal-caín iká iki, yamin teetai jonira iká iki, bronce itan hierro meskó jawékibo akaira iká iki. Ja Tubal-caínman poira jawen jane Naamá iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wetsa netenra Lámecnin, jawen awinbo yoia iki, Adá itan Silá: “Ninkáshamankanwe, en mato yoinon, ea isinhakin xateketianra en westíora joni bake ranon reteke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Jawerato joninki Caín reteai, jaon kopikakinra kanchis akin masá tenemakanti iki, ikaxbi ea ramiabobiribira, kanchis chonka kanchis akin, masá tenemakanti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adanmanra jawen awin betan yoranribia iki, jatianra benbo bakeaxon janea Set iká iki, jatianra neskata iki: “Abel, Caínman retea toanra Diossen ea wetsa benbo bake menike”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set-ribira westíora bakeya iká iki, jara Enós akin janea iki. Jainxon peoxonra Ibon jane rabikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Natobo riki, ja Adanman chiní bakebaon jane wishaa: Diossen joni anontianra, ja keskabiakin aká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","benbo betan ainbora jato jonia iki, jaskaaxonra jato jakon shinanxona iki. Jato jonia netenra, Diossen yoia iki: “Maton janera jonibo iti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Jawen benbo bake pikónontianra Adán pacha kimisha chonka baritiaya iká iki, ja bakera jatíbinin jawen papa jisábi iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Jaskata pekáo Adán japaria iki, posaka pacha baritiapari, jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Jaskataxa jatíbi jawen baritia Adán jaa iká iki, iskon pacha kimisha chonka baritia; jatí baritiayanixa, mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set, pacha pichika baritiaya iketianra, jawen benbo bake Enós pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Jaskata pekáo, Set japaria iki posaka pacha kanchis baritiapari. Jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaríbaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","jaskataxa jatíbi jawen baritia Set jaa iká iki, iskon pacha chonka rabé baritia. Jatí baritiayanixa mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós, iskon chonka baritiaya iketianra jawen benbo bake Cainán pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Jaskata pekáo Enós japaria iki, posaka pacha chonka pichika baritiapari, jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaribaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","jaskatax jatíbi jawen baritia Enós jaa iká iki, iskon pacha pichika baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainán, kanchis chonka baritiaya iketianra jawen benbo bake Mahalalel pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Jaskata pekáo Cainán japaria iki, posaka pacha chosko chonka baritiapari, jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Jaskatax jatíbi jawen baritia Cainán jaa iká iki, iskon pacha chonka baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel, sokota chonka pichika baritiaya iketianra, jawen benbo bake Jared pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jaskata pekáo Mahalalel japaria iki, posaka pacha kimisha chonka baritiapari, jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Jaskatax jatíbi jawen baritia Mahalalel jaa iká iki, posaka pacha iskon chonka pichika baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared, pacha sokota chonka rabé baritiaya iketianra, jawen benbo bake Enoc pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jaskata pekáo Jared japaria iki, posaka pacha baritiapari, jainoax wetsa jawen benbo bakebo, itan ainbo bakebo jaribaa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","jaskatax jatíbi jawen baritia Jared jaa iká iki, iskon pacha sokota chonka rabé baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc, sokota chonka pichika baritiaya iketianra, jawen benbo bake Matusalén pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoc-ra jaa iki, Diossen shinanna keskáres axoni. Ja Matusalén pikota pekáo Enoc japaria iki, kimisha pacha baritiapari, jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaríbaa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","jaskatax jatíbi jawen baritia, kimisha pacha sokota chonka pichika baritia Enoc jaa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ja Diossen shinanna keskáres axoni jaa ikaxa, wetsa neten manóresa iki, jaskaraa iki moa Diossenbi boá. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén, pacha posaka chonka kanchis baritiaya iketianra, jawen benbo bake Lámec pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Jaskata pekáo Matusalén japaria iki, kanchis pacha posaka chonka rabé baritiapari. Jainoax wetsa jawen bakebo jaríbaa iki, benbo bakebo betan ainbo bakebo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jaskatax jatíbi jawen baritia Matusalén jaa iká iki, iskon pacha sokota chonka iskon baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lámec, pacha posaka chonka rabé baritiaya iketianra, westíora jawen benbo bake pikota iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Jara Noé akin janea iki, jaskaax iká iki neskati: “Ibon nato mai jakonmakin shinanxona iketianra, waiai noa ikonbiresi teetai, jaskara ikenbira nato baken noa tantimati iki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Moa Noé pikota pekáora, Lámec jaa iki pichika pacha iskon chonka pichika baritiapari; jainoax wetsa jawen benbo bakebo itan ainbo bakebo jaribaa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Jaskatax jatíbi jawen baritia Lámec jaa iká iki, kanchis pacha kanchis chonka kanchis baritia. Jatí baritiayanix mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pichika pacha baritiaya inontianra Noekan, bakea iki Sem, Cam, Jafet. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nato main jonibo kaiti peokoonontianra jemaabotankin bakeakana iká iki, ainbo bakebo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Diossen bakebaon, ja ainbobo oinnara iká iki metsáshamanbo. Jatianra jainoa katotax jaton keenshamanbo oinnax jabo betan wanokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ikaxbira Ibon yoia iki: “Nato jonibora, yorayabo ikax jatíbitian jatimabo iki. Jakopíra, pacha rabé chonka baritia senenres en jato jamati iki, ikíra Dios iká iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Diossen bakebaon, ja jonibaon bake ainbobo bixon jato betan bakeakanara, anishaman jonibo nato main pikoti peokookana iki, japekáora kaibotanreskana iki. Jabora ikana iki moatianbi koshi reteananaibo, jaton akábo oinxon onankana ikax ninkakataibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ibon oinnara jonibaon aká nato main bebonbires jakonma iká iki, jaton shinanra jatíbitian jakonma atires iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","jaweati en joni akárin ikira iká iki. Kikinni chexakaatira ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","neskata iki: “En aká jonibora, nato mainmea tsoabi yamatiakin en jato keyoai, jatíbi yoinaboribi, main norex iki niaibo jainoax noyai yoinabo. ¡Ayamapainon en jato akárin ikíra ea ikai!” iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Jaskara ikenbira, Ibon oinna Noébichores jakon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Natora Noé iní yoii iki. Noéra jakonhira joni iká iki, jatíbitianra Dios yoiti ixona iki. Ja janontianra jabé jonibo xaran, jabichores Dios keenai keskati jaa joni iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noéra kimisha benbo bakeya iká iki, jabaon jane iká iki, Sem, Cam, Jafet. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Diossen oinnara nato main jakonma bochobires iká iki, itan onsati ramianankanai iká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","jaskatira jatíbi jonibo jakonmai axekana iká iki. Diossen oinna nato main ichabires jakonma jaketianra, ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Noé yoia iki: “Enra shinanke jatíbi jonibo keyonoxon. Jaton jakonma kopíra nato neten ikonbiresi onsati reteanankanai, jaskara iketianra en jato keyoai, jatíbi nato neten ikáboyabi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bepon jiwi wapóroawe, jawen chitébo awé, jaskáxon okenbekonbi ja wapóro xabábo boín boyawe, jemaori itan napoori, jene weinaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ja wapóro akin, min topóntira neskara iti iki: Pacha kimisha chonka pichika metro jawen nenké, rabé chonka rabé metro, wetsa metro iti naponbekon jawen naxbá; jainoax chonka kimisha metro, wetsa metro iti naponbekon jawen keyá. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kimisha pekataya axon, bochiki ja wapóro peká nókoti, metro naponbekon ikain westíora ventanan awé; jainxon westíora xepótiribi awé. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Enra jenen ewa raanai, mai mapoxon jatíbiainoa joni itan yoina jiriabo nato netemeabo keyonon ixon. Jatíbi nato main jaabora, mawáti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ikaxbi miibetanra, ja senenhabekonti joi en akai. Ja wapóro meranra min bakebo weikanti iki, min awin, min baban ewabo itan miaribi jikiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Jainxonribira min weimati iki, jatíbi nato netemea yoinabo, bene betan awinbora iti iki; jaboribira miibetan mawákantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Jatíbi meskó yoinabora, rabébo miibetan ja wapóro meran weíkanti iki: noyai yoinabo, ináati yoinabo, main norex iki niaibo, jaboribi keyonaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Meskó jawékiatibo tsinkiwe, jaskáaxon benxoawe. Mato betanbi yoinabaon jawékiati janon ixon”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Jatianra Noekan aká iki, senenhakin jatíbi ja Diossen ati yoiabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Japekáora Ibon Noé yoia iki: “Ramatian iki miabichores, jatíbi jonibo xaran nokon keena keskáres akí jaa joni. Jaskara ikax, maton bakeboyabi wapóro meran weikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Rama jatíbi kerásma yoinabo weimawe, kanchis bene jainxon kanchis awin. Ikaxbi kerás yoinaboribi, bene betan awinbichores weimawe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Jainxonribi weimawe kanchis meskó noyai yoinabo, bene betan awin kataxabo, ja yoinabo nato neten keyoyamai jati kopi, ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","nenoax kanchis nete senenketianra, chosko chonka nete itan chosko chonka yamé en oi bemai. Nato mainmea jatíbi jiriabo itan jatíbi ja en joniabora en keyoai”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Jatianra Noekan jatíbi Ibon ja ati yoia keskáshamanbo aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ja jenen ewan keyokin mai maponontianra, sokota pacha baritiaya Noé iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Jatianra jenen ewan retenaketian Noé, jawen awin, jawen bakebo jainoax jawen baban ewabo wapóro meran weikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kerásma itan kerás yoinabo, noyai itan main norex iki niaibora, ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Noé betan wapóro meran weikana iki, rabé rabébo, bene betan awinbora iká iki, Diossen jato yoia keskára ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ja kanchis nete senenketianra, jenen ewan moa mai mapokin peoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Baritia peokota rabé oxe, chonka kanchis netera iká iki. Jatianra Noé sokota pacha baritiaya iká iki. Ja netenshamanribira aniparo xamameax jene jokonai kinibo toebetana iki, jainoax bochikia naikanmea ani xepótibo kepemebotana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Chosko chonka nete itan chosko chonka yaméra, nato main oi bei jenéyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ja oi bei peokootai netenribira, Noé, jawen bakeboya Sem, Cam, Jafet itan jawen awin jainoax jawen baban ewabo betan wapóro meran jikia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Jatíbi meskó yoinabo, inaatima itan ináatibo, itan jatíbi meskó norex iki niaibo itan noyai yoinabora jato betan weikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Jatíbi yoinabora, rabébo Noé betan wapóro meran weikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ja meskó yoinabora, bene betan awinbo weikana iki; Diossen Noé yoia keskáshaman ikanketianra, Ibon ja wapóro xepoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Chosko chonka nete kamanra jenen ewa bea iki. Ja jenetiataitoninra, wapóro toxbati peokota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ja jene bei keyáinataitoninra, wapóroribi toxbainata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Jaskati ikonbiresi jenetiaxonra, jatíbi nato mainmea ani manan keyábo, keyokin mapoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ja ani manan keyábo mapokin keyoa pekáora, kanchis metro bebon keyá jene iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Jaskatax, jatíbi nato main jaa joniboyabi, noyaibo, ináati itan ináatima yoinabo, main norex iki niaiboribi mawáti keyokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Jatíbi nato mainmea jiriabo, jiria ixon joinnaibo mawati keyota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Noé betan wapóronin ikábobichoresa, jiria banékana iki; ja jain iamaabora mawati keyokana iki: jonibo, inaati yoinabo, noyaibo, jainoax main norex iki niaibora keyota iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","pacha pichika chonka nete kamanra, jenen ewan mai mapoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Jatianra Diossen Noé shinanna iki, jatíbi ja wapóro meran jabé iká yoinaboyabi. Nato mai payannon ixonra niwe bemaa iki, jatianra moa jene tsosini peokota iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","aniparo xaman iká, jan jene jokonai ani kinibora moa xepota iki, jainoax naiorikea jene tewana ani xepótiboribira moa xepota iki. Oi beira moa jeneta iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","jatianra jainmashoko jene tsosinpaketa iki. Moa pacha pichika chonka nete senenketianra, moa tsosinpakebiresa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","jatianra ja baritia kanchis oxeya iketian, jawen chonka kanchis neten, ja Ararathainoa manan maxkaten ja wapóro rakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ja baritia chonka oxeya iketian, jawen reken netenra ja jene tsosinkaresa iki, jatianra ani manan keyábo moa pikota oinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Chosko chonka nete, jenen ewa winota pekáora, Noekan jawen wapóro ventana kepena iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","jatianra wiso nawashian keská cuervo raana iki; raana kaax noyai mayaaketanax joríbaa iki, mai manxanamapari iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Cuervo ranhibata pekáora, mai tsosina onankaskin Noekan xotó raana iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ikaxbira ja xotó wapóroain joríbaa iki, jain yakátira jaweranobi nokoyamaa iki, maira jenen mapoapari iká iki. Jaskatax xotó joáitianra jawen meken pikoxon yatanxon, Noekan wapóro meran jikimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noéra kanchis nete manata iki, jatianra jakiribi xotó raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Moa yametaitianra, olivo jiwi poyan meskeshoko xechankaya xotó joá iki. Jaskáxonra moa mai pikotai Noekan onanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kanchis nete manata pekáora, jakiribi xotó raana moa banéyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé sokota pacha westíora baritiaya iketianra, moa mai pikota manxan iká iki. Ja baritia reken oxe, jawen reken nete inontianra, Noekan jawen wapóro peká ras aká iki, jatianra oinna moa mai manxana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Jawen rabé iti oxe, rabé chonka kanchis neteya iketianra, mai moa kikinni manxana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Jatianra Diossen Noé yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wapóroninmea jato pikokinwe, min awin, min bakebo, min baban ewaboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ja miibetan iká jatíbi yoinaboribi jokonhawe, noyaibo; ináati yoinabo; itan main noréx iki niaibo; nato main jatíbiain boxon icha bakeaxon, nato nete bochoabatankanon”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Jatianra, Noé, jawen awin, jawen bakebo jainoax jawen baban ewaboribi wapóroninmeax jokonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Jatíbi yoinaboribira jokonkana iki, inaati betan inaatima yoinabo, main noréx iki niaibo, itan noyai yoinabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Jaskata pekáora, jainxon Dios rabinoxon Noekan, jan perakanxon yoina menoti makan tsamana iki. Jaskáxon bipakea iki, westíorabo meskó yoina kerásmabo jainxon noyai yoinabo kerásmaboribi bipakea iki. Jaskáxon Dios rabikin, keyokin menoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jatianra yoinabo menoa iorai noe, jaki nokóketian Dios neskata iki: “Ramara en jawetianbi, jonibaon jakonma aká kopí, nato nete jakiribi jakonma inon ixon, en ramiayamai. Jonira bakeranontianbi jakonma ati shinanyares iki. Yoinaboribira, en jakiribi keyoyamai moa jato aká keska akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nato nete japariketianra, yoábo banaxon tsekakantiki, xana betan matsira jatiki; jenetia betan baritiara jati jake, nete betan yaméribira jati iki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Diossenra Noé, itan jawen bakebo jakonhakin shinanxonkin, neskara joibo yoia iki: “Icha bakeakanwe itan nato main kaikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nato netemea jatíbi yoinabora, mato meraax raketi saki ikanti iki. Jatíbi noyai yoinabo, mainmeabo, itan aniparomeabo, jatíbi ja yoinabaon koshira mato iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Jatíbi yoinabora maton piti iki, paxabi piti yoábo, maton keenashamanbora maton piti iki. Jabora en mato meniai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ikaxbira westíora jawékibicho, maton pitima iki: nami jimiabira maton pitima iki, yoinabo jiminres koshiax, jaa kopíra maton atima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mato retea kopíra, joni itan yoina inonbi en masá tenemati iki. Jonibora jawen kaibo reteketian westíorabo, en jato masá tenemati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Jonin jabé joni reteketianra, wetsa jonin jaribi reteti iki, jonibora Diossen ja keskábiakin joniaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ikaxbi maton, ¡Icha bakeakanwe, jabo nato neten kainon!” akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Jainxonra Diossen Noé jawen bakeboyabi yoiribia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ninkakanwe, mato betan itan maton chiní bakebo betanra, jaskara senenhabekonti joi en benxoai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Jainoax wapóroninmeax jokona jatíbi mato betan iká yoinabo betanribira ja joi en benxoai: noyaibo, ináati itan ináatima yoinabo, jatíbi nato netemea yoinabo betanra en akai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Jaskara mato betan senenhakonti joira, jawetianbi en wetsakeskaayamai: jonibo itan yoinabora, moa jakiribi jenen ewa en jato keyomayamai. Nato mainmeabo jan jato keyotira moa jenen ewa iwetsayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mato betan itan jatíbi yoinabo betan jatíbitian jaskara senenhabekonti joira en benxoai, ja oinxon onantira nato iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","enra nokon koshki nai koinbo meran ake, nato netemeabo betan jaskara ati joi en benxoa ja oinxon onantira iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mai mananhon en nai koin tsinkímaketian, jain nokon koshki pikotara maton oinnoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Jatianra en shinanti iki, mato betan itan jatíbi yoinabo betan jaskara senenhabekonti en benxoa joi, jatianra jan mato keyoti jenen ewa bewetsatima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ja nai koinman nokon koshki iketian oinxonra en shinanti iki, jatíbi nato netemea jonibo betan itan jatíbi yoinabo betan jatíbitian jaskara senenhabekonti en benxoa joi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nato ja oinxon onanti en akára, nato mainmea jatíbi jonibo betan itan jatíbi yoinabo betan jaskara senenhabekonti en benxoa joi iki”, akinbo. Jaskatira Dios betan Noé yoyo ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noekan bakebo wapóroainoax mannabora Sem, Cam, Jafet iká iki, Camra Canaánman papa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ja kimishara iká iki, Noekan bakebo, jabaon chiní bakebaon bakeara, nato main jakiribi kaikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Waiakin peoxonra, Noekan uva banaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wetsa netenra Noekan pae xeaa iki, jatianra panhena iki, jaskataxa jawen carpa xobo napo, chopa potayonax rakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ja Camman papan, Canaánman, jawen papa Noé oinnara chopaoma iká iki, pikóxonra jawen wetsa rabe yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Jatianra Sem betan Jafetnin, jan perakooti bixon paobaini kaxon jaton papa rapokana iki. Chopaoma iketian jawen yora oinnaketianra chitikan itan wetsaori oinnax kaxon rakokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Paen jishtenxonra jawen bake chinikan jaskara aká Noekan onanna iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","jatianra yoia iki: “¡Canaánra jakonmabires iti iki! ¡Jawen wetsa rabekan yanka yonoti ioraa namanbiresa iti iki!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Jainxon yoiribia iki: “Semman Ibo Diossa jakon iki, itan Canaán ibanon jawen yanka yonoti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Diossen abánon Jafet ani mai menikin, jawen chiní bakeboyabi; ibanon Sem betan jawen chopa peotanin jaai, jainoax abánon Canaán jawen chiní bakeboyabi jaton yanka yonoti imakin”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ja jenen ewata pekáora, kimisha pacha pichika chonka baritiapari Noé jaa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","jaskatax iskon pacha pichika chonka baritiayanix Noé mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noekan bake Sem, Cam itan Jafetnin, jenen ewa winota pekáo jaton bakebaonbi bakeabora natobo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetnin bakebora iká iki Gomer, Magog, Madai, Javán, Tubal, Mesec, itan Tiras. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ja Gomernin bakebora iká iki Askenaz, Rifat, jainoax Togarma. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javánman bakebora iká iki Elisa, Tarsis, Quitim, jainoax Rodanim. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ja Jafetnin chiní bakebaon bakebora iká iki, aniparo kexakea maibo biax, jemaax ja rarebobires ikax; jatonbiribi mai iboax, jaton joinbiribi yoyo iki jakanabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ja Camman bakebora iká iki Cus, Mizraim, Fut, jainoax Canaán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ja Cussen bakebora iká iki Sebna, Havila, Sabta, Raamá, itan Sabteca. Ja Raamá bakebora iká iki Seba betan Dedán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus iká iki, Nimrodnin papa, jara iká iki nato main; reken koshi shinanya joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ibon shinanman imaara, Nimrod ikonbires yoinanin mecha iká iki. Jaskara yoiira ikanai: “Mia Ibon imabanon, Nimrod iní keská ikonbires, yoinanin mecha iki”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ja apo iketian, jawen mainmea ani jemabora iká iki Babel, Erec, Acad, jainoax Calne. Jatíbi jabora Sinar mainmea jemabo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ja mainmeaxa Asur pikota iki, janra Nínive, Rehobot-Ir, Cala jemabo aká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ja ani jema Resénribira aká iki, ja jemara Nínive betan Cala naxaran iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ja Mizraimhainoaxa, meskó jonibo jaai peokota iki, Ludeobo, Anameobo, Lehabitabo, Naftuhitabo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patruseobo, Casluhítabo jainoax Caftoritabo jabaon bakebora filisteobo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaánman reken bakera Sidón iká iki, jainoax jawen chiní bakera Het iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaánman chiní bakebaon bakea bakebora iká iki, jebuseobo, amorreobo, gergeseobo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveobo, araceobo, sineobo; ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeobo, zemareobo, jainoax hamateobo. Jaskata pekáora, jatíbi cananeo jonibo janbískana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ja cananeo jonibaon maira Sidón jemankoniax Gaza jeman senen iká iki, jara Gerar maiori iká iki, itan Sodoma, Gomorra, Adma, Zeboím jemabo ikáorira iká iki, ja Lasa jema senenra iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Jabora Camman chiní bakebo iká iki, maiabotiibira ikana iki, itan ja rarebobires jaton mainbiribi ikana iki, jainoax jaton joinbiribi yoyo ikaibora ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semra Jafetnin wetsa reken iká iki, jawen bakeboribira jaa iki. Jatíbi Hebernin bakebora Semman chiní bakebo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Elam, Asur, Arfaxad, Lud itan Aram, jabora Semman bakebo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramman bakebora iká iki Uz, Hul, Geter itan Mas. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad iká iki, Selakan papa; itan Selabiribira iká iki Hebernin papa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Jaskatax iikin Hebernin rabé bakeaa iki: ja wetsan jane iká iki, Péleg. Jaskáakinra janea iki, ja pikónontian ja mainmea jonibo, janbískana iketian; jainoax Pélegkan wetsan jane iká iki, Joctán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ja Joctánman bakebo iká iki, Almodad, Selef, Hazar-mavet, Jera, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila jainoax Jobab. Jatíbi jabora Joctánman bakebo iká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mesa mainkoniax peokotax Sefar mai ikain senen iká mainkobo jakanara iká iki, jara bari pikotaiori iká manan maibo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Jabora Semman chiní bakebo iká iki, maibotiibira ikana iki, itan ja rarebobires jaton mainbiribira ikana iki, jainoax jaton joinbiribi yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Jabora Noekan bakebaon rarebobo iki, jaton rekénboainxon peokooxon bakeakanabora meskó keska jaton chiní bakebo iká iki, itan jatonbiribi maiabora ikana iki. Jenen ewa winota pekáora jatíbiain janbiskana iki, jabaonra nato neten maibotiibi iká jemabo akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ja inontianra jatíbiain westíora joinbicho yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bari pikotaiorikea mainmeax pikotax boxonra, Sinar ikain mai teshanpa meraax jain jaai banékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wetsa netenra yoianankana iki: “Ladrilloanon akanwe, non chiikan xoinon”, iki. Jaskáxonra moa makan meeyamakin ladrillo akana iki, jainxonra jan tekiati jatonbi meskoxon ayamakin mainmea boi asfalto bixon akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ja aká pekáora yoyo ikana iki: “Neri bekanwe, jemaanon akanwe, jainxon naikibi nokota torre anon akanwe. Jatianra nato main jatíbiain noa janbískantima iki”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ikaxbira ja jema itan jonibaon torreai oinni Ibo bochikiax joá iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","jatian shinanna iki: “Nato jonibora westíora jemabicho ikanai itan westíora joinbichora yoyo ikanai; jaskákinra nato tee peokana iki, nato tee akanaira jawekeskaxonbi jato jenematikoma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Pakéxon non jaton joi onantimaara jakon iti iki, ibakanon yoyo ikibi ninkakananyamai”, iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Jaskáaxonra Ibon nato main jatíbiain jato janbisa iki, jatianra jemaakin moa jenekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Jain ikanainxonra Ibon jatíbi nato mainmea jonibaon joi jato onantimaana iki, jainxonra nato neten jatíbiain jato janbismaa iki. Jaskara ikenra ja jema Babel akin janekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Natobora Semman chiní bakebo iki. Jenen ewa winota rabé baritia pekáo, pacha baritiaya Sem iketianra jawen benbo bake Arfaxad pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Japekáora Sem pichika pacha baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo itan ainbobo jaríbaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad kimisha chonka pichika baritiaya iketianra, jawen benbo bake Sala pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Japekáora Arfaxad chosko pacha kimisha baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo, itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala kimisha chonka baritiaya iketianra, jawen benbo bake Heber pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Japekáora Sala chosko pacha kimisha baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo, itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber kimisha chonka chosko baritiaya iketianra, jawen benbo bake Péleg pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Japekáora Heber chosko pacha kimisha chonka baritiapari jaa iki, jatianra jawen wetsa bakebo benbobo, itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg kimisha chonka baritiaya iketianra, jawen benbo bake Reu pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Japekáora Péleg rabé pacha iskon baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu kimisha chonka rabé baritiaya iketianra, jawen benbo bake Serug pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Japekáora Reu rabé pacha kanchis baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug kimisha chonka baritiaya iketianra, jawen benbo bake Nacor pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Japekáora Serug rabé pacha baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor rabé chonka iskon baritiaya iketianra, jawen benbo bake Taré pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Japekáora Nacor pacha chonka iskon baritiapari jaa iki, jatianra wetsa jawen bakebo benbobo itan ainbobo jaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taré moa kanchis chonka baritiaya iketianra, jawen benbo bakebo Abram, Nacor itan Harán pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Natobora Tarékan chiní bakebo iká iki, Abram, Nacor itan Harán. Haránra Lotkan papa iká iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ur jema Caldea mainmeaxa mawata iki, jawen papa Taré ikámatianbira japari iká iki, jainoax pikotainoaxbira mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramra Sarai betan wanoa iki, jatianra Nacor Milca betan wanoa iki, jara Haránman bake iká iki, itan jawen wetsara Iscá iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraíra tooisma ikax bakeoma iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Caldeo jonibaon Ur jemankoniaxa Canaán main kaai Taré pikota iki, kakinra jawen bake Abram itan jawen baba Lot jainoax jawen baban ewa Sarai ioa iki. Ikaxbira, Harán jemanko nokotax jain jaai banékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Jatianra rabé pacha pichika baritiayanix Taré mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wetsa netera Abram Ibon yoia iki: “Min mai, min rarebobo itan min papan xobo moa jenewe, jain mia kati mai en mia oinmanon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Min chiní bakebo tsinkixon westíora main en jato imaara ichabires ikanti iki; jakonhakinra en mia shinanxonti iki, itan kikin jakon ninkakataira en mia imati iki, jainoax wetsabo jakonhaira mia iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mia jakonhaibora, en jakonhati iki, mia ramiaibora en ramiati iki; miibaxonra nato netemea jatíbi jonibo en jakonhati iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abramra Ibon jaskati yoia keskati Haránhinoax pikota iki. Jainoax Canaánhin kaai pikónontianra kanchis chonka pichika baritiaya iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Jawen awin Sarai itan jawen noxa Lot-ra kakin boá iki, jatíbi jayata jawékiboribi itan ja marokin bia jonibora boá iki. Canaánhin jabé boabo betan nokóxonra, ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramman jatíbi ja mai shitabainax Siquemhain nokota iki. Jainra encina jiwi iresama Moré iká iki. Ja inontianra cananeo jonibo ja main jakana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jainxonra jaki pikoxon Ibon yoia iki: “Nato maira min chiní bakebo en meniai”, akin. Jatianra Ibo rabinoxon Abramman makan tsamana iki, jainoax jaki pikoxon oinmaa iketianra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Japekáora Betel jemankoniax bari pikotaiori iká manan mainko kaa iki, jainra jawen carpa peota aká iki. Ja ikainoaxa bari jikiaiori Betel iká iki, jatianra Hai jema bari pikotaiori iká iki. Ja ikainkoxonra Abramman jakiribi makan tsamana iki, Ibo rabinoxonra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Japekáora moa kariba iki, jainmashamanra ikaina iki, Néguev maiorira kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Jaskarabo inontianra, ja main jatíbiain ikonbires jawékiati yama iká iki. Jatianra Abram jawetio basires jaai Egiptonko kaa iki. Jawen itinkora ja jawékiati jawebi yama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egiptonko nokoti kakinra Abramman, jawen awin Sarai yoia iki: “Ninkawe, en oinnara mia iorai metsá ainbo iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","jatianra Egipto jonibo mia oinnax neskákanti iki: ‘Nato ainbora ja jonin awin iki, ikira ikanti iki’. Jatianra ea retekanti iki, jatianra mia binoxon mia jaweakantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Jaskara iken, ea jakon inon itan mia kopí ea reteyamakanon ixon, eara jawen poi iki akin min jato yoiti iki”, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Egiptonko nokóketian, ja Egipto jonibaon Sarai oinnara iorai metsá iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Egipto apo faraónman joni koshibaonribira oinna iki, jatianra iorai metsá riki ja ainbo ixon yoii bokana iki. Jatianra faraón iká xobonko Sarai bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ja Sarai kopíra, faraónman Abram akonbireskin jakonha iki. Carnerobo, wakabo, ja yonoti jonibo, ja kikinhakin yanka yonoti ainbobo, burrobo itan camellobo meniresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Jaskáakenbira ja Sarai kopíribi Ibon ja faraón jawen awin itan bakeboyabi meskó jakonma isinbaon masá tenemaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Jaskara iketianra, faraónman Abram kenamaxon, yoia iki: “¿Jaweatiki, nato ainbo min awin ikenbi, min ea yoiamaa iki? ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nokon poi riki, ixonra min yoia iki, jatianra nokon awin iti en bia iki. Natora min awin iki, ¡Moa bixon botanwe!” akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Jatianra Abram Egiptonkonia pikokanti faraónman jawen jonibo yoia iki, jawen awin itan jatíbi jawen jayata jawékiboyabira raankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Egiptonkoniax pikotaxa, Abram jawen awin itan jatíbi jawen jayata jawékiabi, Néguev main jakiribi kaa iki. Jawen noxa Lot-ra jato betan kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramra, ikonbires icha jawékia iká iki, oroya, plataya, itan yoinaboyara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Neguevhainoax baneti kaira, iikaini kaax Betel jeman nokota iki, jainoax kaaxa, jainpari ikátiainko nokota iki, jara Betel betan Hai jema naxaran iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Jara iká iki jain makan tsamanxon jainxon jan Ibo rabiantana. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot-ribira ikonbires icha jawékia iká iki, jawen epa Abram keskáshamanribi, icha carneroya itan icha wakaya jainoax jabé jaa joniboribi icha iká iki; ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ikaxbi jain ikanara icha yoina jatíbi jato pimati senenma iká iki. Jainbicho jatira moa atipanyamakana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","jaskatira Abramman waka koirannai jonibo betan, Lotkan waka koirannai jonibo, sinakanankana iki. Ja inontianribira, cananeobo betan ferezeobo jainpari jaakana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Jaskara iketianra, wetsa neten Abramman Lot, yoia iki: “Mia itan eara noa rarebo iki, jaskara ikaxa noa join itima iki, min yoina koirannai jonibo itan nokon jonibora jaskara itima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Oa riki jatíbi mai, jainoara min katóti iki. Enra mia yoiai, rama ebé jayamawe. Mia norteori kaitianra, ea surhori kaai, jatian mia surhori kaaitianra ea norteori kaai”, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lotkanra jatíbi ja Jordán paro teshanpa oinna iki, jatian Zoar jemashoko kaman oinnara, ja teshanpain icha onpax iká iki, joa wai ani keskára iká iki. Egipto keskára iká iki. (Sodoma itan Gomorra jema Ibon keyoamatianra jaskara iká iki.) ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jatianra jatiobi ja Jordán teshanpa Lotkan katota iki, jatianra ja ikanainkoniax bari pikotaiori kaa iki. Jaskataxa, Abram itan Lot jatonbiribi iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramra Canaánhain baneta iki, jatianra ja teshanpa ikain jemabo ikain jaai Lot kaa iki, Sodoma jema ochómara kaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","jainoa jonibora ikonbires jakonmabo iká iki, jakonmabires ochabo akira Iboki ramíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot kaa pekáora, Ibon Abram yoia iki: “Ja mia ikainxon, norteori, surhori, bari pikotaiori itan bari jikiaiori jakonhakin oinwe; ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","jatíbi ja min oinna maira en mia meniti iki, jatianra jatíbitian mina itan min chiní bakebaonna iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Jabora mai poto keská icha en jato imati iki. Mai potoshokobora topóntikoma iki, min chiní bakebora topontikomaribi iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","¡Wenixon, ja mai jawen nenké itan jawen naxbá ointanwe, jara en mia meniai!” akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Jaskáxonra, Abramman jawen carpa xobo ras abaini Mamré janeya jonin encina nii ikainko, Hebrón jema ochóma jaai kaa iki. Jainra Ibo rabinoxon makan tsamana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Jaskara inontianra Amrafel Sinar apo iká iki, Arioc iká iki Elasar apo, Quedorlaómer iká iki Elamhinoa apo, itan Tidalra Goim apo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Natobora, nato apobo betan reteanankana iki, Bera, ja Sodomainoa apo, Birsá, Gomorrainoa apo, Sinab, Admáhinoa apo, Seméber, Zeboimhainoa apo, jainoax Vela jemamea apo, ja jemaribira Zoar iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nato pichika apobaonra Sidim xankenhain ja Aniparo Mawata ikain, jaton sontárobo jainbicho tsinkikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ja apo Quedorlaómernin chonka rabé baritia, jato iboara iká iki, ikaxbira chonka kimisha baritia itin, ja pichika apobaon jabé reteananti shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ja wetsa baritia iketianra, Quedorlaómer itan ja betan iká apobo Astarot Karnaim iká mainko bokana iki, jatianra jainxon refaítabo betan reteanankin jatoareskana iki; japekáora Hamhainxon zuzitabo jatoareskana iki, Savé-quiriataimhainxonra emitaboribi jatoareskana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","jatianra Seir mananmanxon horeobo jatoareskana iki, jainxonra El-parán mai teshanpa kaman jato chibankana iki, jara jain jawebi xoxoyamai manan patax iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Quedorlaómer itan jabé ikábora baneti boi En-mispathain nokókana iki, jaribira Cades iki. Ja baneti bokinra amalecitabaon mainmea jatíbi nokoaibo jatoaresxon bibotankana iki, Hazezon-tamar mainko jaa amorreo jonibora jaskáaribakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Jatianra nato nenoa apobo Sodoma, Gomorra, Adma, Zeboím, itan Bela, Sidim manan teshanpain tsinkiti bokana iki. Jainoaxa nato pichika apo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Quedorlaómer, Tidal, Amrafel itan Arioc betan reteanana iki, jabetan ikana chosko apora Elam, Goim, Sinar itan Elasarhainoabo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Jatíbi ja Sidim manan teshanpainra, jainnobi asfalto bói jain yakata icha xantóbo jaa iki, jatianra Sodoma itan Gomorrainoa apobo reteanantiainoax jabati boí, ja bói xantóainbo pakékana iki. Jatíribi apobora mananman jabati bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Jatoaresabaonra Sodoma itan Gomorrainoa jatíbi jaton jawékiatibo itan jaton kopí jawékibo, bibaini jainoax moa bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ja Abramman noxa Lot, Sodomain jaa iketianra, jaribi yatanxon, jatíbi jawen jayata jawékiabi bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ikaxbira westíora joni mawáyamaax jabatax kaxon, jatíbi jaskara ikábo ja hebreo joni Abram keshana iki, Mamré janeya jonin encina jiwibo ikainko jara iká iki. Ja Mamrera Escol betan Anernin wetsa iká iki; jabora Abram betan rabeta iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Jawen noxa yatanxon bokana onanxonra Abramman, jawen xobonkoniax pikotabo, jaki koshia jawen jakon yonotibo jato tsinkia iki, jatíbira kimisha pacha chonka posaka joni iká iki, jatianra apobo chibani Dan jema kaman jato betan kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Yaméra, Abramman jawen jonibo betan ratereskin ja apobo peoa iki, jatianra Hobá jema kaman jato chibankana iki, jara Damasco jema norteori iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","jatianra jatíbi ja bokana jawékibo keyokin jato bichinkana iki. Jaskáxonra, Abramman jawen noxa Lot biribaa iki, jatianra jatíbi jawen noxan jawékibo biribaa iki. Ainbobo itan wetsa joniboribira bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Quedorlaómer itan jabetan rabeta apobo jatoaresa pekáo Abram joketian biira, Sodoma apo Savé manan teshanpain kaa iki, jaribira apon teshanpa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melquisedec, Salem jemamea apo itan koshi Diossen sacerdoteninribira pan itan vino xeati boxona iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","jatianra Abram jakonhakin shinanxonkin neskáakin yoia iki: “Nai itan mai jonia ani Diossen, mia jakonhabanon; ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","itan ja ani Dios rabikaata ibanon, jan amaara min rawíbo min jatoaresa iki”, akin. Jatianra Abramman, jawéki bonkana jakiribi bixon, pachankonia chonkabo Melquisedec menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Jaskáa pekáora Sodoma apon Abram yoia iki: —Jonibores ea meniwe, jatian minbiribi jawékibo biwé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ikaxbira Abrammanbiribi yoia iki: —Enra akonkin Ibo yoia iki, ja koshi Diossa nai itan mai jan jonia iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","min jawéki jawebi bitimara en yoia iki, westíora yoman inonbi iamax westíora zapato risbí inonbira en biamai, icha jawékia en imaa riki ixon jawetianbi min yoiamanon ixonra en biamai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nokonabi itira jawebi ea keenyamai, nokon yonotibaon pikanabichores ibanon. Ja ebé kaa jonibaonresa jawékibo biti iki, jabora Aner, Escol itan Mamré iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Jaskarabo iká pekáo, Abram shinan manokainketian Ibon nekeaxbi ja betan yoyo ikin, neskáakin yoia iki: —Rakéyamawe Abram, ea riki mia koirankin panaa. Ja min biti jawekira, iorai icha inoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ikaxbi Abramman neskáakin yoia iki: —Ibo Diossé, jawe ea menikasikayaki mia iitai ea bakeoma ikenbi, nokon xobon iká Damascoainoa Eliezer riki, jan nokon jawékibo tekikin biti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Jainxon Abramman yoiribia iki. Westíora bakebi min ea meniamaa kopíra, ja nokon xobon iká westíora nokon yonoti jonin, nokon jawéki tekikin biti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Jatianra Ibon Abram neskáakin yoiribia iki: —Jan min jawékibo tekikin iboatira, min bakebi inóxiki; wetsabora iti yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Jatian Ibon Abram, jeman pikoxon neskáakin yoia iki: —Minra abiratiki, jakonhakin nai oinxon, atipanxon wishtinbo toponwe. Jatí icharibira, min chiní bakebo inoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrammanra Ibo ikonhaa iki. Jaskáaketianra já yoii atikeskabiakin akai joni riki, iki Ibo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Jainxonra yoia iki: —Eara Ibo iki; caldeo jonibaon Ur jemameara en mia pikoa iki. Nato mai tekikin min bakebaon biboti kopí mia meninoxon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ibo Diossé, ikaxbi ¿Jawekeskaa shamanxonki, en onantiki, nato mai iboanon ixon, min ea meniai? akin Abramman aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Jatian Diossen neskáa iki: —Minra ea bexonti jake, westíora waka awin, westíora cabra awin, jainoax westíora carnero bene, jabora iti jake kimisha baritiayabo. Jainxonribira, min beti jake, westíora noma itan westíora xotó bake pemoxaishaman —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Jatíbi ja yoinabora, Abramman Dios bexona iki, ja yoinabora naponbekon kaxkepakea iki, jaskáxon beibanankin joyóbaintiakin tipina iki; ikaxbi ja noma betan xotó kaxkeyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Jatian ja yoinabo mawata namibo pikasi, poinkoskobo maanna iki, ikaxbira Abramman jato ibina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Moa yametaitian, ikonbiresi Abram oxaa iki. Ja basimabi, moa kikin yamé meran iká iki, jatianra ikonbiresi raketa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Jatian Ibon, Abram neskáakin yoia iki: —Moara min onanna iti jake, min chiní bakebora, wetsabaon main janoxikanai, jainoara jato kikinhakin yanka yononoxikanai; chosko pacha baritia kamanra, jato ramianoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ikaxbi enribira, mato kikinhakin yanka yonoai jonibo, masá tenemanoxiki, jaskara winota pekáora, min chiní bakebo xabakaanoxiki; jainoaxa iorai icha jawéki ibo inóxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Miabiribira, moa yosishamanax jakonshamabires shinan tantishamanres mawánoxiki, jaskatax min anibo ikainribi; mia miimetax jato betan iki, mia kanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nenoax, jawen chosko itin iká min chiní bakebora, jakiribi nato main benóxikanai. Jaskara ikaxa, ja rama neno jaa amorreobo jaton jakonma aká kopí, en jato masá tenemati senenamapari iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Jatianra bari jikiax, jatíbiain moa yamé iketian, westíora horno koinnai meran chopa bonton tirí, ja yoina nami tipina napon winotai oinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ja netenribira Ibo betan Abramman, ja senenhabekonti joi axon neskáakin yoia iki: —Nato maira, min chiní bakebo en meninoxiki. Egipto paronkoniax peokootax, aniparo Éufrates kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ja mai iki, quenitabaona, ceneobaona, cadmoneobaona, ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hititabaona, ferezeobaona, refaítabaona, ");
INSERT INTO shpNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreobaona, cananeobaona, gergeseobaona jainoax jebuseobaona —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraíkanra jawen bene Abram, bakeaxonti atipanyamaa iki, jaskara ikenbi jain iká iki, westíora jawen yanka yonoti Egipto ainbo, jawen jane Agar. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Jatian jaskara ixon, Abram neskáakin yoia iki: —Ea riki Diossen bakeaisma imaa, jaskara iken min ea axonon en mia yoibanon, nokon yanka yonoti Agar betan iwé, jaskataxparira já meranoax nokon bakebo jabirati iki —akin. Jaskáakin Saraikan yoia, Abram jen ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Jatian Abramman awinhanon ixon, Egipto ainbo Agar boxon menia iki, jara iká iki moa chonka baritia Canaánhain jakana inontian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramman Agar nokoara, moa toota iki; ikaxbi jaskati toota onantaanan, jawen ibo Sarai oinxon omiskin, peoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Jatian Saraikan, Abram neskáakin yoia iki: —¡Mia kopíra akai, ea Agarnin omískin! Enbira mia menia iki awinhanon ixon. Jatian ramakan bakeya iki kaai kopí, ebebonbires shinanmeetai. Diossenbi yoibanon tsoa kopíkayarin ixon, mia kopírin iamax ea kopírin ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Jatian Abramman neskáakin yoia iki: —Shinanwe, mia riki min yanka yonotinin ibo ainbo; min jaskáa jakon iti iketian, ja min shinanna keská awé —akin. Jatian Saraikan, akonbireskin ramiakin peoa, Agar jabata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Jaskákenbi, Diossen ángelnin tsoa jonibi jain jaama mananmamea nokoa iki, Shurhain kati bainko; jene jokonai patax iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Jainoa yokata iki: —Saraikan yanka yonoti, Agar, ¿Jaweranoax joirin mia, itan jawerano kaaiki mia iitai? —akin. —Nokon ibo ainbo Saraibakeax jabati kaira ea iitai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Jatian Ibon ángelnin neskáakin yoia iki: —Min Ibo ainboiba jakiribi kaax ja betan itanwe, jainxon jatíbi mia yoiabo axoni yoiti itanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Jainxon Ibon ángelnin neskákin yoiribia iki: “Min chiní bakebora akonbireskin en jato kaimanoxiki, tsonbi topontimatii. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Miara tooya iki, benbo bakeyara mia iki kaai, Ismael akinra min janeti iki; min masá tenea Diossen ninkata kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Jara inoxiki, yoitimaa siná joni, nii meranoa yoina keská. Jaskatira jatíbi jonibo betan reteananoxiki, jainoaxa já betan jatíbi joniboribi reteananoxiki. Ikaxbi jara, jawen wetsabo jaki ramíreskanainbi, jato patax janoxiki”, akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Jaskati Ibo betanbi yoyo ixon, Agarnin janea iki, “oinmis Dios”, akin. Jainoax janbix neskata iki, “Ea Diossen oinna, ikaxa ea japarike”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Jakopíribira, ja pozon jane iki: “Jiria ixon, ea oinnaton pozo”, iki iká. Ja pozora, Cades betan Bered jema naxaran iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Jatianra, Agarnin Abram betan westíora benbo bakea iki; jatian janea iki, Ismael akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ja Ismael pikoontianra, Abram posaka chonka sokota baritiaya, iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram, iskon chonka iskon baritiaya inontianra, jaki pikoxon Ibon yoia iki: —Ea riki, jatíbi atipana koshi Dios; jakonmanin yointimai ebebon jakonbires jawé. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jatianra, ja senenhabekonti joi en miibetan ati iki: ichabires chiní bakeboyara en mia imanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Jatian, Abram chirankotax maikibi bekepia iki, jainoara Diossen yoiboresa iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Nato riki ja senenhabekonti joi, en miibetan akai: Miara ikai, icha mainmea jonibaon papa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Min janera moa Abram iamai. Ramara nenoax peokootax, min jane ikai Abraham, icha jonibaon papa en mia imai kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Min chiní bakebora, kikinbires icha en imanoxiki; miibakeaxa apobo betan jemabo pikónoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ja jaskara ati shinan en miibetan akai riki, jatíbitian min Dios ea iti, jainoax min chiní bakebo betan en atira iti iki; ea jabaon Diossibi iti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Jain mia rama jaa Canaán maira, jatiobi en mia itan min chiní bakebo meniti iki; jatíbitian iboanon ixon, jainoaxibira jaton Dios ea iti iki —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Jaskáakin yoixonbi, Diossen Abraham neskáakin yoiribia iki: —Ikaxbira en jaskara ati shinanna joi, min senenhati jake, min chiní bakeboyaxonbi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ja en mato betan jaskara ati shinanna joi, maton chiní bakeboyaxonbi maton senenhati riki: Jatíbi benbobaon, jaton jakina rebichi xateti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Maton jakina rebichira maton xateti iki, ja en mato betan ja senenhabekonti joi aká, onanti iti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ramara nenoax peokootax, jatíbi benbo bake pikotabo posaka neteya iketian, maton jawen jakina rebichi xatexonti iki. Min xobomeax pikota benbo bakeribira aká iti iki, yanka yononoxon koriki kopí wetsankonia bia joni wetsabires inonbira, xatea iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ja xobomeax pikota bake itan, maroxon bia jonira ayamaama jawen jakina rebichi xatea iti iki. Jatianra en jaskara ati shinanna joi yoii iká maton yoranko onanti iti iki, jatíbitian en jaskara ati shinanna joira iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ikaxbi, jawen jakina rebichi xateama jonira, mato betan itima iki; jaskara ati en shinanna joi yoitimakin senenhayamaa kopíra itima iki —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Jainxon Diossen Abraham neskáakin yoiribia iki: —Min awin Saraikan, janera moa ja iamai, nenoax peokootaxa jawen jane ikai Sara. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Enra jakon itiakin shinanxonai, jaskáaxonra en amai miibetan westíora benbo bake. Jakon itiakin en shinanxonaira ikon iki. Sarara iti iki, icha mainmea jonibaon tita. Jainoax, jawen chiní bakebora jemabaon apo iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Jatian Abraham, chirankotax maikibi bekepia iki, jainxonra shinanhananbi osana iki: “¿Pacha baritiayanixmein joni papa iti iki? ¿Jainxon Saranmein ati iki, iskon chonka baritiayaxon benbo bakeakin?” ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Jatian Dios neskáakin yoia iki: —¡Min jakon shinanxona keskati, Ismael japainon riki! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ikaxbi Diossenbiribi yoia iki: —Enra yoia iki, min awin Sara betan westíora min benbo bakeati, jara Isaac akin min janeti iki. En jaskara ati shinanna joira, jeneyamakin en já betan ati iki, jainoax jawen chiní bakebo betan; jatíbitian en ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismael yoikin min ea akára, en mia ninkáxonke, jaskara iketianra en akai jakon shinanxonkin; jainxonra en icha bakeya imai, jainoax jawen chiní bakebo kainon ixon. Ismaelra inoxiki, chonka rabé iresama joni koshibaon papa, jaonxon kaimaxonra; icha joni iketian iorai ani maia, en jato imanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ikaxbi Isaac betanra, en akin jeneyamai, jaskara ati en shinanna joi; ja bakera westíora baritia pekáo, ja netebaon, Sara betan min bakeati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Jatian Abraham betan yoyo iki senenax, Dios moa jainoax kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ja netenbira, Abrahamman jawen bake Ismael, jawen jakina rebichi xatexona iki. Jainxonra, jatíbi jawen xobomeax pikota jawen yonotibo betanbi, wetsankonia koríki kopí bia jonibo; jaboribi jaton jakina rebichi xatexona iki. Jaskáati Diossen yoia iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iskon chonka iskon baritia ixonra, Abrahamman jawen jakina rebichi xatea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismael, chonka kimisha baritiaya iketianra, jawen jakina rebichi xatexona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham betan jawen bake Ismael, jaskáati yoia senenhati kopí, ja netenbicho jaton jakina rebichi xatexonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Jabé akábora iká iki, jatíbi jawen xobon ikábo, jawen xobonkoniax pikota jawen yonotibo, wetsankonia koríki kopí bia joniboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Diossenra Abraham nokoa iki, Mamrekan encina nii ikainko, jawen carpa xobo xepótiain yakata; bari xaman ikax xana iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamman, bewakeexon oinna iká iki, kimisha joni chankata. Jato ointaanan ishtonbires wenikainxon, jato bii chirankootax main bekepia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Jaskáxon yoia iki: —Nokon Ibó, enra mia yoiai ishtonbires kayamai, mia banépariti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Min oinna jakon iketian, en jato yoibanon onpax bekanon ixon, maton tae chokanon; jainoax nato jiwi ota naman shokores mato tantinon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Maton yonotiiba, mato jokebetin ixonra, en mato piti bexonai; kaamatianbi jawékiax jan koshikainax mato katanon ixon —akin. Jatianra: —Ikonrake, jakon riki —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Jawen carpa xobo meran jikikainxon, Abrahamman Sara neskáakin yoia iki: —¡Ishtonwe! Rabé chonka kilo harina jakonshaman bixon panhawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Jaskáa pekáo Abraham, waka ikainko ishto kaxon jainoa katota iki; jakonshaman waka bake bene, jaskáxon jawen yonoti menia, ishtonbires yoá aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Waka nami pimaribikinbi, waka xoma jene seroaa petsoti betan, waka xoma jene xeati jato bexona iki. Jaskáakin jato bexona pikanai kaman, jato amai jiwi ota naman chankata iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Pikin senenhaxon, ja meratabaon Abraham yokákana iki: —¿Min awin Saraki, jawerano iki? —akin. —Ono, carpa xobo meran riki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Jatian westíoranin neskáakin yoia iki: —Oa wetsa baritia joaitonra, ea miiba merati joribai, jatianra min awin Sara; moa westíora benbo bakeya inóxiki —akin. Jatíbi ja yoyo ikanaitian ninkatira, carpa xobo xepotiain Abraham pekao, Sara iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ja Abraham betan Sara iká iki moa yosiora, jatian jaskara ikaxa Sara, moa jimii jeneta iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Jaskara ixonra, Saran osán teneyamakin osántaanan shinanna iki: “¿Jawekeskataxmein, ea jaskátinin keenti iki, rama iki nokon bene iorai yosi, jainoax ea iki moa iorai yoxan?” iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ikaxbi Ibon Abraham neskáakin yoia iki: —¿Jawekopiki, Saran osanai? ¿Yoxanshoko ixonbi, bakeatiki ikonhayamai? ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Jamayanke Ibona, atikomabires jawéki jan atipanyamaa? Oa wetsa baritia joaitonra, ea miiba merati joribai, jatianra Sara moa bakeya inóxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Jaskatai ninkatax, Sara raketi paranakasa iki. Jaskákin yoia iki: —Enra osanama iki —akin. Jaskatainbi Ibon neskáakin yoia iki: —Enra onanke min osana —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Jaskata pekáo, ja meratabo weníbaini Sodoma jema ikaori bokana iki. Abrahamra kaa iki, bokanaitian jato raani. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Jatianra Diossen shinanna iki: “Ja en akí kaira, en Abraham yoiti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Jakaya iki kaai betin, westiora mainmea icha itan koshi shinanya jonibaon papa. Enra yoia iki já meranxon jatibi nato netemea jonibaon jemabo, jakon shinanxonti, ibakanon jakon jaai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Enra katota iki, jawen bakebo itan jawen chiní bakebo jaskara ati jato yoinon ixon, jaskara iti en onanmaa keskati ikanon ixon jato yoiti; jatíbi jakonhakin itan atikeskabiakin akanon ixon, jatianra en ati yoiabo jato axonkin en senenhati iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Jaskáxon Ibon neskáakin yoia iki: —Sodoma betan Gomorra jonibora jakonmabires ninkakaatai, jainoax jaton ocha akábora iorai jakonmabires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ramara ea jain kaai, ikonrin ja ea yoikana keská ikonbires jakonma ixon oinni, jaskáakin enbi oinxonra onanti iki ikon riki ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Jatian ja merata rabé, jainoax Sodomain kaa iki, ikaxbi Abraham banetax, Dios bebonbipari iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Jaki ochómakainxon neskáakin yokata iki: —¿Minki akai, jakonma akábo betan jakon akaibo jato keyokin? ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Jawekeska ikax, ja jeman jati iki pichika chonka joni jakonma akamabo ¿Jaskara ikenbimein, ja pichika chonka joni kopi noibaxon jaton jakonma shinanxonyamatitianbi, min ja jema keyoti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡Jakonma akamabo betanra, jakonma aká ibobo min reteti atipanyamake! ¡Rabéxonbi ocha aká iketian ati keskáakinra, min retetima iki! ¡Jato reteyamawe! Jatíbi nato netemea jonibo jakonma winóxon, joi benxoamakanai xenwina koshi riki mia, ¿Jaskara ixonbiki min jato jakonhakin jakonma akábo benxoaxontima iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jatian Ibon yoia iki: —Ja pichika chonka joni jakonma akamabo Sodoma jeman jaketian nokoxonra, jabo kopí jatíbi jain jaabo jaton jakonma en shinanxontima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Jaskáakenbi Abrahamman, jakiribi yoia iki: —Neskati mii betan yoyo iki, ea bebon yoitimakaresainbi ea shinanxonyamawe, ikon riki mia Dios, ea joni iresabires ixon mia jaskati senema. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ikaxbi, iti iki maxkati pichika jakonma akáma joni, pichika chonka senenhati. ¿Ja pichika joni, maxkata kopíreski min jatíbi jema keyoti iki? —akin. Jatian Ibon neskáakin yoia iki: —Chosko chonka pichika, jakonma akáma joni jaketian nokoxonra, en keyotima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","—Jarabirake chosko chonkabicho, jakonma akáma jonibo —akin. Ikaxbi, Abrahamman yokákin teaboresaitian. —Ja chosko chonka joni kopíra, ja jema en keyotima iki —akin Ibon aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Jaskákenbi, Abrahamman yokáribia iki: —Eapari ninkáxonwe en mia yokánon, yoitimakainxon akonbireskin teakin; ja akaipacho en mia yokata eki sináyamawe. Minra abirati iki, nokokin jakonma akáma jonibo kimisha chonkabichores —akin. Jatianra Ibon jakiribi yoia iki: —Ja kimisha chonka, jakon joni jaketianra, ja jonibaon jakonma aká en shinanxontima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Jabi Abrahamman yokákin teaboresa iki: —Mia nokon Ibo iketian jaskáakin mia yokatira, ea iorai yoitimake, ikaxbi, ¿Rabé chonka joni jakonma akáma jaketianki min jaweati iki? —akin. Jatian Ibo yoia iki: —Ja rabé chonka joni kopíra, ja jema en keyotima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Jabi Abrahamman yokákin teaboresparia iki: —Eki, sináyamawe miara nokon Dios iki, ja akinbichora en mia yokatai, nato aká pekáora en mia yokáwetsayamai: ¿Jakon jonibo chonkabichores, jaketianki min jaweati iki? —akin. Jatian Diossen neskáakin yoia iki: —Ja chonkatanibires, jakon joni jaketianra, ja jema en keyotima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Jatian Abraham betan yoyo iki senenax, Dios jainoax kaa iki; jatianra Abrahambiribi, jawen carpa xobonko kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Moa yametaitian, ángel rabé Sodoma jema ikain nokota iki. Lot iká iki, jema xepotiain yakata, jainpacho jonibo tsinkitainko. Nokókanaitian oinnax, weníkaini kaxon jato bikin jowé aki chirankootax, maiki bekepia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Jaskáxon jato yoia iki: —Jonibó, maton yonoti ixonra en mato yoiai, ea ninkáxoni jeen ikax, nokon xobon bokanwe nato yamérespari mato jain inon. Jainxon maton tae chokanon, jainoax mato yamékirishaman kanon —akin. Jato jaskáabi yoikana iki: —Irake, noara kayamai. Noa jemanbi ishinbanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Jaskákankebi, Lotkan jato iokaskin akonbireskin teaitian jeen ikax, noa mibé min xobon kabánon ikana iki. Jato betan jawen xobon nokóxon, Lotkan jakonhakin ja yamé jato pimakin, jan soo imatioma pan axonketian, ja meratabaon piá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Jatian oxakanamapari ikenbira, Sodoma jemamea jatíbi jonibaon ja xobo katekana iki, jainra ikana iki bakeboainoax peokootax yosishokobo kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Jainxon Lot, saí akin peokana iki: —¿Jakan jawerano ikanai, nato yamé min xobon joá jonibo? ¡Noa jato pikoxonwe! ¡Nonra jato yorankasai! —akinbo akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Jaskákanaitian jeman pikóxon, já pekáo jawen xobo xepoti iketian, kikinhakin xepotaanan; jato betan yoyo ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Jainxon jato yoia iki: —Jato jaskáayamakanwe, matora nokon rarebo iki, matonra jakonmabires jawéki shinanxon anake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Eara, rabé bake ainboya iki, tsoa joninbi tanaamapari; jabo en mato pikoxonbanon maton keena keská anon. Ikaxbi, nato jonibo jaweayamakanwe, en keena bekana riki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Jaskatainbi jabaon neskáakin yoia iki: —¡Oke iwé! Noara keenyamai, wetsankoniax joxon min yoia keskáakin noa amati. ¡Ramara, jabo ati bebonbires, mia non ramiayonai! —akinbo. Jatianbira Lot ramiakin peokana iki, jaskaaira ochómabaikana iki, jawen xobo xepoti pakekasi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ikaxbi, jaiba meratabaon mepikotaanan yatanxon, Lot xobo meran jikimakana iki. Jaskáaxon, xepóti xepokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Jaskáaxon, ja jemaori ikábo jato benche banémaa iki. Jatíbi bakeboainxon peoxon yosishokobo kaman, jato benche banémaa iki. Jaskatax, xobo xepóti benai bohantani paxkinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Jatian jaiba meratabaon, Lot neskáakin yoia iki: —¿Wetsa min rareboboki, neno jaríbaa? Min benbo bakebo betanbi bake ainbobo, jainxon min rayosbo biwé, jainoax nato jemamea min jatíbi jawéki; jabo jokonhaxon nenoax ochó itiakin botanwe, ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","nato jema, non keyoai kopí. Diossenra, ninkáke ichaxon yoikanaitian nato jema moa iorai jakonma. Jaskara kopí riki, nato jema keyoti noa raana —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Jatian Lot jawen rayos iti jonibo oinni kaa iki, jabo iká iki jawen bake ainbobo binoxon onantiabo, jabo nokoxon jato yoia iki: —¡Wenitax, nenoax moa botankanwe, nato jemara Diossen keyoai! —akin. Jawen rayos iti jonibo, jaskáakin Lotkan yoiabi ikonhayamabireskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Moa nete xabataitian, ángelbaon Lot yoia iki: —¡Ishtonwe! Weníxon, min awin betan min bake ainbo rabé nenoa botanwe, nato jema non keyoaitian mawákashamakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Jaskáabi Lot ishtonyamaitian, Ibon já noibai kopí, jawen awin jainoax jawen bake ainbobo kishpinkanon ixon, ángelbaon metsontaanan ja jemamea jato pikokin boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Moa jemameax pikókanketian, ángelnin neskáa iki: —¡Ishtokanwe, mato kishpinnon! Pekáori oinyamakanwe; ja mai teshanpanin kaai jawekeskataxbi jaweranobi chankayamai botankanwe. Mato kishpinnon, mananman botankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Jaskáabi Lotkan yoia iki: —¡Noa jaskáyamawe, mato non Ibo iketianra en mato yoiai, noara jain kayamai! ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Matonresa, ichabires jakonhakin noa akinke, nobetan jakon ixonra janon ixon, maton noa kishpinmake; ikaxbi ja mananman kati maton yoiabira, noa jain kati atipanyamake, bainmeara jan jato keyoai jakonmanin nokoa, noa mawánake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nenoaxa, ochóma iki westíora jema maxkoshoko, jain noa jabati kati. ¡Jain noa ranwe kishpinnax noa janon ixon, ja jemara ikon maxkoshoko iki! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Jatian, wetsan yoia iki: —Enra mia ninkáke, min yokatara en mia axonai. Ja min yokata jemara, en jaweayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ikaxbi, ¡Bomentankanwe! Mato jain nokotai kamanra en jawebi ayamapariai —akin. Ja jema maxkoshoko iketian, janekanara iká iki Zoar. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nete xabáketian, Lot Zoarhain moa nokota iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Jatianra moa Diossen, ja Sodoma betan Gomorra jemaki, asufreya chii tiritai oi pakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Jatíbi ja jeman jaabo jato keyoa iki, jainoax jatíbi ja mai teshanpanin xoxoai niibo keyoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ikaxbi Lotkan awinribi já pekao kakin pekáori oinnatianbi, tashi makan baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wetsa nete xabáketian yamékiri, Abraham kaa iki; jainoax Dios betan yoyo iantanainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Jainxon oinna iki Sodoma betan Gomorra, jainoax jatíbi ja mai teshanparibi, jaskáakin oinna iká iki; jatíbi ja mainmeax koin keyati, horno meranoax ikai keskati. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Jaskáaxonra aká iki, Diossen keyokin ja Lot jain japachoai mai teshanpain iká jemabo, ikaxbi Abraham shinanxon Diossen Lot jainoa tsekáa iki; jato akai jakonmanin ayamanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Jaskata pekáo raketi, Lot Zoar jeman moa jakashamai, jawen bake ainbo rabéya mananman kaa iki. Jain kaax, ja kimishabi manan kini meran jakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Jain iikin wetsa neten, jawen rekeman, jawen wetsa chini yoia iki: —Non papara moa yosi iki, nato noa jain iká mainra tsoa jonibi yamake, noa jaskati axea keskáakin noa jan awinhanoxon biti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jaskara iketian, non papa paenhanon awé, non yoranmanon; jaskáaxonra non bakeaxonti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Jaskáawana yamébi, jaton papa paenhakana iki, jatian ainbo bake rekeman jabé yorana iki. Jaskákenbi onanyamaa iki, jawetianki jabé iki rakata iká iki ixon, itan jawetianki jainoax wenita iki ixonribi, onanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wetsa nete xabáketian, ja rekeman jawen chiní yoia iki: —Ninkáwe, yaméra non papa betan en yoranwanke, jaskara iketian nato yamé jakiribi paenhanon awé, min já betan yorannon; jaskáaxonra rabéxonbi non jabé bakeati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ja yamé, jaton papa jakiribi paenhakana iki, jatian chinikan jabé yorana iki; jaskákenbi onanyamaribia iki, jawetian ikárin jabé rakati, itan jawetian wenitarin ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Jaskataxa, Lotkan bake ainbo rabébi toota iki, jaton papa betanbi ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ja rekenmanara, benbo bake iká iki, ja janea iká iki Moab, ja iki ramatian moabitabaon papashoko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ja chinikanabiribira, benbo bake iká iki, ja ramatian amonitabaon papashoko, jawen janera Ben-amí iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ja ikainoax, Abraham Néguev mai ikain kaax, Gerar jeman jaai baneta iki. Ja iki, Cades betan Sur naxaran. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Jain ikaxa, iká iki Sara jawen awin ikenbi, nokon poi riki iki. Jaskáketianra, Abimelec Gerar apon jato yoia iki, Sara bexonkanon ixon jawen awin itiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Jaskákenbira, ja yamébi namáketian Abimelec Diossen yoia iki: “Miara mawatai, ja min bia ainbora beneya iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Jaskáakenbi, ja ainbo teaama ixon, yoia iki: “Nokon Ibó, ¿Minkayaki jawe jakonma akáma ikenbi, jato reteti shinanai? ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahammanbira ea yoia iki, nokon poi riki akin, jatianra ainboribi ikon riki nokon poi, iki iká iki. Jaskara iketianra, en shinanai jatíbi en akára jakon iki ixon, jawe jakonma en akáma riki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Jatianra, Diossen namá meran yoia iki: “Kikinhakinra en onanke, min jakon shinanxon aká. Jakopíra en mia teamayamaa iki, ja akáx mia eki ochanaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Jaskara iken, rama ja joni jawen awin banexonwe, jara profeta iki, jaskara ixonra, jan mia yokáxonti iki mia janon ixon; ixonbi banexonyamaaxa ikon iki mia mawáti, mibé ikáboyabi”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wetsa nete xabáketian yamékiri, Abimelec wenixon jawen yonotibo kenaxon, jatíbi jaskáakin namáwana jato yoia iki. Jaskáakin yoiai ninkatax, ikonbiresi rakékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Jaskáa pekáo, Abimelecnin Abraham kenaa joketian yoia iki: —¡Oinparikayata, min noa jaskáa! ¿Jawerin jan en mia jakonma shinanmaa, min eki itan nokon joniboki, ikonbires jakonma ani ocha min raana? Jaskara jawékibora atima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Jatíbi jaskarabo akinki, min jawekeska shinanxon aká iki? —akinbora Abimelecnin Abraham aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Jaskáaketianra, Abrahamman neskáa iki: —En shinanara iká iki, nenoxon maton Dios jawemabi shinanai, jatian jaskara ixon nokon awin kopi maton ea reteti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ikaxbira ikon iki já nokon poi, nokon papan bake riki, ikaxbira nokon titanama iki; jaskara iketianra ea jabé wanoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Diossen, nokon papan xobonkoniax pikóti yoinontianra en yoia iki; ja noa nokotainkobo ea yoii nokon poi riki, iki iti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Jaskáakin yoia pekáo, Abimelecnin Abraham jawen awin Sara menia iki. Jainxonribi menia iki ovejabo, wakabo, ja kikinhakin yanka yonotibo benbobo itan ainbobo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Jainxon neskáakin yoia iki: —Oinwe, natora nokon mai iki; jaweranoki min keenshaman iki, katotax jainshaman jawé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Jatian ja Sara neskáakin yoia iki: —Westíora waranka koríki min poi en meniara, ja mibé ikabo bebon jan mia jakon ninkakaamati kopí en menia iki. Jakopíra, tsonbi mia jakonmaakin yoiti yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Jatian Abrahamman Dios oranketian, Diossen jaton isin benxoaa, Abimelec betan jawen awin jakiribi jakon ikana iki. Jawen yonoti ainboboribi bakeakanon ixon jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Sara kopíra Diossen aká iká iki, Abimelecnin xobonkonia tsoa ainbobi bakeaisma iti imakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Jan axonti yoia keskáakin, Saraakin shinanxon, Diossen ja axonti yoia senenhaxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Jakopíra Sara tóota iki, jaskáaxon aká iki Abraham betan benbo bakeakin, kikin yosishoko ikenbi. Ja bakera, Diossen jatian iti yoiatian pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahamman Sara betan bakeaxon, janea iki Isaac, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ja pikota posaka neteya iketianra, jawen jakina rebichi xatexona iki; jaskáati Diossen yoia iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ja Isaac pikónontianra, Abraham pacha baritiaya iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Jatian Saran shinanna iki: “Diossenra ea osánmaa iki, jatian jatíbi jan ea benbo bakeya onanabaonra, ebetan osánkanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Tsonmeín akeana iki yoikin, Abraham betan en benbo bakeati? Jaskara yosi ikenbira, en jabé benbo bakeake”, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ja bake Isaac, aniketian xoma akin jenemakana iki. Ja xoma jenemai netera, Abrahamman ani fiestaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ikaxbi Saran oinna iki, Abrahamman Egipcio ainbaon Agar betan aká bake, Isaacki jakonmai shiroaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Jaskataitian kaxon, Abraham yoia iki: “¡Ja yanka yonoti ainbora, jawen bake betanbi wetsanko moa kati jake! Nokon bake Isaacninra, jawekeskáaxonbi jatíbitian jawena iti min meniti jawékibo, ja yanka yonotinin bake jatíribi meniti yamake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Jaskáakin yoiara, Abraham ikonbiresi onisa iki, jawen bakeribi ikenbi já yoii ikaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ikaxbi, Diossen neskáakin yoia iki: “Ja min bake, itan ja min yanka yonoti ainbo kopí masá shinanyamawe. Jatíbi mia Saran yokatabo axonwe, Isaac meranoaxa min chiní bakebo jati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ja min yanka yonoti ainbaon bakenkoniaxa, ani jema pikóti jake, jaribi min bake iketianra en jaskara imati iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wetsa nete xabata yamékirishoko iketian, Abrahamman piti betan bichi chomo onpaxya Agar menia iki; jainxon jatíbi papimaxon jawen bake Ismael menixon jainoa raana iki. Jain kaai onanyamaaxbi kaax, Agar tsoa jonibi jain jamaa Beerseba mananman kakáresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ja bichi chomon iká onpax keyóketian, jawen bake jiwishoko nia naman potabaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Jatian kaax ochochaa yakata iki, jawen bake mawatai oinkashamai. Jain kaax yakáketian bake wini peokoota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ja bake winiaitianra, Diossen ninkata iki; jaskatai ninkáxon naikanxonbi Diossen ángelnin, Agar kenaxon yoia iki: “¿Jaweki mia winota Agar? Rakéyamawe; ja ikainoaxbi bake winiaitianra, Diossen ninkáke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kamentanwe min bake benai, bixon metsonxon jeneyamatanwe, jaonxonra en ani jema pikoti jake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Jatian Diossen amaa westíora pozo meraa iki. Meraax kaxon, bichi chomon onpax bochoaa iki, jainxon Ismael xeamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Diossen akinnara bake aniax, jain jawebi xoxoyamai Parán mananman jaa iki, jain ikax kikin pian mecha baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Jain iikin jawen titan, Ismael Egipcio ainbo betan wanomaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ja inontiantanishamanribi, Abimelec, Abraham betan yoyo iki kaa iki. Ja kaaitian, sontárobaon koshi Ficol jabé kaa iki. Jatian Abimelecnin Abraham yoia iki: —Non oinnara, jatíbi min akaibo Diossen mia akinnai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jaskara iketian, nato noa ikainxonbi, Diossenbira onanke en mia axonai ixon ea yoiwe; min noa ramiayamai eabi, nokon bakebobi, jainoax nokon chiní bakebobi. Ea yoiwe, mia noibaxon en aká keskaribiakin min ea ati, jainxon min jaskáaribati iki, nato jain ea iká mainmea jonibo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","—Ikonrake, Diossenbira onanke ja en mia axonai —akin Abrahamman aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Jaskáaxonbi, jawen jonibaon pozo bichina iketian, Abrahamman ja yoikin Abimelec aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Jatianra Abimelecnin, yoia iki: —Rama kamanbira, ja jawéki en onanyamake, minkayara ea yoiayamaa iki. Enra onanyamake, tson jaskara akára ibirai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Jatian, Abrahamman bia iki ovejabo, itan wakabo, jaskáaxon jabo Abimelec menia iki; jatian ja netenribi, ja ati shinanbo abékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ixonbi Abrahamman, ja tsamatainoa kanchis oveja bixon, janbiribi aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ja aketian Abimelecnin yokata iki: —¿Jaweati kanchis oveja min janbiribi akárin? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Jatian Abrahamman yoia iki: —Nato kanchis oveja en mia meniai riki, nato pozo en aká onanti inon ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Jaskara kopí, ja mai janekana iká iki Beerseba, Diossenbira onanke non shinanai, nonra senenhati jake iki jainoax rabekaxbi ikana iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ja Beersebainxon ja ati joibo yoikin senenhayontaanan, Abimelec betan Ficol moa jakiribi filisteobaon main kabékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ja Beerseba ikainkora aká iki, Abrahamman westíora jiwi tamarisco banakin, jaskáaxon aká iki janetaanan jatíbitian jaa Ibo Dios rabikin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Jaskatax, filisteobaon main Abraham basibires jaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Jain moa jawetio basi iketian, akonkin ikonhai onannoxon, Abraham Diossen tanaa iki. Jawen janen kenaketian, jan aká iki: —Eara neno iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Jaskáketian Diossen yoia iki: —Ja Isaac, min jabicho bake, min ayorakin noia, biax Moriah main katanwe. Jain nokóxon, retexon keyokin menotanwe, jainxon min ati mananra en mia yoiti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Jatianra wetsa nete xabata yamékirishoko iketian, wenixon Abrahamman jain karo ati jawen asno pekaten aká iki. Jan menoti karo xateax, ja Diossen kati yoiainko kakin, jawen bake Isaac betan jawen yonoti rabé ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Jawen kimisha nete itin, Abrahamman jain kaai manan, ochóxonbi oinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Jatian jawen yonotibo yoia iki: —Nenobi asno betan banékanwe. Nato bake betan, orichaa kaxon non Dios rabibatanon, jainoaxa noa joribai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Jan yoina menoti karo bixon, Abrahamman Isaac iamaxon, chichika betan chii biax moa kabékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ja basikainainshoko Isaacnin Abraham aká iki: —¡Papá! —akin. Jatianra Abrahamman aká iki: —¿Jaweki mia keenai baké? —akin. Jatian Isaacnin aká iki: —Oinwe, noa riki karo betan chiiya, ikaxbi ¿Ja retexon keyokin menoti carneroki, jawerano iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","—Baké, Diossenra noa meniti iki carnero, ja retexon keyokin menoti —akin jawen papan aká iki. Jaskataxa, ja rabébi kakaresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Jatian jain kati Diossen yoiainko moa nokóxonra, Abrahamman makan tsamanxon, jaki karo tsamana iki; jaskáa pekáo jawen bake Isaac nexaxon, ja karo tsamanaton perakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ikaxbi, Dios axonkin menonoxon, jawen bake reteti chichika biatianbi, ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","naikanxonbi Ibon ángelnin kenaa iki: —¡Abraham! ¡Abraham! —akin. Neno riki ea, iki iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Jatian ángelnin yoia iki: —Jawe jakonmabi ja bake ayamawe, moara en onanke mia Dioski raketai, jabicho min bake ikenbira, enra mia meniamai iki mia iamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Já patax, oinhaketankin Abrahamman meraa iki, westíora carnero, jiwi metax ikain jawen machaman wexeta. Jatian kaxon carnero bia iki, jaskáaxonra aká iki, jawen baken toan retexon keyokin menoxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ja aká pekáo, Abrahamman ja ikainko janea iki: “Ibo riki noa jan maxkata meniai”, akin. Jakopíra, ramatian kamanbi ja yoii ikanai: “Jainxon, Ibon maxkatabo meniai manan”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Jawen rabé itin naikanxonbi, Ibon ángelnin Abraham kenaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Jaskaxon yoia iki: —Ibonra neskara yoike: ‘Jabicho min bake ikenbi, enra mia meniamai iki mia iamaa iketianra, nokon janenkobi en mia yoiai, ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","enra mia jakon shinanxonai, jakon mia inon ixon. Min chiní bakebora en imanoxiki, naikanmea wishtinbo keská icha, itan aniparo kexakea mashi keska iorai icha. Jainxonra jabaon anoxiki jaton rawibo jatíbitian jatoareskin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Jatian jabo kopíra, nato netemea jatíbi maibotiibi jakon jakanti iki, ja en yoia ea ninkáxonax mia yoiti iká kopí’ —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Jainoax, Abraham jakiribi joá iki, jain jawen yonotibo banéwanainko. Jaskata pekáo, jainoax jatikaxbi Beersebanko bekana iki; jain jaaira Abraham baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Jawetio basi iká pekáo, Abraham yoikana iki, jawen wetsa Nacorninribi Milcaki bakeaabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Japari pikota iká iki, Uz; japekáo pikota jawen wetsa iká iki, Buz; jainoax iká iki, Quemuel, jara Aramman papa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Japekáo pikotabo iki, Quesed, Hazo, Pildas, Jidlaf jainoax Betuel. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ja Betuelra, Rebecanin papa iká iki. Ja posaka bakebora iká iki, Abrahamman wetsa Nacornin, Milcaki bakeaabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Jainoaxribi, Nacornin ja jawen awin keskati ikai Reúma betan bakeaabo jaribaa iki. Jabo iká iki, Teba, Gaham, Tahas jainoax Maaca. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarara jaa iki, pacha rabé chonka kanchis baritia. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Jainoax mawata iki Quiriat-arbainoax, jaribi iki Hebrón jema, Canaán main iká. Sara mawáketianra Abraham winia iki, jainoaxibi meketa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sara mawata yora rakatainoax kaxon jainoa hititabo yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Mato xaran ea wetsankonia ikenbi, jain nokon awin minti ea mai kini maromakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Jatian hititabaon yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—¡Noaparikaya ninkáwe ibó! Miara noo xaran, Diossen katota joni iki. Min awin miinwe, non jain mawá miinti kini jakonshaman ikainko, jaskara iketianra tsonbi, mia mai kini washiamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Jatian Abraham wenitax, hititabo jakon iketian, jato bebon beókaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Jainxon jato yoia iki: —Nokon awin en neno miintinin ikoni keenkin, ja Zoharnin bake Efrónpari ea yokáxonkanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Macpelá manan kini ea maromanon, ja iki jawen mai senenain iká. Ja manan kinin kopítiira keyokin en kopíati iki, jaskataxa neno jain mawá miinti mai kini ibo ea iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Jatian Efrón jato betan jain ixon, jawen kaibobaon itan jatíbi ja jeman jikiaibaonribi ninkánon ixon, Abraham yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—¡Jaskarama riki, nokon ibó, eapari ninkáwe! Ja maira en mia meniresai, jainoax ja main iká manan kiniribira en mia meniresai. Nokon kaibobo riki, en mia meniresai jabaon onanna. Awé min awin jain miinkin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Jaskáketianra, Abraham jainoa jonibo jakon iketian, jakiribi jato bebon beókaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Jaskáxon jatíbi bebonxon Efrón yoia iki: —¡Eapari, ninkáxonwe! Mai kopipari ea koríki bixonwe, jatianparira nokon awin en miinti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Jatian Efrónman yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Ea ninkáwe, nokon ibó: Nato main kopíra, chosko pacha koríki iki. Jawen kopí jatí iketianra, non yoiboti yamake, jaskara iketian min awin miintanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamra jen ika iki, ja hititabo bebonxon jawen mai kopi jatí kopíati Efrónman yoia, jaskákinra ja yoiatishaman, koríkinin kopía iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Jaskataxa, Abraham Macpelain iká Efrónman mai maronike, ja iká iki, Mamré ikainoax bari pikotaiori, jaskara ikaxa, ja main iká manan kiniabi jatíbi jiwibo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahammana iká iki. Jaskara ikara, hititabo betan ja jatíbi jema xepótiain winotaibaon onanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Jaskara aká pekáora, Abrahamman ja Macpelá mainmea manan kininko Sara miinna iki. Ja iká iki, Mamré ikainoax bari pikotaiori iká, jawen janeribi Hebrón, Canaánhain iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Jaskataxa mai ibo baneta iki, itan jain iká manan kiniribi, ja iká iki jain mawá miinti hititabaon maromaa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamra moa iorai yosi iká iki, jatianra Diossen jatíbinin jakonhakin shinanxon akinna, jakon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wetsa netenra, westíora jawen yonoti jatíbi jato xewina yosi kenaa iki, ja iká iki jatíbi jawen jawéki jakonhakin koiranxonti imaa, jara neskáakin yoia iki: —Nokon kishi naman min meken niawe, ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","jaskáaxon ea yoiwe non Ibo bebonxon, ja naikanmea Dios iketian, minki ati iki nokon bake Isaac, nato jain ea jaa Canaán mainkonia ainbo betan wanonaketian oinxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Miaki kati iki nokon mainko, ja nokon rareboibakea ainbobo xaranmea, nokon baken awin iti katóxoni —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ja yonotinin neskáakin yoia iki: —Ikaxbi ja ainbo ebetan jokashamaitianki, ¿En jawe ati iki? ¿Enki, jainoax mia joní mainko, min bake boti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Jatian Abrahamman yoia iki: —¡Boama, jain nokon bake boyamawe! ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ja naikanmea Ibo Diossenra, ea pikoa iki nokon papan xobonkonia, jainoax nokon rarebobaon mainmea, jainxonra nato mai nokon chiní bakebo meniti ea yoia iki. Jainoaxibira, nokon baken awin iti jainoa min benon ixon jawen ángel mii bebon raanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ikaxbi ja ainbo mibé jokáshamaitianra, moa mia xabakaake ja min ati senenhax, ixonbi ¡Jawekeskáaxonbi, nokon bake jain boyamawe! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Jatian ja yonotinin, jawen ibo Abrahamman kishi naman jawen meken aká iki, jaskáaxon Diossenbira onanke, min yokata en mia axonti, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Jaskáa pekáo jawen ibo jayata jawékibo ikainoa ja meniti, jaweti jawéki jakonshamanbo katota iki, jawen chonka camello biax, Mesopotamiain iká Nacornin jeman kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ja yonoti jema ochóma nokóketian, moa yametai iká iki. Jatianra iká iki, ainbobo onpax bii bokanai. Ja yonotininra, pozo patax jawen camellobo tantimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Jatian orankin peoa iki: “Nokon ibo Abrahamman Ibo Dios, ea jakon kamawe jainxon nokon ibo min noibaa ea oinmaxonwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nenobira ea banetai pozo pataxbi, onpax bii xontakobo bekanai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Min yonoti Isaacnin awin iti, min katota en onannon ixon ja en onpax yokata xontakonin: ‘Awé xeakin ixon jawen chomomea ea amanon’, ‘jainxon min camelloboribi en onpax menibanon akin ea anon’. Jaskaketianra, en akonkin onanti iki, min nokon ibo noibaa”, akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ja orankin senenhamapari ixonbi, westíora xontako chomo teyakaya joai oinna iki. Ja iká iki Rebeca, Betuelnin bake; ja Betuel iká iki, Milca betan Nacornin bake, Abrahamman wetsa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebecara iká iki, iorai metsáshoko itan yoranamapari; tsoa joni betanbi ikámapari. Pozo ikainko ipakexon, jawen chomon onpax bochoataanan karíbaitian, ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ja yonoti ishto kaxon nokoxon, jainoa yoia iki: —Min chomomeapari, ichátama onpax ea xeamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Jatianra ja xontakonin aká iki: —Xeawe joní —akin. Jaskátaanan jawen chomo namaanxon yatanxon xeamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ja yonotinin xeakin senenhaketian, Rebecanin yoia iki: —Min camelloboribi en onpax weaxonbanon, abákanon jaton keena keskáakin xeakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ichai ishtoshaman pozonko katan katankin, ishtonbires jawen chomomea onpax ja yoinabo xeamatinko nachita iki, jatíbi camellobaon xeakin senenhai kaman onpax weaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ja akai kaman, ja yonotinin jawebi yoiamakin oinna iki. Onankasa iki, jain kaketian jakonhakin Diossen akinna. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Camellobaon xeakin senenhaketian, ja jonin bia iki westíora oro meosoti jawen iwe sokota gramos, jainxon ja xontako jawen rekinhain sawemaa iki. Jainxonribi menia iki, rabé oro menexeti, jawen iwe pacha gramos iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Jatian ja xontako neskáa iki: —Eapari yoiwe, miaki tson bake ainbo iki, nato yamé nokon jonibo betan ea jain oxatiki min papan xobon jati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Jatian xontakonin yoia iki: —Ea riki, Betuelnin bake ainbo; ja iki Milca betan Nacornin bake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nokon xobonra, mia jain oxati jake, jainoaxa xobi choshiboribi maxkáyamake min camellobaon piti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Jaskáaketian ja yonotinin chirankooxon, Dios rabia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ja akira neskata iki: “Nokon ibo Abrahamman Ibo Dios jakonshaman ibanon, nokon ibo noibakinra senenhaxonke, jaskákinra bain joaitian jawen rarebobaon xobonko pontékirani joáx nokótiakin ea akinke”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Jatianra jatíbi jaskara winotabo yoii Rebeca, jawen titan xobonko ishtoi kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Jara westíora poiya iká iki, jawen jane Labán jara pozonko ishtoa iki, ja joni benai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Meosoti betan menexeti jawen poin saweara moa oinna iká iki, jainxonribi jaskáakinbo ja jonin yoiabo yoiaitian ninkata iká iki, jatianra Abrahamman yonoti jawen camellobo betan pozo ikainpari iketian, Labánman kaxon nokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Jatian yoia iki: —Jowé miara Ibon jakon joni iki. ¡Jawekeskataxbira, mia neno jemanbi baneti yamake, jain mia itira en moa xobo benxoaa iki, jainoax ja camellobo jain itiribira en moa benxoaa iki! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Jatian jaskáara ja yonoti, jawen xobon kaa iki. Jainxonra, Labánman camellonimea jawéki manhaxona iki, jaskáaxonra jato pimaa iki, jainxonra onpax bea iki, ja yonoti itan jabé beábaon tae chokanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ja piti menikanara, Abrahamman yonoti neskata iki: —Ja en yoikasai yoiamapari ixonra, en piti atipanyamake —iki. —Noa yoiwe —akin Labánman aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Jatianra ja yonotinin neskáakin yoia iki: —Eara Abrahamman yonoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Diossenra, ichabires nokon ibo jakonhakin shinanxona iki, jaskáaxonra icha jawékia imaa iki: Jara menia iki, carnerobo, wakabo, oro itan koríki, yonoti benbobo, yonoti ainbobo, camellobo itan asnobo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Jainxonribira, jawen awin Sara, moa iorai yoxanshoko ikenbi westíora benbo bakeamake, jainxonra nokon ibon, jatíbi jawen jawéki, jawen bake moa iboamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Diossenbira onanke iki itaanan, nokon ibon ea neskáakin yoia iki: ‘Nato ea jain jaa, Canaán mainmea ainbo betanra, jawekeskáaxonbi nokon bake min wanomatima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Jakonra iti iki, nokon papan rareboboibakea min ointi, jainoara nokon kaibo ainbobo xaranmea, jawen awin iti min benati iki’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Jatian, en yoia iki: ‘Nokon ibo Abraham, ¿Jatianki jawekeska iti iki, ja ainbo ebé jokashamaitian?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Jatian jan ea neskáakin yoia iki: ‘Dios keenai akí ea jaa iketianra, jan jawen ángel ranti iki miibetan kanon ixon, jatianra mia jakon kati iki, jainxon min beti iki nokon rarebo ainbobo xaranmea, nokon baken awin iti, jara iti iki, nokon papan rareboibakea. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ja xontako nokon rarebobaon mibé jonon ixon mia menikashamaketianpariresa, min ea axonti yoia akáx, mia xabakata iti iki, akin ea aká iki’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jaskatax rama ea pozonko nokota iki, jatianra jainxon oración meran en Dios yoike, nokon ibo Abrahamman Dios: ‘Ea jakon kanon ixon, min ea akonkin jakonhati iketianra, ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","nato pozo pataxon en mia yokatai, neskara inon ixon: Ja onpax bii joai xontako, joketian en neskáakin yoiti iki: Eapari, min chomomea ichátama onpax xeamawe akin, ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","jatian jan ea neskáati iki: Awé xeakin, min camellobaonribi anon ixon en onpax weabanon, akin ea akai ainbo ibanon, mia Diossen nokon ibo Abrahamman bakena iti min katota’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nato neskáakin en oranai senenhamabi, Rebeca, jawen chomo teyakaya joai en oinwanke. Onpax bii pozonko ipakeaitian, en yoiwanke: ‘Eapari min onpax meniwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","En jaskáatianbira, jawen chomo namanxon ea yoiwanke: ‘Xeawe akin, jainxon ea awanke min camellobo en xeamabanon akin’. Jaskáaxonra awanke ea jan onpax xeamakin, jainxon nokon camelloboribi amawanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Jaskáa pekáo en yokáwanke: ‘¿Miaki, tson bake ainbo iki?’, akin. Jatian ea yoiwanke: ‘Eara, Betuelnin bake ainbo iki, ja Nacor betan Milcanin bake’, akin. Jatianra meosoti, jawen rekinhain en axonwanke, jainxon rabé menexetiribi en sawemawanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Jainoax ea chirankoota iki, jaskáxonra en Ibo rabia iki; nokon ibo Abrahamman Ibora en jakonman rabiai, ja ponté bain ea beketian, nokon ibon rarebaon bake ainbo, jawen bake en bixonon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ramapari ea yoikanta, matoki nokon ibo betan jakon itan ikon ikai ixon, ikaxbi iamakinribi ea yoikanwe, jaskáaxonra ja ati en onanti iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Jatian Labán betan Betuelnin yoia iki: —Nato jatíbira Ibon aká ike, jakopíra mia non yoiti atipanyamake, jaskara riki ixon, iamax jaskarama riki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Oinwe, nato riki Rebeca; bixon iotanwe. Ibátanon min ibon baken awin, Ibon jaskara iti shinanxona iketian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Jatianra jaskáakin akana ja joibo ninkatax, Abrahamman yonoti Dios bebon chirankootax maikibi bekepia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Jaskata pekáora, oro betan koríki aká jaweti jawéki jokonhaa iki, itan chopaboribi, jaskáaxonra Rebeca menia iki. Jawen poi betan jawen titaribira, jawékibo meniresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Jaskáa pekáopari, já itan jabé beábaon pixon xeakana iki, jainoaxa jain oxakana iki. Ja nete xabáketian weníxon, ja yonotinin yoia iki: —Nokon ibon xobon, moa ea jakiribi rankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Jaskáakenbira, jawen poi betan jawen titan yoia iki: —Chonka neteparira, nato xontako noobetan banétai, japekáoparira mii betan kati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ikaxbi, ja yonotinin jato neskáakin yoia iki: —Kati ikenbi, ea chiteyamakanwe. Diossen imaara, ea joá jakon pikóke. Jaskara iketian, nokon ibon xobon ea jakiribi raankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Jaskáketian jabaon yoia iki: —Non xontako kenabanon, janki jawe yoiai non ninkanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeca kenaxon yokákana iki: —¿Nato joni betan katinki mia keenai? —akin. Jenjen eara kaai akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Jatian moa Rebeca, raankana iki jatíbitian jan koirana ainbo betan, jainoax ja Abrahamman yonoti beabo betan. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Jatian jakonhakin shinanxonkin, Rebeca neskáakin yoikana iki: “Mia non poi ikax ¡Ikonbires icha jonibaon tita itanwe! ¡Abákanon min chiní bakebaon, jaton rawíbaon jemabo bixon iboakin!” akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Jatian Rebeca betan jawen yonoti ainbo camellonin peyakataanan, Abrahamman yonoti chibani bokana iki. Jaskatax, ja yonoti Rebeca bitaanan moa jainoax kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Jatian Isaac iká iki, “jara jake itan eara oinnai”, ika pozonkoniax joá, ja Néguev mainko jaa ikáx. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ja yaménox yantanaitian chankati kaa iki. Jainxonra camellobo jakiriti joái oinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca janribi Isaac oinnax, camellonimeax pakéxon, ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ja yonoti yokata iki: —¿Ja wainkoniax oa noki joái joniki tsoa iki? —akin. —Nokon ibo Isaac riki —akin aká iki. Jatianra, jawen rakóti bitaanan bepota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ja yonotinin, jatíbi jan akábo Isaac yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Jatian jaskáa pekáo, Isaacnin ja Rebeca jawen titan carpa xobonko boá iki, jainoax já betan wanoa iki. Isaacninra, akonbireskin Rebeca noia iki, jaskataxa jawen tita mawataton onís tantia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamra wetsa awinya iká iki, jawen jane Cetura. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Jabé aká jawen benbo bakebo iká iki Zimram, Jocsán, Medán, Madián, Isbac jainoax Súa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Seba betan Dedánman papara Jocsán iká iki. Ja Dedánman chiní bakebo iká iki Asureobo, Letuseobo, jainoax Leumeobo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ja Madiánman bakebora iká iki Efa, Efer, Hanoc, Abida, jainoax Elda. Jatíbi jabora iká iki, Ceturanin chiní bakebo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamman jatíbi jawékira, Isaacnin bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Jawen wetsa awinbaon bakebora, jaweti jawékires Abrahamman jato meniresa iki, jatian japaria inontianra, jawen bake Isaac betan imayamakin bari pikotaiori iká mainko jato raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Pacha kanchis chonka pichika baritia senenresa, Abraham jaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","jainoaxa iti keskatibi yosishoko ikax, mawata iki. Jaskataxa jawen anibo betan iki kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Jawen bakebaon, Isaac betan Ismaelnin, Macpelain iká manan kininko miinkana iki, ja iki Mamré bari pikotaiori iká, ja hitita Zoharnin bake Efrónman mainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ja maira hititabaona Abraham maroa iká iki. Jain jawen awin Sara pataxa, Abraham miinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mawata pekáora, Diossen Isaac jakonhakin shinanxona iki, ja Isaac iká iki, “jara jake itan eara oinnai”, ika pozo patax jaai baneta. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Natobo riki Ismaelnin bakebo, Abraham betan Agarnin bake, Saran yanka yonoti egipcia ainbaona. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Jaskati pikókanara, iká iki neskara: Jawen reken benbo bake iká iki Nebaiot, japekáo ikara iká iki Cedar, Adbeel, Mibsam, ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis jainoax Cedema. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Natobora Ismaelnin chonka rabé bakebaon jane iki, jatianra jaton maibo, itan jaton xobobo iká iki jaton janenbi onantiakin janekanabo. Jaton jonibaon koshibora, jatobi ikana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Pacha kimisha chonka kanchis baritiaya ikaxsha Ismael mawata iki, jaskatax jawen anibo betan iki kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Jawen chiní bakebora, Havila betan Sur naxaran iká mainko jakana iki, Egipto bekeiba, Asirianko katiori. Jawen wesabaon imakashamakin, bechitekanabira jain jakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nato riki, Abrahamman bake Isaac yoii iká joi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Rebeca betan wanonontianra, Isaac chosko chonka baritiaya iká iki, ja iká iki Betuelnin bake ainbo jainoax Labánman poi, jabo iká iki arameobo Padan-aram-hain jaabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebecaninra bakeati atipanyamaa iki, jaskara iketianra Isaacnin já kopi Dios yokata iki. Jatianra ja yokata Diossen ninkáxona iki, jaskatax Rebeca moa toota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ikaxbi ja rabébaon bakebo, poko meranoaxbi meekananaitian, jan shinanna iki: “Nato jaskábi iti iketianki, ¿Jawekopi, ea jakasi iti iki?” ixon. Jatianra, jaskatai onankaskin Ibo yokati kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jatianra, jan yoia iki: “Ja min poko meranra, rabé tsamá joni iki, rabé jema riki pikotamatianbi reteananbekonai. Westíorara wetsa xewina koshi iti iki, jainoax ja rekenra jawen chiní naman iti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ja iti nete senenketian Rebeca bakena, rabébaon iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ja reken pikotara jawen rani joshin iká iki, jatiobi ranin rapoa, jatian Esaú akin janekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Japekáora jawen wetsa pikota iki, Esaúkan tae chipon westíora mekenman yatana, jaskata kopíra Jacob akin janekana iki. Rebeca rabébaon bakenontianra, Isaac sokota chonka baritiaya iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ja bakebora ania iki. Esaúra nii meran niti onan joni pikota iki, jaskara ikaxa iorai yoinanin mecha iká iki; ikaxbi Jacobiribira iiosma joni iká iki, jaskara ikaxa xobonbi banétinin keen iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esaúra, Isaacnin keenshaman iká iki, jan yomeraa piti jawen keen iketian, ikaxbi Jacobiribi Rebecanin keen iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wetsa nete Jacob yoá aki iitaitian, Esaú iorai paxkina kachiokeax joxon, ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","neskáakin yoia iki: —Eapari ichátama, ja min yoá aka piti joshin meniwe eara pitin reteai —akin. (Jaskara iketianra, Esaú Edomribi iki.) ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","—En mia meninon eapari, ja min reken bake ixon bitibo ea meniwe —akin Jacobnin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Jatian Esaúkan yoia iki: —Min oinke ea pitin reteai, jaskara iketianra ja reken bake ixon bitibo jawebi ea akinyamai ikax, nokona jawemabi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","—Diossenbira onanke, en mia meniai akin ramabi ea awé —iki yoyo imakaskinra Jacobnin teaa iki. Jaskáara Esaúkan, Diossenra onanke en mia meniai, akin aká iki. Jaskáaxon ja reken bake ixon bitibo, Jacob menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jaskáaketianra Jacobnin, wetsa piti betan poroto noe akin yoá aka Esaú menia iki. Jatianra pixon xeakin senenhataanan, weníkaini Esaú kaa iki, ja reken bake ixon jan bitibo manókenbi jawemabi keskáakin shinanbaini. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Jaskarabo inontianra, ja Isaac iká main yoábo yamaketian, jawékiatinin ikana iki; ja Abraham mawatamatian iní keskáribii. Jakopíra, jain iamai Gerar janeya main Isaac kanike; jain filisteobaon apo Abimelec ikainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jain kaax Isaac iitaitian, Ibon yoia iki: “Egipto mainko jaai kayamawe; enra mia yoiti jake, jain kaax mia jati. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nato mainbipari iakewe, wetsanko boanhatanresai jonibo ikai keskati iamawe. Ikaxbi enra mibébi ixon, mia jakonbires imati iki. Mibébira ja min chiní bakebo, nato mai en meniti jake. Jaskáaxonra en senenhatiki, ja moatianbi min papa Abraham jaskáati en yoini joibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Jaskáaxonra, min chiní bakebo en akonbireskin kaimatiki; naikanmea wishtintiibires ikantiakin. Ja min bakebora, nato mai en jato meniti jake. Jainoax mia kopíribira, jatíbiainoa meskó jonibobi, en jakonbires jato imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ja Abrahamra, en yoia joibo ea ninkáxonai iká iki. Jaskara ixonra, jatíbi en yoia joibo itan jatíbi nokon esébo ea jan senenhaxona iki”, akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Jaskati ja Gerarhain kaax, Isaac jainbipari jaai iakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Jain iakeketian ja Gerarhainoa jonibaon, jawen awinrin Rebeca ixon, yokákana iki. Jaskáakin Isaac yokákanabi, retekanaketian raketi paranakin, jato neskáa iki: Nokon awinma riki, nokon poi riki, akin. Jatora jaskáakin yoia iki, ja jawen awin Rebeca kikinbires metsáshoko ainbo iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Jain kaxon jato jaskáakin yoiibataxbi, moa icha nete jain iketian, ja filisteobaon apo Abimelecnin jawen xobo ventananin bepikooxon oinna iká iki, ja Isaac nokon poi riki ja Rebeca iki iibataxbi, ikoananshaman noibai iiti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Jaskatai oinxon ja Abimelecnin Isaac kenaa iki. Kenaxon yoia iki neskáakin: —Ja ainbora min poima iki, min awin riki. ¿Jaskara ikenbikayaki, nokon poi riki, iki mia iibata? —aka iki. Jatian Isaacnin yoia iki neskáakin: —Eara jaskáibake, ja ainbo kopí ea retekanti jisá iketian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Jaskataitian Abimelecnin yoia iki: —¿Jaweati min noa jaskáakin paranarin? Shokochaa iwanaxa, nenoa jonibo ja min awin betan oxakeankanke. Jatianra jaskati ochaaton, jatíbi noabo ramíkeanke —aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Jaskáaxon ja jeman jaa jatíbi jonibo Abimelecnin kenamaxon, jato yoia iki neskáakin: —Jawerato joninki, nato joni iamaxon nato ainbo jawe keskabo akai, jabora en jato retemati jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Jatian moa jain kaax jaxon, ja baritianbi Isaacnin meskó yoábo banaa iki. Ja banaa Diossenbi imaxona kikinbiresakin ixona iki, jainoabaon banaa ikai bebonbires. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Jaskáakin jawen banábaon ixona, kikinbires icha tsekaxon biax marotaanan, icha koríki bia iki; jainoax wetsa icha jawékiboyaribi baneta iki. Jaskati jawékiata ikaxa, jatíbiain jatíbi jawékia ninkakaata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Jaskati ja Isaacnin ovejaboyabi wakabo kaiketian, icha yoinaya baneta iki. Jainoax jawen yonotiboribi kikin icha iká iki. Jatian ja Isaac jaskáyoraitian oinnax, filisteo jonibo moa jaki notsiresi, itan jaki ramiti peokookana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Jaskákinra ja filisteo jonibaon akana iki, ja moatian Abrahamman jawen jonibo pozoamanibo, mai bochoakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ja jaton apo Abimelecninribi, aká iki neskáakin: —Moa nenoax pikotax wetsanko katanwe; miara moa noa xewinbainbires jawékia iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ja apon jaskaa, moa ja mainmeax Isaac pikota iki. Ja pikótaanan kaax, Gerar mainko iká teshanpa ikainko jaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ja Isaac jain kaax jainkora iká iki, ja moatian jawen papa Abrahamman, jawen jonibo jain jato pozoamani. Jaskara ikenbi iká iki, ja filisteo jonibaon ja pozo mai bochoaxon jato xeponankana. Jaskara ikenbi, ja Isaacnin jakiribi jain kaxon, jawen jonibo ja pozo benaakin jato mai nawemaribaa iki. Jaskáaxon jawen papan janeni janenribi, ja pozobo apakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Jatian wetsa neten iká iki, Isaacnin jonibo pozoai iiti. Ja pozoakinra, moa jene jokonai nokokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Jaskara iitainbi, ja Gerarhainoa yoina koiranaibo betan, ja Isaacnin yoina koirannai jonibo, onpaxen paranan iki reteanankana iki. Ja pozo ikainoax jaskákana iketianra, Isaacnin ja pozo janea iki: “Jainoax reteananti pozo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ja pozonkoniax onpaxen paranan iki jaskákana iketian, wetsa pozo aríbakana iki. Ja wetsa pozo akankebi, ja pozon paranan iribakana iki. Jatian ja pozobiribi Isaacnin janea iki, “jainoax join ianananti pozo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Jatian moa jaská jaskáakana, wetsanko kaxon, wetsa pozo aríbaa iki; ikaxbi ja pozo kopi moa reteananyamakana iki. Jakopi, ja pozo janea iki, “jakonbires”, akin. Jaskáataanan ja Isaac iká iki neskati: “Ramara Ibon neno noa jakonbires imake; nato main jaaxa, rama moa bebonbires jawékia noa ikai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Jaskara iiti, moa Isaac wetsa main kaa iki; Beerseba akin akanai main. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Jain kaa yamébi, jaki Ibo pikóxon, ja Isaac yoia iki neskáakin: “Ea riki, ja min papa Abraham ipaonitonin Dios. Já en noini kopíresa, en mia jakonbires jamati iki; jainxon já kopíressibira, min rarebobo en kikinhakin kaimati iki. Jakopi, rakéyamawe; jatíbininra en mia akinti jake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Jaskáketian ja ikainko, Isaacnin makan tsamana iki; Dios rabikin yoina reteanan jan perakanxon Dios menoxonti. Jaskara aká pataxibi, jawen chopa xobo carpa aká iki. Jatian jawen yonotibaonbiribi, jainbi wetsa pozo aríbakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Wetsa netera Isaac betan yoyo iki, Gerarhainoax Abimelec joá iki, já betan raenanai Ahuzat itan Ficol, ja sontárobaon koshi capitán jabé joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Jaskákanketian ja Isaacnin jato aká iki neskáakin: —¿Jaweati ea benaiki mato bekana? Ea matoiba inontian maton ea aká iki, akonbireskin ramiakin. Jainxon ja maton mainmea aká iki, maton ea potakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Jato Isaacnin jaskáara, neskáakana iki: —Nonra oinke Ibora miibetan iki, itan nonra shinanke mia yoiti, ja senenhabekonti joi mibé anoxon. Ja senenhabekonti joira neskara iti iki: ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Jawe jakonmabi min noa atima, jawetianbira mia teakin non sinámaama iki. Jaskáyamakinra jatíbitian mia non jakonha iki, itan jakonhaxonra mia non raana iki, itan ramara jakon itiakin Ibon mia shinanxonai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Jatian jaskáakin yoikana, Isaacnin jato icha pitiabi, icha xeatiribi jato axona, kikinhakin jawékiakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Jatian wetsa nete xabata yamékirishoko, Isaac betan ja apo Abimelec, wenikana iki. Ja wenixon, Dios janetaanan moa ikoni ramiananyamanoxon, shinan abékona iki. Ja jaskara shinan moa abékonxon, ja jaiba beabo moa Isaacnin jato raana iki. Ja raana boí, kikinshaman jakon shinanyares bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ja netenribi, ja pozoai iikanai Isaacnin jonibo bekana iki. Jabo bexon Isaac keshankana iki, ja pozoakin mai chinikin, moa jene nokokana. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Jatian ja pozo Isaacnin janea iki Seba, akin. Jakopíra, rama kamanbi, ja jeman jane iki, Beerseba. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Jaskata iikinra, moa chosko chonka baritiaya ixon, Esaúkan Judit awinhanoxon binike. Ja Judit iká iki, Beerin bake, ja iki heteo joni. Jainxon biribaa iki, Basemat janeya ainbo; ja iká iki Elóman bake, jaribi iká iki, heteo joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ja Esaúkan awin rabera iká iki, jan Isaac betan Rebeca jakonmabires shinanmai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Jaskarabo inontianra, Isaac kikinbires yosishoko iká iki. Jaskara ixonra, moa kikinyorai bekona ixon, jato onanyamaresa iki. Jakopira, wetsa neten aká iki, jawen reken bake Esaú kenakin: —¡Nokon baké! —akin. Jatian jawen bake Esaúkan yoia iki: —Ea yoiwe papá —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ja kenaxon, neskáakin Isaacnin yoia iki: —Oinwe, baké; ea riki moa yosishokoira, basimara ea mawáti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Jakopi, ramapari min kanóti betanbi min pia bitaanan, kachio katanwe, yoina ea retexonti benai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ja yoina reteanan bexonra, min noeshamanhakin ea pitiaxonti jake; ja nokon keena keskáshaman piti. Jaskara pitiaxonra, min ea bexonti jake, en pinon. Ja piá pekáora, ea mawatamatianbi, mia jatíbitian Diossen jakonhanon ixon, ja shinan en mia meniti jake —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Jatian ja Isaacnin, jawen reken bake Esaú jaskáaitian, Rebecan ninkata iki. Ja jaskáaitian ninkáwanxon, moa Esaú yoina retenoxon benai kaa pekáo, ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ja Rebeca kaa iki, jawen bake Jacob keshani. Ja keshankin aká iki neskáakin: —Ninkáwe, baké; enra ninkábeiranke min papan ja min wetsa Esaú neskáakin yoii iitai: ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Yoina retetaanan bexon, piti noeshamanhakin yoá axon, ja piti bexon pimati. Jatian jaskáaketian ronki, janbiribi mawatamabi Ibon jakonhanon ixon, jawen shinan menitiki, ikira iwanke’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Jaskara iketian, ramapari jatíbi en mia ati yoiaibo, ea axonwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ramabira ja yoinabo ikain mia kati jake; jain kaxonra rabé carnero bake jakonshaman min ea bexonti jake. Enra onanke, jawekeska pitishamankayaki min papan keen iki, ixon. En axonbanon, jawen keenshaman pitiaxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Jatian moa en pitiaketianra min boxonti jake, ja piti pinon ixon. Min jaskáaketianra, mawatamatianbi janbiribi mia Diossen Shinan meniti iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ikaxbi Jacobnin jawen tita yoia iki neskáakin: —En jaskáati ikaxbi riki, ja nokon wetsa Esaú jatíbiain kikinbires rani kextó; jatian eabiribi iki ranioma. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Jaskara ikenra, nokon yora tii ataananres nokon papan ea onantiki, tsoarin ea ixon. Jatian ea onantaanan itiki, ja nokon bakera eki shiroi iitai, iki. Jatianra ea jakon shinan menititianbi, ea rami shinanres menitiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Jaskáakin jawen baken yoia, jawen titan aká iki, neskáakin: —Baké, jatíbi en mia ati yoiabo ea axonwe. Ja cabra bake rabé, ea neri bexonwe. Jawetianki mia onantaanan, min papan jakonma shinanres mia meniai, jatian ibanon ja jakonma shinan mia menia eki bei —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jaskáakin jawen titan yoiwana, moa Jacob kaa iki, ja cabra bakebo bii. Jatian bexon moa jawen tita menia iki. Ja boxona, jawen titan kikinbiresakin noeakin, jawen papa Isaac pitiaxona iki; jawen keen keskashamaankin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Jatian ja piti akin moa senenhayontaanan, Rebeca ishton kaa iki, ja Esaúkan jakon chopabo bixoni. Ja Esaúkan chopabo bexon, Jacob sawemaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ja sawemaa pekáo, jawen titan Jacobnin ponyain itan jawen texonko, ja cabra bakebaon bichin rakoa iki; rania keská inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Jatian moa jaskáboakin senenhayontaanan, ja raton iká piti betanbi wetsa pitiribi, Jacob menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jatian Jacob moa jawen papaiba kaa iki; kaxon aká iki neskáakin: —Papá, eara neno iki —akin. Jaskáa Isaacnin yokata iki: —¿Jawerato nokon bakerin mia? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jaskáakin yokata, Jacobnin aká iki: —Ea riki, ja min reken bake Esaú. Enra moa mia axonke, ja axonti min ea yoiwanabo. Weníkirani joxon, ja en mia pitiaxona piiwe; ja aká pekáo min ea jakon shinanxonon —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Jaskáakin yoia, Isaacnin aká iki neskáakin: —¿Jawekeskaaxonki, min ishtonbires yoina retebeirana? —akin. Jaskáa Jacobnin yoia iki: —Min Ibo Diossenbi eki pikómaketianra, en abeiranke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Jatian Isaacnin yoiribia iki: —Baké, ekikiranxon ea pataxiwe, ikonrin mia nokon bake Esaú ixon onannoxon, en mia tii anon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jaskáakin jawen papan yoia, ja Jacob jawen papan tii anon ikax, jakikirana iki. Ja tii ataanan, Isaacnin yoia iki: “Min joira Jacobnin joi iki, ikaxbi min ponyanra, Esaúkan poyan iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jatian jawen papan meeta, Jacobnin poyan jawen wetsa Esaúkan poyan keská ranibiresibi iketian onanyamaa iki. Jaskáakin onanyamaxonbi, Diossen jawen jakon shinanman jakonhanon ixon, Diospari yoixonyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Jakopí, Isaacnin jawen bake Jacob jakiribi yokáribia iki, neskáakin: —¿Miakonrin nokon bake Esaú? —akin. Jaskáa: —Ea riki Esaú —akin Jacobnin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Jaskáa Isaacnin aká iki: —Jaskara iken, ja min ea pitiaxona piti, ea neri bexonwe en pinón. Ja piá pekáoparira, mia Diossen jakonhanon ixon, en mia Dios yoixonti jake —akin aká iki. Jaskáakin jawen papan yoia, Jacobnin ja pitiabi xeati bexona, jawen papan jawékiaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Jatian moa pikin senenhaxon, Isaacnin jawen bake kenaxon yoia iki: —Ramapari ekikiranxon, ea bexetiwe baké —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jaskáti yoia, jawen papakiriti ochómakainxon, Jacobnin jawen papa bexeta iki. Jatian Isaacninbiribi, jawen bake Jacobnin chopa xetexona iki. Ja xetetaanan, Diossen jakonhanon ixon neskáakin Dios yoixona iki: “Baké, mia riki waín teetai ikax, wai itsabires. Mia jaskara ikaxiki, westíora waimea banábo, Diossenbi jakonshamanhakin xoxomaa keskáshaman; ja Diossenbi jaskara iti mia shinanxona ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Jainxon trigoyabi uva jakonshamani xoxonon ixonribi, mia Diossenbi oi bemaxonbanon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Icha jonira, min jato akinoxiki. Wetsa mainmea joniboribira, miibebon chirankoonoxikanai. Min wetsabaon joni koshiribira mia inóxiki. Jatian mia jan jakonmaaibora, jakonmaribi ikanti iki. Ja mia jan jakonhaibora, jakonribi ikanti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Jatian ja Isaacnin moa Jacob jaskáakin senenhayona pikókainaitianribi, jawen papa yoina retexoni katanax, Esaú nokótoshita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ja Esaúkanribira, noeshamanhakin pitiaxon jawen papa bexona iká iki. Ja piti bexon, jawen papa neskáakin yoia iki: —Papá, weníkiranxonpari, min keenshaman yoina reteanan, en mia noeshamanhakin pitiaxona piiwe. Ja piti piá pekáo, ea Diossen jakonhanon ixon, min ea Dios yokáxonon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Jaskáaketian jawen papa Isaacnin, ja Esaú neskáa iki: —¿Miakayaki tsoa iki? —akin. Jaskáa yoia iki: —Ea riki, ja min reken bake Esaú —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Jaskáakin yoia, saki iananbi yoia iki: —¿Jatian tsoakayaki, neno mia joámatian jatíbi pitiya joxon, ea pimabaini moa kaa? Jara Diossen jakonhanon ixon, moa Dios en yoixona kake —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Jawen papan jaskáakin yoia ninkatatianbi, ikonbiresi sinati saí iananbi, Esaú winia iki. Jaskati winiananbi, ja Esaúkan aká iki jawen papa neskáakin: —¡Papá, earibi Diossen jawen jakon shinanman, jakonhanon ixon ea yoixonwe! —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Jaskáakin yoiabi, ja Isaacnin jawen bake Esaú neskáa iki: —Min wetsa joxonra, ea akonbireskin paranke. Jaskáakin ea parana onanyamaxonra, ja mia en meniti yoia Diossen jakon shinan, mia shinankin en moa jares menike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Jatian Esaú iká iki neskati: —Akontibi Jacob, akin maton janea riki. Ja joni riki, janso itan paranmis joni. Janra natoyanix, moa rabéakin ea paranai. Ja reken bake iketian, nokon papan ea meniti yoiabichoma riki, ea jan bichina. Ja rama ea jan bichinribia riki, Diossen jakonhati jawen jakon shinan. ¿Jaskara ikenki, rama min earibi Diossen jakonhanon ixon, ea Dios yoixonti atipanyamaa papá? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Jaskáa Isaacnin, jawen bake Esaú neskáa iki: —¿Baké, ramaki en mia kopi jaweati iki? Ja min wetsara moa en janeke, min joni koshi iti. Jainxon jatíbi jawen kaiboboribira, jan yonoai inóxiki. Jatianra en yoiribike, icha trigoya iti, itan icha uvayaribi iti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Jaskáakin yoiara, Esaú jakiribi ikonbiresi sinati, saí iananbi winikin, Diossen jakonhanon ixon jawen papa yokákin jeneyamai neskata iki: —¿Papá, minkayaki, westiora jawekiaintanibires ea Diossen jakonhanon ixon, ea yoixonti atipanyamaa? —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Jatian jaskáketian, Diossenbi jaskáati shinan menia, jawen papan aká iki, neskáakin: “Miara jaai kati jake, jain banakanabo iamai mainko. Jainoax jawetianbi oi beyamai mainkoribira, mia jaai kati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Reteanantiainxon mia retekanaketianbora, minbix mia koiranmeeti jake. Jainoax min wetsanbi mia yonoti jake. Jatian minbiribi koshionxon moa shinan biketianra, moa tsonbi miaarestima iki”, akin jawen papan aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ja benóxon, jawen papan Jacob Diossen jakon shinan meninontianbira, ja Esaú jawen wetsa Jacobki ramiti peokoota iki. Jainxonribira Esaúkan shinanna iki: “Jawen papa mawata pekáo, jawen wetsa Jacob reteti”. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Jatian jaskarabo Esaúkan shinannaitian onanxon, Rebeca keshankana iki. Ja keshankana, jawen bake Jacob kenaxon yoia iki neskáakin: —Ja min wetsa Esaúra, miki ramíkin mia reteti shinanyares iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Jaskara iketian, rama en mia yoiai nokon joi ea ninkáxonwe. Miara ramabi kati jake, nokon poi Labánman xobonko. Ja Labánra, Haránhin iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Jain kaxa, jawetio basi inonbi mia jaiba iaketi jake; ja min wetsa Esaú sinata tantiai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Jawetianki ja min ayantana jawékinin, min wetsa shinanbenopaketai, jatianra en mia keshanti jake, mia jakiribi neno jonon ixon. Ja netenbicho nokon bake rabé manótininra ea keenyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Jaskátaanan, Isaac keshani Rebeca kaa iki. Kaxon yoia iki neskáakin: —Nato hitita ainbobo neno ikana oinnira, ea moa jatsanke. Jawekeska ixonra, ja hitita ainbobo Jacobnin awinhanoxon bitiki. Ja ainbobo biketianra, en moa jatiakinbobi shinantima iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Jaskáakin Rebecanin yoia, Isaacnin Jacob kenamaa iki. Ja kenama joketian, Diossen jakonhanon ixon yoia pekáo, neskáakin yoia iki: “Jawekeskáaxonbira, cananea ainbobo awinhanoxon min biti yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Jakonkayara iti iki, Padán-aramhin mia kati. Jainra min papashoko Betuel iki; ja iki min titan papa. Jain kaxonra, min koka Labánman bake ainbo awinhanoxon min biti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Jainxon ja koshi shinanya Diossa en mia yoixonai, ichabires bakeya mia imanon ixon. Jainxonra min chiní bakeboribi mia kaimaxona, kikinbiresi kaikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Min chiní bakeboyabi, mia Diossen jakonbires imabanon; ja moatian Abraham aní keskaribiakin. Jaskataxesa, ja jain mato jaresa iitai mai ibo mato iti iki. Ja mai riki, moatianbi Diossen Abraham meninoxon yoini”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Jaskáa pekáora, Isaacnin jawen bake Jacob Padán-aramhin raana iki. Ja jemara iká iki, jawen titan poi Labán jain jaa jema. Ja Labánra, Betuelnin bake iká iki; jabora arameo jonibo iká iki. Jatian ja Rebecabiribira iká iki, Jacob betan Esaúkan tita. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Jatian Esaúkan moa oinna iká iki, jawen papa Isaacnin, ja Jacob Diossen jakonbires imanon ixon, moa Dios yoixona. Jaskáakin senenhaxon, Padán-aramhin raana iki, jain kaax wanonon ixon. Jainxonribi ja Dios yoixona pekáo yoia iká iki, jawekeskáaxonbi Canaán ainbo awinhakin bitima. Jatíbi jawen papan ja Jacob jaskáabo, moa Esaúkan onanna iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jaskáakin jawen anibaon yoia ninkáxoni, Padán-aramhin Jacob kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ikaxbi ja Esaúkanra moa onantanishamana iká iki, ja Canaán ainbo rabé awinhakin bia, jawen papa Isaacnin keenma. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Jaskara iken Esaú kaa iki, Ismaelhiba; jaiba kaxon awinyaribi ixonbi ja Ismaelnin bake Mahalat bia iki. Ja iká iki, Nebaiotnin poi. Jatian Ismaelbiribi iká iki, Abrahamman bake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jaskata iiti, Beersebainoax Jacob kaa iki, Harán akin akanai mainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Jatian moa ochó kaxon oinna iká iki, moa yametai. Jaskara ointaanan, jainpari oxai iakea iki. Jaskati jain iakexon, jainoa makanbo bixon jakonshamanhakin tipinax, janbi tepikaini oxaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Jain oxaxon, namá meran oinna iká iki, naikameaxbi joax maikibi nokota tapiti. Ja tapitinin iká iki, Diossen ángelbo rawinanani maanni; jatíribibo namani bei, jatíribibo bochikii boí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Jatian jaskákanaitianribi, ja tapiti rebetseetainkoniax, Dios iká iki neskati: “Ea riki, Ibo. Ja min papa Abrahamman Dios, jainoax Isaacnin Diossibi. Ja mia jain rakata maira en mia meniai, jainxon ja min chiní bakeboribira en jato meniti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Jatíbi ja miipekaokea min rarebobo kaiaxa, kikínbires icha ikax, mai pototii icha ikanti iki. Jaskataxa bari pikotaio, itan bari jikiaio boaxbo janoxikanai. Jatian jatíribibora, nete senenao itan nete tsisenenaobo boax janoxikanai. Jainoax mia kopi, itan ja min rarebobo kopíra, jatíbi jonibo Diossen jato jakonbires imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Jaskara iketianra, jatíbitian mibé ixon, jawerano inonbi mia kaainko en mia koirantiki. Jainxonra nato main en mia beribanoxiki, jatíbi ja en mia axonti yoiabo en senenhai kaman”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jatian oxá meran jaskáa moa besotaanan rateti, Jacob iká iki neskati: “Nenokayabira Ibo Diossen jati ikenbira en onanyamaa ike”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Jaskátaanan raketi iká iki neskati: “Neno itira, kikinbires onsá iki. Jaskara ikaxa, Diosbiribi neno jaa ikax, jawen xobobiribi iki. Nai xepotiriki neno”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jatian nete xabata yamékirishoko wenixon, Jacobnin bia iki, jan tepikaini oxaibata makan. Ja bixon waketaanan, Diossenabi imakin onanti inon ixon, jaki xeni chikoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Jainribi moatian iká iki, Joé akin janekana jema. Jain ja janeya ikenbi, Jacobninbiribi Betel akin janea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jatian ja jaskáakin janeainoax, Diossen akinketian, janribi Dios jaskáaxonti yoii, Jacob iká iki neskati: “Ja Dios ebé ixon, jain ea kaainkobo koiraananbi ea piti meniketian, itan en saweti chopa ea meniketian, ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","itan jatíbi jakonbires isinama, rakéyamai nokon papan xobonko jakiribi ea banémaketianra, ja Ibo iti iki, nokon Diosbishaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Jainoax nenonxon jaskáani onanti inon ixon, nato makan neno ataanan, en aceite jaki chikoaira ikai, neno riki Diossen xobo iki ixon, ja oinxon onanti. Jainxon jatíbi min ea menia chonka jawékiainoara, en mia westíora meniti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jatian Jacob jainoax tekíkaini, bari pikotaiori iká jonibaon maiori kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Jain kaax nokóxon pozo ochóma oinna iká iki, kimisha tsamá carnero tantii tsamata. Ja pozonkonia onpaxa iká iki, carnerobaon xeai. Jainoax ja pozoribira iká iki, ani makaman mapokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ikaxbi ja pozonkonia onpax iká iki, jaton axébiribi jaskara iketian, jaton yoinabo tsinkiketianpari kepenhanan amakanaires. Jatian moa xeamakin senenhaxon, jakiribi ja ani makaman xepokanai iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jatian Jacobnin aká iki, yoina koiranaibo jain ointaanan, jato neskáakin yokákin: —¿Jonibó, matoki jaweranoa iki? —akin. Jato jaskáa yoikana iki: —Noara Haránhinoa iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jaskáketian jato yokata iki: —¿Matonki Nacornin bake Labán onanna? —akin. Jatian yoikana iki: —Nonra onanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jaskáketian Jacobnin jato yokákin jeneyamaa iki: —¿Isinamarin? —akin. Jato jaskáaketian ja jonibaon yoikana iki: —Jenjen Labánra jakon iki, oinwe onora jawen bake ainbo Raquel jawen carneroboya joai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jaskáakana jato neskáakin Jacobnin yoia iki: —Maton yoinabo weímati ikaxbira, yantánmapari iki. Jaskara iken, ja yoinabo boxonpari onpax xeamataanan, pastoribi pimatankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Jatian yoikana iki: —Nonra jaskáati atipanyamake, jatíbi yoinabo tsinkitamapari iketian. Jatíbi yoinabo tsinkíketiamparira, jan pozo mapoa ani makan oke werantaanan, non onpax xeamati jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jaskati ja jonibo betanpari yoyo iki iitaitian, yoinabo koirannai ikax, jawen papan yoinaboya, Raquel nokótoshita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jatian Jacob yoyo iki iitibi bewakeeinakainxon, ja Raquel jawen papan carnero ichaya joai meraa iki. Ja Raquel iká iki, Labánman bake; ja Labánbiribi iká iki, jawen titan poi. Jaskáakin onantaanan, jatianbi ishto kawanxon jan pozo mapoa makan weranxon, ja pozo kepena iki. Ja kepenhanan, jawen titan poin yoinabo onpax xeamaxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jaskáakin jawen rarebo onanxon, winiananbi, Jacobnin Raquel bexeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jainxon Jacobnin Raquel yoia iki: Ea riki, Rebecanin bake; Labánman piábake, akin. Jaskáakin yoiatianbira, Raquel jawen papa keshani ishto kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Jaskáakin Raquelnin jawen poin bake joá, jawen papa keshana, ja Jacobnin koka Labán ishto joxon, jawen piá onantaanan jowé akin ataanan, jaon rarokin ikóxon bexeta iki. Jaskáaxon, jawen xobon ioa iki. Jain ioa kaxon, jatíbi jaskara ikábo rebéstankin jawen koka yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Jaskáaketian Labánman yoia iki: “Mia riki, kikinshaman nokon ochómakea rarebo ikax, nokon jimibi”, akin. Jaskatax Jacob westíora oxe senenshaman Labánhiba iakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Jatian Labánman Jacob neskáakin yoia iki: —Mia nokon kikin ochómakea rarebo ikaxa, ea teexoni yankabires kopí biimabi mia teeti yamake. Ramapari ea yoiwe, ¿Jawetiishaman en mia kopíatinki, mia keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ikaxbi ja Labán iká iki rabé bake ainboya. Ja rekeman jane iká iki, Lea; ja chinikana iká iki, Raquel. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ja Leara iká iki, oinnatonbobi bemés ikax, metsáshoko. Jatian ja Raquelbiribi iká iki, jawen bemanan jakonshoko ikax, jatíbinin metsáshoko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ja moabi rekenhakin Raquel oinnontianbi jaon keena ikaxa, Jacob iká iki neskati: “Ja min chiní bake Raquel kopíra, kanchis baritia senen en mia teexonti jake”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Jaskáketian Labánman yoia iki: —Ikonrake, wetsabo menititianbi en miakaya menibanon. Jaskara iken, rama nobé neno banéwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jaskáxonra ja Raquel kopí, kanchis baritia senen, Jacobnin Labán teexona iki. Ja Raquelnin keenkin akonbireskin noia kopí, jatí baritia teexon Jacobnin oinnabira iká iki, basimashoko teeta keskáres. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jatian moa jatí baritia teexon, Jacobnin aká iki Labán neskáakin: —Moara en ake senenhakin, jatí baritia en teeti shinanna. Jaskara ikenra, moa min bake awinhatin ea keenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ja Jacobnin jaskáaketian, Labánman aká iki, ja jato ochóma jakana jonibo jato kenaaketanxon, ja wanotiainxon pinoxon, icha pitiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Jatian ja wanoti fiesta moa senenketian, ja yamébi Labánman jawen bake Leares, Jacob bexona iki. Jares bexonabi onanyamaxon bixon, Jacobnin oxakiina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Jaskara iken, ja Labánman jawen yanka yonoti ainbo Zilpá bexona iki, ja jawen bake Lean yonoti inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ja onanyamaxon moa oxakiinshinkin, yamékirishoko Jacobnin oinnabi iká iki, Leares ja jabé oxashinai. Jaskati ja Lea betanres oxashinkin, Jacobnin aká iki, ja Labán neskáakin: —¿Jaweati min ea jaskáarin? ¿Ja min bake Raquel biti kopíkayaki, ea miiba teetama iki? ¿Jaweati min ea paranarin? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Jaskáaketian Labánman aká iki neskáakin: —Nenonxon bake benomakinra, jawetianbi chiní bakepari non imayamai; ja reken bakeparikaya riki non benomai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Jakopí, ja mia wanoapari westíora semanantanibires senenhawe, jatianparira nokon wetsa bake en mia meniti iki. Ikaxbi ja nokon wetsa bake min biai kopíra, nenobi iakeax jakiribi kanchis baritia senen mia eiba teeribiti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jaskáakin yoia jen iketian, moa westíora semana ja wanoibata senenhaketian, Labánman jawen bake Raquel moa Jacob meniribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Jaskáakin moa awinhati jawen bake Jacob menitaanan, Labánman jawen yanka yonoti ainbo, jawen bake Raquel menia iki, jawen yonoti inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jatian ja Raquel moa awinhakin bixon, Jacobnin oxakiina iki. Ja Raquel moa bixonra, Lea aká bebonbires, Jacobnin noia iká iki. Jaskáakin ja Raquel moa Jacobnin biabi, kanchis baritia senenpari, jakiribi ja Raquel kopi Jacob teeti maxkata iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jaskara iketian, Ibon oinna iki, Jacobnin jawen awin Lea, kikinshamanhakin noiamaa. Jaskara ointaanan, Diossenbi Lea bakeya imaa iki. Jatian Raquelbiribi, bakeayosma imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Jaskáakin ja Diossenbi bakeai iti imaa ikax, Lea tootax bakena iki. Ja bake pikóketian janea iki, Rubén akin. Jaskáakin bakeaax, Lea iká iki neskati: “Ibonra en masá shinanai ointaanan ea akinke. Jakopíra, rama nokon benen ea noiti jake”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Jaskata iikin, Lean wetsa bakearibaa iki. Ja wetsa bake pikóketian, Simeón akin janea iki. Jaskatax ja Lea neskati yoyo iribaa iki: “Ea nokon benen noiamai ointaananra, Diossenbi noibakin, nato wetsa bake ea meniribike”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Jatian Lean jakiribi wetsa bakearibaa iki; ja bake janea iki, Leví akin. Ja bakeataanan Lea iríbaa iki neskati: “Rama moa jabé en kimisha bakeaketianra, ja nokon benen ea noiai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Jainxon Lean aríbaa iki, bakeakin. Ja bake pikóketian janea iki Judá, jainoax neskata iki: “Ramara nato baken benekin en Ibo rabiai”, iki. Japekaora moa Lea tooyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Jatian Raquelbiribi tooisma ixon, jawen bene Jacob betan bakeati atipanyamaax, jawen wetsa Leaki notsikin jakonma shinanna iki. Jaskákin jawen bene Jacob yoia iki neskáakin: —Ebekaya bakeawe; mibéshaman bakeayamaaxa, ea moa mawákasai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jaskáakin Raquelnin yoia, Jacob jaki sinata iki; ja sinákin aká iki neskáakin: —Ea min jaskáakin yoiti ikaxbira, ea Diosma iki. ¿Dioskayamarin jaskarabiribi iti mia imaa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Jaskáaketian Raquelnin aká iki neskáakin: —Ja nokon yanka yonoti Bilhá en mia menibanon, jabé ixon min bakeanon. Jatianra jabé min bakeaa pikotabo bixon, nokon bakebi keská en imati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Jaskáaxon Raquelnin jawen yanka yonoti ainbo, jawen benen awinhanon ixon meniketian, jawen bene Jacobnin oxakiina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ja Jacobnin biara, Bilhán Jacob betan bakeaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Jatianra Raquel iká iki: “Nato baken janera Dan iki, Diossenra en yokata ninkáke, westíora bake menixonra jaskara iti keskábiakin ea axonke”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Jaskata iikin, jakiribi ja Raquelnin yonoti ainbo Bilhán, Jacob betan bakearibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ja bake pikóketian, Raquel iká iki neskati: “Nato bake pikotara en janeai, Neftalí akin. Enra ja janen akai, ea bakeayosma ikax, nokon wetsa betan rawikananbekona keská ikax itikomabires iikinbi, Diossen akinnares moa bakea kopí”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Jatian moa Lea tooyamaparikin, Lean jawen yanka yonoti ainbo Zilpá bexon, jawen bene Jacob bimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Jaskáakin jawen yonoti Lean bimaa awinhaxon, Jacobnin jabé bakearibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Jatianra Lea iká iki neskati: “¡En shinanamatianbira, mia kopíres ea bakeya banéke! Jakopíra nato bake en janeai, Gad akin”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Jaskata iikin, ja Lean yonoti ainbo Zilpánin, Jacob betan bakearibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ja bake pikota ointaanan, Lea iká iki neskati: “Nato bake pikotatonra, ea kikinhakin raromake. Ramara ea yoii, jan ea oinna ebé ainbobo ikanti jake, natotianra Lea raroshamanai iki. Jakopíra, ja pikota bake en janeai, Aser akin”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Jatian jaskata iitaitian, trigo tsekatitian Rubén wainko kaa iki. Kaxon, ja kokoax tooti bimi meraa iki; ja bimin jane iká iki, mandrágoras, akin akanai bimi. Ja bimi jawen tita Lea bexonketian oinnax, Raquel iká iki, jawen wetsa Lea akí neskati: —Ja kokoti bimi mandrágoras, min baken mia bexona ea meniwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Jaskáaketian Lean aká iki, Raquel neskáakin: —¿Ja nokon bene min ea bichinakayaki, mina jawemabi iki? Jaskara ikenki, rama ¿Ja nokon baken ea mandrágoras bimi ea bexonaribi min ea bichinkasai? —akin. Jaskáaketian Raquelnin Lea neskáa iki: —Ja min baken mia bexona kokoti mandrágoras bimibo min ea meniketianra, jakopi rama yamé Jacob mibé oxati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jaskáakin yoia iitaitian, wainko katanwanax moa yantan Jacob joaitian bechii, Lea kaa iki. Ja bechibainxon Lean aká iki neskáakin: —Raquelninra ake, nokon baken mandrágoras kokoti bimi ea bexonketian ea bichinkin. Ja bichinxonra ea yoike, ja ea bichina kopí, nato yamé mia ebé oxati —akin. Jaskáakin yoia, ja yamébi Jacob Lea betan oxaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Jatian ja Lean yokatabo, Diossen ninkáxona iki. Jaskáxon jakiribi Jacob betan bakearibaa iki. Jayakax iká iki, moa pichikaakin Lean Jacob betan bakeaa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Jaskatax Lea neskata iki: “Ja nokon yanka yonoti en nokon bene awinhamaa kopíresa, ea Diossen bakeya imaribike. Jakopíra, Isacar akin en janeai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Japekáo, Lean Jacob betan bakearibaa iki. Jayakax iká iki, moa sokotaakin Jacob betan bakeaa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ja bakeaax Lea iká iki, neskati: “Diosbi janbix keentaanan ea menia riki, nato bake. Jaskara iketianra, moa ebé sokota bakeaax, nokon bene ebébi jati iki”, iki. Jatian ja bake janea iki, Zabulón akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Jaskara iikin, Lean bakearibaa iki ainbo bake. Ja bake janea iki, Dina akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Jatian Raquel tooisma ixon, Dios yoká yokataitian, ja yokatabo Diossen ninkáxona ja Raquel tóota iki. Jaskáakinra Diossen tooma iki, jawen bakeyabiribi inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ja jawen bake moa pikóketian, Raquel iká iki neskati: “Ramara bakeayosmanix rabini ea iitai jawéki, moa Diossen keyoxonke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ea wetsa bakeamapainon riki”, iki. Jakopira José akin janea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Jatian Raquel José tóota iiti, moa bakena pekáo, Jacob kaa iki jawen rayós Labánhiba. Ja kaxon yoia iki neskáakin: —Eara keenai, nokon mainko itan ea jain iitibi joníain, min ea raanribitinin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Jainxon nokon awinboyabi, nokon bakebo ea meniwe, jabo kopíra ea miiba teeta iki, jakopí ea nenoa pikómawe. Moara miinbi onanke, jaskáakin en mia teexonabo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Jacobnin jaskáaketian, Labánman yoia iki: —Kayamakayawe, neno eibabikaya iakewe; miara kikinbires jakon ebé iká iki. Enra onanmisbo yokaanan onanna iki, mia neno eiba iká kopí, Ibon jakonbires imaa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Jawetiishaman en mia kopíatiki mia keenai, ea yoireswe; en mia jatí kopíanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ja Labánman jaskáa, Jacobnin aká iki neskáakin: —Minbira moa onanke, jaskáakin min tee en axonabo. Jainxonribira min onanke, en koiranaki min yoinabo jawekeska iká iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ea miiba joámatianra min yoinabo iká iki, ichátamashoko. Ikaxbi rama iki, moa kaiax kikinbires icha. Ea miiba jonontianbira, Ibon miaakin jakon shinanketian, min yoinabo mia kaimaxona iki. Jakopíra ramabiribi, nokon awinboyabi nokon bakebo akinti kopíbiribi ea teekasai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Jaskáa Labánman aká iki: —¿Jawe jawéki en mia menitinkayaki mia keenai? —akin. Jatian Jacobnin yoia iki: —Ea jawebi meniamawe; ikaxbi ja en mia yokata jawékireskaya ea ninkáxonwe. Jatianparira, min yoinabo en jakiribi mia koiranxonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ramara ja min yoinabo tsamatainko kaxon, ja joxo rania yoinabo, wiso rania yoinabo itan ja meskó keska rania yoinabo, en jatonbiribibo imai, ja jisábobiresbiribi ikannon ixon. Ja yoinabo en jaskáapakearesa iti jake nokon kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ja min yoinabo bakish jakonshamanhakin en mia axonpakea oinxonparira, min onanti iki en mia atikeskabiakin jakonhakin axonabo. Ikaxbi jaweratoshamanborin nokon yoinabo ixon oinkaskinra, min aresti atipanke. Ikaxbi jawetianki, ja nokon yoinabo ikainko benakin, joxoshaman rania, itan rayanmetani rania yoinabo min merai, jatianparira min onanti iki, en mia yometsoaa —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Jaskáakin Jacobnin yoia, Labánman shinan jakonbires iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Jaskáxon ja netenbi carnero meskó raniabo, cabra rani seré wison tsakáyabo, itan rani manxantani carnero bakebo, janbiribo tsinkitaanan, Labánman jawen bakebo koiranmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Jatian jaskáakin Jacob parantaanan, ja yoinabo tsinkixon, Labánman jawen bakebo ja yoinabo ochó bomaa iki. Ja yoinabo jain bomaara iká iki, ja Jacob ikainoax kati, kimisha nete kaax nokóti. Jaskáakin ja Labánman jawen yoinabo jabákinkin bokenbi, ja jatíribi jaiba baneta yoinabo, Jacobnin koiranxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jatian Jacobnin aká iki, álamo jiwi poyan, almendra jiwi poyan itan castaño jiwi ponyanbo bixon kekótiapakekin. Jaskáaxon ja kekótiaa jiwi poyan bichibo xaranhakin raxota, joxon xaranyabo baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ja xaranhakin raxota jiwi ponyanbo bexon, jain yoinabaon bexon onpax xeai ponté nichinpakea iki. Ja xaranhakin raxota jiwi ponyanbo nichinkinra Jacobnin shinanna iki, neno onpax xeai bexon yoinabaon ja oinxon yoranara, ja jiwi raxota jisáboribi bake pikóti iki ixon. Jainxon onpax xeai bexon, ja jiwi xokaa sionyabo oinhananbi, ja yoina jimiabo ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","jawen benen akára, carnero bake pikotabo, jawen rani sionyabo itan jawen rani wison tsakáyabo pikóti iki, ixonribi ja jiwibo jain nichina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jatian jaskara rania pikota carnero bakebo, Jacobnin janbiribibo apakea iki. Ikaxbi ja jaskaramabora, Labánmanabo iká iki. Jaskáaxon Jacobnin jawen yoina itibobiribi tsinkianan, ja Labánman yoinabo betan meskómayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ja jakonshaman yoina awinbo jimia iketian, jawen benen akasai oinxonra, ja jiwi kekótiaa rasionyabo boxon, ja yoinabo bebon Jacobnin chankanxona iki; ja kekóti keská sionyabo pikónon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ikaxbi jakonmatani yoina jimiabo bexon, jawen benen akasai oinxonbira, jawen rasionya kekótibo Jacobnin nichinxonyamaa iki. Jaskara ikaxa, ja jakonmatani yoinabo iká iki, Labánmana. Jatian ja jakonshaman yoinabobiribi iká iki, Jacobna. ");
INSERT INTO shpNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jaskataxa, Jacob kikinbiresi jatíbi jawékia baneta iki. Ja kopí jawen carnerobo iká iki, kikinbires icha. Jainoax jawen kikinhakin yanka yonoti aínboboyabi, jawen kikinhakin yanka yonoti benboboribi icha iká iki. Jainoaxibira, jawen camelloboyabi asnobo, kikinbires icharibi iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jatian jaskara iikin, Jacobnin ninkata iká iki, Labánman bakebo yoyo ikana. Ja yoyo ikana iká iki neskati: “Ja Jacob riki, non papan jatíbi jawékibo iboataanan, kikinbires icha jawékia baneta”, iki ikana. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jainxonribi ja Jacobnin, jawen rayós Labán ointaanan onanna iki, moa ipachoai keská jakonshaman jisáma. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Jaskara iken, ja Jacob Ibon yoia iki, neskáakin: “Ja mia jain ikátiai, min anibaon mainko moa karibatanwe, jainra min kaibobo jake. Mia jain kaaitianra, ea mibé jain kati jake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jaskáakin Diossen yoia, Jacobnin Raquel betan Lea kenamaa iki. Ja kenamaa joax, yoinabo ikainko nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jain moa nokókanketian, jato yoia iki: —Rama netebaon maton papa en oinna riki, ea joá benátian iantana keskáma; eki jakonmarestaniara en oinnai. Jaskara ikenbira, ja nokon anibaon Dios ebébi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mato rabekanbira akonkin onanke, ja maton papan yonoa, jawen teebo jakonhakin axoni, nokon koshibobi keyónon kaman, ea ikonbiresi teeta. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","En jaskáakinbo jawen tee axonabira, ja maton papan ea akonbireskin parana iki. Jainxonribira ichabiresakinribi ea paranbea iki, jan jatí ea kopíati yoia keská senenhayamakin. Ja maton papan ea jaskáboainbira, ea Diossenbi koirana iketian, ea jan jaweayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ja maton papan aká iki, ea yoikin: ‘Ja mia teeta kopí, en mia jan kopíati yoinabo riki, ja meskó keska raniabo’, akin. Jaskáakinbo ea yoiketian, ja yoinabaon bakeaa, meskó keska raniabo pikota iki. Jaskarabo pikókenbi, ea meniamaa iki. Jatian japekáora, ea yoiribia iki: ‘Mia teeta en jan mia kopíati yoinabo riki, seré raniabo’, akin. Ea jaskáaketian, ja yoina bakenabo serébires raniabo pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Jaskáaxonbora, maton papan carnero itibo bichintaanan, ja yoinabo nokona inon ixon, ea Diossen menia iki —akinra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Jatian jaskara iikinra, ja carnerobo jimititian, namá meran en oinna iki neskara: Ja carnero awin jimiabo iketianra aká iki, rani sionya itan meskó keska rania carnerobaon, jawen awin akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Jatian ja namá meranbi, Diossen ángelnin nokon janen ea kenaa iki, jatianra en neskáa iki: “Eara neno iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ja namá meran en jaskáaketianra, ja ángelnin ea neskáa iki: “Ramapari bochiki oinhinabainwe. Jatianra min ointi iki, ja rani sionyabo itan ja meskó rania carnerobaon, jawen awin akaitian; jaskara yoinabora iti jake, ja mina itibo. Jaskara iketianra en oinke, ja min rayós Labánman mia jaskáabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Earibi riki, ja Betelhain oxaxon min namánontian, namá meran mia jan oinmayantana Dios. Jishaman jain oxaxon min aká iki, jan tepikaini mia oxaa makan bitaanan, jaki xeni chikokin. Ja makanki xeni min jaskáa riki, jain ikax mia ebé nokoanana onanti inon ixon min aká. Ja Betelhainxonribira min ea yoia iki, westíora jawéki ea axonti. Jaskara iken, rama moa nato mainmeax pikókaini, ja jainoax mia pikóni mainko katanwe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Jatianra Raquel betan Lean yoia iki: —Jatíbitian nona iti non papana non bitira moa jawebi yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Jainxon ja non papanribira, wetsabobires keskáakin noa shinanai. Jainoax iká iki, nonbobi maroi. Ja noa biti kopi mia akonbireskin teemaxon aká iki, jawebi noa meniamakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Jaskara iketianra, ja Diossen non papa bichina jatíbi yoinabo, moa nona ikax, non bakebaonaribi iki. Jakopíra, jatíbi mia Diossen yoiaibo min axonresti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ja jaskara jain iitira, moa Jacob kaa iki. Ja moa kanoxonra, jawen bakeboyabi jawen awinbo, camellonin jato peyásanpakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Jaskati ja jain jawen papa Isaac iká Canaán main kakinra, ja Padán-aramhin inontian bia jatíbi jawen yoinabo, moa Jacobnin boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ja jawen papa Labán, yoinabo rapéstei wetsanko kaketianra, Raquelnin, ja xobomea ja rabiti aká jawékibo jawen papa yometsoabaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ja Labánra iká iki, arameo joni. Jaskara ikenbira Jacobnin, jatíbi jawen jawékiboyabi moa jabati kakinbi jawebi yoiamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jaskati jatíbi jawen jawékia jabati kakin, Éufrates paro shitabaina iki. Ja paro shitabaini kaax, Galad janeya manan ikáori kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jatian moa kimisha nete Jacob kaibata pekáopari, Labán yoikana onanna iki; moa Jacob jabati kaibata yama. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Jaskara onantaanan, jawen kaibobo tsinkiax, Jacob chibani Labán kaa iki. Jatian ja chibani kanchis nete senen kaxon nokokana iki, Galaad janeya mananman tsamákana. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Jatian ja ikanainko kaax nokota yamé oxaketianra, namá meran Diossenbi Labán yoia iki: “Enpari mia yoinon ea ninkáxonwe, Labanma: Ja Jacob jakonmaareskin yoyo ayamawe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jaskati kaxon, Galaad janeya mananman jato Labánman nokoa iki. Jato jain nokoax, Labán ja ioaboyabi jato betanbi jain iakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Jaskati moa jatoiba iakexon, Labánman, Jacob neskáakin notsina iki: —¿Jaweaki mia jaskatarin? ¿Jaweatikaya min ea paranarin? ¿Jaweati nokon bake ainbo rabé bekin, reteanantiainxon jato yatanxon bekanai keskáakinres, jato jabákinkin min ea beenanarin? ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Jaweaki ea yoiaxmabi jonéshoko jabati joaxki mia iitai? Ea keshanax mia joáitianra, mia eibakeax pikotaitonin rarokin, jakonshaman shinanyanxonres tanporayabi, arpabo axonhanan mia non raankeana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Jainxon nokon bababoyabi ja nokon bake ainbo rabé, ja jayá jonon ixontanibobi min ea jato bexémayamaa iki. Ja min ea jaskaa jawéki riki, onanma jonibo ikax jaskákanai keskáakinres min aká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mia jaskákirana iketianra, mia ramiatibo en shinanna iki. Jaskarabo en shinankebira, nato yamébi ea oxaketian, namá meran min anibaon Diossen ea yoiwanke neskáakin: ‘Ja Jacob nokoanan, jakonhakinreskaya yoitanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Jaskara iken, ja min papa ikatiain karíbakasai ikaxkayara, ja enbi jawéki dios ataanan en rabiai jawékinin mia yometsotima iká iki. ¿Jawe keská kopíkaya jaskaraton min ea yometsoaarin? —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jaskáaketian jawen awin Raquel yometsoa ikenbi onanyamaxon, Jacobnin neskáakin Labán yoia iki: —Ja min bake ainbo rabé, min ea bichinaketian rakékinra, en mia keshanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ikaxbi jawerato neno ikábo, ja min diosboya iken, ¡Mawábanon! Ja jawéki, mia beenankonkana ikax, ja jan bea joni mawáti jake. Jaskáti jawékira, ja neno ebé ikábaonbi onanke: ea yoiwe min jawe jawéki jaketian, botanwe —akin. Ikaxbira Raquelnin ja rabiti akábo yometsoa Jacobnin onanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Jatian jaskáati yoia, ja Jacobnin carpa xobonkopari Labán jikia iki; jawen jawéki benai. Japekáo kaax, Lean carpa xobonko jikiribia iki. Jatian ja kimisha itin, jaton yanka yonotibaon carpa xobon jikixonbi, jawe jawékibi ja rabiti aká nokoyamaa iki. Jaskati xobobotiibi benaatankinbi jawe jawéki nokoyamaax, senennainbi jawen bake Raquelnin xobon jikiribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Jatian jaskáakin jan boá ikax, jawen papan benaboai ointaanan, Raquel ja rabiti aká jawékibo boá tsinkitaanan, camello pekaten iká jan yakáti naman niaax, janbi peyakaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Jaskati ja jawékininbi peyakaxon, Raquelnin jawen papa neskáakin yoia iki: —Ea weniamaitian oinnax sináyamawe, Papá. Noa ainbobo jaskatai keskábii, jimiaxa ea iitai —akin. Jaskáakin yoia, jatíbiain benakinbi Labánman merayamaa iki, janbi rabiti aká jawékibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jatian ja Labánman ayorakin jawen jawéki benai ointaanan, Jacob sináxon neskáa iki: —¿Jawekeska atimayora jawéki en aká iketiankayaki, mia jaskáyorai? ¿Jaweatiki joni reteaibo akanai keskáakin, ea neno kaman benakin min ea chibana? ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Moara nokon jawékiainbo min rebéstankin benake. Jawekeska ixonra, ja min jawékibobira moa min nokoke. Ramapari jatíbi ja min nokoa jawékibo, neno ikábo bebon bexon tsamaniwe; abákanon tsonakayarin ixon, jabaon yoikin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ja ea miiba rabé chonka baritia senen teenontianra, jakonhaxonres min yoinabo mia koiranxonkin, westíoratanibi en mia pianaanama iki. Jainxon ja min carneroboyabi, ja min cabra bakenaiboribi en akonkin mia koiranxona, westíorabi mawatamaribi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Pimis yoinanin, min carnerobo retekenbi, mia bexonyamakin, en mia kopíaresa iki. Jainoax neten iamaxon yamébo min yoinanin yometsokankebi, min eares kopíamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ja ea mibé ikax ikonbiresi teenontianra, bari xanan aká ea kikinni onitsapita iki. Jatian yamébiribi, matsin aká onitsapikin en oxábo tenea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Jatian ja rabé chonka baritia senen ea miiba teenontianra, chonka chosko baritia min bake ainbo rabé kopí, en mia teexona iki. Jainoax sokota baritia senenbiribi, min yoinabo kopí ea teeta iki. Jaskáshamaankinbo en mia teexonabira, ea jakonhakin kopíakashamai kopí, min meskóakinbores yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Jaskara ikenbira, ja nokon papashoko Abraham betanbi Isaacnin Dios jakon ixon, ea noibaxon akinna iki. Jaskati kikinbiresi paxkinyonon kaman teetaitian, ea Diossen akinnabo oinnama ixon, itan namáketian Diossen notsinama ixonra, moabires jawebioma inonbi min ea raankeana iki —akin Jacobnin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jaskáaketian Labánman Jacob yoia iki: —Nato ainbo rabéra nokon bakebo iki; nato bakeshokobora, nokon bababobiribi iki. Jainoax jatíbi neno iká jawékiboyabi, nato yoinabora, nokonabiribi iki. Jakopíra, timenbires en mia ramiati shinanama iki. Jaskara iketianki, rama ja nokon bakeboya jaton bakebo, en jaweati iki. Enra jabo mato bichinti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Jaskara iken, neripari jowé, non rabéxonbi moa jakoni janoxon shinanbekonon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jaskáaketian Jacobnin, westíora ani makan bixon jain chankana iki, ja jatíribi beshé makanbo jaki koshiti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jainxon jawen kaibobo yoia iki: —¡Makanbo tsinkikanwe! —akin. Jatian jatíxonbi westiora tsamá anoxon makanbo tsinkikana iki, jainxonra ja makan tsamainxon pikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Jatian ja makanbo moa jaskáyontaanan, rabéxonbi jaton joinbiribibo jane menikana iki. Ja Labán arameo joni ixon aká iki, jawen joinbiribi, “Jegar Sadutá”, akin. Jatian Jacobninbiribi hebreo joni ixon aká iki, “Galaad”, akin; jaskáakinbora jane menikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ja moa jaskáakin senenhayonax, Labán iká iki neskati: —Nato makanbo non jaskáakin tsamana riki, ja oinnaitiibi non jaskáakin shinanbekoni jawéki, noa jan shinanmati. Ja kopí riki, jawen jane Galaad —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Jainoax jawen wetsa janeribi riki, Mizpá. Jatian Labán iríbaa iki neskati: —Jaskara shinan non rabéxonbi abékona iketianra, moa ochokananbekonax noa oinhananyamaibi, Diossenbi noa ointi jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ikaxbi jawekeska ixon min ati iki, eara nenoa tsonbi oinyamake iki ixon, wetsa ainbo oinxon nokon bake ainbo rabé ramiataanan jato potakin. Jaskarabo shinanxon, nokon bake rabé min jaskáabira, jaweranoa inonbi noa rabébi Ibo Diossen noa oinke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Jatian Labánman, Jacob yoiboresa iki: —Oinwe, nato makan beshébo tsinkianan en chankana napon, ani makan en nichina. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ja jawéki riki, ja senenhabekonti joi non aká, ja oinnaitiibi ja non aká jawéki, noa jan shinanmai. Ja kopíra, moa rabéxonbi akonkin shinanxon abékona ikax, jawekeskataxbi moa ramiananti noa yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abánon ja Abrahamman Diossen, itan Nacornin Diossenbi, noaki jaweatiki ixon jan oinkin —akin. Jatianra Jacobnin jawen papa Isaacnin rabipaoni Dios janebainhana yoia iki, enra senenhai, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jaskata pekáo, ja manamanxonbi Jacobnin yoina Dios retexona iki. Jaskáaxon jawen kaiboboribi pii bekanti jato kenaa iki. Ja piá pekáo, ja manamanbi iakeax, jainbi oxakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Jatian nete xabáketian, yamékirishoko wenixon Labánman jawen bake ainbo rabéyabi, jawen bababo bexépakea iki. Jato bexékin senenhaxon, Diossen jakon shinan jato menitaanan, moa jakiribi jawen itinko Labán karíbaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jatian moa jaskata pekáo, Jacob moa jakiribi karíbaitian, Diossen ángelbo jaki jokonxon nokokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ja ángelbo ointaanan, Jacob iká iki neskati: “Nenoribikayaki, Diossen sontárobo jaa”, iki. Jaskáxon jain janea iki, Mahanaim, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jaskata pekáo, Jacobnin jakiribi jawen yonotibo raana iki, jawen wetsa Esaú jain iká Seir janeya jemanko. Ja jemara iká iki Edom janeya mainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jato raankin yoia iki: “Nokon wetsa Esaú ea yoixontankanwe: ‘Moara basiora nokon koka Labán betan ea jake; ramara nokon wetsa Esaúibapari ea kaai, ikira ike, min yonoti Jacob. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Jainoaxibi jawen meskó yoinayabi, jatíbi jawen kikinhakin yanka yonoti joniboya, jainoax jawen yanka yonoti ainboboyaribi ja nokon ibo joai. Ja kopíra jakonshaman shinanyaxonres min biti iki, ikira ike’ ”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Jatian ja raana botanhibakana jawen jonibo bexon, Jacob yoikana iki neskáakin: —Ja min wetsa Esaú, min joi bomaa kaxon non yoiara, moa jabi mia bechii joai. Ja joaitian chibanira, chosko pacha joni jabé bekanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jaskáakin jawen jonibaon yoia, ratéananbi kikinbiresi rakékin, jaakinres shinanira iká iki. Jaskati iorai rakékin, jawen joniboyabi jawen yoinabo, rabé tsamábo aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Neskara shinanyaxonra aká iki, Jacobnin jaskáakin: “Ja wetsa tsamá Esaúkan joxon ramiaitian oinnax, ja wetsa tsamá jabáti kopí”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jaskáxon Jacobnin orankin neskáa iki: “Mia nokon Ibo Diossiki, nokon papashoko Abrahamman Dios, itan nokon papa Isaacnin Diossibi. Jaskara ixonra min ea yoinike, jain ea japaoni nokon kaibobo xaran, ea jakiribi karíbati. Jain ea jakiribi kaketian, ekiakin jakon shinanna ixon, ea akintira min ea yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ea jaskáati jisáma joni ikenbira, miares jakonhamis ixon itan akonkin senenhai ixon, min ea akinna iki. Ja Jordán paro jawebiomaxon shitaibi, nokon kekótiabicho ea iká iki. Jaskara iní ikaxbi riki, ramatianbiribi ea icha jonia itan icha yoinaya ikax, moa rabé tsamá jato imati winobainbires. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Jaskara iken, rama ea noibawe; ja nokon wetsa Esaúkira, ea kikinbiresi raketai. Jan joxonra, noa jatíbi bakeboyabi ainbobo noa retekin keyonake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Minra ea yoia iki, jatíbitian jakonbires jati. Jainxon minribi ea yoia iki, nokon kaibobo kikinbiresi kaiax, aniparo kexakea mashitii icha ikax, tsonbi topontimatii iti, akin orana iki”, akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jaskatax moa jainbi yametax, Jacob jain oxaa iki. Jainxonribi jawen jayata jawékibo, jawen wetsa Esaú meninoxon katóxonpakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ja jawen wetsa katóxonabo iká iki: Rabé pacha cabra, rabé chonka cabra bene, rabé pacha carnero awin, rabé chonka carnero bene. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kimisha chonka camello awin bakeyabo, chosko chonka waka awin, chonka waka bene, rabé chonka asno awin, chonka asno bene. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jaskáaxon jawen yonotibo menipakea iki, westíora tsamá yoinabo. Jato menipakekin yoia iki: —Ja westíora tsamábo jatonbiribi ochóchaabo akanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jatian ja reken tsamá imataanan, Jacobnin jawen yonoti yoia iki: Jawekeska ixon, ja nokon wetsa Esaú joxon meraanan mia ati iki, neskáakin yokákin: —¿Miaki tsoa iki? Iamaax ¿Jaweranoki mia kaai? Iamaax ¿Nato yoinaboki, tsoona iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ja mia jaskáakin yokáketianra, min neskaakin yoiti iki: “Ja yoinabora min yonoti Jacobna iki; kopímabi mia meniti noa tsinkimaa. Jara nopekao chinitainbires joai anoxiwe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jainxon ja rabé itin raana, itan ja kimisha itin raana, jainoax jatíbi ja yoina tsama boaibo jato yoia iki: —Ja Esaú meraxon jaskaakinbires yoinoxikanwe, ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","jainxon yoiribikanwe: ‘Noopekaora ja min yonoti Jacob joai’ —akin. Jacobnin shinanara iká iki: “Jaskáakin nokon jonibo en nokon wetsa jato yoimaara, jawen siná shinan tantipakexon, ea jakonhakin bitiki”, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jatian jaskáakin ja jawen wetsa tsinkixona jawéki, moa jawen jonibo betan Esaú bomakin rekenmaax, jainbipari iakeax Jacob jainbi oxaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Jaskatax ja yamébi Jacob wenixon, jatíbi jawékiboyabi jawen rabé awin, jawen rabé yanka yonoti ainbo, itan jawen chonka westíora bake bitaanan jato boxon, paro benés ikain jato shitámaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Jaskáaxonra jatíbi jawen jawékiboya, ja Jaboc janeya paro keiba jato shitámaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jaskáakin jato shitámataanan, Jacob jabicho jain iakea iki. Jain iakeax, ja yamébi westíora onanama joni jaki joketian, jabé koshi meeanani iishina iki; nete xabatai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jatian ja jonin, moa Jacob jaaresti atipanyamaxon, jawen chipexkoain timakin, tsipaskea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Jatian ja Jacob jaskáataanan, ja jonin yoia iki: —Moara bari pikóke ea jenewe —akin. Jaskáabi Jacobnin neskáa iki: —Ea jakon janon ixon, min jakon shinan min ea meniamaitianra, en mia jeneyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Jaskáa ja jonin yokata iki: —¿Jawe janerin mia? —akin. Jatian jan yoia iki: —Nokon jane riki Jacob —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Jatian ja jonin neskáa iki: —Ramara min jane Jacob iamai. Min janera ikai Israel; miara Dios betan itan jonibo betanribi koshi meeanankin min jatoareske —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jaskáakin yoia, Jacobnin neskáa iki: —Ramara minbiribi, ea yoishokoti jake min jane —akin. Jaskáa ja jonin aká iki: —¿Jaweatikayaki nokon jane min onankasai? —akin. Jaskátaanan ja jonin, moa Jacob jawen jakon shinan menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jatian jainoax jaskábekona mai, Jacobnin janea iki, Penuel akin. Jaskatax Jacob iká iki neskati: “Moara enbishaman Dios oinke, jabira ea jarésparike”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jatian bari keyataitian, ja jonin tsipaskea moa nitikoma banetax, Jacob jakonmai nii yoté iikaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ja Jacob jaskáakin Diossen tsipaskeni iketianra akanai, rama kamanbi israelita jonibaon, kishinkonia nami piamakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jatian ochokeabi Esaú, jawen chosko pacha joniboyabi jaki joaitian, Jacobnin meraa iki. Ja joai merataanan, jaton bakebobiribi koirankanon ixon, jato menipakea iki. Ja jaton bakebo koiranti yoiabora iká iki, Lea, Raquel jainoax jawen yanka yonoti ainbo rabé. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Jato jaskáataanan, jawen yanka yonoti ainbo rabépari jaton bakeboya jato rekenmaa iki; japekáo Lea imaa iki. Ja Lea pekáo chinitainbires Raquel jawen bake Joséyabiribi imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jato jaskámaaxbi, jato winobaini kaax, Jacob jawen wetsa joai bebon kanchisi chirankootaitiibi, maikibi bekepia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Jatian jawen wetsa jaki kaai ointaanan, ja Esaúribi jaki ishtokainxon, jawen wetsa ikótaanan teikoax, rabekaxbi winibekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Jatian jaskata pekáo oinhaketankin, Esaúkan meraa iki ainboyabi bakebo. Jaskara oinxon, Jacob yokata iki: —¿Natoki tsoabo iki? —akin. Jatian Jacobnin yoia iki: —Nato riki, ea Diossenbi menia bakebo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Jatian jawen yanka yonoti ainbobo bakeboyabi ochómakiranax, Esaú bebon chirankootaanan maiki bekepikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Japekáo, Lea jawen bakeboyabiribi joshokoax, chirankootaanan maikibi bekepishokokana iki. Jatian senenainbi Raquel jawen bake José betanshoko joax, jaskatoshishokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Jatian Esaúkan Jacob neskáakin yokata iki: —¿Jaweati ea joai bain, min jatí icha yoinabo raanaki en jokin nokoa? —akin. Jaskáa Jacobnin yoia iki: —Ja yoinabo riki, mia meniti en akábo. Ja yoinaboribi riki, moa ramianani jenetax, noa jakonbires jabékonti kopí en aká —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Jaskáabi, Esaúkan aká iki neskáakin: —Mia nokon wetsa iketianra, en mia yoiai, nokon yoinabora icharibi iki; ibanon ja yoinabo minabi baneti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ja Esaúkan jaskáabi, Jacobnin neskáakin yoiboresa iki: —Ja en mia menia yoinabora, jawekopímabi en mia meniaibo iki. Jakopíra min birésti jake; ea akonbireskin noibaxon min ea bia keskáribiakin. Earibira mia oinnax ikonbiresi raroi, nekebi Dios ointaanan ikai keskatai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jakopíra en mia yoiai, nato en mia meniai jawékira, min birésti jake. Ja nokon yoinabora, ea Diossenbi kaimaxona ikax, kikinbires icha iki. Ea jan maxkatai jawékiboribira, ea moa jayá iki —akin. Jaskáakin teaboxon, Jacobnin jawen wetsa Esaú moa jen imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Jaskati moa jen itaanan, Esaú iká iki neskati: —Jaskara iketian, ea rekenbanon; moa kabékonon kawé —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jaskáaketian Jacobnin Esaú neskáa iki: —Minbira ake onankin bakebo basiamai paxkinai. Jainoaxibira neno jake, carneroboyabi waka tooyabo. Jaskarabo ikenbi, westíora nete winobain non nikinara, paxkinax mawati keyókanti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jakopíra jakon iti iki, miapari rekenkaini kaa. Jatian ea chiní kaabira, nokona jakon iti iki; nokon bakeboyabi nokon yoinabo jainmashaman jato ioti kopí. Jatian kaxonra en mia nokoti iki, Seirhain —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Jatian Jacobnin jaskáakin yoia: —Jakon riki —akin Esaúkan aká iki. Jaskátaanan Esaúkan aká iki neskáakin: —Jaskara iken, ja ebé bekana jawetii joni, en mia banémaxonbanon —akin. Ikaxbi Jacobnin neskáa iki: —¡Jaskarama riki! ¿Jaweakiki mia tsokasai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Jaskátaanan ja netenbi, Esaú moa Seirhain karíbaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jatian Jacob, Sucot janeya mainkobiribi kaa iki. Jain kaxon xoboaa iki; jainxon jawen yoinaboribi jato peotaaxona iki. Jaskara kopíra, jain janea iki, Sucot, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ja Padán-aranhinoax kaaxa, Jacob nokota iki, Sucothain. Jainoax tekíkaini kaax, Siquemhain nokota iki; ja Siquemra Canaán main iká iki. Jaskara ikaxa, jakonbires isinama itan rakéyamai nokókana iki. Jaskataxa ja Siquemhain iakeax jainbi jakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jain iakeaxa, Hamor jonibaon bakebaon main maroa iki; pacha koríki kopía. Ja Hamor iká iki, Siquemman papa; jaskati ja mai jato maroataananra, moa jainbi jatiaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Moa jaskáayona pekáora, jan axon Dios yoinabo retexona menoti makan tsinkianan tsamana iki. Ja makan tsamanxonra janea iki, El-elohé-israel, akin. Ja iki, jatíbi jawéki atipana Israelbaon Dios iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ja Dinara iká iki, Leaki Jacobnin bakeaa. Jaskarabo inontianra, jabé xontakoboiba merati Dina kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Jain kaketian, ja hebeo jonibaon joni koshi Hamornin bake Siquenman meraa iki. Ja merataanan, jaiba kaxon keenyamainbi, teaboxon yorana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ja moa jaskáax, ja Lean bake xontako oinnax, Siquem kikinbiresi jaon keena iki. Jaskati moa aká ikax, iorai jaon keenkin, moa jabi biti shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Jatian ja xontakonin jaskati iorai keenkin, Siquemman jawen papa yoia iki, ja xontakonin papaiba kaxon yobenxonti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ja Jacobninra moa onanna iká iki, jawen bake Dina keenyamainbi Siquenman moa yorana. Jaskara onanaxbi, jawen bakebo jaton yoinayabo wainko bokana iketianpari, jato manakin jaweayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Jaskara ikenbi, ja Siquemman papa Hamor, Jacob betan yoyo iki joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jatian jaskara ikábo, moa wainkoniax joax nokóxon onantaanan, ja Jacobnin bakebo sinákana iki. Ja jaton poi jaskáakana jawéki jabaon oinna iká iki, jatoki ramíkin itan jatoki shirokin akana jawékires. Ja Siquemmanra, jaskáatima iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Jaskákanainbi Hamornin jato yoia iki: —Ja nokon bake Siquemra, ja xontakonin ikonbiresi keenai. Ja kopíra en mato yoiai, jaskati jaon keenaitian moa bimakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Jatianra maton rarebo noa iti iki. Jaskataxa non bakebo maton ainbo bakebo betan wanokanti iki; jatian non bakebaonbiribi maton bakebo biti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Moa noobetan jaai banékanwe. Nato riki, noabo jain jaa non mai; maton keenain kaax jain jakanwe, mainbo marokanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Jatian ja Siquemmanbiribi, Jacob betanbi ja Jacobnin bakebo yoia iki: —Ja Dina en awinhakin biti, maton shinan jakon iketianra, jatíbi maton ea yokatai jawékibo en mato menirestiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Matonra ea yoiresti jake, jawetii jawékikayaki ja Dina kopí mato keenai ixon; jatianra ja mato keenai jawékibaon en mato kopíati iki. Jaskara iken, ja Dina ea bimakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jaskáakin jato yoiabi, ja Jacobnin bakebo keenyamakinbi parankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ja parankinbi akana iki neskáakin: —Jawekeskáaxonbira, jaton jakina rebichi xatéoma jonibo, non poi non bimati atipanyamake. Jaskaraoma joni non bimaabira, noona kikinbires rabin jawéki iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nonra mia bimati atipanke, jatíbi mato jonibaon jatíxonbi, maton jakina rebichi maton rexteketiampari. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Jatikaxbi jaskáxonparira non kaibo ainbobo awinhanoxon, mato jonibaon biti atipanke. Jainxon nonbiribi, maton ainbobo biti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ikaxbi jaskáti mato non yoia keská itin mato keenyamaitianra, ja non poi Dina moa non ioti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Jatian jaskáti yoikana, Hamor betan jawen bake Siquem keenbekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ikaxbi ja Siquem iorai Jacobnin bake Dinan kenyorai ikax, jaskáti yoikanatianbi kaxon, jawen jakina rebichi rextea iki. Ja Siquemribira iká iki, jatíbi jabé iká jawen wetsabaon, akonkin jawen joi ninkáxonkanai joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Jaskatax jatianbi, Hamor betan jawen bake Siquem, ja jaskáti yoikana joi, ja jemamea joni koshibo yoii kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ja kaxon jato aká iki neskáakin: —Ja Jacobnin bakebo riki, kikinbires jakon shinanya jonibo. Jabora neno non main jakáskanai; ibakanon nato non main jataanan yoábo akáx maroi. Jain jakantibora non mai ani ikax jayonreske. Jatianra jabaon non ainbobo awinhakanti iki; nonbiribi jaton ainbobo awinhati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ja jonibora, nobé jatin keenkanai. Ikaxbi jabo keenai riki, jato keskaribi noa inon ixon, noa benbobaon non jakina rebichi rextéyabo noa itin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Jaskara iken, jato imanon akanwe nobébi jato jamakin. Jatianra jaton yoinaboyabi, jaton jayata jawékibo noona iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ja Hamor betan jawen bake Siquemman, joni koshibo jaskáakin yoia keenkana iki. Jaskáxon jatianbi jatíbi benbobaon jaton jakina rebichi rextekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Jatian ja jaskáaibakana kimisha nete pekáo, ja Dinan poi rabé Simeón betan Leví, jan chachimisti espadaya jatoiba kaa iki. Kaxon, ja jaton jakina rebichi rexteabo kikinbires isin iketian koshiamakanaitian, ratereskin nokoanan jato retekin keyokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Jaskáakin ja Hamor betan jawen bake Siquem retetaanan, ja xobomea Dina pikoxon moa iokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jatian jan jato reteabo bokanamatianbi bexon, ja retekana mawá yorabo, jatíribi Jacobnin bakebaon winobainkana iki. Jaskáakin ja mawábo winobainxon, ja jemamea jaton jawékiboribi jato keyokin boonkana iki. Jatora jaskáayonkana iki, ja jawen poi keenyamainbi, Siquemman yorana iketian jan kopikaakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ja jato bonkana jawékibora iká iki: Wakabo, carnerobo, burrobo; jainxonribi bokana iki, ja jeman jaa jawékiboyabi jaton wainko jaa jawékiboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Jainoax jaton xobon jikixonribi, jaton jayata jawékibo jato bonkana iki. Jainxonribi jaton bakeboyabi jaton titaribi bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jato jaskáaketian, Simeón betan ja Leví, Jacobnin jato notsinkin neskáa iki: —Ja maton jaskara jawéki akátoninra, ea kikinbiresakin jakonma imake. Ramara cananeo joniboyabi ferezeo jonibo, eki ramiti moa ea ointinin keenyamakanai. Noabo ichama iketianra, ja nenoa jonibo wetsabo betan rabétaanan noa keyoti atipanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Jato jaskáakin yoiabi neskákana iki: —Ja Siquemmankayara, tsini ainbo akanai keskáakin, ja non poi Dina atima iká iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Jatian Diossen Jacob yoia iki: “Min wetsa Esaúki raketi mia jabati jonontianra, Betelhainxon en mia nokoa iki. Jaskara iketian, rama nenoax jakiribi kaax jain jatanwe. Jatian jain kaax moa nokóxonra, jain axon Dios jawéki menoxonti min makan tsamanti jake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jaskáakin yoia, Jacobnin jawen awinyabi jawen bakebo, jainoax jatíbi jabé jaaboribi jato yoia iki: —Ja mato jayata maton ikonhai ikonma diosbo moa potakanwe. Dios bebon jakon inox, chokixon moa wetsa chopa sawekanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ramabi moa Betelhain bonon bokanwe. Jain kaxonra, Dios rabikin jain axon jawéki menoxonti en makan tsamanti jake. Ja makánbora en jaskáati jake, onsá meranoabi ea Diossen akinna iketian. Jainoax jatíbiain ea kaainkobo ea jan akinna iketianribi —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ja Jacob jaskáketianra, jatíxonbi ja ikonhakanai jatonbi jawéki diosaabo, jaton paronotiabi, Jacob bexonkana iki. Jaskáakin bexonkanketianra, Siquem jiwi ani naman, ja bekana jawékibo Jacobnin jato miinaana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Jatian ja ikanainoax moa maei bokanaitianra, ja jato patax iká jemabo Diossenbi akonbireskin jatoki rakémaa iki. Jakopíra, tsonbi chibanxon jato ramiati shinanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jaskati boax, ja jabé bokana jonibo betanbi Jacob, Luz akin akanai jemanko nokókana iki. Ja jemaribira Jacobnin janea iká iki, Betel akin. Ja jemara Canaán main iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jatian jain moa nokóxon, Jacobnin aká iki, jan perakanxon Dios jawéki menoxonti makan tsamankin. Jaskáakin tsamanxon janea iki, El-betel akin. Jaskáakinra Jacobnin janea iki, jawen wetsaki raketi jabati kaaitian, jain iken Diossen nokoyantana iken. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ja jemameaxibira Débora mawata iki; jara iká iki Rebeca koiranxon jan aniaa ainbo. Ja mawáketianra, Betel ochóma iká westíora ani jiwi namanbi miinkana iki. Jakopíra, ja jain iká jiwi janekana iki, “jain ikax masá shinanni winikani”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jatian Jacob Padán-aramhinoax jonontianra, Diossen jaki pikóribixon, jakonbires inon ixon, benaakin jakiribi jawen jakon shinan menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Jaskáakinra neskáa iki: “Min jane riki Jacob, ikaxbi ramabiribira, min jane ikai Israel. Jaskáakin rama en mia janeketianra, moa tsonbi mia Jacob akin janetima iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Jaskáaxonbi yoiboresa iki neskáakin: “Ea riki jatíbi atipana Dios; ja kopíra min chiní bakebo ikonbiresi kaitax, maibotiibi boax ani jemabo ataanan, apobo jikinoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ja Abraham betan Isaac en mai meninira, rama en miaribi meniai. Ja mai en mia menia keskáribiakinra, min chiní bakeboribi en meninoxiki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Jaskáakin Jacob yoikin senenhataanan, moa Dios kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jaskati moa Dios kaketianra, Jacobnin westíora makan bixon jain jaskarabo ikainkoshaman nichina iki. Ja makan nichinxonra, Diossenabiribi iti kopí, xeni betan uva jenen rachita iki; ja oinnaitiibi Diossenbi jainxon yoyo aka shinanti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jaskara ikenra, Jacobnin jain janea iki, Betel akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jatian Jacob jawen joniboyabi Betelhainoax wetsanko boí tekíribikana iki. Jaskati boí Efrata akanainko nokóti ochóchaapari ikenbi, Raquel baken chexakin peoa iki. Ikaxbi bakenkaskinmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Jaskati moa basi bakenkaskimai iitibi, moa bake pikóketianra, jan bakenmaitonin neskáa iki: “Moa masá shinanyamawe, moara min bake pikóke; ja pikota bakera benbo bakeribi iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Jaskáakin moa bake pikoaxbi, jayá maxkakinbi Raquelnin akinbicho koshin jointaanan yoia iki, nato baken jane riki, Ben-oní, akin. Ja jane iki, nato baken riki ea akonbireskin onitsapimaa iki iká. Ikaxbi jawen papanbiribi janea iki, Benjamín akin. Ja iki, nokon noi bake, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Jaskati moa Raquel mawáketianra, Efratain kati bai kexabi miinkana iki. Jatian ramatianbiribira ja jema janekanai Belén akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jatian Jacobninra ja miinkanainko, westíora makan bixon nichina iki. Ja makanra jaskáa iki, Raquel mawáketian jain miinkani onanti inon ixon. Jaskáakin ja makan nichínira, rama kamanbi jarésparike. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jaskarabo abaini Jacob kaa iki, Eder Torre akanainko. Jain kaxon, carpa xoboaribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Jatian moa jain kaxon jatiaax, jain jakana iki. Jaskati moa jain jaa iikinbi, Rubenman jawen papan awin Bilhá teaanana iki. Jaskáakin jawen baken jawen awin teanaana onanax, ja Rubénki ikonbiresi jawen papa sinata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jacob iká iki, chonka rabé bakeya. Ja Lea betan bakeabora iká iki: Rubén, jawen reken bake; japekáo iká iki, Simeón; Leví; Judá; Isacar jainoax Zabulón. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ja Raquel betan akábiribira iká iki, José betan Benjamín. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Jatian Raquelnin yanka yonoti Bilhá betan akábiribi iká iki: Dan betan Neftalí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Jainoax Zilpá iká iki, ja Lean yanka yonoti. Jabéra Jacobnin bakearibaa iki, Gad betan Aserbiribi. Jabora iká iki, Padan-rain inontian bakeaabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jatian Jacob kaa iki, Mamré akanai jeman, jawen papa Isaac oinni. Ja jeman janeribira iká iki, Arbá itan Hebrón akanairibi. Ja jemanra Abraham betan Isaac japaonike. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ja Isaac mawata iki, pacha posaka chonka baritiayanix. ");
INSERT INTO shpNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Jaskati yosishokoira ikax, jaton papa moa mawáketianra, Esaú betan Jacobnin, jawen anibo miinmeetainkoribi miinkana iki; jawen anibo mawánibo betan nokoanani kanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Neskataxa Esaúkan chiní bakebo kaikanike; jaboribira akanai Edom jonibo akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ja Esaúkan anike, Canaán mainmea rabé ainbo bikin; jawen jane iká iki, Adá ja iká iki Elóman bake, hitita ainbo. Ja wetsa iká iki, Aholibamá; Anákan bake ainbo, Sibónman baba; heveo ainbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Jainoax jawen wetsa awinra jaríbaa iki, jara iká iki Ismaelnin bake ainbo Basemat janeya; jabiribi iká iki, Nebaiotnin poi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Jainoax Esaúkan Adá betan bakeaara iká iki: Elifaz. Jatian Basemat betan akábiribi iká iki, Reuel. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ja senenainbi Aholibamá betan akábiribi iká iki: Jeús, Jaalam jainoax Coré. Jabora iká iki, Canaánhin inontian Esaúkan bakeaabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Jaskati jawen yoinabo moa kaiax, jainbicho itikoma iketianra, Esaúkan shinanna iki, janbiribi moa wetsanko jaai kati. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Jatian jaskati kakinra, jawen awinboyabi, jawen bakebo jainoax jabé jaaboribi tsinkitaanan, jato Esaúkan ioa iki. Jaskáribiakin ja Canaán main inontian bia jawékiboyabi jawen yoinabo, keyokin boá iki. Jaskatax jawen wetsa betan moa ochóananbekona iki. Ja Esaúra jaskati maea iki, moa jawen yoinabo kaia ikax, jainshamanbo moa waiati yamaketian oinnax. Jaskatira jawen wetsaibakeax Esaú pikota iki, jainbicho itikoma iketian ointaanan. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Jakopíra Esaú kaa iki, janbiribi Seir janea mananman jaai. Ja Esaúkan wetsa janera iká iki, Edom. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Neskatax kaikana iki, ja Esaúkan chiní bakebo; jaboribi riki edomita jonibo akin akanai. Ja jonibora jakana iká iki, Seir janeya mananman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Natobora ikana iki, ja Esaúkan chiní bakebaon janebo: Elifaz, ja iká iki Adá betan Esaúkan bakeaa, Jatian ja Reuelbiribi iká iki, Basemat betan akábiribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Jatian ja Elifazsen bakebobiribi iká iki: Temán, Omar, Sefó, Gatam, jainoax Quenaz. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Jainoax ja Elifaznin bia keskáaxon jakina iká iki, Timna janeya ainbo. Ja ainbo betan bakeaa iká iki Amalec, jatíbi jabora ikana iki, Esaúkan awin Adakan bababo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Jatian ja Reuelnin bakebobiribi iká iki: Náhat, Zérah, Sama jainoax Mizá. Jabora iká iki, Esaú betan Basematnin bababobiribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Jainoax Aholibamá betan bakeabobiribira iká iki: Jeús, Jaalam jainoax Coré. Ja Aholibamá iká iki, Anákan bake, Sibónman baba. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Jaskara ikax, ja Esaúkan chiní bakebaon koshibo iká iki, ja Elifazsen chiní bakebobiribi. Jishaman natobo iká iki, jaton joni koshibo: Temán, Omar, Sefó, Quenaz. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam jainoax Amalec. Jabora iká iki, Edom main ikana Elifazsen joni koshibo; jainoax jaton titashoko iká iki, Adá. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ja wetsa joni koshibo ikana iki, natobo: Náhat, Zérat, Sama jainoax Mizá. Jatian natobiribira iká iki, Esaúkan bake Reuelnin chiní bake joni koshi jikiabo: Náhat, Zérah, Sama itan Mizá. Jabo iká iki, Edomhainoa joni koshibo; jainoax Esaú betan jawen awin Basematnin bababo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Jaskáribiira jaríbaa iki, Aholibamánin bakebo. Jabo iká iki: Jeús, Jaalam jainoax Coré. Aholibamára iká iki, Anákan bake ainbo; Esaúkan awin. Jawen bakebora joni koshibo jaríbaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Jatíbi jabora ikana iki, Esaúkan chiní bakebo, ja Edom akanai; jainoax jaboribi ikana iki ja wetsa tsamábaon joni koshiboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ja Esaú jaa mainribira jakana iki, horeos akanai jonibo. Ja westíora jonin jane iká iki, Seir. Ja jonin bakebaon janebo iká iki: Lotán, Sobal, Sibón jainoax Aná, ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Eser, jainoax Disán. Ja jonibora iká iki, horeos jonibaon koshibo; Seirkan chiní bakebo, Edom mainmeabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Jatian Lotánman bakebobiribi iká iki: Horí betan Hemam; jainoax jawen poi iká iki Timna janeya. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Jainoax Sobalnin, bakebobiribi iká iki: Alván, Manáhat, Ebal, Sefó jainoax Onam. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Jaskaribiira Sibónman bakebo jaribaa iki; jabo iká iki: Aja betan Aná. Ja Anánra, jawen papashokon asnobo koirani iikin, tsoa jonibi jain jaama mananmamea westíora jainoax jene jokonai meraa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ja Anára iká iki, westíora benbo bakeya, jawen jane Disón. Jainoax westíora bake ainboyaribi iká iki, jawen jane Aholibamá. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Jainoax Disoman bakebora jaríbaa iki; jabo iká iki: Hemdán, Esbán, Itrán, jainoax Kerán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ja Esernin bakebobiribi iká iki: Bilhán, Zaaván jainoax Acán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ja Disáman bakebobiribi iká iki: Us betan Arán. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Jaskara ikax, ja jonibaon joni koshibora iká iki: Lután, Sobal, Sibón itan Aná. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Eser jainoax Disán. Jatobora iká iki, horeos jonibaon koshibo. Jaskara ikaxa, jaton koshibobiribi Seir janeya main jakana ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ja non janepakeabo riki, Israel jonibo apooma inontian, jabaompari Edom main apo ixon, jan jato ikínpaonibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Jatian rekénpari Edom main apo jikia joni iká iki, Bela; ja iká iki Beornin bake. Jawen jeman jane iká iki Dihanba. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ja Bela mawata pekáora, jawen toan Jobab janeya joni apo jikishokoa iki, jara iká iki Zéracnin bake; Bosrá jemamea joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jatian Jobab mawata pekáobiribira, Husam apo jikia iki; ja iká iki Temán mainmea joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Jainoax ja Husam mawata pekáora, jawen toan Hada apo jikia iki; jabiribi iká iki, Bedadnin bake. Janra Madián jonibo betan reteanankin jato kanana iki; ja Moad jeneya mainxon. Jawen jeman janebiribi iká iki Avit. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Jaskara iiti moa Adad mawáketian, jawen toan Samlá apo jikia iki. Jara iká iki, Masrecá jemamea joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Jatian Samlá moa mawáketian, jawen toan Saúl apo jikia iki. Ja Saúlra iká iki, paro kexá iká jema Rehobot akin akanai jemamea joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Jatian moa Saúl mawata pekáo, jawen toan Baal-hanán apo jikia iki. Ja iká iki, Acbornin bake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Jainoax Baal-hanán mawáketianra, Hadad apo jikia iki. Ja iká iki Pau jemamea joni; jawen awinin jane iká iki, Mehetabel. Jatian ja Mehetabelnin titan janebiribi iká iki, Matred; jawen papashokonabiribi iká iki, Mezaab. ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Jaskara iken, ja neno non yoiaibo riki, Esaúkan kaibobaon janeyabi jaton jemabaon janebo. Ja janebo iki natobo: Timna, Alvá, Jetet, ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibamá, Elá, Pinón, ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz, Temán, Mibsar, ");
INSERT INTO shpNTpo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram, Esaú jawen wetsa jane Edom. Jabora ikana iki, Edom mainmea joni koshibo ixon, jan jato ikinabo. Jaskara ikax, ja Esaú iká iki Edom jonibaon papashoko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jaskatax Jacob Canaánhainbi jaai baneta iki; jawen anibo jain jakátikanainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Natoriki ja Jacob itan jawen bakebo iní jawéki: Ja José chonka kanchis baritiaya inontianra akatiai ja jawen papan awin keskaakin ikinna Bilhá betan Zilpánin bakea jawen wetsabo betan, yoinabo koirankin. Jaskara ixonra, jawen wetsabo jakonmanankanaitiibi kaxon, jawen papa keshankatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ikaxbi ja Israelninra, jawen wetsa jane Jacobnin, janra jawen wetsa bakebo aká bebonbires, José noia iká iki; yosishokoxonbi bakeaa ixon. Jaskáakin noia ixonra, meskó keska metsáshaman sionyabo tariaxona iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ja José jaskáakin jawen papan ayorakin noia ointaananra, jawen wetsabaon omískin peokana iki; yoyo ayamakinra oinreskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Jaskáakanabi, jakonhiraakin namáxon Josekan jawen wetsabo yoikasa iki. Jato jaskáakasabi jatiankaya benbonbires jawen wetsabaon omisa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Jaskáakanabi jato yoia iki: —Eapari ninkakanwe, en namáwana jawéki en mato yoinon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ja nokon namá meran en oinnara noa iwanke, wainko kaxon trigo taxtei noa tsamata. Ja taxtexonra non awanke, senbóakinbo nexapakekin. Jatian ja nokona en nexaxon rakanara iwanke, weniinakainax pontéshaman chankati. Ja nokona jaskáketianra, ja matonabiribi iwanke, ja nokon trigo senbó en neaa chankataori boax, ja manaon beóbaini —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Jaskáakin jato yoia, jawen wetsabaon José neskáa iki: —¿Jaskara ikax, miakayaki non apo inoxiki? —akin akana iki. Jatian jaskáakin namáxon jato yoia kopí, bebonbires José omiskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Jaskáakanabi jakiribi namáxon, Josekan jawen wetsabo, neskáakin jato yoiribia iki: —Enra jakiribi nokon namá meran oinwanke, bari, oxe, jainoax chonka westíora wishtin; jabora iwánke eoriti beóbaina —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Jatian jaskáakin namatabo, jawen papa betanbi jawen wetsabo Josekan jato yoiaitian ninkáxon, jawen papan José notsina iki. Ja notsinkin aká iki neskáakin: —¿Jawe yoii ikákayarin, jaskara min namatabo? ¿Min wetsaboyaxonbi, ea min papan itan min titan, mia rabibainkin min yoiai joibo mia non ninkáxontinkayaki mia keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Jatian ja Josekan jato jaskáakin yoia ninkáxon, jawen wetsabaon jaki ramíkin omiskana iki. Ikaxbi jawen papabiribi, jaskara Josekan namata yoiabo onankasi, ja shinanyares iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Jaskara iiti, wetsa neten ja Josekan wetsabo, Siquem mananman jawen papan yoinabo pasto benaxon pimai bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Jaskara iken, jawen papa Israelnin, José neskáakin yoia iki: —Min wetsabora, Siquemhain yoinabo koirani bokana iki. Ja kopí ea keenai riki, jato oinni mia katin —akin. Jatian jawen papan jaskáakin yoia: —Ikonrake en jato oinbatanon —iki ikaini kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jaskáketian Hebrónhainxon Siquemhain raankin, jawen papan José yoia iki: —Kamentanwe, min wetsaboyabi yoinabora, jawekeskabira iki jato oinni. Ja moa jato oinbeirani joxonra, min ea keshanti jake, jawekeskaki ikanai ixon en onannon —akin. Jaskáxon jato ointi, Hebrónhainxon jawen papan José Siquemhain raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Jaskáakin jawen wetsabo benai kaaxbira, jan kati onanyamaax José benota iki. Ja benotax iitaitianra, westíora jonin nokoxon yokata iki: —¿Jawe benaiki mia iitai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Jaskáakin jonin yokata, Josekan neskáa iki: —Nokon wetsabo benaira ea iitai —akin. Jatian Josekanbiribi ja joni yokáshokoa iki: —¿Minki ea yoiti atipana, ja yoina koiranaiboki, jawerano ikanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Jaskáakin yokata jonin yoia iki: —Tsoabira neno yamake, moa nenoax bokana riki. Ixonbi ja boí, neskati yoyo ikanaira en ninkáibake: Dotánhin bonon bokanwe, iki ikanaira en ninkáaibake —akin. Jaskáakin yoia kaxon, Josekan jawen wetsabo Dotánhin jato nokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Jatian José kaaitian, ochokeabi jawen wetsabaon meraxon, jatoki nokotamatianbi reteti shinankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Jaskáakin moa reteti shinantaanan ikana iki neskati: —Oinkanwe, ja jatíbitian namataira joai —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ibanon joi, non retexon pozo meran potanon. Ja reteanan jain potaxonra, non papa non yoiti iki, pimís yoinanin moa piá riki, akin. Jaskáataananra noa manákanti iki, jan namáxon noa yoipachoaiboki jawekeska ikai ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ja jaton wetsa chiní José yoii jaskákanaitian, Rubenman ninkata iki. Jaskákanai ninkáxon, jan retekashamakin jato neskáakin yoia iki: —Retetima riki, non wetsa; ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","tsoa jonibi jain jaama pozo meranreskaya potati riki. Ja reteaxbira, noa rami itiki —akin. Ja Rubenmanra jato jaskáa iki, jan retekashamakin, itan jawen papaiba ioti shinanya ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jatian José kaax, moa jawen wetsaboiba nokóketian, jawen jakonshaman sion tari jopémakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ja jopemaxon yatantaanan, ja mai kini chichó manxanshaman ikain José potakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ja José moa mai kini meran potabaini boax jawen wetsabo pii bokana iki. Ja pii yakáxon oinkana, Galaad mainmeax Ismaelita jonibo jaton camellonin peyakaabo bekana iki. Ja jonibora iká iki, inintinin maroaibo ixon, Egiptonko meskó inintibo boí; ja bokanai iníntibora iká iki: Bálsamo, mirra, akin akanai iníntibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ja jonibo bekanai ointaanan Judakan, jawen wetsabo neskáakin yoia iki: —Jawe jakonra itima iki, ja non wetsa nonbi reteaxbi, noa jaskati paranaibo iita. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Jakonkayara iti iki, ja non wetsa reteyamakinbi, ja Ismaelitabores non jato maromaa. Non reteti ikaxbira, kikin non wetsaira iki —akin. Jatian Judakan jaskáakin jato yoia, moa José reteyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Jaskáakin moa reteyamaxon, jawékinin maroai madiánhinoax beai ismaelitabo jan winókanaitian oinxon, pozo meranoa José tsekakana iki. Ja tsekataanan, rabé chonka koríki kopía, madianita jonibo maromakana iki. Jaskáakin maromakana, moa José Egiptonko bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Jatian Rubenman ja mai kininko joxon oinnabi, moa kini chichó José yama iká iki. Ja yamaketian jaon masá shinankin, jaton axébiribi jaskara iketian, jan sawea chopabi noshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Jatian jaskara ointaanan, jakiribi banékainxon, ja Rubenman jawen wetsabo neskáakin yoia iki: —Ja non wetsara, moa mai kini meran yamake. ¿Jaskara ikenki, rama ea jawe iti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ja Rubenman jato jaskáakin yoia, jawen wetsabaon Josekan tari bixon, cabra bake retetaanan, jawen jimin ja tari sikakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ja Josekan tari yoina jimin sikataanan, jawen papa boxonkana iki. Ja boxoni jaton papaiba kaax nokóxon, ja tari oinmakin neskáakana iki: “¿Natomarin min bake Josekan tari, jokin meraxon non bea?” ikinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jaskáakin yoikana oinxon, jawen bake Josekan tari onantaanan, Jacob iká iki: “Ja riki nokon bake Josekan tari, ja pimís yoinanin piara ibirai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jatianra Jacobnin jawen sawea chopa waxaa iki, itan ja mawákanketian saweti chopara sawea iki, itan basibiresa jawen bake mawata kopí winia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Jatíbi jawen benbo bakebaon itan jawen bake ainbobaonra raromakasa iki, ikaxbira já raromakantinin keenyamaa iki, jaskáyamaira, jawen bake kopí winiresa iki, itan yoyo ika iki: “Nokon bake kopíra ea meketai, ja mawábo ikain jabé iki ea kaai kamanra ikai”, ikinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Jatian jaskati Josekan marotaanan Egiptonko boxon, Potifar maromakana iki. Ja Potifar iká iki, faraón betan iká sontárobaon joni koshi. Jainoaxibi iká iki, jato koiranaibaon joni koshi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Jaskarabo inontianribira, Judá jawen wetsaboibakeax moa wetsanko janbiribi jaai kaa iki. Jara kaa iki, Hirá janeya jonin xobonko, ja Hirára iká iki, adumita joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Jain ixonra, Judakan westíora ainbo meraa iki; jara iká iki cananeo ainbo, Súa janeya ainbaon bake. Ja ainbo teaxonra, moa awinhakin bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ja bixon bakeaa iki; ja bake janea iki Er akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Japekáo wetsa bakearibaa iki, ja bake janea iki, Onan akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Jainxon wetsaribi bakeaa iki, ja bake janea iki, Selá akin. Ja bakeanontianra, Quezibiain iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Jaskara iikinra, Judakan jawen reken bake, westíora ainbo bimaa iki; ja bimaa ainbaon jane iká iki, Tamar. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ja Judakan reken bake Er iká iki, Diossen oinna jawen ikábo jakonma. Jaskara joni iketianra, Ibon moa jamayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Jatian jaskáketian, Judakan aká iki jawen bake Onan neskáakin: —Ja min wetsan kachiana ainbora min biti jake. Ja bixonra, ja min wetsa mawata min bakeaxonti jake, maton axé jaskara iketian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Jaskáati jawen papan yoiabi, ja jawen awin wetsa betan bakeaabo, jawenama iti onanxon, ja ainbo betan yoranaitiibi bakeanaketian wetsankobores boanmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ja Onánman jaskáai Ibon oinna iká iki, jakonma jawéki. Jaskara iketian, Diossenbi ja Onanribi mawámaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Jaskáketian Judakan, jawen baban ewa Tamar yoia iki: —Ramapari jaskara beneomabi min papan xobon jawé; nokon bake Selá aniai kaman —akin. Ja Judakanra jawen baban ewa jaskáakin yoia iki, jawen wetsabo iká keskáribii, jawen bake Selá mawáti shinankin. Ja kopíra, ja Tamar jawen aniboibapari jaai kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Jaskata basi iitira, Judakan awin moa mawata iki. Ja Judakan awinra iká iki, Súakan bake ainbo. Jaskáakin jawen awin mawámaax iiti, moa jawen onís shinan tantipakeaxa, ja Judá kaa iki, Timnat akin akanai jemanko. Ja jemanribira ikana iki, jawen yoina rapéstexonai jonibo. Jatian jain kaaitianra, ja jabé raenanai joni Hirá jabé kaa iki; jara iká iki adulamita joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Jaskara iikinra, Tamarnin ninkata iki, jawen bene ipaonitonin papa Judá, Timnat jemanko kaa. Ja Judá jain kaara iká iki, jawen yoina rapéstexonkana rani bii. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Jatian ja Timnat jemanko Judá joai ninkáxon, ja Tamarnin aká iki wetsa chopa sawexon, ja benomaaxon saweyantana chopa jopékin. Jaskáakin ja chopa jopexon, onankanaketian wetsa chopa sawetaanan, wetsa choparibi biax jan rakótaanan, janribi jawen bemanan mapoa iki. Jaskati chopan mapótaanan, Enaim jemanko iká, jan jikikanai xepótiain yakata iki. Ja xepótira iká iki, Timnat jemanko kati bai kexa iká. Ja Selá moa anii senena ninkáxon, ja biti shinanaxa Tamar jaskata iki; ixonbira jawen papan bimayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Jatian ja Timnat jeman kakin Judakan oinna iká iki, westíora ainbo chopan mapotax yakata. Jaskara oinxon shinanna iki, wetsabires tsini ainbora ibirai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Jaskara ointaanan, jawen baban ewamara ibirai ikax, ja ainbo yakataiba kaa iki. Kaxon aká iki neskáakin: —Eara mion keenai, ¿Minki ea ikintima iki? —akin. Jaskáa ja ainbaon yoia iki: —¿En mia ikinaki, jawe min ea meniti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Jaskáakin ainbaon yoia, Judakan neskáa iki: —Enra mia meniti jake, nokon yoinabo ikáinoa, westíora cabra bakeshoko —akin. Jaskáakin yoia: —Jakon riki —iki iká iki ja ainbo. Jaskáaxonbi yoiribia iki: —Ja cabra bakeshoko min ea bemai kamanpari, min jawékibo ea neno potaxonwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Jaskáakin yokata, Judakan aká iki neskáakin: —¿Jawe jawéki en mia potaxontinkayaki mia keenai? —akin. Jaskáa ainbaon yoia iki: —Ea potaxonwe, min janeya meosoti keská repania teoti betan, min kekóti —akin. Jaskáakin yokáketian, ja yokata jawékibo, Judakan menia iki. Ja yokatabo menitaanan, ja ainbo moa axon, tooya banémaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Jatian moa jaskáa kaxon, ja Tamarnin jakiribi ja benomaayaxon saweti chopa saweribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ja ainbo moa jaskáabaini kaxon, jabé raenanai adulamita joni betan, Judakan cabra bakeshoko, ja ainbo bomaa iki. Ja bomaa kaxonbi, ja ainbo nokoyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ja ainbo nokoyamaxon, ja jonin jain iká jonibo yokata iki, neskáakin: —¿Jawerano kaarin, ja Enainhainoa tsini ainbo, neno bai kexa yakata en oinhibata? —akin. Jatian yoikana iki: Nenora jawetianbi, tsini ainbo non oinyosma iki, akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Jaskáakana ja joni Judáiba karíbaa iki. Kaxon yoia iki neskákin: —Ja min jaiba ea raana ainbora yama ike. Jain ronki, nin westíora tsini ainbobi yamake, ikira ikanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Jaskáaketian Judakan neskáakin yoia iki: —Jaskara iken, ibanon ja en meniibata jawékiabi baneti. Jatianra ja en meniti yoiibata jawéki, paranyamakin en bomaa menikaskin, min rotoa iketian noki shirokantima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Jatian moa kimisha oxe winota pekáo, Judá yoikana iki neskáakin: —Oa min baken kachiana ainbo Tamar ronki, joni betan iorai moa tóoke —akin akana iki. Jaskáakana koshin saí iki, Judá neskata iki: —Jaskara iken, ja ainbo yatanxon, ja jemamea pikotaanan, jiriabi boxon menokanwe —iki iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Jatian moa yataanan retenoxon pikokanaitian, ja Tamarnin jawen bene wayonman papa jato yoimaa iki neskáakin: “Ja nato jawékibaon ibon riki, jan ea tooa. Jaskara iken, oinwe min tsonaborin nato meosoti itan teoti itan nato bastón”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Jaskáakin ja jawékibo onantaanan, Judá iká iki neskati: “Ja aibaonra jakon aká iki, enra jakonma ake, ja nokon benbo bake Selá betan benomayamaa kopí”. Jainoaxa moa jabé oxawetsayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Jaskata iiti, ja Tamar tootax rabébaon bakena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Jatian moa pikókinra westioratonin jawen meken pikoa iki, jatianra ja bakenmaitonin joshin cintan menexa iki, jaskaaxa neskata iki: “Nato riki ja reken pikota”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Jatian ja poyan pikota iwana jakiribi jikiketian, ja rawini japekáo iwana wetsa bake pikota iki. Jaskati japari pikóketianra, jan bakenmaitonin janea iki: Fares akin. Ja iki, ¡jawen wetsa werantaanan japari pikota! iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ja pikota pekáopari, ja joshin cintan nexawana bake pikota iki; ja pikóketian janea iki Zérac akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jatian José Egiptonko bokanketianra, egipcio joni Potifar janeyaton ismaelitaboikea marokin bia iki. Ja Potifar iká iki faraón betan teetai joni koshi, itan, já koirannai sontárobaon koshi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jaskati jaon marokankebi, Diosbi jabé iketian, jawen joni koshin xobon, José jakonbires jaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Jawen joni koshinra onanna iká iki, ja José betanbi Dios iketian, jatíbi jawéki jakonbires jan imaxonai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ja Diossenbira José jaskara imaa iki, jawen joni koshin jaskara jakon iketian noinon ixon. Jaskáakin noia ixonra, jawenabiribishaman joni ixon, jawen tee jakonhakin axonnon ixon, joni koshi jikimaa iki. Jainxon jatíbi jawen jawékibo, jakonhakin koiranxonon ixonribira, joni koshi imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ja Potifarnin, José joni koshi jikimaxon, jatíbi jawen xobon iká jawékiboyabi, jawen banábo itan jawen yoinabo koiranti jaki jenenontianbira, Diossen jatíbinin jakonhakin Potifar akinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Jaskáakin jawen jawékibo José koiranmaa, jakonhakin koiranxonaitian onanax, moa jaakin shinanyamai, pitiakinres shinanni jaa iki. Ikaxbi ja Joséra iká iki, jatíbinin jakon ikax, bakeranon metsáshaman. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Jaskati ja José, moa jato betan basi jaa iitaitianra, jawen joni koshi Potifarnin awin, jaon keeni peokoota iki. Jaskati jaon keeni iikin, wetsa neten ja ainbaon José aká iki neskáakin: —Nokon bachinkopari rakánon kawé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Jaskáti ainbaon yoiabi, jabé jaskátinin keenyamakin Josekan aká iki neskáakin: —Oinwe, ja neno iká jatíbi min benen jawékibo iki, nokonabi keskáabainxon en koiranxonai. Jakopí riki, ja min benen jawen jatíbi jawékibo eki jeneresa. Jaskara ikax, moa jawebi maxkáyamakinra, wetsa jawékiboakin en moa shinanti yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nato xobonra, wetsa ea xewina joni koshi yamake. Jaskáakin joni koshi imataananra, nokon koshin ea yoia iki, nato xobomea jatíbi jawékibo en aresti. Jatian miabiribi iki, ja nokon joni koshin awin. Jaskara ikenbi, mia teaaxa nokon Dioski ea ochati iki —akinra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Jaskáakinbo Josekan ja ainbo yoiabi, netetiibi amakaskin teai, jaiba joi jeneyamaa iki. Jaskatainbi Josekan ayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Jaskara iiti, wetsa neten José kaa iki, ja ainbo jain iká xobon tee akí. Ja xobon tee akai netenribi, tsoabi jain yama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Jaskara iketian, ja ainbaon joxon amakaskin, José jawen chopan yatantoshita iki. Jaskáabi akáshamai jabati kakin, ja ainbaon jan yatana jawen chopa ishtoi kakin, jaki potabaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Jatian ja Josekan jabati kakin, jawen chopa jopébaina, ja ainbaon mekenman baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Jaskati ja chopa tsomaayanix iká iki, Potifarnin awin sion iananbi, jawen xobon iká jawen yonotibo akí neskati: —Jaweatibira non kaiboma ikenbi, hebreo joni nokon benen bexonra, ea keenyamaibi ja jonin ea akeanke. Ja amakashamaira, ea koshin sion ike. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Jaskati ja amakashamai, ea ikonbiresi koshin sion ikaitianra ake, jawen chopa neno potabainkin —iki iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Jaskáxon ja ainbaon aká iki, jawen bene joketian oinmanoxon, Josekan chopa jain benxoakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Jatian jawen bene moa joketian, jawen yanka yonotibo yoiwana keskáribiakin yoii iká iki neskati: —Ja non kaibo ikenmabi, hebreo joni min beyantanatoninra, ea jain oxainko jikixon, ea keenyamainbi yatanxon ea akáswanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ikaxbi ea koshin sion ikaitianra awanke, ishtoi kakin jawen chopa potabainkin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Eara jaskáawanke ja min yanka yonotinin —iki. Jawen awinin jaskáakin Potifar keshana, ikonbiresi sinata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Jaskati sináxon, José preso potaa iki; jain apon joniboribi preso ikanainko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ja Potifarnin jaskáakenbi, Diossen akonbireskin José noikin jeneyamakin, jaskarainoabi akinkin jeneyamaa iki. Ja kopíra Diossenbi amaa, ja presobo koirana jonin, José jaweayamakin jakonharesa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Jatian jaskara iikin, ja presobo koirannai joni koshin, José aká iki cárcel meran ikábaon koshi jikimakin. Jainxon ja cárcel meranxon akanai teeboribi jan jato amaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Jatian ja cárcel meranoa joni koshin, moa jawebi oinyamaa iki, jatíbi jawéki moa Joséki jenea ixon. Jaskara iketianra, Diosbi jabé ixon akinna, Josekan aká jawékibo jatíbi jakonbires iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Jaskarabo iiti, jan jato xeamaibaon joni koshi betan panhakaibaon joni koshin, ja Egiptonkonia apo akonbireskin sinámakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraón, apora, ja joni koshi rabéki sinata iki, ja xeamaibaon koshiki itan ja pan axonaibaon koshiki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","jatianra ja koirannai sontárobaon koshin xobonko jain cárcel ikainko jato niamaa iki. Jainshamanribira José xepokana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ja koirannai sontárobaon koshinra ja joni koshibo akinnon ixon José yoia iki, jatianra ja cárcel meran basi ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Jaskati jain preso iikin, ja apo xeamaibaon joni koshi betan panhakaibaon joni koshin namábekona iki. Ja yamébicho rabéxonbi namábekonara, wetsaresibi namábo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Jatian yamékirishoko Josekan kaxon, ja rabé joni jato oinnara iká iki, jaakinres shinanni onísshoko itinbekona. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Jaskara ja jabé preso oinxon, Josekan jato yokata iki: —¿Jawekopikayaki, itimareshoko mato iibekonai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Jato jaskáakin yokata, rabéxonbi neskáakin yoibekona iki: —Rama yaméra non namáwanke; ixonbira ja non namata jawéki, jawe yoii ikárin ixon noa jan yoiti yamake —akin. Jaskáakin yoibekonketian, jato neskáa iki: —¿Diossenbi mato jaskáakin namámaara ibirai? Ja kopí, ja maton namábekonapari ea yoikanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Jatian ja apo xeamaitonin joni koshinpari, jan namatabo José yoia iki. Ja yoikin aká iki neskáakin: —Ja nokon namá meranra en oinwanke, uva jiwi ebebon chankata; ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ja uva jiwira iwanke, jawen kimisha poyanya. Ja poyanhinoax, wetsa poyan pikotainoaxa iwanke, jawen joabo jokoni. Ja joabo jokontaanan, jabi bimiaxa iwanke, moa ja uva bimibo joshini. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Jatianra iwanke, ja faraónman kenpo en tsomaa. Ja kenpo tsomaatonra en awanke, ja uva bimi joshina bitaanan, ja kenpon potsikin. Jaskáakin senenhataananra, en awanke ja apo faraón en menikin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jaskáakin jaton namá yoiketian, Josekan jato aká iki neskáakin: —Ja min namá riki, neskara yoii iká: Ja min namá meran, uva jiwi kimisha poyan min oinna riki, kimisha nete yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ja kimisha nete senenketianra, faraónman jakiribi min iká jawékibo mia oinni joai. Ja joxon ointaananra, ja min akátiai teeain, jakiribi mia jikimatiki. Jaskáakin jikimaribaara, moa mia ikátiai keskáribii, ja faraónman tee axoni jato xeamaibaon joni koshi mia iribati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Jaskáakin moa jakiribi ja teeain mia jikimaa, ea noibakin ekiakintani shinannoxiwe. Jaskara ixon, faraón ea yoixonoxiwe, nato cárcel meranoa ea moa pikonon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ea riki, hebreo jonibo iká mainmea yometsoxon bekana joni. Jakopíra, jawe jakonmabi akáma ikax, ea neno cárcel meran itima iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Jatian jaskáakin jakonhiraakin, ja namá Josekan yoiaitian ninkáxon, ja panhaibaon joni koshin José yoishokoa iki neskáakin: —Enbiribi namatara iwanke, eaki kimisha joxo tasakan pan bochoaa maia. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ja wetsa tasá bochiki ikára iwanke, meskó keska bata pan bochoya; ja faraón boxonti. Ja bata panbora awanke, isábo bexon en maia tasakameabi pikin —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jaskáa Josekan yoia iki: —Ja min namata riki, neskara yoii iká: Ja kimisha tasá min namata riki, kimisha nete yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Jainoax ja kimisha nete itinra, min ikábo faraónman mia ointi jake. Jaskáaxonra jiwin paninhanan mia reteti jato yoinoxiki, jatianra isábaon bexon min yora pikántiki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Jatian ja kimisha nete itin iká iki, faraónman pikóni nete senenai. Ja nete senenketian, jawen joni koshiboyaxonbi faraónman fiestaa iki. Jatian ja fiestanko bekanabo bebonxonbi, faraónman aká iki, ja cárcel meran niakana jan jato xeamaibaon joni koshi betanbi, jan jato pan axonaibaon joni koshi, cárcel meranoa jato jeman pikomakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Jaskáaxon ja xeati jato xeamaibaon koshi, jakiribi jawen teeain jikimaa iki. Jaskáakin jikima, ja moatianbi akátiai keskábiakin, faraón xeati boxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ikaxbi jan jato panhaxonaibaon joni koshira, risbikan tenéxtaanan jato jiwinko paninmaa iki. Jaskatax, ja Josekan jaton namá yoia keskáshaman senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ikaxbi jato xeamaibaon joni koshi, moa jakiribi jawen teetiain jikixonbi, Joséakintanibi shinanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jatian moa jaskarabo iká, rabé baritia winota pekáo, westíora yamé faraónman namata iki. Ja namá meran oinna ronki iká iki, Nilo janeya paro kexá keníxon oinni chankata. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Jain keníxon oinna iká iki, kanchis waka xoa jakonshamanbo, ja paromeax mapeti. Ja wakabo mapéxon, ja paro kexakea neshan tawa meranoa xobibo piá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Japekáo oinribia iká iki, kanchis waka oshishokobo, ja paromeax mapeti. Jaskara wakabo mapetax, ja xoashamanbo patax, charókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Jatian ja oshishoko waka mapetabaon, ja xoashamanbo pikin keyoai oinna iki. Jaskarabo namá meran ointaanan, moa faraón besoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Jaskataxbi moa jakiribi faraón oxaribia iki. Ja oxaxon namáribia iki, westíora nia trigonimeaxbicho, kanchis texkan jakonshaman jokona. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Jainxon oinribia iki, kanchis trigo texkan, bero chorishamatianbi bari xanan siwáabo ikax bimiomabo. Jaskarara iká iki, bari pikotaiorikeax payákin, bari xanan choshiayona ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Jatian ja kanchis trigo texkan choshishokobaon aká iki, ja jakonshaman texkanbo pikin keyokin. Jaskati oxá besoxon faraónman onanna iki, namáketian iitai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Jaskáakin namáwanxon, moa nete xabáketian jaakinres shinanira faraón iká iki. Jaskati ja shinanyares ixon, ja namá onankaskin jatíbi ja Egiptonkonia onanya joniboyabi onanmis jonibo, jato kenamaa iki. Jaskáakin jato faraónman kenamaa bexonbi, tsonbi ja namá jaskara yoii iká yoiti atipanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Jaskáakin yoiti atipanyamakana ointaanan, ja jato xeamaibaon joni koshin, jatianpari José shinanna iki. Ja shinanritaanan, faraón aká iki neskáakin: —Ramaparira en shinanrike, ea jakonmabires joni baneta. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Jatian mia apo, jato panhaxonaibaon joni koshi betanbi, eki sináxon, noa rabébi ja koirannai sontárobaon koshin xobonko cárcel ikainko min noa raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Jaskara iikinra, westíora yamé non rabéxonbi namábekona iki. Ja jato jan panhaxonaibaon koshin namata iká iki, wetsaresibi. Jatian en akábiribi iká iki, wetsaresibi. Jainoax ja namáboribi iká iki, wetsaresibi jawéki iti yoii ikábo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Jaskara non namánontianra, jainribi nobé preso iká iki, westíora hebreo bakeranon. Ja bakeranonra iká iki, sontárobaon joni koshin ináabainxon yanka yonoai. Jaskáakin namatabo, ja bakeranon non yoiara, jaskara yoii ikábo noa onantiakin jan yoipakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Jatianra jan non namábo noa yoipakexona keskáshamanbo senena iki. Ja namábo noa jan yoia keská senenmakinra min aká iki, eabiribi nokon tee ikatiain jikimaxonbi, ja wetsabiribi jato nishin tenexmaxon paninhanan min jato retemakin —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Jaskáakin yoiatianbi, cárcel meranoa José pikoxon bexonkanti, faraónman jato yoia iki. Ja faraónhiba joti yoikana benxokaakin, Josekan jawen kenibo oroxon, bená chopabo saweyontaanan, joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ja José moa joketian, faraónman yoia iki, neskáakin: —En namatabora, ea tsonbi ja yoii ikábo onantiakin yoiti atipanyamakanke. Jaskara ikenbira ea yoikanke, namábo mia yoikanketian, jaskara yoii iká riki, ixonbo min jato yoiai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jaskáakin yoia José iká iki neskati: —Jaskara namábo en onantiakin yoiaibo riki, Diossenbi amaa en akaires; jaskara ixonra, jan amaares min onannon ixon mia en yoiti atipanke —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Jaskáketian faraónman aká iki, José neskáakin: —Nokon namá meranra ea iibake, Nilo janeya paro kexá ea chankata. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ja paromeaxa ibake, kanchis waka xoa jakonshamanbo pikoti. Jabo pikotax mapéxonra aibake, ian kexa xoxoai neshan tawa keská xaranmea xobibo pikin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Jatian ja xoashamanbo pekáora iibake, kanchis waka kikinbires jakonma oshishokobo bei. Jaskara wakabora, nin jawetianbi Egipto mainmea en oinyosma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ja oshishoko waka beabaonra aibake, ja jatonpari mapéwana xoa itan jakonshaman kanchis wakabo pikin keyokin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Jaskáakin ja xoashaman jabé wakabo piaxbira iibake, ja oshishoko wakabo piama keskábiresbo ikax, jaskara oshibiresbo. Jaskara oinkin senenhataananra, ea moa jakiribi oxá besoibake, ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","jatian jakiribi moa oxaribixonra en namáribiibake, westíora trigo taxomeaxbicho, kanchis texkan jakonshamani bimiax paniabo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Jainxon ja namá meranribira en oinhibake, westíora trigo taxomeaxbichoribi, kanchis texkan jakonmai bimia. Ja texkanbora ibake, bari pikotaiorikeax xana payataitonin choshia ikax, siwáshokobo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ja trigo texkan siwáshokobaonra aibake, ja jakonshaman texkanbo pikin keyokin. Jaskarabo namáxon onankaskin, ja onan jonibo kenamaxon en jato yokatabira, ea tsonbi onantiakin yoiti atipanyamakanke —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jaskáaketian Josekan faraón yoia iki: —Ja rabé keská min namata riki, westíora jawékibicho iti yoii iká. Diossenra jan akí kaai jaweki mia keshanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ja kanchis waka xoashamanbo min namata riki, kanchis baritia yoii iká. Jatian ja kanchis trigo texkan jakonshaman min oinna riki, ja kanchis baritia yoii ikáribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Jainoax kanchis waka jakonma oshishokobo min oinna, itan ja kanchis trigo texkan bari pikotaiorikeax xana payataitonin choshia min oinna riki, kanchis baritia jawékiatinin ikanti yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ja jaskara namábo oinmaxonra, Diossenbi ja apo onanmaa iki, jaskara jawékibo janbi imai kaaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Jaskara ikenra, ja Egipto main kanchis baritia senen, yoábo kikinbires icha iki kaai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Jatian jaskata pekáora, kanchis baritia senenribi yoábo iamaitian, jawékiatin ikonbiresnoxikanai. Jaskati jawékiatinin iorakinbira, jonibaon onanyamaresti iki, jaskara moatian ikátiimabira, Egipto main iorai jawékiatinin ikí bonoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ja Egipto mainmeax ikonbiresi jawékiatinin ititianra, ja moatian icha jawékiati jakátiaibaon moa shinanbenokanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ja faraónman rabéakin namatara, jaskara iti yoii iká namá rabébires iki. Jaskara itibora, Diossenbi moa basima imati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Jaskara iken, jakonkayara iti iki, mia apo ixon westíora onan joni, itan shinanya joni katóanan, nato Egipto main iká jonibo jan jato ikinnon ixon, min koshi jikimati. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Jakopíra, mia apo ixonkaya min ati jake neskara: Minra joni koshibo janepakeanan, jato raanti jake, ja Egipto main iká jatíbi jemabaon. Jain kaxonra, ja kanchis baritia senen yoá icha inontian tsinkikana yoábo, pichika tsamáinoa westíorabo jato bichinkanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Jato bichinxon bexonra, jainbicho tsinkianan tsamankanti jake, jainoa jaton apon jaskaakin ati jato yoinon ixon. Jaskáaxonra ja Egipto main iká jemabaon jaa jonibo, jato jawékiamakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Jaskáaxonra, jato bichina yoábo, ja Egiptonko iká jeman benxoakanti iki. Jatianra ja kanchis baritia yoakan ititian, moa jonibaon ja jawékiakantibo jati iki —akinra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Jaskáatibo Josekan jato yoia, ja faraón betanbi jawen joni koshibaon shinanna, kikinbires jakon jawéki iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Jaskáakin jawen namá yoia moa onantaanan, faraónman jabé ikábo neskáakin yoia iki: —¿Maton shinanaki, nato bakeranon keskáribi, Diossen shinanman iboaa wetsa joni non merati atipana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Jatian ja Josébiribi faraónman neskáa iki: —Mia keská Diossen onan shinanya jonira, tsoabi yamake. Miabicho riki, jaskarabiribi iti Diossenbi imaa ikax, jato onanai joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Rama netenbira, nokon toan ea jain iká palacionko mia joni koshi en imai. Jaskáakin joni koshi en mia imaketianra, jatíbi min yoia joibo, nokon jonibaon mia ninkáxonti iki. Eabichoresa, apo ikax mia xewina joni koshi iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Egipto main iká jatíbi jonibaon koshiribira en mia imai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Jaskáataanan, jawen metotiainoa jawen janeya meosoti tsekataanan, faraónman José sawemaa iki. Jainxon lino aká chopa kikin kopí itan jakonshamanribi, oro teoti betanbi bexon José sawemakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Jaskáakin senenhataanan, ja apo jan kaai carro pekáo wetsa carro ikátonin, moa apo keska itiribi janea iketian, José nanémaa iki. Ja nanémataanan boí, jabé boai apon joni koshibo ikana iki neskati: Jainra apo kaai, “¡bai xepoyamakanwe!”, ja apo mato ponte winotaitian rabii já bebon chirankookanwe, iki saa iibainkana iki. Jaskataxa Egipto main iká apon koshi jikimaa, José jain baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Jainxon faraónman José yoiribia iki neskáakin: —Ea riki, Egipto mainmea apo. Jaskara ixon riki, en mia joni koshi jikimaa. Jaskara mia joni koshi iketianra, jawékibo anoxon miapari yokákanti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Jainxonribira faraónman, wetsa jane José menia iki. Ja jane menia iká iki, Zafnat-panea. Jaskáakin janetaanan, Potiferanin bake ainbo Asenat awinhanon ixon bimaa iki. Ja Potiferara iká iki, On jemamea sacerdote. Jaskata pekáora, Egipto mainmea jemabotiibi José kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joséra kimisha chonka baritiaya iká iki faraónhiba bokanontian. Ja apoibakeax pikótaananra, jatíbi ja Egipto main iká jemabaon kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ja José Egiptonko joni koshi inontianra, kanchis baritia senen kikinbiresi banábo jakonshamani xoxoax, ikonbiresi bimia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ja banábo kanchis baritia senen, ikonshamani bimiketian tsinkixonra, Josekan aká iki ja Egipto main iká jemabotiibi ja jawékiati janon ixon, jato benxoamakin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ja Josekan jato tsinkimaa trigo, tsonbi topontimatii kikinbires icha ikaxa iká iki, aniparo kexá iká mashitiibires. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Jatian jawékiatinin iti peokootamatianra, Josekan jawen awin Asenat betan rabé bakeaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ja reken pikota jawen bakera, Josekan janea iki, Manasés akin. Jaskáakin jawen bake ja janen akira iká iki, neskati: “Diossenbira ake, jatíbi ea onitsapita jawéki en shinanaibo, ea shinanbenomakin. Jainxonribira ake, ja nokon kaibobo onitsapitai en shinanai shinanboribi ea shinanbenomakin”, iki iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Jatian ja jawen wetsa bake pikota, Josekan janea iki, Efraín akin. Ja janeira iká iki José neskati: “Ea onitsapita mainxonra nokon bakebo ea Diossen menia iki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Jaskata iitira, moa kanchis baritia senenketian, ja icha jawékiati japachoaibo moa keyota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Jatian ja icha jawékiati ipachoai keyota pekáobiribi, moa jatíbiain jawékiatinin itibiribi peokoota iki. Jaskati jatíbiain jawékiatinin ikanainbi, Egipto mainbiribi icha jawékiati ja iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Jaskati ja Egipto main iká wetsa jemabo, moa jaton jawékiati keyoax, jawékiatinin iki peokooti faraónhiba yobeni bokana iki. Jaskati jaiba bokanketian, faraónman jato aká iki: “Joséiba kaxon jan yoia keskábo axontankanwe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Jatian jaskati moa jatíbi ja Egipto main iká jemabaon jawékiatinin ikanaitian, jain jawékiati benxoaabo jokonhaxon, ja Egipto jonibo Josekan jato maromaa iki. Jaskáakin Josekan jato akinabi, bebonbires jawékiatinin ibotankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Jaskara iketian, jatíbiainoax trigo maroi Egiptonko José ikain bekana iki. Jatíbiainra kikinbiresi jawékiatinin ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jatian jaskati jato iká main moa yoábo yama inontianra, Jacobnin ninkata iki, Egipto main icha jawékiatia ikanai. Jaskara ninkáxon, jawen bakebo yoia iki neskáakin: “¿Jaweakikayaki, jawe akímabi manaanani mato neno oinhananreskanai?” ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Enra ninkáke, Egipto main icha jawékiatia ikanai. Jaskara iken, non ja jawékianon jain boxonpari, trigo marokin bitankanwe; noara pitin retenake, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Jaton papan jato jaskáakin yoia, ja chonka Josekan wetsabo bokana iki; Egiptonkonia trigo maroi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jaskati jawen wetsa bakebo trigo maroi bokanainbi, Jacobnin jawen bake Benjamínbicho jato betan raanyamaa iki; jain kaax jakonma winóti shinankin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ja trigo maroiribi, wetsankonia jonibo bokanaibo betanra, ja Israelnin bakeboribi bokana iki. Jainra bokana iki, ja jain ikana Canaán main, moa jawe jawékiatibi yamaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jaskarabo inontianra, jainoa joni koshi iti José jikimakana iká iki. Jainoax jaribira iká iki, wetsankoniaxbo trigonin maroi beaibo jato jan maromai. Jaskara iketianra, ja trigo maroi boax Joséiba nokótaanan, jawen wetsabo ja José rabii, ja bebon chirankotaanan, maikibi bekepikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Jaiba nokókanatianbi, jato ointaananbires Josekan jawen wetsabo onanna iki. Jaskáakin jato onanaxbi, ja jawen wetsabo onanama keská José iká iki. Jakopíra, notsinbainhanan yoikin jato aká iki neskáakin: —¿Jaweranoaxki mato bekana? —akin. Jato jaskaa ikana iki neskati: —Noara Canaán mainmeax bekanke trigonin maroi —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josekan jato onankebi, jawen wetsabaon ja onanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Jatian jawen wetsabo jaskáketian, Josekan shinanria iki, ja moatian jatokiriakin namáyantana jawéki. Jaskara shinanrixon jato yoia iki neskáakin: —Mato riki, jaweraoxonki non jato peotiki ixon, nato jema paranaxon oinni bekanabo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Jato jaskáa yoikana iki: —Mato jaskáai noa joáma riki. Noa min yonotibo riki, neno trigo icha yoikanai ninkatax, jan maroi bekanares. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Noabo riki, westíora jonin bakebicho. Noara ikon jakon jonibo iki. Jaskara ikaxa, jawetianbi paranaxonbo ointaanan, non jato ramiaisma iki —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jaskáakanabi Josekan jato yoia iki: —Enra jawekeskáaxonbi mato ikonhayamai. Matobo riki, paranax nato jeman weixon, jaoraoxonki non jato ramiatiki ixon, noa oinni bekanabores —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Jaskáabi José yoikana iki: —Noa min yonotibo riki, chonka rabé bake; westíora jonin bakebicho. Jainoax noabo riki, Canaán mainmea jonibo. Ja non wetsa chiníbichora, non papa betan jainbi banéke; ikaxbi ja wetsaresa moa yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jaskáakanabi jato yoiribia iki: —Matobo riki, ja moa en mato yoiwana keskábi, paranaxon non jema oinni beabores. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Jaskara iken, ja maton ea yoiaboki ikon iki ixon onanoxonra, rama en mato neskáai: Ja faraónbicho riki, neno ikábaon joni koshi. Jakopíra, en mato paranyamakin ikon mato yoiai maton onannon ixon, ja faraón janebainkin en mato yoiai. Ja joyamaa maton wetsa chiní neno beyamaaxa, mato jawekeskataxbi nenoax kayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Jaskara iketianra, ja maton wetsa chiní biti, maton westíora raanti jake. Jatian mato neno banetaibobiribira, ja maton wetsa chiní beai kaman, en mato xepoti jake. Jatianparira en mato ikonhati jake, jatíbi maton yoia joibo. Ikaxbi jaskáati en mato yoiabo maton senenhayamaketianra en onantiki, paranaxon non jema oinni mato joáres —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Jato jaskáakin yoitaanan, kimisha nete senen, Josekan jato cárcel meran xepoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Jatian jato cárcel meran xepoibata moa kimisha nete senenaitian, Josekan moa jato pikoa iki. Jato pikotaanan yoia iki: —Eara Diossen ratetai joni ikax, jawen keena keskáres axoni jaa joni iki. Jaskara iken, ja maton ea yoia keskábo maton senenhaketianra, en mato jawebi shinanxontima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ikon jakonbo ixonra, maton wetsa westíora, neno cárcel meran maton potabainti jake. Jatian mato jatíribibora, maton itinko banéibatabo jato jawékiati boxoni moa kati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ikaxbi ja maton wetsa chiní baneta maton yoiibatara, jakiribi jokin maton ea bexonti jake. Já maton beketianparira en mato ikonhati iki, ja maton yoia joibo ikon iká. Ikaxbi ja maton yoiabo senenhayamaaxa, mato mawáti jake —akin jato aká. Ikonrake non abánon ja min yoia keská, iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Jaskáakinbo jato yoia, jatonbiribi ikana iki neskati: —Ja non wetsan jaskáatima noa yoiabi, noibayamakin akonbireskin ramiakin onitsapimani ikaxiki, noa jaskaraton ikonbiresi ochaa. Ja non jaskáani kopí riki, ramabiribi noki jaskara jawéki nokota —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Jatian jaskákanaitian jawen wetsabo, Rubenman jato neskáa iki: —Neskarabo inaketian, ja non wetsa maton retekaskin ramiaitian, atima en mato yoiabi, maton nokon joi ea ninkáxonyamaa iki. Ja maton jaskáani kopí riki, ramatian noabiribi masá tenei, ikonbiresi noa onitsapikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ikaxbi jabaonra onanyamaa iká iki, ja Josekan jaton joi ninkatai. Jaskarara shinankana iki, ja Josekan jato yoyo akin, wetsa joni jato yoimaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jatian jato jaskáai iitibi, jato oinnax onisi, jato jenebaini wetsaori kaax, José winia iki. Ja onisi winii senentaanan, jakiribi joríbaxon, jatíbi ja jain ikábaon jishnonbi, ja Simeón jato yatanmataanan cadenanin axon, cárcel meran jato niamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ja Simeón cárcel meran jato niamaa pekáora, Josekan jawen joni koshibo yoia iki, jaton sakobaon jato trigo bochoaxonti. Ja bochoaa pekáo, jan trigo kopíakana koríkiboribi, jaton sacobaon jato niapakexonti jato yoia iki. Jainoax jaton itinko kakin, ja jawékiakantiboribi jato axonkanti yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Jaskáakin ja trigo saco menikanabo, jaton asnobaon moa petsámankin senenhataanan, ja Josekan wetsabo moa bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ja bobóbaiti moa yantan iketian, jain iakexon westíoran aká iki, jawen asno pimanoxon, jawen saco techorokin. Ja techorokin chichó meraa iki, ja trigo bikin jan kopíaibata koríki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ja koríki meraax ratékin, jawen wetsabo aká iki: —Oinkanwe nato nokon koríki ea banexonkana. Nato nokon saco techórokinra en merake —akin. Jato jaskáakin yoia rateti, jatonbiribibo yoyo iki ikana iki neskati: —¿Jaweatimein noa Diossen jaskáake? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Jatian moa jakiribi ja Canaán main kaax nokóxon, jawen bakebaon Jacob yoikana iki, jatíbi jaskara winókana jawékibo. Jaskarabo yoikin, jaton papa akana iki neskáakin: ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Ja Egiptonko joni koshi jikimakanaiba kaax, noa nokóketianra noa aibake, non yoyo akabi jakonma koshi joinres noa aboankin. Jaskákin noa aibake matobo riki, paranaxon noa ramianoxon, non jema oinni bekanabo, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Jaskáakinbo noa yoiainbira, nonbiribi aibake, noara ikon jakon jonibo iki. Jainoax paranaxonboribira, jawetianbi jato ramianoxonbo jaton jemabo non oinyosma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Noabo riki, westíora papabicho; ikaxbi chonka rabé bake. Jatian westíora non wetsaresa, moa nobéma iki. Ikaxbi ja non wetsa chiníshokoresiki, ja non papa betanbi Canaánhin baneta, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Non jaskáakin yoiara, ja Egiptonko joni koshi imakanatonin noa aibake neskáakin: ‘Ikon jakon jonibo ixonra, maton wetsa westíora neno maton ea potaxonti jake. Jatian matobiribira, ja maton xobon banetabaon jawékiati, jato boxoni moa kati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ikaxbi jakiribi joríbakinra, ja banéibata maton wetsa chiníshoko, maton ea bexonti jake. Já maton beketianparira en ikonhati iki, ikon jakon jonibo ixon, maton ea paranyamaa. Jatianribira ja neno en mato banenanhibata maton wetsa, en mato pikoxonti iki. Jainoax jatianribira, jakonshamanax neno mato jawékininbo maroti iki, akinra noa aibake’ —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Jaskáakin jaton papa yoikin senenhataanan, jatíxonbi jaton sacobo nasii akin, ja trigo marokin kopíaibata koríkibo, jaton sacon iká merakana iki. Ja koríki pishabo jaton sacon iká meraax, jaton papa betanbi jaskarabo meraax, ikonbiresi ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jatian ratékin, Jacobnin jawen bakebo neskáa iki: —Ja maton wetsabo bokinra akai, maton ea jato keyonanpakebireskin. Ja Josépari maton aká iki, manómakin. Jatian ramabiribi maton ake, Egiptonko ioxon presoakanketian, Simeón potabeirankin. Ja senentiainbi, rama ja Benjamín boribakasi mato iitai. Ja maton wetsabo maton jaskáaitoninra akai, maton jatíbitian ea jakonma imakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Jaskáketian Rubenman jawen papa yoia iki: —Ja min bake Benjamín iká jawékibo en oinbanon, eki jenewe, papá. Enra mia jakiribi bexoni kaai. Ikaxbi jaskáakin yoixonbi, en Benjamín mia bexonyamaketian, nokon bake rabé ea retenannoxiwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jaskáakin yoiabi, Jacobnin jawen bake aká iki: —Ja min wetsa nokon bakera, jawekeskáaxonbi en mato raanxonyamai. Oinwe, ja min wetsa José iki, moa mawata yama. Jatian ja min wetsa Benjamínbicho iki, rama neno ebé jaa. Ja maton wetsa Benjamínribi, maton ioa kaaibi jakonma winóketianki, mato jawe iti iki. Ja nokon bake chiní, maton boxon jaskámaa kopíra, ea yosishoko ikax iti iki, jaskaraton masá shinanni onisi mawákasi —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Jaskarabo inontianra, Canaán main iká jonibo, bebonbires jawékiatinin iki iiboreskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jatian ja Egiptonkonia trigo beyantankana moa keyotaitianra, Jacobnin jawen bakebo yoia iki: —Jakiribi trigo marokin bii boribatankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Jaskáaketian Judakan jawen papa neskáa iki: —Ja trigo maromataanan raankinra, ja Egiptonkonia joni koshin onantishamanhakin noa yoia iki: ‘Jakiribi jaiba kakin, non wetsa chini boyamaax, moa jaiba noa nokótima’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Jaskara iken, ja non wetsa chini min nobé raanaitianparira, noa jakiribi Egiptonko trigo maroi kati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ikaxbi nobetan ja non wetsa min raanyamaitianra, noa jawekeskataxbi kayamai, papá. Ja jainoa koshinra, noa joaitian ayantanke yoikin: ‘Non wetsa chiní boyamaax, moa jaiba noa nokótima’ —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jaskáaketian ja jaton papa Israelnin jato aká iki neskáakin: —¿Jaweatikayaki, ja joni koshin mato yokataitian, non wetsa chiníra jake, akin maton aká iki? Jaskaaxonpachora akai, maton ea jakonmabires shinanmakin —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Jaton papa jaskáketian neskáakin yoikana iki: —Ja joni koshin meskóakinbo noa yokáketian riki, non jaskáakinbo yoia. Jishaman jaskarabo yokákin noa aká iki: ‘¿Maton papaki japaria? ¿Maton wetsa neno joámaki jaríbaa?’ akinbo. Jatianra nonra onanyamaa iki, jaskáakinbo yokáboxon, ja ‘maton wetsara maton ea bexonti jake’, akin noa ati —akin jaton papa akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Jatian Judakanbiribi, jawen papa aká iki neskáakin: —Moa noa kabatanon, nato bake moa nobé raanwe. Ja bake nobé kaketianra, enbishaman já koiranti jake. Jatianresa mia, noa, itan non bakeboribi mawáyamai japarikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ja min bake en boá jawekeskabo winóketianra, ea iti jake ja min bake kopi min ea ramiati. Jakiribi ja min bake mia neno banexonyamaxonra, en ati jake jatíbitian ja ocha kopi masá tenekin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Jaskáyamakin moabi ja bake nobé min raanhibaketianra, moa rabeti kaax noa joríbaa ikeanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Jaskáketian jawen papan neskáa iki: —Moara wetsa keska shinanbo non ati yamake. Jaskara iken, ramapari mato jaiba kaai joni koshi, maton sacon jawéki axon boxontankanwe. Ja maton boxonaibora iti jake, ja nenonxon non akai kikin jakon jawékibo. Ja maton boxontibora iti iki: Ichama bálsamo, ichama mishkin, meskó inintibo, mirra, castaño bimibo itan almendro bimibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Jainoax ichachashaman koríkiribira, maton boxonti jake. Jainoax ja maton saco meranoa maton meraibata koríkiribira, boxon maton jabishaman meniti jake. Jawekeska ikaxa, shinan benoxon mato axonabira iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Jaskara iken, ja joniiba moa botankanwe; kakin atankanwe ja maton wetsa iokin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ja mato jaiba kaai, joni koshiiba nokóketian, abánon ja koshi shinanya Diossenbi noibataanan onísaxon, mato akinkin. Jainxon abánon, ja cárcel meran iká min wetsa pikotaanan, ja maton ioai maton wetsa Benjamínribi jaweamayamakin. Jatian ea jawekeska bakeoma banéti ikax, ibanon jaskarabiribi ea baneti —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jaskáketian ja Jacobnin bakebaon, ja joni koshi boxonti yoiibata jawékibo moa biax bokana iki. Ja moa bokin, ja ichashaman koríkiabi, jaton wetsa Benjamín iokana iki. Jaskati boax Egiptonko nokótaanan, Joséiba bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ja boax jaki nokoti bokanaitian, Benjamín jato betan kaai Josekan meraa iki. Ja meraxon, jawen xobon iká jawen yonoti joni koshi yoia iki: —Nokon xobonko nato jonibo iotanwe. Jain kaxonra, westíora waka min reteti jake; nenoax kaxon bariapan en jato betan pinon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Jatian jawen yonotibaon joni koshin, jan yoiwana keskábo José axona iki; jaskáxon janbishaman jato ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Jaskáakin jato ioabi, Josekan xobo iketian onanax, ikonbiresi raketi, jatonbiribibo yoyo iibainkana iki neskati: —Paranxon ja xobon noa boí riki. Ja reken trigo maronontian, ja koríki noa banexonkin, non saco meran noa niaxonyantana kopíra ibirai, neno noa iwekana. Iamaxon non yoinayabi noa iboataanan, kikinhakin yankabires yononoxon noa bearibira ibirai —ikibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Jaskáakin jato boá kaxon, jain kaa xobon jikiamatianbi, jan jato ioa Josekan yonotibaon joni koshi betan yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ja yoyo akin akana iki neskáakin: —Oinpariwe ibó, minra moa onanke, noabo riki ja miibakea jawékiati maroi noa beibataboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ja jawékiati min noa menia nenoax noa kanontianra, moa yantan iketian oinnax, moa jain iakea iki. Jain iakexon, ja non boai trigo sacobo techóroxon non oinnara iká iki, koríki pishabo ja meran iká. Ja koríkibora, ja iantanatiibi iki; ja banenoxonra non neno beke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Jainxonra non koríki beke, jakiribi nenoa trigonin maronoxon. Ixonbira non onanyamake, tsonkaya ja non saco meran ja koríkibo noa niaxonaki iantana ixon —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Jaskákanketian, ja Josekan joni koshin jato neskáa iki: —Rakéyamakanwe, jakonreskaya shinankanwe. Jawekeska ixonra, maton Diossen itan maton anibaon Diossenbira, ja koríkibo maton sacobaon mato axonhibake. Ja trigo bikin, maton kopíayantana koríkibora en biantanke —akin jato aká iki. Jato jaskáakin yoitaanan kaxon, ja cárcel meran iká Simeón pikotaanan, jato ikanainko ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Jaskáa pekáo, moa jatíbi jato Josekan xobonko ioa iki. Jain moa jato ioxon, jan tachokiikanti onpax jato menia iki. Jainxon jaton yoinaboribi jato pimaxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Jatian jabaon moa onanna iká iki, Josekan jawen xobonxon jato betan bariapan pii joai. Jaskara onanxon, ja José menikanti jawékibo benxoakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ja José moa jato betan jawékiai bariapan joketianra, ja meniti bokana jawékibo moa menikana iki. Ja jawékibo meniamatianbi, ja rabii ja bebon chirankotaanan maikibi bekepikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Jaskákanketian, Josekan jato yokata iki: —¿Matoki jakontani iantana? ¿Ja maton papa yosishoko maton yoiantanaki jaresparia? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Jato jaskáa, joni koshi ikax jato betan senenma iketian, jakiribi já bebon beobainkana iki. Jaskátaanan yoikana iki: —Ja non papa, noa keska noibatishokoribira, jain jakontanibires iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Jaskáakin yoikana, oken oinbekonkin jain jato betan Benjamín itina Josekan meraa iki. Ja Benjamínra iká iki, jawen tita betanshaman jawen papan bakeaa ikax, jawen wetsabi. Jatianra iká iki José neskati: —¿Natokayarin maton wetsa chiní, já yoikin maton ea ayantana? —iki. Jato jaskáakin yoitaanan, ja Benjamín Josekan neskáa iki: —Mia Diossen noibataanan akinbanon, baké —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Jaskáakin yoixon, jawen wetsa ointaanan José ikonbiresi onisa iki. Jaskáakin onisen yatannatianbi, jawen xobon ishtonbires jikiax, José winia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ja winii senentaanan, winia onanti inaketian bechokiitax, joribaxon jato yoia iki: ¡Moa pikánon jato metexonkanwe! akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Jatianra moa pikin peonoxon, wetsa mesan jawen piti José axonkana iki. Jatian ja Jacobnin bakebobiribi, wetsa mesan axonkana iki. Jainxon ja Egipto jonibobiribi, jatonbiribibo axonkana iki; jaton axé meran, hebreo jonibo betan pitima yoiai iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Jatian pikin peoamatianbi, Josekan jawen wetsabo beibanamakin jato yakámaa iki. Jaskáakin jato yasánkin aká iki, jaton rekenhainxon peoxon, jaton wetsa chiní senen jato yakámakin. Jato jaskáakinbo yasánketian ointaanan, ratébainax beísanankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Jato jaskáakin moa yasántaanan, Josekan aká iki, jawen wetsabo yakákana mesanko, jawen yonotibo piti bomakin. Ixonbi ja Benjamínbiribi, jawen wetsabo axona bebonbires icha piti axona iki. Jatian jaskáakin jawen wetsabo betan moa jawékiaax, José raroshaman iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jaskarabo iká pekáo, jawen yonotibaon joni koshi, Josekan yoia iki: —Nato jonibaon boti senenbopari, jaton sacobaon trigo bochoaxonkanwe. Jainxon jaton saco bemakayanribi, jan kopíakana koríki pishabo jato niaxonkanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Jainxon jaton wetsa chinikan sacon niaxonwe, nokon yami kenpo betanbi jan trigo kopíakana koríkiribi —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Jatian wetsa nete xabata yamékirishoko, jaton asnoboyabi moa bokanaitian, Josekan jato raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ja moa bokana pekáo, ochókanamabi Josekan jawen yonoti joni koshi neskáakin yoia iki: —Ja bokanabo ochóira bokanamabipari, jato chibantanwe. Nokoxonra, min jato yoiti jake: ‘¿Jaweatiki nokon Ibon mato jakonhaabi, maton jakonmaabeirana? Matonra jawen plata kenpo yometsokin beke’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ja kenpora, jan nokon joni koshin xeai iki. Jainoax ja kenpon axonribira akai, rama iti jawékibo onankin. Jaskara ikaxa, ja maton akábo, kikinbires jakonma jawéki iki akin jato anoxiwe —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Jaskáakin Josekan yoia kaxonra, jato nokotaanan, ja yoiwana joishamanribi, jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Jatianra jabaon yoia iki: —¿Jaweatikayaki, jaskara joibo yoikin min noa jeneyamai? Jawetianbira, non jato jaskáayosma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Jishaman, nenoa trigo marobaini kaxon non ayantanke, Canaánhin kaxon, non saco meranoa koríki merakin. Ja koríki iboayamakinra, jakiribi neno jokin non mato banexonhibake. ¿Jaskata ikaxbiki, jawekeskati ja min Ibon xobon iká koríki, itan orobo noa yometsotiki? ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Jawekeska ixon, ja manota jawékibo benakin atiki, ja neno noa iká westíorainoa min nokokin. Jatianra ja jainoa min nokoa joni, moa retekanti iki. Jainoax jatíbi noaboribi, min kikinhakin yanka yonotibo noa iti iki —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Jatian Josekan yonotibaon joni koshin yoia iki: —Ikonrake; ja maton shinanna keskáakinra en mato ati jake. Ikaxbi ja plata kenpo en jaibakea meraibichora, nokon yonoti iki kaai. Jatian mato jatíribibora, jawe ramibi akáma keská mato ikanti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Jaskáakin jato yoiatianbi, jaton asnon iká sacobo manhaxon, jatianbi techórokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Jatian jaton sacobo moa techórokanketianra, ja joni koshin aká iki, jaton sacobotiibi plata kenpo benakin. Ja moa benakin peokin aká iki, jaton wetsa rekeman saconkoxon peoxon, jaton wetsa chinikan saco kaman. Jaskáakin sacobotiibi benabokin meraa iki, jaton wetsa chiní Benjamínman saconkonia. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ja Benjamínman saco meranoa meraketianra, jatíxonbi jaon masá shinanai onanti inon ixon, jaton sawea chopabo noshikana iki. Jaskatax jaton sacobo asnon ataanan, jakiribi Egiptonko banébainribikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jaskati boax, jawen wetsaboyabi Judá, Josekan xobon bokana iki. Ja boax nokotax, José bebon chirankootaanan maikibi bekepikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jaskákanketian, Josekan jato yoia iki neskáakin: —¿Jaweati maton ea jaskáarin? ¿Matonki onanyamaa, ea jaskáaibo en shinanmanres jato onanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Jatian jato Josekan jaskáaketian, Judakan aká iki neskáakin: —Non riki, jawe jakonmabi akáma. Ikaxbi jawekeskaakinshaman yoiananra, miabira non ikonhamatiki, non jakonma jawékibo akáma ixon, non mia yoiabi min noa ikonhayamaitian. Ikaxbi Diossen oinnaribi moa non, jakonma jawéki akona ikaxa, ja jaibakea min kenpo meraa betanbi, jatikaxbi noa min kikinhakin yanka yonotibo iki noa bokanai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Jaskáabi Josekan jato neskáakin yoia iki: —Enra jatíbi mato jaskáayamai, ja plata kenpo en jaiba nokoaresa, nokon yonoti ikai. Ikaxbi mato jatíribiboresa, moa tsonbi jaweayamaa, maton papaiba mato jakonbires bokanti jake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Jatian jaskáakin jato yoia, Judá Josékirikaina iki, jakikainxon neskáakin yokata iki: —Ibó, rama riki ea mibébiribi beibabanax yoyo itin keeni; ¿Eaki iti atipanyamaa? Ibó. Ikaxbi en mia jaskáakin yokata, eki sináyamawe. Miabi Faraón shinanbainkinra en mia jaskáai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Minra noa yokata iki, noaki papaya iki, iamaax nobé joyamaa non wetsaki jaa, iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Min noa jaskáketian mia non yoiantanke, jaráke non papa yosishoko, itan non wetsa chiní bakebires, akin. Ja non wetsa riki, yosishokoxonbi non papan bakea. Jakopíra, kikinbiresakin noike, ja wetsa mawata toan jabicho baneta iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mia jaskáakin non yoia, min noa ayantanke, ja non wetsa chiní min onankasai kopí, ja bexonti noa yoikin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Jatianra non mia aká iki, ja non wetsa chiní, mia non bexonabira, já kikinhakin noia ixon, jaon akonbireskin masá shinanni, non papa mawárestiki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Jaskáabi min noa yoiribia iki: Ja non wetsa chiní mia non bexonyamaketian, jawekeskáaxonbi jakiribi noa miiba joketian, moa min noa bitima. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Min noa jaskáa kaxonra, jatíbi min noa yoia joibo rebéstankin, non papa non keshana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Jatianra non papan noa yoia iki: ‘Jakiribi trigo marokin bii botankanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ikaxbi non yoia iki: ‘Ja non wetsa chiní boxonti, joni koshin noa yoia ikaxa, noa jawekeskataxbi jayáoma kati atipanyamake. Jayáoma noa kaketian ronki, jawekeskáaxonbi ja moatian ayantana keskáakin, noa biribatima iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Jaskáakin yoiabi, ja non papan noa aríbaa iki, neskáakin: ‘Matonra ake kikinhakin onankin, ja nokon awin Raquel betan en rabé bakea. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ja nokon wetsa bake eibakeaxbi moa manota iketianra, moa jawetianbi en oinyosma iki. Jaskara iketian en shinanai, ja nokon bakera, moa pimís yoinabaon piá iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Jatian nato ebé iká nokon jabicho bake texea boxon, maton jakonma winómaketianra, ea yosishokoira ikax, jaon masá shinanni ea mawáresti iki’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Jaskara iken, rama ja nokon papaiba karíbakin, nokon wetsa en boxonyamaara, jabébiribi jaxon ayorakin noia ikax, ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ja nokon wetsa ebé kayamai ointaanan, nokon papan kikinni onískin maxkati iki. Ja non papa yosishoko ikenbi jaskámaaxa, noa jawen bakebo kikinbires jakonma banéti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Jakopíra, neno jokin ja nokon papa en yoia iki, nato bake en akonkin koiranti. Jaskáati yoikinra, en aká iki neskáakin: ‘Ja nato en ioai nokon wetsa, jakiribi mia iwexonyamaaxa, ea iti jake jaskaraton jatíbitian masá shinankin, jakonma masábires tenei jaai’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Jakopíra ea keenai, nato bake jawen wetsabo betan raantaanan, jawen toan min yanka yonoti ea banéti. ");
INSERT INTO shpNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Jaskara iken, ja nokon wetsa ebé kayamaitianra, jawekeskataxbi nokon papan xobon ea kati atipanyamake. Jaskati eabicho kaxonbira, ja nokon papa jakonma en shinanmaa akonbireskin masá shinanni onitsapitai en ointi iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Jato jaskái iikinbira, moa jato bebonxon teneti atipanyamaxon, jawen yonotibo Josekan, koshin neskáakin saí aka iki: “¡Jatikaxbi nenoax jokonkanwe!” akin. Jatianra westiora jawen yonotibi jain yamakana iki, ja Josekan jawen wetsabo jato onanmanontian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Jaskáakin jawen wetsabo moa jato onanmataanan, José ikonbiresi koshin sion iki winia iki. Jaskati winiaitian, jatíbi jain iká Egipto jonibaon ninkákana iki. Jainxon jaskati ja José winiabo, faraónribi keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jatian jawen wetsabo Josekan aká iki, neskáakin: —Ea riki José; ¿Non papaki jaréstaniparia? —akin. Jato Josekan jaskáabi, ikonbiresi ratékin, nin tsonbi jawetanibi yoiti atipanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Jaskákanainbi Josekan jato yoia iki: —Nerichaa bekanwe —akin. Jatian jato jaskáa jakibeirankanketian jato yoiribia iki: —Ea riki, maton wetsa José; ja Egiptonko bokannon ikax, mato eon maroni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ikaxbi jaskáakin yoixon en mato onanmaa, matonbinix jakonmabo shinanni, maton shinan tsokasax sinataxbo, jakayara mion maronike iki ikaxbo, sinakananyamakanwe. Diossenbira mato joámatianbi, eapari neno raana iki, neskati jawékiatinin ikí mato keyókanketian, mato itan wetsaboribi akinti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Moa riki, rabé baritia mato jawékiatinin ikai. Jabira maxkáparike pichika baritiapari, mato jawékiatinin iikaresti. Jaskara ikaxa, maton banábo xoxotima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Jaskátibo kopí riki, Diossenbi mato joámatianbi eapari neno raana. Jaskáaxon matoyabi, itan maton kaiboboribi en akinti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Matoma riki ea neno jan raana, Diosbikaya riki, jan ea neno bea. Ja Diossenribira, Faraón akinnai joni koshi iti, itan ja faraónman xobon ikábaon joni koshi itiribi ea imaa iki. Jainxon jatíbi nato Egipto main jaa jonibaon joni koshi itiribira, ea jan imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Jaskara iken, ramabi boxon ja nokon papa ea neskáakin yoixontankanwe: ‘Ja min bake Josekanra ake, neskara joi mia bemakin: Nokon papanpari nato joi en bomaatianbi, ishton ea oinni jonon. Diossenbi Egipto main jaa jonibaon koshi ea imaa riki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Jainxonribi yoitankanwe, joaxa Gosén janeya main jakanti iki; jawen bakeyabi jawen bababoya, itan jatíbi jawen yoinaboyaribi. Jaskati moa jain joax jaaxa, ea iká ochóma jati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Jaskati neno joax jakanketianparira, en jatíbi jawékinin jato maxkámatima iki. Pichika baritiaparira maxkáke, jawékiatinin iki onitsapikanti’. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Jaskara iken, maton itan nokon wetsa Benjamínmanbi ake ninkákin, enbishaman jaskara joi mato yoiaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Jaskara iken, ja nokon papa ea yoixontankanwe, eara neno Egiptonko joni koshi jikimakana iki. Jainxonribi yoitankanwe, jatíbi jaskara jawéki en neno akai maton oinnabo. Jaskáakin yoitaananra, ja nokon papa jatianbi ea maton iwexonti jake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Jato jaskáakin yoikin senenhataanan, José jawen wetsa Benjamín paotaanan rabekaxbi winibekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Japekáo Josekan, jatíbi jawen wetsabo bexépakea iki. Jaskáakin jato paotaanan bexépakei onisi jato betanbi winia iki. Jaskati senentaanan moa jaton shinan tantipakeax, jaton wetsa José betan yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ja Joséiba jawen wetsabo nokókana joira, faraón keshankana iki. Jaskarabo keshankana ninkatax, jawen joni koshiboyabi faraón kikinbiresi raroa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Jaskati rarokin, ja faraónman jawen wetsabo José yoimaa iki neskáakin: —Min wetsabopari yoiwe, jaton yoinaboyabi, ja min jato menia jawékiatiboya, Canaán main jakiribi moa botankanon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Jain kaxonra, maton papa betanbi jatíbi jabé ikábo, maton ea jato iwexonti jake. Jaskáakin maton jato iwea eiba nokókanketianra, Egipto mai jain jakonshamani yoábo xoxoainko, en jato jamati iki. Jain en jato jamaara, jakonshamani yoábo ikaitian ja jawékiai jakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Jainxon jato yoiwe, nato Egiptonkonia kabáyonin niniai carroboribi botankanon. Jatianra jan napóanan, jaton bakeboyabi jaton awinbo, itan ja min paparibi jan naneanan ishtontani bekanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Jainxon jato yoiribiwe, ja Canaán mainmea jaton jayata jawékibo jenebeirantin masá shinanyamakanon. Neno Egiptonko moa bekanketianra, jatíbi jakon jawékibo en jato iboamati jake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jatian faraónman yoia keská, israelitabaon axonkana iki. Jaskáxon jan jato bekanti kabáyonin niniai carroyabi, ja kakin jawékiatiboribi, Josekan jato menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Jainxon chopa benáshamanboribi jato menipakea iki. Ixonbi ja Benjamínbiribi menia iki, kimisha pacha koríki, jainoax pichika kikin kopí chopa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Jatian jawen papabiribi bomaa iki, chonka asnon axon, kikinbires meskó jakon jawékibo. Jainxon jatíribi chonka asno awinin axonribi bomaa iki: Trigo, piti jainoax meskó jawékiatiboribi. Ja jawékiatibora iká iki, jokin jawen papan ja jawékiatibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Jaskati moa kati jato yoia, moa bokanaitian, jato neskáa iki: —Ramiananyamai jakonaxes botankanwe —akin. Jatianra jabo moa bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Egiptonkoniax boaxa, Canaáin jakonbires jaton papaiba nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ja moa kaax nokóxon, jaton papa Jacob keshankana iki, jawen bake José jaresparia. Jainxonribi yoikana iki, ja José jatíbi Egipto mainmea jonibaon joni koshi jikimakanaribi. Jaskáakin jaton papa yoikanabi, ikonhayamai ratékainax, jawebi yoyo iamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Jaton papa jaskatainbi, ja Josekan joi bemaabo jeneyamakin rebéstankin yoikana iki. Jaskáakin yoikana ikonhayamai iikinbi, ja Josekan kabáyonin niniai carrobo oinna iki; ja carrobo iká iki, jan naneanan já bokanti bemaa. Ja ointaananpari, ja ikonhayamai iwana shinanbo moa tantipakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Jaskarabo oinnaxpari jawen shinan tantitaanan, ja Israel jawen wetsa jane Jacob iká iki neskati: “¡Moa ea yoiamakanwe, ja nokon bake Joséra moa jake ixonra, en moa ikonhai! Jakopíra, ea mawatamatianbi já oinni ea kaai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jaskatax ja Josekan papa Israel, jatíbi jabé ikáboyabi jawen bakebaon boá, Canaán mainmeax kaax Beersebanko nokota iki. Jain nokóxon, jawen papa Isaacnin rabikatitai Diosibi rabikin, yoina reteanan menoxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Jatian jain iakea yamé, namá keská meranxon Diossen jawen janen, Jacob kenaa iki. Ja kenaitian aká iki neskáakin: —Jawerin, eara neno iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Jaskáaketian Diossen yoia iki: —Ea riki, min papan Dios. Jaskara iketian, ja Egiptonko jaai katin rakéyamawe. Jain kaax mia jaketianra, min chiní bakebo en akonbireskin kaimaa, ani jemaaxbo jakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ja Egiptonko mia kaaitianra, eabi mibé iti jake. Jainoax enribira, ja min chiní bake kaiabo, ja Egiptonkonia pikotaanan en jakiribi min mainko jato beribanoxiki. Jatian mia Egiptonko iiti mawáketianra, ja min bake José, mia mawataitian oinni mibé iti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jatian moa jaskáa pekáo, Beersebankoniax kaai Jacob tekita iki. Ja kaai tekíkin, ja faraónman bemaa, kabáyonin niniai carrobaon, jaton papa betanbi jaton awinyabi jaton bakebo, ja carrobaon moa jato napokoomaxon, jato iokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jaskataxa Jacob jatíbi jabé ikáboyabi, moa Egiptonko jaai bokana iki. Jain bokinra bokana iki: Jaton wakabo, jaton carnerobo jainoax jatíbi ja Canaánhain inontian bikana jawékibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ja Egiptonko Jacob kaaitianra, jatíbi jawen bakeboyabi jawen bababo, jabé boax nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ja Egiptonko bokanni Lean bakebaon janebo riki natobo: Jawen reken bake Rubén. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ja Rubenman bakebora iká iki: Hanoc, Falú, Hesrón jainoax Carmí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ja Simeónman bakebobiribi iká iki: Gemuel, Jamín, Óhad, Jaquín, Sóhar; jainoax ja Saúlbiribi iká iki, cananea ainbo betan bakeaa. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ja Levikan bakebobiribi iká iki: Guersón, Quehat, jainoax Merarí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ja Judakan bakebobiribi iká iki: Er, Onan, Selá, Fares, itan Zérah (ja Er betan Onanra, Canaán mainmeax moa mawata iká iki). Jatian ja Faressen bakebora iká iki, Hesrón betan Hamul. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Jatian ja Isacarnin bakebobiribira iká iki: Tola, Puvá, Job jainoax Simrón. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ja Zabulónman bakebo iká iki: Sered, Elón, itan Jahleel. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ja non yoipakeara ike, ja Lea betan Jacobnin, Padán-aramhin inontian bakeaabo. Ja jaton bake ainboribira iká iki, Dina; jatíbi jayakanixa ikana iki, kimisha chonka kimisha joni. Jatíra ikana iki, benboboyabi ainbobo topona. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jatian ja Gadnin bakebobiribi ikana iki: Sifón, Hagui, Esbón, Suní, Erí, Arodí itan Arelí. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ja Asernin bakeboribira iká iki: Imná, Isvá, Isví, Bería, itan jaton poi iká iki Sérah. Jatian ja Beríanin bakebo iká iki: Heber betan Malquiel. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Jatíresa iká iki, Jacobnin Zilpáki bakeaabo chonka sokota bake. Ja Zilpára iká iki, Labánman yanka yonoti ainbo; jara jawen bake ainbo Lea menia iki, jan yononon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ja Raquelnin Jacob betan bakeabobiribira iká iki, José itan Benjamín. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Jatian Josekan Asenatki bakeaboribira ikana iki: Manasés betan Efraín; jabora iká iki Egiptonkoniax pikota rabébires. Ja Asenat iká iki, Potiferan bake; jara Onhainoa ikonma sacerdote iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ja Benjamínman bakebora iká iki: Bela, Béker, Asbel, Guerá, Naamán, Ehi, Ros, Mupim, Hupim jainoax Ard. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ja neno non yoiatiiresa ike, ja Jacobnin Raquel betan bakea kaikanabo. Jatíbianix ikana iki, chonka chosko joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danman bakebiribira iká iki Husim. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ja Neftalíkan bakebobiribi iká iki: Jahseel, Guni, Jeser jainoax Silem. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ja Bilhára iká iki, Labánman yanka yonoti ainbobiribi; jara jawen bake Raquelnin yonoti inon ixon menia iki. Ja Bilhá betan Jacobnin bakebora iká iki, jatíbianix kanchis bake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ja Jacob betan Egiptonko bokana jawen kikin kaiboshamanbora ikana iki, jatíbianix sokota chonka sokota joni; ikaxbi ja jawen bakebaon awinbora toponkanamapari iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ja Egiptonkoxonra, Josekan bakeaa iki, rabé. Jatoyabi ja nokókana jawen kaibobo toponkanara iká iki, kanchis chonka joni; jatí Jacobnin kikinshaman rarebobora ikana iki, Egiptonko. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ja Egiptonko nokotamatianbira, Jacobnin jawen bake Judá Joséiba raana iki; Gosén main nokókanamatianbi jato bechii jonon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jatian ja Gosén main jawen papa moa nokota ninkáxon, Josekan ja bechii kanoxon, jan kati jawen carro jato jakonshamanhakin benxoamayona iki. Jaskáakin bechii kaxon moa nokoax, jawen papa yosishoko teikotaanan onisi, basichaashaman José ikonbiresi winia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jaskati senenketian, Israelnin jawen bake José aká iki neskáakin: —Baké, ramara ake en miabishaman jiriapari nokon beronbi oinkin. Jaskáakin miabi moa oinnaxa, ea raroshamanres moa mawáti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Jatian Josekan jawen wetsaboyabi, jawen papa betan ikábo yoia iki neskáakin: —Enpari ishton kaxon faraón yoibatanon, nokon wetsaboyabi nokon kaibobora, Canaán mainmeax neno ebé jaai bekanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Jainoax jan teetaibobiribi ikaxa, jatíbi jaton wakaboyabi jaton carneroboya bekanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Jaskáakin en faraón keshana, mato kenamaa kaketian, ¿Jawenshamanki mato teetai? Akin mato yokata, neskáakin yoinoxikanwe: ");
INSERT INTO shpNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Non yosibobiribi jaskaraton teepaoni iketian riki, noaboribi yoinabo kaiai teetaibo, akinra ja faraón mato ati jake. Jatian jaskáakin maton yoiara, Gosén mainshaman mato imatiki. Ja Egipto jonibo, yoina kaiai joni jato patax jatin keenma ikenbira, mato jain imati iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jaskatax kaxon, Josekan faraón yoia iki, moara Canaánhinoax beax, Gosén main nokon papa betanbi nokon wetsabo nokotax tsamákanke. Jabo bekana riki, jatíbi jaton jawékiabi, jaton yoinaboya, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Jaskáakin faraón keshana pekáo, jawen wetsa pichika katota iki; faraón onanmai kanoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ja onanmati jato ioa kaketianra, faraónman jato neskáa iki: —¿Matoki jawen teetaishamanbo iki? —akin. Jato jaskáakin yokata yoikana iki: —Mia riki, non joni koshi. Jaskara ikenra mia non yoiai, ja non anibo janribi ipaoni iketian riki, yoinabo kaiai noa janribi teetaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ja Canaán mainmeax, kikinbiresi jawékiatinin iorai kopí riki, nato Egipto main jakasi noa bekana. Jainoax non yoinabaon piti pastobobi, moa xoxoyamaitian riki, noa neno bekana. Jaskara kopí riki, miares joni koshi iketian, Gosén maintanibires min noa jamanon ixon, mia yokati noa bekana —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Jaskáaketian faraónman, José neskáakin yoia iki: —Ja min papa betanbi, min wetsabora mibé neno jakasi bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Jaskara iken, nato Egipto maira moa miki en jenea iki. Jakopí, ja Gosén maira jakonshaman iki, jain jato imawe. Jawekeska ikaxa, jato xaran jati atipanke, min onanna akonkin waka koiranti onan joni. Jaskara jonibo jaketianra, ja jonibo min imati jake, yoina koirannaibobiribi iti. Jatianra nokon yoinaboribi jawenayabi koiranon ixon, en jain imati jake —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Jatian Josekan, jawen papa faraón onanmakin ioa iki. Ja ioa kaax, moa faraónhiba nokóxon, ja joni aniakin shinanbainhanan aká iki, neno joaxa ea iitai, ¿Miaki jawekeskatani iki? akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Jaskáaketian faraónman aká iki: —¿Jawetii baritiayarin mia? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jatian Jacobnin yoia iki: —Moa riki ea pacha kimisha chonka baritiaya, jatíbiain kawantani jaa. Jatí baritia onitsapiti jaa ikaxbi riki, ea ramakamanbi nokon yosibaon baritia ikátiaitii nokotama —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jaskáakin yoitaanan, moa faraónhibakeax Jacob pikókaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jaskáxon ja faraónman yoiabo senenhakin, ja Josekan jawen papa betanbi jawen wetsabo, ja Egiptonko iká mai jakonshaman jato menia iki. Jaskáakin jato mai menia, Gosén janeya mainko boax jain jakana iki; ja main janeribi iki Ramsés. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jainxonribira jatíbi jawen kaibobo, Josekan, ja jawékiakanti senenbo jato menikatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Jaskarabo inontianra, Egipto main itan Canaán main iká jonibo, jawékiatinin iorai mawákaskana iki. Jaskárakana iki, nin jaweranoabi jawékiatibo biti yama iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Jatian ja Canaán joniboyabi Egipto jonibaon, trigo bikin kopíakanai koríkibobiribi, Josekan tsinkiboa iki. Ja tsinkixon, jain faraón teetai xobon boxon, ja koríkibo jain benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Jatian Egiptonkobi, nin Canaánhinbi moa koríki yamaketianra, egipciobaon José yoikana iki: —¡Min noa piti meniwe! Koríkioma kopíres min noa piti retemaara, atikeskabiakin min aká itima iki —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jaskáakana Josekan jato yoia iki: —Jaskati moa koríkibobi keyota ixon, rama maton yoinabo ea bexonkanwe; ja yoinabo kopí mato en trigo meninon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Jato jaskáakin Josekan yoia, meskó yoinabo bexonkana iki. Ja bekana yoinabo iká iki: Kabayobo, carnerobo, wakabo jainoax asnoboribi. Jaskáakin yoinabo bekanketianra, ja yoinabo kopí Josekanbiribi aká iki, westíora baritia senen, jaton jawékiati trigobo jato meniboreskin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Jatian moa jato jawékiati menikin jeneti baritia senenaitian, Joséiba boríbakana iki. Ja boxon neskáakin yoiribikana iki: —Ja rama miiba joríbaxon, mia non yoiai riki, paranbainkin mia non akaima. Ikon jaskarakon iketian riki, mia non jaskáakin yoiai. Noabo riki, moa kikinbires koríkiomabo. Jainxon ja noa jayata jatíbi non yoinaboribi riki, keyokin moa non mia meniabo. Jaskara ikaxa, rama moa jashaman mia non meniboti jawékibo moa yamake. Ja texea jawékibicho riki, non mai betan non yorabichores. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Jaskara iken, ja trigo min noa meniboresti kopí, rama ja non yoran itan ja non main marowe. Jatianra ja faraónman noa jawen kikinhakin yanka yonoti imaabi, noona jawemabi iti iki, jan noa pimai ikax. Jainoax jakonribira itiki, jain noa jaa mainko bananon ixon, ja banati berobo min noa menia. Jatianra ja main banaabo jawékiai jaax, noa itan ja mai mawata keská itima iki —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jaskati moa yoábo yamaketian, ikonbiresi jawékiatinin ikinra, Egipto jonibaon jaton waibo José maromakana iki. Ja jaskáakin José maromakana waibora, ja Egiptonko iká jatíbitanishaman maibo, moa faraónmana baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jaskatax ja Egiptonko jakana jonibo, faraónman kikinhakin yanka yonotibo banékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ikaxbi ikonma sacerdotebaonres, jaton waibo José maromayamakana iki. Jabaonra jaskáakana iki, jabo faraónmanbi jawékiati jato meniaibo ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jaskata pekáora, Josekan jatíbi jonibo yoia iki: —Jaskara ikaxa, rama matoyabi ja maton maibo, moa faraónmana iki. Jakopíra en mato banati berobo meniai, maton jain bananon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Jatian ja maton banaabo moa iketian tsekaxonra, pichika tsamáinoa westíorares, faraón maton meniti iki. Jatian chosko tsamá matona banetara iti iki, jainoabi maton banati, jainoax jainoabi maton jawékiatiboribi —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ja Josekan jato jaskáaketian yoikana iki neskáakin: —Miabichores kikinbires noimis ixonra aká iki, noa jawékiatinin iki keyotainbi, minres noa noibataanan jamakin. Jaskara ikaxa, faraónman kikinhakin yanka yonokin noa teemaabi, nona jawemabi iti iki —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jaskara iken, westíora senenhakanti esé Josekan pikoa iki. Ja pikoa eséra iká iki, ja bimi tsekakana pichika tsamáinoa, westíora tsamá faraón menikanti jake, iki iká. Ja jaskáakanti yoini eséra, rama kamanbi jaréske. Ikaxbi ja sacerdotebaonresa, jaton wainkonia tsekaa jawékiatibo, faraón meniamakana iki; jaton maibo faraónman iboaama iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jatian jaskati Egiptoain boax, ja israelitabo Gosén main jaax, ikonbiresi kaikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ja Egipto mainra Jacob jaa iki, chonka kanchis baritia senen. Jatíbianixa ja Jacobnin baritia iká iki, pacha chosko chonka kanchis baritia. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jaskara iikin, Jacobnin onanna iki, jawen mawáti nete moa seneni kaai. Jatian jaskara onanxon, jawen bake José kenaxon yoia iki: —Akonkin noixon ea akinti ixon, min meken ja nokon kishi naman niawe, jaskaaxon jatíbi ja en mia yokataibo ea senenhaxonti ixon, Dios janetaanan ea jen awe. Ea mawáketian, jawekeskáaxonbi Egipto main ea miinyamanoxiwe. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Jawetianki ea mawatai, ea nenoa tsekabainkin boxon, jain nokon anibo miinmeeta pataxbiribi, ea miinnoxiwe —akin aká iki. Jawen papan jaskáaketian, enra mia jaskáati jake akin Josekan aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jatian jawen papan yoia iki: —Dios janetaanan ea jaskáawe —akin. Jaskáatin keenaitian, Josekan Dios janebainkin jawen papa yoia iki, jatianra ja Israel jawen tepitikibi bekepinon kaman, beota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Jaskáayantana basimabi, Josekan ninkata iki, jawen papa Jacob isinai. Jaskara ninkátaanan, jawen bake rabé Manasés betan Efraín bibaini, jawen papa oinni José kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ja kaax nokóketian, Jacob keshankana iki, jawen bake José ja oinni joá. Ja keshankanatianbi, Jacob raroi jawen rakátiainoaxbi koshiinakainax, yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jain yakáxon, jawen bake José aká iki neskáakin: —Ja Canaán main iká Betel jemanko ea inontianra, ja jatíbi atipana Dios eki pikóxon, jakonbires janon ixon ea jakon shinanxonkin, ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","neskáakin ea yoia iki: ‘Oinwe min chiní bakebo en kaimaara, kikinbires icha inóxikanai. Jaskati kaiaxa, maibotiibi janbístaanan ani jemaaxbo janoxikanai. Jainxon ja min chiní bakeboribira, Canaán mai en jato meninoxiki, jatíbitian jatonabiribi inon ixon’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jaskara iken, ja neno Egiptonko ea mato betan jaai joamatianbi, min bakeara rabé iki Efraín betan Manasés. Jabora nokon bake rabé Rubén betan Simeón aká keskáribiakin, nokon bakebi keskáribiakin en shinanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ja bakebo pekáo min chiní bakeabora, minabiribi iti iki, jatianra Efraín betan Manaséssen wetsa ixon jatíbitian jatona inon ixon papana biti jawéki jatonribi biti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jatian Padán-aramhinoax jokinra, min tita Raquel en Canaánhinxon mawámaa iki. Ja maxkaketianra, Efrata jemaki nokóti ochóma iká bai kexabi en maiaa iki; ja Efratan janeribi riki Belén —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jaskáakin yoii iikinbi, ja Josekan bake rabé Jacobnin meraa iki. Ja merataanan José neskáakin yokata iki: —¿Nato bake rabéki tson bakebo iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","—Nato bake rabé riki, neno Egiptonko iketian, Diossenbi ea menia bakebo —akin Josekan jawen papa aká iki. Jaskáaketian, jawen papan aká iki neskáakin: —Neripari ja min bake rabé ea bexonwe; ja Diossen jawen jakon shinan ea menia shinan en meninon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ja Josekan bakebo jaskáanontianra, Israel iká iki moa yosishokoira ixon, jakonhakinbobi moa ointi atipanyamaa. Jaskara iketianra, já ochóma Josekan jawen bake rabé ioxona iki. Jato ioxonketian jaton rarokin, jawen baba rabé toataanan jato bexeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Jawen baba rabé jaskáa pekáo, jawen bake José aká iki neskáakin: —Kikinshamankinra, jakiribi mia en ointi shinanama iki. Jaskara ikenbira, Diossenbi amaares rama min bake rabéyashoko en mia oinke —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jaskáa pekáo, ja bakebo jawen papashokon toaketian bichintaanan, ja bebon kaax, José chirankootax maikibi bekepia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jaskátaanan Josekan jawen bake rabé bixon, ja Efraín jawen mekayao mekenman metsona iki; jatian Manasésbiribi, jawen mexkao mekenman metsona iki. Jaskáakin jawen bake rabé metsonhanan, jaton papashoko patax jato imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Jatian moa jaskaaxonabira, jato Dios yokáxonamatianbi, Jacobnin jawen meken rawinonaankin jato manaon sanana iki. Jatian jawen mekayao meken, Efraínman mapo manaon sanana iki; ja chiní ikenbi. Jainxon jawen mexkaokea mekenbiribi, Manaséssen mapo manaon sanana iki; jakaya Josekan reken bake ikenbi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Jatian José jawen bakeboyabi, Diossen jakonhanon ixon, Jacobnin moa jato yoixona iki neskáakin: “Mia Dios iketianra, nokon papashoko Abraham betan, nokon papa Isaacnin min joi mia ninkáxonkatiai. Jaskaribiakinra en onanke, nokon titan chixana meranoax pikónontianbi, ea min koiranbea. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Jainxon meskó onsá jawékiainoaboribi, min ángel min ea koiranmaa iki. Ja kopí ea keenai riki, ja Diossenbiribi nato bake rabéki, jakonhakin jato shinanxontin. Jabo jaskáa kopíressibira, nokon janeyabi Abrahamman jane itan ja Isaacnin janeribi, jatíbiain jakon ninkakaanoxiki. Jaskara ikenra, nato bakebaon chiní bakebo, ikonbiresi kainoxikanai”, akin jato aká ki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jatian jaskáakin, ja Josekan bake chiní Efraín manáon, Jacobnin jawen mekayaokea meken sanana iká iki. Jaskáa ikenbira, ja bake manaon jaskáatin keenyamakin, jawen reken bake Manaséssen mapo manaonres, jawen papan mekayaokea meken boxon, Josekan sananmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ja jawen reken bake manáon jaskáamaxon, jawen papa metsontaanan José iká iki neskati: —¡Papá, jaskarama riki!; nato nokon reken bake Manasés manaonkaya riki, min mekayaokea meken bexon, min já ponté sananti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Jaskáabi jabiribi jaskáatin keenyamakin, Jacobnin jawen bake José aká iki, neskáakin: —Ikon jaskarakon riki, ja min yoia keská. Ja min reken bakera, kaitaanan ani jemaaxboribi jaai bokanai. Ikaxbi ja xewinabiresa iki kaai, ja min chiní bake Efraín. Jara kikinbiresi kaitaanan, jatíbiain janbístaananbo ani jemaaxbo janoxikanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jaskáakin José yoia pekáo, ja netenbi Manaséspari Dios yoixontitianbi, Efraínpari Jacobnin neskáakin Dios yoixona iki: —Ja Israel jonibaonra anóxikanai, jatíbitian maton jane shinantaanan, jato Diossen jakonhanon ixon, jato neskáakin yoixonkin: ‘Ja Manasés betan Efraín jan akíni Diossenribi, mato akinbanon’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Jatian Josébiribi, jawen papan aká iki neskáakin: —Eara moa mawatibi iki. Jaskati ea moa mawákenbira, non Dios mato betan jatíbitian iti jake. Ja Diossenribira, non yosibo jain ipaoni mainko mato banémaribanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Miabichoresiki, min wetsabo xewiinabaina joni koshi jikimakana. Jaskara mia ikenra, ja amorreobo betan reteananxon en jato bichinni Siquem mai, mia itan min chiní bakebo en meniai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jatian Jacobnin, jawen bakebo kenaxon jato yoia iki neskáakin: “Ramapari, neribekanwe, jaskara iikax mato iki kaaibo, en mato yoinon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ea riki maton papa Jacob, jaskara iken en mato yoiaibopari ea ninkáxoni bekanwe bakebó, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Jato jaskáa jaki bekanketianra, jawen bake Rubénpari neskáakin yoia iki: Mia Rubén riki, bakeranon koshi inontian en bakeaa ikax, nokon reken bake; jakopíra ea miki koshia iká iki. Jaskara ikax, mia koshi shinanya iketianra, mia rabibainhanan ani joniakin mia shinanni, miki chipónoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Jaskara miashaman, nokon reken bake ixonbira aká iki, ea min akonbireskin jakonma shinanmakin. Ja jakonma min ea shinanmaara iká iki, nokon onan awin ea teanaanxon. Jakopíra, rama moa nokon reken bakema keská ikax, aniparo jene jawen keenaobiribi boí iitai keskáres ikax, mia minbix koirameyamaa iki, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Jatian ja Simeón betan Levíbiribira, siná yoina keská ixon, ishtonbires sinátaanan jato reteai joni rabébiribi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Jakopíra, jaskara atin keenkinres maton jato reteai, ea mato betan jatin itan maton tsinkítiainbo itinribi ea keenyamaa iki. Jaskarabo ixonribi maton akai, yoinakibobi sinátaanan moa niamanon ixon, jaton tae chiponobo jato xatenaankin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Jaskati yoinabo ikai keskati sinataibo ikaxiki, mato kikinbires jakonma jonibo. Maton jaskaraninbira, Israel jemabotiibi en mato janbismaa, mato jatíbiain janbisax jaresabo inóxikanai, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jainxon Judábiribi yoia iki neskáakin: Mia nokon bake Judákanbiribira, jato betan reteanankin min jatoaresnoxiki. Jatian min wetsabaonbiribira, mibebon joxon chirankootaanan mia rabinoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Jainoax miabiribi riki, kikinbires ino siná yoina biax koirani rakáketian, tson pataxtima keská. Jaskara siná iketianki, ¿Tson jaskara siná yoina pataxti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mia Judá Diossenbi joni koshi imaa iketianra, tsonbi min toan wetsa koshi imati yamake. Jainoax ja koshi jikimaxon mia menikana mia jaki koshiti kekótiribira, tsonbi mia bichinti yamake. Jawetianki ja nato neten jatíbitian apo iti joni joai, jan joxónresa ja kekóti mia bichinnoxiki. Ja joniribira, jatíxonbi jawen joi ninkáxonoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ja joni joxónribira, uva ichaira iketian, jawen burro bake ja uva jiwiki nexanoxiki. Jainxon uva jene vinoakanatonribira, jawen chopa betanbi jawen tari jan patsánoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ja apo iki joai joniribira inóxiki, uva jene xewinbainbires jakonshaman beroya keská ikax, metsáshaman. Jainoaxibira inóxiki, leche xewinbainbires joxoshaman xeta keskaya, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Jainxon Zabulónbiribi yoia iki: Miabiribira, aniparo kexá janoxiki. Mia jain jaketianra, wetsankoniax beaxbo, ani wapórobo min repintiain repinoxiki. Jatian mia jain jaa min mai senenabiribira inoxiki, Sidón mai senenainko akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Jatian ja Isacarbiribi yoia iki: Mia Isacar riki, iwe jaweki papimakanai yoinabo keská ikax, kikinbires koshi joni. Jaskara ikaxa, jawen jatinkobiribi yoina tantimakana jakonbires tantia keská ixon, mia meskóakin ramiakanabi, min jato kopíamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Jaskara ixon min oinna, ja mia jain jaa mai jakonshaman jain jati jisá ointaanan, mia yanka yonokin teemakanabira, jakonshaman shinanyaxonres min jato teexonoxiki, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ja jawen bake Danbiribi yoia iki neskáakin: Minbiribira, joni koshi jikitaanan min kaibo israelitabo jato akinoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Mia Danra inóxiki, bai kexa rono tsamátaanan, joni peyakaya kabayobo kaaitian, jaton tae chiponki natéxtaanan jato pakeai keskábo. Jakopíra, ja mii patax iká jemabo ikonbiresi matoki rakénoxikanai akin jawen papan aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jaskáakin jawen bake yoitaanan, Jacob iká iki neskati: ¡Nokon Ibó min ea jamanon ikaxa, ea miki koshiananbi mion manati jenéyamai! iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Jainxon Gadbiribi neskáakin yoia iki: Mibé reteananira, reteananai jonibo benóxikanai. Jaskati bekankenbira, min jatoaresa jabati bokanaitian, jato chibanhanan min jato keyonoxiki akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Jatian Aserbiribi neskáakin yoia iki: Miabiribira, kikinbires icha jawékiatia ikax, jawebi yoronyamanoxiki. Jaskara ixonra, apobaon jawékiai keskáshamanbo jawékiaires mia janoxiki, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Jainxon Neftalíbiribi neskáakin yoia iki: Miabiribi riki, jatíbibo jato jakonhaxonres jakinti shinanya ikax, westíora yoina jawen bakeboyabi metsáshoko ikax, tsonbi jaweayamaa kawanhatanai keská, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jawen wetsa bakebo moa jaskáakin yoitaanan, Josébiribi aká iki, jawen chiní bakeboyabi jaskara iti yoikin neskáakin: Mia José riki, jene ochóma westíora jiwi niax, kikinbiresi bimia keská. Jainoax ja jiwi ponyanbo, chikékana tanai neeinatai keskáribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ikaxbi ja jakonma shinanya jonibaonra, mia omískin mikiakin jakonma shinankana iki; jatíbitian mia ramiati shinanyares ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Miki jaskábokanainbira, ponté jakon shinanyares ikax, mia jawetianbi rakéyamanoxiki. Jakopíra, ¡Nokon Dios en ichabires iráke akai!, janres jatíbi jawéki atipanketian. Jainxonra en iráke aribai, jan jato ikinna ixon, jatíbitian jato akinhanan jato koiranaitianribi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ja min papan Diossen mia akinti kopíra, en já iráke akai. Já riki, jatíbi atipana Dios; jaskara ixonra, jawen jakon shinanman mia jakonhati iki. Ja naikanmea jakon jawékibaon, itan ja aniparo chichokea jakon jawékibaonribira, mia jan jakonhati iki. Jainoax ainbobaonribira, jakonhakin bakeataanan, jakonhakinribi jaton bakebo jawékiamakin jato aniakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Jaskara iken, ea nokon anibaon aní bebonbiresa, mia nokon bake iketian, Diossen mia jakon imanon ixon, en mia Dios yoixonai. Ja moatianbi japaoni keyá manain iká jakon jawékibo min oinnai bebonbiresa, Diossen jawen jakon shinanman mia jakonhanoxiki. Mia José riki, min wetsabo xaranmea, Diossenbi mia katota, akin aká iki jawen papan. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Jatian senentiainbi, ja Benjamínbiribi yoia iki neskáakin: Miara inóxiki, westíora pimís yoina siná keska. Ja siná yoinanin akai iki, yamékiri piti bixon janbichopari pikin. Jatian moa yantanpake akai iki, ja texeawana, wetsabo pikinkin”, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ja non yoipakeabora ike, ja chonka rabé Israelnin bake iníbo. Ja jawen bake westíorabokira, jawen papan jaskábiribi ikannon ixon, jato Dios yoixonpakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jaskáakin jato yoikin senenhayontaanan, Jacobnin jawen bakebo yoia iki: “Moara ea mawatibi iki. Ja nokon anibo minmeetainkoribi ea miinnoxikanwe. Ja jain miinmeekana kini riki, ja Efrón janeya heteo jonin mainko iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Jara, Canaán main iki; ja Macpelá iká bekeiba Mamré manan ikainko. Ja kinira, Abraham maroa iká iki Efrónmana; jabobiribi jain miinmeeti shinanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Jaskáti shinanxon bia ikaxa, ja Abraham jawen awin Sara betanbi jain miinmeeta iki. Jainoax jainribira miinmeekana iki: Isaac betan jawen awin Rebeca, jainoax Learibi. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ja jain miinmeeti kinira, hitita jonibaona Abraham maroni iká iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jatian jaskáakin, jawen bakebo moa yoikin senenhataanan rakáxon, ja Jacobnin moa maxkaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jaskáakin jawen papan moa maxkaketian, ikonbiresi onískin winiananbi, jawen papan yora teikobainxon Josekan bexeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Jaskati senenxon, ja mawábaon yora jaskáaibiribi jonibo, jawen papan yora pisitima raon amaxon, jainpari rakanxonti, Josekan jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Jatian ja mawá yora jaskáakin raonyonxon, chosko chonka nete senenpari miinyamakana iki; ja raon jawen yora taraxmai kaman. Jaton axébiribi jaskara iketianra, jaskáakana iki. Ja Egipto jonibaonribira, kanchis chonka nete senen, José onískinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Jaskati jawen onís shinan moa tantipakea pekáo, ja faraónman joni koshibo Josekan yoia iki neskáakin: —Ea keenai riki, maton jisá ea mato betan jakonbires iká iketian noibataanan, faraón maton ea neskáakin yoixonti: ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ja nokon papanra, jayá maxkakinbi ea aká iki, jan yoia joibo en senenhaxonai onanti inon ixon, Dios janemataanan ea neskáakin yoikin: Moa en maxkaketian, ja Canaán main iká kininko ea miinnoxon bonoxikanwe, akin. Jakopíra ea keenai, faraón maton ea jaskáakin yoixontin. Ja kini meran, nokon papan yora moa niaaxa, ea joríbatiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Jato Josekan jaskáaketian, faraón yoixonkanara, José kenaxon neskáakin yoia iki: —Atanwe, min papa miinkin; Dios janemataanan min jaskáati mia jan yoiantana keskáakin —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Jaskáakin yoia, José jawen papan yora miinni kaaitian, faraón betan teetai joni koshiboyabi jatíribi Egipto jonibo jabé bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ja José kaaitian chibani bokin, Jacobnin kaibobaon jaton bakebo, itan jaton yoinabobicho Gosén main potabainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Jainoax jatíribibo bokana iki, kabáyonin peyakaabo, jainoax kabáyonin niniai carronbaonribi bokana iki. Ja kopíra, ja José chibani bokanabo iká iki, kikinbires icha joni. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ja boax, Atad akanainko iká wainko nokókana iki; ja iki Jordán paro ochóma iká. Jain moa nokóxonbira, ja Josekan papan yora miinyamaparikin, onantishamanhakin kanchis nete senenpari rakanax, ja José masá shinankiini itan onískiini winikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Jaskati ja yora rakana oinnax, Egipto jonibo ikonbiresi onisi winikanaitian, Canaán jonibo ikana iki: “Ja egipciobaonra mawá miinkin onantishamanhakin akanai”, jaton noia joni koshi mawata beaxa ibirakanai, iki. Jatian jaskátaanan, ja jainoax jaskákana janekana iki, Abel-misraim, akin. Ja jaskáakin janekani riki, Jordán paro keiba iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jaton papan yora jaskáaxonra, jawen bakebaon senenhakana iki, ja jaton papa jiria inontian, jawen yora jaskáaxonti yoini joibo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Jato jaskáati yoia ixonra, jawen bakebaon jaton papan yora bokana iki, Canaán ikain Macpelá main iká kininko. Ja kinira iká iki, jatobiresbiribi mawatax jain miinmenoxon, hitita joni Efrónmana Abraham maroa. Ja kiniribira iká iki, bari pikotaiori Mamré akanai manan ochóma iká. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Jatian jawen papan yora moa miinkin senenhataanan, José jawen wetsaboyabi jatíbi jabé boabo, moa Egiptonko beribakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Moa jaton papa mawáketian, Josekan wetsabaon neskara shinanna iki: “Jawekeska ixonra, ja non papa moa mawata iketian, Josekanbira non já ramiani iketian, jan kopikaakin nokiakin rami shinanai”, iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Jaskáxon westíora raankana iki, jaton wetsa José neskáakin yoiti: “Ja non papa mawatamatianra, noa min wetsabo yoia iki, ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","mia neskáakin yoiti: ‘Ja min wetsabo mia ramiax miki ochakana ikenbi, moa jaskara jawékibo jato shinanxonyamawe, iki ja non papa iká’. Jaskara iken, rama mia non yoiai riki, mia non jaskáakin ramiabo ikenbi, moa nokiakin min ramiakin shinantima. Noaboribira min papa Jacobnin Diossen yonotibo iki”. Jaskáakin ja raankanatonin rebéstankin José yoia, winipakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ja joi bemakanatonin moa yoikin senenhaketianribi, ja Josekan wetsabo nokótoshita iki. Ja nokotax ja bebon chirankootaanan, maikibi bekepixon yoikana iki neskáakin: —Noa neno ikábo riki, min kikinhakin yanka yonoti jonibo —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jaskákanaitian jato Josekan yoia iki: —Rakéyamakanwe; jawekeskataxbira Diossen toan ixon en mato ramiati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Maton shinanra iká iki, ea ramiati. Jaskara ikenbira, ja maton shinanna keska imayamataanan, mato jakonhanon ixonres, Diossenbi ea neno imaa iki. Jaskáakin Diossenbi ea neno imaa kopíresa, icha jonibo en jato akinna, jakonbires japarikanke. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jaskara ikenra, mato jawekeskataxbi eki rakéti yamake. Enra maton bakeboyabi, mato jawékiatibo meniti jake —akin jato aká iki. Jaskáakin jakonhakinres jato yoibainhananra, Josekan jawen wetsabaon jakonmatani shinanni iitai shinanbo, jato tantimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jaskatax, ja José jawen papan kaiboboyabi, Egipto mainko jakana iki. Jatian ja Joséra jaa iki, pacha chonka baritia senenres. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ikaxbi ja Joséra mawata iki, jawen bake Efraínman bakebaon bababaon bakebo oinbaini. Jainxonribira jawen rarebo inon ixon, jawen baba Makirnin bakebo bia iki. Ja Makir iká iki, Manaséssen bake. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Jatian jaskara iikinra, Josekan jawen wetsabo yoia iki neskáakin: “Eara moa basima mawáti jake. Ikaxbira mato Diossen akinoxiki; jainxonra nato Egipto mainmea mato pikonoxiki. Jainoa pikotaananra, ja moatianbi Diossen jato mai meninoxon, Abraham, Isaac, Jacob, jabo yoiniain mato bonóxiki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jainxon Josekan, jawen wetsabaon paranyamakin akonkin yoikanai onannoxon, Dios janebainhanan jato yoia iki neskáakin: “Diossa jatíbitian mato betan inóxiki. Jakopí, nato Egipto mainmeax pikoti kakin, nokon xaoribi ea boxonoxikanwe”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ja Joséra mawata iki, pacha chonka baritiayanix. Ja mawáketianra, pisitima raon ayonxon taraxmaxon, cajón meran niaanan Egiptonko benxoakana iki.");
INSERT INTO shpNTpo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ja Israelbo joni koshibaonres jato ikinna inontianra, ja main jatíbiain jawékiatinin ikana iki. Jatianra westíora joni Judá main iká Belénhainoa, jawetio basires Moab main jaai, jawen awin itan jawen bake rabéya kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ja jonin janera iká iki Elimélec, jawen awinin jane iká iki Noemí, jatian jawen bake rabékan jane iká iki Mahlón betan Quelión. Jabora efrateo jonibo iká iki, ja iki Belénhainoabo iki iká. Ja Moabhain nokotaxa, jain jaai banékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ikaxbi iiti jawen bene Elimélec mawáketianra, Noemí jawen bake rabéyares baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Jaskara iitira jabo, rabé moabita ainbo betan wanokana iki; ja westíoran jane iká iki Orfa, wetsa iká iki Rut. Jatian jain jakana moa chonka baritia seneni kaaitianra, ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mahlón betan Quelión mawata iki, jatianra Noemí moa bakeoma itan beneoma, jabichoshoko baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Wetsa netera Noemíman Ibon jawen jonibo noibaxon, Judáin moa jawékiatinin iti jenémaa, yoikanai Moabhainxon ninkata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Jatianra moa Judáin karibati shinanna iki, jaskataxa jawen babán ewaboya jainoax moa kaai pikota iki; ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ikaxbi bain kakinra jato yoia iki: —Banetax, maton xobonko botankanwe, maton tita betan iki. Ibon jatíbitian mato noibakin jakonhabanon, nokon bakeboyabi maton ea ikínkatitai keskáribiakin, ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","jainxon mato jakiribi benomabanon, jaskatax mato jakon janon —akin jato aká iki. Jato jaskáa pekáora Noemíman moa kanoxon, jato betsó aká iki, ikaxbira ja ainbobo winia iki, ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","jainxonra yoikana iki: —¡Noara kayamai! ¡Noara mibébi min main baneti kaai! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Jabaon jaskáa, Noemíman jato teaa iki: —Botankanwe, nokon noi baban ewabó ¿Jaweakiki mato ebé kakasai? Enra iikaxonbi mato betan wanoti wetsa bakeati jisáma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Maton xobon moa banétankanwe. Ea jakiribi benoti ikaxbira, moa ea bebon yoxanhira iki, jawekeska ikax jan manáti japariketianra, nato yamébi benotaanan en jaweti bakeakeana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","¿Matonmein aniai kaman, jabo betan benonoxon manakeana iki? ¿Matomein jabo manai benoyamakeana iki? Iamarakeanke, nokon bake ainbobó. Ibonra akonbireskin en masá teneti eki raana iki, ikaxbi nokonara iti iki, maton masá teneaitian oinnax, bebonbires masá shinanti jawéki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Jaskáakin yoiara, jabo jakiribi winikana iki. Ja senentiainbira, jawen baban ewa Orfanin moa kanoxon betsó aká iki, ikaxbi Rut-ra jabébi baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Jatianra Noemíman yoia iki: —Oinwe, mia keskaribi nokon baban ewara, jawen main itan jawen diosboiba kaai banetai. Miaribi jabé katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Jatian Rutkan yoia iki: —¡Ea yokáyamawe mia jenenon ixon itan miibakeax ochónon ixon! Jaweranoki mia kaai, jainribira ea kati iki, jainoax jaweranoki mia jaai, jainribira ea jati iki. Min jonibora nokon joniribi iti iki, itan min Diossa nokon Diossibi iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Jaweranoki mia mawatai, jainribira ea mawáti iki, itan jainribira ea miimeeti iki. ¡Abánon Ibo Diossen mia jeneketian, ea akonbireskin masá tenemakin, mawáxonparira en mia jeneti iki! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Jatian Noemíman oinna, Rutkan jabé kanoxon akonkin shinanna iketianra, moa teaboreshamaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","jaskati kaaxa ja rabé, Belénhain kaman nokota iki. Ja Belénhain kaax nokóketianra, jatíbi jonibo anibiresi shinan rarokana iki. Ainbobora neskata iki: —¿Natoki Noemíma iki? —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ikaxbi jan jato yoia iki: —Noemí akin ea moa janeyamakanwe; Mara akinkaya ea janekanwe, jatíbi atipana Diossenra ea akonbireskin jakonma shinanya imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ea nenoax pikonontianra, ea jatíbia iká iki, ikaxbi ea rama joára kikin jawebioma iki, jaskara Ibo keena iketian. ¿Jaweatiki maton ea Noemí akin janeai, jatíbi atipana Ibon eki jakonmaaxon ea masá tenemaa ikenbi? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Jaskatax Noemí, jawen baban ewa Rut moabita ainbo betan, Moab mainmeax Belénhain kaa iki. Jatianra ja Belénhainxon cebada tsekakin, peokanaitian nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Noemímanra jawen bene Elimélec kopí, westíora joni rareboa iká iki, jawen janera iká iki Booz, jara iká iki icha jawékia ikax, kikinni ninkakaatai. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Wetsa netera Rutkan Noemí yoia iki: —Ea wainko ranwe, jawekeska ixon ja tsekai teetaibaon, epekáo jokin ja texkanbo topiwe akin ea atitian riki —akin. Jaskaa yoia iki: —Katanwe nokon bake ainbó —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Jaskaa Rut wainko kaa iki, kaxonra ja teetaibaon texkan jeneabo tsekaa iki. Jakonresira iká iki ja Elimélecnin rarebo Boozsen wainkoshaman kaa. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Jatianra Belénhainoax nokóxon, ja tsekai teetaibo Boozsen jato yoia iki: —¡Ibora mato betan iki! —akin. Jatianra jabaon neskáa iki: —¡Miaribi Ibon jakonhabanon! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Japekáora tsekai teetaibaon koshi, Boozsen yokata iki: —¿Tsoa jonin xontakorin oa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Jaskaa ja teetaibo oinnaitonin yoia iki: —Noemí betan Moabhainoax joá moabita xontako riki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Eara yokáke, ja tsekai teetaibo pekáokea texkanbo topinoxon, moa yamékiribi teeti peokoowana riki, ramashokobira shokores tantii joke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Jatianra Boozsen Rut yoia iki: —Ninkáwe, nokon bake ainbó, wetsa wainkobo ja texkan topi kayamawe. Nenobi banéwe, nokon yonoti ainbobo betan. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Jainoaxa mia karesti iki ja tsekai teetaibo oinnax. Moara nokon yonotibo jaskara itibo en yoike, mia jaweayamakanon ixon. Jawetianki mia nomiai, ja onpax bikana chomon ikábo oinxonra min xearesti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Jatianra Rut, iresama joni iketian, mai tii anon kaman beotaanan Booz yokata iki: —¿Jaweatiki ea wetsankonia ikenbi, eonbiribi keenxon min ea ayorakin jakonhai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Jatianra Boozsen neskáa iki: —Enra jatíbi ayorakin onanke, ja min bene mawata pekáoki, jawen tita min jawekeska aká iki ixon, jainxonribira en onanke, min onanama jonibo noa ikenbi nobé jaai jonoxon, min aniboyabi mato jain jaa mai min jenebeirana. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","¡Mia Diossen kopíabanon! ¡Abánon Israelbaon Ibo Diossen, min jaki koshinoxon benaa iketian, jatíbi min aká kopí, mia jan kopíakin! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Jaskaa ainbaon yoia iki: —Minra ea bebonbires jakonhai, itan min joinribira ea akonbireskin raromai. Eara min noibabainxon yoyo ake, westíora min yonoti ainbo keská ea ikenmabi —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Jatian moa piti hora iketian kenaxonra, Boozsen Rut yoia iki: —Neri jowé, westíora pan pakex bixon, nato jayá piti yochi jeneaton pokowe —akin. Ja tsekai teetaibo betan Rut yakáketianra, Boozsen bero tobán menia iki. Jatianra potonon kaman ja ainbaon piá iki, itan texeayona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Japekáora jakiribi texkanbo topii kaxon, Boozsen jawen yonotibo neskáti yoia iki: —Jaweayamakanwe, abanon ja cebada tsamana manainkoniaboribi bikin. Bechiteyamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Jainxonribi ja neanoxon bikin maanhareskanwe, abánon járibi bikin, ¡Tsonbi ja teayamakanwe! —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Jaskáketian Rutkan, yametai kaman Boozsen wainkonia texkanbo tsekaa iki. Jatian jan tsekaa xemeara, rabé chonka kilo winoa cebada iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Jatian moa jemanko baneti kakin bero papibaini kaxonra, jawen benen tita oinmaa iki. Japekáora, ja piti texeawana bixon, Noemí menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Jatianra Noemíman yokata iki: —¿Jaweranoki mia rama teeta? ¿Jaweranoaki min ichaira texkan tsekaa? ¡Jaskáakin jan mia akinna joni, jakon ibanon! —akin. Jatianra Rutkan jawen benen tita, tsobéki teebaitai ixon yoia iki: —Ja joni ea jabé teebaitaitonin jane riki, Booz —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Jatianra Noemíman yoia iki: —¡Ibon jakonhabannon! Jara nokon bene mawataton ochómakea rarebo iki, jakopíra ja senenhakin noa koirannai. Janra rama noa jakonhake, ja nobé ikátiaibo mawatamatian jato akátiai keskáribiakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Jatianra Rutkan yoiboresa iki: —Jainxonribira ea yoike, jawen yonoti ainbobo betan ja tsekakin keyokanai kaman ea teeresnon ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Jatianra Noemíman jawen baban ewa neskáa iki: —Nokon bake ainbó, en oinnara jakon iki, jawen yonoti ainbobo betan mia banéti, jatianra wetsa wainkobo mia katima iki, itan mia tson teatima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Jaskáakin yoiara Rutkan, Boozsen yonoti ainbobo betan, cebada betan trigo texkanbo keyonon kaman tsekaboresa iki. Jain kamanra, jawen benen tita betan Rut jaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Wetsa netera Noemíman Rut yoia iki: —Nokon baké, mia jabé jakon jatira min bene iti en mia benaxonai. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Oinwe, mia jawen yonoti ainbobo betan teepachoai Boozsa, nato yamé jawen wainko tseká berobo payani kaai. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Neskara awé: Nashiax, min jakon chopa saweax ininmewe, jaskatax kaxon Boozsen jawékiaitian jonéxon ointanwe, pikin itan xeakin senenhamatianbira min onanmatima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Jaweranoki oxai rakatai ixonra, min jakonhakin ointi iki. Jatian moa iketianra, jan tapota rakoti rabítaanan mia jain rakáti iki. Japekáora jaweki min ati iki ixon, janbi mia yoiti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Jaskaa Rutkan yoia iki: —Jatíbira ja min yoia keskábo en ati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Jatianra Rutkan wainko kaxon jatíbi jawen benen titan yoia keskábo aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Jatianra Booz, moa pixón xeax raroshaman iká iki. Japekáora, ja berobo pataxbi oxai rakata iki. Jatian shokores itaananra Rut, já ikainko netéshamanax nokóxon, jan tapota rakoti tabítaanan jain oxai rakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Jatianra yamé pochinikon, ratéresi Booz besoa iki, ja ranbékin jawen taenko westíora ainbo rakata iketianra rateta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","—Jaskatax ratéxon ¿Tsoarin mia? —akin Boozsen aká iki. Jaskáa Rutkan yoia iki: —Ea riki Rut, min yonoti ainbo. Miara nokon ochómakea rarebo iki, jaskara ixonra ea min koiranti iki. Ea keenai riki, ea min awinhakin bitín —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Jatian Boozsen yoia iki: —¡Mia Ibon jakonhabanon! Moabo jaskatama ikaxbira min bene wayon mekéxonkin min akonkin senenhai. Ramara mia onanti ike. Jakonra ikeana iki ea winoa bakeranoncha min benaa, jawékia iamax jawékioma inonbi, ikaxbira min jaskara ayamake. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Rakéyamawe, nokon bake ainbó, jatíxonbira nokon jemameabaon mia onanke, miara min iká jakon ainbo iki. Jakopíra, ja min yokatabo en mia axonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ikon riki, miara nokon ochómakea rarebo iki, ikaxbi eabi winoa min ochómakea rarebora wetsa jake. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Nato yamépari nenobi banéwe, bakish yamékirira non onanti iki, ja rarebo ixon ati jawéki senenhakinki, mia koirantiki ixon. Ikaxbi mia ayamaitianra, Ibo bebon en mia yoiai, enra mia atiki ixon. Ramapari nete xabatai kaman moa oxawe —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Jaskáakin yoia Rut, ja yamé Booz patax oxaa iki. Ja wetsa nete xabataitianra, kikin yamépari ikenbi wenita iki. Boozsenra shinanna iká iki: “Nato ainbo wainko joára, tsonbi onanama iti jake”, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Jatianra Boozsen yoia iki: —Min perakoti jopexon jakonhakin tewanwe —akin. Jatian Rutkan rakoti tenwanai kamanra, Boozsen chosko chonka kilo winoa cebada napóxona iki. Jaskátaananra moa botanon ixon akinkin iamaa iki, jainoax ja ainbo moa jemanko kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Jatianra Rut jawen bene wayonman titaiba nokóketian, neskáakin yokata iki: —¿Jawekeskaki mia iká, nokon bake ainbo? —akin. Jatianra Rutkan jatíbi Boozsen jaskáakin já akinnabo yoia iki, ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","jainxon yoiboresa iki: —Nato jatíbi cebada menikinra, ea yoike: ‘Min benen titaiba baneti kaira, mia jawebioma katima iki’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Jatianra Noemíman yoia iki: —Nokon bake ainbó, ramara, jawekeskaki winotai ikax mia manápariti iki. Nato jawéki ramakamanbi benxoyamaitianra, nato joni tantitima iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Iiwanaxa, Booz ja jema xepotiainko yakati kaa iki, jainra iká iki jonibaon tsinkí akai. Jatianribira jan yoiibata jaton rarebo winotaitian Boozsen neskáa iki: —Ninkáwe, nenopari yakatiwe —akin. Jatianra ja rarebo jain kaax yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Jatianbira Boozsen ja jemamea chonka joni koshibo jato kenaxon, jabé yakáti jato yoia iki. Jatian moa jabo yakákanketianra, ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boozsen jawen rarebo neskáa iki: —Noemímanra Moabhainoax baneti joxon, non rarebo ikátiai Elimélecnin mai maronoxon shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Eara mia onanmatin keena iki, jawekeska ikax, miara marotininbira keenti iki ixon, ramabira min biti atipanke neno nobé ikábo bebonbi, itan nato jemamea joni koshibo bebonbi, jabaon onannon ixon. Miara Elimélecnin ochómakea rarebo iki, jaskara ixonra jawen mai min marokin biti iki. Ikaxbi mia maroyamakinra, ea min onanmati iki, jaskarabo jato akinti kopíra ea mii pekáokea iki —akin. Jaskáa ja rarebonin yoia iki: —Ea maromabanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Jatianra Boozsen onantiakin yoia iki: —Minra onanti jake, jawerato joniki Noemíman main maroai, jara iamama Rut betanribi wanoti iki, ja benomaya moabita ainbo betan, ja mai jawen bene wayonman jane keyotima kopí —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Jaskáa ninkátaananra, jawen rarebonin yoia iki: —Jaskara ikenra ea maromatima iki, bixonbira nokon jawékibo en jakonmaati iki. Ikaxbi mia marotinin keenkin ja mai biwé; eakaya marotitianbira en mia imati iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Jaskarabo inontianra, Israelhain westíora axé ja iki: jawetianki westíora jonin, jawen rarebo jaskati iketian wetsa joni akinnai, iamax jawetianki maroxon iamax maromakin senenhai, ja meniaton o ja maromaatoninra jawen tasaweti, jopétaanan ja wetsa joni meniai iká iki. Ja nato axekan yoiai keskáakinra, ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Boozsen rarebonin jawen tasaweti jopétaanan, ja Booz menikin neskáakin yoia iki: —Mia marowe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Jatianra Boozsen, yosiboyabi itan jain ikábo neskáa iki: —Mato jatíbi riki rama, ja Elimélec, Quelión jainoax Mahlón, jabaon mai en Noemí maromaitian oinnaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Jainxonribira maton onanai ja Rut, moabita benomaata ainbo, en awinhakin biai, ja main jawen bene wayonman jane jatíbi jonibaon jane iká kirikain Mahlón iká toxkotima kopí. Jaskáara ja Mahlónman jane, jawen kaibobo xaranmeax keyotimaa iki, nin nato jemameaxbi shinanbenokantima iki. Mato riki rama ea onanabo —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Jatian ja yosibaon itan jatíbi jain ikábaon yoikana iki: —Jenjen, noabo riki. ¡Ja min biai ainbo abánon, Ibon Raquel betan Lea keska imakin, jainoax jatíbi israelitabo noa kaia iki! Jaskara iketian mia iwé, Efratankonia kikin ninkakatai joni, Belénhainxon onanshamankana joni. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Abánon Ibon ja ainboki mia icha bakeamakin. Jatianra ikonbires rarebaon kaia mia iti iki, ja Tamar betan Judakan bake, Faresnin aní keskáakin —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Jaskáxonra Booznin Rut bia iki. Jainoaxa jabé yoranketian, Ibon tooma iki, jainxon westíora benbo bakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Jatianra ainbobaon Noemí yoia iki: —¡Ibo rabinon akanwe, jan mia koiranti westíora baba mia menia kopí! ¡Ja min baba Israelhain jakon ninkakabanon! ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Janra mia yoxanshoko iketian shinan raromati iki itan akinti iki, min babán ewan bake ixon, jaon riki mia ichabires keena itan jara mina kanchis bakeyata winobainbires jakon iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Jaskáa Noemíman ja bake bixon ikota iki, itan moa koiraanan anianoxon bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ja oinnaxa ja patax iká ainbobo neskata iki: —¡Noemíra moa westíora bakeya iki! —iki ikana iki. Obed akinra janekana iki. Jára Isaíkan papa itan Davidkan papashoko iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Natobora Faressen chiní bakebo iká iki: Faressa iká iki, Hezrónman papa; ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezrónra iká iki, Ramman papa; Ramra iká iki, Aminadabnin papa; ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab iká iki, Naasónman papa; Naasónra iká iki, Salmónman papa; ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmónra iká iki, Booznin papa; Boozra iká iki, Obednin papa; ");
INSERT INTO shpNTpo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Jatian Obed iká iki, Isaínin papa; jainoax Isaí iká iki Davidkan papa.");
INSERT INTO shpNTpo_vpl VALUES ("JL1_1","030_1_1","JOL","1","1","1","Ea Petuelnin bake Joelra, nato joi Ibon yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_2","030_1_2","JOL","1","2","2","Nato jakonhakin ninkáshamankanwe joni koshibó, jainxon matonribi ja main jaa jonibaon ninkakanwe. ¿Neskara jawéki ikaiki maton jawetianbi oinnama iki? ¿Jawetianbiki wetsatianbo, neskara jawéki ikai maton papabaon oinnama iki? ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_3","030_1_3","JOL","1","3","3","Nato joi maton bakebo yoikanwe, abákanon jabaon jaton bakebobiribi yoikin, jatianra jato pekao pikotaibo jabaonbiribi jato yoiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_4","030_1_4","JOL","1","4","4","Judáin bexonra chanpobaon jatíbi pia iki: wetsabaon texeara jatíribibaon bexon keyokin piá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_5","030_1_5","JOL","1","5","5","¡Mato paennabo moa jishtenkanwe! ¡Ja vino xeaibo winikanwe, wai ras axonra uva jenebobi mato bichinkanai! ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_6","030_1_6","JOL","1","6","6","Jainoax champobora koshi, itan ichabires sontárobo keská, león xeta keskáyabo, itan león awinnin xenita xeta keskáyabo nokon main jatíbiain janbiske. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_7","030_1_7","JOL","1","7","7","Non uva waibora ramiake, non higo waibora keyokin beshéake, ja jiwibichibora keyokin bishkoke, ja jiwi poyanbobira joxobaintiake. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_8","030_1_8","JOL","1","8","8","Jawen biti joni mawáketian ja biti iká ainbo winiai keskati, itan mekéti chopa saweax ikai keskatira, ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_9","030_1_9","JOL","1","9","9","Ibo ja meniti jawékibo, bero bimibobi yamaketian, itan uva xeatibobi Ibon xobonko yamaketian, sacerdote jonibo winiai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_10","030_1_10","JOL","1","10","10","Jawe banábira ja main moa yamake; ja maibora moa jawebioma ikax onis iki, trigora moa keyoke, uva waibora moa choshi iki, itan olivos jiwibora moa siwáke. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_11","030_1_11","JOL","1","11","11","Mato wain teetaibo, itan uva banaibo onisi winikanwe, banábora moa keyóke, jaskara ikaxa trigo, itan cebada moa tsekati yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_12","030_1_12","JOL","1","12","12","Uva waibora moa choshike jainoax higo jiwibora moa keyóke. Yobin jiwibo, wanin jiwi keskábo, manzana jiwiboribira moa choshike, jainoax jatíbi wain banati jiwibo. ¡Jaskara kopíra jatíbi jonibo moa raroyamakanai! ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_13","030_1_13","JOL","1","13","13","Mato sacerdotebo, Dios menikin jainxon jawéki menotiain teetaibo, xaxa chopa sawekanwe, jaskáax chexakaati winikanwe, maton Diossen xobonkora, moa bimi berobi, uva xeatibi ja Dios meniti moa yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_14","030_1_14","JOL","1","14","14","Jonibo kenaxon ayunanti jato yoikanwe; ja joni koshibo, itan jatíbi ja main jaa jonibo, maton Ibo Diossen xobonko jato tsinkikanwe, jaskáaxon Ibo yokakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_15","030_1_15","JOL","1","15","15","¡Jawe iresaipanon, Ibon jaton jakonma aká jonibo yoixonti netera moa ochóma iki! ¡Jatíbi koshi Ibon onsá netera noa keyoi joai! ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_16","030_1_16","JOL","1","16","16","Non oinkenbira, chanpon non yoábo keyokin pixon noa pitioma banémaa iki, jatianra non Diossen xobonko moa raroti keyota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_17","030_1_17","JOL","1","17","17","Non banaa berobora oi beyamaitian mawáke, trigora moa yamake, itan jain bero tsamantibora koiranyamakana moa rinwimeebotanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_18","030_1_18","JOL","1","18","18","¡Wakabora jawékiakasi máan ikai! Yankabiresa wakabaon pasto benai; carnero tsamabora mawatai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_19","030_1_19","JOL","1","19","19","¡Min akinnon ixonra en mia yokatai Ibó, tsoa jonibi jain jaama mainmea xobi, itan ja mainmea niibora bari xanan keyokin menoke! ");
INSERT INTO shpNTpo_vpl VALUES ("JL1_20","030_1_20","JOL","1","20","20","¡Weanbo tsosinketian, itan bari xanan pastobo menoaitianra, ináatima yoinabaonbi min akinnon ixon mia yokákanai! ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_1","030_2_1","JOL","2","1","1","Jerusalén mananmanxon trompeta xoon akanwe; Ibon jakon manmanxon ja onsá yoii ikai onankanwe. Judáin jaa jonibo jatikaxbi saki ikanwe, Ibon jaton akábo yoixonti netera ochóma iki: ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_2","030_2_2","JOL","2","2","2","ja netera kikin yamé, itan yamémataniribi iti iki, ja netera nai koin jaax ota yamé iti iki. Koshi itan ichabires sontarobora nete xabáxon tenai keskati, mananbotiibi jatíbiain janbiskana iti iki. Neskara jawéki ikaira jawetianbi non oinnama iki, jaskáribiakinra jawetianbi non ointima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_3","030_2_3","JOL","2","3","3","Chiikan jatíbi keyoai keskáakinbora akanai; winotamatianbi axon, itan moa winota pekáobi axon akinra menoai. Ja nokotamatianra, mai kikínbires jakon jain iká iki, ja moa bokanketianra, jain jawebi xoxoyamai manan keská iti iki. ¡Jawebira jainoax kenekaayamai! ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_4","030_2_4","JOL","2","4","4","Jawen jisára kabayobo keská iki, kabáyonin boaibo ikai keskatira ishtokanai, ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_5","030_2_5","JOL","2","5","5","mananbotiibi choronaitianra jawen riri ika, janmeax reteananti carrobo ikai keskati riri ikai, pei chosi menoa ikai keskatira tashki tashki ikai. Koshi sontárobo reteananox joyota keskára ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_6","030_2_6","JOL","2","6","6","Jato oinnaxa jonibo saki ikai, itan jatíbi jaton bemananra pasnákanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_7","030_2_7","JOL","2","7","7","Reteananai koshi shinanya jonibo keskara ishtokanai, makan chikébaonra néekanai jainoaxa pontébainkanai, tsoabira wetsaori kayamai pontéres bain bokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_8","030_2_8","JOL","2","8","8","Wetsabo betan tsakaananyamaira; westíorabo jaton bainbiribi bokanai, pia meranbires ikaxbira, ja joyotax janbísyamakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_9","030_2_9","JOL","2","9","9","Jaton jema bichinaxa makan chiké maxkaten ishtokanai, xobo pekatenbora nékanai, ja yometso ikai keskatira xobo ventananbaonbi weíkanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_10","030_2_10","JOL","2","10","10","Jato bebonmeaxa mai ninwanai, naira shakotai, bari betan oxera yametai itan wishtinbora moa penéyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_11","030_2_11","JOL","2","11","11","Jawen sontárobo bebon kakinra, Ibon jawen tirin ikai joi jato ninkámai. Jawen sontárobora kikínbires icha iki; ja yoia senenhaibora tson topontimati iki. ¡Jonibo Ibon jato yoixonai netera, kikin jakonma itan onsá iti iki! Tsonbira teneti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_12","030_2_12","JOL","2","12","12","Ibonra neskara yoia iki: “Jaskara ikenra rama Ibo Diossen onantiakin yoiai, jatíbi maton shinanyaxonbi eabicho rabikanwe. ¡Ayunankanwe, saí ikanwe itan winikanwe!” ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_13","030_2_13","JOL","2","13","13","¡Non Ibo Dioski yoiti ikanwe, maton chopa waxatitianbi, jatíbi maton shinanyanixbi jaki yoiti ikanwe! Ibora, akonkin noimis itan onísamis iki, jato jaweatima shinanyaresiki, ikira ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_14","030_2_14","JOL","2","14","14","Jawe keska ixonra moa mato masá tenemayamakin, icha jawéki mato meniti iki: Icha berobo itan icha uva xeati ja non Ibo Dios menitibo. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_15","030_2_15","JOL","2","15","15","¡Sión mananmanxon westíoratonin trompeta xoon awe! Judá jonibo kenakanwe tsinkíxon ayunankanon; ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_16","030_2_16","JOL","2","16","16","mato sacerdotebaon Diossen jonibo tsinkikanwe, Dios bebon kerásma inox kikinni chokíkanon jato yoikanwe; yosibo, bakebo itan xoma akai bakeboribi jato tsínkikanwe. ¡Ja wanoa benábobira ja wanoax jain ikainoax bokanti iki! ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_17","030_2_17","JOL","2","17","17","Sacerdotebo, ja Ibon tee akaibo winikanwe, xepóti itan jainxon yoina menoti jemaorixon yokákanwe: “Min jonibaon ocha shinanxonyamawe Ibó; min joniboki tsoabi shiromayamawe; wetsa mainmeabaon jatoaresnaketian jato amayamawe. ‘¿Maton Dioski jawerano iki?’ ” Ikira, ja ikon Dios onananma jonibo inake. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_18","030_2_18","JOL","2","18","18","Jatianra Ibon ja mainmea jawen jonibo noia jato onanmaa iki; jawen jonibo noibaxa, ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_19","030_2_19","JOL","2","19","19","neskata iki: Enbira mato yoiai; “Enra mato meniai trigo, uva xeati itan olivo xeni, jatianra ja jawékiati jaketian mato raroshaman iti iki; jaskáxonra ikon Dios onanma jonibo en matoki shiromatima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_20","030_2_20","JOL","2","20","20","Norteorikeax beai chanpobora matoki nokómatima iki, jain jawebi xoxoyamai mananmanra en potati iki. Jatopari beaibora, jaweona aniparo ikainko en jato jene retemati iki, ja jato pekáo beaibora, Mediterraneoain en jene retemaa, jaton yora payotax pisi poati iki. ¡Ani jawékibora en ati iki!” iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_21","030_2_21","JOL","2","21","21","Matobo, kikinbiresi rarokanwe itan rakéyamakanwe, Ibonra ani jawékibo ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_22","030_2_22","JOL","2","22","22","Nii meranoa yoinabó, rakéyamakanwe, xobi xoxoabora pei paxashamanbo iti iki, jiwibora bimiti iki, jatianra higo betan uva ichabires jati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_23","030_2_23","JOL","2","23","23","¡Mato Jerusalénhain jaabo rarokanwe, non Ibo Dioski rarokanwe! Janra maxkáketian mato oi bemaxona iki, moa akátiai keskáribiakinra jénetia, itan nii peibo pechokoaitian mato oi bemaxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_24","030_2_24","JOL","2","24","24","Icha trigora tsekakanti iki, jatianra ichabires uva xeati itan olivo xeni jati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_25","030_2_25","JOL","2","25","25","Ibonra yoia iki: “Ja kikin jakonmabires keyomis ichabires chanpo, en matoki raanaton baritiabo mato manómaara, en mato banexonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_26","030_2_26","JOL","2","26","26","Potónon kaman jawékiaxonra, ea Ibo Dios maton rabiti iki, ani rateti jawékira en mato kopí aká iki. Jawetianbira nokon jonibo moa rabinkantima iki, ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_27","030_2_27","JOL","2","27","27","jatian mato israelitabaonra akonkin onanti iki, ea Ibora mato betan iki, itan ea riki maton Dios ixon, jaskara ikaxa wetsabo yamake. ¡Jawetianbira mato nokon jonibo, moa rabintima iki! ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_28","030_2_28","JOL","2","28","28","Jaskara jawékibo winota pekáora, jatíbi jonibo nokon Shinan en jato meniti iki: maton benbo bakebo itan maton ainbo bakebora, nokon janenko yoyo ikanti iki, yosibaonra namáti iki, bakeranonbaonra namá meran akai keskáakin nekebi jawékibo oinkanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_29","030_2_29","JOL","2","29","29","Yonokaatai jonibo, itan yonokaatai ainbobokiribira, nokon Shinan en manhati iki; ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_30","030_2_30","JOL","2","30","30","ani rateti jawékibo naikan ikaibora en jato oinmati iki, itan jimi, chii tiritai, chii koin kextóra nato main iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_31","030_2_31","JOL","2","31","31","Bari yaméketianra, oxe jimi keská iti iki, Ibon nete nokotamatianra jaskara iti iki, ani nete itan onsára iti iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("JL2_32","030_2_32","JOL","2","32","32","Ikaxbi jatíbi ja Ibo rabiaibora, mawáinoax xabakaati iki, jaskara ikaxa Sión mananman, Jerusalénhain jakanti iki, jaskara ati Ibon yoia keskára iti iki. Jan katotabora mawayamai jati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_1","030_3_1","JOL","3","1","1","Ibonra yoia iki: Ninkakanwe: “Ja nete nokoketianra, ja maton rawíbaon jaskara akábo en jato yoixontitian, Judá itan Jerusalénhainoa yatanxon bokanabo, wetsa mainmeabo en jakiribi jato banémati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_2","030_3_2","JOL","3","2","2","Jatíbi wetsa mainmea jonibo jato tsinkixonra, Josafat manan teshanpain en jato boti iki, jainxonra nokon joni Israelbo, jaskara jakonma akanabo en jato yoixonti iki. Israelitabora nato neten jatíbiain janbisakana iki, jaskáaxa nokon mai pakexbo menianankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_3","030_3_3","JOL","3","3","3","Nokon jonibaon menianankinra suerte akana iki, bake benbobaon itan bake ainbobaon maroxonra, ja koriki pae xeakin itan tsini ainbobo akin keyokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_4","030_3_4","JOL","3","4","4","¿Jaweki mato eibakea keenai, Tiro, Sidón itan filisteabo? Enra mato jawe jakonma akáma iki. ¿Kopikaakin ea akasirin mato? Ea kopitira mato iitima iki. ¿Matonki ea kopí yokákasai? ¡Basiamabira mato jaskara íitaitian en mato masá tenemati iki! ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_5","030_3_5","JOL","3","5","5","Matora nokon plata betan oro yometsoa iki, nokon kopí jawékibora maton diossen xobonko maton boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_6","030_3_6","JOL","3","6","6","Judá jonibora maton ochó boá iki, ja Jerusalénhain jaa jonibo, jabora jaton yonoti inon ixon Griegobo maton jato maromaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_7","030_3_7","JOL","3","7","7","Ikaxbi enbira jain maton jato maromaainkonia en jato pikoti iki, jainxonra jabaon aká keskáribiakin en mato masá tenemati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_8","030_3_8","JOL","3","8","8","Maton bake benbobo, itan bake ainbobora en Judá jonibo jato maromati iki, abákanon jabaonbiribi ja ochó mainmea sabá jonibo jato maromakin ixon. Ea Ibonra, moa yoike”. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_9","030_3_9","JOL","3","9","9","Nato jaskara iti maibotiibi jato yoikanwe: ¡Moa reteananox benxokaakanon! ¡Koshi shinanya jonibo jato kenakanwe! ¡Reteananai jonibó moa reteanani bokanwe! ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_10","030_3_10","JOL","3","10","10","Jaton lampabo espadaabakanon jatian machitobiribi tsatsitaxoabakanon, jatian yosma jonibiribi ibanon: “¡Ea riki koshi shinanya!” iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_11","030_3_11","JOL","3","11","11","Mato jatíbi, nóopatax iká mainmea jonibo. ¡Ishtonbires, tsinkiti bekanwe! ¡Sináma joni ikaxbira, moa reteananai baneti iki! ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_12","030_3_12","JOL","3","12","12","Ja maibotiibi ikainoabo moa benxokaatax, Josafat manan teshanpain tsinkikanwe, jainxonra jatíbi nóopatax iká mainmea jonibaon jakonma akábo Ibon jato yoixonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_13","030_3_13","JOL","3","13","13","Jabora kikínbires jakonmabo iki, trigo moa choshiketian ati keskáakin xatekanwe, jatian tsekatira moa senenke; uva akanai keskáakin potsikanwe, uva xeatiatira moa jatíbi senen iki; jaton jakonmara anibires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_14","030_3_14","JOL","3","14","14","Jainxon en jato jaskara ati shinanna, mai teshanpainra, kikínbires icha joni tsinkiti iki, jonibo Ibon jaton akábo yoixonti netera moa ochómabires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_15","030_3_15","JOL","3","15","15","Ja Ibon nete iketianra, bari itan oxe moa yametai, itan wishtinbora moa penéyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_16","030_3_16","JOL","3","16","16","Sión manan ikainxonbi, Jerusalénhainxon Ibon, jawen tirin ikai joi jato ninkámaketianra, nai itan mai shakotai. Ikaxbi ea Ibora israelitabo jain jonéti iki, nokon jonibo iketianra jakonhain inmaxon ea Ibon jato koirannai. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_17","030_3_17","JOL","3","17","17","“Ea maton Ibo Diossa, Siónhain jake iki ixonra maton onanti iki, jara nokon jakon manan iki. Jerusalén nokon kikin jakon jema iketianra, jawetianbi wetsankoniabaon jakiribi bitima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_18","030_3_18","JOL","3","18","18","Jaton akábo en yoixona pekáora, mananmanbo itan mai mato ikainbo icha uva xeati ikax, itan icha leche ikax onpax ikai keskati baiti iki, jatianra Judá weanbaon moa jene bochoti iki. Nokon xobonkoniax jene jokonaitoninra, Sitim teshanpa mechaati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_19","030_3_19","JOL","3","19","19","Egiptora ras ati iki, jatian Edomra tsoa jonibi jain jaama iti iki, yankabiresa Judá jonibo maton jakonma aká iki, jainoaxa jakonma akáma ikenbi, jaton mainmeabi maton jato retea jimi chikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_20","030_3_20","JOL","3","20","20","Judá itan Jerusalénhainra jatíbitian jonibo jati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JL3_21","030_3_21","JOL","3","21","21","Jan jato reteabora en jato kopíxonti iki, itan jan jato akábo shinanreskinra en jato ramiati iki. Ea, Ibon jatira Sión mananman iti iki”, ikira iká iki.");
INSERT INTO shpNTpo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ibonra, Amitainin bake Jonás, yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Ani jema Níniveainoa jonibora en jato keyoai kaxon yoitanwe, jabaon jakonma jawéki akai joira moa eiba nokóke”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ikaxbira Jonás, yoiti ititianbi Ibo bebonmeax jabata iki, jaskatira Jope repintiain kaa iki, Tarsissain kaai waporo moa pishitaishoko nokoaxa; pasaje marotaanan moa jain kaai naneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ikaxbira Ibon, aniparo napo, kikinbires niwe koshi bemaa, wapóro ras akasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Marinerobaonra ikonbiresi rakekin, westíorabaon jaton dios yokákana iki. Jatian ja waporo iwematani inon ixonra, jatíbi ja boai jawékibo aniparo napo potakana iki. Jonásbiribira, naman kaax jain jawéki benxoati meran ikonbiresi oxaa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Jatianra capitánman ja Jonás ikain kaxon yoia iki: —¿Jaweakirin mia jain oxaares? ¡Wenixon min Dios yokáwe! Onsá meranoa noa akintinin kenxon, noa jamanon ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Jatianribira marinerobo yoiananbotankana iki: —Suerte anon akanwe, tson jakonma aká kopíki, non neskáakin masá teneai ixon non onannon —ikibo. Jatianra jaskákin suerte akana, Jonáski paketa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Jatianra Jonás neskáakana iki: —Noa yoiwe, jawekopíki noki neskara masá teneti jawéki joá. ¿Jawe tee akí mia neno joarin? ¿Jaweranoaxki mia joá? ¿Jawerato mainmea jonirin mia? ¿Jawe jonirin mia? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Jatianra Jonassen jato yoia iki: —Eara hebreo joni iki, itan eara naikanmea Ibo Dios rabiai iki, janra aniparo betan mai jonia iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Iboibakeax jabati kaaira Jonassen ja marinerobo yoia iki, jatianra jabo jato yoia ninkatax, itan aniparo bebonbires bechon anikaresai oinnax, ikonbiresi rakékana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","jaskákinra yoikana iki: —¿Jaweati min jaskara akárin? ¿Aniparo tantinon ixonki mia non jaweati iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jatianra Jonassen jato neskáa iki: —Aniparo napo ea potakanwe, jatianra aniparo bechon tantiti iki. Enbira onanke, ea kopí riki nato ani niwe koshi matoki paketa iki ixon —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Marinerobaonra maiori kakaskin, jatíxonbi jaton koshi senena kaman winakana iki, ikaxbira bebonbires bechon anikaresaitian atipanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Jatianra Ibo yokati neskákana iki: “Ibó, nato joni kopi noa mawámayamawe. Jakonma jawéki akáma ikaxbi mawáketian, non aká keskáakin noa oinyamawe, miara min keena keská akai iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Jaskáakin yoitaananra Jonás aniparo napo potakana iki, jatianra moa aniparo bechon jeneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Jaskara jawéki winota oinnaxa, nato Ibora ikon iki ixon marinerobaon akonkin shinanna iki, jainxonra ja menikin yoina retexonkana iki, jaskáxonra mia rabikinra non jeneyamai akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Jaskákanaitianra Ibon moa ani yapa jan Jonás xeati jain aká iká iki. Jatianra yapan poko meran kimisha nete itan kimisha yamé Jonás jain iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jatianra yapan poko meranxon Jonassen jawen Ibo Dios orana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","oranira neskata iki: “Ibó, masá tenekinra en mia saí akin yokata iki, jatianra ea min akinna iki. Kikinbires chichó mawá meran ixon en mia kenaara, min ea ninkata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Aniparo kikin nemin ikain min ea potaara, baikan ea mapoa iki, ja min raana ani bechónbaonra ea mapoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Miibakea, moa min ea potaara, en shinanna iki; min jakon xobo moa oinwetsatima. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Akonbireskin ea jenen mapoara; aniparo neminhain ea iketian; jene meranoa xobi algas nishibaon ea mapoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ani xanken xamanko kamanra ea nokota iki; ¡jatíbitian jainoax pikótimaakin min xepoara en shinanna iki! Ikaxbi mia nokon Ibo Diossenra, mawáinoa min ea pikómaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Eara moa jayamai ixon onanxonra, en mia shinanna iki Ibó; en mia yokata joira mia iboamaa xobonko, miiba nokota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Jatonbi ikonma dios axon rabiaibaonra, moa mia ikon akin jenekanai; ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","ikaxbi enra mia rabiti iki, jainoax raroira ea miki bewati iki; ja en mia axonti yoiabora, en mia senenhaxonti iki. ¡Ibó, minbichoresa jato jamati atipanke!” akinra aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Jatianra Ibon amaa aniyapan, maioriakin Jonás kinana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ibonra jawen rabé itin Jonás yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Ani jema Níniveain katanwe, nato en mia yoiai joi jato yoitanwe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jonássa, jain Ibon kati yoia Níniveain kaa iki. Ja jemara kikin ani ikáx, kimisha nete rebesti iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ja jeman nokóxonra Jonassen, koshín saí ianan westíora nete aabaikin jato joi yoia iki: “¡Nenoax chosko chonka netera, Ibon nato jema keyoai!” akinra jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ja jemamea jonibo, jawékiabo itan jawékiomabaonra, Dios ikonhakana iki, jaskákinra ayunankana iki, jainxonra jaton jakonma shinanbo akonkin jenei onisi chexakaatai onanti inon ixon, xaxa chopabo sawekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ja joi Nínive apoiba nokóketianra, jawen yakátiainoax wenixon, ja apo ixon saweai chopa jopexon, oniskin ati chopa janribi sawea iki, jaskáaxa mainbi yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Jaskata pekáora, ja apon jawen joni koshibo betan jatíbi ja jemanko neskara koshi joi jato onamaa iki: “Tsonbira jawebi jawékiatimaa iki. Jaton wakabo itan jaton carneroboribira pimakantima iki, itan xeamakantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Jaskáyamai, masá shinanni chexakatai onanti inon ixon, jatíxonbi xaxa chopa sawekanwe, jaskáxon jatíbi maton koshiaxonbi Dios yokakanwe. Maton jakonma axé itan ramakamanbi ja atima jakonma akí mato iitai westíorabaon jenekanwe; ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Diossen, wetsaakin shinanxon jawen siná shinan tantimatitian riki, jaskáketianra moa noa mawátima iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Jatianra Diossen oinna iki ja Nínive jonibo jaskákanai, itan jaskáaxon moa jaton jakonma axé jenekanaibo, jatianra jato jakonma ati yoia ixonbi, moa jato atima shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ja Diossen aká Jonassen oinnara, kikinshaman jakonma ikax, jawen kenmabires iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Jaskákinra Ibo neskáa iki: —Ninkáwe Ibó, nokon main inontianra, jaskarara winoti kaai iki ixon moa en yoia iki. Jaskara iketianra Tarsissain ishtonbires ea jabati kakasa iki, enra onanke mia riki akonkin noibamis itan onísamis Dios, miara ishtonbires sináisma iki, kikinbires noimis ixonra jato masá tenemati yoixonbi, enra jato ayamai iki ixon min shinanai. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Jaskara iketianra, ea moa jamayamawe Ibó akin en mia yokatai. Jayamai moa ea mawatakayara jakon iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ikaxbira Ibon yoia iki: —¿Min oinnaki mia jaskati sinata jakon iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Ja jemameax bari joaiori kaxonra Jonassen jain; westíora pepan akax, jawen ota naman yakata iki, jaweki ja jema winotai ixon, jainxon oinni. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ibonra westíora nia nishi peia jawen jane ricino, Jonás manaon wexéti xoxomaxona iki, jawen otan mapoa jakonshaman shinannon ixonra aká iki. Ja ricino nia kopíra, Jonás kikin raroshaman iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ikaxbi, wetsa nete xabaketianra, Ibonbi amaa xenan ja ricino piá, moa choshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Bari pikóketianra, Diossen xana niwe bari pikotaiorixon payamaa iki, jatianra Jonás jawen mapokishaman barin akáa, moa beyosi, mawákasa iki. Jaskatira iká iki: —Moa jayamai ea mawatakayara jakon iti iki —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Jatianra Ibon yokata iki: —¿Ja ricino nishi moa choshiketian, mia sinataki min oinna jakon iki? ¡Jaskara riki en oinnara jakon iki! —akinra Jonassen aká iki. ¡Sinatira ea mawákasai! ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Jatianra Ibon yoia iki: —Minra ja ricino nishi banamaa iki, minra xoxo maamaribi iki; westíora yaméra xoxoa iki, jainoax wetsa yaméra moa mawata iki. Jaskara ikenbira mia jaon onisai. ");
INSERT INTO shpNTpo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Jaskara iketianra itibi ea Nínive jonibo noibai jato kopí onisai. Ja ani jemanra, pacha rabé chonka waranka bebonbires bake keska onanmabo jake, jabaonra jaskatax kishpinmeeti onanyamake, jainoaxa jain icha yoina jake —akin.");
INSERT INTO shpNTpo_vpl VALUES ("HK1_1","036_1_1","HAB","1","1","1","Natora profeta Habacuc Ibon onanmaa joi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_2","036_1_2","HAB","1","2","2","Ibó, ¿Jawetiankamanki min ninkatamabi mia yokati ea saí iti iki? ¿Jawetiankamanki, nato jakonma jawéki ikai kopí, noa akinni mia joaimabi mia yokákin en mia saí ati iki? ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_3","036_1_3","HAB","1","3","3","¿Jaweatiki ichabires masá teneti itan ichabires jakonma min ea oinmai? Jakonma masá teneti itan mawakanra ea kateke; jatíbiainra join iananankanai itan jakonmanankanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_4","036_1_4","HAB","1","4","4","Ja esekan yoiai keskára ayamakanai, ati keskáakinra jakonhakin jato benxoaxonyamakanai, joi benxoakinra jakonmabaon jakonbo jatoaresai, itan atikeskabiakin jakon atira wetsaakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_5","036_1_5","HAB","1","5","5","Oinkanwe wetsa mainmeabaonra mato kateke; oinnax ratékanwe. Ea riki moa atires, wetsabaon mato yoia maton ikonhatima keská jawékibora en ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_6","036_1_6","HAB","1","6","6","Ninkakanwe caldeobora reteanankasbo en jato imai, jabora ramiamis jonibo iki, nato mai rebestanira jatíbitian oken boanbekonkanai, jatona ikenmabi iboanoxon mai biira ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_7","036_1_7","HAB","1","7","7","Ja jonibaonra jato ratexon rakéakanai, wetsa esébo ayamakinra jatonabichores jakon shinankanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_8","036_1_8","HAB","1","8","8","Jaton kabayobora leopardobo winoa ishtobo iki, tsoa jonibi jain jaama mananmamea pimis yoinabo bebónbires sinábo riki. Ja kabáyonin peyakax boai jonibora kikinbires icha itan kikinbires ishtobo iki, jato akíra ochokeaxbi jatoki choronkanai, teté namiki paketai keskatira, jatoki choronkanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_9","036_1_9","HAB","1","9","9","Winókinra jatíbi keyokin ras abotankanai; ja bokinra jato rakéabotankanai, ja jato yatankana jonibora aniparo mashi xewinna bebónbires icha ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_10","036_1_10","HAB","1","10","10","Apobo itan kikin jakon joni koshibokira shirokanai. Jaton jema katemakin koshi chikékanara osankanai, jan mapétira ja chikékibi mashi keyá tsamankanai, jaskáxonra rátereskin jato yatankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_11","036_1_11","HAB","1","11","11","Niweaba koshi keskára winókana iki; jaton koshinbi jato akíra wetsa diossa noa keska yamake ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_12","036_1_12","HAB","1","12","12","Ibó ¿Miaki jatíbitianbires jaama iki, miaki jakon itan keyoisma Diosma iki? Miara nokon Ibo itan ea koiranna iki, caldeobo jato koshi menixonra, jabo meranxon atikeskabiakin min noa masá tenemaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_13","036_1_13","HAB","1","13","13","Mia kikinshaman jakonma néoma ixonra, jakonma akanai min amaresti atipanyamake, anibires jakonma akanairibira min jakonhaxon jato ointi atipanyamake, ¿Jawe keskákinki retemisbo min oinresai, jaweatiki jakonma jonin ja keskáma jakonbo jato reteaitian min netéxon oinresai? ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_14","036_1_14","HAB","1","14","14","¿Jaweatiki aniparomea yapabo akai keskáakin min jonibo akai, jan akinti koshioma yoinabo keskáakin? ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_15","036_1_15","HAB","1","15","15","Caldeobaonra wetsa maibo iboakanai, yapa biaibaon yapa bixon iboai keskáakin: miskitinin itan redbaonra bikanai, jaskara jatíbi tsamata oinnaxa kikinbiresi raroai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_16","036_1_16","HAB","1","16","16","Jaskákinra yapa biai jonin mishkiti betan jawen redbo rabiai, jainxonra jabo rabikin yoinabo retexonai itan incienso inintibo menoxonai, jabo kopíresa jakon itan icha pitia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK1_17","036_1_17","HAB","1","17","17","Jaskáakinki, ¿Caldeobaon jaton redbaon noa biboreskanti iki? ¿Noibayamakin jonibo jato reteboreskanti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_1","036_2_1","HAB","2","1","1","Netékainxonra en ninkatai itan jato koirannai sontáro jawen itinko iká keskára ea iti iki, jaweki Ibon ea yoiai ixonra en ninkáti iki, jakonma shinanni joikin, en yoiaki jawe ea yoiai ixonra en ninkáti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_2","036_2_2","HAB","2","2","2","Ibonra ea yoia iki: “Ja en mia oinmai mapó tablanin wishawe, ishton yoyo ati itiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_3","036_2_3","HAB","2","3","3","Nato min oinna jawéki jatian senenti nokotamapari ikaxbira; iamama senenti jake, Ja min oinna basiainbi, miabiribi manáreswe: ja ititianbiribira nokóti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_4","036_2_4","HAB","2","4","4","Jakonma jonibora rabitaibo iki ixon wishawe, ikaxbi atikeskabiakin senen akaibora, Dioski yoiti ikax jati iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_5","036_2_5","HAB","2","5","5","Rabí jonibora, joni koshi itin keenbo iki; ja ikaskin benai tantiyamaira jatíbitian bebon keenboreskanai, ja koshi iká jakonmamis ikenbi. Jaton kexa chopeara jain mawá minti kini keska iki, mawá keskáribi tantiti onanmabora ikanai, jaskara ixonra jaton maibo, jato bichinbotankanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_6","036_2_6","HAB","2","6","6","Ikaxbi jato mai bichinkanabora jatikaxbi jan jato bichinaboki shirokanti iki, jatokira bewakanti iki: “¡Jawe ireskiai panon mato, matonama ikenbi wetsabaon jakon kopí jawékibo biax mato icha jawékia banétabo! ¿Jawetian kamanki mato ribina kopí bixon, icha jakon kopí jawéki tsamani mato jenetai?” ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_7","036_2_7","HAB","2","7","7","Maton shinannamainbira, ja maton ribinabo matoki nokoti iki, jan mato masá tenemaibo matoki pikóxonra, jawebioma mato banékanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_8","036_2_8","HAB","2","8","8","Maibotiibi ikábora bianananax, mato akí matoki bechiakekanti iki, jatianra maton jato aká keskáribiakin, maton jawéki keyokin mato bichinkanti iki. Jatíbi eséki ramíkin maton aká kopíra, mato kopíamati iki, ja mainxon jemaboki itan jainoa joniboki bechiakexon maton meskó jakonma aká kopíribira mato kopíamakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_9","036_2_9","HAB","2","9","9","¡Jawe ireskiai panon mato, yometsokin bia jawékininra maton xobo, maton bochoake, jatíbi jakonmabaon mato akaitian, jan mato xabaatira maton ake! ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_10","036_2_10","HAB","2","10","10","Jaskáxonra maton xobon iká rarebobo maton rabintiake, ja maibotiibi ikábo ras axonra, matonbi jan mato keyoti ake. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_11","036_2_11","HAB","2","11","11","Ja jema chiké makanbobi itan ja xobo jiwi kanobobira matoki bechiaketax, mato ramiai saí ikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_12","036_2_12","HAB","2","12","12","¡Jawe ireskiai panon mato, jemabo akinra, esekan yoiaibo ayamaakin, itan atikeskabiakin jaskara ati maton ayamaa iki! ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_13","036_2_13","HAB","2","13","13","Jatíbi atipana Ibon imaara mato teeta, jainoax ja mato teeti paxkinairibi yanka iti iki, jatíbi maton tee akábora chiikan keyokin menoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_14","036_2_14","HAB","2","14","14","Jenen aniparo bochoa keskáakinra, Ibo jaskáaxon onanti shinan koshi nato main jatíbiain bochoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_15","036_2_15","HAB","2","15","15","¡Jawe ireskiai panon mato, mato patax ikábora paeya meskoxon jan beyósti rao maton jato xeamai, namanbires shinanmeexon keyokin jaton chopa jopeta oinnoxon! ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_16","036_2_16","HAB","2","16","16","Rabítitianbira, mato rabinresti iki, wetsabo maton aká keskáribiakinra Ibon mato ati iki, mato panaa chopa jopemaxon maton jakina rebichi maton xateama jato oinmai keskára mato ati iki, jatianra rabítitianbi mato namanbires shinanmeeti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_17","036_2_17","HAB","2","17","17","Líbano manan jaskáati ikenmabi maton jakonma akára matoki bechiaketi iki, jainoa yoinabo reteaxa mato ratéti iki. Ja mainmea jemaboki itan jaínoa joniboki bechiakexon esekan yoiai ayamaketian itan jakonmabires maton jato aká kopíra, matoki jaskara jawékibo nokóti jaki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_18","036_2_18","HAB","2","18","18","¿Ja rabiti jawéki jatonbi aká moa akin senenhakanatonki noa akinti iki? ¿Jawekeskaxonki jan jansotires ixon, ja rabiti jatonbi akátonin noa akinti iki? Ja rabiti jatonbi akára yoyo iti atipanyamake; ¿Jawekeskataxki jan jaskara akaibo ikonhax jatoki koshiti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_19","036_2_19","HAB","2","19","19","¡Jawe ireskiaipanon mato, ja rabiti aká jawéki jiwira maton jishtenwe akin akai, ja yoyo iosma makanra maton niwé akin akai! ¿Jabaonki joi bexon noa yoiti atipana? ¡Jawe akamakan, jara oro itan platanin rapoa ikaxbi jiriomabobi iki! ");
INSERT INTO shpNTpo_vpl VALUES ("HK2_20","036_2_20","HAB","2","20","20","Ikaxbi Ibora jawen jakon ani xobonko iki: ¡Jatíbi nato mainmea jonibo já bebonmeax netékanwe! ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_1","036_3_1","HAB","3","1","1","Nato riki profeta Habacucnin orana. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_2","036_3_2","HAB","3","2","2","Ibó, jatíbi min aká yoikanai ninkataxa, raketi ea saki ikai. Ani jawéki moatian min akábo, rama noa jaketian noa axonwe, nonribi onannon ixon. Jaskati sináxonbi min noa noibai noa oinmawe. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_3","036_3_3","HAB","3","3","3","Diossa Temán mainmeax joai; Parán mananmameaxa Jakon Dios joai. Jawen koshi shinanra naikan jatíbiain iki, nato netenxonra jatíbiainxon rabikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_4","036_3_4","HAB","3","4","4","Pené joekan kateara joai, jawen mekenmameaxa kaná joébo jokonai, jaskáaxonra jawen koshi janbi jonea onantiakin jishtiai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_5","036_3_5","HAB","3","5","5","Já joketianra jakonmabires isinbo beai, yoná koshiribira japekáo joai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_6","036_3_6","HAB","3","6","6","Já jainbi chankaketianra mai ninwana iki; jato oinnara maibotiibi ikábo raketi saki ikanai; ramanmantian mananbora reokootai, moatian mananbora ras ikai; Dios jan niai baira jatíbitianbires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_7","036_3_7","HAB","3","7","7","Cusán jonibo jakonma meranbires ikanaira en oinna iki, Madiánhin jaa jonibora raketi senbíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_8","036_3_8","HAB","3","8","8","¿Ibó, parobokiki mia sinata? ¿Kikínbiresiki aniparoboki mia sinata? ¿Jaskatiki min kabayobaon mia peyaka, janxon min jatoaresai carronki mia naneta? ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_9","036_3_9","HAB","3","9","9","Min kanóti betan jatíbi min piabora moa min benxoa iki. Parobo axonra, jan jene boai taebo min ake. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_10","036_3_10","HAB","3","10","10","Mia oinnaxa manánbo shakotai; naikanmeaxa oi kextó maannai, aniparo nemín itan anibechonra xóo ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_11","036_3_11","HAB","3","11","11","Min piabo kikin pené ikax, itan min lanza kikinbires kaná ikai keskati joétaitianra, bari betan oxe jonetax moa pikóyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_12","036_3_12","HAB","3","12","12","Sinataxa nato main jatíbiain mia niai; kikínbiresi sinataxa maibaon mia jaton penitai. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_13","036_3_13","HAB","3","13","13","Minra min jonibaon paranan ikín min jato akinna iki, jainxonra ja minbi katota aporibi min akinna iki. Jakonma jonibaon xobora min ras aka iki, jainxonra jan koshia shanka inonbi min jishtiakin pikoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_14","036_3_14","HAB","3","14","14","Jaton koshira jawen pianbi min retea iki, niweaba koshi beai keská rabíbeirani kabáyonin bexonra, jonéres jato keyonoxon jan kopímistiomabo jato tsakakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_15","036_3_15","HAB","3","15","15","Aniparo kikin jene neminhainra, min kabáyonin jatíbiain mia kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_16","036_3_16","HAB","3","16","16","Jatíbi neskara ninkataxa ea raketa iki. Ea keski ikaitianra, nokon witaxen moa tewanyamaa iki, jatianra jatíbi nokon yora koshi keyota iki. Jaskara ikenbira, noa jan jakonma tenemai, sontárobo Diossen masá tenemai nete nokotai kaman, jakonhaxonres en manati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_17","036_3_17","HAB","3","17","17","Higo jiwibo bimiamaibi, Uva jiwibo bimiamaibi, olivo jiwibo bimiamaibi; non wainko banaabo jawe tsekati yamakenbi; wakabo, carnerobobi yamakenbira, ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_18","036_3_18","HAB","3","18","18","mia, ea jan jamai iketianra, raroanan jatíbitian en mia rabiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("HK3_19","036_3_19","HAB","3","19","19","Nokon Ibó minra jakiribi benaakin ea koshi menia iki; chaxon ishto menixon, manan keyáinbo min ea raanara ea jain iká iki.");
INSERT INTO shpNTpo_vpl VALUES ("ML1_1","040_1_1","MAL","1","1","1","Nato riki Ibon profeta Malaquías meranxon Israel jonibo rama iti yoia joi: ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_2","040_1_2","MAL","1","2","2","“Enra mato noike”. Irai Ibo. Jaskatainbira maton yoiai: “¿Jawekeskaaxonki min noa noia, non onanna?” Ibonra mato yoiai: “Esaú betan Jacob ja bake rabébires ikenbira, já meranxon jawéki anoxon Jacob en katota iki, ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_3","040_1_3","MAL","1","3","3","ixonbira Esaú en katóyamaa iki. Jaskáribiakinra en mato noike. Jaskákinra Esaú jain jaa mai, niia manan mai ikenbi, tsoa jonibi jain jaama maibichores en banémaa iki, ja jawen maibora nii meranoa yoinabobichores jain jakon jati baneta iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_4","040_1_4","MAL","1","4","4","Ja Esaúkan chiní bakebo, edomitabaonra yoikanti iti iki: “Non rawíbaonra non jawékibo noa keyokin ras akanankana iki, ikaxbi jaskáakankenbira non main jakiribi non aríbakanti iki”, iki ixon. Ikaxbira jatíbi atipana Ibon jato yoiti iki: “Jabaonra jakiribi jaton jawékibo aríbakanti iki, ikaxbira en jato ras akanribiti iki. Jaton main janera iti iki ‘jakonma mai’, itan ‘ja mainmea joniboki, jawetio basi inonbi, ikonbiresi Ibo Dios sinata iki iká’ ”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_5","040_1_5","MAL","1","5","5","Mato Israelbaonra, maton beronbi ointi iki, jatianra maton yoiti iki: “¡Ibora jain non mai senenna bebonbires koshi iki!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_6","040_1_6","MAL","1","6","6","Jatíbi atipana Ibonra sacerdotebo yoia iki: “Bakebaonra jaton anibo jakonhakanti iki, jainoax ja teemakanaibaonra jan jato yonoaibo jakonhakanti iki. Ea maton papa ikenbiki, ¿Maton ea jakonhayamai? Iresabires shinankinra maton ea jakonhayamai”, akin. Jainoaxibira mato ikai: “¿Jaweki mia iresabires non shinanna?” iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_7","040_1_7","MAL","1","7","7","Jainxon yoina menoti en iboainkora jakonma pan mato sacerdotebaon beai, jaskara akinbira maton ea yokatai: “¿Jawe jawékininki mia non jakonmaa iki? Maton ea jakonma aká riki, nokona ikenbi jainxon yoina menoti maton iresabires akin shinannai kopí, ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_8","040_1_8","MAL","1","8","8","itan mato sacerdotebaon shinanna riki, yoina benchebo, chantobo, iamax isinaibo inonbi ea meninoxon beti”. ¡Maton joni koshibo jaskarabo boxontankanwe! ¡Oinkanwe, jabaonki maton menia jakonhaxon bitiki ixon! ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_9","040_1_9","MAL","1","9","9","Mato noibanon ixon Ibo Dios yokakanwe. Ikaxbi jaskara jakonma jawékibo akinra maton shinantima iki, Ibo Diossenra noa akinnai ixon. Jatíbi atipana Ibora neskata iki: ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_10","040_1_10","MAL","1","10","10","“¡Mato wetsabiresxon Ibo Diossen xobo xepoa ipainon riki, jainxon yoina ea menoxonti yankabires moa chii keteawetsatima iti”, akin! Maton ea jawebi raromayamai kopíra, jawéki maton ea meniresabo moa mato en bixonyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_11","040_1_11","MAL","1","11","11","Jatíbi nato netemea maibotiibiainxonra ea kikin ani shinankanai; incienso inintira ea menoxonkanai, jainxonra jakon jawékibo ea menikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_12","040_1_12","MAL","1","12","12","Jaskara ikenbira, matonbiribi ea jakonmake, jainxon yoina menoti nokona ikax, nokon mesa ikenbi, maton shinanna riki iresabires iti, jaskara ikaxa jain iká pitiribi iresabires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_13","040_1_13","MAL","1","13","13","Matora ikai: “¡Jatíbi nato jawékibaonra noa moa paxkina iki!” ikibo. Jaskákinra maton ea iresabires shinannai. Jainxonra maton shinannai yoina yometsoxon, iamax waka chanto, iamax waka isinai ea meninoxon maton beketian ea raroti. ");
INSERT INTO shpNTpo_vpl VALUES ("ML1_14","040_1_14","MAL","1","14","14","¡Kikinshaman jakonmara iti iki, ja janso joni, jakon yoina ea meniti yoia ixonbi, yoina jawen yoranko jakonma neeya ea menia! Ea riki ja kikin Apo, maibotiibira eki rakékanai. Nato jaskara yoiaira jatíbi atipana Ibo iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_1","040_2_1","MAL","2","1","1","Sacerdotebó, ramara nato esé matona iki: ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_2","040_2_2","MAL","2","2","2","“Matonra ea yoiti ixonti iki, jainxonra akonkin shinanxon maton ea jakonhati iki. Ja maton ayamaketianra, jakonmakin en mato shinanti iki. Jatian jakonhakin shinanxon maton ea jakonhayama iketianra, sacerdote iketian jan mato jakonha jawékibo jakonmakin en shinanti iki”, iki ikábo. Jatíbi atipana Ibonra jaskara yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_3","040_2_3","MAL","2","3","3","“Ja sacerdote iti koshira en mato bichinnai, jainxonra ja ea menoxonti maton bea yoinabaon poko meranoa poinbi en mato beskiti iki. ¡Jatianra poi betanbi en mato potati iki! ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_4","040_2_4","MAL","2","4","4","Jaskáxonra ja ati en yoia esé maton onanti iki, ja maton reken Leví betan en jaskara senenhabekonti shinanni joi jatíbitian iti”. Jatíbi atipana Ibonra jaskara yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_5","040_2_5","MAL","2","5","5","Ibonra yoiboresa iki: “Ja senenhabekonti joi en yoiara Levíkana jan jati betan jakonshaman iti iká iki, en jaskara aká riki. Eki yoiti ikax, rakénon ixon, jatianra jan jaskara aká iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_6","040_2_6","MAL","2","6","6","Jainxon Levikan jato jakon jawékibores axeaara paranmisma ikana iki, itan jawe jakonmabi yoyo iosmabo. Kikin jakonresa ebetan jaa iki, jaskara ixonra jakonma akaibo jato ichabires jenemaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_7","040_2_7","MAL","2","7","7","Sacerdotebaon, tee riki, jakonhakin jonibo axeati, ea chibankanon ixon, jaskara iketianra mato axeanon ikax jatoiba mato kati iki, jabora jatíbi atipana Ibon joi boaibo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_8","040_2_8","MAL","2","8","8","“Ikaxbi mato, sacerdotebora jakonhainoax wetsaori kake; ja maton axeabora icha maton jato pakémaa iki. Jaskáxonra, jawen chiní bakebo sacerdote inon ixon, en maton reken Leví betan jaskara senenhabekonti aká joi, maton jawebi senenhayama iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_9","040_2_9","MAL","2","9","9","Jaskati mato eki yoitimaa iken, itan jaskábichopanan, jato axeakinbi jatíbi jonibo maton senenbires ayama ikenra, en amaa mato jonibaon onanxon, moa mato iresabires akin shinankanti iki”, jatíbi atipana Ibonra jaskara yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_10","040_2_10","MAL","2","10","10","Ea Malaquíasninra mato yokatai ¿Jan noa jonia Ibo Dioski, jatíbi jonibaon Papama iki? ¿Jawekopíki, jaskati parananankin non rekenbo betan Ibo Diossen, jaskara senenhabekonti joi aká ikenbi non ramiai? ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_11","040_2_11","MAL","2","11","11","Judá jonibaonra Ibo Dios senen ixonyamai, jaskákinra Jerusalénhainxon itan jatíbi Israelhainxon jakonmaira jawéki akanai. Ibon noia xobonkoxonra, ocha atima ikenbi; jakonma akanke, itan Judá jonibaonra awinhanoxon ainbobo bike, jabora jatonbi aká ikonma dios rabiaibo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_12","040_2_12","MAL","2","12","12","¡Jaskara jawéki akaibo, Ibon non mainmea keyokin potapainon riki, wetsabires inonbi, jatíbi atipana Ibo jawéki menikin bexonaibobi! ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_13","040_2_13","MAL","2","13","13","Ikaxbira maton bebonbires akai: Ibo jainxon yoina menoxontira maton beon jenenbi montanai, jainxon ja maton jawéki meniaibo Ibon jakonhaxon mato bixonyamaara, ikonbiresi onisi yoyo iananbi mato winiai. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_14","040_2_14","MAL","2","14","14","Jatian mato yokakaatai riki, ¿Jaweatiki noa jaskáai? Ja Ibonra onanke, ja mia bakeranontian jabé wanoa ainbo betan ja axonti yoixonbi min senenhayamabo. ¡Jara mia jabébiribi iká iki, jaskákinra wetsabo betan ikin yosmaatima min yoia iki! ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_15","040_2_15","MAL","2","15","15","¿Jan non yora betan non shinan joniaki, ja Diosbichoma iki? ¿Jatianki jawen Dios keenai, non chiní bakeboki janwenaribi itima iki? ¡Jaskara iketian, matonbi maton shinan koirankanwe, jaskáaxon ja bakeranontian maton bia maton awin jaskáatima yoia ixon, yosma ayamakanwe! ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_16","040_2_16","MAL","2","16","16","Ja Israelnin Ibo Dios, jatíbi atipanatoninra yoiai: “¡Matonbi maton shinan koirankanwe, maton awin yosmaayamakanwe; jaton awin potai jonibaon ochara en omisai, jaskara jakonma akátoninra mato ochai!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML2_17","040_2_17","MAL","2","17","17","Ibora, mato jaki jakonmai yoyo ikai ninkati moa jatsanke; jaskara ikenbira maton yokatai: “¿Jawe non yoia ninkataxki jatsanaa?” akin. Jakonma akaibora Ibon keen iki ixonra maton yoia iki, jaskatira jato betan raroshaman iki ixonra maton yoiai. ¡Diossa atikeskabiakin jakon akai iki ixonra, maton ikonhayamai! ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","Jatíbi atipana Ibonra yoiai: “Nokon joi boai jonira en raanai, nokon bai ea benxoaxonti. Ja maton benai iitai Ibora jawen xobonko moa ratéresi jikiai. ¡En jaskara senenhabekonti aká joi boai joni, ja jotín mato keenaira moa nokotai!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_2","040_3_2","MAL","3","2","2","Ikaxbi ¿Ja joai neteki tson bechiteti iki? ¿Tsoaki jainbi chankati iki? Chii tiri keská joxonra, non ocha soati iki; non kerásbo chokai jabón keskára iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_3","040_3_3","MAL","3","3","3","Levikan chiní bakebo, ja sacerdotebo jaton ocha soaira Ibo yakáti iki, plata itan oro chii tirikan axon penéakanai keskáakinra ati iki. Jaskaa pekáora jabaon atikeskabiakin Ibo jawéki menikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_4","040_3_4","MAL","3","4","4","Judá jonibo betan Jerusalén jonibaon jawéki meniara Ibo raroti iki, moatianbo jawéki menikana ikátiai keskatira raroti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_5","040_3_5","MAL","3","5","5","Jatíbi atipana Ibonra yoiai: “Maton ocha akábo mato yoixonira ea joti iki. Enbi onanna ixonra yobé jawéki akai jonibo en jaton jakonma yoixonti iki, wanoyanixbi teamisaibo, ikonma ikenbi jansoi ikon riki ikaibo, teemaxonbi jato kopíayamaibo, benomaatabo betan kachianabo jato ramiaananbi yonoaibo, wetsankoniax joá jato ramiaibo itan eki jakonmaibo, jabora jaton jakonmabo en yoixonti iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_6","040_3_6","MAL","3","6","6","“Ea Ibora, wetsakeskatama iki. Jaskara ixonra mato Jacobnin chiní bakebo, en mato keyoyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_7","040_3_7","MAL","3","7","7","Maton rekenbaon aní keskaribiakinra nokon esé ati en mato yoia maton jenea iki, jaskatira mato yoitimaa iki. Ea, jatíbi atipana Ibo Diossenra, mato yoiai: Maton ochabo jeneax eki beribakanwe, jatianra enribi mato koiranti iki itan jatíbinin en mato akinti iki. Ixonbira maton ea yokatai: ¿Jawe jakonma akainkoniaxki noa jakiribi miki banéti iki? akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_8","040_3_8","MAL","3","8","8","Ikaxbira en mato yokatai: ¿Joninki atipana ja bikasai Dios meniamakin? ¡Ja en bikasaira maton ea meniamake! Jatianra maton ea yokaribipariai. ‘¿Jawe keenaibiki mia non meniamaa?’ ¡Ja chonkankonia westíorabo ea menitinin itan maton jawékibo menitininra maton ea yometsoake! ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_9","040_3_9","MAL","3","9","9","Mato jatíxonbira, nato mainmea jonibaon maton ea yometsoake, jaskara ixonra mato jatíbi jakonma inon ixon en yoiai. Ea, jatíbi atipana Ibonra, en mato yoiai: ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_10","040_3_10","MAL","3","10","10","Jaskara iken nokon xobonko, ja chonkankonia ea westíora meniti senen keyokin boxon, ja koríki ati cajanko akanwe; maton jaskáara jawetianbi jawékiati maxkátima iki. Jaskáakin ea rama tanakanwe, maton oinnon ventanabo kepenai keskáakin nai kepenxon, mato jakon jawékibaon jayákaresnon ixon en mato akinnon. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_11","040_3_11","MAL","3","11","11","Jainxonra maton wainkonia yoabo itan maton uva waibo, jan mato keyonanai jakonma ikibo en mato keyoxonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_12","040_3_12","MAL","3","12","12","Jatíbi wetsa mainmeabora mato yoii jakonshamanbora ikanai, iki ikanti iki, maton maira jan keentishaman iti iki. Ea, jatíbi atipana Ibonra jaskara yoiai”. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_13","040_3_13","MAL","3","13","13","Ibonra neskara yoiai: “Jakonmaibiresa mato eki yoyo ikai. Jaskákinbira maton ea yokatai: ‘¿Jawe jakonmaki noa miki yoyo ika?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_14","040_3_14","MAL","3","14","14","Neskatira mato yoyo ike: ‘Jatíbi Dios tee axontira yanka jawéki iki, ¿Jatíbi atipana Ibon yoia axonki jawe jakon non biti iki, itan ja oniskin ati chopa sawexonki jawe jakon non biti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_15","040_3_15","MAL","3","15","15","Nonra oinke, ja rabitai jonibora jakonbires jakanke, jainoax jakonma joniboribira jatíbitian jakonbires jakanke, jawetianbira jabo jakonma jawéki winóyamai itan Ibo Dios tanakin jakonmaxbira, jawe masábi teneyamakanai’ ”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_16","040_3_16","MAL","3","16","16","(Ja Dios rabiaibo jatonbiribi yoyo ikaitianra Ibon netekaixon ninkata iki. Jaskákinra ja shinanti kopí, ja Ibo bebonxonbi westíora kirika meran ja rabiaibaon janebo wishamaa iki.) ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_17","040_3_17","MAL","3","17","17","Jatíbi atipana Ibonra yoia iki: “Eara benxokaati iitai nokon jonibo jakiribi eki bekanti nete jati iketian. Jawen tee axonai bake, jawen papan noibai keskáakinra, en jato noibati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML3_18","040_3_18","MAL","3","18","18","Jatianra maton ointi iki, Ibo Diossen ja jakon akábo betan jakonma akábo jato senenbires jakonhati atipanyamaa, jaweratoki jakon iki ixon itan jaweratoki jakonma iki ixon, jainxon ja Dios rabiaibo itan ja rabiamaibo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Jatíbi atipana Ibonra neskara yoiai: “Ja nete nokótira moa ochóma iki, horno ketea tiritai keskatira tiriti iki, jatíbi rabitaibo itan jakonma jonibora bimi jawéki xaká ikai keskati chii tiritainko menókanti iki. Ja nete nokoxon jato menoara, jawebi yamatii jabo menókanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Ikaxbi mato, jan ea jakonhaibora, atikeskabiakin en jakon akára bari penekan tenaa keskati jistibires iti iki. Jatianra waka bake, kene meranoa pikoa raroi choronai keskati mato iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_3","040_4_3","MAL","4","3","3","Ja netera en moa mato benxoaxona iki, jatianra jakonma jonibo mai poto akai keskáakin maton jamáti iki. Ea jatíbi atipana Ibo ixonra, jaskarara iti iki ixon, en mato yoiai”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_4","040_4_4","MAL","4","4","4","Ibonra yoia iki: “Israelitabó, Horeb mananmanxon nokon yonoti Moisés meranxon, en nokon esé mato menini shinanbenoyamakin senenhakanwe. ¡Ja esébo itan ja ati joibaon yoiai akira, jatíbi Israel jonibo yoiti ikanti iki! ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_5","040_4_5","MAL","4","5","5","Oinkanwe, jonibó, Ibon jato masá tenemati nete nokotamatianbira, profeta Elías en jato raanxonti iki, jara kikin jakonma nete itan onsá iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("ML4_6","040_4_6","MAL","4","6","6","Janra papabo betan jaton bakebo raeananmaxon jakon jamati iki. Ikaxbi jaskáyamakanketianra, en joxon keyokin ras axon en mai ramiati iki”, akin.");
INSERT INTO shpNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristora iká iki David betan Abrahamman chiní bake. Natobo riki jawen rarebo ipaonibaon janebo: ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamman bakera iká iki, Isaac. Isaacnara iká iki, Jacob. Jacobkanara iká iki, Judá betan jawen wetsabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ja Judákanabiribi iká iki, Fares betan Zera, jaton tita iká iki, Tamar. Faresnabiribi iká iki, Esrom, Esrommanabiribi iká iki, Aram. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arammanabiribi iká iki, Aminadab, Aminadabkanabiribi iká iki, Nahasón. Nahasónmanabiribi iká iki, Salmón, ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónmanabiribi iká iki Booz, jawen tita iká iki, Rahab, jatian Booznabiribi iká iki, Obed, jawen tita iká iki Rut. Ja Obednin bakebiribi iká iki, Isaí, ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíkanabiribi iká iki apo David. Apo Davidkanabiribi iká iki, Salomón, jawen tita iká iki ja Uríasnin awin ikátiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónman bakebiribi iká iki Roboam. Roboammanabiribi iká iki Abías. Abíasnabiribi iká iki, Asá. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asákanabiribi iká iki Josafat. Josafatnabiribi iká iki Joram. Jorammanabiribi iká iki, Uzías. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasnin bake iká iki, Jotam. Jotammanabiribi iká iki, Acaz. Ja Acazsen bake iká iki, Ezequías. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ja Ezequíassenabiribi iká iki, Manasés. Manaséssenabiribi iká iki, Amón. Ja Amónmana iká iki, Josías. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jatian ja Josíasninbiribi bakea iki, Jeconías itan jawen wetsabo, jaton rawibaon yatanxon Babilonia main jato bokanontian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jatian, moa jakiribi Babiloniainoax beribakana pekáora; Jeconíassen bakeaa iki, Salatiel. Salatielnin bakebiribi iká iki, Zorobabel. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ja Zorobabelnin bake iká iki, Abiud. Abiudkanabiribi iká iki, Eliaquim. Eliaquimmana biribi iká iki, Azor. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ja Azornin bake iká iki, Sadoc. Jatian Sadocnabiribi iká iki, Aquim. Ja Aquimman bakebiribi iká iki, Eliud. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ja Eliudnin bakebiribi iká iki, Eleazar. Eleazarnabiribi iká iki, Matán. Ja Matánman bakebiribi iká iki, Jacob. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jatian Jacobnin bakera iká iki José, jara iká iki ja Marían bene. Ja *Cristo akin akanai, Jesussen tita. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaskara ikaxiki, ja Abraham iníainoax David iní senen, chonka chosko Criston rekenbo iká. Jainoax David inontian, Babiloniain jaton rawíbaon jato bokanontian riki, chonka choskoribi. Jatian Babilonia main jato bokanontian, Cristo pikóni senen riki, chonka choskoribi, ja Criston rekenbo ikana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jaskatax Jesucristo pikóni riki neskara: Maríara iká iki, Josekan binoxon yoia moa jen ika. Ikaxbi biamapari ikenbira, María toota iki; Diossen Shinanman atipana koshin imaa. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jatian José iká iki ponté shinanya joni; jaskara ixonra, jonibo bebon María jakonma banémakashamakin, shinanna iki jonéshokores jeneti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Moa jaskáanoxon shinankenbira, namá meran non Ibon ángelnin, neskáakin yoia iki: “José, mia riki Davidkan rarebo, rakéyamawe María betan wanotinin, ja tootara Diossen Shinanman atipana koshin imaa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ja bake pikotara benbo bake inóxiki. Jara Jesús akin min janeti jake; janra jawen jonibo jaton ochabo soaxon jato kishpinmanoxiki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nato jawékibora winota iki, ja non Ibon jawen *profeta neskáakin yoimani keská senennon ikax: ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jonin tanatama xontakora toonoxiki, ja bakenara benbo bake inóxiki. Jara Emanuel akin janenoxikanai”, iki iní. Ja joi iki “Dios iki nobetan”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jaskáakin namá meran, ja Ibon ángelnin yoiara, oxá besotaanan kaxon, jan yoia keskáakin moa Josekan María awinhakin bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ikaxbi, ja bakenai kamanpari jabé yoranyamaa iki. Jatian moa bakenketianra, ja pikota bake, Jesús akin Josekan janea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesússa pikota iki, Judea main iká Belén jemameax, Herodes ja mainmea apo inontian. Jatianribira onan jonibo, bari pikotaiorikeax beax, Jerusalénhain nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jain nokóxon, jato yokákana iki: —¿Ja judíobaon apo pikóbena bakeshokoki jawerano iki? Bari pikotaiori, jawen wishtin pikota oinbeiranira ja rabii noa joke —akin jato yokákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jaskara ninkatax, apo Herodes kikini shinan tsokasa iki. Jatianra jatíbi ja Jerusalénhain iká joniboribi jabébi jaskákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jaskákinra, jatíbi ja *sacerdotebaon koshibo, itan esé onanbo, jato Herodesnin kenamaa iki. Jainxon jato yokata iki: Jaweranoax *Cristo pikótiki, yoikatikanai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jatian yoikana iki: —Judea main iká Belénhainoax itira yoikanike; jaskara yoikinra ja *profetanin wishanike: ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ja Belén jemara, Judá main iká ani jemabo xaran, jakonmashokoira jemama iki. Jainoaxkaya westíora apo pikóxon, jan *Israel jonibo jato akinti ikax’, ikira ikai, akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jaskáakanara, jonéshoko ja onan jonibo jato kenamaa bekanketian yokáxon, Herodesnin onanna iki jatianshaman wishtin pikota merakana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jaskáa pekáo, moa Belénhain raankin jato neskáa iki: Botankanwe; boxon, jawekeskarainshamarin ja bake ixon, benatankanwe, jatian moa nokoxonra, maton ea keshanti iki, enribi kaxon já rabishokoti kopí —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jaskáakinbo jato apon yoia pekáora, ja onan jonibo moa bokana iki. Jatian ja bari pikotaiokeax wishtin pikota oinbakana, jato bebon kakaresa iki. Kaax, jain bake iká pontéshamanbi tsasia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jaskáakin ja wishtin oinnax, ja onan jonibo kikinbiresi rarokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jatian, moa xobo meran weixon, ja bake jawen tita María betanbi oinkana iki. Jainxon ja bebon chirankooxon ja bake rabikana iki. Jaskáatanan jaton bonantibo kepentaanan, oro, *incienso, *mirra, jawekopímabi ja bake menireskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Japekaora, namá meran moa jakiribi Herodes ikain bokantima jato yoia, moa jaton main karibai, wetsa bain bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Moa onan jonibo bokana pekáo, non Ibon ángelnin namá meran José yoia iki: “Oxá besotaanan wenixon, ja bake betan jawen titabi, Egiptonko jabákintanwe, Herodesninra ja bake retenoxon, jato benamati jake. Kaax, jainpari itanwe, jakiribi mia jonon ixon en mia keshanai kaman”, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ja yamébi, oxá besoax wenixon, Josekan ja bake betan jawen titabi jabákinkin Egiptonko jato boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kaax, Herodes mawatai kamanpari jain ikana iki. Ja *profeta meranoax, “nokon bakera en Egiptonkonia kenamanike”, iki non Ibo yoyo ini joi senennon ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jatian ja onan jonibaon moa parana onanaxa, Herodes kikinbiresi sinata iki. Jaskáxonra ja Belénhain, itan ja ochóma iká jemameaboribi, jatíbi pikóbena itan rabé baritiaya benbo bakebo, jato keyo retemaa iki. Moa jatio basi ja wishtin pikota onan jonibaon yoiibata iketian onanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaskataxa, ja *profeta Jeremíasnin yoini joibo senena iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá jemanra, kikinbiresakin masá shinanni winiananbi sion ikaitian ninkákana iki. Jara iká iki Raquel, jawen bakebo kopí winii. Tantimakaskanabira, keenyamaa iki, jawen bakebo moa keyo mawata iketian”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jatian moa Herodes mawata pekáora, Egiptonkobipari iketian, José ja Ibon ángelnin namá meran yoiribia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Oxá besotaanan weníxon, ja bake betanbi jawen tita, jakiribi *Israel mainko iotanwe, ja maton bake retekasi ipachoaibora, moa mawákanke”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jaskáa oxá besotaanan wenixon, Josekan ja bake betanbi jawen tita jakiribi jato *Israel main ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jatian kakinbi ja Herodesnin bake Arquelao jawen papan toan, Judeain apo iká ninkatax, raketi jain kakashamaa iki. Ikenbi, Diossen namá meran yoia, moa jain kayamai, Galilea mainres kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jain nokotax, Nazaret jeman jaai bokana iki. Jaskarabora winota iki, Nazarethainoa akin Jesús akanti, *profetabaon yoikatitai senenti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ja netebaonribira jato *bautizanai Juanman ja Judeain iká jain joni jayamainkoxon jato joi yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ja joi yoikin jato neskaa iki: “¡Maton jakonma shinanbo akonkin jenekanwe, ja Diossen ikinaton jati netera, moa ochómabires iki!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja Juan jaskáti yoiira inike ja *profeta Isaías neskati: “Jain joni jayamainkoniaxa joni saí ikai: ‘Non Ibo bai benxoaxonkanwe; jakonshamanhakin ja bai pontexonkanwe’ ”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja Juanra iká iki, camello rani chopa sawéya. Jainoax bichi sintóranin chinexeya. Jawen piti iká iki, chanpo, jawen xeati iká iki, bona jene. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jatian jan joi yoiai ninkatira, icha jonibo Jerusalénhainoax, itan Judea mainmeaxbo bekana iki. Jainoax ja Jordán main iká ochómakeaboribi bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jatian, jaton ochabo keshakanketian, Jordán weanmanxon, jato Juanman bautizana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ikenbi icha *fariseobo betan *saduceoboribi, Juanman jato bautizanon ikax bekana oinxon, jato neskáakin yoia iki: “Matobo riki, jakonmabo ikax, rono kaita keská jonibo. ¿Tsonki yoia ja masábires tenetiain kati iitibi matoribi kishpinti? ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ikonkon moa maton jakonma shinanbo jenea onanti iti kopíkaya, moa jakoni jakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Matonbinix: ‘Noakayara Abrahamman chiní bakebo iki’, iamakanwe, Diossenra nato makanbo inonbi Abrahamman chiní bakebo itiakin joniati atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja yamira moa taponyabiakin jiwi xatetires inon ixon, ja namanbi rakana iki. Ja jakoni bimiamai jiwibora, moa yamin taxteanan chiikan menokanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Enra onpaxenres jato bautizanai, jaton jakonma shinanbo akonkin jenekanon ixon. Ikaxbi epekaora westíora joni joai, janbiribira jato bautizanoxiki, ja Diossen Shinanman, itan chiikan. Jara ebebon jatíbi atipana koshia iki, jawen zapatotanibires boxonti jisáma riki ea. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jara moa jan payanti tsomáya iki. Janra ja trigo bimibo payanhanan jawen xakábo potamaxon, ja bimibichores bixon, jain benxoatinko benxoanoxiki. Jatian ja xakábobiribira, jawetianbi tiriti nokayamai chii meran potaxon menonoxiki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jaskákenbi Jesús Galileankoniax Jordán wean ikain kaa iki, jain Juan iketian, jan bautizanon ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kakenbi akáshamakin Juanman yoia iki: —Minkayara ea ati iki bautizankin; ¿Jatian miakaya en imanon ikax eiba joá? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jaskáabi, Jesussen yoia iki: —Ramabichores jaskara anon awé, jaskara itin Dios keena jawéki, non senenhakayara jakon iti iki —akin. Jaskáakin yoia, Juanman bautizana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ja moa bautizana mapetaitianribi, nai chopeta iki. Jaskaketian Jesussen oinna iki, ja Diossen Shinan, xotó keska joáx jaonbi peyakatoshiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jaskataitianribi, naiorikeax yoyo ika iki neskati: “Nato riki nokon noi bake, jaonra ea ikonbiresi raroai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jaskata pekáo, Diossen Shinanman, jain joni jayamainko Jesús boá iki, *Satanássen tananon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jatian, moa chosko chonka nete, itan chosko chonka yaméribi, jawékiaama ikax moa jawékiakasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jatian, ja Jesús ochamakaskin tanai, *Satanás jaki joá iki, joxon yoia iki: —Diossen Bakekon ixon, nato makanbo pan imawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jaskáabi, Jesussen neskáa iki: —Diossen kirika meranra yoiai: ‘Jawékiatininbichora joni jayamake, Diossen yoiai joibo senenhairibikayara joni jati jake, ikira ikai’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Japekaora, Satanássen Jesús Jerusalénhain boríbaa iki. Jainxonra ja Dios rabiti xobo bochiki boxon, ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yoia iki: —Ikon Diossen Bake ikax, nenoax naman choronwe, Wishá meranra yoiai: ‘Diossenra jawen ángelbo raanti iki, mia koirannon ixon. Jatianra paketamabi mia jabaon weninti iki, min tae makanki choshíkaintima kopí’, iki ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jaskáabi, Jesussen yoia iki: —Diossen joi meranra yoiai: ‘Non Ibo Dios jawetianbi tanatima’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jainxonra jayá senentiainbi, ja Satanássen manan keyá ikain boríbaa iki. Jain boxonra, jatíbi nato netemea ani jemabo oinmaa iki, jaton ani jawékiboyabiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jaskáaxon yoia iki: —Ebebon chirankooxon min ea rabiketianra, jatíbi nato jawékibo en mia meniti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jaskáaketianra Jesussen neskáa iki: —Nenoax katanwe Satanás. Diossen joi meranra ikai: ‘Non Ibo Diosbichores rabikanwe, itan jabichoresibi jawen keenabo axonkanwe iki’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jaskáa ja Satanás moa kaa iki. Ja kaketian, Diossen ángelbo bexon, Jesús akinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jatian Judeain iikinbi, cárcel meran Juan akana ninkatax, Jesús Galileanko kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ikaxbi, Nazaret jemanko banéyamai, ja Galilea ian kexa iká Capernaúm jemankores jaai kaa iki, ja Zabulón betan Neftalí jonibaon mainko. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaskara iti yoikin ja *profeta Isaíassen wishani keská senennon ikax. Jara inike neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ja Jordán keiba itan aniparo ochóma iká, Zabulón betan Neftalí main jakanabo; jainoax, ja Galileanko jakana judíoma joniboribi, ninkákanwe: ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ja yamé keska meran jakátiai jonibaonra, moa westíora joé oinkanke, ja onsá mawá meranbires jakatiaibora moa jato joekan tenake”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jainxonra moa joi yoikin peokin jato Jesussen neskáa iki: “Maton jakonma shinanbo akonkin jenekanwe, ja Diossen ikinaton jati netera, moa ochóma iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jatian Galilea ian ketani kakinra, já wetsa rabébires rikani iibekonaitian Jesussen nokoa iki. Ja iká iki Simón Pedro betan jawen wetsa Andrés. Jabo iká iki yapan teetaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jainoa jato Jesussen neskáakin yoia iki: —Ea chibankanwe, jonibo biai itiakinbiribi en mato imanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jato jaskáa, jatianbi jaton rika jainbi jenebaini, jabé kabékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jatian orichaa kakinra, já wetsa rabébires Jacobo betan Juan Jesussen nokoribia iki, jaton papa Zebedeo betanbi botenxon rika onai iitaitian. Jainoa jato kenaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jato jaskáakin kenaatianbi, ja boteyabiakin jaton papa potabaini, Jesús betan kabékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jatíbi ja Galilea main iká jemabaonra Jesús kawantana iki, jain tsinkíti xobo meranxonbo jato eseboi. Ja Diossen ikinaton jati jakon joibo jato yoiboa iki, itan meskó keskati isini chexakaataiboribi jato benxoaboa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jaskarabora jatíbi Siria main ninkakaata iki; jaskara ninkáxonra, meskó isinyabo bexonkana iki. Yoshin naikiabo, maxkaibo, yora koshiamaibo; jainoax meskó keskati chexakaati isinaibo. Jaskarabora jato Jesussen benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jatianra kikinbires icha joni, Galileankoniax, *Decápolissainoax, Jerusalénhainoax, Judeainoax itan ja Jordán keibakea iká mainmeaxboribi Jesús chibani bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jaskati joni icha bekana oinnaxa, mananman mapetax Jesús jain yakata iki. Jatian jaonmea onannaibo ja patax bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jainxon jato esekin peoa iki, neskáakin: ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dioskires ikoni koshiax jakanabora, Diossen raroshaman imati iki. Jabora jawen neten jato Diossen ikintibo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ja winiaibora Diossen raroshaman imati iki. Jabora Diossenbi jaton shinanbo tantimati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ja rabí shinanhomabora Diossen raroshaman imati iki. Jabaonra jato mai meninoxon yoini, bikanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ja pikasai keskati itan nomiai keskati, atibi keskáakin atin kikini keenaibora, Diossen raroshaman imati iki. Jabora jaton shinanna keskáakin Diossen imaxonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ja noibamisaibora, Diossen raroshaman imati iki. Jabora Diossenbiribi noibashokoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Moa jato meran jakonma shinan yamaabora Diossen raroshaman imati iki. Jabaonra Dios oinnoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jakonshaman jakanon ikax jato akini teetaibora, Diossen raroshaman imati iki. Jabora ikon Diossen bakebo riki, akin akanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ja itibi keskati jaketian, jakonmaakanaibora, Diossen raroshaman imati iki. Jabo riki jawen neten jato Diossen ikintibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ja ea kopi ramiakanaibo, ja masá tenemakanaibo, itan ikámainkobi jato join imakanaibora, Diossen raroshaman imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mato jaskáakana, ikonbiresi rarokanwe, naikanxonra ja biti kikinbires ani jawéki maton bii kati jake. Jaskáakinribira masá tenemakana iki, ja mato yamaatian japaoni *profetabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Matobo riki nato netemea tashi keskabo. Ikaxbi ja tashira moa jawen moka keyotax, jawekeskataxbi mokayamai, jara moa jakonma iketian jema napon potatires iki jonibaon winókin jamáreskanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Matobo riki nato nete jan tenaa joé keskabo. Westíora jemara manan maxkaten itinax, joné iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tsonbira joé keteaxon jawékinin mapoyamai. Jaskáyamakinra, bochikishamanres peyasankanai, jatíbi ja xobon ikábo ja joekan jato tenati kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jaskara joé keskara iti jake maton iká jawékibo, jonibo bebon. Ja maton jakon jawékibores akaitian oinxon, jabaonribi ja naikan iká Papa rabishokokanti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Shinanyamakanwe, ja Diossen esé itan *profetabaon yoiai joibo, jawemabi itiakin imai ea joá. Eara jawemabi itiakin imai joáma iki. Ja esekan yoiaibo senenti kopí riki ea joá. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ikonshamanra en mato yoiai: Ja nai betan mai japariketianra, westíora joibi ja esé non soananti atipanyamake, jatíbi jan yoiaibopari senenai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jaskara kopí, tsoabaonki ja esé meran iká senenhati joibo, atibires keskáshokobobi senenhayamai itan wetsaboribi jaskati jati jato onanmayamai, jabora Diossen ikinaton jatinko jawemabi ikanti iki. Ikaxbi ja esekan yoiai keskati jaxon, wetsaboribi jaskati jati jato onanmaibora, Diossen ikinaton jatinko kikin jonibo ikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Jakopíra en mato yoiai, ja *fariseobo betan esé onan jonibo ikai bebonbires itibi keskati jakoni jayamaira, jawekeskataxbi ja Diossen ikinaton jatinko mato ikantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Matonra onanke, ja moatian Moiséssen yoini joi, ja iki: ‘Joni reteyamakanwe. Ja retemisaibora joi benxoai joni koshiboiba bokanti jake, jato masá tenemakanon ixon’, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ikaxbi enbiribira mato yoiai: Jaweratoboki wetsaboki sinatai, jabora koshibaon, masá tenemati jake. Jatian ja wetsabo ichataibora, koshibo tsinkita bebon bokanti jake. Jatian ramibires shinantaanan jatoki jakonmaibires yoyo ikaibora, chiikan ewa meran potati iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jaskara kopí, jainxon Dios yoina menoxontiainko, Dios meniti jawéki boxonbi atiki, ja miki sinatai joni min shinanrikin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Jatianra ja Dios meniti jawéki min boá, jainxon Dios yoina menoxontiainkobipari abaini, ja joni betan joi benxoax raeananipari mia kati jake. Jatian moa jaskáa pekáoparikayara, min ati jake Dios jawéki menikin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Miki jakonmaakin mia joni koshiboiba kenamakanketian, ja mia ja jaskáa joni betanpari ishton joi benxoawe. Ja joi benxoai joni koshiboiba mia bokanamatianbi. Min jaskáyamaabira, policiabo yatanmaxon cárcel meran mia niakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Enra mato pontéshaman yoiai: Jain xepokanara mato pikótima iki, jatí kopíax pikóti yoikanati kopíai kamanpari. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Matonra moa ninkata iki: ‘Wanoya itan benoya ixon, wetsa betan yoranyamakanwe’, iki Moisés yoyo ini. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ikaxbi enbiribira mato yoiai: Jaweratoboki westíora ainbo oinnax jaon keenai, janra wanoya ixonbi, jawen shinan meran moa jabé yoranke ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jaskara iken, ja min mekayaokea beron mia ochamaresaitian, tsekaxon moa ochó potawe. Jakonra itiki jatiobi min yora, masá tenetian potakantitianbi, ja min yora meran iká westíora min mebires manota. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jatian ja min mekayaokea mekenman mia ochanko pakémaresaitian, xatexon ochó potawe. Jakonra itiki jatiobi min yora, masá tenetian potaakatitianbi, ja min yora meran iká westíora min mebires manota. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jainxon Moiséssenribi neskáakin yoinike: ‘Ja jaton awin potaibaonra, moa potaa iki iká kirika wishá jato meniti jake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ikaxbi enbiribira mato yoiai: Jawerato joninki wetsa joni betan ikainmabi jawen awin potai, janra ja ainbo benoya ixonbi wetsa betan yoranti ati onsá meran imai. Jatian ja benen potaa ainbo betan wanoai joniribira, moa benoya ainbo betan yoranairibi ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jainxon maton ninkáribia iki, ja Moiséssen maton rekenbo neskáakin yoini: ‘Maton ati yoiabo senenhanoxmabi Diossen janenkora non senenhai iki iamakanwe’, akin jato aní. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ikaxbi enbiribira mato yoiai: Jawetianbi jawéki anox yoyo iki, Diossen janenkora en akai iki iamakanwe. Nin nai janetaanan, janra onanke en senenhai, ikiribi iamakanwe, jara Diossen ani yakati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jainoax mai janetaananribi jaskáyamakanwe, jara jainribi itinke. Nin Jerusalén janetaananribi jaskáyamakanwe. Jara ani Apo Diossen jema iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jainoaxibi maton mapokibiribi jaskáyamakanwe, matonra jawekeskaaxonbi westíora boobi, wiso iamaxon joxo imati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jawéki anox: ‘Enra akai’, ikires ikanwe; jatian ayamanoxa: ‘Enra ayamai’, ikiresibi mato iti jake. Jatian meskotibores mato yoyo ikaira, moa *Satanássen imaa ikaires mato iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Matonra ninkata iki: ‘Tsonki jato westíora bero toshananai, jaribi westíora bero toshanti; jainoax jato xeta sekenaanketian jaribi xeta sekenaanshokoti’, iki iká esé. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ikaxbi, enbiribira mato yoiai: Jakonmaakana jato kopikin jakonmaayamakanwe, jaweratobaonki mato mekayao tamoki tantash akai, wetsaori jato amaribikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sináaxon mato koton bichinkaskin akana, mato jan perakootiribi jato menikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Teaxon mia westíora kilómetro jawéki papimakana, rabé kilómetro jato boxonwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wetsaxon inonbires mia jawéki yokata, jato meniwe. Jainxon banexonoxon mia jawéki yokákana jatoki yoashiamawe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Matonra moa ninkata iki: ‘Mibé joni noiwe, ixonbi ja min rawíbichores omiswe’, iki iká esé. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ikaxbi enbiribira mato yoiai: Ja maton rawíbo noikanwe, jainxon jan mato jakonmaaiboki orankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jatianra mato itiki ja naikan iká Papa Diossen bakebo. Jan akai jakon itan jakonma joniboki inonbi bari pikómakin. Jainxon aríbai yoiti itan yoitima joniboki inonbi jato oi maanmaxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jatian jan mato noiabores jato noixonki, ¿Jawe jakon maton biti iki? Ja apo kopíakana koríki tsinkiaiboribira jabé raenanaibo betan jaskatai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jainxon ja mato betan joi akaibores maton jato saludanabira, bená jawékima iki, ja Dios ikonhayamai jonibobira jaskakanani jakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Matora iti jake jakonman senenabo, ja maton Papa Dios naikan iká keskaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wetsabaon oinnon ixonres jonibo bebonxon jakon teebo ayamakanwe. Maton jaskáakinres akaitianra, ja maton biti jawékibo, ja naikan iká Papa Diossen, mato menitima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jaskara kopí, ja jawékinin yoronaibo jato akinax, ja ikon keskati ikaibo keskati iamakanwe. Jaboresa ikai, ja esé ninkáti xobo meranoax itan jain jonibo winotainkobo kaax, rabikanon ikax keshaatani. Jaskataibaonra moa jawen kopí bike iki ixonra en mato yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jawetianki ja maxkatabo min jato akinnai, tsoabi jato keshanyamawe, ja min mexkaokea mekemanra onanti yamake, ja min mekayaokea mekenman akaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Joné jato akinwe. Jatian jaskáakin min jato jonéshoko akinkenbira, moa oinna ixon, ja min Papa Diossenbiribi ja min biti jawéki mia meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jawetianki maton oranai, ja ikon keskati ikaibaon akai keskáakin ayamakanwe. Jabo iki jonibaon oinnon ixonres ja esé ninkáti xobo meranxon itan jonibo winotainkoxonbo orantinin keenbo. Jaskataibaonra jaton biti jawéki moa bike, iki ixonra en mato yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ikaxbi jawetianki minbiribi oranai, min xobonko jikixon, xepóti xepotaanan, joneshoko ja min Papa Dios yoyo awe. Jatian joneshoko min jaskáakenbira, moa oinna ixon, ichaxon oinkanonbi, ja min biti jawékibo mia meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Orankin, jawetianbi ja joibicho bane banekin yoiamakanwe; ja Dios ikonhayamai jonibaon akai keskáakin. Jabaonra shinannai iorai yoyo ikaitian jato Diossen ninkáxonti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jabo keská iamakanwe. Maton yokatamatianbira, ja maton Papa Diossen moa onanke mato jan maxkatabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Matonra neskáakin oranti jake: ‘Non Papa naikan iká, jatíxonbi mia ikon Dios onanbakanon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jowé, non apo iki, abákanon jatíxonbi nato main ikábaon min keena keskáres akin, ja naikan ikábaon akai keskáakinribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Rama ja jawékiati noa netetiibi maxkataibo noa meniwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Non ocha akábo noa shinanxonyamawe, ja noki ochaabo moa non jato shinanxonyamai keskáribiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Shinan meran akásti jawékiain pakémayamakinkaya, *Satanássen jakonmaanaketian noa koiranwe’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wetsabaon jakonmaaka, moa maton ja jato shinanxonyamaitianra, ja naikan iká maton Papa Diossenribi mato ja shinanxontima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ikaxbi wetsabaon jakonmaaka, maton ja shinankin jeneyamaitianra, maton Papa Diossenribi mato ja shinanxonkin jenetima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jawetianki maton *ayunanai, ja beparametaibo keskati onísshokobo iamakanwe. Jabo ikai onisshokobo iki, ayunanai jonibaon oinkanon ikaxes. Jaskataibaonra moa bike ja jaton biti jawékibo, iki ixonra en mato yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jawetianki minbiribi ayunanai, jakonireskaya boexeewe, itan min bemananribi chokawe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Min ayunanai jonibaon onantima kopí. Diossenbichoresa onanna iti jake. Jatian min joné akenbi moa oinna ixonra, ja min biti jawékibo mia meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nato mainxon icha jawéki kaiakasi iamakanwe. Ja jawékibora arai keyotai, jatíribibora jawen ibon pia payotai, jainxonra yometsobaon mato yometsoati atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Naikanra jaskarama iki, jainkaya icha jawéki kaiakanwe, jainra jawékibo arayamai, jawen ibon pia payótibo yamake, itan yometsoboribi yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jaweranoki min icha jawéki kaimaa itina, jainresa min shinan itiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ja bero riki non yora jan tenaa joé keska; jaskara ikenra, ja min bero jakonshaman iketian, jatiobi min yoraribi joé meran keská ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ikaxbi ja min bero jakonma iketianra, jatiobi min yoraribi yamé keska meran ikai. Jatian ja joé keska mii meran iká nokaketianra, kikinbires yamé itiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tsoa yonokaatai jonibira, jatianbicho rabé jonin tee axoni teeti atipanyamake. Westíorares noixonra, jawen joi senenhaxonti iki. Jatian wetsara, omiskin joi senenhaxontima iki. Jaskáribiira, Diossen tee aríbaibi, nekeabi jawékiakinres shinanni mato iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jaskara ikenra en mato yoiai: Maton ja jawékiati kopí, itan ja maton saweti chopa kopibo, masá shinanyamakanwe. Noa jaara piti kopíbichoma iki, non yorara jakon chopa sawematibichoma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oinkanwe ja noyai isábo; jabaonra jawebi banati atipanyamake; bimibo tsekaxon jain atinko benxoatiboribi atipanyamakanke. Jaskarabo ikenbira, ja naikan iká maton Papa Diossen, jato jawékiatinin maxkámayamai. Matokayara abiresti iki, ja isábo akai bebonbires jaskáakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jaskáakin masá shinankinbira, tsonbi jaton jati shokorestanibi bebonhati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jatian jawekopíki, ja saweti chopa kopi maton ayorakin masá shinannai? Oinkanwe, ja nii meran xoxoai joabo. Jabora teeti atipanyamake, itan jatonbi chopaatiboribi atipanyamakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ikaxbi, enra mato yoiai: Ja apo Salomónra jawen jakon chopabaon raokaayonaxbi ja joabo xewina metsá iamaa iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jatian jabokaya basimashoko ikax, moa choshiketian menokanai ikenbi akai Diossen ja waimea joabo kikin metsáshokobo imakin. Matokayara abiresti iki jakon chopabo sawemakin. ¡Jaki koshitira mato maxkáke! ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jaskara iken masá shinanni: ‘¿Jaweki non rama jawékiaipanon?’ iamax ‘¿Jawe chopaki non rama saweaipanon?’ ikibo iamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ja Dios ikonhayamaibaonresa akai ja jawékibo kopí masá shinankin. Ikaxbi ja maton Papa Dios naikan ikátoninra, moa onanke mato jaskara jawékibaon maxkata. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rekenparikaya Diossen ikinaton jatires onankanwe, jainxon atibi keskáakin jan yoiaibo senenhaxonkanwe. Jatianra nato jawékibaon yoroni mato iitaibo mato meniboresti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jaskara kopí bakish iti jawékibaon masá shinanyamakanwe, jara bakish winóti jawékibiribi iki. Netetiibikayara moa atikoma jawékibo jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wetsabo jakonmaakin yoiamakanwe, matoribi jakonmaakin yoikantima kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ja wetsabaon aká yoixontaanan maton jato masá tenemai keskáakinribira mato Diossen ashokoti iki. Jawekeskaakinki maton jato akai, jaskáakinribira mato Diossen ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jawekopíki, wetsabo maxkoshoko bepokootares min jato oinxonai, miakaya aniositon bepokoota itinxonbi? ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jawe keskaxonmein min atiki wetsabo: ‘Mia maxkoshoko bepokoota ea bimawe’, akin jato akin, miakaya aniositon iká ixonbi? ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Mia ja jakon keskatonin shinanmeetai! Minparikaya mia jan bepokoota aniosi tsekawe, jatianparira moa jakonhakin oinxon, min wetsabo jato bixonti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ja ochitibo Diossen jawékibo meniamakanwe, jaskara jakon jawéki onanyamaxonra, mato jakonmaakanti atipanke. Jainxon ja kopí jawékiboribi kochibo meniamakanwe, jabaonra onanyamaxon jamáreskanti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dios yokákanwe, jatianra mato jan meniti iki; benakanwe, jatianra maton nokotiki; kenakanwe, jatianra mato jan akinti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jaweratobaonki yokatai, jabaonra biai; jaweratobaonki benai, jabaonra merai; jainoax jaweratoki kenatai, jabora akinti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Matonmein atiki, pan yokákenbi makanres maton bake menikin? ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Iamaxon, yapa yokákenbi ronores menikin? ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Matokaya jakonma shinanyabo ixonbira, jakon jawékibores maton bake meniti maton onanke. Atixonbira ja maton Papa Dios naikan ikátonin abirestiki, ja yokákanketian jato jakon jawékibo menikin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wetsabaon jaskáatinin mato keenai keskáakinribi, matonribi wetsabo jaskáashokokanwe. Jaskara noa iti riki ja Moiséssen esekan itan *profetabaon yoini joi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ja naxbáma xepótiorikaya jikikanwe, ja manótiori kaa bai xepótira, kikin naxbá ikax katibires iki; ja baiorira icha joni bokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ikaxbi ja jatíbitian jati neteori kati baira naxbáma iki, jawen xepótira maxkoshoko iki, jao jikitira itikoma iki, jakopíra ichama joni ja baiori bokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ja *profeta keskati ikaibaon parannaketian koirameekanwe. Jabora oveja keskatax matoiba bekanti jake pimis yoina keskábo ikaxbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jabora jaton ikábo oinxonres maton onanti atipanke, tsonbira uva bimi betan higo bimi, moxa jiwimea tsekayosma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jatíbi jakon jiwibora, jawen bimibo jakonribi ikai, jatian jakonma jiwibora jawen bimi jakonmaribi ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Westíora jakon jiwira, jawen bimi jakonma iti atipanyamake. Jatian westíora jakonma jiwira, jawen bimi jakon iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jaskati jakoni bimiamai jiwibora, moa xatexon menotires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaskara ikenra, jaton ikábo oinxonres ja jonibo maton onanti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jatikaxbishamanra ea ‘Ibó, Ibó’, akin akaibo Diossen ikinaton jati netenko jikiamanoxiki. Jikiranoxikanai ja nokon Papa Dios naikan ikátonin yoiabo akonkin senenhaibores. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jatian moa jaton aká jawékibo Diossen yoixonti nete nokóketianra, icha jonibo inoxikanai ea akí neskati: ‘Ibó, Ibó min janenkora non jato joi yoia iki, min jane yoitaananra non jato meranoa yoshinbo pikoa iki, jainxonra icha ratéti jawékiboribi non aká jake, ikibo inoxikanai’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jaskákanainbira enbiribi jato anóxiki: ‘¡Jawetianbira en mato onanyamaa iki, moa eibakeax botankanwe jakonma akai jonibo!’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jaskara iken, ja nokon joi ninkáxon en yoia keská ea axonaibo riki, shinanti onan ixon shanka main jonin xoboani keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oi kexto beax ani jenetiata iki, jainoax niwe koshiribi ja xoboki tsakata iki; ikaxbi ja xobo poxóyamaa iki shanka maiki jawen witábo nichina ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ikaxbi ja nokon joi ninkáxonbi, en yoia keská ayamaibo riki, shinanti onanma jonin mashi main xoboani keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oi kexto beax ani jenetiata iki, jainoax niwe koshiribi ja xoboki tsakata iki, ikaxbi tewanyamai poxota iki. Jaskatax ja xobo kikini ras ika iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jaskarabo jato yoikin Jesussen senenhaketian, jain tsinkita jonibo kikini ratékana iki jato esea ninkatax, ");
INSERT INTO shpNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ja esé onanbaon akai keskáayamakin, koshi shinanyaxon jato yoiketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jatian moa Jesús mananmanmeax ipakeax kaaitian, icha jonin chibana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jaskákenbi *lepra isinya westíora joni joáx, ja bebon chirankootoshixon yoia iki: —Ibó, mia keenxon nokon isin ea benxoawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jaskáa ja jonin yora tii axon Jesussen yoia iki: —Eara keenai, en mia abanon benxoakin —akin. Jaskáatianbi, ja *lepra isin moa joni benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jainxon Jesussen yoia iki: —Tsoabi keshanyamawe, pontékainxonres ja sacerdote oinmatanwe. Jainxon ja Moiséssen yoini keskáakin Dios jawéki menitanwe, moa min isin mia benxoa onankanti kopí —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jatian moa Jesús Capernaúmhain nokóketian, westíora romano sontárobaon koshi joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Joxon yoia iki: —Ibó, nokon yonotira isini xobon itinke, koshitibobira atipanyamake, kikini chexakaakin masá tenei riki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jaskáa Jesussen yoia iki: —Ea kabánon ja isinai benxoai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jatian ja sontárobaon koshin neskaa iki: —Ibó, nokon xobon mia jikimati senenmabobiriki ea; nenonxonbikayares benxoti yoiwe, jatianra nokon yonoti moa benxoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eara ja nokon koshibaon yoia joi jato senenhaxonairibi ixon onanke, jatian earibi iki ja sontárobaon koshi. Jawetianki ja westíora sontáro en jain katanwe akin akai, jatianra akai. Jatian wetsabiribi en neri jowé akin aká, joái; jainxon jawetianki ja nokon yonoti, nato ea axonwe akin en akai, jatianra ea jan axonai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jaskáaketian ninkatax Jesús kikini rateta iki. Jainxon ja chibani beaibo yoia iki: —Ikonshamanra en mato yoiai, neskati eki koshia jonira, tsoabi en *Israel main nokoyosma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jaskara ikenra en mato yoiai: Icha jonira bari pikotaiorikeax itan bari jikiaiorikeax benóxikanai. Jabora inoxiki Diossen jawékiati aká jawékiaki, Abraham betan, Isaac, jainoax Jacob betan ja Diossen ikinaton jati netenko tsinkiti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ikaxbi, ja Diossen ikinaton jati netenko iti ikábokayara jain ititianbi, jatobiribi masábires tenetiainko potanoxiki. Jainra masábires tenei xeta kerox aki wininoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jato jaskáatanan ja sontárobaon koshi Jesussen yoia iki: —Moa min xobon katanwe. Ibanon ja min ikonhaxon shinanna keská ikí —akin. Jaskáakin yoiatianbi moa jawen yonoti benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jainoax Jesús Pedron xobon kaa iki. Jain kaxon, ja Pedron rayós ainbo yoná akí bachin rakata nokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jaskara nokoxon, jawen mekenki Jesussen tii akatianbi, yoná jenea iki. Jainoax wenixonra ja ainbaon Jesús jawékiamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jatian moa yametaitian, icha joni yoshinman iboabo Jesússiba bokana iki; jaskáakin bexonkanara, westíora joinbichores yoshinbo jato meranoa pikopakea iki. Jainxonribi ja isinai bokanabo jatíbi jato benxoapakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neskarabora winota iki, jaskara iti yoii, *profeta Isaías: “Janbira non isinbo noa bichina iki, jainxon non chexáboribi noa keyoxonike iki yoyo ini senenti kopí”, ini. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jatian ichaxon moa katekana ointaanan, jaonmea onannaibo Jesussen yoia iki: —Ian keiba bonon bokanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jainoa westíora esé onan jonin nokobainxon neskáa iki: —Jawerano inonbi mia kaaitianra, mia chibani ea kaai Maestró —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jaskáa, Jesussen yoia iki: —Nii ochitibora, jain jati kiniabo iki. Jainoax noyai yoinabora, jain jati naayabo iki. Ikaxbi ja jonin Bakera, jain tantitiomabobi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jatian wetsa, jaonmea onanaitonin yoia iki: —Nokon papa mawáketian en miintira jake Ibó, ea japari amawe, japekaoparira en mia chibantiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jaskáa, Jesussen yoia iki: —Eakaya chibanreswe, abanon ja mawábaon, ja mawataibo miinkin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jaskáataanan, Jesús ian shitai kaai boten naneta iki. Jatian jaonmea onanaiboribi jabé bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ja bokanaitian, niweaba koshi jatoki pakéxon, ja bote bechonman jene nachita iki. Ikaxbi Jesúsbiribi iká iki oxaa. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jaskataitian oinxon, jaonmea onanaibaon oxá ratexon Jesús yoikana iki: —Ibó, moara noa reokootai, noa kishpinmawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jaskáakana jato yoia iki: —¿Jawekopíki mato iorai raketai? ¡Dioski koshitira mato maxkábireske! —akin. Jaskátaanan wenixon, niwe betan bechon notsina iki moa jenénon ixon. Jaskáakin aká, moa neseax jatíbi jakonshamares baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jaskáaketian, jawen jonibo ikana iki kikini ratetax: —¿Jatianki tsoa iti iki nato joni, niwe betan bechonbaonbi jawen joi ninkáxonai ikax? —iki yokakanani. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jatian ian shitabaini kaax, moa Gadara main Jesús nokóketianra, pantioainoax rabé joni yoshinman iboaka, já bechii jobekona iki. Ja rabéra iká iki kikinbires siná, jaskara iketianra, tsoabi ja bain winóti atipanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Joaxa neskati saí ibekona iki: —Jesús, miara Diossen Bake iki ¿Minki noa jaweakai? ¿Nete senenamabi noa masá tenemaiki mia neno joá? —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jato ochómaribi iká iki, icha kochi pii tsamata. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jatian ja yoshinbaon Jesús yoia iki: —Jokonhaxon, ja kochi tsamatabo meran, noa weimawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jatian, jato Jesussen aká iki: —Itankanwe —akin. Jaskáa, ja rabé joni meranoax jokonax boax, kochibo meran ja yoshinbo weikana iki. Jatianbi jatíbi kochibo ishto boxon jene tsakax, jenen retea keyókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jaskáketian ja kochi koiranaibo jabati bokana iki. Boax jemanko nokóxon, jaskatax kochibo keyota jato yoikana iki, jainxon ja yoshin naikia ipachoaibo jaskatax benxoaboribi jato yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jaskara ninkataxa, jatíbi ja jeman iká jonibo Jesússiba bekana iki. Bexon yoikana iki, moa jaton mainmeax wetsanko kati. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jaskáakanara, boten nanexon ian shitabeirani joáx, jawen jemanbiribi Jesús nokota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jain iketianra, chanto joni rakátinin axon, bexonkana iki. Jatianra, já ikonhai jaki koshikana oinxon, Jesussen ja isinai joni neskáakin yoia iki: —Koshiakin shinanwe joní, min ochabora en moa mia shinanxonyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jaskáaketian, jatíribi esé onan jonibaon shinanna iki: “Nato jonira kikin jakonmaibires Dioski yoyo ike”, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ikaxbi jaskarabo shinankanai onanxonra, Jesussen jato yokata iki: —¿Jawekopikayaki maton jakonmaakin shinannai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jaweraki yoitikayaki atibires itiki? ‘¿Min ochabora en mia shinanxonyamai’, akin ati, iamax ‘wenitax katanwe’, akin ati? ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ramara en mato oinmai, ja jonin Bakera, nato mainxon ja ocha akanabo moa jato shinanxonyamanoxon yoiti koshia iki ixon —akin jato aká iki. Jainxon ja chanto joni yoia iki: —Weníxon, min rakáti bibaini min xobon katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jaskáa wenitax, ja joni jawen xobon kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jaskara oinnax, jonibo rakékana iki, jainxon Dios rabikana iki, jaskara atipana koshiaribi jonibo imaa iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jatian moa jainoax kakin, Jesussen oinna iki westíora joni Mateo janeya, jainxon Romamea apo kopí yokákinxonkanai xobonko jato kopí yokati yakata. Jainoa Jesussen aká iki: —Ea chibanwe —akin. Jaskáatianbi wenítaanan Mateo jabé kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jatian jaskáawana pekáo, Mateon xobonkoxon jaonmea onanaiboyaxon jawékiai Jesús iketianra, icha ja apo jato kopí yokáxonaiboyabi jakonma ninkakaatai jonibo, beax jato ikainkoribi jato betan jawékiai yakákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jaskara oinxon, jaonmea onannaibo *fariseobaon yokata iki: —¿Jaweatiki maton maestron, ja apo kopí yokáxonaibo, itan ja ochayabo betan jawékiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jato jaskáa ninkaxon Jesussen ja fariseobo yoia iki: —Ja isinaimabora raonmis joni benatinin maxkáyamake. Isinaibokaya riki ja raonmis jonin akintinin maxkatabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jaskara ixon ramapari onantankanwe, ‘Ja yoinabobicho maton ea retexontinra moa ea keenyamai. Ea keenai riki, noibamisbokaya mato ikantinin’, iki Dios yoyo ika joi. Eara ja jakonman shinanmeetaibo benai joáma iki. Eara joá iki ja ochayabo shinan —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jatian jan jato *bautizanai Juanmamea onannaibo bexon, Jesús yokákana iki: —Nonra akai ichaakin *ayunankin, jatian fariseobaonribira akai jaskáakin. ¿Jawekopíki ja mionmea onanaibaon jaskáayamakanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jatian jato Jesussen neskaa iki: —¿Imeyakanti atipanke ja wanoti fiestanko kenamaa beabo, ja wanoai joni jato betanpari ikenbi onísshokobo ikí? Ikaxbi nokóranoxiki ja wanoai joni yamati nete. Jatianparira jabaon anóxikanai ayunankin —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tsonbira chopa ritás benakan, chopa payo onayamai, bená ikax niníkin ja chopa payo noshiai iken, jaskataxa ja noshí bebonbires ani iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jainxon tsonbira bená vino, ja bichi chomo payon nachíamaribiai. Nachitabira moa vino paeketian, ja chomo toá iti iki. Jaskataxa moa vino yoyokootiki, jatian chomobiribi jakonma banétiki. Jaskánaketianra, ja bená vino chomo benakanribi nachíti iki. Jaskáaparira, ja vino betanbi ja bichi chomo jawe itima iki”, akin jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jatian jaskáakin jato yoii Jesús iitainbi, judíobaon joni koshi Jesús bebon chirankootoshixon yoia iki: —Nokon bake ainbora ramabi mawáke. Ikaxbi nokon xobon kaxon min mekenman ea tii axonara jakiribi jiriti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jaskáakin aká ja joni betan Jesús kaaitian, jaonmea onanaiboribi jabé bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jatian moa bokanaitian, westíora ainbo moa chonka rabé baritia jimi boanaitonin, Jesúski ochómakainxon, pekáorixon jawen jan perakooti kebí tii aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ja ainbaon shinannara iká iki: “Ja Jesussen perakootitanibires tii akaxa ea benxoti iki”, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jaskáara, bechiakekainxon ja ainbo ointaanan Jesussen yoia iki: —Koshi shinanwe ainbó, eki koshiaxa mia benxoke —akin. Jaskáatianbi, ja ainbo benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jatian moa joni koshin xobon nokóxon Jesussen oinna iká iki, jayá maiai bonox, ja quena xoon akaibo jain tsamákana, itan icha joniboribi winii saa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jainoa jato Jesussen yoia iki: —Nenoax jokonkanwe, nato bake xontakora mawatama iki, oxaaresiki —akin. Jato jaskáabi jaki shirokin jonibaon osanreskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ikaxbi moa jato jokonhataanan, jikixon ja xontako Jesussen metsonhinabaina wenita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jaskara Jesussen akára, ja main iká jemabotiibi ninkakaata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jaskáabaini moa Jesús jainoax kaaitian, rabé benche ja chibani joí saí iikiranbekona iki: —Noibataanan noa akinwe Davidkan baké —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jatian jaskákanabi kaax xobo meran jikiketian, ja benche rabekan jainoa nokobekona iki. Jainoa jato Jesussen yokata iki: —¿Matonki ikonhai, en mato benxoati atipana? —akin. Jato jaskáa: —Nonra ikonhai Ibó —akin abékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jaskáakana, jaton beronko Jesussen jato tii aka iki. Jainxon jato yoia iki: —Maton ikonhaa keskára en mato imai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jato jaskáatianbi, moa oinbekona iki. Jainxon jato Jesussen yoia iki: —Tsoabi keshanyamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jato jaskáabi, moa pikóbaini boxonbires, jatíbi ja main ikábo jato keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jatian ja benche iwana rabé moa pikókainbekonaitianribi, westíora yoyo iosma joni yoshin naikia, Jesússiba bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jatian ja joni meranoa moa Jesussen yoshin pikoketianra, jatianbi ja joni yoyo iki peokoota iki. Jaskara oinnax ratetax ikana iki: —Jawetianbira, nato *Israel main jaskara jawéki akanaibo non oinyosma iki —ikibo yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ikaxbi *fariseobaonbiribi yoikana iki: —Ja yoshinbaon koshin, atipana koshi menia ixonra akai, jan yoshinbo jokonhakin —iki ixonres. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jatíbi ani jeman itan maxkoshoko jemabaonra, Jesús iaketana iki, ja esé ninkati xobo ikainxonbo jato axeaki. Jato yoia iki ja Diossen ikinaton jati bená joibo. Jainxonribi, meskó isinyabo itan meskoti chexakaataibo jato benxoaboa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jatian icha joni já chibani bekanai oinxonra, Jesussen jato noibaa iki. Jan jato ikíntioma oveja keskábo ikax, moa kikini shinan tsokáskanabo ikanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jainxon jaonmea onannaibo jato yoia iki: —Icha riki ja non tsekati bimibo, ikaxbi ja tsekai teetaibora ichamashoko iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jaskara iken, ja wai Ibo yokákanwe, abanon wetsaboribi jawen wainko tsekai teeti jato raankin —akin jato Jesussen aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jawen chonka rabé jaonmea onannaibo tsinkixonra, yoiti koshi shinan jato Jesussen menipakea iki, jan jonibo meranoa yoshinbo pikokanon ixon, itan meskó isinboyabi ja chexakaataiboribi benxoakanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Natobo riki ja chonka rabé Jesussen raanabaon jane: Rekenpari iki Simón, jawen wetsa jane iki Pedro. Jainoax jawen wetsa Andrés. Ja pekao iki, Jacobo betan Juan; ja Zebedeon bake rabé. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jainoax iki, Felipe, Bartolomé, Tomás itan Mateo ja romamea apo kopí yokáxonai ipachoai. Japekáo iki, Alfeon bake Santiago betan Tadeo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Jainoaxibi iki Simón; ja Zelotebo betan ipachoai. Japekáo iki Judas Iscariote, ja jakonhai keská iikinbi jan Jesús jakonmaani. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja chonka rabéra Jesussen raana iki, neskáakin jato yoiyonxon: “Ja judíomabo jakana mainkobo boyamatankanwe, nin Samaria main iká jemabaonribi mato katima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ja ovejabo manota keská itai *Israel joniboibakaya botankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Boxon jato yoitankanwe; Diossen ikinaton jati netera moa ochóma iki, akin ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Isinaibo benxoatankanwe, mawábo jiriatankanwe; *lepra isinyaboribi maton jato benxoati iki; jonibo meranoa, yoshinbo jokonhatankanwe. Jaskarabo akinra maton jato kopí yokátima iki, ja nato atipana koshira maton kopí biamaribi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Oro itan koríkibira, maton kakin botima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jan jawékiati boti pisharibi maton botima iki. Nin wetsa chopa itan wetsa zapatoyaribira mato katima iki; jainxon jan kekótiribi boyamakanwe. Ja teetai jonira jawékiamakana iti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jawetianki mato westíora jeman nokotai, jakon joni benax jawen xobonpari mato iti iki, mato wetsanko kaai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ja xobon jikikinra, Diossen mato jakon imabanon akin maton jato ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jatian jakonhaxon ja xobon mato imakanketianra, maton yoia jakon shinan jatoiba baneti iki. Ikaxbi mato biamakanketianra, ja maton jato keenxona jakon shinan matoibabi baneti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jatian jaweranoxonki mato bikashamakanai itan maton joibobi ninkákashamakanai, ja xobomeax itan ja jemameaxa, mato pikóti jake. Kaaira ja maton jamata mai potobo, mato tawasaakainti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ikonshamanra en mato yoiai: Ja jonibora, jaton aká jawékibo jato yoixonti nete nokóketian, Sodoma betan Gomorra jemamea jonibo aní bebonbires jato Diossen castiganoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Oinnax itankanwe, pimis yoinabo napo ovejabo raanti keskáakinra en mato raanai. Matora iti jake rono keskabo, jakonmaakaskana onan, itan xotóbo keskaribi, ramiamisti shinanhomabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Koirameetax itankanwe, matora joni koshiboibabo bokanti jake. Jaton esé ninkati xobo meranxonbora mato rishkinoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ea chibanaibo iketianra, joni koshiboiba, itan apobo bebonribi mato bokanti iki. Mato jaskáakanara, jatoyabiakin ja joi ayamaiboribi nokon joi maton jato yoiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ikaxbi jaskáakin, mato jema koshiboiba bokana, jawemein en jato yoiti iki, iamaax jawerakimein en jato ati iki ikibo mato itima iki. Mato yoyo imakanaitianra, Diossenbi mato jaskati yoyo iti shinanbo mato meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Matobimara iti iki ja yoyo ikai, non Papa Diossen Shinanra iti iki ja mato meranoax yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jaton wetsanbira, jawen wetsabibo jato retemanoxikanai. Jatian papabaonra jaton bakebo jaskáashokonoxiki. Bakebaonra jaton papaki ramítaanan jato retenoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ea chibanaibo iketianra, mato jatíxonbi omiskin ramianoxikanai; Ikaxbi ja mawatai kamanbi eki koshii jenéyamaibora, kishpinmenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jawetianki mato westíora jemankoxon ramianoxon benakanai, jatianra mato wetsa jeman jabati kati iki. Enra mato pontéshaman yoiai: Ja *Israel main iká jatíbi jemabaon mato iaketanamabira ja jonin Bake jonoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jatomea onanai jonira, jaonmeax axea joni xewina iti atipanyamake. Jainoax, ja yonoti joniribira, jan yonoai joni xewina iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jatomea onanai jonira, jaonmeax axea joni keskaresibi iti jake. Jatian ja yonokaatai joniribira, jan yonoai joni keskaresibi iti iki. Ja xobo ibobi Beelzebú akinbo janeyonkana ixonra, jabé ikábokaya abireskanti jake jakonmaakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jaskara ikenbi, joniboki rakéyamakanwe. Jishtima jawékibora iikax onantiti jake; joné jawékibobira, tsonbi onanama iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ja yamé meranxon en mato yoiabo, matonbiribi netenshaman yoikanwe. Jatian jonéshoko en mato yoiabobiribi, jatíbi jato ninkámakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ja yora reteaiboki rakéyamakanwe, jabaonra jawekeskaxonbi kaya reteti atipanyamake. Ja kaya betan yorabi jan masá tenetian potatikikaya rakékanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kopímashoko ikenbi ikanai iki, westíora koríkishoko binox, rabé isáshokotonin maroi. Jaskara ikenbira, ja maton papa Dios keenyamaitian, westíorabi mawáti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jatian matokayara, jaweti booki maton maponko jaa iki ixon moa Diossen toponxonabo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jaskara iken rakéyamakanwe. Maton kopíra, icha isábaon kopí xewina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jaweratoboki jonibo bebomeax Criston joni riki ea iki ikai, jatianra earibi ja naikanmea nokon Papa bebomeax; ikon riki jabo nokon jonibo iki ishokonoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ikaxbi jaweratoboki jonibo bebomeax, eara Criston jonima iki ikai, jatianra earibi ja naikanmea nokon Papa bebomeax, ikon riki jabo nokon jonimabo iki ishokonoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Shinanyamakanwe nato main jaabo jato jakon jamai ea joá. Eara jaskai joáma iki. Eara joá iki espada bei. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ea joá riki, jonibo jaton papakibi sinákanon ikax, ainbobo jaton titakibi sinákanon ikax, baban ewabo jaton benen titakibi sinákanon ikaxbo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jaskara ikaxa, ja maton rawibo inoxiki, ja maton kikin rarebobi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ja ea noia bebonbires, jaton papa betan jaton tita noiabora, nokon joni iti atipanyamake; ea noia bebonbires, jaton bakebo noiaboribira nokon joni iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jatian, ja masábo tenekashamakin ea chibankin jeneaibora, nokon joni iti atipanyamaribake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Japarikaskin ea jeneaibora, jatíbitian manókanti iki. Ikaxbi ea kopi jaton yora menikaataibora, kishpinmeenoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jaweratobaonki, jakonhaxon jaton xobon mato biai, jabaonra moa earibi bike. Jatian jaweratobaonki ea biai, jabaonra jan ea raana Diosribi moa bike. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ja profeta onanxon jawen xobon jato biabaonra, ja *profeta Diossen meniai jawékiboribi binoxiki. Jatian ja Diossen keena keská akai joni onanxon, jawen xobon jato biaibaonra, Diossenbi menia, ja jakon jonin biai jawékiboribi binoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jainxon jaweratobaonki, kikinmashoko ikenbi nokon joni onanxon, jato onpaxtanishokobires xeamai, jabaonribira, Diossenbi menia jaton biti jawéki binoxiki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jatian jaskarabo jawen chonka rabé jaonmea onannaibo moa onanmakin senenhataanan, wetsa jemabaon Jesús kaa iki, Diossen joi yoixon jato onanmaboi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jatian cárcel meranxonbi Juanman ninkata iki, *Criston jaskara akaibo. Jaskara ninkáxon, jawen jonibo raana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","¿Miarin ja joti yoikatikanai? Iamaxon, ¿Wetsaki non manatiki? akin yokákanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jatian Jesussen jato yoia iki: “Boxon ja maton jaskara oinnabo itan maton ninkatabo, Juan keshantankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yoitankanwe, benchebaonra moa oinnai, ja nitikomabora moa jakoni niai, ja *lepra isinyabora moa benxoai, pabebaonra moa ninkatai, mawatabora jiriai, jainoax, ja onitsapishokobora kishpinti jakon joi en jato yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jatian neskarabo en akai oinnax rabé shinanya iamaibora, kikini rarokanti iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jatian moa bokana pekáo, ja Juan yoikin jonibo Jesussen neskáa iki: “¿Jawe oinnikayaki mato jain joni jayamainko kaa iki? ¿Westíora tawa niwen shakonai oinni? ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jatian jaskati kaama ikaxki ¿Jawe oinnikaya mato kaa iki? ¿Westíora joni kikin jakon chopa sawéya oinni? Matonra onanke, jaskara chopa sawéyabora, apobaon xobo meran ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jatian jaskara ikenki, ¿Jaweaki mato kaa iki? ¿Westíora profeta oinni? Ikon riki, jara westíora *profeta xewina kikin joni iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ja Juan yoiira ikai, wishá meran néskati: ‘Mia kamatianbira, nokon joi boai jonipari en raanai, mia jan joti bai benxoaxonon ixon’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Enra mato ikonshaman yoiai, jatíbi joni pikotabora, tsoabi ja jato *bautizanai Juan xewina kikin yamake. Ikaxbi ja Diossen ikinaton ikábo xaran kikinmashoko keská itinakayara, Juan xewina kikin iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ja jato bautizanai Juanman joi yoikin peonontianbira, rama kamanbi ja Diossen ikinaton jakanabo kikin jakonmaakinbiresbo akana masá tenei ikanai, jaskáaxon keyoti shinanxon jakonma jonibaon aká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ja Juan yamatianbira, jatíbi *profetabaon itan ja esé kirika meran wishakaata joibaon yoia iki, Diossen ikinaton jati nete nokóti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ikonhati jisáma ikenbira en mato yoiai: Juanbi riki ja *profeta Elías joti yoikatikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tsoabaonki jakonhakin ninkatai, akanwe ninkákin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jawekimein en ramatian jonibo yointi iki? Bakebo keskára ikanai. Jabo ikai jabé raenanaibo akí jeman tsamatax, neskatibo saí iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Non quena axonabira, mato ransayamaa iki. Onís bewabaon noa bewakenbira, mato winiamaa iki’, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jato bautizanai Juanra iká iki joáx, piamai itan xeayamai. Jatian já yoikana iki, westíora yoshinra jameran jake ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Japekao joá iki ja jonin Bake, jatíbi piai itan xeai, jatian já akanai naxki itan pae xeaitonin yoinkin. Jainxon aríbakanai, ja kopí yokámisaibo itan ochayabo betanres raenanai akinbo. Ikaxbi, ja non aká jawékibo oinxonresa onankanti jake, Diossen onan shinanman non aká”. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jatian jainxon icha ratétibo aká oinxonbi, jaton jakonma shinanbo jeneyamakanaitianra, ja jemamea jonibo jato Jesussen neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Jawe iresaipanon, ja Corazín betan Betsaida jeman jaa jonibo! Ja matoibaxon en ratéti jawéki akábo, Tiro betan Sidón jemanxon en aká iketianra, moabires jainoa jonibaon jaton jakonma shinanbo akonkin jenea ikeanke. Masá shinankin saweti xaxa chopabo saweaxbora, chiimapo rapokookanabo ikeanke, jaton jakonma shinanbo jenea onanti iti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jakopíra en mato yoiai: Jaton akábo yoixontaanan jato Diossen masá tenemati nete senenketianra, ja Tiro betan Sidón jemameabo amai bebonbires mato Diossen masá tenemanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jainoax ja Capernaúm jeman jaa jonibo ¿Maton shinannaki matoribi naikan keyánoxiki? Enra mato yoiai: Matora jainxon masá tenetiainko potanoxiki. Ja matoibaxon en ratéti jawéki akábokaya Sodoma jemanxon en aká iketianra, ramakamanbi ja Sodoma jemamea jonibo jaréskeanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jakopíra en mato yoiai: Jaton akábo yoixontaanan jato Diossen masá tenemati nete nokóketianra, ja Sodoma jonibo amai bebonbires mato Diossen masá tenemati jake”. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","“Jatianribira iká iki Jesús neskati yoyo iki: Papá, mia riki nai betan mai Ibo, enra mia rabiai ja onan itan shinanya jonibo nato jawékibo onanmayamataanan, ja onanma jonishokobores min jato onanmaa kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jaskara min shinan iketianra min jaskáaka iki Papá. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nokon Papanra jatíbi jawéki ea iboamaa iki. Tsonbira ea onanyamake, nokon Papan bichoresa ea onanke. Jaskaribiakinra, tsonbi nokon Papa onanyamake. Enbichoresa onanke, jainxon jaweratoboki en jato onanmai, jabaonribira nokon Papa onanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jatíbi ja teeti paxkina keskábo itan iwe jawéki papíya keskábo, eki bekanwe, en mato tantimanon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ja en mato ati yoiai joibo senenhakanwe. Eibakeax axekanwe, eara jakon shinanya itan rabikaati shinanhoma iki; enresa maton kaya tantimati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ja en mato ati yoiai joibora senenhati atibires iki. Jara atikomama iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iitira, tantiti netenbi Jesús jaonmea onanaiboya trigo wainapobi winota iki. Kakinbi moa jawékiakaskin ja jaonmea onanaibaon ja trigobo tsekaxon pikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jaskáakanai oinxonra, *fariseobaon Jesús neskáakin yoikana iki: —Oinwe, ja mionmea onanaibaonra ja tantiti neten atima jawéki akanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jatian Jesussen jato neskáa iki: —¿Matonki ja westíoraakin Davidkan jawen joniboyaxon jawékiakaskin akáni yoii iká yoyo akama iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Janra, Dios rabiti xobo meran jikixon, já chibanaiboyaxonbi, ja Dios rakanxonkana pan piá iki. Ja iká iki nin janbi itan jawen jonibaonbi pitima, *sacerdotebaonres ati ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Matonkayaki ja tantiti netenbi Dios rabiti xobo meran teetibi, *sacerdotebo ochayamakanai, Moiséssen esé meran yoiaibo yoyo akama iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Enra mato yoiai: Nenora itinke westíora ja Dios rabiti xobo betan senenma bebonbires kikin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Matonkayaki onanyamaa iki: ‘Ja eara keenyamai maton yoinabo retexontin. Ea keenai riki noibamisti shinanyabicho mato itin’, iki Dios yoyo ika. Ja onanaxa, jakonma akáma jonibo jakonmaakin yoii mato iiyamakeanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja jonin Bakekaya riki jawerin ja tantiti neten atibo iki ixon mato jan yoiti —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jainoax kaax, jain iká esé ninkáti xobo meran Jesús jikia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ja xobo meran iká iki, westíora joni meken jirioma. Jatian jaskáaxon já jakonmaakin yoiti benaibo ixon, Jesús yokákana iki: —¿Tantiti netenbi isinai benxoatiki jakon iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jatian Jesussen jato neskaa iki: —¿Matonki, ja maton oveja westíorashoko tantiti netenbi kini meran kaketian, biamai iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Westíora jonikaya riki oveja winoa bebonbires non shinanti. Jaskara kopíra, tantiti netenbi non jakon jawéki ati ramima iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jainxon ja joni yoia iki: —Min meken sananwe —akin. Jaskáa ja jonin sananatianbi benxoax, moa wetsaorikea jawen meken keskaribi jakon baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jaskáaketian oinnax, *fariseobobiribi jain tsinkíti xobomeax jokonbaini boax tsinkíkana iki, jaskáaxon Jesús retenoxon shinan akí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jaskara shinankanaibo onanax, moa jainoax Jesús kaa iki. Kaaitian icha joni já chibani bokana iki. Jainxon icha isinaiboribi, jato Jesussen benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jaskáaxon jato yoia iki tsoabi keshantima. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ja *profeta Isaíassen yoini joibo senenti kopíra jato jaskáa iki. Ja iká iki neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Natoriki nokon yonoti, ja riki en katota, jara en noike, jaonra ea ikonbiresi raroai. Jara nokon Shinanya en imanoxiki. Janra itibi keskati jati jatíbiainoa jonibo jato joi yoinoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tsobebira já join ianananyamanoxiki. Jara koshi join iamanoxiki. Tsonbira jawen joi ninkáyamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Moa kapota ikenbira ja tawa sekeyamanoxiki. Koinshokores jokonainbira mecha nokaatima iki, moa jatíbiainoa jonibo itibi keskati jakanai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jatíbi jonibora jaon manánoxikanai”, ikira inike. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jaweti jonixonra, westíora joni benche itan yoyo iosma yoshin naikia Jesússiba bekana iki. Jara Jesussen benxoaa iki. Jaskáara moa jakonhakin oinnax, jakoniribi yoyo ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jaskara oinnaxa, jatíbi jonibo ikonbiresi ratékana iki. Jaskati ikana iki: “¿Natomarin ja Diossen katota *Davidkan Bake?” ikibo yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jaskákanaitian ninkáxon, fariseobaon jato aká iki: “Nato jonira yoshinbaon koshi Beelzebúkan atipana koshi menia iki, jonibo meranoa yoshinbo jokonhanon ixon”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jatian jaskara shinankanai onanxon jato Jesussen yoia iki: “Westíora mainbicho jakana jonibora, jatonbi wetsa tsamabo akáx jatobires reteanani keyókanti iki. Westíora jeman jaa jonibo iamax ja xobonbicho jakana jonibora, jatobires ramianani jaax, jaskatiribi keyokanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaskáribira, ja *Satanássen jabé yoshin notsínxon pikoti atipanyamake. Jaskaxbira jawen ikinabo betan jakon itima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Maton yoiai, enki ja Beezebúkan atipana koshin yoshinbo jokonhai; jatian jaskara ikenki ¿Tson atipana koshi meniaton akanai, ja matomea onanaibaon yoshinbo jokonhakin? Abánon jabaonbi mato yoikin ja maton ea jaskáakin akábo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ikaxbi ja Diossen Shinanman en yoshinbo jokonhai ikaxa, onanti iti iki ja Diossen ikinaton jati nete moa matoiba nokota. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jaskaribiakin ¿Tsonmein atiki, rekenpari ja koshi joni yatanxon nexaamatianbi jawen xobomea jawékibo yometsoakin? Jaskáaxonresparira yometsoakanti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ja ebé rabéyamaibora, eki jakonmaataibo iki. Jatian ea jan wetsabo bikinyamaibora, jan jato onónhakaibores iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jakopíra en mato yoiai: Jatíbi ja ocha akanabo itan jakonmai yoyo ikanabora, Diossen jato shinanxontima iki. Ikaxbi ja Diossen Shinanki jakonmai yoyo ikanabora, Diossen jato ja shinanxonkin jenetima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja jonin Bakeki jakonmai yoyo ikax ochakanaibora, jato Diossen soaxonai. Ikaxbi ja Diossen Shinanki jakonmai yoyo ikax ochakanabora, jawekeskaxonbi jato soaxonti atipanyamake, nin jawetianbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jakon jiwira, jakoniribi bimiai; jatian jakonma jiwi ikaxa, jawen bimiribi jakonma ikai. Jiwira jawen bimibo oinxonres non onanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Matobo riki, jakonmabo ikax, rono kaita keská jonibo! ¿Jawekeskaxonki maton jakon jawékibo yoiti iki jakonmabo ixonbi? Ja maton jointi meran bochoa shinanra, mato yoyo ikaitian kexakan jokonai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ja jakon joninra, jakon jawékiboresibi yoiai; já meran jakon shinan jaketian. Jatian jakonma joninra, jakonma jawékiboresibi yoiai; jawen shinan jakonmaribi iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jatianra en mato yoiai: Moa jaton aká jawékibo yoixonti nete nokóketianra, jatikaxbi jakonmairesbo yoyo ikabo ikax keshanoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ja min joinbira inoxiki, mia jakon baneti iamax mia castigameti”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jatian ja esé onanboyabi *fariseobaon Jesús neskáa iki: —Min ratéti jawéki akaira noa oinkasai maestró —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jaskáakanabi Jesussen jato neskáa iki: —Jakonma jonibo ikax Dios betanbicho iamaibo ixonbira akai, maton ea ja oinxon onantibo yokákin. Ikaxbira en mato axonyamai. Ja oinxon maton onanti riki, ja *profeta Jonás iní keskati ea iketianparires. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ja Jonás ani yapa meran, kimisha nete itan kimisha yamé iní keskatiribira inoxiki, ja jonin Bake, kimisha nete itan kimisha yaméribi mai chicho ikí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ja ramatian jaa jonibo jaton akábo Diossen yoixonti nete nokóketianra, Nínive joniboribi jain inoxiki, Diossen mato masá tenemanon ikax matoki ramii yoyo iki. Ja Nínive jonibaonra Jonassen joi yoiai ikonhataanan, jaton jakonma shinanbo akonkin jenekana iki. Jatian mato xarankaya Jonás iní bebonbires ikenbira maton ikonhayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jainoax ja ramatian jaa jonibo jaton akábo Diossen yoixonti nete nokóketianra, ja nete senenainoa apo ainboribi jain inóxiki, Diossen mato masá tenemanon ikax yoyo iki. Jara kikin ochokeaxbi joá iki, onan iketian Salomónman esé ninkati. Jatian mato xarankaya ja Salomón iní bebonbires ikenbira, maton jawen esé ninkáxonyamai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Westíora yoshinra ikai, moa joni meranoax pikotax, jain joni jayamainko kawanhatani, jain tantiti benai. Ikaxbira nokoti atipanyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jaskáakin nokoyamaxonra shinannai: ‘Ramara ea jainoax pikóyantana xobonko ea karibai’, ixon. Jaskatax joxon oinnara ikai ja joni, xobo jonioma, jakonyoraakin matsóxon, benxoayona keskáshaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaskara ointaananra karibai, kaxonra kanchis yoshin ja bebonbires jakonma shinanyabo jato beai. Jatian jato iwea beaxa, jatikaxbi ja joni meran weíkanai. Jatianra ja joni, moa ikátiai bebon jakonmabires banetai. Jaskararibira ikanti jake winoti ja ramatian yoitima jonibo”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jaskáakin ja joni tsamatabo yoii Jesús iitainbi, jawen tita betan jawen wetsabo bekana iki. Bexon jemanxonbi manakana iki jabé yoyo ikaskin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jatianra wetsan Jesús keshana iki: —Min tita betan min wetsabora, mibé yoyo ikasi beax, jeman charókanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jaskáaketian jan keshana joni neskáa iki: —¿Tsoakayarin nokon tita, itan nokon wetsabo? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jaskátaanan, jaonmea onannaibo metoanan Jesussen yoia iki: —Natobo riki nokon tita, itan nokon wetsabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jaskara iken, jaweratobaonki ja nokon Papa naikan ikátonin yoiaibo senenhai, jaboresiki nokon wetsabo, nokon poibo, itan nokon tita —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ja netenbiribira, xobomeax pikókaini kaax, ian kexa Jesús yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jain iketianra, icha joni jaki bea iki. Jaskara ointaananra, kaax Jesús boten nanetax jain nayakaa iki. Jatian ja jonibobiribi mashinbi ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jainxonra, meskó jawékikibo yoinbainxon jato Jesussen icha jawékibo onanmaa iki. Neskáakin jato yoia iki: “Westíora wain teetaira inike bero banai kaai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ja banakin masá aaboara, jatíribi berobo bai napon maana iki. Jara basiamabi isábo bexon keyokin pia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jatíribi berobora makan xaran maana iki. Jain maana berobora basiamai xoxoa iki, mai kextóma iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ikaxbi moa bari pikókin menoa, jawen taponbo chichó boama ikax, choshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jatíribi berobora maana iki, moxa napo. Jara moa anixon, moxabaon mapoanan animayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ikaxbi jatíribi berobora maana iki, mai jakon ikain. Jabora jakonhirai bimia iki. Westíora nia bimia iki, pacha. Wetsa nia bimia iki, sokota chonka. Jainoax wetsa nia iká iki, kimisha chonka bimiya. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tsoabaonki jakonhakin ninkatai, akanwe en mato yoiaibo ninkákin”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jatian jaonmea onanaibaon pataxbainxon Jesús yokákana iki. Jawekopiki jawetsa jawékiki yoinbainxon jonibo jato eseai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jatian Jesussen jato yoia iki: “Matoresa en onanmaboai ja Diossen ikinaton jati onanyamakana ikátiaibo. Ikaxbi, wetsabora en onanmayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jaweratobaonki moa onanna, jabora en bebonbires onanmati jake, kikinhakin onankana iti kopí. Ikaxbi ja onanyamabora, jaton onanna jawékibo en shinanbenomati jake, onanyamakanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jaskara kopíra akai en wetsa jawékikibo yoinbainkin jato joi yoikin. Oinxonbi onanyamareskanai kopí itan ninkáxonbi onanyamareskanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jaskatira ikai ja *profeta Isaíassen yoini joibo jatoiba seneni. Jara inike neskati: ‘Ninkáxonbira onanyamaresnoxikanai. Oinxonbira, onanyamaresnoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nato jonibaon shinanra jakonmaata iki. Ninkákashamaira papókanai. Oinkashamaira betíkanai. Jaskáaxon onantaanankaya jaton jakonma shinanbo jeneax eki bekanketian en jato kishpinmati ikenbi’, ikira iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ikaxbi matora Diossen raroshaman imake, maton beronbi oinnai, itan maton pabíkininbi ninkatai iken. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ikonshamanra en mato yoiai: Icha *profetabo itan icha jakon jonibora, ja maton oinni iitaibo oinkaskana iki, ikaxbi oinyamakana iki. Ja maton rama ninkati iitaiboribi ninkákaskana iki, ikaxbi ninkáyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Rama ninkákanwe, ja bero banaaki yoinmeeta esé en mato onantiakin yoinon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ja Diossen joi ninkáxonbi onanyamaresaibora, yoshinman joxon ja ninkákana joibo jato shinanbenomai. Jaskarabo riki ja bai napo bero maanna iní keskabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja makan xaran bero maanna iní riki, Diossen joi ninkáxon, keenshamankin ikonhaibo yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ikaxbira, jawen taponbo chichóshaman kaama ikax, basi iamakanai. Jabaonra tanakaatibo joketian, itan Diossen joi kopi jakonmaaxon masá tenemakanabo, teneyamakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja moxa napo bero maana iní riki, moa Diossen joi ninkataxbi, nato netemea jawékibo ayorakin shinanni, jaskatax icha koríkiatires shinannaibo yoii iká. Jatíbi jaskara jawékibaonra ja Diossen joi ninkatabo jato shinanbenomai, jatian moa Diossen tee akin jenekanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ikaxbi ja mai jakon ikain bero maana iní riki, Diossen joi ninkáxon moa kikinhakin onanabo yoii iká. Jaboresa ikai jakoni bimii, ja westíora nia jiwibicho, pacha bimia, sokota chonka bimia, jainoax kimisha chonkabo bimiabo iní keskati”, akin jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jainxon wetsa jawékiki yoinmeeta esé jato Jesussen yoiribia iki: “Diossen ikinaton jati riki, westíora jonin jawen wainko trigo banaa iní keska. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jatíbi jonibo moa oxakana ikenra, jawen rawí joxon ja *cizaña janeya xobi, trigo banaainkoribi banaa iki. Jaskáabaini moa kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jatian ja trigoribi moa aniax botoetaitian, *cizañaribi xoxoa merakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jaskáketian, ja teetaibo wai iboiba bokana iki keshani. Boxon yoikana iki: ‘Ibó, jakon berobobichores min banayantanabiki ¿Jawekeskatax ja *cizañaribi xoxoa?’ akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jaskáakana, ja wai Ibon jato yoia iki: ‘Westíora nokon rawikan aká riki’, akin. Jatian ja teetaibaon yokata iki: ‘¿Ja *cizaña non mexaxontinki mia keenai?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jatian jato yoia iki: ‘Ayamakanwe, ja cizaña mexakinra, maton trigoribi mexanake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ibanon, ja trigo tsekati nete senenai kaman, jabébipari anii. Jatianra ja tsekai teetaibo raankin en yoiti iki, ja cizañapari taxtexon tsamankanti jainoa menonoxon. Japekáopari ja trigo tsekaxon jain benxoati xobonko maton tsamanti iki’ ”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","“Jainxon wetsa jawékiki yoinkin jato Jesussen aríbaa iki neskáakin: Diossen ikinaton jati riki, westíora jonin jawen wainko mostaza bero banaa keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ja bero riki, wetsa berobo winoa kikin beshéshokoira. Ikaxbi, jawetianki moa aniai, jara ikai ja wainkonia wetsa banábo xewina ani ikí. Jatian moa jaskati aniketianra, jatíbi noyai yoinabo bexon, jawen poyanman naakanai”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jainxon wetsa jawékiki yoinkin jato Jesussen aríbaa iki neskáakin: “Ja Diossen ikinaton jati riki, westíora ainbaon, kimisha ani wea harinaya *levadura meskoa, paeax jatiobi soo ikai keská”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jatíbi nato jawékiboki yoinbainkira jato Jesussen esea iki. Jaskáaxonresa jato esekatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jara iká iki ja *profeta yoyo ini joi senenti kopí. Ja inike neskati: “Jawekiki yoinmeeta esébora en jato yoinoxiki. Diossen nete jonianontianbi, tson onanama jawékibora en jato onanmanoxiki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jaskáakin jonibo yoitaanan, moa Jesús xobon kaa iki. Jainoara jaonmea onanaibaon yokákana iki, ja wainko cizaña xoxoaki jawe yoii iká iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jatian Jesussen jato yoia iki: “Ja jakon bero jan banai joni riki, ja jonin Bake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ja wai riki, nato nete yoii iká. Ja jakonshaman berobo riki, Diossen ikinaton jaa jonibo yoii iká. Jatian ja *cizaña riki, *Satanássen jonibo yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jatian ja nokon rawí jan *cizaña banaa riki, yoshinbaon koshi. Ja trigo tsekakanti riki, nato nete senenti yoii iká. Jatian ja trigo tsekai teetaibo riki, ángelbo yoii iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ja *cizaña taxtexon tsamanhanan menoti keskáribira inoxiki, moa nato nete senenketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ja jonin Bakenra, jawen ángelbo raannoxiki, jawen ikinna jonibo xaranmea, jatíbi ja wetsabo ochamaibo itan jakonma akai jonibo, jato tsinkinon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jaskáaxonra, chii tiritai xanken meran jato potanoxikanai. Jainra inoxikanai, masá tenei, xeta kerox aki winii. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jatian, jakon aká jonibobiribira, jawen Papan jato ikinna netemeax, bari keskati penénoxikanai. Tsoabaonki jakonhakin ninkatai akanwe ninkákin ja en mato yoiaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Diossen ikinaton jati riki, westíora mainko kopí jawékibo jonekana keská. Westíora joninra ja kopí jawékibo meraxon, jainbi jakiribi joneribia iki. Jaskáabaini kikin raroshaman kaax, jawen jatíbi jayata jawékibo maroa iki. Jaskákirani joxon jatiobi ja mai marokin bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ja Diossen ikinaton jati riki, jan teetai ikax westíora joni perlanin keeni maronoxon benai kawantanai keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jatian iikin, westíora perla kikin icha kopía merax; jawen jatíbi jawékibo kaax keyo maroa iki. Jaskáaxon, ja perla marokin bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jainoax, Diossen ikinaton jatiribi riki, ani rika jenenko nepóxon, meskó yapabo biti keskaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja ani rika meran moa yapa icha weiketianra, ja yapan teetaibaon, mashiori boxon mapémakanai jainxon katónoxon. Ja jakon yapabo akanai tasakan napókin, jatian ja jakonma yapabobiribi potakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaskararibira inoxiki moa nete senenketian. Ángelbora benoxiki, jakonma jonibo xaranmea, jakon jonibo kátoti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ja jakonma jonibora, chii tiritai xanken meran jato potanoxikanai. Jainra inoxikanai, masá tenei, xeta kerox aki winii”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jaskáatanan jato Jesussen yokata iki: —¿Jatíbi nato jawékiboki maton kikinhakin ninkata? —akin. Jatianra jabaon yoia iki: —Nonra ninkáke Ibó —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jatian jato Jesussen yoiribia iki: —Jawetianki westíora esé onan jonin, Diossen ikinaton jati kikinhakin onanai, jatianra ja joni ikai, westíora jonin jawen xobo meranoa, moatian jawékibo itan bená jawékibo benxoa iikinbi jokonhai keská ikí —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jaskáakin jato jawékiki yoinmeeta esébo yoikin senenhataanan, moa Jesús jainoax kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kaax jawen jemanko nokota iki. Jainxonra ja esé ninkati xobo meranxon jato axeakin peoribia iki. Jato jaskaitianra ikonbiresi jonibo ratékana iki. Jaskati ikana iki: —¿Jaweranoa jaskara onan shinanbo naton biarin? ¿Jawekeskaxonki ratéti jawékiboribi akai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Natora carpinteron bakeres iki. Jawen tita iki María. Jawen wetsabo iki, Jacobo, José, Simón jainoax Judas. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jawen poiboribi iki neno nooxaran jakanabo, ¿Jatian jawekeskarainoax jaskaraton axea itiki? —ikibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaskatax, já ikonhakashamaibo ikana iki. Ikaxbi Jesussen jato yoia iki: —Westíora *profetara jatíbiainxon jakonhakanai. Ikaxbi, jawen jemanxonbi, itan jawen rarebobaonra ayamai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jatian tsonbi já ikonhayamakanaitian, ichashaman ratéti jawékibo jainxon ayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jatian Galilea mainmea apo inontianra, Herodesnin ninkata iki ja Jesús yoii ikanaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jaskarabo ninkáxon, jawen jonibo yoia iki: “Ja jonira jato *bautizanai Juan iki; moa jiriribia, jakopíra, ratéti jawékibo atipana koshia iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodesninra iká iki, jato bautizanai Juan jato yatamaxon, cárcel meran jato niamaa, jawen wetsa felipen awin Herodías kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juanmanra akátiai Herodes yoikin: “Ja min wetsan awinra, jawekeskaxonbi min awinhati atipanyamake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jaskáara, Juan retekasibi Herodes joniboki raketa iki, jatíxonbi ja Juan *profeta shinankanai iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jaskara iitainbira, Herodesnin jawen pikóni baritia senenhaxon fiestaaka iki. Jatianra ja chania beabo bebomeax, Herodíassen xontako ransaa iki. Jaskati ransaara iká iki Herodesnin keenshaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jaskákinra jawen joi akonkin senenhanoxon ja xontako yoia iki, jawe inonbires yokáketian meniti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jatian jawen titan eseara, ja xontakonin aká iki Herodes neskáakin: —Jato bautizanai Juanman mapo, raton axon ea meniwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jaskáara apo Herodesnin akonbireskin masá shinanna iki. Ikaxbi ja chania beábaon ninkánonbiora yoia ixon, ja xontakonin yokata jawéki meniti jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jatian jato jaskáakin yoia boxon, jawen yonotibaon cárcel meranoabi Juan textekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jaskáaxon ja mapo raton naneanan boxon ja xontako menikana iki. Jatian janbiribi jawen tita tekikin menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jaskáakana pekáo, ja Juanmamea onannaibo bekana iki. Bexon, moa jawen yora bokana iki, boxon miinkana iki. Jaskáabaini boxon Jesús keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jatian Juan jaskáakana ninkatax, Jesús jabicho boten nanékaini, tsoabi yamanko kaa iki. Ikaxbi moa Jesús kaai onanax, ja jeman iká jonibo ja chibani mainbi bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jatian moa botemeax pakéxon Jesussen oinna iki, kikinshaman joni icha jain tsamákana. Jaskákana oinxonra, jato noibaa iki. Jaskáaxon, ja isinai bokanabo jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jatian moa yantainraitian, jaonmea onanaibaon nokobainxon yoikana iki: —Moara yantányora iki, ja jonibo moa jato raanwe, nenora jawebi yamake. Abátankanon jemanko boxon, jawékiati maroxon jawékiakin —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jaskáakana Jesussen jato yoia iki: —Jabora bokanti yamake, matonbikaya jato jawékiamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jatian jaonmea onanaibaon neskáaka iki: —Noara neno pichika pan betan rabé yapayashokores iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jatian Jesussen jato yoia iki: —Ea neri bexonkanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jaskáaxon ja joni icha pastonbi yakákanti jato yoia. Jato jaskáataanan, ja pichika pan betan rabé yapa bixon, bochiki ointaanan Dios iráke aka iki. Jaskáa pekáo, pan pakexpakeanan, jaonmea onannaibo menipakea iki; jatian jabaonbiribi, tekikin jonibo menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jara jatíxonbi pikana iki, kikini potónon kaman. Jatian ja pakex texeabo tsinkíkanara baneta iki, chonka rabé tasá bocho. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jatian jan piábo ikana iki, pichika waranka jonibobira. Tsonbi ainboboyabi bakebo toponama ikaxbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jaskáa pekáo, jaonmea onannaibo Jesussen yoia iki, jatopari boten nanébaini moa ian keiba bokanti, janpari ja joni icha raanai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jaskáakin moa joni icha raana pekáo, Jesúsbiribi jabicho ani mananman kaa iki jainxon orani. Jatian moa yamékenbi jabicho jain iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jaskatai kamanbiribi ja bote moa kikin napon kaa iká iki. Jatianra bokanaikirikeax bei, niwe koshi jatoki tsakata iki, jaskákin ja bote, bechonman oken boanbekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jatian moa nete xabáti ochóma, jene besenen niax, Jesús jatokiriti kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jaskati jene besenen niax joaitian oinnax, jaonmea onannaibo kikini ratetax: —Yoshin riki —iki saa ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jaskákanainbi jato Jesussen yoia iki: —¡Jaskáyamakanwe! Ea riki, rakéyamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jaskataitian Pedron aká iki: —Ibó, ikon miakon ixon, ea jenen niax miiba katiakin ea kamashokowe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jaskáketian Jesussen aká iki: —Jokayata —akin. Jaskáa Pedro, ja botemeax pakétaanan, jenenbi niax Jesúskiriti kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ikaxbira, niwe koshiora iketian oinnax, raketa iki. Jaskatira jatianbi jene meran jikipakekaina iki. Ja moa jikipakekainira iká iki: —Ibó, ea biwé —iki saí iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jaskataitian, Jesussen ponyaman yatantaanan bixon yoia iki: —¿Jawekopíki mia rabé shinanya iká? Miara eki kikini koshiama iki, joní —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jaskatax moa jatoribi boten nanéketian, niweribi moa nesea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jaskáketianra, ja botin ikábaon, já bebon chirankootanan: —Ikon riki mia Diossen Bake —akin Jesús rabikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jaskatax moa ian shitabaini boax, Genesaret jemanko nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jain nokóketianra, jainoa jonibaon Jesús onanxon, jatíbiain jato keshankana iki. Jaskara ninkáxonra, isinaibo Jesússiba bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jatianra yoikana iki, jawen perakooti kebítanibires jato tii amati. Jaskáketian jato amaara, jan tii akabo jatikaxbi benxokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jawetii *fariseoboyabi esé onanbora ikana iki Jerusalénhainoax bekana, jabaonra nokobainxon Jesús yokákana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Jawekopíki ja mionmea onanaibaon non rekenbaon axé senenhayamakanai? ¿Jawekopikayaki jawékiakamatianbi mechokiyamakanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jaskáakana, Jesussen jato neskaa iki: —¿Jatian jawekopíki matonribi, ja maton rekenbaon axéres senenhakin Diossen esé senenhayamai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diossenra yoia iki: ‘Min papa betan min tita joi senenhaxonwe. Jainoax, jaweratoboki, jawen aniboki jakonmai yoyo ikai, jabora retekanti jake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ikaxbi matonbiribi yoiai: Westíora joninronki jawen papa betan jawen tita yoiti jake: ‘Enra mia akinti atipanyamake, jatíbi nokon jawékibo moa Dios menia ixon’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jatian jaskáakin yoia ixonki, ja jonin jawen papa betan jawen tita moa akintima iki, ixon. Jatian jaskáakin ja maton rekenbaon yoini joibores chibankinra, ja senenhati joi Diossen yoiabo moa jawemabiakin maton shinannai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mato riki ikon keskati ikaibo. Itixbira inike ja profeta Isaías mato yoii neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nato jonibaonra, jaton yoyo ikatoninres ea rabiai. Ikaxbi jaton shinanra eaakin shinanti ochóbires ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jonibaon yoia eséres jato axeaibo ixonra, yankabires ea rabikanai’, iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jaskáa pekáo, jonibo kenataanan jato Jesussen yoia iki: —Ninkáshamankanwe, maton onannon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ja non jawékiaitoninra ayamai joni jakonma imakin. Ja kexakameax, jakonma joibo jokonaitoninra, akai joni jakonmabires imakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jaskaketian jaonmea onanaibaon, pataxbainxon Jesús yokákana iki: —¿Minki onanna, min jato jaskáakin yoiketian *fariseobo kikini sinata? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jaskáakana jato Jesussen yoia iki: —Jawerato jiwiki, nokon papa Dios naikan ikátonin banaama iki, jara taponyabi jato mexanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jaskara iken jato oinreskanwe, jabora, jabé benche ikinaibo iki. Jatian benche ixonbi jabé benche iokasi iitira, rabekaxbi xanken meran pakébekonti jake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jaskáketian Pedron aká iki: —Ja min jato yoikin ataipari noa onantiakin yoiwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jatian Jesussen jato neskáaka iki: —¿Matonribikayaki ninkákaskinyamai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Matonki onanyamaa ja non jawékiakabo non poko meran boax, moa ori jokonai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ikaxbi ja kexakameax pikotai joibo riki, jonin shinan meran ikábo. Ja riki jan joni jakonma imai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ja jonin shinan meranoaxkaya ikaibetin neskara jakonma atibo pikoti: Retemisti, wanoya itan benoya ixonbi wetsa betan yoranti, atima betanbires yoranti, yometsoti, jansoti itan jakonmanin yoinmistibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nato jawékibo riki jan joni jakonmabires imaibo. Ikaxbi ja mechokiixonmabi jawékiaitoninra, jato jakonma imayamai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jaskáatanan, moa jainoaxbi Tiro betan Sidón janeya main Jesús kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jatian jain ikenra, westíora cananea ainbo, Jesús akí neskati joo iikirani joá iki: —Ibó, mia riki *Davidkan Bake, noibataanan ea akinwe, nokon bake ainbaonra masábires teneai, yoshin naikia ixon —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ikaxbi, Jesussen jawebi yoiamaa iki. Jatianra, jaonmea onanaibaon nokobainxon yoia iki: —Nato ainbora noa chibani joo iikirani noo pekao joái, moa katanon ixon yoiwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jaskáa, Jesussen jato yoia iki: —Diossenra ea raana iki; *israelitabopari jato akinti, oveja manota keskábo ikanaitian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ikaxbi ja ainbo, já bebon joáx chirankootoshitax: —Ea akinwe Ibó —iki itoshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jaskatoshiketian: —Jakonma riki bakebo piti bichinxon, ochítibo non meninaanti —akin Jesussen aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jatian ja ainbaonbiribi yoia iki: —Ikon riki Ibó jaskara; ikaxbira, jawen ibo metinina piti tsosáshokobo mesameax maana akai iki, ochitinin piribakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jaskáaketian Jesussen yoia iki: —Ainbó, miara eki ikoni koshike, min ea yokata jawékira en mia axonai —akin. Jaskáakin Jesussen yoiatianbi, jawen bake ainbo moa benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jaskáatanan, moa jainoax tekíkaini kaax, Galilea ian kexa Jesús nokota iki. Jain nokotaxa, mapébaini kaax, manan maxkaten yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jain iketianra, jaki joni icha tsinkita iki. Ja nitikomabo, benchebo, yoyo iosmabo, poyánkomabo, itan icha meskoti isinaibo iwei beax. Boxonra Jesús bebon akana iki. Jatianra jan jato benxoapakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jato benxoara, ja yoyo iosmabo moa yoyo ika iki, ja poyánkomabo moa benxoa iki, nitikomabo moa jakoni nia iki, benchebaonribi moa oinna iki. Jaskara oinnaxa, jonibo kikini ratékana iki. Jaskáxonra rabikana iki ja israelitabaon Dios. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jatian Jesussen jaonmea onannaibo kenaxon yoia iki: —Nato jonibora en jato noibai, moa kimisha neteyora neno ebé ikax, ja jawékiatioma ikanaitian. Pimaamabira en jato raankashamai. Jaskarabi en jato raanabira, bain boí paxnakanti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jatian jaonmea onanaibaon yoikana iki: —¿Jaweranoaki non jawékiati bitiki, nato jatí icha joni non jato pimati? Nenora jema yamake —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jatian Jesussen jato yokata iki: —¿Matoki jaweti panya iki? —akin. —Kanchis panra jake. Jainoax jaweti yapashokoribi —akin akana iki jawen jonibaon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jaskáaxon ja joni icha Jesussen yoia iki mainbi yakákanti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jainxonra, ja kanchis pan betan yapabo bitaanan, Dios iráke aka iki. Jaskáaxonra, ja panyabi yapabo pakexpakeanan jaonmea onannaibo jato menipakea iki. Jatian jabaonbiribi tekikin jonibo menikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jara jatíxonbi potónon kaman pikana iki. Ja pakexbo texeketian tsinkikanara baneta iki, kanchis tasápari. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jatian jan piabora ikana iki, chosko waranka jonibobira, ainboyabi bakebo toponkanama ikaxbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jatian jaskáa pekáora, ja jonibo raankin senenhataanan, Jesús biribi moa boten nanetaanan, Magadán main kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jatianra, *fariseoboyabi saduceobo Jesús oinni bokana iki. Boxonra, jakonmain pakémati shinanya ixon, Diossen raanakon ixon, ja oinxon onankanti jato oinmati yokákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ikaxbi Jesussen jato yoia iki: “Matora ikai yantanpake nai oinxon oinna jakonshaman iketian, ‘ramara moa oi beyamai iki’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jatian yamékiri, nai oinna koin kextó iketian mato iribai, ‘ramara oi beai’, iki. Jaskáakin ja nai oinxonres, nete jaskara ikaibo onanai ixonbiki, ¿Jawekopíki, ja rama en akai jawékibo oinxonbi maton onanyamaresai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jakonma itan yoitima jonibo ixonra akai ja oinxon onanti anon ixon maton ea yokákin. Ikaxbira en mato oinmakasai, ja *profeta Jonás winóni keskábichores”, akin jato aká iki. Jato jaskáakin yoitaanan, moa jato potabaini kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jatian ja ian keiba shitati boira, jaonmea onannaibo panman shinanbenobainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jatianra Jesussen jato yoia iki: —Ointanikanwe, ja *fariseoboyabi *saduceobaon, *levadurakira mato koiranmeeti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jato jaskáakara, jaonmea onannaibo ikana iki: —Non pan beyamaketianra ake noa jaskáakin yoikin —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jaskákanai onantaanan, jato Jesussen yoia iki: —¿Jawekopíki pan yamaketian, mato jashoko yoii iitai? Eki kikini koshiama jonibo riki mato. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ramakamanbiki maton onanyamaa? ¿Ja pichika waranka joni, pichika panribi en jato pimanontianki, jaweti tasá bocho maton tsinkiantana iki ixon maton shinanyamai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jainoax ¿Ja kanchis pan, en chosko waranka joni jato pimanontian, jatí tasá bocho tsinkiantanaki, moa maton shinanyamaribiai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jawekopíkayaki maton onanyamaresai? Pan yoiira iamake ea jaskati. Ja fariseobo betan *saduceobaon *levadurakikaya koirameekanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jatianpari onankana iki, jayá pan ati levaduraki koirameekanti yoiima Jesús iwana. Ja iká iki, fariseobo betan *saduceobaon jakonma eséki koiranmeeti jato yoikin jato aká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jatian ja Filipo main iká Cesareanko moa nokóxon, Jesussen jaonmea onannaibo yokata iki: —¿Ja jonin Bakeki tsoa iki ixon jonibaon shinannai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jatian jawen jonibaon yoia iki: —Jatíribibaonra shinannai, mia jato *bautizanai Juan. Wetsabaonra shinannai, mia Elías. Jainxonribira shinankanai, mia *profeta Jeremías, iamax wetsa *profetabo —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jaskáakana —¿Jatian matonbiribiki, ea tsoa shinannai? —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jatian Pedron yoia iki: —Mia riki *Cristo, ja jiria Diossen bake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jaskáa Jesussen yoia iki: —Diossenra mia raroshaman imake, Jonassen bake Pedro, natora minbi onanama iki. Ja naikan iká nokon Papa Diossenbira mia onanmake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jatian enbiribira mia yoiai, mia riki Pedro; ja iki shanka iki iká. Ja nato shankakira nokon joni itibo en jato tsinkinoxiki. Jara mawakan atipana koshinbi, jawekeskaxonbi ras atima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Diossen ikinaton jati nete kepenti koshira en mia meniai. Ja nato mainxon min atima yoiaibora, naikanxonribi Diossenribi atima yoiai. Jatian ja nato mainxon min ati yoiaiboribira, Diossenribi ati yoiai itiki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jaskátaanan jaonmea onannaibo Jesussen yoia iki; ja riki Cristo akin tsoabi jato keshantima. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jainxonra peokin jaonmea onannaibo Jesussen yoia iki, ja Jerusalénhain kaketian, judíobaon joni koshibo, itan *sacerdotebaon koshibaon, jainoax ja esé onan jonibaon, kikinhakin masá tenemakantibo. Jainxonra ea retekanti jake, ikaxbira kimisha nete itin ea jiriribiti iki, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jatianra Pedron okeshoko bibainxon: —Miara jaskara winóti atipanyamake Ibó; Diossen mia jaskámayamabanon —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jaskáketianra, Jesussen bechiakekainxon Pedro neskáa iki: —Nenoax katanwe *Satanás. Miara ea jakonmain pakémakasires iki. Diossen keenai jawékibo atira min shinanyamai, jonibo keenai atiresa min shinannai —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Japekao, Jesussen jaonmea onannaibo yoia iki: —Ja nokon joni itin keenaibora, jaton keena keskáres akí jenéti iki. Ea kopi masá teneti jawemabi ixon, ea chibankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja jakonshamares jatín keenaibora, moa jatíbi manóke. Ikaxbi, ea kopi menikaataibaonra, jakon jati nokokanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Jakonmein iti iki, nato netemea jawékibo kaiaa ikátiibi, jati neteoma joni iká? Iamaxon ¿Jawen kaya kishpinti kopímein, jawetiishaman jonin kopíatiki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja jonin Bakera jonoxiki, jawen Papan koshi shinanya itan jawen ángelboya. Joxonra ja tee akana betan senenribi jaton biti jawékibo jato menipakenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ikonshamanra en mato yoiai, jatíribi ja neno itinabora mawáyamanoxikanai, ja jonin Baken ikinaton jawen jonibo jakana oinnai kamanpari —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sokota nete pekáora, Pedro, Jacobo jainoax Jacobonin wetsa Juan, jato Jesussen manan keyá ikain boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jain ikaxa, jato bebomeax Jesús wetsaresibia iki. Jawen bemananra iká iki bari keska pené. Jatian jawen chopabiribira iká iki, kikinbires joxo ikax, joé keska penébires. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moa jaskáketian oinkana iká iki, Moisés betan Elías Jesús betan yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jatian Pedron Jesús yoia iki: —Ibó, jakonhira riki noa neno iká. Mia keenketianra, en kimisha peota atiki; westíora itiki mina; wetsa Moiséssena; jainoax wetsa iti iki, Elíasna —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jaskáakinbo yoii Pedro itainbi, nai koin penébirestonin, jato mapotoshita iki. Jatian ja koin meranoax: “Nato riki nokon noi Bake, jaonra ea ikonbiresi raroai, jawen joi senenhaxonkanwe”, iki yoyo ikaitian ninkákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jaskataitian ninkatax, jaonmea onannaibo ikonbiresi raketi chirankootaanan mainbi bekepikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jatianra pataxbainxon jato Jesussen tii aka iki. Jainxon jato yoia iki: —Weníkanwe, rakéyamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jato jaskáketian oinkana iká iki moa Jesúsbicho itina. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jatian moa mananmameax ipakekin, jato Jesussen yoia iki: —Ja maton oinnabo, ja jonin Bake mawatax jiriai kamanpari tsoabi yoiamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jato jaskáketian jaonmea onanaibaon Jesús yokákana iki: —¿Jawekopíki ja esé onanbaon yoiai, *profeta Elíasparira joti jake iki ixon? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jatian Jesussen jato yoia iki: —Ikon riki. Elíasparira joti jake, janpari jatíbi jawéki benxoati kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ikaxbi enra mato yoiai, Elíassa moa jonike. Jokenbira, onanyamaxon jaton keena keskáres akana iki. Jaskatiribira inoxiki, ja jonin Bake, masá memakana onitsapiti —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jato jaskáaketian, jaonmea onanaibaon onanna iki, ja jato bautizanai Juan yoikin jato Jesussen aká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jatian ja jonibo ikainko moa nokókanketian, westíora joni Jesúski joáx, ja bebon chirankootoshixon yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nokon bake noibataanan ea akinxonwe, Ibó. Beyóskinra masábires tenei. Ichaira chiiki moa pakéke. Jainxon, ichakinribira jene tsakake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mionmea onannaibo en bexonabira, jabaon benxoati atipanyamakanke —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jaskáa, Jesussen jato yoia iki: —Dioski koshiti maxkata itan jakonmabo riki mato. ¿Eahomaxonki maton jawebi atipanyamaa? ¿Jawetian mato jaskaraton axetikayarin? Neri ja bake ea bexonkanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jatian bexonkana, ja bake meran iká yoshin notsínxon Jesussen pikoa iki. Jaskáatianbi ja bake moa benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jaskáa pekáo, jatonbichobiribi kenaanan jaonmea onanaibaon Jesús yokákana iki. —¿Jawekopiki ja yoshin non pikoti atipanyamaa ika? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jaskáa, jato Jesussen yoia iki: —Matora Dioski ikoni koshiamabo iki. Ikonshamanra en mato yoiai; ja mato Dioski koshia shinan, mostaza berotiotanibires ixonra, ‘Nato manan, okechaa taxkéwe akin maton aká, ja manan taxkéti atipanke’. Jatianra jawe atikomabi matona yamatiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ikaxbi jaskara yoshinbora, oranhananbi, ayunaxonpari pikotibo iki —akin jato aká iki ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jatian jato betanbi Galilea main kakin, Jesussen jato yoia iki: —Ja jonin Bakera, jato yatanmanoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jaskáaxonra retenoxikanai. Ikaxbira, kimisha nete pekáo jiriribinoxiki —akin. Jaskatai ninkaxon, akonbireskin masá shinanni onískana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jatian moa Jesús jaonmea onanaiboyabi, Capernaúmhain nokókanketianra, Dios rabiti xobo benxoati koríki tsinkiaibo Pedroiba bekana iki. Bexon yokákana iki: —¿Maton maestronki, ja Dios rabiti xobo benxoati koríki meniamai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jaskáakana; —Arai kopíakin —akin jato Pedron aká iki. Jato jaskáabaini moa xobo chicho Pedro jikiketian, janpariakin Jesussen neskáa iki: —Simón minbiribiki jawekeska shinannai ¿Tsoabokayaki, ja meskó jawékibo kopí apobaon jato kopí yokatai? ¿Jaton bakebo, ó wetsabores? —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jatian Pedron yoia iki: —Wetsaboresa jato akanai —akin. Jaskáa Jesussen yoia iki: —Jaskara ixonra, jawen bakebaon jawebi kopíayamakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ikaxbi, jato jakonma shinanmatima kopí, ianman kaxon mishkitanwe. Jawerato yapaki min japari biai, jara min janchópeti jake, jainoara min koríki merati iki. Ja koríki bixonra, nokona betan minayabiakin moa min jato kopíati iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jatianribi jaonmea onanaibaon Jesús yokákana iki: —¿Tsoakayarin, ja Diossen ikinaton jatínko jato xewina? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jaskáakana, westíora bake kenaxon, jato napon Jesussen nichina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jainxon jato yoia iki: —Ikonshamanra en mato yoiai; jakonma shinan jenetaanan, bake keskati iamaira, jawekeskataxbi ja Diossen ikinaton jatínko, mato jikiamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ja Diossen ikinaton jatínko, kikin iki kaibo riki, kikinman shinanmeeyamataanan bake keskati ikaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jaweratobaonki nokon janenko westíora bake nato keskaribi biai, jabaonra moa earibi bike. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jatian jaweratobaonki ja eki koshia bakebo jato ochan pakémai, jabora jan reneti ani makan teomaxon aniparo napo jato potakanti bebonbires jakonma biti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Jawe iresaipanon nato nete, jan jonibo ochan pakémati jawékiboya ikax. Jara jaskáshamanhaxon bechitentikoma iki. Ikaxbi, jawe iresaipanon, ja wetsabo jan jato ochan pakémaibo! ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jaskara iken, ja min mekenman iamaxon min taen mia ochan pakémai iketian, xatexon ochó potawe. Jaskara ponxte iamax kixtebicho mia basibires jaakayara jakon itiki. Ja okenbekonbi mekenya iamax okenbekonbi taeya mia Diossen chiikan ewa meran potatitianbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jatian ja min beron mia ochan pakémaitian, tsekaxon ochó potawe. Westíora beroyabicho mia basibires jaakayara jakon itiki. Ja okenbekonbi beroya mia Diossen chiikan ewa meran potatitianbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nato bakebo tsoabi jato omisyamakanwe. Jan jato koirannai Ángelbora, Dios betanbi ikábo iki ixonra en mato pontéshaman yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ja jonin Bakera joá iki, manotabo jato kishpinmati kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Matonki jawekeska shinannai? Westíora joni itiki pacha ovejaya, ikenbi itiki westíora manoti. ¿Jaskákemein, ja iskon chonka iskon, jainbi ja mananman potabaini, ja westíora manota benai katima iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Enra onanke, kaxon meraaxa ikonbiresi rarotiki; ja jatíribi manotamabo oinnax ikai bebonbires. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaskáribiira, ja maton Papa naikan iká, tsoa bakebi manótinin keenyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ja mibé joi akaitonin mia jakonmaaka. Jabebichopari yoyo ixon, shinanmeemawe jawen jakonma akábo, jatian mia ninkáxonara, jakiribi min wetsa betan mia jakon banéke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jatian jaskáabi mia ninkáxonyamaitianra, westíora iamax rabé joi akairibi min kenati iki; ja mato yoyo ikaibo rabé iamax kimishaxon ninkata iti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jatian jaskáakin akábi jato ninkáxonyamaitian, joi akaibo jato yoiwe. Jatian ja joi akaibaon yoiabi jato ninkáxonyamaribaitianra, moa joi akaima joni iamax ja apo kopí yokáxonaibo keskáakinres min ointi jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Enra ikonshaman yoiai, ja nato mainxon maton atima yoiaibora, naikanxonribi Diossen atima yoiai. Jatian nato mainxon maton ati yoiaibora, Diossenribi ati yoiai itiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Enra mato yoiribiai: Jawetianki Dios jawéki yokánox, nato mainxon maton westíora shinanbicho rabéxonbi abékonai, jatianra mato Diossen meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jatian jaweranoki rabé iamax kimisha inonbi nokon janenko tsinkíkana iki, jainriki ea jato betan —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jaskáketian, nokobainxon Pedron yokata iki: —Ibó, ¿Westíora ebé joi akaitonin ea jakonmaaketianki, jawetiakinres en moa ja shinanxontima iki? ¿Kanchis akin? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jatian Jesussen yoia iki: —Kanchis akinbicho atira en mia yoiamai. Kanchis chonkaakinkayara, ja kanchis min senenhati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja Diossen ikinaton jatira, westíora apon jawen yonotibaon ribina iken jato yokápakeni keská iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jatian moa jaton ribinbo jato yokákin peoketianra, jan kikinbires icha ribina westíora joni bexonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jatian jan kopíatioma ja joni iketianra, apon jato yoia iki, jawen awinyabi itan jawen bakeboyabi ja jonin marokanti. Jainoax jatíbi jawen jayata jawékiboribi iti jato yoia iki. Jaskaraton moa jawen ribinbo kopíanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jaskáaketianra, jabé teetai jonin ja apo bebon chirankootanan yoia iki: ‘Shokorespari ea manawe Ibó, en mia keyokin kopíanon’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jaskáakin akára, noibataanan apon jawen ribinbo moa shinanxonyamataanan, jaweayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jatian moa jaskáa pikókainkibi, jan ichama ribina jonibiribi jan bechia iki. Ja bechixonra, tepotsiananbi yoia iki: ‘¡Ja min ea ribina, moa ea ishton kopiáwe!’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jaskaaka, ja bebon chirankootanan jonin yoia iki: ‘Shokorespari ea manawe, en mia keyokin kopíanon’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jaskáabi keenyamataanan, cárcel meranres jato amaa iki; jawen ribin kopíai kaman iti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jaskaaka oinxonra, wetsa jabé teetaibaon akonbireskin masá shinankana iki. Jaskákinra, ja apo boxon keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jatianra aponbiribi kenamaa joketian neskáakin yoia iki: ‘¡Mia riki kikin jakonma joni! Enra jatíbi min ea ribinabo mia shinanxonyamake, min ea ayorakin yokákin jeneyamaketianres. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Jatian jawekopíki ja en mia aká keskáakinribi, mibé teetai joni min noibayamaa?’ akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jaskaraton ikonbiresi sináxonra, ja apon jawen ribin keyo kopíakai kaman jato castigamaa iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jaskáatanan jato Jesussen yoia iki: —Nokon Papa Dios naikan ikátoninra, mato jaskáashokoti iki, ja mato betan joi akaibo betan jakonmanana ixon, akonkin maton shinanxonkin jeneyamaitian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jaskara jawékibo jato Galileankoxon yoikin senenhataananra, ja Jordán keiba iká Judea main moa Jesús kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kaitianra icha jonin chibana iki. Jatianra jain ixon, jatíbi isinaibo jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jaskaai iitainra, *fariseobo bekana iki jaskáaxon Jesús jakonmaati benai. Bexonra yokákana iki: —¿Wetsa jawéki kopíbires jonin jawen awin potatiki jakon iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jaskáakana, Jesussen jato yoia iki: —¿Matonkayaki yoyo ayosma iki, ja jatíbi peoai bená, ‘benbo betan ainbo Diossen joniani’, iki ixon jawen joi meran yoiai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jaskara kopíkaya Diossen yoinike: ‘Joninra jawen papa betan jawen tita jeneti iki, jawen awin betanbiribi wanoxon, jaskataxa ja rabé moa westíora yorabicho keská iti iki’, iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jatianra moa rabé yora iamai, westíora yorabicho iki. Jaskara ikenra, Diossenbi jato wanomaa, tsonbi jato potaanamati atipanyamake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jatian fariseobaon yokáribia iki: —¿Jawekopíkayaki Moiséssen yoini, ainbo potanoxonpari kirika wishaanan meniti? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jaskáakana, jato Jesussen yoia iki: —Maton keena keskábores akaibo ikenra aká iki Moiséssen jaskáakin jaton awin potati yoikin. Ikaxbi rekenra, jaskara iti ikáma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jatianra enbiribi mato yoiai: Jaweratobaonki jaton awinin yosmaamabi, potaxon wetsa ainbo biai, jabaonra wanoyaxonbi wetsa betan yoranti akai. Jatian tsonki ja potá beneya ainbo biai, janra benoya betanbi yoranairibi ikai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jatian jaonmea onanaibaon yoia iki: —Jonin jawen awin jaskáati iketiankayara, joni wanoyamaakaya jakonhira iti iki —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jatian Jesussen jato yoia iki: —Jatikaxbira tsoa wanooma iti atipanyamake. Jaskara itibobiribi jato Diossenbi imaaboresa ikanai jaskara. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jarake meskó jawéki, jaskara kopíbo jatíribi jonibo wanoyamai. Jatiribora wanoyamai, jaskarabiribi iti pikotabo ikax. Wetsabora wanoyamai, wetsabaon jaton yora ramianana ikax. Jatian wetsabora wanoyamakanai, Diossen jawékibiribi axonti shinanyabo ikax. Jaweratoboki, ja en yoipakeabo iti jisá iki, jaskara ikanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jatian jatíribibaon, jaton bakebo Jesússiba bekana iki, mamepasxon jatoki oranon ixon. Ikaxbi jaonmea onanaibaon jato notsina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jatianra Jesussen jato yoia iki: —Ja bakebo bechiteyamakanwe, ibakanon eki bei. Jato keskabaonakaya riki ja Diossen ikinaton jati nete —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jaskáaxon ja bakebo mamepasxon jatoki orankin senenhataanan, moa jainoax wetsanko karibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Westíora bakeranonra Jesús oinni kaa iki, kaxonra neskáakin yokata iki: —Jakon maestró ¿Jawe jakon jawékishamanki en ati iki, jatíbitian jati neteya inoxon? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jaskaa Jesussen yoia iki: —¿Jaweatiki min ea jakon maestró, akin akai? Dios bichoresiki jakon. Ikaxbi, ikoni jatíbitian jatín keenira, ja senenhati join yoiai keskati mia jati iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jatian ja bakeranoman aká iki: —¿Jaweratoborin, ja senenhati joi? —akin. Jaskáa Jesussen yoia iki: —‘Jato reteyamawe; wanoya itan benoya ixonbi, wetsa betan yoranyamawe; yometsoyamawe; wetsabo jakonmaanox jansoi yoyo iamawe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Min papa betan min tita jakonhawe, itan minbix noikaata keskáribiakin, wetsaboribi noiwe, ikira ikai’ —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jaskaaka, ja bakeranonman yoia iki: —Jatíbi ja min ea yoiabora, baketianbi moa en senenhaa iki, ¿Ramaki ea jawe maxkata? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jatian Jesussen yoia iki: —Ikoni jakonbires itin keenkin, jatíbi mia jayata jawékinin maroxon, ja jawebiomashokobo jato menitanwe. Jaskáaxpariresa, mia naikan icha jawékia itiki. Jaskáakin senenhabeirani, jotanwe mia nokon joni inon —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jaskáakin akára, onískaini ja bakeranon kaa iki, ichayora jawékia ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jaskáaketianra jaonmea onannaibo Jesussen yoia iki: —Ikonshamanra en mato yoiai, kikinshaman itikoma riki, ja icha jawékiabo, Diossen jato ikinai neten jikiti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jatianra en mato yoiribiai: Westíora camellonara itibiresma iki, ja xomox chipekenin bebati, jatian ja icha jawékiabaonara bebonbires itikoma iki ja Diossen ikinaton jati netenko jikiti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jaskati yoyo iketian ninkataxa jaonmea onannaibo ikonbiresi ratetax ikana iki: —Jatian jaskara ikenki ¿Tsoakaya kishpinmeeti atipana? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jaskákanaitianra, jainbikon ointaanan Jesussen jato yoia iki: —Natora jonibaon atipanyamake, ikaxbi Diossenara jatíbi atibires iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jaskáketian Pedron yoia iki: —Nonra, jatíbi noa jayata jawékibo jenea iki. Jaskáaxa mia chibani joá iki. Jatianki ¿Jawe non binoxiki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jatian Jesussen yoia iki: —Ikonshamanra en mato yoiai, moa jatíbi jawékibo jakiribi benaakin aríbaxa, ja jonin Bake jawen penébires yakátinin yakánoxiki. Jatianribira ea chibanabo ikax, matoribi ebébi ja chonka rabé yakátinin yakánoxiki, jaskáaxon ja chonka rabé tsamá *Israelnin rarebobo jaton akábo jato yoixonox. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jatian jaweratobaonki ea kopi, jaton xobo, jaton wetsabo itan jaton poibo, jaton papa itan jaton tita, jaton awin itan jaton bakebo, jainxon jaton waibo jeneai; jabaonra ja jaton jawékibo jenea bebonbires pachabo binoxikanai, itan jatíbitian jati neteyaribi inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ikaxbi icha ja ramatian kikin ikátiaibora kikinmashokobo inoxikanai, jatian ja ramatian kikinmashoko ikátiaibora kikinbo inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ja Diossen noa ikinti riki, westíora uva waia joni jato teemanoxon yamékirishoko jonibo benai kaní keska. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jatian ja teekasai jonibo westíora nete teeta betan senen jato kopíati yoia jakon ikanaitian, moa jawen wainko jato teeti raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iiwanax, moa iskon hora yamékiri iketian, plazain karibaxon nokoa iki, icha joni jawe akímabi iiresaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jainoa jato yoia iki: ‘Matoribi nokon uva wainko teetankanwe, enra mato senen kopíatiki’, akin. Jato jaskáa, jaboribi teeti bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jainoax bariapan, jakiribi karibaa iki. Iiwanax yantanpake karibaxon jato jaskáaribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jainoax moa bari jikiti ochóma jakiribi karibaxon oinna iká iki, wetsaboribi jawe akímabi iiresaibo, jainoa jato yokata iki: ‘¿Jawekopíki mato neno teetimabi iibaitai?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jaskáa yoikana iki: ‘Tsonbi noa teeti biama ikaxa noa ikanai’, akin. Jaskáakana: ‘Rama matoribi ja nokon uva wainko teeti botankanwe’, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jatian moa yaméketianra ja wai ibon, ja teetaibaon koshi kenaxon yoia iki: ‘Ja teetabo kenaxon moa jato kopíapakewe, rekenpari ja chiní teeti jikiwanabo awé, japekáora ja reken jikiwanabo min jato akai’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jatianra chiníbires teeti jikiwanabaonpari bexon, ja westíora nete teexon bititiiribi bipakekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Japekao, moa reken teeti jikiwanabaon biti iketian shinankana iki, jabaon bebonchaa biti. Ikaxbi jabaonribi, westíora nete teexon bikanaitiiribi bikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jatian moa kopí biaxa, ja wai iboki jakonmaibiresbo yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jaskákin yoikana iki: ‘Ja chiní nokotabo westíora horares teekankenbira, noa akátiiribi min jato kopíake, noabokaya ikonbiresi bari napobi iibaiti teekenbi’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jaskáakana, ja ibon, jato betan itina westíora yoia iki: ‘Joní, enra mia jakonmaama iki. Westíora nete teeta betan senen en mia kopíatira moa non shinan abékonwanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Natoriki ja min koríki, ja biax moa katanwe. Ikaxbi eara keenai ja chiní jikiwanaboribi mato akátiiribi kopíatinin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Enra ja nokon koríki, nokon keena keskáakin ati atipanke. Jatian ¿Jawekopíki ikai ea jakonhira iketian mia eki notsi?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jaskatira, ja rekenain iitaibo chinínoxiki, jatian ja chinitain iitaibobiribi rekennoxikanai. Icha riki ja kenakaatabo, ikaxbi ja katokootabora ichama iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jainoax Jesús moa jerusalénhain, kaa iki. Ja bain kakinra jawen chonka rabé jaonmea onannaibo tsinkixon jato yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ramara noa jerusalénhain bokanai, jainxonra ja jonin Bake yataanan ja *sacerdotebaon koshibo itan ja esé onanbo menikin bonoxikanai. Jatianra jabaon jaskáaxon reteti shinankanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jainxonra ja judíoma jonibo meninoxikanai jaki shirokanon ixon, rishkionkanon ixon, itan korosen axon retebakanon ixon. Ikaxbi kimisha nete itinra jirinoxiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jatian ja Zebedeon bakebaon tita, jawen bakebo betanbi joáx Jesús bebon chirankootoshita iki, jawéki yokákasi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jatian Jesussen yokata iki: —¿Jaweki mia keenai? —akin. Jatian ainbaon yoia iki: —Moa mia apo jikixon ja nokon bake rabébi, wetsa min mekayao, itan wetsa min memio jato yakámatinra ea keenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jaskáa, Jesussen yoia iki: —Matonra onanyamake ja maton yokatai. ¿Matonki atipantiki ja moka tenexon en xeairibi xeakin? —akin jato aká iki. Jatian jabaon yoia iki: —Nonra atipanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jatian Jesussen jato yoia iki: —Ikon riki, ja moka tenexon en xeairibira maton xeanoxiki. Ikaxbi ja nokon mekayao itan nokon memio jato yakámatira, en jato imaima iki. Nokon papanresa oinnoxiki tsoaboki jan imatiki ixon —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jatian jaskáakinbo aká ninkatax, jatíribi chonka Jesussenmea onannaibo, ja rabéki sinákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jaskákanaitian jato kenaxon Jesussen yoia iki: —Matonra onanke, Dios ikonhayamai apobaonra akai jawen jemabo kikinhakin iboataanan jato ikinkin. Jatian ja kikinman shinanmeetaibaon akai jaton keena keskáakin jato akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ikaxbi matora jaskakanantima iki. Jaweratoboki kikinman ninkakaatai itin keenai, jabora jato jawéki axonaibores iti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jaweratoboki jato xewina iti shinanyabo iki, jabora jaton yonoti iti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ja jonin Bakera jaskara iki. Jara akinkanon ikax joáma iki. Jara joá iki jato akinti kopí, itan jawen yoranbi kopíataanan jatíbi jato ochankonia xabáai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jatian Jericóainoax moa bokanaitian, icha jonin jato chibana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ja bai kexa iká iki benche rabé yakábekona. Jatian Jesús jan winotai ninkatax, iká iki: —Ibó, miara Davidkan bake iki. Noibataanan noa akinwe —iki saí ibekoni. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jaskataitian, netémakaskin jonibaon notsina iki. Ikaxbi jatiankaya bebonbires koshin saí ibekona iki: —Ibó, miara Davidkan bake iki. Noibataanan noa akinwe —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jaskaketian Jesús jainpari chankata iki. Jainxon jato kenaxon yokata iki: —¿En jawe mato kopi atinki mato keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jaskáa yoibekona iki: —Ibó, min oinmatinra noa keenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jaskáakana Jesussen jato noibaa iki. Jainxon jato bero tii axona iki. Jaskáatianbi ja benche rabékan moa oinbekona iki. Jaskatax Jesús chibani kabékona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jaskati kaax, ja Betfagé jeman nokókana iki, ja Olivos manan ikainko, moa Jerusalén ochóma. Jainxonra Jesussen jaonmea onanai rabé raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jato raankin yoia iki: —Oa nenonxon non oinna jema itinainko botankawe, jain kaxonra, westíora burro bake betan burro awin nexakana maton nokotiki. Ja choroanan ea bexontankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jatian jaweraki mato akanaitian, non Ibo keenaitianra non boai, ramashokobira mato banexonribai akin jato yoitankanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nato jawékibora iká iki, ja *profetanin yoinibo senennon ikax. Ja wishára ikai neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ja *Sión janeya mananman iká jonibo yoikanwe ‘Oinkanwe, jainra maton apo joái. Jara rabiti shinanhoma iki. Westíora burro baken peyakaaxa joái’ ”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jaskáakin jato yoia kaxonra, ja Jesussen yoia keskáakin jaonmea onanaibaon akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bekana iki ja burro awin betan ja burro bake. Bexonra ja rabébi jaton taribaon pekakaakana iki, jatian Jesús jan peyakax kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ja kaaitianra, icha ixon jonibaon jaton taribo bai naponbi kakaaxonkana iki. Jatíribibaon, jiwi poyanshokobo ponskeanan, ja kaai bai napon tipinxonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jatian ja rekenain boaibo itan já pekao beaibo, saa ikana iki: —¡Noa kishpinmawe apo Davidkan Baké! ¡Nonra mia jowé akai, mia riki ja Ibon janenko joái! ¡Noa kishpinmawe ani Diossé! —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jatian moa Jerusalénhain Jesús jikiketianra, ja jemameabo jatikaxbi meskóbo shinanni ratékana iki. Jaskati ikana iki: —¿Tsoarin nato joni? —ikibo yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jaskákanaitian, jabé beabaon jato yoia iki: —Nato riki ja *Profeta Jesús, ja Galilea main iká Nazaret jemamea —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jatian moa jain ikaxa, *Diossen xobo meran Jesús jikia iki. Jain jikixonra, jainoax maroaibo jatíbi jato jokonhaa iki. Koríki cambianaibaon mesabo, itan jainoax xotó maroti akanaboribi jato werananpakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jainxon jato yoia iki: —Jawen kirika meranra, Dios neskatai: ‘Nokon xobora iti jake, jainoax Dios betan yoyo iti xobobiribi’, iki. Ikaxbi matonra imake, ja meranoax yometsoti xobo —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jatian jain Jesús iketianra, Dios rabiti xobo meran, bencheboyabi nitikomabo bekana iki. Bekanketianra jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ikaxbi ja ratéti jawékibo akaitian oinnax itan Dios rabiti xobo meranoax: “¡Noa kishpinmawe apo Davidkan Baké!” iki bakebo saa ikai ninkatax, ja *sacerdotebaon koshibo itan ja esé onanbo, ikonbiresi sinákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jaskákin Jesús yoikana iki: —¿Minki ninkatai mia yoii jaskákanaibo? —akin. Jatian Jesussen jato yoia iki: —Enra ninkatai. Ikaxbi ¿Matonki yoyo akama iki, jaskara iti yoii Diossen joi meran neskatai? Jainra ikai: ‘Ja bakeshokobo, ja xoma akaishokobaonbira mia rabinoxikanai’, iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jato jaskáabaini, ja jemameax moa Jesús Betania jeman kaa iki. Ja yamé jain oxaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jatian yamékirishoko moa jakiribi Jerusalénhain karibai, Jesús jawékiakasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kakinbi higo jiwi bai kexa chankata meraa iki. Ikaxbi, ochómakainxon oinnabi iká iki peiabichores. Jaskara iketian yoia iki: —¡Jawetianbira mia jakiribi bimiamanoxiki! —akin. Jaskáatianbi ja higo jiwi moa tanoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jaskáaketian oinnax ratéxon, jaonmea onanaibaon Jesús yokákana iki: —¿Jawekeskatiki, nato higo jiwi ishtonbires tanoa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jatian Jesussen jato yoia iki: —Ikonshamanra en mato yoiai: Ikoni Dioski koshiabo ixon meskó shinanyamakinra, nato higo jiwi en aká keskáakinbicho maton atima iki. Jawekeska ixon, nato manan maton yoiti iki: ‘Nenoax tsekékaini kaax, aniparo napo pakétanwe’, akin. Jatianra mato ixonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jatian jatíbi maton oracion meran yokataibora, akonkin ikonhaxon maton biti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jaskata pekáora, Dios rabiti xobo meran Jesús jikia iki. Jainxon jato axeai iitaitianra, *sacerdotebaon koshiboya, ja judíobaon joni koshibo bexon yokákana iki: —¿Tson shinanmanki min jato jaskáai? ¿Tsonki mia jaskara yoiti koshi imaa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jaskáakana, jato Jesussen yoia iki: —Enribi mato westíora yoká ashokoai; ja maton ea yoiketianra, enribi mato yoitiki, tson shinanmanki en jaskarabo akai iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tson amaaki, Juanman jato bautizana iki? ¿Diossen amaa, ó jonibaon amaaki iká iki? —akin jato aká iki. Jato jaskáa meskó shinanbo akí neskákana iki: “Diossen amaara aká iki akin non akábira, ‘¿Jaweati maton ikonhayamaa iki?’ akin noa ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jatian jonibaon amaara aká iki akin non ati ikaxbira, noa rakéribiai, jatíxonbiora já *profeta onankana iketian”, iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jaskáaxon yoikana iki: —Nonra onanyamake —akin. Jatian Jesussen jato yoia iki: —Jaskara ikenra enribi mato yoiamai, tson amaaki en jaskarabo akai ixon —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jatian Jesussen jato yoiribia iki: —¿Jawekeskaki maton shinannai neskara joi? Westíora jonironki inike rabé bakeya. Jatian jawen reken bake yoia iki: ‘Baké, ramapari nokon wainko uva bimi tsekai teetanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jaskáabi, ja baken yoia iki: ‘¡Eara kakashamai!’ akin. Jatian jaskáawanaxbi, moa wetsa shinan biax teeti kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jainxon, jawen wetsa bake jaskáakinribi yoia iki: ‘Jaskáa, ikonrake ea kabatanon’, akin aká iki. Ikaxbi ja bake kayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jatian jawerato bakenki, jawen papan joi senenhaxona iki? —akin jato aká iki. Jatian jabaon yoia iki: —Ja rekemanra axona iki —akin. Jatian Jesussen jato yoia iki: —Ikonshamanra en mato yoiai; matobo ikámatianbira, jan apo kopí yokákinxonaibo itan tsini ainbobopari, ja Diossen jato ikinti netenko jikinoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jato *bautizanai Juanra joá iki, itibi keskati jati jato onanmai, jabira maton ikonhayamaa iki. Jatianra, ja apo kopí yokákinxonaibo, itan ja tsini ainbobaonres ikonhakana iki. Jabo jaskataira maton oinna iki. Ikaxbi, mato shinanmeeyamakana iki já ikonhanox. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ramapari ja wetsa jawékiki yoinmeeta esé ninkáribikanwe: Westíora joninra jawen mainko uva wai axon, ja katemakin chiketa iki. Jaskáaxonra jainxon vinoati chinia iki, itan jainxon koiranti keyá xoboribi aká iki. Jaskarabo ayona pekáora, jain teekanon ixon, jaweti teetaibo jato menibaini moa ochó kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jatian ja uva bimibo moa tsekati senenketianra, jawen jonibo raana iki, jain teetaibaon jawenabiribi axonkana yokáxon bixonkanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ikaxbi, jain teetaibaon ja boabo yatanxon jakonmaakana iki. Westíora rishkionkana iki, wetsa retekana iki, jainxon wetsabiribi makanman tsakayonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jato jaskáakanketian, ja reken jato raanhibata bebonbires, ja wai ibon jawen yonotibo raanribia iki. Jaabi, ja reken boabo aibata keskáakinribi jato akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jainxonra, senentiainbi jawen bakebi raanribia iki. ‘Jara tsonbi jaweatima iki ixon shinantaanan’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikaxbi ja bake oinnax, ja teetaibo neskati yoyo ikana iki: ‘Nato riki ja jawen papan jawéki jan biti, retenon akanwe. Jatianra noa ibo banéti iki’, iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jaskáxon ja bake yatanxon, uva wainkonia pikobainkin boxon retekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Jatian maton shinannamein, ja uva wai ibo joxon ja teetaibo jaweatiki? —akin jato Jesussen yokata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jaskáa yoikana iki: —Noibayamakinra ja jakonmabo jato keyo reteti iki. Jaskáaxonra wetsa teetaibo jain imati iki, ja bimi tsekaitiibi, jan biti ikátiishaman meniti atipanabo —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jatian Jesussen jato yoia iki: —¿Matonki ja Wishá meran yoiaibo jawetianbi yoyo akama iki? Jainra ikai: ‘Ja xoboaibaon rotokani makanra, jaki xoboati makan baneta iki. Natora non Ibon aká iki, jara ja oinnax jaon manaiti jawéki iki’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jaskara kopíra en yoiai, matobo jawen joni itinra moa Diossen keenyamanoxiki. Jatianra jawen ikinna joni jaskara atin já keenaishaman akaibores jato imanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tsoaki ja nato makanki paketai, jara kikini rorokookainti iki. Jatian tsokiki ja nato makan paketai, jara jaras abainti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jatian ja jawékiki yoinmeeta esé ninkaxon, ja *sacerdotebo itan *fariseobaon, onanna iki jatobi yoii jaskata. ");
INSERT INTO shpNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jaskara onanxon yatankasibi, joniboki rakékana iki, *profeta riki ixon shinankanai kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jatian Jesussen, jakiribi jawékiki yoinmeeta esé yoikin jato aríbaa iki neskáakin: ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ja Diossen ikinaton jati riki, westíora apon jawen bake wanoaitian fiestaaxon icha jawékiati aní keskaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jaskáaxon, ja apon jawen yonotibo raana iki, ja chaniabo moa jato kenati, ikaxbi tsoabi bekashamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jatianra jakiribi wetsa jawen yonotibo raanribia iki neskáakin yoixon: ‘Ja en jato chaniabo yoitankanwe moara en jawékiati ake. Enra nokon wakabo itan nokon yoina xoashamanbo jato retemake, moa jawékiatiresiki. Jawékiaki bekanwe’, akin jato ati. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ikaxbi ja chaniabaon jato joi ninkáxonyamaa iki. Jaskati wetsa jawen mai oinnibiribi kaa iki. Wetsabiribi jawen jawékinin maroires kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jatian wetsabaonbiribi ja apon yonotibo yatanxon, ramiayonxon retekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jaskara ninkataxa ja apo ikonbiresi sinata iki. Jaskákinra jawen sontárobo raanxon ja retemisbo jato keyo retemaa iki. Jainxon, jaton jemaribi jatiobi jato menomaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jaskáa pekáo ja apon jawen yonotibo yoia iki: ‘Ja wanoti fiestatian non piti akára moa ike, ikaxbi ja en chania ikábora jaskarain joti jisámabobi ikanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ramakaya icha jan winókanai callebaon boxon, jatíbi ja maton bechiaibo jato chanitankanwe’, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jato jaskáa boxon ja yonotibaon ja callen ikábo jato chania iki, jakon itan jakonma jonibo inonbi, jaskáakanara jainoax wanoai xobo bochonon kaman joni icha weita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jatian ja chania beabo oinni jikixon apon meraa iki westíora joni jayakax fiestanko jikiti chopa sawéoma itina. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jatian apon yokata iki: ‘Joní ¿Jawekeskataxki ja jayá fiestanko iti chopa sawéomanixbi mia neno jikia?’ akin. Jaskáabi ja joni jawebi yoyo iama iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jaskaketian ja apon jawen yonotibo yoia iki: ‘Nato joni tanéxanan menéxkanwe, jaskáaxon nenoa pikoxon ja yaméain potakanwe, ja masá tenei winikin xeta kerox ati ikainko’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ichara ikanai ja kenakaatabo ikaxbi ja katokootabora ichama iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jato jaskáa pekáo boax *fariseobo tsinkíkana iki, jaskáaxon Jesús jakonmai yoyo imaxon jakopi ramianoxon shinan akí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jaskáaxon jaweti jaton joniboyabi Herodesnin jonibo raankana iki, jatian jabaon neskáakin yoikana iki: —¡Maestro! Nonra onanke minra ikon yoiai iki ixon, jainxonra akonkinribi ja Dios keenai keskati jati min jato onanmai. Minra ja jonibaon yoiai jawékibo chibanyamai, jato betan jakon inox mia iamai kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oinnon min shinanbiribi noa yoita. ¿Jakon o jakonmarin ja icha mai iboaa romamea apon yoiaibo senenhakin non kopíati? —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jatian jakonma shinanyaxon jaskáakanai onanxon jato Jesussen yoia iki: —¡Beparanmetaibo! ¿Jawekopiki maton ea jakonmain pakémakasai? ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jan apo kopíati koríki ea oinmakanta —akin jato aká iki. Jato jaskáa, bexonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jatian Jesussen jato yokata iki: —¿Tson bemanan jisárin itan tson janerin ja koríkiain akana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jaskáa yoikana iki: —Césarna riki —akin. Jatian Jesussen jato yoia iki: —Ja Césarnin jawékibo, César menikanwe. Jatian ja Diossen jawékibobiribi Dios menikanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jato jaskáaka ninkatax ikonbiresi ratékana iki, jaskaxon jatianbi jenebaini moa bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ja neteribira jaweti *saduceobo Jesússiba bekana iki, jabaonra mawatabo jiriti ikonhaayamakanai, jaskakinra Jesús yokákana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, Moiséssen esekanra yoia iki, westíora joni bakeaamabi mawáketian, ja kachianbaina ainbo jawen wetsan biti, ja jawen wetsa wayon bakeya imati kopí iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jatian noibara iká iki kanchis joni ja bakebires jaskara winoti, jaton rekenparira wanoaxbi mawata iki, jatian bakeamabi iká iketian, já pekao iká jawen wetsan ja kachiana ainbo bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jatian jara jaskashamanribi winota iki, japekaora ja kimisha itin iká jawen wetsa jaskáribi winota iki, jaskápatankaxonra ja kanchis wetsaxonbi ja ainbo awinhakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jatian moa jatikaxbi mawákana pekáo, ja ainboribi mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jaskara iken ja kanchisxonbi awinhakana iní ikaxmein ja mawatabo jiriketian ¿Tson awinshaman ja ainbo inoxiki? —akinra akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jaskáakana Jesussen jato yoia iki: —Matora jaimabires itai, ja wishakan yoiaibo onanyamaax, itan ja Diossen atipana koshiribi onanyamaa kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ja mawatabo moa jirikanketianra, benbobo wanoti itan ainbobo benoti moa yamanoxiki. Jabora naikanmea ángelbo keskábores moa inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Matonkayaki yoyo akama iki, ja mawatabo jiriti iken ja yoii Dios ikai ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ea riki Abrahamman Dios, Isaacnin Dios, itan Jacobnin Dios?’ iki. Jara mawábaon Diosma iki, ja riki jiriabaon Dios —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jato jaskáakin Jesussen yoia, jonibo ikonbiresi ratékana iki jawen esé ninkatax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jaskáketianra, ja *saduceobo Jesussen netémaa ninkatax, fariseobo tsinkíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jatian westíora kikinhakin esé onannaton Jesús tanakin yokata iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestró, ¿Jaweratokayarin japariakin senenhati joi esekan yoiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jaskáa Jesussen yoia iki: —‘Ja min Ibo Dios noiwe, jatíbi min jointiaxonbi, min kayayaxonbi itan jatíbi min shinanyaxonbi’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jariki ja rekenain iká itan japariakin non senenhati joi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jatian japekao iká riki, jaskataniribi; jara ikai neskati: ‘Minbix noikaata keskáribiakin wetsabo noiwe’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nato senenhati joi rabékira ike jatíbi esébo itan ja *profetabaon yoikatitai joibo koshii. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jatian jainbipari ja fariseobo tsinkíkana iketian jato Jesussen yokata iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Matonki ja *Cristo tsoa shinannai? ¿Tson bakemein itiki? —akin. Jatian yoikana iki: —Davidkan bake riki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jaskáakana jato Jesussen yoia iki: —¿Jaskara ixonbiki ja Diossen Shinanman imaa Davidkan, Ibó akin aká iki? David inike: ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Diossenra nokon Ibo yoia iki: ‘Nokon mekayao yakáwe, Ja min rawibo en min taenaman itiakin imaxonai kaman iki’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Jawekeskataxki ja Cristo Davidkan bake itiki, ja Davidkanbi Ibó akin akai ikax? —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jato jaskáaka tsonbi jawe joibi yoiamaa iki. Jatianbira moa jainxon tsonbi jawebi yokáwetsayamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jato jaskáa pekáo, jatíbi joniboyabiakin, jaonmea onannaibo Jesussen yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ja esé onanbo itan *fariseobo riki, ja Moiséssen aní esébo jaskati iká jato onanmaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaskara iken jato joi ninkáxonreskanwe, jainxon jatíbi mato yoikanaiboribi jato axonreskanwe; ikaxbi jabo ikai keskatires iamakanwe. Jabora jato jaskáakin eseibi, jaskati iamakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Atikomabires senenhati joibo akanai jato senenhamakaskin, wetsabo papimanoxon, kikinbires iwe jawéki tsinkikanai keskáakin. Ikaxbi jabaonribi senenhakinmabi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jatíbi jaton akaibo iki jonibaon oinnon iki ixon akanaires. Chopaki Diossen joi wishaxbo ikanai jan benexeeti, itan jaton poyainbo jan ponexeeti. Jaton tariribi akanai tapóshaman inon ixonbo chopan ketekiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tsinkíxon jawékiatiainko kaax ikanai, kikinbo yakatainkoshamanboribi yakámakantinin keeni, jainoax ja esé ninkáti xobo meran jikiaxbo ikanai rekenainshaman yakámakantininribi keeni. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jainoaxibi ikanai jonibaon bechixon jato saludankin, maestró akinshamanbo akantininribi keeni. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ikaxbi matobiribi, jonibaon maestró akin akantinin keenyamakanwe. Matora já wetsabobires keskábo ikax, westíora Maestroyabicho iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tsoa jonibi nato mainxon papá akinbo ayamakanwe, westíora papayabichoriki mato, já riki ja naikan iká Dios. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jainoax maestro akin mato akantininribi keenyamakanwe. Matora westíorabicho maestroya iki, jariki *Cristo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ja mato xaranmea jan mato xewina jonira iti jake, wetsabo jato jawéki axonai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ja jatonbinix kikinman shinanmeetaibora, jawemabiakin oinkanti jake, jatian ja jawemabitonin shinanmeetaibora, kikin joniakin oinkanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jawe iresaipanon, ja *fariseoboyabi esé onanbo, mato riki beparametaibores. Matonra akai ja wetsabo jato Diossen ikinti netenko jikikanti ikenbi, jato xepóti xeponaanreskin. Matoribi jikiamai itan ja jikikasaiboribi maton imayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparametaibores. Matonra akai ja benomaata jaton xobon jayatashokobo jato bichinkin, jaskáax paranakin akai maton nenké oraciónbo akin. Jato jaskáai kopíra maton bebonbires masá tenenoxiki ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparametaibores. Matora ikai ochóbi jatíbiainbo kaai, westíora jonitanibires maton esé jato ikonhamakasi, jatian moa jato ikonhamaxonra, mato xewina jakonmabires maton jato imai, jatiankaya moa chiikan ewa meran katiresbo itiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Jawe iresaipanon, mato riki benchebo ixonbi jato ikinkasaibo! Maton yoiai: ‘Tsonki ja Diossen xobo janebainhanan jawéki ati yoiai, jara senenhayamaabi jawemabi iki ixon, ikaxbi ja Dios rabiti xobo meran iká oro janebainhanan ati yoiakaya iki ja akonkin senenhati, ixon’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Kikinshaman onanma itan benchebo riki mato! ¿Jawekayaki bebon jakon iki, ja oro, ó ja oro jan Diossena imai, *Diossen xobo? ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jainxon maton yoiribiai: ‘Tsonki ja jainxon Dios yoina menoxonti janebainhanan jawéki ati yoiai, jara senenhayamaabi jawemabi iki ixon. Ikaxbi ja jainxon Dios yoina menoxontiainko, ja Dios menikana jawéki itina janebainhanan ati yoiakaya iki, akonkin senenhati ixon’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Benchebo! ¿Jawekayaki bebon jakon iki, ja Dios menikana ó ja Dios menikana jan jakon imai jainxon yoina menoti? ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ja jainxon yoina Dios menoxonti janebainhanan jawéki anox yoyo ika joninra, jabicho janeyamake. Janra jatíbi ja Dios menikanayabi moa janeke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jatian ja Diossen xobo janebainhanan jawéki anox yoyo ika joninra, jabicho janeyamake. Janra ja jameran já Diossibi moa janeke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jatian ja nai janebainhanan jawéki anox yoyo ika joninra, jabicho janeyamake. Janra moa Diossibi janeke, naikan jawen yakáti iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparanmetaibores! Matonra akai ja mentankonia, aníssainoa itan ja comino maton tsekaa, chonkankoniabo westíorabo Dios menikin. Ikaxbi ja esé meran iká kikinshaman ja senenhati joikaya maton senenhayamai. Ja iki, itibi keskati jati, noixon jato jatíbinin akinti itan Diossen yoiai keskati jati. Jakaya riki ja wetsa jawékibo aríbakinbi maton senenhati. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Mato riki benchebo ixonbi jato ikinkasaibo! Matonra akai nakayabi xeanaketian akamabipari toakin, ikaxbi ja ani camello xeati meran itinakaya maton xeai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparametaibores. Matonra akai jawen pekainres ja rato betan vasobo chokakin. Ikaxbi maton shinan merankayara bochoke, ja maton yometsoxon bia jawékibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo benchebo! Rekenparikaya ja vaso napo iká kerásbo chokakanwe, jatianra ja vaso pekainribi moa kerás yamati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparanmetaibores ikax, ja mawá kini joxoakin sikakana keská, bebires jakonhira. Ikaxbi chichó iki, ja mawá xaoyabi meskó kerás jawékibo bochoa. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaskara riki mato; oinkana jakonhira joni keskabo, ikaxbi chichókaya beparametaibo itan jakonma shinan bochoyabo ikaxbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jawe iresaipanon, ja fariseoboyabi esé onanbo, mato riki beparametaibores. Matonra akai ja *profetabo mawáni shinanoxon *monumentobo akin, itan ja jakon joni mawata miinkana kiniboribi akai maton raoaxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jaskáaxki mato ikai: ‘Noaribi ja non rekenbo betan senen japaoni ixonra, ja *profetabo retekanaitian non ayamakeana iki, ikibo yoyo iki’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jaskatibo yoyo ikinra moa maton onanke, mato riki ja *profetabo jan retekatitaibaon chiní bakebo ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jaskara ixon, ja maton rekenbaon akin peonikaya senenhakai kaman chibanreskanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mato riki, jakonmabo ikax rono kaita keská jonibo ¿Maton jisáki ja chiikan ewa meran mato kayamanoxiki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Enra mato raanxonoxiki, *profetabo jainoax nokon joi onanna jonibo itan jan mato axeatibo. Ikaxbira maton jato retenoxiki, jatíribibora maton jato korosen anóxiki, jatian wetsabora ja esé ninkáti xobo meranxonbo maton jato rishkinoxiki, jemabotiibira benaananbo maton jato ramianoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaskara ikenra jatíbi jakon jonibo retekana kopí, mato Diossen castiganoxiki. Ja Abel retekani kopí itan ja senentiainbi ja Diossen xobo meran iká jainxon Dios yoina menoxonkanai naxaranxon ja Beriquíassen bake Zacarías maton reteni kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ikonshamanra en mato yoiai: Nato jawékibo kopíra, mato jatíbi Diossen castiganoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Jerusalén jonibo, Jerusalén jonibo! Mato riki ja *profetabo itan jawen joi yoiti Diossen raana jonibo makanman tsakaanan jato reteaibo. Ichaakinra en mato tsinkianan ikinkaske, atapanin jawen bakeshokobo jawen pechi meran axon koirannai keskáakin. Ikaxbi mato keenyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jaskara ikenra, ja Diossen xobo, moa potá xobo keská inóxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jatianra en mato yoiai: Ramara jawetianbi maton ea oinwetsayamanoxiki, ‘Miara non jowé akai, mia riki ja Ibon janenko joái’, iki mato iti senenai kamanpari”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ja moa Diossen xobo meranoax Jesús pikókaini kaaitianra, jaonmea onanaibaon nokobainxon ja Diossen xobo metsáshaman itina oinmakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jatian Jesussen jato yoia iki: —¿Matonki oinna nato xobo jaskáakinshaman akana? Enra mato ikonshaman yoiai, westíora makan texea wetsa makanki perakaatanibobira yamanoxiki, keyora ras anóxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jato jaskáa pekáo, olivos mananman bokana iki, jain kaax Jesús yakata iki, jatian moa jabicho iketian jaonmea onanaibaon nokobainxon yokákana iki: —Jawetianshamankayaki jaskarabo iti iki ixon min yoitininra noa keenai. Jainoax ¿Jaweki inoxiki ja mia joti ochama itan moa nete senenaitian non ja oinxon onantibo? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jaskáakana jato Jesussen yoia iki: —Koirameekanwe mato tsonbi parankantima kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ichara benóxikanai eki yoinmeetax, ‘ea riki *Cristo’, iki ikaibo, jaskáakin yoixonbora jato icha paranoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Matonra ninkánoxiki wetsanko, wetsankobo reteanankanai. Ikaxbi ratéyamanoxikanwe; jaskarabo ikíbira nete senenamapari inoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jonibora wetsa mainmea jonibo betan reteananoxiki, jatian apobora wetsa mainmea apobo betan reteananoxiki, jonibora jawékiatinin inoxiki, jainoax jatíbiainra ani niwanbo inoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ikaxbi jaskarabo ikaira itiki, moa masá tenetibo iki peokootaipari. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Matora yatanxonbo joni koshiboibabo bonoxikanai ramianoxon, jaskáaxonbora mato retenoxikanai. Ea chibanaibo iketianra jatíxonbi mato omísnoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jatianribira ichaxon ea ikonhakin jenenoxikanai. Jakonhai keská ixonbora, jato ramiakanti jake, jaskatira omisananoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Icha ikonma *profetabora pikónoxikanai. Jabaonra icha joni parannoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jatian moa iorai jakonma jawékibo kaita ikenra, icha jonibaon noimisti shinan keyónoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ikaxbi ja nete senenai kamanbi eki koshii jenéyamaiboresa, kishpinmeenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja Diossen ikinaton jati jakon joira, jatíbiainpari yoikaati jake, jatíxonbi onankana iti kopi, jatianparira moa nete senenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jawetianki ja Diossen xobo meran, jakonmabires jawéki akanti ja *profeta Danielnin yoini keská akanai maton oinnai (yoyo axon onankanwe). ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jatianra ja Judea main ikabo, jabati mananman bokanti jake, ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","jatian ja jaton xobo pekaten itinabora, jaton jawékibo bikasi moa naman jotima iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","jainoax ja jaton wainko bokanabora, jaton chopa bikasi xobon jakiribi jotima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Jawe iresaipanon! Ja tooyabo itan bake maxkoya ainbobora ikonbiresi onitsapinoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dios yokákanwe ja mato jabati katira, oitian iamax tantiti netenbi inake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Akonbireskin masá tenetira inoxiki ja neten. Tsonbira nato nete peokoonontian itan ramakamanbi jaskáakinhora masá teneama iki itan jaskáakin masá tenetiribi moa yamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jatian jaskáakin masá tenetibo basiora Diossen imaabira, jatikaxbi mawákanti iki. Jakopíra jawen katotabo noia ixonres, basima neteres imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ja netebaon tsonbires mato atiki: ‘Oinkanwe, neno riki *Cristo’, iamaxon ‘oa riki’, akinbo yoikin, jato ikonhayamanoxikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ikonma Cristobo itan ikonma *profetabora bekanti jake. Jabaonra ja oinxon onanti itan ani ratéti jawékibo anoxikanai, jaskáaxon ja Diossen katotabobi jato paranti shinanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Koiramekanwe, jaskarabo ikámatianbira en moa mato yoike. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaskara iken, ‘Cristora jain joni jayamainko itinke’, akin mato akana, jain kayamanoxikanwe. Jainxon, ‘Cristora xobo chicho joneta itinke’, akin mato akanabi, ikonhayamanoxikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ja kaná chopékin, bari pikotaiorixon bari kaaiori tenai non oinnai keskára inoxiki ja jonin Bake joí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jaweranoki westíora mawá iki, jainra jaskara piai noyai yoinabo tsinkitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jaskara masá tenetibo winota pekáoshokobira, moa bari nokanoxiki, oxénribi moa teneyamanoxiki, ja naikan iká wishtinboribi maannoxiki, jatíbi ja naiori iká koshi jawékiboribi shakónoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaskataitianra oinnoxikanai ja jonin Bakera moa joái ixon, ja oinxon onanti naikan ikaitian. Jaskataitianra jatíbi nato main já jonibo raketi winiananbi yoyo inoxikanai, ja jonin Bake jawen atipana koshia, itan penébires moa naikoinman joaitian oinnax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jatian janra jawen ángelbo raanoxiki, kikin koshin trompeta xoon akatoninres, jatíbi jawen katotabo mai senenainoabi jato tsinkiti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ja higo jiwi riki maton jainxon onanti. Jawetianki jawen ponyanbo jakonax, moa jawen peibo pechokoai, jatian maton onanai moara baritiati ochóma iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaskáakinribi ja meskó jawékibo ikaitian oinxon, onanoxikanwe ja jonin Bake moa joti ochóma. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ikonshamanra en mato yoiai: jatíbi nato jawékibora inoxiki seneni ja ramatian jakana jatíribi jonibo mawatamatianbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ja nai betan maira keyónoxiki, ikaxbi ja nokon joibora, winóyamai senenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ikaxbi ja nete itan ja hora jotira tsonbi onanyamake. Nin ja naikan iká ángelbaon itan ja Bakenbira onanyamake. Nokon papa Diossenbichoresa onanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ja Noé inontian ikáni keskáshamanribira inoxiki ja jonin Bake moa jakiribi joaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ja jenen ewa beamapari inontianbi peokootaxa, moa Noé wapóro meran jikiai kamanbi, jonibo iká iki pii itan xeai, jainoax wanoi itan benoibores. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jatian tsonbi jaskara iti shinannamabires ikenbira, jenen ewa bexon jatíbi jato keyoa iki. Jaskáribira inoxiki ja jonin Bake moa jakiribi joaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ja neten rabé joni wainko teeti iibekonaitianra, westíorares boti iki, jatian wetsa botima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rabé ainboribi itiki renei iibekoni, westíorares boti iki, jatian wetsa botima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jaskara iken benxokaatax manákanwe. Ja netenshaman maton Ibo jotira maton onanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Shinankanwe, westíora jonira, ja horashaman yamé yometso joái onanax oxatima iki. Jaskáaxonra ja yometso jawen xobo meran jikimatima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaskara iken matoribi benxokaata ikanwe; ja jonin Bakera jonoxiki tson shinannamatian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jawen tee akonkin senenhai shinanya yonotira, jawen ibon jaki jenekin yoibainai, jawen xobon ikábo jato ikinti itan jato jawékiamati. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Diossenra raroshaman imati iki jawen ati teebo senenhai iitaitian joxon ja yonoti jawen ibon nokoketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Enra mato ikonshaman yoiai: Jara jawen ibon jatíbi jawen jawékibo koiranon ixon jaki jeneti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ikaxbi ja yonoti jakonma ixon atiki, nokon ibora ishton joyamai ixon shinantaanan, ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","jan jato ikinna ja wetsa yonotibo jato jakonmaakin peokin, jainoax paenai jonibo betan jikiax jato betanres xeai, itan jato betan jawékiaibores ikí. ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jaskatibores iitaitianra ja nete itan ja hora joti shinannamainbires joxon, jawen ibon, ");
INSERT INTO shpNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ja beparanmeetaibo ati keskáakinribi castiganoxiki. Jatianra akonbireskin masá tenei xeta kerox aki winiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ja Diossen ikinaton jati netera inoxiki, ja chonka xontako jaton lamparin bitaanan ja wanoai joni manai boax ikáni keskáribi winoti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichikara ikana iki, shinanti onanmabo, jatian pichikaribi ikana iki shinanti onanbo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ja pichika shinanhomaninra, lamparin bokinbi, keyóketian jakiribi nachíti xeni boyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ikaxbi ja shinanyabaonra, lamparin boribakinbi, xeniribi bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jatian ja wanoai joni ishton joyamaitianra, oxakan jato atimaana, jatikaxbi oxakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jatian moa yamé pochínikon ninkákana iki: ‘¡Jainra moa wanoai joni joái bechii bekanwe!’ iki saí ikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jaskákanai ninkatax jishtenxon, jatíbi xontakobaon jaton lamparinbo jakonhakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jatian ja pichika xontako shinanhomabaon akana iki ja shinanya xontakobo yoikin: ‘Non lamparinbora moa nokaibishoko iki, maton xeni ichatamashoko noa menikanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ikaxbi ja shinanya xontakobaon jato yoia iki: ‘Mato meniaxbira noaribi maxkátiki, jakonra itiki, ja maroaiboiba kaxon matonabiribi itiakin maton biá’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ikaxbi ja pichika xontako xeni marokin bii bokana pekáora, ja wanoai joni nokota iki. Jatian ja benxokaata iká xontakobores wanoti fiestanko jabébi jikikana iki. Jatian moa weíkanketian xepótiribi xepota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jaskata pekáora ja wetsa xontakobo nokótoshitax, ‘¡Ibó! ¡Ibó! Noa xepóti kepenxonwe’, iki itoshikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ikaxbi jan jato yoia iki: ‘Enra mato onanyamake, tsoara mato ibirai akinres’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jaskara iken; benxokaatabo ikanwe. Matonra ja nete itan ja horashaman ja jonin Bake jotiki onanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ja Diossen ikinaton jati netera inoxiki, ochó kanoxon westíora jonin jawen yonotibo kenaxon koirankanon ixon jato koríki menipakeni keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Westíora menia iki, pichika waranka, wetsa menia iki, rabé waranka; jainxon wetsa menia iki westíora warankares. Jatí ichares westíoraxonbo koirankanti jisábo onanxonra jato menipakea iki. Jaskáatanan moa ochó kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jan pichika waranka bia joninra, ja koríkinin teexon wesa pichika warankaribi bia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jatian jan rabé waranka biatoninribi jaskáashokoa iki. Janribi wetsa rabé waranka bishokoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ikaxbi ja westíora waranka biatoninra, kaxon mai chinianan mai chicho ja koríki miinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Basi iiti ja ochó kayantana joni joá iki. Joxonra jawen jonibo yokápakea iki, jaweki ja koríkinin akana ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Rekempari joá iki ja pichika waranka jan biantana, joxonra wetsa pichika warankaribi menitoshita iki. Jainxon yoia iki: ‘Ibó, minra ea menia iki pichika warankares, natora wetsa pichika warankaribi en mia meniai, ja riki en kaimaa’, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jatian ja jonin yoia iki: ‘Jakonra min ake, miara jakon itan miki koshiti joni iki, ja ichama min jakonhakin aká kopíra, rama bebonbires icha en mia koiranmai. Rama ebé raroi jowé’, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ja pekao, joá iki ja rabé waranka koríki jan biantana joni, joxon yoia iki: ‘Ibó minra ea menia iki rabé waranka koríki, natora wetsa rabé warankaribi en mia meniai, ja riki en kaimaa’, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jatian ja jonin yoia iki: ‘Jakonra min ake, miara jakon itan miki koshiti joni iki, ja ichama min jakonhakin aká kopíra, rama bebonbires icha en mia koiranmai. Rama ebé raroi jowé’, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ikaxbi ja westíora waranka koríki biantana toninbiribi joxon yoia iki: ‘Ibó, enra onanna iki, jain banaa ixonmabi jainoa bikaskin min jato yokákin teai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja kopira, rakékin ja min koríki en kaxon mai meran jonea iki. Ikaxbi nato riki ja min koríki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jaskáa, ja jonin yoia iki: ‘Mia riki jakonma, itan chikish joni. Ja jain banaa ixonmabi jainoa bikaskin en jato yokákin teai onanna ixonra, ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","iká iki, ja koríki min banco meran niati. Jatianra moa joxon ja nokon koríki kaita en bikeanke’, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jaskáatanan jawen jonibo yoia iki: ‘Ja westíora waranka koríki bichinxon, ja chonka waranka koríkia joni menikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ja jakonhakin akára, bebonbires non meniti jake ibanon ichaya iki ixon. Ikaxbi ja jakonmaakin akára, ja jayatabobi non keyo bichinti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jatian ja nato jakonma yonoti, jemaori boxon yamé meran potakanwe, ja xeta kerox aki winiti ikainko’, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ja jonin Bakera, jatíbi jawen ángelboya penébires joáx, jawen penébires yakátinin yakánoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Já bebonra jatíbiainoa jonibo tsinkinoxiki. Jatian janra jato katópakenoxiki, ja oveja koiranaibaon cabrabo betan imayamakin ovejabo katotai keskáakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja ovejabora jawen mekayao jato imanoxiki, jatian ja cabrabora jawen mexkao jato imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jatianra ja apon jawen mekayao ikábo jato yoiti iki: ‘Matobo neri bekanwe, nokon Papanra mato jakon imake. Ja nato nete jonianontianbi, matonribi Dios betanbi jainxon jato ikinti nete axona, iboakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Matonra ea pikasaitian ea pimaa iki. Ea nomiaitian maton ea xeamaa iki. Ea wetsanko iketian maton xobon ea maton imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ea chopaoma ikenbi maton ea chopa menia iki. Isinaitian, maton ea koirana iki. Cárcel meran iketian, ea oinni mato kaa iki’, akin jato atiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jatianra ja jakon jonibo ikanti iki: ‘¿Jawetianki, mia pikasai oinxon non mia pimaa iki, Ibó? ¿Jawetianki, mia nomiaitian oinxon non mia xeamaa iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jawetianki wetsanko kaa iketian oinxon, non xobon mia non bia iki? ¿Jawetianki chopa keyota oinxon, mia non chopa menia iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jawetianki, isinai oinxon non mia koirana iki? ¿Jawetianki, cárcel meran iketian oinnax mia oinni noa kaa iki?’ iki ikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jatianra, ja Apon jato yoiti iki: ‘Ja nokon wetsabo, kikinmashoko shinankanaibo akinkinra, maton ea moa akinna iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Japekáora, ja mexkao ikábobiribi jato yoiti iki: ‘¡Eibakeax botankanwe, jakonmabo. Ja yoshinbaon koshi itan jawen yonotibo axona, jawetianbi nokayamai chiikan ewa meran botankanwe! ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Matonra ea pikasainbi ea pimayamaa iki. Ea nomiainbi maton ea xeamayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ea wetsanko kakenbi, maton xobon ea maton biamaa iki. Ea chopaoma ikenbi, maton ea chopa meniamaa iki. Ea isinainbi itan ea cárcel meran ikenbi, ea oinnitani mato kayamaa iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jatianra jabaon akanti iki: ‘Ibó, ¿Jawetiankayaki mia pikasai non oinna iki, mia nomiaitian non oinna iki, mia wetsanko kaa non oinna iki, mia chopa keyota non oinna iki, jainxon isinainbi itan cárcel meran ikenbi mia non akinyamaa iki?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jatianra, ja apon jato yoiti iki: ‘Ja nokon wetsabo, kikinmashoko shinankanaibo maton akinyamaara, maton earibi akinyamaa iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaskara jakonma jonibora, jatíbitian masá tenetiain bokanti jake. Jatian ja Diossen yoiai keská ikábora jatíbitian jati netenkobiribi bokanti jake —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jatian moa jato joi yoikin senenhataanan, jaonmea onannaibo Jesussen yoia: ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Matonra onanke, ja rabé nete pekáo moa *Pascua fiesta ikai. Jatianra ja jonin Bake yataanan ramiayonxon korosen axon retenoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jatianribi iká iki, ja sacerdotebaon koshibo betan ja judíobaon joni koshibo, ja *sacerdotebaon koshi Caifás jain iká xobonko tsinkíkana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jainxon shinankana iki, paranhanan yatanxon Jesús reteti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ikaxbi jatíribibo ikana iki: —Ja *Pascua ikaitianbiora atima riki, sinatira jonibo tsokáskanake —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jatian Jesús iká iki Betania jemanko, ja *lepra isinya ikátiai Simonman xobonko. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jain pii yakáketianra, westíora ainbo nokótoshita iki kopí ininti tsomáya. Joxonra, pataxbainxon ja inintinin Jesús machita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jaskaaka oinnax, jaonmea onannaibo ikana iki ikonbiresi sinati neskati: —¿Jawekopiki, nato ininti jaskáakin yoyota? ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jakayara ike kikinshaman kopí maroxon, ja jawékiomashokobo jato akinti —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jaskákanai onanxon, jato Jesussen yoia iki: —¿Jaweakiki nato ainboki mato sinatai? Janra jakon tee ea axonke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ja jawékiomabora, jatíbitian mato xaran janoxiki, ikaxbi eara jatíbitian mato betan iamai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nato ainbaon ea inintinin jaskáa riki, jayá ea miinkanon ixon aká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Enra mato ikonshaman yoiai: Nato netenxonra, jatíbiainxon jakon joi yoikin, nato ainbaon ea jaskáani yoinoxikanai ja shinankin —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jatian ja chonka rabé jaonmea onannaibo ikainoa, westíora Judas Iscariote janeyara, *sacerdotebaon koshibo oinni kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kaxon jato yoia iki: —¿Jawetiishamanki maton ea kopíatiki, en mato Jesús yatanmaketian? —akin. Jatian jabaon shinan axon, kimisha chonka koríki menikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jatian jaskáakana, moa jaskáaxon jato Jesús yatanmati Judassen benaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ja moa fiesta peokootaitian, *levaduraoma aká pan pikanai reken netera, jaonmea onanaibaon Jesús yokákana iki: —¿Jaweranoshamanxon, ja *Pascua iketian, non jawékiati aká yantan pitinki mia keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jatian Jesussen jato yoia iki: —Jerusalénhain botankanwe, ja en mato janexona jonin xobonko. Kaxon yoitankanwe: ‘Moara nokon nete ochóma iki, jakopira ja eonmea onannaibo betan min xobonkoxon en jawékiakasai *Pascua iketian, ikira non Ibo ike akin atankanwe’ —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jato jaskáa boxon, jaonmea onanaibaon ja Jesussen jato yoia keskáshamankin akana iki. Jainxon ja *Pascua iketian yantan jawékiatiribi akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jatian moa yaméketian, Jesús iká iki jawen chonka rabé jaonmea onannaibo betan pii mesan yakata. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jain pii yakáxonbi, jato yoia iki: —Ikonshamanra en mato yoiai: Mato westíoraxonra jakonhai keská ixonbi ea jakonmaati jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jaskáakin yoia, jawen jonibaon akonbireskin masá shinankana iki. Jatian, westíoraxonbo yokákana iki: —¿Ea yoiiki mia iká Ibó? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jaskáa jato yoia iki: —Ja en piai ratomearibi piai riki, ja jakonhai keská ixonbi ea jan jakonmaati. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ja jonin Bakera, jaskara iti wishakan yoiai keská winóti jake. Ikaxbi jawe iresaipanon, ea jakonhai keská ixonbi ea jan jakonmaakai. Jakonra ibirakeanke ja jonikaya, jawen tita meranoax pikóyamaa —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jatian jankaya jakonhai keská itaanan jakonmaati ixonbi, Judassen aká iki: —¿Ea yoiiki mia iká Maestró? —akin. Jatian Jesussen yoia iki: —Minbira moa yoike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jatian pii ikanaitian, pan bitaanan, Jesussen Dios iráke aka iki. Jaskáaxon ja pan tobapakeanan jato menikin ja jaonmea onannaibo yoia iki: —Bixon pikanwe; natora nokon yora iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Japekao, xeatia kenporibi bixon, Dios iráke aka iki, jaskáatanan jato menipakekin yoia iki: —Jatíxonbi ja nato kenpomea xeakanwe, ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","jara nokon jimi iki, janra ja senenhabekonti joi Diossen aká onanti imai. Ja jimira chikotai icha jonibaon ocha, moa Diossen shinanxonyamanon ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nato akinbichora en mato betan nato vino xeai. Ikaxbi jawetianki ja nokon Papan noa ikinai neten noa jatikaxbi tsinkíkanai, jatianparira ja bená vino non xearibinoxiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jaskatax moa *salmosbo bewai senentaanan, Olivos mananman bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jainxon jawen jonibo Jesussen yoia iki: —Nato yaméra mato jatikaxbi eki koshiamanoxiki. Jaskáti yoiira wishá meran ikai: ‘Jan oveja koiranaira en retenoxiki, jatianra ja ovejabo janbísti jake iki’. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ikaxbi moa jiritaananra, mato kaamabi eapari Galileanko kanóxiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jaskataitian, Pedron yoia iki: —Jatíxonbi miabicho potakanainbira, en mia potayamanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jatian Jesussen neskáa iki: —Ikonshamanra en mia yoiai: Nato yaméra, atapa keotamabi ea yoii kimishai enra onanyamake iki mia inoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jaskáa, Pedron yoia iki: —Ea mibébi retekanti ikenbira, jawe ikaxbi enra já onanyamake iki ea iamanoxiki —akin. Jatian jatíribi jaonmea onanaibaonribi jaskáakin yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Japekao, jaonmea onanaiboya Jesús Getsemaní janeya wainko kaa iki, jainxon jato yoia iki: —Nenobipari yakákanwe en ono kaxon oranai kaman —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jaskáaxon, Pedro betan Zebedeon bake rabéres ioa iki. Jainoaxa ikonbiresi oniskin masá shinankin peoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jainxon jato yoia iki: —Nokon shinan meranra ea ikonbiresi onisai mawákasnon kaman. Nenobipari ikanwe, ebébi oxá tenekanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jato jaskáabaini orichaashoko kaax, jawen betonkoninbi mai tii akai kaman chirankootanan neskáakin orana iki: “Papá, min keen iketian, ea masá tenemayamawe. Ikaxbi nokon keena keská ea axonyamawe. Min keena keskáres awé”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jaskataanan, jaonmea onannaibo ikainko joríbaxon, oxakana jato nokoa iki. Jainxon Pedro yoia iki: —¿Westíora hora tanibireski maton ebé oxá teneti atipanyamaa? ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Oxayamakinkaya orankanwe, tanakaati joketian maton teneti kopí. Maton shinanra jakon akasai, ikaxbi maton yorara yosma iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jainoax jakiribi karibaxon neskáakin orana iki: “Papá, jaskáshamanhaxon nato masá en teneti bechitentikoma iketian, min keena keskáres awé”, akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jaskáakin oranbeirani joxon, jakiribi oxakana jato nokoribia iki. Jaton berobo ikana iki oxakan ayora bero pexmashokobo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jaskara ikanaitian jato oinbainresi kaxon, moa kimisha itin ja awana keskáakinribi orana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jaskáatanan jaonmea onannaibo ikainko joxon jato yoia iki: —¿Ramakamanbikayaki mato tantii oxa oxaresai? Moara ja jonin Bake ochayabo yatanmakanti hora senenke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Weníkanwe, moa noa bokanon. Jan ea jakonhai keská ixonbi ea jakonmaakai jonira, moa jain joái —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jato jaskáakin yoii iitainbi, Judas nokótoshita iki. Ja iká iki westíora Jesussenmea onanairibi. Jabéra icha joni bekana iki, espadayabo itan jiwiabo. Ja bekanabo iká iki, *sacerdotebaon koshiboyaxon ja jema koshibaon jato raana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jatian jakonhai keská ixonbi, jan jakonmaakai Judassen iká iki: “Ja kaxon en bexetaira já iki, ja yatannoxikanwe”, akin moa jato yoia. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jaskara ixon, nokobainxon Jesús aká iki: —¿Miaki jawekeska iki maestró? —akin. Jaskataanan bexeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jatian Jesussen yoia iki: —Jaskara akí mia joákaya, ishtontani awé joní —akin. Jaskáaketian, nokobainxon jonibaon Jesús yatankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jaskáakanaitian, westíora Jesús betan itinaton jawen espada tsekataanan, ja *sacerdotebaon koshín yonoti rerakin paxtea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jaskáaketian, Jesussen yoia iki: —Ja min espada moa benxoawe. Ja espadanin jato reteaibora, espadaninribi retekanti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Minki onanyamaa, ea jaweayamakanon ixon ja nokon Papa en yokáketian ramabishoko kikinbires icha ángelbo ea jan raanxonti? ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ikaxbi en jaskáakabira, jaskara iti wishakan yoiaibo senentima iki —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jaskáatanan, ja jonibo Jesussen yoia iki: —¿Jaweakiki ja yometsobo atin ea yatani mato espadayabo itan jiwiabo bekana? Netetiibira, jato axeai ea Diossen xobo meran iká iki. Jatianra jawetianbi maton ea yatanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ikaxbi nato jawékibora ike ja *profetabaon yoini joibo senennon ikax —akin jato aká iki. Jatianra jaonmea onanaibaon, moa jabákin jatíxonbi Jesúsbicho potabainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jatian jan Jesús yatannabaonra, sacerdotebaon koshi Caifássen xobonko bokana iki. Jain ikana iki ja esé onanboyabi jema koshibo tsinkíkana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ikaxbi Pedrobiribi ochóxonres chibanboi kaax, ja sacerdotebaon koshin xobo jema ikain nokota iki. Jain nokotax ja xepóti koiranaibo betan yakata iki, Jesúsmein jaweayonkanai ixon oinnox. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jatian ja sacerdotebaon koshi itan ja jema koshibaonra jaskáaxon Jesús reteti kopí janso joi benakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ikaxbi, icha joni joxon jansokin jakonmaakinbo yoikanabi, atikoma iká iki. Ikenbi, rabé joni joxon, ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jato yoia iki: —Nato jonira iká iki: ‘Enra ja Diossen xobo ras axon, jakiribi kimisha netebi aríbatiki’, iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jaskáaketian, wenítaanan ja sacerdotebaon koshín yoia iki: —¿Minki jawebi yoiamai? ¿Minki ninkata mia jaskati iká yoikanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jaskáabi Jesussen jawebi yoiamaa iki. Jaskaketian ja sacerdotebaon koshin aká iki. —Ja jatíbitian jiria Diossen janenko noa yoita. ¿Miarin ja Diossen bake *Cristo? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jaskáa, Jesussen yoia iki: —Eara jaakon iki, minra moa yoike. Jatianra en mato yoikasai: Basimara maton oinnoxiki ja jonin Bake, jatíbi atipana koshia Diossen mekayao yakata, itan nai koinman joaitian —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jaskáketianra, ja sacerdotebaon koshin jawen chopa noshia iki sinákin. Jaskatax iká iki: —Dioskira jakonmaibires yoyo ike. Wetsabo yokátininra moa noa maxkáyamake, matonbira ninkake jaskati yoyo ikaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jawe keskaki maton shinannai? —iki. Jatianra ikana iki: —Reteti riki —iki saa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jatian jatíribibaon betoshba ataananbo timakana iki. Jatian wetsabaonra, tantash axonbo, ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","akana iki: —Ikon Cristo ixon, onanta tsonki mia tantash aka —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jatian jaskákanai kamanbiribi, Pedro iká iki jeman yakata. Jain itinketianra, westíora jaton yonoti ainbaon nokóxon yoia iki: —Miaribi riki ja Galileankonia Jesús betan ipachoai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ikaxbi jain itinabo bebomeax, paranai, Pedro iká iki: —Enra onanyamake, tsoa yoiira mia iibirai —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jaskátaanan xepótiain kaa iki. Jainoara ja wetsa yonokanai ainbaon oinxon ja jain ikábo yoia iki: —Natoribi riki ja Nazarethainoa Jesús betan ipachoai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jato jaskáaitian, onanaxbi jakiribi, ikonkon enra ja joni onanyamake iki Pedro iribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jato jaskáa basimabi, jain ikábaon pataxbainxon Pedro yoikana iki: —Ikon riki mia jawen joni, mia yoyo ikara onantibires iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jatianra jakonmaibires jaki yoyo itaanan Pedro neskata iki: Enra jawekeskaxonbi ja joni onanyamake iki. Jaskati yoyo ikainbi, atapabene keota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jaskáketian, Pedron shinanria iki: “Ja atapabene keotamatianbi, kimishai paranati”, Jesussen yoiwana. Jaskáakin shinannax, jeman pikókaini kaax, akonbireskin masá shinanni Pedro winia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jatian moa nete xabáketian yamékirishoko, jatíbi *sacerdotebaon koshibo itan ja jema koshibaon shinankana iki jaskáaxon Jesús reteti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jaskáaxon, menéxanan boxon, ja romamea joni koshi Pilato menikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jatian moa Jesús retenoxon shinankana onanaxa, jakonhai keská ixonbi jan jakonmaa ikax, Judas ikonbiresi shinanmeeta iki. Jaskákinra ja *sacerdotebaon koshibo itan ja jema koshibo, ja kimisha chonka koríki jato banexonribaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jato yoia iki: —Eara ochake, retekanon ixon jakonma akáma joni jato yatanmaax —akin. Jaskáketianra: —¿Nonki jawe ointi ja? Jara min ointi jawékibiribi iki —akinres akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jaskáakin akanara, Diossen xobo napobi janbisbaintiakin Judassen koríkibo potaa iki. Jaskáabaini kaax, risbikan tenexetax mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jatian ja *sacerdotebaon koshibora ja koríki biax neskákana iki: —Nato koríkira joni retekanaton kopí iki. Jara ja Dios menikana koríki betanbi non meskoti atipanyamake —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jaskáaxon shinankana iki, ja mapokan teetaitonin wai akin akanai mai, ja koríkinin maroti. Jain ja wetsankoniax beax mawatabo jato miinti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja kopira, rama kamanbi ja mai janekanai, Jimi Mai akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaskataxa, senena iki ja *profeta Jeremíassen yoini: —Ja kimisha chonka koríkira biríbakana iki. Jatíra iká iki ja joni kopi jato *Israelitabaon kopí yokata, ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bixonra, ja mapokan teetaitonin wai akin akanai mai, ja koríkinin marokana iki, ja Ibon ea jaskáati yoia keskáshaman —iki yoyo ini. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús iká iki Pilato bebon boxon nichinkana. Jatian jan yokata iki: —¿Miarin ja judíobaon apo? —akin. Jatian Jesussen yoia iki: —Minra moa yoike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jatian ja *sacerdotebaon koshiboyaxonbi *ancianobaon jakonmaakinbo yoikanabi, Jesussen jawebi yoiamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jaskataitian Pilaton yokata iki: —¿Minki ninkáyamai, ja mia jakonmaakinbo yoii ikanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jábi Jesussen jawe joibi yoiamaa iki. Jaskataitian ja joni koshi ikonbiresi rateta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jatian ja joni koshin axé iká iki, *Pascua fiestatiibi, westíora preso jonibaon katota jato pikoxonti. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jatianribi iká iki, westíora ninkakaatai joni Barrabás jeneya, cárcel meran akana. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jatian jain tsinkíkana jonibo, jato Pilaton yokata iki: —¿Tsoa en pikotininki mato keenai: Barrabás ó Jesús, ja Cristo akin maton akai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jaki notsireskin yataanan já bexonkana iketian onanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jatian jainxon joi benxoatiainko Pilato yakáketianra jawen awinin joi bomaa iki: “Ja jakon joni betanra min jawe ointi yamake. Já jaskáakanai kopíra en jakonmabires namáwanke”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ikenbi, ja *sacerdotebaon koshiboyabi ja jema koshibaonbiribi, ja joni icha tsinkitabo yoixon jen imakana iki, Barrabás pikotaanan Jesúsbiribi reteti, Pilato yoikanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jaskáketianra, ja joni koshin jato yokáribia iki: —¿Jaweratokaya en pikoxontinki mato keenai? —akin. Jatian yoikana iki: —Barrabás noa axonwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jaskáakana, Pilaton jato aríbaa iki: —¿Jatian ja *Cristo akin maton akai Jesúski en jaweati iki? —akin. Jato jaskáa jatíxonbi yoikana iki: —Korosen awé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jatian Pilaton jato yokata iki: —¿Jawe jakonma akákayarin? —akin. Jato jaskáabi, korosen awé ikires koshin saa ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jatianra Pilaton oinna iki, jawen joi ninkáxonyamai, bebonbires jakonmaati saa ikanaitian. Jaskákanaitianra jato onpax bemaax, jato bebonmeaxbi mechokiita iki. Jato yoia iki: —Nato joni mawatara en akáma ikai, jara maton jawékibiribi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jato jaskáa jatíxonbi yoikana iki: —Non bakeboyaxonbira nato joni mawata non iboakai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jaskákanaitian, Barrabás jato Pilaton pikoxona iki. Ja pekao jato Jesús rishkimaa iki. Jaskáatanan moa korosen akanon ixon jato menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jatianra ja joni koshin sontárobaon, ja apo jain iká xobo chicho Jesús bokana iki. Jainra ja Jesús katei jatíbi sontárobo tsinkíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jawen chopa jopémaxonra, jaki shirokin jan perakooti joshin chopa sawemakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Moxa maitiaxonra, ja maitiribi maimakana iki. Jaskáaxonra westíora jiwi kekóti jawen mekayao yatanmakana iki. Jaskáakin akáxa, jaki shiroi já bebon chirankootaxbo neskata iki: —Jatíbitianbires ja judíobaon apo ibanon —ikibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jainxonribi, betoshba akana iki. Ja yatanmakana iwana jiwinbiribi mapoki rishkikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Moa jaskati jaki shiroi senenxonra, ja sawemawankana jan perakooti joshin chopa jopemaxon, jawen chopabiribi sawemakana iki. Jaskáaxonra moa korosen anoxon bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ja moa jainoax pikóbaini bokinra, Cireneainoa westíora joni Simón janeya nokokana iki. Jara Jesussen koros papimaxon, bomakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jatian moa ja Gólgota mananman nokóxonra, “Ja iki mapo xao manan”, iki iká, ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","moka jawékia vino meskoa Jesús xeamakana iki. Ikaxbi moa tanaax jakiribi akáshamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jatian moa korosen axonra, *suerte axon, sontárobaon jawen chopabo bikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Moa jaskáa pekáo, koirani jain yakákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ja manaon iká iki jaskara kopí akanai yoikin tablanin neskaakin wishakana: “Nato riki Jesús ja judíobaon apo”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Já betanra rabé yometsoribi korosen akana iki. Wetsa iká iki jawen mekayao; wetsa jawen mexkao. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jatian jain winotaibo, jaki shiroi, bonké bonke iananbi, ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yoikana iki: —Mia iki, ja Diossen xobo ras axonra, en kimisha nete pekáobi jakiribi aríbatiki, iki iibata. Rama minbix kishpinmeewe. Ikon Diossen bake ikax, ja korosenmeax pakéwe —akinbo akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jatian ja *sacerdotebaon koshibo itan ja esé onanboyabi jema koshiboribi jaki shiroi ikana iki neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Wetsabora jato kishpinmaa iki, ikaxbi janbix itira itipanyamake. Ikon Israel jonibaon apo ikax, ibanon ja korosenmeax janbix paketi, jatianparira non já ikonhatiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dioski koshiaronki ikira ikai, ikonkon jaon keenai ixon, abanon rama Diossen kishpinmakin. Jaronki Diossen Bake iki ixonra janbi yoiai —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ja já betan korosen akana yometsobobira, jaki shirokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jatian moa bariapan iketianra, ja main jatíbiain yameta iki; yantanpake kimisha hora kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja yantanpake moa kimisha hora ikí kaitianra, kikinbires koshin Jesús sai ika iki: “Elí, Elí, ¿Lama sabactani?” iki. (Ja iki: “Diossé, nokon Diossé, ¿Jaweatiki min ea potaapanon?”) iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jaskati saí ikai ninkatax, jatíribi jain ikábo ikana iki: —*Profeta Elías kenai riki —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jaskáketianra jatianbi ishtoi kaxon, westíoranin *esponja bitaanan, *vinagre tsaimaa iki. Jaskáaxonra jiwi nenkéki nexaanan Jesussen xeanon ixon ketaxnana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jaskáaitian wetsabaonbiribi yoikana iki: —Jaskáayamawe, jorábiratiki Elías ja kishpinmai non oinnon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jaskákenbi, Jesús jakiribi koshin saí itaanan, moa jatianbi maxkaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja jaskatatianbira Diossen xobo meran iká, jan nachitea chopa, bochikiax namani noshita iki, mairibi shakota iki, itan shankaboribi kaxketa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mawá miinkana kiniboribi kepenmeeta iki. Jatianra icha jakon joni mawániboribi jiria iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jatian moa Jesús jiria pekáora, ja mawá kini meranoax pikotax, Jerusalén jeman bokana iki. Jainoara icha jonin jato oinna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja *capitán betan jabé iká sontárobora, Jesussen yora koirani iikanainbi niwanman aká, itan meskóbo ikaitian oinnax, ikonbiresi rateti ikana iki neskati: —¡Ikonra iká iki, nato joni Diossen bake! —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jainribi ikana iki icha ainbobo, Galileankoniaxbi Jesús chibani beabo ochóxonres oinni. Ja ainbobo iká iki jan Jesús akinnabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jato xaranribi iká iki, María *Magdalena, jainoax Jacobo betan Josekan tita María. Itan Zebedeon bakebaon titaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Moa yantan iketianra, Arimateainoa icha jawékia westíora joni José janeya joá iki. Jaribi iká iki Jesús chibani ipachoai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Janra Pilatoiba kaxon Jesussen yora yokata iki. Jaskáakin yokáketianra Pilaton jato menimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jatianra Josekan ja Jesussen yora bixon, kakaati jakonshamantonin rakawaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jaskáaxonra janbi jato shanka kiniamaa bená ikainko, ja Jesussen yora niaa iki. Jaskáatananra shanka anin ja kini xepobaini moa kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jatian María *Magdalena betan wetsa Maríara iká iki ja Jesús miinkana kini ponté yakábekona. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jatian ja tantiti nete xabáketianra, *sacerdotebaon koshibo itan *fariseobo, Pilatoiba bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jain boxon, yoikana iki: —Ibó, nonra shinannai ja paranmis jonin japarixon jato neskáakin yoiibata: Eara kimisha nete itin jirinoxiki akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaskara iketian, min sontárobo yoiwe, kimisha nete senenai kaman kikinshamaankin, ja kini koirankanon. Jaonmea onanaibora beax ja yoran yometsokanake. Jatonbi jaskáaxa, jato yoii moara jirike iki ikantiki, jaskáaxonra jato apachoai bebonbires jato parankanti iki —akinra akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jaskáakana, Pilaton jato yoia iki: —Nato jatíribi sontárobo boxon, matonbishaman jato kikinhakin koiranmatankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jato jaskáaka boxon, shanka anin ja kini kikinhakin xepoxon, onantiakin boyakana iki. Jaskáaxon jaki sontárobo koiranmakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jatian ja tantiti nete winota pekáo moa domingo nete xabataitianra, María *Magdalena betan wetsa María kabékona iki, jain Jesussen yora miinbakana oinni. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jain kabékonainbi ratéresi kikinbires koshi ninwana iki; ja non Ibo Diossen ángel naikanmeax joaitian. Joxon, jan kini xepoa shanka oke taranax janbi peyakaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ja ángelnin yora iká iki, kaná biri ikai keská pené. Jawen yoraribi iká iki kikinbires joxoshaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jaskara oinnax ja kini koirana sontárobo, kikinbiresi raketi saki iki, mawá keskabo tipikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jatian ángelnin ja ainbobo yoia iki: —¡Rakéyamakanwe! Enra onanke ja korosen aibakana Jesús benai mato iitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Moara neno yamake, jan yoipachoai keskatira moa jirike. Maton onannon, jain aibakana oinni bekanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Rama ishton boxon jaonmea onannaibo yoitankanwe: ‘Ja reteibakanara moa jirike jatianronki japari moa Galileanko kaai, jainoaronki maton oinni kati iki’, jaskara mato yoikasira ea iitai —akinra jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jato jaskáa ja mawá kini ikainoax ja ainbo rabé ishtonbires kabékona iki, raketibi kikínbiresiribi rarobekona iki. Jaskataxa jaonmea onannaibo keshani kaai ishtobekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ja bokanainbi bechixon jato Jesussen saludana iki. Jato jaskáaketian nokobainxon Jesús rabikana iki jawen taekibi bekepikainxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jatian Jesussen jato yoia iki: —¡Rakéyamakanwe! Ja nokon wetsabo Galileanko bokanon yoitankanwe, jainoara ea oinni bokanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jatian ja ainbobo kaaitianribi, ja koirani iitai jaweti sontároboribi jeman bokana iki. Boxonra jatíbi jaskara ikábo ja *sacerdotebaon koshibo keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jatian jabobiribi jema koshibo betan tsinkíxon shinan akí bokana iki. Moa shinan axonra ja sontárobo icha koríki menikana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","jaskáaxon jato yoikana iki: —Jato yoinoxikanwe, noa oxaketianra jaonmea onanaibaon yamé bexon ja Jesussen yora boankanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jatian nato joi ja joni koshin ninkáketianra, noabiribi jabetan yoyo ikai, jaskáaxonra mato jakonmaati ikenbi non amatima iki —akin jato akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jaskáakana ja sontárobaon koríki bixon, ja ati yoikana keskáakin akana iki. Jatian jaskáakin yoikani joira ramakamanbi judíobaon ikon keskáakin yoikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ikaxbi ja chonka rabé jaonmea onanaibobiribi Galileanko bokana iki, jain bokanti jato Jesussen yoiibata manan ikainko. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jain boax nokóxonra ja Jesús rabikana iki, ikaxbi jatíribibo ikana iki jamara ibirai iki ixonbores shinanni. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jatianra Jesussen jato pataxbainxon yoia iki: —Jatíbi ja naikan iká itan main ikábo jato ikinti koshira ea Diossen menike. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaskara iken, rama botankanwe, jain jonibo jakana jatíbi mai ikainkobo, eonmea onannaibo itiakin jato imatankanwe, ja ikonhaibora, Papan janenko itan Baken janenko jainoax Diossen Shinanman janenko maton jato bautizanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jatíbi ja en mato onanmaa jawékibo senenhakantiakin jato axeatankanwe. Jatian eara netetiibi mato betan iti iki, ja moa nete senenai kamanbi —akin jato aká iki.");
INSERT INTO shpNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Neskataxa iká iki, ja Diossen Bake, Jesucristokiriti iká jakon joi yoikaati peokooti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ja *profeta Isaíassenra, jawen kirika meran wishanike, neskáakin: “Enra nokon joi yoiai mia raanxonai, janra mia jan kati bai benxoaxonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jain joni jayamainkoniaxa, neskati saí inoxiki: Ja Ibo jan joti bai pontexonkanwe”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jaskáakin yoini keskatishaman pikóxonra, jain joni jayamainkoxon, Diossen joi yoikin Juanman jato neskáa iki: —Moa jakonma shinanbo akonkin jenexon, Diossen joi biax, bautizameekanwe, maton ochabo moa Diossen mato shinanxonyamanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jatian Judea mainmeax, itan Jerusalén jemameax jonibo bexon, jaton ochabo Dios keshanketian, Jordán weanmanxon, Juanman jato bautizankatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ja Juanman chopa sawea iká iki, camello rani aká. Jainoax jan chinexeeta sintóra iká iki, bichi aká. Jatian jawen piti iká iki, chanpo, jainoax jawen xeati iká iki, nii meranoa bona jene. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jainxon jato joi yoikinribi, neskáa iki: —Epekáora joái, ebebon atipana koshia joni. Ea já namanbires ixonra, chirankokainxon jawen zapato risbitanibobi en choroxonti jisáma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Enra onpaxenres mato bautizana iki. Ikaxbi epekáo joáitoninra, Diossen Shinanman mato bautizanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jatian ja netebaon, Galilea main iká Nazaret jemameax, Jesús Juanhiba kaketian, Juanman Jordán weanmaxon bautizana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jatian ja jenemeax mapékin, nai chopetaitian oinna, Diossen Shinan westíora xotó keska jaki joáx itoshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jatian jaskáketian, naikanmeax yoyo ika iki neskati: “Mia riki nokon noi Bake, mionra ea ikonbiresi raroai”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jatian jaskáxon Diossen Shinanman, jain joni jayamainko Jesús ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jain iká iki chosko chonka nete senen, pimis yoinabo xaran, jainoa *Satanássen ochamakaskin Jesús tanaa iki. Jaskáketian ángelbo bexon Jesús akinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jatian Juan moa cárcel meran akanketian, Jesús Galileanko kaa iki; Diossen jaskati yoia jawen jakon joibo jato yoii. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jatian jato joi yoikin neskáa iki: “Moara yoini nete senenke. Jatian ja Diossen ikinnaton jati netera, moa ochóma iki, Diossen joi bikanwe. Ninkáxonres ja jakon joi en yoiaibo ikonhakanwe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jatian ja Galilea ian ketani kakin, oinna iká iki; Simón jawen wetsa Andrés betan rikani iibekoni, yapán teetaibo ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jatian nokobainxon Jesussen jato yoia iki: —Ea chibankanwe, jonibo biti onanbobiribi en mato imanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jaskáatianbi, jaton rikabo jenebaini jabé bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jainoax orichaa kakin, Zebedeon bakebo Jesussen nokoribia iki; ja iká iki Jacobo betan jawen wetsa Juan. Jabo ikana iki, jaton papa betan rika onai iibekoni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jaboribi Jesussen jato kenaa iki. Kakin jawen joniboyabi, jaton papa Zebedeo botenbi potabaini, Jesús betan bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Boax Capernaúmhain nokókana iki, jatian moa tantiti nete iketian, jain tsinkiti xobo meran jikixon, Jesussen jato esea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jatian jawen koshi shinanyaxon Jesussen jato eseaitian ninkatax, jonibo ratékana iki; ja esé onanbaon yoiai keskáma iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ja jain tsinkiti xobo meran iká iki, westíora joni yoshin naikia; jara neskati saí ika iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Jawekopiki mia noiba joá Nazarethainoa Jesús? ¿Noa keyoiki mia joá? Enra mia onanke, mia riki Diossen jakon Joni —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jaskataitian Jesussen yoshin notsina iki, neskáakin: —Netéwe, ja joni meranoax moa pikówe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jaskáatianbi, ja joni, mai tsakamataanan, koshín sion ikaini, já meranoax yoshin pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jaskáketian oinnax, jatikaxbi ratékana iki. Jaskatax yokakananbotankana iki, neskati: —¿Jawe keska jonikayarin nato? Bená esébo akai jato yoikin ¿Jawe keska koshi shinanyakayarin nato joni? Jan yoshinbo pikóti yoiara ikanai, jawen joi ninkáxonax, pikoti —ikibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jatian Jesussen jaskara aká jawékibo, ishtonbires ja Galilea main ninkakaaketana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jatian jaskáa pekáora; Jesús, Jacobo, jainoax Juan, ja tsinkiti xobomeax pikóbaini boax, Simón betan Andréssen xobon bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jain iká iki Simonman rayós ainbo yonatax rakata. Jaskara iketianra Jesús keshankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jaskáakana kawanxon, Jesussen ja ainbo metsonxon wenina iki. Jatianbi moa yoná jenexon jato jawékiati axona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jatian moa bari jikii yantanshoko ikenbi, ja jatíbi isinaibo, itan yoshin naikiaboribi, Jesússiba bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jatianra jatíbi ja jemamea jonibo ja xobo xepotiain tsinkíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jatianra Jesussen icha joni meskó isinyabo jato benxoaa iki. Jainxon icha yoshinboribi jato meranoa jokonhaa iki. Ikaxbi yoshinbo jawebi jato yoyo imayamaa iki, jabaon já onankana iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jatian nete bei, oxnetaishoko Jesús wenitax, xobomeax pikókaini jabicho kaa iki, tsoabi yamankoxon orani. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jatianra Simón jabé ikábo betanbi, Jesús benai bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nokóxon yoikana iki: —Jatíxonbira mia benakanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jaskáakanabi jato yoia iki: —Ochóma jema ikainkobo bonon bokanwe, jainribi jato Diossen joi yoii. Jaskarainoabo jato akinoxkayara ea joá iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jaskatax Galileanko iká jemabotiibi kaa iki. Jaton jain tsinkiti xobo meranxonbo, Diossen joi jato yoiboa iki. Jainxon jonibo meranoa yoshinboribi pikoboa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iitaitian, westíora *lepra isinya joni joáx, Jesús bebon chirankooxon yoia iki: —Mia keenxon, nokon yoramea isin, min ea benxoawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jatian Jesussen noibaxon, jawen mekenman tii axon, yoia iki: —Eara keenai, en mia benxoabanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jaskáatianbi, moa jawen isin benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jaskáaxon, ja joni raankin, Jesussen neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Kakin, tsoabi yoiboyamatanwe, ja *sacerdotebicho oinmatanwe. Jainoax mia Dios bebon jakon iti kopí, Moiséssen jaskáati yoini keskáakin, Dios jawéki menitanwe, mia *sacerdotebaon oinkanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ikaxbi ja jonin kakin, jatíbi jaskara ikábo jato keshanboa iki. Jatian moa jato keshanketian, Jesús jawerato jemanbi kati atipanyamaa iki. Jaskatax tsoabi yamanko, Jesús iká iki; ikaxbi, jatíbiainoax já oinni bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jaweti nete pekáora, Jesús Capernaúmhain karibaa iki. Jatian ja xobonko ninkatax, ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","jain icha jonibo tsinkita iká iki, ja xobo xepotiainbobi moa senenma. Jatian jainoara, jan jato Diossen joi yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iitainbi, chosko jonin kishi jirioma joni bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ikaxbi icha joni iketian, jikimati atipanyamaxon, ja Jesús iká ponté xobo pebixon, jawen rakátinin axon, ja isinai naman apakekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jatian jan bea jonibaon kikinhakin, ikonhakana onanxon, Jesussen ja isinai yoia iki: —Baké, min ochabora en moa mia shinanxonyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jesussen jaskáakin ja kishi jirioma yoia ninkatax, jain yakákana jawetii esé onan jonibaon, neskáakin shinankana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Jawekopiki nato joni yoitimaresi jaskati yoyo ikai? Jakonmaibiresi ikai, Dioski yoyo iki. Diossenresa atipanke ja ochabo moa jato shinanxonyamakin —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ikaxbi jaton shinan onanxon, Jesussen jato yokata iki: —¿Jawekopiki maton jaskáakin shinannai? ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jaweraki yoitikayaki atibires iki? ¿Min ochabora en moa mia shinanxonyamai ati? Iamax ¿Min rakáti yatanbaini katanwe akin ati? ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jaskara ikenra, rama en mato onanmai; ja jonin Bakera nato main, jaton ocha akábo jato shinanxonyamanoxon yoiti koshiya iki ixon —akin. Jatian jaskátaanan, ja kishi jirioma joni yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Miara en akai: Weníxon, min rakáti yatanbaini moa min xobonko katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jatianbi ja joni wenitax, jawen rakáti bibaini, jaton jishnonbi moa jainoax kaa iki. Jaskara oinnax, jatikaxbi ratetax, Dios rabii ikana iki, neskati: —Nonra jawetianbi jaskara jawéki oinyosma iki —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jaskatax Jesús ian kexa karibaa iki. Jain iketian, jaki joni icha tsinkíkanketian jato esea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jainoax moa kaai winókin, Alfeon bake Leví, jainxon ja romamea apo kopí yokáxonkanai xobonko, jato kopí yokati yakáketian meraxon, Jesussen yoia iki: —Ebé kawé —akin. Jaskáa wenixon Levikan chibana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kakinbi Levikan, Jesús jaonmea onanaiboyabi jawen xobon pikinnoxon jato ioa iki. Jatian jain jato betanribi icha joni bokana iki; apo jato kopí yokáxonai jonibo itan wetsa ochaya joniboribi ikana iki, ja Jesús jaonmea onanaiboyabi pii ikanainko jato betan yakákana. Jatian jato chibani bokanabo ikana iki kikinbires icha. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesussen jaskarabo betan piaitian oinxon, ja esé onan *fariseobaon Jesussenmea onannaibo yokákana iki: —¿Jaweatiki maton Maestron, ja apo kopí yokáxonaibo itan ja ochaya jonibo betan jawékiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jato jaskáai ninkáxon Jesussen yoia iki: —Isionmabaonra jato benxoakai joni benayamai. Ja isinyabaonresa akai, jato benxoakai joni benakin jan raonnon ixon. Eara jakon jonibo akinni joáma iki, eara joá iki ochaya jonibo jato akinni —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jatian westíora nete ikana iki, ja jato *bautizanai Juanmamea onannaibo betan *fariseobomea onannaibo *ayunani. Jatianra jatíribi jonibo Jesússiba bexon yokákana iki: —Ja jato Bautizanai Juanmamea onannaibo betan ja fariseobaomea onanaibaonra akai ayunankin, ¿Jawekopiki ja mionmea onanaibaon ayunanyamai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jatian Jesussen jato neskáa iki: —Wanoai joni jato betanbi ikenki ¿Ja kenaa jonibaon jawékiayamai iki? Ja wanoai joni jato betanbipari ikenra, ayunankanti yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ikaxbi ja wanoai joni bokanti netera nokónoxiki, jatianparira ayunanoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsonbira chopa payo bená chopan onayosma iki. Akábira jan onaa topo otsiax anii noshitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jainxonribi tsonbi bená aká vino, payo bichi chomon nachíosma iki. Akábira moa vino paexon ja chomo toá imati iki. Jaskatax moa chomo ramíketian ja vinoribi moa yoyokooti iki. Jaskánaketianra ja bená aká vino, bichi chomo benakanribi nachíti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jatian jato jaskáa pekáo, tantiti netenbi trigo wai naponbi Jesús winota iki, winókinbi jaonmea onanaibaon trigo bimi tsekakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jaskáakanaitian fariseobaon yokata iki: —Oinwe ¿Jaweatiki tantiti neten jaskátima ikenbi, ja mionmea onanaibaon trigo bimi tsekakanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jatian Jesussen jato neskáa iki: —¿Matonkayaki ja Davidkan, já chibanai joniboyaxonbi, maxkáxon, jawékiakaskin aní, Diossen joi meran yoyo ayosma iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ja *sacerdotebaon koshi Abiatar, Diossen xobonko inontianra, ja xobon David jikixon, *sacerdotebaonbicho piti ikenbi, ja pan piaa iki. Jaskáxon jabé nia joniboribi jato menia iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jainxon Jesussen jato yoiribia iki: —Ja tantiti netera, jan joni iboaxon yonoti Diossen akáma iki, ja netera aká iki, joni tantitibiribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ramara, en mato onanmai; ja jonin Bake riki, jawerin ja tantiti neten ati ixon mato jan yoiti koshia —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jatian wetsa nete, jain tsinkíti xobo meran, Jesús jikiribia iki. Jain iká iki, westíora meken jirioma joni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jain ikana iki jawetii joniboribi, ja tantiti netenbimein akai, Jesussen ja meken jirioma joni benxoakin ixon oinni. Aketian ja yoixontaanan, jakonmaati shinanyanix. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jaskákanaitian, ja meken jirioma joni, Jesussen yoia iki: —Wenitax, jato bebon chankawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jaskáxon Jesussen jato yokata iki: —Tantiti netenki, jawe jawéki ati yoiai ¿Jakon jawéki ati o jakonma jawéki ati? ¿Jato mawámaresti o jato mawámatima? —akin. Jato jaskáabi netéreskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jatian já kateaketanabo sináyaxon jato Jesussen oinna iki, jatianra ikonhakashamakanaitian onístaanan ja joni yoia iki: —Min meken sananwe —akin. Jaskáa jawen meken sanana iki, jatianbi joni benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ikaxbi jaskara oinnax, moa *fariseobo pikóbaini boax, ja Herodes rabékinnaibo betan tsinkíxon, Jesús reteti shinan akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jatianra jaonmea onannaiboyabi, Jesús ian kexa kaa iki. Jain ikanaitian, ichaxon Galilea jonibaon chibankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jatian Jesussen ratéti jawékibo akai ninkatax, oinni bekana iki. Ja bekanabo iká iki, Judeainoabo, Jerusalénhainoa jonibo, jainoax Jordán bekeiba iká Idumeainoabo. Jatíribibo ikana iki, Tironkoniabo, itan Sidónhainoabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jaskati icha joni, jaki bekanketianra, jaonmea onannaibo Jesussen yoia iki; bitaxkanaketian jan nanéti boti bexonkanti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Moa icha joni jato benxoaa iká iki. Jakopi ja isinaibo beax, Jesús tii akasi, jaki tsamákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jatian ja joni meran iká yoshinboribi, Jesús bebon chirankotax saí ikana iki, neskati: —¡Mia riki ja Diossen Bake! —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ikaxbi jonibo bebomeax já yoii jaskáyamakanon ixon, Jesussen notsínxon jato netémaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jaskata pekáo, Jesús mananman kaa iki. Jainxonra, jawen keenshamanbores, Jesussen jato kenaa iki. Jatian moa beax, tsinkíkanketianra, ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","chonka rabé joni jato xaranmea katota iki, jabé nikanti, itan jato joi yoiti raanoxon. Jatian jabora jato janea iki: “Raanabo”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jainxonra, jawen koshi shinan jato menipakea iki, jan yoshinbo pikokanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja chonka rabé katóxon biá jonibo ikana iki; Simón, ja Pedro akin janea. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jainoax iká iki, Zebedeon bake rabé, Jacobo betan jawen wetsa Juan; jabora janea iki, Boanerges akin, ja iki, (“tirin ikaitonin bakebo”) iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Jainoaxibi ikana iki: Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeon bake Santiago, Tadeo, Simón ja Zelote. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jainoax, Judas Iscariote, ja jakonhai keská iikinbi jan Jesús jakonmaani. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jaskáa pekáo, westíora xobon Jesús jikia iki. Jain iikanaitian, icha joni jakiribi jatoki tsinkíkana iki. Jatian Jesussen, jaonmea onanaiboyaxonbi jawékiatibobi atipanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jatian Jesús jaskatai ninkatax, jawen rarebobo já bii beax ikana iki, naton shinanra moa jakonmaake, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jatian esé onan joniboribi, Jerusalénhainoax beax, já yoiiribi ikana iki: —Nato joninra, yoshinbaon koshi Beelzebúkan atipana koshi meniatonin akai, ja jonibo meranoa yoshinbo jokonhakin —ikibo yoyo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jaskákanaitian, jonibo kenaxon yoia iki: —¿Jawekeskaxonmein atipanke, *Satanássen, jabé yoshin pikokin? ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Westíora jemankoniax, rawikanantaanan, jatonbiribi tsamáshoko akáxa, moa jainbicho ikanti atipanyamakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jainoax, westíora xobonko, ja rarebobicho jakanabo, jatonbinix, ramiananaxa, moa jainbicho ikanti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanás iki jaskáribi, jabé ikábo betanbi ramiananaxa, moa janbiribi ikax, jaton koshia itima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tsonbira koshi jonin xobon jikixon, ja joni nexayonamatianbi, jawen jawékibo yometsoati atipanyamake. Nexayonxonparira, jawen jawékibo boonankanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ikonshamanra, en mato yoiai, Diossenra jatíbi jonibo jaton ocha akábo, itan jakonmai yoyo ikanabo, moa jato shinanxontima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ikaxbi jaweratoboki ja Diossen Shinanki jakonmaibires yoyo ikax ochai, jabora jawetianbi jato Diossen shinanxonkin jenetima iki. Jabora jatíbitian ja ochayabi ikanti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jaskáakinra Jesussen jato yoia iki já yoii, yoshin naikia riki nato iki ikanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jatian jato jaskáai iitaitian, Jesussen tita betan jawen wetsabo bekana iki. Bexon jemanxonbi, Jesús kenamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jatian já kateax tsamatabaon, Jesús neskákin yoikana iki: —Min tita betan min wetsabora, mia oinkasi beax, jeman ikanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jaskáakana jato neskáa iki: —¿Tsoaborin nokon tita betan nokon wetsabo? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jatian ja katei tsamákana jonibo oinyaketanxon, jato yoia iki: —Natobokaya riki nokon tita, itan nokon wetsabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jaweratobaonki Dios keenai keskáres akai, jaboriki nokon wetsa, nokon poi, itan nokon tita —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jatian Jesús jakiribi ian kexá kaxon, jato esekin peoa iki. Ja icha joni tsinkíkanketian, boten nanetax napoori kaax Jesús jain nayakaa iki. Jatian jonibobiribi ian kexabi tsamákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jaskáaxon icha meskó jawékiki yoinyanan jato esekin, neskáa iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Ninkákanwe neskara en mato yoiai: Westíora jonira wainko kaa iki, bimi bero banakin masáa aaboi. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ja masá akara, jatíribi berobo bai napo maana iki. Jain maanabora, isábaon bexon piá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jainoax jatíribi berobo makan xarán maana iki. Jaskarain maannax, mai kextóma iketian, ja berobo ishton xoxoa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ikaxbi bari pikotax xanaketian, ja xoxoa berobo, mai kextóma iken, ishtonbires siwata iki, taponma ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jatian jatíribi berobo moxa xaran maana iki. Jatianra moxabo ishtonbires anixon retea, moa bimiamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jatian jatíribi berobo maana iki, mai jakon ikain. Jaskarain maannabora, xoxoax, jakonshamani bimia iki: wetsa nia bimia iki, kimisha chonkabo; wetsa sokota chonka, wetsa iká iki, pacha —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jaskáxon, Jesussen jato yoia iki: —Ninkataibo ixon, ninkákanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jatian moa jonibo bokana pekáo, Jesúsbicho banéketian, já ochóma iwanabo betan jawen chonka rabé jaonmea onanaibaon bexon, Jesús yokákinkana iki; jawe yoikinki jan jato jawékiki yoinyanan, esewana ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jaskákana jato yoia iki: —Diossenra jawen ikinnaton jati joné nete, pontéres mato onanmaa iki. Ikaxbi ea ikonhayamaibora jawékiki yoinyanan en jato onanmai, ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","oinnaxbi, oinnama keskábores ikanon ixon, itan en yoiai joi ninkataxbi ninkatama keskábores ikanon ixonribi. Jaskáaxon jaton jakonma akábo akonkin jeneyamakanaitian, Diossen jato ja shinanxonresnon ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jainxon jato yoia iki: —¿Ja jawékiki en jato yoinwana eséki maton onanyamaa? ¿Jawekeskaxonki ja wetsa jawékibo maton onanti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ja bero banai joni keská riki, ja Diossen joi yoiai joni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jatíribi jonibo riki, ja bai napo bero maana iní keskabo. Jaskara jonibaonra akai, Diossen joi yoikanaibo ninkáshamankin, ikaxbi *Satanássen joxon akai jan ninkata joibo shinanbenomakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jatíribi jonibo jake, ja makan xaran bero maana iní keskabo. Jaskarabaonra akai joi ninkaxon keenshamanxon ikonhakin, ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ikaxbi ichama taponya keskábo ikaxa, koshi shinanhomabo ikanai. Jaskara kopíra, tanakin masá tenemakanabo ishtonbires joi ikonhakin jenekanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jatíribi jonibo riki, moxa napon bero maana iní keskabo. Jaskarabaonra joi yoikanaibo ninkatai, ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ikaxbi nato netemea jawékibores shinankin itan koríki bitiakinres shinanni jatonbinix parameekanai. Jainoaxibi wetsa meskó jawéki ati shinanbaonribi, ja joi ikonhabo moa jato shinanbenomai. Jaskataxa bimiamai keskábo banékanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ikaxbi jarake jonibo, ja mai jakonshaman ikain bero maanna iní keskabo. Jaskara jonibaonra joi ninkáxon ikonhakanai. Jabo riki bero maana xoxoax jakonshamani bimia iní keskabo. Jaskara ikax; westíora nia bimia iki kimisha chonka, wetsa nia sokota chonka; jainoax wetsa nia pacha bimia —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jainxon Jesussen jato yoiribia iki: —Tsonbira lamparin keteaxon jawékinin mapoyamai iki, itan oxati namanribi yasányamai iki. Jaskáyamakinra bochiki peyasankanai; jawen joekan tenaa jishtishaman inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaskáribira jawéki akanabo jonéma iki; onanyamarakanke ixon shinantima. Ja joné akana jawékibora jato jishtiaxonoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jaskara iken, ninkataibo ixon, ninkákanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jainxon jato yoiribia iki: —Ninkakanwe en mato yoiai: jawekeskakinki maton wetsabo akai, jaskáakinribira mato Diossen ati iki, bebonbirespariribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jatian joi ninkáxon jan yoiai keská akaibora, bebonbires Diossen jato onanmati iki. Ikaxbi jaweratobaonki joi ninkáxonbi ikonhaayamai jabora jaton jayata onan shinanbi moa Diossen bichinti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jainxon Jesussen jato yoiribia iki: —Ja Diossen ikinnaton jati nete riki, jonin bero banaa ikai keská. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ja banakin senenhax ikai; yaméketian joni oxai. Jatian nete xabáketian ikai joni besoi. Jatian ja jonin onanyamake jawekeskataxki yamé itan neten ja bero banaa xoxoax aniai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ja mainbira ja banaa berobo neskámai; rekenpari xoxoax jawen jiwi aniax bimiai. Japekáora texkan bocho, ja bimi bero ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jatian ja bimibo moa tsekatires iketianra, jawen ibon ja bimibo moa tsekai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jainxon jato yoiribia iki: —¿Ja Diossen ikinnaton jati netemein jawe jawékiki non yointi iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jara, ja mostaza beroshoko banakana ikai keská iki. Ja mostaza bero riki, ja banakanai wetsa berobo winoa kikin beshéshoko. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jaskara beshéshoko ikaxbira ikai, banaa xoxoax, jatíbi ja wainkonia wetsa banábo bebonbires ani baneti, jatian ani mebiabo iketianra isábaon jain naakanti atipanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jaskáaxonra icha jawékiboki yoinhanan, Jesussen jato Diossen joi yoikatitai, jabaon onanti senenresbo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Janra jawékiboki yoinhananres jato joi yoikatitai. Ikaxbi jaonmea onanaibora jatíbi jawékibo onantishamanhakin jato yoikatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jatian moa yametaitian Jesussen jaonmea onannaibo jato yoia iki: —Oke ian keiba shitánon bokanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jaskáatanan jaonmea onannaibo já iká boten nanémaax, jain ikana icha joni potabaini moa bokana iki. Jatian jato chibani, jatíribibo wetsa botenbo bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ja bokanainbi niweaba koshi jatoki paketax, ani bechona iki. Jaskáxonra jaton bote, bechonman jato jene bochoanaana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jaskatainbi Jesúsbiribi ja boten chirakax tepikaini oxaashaman iká iki. Ikaxbi jishtenhaxon Jesús yoikana iki: —Maestró ¿Noa bechonman reoainbiki mia jawe iamai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jaskáakana wenixon, niwe betan aniparo notsinkin neskáa iki: —Jenéwe, moa niweyamawe —akin. Jaskáa ja niwe betan bechon jenetax, moa ian jakonshaman baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jatian jaskátaanan jaonmea onannaibo jato yoia iki: —¿Jawekopikayaki mato iorai rateta? ¿Matokayaki, Dioski kikinni koshiamaparibo iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jato jaskáabi kikinbiresi ratékanabo ikax, jatobires yokakanani neskákana iki: —¿Jawekeska joni ikenmein akai, niwe betan bechonbaonbi jawen joi ninkáxonkin? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jatian moa shitábaini boax, Gadara main nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jain nokotax moa Jesús mapetaitianribi, pantionhainoax yoshin naikia joni jaki joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja joni iká iki pantionhainbiribi jaa; tsonbi jakonshamanxon tantimatibi atipanyamaa itan cadenaninbobi nexati atipanyamakana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Moa ichaakinbo cadenaninbo tanéxon menéxkanabi, cadenabo ras aresai iká iki. Jakopíra tsonbi tantimati atipanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Netenyabi, yamébo pantionhain itan mananman kaaxbo ja joni saí iikawankatitai iká iki. Jainoax janbixbi makanman tsakakaatibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jatian ochóxonbi Jesús merataanan jaki ishtoi joáx chirankootanan, ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","saí iki neskata iki: —Mia riki Jesús, ja ani Diossen Bake ¿Minki ea jaweakai? Enra mia Diossen ninkánonbi yoiai; ea masábires tenemayamawe —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jaskáakinra yoia iki, ja nato jonimeranoax pikówe yoshimá, akin Jesussen aká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jaskáketian Jesussen yokata iki: —¿Jawe janerin mia? —akin. Jatian jan yoia iki: —Nokon jane riki legión, emeran icha ikanai kopí —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jatian ja yoshinbaon Jesús yokákin teakana iki: —Nenoa noa wetsa main raanyamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jatian ja ochóma manan ipaketiainko icha kochi pii tsamata iketian, ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","yoshinbaon Jesús yoia iki: —Ja kochi tsamatainko noa raanwe, noa jain weinon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jaskáakana Jesussen ja yoshinbo jain boax weiti jato yoia iki. Jaskatira ja joni meranoax jokonbaini boax ja kochibo meran weikana iki. Jainra ibiraa iki, rabé waranka kochibobira. Jatianra ja kochibo ishto boax, jene tsakax keyókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jatian jaskatabo oinnax, ja kochi koiranaibo jabati ishtokana iki, bokin ja jeman nokóxon itan wain teetaiboiba nokóxonbo, ja winota jawékibo jato keshanbokana iki. Jatian jonibo bokana iki, jaskara jawéki winotabo oinni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jatian bexon oinkana iká iki, ja yoshin naikia ikax ramionpachoai joni, moa jaskarama; jakonshaman moa chopa saweyonax yakata itan jawen shinanribi moa jakon. Já oinnax jonibo ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jatian ja jaskata oinni beabo, jatonbishaman oinnabaon jato yoia iki; jaskatax ja yoshin naikia ipachoai joni benxoabo itan jaskatax kochibo keyotaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jaskáaketian moa jainoax katanon ixon Jesús yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jaskáakana moa kaai boten nanetaitianribi, ja yoshin naikia ipachoai joni joá iki, jabetan kakaskin Jesús yokati. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jaskáabi ja joni iwekashamakin, Jesussen yoia iki: —Min xobonko katanwe, min kaiboboiba. Jain kaxon ja Diossen mia noibaxon benxoabo jato yoitanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jaskáakin yoia kaxon, *Decápolissain iká jemabaon jato yoiboa iki; jaskáxon Jesussen já akinna jawékibo. Jaskara ninkatax jatikaxbi jonibo ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jatian moa jakiribi Jesús ian keiba shitáketian, icha jonibo tsinkíkana iki. Jatianra já ian kexabi baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jain iketian, jain tsinkíti xobomea westíora joni koshi joá iki; jawen jane iká iki Jairo. Jara joáx Jesús namanbi chirankooxon, ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akonbireskin yokákin neskáa iki: —Nokon bake xontakora moa mawatibishoko iki. Eapari kaxon mamepasxon benxoaxoni kawé, jatianra moa já mawátima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jaskáakin yoia Jesús jabébi kaaitian, icha joni ja chibani boaibaon Jesús bitáxeskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja joni icha xaran iká iki, westíora ainbo isinai; moa chonka rabé baritia jimi boanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jara kikinbiresi onitsapita iká iki jato raonai jonibo raonmai, jatíbi jawen jayata jawékibo yankabires keyoyona, jatian benxotitianbi, jawen isin moa wekókaresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jaskara iikinbi, Jesús yoikanaitian ninkatax ja ainbo, joni icha xaranbi, Jesús pekáobi jikikainxon jan perakoota chopa tii akanaana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Moabi jan shinanna iká iki, ja Jesussen perakooti chopatanibires tii akáxa ea benxoti iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jatian jawen tari tii akatianbi, moa jimi boani jeneta iki. Jatianra ja ainbonin onanna iki, jawen isin moa benxoa. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jatian Jesussen jawen atipana koshi ja meranoax pikota onantaanan, jonibo xarameax pekáori bechiakekainxon jato oinna iki. Jaskáaxon jato yokata iki: —¿Tsonki nokon tari ea tii akanaana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jatian jaonmea onanaibaon yoia iki: —Joni icha miki tsamáxon bitaxa onanaxbiki mia ikai ¿Tsonki nokon tari ea tii akanaana iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jaskáakanabi jan tii aka onankaskin Jesussen oken benabekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jatian ja ainbo, eara moa benxoke ixon onanax joáx, raketi saki iananbi, Jesús naman chirankootoshixon, jatíbi ja ikon jawékibo keshana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jaskáaketian Jesussen yoia iki: —Ea ikonhaxa mia benxoke, baké; jakonres katanwe, moara mia isinhoma iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jatian Jesús yoyo iki jenetamapari ikenbi, Jairon xobonkoniax, jawen jonibo bekana iki. Bexon ja bake ainbaon papa yoikana iki: —Min bakera moa mawáke. Ja Maestro min xobon iokaskin moa teayamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ikaxbi jaskákanaitian ninkáxonbi, neskáakinbiribi Jesussen, Jairo yoia iki: —Rakéyamawe, eares ikonhawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jainxon Pedro, Jacobo, jainoax Jacobonin wetsa Juan, jabores jabé kati yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jatian moa Jairon xobon nokóxon oinna iká iki, jonibo winii, saa iki itan moa tsokaskana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jatian jikikainxon Jesussen jato yoia iki: —¿Jaweakiki mato winii saa ikanai? Nato bakera mawatama iki. Oxaaresiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jato jaskákin yoia, Jesús ikonhaayamai shiroi saa ikana iki. Ikaxbi jan jatíbi jain ikábo jato jokonha iki, jaskatax jawen papa betan jawen tita itan jabé kaabo betanres, ja bake ikainko jikikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jatian, Jesussen ja bake ainbo metsontaanan yoia iki: —¡Talita Cumi! —akin. Ja iki, “miara en akai baké, jikiwe”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jaskáatianbi, ja xontako moa wenita iki. Ja bake iká iki, chonka rabé baritiaya. Jatianra jonibo kikinbiresi ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ikaxbi Jesussen jato yoia iki, tsoabi jaskara jawéki winotabo keshantima. Japekáora jato yoia iki, ja bake pimakanti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jatian jainoax moa jakiribi, jawen mainbiribi Jesús kaaitian, jaonmea onannaibo jabé bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jain nokóxon, tantiti neten, ja jain tsinkíti xobo meranxon, Jesussen jato esekin peoa iki. Jatian ja icha joni, jaskáakin jato yoiai ninkataanan, ratetax, neskákana iki: —¿Jaweranoa jaskara jawékibo onanarin? ¿Jaweranoa onan shinan biaxki nato joni jaskatai? Itan ¿Jawekeskaxonki ja ratéti jawékiboribi akai? ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Nato joniki carpinteroma iki, Marían bake? Já iki, Jacobonin wetsa, Josekan wetsa, Judassen wetsa, jainoax Simonman wetsa. Jawen poiboribi iki neno noobetan —ikibo ikana iki. Jaskáaxon moa jaki jakonmaakin shinankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ikaxbi, Jesussen jato yoia iki: —Westíora *profetara, jatíbiainxon jakonhakin oinkanai. Ikaxbi jawen mainkoxonra, jawen rarebobaonbi, itan jawen xobon ikábaonbi, jaskáyamakanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jaskara kopíra, jainxon westíora ratéti jawékibi jan ati atipanyamaa iki. Jaskara ikenbi, jawetii isinaires jaton yora meeanan, jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jatian jainoa jonibaon, já ikonhaayamakanai oinnax, Jesús rateta iki. Jaskatax wetsa jemabaonres, jato Diossen joi onanmaboi kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iikin chonka rabé jaonmea onannaibo, Jesussen tsinkia iki. Jaskáxon rabé rabébo, joi yoiti raankin; jonibo meranoa yoshinbo pikoti, yoiti koshi jato menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jatian raankinra, nato jawékibo botima jato yoia iki: Jaton jawékiati, jaton bolsa, jaton koríkibi. Jaton bastónbores boti jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jainxon, zapatores saweti jato yoia iki. Ikaxbi ja saweti wetsa chopares botima. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jaskáaxon, Jesussen jato yoia iki, jawerato xobonkoxonki mato bikanai, jainra mato banéti iki, jainoax mato wetsanko kaai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jatian jaweranoxonki mato bikashamakanai, itan maton yoiai joibo ninkákashamakanai, jainoaxa moa mato pikóti iki. Ja moa kaaira, mato mai poto tawasakainti iki, ja mato bikashamakana onanti iti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jato jaskáakin yoia bokin, ja chonka rabé jaonmea onanaibaon, akonkin jaton jakonma shinanbo jeneti joi jato yoibokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jainxonribi, jonibo meran yoshin weitabo jokonhabokana iki. Icha isinaiboribi, xenin sikaanan jato benxoakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jatian Jesús ikábo yoikanaitianra, apo Herodesnin ninkata iki, jara jatíbiain ninkakaata iki. Jatíribibo ikana neskati: “Jato *bautizanai Juanra jirike, jakopira atipana koshi shinanya ixon, ratéti jawékibo akai”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wetsabobiribi ikana iki: “Natora *profeta Elías iki”, ikibo. Jatian wetsabo ikana iki: “Moatian *profetabo iní keskaribi riki”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jatian jaskara jawékibo ninkatax, Herodes iká iki: —Jara Juan iki, en jato textemayantana, jara moa jakiribi jirike —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ja Herodías kopíra iká iki Herodesnin Juan jato yatamaxon itan cadenanin nexamayonxon cárcel meran jato amaa. Ja Herodesninra jawen wetsa Felipen awin Herodías awinhaka iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jatian Juanman Herodes yoia iká iki: —Min wetsan awinbi, awinhatira esekan yoiamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jaskáakin yoia kopí Herodías, Juanki kikinni sináxon, retekasa iki; ikaxbi ati atipanyamaa iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ponté shinanya, itan jakonma jawéki ayamai joni onanax, Herodes jaki raketaitian. Jatian Juanman yoiaibo moa jaskáshamanti atipanyamaxon, jakonhaxonres Herodesnin ninkáxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jaskara iitainbi, jawen pikota baritia nete senenketian rarokin, Herodesnin ani fiestaaxon, jawen joni koshiboyabi sontárobaon koshi *comadantebo, itan Galileankonia kikin jonibo kenaxon jato jawékiakiina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iikanainbi, ja Herodíasnin bake xontako, ja jawékiai ikanainko jikiax ransaa iki. Ja ransaitian, Herodes betan jan kenamaa jonibo, kikinbiresi rarokana iki, jatianra ja xontako Herodesnin yoia iki: —Ja mia keenai jawékibo ea yokákinreswe, en mia meninon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jatian ikonkon meninoxon yoia iki: —Jawe jawéki inonbires min ea yokatara, en mia meniti iki. Ja en jato jain ikinna maira, jatíbi jawékiboyabi naponbekon senen inonbi en mia meniti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jaskáa kaxon, ja xontakonin jawen tita yokata iki: —¿Jawemein en yokáti iki? —akin. Jatian Herodíassen yoia iki: —Ja jato *bautizanai Juanman mapo yokátanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jaskáatianbi, ja xontako ishto apoiba kaxon, yokata iki: —Ja jato *bautizanai Juanman mapo raton axon, min ramabi menitininra ea keenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jatian ja apon akonbireskin masá shinanna iki. Ikaxbi ja kenama beabo bebonxon ikonkon meniti yoia ixon, ja xontako parankashamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jaskáakin moa yoia ixonra, jatianbi jawen westíora sontáro apon raana iki; ja Juan texteanan, jawen mapo bexonon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jatian kaxon ja sontáronin, Juan textexon, jawen mapo raton bexon, ja xontako menia iki, jatian janbiribi jawen tita menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jaskáakana ninkataxa, jawen jonibo, Juanman yora bii bekana iki, jaskáaxonra moa miinnoxon bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jatian jaskata pekáo, ja raanabo Jesús betan tsinkíkana iki. Jainxonra jatíbi jaton aká jawékibo, itan jaskáakin jato joi onanmakanabo yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jatian joni icha jatoki beax, jatíribibo boai rawini beyakereskanaitian, pitibobi atipanyamakana iki. Jaskara kopí, Jesussen jaonmea onannaibo yoia iki: —Noa shokores tantinonpari, tsoabi yamanko noabicho bonon bokanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jaskatax Jesús jawen joniboyabicho tsoabi yamanko boí, napokoobainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jaskati bokanaitian oinxonra jonibaon onankana iki, jain boira ikanai ixon. Jaskatax, jatíbi ja tsinkitabo ian ketani ishto boax, jatopari Jesús jain kainko nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jatian Jesussen moa nokóxon mapétaanan oinna, jatopari nokotax joni icha tsinkíribikana iká iki. Jatianra jato oinxon Jesussen noibaa iki, jan koirantioma oveja keskábo ikanaitian, jainxonra icha jawékibo jato onanmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jatian moa yantan iketian, jaonmea onanaibaon Jesús yoikana iki: —Moara yantan iki nenora jawebi yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Moa botankanon ixon jato yoiwe; abátankanon ja wai ikainkobo itan ja ochóma iká jemabaon boxon jaton jawékiatibo maroxon bikin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ikaxbi Jesussen jato yoia iki: —Matonbikaya jato pimakanwe —akin. Jatian jabaon Jesús yoia iki: —¿Minki noa yoiai, ja rabé pacha nete teexon biti koríkinin, non jato jawékiati bixon pimati? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jatian Jesussen jato yokata iki: —¿Matoki jawetii panya iki? Ointankanwe —akin. Jato jaskáa moa jatí pan jaketian onanxon yoikana iki: —Jarake pichika pan jainoax rabé yapa —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jatianra Jesussen jato yoia iki, tsamábo axon jato paston jatíbi yakámati. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jato jaskáa, ja tsamábotiibi pachabo itan pichika chonkabo akáx yakákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Moa jaskákanketian Jesussen ja pichika panyabi rabé yapa bitaanan, bochiki oinxon Dios iráke aka iki. Jaskáatanan panbo tobapakeanan jaonmea onannaibo menia iki. Jabaonbiribi ja tsamata jonibo tekikin jato menipakea iki. Jaskáakinribi axon ja yaparibi jatíbi jato menipakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jaskáakin menikana jatíxonbi piax moa kikinni potókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jatian texeakana ja panyabi, yapa pakexbo tsinkíkanara, chonka rabé tasá bocho iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jatian jan jawékiaa jonibo ikana iki, pichika waranra jonibira. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jaskáa pekáo Jesussen jaonmea onannaibo yoia iki, jatopari ian keiba boten shitatax boax, Betsaida jeman nokókanti. Jatian Jesúsbiribi ja joni icha jato raani jainpari baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jatian moa jato raankin senenhataanan, Jesús mananman kaa iki, orani. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jatian ja boí ian naponbekon ikanaitianra, moa yameta iki. Jatian Jesúsbiribi jabicho jainbipari iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jainxonbi jato oinna iki, jatoki niwe pakéxon, jato jakonhakin winamayamaitian. Jatian moa nete xabáti ochóma Jesús jene besenen niax jatoki joá iki. Jatian jato winobainai keská iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jainoara jene besenen niax joaitian oinnax, yoshinra ibirai ikax, raketi saa ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jaskáakin oinnax jatikaxbi ratékanaitian, Jesussen jato yoia iki: —¡Rakéyamakanwe, ea riki, koshiakinres shinankanwe! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jaskatax ja ikana boten nanéketianribi niwe jeneta iki. Jatianra jabo ikonbiresi ratékana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ja shinanmanres pan kaimaa onanyamareskanai kopí. Jaton shinanbora moa onantimata, iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jatian ja ian shitai boax Genesaret main nokókana iki. Jain nokóxon jaton bote nexakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jatian moa mapékenbires, jainoa jonibaon Jesús onankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jaskáakin onanxon ja main ikana jonibo ishton jato keshaanketankana iki. Jatianra ja isinaibo, jawen rakátinin axonbo Jesússiba bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jatian kaira Jesús, anichaa jemabaon itan maxkoshoko jemabaon nokota iki. Jaskarainbo nokóketian, icha jonibo winotainkobo ja isinaibo rakanxonkana iki. Jaskáxon Jesús yoikana iki, jan perakoota chopa kebítanibires ja isinaibo jato tii amanon ixon; jatian jawen chopa jan tii akabo benxokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jatian *fariseoboyabi, ja Jerusalénhainoax bekana jawetii esé onan jonibo, Jesússiba bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bexon, ja jaweti Jesussenmea onanaibaon mechokiixonmabi piaitian oinxon, jashoko jato yoixonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ja *fariseobo betan jatíbi judíobora ikana iki, jaton reken papabaon axekan ikín, meken chokaxon jawékiaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jatian mercadonkoniax joxon, mechokiixonpari pikátikanai. Jainoax meskó icha axébora jaríbake jaton reken papabaon senenhati jato yoikatitaibo. Ja axébo iká iki; vasobo chokati, chomoshokobo chokati, kentíbo chokati, itan jan oxati chopabo patsáti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jaskara iken, *fariseobo betan esé onan jonibaon, Jesús yokákana iki: —¿Jawekopiki ja mionmea onanaibaon, ja non reken papabaon axébo senenhayamakin, mechokiixonmabi pikanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jatian Jesussen jato neskáa iki: —Akontibira *profeta Isaíassen, mato beparametaibo iken yoikin, wishanike, neskáakin: ‘Nato jonibaonra, jaton kexakanres ea rabikanai. Ikaxbi jaton shinanra eaakin shinnakanti ochóbires iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yankabiresa ea rabikanai. Jabaonra jonibaon ati yoiai esébores jato onanmai’, iki inike. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Matonra Diossen yoiai esébo jenexon, ja jonibaon ati yoiai keskábores senenhai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jainxon jato yoiribia iki: —Maton axekan yoiai keskábores akinra akai, maton Diossen ati yoiaibo senenhayamakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiséssenra yoia iki: ‘Min papa betan min tita jakonhawe’. Jatian jaweratobaonki jawen papa betan tita jakonmaakin yoiai, jabora retekanti jake, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ikaxbi matonbiribi akai jato esekin, bakenra jawen papa betan jawen tita yoiti atipanke: ‘Enra mato akinti atipanyamake; ja ea jayata jawékibora moa corbán iki’, akin. Ja joi iki, (‘moa en Dios menia riki’) iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jainxonribi maton yoiai, moa jaskáa ixonra, ja baken jawen papa betan jawen tita moa akintiakin shinanti yamake, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaskákin matonbi shinanxon pikoa jawékibores jato onanmakinra, moa Diossen esébo jawemabi itiakin maton keyoai; jainxonra wetsa jaskara keská icha jawékiboribi maton akai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jaskáatanan, jain icha tsinkíkana jonibo kenaxon, yoia iki: —Rama jatíxonbipari en yoiai joibo ninkáxon, onankanwe: ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jawékiati piatoninra, joni jakonma imayamai, já meranoax jakonma shinan pikotaitoninkayara, joni jakonma imai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ninkataibo ixon, ninkákanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jaskátaanan jonibo potabaini kaax, xobo meran jikiketian, jaonmea onanaibaon yokata iki, ja jaki jato yoinwana jawékikiriakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jatian jato yoia iki: —¿Matonribikayaki jaskara joibo ninkáyamai? Jatíbi jawékiati piatoninra, joni jakonma imati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ja jawékiakanara, jaton shinan meran weíyamai, jaton poko meranres boax, moa ori jokonribiai —akin. Jaskáakinra, jato Jesussen yoia iki, jatíbi jawékiati jawékibora, jakon iki ixon onankanti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jainxon jato yoiribia iki: —Ja joni meranoax pikotai jakonma shinanmankayara joni jakonma imai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ja jonin shinan meranoaxkayara ikai jakonma shinanbo pikoti. Ja shinanbo riki neskara: Atima betanbires yoranti ati, yometsoti, joni reteti, wanoya itan benoya ixonbi wetsa betan yoranti, ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jabicho jawékia itin keenaires, wetsabaon jawékinin kenti, jakonma jawéki ati, paranmisti, meskó jawékinin cheati, jatoki notsiti, yoimisti, rabíti, shinankonaxmabi yoyo iresti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Neskara jakonma jawékibora, jonin shinan meranoax pikotai. Jaskarabaonra joni jakonma imai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jato jaskáatanan, Jesús Tiro main kaa iki. Jain nokotax, tsoabi onanmakashamai xobo meran jikia iki, ikaxbi, jonéti atipanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jatian, ja jakonma yoshin naikia bake ainbaon tita, jain Jesús iká ninkatax, ishto kaax nokótaanan jánaman chirankootoshita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ja ainbora iká iki judíoma, Sirofeniciainoa. Janra Jesús yokákin jeneyamaa iki, jawen bake meranoa yoshin pikoxonon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ikaxbi Jesussen yoia iki: —Oinpariwe. Abánon bakebaonpari pikín. Jakonma riki ja bakebo piti bichintaanan, ochitibo meniti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jatian ainbaon neskáa iki: —Ja min yoiara ikon iki, Ibó. Ikaxbi bakebaon pikin mesa naman pakéxshokobo maanketianra, ochítibaonribi piai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jaskáaketian Jesussen yoia iki: —Min ea jainshamainra yoia kopí, jakonbires katanwe. Ja min bake meranoaxa moa yoshin pikóke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jaskáakin yoia, jawen xobon kaxon oinna, jawen bake xontako bachi meran rakata iká iki, moa já meranoax yoshin pikóketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jatian Tiro mainmeax, moa karíbakin, Sidón winobaini kaax, Jesús Galilea ianman nokota iki, ja iká iki *Decápolis mainko. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jain iketianra, pabe itan yoyo iosma joni Jesússiba bekana iki. Jainxon Jesús yoikana iki; tii axon ja joni benxoaxonti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jaskáakana, ja icha jonibo ikainoa, wetsaorishoko ioxon ja jonin pabíki meran Jesussen jawen metoti niaa iki. Jainxon jawen keyonman, ja jonin jana tii axona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jaskáxon, nai bochiki ointaanan koshinshaman joinxon, ja joni yoia iki: “Efatá”, akin. Ja joi iki, “chopéwe”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jaskáatianbi, ja jonin pabíki chichó chopeta iki. Jainoax jawen jana, taponribi tapishitax, moa jakoni yoyo ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jaskáaxon, Jesussen jato yoia iki, jaskara akábo tsoabi keshantima. Ikaxbi jaskátima yoiabi, jatiankaya wetsabo keshanbotankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jatian jaskara ninkataanan, kikinbiresi ratetax, jonibo neskákana iki: —Jatíbira jakon akai. Pabebobira benxoaxon, jato ninkámai. Yoyo iosmabora, jato yoyo imai —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jatian ja netebaon jain iikanaitian, joni icha jatoki tsinkíribia iki. Jain tsinkitabo ikana iki, ja jawékiatiomabobi. Jaskara oinxon, Jesussen jaonmea onannaibo kenaxon yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Enra nato jonibo noibai. Moa kimisha neteira ebé ikaxbi, jawékiama ikanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jawékiamabi en jaton xobon raanabira, bain kaai paxnakanti iki. Jatíribibora ochokeax bekanabo iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jatian jaonmea onanaibaon Jesús, neskáakana iki: —Nenora tsoabi jakana yamake, ¿Jaweranoa jawékiati bixonki, nato jonibo non jawékiamatiki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jatian Jesussen jato yokata iki: —¿Matoki jaweti panya iki? —akin. Jatian yoikana iki: —Kanchis panra jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jaskákin akana Jesussen, jonibo yoia iki, mainbi yakákanti. Jatian moa yakákanketian, ja kanchis pan bixon Dios iráke ataanan, pan tobapakeanan jaonmea onannaibo menia iki. Jatian jabaonbiribi, ja jonibo menipakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jainxon jawetii yapa kopíribi Dios iráke ataanan, Jesussen jaonmea onannaibo menia iki, tekikin ja jonibo menipakenon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jatian piax, jatikaxbi potókana iki. Ja pikin texeakana pakexbo tsinkikana iká iki, kanchis tasá bocho. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jatian jan piábo ikana iki, chosko waranka jonibobira. Jaskáxon, moa jato Jesussen raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jato jaskáatanan Jesús, jaonmea onanaiboyabi boten nanetax, Dalmanuta janeya main kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jatian fariseobo beax, Jesús betan join iananankana iki. Jatian jaskáaxon jakonmain pakémakaskin, ratéti jawékibo anon ixon yokákana iki. Ikonkon Diossibakeax joárin ixon onannoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jaskáakana, koshin jointaanan Jesussen, jato yoia iki: —¿Jawekopiki nato jonibaon, ratéti jawékibo en axonon ixon ea yokákanai? Pontéshamanra en yoiai, enra mato axonyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jaskáatanan jato potabaini, jakiribi boten nanetax, ian keiba shitáribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jatian kakinbi, shinanbenoxon ja jawékiatibi boyamakana iki. Ikaxbi panyabichoshokores ja boten ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jaskara iken, koirameekanon ixon Jesussen jato yoia iki: —*Fariseobaon, itan Herodesnin *levaduraboki kikinni koirameekanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jatian Jesussenmea onannaibo jatobires yoyo iki, neskákana iki: —Non pan beyamaketianra abirake noa jaskáakin —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jaskákanai onanxon Jesussen jato yoia iki: —¿Jaweakiki, nonra pan beyamake iki mato iitai? ¿Matonkayaki ramakamanbi onanyamaresa? ¿Maton shinankayaki kikinni xepota keskábo iki? ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Beroya ixonbira, maton oinyamai, pabíkia riki mato, ikaxbira maton ninkáyamai ¿Matonki shinanyamai? ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ja pichika waranka jonibo, en pichika pan pimanontianki, ja texeabo ¿Jaweti tasá bocho maton bibata? —akin. Jatian yoikana iki: —Chonka rabé tasá bocho —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jatian ja chosko waranka jonibo, ja kanchis pan en pimanontianki, ¿Jawetii tasá bocho ja texeabo maton tsinkiibata? akin. Jatian neskáakana iki: —Kanchis —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jaskáketian Jesussen jato yoia iki: —¿Matonki ramakamanbi onanti atipanyamaa? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jatian boax, Betsaidanko nokóketian, westíora benche joni bexonkana iki. Jatianra tii axon, benxoati yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jaskákana, ja joni Jesussen metsonhanan, ja jemamea pikobainxon, jawen beronko keyoman beskixon, mamepastaanan yokata iki: —¿Minki moa ointi atipana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jatian yoia iki: —En oinna riki jonibo, jiwibo niai keská —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jaskáketian, Jesussen jakiribi betí aka, moa benxoxon jakonhakin oinna iki. Jatian jatíbi jan oinna jawékibo jishtishaman iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jaskáaxon, jawen xobon raankin, Jesussen yoia iki: —Moa jakiribi jeman kayamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Japekáo, jaonmea onanaiboyabi Jesús, ja Cesarea main iká, Filipo jema patax iká jemashokobaon bokana iki. Kakin Jesussen jaonmea onannaibo yokata iki: —¿Jonibaonki ea tsoa shinannai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jatian yoikana iki: —Jonibaonra shinannai mia jato *bautizanai Juan. Wetsabaonra yoiai mia Elías. Jainoax jatíribibaon mia yoiai iki, westíora *profeta —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jainxon, Jesussen jaonmea onannaibo yokata iki: —Jatian ¿Matonbiribiki, eaki tsoa ixon shinannai? —akin. Jatian Pedron yoia iki: —Mia riki *Cristo, Diossen katota —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jatian Jesussen jato yoia iki: —Tsoabipari jaskara jawékibo keshanyamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jatian Jesussen jaonmea onannaibo esekin peoa iki: —Ja jonin Bakera, kikinhakin masá tenemakanti jake. Ja judíobaon joni koshibo, itan *sacerdotebaon koshibo, jainoax esé onan jonibora, jaon keenyamanoxikanai. Jaskákinra retenoxikanai, ikaxbi jawen kimisha nete itin jirinoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jaskara jawékira onantiakin jato yoia iki. Jatian Pedron jabichobiribi okeshoko boxon notsina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ikaxbi Jesussen jakiribi joxon, jaonmea onannaibo ointaanan, Pedro notsina iki neskáakin: —Moa eibakeax, katanwe *Satanás. Diossen shinannai keskákinra min shinanyamai. Jonibaon shinannai keskáresa min shinannai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jaskáatanan Jesussen, ja icha joniboyabi, jaonmea onannaibo kenaxon, yoia iki: —Jaweratoboki, eonmeax axeaibo ikasai, jaton shinannai keskábo akin jenexon, masá tenetibo ikenbi, ea chibankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jaweratoboki, mawákashamai, jabora manotiain bokanti iki. Ikaxbi jaweratoboki, ea kopi itan nokon joi yoiai kopí mawatai, jabora jatíbitian jakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Jawe jakonrin westíora joni nato netemea jawékibo kaiayontaananbi mawata? ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iamax ¿Joninmein jawetii kopíati atipanke janoxon? ");
INSERT INTO shpNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jatian jaweratoboki, eki itan nokon joi yoitininbo, ja Diossibakeax ochotabo, itan ochaya jonibo bebonmeax rabinai, jatíanra ja jonin Bakeribi, jawen Papan koshi shinanya, itan jawen ángelboyabi joáx, jaskara joniboki rabinshokoti iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jatian Jesussen jato yoiribia iki: —Ikonshamanra en mato yoiai; Neno mato jatíribi japariabora, mato mawáyamaparinoxiki, ja Diossen ikinnaton jatí nete, jawen atipana koshiabi nokotai oinnai kaman —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jatian sokota nete pekáo, westíora manan keyá ikain kakin Jesussen ioa iki: Pedro, Jacobo, jainoax Juan. Jatian jain kaax jato bebonmeaxbi Jesús wetsaresibia oinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jaskatax jawen chopa kikinbires pené itan joxoshaman baneta iki. Jaskara joxoakinra, tsonbi chopa patsáisma iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jatian jaskáaketian, Elías betan Moisés, Jesús betan yoyo ikai oinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jatian, Pedron Jesús yoia iki: —Maestro, Jakonhira riki noa neno iká. Non kimisha peota abanon; mina westíora, wetsa Moiséssena, wetsa Elíasna —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jatian jain ikana Jesussenmea onannaibo, kikinbiresi ratékana iká iki. Jaskáakin yoitibobi moa Pedron onanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jaskákenbi, jatoki nai koin bexon, jato mapoa iki. Jatian ja koin meranoax, neskati yoyo ika iki: —Nato riki nokon noi Bake, jawen joi ninkaxonkanwe —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jatian jaskáketian, oinyaketankanabi, moa jabé iwanabo yamaaxbi, Jesúsbichores jain iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jaskata pekáo, moa mananmameax ipakekin, Jesussen jaonmea onannaibo yoia iki, jaskara oinkanabo tsoabipari jato keshantima. Ja jonin Bake ratekanabi, jiriai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jaskáakin jato yoia, tsoabi keshanyamakana iki. Ikaxbi jatobiresbiribi yokakanani ikana iki, jawe keska yoiiki iká, eara mawataxbi, jiriribinoxiki iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jaskáxon, Jesús yokákana iki: —¿Jawekopiki Elíaspari joti esé onanbaon yoiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jatian Jesussen jato yoia iki: —Ikon riki, Elíasparira joái. Janra jatíbi jawékibo benxoati jake. Jatian ¿Jawekopiki Wishá meran yoiai, ja jonin Baken masá teneti, itan jaon keenyamakanti? ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ikaxbi enra mato yoiai, Elíassa moa jonike. Já jokenbira, jaton keena keskáakinres akana iki. Ja joni jaskáakanti Wishá meran yoiai keskáakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jatian moa jakiribi ja jatíribi jaonmea onannaibo ikainko boxon oinkana iká iki, icha jonibaon jato katea itan esé onan jonibo betan join iananani. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jaskati iikinbi, Jesús joaitian oinnax, ratétaanan ishto boxon, saludankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jatian Jesussen jato yokata iki: —¿Jawe yoiiki mato jabo betan join iananani iitai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jatian westíora jain itinaton yoia iki: —Nokon bakera en mia bexonke, Maestró. Nato nokon bake meran yoshin naikixonra yoyo iosma banémaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jaweranoki já kaai, jainxonra akai ja yoshinman beyósaxon mai tsakamaa, bakox kespoxon, xeta keróx akin itan saki iki chorishi. Moa paxnayona riki. Ja mionmea onannaibo, nokon bakemea yoshin pikoxonon ixon en jato yoiabira, jabaon ati atipanyamakanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jatian Jesussen jato neskáa iki: —¡Dioski koshiama jonibo riki mato! ¿Jawetian kamankayaki mato betan ea iti iki? ¿Jawetian kamanki mato jaskara iketian en teneti iki? Ja bake ea neri bexonkanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jaskáa ja bake bexonkanketian, yoshinman, ja Jesús oinxon, ja bake mai tsakamaa, bakox kespoti tarameeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jatian Jesussen, ja baken papa yokata iki: —¿Moa jawetio basirin neskatai? —akin. Jatian jaskáa yoia iki: —Baketianbi jaskati peokoota riki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ichakinbora, ja yoshinman retekaskin, chiikibo pakémai, itan jenebo tsakamai. Jaskara iken, atipanxon, noibaxon noa akinwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jatian Jesussen yoia iki: —¿Jawekopiki mia ikai, atipanxon, noa akinwe iki? Ja Dioski koshiabaonara, jatíbi atibires iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jaskáakin aká, ja baken papa koshin neskata iki: —¡Enra Dios ikonhai. Ea jaki bebonbires koshinon ixon ea akinwe! —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jaskáakenbi, icha jonibo jaki beai oinxon, Jesussen ja yoshin notsinkin, neskáa iki: —Miara en akai, yoyo iosma, itan pabe yoshinmá. Nato bake meranoax pikówe, moa jakiribi, ja bake meran jikiwetsayamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jaskáakin yoia, yoshin sion itaanan jakiribi ja bake maxkamaax, já meranoax pikota iki. Jatian ja bake mawá keska rakata iki. Jaskara oinnax, ja icha jonibo moara mawáke iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ikaxbi Jesussen, metsonxon wenina, ja bake moa nia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jaskáa pekáo, Jesús westíora xobo meran jikia iki. Jain iketian, jaonmea onanaibaon jatobichoxon yokákana iki: —¿Jawekopiki ja yoshin non pikoti atipanyamawana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jatian Jesussen jato neskáa iki: —Jaskara yoshinra, oración betan *ayunoninres non pikoti atipanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jatian moa jaskáa pekáo, Jesús jaonmea onanaiboyabi, Galilea main shitabaini bokana iki. Ikaxbi Jesús keenyamaa iki, jain kaa tsonbi onantinin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jara jaskata iki jaonmea onannaibo neskáakin eseti kopí: —Ja jonin Bakera, jonibo yatamaxon retenoxikanai, ikaxbira, kimisha nete itin jirinoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jaskákin yoiabi, jabaon onanti atipanyamaxon, jakiribi yokáti onsatankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jatian jaskábaini boax, Capernaúm jeman nokókana iki. Jatian moa xobo meran weixon, Jesussen jaonmea onannaibo yokata iki: —¿Jawe jawéki yoiiki mato bain joi, join iananani iikiranwana? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jato jaskáabi, jawebi yoyo iamakana iki. Ja jatobiresbiribi tsoamein iki nooxaran noa xewina kikin iki iibeirawankana ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jatian yakáxon Jesussen, ja chonka rabé jaonmea onannaibo, kenaxon jato yoia iki: —Jaweratoboki ja kikin itin shinanmeetai, jabora kikinmanin shinanmeeti jake. Jainxon jatíbi jato akinnairibi iti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jato jaskáatanan, westíora bake, jato napon nichina iki. Jatian bitaanan ikóxon jato yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Jaweratobaonki nokon janenko nato keska westíora bake biai, jabaonra ea bike; jatian ja ea biabaonra, jan ea raana nokon Paparibi moa bike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jatian Juanman yoia iki: —Maestró, nonra oinhibake westíora jonin, min janenko wetsa jonimea yoshin pikoai. Ikaxbi noobetan niai ixonmabi aketianra, moa non atima yoiibake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jaskákanketian Jesussen yoia iki: —Atima yoiamakanwe. Ja nokon janenko ratéti jawéki akaibora, eki jakonmaibo yoyo iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jaweratoboki noki ramíamai, jabora nobé rabetaibo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jaskara iken, jaweratobaonki mato Cristonabo onanxon, westíora vaso onpaxtanibires mato xeamai, ikonshamanra en mato yoiai, jabaonra jaton biti jawékibo bikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ikaxbi jaweratobaonki ja bake keska nokon joi ikonhaibo, jato ochan pakémai, jabora jan reneti makan ani teomaxon, aniparonko potati, bebonbires jakonma castigo bikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jaskara iken, min mekenman mia ochamai iketian, xatewe. Jakonra iti iki benkex mekenyabichokaya mia jati netenko jikia, ja rabé mekenyanix, chiikan ewa meran katitianbi. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jainra jawetianbi chii nokayamai ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Jatian min taen mia ochamai iketian, xatewe. Jakonra iti iki ja rabé taeyabi mia chiikan ewa meran katitianbi, benkex taeyabicho mia jati netenko jikia. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja min beron mia ochan pakémai iketian, tsekawe. Jakonra iti iki, westíora beroyabicho ja Diossen ikinnaton jati netenko mia jikia, ja rabé beroyanix chiikan ewa meran potatitianbi, ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ja jawetianbi mawáyosma xenabo, itan ja chiiribi jawetianbi nokayamainko. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Diossenra jatíbi jakonhanoxiki, ja tashín axon iamaxon chiikan menoxon jawéki jakonhati keskáakin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tashira jawen moka toxkotama ikax, jakon iki. Ikaxbi moa jawen moka toxkóketianki ¿Jawe keskaxon non moka imaribiti iki? Jaskara iken, ja tashi keska jakon ikanwe, jakon jawékibores akí, jatíbibo betan jakonax jakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jatian Capernaúmhainoax, Judea main Jesús kaa iki; ja Jordán wean keiba. Jain Jesús iketian, icha joni jakiribi jaiba tsinkíkana iki. Jatianra, moa apachoai keskáakin jato eseribia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jato jaskaí iitaitian, jatíribi *fariseobo jaiba bokana iki, já jakonmati shinanyanix, jainxon yokákana iki, neskákin: —¿Akiatiki jonin jawen awin potakin? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jaskáakana, Jesussen jato yoia iki: —¿Jawekeskaatiki mato Moiséssen yoia iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jatian yoikana iki: —Moiséssenra yoia iki onanti inon ixon, kirika wishaxon menianan ainbo potati —akin akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jatian Jesussen jato yoia iki: —Maton keena keskábores akaibo iketianra anike, Moiséssen jaskáxon awin potatibo mato yoikin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ikaxbi nete peokin jonianontianbira, Diossen benbo betan ainbo joniaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jakopira moa wanoxon jonin jawen anibo jeneti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jaskataxa ja rabébi moa westíora yorayabicho keská ikai. Jatianra moa rabé imai, westíorabicho ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jaskara ikenra, ja Diossenbi jato biananamaabo ikax, jawekeskataxbi moa potaanankanti yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jatian xobon kaketian, jaonmea onanaibaon ja joikiriakin yokáribikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jatian Jesussen jato yoia iki: —Jaweratobaonki, jaton awin potaxon, wetsa ainbo biai, jabaonra wanoya ixonbi wetsa betan yorankin, jaton reken awin yosmai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jatian ainbaonribi atiki, jawen bene potaxon wetsa joni bikin, jatianra benoya ixonbi wetsa betan yorankin, jawen reken bene yosmai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jatian jain Jesús iitaitian, jaiba jonibaon jaton bakebo bokana iki, jakon ikanon ixon mamepasmakin. Ikaxbi jaonmea onanaibaon jato notsina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jatian jaskákanaitian oinnax Jesús sinata iki, jainxon jaonmea onannaibo yoia iki: —Ja bakebo chiteyamakanwe, ibakanon eiba bei. Ja Diossen ikinnaton jati netera, ja bakebo keská ikaibaona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ikonshamanra en mato yoiai, jaweratobaonki baken akai keskáakin ja Diossen ikinnaton jati nete biamai, jabora jain jikitima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jato jaskáatanan, bakebo ikótaanan jakon ikanon ixon jato mamepasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jatian Jesús jakiribi, moa wetsanko karibai iitaitian, westíora joni ishto joáx, já bebon chirankootoshixon, yoia iki: —Jakon Maestro ¿Jawe jawékiki en ati iki jati neteya inoxon? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jaskáketian, Jesussen yoia iki: —¿Jawekopiki min ea jakon Maestro akin akai? Tsoa jonibira jakon yamake, Diosbicho riki jakon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Minra moa onanke, ja senenhati Diossen yoia esébo. Ja esé meran yoiai: Retemistima, wanoya itan benoya ixon wetsa betan yorantima, yometsotima, wetsaboki jakonmai jansoi yoyo itima, paranmistima, itan papa betan tita jakonhawe iki iká —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jatian ja jonin yoia iki: —Bakeranontianbira jaskara esébo en senenhaa iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jatian Jesussen noibaxon ja joni beisa iki; jaskáxon yoia iki: —Westíora jawékiresa mia maxkáke. Jatíbi mia jayata jawéki marotanwe, jatian jakopi koríki bixon, ja jawékinin maxkatashokobo jato menitanwe. Jaskáaxparira naikan, icha jawékia mia iti iki. Jaskáax, ea chibani jowé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jaskáakin yoia ninkataanan, masá shinanni ja joni kikin onís kaa iki. Ichaira jawékia ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jatian Jesussen jatíbi jato oinyaketanxon, jaonmea onannaibo yoia iki: —Itibiresma riki, ja icha jawékia jonibo Diossen ikinnaton jati netenko jikiti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jaskáakin yoia jaonmea onannaibo ratékana iki. Jaskakenbi, Jesussen jato yoiribia iki: —¡Itibiresma riki ja Diossen ikinnaton jati netenko jikiti, bakebó! ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jatian camellora ani yoina ikaxbi, xomox chipekenin jikiti itibires iki, ikaxbi icha jawékia joninara, ja Diossen ikinnaton jati netenko jikiti kikin itikoma iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jaskáakin Jesussen jaonmea onanaibo yoia, jatiankaya ikonbiresi ratékana iki. Jaskatax jatobiribi yoyo ikana iki, neskati: —Jaskara iken ¿Tsoamein iti atipanke kishpinmeeti? —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jatian Jesussen jainbikon jato oinxon, yoia iki: —Ikon riki, jonibaonara atikoma iki, ikaxbi Diossenara, jatíbi jawéki atibires iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jatian Pedron yoia iki: —Jatíbi noa jayata jawékibo potabeiranira mia chibani noa joá iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jatian Jesussen neskaa iki: —Ikonra en mato yoiai, jaweratobaonki jaton xobo, jaton wetsabo, jaton poibo, jaton tita, jaton papa, jaton bakebo, itan jaton wai; ea kopi, itan jan kishpinti jakon joi yoii kakin jenebainai, ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jabaonra nato netenxonbi binoxiki, jaton xobo, jaton wetsabo, jaton poibo, jaton titabo, jaton bakebo, jaton waibo, jenebaina bebonbires. Jainxon ramiaxon masá tenemakana meranbira, Diossenbiribi jawen keyóyosma bená netenko jato jakinnoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jatian rama icha jonibo jato xewinaton, shinanmeetaibora, namanbires inoxikanai. Jatian namanbires shinanmeekatitaibora, jato xewinabo inoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jainoax moa Jerusalénhain kaai, jaonmea onannaibo bebon Jesús kaa iki. Jaskáketian jaonmea onannaibo ratékana iki, itan japekáo boaibobiribi rakékana iki. Jaskákanainbi, ja chonka rabé jaonmea onannaibo kenaxon jatobiribi wetsaori ioanan, jaskara já winótibo Jesussen jato neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Matonra oinke noa Jerusalénhain kaai iitai. Jain kaketianra, ja jonin Bake yatanxon, ja *sacerdotebaon koshiboiba itan esé onanboiba bokanti jake. Jaskáaxonra, ja judíomabaon retenon ixon jato menikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jaki shirokinra kenyoman betoshba akanti iki. Jainxonra rishkikanti iki. Jaskaáxonra retenoxikanai. Ikaxbi jawen kimisha nete itinra, jirinoxiki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jatian Jacobo betan Juan, ja Zebedeon bake rabé, Jesússiba kabékonxon, yokákana iki: —Maestró, ja mia non yokatai jawékibo min axontininra noa keenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jatian Jesussen jato yokata iki: —¿En jawe axontininki mato keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jato jaskáa yoikana iki: —Min neten apo jikixon noa rabébi mii pataxbi yasántininra noa keenai; westíora min mekayao jainoax wetsa min mexkao —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jatian Jesussen jato yoia iki: —Maton ea yokatai jawékira maton onanyamake ¿Ja moka jawéki en xeairibiki maton xeati atipana? Iamax ¿Ea bautizameetai keskatiribiki mato iti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jatian yoibekona iki: —Nonra atipanke —akin. Jatian Jesussen jato yoia iki: —Ikonrake, ea iki kaai keskatiribira mato onitsapinoxiki itan mato mawáti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ikaxbi ja nokon mekayao itan ja nokon mexkao mato yakámatira, en mato imati jawékima iki. Jara ja jain iti shinanxonabaonares iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jato jaskáa ninkatax jatíribi ja chonka jaonmea onannaibo ja Juan betan Jacoboki sinákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ikaxbi Jesussen jato kenaxon yoia iki: —Matonra onanke ja Dios ikonhaayamai joni koshibaon, itan onan jonibaon jaton ikinna jonibo jaton keena keská jato akanai, itan jato ikinai jonibaon iboataanan akonbireskin jato yonokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ikaxbi matora jaskáti yamake. Jaweratoboki mato xarameax kikin joni ikasaibo iki, jabora wetsabo teexonai iti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jaweratoboki jato xewina ikasai, jabora wetsabaon iboaxon yonokanai iti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ja jonin Bakera, jonibaon akinkanon ikax joáma iki, jara joá iki jonibo akini itan icha jonibo kishpinmanox jato kopi mawati —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jatian jaskatax boax Jericóain nokókana iki. Ja jemameax kakin Jesussen jaonmea onanaiboyaxonbi, itan jato chibani boai icha jonibaon kakin oinkana iki; Timeon bake Bartimeo, benche ikax baikexa jawéki menikanon ixon jato yokati yakata. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jatian ja benchen, Nazarethainoa Jesús moa joí ochómaitian ninkáxon saí aka iki: —¡Jesús, Davidkan Baké, ea noibawe! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jaskati saí ikaitian ichaxon netémakaskin notsínkana iki. Ikaxbi jatiankaya bebonbires koshin: —¡Ea noibawe Jesús, Davidkan Baké! —iki saí ika iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jaskáa chankáxon Jesussen jato yoia iki: —Ea kenaxonkanwe —akin. Jatian ja benche kenakin neskáakana iki: —Koshiakin shinantaanan jikiwe; miara kenai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jaskáakana jan perakoota chopa jopetax potabeirani westíorai chorontaanan, Jesúski joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jatian Jesussen yokata iki: —¿En mia jaweatiki mia keenai? —akin. Jatian ja benchen yoia iki: —Min oinmatinra ea keenai Maestró —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jaskáa Jesussen yoia iki: —Moara mia kati atipanke, eki koshiaxa mia benxoke —akin. Jaskáatianbi ja benche iwanaton moa oinna iki. Jaskatax moa Jesús chibani bain kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jatian moa Jerusalénhain nokóti ochóma, ja Betfagé betan Betania jema bekeiba iká Olivos janeya mananman nokóxon, jaonmea onanai rabé Jesussen raana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","neskáakin yoixon: —Noa ponte iká jemashoko ikainko kabékontanwe. Jain kaxonra tsoabi jan peyakai peokootamapari burro bake nexakana maton nokoi kaai. Ja choroxon ea bexontankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jatian jaweatiki maton choroai akin mato yokákana, jato yoitankanwe: Non Ibora jan keenai. Ramabishokora mato non jakiribi bexonai akin atankanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jaskáakin yoia kabékonxon baikexa iká xobo xepotiain nexaa burro bake nokoxon chorokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jatian jatíribi jain ikábaon jato yokákinkana iki: —¿Jaweakiki mato iitai? ¿Jaweatiki ja burro bake maton choroai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jatian Jesussen jaskáakin yoiti yoiwana keskáakin yoibekona, jato bomareskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jaskáaxon burro bake Jesús boxonkana iki. Boxon jaton taribaon pekakaaxonkana, Jesús jan peyakax kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jatianra kaaitian jaon rarokin ichaxon jaton taribo bainapo kakaaxonkana iki. Jatiribibaonbiribi pei xatexon bainapo tipinxonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jatian ja rekenain boaiboyabi ja chinitain beaibo neskati koshin saa ibainkana iki: —¡Noa kishpinmawe! ¡Nonra mia jowé akai, mia riki ja Ibon janenko joái! ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nonra mia jowé akai, mia riki non apo; ja non papa David ipaoni keskáribi! Noa kishpinmawe non ani Diossé —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jatian kaax, Jerusalénhain nokotax, Dios rabiti xobon jikia iki. Jain jikixon, jatíbi jawéki oinkin senenhatanan, moa yantan iketian, jawen chonka rabé jaonmea onanaiboyabi Betaniain kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jatian nete xabáketian, jawen joniboyabi Betaniainoax kaai, Jesús jawékiakasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kakin ochóxonbi, higo icha peia merataanan, bimiara ibirai ixon oinni kaa iki. Ja kaxon oinnabi, pei ichayares iká iki, jawen bimititianmapari ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jatian jaskara oinxon, Jesussen ja higo yoia iki: —Ramara jawetianbi, mionmea tsonbi bimi kokoyamanoxiki —akin. Jaskaitian jaonmea onanaibaon ninkata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jaskáabaini boax, Jerusalénhain nokókana iki. Jain ikax, Dios rabiti xobo meran Jesús jikia iki. Jaskáxon, ja jainoa jato maromaibo, itan jato maroxon bixonaibo jokonhaa iki. Ja koríki cambianaibaon mesabo jato werananpakea iki, itan ja xotó jato maromaibaon yakátiboribi jato werananpakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jatian Dios rabiti xobo meran, jawe jawékibi botima jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jainxon jato esekin neskáakin, yoia iki: —Wishá meranra yoiai: ‘Nokon xobora iti jake, jatíbiainoa jonibaon jainxon orankanai xobobiribi’. Ikaxbi matonra imake jainoax yometsoti xobo —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jato jaskáaitian ninkatax, ja *sacerdotebaon koshibo itan esé onan jonibaon ninkata iki. Jatianra rakékin, jaskáaxon Jesús reteti benakana iki. Jatíbi jonibo Jesussen joi yoiaitian ninkatax ratékanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jatian moa yaméketian, Jesús, jaonmea onanaiboyabi ja jemameax moa boribakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jatian nete xabáketian, jakiribi yamékiri kakin oinna, ja higo nia iibata moa taponyabi tanoa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jatian jaskata ointaanan shinanrixon, Pedron, Jesús yoia iki: —Oinwe, Maestro. Ja jakonmaanon ixon min yoiibata higora moa tanoke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jatian Jesussen yoia iki: —Dioskires koshikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Enra mato ikonshaman yoiai, jawekeska ixon, westíora jonin atiki Dioski koshixon, nato manan neskáakin yoikin: Nenoax tsekékaini kaax, aniparon pakétanwe akin. Jatianra Diossen imaxonti iki, ponté shinanxon, ja en yoia keskára ea imaxonai ixon ikonhaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jakopira en mato yoiai, jatíbi maton oración meran yokatai jawékibo, moara non bike ixon shinanxon akanwe. Jatianra maton biti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jawetianki maton oranai, ja wetsaboki mato jakonmaatabo moa shinanxonyamakanwe. Ja naikanmea maton Papa Diossenribi, maton ochabo moa shinanxontima kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ikaxbi jawetianki, jatoki jakonmaata ixonbi, maton ja shinanxonkin jeneyamai, jatianra ja naikan iká non Papa Diossenribi maton ochabo shinanxonkin jenetima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jaskatax Jerusalénhain, boribakana iki. Jain kaax, Dios rabiti xobo meran Jesús jikiax kawantanaitian, *sacerdotebaon koshibo, esé onanbo, itan judíobaon joni koshibo, jaki bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jatian jabaon Jesús yokákana iki: —¿Jawe koshi ixonki akai min jaskáakin? ¿Tsonki mia jaskáati yoia? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jatian Jesussen jato yoia iki: —Enribira rama mato yokatai. Maton ea yoiketianra, enribi mato yoiti iki, tson yoiatonki jaskarabo en akai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tson ati yoiaki, Juanman jato bautizana iki ¿Diossen, iamax jonibaon ati yoiaki aká iki? Ea yoikanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jatian jato jaskáakin yokatabi, jaskáshamanhakin yoiti atipanyamaxon, jatobiribi yokakanani neskákana iki: —¿Nonki jawekeska yoiti iki? Diossen jaskaáti yoiara jato imaa iki, akin non akábira: ¿Jawekopiki maton ikonhayamaa iki? Akin noa ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jatian jonibaon ati yoiara aká iki, akin non akábira, noki jonibo ramíti iki —iki ikana iki. Jaskárakana iki, ja Juan jatíxonbi *profeta onankana iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jaskákinra, Jesús yoikana iki: —Nonra onanyamake —akin. Jatian Jesussen jato yoishokoa iki: —Jaskara iketianra, enribi mato yoiamai, tson yoiatonki en jaskarabo akai ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jatian jakiribi, jawékikiriakin yoinhanan esekin jato Jesussen neskaa iki: —Westíora joninra aká iki, jawen wainko uva banakin. Jaskáaxonra ja wai katemakin chiketa iki. Jainxonra uva potsiti shanka nachina iki. Jaskaáxon westíora torre aká iki jainxon koiranti. Jaskáayonxonra jaweti teetai joni, jawen uva wai menia iki, jain teekanon ixon. Jato jaskáa pekáo ja wai ibo ochó kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jatian uva tsekati senenketian, ja wai ibon jawen yonoti joni jatoiba raana iki, ja jan bititii jatíribi uva bimi jatoibakea bixonon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ikaxbi raankenbi ja jonibaon yatanxon rishkionxonres, jawebioma raankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jaskáakanketianra, wetsa jawen yonoti jatoiba raanribia iki; ikaxbira tsakaxon maxteyonkana iki. Jaskáax jakonmaibiresbo jaki yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jatianra wetsa jawen yonoti raanribia iki, kakenbi jaribi retekana iki. Jaskákana pekáora, icha jawen jatíribi yonotibo jato raanribia iki. Jatianra bokanketian, jatíribibo rishkionkana iki, itan jatíribibo retekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Jatianra moa westíora joniabichoshoko baneta iki. Já iká iki, jawen noi bake. ‘Jara senentiainbi raana iki, jara ea jakonshamanxonres bixonkantiki ixon shinantaanan’. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ikaxbi ja raana joaitian oinnax, ja jakonma shinanya teetai jonibo yoyo ikana iki: ‘Nato riki ja jawen papan wai jan biti. Retenon akanwe, jatianra noakaya wai ibo iti iki’, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jaskáxon yataanan, ja wai ibon bake retekana iki. Jaskáaxon jawen yora waimaan boxon, potakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Jatianmein ja wai ibon jato jaweati iki? Jaweamakan kaxonra, ja teetai jonibo reteti iki. Jaskaáxonra, wetsabo jawen wainko imati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Matonki ja wishá meran iká joibo yoyo ayosma iki? Ja Wishá meranra ikai neskati: ‘Ja xoboaibaon, rotokana makanra, jákaya jaki kikini xobo koshiti makan baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Natora Diossenbi imaa iki, jakopíra noa ikonbiresi ratékanai’ —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jatian jawékiki yoinhanan, jatobi yoikin aká onanxon, Jesús yatankaskana iki. Ikaxbi joniboki rakékin, moa jaweayamakin potabainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jaskata pekáo, jawetii *fariseobo betan Herodes rabékinaibo, Jesússiba raankana iki. Jabaon kaxon yokata jakonmaibo Jesús yoyo iketian, ramiati shinanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jatian raankana kaxon, Jesús yokákana iki: —Maestro, nonra onanke min ikon joibores yoiai. Minra ja min jato onanmaibo yoii ikanainbi jato ninkáxonyamakin, jaskatax Dios keenai keskati jakantiakinres jato onanmai. Jakopira mia non yokatai: ¿Jakonrin ja apo kopíati yoiai non meniti? ¿Nonki kopíatiki o akáma? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ikaxbi beparankinres akanai onanxon, Jesussen jato yoia iki: —¿Jawekopiki maton ea jakonmain pakémati shinanxon tanai? En oinnon ja koríki ea neri bexonkanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bexonkanketian oinxon, jato yokata iki: —¿Tsoa jisárin itan tson janerin nato koríkiain iká? —akin. Jatian yoikana iki: —Césarna riki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jatian Jesussen jato yoia iki: —Jaskara iken, ja Césarna iketian César menikanwe. Jatian Diossenabiribi Dios menikanwe —akin. Jato jaskáakin yoia ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jatian jawetii *saduceobo, Jesús oinni bokana iki. Jabo ikana iki, mawatax jirikanti ikonhayamaibo. Jakopi jakiriakin Jesús yokákana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestró, Moiséssenra noa neskara wishaxonike: Westíora wanoya joni jawen awin betan bakeamabi mawáketian, jawen wetsan ja kachiana ainbo biti. Bixon, jabé bakea, ja bake moa ja mawata jonina ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jatian jaráa iki, kanchis jawetsabires. Jaton rekenra japari wanoaxbi, bakeamabi mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jatianra, japekáo iká jawen wetsan, ja ainbo bia iki. Ikaxbi jabé bakeaamabiribi mawata iki. Jatian jaskaribi, ja kimisha itin iká jawen wetsa winota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jaskatax, ja kanchis wetsabi ja ainbo bixon jabé bakeaamabi mawati keyókana iki. Jatian senentiainbi, ja ainboribi mawata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jaskara iken, ja kanchisxonbi awinhani ikaxmein, ja jiriti nete nokoketian ¿Jaweraton awin inoxiki ja ainbo? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jatian Jesussen neskaa iki: —Matora shinan meran benotabo iki. Ja wishá meran yoiai joibo, itan Diossen atipana koshi onanyamaa kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ja mawábo jiriaxa tsoa jonibi wanoyamanoxiki, itan tsoa ainbobi benoyamanoxiki. Jatianra ja naikanmea ángelbo keskáres inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jatian ¿Ja mawatabo jiriti, ja Moiséssen wishani meran yoiaiboki maton yoyo akama iki? Jainra yoiai ja zarza jiwi tiritai meranxon Diossen neskáakin Moisés yoini: ‘Ea riki, Abrahamman Dios, jainoax Isaacnin Dios, itan Jacobnin Dios’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jara mawábaon Diosma iki, jara jiriabaon Dios iki. Matora shinan meran benotabo ikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jatian jainshaman jato Jesussen yoia ninkatax, westíora esé onan joni joxon, yokata iki: —¿Jawerato senenhati joikayarin, ja jatíbi esébo xewina? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jatian Jesussen yoia iki: —Ja jatíbi esébo xewina senenhati joi riki, neskara: ‘Ninkákanwe *Israel jonibo, ja non Ibo Diossiki, jabichores non Ibo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Akonkin; jatíbi min jointiaxonbi, min kayayaxonbi, min shinanyaxonbi itan min koshiaxonbi min Ibo Dios noiwe’, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Japekáo iká riki: ‘Minbix noikaata keskáribiakin, wetsaboribi noiwe’, iki iká. Yamarake wetsa neskara esé xewina, japari non senenhati —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jatian esé onan jonin yoia iki: —Ikonra min yoike Maestró, westíorabicho riki non Dios, wetsara moa já pekao yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jaskara iken, ja non jointiaxonbi, jatíbi non shinanyaxonbi, jatíbi non koshiaxonbi Dios noiti, itan nonbix noikaata keskáribiakin wetsabo noiti riki, ja jatíbi Dios menitibo itan jainxon Dios yoina menoxonti bebonbires jakon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jatian ja esé onan jonin, jakonhakin yoiketian, Jesussen neskaa iki: —Miara ja Diossen ikinaton jati netenko moa jikitires iki —akin. Jatian jaskáa pekáo, moa yokáribiti onsatankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jatian Jesussen, Dios rabiti xobo meranxon, jato esei iikinbi, jato yokata iki: —¿Jawekopiki ja esé onanbaon, ja Cristora Davidkan bake iki ixon yoikanai? ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ja David inike, Diossen Shinanman imaa, já yoii neskati: ‘Ja Ibonra yoia iki, ja nokon Ibo: Nokon mekayao yakáwe, ja min rawibo en mia jatoaresmai kaman’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja Davidkanbi, Ibó akin akai ikaxki ¿Jawe keskatax ja *Cristo Davidkan bake iti atipana? —akin. Jatianra ja icha jonin, keenshamanxon ja Jesussen yoiaibo ninkákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jatian jato esekin, Jesussen yoia iki neskákin: —Esé onanbo ikai keskati jayamai koirameekanwe. Jabora ikai, tapó chopa sawéyabores kawanhatani, itan icha jonibo tsinkitain kaketian jakonhakin saludankantininbores keeni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jain tsinkiti xobo meran jikiaxbo ikanai rekenaishaman yakátininbores keeni, itan jakonshaman ikainxonbores pitin keeni. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jainxonra ja benomaatabaon xoboboribi jato bichinkanai. Jatian jato jaskáax, paranakin akanai kikin nenkébo orankin. Jabora, Diossen kikinbiresakin, masá tenemanoxiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jatian Jesús yakata iká iki, Dios menikin jain koríki napóxonkanai ponté. Jainxon oinna iki, Dios menikin napókanaitian. Ja icha koríkiabaon, icharibi akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jaskaai iikanainbi, westíora jawebioma benomaata ainbo joxon, Dios menikin rabé chorish koríkishoko nanea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jaskáketian, oinxon jaonmea onannaibo tsinkixon, yoia iki: —Ikonshamanra en mato yoiai, nato jawebioma benomaata ainbaonra, jatíbibo xewinbainbires, Dios koríki menike. ");
INSERT INTO shpNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Icha koríkiabaonra, jaton koríki texeabores menike. Ikaxbi nato ainbaonra, jawebiomashoko ixonbi jatíbi já jayata koríkishoko Dios menike —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jatian Jesús, Dios rabiti xobomeax pikotaitian, westíora jaonmea onanaitonin yoia iki: —Maestró, oinwe nato makan akana ani xobo, jainoax jawen chikéribi metsáshaman —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jatian Jesussen yoia iki: —Nato ani xoboakana min oinnara, jatíbi ras inoxiki. Westíora makantanibira, jabé makanki perakaa yamanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jaskata pekáo, Olivos mananman bokana iki. Ja manan iki, Dios rabiti xobo iká bekeiba. Jain Jesús yakata iketian, oinnax jaonmea onannaibo bekana iki. Jabo iká iki; Pedro, Jacobo, Juan, Andrés. Jabaon jatonbiribi Jesús yokákana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Noa yoiwe ¿Jawetianki, ja min yoia keská jawékibo iti iki? ¿Jawe keska jawékibo ikai oinxonki moa nete senenti ochóma non onanti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jatian Jesussen jato yoia iki: —Mato tsonbi, paranyamanon koiranmeekanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eki yoimeetaxa icha benóxikanai, jabora inoxiki: ‘Ea riki Cristo iki ikaibo. Jaskaáxonra, icha jonibo jato paranoxikanai’. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jatian wetsankobo reteanankanaibo, itan moa reteanantibores ninkataxbi, ratéyamanoxikanwe. Jaskarabora iti jake, ikaxbira, nete senenamapari inóxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jainoaxibira, nato mainmeabo betan wetsa ochó mainmeabo reteananoxikanai. Jainoax apobora, wetsa ochokea apobo betan reteananoxikanai. Wetsanko, wetsankobora niwannoxiki Jainoaxibira jawékiatinin inoxikanai. Jaskara onitsapiti jawékibora, ja peokooti ikaibopari iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jaskara iken, kikini koirameekanwe. Matora yatanxonbo joni koshiboiba bonoxikanai. Jaskáxonra, ja jain tsinkíti xobo meranxonbo mato rishkinoxikanai. Ea kopira joni koshiboiba, itan apoboiba mato bonoxikanai. Jatian jaskarainbo bokanara, nokon joi maton jato yoinoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja nete senenamatianbira, jatíbiainpari ja ikon joi yoikaati jake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jaskáakin mato bokana, jawerakimein en jato yoiti iki ixon maton masá shinantima iki, Diossenbi, itan jawen Shinanmanbikayara, jaskati yoyo iti joibo mato menitiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jainxon jonibaonra, jaton wetsabi retekanon ixonbo jato yatanmanoxikanai. Jainxon papabaonribi jaton bakebi jato yatanmanoxikanai. Jatian bakebaonra, jaton aniboki kikini sináxon, jato retemanoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jainxonra, ea kopi, jatíbi jonibaon mato omísnoxikanai. Ikaxbi jaweratoboki eki koshii jenéyamai, jabora kishpinnoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jaskarabo iken, ja Danielnin wishani joibo yoyo axon jaweraki ikárin ixon, onankanwe; jawetianki ja Dios rabiti xobo meranxon, kikinbires jakonma jawéki akanaitian maton oinnai, jatianra ja Judeain ikábo, jatianbi moa mananman jábati bokanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jaweratoboki ja neten, jaton xobo bochiki iki, jabora moa naman jotima iki, itan jaton jawékibo bii moa xobon jikitima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jainoax ja wainko ikábora, jaton perakooti chopa biibobi moa xobonko bekantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Jawe iresaipanon! Ja nete nokóketianra noibati inoxikanai, ja tooyabo, itan ja bake xoma amakin jenemamabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jaskara iken Dios orankanwe, neskara jawékibo oitian napo iamanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jatianra inóxiki akonbireskin masá teneti nete, ja Diossen nete joniakin peonontianbira tsonbi jaskáakin masá teneama iki itan japekaora moa jaskátibo yamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja masá teneti netebo non Ibon basibires imaabira, tsoabi kishpinyamakeanke. Ikaxbi jawen katota jonibo noixonra, Diossen ja masá teneti nete basima itiakin imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jawekeska ixon, akanti iki mato yoikin: ‘Oinni bekanwe, neno riki Cristo, akin. Iamaxon, ono riki oinni bekanwe’, akin. Mato jaskáakanabi, ikonhayamanoxikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ja netebaonra, ikonma Cristobo itan ikonma *profetabo bexon, ja oinxon onanti jawékibo itan rateti jawékibo anoxikanai; jaskáxon jato parannoxon. Jawekeska ixonra ja Diossen katota jonibobi, jato parankantiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jaskarabo ikámatianbira en moa mato yoike; koiranmeetax jakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ikaxbi jaskákinbo moa masá tenekana pekáora, bari nokanoxiki. Oxenribi moa yamé tenayamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wishtínbora naikanmeax, maannoxiki. Jainoaxa, ja naikan iká koshi jawékibo shakónoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jatianra ja jonin Bake, nai koinman jawen atipana koshia, itan jawen penéyabi joaitian oinnoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Janra ja ángelbo raannoxiki jawen katota jonibo, ja mai senenainkonia, itan ja nai senenainkoniabi jato tsinkinon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ramara higoki yoinhanan en mato onanmai. Ja higo jawen peibo tinini keyotax, pechokooketian oinxon, akai maton onankin, moara baritiati ochóma iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaskáakinribira, ja yoia keskábo ikai oinxon maton onanti jake, ja jonin Bake jotira moa ochóma iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Enra mato ikonshaman yoiai, ramatian jaa jonibo jarésparikankebira, neskarabo senenti jake ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ja nai betan maira keyónoxiki, ikaxbi nokon joira jawetianbi keyóyamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ikaxbi ja neteshaman, itan ja hora jotira tsonbi onanyamake. Ja naikan iká ángelbaon itan ja Bakenbira onanyamake. Nokon Papanbichoresa onanke. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jaskara iketian, oxaa keskábo iamai, koirannai keskábo ikanwe. Matonra onanyamake, jawetiankayaki jaskarabo iti iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ja westíora jonin ochó kakin jawen xobo koiranon ixon jawen yonotiboki jenebaini keská ikanwe. Ja jonin kakin anike, jawen yonotibo westíora teebo menipakekin. Jatian ja xepóti koirannai joniribi yoia iki, kikinhakin koiranti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jaskara iken, oxá besoabo keská ikax, moa manatares ikanwe. Matonra onanyamake ja xobo ibo jatian joti. Jawe keska ikaxa, joti iki, yantanshoko, yamé pochínikon, atapabene keotaitian, iamax nete xabataitian, ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","matora joxon oxaa keskábo nokonake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ja en mato yoiaiboribira, jatíbibo en jato yoiai: Moa oxá besoa keskábo ikanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jaskarabo inontianra, rabé neteres maxkata iká iki moa *Pascua fiesta iti nete, itan *levaduraoma aká pan piti fiesta neteribi. Jatian *sacerdotebaon koshiboyabi, ja esé onanbo bekana iki, ja Jesús paranhanan yatanxon reteti shinanyanix. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jatian jatíribibo neskákana iki: —Fiestatian atima riki, noara jonibaon sináxon ramiakanake —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jatian Jesús iká iki Betaniain kaa, ja *lepraya iantana Simonman xobon. Jain ixon, mesan pii Jesús yakáketian, westíora ainbo joá iki, ja *alabastro pomonko *nardo akana ininti kikinbires inín, itan kikinbires kopí tsomáya. Ja toetaanan, ainbaon Jesús machita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jaskáaketian oinnax, jatíribi jain ikábo sinati, jatobiribi yoyo iki, neskákana iki: —¿Jaweatiki aká ja kikinbires kopí ininti yoyókin? ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jakayara ike ja kimisha pacha nete teexon koríki bititii senen maroti. Jaskáaxon ja jawékiomashokobo jato akinox —ikibo. Jaskatax, ja ainboki jakonmaibo yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ikaxbi Jesussen jato yoia iki: —Oinreskanwe ¿Jawekopiki mato jaki ramitai? Jan ea jaskáara jakon jawéki iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ja jawebiomashokobora, jatíbitian mato betanbi inoxikanai. Jaskara ikenra, mato keenatian maton jabo akinti atipanke. Ikaxbi eara neno jatíbitian mato betanbi iamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nato ainbaonra, jawen atipana senen ea jakonhake. Jayá ea miinkanon ixonra, inintinin nokon yora ea inínhaxonke. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ikonshamanra en mato yoiai: Jaweranoxon inonbira nato netenxon Diossen joi yoikin, nato ainbaon ea jaskáani yoinoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jaskáketian ja, jaonmea onanai jawen chonka rabéainoa, Judas Iscariote, *sacerdotebaon koshiboiba kaa iki; jato Jesús yatankiinoxon jato betan shinan akí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jato jaskáakin yoia ninkatax, ikonbiresi rarokin, koríkinin kopiáti Judas yoikana iki. Jatianra jaskaxon jato yatanmati moa jan benaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jatian ja levaduraoma aká pan piti fiesta peokoota nete, itan *Pascua iketian ja carnero bake retekanai netenra, jaonmea onanaibaon Jesús yokákana iki: —¿Jawerano kaxon, ja *Pascua netetian non piti axontininki mia keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jatianra Jesussen jaonmea onanai rabé raankin yoia iki: —Jerusalén jeman kabékontanwe. Jain kaxonra, chomon onpax boai joni maton nokoi kaai, ja joni kaaitian, chibantankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jawerato xobonki ja joni jikiai, jainribi jabébi jikixon, neskáakin ja xobo ibo yoitankanwe: ‘Non Maestronra mia yokatai ¿Jawerato xobo nachiterin ja eonmea onannaibo betan, *Pascua fiestatian en jainxon jawékiati?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Maton jaskáara, ja bochiki iká ani nachite moa jainxon pitires inon ixon benxoayonkana mato oinmati iki. Jatian jainxonra ja pitibo moa maton ati iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jaskáakin yoia jaonmea onanai rabé kabékona iki. Boax jeman nokóxon oinkana, ja Jesussen jato yoiwana keskáshaman nokobekona iki. Kaxon ja *Pascua neten, piti moa akana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jatian moa yametaishoko, jawen chonka rabé jaonmea onanaiboya, Jesús jain nokota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jatian moa mesankoxon pii yakáxon, Jesussen jato yoia iki: —Ikonshamanra en mato yoiai, ja ebetan pii itina mato westíoratonra, ea jakonhai keská iikinbi ea jakonmaanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jaskáakin jato yoia, masá shinankana iki, jainxon westíoraxonbo, Jesús yokápakekana iki: —¿Earin jan mia jato yatanmati? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jatian jato yoia iki: —Ja mato chonka rabé ikainoa, ja en akai ratonribi ebébi pan montanai riki, jan ea jato yatanmati. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ja Wishá meran jaskáti yoiai keská senennon ikaxa, ja jonin Bake mawáti jake. Ikaxbi ¡Jawe iresaipanon, jakonhai keská ixonbi ea jan jakonmaati! Jakonkayara ikeanke já joniama —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja pii iikanaitian, pan bixon Jesussen Dios iráke aka iki. Jaskáaxon ja pan tobapakexon, jato menikin yoia iki: —Pikanwe, natora nokon yora iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Japekaora ja xeatia vasoribi bixon, Jesussen Dios iráke aka iki. Jaskáatanan, jato menipakea, jatíxonbi xeakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jato menikin yoia iki: —Nato riki nokon jimi, janra ja senenhabekonti joi Diossen aká onanti imai. Ja jimira chikotai icha jonibo kishpinmeekanti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ikonshamanra en mato yoiai, enra mato betan jakiribi vino xeayamanoxiki, ja Diossen ikinaton jati netenxon non jakiribi bená vino xearibii kaai kaman —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jatian moa bewai senentaananra, Olivos janeya mananman bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kakin Jesussen jaonmea onannaibo yoia iki: —Nato yaméra jatíxonbi maton eabicho potanoxiki. Ea maton jaskaáti yoiira ikai Diossen joi meran neskati: ‘Oveja koirannai joni en reteketianra, jawen ovejabo janbisnoxiki’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ikaxbi jakiribi jiriaxa mato kaamatianbi, eapari Galileanko kanoxiki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jaskáketian Pedron yoia iki: —Wetsabaon miabicho potakenbira, en mia ayamanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jatian Jesussen Pedro yoia iki: —Ikonshamanra en mia yoiai, rama yamébira, rabeti atapa keotamabi, ea onanaxbi mia kimishai parananoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jaskáabi Pedron yoia iki: —Ea mibébi mawáti onanaxbira, ea paranayamanoxiki —akin. Jatian jatíxonbi jaskáakinbires yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jainoax Getsemaní janeya wainko bokana iki. Jainxon, Jesussen jaonmea onannaibo yoia iki: —Enpari oranbatanon, nenobi yakáxon ea manakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kakinra, Pedro, Jacobo, jainoax Juantiires jato ioa iki. Kaaibi Jesús raketi kikinbiresi onisa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jatian jato yoia iki: —Eara ikonbiresi mawákasnon kaman onisai; nenobipari ikanwe, oxayamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jato jaskábaini orichaashoko kaax, maikibi bekepixon, orana iki: Ati ixon masá tenemayamanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ja orankin, neskaa iki: “Papá, minra jatíbi atipanke. Jaskara iken, min keen iketian, masá tenetiainoa ea pikómawe. Ikaxbi nokon keena keská ea imayamawe; mia keenai keskáreskaya ea imawe”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jaskáatanan, jaonmea onanaboiba joríbaa iki. Joxon oxakana jato nokoa iki. Jatian Pedro yoia iki: —¿Miaki oxaa Simón? ¿Minki westíora horatanibires oxá teneti atipanymaa? ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oxayamakin orankanwe; matora ochanake. Shinan meranra mato ati shinanya iki. Ikaxbi maton yorara yosma iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jatian Jesús orani karibaa iki. Kaxon, awana keskáribiakin orana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jainoax jakiribi joxon, jato oxaa nokoribia iki. Oxakashorai betireskana, jatian jaskáshamanhakin Jesús yoitibobi atipanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jatian moa ja kimisha itin, jakiribi joxon, jato yoia iki: —¿Matoki oxaa, itan tantiabopari ikanai? ¡Weníkanwe! Moara ja jonin Bake, ochaya jonibo yatanmakanti hora nokóke. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Weníkanwe, moa noa bokanon! Jan ea jakonhai keská ixonbi ea jakonmaakai jonira moa joái —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jato jaskáakin yoii iitainbi, ja chonka rabéainoa westíora jaonmea onanai Judas, icha jonia joá iki. Ja jonibo iká iki, espadayabo, jainoax jiwiabo; ja *sacerdotebaon koshiboyaxonbi, esé onanbaon, itan *ancianobaon jato raana bekana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja jakonhai keská ixonbi, jan jakonmaakai Judassen jato yoia iká iki, jan jaskáaitian oinxon yatánkanti. Ja iká iki: “Ja kaxon betsó akaitian, yatanxon koiranshamanxon, bokanti”. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jatianra jaki ochómakiranxon, Judassen, Jesús neskaa iki: —Maestró —akin. Jaskáatanan betsó aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaskáaitian oinxon, Jesús yatanxon nexakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jatian jain westíora ikatonin, espada tsekataanan *sacerdotebaon koshin yonoti, paxtea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jatian Jesussen já yatani bekanabo yoia iki: —¿Eaki yometso iki, ja espadayabo, itan jiwiabo bexon, maton ea yatanti? ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Netetiibira ea mato betan ipachoai; Dios rabiti xobo meranxonbo Diossen joi yoianan jato esei. Ixonbi jawetianbi maton ea yatanyamaa iki. Ikaxbi Wishá meran yoiai keskábo senennon ixonresa, rama maton ea jaskáai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jatian jaonmea onannaibo, ja Jesúsbicho potabaini jabákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jaskáakin jabicho potakankebi, westíora chopan rakóya bakeranonmanbicho, Jesús chibana iki. Jatian járibi yatankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ikaxbi jan rakota chopa raopeekaini, chopaoma jábati ishtoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jaskáxon Jesús bokana iki, ja *sacerdotebaon kikin koshiiba. Jain iokanketian, wetsa *sacerdotebaon koshiboyabi, judíobaon joni koshibo, itan esé onanbo tsinkíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jatian Pedroribi, ochóxonres Jesús chibanboi kaa iki. Kaax *sacerdotebaon joni koshin xobo jema ikain jikiax, policiabo betan chii kexa yooti yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jatian *sacerdotebaon koshiboyaxonbi, judío koshibaon, jakopi retenoxon jan jakonma aká yoiti joni benakinbi nokoyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Icha joni jaki jakonmai jansoibo yoyo ikanabira, jaskáakinshamanbires yoiamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ikaxbi jatíribibora Jesúski ramitires, jansoibo ikana iki, neskati: ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—‘Nonra ninkata iki, ja jonibaon aká nato Dios rabiti xobo ras axonra, jakiribi kimisha neteres en wetsa aríbati iki; ikaxbi jara iti iki jonibaon akáma’, iki ikaitian —iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ikaxbira jaskáakinshamanbires yoiamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jatian jaskákanketian, ja *sacerdotebaon joni koshin wenixon, Jesús yokata iki: —¿Minki jawebi jato yoiamai? ¿Ikon iketiankayaki mia jaskaákinbo yoikanai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ikaxbi Jesús, jawebi yoyo iamai netéresa iki. Jaskáketian, *sacerdotebaon joni koshin yokáribia iki: —¿Miarin Cristo, ja ani Diossen Bake? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jatian Jesussen yoia iki: —Ikon já riki ea. Matonra oinnoxiki, ja jonin Bake, jatíbi atipana koshiaton mekayao yakata, itan nai koinman joaitian —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jatianra ja *sacerdotebaon koshin, sinatai onankanon ixon, jawen sawea tari waxataanan, jato yoia iki: —Moara janbishaman yoike, wetsabaon yoitininra, moa noa maxkáyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Matonbira moa ninkáke, Dioski jakonmaibires yoyo ika ¿Jawe keskaki maton shinannai? —akin. Jatianra jatikaxbi, jara mawáti jake iki ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaskáxon jatíribibaon toshbá akana iki. Jainxon chopan benéxanan, tantash axonbo yokákana iki: —¡Tsonki mia aká jaskáakin onanta! —akin. Jatian ja policiabaonribi bemanankibo timakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jatian Pedro, xobo jema ikain yakáketian, *sacerdotebaon joni koshin yonoti ainbo joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Joxon, ja Pedro chiikan yootaitian, jainbikon ointaanan, yoia iki: —Miaribi riki ja Nazarethainoa Jesús betan nipachaoi joni —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jatian paranakin Pedron yoia iki: —Enra onanyamake; tsoa yoiira mia ibirai —akin. Jaskáabaini jemaori pikókenbi, atapabene keota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jatian ja ainbaon jakiribi Pedro ointaanan, jain charotabo jato yoia iki: —Natora Jesussen joniribi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ikaxbi jakiribi Pedro paranaa iki. Jaskákenbi, jain charotabaon jakiribi yoikana iki: —Ikon riki mia jawen joni. Miara Galilea joniribi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jaskáakana kikini paranakin, Pedron jato yoia iki: —Enra mato ikon yoiai, ea jansoaitian Diossenbi ea masábires tenemabanon, já yoikin maton ea akai jonira, en onanyamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jato jaskáatianbi, moa rabeti atapabene keota iki. Jaskáketian Pedron shinanria iki, “atapabene rabeti keotamatianbira, ea onanaxbi kimishai mia parananoxiki”, akin Jesussen yoiibata. Jaskatax kikini winia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jatian nete xabáketian, *sacerdotebaon koshiboyabi, judíobaon joni koshibo, jainoax esé onanbo, itan jatíbi judíobaon joni koshiboribi tsinkíkana iki. Jaskáxon moa Jesús nexayonxon, Pilatoiba bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jatian jaiba bokanketian, Pilaton, Jesús yokata iki: —¿Miarin ja judíobaon apo? —akin. Jaskaa yoia iki: —Minbira moa yoike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jatian ja *sacerdotebaon koshibaon, jan akáma icha jawékibobi yoixonkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jatian Pilaton, yokáribia iki: —¿Minki jawebi jato yoiamai? Minbi ninkáke ja icha jawéki kopí mia jakonmaakin yoikanai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ikaxbi Jesussen jawebi yoiamaa iki. Jaskatai ointaanan, Pilato rateta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jatian Pilaton axé iká iki, *Pascua fiestatiibi westíora preso, ja jonibaon yokáketian pikoti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jatianribi iká iki, apoki yoitimakin joni reteabo betan westíora joniribi Barrabás janeya cárcel meran akana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jatian *Pascua fiestatiibi Pilaton pikoai iketian, jaiba icha jonibo bekana iki, westíora pikoxonon ixon yokati. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jaskáakana Pilaton jato yokata iki: —¿Ja judíobaon apo en pikoxontiki mato keenai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatonra moa onanna iká iki, ja Jesúski notsikinres ja *sacerdotebaon koshibaon jaiba bekana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ikaxbi *sacerdotebaon koshibaon moa jonibo yoia iká iki, ja Barrabás jato pikoxonon ikax, saa ikanti. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jatian Pilaton jato yokata iki: —¿Ramaki ja judíobaon apo akin maton akai joni, en jaweatiki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jatian jonibo saa ikana iki: —Korosen awé, korosen awé —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jatian Pilaton jato yoia iki: —¿Jawe jakonma akákayarin? —akin. Ikaxbi jabo jakiribi, ¡korosen awé! Ikires saa ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jatian jonibo betan jakon banénoxon, Barrabás jato pikoxona iki. Jaskáaxon sontárobo rishkimayonxon, Pilaton, Jesús jato menia iki; korosen akanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jatianra sontárobaon, ja apo jain iká xobo jemanko Jesús bokana iki, jain sontárobo ikain. Jainra jatíbi sontárobo jainbicho tsinkíkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jaskáaxon jan perakooti joshinyame chopa, sawemakana iki. Jainxonribi moxa maiti maimakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jatian jaskáakin akáx, Jesúski shiroi neskati saa ikana iki: —Ikon riki mia judíobaon apo, miara basi janoxiki —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jaskáatanan jiwin mapoki rishkixon, toshbá akana iki. Jainoax jabebon chirankokana iki, rabiai keskati. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jatian moa jaskati jaon shiroa pekáo, jan perakooti joshinyame chopa jopémataanan jawen chopabi sawemaribikana iki. Jaskáaxon moa korosen anoxon pikobainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ja Jesús bokanaitian, Cireneainoa Simón janeya joni wainkoniax joaitian bechikana iki. Já iká iki, Rufo betan Alejandron papa. Ja jonira keenyamainbi Jesussen koros bomakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jaskáaxon Jesús Gólgota mananman bokana iki. Ja joi iki: “Mapo xao”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jain boxon, *mirra moka vinoya meskoa xeamakaskanabi, Jesussen ayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jainxonra moa Jesús korosen akana iki. Jatianra, sontárobaon *suerte akana iki, tsonki jawen chopa bitiki ixon onannoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja Jesús korosen akannontian iká iki, moa yamékiri, iskon hora. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jatian jakopi retekanai joi tablanin wishaxon, já manaon tasakana iká iki: “Judíobaon apo”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jatian rabé yometsoribi iká iki jabébi korosen akana. Westíora jawen mekayao; wetsa jawen mexkao. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Neskatira senena iki ja Wishá meran yoiai: “Jakonma jonibo betanbi akanara yoikana iki” iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jatian jain Jesús korosen akanainko, winotaibo jakonmai jaki shiroibo, bonké, bonke iannanbi, neskákana iki: —¡Eri! Mia iká iki yoyo iki, ja Dios rabiti xobo ras ataananra, kimisha neteres en jakiribi aríbanoxiki iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jaskara ikax, minbix kishpinmeetax ja korosenmeax, pakéwe —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jaskaribiira ja *sacerdotebaon koshibo, betan esé onanboribi jaki jakonmai shiroi, ikana iki neskati: —Wetsabora kishpinmaa iki, ikaxbi janbixbira iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ibanon ja Cristo, *Israel jonibaon apo, janbixbi korosenmeax paketi, jatianparira non oinxon ikonhatiki —ikibo. Jatian ja jabé korosen ikábobi jaki jakonmai yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jatian moa bariapanketian, jatíbiain yameta iki, ja kimisha hora yantan kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jatian ja horaribi, Jesús koshin saí iki, neskata iki: “Eloi, Eloi ¿Lama sabactani?” iki. (Ja iki: “Nokon Diossé, nokon Diossé ¿Jaweatiki min ea potabaina?”) iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jaskatai ninkatax, jain ikana jatíribibo neskákana iki: —Ninkákanwe, Elíassa kenai —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jaskáketian ninkaxon, westíora jonin ishto kaxon, jiwishokotonin *esponja akátonin *vinagre tsaimataanan Jesussen tsitsianan xeanon ixon, ketaxnanax, neskata iki: —Oinnon akanwe; ja korosenmea pakeira Elíasbira joái —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ikaxbi Jesussen kikin koshin saí itaanan, moa maxkaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jaskáketian, Diossen xobo meran iká, jan nachitea chopa, bochikiax namani noshita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jatian ja Jesús moa mawata ointaanan, ja bebon itina romanobaon *capitán, neskata iki: —Ikonra iká iki nato joni Diossen Bake —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jatian ochóxonres oinni, jaweti ainboboribi jain ikana iki. Jato xarán ikana iki; María *Magdalena, jainoax, ja chiníshoko Jacobo betan Josekan tita María, jainoax Salomé. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ja ainbobo ikana iki, Jesús Galileanko inontian jabé nikátiaibo, itan jabaon jawéki axonkatitaibo. Jainoax wetsa ainboboribi jain ikana iki, Jesús betan Jerusalénhain beabo. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jatian moa yametaitian oinnax, bakish tantiti nete ikai kopí, jatikaxbi moa benxokáakanai iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jaskara iken, Arimateainoa José janeya joni joá iki, já ika iki joni koshibo betan iká koshiribi. Jaribi iká iki, Diossen ikinaton jati netenko iti shinannairibi ikax manata. Jakopí rakéyamai, Pilato ikain jikixon Jesussen yora yokata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jatian moa mawata ninkatax ratéxon, ja *capitán Pilaton kenaa iki jawetianki mawáibata ixon yokánoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja kenamaa joxon, moa mawata yoiketian, ja Jesussen yora boti moa José yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jatianra Josekan *lino chopa maroxon ja Jesussen yora korosenmea pakeanan, jan rakawaa iki. Jaskáatanan boxon, shanka kiniakana meran niaa iki. Jainxonra westíora shanka anin ja kini xepoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jatian ja María *Magdalena betan Josekan tita Maríanin, jain akanaibo oinbekona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jatian moa tantiti nete winota pekáora, ainbobaon ja Jesussen yora raskinoxon, ininti marokana iki, jan biabo iká iki, Magdalainoa María betan Jacobonin tita María itan Salomé. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jatian ja reken nete semana peokootai yamékirishoko moa bari pikotaitian, jain Jesussen yora aibakana kininko boax nokókana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaai yoyo iibainkana iki: —¿Tsonparimein, jan kini xepoa ani makan noa taranxonai? —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jatian nokóxon oinkana, jan xepoibakana makan moa wetsaori rakata iká iki. Ja makanra iká iki kikin ani. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jaskara iketian, ja kini chicho jikixon oinkana iká iki, ja mekayao westíora bakeranon joxoshaman tapó chopa sawéya yakata. Já oinnax ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jatian jan jato yoia iki: —Ratéyamakanwe, enra onanke, ja korosen aibakana Nazarethainoa Jesussen yora oinni mato bekana. Ikaxbira moa neno yamake; ¡Moara jirike! Oinkanwe jain aibakana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Moa botankanwe; boxon jaonmea onannaibo, itan Pedro yoitankanwe: ‘Mato kaamatianbironki, japari Galileanko kaai, jainoaronki maton ointi iki, ja mato yoiibata keskáakin’, akin atankanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jatianra, ja kini meranoax, ja ainbobo jokonbaini, kikinbiresi ratetax, saki iananbi bokana iki. Nokóxonbi tsoabi yoiamakana iki, rakékin. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jatian moa jiria pekáora, ja reken semana nete yamékirishoko, Magdalainoa Maríakipari Jesús pikota iki. Ja María iká iki, ja meranoa kanchis yoshin, Jesussen jokonhayantana. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ja ainbaon kaxon, Jesús betan ipachoaibo onisi, winii ikanaibo jato keshana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ikaxbi ja Jesús jiria, janbishaman oinxon, jato yoiabi, jabaon ikonhaayamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jatian jaskata pekáo, jaonmea onanai rabé, wainko kabékonaitian wetsakeskatibiribi, Jesús jatoki pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jatian jabaon kaxon ja jatíribibo jato yoiabi, ikonhayamaribikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jatian jaskata pekáo, jawen chonka westíora jaonmea onannaibo pii ikanaiboki, pikóxon, jato Jesussen notsina iki, já jiria oinnabaon yoiabi, jaton keena keskáakinbores shinankin ikonhayamakana iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jainxon jato yoia iki: —Jatíbiain botankanwe, boxon jatíbi jonibo ja jakon joi jato yoitankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jatian jaweratoboki ikonhaax bautizameetai, jabora kishpinti iki. Ikaxbi jaweratobaonki ea ikonhaayamai, jabaonra masá tenenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jatian ja ea ikonhaax, eki koshiabaonra; nokon janenko, jonibo meranoa yoshinbo pikonoxikanai, bená joibaonra yoyo inoxikanai, ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ronobora yatannoxikanai, mawáti rao xeaxbira ramíkantima iki. Jaskaribiakinra mekenman tii axonres ja isinaibo benxomanoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jato jaskaákinbo yoia pekáo, ja Ibo Jesús naikan keyatax, moa kaa iki. Kaax, Diossen mekayao yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jatianra jaonmea onannaibo, jatíbiain Diossen joi yoii bokana iki, jatianra ja Ibon jato akinna iki, ja yoikanai joibo ikon onankanon ixon, ja oinxon onantibo jato amaxon.");
INSERT INTO shpNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ichaxonra ja noo xaranmeax ikonshaman winota jawékibo wishakin tanakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ja peokootiainxonbi jatonbishaman oinkanabaon, noa yoikani keskáakinribi; ja joniboribira jawen joi yoiaibo jato imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Enribira ja peokootainoabi kikinshamanhakinbo onanboxon, jakonshamanhakin en mia wishaxonai, nokon keen Teófilo, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","jaskáaxon ja mia yoikana ikon joibo min kikinhakin onannon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ja Judea main Herodes apo inontianra, westíora *sacerdote Zacarías janeya jakátiai. Jara iká iki Abías janeya tsinkí ikainoaribi. Jatian jawen awin Elizabet iká iki, ja *sacerdote Aarónman rarebo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ja rabébira iká iki Dios bebon jakoni jabékona iken, tsonbi jakonmaninbo yointi yama, jainoax ja non Ibon yoiai itan jawen eséboribi senenhai jabékona. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jaskara ikaxbira bakeoma ikana iki, ja Elizabet bakeayosma iketian, itanribi ja rabébi moa yosiora ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wetsa netenra Zacarías jawen nete nokóketian, jabé ikáboyaxonbi *sacerdote ixon Diossen tee axoni iitaitian, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","jaskara jaton axé iketian ja *sacerdotebaon *suerte akana, jaki paketa iki. Ja Diossen xobo meran jikixon, *incienso menoi kati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jatian ja *incienso Dios menoxonti hora nokoketian, ja jemaori tsinkíkana icha jonibo orani ikana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","jatian jaskáai iitaibira, ja jainxon *incienso menoti patax, mekayao westíora ángel pikota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jaskáakin ja ángel meraax, Zacarías ratetax kikinni raketa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jaskatainbi ja ángelnin yoia iki: —Zacarías rakéyamawe, Diossenra min oranabo mia ninkáxonke; min awin Elizabethra moa bakeya ikai, ja bakera Juan akin min janenoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jatianra ikonbiresi mia raronoxiki, itan icha joniboribira ja pikóketian raronoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jara non Ibo bebon kikin joni inóxiki. Janra jawetianbi vino itan wetsa jan paenti xeatibo xeayamanoxiki, jainoax pikotamatianbira moa Diossen Shinan bochóya inóxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Janra icha *Israel jonibo, jaton Ibo Dioski jato banémaribanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja parira non Ibo joámatianbi rekennoxiki, jara ja *profeta Elías jayáni Shinanyaribi, itan atipana koshiaribi inóxiki. Jaskáaxonra ja papabo betan jaton bakebo jakiribi jato raeananmaribinoxiki; jainxonra ja yoitima jonibo, ja yoiti jonibo ikanai keskatiribi ikanon ixon jato imanoxiki; neskáaxonra ja jonibo jato benxokaamanoxiki, jaskáaxon non Ibo bikanon ixon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jatian jaskáa Zacaríassen ja ángel yokata iki: —¿Jawekopiki ea neskara winóti iki? Ea iki moa yosishoko, jatian nokon awinribi iki moa yoxanshoko —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jaskáketian ángelnin yoia iki: —Ea riki Gabriel, ja Diossen yoiaibores axonai, janra ea raanke miibetan yoyo ixon neskara jakon joibo mia yoiti. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ikaxbi jaskarabo en mia yoiabo ikonhayamaxa, rama mia yoyo iamai banetai; miara jaskati yoyo itipanyamai kaai, jawen ititianbiribi jatíbi neskarabo seneni kaai kaman —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jaskatai kaman ja jemaori tsamata jonibo Zacarías pikótinin manákana iká iki, ¿Jawekeskatiki ja Diossen xobo meranoax ishton pikóyamai? ikibo yokakaati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jatian moa pikóxon jato yoyo ati atipanyamaa iki; jatian jaskataitian oinxon onankana iki, ja Diossen xobo meranxonra, namá keska meran oinke ixon. Jatianra meken chankanxonres, jato yoyo aka iki. Jaskataxa moa yoyo iamai baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jatian jawen tee moa senenhax, Zacarías moa jawen xobon kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jainoax jawen awin Elizabet moa tooya iká iki, jaskataxa pichika oxe jawen xobomeax pikóyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Jainoax neskata iki: “Non Ibonra rama ea neskara imake, moa ea jonibaon omisyamanon ixon”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jatian moa sokota oxe tooya ikenra Diossen jawen ángel Gabriel raana iki; ja Galilea main iká Nazaret janeya jemanko. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ja jeman iká iki westíora xontako María janeya jawetianbi joni betan yoranyosma, ikaxbi José janeya jonin binoxon onantiares, jara iká iki ja apo David ipaoniton rarebo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kaax ángel ja xontako ikain nokota iki, jainxon neskáakin yoia iki: —¡Eara mia oinni joke, Diossenra mia katóke! Ja Ibora mii betan iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jatian jaskáakin ángelnin yoiai ninkatax María rateta iki, jainxon shinanna iki: —¿Jaweatimein ea jaskáakinbo yoiai? —ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jaskataitian ángelnin yoia iki: —Rakéyamawe María, Diossenra mia katóke, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ramara mia benbo bake tootai, ja bake pikóketianra Jesús akin min janenoxiki, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","jara jato xewina joni inóxiki, jainxonra ani Diossen Bake akinribi anoxikanai; jara non Ibo Diossen apo imanoxiki, jawen reken papashoko David imani keskáribiakin; ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jaskatax jatíbitian ja Jacobnin rarebobo jato ikinai iti kopí, jara jatíbitian apo iki jenéyamanoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jaskáaketian Marían ja ángel yokata iki: —¿Jawekeskatiki jawetianbi joni betan yorantinin iosma ikaxbi ea neskara jawéki iti iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jatian ángelnin yoia iki: —Ja Diossen Shinanra miki jonoxiki, jatianra ja ani Diossen atipana koshi, mii meran inóxiki. Jaskara kopíra ja Bake pikotai, jawenabiribi iken, Diossen Bake akin janenoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jainoaxa ja min rarebo Elizabet moa yoxanshoko ikaxbi tootax, rama moa westíora benbo bakeya ikai. Jara ja tooismatonin yoinkanai ikaxbi moa sokota oxe tooya iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jaskara ikenra Diossen jawe jawékibi atipanyamaa yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jaskáaketian Marían yoia iki: —Eara non Ibon yonoti iki, abánon ja min yoia keská ea Diossen imakin —akin. Jaskáabaini ja ángel moa kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jaskarabo iká pekáo basimabi María ishton Elizabet oinni kaa iki, ja Judea mainmea mananman iká jeman. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nokóxonra ja Zacaríassen xobonko jikixon Elizabet saludana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jaskáakin Marían *saludana Elizabetkan ninkatatianbira, ja Elizabetkan poko meranoax jawen bake koshia iki. Jainoaxa Elizabet ja Diossen Shinan bochóya ikax, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","koshinshaman María akí neskata iki: —¡Diossenra wetsa ainbobo aká bebonbires mia jakonhakin akinke, jainxon ja min bake pikoti kaairibira jakonhakin akinke! ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eara jawemabishoko iki, ja nokon Ibon tita ikaxbi ea oinni mia joti. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ja min ea saludantoshia en ninkatatianbira, nokon bake poko meranoax raroi koshike. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Diossen mia raroshaman imabanon, jaskara imatibo non Ibon mia yoia senenti min ikonhaa kopí! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jatian María neskata iki: “Nokon shinanyaxonbira non Ibo en rabiai, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","jan ea kishpinmaa Dioskira nokon shinan meran ea raroai, ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ea jawen yonoti ikax, rabíti shinanhoma iken, ekiakin shinanna kopí. Jaskáakinra, jonibaon rama peoxon jatíbitian Diossenra mia raroshaman imake akin ea anoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ja jatíbi atipana koshia Diossen, ani jawékibo emeranxon aká kopí. ¡Jakon riki jawen jane! ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diossenra já rabiaibo jatíbitian, jato noibai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jawen atipana koshinra ani jawékibo aká iki: Ja rabitai jonibaon anoxon shinankana jawékibora, jato ras akanaana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ja apobo jaton teeainoa pikoxonra, ja rabítinin shinanhomabo ani jonibo jato imaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ja jawékiakasaibora icha jawékiati jato menia iki, jatian ja jatíbi jawékia jonibora, jawebiomabo jato banémaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ja jawen yonoti Israel jonibo jato akinxonra, jawen noibamisti shinanmanribi jato akintinin shinanbenoyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jaskáakin jato akintibo ja non rekenbo jato yoini iketian; jainxon ja Abraham itan jawen chiní rarebo iki kaiboribi jato yoini iketian”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jaskatax María ja Elizabetkan xobonpari kimisha oxe ikax, moa jawen xobon karibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jatian jaskara iiti moa bakenti oxe senenketianra, benbo bake Elizabet bakena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jatianra ja patax ikáboyabi jawen rarebobo ja rarokinni bokana iki, non Ibon jakonhakin akinna onanax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jatian ja bake pikota moa posaka neteya iketian boxon, jawen jakina rebichi xatexonkana iki, jainxon ja bake jawen papan janenbi Zacarías akin janekaskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ikaxbi jawen titan jato yoia iki: —Jawen janen ayamakanwe, jawen janera iti jake Juan —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jato jaskáaketian yoikana iki: —Min rarebora ja janeya yamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jainxon ja baken papa yoyo iamai iken, mekemanres metokin yokákana iki, janbiribiki jawen bake jawe janekasai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jaskáakana jawen papan jan wishati tablashoko bexonkanti jato yokata iki, jaskáakin bexonkanketian, neskati iká wishaa iki: “Jawen jane riki Juan”, iki iká, jatianra jonibo jatikaxbi ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jaskákanaitianribi Zacarías moa jakiribi yoyo ika iki, jainxonra Dios rabikin peoa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jaskara oinnaxa ja patax ikana jonibo ratékana iki, jainoax ja Judea main iká mananbaon jakana joniboribi, jaskara winotabo jato yoiaketankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jatian jaskara ikábo ninkata jonibo jatonbinix neskatibo yokakaakana iki: “¿Jawekeskamein nato bake aniax ikí kanoxiki?” ikibo. Jawen atipana koshin ja Ibon akinnai ointaanan. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jatian ja baken papa Zacarías ikonbiresi Diossen Shinan bochóya ikax, ja Diossen imaa joibores yoyo iki neskata iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Israel jonibaon Dios, rabinon akanwe, kopíaxon jawen jonibo jato xabáai joá iken! ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jawen yonoti ipaoni Davidkan rareboboainoara, noa jan kishpinmai westíora joni atipana koshiya noa raanxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jaskara itibora moatianbi janbi imaa *profetabo meranxon Diossen jato yoimaa iká iki; ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ja non rawíboibakea, itan ja noa omisai joniboibakea pikoanan noa jan xabáati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Jainxon ja non reken papashokobo jato onísaxon jato akintiribi yoia iki, jainoax ja senenhabekonti joi akátoninribi shinanbenotima. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ja non reken papashoko Abraham akonkin jato yoini joi riki neskara: ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jawen keena keskatires noa ikanon ixonra, non rawíboibakea noa jan xabáa iki; ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","jainoax nato neten já bebon jaax, ponté shinanya itan ochaoma keskáboribi noa jatíbitian ikanti kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Baké jatian miara Ani Diossen *profeta akin anoxikanai. Minpari rekenxon, ja non Ibo joti iketian benxokaanon ixon jato yoiaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jaskáaxon Diossen jaton ochabo moa shinanxonyamataanan jato kishpinmai joi, jawen jonibo min jato onanmati kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ja non Diossenra jawen ani akinmisti shinanya ixon, jan noa kishpinmati noa raanxona iki, ja netetiibi jakonshamankin noa bari pikómaxonai keskáakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jaskáaxon ja kikin yamé keska meran jakanabo, jato tenai keskáakin jato anon ixon, jainxon jakoni jakanon ixonribi noa onanmati”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jainoax ja bake anii; shinan meranribi koshikaa iki, jainoax jain joni jayamainko já iki; jawen kaibo Israel jonibo Diossen joi jato yoii joái kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja netebaonra Augusto iká iki, ja icha mai iboaa romamea apo imakana. Jaskara ixon, jatíbi jonibo jaton jane wishakaanon ixon, jatíbiain jato ninkámati joi raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jatian jaskati jaton jane wishakaatira iká iki, Cirenio janeya joni, Siriainoa joni koshi iká inontian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jaskatira jatíbi jonibo jaton jemabaon jaton jane wishakaati bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jaskara kopíra José, ja Galilea main iká Nazaret janeya jemameax, ja Judea main iká Belén janeya jeman kaa iki, ja apo David jainoax pikóniainko. Ja José iká iki ja apo ipaoniton rareboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jatian ja wishakaati kaaira, jawen awin María betanbi kaa iki, jatian María iká iki tooya. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jatian ja Belénhain ikanaitianra, moa María bakenti oxe senena iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jainoaxa, jawen reken benbo bake pikota iki; pikóketianra chopan rakawaa iki, jainxon jan yoinabo pimakanai jawékiain rakana iki. Jain ikanti xobobo bocho ikax jainshaman jabo iti yama iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jatian ja Belén jema ochómaribi, jaton yoinabo yamé koirani jonibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jain iikanaitian, non Ibon ángel jatoki pikota iki. Jainxonra non Ibon koshi shinanman jato tenaaketana iki; jatianra kikinni ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jatian ángelnin jato neskáakin yoia iki: “Rakéyamakanwe, jakon joi mato yoiira, ea joke ja ninkataxa jatikaxbi mato rarokanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ramara ja Davidkan jemameax jan mato kishpinmati pikóke, ja riki *Cristo, ja Ibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Neskarabo oinxonra maton onanti iki: Ja bakeshoko chopan rakawaxon jan waka pimakanainko rakankanashokora maton merati iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jaskati iikanaibi ratéresi ja ángel betanbi, kikin icha ángelboribi naikanmeax bea iki. Ja beax Dios rabii bewai neskákana iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Naikamea Diossa non rabiai! ¡Ja nato mainxon jawen keena keská akai joniboribi, jakonbires ikanwe!” ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jatian jaskati senentaanan ja ángelbo moa boríbakana pekáo, ja oveja koirannai jonibo neskati yoyo ikana iki: —Belénhain bonon bokanwe, ja neskara jawéki ikábo non Ibonbi noa yoiabo oinni —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jaskatax ishton bokana iki, kaxon ja María betan José nokokana iki, jatian ja bakeshoko iká iki, jainxon yoina pimakanainko rakana. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jaskáakin ja bake oinxon jato yoikana iki, ja bakekiriakin jato ángelnin yoiwana joiboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jatian jaskáakin ja oveja koiranaibaon jato yoia ninkatax, jatikaxbi ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Jatian Maríabiribi jatíbi neskarabo moa onanna ikax, ja shinanyabi iita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jatian jaskáakin oinkin senenhataanan, ja oveja koiranaibo moa boribakana iki. Bokinra Dios rabiananbi iráke aabainkana iki; ja ángelnin jato yoia keskáshamanbo iká oinxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jatian ja bake pikota moa posaka neteya iketian, jawen jakina rebichi xatexonkana iki. Jaskáaxonra JESÚS, akin janekana iki. Ja María tootamatianbi, jaskáakin janeti ángelnin yoia iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jatian ja Dios bebon jakon inox, jatí neteyanix chokíti, ja Moiséssen esekan yoiai nete senenketian, ja bake Jerusalénhainoa Diossen xobo meran bokana iki non Ibo meninoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jaskáakinra akana iki, non Ibon kirika meran neskáakin yoiaitian: “Jatíbi reken bake pikotaibora non Ibonabiribi itiakin meniti iki”, iki ikaitian senenhakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jainxonra Dios jawéki menikana iki; ja non Ibon esé meran jaskáati yoiaitian, rabé nonbex iamaxon rabé xotó reteti iki ikaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jaskarabo inontianra, Simeón janeya joni, Jerusalénhain jaa iká iki. Ja joni iká iki jakon shinanya ixon Dios rabii jaa ikax, *Israel jonibo xabakaati manataribi. Ja Simeón iká iki, Diossen Shinan bochóya joniribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jara ja Diossen Shinanman moa onanmaa iká iki, ja non Ibon raanai Cristo oinnamabi mawátima. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jaskara ikaxa Diossen Shinanman onanmaa, Diossen xobonko kaa iki. Jatian Jesúsribi jawen anibaon jain ioa iki, ja esekan yoiai keská senenhakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jainoara Simeónman ja bake bitaanan ikota iki. Jainoaxa Dios rabii neskata iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ibó, moara ike jaskara iti min ea yoia en ointibo seneni, ramara ea min yonoti joni moa jakonax mawáti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Moara enbishaman oinke noa jan kishpinmati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Jara min raana iki; jara jatíbi jonibaon oinnoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Joékan akai keskáakinra jatíbiainoa jonibo tenanoxiki, jainoax ja min Israel jonibaon rabitiribi inóxiki”, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jatian ja baken papa betan tita ratébekona iki; Simeón ja bake yoii jaskatai ninkatax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jaskátaanan jawen aniboyabi ja bakeshoko Diossen jakonhanon ixon, Simeónman jatoki orana iki. Jaskáxon ja Jesussen tita Maríabiribi neskáakin yoia iki: —Oinwe, nato bake kopira icha Israel jonibo kishpinmeenoxikanai, itan icha joniboribi manótiain bonoxikanai; ikaxbi icha joniboribi jaki ramínoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Janra icha jonibaon ati shinannai jawékibo onannoxiki. Ikaxbi neskara jawékibo oinxonra espadanin bebanbainkin chachikana keská min shinannoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jatian jainribi ika iki westíora *profeta ainbo, jawen jane Ana, Penuelnin bake, ja iká iki Asernin rarebobaon bake, ja ainbo iká iki moa yoxanshoko. Jatian xontakotian benoax kanchis baritia, já betan jaa iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jatian ja ainbo benomaani iká iki moa posaka chonka chosko baritia. Jaskaranix Diossen xobo meranbi jaa ixon, yaméyabi netenbo Dios rabikatitai, jainxon *ayunankinboribi orankatitai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jatian Simeón yoyo ikaitianribi, ja ainbo jatoiba joá iki; joxon janribi Dios rabikin iráke aka iki. Jaskáaxon ja Jerusalénhainoa jonibo kishpinmai jotin manatabo jato yoia iki, ja bake jaskarabo ikákiriakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jatian non Ibon esé meran jaskáati yoiaibo senenhabaini, Galilea main iká Nazaret jemanko moa boribakana iki, ja iká iki jaton jemabiribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jatian anikinra ja baken onan shinanribi biboa iki, jainxon Diossen akinatonribi, ja bake jakonbires iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jaskara iken ja Jesussen anibo, baritiatiibi Jerusalénhain *Pascua fiesta winoti bokátikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jatian moa Jesús chonka rabé baritiaya iken, jaskatibiribi axea ixon, *Pascua fiesta winoti kakin, jawen anibaon Jesús Jerusalénhain iokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ja *Pascua fiesta moa keyóketian, Jesussen anibo moa jaton jemanko boríbakana iki. Jatian Jesúsbiribi Jerusalénhain baneta iki. Ikaxbi jawen anibaon onanyamareskana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ja Jesussen anibaon shinanna iki, ja joni icha bekanai xaran joái. Jaskáakin onanyamaax, westíora nete bain joxónpari, ja Jesús yamaa rotokana iki. Jaskáakin rotoxon jawen kaiboboiba itan wetsa jato betan beaiboiba benakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jaskáakin benakinbi nokoyamakana iki, nokoyamaax jawen anibo Jerusalénhain benai boribakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kaax nokóxon kimisha nete benaxonpari nokokana iki; ja Diossen xobo meran, Moiséssen esé onan jonibo xaran yakata. Jabaon yoiai joibo ninkáananbi ja joikiriakin jato yokati iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jatian ja baken jaskáakinbo jato yokatai ninkatax, ja bake onan iken, ja ninkataibo ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jaskara onan jonibo jato jaskáaitian oinnax, jawen aniboribi ratékana iki; jaskákin jawen titan neskáakin yoia iki: —Baké, ¿Jaweaki neno joxonki min noa akonbireskin benamaa? Min papa betanra en mia benakonshamanke. Mia kopira, non akonbireskin masá shinanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jaskáaketian Jesussen jato yoia iki: —¿Jawekopiki maton ea benai? ¿Matonki onanyamaa, nokon papan jawéki axoni ea iitai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jato jaskáakin yoiabi jawen anibaon onanyamakana iki, jawe yoiiki jaskatai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jatian jaskatax jawen anibo betan Nazarethainko moa Jesús kaa iki. Jain kaax jawen anibaon joi ninkáxonai iki jenéyamaa iki. Ikaxbi ja Jesús jaskáyantanabo jawen tita shinanbenoyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jainoax Jesús jawen onanti shinanyabi, jawen yoraribi anikaresa iki. Jainxon Diossen oinna itan jonibaon oinnaribi, jawe jakonmabi yama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jatian Tiberio iká iki, moa chonka pichika baritia ja icha mai iboaa apo jikia. Jatian Judea mainbiribi iká iki, Poncio Pilato jaton joni koshi. Jainoax Herodesbiribi Galilea mainmea joni koshi iká iki, jatian ja Herodesnin wetsa Felipebiribi iká iki, Iturea betan Traconite mainmea joni koshi. Jainoax ja Abiline main jaton joni koshi ikáribi iká iki Lisanias. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jatianribi ja *sacerdotebaon koshi iká iki, Anás betan Caifás. Jatian jabo jaskara inontianribi, jain joni jayamainkoxon, ja Zacaríassen bake Juan Diossen yoyo aka iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jaskatira jatíbi ja Jordán wean main iká jemabaon Juan kaa iki; akonkin jaton jakonma shinanbo jenetaanan bautizameekanon ixon jato joi yoiboi; jaskakanketian jaton ochabo moa Diossen shinanxontima kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jaskarabo iti yoikinra ja *profeta Isaíassen neskáakin wishanike: “Jawebi yama mananmameaxa joni neskati saí ikai: ‘Non Ibo joti bai benxoaxonkanwe, bai pontexonkanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jatíbi mai xankenbora bochoakanti iki, jatíbi mananbo itan manan kawishpobora, masenenhakanti iki. Ja yosho baibora pontekanti iki; ja jakonma baibora masenenhakanti. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jatíbiain iká jonibaonra oinnoxikanai, jan jato kishpinmati Diossen jato raanxona’ ”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ja Juanman jato bautizanon ikax jonibo bekanaitianra, jan jato neskáakin yoikatitai: “¡Mato riki, jakonmabo ikax, rono kaita keská jonibo! ¿Tsonki mato yoia, ja Diossen jato castigantinkoniax mato kishpinmeeti? ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jaskara iken maton jakonma shinanbo akonkin jenetaanan jakoni jakanwe, matonbinixbo: ‘¡Noara Abrahamman chiní rarebobo!’ ikibo iamakanwe. Diossenra nato makan inonbi Abrahamman chiní rarebo imati atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ja yamira moa taponyabiakin jiwi xatetires inon ixon, ja namanbi rakana iki. Ja jakoni bimiamai jiwibora, moa taxteanan chiikan menokanti jake”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jatian jonibaon yokákana iki: —¿Nonbiribiki jawe ati iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jatian Juanman jato yoia iki: —Ja rabé kotonyabaonra, ja jayáomabo wetsa koton jato meniti iki, ja pitiabaonra, ja jayáomabo jato akinti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jainoax ja apo jato kopí yokáxonaiboribi, bautizameekasi Juanhiba bekana iki; bexon neskáakin yokákana iki: —¿Nonbiribiki jawe ati iki Maestró? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jatian Juanman jato neskáa iki: —Rama jato kopí yokákin, bebonhira jato yokáyamakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jainxon jawetii sontárobaonribi, Juan neskáakin yokákana iki: —¿Nonbiribiki jawe ati iki? —akin. Jaskáakana jato yoia iki: —Rama tsoabi rakéaxonbo jato jawéki bichinyamakanwe, jainxon yankabires jato jakonma akátonin yoinyamakanwe, ja mato kopíakanaitoninbiribi jakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jatian jonibo ikana iki kikinni onankashorai manákana, jaskatira ikana iki jatíbi jonibo, Juanra ibirai ja *Cristo ikibo yokakanani. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ikaxbi Juanman jato neskáakin yoia iki: “Enra jato onpaxenres *bautizanai; ikaxbi epekaora westíora joni joái; janra Diossen Shinanman itan chiikan jato bautizanoxiki. Jara ea xewina atipana koshiya iki. Jaskara ikenra, jawen zapato risbitanibobi choroxonti senenma iki ea. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jara moa jan payánti tsomáya joái, ja trigo bimibo payanhanan jawen xakábo potamanox. Ja bimibichores bixonra, jain benxoatinko benxoanoxiki. Jatian ja xakábobiribira, jawetianbi tiriti nokayamai chii meran potaxon menonoxiki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Neskáakinbo, itan icha meskó eséboribi yoiananra, jakon joi Juanman jonibo yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jainxonra ja joni koshi Herodessibi notsina iki; jawen wetsa Felipen awin Herodías awinhaka iketian, itan wetsa jakonma jawékiboribi aká kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ikaxbi jaskáakin akára, moa siná teneti atipanyamaxon, Herodesnin jato cárcel meran Juan amaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jatian jonibo bautizani Juan iitaitianra, Jesússibi kaax bautizameeta iki. Jatian moa orani ikaitianra nai chopeta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jaskataitianra jishtibires Diossen Shinan, westíora xotó keska jaki joá iki; jatianra naikanmeax neskati yoyo ikai ninkata iki: —Miara nokon noi Bake iki, mionra ea kikinbiresi raroai —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jatian jawen tee akin peonontianra iká iki, Jesús moa kimisha chonka baritiayabira. Jara iká iki, Josekan bake, ja ikonhakanai keská. Jatian Joséra iká iki Elikan bake, ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ja Elí iká iki, Matatnin bake, ja Matat iká iki Levikan bake, ja Leví iká iki, Melquinin bake; ja Melquí iká iki, Janaikan bake; ja Janai iká iki, Josekan bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ja José iká iki, Matatíassen bake; ja Matatías iká iki, Amóssen bake; ja Amós iká iki, Nahúmman bake; ja Nahúm iká iki, Eslíkan bake; ja Eslí iká iki, Nagainin bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ja Nagai iká iki, Máatnin bake; ja Máat iká iki, Matatíassen bake; ja Matatías iká iki, Semeikan bake; ja Semei iká iki, Joseckan bake; ja Josec iká iki, Judakan bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ja Judá iká iki, Johanánman bake; ja Johanán iká iki, Resan bake; ja Resa iká iki, Zorobabelnin bake; ja Zorobabel iká iki, Salatielnin bake; ja Salatiel iká iki, Nerin bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ja Neri iká iki, Melquinin bake; ja Melquí iká iki, Adikan bake; ja Adí iká iki, Cosamman bake; ja Cosam iká iki, Elmadámman bake; ja Elmadám iká iki, Ernin bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ja Er iká iki, Josuénin bake; ja Josué iká iki, Eliezernin bake; ja Eliezer iká iki, Jorinman bake; ja Jorin iká iki, Matatnin bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ja Matat iká iki, Levikan bake; ja Leví iká iki, Simeónman bake; ja Simeón iká iki, Judakan bake; ja Judá iká iki, Josekan bake; ja José iká iki, Jonamman bake; ja Jonam iká iki, Eliaquimman bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ja Eliaquim iká iki, Melean bake; ja Melea iká iki, Menan bake; ja Mena iká iki, Matatanin bake; ja Matata iká iki, Natánman bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ja Natán iká iki, Davidkan bake; ja David iká iki, Isaíkan bake; ja Isaí iká iki, Obedkan bake; ja Obed iká iki, Boozsen bake; ja Booz iká iki, Salmónman bake; ja Salmón iká iki, Nahasónman bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ja Nahasón iká iki, Aminadabnin bake; ja Aminadab iká iki Admínman bake; ja Admín iká iki, Arníkan bake; ja Arní iká iki Esromman bake; ja Esrom iká iki Faresnin bake; ja Fares iká iki Judakan bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ja Judá iká iki Jacobnin bake; ja Jacob iká iki, Isaacnin bake; ja Isaac iká iki, Abrahamman bake; ja Abraham iká iki, Tarékan bake; ja Taré iká iki, Nacornin bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ja Nacor iká iki, Serugnin bake; ja Serug iká iki, Ragaunin bake; ja Ragau iká iki, Pélegnin bake; ja Péleg iká iki, Ebernin bake; ja Eber iká iki, Selajkan bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ja Selaj iká iki, Cainánman bake, ja Cainán iká iki, Arfaxadnin bake; ja Arfaxad iká iki, Semman bake; ja Sem iká iki, Noekan bake; ja Noé iká iki, Lameckan bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ja Lamec iká iki, Matusalénman bake; ja Matusalén iká iki, Enocnin bake; ja Enoc iká iki, Jaredkan bake; ja Jared iká iki, Mahalaleelnin bake; ja Mahalaleel iká iki, Cainánman bake; ");
INSERT INTO shpNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ja Cainán iká iki, Enóssen bake; ja Enós iká iki, Setkan bake; ja Set iká iki, Adánman bake; ja Adán iká iki, Diossen bake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jatian Jesús Diossen Shinan kikinni bochoax, ja Jordán weanhinoax, moa karibaa iki. Jainxonra ja Shinanman jain joni jayamainko ioa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jainra chosko chonka nete iká iki, jainoara Satanássen ochamakaskin tanaa iki; jatian jatí nete jawékiama ikaxa kikinbiresi jawékiakasa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jatianra *Satanássen neskáakin yoia iki: —Ikonkon Diossen Bake ixon, nato makan pan imawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jaskáaketian Jesussen yoia iki: —Wishá meranra ikai: ‘Jawékiatininbichora joni jayamake, ja Diossen yoiaibo senenhairibikayara joni jati jake’, iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jainoara *Satanássen manan keyá ikain boríbaa iki. Jain boxon, jatíbi nato netemea ani jemabo oinmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jaskáakin oinmaxon yoia iki: —Enra jatíbi nato jawékibo, itan nato jemabaon ani jawékibo mia meniti iki. Jabora nokona iki, jatian jaweratoboki en menikasai jabora en meniti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jaskara ikenra, ebebon chirankooxon min ea rabiketian, jatíbi nato jawékibo mina iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jaskáakin yoiabi Jesussen neskáa iki: —Wishá meranra ikai neskati: ‘Ja min Ibo Diosbichores rabiananbi, jabichores jawen keenabo axonkanwe’, iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jainxonra Satanássen Jerusalénhain Jesús ioribia iki. Jain ioxon Dios rabiti xobo bochiki boxon, chankakiina iki, jainxon neskáakin yoia iki: —Ikonkon Diossen Bake ikax nenoax naman choronwe; ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wishá meranra yoiai: ‘Diossenra jawen ángelbo raanti iki; jabaon koiraanan mia akinkanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Makanki choshiamanon ixonra, ja ángelbaon jaton mekenman mia tewankanti iki’, ikira ikai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jaskáabi Jesussen yoia iki: —Wishá meranra ikai: ‘Min Ibo Dios tanayamawe’, iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jatian wetsa keskáakinbo axon Jesús tanati atipanyamaax aríbanoxpari, jawetio basi já jenebaini moa Satanás kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jainoax ja Diossen Shinanman atipana koshi bochóya ikax, Galileanko Jesús karibaa iki. Jatianra jatíbiainoa jonibo jakiritibo yoyo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jaskara kaxonra, jain kaax nokotainkobo, jain tsinkíkanai xobo meranxonbo, jato axeakatitai. Jatianra jatíxonbi rabikatikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jatianra já jainoax ania Nazarethain Jesús karibaa iki; ja jeman nokotax tantiti neten, jain tsinkíti xobon kaa iki, jaskatibiribi axea ikax. Jain jikiax jato bebon chankata iki, ja Diossen kirika yoyo anox. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jainoara yoyo anon ixon, ja *profeta Isaíassen wishani kirika menikana iki. Ja kirika menia chopexon meraa iki, neskati iká wishá: ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ja Ibon Shinanra emeran iki; janra jawenashamanbi ea imaa iki, ja jawékiomashokobo, jakon joi jato yoinon ixon, janra ea raana iki, ja preso keskábo xabakaati, joi jato yoiti, ja benche keskabo jato oinmati; jainxon yonokin ramiareskanaibo jato xabáati, ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","itan ja non Ibon jato akinti nete nokota jato yoiti”, iki iká. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jainxonra Jesussen ja kirika moa xepoa iki. Jaskátaananra, jan jato akinnai joni moa menitaanan moa yakata iki. Jatíbi ja tsinkíti xobo meran ikábaon, jainbi kikinhakin oinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jainxon jato Jesussen neskáakin yoikin peoa iki: —Ramabira ike, mato bebonbi nato wishábo seneni —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jato jaskáa, Jesús yoii jakonires yoyo ikana iki; jainxon jakonhira joibo jato yoiaitianbo, ninkataxibi ratékana iki. Jaskatira neskatibo yokakaakana iki: —¿Natomarin ja Josekan bake ipachoai? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jaskákanaitian Jesussen jato yoia iki: —Ramara matonbi, ja neskákanai joi ea yoiti iki: ‘Jato raonai, minbixbi raomeewe’, akin. Jainxonra maton ea yoiribiti iki: ‘Ja Capernaúmhainxon min aká jawékibo non ninkánibo; rama neno min mainkoxonribi aríbawe’ —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jainxon jato yoiboresa iki, neskáakin: —Ikonshamanra en mato yoiai, tsoa *profetabira jawen jeman jaa jonibaonbi jakonhayamakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ikon riki, ja *profeta Elías inontianra, naikanmeax oi beyamaitian, jatíbiain ikonbiresi jawékiatinin ikana iki. Jatian icha benomaya ainboboribi *Israel jeman jakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ikaxbi Elíasra, ja *Israel jeman tsoa benomaya ainboboibabi, Diossen raanyamaa iki; Sarepta jeman iká benomaaya ainboibares raana iki. Ja iká iki Sidón jema iká ochóma. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jainoax ja *profeta Eliseo inontianribira, ja Israel main icha *lepra isinya jonibo jaa iki. Ikaxbi tsoabi benxoyamaa iki; ja Siriainoa Naamán janeya joniresa benxoa iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jaskáakin jato Jesussen yoia ninkátaanan, ja tsinkíti xobo meran weitabo, ikonbiresi jaki sinákana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jaskáaxonra yatanxon, ja jemamea pikoxon, ja jema iká manan maxkatenbi Jesús bokana iki, jainxon werannoxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jaskáakin bokanabira jato xaranmeaxbi jato potabaini moa Jesús kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jainoax Jesús Capernaúm jeman kaa iki, ja iki Galilea main iká. Jain kaxon ja tantiti netenbo jato axea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jaskáakinbo jato axeaitian ninkatax, jonibo ratékana iki. Koshi shinanyaxon jato akaitian ninkatax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jatian ja tsinkíti xobo meran iká iki, westíora joni yoshin naikia. Jaskara ikax, ja joni neskati koshin saí ika iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Noa jenewe! ¿Jaweatiki min noa teai Nazarethainoa Jesús? ¿Noa keyoiki mia joá? Enra mia onanke; mia riki Diossen ochaoma Bake —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jaskáaketian ja yoshin notsinkin neskáakin Jesussen yoia iki: —¡Netéwe yoshimá, ja joni meranoax pikówe! —akin. Jatianra jato bebonbi ja joni mai tsakamataanan, jameranoax pikókinbi, ja yoshinman jawe jakonmabi ayamabaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jainoaxa jatikaxbi jonibo ratékana iki; jaskatax jatobires neskatibo yoyo ikana iki: —¿Jawekeska joikayarin nato? Nato joninra jatíbi jawen atipana koshiaxon, itan yoiti koshiaxon, yoshinbo jokonti yoiai; ¡Jatianra jabo pikókanai! —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jaskatira ja Jesussen jaskara jawéki akábo, jatíbi ja mainmea iká jemabaon ninkakaaketana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jainoaxa ja tsinkíti xobo meranoax pikókaini kaax, Simonman xobon Jesús jikia iki. Jain iká iki, Simonman rayos ainbo kikin yoná koshi aká rakata. Jatianra ja benxoanon ixon Jesús yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jatianra ja ainbo manaon beokainxon ja yoná Jesussen notsina iki. Jaskáatianbi ja ainbaon moa yoná jenea iki. Jatianbi wenixon, ja ainbaon jato jawékiamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jatian moa yametainshokobi, jatíbi meskó keskati isinaibo, Jesússiba bokana iki. Jaskáakin bokanketianra tii axonres jato benxoapakea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jainoax icha isinai jonibo meranoaxibi, yoshinbo jokona iki. Jaskati jokonira neskatibo saí ikana iki: —¡Mia riki Diossen Bake! —iki. Ikaxbi Jesussen yoyo imayamakin ja yoshinbo jato notsina iki; jara *Cristo iki ixon jabaon onanna kopí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jatian nete xabataishoko wenitax, ja jemameax pikókaini joni yamanko Jesús kaa iki. Ikaxbi jonibora ja benai boax já ikainko nokóxon, kayamanon ixon jainbi banémakaskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ikaxbi Jesussen jato yoia iki: —Wetsa jemankoboribira ja Diossen ikinaton iti jakon joibo en yoiti jake; ja ati kopíra nato neten ea Diossen raana iki —akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaskáakinra ja Judeain iká jain tsinkíti xobo meranxonbo, ja jakon joibo jato Jesussen yoiboa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Westíoraira Jesús ja Genesaret ian kexá iká iki; jain ikenra, ja Diossen joi ninkákaskin, joni ichan bitaxkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jainxonra Jesussen oinna iki, ja rikanaibaon rabé bote jawebioma, mashin repia. Ja bote ibobo ikana iki, mapéxon jaton rika chokai tsamákana. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jatian wetsa bote iká iki Simónmana, jain Jesús naneta iki. Jainxon yoia iki napoorichashoko ja bote axonti. Jainoaxa ja boten Jesús nayakaa iki; jainxon jonibo jato axeakin peoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jaskáakin jonibo jato Diossen joi yoikin senenhataanan, ja Simón yoia iki: —Ja min bote napoori boxon, maton rikabo jain nepókanwe, maton yapa binon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jaskáaketian Simonman Jesús yoia iki: —Maestró, yaméra non aashinai rikankin; ikaxbira jawe yapabi non biamawanke. Ikaxbi min ati yoiara en akai ja rika nepókin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jatian jaskáati yoia nepóxonra, icha yapa bikana iki, jaton rikabobi noshinon kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jaskara iken ja wetsa boten iká, jato betan teetai jonibo kenakana iki, jato akini bekannon ixon. Jatianra jabo bexon, jaton rabé botebi bochoakana iki, kikin jikiibishokobo itiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jaskáaketian oinnax Simón Pedro Jesús naman joáx, chirankoota iki. Jainxon neskáakin yoia iki: —Ebé iamawe Ibó, eara ochaya joni iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jatian Simón itan jabé ikábora ikana iki ratékanabo; ichayora yapa biax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jainoax ja Simón betan teetaibo, Zebedeon bake rabé, Santiago betan Juanribi, kikinni ratékanabo ikana iki. Ikaxbi Jesussen Simón yoia iki: —Rakéyamawe, nenoax pekootaxa, rama mia joni biaibiribi ikai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jato jaskáaketian jaton bote repintaanan, jain iká jatíbi jaton jawékibo potabaini, Jesús betan bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wetsa netenra, westíora jeman Jesús iketian, *lepra isinya westíora joni jaiba joá iki. Joxon Jesús oinnax, ja namanbi chirankootax maikibi bekepia iki. Jainxon Jesús neskáakin yoia iki: —Ibó, keenxonra nokon isin min ea benxoati iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jatian Jesussen mekenman tii axon, neskáakin yoia iki: —Eara keenai. ¡Benxowe! —akin. Jaskáatianbi, ja jonin *lepra isin moa benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jatianra Jesussen yoia iki: —Tsoabi keshanyamawe; pontékainxonres ja *sacerdote oinmatanwe, jainxon ja Dios bebon jakon iti kopi, ja Moiséssen jaskáati yoini keskáakin, Dios jawéki menitanwe, moa mia benxoa sacerdotebaon onankanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jaskarabo ikenbira, jatíbiain ja Jesussen aká jawékibo ninkakaaboresa iki. Jaskatira icha jonibo tsinkíakeresa iki, ja Jesussen yoiaibo ninkati. Jainoax jaton isinbo jato benxoanon ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ikaxbira Jesús tsoabi yama ikainkobo orani kakatiai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wetsa netera Jesussen jato joi onanmai iitaitian, jawetii *fariseobo betan esé onan jonibo jain yakákana iká iki. Jabo bekana iká iki, Galilea main iká maxko jemameax, itan Judea main iká jemameax, jainoax Jerusalénhainoaxibi. Jatianra Diossen atipana koshi Jesús meran jishtia iki, ja isinaibo benxoaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jatianra jawetii jonibaon, westíora kishi jirioma joni, rakátinin axon bekana iki. Bexonra xobo meran jikimaxon Jesús bebon rakankaskana iki; ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ikaxbira jaoraoshamanxon jikimati merayamakana iki, ichayora joni iketian. Jaskara ikenra ja xobo pekaten mapéxon, ja xobo pebíanan kiniaxon, jawen rakátininbi axon; ja joni icha xaranbi apakexon, ja isinai joni Jesús bebon rakankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jatian jan beabo, ja ikonhaax jaki koshikana ointaanan, Jesussen ja isinai joni neskáa iki: —Joní, min ochabora en moa mia shinanxonyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jatianra ja esé onanbaon, itan *fariseobaon neskáakinbo shinankana iki: “¿Tsoarin nato, ja Dios yoii jakonmaibires yoyo ikai? Diossenbichora non ochabo moa noa shinanxonyamati atipanke”, akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ikaxbi Jesussenra, jaskáakinbo shinankanai onanxon, jato neskáakin yokata iki: —¿Jaweatiki maton jaskáakin shinannai? ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jaweraki yoitikayaki atibires itiki: ‘Min ochabora en mia shinanxonyamai’, akin ati, iamax: ‘Wenitax katanwe’? akin ati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Enra mato oinmai, nato mainra ja jonin Bake, jonibaon ocha akábo moa jato shinanxonyamanoxon yoiti koshiya iki ixon —akin jato aká iki. Jaskátaanan ja isinai joni neskáa iki: —Enra mia yoiai, wenixon min rakáti bibaini, min xobon katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jaskáatianbi, ja kishi jirioma joni, jato bebonbi wenixon, jawen rakáti bitaanan jawen xobon moa kaa iki. Kakin Dios rabi rabibaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jatianra jatíbi jonibo ratékana, jainxonra Dios rabikana iki; jainoaxa kikinni raketi neskatibo yoyo ikana iki: —Ramara non ake jan ratéti jawékibo oinkin —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jaskara aká pekáora, moa Jesús jainoax kaa iki. Kakin Leví janeya westíora joni nokoa iki, jainxon Romamea apo jato kopí yokáxonai xobonko yakata. Jainoa Jesussen neskaa iki: —Ea chibanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jatianra Leví jatíbi jawen jawékibo jenetaanan Jesús betan kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jainxonra Levikan, jawen xobon Jesús ioxon, rarokin ani fiestaaxona iki. Jaskáaxon jato chania, jato betan jawékiai ja apo jato kopí yokáxonaiboyabi, wetsa joniboribi jain tsinkíkana iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ikaxbi ja jaskara esé chibanaibobires ixon, fariseobo betan esé onan jonibaon, ja Jesussenmea onannaibo jakonmaakin yoikin peokana iki. Jainxonra neskáakin yoikana iki: —¿Jaweatiki jakopí yokámisaibo, itan ja ochaya jonibo betan maton jawékiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jatian Jesussen jato yoia iki: —Ja isinhomabora jato raonai joni benatinin maxkáyamake. Isinaibokaya riki jato raonai jonin akintinin maxkatabo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eara ja jákonman shinanmeetaibo benai joáma iki. Eara joá iki ja ochaya jonibo kopí; jaskáaxon jabaon Dios ikonhanon ikax —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jainxonra jonibaon Jesús yoiribikana iki: —Ja Juanmamea onannaibo betan ja fariseobaomea onanaibaon akanai, jatíbitian *ayunankin, itan akonbireskin orankin, jatian mionmea onanaibaonbiribi akanai, jatíbitian piananbi xeakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jatian Jesussen jato yoia iki: —Jawetianbira wanokanai fiestanko, jato chania bekanketian, maton jato jawékiati tenemati atipanyamake, ja wanoai joni jato betan iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ikaxbi netera nokónoxiki, ja wanoai joni moa bokanti, jatianparira ja chania bekanabaon jawékiati tenekanti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jainxonra neskara jawékiki jato yoinribia iki: —Tsonbira chopa bena xatetaanan jan payo chopa onayosma iki; jatian jaskáakin onaara, ja bená chopan ja payo chopa waxaresai. Jainoax ja bená choparibi, ja payo chopaki onaa ikax jakon banéyamai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jainxon tsonbiribi payo bichi chomon, bená vino nachíosma iki; jaskáakin akábira, bená vinon ja payo bichi chomo toá akai, jaskatira ja vino betan ja bichi chomoribi, moa jawemabi banetai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jaskánaketianra ja bená vino, bená bichi chomonribi nachíti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jainoax tsoabira ja pae vino xea pekao, ja paema vino xeakasibo iamakanai. Jaskatira ikanai: ‘Ja pae vinokayara kikin jakon iki’, ikibo —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jatian westíora tantiti netenra, Jesús jaonmea onannaibo betan, wai banakanbi bokana iki. Kakinra jaonmea onanaibaon trigo bimi texkan pinoxon xemekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jaskáakanaitian jawetii *fariseobaon jato yokata iki: —¿Jaweatiki ja tantiti neten jaskáatima ikenbi maton jaskara jawékibo akai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jatian Jesussen jato yoia iki: —¿Matonki ja jawékiakashorakin, jabé ikábo betan westíoraakin Davidkan aní jawéki yoyo akáma iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Janra ja Dios rabiti xobo meran jikixon, ja Dios menikana pan bixon pia iki. Jainxonra já chibanaiboribi, pikannon ixon jato menia iki, ja sacerdotebaonbichores ja pan piti akana ikenbi —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jainxon jato yoiribia iki: —Ja jonin Bake riki, jawerin ja tantiti neten atibo ixon jan mato yoiti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jatian wetsa tantiti neten, Jesús jain tsinkíkanai xobon jikia iki. Jain jikixon axeakin peoa iki. Jainribi iká iki, westíora joni jawen mekayao meken jirioma. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jatian jainribi ikana iki esé onan joniboyabi fariseobo; ja tantiti netenbimein Jesussen benxoai ixon paranaxon oinni. Jaskáaxon jakibo yoinxon ramiati shinanyanix. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ikaxbi, janra jaskarabo shinankanai onanxon, ja meken jirioma joni neskáakin yoia iki: —Wenitax joáx, jain napon chankawe —akin. Jaskáakin yoia, wenitax chankata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jainxon jato Jesussen yoia iki: —Rama en mato yokábanon ninkákanwe: ¿Ja tantiti neten non jawe atiki yoiai? ¿Jakon jawéki ati ó jakonma jawéki ati? ¿Mawatainbi jato kishpinmati, ó jato mawámaresti? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jaskáaxon jain ikábo jato beísaketana iki; jainxon ja meken jirioma joni yoia iki: —Min meken sananwe —akin. Jaskáakin yoia sananatianbi, ja jonin meken benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ikaxbi wetsabobiribi ikonbiresi sinákana iki, jaskáaxon shinan akana iki, ja Jesúski jaweakantiki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jatian ja netebaonribira mananmanxon orani Jesús kaa iki. Jainra orani Dios betan yoyo iki yamé iishina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Moa nete xabáketianra, jaonmea onannaibo jato kenaa iki. Kenaxon chonka rabéres jato katota iki; jabora jato janea iki, raanabo akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jabo iká iki: Simón, jaribi janea iki Pedro akin; jainoax ja Simonman wetsa Andrés, jainoax Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeon bake Santiago, jainoax Simón, ja Zelotebo betan nia ikátiai, ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jainoax Santiagon bake Judas, jainoax Iscariote, ja jakonhai keská ixonbi jan Jesús jakonmaani. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jaskáakin senenhataanan, mananmameax moa Jesús ipakea iki; jawen katota joniboyabi. Beax ja manan teshanpa ikain ikana iki; Jatian ja icha joni tsinkitabo ikana iki Judea mainmeax, Jerusalénhainoax, jainoax ja Tiro keibakeax, itan ja Sidónhainoax bekanaboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jabora ja Jesussen joi yoiaibo ninkati itan jaton isinbo jato benxoanon ikax bekanabo ikana iki. Jatianra ja yoshinbo jato meran naikixon, jato masá tenemaiboribi jato benxoaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jatíbi jonibora Jesús tii akaskana iki, já meranoax pikotai jawen atipana koshin jato benxoai oinxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jatian Jesussen jaonmea onannaibo jato beísaketana iki; jainxon jato yoia iki: “Diossenra raroshaman imati iki, ja mato Dioskires ikoni koshiax jakanabo. Matonakayariki ja Diossen ikinaton jati nete. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Diossenra raroshaman imati iki, ja pikasi, itan nomi mato rama iitaibo. Matora jawekiatinin maxkáyamanonxiki. Diossenra raroshaman imati iki, ja onisi winii mato rama iitaibo; jaskata pekáora mato raroshaman inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Diossenra raroshaman imati iki, ja jonin Bake kopí, jonibaon omiskanaibo, ja jawemabiakin shinankanaibo, ja ichákanaibo, ja jakonma jawéki atin, jaton jane omisnankanaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mato jaskáakana raroananbi kikini benenoxikanwe ja nete. Naikanxonra Diossen kikin jakonhakin mato ikinoxiki. Jaskáakinribira, moatian jaton reken papashokobaonribi ja *profetabo jakonmaapaokanike. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ikaxbi, ¡Jawe iresaipanon, rama ja mato jatíbi jawékia ikax moa jakonbires jakanabo! ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Jawe iresaipanon, ja rama mato jatíbi jawékiatinin maxkáyamaibo, matora jawékiatinin inoxikanai! ¡Jawe iresaipanon, ja ramatian raroi jakanabo, matora onisi wininoxikanai! ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Jawe iresaipanon, ja jatíxonbi kikin joniboakin shinankanaibo! Jaskáakinribira ja janso *profetabo, jaton reken papashokobaon jato shinanpaonike. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ikaxbi, ja en yoiai ninkati tsamatabora en mato yoiai: Maton rawibo noikanwe, mato omisaibo jato jakonhakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mato ramímatiakinres shinanxonaiboki, jakonres shinankanwe. Jainxon matoki shirokin mato join imakanketianbo, jatoki orankanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jawekeska ixon wetsa jonin ati iki mato tantash akin; wetsaori amaribinoxikanwe, jainxon mato jan perakooti choparibi mato boonkana, maton kotonribikaya jato bomaresnoxikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wetsabaonbires mato jayata jawéki mato yokákana; meniresnoxikanwe. Jatian jaweratobaonki matona ikenbi mato jawéki bichinai, moa yokáyamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jaskara iken, wetsabaon mato jaskáatinin mato keenai keskáribiakin, matonribikaya wetsabo jato jaskáakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jatian ja mato jakonhaibores maton jato noiabira, wetsaresibi jawékima iki; ja ochaya jonibaonribira jato jaskáai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jainxon ja mato jakonhai joniboresibi, maton jato jakonhabira, wetsaresibi jawékimaribi iki, ja ochaya jonibaonribira jaskáakinribi jato jakonhai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jato jawéki menikin, mato kopikin menishkokanti shinanyaxonres jato menikinbira, wetsaresibi jawéki maton ayamai; ja ochaya jonibaonribira jato jaskáai, jatoibakea bishokoti shinanyaxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jaskara iken, maton rawíbo noianan jato jakonhakanwe; mato kopikin menishokokanti shinanhomaxon jato menikanwe. Jaskáakinra ani jawékibo maton biti iki, itan ja ani Diossen bakekonshaman mato iti iki. Janra jakon shinanyaxon, ja jakonma jonibo itan Dios iráke ati onanma joniboribi jato akinnai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jaskara iken, ja maton Papan jato akai keskáribiakin, jato onísakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tsoabi jaton jakonma akábo yoixonyamakanwe; jatianra Diossen mato jaskáashokotima iki. Jainxon jakonma akanketianbo, jato ramiayamakanwe; jatianra Diossen mato ramiayamashokoti iki. Mato jakonmaakanabo moa jato shinanxonyamakanwe; jatianra mato Diossen jaskáashokoti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jato jawéki menikanwe; jatianra mato Diossen menishokoti iki. Janra mato meniti iki; ja saco meran jakonshamanhakin napóanan, kikinhakin bochoaka keskáakin. Jawe jawékiki maton jato menia iki, jaribira mato Diossen meniti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jainxon Jesussen jawékiki yoinribikin jato neskaa iki: “Westíora benchenra, jawekeskaxonbi jabé benche ioti atipanyamake; jatian jaskáakin ioibira rabekaxbi kini meran pakébekonti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jawerato axeai jonibira, jawen maestro bebon onan iti atipanyamake. Jawetianki jan onankin senenhai, jatianparira jawen maestro betan senen onanribi iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jawekopiki ja wetsa maxkoshoko nisá bepokoota iken, min jares oinxonai; ja mia jiwi aniosi bepokootakaya ointitianbi? ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Jawekeskaxonki ja min wetsa, nisá bepokoota iken, min bixonti iki; ja mia jiwi aniosi bepokoota, minbipari tsekaama ixonbi? ¡Beparametaibo riki mato!, matonparikaya ja aniosi mato bepokoota tsekakanwe. Jaskáaxonparira moa jakonhakin oinxon, ja min wetsa nisá bepokoota min tsekaxonti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jawetianbira jakon jiwi, jakonma bimia iti atipanyamake, jatian ja jakonma jiwibiribi, jakon bimia iti atipanyamaribake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jiwibora non onanai iki, jawen bimibo oinxonres. Jaskara ikenra, ja moxa jiwimea higo bimi non tsekati atipanyamake; jatian zarza jiwimeabiribi non uva bimi tsekati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Westíora jakon jonira jakon jawékibores yoyo ikai; jakonhakin shinanires jaa ikax; ikaxbi jakonma jonira jakonma jawékibores yoyo ikai, jawen shinan meran jakonma iken. Jawekeskaraki jonin shinannai, jaskarara joni yoyo ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Jaweatiki, ‘Ibó, Ibó’, akin maton ea janeai, nokon keenai keskábo axonkinmabi? ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ramara en mato yoiai, jatíbi ja nokon joi ninkáxon jan yoiai keská senenhaiboki, jawe jawéki keskábo iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jabo riki jonin xoboakin aní keska; rekenparira neminhakin chinianan, shankaki witábo nichina iki. Jatian jenetiaxon mapoara, ja xoboki bai koshi tsakákinbi shakonyamabobia iki; ja xobo witabo kikinhakin nichina iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ikaxbi ja en yoia joibo ninkáxonbi, nokon keena keskábo ea axonyamaibo riki; jonin mai chinixonres, jaki koshitibo ayonxonmabi xoboani keskábo. Jatianra basitanima bai koshin, ja xobo poxaa iki; jaskataxa kikini ras ika iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jatian moa jato joi yoikin senenhatanan, Jesús Capernaúmhain kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jain iká iki westíora romano sontárobaon oficial. Jan akonbireskin noia jawen yonoti iká iki, isini mawatibishoko. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jatian Jesús yoii ikanaibo ninkáxon, ja oficialnin, jatíribi judíobaon joni koshibo, Jesússiba jato raana iki; ja jawen yonoti isinai benxoai joyamaama joti yoikanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jato jaskáa boxon, joyamaama joti Jesús neskáakin yoikana iki: —Atibira nato sontárobaon koshi oficialnin yokatai min akinti jake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Janra non kaibo judíobo jato noike. Janribira, jain tsinkíti xobo noa axona iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jaskáakana, jato betan Jesús kaa iki; jatian moa xobonko nokoti bokanaitian, ja *capitánman, jawen onanna jonibo jato raana iki, bechixon neskáakin yoikanon ixon: “Ibó, jakonma shinanyamawe, nokon xobontanibobi, mia jikimati jisámabobi riki ea. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jaskara kopíra eabishaman mia benai kayamawanke. Ikaxbi ja nokon yonoti benxonon ixon, ea yoixonreswe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Enribira nokon koshibaon yonoa jato senenhaxonai. Jainoaxa, en ikinna sontároboribi jake; jatian westíora en jain katanwe akin yoiara kaai, jatian neri jowé akin en wetsa akára, joái; jatian nokon yonoti en jawéki ati yoiara akai”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jatian jaskáakin yoikana ninkatax, Jesús ráteta iki. Jaskáaxon, já chibani bokana jonibo, jato neskáakin yoia iki: —Ikonshamanra en mato yoiai: Nato *Israel mainra, nato jonin akai keskáakin ea ikonhai joni, en jawetianbi nokoisma iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jatian jakiribi moa xobon banéxon, ja raanwanabaon oinkana iká iki, ja yonoti moa benxoa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jaskáa pekáo, Nain janeya westíora jemanko Jesús kaa iki. Jain kaaitian jaonmea onannaibo, itan icha joniboribi já chibani bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jatian ja jema xepotiain moa nokoti kakin oinna, mawá miinnoxon boí ikana iki. Ja mawá iká iki, benomaata ainbaon jabicho bake, jatian ja mawá miinkini boaibo ikana iki icha joni. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jaskara oinxon, ja ainbo Jesussen noibaa iki; jainxon yoia iki: —Winiamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jaskáatanan ja mawá nokobainxon jan bekanai cajón yatana iki. Jatianra ja mawá iata jonibo jainbi charókana iki. Jainxon ja mawá Jesussen neskáakin yoia iki: —Bakeranon, weníwe akinra en mia akai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jaskáa, ja mawá iwana yakáinakainax moa yoyo iki peokoota iki; jatianra Jesussen moa jawen tita menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jaskara oinnax ratéxonra, jatíxonbi Dios rabii neskákana iki: —Westíora ani *profetara nooxaran nokóke —ikibo. Jainoax neskáribikana iki: —Jawen jonibo jato akinira Dios joke —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jatian jaskara jawékibo Jesussen aká joira, jatíbi Judea main itan ja patax iká jemabaon ninkakaaketana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jatian Juanmanra jatíbi neskara joibo ninkata iki, jawen jonibaon yoia; jaskara ninkáxonra, jawen joni rabe kenaxon, ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ja Iboiba jato raana iki ¿Miarin ja joti yoikani, iamaxon wetsaki non manati iki? akin yokákanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jatian boxon, Juanman jonibaon neskáakin Jesús yoikana iki: —Jato *bautizanai Juanmanra noa raanke, ¿Miarin ja joti yoikani, iamaxon wetsaki non manatiki? akin mia yokáti —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jatianbira icha isini onitsapitaibo jato Jesussen benxoa iki, jainxon ja yoshin naikiaboribi jato pikoxona iki; jainxon icha bencheboribi jato oinmaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jaskáakin senenhataanan, jato neskáakin yoia iki: —Rama moa botankanwe, kaxon Juan yoitankanwe, jaskara maton oinnabo itan jaskara maton ninkatabo. Benchebaonra moa oinke; chantobora moa nikanai; ja *lepra isinyabora moa benxokanke; pabebaonra moa ninkákanai; mawábora jiriai; ja jawékinin maxkatabora ja bená joi jato yoikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Diossenra raroshaman imati iki, ja ea ikonhaax eki koshii jenéyamaibo! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jatian ja Juanman raana jonibo, moa bokana pekáo, Jesussen ja tsamata jonibo, Juankiriakin yoikin jato neskáa iki: “Ja jain joni jayamainko kaxonki ¿Tsoa joni maton oinna iki? ¿Westíora tawa nia niwen shakonai? ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Jainxonki jaweribi maton oinna iki ¿Westíora joni jakon chopa saweya? Akáma. Matonra onanke, ja jakon chopa saweaibo, itan jan raroti jakonma akaibo, ja apobo jain teetai xobonko jakana. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jainxonki jaweribi maton oinna iki? ¿Westíora *profetaki maton oinna iki? Ikon riki, jara maton oinna iki; jara westíora *profeta xewina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ja Juan yoiira ikai Wishá meran neskati: ‘Mia raanamatianbira, en wetsa jonipari raanai; jan mia kati bai, mia benxoaxonon’, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Enra mato yoiai, jatíbi jonibo xaranra tsoa jonibi, Juan xewina yamake; ikaxbi tsoaki, ja Diossen jato ikinaton jaa joni iki, jara Juan xewina iki”. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jatian neskara ninkáxon, jatíbi jonibaon itan jato kopí yokataibaonribi ikonhakana iki, Diosra jakon iki ixon. Jatianra Juanman jato bautizana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ikaxbi ja *fariseobo betan esé onan jonibaonbiribi, Juan bautizamayamakana iki. Jabo jato jaskámati Diossen shinanna ikenbi keenyamakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Jatian ¿Jawekiki ja ramatian jonibo en yointi iki? ¿Tsoa keskaborin jabo? ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jabo riki bakebo plazain tsamatax tsinii saa ikanai keskábo; jaskatira ikanai neskati: ‘Non mato quena xon axonabira, mato ransayamaa iki, mawákanketian iti bewábo noa bewakenbira mato winiamaa iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ja jato *bautizanai Juanra iká iki pan piosma itan vino xeayosma; jatian matonra akai, yoshin naikia riki ixonbo yoikin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jainoaxa ja jonin Bake joá iki; jara xeai itan piai iki. Jatian maton akai, nato riki naxki joni itan paenai, jainoax ochaya jonibo itan kopí yokámisaibo betan raenanai akinbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ikaxbi ja Diossen onan shinanra jishtiai, jatíbi jan akainkobo”, akinra jato Jesussen aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jatian westíora fariseo joxon, jawen xobonko pikinnoxon Jesús kenaa iki. Jaskáakin kenaa kaax, jawen xobon jikia iki; jainoax mesan yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jatian ja jemanribi westíora ainbo iká iki; jakonma jawékibores akí ochai jaa, jatíxonbi onankana. Ja ainbaon onanna iki, ja fariseon xobon pii Jesús kaa. Jaskara onanax, *alabastro akana botírianin, kikinbires kopí ininti bochóya, Jesússiba kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jain joáx, winiananbi Jesussen tae pataxbi yakata iki, jainxonra jawen beonmanbi, tachota iki, itan jawen bookanbi tasoa iki, jaskáaxonra tatsó aka iki. Jaskáakin senenhaxon, ja ininti boatonin, Jesussen tae sikaanan ininhaxona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja ainbaon jaskáaketian oinxon, jan piti kenaa fariseon, neskáakin shinanna iki: “Ikon *profeta ixonra, ochaya ainbo riki nato ea tii aki iitai, ixon onankeanke”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jatianra Jesussen ja fariseo neskáakin yoia iki: —Simón, westíora jawéki mia yoibanon —akin. Jaskáa yoia iki: —Ea yoiwe maestró —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jatian Jesussen yoia iki: —Rabé joninra, westíora joni koríki ribina iká iki; westíoranin ribina iká iki, pichika pacha nete teexon bititii; wetsan aká iká iki, chonka pichika nete teexon bititii. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jaskáakin ribinxonbi, moa kopíati atipanyamaketian, ja rabekan ribinbi ja jonin, moa jato shinanxonyamaa iki. Rama ea yoiwe ¿Jawerato ja ribinya joninmein bebonbires noia iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jaskáa Simonman yoia iki: —En shinannara, ja bebon icha ribinya jonin aká iki —akin. Jatian Jesussen yoia iki: —Ikonra min yoike —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jatian ja ainbo ointaanan, ja fariseo Jesussen neskáa iki: —¿Minki oinna nato ainbo? Min xobon ea merati jokenbira, onpaxtanibi min ea meniamake; ea jan tachokiinon ixon. Ikaxbi nato ainbaonres ake, jawen beonmanbi ea tachóanan jawen bookanbi, nokon tae ea soaxonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Minra ea betsó ayamabobike; ikaxbi nato ainbaonra, jowanxonbi ea tatsó akin jeneyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Minra ea xenin nokon maponko ea sikayamawanke; ikaxbi nato ainbaonra inintinin nokon tae ea inínhaxonke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaskara ikenra en mia yoiai; jan ea akonbireskin noia riki, jawen jatíbi ochabo en moa shinanxonyamaitian. Ikaxbi ja jaton ocha akábo, jaakin jato Diossen shinanxonresaibaonra, kikinshamanhakin ea noiamai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jatian jaskáatanan ja ainbo neskáa iki: —Min ocha akábora en moa mia shinanxonyamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jaskáaketian ninkatax jabé jawékiaibo, neskatibo yoyo ikana iki: —¿Tsoa jonirin nato, jaton ocha akábo jato soaxonai? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jaskákanainbi Jesussen ja ainbo neskáakin yoia iki: —Ea ikonhaax mia eki koshia kopíra, mia kishpinke, rama moa jawekeskabo shinanyamai jakonax katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jaskarabo iká pekáo, icha ani jemabaon itan maxko jemabaonribi, ja Diossen ikinaton jati bená joi yoii Jesús kakátiai; jatian jawen chonka rabé jaonmea onanaiboribi jabé bokátikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jainoax jaweti ainboboribi jabé bokátikanai; jatíribibo iká iki, yoshin jato jokonhaxonabo; jatíribibo iká iki isinaitian jato benxoabo. Jainoax jato xaranribi iká iki, ja *Magdalena akin akanai Maríaribi, já meranoax kanchis yoshin pikota ainbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jainoax ja Cuza janeya jonin awin Juanaribi; ja Cuza iká iki, Herodesnin jawéki koirani teetai, jainoax Susanaribi. Jainoax jaton jayata jawékinin Jesús akinnai icha wetsa ainboboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jatian icha jonibo wetsa jemameaxbo Jesús oinni tsinkíkana iki. Jaskatira icha jonibo tsinkíkana iki; jainoara Jesussen, jawékiki yoinhanan jato neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Westíora jonira, bero banai kaa iki; kaxon masá akara, jatíribi berobo bai naposhaman maana iki; jain maanketian, jamákana iki; jainxon isábaonribi bexon, ja berobo pikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jatíribi berobo maana iki, makánbo xaran. Jain maannax xoxoaxbi mai mecháatibo maxkatax choshia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jatíribi berobo maana iki; moxa napo, jatian ja berobo betanribi ja moxabo xoxoa iki; jatian ja moxapari anixon, ja baná xoxoabo, mapoanan retea iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ikaxbi jatíribi berobo maana iki, mai jakon ikain; jaskataxa xoxoax ania iki. Jaskatira kikin icha bimia iki; westíora niábo pachabo bimia iki”, akin. Jaskáakin jato yoitaanan, koshi join jato Jesussen neskáa iki: “¡Ja ninkataibaon ninkákanwe!” akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jatian jaonmea onanaibaon Jesús yokákana iki; jawekeska yoikaskinki jaskara yoiwana ixon onankaskin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jatian jato neskáakin yoia iki: “Matora ja onanyamakana Diossen ikinaton jati en onanmai; ikaxbi wetsabora jawékiki yoinhananbo en jato onanmai; jaskatax oinnaxbi oinnama keskábo ikanon ixon, itan ninkáxonbi onanyamakanon ixonribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Neskara yoii iká riki, ja bero banai joniki yoinkin en mato aká: Ja bero riki Diossen joi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jatian ja bai napon maana bero riki, Diossen joi yoikanai ninkataibo. Ikaxbi *Satanás joxonra jan ninkata jawen jointi meran iká joibo shinanbenomai; jaskatax já ikonhaax kishpinmeekanaketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jatian ja makan xaran maana berobo riki, ja Diossen joi ninkatatianbi, keenshamankin ikonhaibo. Ikaxbi kikinishaman eki koshiamabo ixonra, jawetio basires ea ikonhakanai. Jatian meskó atikomabo nokoxonra, moa ea ikonhakin jenekanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jatian ja moxa napon maana berobo riki, ja Diossen joi ninkáxonbi, iikaanan, jaton meskó shinannai jawékibaon, icha jawékiya iti shinanbaon, itan jaton keenshaman ati shinanbo, jaton shinan meran weixon keyonaanaibo; jatianra ja baná xoxoaxbi bimiamai keskábo banékanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jatian ja mai jakonhain bero maana riki; jakonshaman shinanyaxon, itan pontéakin shinantaanan, ja joi ninkáxon jan yoiai keskábores akí koshii jenéyamai; ja banaa berobo xoxoax, jakonshamani icha bimiai keskábo, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tsonbira westíora lamparin ketéaxon, jawékinin mapoisma iki, itan jaton oxati tapo namanbi ayosma iki. Jaskáyamakinra keyáshaman peyásankanai, ja xobon jikiaibaon joé oinkanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaskáribiira westíora joné jawékibi, merayamai bokanai iti atipanyamake; jatian ja onanyamakana jawékibi, tsonbi jishtiakin ayamai kaai yamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jaskara iken kikinhakin ninkákanwe, jaweratoki moa jayá iki, jara bebonbires meniti iki. Ikaxbi jaweratoki jayáoma iki, jara jatíbi jawen jayatashokobo keyo bichinti iki”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jatian jawen tita betan jawen wetsabo, ja Jesús ikain bokana iki. Ikaxbi pataxti atipanyamakana iki joni ichaira iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jatian wetsa jonin Jesús keshana iki: —Min tita betan min wetsabora jeman charókanke, mia oinkasi beax —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jatian jato neskáakin yoia iki: —Ja Diossen joi ninkáxon jan yoiai keská akaibo riki, nokon tita itan nokon wetsabo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jatian wetsa neten, Jesús jaonmea onanaiboyabi, boten naneta iki, jain nanexon jato yoia iki: —Ian keiba bonon bokanwe —akin. Jaskatax moa shitati bokana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","jatian moa ian shitai ikanaitian, Jesús moa oxaa iki; jainoaxa ja ianman niwe koshi paketa iki; jatianra jaton boteribi moa jene weiti peokootax reokooti onsá meran ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jaskara ikenra, kaxon oxá jishténhaxon Jesús neskáakin yoikana iki: —¡Maestró!, ¡Maestró! ¡Noara moa jikiai! —akin. Jatianra weníxon, ja niweyabi bechon Jesussen notsina iki. Jatianra ja niweyabi, bechon moa nesea iki, jainoax moa jatíbi jakonshaman baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jainxon jaonmea onannaibo jato neskáa iki: —¿Eki koshia ikaxbiki mato jaskata? —akin. Jato jaskáabi moa iorai ratetax, jatobiresbo neskatibo yokakanankana iki: —¿Tsoarin nato joni; ja niweyabi bechonbo nesekanwe akin aká, jawen joi ninkáxonkanai? —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jaskatax boax, ja ian keiba iká Gadara main nokókana iki; ja iki Galilea keiba iká. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jain kaax Jesús mapetaitian oinnax, ja jemameax yoshin naikia joni jaki joá iki; ja joni iká iki, moa basibires pantionhainres jaax, chopaomabobi ikax, xobonmabi jaa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jaskáakin Jesús oinnax ja bebon chirankootaanan, neskati saí ika iki: —¡Ea teayamawe Jesús, ani Diossen Baké! ¡Enra mia yokatai, ea ramiayamawe! —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jaskáakinra yoia iki; moa já meranoax ja yoshin pikóti Jesussen yoiaitian. Kikinhakinra yoshinman ja joni iboa iká iki. Jatian jonibaon cadenaninbo menéxananbo, tanéxon koirankanabi, jan ras areskatitai, itan ja yoshinmanribi, jain joni jayamainkobo ja joni jabámakatiai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jatian Jesussen ja joni yokata iki: —¿Jawe janerin mia? —akin. Jaskáa jan yoia iki: —Nokon jane riki Legión —akin. Jaskáakinra yoia iki, já meran kikinbires icha yoshinbo weita iketian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jainxonra yoshinbaon Jesús yoikana iki, ja jakonma kini meran jato potayamanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jatian mananman icha kochi pii tsamata iken; jabo meran jato weimanon ixon ja yoshinbaon Jesús yoikana iki. Jaskáakanketianra jain weikanon ixon jato Jesussen yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jaskáakin jato yoia, ja joni meranoax jokontaanan boax, kochibo meran ja yoshinbo weita iki. Jatianra ja kochibo ishto boax, ketóainoax jeneki choronkana iki, jainoara ja kochibo jato jenen keyoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jatian jaskáketian oinnax, ja kochi koirannai jonibo rátetax, jabati ishtokana iki. Boxonra jemankobo nokóxon itan wain teetai jonibo, jaskara joibo jato keshanbokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jaskara ninkatax oinni jonibo bokana iki. Jatian boxonra Jesús ikain nokóxon, ja yoshinbo já meranoa jokona joni, ja Jesús namanbi yakata, nokokana iki; moa chopa sawéya itan moa jakon. Jaskara oinnax jonibo rakékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jatian jaskara winota oinnabaonra wetsaboribi, jato yoikana iki. Ja yoshin naikia ipachoai joni, jaskatax benxoa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jatian jaskáaketian oinnax, ja Gadara mainmea jonibaon, ikonbiresi rakékin moa jainoax kanon ixon Jesús yoikana iki. Jaskáakana Jesús boten nanetax moa kaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jaskati moa kaaitian, já merameax yoshinbo jokona jonin, jabé kakaskin Jesús yoia iki; ikaxbi Jesussen kayamawe akin ataanan; neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Min xobon katanwe, kaxon jatíbi ja mii meranxon Diossen jaskara akábo jato yoitanwe —akin. Jatianra ja joni moa kaa iki. Kaxon jatíbi ja jemamea jonibo, ja meranxon Jesussen aká jawékibo jato yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jatian jakiribi ja ian shitai joáx, jainoax kawanainko joribaketian; ja manai iikin, raroshamankin jonibaon bikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jain nokóketianra westíora joni Jairo janeya jaiba joá iki, ja iká iki jain tsinkíti xobonkonia joni koshi; joxonra Jesús namanbi chirankooxon, jawen xobon kanon ixon yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jawen jabicho ainbo bake mawatibishoko iken. Ja bake iká iki chonka rabé baritiaya. Jaskáakin yoia kaaitianra joni ichan bitaxesa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jatian ja jonibo xaranribi westíora ainbo iká iki; moa chonka rabé baritia jimi boani isinai. Jato raonmakin jatíbi jawen koríkishokobo moa keyoyona iká iki; ikaxbi moa tsonbi benxoati atipanyamaa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ja ainbaon Jesús pekao jokin nokobainxon jan perakoota chopa kebí tii akanaana iki. Jaskáakin tii akatianbi ja ainbo moa jimi boani jeneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jaskáaketian Jesussen jato yokata iki: —¿Tsonki ea tii aka? —akin. Jato jaskáa jatíxonbi nonra mia akáma iki, akin akana iki. Jaskákanaitian Pedron yoia iki: —Maestró, joni ichaira ixon bitaxkanara mia iitai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jabi Jesussen jato yoiakeresa iki: —Tsonra ea tii ake, nokon atipana koshira emeranoax pikóke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jatian jaskáshamanax jonétikoma iken, ja ainbo, Jesús namanbi saki iananbi chirankootoshita iki. Jainxonra ja joni icha tsamata napónxonbi yoia iki; jawekopi tii akárin ixon, jainoax jaskatax benxoaribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jaskáakin yoiketian ja ainbo Jesussen yoia iki: —Baké, ea ikonhaxa mia benxoke, moa jakonax katanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jatian Jesús yoyo ikipari iitainbira, jain tsinkíti xobon iká joni koshi Jairon xobomeax, westíora joni joá iki, joxon neskáakin yoia iki: —Min bakera moa mawáke, ja Maestro moa teayamawe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jatian jaskáaketian ninkáxon Jesussen Jairo neskáakin yoia iki: —Rakéyamawe eareskaya ikonhawe, jatianra min bake benxoti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jainoax Jairon xobon kaa iki, jain nokóxon, tsoabi ja xobon jikimayamaa iki. Jaskáxon ja Pedro, Santiago, Juan jainoax ja mawata baken papa betan jawen titares jikimaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jatian jatíbi jain ikábo, winiananbibo yoyo iki ikanaitian, jato nokoa iki. Jaskákanaitian Jesussen jato yoia iki: —Winiamakanwe, nato xontakora mawatama iki; oxaaresiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jaskáakin jato yoiabi jaki shirokin osanreskana iki, ja xontako moa mawata iken onanax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jaskákanaitian kawanxon, Jesussen ja mawá metsonxon, koshinshaman neskáakin yoia iki: —¡Weniwe xontakó! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jatianbi ja xontako jiriax wenita iki; jainoara jawékiamakanon ixon jato Jesussen yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jaskáketian oinnax jawen anibo ratékana iki; jatian Jesussen jato yoia iki, jaskara jawékibo tsoabi jato keshantima. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jainxonra Jesussen jawen chonka rabé jaonmea onannaibo tsinkia iki; jaskáaxonra jawen atipana koshi, itan yoiti koshi jato menipakea iki, meskó yoshinbo pikokanon ixon, itan isinaiboribi benxoakanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jaskáaxon jato raana iki, ja Diossen ikinaton jati joibo jato yoiti, itan isinaiboribi benxoakanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jato yoia iki: —Kakin jawebi bokantima, nin kekóti, nin bolsa, nin jawékiati jawékibi; nin koríkibi, nin wetsa ja saweti chopabi bokantima. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jawerato xobonki mato nokotai, jainbi mato iti iki, wetsanko kaai mato taxketai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ikaxbi jawerato jemanxonboki mato bikashamakanai; ja jemameax moa mato kati iki. Kaaira ja maton jamata mai potobo, mato tawasaakainti iki. Ikonhayamakin mato biamax, moa onsá meran ikanai jabaon onankanon ikax —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jaskáakin jato yoia, jatíbi maxko jemabotiibi bokana iki, jakon joi jato yoiboi, itan isinaiboribi jato benxoaboi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jatian ja apo Herodesnin jatíbi jain winotai jawéki yoii ikanaibo ninkata iki; jaskarabo ninkáxon meskóakinbo shinanna iki. Ja mawáyantana Juanra moa jiriribike ikibo ikanaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jatíribibaon yoia iki; ja *profeta Elías jatoki pikota; jatian wetsabaonbiribi yoia iki, ja moatian *profeta ipaonibo westíora jiria. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jaskákanaitian Herodesnin jato yoia iki: —Enbishamanra ja Juan jato textemayantanke ¿Jatian ja yoii yoyo iorakanai, en ninkatai joniki tsoa iki? —akin. Jaskara kopíra Herodesnin Jesús oinkashoraa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jainoax ja raanabo moa beribakana iki. Bexonra jaskara jawékibo abeirankanabo Jesús yoikana iki. Jatian janra jatobiribi tsínkianan, ja Betsaida jemanko jato boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ikaxbi moa jain bokana onanxon jonibaon chibana iki. Jatianra jakonhaxonres jato Jesussen bia iki. Jainxonra ja Diossen ikinaton jati joibo yoiananbi, ja isinaiboribi jato benxoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jatian moa yantan iketian, jawen chonka rabé jaonmea onanaibaon, neskáakin Jesús yoikana iki: —Nato jonibo moa tantikanon ixon jato raanwe, neno noa ikainra jawebi yamake; abátankanon ja ochóma iká jemashokobaon, itan wainkoboribi ja jawékiakanti benakin —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jatian Jesussen jato yoia iki: —Matonbikaya jato pimakanwe —akin. Jatian jabaon neskaa iki: —Noara pichika pan betan rabé yapashokoyares iki. Jaskara ikenra noabi kati jake, jato jawékiati maroxoni —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ja jain tsinkita iká iki, pichika waranka jonibira; jaskara ikenbi Jesussen jaonmea onannaibo jato yoia iki: —Westíora tsamábotiibi pichika chonka jonibo jato yakámakanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jatian jaskáakin jato yoiara jatikaxbi yakákana iki; ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jatian Jesussen ja pichika pan betan ja rabé yapa bitaanan, naiori oinxon, ja jawékiati kopí Dios iráke aka iki. Jaskáakin senenhaxon, tobapakeanan jaonmea onannaibo jato menia iki; jabaonbiribi ja tsamatabo jato menikanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jaskáakin menikana piax, jonibo jatikaxbi potókana iki. Jatian jato menia texe tsinkikana, chonka rabé tasá bocho baneta iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wetsa neten jabichobiribi orani Jesús iká iki; jatian ja jaonmea onanaiboribi já betan jain ikana iki. Jainoa jato neskáakin yokata iki: —¿Tsoarin ea ixonki jonibaon ea yoiai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jato jaskáa yoikana iki: —Jatíribibaonra shinankanai, mia jato *bautizanai Juan, wetsabaonra shinankanai mia Elías, jainxon jatíribibaon shinankanai mia moatian ipaoni *profeta jiria —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jaskáakanabi Jesussen jato yokáribia iki: —¿Jatian matonbiribiki ea tsoa shinannai? —akin. Jato jaskáaketian Pedron yoia iki: —Mia riki ja *Cristo —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jatian Jesussen jato yoia iki, jaskara joibo tsoabi jawekeskaxonbi jato keshanyamakanon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jainxon jato neskáakin yoiribia iki: —Ja jonin Bakera ikonbiresi onitsapiti jake; jainoax ja judíobaon koshibo, ja *sacerdotebaon koshibo, itan ja esé onan joniboribi jaon keenyamakanti iki. Jaskáaxonra retekanti iki, ikaxbira jawen kimisha nete itin jirinoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jainxon jatíbibo jato neskáakin yoiribia iki: —Jaweratoboki eonmea onanai ikasai, jabora jawen keena keskatibores iki moa jenéxon, netetiibi jawen koros papiti iki, jainxon ea chibanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jaweratoboki mawákashamai, jabora manotiain bokanti iki. Ikaxbi jaweratoboki ea kopi mawatai jabora kishpinkanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Jawe jakonmein iti iki, teetax joni nato netemeax jatíbi jawékinin senenax, iitibi mawatax manotiain kaa? ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jaweratoki eon itan nokon joiki rabinai; jatianra ja jonin Bakeribi jawen pené neteyabi, itan jawen papan koshi shinanyanixibi jawen ángelboyabi joáx jaon rabinnoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Enra mato ikonshaman yoiai, jatíribi neno ikábora, ja Diossen ikinaton jati oinnamatianbipari mawákantima iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jatian jato jaskáakin yoiibata, moa posaka nete pekáora mananmanxon orani Jesús kaa iki. Ja Pedro, Juan jainoax Santiagoribi já betan bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jatian moa orani iitaitianribi, Jesussen bemanan moa wetsaresibia iki. Jainoax jawen choparibi moa joxoshaman itan kikinbires penéshaman iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jatianra rabé joni joáx Jesús betan yoyo ikai oinkana iki. Ja iká iki Moisés betan Elías. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jatian jaton yora iká iki jakonhira penéshamantonin kateaketana. Jabaonra ja Jesús Jerusalénhainxon retekin jaskáakin onitsapimakantibo yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jatian Pedrobiribi jabé ikábo betanbi kikinbiresi oxakaskinbi teneabo ikana iki. Jaskáakinbira Jesussen yora itan já betan iká rabé jonin yora penebires oinkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jatian ja jonibo moa Jesússibakeax bokanaitian Pedron yoia iki: —Maestró, ¡Jakonhira riki noa neno itina! Jaskara iken kimisha peotashoko non abanon: wetsa mina, wetsa Moiséssena, wetsa Elíasna —akin. Jaskarabo yoikinbi Pedron onanyamaresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jaskati yoyo iitainbi, nai koin bexon jato mapotoshia iki. Jatian jaskara nai koin meran jato oinnax rakékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jainxonra ja nai koin meranoax neskati yoyo ikai ninkákana iki: “Nato riki nokon bake, ja en katota, já ninkáxonkanwe”, iki ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jaskati yoyo ikai ninkákanaitianribi Jesús moa jabicho iká iki; ikaxbi jabaon nato jawékibo jonekana iki. Jatian ja netebaonra jaskara oinkanabo tsoabi jawebi jato keshanyamakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jatian nete xabáketian mananmameax moa naman beribakana iki. Jatianra icha joni, ja Jesús bechii bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jaskákenbi ja joni icha napónxon; westíora jonin koshinshaman Jesús neskáakin yoia iki: —Maestró, nokon bakepari ea oinxonwe, jara nokon jabicho bake iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yoshin já meran jikixonra, sion imai jaskáakinra pakeai, jainoaxa bakox kespotai; jaskáakinra ramiayonxon jenekashamai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Enra ja mionmea onannaibo yoiibake, ja yoshin pikoxonkanon ixon; ikaxbira atipanyamaibakanke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jatian Jesussen neskáakin yoia iki: —¡Eki koshiamabo itan yoitima jonibo riki mato! ¿Jawetian kamanki mato betan ixon mato neskataitian en teneti iki? Ja min bake ea neri bexonwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jatian ja bake moa Jesúski nokoti joaitian, yoshinman mai tsakamaxon jakiribi maxkámaa iki. Ikaxbi Jesussen ja yoshin notsina iki, jainxonra moa benxoaxon, ja bake jawen papa menia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jatianra jatikaxbi ratékana iki, ja Diossen ani jawéki aká oinnax. Jatian jatíbi neskarabo Jesussen akai oinnax ratékanaitian, jaonmea onannaibo jato yoia iki neskáakin: ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Rama neskara en mato yoiaibo ninkatax shinanbenoyamakanwe, ja jonin Bakera, ochaya jonibo menikanti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ikaxbi jabaonra onanyamareskana iki; jan jato yoiaibo; Diossenbi jato onanmayamaitian, jainoax kikiniribi rakékana iki onantiakin jato yoinon ixon Jesús yokátininbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jatianra Jesussenmea onannaibo jatobiresbo yokakanankana iki, tsoa jato xaranmeakayaki jato xewina iti iki ikaxbo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jatian jaskákanaitian jaton shinan onanxon, Jesussen westíora bake bia iki; bixon já patax nichina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jainxon jato neskáakin yoia iki: —Jaweratobaonki, nokon janenko neskara bake biai, jabaonra eabi biai. Jatian ja ea biaibaonribira, jan ea raanaribi biai. Jaskara iken ja kikinmanshokotonin shinanmeetai riki, jan mato jatíbi xewina —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jatian Juanman Jesús yoia iki neskáakin: —Maestró, westíora jonira non oinhibake min janenko yoshinbo jokonhaitian. Jaskáaitianra non atima yoiibake, noobetan niai ixonmabi akaitian oinxon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jatian Jesussen jato neskaa iki: —Atima jato yoiamakanwe; jaweratoboki noki ramíyamaibo iki, jabora noa akini nobé rabetaibo iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jatian moa naikan kati ochóma iketian, koshi shinanbaini Jerusalénhain kaai pontékainti Jesussen shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jaskáaxon, jato yoii bokanti jonibopari rekenmaa iki; boax Samariain iká westíora maxko jemanko nokókana iki, nokóxon jain ikanti xobo benakana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ikaxbi ja Samaria jonibaon jatoiba jato imakashamakana iki; Jerusalénhain boí winotaibo onanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jaskákanaitian oinxon, Santiago betan Juanman Jesús yoia iki: —Ibó ¿Miaki keenti iki, nato jonibo keyonon ixon, naikanmeax chii pakénon ixon non yoiti? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ikaxbi Jesussen bechiakekainxon jato notsina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jaskatax moa wetsa jemashoko ikain bokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jatian jabo bain bokanaitian, westíora jonin Jesús neskaa iki: —Ibó jawerano inonbi mia kaaitianra, en mia chibanti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jaskáketian Jesussen yoia iki: —Nii ochitibora jain jati kinia iki, jainoax ja noyai yoinabora, jain jati jaton naayabo ikanai; ikaxbi ja jonin Bakera, jain tantitiomabobi iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jainxon wetsa joni Jesussen yoiribia iki: —Ebé kawé —akin. Jatian ja jonin neskaa iki: —Ibó, nokon papa mawáketianra en miinpariti jake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jatian Jesussen yoia iki: —Kayamawe, abákanon ja mawábaonribi jabé mawa miinkin; minbiribi ja Diossen ikinaton ikanti joi jato yoii kawé —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jatian wetsan yoia iki: —Ibó enra mia chibankasai, ikaxbi eapari manawe; ja nokon xobon ikábopari en jato kaai abátanon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jaskáakenbi Jesussen neskáa iki: —Jaweratonki mai karanbeananbi pekáori naisai, janra jakonmaakin mai karanbeai. Jaskaribiira westíora joni ja Diossen ikinaton jatínko iti atipanyamake —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jaskara pekáora, wetsa neten jawen kanchis chonka rabé joni, Jesussen jato bia iki. Jaskáakin jato bixon rabé rabébo, jatopari raana iki jaribi jain kati shinanna jemabaon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jainxon jato neskáakin yoia iki: “Ikonshamanra en mato yoiai, ja bimi tsekatibo riki icha, ikaxbi ja tsekai teetaibora ichamashoko ikanai, jaskara kopí ja wai Ibo yokákanwe, abanon ja bimi tsekai teetiboribi jato raankin ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jaskara iken moa botankanwe; oinkanwe enra mato raanai, ja pimis yoinabo xaran *corderobo raanai keskáakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kakin, pisha boyamakanwe, itan koríki jan botibi, nin zapatobi maton botima iki. Jainxon kakin joni bain nokoxon, ja saludanibo mato banetima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jatian kaax nokóxon, jaton xobon jikixon jato saludankin maton jato neskáati iki: ‘Nato xobon ikábo mato jakonbires ibanon’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jatian ja xobon jakon shinannai jonibo jakenra, ja maton yoia jakon shinanribi ja xobon ikábaon biti iki. Ikaxbi ja xobon jaskara shinanya joni yamaketianra, ja maton yoia jakon shinanbo matoki joríbati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jaskara ikenra jaton xobonbi mato baneti iki; mato jawékiamakanabo maton aresti iki. Ja teetaibora jaton tee akaibo kopí kopíakanti jake; xobobotiibi mato kawantantima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jawerato jemanki mato nokotai, ja jemanxon bixon mato jawékiamakana maton aresti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ja jain mato nokota jemankobo isinaibo nokoxon, maton benxoati iki. Jainxonra neskáakin maton jato yoiti iki: ‘Ja Diossen ikinaton iti netera moa ochóma iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ikaxbi jawerato jemanxonki mato biamakanai, jatianra ja jema callenkobo pikóxon maton jato neskáati iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Ja maton jemamea mai poto non jamata, noon neetabobira noa tawasaatai, maton noa bikashamaa onanti inon ikax! Ikaxbi neskara onankanwe; ja Diossen ikinaton jatira moa matoiba nokotibi iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Enra mato yoiai, castigameti nete nokoketianra ja jemanxon mato biamaa jonibo, ja Sodomainoa jonibo ikáni bebonbires inoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Jawe iresaipanon, ja Corazín jemamea jonibo betan ja Betsaida jemamea jonibo! Ja matoibaxon en aká keskáribiakin, ja Tiro jema betan Sidón jemanxon, ratétibo en aká iketianra, moabires jainoa jonibaon jaton jakonma shinanbo akonkin jenetaanan Dios ikonhaax, ja masá shinankin sawekanai xaxa chopa saweax, chiimapobaon mapokookeankana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ikaxbi jaton akábobiribi yoixon jato castiganti nete nokoketianra, ja Tiro jema betan Sidón jemamea jonibo akai bebonbires en mato castiganoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jatian mato Capernaúm jonibaonra, noara naikan kanoxiki ixonbira maton shinannai, matora kayamanoxiki, ¡Kikinbires yamé kini meranra mato potakaanoxiki! ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jaweranoxonki maton yoia joibo mato ninkáxonkanai, jabaonra earibi ninkáxonkanai. Jaweratobaonki keenyamakin mato omisai, jabaonra keenyamakin earibi omiskanai. Jatian ja eon keenyamaibora, jan ea raanatonribi keenyamakanai”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jatian ja kanchis chonka rabé jonibo raroshaman beribakana iki, bexon yoikana iki neskáakin: —¡Ibó, min janenko non jato notsinara, yoshinboribi non yoiai joibo ninkáxoni jokonkanke! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jaskáakanketian jato Jesussen yoia iki: —Ikon riki, enra oinna iki naikanmeax joí *Satanás kaná ikai keskati paketaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Enra nokon atipana koshi mato menipakea iki; ja ronobo itan ninbobo maton jamakenbi mato jaweayamanon ixon; jainxon jawekeska jakonmabi winóyamakin, ja maton rawikan koshi shinanboribi matonharesnon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ja maton yoiaibo ninkatax yoshinbo jokonaitonbicho raroyamakanwe, ja maton jane moa naikan wishakaata kopíribikaya rarokanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jatianbi Jesús ikonbiresi raroa iki, ja Diossen Shinanman imaa, jainoax neskata iki: “Enra mia rabiai Papá, mia riki mai betan nai Ibo. Ja onan itan ninkatai jonibo onanmayamataananra; ja onanma jonishokobo, ja min joné jawékibo min jato onanmaa iki. Ikon riki Papá, jaskara ati keenxonra min jaskáa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jatíbi jawékibora nokon Papan ea menia iki; tsonbira tsoarin ea ixon onanyamake, ja nokon Papanresa ea onanke. Jatian tsonbiribi nokon Papa onanyamake ea jawen Bakenbichores. Jainxon ea jawen Bake ixon, en jato onanmaabaonresibira akanai onankin”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jatian jaonmea onannaibo jatobichobiribi neskáakin yoia iki: “Diossenra raroshaman imai, ja maton oinni iitai jawékiboribi oinna jonibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Enra mato yoiai icha *profeta ipaonibo itan apobora, rama maton oinnaibo oinkasi ikana iki; ixonbira jabaon oinyamakana iki. Ja maton ninkataiboribi ninkátinin manatabora ikana iki, ixonbira ninkáyamakana iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Westíora esé onan jonira Jesús betan yoyo iki kaa iki; kaxonra jakonmaanoxonres tanakin neskáa iki: —Maestró ¿Jatíbitian jati neteya inoxonmein en jawe ati iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jaskáa Jesussen yoia iki: —¿Ja esé kirika meranki jawekeska yoikin wishaa iki? ¿Jaweki min yoyo akai? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jatian ja esé onan jonin yoia iki: —‘Ja min Ibo Dios noiwe; jatíbi min jointiaxonbi, jatíbi min kayayaxonbi, jatíbi min koshiaxonbi, jatíbi min shinanyaxonbi’. Jainxon ja ‘minbixbi noikaata keskáakinribi wetsabo jato noiwe’, ikira ikai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jatian Jesussen yoia iki: —Ikon jaskarakonra min yoike. Ikoni jaskati jaaxa mia jati neteya iti iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jatian ja esé onan jonin, jan yokatabo jakon imakaskin shinantaanan Jesús yokáribia iki: —¿Jatian tsoarin ja en jaskáati joni? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jatian Jesussen neskáa iki: —Westíora jonira Jerusalénhainoax Jericóain kaa iki. Jain kaaitian yometsobaon yatanxon, jatíbi bichinyonkana iki. Ja sawea chopabobi jopémayonxon rishkionxon mawátanishaman potabainkana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jatian ja senenressibi, westíora *sacerdote ja bainribi kaa iki; kakin ointaanan wetsaorishoko ratanbaina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jainoax westíora *Levitaribi ja bain joá iki; ja jokin meraxonbi, janribi ratanbainresa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ikaxbi ja bainribi, westíora Samariainoa joni kaa iki. Kakinbi meraxon ja joni noibaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jatianra nokobainxon, ja xateyonkanabo, xeni betan vinon raonhanan, chopanbo neayona iki. Jainxon jawen burronbi perakanxon boá iki; boxon westíora xobonxon koirana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nete xabáketian, ja Samaria jonin rabé koríki ja xobo ibo menia iki. Ja menikin yoia iki neskáakin: ‘Nato joni ea koiranxonwe, jatian bebonchaabires min jaki koríki keyoketianra, jakiribi joxon en mia kopíai joái’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jatian min jisáki ja kimisha joninkonia ¿Jawerato iká iki ja jakonma jonibaon yometsoayonkana iketian jabé joniakin shinannai? —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jatian ja esé onan jonin yoia iki: —Ja noibaxon jan akinna jonira iká iki —akin. Jatian Jesussen yoia iki: —Rama miinribi kaxon jaskáashokotanwe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jaskatax bain kaax Jesús westíora jemankoshoko nokota iki. Jainoa westíora ainbo Marta janeyaton jawen xobon boá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja Marta iká iki westíora wetsaya, jawen jane María. Jara Jesussen joi yoiai ninkati ja namanbi yakata iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ikaxbi ja Martabiribi meskó teebores akí iká iki. Jainxonra Jesús pataxbainxon neskáakin yoia iki: —Ibó, ¿Ja nokon wetsan eabicho tee amaiki min oinyamaa? Ea yoixonwe ea akini jonon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jatian Jesussen yoia iki: —Marta, Marta, icha jawéki akin shinanira min shinan tsokasai, ");
INSERT INTO shpNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ikaxbi westíora jawékiresiki kikin bebonbires jakon; jatian Maríanra ja jawéki katoke. Jaskara ikenra tsonbi ja jenemati atipanyamake —akin aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jatian wetsa neten, wetsanko kaxon orani Jesús iita iki. Moa senenhaketian westíora jaonmea onanaiton yoia iki: —Ibó, Juanman jaonmea onannaibo jato oranti onanmaa keskáribiakin noa oranti onanmashokowe —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jatian Jesussen jato yoia iki: —Matonra neskáakin oranti jake: ‘Non Papa naikan iká, jatíxonbi mia ikon Dios onanbakanon; non apo iki jowé. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ja netetiibi noa maxkata jawékiatibo noa meniwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Non ocha akábo soaxon noa shinanxonyamawe, ja noki ochaabo moa non jato shinanxonyamai keskáribiakin. Shinan meran akásti jawékiainbo noa pakémayamawe’, akin anonxikanwe —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jainxon jato neskáakin yoiribia iki: —Iti iki mia já betan raenanai jonin xobonko mia yamé pochínikon kaai. Kaxon min ati iki: ‘Kimisha panshoko ea meniwe, en mia banexonribanon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Westíora ebé raenanai jonira, ochokeax joáx nokon xobon nokóke, ja nokókenbira en ja jawékiamati yamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jaskáakin akára, chichóxonbi jan neskáakin mia yoiti iki: ‘Ea tearesshayamawe, nokon xobora xepó iki. Eara nokon bakeboyabi moa oxaa iki. Jakopira mia jawebi menii ea weiti atipanyamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Enra mato yoiai, jaskáakin min yokákin jeneyamaibi mia menitima ixonbira, ja miibetan raenanai ixonres, ja min yokata jawékibo mia meniti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaskara ikenra en mato yoiai: Yokákanwe jatianra mato Diossen meniti iki; benakanwe jatianra maton nokoti iki, kenakanwe jatianra mato akinti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jaweratonki yokatai janra biai, jaweratonki benai janra nokoai, jaweratonki kenai jara akinnai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Matonmein ati iki, papa iketian, maton baken mato yapa yokata, westíora rono menikin? ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iamaxon bachi yokáketian, westíora ninbo menikin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Matokaya jakonma shinanyabo ixonbira maton onanke, jakon jawékibores maton bakebo meniti. ¡Jaskarabo bebonbireskayara ja naikan iká non papan jakon shinanya ixon, ja Diossen Shinan yokataibo jato meniti iki! —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jatian Jesús iká iki, jan joni yoyo imayamai yoshin pikoi; jatian ja yoshin moa joni meranoax pikóketian, ja joni moa yoyo iki peokoota iki. Jaskara oinnax jonibo ratékana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jatian jatíribibobiribi ikana iki, neskati: “Ja Belzebúkan, atipana koshi meniatonra nato jonin yoshinbo pikoai”, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jatian jatíribibaonbiribi, jakonmaakaskinres ja oinxon onanti, itan ratéti jawékibo anon ixon yoikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ikaxbi jaskáakin shinankanai onantaanan, jan jato yoia iki: “Westíora mainmea jonibobires ikaxbi reteananaxa, moa jainbicho iti atipanyamakanke. Jatian westíora xobonkoniax ja rarebobires ikaxbi, ramiananaxa moa jainbicho iti atipanyamakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jatian *Satanás janbixbi jakonmaataanan jabichobiribi ikaxki ¿Jawekeskatax jatíbi jawen atipana koshiabi baneti iki? Neskáakinra en mato yoiai; enki akai ja Beelzebúkan koshin yoshinbo pikokin ixonbo maton yoiaitian. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jatian jaskara ikenki ¿Tson atipana koshi meniaton akanai, ja matomea onanaibaon yoshinbo pikokin? Jabaonbira mato yoiti iki, ja maton ea jaskáakin yoiara jakonma iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jatian ja Diossen atipana koshin, en yoshinbo pikoaitonra noa onanmai, ja Diossen ikinaton jati netera moa nokóke ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jawetianki westíora koshi jonin, jan retemisti tsomáyaxon jawen xobo koirannai, jatianra ja benxoa jawékibo tson yometsoayamai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ikaxbi ja xewina koshi wetsa joni joxónresparira, jaki chipota jan retemisti jawékibo bichinxon, jatíbi jawen jawékibo moa iboananai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jaweratobaon oinnaki ja en akai jawékibo jakonma iki; jabo riki ja eki jakonmaataibo, jaweratobaonki, Dios ikonhakanon ixon ea akinhamai, jabaonra ea ikonhakanti ikenbi jonibo jato janbísaresai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jatian westíora yoshin, joni meranoax pikotax kaaxa, jawebi yamankobo kawantanai, jain iti benai. Jatian moa nokoyamaxon shinannai: ‘Ramara jain ea ipachoai nokon xobonko ea karibai’, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jatian joxon oinna ikai, jonin shinan jakonyoraakin matsóxon kikinshamanhakin benxoayona keská. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jatian jaskara oinbaini kaxonra, kanchis yoshin bebonbires jakonmabo jato iweai. Jaskati beaxa jatikaxbi ja joni meran weíkanai. Jatianra ja joni, ja moatian ikátiai bebon jakonmabires banetai”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jaskarabo jato yoii Jesús iitaitian, joni icha napomeax, westíora ainbo saí ika iki, neskati: —¡Diossen raroshaman imabanon, ja tooxon bakeataanan mia ania ainbo! —iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jaskáakenbi Jesussen yoia iki: —¡Ja Diossen joi ninkátaanan, jan yoiai keskati jakanabokaya, Diossen raroshaman imabanon! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jatian icha jonibo, Jesús ikainko tsinkíakereskana iki. Jaskákanaitian jato neskáakin yoia iki: “Ja ramatian jaa jonibo riki jakonma shinanyabo. Jabaonra ja oinxon onanti jawékibo en anon ixon ea yoikanai. Ikaxbira jaskarabo ayamakinbi ja Jonás iní keska jawékiribi en ati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ja Jonás iká iki, jato Diossen joi yoii kaa, Nínive jonibaon onankanti. Jaskáribiira ja jonin Bake, ja ramatian jaa jonibaon ja oinxon onankanti iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ja ramatian jaa jonibo jaton akábo jato yoixonti nete senenketianra; ja surhorikea apo ainboribi jain inóxiki, janra jato castiganon ixon Dios yoinoxiki. Jara kikinbires ochó mai senenainoax jonike. Ja Salomónman jawen onan shinanyaxon yoiai joibo ninkati. Jatian rama mato betan itinara ja Salomón xewina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja nete senenketianribira, ja Jonassen yoia joi ninkáxon ikonhataanan, jaton jakonma shinanbo akonkin jeneni, Níniveainoa joniboribi, jain inóxiki. Jain ixonra jabaonribi, ja ramatian jaa jonibo jato Diossen castiganon ixon yoinoxikanai. Jatian ja rama itinara Jonás xewina iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tsonbira lamparin keteaxon jawéki pekáo joneyamai, itan jawékinin mapoyamakanai. Jaskáyamakinra bochikishamanres peyasankanai, jawen joekan tenaketian, ja xobon jikiaibaon oinna jishtishaman inon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maton bero riki, jan maton yora tenaa lamparin keska, jatian min bero jakon ikenra, jatíbi min yoraribi joébires iti iki. Ikaxbi ja min bero jakonma ikenra, jatíbi min yoraribi yamé meran keská iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jaskara iken rama koiranmeetax shinanmeekanwe; ja mato meran joé ikara yamé inake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jawetianki maton yora meran joé keska ikax, jawe yamébi yamaa keská ikai, jatianra min onantishamanhakin ointiki, westíora lamparin joekan tenaketian min oinnai keskáakin”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jatian moa jato joi yoikin senenhaketianribi, westíora *fariseo, jawen xobon pii kanon ixon, Jesús kenai joá iki. Jaskáakin kenaa kaax jawen xobon jikiax pii Jesús yakata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jaskaketian ja *fariseo ráteta iki, ja jawékiamatianbi mechokiiti esé meran yoiai senenhayamaitian oinnax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ikaxbi Jesussen yoia iki, neskáakin: —Mato fariseobo riki vaso betan plato pekáobicho chokaibores. Ikaxbi maton shinan meran riki mato jakonmabiresbo, ja jakonma jawéki akin akonbireskin jato yometsoaibo ikax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Onanma jonibo riki mato! Diossenra nekeabi itan ja chichokea jawékibi aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jakon shinanyaxonkaya ja mato jayata jawékibaon ja jawebiomashokobo jato akinkanwe; jatianra nekebi itan shinan meranribi mato jakon ikanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Jawe iresaipanon, mato fariseobo! Maton akai ja chonkankoniabo westíora Dios menikin. Jaskáakin maton jato meniai riki; menta, ruda jainxon meskó pei piti itan meskó bero pitiboribi. Jaskarabo akinbira ja atibi keskáakin jato akinti, itan ja noiti shinanyaxon maton jato noiamake. Jaskati jakonibo iananbikaya ja maton akai jawékibo akin jeneyamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Jawe iresaipanon, mato fariseobo! Mato riki, jain tsinkíti xobo meran weitaxbo, rekenainshamanbores yakátinin keenaibo; jainoax callen meraxonbo, rabikin jakonshamanhakinbo saludankantininbores keenaibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Jawe iresaipanon, mato fariseobo riki, ja mawá miinkana matóbo onantima iken, jonibo jaon penitai keskábo! —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jatian westíora esé onan jonin neskáakin yoia iki: —Maestró, jaskáakinbo yoixonra min noabobi jakonma shinanmai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jaskáaketian Jesussen yoia iki: —¡Jawe iresaipanon, mato esé onan jonibo! Mato riki, matonribi atipanyamaxonbi, tsonbi tenetima iwe jawéki wetsabores jatobicho papimai keskábo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Jawe iresaipanon! Matonra akai ja maton rekenbaon retekani *profetabo jisáakinboribi monumentoakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaskarabo akinra maton jato onanmai, ja maton reken papashokobaon aní jawékiboribi, jakonra akana iki ixon maton shinannai. Jabaonra akana iki ja *profetabo retekin, jatian matonra jabo iní jisáakinbo *monumentoakanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jaskara kopíra jawen onan shinanyanix ínike Dios neskati: ‘Nokon *Profetabo itan en raanaboribira janoxiki; jabora jatíribibo retexon jatíribibo jato masábo tenemanoxikanai’, iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jaskáakinra ja nete jonianontianbi retekani jatíbi *profetabo, ja ramatian jaa jonibo jato Diossen iboamanoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ja Abel retekaniainoax ja Zacarías retekani kamanra, mato ramatian jaa jonibo Diossen iboamanoxiki. Zacaríasra retekana iki, ja Diossen xobo meran iká jainxon Dios yoina menoxonti ikainxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Jawe iresaipanon, mato esé onan jonibo! Mato riki, onan shinanya ikax jan iboabo; ixonbira jaskarabo onanxonbi maton jawe ayamai. Jaskáakinra jaskara onan shinanyaboribi ikantiakin maton jato imakashamai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jatian Jesús moa jainoax pikókaina pekaora, ja esé onan joniboyabi fariseobo ikonbiresi Jesúski sinákana iki. Jatianra meskóakinbo yokákin peokana iki, ");
INSERT INTO shpNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jaskáaxon ramiati benakin, jakonmaakin yoyo imaxon jawen yoyo ikatoninbi jakonmaati shinanxon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jatian jain iitaitian, kikinbires icha joni jatoki tsinkíkana iki. Jaskatira jatonbinix bitaxananbotankana iki. Jainxon jaonmea onanaibopari jato Jesussen neskáa iki: “Koirameekanwe, ja ikon keskashamanhakin jato joi yoiai *fariseobaonra mato parankanake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jatíbi joné jawékibobira onantibires inóxiki; ja tson onanyamaa ikatiaibobira jatíxonbi onannoxikanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaskara ikenra jatíbi ja joneshoko, itan tson onanyamaabobi jatíbiain ninkakaaketanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Rama en mato yoibanon ebé raenanaibó; ja yora reteai joniboki rakéyamakanwe, mato jaskáa pekáora moa jawebi ati atipanyamakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ikaxbi en mato yoibanon tsokikayaki mato rakéti iki ixon: Mato jaki rakéti riki Dioski; ja mato mawámataanan, maton kaya chiikan ewa meran mato potananti iketian. Ikon jakikaya rakékanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ichama koríkininra akanai pichika isáshoko marokin bikin. Jaskara ikenbira Dios jabaon shinanbenoti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maton boo riki westíora westíorabo moa jan topona. Jaskara iken rakéyamakanwe: Matora ja icha isáshokobo xewinbainbires Diossen shinannai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jainxonra en mato yoiribiai, jaweratoboki jonibo bebonmeax, eonparanan ikai, jatianra ja jonin Bakeribi ja Diossen ángelbo bebomeax jaonparana iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ikaxbi ea onanaxbi ja ea onanyamaa keskati ikaikira, earibi ja Diossen ángelbo bebomeax ja onanyamaa keskati iti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Diossenra ja jonin Bakeki jakonmaati yoyo ikaibo, jaton ochabo moa jato shinanxontima iki. Ikaxbi ja Diossen Shinanki jakonmaati yoyo ikax ochaabora, jaton ochabo jawetianbi shinanxonkin jenetima iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mato jain tsinkíti xobo meran bokana, iamaxon mato joi benxoaiboiba bokana, itan joni koshiboiba mato bokanabo; jawekeskatimein mato kopibi mato yoyo iti iki, iamaxon jawemein en jato yoiti iki ixonbo masá shinanyamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ja jato bebon mato nikenra, jaskara maton jato yoiti joibo, ja Diossen Shinanmanbi mato shinan meniti iki; jaskáakinbo maton jato yoinon ixon”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jatian ja icha joni ikainxon westíora jonin Jesús yoia iki: —Maestró, nokon wetsa ea yoixonwe, ja non papan noa potaxona, en bitibo iníbiribi ea meninon —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jaskáaketian Jesussen yoia iki: —Joní, tsonbira jaskarabo mato benxoaxonai koshi iti ea imaama iki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jainxon jato yoiribia iki: —Koirameekanwe; bebonbires jawékinin kenkaresti shinanyabora mato inake. Ja icha jawékima riki noa jan jakon jamai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jainxonra icha jawékia iní joniki iká esé yoikin jato neskáa iki: “Westíora jonira inike icha jawékia, ja jonin jawen wain banaara anike jawen banábaon icha bimixonkin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jatian ja icha jawékia jonin shinanna iki neskáakin: ‘¿Ramamein en jawekeskaati iki? Ja bimibo tsekaanan en jain benxoatira yamake’, ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jainoax neskata iki: ‘Enra moa onanke enki jaweatiki ixon. Ramara ja en jain berobo benxoai xoboshokobo ras apakexon, anishamanbo en wetsa apakeai; jaskáaxonra ja en tsekai bimibo, itan jatíbi ea jayata jawékibo en jain benxoati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jaskáayontaananra nokon shinan meran en neskara shinanti iki: Eara icha jawékia iki, icha baritiaribi jawékiati senen. Jaskara ikenra rama raroanan ja piananbi xeaanan ea tantiai’, iki ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ikaxbira Diossen ja joni neskáakin yoia iki: ‘Mia riki onanma joni, nato yamébira mia mawatai, ¿Jatian ja min benxoa jawékiboki rama tsona banetai?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaskarara winotai ja icha meskó jawékibo tsinkiboresi jakana jonibo. Jaskara jonibo riki Diossen oinna jawemabi”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jainxon Jesussen jawen jonibo neskáakin yoiribia iki: “En mato yoibanon ninkákanwe, jawékiati jawékinin yoronkin jayoraakin shinanni onisshamakanwe; itan ja saweti chopabaon yoronkin masá shinanni onisshamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Non jatikaya riki, non ja jawékiati xewina jakon. Jatian ja non yora riki, ja non saweai chopa bebon jakon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oinkanwe, ja isábo: Jabaonra banati atipanyamakanke, itan jatonbiribi banaananbo bimibo tsekati atipanyamakanke. Jainoax jain jaton jawékiatibo benxoatiomaboribi ikanai. Jaskarabo ikanainbira, ja jawékiakantibo jato Diossen maxkámayamai. ¡Matobokayara ja noyai yoinabo bebonbires iki! ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tsonbira, westíora oratanibires jawen jati bebonhati atipanyamake kikini keenyorakinbi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jatian neskara maxko jawékibo atipanyamaxonbiki ¿Jaweatin ja wetsa jawékibo akáskin maton ayorakin shinannai? ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Oinkanwe ja wain xoxoa joabo: Jabora teeti atipanyamakanke, itan jatonbiribi chopaaxonbo saweti atipanyamakanke. Jaskara ikenbira ja apo Salomón, jakonhira chopabo saweibi, ja joabo ikai bebonbires metsati raokaati atipanyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jatian jabokaya moa choshiketian menokanti ikenbira akai Diossen, ja waimea joabo kikin metsáshaman imakin. ¡Matobokayara ja maton saweti chopabo mato maxkámatima iki, mato kikini eki koshikanamabo ikenbi! ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jaskara kopí ja piti, itan ja xeatibicho benai, shinan tsokasyamakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Non Papa Diossenra mato jan maxkata jawékibo onanke. Ja Dios ikonhayamai jonibaonbichora akai jaskáyoraakin shinankin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jaskara iken ja Diossen ikinaton itireskaya shinankanwe; jatianra neskara jawékiboribi maton biti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Rakéyamakanwe, mato ichamabo riki nokon oveja keskábo, ja nokon Papanra jawen jakon shinanman jawen ikinaton mato ikinti shinanna iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ja mato jayata jawékibo marotaanan ja jawékinin yoronaishokobo jato akinkanwe. Ja pisha payon jawéki akai keskáakin ayamakanwe; ja naikanmeax jawetianbi keyótima jawékibokaya akanwe. Ja jain yometso jikitima itan jainoa jawen ibon pia potoax payótima ikain. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jaweranoki maton icha jawéki benxoa itina, jainresa maton shinannai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Moa benxokaatabo ikanwe; moa maton lamparin keteax manata keskábo ikanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ja yonokanai joni keskabo ikanwe, ja yonokaatai jonira ikai, ja wanokanai fiestanko katanax yamé joxon, jan teemaitonin kenatoshitatianbi xepóti kepenxontires inox manati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kikin rarora iti iki, ja jan yonoai jonin joxon oinna, jawen yonoti joni oxaama iká. Enra mato yoiai jabébi pinon ixonra jawen mesan yakámati iki. Jaskáaxonra jan yonoaitonin jawékiamati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kikin raroti jawékira iti iki, ja yonoai jonin, yamé pochínikon iamaxon nete xabataitian joxon oinna jawen yonoti joni oxaama ikai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jainxon neskara jawéki rama onankanwe: Yamé ja hora yometso jawen xobon joái onanaxa, ja joni moa oxatima iki; jawen jawékibo yometsoanaketian koirani. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaskatira matoribi moa benxokaatabo ikanti jake, ja jonin Bakera maton joti shinannamatian jonoxiki”, akin jato Jesussen aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jatian Pedron yokata iki, neskáakin: —Ibó, ja jawékiki yoinhanan min noa yoiaboki, noabicho onanmakin min aká o jatíbi jato onanmakinki min yoia —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jatian non Ibon yoia iki: “Jawerato yonotiki jawen ibon ati yoiai jawékibo, jakonhakin senenhaxonai iki, jara jawen ibon jawen xobon ikábo jato jawékiamaxonon ixon yoiai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jatian jan yonoai jonin joxon, jan yoiabo senenhaxonai nokoketianra ja yonokaatai joni kikini raroti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ikonshamanra en mato yoiai, jan yonoaitoninra jatíbi jawékibo koiranon ixon jikimati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ikaxbi ja yonoti jonin ati iki, neskara shinankin: Ja ea jan yonoaira basipari joái iki ixon. Jaskara shinanxon ati iki, jabé yonokaatai benbobo itan ainbobo jato ramiakin peokin. Jaskáakinra ati iki janbichores pikin itan xeakin; jainoax paenibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jaskatibo itainbi iti iki, jan shinanamainbi jan yonoai joni joí, ja joti hora onanamabobi ikenbi. Jaskara joxon nokoananra, akonbireskin castiganti iki; ja jatíribi yoitimabo jato akai keskáribiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jan yonoai joni, jaskara atin keenaibo onanaxbi, ja anox benxokaatitianbi yoitimatai yonotira, castigankin akonbireskin rishkiti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ikaxbi jawerato yonotininki, ja akáx castigameti jawéki onanyamaxon akai; jara ayorakin rishkianan castigantima iki. Jaweratoboki icha jawéki ati jato onanmaa iki, jabora ichaakinribi jato yokánoxiki; jaweratoboki icha jawéki ati yoia iki, jabora ichaakinribi, akárin senenhakin ixon jato yokánoxiki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Eara nato main joá iki, chii ketea tiritai keská inon ikax. Jaskatira ja chii tiritai keská imentinin ea keenai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Rekenparira, kikin jakonmabires tanakaati jawéki ea winóti jake. ¡Jaskatira jatíbi jaskarabo senenai kaman ea ikonbiresi onitsapitai! ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Matonki shinannai nato neten jakonshaman jato jamanox ea joá? Jaskarama riki, jonibo meskoákinbo shinanni jatonbiribibo ikanon ikaxa ea joá iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ramatian peokootaxa, ja xobonkobicho jaa pichika jonibo sinakanannoxikanai, kimisha iti iki, ja rabéki jakonmaati, rabé iti iki ja kimishaki jakonmaati. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papa iti iki jawen bakeki jakonmaati, ja bake benbobiribi iti iki, jawen papaki jakonmaati, ja titabiribi iti iki, jawen bake ainboki jakonmaati, ja bake ainbobiribi iti iki, jawen titaki jakonmaati, ja rayos ainbobiribi iti iki jawen baban ewaki jakonmaati, ja baban ewabiribi iti iki, jawen rayos ainboki jakonmaati”, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jainxon Jesussen jain iká jonibo jato yoiribia iki, neskáakin: “Bari kaiori nai koin keyatai oinxon, maton onanke oi beai; jatianra ikai maton yoia keskati iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jainxon ja surhorikeax niwe payataitianribi, akai maton yoikin, bari xana ikai, jatianra ikai ja maton yoia keská ikí. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Beparametai jonibo riki mato! Matonra akai ja nai bochiki jaskara ikaitian, ja main jaskara ikaibo onankin. ¿Jatian jawekeskaakinki nato netebaon jaskara ikaibo maton onanyamai? akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jawekopiki jaskáaxon jakon jawékibo atibo, matonbi onanyamai? ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jonin mia ati iki, ja joi benxoai joni koshiboiba boti shinankin, jatianra jaskarainbo mato bokanamatianbi, jakonshamanxonres ja joibo benxoatikaya maton shinanti jake; jaskarainbo mato boyamakanon. Maton jaskáyamaabira, ja joni koshin mato policiabo yatanmati iki, jatian ja policiabaon mato cárcel meran niakanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ja jatí kopiáti mato yoikanatii nete senenhax mato pikotai kaman”, akin jato aká. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ja netebaonribira jawetii jonibo Jesús oinni bokana iki. Boxon yoikana iki, ja Galileanko ikana jawetii jonibo Pilaton jato retemaa. Jatian jabaon Dios menikin menonoxon retekana yoina jimiboyabiribi ja jonibaon jimi jato méskomaa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jatianra Jesussen jato neskáakin yoia iki: “¿Ja Galilea jonibo jato jaskáakana ikenki, maton shinannai; ja main iká wetsa jemamea jatíribi jaton kaibobo bebonbires ochaya iken retekana? ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jaskaramabora ikana iki; matoribira ja maton akai jakonma jawékibo akonkin jeneyamai, Dios ikonhayamaax mato mawáti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Maton shinannaki, ja Siloé ikainoa torre poxókin keyoni, chonka posaka jonibo; ja Jerusalénhain jakana jonibo bebonbires jakonma jonibo ikana iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jaskaramabora ikana iki ixonra en mato yoiai; matoribira ja maton akai jakonma jawékibo akonkin jeneyamai, Dioski banéyamaax mato mawáti iki”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jainxon jawékiki yoinhanan jato Jesussen neskáakin yoiribia iki: “Westíora jonira inike jawen wainko higo banáya. Jaskara ikax moara bimibirake ixon oinni kaa iki; kaxon oinnabi bimiama iká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jainxonra ja wai koirannai joni yoia iki: ‘Moa kimisha baritia riki, ja higo bimi bikasi ea joái; ikaxbira en biti atipanyamake. Jaskara iken rama moa xatewe, yankabiresa ja wainko chankánake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jatian ja mai koiranaiton neskáakin yoia iki: ‘Ibó, westíora baritiapari en oinbanon, ja namanbo mai karanbexon, jan mai raontibopari en tapóyonbanon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Non jaskáara ibirati iki bimii, jatian jaskáabi iamaketianra moa min jato xatemati iki’ ”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Westíora tantiti netera, jain tsinkíti xobo meranxon jato joi yoii Jesús iita iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jatian jainribi westíora ainbo, moa chonka posaka baritia isinai iká iki. Já iká iki yoshinman katoxkoya banémaa ikax moa pontéti atipanyamaa. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jaskara oinxon Jesussen kenaxon yoia iki: —Ainbó, moara min isin mia benxoke —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jatian jaskáataanan, jawen mekenman ja ainbo tii aka iki; jaskáatianbi ja ainbo moa ponteti nia iki, jainxon Dios rabikin peoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jaskáaketian jain tsinkíti xobomea joni koshi sinata iki, ja tantiti netenbi Jesussen benxoaketian oinnax. Jaskáaxon jonibo neskáakin yoia iki: —Sokota netebicho riki jan teeti nete; ja netebaonresa benxokasi mato joti iki, ja tantiti neten joáma —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jatian ja Ibon jato yoia iki: —Beparametaibo riki mato ¿Mato westíoraninbiki, maton waka bene, iamaxon maton burro, tantiti netenbi chóroxon, onpax xeamakinbo boyamai? ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nato ainbora Abrahamman chiní rareboribi iki, jaskara ikenbira, *Satanássen chonka posaka baritia isinmaxon, ramiayona ike ¿Jamein ja tantiti netenbi non benxoati atipantima iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jatian Jesussen jaskáakin yoiketian, jatíbi jawen rawibo kikinbiresi rabinkana iki. Ikaxbi jatíbi jonibobiribi rarokana iki; Jesussen ani jawékibo akai oinnax. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jainxon Jesussen jato yoiribia iki: “¿Jawe jawékiki yoinxonmein, ja Diossen ikinaton iti jawékibo, onantishamanhakin en mato yoiti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jara iti iki, westíora jonin, ja mostaza beroshoko bixon, jawen wainko banaa keská. Jaskáakin banaara xoxoax anitaanan, ani jiwi ikí kaai, jaskara iketianra, ja noyai yoinabo bexon, jain naaxon bachiakanai”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jainxon Jesussen jato yoiribia iki: “¿Jawe jawékiki yoinxonmein ja Diossen ikinaton iti jawéki en mato yoiti atipanke? ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jara iti iki, *levaduraya kimisha wea harina meskoanan meinna, ja jatiobi harina tonko soo imaa keská”, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jaskáakin jato yoia pekáo Jerusalénhain kakinra, Jesussen ja anichaa jemabaon itan maxko jemankobo, jato joi onanmaboa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jainxonra westíora jonin neskáakin yokata iki: —Ibó, ichamashokora ikanai ja kishpinmeeta jonibo —akin. Jaskáaketian jan yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Naxbama xepótinin jikitikaya, shinanni jakanwe. Icha jonibora ja xepótininshaman jikitinin keenaxbi, iti atipanyamakanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ja xobo ibo jikixon moa jawen xobo xepoketianra, jemameax kenati mato neskáti iki: ‘Ibó, noa kepenxonwe’, iki. Jaskáabira ati iki mato neskáakin: ‘Enra mato onanyamake tsoabora mato ibirai’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jatian maton ati iki neskáakin: ‘Mibébira non piá iki, itan non xea iki. Jainxon non jemankonia callenxonbo, min joi jato non onanmaa iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jaskáaketian mato ati iki: ‘Jaweranoabora mato ibirai; enra mato onanyamake. ¡Moa nenoax botankanwe, matobora jakonma jawéki akí jakanabores iki!’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jatian matonra winiananbi xeta kerox anoxikanai. Ja Abraham, Isaac, Jacob jainoax jatíbi ja *profeta ipaonibo, ja Diossen ikinaton jatínko jakanabo jato oinnax, matobobiribi castigana onitsapikin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jonibora benoxiki, norteorikeax, itan surhorikeax; jainoax bari pikotaiokeax itan bari jikiaiokeax, ja Diossen ikinaton jatinkoxon jawékiai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jatianra ja jato namanbirestonin shinanmeetaibo jato xewinabo inoxikanai; jatian rama jato xewinaton shinanmeetai jatíribibora, namanbires inoxikanai —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jatian jatíribi *fariseobo Jesússiba nokókana iki. Jainxon neskáakin yoikana iki: —Moa wetsanko katanwe Herodesninra mia retekasai —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jaskáakin yoikana jato neskáa iki: —Botankanwe; boxon ja paranmisti onan joni, neskáakin yoitankanwe: ‘Rama itan bakishra, ja jonibo meranoa en yoshinbo pikoai, jainxonra isinaiboribi en benxoai. Jaskarabo akinra wetsa bakishbi en moa senenhai’. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ikaxbi ramara ea Jerusalénhain kaai, rama kaaxa, bakish kakábaitax, wetsa bakish ea jain nokoti kaai. Jawetianbira westíora *profeta Jerusalénhainoaxmabi mawáti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Mato Jerusalén jonibo riki, *profetabo itan ja Diossen raana jonibo reteaibo! ¡Mato jaskarabo ikenbira ichabiresakin atapanin jawen bakeshokobo tsinkianan, jawen pechi meran akai keskáakin, enribi mato jakonhakasa iki, ikaxbira mato keenyamakana iki! ");
INSERT INTO shpNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oinkanwe, jawen xobora moa Diossen jeneai, jatianra en mato yoiai, matonra ea oinwetsayamanoxiki: ‘¡Ja Ibon janenko joái jonira jakonhira iki!’, iki mato iki kaai nete nokotai kaman —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Westíora tantiti netenra, *fariseobaon joni koshin xobonko Jesús pii kaa iki. Kaketian jatíribi *fariseobaon oinkana iki; jawemein jain akai ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jainribi iká iki, já bebon westíora joni soo iona. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jatianra ja fariseo itan ja esé onan jonibo, neskáakin Jesussen yokata iki: —¿Atirin iamaxon atimarin ja tantiti netenbi isinaibo benxoakin? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jatian jabaon jawe joibi yoiamakana iki, jainxon Jesussen ja isinai joni tii axon benxoa iki, jaskáa pekáo moa raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jainxonra ja fariseobo yoia iki: —¿Tsoa matobaonki, maton burro iamaxon maton bake mai kini meran kaken tantiti nete iketian tsekatima iki? —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jato jaskáabi jawebi yoiti atipanyamaax netéreskana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jatian ja jawékiatiain chanikanabo boxon, ja kikinbo iti akana yakátininshamanbo katotax yakákanaibo oinxon, Jesussen jato neskáakin esea iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ja wanokanai fiestanko chanikana joáx, ja kikinbo iti akana yakátiainbo mato yakátima iki. Jawekeska ikaxa mia xewina kikin wetsa joniribi chania joti atipanke. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jatianra jan mato chania joni joxon mato ati iki: ‘Nato wetsa joákaya ja mia jain yakata yakáti meniwe’, akin. Mia jaskáara rekenain iwanaxbi ja chinita yakátiain kaax mia rabinti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jaskara iken, chanikana joáx chinitainreskaya yakákanwe; jatianra jan mato chania jonin joxon mato ati iki: ‘Jain kikinbo iti aká yakátiainkaya joáx yakáwe’, akin. Jatian mia jaskáketian oinxonra, ja mibé mesan yakatabaon, mia kikin joniribi shinankanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jaweratoboki jatonbinix jato xewinaton shinanmeetai, jabora jato namanbires iti iki, jatian jaweratoboki, kikinmashokotonin shinanmeetaibo iki, jabora jato kikin jonibo imati iki —akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jainxon, jaiba jawékiati jan kenaa joni Jesussen yoia iki: —Jawetianki tsinkíanan jawékiati min akai, minra chanitima iki, ja mibé raenanaibo, min wetsa, mii patax iká icha jawékiabo; jaskarabores min jato kenaabira, jabaon kopikin mia kenashokokanti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jaskáyamakinkayara ja tsinkíanan jawékiatibo axon, neskarabores min jato kenati iki. Ja jawebiomashokobo, ja shinankomashokobo, ja nitikomabo itan bencheboribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jatianra mia raroshamanres iti iki, jabaonra min jato aká keskáakinribi mia kenati atipanyamakanke. Ikaxbi minra ja joi akaibo mawatax jirikana neten min biti jawékibiribi min binoxiki —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jato jaskáa ninkátaanan, jato betan pii yakata westíora jonin Jesús neskáa iki: —¡Ja Diossen ikinaton jatinkoxon, icha pitiakana jato betan tsinkíxon jawékiaibora, kikinbires raroshamanbo ikanti iki! —akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jaskáaketian Jesussen yoia iki: —Westíora joninra anike, icha tsinkixon jato jawékiakinnoxon, icharibi pitiakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Moa piti hora senenketian, jawen yonotibo raana iki, jato neskáakin yoiti: ‘Bemenkanwe ja pitira moa yasanabo ikax, moa pitires iki’, akin jato yoiti. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jaskáakin jato yoiabi, ja yoiax kayamatibo jatíxonbi yoipakekana iki. Ja reken kayamaitonin yoia iki: ‘Ramabiorara en mai maroxon bike, enra japari oinni kati jake. Jakopira ea kati atipanyamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jatian wetsan yoia iki: ‘Ja mai karanbemati pichika wakara en marokin bike; enra jabopari tanamapakei kati jake. Jakopira ea kati atipanyamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jainxon wetsan yoiribia iki: ‘Eara ramabiora wanoke jakopira ea kati atipanyamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jatian ja yonokaatai jonin, joxon ja xobo ibo yoia iki. Jatíbi ja jokashamakin yoikana joibo, jaskáakin yoia, ja joni sinata iki. Jaskáaxon ja yonoti joni neskáakin yoia iki: ‘Ramabi karibatanwe ja jeman iká callebaon; jain kaxon, ja jawebiomashokobo, ja shinankomashokobo, nitikomabo itan benchebo jato iwetanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Moa jaskáakin axon ja yonokaatai jonin, ja jan yonoai joni yoia iki: ‘Moara en ake, ja min jaskáati yoiabo senenhakin, ikaxbi jain yakákantibora jarésparike’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jatian jan yonoa jonin jawen yonoti yoiribia iki: ‘Rama ja callebaon itan ja bai kaabaon katanwe, kaxon jato teanan iwexon, jato jikimakanwe, ja nokon xobo bochoai kaman. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ikonshamanra en mato yoiai, ja reken en jato kenamaa beyamakanabaonra, ja en jato pikinti aká pitibo jawékiayamakanai’, akinra aká iki —ixonra jato Jesussen yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Icha jonibaonra Jesús chibana iki, jainxonra bechiakexon jato neskáakin yoia iki: ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Jaweratoboki eonmea onanai ixonbi, jawen papa, jawen tita, jawen awin, jawen bakebo, jawen wetsabo, jawen poibo aká bebonbires, itan janbixbi noikaata bebonbires ea noiamai, jabora eonmea onannaibo ikanti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jaweratonki ea kopi mawátinin rakékin, ea chibankin jeneai, jara nokon joni iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mato westíoran ati iki, torre chankanti shinankin ¿Jaskara akámatianbimein, ja peoai jawékimein senenhai kaai ixon shinanipari yakátima iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jaskáyamaxonra moa jaki atibo peoyonxonbi, jankeanyamakin jeneti iki. Jatianra jaskara oinnabo jaki shiroi, ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","neskákanti iki: ‘Nato joninra tee peoa iki; ikaxbira jankeanti atipanyamaa iki’, ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Iamaxon westíora aponmein wetsa apo betan reteanani kati shinanxon ¿Chonka waranka sontároboyabicho ixon, ja jabetan reteanani boaibo rabé chonka waranka sontárobo ikanaitian, rekenpari jawekeskaxonmein non jatoarestiki ixon, shinanipari yakátima iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jatian moa jato betan senenma oinxonra, ja apo jainbipari iken, jawen jonibo jato raanti iki. Moa itima riki ixon, jato joi boxonti. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaskara iken tsoa matobaonki jatíbi mato jayata jawékibo jeneyamai, jara eonmea onanai iti atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ja tashi riki jakon, ikaxbi moa jawen moka keyotaxa; jawekeskataxbi moa jakiribi moka iribati atipanyamake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jaskara ikaxa, mai raonti itan banábo raontibobi moa jakonma iki. Jara moa potatires iki. Ninkataibo ixon, kikinhakin ninkákanwe”, akinra jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jatian ja Romamea apo jato kopí yokáxonaibo, betan jakonma ninkakaatai jonibora, ja Jesussen yoiaibo ninkati bekana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jatianra ja esé onan jonibo betan *fariseobo, jakonmaakinbo já yoii neskatibo yoyo ikana iki: —Nato joninra akai ochaya jonibo betan tsinkíanan jato betan jawékiakin —ikibo. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jatianra Jesussen jawékiki yoinhanan jato neskáakin yoia: ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Tsoa matobaonmein, pacha ovejaya ixon, westíora manóketian, merai kaai kaman, benai kakin ja iskon chonka iskon potabaintima iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jatian jaskáakin benakin meraxonra, rarokin ikóxon bibeiranti iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jatian ja xobon bexonra, jabé raenanai joniboyabi já patax iká jonibo jato tsinkianan, neskáakin yoiti iki: ‘Ea rarokinkanwe, ja nokon oveja manota ikara, en moa merake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Enra mato ikonshaman yoiai; Jaskáribiira nai neten bebonbires raroti jawéki jake, westíora ochaya jonin jawen jakonma akaibo jenetaanan Dios ikonhaketian; ja iskon chonka iskon jonibo moa Dios ikonhaax jakoni jakanabo oinnax ikai bebonbires, akin jato aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Westíora ainbo iti iki; chonka koríkia, ixonbi ati iki westíora manómakin. Jatian ja benakin ati iki; joé keteaxon, jakonshamankin matsóanan, ja nokoai kaman benakin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jatian meraxonra jabé raenanai ainboboyabi já patax jaabo jato tsinkixon neskáakin yoiti iki: ‘Ea rarokinkanwe, enra ja nokon koríki manota iká moa merake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Enra mato ikonshaman yoiai; jaskáribiira ja Diossen ángelbo ikonbiresi rarokanai, westíora ochaya jonin jawen jakonma akaibo jenetaanan, Dios ikonhaketian”, akin jato Jesussen aká iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jainxon jato Jesussen neskáakin yoiribia iki: “Westíora jonira iká iki rabé bakeya. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jatian jawen chiní baken jawen papa yoia iki: ‘Papá, ja ea jayáti min meniti jawékibo ea meniwe’, akin. Jatianra ja papan, jawen bake rabé jato menipakea iki, jato jayáti jawékibobiribi. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jatian jawetii nete pekáo, ja chiní bake jatíbi jawen jawékibo maroa iki; jaskátaanan jawen jatíbi koríkia, ochó jeman kaa iki; kaxon jatíbi jakonma jawékibo akin, jawen koríkibo keyoa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jaskáakin jawen koríki keyoketianribi, ja main jatíbiain jawékiatinin ikí, peokookana iki. Jatianra ja joniribi jawékiatinin ikí peokoota iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jaskara ikenra jain teeti benai, ja jeman iká westíora joniiba kaa iki. Jainoara ja jonin jawen wainko kochibo koiranti raana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jatianra ja kochin piai jawékiatibo oinnax, kikinbiresi jawékiakasa iki; jaskara ikenbi tsonbi jawékiamayamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jainxonra shinankin peoa iki: ‘¡Jawetii teetai jonibaonbira nokon papan xobonko, piti texeareskanainbi, eabiribi nenoa pitin reteai! ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ramara jakiribi nokon papaiba ea karibai. Kaxonra en neskáati iki: Nokon papá, Dioski itan mikiribira ea ochake. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eara moa min bake iti jisáma iki; jaskara iken westíora miibetan teetai joni keskáakinres ea shinanwe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jaskatira moa jawen papaiba kaai, bain karibaa iki. Ja moa nokoti kaaitianra, ochokeabi jawen papan meraa iki. Meraxa já noibai bechii ishtoa iki. Kaxon nokoanan paoxon betsó ayona iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jatian ja baken jawen papa neskáa iki: ‘Papá, Dioski itan mikiribira ea ochake. Ramara ea min bake iti jisáma iki’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ikaxbi ja papan jawen yonotibo yoia iki: ‘Ja kikin jakonshaman chopa ishton sawemakanwe, meosotiribi sawemakanwe, jainxon zapatoribi sawemakanwe. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jainxon ja kikin xoa wakaribi bexon retekanwe. ¡Non rarokin fiestaaxon pikánon! ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nato nokon bakera mawata keská iká iki, ramara moa jiria nokóke. Manotara ikátiai, ikaxbi ramara moa non merake’, akin. Jaskaaxon moa fiestaakin peokana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jaskákanainbi, jawen reken bake, wainkopari iká iki. Jatian moa jokin xobo ochómaxon ninkata, bewábo ikaitian ransaibo ikana iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jainxonra westíora jawen papan yonoti; jaweakiki ikanai ixon kenaxon yokata iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jatianra ja yonotinin yoia iki: ‘Min wetsara jakiribi nokóke, jaskati jakonbires nokóketianra min papan, ja kikin xoa waka jato retemake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jaskáakin yoiara, ja reken bake kikini sinata iki; jaskatax xobon jikikashamaitian, pikóxon jawen papan xobon jikinon ixon yoikin jeneyamaa iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jatianra jawen papa yoia iki: ‘Minra onanke ichabires baritia, jawetianbi miki yoitimayamakin en mia tee axonabo; ikaxbira jawetianbi, westíora chivo baketanibi min ea meniama iki, enbiribi ebé raenanaibo betan reteanan pinon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ikaxbi, nato min bake, ja tsini ainbobo teakin, min koríki keyoax joketianres ake, ja wakabake kikin xoa min retekin’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jatian jawen papan yoia iki: ‘Baké, miara jatíbitian ebé iki. Jatíbi ea jayata jawékibora minaribi iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ikaxbi ramara, fiestaaxon jawékiatibo akáx noa raroti jake. Ja min wetsa mawata keská iitibi jiriribia keská iken, manota ikenbi, moa jakiribi meraribixon, akinra jawen papan aká iki’ ”, akin jato Jesussen yoia iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jainxon Jesussen jaonmea onannaibo neskáakin yoiribia iki: “Westíora icha jawékia jonira iká iki, jawen jawékibo já koiranmaa jonia. Jatian ja joni keshankana iki, jawen jawékibo jakonmaakinbo akin keyonaanai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jatian jaskara ninkáxon ja jawéki ibon, kenamaxon neskáakin yoia iki: ‘¿Jawekeska jawékibo min akaitiankayaki ea neskáakinbo yoikanai? Rama jaskara tee min akábo ea yoipakewe, moara nokon jawékibo koirannai en mia imati atipanyamake’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jatian ja jawékibo koirannai jonin neskáakin shinanna iki: ‘¿Ramamein en jawe ati iki? Ja ea jan teemai joninra moa ea tee bichinai, enra wain teetibobi atipanyamake, jato jawéki yokataishoko ea itira rabin jawéki iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Enra moa onanke, teeoma iketian jaton xobon ea bikanon ixonki, en jaweatiki ixon’. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jainxon ja jawéki koirannai jonin; ja icha koríkia joni ribina jonibo westíorabo jato kenapakea iki. Jainxon ja reken kenaapari neskáakin yokata iki: ‘¿Jawetiiki ja nokon koshi min ribina?’ akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jatian jan neskaa iki: ‘Pacha barril xeni’, akin. Jaskáaketian yoia iki: ‘Jisé nato riki min jatí ribina onanti kirika. Rama jain yakáxon ishton pichika chonka barril kopíati ikares awé’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jainxon wetsa yokáribia iki: ‘¿Minki jawetii ribina?’ akin. Jatian jan yoia iki: ‘Pacha sako trigora en ake’, akin. Jaskáaketian yoia iki: ‘Nato riki jatí min ribina onanti kirika, rama posaka chonka kopía itiakin awe’, akin. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jatian jan yonoai jonin, onanna iki, ja jaweki koiranti imaa jakonma joni kikinshaman shinanti onan iká. Ja Dios ikonhayamai jonibora jaton koríki teemati onanhirabo ikanai, jatian ja Diossen joi akaibora, jaskarairamabo iki. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jaskara kopíra en mato eseai, ja maton bia koríkininbokaya, mato betan raenanai jonibo ikantiakin jato akinkanwe, jatian jaskarabo moa keyóketian, jatíbitian jati nai netenxon mato Diossen binon ixon. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jaweratobaonki ichama jawékia ixonbi jakonhakin akai, jabaonra icha jawékiboribi jakonhakin akai. Jatian jaweratobaonki ichama jawékiboribi jakonmaakinbo akai, jabaonra, icha jawékiboribi inonbi jakonmaakinbo akai. ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jatian ja nato netenxon, maton bia jawékibo jakonmaakin akai ikenki, ¿Tson ja Diossen jawékibo koirannai mato imati iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jatian ja wetsabaon jawéki akin, jakonhaxon maton ayamaitianki, ¿Jawekeskaxon ja matonabi iti jawékibo mato menikanti iki? ");
INSERT INTO shpNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tsoabira rabé joni teexonai iti atipanyamake, janra wetsabicho noixon ja wetsa omisti iki. Wetsabicho joi ninkáxonkinra wetsa axontima iki. Tsoabira Diossen tee axonyananbi ja nekeabi jawékiakinbores shinanni jati atipanyamake”, akin jat