﻿USE sofia;
DROP TABLE IF EXISTS sofia.shj_vpl;
CREATE TABLE shj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES shj_vpl WRITE;
INSERT INTO shj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kän mange käsäkädä dackä ngakä wexeki kasogäning na kä'desesäning tä warogkang tä räbäne kä'day, ");
INSERT INTO shj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","winy kaꞌdas luguki känggi wexe ngakä Kaläg na koxtu nga na aga ndä lugung tä kogkang. ");
INSERT INTO shj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nenyang agänang na ngasang karäbtä ngakä weg käꞌday appoyo tä debic ndä oxowa apo ka agä mändey anggärekärejey bandagä räbäne tägi käxa ngondey Tiyafilus, ");
INSERT INTO shj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ndey ka gi bäle zänggä ngakä wegki kaläpesäning tä giningang. ");
INSERT INTO shj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tä butugku Xirudus buguningzä Yaxudiya, me tämed tä Kalägkandäng age ka Zakariya näs wayagkä menggä tämed tä Kaläg tä udsa säbangäs Abija. Ndä uxumandäng age ka Alizapad näs caxsä Xarunag. ");
INSERT INTO shj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pädaxkäsa sälelexiny tagä Kaläg ndä sämene ngakä täsediccä Kaläg käꞌday na akäsogi Kaläg payis känang appoyo. ");
INSERT INTO shj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ndä pipindäng täsa säxong xa uxuma Alizapad pixing, ndä sa pädaxkäsa saboxso. ");
INSERT INTO shj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xongonendäng Zakariya na udsä menggä wexeki kamen wexetang, kamen wexekä tämed tä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na 'dodony kadel täma täbangä tanyaranä menggä tämed tä Kaläg ka mäꞌdoc taxä tämekä tedeldäkä Kaläg tä lägoygä mäxäs. ");
INSERT INTO shj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ani mägäꞌdoccus tä lägoygä mäxäsang, kulung känggi tängang kapasäning tunyu palacca. ");
INSERT INTO shj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na kala malayikanä Kalägkandäng kawayasa täma dokolo tandä abanic täwang tumunu lägoygä mäxäs. ");
INSERT INTO shj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Na todi Zakariya kox malayika na nyigatäg kamen ma mädätägä. ");
INSERT INTO shj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na malayika ngade täma ka, “Zakariya, wanga nyigatäg xa Kaläg kädäng paleygägi. Uxugi Alizapad ꞌdo yedäng päxä apang tägi ndä gi nꞌdoco dogada age ka Yoxana. ");
INSERT INTO shj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma mäsogo wanägi laye tidi, ndä kän mange lededäning xa sägäyäng ma, ");
INSERT INTO shj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ndä ma mälayis käxa tädäx na apo tagä Bazuwec. Ndä mäwuxi bux säxong, na mändey wuxiki ꞌdazic tängang mäwuxi säxong. Ma mälayis käxa päsewa na Ligidä Kaläg cawu cukuma tä bälegkä bosa. ");
INSERT INTO shj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma mämelede menggä Israyil mange ta Bazuwec Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma mälayis käxa päccada tagä Bazuwec na panggu kala panggudugku me logey Iliya ndey mäwex mäganygä menggäsa ndey laley enggengga, na menggä koꞌdo mäwexe mäganyga ndey nyangädä lelertägkä däppic ndey mäbolasa kän tä benggä Bazuwec.” ");
INSERT INTO shj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Zakariya kamänze ka, “Agä asogowa key ndey abäle ka ngakong layecänäs tireneng? Xa agä kaboxsu ndä uxang kaboxsu mändey.” ");
INSERT INTO shj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malayika kabuc ka, “Agänang anäs Jiprayil. Agä awede tä cuku Kaläg ndä Kaläg kayaxsä agä ka agä awung alegeyze tägi agoying yaxsäweccong apong tägi. ");
INSERT INTO shj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndä gang nyäpäladas gi legecce säxong, basa xongondi ngakong sogoduning tängang, xa gi kämen ngakang säxong, ndä käcag wunosuno layeccänäs tire tä xongondi tängang.” ");
INSERT INTO shj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndä känatäng bene Zakariya tunyu mänedäning ka oxadi siye Zakariya kalaygädä taxä tämeki tedelang mänang. ");
INSERT INTO shj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na kala mawetä tunyu ndä ikäma kaxsäwa mäyex legey täsa säxong, na todi sabäle ka mägox nimic tä cukuma taxä tedeläccä Kaläg, malewa na läläbey yä mäyex legey säxong. ");
INSERT INTO shj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kala wexekäma käpeläning na mägämele tä pa. ");
INSERT INTO shj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na kala todi uxuma Alizapad koxsonga käcatäng asämeny mädäg ꞌdaꞌdanyewa. ");
INSERT INTO shj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cängade ka, “Kalägkang kawex ngakong tagä, tä sänggong nyaläpäng paygänya ndä nyägäcay zänggä motakang tä warä kän.” ");
INSERT INTO shj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tä asämexsi aran layis näkä oxsongdugku Alizapatang, Kaläg kayaxsä malayika Jiprayil tä cabärä Calil tä kaxsä pana säbangäs Nasra, ");
INSERT INTO shj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ta kedenweccandäng säbangäs Mariyom sader ta apangandäng säbängäs Yusif tä caxsä Dawud. ");
INSERT INTO shj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na malayika kawung täce, kämodey ce ngade täce ka, “Gingang nuxundugkägi käbaxändey tä känang, Kalägkang nagi!” ");
INSERT INTO shj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na Mariyom käbabangwa tä ngaki malayika kangatang, ndä cägäre bangä modeygi mänangang. ");
INSERT INTO shj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na kala malayika ngade täce ka, “Wanga nyigatäg Mariyom, xa Kaläg kadong baxändäg tägi! ");
INSERT INTO shj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dänge! Gining no noxsongada ndä niyedäng päxä apang ndä dogada age ka Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma mälayis käxa ngake tädäxiny ndä säbangäs ma päxä pe Kalägi tiyating, ndä Bazuwec Kaläg togada butugku wawanäma Dawud täma. ");
INSERT INTO shj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma mämene butug tä känggä Yaxup ndä sanydenendäng säxong, ndä butugkuma 'desetäsäno säxong.” ");
INSERT INTO shj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyom ngade ta malayika ka, “Ngakong layeccä key, yä taxä nuxu kasäng na apang songang?” ");
INSERT INTO shj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na malayika kämeley ngade ka, “Ligidä Kaläg coccolacca tägi na panggugu Kalägi tiyating wunodung wayedäng tä bälegkägi na asämexsägi lada, nenyang päxä pipini niyedängang näka tedelang, ndä säbangäs ma päxä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndä za, wayigo Alizapad na boxuske mändey oxsong tä päxä apang yä kän bangäs ce pixi, gang satäng täce asämeny aran! ");
INSERT INTO shj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ndä 'doga bede tä Kalägkandäng song.” ");
INSERT INTO shj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Mariyom kagixi ngade ka, “E, bi, anäs me wexiccä Kaläg. Wanga ngaki sogoduning tagäng layis wega tä bangä ngakigigong.” Na malayika kä'doc kawangasa ce. ");
INSERT INTO shj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na tä sänggi Mariyom kangäsa tetex kä'doc tä kaxsä pa tä cabärä Yaxudiya, ");
INSERT INTO shj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","na caläs pang Zakariya na cägämodey Alizapad. ");
INSERT INTO shj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na Alizapad kädäng modeygä Mariyom, na pipini tä bälegkäce Alizapatang käpäräwa, na Ligidä Kaläg käligä Alizapad. ");
INSERT INTO shj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na Alizapad kasan kädawa ka, “Kaläg kadä wanägi tä warä uxu kä'day na päxägini tä bälegkäging! ");
INSERT INTO shj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Agänang anäs xäng kädäppa ka bo Bazuweccang wung copu agäng? ");
INSERT INTO shj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ani kandängäs modeygägi na wundangang, päxä pipinong tä bälegkangang käpäräwa na wadäkä tididäg. ");
INSERT INTO shj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gi käbaxändey xa gi kämen ngaki Kaläg kalegey tägi ka 'desetäsäningang.” ");
INSERT INTO shj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Mariyom ngade ka, “Mägaxsang dädäxti Kaläg, ");
INSERT INTO shj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na ligidang kadeb led tä Kaläg me nayiccang, ");
INSERT INTO shj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","xa nyägox cuku molgang, agä me wexiccänya. Ndä ganang menggä zädong, kä'day bangäs agä käxa kabaxändey. ");
INSERT INTO shj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Xa nyang nyäs Bazuwecca pädägkang kawex wexeka ngoniny tagäng ndä agänya tedeliny. ");
INSERT INTO shj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tä menggä zong na banga, agänya watasa tä känggi nyaye nyang. ");
INSERT INTO shj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nya nyawex wexeki tädäxinyang na andänya. Ndä nyawasa känggi logoduning na wexe degejey tä mäganyganang. ");
INSERT INTO shj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nyägäcoccoley menggä butug yä nyägäpoka känggi butug wundung tängang tiyati, ");
INSERT INTO shj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ndä nyägämas menggä xas na weka apoccu, yä nyamatä känggi näs tanganuwang na asängga päloccu. ");
INSERT INTO shj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nyaxony menggä wexekänya Israyil xa nyanimäng agäwaydakänya, ");
INSERT INTO shj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kala täseki nyadästäs wawanakogki mägaccängang, na ta Apraxim na atuge näs ur'dug.” ");
INSERT INTO shj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kala Mariyom kuccu na Alizapad ta asämenyga kodos na cägämel tä panäce. ");
INSERT INTO shj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Xongondi Alizapad kiye tängang, cägiyäng päxä apang. ");
INSERT INTO shj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na menggä sogalinygäce na wayakäsa kädäng ka Kaläg kädädäxti agäwaydad täce na sägäledäno nace. ");
INSERT INTO shj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tä sänggi tespedespeng sawuno tä luwuku päxä pipi, ndä sägäpay ka sädogas agäma ka Zakariya täbangä mesa. ");
INSERT INTO shj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Neng bosa kämele täsa ka, “A'a! Basa sädoga agäma ka Yoxana.” ");
INSERT INTO shj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na sängadeccä täce ka, “Nuxu kigkandäng tä caxsägo age mänang song.” ");
INSERT INTO shj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na sägertäcce ta mesa Zakariya ndey ka sä'dox aga mäpaye mädogas ta penäma. ");
INSERT INTO shj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na mamän owdu badaxiccä gärekärejey na mägärekärejeysa ka, “Age ka Yoxana.” Na sägädongasa käꞌdaygäsa. ");
INSERT INTO shj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na käccogos ikä Zakariya kalengesäwa na nyipäräma kä'dakasäwa na malegeyze, malog Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na menggä sogalinygäsa kä'day nyigatäg kamen, na ngaki kasogänong kalaye legeydäno tä kaxsä cabärä Yaxudiya kä'day. ");
INSERT INTO shj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na känggi kä'day kädäng ngakiyang kameskädä tä mäganyga ndä ngadeccä ka, “Päxä pipinong wunodung layis wi?” Xa andä Kalägkang nang seley. ");
INSERT INTO shj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na Ligidä Kaläg käligä Zakariya me Yoxananag na malogeza ka, ");
INSERT INTO shj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Andädäxti Bazuwec Kalägä Israyil, xa nyawung tä posakä kän na 'dakakä kän. ");
INSERT INTO shj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ndä nyägängusey yaxticcä xonyad tä kog tä känggä me wexiccänya Dawud, ");
INSERT INTO shj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kaꞌdas ani nyalegeyzenäs na ikänggä menggä logeygänyagi mägaccäng tedelinyang, ");
INSERT INTO shj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ndey ka nyäxony kog tä menggä kurog, na mändey ta asänggä känggi kä'day saxe kogkang. ");
INSERT INTO shj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nyasog ngakong ndey nyälapa agäwaydad ta wawanagkog, na ndey nyäniming axäskänyagi tedelinyang, ");
INSERT INTO shj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na täsedicci nyägäloguwa nang ta wawanog Apraximang. Täsedicci lapedäng ka ");
INSERT INTO shj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kogki nyaxony kog ta asänggä menggä kurogkang ndakä wexedig nya na nyigatäg song, ");
INSERT INTO shj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tä tedeldäg na lelextäg tagänya tä loydugkä aygog. ");
INSERT INTO shj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndä gi päxä penangong säbandäs gi me logeygä Kalägi tiyating, xa gi piccadas tagä Bazuwec ndey bolasa sota tänya, ");
INSERT INTO shj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ndey doga ligiccä xonyad tä känggä Kaläg na wangakä ngaka tasiny tä känggänya. ");
INSERT INTO shj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xa agäwaydakä Kalägog wunodung xonyo kog paratasawa ka'das keyzic ");
INSERT INTO shj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ndey bowdic wung tä känggi käcasäng tä lätäng na tä ligidä xäsang, ndey meskede exenggog ta akäsogä modey.” ");
INSERT INTO shj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ndä päxä pipi wedede na kiniy tä wane na yexkä nga. Ndä mäguccu tä pumpung basa xongondi mawesawa na wexed tä Israyil tängang. ");
INSERT INTO shj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tä enggä sänggi Axustus Kaysar kabokung asiriye tunyu ka kän kä'day 'docco gärekärejeysa aga tä cabär kä'day tä wexekä tuluba. ");
INSERT INTO shj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndä gärekärejeyga täzälägkang, tä cuku Kuruniyos tä butug tä Suriya. ");
INSERT INTO shj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kän kä'day kä'docco tä cabärtaga ndey gärekärejey aga täng. ");
INSERT INTO shj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na kala Yusif kawetä mändey tä cabärä Nasra tä Calil kä'doc tiyati tä Petlaxam cabärä Dawud, tä Yaxudiya, xa ma mäs me cabäri ndä mäs wayäwan tä caxsä Dawudag. ");
INSERT INTO shj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mägä'doc ndey sägärekarejeysa agäsa na Mariyomzi sader tämang ndä cägä'dosuwa. ");
INSERT INTO shj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na tä cuku sa todi, pipi kagasäng ce. ");
INSERT INTO shj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na cägiyäng päxäcenä zäläg näs päxä apang na camulungi na tandä ndä cäzänggasa tä kuburicci säziye male tängang, xa axa säzänggasa täng undung. ");
INSERT INTO shj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndä tänya owdi menggä megäsatäng cuccu käsac tä korongo meske sagunuga ongud. ");
INSERT INTO shj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na malayikanä Kaläg kaweyesawa täsa na tädäxticcä Kaläg käbanyeza tä waräsa na nyigatäg kadele sa nano. ");
INSERT INTO shj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na malayika kangada täsa ka, “Wanga nyigatäg! Ndänge ngakong, agä anduwale yaxsäwecca apo tanggo aki kodung wadäkä tididäg tä kän kä'dayang. ");
INSERT INTO shj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Xongondong sägiyäng me nayic tanggo tä cabärä Dawud. Mang mäs Almasiyang ani näs Bazuweccang. ");
INSERT INTO shj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndä boliccongang lapedäng tanggo ka, anggo 'doxadang päxä pipi kamulungiwa na tandä ndä sängo tä kuburicci säziye male tängang.” ");
INSERT INTO shj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na kälilic malayikadagi tiyating kaweyesäno mange na malayikani dädäxti Kaläg ngadeccä ka, ");
INSERT INTO shj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dädäxtic tä Kaläg tiyati, na modey täzäg tä känggi nyäpayeng!” ");
INSERT INTO shj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na kala malayikada kawangasa sa kä'docco tiyati, na menggä megäs ngadeccä tä ngastängga ka, “Nycugo tä Petlaxam ndey laleyig ngaki kasogäno todiyang, aki Kaläg kaläpäng täkogkang.” ");
INSERT INTO shj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na sägä'docco tetex sa'doxa Mariyom na Yusif na pipi sägäsänggasa tä kuburicci säziye male tängang. ");
INSERT INTO shj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kala sägox pipi, na saser ngaki saläpa täsa tä ngakä piping, ");
INSERT INTO shj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","na känggi kä'day kädängang käsaydä aga tä ngaki menggä megäs kalegeyang. ");
INSERT INTO shj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yä Mariyom kameskäde ngaki kä'day tä mägaxse ndä cägäre tä mägaxsäce ka ngakong key. ");
INSERT INTO shj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na kala menggä megäs kämele, dädäxti Kaläg tä ngaki kä'day sägädäng na sägoxang, xa nga kä'day ka'das ngaki saläpe täsang. ");
INSERT INTO shj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tä sänggi tespedespeng, salu ma na sadogas agäma ka Yasuwa, agi malayika kadogas musku cägoxsonga täma songang. ");
INSERT INTO shj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ani Mariyom kä'desenäs sänggä iyekeneng, tä bangä asiriyenä Musa, Yusif na Mariyom kagoying Yasuwa tä Ursalim ndey sädogas ma tä Kaläg ");
INSERT INTO shj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ka'das ngaki gärekärejeyno ta asiriyenä Kalägkang, ka “Pipugi siyedäng tä zälägkang näs enggä apangasang sädoga kä'day tagä Kaläg”, ");
INSERT INTO shj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ndey sädämze ka'das legeygi asiriyenä Kaläg kangatang, ka sädoga enggä kurugä pa pädax na cong näs kurugä kaxsetang sädoga pädax. ");
INSERT INTO shj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ndä gang 'doxtiyandäng tä Ursalim säbangäs Simiyan apangza lelexang ndä kamen ngakä Kaläg ndä bene käxa xonyo Israyil. Ligidä Kalägkandäng täma. ");
INSERT INTO shj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ligidä Kaläg kaläpe täma ka mäxse song basa ka mox Almasini Bazuwec Kaläg kayaxsängang. ");
INSERT INTO shj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Ligidä Kaläg koyo Simiyan na mawung taxä tämed tä Kaläg, mändey Yusif na Mariyom kagoying päxä pipi Yasuwa ndey ka säsog tanyara täng tä bangä asiriye, ");
INSERT INTO shj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","na Simiyan käpokä ma tä asängge ndä log Kaläg ngade ka, ");
INSERT INTO shj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gang, tä bangä ngadagkägi gi Kalägi ngondeyang, mene andang 'daki me wexiccägi 'doc na modey. ");
INSERT INTO shj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xa agang kox me 'dagkicci ");
INSERT INTO shj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","käbolasa tagä kän kä'dayang. ");
INSERT INTO shj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mangang mäs banyiccang, ndey gi Kaläg, lapasäwa tä känggi näs Yaxudiny songang, na dädäxtic tä känggägi menggä Israyil.” ");
INSERT INTO shj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na todi Yusif na Mariyom käpegse tä ngaki kalegeyno ta päxäsang. ");
INSERT INTO shj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyan kapes sa. Na ngade ta bosa Mariyom ka, “Ndelde wunggugo appoyo! Kaläg kalebäng päxä pipinong ndä mang mäsogo telänad na ngäsakä kän mange tä Israyil na mälayis bolicci kän saxeng. ");
INSERT INTO shj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndä nästire, mäganygä kän mange lapetäsäno tä bangä wexekäma ndä gining tä ngasägi, mägaxsägi 'dudowa!” ");
INSERT INTO shj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mändey me logeyandäng näs ux säbangäs Xana päxä pe Fanawil tä caxsä wayakä Asir. Ce caboxsä na'do, sabagäning na yoxuce sägäcuccu tä jendäg paxtänding basa xäskäma. ");
INSERT INTO shj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na cäguccu tä mandurtug tä jendäg udiny tesped wang tesped (84). Ndä casäja axä tämed tä Kaläg song, cädukuru na uxkud tä ngasäce ndä cäpalacca ongud na säxe kä'day. ");
INSERT INTO shj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na tänya xonggondi, cawung täsa na cadeb logakä Kaläg ndä cälege ngakä pipi tä menggä Yaxudinygi kä'day bene tegic tä Ursalimang. ");
INSERT INTO shj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na kala Yusif na Mariyom kä'dese nga kä'day tä bangä asiriyenä Kaläg, na sägämele tä Nasra tä cabärä Calil. ");
INSERT INTO shj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na päxä pipi ka'donga ndä kalay pädäg, käpäsäwa na lelertäg ndä payiccä Kalägkang na ma. ");
INSERT INTO shj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Me Yasuwanag na bosa 'docco tä Ursalim jenijeni tä Pärkid. ");
INSERT INTO shj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ani jendägkä Yasuwa käcogäs asiny wang pädaxang, sägä'docco tiyati tä Ursalim na bangä adi. ");
INSERT INTO shj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sägä'docco sägä'dese Pärkid na tä melgäsa tä pa, päxä celic Yasuwa kalay tong tä Ursalim. Ndä mesa na bosa yex song. ");
INSERT INTO shj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sa säcuccu ka mandäng na känggi säwedeccä nangang, sägäcogu sängädi nuxungang, na sägä'docco sämänecce sänyame ma tä warä wayakäsa na biskodagäsa. ");
INSERT INTO shj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ndä sa'doxas ma song na sägämele tä Ursalim tä nyam. ");
INSERT INTO shj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tä sänggi kodos tä bangeneng, sa'doxas ma taxä tämed tä Kaläg, tä kaxsä kal. Mägäcca tä pidänä balduwiny, mädelde wunduma täsa ndä mämäne sa. ");
INSERT INTO shj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na känggi kä'day kädäng legeygä Yasuwang, kädongo tä yerändägkäma na bucuku nga ta menggä bäldey. ");
INSERT INTO shj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mesa na bosa kox ma na wadäka koyo na bosa ngade täma ka, “Päxang, wi siye gi käsogkuwa täwas mänang? Lala, menggo na agänang wanyamedig owdugi paccey.” ");
INSERT INTO shj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na mägämele täsa ka, “Wi siye anggo nyamadang owdangang? Anggo 'diyang ka pang Appanang nyaza anycu tängang?” ");
INSERT INTO shj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ndä musku kax menggäsa kabäle ngakäma täsa song. ");
INSERT INTO shj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na sacoccoleza sägämelese tä Nasra ndä mädede nga täsa. Ndä bosa meskede ngaki kasoguningang kä'day tä mägaxse. ");
INSERT INTO shj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ndä Yasuwa 'dongada na lelertägke, ndä Kaläg na kän paye ma. ");
INSERT INTO shj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tä jendägki asiny wang mädägkang tä butugku Tapariyos Kaysar, ndä Pälatis Alpondi buguningzä Yaxudiya. Xirudus bazuweccang tä Calil, na päxä bosa Filipus päxä bazuweccang tä cabärä Itoriya na Taruxontis. Yä Lisaniyus bazuweccang tä Apäliya. ");
INSERT INTO shj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Legeygä Kaläg kawuno ta Yoxana päxä pe Zakariya tä pumpung ani Xanas na Kiyafa, seley layis ngotorpugu menggä tämed tä Kalägkang. ");
INSERT INTO shj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na mägä'doc tä Colonggonä Urdun kä'day, mäduwale ngakä xajkä kän tä ngaka tasiny, na pac tä ma. Ndey Kaläg cay ngaka tasinygäsa xa sägäxaje. ");
INSERT INTO shj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ka'das ani gärekärejesawa tä sorunu legeygä me logey Isayang, “Ndänge ngasawan logacca tä pumpung ka, ‘Weye akäsog tä Bazuweccog, ndokala akäsog täma. ");
INSERT INTO shj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ko'dota kä'day 'docco päseccä, cabärta na enggä cobocoboriny mäxotusuno, na akäsogi kagolopewang dokol, na sogi ngudungudulang zäräzirigiwa, ");
INSERT INTO shj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ndey kän kä'day laley xonyakä Kaläg.’” ");
INSERT INTO shj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na Yoxana ngade tä xä'däni kawuno tä paccang ka, “Ama caxsä enggä tämong! Xänang kädaxä anggo ka mpexkeng zängaygä Kaläg tanggong? ");
INSERT INTO shj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ndä gang läpäning 'dogi lapedäng ka anggo kälayisang kängga kämele tä Kalägkang. Ndakä layisang kängga bangada Apraxim tä ngastängga ka menanang. Ndakä ngadang ka, ‘ 'Doga siyewa tä kogkandäng song.’ Agänang aläpedäng tanggo ka Kaläg nguso nganyugong teyis pipu ta Apraxim! ");
INSERT INTO shj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Seley ganang kompa käcicilisuwa tä mäxkä ewe ndä eti iyedäng engge apoccu songang säluwutäsa täzäg ndä sägawa tä mas.” ");
INSERT INTO shj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na xä'dä kamän ma ka, “Neng gang wasogig wi?” ");
INSERT INTO shj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yoxana kabuc täsa ka, “Käxa tandu täng pädaxang larä na käxi ne wundungang ndä käxa siyake tängang sog mänang.” ");
INSERT INTO shj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Menggä yawgä tuluba mändey kawuno tä pac tä ma na mäne ma ka, “Me bäldic, yä wasogig wi?” ");
INSERT INTO shj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na maläpe täsa ka, “Ndakä yawadang weg mangeccä tä wegki saläpäng tanggong.” ");
INSERT INTO shj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ndä kulung asägaru mändey kamän ma ka, “Yä was, wasogig wi?” Na maläpe ka, “Ndakä bagkadang weg tä kän na rejic mändey na celdug, gixi maxiye na 'dogi sädogodäng tanggong.” ");
INSERT INTO shj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na todi kän wadäka kalaye tidiny xa satäng bene Almasi, na soxo ka Yoxanang näs Almasi. ");
INSERT INTO shj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoxana kabuc täsa kä'daygäsa ka, “Agä anäs käxa pacce anggo tä ma winy, yä kigkandäng wunodung ndä panggudugke mo'do kanggä. Agänang anäs käxa ulidi käbadage song. Ndä ma mäwunodung mägodung Ligidä Kaläg tanggo na mas. ");
INSERT INTO shj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ndä adalandäng ta andäma ndey mexenäs nyada täpox yä mädoga kuny tä curunuma, yä nyada mädunyu na masa paxewa song.” ");
INSERT INTO shj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndä ta akäsogong na pagad mange, Yoxana kalogey yaxsäwecci apo lege ngakä Kalägkang. ");
INSERT INTO shj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ndä ani Yoxana kä'dedeyis Xirudus tä ngakä batakä uxä päxä bosani säbangäs Xirudiya na wexeki mändey mawex tasiny kä'day, ");
INSERT INTO shj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Xirudus kasog 'doga tas mändey. Madene Yoxana tä ax. ");
INSERT INTO shj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kän kä'day käpacäning tä ma, na Yasuwa mändey kawung sägäpaccä. Ani mäpalaccanäsäng tiyati kalengesäwa, ");
INSERT INTO shj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Ligidä Kaläg kacoccoleza täma oxowa ka'das kuruwic na legey käpätäsäng tiyati ngadeccä ka, “Giningang nuxundugkägi näs penanggi ampaye ngakeneng. Xa ngakägi kasog wanang tiding.” ");
INSERT INTO shj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ani Yasuwa kadebäs wexekeneng, satäma jendäg ud wang asiny. Ndä kän oxo ka mäs päxä pe Yusif, päxä pe Xali, ");
INSERT INTO shj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","päxä pe Matad, päxä pe Lawi, päxä pe Malki, päxä pe Yuna, päxä pe Yusif, ");
INSERT INTO shj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","päxä pe Matäsaya, päxä pe Amus, päxä pe Naxum, päxä pe Xasäli, päxä pe Nacayi, ");
INSERT INTO shj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","päxä pe Mas, päxä pe Matäsaya, päxä pe Samayin, päxä pe Yusic, päxä pe Goda, ");
INSERT INTO shj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","päxä pe Yoxanan, päxä pe Resa, päxä pe Zaräpapil, päxä pe Saltil, päxä pe Niri, ");
INSERT INTO shj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","päxä pe Malki, päxä pe Adi, päxä pe Gäsim, päxä pe Almadam, päxä pe Ir, ");
INSERT INTO shj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","päxä pe Gesuwa, päxä pe Aläyasär, päxä pe Yoram, päxä pe Matad, päxä pe Lawi, ");
INSERT INTO shj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","päxä pe Simiyan, päxä pe Yaxuza, päxä pe Yusif, päxä pe Gonam, päxä pe Aliyakim, ");
INSERT INTO shj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","päxä pe Maliya, päxä pe Minan, päxä pe Matada, päxä pe Nasan, päxä pe Dawud, ");
INSERT INTO shj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","päxä pe Yasa, päxä pe Oped, päxä pe Pos, päxä pe Sala, päxä pe Naxsun, ");
INSERT INTO shj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","päxä pe Aminadip, päxä pe Adämin, päxä pe Arni, päxä pe Xasrun, päxä pe Faris, päxä pe Yaxuza, ");
INSERT INTO shj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","päxä pe Yaxup, päxä pe Isxag, päxä pe Apraxim, päxä pe Tarex, päxä pe Naxur, ");
INSERT INTO shj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","päxä pe Suruc, päxä pe Raw, päxä pe Falic, päxä pe Apir, päxä pe Sela, ");
INSERT INTO shj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","päxä pe Kayinan, päxä pe Arfagäsad, päxä pe Sam, päxä pe Nox, päxä pe Lamag, ");
INSERT INTO shj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","päxä pe Mätäsalex, päxä pe Anax, päxä pe Yarad, päxä pe Maxalil, päxä pe Kinan, ");
INSERT INTO shj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","päxä pe Anos, päxä pe Sed, päxä pe Adam, päxä pe Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ndä nyägäligä Yasuwa na Ligidä Kaläg, mägämel na Colonggonä Urdun, Ligidä Kaläg kagoying ma tä pumpung. ");
INSERT INTO shj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Däniye käläbä ma tä sängga udiny pädax. 'Doga masi wundung tä sänggi, ani sänggi kä'desesänonusang ma magä'di na'do. ");
INSERT INTO shj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na Däniye ngade täma ka, “Näs Päxä Kaläg seleyang, lapi tä ngayiccong layis zäx.” ");
INSERT INTO shj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yasuwa kabuc ka, “Gärekärejesawa tä Sorunu Kaläg ka, ‘Siyatag tol naye käxa julang song.’” ");
INSERT INTO shj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na Däniye kabag ma tä ke'dengge'demes ndä banye ow na gertä bugundugku walangiccä täzäg kä'day täma. ");
INSERT INTO shj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na Däniye läpadas ta Yasuwa ka, “Adogodung bugundugkong kä'day tä andägi na tädäxtägki wedetese nangang, xa sadogung panggudug tä andang ndä adogada tä käxi ampayeng. ");
INSERT INTO shj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndä känox kundukurusa käpaley agängang, wekong kä'day känggig.” ");
INSERT INTO shj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yasuwa kabuc ka, “Gärekärejesawa ka, ‘Dukurusa pala Kalägägi na wexe ngake tol.’” ");
INSERT INTO shj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Däniye kabag Yasuwa tä Ursalim, na kädokalasa ma tiyati täzä ndandangzä axä tämed tä Kaläg, na ngade täma ka, “Känox näs Päxä Kaläg seleyang, xudiwa täzäg todong. ");
INSERT INTO shj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Xa gärekärejesawa ka, “‘Kaläg yaxsedäng malayikadage tägi ndey meskädä gi,’ ");
INSERT INTO shj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘muso gi ta asängga wange gi ndey ka 'dingäsa exenägi tä ngayic song.’” ");
INSERT INTO shj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Yasuwa kabuc ka, “Sorunu Kaläg ngade ka, ‘Ndakä läbä Bazuwec Kalägägi song.’” ");
INSERT INTO shj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na todi Däniye kä'dese läbke bägälic, na kala kawangasa ma basa xongoda. ");
INSERT INTO shj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yasuwa käligäwa na panggudugku Ligidä Kaläg, na kämel tä Calil, na todi lulungudäma kuduwalewa kä'day tä kaxsä cabär. ");
INSERT INTO shj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na madeb bäldey tä axinygä palicinygä Yaxudiny na kän kä'day kädädäxti ma. ");
INSERT INTO shj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ndä kala gang Yasuwa kawung tä Nasra, tä owdi ma'donga tängang, na mägä'doc maläs axä paliccä Yaxudiny tä xongondu Sapid, xa nyang näs tanyara tämang. Mangäsa tiyati tä geney, ");
INSERT INTO shj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","na sadogas sorunu me logey Isaya täma. Na malenge soru ma'doxa owdi gärekärejesawa ka, ");
INSERT INTO shj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ligidä Bazuwec Kalägkandäng na agä, xa nya nyaseny agä ka agä anduwaley yaxsäweccä nyani apong tä menggä wiy. Ndä nya nyayaxsä agä ka agä anduwale 'dagkic tä känggi kacikiliningang na ndey ngojony zayza, na känggi sägäcäläxtiyang sä'daka, ");
INSERT INTO shj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ka agä anduwale jendä agä waydagä Bazuwec tä kän.” ");
INSERT INTO shj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na kala mägäräkä Sorunu Kaläg na madoga tä käxi kamen wexetang na mägäcca. Na Känggi kä'day tä axä paliccä Yaxudinyang kamende aga täma. ");
INSERT INTO shj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na Yasuwa käbäldeyza läpede täsa ka, “Ngakä Kalägong kändängeng genewang, xongondong kalayenäs wega.” ");
INSERT INTO shj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na kala kä'daykäsa salegeyze appoyo tä ngakä Yasuwa, na sa'dämdes legeygi tidiny käptäzäng ikämang. Na sängadeccä ka, “Yä 'doxtong de päxä pe Yusifang?” ");
INSERT INTO shj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yasuwa ngade täsa ka, “Nästire anggo zeredeng ngakong tagä ka, ‘Wanga tumarajuwic, däxä ngase!’ na kämpayang tagä ka, ‘ 'Dogi kandängig ka gi käsog tä cabärä Kafärnaxumang, soga todong tä cabärägi mändey.’” ");
INSERT INTO shj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na mapos legey ka, “Aläpedäng zänggä nga tanggo ka, me logeyandäng sägixidi tä cabäre song. ");
INSERT INTO shj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ndä näs tire aläpedäng ngakong tanggo ka madurinyatäng mange tä cabärä Israyil tä cuku me logey Iliya ani zäkoxa kärigkäwa tä jendäg kodos na asämeny aranang, xas kawung tä walangic kä'day. ");
INSERT INTO shj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yä Kaläg kayaxsä me logey Iliya ta nuxu accäsa song, basa ta uxi näs mandur näs me pungud tä kaxsä pang Sarfa tä cabärä Sayidunang. ");
INSERT INTO shj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndä menggä omodatäng mange tä Israyil tä cuku me logey Ilisa, yä nuxu accäsandäng kädäxäwa song, basa Naman me pungudi käpätäng Suriya.” ");
INSERT INTO shj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ani sägädängäs ngakongang, känggi kä'day tä axä paliccä Yaxudinyang käsängasa paccey. ");
INSERT INTO shj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na sangusosuno tiyati, samagäng ma tunyu tä kaxsä pa. Na sagoyas ma tä nyixtä päxä cobocoboric, säpaye säzajas ma täzäg tä zä cabäri käke'decekang. ");
INSERT INTO shj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Neng mawetä tä warä xä'dä na mägä'doc tä akäsogäma watäkäma. ");
INSERT INTO shj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yasuwa kä'doc tägaxsä Kafärnaxum tä Calil, tä xongondu Sapid, na madeb bäldeygä kän. ");
INSERT INTO shj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na sa'dämdes bäldiccäma xa soxo bugundug täng. ");
INSERT INTO shj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ndä tänya axä paliccä Yaxudinygi apangandäng käxa tasandäng tä wane, ndä kapere ka, ");
INSERT INTO shj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wayi! Wanga was watäkäsko, Yasuwa me Nasra! Gining kuwung tä paxagäsko? Ayex gi ka giningang Ndedelang na näs näkä Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Yasuwa kadux käxa tasti tä wanämang ka, “Päli! Wete tä wanäma!” Na kala käxa tas kacodasa ma täzäg tä pidänäsa na kawetä napäl kawung ma käppärjig. ");
INSERT INTO shj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Känggi taxä paliccang, kädongasa ndä mänedäning ka, “Oxadi sogowa todong manang? Na butug na panggudug mädaxedäng ligitiga tasiny tunyu na wedeccä!” ");
INSERT INTO shj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na kala lulungudä Yasuwa kawasasäwa tä cabär bägälic. ");
INSERT INTO shj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ani Yasuwa kawangasanäs axä paliccä Yaxudinyang, maläs pang Saman. Na ma'doxa wawana uxu bäxadiccandäng paccey, na sägäpay Yasuwa ka däxä ce. ");
INSERT INTO shj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na mägädokol todu zäce na maduxsi ka bäxadic lay wundung täce. Na käccogos cangäsa tiyati cawexse täsa. ");
INSERT INTO shj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tä 'dängakä xong, känggi wayaka täxäccä na täxäka cagäcaguwinyang, sagoying täma. Na mägäläbtä sa kä'day na wadäkäsa kädaxäning. ");
INSERT INTO shj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kängga tasiny kawetäcco tunyu mangeccä, na pered ndä ngadeccä ka, “Giningang näs päxä Kalägkang!” Na madux sa mäleyis sa legey xa sa säyex ma ka mäs Almasi. ");
INSERT INTO shj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na megetuduyzi täbangeneng, Yasuwa kawangasa sa ka'doc tä owda kaculdoy, yä musku xä'dä nyame bangäma. Ani sa'doxus mang, säleyis ma 'doc wangesänakä sa. ");
INSERT INTO shj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ndä Yasuwa ngade täsa ka, “Basa anduwaley yaxsäwecci apo lege ngakä bugundugku Kalägkang tä kulung cabärtagi tängang mändey, xa ngakongag Kaläg kayaxsä agä ka awung awexang.” ");
INSERT INTO shj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na todi mäwedede mäbäldecce tä axinygä paläccinygä Yaxudiny tä Yaxudiya. ");
INSERT INTO shj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Xongenendäng, Yasuwandäng dokolo tä nyixtä Colonggonä Calil, ndä xä'dä kagurma paye däng ngakä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na mägox dämpejiginy pädax tä nyixtä colonggo yä letuganagi näs menggä menekä asang, kawetäcco tunyu 'daye ka'dadaga. ");
INSERT INTO shj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Yasuwa kä'doc tä kaxsä nuxu dämpejigsi näs näkä Samanang, na mäläpede ta Saman ka, “Zexteyi dämpejigsiginong na pidänä ma.” Yasuwa käcca tä nya kaxsä dämpejigsi ndä bälde xä'dä. ");
INSERT INTO shj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yasuwa kä'dese legeyge, na ngade ta Saman ka, “Nyasi dämpejig tä maga tä'duginy na nggawi ka'dadagägo täng ndey meneng as.” ");
INSERT INTO shj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saman kabuc ka, “Ngotorpo, wakasängig kädayi tä wexed ndä kamenig nuxu 'dog song! Neng tä legeygägigong anggawada ka'dada tä ma.” ");
INSERT INTO shj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na sägädäng ngakäma sägawa ka'dadakäsa tä ma na samen as mange de ka'dadagäsa kacertäno. ");
INSERT INTO shj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na sägädawasa ta biskodagäsagi tä dämpejigsi nuxungang ka wuno posa. Na sawuno sägäpäsä dämpejiginy pädax na as de paye muxosuno tä ma. ");
INSERT INTO shj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saman Putros kox mänang, na kudukurusa tagä Yasuwa ngade ka, “Bazuwec, wede wangasa agä, xa anäs käxa sogo ngaka tasiny!” ");
INSERT INTO shj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Na todi Putros na känggi namang, kädongo tä menekä aski samendä mangeng. ");
INSERT INTO shj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yaxup na Yoxana enggä penggä Zapadi menggä wexed na Saman kädongo mändey. Na Yasuwa ngade ta Saman ka, “Wanga nyigatäg, xa gang na ur'dug gi layis me menekä kän.” ");
INSERT INTO shj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na kala sagoyas dämpejiginygäsa tä tungurtic, na sawangasa weg bägälic na sägäräbkädä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tä cuku Yasuwa tä nuxu kaxsä pandäng, apangandäng kawung täma wane kä'dod na omo. Mägox Yasuwa na mägunusawa täzäg mäzaye zäg na manyäxay Yasuwa ka, “Bazuwec, kä'dang mpayeng kax kusog wanag kalay apo.” ");
INSERT INTO shj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Yasuwa kälanga ande käpärä ma na ngade ka, “Agä ampaye asog gi lay mpo. Omo caya!” Na käccogos omo kaway tä wanäma. ");
INSERT INTO shj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na Yasuwa kä'dedey ma ka andakä mäläpe tä nuxu kig song. Na madästä me omo ka, “Wede koyi ngasägi ta me tämed tä Kaläg na koyi 'dogu tämekägi ndey mäduwalasa ka wanägi kälay apo, tä bangä asiriyenä Musa kadästäse nangang, ndey säbäle ka wanägi kälay apo.” ");
INSERT INTO shj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yä wadi lulungudu wexekä Yasuwa kawasasäwa käked na xä'däni kädängang kawuno tä dänggä ngakäma ndey Yasuwa däxä sa tä täxäkäsa. ");
INSERT INTO shj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ndä Yasuwa päledeswa tä owda kaculdoy xondaxonda watäke tä paley. ");
INSERT INTO shj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na xongenendäng Yasuwa bäldecce na Farisiny na menggä lelericcä asiriyenä Musa aki käpädäsäno tä Calil na tä Yaxudiya na tä Ursalimang käcasäng käsac, ndä panggudugku Kalägkang kasog Yasuwa däxä känang. ");
INSERT INTO shj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kulung apangas kawuno poko pudude tä salany. Säpaye ka sägoyas ma tax tagä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Neng sa'doxa ow kapäs, ndä owda sälangeyis ma undung na sa'dese tazä ax sawe ax ndä sälolas ma nang tax na salany tagä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yasuwa kox menekä ngakäsa täma, na ngade ta pudude ka, “Bisko, ngaka tasinygägi käcayino.” ");
INSERT INTO shj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na menggä lelericcä asiriyenä Musa na Farisiny käre tä ngastängga ka, “Apangza tiyanang degeje Kalägkang? Xänang caye ngaka tasiny tä kän basa Kalägkang?” ");
INSERT INTO shj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ani Yasuwa kabälenäs ngakäsagiyang, mäne sa ka, “Wi siye anggo makadang ngakong tä mäganygägong? ");
INSERT INTO shj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngakatiyag kädäppa ka xäxäminy ngadäningang, ‘Ani ka ngaka tasinygägi käcayining,’ wala ka, ‘Ngäsa tiyati wetäde’? ");
INSERT INTO shj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Asogo ngakong ndey bäleng ka agä, Päxä Käxa Jul panggudugkatäng tä andang täzäg layis näka anycayis ngaka tasiny.” Na Yasuwa ngade ta pudude ka, “Ngäsa tiyati poka salanygägi wede tä pa.” ");
INSERT INTO shj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na tetex mangäsa tagäsa tiyati na madeccäng salanygäma mägä'doc tä pa, mädädäxti Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na mäganygäsa kabalza na sägädongo, na sägädädäxti Kaläg tä ngaki kasogunong. Na kala sanyigata Kaläg, sängadeccä ka, “Was kanoxig ngaka tädäxiny xongondong.” ");
INSERT INTO shj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tä bangä ngakong Yasuwa kawetä tunyu na kox käxa age ka Lawi, säbängäs ma mändeng Mata, näs me yawgä tuluba käcca gixinicci taxä burkune. Na Yasuwa ngade täma ka, “Räbta agä.” ");
INSERT INTO shj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na mangäsa tiyati mawangasa weg kä'day mägä'doc tä bangä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Lawi kasog led tä pane ta Yasuwa, na kala xä'dä na menggä yawgä tulubada na kulung palangaski tängang, käcasäng sagur siyad nasa. ");
INSERT INTO shj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na Farisiny na menggä lelericcä asiriyenä Musa daweccä ta menggä räbkä Yasuwa ka, “Wi siye anggo darjangedänang na ziyaccang na wuxiccing na menggä yawgä tuluba na kängga sogo ngaka tasinyang?” ");
INSERT INTO shj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na Yasuwa kabuc ta Farisiny ka, “Känggi täxäccä songang paye me nayic song, basa känggi täxäccäng käcag paye me nayiccang. ");
INSERT INTO shj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Agä kawung tä bangakä känggi apoccung song, wadi kawung tä känggi sogo ngaka tasinyang ndey meley mäganyga.” ");
INSERT INTO shj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sängadeccä ta Yasuwa ka, “Menggä räbkä Yoxana mene uxkud todotol na palacca tä Kaläg, na mändey menggä räbkä Farisiny sogo mänang, yä menggä räbkägi kädil siyad na wuxid tol.” ");
INSERT INTO shj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na kala Yasuwa ngade täsa ka, “Kädäppa ka dogang palangaska kawuno tä batad ka men uxkud yä me batatandäng nang? ");
INSERT INTO shj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Musku xa ow wunodung säbate me batad täsa, ndä kala sälayenäs kängga mene uxkud.” ");
INSERT INTO shj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na sax mändey maser nga täsa ka, “Kigkandäng cerede nyonggo tä tandäna warändi ndä debede tä näka kaboxsu song. Käxa kasog mänangang kacere tandäni waränding, ndä nyonggoni waränding 'dasedäning na boxe song. ");
INSERT INTO shj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kigkandäng colada bux tä meldäna näs boxenendäng song. Käxa kacolas buxka warändi tä meldäna näs boxeneng, zage meldä na wanyisäwa. ");
INSERT INTO shj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wadi kädäppa ka buxka warändi säcolas tä kaxsä meldäna warändi. ");
INSERT INTO shj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ndä käxa kawux buxku boxinyganang paye buxka warändi song. 'Do ngade ka, ‘Buxku boxinyga apoccu na wizicci.’” ");
INSERT INTO shj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Xongenendäng Yasuwa kadus kaxsänggä pelow tä xongondu Sapid. Na menggä räbkä ma kabag zänggä kuny kapujuguy kasi. ");
INSERT INTO shj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na kulung Farisiny ngadeccä ka, “Wi siye anggo nyca'dadang asiriyenä Musa tä xongondu Sapitang?” ");
INSERT INTO shj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yasuwa kabuc täsa ka, “Anggo känggeneng ngaki Sorunu Kaläg lege tä ngakä Dawud na biskodage kasog tä xondi xas kapaxäsang song? ");
INSERT INTO shj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Masogkuwa key maläs axä burkunu tämed tä Kaläg de mägä'doc masi siyaki tedelinyang, yä asiriye ngade ka säsi säxong bal me tämed tä Kaläg watäkeneng, ndä madoga kulung tä enggä biskodagämang?” ");
INSERT INTO shj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na mängade täsa ka, “Agä Päxä Käxa Jul anäs bazuwec tä xongondu Sapid.” ");
INSERT INTO shj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yasuwa käläs axä paliccä Yaxudiny bäldecce tä nuxu xongondu Sapitandäng. Ndä apangandäng tänya axä owdi andä abanicce käxsä. ");
INSERT INTO shj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Menggä lelericcä asiriyenä Musa, na Farisiny jenggere Yasuwa käsac. Paye bäle ka cong Yasuwa däxäcci tä xongondu Sapitang, ndey ka sä'dox rakawza säglinäs nga täma. ");
INSERT INTO shj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ndä Yasuwa yex ngakäsagi sabokasa tä zänggäsang, na mängade tä 'doxti ande käxsängang ka, “Ngäsa tiyati dokala tä pidi todong.” Na todi mangäsa magädokol tänya owdi. ");
INSERT INTO shj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Yasuwa ngade täsa ka, “Ampaye amän anggo ka, apo ta asiriye ka wex ngaka apoccu wala ka wex ngaka tasiny tä xongondu Sapid, ka xony rongic wala ka wanydäs?” ");
INSERT INTO shj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na Yasuwa gaw ze käsaya sa na'anggäsa na ngade ta apangzi ande käxsäng ka, “Langi andägi.” Na apang kälanga ande na ande kaliy apo. ");
INSERT INTO shj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na ngaki mänangang kawaley mäganygäsa na sälegecce säbodo 'doga säsog ta Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Xongondi Yasuwa ka'deg cabär tä paley tängang, masäng kädayi tä paley tä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ow kagezä na mabandä menggä räbkäma madec kulung tä wara asiny wang pädax ndey mäligä. ");
INSERT INTO shj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Madeccäng känggong, Saman, ani sabangäs Putrosang, na päxä bona Andrawus, Yaxup, Yoxana, Filipus, na Partalmawus, ");
INSERT INTO shj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata, Toma, Yaxup päxä pe Xalafi, Saman ani sabangäs me mäganygä pädätägkang, ");
INSERT INTO shj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yaxuza päxä pe Yaxup, na Yaxuza Askariyuti ani kamenes Yasuwang. ");
INSERT INTO shj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yasuwa kawung täzäg na känggenegi kälägäng na mägädokol tä owda kädäpä. Na menggä räbkäma käyawesäno mange na kän bägälic kädurisäno käpätäsäno tä cabärä Yaxudiya na Ursalim na tä nyäxtä ndandangzä colonggonu Taya na Sayidun. Sawuno tä dänggä bäldiccäma Yasuwa na ndey ka mädäxäsa tä täxäkäsa. ");
INSERT INTO shj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na känggi ligitiga tasiny käco'deyang, kalaye käccag. ");
INSERT INTO shj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Xä'dä paye zegeleyi ma, xa panggudug päkätäsäng wanäma ndä mädäxä sa na'anggäsa. ");
INSERT INTO shj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na mägäza menggä räbkäma na mängade täsa ka, “Baxändäg ta anggogong widänangang, xa bugundugku Kaläg kunggog. ");
INSERT INTO shj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Baxändäg ta anggogong xas tanggo gangang, xa edekeny matasang. “Baxändäg ta anggogong ngecceng gangang, xa edekeny guguccing. ");
INSERT INTO shj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Baxändäg ta anggogong säsaxenggong, na sa'däda tunyang, na sälangeng, na säpexke kala kängga tasiny xa kämeneng ngakang, agä Päxä Käxa Julang! ");
INSERT INTO shj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ledining na zazanedicci tä xongondi ngakong kasoguning tanggong, xa dericcägo ngondey tä pang Kaläg tiyati. Xa wawanakäsagi kä'doccong kasog mänang tä menggä logey. ");
INSERT INTO shj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Woyoy ta anggogong male tanggong, xa anggo ka'doxang buduldugkugo na kä'deseng kala. ");
INSERT INTO shj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Woyoy ta anggogong kämasang gangang, xa edekeny xas lukudi paxe anggo. “Woyoy ta anggogong guguccing gangang, xa edekeny guniccing na ngecceng. ");
INSERT INTO shj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Woyoy ta anggogong kän kä'day lege ngaka apoccu tä ngakägong, xa wawanakäsagi kä'doccong mändey kasog mänang ta menggä logeygi celuwinyang.” ");
INSERT INTO shj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Na Yasuwa kapos legey ngade ka, “Ndä agä alegecce tanggogong, ndeldedeng wunggugong. Mpaya menggä kurugo, zoga ngaka apoccu tä känggi saxenggong. ");
INSERT INTO shj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pese känggi cage anggong, na palezi tä känggi cälixtinggong. ");
INSERT INTO shj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tä käxi 'dade abogiccäging, wexi cengicci kalayang täng 'dadä, na käxa bate tandänäging, togi nuxu ani biyeyang täng mändey. ");
INSERT INTO shj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kig kanyäxayging togi 'dogi payeng, ndä kig kabag 'dog täging, adakä naläng täng tunyu. ");
INSERT INTO shj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Koyada kän kala koyaki mpaye sägoydäs ging. ");
INSERT INTO shj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Gang mpayadang känggi paye anggong, oxadi 'doxadang tä bangeneng? Mändey känggi sogo ngaka tasinyang paye känggi payeng. ");
INSERT INTO shj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Gang zogadang ngaka apoccu tä känggi sogo ngaka apoccu tanggong, oxadiyang 'doxadang tä bangeneng? Mändey känggi sogo ngaka tasinyang sogo mänang. ");
INSERT INTO shj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ndä gang kämeneng amusu tä känggi yexeng ka meledäng tanggong, oxadiyang 'doxadang tä bangeneng? Mändey kängga sogo ngaka tasiny menede amusu tä kängga tasiny ndey mele täng kä'day. ");
INSERT INTO shj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wadi kädäppa ka mpayang menggä kurugo, na zogang ngaka apoccu täng, na meneng 'dog ndä bokosänang ka sämeleyäng tanggo song. Ndey dericcugo lay tädäx, na layisang enggä penggä Kalägi Tädäxang, xa mägaxsänya bow tä kängga mäganyga juliny na tä kängga logacca song. ");
INSERT INTO shj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Layesi kängga aga watäsa tä kän xa Menggoni Tiyating age watäsa tä kän.” ");
INSERT INTO shj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yasuwa ngade ka, “Wanga käligkä nga tä kän, andakä sägäling tanggo. Wanga zägkoygä kän, ndey säwang zägkoygä ko. Zaxi nga tä kän ndey säsaxäng nga tanggo. ");
INSERT INTO shj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Begsi ndey säbeg anggo. Kili 'dog appoyo, 'dixisa täzäg ndä ngädengädesa, ndä didili, ndey säduki tä satä ngorezägi. Tä kiligi gi gilingang sägilidäng tägi.” ");
INSERT INTO shj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na mändey maser nga täsa ka, “Käxa layis ngojox 'dosto ngojox song, kädäppa mänang? Pädaxkäsa sädelgetese taxä 'dog, säxong? ");
INSERT INTO shj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Me räb ngondey ta me bäldicce song, basa käxi sägäbäldey appoyong nyang laye kala me bäldicceneng. ");
INSERT INTO shj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Wi siye gi zaye nyaxic ta awunu päxä bonggo yä kä'diya sarakaduwecci ta awunuging? ");
INSERT INTO shj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Käsogkuwa key läpede tä päxä bonggo ka, ‘Päxä bisko, wanga agä anycay nyaxic ta awunugi’ yä kä'diya bo sarakaduwecci ta awunuging? Ama me fonofoney! Caya bo sarakaduwecci ta awunuging täzäläg ndey zayza käley ndä kala bokung nyaxicci ta awunu päxä bonggong tunyu.” ");
INSERT INTO shj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Eta apo iyedäng päxenena tas song, ndä mändey eta tas iyedäng päxenena apo song. ");
INSERT INTO shj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ewe kä'day bäletäsäning na enggengganagi iyedängang. Ewegä kunyu iyedäng enggä 'dami song, na adilu sete tä kenyegen song. ");
INSERT INTO shj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Käxa apong ngaka apoccu päkätäsäng mägaxse, yä käxa tas ngaka tasiny päkätäsäng mägaxse. Xa 'dogi mälegeng päkädäng mägaxsämani kapäsang.” ");
INSERT INTO shj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yasuwa ngade ka, “Wi siye anggo bangadang agä ka, ‘Bazuwec, Bazuwec,’ ndä wexedeng ngaki aläpedäng tanggo songang? ");
INSERT INTO shj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Käxa kawung tagä ndä delde wunde tä legeygang ndey wexse nangang, agä aläpede täng ka käxeneni ka'das ");
INSERT INTO shj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","apangza kadony pane kabosasa täzäg loy, ndä repesa kadasu täzä tappa. Faya kawung basa colonggo kämamanya tä pox de käbung pa, ndä kägä'dikiy pa song, xa kärepesawa appoyo. ");
INSERT INTO shj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yä käxa dänge ngakang ndä wexe songang, käxeneni ka'das apangza kadony pane täzäg winy kabosasa kadasu säxong. Ndä colonggo kapäs käsajä pane, na kagurumusawa tetex na kawanydäswa seley!” ");
INSERT INTO shj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ani Yasuwa kä'desenäs bäldeyge kä'day tä känang, maläsa Kafärnaxum. ");
INSERT INTO shj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ndä ngotorponu asägarugu Romanandäng tänya owdi paye cäläxse nano, ndä nya cäläxsämani täxä paccey paye äxsä. ");
INSERT INTO shj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ani ngotorpo kädängäs ka Yasuwa kawunäsang, mayaxsä ngondowinygä Yaxudiny ta Yasuwa, ka säbandä ma mäwung, ndey mänay cäläxsä ngotorpo. ");
INSERT INTO shj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sawuno ta Yasuwa, na sägä'dedey ma ka, “Wede xonya ngotorpo xa mang mägädäppas xonyatang, ");
INSERT INTO shj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","xa mäpaye känggä Yaxudiny, na mändey madony axä palic.” ");
INSERT INTO shj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na todi Yasuwa kä'doc nasa. Ani sägä'docconäs ngäte tä pang, ngotorpo kayxsa aminuge kaläpe täma ka, “Bazuwec, wanga dereygä ngasägi xa kandäppas ka gi wung tä panang song. ");
INSERT INTO shj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nyang kasog asaxe wunad tägingang. Ndä gang ngadi winy ndey cäläxsang 'dox nayic. ");
INSERT INTO shj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndä agä mändey anäs käxa panggudug tä ande kamen asägaru, ndä kangada tä nuxu ka, ‘Wedeng’ na 'docco, na tä nuxung ka, ‘Bong’ na wunodung, na tä cäläxsang ka, ‘Wexe 'dogongang,’ na wexe 'dogeneni.” ");
INSERT INTO shj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ani Yasuwa kädängäs ngakongang, ma'dämdes ngakäma. Na mawexwa mängade tä xä'däni räbtomang ka, “Aläpedäng tanggo ka tä Israyil bägälic ka'dox käxa kamen ngakang ka'das 'doxtongandäng song!” ");
INSERT INTO shj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na kala känggi sayaxsäng, kämele tä pa ka'doxäng cäläx kalay apo. ");
INSERT INTO shj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kala tetex Yasuwa kä'doc tä kaxsä pana säbangäs Nayin. Na menggä räbkäma Yasuwa na xä'dä kä'docco nama. ");
INSERT INTO shj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sawuno saläs kaxsä pa, na sa'doxung apangandäng käxsä kän käpokung tunyu, ndä nyang nuxundugke ta bona ndä cäs mandur, ndä känatäng nace mange. ");
INSERT INTO shj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bazuwec kox ce, na agäma kawasa täce na mängade täce ka, “Wanga ngeyig.” ");
INSERT INTO shj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na mawung mägäläbä salany, na nycogi pokaccangang kädokalasa kisid. Na mängade ka, “Päxä op, angade tägi ka, ngäsa tiyati!” ");
INSERT INTO shj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na päxä opi käxsängang kangäsa tiyati na kalegese, na Yasuwa kämeles ma ta bosa. ");
INSERT INTO shj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na sägädongo kä'daygäsa, na sadelese tä dädäxtigä Kaläg, sängadeccä ka, “Me logeyga tädäxandäng tä warog!” na, “Kaläg kawung tä posakä kängge!” ");
INSERT INTO shj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na todi lulungudä Yasuwa kawasasäwa tä Yaxudiya na tä cendegä walangic kä'day. ");
INSERT INTO shj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Menggä räbkä Yoxana kaläpe ngaki kä'day Yasuwa kasogkang ta Yoxana. Na Yoxana kabandä menggä räbke pädax ");
INSERT INTO shj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na mayaxsa sa ka sägä'docco sämän Yasuwa ka, “Giningang näs käxi kän beneng, wala basa abendig käxa caka?” ");
INSERT INTO shj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ani apanginy kawunonäs ta Yasuwang, sängadeccä ka, “Yoxana me pac kayaxsä was tä gining ka amänzig ka, ‘Giningang näs käxi kän beneng, wala basa abendig käxa caka?’” ");
INSERT INTO shj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na tä nya owdi Yasuwa kädäxä kän mange tä däxäka cakucakuny na mägäcay ligitiga tasiny tä wadäkä kän na malende agä ngojony. ");
INSERT INTO shj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na mabuc täsa ka, “Wesi lapi ta Yoxana tä 'dogi känoxangang na kändängengang. Ka ngojony käsayiza, mexesu kewetädäcco kiccag, na menggä omoda wadägka kalaye apoccu, na bunguny kädängze, na kängga käxse koxsasa, na menggä wiy kädäng duwaleyga warändi. ");
INSERT INTO shj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baxändäg tä käxi base mägaxse tagä songang.” ");
INSERT INTO shj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ani menggä yaxsäweccä Yoxana kä'docconäsang, Yasuwa kalegese tä ngakä Yoxana tä xä'dä ka, “Oxadi kasog anggo känoccang tä pumpung tä zaygeneng? Päx känoxang mege zäwande nyaxic? A'a! ");
INSERT INTO shj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Neng oxadiyang känoc tunyu tä zaygeneng? Apangza kälagäwa na tandäna duladulaje? A'a! Za, känggi lage tanduga duladulajeccäng, käcag tol cuccu tä owdu buguninginyang! ");
INSERT INTO shj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Oxadiyang känoccang tunyu tä zaygeneng? Me logey? E, neng aläpedäng tanggo ka ma mäs me logeyga tädäx tä menggä logey. ");
INSERT INTO shj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngakongag gärekärejesäno tämang, ‘Lala, ayaxsada me yaxasawiccang tagägi, ani 'docco weye akäsog ndä kala noccang.’ ");
INSERT INTO shj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aläpedäng tanggo ka, känggong sägiyängang käxa tädäx kala Yoxanandäng song. yä käxi biyey tä bugundugku Kalägkang tädäx täma.” ");
INSERT INTO shj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ani kän kä'day kädängäs ngaki Yasuwa kangatang, na mändey menggä yawgä tulubada, kagixi däppiccä Kaläg, xa Yoxana käpaccä sa. ");
INSERT INTO shj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ndä mändey Farisiny na menggä lelericcä asiriyenä Musa käpexkä ngaki Kaläg kabokasa täsang, xa Yoxana käpaccä sa song. ");
INSERT INTO shj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yasuwa ngade ka, “Oxadi andäppo na känggä zongang, na sa sa'das wi? ");
INSERT INTO shj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sa sa'das pipuga käcasäno ta axä owdu wanyäg ndä bangedäning, ‘Was kanusig ndetelegu tanggo ndä anggo kocoxsang song, kangeyig ndä aguniccig ndä anggo kängeydäcceng song.’ ");
INSERT INTO shj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Yoxana me Pac kawung ndä kalägäji ndä mäwuxi bux song. Ndä ngadaccang ka märamacca! ");
INSERT INTO shj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yä agänang Päxä Käxa Jul kawung asiyacca na awuxicci, ndä anggo ngadaccang ka, ‘Za, päxä me kurugurunong na wuxicci de bux paxeng mäs biskonu menggä yawgä tulubada na kängga tasiny!’ ");
INSERT INTO shj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Zänggä ngakä lelertäg bäledeswa na cofu'do'dugku logadä menggä räbke.” ");
INSERT INTO shj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nuxu Farisiccandäng säbangäs Saman kabandä Yasuwa ka säsiyza nang tä pane, na mägä'doc tä pang Farisic na sägä'docco sagur siyad. ");
INSERT INTO shj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ndä uxandäng tä nya kaxsä pani, sogo ngaka tasiny, cabäle ka Yasuwandäng tä pang Farisic, na cawung cägo midä mäxäs tä belenyza sadotogey sägäluxu tä ngayicca säbangäs alpasta. ");
INSERT INTO shj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na cägä'doc täwang badadagäma, cänge, ndä cädälbede uxku agäce tä exenggäma. Ndä cäsenye exenggäma na apaxkäce, na mändey cägäbucci exenggäma, ndä cawawe exenggäma na midä mäxäs. ");
INSERT INTO shj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisicci kabandä mang kox ngaki, na ngade tä ngase ka, “Kä'dang apangzong layis me logey seleyang, kax mabäle ka uxong läbe mang näka sogo ngaka tasinyang.” ");
INSERT INTO shj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Yasuwa kabuc täma ka, “Saman, ampaye aläpäng nuxu 'dog tägi.” Na mabuc ka, “Lapäng, me bäldic.” ");
INSERT INTO shj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na Yasuwa ngade ka, “Me menekä amusundäng kamene amusudi ta kän pädax. Nuxu kamen fudada udiny mädäginy mädäg (500), mändey käxi nuxungang kamen udiny pädax wang asiny (50). ");
INSERT INTO shj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ani sägämelenäs wegki samen täma songang, masaxa wegki samen tämang kä'day. Pädaxkäsa xänang täsa kädäppa ka paye ma mo'do accanang?” ");
INSERT INTO shj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saman kabuc ka, “Ka'das ka kädäppa ka käxi kamen amusu mangeng, nyaza.” Na Yasuwa ngade täma ka, “Mänang gi seley kälegey zänggä nga.” ");
INSERT INTO shj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na mawexwa mägäsay ce, na mängade tä Saman ka, “Gining noxo uxong? Agänang käläs panägi. Kudong magä 'dakä exenggang song, yä ce ca'day exenggang na uxku agäce ndä casenydä na apaxkä zäce. ");
INSERT INTO shj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kämpaxäng agä na modey na kägappas agä song, yä ani kaläsäs panäging cägädokala bucigä exenggang song. ");
INSERT INTO shj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Käwawey zang na mid song, yä ce cawawey exenggang na midä mäxäs. ");
INSERT INTO shj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Neng aläpedäng tägi ka ngaka tasinygäcegi mangeng kawangesäno täce ndä nyang cäpaye pacceyang. Yä käxi sasaxa täng bälaxinyang, paye bälaxiny.” ");
INSERT INTO shj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na Yasuwa ngade täce ka, “Ngaka tasinygägi käcayining tägi.” ");
INSERT INTO shj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndä palangaski kagur siyad namang käre tä zängga ka, “Xänanang kanang mändey caye ngaka tasinygä tä känang?” ");
INSERT INTO shj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Yasuwa ngade tä ux ka, “Menekä ngakägi tagä kaxony gi. Wede na modey.” ");
INSERT INTO shj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Täbangä ngakongang, Yasuwa kadadara kaxsä pa na madus enggä cabärta mäbäldecce na mälogo yaxsäwecca apo tä bugundugku Kaläg. Känggämagi mägälägä asiny wang pädaxang satäng nama, ");
INSERT INTO shj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na mändey sag na kulung uxugi mägänay tä ligitiga tasinyang na tä däxäkanang. Mariyomzi säbangäs Macidaliya ani samagäng kängga tasiny paxtänding tunyu tä waneneng, ");
INSERT INTO shj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Xana uxu Cuza, ani kamen wexekä pang buguning Xirudusang, na Sosana na kulung kän mange kälarta wegkanagi layis käkä ngastängganang täsa. ");
INSERT INTO shj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kän kawuno ta Yasuwa käpätäsäno tä kaxsänggä padägka cakucakuny na xä'dä kädurisäwa, na malegeyze täsa näs seredänic. ");
INSERT INTO shj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mängade ka, “Me zäb kawetä kä'doc tä wasakä yugke ndä kulung kawosasa tä kaxsä akäsog na kän kebtesa, na awiny kaleb kulung. ");
INSERT INTO shj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kulung yug kawosasa tä cobocoboric, na ani kalocconäsang kamasasa xa nyigidiccandäng song. ");
INSERT INTO shj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kulung yug kawosasa tä warä kunyu na kalocco appoyo ndä kunyu räbta. ");
INSERT INTO shj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mändey aki kawosasa tä zägka apoccung kalocco na ka'dongasa appoyo, na kiye kiccag zä kuc nuxung age kasog udiny mädäg (100) taxä mange.” Na mängade ka ngakong ngadeccä ka, “Käxa wunde dängecceng, däng ngakong!” ");
INSERT INTO shj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na menggä räbkä ma kamän ma ka seredäniccong näkä wiyang. ");
INSERT INTO shj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na Yasuwa ngade ka, “Anggo nyadogung akäsog tanggo ndey bäleseng bodakä bugundugku Kaläg. Yä tä kulung kän agä alegecce täng na seredänic, ndey kax sälale na oxuswa pele winy, ndä kax sädänge na säbälede 'dogeneni song. ");
INSERT INTO shj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ndä gang seredäniccong bangeneng ka, yugkag näs ngakä Kalägkang. ");
INSERT INTO shj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yugki kawoso tä akäsogkang sag näs känggi dänge nga na zeppe tetexang, na Däniye wunodung bate nga tä mäganyga ndey ndakä men ngakä Kaläg ndä 'dox xonyad. ");
INSERT INTO shj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yugki kawosasa tä cobocoboriccang sag näs känggi dänge nga na bate na led, ndä mäxkanatäng song. Mene käccogos, ndä ngaka bedeccä kawunong na zalbangada. ");
INSERT INTO shj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mändey yugki kawosasa tä warä kunyuwang, sag näs känggi dänge nga ndä kä'docco tunyang 'doxada ngakä kanyakanyanä cabär na ngakä Kalägi samenang 'dongatasa song. ");
INSERT INTO shj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yä yugki kawosasa tä zägki apoccu ndä loccong, sag näs känggi dänge nga na mene pädäte tä mäganyganagi bowinyang na tegetese sogo yugic. ");
INSERT INTO shj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kigkandäng banye masäracane ndä xubu song na suxuludi tä boxu salany song. Basa bokasa tä zä tumu ndey känggi luso axang ox owda bow. ");
INSERT INTO shj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'Dogi kabodwang paredäwa tunyu na 'dogi ka'danywang wedäwa tunyu tä owda bow. ");
INSERT INTO shj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ndelde wunggugo appoyo. Käxa 'doge tängang säposo täng, ndä käxa oxo ka 'doge täng yä wundungang, säbate täng.” ");
INSERT INTO shj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Enggä bonggu Yasuwanag na bosa kawuno täma, ndä kä'docco täma ngäte song xa xä'dä käsekä sa. ");
INSERT INTO shj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na saläpe täma ka, “Enggä bonggugo na bonggo satäng tunyu paye zay gi.” ");
INSERT INTO shj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na mägämeley täsa ka, “Ngganang na enggä bonggusko sag näs känggi dänge ngakä Kaläg na wexeng.” ");
INSERT INTO shj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Xongenendäng Yasuwa kä'doc tä kaxsä dämpejig na menggä räbke na mängade täsa ka, “Nycugo agali andi tagä colonggo.” Na sägä'docco tunyu. ");
INSERT INTO shj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ani säwadaccanäs na dämpejigkang Yasuwa kasändä. Na megede kasagesäng tädäxtiny täsa tä colonggo na dämpejig soro päsed na ma, ndä paye mäxasa tä ma nasa. ");
INSERT INTO shj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na sägänoxsas ma sängadeccä täma ka, “Bazuwec, bazuwec, kogkatäng täzänggä xäs!” Na mägoxsa na madux megede, na dampajeygä ma kädokalasa na kasebesäno. ");
INSERT INTO shj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na mängade täsa ka, “Wi siye anggo menedeng ngakang songang?” Na nyigadäg kamen sa na sägäsaydä agäsa na samänäno ka, “Xänanang kanang? Rejede megede na ma na dänge ngakeneng!” ");
INSERT INTO shj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yasuwa na menggä räbke käca'dä ma na dämpejig kä'docco tä cabärä Gäresa tä xining tagä Calil. ");
INSERT INTO shj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ani Yasuwa kebesanäs exene tä ndandangang, 'doxtiyandäng näs me nya cabäri käpasa täma kängga tasinyatäng tä wane. Ndä kaleygädä kälagä tandä song ndä uccu tä pa song basa tä warä morota. ");
INSERT INTO shj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na mägox Yasuwa na mapere, madeläng täzäg tagä Yasuwa na mägädawa paccey ka, “Oxadi tägog tä pidi naging Yasuwa, Päxä Kalägi Tiyating! Kanyixay gi ka ndakä nycälixti agä!” ");
INSERT INTO shj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mängade tä Yasuwa mänang xa Yasuwa kadux käxa tasti tä wanämang ka wetä tunyu tä wanäma. Ndä nyacotädasa ma taxä mange, ndä kän cäkili exenggäma na asänggäma na kacägaliny ndä meske ma. Neng mä'dexe ndä käxa tasti tä wanämang koyadas ma tä owda kaculdoy. ");
INSERT INTO shj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yasuwa kamän ma ka, “Säbängäs gi xäng?” Na mängade ka, “Säbangäs agä Katiba” xa kängga tasiny mangeccä tä wanäma. ");
INSERT INTO shj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na kängga tasiny käpaydä ta Yasuwa ka ndakä yaxsas sa tä owdi sägäpätäsuno tängang. ");
INSERT INTO shj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ndä buduruginyatäng mange siyacca tiyati tä päxä cobocoboric na kängga tasiny käpay Yasuwa ka mädokas sa tä wadäkä buduruginy ndey ka sä'docco nang na mägä'dakas sa täng. ");
INSERT INTO shj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na kängga tasiny kawetäcco täwang apangzi kä'docco tä buduruginygi mangeng, na kasog buduruginy kawu'daka colonggo kamäxasa tä zäg. ");
INSERT INTO shj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Menggä megäskä buduruginy kox 'dogi kasogkuwang na koyo kawasesäning kä'docco käduwaley tä kaxsä pa na tä enggä cabärta. ");
INSERT INTO shj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na kän kawetäcco paye zay 'dogi kasogkuwang, na sawuno ta Yasuwa. Sa'doxa nya apangzi kängga tasiny kawetäcco tä waneneng, ze kalay appoyo, kälagäwa na tandu na kä'doc käcca tä warä exenggä Yasuwa na kän kalaye nyägadiny. ");
INSERT INTO shj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Känggi kox 'dogi kasogkuwang ta apangzi kängga tasiny kawetäcco tä waneneng, kaläpe tä känggi kox songang. ");
INSERT INTO shj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na kala menggä Gäresa kä'day na känggi kakukury cabär kä'dayang käpay Yasuwa ka 'doc wangasa sa xa nyigatäg kadele sa. Na Yasuwa ka'deg dämpejigse ka 'doco, ");
INSERT INTO shj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","na nya apangzi mägäcay kängga tasiny tängang käpay ka sä'docco nang, neng Yasuwa kayaxsas ma tä pa. ");
INSERT INTO shj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Läpede täma ka, “Mele wede tä panägo na pari ngaki Kaläg kasog täging.” Na mägä'doc mägäduwaley tä kaxsä pa tä 'dogi Yasuwa kasog tämang. ");
INSERT INTO shj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yasuwa kämel tä Calil na xä'dä käpaxas ma xa satäng tä benggä ma. ");
INSERT INTO shj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ndä apangandäng säbangäs Yayurus näs ngondow kamen axä paliccä Yaxudiny kä'doc kudukurusa tä warä exenggä Yasuwa, käpay ma ka sä'docco nang tä pane, ");
INSERT INTO shj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","xa penämandäng nuxung layis päxä ux jendägke asiny wang pädax paye äxsä. Yasuwa kamen akäsog, na xä'dä kagur ma de bungu ma. ");
INSERT INTO shj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ndä uxandäng tä warä xä'dä tamicce colowa tä jendägka asiny wang pädax ndä käxa däxändäng song. ");
INSERT INTO shj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Cawung tä ongu Yasuwa ndä cäpärä munu tandänäma, na tetex waxäd kädokalasa. ");
INSERT INTO shj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Yasuwa kamänze ka, “Xänang käpärä agäng?” Na kän kä'day kagil, na Putros kabuc ta Yasuwa ka, “Bazuwec, xä'dänong kä'day kagur gi ndä bungu gi!” ");
INSERT INTO shj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Neng Yasuwa ngade ka, “Agä kabäle ka kigkandäng käpärä agä xa panggudug kawetäcce tä wanang.” ");
INSERT INTO shj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na ce uxi cabäle ka cä'danyewa song na caparängwa tunyu na cawung cädätägä cadeläng ta agäma. Na caläpe 'dogi kasog cägäpärä Yasuwang na däxki tetex kasoguno täceng tagä xä'däni kä'day. ");
INSERT INTO shj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na Yasuwa ngade täce ka, “Penang, menekä ngakägi tagä känay gi. Wede na modey.” ");
INSERT INTO shj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ani musku mälegeccenäsang, nuxu kigkandäng käpätäng pang Yayurus kawung ngade ta Yayurus ka, “Päxä penägi käxsä, wanga dereygä me bäldic winy.” ");
INSERT INTO shj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yasuwa kädäng ngaki na maläpe ta Yayurus ka, “Wanga kärekä nga, yä mene ngakang winy, xa coxsada.” ");
INSERT INTO shj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ani Yasuwa käcogus pang Yayurusang, mawang kän kaläs ax nama song basa Putros, Yoxana, Yaxup, Yayurus na uxe. ");
INSERT INTO shj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na'anggäsagi tä pang ngeyigkang sängeccä na sägunuccu tä ngakä ce, neng Yasuwa kawung ngade täsa ka, “Wanga ngeyig xa cägäxsä song casändä winy.” ");
INSERT INTO shj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na sagug ma, xa säyex beyin ka cägäxsä. ");
INSERT INTO shj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na Yasuwa kamen andäce na ngade täce ka, “Päxä ux, ngäsa tiyati.” ");
INSERT INTO shj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na ronguccäce kämel, na tetex cangäsa. Na maläpe täsa ka sädoga nuxu 'dog täce cäsi. ");
INSERT INTO shj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Menggäsa kädongo tä ngaki mänang. Na mägä'dedeyza ka ndakä säläpe 'dogi kasogkuwang tä nuxu kig. ");
INSERT INTO shj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yasuwa kuduri känggi mägäligä asiny wang pädaxang, na madoga panggudug täng kä'dayga na butug ndey layenäs kängga makadas kängga tasiny tunyu na däxi kän ");
INSERT INTO shj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","na mayaxsa sa ndey ka säduwaley bugundugku Kaläg na sädäxä känggi täxäccäng. ");
INSERT INTO shj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mäläpede täsa ka, “Ndakä seley bagang nuxu 'dog nanggo tä wedäg song, kala keced na 'dogu pokakä tandu, na siyad na ariyaliny, na ndakä bagang tandu nanggo. ");
INSERT INTO shj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndä pani käläsangang, nycicci täng basa xongondi wangetäsänang kaxsä pa tängang. ");
INSERT INTO shj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kaxsä pana känoccang täng kängge kabokasa anggo songang, ndä mpadang wangesänang kaxsä pang, 'diskisining käräptänicci ta exenggägong ndey layis ngakä ngastänggäsa ka känoccang ndä sagixi yaxsuwiccä Kaläg song.” ");
INSERT INTO shj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na samen sog sägä'docco sadus kaxsä pa säduwale yaxsäwecci apo lege ngakä Kalägkang na sädäxä kän tä ota bägälic. ");
INSERT INTO shj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Buguning Xirudus kädäng ngaki kä'day kasogäningang tä wexekä Yasuwang, na zäma kaxsäwa paccey xa kulung kän ngadeccä ka käxong kanang ndakä layis Yoxana me Pac kangäsa tä xäs, ");
INSERT INTO shj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ndä kulung kän ngadeccä ka acaka layis me logey Iliya nyaza kaparaswa täsa. Ndä musku kulung kän lege ka mänang nuxu me logeyga waneng kangäsa. ");
INSERT INTO shj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xirudus ngade ka, “Kaluwi zä Yoxana tä pox yä mändey xänanang kalugsi sälege ngakeneng?” Na Xirudus kasäkesawa paye ox Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Känggi Yasuwa kälägäng kämele, na saläpe ngaki kä'day sawexang ta Yasuwa. Na mabag sa sägä'docco sapälesäning säpaxadas bo pana säbangäs Petsayida. ");
INSERT INTO shj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Neng xä'dä kapungung owduma na käräbkädä ma. Na mabokasa sa ndä mälegey sa na ngakä butugku Kaläg na mägädäxä känggi paye däxang. ");
INSERT INTO shj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Xong paye 'däng, na känggi mägälägä asiny wang pädaxang kawuno ngadeccä täma ka, “ 'Daki xä'dänong, ndey 'docco täwang kaxsä pa ndey 'dox owdu säng na siyad, xa kogkatäng tä owda kaculdoy.” ");
INSERT INTO shj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Neng Yasuwa kämeley täsa ka, “Anggo dogi siyad täsa.” Na sabuc täma ka, “Siyatatäng layis käka kätäx song basa raxifiny mädäg na as pädax tol. Basa anoccig anganyig siyad tä känggong kä'dayakang.” ");
INSERT INTO shj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sangad ngakong xa apanginyatäng päsäciny mädäg (5,000) tä warä xä'dä. Na Yasuwa läpede tä menggä räbke ka, “Wanga sa säccasäno tä ud taxä udiny pädax wang asiny (50).” ");
INSERT INTO shj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na sasog kala ngaki maläpasang. Na kän kä'day käcasäng täzäg. ");
INSERT INTO shj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na mabag raxifinygi mädägkang na aski pädaxang na mägäsa tiyati na malog Kaläg ndä mälarä siyad mädoga ta menggä räbkäma ka sälarta tä xä'dä. ");
INSERT INTO shj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kä'daygäsa sasiza samasa, na ani kalayang sanyaptä landa asiny wang pädax. ");
INSERT INTO shj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Xongenendäng Yasuwa kangäsa kä'doc palacca watägke, ndä menggä räbkämatäng nama na mamän sa ka, “Kän ngadeccä ka agä anäs xäng?” ");
INSERT INTO shj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na sa sabuc täma ka, “Näs Yoxana me Pac, kulung kän ngadeccä ka me logey Iliya, na musku kulung kän ngadeccä ka nuxus menggä logeygi wane käxseng nuxungang kangäsa.” ");
INSERT INTO shj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na mängade täsa ka, “Yä anggo ngadaccang ka agä anäs xäng?” Na Putros kabuc ka, “Almasini Kaläg kayaxsängang.” ");
INSERT INTO shj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na madästä sa seley ka ndakä säläpe tä nuxu kig song, ");
INSERT INTO shj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","mängade ka, “Agä, Päxä Käxa Jul anycäläxtiwa tä nga mange, ndä ngondowiny na bazuwinygä tämed tä Kaläg na menggä lelericcä asiriyenä Musa pexke agä, na säpaxe agä ndä tä sängga kodos angäsata tä xäs.” ");
INSERT INTO shj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yasuwa ngade tä kän kä'day ka, “Käxi paye ndey layis me räbkangang basa 'diya ngakä ngase ndä poko kalic todotol na räbkädä bangang. ");
INSERT INTO shj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xa käxi paye ka xony rongicce täzäg tä ngakä ngaseneng, mesede yä käxi paye mese rongicce täzäg tä ngakangang 'doxo aygä lili. ");
INSERT INTO shj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oxadi kig 'doxo tä bangä tangandäg tä walangic kä'day yä edekeny mese rongicceneng? ");
INSERT INTO shj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Käxa ze maye tä agä na tä legeygangang, Agä, Päxä Käxa Jul alayis käxa ze maye täng tä xongondi awunodung täng tä xongondu dädäxticcang na tä dädäxticcä Appa na malayikadagi tedelinyang. ");
INSERT INTO shj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndä gang seley aläpedäng tanggo ka, kulung känatäng tä warägo äxseccä song basa ox bugundugku Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yasuwa käbäldeyze ndä mäsäng tespedespe, na mabag Putros na Yoxana na Yaxup sägä'docco tä zä cabär tä paley. ");
INSERT INTO shj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yasuwa palacca na toccäma kalay caka na tanduguma wuxeccä, ndä dulatulajeccä bowiny. ");
INSERT INTO shj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na apangas pädax kaweyesäno kadeb legey nama, apangaskenegi menggä logeyag, Musang na Iliya. ");
INSERT INTO shj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sägaleza na tädäxtic dulatulaje na salegeyze na Yasuwa tä ngakä melgäma tiyati ka mä'doc tä Ursalim ndey ngaki Kaläg kangatang 'desesäning täng. ");
INSERT INTO shj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndä Putros na känggi nangang kasändäcco, na sägoxsasa na agäsa käyer na sägox tädäxticcäma na apanginy pädax dokoloccu nama. ");
INSERT INTO shj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na apanginygi pädaxang kamen sog, na Putros ngade ta Yasuwa ka, “Bazuwec, wunakog todong apoccu. Nycugo abola telegudi kodos, nuxu tägi, nuxu ta me logey Musa na nuxu ta me logey Iliya.” Xa mabäle 'dogi mälegeng song. ");
INSERT INTO shj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ani mälegeyis ngakongang timinggaric kawung kaxub sa, na salaye sänyigadiny. ");
INSERT INTO shj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na sägädäng ngasäwan tä kaxsä timinggaric ka, “Päxä penanggong nyang kaderesang, ndänge ngake!” ");
INSERT INTO shj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ani ngasäwan kalegezenäsang, Yasuwa ka'doxuwa watäke. Na sägämolosäning saläja 'dogi sägoxang tä nuxu kig song basa xongonda caka. ");
INSERT INTO shj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Edekenydeneni sacoccoleza na zä cabär na xä'dä käpasasa täma. ");
INSERT INTO shj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na nuxu apangandäng tä warä xä'dä kabandäsa ka, “Me bäldic, kanyäxay gi ka xony penang xa nyang nuxu tagä tolang! ");
INSERT INTO shj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ligida tas teldedes ma na sogo ma mädawe ndä nyäpapaxe ma na sogo guxudunic päkädäng ikäma ndä wange ma mänungu song, cäläxti ma nano. ");
INSERT INTO shj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndä kampay tä menggä räbkägi ka cay ligida tas tä wanäma ndä kadeges sa.” ");
INSERT INTO shj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na Yasuwa kabuc ka, “Anggo menggä zong menekä ngakägo bedeccä ndä näsang menggä sogo ngaka tasiny! Alayde nanggo ka'das wi dexä ampanye ngakägong? Koying päxä penägi todong.” ");
INSERT INTO shj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sagoying päxä pipi ngäte ta Yasuwa na ligida tas kacodasa pipi täzäg pappaxe. Na Yasuwa kadux ligida tas, na kala Yasuwa känay päxä pipi na kämeles ta mena. ");
INSERT INTO shj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na todi kän kädongo tä panggudugku Kalägi mänangang. Na todi xä'dä kä'day käledäning tä 'dogi Yasuwa wexeng, na Yasuwa ngade tä menggä räbke ka, ");
INSERT INTO shj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mene legeygong tä mäganygägo, xa agä Päxä Käxa Jul sä'doc sämenedes agä ta asänggä menggä kurang.” ");
INSERT INTO shj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ndä sa sabäle legeygi malegeyag song, xa bange ka'danywa täsa ndey ka ndakä säbäle. Ndä sänyigate mänekä ma tä legeygi mägälajängang. ");
INSERT INTO shj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na kala matakä nga kadebäning tä warä menggä räbkä Yasuwa ka xänang täsa ngake tädäxiny mo'do acängganang. ");
INSERT INTO shj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Neng Yasuwa kabäle ngaki sabokasa tä mäganygäsa, na mabag päxä pipi mägätokalasa tä wanäma. ");
INSERT INTO shj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na malegeyze täsa ka, “Käxi paye päxä päxkunong na agangang, paye agä. Ndä käxi paye agäng, paye Kalägi kayaxsä agäng. Xa käxi biyey tä warägo kä'daygägong, nyang ngake tädäxiny mo'do acängganang.” ");
INSERT INTO shj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoxana kabuc ta Yasuwa ka, “Bazuwec, ka'doxig nuxu kigkandäng caye kängga tasiny tä wadäkä kän na agägi, ndä wa kampayedig ka andokoleyig ma xa mäs me räb na was song.” ");
INSERT INTO shj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Neng Yasuwa ngade täma ka, “Wanga dokoleygä ma, xa käxi näs me kurog säxongang biskonogkang.” ");
INSERT INTO shj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sänggä Yasuwa kalaye bälaxiny ndey ka Kaläg bag ma tiyati, na mägädiri Ursalim. ");
INSERT INTO shj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na todi Yasuwa kayaxsa menggä yaxsäwec kapäccasa tagäma, na sägäcogä ow, na saläs kaxsä pang menggä Samriya ndey säbolasa ow täma. ");
INSERT INTO shj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Neng menggä kaxsä pa kabäle ka Yasuwa 'do tä Ursalim, na sägäsekä ma. ");
INSERT INTO shj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ani Yaxup na Yoxana menggä räbkä Yasuwa koxäs mänangang, sängadeccä ka, “Bazuwec, mpaye was abandig masä Kaläg täzä koxa ndey tuny nycokong kä'day?” ");
INSERT INTO shj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Neng Yasuwa kawexeswa täsa na kadux sa, ");
INSERT INTO shj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","na sawetädese tä kaxsä pana caka. ");
INSERT INTO shj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tä zänggä wedäkäsa ta akäsog, nuxu accäsa kangad täma ka, “Agä a'dorto banggi todi noco tängang.” ");
INSERT INTO shj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Na Yasuwa ngade täma ka, “Atorndoru axinygä kudufuganatäng na awiny axinyganatäng, yä agänang Päxä Käxa Jul panangandäng song.” ");
INSERT INTO shj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mändey Yasuwa ngade tä nuxu accäsa ka, “ 'Dorkäda agä.” Neng kämeley täma ka, “Bazuwec, wanga agä accig anoc abosu appanang.” ");
INSERT INTO shj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Neng Yasuwa ngade täma ka, “Wanga känggi käxseng bosu kängganagi käxseng, yä gi wede duwala bugundugku Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na nuxu accäsa kasan ngade ka, “Agänang a'dorto gi, Bazuwec, neng bende agä accigäne anoc angada tä menggä panang.” ");
INSERT INTO shj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Yasuwa ngade täma ka, “Käxa seley danada ande tä sicci ndä gawada ze tongang kädäppa bugundugku Kaläg song.” ");
INSERT INTO shj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yasuwa kayaxsa menggä räbke udiny kodos wang asiny wang pädax (72) ka päccasa pädapädax tagäma tä bonggu padäg na tä otagi kä'day ma Yasuwa mäpaye mä'doc tängang. ");
INSERT INTO shj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mängade täsa ka, “Jeded mangeccä yä wadi menggä wexed bälaxiny. Neng gang mäne Bazuweccä jeded ndey yaxsäng menggä wexed tä jeded. ");
INSERT INTO shj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Wesi! Ayaxsadas anggo tunyu ka'das sagunuga luluduwiny käraka tä pidi. ");
INSERT INTO shj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ndakä bagang ariyaliny mange, na mändey meldänä wedäg, na 'dataginy axinyga pädax, na ndakä galedetäsänang tä kän ta akäsog song. ");
INSERT INTO shj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Känoxang käläsang pang, päcci ngada ka, ‘Wanga modeygä Kaläg laye tä panong!’ ");
INSERT INTO shj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ndä käxa mägaxse paye modey tä owdiyang, modey layeccä täng, yä wundungang modeygägo layeccä täsa song. ");
INSERT INTO shj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nycicci tä nya pani ziya na wuxi siyaki sadogung tanggong, xa me wexed kädäppa ka sädoga dericce. Wanga 'däla'dälangey tä padäg winy. ");
INSERT INTO shj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Känoxang käläsang bo pang, ndä kän kabokasa anggong, ziya 'dogi säguxis anggo nangang. ");
INSERT INTO shj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndäxi känggi täxäccä tä cabärang na lapi täsa ka, ‘Bugundugku Kalägkatäng nanggo!’ ");
INSERT INTO shj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Yä käläsang bo pa ndä kängge kabokasa anggo songang, wesi tä akänggä sota na ngada ka, ");
INSERT INTO shj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Käräptäniccä bo panägonong ta exenggäskong a'diskidinig tanggo ndey layis ngakä ngastänggägo ndä bäli ngakong ka, Bugundugku Kaläg kala kawuno ngäte.’ ");
INSERT INTO shj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndä ndänge, xa tä sanydä ow, ngakong layeccä tasiny täsa mo'do aki kasoguning tä Sudumang! ");
INSERT INTO shj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Woyoy tä menggä pang Korusin! Woyoy tä menggä pang Petsayida! Xa kä'dang weränicci kasoguning tanggo sogkuwa tä Taya na Sayidunang kax sägämele mäganygäsa tä ngaka tasiny wane, säccatetäsäng tä atilisiny, säbugu zänggäsa na uskuc na saxse mäganygäsa. ");
INSERT INTO shj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Neng xongondi xukumzä Kaläg wunodung tängang, nga layeccä bedeccä tanggo paccey 'diti aki tä Taya na Sayidunang! ");
INSERT INTO shj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ndä anggo menggä Kafärnaxum, anggo noxadang ka edekeny Kaläg dädäxti anggo tiyati? A'a! Wadi kala sägawadas anggo tä mas! ");
INSERT INTO shj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Käxa kädäng ngakägong kädäng ngakang, yä käxa käpexkä anggong käpexkä agä ndä käxa käpexkä agäng käpexkä Kalägi kayaxsä agäng.” ");
INSERT INTO shj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kala menggä räbki udiny kodos wang asiny wang pädaxang (72) kämele na led, ngadeccä ta Yasuwa ka, “Bazuwec, mändey kängga tasiny kädängäng nga täwas na agägi!” ");
INSERT INTO shj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na kala Yasuwa ngade täsa ka, “Agä kanox Däniye käpätäng zä koxa kadeläng kala mälamälajegä koxa. ");
INSERT INTO shj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ndänge, agä kadong panggudug tanggo ndey dereterejeyseng zänggä dolu na dänu na mändey ndey mo'dasang me kurugo Däniye, ndä 'doga siye anggondäng song. ");
INSERT INTO shj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yä musku, wanga led ka ligitiga tasiny kädängäng nga tanggo, wadi ledäning xa agägo gärekärejesäning tiyati tä pang Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na tänya axä owdi Yasuwa käligäwa na Ligidä Kaläg na mägäledäwa mängade ka, “Agä andädäxti gi Appanang, Bazuweccä tiyati na täzäg, xa gi kä'dany ngakong tä menggä lelertäg na känggi yeräninyang, yä käparäng tunyu ta enggä pipu. E, Appa, xa wanägi tidi täng. ");
INSERT INTO shj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Appananggi tiyating nyang kadong ngakong tagä kä'dayang. Appanangang tol seley yex agäng, Ndä agänangang tol seley ayex Appangang, na mändey känggi agä käpay ka aparas Appanang tängang käcag tol bäledes mang.” ");
INSERT INTO shj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na kala Yasuwa kawexeswa ta menggä räbke kabodsa nang na ngade ka, “Baxändäg tä agäwanggi lale 'dogi anggo zayadangang! ");
INSERT INTO shj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndä agä aläpedäng tanggo ka menggä logeygä Kaläg mange na buguninginy käpay ka laley wegkong laladangang ndä kox song, sapaye ka sädäng ngakong ndängedengang ndä sägädäng song.” ");
INSERT INTO shj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Xongenendäng, me lelericcä asiriyenä Musa kangäsa paye ka läbä Yasuwa, na ngade täma ka, “Me bäldic, oxadi kädäppa ka asog ndey a'dox aygä liliyang?” ");
INSERT INTO shj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na Yasuwa ngade täma ka, “Oxadi gärekärejesawa tä asiriyenä Musang? Anggo käbäleng wi tängang?” ");
INSERT INTO shj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na me lelericcä asiriyenä Musa kabuc ka, “Asiriye ngade ka, ‘Paya Bazuwec Kalägägi na mägaxsägi nuxung, na rongiccägi kä'day, na kutegtägkägi kä'day, na ngakä zägi kä'day’, na ‘paya menggä sogalinygägi kä'day ka'das paygi mpayis ngasäging.’” ");
INSERT INTO shj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na Yasuwa ngade täma me lelericcä asiriyenä Musa ka, “Gi kubuc ngakong appoyo, soga mänang ndey nay.” ");
INSERT INTO shj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ndä me lelericcä asiriyenä Musa paye bokung ngase tuny, na ngade ta Yasuwa ka, “Xänang näs me sogaldangang?” ");
INSERT INTO shj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na Yasuwa kabuc täma näs legedänic ka, “Apangandäng kacoccoleza tä Ursalim 'docco tä owda säbangäs Arixa, na kadel ta asänggä menggä bärada na kamen ma kawi'd ma, käbadä ma ndä wangasa ma tä enggä xäska bälaxiny. ");
INSERT INTO shj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Na todi me tämed tä Kaläg kälaxäng kacoccoleza na nya akäsogi ma'doxung apangzi menggä bärada käbadäng sängo täzäg na mapopporeza mägälang cengic. ");
INSERT INTO shj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na mändey me Lawi me posakä me tämed kawung kälaxäng na kox apangzi sängo täzäg na kapopporeza kälang cengic. ");
INSERT INTO shj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yä me Samriyani näs me pungutang wede kawung tänya owdu 'doxti sägäbadäng na mägox nya 'doxti sängo na agäma kawasa täng. ");
INSERT INTO shj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Na mägä'doc täng masenyndä penduge ndä mädoga mid täng ndä mäbodey ndä mäpoka tä kaccänäma. Magoya taxä aloc ndä mädäxä. ");
INSERT INTO shj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na edekenydeneni mabag ariyaliny pädax madoga ta me aloc, mängade täng ka, ‘Meskäde 'doxtong appoyo ndä wegki noco wanyäs tämang awunodung ameledäng tägi kä'day.’ ");
INSERT INTO shj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Tä känggong kodosakang, xänang kädäppa ka näs me sogal tä 'doxti menggä bärada käbadäng?” ");
INSERT INTO shj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na me lelericcä asiriyenä Musa ngade ka, “Käxi age kawasa tämang.” Na Yasuwa ngade täma ka, “Neng wede soga ka'das ma mänang.” ");
INSERT INTO shj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yasuwa na menggä räbke wedetese na kala sägä'docco saläsa nuxu kaxsä pa na uxandäng säbangäs Marsa kuxis ma xa mäs palangasic. ");
INSERT INTO shj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ndä ce Marsa päxä bosandäng säbängäs Mariyom käcca todä exenggä Bazuwec Yasuwa delde wunde tä bäldiccäma. ");
INSERT INTO shj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yä Marsandäng dalewa tä wexed xa cäpaye cäwex wexed kä'day na cawung ta Yasuwa cängade ka, “Bazuwec, gining seley mpaye ngakang xa'de? Päxäsko kawangäng wexed tagä kä'day. Lapi täce ka cäpos agä.” ");
INSERT INTO shj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na Bazuwec Yasuwa kabuc täce ka, “Marsa, Marsa, gining gäre nga ndä käwoldoxu na'do tä ngakä weg mange. ");
INSERT INTO shj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wadi 'dogkandäng nuxu payewa. Mariyom kadere ngaki apoccu pacceyang, 'doga bate täcendäng song.” ");
INSERT INTO shj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Xongonendäng Yasuwandäng palacca tä owandäng. Mägädokala paley na nuxu me räbkäma ngade täma ka, “Bazuwec, bälde was na paley, kala ani Yoxana käbäldeyis menggä räbkeneng.” ");
INSERT INTO shj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na Yasuwa läpede tä menggä räbke ka, “Känoxang mpadang palezangang, paleyzi ngada ka, Kaläg, Appani tiyating wanga agägi laye tädäxiny wanga bugundugkägi wuno täwas. ");
INSERT INTO shj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Togung zäx täwas todotol, ");
INSERT INTO shj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","na saxäng ngaka tasinygusko täwas, xa was wasaxedig nga tä känggi sogo ngaka tasiny täwasang. Ndakä wang ngakä längädäsko kawas was tä sogkä ngaka tasiny.” ");
INSERT INTO shj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na Yasuwa läpede täsa ka, “Kädäppa ka nuxu accägo biskonenendäng, ndey 'doc täng tä pälic läpe täng ka, ‘Bisko, bege agä pugandagä zäx kodos, ");
INSERT INTO shj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","xa biskonang käpätäng wedäg kawung tä panang, ndä 'doga tä andangandäng song.’ ");
INSERT INTO shj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ndä biskonäma meley täma ka, ‘Wanga daw tagä. Xa kala kadäränggälisnig na penggang tax kasändäccig. Päx angäsata tiyati adogodung nuxu 'dog tägi song.’ ");
INSERT INTO shj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Agä aläpedäng tanggo ka, kax apang uccu tax na ngäsata togada nuxu 'dog ta biskone xa ka biskoneneng song. Neng apang ngäsata togada 'dogi biskone payeng xa biskone ze kama tä mäneke song. ");
INSERT INTO shj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aläpedäng tanggo ka, mäne owdu 'dog ndey sädogung tanggo, nyamgäda 'dogi mpadangang ndey 'doxang, dotora sogal ndey sälenge tanggo. ");
INSERT INTO shj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Käxi mänecceng 'doxo 'dogi payeng ndä käxi nyamaccang kaledäng, na käxi totoro sogalang sälengede täng. ");
INSERT INTO shj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Xänang tä warägo näs appa pene kanyixay axsic täng ndä doga dol tängang, yä sax togakä axsic tängang? ");
INSERT INTO shj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na cong pene kanyixay gäldic täng, ndä toga dän tängang? ");
INSERT INTO shj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anggogi ndasinyangang yexeng togakä wegka apoccu ta penggägo, neng seley Kaläg, Appani Tiyating togada Ligide tä känggi mäne mang!” ");
INSERT INTO shj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yasuwa käcay käxa tasta kädogosojey apang. Ani käxa tas kawetäsang, apangzi kalayis togojosang kalegese, na xä'dä kädongo. ");
INSERT INTO shj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Na kulung acänggäsa ngadeccä ka, “Yasuwa caye kängga tasiny na panggugu Pelizipul buguningzä kängga tasiny.” ");
INSERT INTO shj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kulung kän paye läbä ma na ngadeccä ka mäsog bolic pätäng tiyati. ");
INSERT INTO shj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yä Yasuwa kabäle ngaki tä mäganygäsang na mängade täsa ka, “Bugundugka kälartänong wanyetäsäno, ndä caxsäwanda kälaräwang, telgedäng. ");
INSERT INTO shj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Yä gang butugku Däniye kälaränong, bugundugke dokoloccu key? Agä kamän anggo xa anggo gasedänang ka agä anycaye kängga tasiny na panggugu Pelizipul. ");
INSERT INTO shj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ndä gang agä anycaye kängga tasiny na panggugu Pelizipulang, anggo menggä räbkägo caye na panggugu wi? Neng mänangang, sa säparedäng anggo tunyu ka nyceluwinyang. ");
INSERT INTO shj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yä gang agänang anycaye kängga tasiny na andä Kalägkang, mänangang bugundugku Kaläg käcogu anggo. ");
INSERT INTO shj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Apangza pädäg kayiwa na wegkä pogutang meske pane, na ka'däka'dinä pane kä'day. ");
INSERT INTO shj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yä apangza pädäg paccey kasakas ma ndä kamo'das mang, soro bupsu pogudumani mäpäse andäma nangang na bate wegkäma lare. ");
INSERT INTO shj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Käxa nagä songang me kurangang ndä käxa poso agä tä wexed songang mace tagä.” ");
INSERT INTO shj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yasuwa legecce ngade ka, “Ligida tas kawetä tunyu täwang kigkang, tusu otaga ma wundung täng nyame owda nundu täng neng 'doxo song. Na ngade tängase ka, ‘Neng mänangang amelede tä boxu pananggi kawangasang.’ ");
INSERT INTO shj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na nyämele nyä'doxada boxu pa worowa kälexejeg na weg repetäsäning. ");
INSERT INTO shj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ndä nyäwede mändey nyä'do nyägodung kulung ligitiga tasinyga paxtinding mo'do nya, ndey sä'doc säläs säcuccu täng, ndey säsog 'doxti cuke laye tasiny mo'dä cukenegi täzälägkang.” ");
INSERT INTO shj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ani Yasuwa kalegeyäs ngakongang, uxandäng tä warä xä'dä kädawa ta Yasuwa ka, “Baxändäg tä uxi kiyäng ging na ki'digi kä'dey ging!” ");
INSERT INTO shj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yä Yasuwa kämele täce ka, “Wadi baxändäg tä känggi dänge ngakä Kaläg na wexeng!” ");
INSERT INTO shj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Xä'dä kaposwa, na Yasuwa kadeb legey ngade ka, “Zong sogo ngaka tasiny paccey, zong paye agä ka asog bolicca sogowa täng, ndä boliccandäng dogadaswa täng song basa boliccä me logey Yunan. ");
INSERT INTO shj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Dase ani Yunan kawunäs kalayis bolic tä menggä Niniwa, agä Päxä Käxa Jul mändey alayis bolic tä zong. ");
INSERT INTO shj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Buguningzä uxandäng näs näkä anda täzäg ngäsata na känggä zong tä xongondu xukum. Na cäsogo asiriye siye sa xa cägäpätäng tä 'denga ndey cädäng lelericcä Seleman. Ndä kigkanang todong ngake tädäxiny mo'do Seleman! ");
INSERT INTO shj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Menggä Niniwa ngäsotäsäng na menggä zong tä xongondu xukum. Na säsogo asiriye siye menggä zong, xa ani Yunan käbäldeyis menggä Niniwang, sägäxaje tä ngakäsagi säsogo tasinyang. Ndä kigkanang todong ngake tädäxiny mo'do Yunan! ");
INSERT INTO shj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Käxa banye lampane ndä 'danye na gumudi 'dog tängandäng song, basa bokasa täzä tumu ndey känggi läsotäng towang zayza nang. ");
INSERT INTO shj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Awunuging näs banyiccä wanäging. Känox awunugi apong, wanägi bägälic päse nyipäxkic, yä awunugi tasang, wanägi bägälic lätäng. ");
INSERT INTO shj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Neng gangang bäli, nyipäxkiccägi ndakä layis lätäng song. ");
INSERT INTO shj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndä gang känox wanägi bägälic päse nyipäxkic ndä nuxu cengiccenendäng tä lätä songang, wanägi bägälic päse nyipäxkic kala pappareygä lampa.” ");
INSERT INTO shj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yasuwa kä'dese legeyge na nuxu Farisiccandäng kabandä ma ka sä'docco sägur siyad tä pane. Na Yasuwa kä'doc kaläs tow na sägäccasäng sagur siyad. ");
INSERT INTO shj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ani Farisic koxus Yasuwa paye siyza yä ka'dayis asängge täbangä tanyara songang, kädonga. ");
INSERT INTO shj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na Bazuwec kalegese täma ka, “Neng gang anggo Farisiny 'dayadang ondugu satugugo yä kaxsängga kaganye. Yä anggog mänang. Mäganygägo päse kuruguru na tastäg. ");
INSERT INTO shj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ama anggo abadiny, anggo 'diyang ka Kalägkang teye wanä 'dog na kaxseneng? ");
INSERT INTO shj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wadi dogi weg tä känggi widäningang na mäganygo nuxung, ndey ngakä mäganygägo na wexekägo laye kälexejeg tagä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Woyoy tanggo Farisiny! Anggo dogadang asiny tä udiny mädäg tä kenyu na enggä ewegä log tä Kaläg, yä musku anggo bigiding däppic na payiccä Kaläg! Wadi kädäppa ka anggo dogang wegkong tä Kaläg yä wangang bigigä däppic na payiccä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woyoy tanggo Farisiny! Xa mpadang cad tä otagä dädäxti tä axä paliccä Yaxudiny na mpadang ma'ditegä modey tä otagä nganyatada! ");
INSERT INTO shj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woyoy tanggo! Xa kä'dasang morotaga kasabe, kän wedeccä ta zängga ndä yex song!” ");
INSERT INTO shj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na nuxung me lelericcä asiriyenä Musa kabuc täma ka, “Me bäldic, legeyis ngakongang langatag täwas mändey.” ");
INSERT INTO shj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Neng Yasuwa kämeley ka, “Woyoy ama menggä lelericcä asiriyenä Musa mändey! Anggo ndarandadang kän na ngakä asiriye ndä siyada tä wadäka, yä musku taxä nuxuza anggo dogadang asänggägo täng tä posad song! ");
INSERT INTO shj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woyoy tanggo xa anggo donyadang morotagä menggä logeygi wawanagkägo kapaxang. ");
INSERT INTO shj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ka'das ka anggo gixing na käbäleng wexekä wawanagkägo, xa sapaxtä menggä logey ndä anggo kädonydang morotaga! ");
INSERT INTO shj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nenyang Kalägi yex nga kä'dayang ngade ka, ‘Agä ayaxsada menggä logey na känggi sägäligäng täsa, ndä kulung acängga säpaxe na sämaceccä täng säpexke.’ ");
INSERT INTO shj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndä zong layis näka asiriye siye tä tamiccä menggä logeygi kacolasäwa cawu tebiccä ow, ");
INSERT INTO shj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","cawu tamiccä Xapil na tä tamiccä Zakariya, ani sapax tä kaxsä kaldä axä tämetang. E, agä aläpedäng ka layeccänäs ngakä ngastänggä zong. ");
INSERT INTO shj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Woyoy tänggo menggä lelericcä asiriyenä Musa! Anggo kädäringgiling sogaldä yexkä nga! Anggo käläsang na ngastänggägo song, ndä käzekeng känggi paye läsang.” ");
INSERT INTO shj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ani Yasuwa käpayis ka wetä tä pang Farisiccang, menggä lelericcä asiriyenä Musa na Farisiny kadeb maccad tasiny täma, na samän ma seley na mäned tä nga mange, ");
INSERT INTO shj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ndey sänyamgädäs rakawza sämen ma täng tä ngaka mälege. ");
INSERT INTO shj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ani xä'dä kädurisäno kasog päsäciny dexä bungudäningang, Yasuwa kadeb legey täzälägäne ta menggä räbke ka, “Meskädäning tä 'daziccä Farisinygi näs fonofoneyang. ");
INSERT INTO shj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'Doga ka'danywang, 'doxowa ndä 'doga kabotwa näs raj paredängwa tunyu. ");
INSERT INTO shj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ndä gang ngaki bägälic kangadäning ongutang dängewa säxe, na ngaki käbodang taxä ndongang duwaledäning tä owda lenge. ");
INSERT INTO shj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Aläpedäng tanggo biskodagang ka wanga nyigatägkä känggi paxe wanäwanang, xa mändey 'doga sogo täbangenendäng song. ");
INSERT INTO shj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wadi aläpedäng tanggo ka käxi kädäppas ka nyigatangang, nyigata Kaläg xa nyang tol panggudug täng gawadas anggo tä mas tä xongondu xäskägong. E, aläpedäng tanggo ka, nyigata Kaläg! ");
INSERT INTO shj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Päx atodu mädäg sänganyada na mälininy pädax song? Yä musku nuxung atoduwiccandäng ka'diyaswa tagä Kaläg song. ");
INSERT INTO shj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ndä näs tire apaxki täzäging Kaläg kägänasa. Wanga nyigatäg, xa anggo ngakägo bedeccä mo'do atoduga mange. ");
INSERT INTO shj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aläpedäng tanggo ka, käxa 'dade awage na agä tagä kän ka räbo agäng, agä, Päxä Käxa Jul mändey a'dade awagang nang tagä malaykadagä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yä käxa käli agä tagä känang agä mändey agäli tagä malaykadagä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ndä käxa lege ngakä maccad tä ngakang, agä Päxä Käxa Julang, nyäwangada nga täng yä käxi degeje Ligidä Kalägkang nyäwangada nga täng song. ");
INSERT INTO shj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yä sagoying anggo tagä axä paliccä Yaxudiny na bugununginy na ngotorpodang, ndakä gäredeng ngaka mäxising nang na tä 'doga legedeng, ");
INSERT INTO shj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","xa Ligidä Kaläg lapedäng 'doga legedeng tänya owdi.” ");
INSERT INTO shj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nuxu kigkandäng tä warä xä'dä ngade ta Yasuwa ka, “Me bäldic, lapi ta päxä bisko ka walarig malenä appanang.” ");
INSERT INTO shj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Neng Yasuwa ngade täma ka, “Amo, xänang kamenäs agä buguningang de azaye ngakägong?” ");
INSERT INTO shj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na mängade täsa ka, “Lengi agägo na meskäde ngastänggägo tä 'dara, xa rongicca 'doxowa tä dangandägkandäng song.” ");
INSERT INTO shj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na maser nga täsa ka, “ 'Doxtiyandäng näs tanganic pelowge kiying päxä kuny, ");
INSERT INTO shj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","na mängade ka, ‘Asogowa key, ndey a'dox curuna ngotey adoga kunykang tängang?’ ");
INSERT INTO shj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na kala mängade ka, ‘Basa asog 'dogong, apaxatasa curugang yä adonyo käka ngoniny, ndey acolda kuny täng na ka'däka'di bägälic. ");
INSERT INTO shj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndä angad tängasang ka, “Gi ka'däka'dinägi mange käyoka mange layis näkä jende, buduldi, sisi, wuxsi, na ledewa!”’ ");
INSERT INTO shj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Na kala Kaläg ngade täma ka, ‘Ama abad! Ondunong analedäng rongiccägi tägi tunyu, yä xänang lugu ka'däka'dini käwex tängasäging?’ ");
INSERT INTO shj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Käxa xikitäsa weg tä ngase mänangang, wadi tangandägkenetäng tagä Kaläg song.” ");
INSERT INTO shj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yasuwa ngade tä menggä räbke ka, “Aläpedäng tanggo ka wanga kärekä ngakä aygägo, na wegka ziyadang na tä wadäkägo tä tanduga lagadang. ");
INSERT INTO shj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Xa ay mo'do siyad, ndä wanäwan mo'do lag. ");
INSERT INTO shj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Lala atämidinggaru wacca song ndä zäbecce song, ndä curunanandäng song, yä Kaläg ziye. Ndä Kaläg paye anggo paccey mo'do awiny! ");
INSERT INTO shj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Xänang tanggo kärekä ngake posada sängädic tä rongeneng? ");
INSERT INTO shj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndä yexeng ka kärekä ngakägo posada sängädic tä rongiccägo songang, wi siye anggo gäredeng ngakä kulung wegkang? ");
INSERT INTO shj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lala dudulus 'dongoccu key, ndä wexekanatäng song, ndä secce song. Neng musku aläpedäng tanggo ka, kala Seleman tä bugundugke kälagä tandäna kusu kala nuxu dudulusiccong song! ");
INSERT INTO shj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ndä Kaläg nyaza nyägädel dudulus mänangang, ndä uccu todong xongong ndä edekeny sädoxus mas tä boxu tämä'di'diccä zex. Kaläg paye anggo mo'do dudulus. Wi siye anggogong menekä ngakä Kaläg bälaxiny tanggo mänangang? ");
INSERT INTO shj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ndakä makadang bandagä wegka ziyadang na wegka wuxiding na ndakä gäredeng ngakä weg. ");
INSERT INTO shj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Xa känggi kä'day tä walangiccang, mate bandagä siyad na wuxid, ndä Appani Tiyating yex 'dogi mpadangang. ");
INSERT INTO shj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anggo basa makädang bangä ngakä Kaläg ndä nyädogung weg tanggo käsär. ");
INSERT INTO shj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Anggo menggä räb kä'dasang sagunu, wanga nyigatäg xa Menggoni Tiyating wane tidi xa buguningzägong na meske anggo. ");
INSERT INTO shj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nganyi wegkägo kä'day larti tä känggi widänong. Yawi malenägo tä pang Kaläg tä kaxsä meldugi boxsoccu na cereduno songang, na me bära bate songang na tondoc wanyäs songang ndey meskädä wegkägo tä pang Kaläg tiyati. ");
INSERT INTO shj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Xa owdi mälenägo tängang nyang mäganygägo padasang. ");
INSERT INTO shj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Laga tandugu wexekägo na meskäde lampadagägo kusuccu kä'day. ");
INSERT INTO shj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Layi kala kängga bene käxa ngondeza päkädäng owdu ledä batad, ndey mawung madotorezang ndey lenge bäling täma tetex. ");
INSERT INTO shj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Baxändäg tä cäläxinygi käxa ngondey 'doxodung oxacca kasändäcco song tä melgämang! Aläpedäng zänggä nga tanggo ka, ma täzäma mälage tandugu wexed, na mäbogkatasa sa, ndey mälarta siyad täsa! ");
INSERT INTO shj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kax mäwung tä pälic na mä'doxodängza soxacca, baxändäg tä cäläxinygi mänangang! ");
INSERT INTO shj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wadi bäli ka kä'dang me pa yex xongondi me bära wunodung tängang kax meske pane wange me bära läso song. ");
INSERT INTO shj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anggo mändey layesi kängga cuccu meskedäning, xa agä, Päxä Käxa Jul awunodung ndä xongondeneni bäledesäwa song.” ");
INSERT INTO shj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na Putros ngade ta Yasuwa ka, “Bazuwec, gining zere ngakong täwas wala kän kä'day?” ");
INSERT INTO shj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Bazuwec kabuc ka, “Xänang kädäppa ka mpäse andägi nang na kalelerey tä menekä wexetang, xänang käxa ngondezä wexed bokatasa mene menggä wexed tä ande ndey togadas dericcä menggä wexed layde songang? ");
INSERT INTO shj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Baxändäg tä me wexeki käxa ngondeze mele 'doxodung wexecceng. ");
INSERT INTO shj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aläpedäng zänggä nga tanggo ka, käxa ngondezä wexed menede ka'däka'di tä andä käxi mänangang. ");
INSERT INTO shj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Yä wadi nya me wexeki kä'doc kangad tä ngase ka käxa ngondezang kalaygädas tä mel, na kadeb badkä kulung menggä wexed, bade apanginy na uxu kä'day, ndä siyacca na wuxicci de bux paxeng, ");
INSERT INTO shj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ndä käxa ngondezä nya me wexeki nuxus wung tä xongondi sabokasa ka mäwunodung songang na tä sani säyex songang, na cäläxti ma, ndä matas ma tä owdu märinginy. ");
INSERT INTO shj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ndä me wexeki yex ngaki käxa ngondeze paye ndä wexe song na käbolasa ngase songang, 'doxo bad mange. ");
INSERT INTO shj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Wadi me wexeki yex ngaki käxa ngondeze paye songang ndä wex songang säbade päxä bälax winy. Käxa sadoga weg täng mangeng, säpaye täng mange, ndä käxa saposa weg täng mange ka mendäng, säläge payge täng mange. ");
INSERT INTO shj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Agä kawung täzäg tä koyinakä mas, ndä ampaye ka nyandäng ganang tunyu walangic kä'day! ");
INSERT INTO shj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ndä mänang agä alayis käxa panye xuxubtäg ndä agäre bal a'dese! ");
INSERT INTO shj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Anggo noxadang ka agä kawung tä koyinakä modey täzäg? A'a, agä kawung tä koyinakä modey song, wadi kawung tä koyinakä wasad! ");
INSERT INTO shj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Caw xongong na ur'dug bäli ka kän mädäg tä pana wasetäsäning, kodos pase awaga na pädax ndä pädax pase awaga na kodos. ");
INSERT INTO shj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sa säwasetäsäning, menäwan kixidi pene apang song, ndä penäwan kixidi mena song, bonuwan kixidi päxe ux song, ndä päxä ux kixidi bona song, ux kixidi uxä päxe song, ndä päxä ux kixidi wawana ux song.” ");
INSERT INTO shj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yasuwa mändey kangad tä xä'dä ka, “Känoxang timingarugu zädongang, na kala bäledeng ka koxa käje na käje. ");
INSERT INTO shj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ndä känoxang megenä anda täzäg sageng, bäledeng ka kämpagänendäng sagedäng, na sagedäng. ");
INSERT INTO shj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anggo menggä fonofoney! Anggo yexeng tetebegä ngakä bolicca alacca täzäg na täzä koxang, yä wadi kasogänang key 'diyang tetebegä ngakä bolugu wexekong awexe ganangang? ");
INSERT INTO shj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Wi siye anggo zaxadang terekä ngaka apoccung? ");
INSERT INTO shj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Känoxang noccang na me pokakä nga tägi tagä buguningang, mäpädägäsing ndey bolang ngakägo nama ta akäsog ndakä mägoyas gi tagä buguning, xa buguning menedes gi tä andä polisic, ndä polisic rikidis gi tax. ");
INSERT INTO shj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Agä aläpedäng tanggo ka, anggo 'doxadang tunyu song basa degänang na milin!” ");
INSERT INTO shj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Xongondi Yasuwa bäldeccenäsang, kän kawuno kaläja täma ka Pälatis kapax kulung menggä Calil ndä kurupu tamicca na tamiccä wegki sadämze nangang. ");
INSERT INTO shj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na Yasuwa kabuc täsa ka, “Neng anggo käbokosänang ka menggä Calilgi sapaxang sag tasiny mo'do wayaka nyang kasog sapaxang? ");
INSERT INTO shj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A'a, aläpedäng tanggo ka bal anggo xajang tä ngaka tasiny mändey xa na'anggägo näxsecceng mändey!” ");
INSERT INTO shj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na mändey Yasuwa ngade täsa ka, “Känggi bägäliziccä kumagi kadeles zängga käxse asiny wang tespedespe tä Salonang, anggo nggeredeng ka sa sädasiny paccey sämo'do känggi kä'day tä Ursalimang? ");
INSERT INTO shj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A'a, aläpedäng tanggo ka bal anggo xajang tä ngaka tasiny mändey xa na'anggägo näxsecceng mändey!” ");
INSERT INTO shj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yasuwa kaser nga ka, “Apangandäng käsäbä etä 'dami tä pelowge, na xongonendäng mägä'doc mäpaye ka metä enggenge neng ma'doxa ze pälo. ");
INSERT INTO shj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na kala mäläpede tä 'doxti meske pelowang ka, ‘Tä jendäg kodos agä amelde awunodung ndey ka a'dox päxä 'daminong ndä a'doxodung ze pälo. Dagasa täzäg, taxä wi 'dog uccu ndä wanyis zägkang?’ ");
INSERT INTO shj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Neng me megäskä pelow kabuc täma ka, ‘Bazuwec, accig wanga etong jenong yä anoc abosu boxe adoga mudura täng. ");
INSERT INTO shj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ndä zayig cong kiye baydangang, yä kasax iyetang, ndä lusa täzäg.’” ");
INSERT INTO shj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yasuwa bäldecce tä nuxu axä paliccä Yaxudiny tä xongondu Sapid, ");
INSERT INTO shj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ndä uxandäng tänya owdi ligida tas kämexestey tä jendägka asiny wang tespedespe. Nyägonggosey ce kasog ce seley cäyex dokol kätay song. ");
INSERT INTO shj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yasuwa kox ce na kabandä ce na ngade täce ka, “Kala käwulegeswa tä ngguxtug.” ");
INSERT INTO shj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na Yasuwa kädana asängge täce na tetex cägädokol tiyati kätay na cägädädäxti Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na käxa ngondezä axä paliccä Yaxudiny käsänga ta Yasuwa xa Yasuwa kädäxsi tä xongondu Sapid, na ma käxa ngondey mäläpede tä xä'dä ka wexed wexedäning tä sängga aran. Käxa täxäng wung sädäxä täng ndakä wung tä däx tä xongondu Sapid. ");
INSERT INTO shj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Na Bazuwec Yasuwa kabuc täma ka, “Anggo menggä fonofoney! Anggo nuxu accägondäng tä xongondu Sapid uludi tigide na cong näs kaccäneneng ndey koya tä wuxid song? ");
INSERT INTO shj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yä cezong cäs päxä pe Apraxim, Däniye gun onguce tä jendägka asiny wang tespedespeng, awang 'dakakä ce tä co'dic tä xongondu Sapid?” ");
INSERT INTO shj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ani Yasuwa kangadäs legeygongang, menggä kuruma kä'day zängga kamaye yä xä'dä kä'day käledäning tä wexeki kädong sa Yasuwa wexeng. ");
INSERT INTO shj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yasuwa kamänze ka, “Bugundugku Kaläg ka'das wi? Oxadiyang agänang andäppo nangang? ");
INSERT INTO shj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bugundugku Kaläg ka'das päxä yugicca biyey apang kabag käsäbesa tä kaxsänggä pelowge ndä 'donga layis apanggä ed yagäney, ndä awiny 'danydä axinyga tä acayadage.” ");
INSERT INTO shj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mändey Yasuwa ngade ka, “Oxadiyang agä andäppo na bugundugku Kalägkang? ");
INSERT INTO shj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bugundugku Kaläg ka'das 'dazicca ux kabag ndä kurupu na duc mange ndä kamojey ndä pudi kä'day.” ");
INSERT INTO shj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yasuwa kä'doc tä wedäg kadus kaxsä pa na enggä cabärta bäldecce ndä mäwedede tä Ursalim. ");
INSERT INTO shj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na nuxu kigkandäng kamän ma ka, “Bazuwec, enggä kän bälaxinyag Kaläg xonyong?” Na mängade täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mpädägäsining ndey läsang akäsogaldi kacäbaswang, xa aläpedäng tanggo ka kän mange zäge läsake ndä mo'dada läsacca song. ");
INSERT INTO shj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Xongonda ledä pa kangäsa kärikä sogaldeneng, anggo wunosunang ndokalaccang tunyu dotoraccang ndä nyäxadang ma ka, ‘Bazuwec, wanga was aläsig!’ Neng mäbucu tanggo ka, ‘Agänang ayex anggo song ndä ayex owda känycuccing täng song.’ ");
INSERT INTO shj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na noccang ngadaccang ka, ‘Was kasiyzig na kawuxsig nagi, ndä gi käbäldeyze tä kaxsä panäsko.’ ");
INSERT INTO shj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Neng mämele ka, ‘Agänang ayex anggo song ndä ayex owda känyciccing täng song! Nycengäning tä wanang, na'anggägo, anggo menggä sogkä ngaka tasiny!’ ");
INSERT INTO shj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na kala todi ngecceng na gasadang nyäxkägo tä oxakä Apraxim na Isxag na Yaxup na menggä logeygi kä'day tä bugundugku Kalägkang yä anggo tä ngastänggägo sä'dädadas anggo tunyu. ");
INSERT INTO shj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ndä kän päkätäsäng zä dong na tawiny na anda tiyati na anda täzäg wunosuno catetäsäng kuru siyad tä owdu Bugundugku Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndä seley känggi päccadas ngastängganang, latasa tong yä känggi latasa tongang, päccatasa.” ");
INSERT INTO shj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tänya xongondi Yasuwa legeccenäsang, kulung Farisinyatäng kawuno ngadeccä täma ka, “Wete wede wangasa owdong xa Xirudus paye pax gi.” ");
INSERT INTO shj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Neng Yasuwa kabuc täsa ka, “Wesi lapi ta atorundorini ka, ‘Laley, agä anycaye kängga tasiny na andäxäcci xongondong na edekeny yä mugundeneni ampele wexekang. ");
INSERT INTO shj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ndä gang agä awedede xongondong na edekeny na mugun xa kax kädäppa ka säpaxa me logey täpox song, basa tä Ursalim.’ ");
INSERT INTO shj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ama, ama menggä Ursalim, anggogi paxadang menggä logey na 'dämedeng menggä yaxsäwinygi sägäligäng! Agä tol kampay ka agä anduris anggo kala kuxug na enggengge tä boxu kubugke neng anggo kämpayang song! ");
INSERT INTO shj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ndä ganang lala kala agä awangatasa anggo! Ndä aläpedäng tanggo ka, anggo mpasaccang nagä mändey song basa ngadang ka, ‘Baxändäg tä käxi wunodung na agä Bazuwec Kalägkang!’” ");
INSERT INTO shj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Xongondu Sapid Yasuwa kä'doc tä siyad tä pang ngotorponu Farisiny ndä kulung känatäng tänya owdi jenggere ma käsac. ");
INSERT INTO shj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ndä apangandäng tänya owdi exengge na asängge kapuruzu. ");
INSERT INTO shj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Yasuwa kamän me lelericcä asiriyenä Musa na Farisiny ka, “Kädäppa ta asiriye ka kig däxsi tä xongondu Sapid wala kädäppa song?” ");
INSERT INTO shj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Neng säpuloccä na todi Yasuwa kädana ande ta apangzi kädäxä na kayaxsas tä pa. ");
INSERT INTO shj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na todi Yasuwa kamän sa ka, “Xänang tanggo pene täng na cong näs tigide kadel taxä gol tä xongondu Sapid ndä 'dägane tetex nyasedäng tunyu songang?” ");
INSERT INTO shj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ndä sa sabuc ngakenegi song. ");
INSERT INTO shj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ani Yasuwa koxäs palangas teredenäs otagä caka apoccung, maser nga täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sabandä gi tä owdu batatang, ndakä dere owdu cakä kängga ngoniny xa nuxus nuxung kigkandäng sabandä ngondey tägi. ");
INSERT INTO shj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ndä nuxus käxi kabandä anggong wung lapäng tägi ka, ‘Togi komong känyca tängang tä käxong ngondeyanang’, ndä mänangang zänggä matag tägi ndä sogo gi cengedeswa tä päxä owda biyey. ");
INSERT INTO shj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Wadi känox sabandä ging, wede icca tä päxä owda biyey ndey käxi kabandä gi kox ging, wung läpäng tägi ka, ‘Bisko, bo wede icca tä owda apo.’ Na kala känggi täng kä'dayang bälede nyaygi sädogodung täging. ");
INSERT INTO shj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Xa käxa poko ngaseneng Kaläg maye ze yä käxa coccolo ngaseneng, Kaläg pokada tiyati.” ");
INSERT INTO shj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sax mändey Yasuwa ngade ta apangzi kabandä kän tä siyatang ka, “Xongonda mpaye bandä kän tä siyatang, acaka bandä biskodagägi na enggä bonggugo na wayagkägo na cong näs menggä sogalinygägigi kadangandeng ndey ka bandä gi tä siyad mändey. ");
INSERT INTO shj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wadi xongonda käsog letang, banda menggä wiy na kappudiny na mexesu na ngojony. ");
INSERT INTO shj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ndey baxändey, xa sa sämeledäng wegki sasiyang tägi song, gi 'doxo wegkägi tä xongondu ngäsakä känggi lelexinyang tä xäs.” ");
INSERT INTO shj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nuxung accä känggi siyacca na Yasuwa tä pang Farisiccang kädäng ngaki Yasuwa kangatang, na ngade ta Yasuwa ka, “Baxändäg tä känggi kä'day 'docco siyacca tä owdu Bugundugku Kalägkang!” ");
INSERT INTO shj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Neng Yasuwa ngade täma ka, “Apangandäng kasog led ngotey ndä bandä palangas mange. ");
INSERT INTO shj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na tä xongondu led mayaxsä cäläxinygäma ndey ka 'docco läpe känggi sabandäng ka wuno xa kala siyatatäng benecce. ");
INSERT INTO shj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Neng kän kä'day kadeb kerekä nga. Nuxu käxi tä zälägkang ngade ka, ‘Agänang kangany zäg ndä ampaye anoc anycopu, wanga agä anoc.’ ");
INSERT INTO shj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na mändey ani täbangeneng ngade ka, ‘Agä kangany tigitigä way asiny ndä ampaye anoc azägä, wanga agä anoc.’ ");
INSERT INTO shj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yä 'doxti layis sanydäsang ngade ka, ‘Agänang andalewa xa kabagsa käsactong ndä awunodung song.’ ");
INSERT INTO shj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na kala cäläx kämel kä'doc kaläpe ngaki ta bazuwecce. Na bazuwec ledä pa käsänga na läpedes ta cäläxse ka, ‘Wede tetex tä akäsogä bo pa na ta akänggä sotagä kukujiy. Banggäda menggä wiy na mexesu na kappudiny na ngojony ka wuno.’ ");
INSERT INTO shj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Neng cäläx ngade ka, ‘Bazuwec, ngaki käläpäng ka sogunong, kasog kala ndä musku otagä catatäng päloccä.’ ");
INSERT INTO shj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na kala bazuwec ngade ta cäläxse ka, ‘Wede tä akänggä sotagi ngoniny näs sotagä walangang, banggäda kän ka wuno ndey panang päs. ");
INSERT INTO shj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Xa agä aläpedäng tanggo ka acaka nuxu käxi kabandäng ndä saxang, wung pong siyakong!’” ");
INSERT INTO shj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xä'dä mange wedeccä na Yasuwa na mawexwa mäläpede täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Käxa paye wung 'doc nagä ndä paye agä paccey mo'do paygi payis mena na bona na uxe na pengge na enggä bongga na mändey ngase songang, layis me räbkang song. ");
INSERT INTO shj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Käxa poko kalicce ndä räbo agä songang, layis me räbkang song. ");
INSERT INTO shj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Xänang tanggo paye dony pane ndä cata ndey gan na zay wegka 'desede tonyakä pane nang songang? ");
INSERT INTO shj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Känox känyca gärtä nga ndä bosasa kadasuwec appoyo na kä'dese panägi songang, känggi kä'day zaye panäging kugu gi. ");
INSERT INTO shj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Docco ngadeccä ka, ‘Apangzong kadonyza ndä käpany kä'dese pane song!’” ");
INSERT INTO shj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mändey mängade ka, “Buguningza key paye 'doc 'ding buguningza caka tä pogud ndä cata bälede ngase ka 'do tä pogud na asägaruge päsäciny asiny (10,000) ndey mo'du buguningza käne päsäciny utang (20,000)? ");
INSERT INTO shj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ndä mäyex ka mä'dingi nya buguningzi songang, tä cuku menggä kurusa täxande, mäyaxsada kulung menggä bolic päccatasa tä legeygä ngakä modey. ");
INSERT INTO shj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ndä mänang nuxung accägondäng layis me räbkang song basa wangesänang wegkägo kä'day ndey räbkädang agä.” ");
INSERT INTO shj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Enggäloke apoccu yä kalaye leminyang, sogoduning key meletäsäno tä coccoydägkang? ");
INSERT INTO shj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Enggäloke kalaye leminyang, kax säduki tä zäg na tä codoro na wexekanatäng song basa säduki täpox. Käxa wunde dängecceng, däng ngakong!” ");
INSERT INTO shj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Menggä yawgä tuluba na känggi sogo ngaka tasinyang kawuno tä dänggä legeygä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Neng Farisiny na menggä lelericcä asiriyenä Musa ngunungunicci ka, “Apangzong bokatasa kängga sogo ngaka tasiny ndä siyacca nang.” ");
INSERT INTO shj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na kala Yasuwa kaser nga täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Xänang tanggo sagunu täng udiny mädäg (100) ndä nuxung mes ndä wangatasa aki udiny tesped wang asiny wang paye nuxung (99) tä korongic yä 'doco tä nyamgä ani nuxung kämesang basa 'dox songang? ");
INSERT INTO shj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ndä kala ma'doxang mäpoko tä baccugäma mälededeswa nang tä akäsog. ");
INSERT INTO shj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mämelede tä pa, mäbange aminuguma na menggä akäsogalinygäma ka, ‘Posa agä nycugo aledäning xa ka'dox sagändanggi kämesang.’ ");
INSERT INTO shj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aläpedäng tanggo ka, ka'das nya bangi kän lededäning paccey tä pang Kalägi tiyating tä ngakä käxa nuxungza käxajä tä ngaka tasiny. Xa ledi tiyati tä pang Kalägkang kamo'du ledä aki udiny tesped wang asiny wang paye nuxung (99) lelexiny kamen ngakä Kalägkang.” ");
INSERT INTO shj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yasuwa kawetäde na legey ka, “Cong näs uxa ariyalinygä fudada täng asiny ndä nuxung mesang, banye lampane ndä wortäcca paccey ndey 'dox owde song? ");
INSERT INTO shj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ndä ca'doxang cäbange aminuguce na menggä sogalinygäce cängade ka, ‘Nycugo aledäning xa ka'dox ariyaliccanggi kämesang.’ ");
INSERT INTO shj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ka'das nya bangä ledong, aläpedäng tanggo ka, Kaläg na malayikadage lededäning tä ngakä käxa nuxungza käxajä tä ngaka tasiny.” ");
INSERT INTO shj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yasuwa ngade ka, “Apangandäng mägaccäng na enggä pengge pädax. ");
INSERT INTO shj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Penämani biyeyang lapada täma ka, ‘Appa, ampaye larä male täwas.’ Na kala mesa kälarä male kadoga käma. ");
INSERT INTO shj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Na tä sängga bälaxiny mäguduri malenäma manganya kä'day mägä'docco nang tä cabära täxande. Mägä'doc mawanye nang tä wexekä tawustug winy. ");
INSERT INTO shj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Na kala mägä'dese malenäma, na buxu kamen nya cabäri na xas kapax ma paccey. ");
INSERT INTO shj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na mängade tä ngasäma ka, ‘Anoco ta nuxu me cabärong ani buduruginyge tängang ndey ameskädä buduruginyge.’ ");
INSERT INTO shj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mägä'doc ndä säleye siyad täma kasog ma mäpaye siyakä sa säpärki mädogada ta buduruginyang. ");
INSERT INTO shj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Na xongonendäng manimäng pang mesa na mängade tä ngasäma ka, ‘Wi siye agä anycu todong xas paxe agä, yä appanang wekenetäng mange menggä wexeke siyacca matasa de kulung tegeteseng.’ ");
INSERT INTO shj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mängade ka, ‘Anoco tä pa ta appanang aläpede täma ka, “Appa, kasog ngaka tasiny tagä Kaläg na tagä gi. ");
INSERT INTO shj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kandäppas ka bandäs agä penägi mändey song. Wanga agä alayis me wexiccägi.”’ ");
INSERT INTO shj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Na kala mamen sog mämele tä pa ta mesa. Na mesa kox ma täxande na age kawasa täma käpaxas ma kagapas ma. ");
INSERT INTO shj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na mängade ta mesa ka, ‘Appa, kasog ngaka tasiny tagä Kaläg na tagä gi. Kandäppas ka agä anäs penägi mändey song.’ ");
INSERT INTO shj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Neng mesa kabandä cäläxinyge ka, ‘ 'Dägana goyining tandäni appoyong laga ma nang, na baga kälingic loxi tä päxä andäma na laga ma na käbadaga apoccu.’ ");
INSERT INTO shj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na mesa kabandä menggä wexed ka, ‘Goyining päxä 'dämädi kawingang nycugo ampärki ma nang, na aledäning, ");
INSERT INTO shj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","xa päxä penanggong kämes neng sa'dox ma! Oxodig ka mägäxsä, neng manang mawung moxacca.’ Na kän käledäno. ");
INSERT INTO shj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yä päxä penämani ngondeyang nyandäng tä pelow na kala kawung wede dänge tädäxä kän buldi na coxad na langad tä pa. ");
INSERT INTO shj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na kala mägädokala täxande mabandä me wexed mamän ka, ‘Oxadi kasiwa tä pang?’ ");
INSERT INTO shj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na me wexed lapada täma ka, ‘Päxä bonggo kämel kawung, neng menggo käpärkä ma na päxä 'dämädi kawing pacceyang, xa mawung wanäma apo.’ ");
INSERT INTO shj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na mägäsänga malewa täxande na mesa kä'doc täma mäne ma ka, ‘Wi siye gi zaxe wunad towang?’ ");
INSERT INTO shj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na mängade ka, ‘Za, kalayigädä nagi ewexecce tägi kala cäläx ndä ande ngagigi, yä kax taxä nuxu kädong päxä ayis ka apax asig na aminugang song. ");
INSERT INTO shj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yä päxä penäginong kasax gi, kabag malene kä'doc kawanye nang na tabany, ndä kawung kämpärkä na käledäwa täng.’ ");
INSERT INTO shj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Na mesa kabuc täma ka, ‘Penang, ging nagä tol ndä wegkang kä'day kinggig. ");
INSERT INTO shj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yä päxä bonggonong kämese täpox neng sa'dox, oxodig ka käxsä neng manang mawung moxacca, nyang kasog kampärkä mang ndey ledänig.’” ");
INSERT INTO shj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yasuwa kaläpe tä menggä räbke ka, “Apangandäng näs tanganic saläpe täma ka me menekä wegkäma kawanydäs weg. ");
INSERT INTO shj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na ma 'doxti kadangandeyang kabandä me menekä wegke kamän ka, ‘Oxadi kasiwa andänge sälege ngakä wexekäging? Genesa wexeki käwex kä'dayang xa gi mändey noco layis me menekä wegkang song.’ ");
INSERT INTO shj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Na me menekä weg ngade tängase ka, ‘Oxadi gang asogkang, xa bazuweccang paye caye agä tä wexekangang? Agä ampädäg de ka awacca song ndä zänggä matag tagä ndey ka anyäxayza. ");
INSERT INTO shj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ayex 'doga asogo ndey kax säbogkung agä tunyu tä wexekang na kän bokatasa agä tä padägka.’ ");
INSERT INTO shj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Na kala mabanggädä känggi kamendä amusudi tä 'doxti kadangandeyang nunuxundi. Na mamän ani täzälägkang ka, ‘Gining bazuweccang paye tägi käreny?’ ");
INSERT INTO shj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na nya apangzi kabuc ka, ‘Bälegkä belenyinygä midä kuluc udiny mädäginy tespedespe (800).’ Na me menekä weg ngade täma ka, ‘Koyung faragiccä amusunugi icca täzäg tetex gärekärejesa udiny mädäginy tesped (400).’ ");
INSERT INTO shj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na mändey me menekä weg kamän 'doxti nuxungang ka, ‘Gining bazuwec paye tägi käreny?’ Na nya 'doxti kabuc ka, ‘Mäpaye landagä guruwec päsic nuxung (1,000).’ Na me menekä weg ngade täma ka, ‘Baga faragiccä amusunugi gärekärejesa udiny mädäginy tespedespe (800).’ ");
INSERT INTO shj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na bazuwec käboxey me menekä wegki käläkäläjang xa mawexse na yerändäg. Xa känggi mene ngakä Kaläg songang, yeräniny tä wexekanagi wexe na acängganang mo'do känggi kamen ngakä Kalägkang. ");
INSERT INTO shj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndä aläpedäng tanggo ka zoga biskodagägo na bangä tangandägkä walangic, ndey edekeny asänggägo kalaye päloccung, ndey säbogkasa anggo tä pang Kalägi tiyating. ");
INSERT INTO shj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Käxa mägaxse bow tä päxä 'doga bälaxang, mändey mägaxse bow tä wegka mangeccä, yä käxa mägaxse jul sogo raj tä päxä 'doga bälaxang, mändey sogo mänang tä wegka mangeccä. ");
INSERT INTO shj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Känox gang mägaxsägi bow tä menekä tangandägkä walangic songang, zogowa key mägaxsägi laye bow tä tangandäg tä pang Kalägi tiyating? ");
INSERT INTO shj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndä känox mägaxsägi bow tä menekä wegkä käxa caka songang, xänang togodung känggi täging? ");
INSERT INTO shj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Me wexetandäng päx wexecce ta bazuwecciny pädax song, xa nyäsogo 'do paye nuxung paccey yä saxe nuxung. Mändey nuxus nyäsog gigili nuxung yä ndäridäswa tä nuxung. Kigkandäng dacada wexe ngakä Kaläg na ngakä male song.” ");
INSERT INTO shj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisinygi paye ngakä male pacceyang kädäng ngaki Yasuwa kalegey kä'dayang, na sagug ma näs anyad. ");
INSERT INTO shj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Neng Yasuwa ngade täsa ka, “Anggo läpedeng ngastänggägo tagä kän ka anggo mpoccang na'do yä dara Kaläg yex ngakä mäganygägo. Wegkägogi ngoxodänang nang tagä kän na tä warä känang, tas tagä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Asiriyenä Musa na sorunu menggä logey kawexse tä loydägkä ow basa Yoxana me Pac kawung. Ndä kala yaxsäwecci apo lege ngakä bugundugku Kalägkang duwaleywa ndä kala kän kä'day kasägkesäno ndey ka läs bugundugku Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Zäkoxa na täzäg way winy 'diti päxä munu jengicca sacarasa ta asiriyenä Kaläg ka werwa. ");
INSERT INTO shj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Käxa kasax uxe ndä 'doc bag uxa cakang, kasog ramic, ndä käxa kabag uxa yoxe kasaxang, ramacca.” ");
INSERT INTO shj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yasuwa ngade ka, “Apangandäng kadangandey ndä lagewa na tanduga dulatulajeccä ndä todotol siye siyaka apoccu. ");
INSERT INTO shj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ndä apangandäng säbangäs Liyasir wane bägälic käpoposu wunodung sängo tä akäsogaldä pang nyapangzi kadangandeyang, ");
INSERT INTO shj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","paye ka 'dox enggä siyaki teldeccä tä tumunu siyakämang ndey ka si. Ndä isu wunosung laxte wanämani käpoposung. ");
INSERT INTO shj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na kala ani Liyasir käxsäsang, malayikada kabag ma kagoyas ma tä owdi Apraxim tängang. Na apangzi kadangandeyang mändey käxsä na sabosu. ");
INSERT INTO shj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na mägä'doc tä mas na mägäsa tiyati moxada Apraxim täxande na Liyasir käcca tä wane käsac. ");
INSERT INTO shj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na mabandäsa ka, ‘Wawa Apraxim, wanga agägi wayesäng tagä, lapi ta Liyasir ka mä'doc mäluji päxä andäma tä ma mäwung mädälbes tä nyipärang xa agänanganang tä cäläxtäg tä mas.’ ");
INSERT INTO shj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Na Apraxim kabuc täma ka, ‘Atä, bäli ka tä cuku gi täzäg kä'dox wegkä apoccu kä'day yä Liyasir ka'dox wegka apoccu song, tabewa winy. Neng gang ma mägäluki buduldug yä gi käwalas tabi. ");
INSERT INTO shj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ndä tä ngakong kä'dayakang, salu ow tägog tä pidi ndey ka kängga paye ca'dsa wuno tanggo tä owdiyang, wunosung song na kängga tanggo tä owdi paye wuno täwas tä owdongang, cogo owduskonong song.’ ");
INSERT INTO shj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Na sax mändey apangzi kadangandeyang ngade ta Apraxim ka, ‘Wawa, ampaye gi ka yaxsa Liyasir tä menggä panäsko täzäg ");
INSERT INTO shj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","xa enggä bongguskotäng kawangasa mädäg ndey Liyasir 'doc daxä sa ndey säccagä exenggäsa ndakä sädelese tä mas ka'das agä.’ ");
INSERT INTO shj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Neng Apraxim ngade täma ka, ‘Asiriyenä Musandäng na sorunu menggä logey wanga sa sädäng ngaki legeng.’ ");
INSERT INTO shj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na apangzi kadangandeyang ngade ka, ‘A'a, wawa Apraxim, basa nuxung käxa käxsä kangäsa tä xäs kä'doc kaläpe ngakong täsang, säxajeccä säwange ngaka tasiny.’ ");
INSERT INTO shj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Neng Apraxim kämeley täma ka, ‘Känox sägädäng ngakä me logey Musa na menggä logeygi nasa songang, kax kig äxsä ndä ngäsa 'doc läpe nga täsa na sädänge säxong.’” ");
INSERT INTO shj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yasuwa ngade tä menggä räbke ka, “Bäli ka ngatatäng wunosung gawadas anggo tä ngaka tasiny! Ndä woyoy tä känggi 'docco sogongang! ");
INSERT INTO shj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ndä käxi kädäppa ka 'doco sogong, saxsa ngayiccä ngorey tä ngase ndä sägawa nang tä colonggo 'diti togku känggong mäganyga bowinyang tä sogku ngaka tasiny. ");
INSERT INTO shj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Meskäde ngastänggägo. Känoxang päxä bonggo sogo ngaka tasinyang, duxi ndä mägäxajä mawang ngaka tasinyang, zaxi täma. ");
INSERT INTO shj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kax mäsog ngaka tasiny tägi taxä paxtänding tä xongonda nuxung ndä mämeley ngasäma mäwung tägi taxä paxtänding mangad ka, ‘Agä kaxajä tä sogku ngaka tasinyang,’ saxi täma.” ");
INSERT INTO shj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na känggi Yasuwa käligäng ngadeccä täma Bazuwec Yasuwa ka, “Posa menekä ngakä Kaläg täwas!” ");
INSERT INTO shj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Bazuwec kabuc ka, “Kä'dang menekä ngakä Kaläg tanggo biyey kala päxä yugicca biyeyang, kax läpeng tä etong ngoteyang ka zuduwa na mäxke 'doc udusawa tä kaxsä colonggo, na dänge ngakägo. ");
INSERT INTO shj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Päx nuxung accägondäng cäläxse päkädäng pelow na cong näs megäskä sagunuwang na läpede tänya cäläxseneni ka, ‘Bo icca siysi?’ ");
INSERT INTO shj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A'a, wadi gi bazuwec noco läpede ta cäläxsägi ka, ‘'Dayawa, wexe siyad ndey dogung siyad tagä accäg asiyza na awuxsi ndä kala gang gi ziyza na wuxsi.’ ");
INSERT INTO shj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bazuwec logo cäläxse xa ka kasog ngaki maläpe tängang song, päx mälogo täng? ");
INSERT INTO shj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anggo mändey käwexeng wexeki agä kaläpäng tanggo ka wexengang, kax wexeng na noccang ngadaccang ka, ‘Was anäsig cäläxinyga täbangä wexeki wexedäningang nenyang kandäppig dädäxti song.’” ");
INSERT INTO shj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ani Yasuwa kä'docus tä Ursalimang, mägälang pidänä Samriya na Calil. ");
INSERT INTO shj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mägä'doc ngäte tä päxä cabär, na apanginyatäng layis menggä omoda asiny käpasasa täma na kadenggeze täxande, ");
INSERT INTO shj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kädawasa ngadeccä ka, “Yasuwa, Bazuwec, wanga agägi wayesäng täwas.” ");
INSERT INTO shj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mägäxo sa na mäläpede täsa ka, “Wesi pari ngastänggägo ta menggä tämed tä Kaläg ndey säduwaley ka wadäkägo kalaye apoccu.” Na kala säwedetese na sa'doxung wadäkäsa kädäxäno salaye säpoccu. ");
INSERT INTO shj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na nuxung accäsa kox wane kalay apo na kämel dawe dädäxti Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kä'doc kädukurusa tagä Yasuwa logo Kaläg, ndä ma 'doxti me Samriyang. ");
INSERT INTO shj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na Yasuwa ngade täma ka, “Kandäxä anggo näsang asiny song? Kulung känggi paye nuxungang sati? ");
INSERT INTO shj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Basa me pungudongang tol kämel kawung kädädäxti Kaläg tä ngakä däxkeneng?” ");
INSERT INTO shj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na tänya owdi Yasuwa läpede tä nya me Samriyani ka, “Ngäsa wede xa menekä ngakägi tagä kädäxä gi.” ");
INSERT INTO shj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Xongonendäng kulung Farisiny kamän Yasuwa ka, “Xongonda keyang bugundugku Kaläg wunosung tängang?” Na Yasuwa kabuc ka, “Bugundugku Kaläg wunosung na bolu de oxowa song. ");
INSERT INTO shj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Oxowa ndey ka anggo ngadang ka, ‘Nyanang!’ na, ‘Nyani!’ song. Bugundugku Kalägkatäng nanggo kala.” ");
INSERT INTO shj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yasuwa ngade tä menggä räbke ka, “Owandäng wunodung ndä anggo noccang mpadang ka zang cukang, agä Päxä Käxa Jul tä butug, ndä zadang säxong. ");
INSERT INTO shj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ndä kän ngadeccä tanggo ka, ‘Lala, mani todi!’ na cong ka, ‘Lala, manang todong!’ Ndä ndakä ndängeng ngakäsa. ");
INSERT INTO shj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Xa agä, Päxä Käxa Jul, xongondeneni awunodung kala wuxekä koxana banye tiyati na ota kä'day. ");
INSERT INTO shj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Ndä täzäläg basa agä anycäläxtiwa tä weg mange na mändey menggä zong pexkä agä. ");
INSERT INTO shj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ka'das wexeki kän kawex tä xongondu 'doxti säbangäs Noxang, mändey kän wexe sawexeki basa xongondi agä, Päxä Käxa Jul awunodung tängang. ");
INSERT INTO shj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kän siyacca na wuxicci na batacca na sädere bal koxasa xongondi Nox kaläsa kaxsä dämpejigseneng. Na faya kawung kapax kän kä'day. ");
INSERT INTO shj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Winy ka'das ani tä xongondu 'doxti säbangäs Lotang, kän siyacca, wuxicci, nganyacca ndä nganyatasa, ndä zäbecce na tonyacca, ");
INSERT INTO shj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","neng xongondi Lod kawetäs tä kaxsä pana säbangäs Sudumang, Kaläg kayaxsä mas na nganyuga kusuccu kaduny kän bägälic. ");
INSERT INTO shj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndä kän wexe nya bangongang, mändey laye kala xongondi agä, Päxä Käxa Jul aweyetesawa tängang. ");
INSERT INTO shj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ndä tänya xongondi, käxi täzä ax yä wegke tä axang, ndakä coccoleza ndey ka bag wegke song na mändey känggi tä pelowang ndakä mele tä pa song. ");
INSERT INTO shj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gärning ngaki kasoguno tä uxu Lotang! ");
INSERT INTO shj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Käxa paye ka meske rongicce täzägkang wadi mesede yä käxa meske rongicce täzäg songang 'doxo aygä liliy. ");
INSERT INTO shj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aläpedäng tanggo ka ongudeneni kän tugu salany pädapädax, ndä Kaläg bate nuxu yä nuxu laye. ");
INSERT INTO shj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Mändey uxu pädax tugu ngoreygä kuny tä ngayicca nuxu, ndä nuxu ux säbate yä nuxu laye.” ");
INSERT INTO shj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na kala menggä räb kamän Yasuwa ka, “Tä owda key, Bazuwec?” Na mabuc täsa ka, “Owda wininy kädurisäno tängang, bäli ka wegka käxsetäng täng.” ");
INSERT INTO shj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yasuwa kaser nga tä menggä räbke ka palacca todotol ndakä cananga. ");
INSERT INTO shj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mängade ka, “Buguningandäng tä nuxu bo pandäng nyigate Kaläg song ndä nyaye kän song. ");
INSERT INTO shj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ndä mändey mandurandäng tänya bo pani wunodung melde täma läpede täma ka, ‘Bo geye was na me kurang ndey ndäppoy was.’ ");
INSERT INTO shj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Täzälägäne buguning kalewa, neng magärtä ngaki mandur melde tängang, na mängade tä ngasäma ka, ‘Agä anyigate Kaläg song ndä anyaye kän song, ");
INSERT INTO shj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ndä mandursong nyanang gang nyalange agä todotol, bal anoc agey ta me kure xa cämelde tagä cäwange agä anungu song.’” ");
INSERT INTO shj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Yasuwa ngade ka, “Ndänge sele ngakä buguningza däppo kän song! ");
INSERT INTO shj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yä päx nya Kaläg nyädäppo känggänyagi nyalebäng ngeyeccä tänya säxe na ongutang song? Yä päx Kaläg waxe posakä kän? ");
INSERT INTO shj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aläpedäng tanggo ka Kaläg däppo kängge tetex, yä tä wunakang agä, Päxä Käxa Jul, päx awunodung a'doxodung menekä ngakä Kaläg täzäg?” ");
INSERT INTO shj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mändey Yasuwa kaser seredäniccong ta kulung känggi kabogkasa ngastängga ka yex ngaki wexeng ndä laleyis kän kängga winyang ka, ");
INSERT INTO shj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Apanginyatäng pädax kä'docco taxä tämed tä paley, nuxung Farisiccang yä ani nuxungang me yawgä tulubang. ");
INSERT INTO shj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Na Farisic kangäsa tiyati kapaleza ngade ka, ‘Kaläg, alogo gi xa agänangang kala kulung kän song, kala menggä celdug song, na kala menggä ngananganegä nga song, na kala menggä ramiccu song, ndä agäng kala me yawgä tulubanani song. ");
INSERT INTO shj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tä sängga paxtinding, agä amene uxkud tä sängga pädax ndä aluwu asiny tä wegkanggi a'doxo udiny mädägkang (100) adogodung tägi.’ ");
INSERT INTO shj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Yä me yawgä tuluba kädokol täxande ndä gunusawa na zänggä mayad ngade ka, ‘Kaläg, wanga agägi wayesäng tagä, xa kasog ngaka tasiny!’ ");
INSERT INTO shj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Aläpedäng tanggo ka kala tä 'dockäsa tä pa, Kaläg kagixi me yawgä tuluba xa mägaxse bow, yä Farisic, Kaläg kagixi song. Käxa poko ngaseneng, Kaläg maye ze yä käxa coccolo ngaseneng, Kaläg pokada tiyati.” ");
INSERT INTO shj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xongonendäng kän kagoying engga ta Yasuwa ndey ka mäpes. Neng menggä räb kox mänang, na sadux kän ka dokalas koyinakä pipu. ");
INSERT INTO shj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Neng Yasuwa kabandä pipu ka, “Wanga pipu wuno tagä, ndakä zekeng sa xa känggi 'dase pipugongang bugundugku Kaläg känanag. ");
INSERT INTO shj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aläpedäng zänggä nga tanggo ka, käxa käpay bugundugku Kaläg kala päxä pipi songang, Kaläg kixidi tä bugundugke song.” ");
INSERT INTO shj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Xongonendäng bazuweccä Yaxudinyandäng kamän Yasuwa ka, “Me bäldic, gi mpoyo na'do, asogowa key ndey a'dox aygä liliyang?” ");
INSERT INTO shj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Yasuwa kabuc täma ka, “Oxadi kasog gi bangäs agä käxa apong? Käxa apondäng song, basa Kaläg nuxundugke. ");
INSERT INTO shj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anggo yexeng täsedänic ngade ka, ‘Acaka rameyza, acaka paxsa, acaka pälze, acaka lege celdug, nyaya menggo na bonggo.’” ");
INSERT INTO shj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na nya bazuweccä Yaxudinygi kabuc ka, “Cawu biyeydägkang agändäng awexe ngakong bägälic.” ");
INSERT INTO shj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yasuwa kädäng mänang, na lapada täma ka, “ 'Dogkandäng nuxung musku käsog song. Nganyi wegki täging kä'day larti tä känggi widunong ndey dangandey tä pang Kaläg tiyati. Ndä bag bangang.” ");
INSERT INTO shj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ani 'doxti kädängäs ngaki Yasuwa kalegey mänangang, mägaxse ka'dexwa xa madangandey nano. ");
INSERT INTO shj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yasuwa kox mänang na ngade ka, “Bede paccey tä käxa kadangandey ndey ka läs bugundugku Kaläg! ");
INSERT INTO shj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tireneng ka kamalä läso axä wuladä 'diti käxa kadangandey tä läsakä bugundugku Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na känggi kädängang ngadeccä ka, “Neng gang mänangang xänang seley xonyo ngaseneng?” ");
INSERT INTO shj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na Yasuwa kabuc ka, “Käxa seley xonyo ngasenendäng song, basa Kalägkang tol xonyaccang.” ");
INSERT INTO shj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Putros ngade ka, “Lala, kawangesänig wegkäsko kä'day ndey ka abagig banggi!” ");
INSERT INTO shj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na Yasuwa ngade täsa ka, “Aläpedäng zänggä nga tanggo ka, käxa tanggo kawangasa pane na uxe na enggä bongga na mena na bona na pengge ndey ka wex ngakä Kalägkang, ");
INSERT INTO shj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nyäposo täng mange mo'do aki kalayeng tä jendong na ur'dug tä 'doxakä aygä liliy.” ");
INSERT INTO shj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yasuwa kabag känggenegi käligä asiny wang pädaxang, kä'doc nang tä cengic na mäläpede täsa ka, “Kala lala, 'doccig tä Ursalim, ndä ngaki kä'day menggä logey gärekärejesa tä ngakä agä Päxä Käxa Julang, 'docco 'desetäsäning tä owdi. ");
INSERT INTO shj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kän 'docco menedes agä ta asänggä känggi näs Yaxudiny songang, sä'docco sängobo agä, säcäläxti agä ndä säpädadas agä. ");
INSERT INTO shj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sä'docco säbade agä na ke'diccä oxay, säpaxe agä ndä asängo pädax na tä sängädi kodosang angäsata tä xäs.” ");
INSERT INTO shj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Neng känggi mägäligä asiny wang pädaxang, kabäle bangä ngakämagi song, xa legeygi malegeyang kacungguli sa. Sabäle bangä ngaki Yasuwa lege täsang song. ");
INSERT INTO shj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ani Yasuwa kawunäs ngäte ta Arixang, apangandäng näs ngojox käcca tä nyixtä akäsog nyäxacca. ");
INSERT INTO shj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na mägädäng tädäxä kän na mamänze ka, “Oxadi kiyang kasiwang?” ");
INSERT INTO shj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na säläpede täma ka, “Yasuwa me Nasra nyang wedeng.” ");
INSERT INTO shj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na kala mabandäsa ka, “Yasuwa, päxä pe Dawud, ata agägi wayesäng tagä!” ");
INSERT INTO shj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na känggi kädoleyzang kadux ma ka mäpäla neng mägädawa paccey ka, “Päxä pe Dawud, ata agägi wayesäng tagä.” ");
INSERT INTO shj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na kala Yasuwa kädokala läpede ka sägoyung ngojox täma ngäte. Sagoyung ma ngäte na Yasuwa kamän ma ka, ");
INSERT INTO shj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oxadiyang mpaye agä asog täging?” Na mabuc ta Yasuwa ka, “Bazuwec, soga agä azayza mändey.” ");
INSERT INTO shj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Yasuwa ngade täma ka, “Laleyzi, menekä ngakägi tagä kaxony gi.” ");
INSERT INTO shj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na tetex agäma kalengesuno na mabag bangä Yasuwa, mädädäxti Kaläg. Kän kä'day kox mänang, na kädädäxti Kaläg mändey. ");
INSERT INTO shj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yasuwa kadus bo pana säbangäs Arixa. ");
INSERT INTO shj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ndä apangandäng tänya owdi säbangäs Zaka näs ngotorponu menggä yawgä tulbada kadangandey. ");
INSERT INTO shj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mäpaye ka mälaley Yasuwa neng mädäläng tä warä xä'dä kasog ma moxo Yasuwa song. ");
INSERT INTO shj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Na mägoy tetex mapäcca mägä'doc ma'deg zä balasu ndey ka mox Yasuwa, xa Yasuwa 'doco lange nya sogi. ");
INSERT INTO shj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ani Yasuwa käcogus owdumaniyang, koxas ma tiyati täzä ed na ngade täma ka, “Zaka, coccoleyzi tetex bo xa xongondong 'doccig cuccig tä panägi.” ");
INSERT INTO shj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na tetex Zaka kacoccoleza kä'doc kabokasa Yasuwa tä pane na led. ");
INSERT INTO shj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kän kä'day kox mänang na kangunungunizi ka Yasuwa kä'doc kalayis palangasiccä käxa sogo ngaka tasiny. ");
INSERT INTO shj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Neng Zaka kangäsa ngade ta Bazuwec ka, “Lala, Bazuwec, agä alare wegkang tä pidi adogada kulung tä menggä wiy, na mändey kasog käläkäläjtäg tä wegkä nuxu kigkang amelede 'dogi payeng täng taxä tesped!” ");
INSERT INTO shj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na Yasuwa ngade täma ka, “Xongondong Kaläg kaxony panong, xa Zaka tirä päxä pe Apraximang! ");
INSERT INTO shj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xa agä, Päxä Käxa Jul kawung tä nyam na tä xonyakä kängga kämese.” ");
INSERT INTO shj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ani xä'dä deldeyäs wungga tä legeygä Yasuwang, mawung ngäte tä Ursalim, ndä kän oxo ka bugundugku Kaläg kala wunosung käccogos. Na todi maser nga täsa. ");
INSERT INTO shj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mängade ka, “Päxä pe buguningandäng kä'doc tä walangicca täxande ndey ka sädoga butug täng ndä mel. ");
INSERT INTO shj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na kala ka mä'doco na mabandä cäläxinygäma asiny mägälarta ariyaliny täng asiny ka däseydä basa mämel mäwung. ");
INSERT INTO shj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Neng känggäma paye ngakäma song na sayaxsa menggä yaxsäwiny ka läpe ka, ‘Ampayedig 'doxtong layis buguningzäsko song.’ ");
INSERT INTO shj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ani mägä'docus sadoganäs butug täma ndä mämeläsang, mabandä cäläxinygämagi madoga ariyaliny täng ndey ka däseydäng. Mäpaye mäbäle wegki sa'dox tä zängganang. ");
INSERT INTO shj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Cäläxsi täzälägkang kapäcca täma ngade ka, ‘Bazuwec, ariyalicci kädogung tagä nuxungang, kawexä ka'dox täze asiny.’ ");
INSERT INTO shj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na buguning ngade täma ka, ‘Käwexä apo, gi näs cäläxsa apo! Xa mägaxsägi bow tä päxä 'doga bälax, asogus gi ngotorpo mene kaxsänggä padäg asiny.’ ");
INSERT INTO shj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na mändey pädaxeneni kawung ngade täma ka, ‘Bazuwec, ariyalicci kädogungang kawexä ka'dox täze mädäg.’ ");
INSERT INTO shj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na buguning ngade täma ka, ‘Gi noco mene kaxsänggä padäg mädäg.’ ");
INSERT INTO shj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Na kodoseneni kawung täma ngade ka, ‘Bazuwec, ariyalicci kädogung tagäng nyanang kamulungiy na päxä nyonggo kayokas. ");
INSERT INTO shj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xa anyigate gi xa ayex gi ka näs apangza mägaxse täbag na'do. Ndä gi bate maleni layis nänggi kä'dangas songang ndä jede wegki käzäbä songang.’ ");
INSERT INTO shj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na buguning ngade täma ka, ‘Agänang amene gi tä legeygä ikägi, gi näs cäläxsa kadawustey! Yex ka agä anäs buguningza mägaxse täbag abate maleni layis nanggä ka'dangas songang, na ajede wegki kazäbä songang? ");
INSERT INTO shj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Neng wi siye gi kä'danga ariyaliccang tä axä owdu däsey ndey koyung ze songang?’ ");
INSERT INTO shj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Na buguning ngade tä menggä wexekenegi dokoloccung ka, ‘Gujuyning ariyalicci tämang tunyu dogi tä cäläxsong käne asinyang.’ ");
INSERT INTO shj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Neng sängadeccä täma ka, ‘Bazuwec, noxo ma ariyalinygämatäng asiny!’ ");
INSERT INTO shj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na buguning ngade ka, ‘Aläpedäng tanggo ka käxi kädäsey wegkeneng aposo täng, yä käxi kädäsey käne songang, agujudung täng tunyu. ");
INSERT INTO shj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wadi gang menggä kuranggong paye ka alayis buguningza songang, goyining sa tagang todong dämde ngastänggä sa!’” ");
INSERT INTO shj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ani Yasuwa kä'desenäs seredäniccongang, mawetäde tiyati tä Ursalim. ");
INSERT INTO shj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kala mägä'doc ngäte tä enggä cabärtaga säbangäs Faci na Petani tä Cabärä Zayitun, na mägäpäcca menggä räbkäma pädax. ");
INSERT INTO shj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Mäläpede täsa ka, “Wesi tä päxä cabäri taggägong. Känoccang käläsangang, 'doxadang päxä kaccäna taxä nuxung kig kasana täze song kaxsasawa todi. Nyuli goyining tagä todong. ");
INSERT INTO shj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kä'doxang käxa kamän anggo ka, ‘Wi siye anggo nyuliding kaccängang?’ Läpi täng ka, ‘Bazuwec paye.’” ");
INSERT INTO shj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na sa känggi mayaxsa kapäccasang ka'doxa sangaki maläpe täsang. ");
INSERT INTO shj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sägä'docco säludi päxä kaccä na letuge mäne sa ka, “Nyuliding kaccänong koyadang ti?” ");
INSERT INTO shj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na sabuc täsa ka, “Bazuwec paye.” ");
INSERT INTO shj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na kala sagoya päxä kaccä ta Yasuwa sapetäde tandugusa tä onge ndä Yasuwa 'deg. ");
INSERT INTO shj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Masana täze na kän kapetädesa tanduga tä akäsog ndey dädäxti ma tä laxänakäma. ");
INSERT INTO shj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kala mawung käsac tä akäsogi coccolacca päkädäng Cabärä Zayitunang, na menggä räbkäma kä'day daweccä lededäning dädäxti Kaläg tä wexeki Kaläg kawex sägoxang. ");
INSERT INTO shj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sängadeccä ka, “Baxändäg tä buguningzi Bazuwec Kaläg yaxsedängang! Modeyatäng tä pang Kaläg tiyati na dädäxtiy tä Kaläg!” ");
INSERT INTO shj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Neng kulung Farisinyatäng tä warä xä'dä ngadeccä täma ka, “Me bäldic, daxa menggä räbkägi ka säpälasa.” ");
INSERT INTO shj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na Yasuwa kämeley täsa ka, “Aläpedäng tanggo ka kax säpälasa na nganyugong dawatasa dädäxti agä!” ");
INSERT INTO shj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ani Yasuwa kawunäs ngäte koxus Ursalimang, mangedä tä ngake, ");
INSERT INTO shj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mängade ka, “Anggo menggä Ursalim, kämeseng xa xongondong käbäleng ngaki koyodung modey tanggong song, neng gang kala mändey noxadang 'dogi koyodung modey tanggo song. ");
INSERT INTO shj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tä sänggi wunosunong menggä kurugo kakaradas anggo tä kaxsä cabär tä cende kä'day ndä räbadas anggo. ");
INSERT INTO shj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Säwasadas anggo käked, anggo na penggägo säwange nuxu accägo tä kaxsä Ursalim song, ndä kax ngayicca säwange täzä wayanandäng song. Ngakong sogoduno xa anggo käjenggereng na käbäleng ka Kaläg kawung tanggo song.” ");
INSERT INTO shj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yasuwa kaläs kal taxä tämed tä Kaläg mägä'doc mamagäng menggä nganyad tunyu, ");
INSERT INTO shj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","mängade täsa ka, “Gärekärejesawa tä Sorunu Kaläg ka, ‘Panang, pang paleyang,’ yä anggo käsogasang axä menggä bärada!” ");
INSERT INTO shj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yasuwa bäldecce todotol tä kaxsä kaldagä axä tämed tä Kaläg. Ndä bazuwinygä tämed tä Kaläg na menggä lelericcä asiriyenä Musa na kulung ngotorpugä Yaxudiny nyame rajsa ndey ka paxäs Yasuwa, ");
INSERT INTO shj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","neng sa'dox rakawza ndey säpaxäs ma song, xa kän kä'day kagur ma delde wungga tä ngaki mälegeng. ");
INSERT INTO shj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Xongenendäng Yasuwa bälde kän tä kaxsä kaldä axä tämed tä Kaläg na mäduwale yaxsäwecci apo lege ngakä Kaläg tä känang. Na bazuwinygä menggä tämed na menggä lelericcä asiriyenä Musa na ngondowinygä Yaxudiny kawuno täma ");
INSERT INTO shj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ngadeccä täma ka, “Lapäng, xänang kä'dakas gi ka wexseng? Xänang kadong butug tägi ka wexseng?” ");
INSERT INTO shj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Neng Yasuwa kämeley täsa ka, “Amäne anggo mäned ndä anggo buci tagä. ");
INSERT INTO shj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kalägkang kä'daka Yoxana ka pacä känang, wala känag kä'dakas ma ka mäpacsang?” ");
INSERT INTO shj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na sacengesuno tä cengic sabodsa watäkäsa sängadeccä ka, “Kax 'doccig ngadig ka, ‘Näs Kaläg’ na mä'do mängade ka, ‘Wi siye anggo kämeneng ngakä ma Yoxana songang?’ ");
INSERT INTO shj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ndä mändey kä'doccig kängadig ka, ‘Näs känang,’ kän kä'day 'däme kog na nganyu, xa kän oxo ka Yoxana me logeyang.” ");
INSERT INTO shj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na sägä'docco sabuc ta Yasuwa ka säyex käxa kä'dakas Yoxana ka pacsa song. ");
INSERT INTO shj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Yasuwa ngade täsa ka, “Neng aläpedäng käxi kä'dakas butug tagä ka awexse nangang song.” ");
INSERT INTO shj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yasuwa kaser legey tä kän ka, “Apangandäng käsäbä pelowge, ndä menes tä menggä pelowatäng ndey meskädä yä kä'doc tä wedäg kalaygädä. ");
INSERT INTO shj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kala weg kiye de säjede na mayaxsas cäläxsäma ka 'doc täsa menggä pelowgi mamene zäg tängang, ndey ka larä weg toga käma. Neng sa menggä pelowgi mamene zäg tängang käbadä cäläxsäma ndä matas täma na asängge päloccu mänang. ");
INSERT INTO shj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sax mändey mägälasä mayaxsa nuxu cäläx. Na mändey salandä ndä säbadä ndä sämatas täma na asängge päloccu. ");
INSERT INTO shj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sax mändey mayaxsa kodoseneni. Ani kala sägäbadä sägämexestey ndä sämaga tunyu. ");
INSERT INTO shj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Na ledä pelow ngade tä ngase ka, ‘Oxadi asog gangang? Basa ayaxsas tirä päxä penenggong ampaye ngake pacceyang nuxus sä'doc sänyay ma.’ ");
INSERT INTO shj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ani känggi samene zäg täng koxäs nya penämaniyang, sägaxsäning sängadeccä ka, ‘'Doxtongang luguccing, nycugo apaxa ndey lugig pelowge!’ ");
INSERT INTO shj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na tetex samen ma sabokung ma tunyu tä kaxsänggä pelow sägä'docco sapax ma.” Na Yasuwa kamän sa ka, “Ledä pelowgi kamenes pelow täsang sogo sa key? ");
INSERT INTO shj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ma mäwunodung mäpaxe känggi mamenes pelow tängang yä mädogada tä kängga cakuny.” Na kala kän kädäng ngakong na ngadeccä ka, “Nyäzekä ngakong ndakä soguning mänang!” ");
INSERT INTO shj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Neng Yasuwa kalaley sa käteg na ngade täsa ka, “Ngaki gärekärejesuno tä Sorunu Kalägkang ngadeccä ka wi? Ngadeccä ka, ‘Ngayicci menggä tonyad käpexkäng kalayis ngayiccä saluweccä kadasuweccä ax.’ ");
INSERT INTO shj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndä käxa kadel täzä nya ngayicciyang, nyäroborobogo yä käxa nyadeles zeneng, nyäregeregeje.” ");
INSERT INTO shj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na tänya axä owdi menggä lelericcä asiriyenä Musa na bazuwinygä axä tämed tä Kaläg paye ka men ma xa sabäle ka maser ngaki täsa, neng sänyigate kän. ");
INSERT INTO shj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ngotorpodagä Yaxudiny jenggere Yasuwa käsac ndey ka sä'dox rakawza sämenäs ma na sayaxsas menggä raj ka 'docco paxesäning käräp sogosuning kängga apoccu. Säpaye ka sädäng legey tä ikäma ndey sämenenäs ma tä andä buguningzä Romaniny. ");
INSERT INTO shj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na menggä raj ngadeccä täma ka, “Me bäldic, wa ayexig gi ka nycofu'dono legey ndä bälde zänggä nga tä ngakä Kaläg. Ndä päx gele kän song. ");
INSERT INTO shj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gang kädäppa ka wa ayawig tuluba adogig ta Kaysar wala awangig toke?” ");
INSERT INTO shj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Neng Yasuwa kabäle rajsi tä mäganygäsang na mängade täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Doguning dinarsä Romaniny tagä. Läpäning ligidä xänang na agä xänang gärekärejesuno tä ongeneng?” Na sängadeccä täma ka, “Näkä Kaysarang.” ");
INSERT INTO shj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na Yasuwa ngade täsa ka, “Dogi wegki layis gäkä Kaysarang ta Kaysar, na aki layis käkä Kalägkang dogi tä Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na tänya owdi sägädongasa tä ngaki malegeyang na sa'dox rakawza ndey sämenäs ma tagä kän song, na sägämolosuno. ");
INSERT INTO shj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kulung menggä Yaxudinygi säbangäs Saduginy, ngadeccä ka kig äxse ngäsata tä xäs songang, kawuno ta Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Sängadeccä täma ka, “Me bäldic, me logey Musa gärekärejesa nga täwas ka apangza päxä bona kabagsa ndä äxsä yä kiyäng pipu songang, päxä bona bag nya mandursi ndey iyäng pipu tänya päxä bonanani käxsäng. ");
INSERT INTO shj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ndä enggä bonyatäng paxtinding. Päxä bonanani täzälägkang kabagsa ndä käxsä kawangasa uxe kiyäng pipu täng song. ");
INSERT INTO shj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ndä ani täbangeneng kasog mänang. ");
INSERT INTO shj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kodoseneni kasog mänang. Sägädoneydä batakä ce uxi ndä sägäxse na'anggäsa paxtinding sägiyäng pipu song. ");
INSERT INTO shj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na ce täzäce cägäxse tä bangäsa. ");
INSERT INTO shj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gang mänangang, xänang täsa 'do layis yoxuce tä xongondu ngäsad tä xäsang, ndä na'anggäsa sägädoneydä batakä ceng?” ");
INSERT INTO shj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na kala Yasuwa ngade täsa ka, “Menggä zong batacca na säbate. ");
INSERT INTO shj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Xa känggi lelexiny, ur'dug ngäsotäsäng tä xäs tä xongondu ngäsad tä xäsang, batacca na säbate song. ");
INSERT INTO shj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndä sa mändey säxseccä song xa kala sa'das malayikada. Säs enggä Kaläg, xa sänguso sa tä xäs. ");
INSERT INTO shj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mändey me logey Musa kabäle ka käxa käxsä ngäsata tä xäs. Ka'das ani gärekärejesawa tä Sorunu Kaläg tä ngakä masi kagusi ta Musa tä kaxsetang, ani mabandäs Kaläg ka Kalägä Apraxim, Kalägä Isxag na ka Kalägä Yaxubang. ");
INSERT INTO shj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kaläg Bazuweccä kängga oxaccang, päx näkä kängga käxseng song. Xa kän kä'day ayeccä tänya.” ");
INSERT INTO shj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na kala kulung menggä lelericcä asiriyenä Musa kabuc tä ma ka, “Me bäldic, gi kälegeyze apo na'do!” ");
INSERT INTO shj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na todi sanyigatas mänekä ma. ");
INSERT INTO shj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Neng mängade täsa ka, “Oxadi siye sa sängadeccä ka Almasi näs päxä pe Dawutang? ");
INSERT INTO shj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawud täze ngade tä Sorunu Masmur ka, ‘Bazuwec Kaläg kangad ta Bazuweccang ka, “Bo icca tä cengiccä andä abaniccang, ");
INSERT INTO shj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bal asog gi nyebesa menggä kurugi täzäg.”’ ");
INSERT INTO shj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Dawud bangäs ma ‘Bazuwec,’ yä mälayis päxä pene key?” ");
INSERT INTO shj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ani kän kä'day deldeyäs wungga ta Yasuwang, Yasuwa ngade tä menggä räbke ka, ");
INSERT INTO shj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Meskädäning ta menggä lelericcä asiriyenä Musa. Xa säpaye lagkä tanduga apoccu säwalangeccä nang ndä säma'dite modey tä owtagä nganyatada na säpaye cad tä owtagä dädäxti tä axinygä paliccinygä Yaxudiny na owtagi sänyaye ngotoropu täng tä siyatang. ");
INSERT INTO shj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yä sägäläkäläji wegkä manduriny ndä sädertesäno säpalacca mäna'ang. Känggi kala akakiyang, sag seley Kaläg 'doco cäläxti ta'asang.” ");
INSERT INTO shj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yasuwa jenggerecce tä axä tämed tä Kaläg na kox känggi kadangandeng gawdadas wegkanagi kabegse nangang tä kaxsä cokonu yawgä weg tä Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na mändey mägox mandursa wiwandäng gawa enggä ariyaliny pädax tä kaxsä nya cokoni. ");
INSERT INTO shj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na mängade ka, “Aläpedäng zänggä nga tanggo, lala päxä me wiygong näs manduranang nyang gawa wegke kamo'du kän kä'dayang. ");
INSERT INTO shj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Xa känggong kä'day kabegsekang kabag weg tä zänggä wegkä tangandägka ndä toga, yä ce satäng täce kätogo'dog song yä cabag kä'day cadoga tä Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Xongenendäng känatäng legecce tä ngakä axä tämed tä Kaläg, tä wegki kabastäning na nganyugi wuxeccä täwang axang na wegkä beged, na Yasuwa ngade täsa ka, ");
INSERT INTO shj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gang anggo nycuccang jenggeredeng wegkong xa owandäng wunodung kax ngayicca tenggelecce täzä wayanandäng song, säcobatasa täzäg kä'day!” ");
INSERT INTO shj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na samän Yasuwa ka, “Me bäldic, sangakong bägälic kälegeyang sogoduno ogey? Na oxadiyang layis boluge läpedäng ka ngakong sogoduningang?” ");
INSERT INTO shj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na mängade täsa ka, “Meskädäning xa acaka sänanangey anggo xa kulung känatäng mange wunosung nanange anggo nagang, ngadeccä ka, ‘Agänang anäs Almasiyang,’ ndä kala, ‘Sanydä ow kawung.’ Acaka anggo ndängeng ngakäsa! ");
INSERT INTO shj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ndä kändängeng pogud na keley na kamatang, ndakä nyigatäg men anggo. Xa basa ngakong wuno kayesäno täzälägäne tä loydägkä ow. Ndä sanydä ow wunodung tetex song.” ");
INSERT INTO shj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yasuwa ngade ka, “Pogud ngäsata tä cabärta, ndä buguninginy pogo ngastänga. ");
INSERT INTO shj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ndä mändey wäxäd na buxu na täxäd wunosung 'da'de ota mange ndä nyigatäg mene kän na mändey tädäxtäg na bolu päkätäsäng tiyati. ");
INSERT INTO shj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ndey ka ngakong kä'day sogoduno, sä'docco täzälägäne sämen anggo säcäläxti anggo na sämenedes anggo tä asänggä menggä axä paliccä Yaxudiny na särikidis anggo tä ax. Sägodung anggo tagä buguninginy na tagä turuginy xa anggo kämeneng ngakang. ");
INSERT INTO shj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ndä xongondeneni layis akäsog tanggo ndey läpeng ngakang. ");
INSERT INTO shj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ndakä gäredeng 'doga noccang legedeng tagä buguninginy ndey ka mäxising nang. ");
INSERT INTO shj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Xa agä anoco alägi anggo na turaydey tä 'doga noccang legedeng ndey ndakä menggä kurugo mo'du anggo. ");
INSERT INTO shj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Menggägo na enggä bonggo, na wayakägo na biskodagägo 'docco menedes anggo de sogo kulung acänggägo säpaxe. ");
INSERT INTO shj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na mändey kän kä'day 'docco saxe anggo xa anggo kämeneng ngakang. ");
INSERT INTO shj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Neng tä ngakong kä'day, 'doga zegeledäng rongiccägondäng song. ");
INSERT INTO shj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ndä mäganygä padätägkägo tä ngakang sogo anggo liliccing ur'dug.” ");
INSERT INTO shj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Neng xonga känoxang Ursalim kagukuriwa na asägaruwang, ndey kala bäleng ka wanyiske kawuno käsac. ");
INSERT INTO shj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ndä känggi tä cabärä Yaxudiyang basa oyasa tä zänggä cabärta. Mändey känggi tä kaxsä Ursalimang, wulageccä ndä känggi tunyang ndakä läsa, ");
INSERT INTO shj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","xa sa sänggi Kaläg cäläxti menggä Ursalim tängang, nyang ndey ngaki gärekärejesänong 'desesäning. ");
INSERT INTO shj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Ndä tänya xondi kawungang woyoy tä uxugi kä'dosuning na 'deyecceng! Xa todi kän zäyazäyangedäning täzäg na bälede xuxubtäg. ");
INSERT INTO shj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sädelgetese ta asänggä menggä salu na menäs sa cäläxiny tä warä kän. Känggi näs Yaxudiny songang 'docco paxatasa Ursalim na teretereje basa xongondäsa 'desedeswa.” ");
INSERT INTO shj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ow kawungang, noxadang bolu tä xong tä asämex na tä nyinyiwes ndä kän kä'day täzäg wiyazeccä na käre ngakä xuduxudigä colonggo na dampajeygä ma. ");
INSERT INTO shj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nyigatäg mene kän togada tä woldoxey tä 'dogi sägox wunodung tä walangiccang, xa panggudugki tiyating kala gi'dikidäning seley. ");
INSERT INTO shj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Na kala kän oxo agä, Päxä Käxa Jul ampagacca tä däminggaru na panggudug na tädäxtic. ");
INSERT INTO shj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Neng wegkong kasogunongang, ngusosäning bolosuning na mäganygä pädätäg xa kala 'dakiccägo kacecce'deyze ngäte.” ");
INSERT INTO shj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yasuwa kaser nga täsa ka, “Lala etä 'dami na kulung ewegong bägäliccakang. ");
INSERT INTO shj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Känoxang wungga lilixiccing, na bäledeng ka kala wiwilis ngäte. ");
INSERT INTO shj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mändey känoxang ngakong sogoduningang kala bäli ka bugundugku Kaläg kasextesäng. ");
INSERT INTO shj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aläpedäng zänggä nga tanggo ka menggä zong äxseccä song basa ngakong soguno. ");
INSERT INTO shj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zäkoxa na täzäg 'desetäsäno yä legeygang wayeccä song. ");
INSERT INTO shj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mesekädäning ndey acaka mäganygägo pägäni ndaldänang tä tawustäg na tä wuxid de bux paxe anggo, na kärekä ngakä aygägo ndä acaka sanydä ow wung ndä kurumusa anggo kala kadäbäx. ");
INSERT INTO shj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xa nya xongondi wunodung karamedäng känggong kä'day täzägkang. ");
INSERT INTO shj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wadi layesi kängga cuccu cagiying na palecci ndey layang mpädägänyang ndey mäxäsing ngaki kä'day wunosung sagoduningang ndey ndokalang tagang agä, Päxä Käxa Jul.” ");
INSERT INTO shj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Todotol Yasuwa bäldecce tä kaxsä kaldagä axä tämed tä Kaläg ndä ongutang mä'do mäccu tä Cabärä Zayitun. ");
INSERT INTO shj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndä kän kä'day loxto ow wunotäsäno täma tä kaxsä kaldä axä tämed tä Kaläg tä dänggä bäldiccäma. ");
INSERT INTO shj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xongondi Tanyaranä Raxifta Säwacce Song, ani säbangäs Pärkitang, kawung käsac. ");
INSERT INTO shj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na bazuwinygä menggä tämed tä Kaläg na menggä lelericcä asiriyenä Musa nyame rakawza ndey ka paxäs Yasuwa ndä sänyigate kän neng säpaye säpax ma na raj. ");
INSERT INTO shj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na Däniye kadel tä wang nuxu accä känggämagi mägäligä asiny wang pädaxang, ani säbangäs Yaxusa Iskariyuti. ");
INSERT INTO shj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mägä'doc mabodsa na bazuwinygä tämed na ngotorpugi meske axä tämed tä Kalägkang ndey ka mämene Yasuwa täsa. ");
INSERT INTO shj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na wadägkäsa kalaye tidiny sagixi ka sädogada ariyaliny täma. ");
INSERT INTO shj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na kala sägaxsä ngakäsa na ma. Na ma Yaxusa mägä'doc mänyame rakaw ndey mämenenäs Yasuwa täsa tä owda xä'dä wundung täng. ");
INSERT INTO shj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kala xongondi Tanyaranä Raxifta Säwacce Songang kawung ndey ka Säpärkisi na sädämze na päxä dopolog. ");
INSERT INTO shj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na kala Yasuwa kayaxsa Putros na Yoxana, läpede täsa ka, “Wesi ndele Pärkid ndey wunig siysig täng.” ");
INSERT INTO shj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na sängadeccä täma ka, “Owda keyang mpaye anoccig andeleyig tängang?” ");
INSERT INTO shj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na mabuc täsa ka, “Ndänge, känoxang käläsang kaxsä pang 'doxadang apangandäng poko pete päse ma. 'Dorkäda ma tä pani mä'doc mäläsong, ");
INSERT INTO shj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na lapi tä ledä pa ka, ‘Me bäldic kayaxsä was tägi ka wa amänig gi ka axä palangaski mäwunodung Säpärkicci täng na menggä räbkäma na säsiyzang nyandi?’ ");
INSERT INTO shj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mä'do mäläpedäng apanggä axandäng tiyati na ka'dika'dinä kaxse, wesi ndele wexekägo todi.” ");
INSERT INTO shj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na kala sägä'docco sa'doxa sangaki Yasuwa kaläpe täsang, na sägädeley Pärkid täng. ");
INSERT INTO shj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kala sanä Pärkid kawung, Na Yasuwa kä'doc kagur siyad na känggi mägäligäng. ");
INSERT INTO shj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na mängade täsa ka, “Wanang tidi xa kalängädi tä siyakä siyakä Pärkidkong nanggo xa kala sä'docco säcäläxti agä tä bange. ");
INSERT INTO shj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndä aläpedäng tanggo ka agä asiye Pärkid nanggo mändey song basa ngaki Kaläg kayaxsäng agä tängang 'desesäning layis wega tä bugundugku Kaläg.” ");
INSERT INTO shj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na mabag päxä kobox päse malog Kaläg mängade ka, “Mene dugi na'anggägo. ");
INSERT INTO shj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aläpedäng tanggo ka xongondong sanydangang tä wuxikä magä adilu basa bugundugku Kaläg wuno.” ");
INSERT INTO shj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na mändey mabag raxif malog Kaläg ndä mäbeny mädoga täsa mängade ka, “Yanä wanangang kadogung tanggo. Zogada adinong mänang ndey nimidänang agä nang.” ");
INSERT INTO shj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kala sasiyza na mabag päxä kobox, mängade ka, “Päxä koboxsä tamiccanggong coladaswa tanggong, nyang layis axäska warändi tanggo na Kalägkang.” ");
INSERT INTO shj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yasuwa ngade täsa ka, “Lala, käxi 'doc menedes agäng andenenang nagä tä tumunu siyad ganang. ");
INSERT INTO shj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Agä, Päxä Käxa Jul a'docco anäxse kala ngaki Kaläg kabogkasang ndä woyoy ta apangzi menedes agäng!” ");
INSERT INTO shj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na todi sadelese tä mänekä ngastänggäsa ka xänang seley 'docco sogo ngakongang. ");
INSERT INTO shj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na sawaläte ka xänang tä waräsa ngake tädäxiny mo'do acängganang. ");
INSERT INTO shj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na kala Yasuwa ngade täsa ka, “Buguninginy na ngotorpugu känggi näs Yaxudiny songang cäläxti kän ndä dalacca ka apoccu. ");
INSERT INTO shj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ndä anggo kändäppang ka layang ka'das sa song, wadi käxi tä warägo ngake tädäxiny kamo'du acängganang, bokasa ngase täzäg na ngotorpo lay kala me wexed. ");
INSERT INTO shj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Xänang ngake tädäxiny mo'do accanang, käxi käcca bene siyatang, wala käxi wexe siyatang? Wadi käxi käcca bene siyatang kädäppa ka nyaza ngake tädäxinyang. Neng agänang tä warägo ka'das käxi wexecceng. ");
INSERT INTO shj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Anggog tol kändokalang nagä tä läbang. ");
INSERT INTO shj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nenyang agä adogodung butug tanggo ka'das togunakenegi appanang kadogunäs tagäng, ");
INSERT INTO shj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ndey guring siyad tä owdu bugundugkang ndä nycatetäsänang tä komzu bugundug menedeng caxsänggä Israyilinygi asiny wang pädaxang.” ");
INSERT INTO shj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na Yasuwa ngade ta Saman Putros ka, “Saman, Saman, dänge! Däniye käpaydä ka läbä anggo na'anggägo ndä Kaläg kä'daka, ndä Däniye 'do pede anggo kala pedeki me pelow pededenäs nyadanä gärwec täpoxang. ");
INSERT INTO shj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Neng agä kapaleyza tägi Saman, xa ndakä menekä ngakägi tagä 'dexäning. Xongonda kämeley mägaxsäging, pädäti enggä bonggugo.” ");
INSERT INTO shj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Neng Putros ngade täma ka, “Bazuwec, kax ka wi, na agä ano nagi tä ax na tä xäs!” ");
INSERT INTO shj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Yasuwa kämeley täma ka, “Putros dänge, ndey ka tä kesekä ow modolong logo, gi n'do gäli agä taxä kodos ka 'di agä.” ");
INSERT INTO shj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na Yasuwa ngade täsa ka, “Ani kayaxsanäs anggo tä wexed ndä aläpänäs tanggo ka ndakä bagang ariyaliny mange nanggo na meldänä wedäg na 'dataginy axinyga pädaxang, päx nuxu 'dogkandäng kä'disä tanggo?” Sabuc ka, “A'a, päx 'doga kä'disändäng song.” ");
INSERT INTO shj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na mängade täsa ka, “Neng gang käxa tanggo ndarudigä ariyaliny tängang bag na mändey bag meldänä wedäg. Ndä käxa saläne täng songang, nganya tandäne, nganyäs salä. ");
INSERT INTO shj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aläpedäng tanggo ka ngaki menggä logey gärekärejesa tä ngakangang, basa 'desesuno. ‘Ndä kän bangäs agä märing.’ Xa ngaki menggä logey gärekärejesa ka soguno tagäng kala sogoduno.” ");
INSERT INTO shj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na menggä räbkäma ngadeccä täma ka, “Za, Bazuwec, saluwakang todong pädax.” Na Yasuwa läpede täsa ka, “Mangeccä.” ");
INSERT INTO shj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yasuwa kawetä ka'das ani todotolang kä'doc tä Cabärä Zayitun, na menggä räbkäma kabag bangäma. ");
INSERT INTO shj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sägäcogu ow na mäläpede tä menggä räbkäma ka, “Palecci ndey Däniye käläbä anggong degeng.” ");
INSERT INTO shj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na masexte mägä'doc mägädukurusa mäpalacca ka, ");
INSERT INTO shj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Appa, känox gixisang, ampaye gi xony agä tä akäsogu cäläxtigong awededes tängang. Yä näs giza kämpaydäs agäng, wanga soguning na ngakägi xa na ngakang song.” ");
INSERT INTO shj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na malayika käpätäng tiyati käpädäti ma. ");
INSERT INTO shj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tä zänggä paleygämagi mäpalacca na zä'diriy na mapaleydäcca paccey seley dexä modiccäma täläbe täzäg ka'das tamic. ");
INSERT INTO shj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ani mangäsanäs tä paliccang mägämele ta menggä räbkäma ma'doxas sa sapägini tä kuniy de sasändäcco. ");
INSERT INTO shj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na mängade täsa ka, “Oxadi sängadangang? Ngäsosuning! Palezi ndey Däniye käläbä anggong degeng!” ");
INSERT INTO shj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ani musku mälegeccenäs täsang, nuxu me räbkämani säbängäs Yaxusang kaleza koyo xä'dä na kä'doc kawu'dakas Yasuwa käbuciy. ");
INSERT INTO shj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Neng Yasuwa ngade täma ka, “Yaxusa, gi gang menedes agä, Päxä Käxa Jul na bucigong?” ");
INSERT INTO shj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kulung menggä räbkä Yasuwagi nangang kox 'dogi paye sogkuwang, na ngadeccä ka, “Bazuwec, mpaye was wa ampogig nycokong na salugusko?” ");
INSERT INTO shj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na nuxu me räbkäma kajede wundä abaniccä cäläxsä ngotorponu axä tämed tä Kaläg täpox. ");
INSERT INTO shj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Neng Yasuwa ngade ta menggä räbke ka, “Ndokolosi mänang!” Na Yasuwa käläbä wundä cäläx kämele täng na kalay apo. ");
INSERT INTO shj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na Yasuwa ngade ta bazuwinygä axä tämed tä Kaläg na ngotorpugu megäskä axä tämed na ngondowinygä Yaxudinygi kawuno tä menekä mang ka, “Anggo käsagang tagä na salu na gany dexä ka'das ka agä anäs märing? ");
INSERT INTO shj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Agä kanycu nanggo tä kaxsä kaldä axä tämed todotol ndä päx tä nuxung kämeneng agä song. Neng ongudong xongondugong na xongondu butugku lätäg!” ");
INSERT INTO shj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kala samen Yasuwa samagas tagäsa sagoyas tä pang ngotorponu axä tämed tä Kaläg. Yä Putros räbto sa ndä lewa täxandäxang. ");
INSERT INTO shj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kulung kän kadox mas tä pidinä kaxsä kal pagedäning na Putros kä'doc käcca tä waräsa pagewa. ");
INSERT INTO shj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na päxä uxandäng näs me wexed kox ma tä banyiccä mas na kajenggerey ma ngade ka, “Apangzong nyang na Yasuwa seley!” ");
INSERT INTO shj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Neng Putros kagil ngade ka, “Ama kuxong, ayex ma säxong!” ");
INSERT INTO shj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sax mändey tä bälaxtäg, nuxu accäsandäng kox ma na ngade täma ka, “Gining mändey näs nuxu me räbkä Yasuwa.” Neng Putros ngade ka, “Amo, agänang song!” ");
INSERT INTO shj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sägäcudisi mäna'ang na nuxu kig kalewa ka, “Kax ka wi, na 'doxtongang na Yasuwa, xa ma mändey mäs me Calil.” ");
INSERT INTO shj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Neng Putros kämeley täma ka, “Amo, ayex 'dogani legeng song!” Na tänya owdi musku tä zänggä legeygäma, modolong kalog. ");
INSERT INTO shj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na kala Yasuwa Bazuwec kawexeswa kalala Putros käteg na Putros kagäräng ngaki Bazuwec kalogey tämang, ka, “Ndey ka tä kesekä ow modolong logo, gi n'do gäli agä taxä kodos.” ");
INSERT INTO shj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na Putros koya tunyu kangey paccey. ");
INSERT INTO shj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na kala apangaski kamen Yasuwang kadeb ngobku Yasuwa ndä bade. ");
INSERT INTO shj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sägaxsä agäma ndä sämäne ma tetedetex ka, “Logeyzi! Xänang kadä ging?” ");
INSERT INTO shj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na mändey sägäcemdä ma. ");
INSERT INTO shj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ani ow kagezänäsang, bazuwinygä axä tämed tä Kaläg na menggä lelericcä asiriyenä Musa kudurisuno. Apangaski kamen Yasuwang kagoying ma ta ngotorpugä Yaxudiny. ");
INSERT INTO shj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Sängadeccä täma ka, “Känox näs Almasiyang, läpäng täwas.” Neng Yasuwa ngade täsa ka, “Kax aläpäng tanggo, na gixiding song, ");
INSERT INTO shj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ndä kax amän anggo na buciding song. ");
INSERT INTO shj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Neng bäli ka xongondong na tä bange kä'day, agä Päxä Käxa Jul, anoco anycata tä andä abaniccä Kalägi panggudug tängang.” ");
INSERT INTO shj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na kala na'anggäsa sängadeccä täma ka, “Neng giningang näs päxä Kalägkang?” Na mabuc täsa ka, “Axeneng, anggo ngadaccang ka agäng.” ");
INSERT INTO shj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na sängadeccä ka, “Käxa mändey payedig ndey ka mänigkandäng song. Xa kog kädängig na wunggog tä ikäma!” ");
INSERT INTO shj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ngotorpugä Yaxudiny kangusosuno kagoya Yasuwa ta Pälatis. ");
INSERT INTO shj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sagäli täma ka, “Wa kamenig 'doxtong woko kän ka sog pogud na ka wang yawgä tuluba ta Kaysar na mägasada tä ngasäma ka ma mäs Almasi buguning.” ");
INSERT INTO shj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na Pälatis kamän Yasuwa ka, “Giningang näs buguningzä Yaxudinyang?” Na Yasuwa kämeley täma ka, “Axeneng, gi kängad mänang.” ");
INSERT INTO shj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na Pälatis ngade ta bazuwinygä axä tämed tä Kaläg na xä'dä ka, “Ka'dox 'doga tasta de ka giling nga nang tä 'doxtong song.” ");
INSERT INTO shj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Neng saleyning sängadeccä ka, “Ma mäbälde kän mäwoko bägälic tä kaxsä Yaxudiya. Madeb tä Calil ndä mäccogu owdong nang!” ");
INSERT INTO shj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ani Pälatis kädängäs ngakiyang, kamänze ka cong Yasuwa näs me Calilang. ");
INSERT INTO shj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pälatis kabäle ka Yasuwa käpätäng Calil ndä Xirudusang näs bazuweccä Calilang, na mayaxsas Yasuwa ta Xirudus xa nya xongongi Xirudusandäng tä Ursalim. ");
INSERT INTO shj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ani Xirudus koxus Yasuwang wanäma kalay tidi paccey xa mandäng mäbenecce ka mäpaye mox Yasuwa, xa mägädängdä sälege ngakä Yasuwa ndä mäpaye ka mox boliccä were wexeki Yasuwa wexeng. ");
INSERT INTO shj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Xirudus kamändä Yasuwa nano. Neng Yasuwa kabuc täma song. ");
INSERT INTO shj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ndä bazuwinygä axä tämed tä Kaläg na menggä lelericcä asiriyenä Musa satäng tänya owdi dokoloccu, kaleyning kilidi nga täma. ");
INSERT INTO shj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na todi Xirudus na asägarugu megäske kängobtu Yasuwa ndä lagä ma na tandugu butug ndä meles ma ta Pälatis. ");
INSERT INTO shj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na tänya xongondi Xirudus na Pälatis kalayenäs aminu xa kalaygädä säs menggä kur. ");
INSERT INTO shj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pälatis kabandä bazuwinygä axä tämed tä Kaläg na ngotorpugä Yaxudiny na kän, ");
INSERT INTO shj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mäläpede täsa ka, “Anggo goynang 'doxtong tagä ka wanyis kän. Ndä kamändä ma tagägo ndä 'doga ka'dox täma tasandäng näs 'dogi anggo giling täma ka mäsogondäng song. ");
INSERT INTO shj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ndä wala Xirudus ka'dox nuxu 'doga tas täma, nenyang mägämeleyäng ma tägogkang. Za, ma masog 'doga de ka säpaxe ma täng song. ");
INSERT INTO shj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Gang adogadas ma säbade ma na ke'diccä oxay ndä kala a'dakas ma.” ");
INSERT INTO shj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Neng sägädawasa na'anggäsa ka, “Baga 'doxtong paxa! Yä 'daki Parapas täwas!” ");
INSERT INTO shj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapas apangza sägäräki tä axang xa kageley ngase pogo turugsä Rumandi kamen Ursalimang ndä kapaxsa. ");
INSERT INTO shj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pälatis kalegeyze täsa mändey tä ngakä Yasuwa xa mäpaye mä'dakas Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Neng saleyning sädaweccä ka, “Nggadi ma tä kalic, nggadi ma tä kalic!” ");
INSERT INTO shj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pälatis kälasä taxä kodeseneni ngade täsa ka, “Xanya? Oxadi masog tasang? Agä ka'dox 'doga ma masog tas kädäppa ka apax ma täng song. Agänang adogadas ma säbade ma na ke'diccä oxay winy ndä a'dakas ma.” ");
INSERT INTO shj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Neng musku saleyno na daw ka sägadas ma tä kalic. Na mägädänge täsa. ");
INSERT INTO shj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kala Pälatis kagixi 'dogi säpayeng na kä'dakas Yasuwa ka säpax. ");
INSERT INTO shj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na mägä'daka 'doxti säbangäs Parapas sägäräki tä ax xa kageley ngase pogo turug na kapaxsang yä macananga madoga Yasuwa ka säpax xa kän paye mänang. ");
INSERT INTO shj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ani sabokunäs Yasuwa tunyang, sägäpasasa na Samandi näs me Sayrunang. Käpätäng tä xining ka läso Ursalim na sägänagey sägäpoka kalic tä ngase ka 'dorkädä bangä Yasuwa nang. ");
INSERT INTO shj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na kän kawuno mange kabag bangäsa, ndä tä warä sa känggi uxuwatäng kunuccu na ngeccä tä ngakä Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Neng Yasuwa gaw ze läpede täsa ka, “Anggo uxugu Ursalim, wanga ngeyig tä ngakang, wadi ngeyi tä ngakä ngastänggägo na tä enggenggägo. ");
INSERT INTO shj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Xa ngakong ngaletäsäno, seley owda tasandäng wunodung ndä kän 'docco ngadeccä ka, ‘Baxändäg ta pixu na kuxtugi taxä nuxu käpoku pipi songang na ki'digi kä'deyze songang!’ ");
INSERT INTO shj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndä nya owda tasti kawungang, kän 'docco ngadeccä tä cabärta ka, ‘Delesäning tä zänggäsko!’ na tä cobocoboriny ka, ‘Mäxosuning nawas täzäg!’ ");
INSERT INTO shj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gang kän kasog ngakong tä eta musku tuduwinyang, oxadi sogowa tä eta kamasäng?” ");
INSERT INTO shj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kulung märinginyatäng pädax sabokung tunyu ndey ka sä'doc säpax na Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ani sägäcogus owdi säpaxe kän täng säbangäs “owdu zänggä kängga käxseng”, sägä'docco sägadas ma ta kalic na mändey märinginygi sägadas tä käna. Nuxu ta cengiccä abaniccäma na nuxu tä cengiccä nyogoldäma. ");
INSERT INTO shj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Neng Yasuwa ngade ka, “Appa, wangi täsa xa säyex ngakong säsogong song.” Na sa asägarugi gadas Yasuwa tä kaliccang sägä'docco sägäcasäng sawany atapayu ndey sälartäs tandugu Yasuwa. ");
INSERT INTO shj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kän kädokolo lale ma, na mändeng ngotorpugä Yaxudiny kädegejeydä ma ngadeccä täma ka, “Ma maxonydä kän. Wanga ma mäxony ngasäma ka cong mäs Almasinä Kalägkang, ani Kaläg kayaxsäng nuxungang!” ");
INSERT INTO shj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mändey asägaru kängobtä ma ndä 'docco toga buxka kawace täma ka mäwux ");
INSERT INTO shj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ndä ngadeccä täma ka, “Yex ngasägi ka näs buguningzä Yaxudinyang, xonya ngasägi!” ");
INSERT INTO shj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Badaxiccandäng sägärekärejeze täng tä owdu zäma ngade ka, “Buguningzä Yaxudinyanang.” ");
INSERT INTO shj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nuxung märingzi sägadasa tä cengiccämang kalegeyze täma näs langad ngade ka, “Gi näs Almasi song? Ata xony ngasägi na xony was!” ");
INSERT INTO shj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Neng märingzi nuxungang kadux nya accanani ngade ka, “Gi nyigate Kaläg song? Noxo kogkakang na'anggog tä zänggä xäs. ");
INSERT INTO shj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tä ngakog tireneng xa kog käsogig ngaka siye kog, yä 'doxtong kasog nuxung 'doga tas song.” ");
INSERT INTO shj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na mawetäde na legey mängade ka, “Yasuwa, känox känoc tä butugkuging wanga agägi wayesäng tagä.” ");
INSERT INTO shj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Yasuwa ngade täma ka, “Aläpedäng zänggä nga tägi, xongondong agänang nagi 'doccig tä Pang Kaläg tiyati.” ");
INSERT INTO shj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ani xong kawunäs tä piding, ow kälämaswa täng bägälic kasog sada kodos, ");
INSERT INTO shj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","xa xong kadärändä. Na tandänä akäsogaldä axä tämed tä Kaläg kacereswa tä pidi kälaräswa pädax. ");
INSERT INTO shj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na kala Yasuwa, kabandäsa paccey ka, “Appa, agä ka'daka ligidang tä andägi kala!” Ani mangadäs ngakiyang na mägänungis sanydä nunggäma. ");
INSERT INTO shj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ngotorponu asägarugu Roman kox 'dogi kasogkuwang, na kädädäxti Kaläg ngade ka, “Pezängga 'doxtong käxa lelexang!” ");
INSERT INTO shj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na kala xä'däni dokoloccu kox 'dogi kasogkuwang, kämele tä pa na zängay. ");
INSERT INTO shj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na känggi kä'day yex Yasuwang kädokolo täxande na uxugi käräbkädä bangä Yasuwa cawu Calilang kox 'dogi kasogkuwang. ");
INSERT INTO shj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Apangandäng säbangäs Yusif nuxung ngotorponu Yaxudinyang, ndä käxa lelexang. ");
INSERT INTO shj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ndä ma mäpaye 'dogi nycoki kawex ta Yasuwang song. Ma mäs me bo pana säbangäs Armataya tä cabärä Yaxudiya ndä mäbene bugundugku Kaläg. ");
INSERT INTO shj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusif kä'doc ta Pälatis ka toga wanä Yasuwa täma. ");
INSERT INTO shj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na Pälatis kagixi kadogas ma ka mä'doc mäcoccoley wanä Yasuwa. Na kala mamulungi na darnase mägä'doc mägälola taxä morogsa sadotogey tä ngayic ndä kax taxä nuxung sabosu kig täng song. ");
INSERT INTO shj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndä nya xongondeneni xongondu deleygä wexetang xa xongondu Sapid ngäte. ");
INSERT INTO shj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Uxugi kabag bangä Yasuwa cawu Calilang, kä'docco tä bangä Yusif käsay morog na bokosänaki sabokasanäs wanä Yasuwang. ");
INSERT INTO shj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na sägämele tä pa sägä'docco sägädeley may na midä mäxäs. Na sägänunducco tä xongondu Sapid xa asiriye Musa kangad mänang. ");
INSERT INTO shj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Xongondi tä bangä xongondu Sapitang, tä kesekä ow uxuwatäng kä'docco tä copku morog koyo mäxäsi sägädeleyang. ");
INSERT INTO shj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sägä'docco sa'doxa kädandafi gärenggärengeswa tä cengic, ");
INSERT INTO shj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ani sägä'docconäs saläsäs axä morogkang, sa'doxa wanä Bazuwec Yasuwa wundung taxä morog. ");
INSERT INTO shj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na sägädongasa sägäre ngakä 'dogi kasogkuwang, na tetex apanginy pädax kawayesäno kälagä tanduga dulatulajeccä kädokolo tä wadäkäsa. ");
INSERT INTO shj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na nyigatäg kadeles sa uxugi de kädukurusuno täzäg neng sa apanginygi pädaxang ngadeccä täsa ka, “Oxadi siye anggo nyamadang käxa oxacca tä warä kängga käxseng? ");
INSERT INTO shj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mandäng todong song, mabägäng tä xäs! Nimäning ngaki maläpäng tanggo tä cukuma tä Calilang, ");
INSERT INTO shj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","aki ka Päxä Käxa Jul basa sä'docco sämenes tä asänggä kängga tasiny ndey gadas ma tä kalic, na tä sängädi sogo kodoseneng, mängäsata tä xäs.” ");
INSERT INTO shj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na sa uxugi sagäräng legeygi Yasuwa kalegey täsang, ");
INSERT INTO shj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","na sägämele na morog sägä'docco saläpe ngaki kä'day kasogunong ta känggi Yasuwa käligä asiny wang nuxungang na tä kulung känggi tängang. ");
INSERT INTO shj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sa uxugi kox ngakiyang Mariyom Macidalinang na Xana na Mariyom bo Yaxupag na kulung uxugi nasang sag kaläpe ngaki tä känggi Yasuwa käligäng. ");
INSERT INTO shj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Neng ngaki uxugi käcopu morog kaläpe täsang samen song xa sälaleyis degejey winy. ");
INSERT INTO shj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na Putros kangäsa koy kä'doc kälim morog ka'doxa darnaseni samulungis Yasuwang winy. Na mägämel tä pa mägäbabangwa tä ngaki kasogunong. ");
INSERT INTO shj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tänya xongondi menggä räbkä Yasuwagi pädaxang wedetese tä päxä cabära säbangäs Imawus, ndä kä'dalangaswa bate sada pädax na Ursalim. ");
INSERT INTO shj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ndä sälege ngakä wegki kä'day kasoguning ta Yasuwang. ");
INSERT INTO shj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na tä zänggä legeygäsagi, Yasuwa kacubugiswa täsa wedeccä nasa ");
INSERT INTO shj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","neng agäsa kamägäning sabäles ma song. ");
INSERT INTO shj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na Yasuwa kangada täsa ka, “Legeygatiyakang legedeng ndä wedetesengang?” Na käkäräb sägädokalasa sägänyonyey agäsa. ");
INSERT INTO shj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na nuxung accäsani age ka Kiloppasang kabuc täma ka, “Giningang watäkägi näs palangasic tä Ursalim tä enggä sänggongang dexä 'di ngaki kasogunong?” ");
INSERT INTO shj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na mängade täsa ka, “Ngaka keyag?” Na sabuc täma ka, “ 'Dogi kasogkuwa ta Yasuwa me Nasrang. 'Doxteneni Kaläg kadoga panggudug täng na wexed na legey kasog kabälesäwa ka me logeygä Kalägkang kayaxsäng tä kän kä'day, ");
INSERT INTO shj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ndä bazuwinygä axä tämed tä Kaläg na ngotorpugusko kamenes ma sägadas ma tä kalic ndä säpax ma. ");
INSERT INTO shj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yä was wakabokosunig ka mang mäs Almasini kawung ndey ka xony Israyilang. Ndä ganang seley ngakong kala satäng säng pädax ndä kodosenenang. ");
INSERT INTO shj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ndä mändey kulung uxugi tä waräskong kabal mäganygusko ow tudizong xa saloxtu ow sägä'docco tä morog. ");
INSERT INTO shj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sägä'docco sa'doxa ngaccä wanäma song na sawuno saläpäng täwas ka sägox malayikada läpede täsa ka moxacca. ");
INSERT INTO shj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndä kulung känggi nawasang kä'docco tä morog ka'doxa sangaki saläpäng täwasang kalayenäs wega ndä sägox ma song.” ");
INSERT INTO shj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na Yasuwa ngade täsa ka, “Ama kängga kamanande, oxadi mäganygägo päpäxiny tä menekä ngakä menggä logeygi kalegeyze tanggong! ");
INSERT INTO shj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anggo käbäleng ka basa Almasi cäläxtiwa ndey sädädäxti song?” ");
INSERT INTO shj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na madeb geneygä ngakä me logey Musa na menggä logeygi kä'dayang, mägene kä'day ngaki gärekärejesäno tä ngakä ngasäma tä kaxsä Sorunu Kalägkang. ");
INSERT INTO shj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ani sawunonäs käsac tä wang päxä cabärang, Yasuwa kasoguswa käxa paye warä päxä cabär, ");
INSERT INTO shj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","neng sapappaledä ma ka mä'doc mälay nasa xa ow kamo'dsa. Na kala mägä'doc nasa. ");
INSERT INTO shj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ani magurus siyad nasang, mabag raxif, malog Kaläg ndä mäbeny, ndä mälarta täsa. ");
INSERT INTO shj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na todi agäsa kalengesäning, na sajenggerey ma sabäles ma. Na käkäräb mägä'duywa täsa. ");
INSERT INTO shj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na sängadeccä tä ngastänggäsa ka, “Yä päx mäganygog kalaye tidiny tä ngaki kä'dang mägene tägog tä akäsog näs käkä Sorunu Kalägkang song?” ");
INSERT INTO shj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na tänya owdi sägämelese tä Ursalim. Sägä'docco sa'doxas känggämagi mägäligä asiny wang nuxungang na kulung känggi todiyang kudurisuno ");
INSERT INTO shj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na sa känggi sa'doxa kädurisunong läpede täsa ka, “Nästire Bazuwec kangäsa tä xäs, de maparaswa ta Saman Putros!” ");
INSERT INTO shj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na sagi pädaxang mändey sadedebeyde ngaki kasoguno täsa tä akäsogkang, na benyeki mabenyis raxif de sabälenäs mang. ");
INSERT INTO shj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ani menggä räbkä Yasuwa legeyis ngakämang, ma Yasuwa täzäma magayasawa tä waräsa mängade täsa ka, “Amodo anggo.” ");
INSERT INTO shj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Neng sägox ma na mäganygäsa kabal sa na nyigatäg kamen sa soxo ka sägox arälodic. ");
INSERT INTO shj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na mängade täsa ka, “Oxadi siye anggo nyägadänyang na basadang mäganygägong? ");
INSERT INTO shj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lala asänggang na badagä exenggang, agänangang! Läbe wanang na lala, arälodic yandäng tä wane na ngay song yä lalang agä gang anggo noxadang ngayakang tä wanang na ya.” ");
INSERT INTO shj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ani malegeyis legeygongang, madoga badadagä exenggäma na asänggäma ka säzay. ");
INSERT INTO shj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndä musku säcukuludäning samen ngaki mangatang song xa wadäkäsa tidiny tä oxakäma de sägädongo. Na mamän sa ka, “ 'Doga siyewa tanggo todongandäng päx?” ");
INSERT INTO shj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na tetex sabag axsicca käbux sadoga täma ");
INSERT INTO shj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","na mabag masiy tagäsa tänya owdi. ");
INSERT INTO shj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na mängade tä menggä räbke ka, “Ngakanggongag kaläpäng tanggo ani musku cuccusig nanggong, ka ngaki kä'day gärekärejesäno tä ngakang tä asiriyenä Musa na tä sorunu menggä logey na tä Sorunu Masmurang ka bal päsesäwa.” ");
INSERT INTO shj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na malenge zänggäsa ndey ka säbäle ngakä Sorunu Kaläg, ");
INSERT INTO shj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ndä mängade täsa ka, “Sägädokoley gärekärejey tä Sorunu Kaläg ka Almasi bal cäläxtiwa ndä äxsä ndä ngäsa tä xäs tä sängädi kodosang. ");
INSERT INTO shj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sädebe duwaleygä agä Almasi tä Ursalim na tä cabärta kä'day. Säduwale nga tä kän ka xajkä mäganyga tä ngaka tasiny ndey Kaläg wanga ngaka tasiny täng. ");
INSERT INTO shj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ndä anggo käzayang ngakong nagägo seley ndey läpeng tä kulung kän. ");
INSERT INTO shj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ndä gang lala, agä ayaxsedäng 'dogi Appanang kangad ngakeneng. Neng nycicci tä Ursalim basa Kaläg yaxsäng panggudug tanggo.” ");
INSERT INTO shj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na Yasuwa kabag menggä räbke kä'docco nang tä owda säbängäs Petani, na mayuxi asänggäma tiyati mapes sa. ");
INSERT INTO shj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ani mäpesecenäsang, Kaläg kabag ma tä pane tiyati. ");
INSERT INTO shj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na kala sägädukurusuno sägädädäxti ma. Na kala sägämelese tä Ursalim na led, ");
INSERT INTO shj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","na todotol sädädäxti Kaläg tä axä tämed tä Kaläg.");
ALTER TABLE shj_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
